
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  944),  selected  126 , name 2cwq_A
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 2cwq_A.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -9_A      -       -           -
LGA    G    -8_A      -       -           -
LGA    L    -7_A      -       -           -
LGA    V    -6_A      -       -           -
LGA    P    -5_A      -       -           -
LGA    R    -4_A      -       -           -
LGA    G    -3_A      -       -           -
LGA    S    -2_A      -       -           -
LGA    H    -1_A      -       -           -
LGA    X     1_A      -       -           -
LGA    D     2_A      -       -           -
LGA    R     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    H     5_A      -       -           -
LGA    E     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    V     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    A    11_A      -       -           -
LGA    X    12_A      F       7          3.203
LGA    A    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    N    15_A      -       -           -
LGA    L    16_A      -       -           -
LGA    G    17_A      -       -           -
LGA    E    18_A      -       -           -
LGA    G    19_A      -       -           -
LGA    L    20_A      -       -           -
LGA    P    21_A      G       8          3.134
LGA    R    22_A      E       9          2.422
LGA    A    23_A      G      10          1.070
LGA    I    24_A      M      11          1.183
LGA    P    25_A      K      12          1.263
LGA    L    26_A      V      13          0.704
LGA    L    27_A      V      14          0.622
LGA    A    28_A      K      15          1.062
LGA    E    29_A      E      16          0.754
LGA    K    30_A      K      17          0.562
LGA    A    31_A      Y      18          1.065
LGA    P    32_A      P      19          1.524
LGA    G    33_A      D      20          1.445
LGA    L    34_A      L      21          1.545
LGA    L    35_A      Y      22          1.317
LGA    L    36_A      D      23          1.127
LGA    E    37_A      I      24          1.442
LGA    H    38_A      I      25          1.135
LGA    G    39_A      V      26          0.977
LGA    R    40_A      K      27          1.374
LGA    S    41_A      L      28          1.228
LGA    W    42_A      N      29          1.227
LGA    T    43_A      D      30          2.167
LGA    Y    44_A      T      31          2.471
LGA    A    45_A      V      32          1.797
LGA    X    46_A      F      33          1.989
LGA    P    47_A      T      34          1.492
LGA    E    48_A      -       -           -
LGA    K    49_A      G      35          5.723
LGA    G    50_A      K      36          2.938
LGA    A    51_A      T      37          1.768
LGA    L    52_A      L      38          0.971
LGA    D    53_A      D      39          1.085
LGA    E    54_A      Y      40          1.645
LGA    K    55_A      K      41          1.473
LGA    T    56_A      T      42          0.754
LGA    R    57_A      Q      43          0.735
LGA    T    58_A      K      44          0.803
LGA    L    59_A      L      45          0.762
LGA    I    60_A      I      46          0.425
LGA    L    61_A      A      47          0.353
LGA    L    62_A      I      48          0.413
LGA    G    63_A      G      49          0.564
LGA    I    64_A      I      50          0.468
LGA    A    65_A      V      51          0.444
LGA    L    66_A      A      52          0.763
LGA    A    67_A      S      53          0.511
LGA    T    68_A      R      54          1.707
LGA    G    69_A      C      55          1.844
LGA    S    70_A      D      56          2.740
LGA    E    71_A      E      57          3.113
LGA    A    72_A      V      58          3.872
LGA    C    73_A      A      59          2.709
LGA    V    74_A      I      60          1.263
LGA    K    75_A      E      61          2.310
LGA    A    76_A      K      62          2.260
LGA    X    77_A      Q      63          1.281
LGA    A    78_A      M      64          0.741
LGA    H    79_A      K      65          1.429
LGA    R    80_A      S      66          1.713
LGA    A    81_A      A      67          1.476
LGA    K    82_A      M      68          1.040
LGA    R    83_A      K      69          1.355
LGA    L    84_A      E      70          3.717
LGA    -       -      L      71           -
LGA    G    85_A      G      72          1.087
LGA    L    86_A      I      73          1.062
LGA    S    87_A      T      74          1.910
LGA    K    88_A      K      75          2.003
LGA    E    89_A      E      76          1.308
LGA    A    90_A      E      77          0.787
LGA    L    91_A      I      78          0.741
LGA    L    92_A      A      79          0.844
LGA    E    93_A      D      80          1.118
LGA    T    94_A      V      81          0.872
LGA    L    95_A      L      82          1.562
LGA    K    96_A      R      83          2.089
LGA    I    97_A      V      84          1.398
LGA    A    98_A      V      85          1.080
LGA    R    99_A      L      86          2.093
LGA    Q   100_A      L      87          1.749
LGA    A   101_A      T      88          0.864
LGA    Q   102_A      S      89          0.648
LGA    A   103_A      G      90          2.873
LGA    N   104_A      M      91           -
LGA    A   105_A      P      92           -
LGA    V   106_A      A      93           -
LGA    L   107_A      F      94           -
LGA    G   108_A      T      95           -
LGA    H   109_A      K      96           -
LGA    A   110_A      A      97           -
LGA    A   111_A      M      98           -
LGA    P   112_A      K      99           -
LGA    L   113_A      I     100           -
LGA    L   114_A      L     101           -
LGA    E   115_A      E     102           -
LGA    V   116_A      K     103           -
LGA    L   117_A      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126   98    5.0     83    1.75    21.69     77.050     4.475

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.526914 * X  +   0.221342 * Y  +  -0.820591 * Z  + -29.492027
  Y_new =   0.515601 * X  +  -0.850785 * Y  +   0.101589 * Z  +  91.437370
  Z_new =  -0.675661 * X  +  -0.476626 * Y  +  -0.562415 * Z  +  77.781715 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.438573    0.703020  [ DEG:  -139.7199     40.2801 ]
  Theta =   0.741861    2.399732  [ DEG:    42.5055    137.4945 ]
  Phi   =   0.774547   -2.367046  [ DEG:    44.3783   -135.6217 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cwq_A                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cwq_A.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126   98   5.0   83   1.75   21.69  77.050
REMARK  ---------------------------------------------------------- 
MOLECULE 2cwq_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   23-JUN-05   2CWQ              
TITLE     CRYSTAL STRUCTURE OF CONSERVED PROTEIN TTHA0727 FROM                  
TITLE    2 THERMUS THERMOPHILUS HB8                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TTHA0727;                             
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 GENE: TTHA0727;                                                      
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PHCEH                                     
KEYWDS    CONSERVED HYPOTHETICAL PROTEIN, ALL ALPHA, STRUCTURAL                 
KEYWDS   2 GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL             
KEYWDS   3 AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                            
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.ITO,R.ARAI,E.FUSATOMI,T.KAMO-UCHIKUBO,S.KAWAGUCHI,                  
AUTHOR   2 T.TERADA,M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-JUL-06 2CWQ    1       JRNL                                     
REVDAT   1   23-DEC-05 2CWQ    0                                                
JRNL        AUTH   K.ITO,R.ARAI,E.FUSATOMI,T.KAMO-UCHIKUBO,                     
JRNL        AUTH 2 S.KAWAGUCHI,R.AKASAKA,T.TERADA,S.KURAMITSU,                  
JRNL        AUTH 3 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   CRYSTAL STRUCTURE OF THE CONSERVED PROTEIN                   
JRNL        TITL 2 TTHA0727 FROM THERMUS THERMOPHILUS HB8 AT 1.9 A              
JRNL        TITL 3 RESOLUTION: A CMD FAMILY MEMBER DISTINCT FROM                
JRNL        TITL 4 CARBOXYMUCONOLACTONE DECARBOXYLASE (CMD) AND AHPD            
JRNL        REF    PROTEIN SCI.                  V.  15  1187 2006              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2CWQ A    1   117  UNP    Q5SMF5   Q5SMF5_THET8     1    117             
DBREF  2CWQ B    1   117  UNP    Q5SMF5   Q5SMF5_THET8     1    117             
DBREF  2CWQ C    1   117  UNP    Q5SMF5   Q5SMF5_THET8     1    117             
SEQRES   1 A  137  MSE GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  137  LEU VAL PRO ARG GLY SER HIS MSE ASP ARG THR HIS GLU          
SEQRES   3 A  137  ARG VAL LEU GLN ALA MSE ALA GLU ASN LEU GLY GLU GLY          
SEQRES   4 A  137  LEU PRO ARG ALA ILE PRO LEU LEU ALA GLU LYS ALA PRO          
SEQRES   5 A  137  GLY LEU LEU LEU GLU HIS GLY ARG SER TRP THR TYR ALA          
SEQRES   6 A  137  MSE PRO GLU LYS GLY ALA LEU ASP GLU LYS THR ARG THR          
SEQRES   7 A  137  LEU ILE LEU LEU GLY ILE ALA LEU ALA THR GLY SER GLU          
SEQRES   8 A  137  ALA CYS VAL LYS ALA MSE ALA HIS ARG ALA LYS ARG LEU          
SEQRES   9 A  137  GLY LEU SER LYS GLU ALA LEU LEU GLU THR LEU LYS ILE          
SEQRES  10 A  137  ALA ARG GLN ALA GLN ALA ASN ALA VAL LEU GLY HIS ALA          
SEQRES  11 A  137  ALA PRO LEU LEU GLU VAL LEU                                  
SEQRES   1 B  137  MSE GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  137  LEU VAL PRO ARG GLY SER HIS MSE ASP ARG THR HIS GLU          
SEQRES   3 B  137  ARG VAL LEU GLN ALA MSE ALA GLU ASN LEU GLY GLU GLY          
SEQRES   4 B  137  LEU PRO ARG ALA ILE PRO LEU LEU ALA GLU LYS ALA PRO          
SEQRES   5 B  137  GLY LEU LEU LEU GLU HIS GLY ARG SER TRP THR TYR ALA          
SEQRES   6 B  137  MSE PRO GLU LYS GLY ALA LEU ASP GLU LYS THR ARG THR          
SEQRES   7 B  137  LEU ILE LEU LEU GLY ILE ALA LEU ALA THR GLY SER GLU          
SEQRES   8 B  137  ALA CYS VAL LYS ALA MSE ALA HIS ARG ALA LYS ARG LEU          
SEQRES   9 B  137  GLY LEU SER LYS GLU ALA LEU LEU GLU THR LEU LYS ILE          
SEQRES  10 B  137  ALA ARG GLN ALA GLN ALA ASN ALA VAL LEU GLY HIS ALA          
SEQRES  11 B  137  ALA PRO LEU LEU GLU VAL LEU                                  
SEQRES   1 C  137  MSE GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  137  LEU VAL PRO ARG GLY SER HIS MSE ASP ARG THR HIS GLU          
SEQRES   3 C  137  ARG VAL LEU GLN ALA MSE ALA GLU ASN LEU GLY GLU GLY          
SEQRES   4 C  137  LEU PRO ARG ALA ILE PRO LEU LEU ALA GLU LYS ALA PRO          
SEQRES   5 C  137  GLY LEU LEU LEU GLU HIS GLY ARG SER TRP THR TYR ALA          
SEQRES   6 C  137  MSE PRO GLU LYS GLY ALA LEU ASP GLU LYS THR ARG THR          
SEQRES   7 C  137  LEU ILE LEU LEU GLY ILE ALA LEU ALA THR GLY SER GLU          
SEQRES   8 C  137  ALA CYS VAL LYS ALA MSE ALA HIS ARG ALA LYS ARG LEU          
SEQRES   9 C  137  GLY LEU SER LYS GLU ALA LEU LEU GLU THR LEU LYS ILE          
SEQRES  10 C  137  ALA ARG GLN ALA GLN ALA ASN ALA VAL LEU GLY HIS ALA          
SEQRES  11 C  137  ALA PRO LEU LEU GLU VAL LEU                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  12       8                                                       
HET    MSE  A  46       8                                                       
HET    MSE  A  77       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  12       8                                                       
HET    MSE  B  46       8                                                       
HET    MSE  B  77       8                                                       
HET    MSE  C  12       8                                                       
HET    MSE  C  46       8                                                       
HET    MSE  C  77       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   4  HOH   *262(H2 O)                                                    
CRYST1  107.102  107.102   55.455  90.00  90.00 120.00 P 31 2 1     18          
ATOM      1  N   SER A  -9      -1.892  85.752  46.627  1.00 48.88           N  
ATOM      2  CA  SER A  -9      -1.685  84.322  46.998  1.00 47.78           C  
ATOM      3  C   SER A  -9      -1.347  83.455  45.776  1.00 43.68           C  
ATOM      4  O   SER A  -9      -0.999  82.266  45.913  1.00 35.94           O  
ATOM      5  CB  SER A  -9      -2.935  83.786  47.700  1.00 49.36           C  
ATOM      6  OG  SER A  -9      -4.106  84.387  47.173  1.00 51.71           O  
ATOM      7  N   GLY A  -8      -1.438  84.064  44.595  1.00 37.46           N  
ATOM      8  CA  GLY A  -8      -1.137  83.363  43.358  1.00 36.44           C  
ATOM      9  C   GLY A  -8       0.338  83.012  43.236  1.00 39.07           C  
ATOM     10  O   GLY A  -8       1.165  83.501  44.022  1.00 34.72           O  
ATOM     11  N   LEU A  -7       0.671  82.172  42.252  1.00 31.02           N  
ATOM     12  CA  LEU A  -7       2.052  81.749  42.036  1.00 26.85           C  
ATOM     13  C   LEU A  -7       2.931  82.927  41.649  1.00 31.76           C  
ATOM     14  O   LEU A  -7       4.115  82.957  41.994  1.00 28.41           O  
ATOM     15  CB  LEU A  -7       2.149  80.679  40.940  1.00 32.08           C  
ATOM     16  CG  LEU A  -7       3.553  80.075  40.867  1.00 30.37           C  
ATOM     17  CD1 LEU A  -7       3.760  79.193  42.090  1.00 35.41           C  
ATOM     18  CD2 LEU A  -7       3.741  79.273  39.589  1.00 33.89           C  
ATOM     19  N   VAL A  -6       2.358  83.865  40.892  1.00 29.28           N  
ATOM     20  CA  VAL A  -6       3.066  85.079  40.477  1.00 35.87           C  
ATOM     21  C   VAL A  -6       2.203  86.269  40.878  1.00 36.09           C  
ATOM     22  O   VAL A  -6       0.981  86.164  40.914  1.00 31.20           O  
ATOM     23  CB  VAL A  -6       3.325  85.120  38.966  1.00 38.74           C  
ATOM     24  CG1 VAL A  -6       4.355  84.053  38.603  1.00 40.94           C  
ATOM     25  CG2 VAL A  -6       2.025  84.928  38.201  1.00 36.04           C  
ATOM     26  N   PRO A  -5       2.832  87.417  41.178  1.00 38.93           N  
ATOM     27  CA  PRO A  -5       2.156  88.652  41.598  1.00 43.84           C  
ATOM     28  C   PRO A  -5       1.170  89.262  40.604  1.00 43.60           C  
ATOM     29  O   PRO A  -5       1.235  88.994  39.404  1.00 37.72           O  
ATOM     30  CB  PRO A  -5       3.318  89.609  41.886  1.00 45.32           C  
ATOM     31  CG  PRO A  -5       4.513  88.693  42.077  1.00 49.90           C  
ATOM     32  CD  PRO A  -5       4.281  87.642  41.047  1.00 43.54           C  
ATOM     33  N   ARG A  -4       0.273  90.100  41.131  1.00 46.90           N  
ATOM     34  CA  ARG A  -4      -0.731  90.793  40.325  1.00 49.61           C  
ATOM     35  C   ARG A  -4      -0.035  91.458  39.144  1.00 41.76           C  
ATOM     36  O   ARG A  -4       0.950  92.167  39.337  1.00 49.57           O  
ATOM     37  CB  ARG A  -4      -1.419  91.907  41.131  1.00 51.18           C  
ATOM     38  CG  ARG A  -4      -2.212  91.504  42.368  1.00 57.02           C  
ATOM     39  CD  ARG A  -4      -2.813  92.772  43.005  1.00 60.50           C  
ATOM     40  NE  ARG A  -4      -3.676  92.522  44.161  1.00 64.08           N  
ATOM     41  CZ  ARG A  -4      -3.253  92.073  45.343  1.00 64.53           C  
ATOM     42  NH1 ARG A  -4      -1.967  91.812  45.543  1.00 65.44           N  
ATOM     43  NH2 ARG A  -4      -4.120  91.894  46.333  1.00 64.94           N  
ATOM     44  N   GLY A  -3      -0.547  91.234  37.936  1.00 41.72           N  
ATOM     45  CA  GLY A  -3       0.021  91.853  36.742  1.00 35.82           C  
ATOM     46  C   GLY A  -3       1.514  91.738  36.467  1.00 35.63           C  
ATOM     47  O   GLY A  -3       2.065  92.511  35.666  1.00 32.72           O  
ATOM     48  N   SER A  -2       2.181  90.775  37.099  1.00 30.55           N  
ATOM     49  CA  SER A  -2       3.612  90.612  36.887  1.00 31.58           C  
ATOM     50  C   SER A  -2       3.950  90.240  35.449  1.00 31.30           C  
ATOM     51  O   SER A  -2       5.018  90.592  34.962  1.00 24.64           O  
ATOM     52  CB  SER A  -2       4.193  89.580  37.872  1.00 39.78           C  
ATOM     53  OG  SER A  -2       3.402  88.408  37.958  1.00 35.75           O  
ATOM     54  N   HIS A  -1       3.043  89.562  34.745  1.00 27.55           N  
ATOM     55  CA  HIS A  -1       3.345  89.192  33.364  1.00 32.27           C  
ATOM     56  C   HIS A  -1       3.312  90.408  32.444  1.00 34.09           C  
ATOM     57  O   HIS A  -1       3.691  90.311  31.271  1.00 33.09           O  
ATOM     58  CB  HIS A  -1       2.365  88.140  32.833  1.00 29.18           C  
ATOM     59  CG  HIS A  -1       0.943  88.618  32.765  1.00 29.14           C  
ATOM     60  ND1 HIS A  -1       0.107  88.633  33.863  1.00 29.88           N  
ATOM     61  CD2 HIS A  -1       0.208  89.088  31.729  1.00 25.97           C  
ATOM     62  CE1 HIS A  -1      -1.083  89.085  33.503  1.00 34.43           C  
ATOM     63  NE2 HIS A  -1      -1.049  89.368  32.212  1.00 28.74           N  
HETATM   64  N   MSE A   1       2.857  91.546  32.964  1.00 28.38           N  
HETATM   65  CA  MSE A   1       2.795  92.767  32.163  1.00 30.12           C  
HETATM   66  C   MSE A   1       4.062  93.612  32.311  1.00 33.25           C  
HETATM   67  O   MSE A   1       4.212  94.632  31.623  1.00 29.44           O  
HETATM   68  CB  MSE A   1       1.589  93.613  32.582  1.00 33.39           C  
HETATM   69  CG  MSE A   1       0.254  92.916  32.454  1.00 35.90           C  
HETATM   70 SE   MSE A   1      -0.211  92.524  30.616  1.00 36.79          SE  
HETATM   71  CE  MSE A   1      -0.392  94.370  29.984  1.00 26.79           C  
ATOM     72  N   ASP A   2       4.963  93.188  33.205  1.00 33.63           N  
ATOM     73  CA  ASP A   2       6.216  93.908  33.472  1.00 34.71           C  
ATOM     74  C   ASP A   2       7.100  94.037  32.240  1.00 32.89           C  
ATOM     75  O   ASP A   2       6.956  93.286  31.284  1.00 24.71           O  
ATOM     76  CB  ASP A   2       7.027  93.195  34.555  1.00 32.45           C  
ATOM     77  CG  ASP A   2       6.453  93.378  35.948  1.00 37.57           C  
ATOM     78  OD1 ASP A   2       5.296  93.822  36.086  1.00 35.08           O  
ATOM     79  OD2 ASP A   2       7.174  93.056  36.915  1.00 44.36           O  
ATOM     80  N   ARG A   3       8.039  94.976  32.287  1.00 29.24           N  
ATOM     81  CA  ARG A   3       8.956  95.181  31.178  1.00 36.37           C  
ATOM     82  C   ARG A   3      10.288  94.410  31.309  1.00 39.97           C  
ATOM     83  O   ARG A   3      11.238  94.636  30.544  1.00 35.92           O  
ATOM     84  CB  ARG A   3       9.185  96.675  30.989  1.00 42.37           C  
ATOM     85  CG  ARG A   3       7.893  97.439  30.703  1.00 46.73           C  
ATOM     86  CD  ARG A   3       7.196  96.882  29.455  1.00 53.41           C  
ATOM     87  NE  ARG A   3       5.890  97.492  29.201  1.00 55.27           N  
ATOM     88  CZ  ARG A   3       5.178  97.287  28.095  1.00 62.01           C  
ATOM     89  NH1 ARG A   3       5.648  96.490  27.141  1.00 64.53           N  
ATOM     90  NH2 ARG A   3       4.001  97.879  27.935  1.00 58.00           N  
ATOM     91  N   THR A   4      10.343  93.520  32.304  1.00 37.31           N  
ATOM     92  CA  THR A   4      11.470  92.610  32.521  1.00 34.17           C  
ATOM     93  C   THR A   4      10.799  91.352  33.049  1.00 32.42           C  
ATOM     94  O   THR A   4       9.677  91.407  33.551  1.00 34.65           O  
ATOM     95  CB  THR A   4      12.495  93.079  33.592  1.00 43.04           C  
ATOM     96  OG1 THR A   4      11.949  92.884  34.907  1.00 35.23           O  
ATOM     97  CG2 THR A   4      12.879  94.538  33.375  1.00 40.69           C  
ATOM     98  N   HIS A   5      11.487  90.226  32.936  1.00 35.12           N  
ATOM     99  CA  HIS A   5      10.978  88.936  33.390  1.00 29.83           C  
ATOM    100  C   HIS A   5      11.207  88.732  34.890  1.00 33.31           C  
ATOM    101  O   HIS A   5      10.696  87.782  35.473  1.00 25.49           O  
ATOM    102  CB  HIS A   5      11.728  87.830  32.662  1.00 26.59           C  
ATOM    103  CG  HIS A   5      13.187  87.811  32.989  1.00 20.12           C  
ATOM    104  ND1 HIS A   5      14.100  88.630  32.365  1.00 32.16           N  
ATOM    105  CD2 HIS A   5      13.870  87.150  33.953  1.00 27.24           C  
ATOM    106  CE1 HIS A   5      15.285  88.477  32.931  1.00 36.81           C  
ATOM    107  NE2 HIS A   5      15.171  87.585  33.899  1.00 29.47           N  
ATOM    108  N   GLU A   6      11.969  89.629  35.512  1.00 38.61           N  
ATOM    109  CA  GLU A   6      12.332  89.505  36.929  1.00 32.45           C  
ATOM    110  C   GLU A   6      11.244  89.242  37.980  1.00 32.84           C  
ATOM    111  O   GLU A   6      11.415  88.394  38.854  1.00 27.44           O  
ATOM    112  CB  GLU A   6      13.190  90.724  37.332  1.00 40.29           C  
ATOM    113  CG  GLU A   6      14.506  90.812  36.542  1.00 45.13           C  
ATOM    114  CD  GLU A   6      15.289  92.109  36.757  1.00 57.17           C  
ATOM    115  OE1 GLU A   6      14.735  93.209  36.526  1.00 61.17           O  
ATOM    116  OE2 GLU A   6      16.476  92.030  37.145  1.00 61.58           O  
ATOM    117  N   ARG A   7      10.124  89.944  37.921  1.00 31.24           N  
ATOM    118  CA  ARG A   7       9.086  89.705  38.935  1.00 35.79           C  
ATOM    119  C   ARG A   7       8.544  88.286  38.844  1.00 32.58           C  
ATOM    120  O   ARG A   7       8.381  87.598  39.852  1.00 24.57           O  
ATOM    121  CB  ARG A   7       7.935  90.696  38.764  1.00 42.07           C  
ATOM    122  CG  ARG A   7       7.647  91.557  39.980  1.00 47.55           C  
ATOM    123  CD  ARG A   7       6.704  92.690  39.585  1.00 46.89           C  
ATOM    124  NE  ARG A   7       5.523  92.742  40.428  1.00 56.00           N  
ATOM    125  CZ  ARG A   7       4.334  93.165  40.018  1.00 52.99           C  
ATOM    126  NH1 ARG A   7       4.168  93.575  38.765  1.00 48.40           N  
ATOM    127  NH2 ARG A   7       3.312  93.169  40.862  1.00 57.75           N  
ATOM    128  N   VAL A   8       8.230  87.862  37.628  1.00 23.72           N  
ATOM    129  CA  VAL A   8       7.722  86.519  37.424  1.00 27.40           C  
ATOM    130  C   VAL A   8       8.725  85.496  37.928  1.00 20.46           C  
ATOM    131  O   VAL A   8       8.348  84.586  38.667  1.00 26.14           O  
ATOM    132  CB  VAL A   8       7.410  86.259  35.924  1.00 26.71           C  
ATOM    133  CG1 VAL A   8       7.270  84.769  35.655  1.00 26.32           C  
ATOM    134  CG2 VAL A   8       6.109  86.970  35.551  1.00 31.15           C  
ATOM    135  N   LEU A   9       9.987  85.643  37.526  1.00 23.02           N  
ATOM    136  CA  LEU A   9      11.044  84.709  37.928  1.00 26.09           C  
ATOM    137  C   LEU A   9      11.218  84.625  39.445  1.00 26.62           C  
ATOM    138  O   LEU A   9      11.318  83.536  40.015  1.00 23.79           O  
ATOM    139  CB  LEU A   9      12.387  85.100  37.287  1.00 20.44           C  
ATOM    140  CG  LEU A   9      13.593  84.250  37.735  1.00 29.81           C  
ATOM    141  CD1 LEU A   9      13.366  82.817  37.294  1.00 26.96           C  
ATOM    142  CD2 LEU A   9      14.910  84.762  37.136  1.00 20.78           C  
ATOM    143  N   GLN A  10      11.259  85.783  40.091  1.00 25.81           N  
ATOM    144  CA  GLN A  10      11.442  85.869  41.541  1.00 27.81           C  
ATOM    145  C   GLN A  10      10.325  85.210  42.337  1.00 28.52           C  
ATOM    146  O   GLN A  10      10.585  84.533  43.335  1.00 31.54           O  
ATOM    147  CB  GLN A  10      11.564  87.343  41.961  1.00 38.01           C  
ATOM    148  CG  GLN A  10      12.996  87.852  42.111  1.00 44.52           C  
ATOM    149  CD  GLN A  10      13.831  87.769  40.835  1.00 52.89           C  
ATOM    150  OE1 GLN A  10      14.959  88.248  40.800  1.00 61.50           O  
ATOM    151  NE2 GLN A  10      13.285  87.156  39.794  1.00 60.09           N  
ATOM    152  N   ALA A  11       9.087  85.425  41.905  1.00 21.60           N  
ATOM    153  CA  ALA A  11       7.926  84.847  42.568  1.00 34.63           C  
ATOM    154  C   ALA A  11       7.941  83.324  42.455  1.00 30.89           C  
ATOM    155  O   ALA A  11       7.613  82.618  43.410  1.00 30.42           O  
ATOM    156  CB  ALA A  11       6.648  85.402  41.960  1.00 31.59           C  
HETATM  157  N   MSE A  12       8.340  82.815  41.292  1.00 30.50           N  
HETATM  158  CA  MSE A  12       8.388  81.368  41.108  1.00 26.58           C  
HETATM  159  C   MSE A  12       9.500  80.744  41.953  1.00 25.94           C  
HETATM  160  O   MSE A  12       9.305  79.700  42.586  1.00 25.96           O  
HETATM  161  CB  MSE A  12       8.572  81.026  39.623  1.00 25.05           C  
HETATM  162  CG  MSE A  12       7.373  81.437  38.780  1.00 30.91           C  
HETATM  163 SE   MSE A  12       7.487  80.843  36.931  1.00 33.49          SE  
HETATM  164  CE  MSE A  12       7.076  78.987  37.209  1.00 37.42           C  
ATOM    165  N   ALA A  13      10.663  81.383  41.968  1.00 24.27           N  
ATOM    166  CA  ALA A  13      11.787  80.871  42.741  1.00 30.41           C  
ATOM    167  C   ALA A  13      11.405  80.871  44.214  1.00 32.95           C  
ATOM    168  O   ALA A  13      11.715  79.954  44.967  1.00 33.03           O  
ATOM    169  CB  ALA A  13      13.021  81.753  42.516  1.00 31.48           C  
ATOM    170  N   GLU A  14      10.714  81.929  44.599  1.00 33.59           N  
ATOM    171  CA  GLU A  14      10.253  82.148  45.955  1.00 39.00           C  
ATOM    172  C   GLU A  14       9.161  81.157  46.365  1.00 39.14           C  
ATOM    173  O   GLU A  14       9.214  80.557  47.446  1.00 38.25           O  
ATOM    174  CB  GLU A  14       9.722  83.576  46.013  1.00 44.15           C  
ATOM    175  CG  GLU A  14       9.500  84.177  47.359  1.00 49.16           C  
ATOM    176  CD  GLU A  14       9.193  85.661  47.231  1.00 55.10           C  
ATOM    177  OE1 GLU A  14      10.082  86.424  46.788  1.00 55.36           O  
ATOM    178  OE2 GLU A  14       8.056  86.062  47.555  1.00 60.32           O  
ATOM    179  N   ASN A  15       8.169  80.984  45.498  1.00 33.94           N  
ATOM    180  CA  ASN A  15       7.057  80.098  45.797  1.00 34.53           C  
ATOM    181  C   ASN A  15       7.287  78.607  45.571  1.00 31.82           C  
ATOM    182  O   ASN A  15       6.594  77.780  46.175  1.00 31.83           O  
ATOM    183  CB  ASN A  15       5.819  80.574  45.039  1.00 33.77           C  
ATOM    184  CG  ASN A  15       5.299  81.901  45.574  1.00 43.87           C  
ATOM    185  OD1 ASN A  15       5.349  82.150  46.779  1.00 44.73           O  
ATOM    186  ND2 ASN A  15       4.794  82.751  44.690  1.00 37.80           N  
ATOM    187  N   LEU A  16       8.258  78.268  44.727  1.00 28.75           N  
ATOM    188  CA  LEU A  16       8.580  76.878  44.433  1.00 26.97           C  
ATOM    189  C   LEU A  16       9.866  76.403  45.093  1.00 30.40           C  
ATOM    190  O   LEU A  16      10.103  75.204  45.168  1.00 30.72           O  
ATOM    191  CB  LEU A  16       8.702  76.659  42.930  1.00 24.15           C  
ATOM    192  CG  LEU A  16       7.459  77.056  42.127  1.00 21.63           C  
ATOM    193  CD1 LEU A  16       7.670  76.747  40.654  1.00 26.71           C  
ATOM    194  CD2 LEU A  16       6.257  76.290  42.656  1.00 29.49           C  
ATOM    195  N   GLY A  17      10.700  77.342  45.539  1.00 29.43           N  
ATOM    196  CA  GLY A  17      11.950  76.981  46.183  1.00 30.35           C  
ATOM    197  C   GLY A  17      12.767  75.975  45.402  1.00 30.57           C  
ATOM    198  O   GLY A  17      12.985  76.140  44.199  1.00 28.65           O  
ATOM    199  N   GLU A  18      13.218  74.925  46.085  1.00 28.80           N  
ATOM    200  CA  GLU A  18      14.023  73.883  45.457  1.00 29.83           C  
ATOM    201  C   GLU A  18      13.248  73.142  44.356  1.00 20.22           C  
ATOM    202  O   GLU A  18      13.835  72.422  43.558  1.00 24.55           O  
ATOM    203  CB  GLU A  18      14.491  72.880  46.514  1.00 32.48           C  
ATOM    204  CG  GLU A  18      15.386  73.496  47.588  1.00 42.83           C  
ATOM    205  CD  GLU A  18      16.565  74.258  47.002  1.00 49.23           C  
ATOM    206  OE1 GLU A  18      17.334  73.670  46.207  1.00 56.11           O  
ATOM    207  OE2 GLU A  18      16.723  75.452  47.338  1.00 60.78           O  
ATOM    208  N   GLY A  19      11.934  73.329  44.327  1.00 22.90           N  
ATOM    209  CA  GLY A  19      11.121  72.668  43.317  1.00 21.05           C  
ATOM    210  C   GLY A  19      10.995  73.468  42.024  1.00 27.98           C  
ATOM    211  O   GLY A  19      10.260  73.063  41.105  1.00 22.37           O  
ATOM    212  N   LEU A  20      11.686  74.608  41.937  1.00 20.94           N  
ATOM    213  CA  LEU A  20      11.641  75.405  40.704  1.00 21.01           C  
ATOM    214  C   LEU A  20      12.216  74.546  39.580  1.00 21.27           C  
ATOM    215  O   LEU A  20      13.326  74.044  39.687  1.00 18.06           O  
ATOM    216  CB  LEU A  20      12.488  76.674  40.835  1.00 24.24           C  
ATOM    217  CG  LEU A  20      12.500  77.605  39.624  1.00 25.04           C  
ATOM    218  CD1 LEU A  20      11.151  78.343  39.507  1.00 17.63           C  
ATOM    219  CD2 LEU A  20      13.652  78.608  39.783  1.00 23.91           C  
ATOM    220  N   PRO A  21      11.466  74.365  38.482  1.00 18.06           N  
ATOM    221  CA  PRO A  21      11.991  73.541  37.393  1.00 20.78           C  
ATOM    222  C   PRO A  21      13.230  74.174  36.791  1.00 23.42           C  
ATOM    223  O   PRO A  21      13.335  75.388  36.733  1.00 22.33           O  
ATOM    224  CB  PRO A  21      10.832  73.501  36.396  1.00 19.62           C  
ATOM    225  CG  PRO A  21       9.636  73.636  37.257  1.00 22.42           C  
ATOM    226  CD  PRO A  21      10.055  74.710  38.245  1.00 17.36           C  
ATOM    227  N   ARG A  22      14.157  73.335  36.345  1.00 21.88           N  
ATOM    228  CA  ARG A  22      15.400  73.775  35.729  1.00 24.20           C  
ATOM    229  C   ARG A  22      15.126  74.637  34.497  1.00 25.72           C  
ATOM    230  O   ARG A  22      15.877  75.571  34.189  1.00 22.76           O  
ATOM    231  CB  ARG A  22      16.212  72.538  35.349  1.00 26.78           C  
ATOM    232  CG  ARG A  22      17.467  72.787  34.545  1.00 41.75           C  
ATOM    233  CD  ARG A  22      18.033  71.444  34.065  1.00 51.85           C  
ATOM    234  NE  ARG A  22      19.092  71.587  33.066  1.00 52.31           N  
ATOM    235  CZ  ARG A  22      19.290  70.724  32.076  1.00 52.10           C  
ATOM    236  NH1 ARG A  22      18.502  69.662  31.949  1.00 51.89           N  
ATOM    237  NH2 ARG A  22      20.281  70.911  31.215  1.00 54.72           N  
ATOM    238  N   ALA A  23      14.043  74.332  33.789  1.00 19.76           N  
ATOM    239  CA  ALA A  23      13.696  75.107  32.609  1.00 18.46           C  
ATOM    240  C   ALA A  23      13.331  76.581  32.889  1.00 21.45           C  
ATOM    241  O   ALA A  23      13.477  77.418  32.009  1.00 18.29           O  
ATOM    242  CB  ALA A  23      12.542  74.426  31.853  1.00 22.63           C  
ATOM    243  N   ILE A  24      12.858  76.912  34.089  1.00 18.01           N  
ATOM    244  CA  ILE A  24      12.468  78.310  34.354  1.00 17.99           C  
ATOM    245  C   ILE A  24      13.640  79.310  34.235  1.00 19.39           C  
ATOM    246  O   ILE A  24      13.544  80.295  33.503  1.00 18.38           O  
ATOM    247  CB  ILE A  24      11.781  78.444  35.729  1.00 19.16           C  
ATOM    248  CG1 ILE A  24      10.499  77.592  35.740  1.00 22.21           C  
ATOM    249  CG2 ILE A  24      11.448  79.927  36.027  1.00 14.39           C  
ATOM    250  CD1 ILE A  24       9.558  77.854  34.568  1.00 22.58           C  
ATOM    251  N   PRO A  25      14.754  79.075  34.956  1.00 19.12           N  
ATOM    252  CA  PRO A  25      15.879  80.019  34.833  1.00 22.42           C  
ATOM    253  C   PRO A  25      16.398  80.070  33.386  1.00 22.40           C  
ATOM    254  O   PRO A  25      16.842  81.114  32.897  1.00 16.87           O  
ATOM    255  CB  PRO A  25      16.921  79.441  35.780  1.00 19.77           C  
ATOM    256  CG  PRO A  25      16.070  78.778  36.842  1.00 20.26           C  
ATOM    257  CD  PRO A  25      14.989  78.113  36.052  1.00 15.12           C  
ATOM    258  N   LEU A  26      16.359  78.927  32.710  1.00 18.78           N  
ATOM    259  CA  LEU A  26      16.811  78.873  31.329  1.00 18.23           C  
ATOM    260  C   LEU A  26      15.916  79.750  30.433  1.00 22.85           C  
ATOM    261  O   LEU A  26      16.410  80.452  29.542  1.00 20.03           O  
ATOM    262  CB  LEU A  26      16.848  77.418  30.853  1.00 17.39           C  
ATOM    263  CG  LEU A  26      18.000  76.618  31.478  1.00 20.02           C  
ATOM    264  CD1 LEU A  26      17.863  75.123  31.152  1.00 20.87           C  
ATOM    265  CD2 LEU A  26      19.323  77.162  30.951  1.00 25.25           C  
ATOM    266  N   LEU A  27      14.609  79.730  30.683  1.00 18.33           N  
ATOM    267  CA  LEU A  27      13.681  80.578  29.930  1.00 14.82           C  
ATOM    268  C   LEU A  27      13.998  82.059  30.217  1.00 18.26           C  
ATOM    269  O   LEU A  27      14.053  82.880  29.301  1.00 20.53           O  
ATOM    270  CB  LEU A  27      12.235  80.295  30.335  1.00 16.89           C  
ATOM    271  CG  LEU A  27      11.602  79.014  29.781  1.00 19.04           C  
ATOM    272  CD1 LEU A  27      10.180  78.888  30.342  1.00 20.04           C  
ATOM    273  CD2 LEU A  27      11.566  79.063  28.258  1.00 18.52           C  
ATOM    274  N   ALA A  28      14.177  82.398  31.488  1.00 15.98           N  
ATOM    275  CA  ALA A  28      14.529  83.777  31.869  1.00 17.65           C  
ATOM    276  C   ALA A  28      15.720  84.266  31.044  1.00 17.85           C  
ATOM    277  O   ALA A  28      15.742  85.393  30.547  1.00 20.00           O  
ATOM    278  CB  ALA A  28      14.884  83.826  33.361  1.00 18.15           C  
ATOM    279  N   GLU A  29      16.712  83.404  30.900  1.00 21.14           N  
ATOM    280  CA  GLU A  29      17.920  83.735  30.151  1.00 21.73           C  
ATOM    281  C   GLU A  29      17.742  83.753  28.633  1.00 23.05           C  
ATOM    282  O   GLU A  29      18.112  84.711  27.957  1.00 21.09           O  
ATOM    283  CB  GLU A  29      19.028  82.716  30.461  1.00 19.78           C  
ATOM    284  CG  GLU A  29      20.361  83.054  29.781  1.00 26.88           C  
ATOM    285  CD  GLU A  29      21.357  81.914  29.823  1.00 35.19           C  
ATOM    286  OE1 GLU A  29      21.209  81.015  30.677  1.00 31.47           O  
ATOM    287  OE2 GLU A  29      22.301  81.930  29.003  1.00 34.80           O  
ATOM    288  N   LYS A  30      17.172  82.681  28.104  1.00 21.77           N  
ATOM    289  CA  LYS A  30      17.056  82.546  26.666  1.00 20.24           C  
ATOM    290  C   LYS A  30      15.763  82.899  25.957  1.00 17.84           C  
ATOM    291  O   LYS A  30      15.779  83.121  24.749  1.00 22.85           O  
ATOM    292  CB  LYS A  30      17.477  81.123  26.306  1.00 22.21           C  
ATOM    293  CG  LYS A  30      18.848  80.807  26.891  1.00 28.21           C  
ATOM    294  CD  LYS A  30      19.396  79.504  26.397  1.00 28.15           C  
ATOM    295  CE  LYS A  30      20.820  79.283  26.913  1.00 26.06           C  
ATOM    296  NZ  LYS A  30      21.316  77.953  26.476  1.00 23.72           N  
ATOM    297  N   ALA A  31      14.657  82.944  26.687  1.00 14.66           N  
ATOM    298  CA  ALA A  31      13.360  83.252  26.093  1.00 23.09           C  
ATOM    299  C   ALA A  31      12.513  83.914  27.172  1.00 14.96           C  
ATOM    300  O   ALA A  31      11.475  83.391  27.580  1.00 19.11           O  
ATOM    301  CB  ALA A  31      12.688  81.969  25.611  1.00 18.90           C  
ATOM    302  N   PRO A  32      12.946  85.087  27.638  1.00 16.72           N  
ATOM    303  CA  PRO A  32      12.185  85.772  28.683  1.00 18.44           C  
ATOM    304  C   PRO A  32      10.721  86.073  28.334  1.00 16.45           C  
ATOM    305  O   PRO A  32       9.875  86.076  29.222  1.00 15.84           O  
ATOM    306  CB  PRO A  32      13.032  87.020  28.984  1.00 20.79           C  
ATOM    307  CG  PRO A  32      13.849  87.245  27.722  1.00 18.27           C  
ATOM    308  CD  PRO A  32      14.167  85.831  27.257  1.00 23.42           C  
ATOM    309  N   GLY A  33      10.440  86.349  27.055  1.00 17.56           N  
ATOM    310  CA  GLY A  33       9.073  86.600  26.616  1.00 18.08           C  
ATOM    311  C   GLY A  33       8.219  85.356  26.848  1.00 17.18           C  
ATOM    312  O   GLY A  33       7.060  85.464  27.268  1.00 18.18           O  
ATOM    313  N   LEU A  34       8.780  84.173  26.591  1.00 15.63           N  
ATOM    314  CA  LEU A  34       8.026  82.934  26.805  1.00 17.59           C  
ATOM    315  C   LEU A  34       7.797  82.720  28.310  1.00 17.16           C  
ATOM    316  O   LEU A  34       6.775  82.164  28.703  1.00 17.68           O  
ATOM    317  CB  LEU A  34       8.746  81.718  26.179  1.00 20.09           C  
ATOM    318  CG  LEU A  34       8.122  80.329  26.392  1.00 24.45           C  
ATOM    319  CD1 LEU A  34       6.629  80.330  26.027  1.00 18.61           C  
ATOM    320  CD2 LEU A  34       8.897  79.295  25.559  1.00 18.38           C  
ATOM    321  N   LEU A  35       8.718  83.190  29.156  1.00 18.14           N  
ATOM    322  CA  LEU A  35       8.530  83.040  30.599  1.00 13.94           C  
ATOM    323  C   LEU A  35       7.361  83.920  31.023  1.00 16.09           C  
ATOM    324  O   LEU A  35       6.537  83.517  31.835  1.00 18.23           O  
ATOM    325  CB  LEU A  35       9.795  83.446  31.381  1.00 18.12           C  
ATOM    326  CG  LEU A  35       9.640  83.451  32.915  1.00 25.46           C  
ATOM    327  CD1 LEU A  35       9.212  82.065  33.393  1.00 20.43           C  
ATOM    328  CD2 LEU A  35      10.975  83.844  33.606  1.00 21.69           C  
ATOM    329  N   LEU A  36       7.285  85.134  30.482  1.00 18.20           N  
ATOM    330  CA  LEU A  36       6.168  86.028  30.835  1.00 18.06           C  
ATOM    331  C   LEU A  36       4.857  85.470  30.277  1.00 17.88           C  
ATOM    332  O   LEU A  36       3.787  85.623  30.875  1.00 13.86           O  
ATOM    333  CB  LEU A  36       6.393  87.438  30.279  1.00 18.45           C  
ATOM    334  CG  LEU A  36       7.496  88.223  30.998  1.00 30.19           C  
ATOM    335  CD1 LEU A  36       7.580  89.622  30.429  1.00 32.81           C  
ATOM    336  CD2 LEU A  36       7.195  88.273  32.485  1.00 29.01           C  
ATOM    337  N   GLU A  37       4.933  84.807  29.130  1.00 15.20           N  
ATOM    338  CA  GLU A  37       3.709  84.226  28.557  1.00 13.67           C  
ATOM    339  C   GLU A  37       3.264  83.074  29.453  1.00 16.07           C  
ATOM    340  O   GLU A  37       2.062  82.836  29.638  1.00 18.75           O  
ATOM    341  CB  GLU A  37       3.953  83.731  27.126  1.00 14.02           C  
ATOM    342  CG  GLU A  37       2.737  83.049  26.482  1.00 15.75           C  
ATOM    343  CD  GLU A  37       1.540  83.983  26.227  1.00 22.02           C  
ATOM    344  OE1 GLU A  37       1.534  85.139  26.685  1.00 23.32           O  
ATOM    345  OE2 GLU A  37       0.581  83.531  25.574  1.00 27.19           O  
ATOM    346  N   HIS A  38       4.242  82.357  30.005  1.00 15.41           N  
ATOM    347  CA  HIS A  38       3.958  81.265  30.928  1.00 15.24           C  
ATOM    348  C   HIS A  38       3.217  81.851  32.127  1.00 16.02           C  
ATOM    349  O   HIS A  38       2.209  81.313  32.575  1.00 17.83           O  
ATOM    350  CB  HIS A  38       5.271  80.608  31.389  1.00 14.31           C  
ATOM    351  CG  HIS A  38       5.091  79.617  32.497  1.00 21.32           C  
ATOM    352  ND1 HIS A  38       4.396  78.438  32.331  1.00 15.61           N  
ATOM    353  CD2 HIS A  38       5.492  79.642  33.790  1.00 31.59           C  
ATOM    354  CE1 HIS A  38       4.378  77.779  33.477  1.00 29.07           C  
ATOM    355  NE2 HIS A  38       5.034  78.487  34.379  1.00 28.96           N  
ATOM    356  N   GLY A  39       3.724  82.964  32.657  1.00 13.87           N  
ATOM    357  CA  GLY A  39       3.063  83.589  33.802  1.00 17.74           C  
ATOM    358  C   GLY A  39       1.680  84.124  33.461  1.00 15.08           C  
ATOM    359  O   GLY A  39       0.733  84.011  34.262  1.00 15.96           O  
ATOM    360  N   ARG A  40       1.542  84.707  32.271  1.00 16.17           N  
ATOM    361  CA  ARG A  40       0.243  85.244  31.859  1.00 21.24           C  
ATOM    362  C   ARG A  40      -0.773  84.102  31.789  1.00 19.66           C  
ATOM    363  O   ARG A  40      -1.897  84.191  32.323  1.00 16.69           O  
ATOM    364  CB  ARG A  40       0.326  85.915  30.474  1.00 19.96           C  
ATOM    365  CG  ARG A  40      -1.015  86.576  30.041  1.00 21.49           C  
ATOM    366  CD  ARG A  40      -1.021  87.018  28.580  1.00 21.72           C  
ATOM    367  NE  ARG A  40      -1.113  85.898  27.643  1.00 23.71           N  
ATOM    368  CZ  ARG A  40      -2.212  85.166  27.432  1.00 28.79           C  
ATOM    369  NH1 ARG A  40      -3.336  85.431  28.090  1.00 24.14           N  
ATOM    370  NH2 ARG A  40      -2.186  84.158  26.568  1.00 18.29           N  
ATOM    371  N   SER A  41      -0.364  83.019  31.136  1.00 16.16           N  
ATOM    372  CA  SER A  41      -1.247  81.877  30.971  1.00 16.97           C  
ATOM    373  C   SER A  41      -1.617  81.269  32.319  1.00 20.72           C  
ATOM    374  O   SER A  41      -2.763  80.883  32.539  1.00 16.55           O  
ATOM    375  CB  SER A  41      -0.608  80.819  30.051  1.00 18.54           C  
ATOM    376  OG  SER A  41       0.632  80.394  30.561  1.00 22.48           O  
ATOM    377  N   TRP A  42      -0.657  81.197  33.231  1.00 16.97           N  
ATOM    378  CA  TRP A  42      -0.939  80.641  34.551  1.00 17.69           C  
ATOM    379  C   TRP A  42      -2.032  81.461  35.236  1.00 22.27           C  
ATOM    380  O   TRP A  42      -2.956  80.910  35.847  1.00 17.36           O  
ATOM    381  CB  TRP A  42       0.321  80.657  35.424  1.00 21.01           C  
ATOM    382  CG  TRP A  42       0.111  80.078  36.807  1.00 22.32           C  
ATOM    383  CD1 TRP A  42      -0.622  80.625  37.839  1.00 25.52           C  
ATOM    384  CD2 TRP A  42       0.570  78.810  37.270  1.00 18.60           C  
ATOM    385  NE1 TRP A  42      -0.647  79.759  38.906  1.00 22.08           N  
ATOM    386  CE2 TRP A  42       0.082  78.640  38.584  1.00 21.02           C  
ATOM    387  CE3 TRP A  42       1.354  77.793  36.703  1.00 23.88           C  
ATOM    388  CZ2 TRP A  42       0.347  77.491  39.333  1.00 23.06           C  
ATOM    389  CZ3 TRP A  42       1.616  76.650  37.451  1.00 25.20           C  
ATOM    390  CH2 TRP A  42       1.115  76.512  38.748  1.00 20.45           C  
ATOM    391  N   THR A  43      -1.933  82.781  35.120  1.00 16.15           N  
ATOM    392  CA  THR A  43      -2.893  83.645  35.789  1.00 21.07           C  
ATOM    393  C   THR A  43      -4.255  83.659  35.124  1.00 19.21           C  
ATOM    394  O   THR A  43      -5.272  83.857  35.798  1.00 18.07           O  
ATOM    395  CB  THR A  43      -2.338  85.078  35.938  1.00 25.07           C  
ATOM    396  OG1 THR A  43      -2.090  85.644  34.649  1.00 39.92           O  
ATOM    397  CG2 THR A  43      -1.044  85.036  36.705  1.00 22.31           C  
ATOM    398  N   TYR A  44      -4.274  83.438  33.814  1.00 20.64           N  
ATOM    399  CA  TYR A  44      -5.531  83.393  33.078  1.00 17.89           C  
ATOM    400  C   TYR A  44      -6.315  82.193  33.606  1.00 16.10           C  
ATOM    401  O   TYR A  44      -7.518  82.273  33.856  1.00 15.32           O  
ATOM    402  CB  TYR A  44      -5.270  83.203  31.579  1.00 19.01           C  
ATOM    403  CG  TYR A  44      -6.489  82.696  30.851  1.00 23.70           C  
ATOM    404  CD1 TYR A  44      -7.532  83.550  30.519  1.00 24.29           C  
ATOM    405  CD2 TYR A  44      -6.648  81.330  30.614  1.00 23.82           C  
ATOM    406  CE1 TYR A  44      -8.720  83.049  29.977  1.00 23.46           C  
ATOM    407  CE2 TYR A  44      -7.812  80.823  30.082  1.00 22.18           C  
ATOM    408  CZ  TYR A  44      -8.847  81.679  29.767  1.00 25.18           C  
ATOM    409  OH  TYR A  44     -10.013  81.140  29.270  1.00 32.84           O  
ATOM    410  N   ALA A  45      -5.619  81.070  33.766  1.00 17.35           N  
ATOM    411  CA  ALA A  45      -6.275  79.852  34.246  1.00 15.61           C  
ATOM    412  C   ALA A  45      -6.688  79.919  35.716  1.00 19.24           C  
ATOM    413  O   ALA A  45      -7.721  79.374  36.106  1.00 17.24           O  
ATOM    414  CB  ALA A  45      -5.344  78.617  34.013  1.00 15.51           C  
HETATM  415  N   MSE A  46      -5.868  80.582  36.521  1.00 16.88           N  
HETATM  416  CA  MSE A  46      -6.083  80.678  37.950  1.00 17.97           C  
HETATM  417  C   MSE A  46      -6.032  82.130  38.411  1.00 18.89           C  
HETATM  418  O   MSE A  46      -5.043  82.561  38.987  1.00 18.69           O  
HETATM  419  CB  MSE A  46      -5.012  79.839  38.668  1.00 19.00           C  
HETATM  420  CG  MSE A  46      -5.203  78.320  38.443  1.00 17.09           C  
HETATM  421 SE   MSE A  46      -3.687  77.216  38.894  1.00 21.05          SE  
HETATM  422  CE  MSE A  46      -2.677  77.374  37.237  1.00 19.43           C  
ATOM    423  N   PRO A  47      -7.111  82.888  38.175  1.00 18.92           N  
ATOM    424  CA  PRO A  47      -7.090  84.292  38.599  1.00 25.28           C  
ATOM    425  C   PRO A  47      -7.001  84.456  40.114  1.00 29.29           C  
ATOM    426  O   PRO A  47      -7.480  83.612  40.879  1.00 22.32           O  
ATOM    427  CB  PRO A  47      -8.364  84.865  37.976  1.00 27.46           C  
ATOM    428  CG  PRO A  47      -9.277  83.684  37.887  1.00 31.28           C  
ATOM    429  CD  PRO A  47      -8.372  82.540  37.492  1.00 24.24           C  
ATOM    430  N   GLU A  48      -6.350  85.535  40.541  1.00 28.73           N  
ATOM    431  CA  GLU A  48      -6.168  85.802  41.966  1.00 37.10           C  
ATOM    432  C   GLU A  48      -7.423  85.540  42.803  1.00 36.52           C  
ATOM    433  O   GLU A  48      -7.331  84.988  43.897  1.00 46.12           O  
ATOM    434  CB  GLU A  48      -5.667  87.230  42.177  1.00 42.78           C  
ATOM    435  CG  GLU A  48      -4.286  87.278  42.796  1.00 50.94           C  
ATOM    436  CD  GLU A  48      -4.268  88.049  44.095  1.00 54.58           C  
ATOM    437  OE1 GLU A  48      -3.467  87.696  44.993  1.00 62.14           O  
ATOM    438  OE2 GLU A  48      -5.053  89.014  44.217  1.00 58.48           O  
ATOM    439  N   LYS A  49      -8.595  85.932  42.303  1.00 33.97           N  
ATOM    440  CA  LYS A  49      -9.856  85.666  43.013  1.00 35.51           C  
ATOM    441  C   LYS A  49     -10.717  84.868  42.055  1.00 37.67           C  
ATOM    442  O   LYS A  49     -11.593  85.403  41.379  1.00 45.42           O  
ATOM    443  CB  LYS A  49     -10.569  86.965  43.405  1.00 38.01           C  
ATOM    444  CG  LYS A  49      -9.948  87.610  44.626  1.00 39.08           C  
ATOM    445  CD  LYS A  49     -10.630  88.897  45.000  1.00 37.73           C  
ATOM    446  CE  LYS A  49     -10.017  89.417  46.284  1.00 46.64           C  
ATOM    447  NZ  LYS A  49     -10.460  90.793  46.594  1.00 55.35           N  
ATOM    448  N   GLY A  50     -10.455  83.574  42.001  1.00 25.83           N  
ATOM    449  CA  GLY A  50     -11.181  82.733  41.081  1.00 25.24           C  
ATOM    450  C   GLY A  50     -12.234  81.834  41.674  1.00 22.40           C  
ATOM    451  O   GLY A  50     -12.751  82.057  42.772  1.00 22.55           O  
ATOM    452  N   ALA A  51     -12.525  80.779  40.932  1.00 20.39           N  
ATOM    453  CA  ALA A  51     -13.548  79.833  41.328  1.00 19.17           C  
ATOM    454  C   ALA A  51     -13.075  78.811  42.355  1.00 20.79           C  
ATOM    455  O   ALA A  51     -13.872  78.307  43.137  1.00 19.42           O  
ATOM    456  CB  ALA A  51     -14.102  79.124  40.077  1.00 20.62           C  
ATOM    457  N   LEU A  52     -11.776  78.535  42.382  1.00 19.24           N  
ATOM    458  CA  LEU A  52     -11.221  77.548  43.314  1.00 19.94           C  
ATOM    459  C   LEU A  52     -10.135  78.168  44.171  1.00 24.92           C  
ATOM    460  O   LEU A  52      -9.426  79.062  43.712  1.00 25.64           O  
ATOM    461  CB  LEU A  52     -10.611  76.382  42.530  1.00 21.30           C  
ATOM    462  CG  LEU A  52     -11.529  75.696  41.521  1.00 21.92           C  
ATOM    463  CD1 LEU A  52     -10.734  74.615  40.735  1.00 15.09           C  
ATOM    464  CD2 LEU A  52     -12.691  75.077  42.261  1.00 16.19           C  
ATOM    465  N   ASP A  53      -9.969  77.681  45.397  1.00 19.40           N  
ATOM    466  CA  ASP A  53      -8.926  78.242  46.259  1.00 20.81           C  
ATOM    467  C   ASP A  53      -7.549  77.664  45.893  1.00 25.26           C  
ATOM    468  O   ASP A  53      -7.466  76.698  45.130  1.00 18.30           O  
ATOM    469  CB  ASP A  53      -9.262  78.025  47.754  1.00 21.89           C  
ATOM    470  CG  ASP A  53      -9.428  76.550  48.142  1.00 37.74           C  
ATOM    471  OD1 ASP A  53      -8.946  75.646  47.423  1.00 36.58           O  
ATOM    472  OD2 ASP A  53     -10.040  76.299  49.205  1.00 40.95           O  
ATOM    473  N   GLU A  54      -6.472  78.250  46.421  1.00 18.10           N  
ATOM    474  CA  GLU A  54      -5.113  77.791  46.085  1.00 24.12           C  
ATOM    475  C   GLU A  54      -4.805  76.347  46.476  1.00 24.40           C  
ATOM    476  O   GLU A  54      -4.014  75.677  45.811  1.00 19.75           O  
ATOM    477  CB  GLU A  54      -4.036  78.709  46.689  1.00 25.82           C  
ATOM    478  CG  GLU A  54      -3.817  80.013  45.932  1.00 43.10           C  
ATOM    479  CD  GLU A  54      -3.571  79.825  44.435  1.00 34.37           C  
ATOM    480  OE1 GLU A  54      -2.630  79.099  44.047  1.00 36.32           O  
ATOM    481  OE2 GLU A  54      -4.323  80.427  43.638  1.00 37.28           O  
ATOM    482  N   LYS A  55      -5.405  75.880  47.564  1.00 21.65           N  
ATOM    483  CA  LYS A  55      -5.198  74.509  47.988  1.00 24.27           C  
ATOM    484  C   LYS A  55      -5.691  73.603  46.883  1.00 20.52           C  
ATOM    485  O   LYS A  55      -4.950  72.745  46.394  1.00 19.99           O  
ATOM    486  CB  LYS A  55      -5.993  74.193  49.261  1.00 18.49           C  
ATOM    487  CG  LYS A  55      -5.910  72.722  49.671  1.00 26.90           C  
ATOM    488  CD  LYS A  55      -6.564  72.462  51.029  1.00 26.83           C  
ATOM    489  CE  LYS A  55      -6.535  70.985  51.379  1.00 34.80           C  
ATOM    490  NZ  LYS A  55      -7.108  70.730  52.741  1.00 36.66           N  
ATOM    491  N   THR A  56      -6.954  73.791  46.503  1.00 17.23           N  
ATOM    492  CA  THR A  56      -7.572  72.972  45.454  1.00 17.44           C  
ATOM    493  C   THR A  56      -6.804  73.039  44.145  1.00 17.29           C  
ATOM    494  O   THR A  56      -6.550  72.006  43.513  1.00 16.45           O  
ATOM    495  CB  THR A  56      -9.040  73.389  45.218  1.00 18.18           C  
ATOM    496  OG1 THR A  56      -9.758  73.285  46.453  1.00 24.54           O  
ATOM    497  CG2 THR A  56      -9.721  72.466  44.189  1.00 15.10           C  
ATOM    498  N   ARG A  57      -6.432  74.246  43.723  1.00 14.30           N  
ATOM    499  CA  ARG A  57      -5.678  74.388  42.476  1.00 13.61           C  
ATOM    500  C   ARG A  57      -4.385  73.592  42.527  1.00 17.26           C  
ATOM    501  O   ARG A  57      -4.052  72.890  41.573  1.00 16.89           O  
ATOM    502  CB  ARG A  57      -5.337  75.862  42.196  1.00 17.00           C  
ATOM    503  CG  ARG A  57      -6.545  76.717  41.813  1.00 17.07           C  
ATOM    504  CD  ARG A  57      -6.265  78.207  41.990  1.00 15.14           C  
ATOM    505  NE  ARG A  57      -7.313  79.031  41.372  1.00 19.84           N  
ATOM    506  CZ  ARG A  57      -7.285  80.365  41.339  1.00 22.00           C  
ATOM    507  NH1 ARG A  57      -6.272  81.011  41.896  1.00 15.53           N  
ATOM    508  NH2 ARG A  57      -8.252  81.052  40.746  1.00 17.40           N  
ATOM    509  N   THR A  58      -3.656  73.707  43.636  1.00 15.75           N  
ATOM    510  CA  THR A  58      -2.391  73.011  43.779  1.00 15.64           C  
ATOM    511  C   THR A  58      -2.574  71.490  43.757  1.00 13.84           C  
ATOM    512  O   THR A  58      -1.791  70.775  43.121  1.00 15.12           O  
ATOM    513  CB  THR A  58      -1.687  73.430  45.096  1.00 16.14           C  
ATOM    514  OG1 THR A  58      -1.527  74.850  45.094  1.00 19.00           O  
ATOM    515  CG2 THR A  58      -0.295  72.757  45.225  1.00 16.76           C  
ATOM    516  N   LEU A  59      -3.603  70.994  44.438  1.00 14.68           N  
ATOM    517  CA  LEU A  59      -3.818  69.546  44.465  1.00 18.58           C  
ATOM    518  C   LEU A  59      -4.233  69.014  43.093  1.00 18.37           C  
ATOM    519  O   LEU A  59      -3.897  67.881  42.743  1.00 16.25           O  
ATOM    520  CB  LEU A  59      -4.857  69.176  45.538  1.00 15.52           C  
ATOM    521  CG  LEU A  59      -4.376  69.587  46.939  1.00 15.47           C  
ATOM    522  CD1 LEU A  59      -5.385  69.121  47.943  1.00 18.44           C  
ATOM    523  CD2 LEU A  59      -2.966  69.010  47.238  1.00 16.95           C  
ATOM    524  N   ILE A  60      -4.977  69.815  42.326  1.00 15.23           N  
ATOM    525  CA  ILE A  60      -5.367  69.396  40.981  1.00 14.17           C  
ATOM    526  C   ILE A  60      -4.077  69.311  40.138  1.00 14.31           C  
ATOM    527  O   ILE A  60      -3.837  68.313  39.470  1.00 12.72           O  
ATOM    528  CB  ILE A  60      -6.366  70.404  40.324  1.00 16.40           C  
ATOM    529  CG1 ILE A  60      -7.728  70.344  41.036  1.00 16.28           C  
ATOM    530  CG2 ILE A  60      -6.586  70.057  38.836  1.00 15.75           C  
ATOM    531  CD1 ILE A  60      -8.660  71.515  40.640  1.00 18.60           C  
ATOM    532  N   LEU A  61      -3.248  70.356  40.183  1.00 12.99           N  
ATOM    533  CA  LEU A  61      -1.992  70.364  39.438  1.00 10.40           C  
ATOM    534  C   LEU A  61      -1.096  69.214  39.854  1.00 15.90           C  
ATOM    535  O   LEU A  61      -0.430  68.603  39.013  1.00 14.93           O  
ATOM    536  CB  LEU A  61      -1.266  71.685  39.665  1.00 13.87           C  
ATOM    537  CG  LEU A  61      -2.004  72.841  38.966  1.00 14.59           C  
ATOM    538  CD1 LEU A  61      -1.415  74.161  39.427  1.00 15.90           C  
ATOM    539  CD2 LEU A  61      -1.835  72.682  37.435  1.00 11.79           C  
ATOM    540  N   LEU A  62      -1.078  68.928  41.152  1.00 13.69           N  
ATOM    541  CA  LEU A  62      -0.248  67.838  41.691  1.00 16.21           C  
ATOM    542  C   LEU A  62      -0.751  66.483  41.192  1.00 20.05           C  
ATOM    543  O   LEU A  62       0.049  65.620  40.795  1.00 15.98           O  
ATOM    544  CB  LEU A  62      -0.257  67.843  43.230  1.00 14.49           C  
ATOM    545  CG  LEU A  62       0.474  66.663  43.916  1.00 13.13           C  
ATOM    546  CD1 LEU A  62       1.956  66.646  43.498  1.00 16.10           C  
ATOM    547  CD2 LEU A  62       0.353  66.785  45.461  1.00 13.53           C  
ATOM    548  N   GLY A  63      -2.071  66.295  41.227  1.00 15.61           N  
ATOM    549  CA  GLY A  63      -2.635  65.048  40.747  1.00 14.78           C  
ATOM    550  C   GLY A  63      -2.295  64.835  39.283  1.00 13.92           C  
ATOM    551  O   GLY A  63      -1.875  63.753  38.868  1.00 13.00           O  
ATOM    552  N   ILE A  64      -2.485  65.870  38.475  1.00 14.55           N  
ATOM    553  CA  ILE A  64      -2.179  65.751  37.055  1.00 13.15           C  
ATOM    554  C   ILE A  64      -0.713  65.401  36.821  1.00 14.77           C  
ATOM    555  O   ILE A  64      -0.418  64.493  36.057  1.00 13.49           O  
ATOM    556  CB  ILE A  64      -2.532  67.053  36.289  1.00 17.73           C  
ATOM    557  CG1 ILE A  64      -4.068  67.243  36.284  1.00 16.40           C  
ATOM    558  CG2 ILE A  64      -1.959  66.989  34.864  1.00 18.72           C  
ATOM    559  CD1 ILE A  64      -4.544  68.603  35.761  1.00 18.29           C  
ATOM    560  N   ALA A  65       0.198  66.094  37.513  1.00 14.11           N  
ATOM    561  CA  ALA A  65       1.640  65.852  37.362  1.00 14.51           C  
ATOM    562  C   ALA A  65       1.983  64.395  37.643  1.00 16.13           C  
ATOM    563  O   ALA A  65       2.726  63.762  36.886  1.00 14.90           O  
ATOM    564  CB  ALA A  65       2.441  66.764  38.317  1.00 11.27           C  
ATOM    565  N   LEU A  66       1.444  63.872  38.740  1.00 13.82           N  
ATOM    566  CA  LEU A  66       1.688  62.497  39.124  1.00 10.95           C  
ATOM    567  C   LEU A  66       1.109  61.530  38.080  1.00 14.39           C  
ATOM    568  O   LEU A  66       1.799  60.602  37.658  1.00 16.49           O  
ATOM    569  CB  LEU A  66       1.083  62.209  40.512  1.00 11.39           C  
ATOM    570  CG  LEU A  66       1.805  62.802  41.745  1.00 14.31           C  
ATOM    571  CD1 LEU A  66       0.826  62.810  42.936  1.00 16.37           C  
ATOM    572  CD2 LEU A  66       3.061  61.970  42.107  1.00 13.60           C  
ATOM    573  N   ALA A  67      -0.137  61.747  37.655  1.00 16.50           N  
ATOM    574  CA  ALA A  67      -0.769  60.853  36.671  1.00 17.23           C  
ATOM    575  C   ALA A  67      -0.093  60.859  35.301  1.00 17.75           C  
ATOM    576  O   ALA A  67      -0.096  59.833  34.624  1.00 18.34           O  
ATOM    577  CB  ALA A  67      -2.263  61.195  36.499  1.00 15.05           C  
ATOM    578  N   THR A  68       0.483  61.996  34.903  1.00 17.76           N  
ATOM    579  CA  THR A  68       1.146  62.113  33.600  1.00 15.51           C  
ATOM    580  C   THR A  68       2.654  61.899  33.678  1.00 18.63           C  
ATOM    581  O   THR A  68       3.343  61.957  32.666  1.00 15.69           O  
ATOM    582  CB  THR A  68       0.912  63.521  32.919  1.00 19.19           C  
ATOM    583  OG1 THR A  68       1.440  64.563  33.753  1.00 21.69           O  
ATOM    584  CG2 THR A  68      -0.577  63.774  32.690  1.00 16.79           C  
ATOM    585  N   GLY A  69       3.175  61.690  34.876  1.00 17.72           N  
ATOM    586  CA  GLY A  69       4.608  61.462  35.009  1.00 17.59           C  
ATOM    587  C   GLY A  69       5.488  62.654  34.675  1.00 17.54           C  
ATOM    588  O   GLY A  69       6.584  62.487  34.124  1.00 19.65           O  
ATOM    589  N   SER A  70       5.016  63.863  34.964  1.00 14.06           N  
ATOM    590  CA  SER A  70       5.830  65.064  34.712  1.00 16.28           C  
ATOM    591  C   SER A  70       6.677  65.274  35.973  1.00 17.09           C  
ATOM    592  O   SER A  70       6.212  65.871  36.922  1.00 16.55           O  
ATOM    593  CB  SER A  70       4.931  66.293  34.484  1.00 17.05           C  
ATOM    594  OG  SER A  70       5.693  67.500  34.379  1.00 19.73           O  
ATOM    595  N   GLU A  71       7.910  64.779  35.975  1.00 15.14           N  
ATOM    596  CA  GLU A  71       8.786  64.919  37.136  1.00 21.44           C  
ATOM    597  C   GLU A  71       8.934  66.374  37.564  1.00 20.31           C  
ATOM    598  O   GLU A  71       8.808  66.681  38.749  1.00 18.97           O  
ATOM    599  CB  GLU A  71      10.175  64.307  36.835  1.00 25.11           C  
ATOM    600  CG  GLU A  71      10.134  62.909  36.207  1.00 43.66           C  
ATOM    601  CD  GLU A  71      11.528  62.284  35.986  1.00 52.67           C  
ATOM    602  OE1 GLU A  71      12.432  62.974  35.446  1.00 49.05           O  
ATOM    603  OE2 GLU A  71      11.709  61.091  36.346  1.00 49.24           O  
ATOM    604  N   ALA A  72       9.172  67.284  36.614  1.00 19.83           N  
ATOM    605  CA  ALA A  72       9.339  68.693  36.988  1.00 17.10           C  
ATOM    606  C   ALA A  72       8.104  69.264  37.679  1.00 16.99           C  
ATOM    607  O   ALA A  72       8.225  70.033  38.635  1.00 20.35           O  
ATOM    608  CB  ALA A  72       9.677  69.550  35.762  1.00 18.83           C  
ATOM    609  N   CYS A  73       6.914  68.922  37.180  1.00 14.58           N  
ATOM    610  CA  CYS A  73       5.678  69.426  37.792  1.00 13.31           C  
ATOM    611  C   CYS A  73       5.397  68.750  39.138  1.00 13.51           C  
ATOM    612  O   CYS A  73       4.839  69.363  40.042  1.00 16.98           O  
ATOM    613  CB  CYS A  73       4.487  69.210  36.862  1.00 14.51           C  
ATOM    614  SG  CYS A  73       4.637  70.161  35.318  1.00 22.97           S  
ATOM    615  N   VAL A  74       5.744  67.480  39.276  1.00 16.28           N  
ATOM    616  CA  VAL A  74       5.511  66.844  40.575  1.00 15.18           C  
ATOM    617  C   VAL A  74       6.361  67.555  41.643  1.00 13.48           C  
ATOM    618  O   VAL A  74       5.862  67.919  42.732  1.00 15.06           O  
ATOM    619  CB  VAL A  74       5.899  65.353  40.568  1.00 17.08           C  
ATOM    620  CG1 VAL A  74       5.848  64.800  41.995  1.00 15.73           C  
ATOM    621  CG2 VAL A  74       4.934  64.566  39.690  1.00 14.15           C  
ATOM    622  N   LYS A  75       7.635  67.777  41.331  1.00 16.25           N  
ATOM    623  CA  LYS A  75       8.527  68.405  42.305  1.00 16.40           C  
ATOM    624  C   LYS A  75       8.087  69.832  42.605  1.00 17.85           C  
ATOM    625  O   LYS A  75       8.082  70.265  43.757  1.00 18.13           O  
ATOM    626  CB  LYS A  75       9.969  68.417  41.808  1.00 16.46           C  
ATOM    627  CG  LYS A  75      10.976  68.806  42.908  1.00 15.06           C  
ATOM    628  CD  LYS A  75      12.397  68.623  42.437  1.00 22.76           C  
ATOM    629  CE  LYS A  75      13.392  69.100  43.473  1.00 27.84           C  
ATOM    630  NZ  LYS A  75      14.731  69.279  42.847  1.00 31.11           N  
ATOM    631  N   ALA A  76       7.709  70.553  41.555  1.00 15.94           N  
ATOM    632  CA  ALA A  76       7.277  71.923  41.716  1.00 18.67           C  
ATOM    633  C   ALA A  76       6.011  72.027  42.581  1.00 20.45           C  
ATOM    634  O   ALA A  76       5.946  72.848  43.509  1.00 17.55           O  
ATOM    635  CB  ALA A  76       7.056  72.569  40.312  1.00 16.37           C  
HETATM  636  N   MSE A  77       5.003  71.199  42.299  1.00 17.59           N  
HETATM  637  CA  MSE A  77       3.772  71.275  43.079  1.00 19.00           C  
HETATM  638  C   MSE A  77       3.925  70.734  44.491  1.00 19.14           C  
HETATM  639  O   MSE A  77       3.199  71.149  45.396  1.00 19.19           O  
HETATM  640  CB  MSE A  77       2.622  70.556  42.358  1.00 18.74           C  
HETATM  641  CG  MSE A  77       2.222  71.229  41.029  1.00 18.84           C  
HETATM  642 SE   MSE A  77       1.706  73.085  41.268  1.00 27.26          SE  
HETATM  643  CE  MSE A  77       3.387  73.936  40.831  1.00 18.91           C  
ATOM    644  N   ALA A  78       4.851  69.805  44.693  1.00 17.24           N  
ATOM    645  CA  ALA A  78       5.069  69.278  46.034  1.00 19.20           C  
ATOM    646  C   ALA A  78       5.636  70.398  46.899  1.00 19.32           C  
ATOM    647  O   ALA A  78       5.222  70.589  48.038  1.00 20.89           O  
ATOM    648  CB  ALA A  78       6.043  68.108  45.994  1.00 21.70           C  
ATOM    649  N   HIS A  79       6.592  71.148  46.354  1.00 19.66           N  
ATOM    650  CA  HIS A  79       7.186  72.245  47.105  1.00 21.15           C  
ATOM    651  C   HIS A  79       6.212  73.406  47.262  1.00 22.22           C  
ATOM    652  O   HIS A  79       6.189  74.102  48.285  1.00 20.65           O  
ATOM    653  CB  HIS A  79       8.471  72.706  46.428  1.00 24.09           C  
ATOM    654  CG  HIS A  79       9.655  71.849  46.755  1.00 28.13           C  
ATOM    655  ND1 HIS A  79       9.910  70.645  46.122  1.00 28.12           N  
ATOM    656  CD2 HIS A  79      10.640  72.006  47.671  1.00 17.83           C  
ATOM    657  CE1 HIS A  79      11.003  70.102  46.634  1.00 21.47           C  
ATOM    658  NE2 HIS A  79      11.466  70.907  47.575  1.00 32.92           N  
ATOM    659  N   ARG A  80       5.401  73.612  46.236  1.00 21.96           N  
ATOM    660  CA  ARG A  80       4.395  74.657  46.273  1.00 20.90           C  
ATOM    661  C   ARG A  80       3.451  74.327  47.438  1.00 24.11           C  
ATOM    662  O   ARG A  80       3.139  75.178  48.287  1.00 18.18           O  
ATOM    663  CB  ARG A  80       3.632  74.652  44.949  1.00 23.63           C  
ATOM    664  CG  ARG A  80       2.387  75.528  44.902  1.00 28.06           C  
ATOM    665  CD  ARG A  80       2.725  76.995  44.976  1.00 30.89           C  
ATOM    666  NE  ARG A  80       1.530  77.796  44.738  1.00 32.63           N  
ATOM    667  CZ  ARG A  80       1.325  79.005  45.244  1.00 30.65           C  
ATOM    668  NH1 ARG A  80       2.249  79.560  46.029  1.00 23.40           N  
ATOM    669  NH2 ARG A  80       0.188  79.649  44.978  1.00 27.55           N  
ATOM    670  N   ALA A  81       3.013  73.073  47.488  1.00 19.13           N  
ATOM    671  CA  ALA A  81       2.100  72.618  48.549  1.00 22.82           C  
ATOM    672  C   ALA A  81       2.733  72.777  49.944  1.00 23.45           C  
ATOM    673  O   ALA A  81       2.068  73.207  50.900  1.00 25.32           O  
ATOM    674  CB  ALA A  81       1.684  71.119  48.292  1.00 16.81           C  
ATOM    675  N   LYS A  82       4.012  72.432  50.057  1.00 19.70           N  
ATOM    676  CA  LYS A  82       4.738  72.554  51.328  1.00 29.54           C  
ATOM    677  C   LYS A  82       4.758  74.020  51.790  1.00 29.46           C  
ATOM    678  O   LYS A  82       4.435  74.334  52.938  1.00 25.77           O  
ATOM    679  CB  LYS A  82       6.167  72.044  51.150  1.00 31.68           C  
ATOM    680  CG  LYS A  82       7.062  72.155  52.372  1.00 43.04           C  
ATOM    681  CD  LYS A  82       8.494  71.773  52.003  1.00 50.60           C  
ATOM    682  CE  LYS A  82       9.426  71.779  53.209  1.00 54.88           C  
ATOM    683  NZ  LYS A  82      10.810  71.395  52.792  1.00 56.31           N  
ATOM    684  N   ARG A  83       5.115  74.925  50.888  1.00 24.06           N  
ATOM    685  CA  ARG A  83       5.139  76.336  51.241  1.00 30.10           C  
ATOM    686  C   ARG A  83       3.764  76.883  51.595  1.00 30.36           C  
ATOM    687  O   ARG A  83       3.659  77.812  52.391  1.00 28.05           O  
ATOM    688  CB  ARG A  83       5.785  77.149  50.124  1.00 30.34           C  
ATOM    689  CG  ARG A  83       7.193  76.678  49.874  1.00 40.65           C  
ATOM    690  CD  ARG A  83       8.064  77.754  49.273  1.00 49.87           C  
ATOM    691  NE  ARG A  83       9.451  77.311  49.227  1.00 49.13           N  
ATOM    692  CZ  ARG A  83      10.490  78.101  49.463  1.00 52.07           C  
ATOM    693  NH1 ARG A  83      10.300  79.380  49.761  1.00 50.84           N  
ATOM    694  NH2 ARG A  83      11.721  77.607  49.407  1.00 55.31           N  
ATOM    695  N   LEU A  84       2.703  76.321  51.020  1.00 29.32           N  
ATOM    696  CA  LEU A  84       1.359  76.782  51.376  1.00 22.81           C  
ATOM    697  C   LEU A  84       0.906  76.121  52.682  1.00 20.93           C  
ATOM    698  O   LEU A  84      -0.139  76.465  53.234  1.00 26.06           O  
ATOM    699  CB  LEU A  84       0.358  76.449  50.268  1.00 28.91           C  
ATOM    700  CG  LEU A  84       0.459  77.282  48.987  1.00 29.47           C  
ATOM    701  CD1 LEU A  84      -0.479  76.712  47.945  1.00 25.30           C  
ATOM    702  CD2 LEU A  84       0.113  78.742  49.291  1.00 30.57           C  
ATOM    703  N   GLY A  85       1.682  75.157  53.165  1.00 24.24           N  
ATOM    704  CA  GLY A  85       1.309  74.474  54.391  1.00 27.75           C  
ATOM    705  C   GLY A  85       0.148  73.499  54.239  1.00 30.41           C  
ATOM    706  O   GLY A  85      -0.615  73.290  55.190  1.00 25.43           O  
ATOM    707  N   LEU A  86      -0.012  72.910  53.052  1.00 22.64           N  
ATOM    708  CA  LEU A  86      -1.089  71.929  52.847  1.00 21.79           C  
ATOM    709  C   LEU A  86      -0.758  70.741  53.755  1.00 18.59           C  
ATOM    710  O   LEU A  86       0.408  70.423  53.962  1.00 17.90           O  
ATOM    711  CB  LEU A  86      -1.155  71.497  51.376  1.00 16.54           C  
ATOM    712  CG  LEU A  86      -2.132  72.254  50.456  1.00 35.29           C  
ATOM    713  CD1 LEU A  86      -2.244  73.707  50.845  1.00 25.34           C  
ATOM    714  CD2 LEU A  86      -1.702  72.115  49.007  1.00 22.97           C  
ATOM    715  N   SER A  87      -1.779  70.068  54.270  1.00 17.74           N  
ATOM    716  CA  SER A  87      -1.552  68.972  55.220  1.00 21.08           C  
ATOM    717  C   SER A  87      -1.050  67.687  54.604  1.00 20.45           C  
ATOM    718  O   SER A  87      -1.319  67.381  53.448  1.00 20.99           O  
ATOM    719  CB  SER A  87      -2.837  68.664  56.006  1.00 23.76           C  
ATOM    720  OG  SER A  87      -3.822  68.034  55.189  1.00 22.05           O  
ATOM    721  N   LYS A  88      -0.327  66.924  55.402  1.00 18.44           N  
ATOM    722  CA  LYS A  88       0.187  65.650  54.944  1.00 22.50           C  
ATOM    723  C   LYS A  88      -0.980  64.760  54.501  1.00 26.00           C  
ATOM    724  O   LYS A  88      -0.899  64.108  53.469  1.00 21.64           O  
ATOM    725  CB  LYS A  88       0.971  64.968  56.069  1.00 27.13           C  
ATOM    726  CG  LYS A  88       1.359  63.535  55.772  1.00 24.30           C  
ATOM    727  CD  LYS A  88       2.274  62.973  56.856  1.00 27.90           C  
ATOM    728  CE  LYS A  88       2.499  61.481  56.634  1.00 25.91           C  
ATOM    729  NZ  LYS A  88       3.461  60.918  57.622  1.00 28.30           N  
ATOM    730  N   GLU A  89      -2.072  64.745  55.267  1.00 23.70           N  
ATOM    731  CA  GLU A  89      -3.209  63.889  54.902  1.00 26.21           C  
ATOM    732  C   GLU A  89      -3.834  64.280  53.562  1.00 23.55           C  
ATOM    733  O   GLU A  89      -4.302  63.416  52.826  1.00 18.44           O  
ATOM    734  CB  GLU A  89      -4.295  63.891  55.997  1.00 26.08           C  
ATOM    735  CG  GLU A  89      -3.945  63.069  57.261  1.00 25.81           C  
ATOM    736  CD  GLU A  89      -3.837  61.558  57.011  1.00 34.68           C  
ATOM    737  OE1 GLU A  89      -2.783  60.974  57.360  1.00 36.59           O  
ATOM    738  OE2 GLU A  89      -4.796  60.948  56.478  1.00 30.44           O  
ATOM    739  N   ALA A  90      -3.853  65.572  53.256  1.00 22.87           N  
ATOM    740  CA  ALA A  90      -4.418  66.043  51.984  1.00 22.19           C  
ATOM    741  C   ALA A  90      -3.498  65.642  50.821  1.00 22.22           C  
ATOM    742  O   ALA A  90      -3.964  65.230  49.752  1.00 20.48           O  
ATOM    743  CB  ALA A  90      -4.603  67.583  52.019  1.00 17.33           C  
ATOM    744  N   LEU A  91      -2.188  65.759  51.032  1.00 17.56           N  
ATOM    745  CA  LEU A  91      -1.226  65.417  49.983  1.00 20.36           C  
ATOM    746  C   LEU A  91      -1.218  63.920  49.716  1.00 18.70           C  
ATOM    747  O   LEU A  91      -1.175  63.485  48.562  1.00 17.97           O  
ATOM    748  CB  LEU A  91       0.174  65.919  50.363  1.00 15.43           C  
ATOM    749  CG  LEU A  91       0.266  67.450  50.333  1.00 21.06           C  
ATOM    750  CD1 LEU A  91       1.569  67.910  51.005  1.00 21.81           C  
ATOM    751  CD2 LEU A  91       0.220  67.922  48.868  1.00 16.76           C  
ATOM    752  N   LEU A  92      -1.281  63.125  50.783  1.00 14.95           N  
ATOM    753  CA  LEU A  92      -1.299  61.686  50.627  1.00 18.20           C  
ATOM    754  C   LEU A  92      -2.607  61.257  49.957  1.00 19.23           C  
ATOM    755  O   LEU A  92      -2.613  60.314  49.170  1.00 16.70           O  
ATOM    756  CB  LEU A  92      -1.156  61.004  51.996  1.00 20.16           C  
ATOM    757  CG  LEU A  92       0.075  60.158  52.366  1.00 32.27           C  
ATOM    758  CD1 LEU A  92       1.289  60.476  51.491  1.00 20.28           C  
ATOM    759  CD2 LEU A  92       0.387  60.363  53.864  1.00 24.70           C  
ATOM    760  N   GLU A  93      -3.723  61.924  50.268  1.00 18.50           N  
ATOM    761  CA  GLU A  93      -4.981  61.531  49.621  1.00 16.11           C  
ATOM    762  C   GLU A  93      -4.923  61.878  48.140  1.00 13.91           C  
ATOM    763  O   GLU A  93      -5.445  61.145  47.302  1.00 12.74           O  
ATOM    764  CB  GLU A  93      -6.195  62.205  50.261  1.00 15.49           C  
ATOM    765  CG  GLU A  93      -7.541  61.683  49.704  1.00 15.33           C  
ATOM    766  CD  GLU A  93      -8.718  62.013  50.620  1.00 22.90           C  
ATOM    767  OE1 GLU A  93      -8.713  61.564  51.791  1.00 23.89           O  
ATOM    768  OE2 GLU A  93      -9.640  62.721  50.171  1.00 25.21           O  
ATOM    769  N   THR A  94      -4.291  63.001  47.824  1.00 15.47           N  
ATOM    770  CA  THR A  94      -4.141  63.408  46.425  1.00 15.84           C  
ATOM    771  C   THR A  94      -3.328  62.343  45.679  1.00 16.95           C  
ATOM    772  O   THR A  94      -3.655  61.961  44.552  1.00 15.25           O  
ATOM    773  CB  THR A  94      -3.457  64.782  46.346  1.00 17.17           C  
ATOM    774  OG1 THR A  94      -4.303  65.734  47.003  1.00 18.26           O  
ATOM    775  CG2 THR A  94      -3.239  65.211  44.854  1.00 13.79           C  
ATOM    776  N   LEU A  95      -2.277  61.850  46.329  1.00 14.49           N  
ATOM    777  CA  LEU A  95      -1.442  60.805  45.736  1.00 14.99           C  
ATOM    778  C   LEU A  95      -2.274  59.535  45.496  1.00 17.98           C  
ATOM    779  O   LEU A  95      -2.185  58.919  44.427  1.00 13.34           O  
ATOM    780  CB  LEU A  95      -0.241  60.482  46.652  1.00 16.06           C  
ATOM    781  CG  LEU A  95       0.570  59.251  46.230  1.00 13.05           C  
ATOM    782  CD1 LEU A  95       1.137  59.459  44.787  1.00 12.96           C  
ATOM    783  CD2 LEU A  95       1.732  59.052  47.214  1.00 17.61           C  
ATOM    784  N   LYS A  96      -3.083  59.146  46.483  1.00 15.46           N  
ATOM    785  CA  LYS A  96      -3.934  57.967  46.336  1.00 13.98           C  
ATOM    786  C   LYS A  96      -4.929  58.156  45.194  1.00 13.68           C  
ATOM    787  O   LYS A  96      -5.254  57.213  44.477  1.00 15.42           O  
ATOM    788  CB  LYS A  96      -4.718  57.682  47.627  1.00 13.39           C  
ATOM    789  CG  LYS A  96      -3.846  57.193  48.803  1.00 16.10           C  
ATOM    790  CD  LYS A  96      -4.694  56.674  49.986  1.00 19.25           C  
ATOM    791  CE  LYS A  96      -5.590  57.750  50.597  1.00 26.21           C  
ATOM    792  NZ  LYS A  96      -6.479  57.183  51.692  1.00 25.60           N  
ATOM    793  N   ILE A  97      -5.416  59.384  45.034  1.00 14.84           N  
ATOM    794  CA  ILE A  97      -6.393  59.695  43.992  1.00 15.39           C  
ATOM    795  C   ILE A  97      -5.793  59.630  42.605  1.00 16.31           C  
ATOM    796  O   ILE A  97      -6.436  59.140  41.670  1.00 14.11           O  
ATOM    797  CB  ILE A  97      -7.015  61.101  44.223  1.00 12.48           C  
ATOM    798  CG1 ILE A  97      -7.965  61.050  45.436  1.00 14.63           C  
ATOM    799  CG2 ILE A  97      -7.769  61.563  42.996  1.00 13.37           C  
ATOM    800  CD1 ILE A  97      -8.483  62.444  45.896  1.00 15.91           C  
ATOM    801  N   ALA A  98      -4.562  60.118  42.472  1.00 11.65           N  
ATOM    802  CA  ALA A  98      -3.871  60.111  41.179  1.00 17.19           C  
ATOM    803  C   ALA A  98      -3.606  58.658  40.776  1.00 16.93           C  
ATOM    804  O   ALA A  98      -3.727  58.278  39.604  1.00 15.49           O  
ATOM    805  CB  ALA A  98      -2.559  60.880  41.283  1.00 15.75           C  
ATOM    806  N   ARG A  99      -3.231  57.850  41.762  1.00 14.48           N  
ATOM    807  CA  ARG A  99      -2.983  56.435  41.549  1.00 15.86           C  
ATOM    808  C   ARG A  99      -4.294  55.747  41.117  1.00 16.63           C  
ATOM    809  O   ARG A  99      -4.299  54.964  40.170  1.00 15.67           O  
ATOM    810  CB  ARG A  99      -2.427  55.814  42.841  1.00 13.62           C  
ATOM    811  CG  ARG A  99      -2.252  54.324  42.786  1.00 14.43           C  
ATOM    812  CD  ARG A  99      -1.425  53.854  44.011  1.00 12.85           C  
ATOM    813  NE  ARG A  99      -1.320  52.409  43.984  1.00 16.60           N  
ATOM    814  CZ  ARG A  99      -2.274  51.603  44.433  1.00 20.73           C  
ATOM    815  NH1 ARG A  99      -3.370  52.133  44.957  1.00 18.38           N  
ATOM    816  NH2 ARG A  99      -2.157  50.280  44.304  1.00 17.07           N  
ATOM    817  N   GLN A 100      -5.395  56.053  41.798  1.00 14.78           N  
ATOM    818  CA  GLN A 100      -6.712  55.484  41.451  1.00 16.16           C  
ATOM    819  C   GLN A 100      -7.150  55.897  40.039  1.00 13.43           C  
ATOM    820  O   GLN A 100      -7.700  55.093  39.273  1.00 15.11           O  
ATOM    821  CB  GLN A 100      -7.789  55.955  42.438  1.00 16.25           C  
ATOM    822  CG  GLN A 100      -9.183  55.336  42.173  1.00 15.99           C  
ATOM    823  CD  GLN A 100      -9.210  53.856  42.525  1.00 26.36           C  
ATOM    824  OE1 GLN A 100      -8.485  53.426  43.409  1.00 21.94           O  
ATOM    825  NE2 GLN A 100     -10.060  53.075  41.847  1.00 22.28           N  
ATOM    826  N   ALA A 101      -6.907  57.156  39.698  1.00 14.52           N  
ATOM    827  CA  ALA A 101      -7.298  57.679  38.387  1.00 12.70           C  
ATOM    828  C   ALA A 101      -6.652  56.909  37.256  1.00 14.30           C  
ATOM    829  O   ALA A 101      -7.313  56.551  36.267  1.00 15.98           O  
ATOM    830  CB  ALA A 101      -6.937  59.148  38.289  1.00 12.80           C  
ATOM    831  N   GLN A 102      -5.358  56.640  37.395  1.00 13.44           N  
ATOM    832  CA  GLN A 102      -4.644  55.896  36.363  1.00 13.47           C  
ATOM    833  C   GLN A 102      -5.186  54.461  36.274  1.00 15.81           C  
ATOM    834  O   GLN A 102      -5.283  53.890  35.185  1.00 16.75           O  
ATOM    835  CB  GLN A 102      -3.132  55.918  36.663  1.00 16.90           C  
ATOM    836  CG  GLN A 102      -2.487  57.285  36.417  1.00 13.90           C  
ATOM    837  CD  GLN A 102      -2.688  57.780  34.987  1.00 15.27           C  
ATOM    838  OE1 GLN A 102      -3.636  58.525  34.703  1.00 20.21           O  
ATOM    839  NE2 GLN A 102      -1.811  57.338  34.061  1.00 12.93           N  
ATOM    840  N   ALA A 103      -5.540  53.872  37.412  1.00 14.74           N  
ATOM    841  CA  ALA A 103      -6.104  52.521  37.408  1.00 17.68           C  
ATOM    842  C   ALA A 103      -7.503  52.575  36.751  1.00 14.15           C  
ATOM    843  O   ALA A 103      -7.861  51.714  35.923  1.00 13.77           O  
ATOM    844  CB  ALA A 103      -6.206  51.985  38.842  1.00 19.19           C  
ATOM    845  N   ASN A 104      -8.281  53.583  37.132  1.00 15.03           N  
ATOM    846  CA  ASN A 104      -9.615  53.796  36.570  1.00 14.09           C  
ATOM    847  C   ASN A 104      -9.557  53.864  35.047  1.00 14.80           C  
ATOM    848  O   ASN A 104     -10.382  53.289  34.359  1.00 17.26           O  
ATOM    849  CB  ASN A 104     -10.209  55.142  37.015  1.00 13.90           C  
ATOM    850  CG  ASN A 104     -10.607  55.161  38.461  1.00 16.34           C  
ATOM    851  OD1 ASN A 104     -10.634  54.127  39.125  1.00 19.06           O  
ATOM    852  ND2 ASN A 104     -10.928  56.347  38.960  1.00 16.15           N  
ATOM    853  N   ALA A 105      -8.604  54.621  34.526  1.00 14.89           N  
ATOM    854  CA  ALA A 105      -8.505  54.795  33.087  1.00 16.56           C  
ATOM    855  C   ALA A 105      -8.305  53.484  32.342  1.00 16.08           C  
ATOM    856  O   ALA A 105      -8.839  53.307  31.247  1.00 17.46           O  
ATOM    857  CB  ALA A 105      -7.390  55.775  32.758  1.00 13.35           C  
ATOM    858  N   VAL A 106      -7.531  52.566  32.924  1.00 15.11           N  
ATOM    859  CA  VAL A 106      -7.309  51.277  32.269  1.00 13.25           C  
ATOM    860  C   VAL A 106      -8.642  50.540  32.132  1.00 12.94           C  
ATOM    861  O   VAL A 106      -8.945  49.990  31.076  1.00 15.86           O  
ATOM    862  CB  VAL A 106      -6.310  50.419  33.058  1.00 15.24           C  
ATOM    863  CG1 VAL A 106      -6.219  49.030  32.448  1.00 14.75           C  
ATOM    864  CG2 VAL A 106      -4.934  51.081  33.024  1.00 13.81           C  
ATOM    865  N   LEU A 107      -9.449  50.540  33.189  1.00 13.67           N  
ATOM    866  CA  LEU A 107     -10.753  49.877  33.104  1.00 16.21           C  
ATOM    867  C   LEU A 107     -11.634  50.594  32.055  1.00 20.62           C  
ATOM    868  O   LEU A 107     -12.366  49.945  31.292  1.00 15.12           O  
ATOM    869  CB  LEU A 107     -11.454  49.856  34.485  1.00 16.02           C  
ATOM    870  CG  LEU A 107     -10.776  48.985  35.579  1.00 15.88           C  
ATOM    871  CD1 LEU A 107     -11.610  48.986  36.868  1.00 14.65           C  
ATOM    872  CD2 LEU A 107     -10.608  47.548  35.096  1.00 17.57           C  
ATOM    873  N   GLY A 108     -11.544  51.925  32.004  1.00 16.99           N  
ATOM    874  CA  GLY A 108     -12.335  52.671  31.043  1.00 16.90           C  
ATOM    875  C   GLY A 108     -11.943  52.357  29.606  1.00 20.76           C  
ATOM    876  O   GLY A 108     -12.755  52.489  28.700  1.00 19.65           O  
ATOM    877  N   HIS A 109     -10.698  51.930  29.407  1.00 14.82           N  
ATOM    878  CA  HIS A 109     -10.183  51.586  28.085  1.00 18.64           C  
ATOM    879  C   HIS A 109     -10.366  50.121  27.768  1.00 19.82           C  
ATOM    880  O   HIS A 109     -10.012  49.686  26.681  1.00 19.51           O  
ATOM    881  CB  HIS A 109      -8.680  51.870  27.990  1.00 17.10           C  
ATOM    882  CG  HIS A 109      -8.343  53.318  27.873  1.00 22.51           C  
ATOM    883  ND1 HIS A 109      -8.782  54.096  26.828  1.00 26.19           N  
ATOM    884  CD2 HIS A 109      -7.593  54.128  28.658  1.00 21.43           C  
ATOM    885  CE1 HIS A 109      -8.324  55.326  26.975  1.00 26.34           C  
ATOM    886  NE2 HIS A 109      -7.600  55.371  28.079  1.00 34.10           N  
ATOM    887  N   ALA A 110     -10.918  49.371  28.715  1.00 19.15           N  
ATOM    888  CA  ALA A 110     -11.083  47.932  28.578  1.00 19.36           C  
ATOM    889  C   ALA A 110     -12.355  47.423  27.898  1.00 17.70           C  
ATOM    890  O   ALA A 110     -12.498  46.228  27.710  1.00 18.00           O  
ATOM    891  CB  ALA A 110     -10.965  47.292  29.972  1.00 17.43           C  
ATOM    892  N   ALA A 111     -13.270  48.296  27.507  1.00 17.83           N  
ATOM    893  CA  ALA A 111     -14.502  47.780  26.903  1.00 22.92           C  
ATOM    894  C   ALA A 111     -14.330  46.831  25.717  1.00 20.33           C  
ATOM    895  O   ALA A 111     -14.947  45.760  25.686  1.00 25.60           O  
ATOM    896  CB  ALA A 111     -15.442  48.940  26.519  1.00 20.96           C  
ATOM    897  N   PRO A 112     -13.482  47.186  24.732  1.00 18.51           N  
ATOM    898  CA  PRO A 112     -13.316  46.289  23.578  1.00 21.96           C  
ATOM    899  C   PRO A 112     -12.848  44.892  23.954  1.00 22.55           C  
ATOM    900  O   PRO A 112     -13.143  43.927  23.259  1.00 24.05           O  
ATOM    901  CB  PRO A 112     -12.287  47.020  22.707  1.00 24.05           C  
ATOM    902  CG  PRO A 112     -12.504  48.477  23.059  1.00 27.95           C  
ATOM    903  CD  PRO A 112     -12.689  48.419  24.558  1.00 22.58           C  
ATOM    904  N   LEU A 113     -12.083  44.794  25.033  1.00 20.02           N  
ATOM    905  CA  LEU A 113     -11.591  43.508  25.498  1.00 20.98           C  
ATOM    906  C   LEU A 113     -12.726  42.806  26.225  1.00 23.01           C  
ATOM    907  O   LEU A 113     -13.028  41.644  25.936  1.00 22.83           O  
ATOM    908  CB  LEU A 113     -10.388  43.674  26.462  1.00 20.12           C  
ATOM    909  CG  LEU A 113      -9.971  42.423  27.276  1.00 20.84           C  
ATOM    910  CD1 LEU A 113      -9.561  41.273  26.342  1.00 16.90           C  
ATOM    911  CD2 LEU A 113      -8.796  42.781  28.183  1.00 18.84           C  
ATOM    912  N   LEU A 114     -13.353  43.508  27.167  1.00 19.56           N  
ATOM    913  CA  LEU A 114     -14.433  42.898  27.923  1.00 20.57           C  
ATOM    914  C   LEU A 114     -15.543  42.399  27.007  1.00 22.53           C  
ATOM    915  O   LEU A 114     -16.154  41.360  27.271  1.00 24.08           O  
ATOM    916  CB  LEU A 114     -15.003  43.879  28.955  1.00 19.83           C  
ATOM    917  CG  LEU A 114     -14.015  44.334  30.040  1.00 17.96           C  
ATOM    918  CD1 LEU A 114     -14.649  45.431  30.911  1.00 20.83           C  
ATOM    919  CD2 LEU A 114     -13.595  43.137  30.901  1.00 21.24           C  
ATOM    920  N   GLU A 115     -15.794  43.124  25.926  1.00 20.61           N  
ATOM    921  CA  GLU A 115     -16.853  42.725  25.002  1.00 28.95           C  
ATOM    922  C   GLU A 115     -16.673  41.345  24.389  1.00 29.85           C  
ATOM    923  O   GLU A 115     -17.654  40.694  24.049  1.00 27.40           O  
ATOM    924  CB  GLU A 115     -16.988  43.751  23.881  1.00 31.77           C  
ATOM    925  CG  GLU A 115     -17.621  45.025  24.349  1.00 44.60           C  
ATOM    926  CD  GLU A 115     -19.141  44.973  24.339  1.00 52.43           C  
ATOM    927  OE1 GLU A 115     -19.712  43.916  24.697  1.00 55.92           O  
ATOM    928  OE2 GLU A 115     -19.764  46.001  23.982  1.00 54.01           O  
ATOM    929  N   VAL A 116     -15.436  40.887  24.236  1.00 25.77           N  
ATOM    930  CA  VAL A 116     -15.225  39.579  23.626  1.00 30.63           C  
ATOM    931  C   VAL A 116     -15.062  38.403  24.586  1.00 32.11           C  
ATOM    932  O   VAL A 116     -14.808  37.280  24.141  1.00 30.60           O  
ATOM    933  CB  VAL A 116     -13.999  39.588  22.683  1.00 31.83           C  
ATOM    934  CG1 VAL A 116     -14.097  40.763  21.721  1.00 39.15           C  
ATOM    935  CG2 VAL A 116     -12.723  39.652  23.492  1.00 35.82           C  
ATOM    936  N   LEU A 117     -15.199  38.635  25.888  1.00 34.36           N  
ATOM    937  CA  LEU A 117     -15.060  37.536  26.842  1.00 34.56           C  
ATOM    938  C   LEU A 117     -16.368  36.761  27.064  1.00 40.83           C  
ATOM    939  O   LEU A 117     -17.430  37.196  26.562  1.00 36.47           O  
ATOM    940  CB  LEU A 117     -14.560  38.057  28.184  1.00 36.50           C  
ATOM    941  CG  LEU A 117     -13.310  38.928  28.227  1.00 31.40           C  
ATOM    942  CD1 LEU A 117     -13.052  39.311  29.681  1.00 31.03           C  
ATOM    943  CD2 LEU A 117     -12.107  38.181  27.656  1.00 31.05           C  
ATOM    944  OXT LEU A 117     -16.315  35.717  27.755  1.00 42.88           O  
TER     945      LEU A 117                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
