
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 1010),  selected  133 , name 2qeu_B
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 2qeu_B.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     8_B      -       -           -
LGA    S     9_B      -       -           -
LGA    Q    10_B      -       -           -
LGA    D    11_B      -       -           -
LGA    I    12_B      -       -           -
LGA    L    13_B      -       -           -
LGA    K    14_B      -       -           -
LGA    Q    15_B      -       -           -
LGA    H    16_B      -       -           -
LGA    A    17_B      -       -           -
LGA    A    18_B      -       -           -
LGA    H    19_B      -       -           -
LGA    Y    20_B      -       -           -
LGA    E    21_B      -       -           -
LGA    S    22_B      -       -           -
LGA    D    23_B      -       -           -
LGA    X    24_B      -       -           -
LGA    G    25_B      -       -           -
LGA    G    26_B      -       -           -
LGA    L    27_B      F       7          2.774
LGA    P    28_B      G       8          0.416
LGA    E    29_B      E       9          0.625
LGA    A    30_B      G      10          0.883
LGA    L    31_B      M      11          0.871
LGA    V    32_B      K      12          1.155
LGA    Q    33_B      V      13          1.385
LGA    L    34_B      V      14          1.784
LGA    A    35_B      K      15          1.934
LGA    E    36_B      E      16          2.277
LGA    Y    37_B      K      17          2.452
LGA    A    38_B      Y      18          2.736
LGA    P    39_B      P      19          2.458
LGA    E    40_B      D      20          2.327
LGA    T    41_B      L      21          2.032
LGA    F    42_B      Y      22          1.662
LGA    D    43_B      D      23          1.470
LGA    A    44_B      I      24          1.117
LGA    Y    45_B      I      25          1.214
LGA    S    46_B      V      26          1.045
LGA    R    47_B      K      27          0.574
LGA    X    48_B      L      28          0.444
LGA    R    49_B      N      29          0.235
LGA    T    50_B      D      30          0.814
LGA    T    51_B      T      31          1.214
LGA    X    52_B      V      32          1.457
LGA    L    53_B      F      33          1.997
LGA    K    54_B      T      34          3.241
LGA    S    55_B      -       -           -
LGA    E    56_B      -       -           -
LGA    A    57_B      -       -           -
LGA    D    58_B      -       -           -
LGA    G    59_B      G      35           #
LGA    A    60_B      K      36          5.213
LGA    K    61_B      T      37          2.786
LGA    L    62_B      L      38          1.812
LGA    P    63_B      D      39          2.556
LGA    L    64_B      Y      40          2.102
LGA    K    65_B      K      41          2.101
LGA    Y    66_B      T      42          2.012
LGA    K    67_B      Q      43          1.606
LGA    H    68_B      K      44          1.481
LGA    L    69_B      L      45          1.423
LGA    I    70_B      I      46          1.280
LGA    L    71_B      A      47          1.388
LGA    V    72_B      I      48          1.288
LGA    V    73_B      G      49          1.533
LGA    L    74_B      I      50          1.540
LGA    D    75_B      V      51          1.579
LGA    A    76_B      A      52          1.179
LGA    I    77_B      S      53          1.864
LGA    R    78_B      R      54          2.343
LGA    D    79_B      C      55          2.027
LGA    E    80_B      D      56          2.268
LGA    P    81_B      E      57          2.365
LGA    I    82_B      V      58          2.573
LGA    G    83_B      A      59          2.552
LGA    I    84_B      I      60          1.897
LGA    V    85_B      E      61          2.327
LGA    N    86_B      K      62          2.429
LGA    H    87_B      Q      63          2.042
LGA    T    88_B      M      64          1.644
LGA    R    89_B      K      65          2.592
LGA    A    90_B      S      66          2.909
LGA    A    91_B      A      67          2.402
LGA    X    92_B      M      68          2.442
LGA    N    93_B      K      69          3.651
LGA    -       -      E      70           -
LGA    A    94_B      L      71          1.570
LGA    G    95_B      G      72          3.309
LGA    L    96_B      I      73          2.227
LGA    S    97_B      T      74          2.389
LGA    V    98_B      K      75          1.873
LGA    D    99_B      E      76          1.536
LGA    E   100_B      E      77          1.616
LGA    L   101_B      I      78          0.966
LGA    I   102_B      A      79          0.321
LGA    E   103_B      D      80          1.016
LGA    G   104_B      V      81          0.806
LGA    I   105_B      L      82          1.076
LGA    L   106_B      R      83          1.773
LGA    L   107_B      V      84          0.848
LGA    G   108_B      V      85          0.969
LGA    I   109_B      L      86          1.429
LGA    I   110_B      L      87          1.426
LGA    V   111_B      T      88          1.699
LGA    Y   112_B      S      89          1.228
LGA    G   113_B      G      90          0.822
LGA    X   114_B      M      91          0.714
LGA    P   115_B      P      92          1.439
LGA    A   116_B      A      93          1.539
LGA    W   117_B      F      94          1.290
LGA    G   118_B      T      95          2.321
LGA    K   119_B      K      96          2.855
LGA    T   120_B      A      97          3.844
LGA    G   121_B      M      98          4.876
LGA    R   122_B      K      99          3.181
LGA    K   123_B      I     100          0.591
LGA    A   124_B      L     101          2.706
LGA    V   125_B      -       -           -
LGA    T   126_B      E     102          1.513
LGA    F   127_B      K     103          3.889
LGA    A   128_B      L     104          4.325
LGA    V   129_B      -       -           -
LGA    E   130_B      -       -           -
LGA    F   131_B      -       -           -
LGA    E   132_B      -       -           -
LGA    K   133_B      -       -           -
LGA    E   134_B      -       -           -
LGA    L   135_B      -       -           -
LGA    A   136_B      -       -           -
LGA    G   137_B      -       -           -
LGA    K   138_B      -       -           -
LGA    R   139_B      -       -           -
LGA    T   140_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133   98    5.0     96    2.10    19.79     79.653     4.368

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.007053 * X  +  -0.253629 * Y  +   0.967276 * Z  +   0.566382
  Y_new =  -0.999629 * X  +   0.027219 * Y  +  -0.000151 * Z  + 123.889610
  Z_new =  -0.026290 * X  +  -0.966919 * Y  +  -0.253727 * Z  +  28.957748 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.827418    1.314174  [ DEG:  -104.7034     75.2966 ]
  Theta =   0.026293    3.115299  [ DEG:     1.5065    178.4935 ]
  Phi   =  -1.577852    1.563741  [ DEG:   -90.4042     89.5958 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qeu_B                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qeu_B.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133   98   5.0   96   2.10   19.79  79.653
REMARK  ---------------------------------------------------------- 
MOLECULE 2qeu_B
HEADER    LYASE                                   26-JUN-07   2QEU              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE CARBOXYMUCONOLACTONE                    
TITLE    2 DECARBOXYLASE (YP_555818.1) FROM BURKHOLDERIA XENOVORANS             
TITLE    3 LB400 AT 1.65 A RESOLUTION                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE CARBOXYMUCONOLACTONE DECARBOXYLASE;               
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BURKHOLDERIA XENOVORANS LB400;                  
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: LB400;                                                       
SOURCE   5 GENE: YP_555818.1, BXENO_C0540, BXE_C0569;                           
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_555818.1, PUTATIVE CARBOXYMUCONOLACTONE DECARBOXYLASE,             
KEYWDS   2 CARBOXYMUCONOLACTONE DECARBOXYLASE FAMILY, STRUCTURAL                
KEYWDS   3 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   4 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   17-JUL-07 2QEU    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE CARBOXYMUCONOLACTONE           
JRNL        TITL 2 DECARBOXYLASE (YP_555818.1) FROM BURKHOLDERIA                
JRNL        TITL 3 XENOVORANS LB400 AT 1.65 A RESOLUTION                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  2QEU A    1   140  UNP    Q13HH1   Q13HH1_BURXL     1    140             
DBREF  2QEU B    1   140  UNP    Q13HH1   Q13HH1_BURXL     1    140             
DBREF  2QEU C    1   140  UNP    Q13HH1   Q13HH1_BURXL     1    140             
SEQRES   1 A  141  GLY MSE ASP GLN GLU SER ASN ALA THR SER GLN ASP ILE          
SEQRES   2 A  141  LEU LYS GLN HIS ALA ALA HIS TYR GLU SER ASP MSE GLY          
SEQRES   3 A  141  GLY LEU PRO GLU ALA LEU VAL GLN LEU ALA GLU TYR ALA          
SEQRES   4 A  141  PRO GLU THR PHE ASP ALA TYR SER ARG MSE ARG THR THR          
SEQRES   5 A  141  MSE LEU LYS SER GLU ALA ASP GLY ALA LYS LEU PRO LEU          
SEQRES   6 A  141  LYS TYR LYS HIS LEU ILE LEU VAL VAL LEU ASP ALA ILE          
SEQRES   7 A  141  ARG ASP GLU PRO ILE GLY ILE VAL ASN HIS THR ARG ALA          
SEQRES   8 A  141  ALA MSE ASN ALA GLY LEU SER VAL ASP GLU LEU ILE GLU          
SEQRES   9 A  141  GLY ILE LEU LEU GLY ILE ILE VAL TYR GLY MSE PRO ALA          
SEQRES  10 A  141  TRP GLY LYS THR GLY ARG LYS ALA VAL THR PHE ALA VAL          
SEQRES  11 A  141  GLU PHE GLU LYS GLU LEU ALA GLY LYS ARG THR                  
SEQRES   1 B  141  GLY MSE ASP GLN GLU SER ASN ALA THR SER GLN ASP ILE          
SEQRES   2 B  141  LEU LYS GLN HIS ALA ALA HIS TYR GLU SER ASP MSE GLY          
SEQRES   3 B  141  GLY LEU PRO GLU ALA LEU VAL GLN LEU ALA GLU TYR ALA          
SEQRES   4 B  141  PRO GLU THR PHE ASP ALA TYR SER ARG MSE ARG THR THR          
SEQRES   5 B  141  MSE LEU LYS SER GLU ALA ASP GLY ALA LYS LEU PRO LEU          
SEQRES   6 B  141  LYS TYR LYS HIS LEU ILE LEU VAL VAL LEU ASP ALA ILE          
SEQRES   7 B  141  ARG ASP GLU PRO ILE GLY ILE VAL ASN HIS THR ARG ALA          
SEQRES   8 B  141  ALA MSE ASN ALA GLY LEU SER VAL ASP GLU LEU ILE GLU          
SEQRES   9 B  141  GLY ILE LEU LEU GLY ILE ILE VAL TYR GLY MSE PRO ALA          
SEQRES  10 B  141  TRP GLY LYS THR GLY ARG LYS ALA VAL THR PHE ALA VAL          
SEQRES  11 B  141  GLU PHE GLU LYS GLU LEU ALA GLY LYS ARG THR                  
SEQRES   1 C  141  GLY MSE ASP GLN GLU SER ASN ALA THR SER GLN ASP ILE          
SEQRES   2 C  141  LEU LYS GLN HIS ALA ALA HIS TYR GLU SER ASP MSE GLY          
SEQRES   3 C  141  GLY LEU PRO GLU ALA LEU VAL GLN LEU ALA GLU TYR ALA          
SEQRES   4 C  141  PRO GLU THR PHE ASP ALA TYR SER ARG MSE ARG THR THR          
SEQRES   5 C  141  MSE LEU LYS SER GLU ALA ASP GLY ALA LYS LEU PRO LEU          
SEQRES   6 C  141  LYS TYR LYS HIS LEU ILE LEU VAL VAL LEU ASP ALA ILE          
SEQRES   7 C  141  ARG ASP GLU PRO ILE GLY ILE VAL ASN HIS THR ARG ALA          
SEQRES   8 C  141  ALA MSE ASN ALA GLY LEU SER VAL ASP GLU LEU ILE GLU          
SEQRES   9 C  141  GLY ILE LEU LEU GLY ILE ILE VAL TYR GLY MSE PRO ALA          
SEQRES  10 C  141  TRP GLY LYS THR GLY ARG LYS ALA VAL THR PHE ALA VAL          
SEQRES  11 C  141  GLU PHE GLU LYS GLU LEU ALA GLY LYS ARG THR                  
HET    MSE  A  24       8                                                       
HET    MSE  A  48       8                                                       
HET    MSE  A  52       8                                                       
HET    MSE  A  92       8                                                       
HET    MSE  A 114       8                                                       
HET    MSE  B  24       8                                                       
HET    MSE  B  48       8                                                       
HET    MSE  B  52       8                                                       
HET    MSE  B  92       8                                                       
HET    MSE  B 114       8                                                       
HET    MSE  C  24       8                                                       
HET    MSE  C  48       8                                                       
HET    MSE  C  52       8                                                       
HET    MSE  C  92       8                                                       
HET    MSE  C 114       8                                                       
HET    ACT      1       4                                                       
HET    ACT      2       4                                                       
HET    ACT      3       4                                                       
HET    ACT      4       4                                                       
HET    ACT      5       4                                                       
HET    ACT      6       4                                                       
HET    ACT      7       4                                                       
HET    CIT      8      13                                                       
HET    CIT      9      13                                                       
HET    CIT     10      13                                                       
HET    GOL     11       6                                                       
HET    GOL     12       6                                                       
HET    GOL     13      12                                                       
HET    GOL     14      12                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACT ACETATE ION                                                      
HETNAM     CIT CITRIC ACID                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    15(C5 H11 N O2 SE)                                           
FORMUL   4  ACT    7(C2 H3 O2 1-)                                               
FORMUL  11  CIT    3(C6 H8 O7)                                                  
FORMUL  14  GOL    4(C3 H8 O3)                                                  
FORMUL  18  HOH   *410(H2 O)                                                    
CRYST1   71.173   71.173  325.501  90.00  90.00 120.00 P 61 2 2     36          
ATOM   1086  N   THR B   8      15.895  92.604  28.988  1.00 40.36           N  
ATOM   1087  CA  THR B   8      15.845  91.530  27.939  1.00 41.76           C  
ATOM   1088  C   THR B   8      14.961  90.343  28.423  1.00 41.60           C  
ATOM   1089  O   THR B   8      13.770  90.528  28.717  1.00 42.27           O  
ATOM   1090  CB  THR B   8      17.292  91.067  27.563  1.00 41.98           C  
ATOM   1091  N   SER B   9      15.529  89.133  28.491  1.00 39.18           N  
ATOM   1092  CA  SER B   9      15.038  88.124  29.432  1.00 37.39           C  
ATOM   1093  C   SER B   9      15.004  88.724  30.854  1.00 35.89           C  
ATOM   1094  O   SER B   9      14.137  88.366  31.664  1.00 35.90           O  
ATOM   1095  CB  SER B   9      15.936  86.864  29.466  1.00 37.36           C  
ATOM   1096  OG  SER B   9      16.079  86.225  28.205  1.00 35.44           O  
ATOM   1097  N   GLN B  10      15.968  89.609  31.142  1.00 34.00           N  
ATOM   1098  CA  GLN B  10      16.111  90.254  32.456  1.00 32.71           C  
ATOM   1099  C   GLN B  10      14.850  91.012  32.893  1.00 31.93           C  
ATOM   1100  O   GLN B  10      14.434  90.903  34.057  1.00 31.84           O  
ATOM   1101  CB  GLN B  10      17.324  91.200  32.464  1.00 31.56           C  
ATOM   1102  N   ASP B  11      14.251  91.769  31.967  1.00 31.18           N  
ATOM   1103  CA  ASP B  11      13.048  92.571  32.270  1.00 31.35           C  
ATOM   1104  C   ASP B  11      11.811  91.689  32.457  1.00 29.28           C  
ATOM   1105  O   ASP B  11      11.001  91.923  33.363  1.00 28.49           O  
ATOM   1106  CB  ASP B  11      12.788  93.641  31.189  1.00 33.43           C  
ATOM   1107  N   ILE B  12      11.674  90.673  31.606  1.00 27.47           N  
ATOM   1108  CA  ILE B  12      10.559  89.717  31.727  1.00 25.81           C  
ATOM   1109  C   ILE B  12      10.645  88.897  33.038  1.00 25.45           C  
ATOM   1110  O   ILE B  12       9.621  88.654  33.695  1.00 24.35           O  
ATOM   1111  CB  ILE B  12      10.457  88.802  30.481  1.00 27.00           C  
ATOM   1112  CG1 ILE B  12      10.018  89.637  29.264  1.00 23.19           C  
ATOM   1113  CG2 ILE B  12       9.469  87.630  30.734  1.00 14.17           C  
ATOM   1114  CD1 ILE B  12      10.114  88.893  27.941  1.00 28.23           C  
ATOM   1115  N   LEU B  13      11.861  88.506  33.427  1.00 23.08           N  
ATOM   1116  CA  LEU B  13      12.073  87.831  34.711  1.00 21.88           C  
ATOM   1117  C   LEU B  13      11.669  88.718  35.881  1.00 22.50           C  
ATOM   1118  O   LEU B  13      11.001  88.265  36.819  1.00 23.65           O  
ATOM   1119  CB  LEU B  13      13.538  87.388  34.845  1.00 23.54           C  
ATOM   1120  CG  LEU B  13      13.841  86.087  34.084  1.00 21.55           C  
ATOM   1121  CD1 LEU B  13      15.305  86.050  33.676  1.00 24.70           C  
ATOM   1122  CD2 LEU B  13      13.450  84.872  34.918  1.00 18.07           C  
ATOM   1123  N   LYS B  14      12.077  89.987  35.814  1.00 19.74           N  
ATOM   1124  CA  LYS B  14      11.702  90.962  36.839  1.00 20.89           C  
ATOM   1125  C   LYS B  14      10.171  91.072  36.934  1.00 21.23           C  
ATOM   1126  O   LYS B  14       9.612  91.118  38.042  1.00 22.50           O  
ATOM   1127  CB  LYS B  14      12.360  92.351  36.573  1.00 18.67           C  
ATOM   1128  N   GLN B  15       9.498  91.089  35.781  1.00 23.67           N  
ATOM   1129  CA  GLN B  15       8.034  91.175  35.737  1.00 26.09           C  
ATOM   1130  C   GLN B  15       7.305  90.078  36.536  1.00 24.63           C  
ATOM   1131  O   GLN B  15       6.228  90.317  37.107  1.00 24.19           O  
ATOM   1132  CB  GLN B  15       7.533  91.110  34.292  1.00 26.63           C  
ATOM   1133  CG  GLN B  15       7.138  92.437  33.682  1.00 34.47           C  
ATOM   1134  CD  GLN B  15       6.396  92.260  32.360  1.00 34.88           C  
ATOM   1135  OE1 GLN B  15       5.766  91.212  32.100  1.00 49.87           O  
ATOM   1136  NE2 GLN B  15       6.457  93.287  31.521  1.00 50.80           N  
ATOM   1137  N   HIS B  16       7.865  88.873  36.551  1.00 21.37           N  
ATOM   1138  CA  HIS B  16       7.142  87.729  37.089  1.00 18.50           C  
ATOM   1139  C   HIS B  16       7.778  87.169  38.339  1.00 19.02           C  
ATOM   1140  O   HIS B  16       7.286  86.188  38.888  1.00 18.71           O  
ATOM   1141  CB  HIS B  16       7.062  86.652  36.015  1.00 16.20           C  
ATOM   1142  CG  HIS B  16       6.286  87.076  34.812  1.00 14.72           C  
ATOM   1143  ND1 HIS B  16       4.928  87.327  34.858  1.00 19.56           N  
ATOM   1144  CD2 HIS B  16       6.668  87.313  33.533  1.00 17.26           C  
ATOM   1145  CE1 HIS B  16       4.504  87.679  33.655  1.00 15.54           C  
ATOM   1146  NE2 HIS B  16       5.537  87.666  32.831  1.00  9.14           N  
ATOM   1147  N   ALA B  17       8.845  87.803  38.818  1.00 17.14           N  
ATOM   1148  CA  ALA B  17       9.583  87.267  39.962  1.00 17.97           C  
ATOM   1149  C   ALA B  17       8.712  87.160  41.232  1.00 18.45           C  
ATOM   1150  O   ALA B  17       8.790  86.158  41.968  1.00 16.51           O  
ATOM   1151  CB  ALA B  17      10.850  88.099  40.235  1.00 17.98           C  
ATOM   1152  N   ALA B  18       7.876  88.172  41.475  1.00 18.13           N  
ATOM   1153  CA  ALA B  18       6.993  88.184  42.660  1.00 19.11           C  
ATOM   1154  C   ALA B  18       5.981  87.016  42.639  1.00 19.96           C  
ATOM   1155  O   ALA B  18       5.681  86.405  43.675  1.00 19.89           O  
ATOM   1156  CB  ALA B  18       6.275  89.519  42.769  1.00 17.96           C  
ATOM   1157  N   HIS B  19       5.465  86.712  41.452  1.00 19.98           N  
ATOM   1158  CA  HIS B  19       4.572  85.568  41.273  1.00 20.42           C  
ATOM   1159  C   HIS B  19       5.251  84.252  41.673  1.00 19.66           C  
ATOM   1160  O   HIS B  19       4.701  83.475  42.463  1.00 18.41           O  
ATOM   1161  CB  HIS B  19       4.056  85.469  39.819  1.00 22.08           C  
ATOM   1162  CG  HIS B  19       3.388  84.159  39.517  1.00 23.06           C  
ATOM   1163  ND1 HIS B  19       2.214  83.764  40.126  1.00 16.01           N  
ATOM   1164  CD2 HIS B  19       3.749  83.141  38.701  1.00 21.04           C  
ATOM   1165  CE1 HIS B  19       1.874  82.564  39.685  1.00 16.90           C  
ATOM   1166  NE2 HIS B  19       2.785  82.165  38.815  1.00 20.99           N  
ATOM   1167  N   TYR B  20       6.434  83.994  41.117  1.00 18.48           N  
ATOM   1168  CA  TYR B  20       7.114  82.724  41.369  1.00 17.43           C  
ATOM   1169  C   TYR B  20       7.626  82.602  42.808  1.00 17.69           C  
ATOM   1170  O   TYR B  20       7.580  81.511  43.391  1.00 16.88           O  
ATOM   1171  CB  TYR B  20       8.217  82.474  40.342  1.00 18.42           C  
ATOM   1172  CG  TYR B  20       7.680  82.170  38.957  1.00 17.38           C  
ATOM   1173  CD1 TYR B  20       7.082  80.948  38.695  1.00 18.22           C  
ATOM   1174  CD2 TYR B  20       7.764  83.103  37.912  1.00 16.85           C  
ATOM   1175  CE1 TYR B  20       6.580  80.655  37.457  1.00 15.46           C  
ATOM   1176  CE2 TYR B  20       7.273  82.814  36.645  1.00 13.16           C  
ATOM   1177  CZ  TYR B  20       6.677  81.558  36.418  1.00 17.51           C  
ATOM   1178  OH  TYR B  20       6.148  81.168  35.183  1.00 15.36           O  
ATOM   1179  N   GLU B  21       8.085  83.704  43.403  0.50 18.15           N  
ATOM   1181  CA  GLU B  21       8.516  83.626  44.789  0.50 19.18           C  
ATOM   1183  C   GLU B  21       7.326  83.323  45.694  0.50 18.53           C  
ATOM   1185  O   GLU B  21       7.419  82.480  46.589  0.50 20.25           O  
ATOM   1187  CB  GLU B  21       9.208  84.918  45.227  0.50 20.43           C  
ATOM   1189  CG  GLU B  21      10.546  85.186  44.513  0.50 26.94           C  
ATOM   1191  CD  GLU B  21      11.634  84.163  44.817  0.50 23.22           C  
ATOM   1193  OE1 GLU B  21      11.517  83.413  45.808  0.50 36.33           O  
ATOM   1195  OE2 GLU B  21      12.624  84.127  44.067  0.50 24.38           O  
ATOM   1197  N   SER B  22       6.204  83.996  45.438  1.00 16.48           N  
ATOM   1198  CA  SER B  22       5.003  83.843  46.241  1.00 18.24           C  
ATOM   1199  C   SER B  22       4.410  82.457  46.088  1.00 18.95           C  
ATOM   1200  O   SER B  22       4.156  81.745  47.069  1.00 19.21           O  
ATOM   1201  CB  SER B  22       3.976  84.880  45.796  1.00 19.45           C  
ATOM   1202  OG  SER B  22       2.782  84.764  46.537  1.00 30.60           O  
ATOM   1203  N   ASP B  23       4.248  82.064  44.837  1.00 16.42           N  
ATOM   1204  CA  ASP B  23       3.562  80.822  44.540  1.00 17.83           C  
ATOM   1205  C   ASP B  23       4.416  79.600  44.790  1.00 18.11           C  
ATOM   1206  O   ASP B  23       3.923  78.600  45.377  1.00 16.28           O  
ATOM   1207  CB  ASP B  23       3.101  80.803  43.097  1.00 15.89           C  
ATOM   1208  CG  ASP B  23       2.159  79.657  42.837  1.00 16.78           C  
ATOM   1209  OD1 ASP B  23       1.083  79.622  43.514  1.00 11.64           O  
ATOM   1210  OD2 ASP B  23       2.536  78.823  41.991  1.00 16.01           O  
HETATM 1211  N   MSE B  24       5.677  79.689  44.343  1.00 16.06           N  
HETATM 1212  CA  MSE B  24       6.601  78.545  44.289  1.00 17.10           C  
HETATM 1213  C   MSE B  24       7.875  78.634  45.118  1.00 17.90           C  
HETATM 1214  O   MSE B  24       8.638  77.659  45.176  1.00 22.11           O  
HETATM 1215  CB  MSE B  24       6.984  78.250  42.813  1.00 17.30           C  
HETATM 1216  CG  MSE B  24       5.790  77.968  41.921  1.00 18.81           C  
HETATM 1217 SE   MSE B  24       5.120  76.129  42.194  0.75 18.57          SE  
HETATM 1218  CE  MSE B  24       6.338  75.179  40.997  1.00 15.21           C  
ATOM   1219  N   GLY B  25       8.125  79.778  45.765  1.00 17.96           N  
ATOM   1220  CA  GLY B  25       9.382  79.958  46.467  1.00 18.66           C  
ATOM   1221  C   GLY B  25      10.579  80.130  45.552  1.00 19.88           C  
ATOM   1222  O   GLY B  25      11.713  79.965  46.000  1.00 25.49           O  
ATOM   1223  N   GLY B  26      10.343  80.506  44.295  1.00 18.09           N  
ATOM   1224  CA  GLY B  26      11.406  80.656  43.292  1.00 16.68           C  
ATOM   1225  C   GLY B  26      11.018  80.101  41.903  1.00 18.05           C  
ATOM   1226  O   GLY B  26       9.929  79.527  41.716  1.00 18.13           O  
ATOM   1227  N   LEU B  27      11.908  80.319  40.928  1.00 16.24           N  
ATOM   1228  CA  LEU B  27      11.677  79.918  39.534  1.00 18.54           C  
ATOM   1229  C   LEU B  27      12.325  78.557  39.236  1.00 17.08           C  
ATOM   1230  O   LEU B  27      13.538  78.406  39.292  1.00 14.92           O  
ATOM   1231  CB  LEU B  27      12.223  80.993  38.581  1.00 18.69           C  
ATOM   1232  CG  LEU B  27      11.843  80.894  37.105  1.00 13.74           C  
ATOM   1233  CD1 LEU B  27      10.333  80.994  36.971  1.00 15.29           C  
ATOM   1234  CD2 LEU B  27      12.543  81.944  36.260  1.00 19.51           C  
ATOM   1235  N   PRO B  28      11.518  77.544  38.877  1.00 19.01           N  
ATOM   1236  CA  PRO B  28      12.171  76.283  38.515  1.00 20.69           C  
ATOM   1237  C   PRO B  28      13.169  76.385  37.363  1.00 19.33           C  
ATOM   1238  O   PRO B  28      13.012  77.227  36.485  1.00 21.05           O  
ATOM   1239  CB  PRO B  28      10.995  75.386  38.116  1.00 22.09           C  
ATOM   1240  CG  PRO B  28       9.782  75.995  38.822  1.00 24.95           C  
ATOM   1241  CD  PRO B  28      10.049  77.465  38.869  1.00 20.07           C  
ATOM   1242  N   GLU B  29      14.194  75.530  37.372  1.00 19.14           N  
ATOM   1243  CA  GLU B  29      15.254  75.537  36.338  1.00 20.52           C  
ATOM   1244  C   GLU B  29      14.752  75.439  34.903  1.00 18.00           C  
ATOM   1245  O   GLU B  29      15.284  76.093  34.004  1.00 16.51           O  
ATOM   1246  CB  GLU B  29      16.242  74.380  36.563  1.00 23.91           C  
ATOM   1247  CG  GLU B  29      17.466  74.367  35.639  1.00 23.02           C  
ATOM   1248  N   ALA B  30      13.753  74.603  34.673  1.00 17.66           N  
ATOM   1249  CA  ALA B  30      13.167  74.495  33.336  1.00 18.85           C  
ATOM   1250  C   ALA B  30      12.678  75.862  32.880  1.00 16.25           C  
ATOM   1251  O   ALA B  30      12.834  76.211  31.719  1.00 16.97           O  
ATOM   1252  CB  ALA B  30      12.022  73.486  33.293  1.00 16.96           C  
ATOM   1253  N   LEU B  31      12.052  76.617  33.789  1.00 16.57           N  
ATOM   1254  CA  LEU B  31      11.513  77.934  33.424  1.00 13.88           C  
ATOM   1255  C   LEU B  31      12.622  79.010  33.346  1.00 12.92           C  
ATOM   1256  O   LEU B  31      12.537  79.930  32.554  1.00 12.10           O  
ATOM   1257  CB  LEU B  31      10.376  78.335  34.378  1.00 12.39           C  
ATOM   1258  CG  LEU B  31       9.080  77.516  34.289  1.00 13.17           C  
ATOM   1259  CD1 LEU B  31       8.057  77.955  35.382  1.00 17.21           C  
ATOM   1260  CD2 LEU B  31       8.496  77.618  32.910  1.00 14.57           C  
ATOM   1261  N   VAL B  32      13.679  78.864  34.140  1.00 14.77           N  
ATOM   1262  CA  VAL B  32      14.888  79.664  33.960  1.00 14.14           C  
ATOM   1263  C   VAL B  32      15.400  79.532  32.531  1.00 12.71           C  
ATOM   1264  O   VAL B  32      15.659  80.534  31.853  1.00 14.12           O  
ATOM   1265  CB  VAL B  32      16.027  79.278  34.946  1.00 15.46           C  
ATOM   1266  CG1 VAL B  32      17.317  80.027  34.604  1.00 15.73           C  
ATOM   1267  CG2 VAL B  32      15.592  79.543  36.387  1.00 18.88           C  
ATOM   1268  N   GLN B  33      15.509  78.284  32.063  0.50 12.94           N  
ATOM   1270  CA  GLN B  33      15.983  77.996  30.702  0.50 12.13           C  
ATOM   1272  C   GLN B  33      15.017  78.564  29.664  0.50 10.25           C  
ATOM   1274  O   GLN B  33      15.456  79.158  28.693  0.50 11.64           O  
ATOM   1276  CB  GLN B  33      16.213  76.472  30.459  0.50  9.96           C  
ATOM   1278  CG  GLN B  33      17.499  76.182  29.620  0.50 16.46           C  
ATOM   1280  CD  GLN B  33      17.572  74.752  29.013  0.50 13.54           C  
ATOM   1282  OE1 GLN B  33      17.222  73.775  29.664  0.50 10.26           O  
ATOM   1284  NE2 GLN B  33      18.083  74.644  27.791  0.50 12.48           N  
ATOM   1286  N   LEU B  34      13.710  78.392  29.884  1.00 10.64           N  
ATOM   1287  CA  LEU B  34      12.691  78.946  28.979  1.00  9.12           C  
ATOM   1288  C   LEU B  34      12.847  80.473  28.894  1.00  7.22           C  
ATOM   1289  O   LEU B  34      12.751  81.043  27.823  1.00  9.27           O  
ATOM   1290  CB  LEU B  34      11.280  78.672  29.451  1.00  9.57           C  
ATOM   1291  CG  LEU B  34      10.177  78.960  28.399  1.00 12.36           C  
ATOM   1292  CD1 LEU B  34      10.218  77.915  27.279  1.00 10.84           C  
ATOM   1293  CD2 LEU B  34       8.789  79.008  29.079  1.00 10.39           C  
ATOM   1294  N   ALA B  35      13.065  81.117  30.038  1.00  9.48           N  
ATOM   1295  CA  ALA B  35      13.264  82.570  30.058  1.00 10.94           C  
ATOM   1296  C   ALA B  35      14.466  82.962  29.222  1.00 13.15           C  
ATOM   1297  O   ALA B  35      14.420  83.947  28.477  1.00 12.60           O  
ATOM   1298  CB  ALA B  35      13.421  83.086  31.495  1.00  8.97           C  
ATOM   1299  N   GLU B  36      15.539  82.185  29.327  1.00 12.33           N  
ATOM   1300  CA  GLU B  36      16.744  82.470  28.558  1.00 14.29           C  
ATOM   1301  C   GLU B  36      16.533  82.364  27.049  1.00 12.26           C  
ATOM   1302  O   GLU B  36      16.877  83.283  26.296  1.00 12.57           O  
ATOM   1303  CB  GLU B  36      17.876  81.542  28.993  1.00 13.95           C  
ATOM   1304  CG  GLU B  36      19.134  81.676  28.149  1.00 21.32           C  
ATOM   1305  CD  GLU B  36      20.344  80.967  28.749  1.00 23.42           C  
ATOM   1306  OE1 GLU B  36      20.143  80.004  29.561  1.00 42.10           O  
ATOM   1307  OE2 GLU B  36      21.483  81.379  28.386  1.00 39.38           O  
ATOM   1308  N   TYR B  37      15.958  81.254  26.609  1.00 11.84           N  
ATOM   1309  CA  TYR B  37      15.886  80.895  25.198  1.00 10.45           C  
ATOM   1310  C   TYR B  37      14.631  81.294  24.459  1.00 12.44           C  
ATOM   1311  O   TYR B  37      14.619  81.308  23.220  1.00 14.03           O  
ATOM   1312  CB  TYR B  37      16.071  79.384  25.086  1.00 11.94           C  
ATOM   1313  CG  TYR B  37      17.475  78.957  25.410  1.00 15.06           C  
ATOM   1314  CD1 TYR B  37      18.526  79.383  24.645  1.00 17.99           C  
ATOM   1315  CD2 TYR B  37      17.728  78.092  26.456  1.00 19.51           C  
ATOM   1316  CE1 TYR B  37      19.833  78.992  24.926  1.00 22.56           C  
ATOM   1317  CE2 TYR B  37      19.018  77.689  26.748  1.00 23.82           C  
ATOM   1318  CZ  TYR B  37      20.060  78.139  25.980  1.00 22.29           C  
ATOM   1319  OH  TYR B  37      21.344  77.736  26.262  1.00 32.68           O  
ATOM   1320  N   ALA B  38      13.569  81.579  25.210  1.00 12.59           N  
ATOM   1321  CA  ALA B  38      12.246  81.839  24.652  1.00 10.15           C  
ATOM   1322  C   ALA B  38      11.566  82.883  25.571  1.00 11.03           C  
ATOM   1323  O   ALA B  38      10.530  82.593  26.191  1.00 11.35           O  
ATOM   1324  CB  ALA B  38      11.436  80.550  24.580  1.00  9.56           C  
ATOM   1325  N   PRO B  39      12.162  84.089  25.688  1.00  9.45           N  
ATOM   1326  CA  PRO B  39      11.629  85.025  26.705  1.00  9.39           C  
ATOM   1327  C   PRO B  39      10.168  85.512  26.450  1.00  9.46           C  
ATOM   1328  O   PRO B  39       9.394  85.709  27.424  1.00 11.35           O  
ATOM   1329  CB  PRO B  39      12.619  86.190  26.666  1.00 12.20           C  
ATOM   1330  CG  PRO B  39      13.243  86.106  25.346  1.00 13.75           C  
ATOM   1331  CD  PRO B  39      13.304  84.675  24.957  1.00  8.34           C  
ATOM   1332  N   GLU B  40       9.779  85.649  25.178  1.00  8.32           N  
ATOM   1333  CA  GLU B  40       8.382  85.986  24.865  1.00 12.89           C  
ATOM   1334  C   GLU B  40       7.420  84.874  25.243  1.00 12.90           C  
ATOM   1335  O   GLU B  40       6.320  85.135  25.706  1.00 12.77           O  
ATOM   1336  CB  GLU B  40       8.181  86.322  23.390  1.00 13.67           C  
ATOM   1337  CG  GLU B  40       8.974  87.488  22.881  1.00 18.91           C  
ATOM   1338  CD  GLU B  40       8.653  87.869  21.425  1.00 22.33           C  
ATOM   1339  OE1 GLU B  40       8.204  87.027  20.601  1.00 33.23           O  
ATOM   1340  OE2 GLU B  40       8.867  89.048  21.092  1.00 36.61           O  
ATOM   1341  N   THR B  41       7.819  83.624  25.020  1.00 10.71           N  
ATOM   1342  CA  THR B  41       7.020  82.461  25.483  1.00 10.27           C  
ATOM   1343  C   THR B  41       6.954  82.391  26.999  1.00 10.30           C  
ATOM   1344  O   THR B  41       5.882  82.180  27.558  1.00 11.05           O  
ATOM   1345  CB  THR B  41       7.489  81.102  24.853  1.00 11.93           C  
ATOM   1346  OG1 THR B  41       7.061  81.075  23.488  1.00 15.86           O  
ATOM   1347  CG2 THR B  41       6.913  79.864  25.616  1.00 12.80           C  
ATOM   1348  N   PHE B  42       8.081  82.622  27.667  1.00  8.46           N  
ATOM   1349  CA  PHE B  42       8.117  82.621  29.112  1.00  8.71           C  
ATOM   1350  C   PHE B  42       7.173  83.707  29.663  1.00  8.75           C  
ATOM   1351  O   PHE B  42       6.456  83.452  30.605  1.00  9.10           O  
ATOM   1352  CB  PHE B  42       9.558  82.815  29.627  1.00  9.47           C  
ATOM   1353  CG  PHE B  42       9.650  83.077  31.117  1.00  8.02           C  
ATOM   1354  CD1 PHE B  42       9.502  82.052  32.038  1.00 12.50           C  
ATOM   1355  CD2 PHE B  42       9.898  84.365  31.592  1.00 12.05           C  
ATOM   1356  CE1 PHE B  42       9.567  82.288  33.391  1.00 11.52           C  
ATOM   1357  CE2 PHE B  42       9.957  84.613  32.948  1.00 18.05           C  
ATOM   1358  CZ  PHE B  42       9.793  83.581  33.856  1.00 12.80           C  
ATOM   1359  N   ASP B  43       7.153  84.889  29.039  1.00 10.53           N  
ATOM   1360  CA  ASP B  43       6.305  86.007  29.507  1.00 10.08           C  
ATOM   1361  C   ASP B  43       4.822  85.622  29.393  1.00 11.52           C  
ATOM   1362  O   ASP B  43       4.104  85.713  30.371  1.00 10.49           O  
ATOM   1363  CB  ASP B  43       6.611  87.314  28.746  1.00 11.78           C  
ATOM   1364  CG  ASP B  43       5.831  88.513  29.293  1.00 15.23           C  
ATOM   1365  OD1 ASP B  43       5.655  88.661  30.532  1.00 20.09           O  
ATOM   1366  OD2 ASP B  43       5.417  89.332  28.459  1.00 24.18           O  
ATOM   1367  N   ALA B  44       4.388  85.144  28.220  1.00 11.35           N  
ATOM   1368  CA  ALA B  44       2.968  84.799  27.996  1.00 12.33           C  
ATOM   1369  C   ALA B  44       2.531  83.658  28.910  1.00 14.18           C  
ATOM   1370  O   ALA B  44       1.494  83.726  29.562  1.00 11.56           O  
ATOM   1371  CB  ALA B  44       2.708  84.452  26.545  1.00 11.07           C  
ATOM   1372  N   TYR B  45       3.363  82.633  28.991  1.00 13.47           N  
ATOM   1373  CA  TYR B  45       3.151  81.508  29.909  1.00 11.77           C  
ATOM   1374  C   TYR B  45       3.050  81.978  31.348  1.00 10.65           C  
ATOM   1375  O   TYR B  45       2.173  81.526  32.073  1.00 10.13           O  
ATOM   1376  CB  TYR B  45       4.265  80.476  29.784  1.00 13.93           C  
ATOM   1377  CG  TYR B  45       4.075  79.335  30.728  1.00  9.77           C  
ATOM   1378  CD1 TYR B  45       3.147  78.334  30.440  1.00 15.79           C  
ATOM   1379  CD2 TYR B  45       4.758  79.283  31.940  1.00 14.92           C  
ATOM   1380  CE1 TYR B  45       2.939  77.304  31.308  1.00 13.03           C  
ATOM   1381  CE2 TYR B  45       4.560  78.226  32.818  1.00 11.21           C  
ATOM   1382  CZ  TYR B  45       3.639  77.251  32.495  1.00 15.78           C  
ATOM   1383  OH  TYR B  45       3.431  76.195  33.338  1.00 16.60           O  
ATOM   1384  N   SER B  46       3.897  82.921  31.759  1.00  9.77           N  
ATOM   1385  CA  SER B  46       3.861  83.396  33.159  1.00 12.01           C  
ATOM   1386  C   SER B  46       2.579  84.186  33.438  1.00 10.28           C  
ATOM   1387  O   SER B  46       1.996  84.072  34.526  1.00 11.21           O  
ATOM   1388  CB  SER B  46       5.122  84.169  33.521  1.00 11.05           C  
ATOM   1389  OG  SER B  46       6.253  83.317  33.355  1.00 13.30           O  
ATOM   1390  N   ARG B  47       2.103  84.913  32.434  1.00 10.60           N  
ATOM   1391  CA  ARG B  47       0.848  85.624  32.582  1.00 12.34           C  
ATOM   1392  C   ARG B  47      -0.301  84.630  32.754  1.00 10.78           C  
ATOM   1393  O   ARG B  47      -1.194  84.885  33.576  1.00 10.98           O  
ATOM   1394  CB  ARG B  47       0.527  86.478  31.367  1.00  8.85           C  
ATOM   1395  CG  ARG B  47       1.351  87.722  31.163  1.00 16.00           C  
ATOM   1396  CD  ARG B  47       1.133  88.201  29.754  1.00 25.58           C  
ATOM   1397  NE  ARG B  47       2.007  89.316  29.499  1.00 27.70           N  
ATOM   1398  CZ  ARG B  47       1.654  90.586  29.675  1.00 36.01           C  
ATOM   1399  NH1 ARG B  47       0.414  90.915  30.068  1.00 28.23           N  
ATOM   1400  NH2 ARG B  47       2.546  91.531  29.430  1.00 40.15           N  
HETATM 1401  N   MSE B  48      -0.286  83.550  31.965  1.00 11.90           N  
HETATM 1402  CA  MSE B  48      -1.312  82.526  32.038  1.00 11.41           C  
HETATM 1403  C   MSE B  48      -1.280  81.881  33.411  1.00  9.26           C  
HETATM 1404  O   MSE B  48      -2.314  81.722  34.071  1.00  9.88           O  
HETATM 1405  CB  MSE B  48      -1.117  81.464  30.949  1.00 13.55           C  
HETATM 1406  CG  MSE B  48      -2.317  80.534  30.769  1.00 10.90           C  
HETATM 1407 SE   MSE B  48      -2.032  79.288  29.311  0.75 14.82          SE  
HETATM 1408  CE  MSE B  48      -0.675  78.258  30.188  1.00 11.22           C  
ATOM   1409  N   ARG B  49      -0.078  81.537  33.861  1.00 10.40           N  
ATOM   1410  CA  ARG B  49       0.120  80.884  35.168  1.00 12.85           C  
ATOM   1411  C   ARG B  49      -0.382  81.751  36.314  1.00 13.66           C  
ATOM   1412  O   ARG B  49      -0.968  81.273  37.274  1.00 14.53           O  
ATOM   1413  CB  ARG B  49       1.618  80.656  35.385  1.00 15.25           C  
ATOM   1414  CG  ARG B  49       1.926  79.585  36.352  1.00 15.33           C  
ATOM   1415  CD  ARG B  49       3.402  79.501  36.576  1.00 19.49           C  
ATOM   1416  NE  ARG B  49       3.685  78.291  37.324  1.00 19.93           N  
ATOM   1417  CZ  ARG B  49       3.635  78.203  38.647  1.00 14.19           C  
ATOM   1418  NH1 ARG B  49       3.382  79.268  39.407  1.00 15.56           N  
ATOM   1419  NH2 ARG B  49       3.861  77.036  39.214  1.00 17.10           N  
ATOM   1420  N   THR B  50      -0.113  83.042  36.191  1.00 13.55           N  
ATOM   1421  CA  THR B  50      -0.472  84.011  37.214  1.00 12.02           C  
ATOM   1422  C   THR B  50      -1.971  84.086  37.423  1.00 13.93           C  
ATOM   1423  O   THR B  50      -2.424  84.110  38.582  1.00 13.32           O  
ATOM   1424  CB  THR B  50       0.120  85.394  36.881  1.00 11.65           C  
ATOM   1425  OG1 THR B  50       1.541  85.243  36.779  1.00 15.06           O  
ATOM   1426  CG2 THR B  50      -0.236  86.390  37.934  1.00 10.31           C  
ATOM   1427  N   THR B  51      -2.735  84.099  36.328  1.00  9.84           N  
ATOM   1428  CA  THR B  51      -4.202  84.075  36.433  1.00 11.40           C  
ATOM   1429  C   THR B  51      -4.671  82.706  36.973  1.00 11.17           C  
ATOM   1430  O   THR B  51      -5.483  82.620  37.926  1.00 11.99           O  
ATOM   1431  CB  THR B  51      -4.906  84.459  35.110  1.00 15.44           C  
ATOM   1432  OG1 THR B  51      -6.327  84.395  35.293  1.00 17.04           O  
ATOM   1433  CG2 THR B  51      -4.537  83.556  34.000  1.00 13.88           C  
HETATM 1434  N   MSE B  52      -4.095  81.634  36.438  1.00  8.98           N  
HETATM 1435  CA  MSE B  52      -4.569  80.302  36.833  1.00  8.71           C  
HETATM 1436  C   MSE B  52      -4.348  80.002  38.312  1.00 10.24           C  
HETATM 1437  O   MSE B  52      -5.184  79.366  38.934  1.00  8.67           O  
HETATM 1438  CB  MSE B  52      -3.890  79.242  36.012  1.00  8.52           C  
HETATM 1439  CG  MSE B  52      -4.418  79.152  34.599  1.00  7.18           C  
HETATM 1440 SE   MSE B  52      -3.334  77.815  33.673  0.75 13.62          SE  
HETATM 1441  CE  MSE B  52      -4.285  77.716  32.027  1.00 11.02           C  
ATOM   1442  N   LEU B  53      -3.264  80.535  38.877  1.00  9.72           N  
ATOM   1443  CA  LEU B  53      -2.881  80.248  40.250  1.00  8.68           C  
ATOM   1444  C   LEU B  53      -3.167  81.447  41.194  1.00 10.39           C  
ATOM   1445  O   LEU B  53      -2.646  81.543  42.316  1.00  9.26           O  
ATOM   1446  CB  LEU B  53      -1.411  79.807  40.265  1.00 11.87           C  
ATOM   1447  CG  LEU B  53      -1.210  78.376  39.820  1.00 11.58           C  
ATOM   1448  CD1 LEU B  53       0.268  78.013  39.552  1.00 13.01           C  
ATOM   1449  CD2 LEU B  53      -1.827  77.404  40.835  1.00 12.82           C  
ATOM   1450  N   LYS B  54      -4.027  82.346  40.730  1.00 11.13           N  
ATOM   1451  CA  LYS B  54      -4.544  83.425  41.571  1.00 11.25           C  
ATOM   1452  C   LYS B  54      -5.008  82.881  42.936  1.00 12.74           C  
ATOM   1453  O   LYS B  54      -5.638  81.824  43.039  1.00  9.79           O  
ATOM   1454  CB  LYS B  54      -5.698  84.107  40.812  1.00 14.16           C  
ATOM   1455  CG  LYS B  54      -6.186  85.354  41.411  1.00 19.95           C  
ATOM   1456  CD  LYS B  54      -6.646  86.345  40.343  1.00 32.55           C  
ATOM   1457  CE  LYS B  54      -7.920  85.911  39.636  1.00 38.32           C  
ATOM   1458  NZ  LYS B  54      -7.994  86.575  38.291  1.00 42.60           N  
ATOM   1459  N   SER B  55      -4.673  83.610  43.984  1.00 13.77           N  
ATOM   1460  CA  SER B  55      -5.128  83.278  45.339  1.00 16.44           C  
ATOM   1461  C   SER B  55      -6.581  83.715  45.579  1.00 15.32           C  
ATOM   1462  O   SER B  55      -7.143  84.515  44.843  1.00 12.99           O  
ATOM   1463  CB  SER B  55      -4.258  83.973  46.381  1.00 17.63           C  
ATOM   1464  OG  SER B  55      -4.429  85.354  46.255  1.00 16.06           O  
ATOM   1465  N   GLU B  56      -7.167  83.152  46.627  1.00 16.58           N  
ATOM   1466  CA  GLU B  56      -8.478  83.572  47.093  1.00 14.89           C  
ATOM   1467  C   GLU B  56      -8.488  85.066  47.453  1.00 17.29           C  
ATOM   1468  O   GLU B  56      -9.443  85.771  47.122  1.00 14.97           O  
ATOM   1469  CB  GLU B  56      -8.870  82.740  48.307  1.00 16.26           C  
ATOM   1470  CG  GLU B  56      -9.299  81.328  47.980  1.00 17.98           C  
ATOM   1471  CD  GLU B  56      -9.656  80.552  49.222  1.00 24.03           C  
ATOM   1472  OE1 GLU B  56      -8.737  80.082  49.954  1.00 21.96           O  
ATOM   1473  OE2 GLU B  56     -10.871  80.420  49.473  1.00 26.70           O  
ATOM   1474  N   ALA B  57      -7.418  85.526  48.098  1.00 13.22           N  
ATOM   1475  CA  ALA B  57      -7.263  86.932  48.468  1.00 14.27           C  
ATOM   1476  C   ALA B  57      -7.324  87.829  47.231  1.00 15.56           C  
ATOM   1477  O   ALA B  57      -7.759  88.966  47.296  1.00 16.08           O  
ATOM   1478  CB  ALA B  57      -5.955  87.122  49.208  1.00 13.78           C  
ATOM   1479  N   ASP B  58      -6.884  87.321  46.090  1.00 14.41           N  
ATOM   1480  CA  ASP B  58      -6.986  88.067  44.838  1.00 16.31           C  
ATOM   1481  C   ASP B  58      -8.211  87.689  44.021  1.00 17.65           C  
ATOM   1482  O   ASP B  58      -8.300  88.030  42.841  1.00 19.08           O  
ATOM   1483  CB  ASP B  58      -5.722  87.898  44.002  1.00 17.85           C  
ATOM   1484  CG  ASP B  58      -4.507  88.547  44.648  1.00 21.38           C  
ATOM   1485  OD1 ASP B  58      -4.676  89.563  45.367  1.00 28.57           O  
ATOM   1486  OD2 ASP B  58      -3.384  88.040  44.438  1.00 20.04           O  
ATOM   1487  N   GLY B  59      -9.160  87.001  44.651  1.00 17.85           N  
ATOM   1488  CA  GLY B  59     -10.451  86.748  44.038  1.00 18.09           C  
ATOM   1489  C   GLY B  59     -10.695  85.357  43.469  1.00 16.10           C  
ATOM   1490  O   GLY B  59     -11.731  85.132  42.829  1.00 19.15           O  
ATOM   1491  N   ALA B  60      -9.773  84.417  43.691  1.00 12.79           N  
ATOM   1492  CA  ALA B  60      -9.957  83.044  43.183  1.00 12.08           C  
ATOM   1493  C   ALA B  60     -11.036  82.363  44.015  1.00 12.12           C  
ATOM   1494  O   ALA B  60     -11.185  82.683  45.207  1.00 13.11           O  
ATOM   1495  CB  ALA B  60      -8.687  82.271  43.313  1.00 12.25           C  
ATOM   1496  N   LYS B  61     -11.787  81.447  43.405  1.00 13.18           N  
ATOM   1497  CA  LYS B  61     -12.762  80.648  44.146  1.00 12.39           C  
ATOM   1498  C   LYS B  61     -12.219  79.334  44.703  1.00 11.87           C  
ATOM   1499  O   LYS B  61     -12.630  78.910  45.769  1.00 11.26           O  
ATOM   1500  CB  LYS B  61     -14.008  80.401  43.295  1.00 12.85           C  
ATOM   1501  CG  LYS B  61     -14.685  81.707  42.816  1.00 14.53           C  
ATOM   1502  CD  LYS B  61     -15.257  82.492  43.949  1.00 21.22           C  
ATOM   1503  CE  LYS B  61     -15.850  83.832  43.487  1.00 27.21           C  
ATOM   1504  NZ  LYS B  61     -14.835  84.707  42.832  1.00 36.92           N  
ATOM   1505  N   LEU B  62     -11.291  78.686  43.994  1.00 10.27           N  
ATOM   1506  CA  LEU B  62     -10.725  77.407  44.437  1.00  8.56           C  
ATOM   1507  C   LEU B  62      -9.496  77.723  45.293  1.00 11.27           C  
ATOM   1508  O   LEU B  62      -8.629  78.438  44.845  1.00 11.01           O  
ATOM   1509  CB  LEU B  62     -10.314  76.602  43.192  1.00  8.48           C  
ATOM   1510  CG  LEU B  62      -9.797  75.158  43.365  1.00  9.10           C  
ATOM   1511  CD1 LEU B  62     -10.829  74.299  44.009  1.00 11.00           C  
ATOM   1512  CD2 LEU B  62      -9.338  74.598  42.012  1.00  7.19           C  
ATOM   1513  N   PRO B  63      -9.466  77.264  46.547  1.00  7.70           N  
ATOM   1514  CA  PRO B  63      -8.326  77.531  47.414  1.00 11.75           C  
ATOM   1515  C   PRO B  63      -6.983  77.122  46.794  1.00 11.21           C  
ATOM   1516  O   PRO B  63      -6.889  76.080  46.127  1.00  9.06           O  
ATOM   1517  CB  PRO B  63      -8.621  76.678  48.643  1.00  9.89           C  
ATOM   1518  CG  PRO B  63     -10.109  76.568  48.668  1.00 10.94           C  
ATOM   1519  CD  PRO B  63     -10.526  76.506  47.248  1.00 10.79           C  
ATOM   1520  N   LEU B  64      -5.973  77.965  47.001  1.00 10.39           N  
ATOM   1521  CA  LEU B  64      -4.651  77.763  46.403  1.00  9.26           C  
ATOM   1522  C   LEU B  64      -4.060  76.394  46.742  1.00  8.77           C  
ATOM   1523  O   LEU B  64      -3.415  75.773  45.900  1.00  9.15           O  
ATOM   1524  CB  LEU B  64      -3.676  78.843  46.862  1.00  9.82           C  
ATOM   1525  CG  LEU B  64      -2.306  78.968  46.198  1.00 10.82           C  
ATOM   1526  CD1 LEU B  64      -2.416  79.011  44.654  1.00 10.81           C  
ATOM   1527  CD2 LEU B  64      -1.568  80.201  46.752  1.00 12.49           C  
ATOM   1528  N   LYS B  65      -4.252  75.960  47.981  1.00  9.17           N  
ATOM   1529  CA  LYS B  65      -3.774  74.634  48.366  1.00 10.20           C  
ATOM   1530  C   LYS B  65      -4.322  73.510  47.476  1.00 10.32           C  
ATOM   1531  O   LYS B  65      -3.602  72.536  47.129  1.00  9.60           O  
ATOM   1532  CB  LYS B  65      -4.076  74.348  49.821  1.00  8.86           C  
ATOM   1533  CG  LYS B  65      -5.540  74.382  50.219  1.00  6.92           C  
ATOM   1534  CD  LYS B  65      -5.606  74.221  51.775  1.00 11.72           C  
ATOM   1535  CE  LYS B  65      -7.019  74.352  52.291  1.00 15.23           C  
ATOM   1536  NZ  LYS B  65      -7.117  74.374  53.765  1.00 12.35           N  
ATOM   1537  N   TYR B  66      -5.592  73.639  47.090  1.00  9.33           N  
ATOM   1538  CA  TYR B  66      -6.225  72.640  46.209  1.00  7.87           C  
ATOM   1539  C   TYR B  66      -5.826  72.783  44.732  1.00  8.32           C  
ATOM   1540  O   TYR B  66      -5.721  71.780  44.010  1.00  9.10           O  
ATOM   1541  CB  TYR B  66      -7.746  72.629  46.405  1.00  7.13           C  
ATOM   1542  CG  TYR B  66      -8.115  72.240  47.821  1.00  9.60           C  
ATOM   1543  CD1 TYR B  66      -7.508  71.157  48.468  1.00 11.29           C  
ATOM   1544  CD2 TYR B  66      -9.033  72.980  48.544  1.00 12.15           C  
ATOM   1545  CE1 TYR B  66      -7.805  70.838  49.805  1.00 11.09           C  
ATOM   1546  CE2 TYR B  66      -9.353  72.666  49.849  1.00 14.95           C  
ATOM   1547  CZ  TYR B  66      -8.755  71.608  50.489  1.00 11.96           C  
ATOM   1548  OH  TYR B  66      -9.090  71.347  51.804  1.00 16.55           O  
ATOM   1549  N   LYS B  67      -5.560  74.030  44.303  1.00  7.34           N  
ATOM   1550  CA  LYS B  67      -4.984  74.268  42.999  1.00  9.02           C  
ATOM   1551  C   LYS B  67      -3.662  73.515  42.862  1.00  8.53           C  
ATOM   1552  O   LYS B  67      -3.435  72.788  41.904  1.00  8.67           O  
ATOM   1553  CB  LYS B  67      -4.756  75.744  42.743  1.00  9.68           C  
ATOM   1554  CG  LYS B  67      -6.040  76.557  42.632  1.00  5.89           C  
ATOM   1555  CD  LYS B  67      -5.777  77.962  42.022  1.00  8.83           C  
ATOM   1556  CE  LYS B  67      -7.084  78.659  41.782  1.00 12.71           C  
ATOM   1557  NZ  LYS B  67      -6.877  80.021  41.283  1.00  8.80           N  
ATOM   1558  N   HIS B  68      -2.786  73.706  43.843  1.00  8.06           N  
ATOM   1559  CA  HIS B  68      -1.519  72.972  43.816  1.00  7.29           C  
ATOM   1560  C   HIS B  68      -1.642  71.474  44.030  1.00  9.04           C  
ATOM   1561  O   HIS B  68      -0.875  70.724  43.420  1.00  8.92           O  
ATOM   1562  CB  HIS B  68      -0.528  73.586  44.772  1.00  8.79           C  
ATOM   1563  CG  HIS B  68       0.071  74.853  44.272  1.00 12.02           C  
ATOM   1564  ND1 HIS B  68       1.036  74.892  43.290  1.00  9.42           N  
ATOM   1565  CD2 HIS B  68      -0.176  76.134  44.616  1.00  8.95           C  
ATOM   1566  CE1 HIS B  68       1.367  76.153  43.057  1.00  9.90           C  
ATOM   1567  NE2 HIS B  68       0.654  76.933  43.858  1.00 13.55           N  
ATOM   1568  N   LEU B  69      -2.620  71.019  44.807  1.00  8.48           N  
ATOM   1569  CA  LEU B  69      -2.885  69.588  44.883  1.00  6.75           C  
ATOM   1570  C   LEU B  69      -3.253  69.018  43.501  1.00  4.78           C  
ATOM   1571  O   LEU B  69      -2.769  67.958  43.138  1.00  8.40           O  
ATOM   1572  CB  LEU B  69      -3.972  69.286  45.902  1.00  8.21           C  
ATOM   1573  CG  LEU B  69      -4.318  67.799  46.052  1.00  5.92           C  
ATOM   1574  CD1 LEU B  69      -3.123  66.975  46.441  1.00  5.39           C  
ATOM   1575  CD2 LEU B  69      -5.455  67.692  47.074  1.00  7.77           C  
ATOM   1576  N   ILE B  70      -4.103  69.713  42.737  1.00  6.98           N  
ATOM   1577  CA  ILE B  70      -4.416  69.253  41.370  1.00  8.03           C  
ATOM   1578  C   ILE B  70      -3.116  69.126  40.541  1.00  7.55           C  
ATOM   1579  O   ILE B  70      -2.903  68.119  39.886  1.00  7.63           O  
ATOM   1580  CB  ILE B  70      -5.475  70.160  40.679  1.00  7.04           C  
ATOM   1581  CG1 ILE B  70      -6.849  69.968  41.383  1.00  8.07           C  
ATOM   1582  CG2 ILE B  70      -5.558  69.917  39.158  1.00  7.50           C  
ATOM   1583  CD1 ILE B  70      -7.901  71.107  41.147  1.00  9.27           C  
ATOM   1584  N   LEU B  71      -2.238  70.124  40.664  1.00  8.55           N  
ATOM   1585  CA  LEU B  71      -0.953  70.102  39.943  1.00  7.63           C  
ATOM   1586  C   LEU B  71      -0.057  68.975  40.409  1.00  9.43           C  
ATOM   1587  O   LEU B  71       0.628  68.338  39.598  1.00  7.25           O  
ATOM   1588  CB  LEU B  71      -0.316  71.474  39.949  1.00 10.57           C  
ATOM   1589  CG  LEU B  71      -1.064  72.465  39.079  1.00  9.82           C  
ATOM   1590  CD1 LEU B  71      -0.635  73.911  39.486  1.00  8.28           C  
ATOM   1591  CD2 LEU B  71      -0.880  72.194  37.628  1.00  9.46           C  
ATOM   1592  N   VAL B  72      -0.102  68.665  41.706  1.00  7.53           N  
ATOM   1593  CA  VAL B  72       0.637  67.526  42.236  1.00  8.83           C  
ATOM   1594  C   VAL B  72       0.179  66.241  41.535  1.00  6.93           C  
ATOM   1595  O   VAL B  72       0.968  65.481  41.015  1.00  9.64           O  
ATOM   1596  CB  VAL B  72       0.481  67.369  43.767  1.00  6.86           C  
ATOM   1597  CG1 VAL B  72       0.888  65.932  44.200  1.00  8.09           C  
ATOM   1598  CG2 VAL B  72       1.238  68.458  44.551  1.00  6.51           C  
ATOM   1599  N   VAL B  73      -1.139  66.032  41.507  1.00  7.34           N  
ATOM   1600  CA  VAL B  73      -1.680  64.797  40.920  1.00  5.91           C  
ATOM   1601  C   VAL B  73      -1.337  64.720  39.423  1.00  7.20           C  
ATOM   1602  O   VAL B  73      -0.943  63.676  38.901  1.00  6.99           O  
ATOM   1603  CB  VAL B  73      -3.166  64.697  41.198  1.00  6.09           C  
ATOM   1604  CG1 VAL B  73      -3.669  63.391  40.444  1.00  5.49           C  
ATOM   1605  CG2 VAL B  73      -3.424  64.584  42.683  1.00  8.61           C  
ATOM   1606  N   LEU B  74      -1.479  65.832  38.712  1.00  7.57           N  
ATOM   1607  CA  LEU B  74      -1.074  65.898  37.287  1.00  8.11           C  
ATOM   1608  C   LEU B  74       0.418  65.615  37.073  1.00  6.96           C  
ATOM   1609  O   LEU B  74       0.756  64.824  36.165  1.00  8.79           O  
ATOM   1610  CB  LEU B  74      -1.445  67.252  36.682  1.00  8.15           C  
ATOM   1611  CG  LEU B  74      -2.953  67.518  36.465  1.00  8.45           C  
ATOM   1612  CD1 LEU B  74      -3.159  69.010  36.135  1.00 11.85           C  
ATOM   1613  CD2 LEU B  74      -3.582  66.623  35.389  1.00 13.13           C  
ATOM   1614  N   ASP B  75       1.283  66.171  37.919  1.00  7.96           N  
ATOM   1615  CA  ASP B  75       2.698  65.850  37.849  1.00  8.16           C  
ATOM   1616  C   ASP B  75       2.963  64.368  38.183  1.00  9.49           C  
ATOM   1617  O   ASP B  75       3.922  63.788  37.647  1.00  9.44           O  
ATOM   1618  CB  ASP B  75       3.538  66.763  38.718  1.00 11.74           C  
ATOM   1619  CG  ASP B  75       3.733  68.134  38.108  1.00 10.96           C  
ATOM   1620  OD1 ASP B  75       3.396  68.305  36.922  1.00 13.05           O  
ATOM   1621  OD2 ASP B  75       4.277  69.028  38.795  1.00 13.65           O  
ATOM   1622  N   ALA B  76       2.161  63.772  39.059  1.00  6.34           N  
ATOM   1623  CA  ALA B  76       2.236  62.324  39.298  1.00  8.07           C  
ATOM   1624  C   ALA B  76       1.974  61.529  38.044  1.00  8.94           C  
ATOM   1625  O   ALA B  76       2.758  60.630  37.653  1.00 10.69           O  
ATOM   1626  CB  ALA B  76       1.283  61.888  40.386  1.00  6.60           C  
ATOM   1627  N   ILE B  77       0.888  61.902  37.365  0.50  5.77           N  
ATOM   1629  CA  ILE B  77       0.531  61.257  36.117  0.50  5.44           C  
ATOM   1631  C   ILE B  77       1.635  61.433  35.076  0.50  7.28           C  
ATOM   1633  O   ILE B  77       2.092  60.435  34.476  0.50  7.11           O  
ATOM   1635  CB  ILE B  77      -0.826  61.739  35.558  0.50  5.47           C  
ATOM   1637  CG1 ILE B  77      -1.927  61.596  36.616  0.50  9.40           C  
ATOM   1639  CG2 ILE B  77      -1.169  60.935  34.306  0.50  6.11           C  
ATOM   1641  CD1 ILE B  77      -1.872  60.270  37.400  0.50  7.89           C  
ATOM   1643  N   ARG B  78       2.141  62.652  34.954  0.50  8.34           N  
ATOM   1645  CA  ARG B  78       3.058  62.979  33.863  0.50  9.05           C  
ATOM   1647  C   ARG B  78       4.475  62.471  34.164  0.50  8.79           C  
ATOM   1649  O   ARG B  78       5.335  62.488  33.272  0.50 10.87           O  
ATOM   1651  CB  ARG B  78       3.014  64.492  33.619  0.50 10.42           C  
ATOM   1653  CG  ARG B  78       3.751  64.982  32.381  0.50 14.77           C  
ATOM   1655  CD  ARG B  78       3.297  64.305  31.057  0.50 14.42           C  
ATOM   1657  NE  ARG B  78       4.021  64.866  29.892  0.50 13.31           N  
ATOM   1659  CZ  ARG B  78       3.591  65.863  29.110  0.50 12.32           C  
ATOM   1661  NH1 ARG B  78       2.400  66.415  29.285  0.50  8.47           N  
ATOM   1663  NH2 ARG B  78       4.369  66.288  28.119  0.50 11.83           N  
ATOM   1665  N   ASP B  79       4.704  61.993  35.396  1.00  8.52           N  
ATOM   1666  CA  ASP B  79       6.057  61.639  35.879  1.00  8.69           C  
ATOM   1667  C   ASP B  79       7.019  62.813  35.849  1.00 12.14           C  
ATOM   1668  O   ASP B  79       8.097  62.749  35.211  1.00 10.41           O  
ATOM   1669  CB  ASP B  79       6.626  60.442  35.117  1.00 11.54           C  
ATOM   1670  CG  ASP B  79       5.804  59.214  35.316  1.00 18.53           C  
ATOM   1671  OD1 ASP B  79       5.435  58.889  36.462  1.00 16.09           O  
ATOM   1672  OD2 ASP B  79       5.526  58.546  34.307  1.00 20.18           O  
ATOM   1673  N   GLU B  80       6.628  63.921  36.477  0.50 10.49           N  
ATOM   1675  CA  GLU B  80       7.555  65.036  36.618  0.50 10.79           C  
ATOM   1677  C   GLU B  80       7.869  65.172  38.102  0.50 12.83           C  
ATOM   1679  O   GLU B  80       7.091  65.748  38.847  0.50 11.58           O  
ATOM   1681  CB  GLU B  80       7.036  66.337  36.019  0.50 12.97           C  
ATOM   1683  CG  GLU B  80       8.206  67.177  35.421  0.50 24.72           C  
ATOM   1685  CD  GLU B  80       9.290  67.601  36.442  0.50  9.73           C  
ATOM   1687  OE1 GLU B  80      10.313  66.883  36.718  0.50 12.54           O  
ATOM   1689  OE2 GLU B  80       9.144  68.730  36.904  0.50 21.39           O  
ATOM   1691  N   PRO B  81       8.966  64.538  38.539  1.00 12.28           N  
ATOM   1692  CA  PRO B  81       9.366  64.502  39.932  1.00 14.53           C  
ATOM   1693  C   PRO B  81       9.827  65.836  40.538  1.00 11.78           C  
ATOM   1694  O   PRO B  81       9.688  66.044  41.765  1.00 15.24           O  
ATOM   1695  CB  PRO B  81      10.484  63.471  39.931  1.00 17.39           C  
ATOM   1696  CG  PRO B  81      11.041  63.521  38.576  1.00 16.17           C  
ATOM   1697  CD  PRO B  81       9.878  63.736  37.691  1.00 14.97           C  
ATOM   1698  N   ILE B  82      10.399  66.722  39.707  1.00 13.05           N  
ATOM   1699  CA  ILE B  82      10.811  68.045  40.202  1.00 13.28           C  
ATOM   1700  C   ILE B  82       9.555  68.864  40.463  1.00 11.97           C  
ATOM   1701  O   ILE B  82       9.357  69.392  41.544  1.00 11.63           O  
ATOM   1702  CB  ILE B  82      11.737  68.780  39.189  1.00 14.82           C  
ATOM   1703  CG1 ILE B  82      12.988  67.935  38.956  1.00 19.38           C  
ATOM   1704  CG2 ILE B  82      12.106  70.175  39.730  1.00 11.01           C  
ATOM   1705  CD1 ILE B  82      13.669  67.541  40.209  1.00 26.67           C  
ATOM   1706  N   GLY B  83       8.701  68.939  39.456  1.00 12.03           N  
ATOM   1707  CA  GLY B  83       7.435  69.615  39.590  1.00  8.82           C  
ATOM   1708  C   GLY B  83       6.558  69.094  40.700  1.00  8.34           C  
ATOM   1709  O   GLY B  83       5.943  69.885  41.406  1.00  9.84           O  
ATOM   1710  N   ILE B  84       6.509  67.776  40.885  1.00  8.78           N  
ATOM   1711  CA  ILE B  84       5.624  67.200  41.912  1.00  7.73           C  
ATOM   1712  C   ILE B  84       6.059  67.688  43.314  1.00  8.39           C  
ATOM   1713  O   ILE B  84       5.223  68.071  44.143  1.00  8.75           O  
ATOM   1714  CB  ILE B  84       5.473  65.644  41.856  1.00  5.79           C  
ATOM   1715  CG1 ILE B  84       4.125  65.272  42.482  1.00  9.08           C  
ATOM   1716  CG2 ILE B  84       6.635  64.919  42.605  1.00  7.74           C  
ATOM   1717  CD1 ILE B  84       3.807  63.845  42.433  1.00  6.94           C  
ATOM   1718  N   VAL B  85       7.377  67.748  43.572  1.00  8.57           N  
ATOM   1719  CA  VAL B  85       7.851  68.224  44.852  1.00  9.17           C  
ATOM   1720  C   VAL B  85       7.609  69.739  44.929  1.00  9.50           C  
ATOM   1721  O   VAL B  85       7.131  70.212  45.940  1.00  9.07           O  
ATOM   1722  CB  VAL B  85       9.334  67.872  45.041  1.00  9.13           C  
ATOM   1723  CG1 VAL B  85       9.966  68.666  46.202  1.00 11.42           C  
ATOM   1724  CG2 VAL B  85       9.472  66.375  45.205  1.00 10.63           C  
ATOM   1725  N   ASN B  86       7.902  70.499  43.862  1.00  8.68           N  
ATOM   1726  CA  ASN B  86       7.620  71.939  43.890  1.00  9.61           C  
ATOM   1727  C   ASN B  86       6.153  72.292  44.211  1.00  7.08           C  
ATOM   1728  O   ASN B  86       5.887  73.211  44.989  1.00 10.97           O  
ATOM   1729  CB  ASN B  86       8.088  72.646  42.596  1.00 10.18           C  
ATOM   1730  CG  ASN B  86       9.621  72.687  42.476  1.00 14.89           C  
ATOM   1731  OD1 ASN B  86      10.327  72.633  43.490  1.00 19.70           O  
ATOM   1732  ND2 ASN B  86      10.124  72.817  41.253  1.00 15.91           N  
ATOM   1733  N   HIS B  87       5.212  71.577  43.587  1.00  8.23           N  
ATOM   1734  CA  HIS B  87       3.793  71.799  43.860  1.00  8.24           C  
ATOM   1735  C   HIS B  87       3.340  71.264  45.234  1.00  8.38           C  
ATOM   1736  O   HIS B  87       2.410  71.823  45.866  1.00 11.19           O  
ATOM   1737  CB  HIS B  87       2.930  71.287  42.701  1.00  8.77           C  
ATOM   1738  CG  HIS B  87       3.030  72.136  41.476  1.00  8.52           C  
ATOM   1739  ND1 HIS B  87       2.470  73.388  41.401  1.00  6.81           N  
ATOM   1740  CD2 HIS B  87       3.649  71.926  40.287  1.00 10.50           C  
ATOM   1741  CE1 HIS B  87       2.751  73.922  40.227  1.00 13.37           C  
ATOM   1742  NE2 HIS B  87       3.476  73.065  39.538  1.00 10.91           N  
ATOM   1743  N   THR B  88       3.966  70.191  45.719  1.00  7.04           N  
ATOM   1744  CA  THR B  88       3.689  69.712  47.081  1.00  6.92           C  
ATOM   1745  C   THR B  88       4.093  70.795  48.099  1.00  7.27           C  
ATOM   1746  O   THR B  88       3.328  71.146  48.998  1.00  9.47           O  
ATOM   1747  CB  THR B  88       4.380  68.382  47.404  1.00  8.03           C  
ATOM   1748  OG1 THR B  88       3.848  67.394  46.533  1.00  7.89           O  
ATOM   1749  CG2 THR B  88       4.141  67.949  48.887  1.00 10.24           C  
ATOM   1750  N   ARG B  89       5.323  71.281  47.958  0.50  8.83           N  
ATOM   1752  CA  ARG B  89       5.828  72.387  48.768  0.50  8.66           C  
ATOM   1754  C   ARG B  89       4.857  73.582  48.726  0.50  8.37           C  
ATOM   1756  O   ARG B  89       4.436  74.085  49.764  0.50  8.71           O  
ATOM   1758  CB  ARG B  89       7.241  72.786  48.299  0.50  7.78           C  
ATOM   1760  CG  ARG B  89       7.957  73.771  49.206  0.50 12.49           C  
ATOM   1762  CD  ARG B  89       9.307  74.219  48.612  0.50  9.37           C  
ATOM   1764  NE  ARG B  89      10.252  73.116  48.406  0.50 10.22           N  
ATOM   1766  CZ  ARG B  89      10.657  72.650  47.222  0.50  9.58           C  
ATOM   1768  NH1 ARG B  89      10.242  73.190  46.086  0.50 12.41           N  
ATOM   1770  NH2 ARG B  89      11.532  71.644  47.158  0.50 14.04           N  
ATOM   1772  N   ALA B  90       4.483  74.007  47.521  1.00 11.72           N  
ATOM   1773  CA  ALA B  90       3.549  75.122  47.327  1.00 10.50           C  
ATOM   1774  C   ALA B  90       2.198  74.846  48.030  1.00  9.89           C  
ATOM   1775  O   ALA B  90       1.686  75.688  48.779  1.00  7.94           O  
ATOM   1776  CB  ALA B  90       3.356  75.394  45.817  1.00  8.59           C  
ATOM   1777  N   ALA B  91       1.640  73.651  47.805  1.00  9.37           N  
ATOM   1778  CA  ALA B  91       0.346  73.313  48.388  1.00 10.42           C  
ATOM   1779  C   ALA B  91       0.411  73.417  49.914  1.00  8.19           C  
ATOM   1780  O   ALA B  91      -0.531  73.897  50.563  1.00  7.65           O  
ATOM   1781  CB  ALA B  91      -0.145  71.880  47.930  1.00  7.75           C  
HETATM 1782  N   MSE B  92       1.496  72.888  50.488  1.00  8.89           N  
HETATM 1783  CA  MSE B  92       1.628  72.786  51.942  1.00 11.64           C  
HETATM 1784  C   MSE B  92       1.928  74.154  52.538  1.00 11.14           C  
HETATM 1785  O   MSE B  92       1.424  74.503  53.611  1.00  7.95           O  
HETATM 1786  CB  MSE B  92       2.693  71.762  52.313  1.00 10.80           C  
HETATM 1787  CG  MSE B  92       2.202  70.343  52.080  1.00 11.85           C  
HETATM 1788 SE   MSE B  92       3.480  68.972  52.438  0.75 10.49          SE  
HETATM 1789  CE  MSE B  92       3.724  69.270  54.405  1.00  9.37           C  
ATOM   1790  N   ASN B  93       2.700  74.950  51.803  1.00  9.48           N  
ATOM   1791  CA  ASN B  93       2.864  76.354  52.168  1.00  9.27           C  
ATOM   1792  C   ASN B  93       1.529  77.080  52.224  1.00  8.75           C  
ATOM   1793  O   ASN B  93       1.368  78.002  53.061  1.00 10.09           O  
ATOM   1794  CB  ASN B  93       3.863  77.069  51.234  1.00 10.12           C  
ATOM   1795  CG  ASN B  93       5.315  76.810  51.602  1.00 11.78           C  
ATOM   1796  OD1 ASN B  93       5.635  76.569  52.770  1.00 16.46           O  
ATOM   1797  ND2 ASN B  93       6.207  76.911  50.623  1.00  6.38           N  
ATOM   1798  N   ALA B  94       0.591  76.713  51.356  1.00 10.84           N  
ATOM   1799  CA  ALA B  94      -0.737  77.310  51.317  1.00  9.49           C  
ATOM   1800  C   ALA B  94      -1.751  76.608  52.247  1.00  9.08           C  
ATOM   1801  O   ALA B  94      -2.949  76.924  52.249  1.00 11.93           O  
ATOM   1802  CB  ALA B  94      -1.251  77.378  49.838  1.00 11.08           C  
ATOM   1803  N   GLY B  95      -1.295  75.638  53.030  1.00 11.27           N  
ATOM   1804  CA  GLY B  95      -2.122  75.041  54.072  1.00  9.86           C  
ATOM   1805  C   GLY B  95      -2.558  73.612  53.872  1.00  9.45           C  
ATOM   1806  O   GLY B  95      -3.267  73.066  54.694  1.00 10.07           O  
ATOM   1807  N   LEU B  96      -2.148  72.974  52.774  1.00  8.05           N  
ATOM   1808  CA  LEU B  96      -2.581  71.598  52.578  1.00  8.18           C  
ATOM   1809  C   LEU B  96      -1.934  70.690  53.612  1.00  9.64           C  
ATOM   1810  O   LEU B  96      -0.758  70.827  53.882  1.00 10.04           O  
ATOM   1811  CB  LEU B  96      -2.171  71.115  51.198  1.00  6.15           C  
ATOM   1812  CG  LEU B  96      -2.862  69.804  50.733  1.00  8.65           C  
ATOM   1813  CD1 LEU B  96      -4.252  70.079  50.195  1.00 12.26           C  
ATOM   1814  CD2 LEU B  96      -1.961  69.027  49.734  1.00  8.12           C  
ATOM   1815  N   SER B  97      -2.701  69.776  54.197  1.00  7.72           N  
ATOM   1816  CA  SER B  97      -2.131  68.764  55.090  1.00  7.49           C  
ATOM   1817  C   SER B  97      -1.562  67.579  54.328  1.00  8.77           C  
ATOM   1818  O   SER B  97      -1.966  67.288  53.185  1.00  8.53           O  
ATOM   1819  CB  SER B  97      -3.184  68.274  56.071  1.00 10.02           C  
ATOM   1820  OG  SER B  97      -4.122  67.446  55.437  1.00  7.35           O  
ATOM   1821  N   VAL B  98      -0.644  66.871  54.980  1.00  8.31           N  
ATOM   1822  CA  VAL B  98      -0.131  65.618  54.425  1.00  7.90           C  
ATOM   1823  C   VAL B  98      -1.269  64.594  54.194  1.00  8.59           C  
ATOM   1824  O   VAL B  98      -1.351  63.943  53.155  1.00  7.18           O  
ATOM   1825  CB  VAL B  98       1.041  65.000  55.255  1.00  9.63           C  
ATOM   1826  CG1 VAL B  98       1.484  63.636  54.607  1.00 10.68           C  
ATOM   1827  CG2 VAL B  98       2.224  66.004  55.328  1.00  6.75           C  
ATOM   1828  N   ASP B  99      -2.193  64.496  55.144  1.00  7.65           N  
ATOM   1829  CA  ASP B  99      -3.346  63.605  54.922  1.00  9.04           C  
ATOM   1830  C   ASP B  99      -4.114  63.915  53.651  1.00  7.26           C  
ATOM   1831  O   ASP B  99      -4.481  62.987  52.936  1.00  8.35           O  
ATOM   1832  CB  ASP B  99      -4.308  63.673  56.100  1.00 10.22           C  
ATOM   1833  CG  ASP B  99      -3.773  63.017  57.352  1.00 15.01           C  
ATOM   1834  OD1 ASP B  99      -2.838  62.190  57.273  1.00 13.20           O  
ATOM   1835  OD2 ASP B  99      -4.292  63.354  58.435  1.00 16.68           O  
ATOM   1836  N   GLU B 100      -4.406  65.198  53.393  1.00  8.46           N  
ATOM   1837  CA  GLU B 100      -5.111  65.604  52.172  1.00  7.20           C  
ATOM   1838  C   GLU B 100      -4.282  65.294  50.917  1.00  9.12           C  
ATOM   1839  O   GLU B 100      -4.813  64.913  49.893  1.00  7.81           O  
ATOM   1840  CB  GLU B 100      -5.445  67.097  52.161  1.00  8.50           C  
ATOM   1841  CG  GLU B 100      -6.481  67.524  53.155  1.00  5.48           C  
ATOM   1842  CD  GLU B 100      -6.673  69.032  53.175  1.00 14.22           C  
ATOM   1843  OE1 GLU B 100      -5.673  69.786  53.292  1.00 11.28           O  
ATOM   1844  OE2 GLU B 100      -7.827  69.444  53.004  1.00 13.94           O  
ATOM   1845  N   LEU B 101      -2.975  65.495  51.018  1.00  8.69           N  
ATOM   1846  CA  LEU B 101      -2.075  65.219  49.919  1.00  8.00           C  
ATOM   1847  C   LEU B 101      -2.216  63.759  49.507  1.00  8.17           C  
ATOM   1848  O   LEU B 101      -2.384  63.426  48.329  1.00  7.42           O  
ATOM   1849  CB  LEU B 101      -0.629  65.491  50.339  1.00  8.83           C  
ATOM   1850  CG  LEU B 101       0.457  65.257  49.267  1.00  8.24           C  
ATOM   1851  CD1 LEU B 101       0.340  66.336  48.151  1.00 10.40           C  
ATOM   1852  CD2 LEU B 101       1.854  65.219  49.901  1.00  8.66           C  
ATOM   1853  N   ILE B 102      -2.123  62.871  50.492  1.00  5.61           N  
ATOM   1854  CA  ILE B 102      -2.193  61.451  50.262  1.00  7.97           C  
ATOM   1855  C   ILE B 102      -3.572  61.115  49.642  1.00  6.91           C  
ATOM   1856  O   ILE B 102      -3.654  60.366  48.686  1.00  7.02           O  
ATOM   1857  CB  ILE B 102      -1.907  60.626  51.553  1.00  9.88           C  
ATOM   1858  CG1 ILE B 102      -0.437  60.794  52.046  1.00  9.34           C  
ATOM   1859  CG2 ILE B 102      -2.225  59.139  51.348  1.00  4.98           C  
ATOM   1860  CD1 ILE B 102      -0.221  60.290  53.464  1.00  7.79           C  
ATOM   1861  N   GLU B 103      -4.647  61.644  50.225  1.00  5.58           N  
ATOM   1862  CA  GLU B 103      -5.988  61.341  49.698  1.00  7.32           C  
ATOM   1863  C   GLU B 103      -6.115  61.718  48.215  1.00  7.96           C  
ATOM   1864  O   GLU B 103      -6.716  60.982  47.466  1.00  7.91           O  
ATOM   1865  CB  GLU B 103      -7.091  62.000  50.542  1.00  9.55           C  
ATOM   1866  CG  GLU B 103      -7.220  61.379  51.939  1.00  8.07           C  
ATOM   1867  CD  GLU B 103      -8.434  61.910  52.743  1.00  9.67           C  
ATOM   1868  OE1 GLU B 103      -9.337  62.479  52.104  1.00 14.61           O  
ATOM   1869  OE2 GLU B 103      -8.530  61.677  53.975  1.00 10.82           O  
ATOM   1870  N   GLY B 104      -5.552  62.873  47.834  1.00  6.57           N  
ATOM   1871  CA  GLY B 104      -5.622  63.343  46.471  1.00  8.39           C  
ATOM   1872  C   GLY B 104      -4.838  62.492  45.517  1.00  5.71           C  
ATOM   1873  O   GLY B 104      -5.301  62.138  44.433  1.00  8.04           O  
ATOM   1874  N   ILE B 105      -3.586  62.199  45.909  1.00  7.93           N  
ATOM   1875  CA  ILE B 105      -2.701  61.390  45.092  1.00  6.89           C  
ATOM   1876  C   ILE B 105      -3.273  60.008  44.802  1.00  7.37           C  
ATOM   1877  O   ILE B 105      -3.164  59.481  43.690  1.00  7.44           O  
ATOM   1878  CB  ILE B 105      -1.268  61.288  45.662  1.00  5.49           C  
ATOM   1879  CG1 ILE B 105      -0.616  62.653  45.579  1.00  7.04           C  
ATOM   1880  CG2 ILE B 105      -0.400  60.279  44.865  1.00  6.27           C  
ATOM   1881  CD1 ILE B 105       0.726  62.769  46.390  1.00  6.87           C  
ATOM   1882  N   LEU B 106      -3.849  59.369  45.806  1.00  5.35           N  
ATOM   1883  CA  LEU B 106      -4.452  58.048  45.621  1.00  6.38           C  
ATOM   1884  C   LEU B 106      -5.457  57.990  44.504  1.00  6.77           C  
ATOM   1885  O   LEU B 106      -5.628  56.980  43.841  1.00  7.02           O  
ATOM   1886  CB  LEU B 106      -5.039  57.546  46.936  1.00  6.26           C  
ATOM   1887  CG  LEU B 106      -4.059  57.275  48.100  1.00  8.77           C  
ATOM   1888  CD1 LEU B 106      -4.852  56.985  49.395  1.00  8.24           C  
ATOM   1889  CD2 LEU B 106      -3.183  56.048  47.691  1.00  9.40           C  
ATOM   1890  N   LEU B 107      -6.189  59.093  44.305  1.00  5.61           N  
ATOM   1891  CA  LEU B 107      -7.265  59.118  43.285  1.00  6.29           C  
ATOM   1892  C   LEU B 107      -6.694  58.912  41.892  1.00  5.70           C  
ATOM   1893  O   LEU B 107      -7.364  58.372  40.997  1.00  7.89           O  
ATOM   1894  CB  LEU B 107      -8.033  60.453  43.372  1.00  7.09           C  
ATOM   1895  CG  LEU B 107      -8.809  60.680  44.674  1.00  7.28           C  
ATOM   1896  CD1 LEU B 107      -9.331  62.146  44.796  1.00  7.53           C  
ATOM   1897  CD2 LEU B 107      -9.921  59.676  44.962  1.00  9.77           C  
ATOM   1898  N   GLY B 108      -5.421  59.271  41.693  1.00  5.75           N  
ATOM   1899  CA  GLY B 108      -4.749  58.946  40.419  1.00  9.27           C  
ATOM   1900  C   GLY B 108      -4.749  57.481  40.052  1.00  8.85           C  
ATOM   1901  O   GLY B 108      -4.728  57.168  38.856  1.00  8.79           O  
ATOM   1902  N   ILE B 109      -4.776  56.571  41.030  1.00  5.75           N  
ATOM   1903  CA  ILE B 109      -4.791  55.144  40.791  1.00  7.34           C  
ATOM   1904  C   ILE B 109      -6.082  54.718  40.025  1.00  7.59           C  
ATOM   1905  O   ILE B 109      -6.087  53.876  39.142  1.00  8.76           O  
ATOM   1906  CB  ILE B 109      -4.656  54.340  42.102  1.00  6.10           C  
ATOM   1907  CG1 ILE B 109      -3.304  54.653  42.750  1.00  4.73           C  
ATOM   1908  CG2 ILE B 109      -4.812  52.823  41.834  1.00  5.26           C  
ATOM   1909  CD1 ILE B 109      -3.158  54.162  44.174  1.00  4.93           C  
ATOM   1910  N   ILE B 110      -7.210  55.388  40.359  1.00  6.81           N  
ATOM   1911  CA  ILE B 110      -8.465  55.086  39.664  1.00  8.04           C  
ATOM   1912  C   ILE B 110      -8.334  55.241  38.134  1.00  7.27           C  
ATOM   1913  O   ILE B 110      -8.751  54.366  37.379  1.00  7.72           O  
ATOM   1914  CB  ILE B 110      -9.601  55.969  40.196  1.00  7.98           C  
ATOM   1915  CG1 ILE B 110      -9.962  55.545  41.633  1.00  7.89           C  
ATOM   1916  CG2 ILE B 110     -10.826  55.885  39.255  1.00  8.35           C  
ATOM   1917  CD1 ILE B 110     -10.925  56.478  42.346  1.00 11.61           C  
ATOM   1918  N   VAL B 111      -7.782  56.381  37.694  1.00  7.05           N  
ATOM   1919  CA  VAL B 111      -7.774  56.757  36.304  1.00  7.94           C  
ATOM   1920  C   VAL B 111      -6.513  56.296  35.564  1.00  7.66           C  
ATOM   1921  O   VAL B 111      -6.551  56.057  34.382  1.00  8.87           O  
ATOM   1922  CB  VAL B 111      -8.035  58.277  36.126  1.00  8.72           C  
ATOM   1923  CG1 VAL B 111      -8.159  58.668  34.655  1.00  6.23           C  
ATOM   1924  CG2 VAL B 111      -9.351  58.706  36.926  1.00  7.18           C  
ATOM   1925  N   TYR B 112      -5.427  56.189  36.313  1.00  5.57           N  
ATOM   1926  CA  TYR B 112      -4.082  55.940  35.771  1.00  7.34           C  
ATOM   1927  C   TYR B 112      -3.322  54.719  36.366  1.00  8.50           C  
ATOM   1928  O   TYR B 112      -2.177  54.449  35.964  1.00  8.81           O  
ATOM   1929  CB  TYR B 112      -3.269  57.229  35.713  1.00  8.21           C  
ATOM   1930  CG  TYR B 112      -3.644  58.114  34.552  1.00  7.59           C  
ATOM   1931  CD1 TYR B 112      -3.110  57.905  33.297  1.00 11.06           C  
ATOM   1932  CD2 TYR B 112      -4.546  59.178  34.728  1.00 10.36           C  
ATOM   1933  CE1 TYR B 112      -3.455  58.778  32.233  1.00 10.94           C  
ATOM   1934  CE2 TYR B 112      -4.904  60.009  33.693  1.00 11.99           C  
ATOM   1935  CZ  TYR B 112      -4.345  59.810  32.456  1.00 13.26           C  
ATOM   1936  OH  TYR B 112      -4.696  60.653  31.431  1.00 14.54           O  
ATOM   1937  N   GLY B 113      -3.972  53.915  37.186  1.00  5.85           N  
ATOM   1938  CA  GLY B 113      -3.379  52.698  37.691  1.00  7.04           C  
ATOM   1939  C   GLY B 113      -2.351  52.919  38.772  1.00  7.69           C  
ATOM   1940  O   GLY B 113      -2.052  54.038  39.191  1.00  7.78           O  
HETATM 1941  N   MSE B 114      -1.792  51.804  39.233  1.00  8.96           N  
HETATM 1942  CA  MSE B 114      -0.858  51.841  40.304  1.00  7.61           C  
HETATM 1943  C   MSE B 114       0.375  52.732  40.019  1.00  5.28           C  
HETATM 1944  O   MSE B 114       0.831  53.400  40.967  1.00  6.84           O  
HETATM 1945  CB  MSE B 114      -0.511  50.440  40.776  1.00  8.62           C  
HETATM 1946  CG  MSE B 114       0.416  50.378  41.993  1.00  6.43           C  
HETATM 1947 SE   MSE B 114      -0.193  51.413  43.514  0.75  9.23          SE  
HETATM 1948  CE  MSE B 114      -1.870  50.398  43.828  1.00  8.52           C  
ATOM   1949  N   PRO B 115       0.811  52.868  38.763  1.00  6.62           N  
ATOM   1950  CA  PRO B 115       1.961  53.816  38.532  1.00  7.30           C  
ATOM   1951  C   PRO B 115       1.715  55.242  38.881  1.00  9.17           C  
ATOM   1952  O   PRO B 115       2.657  55.965  39.056  1.00  8.37           O  
ATOM   1953  CB  PRO B 115       2.276  53.621  37.057  1.00  7.67           C  
ATOM   1954  CG  PRO B 115       1.757  52.226  36.727  1.00  9.40           C  
ATOM   1955  CD  PRO B 115       0.462  52.133  37.523  1.00  9.01           C  
ATOM   1956  N   ALA B 116       0.454  55.658  38.946  1.00  6.25           N  
ATOM   1957  CA  ALA B 116       0.116  57.004  39.416  1.00  7.65           C  
ATOM   1958  C   ALA B 116       0.623  57.283  40.848  1.00  7.80           C  
ATOM   1959  O   ALA B 116       0.870  58.432  41.210  1.00  8.49           O  
ATOM   1960  CB  ALA B 116      -1.414  57.284  39.371  1.00  7.94           C  
ATOM   1961  N   TRP B 117       0.701  56.225  41.640  1.00  5.76           N  
ATOM   1962  CA  TRP B 117       1.368  56.241  42.949  1.00  7.03           C  
ATOM   1963  C   TRP B 117       2.853  55.814  42.866  1.00  6.93           C  
ATOM   1964  O   TRP B 117       3.730  56.474  43.426  1.00  6.59           O  
ATOM   1965  CB  TRP B 117       0.624  55.306  43.897  1.00  8.45           C  
ATOM   1966  CG  TRP B 117       1.321  54.993  45.165  1.00  4.20           C  
ATOM   1967  CD1 TRP B 117       2.136  53.941  45.407  1.00  6.54           C  
ATOM   1968  CD2 TRP B 117       1.288  55.768  46.355  1.00  5.53           C  
ATOM   1969  NE1 TRP B 117       2.618  54.003  46.670  1.00  6.01           N  
ATOM   1970  CE2 TRP B 117       2.125  55.121  47.280  1.00  8.56           C  
ATOM   1971  CE3 TRP B 117       0.645  56.952  46.729  1.00  6.76           C  
ATOM   1972  CZ2 TRP B 117       2.337  55.612  48.560  1.00  7.30           C  
ATOM   1973  CZ3 TRP B 117       0.868  57.446  47.988  1.00  7.12           C  
ATOM   1974  CH2 TRP B 117       1.662  56.741  48.909  1.00  9.20           C  
ATOM   1975  N   GLY B 118       3.099  54.675  42.216  1.00  7.66           N  
ATOM   1976  CA  GLY B 118       4.367  53.998  42.318  1.00  9.23           C  
ATOM   1977  C   GLY B 118       5.550  54.675  41.685  1.00  9.01           C  
ATOM   1978  O   GLY B 118       6.647  54.579  42.178  1.00  9.84           O  
ATOM   1979  N   LYS B 119       5.352  55.302  40.534  0.50  8.07           N  
ATOM   1981  CA  LYS B 119       6.477  55.925  39.842  0.50  8.23           C  
ATOM   1983  C   LYS B 119       6.836  57.243  40.547  0.50  9.30           C  
ATOM   1985  O   LYS B 119       7.874  57.363  41.187  0.50 11.69           O  
ATOM   1987  CB  LYS B 119       6.201  56.137  38.349  0.50 10.42           C  
ATOM   1989  CG  LYS B 119       6.044  54.827  37.528  0.50 10.06           C  
ATOM   1991  CD  LYS B 119       5.727  55.087  36.031  0.50 11.82           C  
ATOM   1993  CE  LYS B 119       6.949  55.560  35.288  0.50 14.33           C  
ATOM   1995  NZ  LYS B 119       6.700  55.914  33.870  0.50  8.80           N  
ATOM   1997  N   THR B 120       5.947  58.215  40.461  1.00  9.36           N  
ATOM   1998  CA  THR B 120       6.232  59.577  40.869  1.00  9.96           C  
ATOM   1999  C   THR B 120       5.366  60.078  42.010  1.00  7.74           C  
ATOM   2000  O   THR B 120       5.855  60.766  42.942  1.00  9.82           O  
ATOM   2001  CB  THR B 120       6.098  60.502  39.601  1.00 11.15           C  
ATOM   2002  OG1 THR B 120       6.916  59.967  38.546  1.00 15.14           O  
ATOM   2003  CG2 THR B 120       6.520  61.894  39.882  1.00 11.04           C  
ATOM   2004  N   GLY B 121       4.096  59.680  42.026  1.00  6.84           N  
ATOM   2005  CA  GLY B 121       3.198  60.222  43.060  1.00  7.94           C  
ATOM   2006  C   GLY B 121       3.716  60.056  44.486  1.00  7.04           C  
ATOM   2007  O   GLY B 121       3.649  60.942  45.346  1.00  9.87           O  
ATOM   2008  N   ARG B 122       4.229  58.862  44.788  1.00  8.13           N  
ATOM   2009  CA  ARG B 122       4.691  58.574  46.138  1.00  7.73           C  
ATOM   2010  C   ARG B 122       5.883  59.439  46.554  1.00  8.54           C  
ATOM   2011  O   ARG B 122       6.122  59.625  47.753  1.00  9.29           O  
ATOM   2012  CB  ARG B 122       4.978  57.098  46.304  1.00  8.03           C  
ATOM   2013  CG  ARG B 122       6.153  56.583  45.516  1.00  6.93           C  
ATOM   2014  CD  ARG B 122       6.255  55.079  45.687  1.00  8.46           C  
ATOM   2015  NE  ARG B 122       7.398  54.486  45.017  1.00 10.63           N  
ATOM   2016  CZ  ARG B 122       8.553  54.202  45.604  1.00 14.43           C  
ATOM   2017  NH1 ARG B 122       8.771  54.493  46.887  1.00 13.19           N  
ATOM   2018  NH2 ARG B 122       9.487  53.619  44.893  1.00 18.43           N  
ATOM   2019  N   LYS B 123       6.642  59.960  45.579  1.00 10.19           N  
ATOM   2020  CA  LYS B 123       7.798  60.827  45.935  1.00 10.46           C  
ATOM   2021  C   LYS B 123       7.316  62.131  46.623  1.00  7.05           C  
ATOM   2022  O   LYS B 123       7.997  62.705  47.524  1.00  8.16           O  
ATOM   2023  CB  LYS B 123       8.567  61.159  44.665  1.00 12.53           C  
ATOM   2024  CG  LYS B 123       9.146  59.985  43.886  1.00 13.46           C  
ATOM   2025  CD  LYS B 123       9.916  60.454  42.647  1.00 15.67           C  
ATOM   2026  CE  LYS B 123      10.764  59.310  42.096  1.00 21.41           C  
ATOM   2027  NZ  LYS B 123      11.354  59.647  40.806  1.00 29.09           N  
ATOM   2028  N   ALA B 124       6.134  62.589  46.234  1.00  6.39           N  
ATOM   2029  CA  ALA B 124       5.492  63.756  46.866  1.00  7.55           C  
ATOM   2030  C   ALA B 124       5.228  63.488  48.344  1.00  9.24           C  
ATOM   2031  O   ALA B 124       5.390  64.381  49.160  1.00  7.95           O  
ATOM   2032  CB  ALA B 124       4.170  64.140  46.095  1.00  9.13           C  
ATOM   2033  N   VAL B 125       4.820  62.259  48.665  1.00  8.15           N  
ATOM   2034  CA  VAL B 125       4.483  61.866  50.025  1.00  8.73           C  
ATOM   2035  C   VAL B 125       5.755  61.747  50.865  1.00 10.13           C  
ATOM   2036  O   VAL B 125       5.827  62.231  52.004  1.00 11.74           O  
ATOM   2037  CB  VAL B 125       3.636  60.573  50.049  1.00  8.23           C  
ATOM   2038  CG1 VAL B 125       3.349  60.126  51.539  1.00  8.84           C  
ATOM   2039  CG2 VAL B 125       2.297  60.790  49.287  1.00  7.99           C  
ATOM   2040  N   THR B 126       6.772  61.117  50.290  1.00  9.30           N  
ATOM   2041  CA  THR B 126       8.086  61.015  50.936  1.00  9.89           C  
ATOM   2042  C   THR B 126       8.614  62.419  51.339  1.00  9.28           C  
ATOM   2043  O   THR B 126       9.030  62.660  52.489  1.00 11.64           O  
ATOM   2044  CB  THR B 126       9.101  60.346  50.042  1.00 14.42           C  
ATOM   2045  OG1 THR B 126       8.641  59.031  49.732  1.00 10.70           O  
ATOM   2046  CG2 THR B 126      10.505  60.279  50.729  1.00 16.40           C  
ATOM   2047  N   PHE B 127       8.589  63.334  50.380  1.00  9.59           N  
ATOM   2048  CA  PHE B 127       8.908  64.730  50.632  1.00  9.95           C  
ATOM   2049  C   PHE B 127       8.008  65.347  51.703  1.00  9.08           C  
ATOM   2050  O   PHE B 127       8.526  66.021  52.616  1.00  9.92           O  
ATOM   2051  CB  PHE B 127       8.843  65.553  49.326  1.00  8.55           C  
ATOM   2052  CG  PHE B 127       8.931  67.050  49.544  1.00  7.80           C  
ATOM   2053  CD1 PHE B 127      10.142  67.674  49.772  1.00 11.07           C  
ATOM   2054  CD2 PHE B 127       7.785  67.823  49.541  1.00  6.81           C  
ATOM   2055  CE1 PHE B 127      10.206  69.054  49.969  1.00  9.00           C  
ATOM   2056  CE2 PHE B 127       7.829  69.161  49.736  1.00 10.31           C  
ATOM   2057  CZ  PHE B 127       9.037  69.787  49.975  1.00 10.40           C  
ATOM   2058  N   ALA B 128       6.702  65.127  51.589  1.00  7.23           N  
ATOM   2059  CA  ALA B 128       5.701  65.804  52.425  1.00  6.23           C  
ATOM   2060  C   ALA B 128       5.904  65.480  53.908  1.00  8.11           C  
ATOM   2061  O   ALA B 128       5.762  66.335  54.788  1.00 10.39           O  
ATOM   2062  CB  ALA B 128       4.324  65.380  52.008  1.00  7.17           C  
ATOM   2063  N   VAL B 129       6.207  64.223  54.178  1.00 10.48           N  
ATOM   2064  CA  VAL B 129       6.427  63.781  55.570  1.00  8.92           C  
ATOM   2065  C   VAL B 129       7.570  64.560  56.236  1.00  9.40           C  
ATOM   2066  O   VAL B 129       7.447  64.932  57.367  1.00  8.40           O  
ATOM   2067  CB  VAL B 129       6.627  62.236  55.633  1.00 10.45           C  
ATOM   2068  CG1 VAL B 129       7.207  61.769  57.024  1.00 15.55           C  
ATOM   2069  CG2 VAL B 129       5.265  61.525  55.254  1.00 11.47           C  
ATOM   2070  N   GLU B 130       8.622  64.842  55.492  1.00  8.15           N  
ATOM   2071  CA  GLU B 130       9.726  65.638  55.984  1.00  7.42           C  
ATOM   2072  C   GLU B 130       9.375  67.124  55.987  1.00  9.28           C  
ATOM   2073  O   GLU B 130       9.667  67.857  56.956  1.00  7.50           O  
ATOM   2074  CB  GLU B 130      11.008  65.361  55.201  1.00 10.91           C  
ATOM   2075  CG  GLU B 130      11.453  63.879  55.192  1.00 15.84           C  
ATOM   2076  CD  GLU B 130      11.431  63.202  56.556  1.00 29.61           C  
ATOM   2077  OE1 GLU B 130      11.996  63.786  57.523  1.00 22.17           O  
ATOM   2078  OE2 GLU B 130      10.855  62.084  56.665  1.00 30.64           O  
ATOM   2079  N   PHE B 131       8.712  67.591  54.941  1.00  8.57           N  
ATOM   2080  CA  PHE B 131       8.369  69.006  54.859  1.00  5.65           C  
ATOM   2081  C   PHE B 131       7.361  69.477  55.923  1.00  5.80           C  
ATOM   2082  O   PHE B 131       7.415  70.616  56.372  1.00  6.72           O  
ATOM   2083  CB  PHE B 131       7.862  69.373  53.450  1.00  6.56           C  
ATOM   2084  CG  PHE B 131       7.776  70.870  53.222  1.00  7.36           C  
ATOM   2085  CD1 PHE B 131       8.899  71.672  53.337  1.00  8.79           C  
ATOM   2086  CD2 PHE B 131       6.561  71.466  52.919  1.00  8.21           C  
ATOM   2087  CE1 PHE B 131       8.808  73.014  53.100  1.00  6.70           C  
ATOM   2088  CE2 PHE B 131       6.458  72.811  52.698  1.00 10.36           C  
ATOM   2089  CZ  PHE B 131       7.582  73.598  52.824  1.00 12.08           C  
ATOM   2090  N   GLU B 132       6.491  68.579  56.342  1.00  6.50           N  
ATOM   2091  CA  GLU B 132       5.536  68.857  57.392  1.00  8.04           C  
ATOM   2092  C   GLU B 132       6.310  69.237  58.650  1.00  6.70           C  
ATOM   2093  O   GLU B 132       5.948  70.177  59.363  1.00  5.48           O  
ATOM   2094  CB  GLU B 132       4.727  67.593  57.671  1.00  6.61           C  
ATOM   2095  CG  GLU B 132       3.688  67.788  58.770  1.00  7.30           C  
ATOM   2096  CD  GLU B 132       2.751  66.589  58.936  1.00 14.97           C  
ATOM   2097  OE1 GLU B 132       3.256  65.452  58.972  1.00 20.31           O  
ATOM   2098  OE2 GLU B 132       1.528  66.817  59.049  1.00 22.09           O  
ATOM   2099  N   LYS B 133       7.382  68.508  58.954  1.00  7.25           N  
ATOM   2100  CA  LYS B 133       8.189  68.826  60.141  1.00  8.69           C  
ATOM   2101  C   LYS B 133       8.989  70.100  59.959  1.00  8.05           C  
ATOM   2102  O   LYS B 133       9.127  70.885  60.912  1.00  5.67           O  
ATOM   2103  CB  LYS B 133       9.117  67.683  60.493  1.00 11.44           C  
ATOM   2104  CG  LYS B 133       8.363  66.441  60.930  1.00 17.38           C  
ATOM   2105  CD  LYS B 133       9.284  65.282  61.214  1.00 26.25           C  
ATOM   2106  CE  LYS B 133       9.955  64.780  59.961  1.00 32.76           C  
ATOM   2107  NZ  LYS B 133      10.344  63.341  60.074  1.00 39.78           N  
ATOM   2108  N   GLU B 134       9.471  70.333  58.719  1.00  3.77           N  
ATOM   2109  CA  GLU B 134      10.186  71.570  58.443  1.00  5.37           C  
ATOM   2110  C   GLU B 134       9.266  72.759  58.637  1.00  3.92           C  
ATOM   2111  O   GLU B 134       9.599  73.714  59.329  1.00  3.83           O  
ATOM   2112  CB  GLU B 134      10.747  71.556  57.022  1.00  4.07           C  
ATOM   2113  CG  GLU B 134      11.655  72.687  56.743  1.00  6.83           C  
ATOM   2114  CD  GLU B 134      12.012  72.826  55.255  1.00 10.30           C  
ATOM   2115  OE1 GLU B 134      12.356  71.828  54.617  1.00  9.36           O  
ATOM   2116  OE2 GLU B 134      11.929  73.968  54.745  1.00  8.07           O  
ATOM   2117  N   LEU B 135       8.081  72.681  58.041  0.50  3.69           N  
ATOM   2119  CA  LEU B 135       7.147  73.797  58.137  0.50  5.83           C  
ATOM   2121  C   LEU B 135       6.751  74.096  59.593  0.50  3.29           C  
ATOM   2123  O   LEU B 135       6.671  75.260  60.011  0.50  4.66           O  
ATOM   2125  CB  LEU B 135       5.922  73.484  57.269  0.50  4.44           C  
ATOM   2127  CG  LEU B 135       4.971  74.613  56.902  0.50 10.45           C  
ATOM   2129  CD1 LEU B 135       5.722  75.735  56.184  0.50  5.47           C  
ATOM   2131  CD2 LEU B 135       3.891  73.992  56.026  0.50  6.20           C  
ATOM   2133  N   ALA B 136       6.533  73.045  60.372  1.00  2.88           N  
ATOM   2134  CA  ALA B 136       6.245  73.202  61.813  1.00  3.24           C  
ATOM   2135  C   ALA B 136       7.392  73.870  62.603  1.00  4.19           C  
ATOM   2136  O   ALA B 136       7.145  74.614  63.559  1.00  5.74           O  
ATOM   2137  CB  ALA B 136       5.907  71.889  62.427  1.00  4.27           C  
ATOM   2138  N   GLY B 137       8.643  73.628  62.209  1.00  3.62           N  
ATOM   2139  CA  GLY B 137       9.809  74.172  62.872  1.00  3.57           C  
ATOM   2140  C   GLY B 137      10.180  75.612  62.475  1.00  2.00           C  
ATOM   2141  O   GLY B 137      11.129  76.156  62.971  1.00  2.00           O  
ATOM   2142  N   LYS B 138       9.419  76.163  61.499  1.00  2.00           N  
ATOM   2143  CA  LYS B 138       9.633  77.530  61.017  1.00  4.24           C  
ATOM   2144  C   LYS B 138       8.514  78.486  61.360  1.00  3.73           C  
ATOM   2145  O   LYS B 138       8.647  79.680  61.140  1.00  6.73           O  
ATOM   2146  CB  LYS B 138       9.874  77.539  59.501  1.00  3.27           C  
ATOM   2147  CG  LYS B 138      10.985  76.626  59.057  1.00  5.08           C  
ATOM   2148  CD  LYS B 138      11.285  76.773  57.584  1.00  8.49           C  
ATOM   2149  CE  LYS B 138      10.133  76.374  56.720  1.00  3.77           C  
ATOM   2150  NZ  LYS B 138      10.457  76.127  55.251  1.00 12.48           N  
ATOM   2151  N   ARG B 139       7.428  77.955  61.922  1.00  5.54           N  
ATOM   2152  CA  ARG B 139       6.215  78.700  62.161  1.00  6.35           C  
ATOM   2153  C   ARG B 139       5.790  78.562  63.592  1.00  2.92           C  
ATOM   2154  O   ARG B 139       5.985  77.519  64.175  1.00  4.73           O  
ATOM   2155  CB  ARG B 139       5.087  78.135  61.295  1.00  9.94           C  
ATOM   2156  CG  ARG B 139       5.420  78.103  59.821  1.00 20.58           C  
ATOM   2157  CD  ARG B 139       4.233  77.676  58.992  1.00 30.92           C  
ATOM   2158  NE  ARG B 139       4.376  78.144  57.612  1.00 34.63           N  
ATOM   2159  CZ  ARG B 139       3.523  77.852  56.631  1.00 37.87           C  
ATOM   2160  NH1 ARG B 139       2.463  77.087  56.881  1.00 28.29           N  
ATOM   2161  NH2 ARG B 139       3.740  78.327  55.397  1.00 36.72           N  
ATOM   2162  N   THR B 140       5.136  79.587  64.093  1.00  2.00           N  
ATOM   2163  CA  THR B 140       4.614  79.605  65.458  1.00  2.02           C  
ATOM   2164  C   THR B 140       3.485  78.550  65.634  1.00  8.67           C  
ATOM   2165  O   THR B 140       2.759  78.250  64.715  1.00  7.59           O  
ATOM   2166  CB  THR B 140       4.173  81.000  65.854  1.00  5.78           C  
ATOM   2167  OG1 THR B 140       5.296  81.890  65.720  1.00  6.91           O  
ATOM   2168  CG2 THR B 140       3.721  81.046  67.328  1.00  5.32           C  
ATOM   2169  OXT THR B 140       3.315  77.976  66.717  1.00 13.80           O  
TER    2170      THR B 140                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
