
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  119 (  949),  selected  119 , name 1p8c_C
# Molecule2: number of CA atoms   98 (  717),  selected   98 , name T0408.pdb
# PARAMETERS: 1p8c_C.T0408.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     2_C      F       7           -
LGA    Y     3_C      -       -           -
LGA    K     4_C      -       -           -
LGA    K     5_C      -       -           -
LGA    F     6_C      -       -           -
LGA    V     7_C      -       -           -
LGA    E     8_C      -       -           -
LGA    A     9_C      -       -           -
LGA    R    10_C      G       8          2.234
LGA    R    11_C      E       9          4.118
LGA    E    12_C      -       -           -
LGA    L    13_C      G      10          3.858
LGA    N    14_C      M      11          2.007
LGA    E    15_C      K      12          1.703
LGA    K    16_C      V      13          1.962
LGA    V    17_C      V      14          2.043
LGA    L    18_C      K      15          2.647
LGA    S    19_C      E      16          1.977
LGA    R    20_C      K      17          1.354
LGA    G    21_C      Y      18          2.211
LGA    T    22_C      P      19           #
LGA    L    23_C      D      20          2.844
LGA    N    24_C      L      21          3.445
LGA    T    25_C      Y      22          4.819
LGA    K    26_C      D      23          3.794
LGA    R    27_C      I      24          1.555
LGA    F    28_C      I      25          2.797
LGA    F    29_C      V      26          4.470
LGA    N    30_C      K      27          3.642
LGA    L    31_C      L      28          1.586
LGA    D    32_C      N      29          3.098
LGA    S    33_C      D      30          4.346
LGA    A    34_C      T      31          3.454
LGA    V    35_C      V      32          1.532
LGA    Y    36_C      F      33          2.338
LGA    R    37_C      T      34          3.574
LGA    P    38_C      G      35          5.162
LGA    G    39_C      K      36          3.869
LGA    K    40_C      T      37          1.231
LGA    L    41_C      L      38          1.066
LGA    D    42_C      D      39          1.379
LGA    V    43_C      Y      40          1.523
LGA    K    44_C      K      41          1.203
LGA    T    45_C      T      42          0.735
LGA    K    46_C      Q      43          0.942
LGA    E    47_C      K      44          0.853
LGA    L    48_C      L      45          0.433
LGA    M    49_C      I      46          0.539
LGA    G    50_C      A      47          0.680
LGA    L    51_C      I      48          0.457
LGA    V    52_C      G      49          0.547
LGA    A    53_C      I      50          0.810
LGA    S    54_C      V      51          0.734
LGA    T    55_C      A      52          0.588
LGA    V    56_C      S      53          0.803
LGA    L    57_C      R      54          2.222
LGA    R    58_C      C      55          2.705
LGA    C    59_C      D      56          2.252
LGA    D    60_C      E      57          2.264
LGA    D    61_C      V      58          2.740
LGA    C    62_C      A      59          2.468
LGA    I    63_C      I      60          1.728
LGA    R    64_C      E      61          2.112
LGA    Y    65_C      K      62          2.554
LGA    H    66_C      Q      63          2.237
LGA    L    67_C      M      64          1.292
LGA    V    68_C      K      65          2.698
LGA    R    69_C      S      66          3.383
LGA    C    70_C      A      67          2.759
LGA    V    71_C      M      68          1.841
LGA    Q    72_C      K      69          3.901
LGA    -       -      E      70           -
LGA    E    73_C      L      71          2.036
LGA    G    74_C      G      72          2.863
LGA    A    75_C      I      73          2.645
LGA    S    76_C      T      74          3.135
LGA    D    77_C      K      75          2.651
LGA    E    78_C      E      76          2.373
LGA    E    79_C      E      77          1.766
LGA    I    80_C      I      78          1.354
LGA    F    81_C      A      79          0.899
LGA    E    82_C      D      80          0.907
LGA    A    83_C      V      81          0.714
LGA    L    84_C      L      82          1.083
LGA    D    85_C      R      83          0.938
LGA    I    86_C      V      84          0.472
LGA    A    87_C      V      85          1.283
LGA    L    88_C      L      86          2.126
LGA    V    89_C      L      87          1.861
LGA    V    90_C      T      88          0.655
LGA    G    91_C      S      89          1.257
LGA    G    92_C      G      90          1.302
LGA    S    93_C      M      91          1.937
LGA    I    94_C      P      92          2.558
LGA    V    95_C      A      93          0.682
LGA    I    96_C      F      94          3.810
LGA    P    97_C      T      95          4.995
LGA    H    98_C      K      96          2.663
LGA    L    99_C      A      97          1.220
LGA    R   100_C      M      98          3.724
LGA    -       -      K      99           -
LGA    R   101_C      I     100          1.739
LGA    A   102_C      L     101          2.833
LGA    V   103_C      E     102          2.287
LGA    G   104_C      K     103          0.984
LGA    F   105_C      L     104          1.715
LGA    L   106_C      -       -           -
LGA    E   107_C      -       -           -
LGA    E   108_C      -       -           -
LGA    L   109_C      -       -           -
LGA    R   110_C      -       -           -
LGA    E   111_C      -       -           -
LGA    M   112_C      -       -           -
LGA    E   113_C      -       -           -
LGA    K   114_C      -       -           -
LGA    N   115_C      -       -           -
LGA    G   116_C      -       -           -
LGA    E   117_C      -       -           -
LGA    T   118_C      -       -           -
LGA    I   119_C      -       -           -
LGA    S   120_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  119   98    5.0     94    2.42    17.02     73.510     3.736

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.655509 * X  +  -0.387116 * Y  +   0.648421 * Z  +  -8.124549
  Y_new =  -0.707383 * X  +  -0.014114 * Y  +   0.706689 * Z  +  58.584278
  Z_new =  -0.264419 * X  +  -0.921923 * Y  +  -0.283091 * Z  +  71.936516 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.868723    1.272869  [ DEG:  -107.0699     72.9301 ]
  Theta =   0.267601    2.873991  [ DEG:    15.3324    164.6676 ]
  Phi   =  -0.823442    2.318151  [ DEG:   -47.1797    132.8203 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1p8c_C                                        
REMARK     2: T0408.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1p8c_C.T0408.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  119   98   5.0   94   2.42   17.02  73.510
REMARK  ---------------------------------------------------------- 
MOLECULE 1p8c_C
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   06-MAY-03   1P8C              
TITLE     CRYSTAL STRUCTURE OF TM1620 (APC4843) FROM THERMOTOGA                 
TITLE    2 MARITIMA                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CONSERVED HYPOTHETICAL PROTEIN;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: TM1620 (APC4843);                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    CONSERVED HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, PSI,             
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,A.JOACHIMIAK,J.S.BRUNZELLE,S.V.KOROLEV,A.EDWARDS,X.XU,          
AUTHOR   2 A.SAVCHENKO,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)            
REVDAT   2   18-JAN-05 1P8C    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   23-SEP-03 1P8C    0                                                
JRNL        AUTH   Y.KIM,A.JOACHIMIAK,J.S.BRUNZELLE,S.V.KOROLEV,                
JRNL        AUTH 2 A.EDWARDS,X.XU,A.SAVCHENKO                                   
JRNL        TITL   CRYSTAL STRUCTURE ANALYSIS OF THERMOTOGA MARITIMA            
JRNL        TITL 2 PROTEIN TM1620 (APC4843)                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1P8C A    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C B    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C C    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C D    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C E    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
DBREF  1P8C F    1   121  UNP    Q9X1V5   Q9X1V5_THEMA     1    121             
SEQRES   1 A  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 A  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 A  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 A  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 A  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 A  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 A  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 A  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 A  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 A  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 A  145  GLY SER                                                      
SEQRES   1 B  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 B  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 B  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 B  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 B  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 B  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 B  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 B  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 B  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 B  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 B  145  GLY SER                                                      
SEQRES   1 C  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 C  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 C  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 C  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 C  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 C  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 C  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 C  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 C  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 C  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 C  145  GLY SER                                                      
SEQRES   1 D  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 D  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 D  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 D  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 D  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 D  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 D  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 D  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 D  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 D  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 D  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 D  145  GLY SER                                                      
SEQRES   1 E  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 E  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 E  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 E  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 E  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 E  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 E  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 E  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 E  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 E  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 E  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 E  145  GLY SER                                                      
SEQRES   1 F  145  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 F  145  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET GLU TYR LYS          
SEQRES   3 F  145  LYS PHE VAL GLU ALA ARG ARG GLU LEU ASN GLU LYS VAL          
SEQRES   4 F  145  LEU SER ARG GLY THR LEU ASN THR LYS ARG PHE PHE ASN          
SEQRES   5 F  145  LEU ASP SER ALA VAL TYR ARG PRO GLY LYS LEU ASP VAL          
SEQRES   6 F  145  LYS THR LYS GLU LEU MET GLY LEU VAL ALA SER THR VAL          
SEQRES   7 F  145  LEU ARG CYS ASP ASP CYS ILE ARG TYR HIS LEU VAL ARG          
SEQRES   8 F  145  CYS VAL GLN GLU GLY ALA SER ASP GLU GLU ILE PHE GLU          
SEQRES   9 F  145  ALA LEU ASP ILE ALA LEU VAL VAL GLY GLY SER ILE VAL          
SEQRES  10 F  145  ILE PRO HIS LEU ARG ARG ALA VAL GLY PHE LEU GLU GLU          
SEQRES  11 F  145  LEU ARG GLU MET GLU LYS ASN GLY GLU THR ILE SER LEU          
SEQRES  12 F  145  GLY SER                                                      
FORMUL   7  HOH   *87(H2 O)                                                     
CRYST1   65.819   82.541  135.397  90.00  90.00  90.00 P 21 21 21   24          
ATOM   1791  N   GLU C   2      17.124  66.741  49.439  1.00100.35           N  
ATOM   1792  CA  GLU C   2      17.371  67.160  48.030  1.00100.61           C  
ATOM   1793  C   GLU C   2      16.495  68.341  47.632  1.00 97.83           C  
ATOM   1794  O   GLU C   2      16.517  68.779  46.485  1.00 97.95           O  
ATOM   1795  CB  GLU C   2      17.104  65.993  47.089  1.00178.94           C  
ATOM   1796  CG  GLU C   2      17.809  64.722  47.493  1.00179.32           C  
ATOM   1797  CD  GLU C   2      17.485  63.574  46.571  1.00128.83           C  
ATOM   1798  OE1 GLU C   2      16.285  63.336  46.326  1.00128.64           O  
ATOM   1799  OE2 GLU C   2      18.425  62.906  46.093  1.00128.65           O  
ATOM   1800  N   TYR C   3      15.724  68.851  48.588  1.00115.68           N  
ATOM   1801  CA  TYR C   3      14.831  69.986  48.358  1.00115.50           C  
ATOM   1802  C   TYR C   3      15.547  71.204  47.789  1.00115.65           C  
ATOM   1803  O   TYR C   3      15.058  71.838  46.855  1.00115.77           O  
ATOM   1804  CB  TYR C   3      14.149  70.388  49.665  1.00 75.85           C  
ATOM   1805  CG  TYR C   3      13.484  71.748  49.627  1.00 75.59           C  
ATOM   1806  CD1 TYR C   3      12.287  71.949  48.942  1.00 75.48           C  
ATOM   1807  CD2 TYR C   3      14.054  72.836  50.282  1.00 75.49           C  
ATOM   1808  CE1 TYR C   3      11.670  73.203  48.916  1.00 75.48           C  
ATOM   1809  CE2 TYR C   3      13.446  74.093  50.260  1.00 75.51           C  
ATOM   1810  CZ  TYR C   3      12.256  74.269  49.578  1.00 75.49           C  
ATOM   1811  OH  TYR C   3      11.662  75.514  49.569  1.00 75.49           O  
ATOM   1812  N   LYS C   4      16.694  71.538  48.368  1.00 99.44           N  
ATOM   1813  CA  LYS C   4      17.466  72.687  47.919  1.00 96.21           C  
ATOM   1814  C   LYS C   4      18.031  72.437  46.529  1.00 95.58           C  
ATOM   1815  O   LYS C   4      18.400  73.377  45.826  1.00 95.67           O  
ATOM   1816  CB  LYS C   4      18.589  72.983  48.914  1.00144.01           C  
ATOM   1817  CG  LYS C   4      18.071  73.283  50.316  1.00139.90           C  
ATOM   1818  CD  LYS C   4      19.183  73.675  51.278  1.00136.21           C  
ATOM   1819  CE  LYS C   4      18.615  74.016  52.653  1.00133.50           C  
ATOM   1820  NZ  LYS C   4      19.661  74.495  53.601  1.00130.05           N  
ATOM   1821  N   LYS C   5      18.096  71.163  46.144  1.00101.17           N  
ATOM   1822  CA  LYS C   5      18.594  70.779  44.824  1.00 99.95           C  
ATOM   1823  C   LYS C   5      17.509  71.211  43.851  1.00 97.31           C  
ATOM   1824  O   LYS C   5      17.778  71.776  42.797  1.00 96.84           O  
ATOM   1825  CB  LYS C   5      18.772  69.255  44.728  1.00105.09           C  
ATOM   1826  CG  LYS C   5      19.656  68.627  45.802  1.00107.78           C  
ATOM   1827  CD  LYS C   5      21.119  68.992  45.615  1.00108.34           C  
ATOM   1828  CE  LYS C   5      22.002  68.303  46.648  1.00107.12           C  
ATOM   1829  NZ  LYS C   5      23.448  68.562  46.405  1.00107.78           N  
ATOM   1830  N   PHE C   6      16.272  70.941  44.246  1.00 89.03           N  
ATOM   1831  CA  PHE C   6      15.101  71.269  43.454  1.00 85.19           C  
ATOM   1832  C   PHE C   6      14.928  72.776  43.236  1.00 85.07           C  
ATOM   1833  O   PHE C   6      15.349  73.312  42.215  1.00 86.14           O  
ATOM   1834  CB  PHE C   6      13.853  70.683  44.128  1.00 60.65           C  
ATOM   1835  CG  PHE C   6      12.569  71.078  43.466  1.00 57.79           C  
ATOM   1836  CD1 PHE C   6      12.292  70.675  42.154  1.00 57.30           C  
ATOM   1837  CD2 PHE C   6      11.668  71.924  44.121  1.00 55.90           C  
ATOM   1838  CE1 PHE C   6      11.139  71.116  41.494  1.00 54.87           C  
ATOM   1839  CE2 PHE C   6      10.506  72.376  43.471  1.00 55.12           C  
ATOM   1840  CZ  PHE C   6      10.245  71.970  42.151  1.00 54.97           C  
ATOM   1841  N   VAL C   7      14.312  73.450  44.203  1.00 61.95           N  
ATOM   1842  CA  VAL C   7      14.045  74.885  44.136  1.00 61.45           C  
ATOM   1843  C   VAL C   7      15.103  75.751  43.440  1.00 60.18           C  
ATOM   1844  O   VAL C   7      14.765  76.756  42.798  1.00 57.30           O  
ATOM   1845  CB  VAL C   7      13.815  75.455  45.549  1.00 94.95           C  
ATOM   1846  CG1 VAL C   7      13.637  76.967  45.488  1.00 96.60           C  
ATOM   1847  CG2 VAL C   7      12.596  74.806  46.165  1.00 95.71           C  
ATOM   1848  N   GLU C   8      16.370  75.365  43.564  1.00 64.26           N  
ATOM   1849  CA  GLU C   8      17.454  76.137  42.969  1.00 65.89           C  
ATOM   1850  C   GLU C   8      17.551  75.935  41.469  1.00 64.18           C  
ATOM   1851  O   GLU C   8      17.709  76.896  40.712  1.00 61.73           O  
ATOM   1852  CB  GLU C   8      18.796  75.766  43.601  1.00137.40           C  
ATOM   1853  CG  GLU C   8      19.297  74.388  43.208  1.00141.23           C  
ATOM   1854  CD  GLU C   8      20.793  74.245  43.384  1.00144.60           C  
ATOM   1855  OE1 GLU C   8      21.539  75.045  42.776  1.00144.99           O  
ATOM   1856  OE2 GLU C   8      21.222  73.334  44.124  1.00144.49           O  
ATOM   1857  N   ALA C   9      17.461  74.675  41.046  1.00 61.34           N  
ATOM   1858  CA  ALA C   9      17.554  74.325  39.640  1.00 60.57           C  
ATOM   1859  C   ALA C   9      16.351  74.835  38.847  1.00 60.24           C  
ATOM   1860  O   ALA C   9      16.492  75.184  37.682  1.00 58.80           O  
ATOM   1861  CB  ALA C   9      17.701  72.819  39.498  1.00 56.86           C  
ATOM   1862  N   ARG C  10      15.174  74.883  39.472  1.00 69.97           N  
ATOM   1863  CA  ARG C  10      13.977  75.380  38.795  1.00 71.54           C  
ATOM   1864  C   ARG C  10      14.203  76.879  38.493  1.00 72.59           C  
ATOM   1865  O   ARG C  10      14.172  77.290  37.324  1.00 72.29           O  
ATOM   1866  CB  ARG C  10      12.720  75.181  39.674  1.00 70.64           C  
ATOM   1867  CG  ARG C  10      11.382  75.305  38.911  1.00 69.99           C  
ATOM   1868  CD  ARG C  10      10.138  75.127  39.795  1.00 69.62           C  
ATOM   1869  NE  ARG C  10       8.908  74.886  39.017  1.00 71.46           N  
ATOM   1870  CZ  ARG C  10       8.551  73.713  38.461  1.00 71.24           C  
ATOM   1871  NH1 ARG C  10       9.319  72.634  38.583  1.00 69.77           N  
ATOM   1872  NH2 ARG C  10       7.422  73.610  37.762  1.00 68.59           N  
ATOM   1873  N   ARG C  11      14.452  77.678  39.540  1.00 51.62           N  
ATOM   1874  CA  ARG C  11      14.700  79.116  39.380  1.00 53.89           C  
ATOM   1875  C   ARG C  11      15.788  79.319  38.325  1.00 50.79           C  
ATOM   1876  O   ARG C  11      15.694  80.222  37.493  1.00 49.28           O  
ATOM   1877  CB  ARG C  11      15.165  79.760  40.693  1.00122.43           C  
ATOM   1878  CG  ARG C  11      16.644  79.548  40.988  1.00129.46           C  
ATOM   1879  CD  ARG C  11      17.144  80.370  42.162  1.00133.26           C  
ATOM   1880  NE  ARG C  11      18.542  80.074  42.461  1.00138.24           N  
ATOM   1881  CZ  ARG C  11      19.241  80.644  43.436  1.00140.56           C  
ATOM   1882  NH1 ARG C  11      18.678  81.552  44.224  1.00142.66           N  
ATOM   1883  NH2 ARG C  11      20.508  80.302  43.626  1.00142.29           N  
ATOM   1884  N   GLU C  12      16.804  78.461  38.366  1.00 68.99           N  
ATOM   1885  CA  GLU C  12      17.916  78.508  37.422  1.00 69.05           C  
ATOM   1886  C   GLU C  12      17.437  78.364  35.978  1.00 66.33           C  
ATOM   1887  O   GLU C  12      17.308  79.339  35.236  1.00 66.48           O  
ATOM   1888  CB  GLU C  12      18.914  77.371  37.701  1.00111.87           C  
ATOM   1889  CG  GLU C  12      19.789  77.508  38.941  1.00117.04           C  
ATOM   1890  CD  GLU C  12      20.882  78.542  38.787  1.00119.93           C  
ATOM   1891  OE1 GLU C  12      21.496  78.602  37.699  1.00121.81           O  
ATOM   1892  OE2 GLU C  12      21.139  79.284  39.759  1.00121.53           O  
ATOM   1893  N   LEU C  13      17.183  77.121  35.594  1.00 57.83           N  
ATOM   1894  CA  LEU C  13      16.759  76.792  34.249  1.00 55.26           C  
ATOM   1895  C   LEU C  13      15.550  77.586  33.764  1.00 53.47           C  
ATOM   1896  O   LEU C  13      15.496  77.955  32.600  1.00 53.44           O  
ATOM   1897  CB  LEU C  13      16.510  75.282  34.155  1.00 57.70           C  
ATOM   1898  CG  LEU C  13      17.723  74.451  34.613  1.00 57.88           C  
ATOM   1899  CD1 LEU C  13      17.365  72.970  34.659  1.00 58.25           C  
ATOM   1900  CD2 LEU C  13      18.899  74.705  33.673  1.00 57.17           C  
ATOM   1901  N   ASN C  14      14.585  77.859  34.635  1.00 50.92           N  
ATOM   1902  CA  ASN C  14      13.433  78.641  34.197  1.00 51.01           C  
ATOM   1903  C   ASN C  14      13.898  79.996  33.685  1.00 50.48           C  
ATOM   1904  O   ASN C  14      13.450  80.464  32.628  1.00 47.65           O  
ATOM   1905  CB  ASN C  14      12.439  78.828  35.340  1.00 59.61           C  
ATOM   1906  CG  ASN C  14      11.444  77.705  35.406  1.00 60.48           C  
ATOM   1907  OD1 ASN C  14      11.638  76.663  34.773  1.00 59.66           O  
ATOM   1908  ND2 ASN C  14      10.371  77.900  36.164  1.00 61.07           N  
ATOM   1909  N   GLU C  15      14.807  80.611  34.438  1.00 57.47           N  
ATOM   1910  CA  GLU C  15      15.363  81.905  34.067  1.00 60.99           C  
ATOM   1911  C   GLU C  15      16.036  81.748  32.698  1.00 60.58           C  
ATOM   1912  O   GLU C  15      15.757  82.513  31.760  1.00 58.61           O  
ATOM   1913  CB  GLU C  15      16.391  82.350  35.109  1.00116.21           C  
ATOM   1914  CG  GLU C  15      16.672  83.842  35.104  1.00122.87           C  
ATOM   1915  CD  GLU C  15      17.840  84.218  35.994  1.00126.06           C  
ATOM   1916  OE1 GLU C  15      17.907  83.717  37.137  1.00127.32           O  
ATOM   1917  OE2 GLU C  15      18.684  85.023  35.550  1.00125.78           O  
ATOM   1918  N   LYS C  16      16.905  80.741  32.584  1.00 68.15           N  
ATOM   1919  CA  LYS C  16      17.605  80.479  31.329  1.00 70.16           C  
ATOM   1920  C   LYS C  16      16.579  80.341  30.220  1.00 69.39           C  
ATOM   1921  O   LYS C  16      16.616  81.060  29.230  1.00 69.62           O  
ATOM   1922  CB  LYS C  16      18.421  79.187  31.414  1.00 97.21           C  
ATOM   1923  CG  LYS C  16      19.482  79.167  32.491  1.00100.89           C  
ATOM   1924  CD  LYS C  16      20.204  77.828  32.497  1.00103.99           C  
ATOM   1925  CE  LYS C  16      21.089  77.674  33.727  1.00106.58           C  
ATOM   1926  NZ  LYS C  16      21.633  76.289  33.862  1.00109.32           N  
ATOM   1927  N   VAL C  17      15.654  79.408  30.407  1.00 66.32           N  
ATOM   1928  CA  VAL C  17      14.605  79.153  29.430  1.00 66.10           C  
ATOM   1929  C   VAL C  17      13.981  80.426  28.869  1.00 65.07           C  
ATOM   1930  O   VAL C  17      13.983  80.624  27.662  1.00 63.33           O  
ATOM   1931  CB  VAL C  17      13.484  78.275  30.035  1.00 74.55           C  
ATOM   1932  CG1 VAL C  17      12.324  78.148  29.052  1.00 75.17           C  
ATOM   1933  CG2 VAL C  17      14.034  76.900  30.370  1.00 74.28           C  
ATOM   1934  N   LEU C  18      13.446  81.277  29.740  1.00 64.90           N  
ATOM   1935  CA  LEU C  18      12.818  82.515  29.298  1.00 66.41           C  
ATOM   1936  C   LEU C  18      13.827  83.412  28.590  1.00 68.22           C  
ATOM   1937  O   LEU C  18      13.538  83.971  27.525  1.00 67.06           O  
ATOM   1938  CB  LEU C  18      12.211  83.251  30.490  1.00 72.20           C  
ATOM   1939  CG  LEU C  18      11.181  82.426  31.265  1.00 72.62           C  
ATOM   1940  CD1 LEU C  18      10.448  83.328  32.243  1.00 71.83           C  
ATOM   1941  CD2 LEU C  18      10.189  81.781  30.294  1.00 71.71           C  
ATOM   1942  N   SER C  19      15.007  83.538  29.195  1.00 95.12           N  
ATOM   1943  CA  SER C  19      16.093  84.337  28.636  1.00 95.17           C  
ATOM   1944  C   SER C  19      16.174  84.102  27.134  1.00 94.63           C  
ATOM   1945  O   SER C  19      15.755  84.948  26.346  1.00 96.60           O  
ATOM   1946  CB  SER C  19      17.420  83.949  29.297  1.00 73.43           C  
ATOM   1947  OG  SER C  19      18.529  84.422  28.555  1.00 74.58           O  
ATOM   1948  N   ARG C  20      16.711  82.949  26.740  1.00 60.46           N  
ATOM   1949  CA  ARG C  20      16.821  82.619  25.320  1.00 60.37           C  
ATOM   1950  C   ARG C  20      15.479  82.184  24.770  1.00 55.47           C  
ATOM   1951  O   ARG C  20      15.393  81.639  23.677  1.00 54.64           O  
ATOM   1952  CB  ARG C  20      17.859  81.519  25.089  1.00112.33           C  
ATOM   1953  CG  ARG C  20      19.281  82.040  25.107  1.00120.12           C  
ATOM   1954  CD  ARG C  20      20.268  80.991  24.665  1.00125.35           C  
ATOM   1955  NE  ARG C  20      20.257  79.835  25.551  1.00130.84           N  
ATOM   1956  CZ  ARG C  20      21.099  78.813  25.449  1.00133.04           C  
ATOM   1957  NH1 ARG C  20      22.025  78.804  24.497  1.00135.04           N  
ATOM   1958  NH2 ARG C  20      21.016  77.799  26.296  1.00134.75           N  
ATOM   1959  N   GLY C  21      14.433  82.453  25.543  1.00 64.93           N  
ATOM   1960  CA  GLY C  21      13.092  82.079  25.143  1.00 60.74           C  
ATOM   1961  C   GLY C  21      12.500  82.990  24.096  1.00 57.68           C  
ATOM   1962  O   GLY C  21      13.216  83.584  23.301  1.00 58.36           O  
ATOM   1963  N   THR C  22      11.179  83.091  24.121  1.00 49.34           N  
ATOM   1964  CA  THR C  22      10.407  83.898  23.194  1.00 45.48           C  
ATOM   1965  C   THR C  22       9.346  84.593  24.024  1.00 42.47           C  
ATOM   1966  O   THR C  22       9.206  84.304  25.205  1.00 39.64           O  
ATOM   1967  CB  THR C  22       9.733  82.996  22.162  1.00 62.15           C  
ATOM   1968  OG1 THR C  22      10.740  82.412  21.332  1.00 63.90           O  
ATOM   1969  CG2 THR C  22       8.750  83.767  21.307  1.00 66.84           C  
ATOM   1970  N   LEU C  23       8.611  85.520  23.427  1.00 47.30           N  
ATOM   1971  CA  LEU C  23       7.568  86.222  24.163  1.00 45.02           C  
ATOM   1972  C   LEU C  23       6.464  85.194  24.462  1.00 42.17           C  
ATOM   1973  O   LEU C  23       5.694  85.341  25.403  1.00 40.94           O  
ATOM   1974  CB  LEU C  23       7.018  87.382  23.314  1.00 36.74           C  
ATOM   1975  CG  LEU C  23       6.308  88.570  23.984  1.00 38.66           C  
ATOM   1976  CD1 LEU C  23       5.549  89.360  22.928  1.00 36.16           C  
ATOM   1977  CD2 LEU C  23       5.328  88.111  25.040  1.00 38.95           C  
ATOM   1978  N   ASN C  24       6.400  84.147  23.645  1.00 40.78           N  
ATOM   1979  CA  ASN C  24       5.386  83.105  23.841  1.00 39.79           C  
ATOM   1980  C   ASN C  24       5.799  82.217  25.010  1.00 36.91           C  
ATOM   1981  O   ASN C  24       4.974  81.863  25.840  1.00 32.57           O  
ATOM   1982  CB  ASN C  24       5.199  82.245  22.581  1.00 36.97           C  
ATOM   1983  CG  ASN C  24       4.667  83.041  21.404  1.00 35.96           C  
ATOM   1984  OD1 ASN C  24       3.726  83.828  21.531  1.00 37.57           O  
ATOM   1985  ND2 ASN C  24       5.267  82.828  20.245  1.00 35.20           N  
ATOM   1986  N   THR C  25       7.079  81.876  25.060  1.00 32.28           N  
ATOM   1987  CA  THR C  25       7.589  81.074  26.139  1.00 37.96           C  
ATOM   1988  C   THR C  25       7.202  81.765  27.446  1.00 39.90           C  
ATOM   1989  O   THR C  25       6.610  81.147  28.337  1.00 42.65           O  
ATOM   1990  CB  THR C  25       9.097  80.945  26.064  1.00 40.56           C  
ATOM   1991  OG1 THR C  25       9.486  80.825  24.692  1.00 40.09           O  
ATOM   1992  CG2 THR C  25       9.549  79.673  26.812  1.00 40.99           C  
ATOM   1993  N   LYS C  26       7.498  83.057  27.538  1.00 38.77           N  
ATOM   1994  CA  LYS C  26       7.161  83.831  28.728  1.00 39.80           C  
ATOM   1995  C   LYS C  26       5.671  83.919  28.992  1.00 36.19           C  
ATOM   1996  O   LYS C  26       5.256  83.923  30.139  1.00 36.32           O  
ATOM   1997  CB  LYS C  26       7.707  85.264  28.618  1.00 60.15           C  
ATOM   1998  CG  LYS C  26       9.218  85.359  28.525  1.00 66.43           C  
ATOM   1999  CD  LYS C  26       9.688  86.789  28.279  1.00 69.97           C  
ATOM   2000  CE  LYS C  26      11.193  86.827  28.229  1.00 68.94           C  
ATOM   2001  NZ  LYS C  26      11.676  85.735  27.340  1.00 75.53           N  
ATOM   2002  N   ARG C  27       4.857  84.018  27.945  1.00 33.86           N  
ATOM   2003  CA  ARG C  27       3.413  84.145  28.161  1.00 32.62           C  
ATOM   2004  C   ARG C  27       2.809  82.855  28.690  1.00 30.60           C  
ATOM   2005  O   ARG C  27       1.885  82.881  29.506  1.00 25.20           O  
ATOM   2006  CB  ARG C  27       2.697  84.581  26.876  1.00 39.89           C  
ATOM   2007  CG  ARG C  27       2.360  86.058  26.846  1.00 45.18           C  
ATOM   2008  CD  ARG C  27       2.041  86.586  25.437  1.00 46.08           C  
ATOM   2009  NE  ARG C  27       2.048  88.055  25.416  1.00 50.17           N  
ATOM   2010  CZ  ARG C  27       2.125  88.814  24.319  1.00 49.54           C  
ATOM   2011  NH1 ARG C  27       2.199  88.264  23.122  1.00 45.54           N  
ATOM   2012  NH2 ARG C  27       2.148  90.135  24.425  1.00 45.92           N  
ATOM   2013  N   PHE C  28       3.326  81.728  28.209  1.00 28.46           N  
ATOM   2014  CA  PHE C  28       2.862  80.443  28.677  1.00 29.23           C  
ATOM   2015  C   PHE C  28       3.297  80.316  30.147  1.00 29.91           C  
ATOM   2016  O   PHE C  28       2.462  80.102  31.022  1.00 31.45           O  
ATOM   2017  CB  PHE C  28       3.474  79.324  27.849  1.00 38.77           C  
ATOM   2018  CG  PHE C  28       2.802  78.013  28.054  1.00 44.13           C  
ATOM   2019  CD1 PHE C  28       1.698  77.667  27.296  1.00 42.79           C  
ATOM   2020  CD2 PHE C  28       3.237  77.140  29.053  1.00 45.93           C  
ATOM   2021  CE1 PHE C  28       1.031  76.468  27.523  1.00 44.68           C  
ATOM   2022  CE2 PHE C  28       2.572  75.937  29.288  1.00 47.28           C  
ATOM   2023  CZ  PHE C  28       1.472  75.604  28.521  1.00 44.11           C  
ATOM   2024  N   PHE C  29       4.586  80.476  30.431  1.00 32.26           N  
ATOM   2025  CA  PHE C  29       5.028  80.374  31.819  1.00 35.46           C  
ATOM   2026  C   PHE C  29       4.164  81.228  32.734  1.00 37.19           C  
ATOM   2027  O   PHE C  29       3.731  80.758  33.786  1.00 36.36           O  
ATOM   2028  CB  PHE C  29       6.507  80.767  31.972  1.00 32.08           C  
ATOM   2029  CG  PHE C  29       7.464  79.687  31.537  1.00 32.67           C  
ATOM   2030  CD1 PHE C  29       7.347  79.096  30.284  1.00 32.29           C  
ATOM   2031  CD2 PHE C  29       8.470  79.238  32.391  1.00 34.37           C  
ATOM   2032  CE1 PHE C  29       8.216  78.073  29.880  1.00 33.08           C  
ATOM   2033  CE2 PHE C  29       9.342  78.214  31.992  1.00 30.31           C  
ATOM   2034  CZ  PHE C  29       9.213  77.637  30.737  1.00 29.17           C  
ATOM   2035  N   ASN C  30       3.883  82.473  32.338  1.00 36.27           N  
ATOM   2036  CA  ASN C  30       3.050  83.322  33.187  1.00 34.97           C  
ATOM   2037  C   ASN C  30       1.670  82.703  33.388  1.00 34.02           C  
ATOM   2038  O   ASN C  30       1.052  82.771  34.467  1.00 34.45           O  
ATOM   2039  CB  ASN C  30       2.909  84.707  32.556  1.00 42.23           C  
ATOM   2040  CG  ASN C  30       4.175  85.525  32.674  1.00 44.60           C  
ATOM   2041  OD1 ASN C  30       4.345  86.522  31.987  1.00 50.35           O  
ATOM   2042  ND2 ASN C  30       5.068  85.110  33.554  1.00 46.18           N  
ATOM   2043  N   LEU C  31       1.173  82.080  32.335  1.00 33.87           N  
ATOM   2044  CA  LEU C  31      -0.134  81.481  32.409  1.00 35.45           C  
ATOM   2045  C   LEU C  31      -0.145  80.254  33.356  1.00 35.08           C  
ATOM   2046  O   LEU C  31      -1.128  80.008  34.046  1.00 32.86           O  
ATOM   2047  CB  LEU C  31      -0.558  81.122  30.995  1.00 46.02           C  
ATOM   2048  CG  LEU C  31      -2.062  81.130  30.763  1.00 51.30           C  
ATOM   2049  CD1 LEU C  31      -2.733  82.342  31.435  1.00 49.96           C  
ATOM   2050  CD2 LEU C  31      -2.283  81.127  29.252  1.00 54.61           C  
ATOM   2051  N   ASP C  32       0.967  79.520  33.392  1.00 33.28           N  
ATOM   2052  CA  ASP C  32       1.133  78.336  34.239  1.00 35.43           C  
ATOM   2053  C   ASP C  32       1.056  78.768  35.719  1.00 36.45           C  
ATOM   2054  O   ASP C  32       0.667  78.007  36.588  1.00 35.80           O  
ATOM   2055  CB  ASP C  32       2.487  77.675  33.924  1.00 41.39           C  
ATOM   2056  CG  ASP C  32       2.767  76.432  34.778  1.00 43.56           C  
ATOM   2057  OD1 ASP C  32       1.833  75.630  35.018  1.00 41.18           O  
ATOM   2058  OD2 ASP C  32       3.936  76.248  35.191  1.00 47.79           O  
ATOM   2059  N   SER C  33       1.433  80.002  36.000  1.00 37.57           N  
ATOM   2060  CA  SER C  33       1.328  80.503  37.359  1.00 37.29           C  
ATOM   2061  C   SER C  33      -0.063  81.088  37.608  1.00 37.63           C  
ATOM   2062  O   SER C  33      -0.704  80.790  38.620  1.00 37.35           O  
ATOM   2063  CB  SER C  33       2.368  81.578  37.607  1.00 46.46           C  
ATOM   2064  OG  SER C  33       1.943  82.340  38.716  1.00 55.84           O  
ATOM   2065  N   ALA C  34      -0.549  81.910  36.672  1.00 33.64           N  
ATOM   2066  CA  ALA C  34      -1.861  82.543  36.823  1.00 30.08           C  
ATOM   2067  C   ALA C  34      -3.047  81.620  37.058  1.00 32.70           C  
ATOM   2068  O   ALA C  34      -4.005  81.962  37.769  1.00 30.46           O  
ATOM   2069  CB  ALA C  34      -2.146  83.404  35.592  1.00 35.96           C  
ATOM   2070  N   VAL C  35      -3.023  80.452  36.428  1.00 31.58           N  
ATOM   2071  CA  VAL C  35      -4.145  79.539  36.547  1.00 32.26           C  
ATOM   2072  C   VAL C  35      -4.378  78.981  37.971  1.00 34.07           C  
ATOM   2073  O   VAL C  35      -5.479  78.484  38.314  1.00 31.61           O  
ATOM   2074  CB  VAL C  35      -3.978  78.415  35.473  1.00 47.84           C  
ATOM   2075  CG1 VAL C  35      -2.794  77.506  35.802  1.00 45.90           C  
ATOM   2076  CG2 VAL C  35      -5.255  77.654  35.325  1.00 51.76           C  
ATOM   2077  N   TYR C  36      -3.345  79.088  38.804  1.00 36.56           N  
ATOM   2078  CA  TYR C  36      -3.412  78.611  40.175  1.00 40.67           C  
ATOM   2079  C   TYR C  36      -3.859  79.664  41.185  1.00 44.25           C  
ATOM   2080  O   TYR C  36      -4.095  79.345  42.349  1.00 43.73           O  
ATOM   2081  CB  TYR C  36      -2.053  78.036  40.576  1.00 36.38           C  
ATOM   2082  CG  TYR C  36      -1.765  76.747  39.840  1.00 33.03           C  
ATOM   2083  CD1 TYR C  36      -2.455  75.575  40.159  1.00 35.44           C  
ATOM   2084  CD2 TYR C  36      -0.873  76.718  38.765  1.00 31.24           C  
ATOM   2085  CE1 TYR C  36      -2.263  74.386  39.409  1.00 33.28           C  
ATOM   2086  CE2 TYR C  36      -0.676  75.572  38.031  1.00 31.49           C  
ATOM   2087  CZ  TYR C  36      -1.366  74.407  38.353  1.00 33.83           C  
ATOM   2088  OH  TYR C  36      -1.121  73.270  37.640  1.00 34.80           O  
ATOM   2089  N   ARG C  37      -3.989  80.911  40.731  1.00 41.99           N  
ATOM   2090  CA  ARG C  37      -4.404  81.999  41.601  1.00 45.59           C  
ATOM   2091  C   ARG C  37      -5.849  81.884  42.103  1.00 43.45           C  
ATOM   2092  O   ARG C  37      -6.674  81.166  41.537  1.00 43.38           O  
ATOM   2093  CB  ARG C  37      -4.181  83.338  40.891  1.00 86.04           C  
ATOM   2094  CG  ARG C  37      -2.715  83.693  40.716  1.00 96.38           C  
ATOM   2095  CD  ARG C  37      -2.566  84.947  39.885  1.00107.97           C  
ATOM   2096  NE  ARG C  37      -1.171  85.352  39.738  1.00118.56           N  
ATOM   2097  CZ  ARG C  37      -0.763  86.375  38.991  1.00122.56           C  
ATOM   2098  NH1 ARG C  37      -1.647  87.101  38.315  1.00125.63           N  
ATOM   2099  NH2 ARG C  37       0.527  86.675  38.923  1.00124.91           N  
ATOM   2100  N   PRO C  38      -6.164  82.591  43.195  1.00 41.66           N  
ATOM   2101  CA  PRO C  38      -7.480  82.624  43.845  1.00 41.47           C  
ATOM   2102  C   PRO C  38      -8.684  82.995  42.952  1.00 42.88           C  
ATOM   2103  O   PRO C  38      -8.627  83.938  42.150  1.00 43.43           O  
ATOM   2104  CB  PRO C  38      -7.288  83.662  44.955  1.00 46.96           C  
ATOM   2105  CG  PRO C  38      -5.812  83.657  45.217  1.00 44.98           C  
ATOM   2106  CD  PRO C  38      -5.203  83.479  43.879  1.00 44.04           C  
ATOM   2107  N   GLY C  39      -9.789  82.282  43.145  1.00 41.84           N  
ATOM   2108  CA  GLY C  39     -11.005  82.548  42.389  1.00 43.25           C  
ATOM   2109  C   GLY C  39     -12.129  81.934  43.189  1.00 43.31           C  
ATOM   2110  O   GLY C  39     -12.045  81.911  44.413  1.00 43.33           O  
ATOM   2111  N   LYS C  40     -13.176  81.452  42.527  1.00 49.30           N  
ATOM   2112  CA  LYS C  40     -14.270  80.792  43.237  1.00 51.26           C  
ATOM   2113  C   LYS C  40     -13.688  79.620  44.046  1.00 50.47           C  
ATOM   2114  O   LYS C  40     -14.271  79.192  45.036  1.00 49.70           O  
ATOM   2115  CB  LYS C  40     -15.310  80.276  42.244  1.00 67.96           C  
ATOM   2116  CG  LYS C  40     -16.489  81.207  41.993  1.00 73.56           C  
ATOM   2117  CD  LYS C  40     -16.062  82.637  41.714  1.00 77.43           C  
ATOM   2118  CE  LYS C  40     -16.998  83.291  40.698  1.00 78.14           C  
ATOM   2119  NZ  LYS C  40     -18.435  83.109  41.038  1.00 82.63           N  
ATOM   2120  N   LEU C  41     -12.535  79.110  43.605  1.00 49.66           N  
ATOM   2121  CA  LEU C  41     -11.834  78.014  44.277  1.00 50.26           C  
ATOM   2122  C   LEU C  41     -10.619  78.657  44.938  1.00 49.23           C  
ATOM   2123  O   LEU C  41      -9.964  79.471  44.318  1.00 46.65           O  
ATOM   2124  CB  LEU C  41     -11.364  76.952  43.264  1.00 48.28           C  
ATOM   2125  CG  LEU C  41     -12.393  76.409  42.261  1.00 50.25           C  
ATOM   2126  CD1 LEU C  41     -11.710  75.506  41.242  1.00 50.27           C  
ATOM   2127  CD2 LEU C  41     -13.482  75.646  42.996  1.00 50.66           C  
ATOM   2128  N   ASP C  42     -10.322  78.283  46.181  1.00 53.11           N  
ATOM   2129  CA  ASP C  42      -9.189  78.845  46.916  1.00 53.47           C  
ATOM   2130  C   ASP C  42      -7.887  78.313  46.376  1.00 51.64           C  
ATOM   2131  O   ASP C  42      -7.884  77.352  45.622  1.00 54.12           O  
ATOM   2132  CB  ASP C  42      -9.284  78.500  48.394  1.00 83.58           C  
ATOM   2133  CG  ASP C  42      -9.478  77.031  48.620  1.00 89.66           C  
ATOM   2134  OD1 ASP C  42     -10.612  76.548  48.414  1.00 90.96           O  
ATOM   2135  OD2 ASP C  42      -8.494  76.359  48.985  1.00 96.21           O  
ATOM   2136  N   VAL C  43      -6.779  78.905  46.808  1.00 42.53           N  
ATOM   2137  CA  VAL C  43      -5.482  78.516  46.321  1.00 41.50           C  
ATOM   2138  C   VAL C  43      -5.038  77.098  46.719  1.00 42.36           C  
ATOM   2139  O   VAL C  43      -4.363  76.412  45.928  1.00 42.65           O  
ATOM   2140  CB  VAL C  43      -4.422  79.585  46.707  1.00 41.92           C  
ATOM   2141  CG1 VAL C  43      -4.457  79.844  48.210  1.00 44.98           C  
ATOM   2142  CG2 VAL C  43      -3.045  79.153  46.243  1.00 40.90           C  
ATOM   2143  N   LYS C  44      -5.411  76.653  47.918  1.00 38.75           N  
ATOM   2144  CA  LYS C  44      -5.062  75.300  48.356  1.00 37.33           C  
ATOM   2145  C   LYS C  44      -5.766  74.293  47.435  1.00 36.42           C  
ATOM   2146  O   LYS C  44      -5.169  73.300  47.018  1.00 31.28           O  
ATOM   2147  CB  LYS C  44      -5.509  75.053  49.814  1.00 48.68           C  
ATOM   2148  CG  LYS C  44      -5.630  73.554  50.194  1.00 51.36           C  
ATOM   2149  CD  LYS C  44      -5.473  73.262  51.699  1.00 51.88           C  
ATOM   2150  CE  LYS C  44      -6.697  73.631  52.529  1.00 52.58           C  
ATOM   2151  NZ  LYS C  44      -7.928  72.936  52.077  1.00 53.54           N  
ATOM   2152  N   THR C  45      -7.036  74.544  47.131  1.00 52.26           N  
ATOM   2153  CA  THR C  45      -7.756  73.641  46.252  1.00 55.83           C  
ATOM   2154  C   THR C  45      -7.116  73.580  44.866  1.00 55.95           C  
ATOM   2155  O   THR C  45      -6.946  72.485  44.299  1.00 57.89           O  
ATOM   2156  CB  THR C  45      -9.226  74.042  46.095  1.00 52.38           C  
ATOM   2157  OG1 THR C  45      -9.905  73.866  47.344  1.00 57.44           O  
ATOM   2158  CG2 THR C  45      -9.904  73.180  45.032  1.00 53.84           C  
ATOM   2159  N   LYS C  46      -6.752  74.735  44.314  1.00 37.83           N  
ATOM   2160  CA  LYS C  46      -6.139  74.724  42.989  1.00 34.67           C  
ATOM   2161  C   LYS C  46      -4.775  74.062  43.005  1.00 33.30           C  
ATOM   2162  O   LYS C  46      -4.420  73.369  42.048  1.00 27.32           O  
ATOM   2163  CB  LYS C  46      -6.008  76.150  42.390  1.00 34.56           C  
ATOM   2164  CG  LYS C  46      -7.369  76.832  42.052  1.00 32.76           C  
ATOM   2165  CD  LYS C  46      -7.238  78.080  41.183  1.00 31.83           C  
ATOM   2166  CE  LYS C  46      -8.598  78.773  41.043  1.00 33.04           C  
ATOM   2167  NZ  LYS C  46      -8.609  79.901  40.049  1.00 33.15           N  
ATOM   2168  N   GLU C  47      -4.007  74.257  44.075  1.00 31.99           N  
ATOM   2169  CA  GLU C  47      -2.679  73.663  44.123  1.00 33.44           C  
ATOM   2170  C   GLU C  47      -2.690  72.124  44.248  1.00 32.08           C  
ATOM   2171  O   GLU C  47      -1.760  71.449  43.788  1.00 32.23           O  
ATOM   2172  CB  GLU C  47      -1.865  74.303  45.250  1.00 37.60           C  
ATOM   2173  CG  GLU C  47      -1.443  75.750  44.949  1.00 39.57           C  
ATOM   2174  CD  GLU C  47      -0.411  75.828  43.817  1.00 43.24           C  
ATOM   2175  OE1 GLU C  47       0.088  74.757  43.395  1.00 43.30           O  
ATOM   2176  OE2 GLU C  47      -0.086  76.951  43.358  1.00 41.78           O  
ATOM   2177  N   LEU C  48      -3.743  71.587  44.853  1.00 32.43           N  
ATOM   2178  CA  LEU C  48      -3.891  70.146  45.021  1.00 35.34           C  
ATOM   2179  C   LEU C  48      -4.322  69.597  43.665  1.00 36.15           C  
ATOM   2180  O   LEU C  48      -3.959  68.480  43.305  1.00 36.18           O  
ATOM   2181  CB  LEU C  48      -4.947  69.816  46.092  1.00 27.22           C  
ATOM   2182  CG  LEU C  48      -4.683  70.176  47.574  1.00 26.76           C  
ATOM   2183  CD1 LEU C  48      -5.984  70.164  48.367  1.00 25.18           C  
ATOM   2184  CD2 LEU C  48      -3.691  69.239  48.156  1.00 25.98           C  
ATOM   2185  N   MET C  49      -5.086  70.385  42.913  1.00 32.93           N  
ATOM   2186  CA  MET C  49      -5.499  69.966  41.574  1.00 35.09           C  
ATOM   2187  C   MET C  49      -4.245  69.903  40.694  1.00 36.04           C  
ATOM   2188  O   MET C  49      -4.101  68.999  39.863  1.00 40.23           O  
ATOM   2189  CB  MET C  49      -6.508  70.938  40.983  1.00 35.48           C  
ATOM   2190  CG  MET C  49      -7.787  71.024  41.764  1.00 39.02           C  
ATOM   2191  SD  MET C  49      -8.910  72.218  41.065  1.00 41.58           S  
ATOM   2192  CE  MET C  49     -10.450  71.802  41.837  1.00 46.98           C  
ATOM   2193  N   GLY C  50      -3.323  70.838  40.894  1.00 24.86           N  
ATOM   2194  CA  GLY C  50      -2.087  70.813  40.134  1.00 25.89           C  
ATOM   2195  C   GLY C  50      -1.312  69.568  40.549  1.00 27.09           C  
ATOM   2196  O   GLY C  50      -0.521  68.991  39.776  1.00 25.53           O  
ATOM   2197  N   LEU C  51      -1.521  69.152  41.794  1.00 26.61           N  
ATOM   2198  CA  LEU C  51      -0.848  67.954  42.279  1.00 26.78           C  
ATOM   2199  C   LEU C  51      -1.507  66.753  41.575  1.00 22.61           C  
ATOM   2200  O   LEU C  51      -0.827  65.909  41.056  1.00 20.84           O  
ATOM   2201  CB  LEU C  51      -0.977  67.823  43.802  1.00 29.88           C  
ATOM   2202  CG  LEU C  51      -0.293  66.535  44.273  1.00 28.35           C  
ATOM   2203  CD1 LEU C  51       1.209  66.596  44.012  1.00 21.87           C  
ATOM   2204  CD2 LEU C  51      -0.609  66.305  45.743  1.00 29.67           C  
ATOM   2205  N   VAL C  52      -2.830  66.705  41.537  1.00 26.27           N  
ATOM   2206  CA  VAL C  52      -3.515  65.629  40.842  1.00 26.42           C  
ATOM   2207  C   VAL C  52      -3.059  65.520  39.347  1.00 30.54           C  
ATOM   2208  O   VAL C  52      -2.702  64.418  38.871  1.00 30.08           O  
ATOM   2209  CB  VAL C  52      -5.030  65.847  40.905  1.00 26.36           C  
ATOM   2210  CG1 VAL C  52      -5.769  64.840  39.991  1.00 26.48           C  
ATOM   2211  CG2 VAL C  52      -5.493  65.718  42.356  1.00 29.09           C  
ATOM   2212  N   ALA C  53      -3.081  66.642  38.616  1.00 26.67           N  
ATOM   2213  CA  ALA C  53      -2.683  66.649  37.196  1.00 27.33           C  
ATOM   2214  C   ALA C  53      -1.243  66.219  37.010  1.00 27.43           C  
ATOM   2215  O   ALA C  53      -0.931  65.412  36.122  1.00 30.43           O  
ATOM   2216  CB  ALA C  53      -2.906  68.077  36.530  1.00 14.56           C  
ATOM   2217  N   SER C  54      -0.368  66.732  37.861  1.00 23.26           N  
ATOM   2218  CA  SER C  54       1.049  66.411  37.748  1.00 26.19           C  
ATOM   2219  C   SER C  54       1.369  64.961  38.005  1.00 24.20           C  
ATOM   2220  O   SER C  54       2.333  64.453  37.460  1.00 24.54           O  
ATOM   2221  CB  SER C  54       1.891  67.260  38.712  1.00 31.92           C  
ATOM   2222  OG  SER C  54       1.753  68.637  38.420  1.00 40.39           O  
ATOM   2223  N   THR C  55       0.583  64.322  38.863  1.00 24.25           N  
ATOM   2224  CA  THR C  55       0.811  62.930  39.237  1.00 26.03           C  
ATOM   2225  C   THR C  55       0.274  61.951  38.190  1.00 25.11           C  
ATOM   2226  O   THR C  55       0.988  61.010  37.830  1.00 28.92           O  
ATOM   2227  CB  THR C  55       0.210  62.641  40.641  1.00 24.78           C  
ATOM   2228  OG1 THR C  55       0.728  63.607  41.580  1.00 22.88           O  
ATOM   2229  CG2 THR C  55       0.577  61.257  41.115  1.00 25.17           C  
ATOM   2230  N   VAL C  56      -0.943  62.172  37.691  1.00 21.35           N  
ATOM   2231  CA  VAL C  56      -1.504  61.297  36.652  1.00 22.77           C  
ATOM   2232  C   VAL C  56      -0.666  61.454  35.385  1.00 25.16           C  
ATOM   2233  O   VAL C  56      -0.516  60.497  34.628  1.00 24.28           O  
ATOM   2234  CB  VAL C  56      -2.988  61.596  36.316  1.00 28.88           C  
ATOM   2235  CG1 VAL C  56      -3.844  61.385  37.527  1.00 28.13           C  
ATOM   2236  CG2 VAL C  56      -3.157  63.030  35.773  1.00 30.67           C  
ATOM   2237  N   LEU C  57      -0.076  62.635  35.160  1.00 26.79           N  
ATOM   2238  CA  LEU C  57       0.764  62.813  33.979  1.00 24.82           C  
ATOM   2239  C   LEU C  57       2.207  62.416  34.306  1.00 29.44           C  
ATOM   2240  O   LEU C  57       3.101  62.467  33.451  1.00 26.10           O  
ATOM   2241  CB  LEU C  57       0.685  64.250  33.447  1.00 28.46           C  
ATOM   2242  CG  LEU C  57      -0.655  64.587  32.796  1.00 29.05           C  
ATOM   2243  CD1 LEU C  57      -0.644  66.035  32.322  1.00 34.31           C  
ATOM   2244  CD2 LEU C  57      -0.933  63.645  31.606  1.00 29.61           C  
ATOM   2245  N   ARG C  58       2.430  62.020  35.556  1.00 32.07           N  
ATOM   2246  CA  ARG C  58       3.738  61.549  35.981  1.00 36.17           C  
ATOM   2247  C   ARG C  58       4.941  62.432  35.739  1.00 37.83           C  
ATOM   2248  O   ARG C  58       5.917  61.974  35.151  1.00 38.69           O  
ATOM   2249  CB  ARG C  58       4.021  60.156  35.366  1.00 32.41           C  
ATOM   2250  CG  ARG C  58       3.055  59.099  35.837  1.00 34.07           C  
ATOM   2251  CD  ARG C  58       3.374  57.703  35.297  1.00 34.61           C  
ATOM   2252  NE  ARG C  58       2.832  57.514  33.959  1.00 34.59           N  
ATOM   2253  CZ  ARG C  58       3.513  57.014  32.932  1.00 33.99           C  
ATOM   2254  NH1 ARG C  58       4.780  56.635  33.076  1.00 33.92           N  
ATOM   2255  NH2 ARG C  58       2.933  56.928  31.745  1.00 35.34           N  
ATOM   2256  N   CYS C  59       4.896  63.681  36.208  1.00 35.90           N  
ATOM   2257  CA  CYS C  59       6.032  64.596  36.066  1.00 32.11           C  
ATOM   2258  C   CYS C  59       6.598  64.895  37.460  1.00 32.63           C  
ATOM   2259  O   CYS C  59       5.999  65.617  38.262  1.00 31.98           O  
ATOM   2260  CB  CYS C  59       5.596  65.898  35.349  1.00 39.16           C  
ATOM   2261  SG  CYS C  59       6.760  67.299  35.531  1.00 39.86           S  
ATOM   2262  N   ASP C  60       7.765  64.335  37.753  1.00 37.55           N  
ATOM   2263  CA  ASP C  60       8.375  64.530  39.066  1.00 40.42           C  
ATOM   2264  C   ASP C  60       8.555  65.983  39.483  1.00 38.79           C  
ATOM   2265  O   ASP C  60       8.028  66.401  40.513  1.00 37.13           O  
ATOM   2266  CB  ASP C  60       9.714  63.800  39.146  1.00 41.07           C  
ATOM   2267  CG  ASP C  60       9.539  62.299  39.204  1.00 45.74           C  
ATOM   2268  OD1 ASP C  60       8.584  61.844  39.879  1.00 42.62           O  
ATOM   2269  OD2 ASP C  60      10.356  61.583  38.576  1.00 48.89           O  
ATOM   2270  N   ASP C  61       9.310  66.747  38.707  1.00 32.15           N  
ATOM   2271  CA  ASP C  61       9.503  68.149  39.050  1.00 35.58           C  
ATOM   2272  C   ASP C  61       8.181  68.874  39.237  1.00 33.22           C  
ATOM   2273  O   ASP C  61       8.062  69.669  40.150  1.00 35.68           O  
ATOM   2274  CB  ASP C  61      10.379  68.837  38.013  1.00 48.90           C  
ATOM   2275  CG  ASP C  61      11.789  68.318  38.057  1.00 56.51           C  
ATOM   2276  OD1 ASP C  61      12.129  67.745  39.107  1.00 61.60           O  
ATOM   2277  OD2 ASP C  61      12.555  68.471  37.086  1.00 59.76           O  
ATOM   2278  N   CYS C  62       7.183  68.600  38.402  1.00 37.61           N  
ATOM   2279  CA  CYS C  62       5.886  69.245  38.575  1.00 36.94           C  
ATOM   2280  C   CYS C  62       5.296  68.802  39.920  1.00 38.34           C  
ATOM   2281  O   CYS C  62       4.740  69.631  40.668  1.00 38.40           O  
ATOM   2282  CB  CYS C  62       4.923  68.855  37.463  1.00 30.40           C  
ATOM   2283  SG  CYS C  62       5.540  68.964  35.743  1.00 34.92           S  
ATOM   2284  N   ILE C  63       5.402  67.499  40.221  1.00 28.57           N  
ATOM   2285  CA  ILE C  63       4.905  66.962  41.498  1.00 28.14           C  
ATOM   2286  C   ILE C  63       5.622  67.647  42.672  1.00 25.45           C  
ATOM   2287  O   ILE C  63       4.990  68.054  43.635  1.00 20.91           O  
ATOM   2288  CB  ILE C  63       5.120  65.391  41.620  1.00 23.46           C  
ATOM   2289  CG1 ILE C  63       4.196  64.644  40.641  1.00 19.91           C  
ATOM   2290  CG2 ILE C  63       4.870  64.953  43.066  1.00 22.87           C  
ATOM   2291  CD1 ILE C  63       4.583  63.162  40.378  1.00 23.02           C  
ATOM   2292  N   ARG C  64       6.941  67.750  42.589  1.00 32.49           N  
ATOM   2293  CA  ARG C  64       7.716  68.401  43.642  1.00 37.78           C  
ATOM   2294  C   ARG C  64       7.218  69.826  43.839  1.00 38.76           C  
ATOM   2295  O   ARG C  64       6.908  70.236  44.962  1.00 35.48           O  
ATOM   2296  CB  ARG C  64       9.199  68.440  43.278  1.00 40.54           C  
ATOM   2297  CG  ARG C  64       9.970  67.166  43.594  1.00 45.76           C  
ATOM   2298  CD  ARG C  64      11.061  66.914  42.561  1.00 49.30           C  
ATOM   2299  NE  ARG C  64      11.608  65.567  42.709  1.00 55.64           N  
ATOM   2300  CZ  ARG C  64      12.183  64.870  41.730  1.00 57.67           C  
ATOM   2301  NH1 ARG C  64      12.296  65.389  40.507  1.00 59.24           N  
ATOM   2302  NH2 ARG C  64      12.630  63.640  41.971  1.00 59.07           N  
ATOM   2303  N   TYR C  65       7.109  70.566  42.732  1.00 36.21           N  
ATOM   2304  CA  TYR C  65       6.663  71.952  42.795  1.00 35.37           C  
ATOM   2305  C   TYR C  65       5.307  72.133  43.438  1.00 34.03           C  
ATOM   2306  O   TYR C  65       5.158  72.968  44.303  1.00 37.05           O  
ATOM   2307  CB  TYR C  65       6.661  72.595  41.403  1.00 29.36           C  
ATOM   2308  CG  TYR C  65       6.136  73.995  41.449  1.00 30.70           C  
ATOM   2309  CD1 TYR C  65       6.934  75.058  41.893  1.00 30.75           C  
ATOM   2310  CD2 TYR C  65       4.808  74.261  41.127  1.00 33.96           C  
ATOM   2311  CE1 TYR C  65       6.401  76.344  42.011  1.00 31.13           C  
ATOM   2312  CE2 TYR C  65       4.271  75.522  41.238  1.00 30.40           C  
ATOM   2313  CZ  TYR C  65       5.062  76.562  41.678  1.00 34.33           C  
ATOM   2314  OH  TYR C  65       4.486  77.813  41.796  1.00 36.01           O  
ATOM   2315  N   HIS C  66       4.307  71.366  43.034  1.00 42.66           N  
ATOM   2316  CA  HIS C  66       2.989  71.532  43.637  1.00 44.39           C  
ATOM   2317  C   HIS C  66       2.929  71.000  45.056  1.00 44.55           C  
ATOM   2318  O   HIS C  66       1.979  71.293  45.805  1.00 47.27           O  
ATOM   2319  CB  HIS C  66       1.923  70.868  42.778  1.00 41.92           C  
ATOM   2320  CG  HIS C  66       1.716  71.563  41.477  1.00 46.21           C  
ATOM   2321  ND1 HIS C  66       1.104  72.794  41.383  1.00 48.77           N  
ATOM   2322  CD2 HIS C  66       2.119  71.248  40.223  1.00 48.48           C  
ATOM   2323  CE1 HIS C  66       1.143  73.210  40.130  1.00 49.39           C  
ATOM   2324  NE2 HIS C  66       1.755  72.291  39.407  1.00 49.38           N  
ATOM   2325  N   LEU C  67       3.923  70.193  45.419  1.00 33.69           N  
ATOM   2326  CA  LEU C  67       3.979  69.684  46.777  1.00 35.45           C  
ATOM   2327  C   LEU C  67       4.281  70.867  47.712  1.00 35.12           C  
ATOM   2328  O   LEU C  67       3.495  71.155  48.643  1.00 28.83           O  
ATOM   2329  CB  LEU C  67       5.056  68.595  46.932  1.00 38.40           C  
ATOM   2330  CG  LEU C  67       4.577  67.141  46.791  1.00 43.33           C  
ATOM   2331  CD1 LEU C  67       5.766  66.202  46.971  1.00 44.73           C  
ATOM   2332  CD2 LEU C  67       3.494  66.827  47.840  1.00 41.96           C  
ATOM   2333  N   VAL C  68       5.389  71.574  47.470  1.00 42.64           N  
ATOM   2334  CA  VAL C  68       5.674  72.690  48.362  1.00 45.71           C  
ATOM   2335  C   VAL C  68       4.487  73.656  48.309  1.00 45.81           C  
ATOM   2336  O   VAL C  68       4.013  74.130  49.338  1.00 47.52           O  
ATOM   2337  CB  VAL C  68       6.991  73.430  48.021  1.00 34.75           C  
ATOM   2338  CG1 VAL C  68       7.973  72.503  47.263  1.00 32.96           C  
ATOM   2339  CG2 VAL C  68       6.698  74.686  47.268  1.00 39.18           C  
ATOM   2340  N   ARG C  69       3.972  73.919  47.119  1.00 41.94           N  
ATOM   2341  CA  ARG C  69       2.841  74.834  47.037  1.00 44.08           C  
ATOM   2342  C   ARG C  69       1.686  74.395  47.936  1.00 43.64           C  
ATOM   2343  O   ARG C  69       1.035  75.233  48.564  1.00 44.92           O  
ATOM   2344  CB  ARG C  69       2.353  74.969  45.594  1.00 46.12           C  
ATOM   2345  CG  ARG C  69       3.310  75.743  44.695  1.00 52.49           C  
ATOM   2346  CD  ARG C  69       2.866  77.201  44.517  1.00 51.30           C  
ATOM   2347  NE  ARG C  69       2.849  77.918  45.780  1.00 52.02           N  
ATOM   2348  CZ  ARG C  69       1.830  78.657  46.224  1.00 54.03           C  
ATOM   2349  NH1 ARG C  69       0.727  78.781  45.501  1.00 51.11           N  
ATOM   2350  NH2 ARG C  69       1.920  79.276  47.408  1.00 51.69           N  
ATOM   2351  N   CYS C  70       1.428  73.090  48.002  1.00 42.79           N  
ATOM   2352  CA  CYS C  70       0.327  72.589  48.822  1.00 42.18           C  
ATOM   2353  C   CYS C  70       0.657  72.801  50.303  1.00 43.57           C  
ATOM   2354  O   CYS C  70      -0.221  73.083  51.133  1.00 40.04           O  
ATOM   2355  CB  CYS C  70       0.062  71.103  48.518  1.00 45.35           C  
ATOM   2356  SG  CYS C  70      -0.928  70.754  46.995  1.00 45.87           S  
ATOM   2357  N   VAL C  71       1.933  72.664  50.626  1.00 42.44           N  
ATOM   2358  CA  VAL C  71       2.378  72.863  51.988  1.00 46.08           C  
ATOM   2359  C   VAL C  71       2.153  74.321  52.358  1.00 47.21           C  
ATOM   2360  O   VAL C  71       1.492  74.617  53.361  1.00 47.12           O  
ATOM   2361  CB  VAL C  71       3.883  72.537  52.149  1.00 50.16           C  
ATOM   2362  CG1 VAL C  71       4.402  73.129  53.457  1.00 52.23           C  
ATOM   2363  CG2 VAL C  71       4.092  71.028  52.134  1.00 49.68           C  
ATOM   2364  N   GLN C  72       2.696  75.225  51.538  1.00 48.01           N  
ATOM   2365  CA  GLN C  72       2.561  76.649  51.790  1.00 47.04           C  
ATOM   2366  C   GLN C  72       1.114  76.996  52.035  1.00 46.32           C  
ATOM   2367  O   GLN C  72       0.802  77.705  52.976  1.00 48.86           O  
ATOM   2368  CB  GLN C  72       3.083  77.460  50.617  1.00 50.15           C  
ATOM   2369  CG  GLN C  72       4.581  77.335  50.390  1.00 56.65           C  
ATOM   2370  CD  GLN C  72       5.035  78.058  49.127  1.00 58.97           C  
ATOM   2371  OE1 GLN C  72       4.522  77.803  48.035  1.00 62.28           O  
ATOM   2372  NE2 GLN C  72       5.994  78.961  49.271  1.00 59.05           N  
ATOM   2373  N   GLU C  73       0.213  76.496  51.203  1.00 39.23           N  
ATOM   2374  CA  GLU C  73      -1.187  76.811  51.395  1.00 38.69           C  
ATOM   2375  C   GLU C  73      -1.830  76.109  52.578  1.00 39.55           C  
ATOM   2376  O   GLU C  73      -3.042  76.240  52.798  1.00 38.24           O  
ATOM   2377  CB  GLU C  73      -1.944  76.526  50.115  1.00 48.57           C  
ATOM   2378  CG  GLU C  73      -1.432  77.403  49.020  1.00 49.81           C  
ATOM   2379  CD  GLU C  73      -1.417  78.865  49.451  1.00 50.59           C  
ATOM   2380  OE1 GLU C  73      -0.512  79.595  48.994  1.00 47.95           O  
ATOM   2381  OE2 GLU C  73      -2.312  79.269  50.242  1.00 48.95           O  
ATOM   2382  N   GLY C  74      -1.020  75.366  53.332  1.00 56.24           N  
ATOM   2383  CA  GLY C  74      -1.510  74.659  54.505  1.00 57.01           C  
ATOM   2384  C   GLY C  74      -2.343  73.399  54.310  1.00 57.24           C  
ATOM   2385  O   GLY C  74      -3.253  73.113  55.105  1.00 58.11           O  
ATOM   2386  N   ALA C  75      -2.057  72.628  53.266  1.00 44.66           N  
ATOM   2387  CA  ALA C  75      -2.813  71.401  53.049  1.00 40.64           C  
ATOM   2388  C   ALA C  75      -2.259  70.386  54.026  1.00 39.78           C  
ATOM   2389  O   ALA C  75      -1.042  70.319  54.222  1.00 36.77           O  
ATOM   2390  CB  ALA C  75      -2.627  70.902  51.627  1.00 25.84           C  
ATOM   2391  N   SER C  76      -3.144  69.614  54.652  1.00 42.29           N  
ATOM   2392  CA  SER C  76      -2.711  68.569  55.580  1.00 43.49           C  
ATOM   2393  C   SER C  76      -2.276  67.326  54.798  1.00 43.62           C  
ATOM   2394  O   SER C  76      -2.810  67.045  53.720  1.00 43.20           O  
ATOM   2395  CB  SER C  76      -3.855  68.164  56.526  1.00 42.95           C  
ATOM   2396  OG  SER C  76      -4.921  67.534  55.828  1.00 45.00           O  
ATOM   2397  N   ASP C  77      -1.307  66.593  55.339  1.00 43.90           N  
ATOM   2398  CA  ASP C  77      -0.856  65.356  54.719  1.00 43.35           C  
ATOM   2399  C   ASP C  77      -2.057  64.510  54.349  1.00 43.45           C  
ATOM   2400  O   ASP C  77      -1.999  63.752  53.387  1.00 43.83           O  
ATOM   2401  CB  ASP C  77       0.052  64.579  55.666  1.00 42.24           C  
ATOM   2402  CG  ASP C  77       1.465  65.058  55.604  1.00 45.61           C  
ATOM   2403  OD1 ASP C  77       1.623  66.248  55.242  1.00 45.02           O  
ATOM   2404  OD2 ASP C  77       2.405  64.275  55.903  1.00 46.87           O  
ATOM   2405  N   GLU C  78      -3.146  64.637  55.098  1.00 40.61           N  
ATOM   2406  CA  GLU C  78      -4.336  63.864  54.771  1.00 43.54           C  
ATOM   2407  C   GLU C  78      -4.861  64.363  53.425  1.00 41.41           C  
ATOM   2408  O   GLU C  78      -5.096  63.585  52.513  1.00 44.14           O  
ATOM   2409  CB  GLU C  78      -5.429  64.024  55.833  1.00 75.85           C  
ATOM   2410  CG  GLU C  78      -5.209  63.251  57.116  1.00 87.21           C  
ATOM   2411  CD  GLU C  78      -4.427  64.042  58.143  1.00 93.80           C  
ATOM   2412  OE1 GLU C  78      -3.198  64.201  57.983  1.00 97.65           O  
ATOM   2413  OE2 GLU C  78      -5.057  64.518  59.113  1.00 97.32           O  
ATOM   2414  N   GLU C  79      -5.050  65.676  53.324  1.00 40.91           N  
ATOM   2415  CA  GLU C  79      -5.529  66.329  52.108  1.00 35.18           C  
ATOM   2416  C   GLU C  79      -4.702  65.945  50.891  1.00 31.21           C  
ATOM   2417  O   GLU C  79      -5.245  65.611  49.851  1.00 33.81           O  
ATOM   2418  CB  GLU C  79      -5.506  67.851  52.305  1.00 33.50           C  
ATOM   2419  CG  GLU C  79      -6.772  68.402  53.032  1.00 33.63           C  
ATOM   2420  CD  GLU C  79      -6.608  69.845  53.548  1.00 35.28           C  
ATOM   2421  OE1 GLU C  79      -7.651  70.537  53.735  1.00 29.75           O  
ATOM   2422  OE2 GLU C  79      -5.437  70.267  53.763  1.00 33.66           O  
ATOM   2423  N   ILE C  80      -3.388  65.986  51.033  1.00 23.61           N  
ATOM   2424  CA  ILE C  80      -2.503  65.633  49.955  1.00 27.68           C  
ATOM   2425  C   ILE C  80      -2.738  64.174  49.546  1.00 31.61           C  
ATOM   2426  O   ILE C  80      -3.013  63.890  48.364  1.00 29.52           O  
ATOM   2427  CB  ILE C  80      -1.064  65.900  50.374  1.00 32.44           C  
ATOM   2428  CG1 ILE C  80      -0.870  67.430  50.466  1.00 34.01           C  
ATOM   2429  CG2 ILE C  80      -0.092  65.283  49.401  1.00 26.58           C  
ATOM   2430  CD1 ILE C  80       0.455  67.895  51.031  1.00 33.24           C  
ATOM   2431  N   PHE C  81      -2.683  63.252  50.510  1.00 35.10           N  
ATOM   2432  CA  PHE C  81      -2.914  61.856  50.186  1.00 35.09           C  
ATOM   2433  C   PHE C  81      -4.274  61.583  49.604  1.00 33.32           C  
ATOM   2434  O   PHE C  81      -4.417  60.684  48.799  1.00 33.13           O  
ATOM   2435  CB  PHE C  81      -2.685  60.954  51.390  1.00 52.27           C  
ATOM   2436  CG  PHE C  81      -1.328  60.383  51.418  1.00 57.48           C  
ATOM   2437  CD1 PHE C  81      -0.312  61.011  52.134  1.00 61.26           C  
ATOM   2438  CD2 PHE C  81      -1.020  59.275  50.619  1.00 61.92           C  
ATOM   2439  CE1 PHE C  81       0.997  60.555  52.053  1.00 63.83           C  
ATOM   2440  CE2 PHE C  81       0.289  58.806  50.527  1.00 65.31           C  
ATOM   2441  CZ  PHE C  81       1.303  59.446  51.243  1.00 66.12           C  
ATOM   2442  N   GLU C  82      -5.286  62.337  49.985  1.00 31.68           N  
ATOM   2443  CA  GLU C  82      -6.593  62.075  49.395  1.00 33.72           C  
ATOM   2444  C   GLU C  82      -6.596  62.471  47.916  1.00 33.10           C  
ATOM   2445  O   GLU C  82      -7.355  61.933  47.098  1.00 32.49           O  
ATOM   2446  CB  GLU C  82      -7.678  62.837  50.140  1.00 40.04           C  
ATOM   2447  CG  GLU C  82      -7.853  62.383  51.585  1.00 43.39           C  
ATOM   2448  CD  GLU C  82      -9.141  62.899  52.176  1.00 44.56           C  
ATOM   2449  OE1 GLU C  82      -9.921  63.491  51.401  1.00 47.25           O  
ATOM   2450  OE2 GLU C  82      -9.374  62.710  53.395  1.00 46.06           O  
ATOM   2451  N   ALA C  83      -5.736  63.418  47.577  1.00 34.63           N  
ATOM   2452  CA  ALA C  83      -5.617  63.880  46.203  1.00 34.60           C  
ATOM   2453  C   ALA C  83      -4.744  62.864  45.463  1.00 32.51           C  
ATOM   2454  O   ALA C  83      -5.063  62.441  44.351  1.00 30.94           O  
ATOM   2455  CB  ALA C  83      -4.977  65.252  46.178  1.00 30.11           C  
ATOM   2456  N   LEU C  84      -3.624  62.506  46.080  1.00 32.09           N  
ATOM   2457  CA  LEU C  84      -2.739  61.514  45.500  1.00 34.96           C  
ATOM   2458  C   LEU C  84      -3.485  60.181  45.323  1.00 36.75           C  
ATOM   2459  O   LEU C  84      -3.138  59.400  44.442  1.00 37.13           O  
ATOM   2460  CB  LEU C  84      -1.504  61.308  46.378  1.00 30.78           C  
ATOM   2461  CG  LEU C  84      -0.431  62.404  46.294  1.00 33.74           C  
ATOM   2462  CD1 LEU C  84       0.715  62.158  47.337  1.00 30.28           C  
ATOM   2463  CD2 LEU C  84       0.123  62.438  44.900  1.00 27.06           C  
ATOM   2464  N   ASP C  85      -4.514  59.931  46.135  1.00 35.97           N  
ATOM   2465  CA  ASP C  85      -5.262  58.688  46.015  1.00 37.17           C  
ATOM   2466  C   ASP C  85      -6.066  58.725  44.740  1.00 36.21           C  
ATOM   2467  O   ASP C  85      -6.279  57.695  44.092  1.00 33.86           O  
ATOM   2468  CB  ASP C  85      -6.215  58.466  47.196  1.00 42.41           C  
ATOM   2469  CG  ASP C  85      -5.561  57.706  48.352  1.00 45.73           C  
ATOM   2470  OD1 ASP C  85      -4.501  57.079  48.140  1.00 43.16           O  
ATOM   2471  OD2 ASP C  85      -6.116  57.731  49.472  1.00 49.01           O  
ATOM   2472  N   ILE C  86      -6.536  59.917  44.396  1.00 35.43           N  
ATOM   2473  CA  ILE C  86      -7.323  60.090  43.188  1.00 32.46           C  
ATOM   2474  C   ILE C  86      -6.429  59.954  41.955  1.00 29.01           C  
ATOM   2475  O   ILE C  86      -6.796  59.268  41.002  1.00 25.62           O  
ATOM   2476  CB  ILE C  86      -8.052  61.432  43.227  1.00 26.39           C  
ATOM   2477  CG1 ILE C  86      -9.080  61.367  44.360  1.00 27.28           C  
ATOM   2478  CG2 ILE C  86      -8.716  61.746  41.869  1.00 26.04           C  
ATOM   2479  CD1 ILE C  86      -9.860  62.612  44.549  1.00 33.87           C  
ATOM   2480  N   ALA C  87      -5.240  60.556  42.006  1.00 21.87           N  
ATOM   2481  CA  ALA C  87      -4.315  60.455  40.886  1.00 24.25           C  
ATOM   2482  C   ALA C  87      -3.933  58.979  40.646  1.00 24.50           C  
ATOM   2483  O   ALA C  87      -3.991  58.505  39.521  1.00 25.73           O  
ATOM   2484  CB  ALA C  87      -3.066  61.292  41.136  1.00 10.86           C  
ATOM   2485  N   LEU C  88      -3.574  58.275  41.715  1.00 30.02           N  
ATOM   2486  CA  LEU C  88      -3.178  56.856  41.662  1.00 33.31           C  
ATOM   2487  C   LEU C  88      -4.260  55.980  41.033  1.00 34.02           C  
ATOM   2488  O   LEU C  88      -3.987  55.200  40.138  1.00 37.24           O  
ATOM   2489  CB  LEU C  88      -2.905  56.355  43.069  1.00 28.77           C  
ATOM   2490  CG  LEU C  88      -1.914  55.261  43.466  1.00 35.81           C  
ATOM   2491  CD1 LEU C  88      -2.492  54.606  44.729  1.00 30.61           C  
ATOM   2492  CD2 LEU C  88      -1.689  54.201  42.389  1.00 30.97           C  
ATOM   2493  N   VAL C  89      -5.490  56.100  41.506  1.00 31.34           N  
ATOM   2494  CA  VAL C  89      -6.556  55.291  40.942  1.00 31.81           C  
ATOM   2495  C   VAL C  89      -6.866  55.674  39.495  1.00 33.32           C  
ATOM   2496  O   VAL C  89      -7.002  54.789  38.645  1.00 32.11           O  
ATOM   2497  CB  VAL C  89      -7.871  55.356  41.815  1.00 34.18           C  
ATOM   2498  CG1 VAL C  89      -9.062  54.819  41.005  1.00 34.47           C  
ATOM   2499  CG2 VAL C  89      -7.691  54.510  43.116  1.00 22.70           C  
ATOM   2500  N   VAL C  90      -6.986  56.972  39.200  1.00 33.04           N  
ATOM   2501  CA  VAL C  90      -7.275  57.372  37.817  1.00 29.19           C  
ATOM   2502  C   VAL C  90      -6.142  57.018  36.834  1.00 30.06           C  
ATOM   2503  O   VAL C  90      -6.402  56.432  35.795  1.00 30.30           O  
ATOM   2504  CB  VAL C  90      -7.608  58.904  37.714  1.00 32.00           C  
ATOM   2505  CG1 VAL C  90      -7.786  59.297  36.281  1.00 28.15           C  
ATOM   2506  CG2 VAL C  90      -8.912  59.249  38.489  1.00 30.84           C  
ATOM   2507  N   GLY C  91      -4.892  57.325  37.180  1.00 25.69           N  
ATOM   2508  CA  GLY C  91      -3.769  57.062  36.284  1.00 29.18           C  
ATOM   2509  C   GLY C  91      -3.065  55.717  36.380  1.00 32.11           C  
ATOM   2510  O   GLY C  91      -2.078  55.439  35.670  1.00 28.13           O  
ATOM   2511  N   GLY C  92      -3.560  54.886  37.292  1.00 34.93           N  
ATOM   2512  CA  GLY C  92      -2.998  53.564  37.461  1.00 31.40           C  
ATOM   2513  C   GLY C  92      -1.713  53.401  38.232  1.00 28.72           C  
ATOM   2514  O   GLY C  92      -1.077  54.360  38.664  1.00 26.36           O  
ATOM   2515  N   SER C  93      -1.339  52.137  38.401  1.00 24.85           N  
ATOM   2516  CA  SER C  93      -0.145  51.751  39.127  1.00 25.16           C  
ATOM   2517  C   SER C  93       1.207  52.202  38.528  1.00 24.66           C  
ATOM   2518  O   SER C  93       2.235  52.108  39.217  1.00 23.57           O  
ATOM   2519  CB  SER C  93      -0.170  50.225  39.355  1.00 37.16           C  
ATOM   2520  OG  SER C  93      -0.155  49.528  38.141  1.00 42.15           O  
ATOM   2521  N   ILE C  94       1.224  52.682  37.276  1.00 22.59           N  
ATOM   2522  CA  ILE C  94       2.479  53.201  36.676  1.00 26.14           C  
ATOM   2523  C   ILE C  94       2.886  54.423  37.473  1.00 24.26           C  
ATOM   2524  O   ILE C  94       4.048  54.846  37.456  1.00 26.81           O  
ATOM   2525  CB  ILE C  94       2.291  53.741  35.235  1.00 28.31           C  
ATOM   2526  CG1 ILE C  94       0.838  54.239  35.108  1.00 28.95           C  
ATOM   2527  CG2 ILE C  94       2.770  52.703  34.213  1.00 28.47           C  
ATOM   2528  CD1 ILE C  94       0.516  55.001  33.875  1.00 35.28           C  
ATOM   2529  N   VAL C  95       1.894  54.983  38.143  1.00 20.60           N  
ATOM   2530  CA  VAL C  95       2.019  56.188  38.955  1.00 25.19           C  
ATOM   2531  C   VAL C  95       2.699  55.896  40.260  1.00 24.12           C  
ATOM   2532  O   VAL C  95       3.102  56.815  40.973  1.00 21.40           O  
ATOM   2533  CB  VAL C  95       0.607  56.735  39.298  1.00 25.23           C  
ATOM   2534  CG1 VAL C  95       0.645  57.556  40.542  1.00 30.58           C  
ATOM   2535  CG2 VAL C  95       0.037  57.470  38.133  1.00 24.93           C  
ATOM   2536  N   ILE C  96       2.809  54.620  40.608  1.00 35.51           N  
ATOM   2537  CA  ILE C  96       3.404  54.284  41.893  1.00 34.55           C  
ATOM   2538  C   ILE C  96       4.815  54.787  42.098  1.00 35.92           C  
ATOM   2539  O   ILE C  96       5.118  55.364  43.134  1.00 35.14           O  
ATOM   2540  CB  ILE C  96       3.274  52.772  42.184  1.00 21.37           C  
ATOM   2541  CG1 ILE C  96       1.859  52.537  42.710  1.00 22.85           C  
ATOM   2542  CG2 ILE C  96       4.288  52.341  43.248  1.00 19.62           C  
ATOM   2543  CD1 ILE C  96       1.449  51.127  42.935  1.00 30.54           C  
ATOM   2544  N   PRO C  97       5.705  54.582  41.127  1.00 33.98           N  
ATOM   2545  CA  PRO C  97       7.061  55.099  41.370  1.00 38.14           C  
ATOM   2546  C   PRO C  97       7.096  56.619  41.694  1.00 41.78           C  
ATOM   2547  O   PRO C  97       8.018  57.110  42.357  1.00 44.79           O  
ATOM   2548  CB  PRO C  97       7.803  54.756  40.066  1.00 27.35           C  
ATOM   2549  CG  PRO C  97       7.138  53.426  39.652  1.00 23.14           C  
ATOM   2550  CD  PRO C  97       5.651  53.688  39.955  1.00 24.95           C  
ATOM   2551  N   HIS C  98       6.083  57.358  41.249  1.00 32.84           N  
ATOM   2552  CA  HIS C  98       6.048  58.791  41.500  1.00 32.04           C  
ATOM   2553  C   HIS C  98       5.466  59.116  42.849  1.00 34.25           C  
ATOM   2554  O   HIS C  98       5.870  60.091  43.487  1.00 32.04           O  
ATOM   2555  CB  HIS C  98       5.263  59.496  40.392  1.00 36.00           C  
ATOM   2556  CG  HIS C  98       5.922  59.382  39.062  1.00 34.54           C  
ATOM   2557  ND1 HIS C  98       5.765  58.279  38.251  1.00 35.37           N  
ATOM   2558  CD2 HIS C  98       6.867  60.151  38.473  1.00 35.91           C  
ATOM   2559  CE1 HIS C  98       6.591  58.368  37.227  1.00 38.96           C  
ATOM   2560  NE2 HIS C  98       7.275  59.493  37.339  1.00 36.25           N  
ATOM   2561  N   LEU C  99       4.527  58.283  43.284  1.00 40.38           N  
ATOM   2562  CA  LEU C  99       3.889  58.439  44.575  1.00 41.72           C  
ATOM   2563  C   LEU C  99       4.925  58.132  45.664  1.00 42.96           C  
ATOM   2564  O   LEU C  99       4.895  58.724  46.746  1.00 44.89           O  
ATOM   2565  CB  LEU C  99       2.699  57.493  44.665  1.00 43.52           C  
ATOM   2566  CG  LEU C  99       1.905  57.470  45.963  1.00 45.97           C  
ATOM   2567  CD1 LEU C  99       1.029  58.711  46.032  1.00 47.98           C  
ATOM   2568  CD2 LEU C  99       1.046  56.212  46.003  1.00 42.18           C  
ATOM   2569  N   ARG C 100       5.858  57.225  45.377  1.00 35.77           N  
ATOM   2570  CA  ARG C 100       6.906  56.910  46.345  1.00 39.33           C  
ATOM   2571  C   ARG C 100       7.797  58.148  46.576  1.00 40.50           C  
ATOM   2572  O   ARG C 100       7.980  58.585  47.712  1.00 39.80           O  
ATOM   2573  CB  ARG C 100       7.786  55.742  45.873  1.00 50.56           C  
ATOM   2574  CG  ARG C 100       7.039  54.429  45.663  1.00 55.34           C  
ATOM   2575  CD  ARG C 100       7.971  53.226  45.767  1.00 57.82           C  
ATOM   2576  NE  ARG C 100       7.744  52.268  44.691  1.00 61.32           N  
ATOM   2577  CZ  ARG C 100       8.377  52.306  43.523  1.00 63.49           C  
ATOM   2578  NH1 ARG C 100       9.288  53.250  43.292  1.00 65.90           N  
ATOM   2579  NH2 ARG C 100       8.073  51.429  42.570  1.00 63.59           N  
ATOM   2580  N   ARG C 101       8.352  58.698  45.496  1.00 51.49           N  
ATOM   2581  CA  ARG C 101       9.202  59.878  45.587  1.00 51.87           C  
ATOM   2582  C   ARG C 101       8.436  61.022  46.243  1.00 51.52           C  
ATOM   2583  O   ARG C 101       8.936  61.660  47.163  1.00 52.00           O  
ATOM   2584  CB  ARG C 101       9.676  60.287  44.194  1.00 53.56           C  
ATOM   2585  CG  ARG C 101      10.626  59.286  43.550  1.00 57.36           C  
ATOM   2586  CD  ARG C 101      10.682  59.461  42.033  1.00 60.12           C  
ATOM   2587  NE  ARG C 101      11.312  58.317  41.374  1.00 62.31           N  
ATOM   2588  CZ  ARG C 101      10.992  57.866  40.162  1.00 63.84           C  
ATOM   2589  NH1 ARG C 101      10.035  58.458  39.447  1.00 62.82           N  
ATOM   2590  NH2 ARG C 101      11.624  56.806  39.667  1.00 63.43           N  
ATOM   2591  N   ALA C 102       7.212  61.268  45.790  1.00 40.00           N  
ATOM   2592  CA  ALA C 102       6.400  62.333  46.373  1.00 40.53           C  
ATOM   2593  C   ALA C 102       6.295  62.241  47.905  1.00 40.41           C  
ATOM   2594  O   ALA C 102       6.155  63.265  48.589  1.00 38.88           O  
ATOM   2595  CB  ALA C 102       4.994  62.329  45.767  1.00 26.46           C  
ATOM   2596  N   VAL C 103       6.339  61.033  48.452  1.00 42.62           N  
ATOM   2597  CA  VAL C 103       6.233  60.896  49.907  1.00 44.13           C  
ATOM   2598  C   VAL C 103       7.558  61.188  50.587  1.00 43.74           C  
ATOM   2599  O   VAL C 103       7.598  61.866  51.605  1.00 43.23           O  
ATOM   2600  CB  VAL C 103       5.735  59.494  50.330  1.00 48.12           C  
ATOM   2601  CG1 VAL C 103       5.779  59.369  51.840  1.00 51.04           C  
ATOM   2602  CG2 VAL C 103       4.302  59.285  49.862  1.00 46.36           C  
ATOM   2603  N   GLY C 104       8.643  60.691  50.011  1.00 55.05           N  
ATOM   2604  CA  GLY C 104       9.946  60.942  50.588  1.00 54.71           C  
ATOM   2605  C   GLY C 104      10.210  62.432  50.581  1.00 56.69           C  
ATOM   2606  O   GLY C 104      10.830  62.975  51.500  1.00 58.23           O  
ATOM   2607  N   PHE C 105       9.717  63.094  49.537  1.00 52.95           N  
ATOM   2608  CA  PHE C 105       9.884  64.524  49.381  1.00 51.29           C  
ATOM   2609  C   PHE C 105       9.004  65.263  50.371  1.00 50.32           C  
ATOM   2610  O   PHE C 105       9.444  66.216  51.011  1.00 50.16           O  
ATOM   2611  CB  PHE C 105       9.529  64.967  47.944  1.00 52.81           C  
ATOM   2612  CG  PHE C 105       9.925  66.397  47.633  1.00 52.05           C  
ATOM   2613  CD1 PHE C 105      11.267  66.774  47.621  1.00 54.18           C  
ATOM   2614  CD2 PHE C 105       8.962  67.371  47.407  1.00 51.76           C  
ATOM   2615  CE1 PHE C 105      11.632  68.106  47.394  1.00 56.16           C  
ATOM   2616  CE2 PHE C 105       9.318  68.699  47.178  1.00 50.75           C  
ATOM   2617  CZ  PHE C 105      10.647  69.067  47.173  1.00 53.03           C  
ATOM   2618  N   LEU C 106       7.755  64.828  50.487  1.00 36.31           N  
ATOM   2619  CA  LEU C 106       6.836  65.475  51.393  1.00 35.04           C  
ATOM   2620  C   LEU C 106       7.291  65.359  52.820  1.00 39.85           C  
ATOM   2621  O   LEU C 106       6.986  66.238  53.640  1.00 40.98           O  
ATOM   2622  CB  LEU C 106       5.445  64.868  51.266  1.00 34.63           C  
ATOM   2623  CG  LEU C 106       4.435  65.199  52.368  1.00 29.11           C  
ATOM   2624  CD1 LEU C 106       4.138  66.714  52.409  1.00 29.80           C  
ATOM   2625  CD2 LEU C 106       3.162  64.414  52.120  1.00 24.53           C  
ATOM   2626  N   GLU C 107       7.992  64.264  53.126  1.00 48.83           N  
ATOM   2627  CA  GLU C 107       8.489  64.032  54.478  1.00 51.21           C  
ATOM   2628  C   GLU C 107       9.599  65.018  54.748  1.00 49.21           C  
ATOM   2629  O   GLU C 107       9.740  65.509  55.869  1.00 46.88           O  
ATOM   2630  CB  GLU C 107       9.010  62.600  54.652  1.00 75.28           C  
ATOM   2631  CG  GLU C 107       7.987  61.669  55.291  1.00 82.61           C  
ATOM   2632  CD  GLU C 107       8.512  60.263  55.569  1.00 85.87           C  
ATOM   2633  OE1 GLU C 107       7.711  59.413  56.033  1.00 86.53           O  
ATOM   2634  OE2 GLU C 107       9.717  60.012  55.325  1.00 87.49           O  
ATOM   2635  N   GLU C 108      10.390  65.308  53.722  1.00 48.60           N  
ATOM   2636  CA  GLU C 108      11.466  66.274  53.897  1.00 52.14           C  
ATOM   2637  C   GLU C 108      10.903  67.664  54.190  1.00 51.42           C  
ATOM   2638  O   GLU C 108      11.404  68.376  55.050  1.00 52.84           O  
ATOM   2639  CB  GLU C 108      12.345  66.359  52.664  1.00 62.27           C  
ATOM   2640  CG  GLU C 108      13.310  67.523  52.744  1.00 67.83           C  
ATOM   2641  CD  GLU C 108      14.330  67.508  51.639  1.00 70.31           C  
ATOM   2642  OE1 GLU C 108      13.926  67.386  50.465  1.00 72.93           O  
ATOM   2643  OE2 GLU C 108      15.535  67.625  51.945  1.00 73.06           O  
ATOM   2644  N   LEU C 109       9.853  68.038  53.470  1.00 45.85           N  
ATOM   2645  CA  LEU C 109       9.220  69.335  53.649  1.00 43.90           C  
ATOM   2646  C   LEU C 109       8.589  69.409  55.035  1.00 42.95           C  
ATOM   2647  O   LEU C 109       8.545  70.484  55.641  1.00 38.34           O  
ATOM   2648  CB  LEU C 109       8.139  69.576  52.569  1.00 41.32           C  
ATOM   2649  CG  LEU C 109       8.517  69.421  51.083  1.00 42.86           C  
ATOM   2650  CD1 LEU C 109       7.313  69.789  50.206  1.00 41.82           C  
ATOM   2651  CD2 LEU C 109       9.725  70.292  50.748  1.00 39.98           C  
ATOM   2652  N   ARG C 110       8.092  68.278  55.537  1.00 45.75           N  
ATOM   2653  CA  ARG C 110       7.482  68.273  56.864  1.00 48.33           C  
ATOM   2654  C   ARG C 110       8.528  68.443  57.987  1.00 48.46           C  
ATOM   2655  O   ARG C 110       8.256  69.093  59.011  1.00 45.59           O  
ATOM   2656  CB  ARG C 110       6.663  66.999  57.088  1.00 51.55           C  
ATOM   2657  CG  ARG C 110       5.366  66.958  56.295  1.00 52.48           C  
ATOM   2658  CD  ARG C 110       4.557  68.230  56.485  1.00 52.37           C  
ATOM   2659  NE  ARG C 110       3.235  68.105  55.879  1.00 53.60           N  
ATOM   2660  CZ  ARG C 110       2.366  69.101  55.746  1.00 53.18           C  
ATOM   2661  NH1 ARG C 110       2.685  70.314  56.171  1.00 52.55           N  
ATOM   2662  NH2 ARG C 110       1.166  68.873  55.211  1.00 51.96           N  
ATOM   2663  N   GLU C 111       9.713  67.871  57.778  1.00 45.48           N  
ATOM   2664  CA  GLU C 111      10.784  67.980  58.747  1.00 49.13           C  
ATOM   2665  C   GLU C 111      11.183  69.461  58.879  1.00 49.10           C  
ATOM   2666  O   GLU C 111      11.276  69.995  60.002  1.00 44.65           O  
ATOM   2667  CB  GLU C 111      11.992  67.153  58.311  1.00 89.19           C  
ATOM   2668  CG  GLU C 111      13.167  67.280  59.258  1.00 97.43           C  
ATOM   2669  CD  GLU C 111      14.218  66.223  59.022  1.00103.08           C  
ATOM   2670  OE1 GLU C 111      14.730  66.139  57.885  1.00104.91           O  
ATOM   2671  OE2 GLU C 111      14.530  65.474  59.975  1.00105.88           O  
ATOM   2672  N   MET C 112      11.405  70.104  57.728  1.00 56.71           N  
ATOM   2673  CA  MET C 112      11.768  71.515  57.665  1.00 58.09           C  
ATOM   2674  C   MET C 112      10.699  72.340  58.370  1.00 57.49           C  
ATOM   2675  O   MET C 112      11.017  73.198  59.173  1.00 58.98           O  
ATOM   2676  CB  MET C 112      11.893  71.973  56.204  1.00 54.91           C  
ATOM   2677  CG  MET C 112      12.899  71.191  55.379  1.00 54.85           C  
ATOM   2678  SD  MET C 112      12.971  71.760  53.659  1.00 57.77           S  
ATOM   2679  CE  MET C 112      14.726  71.596  53.339  1.00 55.09           C  
ATOM   2680  N   GLU C 113       9.431  72.066  58.083  1.00 38.59           N  
ATOM   2681  CA  GLU C 113       8.340  72.798  58.714  1.00 40.27           C  
ATOM   2682  C   GLU C 113       8.417  72.608  60.225  1.00 42.63           C  
ATOM   2683  O   GLU C 113       8.139  73.532  61.007  1.00 41.25           O  
ATOM   2684  CB  GLU C 113       6.987  72.275  58.220  1.00 54.99           C  
ATOM   2685  CG  GLU C 113       5.938  73.346  57.968  1.00 57.05           C  
ATOM   2686  CD  GLU C 113       4.553  72.758  57.722  1.00 60.27           C  
ATOM   2687  OE1 GLU C 113       3.605  73.518  57.412  1.00 58.62           O  
ATOM   2688  OE2 GLU C 113       4.410  71.521  57.849  1.00 63.31           O  
ATOM   2689  N   LYS C 114       8.782  71.392  60.625  1.00 58.75           N  
ATOM   2690  CA  LYS C 114       8.901  71.027  62.030  1.00 59.98           C  
ATOM   2691  C   LYS C 114       9.974  71.900  62.696  1.00 58.64           C  
ATOM   2692  O   LYS C 114       9.750  72.485  63.767  1.00 56.16           O  
ATOM   2693  CB  LYS C 114       9.283  69.546  62.134  1.00 72.22           C  
ATOM   2694  CG  LYS C 114       9.148  68.941  63.518  1.00 76.37           C  
ATOM   2695  CD  LYS C 114       7.692  68.678  63.873  1.00 80.03           C  
ATOM   2696  CE  LYS C 114       7.570  67.932  65.206  1.00 81.48           C  
ATOM   2697  NZ  LYS C 114       6.159  67.538  65.495  1.00 81.78           N  
ATOM   2698  N   ASN C 115      11.129  71.984  62.035  1.00 43.99           N  
ATOM   2699  CA  ASN C 115      12.253  72.773  62.510  1.00 44.82           C  
ATOM   2700  C   ASN C 115      12.122  74.233  62.075  1.00 43.19           C  
ATOM   2701  O   ASN C 115      13.127  74.908  61.922  1.00 39.53           O  
ATOM   2702  CB  ASN C 115      13.563  72.200  61.972  1.00 60.02           C  
ATOM   2703  CG  ASN C 115      13.809  70.797  62.451  1.00 65.24           C  
ATOM   2704  OD1 ASN C 115      14.771  70.140  62.042  1.00 68.03           O  
ATOM   2705  ND2 ASN C 115      12.935  70.320  63.331  1.00 67.93           N  
ATOM   2706  N   GLY C 116      10.886  74.690  61.869  1.00 49.69           N  
ATOM   2707  CA  GLY C 116      10.632  76.065  61.461  1.00 53.44           C  
ATOM   2708  C   GLY C 116      11.364  76.618  60.241  1.00 54.44           C  
ATOM   2709  O   GLY C 116      11.374  77.832  60.036  1.00 53.00           O  
ATOM   2710  N   GLU C 117      11.981  75.753  59.435  1.00 51.41           N  
ATOM   2711  CA  GLU C 117      12.693  76.205  58.237  1.00 55.12           C  
ATOM   2712  C   GLU C 117      11.713  76.699  57.186  1.00 57.12           C  
ATOM   2713  O   GLU C 117      10.538  76.311  57.172  1.00 56.61           O  
ATOM   2714  CB  GLU C 117      13.526  75.086  57.628  1.00 67.20           C  
ATOM   2715  CG  GLU C 117      14.512  74.473  58.572  1.00 72.34           C  
ATOM   2716  CD  GLU C 117      15.603  73.742  57.839  1.00 76.22           C  
ATOM   2717  OE1 GLU C 117      16.351  72.970  58.480  1.00 77.87           O  
ATOM   2718  OE2 GLU C 117      15.717  73.952  56.611  1.00 78.85           O  
ATOM   2719  N   THR C 118      12.216  77.544  56.294  1.00 59.61           N  
ATOM   2720  CA  THR C 118      11.402  78.124  55.234  1.00 63.60           C  
ATOM   2721  C   THR C 118      11.360  77.271  53.977  1.00 65.98           C  
ATOM   2722  O   THR C 118      12.345  76.634  53.613  1.00 64.18           O  
ATOM   2723  CB  THR C 118      11.922  79.505  54.798  1.00 56.65           C  
ATOM   2724  OG1 THR C 118      12.467  80.201  55.926  1.00 55.28           O  
ATOM   2725  CG2 THR C 118      10.783  80.307  54.188  1.00 56.23           C  
ATOM   2726  N   ILE C 119      10.213  77.297  53.308  1.00 87.21           N  
ATOM   2727  CA  ILE C 119      10.014  76.556  52.075  1.00 91.41           C  
ATOM   2728  C   ILE C 119       9.028  77.323  51.196  1.00 93.62           C  
ATOM   2729  O   ILE C 119       7.821  77.318  51.438  1.00 93.62           O  
ATOM   2730  CB  ILE C 119       9.489  75.123  52.362  1.00 78.21           C  
ATOM   2731  CG1 ILE C 119       8.794  75.080  53.726  1.00 79.40           C  
ATOM   2732  CG2 ILE C 119      10.642  74.130  52.344  1.00 77.42           C  
ATOM   2733  CD1 ILE C 119       8.265  73.704  54.097  1.00 80.33           C  
ATOM   2734  N   SER C 120       9.558  77.998  50.182  1.00110.53           N  
ATOM   2735  CA  SER C 120       8.739  78.784  49.270  1.00111.69           C  
ATOM   2736  C   SER C 120       8.982  78.415  47.807  1.00112.56           C  
ATOM   2737  O   SER C 120       7.983  78.177  47.090  1.00112.21           O  
ATOM   2738  CB  SER C 120       8.998  80.281  49.488  1.00 94.22           C  
ATOM   2739  OG  SER C 120      10.374  80.596  49.344  1.00 93.48           O  
TER    2740      SER C 120                                                      
END
MOLECULE T0408.pdb
ATOM    769  N   PHE     7       8.970  79.991  40.219  1.00 59.01           N  
ATOM    770  CA  PHE     7       9.121  78.887  39.220  1.00 58.55           C  
ATOM    771  C   PHE     7      10.525  78.270  39.318  1.00 57.17           C  
ATOM    772  O   PHE     7      11.448  78.885  39.884  1.00 59.33           O  
ATOM    773  CB  PHE     7       8.894  79.403  37.792  1.00 59.50           C  
ATOM    774  CG  PHE     7       7.630  80.211  37.607  1.00 59.88           C  
ATOM    775  CD1 PHE     7       7.640  81.590  37.779  1.00 59.55           C  
ATOM    776  CD2 PHE     7       6.441  79.594  37.219  1.00 60.26           C  
ATOM    777  CE1 PHE     7       6.481  82.338  37.600  1.00 63.27           C  
ATOM    778  CE2 PHE     7       5.280  80.335  37.027  1.00 57.96           C  
ATOM    779  CZ  PHE     7       5.299  81.709  37.222  1.00 60.10           C  
ATOM    780  N   GLY     8      10.693  77.077  38.739  1.00 51.97           N  
ATOM    781  CA  GLY     8      11.946  76.308  38.864  1.00 47.06           C  
ATOM    782  C   GLY     8      13.010  76.644  37.842  1.00 42.74           C  
ATOM    783  O   GLY     8      12.960  77.691  37.199  1.00 40.60           O  
ATOM    784  N   GLU     9      13.969  75.734  37.690  1.00 39.01           N  
ATOM    785  CA  GLU     9      15.125  75.924  36.812  1.00 38.04           C  
ATOM    786  C   GLU     9      14.737  76.079  35.344  1.00 34.61           C  
ATOM    787  O   GLU     9      15.312  76.893  34.624  1.00 33.70           O  
ATOM    788  CB  GLU     9      16.093  74.746  36.964  1.00 38.65           C  
ATOM    789  N   GLY    10      13.750  75.287  34.915  1.00 34.19           N  
ATOM    790  CA  GLY    10      13.250  75.348  33.551  1.00 31.10           C  
ATOM    791  C   GLY    10      12.790  76.744  33.220  1.00 25.97           C  
ATOM    792  O   GLY    10      13.200  77.304  32.203  1.00 24.44           O  
ATOM    793  N   MET    11      11.958  77.314  34.091  1.00 26.78           N  
ATOM    794  CA  MET    11      11.453  78.679  33.871  1.00 26.99           C  
ATOM    795  C   MET    11      12.547  79.734  33.936  1.00 24.54           C  
ATOM    796  O   MET    11      12.436  80.750  33.237  1.00 22.59           O  
ATOM    797  CB  MET    11      10.298  79.036  34.809  1.00 26.96           C  
ATOM    798  CG  MET    11       8.956  78.424  34.384  1.00 30.81           C  
ATOM    799  SD  MET    11       8.363  79.163  32.682  0.75 32.36          SE  
ATOM    800  CE  MET    11       7.641  80.815  33.439  1.00 38.14           C  
ATOM    801  N   LYS    12      13.587  79.531  34.749  1.00 22.58           N  
ATOM    802  CA  LYS    12      14.709  80.488  34.749  1.00 22.98           C  
ATOM    803  C   LYS    12      15.471  80.468  33.411  1.00 20.97           C  
ATOM    804  O   LYS    12      15.931  81.507  32.944  1.00 22.83           O  
ATOM    805  CB  LYS    12      15.656  80.233  35.932  1.00 24.68           C  
ATOM    806  CG  LYS    12      14.987  80.568  37.290  1.00 26.05           C  
ATOM    807  CD  LYS    12      15.724  79.996  38.524  1.00 31.53           C  
ATOM    808  CE  LYS    12      17.178  80.177  38.487  1.00 33.33           C  
ATOM    809  NZ  LYS    12      17.857  79.899  39.811  1.00 35.75           N  
ATOM    810  N   VAL    13      15.558  79.292  32.784  1.00 23.05           N  
ATOM    811  CA  VAL    13      16.174  79.143  31.455  1.00 22.27           C  
ATOM    812  C   VAL    13      15.338  79.931  30.437  1.00 19.87           C  
ATOM    813  O   VAL    13      15.870  80.675  29.599  1.00 19.37           O  
ATOM    814  CB  VAL    13      16.227  77.631  31.026  1.00 24.12           C  
ATOM    815  CG1 VAL    13      16.716  77.489  29.584  1.00 25.29           C  
ATOM    816  CG2 VAL    13      17.136  76.836  31.979  1.00 30.23           C  
ATOM    817  N   VAL    14      14.032  79.817  30.576  1.00 20.72           N  
ATOM    818  CA  VAL    14      13.119  80.535  29.668  1.00 22.65           C  
ATOM    819  C   VAL    14      13.274  82.037  29.865  1.00 19.62           C  
ATOM    820  O   VAL    14      13.348  82.784  28.895  1.00 20.37           O  
ATOM    821  CB  VAL    14      11.657  80.121  29.823  1.00 21.69           C  
ATOM    822  CG1 VAL    14      10.788  80.938  28.849  1.00 21.74           C  
ATOM    823  CG2 VAL    14      11.465  78.585  29.542  1.00 26.25           C  
ATOM    824  N   LYS    15      13.332  82.483  31.131  1.00 21.22           N  
ATOM    825  CA  LYS    15      13.580  83.912  31.414  1.00 18.46           C  
ATOM    826  C   LYS    15      14.866  84.401  30.767  1.00 19.65           C  
ATOM    827  O   LYS    15      14.894  85.480  30.187  1.00 22.14           O  
ATOM    828  CB  LYS    15      13.617  84.181  32.921  1.00 18.27           C  
ATOM    829  N   GLU    16      15.918  83.608  30.857  1.00 21.08           N  
ATOM    830  CA  GLU    16      17.202  83.950  30.227  1.00 22.56           C  
ATOM    831  C   GLU    16      17.144  83.974  28.678  1.00 22.82           C  
ATOM    832  O   GLU    16      17.665  84.891  28.042  1.00 28.47           O  
ATOM    833  CB  GLU    16      18.277  82.981  30.693  1.00 24.31           C  
ATOM    834  N   LYS    17      16.521  82.963  28.097  1.00 21.86           N  
ATOM    835  CA  LYS    17      16.542  82.770  26.636  1.00 22.20           C  
ATOM    836  C   LYS    17      15.493  83.586  25.851  1.00 21.86           C  
ATOM    837  O   LYS    17      15.808  84.146  24.776  1.00 23.86           O  
ATOM    838  CB  LYS    17      16.365  81.277  26.315  1.00 21.29           C  
ATOM    839  N   TYR    18      14.290  83.672  26.407  1.00 22.99           N  
ATOM    840  CA  TYR    18      13.084  84.212  25.724  1.00 24.08           C  
ATOM    841  C   TYR    18      12.235  85.030  26.691  1.00 21.96           C  
ATOM    842  O   TYR    18      11.217  84.579  27.196  1.00 21.62           O  
ATOM    843  CB  TYR    18      12.270  83.071  25.102  1.00 23.86           C  
ATOM    844  CG  TYR    18      13.142  82.276  24.153  1.00 25.16           C  
ATOM    845  CD1 TYR    18      13.658  82.867  23.007  1.00 22.60           C  
ATOM    846  CD2 TYR    18      13.503  80.967  24.432  1.00 27.55           C  
ATOM    847  CE1 TYR    18      14.496  82.174  22.142  1.00 26.49           C  
ATOM    848  CE2 TYR    18      14.364  80.270  23.576  1.00 26.29           C  
ATOM    849  CZ  TYR    18      14.846  80.874  22.433  1.00 25.54           C  
ATOM    850  OH  TYR    18      15.686  80.188  21.581  1.00 26.16           O  
ATOM    851  N   PRO    19      12.703  86.256  26.994  1.00 22.95           N  
ATOM    852  CA  PRO    19      12.008  87.103  27.963  1.00 20.97           C  
ATOM    853  C   PRO    19      10.540  87.377  27.666  1.00 23.47           C  
ATOM    854  O   PRO    19       9.729  87.342  28.598  1.00 22.73           O  
ATOM    855  CB  PRO    19      12.823  88.395  27.933  1.00 22.49           C  
ATOM    856  CG  PRO    19      14.111  88.033  27.370  1.00 24.22           C  
ATOM    857  CD  PRO    19      13.956  86.869  26.528  1.00 23.77           C  
ATOM    858  N   ASP    20      10.175  87.629  26.413  1.00 23.93           N  
ATOM    859  CA  ASP    20       8.772  87.917  26.104  1.00 28.48           C  
ATOM    860  C   ASP    20       7.908  86.671  26.266  1.00 26.25           C  
ATOM    861  O   ASP    20       6.756  86.723  26.775  1.00 26.13           O  
ATOM    862  CB  ASP    20       8.618  88.482  24.690  1.00 30.80           C  
ATOM    863  CG  ASP    20       9.052  89.954  24.570  1.00 38.16           C  
ATOM    864  OD1 ASP    20       9.402  90.617  25.580  1.00 42.94           O  
ATOM    865  OD2 ASP    20       9.033  90.451  23.426  1.00 46.06           O  
ATOM    866  N   LEU    21       8.444  85.524  25.878  1.00 24.97           N  
ATOM    867  CA  LEU    21       7.721  84.269  26.090  1.00 23.54           C  
ATOM    868  C   LEU    21       7.555  83.994  27.575  1.00 22.52           C  
ATOM    869  O   LEU    21       6.474  83.604  28.042  1.00 24.44           O  
ATOM    870  CB  LEU    21       8.447  83.115  25.385  1.00 23.74           C  
ATOM    871  CG  LEU    21       7.857  81.731  25.468  1.00 25.87           C  
ATOM    872  CD1 LEU    21       6.373  81.718  24.990  1.00 25.00           C  
ATOM    873  CD2 LEU    21       8.754  80.756  24.680  1.00 23.70           C  
ATOM    874  N   TYR    22       8.626  84.193  28.326  1.00 22.41           N  
ATOM    875  CA  TYR    22       8.584  84.070  29.780  1.00 22.77           C  
ATOM    876  C   TYR    22       7.435  84.913  30.380  1.00 22.67           C  
ATOM    877  O   TYR    22       6.627  84.425  31.175  1.00 23.91           O  
ATOM    878  CB  TYR    22       9.912  84.494  30.385  1.00 23.66           C  
ATOM    879  CG  TYR    22       9.886  84.492  31.893  1.00 22.50           C  
ATOM    880  CD1 TYR    22      10.074  83.325  32.604  1.00 23.27           C  
ATOM    881  CD2 TYR    22       9.660  85.671  32.602  1.00 25.67           C  
ATOM    882  CE1 TYR    22      10.047  83.327  33.987  1.00 21.18           C  
ATOM    883  CE2 TYR    22       9.622  85.671  33.963  1.00 25.00           C  
ATOM    884  CZ  TYR    22       9.808  84.488  34.647  1.00 23.45           C  
ATOM    885  OH  TYR    22       9.784  84.487  35.999  1.00 27.44           O  
ATOM    886  N   ASP    23       7.378  86.174  29.980  1.00 23.82           N  
ATOM    887  CA  ASP    23       6.360  87.088  30.502  1.00 24.16           C  
ATOM    888  C   ASP    23       4.927  86.625  30.205  1.00 25.07           C  
ATOM    889  O   ASP    23       4.046  86.754  31.064  1.00 23.28           O  
ATOM    890  CB  ASP    23       6.577  88.482  29.910  1.00 24.42           C  
ATOM    891  CG  ASP    23       7.742  89.194  30.505  1.00 33.39           C  
ATOM    892  OD1 ASP    23       8.216  88.809  31.607  1.00 34.11           O  
ATOM    893  OD2 ASP    23       8.170  90.189  29.868  1.00 37.66           O  
ATOM    894  N   ILE    24       4.693  86.066  29.019  1.00 23.65           N  
ATOM    895  CA  ILE    24       3.350  85.619  28.651  1.00 24.84           C  
ATOM    896  C   ILE    24       3.018  84.370  29.489  1.00 23.61           C  
ATOM    897  O   ILE    24       1.899  84.210  29.967  1.00 24.22           O  
ATOM    898  CB  ILE    24       3.222  85.316  27.150  1.00 27.79           C  
ATOM    899  CG1 ILE    24       3.448  86.587  26.329  1.00 32.72           C  
ATOM    900  CG2 ILE    24       1.848  84.746  26.841  1.00 30.67           C  
ATOM    901  CD1 ILE    24       3.838  86.311  24.854  1.00 35.16           C  
ATOM    902  N   ILE    25       4.024  83.514  29.707  1.00 24.35           N  
ATOM    903  CA  ILE    25       3.817  82.316  30.523  1.00 24.21           C  
ATOM    904  C   ILE    25       3.445  82.707  31.965  1.00 23.22           C  
ATOM    905  O   ILE    25       2.509  82.132  32.562  1.00 25.47           O  
ATOM    906  CB  ILE    25       5.047  81.338  30.493  1.00 24.22           C  
ATOM    907  CG1 ILE    25       5.238  80.729  29.103  1.00 23.74           C  
ATOM    908  CG2 ILE    25       4.856  80.188  31.494  1.00 29.35           C  
ATOM    909  CD1 ILE    25       6.631  80.075  28.922  1.00 23.35           C  
ATOM    910  N   VAL    26       4.144  83.697  32.511  1.00 24.58           N  
ATOM    911  CA  VAL    26       3.846  84.171  33.859  1.00 26.19           C  
ATOM    912  C   VAL    26       2.405  84.710  33.937  1.00 24.90           C  
ATOM    913  O   VAL    26       1.639  84.349  34.854  1.00 24.16           O  
ATOM    914  CB  VAL    26       4.836  85.230  34.313  1.00 28.22           C  
ATOM    915  CG1 VAL    26       4.301  85.976  35.531  1.00 28.71           C  
ATOM    916  CG2 VAL    26       6.242  84.589  34.603  1.00 26.39           C  
ATOM    917  N   LYS    27       2.006  85.523  32.967  1.00 23.37           N  
ATOM    918  CA  LYS    27       0.622  86.024  32.925  0.50 23.88           C  
ATOM    920  C   LYS    27      -0.377  84.879  32.823  1.00 24.17           C  
ATOM    921  O   LYS    27      -1.387  84.886  33.498  1.00 24.41           O  
ATOM    922  CB  LYS    27       0.414  87.028  31.779  0.50 24.31           C  
ATOM    924  CG  LYS    27       1.172  88.334  31.934  0.50 20.98           C  
ATOM    926  N   LEU    28      -0.091  83.873  31.981  1.00 23.31           N  
ATOM    927  CA  LEU    28      -0.962  82.705  31.832  1.00 25.23           C  
ATOM    928  C   LEU    28      -1.121  81.995  33.180  1.00 25.13           C  
ATOM    929  O   LEU    28      -2.231  81.653  33.640  1.00 24.63           O  
ATOM    930  CB  LEU    28      -0.374  81.739  30.788  1.00 23.04           C  
ATOM    931  CG  LEU    28      -1.148  80.428  30.624  1.00 24.78           C  
ATOM    932  CD1 LEU    28      -2.545  80.697  30.079  1.00 32.09           C  
ATOM    933  CD2 LEU    28      -0.369  79.493  29.738  1.00 28.12           C  
ATOM    934  N   ASN    29       0.023  81.773  33.828  1.00 22.56           N  
ATOM    935  CA  ASN    29       0.048  81.101  35.117  1.00 24.38           C  
ATOM    936  C   ASN    29      -0.813  81.844  36.140  1.00 22.89           C  
ATOM    937  O   ASN    29      -1.651  81.255  36.839  1.00 26.79           O  
ATOM    938  CB  ASN    29       1.491  80.993  35.606  1.00 27.63           C  
ATOM    939  CG  ASN    29       1.585  80.340  36.962  1.00 33.82           C  
ATOM    940  OD1 ASN    29       1.667  79.126  37.053  1.00 33.33           O  
ATOM    941  ND2 ASN    29       1.566  81.143  38.011  1.00 35.43           N  
ATOM    942  N   ASP    30      -0.596  83.141  36.234  1.00 22.88           N  
ATOM    943  CA  ASP    30      -1.285  83.973  37.203  1.00 24.82           C  
ATOM    944  C   ASP    30      -2.797  84.034  36.943  1.00 25.07           C  
ATOM    945  O   ASP    30      -3.601  84.001  37.880  1.00 26.99           O  
ATOM    946  CB  ASP    30      -0.694  85.365  37.193  1.00 26.68           C  
ATOM    947  CG  ASP    30       0.726  85.408  37.720  1.00 28.43           C  
ATOM    948  OD1 ASP    30       1.234  84.358  38.174  1.00 35.44           O  
ATOM    949  OD2 ASP    30       1.331  86.499  37.649  1.00 29.80           O  
ATOM    950  N   THR    31      -3.173  84.070  35.675  1.00 22.79           N  
ATOM    951  CA  THR    31      -4.600  83.984  35.289  1.00 24.26           C  
ATOM    952  C   THR    31      -5.213  82.620  35.540  1.00 23.93           C  
ATOM    953  O   THR    31      -6.339  82.515  36.082  1.00 24.83           O  
ATOM    954  CB  THR    31      -4.809  84.366  33.824  1.00 22.72           C  
ATOM    955  OG1 THR    31      -4.260  85.683  33.614  1.00 30.25           O  
ATOM    956  CG2 THR    31      -6.307  84.307  33.460  1.00 24.57           C  
ATOM    957  N   VAL    32      -4.509  81.554  35.146  1.00 22.77           N  
ATOM    958  CA  VAL    32      -4.974  80.194  35.438  1.00 24.03           C  
ATOM    959  C   VAL    32      -5.286  80.043  36.936  1.00 23.77           C  
ATOM    960  O   VAL    32      -6.329  79.469  37.304  1.00 25.63           O  
ATOM    961  CB  VAL    32      -3.924  79.174  34.994  1.00 23.98           C  
ATOM    962  CG1 VAL    32      -4.033  77.835  35.796  1.00 24.54           C  
ATOM    963  CG2 VAL    32      -4.012  78.986  33.460  1.00 22.05           C  
ATOM    964  N   PHE    33      -4.431  80.590  37.799  1.00 23.43           N  
ATOM    965  CA  PHE    33      -4.601  80.397  39.246  1.00 25.33           C  
ATOM    966  C   PHE    33      -5.403  81.502  39.922  1.00 27.87           C  
ATOM    967  O   PHE    33      -5.384  81.637  41.159  1.00 27.20           O  
ATOM    968  CB  PHE    33      -3.266  80.181  39.951  1.00 27.45           C  
ATOM    969  CG  PHE    33      -2.688  78.829  39.709  1.00 26.58           C  
ATOM    970  CD1 PHE    33      -3.361  77.688  40.124  1.00 26.58           C  
ATOM    971  CD2 PHE    33      -1.487  78.692  39.040  1.00 27.16           C  
ATOM    972  CE1 PHE    33      -2.844  76.433  39.875  1.00 26.69           C  
ATOM    973  CE2 PHE    33      -0.960  77.444  38.790  1.00 25.47           C  
ATOM    974  CZ  PHE    33      -1.643  76.315  39.204  1.00 28.16           C  
ATOM    975  N   THR    34      -6.104  82.288  39.114  1.00 28.08           N  
ATOM    976  CA  THR    34      -7.123  83.205  39.620  1.00 27.68           C  
ATOM    977  C   THR    34      -8.472  82.607  39.227  1.00 26.27           C  
ATOM    978  O   THR    34      -9.079  82.991  38.223  1.00 24.59           O  
ATOM    979  CB  THR    34      -6.912  84.630  39.078  1.00 29.15           C  
ATOM    980  OG1 THR    34      -5.572  85.039  39.354  1.00 27.52           O  
ATOM    981  CG2 THR    34      -7.858  85.624  39.752  1.00 27.57           C  
ATOM    982  N   GLY    35      -8.916  81.627  40.013  1.00 23.37           N  
ATOM    983  CA  GLY    35     -10.169  80.966  39.763  1.00 26.15           C  
ATOM    984  C   GLY    35     -11.353  81.880  40.008  1.00 26.00           C  
ATOM    985  O   GLY    35     -11.261  82.862  40.761  1.00 26.21           O  
ATOM    986  N   LYS    36     -12.466  81.593  39.353  1.00 26.20           N  
ATOM    987  CA  LYS    36     -13.707  82.364  39.626  1.00 25.52           C  
ATOM    988  C   LYS    36     -14.401  81.918  40.902  1.00 25.59           C  
ATOM    989  O   LYS    36     -15.013  82.749  41.608  1.00 24.82           O  
ATOM    990  CB  LYS    36     -14.650  82.280  38.433  1.00 23.76           C  
ATOM    991  CG  LYS    36     -14.018  82.839  37.170  1.00 27.92           C  
ATOM    992  CD  LYS    36     -13.636  84.274  37.261  1.00 33.79           C  
ATOM    993  CE  LYS    36     -13.123  84.756  35.913  1.00 33.74           C  
ATOM    994  NZ  LYS    36     -12.672  86.191  35.921  1.00 36.41           N  
ATOM    995  N   THR    37     -14.305  80.634  41.224  1.00 26.34           N  
ATOM    996  CA  THR    37     -14.895  80.088  42.444  1.00 27.40           C  
ATOM    997  C   THR    37     -13.901  79.304  43.281  1.00 28.68           C  
ATOM    998  O   THR    37     -13.830  79.501  44.486  1.00 28.44           O  
ATOM    999  CB  THR    37     -16.085  79.125  42.147  1.00 30.61           C  
ATOM   1000  OG1 THR    37     -17.140  79.845  41.507  1.00 34.12           O  
ATOM   1001  CG2 THR    37     -16.683  78.562  43.442  1.00 27.91           C  
ATOM   1002  N   LEU    38     -13.154  78.398  42.652  1.00 24.44           N  
ATOM   1003  CA  LEU    38     -12.190  77.556  43.382  1.00 24.53           C  
ATOM   1004  C   LEU    38     -11.018  78.408  43.841  1.00 26.73           C  
ATOM   1005  O   LEU    38     -10.561  79.304  43.117  1.00 26.13           O  
ATOM   1006  CB  LEU    38     -11.682  76.416  42.494  1.00 24.24           C  
ATOM   1007  CG  LEU    38     -12.721  75.446  41.996  1.00 25.01           C  
ATOM   1008  CD1 LEU    38     -12.043  74.310  41.217  1.00 23.26           C  
ATOM   1009  CD2 LEU    38     -13.555  74.919  43.151  1.00 22.80           C  
ATOM   1010  N   ASP    39     -10.539  78.150  45.053  1.00 25.77           N  
ATOM   1011  CA  ASP    39      -9.405  78.915  45.556  1.00 26.59           C  
ATOM   1012  C   ASP    39      -8.085  78.324  45.076  1.00 26.80           C  
ATOM   1013  O   ASP    39      -8.046  77.280  44.439  1.00 24.07           O  
ATOM   1014  CB  ASP    39      -9.484  79.093  47.084  1.00 27.84           C  
ATOM   1015  CG  ASP    39      -9.352  77.804  47.861  1.00 31.36           C  
ATOM   1016  OD1 ASP    39      -8.887  76.754  47.351  1.00 28.62           O  
ATOM   1017  OD2 ASP    39      -9.729  77.848  49.052  1.00 33.78           O  
ATOM   1018  N   TYR    40      -7.011  79.046  45.327  1.00 25.33           N  
ATOM   1019  CA  TYR    40      -5.703  78.664  44.822  1.00 24.51           C  
ATOM   1020  C   TYR    40      -5.243  77.312  45.372  1.00 25.46           C  
ATOM   1021  O   TYR    40      -4.698  76.478  44.641  1.00 24.60           O  
ATOM   1022  CB  TYR    40      -4.723  79.753  45.247  1.00 28.58           C  
ATOM   1023  CG  TYR    40      -3.320  79.640  44.733  1.00 27.35           C  
ATOM   1024  CD1 TYR    40      -3.051  79.264  43.426  1.00 42.63           C  
ATOM   1025  CD2 TYR    40      -2.241  79.981  45.555  1.00 35.86           C  
ATOM   1026  CE1 TYR    40      -1.744  79.202  42.958  1.00 45.32           C  
ATOM   1027  CE2 TYR    40      -0.946  79.919  45.099  1.00 36.50           C  
ATOM   1028  CZ  TYR    40      -0.701  79.543  43.803  1.00 41.69           C  
ATOM   1029  OH  TYR    40       0.596  79.495  43.344  1.00 43.10           O  
ATOM   1030  N   LYS    41      -5.466  77.097  46.659  1.00 24.17           N  
ATOM   1031  CA  LYS    41      -5.137  75.787  47.259  1.00 26.03           C  
ATOM   1032  C   LYS    41      -5.786  74.622  46.516  1.00 24.80           C  
ATOM   1033  O   LYS    41      -5.121  73.627  46.222  1.00 24.41           O  
ATOM   1034  CB  LYS    41      -5.525  75.756  48.725  1.00 26.17           C  
ATOM   1035  CG  LYS    41      -5.211  74.458  49.459  1.00 31.58           C  
ATOM   1036  CD  LYS    41      -5.774  74.499  50.886  1.00 33.11           C  
ATOM   1037  CE  LYS    41      -5.347  73.283  51.704  1.00 42.88           C  
ATOM   1038  NZ  LYS    41      -5.846  73.354  53.109  1.00 41.08           N  
ATOM   1039  N   THR    42      -7.074  74.738  46.237  1.00 24.70           N  
ATOM   1040  CA  THR    42      -7.798  73.688  45.520  1.00 23.81           C  
ATOM   1041  C   THR    42      -7.217  73.448  44.133  1.00 24.23           C  
ATOM   1042  O   THR    42      -7.022  72.317  43.719  1.00 23.25           O  
ATOM   1043  CB  THR    42      -9.301  73.985  45.416  1.00 24.82           C  
ATOM   1044  OG1 THR    42      -9.845  74.084  46.733  1.00 25.22           O  
ATOM   1045  CG2 THR    42     -10.038  72.883  44.667  1.00 25.77           C  
ATOM   1046  N   GLN    43      -6.933  74.527  43.418  1.00 23.43           N  
ATOM   1047  CA  GLN    43      -6.319  74.414  42.118  1.00 22.86           C  
ATOM   1048  C   GLN    43      -4.922  73.781  42.157  1.00 23.94           C  
ATOM   1049  O   GLN    43      -4.585  73.025  41.268  1.00 22.91           O  
ATOM   1050  CB  GLN    43      -6.246  75.772  41.437  1.00 24.01           C  
ATOM   1051  CG  GLN    43      -7.565  76.328  41.029  1.00 22.72           C  
ATOM   1052  CD  GLN    43      -7.399  77.608  40.263  1.00 23.02           C  
ATOM   1053  OE1 GLN    43      -6.876  78.573  40.809  1.00 25.62           O  
ATOM   1054  NE2 GLN    43      -7.853  77.631  39.000  1.00 24.23           N  
ATOM   1055  N   LYS    44      -4.119  74.119  43.152  1.00 23.49           N  
ATOM   1056  CA  LYS    44      -2.798  73.504  43.293  1.00 22.94           C  
ATOM   1057  C   LYS    44      -2.885  72.010  43.618  1.00 23.73           C  
ATOM   1058  O   LYS    44      -2.073  71.231  43.139  1.00 23.97           O  
ATOM   1059  CB  LYS    44      -1.964  74.236  44.353  1.00 26.12           C  
ATOM   1060  CG  LYS    44      -1.383  75.517  43.796  1.00 37.14           C  
ATOM   1061  CD  LYS    44      -0.199  75.250  42.854  1.00 40.63           C  
ATOM   1062  CE  LYS    44       0.270  76.569  42.238  1.00 46.64           C  
ATOM   1063  NZ  LYS    44       1.409  76.414  41.283  1.00 41.05           N  
ATOM   1064  N   LEU    45      -3.875  71.626  44.416  1.00 22.77           N  
ATOM   1065  CA  LEU    45      -4.158  70.192  44.683  1.00 22.94           C  
ATOM   1066  C   LEU    45      -4.528  69.448  43.403  1.00 20.00           C  
ATOM   1067  O   LEU    45      -4.064  68.333  43.149  1.00 21.82           O  
ATOM   1068  CB  LEU    45      -5.255  70.034  45.759  1.00 24.89           C  
ATOM   1069  CG  LEU    45      -4.872  70.484  47.179  1.00 24.96           C  
ATOM   1070  CD1 LEU    45      -6.093  70.532  48.099  1.00 25.24           C  
ATOM   1071  CD2 LEU    45      -3.795  69.570  47.786  1.00 26.64           C  
ATOM   1072  N   ILE    46      -5.331  70.092  42.557  1.00 20.74           N  
ATOM   1073  CA  ILE    46      -5.651  69.564  41.249  1.00 21.62           C  
ATOM   1074  C   ILE    46      -4.391  69.407  40.390  1.00 20.78           C  
ATOM   1075  O   ILE    46      -4.202  68.383  39.737  1.00 21.91           O  
ATOM   1076  CB  ILE    46      -6.704  70.453  40.547  1.00 22.08           C  
ATOM   1077  CG1 ILE    46      -8.055  70.378  41.275  1.00 24.84           C  
ATOM   1078  CG2 ILE    46      -6.892  70.056  39.052  1.00 22.38           C  
ATOM   1079  CD1 ILE    46      -9.010  71.552  40.931  1.00 22.86           C  
ATOM   1080  N   ALA    47      -3.523  70.426  40.416  1.00 21.87           N  
ATOM   1081  CA  ALA    47      -2.279  70.384  39.643  1.00 21.24           C  
ATOM   1082  C   ALA    47      -1.416  69.194  40.090  1.00 21.15           C  
ATOM   1083  O   ALA    47      -0.852  68.486  39.264  1.00 23.10           O  
ATOM   1084  CB  ALA    47      -1.507  71.727  39.768  1.00 21.67           C  
ATOM   1085  N   ILE    48      -1.326  68.971  41.401  1.00 23.22           N  
ATOM   1086  CA  ILE    48      -0.581  67.815  41.934  1.00 23.42           C  
ATOM   1087  C   ILE    48      -1.151  66.535  41.379  1.00 22.45           C  
ATOM   1088  O   ILE    48      -0.412  65.683  40.917  1.00 22.38           O  
ATOM   1089  CB  ILE    48      -0.565  67.783  43.480  1.00 22.22           C  
ATOM   1090  CG1 ILE    48       0.257  68.942  44.048  1.00 26.05           C  
ATOM   1091  CG2 ILE    48       0.049  66.452  44.023  1.00 25.18           C  
ATOM   1092  CD1 ILE    48      -0.059  69.242  45.504  1.00 25.14           C  
ATOM   1093  N   GLY    49      -2.485  66.395  41.436  1.00 23.64           N  
ATOM   1094  CA  GLY    49      -3.152  65.223  40.890  1.00 22.69           C  
ATOM   1095  C   GLY    49      -2.810  64.948  39.439  1.00 22.13           C  
ATOM   1096  O   GLY    49      -2.514  63.817  39.044  1.00 22.25           O  
ATOM   1097  N   ILE    50      -2.858  65.995  38.620  1.00 21.97           N  
ATOM   1098  CA  ILE    50      -2.611  65.842  37.209  1.00 23.22           C  
ATOM   1099  C   ILE    50      -1.179  65.410  36.958  1.00 20.30           C  
ATOM   1100  O   ILE    50      -0.936  64.483  36.198  1.00 22.58           O  
ATOM   1101  CB  ILE    50      -2.928  67.132  36.415  1.00 23.33           C  
ATOM   1102  CG1 ILE    50      -4.446  67.402  36.425  1.00 25.36           C  
ATOM   1103  CG2 ILE    50      -2.410  67.043  34.958  1.00 25.70           C  
ATOM   1104  CD1 ILE    50      -4.873  68.780  35.946  1.00 23.40           C  
ATOM   1105  N   VAL    51      -0.226  66.112  37.554  1.00 22.13           N  
ATOM   1106  CA  VAL    51       1.198  65.805  37.361  0.50 22.96           C  
ATOM   1108  C   VAL    51       1.534  64.410  37.901  1.00 22.59           C  
ATOM   1109  O   VAL    51       2.294  63.639  37.290  1.00 23.85           O  
ATOM   1110  CB  VAL    51       2.072  66.864  38.052  0.50 23.96           C  
ATOM   1112  CG1 VAL    51       3.558  66.521  37.912  0.50 22.52           C  
ATOM   1114  CG2 VAL    51       1.793  68.268  37.453  0.50 24.56           C  
ATOM   1116  N   ALA    52       0.940  64.069  39.051  1.00 21.97           N  
ATOM   1117  CA  ALA    52       1.198  62.761  39.646  1.00 22.83           C  
ATOM   1118  C   ALA    52       0.615  61.626  38.821  1.00 24.96           C  
ATOM   1119  O   ALA    52       1.057  60.489  38.972  1.00 27.05           O  
ATOM   1120  CB  ALA    52       0.708  62.681  41.110  1.00 22.19           C  
ATOM   1121  N   SER    53      -0.366  61.908  37.962  1.00 23.44           N  
ATOM   1122  CA  SER    53      -0.993  60.900  37.128  0.50 24.03           C  
ATOM   1124  C   SER    53      -0.070  60.482  35.984  1.00 28.22           C  
ATOM   1125  O   SER    53      -0.306  59.463  35.352  1.00 29.44           O  
ATOM   1126  CB  SER    53      -2.358  61.369  36.590  0.50 24.46           C  
ATOM   1128  OG  SER    53      -2.273  62.367  35.572  0.50 17.33           O  
ATOM   1130  N   ARG    54       0.967  61.288  35.750  1.00 27.88           N  
ATOM   1131  CA  ARG    54       1.961  61.079  34.686  1.00 36.49           C  
ATOM   1132  C   ARG    54       3.323  60.666  35.269  1.00 42.51           C  
ATOM   1133  O   ARG    54       3.434  60.416  36.472  1.00 42.98           O  
ATOM   1134  CB  ARG    54       2.061  62.360  33.864  1.00 36.62           C  
ATOM   1135  CG  ARG    54       0.682  62.788  33.371  1.00 36.07           C  
ATOM   1136  CD  ARG    54       0.720  63.747  32.220  1.00 46.03           C  
ATOM   1137  NE  ARG    54       1.186  65.048  32.671  1.00 47.58           N  
ATOM   1138  CZ  ARG    54       0.593  66.218  32.427  1.00 48.31           C  
ATOM   1139  NH1 ARG    54      -0.539  66.301  31.716  1.00 41.50           N  
ATOM   1140  NH2 ARG    54       1.152  67.314  32.919  1.00 45.55           N  
ATOM   1141  N   CYS    55       4.364  60.567  34.441  1.00 47.81           N  
ATOM   1142  CA  CYS    55       5.609  59.917  34.908  1.00 53.06           C  
ATOM   1143  C   CYS    55       6.714  60.870  35.342  1.00 53.53           C  
ATOM   1144  O   CYS    55       7.760  60.423  35.818  1.00 55.63           O  
ATOM   1145  CB  CYS    55       6.175  58.963  33.844  1.00 54.41           C  
ATOM   1146  SG  CYS    55       4.966  57.829  33.125  1.00 70.70           S  
ATOM   1147  N   ASP    56       6.510  62.170  35.183  1.00 51.11           N  
ATOM   1148  CA  ASP    56       7.593  63.097  35.442  1.00 50.75           C  
ATOM   1149  C   ASP    56       7.796  63.237  36.966  1.00 47.60           C  
ATOM   1150  O   ASP    56       7.187  64.093  37.608  1.00 47.73           O  
ATOM   1151  CB  ASP    56       7.335  64.451  34.744  1.00 51.45           C  
ATOM   1152  CG  ASP    56       8.549  65.360  34.751  1.00 55.00           C  
ATOM   1153  OD1 ASP    56       9.598  64.950  35.298  1.00 59.75           O  
ATOM   1154  OD2 ASP    56       8.445  66.490  34.211  1.00 56.95           O  
ATOM   1155  N   GLU    57       8.662  62.376  37.505  1.00 44.76           N  
ATOM   1156  CA  GLU    57       9.079  62.384  38.919  1.00 44.68           C  
ATOM   1157  C   GLU    57       9.555  63.747  39.434  1.00 43.54           C  
ATOM   1158  O   GLU    57       9.225  64.151  40.554  1.00 39.20           O  
ATOM   1159  CB  GLU    57      10.193  61.362  39.121  1.00 44.24           C  
ATOM   1160  CG  GLU    57      10.658  61.181  40.556  1.00 49.33           C  
ATOM   1161  N   VAL    58      10.342  64.453  38.623  1.00 44.25           N  
ATOM   1162  CA  VAL    58      10.846  65.761  39.019  1.00 41.66           C  
ATOM   1163  C   VAL    58       9.712  66.771  39.079  1.00 39.99           C  
ATOM   1164  O   VAL    58       9.637  67.563  40.023  1.00 40.88           O  
ATOM   1165  CB  VAL    58      12.003  66.255  38.076  1.00 44.98           C  
ATOM   1166  N   ALA    59       8.820  66.732  38.092  1.00 36.00           N  
ATOM   1167  CA  ALA    59       7.624  67.563  38.085  1.00 36.40           C  
ATOM   1168  C   ALA    59       6.746  67.291  39.314  1.00 34.21           C  
ATOM   1169  O   ALA    59       6.208  68.222  39.935  1.00 33.66           O  
ATOM   1170  CB  ALA    59       6.840  67.324  36.816  1.00 37.99           C  
ATOM   1171  N   ILE    60       6.614  66.013  39.667  1.00 31.22           N  
ATOM   1172  CA  ILE    60       5.812  65.647  40.839  1.00 28.82           C  
ATOM   1173  C   ILE    60       6.454  66.198  42.119  1.00 27.71           C  
ATOM   1174  O   ILE    60       5.781  66.867  42.913  1.00 27.90           O  
ATOM   1175  CB  ILE    60       5.613  64.129  40.959  1.00 27.95           C  
ATOM   1176  CG1 ILE    60       4.862  63.584  39.742  1.00 27.51           C  
ATOM   1177  CG2 ILE    60       4.812  63.808  42.224  1.00 26.18           C  
ATOM   1178  CD1 ILE    60       4.987  62.071  39.545  1.00 25.07           C  
ATOM   1179  N   GLU    61       7.741  65.915  42.319  1.00 30.04           N  
ATOM   1180  CA  GLU    61       8.460  66.430  43.501  1.00 32.80           C  
ATOM   1181  C   GLU    61       8.345  67.964  43.626  1.00 35.05           C  
ATOM   1182  O   GLU    61       8.090  68.492  44.715  1.00 33.59           O  
ATOM   1183  CB  GLU    61       9.925  65.988  43.468  1.00 33.45           C  
ATOM   1184  CG  GLU    61      10.720  66.333  44.743  1.00 36.55           C  
ATOM   1185  N   LYS    62       8.492  68.665  42.503  1.00 38.76           N  
ATOM   1186  CA  LYS    62       8.430  70.135  42.479  1.00 39.30           C  
ATOM   1187  C   LYS    62       7.040  70.681  42.772  1.00 38.68           C  
ATOM   1188  O   LYS    62       6.906  71.655  43.526  1.00 36.68           O  
ATOM   1189  CB  LYS    62       8.919  70.670  41.123  1.00 42.11           C  
ATOM   1190  N   GLN    63       5.995  70.076  42.198  1.00 35.90           N  
ATOM   1191  CA  GLN    63       4.635  70.517  42.512  1.00 36.26           C  
ATOM   1192  C   GLN    63       4.355  70.313  43.989  1.00 33.33           C  
ATOM   1193  O   GLN    63       3.755  71.165  44.626  1.00 33.91           O  
ATOM   1194  CB  GLN    63       3.548  69.798  41.676  1.00 39.20           C  
ATOM   1195  CG  GLN    63       3.160  70.466  40.335  1.00 44.45           C  
ATOM   1196  CD  GLN    63       2.333  71.749  40.478  1.00 44.95           C  
ATOM   1197  OE1 GLN    63       1.712  72.008  41.510  1.00 62.12           O  
ATOM   1198  NE2 GLN    63       2.315  72.547  39.425  1.00 63.66           N  
ATOM   1199  N   MET    64       4.752  69.161  44.531  1.00 30.47           N  
ATOM   1200  CA  MET    64       4.471  68.856  45.916  1.00 26.68           C  
ATOM   1201  C   MET    64       5.225  69.810  46.838  1.00 29.86           C  
ATOM   1202  O   MET    64       4.645  70.361  47.788  1.00 28.23           O  
ATOM   1203  CB  MET    64       4.864  67.412  46.233  1.00 23.18           C  
ATOM   1204  CG  MET    64       3.918  66.370  45.589  1.00 22.57           C  
ATOM   1205  SD  MET    64       4.418  64.644  46.195  0.75 22.23          SE  
ATOM   1206  CE  MET    64       3.056  63.632  45.253  1.00 22.00           C  
ATOM   1207  N   LYS    65       6.514  69.998  46.544  1.00 32.32           N  
ATOM   1208  CA  LYS    65       7.386  70.856  47.371  1.00 34.88           C  
ATOM   1209  C   LYS    65       6.857  72.284  47.412  1.00 34.19           C  
ATOM   1210  O   LYS    65       6.702  72.863  48.483  1.00 35.31           O  
ATOM   1211  CB  LYS    65       8.826  70.843  46.843  1.00 35.46           C  
ATOM   1212  CG  LYS    65       9.625  69.629  47.243  1.00 40.38           C  
ATOM   1213  N   SER    66       6.564  72.836  46.245  1.00 36.71           N  
ATOM   1214  CA  SER    66       6.041  74.200  46.142  0.50 37.97           C  
ATOM   1216  C   SER    66       4.709  74.361  46.864  1.00 39.15           C  
ATOM   1217  O   SER    66       4.486  75.342  47.552  1.00 40.37           O  
ATOM   1218  CB  SER    66       5.895  74.618  44.676  0.50 38.61           C  
ATOM   1220  OG  SER    66       5.090  73.703  43.950  0.50 37.08           O  
ATOM   1222  N   ALA    67       3.815  73.392  46.707  1.00 37.33           N  
ATOM   1223  CA  ALA    67       2.536  73.447  47.409  1.00 35.90           C  
ATOM   1224  C   ALA    67       2.708  73.505  48.921  1.00 33.63           C  
ATOM   1225  O   ALA    67       2.000  74.242  49.614  1.00 33.38           O  
ATOM   1226  CB  ALA    67       1.675  72.239  47.036  1.00 35.08           C  
ATOM   1227  N   MET    68       3.620  72.690  49.440  1.00 32.12           N  
ATOM   1228  CA  MET    68       3.809  72.592  50.861  1.00 32.59           C  
ATOM   1229  C   MET    68       4.455  73.891  51.335  1.00 33.83           C  
ATOM   1230  O   MET    68       4.036  74.457  52.332  1.00 35.23           O  
ATOM   1231  CB  MET    68       4.684  71.396  51.205  1.00 33.38           C  
ATOM   1232  CG  MET    68       4.027  70.041  50.923  1.00 33.32           C  
ATOM   1233  SD  MET    68       5.192  68.597  51.472  0.75 34.95          SE  
ATOM   1234  CE  MET    68       4.864  68.765  53.369  1.00 39.85           C  
ATOM   1235  N   LYS    69       5.428  74.370  50.567  1.00 35.03           N  
ATOM   1236  CA  LYS    69       6.210  75.565  50.936  1.00 37.33           C  
ATOM   1237  C   LYS    69       5.376  76.830  50.796  1.00 38.14           C  
ATOM   1238  O   LYS    69       5.218  77.585  51.764  1.00 42.29           O  
ATOM   1239  CB  LYS    69       7.470  75.676  50.075  1.00 36.02           C  
ATOM   1240  N   GLU    70       4.833  77.048  49.606  1.00 39.17           N  
ATOM   1241  CA  GLU    70       4.066  78.262  49.302  1.00 40.19           C  
ATOM   1242  C   GLU    70       2.697  78.317  49.975  1.00 40.34           C  
ATOM   1243  O   GLU    70       2.343  79.342  50.543  1.00 42.02           O  
ATOM   1244  CB  GLU    70       3.909  78.452  47.786  1.00 39.25           C  
ATOM   1245  N   LEU    71       1.936  77.226  49.937  1.00 39.71           N  
ATOM   1246  CA  LEU    71       0.552  77.239  50.424  1.00 38.07           C  
ATOM   1247  C   LEU    71       0.339  76.549  51.771  1.00 34.95           C  
ATOM   1248  O   LEU    71      -0.765  76.565  52.307  1.00 37.25           O  
ATOM   1249  CB  LEU    71      -0.380  76.601  49.371  1.00 39.04           C  
ATOM   1250  CG  LEU    71      -0.453  77.252  47.981  1.00 43.95           C  
ATOM   1251  CD1 LEU    71       0.756  76.880  47.115  1.00 50.69           C  
ATOM   1252  CD2 LEU    71      -1.736  76.876  47.251  1.00 39.57           C  
ATOM   1253  N   GLY    72       1.355  75.907  52.325  1.00 31.62           N  
ATOM   1254  CA  GLY    72       1.147  75.169  53.571  1.00 31.33           C  
ATOM   1255  C   GLY    72       0.288  73.914  53.427  1.00 30.39           C  
ATOM   1256  O   GLY    72      -0.302  73.424  54.405  1.00 31.58           O  
ATOM   1257  N   ILE    73       0.217  73.377  52.213  1.00 32.06           N  
ATOM   1258  CA  ILE    73      -0.496  72.104  51.983  1.00 28.57           C  
ATOM   1259  C   ILE    73       0.221  70.989  52.779  1.00 29.16           C  
ATOM   1260  O   ILE    73       1.450  70.986  52.850  1.00 29.32           O  
ATOM   1261  CB  ILE    73      -0.621  71.840  50.468  1.00 30.50           C  
ATOM   1262  CG1 ILE    73      -1.744  72.732  49.891  1.00 27.84           C  
ATOM   1263  CG2 ILE    73      -0.867  70.336  50.174  1.00 25.19           C  
ATOM   1264  CD1 ILE    73      -1.816  72.820  48.371  1.00 30.38           C  
ATOM   1265  N   THR    74      -0.530  70.088  53.420  1.00 27.36           N  
ATOM   1266  CA  THR    74       0.088  69.024  54.242  1.00 27.26           C  
ATOM   1267  C   THR    74       0.356  67.745  53.462  1.00 27.58           C  
ATOM   1268  O   THR    74      -0.238  67.522  52.416  1.00 24.17           O  
ATOM   1269  CB  THR    74      -0.757  68.627  55.460  1.00 29.19           C  
ATOM   1270  OG1 THR    74      -2.004  68.099  55.031  1.00 28.81           O  
ATOM   1271  CG2 THR    74      -0.971  69.880  56.480  1.00 28.98           C  
ATOM   1272  N   LYS    75       1.211  66.876  53.997  1.00 26.69           N  
ATOM   1273  CA  LYS    75       1.408  65.575  53.357  1.00 24.94           C  
ATOM   1274  C   LYS    75       0.105  64.766  53.394  1.00 24.97           C  
ATOM   1275  O   LYS    75      -0.183  64.049  52.430  1.00 24.26           O  
ATOM   1276  CB  LYS    75       2.547  64.787  54.001  1.00 25.92           C  
ATOM   1277  CG  LYS    75       3.941  65.377  53.781  1.00 25.04           C  
ATOM   1278  CD  LYS    75       5.016  64.369  54.207  1.00 27.40           C  
ATOM   1279  CE  LYS    75       6.395  64.744  53.675  1.00 30.74           C  
ATOM   1280  NZ  LYS    75       7.337  63.582  53.770  1.00 29.47           N  
ATOM   1281  N   GLU    76      -0.705  64.923  54.456  1.00 23.62           N  
ATOM   1282  CA  GLU    76      -2.006  64.250  54.537  1.00 27.19           C  
ATOM   1283  C   GLU    76      -2.963  64.703  53.418  1.00 22.94           C  
ATOM   1284  O   GLU    76      -3.670  63.897  52.828  1.00 25.59           O  
ATOM   1285  CB  GLU    76      -2.676  64.495  55.897  1.00 28.02           C  
ATOM   1286  CG  GLU    76      -3.944  63.646  56.101  1.00 35.01           C  
ATOM   1287  CD  GLU    76      -4.602  63.869  57.467  1.00 37.01           C  
ATOM   1288  OE1 GLU    76      -4.541  65.017  57.990  1.00 52.64           O  
ATOM   1289  OE2 GLU    76      -5.167  62.883  58.002  1.00 48.87           O  
ATOM   1290  N   GLU    77      -2.974  65.994  53.116  1.00 24.57           N  
ATOM   1291  CA  GLU    77      -3.774  66.494  52.000  1.00 24.63           C  
ATOM   1292  C   GLU    77      -3.272  65.945  50.656  1.00 24.30           C  
ATOM   1293  O   GLU    77      -4.068  65.546  49.803  1.00 23.45           O  
ATOM   1294  CB  GLU    77      -3.785  68.017  51.965  1.00 25.09           C  
ATOM   1295  CG  GLU    77      -4.555  68.632  53.117  1.00 28.85           C  
ATOM   1296  CD  GLU    77      -4.410  70.153  53.229  1.00 30.84           C  
ATOM   1297  OE1 GLU    77      -3.353  70.735  52.878  1.00 33.27           O  
ATOM   1298  OE2 GLU    77      -5.388  70.777  53.674  1.00 33.37           O  
ATOM   1299  N   ILE    78      -1.955  65.938  50.475  1.00 24.49           N  
ATOM   1300  CA  ILE    78      -1.378  65.340  49.262  1.00 23.04           C  
ATOM   1301  C   ILE    78      -1.725  63.851  49.134  1.00 21.63           C  
ATOM   1302  O   ILE    78      -2.100  63.380  48.059  1.00 21.32           O  
ATOM   1303  CB  ILE    78       0.162  65.600  49.123  1.00 22.33           C  
ATOM   1304  CG1 ILE    78       0.452  67.103  49.059  1.00 25.20           C  
ATOM   1305  CG2 ILE    78       0.697  64.957  47.836  1.00 21.31           C  
ATOM   1306  CD1 ILE    78       1.911  67.437  49.205  1.00 24.12           C  
ATOM   1307  N   ALA    79      -1.679  63.116  50.236  1.00 22.41           N  
ATOM   1308  CA  ALA    79      -2.026  61.718  50.200  1.00 20.30           C  
ATOM   1309  C   ALA    79      -3.467  61.520  49.727  1.00 21.42           C  
ATOM   1310  O   ALA    79      -3.749  60.611  48.966  1.00 20.43           O  
ATOM   1311  CB  ALA    79      -1.797  61.071  51.552  1.00 22.66           C  
ATOM   1312  N   ASP    80      -4.374  62.409  50.130  1.00 20.93           N  
ATOM   1313  CA  ASP    80      -5.762  62.331  49.652  1.00 20.26           C  
ATOM   1314  C   ASP    80      -5.885  62.593  48.155  1.00 22.81           C  
ATOM   1315  O   ASP    80      -6.734  62.009  47.494  1.00 22.27           O  
ATOM   1316  CB  ASP    80      -6.667  63.310  50.395  1.00 20.14           C  
ATOM   1317  CG  ASP    80      -7.045  62.853  51.807  1.00 23.19           C  
ATOM   1318  OD1 ASP    80      -6.928  61.652  52.156  1.00 25.42           O  
ATOM   1319  OD2 ASP    80      -7.525  63.728  52.549  1.00 28.27           O  
ATOM   1320  N   VAL    81      -5.043  63.483  47.619  1.00 21.25           N  
ATOM   1321  CA  VAL    81      -4.939  63.659  46.181  1.00 22.27           C  
ATOM   1322  C   VAL    81      -4.492  62.341  45.520  1.00 20.03           C  
ATOM   1323  O   VAL    81      -5.078  61.898  44.508  1.00 19.50           O  
ATOM   1324  CB  VAL    81      -3.963  64.805  45.817  1.00 20.90           C  
ATOM   1325  CG1 VAL    81      -3.757  64.895  44.302  1.00 22.88           C  
ATOM   1326  CG2 VAL    81      -4.425  66.168  46.443  1.00 20.83           C  
ATOM   1327  N   LEU    82      -3.519  61.673  46.131  1.00 20.16           N  
ATOM   1328  CA  LEU    82      -2.954  60.455  45.560  1.00 19.84           C  
ATOM   1329  C   LEU    82      -3.955  59.291  45.560  1.00 18.54           C  
ATOM   1330  O   LEU    82      -3.913  58.425  44.676  1.00 19.11           O  
ATOM   1331  CB  LEU    82      -1.666  60.090  46.263  1.00 20.98           C  
ATOM   1332  CG  LEU    82      -0.551  61.135  46.146  1.00 20.66           C  
ATOM   1333  CD1 LEU    82       0.766  60.558  46.671  1.00 21.28           C  
ATOM   1334  CD2 LEU    82      -0.392  61.639  44.674  1.00 22.33           C  
ATOM   1335  N   ARG    83      -4.911  59.309  46.495  1.00 20.31           N  
ATOM   1336  CA  ARG    83      -5.991  58.304  46.463  1.00 21.39           C  
ATOM   1337  C   ARG    83      -6.744  58.386  45.139  1.00 20.18           C  
ATOM   1338  O   ARG    83      -7.025  57.394  44.468  1.00 19.30           O  
ATOM   1339  CB  ARG    83      -6.940  58.521  47.643  1.00 22.29           C  
ATOM   1340  CG  ARG    83      -6.321  58.269  48.999  1.00 22.30           C  
ATOM   1341  CD  ARG    83      -7.215  58.747  50.124  1.00 28.97           C  
ATOM   1342  NE  ARG    83      -8.051  57.695  50.628  1.00 33.52           N  
ATOM   1343  CZ  ARG    83      -7.790  56.938  51.696  1.00 23.68           C  
ATOM   1344  NH1 ARG    83      -6.703  57.064  52.438  1.00 32.40           N  
ATOM   1345  NH2 ARG    83      -8.646  56.031  52.018  1.00 24.82           N  
ATOM   1346  N   VAL    84      -7.007  59.612  44.712  1.00 19.60           N  
ATOM   1347  CA  VAL    84      -7.659  59.856  43.423  1.00 20.32           C  
ATOM   1348  C   VAL    84      -6.772  59.472  42.241  1.00 20.03           C  
ATOM   1349  O   VAL    84      -7.255  58.901  41.275  1.00 20.48           O  
ATOM   1350  CB  VAL    84      -8.137  61.322  43.296  1.00 21.39           C  
ATOM   1351  CG1 VAL    84      -8.987  61.511  41.998  1.00 22.27           C  
ATOM   1352  CG2 VAL    84      -8.967  61.726  44.539  1.00 22.62           C  
ATOM   1353  N   VAL    85      -5.467  59.765  42.311  1.00 19.59           N  
ATOM   1354  CA  VAL    85      -4.526  59.262  41.308  1.00 19.33           C  
ATOM   1355  C   VAL    85      -4.607  57.748  41.150  1.00 19.40           C  
ATOM   1356  O   VAL    85      -4.616  57.261  40.035  1.00 20.61           O  
ATOM   1357  CB  VAL    85      -3.073  59.710  41.615  1.00 19.39           C  
ATOM   1358  CG1 VAL    85      -2.070  59.082  40.659  1.00 17.94           C  
ATOM   1359  CG2 VAL    85      -2.997  61.250  41.539  1.00 21.42           C  
ATOM   1360  N   LEU    86      -4.650  56.998  42.252  1.00 19.33           N  
ATOM   1361  CA  LEU    86      -4.777  55.548  42.161  1.00 19.79           C  
ATOM   1362  C   LEU    86      -6.014  55.159  41.363  1.00 18.98           C  
ATOM   1363  O   LEU    86      -5.940  54.357  40.454  1.00 20.03           O  
ATOM   1364  CB  LEU    86      -4.858  54.924  43.555  1.00 21.20           C  
ATOM   1365  CG  LEU    86      -5.184  53.439  43.651  1.00 21.99           C  
ATOM   1366  CD1 LEU    86      -4.133  52.600  42.959  1.00 24.06           C  
ATOM   1367  CD2 LEU    86      -5.310  53.065  45.156  1.00 20.62           C  
ATOM   1368  N   LEU    87      -7.154  55.734  41.711  1.00 20.94           N  
ATOM   1369  CA  LEU    87      -8.412  55.347  41.065  1.00 21.06           C  
ATOM   1370  C   LEU    87      -8.447  55.701  39.591  1.00 21.01           C  
ATOM   1371  O   LEU    87      -8.981  54.948  38.793  1.00 22.38           O  
ATOM   1372  CB  LEU    87      -9.577  56.046  41.769  1.00 23.55           C  
ATOM   1373  CG  LEU    87     -10.992  55.596  41.405  1.00 25.01           C  
ATOM   1374  CD1 LEU    87     -11.291  54.169  41.742  1.00 30.38           C  
ATOM   1375  CD2 LEU    87     -11.944  56.517  42.180  1.00 27.84           C  
ATOM   1376  N   THR    88      -7.906  56.874  39.258  1.00 21.25           N  
ATOM   1377  CA  THR    88      -7.927  57.375  37.879  1.00 21.88           C  
ATOM   1378  C   THR    88      -6.816  56.833  36.983  1.00 22.77           C  
ATOM   1379  O   THR    88      -6.931  56.837  35.762  1.00 23.28           O  
ATOM   1380  CB  THR    88      -7.874  58.903  37.853  1.00 21.84           C  
ATOM   1381  OG1 THR    88      -6.644  59.350  38.431  1.00 22.90           O  
ATOM   1382  CG2 THR    88      -9.066  59.477  38.541  1.00 25.52           C  
ATOM   1383  N   SER    89      -5.735  56.386  37.602  1.00 20.63           N  
ATOM   1384  CA  SER    89      -4.483  56.227  36.896  1.00 21.58           C  
ATOM   1385  C   SER    89      -3.720  54.942  37.169  1.00 21.03           C  
ATOM   1386  O   SER    89      -2.772  54.629  36.425  1.00 23.05           O  
ATOM   1387  CB  SER    89      -3.575  57.459  37.151  1.00 25.09           C  
ATOM   1388  OG  SER    89      -4.281  58.671  36.880  1.00 24.41           O  
ATOM   1389  N   GLY    90      -4.063  54.215  38.234  1.00 21.98           N  
ATOM   1390  CA  GLY    90      -3.467  52.905  38.482  1.00 20.22           C  
ATOM   1391  C   GLY    90      -2.363  52.897  39.536  1.00 20.13           C  
ATOM   1392  O   GLY    90      -1.942  53.955  40.033  1.00 19.52           O  
ATOM   1393  N   MET    91      -1.913  51.694  39.856  1.00 20.97           N  
ATOM   1394  CA  MET    91      -0.890  51.427  40.886  0.40 24.63           C  
ATOM   1396  C   MET    91       0.459  52.100  40.604  1.00 21.70           C  
ATOM   1397  O   MET    91       1.059  52.724  41.502  1.00 23.86           O  
ATOM   1398  CB  MET    91      -0.619  49.917  41.035  0.40 26.41           C  
ATOM   1400  CG  MET    91      -1.632  49.085  41.765  0.40 29.31           C  
ATOM   1402  SD  MET    91      -0.711  47.905  43.072  0.28 35.75          SE  
ATOM   1404  CE  MET    91      -0.457  49.469  44.218  0.40 21.93           C  
ATOM   1406  N   PRO    92       0.980  51.963  39.373  1.00 21.05           N  
ATOM   1407  CA  PRO    92       2.311  52.563  39.147  1.00 19.88           C  
ATOM   1408  C   PRO    92       2.408  54.050  39.498  1.00 21.02           C  
ATOM   1409  O   PRO    92       3.356  54.485  40.177  1.00 20.96           O  
ATOM   1410  CB  PRO    92       2.572  52.299  37.663  1.00 22.51           C  
ATOM   1411  CG  PRO    92       1.788  51.073  37.374  1.00 20.16           C  
ATOM   1412  CD  PRO    92       0.530  51.210  38.184  1.00 21.39           C  
ATOM   1413  N   ALA    93       1.434  54.836  39.065  1.00 19.14           N  
ATOM   1414  CA  ALA    93       1.460  56.257  39.340  1.00 19.96           C  
ATOM   1415  C   ALA    93       1.300  56.530  40.843  1.00 19.93           C  
ATOM   1416  O   ALA    93       1.977  57.400  41.418  1.00 20.12           O  
ATOM   1417  CB  ALA    93       0.324  56.953  38.551  1.00 22.71           C  
ATOM   1418  N   PHE    94       0.374  55.804  41.457  1.00 18.44           N  
ATOM   1419  CA  PHE    94       0.116  55.937  42.882  1.00 18.79           C  
ATOM   1420  C   PHE    94       1.380  55.638  43.705  1.00 20.05           C  
ATOM   1421  O   PHE    94       1.763  56.426  44.594  1.00 19.06           O  
ATOM   1422  CB  PHE    94      -0.966  54.949  43.301  1.00 20.10           C  
ATOM   1423  CG  PHE    94      -1.232  54.947  44.799  1.00 20.32           C  
ATOM   1424  CD1 PHE    94      -1.802  56.035  45.406  1.00 19.60           C  
ATOM   1425  CD2 PHE    94      -0.904  53.846  45.583  1.00 23.76           C  
ATOM   1426  CE1 PHE    94      -2.066  56.050  46.776  1.00 22.96           C  
ATOM   1427  CE2 PHE    94      -1.154  53.856  46.964  1.00 22.72           C  
ATOM   1428  CZ  PHE    94      -1.722  54.954  47.559  1.00 26.09           C  
ATOM   1429  N   THR    95       2.013  54.508  43.431  1.00 20.55           N  
ATOM   1430  CA  THR    95       3.135  54.077  44.284  1.00 20.94           C  
ATOM   1431  C   THR    95       4.339  55.000  44.073  1.00 20.73           C  
ATOM   1432  O   THR    95       5.018  55.353  45.038  1.00 20.28           O  
ATOM   1433  CB  THR    95       3.494  52.592  44.055  1.00 23.86           C  
ATOM   1434  OG1 THR    95       3.863  52.424  42.701  1.00 24.63           O  
ATOM   1435  CG2 THR    95       2.314  51.685  44.356  1.00 21.43           C  
ATOM   1436  N   LYS    96       4.586  55.442  42.833  1.00 20.08           N  
ATOM   1437  CA  LYS    96       5.679  56.370  42.546  0.50 21.50           C  
ATOM   1439  C   LYS    96       5.460  57.655  43.335  1.00 20.81           C  
ATOM   1440  O   LYS    96       6.378  58.161  43.984  1.00 23.01           O  
ATOM   1441  CB  LYS    96       5.748  56.674  41.040  0.50 23.02           C  
ATOM   1443  CG  LYS    96       6.843  57.658  40.621  0.50 23.87           C  
ATOM   1445  CD  LYS    96       7.014  57.722  39.092  0.50 25.49           C  
ATOM   1447  CE  LYS    96       8.452  58.030  38.704  0.50 32.66           C  
ATOM   1449  NZ  LYS    96       9.333  56.844  38.868  0.50 30.31           N  
ATOM   1451  N   ALA    97       4.244  58.190  43.262  1.00 19.16           N  
ATOM   1452  CA  ALA    97       3.898  59.469  43.921  1.00 19.50           C  
ATOM   1453  C   ALA    97       3.968  59.374  45.441  1.00 20.63           C  
ATOM   1454  O   ALA    97       4.463  60.306  46.135  1.00 20.71           O  
ATOM   1455  CB  ALA    97       2.498  59.945  43.472  1.00 19.41           C  
ATOM   1456  N   MET    98       3.499  58.244  45.974  1.00 19.58           N  
ATOM   1457  CA  MET    98       3.518  58.034  47.406  1.00 20.80           C  
ATOM   1458  C   MET    98       4.949  58.016  47.898  1.00 21.43           C  
ATOM   1459  O   MET    98       5.235  58.574  48.952  1.00 21.18           O  
ATOM   1460  CB  MET    98       2.812  56.740  47.834  1.00 22.05           C  
ATOM   1461  CG  MET    98       1.348  56.831  48.010  1.00 30.57           C  
ATOM   1462  SD  MET    98       0.764  58.016  49.491  0.75 32.27          SE  
ATOM   1463  CE  MET    98       1.937  58.044  50.314  1.00  8.65           C  
ATOM   1464  N   LYS    99       5.840  57.362  47.159  1.00 20.17           N  
ATOM   1465  CA  LYS    99       7.263  57.318  47.526  1.00 20.82           C  
ATOM   1466  C   LYS    99       7.928  58.695  47.534  1.00 21.61           C  
ATOM   1467  O   LYS    99       8.729  59.015  48.429  1.00 22.41           O  
ATOM   1468  CB  LYS    99       8.015  56.361  46.599  1.00 19.98           C  
ATOM   1469  CG  LYS    99       9.522  56.268  46.893  1.00 23.11           C  
ATOM   1470  N   ILE   100       7.602  59.501  46.536  1.00 22.47           N  
ATOM   1471  CA  ILE   100       8.072  60.874  46.456  1.00 23.27           C  
ATOM   1472  C   ILE   100       7.553  61.687  47.656  1.00 24.13           C  
ATOM   1473  O   ILE   100       8.325  62.413  48.299  1.00 23.84           O  
ATOM   1474  CB  ILE   100       7.652  61.544  45.136  1.00 22.91           C  
ATOM   1475  CG1 ILE   100       8.324  60.868  43.926  1.00 22.73           C  
ATOM   1476  CG2 ILE   100       7.973  63.043  45.152  1.00 21.99           C  
ATOM   1477  CD1 ILE   100       7.717  61.279  42.573  1.00 25.00           C  
ATOM   1478  N   LEU   101       6.269  61.540  47.970  1.00 21.64           N  
ATOM   1479  CA  LEU   101       5.660  62.247  49.106  1.00 23.29           C  
ATOM   1480  C   LEU   101       6.347  61.878  50.406  1.00 23.75           C  
ATOM   1481  O   LEU   101       6.624  62.756  51.240  1.00 22.26           O  
ATOM   1482  CB  LEU   101       4.155  61.935  49.207  1.00 22.94           C  
ATOM   1483  CG  LEU   101       3.386  62.589  50.364  1.00 23.09           C  
ATOM   1484  CD1 LEU   101       3.489  64.134  50.332  1.00 23.78           C  
ATOM   1485  CD2 LEU   101       1.946  62.145  50.275  1.00 22.66           C  
ATOM   1486  N   GLU   102       6.611  60.583  50.578  1.00 22.09           N  
ATOM   1487  CA  GLU   102       7.262  60.059  51.770  1.00 27.09           C  
ATOM   1488  C   GLU   102       8.642  60.680  51.965  1.00 25.97           C  
ATOM   1489  O   GLU   102       9.018  61.019  53.083  1.00 27.53           O  
ATOM   1490  CB  GLU   102       7.399  58.543  51.675  1.00 27.36           C  
ATOM   1491  CG  GLU   102       6.073  57.805  51.782  1.00 34.71           C  
ATOM   1492  CD  GLU   102       6.120  56.363  51.242  1.00 36.54           C  
ATOM   1493  OE1 GLU   102       7.234  55.820  51.027  1.00 45.78           O  
ATOM   1494  OE2 GLU   102       5.022  55.775  51.058  1.00 44.93           O  
ATOM   1495  N   LYS   103       9.388  60.834  50.880  1.00 25.11           N  
ATOM   1496  CA  LYS   103      10.773  61.333  50.951  1.00 28.56           C  
ATOM   1497  C   LYS   103      10.847  62.862  51.111  1.00 31.51           C  
ATOM   1498  O   LYS   103      11.911  63.419  51.414  1.00 33.51           O  
ATOM   1499  CB  LYS   103      11.571  60.887  49.714  1.00 29.59           C  
ATOM   1500  CG  LYS   103      11.820  59.386  49.621  1.00 32.01           C  
ATOM   1501  N   LEU   104       9.727  63.543  50.933  1.00 31.51           N  
ATOM   1502  CA  LEU   104       9.711  64.997  51.021  1.00 35.23           C  
ATOM   1503  C   LEU   104       9.855  65.493  52.451  1.00 36.78           C  
ATOM   1504  O   LEU   104       9.406  64.849  53.400  1.00 36.92           O  
ATOM   1505  CB  LEU   104       8.441  65.570  50.389  1.00 34.06           C  
ATOM   1506  CG  LEU   104       8.572  65.835  48.898  1.00 34.04           C  
ATOM   1507  CD1 LEU   104       7.311  66.503  48.411  1.00 34.11           C  
ATOM   1508  CD2 LEU   104       9.796  66.702  48.620  1.00 38.61           C  
ATOM   1509  OXT LEU   104      10.441  66.563  52.661  1.00 40.57           O  
END
