
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  108 (  850),  selected  108 , name 1gmx_A
# Molecule2: number of CA atoms  120 (  935),  selected  120 , name T0411.pdb
# PARAMETERS: 1gmx_A.T0411.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    D     2_A      S      20          6.985
LGA    Q     3_A      N      21          5.547
LGA    F     4_A      I      22          2.767
LGA    E     5_A      Q      23          2.352
LGA    C     6_A      S      24          2.165
LGA    I     7_A      Y      25          1.515
LGA    N     8_A      S      26          1.295
LGA    V     9_A      F      27          2.119
LGA    A    10_A      E      28          1.565
LGA    D    11_A      D      29          0.734
LGA    A    12_A      M      30          1.834
LGA    H    13_A      K      31          2.199
LGA    Q    14_A      R      32          1.017
LGA    K    15_A      I      33          1.592
LGA    L    16_A      V      34          2.308
LGA    Q    17_A      G      35          1.623
LGA    E    18_A      K      36          1.186
LGA    K    19_A      H      37          2.470
LGA    E    20_A      D      38          3.016
LGA    -       -      P      39           -
LGA    -       -      N      40           -
LGA    A    21_A      V      41          1.813
LGA    V    22_A      V      42          1.717
LGA    L    23_A      L      43          0.724
LGA    V    24_A      V      44          1.356
LGA    D    25_A      D      45          0.750
LGA    I    26_A      V      46          0.485
LGA    R    27_A      R      47          0.523
LGA    D    28_A      E      48          1.012
LGA    P    29_A      P      49          1.125
LGA    Q    30_A      S      50          0.992
LGA    S    31_A      E      51          1.047
LGA    F    32_A      Y      52          0.954
LGA    A    33_A      S      53          0.800
LGA    M    34_A      I      54          1.197
LGA    G    35_A      V      55          1.253
LGA    H    36_A      H      56          1.346
LGA    A    37_A      I      57          1.579
LGA    V    38_A      P      58          1.702
LGA    Q    39_A      A      59          1.700
LGA    A    40_A      S      60          1.671
LGA    F    41_A      I      61          0.793
LGA    H    42_A      N      62          0.677
LGA    L    43_A      V      63          1.003
LGA    T    44_A      P      64          2.951
LGA    N    45_A      Y      65           #
LGA    -       -      R      66           -
LGA    -       -      S      67           -
LGA    -       -      H      68           -
LGA    -       -      P      69           -
LGA    -       -      D      70           -
LGA    -       -      A      71           -
LGA    -       -      F      72           -
LGA    -       -      A      73           -
LGA    -       -      L      74           -
LGA    -       -      D      75           -
LGA    -       -      P      76           -
LGA    -       -      L      77           -
LGA    -       -      E      78           -
LGA    -       -      F      79           -
LGA    -       -      E      80           -
LGA    -       -      K      81           -
LGA    D    46_A      Q      82          2.874
LGA    T    47_A      I      83          1.938
LGA    L    48_A      G      84           -
LGA    G    49_A      -       -           -
LGA    A    50_A      I      85          4.006
LGA    F    51_A      P      86          3.699
LGA    M    52_A      K      87          2.193
LGA    R    53_A      -       -           -
LGA    D    54_A      -       -           -
LGA    N    55_A      P      88          2.890
LGA    D    56_A      D      89          1.846
LGA    F    57_A      S      90          1.172
LGA    D    58_A      A      91          1.528
LGA    T    59_A      K      92          0.464
LGA    P    60_A      E      93          0.805
LGA    V    61_A      L      94          1.047
LGA    M    62_A      I      95          0.970
LGA    V    63_A      F      96          1.115
LGA    M    64_A      Y      97          1.641
LGA    X    65_A      C      98          0.317
LGA    Y    66_A      A      99          0.963
LGA    H    67_A      S     100          0.842
LGA    G    68_A      G     101          1.683
LGA    N    69_A      K     102          1.929
LGA    S    70_A      R     103          1.762
LGA    S    71_A      G     104          0.959
LGA    K    72_A      G     105          1.168
LGA    G    73_A      E     106          1.503
LGA    A    74_A      A     107          0.872
LGA    A    75_A      Q     108          0.883
LGA    Q    76_A      K     109          1.542
LGA    Y    77_A      V     110          1.143
LGA    L    78_A      A     111          0.971
LGA    L    79_A      S     112          1.046
LGA    Q    80_A      S     113          1.280
LGA    Q    81_A      H     114          1.573
LGA    G    82_A      G     115          1.202
LGA    Y    83_A      Y     116          1.258
LGA    D    84_A      S     117          1.646
LGA    V    85_A      N     118          1.557
LGA    V    86_A      T     119          1.107
LGA    Y    87_A      S     120          1.297
LGA    S    88_A      L     121          1.369
LGA    I    89_A      Y     122          0.873
LGA    D    90_A      P     123          1.897
LGA    G    91_A      G     124          1.544
LGA    G    92_A      S     125          1.255
LGA    F    93_A      M     126          0.628
LGA    E    94_A      N     127          1.076
LGA    A    95_A      D     128          0.836
LGA    W    96_A      W     129          0.595
LGA    Q    97_A      V     130          1.210
LGA    R    98_A      S     131          2.116
LGA    Q    99_A      H     132          1.978
LGA    F   100_A      G     133          3.328
LGA    -       -      G     134           -
LGA    P   101_A      D     135          2.876
LGA    A   102_A      K     136          0.978
LGA    E   103_A      L     137          3.731
LGA    V   104_A      D     138           -
LGA    A   105_A      L     139           -
LGA    Y   106_A      -       -           -
LGA    G   107_A      -       -           -
LGA    A   108_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  108  120    5.0     97    1.90    15.46     73.681     4.840

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.970806 * X  +  -0.237748 * Y  +  -0.031820 * Z  +  24.729174
  Y_new =   0.202170 * X  +  -0.739610 * Y  +  -0.641954 * Z  +  11.711411
  Z_new =   0.129089 * X  +  -0.629646 * Y  +   0.766082 * Z  +  10.349964 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.687955    2.453638  [ DEG:   -39.4169    140.5831 ]
  Theta =  -0.129451   -3.012142  [ DEG:    -7.4170   -172.5830 ]
  Phi   =   2.936278   -0.205315  [ DEG:   168.2363    -11.7637 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gmx_A                                        
REMARK     2: T0411.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gmx_A.T0411.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  108  120   5.0   97   1.90   15.46  73.681
REMARK  ---------------------------------------------------------- 
MOLECULE 1gmx_A
HEADER    TRANSFERASE                             25-SEP-01   1GMX              
TITLE     ESCHERICHIA COLI GLPE SULFURTRANSFERASE                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLPE PROTEIN;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: BL21(DE3);                                                   
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    RHODANESE, SULFURTRANSFERASE, GLYCEROL METABOLISM                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.SPALLAROSSA,J.T.DONAHUE,T.J.LARSON,M.BOLOGNESI,D.BORDO              
REVDAT   2   01-APR-03 1GMX    1       JRNL                                     
REVDAT   1   28-NOV-01 1GMX    0                                                
JRNL        AUTH   A.SPALLAROSSA,J.L.DONAHUE,T.J.LARSON,M.BOLOGNESI,            
JRNL        AUTH 2 D.BORDO                                                      
JRNL        TITL   ESCHERICHIA COLI GLPE IS A PROTOTYPE                         
JRNL        TITL 2 SULFURTRANSFERASE FOR THE SINGLE-DOMAIN RHODANESE            
JRNL        TITL 3 HOMOLOGY SUPERFAMILY.                                        
JRNL        REF    STRUCTURE                     V.   9  1117 2001              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.10 ANGSTROMS.                                          
DBREF  1GMX A    1   108  UNP    P0A6V5   GLPE_ECOLI       1    108             
SEQRES   1 A  108  MET ASP GLN PHE GLU CYS ILE ASN VAL ALA ASP ALA HIS          
SEQRES   2 A  108  GLN LYS LEU GLN GLU LYS GLU ALA VAL LEU VAL ASP ILE          
SEQRES   3 A  108  ARG ASP PRO GLN SER PHE ALA MET GLY HIS ALA VAL GLN          
SEQRES   4 A  108  ALA PHE HIS LEU THR ASN ASP THR LEU GLY ALA PHE MET          
SEQRES   5 A  108  ARG ASP ASN ASP PHE ASP THR PRO VAL MET VAL MET CSS          
SEQRES   6 A  108  TYR HIS GLY ASN SER SER LYS GLY ALA ALA GLN TYR LEU          
SEQRES   7 A  108  LEU GLN GLN GLY TYR ASP VAL VAL TYR SER ILE ASP GLY          
SEQRES   8 A  108  GLY PHE GLU ALA TRP GLN ARG GLN PHE PRO ALA GLU VAL          
SEQRES   9 A  108  ALA TYR GLY ALA                                              
HET    CSS  A  65       8                                                       
HET    ACT  A1110       4                                                       
HET    ACT  A1111       4                                                       
HET    EDO  A1112       4                                                       
HET    EDO  A1113       4                                                       
HET    EDO  A1114       4                                                       
HET    EDO  A1115       4                                                       
HET    EDO  A1116       4                                                       
HET    EDO  A1117       4                                                       
HET    EDO  A1118       5                                                       
HETNAM     CSS S-MERCAPTOCYSTEINE                                               
HETNAM     ACT ACETATE ION                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  CSS    C3 H7 N O2 S2                                                
FORMUL   2  ACT    2(C2 H3 O2 1-)                                               
FORMUL   4  EDO    7(C2 H6 O2)                                                  
FORMUL  11  HOH   *96(H2 O)                                                     
CRYST1   53.870   53.870   30.523  90.00  90.00 120.00 P 32          3          
ATOM      1  N   MET A   1      20.063  11.930  19.774  1.00 17.49           N  
ATOM      2  CA  MET A   1      20.567  13.156  19.163  1.00 17.38           C  
ATOM      3  C   MET A   1      19.363  13.971  18.704  1.00 17.90           C  
ATOM      4  O   MET A   1      18.236  13.464  18.717  1.00 18.31           O  
ATOM      5  CB  MET A   1      21.543  12.872  18.054  1.00 20.97           C  
ATOM      6  CG  MET A   1      21.013  12.067  16.904  1.00 23.48           C  
ATOM      7  SD  MET A   1      22.221  11.977  15.618  1.00 39.27           S  
ATOM      8  CE  MET A   1      21.816  13.395  14.653  1.00 43.70           C  
ATOM      9  N   ASP A   2      19.632  15.216  18.290  1.00 17.00           N  
ATOM     10  CA  ASP A   2      18.572  16.148  17.923  1.00 18.09           C  
ATOM     11  C   ASP A   2      18.187  16.262  16.484  1.00 16.96           C  
ATOM     12  O   ASP A   2      17.397  17.134  16.097  1.00 20.61           O  
ATOM     13  CB  ASP A   2      18.869  17.505  18.508  1.00 22.70           C  
ATOM     14  CG  ASP A   2      20.075  18.145  17.917  1.00 23.77           C  
ATOM     15  OD1 ASP A   2      20.590  17.671  16.903  1.00 24.32           O  
ATOM     16  OD2 ASP A   2      20.574  19.199  18.343  1.00 33.28           O  
ATOM     17  N   GLN A   3      18.628  15.306  15.655  1.00 17.54           N  
ATOM     18  CA  GLN A   3      18.193  15.238  14.250  1.00 16.23           C  
ATOM     19  C   GLN A   3      17.888  13.738  13.940  1.00 16.29           C  
ATOM     20  O   GLN A   3      18.432  12.861  14.617  1.00 17.60           O  
ATOM     21  CB  GLN A   3      19.278  15.679  13.295  1.00 18.68           C  
ATOM     22  CG  GLN A   3      19.630  17.103  13.424  1.00 20.02           C  
ATOM     23  CD  GLN A   3      20.556  17.588  12.361  1.00 28.36           C  
ATOM     24  OE1 GLN A   3      20.137  17.866  11.219  1.00 34.81           O  
ATOM     25  NE2 GLN A   3      21.818  17.651  12.684  1.00 32.27           N  
ATOM     26  N   PHE A   4      17.054  13.470  12.961  1.00 17.58           N  
ATOM     27  CA  PHE A   4      16.797  12.085  12.458  1.00 16.97           C  
ATOM     28  C   PHE A   4      17.512  11.992  11.119  1.00 19.06           C  
ATOM     29  O   PHE A   4      17.913  13.000  10.492  1.00 23.75           O  
ATOM     30  CB  PHE A   4      15.299  11.760  12.277  1.00 18.00           C  
ATOM     31  CG  PHE A   4      14.678  12.453  11.115  1.00 15.42           C  
ATOM     32  CD1 PHE A   4      14.784  11.935   9.826  1.00 21.28           C  
ATOM     33  CD2 PHE A   4      14.046  13.677  11.265  1.00 19.12           C  
ATOM     34  CE1 PHE A   4      14.300  12.574   8.768  1.00 17.18           C  
ATOM     35  CE2 PHE A   4      13.543  14.339  10.179  1.00 16.26           C  
ATOM     36  CZ  PHE A   4      13.648  13.822   8.968  1.00 24.17           C  
ATOM     37  N   GLU A   5      17.678  10.764  10.714  1.00 17.65           N  
ATOM     38  CA  GLU A   5      18.439  10.474   9.533  1.00 16.38           C  
ATOM     39  C   GLU A   5      17.617   9.656   8.509  1.00 13.28           C  
ATOM     40  O   GLU A   5      16.835   8.795   8.899  1.00 14.29           O  
ATOM     41  CB  GLU A   5      19.687   9.687   9.962  1.00 18.73           C  
ATOM     42  CG  GLU A   5      20.627  10.375  10.918  1.00 26.58           C  
ATOM     43  CD  GLU A   5      21.725   9.419  11.353  1.00 26.62           C  
ATOM     44  OE1 GLU A   5      22.505   8.979  10.507  1.00 43.06           O  
ATOM     45  OE2 GLU A   5      21.796   9.081  12.567  1.00 38.78           O  
ATOM     46  N   CYS A   6      17.874   9.887   7.243  1.00 12.44           N  
ATOM     47  CA  CYS A   6      17.286   9.082   6.203  1.00 11.66           C  
ATOM     48  C   CYS A   6      18.135   7.895   5.867  1.00 12.15           C  
ATOM     49  O   CYS A   6      19.350   8.107   5.630  1.00 14.47           O  
ATOM     50  CB  CYS A   6      17.083   9.896   4.949  1.00 13.70           C  
ATOM     51  SG  CYS A   6      15.834  11.200   5.175  1.00 16.63           S  
ATOM     52  N   ILE A   7      17.578   6.701   5.784  1.00 10.27           N  
ATOM     53  CA  ILE A   7      18.308   5.486   5.463  1.00 10.10           C  
ATOM     54  C   ILE A   7      17.597   4.737   4.348  1.00  9.81           C  
ATOM     55  O   ILE A   7      16.381   4.884   4.154  1.00 10.59           O  
ATOM     56  CB  ILE A   7      18.514   4.586   6.662  1.00 10.32           C  
ATOM     57  CG1 ILE A   7      17.185   4.057   7.229  1.00 10.93           C  
ATOM     58  CG2 ILE A   7      19.329   5.266   7.718  1.00 12.68           C  
ATOM     59  CD1 ILE A   7      17.365   3.081   8.357  1.00 11.72           C  
ATOM     60  N   ASN A   8      18.328   3.909   3.620  1.00 10.17           N  
ATOM     61  CA  ASN A   8      17.764   3.086   2.598  1.00 10.09           C  
ATOM     62  C   ASN A   8      17.295   1.738   3.192  1.00 10.06           C  
ATOM     63  O   ASN A   8      17.590   1.395   4.323  1.00  9.75           O  
ATOM     64  CB  ASN A   8      18.729   2.901   1.413  1.00 11.18           C  
ATOM     65  CG  ASN A   8      19.953   2.142   1.805  1.00 11.29           C  
ATOM     66  OD1 ASN A   8      19.830   1.003   2.197  1.00 13.01           O  
ATOM     67  ND2 ASN A   8      21.133   2.729   1.732  1.00 13.23           N  
ATOM     68  N   VAL A   9      16.533   0.997   2.377  1.00 10.23           N  
ATOM     69  CA  VAL A   9      15.975  -0.236   2.870  1.00 10.36           C  
ATOM     70  C   VAL A   9      17.000  -1.321   3.156  1.00 10.87           C  
ATOM     71  O   VAL A   9      16.761  -2.171   4.013  1.00 11.00           O  
ATOM     72  CB  VAL A   9      14.852  -0.811   1.947  1.00 11.64           C  
ATOM     73  CG1 VAL A   9      13.620   0.098   1.992  1.00 12.75           C  
ATOM     74  CG2 VAL A   9      15.296  -1.023   0.531  1.00 13.33           C  
ATOM     75  N   ALA A  10      18.138  -1.329   2.425  1.00 10.65           N  
ATOM     76  CA  ALA A  10      19.155  -2.344   2.731  1.00 11.19           C  
ATOM     77  C   ALA A  10      19.749  -2.103   4.124  1.00  9.97           C  
ATOM     78  O   ALA A  10      19.965  -3.030   4.892  1.00 10.58           O  
ATOM     79  CB  ALA A  10      20.229  -2.322   1.659  1.00 12.04           C  
ATOM     80  N   ASP A  11      20.025  -0.842   4.428  1.00 10.05           N  
ATOM     81  CA  ASP A  11      20.524  -0.463   5.733  1.00  9.72           C  
ATOM     82  C   ASP A  11      19.485  -0.807   6.807  1.00  9.58           C  
ATOM     83  O   ASP A  11      19.776  -1.432   7.827  1.00 10.08           O  
ATOM     84  CB  ASP A  11      20.898   1.034   5.668  1.00 10.00           C  
ATOM     85  CG  ASP A  11      21.580   1.573   6.888  1.00 10.25           C  
ATOM     86  OD1 ASP A  11      21.850   0.861   7.851  1.00 11.87           O  
ATOM     87  OD2 ASP A  11      21.909   2.800   6.855  1.00 10.81           O  
ATOM     88  N   ALA A  12      18.229  -0.410   6.577  1.00 10.20           N  
ATOM     89  CA  ALA A  12      17.154  -0.706   7.534  1.00 10.85           C  
ATOM     90  C   ALA A  12      17.029  -2.208   7.774  1.00 10.80           C  
ATOM     91  O   ALA A  12      16.858  -2.667   8.909  1.00 11.68           O  
ATOM     92  CB  ALA A  12      15.831  -0.143   7.008  1.00 11.81           C  
ATOM     93  N   HIS A  13      17.074  -2.994   6.705  1.00 11.04           N  
ATOM     94  CA  HIS A  13      16.967  -4.440   6.826  1.00 11.73           C  
ATOM     95  C   HIS A  13      18.085  -5.017   7.691  1.00 11.49           C  
ATOM     96  O   HIS A  13      17.851  -5.923   8.495  1.00 12.45           O  
ATOM     97  CB  HIS A  13      16.954  -5.041   5.434  1.00 12.89           C  
ATOM     98  CG  HIS A  13      16.863  -6.535   5.337  1.00 14.69           C  
ATOM     99  ND1 HIS A  13      17.969  -7.357   5.373  1.00 21.79           N  
ATOM    100  CD2 HIS A  13      15.811  -7.369   5.178  1.00 16.80           C  
ATOM    101  CE1 HIS A  13      17.617  -8.612   5.178  1.00 21.95           C  
ATOM    102  NE2 HIS A  13      16.303  -8.650   5.088  1.00 18.32           N  
ATOM    103  N   GLN A  14      19.295  -4.514   7.523  1.00 11.07           N  
ATOM    104  CA  GLN A  14      20.426  -4.978   8.297  1.00 11.66           C  
ATOM    105  C   GLN A  14      20.252  -4.630   9.790  1.00 11.75           C  
ATOM    106  O   GLN A  14      20.502  -5.469  10.668  1.00 13.38           O  
ATOM    107  CB  GLN A  14      21.700  -4.370   7.743  1.00 11.83           C  
ATOM    108  CG  GLN A  14      22.942  -4.913   8.329  1.00 14.47           C  
ATOM    109  CD  GLN A  14      24.124  -4.402   7.496  1.00 15.12           C  
ATOM    110  OE1 GLN A  14      24.293  -3.187   7.386  1.00 15.10           O  
ATOM    111  NE2 GLN A  14      24.860  -5.287   6.814  1.00 18.40           N  
ATOM    112  N   LYS A  15      19.819  -3.399  10.080  1.00 12.07           N  
ATOM    113  CA  LYS A  15      19.569  -3.026  11.455  1.00 12.45           C  
ATOM    114  C   LYS A  15      18.517  -3.903  12.096  1.00 13.59           C  
ATOM    115  O   LYS A  15      18.632  -4.313  13.238  1.00 15.43           O  
ATOM    116  CB  LYS A  15      19.140  -1.577  11.531  1.00 13.12           C  
ATOM    117  CG  LYS A  15      20.198  -0.531  11.179  1.00 13.47           C  
ATOM    118  CD  LYS A  15      19.619   0.886  11.280  1.00 14.94           C  
ATOM    119  CE  LYS A  15      20.518   2.087  10.867  1.00 14.81           C  
ATOM    120  NZ  LYS A  15      21.605   2.343  11.833  1.00 16.20           N  
ATOM    121  N   LEU A  16      17.502  -4.236  11.332  1.00 14.71           N  
ATOM    122  CA  LEU A  16      16.446  -5.075  11.827  1.00 17.31           C  
ATOM    123  C   LEU A  16      16.960  -6.479  12.109  1.00 19.09           C  
ATOM    124  O   LEU A  16      16.689  -7.072  13.158  1.00 21.12           O  
ATOM    125  CB  LEU A  16      15.234  -5.032  10.878  1.00 20.53           C  
ATOM    126  CG  LEU A  16      13.925  -5.617  11.297  1.00 18.25           C  
ATOM    127  CD1 LEU A  16      13.408  -4.768  12.391  1.00 18.79           C  
ATOM    128  CD2 LEU A  16      13.061  -5.576  10.089  1.00 21.43           C  
ATOM    129  N   GLN A  17      17.704  -7.035  11.158  1.00 18.05           N  
ATOM    130  CA  GLN A  17      18.214  -8.368  11.314  1.00 19.10           C  
ATOM    131  C   GLN A  17      19.123  -8.508  12.527  1.00 19.44           C  
ATOM    132  O   GLN A  17      19.124  -9.531  13.186  1.00 22.08           O  
ATOM    133  CB  GLN A  17      18.916  -8.771  10.045  1.00 21.43           C  
ATOM    134  CG  GLN A  17      19.165 -10.232   9.984  1.00 28.97           C  
ATOM    135  CD  GLN A  17      20.525 -10.595  10.514  1.00 36.93           C  
ATOM    136  OE1 GLN A  17      21.421  -9.750  10.582  1.00 39.99           O  
ATOM    137  NE2 GLN A  17      20.692 -11.860  10.894  1.00 47.20           N  
ATOM    138  N   GLU A  18      19.889  -7.465  12.797  1.00 16.93           N  
ATOM    139  CA  GLU A  18      20.758  -7.414  13.937  1.00 17.52           C  
ATOM    140  C   GLU A  18      20.105  -7.088  15.254  1.00 18.20           C  
ATOM    141  O   GLU A  18      20.746  -7.061  16.306  1.00 19.78           O  
ATOM    142  CB  GLU A  18      21.827  -6.390  13.665  1.00 17.65           C  
ATOM    143  CG  GLU A  18      22.722  -6.784  12.521  1.00 18.39           C  
ATOM    144  CD  GLU A  18      23.703  -5.720  12.167  1.00 19.94           C  
ATOM    145  OE1 GLU A  18      23.540  -4.529  12.524  1.00 25.52           O  
ATOM    146  OE2 GLU A  18      24.639  -6.060  11.421  1.00 25.33           O  
ATOM    147  N   LYS A  19      18.806  -6.851  15.171  1.00 17.01           N  
ATOM    148  CA  LYS A  19      18.026  -6.511  16.355  1.00 18.43           C  
ATOM    149  C   LYS A  19      18.514  -5.213  16.978  1.00 16.98           C  
ATOM    150  O   LYS A  19      18.382  -5.007  18.192  1.00 20.18           O  
ATOM    151  CB  LYS A  19      18.087  -7.683  17.355  1.00 20.86           C  
ATOM    152  CG  LYS A  19      17.658  -9.045  16.785  1.00 22.26           C  
ATOM    153  CD  LYS A  19      17.631 -10.143  17.816  1.00 25.85           C  
ATOM    154  CE  LYS A  19      17.098 -11.417  17.221  1.00 26.79           C  
ATOM    155  NZ  LYS A  19      16.957 -12.465  18.257  1.00 33.24           N  
ATOM    156  N   GLU A  20      18.947  -4.277  16.136  1.00 15.72           N  
ATOM    157  CA  GLU A  20      19.454  -3.001  16.599  1.00 15.48           C  
ATOM    158  C   GLU A  20      18.388  -1.941  16.699  1.00 14.27           C  
ATOM    159  O   GLU A  20      18.523  -0.972  17.415  1.00 16.25           O  
ATOM    160  CB  GLU A  20      20.551  -2.467  15.642  1.00 17.96           C  
ATOM    161  CG  GLU A  20      21.870  -3.126  15.787  1.00 24.07           C  
ATOM    162  CD  GLU A  20      22.819  -2.508  14.748  1.00 24.77           C  
ATOM    163  OE1 GLU A  20      22.398  -1.788  13.791  1.00 31.43           O  
ATOM    164  OE2 GLU A  20      23.989  -2.788  14.792  1.00 29.67           O  
ATOM    165  N   ALA A  21      17.331  -2.064  15.908  1.00 13.16           N  
ATOM    166  CA  ALA A  21      16.301  -1.039  15.766  1.00 12.11           C  
ATOM    167  C   ALA A  21      14.964  -1.737  15.607  1.00 11.76           C  
ATOM    168  O   ALA A  21      14.904  -2.877  15.157  1.00 13.86           O  
ATOM    169  CB  ALA A  21      16.570  -0.128  14.601  1.00 12.41           C  
ATOM    170  N   VAL A  22      13.902  -0.994  15.934  1.00 10.70           N  
ATOM    171  CA  VAL A  22      12.538  -1.436  15.672  1.00 10.31           C  
ATOM    172  C   VAL A  22      12.014  -0.706  14.442  1.00 10.27           C  
ATOM    173  O   VAL A  22      12.514   0.348  14.076  1.00 11.60           O  
ATOM    174  CB  VAL A  22      11.620  -1.256  16.861  1.00 12.06           C  
ATOM    175  CG1 VAL A  22      12.184  -2.019  18.089  1.00 14.95           C  
ATOM    176  CG2 VAL A  22      11.380   0.152  17.207  1.00 12.85           C  
ATOM    177  N   LEU A  23      11.069  -1.323  13.775  1.00 10.06           N  
ATOM    178  CA  LEU A  23      10.472  -0.807  12.573  1.00 10.07           C  
ATOM    179  C   LEU A  23       9.004  -0.469  12.815  1.00 10.41           C  
ATOM    180  O   LEU A  23       8.249  -1.319  13.295  1.00 11.55           O  
ATOM    181  CB  LEU A  23      10.569  -1.854  11.464  1.00 10.32           C  
ATOM    182  CG  LEU A  23       9.920  -1.502  10.154  1.00 11.96           C  
ATOM    183  CD1 LEU A  23      10.513  -0.294   9.567  1.00 12.64           C  
ATOM    184  CD2 LEU A  23       9.975  -2.667   9.211  1.00 14.19           C  
ATOM    185  N   VAL A  24       8.610   0.735  12.466  1.00  9.67           N  
ATOM    186  CA  VAL A  24       7.214   1.177  12.535  1.00  9.91           C  
ATOM    187  C   VAL A  24       6.784   1.578  11.143  1.00  9.70           C  
ATOM    188  O   VAL A  24       7.555   2.095  10.333  1.00 10.84           O  
ATOM    189  CB  VAL A  24       6.978   2.310  13.556  1.00 10.50           C  
ATOM    190  CG1 VAL A  24       7.418   1.854  14.946  1.00 11.82           C  
ATOM    191  CG2 VAL A  24       7.676   3.595  13.192  1.00 11.16           C  
ATOM    192  N   ASP A  25       5.491   1.327  10.875  1.00  9.34           N  
ATOM    193  CA  ASP A  25       4.838   1.617   9.597  1.00  9.29           C  
ATOM    194  C   ASP A  25       3.651   2.515   9.891  1.00  9.14           C  
ATOM    195  O   ASP A  25       2.790   2.135  10.677  1.00 10.11           O  
ATOM    196  CB  ASP A  25       4.435   0.302   8.949  1.00  9.53           C  
ATOM    197  CG  ASP A  25       3.826   0.391   7.568  1.00  9.84           C  
ATOM    198  OD1 ASP A  25       3.205   1.398   7.217  1.00 10.29           O  
ATOM    199  OD2 ASP A  25       3.999  -0.617   6.840  1.00 10.72           O  
ATOM    200  N   ILE A  26       3.652   3.699   9.320  1.00  9.16           N  
ATOM    201  CA  ILE A  26       2.663   4.744   9.592  1.00  9.75           C  
ATOM    202  C   ILE A  26       1.596   4.854   8.510  1.00 10.73           C  
ATOM    203  O   ILE A  26       0.828   5.797   8.521  1.00 13.48           O  
ATOM    204  CB  ILE A  26       3.333   6.097   9.837  1.00  9.98           C  
ATOM    205  CG1 ILE A  26       4.058   6.619   8.597  1.00 10.13           C  
ATOM    206  CG2 ILE A  26       4.260   6.016  11.050  1.00 10.42           C  
ATOM    207  CD1 ILE A  26       4.572   8.044   8.729  1.00 10.58           C  
ATOM    208  N   ARG A  27       1.548   3.887   7.594  1.00 10.32           N  
ATOM    209  CA  ARG A  27       0.499   3.906   6.593  1.00 10.23           C  
ATOM    210  C   ARG A  27      -0.851   3.575   7.177  1.00 11.47           C  
ATOM    211  O   ARG A  27      -0.982   3.058   8.266  1.00 11.76           O  
ATOM    212  CB  ARG A  27       0.840   2.949   5.451  1.00 10.46           C  
ATOM    213  CG  ARG A  27       2.105   3.306   4.713  1.00 10.48           C  
ATOM    214  CD  ARG A  27       2.470   2.275   3.648  1.00 10.50           C  
ATOM    215  NE  ARG A  27       2.741   1.004   4.298  1.00 10.31           N  
ATOM    216  CZ  ARG A  27       2.461  -0.188   3.772  1.00 10.10           C  
ATOM    217  NH1 ARG A  27       1.994  -0.283   2.535  1.00 10.91           N  
ATOM    218  NH2 ARG A  27       2.633  -1.267   4.506  1.00 10.41           N  
ATOM    219  N   ASP A  28      -1.899   3.852   6.391  1.00 12.26           N  
ATOM    220  CA  ASP A  28      -3.266   3.541   6.747  1.00 13.51           C  
ATOM    221  C   ASP A  28      -3.417   2.017   6.970  1.00 13.27           C  
ATOM    222  O   ASP A  28      -2.666   1.219   6.429  1.00 13.79           O  
ATOM    223  CB  ASP A  28      -4.232   4.053   5.651  1.00 14.90           C  
ATOM    224  CG  ASP A  28      -4.111   3.248   4.377  1.00 14.89           C  
ATOM    225  OD1 ASP A  28      -3.289   3.602   3.467  1.00 15.48           O  
ATOM    226  OD2 ASP A  28      -4.850   2.268   4.264  1.00 15.51           O  
ATOM    227  N   PRO A  29      -4.399   1.607   7.767  1.00 14.32           N  
ATOM    228  CA  PRO A  29      -4.511   0.180   8.131  1.00 14.80           C  
ATOM    229  C   PRO A  29      -4.814  -0.735   6.958  1.00 13.59           C  
ATOM    230  O   PRO A  29      -4.394  -1.892   6.962  1.00 13.56           O  
ATOM    231  CB  PRO A  29      -5.680   0.147   9.116  1.00 17.05           C  
ATOM    232  CG  PRO A  29      -6.238   1.423   9.098  1.00 19.04           C  
ATOM    233  CD  PRO A  29      -5.340   2.466   8.523  1.00 16.07           C  
ATOM    234  N   GLN A  30      -5.551  -0.232   5.980  1.00 14.05           N  
ATOM    235  CA  GLN A  30      -5.842  -1.057   4.811  1.00 13.38           C  
ATOM    236  C   GLN A  30      -4.588  -1.340   4.010  1.00 13.54           C  
ATOM    237  O   GLN A  30      -4.334  -2.484   3.654  1.00 12.95           O  
ATOM    238  CB  GLN A  30      -6.896  -0.386   3.907  1.00 14.96           C  
ATOM    239  CG  GLN A  30      -8.296  -0.327   4.473  1.00 18.11           C  
ATOM    240  CD  GLN A  30      -9.171   0.591   3.552  1.00 17.49           C  
ATOM    241  OE1 GLN A  30      -9.621   0.133   2.468  1.00 21.82           O  
ATOM    242  NE2 GLN A  30      -9.460   1.801   3.985  1.00 18.28           N  
ATOM    243  N   SER A  31      -3.779  -0.324   3.760  1.00 12.99           N  
ATOM    244  CA  SER A  31      -2.512  -0.521   3.056  1.00 12.62           C  
ATOM    245  C   SER A  31      -1.594  -1.406   3.874  1.00 12.18           C  
ATOM    246  O   SER A  31      -0.946  -2.307   3.339  1.00 11.76           O  
ATOM    247  CB  SER A  31      -1.810   0.812   2.793  1.00 13.80           C  
ATOM    248  OG  SER A  31      -2.526   1.626   1.854  1.00 15.01           O  
ATOM    249  N   PHE A  32      -1.552  -1.211   5.196  1.00 11.43           N  
ATOM    250  CA  PHE A  32      -0.730  -2.063   6.063  1.00 11.34           C  
ATOM    251  C   PHE A  32      -1.130  -3.523   5.920  1.00 11.02           C  
ATOM    252  O   PHE A  32      -0.276  -4.422   5.753  1.00 11.38           O  
ATOM    253  CB  PHE A  32      -0.853  -1.609   7.536  1.00 12.02           C  
ATOM    254  CG  PHE A  32       0.033  -2.365   8.494  1.00 11.47           C  
ATOM    255  CD1 PHE A  32       1.359  -1.982   8.695  1.00 12.01           C  
ATOM    256  CD2 PHE A  32      -0.460  -3.415   9.238  1.00 12.61           C  
ATOM    257  CE1 PHE A  32       2.162  -2.680   9.546  1.00 11.85           C  
ATOM    258  CE2 PHE A  32       0.330  -4.135  10.127  1.00 13.55           C  
ATOM    259  CZ  PHE A  32       1.669  -3.741  10.295  1.00 12.65           C  
ATOM    260  N   ALA A  33      -2.429  -3.794   5.936  1.00 11.08           N  
ATOM    261  CA  ALA A  33      -2.893  -5.177   5.849  1.00 11.57           C  
ATOM    262  C   ALA A  33      -2.629  -5.778   4.470  1.00 11.73           C  
ATOM    263  O   ALA A  33      -2.452  -6.980   4.349  1.00 11.90           O  
ATOM    264  CB  ALA A  33      -4.371  -5.242   6.199  1.00 11.91           C  
ATOM    265  N   MET A  34      -2.637  -4.943   3.426  1.00 11.65           N  
ATOM    266  CA  MET A  34      -2.336  -5.427   2.091  1.00 11.52           C  
ATOM    267  C   MET A  34      -0.888  -5.889   1.927  1.00 12.03           C  
ATOM    268  O   MET A  34      -0.574  -6.581   0.978  1.00 15.17           O  
ATOM    269  CB  MET A  34      -2.653  -4.368   1.103  1.00 12.89           C  
ATOM    270  CG  MET A  34      -4.117  -4.106   0.807  1.00 16.63           C  
ATOM    271  SD  MET A  34      -4.915  -5.494  -0.006  1.00 16.41           S  
ATOM    272  CE  MET A  34      -4.304  -5.474  -1.573  1.00 21.58           C  
ATOM    273  N   GLY A  35      -0.016  -5.502   2.805  1.00 11.54           N  
ATOM    274  CA  GLY A  35       1.354  -5.952   2.786  1.00 11.95           C  
ATOM    275  C   GLY A  35       2.231  -4.980   3.537  1.00 10.48           C  
ATOM    276  O   GLY A  35       2.183  -3.777   3.263  1.00 10.57           O  
ATOM    277  N   HIS A  36       3.034  -5.483   4.460  1.00 10.64           N  
ATOM    278  CA  HIS A  36       3.956  -4.663   5.224  1.00 10.33           C  
ATOM    279  C   HIS A  36       5.222  -5.465   5.475  1.00 11.17           C  
ATOM    280  O   HIS A  36       5.224  -6.700   5.340  1.00 12.52           O  
ATOM    281  CB  HIS A  36       3.313  -4.187   6.545  1.00 10.82           C  
ATOM    282  CG  HIS A  36       2.846  -5.311   7.411  1.00 11.24           C  
ATOM    283  ND1 HIS A  36       1.546  -5.779   7.407  1.00 12.45           N  
ATOM    284  CD2 HIS A  36       3.515  -6.076   8.297  1.00 11.91           C  
ATOM    285  CE1 HIS A  36       1.462  -6.775   8.279  1.00 12.52           C  
ATOM    286  NE2 HIS A  36       2.623  -6.930   8.873  1.00 14.21           N  
ATOM    287  N   ALA A  37       6.289  -4.790   5.850  1.00 11.72           N  
ATOM    288  CA  ALA A  37       7.499  -5.497   6.196  1.00 13.35           C  
ATOM    289  C   ALA A  37       7.278  -6.356   7.397  1.00 13.64           C  
ATOM    290  O   ALA A  37       6.593  -5.970   8.386  1.00 13.29           O  
ATOM    291  CB  ALA A  37       8.615  -4.524   6.519  1.00 14.66           C  
ATOM    292  N   VAL A  38       7.913  -7.527   7.355  0.50 15.07           N  
ATOM    294  CA  VAL A  38       7.971  -8.379   8.508  1.00 17.80           C  
ATOM    295  C   VAL A  38       8.517  -7.522   9.724  0.50  9.91           C  
ATOM    297  O   VAL A  38       9.457  -6.733   9.644  0.50 13.84           O  
ATOM    299  CB  VAL A  38       8.879  -9.652   8.246  1.00 21.26           C  
ATOM    300  CG1 VAL A  38       8.954 -10.507   9.420  1.00 27.67           C  
ATOM    301  CG2 VAL A  38       8.193 -10.490   7.155  1.00 24.55           C  
ATOM    302  N   GLN A  39       7.882  -7.753  10.821  0.80 15.30           N  
ATOM    304  CA  GLN A  39       8.216  -7.172  12.066  0.80 17.28           C  
ATOM    306  C   GLN A  39       7.835  -5.717  12.166  0.80 15.00           C  
ATOM    308  O   GLN A  39       8.087  -5.123  13.194  0.80 18.22           O  
ATOM    310  CB  GLN A  39       9.676  -7.350  12.476  0.80 20.37           C  
ATOM    312  CG  GLN A  39      10.022  -8.772  12.744  0.80 24.61           C  
ATOM    314  CD  GLN A  39      11.471  -8.955  13.127  0.80 26.59           C  
ATOM    316  OE1 GLN A  39      12.071  -8.110  13.791  0.80 25.38           O  
ATOM    318  NE2 GLN A  39      12.032 -10.088  12.745  0.80 34.30           N  
ATOM    320  N   ALA A  40       7.208  -5.112  11.156  1.00 11.88           N  
ATOM    321  CA  ALA A  40       6.730  -3.743  11.331  1.00 11.33           C  
ATOM    322  C   ALA A  40       5.581  -3.657  12.331  1.00 11.82           C  
ATOM    323  O   ALA A  40       4.624  -4.444  12.283  1.00 14.59           O  
ATOM    324  CB  ALA A  40       6.274  -3.160  10.012  1.00 11.47           C  
ATOM    325  N   PHE A  41       5.659  -2.683  13.201  1.00 12.83           N  
ATOM    326  CA  PHE A  41       4.571  -2.299  14.095  1.00 12.77           C  
ATOM    327  C   PHE A  41       3.780  -1.195  13.433  1.00 12.29           C  
ATOM    328  O   PHE A  41       4.339  -0.206  12.964  1.00 12.23           O  
ATOM    329  CB  PHE A  41       5.162  -1.812  15.423  1.00 14.36           C  
ATOM    330  CG  PHE A  41       4.147  -1.309  16.416  1.00 14.97           C  
ATOM    331  CD1 PHE A  41       3.567  -2.195  17.278  1.00 22.19           C  
ATOM    332  CD2 PHE A  41       3.792   0.012  16.497  1.00 12.78           C  
ATOM    333  CE1 PHE A  41       2.666  -1.740  18.199  1.00 23.74           C  
ATOM    334  CE2 PHE A  41       2.876   0.459  17.412  1.00 14.23           C  
ATOM    335  CZ  PHE A  41       2.319  -0.411  18.273  1.00 20.09           C  
ATOM    336  N   HIS A  42       2.473  -1.344  13.414  1.00 12.98           N  
ATOM    337  CA  HIS A  42       1.627  -0.345  12.837  1.00 12.50           C  
ATOM    338  C   HIS A  42       1.432   0.809  13.836  1.00 11.21           C  
ATOM    339  O   HIS A  42       0.732   0.679  14.835  1.00 12.86           O  
ATOM    340  CB  HIS A  42       0.277  -0.964  12.493  1.00 15.99           C  
ATOM    341  CG  HIS A  42      -0.565  -0.027  11.746  1.00 16.09           C  
ATOM    342  ND1 HIS A  42      -1.898   0.188  12.054  1.00 20.44           N  
ATOM    343  CD2 HIS A  42      -0.261   0.820  10.765  1.00 15.65           C  
ATOM    344  CE1 HIS A  42      -2.349   1.151  11.274  1.00 20.97           C  
ATOM    345  NE2 HIS A  42      -1.421   1.446  10.397  1.00 19.74           N  
ATOM    346  N   LEU A  43       2.050   1.938  13.534  1.00 10.98           N  
ATOM    347  CA  LEU A  43       2.104   3.087  14.422  1.00 11.01           C  
ATOM    348  C   LEU A  43       1.174   4.157  13.917  1.00 11.88           C  
ATOM    349  O   LEU A  43       1.399   4.731  12.838  1.00 12.28           O  
ATOM    350  CB  LEU A  43       3.518   3.615  14.512  1.00 10.79           C  
ATOM    351  CG  LEU A  43       3.684   4.817  15.438  1.00 11.55           C  
ATOM    352  CD1 LEU A  43       3.318   4.476  16.857  1.00 12.87           C  
ATOM    353  CD2 LEU A  43       5.104   5.369  15.402  1.00 12.98           C  
ATOM    354  N   THR A  44       0.151   4.455  14.723  1.00 14.81           N  
ATOM    355  CA  THR A  44      -0.775   5.525  14.461  1.00 17.73           C  
ATOM    356  C   THR A  44      -0.868   6.394  15.695  1.00 19.66           C  
ATOM    357  O   THR A  44      -0.390   6.021  16.759  1.00 18.05           O  
ATOM    358  CB  THR A  44      -2.155   4.980  14.194  1.00 20.64           C  
ATOM    359  OG1 THR A  44      -2.655   4.406  15.427  1.00 19.20           O  
ATOM    360  CG2 THR A  44      -2.058   3.919  13.145  1.00 23.47           C  
ATOM    361  N   ASN A  45      -1.576   7.506  15.599  1.00 21.76           N  
ATOM    362  CA  ASN A  45      -1.740   8.322  16.804  1.00 23.34           C  
ATOM    363  C   ASN A  45      -2.428   7.550  17.953  1.00 22.41           C  
ATOM    364  O   ASN A  45      -2.127   7.747  19.134  1.00 25.38           O  
ATOM    365  CB  ASN A  45      -2.513   9.580  16.434  1.00 27.48           C  
ATOM    366  CG  ASN A  45      -2.801  10.463  17.616  1.00 37.53           C  
ATOM    367  OD1 ASN A  45      -2.338  10.210  18.739  1.00 48.19           O  
ATOM    368  ND2 ASN A  45      -3.585  11.509  17.387  1.00 48.56           N  
ATOM    369  N   ASP A  46      -3.324   6.644  17.594  1.00 19.84           N  
ATOM    370  CA  ASP A  46      -3.937   5.785  18.589  1.00 18.24           C  
ATOM    371  C   ASP A  46      -3.023   4.739  19.184  1.00 17.89           C  
ATOM    372  O   ASP A  46      -3.183   4.457  20.382  1.00 21.17           O  
ATOM    373  CB  ASP A  46      -5.115   5.062  17.996  1.00 19.05           C  
ATOM    374  CG  ASP A  46      -6.372   5.871  17.956  1.00 22.97           C  
ATOM    375  OD1 ASP A  46      -6.433   6.968  18.535  1.00 26.68           O  
ATOM    376  OD2 ASP A  46      -7.324   5.438  17.320  1.00 24.54           O  
ATOM    377  N   THR A  47      -2.125   4.141  18.385  1.00 13.94           N  
ATOM    378  CA  THR A  47      -1.232   3.127  18.928  1.00 12.68           C  
ATOM    379  C   THR A  47       0.022   3.754  19.537  1.00 12.71           C  
ATOM    380  O   THR A  47       0.830   3.050  20.131  1.00 12.98           O  
ATOM    381  CB  THR A  47      -0.879   2.005  17.973  1.00 12.56           C  
ATOM    382  OG1 THR A  47      -0.088   2.552  16.912  1.00 11.95           O  
ATOM    383  CG2 THR A  47      -2.127   1.336  17.401  1.00 14.51           C  
ATOM    384  N   LEU A  48       0.189   5.088  19.421  1.00 14.44           N  
ATOM    385  CA  LEU A  48       1.384   5.757  19.914  1.00 15.22           C  
ATOM    386  C   LEU A  48       1.570   5.632  21.407  1.00 14.59           C  
ATOM    387  O   LEU A  48       2.689   5.431  21.882  1.00 17.05           O  
ATOM    388  CB  LEU A  48       1.386   7.225  19.533  1.00 18.80           C  
ATOM    389  CG  LEU A  48       2.573   8.057  20.033  1.00 20.30           C  
ATOM    390  CD1 LEU A  48       3.907   7.598  19.465  1.00 18.67           C  
ATOM    391  CD2 LEU A  48       2.328   9.521  19.644  1.00 26.33           C  
ATOM    392  N   GLY A  49       0.448   5.718  22.136  1.00 17.01           N  
ATOM    393  CA  GLY A  49       0.579   5.663  23.565  1.00 18.30           C  
ATOM    394  C   GLY A  49       1.170   4.326  24.001  1.00 16.98           C  
ATOM    395  O   GLY A  49       2.121   4.259  24.794  1.00 19.03           O  
ATOM    396  N   ALA A  50       0.642   3.228  23.443  1.00 15.95           N  
ATOM    397  CA  ALA A  50       1.210   1.916  23.691  1.00 15.50           C  
ATOM    398  C   ALA A  50       2.642   1.802  23.226  1.00 14.98           C  
ATOM    399  O   ALA A  50       3.489   1.258  23.931  1.00 17.17           O  
ATOM    400  CB  ALA A  50       0.364   0.824  23.051  1.00 15.50           C  
ATOM    401  N   PHE A  51       2.933   2.305  22.039  1.00 13.49           N  
ATOM    402  CA  PHE A  51       4.295   2.243  21.531  1.00 13.48           C  
ATOM    403  C   PHE A  51       5.290   2.904  22.536  1.00 14.08           C  
ATOM    404  O   PHE A  51       6.380   2.380  22.769  1.00 14.90           O  
ATOM    405  CB  PHE A  51       4.355   2.946  20.178  1.00 12.62           C  
ATOM    406  CG  PHE A  51       5.734   2.870  19.562  1.00 12.48           C  
ATOM    407  CD1 PHE A  51       6.157   1.739  18.906  1.00 12.54           C  
ATOM    408  CD2 PHE A  51       6.629   3.898  19.717  1.00 15.18           C  
ATOM    409  CE1 PHE A  51       7.449   1.646  18.378  1.00 13.92           C  
ATOM    410  CE2 PHE A  51       7.934   3.804  19.172  1.00 14.63           C  
ATOM    411  CZ  PHE A  51       8.311   2.651  18.517  1.00 13.92           C  
ATOM    412  N   MET A  52       4.944   4.060  23.031  1.00 15.04           N  
ATOM    413  CA  MET A  52       5.841   4.795  23.910  1.00 16.16           C  
ATOM    414  C   MET A  52       6.048   4.048  25.237  1.00 19.04           C  
ATOM    415  O   MET A  52       7.166   4.045  25.810  1.00 21.83           O  
ATOM    416  CB  MET A  52       5.357   6.246  24.120  1.00 18.62           C  
ATOM    417  CG  MET A  52       5.474   7.011  22.852  1.00 20.00           C  
ATOM    418  SD  MET A  52       5.033   8.784  22.930  1.00 28.75           S  
ATOM    419  CE  MET A  52       5.972   9.309  24.319  1.00 28.24           C  
ATOM    420  N   ARG A  53       5.000   3.411  25.755  1.00 18.50           N  
ATOM    421  CA  ARG A  53       5.123   2.646  26.987  1.00 19.42           C  
ATOM    422  C   ARG A  53       6.003   1.459  26.776  1.00 21.51           C  
ATOM    423  O   ARG A  53       6.658   0.993  27.709  1.00 26.39           O  
ATOM    424  CB  ARG A  53       3.763   2.186  27.506  1.00 19.40           C  
ATOM    425  CG  ARG A  53       2.995   3.294  28.072  1.00 22.12           C  
ATOM    426  CD  ARG A  53       1.723   2.810  28.836  1.00 20.59           C  
ATOM    427  NE  ARG A  53       0.734   2.224  27.916  1.00 19.44           N  
ATOM    428  CZ  ARG A  53      -0.145   2.904  27.217  1.00 19.32           C  
ATOM    429  NH1 ARG A  53      -0.225   4.238  27.284  1.00 20.87           N  
ATOM    430  NH2 ARG A  53      -1.015   2.261  26.474  1.00 18.34           N  
ATOM    431  N   ASP A  54       5.989   0.947  25.567  1.00 20.37           N  
ATOM    432  CA  ASP A  54       6.663  -0.287  25.289  1.00 20.99           C  
ATOM    433  C   ASP A  54       8.083  -0.146  24.696  1.00 19.91           C  
ATOM    434  O   ASP A  54       8.825  -1.122  24.598  1.00 22.89           O  
ATOM    435  CB  ASP A  54       5.718  -1.077  24.382  1.00 22.86           C  
ATOM    436  CG  ASP A  54       4.222  -1.211  24.967  1.00 21.37           C  
ATOM    437  OD1 ASP A  54       3.844  -0.900  26.148  1.00 24.29           O  
ATOM    438  OD2 ASP A  54       3.311  -1.671  24.254  1.00 24.45           O  
ATOM    439  N   ASN A  55       8.450   1.058  24.282  1.00 15.53           N  
ATOM    440  CA  ASN A  55       9.728   1.281  23.647  1.00 14.32           C  
ATOM    441  C   ASN A  55      10.300   2.541  24.271  1.00 13.59           C  
ATOM    442  O   ASN A  55       9.857   3.660  24.037  1.00 13.63           O  
ATOM    443  CB  ASN A  55       9.565   1.469  22.140  1.00 13.91           C  
ATOM    444  CG  ASN A  55       9.032   0.237  21.508  1.00 15.41           C  
ATOM    445  OD1 ASN A  55       9.802  -0.617  21.077  1.00 19.55           O  
ATOM    446  ND2 ASN A  55       7.679   0.152  21.410  1.00 16.76           N  
ATOM    447  N   ASP A  56      11.328   2.349  25.058  1.00 14.47           N  
ATOM    448  CA  ASP A  56      12.015   3.458  25.686  1.00 13.71           C  
ATOM    449  C   ASP A  56      12.606   4.405  24.672  1.00 12.24           C  
ATOM    450  O   ASP A  56      12.875   4.040  23.539  1.00 12.43           O  
ATOM    451  CB  ASP A  56      13.102   2.948  26.636  1.00 15.77           C  
ATOM    452  CG  ASP A  56      12.567   2.412  27.937  1.00 19.31           C  
ATOM    453  OD1 ASP A  56      11.409   2.642  28.274  1.00 24.39           O  
ATOM    454  OD2 ASP A  56      13.323   1.896  28.756  1.00 27.03           O  
ATOM    455  N   PHE A  57      12.866   5.644  25.091  1.00 12.25           N  
ATOM    456  CA  PHE A  57      13.385   6.682  24.233  1.00 11.25           C  
ATOM    457  C   PHE A  57      14.747   6.434  23.644  1.00 11.46           C  
ATOM    458  O   PHE A  57      15.083   7.096  22.649  1.00 11.53           O  
ATOM    459  CB  PHE A  57      13.377   8.004  24.988  1.00 11.91           C  
ATOM    460  CG  PHE A  57      12.003   8.513  25.319  1.00 12.22           C  
ATOM    461  CD1 PHE A  57      11.005   8.585  24.346  1.00 13.22           C  
ATOM    462  CD2 PHE A  57      11.721   8.929  26.583  1.00 14.27           C  
ATOM    463  CE1 PHE A  57       9.779   9.094  24.638  1.00 15.29           C  
ATOM    464  CE2 PHE A  57      10.486   9.430  26.903  1.00 16.31           C  
ATOM    465  CZ  PHE A  57       9.519   9.517  25.913  1.00 16.74           C  
ATOM    466  N   ASP A  58      15.494   5.486  24.196  1.00 12.33           N  
ATOM    467  CA  ASP A  58      16.767   5.094  23.656  1.00 13.41           C  
ATOM    468  C   ASP A  58      16.675   3.959  22.616  1.00 13.82           C  
ATOM    469  O   ASP A  58      17.684   3.436  22.153  1.00 17.12           O  
ATOM    470  CB  ASP A  58      17.757   4.722  24.785  1.00 15.64           C  
ATOM    471  CG  ASP A  58      17.287   3.583  25.672  1.00 14.30           C  
ATOM    472  OD1 ASP A  58      16.304   2.884  25.439  1.00 17.66           O  
ATOM    473  OD2 ASP A  58      17.991   3.388  26.737  1.00 17.17           O  
ATOM    474  N   THR A  59      15.471   3.566  22.271  1.00 12.08           N  
ATOM    475  CA  THR A  59      15.291   2.514  21.266  1.00 12.11           C  
ATOM    476  C   THR A  59      15.446   3.127  19.888  1.00 11.18           C  
ATOM    477  O   THR A  59      14.658   4.021  19.554  1.00 11.13           O  
ATOM    478  CB  THR A  59      13.851   1.970  21.355  1.00 13.01           C  
ATOM    479  OG1 THR A  59      13.513   1.505  22.649  1.00 15.12           O  
ATOM    480  CG2 THR A  59      13.659   0.813  20.368  1.00 14.07           C  
ATOM    481  N   PRO A  60      16.344   2.640  19.037  1.00 11.52           N  
ATOM    482  CA  PRO A  60      16.357   3.140  17.674  1.00 11.24           C  
ATOM    483  C   PRO A  60      15.074   2.731  16.950  1.00 10.37           C  
ATOM    484  O   PRO A  60      14.692   1.572  16.982  1.00 11.28           O  
ATOM    485  CB  PRO A  60      17.618   2.481  17.093  1.00 13.10           C  
ATOM    486  CG  PRO A  60      18.471   2.173  18.303  1.00 14.79           C  
ATOM    487  CD  PRO A  60      17.453   1.706  19.299  1.00 13.28           C  
ATOM    488  N   VAL A  61      14.470   3.719  16.295  1.00  9.64           N  
ATOM    489  CA  VAL A  61      13.179   3.551  15.592  1.00  9.22           C  
ATOM    490  C   VAL A  61      13.326   3.936  14.147  1.00  8.98           C  
ATOM    491  O   VAL A  61      13.780   5.028  13.833  1.00 10.09           O  
ATOM    492  CB  VAL A  61      12.073   4.389  16.237  1.00 10.13           C  
ATOM    493  CG1 VAL A  61      10.761   4.239  15.473  1.00 10.41           C  
ATOM    494  CG2 VAL A  61      11.879   4.060  17.714  1.00 11.04           C  
ATOM    495  N   MET A  62      12.926   3.038  13.247  1.00  8.43           N  
ATOM    496  CA  MET A  62      12.936   3.303  11.813  1.00  8.44           C  
ATOM    497  C   MET A  62      11.479   3.430  11.353  1.00  8.44           C  
ATOM    498  O   MET A  62      10.670   2.550  11.630  1.00  9.75           O  
ATOM    499  CB  MET A  62      13.602   2.165  11.057  1.00  9.24           C  
ATOM    500  CG  MET A  62      14.998   1.816  11.560  1.00  9.56           C  
ATOM    501  SD  MET A  62      15.759   0.438  10.713  1.00 10.45           S  
ATOM    502  CE  MET A  62      14.705  -0.951  11.254  1.00 12.59           C  
ATOM    503  N   VAL A  63      11.176   4.492  10.637  1.00  8.56           N  
ATOM    504  CA  VAL A  63       9.837   4.826  10.222  1.00  8.68           C  
ATOM    505  C   VAL A  63       9.665   4.610   8.722  1.00  8.33           C  
ATOM    506  O   VAL A  63      10.403   5.181   7.923  1.00  8.90           O  
ATOM    507  CB  VAL A  63       9.482   6.284  10.573  1.00  8.99           C  
ATOM    508  CG1 VAL A  63       8.027   6.584  10.257  1.00 10.18           C  
ATOM    509  CG2 VAL A  63       9.807   6.621  12.042  1.00 10.06           C  
ATOM    510  N   MET A  64       8.676   3.800   8.366  1.00  8.70           N  
ATOM    511  CA  MET A  64       8.328   3.518   6.968  1.00  8.35           C  
ATOM    512  C   MET A  64       6.928   4.038   6.679  1.00  8.58           C  
ATOM    513  O   MET A  64       6.006   3.846   7.446  1.00  9.29           O  
ATOM    514  CB  MET A  64       8.354   1.988   6.742  1.00  9.34           C  
ATOM    515  CG  MET A  64       8.236   1.619   5.256  1.00  9.94           C  
ATOM    516  SD  MET A  64       8.288  -0.136   4.899  1.00 10.04           S  
ATOM    517  CE  MET A  64       9.988  -0.524   5.292  1.00 11.25           C  
HETATM  518  N   CSS A  65       6.796   4.646   5.512  1.00  9.33           N  
HETATM  519  CA  CSS A  65       5.511   5.070   4.993  1.00  9.78           C  
HETATM  520  CB  CSS A  65       5.330   6.588   5.108  1.00 10.49           C  
HETATM  521  SG  CSS A  65       6.467   7.534   4.073  0.80  9.40           S  
HETATM  523  SD  CSS A  65       5.258   8.371   2.563  1.00 12.71           S  
HETATM  524  C   CSS A  65       5.321   4.555   3.569  1.00  9.82           C  
HETATM  525  O   CSS A  65       5.849   3.526   3.197  1.00 10.84           O  
ATOM    526  N   TYR A  66       4.504   5.244   2.790  1.00 11.36           N  
ATOM    527  CA  TYR A  66       4.248   4.845   1.392  1.00 12.27           C  
ATOM    528  C   TYR A  66       5.506   4.900   0.486  1.00 13.24           C  
ATOM    529  O   TYR A  66       5.781   3.993  -0.291  1.00 13.57           O  
ATOM    530  CB  TYR A  66       3.138   5.719   0.799  1.00 12.22           C  
ATOM    531  CG  TYR A  66       1.856   5.709   1.604  1.00 12.30           C  
ATOM    532  CD1 TYR A  66       0.960   4.665   1.471  1.00 12.68           C  
ATOM    533  CD2 TYR A  66       1.549   6.702   2.465  1.00 11.93           C  
ATOM    534  CE1 TYR A  66      -0.204   4.603   2.247  1.00 12.65           C  
ATOM    535  CE2 TYR A  66       0.397   6.689   3.208  1.00 12.59           C  
ATOM    536  CZ  TYR A  66      -0.499   5.605   3.097  1.00 12.42           C  
ATOM    537  OH  TYR A  66      -1.641   5.580   3.865  1.00 13.76           O  
ATOM    538  N   HIS A  67       6.231   5.987   0.590  1.00 12.76           N  
ATOM    539  CA  HIS A  67       7.299   6.338  -0.363  1.00 12.41           C  
ATOM    540  C   HIS A  67       8.518   6.978   0.251  1.00 12.75           C  
ATOM    541  O   HIS A  67       9.462   7.282  -0.474  1.00 14.54           O  
ATOM    542  CB  HIS A  67       6.747   7.304  -1.431  1.00 13.90           C  
ATOM    543  CG  HIS A  67       5.737   6.654  -2.295  1.00 15.06           C  
ATOM    544  ND1 HIS A  67       4.392   6.938  -2.315  1.00 18.13           N  
ATOM    545  CD2 HIS A  67       5.934   5.660  -3.182  1.00 14.74           C  
ATOM    546  CE1 HIS A  67       3.786   6.103  -3.148  1.00 16.44           C  
ATOM    547  NE2 HIS A  67       4.707   5.365  -3.734  1.00 20.95           N  
ATOM    548  N   GLY A  68       8.530   7.221   1.558  1.00 12.69           N  
ATOM    549  CA  GLY A  68       9.644   7.918   2.181  1.00 12.22           C  
ATOM    550  C   GLY A  68       9.413   9.385   2.471  1.00 11.85           C  
ATOM    551  O   GLY A  68      10.343  10.069   2.870  1.00 13.31           O  
ATOM    552  N   ASN A  69       8.170   9.856   2.305  1.00 12.06           N  
ATOM    553  CA  ASN A  69       7.854  11.287   2.483  1.00 13.51           C  
ATOM    554  C   ASN A  69       7.299  11.625   3.852  1.00 12.29           C  
ATOM    555  O   ASN A  69       7.905  12.419   4.599  1.00 12.56           O  
ATOM    556  CB  ASN A  69       6.913  11.736   1.389  1.00 14.20           C  
ATOM    557  CG  ASN A  69       7.498  11.554   0.046  1.00 16.57           C  
ATOM    558  OD1 ASN A  69       8.668  11.877  -0.199  1.00 19.55           O  
ATOM    559  ND2 ASN A  69       6.736  10.938  -0.801  1.00 19.00           N  
ATOM    560  N   SER A  70       6.153  11.041   4.230  1.00 12.34           N  
ATOM    561  CA  SER A  70       5.554  11.341   5.514  1.00 11.06           C  
ATOM    562  C   SER A  70       6.324  10.808   6.685  1.00 10.43           C  
ATOM    563  O   SER A  70       6.174  11.291   7.801  1.00 10.94           O  
ATOM    564  CB  SER A  70       4.099  10.856   5.573  1.00 11.96           C  
ATOM    565  OG  SER A  70       3.955   9.512   5.350  1.00 12.45           O  
ATOM    566  N   SER A  71       7.170   9.805   6.447  1.00 10.61           N  
ATOM    567  CA  SER A  71       8.015   9.283   7.491  1.00  9.98           C  
ATOM    568  C   SER A  71       8.998  10.336   8.009  1.00 10.24           C  
ATOM    569  O   SER A  71       9.490  10.173   9.116  1.00 10.71           O  
ATOM    570  CB  SER A  71       8.700   8.010   7.054  1.00 10.29           C  
ATOM    571  OG  SER A  71       9.413   8.155   5.867  1.00 10.95           O  
ATOM    572  N   LYS A  72       9.342  11.355   7.208  1.00 10.69           N  
ATOM    573  CA  LYS A  72      10.217  12.414   7.694  1.00 11.61           C  
ATOM    574  C   LYS A  72       9.531  13.215   8.812  1.00 11.87           C  
ATOM    575  O   LYS A  72      10.091  13.408   9.891  1.00 12.91           O  
ATOM    576  CB  LYS A  72      10.621  13.308   6.529  1.00 12.38           C  
ATOM    577  CG  LYS A  72      11.423  12.565   5.469  1.00 14.21           C  
ATOM    578  CD  LYS A  72      11.795  13.489   4.296  1.00 17.06           C  
ATOM    579  CE  LYS A  72      12.600  12.733   3.226  1.00 22.40           C  
ATOM    580  NZ  LYS A  72      12.789  13.559   2.031  1.00 28.80           N  
ATOM    581  N   GLY A  73       8.314  13.677   8.566  1.00 12.07           N  
ATOM    582  CA  GLY A  73       7.593  14.425   9.580  1.00 13.18           C  
ATOM    583  C   GLY A  73       7.278  13.571  10.802  1.00 11.54           C  
ATOM    584  O   GLY A  73       7.362  14.047  11.931  1.00 12.04           O  
ATOM    585  N   ALA A  74       6.951  12.289  10.585  1.00 11.09           N  
ATOM    586  CA  ALA A  74       6.676  11.414  11.705  1.00 10.69           C  
ATOM    587  C   ALA A  74       7.937  11.173  12.504  1.00 10.43           C  
ATOM    588  O   ALA A  74       7.886  11.110  13.736  1.00 10.68           O  
ATOM    589  CB  ALA A  74       6.071  10.107  11.240  1.00 11.28           C  
ATOM    590  N   ALA A  75       9.085  11.001  11.845  1.00 10.79           N  
ATOM    591  CA  ALA A  75      10.353  10.824  12.563  1.00 10.56           C  
ATOM    592  C   ALA A  75      10.663  12.030  13.442  1.00 11.10           C  
ATOM    593  O   ALA A  75      11.073  11.890  14.568  1.00 11.54           O  
ATOM    594  CB  ALA A  75      11.489  10.564  11.556  1.00 12.06           C  
ATOM    595  N   GLN A  76      10.473  13.226  12.861  1.00 12.02           N  
ATOM    596  CA  GLN A  76      10.716  14.440  13.617  1.00 12.15           C  
ATOM    597  C   GLN A  76       9.790  14.540  14.839  1.00 12.22           C  
ATOM    598  O   GLN A  76      10.190  14.951  15.919  1.00 12.50           O  
ATOM    599  CB  GLN A  76      10.576  15.655  12.727  1.00 13.75           C  
ATOM    600  CG  GLN A  76      11.064  16.921  13.364  1.00 18.17           C  
ATOM    601  CD  GLN A  76      12.565  16.909  13.539  1.00 20.69           C  
ATOM    602  OE1 GLN A  76      13.307  16.217  12.804  1.00 25.25           O  
ATOM    603  NE2 GLN A  76      13.040  17.707  14.474  1.00 29.81           N  
ATOM    604  N   TYR A  77       8.522  14.148  14.633  1.00 11.85           N  
ATOM    605  CA  TYR A  77       7.595  14.100  15.720  1.00 12.34           C  
ATOM    606  C   TYR A  77       8.053  13.182  16.842  1.00 11.72           C  
ATOM    607  O   TYR A  77       7.988  13.528  18.014  1.00 12.77           O  
ATOM    608  CB  TYR A  77       6.215  13.715  15.180  1.00 13.36           C  
ATOM    609  CG  TYR A  77       5.177  13.618  16.276  1.00 15.99           C  
ATOM    610  CD1 TYR A  77       4.629  14.720  16.858  1.00 25.85           C  
ATOM    611  CD2 TYR A  77       4.854  12.411  16.801  1.00 18.30           C  
ATOM    612  CE1 TYR A  77       3.685  14.593  17.902  1.00 28.49           C  
ATOM    613  CE2 TYR A  77       3.949  12.269  17.807  1.00 23.76           C  
ATOM    614  CZ  TYR A  77       3.356  13.355  18.361  1.00 26.51           C  
ATOM    615  OH  TYR A  77       2.450  13.181  19.374  1.00 38.39           O  
ATOM    616  N   LEU A  78       8.531  11.996  16.492  1.00 11.26           N  
ATOM    617  CA  LEU A  78       9.061  11.092  17.513  1.00 10.55           C  
ATOM    618  C   LEU A  78      10.250  11.687  18.251  1.00 10.98           C  
ATOM    619  O   LEU A  78      10.352  11.514  19.469  1.00 11.41           O  
ATOM    620  CB  LEU A  78       9.390   9.739  16.867  1.00 11.27           C  
ATOM    621  CG  LEU A  78       8.159   8.912  16.428  1.00 11.60           C  
ATOM    622  CD1 LEU A  78       8.638   7.657  15.737  1.00 14.42           C  
ATOM    623  CD2 LEU A  78       7.277   8.537  17.608  1.00 12.75           C  
ATOM    624  N   LEU A  79      11.155  12.340  17.540  1.00 11.23           N  
ATOM    625  CA  LEU A  79      12.271  13.033  18.233  1.00 12.46           C  
ATOM    626  C   LEU A  79      11.720  14.038  19.263  1.00 12.88           C  
ATOM    627  O   LEU A  79      12.184  14.127  20.394  1.00 14.20           O  
ATOM    628  CB  LEU A  79      13.134  13.796  17.228  1.00 15.21           C  
ATOM    629  CG  LEU A  79      13.958  12.996  16.307  1.00 18.22           C  
ATOM    630  CD1 LEU A  79      14.590  13.973  15.324  1.00 25.22           C  
ATOM    631  CD2 LEU A  79      15.067  12.181  16.993  1.00 19.62           C  
ATOM    632  N   GLN A  80      10.716  14.781  18.847  1.00 13.21           N  
ATOM    633  CA  GLN A  80      10.113  15.794  19.724  1.00 15.04           C  
ATOM    634  C   GLN A  80       9.484  15.180  20.951  1.00 16.21           C  
ATOM    635  O   GLN A  80       9.426  15.826  21.989  1.00 19.83           O  
ATOM    636  CB  GLN A  80       9.096  16.614  18.961  1.00 17.21           C  
ATOM    637  CG  GLN A  80       9.673  17.470  17.889  1.00 20.13           C  
ATOM    638  CD  GLN A  80       8.616  18.087  17.001  1.00 21.19           C  
ATOM    639  OE1 GLN A  80       7.440  17.683  17.015  1.00 26.21           O  
ATOM    640  NE2 GLN A  80       9.061  18.996  16.126  1.00 28.47           N  
ATOM    641  N   GLN A  81       9.015  13.958  20.850  1.00 14.61           N  
ATOM    642  CA  GLN A  81       8.461  13.246  22.000  1.00 15.95           C  
ATOM    643  C   GLN A  81       9.500  12.684  22.948  1.00 16.03           C  
ATOM    644  O   GLN A  81       9.131  12.274  24.039  1.00 20.85           O  
ATOM    645  CB  GLN A  81       7.528  12.121  21.576  1.00 17.82           C  
ATOM    646  CG  GLN A  81       6.369  12.471  20.695  1.00 18.51           C  
ATOM    647  CD  GLN A  81       5.788  13.811  20.939  1.00 33.59           C  
ATOM    648  OE1 GLN A  81       5.221  14.031  21.990  1.00 40.27           O  
ATOM    649  NE2 GLN A  81       5.873  14.706  19.946  1.00 32.68           N  
ATOM    650  N   GLY A  82      10.769  12.620  22.531  1.00 14.30           N  
ATOM    651  CA  GLY A  82      11.835  12.172  23.376  1.00 14.77           C  
ATOM    652  C   GLY A  82      12.716  11.087  22.774  1.00 12.69           C  
ATOM    653  O   GLY A  82      13.738  10.738  23.365  1.00 13.52           O  
ATOM    654  N   TYR A  83      12.330  10.513  21.613  1.00 11.53           N  
ATOM    655  CA  TYR A  83      13.221   9.530  21.023  1.00 10.91           C  
ATOM    656  C   TYR A  83      14.509  10.193  20.547  1.00 11.40           C  
ATOM    657  O   TYR A  83      14.463  11.241  19.979  1.00 17.20           O  
ATOM    658  CB  TYR A  83      12.506   8.756  19.890  1.00 10.02           C  
ATOM    659  CG  TYR A  83      11.444   7.826  20.424  1.00  9.87           C  
ATOM    660  CD1 TYR A  83      11.781   6.584  20.828  1.00  9.97           C  
ATOM    661  CD2 TYR A  83      10.145   8.257  20.591  1.00 10.99           C  
ATOM    662  CE1 TYR A  83      10.863   5.764  21.459  1.00 10.36           C  
ATOM    663  CE2 TYR A  83       9.231   7.450  21.200  1.00 11.74           C  
ATOM    664  CZ  TYR A  83       9.578   6.192  21.646  1.00 11.24           C  
ATOM    665  OH  TYR A  83       8.654   5.413  22.294  1.00 13.26           O  
ATOM    666  N   ASP A  84      15.629   9.542  20.775  1.00 10.21           N  
ATOM    667  CA  ASP A  84      16.913  10.080  20.379  1.00 10.03           C  
ATOM    668  C   ASP A  84      17.456   9.536  19.061  1.00 11.24           C  
ATOM    669  O   ASP A  84      18.303  10.212  18.456  1.00 13.15           O  
ATOM    670  CB  ASP A  84      17.955   9.839  21.487  1.00 11.30           C  
ATOM    671  CG  ASP A  84      18.037  11.010  22.458  1.00 11.06           C  
ATOM    672  OD1 ASP A  84      18.203  12.133  21.965  1.00 14.59           O  
ATOM    673  OD2 ASP A  84      17.939  10.814  23.681  1.00 11.20           O  
ATOM    674  N   VAL A  85      17.021   8.371  18.625  1.00 11.00           N  
ATOM    675  CA  VAL A  85      17.637   7.679  17.456  1.00 12.44           C  
ATOM    676  C   VAL A  85      16.449   7.294  16.559  1.00 11.33           C  
ATOM    677  O   VAL A  85      15.784   6.309  16.825  1.00 10.91           O  
ATOM    678  CB  VAL A  85      18.484   6.453  17.903  1.00 13.61           C  
ATOM    679  CG1 VAL A  85      19.118   5.768  16.707  1.00 14.77           C  
ATOM    680  CG2 VAL A  85      19.539   6.895  18.875  1.00 17.90           C  
ATOM    681  N   VAL A  86      16.187   8.122  15.538  1.00 11.61           N  
ATOM    682  CA  VAL A  86      15.037   7.912  14.667  1.00 10.70           C  
ATOM    683  C   VAL A  86      15.473   8.055  13.234  1.00 11.14           C  
ATOM    684  O   VAL A  86      16.262   8.946  12.883  1.00 15.92           O  
ATOM    685  CB  VAL A  86      13.891   8.866  14.991  1.00 12.98           C  
ATOM    686  CG1 VAL A  86      12.640   8.465  14.230  1.00 15.15           C  
ATOM    687  CG2 VAL A  86      13.560   8.877  16.474  1.00 13.19           C  
ATOM    688  N   TYR A  87      14.992   7.163  12.404  1.00  9.49           N  
ATOM    689  CA  TYR A  87      15.290   7.131  10.971  1.00  9.91           C  
ATOM    690  C   TYR A  87      14.034   7.189  10.142  1.00  9.21           C  
ATOM    691  O   TYR A  87      13.000   6.652  10.556  1.00  9.97           O  
ATOM    692  CB  TYR A  87      16.033   5.826  10.619  1.00 10.22           C  
ATOM    693  CG  TYR A  87      17.262   5.536  11.431  1.00 11.04           C  
ATOM    694  CD1 TYR A  87      18.445   6.163  11.132  1.00 14.68           C  
ATOM    695  CD2 TYR A  87      17.230   4.699  12.515  1.00 12.00           C  
ATOM    696  CE1 TYR A  87      19.593   5.938  11.886  1.00 19.11           C  
ATOM    697  CE2 TYR A  87      18.389   4.484  13.276  1.00 14.62           C  
ATOM    698  CZ  TYR A  87      19.554   5.076  12.916  1.00 17.07           C  
ATOM    699  OH  TYR A  87      20.683   4.833  13.692  1.00 23.16           O  
ATOM    700  N   SER A  88      14.120   7.738   8.948  1.00  9.46           N  
ATOM    701  CA  SER A  88      13.097   7.682   7.942  1.00  9.58           C  
ATOM    702  C   SER A  88      13.628   6.828   6.795  1.00  8.87           C  
ATOM    703  O   SER A  88      14.739   7.035   6.331  1.00  9.95           O  
ATOM    704  CB  SER A  88      12.799   9.089   7.435  1.00 10.84           C  
ATOM    705  OG  SER A  88      11.876   9.103   6.363  1.00 11.61           O  
ATOM    706  N   ILE A  89      12.826   5.882   6.344  1.00  9.09           N  
ATOM    707  CA  ILE A  89      13.252   4.910   5.324  1.00  8.91           C  
ATOM    708  C   ILE A  89      12.909   5.401   3.936  1.00  9.35           C  
ATOM    709  O   ILE A  89      11.747   5.450   3.501  1.00 10.08           O  
ATOM    710  CB  ILE A  89      12.677   3.527   5.595  1.00  9.49           C  
ATOM    711  CG1 ILE A  89      13.126   2.993   6.948  1.00  9.78           C  
ATOM    712  CG2 ILE A  89      13.062   2.574   4.474  1.00 10.52           C  
ATOM    713  CD1 ILE A  89      12.449   1.730   7.388  1.00 10.66           C  
ATOM    714  N   ASP A  90      13.926   5.788   3.191  1.00 10.11           N  
ATOM    715  CA  ASP A  90      13.767   6.259   1.838  1.00 10.86           C  
ATOM    716  C   ASP A  90      13.117   5.213   0.978  1.00 11.02           C  
ATOM    717  O   ASP A  90      13.409   4.012   1.033  1.00 11.80           O  
ATOM    718  CB  ASP A  90      15.145   6.626   1.279  1.00 12.31           C  
ATOM    719  CG  ASP A  90      15.731   7.913   1.873  1.00 13.79           C  
ATOM    720  OD1 ASP A  90      14.998   8.820   2.321  1.00 18.35           O  
ATOM    721  OD2 ASP A  90      16.977   8.081   1.835  1.00 16.71           O  
ATOM    722  N   GLY A  91      12.162   5.672   0.171  1.00 11.40           N  
ATOM    723  CA  GLY A  91      11.457   4.802  -0.723  1.00 12.31           C  
ATOM    724  C   GLY A  91      10.244   4.119  -0.146  1.00 11.92           C  
ATOM    725  O   GLY A  91       9.430   3.548  -0.892  1.00 12.96           O  
ATOM    726  N   GLY A  92      10.116   4.127   1.165  1.00 11.38           N  
ATOM    727  CA  GLY A  92       8.943   3.571   1.816  1.00 11.57           C  
ATOM    728  C   GLY A  92       8.742   2.075   1.527  1.00 10.82           C  
ATOM    729  O   GLY A  92       9.628   1.323   1.204  1.00 11.33           O  
ATOM    730  N   PHE A  93       7.476   1.665   1.663  1.00 11.54           N  
ATOM    731  CA  PHE A  93       7.125   0.301   1.425  1.00 11.61           C  
ATOM    732  C   PHE A  93       7.418  -0.153   0.004  1.00 12.26           C  
ATOM    733  O   PHE A  93       7.767  -1.307  -0.231  1.00 12.03           O  
ATOM    734  CB  PHE A  93       5.671  -0.021   1.831  1.00 12.07           C  
ATOM    735  CG  PHE A  93       5.294  -1.418   1.578  1.00 11.85           C  
ATOM    736  CD1 PHE A  93       5.813  -2.431   2.381  1.00 12.43           C  
ATOM    737  CD2 PHE A  93       4.470  -1.790   0.520  1.00 13.00           C  
ATOM    738  CE1 PHE A  93       5.525  -3.774   2.110  1.00 12.98           C  
ATOM    739  CE2 PHE A  93       4.190  -3.078   0.255  1.00 14.10           C  
ATOM    740  CZ  PHE A  93       4.707  -4.095   1.044  1.00 13.83           C  
ATOM    741  N   GLU A  94       7.255   0.760  -0.951  1.00 13.01           N  
ATOM    742  CA  GLU A  94       7.542   0.372  -2.324  1.00 14.54           C  
ATOM    743  C   GLU A  94       8.960  -0.169  -2.432  1.00 13.89           C  
ATOM    744  O   GLU A  94       9.203  -1.203  -3.091  1.00 14.57           O  
ATOM    745  CB  GLU A  94       7.400   1.562  -3.255  1.00 15.57           C  
ATOM    746  CG  GLU A  94       6.043   2.150  -3.439  1.00 21.96           C  
ATOM    747  CD  GLU A  94       5.012   1.155  -3.928  1.00 20.74           C  
ATOM    748  OE1 GLU A  94       3.875   1.264  -3.422  1.00 19.09           O  
ATOM    749  OE2 GLU A  94       5.341   0.268  -4.767  1.00 21.82           O  
ATOM    750  N   ALA A  95       9.912   0.530  -1.843  1.00 12.73           N  
ATOM    751  CA  ALA A  95      11.300   0.094  -1.918  1.00 13.45           C  
ATOM    752  C   ALA A  95      11.524  -1.183  -1.148  1.00 12.51           C  
ATOM    753  O   ALA A  95      12.290  -2.040  -1.562  1.00 13.38           O  
ATOM    754  CB  ALA A  95      12.219   1.184  -1.447  1.00 13.54           C  
ATOM    755  N   TRP A  96      10.869  -1.327   0.007  1.00 11.72           N  
ATOM    756  CA  TRP A  96      11.024  -2.522   0.814  1.00 12.18           C  
ATOM    757  C   TRP A  96      10.578  -3.762   0.023  1.00 12.83           C  
ATOM    758  O   TRP A  96      11.280  -4.763  -0.046  1.00 14.53           O  
ATOM    759  CB  TRP A  96      10.252  -2.410   2.121  1.00 12.20           C  
ATOM    760  CG  TRP A  96      10.395  -3.665   2.971  1.00 12.74           C  
ATOM    761  CD1 TRP A  96       9.642  -4.804   2.898  1.00 13.72           C  
ATOM    762  CD2 TRP A  96      11.458  -3.946   3.887  1.00 13.42           C  
ATOM    763  NE1 TRP A  96      10.161  -5.751   3.744  1.00 14.24           N  
ATOM    764  CE2 TRP A  96      11.252  -5.240   4.411  1.00 12.75           C  
ATOM    765  CE3 TRP A  96      12.523  -3.184   4.380  1.00 12.68           C  
ATOM    766  CZ2 TRP A  96      12.118  -5.814   5.369  1.00 14.16           C  
ATOM    767  CZ3 TRP A  96      13.348  -3.738   5.347  1.00 13.61           C  
ATOM    768  CH2 TRP A  96      13.131  -5.041   5.816  1.00 14.31           C  
ATOM    769  N   GLN A  97       9.355  -3.687  -0.539  1.00 13.23           N  
ATOM    770  CA  GLN A  97       8.806  -4.791  -1.289  1.00 15.37           C  
ATOM    771  C   GLN A  97       9.648  -5.126  -2.516  1.00 15.62           C  
ATOM    772  O   GLN A  97       9.756  -6.293  -2.861  1.00 17.68           O  
ATOM    773  CB  GLN A  97       7.295  -4.506  -1.639  1.00 19.73           C  
ATOM    774  CG  GLN A  97       6.551  -5.655  -2.291  1.00 26.96           C  
ATOM    775  CD  GLN A  97       6.822  -5.714  -3.744  1.00 26.27           C  
ATOM    776  OE1 GLN A  97       7.090  -4.680  -4.333  1.00 35.08           O  
ATOM    777  NE2 GLN A  97       6.875  -6.932  -4.290  1.00 33.92           N  
ATOM    778  N   ARG A  98      10.235  -4.131  -3.144  1.00 15.87           N  
ATOM    779  CA  ARG A  98      11.053  -4.393  -4.336  1.00 17.40           C  
ATOM    780  C   ARG A  98      12.315  -5.139  -3.942  1.00 16.78           C  
ATOM    781  O   ARG A  98      12.752  -6.047  -4.648  1.00 19.87           O  
ATOM    782  CB  ARG A  98      11.396  -3.072  -4.988  1.00 18.77           C  
ATOM    783  CG  ARG A  98      12.218  -3.197  -6.260  1.00 24.32           C  
ATOM    784  CD  ARG A  98      12.583  -1.843  -6.811  1.00 30.53           C  
ATOM    785  NE  ARG A  98      11.419  -1.065  -7.217  1.00 39.13           N  
ATOM    786  CZ  ARG A  98      10.996   0.077  -6.647  1.00 44.40           C  
ATOM    787  NH1 ARG A  98      11.618   0.618  -5.600  1.00 40.16           N  
ATOM    788  NH2 ARG A  98       9.921   0.688  -7.138  1.00 46.59           N  
ATOM    789  N   GLN A  99      12.959  -4.748  -2.843  1.00 16.48           N  
ATOM    790  CA  GLN A  99      14.219  -5.321  -2.470  1.00 16.46           C  
ATOM    791  C   GLN A  99      14.096  -6.607  -1.698  1.00 16.65           C  
ATOM    792  O   GLN A  99      14.942  -7.504  -1.839  1.00 19.98           O  
ATOM    793  CB  GLN A  99      15.042  -4.294  -1.710  1.00 16.50           C  
ATOM    794  CG  GLN A  99      15.381  -3.057  -2.549  1.00 25.41           C  
ATOM    795  CD  GLN A  99      16.615  -2.310  -2.043  1.00 36.33           C  
ATOM    796  OE1 GLN A  99      16.845  -1.163  -2.415  1.00 44.67           O  
ATOM    797  NE2 GLN A  99      17.407  -2.965  -1.207  1.00 42.04           N  
ATOM    798  N   PHE A 100      13.046  -6.720  -0.912  1.00 15.81           N  
ATOM    799  CA  PHE A 100      12.834  -7.827  -0.000  1.00 16.36           C  
ATOM    800  C   PHE A 100      11.453  -8.490  -0.133  1.00 17.92           C  
ATOM    801  O   PHE A 100      10.668  -8.533   0.817  1.00 17.62           O  
ATOM    802  CB  PHE A 100      13.092  -7.441   1.459  1.00 16.36           C  
ATOM    803  CG  PHE A 100      14.453  -6.888   1.663  1.00 16.68           C  
ATOM    804  CD1 PHE A 100      15.567  -7.679   1.498  1.00 17.73           C  
ATOM    805  CD2 PHE A 100      14.642  -5.570   1.926  1.00 15.76           C  
ATOM    806  CE1 PHE A 100      16.858  -7.130   1.673  1.00 17.43           C  
ATOM    807  CE2 PHE A 100      15.891  -5.040   2.052  1.00 17.80           C  
ATOM    808  CZ  PHE A 100      17.009  -5.818   1.910  1.00 18.31           C  
ATOM    809  N   PRO A 101      11.105  -8.943  -1.316  1.00 18.52           N  
ATOM    810  CA  PRO A 101       9.722  -9.392  -1.532  1.00 19.79           C  
ATOM    811  C   PRO A 101       9.317 -10.577  -0.670  1.00 20.16           C  
ATOM    812  O   PRO A 101       8.119 -10.805  -0.405  1.00 23.85           O  
ATOM    813  CB  PRO A 101       9.708  -9.770  -3.009  1.00 22.75           C  
ATOM    814  CG  PRO A 101      11.129  -9.986  -3.413  1.00 22.00           C  
ATOM    815  CD  PRO A 101      11.939  -9.028  -2.531  1.00 20.60           C  
ATOM    816  N   ALA A 102      10.274 -11.392  -0.259  1.00 20.89           N  
ATOM    817  CA  ALA A 102       9.941 -12.501   0.584  1.00 21.73           C  
ATOM    818  C   ALA A 102       9.764 -12.122   2.041  1.00 24.12           C  
ATOM    819  O   ALA A 102       9.440 -12.966   2.880  1.00 26.56           O  
ATOM    820  CB  ALA A 102      10.992 -13.583   0.423  1.00 24.53           C  
ATOM    821  N   GLU A 103       9.981 -10.854   2.360  1.00 18.47           N  
ATOM    822  CA  GLU A 103       9.827 -10.374   3.749  1.00 18.19           C  
ATOM    823  C   GLU A 103       8.672  -9.411   3.873  1.00 16.96           C  
ATOM    824  O   GLU A 103       8.805  -8.321   4.485  1.00 17.66           O  
ATOM    825  CB  GLU A 103      11.109  -9.787   4.307  1.00 19.52           C  
ATOM    826  CG  GLU A 103      12.189 -10.813   4.319  1.00 25.03           C  
ATOM    827  CD  GLU A 103      13.427 -10.241   4.928  1.00 27.66           C  
ATOM    828  OE1 GLU A 103      13.326  -9.418   5.892  1.00 27.29           O  
ATOM    829  OE2 GLU A 103      14.492 -10.522   4.375  1.00 27.51           O  
ATOM    830  N   VAL A 104       7.517  -9.837   3.338  1.00 16.23           N  
ATOM    831  CA  VAL A 104       6.254  -9.112   3.377  1.00 15.40           C  
ATOM    832  C   VAL A 104       5.247  -9.995   4.062  1.00 16.62           C  
ATOM    833  O   VAL A 104       5.110 -11.178   3.771  1.00 20.57           O  
ATOM    834  CB  VAL A 104       5.775  -8.748   1.972  1.00 16.02           C  
ATOM    835  CG1 VAL A 104       4.419  -8.082   2.005  1.00 15.85           C  
ATOM    836  CG2 VAL A 104       6.790  -7.822   1.282  1.00 16.40           C  
ATOM    837  N   ALA A 105       4.521  -9.391   4.988  1.00 15.26           N  
ATOM    838  CA  ALA A 105       3.513 -10.009   5.796  1.00 17.24           C  
ATOM    839  C   ALA A 105       2.167  -9.298   5.517  1.00 15.12           C  
ATOM    840  O   ALA A 105       2.122  -8.124   5.076  1.00 13.87           O  
ATOM    841  CB  ALA A 105       3.893  -9.922   7.307  1.00 20.16           C  
ATOM    842  N   TYR A 106       1.079 -10.006   5.798  1.00 16.52           N  
ATOM    843  CA  TYR A 106      -0.263  -9.525   5.432  1.00 16.60           C  
ATOM    844  C   TYR A 106      -1.129  -9.467   6.671  1.00 17.12           C  
ATOM    845  O   TYR A 106      -0.880 -10.175   7.648  1.00 19.90           O  
ATOM    846  CB  TYR A 106      -0.938 -10.477   4.441  1.00 19.72           C  
ATOM    847  CG  TYR A 106      -0.088 -10.554   3.208  1.00 22.65           C  
ATOM    848  CD1 TYR A 106      -0.164  -9.541   2.256  1.00 19.29           C  
ATOM    849  CD2 TYR A 106       0.885 -11.518   3.074  1.00 23.72           C  
ATOM    850  CE1 TYR A 106       0.645  -9.522   1.161  1.00 21.84           C  
ATOM    851  CE2 TYR A 106       1.728 -11.509   1.950  1.00 26.90           C  
ATOM    852  CZ  TYR A 106       1.592 -10.485   1.001  1.00 25.01           C  
ATOM    853  OH  TYR A 106       2.367 -10.371  -0.150  1.00 30.96           O  
ATOM    854  N   GLY A 107      -2.178  -8.652   6.582  1.00 15.43           N  
ATOM    855  CA  GLY A 107      -3.066  -8.468   7.717  1.00 15.15           C  
ATOM    856  C   GLY A 107      -2.484  -7.522   8.733  1.00 15.75           C  
ATOM    857  O   GLY A 107      -1.440  -6.917   8.568  1.00 18.33           O  
ATOM    858  N   ALA A 108      -3.202  -7.439   9.817  1.00 19.16           N  
ATOM    859  CA  ALA A 108      -2.586  -6.957  11.036  1.00 19.87           C  
ATOM    860  C   ALA A 108      -1.505  -7.869  11.671  1.00 18.79           C  
ATOM    861  O   ALA A 108      -1.329  -9.079  11.462  1.00 20.29           O  
ATOM    862  CB  ALA A 108      -3.670  -6.650  12.055  1.00 15.87           C  
ATOM    863  OXT ALA A 108      -0.728  -7.331  12.489  1.00 22.76           O  
TER     864      ALA A 108                                                      
END
MOLECULE T0411.pdb
ATOM      1  N   SER    20      23.383  16.708  14.252  0.80 17.27           N  
ATOM      2  CA  SER    20      23.666  15.746  13.160  0.80 15.92           C  
ATOM      3  C   SER    20      22.476  15.495  12.278  0.80 13.44           C  
ATOM      4  O   SER    20      21.317  15.511  12.700  0.80 15.60           O  
ATOM      5  CB  SER    20      24.215  14.417  13.698  0.80 17.48           C  
ATOM      6  OG  SER    20      23.257  13.716  14.438  0.80 22.08           O  
ATOM      7  N   ASN    21      22.790  15.226  11.033  0.80 11.57           N  
ATOM      8  CA  ASN    21      21.799  14.886  10.050  0.80 10.66           C  
ATOM      9  C   ASN    21      21.016  13.672  10.572  0.80 10.50           C  
ATOM     10  O   ASN    21      21.625  12.772  11.156  0.80 12.22           O  
ATOM     11  CB  ASN    21      22.527  14.565   8.733  0.80 10.39           C  
ATOM     12  CG  ASN    21      21.644  14.679   7.510  0.80 10.55           C  
ATOM     13  OD1 ASN    21      21.440  15.758   7.041  0.80 12.42           O  
ATOM     14  ND2 ASN    21      21.075  13.574   7.057  0.80 13.97           N  
ATOM     15  N   ILE    22      19.702  13.612  10.337  1.00 10.95           N  
ATOM     16  CA  ILE    22      18.928  12.460  10.733  1.00 11.03           C  
ATOM     17  C   ILE    22      19.511  11.260   9.987  1.00  9.32           C  
ATOM     18  O   ILE    22      19.727  11.303   8.764  1.00 10.99           O  
ATOM     19  CB  ILE    22      17.457  12.632  10.369  1.00 11.59           C  
ATOM     20  CG1 ILE    22      16.804  13.845  11.054  1.00 13.57           C  
ATOM     21  CG2 ILE    22      16.692  11.323  10.585  1.00 11.49           C  
ATOM     22  CD1 ILE    22      15.526  14.302  10.345  1.00 14.59           C  
ATOM     23  N   GLN    23      19.722  10.205  10.701  1.00 10.03           N  
ATOM     24  CA  GLN    23      20.202   9.026  10.107  1.00  7.97           C  
ATOM     25  C   GLN    23      19.164   8.505   9.136  1.00  6.39           C  
ATOM     26  O   GLN    23      17.996   8.376   9.487  1.00  8.10           O  
ATOM     27  CB  GLN    23      20.434   7.978  11.189  1.00 10.93           C  
ATOM     28  CG  GLN    23      20.924   6.641  10.664  1.00 14.01           C  
ATOM     29  CD  GLN    23      22.276   6.695   9.980  1.00 17.14           C  
ATOM     30  OE1 GLN    23      22.415   6.425   8.780  1.00 22.09           O  
ATOM     31  NE2 GLN    23      23.286   7.076  10.734  1.00 21.70           N  
ATOM     32  N   SER    24      19.580   8.181   7.926  1.00  6.02           N  
ATOM     33  CA  SER    24      18.730   7.632   6.909  0.50  5.38           C  
ATOM     35  C   SER    24      19.314   6.309   6.403  1.00  5.20           C  
ATOM     36  O   SER    24      20.540   6.139   6.354  1.00  6.34           O  
ATOM     37  CB  SER    24      18.620   8.604   5.752  0.50  6.73           C  
ATOM     39  OG  SER    24      19.903   8.982   5.331  0.50  6.31           O  
ATOM     41  N   TYR    25      18.430   5.409   5.975  1.00  4.90           N  
ATOM     42  CA  TYR    25      18.808   4.061   5.582  1.00  4.36           C  
ATOM     43  C   TYR    25      18.307   3.735   4.175  1.00  4.30           C  
ATOM     44  O   TYR    25      17.151   4.018   3.830  1.00  4.70           O  
ATOM     45  CB  TYR    25      18.244   3.055   6.559  1.00  4.48           C  
ATOM     46  CG  TYR    25      18.793   3.226   7.967  1.00  4.25           C  
ATOM     47  CD1 TYR    25      20.157   3.141   8.226  1.00  4.90           C  
ATOM     48  CD2 TYR    25      17.959   3.440   9.028  1.00  5.20           C  
ATOM     49  CE1 TYR    25      20.662   3.254   9.519  1.00  5.78           C  
ATOM     50  CE2 TYR    25      18.462   3.530  10.349  1.00  5.38           C  
ATOM     51  CZ  TYR    25      19.818   3.453  10.577  1.00  5.83           C  
ATOM     52  OH  TYR    25      20.352   3.513  11.834  1.00  7.58           O  
ATOM     53  N   SER    26      19.164   3.101   3.384  1.00  4.64           N  
ATOM     54  CA  SER    26      18.810   2.501   2.107  1.00  4.76           C  
ATOM     55  C   SER    26      18.144   1.145   2.296  1.00  4.12           C  
ATOM     56  O   SER    26      18.123   0.572   3.389  1.00  4.46           O  
ATOM     57  CB  SER    26      20.068   2.275   1.296  1.00  5.25           C  
ATOM     58  OG  SER    26      20.846   1.281   1.938  1.00  5.71           O  
ATOM     59  N   PHE    27      17.684   0.566   1.199  1.00  4.20           N  
ATOM     60  CA  PHE    27      17.183  -0.814   1.228  1.00  4.85           C  
ATOM     61  C   PHE    27      18.203  -1.781   1.840  1.00  4.15           C  
ATOM     62  O   PHE    27      17.863  -2.567   2.715  1.00  4.54           O  
ATOM     63  CB  PHE    27      16.840  -1.289  -0.187  1.00  4.65           C  
ATOM     64  CG  PHE    27      16.405  -2.720  -0.195  1.00  4.75           C  
ATOM     65  CD1 PHE    27      15.200  -3.108   0.378  1.00  5.63           C  
ATOM     66  CD2 PHE    27      17.199  -3.718  -0.775  1.00  5.22           C  
ATOM     67  CE1 PHE    27      14.812  -4.423   0.418  1.00  6.31           C  
ATOM     68  CE2 PHE    27      16.798  -5.031  -0.764  1.00  6.95           C  
ATOM     69  CZ  PHE    27      15.581  -5.385  -0.175  1.00  6.90           C  
ATOM     70  N   GLU    28      19.449  -1.741   1.365  1.00  4.46           N  
ATOM     71  CA  GLU    28      20.433  -2.657   1.884  1.00  4.55           C  
ATOM     72  C   GLU    28      20.686  -2.438   3.365  1.00  4.97           C  
ATOM     73  O   GLU    28      20.864  -3.396   4.146  1.00  5.45           O  
ATOM     74  CB  GLU    28      21.728  -2.584   1.075  1.00  5.35           C  
ATOM     75  CG  GLU    28      21.576  -3.230  -0.271  1.00  8.61           C  
ATOM     76  CD  GLU    28      21.516  -4.793  -0.207  1.00  7.80           C  
ATOM     77  OE1 GLU    28      22.246  -5.318   0.605  1.00 10.36           O  
ATOM     78  OE2 GLU    28      20.795  -5.361  -1.051  1.00 10.99           O  
ATOM     79  N   ASP    29      20.690  -1.170   3.804  1.00  4.63           N  
ATOM     80  CA  ASP    29      20.816  -0.894   5.215  1.00  5.09           C  
ATOM     81  C   ASP    29      19.659  -1.511   6.021  1.00  4.66           C  
ATOM     82  O   ASP    29      19.885  -2.069   7.101  1.00  5.52           O  
ATOM     83  CB  ASP    29      20.792   0.610   5.459  1.00  5.73           C  
ATOM     84  CG  ASP    29      21.998   1.390   4.943  1.00  5.96           C  
ATOM     85  OD1 ASP    29      23.097   0.801   4.810  1.00  9.45           O  
ATOM     86  OD2 ASP    29      21.791   2.606   4.675  1.00  6.58           O  
ATOM     87  N   MET    30      18.438  -1.378   5.486  1.00  4.52           N  
ATOM     88  CA  MET    30      17.275  -1.926   6.170  1.00  4.57           C  
ATOM     89  C   MET    30      17.290  -3.442   6.216  1.00  4.62           C  
ATOM     90  O   MET    30      16.909  -4.031   7.218  1.00  5.57           O  
ATOM     91  CB  MET    30      15.990  -1.409   5.534  1.00  4.62           C  
ATOM     92  CG  MET    30      15.744   0.062   5.760  1.00  4.73           C  
ATOM     93  SD  MET    30      15.580   0.571   7.603  0.90  5.90          SE  
ATOM     94  CE  MET    30      13.979  -0.293   7.946  1.00 10.68           C  
ATOM     95  N   LYS    31      17.771  -4.079   5.165  0.50  4.72           N  
ATOM     97  CA  LYS    31      17.941  -5.503   5.166  0.25  5.00           C  
ATOM    100  C   LYS    31      18.911  -5.892   6.320  0.50  4.65           C  
ATOM    102  O   LYS    31      18.659  -6.843   7.086  0.50  5.54           O  
ATOM    104  CB  LYS    31      18.436  -5.931   3.780  0.25  5.09           C  
ATOM    107  CG  LYS    31      18.633  -7.408   3.587  0.25  4.45           C  
ATOM    110  CD  LYS    31      19.621  -7.678   2.406  0.25  5.89           C  
ATOM    113  CE  LYS    31      18.982  -7.379   1.062  0.25  5.98           C  
ATOM    116  NZ  LYS    31      19.966  -7.513  -0.063  0.25  4.92           N  
ATOM    119  N   ARG    32      20.016  -5.189   6.457  0.80  5.55           N  
ATOM    121  CA  ARG    32      20.906  -5.475   7.551  0.80  7.17           C  
ATOM    123  C   ARG    32      20.232  -5.309   8.893  0.80  6.23           C  
ATOM    125  O   ARG    32      20.276  -6.181   9.765  0.80  7.14           O  
ATOM    127  CB  ARG    32      22.169  -4.635   7.440  0.80  8.36           C  
ATOM    129  CG  ARG    32      23.095  -5.165   6.360  0.80 11.35           C  
ATOM    131  CD  ARG    32      24.391  -4.363   6.278  0.80 15.69           C  
ATOM    133  NE  ARG    32      24.132  -3.113   5.578  0.80 22.23           N  
ATOM    135  CZ  ARG    32      24.689  -2.712   4.435  0.80 21.88           C  
ATOM    137  NH1 ARG    32      24.317  -1.537   3.898  0.80 19.62           N  
ATOM    139  NH2 ARG    32      25.626  -3.443   3.842  0.80 24.64           N  
ATOM    141  N   ILE    33      19.520  -4.204   9.045  1.00  5.62           N  
ATOM    142  CA  ILE    33      18.872  -3.915  10.333  1.00  5.84           C  
ATOM    143  C   ILE    33      17.838  -4.978  10.666  1.00  5.82           C  
ATOM    144  O   ILE    33      17.810  -5.485  11.796  1.00  6.61           O  
ATOM    145  CB  ILE    33      18.279  -2.507  10.301  1.00  6.44           C  
ATOM    146  CG1 ILE    33      19.414  -1.505  10.308  1.00  7.28           C  
ATOM    147  CG2 ILE    33      17.317  -2.274  11.453  1.00  8.16           C  
ATOM    148  CD1 ILE    33      18.996  -0.081   9.899  1.00  8.84           C  
ATOM    149  N   VAL    34      16.990  -5.341   9.707  1.00  5.88           N  
ATOM    150  CA  VAL    34      16.002  -6.368   9.967  1.00  6.66           C  
ATOM    151  C   VAL    34      16.670  -7.668  10.385  1.00  6.17           C  
ATOM    152  O   VAL    34      16.259  -8.310  11.351  1.00  7.34           O  
ATOM    153  CB  VAL    34      15.074  -6.537   8.746  1.00  7.43           C  
ATOM    154  CG1 VAL    34      14.163  -7.763   8.914  1.00  9.58           C  
ATOM    155  CG2 VAL    34      14.239  -5.264   8.563  1.00  8.70           C  
ATOM    156  N   GLY    35      17.738  -8.033   9.671  1.00  6.43           N  
ATOM    157  CA  GLY    35      18.439  -9.261   9.977  1.00  6.66           C  
ATOM    158  C   GLY    35      19.162  -9.306  11.311  1.00  6.57           C  
ATOM    159  O   GLY    35      19.486 -10.374  11.803  1.00  8.37           O  
ATOM    160  N   LYS    36      19.460  -8.140  11.881  1.00  6.29           N  
ATOM    161  CA  LYS    36      20.074  -8.045  13.201  0.25  6.74           C  
ATOM    164  C   LYS    36      19.111  -8.321  14.326  1.00  7.11           C  
ATOM    165  O   LYS    36      19.523  -8.692  15.430  1.00  8.42           O  
ATOM    166  CB  LYS    36      20.649  -6.659  13.450  0.25  7.30           C  
ATOM    169  CG  LYS    36      21.870  -6.372  12.639  0.25  7.35           C  
ATOM    172  CD  LYS    36      22.234  -4.913  12.683  0.25  7.90           C  
ATOM    175  CE  LYS    36      22.881  -4.526  14.003  0.25  6.97           C  
ATOM    178  NZ  LYS    36      23.143  -3.054  13.963  0.25  7.30           N  
ATOM    181  N   HIS    37      17.826  -8.110  14.096  1.00  7.61           N  
ATOM    182  CA  HIS    37      16.828  -8.314  15.165  1.00  8.62           C  
ATOM    183  C   HIS    37      17.270  -7.588  16.434  1.00  7.84           C  
ATOM    184  O   HIS    37      17.249  -8.164  17.524  1.00  8.43           O  
ATOM    185  CB  HIS    37      16.586  -9.818  15.436  1.00 10.04           C  
ATOM    186  CG  HIS    37      16.065 -10.524  14.232  1.00 11.70           C  
ATOM    187  ND1 HIS    37      14.752 -10.435  13.832  1.00 17.45           N  
ATOM    188  CD2 HIS    37      16.693 -11.224  13.259  1.00 12.70           C  
ATOM    189  CE1 HIS    37      14.590 -11.111  12.703  1.00 17.15           C  
ATOM    190  NE2 HIS    37      15.756 -11.604  12.337  1.00 14.42           N  
ATOM    191  N   ASP    38      17.670  -6.339  16.335  1.00  8.59           N  
ATOM    192  CA  ASP    38      18.203  -5.607  17.459  1.00  8.40           C  
ATOM    193  C   ASP    38      17.066  -5.247  18.402  1.00  8.57           C  
ATOM    194  O   ASP    38      16.109  -4.578  18.000  1.00  8.80           O  
ATOM    195  CB  ASP    38      18.850  -4.368  16.870  1.00 11.30           C  
ATOM    196  CG  ASP    38      19.619  -3.582  17.830  1.00 14.90           C  
ATOM    197  OD1 ASP    38      19.305  -3.575  19.031  1.00 13.89           O  
ATOM    198  OD2 ASP    38      20.525  -2.882  17.308  1.00 20.42           O  
ATOM    199  N   PRO    39      17.161  -5.670  19.671  1.00  9.42           N  
ATOM    200  CA  PRO    39      16.081  -5.410  20.604  1.00 10.88           C  
ATOM    201  C   PRO    39      15.866  -3.959  20.898  1.00 10.52           C  
ATOM    202  O   PRO    39      14.815  -3.569  21.460  1.00 13.03           O  
ATOM    203  CB  PRO    39      16.529  -6.159  21.854  1.00 11.33           C  
ATOM    204  CG  PRO    39      17.990  -6.224  21.786  1.00 12.34           C  
ATOM    205  CD  PRO    39      18.248  -6.420  20.316  1.00 11.01           C  
ATOM    206  N   ASN    40      16.849  -3.128  20.572  1.00  9.50           N  
ATOM    207  CA  ASN    40      16.758  -1.718  20.866  0.70  9.40           C  
ATOM    209  C   ASN    40      16.493  -0.844  19.622  1.00  8.33           C  
ATOM    210  O   ASN    40      16.728   0.358  19.653  1.00  8.99           O  
ATOM    211  CB  ASN    40      17.923  -1.351  21.740  0.70 11.15           C  
ATOM    213  CG  ASN    40      17.781  -1.941  23.175  0.70 12.91           C  
ATOM    215  OD1 ASN    40      16.695  -1.927  23.785  0.70 16.59           O  
ATOM    217  ND2 ASN    40      18.874  -2.447  23.692  0.70 19.60           N  
ATOM    219  N   VAL    41      15.951  -1.474  18.588  1.00  6.99           N  
ATOM    220  CA  VAL    41      15.496  -0.806  17.374  1.00  7.02           C  
ATOM    221  C   VAL    41      14.005  -1.096  17.203  1.00  5.94           C  
ATOM    222  O   VAL    41      13.545  -2.232  17.442  1.00  8.12           O  
ATOM    223  CB  VAL    41      16.280  -1.295  16.174  1.00  8.84           C  
ATOM    224  CG1 VAL    41      15.632  -0.818  14.857  1.00 11.68           C  
ATOM    225  CG2 VAL    41      17.745  -0.854  16.309  1.00 11.84           C  
ATOM    226  N   VAL    42      13.245  -0.066  16.842  1.00  5.37           N  
ATOM    227  CA  VAL    42      11.829  -0.165  16.581  1.00  5.48           C  
ATOM    228  C   VAL    42      11.588   0.308  15.157  1.00  4.86           C  
ATOM    229  O   VAL    42      12.012   1.394  14.793  1.00  5.55           O  
ATOM    230  CB  VAL    42      11.003   0.700  17.548  1.00  6.60           C  
ATOM    231  CG1 VAL    42       9.512   0.573  17.290  1.00  8.10           C  
ATOM    232  CG2 VAL    42      11.329   0.348  19.012  1.00  8.91           C  
ATOM    233  N   LEU    43      10.860  -0.510  14.397  0.50  4.63           N  
ATOM    235  CA  LEU    43      10.520  -0.219  12.994  0.50  4.37           C  
ATOM    237  C   LEU    43       9.110   0.354  12.991  0.50  3.98           C  
ATOM    239  O   LEU    43       8.134  -0.360  13.243  0.50  5.19           O  
ATOM    241  CB  LEU    43      10.568  -1.505  12.162  0.50  4.41           C  
ATOM    243  CG  LEU    43      11.927  -2.221  12.180  0.50  5.41           C  
ATOM    245  CD1 LEU    43      11.875  -3.496  11.343  0.50  8.93           C  
ATOM    247  CD2 LEU    43      13.037  -1.314  11.712  0.50  8.67           C  
ATOM    249  N   VAL    44       9.000   1.652  12.736  1.00  4.06           N  
ATOM    250  CA  VAL    44       7.740   2.378  12.881  1.00  4.25           C  
ATOM    251  C   VAL    44       7.147   2.669  11.506  1.00  3.95           C  
ATOM    252  O   VAL    44       7.555   3.581  10.806  1.00  4.41           O  
ATOM    253  CB  VAL    44       7.902   3.677  13.657  1.00  4.88           C  
ATOM    254  CG1 VAL    44       6.529   4.262  13.921  1.00  5.95           C  
ATOM    255  CG2 VAL    44       8.673   3.463  14.990  1.00  6.06           C  
ATOM    256  N   ASP    45       6.151   1.846  11.156  1.00  3.90           N  
ATOM    257  CA  ASP    45       5.442   1.950   9.890  1.00  3.71           C  
ATOM    258  C   ASP    45       4.191   2.777  10.142  1.00  3.91           C  
ATOM    259  O   ASP    45       3.299   2.388  10.900  1.00  4.37           O  
ATOM    260  CB  ASP    45       5.090   0.528   9.423  1.00  3.86           C  
ATOM    261  CG  ASP    45       4.448   0.448   8.065  1.00  4.16           C  
ATOM    262  OD1 ASP    45       3.766   1.386   7.622  1.00  4.52           O  
ATOM    263  OD2 ASP    45       4.619  -0.635   7.445  1.00  5.13           O  
ATOM    264  N   VAL    46       4.143   3.959   9.534  1.00  3.64           N  
ATOM    265  CA  VAL    46       3.064   4.909   9.809  1.00  3.77           C  
ATOM    266  C   VAL    46       2.029   4.957   8.685  1.00  4.00           C  
ATOM    267  O   VAL    46       1.222   5.882   8.626  1.00  4.07           O  
ATOM    268  CB  VAL    46       3.598   6.308  10.187  1.00  4.06           C  
ATOM    269  CG1 VAL    46       4.585   6.189  11.327  1.00  4.83           C  
ATOM    270  CG2 VAL    46       4.204   7.057   9.036  1.00  4.55           C  
ATOM    271  N   ARG    47       2.003   3.935   7.839  1.00  3.76           N  
ATOM    272  CA  ARG    47       0.884   3.772   6.921  1.00  3.93           C  
ATOM    273  C   ARG    47      -0.412   3.481   7.693  1.00  3.94           C  
ATOM    274  O   ARG    47      -0.403   3.207   8.893  1.00  4.15           O  
ATOM    275  CB  ARG    47       1.188   2.654   5.923  1.00  4.16           C  
ATOM    276  CG  ARG    47       2.367   2.950   5.015  1.00  4.41           C  
ATOM    277  CD  ARG    47       2.700   1.812   4.070  1.00  4.36           C  
ATOM    278  NE  ARG    47       3.029   0.614   4.852  1.00  4.91           N  
ATOM    279  CZ  ARG    47       2.867  -0.628   4.472  1.00  4.68           C  
ATOM    280  NH1 ARG    47       2.440  -0.932   3.273  1.00  6.72           N  
ATOM    281  NH2 ARG    47       3.136  -1.589   5.344  1.00  5.67           N  
ATOM    282  N   GLU    48      -1.532   3.555   6.981  1.00  4.09           N  
ATOM    283  CA  GLU    48      -2.806   3.203   7.583  1.00  4.53           C  
ATOM    284  C   GLU    48      -2.890   1.692   7.786  1.00  4.44           C  
ATOM    285  O   GLU    48      -2.183   0.927   7.132  1.00  4.87           O  
ATOM    286  CB  GLU    48      -3.978   3.702   6.752  1.00  4.95           C  
ATOM    287  CG  GLU    48      -4.072   5.230   6.741  1.00  5.30           C  
ATOM    288  CD  GLU    48      -4.203   5.796   8.148  1.00  5.46           C  
ATOM    289  OE1 GLU    48      -5.176   5.400   8.836  1.00  7.30           O  
ATOM    290  OE2 GLU    48      -3.321   6.546   8.603  1.00  5.88           O  
ATOM    291  N   PRO    49      -3.765   1.230   8.667  1.00  5.07           N  
ATOM    292  CA  PRO    49      -3.842  -0.216   8.944  1.00  5.88           C  
ATOM    293  C   PRO    49      -4.113  -1.065   7.703  1.00  5.59           C  
ATOM    294  O   PRO    49      -3.590  -2.164   7.577  1.00  6.38           O  
ATOM    295  CB  PRO    49      -4.937  -0.303  10.007  1.00  7.08           C  
ATOM    296  CG  PRO    49      -4.851   1.011  10.738  1.00  6.97           C  
ATOM    297  CD  PRO    49      -4.612   1.988   9.621  1.00  6.19           C  
ATOM    298  N   SER    50      -4.936  -0.567   6.778  1.00  6.07           N  
ATOM    299  CA  SER    50      -5.245  -1.286   5.570  1.00  6.89           C  
ATOM    300  C   SER    50      -4.005  -1.467   4.730  1.00  8.82           C  
ATOM    301  O   SER    50      -3.692  -2.647   4.387  1.00 11.66           O  
ATOM    302  CB  SER    50      -6.402  -0.583   4.864  1.00  8.18           C  
ATOM    303  OG  SER    50      -6.141   0.781   4.672  1.00  9.85           O  
ATOM    304  N   GLU    51      -3.183  -0.409   4.608  1.00  6.34           N  
ATOM    305  CA  GLU    51      -1.884  -0.514   3.894  1.00  6.38           C  
ATOM    306  C   GLU    51      -0.938  -1.517   4.559  1.00  6.84           C  
ATOM    307  O   GLU    51      -0.271  -2.363   3.937  1.00  9.87           O  
ATOM    308  CB  GLU    51      -1.187   0.833   3.816  1.00  6.45           C  
ATOM    309  CG  GLU    51      -1.825   1.884   2.936  1.00  6.93           C  
ATOM    310  CD  GLU    51      -1.213   3.265   3.116  1.00  6.09           C  
ATOM    311  OE1 GLU    51      -1.500   3.925   4.126  1.00  5.52           O  
ATOM    312  OE2 GLU    51      -0.401   3.683   2.254  1.00  7.55           O  
ATOM    313  N   TYR    52      -0.916  -1.495   5.874  0.50  6.32           N  
ATOM    315  CA  TYR    52      -0.057  -2.406   6.644  0.50  6.07           C  
ATOM    317  C   TYR    52      -0.470  -3.849   6.476  0.50  5.86           C  
ATOM    319  O   TYR    52       0.366  -4.768   6.534  0.50  7.51           O  
ATOM    321  CB  TYR    52      -0.144  -1.997   8.110  0.50  6.62           C  
ATOM    323  CG  TYR    52       0.892  -2.603   8.989  0.50  5.83           C  
ATOM    325  CD1 TYR    52       2.105  -1.968   9.173  0.50  6.83           C  
ATOM    327  CD2 TYR    52       0.642  -3.786   9.673  0.50  7.08           C  
ATOM    329  CE1 TYR    52       3.067  -2.478  10.005  0.50  5.81           C  
ATOM    331  CE2 TYR    52       1.565  -4.306  10.531  0.50  6.54           C  
ATOM    333  CZ  TYR    52       2.800  -3.670  10.674  0.50  5.84           C  
ATOM    335  OH  TYR    52       3.723  -4.245  11.535  0.50  7.40           O  
ATOM    337  N   SER    53      -1.764  -4.079   6.330  0.50  5.43           N  
ATOM    339  CA  SER    53      -2.219  -5.414   6.209  0.50  6.90           C  
ATOM    341  C   SER    53      -1.818  -5.969   4.833  0.50  6.17           C  
ATOM    343  O   SER    53      -1.635  -7.185   4.723  0.50  7.67           O  
ATOM    345  CB  SER    53      -3.697  -5.499   6.487  0.50  7.43           C  
ATOM    347  OG  SER    53      -4.418  -4.913   5.460  0.50 13.76           O  
ATOM    349  N   ILE    54      -1.678  -5.142   3.794  0.50  5.58           N  
ATOM    351  CA  ILE    54      -1.227  -5.645   2.484  0.50  5.83           C  
ATOM    353  C   ILE    54       0.166  -6.287   2.599  0.50  5.76           C  
ATOM    355  O   ILE    54       0.397  -7.379   2.078  0.50  6.45           O  
ATOM    357  CB  ILE    54      -1.212  -4.535   1.411  0.50  5.60           C  
ATOM    359  CG1 ILE    54      -2.635  -4.115   1.094  0.50  6.79           C  
ATOM    361  CG2 ILE    54      -0.463  -4.984   0.154  0.50  6.39           C  
ATOM    363  CD1 ILE    54      -2.804  -3.180   1.890  0.50  7.99           C  
ATOM    365  N   VAL    55       1.106  -5.554   3.200  0.50  5.87           N  
ATOM    367  CA  VAL    55       2.442  -6.139   3.379  0.50  7.15           C  
ATOM    369  C   VAL    55       3.172  -5.287   4.420  0.50  5.98           C  
ATOM    371  O   VAL    55       2.966  -4.089   4.462  0.50  7.84           O  
ATOM    373  CB  VAL    55       3.232  -6.295   2.008  0.50  7.51           C  
ATOM    375  CG1 VAL    55       4.737  -6.182   2.192  0.50  7.32           C  
ATOM    377  CG2 VAL    55       2.873  -7.584   1.140  0.50  6.68           C  
ATOM    379  N   HIS    56       4.011  -5.884   5.273  1.00  6.64           N  
ATOM    380  CA  HIS    56       4.737  -5.075   6.240  1.00  5.79           C  
ATOM    381  C   HIS    56       6.027  -5.801   6.574  1.00  6.24           C  
ATOM    382  O   HIS    56       6.199  -6.985   6.280  1.00  9.13           O  
ATOM    383  CB  HIS    56       3.907  -4.718   7.445  1.00  7.71           C  
ATOM    384  CG  HIS    56       3.388  -5.867   8.177  1.00  9.52           C  
ATOM    385  ND1 HIS    56       2.078  -6.258   8.044  1.00 11.75           N  
ATOM    386  CD2 HIS    56       3.958  -6.701   9.075  1.00 12.20           C  
ATOM    387  CE1 HIS    56       1.856  -7.287   8.843  1.00 15.12           C  
ATOM    388  NE2 HIS    56       2.981  -7.576   9.477  1.00 15.99           N  
ATOM    389  N   ILE    57       6.973  -5.068   7.148  1.00  6.13           N  
ATOM    390  CA  ILE    57       8.204  -5.694   7.595  1.00  6.83           C  
ATOM    391  C   ILE    57       7.907  -6.485   8.874  1.00  7.02           C  
ATOM    392  O   ILE    57       7.323  -5.947   9.816  1.00  6.76           O  
ATOM    393  CB  ILE    57       9.320  -4.677   7.801  1.00  7.12           C  
ATOM    394  CG1 ILE    57       9.588  -3.954   6.492  1.00  8.15           C  
ATOM    395  CG2 ILE    57      10.571  -5.370   8.357  1.00  8.78           C  
ATOM    396  CD1 ILE    57      10.670  -2.906   6.578  1.00  9.39           C  
ATOM    397  N   PRO    58       8.313  -7.760   8.977  1.00  9.09           N  
ATOM    398  CA  PRO    58       8.059  -8.494  10.204  1.00 10.43           C  
ATOM    399  C   PRO    58       8.647  -7.782  11.415  1.00 10.46           C  
ATOM    400  O   PRO    58       9.742  -7.269  11.374  1.00 10.73           O  
ATOM    401  CB  PRO    58       8.731  -9.853   9.936  1.00 12.37           C  
ATOM    402  CG  PRO    58       8.691 -10.013   8.501  1.00 13.37           C  
ATOM    403  CD  PRO    58       8.935  -8.605   7.965  1.00 10.81           C  
ATOM    404  N   ALA    59       7.887  -7.805  12.482  1.00 11.11           N  
ATOM    405  CA  ALA    59       8.284  -7.244  13.763  1.00 11.14           C  
ATOM    406  C   ALA    59       8.200  -5.727  13.826  1.00  9.23           C  
ATOM    407  O   ALA    59       8.397  -5.138  14.872  1.00 10.44           O  
ATOM    408  CB  ALA    59       9.698  -7.747  14.216  1.00 13.99           C  
ATOM    409  N   SER    60       7.815  -5.081  12.729  1.00  7.06           N  
ATOM    410  CA  SER    60       7.530  -3.662  12.795  1.00  6.07           C  
ATOM    411  C   SER    60       6.259  -3.429  13.583  1.00  6.01           C  
ATOM    412  O   SER    60       5.460  -4.349  13.789  1.00  8.98           O  
ATOM    413  CB  SER    60       7.393  -3.089  11.398  1.00  5.31           C  
ATOM    414  OG  SER    60       6.289  -3.649  10.675  1.00  5.74           O  
ATOM    415  N   ILE    61       6.068  -2.177  13.976  1.00  5.05           N  
ATOM    416  CA  ILE    61       4.824  -1.719  14.572  1.00  5.46           C  
ATOM    417  C   ILE    61       4.122  -0.783  13.606  1.00  5.12           C  
ATOM    418  O   ILE    61       4.739  -0.193  12.726  1.00  5.56           O  
ATOM    419  CB  ILE    61       5.039  -1.052  15.946  1.00  5.64           C  
ATOM    420  CG1 ILE    61       5.807   0.283  15.839  1.00  5.75           C  
ATOM    421  CG2 ILE    61       5.709  -2.048  16.890  1.00  7.78           C  
ATOM    422  CD1 ILE    61       5.872   1.051  17.154  1.00  6.86           C  
ATOM    423  N   ASN    62       2.803  -0.677  13.767  1.00  4.89           N  
ATOM    424  CA  ASN    62       2.000   0.213  12.928  1.00  4.46           C  
ATOM    425  C   ASN    62       1.446   1.326  13.813  1.00  4.77           C  
ATOM    426  O   ASN    62       0.697   1.089  14.746  1.00  5.91           O  
ATOM    427  CB  ASN    62       0.864  -0.577  12.297  1.00  5.06           C  
ATOM    428  CG  ASN    62       0.015   0.234  11.314  1.00  4.91           C  
ATOM    429  OD1 ASN    62      -1.194  -0.010  11.168  1.00  6.38           O  
ATOM    430  ND2 ASN    62       0.628   1.127  10.556  1.00  5.05           N  
ATOM    431  N   VAL    63       1.838   2.569  13.496  1.00  4.55           N  
ATOM    432  CA  VAL    63       1.373   3.747  14.230  1.00  4.66           C  
ATOM    433  C   VAL    63       0.883   4.753  13.178  1.00  4.33           C  
ATOM    434  O   VAL    63       1.630   5.624  12.737  1.00  4.71           O  
ATOM    435  CB  VAL    63       2.446   4.362  15.135  1.00  5.22           C  
ATOM    436  CG1 VAL    63       1.808   5.465  15.979  1.00  5.91           C  
ATOM    437  CG2 VAL    63       3.073   3.283  16.038  1.00  6.23           C  
ATOM    438  N   PRO    64      -0.344   4.573  12.704  1.00  4.83           N  
ATOM    439  CA  PRO    64      -0.790   5.313  11.517  1.00  4.78           C  
ATOM    440  C   PRO    64      -0.709   6.830  11.660  1.00  4.83           C  
ATOM    441  O   PRO    64      -1.275   7.421  12.588  1.00  6.06           O  
ATOM    442  CB  PRO    64      -2.251   4.860  11.361  1.00  5.14           C  
ATOM    443  CG  PRO    64      -2.277   3.459  11.971  1.00  5.58           C  
ATOM    444  CD  PRO    64      -1.339   3.569  13.143  1.00  5.10           C  
ATOM    445  N   TYR    65      -0.076   7.491  10.670  1.00  5.06           N  
ATOM    446  CA  TYR    65       0.092   8.927  10.739  1.00  5.19           C  
ATOM    447  C   TYR    65      -1.185   9.675  10.355  1.00  5.36           C  
ATOM    448  O   TYR    65      -1.579  10.595  11.046  1.00  7.60           O  
ATOM    449  CB  TYR    65       1.281   9.392   9.895  1.00  5.62           C  
ATOM    450  CG  TYR    65       1.492  10.869  10.029  1.00  6.04           C  
ATOM    451  CD1 TYR    65       2.015  11.401  11.191  1.00  7.21           C  
ATOM    452  CD2 TYR    65       1.139  11.743   9.009  1.00  8.62           C  
ATOM    453  CE1 TYR    65       2.153  12.796  11.360  1.00  9.84           C  
ATOM    454  CE2 TYR    65       1.266  13.094   9.180  1.00 11.40           C  
ATOM    455  CZ  TYR    65       1.774  13.607  10.349  1.00 11.36           C  
ATOM    456  OH  TYR    65       1.900  14.974  10.486  1.00 14.93           O  
ATOM    457  N   ARG    66      -1.813   9.271   9.256  1.00  5.70           N  
ATOM    458  CA  ARG    66      -3.018   9.939   8.772  1.00  5.86           C  
ATOM    459  C   ARG    66      -4.132   9.955   9.817  1.00  6.43           C  
ATOM    460  O   ARG    66      -4.778  10.980  10.033  1.00  7.67           O  
ATOM    461  CB  ARG    66      -3.515   9.278   7.485  1.00  7.66           C  
ATOM    462  CG  ARG    66      -2.882   9.831   6.219  1.00  9.54           C  
ATOM    463  CD  ARG    66      -3.332   9.054   4.992  0.80 10.84           C  
ATOM    464  NE  ARG    66      -4.733   9.306   4.668  0.80 12.36           N  
ATOM    465  CZ  ARG    66      -5.181  10.427   4.111  0.80 14.16           C  
ATOM    466  NH1 ARG    66      -4.337  11.405   3.812  0.80 15.06           N  
ATOM    467  NH2 ARG    66      -6.474  10.570   3.851  0.80 13.94           N  
ATOM    468  N   SER    67      -4.354   8.812  10.457  1.00  5.24           N  
ATOM    469  CA  SER    67      -5.410   8.673  11.435  1.00  6.08           C  
ATOM    470  C   SER    67      -4.985   8.938  12.877  1.00  5.88           C  
ATOM    471  O   SER    67      -5.865   9.124  13.718  1.00  7.16           O  
ATOM    472  CB  SER    67      -6.131   7.357  11.271  1.00  7.36           C  
ATOM    473  OG  SER    67      -5.238   6.289  11.344  1.00  7.49           O  
ATOM    474  N   HIS    68      -3.683   9.001  13.146  1.00  5.81           N  
ATOM    475  CA  HIS    68      -3.166   9.301  14.470  1.00  5.91           C  
ATOM    476  C   HIS    68      -1.916  10.180  14.349  1.00  6.23           C  
ATOM    477  O   HIS    68      -0.826   9.782  14.789  1.00  6.38           O  
ATOM    478  CB  HIS    68      -2.854   8.020  15.266  1.00  6.58           C  
ATOM    479  CG  HIS    68      -4.033   7.179  15.481  1.00  7.46           C  
ATOM    480  ND1 HIS    68      -4.919   7.414  16.510  1.00  9.92           N  
ATOM    481  CD2 HIS    68      -4.511   6.113  14.809  1.00  9.74           C  
ATOM    482  CE1 HIS    68      -5.871   6.505  16.481  1.00 11.96           C  
ATOM    483  NE2 HIS    68      -5.663   5.721  15.446  1.00 12.70           N  
ATOM    484  N   PRO    69      -2.026  11.385  13.790  1.00  6.13           N  
ATOM    485  CA  PRO    69      -0.813  12.188  13.545  1.00  7.07           C  
ATOM    486  C   PRO    69      -0.095  12.626  14.799  1.00  7.79           C  
ATOM    487  O   PRO    69       1.109  12.919  14.777  1.00  8.93           O  
ATOM    488  CB  PRO    69      -1.340  13.372  12.727  1.00  8.41           C  
ATOM    489  CG  PRO    69      -2.792  13.472  13.133  1.00  8.62           C  
ATOM    490  CD  PRO    69      -3.242  12.017  13.256  1.00  6.77           C  
ATOM    491  N   ASP    70      -0.849  12.745  15.889  1.00  7.90           N  
ATOM    492  CA  ASP    70      -0.346  13.087  17.215  1.00  8.22           C  
ATOM    493  C   ASP    70       0.132  11.927  18.035  1.00  7.09           C  
ATOM    494  O   ASP    70       0.483  12.131  19.181  1.00  7.91           O  
ATOM    495  CB  ASP    70      -1.478  13.778  18.044  1.00 10.32           C  
ATOM    496  CG  ASP    70      -2.756  12.887  18.175  1.00 12.66           C  
ATOM    497  OD1 ASP    70      -3.048  11.961  17.282  1.00 14.07           O  
ATOM    498  OD2 ASP    70      -3.526  13.205  19.139  1.00 16.93           O  
ATOM    499  N   ALA    71       0.154  10.710  17.485  1.00  6.89           N  
ATOM    500  CA  ALA    71       0.447   9.557  18.291  1.00  6.32           C  
ATOM    501  C   ALA    71       1.741   9.730  19.085  1.00  6.32           C  
ATOM    502  O   ALA    71       1.769   9.444  20.275  1.00  7.16           O  
ATOM    503  CB  ALA    71       0.578   8.305  17.425  1.00  6.74           C  
ATOM    504  N   PHE    72       2.802  10.196  18.434  1.00  6.20           N  
ATOM    505  CA  PHE    72       4.073  10.262  19.117  1.00  7.02           C  
ATOM    506  C   PHE    72       4.212  11.418  20.090  1.00  7.74           C  
ATOM    507  O   PHE    72       5.256  11.532  20.740  1.00 10.61           O  
ATOM    508  CB  PHE    72       5.243  10.170  18.140  1.00  7.43           C  
ATOM    509  CG  PHE    72       5.489   8.744  17.714  1.00  6.23           C  
ATOM    510  CD1 PHE    72       6.156   7.881  18.577  1.00  7.50           C  
ATOM    511  CD2 PHE    72       4.989   8.235  16.536  1.00  6.47           C  
ATOM    512  CE1 PHE    72       6.307   6.551  18.286  1.00  8.63           C  
ATOM    513  CE2 PHE    72       5.152   6.905  16.222  1.00  7.11           C  
ATOM    514  CZ  PHE    72       5.818   6.051  17.110  1.00  7.95           C  
ATOM    515  N   ALA    73       3.145  12.208  20.247  1.00  7.31           N  
ATOM    516  CA  ALA    73       3.045  13.231  21.275  1.00  7.83           C  
ATOM    517  C   ALA    73       2.231  12.763  22.470  1.00  8.56           C  
ATOM    518  O   ALA    73       2.118  13.492  23.459  1.00 10.70           O  
ATOM    519  CB  ALA    73       2.427  14.503  20.703  1.00  8.88           C  
ATOM    520  N   LEU    74       1.663  11.562  22.436  1.00  8.50           N  
ATOM    521  CA  LEU    74       0.816  11.092  23.525  1.00  8.80           C  
ATOM    522  C   LEU    74       1.620  10.491  24.656  1.00  9.91           C  
ATOM    523  O   LEU    74       2.640   9.858  24.443  1.00 10.83           O  
ATOM    524  CB  LEU    74      -0.150  10.018  22.995  1.00  8.41           C  
ATOM    525  CG  LEU    74      -1.070  10.473  21.874  1.00  8.90           C  
ATOM    526  CD1 LEU    74      -1.903   9.312  21.360  1.00  9.06           C  
ATOM    527  CD2 LEU    74      -1.951  11.640  22.293  1.00 11.36           C  
ATOM    528  N   ASP    75       1.115  10.654  25.867  1.00 11.38           N  
ATOM    529  CA  ASP    75       1.714   9.953  27.007  1.00 12.23           C  
ATOM    530  C   ASP    75       1.473   8.439  26.878  1.00 12.37           C  
ATOM    531  O   ASP    75       0.653   8.004  26.055  1.00 11.95           O  
ATOM    532  CB  ASP    75       1.199  10.509  28.320  1.00 13.44           C  
ATOM    533  CG  ASP    75      -0.207  10.092  28.612  1.00 14.52           C  
ATOM    534  OD1 ASP    75      -0.532   8.884  28.631  1.00 16.72           O  
ATOM    535  OD2 ASP    75      -1.035  10.981  28.899  1.00 19.77           O  
ATOM    536  N   PRO    76       2.218   7.611  27.630  1.00 12.93           N  
ATOM    537  CA  PRO    76       2.115   6.172  27.427  1.00 12.29           C  
ATOM    538  C   PRO    76       0.723   5.586  27.570  1.00 11.45           C  
ATOM    539  O   PRO    76       0.365   4.743  26.799  1.00 11.34           O  
ATOM    540  CB  PRO    76       3.095   5.570  28.451  1.00 14.68           C  
ATOM    541  CG  PRO    76       4.083   6.674  28.688  1.00 16.39           C  
ATOM    542  CD  PRO    76       3.253   7.942  28.619  1.00 14.93           C  
ATOM    543  N   LEU    77      -0.045   6.002  28.562  1.00 10.97           N  
ATOM    544  CA  LEU    77      -1.364   5.431  28.769  0.50 10.50           C  
ATOM    546  C   LEU    77      -2.304   5.801  27.614  1.00  9.42           C  
ATOM    547  O   LEU    77      -3.022   4.952  27.069  1.00 10.45           O  
ATOM    548  CB  LEU    77      -1.905   5.875  30.124  0.50 10.23           C  
ATOM    550  CG  LEU    77      -3.269   5.313  30.499  0.50 10.33           C  
ATOM    552  CD1 LEU    77      -3.195   3.841  30.874  0.50 14.10           C  
ATOM    554  CD2 LEU    77      -3.853   6.131  31.674  0.50 11.65           C  
ATOM    556  N   GLU    78      -2.276   7.058  27.222  1.00  9.30           N  
ATOM    557  CA  GLU    78      -3.131   7.528  26.153  1.00  8.89           C  
ATOM    558  C   GLU    78      -2.703   6.953  24.798  1.00  7.55           C  
ATOM    559  O   GLU    78      -3.558   6.630  23.968  1.00  8.67           O  
ATOM    560  CB  GLU    78      -3.136   9.070  26.108  1.00  9.48           C  
ATOM    561  CG  GLU    78      -4.079   9.689  25.083  1.00  9.79           C  
ATOM    562  CD  GLU    78      -5.572   9.520  25.386  1.00 10.38           C  
ATOM    563  OE1 GLU    78      -5.933   8.992  26.458  1.00 11.33           O  
ATOM    564  OE2 GLU    78      -6.367   9.941  24.556  1.00 13.54           O  
ATOM    565  N   PHE    79      -1.391   6.776  24.603  1.00  7.74           N  
ATOM    566  CA  PHE    79      -0.913   6.141  23.386  1.00  7.31           C  
ATOM    567  C   PHE    79      -1.551   4.750  23.236  1.00  7.50           C  
ATOM    568  O   PHE    79      -2.054   4.388  22.179  1.00  7.68           O  
ATOM    569  CB  PHE    79       0.607   6.044  23.434  1.00  7.67           C  
ATOM    570  CG  PHE    79       1.240   5.532  22.145  1.00  7.10           C  
ATOM    571  CD1 PHE    79       1.872   6.387  21.292  1.00  7.29           C  
ATOM    572  CD2 PHE    79       1.204   4.181  21.839  1.00  6.60           C  
ATOM    573  CE1 PHE    79       2.464   5.922  20.117  1.00  7.50           C  
ATOM    574  CE2 PHE    79       1.787   3.721  20.654  1.00  7.36           C  
ATOM    575  CZ  PHE    79       2.419   4.600  19.803  1.00  6.66           C  
ATOM    576  N   GLU    80      -1.492   3.937  24.285  0.90  8.14           N  
ATOM    578  CA  GLU    80      -2.037   2.611  24.153  0.90  8.94           C  
ATOM    580  C   GLU    80      -3.550   2.654  23.958  0.90  8.49           C  
ATOM    582  O   GLU    80      -4.090   1.869  23.167  0.90  9.26           O  
ATOM    584  CB  GLU    80      -1.626   1.736  25.323  0.90 10.94           C  
ATOM    586  CG  GLU    80      -1.923   0.274  25.125  0.90 12.87           C  
ATOM    588  CD  GLU    80      -3.316  -0.153  25.486  0.90 14.79           C  
ATOM    590  OE1 GLU    80      -4.032   0.611  26.163  0.90 15.76           O  
ATOM    592  OE2 GLU    80      -3.714  -1.266  25.086  0.90 19.69           O  
ATOM    594  N   LYS    81      -4.261   3.592  24.590  1.00  8.78           N  
ATOM    595  CA  LYS    81      -5.687   3.674  24.333  0.50  9.31           C  
ATOM    597  C   LYS    81      -5.995   4.025  22.884  1.00  8.87           C  
ATOM    598  O   LYS    81      -6.964   3.487  22.310  1.00 10.43           O  
ATOM    599  CB  LYS    81      -6.329   4.673  25.282  0.50  9.93           C  
ATOM    601  CG  LYS    81      -6.331   4.204  26.709  0.50 10.96           C  
ATOM    603  CD  LYS    81      -6.819   5.341  27.592  0.50 10.36           C  
ATOM    605  CE  LYS    81      -6.945   4.955  29.026  0.50 12.69           C  
ATOM    607  NZ  LYS    81      -7.100   6.159  29.871  0.50 14.18           N  
ATOM    609  N   GLN    82      -5.227   4.943  22.298  1.00  8.48           N  
ATOM    610  CA  GLN    82      -5.507   5.384  20.963  1.00  9.68           C  
ATOM    611  C   GLN    82      -5.016   4.414  19.894  1.00  9.17           C  
ATOM    612  O   GLN    82      -5.688   4.225  18.883  1.00 11.34           O  
ATOM    613  CB  GLN    82      -4.922   6.776  20.759  1.00  9.86           C  
ATOM    614  CG  GLN    82      -5.607   7.856  21.696  1.00 12.49           C  
ATOM    615  CD  GLN    82      -7.154   8.042  21.566  1.00 12.54           C  
ATOM    616  OE1 GLN    82      -7.666   7.875  20.483  1.00 15.24           O  
ATOM    617  NE2 GLN    82      -7.876   8.429  22.678  1.00 13.84           N  
ATOM    618  N   ILE    83      -3.822   3.860  20.083  1.00  8.72           N  
ATOM    619  CA  ILE    83      -3.164   3.062  19.059  1.00  9.26           C  
ATOM    620  C   ILE    83      -3.360   1.578  19.272  1.00  9.94           C  
ATOM    621  O   ILE    83      -3.348   0.837  18.311  1.00 13.92           O  
ATOM    622  CB  ILE    83      -1.645   3.402  19.021  1.00  9.41           C  
ATOM    623  CG1 ILE    83      -1.436   4.907  18.950  1.00  9.94           C  
ATOM    624  CG2 ILE    83      -0.943   2.713  17.844  1.00 11.05           C  
ATOM    625  CD1 ILE    83      -2.063   5.618  17.779  1.00 12.33           C  
ATOM    626  N   GLY    84      -3.539   1.147  20.507  1.00  9.29           N  
ATOM    627  CA  GLY    84      -3.753  -0.257  20.814  1.00  9.83           C  
ATOM    628  C   GLY    84      -2.526  -1.096  21.078  1.00  8.85           C  
ATOM    629  O   GLY    84      -2.663  -2.302  21.251  1.00 11.00           O  
ATOM    630  N   ILE    85      -1.352  -0.462  21.076  1.00  8.30           N  
ATOM    631  CA  ILE    85      -0.096  -1.089  21.387  1.00  8.21           C  
ATOM    632  C   ILE    85       0.649  -0.160  22.333  1.00  7.46           C  
ATOM    633  O   ILE    85       0.338   1.017  22.432  1.00  8.38           O  
ATOM    634  CB  ILE    85       0.740  -1.363  20.121  1.00  8.29           C  
ATOM    635  CG1 ILE    85       1.120  -0.054  19.416  1.00  9.73           C  
ATOM    636  CG2 ILE    85      -0.003  -2.340  19.247  1.00 10.74           C  
ATOM    637  CD1 ILE    85       2.112  -0.267  18.259  1.00  9.86           C  
ATOM    638  N   PRO    86       1.667  -0.664  23.035  1.00  8.01           N  
ATOM    639  CA  PRO    86       2.420   0.178  23.961  1.00  8.48           C  
ATOM    640  C   PRO    86       3.224   1.241  23.235  1.00  7.80           C  
ATOM    641  O   PRO    86       3.724   1.044  22.119  1.00  8.34           O  
ATOM    642  CB  PRO    86       3.371  -0.806  24.686  1.00  9.49           C  
ATOM    643  CG  PRO    86       2.688  -2.111  24.531  1.00 10.38           C  
ATOM    644  CD  PRO    86       2.083  -2.063  23.155  1.00  9.31           C  
ATOM    645  N   LYS    87       3.379   2.362  23.912  1.00  7.88           N  
ATOM    646  CA  LYS    87       4.205   3.432  23.386  0.80  7.54           C  
ATOM    648  C   LYS    87       5.662   2.981  23.347  1.00  7.42           C  
ATOM    649  O   LYS    87       6.183   2.482  24.333  1.00  9.42           O  
ATOM    650  CB  LYS    87       4.082   4.659  24.274  0.80  8.13           C  
ATOM    652  CG  LYS    87       4.787   5.864  23.700  0.80  8.63           C  
ATOM    654  CD  LYS    87       4.604   7.123  24.546  0.80  9.77           C  
ATOM    656  CE  LYS    87       5.343   8.336  23.983  0.80 10.65           C  
ATOM    658  NZ  LYS    87       5.318   9.490  24.914  0.80 11.03           N  
ATOM    660  N   PRO    88       6.331   3.144  22.204  1.00  7.30           N  
ATOM    661  CA  PRO    88       7.716   2.702  22.136  1.00  7.45           C  
ATOM    662  C   PRO    88       8.601   3.365  23.170  1.00  7.42           C  
ATOM    663  O   PRO    88       8.466   4.563  23.469  1.00  7.76           O  
ATOM    664  CB  PRO    88       8.143   3.094  20.709  1.00  7.68           C  
ATOM    665  CG  PRO    88       6.881   3.004  19.944  1.00  7.88           C  
ATOM    666  CD  PRO    88       5.839   3.552  20.883  1.00  7.34           C  
ATOM    667  N   ASP    89       9.566   2.605  23.642  1.00  7.78           N  
ATOM    668  CA  ASP    89      10.569   3.092  24.598  1.00  8.01           C  
ATOM    669  C   ASP    89      11.435   4.166  23.945  1.00  8.28           C  
ATOM    670  O   ASP    89      12.072   3.906  22.923  1.00  8.32           O  
ATOM    671  CB  ASP    89      11.394   1.859  24.977  1.00  8.92           C  
ATOM    672  CG  ASP    89      12.533   2.113  25.924  1.00 10.72           C  
ATOM    673  OD1 ASP    89      12.864   3.262  26.257  1.00 11.95           O  
ATOM    674  OD2 ASP    89      13.097   1.085  26.356  1.00 14.30           O  
ATOM    675  N   SER    90      11.500   5.358  24.568  1.00  9.48           N  
ATOM    676  CA  SER    90      12.265   6.445  23.983  1.00 10.63           C  
ATOM    677  C   SER    90      13.765   6.240  23.999  1.00  9.42           C  
ATOM    678  O   SER    90      14.475   6.999  23.351  1.00 11.63           O  
ATOM    679  CB  SER    90      11.887   7.770  24.542  1.00 12.89           C  
ATOM    680  OG  SER    90      12.243   7.774  25.888  1.00 16.17           O  
ATOM    681  N   ALA    91      14.256   5.246  24.718  1.00  8.51           N  
ATOM    682  CA  ALA    91      15.673   4.933  24.711  1.00  9.11           C  
ATOM    683  C   ALA    91      16.074   4.196  23.446  1.00  9.07           C  
ATOM    684  O   ALA    91      17.265   4.072  23.186  1.00 11.24           O  
ATOM    685  CB  ALA    91      16.038   4.059  25.935  1.00 11.22           C  
ATOM    686  N   LYS    92      15.119   3.662  22.690  1.00  7.03           N  
ATOM    687  CA  LYS    92      15.414   2.895  21.501  0.80  6.87           C  
ATOM    689  C   LYS    92      15.581   3.804  20.298  1.00  6.20           C  
ATOM    690  O   LYS    92      15.169   4.952  20.297  1.00  7.57           O  
ATOM    691  CB  LYS    92      14.282   1.913  21.255  0.80  6.68           C  
ATOM    693  CG  LYS    92      14.211   0.818  22.325  0.80  7.06           C  
ATOM    695  CD  LYS    92      13.161  -0.217  21.984  0.80  8.08           C  
ATOM    697  CE  LYS    92      12.977  -1.320  23.013  0.80  8.53           C  
ATOM    699  NZ  LYS    92      11.985  -2.316  22.548  0.80 11.35           N  
ATOM    701  N   GLU    93      16.183   3.243  19.247  1.00  5.90           N  
ATOM    702  CA  GLU    93      16.205   3.883  17.943  1.00  5.79           C  
ATOM    703  C   GLU    93      14.889   3.566  17.219  1.00  5.43           C  
ATOM    704  O   GLU    93      14.588   2.397  16.996  1.00  7.19           O  
ATOM    705  CB  GLU    93      17.352   3.361  17.083  1.00  6.18           C  
ATOM    706  CG  GLU    93      17.389   3.990  15.724  1.00  6.50           C  
ATOM    707  CD  GLU    93      18.444   3.443  14.778  1.00  6.24           C  
ATOM    708  OE1 GLU    93      19.138   2.477  15.111  1.00  9.44           O  
ATOM    709  OE2 GLU    93      18.548   3.999  13.660  1.00  8.01           O  
ATOM    710  N   LEU    94      14.129   4.590  16.868  1.00  5.30           N  
ATOM    711  CA  LEU    94      12.891   4.411  16.116  1.00  4.81           C  
ATOM    712  C   LEU    94      13.163   4.809  14.664  1.00  4.73           C  
ATOM    713  O   LEU    94      13.650   5.920  14.412  1.00  5.65           O  
ATOM    714  CB  LEU    94      11.770   5.294  16.661  1.00  5.24           C  
ATOM    715  CG  LEU    94      10.963   4.701  17.820  1.00  5.62           C  
ATOM    716  CD1 LEU    94      11.836   4.382  19.069  1.00  7.25           C  
ATOM    717  CD2 LEU    94       9.819   5.638  18.164  1.00  6.54           C  
ATOM    718  N   ILE    95      12.858   3.911  13.738  1.00  4.22           N  
ATOM    719  CA  ILE    95      13.091   4.118  12.314  1.00  4.07           C  
ATOM    720  C   ILE    95      11.732   4.295  11.644  1.00  3.87           C  
ATOM    721  O   ILE    95      10.928   3.375  11.649  1.00  4.97           O  
ATOM    722  CB  ILE    95      13.833   2.949  11.678  1.00  4.36           C  
ATOM    723  CG1 ILE    95      15.110   2.625  12.432  1.00  5.35           C  
ATOM    724  CG2 ILE    95      14.112   3.267  10.202  1.00  5.16           C  
ATOM    725  CD1 ILE    95      15.873   1.393  11.877  1.00  6.26           C  
ATOM    726  N   PHE    96      11.484   5.473  11.080  1.00  4.13           N  
ATOM    727  CA  PHE    96      10.177   5.827  10.575  1.00  4.04           C  
ATOM    728  C   PHE    96      10.083   5.688   9.061  1.00  4.15           C  
ATOM    729  O   PHE    96      11.003   6.076   8.322  1.00  4.70           O  
ATOM    730  CB  PHE    96       9.885   7.294  10.893  1.00  4.72           C  
ATOM    731  CG  PHE    96       9.654   7.529  12.339  1.00  5.07           C  
ATOM    732  CD1 PHE    96       8.369   7.496  12.872  1.00  6.51           C  
ATOM    733  CD2 PHE    96      10.724   7.742  13.206  1.00  5.56           C  
ATOM    734  CE1 PHE    96       8.177   7.695  14.230  1.00  7.88           C  
ATOM    735  CE2 PHE    96      10.517   7.917  14.571  1.00  6.93           C  
ATOM    736  CZ  PHE    96       9.247   7.863  15.061  1.00  7.62           C  
ATOM    737  N   TYR    97       8.931   5.210   8.592  1.00  3.99           N  
ATOM    738  CA  TYR    97       8.671   5.113   7.146  1.00  3.91           C  
ATOM    739  C   TYR    97       7.169   4.947   6.933  1.00  3.74           C  
ATOM    740  O   TYR    97       6.413   4.602   7.837  1.00  3.98           O  
ATOM    741  CB  TYR    97       9.448   3.952   6.517  1.00  4.23           C  
ATOM    742  CG  TYR    97       9.224   2.625   7.182  1.00  4.19           C  
ATOM    743  CD1 TYR    97       8.214   1.771   6.749  1.00  4.31           C  
ATOM    744  CD2 TYR    97      10.004   2.192   8.242  1.00  4.31           C  
ATOM    745  CE1 TYR    97       7.995   0.562   7.342  1.00  4.59           C  
ATOM    746  CE2 TYR    97       9.792   0.986   8.870  1.00  4.85           C  
ATOM    747  CZ  TYR    97       8.791   0.143   8.414  1.00  4.56           C  
ATOM    748  OH  TYR    97       8.607  -1.063   9.024  1.00  5.52           O  
ATOM    749  N   CYS    98       6.783   5.140   5.676  1.00  3.72           N  
ATOM    750  CA  CYS    98       5.397   4.924   5.250  1.00  3.59           C  
ATOM    751  C   CYS    98       5.423   4.123   3.933  1.00  3.45           C  
ATOM    752  O   CYS    98       5.981   3.034   3.901  1.00  3.84           O  
ATOM    753  CB  CYS    98       4.589   6.248   5.230  1.00  4.07           C  
ATOM    754  SG  CYS    98       5.270   7.526   4.165  1.00  4.60           S  
ATOM    755  N   ALA    99       4.783   4.671   2.880  1.00  3.83           N  
ATOM    756  CA  ALA    99       4.796   4.067   1.537  1.00  3.72           C  
ATOM    757  C   ALA    99       5.854   4.781   0.691  1.00  3.81           C  
ATOM    758  O   ALA    99       6.824   4.156   0.284  1.00  4.15           O  
ATOM    759  CB  ALA    99       3.424   4.128   0.902  1.00  5.74           C  
ATOM    760  N   SER   100       5.676   6.088   0.457  1.00  4.26           N  
ATOM    761  CA  SER   100       6.620   6.835  -0.338  1.00  4.84           C  
ATOM    762  C   SER   100       7.540   7.758   0.462  1.00  4.52           C  
ATOM    763  O   SER   100       8.467   8.328  -0.107  1.00  5.77           O  
ATOM    764  CB  SER   100       5.938   7.644  -1.446  1.00  6.55           C  
ATOM    765  OG  SER   100       5.015   8.529  -0.959  1.00  8.80           O  
ATOM    766  N   GLY   101       7.314   7.906   1.771  1.00  4.88           N  
ATOM    767  CA  GLY   101       8.192   8.612   2.672  1.00  5.06           C  
ATOM    768  C   GLY   101       7.637   9.843   3.357  1.00  4.71           C  
ATOM    769  O   GLY   101       8.158  10.230   4.392  1.00  5.18           O  
ATOM    770  N   LYS   102       6.632  10.512   2.802  1.00  5.31           N  
ATOM    771  CA  LYS   102       6.226  11.814   3.373  1.00  6.25           C  
ATOM    772  C   LYS   102       5.700  11.667   4.789  1.00  5.42           C  
ATOM    773  O   LYS   102       6.060  12.433   5.699  1.00  6.42           O  
ATOM    774  CB  LYS   102       5.200  12.508   2.515  1.00  8.24           C  
ATOM    775  CG  LYS   102       4.808  13.881   3.067  1.00 10.22           C  
ATOM    776  CD  LYS   102       3.960  14.679   2.127  0.50 10.43           C  
ATOM    777  CE  LYS   102       3.301  15.880   2.790  0.50 13.54           C  
ATOM    778  NZ  LYS   102       2.750  16.816   1.809  0.50 16.32           N  
ATOM    779  N   ARG   103       4.762  10.724   4.983  1.00  4.79           N  
ATOM    780  CA  ARG   103       4.191  10.545   6.297  1.00  4.54           C  
ATOM    781  C   ARG   103       5.241  10.072   7.294  1.00  4.28           C  
ATOM    782  O   ARG   103       5.224  10.482   8.458  1.00  5.11           O  
ATOM    783  CB  ARG   103       3.024   9.571   6.249  1.00  4.67           C  
ATOM    784  CG  ARG   103       1.852  10.087   5.414  1.00  5.46           C  
ATOM    785  CD  ARG   103       0.837   9.001   5.183  1.00  5.48           C  
ATOM    786  NE  ARG   103       1.316   7.999   4.254  1.00  5.57           N  
ATOM    787  CZ  ARG   103       0.726   6.850   3.969  1.00  5.15           C  
ATOM    788  NH1 ARG   103      -0.286   6.420   4.709  1.00  4.82           N  
ATOM    789  NH2 ARG   103       1.152   6.098   2.963  1.00  6.22           N  
ATOM    790  N   GLY   104       6.137   9.177   6.867  1.00  4.65           N  
ATOM    791  CA  GLY   104       7.238   8.775   7.731  1.00  4.55           C  
ATOM    792  C   GLY   104       8.055   9.972   8.228  1.00  4.53           C  
ATOM    793  O   GLY   104       8.400  10.055   9.396  1.00  5.29           O  
ATOM    794  N   GLY   105       8.347  10.892   7.330  1.00  4.88           N  
ATOM    795  CA  GLY   105       9.103  12.061   7.706  1.00  5.31           C  
ATOM    796  C   GLY   105       8.352  12.934   8.699  1.00  5.73           C  
ATOM    797  O   GLY   105       8.940  13.479   9.652  1.00  6.59           O  
ATOM    798  N   GLU   106       7.047  13.085   8.492  1.00  5.79           N  
ATOM    799  CA  GLU   106       6.205  13.877   9.404  0.50  5.78           C  
ATOM    801  C   GLU   106       6.175  13.251  10.786  1.00  6.15           C  
ATOM    802  O   GLU   106       6.249  13.937  11.814  1.00  6.87           O  
ATOM    803  CB  GLU   106       4.765  13.993   8.877  0.50  6.72           C  
ATOM    805  CG  GLU   106       4.634  14.891   7.660  0.50  8.74           C  
ATOM    807  CD  GLU   106       5.250  16.297   7.896  0.50 14.10           C  
ATOM    809  OE1 GLU   106       4.916  16.926   8.912  0.50 16.14           O  
ATOM    811  OE2 GLU   106       6.111  16.740   7.110  0.50 19.81           O  
ATOM    813  N   ALA   107       5.983  11.939  10.825  1.00  5.63           N  
ATOM    814  CA  ALA   107       5.923  11.239  12.109  1.00  5.97           C  
ATOM    815  C   ALA   107       7.241  11.310  12.844  1.00  5.28           C  
ATOM    816  O   ALA   107       7.269  11.486  14.078  1.00  6.07           O  
ATOM    817  CB  ALA   107       5.495   9.790  11.883  1.00  5.83           C  
ATOM    818  N   GLN   108       8.352  11.222  12.129  1.00  5.35           N  
ATOM    819  CA  GLN   108       9.671  11.355  12.746  0.70  5.95           C  
ATOM    821  C   GLN   108       9.785  12.708  13.434  1.00  6.34           C  
ATOM    822  O   GLN   108      10.346  12.803  14.531  1.00  7.57           O  
ATOM    823  CB  GLN   108      10.782  11.166  11.705  0.70  5.79           C  
ATOM    825  CG  GLN   108      12.180  11.200  12.277  0.70  6.62           C  
ATOM    827  CD  GLN   108      12.804  12.599  12.514  0.70  7.05           C  
ATOM    829  OE1 GLN   108      13.714  12.746  13.386  0.70  9.86           O  
ATOM    831  NE2 GLN   108      12.353  13.592  11.818  0.70  6.57           N  
ATOM    833  N   LYS   109       9.268  13.749  12.815  1.00  6.66           N  
ATOM    834  CA  LYS   109       9.332  15.086  13.406  1.00  7.47           C  
ATOM    835  C   LYS   109       8.516  15.163  14.677  1.00  6.95           C  
ATOM    836  O   LYS   109       8.923  15.820  15.652  1.00  8.43           O  
ATOM    837  CB  LYS   109       8.865  16.128  12.410  1.00  8.40           C  
ATOM    838  CG  LYS   109       9.899  16.414  11.334  1.00 11.98           C  
ATOM    839  CD  LYS   109       9.420  17.302  10.199  1.00 13.99           C  
ATOM    840  CE  LYS   109      10.580  17.684   9.279  0.80 14.86           C  
ATOM    841  NZ  LYS   109      10.223  18.249   7.939  0.80 18.08           N  
ATOM    842  N   VAL   110       7.334  14.526  14.696  1.00  6.46           N  
ATOM    843  CA  VAL   110       6.543  14.498  15.923  1.00  7.30           C  
ATOM    844  C   VAL   110       7.335  13.809  17.030  1.00  6.59           C  
ATOM    845  O   VAL   110       7.450  14.315  18.141  1.00  7.66           O  
ATOM    846  CB  VAL   110       5.179  13.805  15.707  1.00  6.81           C  
ATOM    847  CG1 VAL   110       4.413  13.739  17.034  1.00  7.86           C  
ATOM    848  CG2 VAL   110       4.360  14.519  14.638  1.00  8.53           C  
ATOM    849  N   ALA   111       7.878  12.634  16.736  1.00  6.25           N  
ATOM    850  CA  ALA   111       8.587  11.898  17.775  1.00  6.44           C  
ATOM    851  C   ALA   111       9.813  12.662  18.294  1.00  6.55           C  
ATOM    852  O   ALA   111      10.037  12.764  19.497  1.00  7.23           O  
ATOM    853  CB  ALA   111       9.000  10.502  17.233  1.00  6.91           C  
ATOM    854  N   SER   112      10.597  13.198  17.371  1.00  6.91           N  
ATOM    855  CA  SER   112      11.838  13.856  17.755  0.50  7.97           C  
ATOM    857  C   SER   112      11.569  15.119  18.578  1.00  8.71           C  
ATOM    858  O   SER   112      12.402  15.486  19.385  1.00 11.07           O  
ATOM    859  CB  SER   112      12.717  14.152  16.530  0.50  8.49           C  
ATOM    861  OG  SER   112      12.096  15.095  15.671  0.50  9.64           O  
ATOM    863  N   SER   113      10.403  15.745  18.391  1.00  8.30           N  
ATOM    864  CA  SER   113       9.935  16.916  19.134  0.50  9.12           C  
ATOM    866  C   SER   113       9.259  16.563  20.456  1.00  8.56           C  
ATOM    867  O   SER   113       8.882  17.467  21.204  1.00  9.94           O  
ATOM    868  CB  SER   113       8.898  17.677  18.288  0.50 10.45           C  
ATOM    870  OG  SER   113       9.490  18.283  17.156  0.50 15.37           O  
ATOM    872  N   HIS   114       9.023  15.281  20.705  1.00  7.79           N  
ATOM    873  CA  HIS   114       8.324  14.809  21.885  1.00  7.83           C  
ATOM    874  C   HIS   114       9.069  13.713  22.609  1.00  8.28           C  
ATOM    875  O   HIS   114       8.496  12.745  23.090  1.00  9.87           O  
ATOM    876  CB  HIS   114       6.869  14.400  21.562  1.00  8.35           C  
ATOM    877  CG  HIS   114       6.066  15.538  21.049  1.00  8.39           C  
ATOM    878  ND1 HIS   114       5.234  16.370  21.762  1.00 12.03           N  
ATOM    879  CD2 HIS   114       6.042  15.973  19.773  1.00  7.75           C  
ATOM    880  CE1 HIS   114       4.721  17.262  20.921  1.00 10.24           C  
ATOM    881  NE2 HIS   114       5.197  17.037  19.714  1.00 13.52           N  
ATOM    882  N   GLY   115      10.379  13.904  22.750  1.00  8.04           N  
ATOM    883  CA  GLY   115      11.136  13.101  23.678  1.00  8.92           C  
ATOM    884  C   GLY   115      11.885  11.910  23.143  1.00  8.53           C  
ATOM    885  O   GLY   115      12.534  11.202  23.936  1.00 10.87           O  
ATOM    886  N   TYR   116      11.865  11.699  21.818  1.00  7.42           N  
ATOM    887  CA  TYR   116      12.617  10.613  21.237  1.00  7.88           C  
ATOM    888  C   TYR   116      13.886  11.204  20.645  1.00  8.36           C  
ATOM    889  O   TYR   116      13.867  11.829  19.596  1.00  9.94           O  
ATOM    890  CB  TYR   116      11.822   9.904  20.128  1.00  7.27           C  
ATOM    891  CG  TYR   116      10.689   9.086  20.672  1.00  7.06           C  
ATOM    892  CD1 TYR   116      10.880   7.750  20.961  1.00  7.23           C  
ATOM    893  CD2 TYR   116       9.420   9.641  20.909  1.00  7.09           C  
ATOM    894  CE1 TYR   116       9.852   6.944  21.464  1.00  7.42           C  
ATOM    895  CE2 TYR   116       8.399   8.858  21.410  1.00  7.13           C  
ATOM    896  CZ  TYR   116       8.609   7.514  21.683  1.00  7.28           C  
ATOM    897  OH  TYR   116       7.548   6.756  22.143  1.00  8.85           O  
ATOM    898  N   SER   117      15.012  10.963  21.308  1.00  9.24           N  
ATOM    899  CA  SER   117      16.310  11.508  20.932  0.50  9.26           C  
ATOM    901  C   SER   117      17.024  10.669  19.883  1.00  9.18           C  
ATOM    902  O   SER   117      18.034  11.122  19.359  1.00 10.73           O  
ATOM    903  CB  SER   117      17.222  11.640  22.154  0.50 10.04           C  
ATOM    905  OG  SER   117      17.610  10.398  22.671  0.50 12.56           O  
ATOM    907  N   ASN   118      16.547   9.429  19.632  1.00  7.59           N  
ATOM    908  CA  ASN   118      17.230   8.515  18.705  1.00  7.19           C  
ATOM    909  C   ASN   118      16.214   8.080  17.660  1.00  6.53           C  
ATOM    910  O   ASN   118      15.453   7.130  17.866  1.00  7.15           O  
ATOM    911  CB  ASN   118      17.828   7.313  19.399  1.00  8.35           C  
ATOM    912  CG  ASN   118      18.776   6.576  18.487  1.00  9.59           C  
ATOM    913  OD1 ASN   118      18.841   6.865  17.290  1.00 12.34           O  
ATOM    914  ND2 ASN   118      19.470   5.588  18.999  1.00 12.25           N  
ATOM    915  N   THR   119      16.127   8.854  16.591  1.00  6.94           N  
ATOM    916  CA  THR   119      15.179   8.577  15.541  1.00  6.53           C  
ATOM    917  C   THR   119      15.901   8.628  14.190  1.00  6.38           C  
ATOM    918  O   THR   119      16.911   9.327  14.010  1.00  7.96           O  
ATOM    919  CB  THR   119      14.000   9.574  15.490  1.00  7.22           C  
ATOM    920  OG1 THR   119      14.473  10.889  15.205  1.00  9.42           O  
ATOM    921  CG2 THR   119      13.226   9.594  16.807  1.00  8.55           C  
ATOM    922  N   SER   120      15.368   7.863  13.253  1.00  5.51           N  
ATOM    923  CA  SER   120      15.944   7.677  11.949  1.00  5.29           C  
ATOM    924  C   SER   120      14.853   7.551  10.920  1.00  4.26           C  
ATOM    925  O   SER   120      13.678   7.376  11.252  1.00  4.97           O  
ATOM    926  CB  SER   120      16.805   6.411  11.921  1.00  6.20           C  
ATOM    927  OG  SER   120      17.765   6.453  12.944  1.00  7.62           O  
ATOM    928  N   LEU   121      15.250   7.606   9.645  1.00  4.46           N  
ATOM    929  CA  LEU   121      14.317   7.455   8.521  0.80  4.26           C  
ATOM    931  C   LEU   121      14.733   6.291   7.643  1.00  4.09           C  
ATOM    932  O   LEU   121      15.920   6.048   7.412  1.00  5.18           O  
ATOM    933  CB  LEU   121      14.326   8.671   7.606  0.80  5.48           C  
ATOM    935  CG  LEU   121      13.854   9.969   8.202  0.80  5.51           C  
ATOM    937  CD1 LEU   121      14.135  11.139   7.266  0.80  8.67           C  
ATOM    939  CD2 LEU   121      12.370   9.905   8.512  0.80  6.72           C  
ATOM    941  N   TYR   122      13.726   5.629   7.100  1.00  3.94           N  
ATOM    942  CA  TYR   122      13.872   4.763   5.921  1.00  3.85           C  
ATOM    943  C   TYR   122      13.156   5.523   4.806  1.00  3.66           C  
ATOM    944  O   TYR   122      11.966   5.342   4.588  1.00  4.17           O  
ATOM    945  CB  TYR   122      13.247   3.394   6.157  1.00  3.95           C  
ATOM    946  CG  TYR   122      13.202   2.471   4.976  1.00  3.68           C  
ATOM    947  CD1 TYR   122      12.279   1.443   4.940  1.00  4.04           C  
ATOM    948  CD2 TYR   122      14.062   2.599   3.885  1.00  4.06           C  
ATOM    949  CE1 TYR   122      12.268   0.524   3.918  1.00  4.09           C  
ATOM    950  CE2 TYR   122      14.050   1.692   2.831  1.00  3.91           C  
ATOM    951  CZ  TYR   122      13.129   0.649   2.841  1.00  4.07           C  
ATOM    952  OH  TYR   122      13.077  -0.285   1.855  1.00  4.47           O  
ATOM    953  N   PRO   123      13.849   6.463   4.142  1.00  4.14           N  
ATOM    954  CA  PRO   123      13.138   7.375   3.237  1.00  4.65           C  
ATOM    955  C   PRO   123      12.396   6.651   2.119  1.00  4.10           C  
ATOM    956  O   PRO   123      11.326   7.076   1.718  1.00  5.12           O  
ATOM    957  CB  PRO   123      14.255   8.307   2.719  1.00  6.56           C  
ATOM    958  CG  PRO   123      15.395   7.915   3.287  1.00 10.08           C  
ATOM    959  CD  PRO   123      15.273   6.827   4.251  1.00  4.12           C  
ATOM    960  N   GLY   124      13.015   5.604   1.575  1.00  4.01           N  
ATOM    961  CA  GLY   124      12.403   4.887   0.494  1.00  4.35           C  
ATOM    962  C   GLY   124      11.110   4.194   0.879  1.00  3.60           C  
ATOM    963  O   GLY   124      10.226   3.980   0.046  1.00  3.88           O  
ATOM    964  N   SER   125      11.007   3.833   2.160  1.00  3.30           N  
ATOM    965  CA  SER   125       9.769   3.381   2.742  1.00  3.33           C  
ATOM    966  C   SER   125       9.300   2.067   2.099  1.00  3.27           C  
ATOM    967  O   SER   125      10.076   1.348   1.484  1.00  3.48           O  
ATOM    968  CB  SER   125       8.736   4.510   2.729  1.00  4.01           C  
ATOM    969  OG  SER   125       9.097   5.537   3.667  1.00  4.43           O  
ATOM    970  N   MET   126       8.020   1.709   2.316  1.00  3.33           N  
ATOM    971  CA  MET   126       7.588   0.395   1.839  0.80  3.44           C  
ATOM    973  C   MET   126       7.575   0.294   0.330  1.00  3.61           C  
ATOM    974  O   MET   126       7.699  -0.811  -0.213  1.00  4.24           O  
ATOM    975  CB  MET   126       6.249   0.002   2.467  0.80  4.02           C  
ATOM    977  CG  MET   126       6.343  -0.301   3.941  0.80  4.27           C  
ATOM    979  SD  MET   126       7.499  -1.795   4.379  0.80  5.51          SE  
ATOM    981  CE  MET   126       6.491  -3.168   3.482  0.80  6.80           C  
ATOM    983  N   ASN   127       7.471   1.417  -0.400  1.00  3.55           N  
ATOM    984  CA  ASN   127       7.586   1.335  -1.845  1.00  3.71           C  
ATOM    985  C   ASN   127       8.975   0.824  -2.210  1.00  3.64           C  
ATOM    986  O   ASN   127       9.127  -0.021  -3.093  1.00  4.42           O  
ATOM    987  CB  ASN   127       7.349   2.703  -2.504  1.00  4.44           C  
ATOM    988  CG  ASN   127       5.915   3.143  -2.465  1.00  4.85           C  
ATOM    989  OD1 ASN   127       5.029   2.508  -1.890  1.00  5.85           O  
ATOM    990  ND2 ASN   127       5.677   4.330  -3.077  1.00  6.65           N  
ATOM    991  N   ASP   128       9.999   1.360  -1.545  1.00  3.44           N  
ATOM    992  CA  ASP   128      11.362   0.913  -1.764  1.00  3.90           C  
ATOM    993  C   ASP   128      11.535  -0.552  -1.367  1.00  3.51           C  
ATOM    994  O   ASP   128      12.152  -1.352  -2.094  1.00  4.13           O  
ATOM    995  CB  ASP   128      12.301   1.824  -0.996  1.00  4.05           C  
ATOM    996  CG  ASP   128      13.769   1.443  -1.119  1.00  4.04           C  
ATOM    997  OD1 ASP   128      14.484   2.115  -1.899  1.00  5.33           O  
ATOM    998  OD2 ASP   128      14.185   0.505  -0.411  1.00  4.84           O  
ATOM    999  N   TRP   129      10.978  -0.923  -0.224  1.00  3.58           N  
ATOM   1000  CA  TRP   129      11.118  -2.279   0.279  1.00  3.68           C  
ATOM   1001  C   TRP   129      10.575  -3.272  -0.747  1.00  3.61           C  
ATOM   1002  O   TRP   129      11.252  -4.235  -1.148  1.00  4.41           O  
ATOM   1003  CB  TRP   129      10.394  -2.398   1.619  1.00  4.11           C  
ATOM   1004  CG  TRP   129      10.558  -3.726   2.308  1.00  3.84           C  
ATOM   1005  CD1 TRP   129       9.614  -4.693   2.432  1.00  4.29           C  
ATOM   1006  CD2 TRP   129      11.708  -4.178   3.064  1.00  4.09           C  
ATOM   1007  NE1 TRP   129      10.093  -5.730   3.205  1.00  4.47           N  
ATOM   1008  CE2 TRP   129      11.373  -5.436   3.599  1.00  4.27           C  
ATOM   1009  CE3 TRP   129      12.972  -3.633   3.353  1.00  4.65           C  
ATOM   1010  CZ2 TRP   129      12.278  -6.175   4.380  1.00  5.21           C  
ATOM   1011  CZ3 TRP   129      13.864  -4.361   4.102  1.00  5.69           C  
ATOM   1012  CH2 TRP   129      13.501  -5.624   4.611  1.00  5.59           C  
ATOM   1013  N   VAL   130       9.339  -3.042  -1.194  1.00  3.61           N  
ATOM   1014  CA  VAL   130       8.708  -3.942  -2.145  1.00  3.83           C  
ATOM   1015  C   VAL   130       9.390  -3.851  -3.511  1.00  4.04           C  
ATOM   1016  O   VAL   130       9.563  -4.874  -4.197  1.00  4.86           O  
ATOM   1017  CB  VAL   130       7.210  -3.665  -2.222  1.00  4.37           C  
ATOM   1018  CG1 VAL   130       6.529  -4.415  -3.377  1.00  5.73           C  
ATOM   1019  CG2 VAL   130       6.574  -4.015  -0.888  1.00  5.44           C  
ATOM   1020  N   SER   131       9.816  -2.682  -3.959  1.00  4.33           N  
ATOM   1021  CA  SER   131      10.509  -2.554  -5.230  0.50  4.63           C  
ATOM   1024  C   SER   131      11.725  -3.462  -5.309  1.00  4.94           C  
ATOM   1025  O   SER   131      12.048  -3.979  -6.379  1.00  7.00           O  
ATOM   1026  CB  SER   131      10.977  -1.105  -5.462  0.50  5.09           C  
ATOM   1029  OG  SER   131       9.891  -0.247  -5.776  0.50  4.79           O  
ATOM   1032  N   HIS   132      12.434  -3.601  -4.190  1.00  4.09           N  
ATOM   1033  CA  HIS   132      13.653  -4.387  -4.120  1.00  5.00           C  
ATOM   1034  C   HIS   132      13.407  -5.825  -3.700  1.00  5.16           C  
ATOM   1035  O   HIS   132      14.366  -6.579  -3.546  1.00  6.97           O  
ATOM   1036  CB  HIS   132      14.651  -3.741  -3.159  1.00  6.29           C  
ATOM   1037  CG  HIS   132      15.173  -2.425  -3.605  1.00  7.34           C  
ATOM   1038  ND1 HIS   132      14.569  -1.247  -3.294  1.00  8.04           N  
ATOM   1039  CD2 HIS   132      16.276  -2.083  -4.305  1.00 12.11           C  
ATOM   1040  CE1 HIS   132      15.249  -0.241  -3.804  1.00 10.56           C  
ATOM   1041  NE2 HIS   132      16.280  -0.718  -4.447  1.00 13.22           N  
ATOM   1042  N   GLY   133      12.154  -6.207  -3.489  1.00  5.03           N  
ATOM   1043  CA  GLY   133      11.806  -7.578  -3.156  1.00  5.84           C  
ATOM   1044  C   GLY   133      11.894  -7.915  -1.668  1.00  5.32           C  
ATOM   1045  O   GLY   133      11.886  -9.110  -1.321  1.00  5.03           O  
ATOM   1046  N   GLY   134      11.909  -6.905  -0.802  1.00  5.00           N  
ATOM   1047  CA  GLY   134      11.989  -7.156   0.610  1.00  5.55           C  
ATOM   1048  C   GLY   134      10.906  -8.023   1.172  1.00  4.95           C  
ATOM   1049  O   GLY   134      11.122  -8.750   2.153  1.00  5.96           O  
ATOM   1050  N   ASP   135       9.725  -7.953   0.591  1.00  5.67           N  
ATOM   1051  CA  ASP   135       8.617  -8.770   1.049  1.00  6.29           C  
ATOM   1052  C   ASP   135       8.818 -10.273   0.822  1.00  5.75           C  
ATOM   1053  O   ASP   135       8.085 -11.067   1.405  1.00  7.57           O  
ATOM   1054  CB  ASP   135       7.307  -8.294   0.391  1.00  7.45           C  
ATOM   1055  CG  ASP   135       7.385  -8.341  -1.120  1.00  8.12           C  
ATOM   1056  OD1 ASP   135       8.281  -7.699  -1.702  1.00  7.76           O  
ATOM   1057  OD2 ASP   135       6.580  -9.093  -1.739  1.00 13.52           O  
ATOM   1058  N   LYS   136       9.807 -10.636  -0.010  1.00  4.79           N  
ATOM   1059  CA  LYS   136      10.115 -12.031  -0.256  0.50  4.79           C  
ATOM   1061  C   LYS   136      11.260 -12.555   0.618  1.00  5.02           C  
ATOM   1062  O   LYS   136      11.670 -13.713   0.474  1.00  5.04           O  
ATOM   1063  CB  LYS   136      10.482 -12.246  -1.718  0.50  4.93           C  
ATOM   1065  CG  LYS   136       9.422 -11.816  -2.688  0.50  4.76           C  
ATOM   1067  CD  LYS   136       8.058 -12.371  -2.399  0.50  5.14           C  
ATOM   1069  CE  LYS   136       7.081 -12.233  -3.537  0.50  6.88           C  
ATOM   1071  NZ  LYS   136       7.051 -10.800  -4.022  0.50  7.26           N  
ATOM   1073  N   LEU   137      11.803 -11.706   1.487  1.00  5.59           N  
ATOM   1074  CA  LEU   137      12.840 -12.118   2.406  1.00  5.41           C  
ATOM   1075  C   LEU   137      12.245 -12.825   3.617  1.00  6.68           C  
ATOM   1076  O   LEU   137      11.058 -12.684   3.923  1.00  8.80           O  
ATOM   1077  CB  LEU   137      13.636 -10.911   2.889  1.00  5.66           C  
ATOM   1078  CG  LEU   137      14.328 -10.125   1.761  1.00  5.65           C  
ATOM   1079  CD1 LEU   137      14.925  -8.864   2.331  1.00  7.54           C  
ATOM   1080  CD2 LEU   137      15.411 -10.949   1.085  1.00  7.87           C  
ATOM   1081  N   ASP   138      13.096 -13.562   4.315  1.00  6.41           N  
ATOM   1082  CA  ASP   138      12.745 -14.216   5.555  1.00  7.90           C  
ATOM   1083  C   ASP   138      13.943 -14.092   6.510  1.00  8.72           C  
ATOM   1084  O   ASP   138      14.589 -15.076   6.851  1.00 12.84           O  
ATOM   1085  CB  ASP   138      12.391 -15.698   5.280  1.00  9.13           C  
ATOM   1086  CG  ASP   138      11.835 -16.421   6.470  1.00 11.58           C  
ATOM   1087  OD1 ASP   138      11.324 -15.777   7.390  1.00 15.42           O  
ATOM   1088  OD2 ASP   138      11.913 -17.655   6.525  1.00 14.90           O  
ATOM   1089  N   LEU   139      14.265 -12.876   6.930  1.00 11.14           N  
ATOM   1090  CA  LEU   139      15.484 -12.587   7.712  1.00 12.59           C  
ATOM   1091  C   LEU   139      15.303 -12.694   9.201  1.00 15.51           C  
ATOM   1092  O   LEU   139      14.166 -12.670   9.679  1.00 16.67           O  
ATOM   1093  CB  LEU   139      15.978 -11.192   7.404  1.00 14.21           C  
ATOM   1094  CG  LEU   139      16.279 -10.807   5.972  1.00 15.95           C  
ATOM   1095  CD1 LEU   139      16.667  -9.342   5.909  1.00 18.14           C  
ATOM   1096  CD2 LEU   139      17.346 -11.740   5.432  1.00 19.85           C  
ATOM   1097  OXT LEU   139      16.299 -12.751   9.943  1.00 18.29           O  
END
