
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 ( 1783),  selected  110 , name 2k0z_A
# Molecule2: number of CA atoms  120 (  935),  selected  120 , name T0411.pdb
# PARAMETERS: 2k0z_A.T0411.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      S      20          4.504
LGA    L     2_A      N      21          4.831
LGA    E     3_A      I      22          2.887
LGA    D     4_A      Q      23          2.972
LGA    Y     5_A      -       -           -
LGA    A     6_A      S      24          1.745
LGA    I     7_A      Y      25          1.751
LGA    S     8_A      S      26          2.018
LGA    L     9_A      F      27          1.685
LGA    E    10_A      E      28          2.977
LGA    E    11_A      D      29          2.141
LGA    V    12_A      M      30          2.099
LGA    N    13_A      K      31          3.839
LGA    -       -      R      32           -
LGA    F    14_A      I      33          3.734
LGA    N    15_A      V      34          2.085
LGA    -       -      G      35           -
LGA    -       -      K      36           -
LGA    D    16_A      H      37          4.312
LGA    -       -      D      38           -
LGA    -       -      P      39           -
LGA    -       -      N      40           -
LGA    F    17_A      V      41          2.982
LGA    I    18_A      V      42          2.189
LGA    V    19_A      L      43          1.129
LGA    V    20_A      V      44          1.637
LGA    D    21_A      D      45          1.191
LGA    V    22_A      V      46          1.017
LGA    R    23_A      R      47          1.005
LGA    E    24_A      E      48          0.523
LGA    L    25_A      P      49          1.078
LGA    D    26_A      S      50          1.121
LGA    E    27_A      E      51          0.594
LGA    Y    28_A      Y      52          0.335
LGA    E    29_A      S      53          0.863
LGA    E    30_A      I      54          0.939
LGA    L    31_A      V      55          0.925
LGA    H    32_A      H      56          0.679
LGA    L    33_A      I      57          0.995
LGA    P    34_A      P      58          1.307
LGA    N    35_A      A      59          1.125
LGA    A    36_A      S      60          1.409
LGA    T    37_A      I      61          0.795
LGA    L    38_A      N      62          1.080
LGA    I    39_A      V      63          0.914
LGA    S    40_A      P      64          1.248
LGA    V    41_A      Y      65          1.958
LGA    N    42_A      R      66          3.579
LGA    -       -      S      67           -
LGA    D    43_A      H      68          2.014
LGA    Q    44_A      P      69          3.775
LGA    E    45_A      D      70          3.807
LGA    K    46_A      A      71          2.938
LGA    L    47_A      F      72          3.297
LGA    A    48_A      A      73          4.187
LGA    -       -      L      74           -
LGA    -       -      D      75           -
LGA    -       -      P      76           -
LGA    -       -      L      77           -
LGA    -       -      E      78           -
LGA    -       -      F      79           -
LGA    -       -      E      80           -
LGA    -       -      K      81           -
LGA    -       -      Q      82           -
LGA    -       -      I      83           -
LGA    -       -      G      84           -
LGA    -       -      I      85           -
LGA    D    49_A      P      86           #
LGA    F    50_A      K      87          2.054
LGA    L    51_A      P      88          3.468
LGA    S    52_A      -       -           -
LGA    Q    53_A      -       -           -
LGA    H    54_A      D      89          1.876
LGA    K    55_A      S      90          0.906
LGA    D    56_A      A      91          0.674
LGA    K    57_A      K      92          1.044
LGA    K    58_A      E      93          2.068
LGA    V    59_A      L      94          2.135
LGA    L    60_A      I      95          1.501
LGA    L    61_A      F      96          1.540
LGA    H    62_A      Y      97          2.507
LGA    C    63_A      C      98          2.118
LGA    R    64_A      A      99          1.572
LGA    A    65_A      S     100          1.794
LGA    G    66_A      G     101          2.046
LGA    R    67_A      K     102          2.224
LGA    R    68_A      R     103          1.856
LGA    A    69_A      G     104          1.708
LGA    L    70_A      G     105          1.378
LGA    D    71_A      E     106          1.375
LGA    A    72_A      A     107          0.780
LGA    A    73_A      Q     108          0.283
LGA    K    74_A      K     109          1.333
LGA    S    75_A      V     110          1.827
LGA    M    76_A      A     111          1.361
LGA    H    77_A      S     112          1.107
LGA    E    78_A      S     113          1.603
LGA    L    79_A      H     114          1.656
LGA    G    80_A      G     115          2.835
LGA    Y    81_A      Y     116          1.418
LGA    T    82_A      S     117          2.847
LGA    -       -      N     118           -
LGA    P    83_A      T     119          1.992
LGA    Y    84_A      S     120          1.596
LGA    Y    85_A      L     121          1.848
LGA    L    86_A      Y     122          0.764
LGA    E    87_A      P     123          1.422
LGA    G    88_A      G     124          1.809
LGA    -       -      S     125           -
LGA    -       -      M     126           -
LGA    -       -      N     127           -
LGA    N    89_A      D     128          1.596
LGA    V    90_A      W     129          3.577
LGA    Y    91_A      V     130          1.366
LGA    D    92_A      S     131          2.828
LGA    -       -      H     132           -
LGA    F    93_A      G     133          4.789
LGA    E    94_A      G     134          1.799
LGA    K    95_A      D     135           #
LGA    Y    96_A      -       -           -
LGA    G    97_A      -       -           -
LGA    F    98_A      K     136           #
LGA    R    99_A      L     137          2.918
LGA    M   100_A      D     138           #
LGA    V   101_A      L     139           -
LGA    Y   102_A      -       -           -
LGA    D   103_A      -       -           -
LGA    D   104_A      -       -           -
LGA    T   105_A      -       -           -
LGA    C   106_A      -       -           -
LGA    D   107_A      -       -           -
LGA    K   108_A      -       -           -
LGA    K   109_A      -       -           -
LGA    N   110_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110  120    5.0     91    2.22    23.08     61.167     3.931

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.099241 * X  +   0.139550 * Y  +  -0.985229 * Z  +   8.872393
  Y_new =  -0.532864 * X  +   0.828731 * Y  +   0.171058 * Z  +   2.985755
  Z_new =   0.840361 * X  +   0.541969 * Y  +  -0.007883 * Z  +   9.791599 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.585340   -1.556252  [ DEG:    90.8333    -89.1667 ]
  Theta =  -0.997950   -2.143643  [ DEG:   -57.1783   -122.8217 ]
  Phi   =  -1.754928    1.386665  [ DEG:  -100.5500     79.4500 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2k0z_A                                        
REMARK     2: T0411.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2k0z_A.T0411.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110  120   5.0   91   2.22   23.08  61.167
REMARK  ---------------------------------------------------------- 
MOLECULE 2k0z_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-FEB-08   2K0Z              
TITLE     SOLUTION NMR STRUCTURE OF PROTEIN HP1203 FROM HELICOBACTER            
TITLE    2 PYLORI 26695. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM               
TITLE    3 (NESG) TARGET PT1/ONTARIO CENTER FOR STRUCTURAL PROTEOMICS           
TITLE    4 TARGET HP1203                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN HP1203;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HELICOBACTER PYLORI 26695;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 26695;                                                       
SOURCE   5 ATCC: 700392;                                                        
SOURCE   6 GENE: HP_1223;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: P11                                       
KEYWDS    A/B DOMAIN, STRUCTURAL GENOMICS, UNKNOWN FUNCTION, PSI-2,             
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS          
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    B.WU,A.YEE,A.LEMAK,J.CORT,A.SEMEST,M.A.KENNEY,                        
AUTHOR   2 C.H.ARROWSMITH,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM              
AUTHOR   3 (NESG)                                                               
REVDAT   1   04-MAR-08 2K0Z    0                                                
JRNL        AUTH   B.WU,A.YEE,A.LEMAK,J.CORT,A.SEMEST,M.A.KENNEY,               
JRNL        AUTH 2 C.H.ARROWSMITH                                               
JRNL        TITL   SOLUTION NMR STRUCTURE OF PROTEIN HP1203 FROM                
JRNL        TITL 2 HELICOBACTER PYLORI 26695. NORTHEAST STRUCTURAL              
JRNL        TITL 3 GENOMICS CONSORTIUM (NESG) TARGET PT1/ONTARIO                
JRNL        TITL 4 CENTER FOR STRUCTURAL PROTEOMICS TARGET HP1203.              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2K0Z A    1   110  UNP    O25821   O25821_HELPY     1    110             
SEQRES   1 A  110  MET LEU GLU ASP TYR ALA ILE SER LEU GLU GLU VAL ASN          
SEQRES   2 A  110  PHE ASN ASP PHE ILE VAL VAL ASP VAL ARG GLU LEU ASP          
SEQRES   3 A  110  GLU TYR GLU GLU LEU HIS LEU PRO ASN ALA THR LEU ILE          
SEQRES   4 A  110  SER VAL ASN ASP GLN GLU LYS LEU ALA ASP PHE LEU SER          
SEQRES   5 A  110  GLN HIS LYS ASP LYS LYS VAL LEU LEU HIS CYS ARG ALA          
SEQRES   6 A  110  GLY ARG ARG ALA LEU ASP ALA ALA LYS SER MET HIS GLU          
SEQRES   7 A  110  LEU GLY TYR THR PRO TYR TYR LEU GLU GLY ASN VAL TYR          
SEQRES   8 A  110  ASP PHE GLU LYS TYR GLY PHE ARG MET VAL TYR ASP ASP          
SEQRES   9 A  110  THR CYS ASP LYS LYS ASN                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      19.164  17.951  12.320  1.00  0.00           N  
ATOM      2  CA  MET A   1      19.308  16.872  13.321  1.00  0.00           C  
ATOM      3  C   MET A   1      19.101  15.497  12.655  1.00  0.00           C  
ATOM      4  O   MET A   1      20.056  14.734  12.474  1.00  0.00           O  
ATOM      5  CB  MET A   1      18.316  17.063  14.508  1.00  0.00           C  
ATOM      6  CG  MET A   1      18.424  15.989  15.615  1.00  0.00           C  
ATOM      7  SD  MET A   1      17.090  16.057  16.838  1.00  0.00           S  
ATOM      8  CE  MET A   1      17.311  17.657  17.603  1.00  0.00           C  
ATOM      9  H1  MET A   1      18.254  17.869  11.832  1.00  0.00           H  
ATOM     10  H2  MET A   1      19.928  17.895  11.617  1.00  0.00           H  
ATOM     11  H3  MET A   1      19.209  18.884  12.785  1.00  0.00           H  
ATOM     12  HA  MET A   1      20.325  16.924  13.707  1.00  0.00           H  
ATOM     13  HB2 MET A   1      18.495  18.031  14.962  1.00  0.00           H  
ATOM     14  HB3 MET A   1      17.304  17.048  14.124  1.00  0.00           H  
ATOM     15  HG2 MET A   1      18.404  15.010  15.154  1.00  0.00           H  
ATOM     16  HG3 MET A   1      19.370  16.114  16.131  1.00  0.00           H  
ATOM     17  HE1 MET A   1      16.551  17.804  18.358  1.00  0.00           H  
ATOM     18  HE2 MET A   1      17.226  18.430  16.854  1.00  0.00           H  
ATOM     19  HE3 MET A   1      18.287  17.708  18.063  1.00  0.00           H  
ATOM     20  N   LEU A   2      17.845  15.199  12.240  1.00  0.00           N  
ATOM     21  CA  LEU A   2      17.446  13.819  11.852  1.00  0.00           C  
ATOM     22  C   LEU A   2      17.827  13.456  10.399  1.00  0.00           C  
ATOM     23  O   LEU A   2      17.475  12.378   9.918  1.00  0.00           O  
ATOM     24  CB  LEU A   2      15.936  13.557  12.121  1.00  0.00           C  
ATOM     25  CG  LEU A   2      14.894  14.008  11.046  1.00  0.00           C  
ATOM     26  CD1 LEU A   2      13.494  13.491  11.414  1.00  0.00           C  
ATOM     27  CD2 LEU A   2      14.868  15.531  10.845  1.00  0.00           C  
ATOM     28  H   LEU A   2      17.176  15.918  12.179  1.00  0.00           H  
ATOM     29  HA  LEU A   2      18.009  13.149  12.498  1.00  0.00           H  
ATOM     30  HB2 LEU A   2      15.814  12.489  12.268  1.00  0.00           H  
ATOM     31  HB3 LEU A   2      15.681  14.045  13.058  1.00  0.00           H  
ATOM     32  HG  LEU A   2      15.160  13.557  10.095  1.00  0.00           H  
ATOM     33 HD11 LEU A   2      12.788  13.771  10.646  1.00  0.00           H  
ATOM     34 HD12 LEU A   2      13.180  13.914  12.362  1.00  0.00           H  
ATOM     35 HD13 LEU A   2      13.515  12.411  11.496  1.00  0.00           H  
ATOM     36 HD21 LEU A   2      14.148  15.782  10.075  1.00  0.00           H  
ATOM     37 HD22 LEU A   2      15.846  15.875  10.538  1.00  0.00           H  
ATOM     38 HD23 LEU A   2      14.587  16.019  11.768  1.00  0.00           H  
ATOM     39  N   GLU A   3      18.567  14.349   9.727  1.00  0.00           N  
ATOM     40  CA  GLU A   3      19.109  14.100   8.364  1.00  0.00           C  
ATOM     41  C   GLU A   3      20.028  12.850   8.401  1.00  0.00           C  
ATOM     42  O   GLU A   3      20.062  12.053   7.468  1.00  0.00           O  
ATOM     43  CB  GLU A   3      19.916  15.336   7.784  1.00  0.00           C  
ATOM     44  CG  GLU A   3      19.822  16.667   8.561  1.00  0.00           C  
ATOM     45  CD  GLU A   3      18.408  17.268   8.620  1.00  0.00           C  
ATOM     46  OE1 GLU A   3      17.957  17.848   7.612  1.00  0.00           O  
ATOM     47  OE2 GLU A   3      17.742  17.153   9.674  1.00  0.00           O  
ATOM     48  H   GLU A   3      18.750  15.200  10.160  1.00  0.00           H  
ATOM     49  HA  GLU A   3      18.252  13.896   7.720  1.00  0.00           H  
ATOM     50  HB2 GLU A   3      20.968  15.079   7.727  1.00  0.00           H  
ATOM     51  HB3 GLU A   3      19.570  15.524   6.770  1.00  0.00           H  
ATOM     52  HG2 GLU A   3      20.172  16.489   9.576  1.00  0.00           H  
ATOM     53  HG3 GLU A   3      20.489  17.388   8.094  1.00  0.00           H  
ATOM     54  N   ASP A   4      20.766  12.724   9.521  1.00  0.00           N  
ATOM     55  CA  ASP A   4      21.673  11.591   9.805  1.00  0.00           C  
ATOM     56  C   ASP A   4      20.879  10.305  10.131  1.00  0.00           C  
ATOM     57  O   ASP A   4      21.368   9.192   9.921  1.00  0.00           O  
ATOM     58  CB  ASP A   4      22.605  11.955  10.992  1.00  0.00           C  
ATOM     59  CG  ASP A   4      23.428  13.231  10.736  1.00  0.00           C  
ATOM     60  OD1 ASP A   4      22.864  14.346  10.856  1.00  0.00           O  
ATOM     61  OD2 ASP A   4      24.638  13.131  10.425  1.00  0.00           O  
ATOM     62  H   ASP A   4      20.710  13.445  10.188  1.00  0.00           H  
ATOM     63  HA  ASP A   4      22.279  11.416   8.919  1.00  0.00           H  
ATOM     64  HB2 ASP A   4      21.999  12.108  11.882  1.00  0.00           H  
ATOM     65  HB3 ASP A   4      23.287  11.125  11.179  1.00  0.00           H  
ATOM     66  N   TYR A   5      19.644  10.487  10.637  1.00  0.00           N  
ATOM     67  CA  TYR A   5      18.728   9.380  11.008  1.00  0.00           C  
ATOM     68  C   TYR A   5      18.011   8.796   9.763  1.00  0.00           C  
ATOM     69  O   TYR A   5      17.235   7.835   9.883  1.00  0.00           O  
ATOM     70  CB  TYR A   5      17.674   9.872  12.051  1.00  0.00           C  
ATOM     71  CG  TYR A   5      18.234  10.265  13.443  1.00  0.00           C  
ATOM     72  CD1 TYR A   5      19.244  11.225  13.585  1.00  0.00           C  
ATOM     73  CD2 TYR A   5      17.728   9.689  14.613  1.00  0.00           C  
ATOM     74  CE1 TYR A   5      19.720  11.587  14.830  1.00  0.00           C  
ATOM     75  CE2 TYR A   5      18.209  10.046  15.858  1.00  0.00           C  
ATOM     76  CZ  TYR A   5      19.203  10.997  15.962  1.00  0.00           C  
ATOM     77  OH  TYR A   5      19.672  11.375  17.203  1.00  0.00           O  
ATOM     78  H   TYR A   5      19.336  11.407  10.764  1.00  0.00           H  
ATOM     79  HA  TYR A   5      19.324   8.593  11.464  1.00  0.00           H  
ATOM     80  HB2 TYR A   5      17.166  10.745  11.654  1.00  0.00           H  
ATOM     81  HB3 TYR A   5      16.937   9.086  12.198  1.00  0.00           H  
ATOM     82  HD1 TYR A   5      19.654  11.694  12.698  1.00  0.00           H  
ATOM     83  HD2 TYR A   5      16.947   8.940  14.535  1.00  0.00           H  
ATOM     84  HE1 TYR A   5      20.502  12.329  14.913  1.00  0.00           H  
ATOM     85  HE2 TYR A   5      17.802   9.582  16.746  1.00  0.00           H  
ATOM     86  HH  TYR A   5      19.814  10.594  17.750  1.00  0.00           H  
ATOM     87  N   ALA A   6      18.261   9.408   8.582  1.00  0.00           N  
ATOM     88  CA  ALA A   6      17.687   8.977   7.292  1.00  0.00           C  
ATOM     89  C   ALA A   6      18.363   7.695   6.793  1.00  0.00           C  
ATOM     90  O   ALA A   6      19.379   7.745   6.082  1.00  0.00           O  
ATOM     91  CB  ALA A   6      17.811  10.107   6.249  1.00  0.00           C  
ATOM     92  H   ALA A   6      18.860  10.182   8.582  1.00  0.00           H  
ATOM     93  HA  ALA A   6      16.625   8.783   7.446  1.00  0.00           H  
ATOM     94  HB1 ALA A   6      17.350  11.009   6.632  1.00  0.00           H  
ATOM     95  HB2 ALA A   6      17.312   9.819   5.329  1.00  0.00           H  
ATOM     96  HB3 ALA A   6      18.854  10.306   6.041  1.00  0.00           H  
ATOM     97  N   ILE A   7      17.824   6.545   7.214  1.00  0.00           N  
ATOM     98  CA  ILE A   7      18.326   5.232   6.792  1.00  0.00           C  
ATOM     99  C   ILE A   7      17.703   4.870   5.433  1.00  0.00           C  
ATOM    100  O   ILE A   7      16.484   4.957   5.262  1.00  0.00           O  
ATOM    101  CB  ILE A   7      18.042   4.115   7.872  1.00  0.00           C  
ATOM    102  CG1 ILE A   7      18.636   4.559   9.256  1.00  0.00           C  
ATOM    103  CG2 ILE A   7      18.610   2.740   7.423  1.00  0.00           C  
ATOM    104  CD1 ILE A   7      18.623   3.508  10.358  1.00  0.00           C  
ATOM    105  H   ILE A   7      17.052   6.583   7.818  1.00  0.00           H  
ATOM    106  HA  ILE A   7      19.406   5.311   6.673  1.00  0.00           H  
ATOM    107  HB  ILE A   7      16.963   4.011   7.971  1.00  0.00           H  
ATOM    108 HG12 ILE A   7      19.664   4.861   9.127  1.00  0.00           H  
ATOM    109 HG13 ILE A   7      18.072   5.407   9.619  1.00  0.00           H  
ATOM    110 HG21 ILE A   7      19.686   2.805   7.303  1.00  0.00           H  
ATOM    111 HG22 ILE A   7      18.167   2.451   6.477  1.00  0.00           H  
ATOM    112 HG23 ILE A   7      18.377   1.986   8.163  1.00  0.00           H  
ATOM    113 HD11 ILE A   7      19.014   3.942  11.267  1.00  0.00           H  
ATOM    114 HD12 ILE A   7      19.238   2.670  10.069  1.00  0.00           H  
ATOM    115 HD13 ILE A   7      17.612   3.171  10.532  1.00  0.00           H  
ATOM    116  N   SER A   8      18.558   4.522   4.467  1.00  0.00           N  
ATOM    117  CA  SER A   8      18.138   4.116   3.112  1.00  0.00           C  
ATOM    118  C   SER A   8      17.947   2.591   3.044  1.00  0.00           C  
ATOM    119  O   SER A   8      18.483   1.854   3.878  1.00  0.00           O  
ATOM    120  CB  SER A   8      19.193   4.585   2.092  1.00  0.00           C  
ATOM    121  OG  SER A   8      19.380   5.985   2.168  1.00  0.00           O  
ATOM    122  H   SER A   8      19.516   4.535   4.675  1.00  0.00           H  
ATOM    123  HA  SER A   8      17.191   4.601   2.886  1.00  0.00           H  
ATOM    124  HB2 SER A   8      20.140   4.097   2.291  1.00  0.00           H  
ATOM    125  HB3 SER A   8      18.866   4.340   1.089  1.00  0.00           H  
ATOM    126  HG  SER A   8      18.814   6.340   2.866  1.00  0.00           H  
ATOM    127  N   LEU A   9      17.196   2.128   2.039  1.00  0.00           N  
ATOM    128  CA  LEU A   9      16.841   0.702   1.878  1.00  0.00           C  
ATOM    129  C   LEU A   9      18.067  -0.153   1.455  1.00  0.00           C  
ATOM    130  O   LEU A   9      18.164  -1.346   1.784  1.00  0.00           O  
ATOM    131  CB  LEU A   9      15.669   0.593   0.864  1.00  0.00           C  
ATOM    132  CG  LEU A   9      15.168  -0.839   0.501  1.00  0.00           C  
ATOM    133  CD1 LEU A   9      14.869  -1.685   1.760  1.00  0.00           C  
ATOM    134  CD2 LEU A   9      13.940  -0.769  -0.430  1.00  0.00           C  
ATOM    135  H   LEU A   9      16.868   2.768   1.370  1.00  0.00           H  
ATOM    136  HA  LEU A   9      16.492   0.343   2.843  1.00  0.00           H  
ATOM    137  HB2 LEU A   9      14.826   1.150   1.270  1.00  0.00           H  
ATOM    138  HB3 LEU A   9      15.976   1.086  -0.055  1.00  0.00           H  
ATOM    139  HG  LEU A   9      15.954  -1.350  -0.041  1.00  0.00           H  
ATOM    140 HD11 LEU A   9      14.131  -1.183   2.374  1.00  0.00           H  
ATOM    141 HD12 LEU A   9      15.776  -1.823   2.330  1.00  0.00           H  
ATOM    142 HD13 LEU A   9      14.487  -2.656   1.466  1.00  0.00           H  
ATOM    143 HD21 LEU A   9      14.196  -0.234  -1.335  1.00  0.00           H  
ATOM    144 HD22 LEU A   9      13.125  -0.255   0.071  1.00  0.00           H  
ATOM    145 HD23 LEU A   9      13.623  -1.769  -0.691  1.00  0.00           H  
ATOM    146  N   GLU A  10      19.017   0.489   0.771  1.00  0.00           N  
ATOM    147  CA  GLU A  10      20.251  -0.157   0.279  1.00  0.00           C  
ATOM    148  C   GLU A  10      21.342  -0.253   1.382  1.00  0.00           C  
ATOM    149  O   GLU A  10      22.424  -0.794   1.133  1.00  0.00           O  
ATOM    150  CB  GLU A  10      20.794   0.573  -0.999  1.00  0.00           C  
ATOM    151  CG  GLU A  10      20.792   2.126  -0.952  1.00  0.00           C  
ATOM    152  CD  GLU A  10      19.500   2.768  -1.512  1.00  0.00           C  
ATOM    153  OE1 GLU A  10      18.518   2.941  -0.757  1.00  0.00           O  
ATOM    154  OE2 GLU A  10      19.460   3.084  -2.723  1.00  0.00           O  
ATOM    155  H   GLU A  10      18.889   1.439   0.601  1.00  0.00           H  
ATOM    156  HA  GLU A  10      19.991  -1.174  -0.005  1.00  0.00           H  
ATOM    157  HB2 GLU A  10      21.813   0.245  -1.174  1.00  0.00           H  
ATOM    158  HB3 GLU A  10      20.198   0.259  -1.851  1.00  0.00           H  
ATOM    159  HG2 GLU A  10      20.917   2.441   0.079  1.00  0.00           H  
ATOM    160  HG3 GLU A  10      21.638   2.492  -1.524  1.00  0.00           H  
ATOM    161  N   GLU A  11      21.045   0.243   2.600  1.00  0.00           N  
ATOM    162  CA  GLU A  11      21.974   0.165   3.759  1.00  0.00           C  
ATOM    163  C   GLU A  11      21.268  -0.378   5.017  1.00  0.00           C  
ATOM    164  O   GLU A  11      21.922  -0.593   6.044  1.00  0.00           O  
ATOM    165  CB  GLU A  11      22.573   1.564   4.071  1.00  0.00           C  
ATOM    166  CG  GLU A  11      21.511   2.639   4.388  1.00  0.00           C  
ATOM    167  CD  GLU A  11      22.075   3.977   4.880  1.00  0.00           C  
ATOM    168  OE1 GLU A  11      22.975   4.535   4.220  1.00  0.00           O  
ATOM    169  OE2 GLU A  11      21.619   4.478   5.928  1.00  0.00           O  
ATOM    170  H   GLU A  11      20.177   0.679   2.731  1.00  0.00           H  
ATOM    171  HA  GLU A  11      22.785  -0.517   3.506  1.00  0.00           H  
ATOM    172  HB2 GLU A  11      23.237   1.476   4.926  1.00  0.00           H  
ATOM    173  HB3 GLU A  11      23.153   1.898   3.217  1.00  0.00           H  
ATOM    174  HG2 GLU A  11      20.938   2.832   3.489  1.00  0.00           H  
ATOM    175  HG3 GLU A  11      20.839   2.238   5.144  1.00  0.00           H  
ATOM    176  N   VAL A  12      19.942  -0.603   4.934  1.00  0.00           N  
ATOM    177  CA  VAL A  12      19.110  -0.909   6.119  1.00  0.00           C  
ATOM    178  C   VAL A  12      19.304  -2.362   6.606  1.00  0.00           C  
ATOM    179  O   VAL A  12      19.687  -3.244   5.829  1.00  0.00           O  
ATOM    180  CB  VAL A  12      17.581  -0.644   5.832  1.00  0.00           C  
ATOM    181  CG1 VAL A  12      16.976  -1.678   4.860  1.00  0.00           C  
ATOM    182  CG2 VAL A  12      16.761  -0.554   7.139  1.00  0.00           C  
ATOM    183  H   VAL A  12      19.513  -0.576   4.055  1.00  0.00           H  
ATOM    184  HA  VAL A  12      19.422  -0.231   6.914  1.00  0.00           H  
ATOM    185  HB  VAL A  12      17.512   0.329   5.342  1.00  0.00           H  
ATOM    186 HG11 VAL A  12      17.540  -1.685   3.938  1.00  0.00           H  
ATOM    187 HG12 VAL A  12      15.947  -1.418   4.644  1.00  0.00           H  
ATOM    188 HG13 VAL A  12      17.005  -2.666   5.306  1.00  0.00           H  
ATOM    189 HG21 VAL A  12      16.841  -1.484   7.690  1.00  0.00           H  
ATOM    190 HG22 VAL A  12      15.721  -0.362   6.908  1.00  0.00           H  
ATOM    191 HG23 VAL A  12      17.141   0.257   7.752  1.00  0.00           H  
ATOM    192  N   ASN A  13      19.069  -2.577   7.910  1.00  0.00           N  
ATOM    193  CA  ASN A  13      18.941  -3.912   8.514  1.00  0.00           C  
ATOM    194  C   ASN A  13      17.697  -3.879   9.418  1.00  0.00           C  
ATOM    195  O   ASN A  13      17.812  -3.534  10.589  1.00  0.00           O  
ATOM    196  CB  ASN A  13      20.206  -4.291   9.353  1.00  0.00           C  
ATOM    197  CG  ASN A  13      21.535  -4.096   8.615  1.00  0.00           C  
ATOM    198  OD1 ASN A  13      21.994  -4.977   7.893  1.00  0.00           O  
ATOM    199  ND2 ASN A  13      22.169  -2.944   8.796  1.00  0.00           N  
ATOM    200  H   ASN A  13      18.986  -1.797   8.500  1.00  0.00           H  
ATOM    201  HA  ASN A  13      18.789  -4.652   7.727  1.00  0.00           H  
ATOM    202  HB2 ASN A  13      20.228  -3.683  10.250  1.00  0.00           H  
ATOM    203  HB3 ASN A  13      20.133  -5.334   9.649  1.00  0.00           H  
ATOM    204 HD21 ASN A  13      21.762  -2.272   9.386  1.00  0.00           H  
ATOM    205 HD22 ASN A  13      23.026  -2.814   8.339  1.00  0.00           H  
ATOM    206  N   PHE A  14      16.501  -4.176   8.859  1.00  0.00           N  
ATOM    207  CA  PHE A  14      15.212  -4.100   9.615  1.00  0.00           C  
ATOM    208  C   PHE A  14      15.240  -4.961  10.894  1.00  0.00           C  
ATOM    209  O   PHE A  14      14.653  -4.594  11.913  1.00  0.00           O  
ATOM    210  CB  PHE A  14      14.010  -4.519   8.729  1.00  0.00           C  
ATOM    211  CG  PHE A  14      13.708  -3.551   7.589  1.00  0.00           C  
ATOM    212  CD1 PHE A  14      13.284  -2.256   7.859  1.00  0.00           C  
ATOM    213  CD2 PHE A  14      13.832  -3.933   6.261  1.00  0.00           C  
ATOM    214  CE1 PHE A  14      13.002  -1.377   6.833  1.00  0.00           C  
ATOM    215  CE2 PHE A  14      13.552  -3.055   5.234  1.00  0.00           C  
ATOM    216  CZ  PHE A  14      13.134  -1.779   5.522  1.00  0.00           C  
ATOM    217  H   PHE A  14      16.481  -4.443   7.916  1.00  0.00           H  
ATOM    218  HA  PHE A  14      15.079  -3.062   9.911  1.00  0.00           H  
ATOM    219  HB2 PHE A  14      14.205  -5.500   8.309  1.00  0.00           H  
ATOM    220  HB3 PHE A  14      13.117  -4.584   9.346  1.00  0.00           H  
ATOM    221  HD1 PHE A  14      13.176  -1.931   8.887  1.00  0.00           H  
ATOM    222  HD2 PHE A  14      14.156  -4.935   6.030  1.00  0.00           H  
ATOM    223  HE1 PHE A  14      12.673  -0.371   7.059  1.00  0.00           H  
ATOM    224  HE2 PHE A  14      13.658  -3.371   4.204  1.00  0.00           H  
ATOM    225  HZ  PHE A  14      12.914  -1.085   4.720  1.00  0.00           H  
ATOM    226  N   ASN A  15      15.949  -6.093  10.809  1.00  0.00           N  
ATOM    227  CA  ASN A  15      16.179  -7.018  11.940  1.00  0.00           C  
ATOM    228  C   ASN A  15      16.906  -6.331  13.129  1.00  0.00           C  
ATOM    229  O   ASN A  15      16.661  -6.666  14.291  1.00  0.00           O  
ATOM    230  CB  ASN A  15      16.987  -8.252  11.444  1.00  0.00           C  
ATOM    231  CG  ASN A  15      18.275  -7.875  10.693  1.00  0.00           C  
ATOM    232  OD1 ASN A  15      19.338  -7.694  11.287  1.00  0.00           O  
ATOM    233  ND2 ASN A  15      18.191  -7.754   9.374  1.00  0.00           N  
ATOM    234  H   ASN A  15      16.338  -6.322   9.942  1.00  0.00           H  
ATOM    235  HA  ASN A  15      15.209  -7.359  12.278  1.00  0.00           H  
ATOM    236  HB2 ASN A  15      17.255  -8.871  12.293  1.00  0.00           H  
ATOM    237  HB3 ASN A  15      16.360  -8.838  10.779  1.00  0.00           H  
ATOM    238 HD21 ASN A  15      17.325  -7.905   8.946  1.00  0.00           H  
ATOM    239 HD22 ASN A  15      19.012  -7.537   8.881  1.00  0.00           H  
ATOM    240  N   ASP A  16      17.777  -5.355  12.812  1.00  0.00           N  
ATOM    241  CA  ASP A  16      18.605  -4.628  13.806  1.00  0.00           C  
ATOM    242  C   ASP A  16      17.764  -3.627  14.626  1.00  0.00           C  
ATOM    243  O   ASP A  16      18.146  -3.267  15.743  1.00  0.00           O  
ATOM    244  CB  ASP A  16      19.773  -3.888  13.082  1.00  0.00           C  
ATOM    245  CG  ASP A  16      20.821  -3.252  14.024  1.00  0.00           C  
ATOM    246  OD1 ASP A  16      21.236  -3.911  15.006  1.00  0.00           O  
ATOM    247  OD2 ASP A  16      21.265  -2.112  13.772  1.00  0.00           O  
ATOM    248  H   ASP A  16      17.869  -5.107  11.873  1.00  0.00           H  
ATOM    249  HA  ASP A  16      19.027  -5.363  14.484  1.00  0.00           H  
ATOM    250  HB2 ASP A  16      20.289  -4.586  12.437  1.00  0.00           H  
ATOM    251  HB3 ASP A  16      19.344  -3.108  12.455  1.00  0.00           H  
ATOM    252  N   PHE A  17      16.611  -3.178  14.075  1.00  0.00           N  
ATOM    253  CA  PHE A  17      15.754  -2.149  14.724  1.00  0.00           C  
ATOM    254  C   PHE A  17      14.352  -2.732  15.033  1.00  0.00           C  
ATOM    255  O   PHE A  17      13.974  -3.788  14.512  1.00  0.00           O  
ATOM    256  CB  PHE A  17      15.610  -0.875  13.814  1.00  0.00           C  
ATOM    257  CG  PHE A  17      16.826  -0.557  12.932  1.00  0.00           C  
ATOM    258  CD1 PHE A  17      17.992  -0.056  13.478  1.00  0.00           C  
ATOM    259  CD2 PHE A  17      16.797  -0.770  11.557  1.00  0.00           C  
ATOM    260  CE1 PHE A  17      19.094   0.222  12.698  1.00  0.00           C  
ATOM    261  CE2 PHE A  17      17.902  -0.492  10.769  1.00  0.00           C  
ATOM    262  CZ  PHE A  17      19.048   0.004  11.342  1.00  0.00           C  
ATOM    263  H   PHE A  17      16.315  -3.558  13.216  1.00  0.00           H  
ATOM    264  HA  PHE A  17      16.219  -1.859  15.667  1.00  0.00           H  
ATOM    265  HB2 PHE A  17      14.752  -0.980  13.172  1.00  0.00           H  
ATOM    266  HB3 PHE A  17      15.437  -0.015  14.455  1.00  0.00           H  
ATOM    267  HD1 PHE A  17      18.039   0.114  14.541  1.00  0.00           H  
ATOM    268  HD2 PHE A  17      15.898  -1.164  11.098  1.00  0.00           H  
ATOM    269  HE1 PHE A  17      19.995   0.613  13.154  1.00  0.00           H  
ATOM    270  HE2 PHE A  17      17.863  -0.664   9.700  1.00  0.00           H  
ATOM    271  HZ  PHE A  17      19.913   0.216  10.732  1.00  0.00           H  
ATOM    272  N   ILE A  18      13.603  -2.042  15.912  1.00  0.00           N  
ATOM    273  CA  ILE A  18      12.162  -2.281  16.128  1.00  0.00           C  
ATOM    274  C   ILE A  18      11.410  -1.414  15.110  1.00  0.00           C  
ATOM    275  O   ILE A  18      11.416  -0.187  15.217  1.00  0.00           O  
ATOM    276  CB  ILE A  18      11.705  -1.904  17.593  1.00  0.00           C  
ATOM    277  CG1 ILE A  18      12.561  -2.661  18.663  1.00  0.00           C  
ATOM    278  CG2 ILE A  18      10.186  -2.179  17.790  1.00  0.00           C  
ATOM    279  CD1 ILE A  18      12.316  -2.220  20.101  1.00  0.00           C  
ATOM    280  H   ILE A  18      14.032  -1.340  16.430  1.00  0.00           H  
ATOM    281  HA  ILE A  18      11.947  -3.331  15.946  1.00  0.00           H  
ATOM    282  HB  ILE A  18      11.857  -0.829  17.718  1.00  0.00           H  
ATOM    283 HG12 ILE A  18      12.349  -3.720  18.612  1.00  0.00           H  
ATOM    284 HG13 ILE A  18      13.614  -2.508  18.452  1.00  0.00           H  
ATOM    285 HG21 ILE A  18       9.613  -1.605  17.072  1.00  0.00           H  
ATOM    286 HG22 ILE A  18       9.886  -1.890  18.789  1.00  0.00           H  
ATOM    287 HG23 ILE A  18       9.980  -3.233  17.648  1.00  0.00           H  
ATOM    288 HD11 ILE A  18      12.949  -2.793  20.762  1.00  0.00           H  
ATOM    289 HD12 ILE A  18      11.282  -2.384  20.363  1.00  0.00           H  
ATOM    290 HD13 ILE A  18      12.553  -1.167  20.207  1.00  0.00           H  
ATOM    291  N   VAL A  19      10.786  -2.042  14.114  1.00  0.00           N  
ATOM    292  CA  VAL A  19      10.270  -1.319  12.944  1.00  0.00           C  
ATOM    293  C   VAL A  19       8.828  -0.834  13.217  1.00  0.00           C  
ATOM    294  O   VAL A  19       8.090  -1.456  13.986  1.00  0.00           O  
ATOM    295  CB  VAL A  19      10.345  -2.230  11.655  1.00  0.00           C  
ATOM    296  CG1 VAL A  19      10.042  -1.437  10.371  1.00  0.00           C  
ATOM    297  CG2 VAL A  19      11.722  -2.932  11.542  1.00  0.00           C  
ATOM    298  H   VAL A  19      10.626  -3.013  14.178  1.00  0.00           H  
ATOM    299  HA  VAL A  19      10.904  -0.443  12.777  1.00  0.00           H  
ATOM    300  HB  VAL A  19       9.588  -3.013  11.751  1.00  0.00           H  
ATOM    301 HG11 VAL A  19      10.100  -2.094   9.512  1.00  0.00           H  
ATOM    302 HG12 VAL A  19      10.759  -0.635  10.255  1.00  0.00           H  
ATOM    303 HG13 VAL A  19       9.046  -1.018  10.429  1.00  0.00           H  
ATOM    304 HG21 VAL A  19      11.896  -3.539  12.420  1.00  0.00           H  
ATOM    305 HG22 VAL A  19      12.508  -2.190  11.458  1.00  0.00           H  
ATOM    306 HG23 VAL A  19      11.739  -3.568  10.664  1.00  0.00           H  
ATOM    307  N   VAL A  20       8.460   0.311  12.619  1.00  0.00           N  
ATOM    308  CA  VAL A  20       7.101   0.884  12.689  1.00  0.00           C  
ATOM    309  C   VAL A  20       6.624   1.208  11.269  1.00  0.00           C  
ATOM    310  O   VAL A  20       7.327   1.882  10.511  1.00  0.00           O  
ATOM    311  CB  VAL A  20       7.051   2.178  13.603  1.00  0.00           C  
ATOM    312  CG1 VAL A  20       5.715   2.955  13.470  1.00  0.00           C  
ATOM    313  CG2 VAL A  20       7.311   1.817  15.085  1.00  0.00           C  
ATOM    314  H   VAL A  20       9.134   0.798  12.110  1.00  0.00           H  
ATOM    315  HA  VAL A  20       6.434   0.134  13.117  1.00  0.00           H  
ATOM    316  HB  VAL A  20       7.850   2.842  13.280  1.00  0.00           H  
ATOM    317 HG11 VAL A  20       4.883   2.324  13.766  1.00  0.00           H  
ATOM    318 HG12 VAL A  20       5.576   3.266  12.446  1.00  0.00           H  
ATOM    319 HG13 VAL A  20       5.737   3.836  14.104  1.00  0.00           H  
ATOM    320 HG21 VAL A  20       7.329   2.719  15.683  1.00  0.00           H  
ATOM    321 HG22 VAL A  20       8.266   1.315  15.174  1.00  0.00           H  
ATOM    322 HG23 VAL A  20       6.530   1.160  15.454  1.00  0.00           H  
ATOM    323  N   ASP A  21       5.442   0.695  10.911  1.00  0.00           N  
ATOM    324  CA  ASP A  21       4.794   0.985   9.628  1.00  0.00           C  
ATOM    325  C   ASP A  21       4.030   2.312   9.773  1.00  0.00           C  
ATOM    326  O   ASP A  21       2.975   2.316  10.393  1.00  0.00           O  
ATOM    327  CB  ASP A  21       3.823  -0.190   9.275  1.00  0.00           C  
ATOM    328  CG  ASP A  21       3.325  -0.170   7.816  1.00  0.00           C  
ATOM    329  OD1 ASP A  21       2.403   0.598   7.483  1.00  0.00           O  
ATOM    330  OD2 ASP A  21       3.876  -0.935   6.992  1.00  0.00           O  
ATOM    331  H   ASP A  21       4.973   0.113  11.547  1.00  0.00           H  
ATOM    332  HA  ASP A  21       5.556   1.077   8.857  1.00  0.00           H  
ATOM    333  HB2 ASP A  21       4.338  -1.133   9.452  1.00  0.00           H  
ATOM    334  HB3 ASP A  21       2.960  -0.154   9.937  1.00  0.00           H  
ATOM    335  N   VAL A  22       4.581   3.430   9.231  1.00  0.00           N  
ATOM    336  CA  VAL A  22       3.943   4.775   9.316  1.00  0.00           C  
ATOM    337  C   VAL A  22       3.177   5.096   8.028  1.00  0.00           C  
ATOM    338  O   VAL A  22       3.684   5.775   7.118  1.00  0.00           O  
ATOM    339  CB  VAL A  22       4.959   5.935   9.667  1.00  0.00           C  
ATOM    340  CG1 VAL A  22       5.370   5.868  11.151  1.00  0.00           C  
ATOM    341  CG2 VAL A  22       6.207   5.895   8.743  1.00  0.00           C  
ATOM    342  H   VAL A  22       5.440   3.347   8.763  1.00  0.00           H  
ATOM    343  HA  VAL A  22       3.213   4.735  10.120  1.00  0.00           H  
ATOM    344  HB  VAL A  22       4.451   6.892   9.507  1.00  0.00           H  
ATOM    345 HG11 VAL A  22       4.491   5.947  11.773  1.00  0.00           H  
ATOM    346 HG12 VAL A  22       6.045   6.681  11.384  1.00  0.00           H  
ATOM    347 HG13 VAL A  22       5.865   4.925  11.352  1.00  0.00           H  
ATOM    348 HG21 VAL A  22       6.737   4.959   8.881  1.00  0.00           H  
ATOM    349 HG22 VAL A  22       6.866   6.722   8.976  1.00  0.00           H  
ATOM    350 HG23 VAL A  22       5.894   5.972   7.704  1.00  0.00           H  
ATOM    351  N   ARG A  23       1.939   4.588   7.943  1.00  0.00           N  
ATOM    352  CA  ARG A  23       1.109   4.732   6.729  1.00  0.00           C  
ATOM    353  C   ARG A  23      -0.388   4.797   7.094  1.00  0.00           C  
ATOM    354  O   ARG A  23      -0.916   5.886   7.365  1.00  0.00           O  
ATOM    355  CB  ARG A  23       1.402   3.584   5.700  1.00  0.00           C  
ATOM    356  CG  ARG A  23       2.808   3.616   5.042  1.00  0.00           C  
ATOM    357  CD  ARG A  23       2.993   2.535   3.976  1.00  0.00           C  
ATOM    358  NE  ARG A  23       2.909   1.172   4.516  1.00  0.00           N  
ATOM    359  CZ  ARG A  23       2.584   0.082   3.816  1.00  0.00           C  
ATOM    360  NH1 ARG A  23       2.149   0.166   2.561  1.00  0.00           N  
ATOM    361  NH2 ARG A  23       2.622  -1.090   4.403  1.00  0.00           N  
ATOM    362  H   ARG A  23       1.565   4.115   8.731  1.00  0.00           H  
ATOM    363  HA  ARG A  23       1.369   5.683   6.261  1.00  0.00           H  
ATOM    364  HB2 ARG A  23       1.288   2.632   6.211  1.00  0.00           H  
ATOM    365  HB3 ARG A  23       0.656   3.633   4.910  1.00  0.00           H  
ATOM    366  HG2 ARG A  23       2.957   4.587   4.582  1.00  0.00           H  
ATOM    367  HG3 ARG A  23       3.561   3.480   5.819  1.00  0.00           H  
ATOM    368  HD2 ARG A  23       2.232   2.662   3.212  1.00  0.00           H  
ATOM    369  HD3 ARG A  23       3.969   2.664   3.520  1.00  0.00           H  
ATOM    370  HE  ARG A  23       3.126   1.059   5.477  1.00  0.00           H  
ATOM    371 HH11 ARG A  23       2.046   1.065   2.121  1.00  0.00           H  
ATOM    372 HH12 ARG A  23       1.892  -0.661   2.065  1.00  0.00           H  
ATOM    373 HH21 ARG A  23       2.895  -1.156   5.368  1.00  0.00           H  
ATOM    374 HH22 ARG A  23       2.344  -1.916   3.911  1.00  0.00           H  
ATOM    375  N   GLU A  24      -1.041   3.626   7.157  1.00  0.00           N  
ATOM    376  CA  GLU A  24      -2.515   3.502   7.268  1.00  0.00           C  
ATOM    377  C   GLU A  24      -2.838   2.008   7.497  1.00  0.00           C  
ATOM    378  O   GLU A  24      -2.008   1.149   7.180  1.00  0.00           O  
ATOM    379  CB  GLU A  24      -3.208   4.053   5.954  1.00  0.00           C  
ATOM    380  CG  GLU A  24      -4.606   4.711   6.119  1.00  0.00           C  
ATOM    381  CD  GLU A  24      -5.740   3.739   6.486  1.00  0.00           C  
ATOM    382  OE1 GLU A  24      -6.093   2.894   5.647  1.00  0.00           O  
ATOM    383  OE2 GLU A  24      -6.278   3.807   7.613  1.00  0.00           O  
ATOM    384  H   GLU A  24      -0.513   2.800   7.151  1.00  0.00           H  
ATOM    385  HA  GLU A  24      -2.836   4.073   8.134  1.00  0.00           H  
ATOM    386  HB2 GLU A  24      -2.553   4.800   5.520  1.00  0.00           H  
ATOM    387  HB3 GLU A  24      -3.301   3.244   5.234  1.00  0.00           H  
ATOM    388  HG2 GLU A  24      -4.532   5.474   6.885  1.00  0.00           H  
ATOM    389  HG3 GLU A  24      -4.868   5.202   5.182  1.00  0.00           H  
ATOM    390  N   LEU A  25      -4.025   1.713   8.061  1.00  0.00           N  
ATOM    391  CA  LEU A  25      -4.505   0.336   8.297  1.00  0.00           C  
ATOM    392  C   LEU A  25      -4.474  -0.507   7.004  1.00  0.00           C  
ATOM    393  O   LEU A  25      -3.838  -1.553   6.975  1.00  0.00           O  
ATOM    394  CB  LEU A  25      -5.937   0.369   8.895  1.00  0.00           C  
ATOM    395  CG  LEU A  25      -6.630  -1.013   9.146  1.00  0.00           C  
ATOM    396  CD1 LEU A  25      -5.834  -1.892  10.142  1.00  0.00           C  
ATOM    397  CD2 LEU A  25      -8.087  -0.820   9.621  1.00  0.00           C  
ATOM    398  H   LEU A  25      -4.602   2.454   8.343  1.00  0.00           H  
ATOM    399  HA  LEU A  25      -3.835  -0.116   9.020  1.00  0.00           H  
ATOM    400  HB2 LEU A  25      -5.891   0.899   9.842  1.00  0.00           H  
ATOM    401  HB3 LEU A  25      -6.566   0.945   8.223  1.00  0.00           H  
ATOM    402  HG  LEU A  25      -6.664  -1.553   8.206  1.00  0.00           H  
ATOM    403 HD11 LEU A  25      -5.761  -1.390  11.098  1.00  0.00           H  
ATOM    404 HD12 LEU A  25      -4.837  -2.071   9.757  1.00  0.00           H  
ATOM    405 HD13 LEU A  25      -6.335  -2.842  10.271  1.00  0.00           H  
ATOM    406 HD21 LEU A  25      -8.637  -0.238   8.891  1.00  0.00           H  
ATOM    407 HD22 LEU A  25      -8.098  -0.302  10.572  1.00  0.00           H  
ATOM    408 HD23 LEU A  25      -8.563  -1.784   9.732  1.00  0.00           H  
ATOM    409  N   ASP A  26      -5.140  -0.012   5.949  1.00  0.00           N  
ATOM    410  CA  ASP A  26      -5.219  -0.684   4.625  1.00  0.00           C  
ATOM    411  C   ASP A  26      -3.823  -0.988   4.046  1.00  0.00           C  
ATOM    412  O   ASP A  26      -3.582  -2.084   3.534  1.00  0.00           O  
ATOM    413  CB  ASP A  26      -6.034   0.204   3.648  1.00  0.00           C  
ATOM    414  CG  ASP A  26      -6.004  -0.256   2.175  1.00  0.00           C  
ATOM    415  OD1 ASP A  26      -6.705  -1.234   1.829  1.00  0.00           O  
ATOM    416  OD2 ASP A  26      -5.284   0.361   1.355  1.00  0.00           O  
ATOM    417  H   ASP A  26      -5.601   0.845   6.060  1.00  0.00           H  
ATOM    418  HA  ASP A  26      -5.749  -1.621   4.773  1.00  0.00           H  
ATOM    419  HB2 ASP A  26      -7.067   0.222   3.975  1.00  0.00           H  
ATOM    420  HB3 ASP A  26      -5.645   1.218   3.706  1.00  0.00           H  
ATOM    421  N   GLU A  27      -2.932   0.007   4.151  1.00  0.00           N  
ATOM    422  CA  GLU A  27      -1.526  -0.081   3.701  1.00  0.00           C  
ATOM    423  C   GLU A  27      -0.759  -1.207   4.433  1.00  0.00           C  
ATOM    424  O   GLU A  27      -0.001  -1.967   3.822  1.00  0.00           O  
ATOM    425  CB  GLU A  27      -0.834   1.278   3.964  1.00  0.00           C  
ATOM    426  CG  GLU A  27      -1.307   2.442   3.076  1.00  0.00           C  
ATOM    427  CD  GLU A  27      -0.870   2.295   1.608  1.00  0.00           C  
ATOM    428  OE1 GLU A  27       0.342   2.091   1.360  1.00  0.00           O  
ATOM    429  OE2 GLU A  27      -1.710   2.445   0.698  1.00  0.00           O  
ATOM    430  H   GLU A  27      -3.231   0.847   4.555  1.00  0.00           H  
ATOM    431  HA  GLU A  27      -1.523  -0.284   2.635  1.00  0.00           H  
ATOM    432  HB2 GLU A  27      -0.999   1.557   4.999  1.00  0.00           H  
ATOM    433  HB3 GLU A  27       0.237   1.163   3.816  1.00  0.00           H  
ATOM    434  HG2 GLU A  27      -2.393   2.502   3.131  1.00  0.00           H  
ATOM    435  HG3 GLU A  27      -0.892   3.366   3.466  1.00  0.00           H  
ATOM    436  N   TYR A  28      -0.968  -1.270   5.747  1.00  0.00           N  
ATOM    437  CA  TYR A  28      -0.363  -2.269   6.643  1.00  0.00           C  
ATOM    438  C   TYR A  28      -0.879  -3.686   6.334  1.00  0.00           C  
ATOM    439  O   TYR A  28      -0.109  -4.658   6.372  1.00  0.00           O  
ATOM    440  CB  TYR A  28      -0.683  -1.841   8.098  1.00  0.00           C  
ATOM    441  CG  TYR A  28      -0.436  -2.882   9.202  1.00  0.00           C  
ATOM    442  CD1 TYR A  28       0.841  -3.123   9.711  1.00  0.00           C  
ATOM    443  CD2 TYR A  28      -1.504  -3.594   9.761  1.00  0.00           C  
ATOM    444  CE1 TYR A  28       1.039  -4.040  10.727  1.00  0.00           C  
ATOM    445  CE2 TYR A  28      -1.304  -4.498  10.773  1.00  0.00           C  
ATOM    446  CZ  TYR A  28      -0.037  -4.719  11.254  1.00  0.00           C  
ATOM    447  OH  TYR A  28       0.152  -5.635  12.265  1.00  0.00           O  
ATOM    448  H   TYR A  28      -1.570  -0.605   6.144  1.00  0.00           H  
ATOM    449  HA  TYR A  28       0.713  -2.244   6.500  1.00  0.00           H  
ATOM    450  HB2 TYR A  28      -0.085  -0.972   8.340  1.00  0.00           H  
ATOM    451  HB3 TYR A  28      -1.729  -1.546   8.150  1.00  0.00           H  
ATOM    452  HD1 TYR A  28       1.689  -2.589   9.294  1.00  0.00           H  
ATOM    453  HD2 TYR A  28      -2.507  -3.425   9.383  1.00  0.00           H  
ATOM    454  HE1 TYR A  28       2.038  -4.217  11.109  1.00  0.00           H  
ATOM    455  HE2 TYR A  28      -2.147  -5.037  11.186  1.00  0.00           H  
ATOM    456  HH  TYR A  28      -0.535  -6.309  12.210  1.00  0.00           H  
ATOM    457  N   GLU A  29      -2.181  -3.776   6.013  1.00  0.00           N  
ATOM    458  CA  GLU A  29      -2.866  -5.053   5.766  1.00  0.00           C  
ATOM    459  C   GLU A  29      -2.447  -5.664   4.424  1.00  0.00           C  
ATOM    460  O   GLU A  29      -2.216  -6.870   4.350  1.00  0.00           O  
ATOM    461  CB  GLU A  29      -4.399  -4.870   5.825  1.00  0.00           C  
ATOM    462  CG  GLU A  29      -4.926  -4.451   7.210  1.00  0.00           C  
ATOM    463  CD  GLU A  29      -6.436  -4.170   7.221  1.00  0.00           C  
ATOM    464  OE1 GLU A  29      -6.890  -3.284   6.463  1.00  0.00           O  
ATOM    465  OE2 GLU A  29      -7.173  -4.818   7.994  1.00  0.00           O  
ATOM    466  H   GLU A  29      -2.697  -2.949   5.933  1.00  0.00           H  
ATOM    467  HA  GLU A  29      -2.573  -5.739   6.560  1.00  0.00           H  
ATOM    468  HB2 GLU A  29      -4.688  -4.111   5.104  1.00  0.00           H  
ATOM    469  HB3 GLU A  29      -4.878  -5.806   5.550  1.00  0.00           H  
ATOM    470  HG2 GLU A  29      -4.699  -5.243   7.919  1.00  0.00           H  
ATOM    471  HG3 GLU A  29      -4.408  -3.550   7.527  1.00  0.00           H  
ATOM    472  N   GLU A  30      -2.346  -4.829   3.372  1.00  0.00           N  
ATOM    473  CA  GLU A  30      -1.968  -5.302   2.021  1.00  0.00           C  
ATOM    474  C   GLU A  30      -0.515  -5.838   2.012  1.00  0.00           C  
ATOM    475  O   GLU A  30      -0.224  -6.836   1.338  1.00  0.00           O  
ATOM    476  CB  GLU A  30      -2.162  -4.194   0.944  1.00  0.00           C  
ATOM    477  CG  GLU A  30      -1.407  -2.887   1.207  1.00  0.00           C  
ATOM    478  CD  GLU A  30      -1.357  -1.946  -0.004  1.00  0.00           C  
ATOM    479  OE1 GLU A  30      -0.516  -2.179  -0.908  1.00  0.00           O  
ATOM    480  OE2 GLU A  30      -2.165  -0.996  -0.079  1.00  0.00           O  
ATOM    481  H   GLU A  30      -2.530  -3.877   3.508  1.00  0.00           H  
ATOM    482  HA  GLU A  30      -2.633  -6.128   1.781  1.00  0.00           H  
ATOM    483  HB2 GLU A  30      -1.843  -4.583  -0.016  1.00  0.00           H  
ATOM    484  HB3 GLU A  30      -3.221  -3.965   0.879  1.00  0.00           H  
ATOM    485  HG2 GLU A  30      -1.888  -2.374   2.036  1.00  0.00           H  
ATOM    486  HG3 GLU A  30      -0.393  -3.127   1.503  1.00  0.00           H  
ATOM    487  N   LEU A  31       0.377  -5.178   2.781  1.00  0.00           N  
ATOM    488  CA  LEU A  31       1.763  -5.640   2.997  1.00  0.00           C  
ATOM    489  C   LEU A  31       2.409  -4.889   4.167  1.00  0.00           C  
ATOM    490  O   LEU A  31       2.075  -3.736   4.421  1.00  0.00           O  
ATOM    491  CB  LEU A  31       2.654  -5.500   1.716  1.00  0.00           C  
ATOM    492  CG  LEU A  31       3.244  -4.089   1.339  1.00  0.00           C  
ATOM    493  CD1 LEU A  31       4.179  -4.193   0.124  1.00  0.00           C  
ATOM    494  CD2 LEU A  31       2.160  -3.025   1.089  1.00  0.00           C  
ATOM    495  H   LEU A  31       0.086  -4.351   3.229  1.00  0.00           H  
ATOM    496  HA  LEU A  31       1.707  -6.693   3.267  1.00  0.00           H  
ATOM    497  HB2 LEU A  31       3.493  -6.182   1.834  1.00  0.00           H  
ATOM    498  HB3 LEU A  31       2.068  -5.854   0.869  1.00  0.00           H  
ATOM    499  HG  LEU A  31       3.851  -3.743   2.160  1.00  0.00           H  
ATOM    500 HD11 LEU A  31       3.631  -4.572  -0.733  1.00  0.00           H  
ATOM    501 HD12 LEU A  31       4.994  -4.868   0.348  1.00  0.00           H  
ATOM    502 HD13 LEU A  31       4.583  -3.221  -0.113  1.00  0.00           H  
ATOM    503 HD21 LEU A  31       1.534  -3.321   0.255  1.00  0.00           H  
ATOM    504 HD22 LEU A  31       2.625  -2.073   0.864  1.00  0.00           H  
ATOM    505 HD23 LEU A  31       1.545  -2.915   1.973  1.00  0.00           H  
ATOM    506  N   HIS A  32       3.330  -5.558   4.876  1.00  0.00           N  
ATOM    507  CA  HIS A  32       4.150  -4.930   5.932  1.00  0.00           C  
ATOM    508  C   HIS A  32       5.296  -5.874   6.313  1.00  0.00           C  
ATOM    509  O   HIS A  32       5.311  -7.038   5.907  1.00  0.00           O  
ATOM    510  CB  HIS A  32       3.290  -4.581   7.187  1.00  0.00           C  
ATOM    511  CG  HIS A  32       2.840  -5.780   7.984  1.00  0.00           C  
ATOM    512  ND1 HIS A  32       1.972  -6.729   7.499  1.00  0.00           N  
ATOM    513  CD2 HIS A  32       3.178  -6.196   9.228  1.00  0.00           C  
ATOM    514  CE1 HIS A  32       1.829  -7.675   8.400  1.00  0.00           C  
ATOM    515  NE2 HIS A  32       2.538  -7.372   9.454  1.00  0.00           N  
ATOM    516  H   HIS A  32       3.458  -6.514   4.689  1.00  0.00           H  
ATOM    517  HA  HIS A  32       4.580  -4.017   5.525  1.00  0.00           H  
ATOM    518  HB2 HIS A  32       3.870  -3.940   7.848  1.00  0.00           H  
ATOM    519  HB3 HIS A  32       2.408  -4.040   6.868  1.00  0.00           H  
ATOM    520  HD1 HIS A  32       1.496  -6.694   6.638  1.00  0.00           H  
ATOM    521  HD2 HIS A  32       3.830  -5.679   9.920  1.00  0.00           H  
ATOM    522  HE1 HIS A  32       1.222  -8.561   8.287  1.00  0.00           H  
ATOM    523  HE2 HIS A  32       2.494  -7.838  10.314  1.00  0.00           H  
ATOM    524  N   LEU A  33       6.247  -5.363   7.095  1.00  0.00           N  
ATOM    525  CA  LEU A  33       7.336  -6.174   7.672  1.00  0.00           C  
ATOM    526  C   LEU A  33       6.838  -6.905   8.931  1.00  0.00           C  
ATOM    527  O   LEU A  33       6.070  -6.328   9.693  1.00  0.00           O  
ATOM    528  CB  LEU A  33       8.515  -5.247   8.029  1.00  0.00           C  
ATOM    529  CG  LEU A  33       9.260  -4.639   6.806  1.00  0.00           C  
ATOM    530  CD1 LEU A  33      10.000  -3.352   7.194  1.00  0.00           C  
ATOM    531  CD2 LEU A  33      10.228  -5.672   6.160  1.00  0.00           C  
ATOM    532  H   LEU A  33       6.219  -4.404   7.295  1.00  0.00           H  
ATOM    533  HA  LEU A  33       7.658  -6.900   6.930  1.00  0.00           H  
ATOM    534  HB2 LEU A  33       8.128  -4.436   8.644  1.00  0.00           H  
ATOM    535  HB3 LEU A  33       9.229  -5.806   8.625  1.00  0.00           H  
ATOM    536  HG  LEU A  33       8.528  -4.372   6.054  1.00  0.00           H  
ATOM    537 HD11 LEU A  33      10.727  -3.560   7.969  1.00  0.00           H  
ATOM    538 HD12 LEU A  33       9.290  -2.619   7.558  1.00  0.00           H  
ATOM    539 HD13 LEU A  33      10.506  -2.946   6.327  1.00  0.00           H  
ATOM    540 HD21 LEU A  33      10.986  -5.968   6.875  1.00  0.00           H  
ATOM    541 HD22 LEU A  33      10.705  -5.229   5.295  1.00  0.00           H  
ATOM    542 HD23 LEU A  33       9.676  -6.548   5.845  1.00  0.00           H  
ATOM    543  N   PRO A  34       7.320  -8.156   9.209  1.00  0.00           N  
ATOM    544  CA  PRO A  34       6.849  -8.957  10.376  1.00  0.00           C  
ATOM    545  C   PRO A  34       7.327  -8.392  11.747  1.00  0.00           C  
ATOM    546  O   PRO A  34       7.042  -8.980  12.794  1.00  0.00           O  
ATOM    547  CB  PRO A  34       7.442 -10.360  10.084  1.00  0.00           C  
ATOM    548  CG  PRO A  34       8.688 -10.078   9.302  1.00  0.00           C  
ATOM    549  CD  PRO A  34       8.363  -8.887   8.428  1.00  0.00           C  
ATOM    550  HA  PRO A  34       5.763  -9.016  10.387  1.00  0.00           H  
ATOM    551  HB2 PRO A  34       7.657 -10.887  11.009  1.00  0.00           H  
ATOM    552  HB3 PRO A  34       6.737 -10.941   9.499  1.00  0.00           H  
ATOM    553  HG2 PRO A  34       9.506  -9.839   9.978  1.00  0.00           H  
ATOM    554  HG3 PRO A  34       8.951 -10.939   8.692  1.00  0.00           H  
ATOM    555  HD2 PRO A  34       9.244  -8.270   8.282  1.00  0.00           H  
ATOM    556  HD3 PRO A  34       7.968  -9.203   7.467  1.00  0.00           H  
ATOM    557  N   ASN A  35       8.067  -7.261  11.718  1.00  0.00           N  
ATOM    558  CA  ASN A  35       8.539  -6.538  12.925  1.00  0.00           C  
ATOM    559  C   ASN A  35       8.052  -5.070  12.906  1.00  0.00           C  
ATOM    560  O   ASN A  35       8.547  -4.243  13.685  1.00  0.00           O  
ATOM    561  CB  ASN A  35      10.097  -6.593  13.000  1.00  0.00           C  
ATOM    562  CG  ASN A  35      10.642  -8.024  13.072  1.00  0.00           C  
ATOM    563  OD1 ASN A  35      10.821  -8.585  14.155  1.00  0.00           O  
ATOM    564  ND2 ASN A  35      10.907  -8.626  11.917  1.00  0.00           N  
ATOM    565  H   ASN A  35       8.318  -6.901  10.849  1.00  0.00           H  
ATOM    566  HA  ASN A  35       8.125  -7.019  13.807  1.00  0.00           H  
ATOM    567  HB2 ASN A  35      10.515  -6.107  12.125  1.00  0.00           H  
ATOM    568  HB3 ASN A  35      10.430  -6.057  13.883  1.00  0.00           H  
ATOM    569 HD21 ASN A  35      10.750  -8.127  11.088  1.00  0.00           H  
ATOM    570 HD22 ASN A  35      11.242  -9.549  11.942  1.00  0.00           H  
ATOM    571  N   ALA A  36       7.069  -4.757  12.019  1.00  0.00           N  
ATOM    572  CA  ALA A  36       6.531  -3.386  11.841  1.00  0.00           C  
ATOM    573  C   ALA A  36       5.231  -3.187  12.645  1.00  0.00           C  
ATOM    574  O   ALA A  36       4.264  -3.933  12.461  1.00  0.00           O  
ATOM    575  CB  ALA A  36       6.293  -3.085  10.349  1.00  0.00           C  
ATOM    576  H   ALA A  36       6.682  -5.478  11.485  1.00  0.00           H  
ATOM    577  HA  ALA A  36       7.279  -2.683  12.202  1.00  0.00           H  
ATOM    578  HB1 ALA A  36       5.543  -3.759   9.954  1.00  0.00           H  
ATOM    579  HB2 ALA A  36       7.216  -3.218   9.798  1.00  0.00           H  
ATOM    580  HB3 ALA A  36       5.952  -2.063  10.226  1.00  0.00           H  
ATOM    581  N   THR A  37       5.234  -2.184  13.543  1.00  0.00           N  
ATOM    582  CA  THR A  37       4.063  -1.796  14.352  1.00  0.00           C  
ATOM    583  C   THR A  37       3.219  -0.765  13.582  1.00  0.00           C  
ATOM    584  O   THR A  37       3.751   0.269  13.165  1.00  0.00           O  
ATOM    585  CB  THR A  37       4.534  -1.190  15.719  1.00  0.00           C  
ATOM    586  OG1 THR A  37       5.319  -2.167  16.424  1.00  0.00           O  
ATOM    587  CG2 THR A  37       3.357  -0.727  16.613  1.00  0.00           C  
ATOM    588  H   THR A  37       6.065  -1.684  13.676  1.00  0.00           H  
ATOM    589  HA  THR A  37       3.465  -2.682  14.553  1.00  0.00           H  
ATOM    590  HB  THR A  37       5.172  -0.329  15.515  1.00  0.00           H  
ATOM    591  HG1 THR A  37       5.901  -2.620  15.804  1.00  0.00           H  
ATOM    592 HG21 THR A  37       2.797   0.051  16.106  1.00  0.00           H  
ATOM    593 HG22 THR A  37       3.740  -0.337  17.546  1.00  0.00           H  
ATOM    594 HG23 THR A  37       2.702  -1.563  16.817  1.00  0.00           H  
ATOM    595  N   LEU A  38       1.914  -1.050  13.380  1.00  0.00           N  
ATOM    596  CA  LEU A  38       1.008  -0.130  12.676  1.00  0.00           C  
ATOM    597  C   LEU A  38       0.756   1.135  13.508  1.00  0.00           C  
ATOM    598  O   LEU A  38       0.161   1.076  14.589  1.00  0.00           O  
ATOM    599  CB  LEU A  38      -0.353  -0.787  12.336  1.00  0.00           C  
ATOM    600  CG  LEU A  38      -1.449   0.179  11.748  1.00  0.00           C  
ATOM    601  CD1 LEU A  38      -0.949   0.939  10.489  1.00  0.00           C  
ATOM    602  CD2 LEU A  38      -2.758  -0.576  11.455  1.00  0.00           C  
ATOM    603  H   LEU A  38       1.555  -1.898  13.718  1.00  0.00           H  
ATOM    604  HA  LEU A  38       1.493   0.151  11.740  1.00  0.00           H  
ATOM    605  HB2 LEU A  38      -0.177  -1.582  11.619  1.00  0.00           H  
ATOM    606  HB3 LEU A  38      -0.748  -1.232  13.243  1.00  0.00           H  
ATOM    607  HG  LEU A  38      -1.675   0.932  12.497  1.00  0.00           H  
ATOM    608 HD11 LEU A  38      -1.736   1.579  10.115  1.00  0.00           H  
ATOM    609 HD12 LEU A  38      -0.668   0.232   9.720  1.00  0.00           H  
ATOM    610 HD13 LEU A  38      -0.090   1.546  10.745  1.00  0.00           H  
ATOM    611 HD21 LEU A  38      -3.108  -1.068  12.353  1.00  0.00           H  
ATOM    612 HD22 LEU A  38      -2.585  -1.322  10.684  1.00  0.00           H  
ATOM    613 HD23 LEU A  38      -3.512   0.119  11.114  1.00  0.00           H  
ATOM    614  N   ILE A  39       1.251   2.254  12.984  1.00  0.00           N  
ATOM    615  CA  ILE A  39       0.936   3.609  13.439  1.00  0.00           C  
ATOM    616  C   ILE A  39       0.819   4.467  12.172  1.00  0.00           C  
ATOM    617  O   ILE A  39       1.559   4.264  11.219  1.00  0.00           O  
ATOM    618  CB  ILE A  39       2.053   4.181  14.404  1.00  0.00           C  
ATOM    619  CG1 ILE A  39       2.173   3.310  15.704  1.00  0.00           C  
ATOM    620  CG2 ILE A  39       1.793   5.666  14.763  1.00  0.00           C  
ATOM    621  CD1 ILE A  39       3.349   3.630  16.615  1.00  0.00           C  
ATOM    622  H   ILE A  39       1.876   2.165  12.230  1.00  0.00           H  
ATOM    623  HA  ILE A  39      -0.025   3.596  13.958  1.00  0.00           H  
ATOM    624  HB  ILE A  39       2.997   4.134  13.868  1.00  0.00           H  
ATOM    625 HG12 ILE A  39       1.274   3.427  16.296  1.00  0.00           H  
ATOM    626 HG13 ILE A  39       2.258   2.268  15.420  1.00  0.00           H  
ATOM    627 HG21 ILE A  39       0.848   5.763  15.285  1.00  0.00           H  
ATOM    628 HG22 ILE A  39       1.760   6.264  13.861  1.00  0.00           H  
ATOM    629 HG23 ILE A  39       2.589   6.031  15.397  1.00  0.00           H  
ATOM    630 HD11 ILE A  39       3.363   2.934  17.440  1.00  0.00           H  
ATOM    631 HD12 ILE A  39       3.250   4.635  16.995  1.00  0.00           H  
ATOM    632 HD13 ILE A  39       4.275   3.546  16.060  1.00  0.00           H  
ATOM    633  N   SER A  40      -0.115   5.400  12.127  1.00  0.00           N  
ATOM    634  CA  SER A  40      -0.243   6.284  10.955  1.00  0.00           C  
ATOM    635  C   SER A  40       0.667   7.513  11.143  1.00  0.00           C  
ATOM    636  O   SER A  40       1.001   7.885  12.276  1.00  0.00           O  
ATOM    637  CB  SER A  40      -1.709   6.694  10.740  1.00  0.00           C  
ATOM    638  OG  SER A  40      -2.557   5.556  10.673  1.00  0.00           O  
ATOM    639  H   SER A  40      -0.704   5.521  12.899  1.00  0.00           H  
ATOM    640  HA  SER A  40       0.094   5.733  10.074  1.00  0.00           H  
ATOM    641  HB2 SER A  40      -2.040   7.321  11.559  1.00  0.00           H  
ATOM    642  HB3 SER A  40      -1.800   7.243   9.811  1.00  0.00           H  
ATOM    643  HG  SER A  40      -2.572   5.115  11.533  1.00  0.00           H  
ATOM    644  N   VAL A  41       1.092   8.117  10.024  1.00  0.00           N  
ATOM    645  CA  VAL A  41       1.855   9.387  10.023  1.00  0.00           C  
ATOM    646  C   VAL A  41       1.063  10.549  10.700  1.00  0.00           C  
ATOM    647  O   VAL A  41       1.661  11.519  11.168  1.00  0.00           O  
ATOM    648  CB  VAL A  41       2.281   9.759   8.552  1.00  0.00           C  
ATOM    649  CG1 VAL A  41       1.054   9.943   7.628  1.00  0.00           C  
ATOM    650  CG2 VAL A  41       3.219  10.993   8.518  1.00  0.00           C  
ATOM    651  H   VAL A  41       0.924   7.676   9.167  1.00  0.00           H  
ATOM    652  HA  VAL A  41       2.762   9.217  10.599  1.00  0.00           H  
ATOM    653  HB  VAL A  41       2.844   8.914   8.160  1.00  0.00           H  
ATOM    654 HG11 VAL A  41       1.382  10.170   6.621  1.00  0.00           H  
ATOM    655 HG12 VAL A  41       0.435  10.756   7.991  1.00  0.00           H  
ATOM    656 HG13 VAL A  41       0.468   9.032   7.616  1.00  0.00           H  
ATOM    657 HG21 VAL A  41       4.099  10.796   9.117  1.00  0.00           H  
ATOM    658 HG22 VAL A  41       2.707  11.862   8.916  1.00  0.00           H  
ATOM    659 HG23 VAL A  41       3.527  11.198   7.500  1.00  0.00           H  
ATOM    660  N   ASN A  42      -0.283  10.422  10.762  1.00  0.00           N  
ATOM    661  CA  ASN A  42      -1.160  11.394  11.462  1.00  0.00           C  
ATOM    662  C   ASN A  42      -1.343  11.035  12.955  1.00  0.00           C  
ATOM    663  O   ASN A  42      -1.768  11.888  13.753  1.00  0.00           O  
ATOM    664  CB  ASN A  42      -2.546  11.487  10.767  1.00  0.00           C  
ATOM    665  CG  ASN A  42      -3.326  10.164  10.765  1.00  0.00           C  
ATOM    666  OD1 ASN A  42      -4.044   9.844  11.708  1.00  0.00           O  
ATOM    667  ND2 ASN A  42      -3.197   9.391   9.699  1.00  0.00           N  
ATOM    668  H   ASN A  42      -0.700   9.655  10.319  1.00  0.00           H  
ATOM    669  HA  ASN A  42      -0.679  12.370  11.411  1.00  0.00           H  
ATOM    670  HB2 ASN A  42      -3.148  12.235  11.272  1.00  0.00           H  
ATOM    671  HB3 ASN A  42      -2.400  11.805   9.739  1.00  0.00           H  
ATOM    672 HD21 ASN A  42      -2.620   9.699   8.971  1.00  0.00           H  
ATOM    673 HD22 ASN A  42      -3.693   8.543   9.678  1.00  0.00           H  
ATOM    674  N   ASP A  43      -1.046   9.770  13.321  1.00  0.00           N  
ATOM    675  CA  ASP A  43      -1.167   9.280  14.710  1.00  0.00           C  
ATOM    676  C   ASP A  43       0.044   9.740  15.535  1.00  0.00           C  
ATOM    677  O   ASP A  43       0.977   8.974  15.770  1.00  0.00           O  
ATOM    678  CB  ASP A  43      -1.310   7.722  14.767  1.00  0.00           C  
ATOM    679  CG  ASP A  43      -2.604   7.153  14.164  1.00  0.00           C  
ATOM    680  OD1 ASP A  43      -3.616   7.879  14.071  1.00  0.00           O  
ATOM    681  OD2 ASP A  43      -2.630   5.947  13.823  1.00  0.00           O  
ATOM    682  H   ASP A  43      -0.724   9.152  12.639  1.00  0.00           H  
ATOM    683  HA  ASP A  43      -2.060   9.722  15.147  1.00  0.00           H  
ATOM    684  HB2 ASP A  43      -0.474   7.283  14.238  1.00  0.00           H  
ATOM    685  HB3 ASP A  43      -1.259   7.405  15.805  1.00  0.00           H  
ATOM    686  N   GLN A  44       0.037  11.024  15.930  1.00  0.00           N  
ATOM    687  CA  GLN A  44       1.119  11.624  16.739  1.00  0.00           C  
ATOM    688  C   GLN A  44       1.017  11.190  18.204  1.00  0.00           C  
ATOM    689  O   GLN A  44       2.036  10.986  18.854  1.00  0.00           O  
ATOM    690  CB  GLN A  44       1.125  13.185  16.587  1.00  0.00           C  
ATOM    691  CG  GLN A  44       2.051  13.725  15.476  1.00  0.00           C  
ATOM    692  CD  GLN A  44       1.856  13.026  14.124  1.00  0.00           C  
ATOM    693  OE1 GLN A  44       1.040  13.442  13.305  1.00  0.00           O  
ATOM    694  NE2 GLN A  44       2.622  11.965  13.873  1.00  0.00           N  
ATOM    695  H   GLN A  44      -0.717  11.592  15.663  1.00  0.00           H  
ATOM    696  HA  GLN A  44       2.061  11.238  16.345  1.00  0.00           H  
ATOM    697  HB2 GLN A  44       0.114  13.517  16.375  1.00  0.00           H  
ATOM    698  HB3 GLN A  44       1.440  13.639  17.522  1.00  0.00           H  
ATOM    699  HG2 GLN A  44       1.875  14.787  15.349  1.00  0.00           H  
ATOM    700  HG3 GLN A  44       3.081  13.594  15.789  1.00  0.00           H  
ATOM    701 HE21 GLN A  44       3.264  11.686  14.551  1.00  0.00           H  
ATOM    702 HE22 GLN A  44       2.521  11.515  13.007  1.00  0.00           H  
ATOM    703  N   GLU A  45      -0.217  11.032  18.700  1.00  0.00           N  
ATOM    704  CA  GLU A  45      -0.478  10.598  20.092  1.00  0.00           C  
ATOM    705  C   GLU A  45      -0.104   9.114  20.300  1.00  0.00           C  
ATOM    706  O   GLU A  45       0.397   8.740  21.359  1.00  0.00           O  
ATOM    707  CB  GLU A  45      -1.961  10.906  20.509  1.00  0.00           C  
ATOM    708  CG  GLU A  45      -3.027  10.748  19.396  1.00  0.00           C  
ATOM    709  CD  GLU A  45      -3.222   9.311  18.890  1.00  0.00           C  
ATOM    710  OE1 GLU A  45      -3.740   8.465  19.653  1.00  0.00           O  
ATOM    711  OE2 GLU A  45      -2.829   9.017  17.739  1.00  0.00           O  
ATOM    712  H   GLU A  45      -0.976  11.209  18.112  1.00  0.00           H  
ATOM    713  HA  GLU A  45       0.177  11.190  20.728  1.00  0.00           H  
ATOM    714  HB2 GLU A  45      -2.244  10.264  21.336  1.00  0.00           H  
ATOM    715  HB3 GLU A  45      -2.008  11.935  20.860  1.00  0.00           H  
ATOM    716  HG2 GLU A  45      -3.976  11.110  19.769  1.00  0.00           H  
ATOM    717  HG3 GLU A  45      -2.722  11.373  18.561  1.00  0.00           H  
ATOM    718  N   LYS A  46      -0.331   8.284  19.265  1.00  0.00           N  
ATOM    719  CA  LYS A  46      -0.033   6.839  19.297  1.00  0.00           C  
ATOM    720  C   LYS A  46       1.469   6.594  19.066  1.00  0.00           C  
ATOM    721  O   LYS A  46       2.070   5.710  19.692  1.00  0.00           O  
ATOM    722  CB  LYS A  46      -0.886   6.096  18.231  1.00  0.00           C  
ATOM    723  CG  LYS A  46      -0.697   4.553  18.117  1.00  0.00           C  
ATOM    724  CD  LYS A  46      -1.159   3.735  19.367  1.00  0.00           C  
ATOM    725  CE  LYS A  46      -0.057   3.532  20.427  1.00  0.00           C  
ATOM    726  NZ  LYS A  46      -0.522   2.710  21.573  1.00  0.00           N  
ATOM    727  H   LYS A  46      -0.716   8.662  18.444  1.00  0.00           H  
ATOM    728  HA  LYS A  46      -0.302   6.462  20.281  1.00  0.00           H  
ATOM    729  HB2 LYS A  46      -1.935   6.281  18.446  1.00  0.00           H  
ATOM    730  HB3 LYS A  46      -0.665   6.530  17.261  1.00  0.00           H  
ATOM    731  HG2 LYS A  46      -1.263   4.209  17.258  1.00  0.00           H  
ATOM    732  HG3 LYS A  46       0.353   4.352  17.933  1.00  0.00           H  
ATOM    733  HD2 LYS A  46      -1.995   4.240  19.835  1.00  0.00           H  
ATOM    734  HD3 LYS A  46      -1.493   2.755  19.033  1.00  0.00           H  
ATOM    735  HE2 LYS A  46       0.786   3.036  19.967  1.00  0.00           H  
ATOM    736  HE3 LYS A  46       0.259   4.500  20.798  1.00  0.00           H  
ATOM    737  HZ1 LYS A  46      -1.395   3.114  21.970  1.00  0.00           H  
ATOM    738  HZ2 LYS A  46       0.206   2.688  22.318  1.00  0.00           H  
ATOM    739  HZ3 LYS A  46      -0.712   1.739  21.261  1.00  0.00           H  
ATOM    740  N   LEU A  47       2.073   7.399  18.183  1.00  0.00           N  
ATOM    741  CA  LEU A  47       3.506   7.271  17.850  1.00  0.00           C  
ATOM    742  C   LEU A  47       4.360   7.688  19.050  1.00  0.00           C  
ATOM    743  O   LEU A  47       5.262   6.960  19.466  1.00  0.00           O  
ATOM    744  CB  LEU A  47       3.842   8.116  16.605  1.00  0.00           C  
ATOM    745  CG  LEU A  47       5.264   7.944  15.978  1.00  0.00           C  
ATOM    746  CD1 LEU A  47       5.627   6.459  15.704  1.00  0.00           C  
ATOM    747  CD2 LEU A  47       5.361   8.771  14.680  1.00  0.00           C  
ATOM    748  H   LEU A  47       1.540   8.106  17.749  1.00  0.00           H  
ATOM    749  HA  LEU A  47       3.698   6.230  17.628  1.00  0.00           H  
ATOM    750  HB2 LEU A  47       3.109   7.882  15.845  1.00  0.00           H  
ATOM    751  HB3 LEU A  47       3.714   9.162  16.867  1.00  0.00           H  
ATOM    752  HG  LEU A  47       6.004   8.335  16.669  1.00  0.00           H  
ATOM    753 HD11 LEU A  47       5.625   5.905  16.632  1.00  0.00           H  
ATOM    754 HD12 LEU A  47       6.615   6.401  15.263  1.00  0.00           H  
ATOM    755 HD13 LEU A  47       4.907   6.022  15.022  1.00  0.00           H  
ATOM    756 HD21 LEU A  47       4.644   8.404  13.954  1.00  0.00           H  
ATOM    757 HD22 LEU A  47       6.357   8.691  14.271  1.00  0.00           H  
ATOM    758 HD23 LEU A  47       5.152   9.813  14.892  1.00  0.00           H  
ATOM    759  N   ALA A  48       4.014   8.852  19.619  1.00  0.00           N  
ATOM    760  CA  ALA A  48       4.675   9.404  20.805  1.00  0.00           C  
ATOM    761  C   ALA A  48       4.464   8.501  22.031  1.00  0.00           C  
ATOM    762  O   ALA A  48       5.349   8.406  22.871  1.00  0.00           O  
ATOM    763  CB  ALA A  48       4.174  10.822  21.075  1.00  0.00           C  
ATOM    764  H   ALA A  48       3.279   9.360  19.222  1.00  0.00           H  
ATOM    765  HA  ALA A  48       5.743   9.462  20.594  1.00  0.00           H  
ATOM    766  HB1 ALA A  48       4.336  11.433  20.194  1.00  0.00           H  
ATOM    767  HB2 ALA A  48       4.709  11.250  21.912  1.00  0.00           H  
ATOM    768  HB3 ALA A  48       3.114  10.800  21.297  1.00  0.00           H  
ATOM    769  N   ASP A  49       3.288   7.841  22.109  1.00  0.00           N  
ATOM    770  CA  ASP A  49       2.986   6.846  23.166  1.00  0.00           C  
ATOM    771  C   ASP A  49       3.979   5.667  23.098  1.00  0.00           C  
ATOM    772  O   ASP A  49       4.574   5.293  24.109  1.00  0.00           O  
ATOM    773  CB  ASP A  49       1.530   6.323  23.026  1.00  0.00           C  
ATOM    774  CG  ASP A  49       1.177   5.209  24.029  1.00  0.00           C  
ATOM    775  OD1 ASP A  49       0.899   5.527  25.203  1.00  0.00           O  
ATOM    776  OD2 ASP A  49       1.207   4.011  23.656  1.00  0.00           O  
ATOM    777  H   ASP A  49       2.598   8.029  21.438  1.00  0.00           H  
ATOM    778  HA  ASP A  49       3.093   7.344  24.127  1.00  0.00           H  
ATOM    779  HB2 ASP A  49       0.844   7.153  23.182  1.00  0.00           H  
ATOM    780  HB3 ASP A  49       1.385   5.949  22.016  1.00  0.00           H  
ATOM    781  N   PHE A  50       4.152   5.117  21.880  1.00  0.00           N  
ATOM    782  CA  PHE A  50       5.065   3.979  21.603  1.00  0.00           C  
ATOM    783  C   PHE A  50       6.525   4.336  21.971  1.00  0.00           C  
ATOM    784  O   PHE A  50       7.288   3.495  22.472  1.00  0.00           O  
ATOM    785  CB  PHE A  50       4.957   3.586  20.100  1.00  0.00           C  
ATOM    786  CG  PHE A  50       5.764   2.343  19.687  1.00  0.00           C  
ATOM    787  CD1 PHE A  50       5.261   1.060  19.916  1.00  0.00           C  
ATOM    788  CD2 PHE A  50       7.009   2.456  19.062  1.00  0.00           C  
ATOM    789  CE1 PHE A  50       5.978  -0.064  19.540  1.00  0.00           C  
ATOM    790  CE2 PHE A  50       7.721   1.330  18.692  1.00  0.00           C  
ATOM    791  CZ  PHE A  50       7.207   0.071  18.927  1.00  0.00           C  
ATOM    792  H   PHE A  50       3.641   5.493  21.129  1.00  0.00           H  
ATOM    793  HA  PHE A  50       4.741   3.141  22.209  1.00  0.00           H  
ATOM    794  HB2 PHE A  50       3.914   3.396  19.866  1.00  0.00           H  
ATOM    795  HB3 PHE A  50       5.288   4.424  19.493  1.00  0.00           H  
ATOM    796  HD1 PHE A  50       4.298   0.944  20.402  1.00  0.00           H  
ATOM    797  HD2 PHE A  50       7.427   3.436  18.874  1.00  0.00           H  
ATOM    798  HE1 PHE A  50       5.574  -1.051  19.726  1.00  0.00           H  
ATOM    799  HE2 PHE A  50       8.683   1.435  18.208  1.00  0.00           H  
ATOM    800  HZ  PHE A  50       7.767  -0.808  18.634  1.00  0.00           H  
ATOM    801  N   LEU A  51       6.890   5.600  21.717  1.00  0.00           N  
ATOM    802  CA  LEU A  51       8.232   6.129  22.006  1.00  0.00           C  
ATOM    803  C   LEU A  51       8.381   6.502  23.496  1.00  0.00           C  
ATOM    804  O   LEU A  51       9.491   6.541  24.011  1.00  0.00           O  
ATOM    805  CB  LEU A  51       8.525   7.354  21.106  1.00  0.00           C  
ATOM    806  CG  LEU A  51       8.402   7.132  19.564  1.00  0.00           C  
ATOM    807  CD1 LEU A  51       8.610   8.449  18.806  1.00  0.00           C  
ATOM    808  CD2 LEU A  51       9.363   6.045  19.040  1.00  0.00           C  
ATOM    809  H   LEU A  51       6.225   6.205  21.319  1.00  0.00           H  
ATOM    810  HA  LEU A  51       8.955   5.350  21.773  1.00  0.00           H  
ATOM    811  HB2 LEU A  51       7.841   8.151  21.393  1.00  0.00           H  
ATOM    812  HB3 LEU A  51       9.537   7.695  21.318  1.00  0.00           H  
ATOM    813  HG  LEU A  51       7.394   6.800  19.348  1.00  0.00           H  
ATOM    814 HD11 LEU A  51       9.599   8.841  19.010  1.00  0.00           H  
ATOM    815 HD12 LEU A  51       7.869   9.171  19.120  1.00  0.00           H  
ATOM    816 HD13 LEU A  51       8.505   8.280  17.741  1.00  0.00           H  
ATOM    817 HD21 LEU A  51       9.151   5.103  19.527  1.00  0.00           H  
ATOM    818 HD22 LEU A  51      10.389   6.330  19.242  1.00  0.00           H  
ATOM    819 HD23 LEU A  51       9.233   5.925  17.971  1.00  0.00           H  
ATOM    820  N   SER A  52       7.253   6.798  24.167  1.00  0.00           N  
ATOM    821  CA  SER A  52       7.230   7.163  25.600  1.00  0.00           C  
ATOM    822  C   SER A  52       7.279   5.911  26.507  1.00  0.00           C  
ATOM    823  O   SER A  52       7.621   6.025  27.690  1.00  0.00           O  
ATOM    824  CB  SER A  52       5.988   8.025  25.920  1.00  0.00           C  
ATOM    825  OG  SER A  52       5.993   8.489  27.262  1.00  0.00           O  
ATOM    826  H   SER A  52       6.405   6.776  23.680  1.00  0.00           H  
ATOM    827  HA  SER A  52       8.118   7.757  25.798  1.00  0.00           H  
ATOM    828  HB2 SER A  52       5.969   8.885  25.265  1.00  0.00           H  
ATOM    829  HB3 SER A  52       5.091   7.440  25.760  1.00  0.00           H  
ATOM    830  HG  SER A  52       5.088   8.651  27.552  1.00  0.00           H  
ATOM    831  N   GLN A  53       6.927   4.724  25.946  1.00  0.00           N  
ATOM    832  CA  GLN A  53       7.008   3.425  26.673  1.00  0.00           C  
ATOM    833  C   GLN A  53       8.467   3.143  27.114  1.00  0.00           C  
ATOM    834  O   GLN A  53       8.723   2.615  28.200  1.00  0.00           O  
ATOM    835  CB  GLN A  53       6.480   2.260  25.782  1.00  0.00           C  
ATOM    836  CG  GLN A  53       5.014   2.401  25.309  1.00  0.00           C  
ATOM    837  CD  GLN A  53       3.991   2.580  26.443  1.00  0.00           C  
ATOM    838  OE1 GLN A  53       4.168   2.080  27.556  1.00  0.00           O  
ATOM    839  NE2 GLN A  53       2.904   3.284  26.168  1.00  0.00           N  
ATOM    840  H   GLN A  53       6.595   4.725  25.024  1.00  0.00           H  
ATOM    841  HA  GLN A  53       6.380   3.502  27.559  1.00  0.00           H  
ATOM    842  HB2 GLN A  53       7.109   2.187  24.900  1.00  0.00           H  
ATOM    843  HB3 GLN A  53       6.562   1.329  26.334  1.00  0.00           H  
ATOM    844  HG2 GLN A  53       4.951   3.256  24.648  1.00  0.00           H  
ATOM    845  HG3 GLN A  53       4.747   1.512  24.748  1.00  0.00           H  
ATOM    846 HE21 GLN A  53       2.807   3.656  25.266  1.00  0.00           H  
ATOM    847 HE22 GLN A  53       2.239   3.409  26.877  1.00  0.00           H  
ATOM    848  N   HIS A  54       9.383   3.534  26.226  1.00  0.00           N  
ATOM    849  CA  HIS A  54      10.836   3.509  26.407  1.00  0.00           C  
ATOM    850  C   HIS A  54      11.383   4.430  25.330  1.00  0.00           C  
ATOM    851  O   HIS A  54      11.147   4.174  24.161  1.00  0.00           O  
ATOM    852  CB  HIS A  54      11.467   2.077  26.260  1.00  0.00           C  
ATOM    853  CG  HIS A  54      11.562   1.304  27.553  1.00  0.00           C  
ATOM    854  ND1 HIS A  54      10.678   0.308  27.919  1.00  0.00           N  
ATOM    855  CD2 HIS A  54      12.472   1.374  28.557  1.00  0.00           C  
ATOM    856  CE1 HIS A  54      11.032  -0.180  29.090  1.00  0.00           C  
ATOM    857  NE2 HIS A  54      12.117   0.448  29.496  1.00  0.00           N  
ATOM    858  H   HIS A  54       9.058   3.902  25.380  1.00  0.00           H  
ATOM    859  HA  HIS A  54      11.067   3.925  27.387  1.00  0.00           H  
ATOM    860  HB2 HIS A  54      10.866   1.495  25.575  1.00  0.00           H  
ATOM    861  HB3 HIS A  54      12.475   2.158  25.848  1.00  0.00           H  
ATOM    862  HD1 HIS A  54       9.901   0.010  27.400  1.00  0.00           H  
ATOM    863  HD2 HIS A  54      13.318   2.046  28.610  1.00  0.00           H  
ATOM    864  HE1 HIS A  54      10.525  -0.967  29.622  1.00  0.00           H  
ATOM    865  HE2 HIS A  54      12.626   0.241  30.313  1.00  0.00           H  
ATOM    866  N   LYS A  55      12.004   5.546  25.726  1.00  0.00           N  
ATOM    867  CA  LYS A  55      12.693   6.459  24.781  1.00  0.00           C  
ATOM    868  C   LYS A  55      14.041   5.863  24.365  1.00  0.00           C  
ATOM    869  O   LYS A  55      14.480   6.034  23.220  1.00  0.00           O  
ATOM    870  CB  LYS A  55      12.885   7.868  25.402  1.00  0.00           C  
ATOM    871  CG  LYS A  55      11.562   8.599  25.713  1.00  0.00           C  
ATOM    872  CD  LYS A  55      11.777  10.012  26.305  1.00  0.00           C  
ATOM    873  CE  LYS A  55      12.529  10.958  25.353  1.00  0.00           C  
ATOM    874  NZ  LYS A  55      12.693  12.317  25.932  1.00  0.00           N  
ATOM    875  H   LYS A  55      11.977   5.777  26.676  1.00  0.00           H  
ATOM    876  HA  LYS A  55      12.070   6.551  23.892  1.00  0.00           H  
ATOM    877  HB2 LYS A  55      13.447   7.769  26.327  1.00  0.00           H  
ATOM    878  HB3 LYS A  55      13.459   8.482  24.715  1.00  0.00           H  
ATOM    879  HG2 LYS A  55      10.985   8.687  24.798  1.00  0.00           H  
ATOM    880  HG3 LYS A  55      10.997   8.006  26.425  1.00  0.00           H  
ATOM    881  HD2 LYS A  55      10.809  10.446  26.530  1.00  0.00           H  
ATOM    882  HD3 LYS A  55      12.342   9.919  27.227  1.00  0.00           H  
ATOM    883  HE2 LYS A  55      13.512  10.552  25.148  1.00  0.00           H  
ATOM    884  HE3 LYS A  55      11.979  11.042  24.426  1.00  0.00           H  
ATOM    885  HZ1 LYS A  55      13.202  12.932  25.263  1.00  0.00           H  
ATOM    886  HZ2 LYS A  55      13.234  12.269  26.820  1.00  0.00           H  
ATOM    887  HZ3 LYS A  55      11.763  12.735  26.127  1.00  0.00           H  
ATOM    888  N   ASP A  56      14.689   5.159  25.313  1.00  0.00           N  
ATOM    889  CA  ASP A  56      15.945   4.432  25.070  1.00  0.00           C  
ATOM    890  C   ASP A  56      15.657   3.105  24.350  1.00  0.00           C  
ATOM    891  O   ASP A  56      15.514   2.048  24.982  1.00  0.00           O  
ATOM    892  CB  ASP A  56      16.717   4.197  26.404  1.00  0.00           C  
ATOM    893  CG  ASP A  56      17.454   5.448  26.909  1.00  0.00           C  
ATOM    894  OD1 ASP A  56      16.789   6.450  27.248  1.00  0.00           O  
ATOM    895  OD2 ASP A  56      18.708   5.441  26.968  1.00  0.00           O  
ATOM    896  H   ASP A  56      14.302   5.126  26.212  1.00  0.00           H  
ATOM    897  HA  ASP A  56      16.564   5.047  24.415  1.00  0.00           H  
ATOM    898  HB2 ASP A  56      16.014   3.886  27.170  1.00  0.00           H  
ATOM    899  HB3 ASP A  56      17.441   3.396  26.260  1.00  0.00           H  
ATOM    900  N   LYS A  57      15.495   3.207  23.026  1.00  0.00           N  
ATOM    901  CA  LYS A  57      15.404   2.053  22.118  1.00  0.00           C  
ATOM    902  C   LYS A  57      15.723   2.520  20.683  1.00  0.00           C  
ATOM    903  O   LYS A  57      15.756   3.731  20.405  1.00  0.00           O  
ATOM    904  CB  LYS A  57      14.009   1.346  22.209  1.00  0.00           C  
ATOM    905  CG  LYS A  57      12.850   1.944  21.377  1.00  0.00           C  
ATOM    906  CD  LYS A  57      12.581   3.430  21.660  1.00  0.00           C  
ATOM    907  CE  LYS A  57      11.258   3.916  21.060  1.00  0.00           C  
ATOM    908  NZ  LYS A  57      10.082   3.185  21.620  1.00  0.00           N  
ATOM    909  H   LYS A  57      15.428   4.105  22.636  1.00  0.00           H  
ATOM    910  HA  LYS A  57      16.173   1.344  22.420  1.00  0.00           H  
ATOM    911  HB2 LYS A  57      14.130   0.317  21.898  1.00  0.00           H  
ATOM    912  HB3 LYS A  57      13.704   1.343  23.250  1.00  0.00           H  
ATOM    913  HG2 LYS A  57      13.090   1.831  20.324  1.00  0.00           H  
ATOM    914  HG3 LYS A  57      11.947   1.376  21.589  1.00  0.00           H  
ATOM    915  HD2 LYS A  57      12.552   3.581  22.730  1.00  0.00           H  
ATOM    916  HD3 LYS A  57      13.392   4.020  21.245  1.00  0.00           H  
ATOM    917  HE2 LYS A  57      11.142   4.970  21.275  1.00  0.00           H  
ATOM    918  HE3 LYS A  57      11.279   3.775  19.988  1.00  0.00           H  
ATOM    919  HZ1 LYS A  57      10.171   2.162  21.448  1.00  0.00           H  
ATOM    920  HZ2 LYS A  57       9.202   3.524  21.184  1.00  0.00           H  
ATOM    921  HZ3 LYS A  57      10.024   3.341  22.646  1.00  0.00           H  
ATOM    922  N   LYS A  58      15.933   1.567  19.776  1.00  0.00           N  
ATOM    923  CA  LYS A  58      16.238   1.860  18.369  1.00  0.00           C  
ATOM    924  C   LYS A  58      15.033   1.483  17.493  1.00  0.00           C  
ATOM    925  O   LYS A  58      14.816   0.305  17.211  1.00  0.00           O  
ATOM    926  CB  LYS A  58      17.508   1.095  17.945  1.00  0.00           C  
ATOM    927  CG  LYS A  58      18.149   1.632  16.653  1.00  0.00           C  
ATOM    928  CD  LYS A  58      19.608   1.173  16.488  1.00  0.00           C  
ATOM    929  CE  LYS A  58      19.770  -0.359  16.514  1.00  0.00           C  
ATOM    930  NZ  LYS A  58      21.171  -0.773  16.260  1.00  0.00           N  
ATOM    931  H   LYS A  58      15.890   0.633  20.061  1.00  0.00           H  
ATOM    932  HA  LYS A  58      16.440   2.926  18.261  1.00  0.00           H  
ATOM    933  HB2 LYS A  58      18.239   1.165  18.748  1.00  0.00           H  
ATOM    934  HB3 LYS A  58      17.257   0.044  17.792  1.00  0.00           H  
ATOM    935  HG2 LYS A  58      17.569   1.285  15.805  1.00  0.00           H  
ATOM    936  HG3 LYS A  58      18.124   2.718  16.671  1.00  0.00           H  
ATOM    937  HD2 LYS A  58      19.986   1.552  15.546  1.00  0.00           H  
ATOM    938  HD3 LYS A  58      20.187   1.602  17.297  1.00  0.00           H  
ATOM    939  HE2 LYS A  58      19.473  -0.731  17.485  1.00  0.00           H  
ATOM    940  HE3 LYS A  58      19.135  -0.798  15.754  1.00  0.00           H  
ATOM    941  HZ1 LYS A  58      21.271  -1.803  16.375  1.00  0.00           H  
ATOM    942  HZ2 LYS A  58      21.815  -0.298  16.924  1.00  0.00           H  
ATOM    943  HZ3 LYS A  58      21.447  -0.524  15.286  1.00  0.00           H  
ATOM    944  N   VAL A  59      14.223   2.488  17.118  1.00  0.00           N  
ATOM    945  CA  VAL A  59      13.012   2.287  16.291  1.00  0.00           C  
ATOM    946  C   VAL A  59      13.169   2.952  14.918  1.00  0.00           C  
ATOM    947  O   VAL A  59      13.685   4.070  14.811  1.00  0.00           O  
ATOM    948  CB  VAL A  59      11.712   2.798  17.038  1.00  0.00           C  
ATOM    949  CG1 VAL A  59      10.508   3.018  16.091  1.00  0.00           C  
ATOM    950  CG2 VAL A  59      11.313   1.807  18.149  1.00  0.00           C  
ATOM    951  H   VAL A  59      14.449   3.399  17.405  1.00  0.00           H  
ATOM    952  HA  VAL A  59      12.898   1.213  16.127  1.00  0.00           H  
ATOM    953  HB  VAL A  59      11.947   3.750  17.507  1.00  0.00           H  
ATOM    954 HG11 VAL A  59       9.646   3.346  16.661  1.00  0.00           H  
ATOM    955 HG12 VAL A  59      10.268   2.093  15.580  1.00  0.00           H  
ATOM    956 HG13 VAL A  59      10.757   3.771  15.360  1.00  0.00           H  
ATOM    957 HG21 VAL A  59      10.468   2.196  18.703  1.00  0.00           H  
ATOM    958 HG22 VAL A  59      12.143   1.666  18.823  1.00  0.00           H  
ATOM    959 HG23 VAL A  59      11.043   0.850  17.713  1.00  0.00           H  
ATOM    960  N   LEU A  60      12.694   2.237  13.881  1.00  0.00           N  
ATOM    961  CA  LEU A  60      12.798   2.656  12.482  1.00  0.00           C  
ATOM    962  C   LEU A  60      11.397   2.824  11.854  1.00  0.00           C  
ATOM    963  O   LEU A  60      10.705   1.834  11.597  1.00  0.00           O  
ATOM    964  CB  LEU A  60      13.595   1.594  11.691  1.00  0.00           C  
ATOM    965  CG  LEU A  60      13.891   1.949  10.208  1.00  0.00           C  
ATOM    966  CD1 LEU A  60      14.898   3.107  10.112  1.00  0.00           C  
ATOM    967  CD2 LEU A  60      14.378   0.720   9.427  1.00  0.00           C  
ATOM    968  H   LEU A  60      12.256   1.376  14.072  1.00  0.00           H  
ATOM    969  HA  LEU A  60      13.329   3.604  12.432  1.00  0.00           H  
ATOM    970  HB2 LEU A  60      14.541   1.427  12.201  1.00  0.00           H  
ATOM    971  HB3 LEU A  60      13.036   0.662  11.716  1.00  0.00           H  
ATOM    972  HG  LEU A  60      12.971   2.287   9.738  1.00  0.00           H  
ATOM    973 HD11 LEU A  60      14.496   3.983  10.609  1.00  0.00           H  
ATOM    974 HD12 LEU A  60      15.082   3.347   9.074  1.00  0.00           H  
ATOM    975 HD13 LEU A  60      15.830   2.827  10.585  1.00  0.00           H  
ATOM    976 HD21 LEU A  60      15.306   0.357   9.846  1.00  0.00           H  
ATOM    977 HD22 LEU A  60      14.536   0.987   8.388  1.00  0.00           H  
ATOM    978 HD23 LEU A  60      13.634  -0.064   9.477  1.00  0.00           H  
ATOM    979  N   LEU A  61      10.999   4.076  11.598  1.00  0.00           N  
ATOM    980  CA  LEU A  61       9.711   4.410  10.958  1.00  0.00           C  
ATOM    981  C   LEU A  61       9.838   4.216   9.431  1.00  0.00           C  
ATOM    982  O   LEU A  61      10.352   5.091   8.747  1.00  0.00           O  
ATOM    983  CB  LEU A  61       9.315   5.890  11.292  1.00  0.00           C  
ATOM    984  CG  LEU A  61       8.778   6.200  12.736  1.00  0.00           C  
ATOM    985  CD1 LEU A  61       9.742   5.748  13.847  1.00  0.00           C  
ATOM    986  CD2 LEU A  61       8.466   7.706  12.885  1.00  0.00           C  
ATOM    987  H   LEU A  61      11.595   4.809  11.850  1.00  0.00           H  
ATOM    988  HA  LEU A  61       8.948   3.741  11.342  1.00  0.00           H  
ATOM    989  HB2 LEU A  61      10.189   6.513  11.122  1.00  0.00           H  
ATOM    990  HB3 LEU A  61       8.550   6.199  10.583  1.00  0.00           H  
ATOM    991  HG  LEU A  61       7.847   5.662  12.882  1.00  0.00           H  
ATOM    992 HD11 LEU A  61       9.334   6.007  14.815  1.00  0.00           H  
ATOM    993 HD12 LEU A  61      10.702   6.233  13.721  1.00  0.00           H  
ATOM    994 HD13 LEU A  61       9.876   4.676  13.796  1.00  0.00           H  
ATOM    995 HD21 LEU A  61       8.087   7.905  13.878  1.00  0.00           H  
ATOM    996 HD22 LEU A  61       7.722   7.999  12.157  1.00  0.00           H  
ATOM    997 HD23 LEU A  61       9.368   8.289  12.726  1.00  0.00           H  
ATOM    998  N   HIS A  62       9.394   3.066   8.902  1.00  0.00           N  
ATOM    999  CA  HIS A  62       9.506   2.769   7.455  1.00  0.00           C  
ATOM   1000  C   HIS A  62       8.245   3.253   6.714  1.00  0.00           C  
ATOM   1001  O   HIS A  62       7.121   3.110   7.224  1.00  0.00           O  
ATOM   1002  CB  HIS A  62       9.771   1.246   7.205  1.00  0.00           C  
ATOM   1003  CG  HIS A  62       8.541   0.369   7.094  1.00  0.00           C  
ATOM   1004  ND1 HIS A  62       7.964   0.047   5.886  1.00  0.00           N  
ATOM   1005  CD2 HIS A  62       7.784  -0.242   8.031  1.00  0.00           C  
ATOM   1006  CE1 HIS A  62       6.919  -0.723   6.090  1.00  0.00           C  
ATOM   1007  NE2 HIS A  62       6.782  -0.915   7.382  1.00  0.00           N  
ATOM   1008  H   HIS A  62       8.979   2.409   9.491  1.00  0.00           H  
ATOM   1009  HA  HIS A  62      10.359   3.332   7.071  1.00  0.00           H  
ATOM   1010  HB2 HIS A  62      10.332   1.133   6.284  1.00  0.00           H  
ATOM   1011  HB3 HIS A  62      10.379   0.862   8.017  1.00  0.00           H  
ATOM   1012  HD1 HIS A  62       8.281   0.342   5.006  1.00  0.00           H  
ATOM   1013  HD2 HIS A  62       7.932  -0.198   9.101  1.00  0.00           H  
ATOM   1014  HE1 HIS A  62       6.283  -1.140   5.324  1.00  0.00           H  
ATOM   1015  HE2 HIS A  62       5.941  -1.191   7.803  1.00  0.00           H  
ATOM   1016  N   CYS A  63       8.438   3.811   5.508  1.00  0.00           N  
ATOM   1017  CA  CYS A  63       7.329   4.296   4.651  1.00  0.00           C  
ATOM   1018  C   CYS A  63       7.373   3.642   3.259  1.00  0.00           C  
ATOM   1019  O   CYS A  63       8.411   3.130   2.837  1.00  0.00           O  
ATOM   1020  CB  CYS A  63       7.363   5.825   4.519  1.00  0.00           C  
ATOM   1021  SG  CYS A  63       6.049   6.511   3.485  1.00  0.00           S  
ATOM   1022  H   CYS A  63       9.367   3.929   5.184  1.00  0.00           H  
ATOM   1023  HA  CYS A  63       6.385   4.014   5.123  1.00  0.00           H  
ATOM   1024  HB2 CYS A  63       7.268   6.272   5.501  1.00  0.00           H  
ATOM   1025  HB3 CYS A  63       8.310   6.129   4.089  1.00  0.00           H  
ATOM   1026  HG  CYS A  63       4.903   6.384   4.139  1.00  0.00           H  
ATOM   1027  N   ARG A  64       6.197   3.624   2.596  1.00  0.00           N  
ATOM   1028  CA  ARG A  64       6.014   3.129   1.212  1.00  0.00           C  
ATOM   1029  C   ARG A  64       6.933   3.842   0.198  1.00  0.00           C  
ATOM   1030  O   ARG A  64       7.351   3.237  -0.792  1.00  0.00           O  
ATOM   1031  CB  ARG A  64       4.524   3.287   0.817  1.00  0.00           C  
ATOM   1032  CG  ARG A  64       4.152   2.890  -0.631  1.00  0.00           C  
ATOM   1033  CD  ARG A  64       2.630   2.815  -0.814  1.00  0.00           C  
ATOM   1034  NE  ARG A  64       2.208   2.622  -2.208  1.00  0.00           N  
ATOM   1035  CZ  ARG A  64       0.938   2.384  -2.590  1.00  0.00           C  
ATOM   1036  NH1 ARG A  64      -0.022   2.178  -1.691  1.00  0.00           N  
ATOM   1037  NH2 ARG A  64       0.633   2.318  -3.875  1.00  0.00           N  
ATOM   1038  H   ARG A  64       5.409   3.971   3.064  1.00  0.00           H  
ATOM   1039  HA  ARG A  64       6.261   2.076   1.210  1.00  0.00           H  
ATOM   1040  HB2 ARG A  64       3.934   2.672   1.490  1.00  0.00           H  
ATOM   1041  HB3 ARG A  64       4.233   4.322   0.969  1.00  0.00           H  
ATOM   1042  HG2 ARG A  64       4.561   3.626  -1.315  1.00  0.00           H  
ATOM   1043  HG3 ARG A  64       4.584   1.919  -0.855  1.00  0.00           H  
ATOM   1044  HD2 ARG A  64       2.256   1.988  -0.223  1.00  0.00           H  
ATOM   1045  HD3 ARG A  64       2.190   3.735  -0.440  1.00  0.00           H  
ATOM   1046  HE  ARG A  64       2.901   2.705  -2.902  1.00  0.00           H  
ATOM   1047 HH11 ARG A  64       0.190   2.194  -0.704  1.00  0.00           H  
ATOM   1048 HH12 ARG A  64      -0.962   1.993  -1.989  1.00  0.00           H  
ATOM   1049 HH21 ARG A  64       1.346   2.437  -4.576  1.00  0.00           H  
ATOM   1050 HH22 ARG A  64      -0.314   2.149  -4.157  1.00  0.00           H  
ATOM   1051  N   ALA A  65       7.210   5.128   0.447  1.00  0.00           N  
ATOM   1052  CA  ALA A  65       8.161   5.916  -0.354  1.00  0.00           C  
ATOM   1053  C   ALA A  65       9.323   6.357   0.548  1.00  0.00           C  
ATOM   1054  O   ALA A  65      10.475   5.967   0.335  1.00  0.00           O  
ATOM   1055  CB  ALA A  65       7.456   7.126  -1.003  1.00  0.00           C  
ATOM   1056  H   ALA A  65       6.762   5.564   1.201  1.00  0.00           H  
ATOM   1057  HA  ALA A  65       8.560   5.288  -1.155  1.00  0.00           H  
ATOM   1058  HB1 ALA A  65       6.641   6.782  -1.628  1.00  0.00           H  
ATOM   1059  HB2 ALA A  65       8.161   7.680  -1.612  1.00  0.00           H  
ATOM   1060  HB3 ALA A  65       7.062   7.779  -0.238  1.00  0.00           H  
ATOM   1061  N   GLY A  66       8.993   7.150   1.581  1.00  0.00           N  
ATOM   1062  CA  GLY A  66       9.987   7.637   2.544  1.00  0.00           C  
ATOM   1063  C   GLY A  66       9.630   8.987   3.140  1.00  0.00           C  
ATOM   1064  O   GLY A  66      10.217   9.391   4.151  1.00  0.00           O  
ATOM   1065  H   GLY A  66       8.056   7.411   1.692  1.00  0.00           H  
ATOM   1066  HA2 GLY A  66      10.069   6.915   3.346  1.00  0.00           H  
ATOM   1067  HA3 GLY A  66      10.955   7.724   2.060  1.00  0.00           H  
ATOM   1068  N   ARG A  67       8.673   9.695   2.515  1.00  0.00           N  
ATOM   1069  CA  ARG A  67       8.268  11.034   2.961  1.00  0.00           C  
ATOM   1070  C   ARG A  67       7.508  10.974   4.300  1.00  0.00           C  
ATOM   1071  O   ARG A  67       7.764  11.793   5.172  1.00  0.00           O  
ATOM   1072  CB  ARG A  67       7.435  11.765   1.872  1.00  0.00           C  
ATOM   1073  CG  ARG A  67       6.957  13.181   2.279  1.00  0.00           C  
ATOM   1074  CD  ARG A  67       8.120  14.143   2.650  1.00  0.00           C  
ATOM   1075  NE  ARG A  67       7.735  15.084   3.717  1.00  0.00           N  
ATOM   1076  CZ  ARG A  67       8.512  16.054   4.215  1.00  0.00           C  
ATOM   1077  NH1 ARG A  67       9.686  16.352   3.666  1.00  0.00           N  
ATOM   1078  NH2 ARG A  67       8.095  16.748   5.258  1.00  0.00           N  
ATOM   1079  H   ARG A  67       8.238   9.310   1.727  1.00  0.00           H  
ATOM   1080  HA  ARG A  67       9.183  11.600   3.121  1.00  0.00           H  
ATOM   1081  HB2 ARG A  67       8.037  11.852   0.971  1.00  0.00           H  
ATOM   1082  HB3 ARG A  67       6.562  11.164   1.641  1.00  0.00           H  
ATOM   1083  HG2 ARG A  67       6.391  13.609   1.456  1.00  0.00           H  
ATOM   1084  HG3 ARG A  67       6.296  13.084   3.135  1.00  0.00           H  
ATOM   1085  HD2 ARG A  67       8.975  13.570   2.995  1.00  0.00           H  
ATOM   1086  HD3 ARG A  67       8.407  14.709   1.771  1.00  0.00           H  
ATOM   1087  HE  ARG A  67       6.849  14.943   4.125  1.00  0.00           H  
ATOM   1088 HH11 ARG A  67      10.014  15.839   2.868  1.00  0.00           H  
ATOM   1089 HH12 ARG A  67      10.249  17.087   4.051  1.00  0.00           H  
ATOM   1090 HH21 ARG A  67       7.203  16.535   5.676  1.00  0.00           H  
ATOM   1091 HH22 ARG A  67       8.660  17.479   5.642  1.00  0.00           H  
ATOM   1092  N   ARG A  68       6.596   9.994   4.461  1.00  0.00           N  
ATOM   1093  CA  ARG A  68       5.806   9.837   5.717  1.00  0.00           C  
ATOM   1094  C   ARG A  68       6.696   9.363   6.873  1.00  0.00           C  
ATOM   1095  O   ARG A  68       6.388   9.599   8.043  1.00  0.00           O  
ATOM   1096  CB  ARG A  68       4.625   8.854   5.525  1.00  0.00           C  
ATOM   1097  CG  ARG A  68       3.748   9.170   4.303  1.00  0.00           C  
ATOM   1098  CD  ARG A  68       3.169  10.601   4.327  1.00  0.00           C  
ATOM   1099  NE  ARG A  68       2.657  11.011   3.003  1.00  0.00           N  
ATOM   1100  CZ  ARG A  68       2.916  12.188   2.401  1.00  0.00           C  
ATOM   1101  NH1 ARG A  68       3.681  13.096   2.988  1.00  0.00           N  
ATOM   1102  NH2 ARG A  68       2.406  12.447   1.204  1.00  0.00           N  
ATOM   1103  H   ARG A  68       6.449   9.363   3.719  1.00  0.00           H  
ATOM   1104  HA  ARG A  68       5.406  10.819   5.976  1.00  0.00           H  
ATOM   1105  HB2 ARG A  68       5.016   7.844   5.414  1.00  0.00           H  
ATOM   1106  HB3 ARG A  68       4.000   8.885   6.413  1.00  0.00           H  
ATOM   1107  HG2 ARG A  68       4.350   9.051   3.414  1.00  0.00           H  
ATOM   1108  HG3 ARG A  68       2.932   8.459   4.270  1.00  0.00           H  
ATOM   1109  HD2 ARG A  68       2.355  10.638   5.042  1.00  0.00           H  
ATOM   1110  HD3 ARG A  68       3.943  11.298   4.642  1.00  0.00           H  
ATOM   1111  HE  ARG A  68       2.080  10.366   2.534  1.00  0.00           H  
ATOM   1112 HH11 ARG A  68       4.079  12.916   3.892  1.00  0.00           H  
ATOM   1113 HH12 ARG A  68       3.858  13.975   2.539  1.00  0.00           H  
ATOM   1114 HH21 ARG A  68       1.826  11.768   0.746  1.00  0.00           H  
ATOM   1115 HH22 ARG A  68       2.594  13.323   0.755  1.00  0.00           H  
ATOM   1116  N   ALA A  69       7.778   8.659   6.507  1.00  0.00           N  
ATOM   1117  CA  ALA A  69       8.841   8.259   7.441  1.00  0.00           C  
ATOM   1118  C   ALA A  69       9.480   9.510   8.059  1.00  0.00           C  
ATOM   1119  O   ALA A  69       9.583   9.630   9.283  1.00  0.00           O  
ATOM   1120  CB  ALA A  69       9.888   7.408   6.700  1.00  0.00           C  
ATOM   1121  H   ALA A  69       7.865   8.404   5.565  1.00  0.00           H  
ATOM   1122  HA  ALA A  69       8.396   7.652   8.226  1.00  0.00           H  
ATOM   1123  HB1 ALA A  69       9.406   6.554   6.243  1.00  0.00           H  
ATOM   1124  HB2 ALA A  69      10.638   7.060   7.395  1.00  0.00           H  
ATOM   1125  HB3 ALA A  69      10.366   7.998   5.928  1.00  0.00           H  
ATOM   1126  N   LEU A  70       9.853  10.450   7.174  1.00  0.00           N  
ATOM   1127  CA  LEU A  70      10.436  11.747   7.548  1.00  0.00           C  
ATOM   1128  C   LEU A  70       9.426  12.592   8.357  1.00  0.00           C  
ATOM   1129  O   LEU A  70       9.747  13.028   9.456  1.00  0.00           O  
ATOM   1130  CB  LEU A  70      10.914  12.485   6.261  1.00  0.00           C  
ATOM   1131  CG  LEU A  70      11.540  13.908   6.444  1.00  0.00           C  
ATOM   1132  CD1 LEU A  70      12.691  13.905   7.472  1.00  0.00           C  
ATOM   1133  CD2 LEU A  70      12.030  14.474   5.091  1.00  0.00           C  
ATOM   1134  H   LEU A  70       9.737  10.257   6.217  1.00  0.00           H  
ATOM   1135  HA  LEU A  70      11.303  11.544   8.172  1.00  0.00           H  
ATOM   1136  HB2 LEU A  70      11.654  11.855   5.774  1.00  0.00           H  
ATOM   1137  HB3 LEU A  70      10.063  12.574   5.590  1.00  0.00           H  
ATOM   1138  HG  LEU A  70      10.775  14.578   6.822  1.00  0.00           H  
ATOM   1139 HD11 LEU A  70      13.471  13.227   7.151  1.00  0.00           H  
ATOM   1140 HD12 LEU A  70      12.319  13.590   8.439  1.00  0.00           H  
ATOM   1141 HD13 LEU A  70      13.100  14.903   7.563  1.00  0.00           H  
ATOM   1142 HD21 LEU A  70      12.802  13.832   4.680  1.00  0.00           H  
ATOM   1143 HD22 LEU A  70      12.433  15.467   5.239  1.00  0.00           H  
ATOM   1144 HD23 LEU A  70      11.205  14.529   4.393  1.00  0.00           H  
ATOM   1145  N   ASP A  71       8.199  12.755   7.811  1.00  0.00           N  
ATOM   1146  CA  ASP A  71       7.095  13.561   8.405  1.00  0.00           C  
ATOM   1147  C   ASP A  71       6.854  13.207   9.880  1.00  0.00           C  
ATOM   1148  O   ASP A  71       6.915  14.077  10.772  1.00  0.00           O  
ATOM   1149  CB  ASP A  71       5.769  13.331   7.601  1.00  0.00           C  
ATOM   1150  CG  ASP A  71       5.660  14.157   6.311  1.00  0.00           C  
ATOM   1151  OD1 ASP A  71       5.796  15.396   6.379  1.00  0.00           O  
ATOM   1152  OD2 ASP A  71       5.408  13.586   5.230  1.00  0.00           O  
ATOM   1153  H   ASP A  71       8.019  12.304   6.974  1.00  0.00           H  
ATOM   1154  HA  ASP A  71       7.374  14.607   8.337  1.00  0.00           H  
ATOM   1155  HB2 ASP A  71       5.700  12.275   7.348  1.00  0.00           H  
ATOM   1156  HB3 ASP A  71       4.916  13.570   8.219  1.00  0.00           H  
ATOM   1157  N   ALA A  72       6.601  11.911  10.106  1.00  0.00           N  
ATOM   1158  CA  ALA A  72       6.282  11.363  11.428  1.00  0.00           C  
ATOM   1159  C   ALA A  72       7.477  11.510  12.390  1.00  0.00           C  
ATOM   1160  O   ALA A  72       7.305  11.915  13.550  1.00  0.00           O  
ATOM   1161  CB  ALA A  72       5.850   9.893  11.276  1.00  0.00           C  
ATOM   1162  H   ALA A  72       6.645  11.292   9.348  1.00  0.00           H  
ATOM   1163  HA  ALA A  72       5.438  11.919  11.829  1.00  0.00           H  
ATOM   1164  HB1 ALA A  72       5.019   9.830  10.583  1.00  0.00           H  
ATOM   1165  HB2 ALA A  72       5.543   9.499  12.235  1.00  0.00           H  
ATOM   1166  HB3 ALA A  72       6.672   9.301  10.898  1.00  0.00           H  
ATOM   1167  N   ALA A  73       8.694  11.233  11.875  1.00  0.00           N  
ATOM   1168  CA  ALA A  73       9.934  11.282  12.669  1.00  0.00           C  
ATOM   1169  C   ALA A  73      10.290  12.719  13.098  1.00  0.00           C  
ATOM   1170  O   ALA A  73      10.756  12.907  14.220  1.00  0.00           O  
ATOM   1171  CB  ALA A  73      11.095  10.627  11.907  1.00  0.00           C  
ATOM   1172  H   ALA A  73       8.759  10.996  10.923  1.00  0.00           H  
ATOM   1173  HA  ALA A  73       9.763  10.695  13.570  1.00  0.00           H  
ATOM   1174  HB1 ALA A  73      10.821   9.616  11.626  1.00  0.00           H  
ATOM   1175  HB2 ALA A  73      11.978  10.594  12.534  1.00  0.00           H  
ATOM   1176  HB3 ALA A  73      11.314  11.194  11.011  1.00  0.00           H  
ATOM   1177  N   LYS A  74      10.056  13.726  12.214  1.00  0.00           N  
ATOM   1178  CA  LYS A  74      10.340  15.148  12.536  1.00  0.00           C  
ATOM   1179  C   LYS A  74       9.475  15.568  13.713  1.00  0.00           C  
ATOM   1180  O   LYS A  74      10.003  16.021  14.721  1.00  0.00           O  
ATOM   1181  CB  LYS A  74      10.116  16.119  11.332  1.00  0.00           C  
ATOM   1182  CG  LYS A  74      10.949  15.800  10.067  1.00  0.00           C  
ATOM   1183  CD  LYS A  74      11.124  17.005   9.101  1.00  0.00           C  
ATOM   1184  CE  LYS A  74      12.262  17.955   9.531  1.00  0.00           C  
ATOM   1185  NZ  LYS A  74      12.378  19.141   8.639  1.00  0.00           N  
ATOM   1186  H   LYS A  74       9.660  13.507  11.351  1.00  0.00           H  
ATOM   1187  HA  LYS A  74      11.381  15.219  12.848  1.00  0.00           H  
ATOM   1188  HB2 LYS A  74       9.066  16.092  11.054  1.00  0.00           H  
ATOM   1189  HB3 LYS A  74      10.359  17.126  11.653  1.00  0.00           H  
ATOM   1190  HG2 LYS A  74      11.929  15.454  10.370  1.00  0.00           H  
ATOM   1191  HG3 LYS A  74      10.455  14.999   9.530  1.00  0.00           H  
ATOM   1192  HD2 LYS A  74      11.349  16.626   8.111  1.00  0.00           H  
ATOM   1193  HD3 LYS A  74      10.196  17.564   9.061  1.00  0.00           H  
ATOM   1194  HE2 LYS A  74      12.080  18.299  10.538  1.00  0.00           H  
ATOM   1195  HE3 LYS A  74      13.204  17.409   9.502  1.00  0.00           H  
ATOM   1196  HZ1 LYS A  74      12.575  18.842   7.662  1.00  0.00           H  
ATOM   1197  HZ2 LYS A  74      13.155  19.754   8.966  1.00  0.00           H  
ATOM   1198  HZ3 LYS A  74      11.494  19.689   8.650  1.00  0.00           H  
ATOM   1199  N   SER A  75       8.154  15.325  13.586  1.00  0.00           N  
ATOM   1200  CA  SER A  75       7.153  15.631  14.626  1.00  0.00           C  
ATOM   1201  C   SER A  75       7.567  15.057  16.003  1.00  0.00           C  
ATOM   1202  O   SER A  75       7.443  15.729  17.020  1.00  0.00           O  
ATOM   1203  CB  SER A  75       5.773  15.080  14.190  1.00  0.00           C  
ATOM   1204  OG  SER A  75       5.376  15.628  12.934  1.00  0.00           O  
ATOM   1205  H   SER A  75       7.837  14.922  12.749  1.00  0.00           H  
ATOM   1206  HA  SER A  75       7.088  16.711  14.706  1.00  0.00           H  
ATOM   1207  HB2 SER A  75       5.826  14.001  14.092  1.00  0.00           H  
ATOM   1208  HB3 SER A  75       5.023  15.339  14.927  1.00  0.00           H  
ATOM   1209  HG  SER A  75       5.018  14.925  12.372  1.00  0.00           H  
ATOM   1210  N   MET A  76       8.113  13.831  15.999  1.00  0.00           N  
ATOM   1211  CA  MET A  76       8.565  13.144  17.228  1.00  0.00           C  
ATOM   1212  C   MET A  76       9.852  13.759  17.802  1.00  0.00           C  
ATOM   1213  O   MET A  76       9.986  13.891  19.019  1.00  0.00           O  
ATOM   1214  CB  MET A  76       8.761  11.649  16.946  1.00  0.00           C  
ATOM   1215  CG  MET A  76       7.468  10.934  16.586  1.00  0.00           C  
ATOM   1216  SD  MET A  76       6.234  11.081  17.902  1.00  0.00           S  
ATOM   1217  CE  MET A  76       4.845  11.807  17.042  1.00  0.00           C  
ATOM   1218  H   MET A  76       8.216  13.368  15.138  1.00  0.00           H  
ATOM   1219  HA  MET A  76       7.774  13.252  17.971  1.00  0.00           H  
ATOM   1220  HB2 MET A  76       9.461  11.528  16.125  1.00  0.00           H  
ATOM   1221  HB3 MET A  76       9.171  11.171  17.830  1.00  0.00           H  
ATOM   1222  HG2 MET A  76       7.070  11.351  15.668  1.00  0.00           H  
ATOM   1223  HG3 MET A  76       7.680   9.882  16.430  1.00  0.00           H  
ATOM   1224  HE1 MET A  76       5.137  12.750  16.600  1.00  0.00           H  
ATOM   1225  HE2 MET A  76       4.040  11.973  17.742  1.00  0.00           H  
ATOM   1226  HE3 MET A  76       4.510  11.133  16.266  1.00  0.00           H  
ATOM   1227  N   HIS A  77      10.794  14.120  16.919  1.00  0.00           N  
ATOM   1228  CA  HIS A  77      12.019  14.852  17.307  1.00  0.00           C  
ATOM   1229  C   HIS A  77      11.668  16.222  17.940  1.00  0.00           C  
ATOM   1230  O   HIS A  77      12.384  16.706  18.822  1.00  0.00           O  
ATOM   1231  CB  HIS A  77      12.969  15.015  16.088  1.00  0.00           C  
ATOM   1232  CG  HIS A  77      13.853  13.820  15.789  1.00  0.00           C  
ATOM   1233  ND1 HIS A  77      15.218  13.845  15.965  1.00  0.00           N  
ATOM   1234  CD2 HIS A  77      13.580  12.589  15.287  1.00  0.00           C  
ATOM   1235  CE1 HIS A  77      15.739  12.701  15.592  1.00  0.00           C  
ATOM   1236  NE2 HIS A  77      14.768  11.919  15.176  1.00  0.00           N  
ATOM   1237  H   HIS A  77      10.665  13.893  15.978  1.00  0.00           H  
ATOM   1238  HA  HIS A  77      12.522  14.254  18.060  1.00  0.00           H  
ATOM   1239  HB2 HIS A  77      12.375  15.198  15.208  1.00  0.00           H  
ATOM   1240  HB3 HIS A  77      13.617  15.869  16.247  1.00  0.00           H  
ATOM   1241  HD1 HIS A  77      15.725  14.598  16.321  1.00  0.00           H  
ATOM   1242  HD2 HIS A  77      12.604  12.196  15.040  1.00  0.00           H  
ATOM   1243  HE1 HIS A  77      16.788  12.448  15.615  1.00  0.00           H  
ATOM   1244  HE2 HIS A  77      14.863  10.966  14.972  1.00  0.00           H  
ATOM   1245  N   GLU A  78      10.537  16.812  17.494  1.00  0.00           N  
ATOM   1246  CA  GLU A  78      10.001  18.082  18.036  1.00  0.00           C  
ATOM   1247  C   GLU A  78       9.326  17.859  19.410  1.00  0.00           C  
ATOM   1248  O   GLU A  78       9.189  18.796  20.198  1.00  0.00           O  
ATOM   1249  CB  GLU A  78       8.995  18.712  17.032  1.00  0.00           C  
ATOM   1250  CG  GLU A  78       9.569  18.924  15.620  1.00  0.00           C  
ATOM   1251  CD  GLU A  78       8.581  19.574  14.639  1.00  0.00           C  
ATOM   1252  OE1 GLU A  78       8.306  20.788  14.775  1.00  0.00           O  
ATOM   1253  OE2 GLU A  78       8.081  18.883  13.717  1.00  0.00           O  
ATOM   1254  H   GLU A  78      10.043  16.374  16.773  1.00  0.00           H  
ATOM   1255  HA  GLU A  78      10.839  18.765  18.168  1.00  0.00           H  
ATOM   1256  HB2 GLU A  78       8.130  18.064  16.952  1.00  0.00           H  
ATOM   1257  HB3 GLU A  78       8.673  19.676  17.416  1.00  0.00           H  
ATOM   1258  HG2 GLU A  78      10.458  19.535  15.684  1.00  0.00           H  
ATOM   1259  HG3 GLU A  78       9.860  17.959  15.230  1.00  0.00           H  
ATOM   1260  N   LEU A  79       8.899  16.605  19.681  1.00  0.00           N  
ATOM   1261  CA  LEU A  79       8.322  16.206  20.996  1.00  0.00           C  
ATOM   1262  C   LEU A  79       9.421  15.696  21.958  1.00  0.00           C  
ATOM   1263  O   LEU A  79       9.110  15.140  23.016  1.00  0.00           O  
ATOM   1264  CB  LEU A  79       7.223  15.118  20.824  1.00  0.00           C  
ATOM   1265  CG  LEU A  79       6.074  15.444  19.827  1.00  0.00           C  
ATOM   1266  CD1 LEU A  79       5.005  14.329  19.801  1.00  0.00           C  
ATOM   1267  CD2 LEU A  79       5.432  16.830  20.095  1.00  0.00           C  
ATOM   1268  H   LEU A  79       8.967  15.933  18.973  1.00  0.00           H  
ATOM   1269  HA  LEU A  79       7.871  17.085  21.447  1.00  0.00           H  
ATOM   1270  HB2 LEU A  79       7.706  14.199  20.498  1.00  0.00           H  
ATOM   1271  HB3 LEU A  79       6.781  14.931  21.800  1.00  0.00           H  
ATOM   1272  HG  LEU A  79       6.511  15.477  18.840  1.00  0.00           H  
ATOM   1273 HD11 LEU A  79       4.235  14.581  19.083  1.00  0.00           H  
ATOM   1274 HD12 LEU A  79       4.557  14.218  20.780  1.00  0.00           H  
ATOM   1275 HD13 LEU A  79       5.463  13.391  19.509  1.00  0.00           H  
ATOM   1276 HD21 LEU A  79       5.027  16.863  21.099  1.00  0.00           H  
ATOM   1277 HD22 LEU A  79       4.636  17.005  19.381  1.00  0.00           H  
ATOM   1278 HD23 LEU A  79       6.178  17.604  19.985  1.00  0.00           H  
ATOM   1279  N   GLY A  80      10.702  15.870  21.568  1.00  0.00           N  
ATOM   1280  CA  GLY A  80      11.845  15.543  22.426  1.00  0.00           C  
ATOM   1281  C   GLY A  80      12.330  14.102  22.296  1.00  0.00           C  
ATOM   1282  O   GLY A  80      13.195  13.678  23.071  1.00  0.00           O  
ATOM   1283  H   GLY A  80      10.871  16.223  20.675  1.00  0.00           H  
ATOM   1284  HA2 GLY A  80      12.657  16.201  22.157  1.00  0.00           H  
ATOM   1285  HA3 GLY A  80      11.587  15.732  23.464  1.00  0.00           H  
ATOM   1286  N   TYR A  81      11.764  13.337  21.339  1.00  0.00           N  
ATOM   1287  CA  TYR A  81      12.232  11.961  21.021  1.00  0.00           C  
ATOM   1288  C   TYR A  81      13.334  12.011  19.948  1.00  0.00           C  
ATOM   1289  O   TYR A  81      13.619  13.076  19.396  1.00  0.00           O  
ATOM   1290  CB  TYR A  81      11.056  11.089  20.520  1.00  0.00           C  
ATOM   1291  CG  TYR A  81       9.869  11.030  21.483  1.00  0.00           C  
ATOM   1292  CD1 TYR A  81       9.945  10.309  22.676  1.00  0.00           C  
ATOM   1293  CD2 TYR A  81       8.678  11.695  21.201  1.00  0.00           C  
ATOM   1294  CE1 TYR A  81       8.870  10.257  23.542  1.00  0.00           C  
ATOM   1295  CE2 TYR A  81       7.611  11.642  22.064  1.00  0.00           C  
ATOM   1296  CZ  TYR A  81       7.709  10.924  23.231  1.00  0.00           C  
ATOM   1297  OH  TYR A  81       6.640  10.877  24.091  1.00  0.00           O  
ATOM   1298  H   TYR A  81      11.005  13.707  20.828  1.00  0.00           H  
ATOM   1299  HA  TYR A  81      12.645  11.514  21.923  1.00  0.00           H  
ATOM   1300  HB2 TYR A  81      10.703  11.476  19.568  1.00  0.00           H  
ATOM   1301  HB3 TYR A  81      11.409  10.071  20.365  1.00  0.00           H  
ATOM   1302  HD1 TYR A  81      10.860   9.782  22.924  1.00  0.00           H  
ATOM   1303  HD2 TYR A  81       8.600  12.264  20.280  1.00  0.00           H  
ATOM   1304  HE1 TYR A  81       8.945   9.694  24.461  1.00  0.00           H  
ATOM   1305  HE2 TYR A  81       6.694  12.165  21.822  1.00  0.00           H  
ATOM   1306  HH  TYR A  81       6.952  10.977  24.993  1.00  0.00           H  
ATOM   1307  N   THR A  82      13.947  10.848  19.647  1.00  0.00           N  
ATOM   1308  CA  THR A  82      14.945  10.708  18.565  1.00  0.00           C  
ATOM   1309  C   THR A  82      14.795   9.334  17.832  1.00  0.00           C  
ATOM   1310  O   THR A  82      15.707   8.498  17.889  1.00  0.00           O  
ATOM   1311  CB  THR A  82      16.419  10.881  19.117  1.00  0.00           C  
ATOM   1312  OG1 THR A  82      16.583  10.108  20.323  1.00  0.00           O  
ATOM   1313  CG2 THR A  82      16.806  12.350  19.389  1.00  0.00           C  
ATOM   1314  H   THR A  82      13.728  10.054  20.176  1.00  0.00           H  
ATOM   1315  HA  THR A  82      14.757  11.498  17.830  1.00  0.00           H  
ATOM   1316  HB  THR A  82      17.111  10.489  18.373  1.00  0.00           H  
ATOM   1317  HG1 THR A  82      17.327   9.505  20.213  1.00  0.00           H  
ATOM   1318 HG21 THR A  82      17.822  12.400  19.759  1.00  0.00           H  
ATOM   1319 HG22 THR A  82      16.138  12.771  20.129  1.00  0.00           H  
ATOM   1320 HG23 THR A  82      16.731  12.925  18.475  1.00  0.00           H  
ATOM   1321  N   PRO A  83      13.629   9.053  17.147  1.00  0.00           N  
ATOM   1322  CA  PRO A  83      13.489   7.842  16.297  1.00  0.00           C  
ATOM   1323  C   PRO A  83      14.176   7.998  14.914  1.00  0.00           C  
ATOM   1324  O   PRO A  83      14.339   9.116  14.405  1.00  0.00           O  
ATOM   1325  CB  PRO A  83      11.956   7.709  16.140  1.00  0.00           C  
ATOM   1326  CG  PRO A  83      11.464   9.122  16.180  1.00  0.00           C  
ATOM   1327  CD  PRO A  83      12.348   9.824  17.190  1.00  0.00           C  
ATOM   1328  HA  PRO A  83      13.884   6.960  16.799  1.00  0.00           H  
ATOM   1329  HB2 PRO A  83      11.709   7.221  15.203  1.00  0.00           H  
ATOM   1330  HB3 PRO A  83      11.551   7.126  16.964  1.00  0.00           H  
ATOM   1331  HG2 PRO A  83      11.565   9.581  15.198  1.00  0.00           H  
ATOM   1332  HG3 PRO A  83      10.430   9.146  16.497  1.00  0.00           H  
ATOM   1333  HD2 PRO A  83      12.508  10.859  16.910  1.00  0.00           H  
ATOM   1334  HD3 PRO A  83      11.908   9.775  18.181  1.00  0.00           H  
ATOM   1335  N   TYR A  84      14.565   6.856  14.331  1.00  0.00           N  
ATOM   1336  CA  TYR A  84      15.104   6.769  12.957  1.00  0.00           C  
ATOM   1337  C   TYR A  84      13.941   6.576  11.974  1.00  0.00           C  
ATOM   1338  O   TYR A  84      12.794   6.374  12.401  1.00  0.00           O  
ATOM   1339  CB  TYR A  84      16.107   5.588  12.849  1.00  0.00           C  
ATOM   1340  CG  TYR A  84      17.300   5.706  13.811  1.00  0.00           C  
ATOM   1341  CD1 TYR A  84      18.444   6.423  13.456  1.00  0.00           C  
ATOM   1342  CD2 TYR A  84      17.264   5.136  15.091  1.00  0.00           C  
ATOM   1343  CE1 TYR A  84      19.505   6.561  14.328  1.00  0.00           C  
ATOM   1344  CE2 TYR A  84      18.326   5.281  15.969  1.00  0.00           C  
ATOM   1345  CZ  TYR A  84      19.442   5.994  15.581  1.00  0.00           C  
ATOM   1346  OH  TYR A  84      20.500   6.146  16.452  1.00  0.00           O  
ATOM   1347  H   TYR A  84      14.461   6.026  14.834  1.00  0.00           H  
ATOM   1348  HA  TYR A  84      15.613   7.699  12.721  1.00  0.00           H  
ATOM   1349  HB2 TYR A  84      15.588   4.656  13.066  1.00  0.00           H  
ATOM   1350  HB3 TYR A  84      16.493   5.537  11.835  1.00  0.00           H  
ATOM   1351  HD1 TYR A  84      18.499   6.873  12.472  1.00  0.00           H  
ATOM   1352  HD2 TYR A  84      16.388   4.567  15.392  1.00  0.00           H  
ATOM   1353  HE1 TYR A  84      20.381   7.121  14.028  1.00  0.00           H  
ATOM   1354  HE2 TYR A  84      18.279   4.829  16.952  1.00  0.00           H  
ATOM   1355  HH  TYR A  84      20.709   5.296  16.852  1.00  0.00           H  
ATOM   1356  N   TYR A  85      14.234   6.629  10.667  1.00  0.00           N  
ATOM   1357  CA  TYR A  85      13.207   6.478   9.630  1.00  0.00           C  
ATOM   1358  C   TYR A  85      13.822   5.936   8.329  1.00  0.00           C  
ATOM   1359  O   TYR A  85      14.954   6.279   7.973  1.00  0.00           O  
ATOM   1360  CB  TYR A  85      12.457   7.813   9.404  1.00  0.00           C  
ATOM   1361  CG  TYR A  85      13.317   8.990   8.911  1.00  0.00           C  
ATOM   1362  CD1 TYR A  85      14.107   9.721   9.797  1.00  0.00           C  
ATOM   1363  CD2 TYR A  85      13.326   9.373   7.566  1.00  0.00           C  
ATOM   1364  CE1 TYR A  85      14.863  10.781   9.366  1.00  0.00           C  
ATOM   1365  CE2 TYR A  85      14.086  10.442   7.134  1.00  0.00           C  
ATOM   1366  CZ  TYR A  85      14.852  11.141   8.039  1.00  0.00           C  
ATOM   1367  OH  TYR A  85      15.614  12.213   7.617  1.00  0.00           O  
ATOM   1368  H   TYR A  85      15.171   6.773  10.389  1.00  0.00           H  
ATOM   1369  HA  TYR A  85      12.487   5.739   9.990  1.00  0.00           H  
ATOM   1370  HB2 TYR A  85      11.662   7.654   8.688  1.00  0.00           H  
ATOM   1371  HB3 TYR A  85      12.000   8.113  10.343  1.00  0.00           H  
ATOM   1372  HD1 TYR A  85      14.123   9.440  10.845  1.00  0.00           H  
ATOM   1373  HD2 TYR A  85      12.722   8.823   6.855  1.00  0.00           H  
ATOM   1374  HE1 TYR A  85      15.464  11.333  10.074  1.00  0.00           H  
ATOM   1375  HE2 TYR A  85      14.077  10.724   6.088  1.00  0.00           H  
ATOM   1376  HH  TYR A  85      16.513  12.112   7.948  1.00  0.00           H  
ATOM   1377  N   LEU A  86      13.058   5.065   7.653  1.00  0.00           N  
ATOM   1378  CA  LEU A  86      13.477   4.363   6.439  1.00  0.00           C  
ATOM   1379  C   LEU A  86      12.808   4.995   5.217  1.00  0.00           C  
ATOM   1380  O   LEU A  86      11.559   4.992   5.086  1.00  0.00           O  
ATOM   1381  CB  LEU A  86      13.126   2.846   6.562  1.00  0.00           C  
ATOM   1382  CG  LEU A  86      13.604   1.855   5.429  1.00  0.00           C  
ATOM   1383  CD1 LEU A  86      12.714   1.875   4.165  1.00  0.00           C  
ATOM   1384  CD2 LEU A  86      15.081   2.082   5.073  1.00  0.00           C  
ATOM   1385  H   LEU A  86      12.159   4.892   7.985  1.00  0.00           H  
ATOM   1386  HA  LEU A  86      14.559   4.458   6.346  1.00  0.00           H  
ATOM   1387  HB2 LEU A  86      13.551   2.494   7.494  1.00  0.00           H  
ATOM   1388  HB3 LEU A  86      12.048   2.763   6.649  1.00  0.00           H  
ATOM   1389  HG  LEU A  86      13.537   0.852   5.824  1.00  0.00           H  
ATOM   1390 HD11 LEU A  86      11.695   1.638   4.438  1.00  0.00           H  
ATOM   1391 HD12 LEU A  86      13.069   1.135   3.456  1.00  0.00           H  
ATOM   1392 HD13 LEU A  86      12.747   2.853   3.706  1.00  0.00           H  
ATOM   1393 HD21 LEU A  86      15.398   1.344   4.350  1.00  0.00           H  
ATOM   1394 HD22 LEU A  86      15.689   1.987   5.964  1.00  0.00           H  
ATOM   1395 HD23 LEU A  86      15.213   3.072   4.654  1.00  0.00           H  
ATOM   1396  N   GLU A  87      13.663   5.515   4.330  1.00  0.00           N  
ATOM   1397  CA  GLU A  87      13.280   5.979   3.004  1.00  0.00           C  
ATOM   1398  C   GLU A  87      13.633   4.883   1.981  1.00  0.00           C  
ATOM   1399  O   GLU A  87      14.815   4.640   1.692  1.00  0.00           O  
ATOM   1400  CB  GLU A  87      13.988   7.320   2.692  1.00  0.00           C  
ATOM   1401  CG  GLU A  87      13.641   8.444   3.687  1.00  0.00           C  
ATOM   1402  CD  GLU A  87      14.326   9.775   3.357  1.00  0.00           C  
ATOM   1403  OE1 GLU A  87      13.793  10.541   2.529  1.00  0.00           O  
ATOM   1404  OE2 GLU A  87      15.412  10.039   3.906  1.00  0.00           O  
ATOM   1405  H   GLU A  87      14.609   5.587   4.590  1.00  0.00           H  
ATOM   1406  HA  GLU A  87      12.198   6.145   2.989  1.00  0.00           H  
ATOM   1407  HB2 GLU A  87      15.064   7.164   2.711  1.00  0.00           H  
ATOM   1408  HB3 GLU A  87      13.703   7.646   1.696  1.00  0.00           H  
ATOM   1409  HG2 GLU A  87      12.566   8.591   3.686  1.00  0.00           H  
ATOM   1410  HG3 GLU A  87      13.943   8.129   4.683  1.00  0.00           H  
ATOM   1411  N   GLY A  88      12.590   4.214   1.477  1.00  0.00           N  
ATOM   1412  CA  GLY A  88      12.727   3.108   0.532  1.00  0.00           C  
ATOM   1413  C   GLY A  88      11.370   2.487   0.233  1.00  0.00           C  
ATOM   1414  O   GLY A  88      10.518   2.419   1.132  1.00  0.00           O  
ATOM   1415  H   GLY A  88      11.686   4.482   1.753  1.00  0.00           H  
ATOM   1416  HA2 GLY A  88      13.165   3.472  -0.387  1.00  0.00           H  
ATOM   1417  HA3 GLY A  88      13.379   2.351   0.955  1.00  0.00           H  
ATOM   1418  N   ASN A  89      11.168   2.028  -1.021  1.00  0.00           N  
ATOM   1419  CA  ASN A  89       9.885   1.441  -1.470  1.00  0.00           C  
ATOM   1420  C   ASN A  89       9.541   0.170  -0.670  1.00  0.00           C  
ATOM   1421  O   ASN A  89      10.353  -0.753  -0.593  1.00  0.00           O  
ATOM   1422  CB  ASN A  89       9.899   1.131  -2.994  1.00  0.00           C  
ATOM   1423  CG  ASN A  89       9.766   2.374  -3.878  1.00  0.00           C  
ATOM   1424  OD1 ASN A  89      10.172   3.473  -3.509  1.00  0.00           O  
ATOM   1425  ND2 ASN A  89       9.196   2.206  -5.062  1.00  0.00           N  
ATOM   1426  H   ASN A  89      11.911   2.067  -1.659  1.00  0.00           H  
ATOM   1427  HA  ASN A  89       9.118   2.184  -1.276  1.00  0.00           H  
ATOM   1428  HB2 ASN A  89      10.831   0.635  -3.246  1.00  0.00           H  
ATOM   1429  HB3 ASN A  89       9.080   0.461  -3.234  1.00  0.00           H  
ATOM   1430 HD21 ASN A  89       8.898   1.305  -5.306  1.00  0.00           H  
ATOM   1431 HD22 ASN A  89       9.096   2.985  -5.645  1.00  0.00           H  
ATOM   1432  N   VAL A  90       8.319   0.152  -0.088  1.00  0.00           N  
ATOM   1433  CA  VAL A  90       7.838  -0.944   0.782  1.00  0.00           C  
ATOM   1434  C   VAL A  90       7.795  -2.297   0.035  1.00  0.00           C  
ATOM   1435  O   VAL A  90       8.039  -3.346   0.619  1.00  0.00           O  
ATOM   1436  CB  VAL A  90       6.433  -0.590   1.421  1.00  0.00           C  
ATOM   1437  CG1 VAL A  90       5.323  -0.482   0.354  1.00  0.00           C  
ATOM   1438  CG2 VAL A  90       6.037  -1.576   2.547  1.00  0.00           C  
ATOM   1439  H   VAL A  90       7.727   0.920  -0.244  1.00  0.00           H  
ATOM   1440  HA  VAL A  90       8.551  -1.035   1.594  1.00  0.00           H  
ATOM   1441  HB  VAL A  90       6.530   0.396   1.876  1.00  0.00           H  
ATOM   1442 HG11 VAL A  90       4.380  -0.224   0.822  1.00  0.00           H  
ATOM   1443 HG12 VAL A  90       5.217  -1.426  -0.163  1.00  0.00           H  
ATOM   1444 HG13 VAL A  90       5.584   0.285  -0.364  1.00  0.00           H  
ATOM   1445 HG21 VAL A  90       5.075  -1.297   2.960  1.00  0.00           H  
ATOM   1446 HG22 VAL A  90       6.782  -1.550   3.332  1.00  0.00           H  
ATOM   1447 HG23 VAL A  90       5.977  -2.580   2.148  1.00  0.00           H  
ATOM   1448  N   TYR A  91       7.543  -2.235  -1.281  1.00  0.00           N  
ATOM   1449  CA  TYR A  91       7.446  -3.420  -2.154  1.00  0.00           C  
ATOM   1450  C   TYR A  91       8.843  -4.023  -2.439  1.00  0.00           C  
ATOM   1451  O   TYR A  91       8.976  -5.226  -2.704  1.00  0.00           O  
ATOM   1452  CB  TYR A  91       6.742  -3.021  -3.479  1.00  0.00           C  
ATOM   1453  CG  TYR A  91       5.346  -2.395  -3.290  1.00  0.00           C  
ATOM   1454  CD1 TYR A  91       4.211  -3.195  -3.136  1.00  0.00           C  
ATOM   1455  CD2 TYR A  91       5.168  -1.006  -3.238  1.00  0.00           C  
ATOM   1456  CE1 TYR A  91       2.957  -2.640  -2.951  1.00  0.00           C  
ATOM   1457  CE2 TYR A  91       3.914  -0.452  -3.050  1.00  0.00           C  
ATOM   1458  CZ  TYR A  91       2.814  -1.275  -2.905  1.00  0.00           C  
ATOM   1459  OH  TYR A  91       1.565  -0.726  -2.716  1.00  0.00           O  
ATOM   1460  H   TYR A  91       7.423  -1.352  -1.687  1.00  0.00           H  
ATOM   1461  HA  TYR A  91       6.838  -4.166  -1.644  1.00  0.00           H  
ATOM   1462  HB2 TYR A  91       7.362  -2.302  -4.005  1.00  0.00           H  
ATOM   1463  HB3 TYR A  91       6.632  -3.901  -4.104  1.00  0.00           H  
ATOM   1464  HD1 TYR A  91       4.317  -4.272  -3.156  1.00  0.00           H  
ATOM   1465  HD2 TYR A  91       6.029  -0.359  -3.351  1.00  0.00           H  
ATOM   1466  HE1 TYR A  91       2.092  -3.283  -2.839  1.00  0.00           H  
ATOM   1467  HE2 TYR A  91       3.800   0.625  -3.014  1.00  0.00           H  
ATOM   1468  HH  TYR A  91       1.096  -1.231  -2.036  1.00  0.00           H  
ATOM   1469  N   ASP A  92       9.878  -3.170  -2.358  1.00  0.00           N  
ATOM   1470  CA  ASP A  92      11.275  -3.536  -2.691  1.00  0.00           C  
ATOM   1471  C   ASP A  92      11.989  -4.276  -1.542  1.00  0.00           C  
ATOM   1472  O   ASP A  92      13.067  -4.821  -1.754  1.00  0.00           O  
ATOM   1473  CB  ASP A  92      12.095  -2.270  -3.100  1.00  0.00           C  
ATOM   1474  CG  ASP A  92      11.928  -1.860  -4.572  1.00  0.00           C  
ATOM   1475  OD1 ASP A  92      10.819  -1.434  -4.960  1.00  0.00           O  
ATOM   1476  OD2 ASP A  92      12.910  -1.956  -5.353  1.00  0.00           O  
ATOM   1477  H   ASP A  92       9.701  -2.257  -2.052  1.00  0.00           H  
ATOM   1478  HA  ASP A  92      11.240  -4.211  -3.540  1.00  0.00           H  
ATOM   1479  HB2 ASP A  92      11.775  -1.439  -2.484  1.00  0.00           H  
ATOM   1480  HB3 ASP A  92      13.154  -2.440  -2.907  1.00  0.00           H  
ATOM   1481  N   PHE A  93      11.399  -4.306  -0.337  1.00  0.00           N  
ATOM   1482  CA  PHE A  93      12.033  -4.951   0.842  1.00  0.00           C  
ATOM   1483  C   PHE A  93      12.344  -6.445   0.574  1.00  0.00           C  
ATOM   1484  O   PHE A  93      13.439  -6.930   0.896  1.00  0.00           O  
ATOM   1485  CB  PHE A  93      11.138  -4.808   2.102  1.00  0.00           C  
ATOM   1486  CG  PHE A  93      10.831  -3.373   2.551  1.00  0.00           C  
ATOM   1487  CD1 PHE A  93      11.524  -2.275   2.045  1.00  0.00           C  
ATOM   1488  CD2 PHE A  93       9.852  -3.131   3.504  1.00  0.00           C  
ATOM   1489  CE1 PHE A  93      11.252  -0.992   2.477  1.00  0.00           C  
ATOM   1490  CE2 PHE A  93       9.579  -1.851   3.932  1.00  0.00           C  
ATOM   1491  CZ  PHE A  93      10.276  -0.781   3.423  1.00  0.00           C  
ATOM   1492  H   PHE A  93      10.525  -3.880  -0.229  1.00  0.00           H  
ATOM   1493  HA  PHE A  93      12.970  -4.433   1.026  1.00  0.00           H  
ATOM   1494  HB2 PHE A  93      10.195  -5.297   1.910  1.00  0.00           H  
ATOM   1495  HB3 PHE A  93      11.623  -5.309   2.936  1.00  0.00           H  
ATOM   1496  HD1 PHE A  93      12.292  -2.430   1.298  1.00  0.00           H  
ATOM   1497  HD2 PHE A  93       9.292  -3.965   3.916  1.00  0.00           H  
ATOM   1498  HE1 PHE A  93      11.806  -0.152   2.069  1.00  0.00           H  
ATOM   1499  HE2 PHE A  93       8.814  -1.687   4.676  1.00  0.00           H  
ATOM   1500  HZ  PHE A  93      10.060   0.225   3.765  1.00  0.00           H  
ATOM   1501  N   GLU A  94      11.384  -7.138  -0.066  1.00  0.00           N  
ATOM   1502  CA  GLU A  94      11.482  -8.581  -0.365  1.00  0.00           C  
ATOM   1503  C   GLU A  94      12.668  -8.909  -1.301  1.00  0.00           C  
ATOM   1504  O   GLU A  94      13.404  -9.873  -1.056  1.00  0.00           O  
ATOM   1505  CB  GLU A  94      10.153  -9.099  -0.967  1.00  0.00           C  
ATOM   1506  CG  GLU A  94       8.960  -9.076   0.005  1.00  0.00           C  
ATOM   1507  CD  GLU A  94       7.719  -9.804  -0.538  1.00  0.00           C  
ATOM   1508  OE1 GLU A  94       7.252  -9.461  -1.650  1.00  0.00           O  
ATOM   1509  OE2 GLU A  94       7.196 -10.717   0.143  1.00  0.00           O  
ATOM   1510  H   GLU A  94      10.576  -6.659  -0.345  1.00  0.00           H  
ATOM   1511  HA  GLU A  94      11.648  -9.090   0.581  1.00  0.00           H  
ATOM   1512  HB2 GLU A  94       9.894  -8.477  -1.818  1.00  0.00           H  
ATOM   1513  HB3 GLU A  94      10.291 -10.118  -1.310  1.00  0.00           H  
ATOM   1514  HG2 GLU A  94       9.266  -9.538   0.941  1.00  0.00           H  
ATOM   1515  HG3 GLU A  94       8.691  -8.043   0.204  1.00  0.00           H  
ATOM   1516  N   LYS A  95      12.861  -8.090  -2.357  1.00  0.00           N  
ATOM   1517  CA  LYS A  95      13.966  -8.289  -3.326  1.00  0.00           C  
ATOM   1518  C   LYS A  95      15.325  -7.845  -2.728  1.00  0.00           C  
ATOM   1519  O   LYS A  95      16.377  -8.320  -3.155  1.00  0.00           O  
ATOM   1520  CB  LYS A  95      13.666  -7.579  -4.684  1.00  0.00           C  
ATOM   1521  CG  LYS A  95      13.334  -6.082  -4.574  1.00  0.00           C  
ATOM   1522  CD  LYS A  95      13.003  -5.385  -5.922  1.00  0.00           C  
ATOM   1523  CE  LYS A  95      14.237  -5.080  -6.800  1.00  0.00           C  
ATOM   1524  NZ  LYS A  95      14.838  -6.292  -7.416  1.00  0.00           N  
ATOM   1525  H   LYS A  95      12.254  -7.330  -2.481  1.00  0.00           H  
ATOM   1526  HA  LYS A  95      14.032  -9.359  -3.515  1.00  0.00           H  
ATOM   1527  HB2 LYS A  95      14.529  -7.687  -5.336  1.00  0.00           H  
ATOM   1528  HB3 LYS A  95      12.823  -8.077  -5.155  1.00  0.00           H  
ATOM   1529  HG2 LYS A  95      12.476  -5.980  -3.918  1.00  0.00           H  
ATOM   1530  HG3 LYS A  95      14.178  -5.577  -4.113  1.00  0.00           H  
ATOM   1531  HD2 LYS A  95      12.329  -6.016  -6.489  1.00  0.00           H  
ATOM   1532  HD3 LYS A  95      12.497  -4.448  -5.705  1.00  0.00           H  
ATOM   1533  HE2 LYS A  95      13.938  -4.410  -7.596  1.00  0.00           H  
ATOM   1534  HE3 LYS A  95      14.985  -4.586  -6.191  1.00  0.00           H  
ATOM   1535  HZ1 LYS A  95      15.630  -6.024  -8.033  1.00  0.00           H  
ATOM   1536  HZ2 LYS A  95      14.125  -6.793  -7.986  1.00  0.00           H  
ATOM   1537  HZ3 LYS A  95      15.194  -6.935  -6.680  1.00  0.00           H  
ATOM   1538  N   TYR A  96      15.295  -6.953  -1.716  1.00  0.00           N  
ATOM   1539  CA  TYR A  96      16.507  -6.580  -0.940  1.00  0.00           C  
ATOM   1540  C   TYR A  96      16.808  -7.641   0.154  1.00  0.00           C  
ATOM   1541  O   TYR A  96      17.831  -7.562   0.833  1.00  0.00           O  
ATOM   1542  CB  TYR A  96      16.369  -5.146  -0.345  1.00  0.00           C  
ATOM   1543  CG  TYR A  96      16.575  -3.999  -1.373  1.00  0.00           C  
ATOM   1544  CD1 TYR A  96      15.778  -3.890  -2.519  1.00  0.00           C  
ATOM   1545  CD2 TYR A  96      17.562  -3.022  -1.190  1.00  0.00           C  
ATOM   1546  CE1 TYR A  96      15.946  -2.860  -3.426  1.00  0.00           C  
ATOM   1547  CE2 TYR A  96      17.727  -1.985  -2.095  1.00  0.00           C  
ATOM   1548  CZ  TYR A  96      16.916  -1.911  -3.209  1.00  0.00           C  
ATOM   1549  OH  TYR A  96      17.074  -0.873  -4.105  1.00  0.00           O  
ATOM   1550  H   TYR A  96      14.438  -6.537  -1.480  1.00  0.00           H  
ATOM   1551  HA  TYR A  96      17.352  -6.583  -1.629  1.00  0.00           H  
ATOM   1552  HB2 TYR A  96      15.376  -5.035   0.077  1.00  0.00           H  
ATOM   1553  HB3 TYR A  96      17.097  -5.016   0.453  1.00  0.00           H  
ATOM   1554  HD1 TYR A  96      15.013  -4.638  -2.700  1.00  0.00           H  
ATOM   1555  HD2 TYR A  96      18.198  -3.075  -0.315  1.00  0.00           H  
ATOM   1556  HE1 TYR A  96      15.308  -2.800  -4.300  1.00  0.00           H  
ATOM   1557  HE2 TYR A  96      18.496  -1.243  -1.930  1.00  0.00           H  
ATOM   1558  HH  TYR A  96      16.205  -0.534  -4.363  1.00  0.00           H  
ATOM   1559  N   GLY A  97      15.893  -8.619   0.327  1.00  0.00           N  
ATOM   1560  CA  GLY A  97      16.168  -9.839   1.117  1.00  0.00           C  
ATOM   1561  C   GLY A  97      15.358  -9.932   2.401  1.00  0.00           C  
ATOM   1562  O   GLY A  97      15.395 -10.958   3.092  1.00  0.00           O  
ATOM   1563  H   GLY A  97      14.998  -8.494  -0.060  1.00  0.00           H  
ATOM   1564  HA2 GLY A  97      15.933 -10.692   0.499  1.00  0.00           H  
ATOM   1565  HA3 GLY A  97      17.224  -9.886   1.373  1.00  0.00           H  
ATOM   1566  N   PHE A  98      14.640  -8.852   2.726  1.00  0.00           N  
ATOM   1567  CA  PHE A  98      13.833  -8.734   3.951  1.00  0.00           C  
ATOM   1568  C   PHE A  98      12.420  -9.259   3.676  1.00  0.00           C  
ATOM   1569  O   PHE A  98      11.677  -8.642   2.903  1.00  0.00           O  
ATOM   1570  CB  PHE A  98      13.786  -7.250   4.393  1.00  0.00           C  
ATOM   1571  CG  PHE A  98      15.168  -6.597   4.489  1.00  0.00           C  
ATOM   1572  CD1 PHE A  98      15.950  -6.739   5.633  1.00  0.00           C  
ATOM   1573  CD2 PHE A  98      15.682  -5.848   3.426  1.00  0.00           C  
ATOM   1574  CE1 PHE A  98      17.199  -6.156   5.717  1.00  0.00           C  
ATOM   1575  CE2 PHE A  98      16.934  -5.267   3.511  1.00  0.00           C  
ATOM   1576  CZ  PHE A  98      17.690  -5.420   4.657  1.00  0.00           C  
ATOM   1577  H   PHE A  98      14.648  -8.094   2.111  1.00  0.00           H  
ATOM   1578  HA  PHE A  98      14.297  -9.326   4.738  1.00  0.00           H  
ATOM   1579  HB2 PHE A  98      13.189  -6.683   3.681  1.00  0.00           H  
ATOM   1580  HB3 PHE A  98      13.310  -7.185   5.367  1.00  0.00           H  
ATOM   1581  HD1 PHE A  98      15.570  -7.315   6.469  1.00  0.00           H  
ATOM   1582  HD2 PHE A  98      15.090  -5.722   2.527  1.00  0.00           H  
ATOM   1583  HE1 PHE A  98      17.793  -6.273   6.614  1.00  0.00           H  
ATOM   1584  HE2 PHE A  98      17.323  -4.690   2.681  1.00  0.00           H  
ATOM   1585  HZ  PHE A  98      18.670  -4.963   4.723  1.00  0.00           H  
ATOM   1586  N   ARG A  99      12.066 -10.411   4.287  1.00  0.00           N  
ATOM   1587  CA  ARG A  99      10.732 -11.031   4.106  1.00  0.00           C  
ATOM   1588  C   ARG A  99       9.622 -10.105   4.628  1.00  0.00           C  
ATOM   1589  O   ARG A  99       9.845  -9.259   5.513  1.00  0.00           O  
ATOM   1590  CB  ARG A  99      10.615 -12.443   4.779  1.00  0.00           C  
ATOM   1591  CG  ARG A  99      10.351 -12.469   6.311  1.00  0.00           C  
ATOM   1592  CD  ARG A  99      11.422 -11.725   7.108  1.00  0.00           C  
ATOM   1593  NE  ARG A  99      11.341 -11.970   8.558  1.00  0.00           N  
ATOM   1594  CZ  ARG A  99      12.346 -11.789   9.429  1.00  0.00           C  
ATOM   1595  NH1 ARG A  99      13.573 -11.494   9.007  1.00  0.00           N  
ATOM   1596  NH2 ARG A  99      12.126 -11.926  10.725  1.00  0.00           N  
ATOM   1597  H   ARG A  99      12.724 -10.859   4.856  1.00  0.00           H  
ATOM   1598  HA  ARG A  99      10.590 -11.152   3.032  1.00  0.00           H  
ATOM   1599  HB2 ARG A  99       9.807 -12.983   4.299  1.00  0.00           H  
ATOM   1600  HB3 ARG A  99      11.535 -12.989   4.588  1.00  0.00           H  
ATOM   1601  HG2 ARG A  99       9.389 -12.009   6.508  1.00  0.00           H  
ATOM   1602  HG3 ARG A  99      10.317 -13.500   6.647  1.00  0.00           H  
ATOM   1603  HD2 ARG A  99      12.385 -12.027   6.740  1.00  0.00           H  
ATOM   1604  HD3 ARG A  99      11.298 -10.661   6.933  1.00  0.00           H  
ATOM   1605  HE  ARG A  99      10.468 -12.254   8.908  1.00  0.00           H  
ATOM   1606 HH11 ARG A  99      13.764 -11.409   8.026  1.00  0.00           H  
ATOM   1607 HH12 ARG A  99      14.315 -11.367   9.674  1.00  0.00           H  
ATOM   1608 HH21 ARG A  99      11.210 -12.169  11.062  1.00  0.00           H  
ATOM   1609 HH22 ARG A  99      12.877 -11.800  11.385  1.00  0.00           H  
ATOM   1610  N   MET A 100       8.428 -10.296   4.081  1.00  0.00           N  
ATOM   1611  CA  MET A 100       7.263  -9.442   4.354  1.00  0.00           C  
ATOM   1612  C   MET A 100       5.979 -10.275   4.381  1.00  0.00           C  
ATOM   1613  O   MET A 100       5.857 -11.280   3.676  1.00  0.00           O  
ATOM   1614  CB  MET A 100       7.130  -8.322   3.288  1.00  0.00           C  
ATOM   1615  CG  MET A 100       8.301  -7.329   3.218  1.00  0.00           C  
ATOM   1616  SD  MET A 100       8.037  -6.055   1.980  1.00  0.00           S  
ATOM   1617  CE  MET A 100       6.549  -5.309   2.615  1.00  0.00           C  
ATOM   1618  H   MET A 100       8.325 -11.056   3.478  1.00  0.00           H  
ATOM   1619  HA  MET A 100       7.398  -8.984   5.331  1.00  0.00           H  
ATOM   1620  HB2 MET A 100       7.031  -8.783   2.308  1.00  0.00           H  
ATOM   1621  HB3 MET A 100       6.224  -7.758   3.487  1.00  0.00           H  
ATOM   1622  HG2 MET A 100       8.421  -6.849   4.184  1.00  0.00           H  
ATOM   1623  HG3 MET A 100       9.210  -7.863   2.973  1.00  0.00           H  
ATOM   1624  HE1 MET A 100       5.750  -6.038   2.593  1.00  0.00           H  
ATOM   1625  HE2 MET A 100       6.280  -4.467   1.998  1.00  0.00           H  
ATOM   1626  HE3 MET A 100       6.713  -4.979   3.629  1.00  0.00           H  
ATOM   1627  N   VAL A 101       5.021  -9.821   5.194  1.00  0.00           N  
ATOM   1628  CA  VAL A 101       3.715 -10.461   5.362  1.00  0.00           C  
ATOM   1629  C   VAL A 101       2.662  -9.666   4.564  1.00  0.00           C  
ATOM   1630  O   VAL A 101       2.318  -8.529   4.933  1.00  0.00           O  
ATOM   1631  CB  VAL A 101       3.313 -10.530   6.886  1.00  0.00           C  
ATOM   1632  CG1 VAL A 101       1.978 -11.292   7.095  1.00  0.00           C  
ATOM   1633  CG2 VAL A 101       4.457 -11.147   7.735  1.00  0.00           C  
ATOM   1634  H   VAL A 101       5.194  -9.006   5.694  1.00  0.00           H  
ATOM   1635  HA  VAL A 101       3.770 -11.479   4.977  1.00  0.00           H  
ATOM   1636  HB  VAL A 101       3.164  -9.511   7.232  1.00  0.00           H  
ATOM   1637 HG11 VAL A 101       1.735 -11.325   8.151  1.00  0.00           H  
ATOM   1638 HG12 VAL A 101       2.068 -12.303   6.720  1.00  0.00           H  
ATOM   1639 HG13 VAL A 101       1.184 -10.785   6.563  1.00  0.00           H  
ATOM   1640 HG21 VAL A 101       5.358 -10.553   7.620  1.00  0.00           H  
ATOM   1641 HG22 VAL A 101       4.656 -12.160   7.407  1.00  0.00           H  
ATOM   1642 HG23 VAL A 101       4.176 -11.159   8.781  1.00  0.00           H  
ATOM   1643  N   TYR A 102       2.216 -10.253   3.443  1.00  0.00           N  
ATOM   1644  CA  TYR A 102       1.145  -9.699   2.595  1.00  0.00           C  
ATOM   1645  C   TYR A 102      -0.205 -10.311   3.024  1.00  0.00           C  
ATOM   1646  O   TYR A 102      -0.306 -11.537   3.174  1.00  0.00           O  
ATOM   1647  CB  TYR A 102       1.424  -9.992   1.084  1.00  0.00           C  
ATOM   1648  CG  TYR A 102       2.550  -9.153   0.432  1.00  0.00           C  
ATOM   1649  CD1 TYR A 102       3.795  -8.993   1.049  1.00  0.00           C  
ATOM   1650  CD2 TYR A 102       2.365  -8.525  -0.812  1.00  0.00           C  
ATOM   1651  CE1 TYR A 102       4.795  -8.246   0.463  1.00  0.00           C  
ATOM   1652  CE2 TYR A 102       3.373  -7.778  -1.400  1.00  0.00           C  
ATOM   1653  CZ  TYR A 102       4.584  -7.645  -0.759  1.00  0.00           C  
ATOM   1654  OH  TYR A 102       5.599  -6.906  -1.337  1.00  0.00           O  
ATOM   1655  H   TYR A 102       2.621 -11.105   3.176  1.00  0.00           H  
ATOM   1656  HA  TYR A 102       1.113  -8.619   2.745  1.00  0.00           H  
ATOM   1657  HB2 TYR A 102       1.694 -11.035   0.974  1.00  0.00           H  
ATOM   1658  HB3 TYR A 102       0.512  -9.815   0.520  1.00  0.00           H  
ATOM   1659  HD1 TYR A 102       3.972  -9.468   2.010  1.00  0.00           H  
ATOM   1660  HD2 TYR A 102       1.415  -8.631  -1.317  1.00  0.00           H  
ATOM   1661  HE1 TYR A 102       5.749  -8.141   0.964  1.00  0.00           H  
ATOM   1662  HE2 TYR A 102       3.207  -7.300  -2.358  1.00  0.00           H  
ATOM   1663  HH  TYR A 102       6.433  -7.384  -1.242  1.00  0.00           H  
ATOM   1664  N   ASP A 103      -1.215  -9.439   3.204  1.00  0.00           N  
ATOM   1665  CA  ASP A 103      -2.590  -9.802   3.625  1.00  0.00           C  
ATOM   1666  C   ASP A 103      -2.599 -10.406   5.040  1.00  0.00           C  
ATOM   1667  O   ASP A 103      -2.509 -11.628   5.220  1.00  0.00           O  
ATOM   1668  CB  ASP A 103      -3.309 -10.729   2.605  1.00  0.00           C  
ATOM   1669  CG  ASP A 103      -4.831 -10.852   2.852  1.00  0.00           C  
ATOM   1670  OD1 ASP A 103      -5.254 -11.640   3.727  1.00  0.00           O  
ATOM   1671  OD2 ASP A 103      -5.612 -10.157   2.161  1.00  0.00           O  
ATOM   1672  H   ASP A 103      -1.024  -8.488   3.053  1.00  0.00           H  
ATOM   1673  HA  ASP A 103      -3.137  -8.864   3.668  1.00  0.00           H  
ATOM   1674  HB2 ASP A 103      -3.140 -10.343   1.605  1.00  0.00           H  
ATOM   1675  HB3 ASP A 103      -2.865 -11.720   2.661  1.00  0.00           H  
ATOM   1676  N   ASP A 104      -2.667  -9.520   6.043  1.00  0.00           N  
ATOM   1677  CA  ASP A 104      -2.854  -9.903   7.459  1.00  0.00           C  
ATOM   1678  C   ASP A 104      -4.146  -9.276   8.008  1.00  0.00           C  
ATOM   1679  O   ASP A 104      -4.360  -9.243   9.226  1.00  0.00           O  
ATOM   1680  CB  ASP A 104      -1.626  -9.471   8.295  1.00  0.00           C  
ATOM   1681  CG  ASP A 104      -1.495  -7.945   8.437  1.00  0.00           C  
ATOM   1682  OD1 ASP A 104      -1.146  -7.279   7.435  1.00  0.00           O  
ATOM   1683  OD2 ASP A 104      -1.725  -7.415   9.547  1.00  0.00           O  
ATOM   1684  H   ASP A 104      -2.570  -8.562   5.827  1.00  0.00           H  
ATOM   1685  HA  ASP A 104      -2.958 -10.984   7.517  1.00  0.00           H  
ATOM   1686  HB2 ASP A 104      -1.701  -9.911   9.282  1.00  0.00           H  
ATOM   1687  HB3 ASP A 104      -0.725  -9.850   7.821  1.00  0.00           H  
ATOM   1688  N   THR A 105      -5.018  -8.804   7.088  1.00  0.00           N  
ATOM   1689  CA  THR A 105      -6.342  -8.244   7.426  1.00  0.00           C  
ATOM   1690  C   THR A 105      -7.211  -9.279   8.180  1.00  0.00           C  
ATOM   1691  O   THR A 105      -8.038  -8.923   9.026  1.00  0.00           O  
ATOM   1692  CB  THR A 105      -7.071  -7.722   6.137  1.00  0.00           C  
ATOM   1693  OG1 THR A 105      -8.363  -7.182   6.468  1.00  0.00           O  
ATOM   1694  CG2 THR A 105      -7.225  -8.805   5.058  1.00  0.00           C  
ATOM   1695  H   THR A 105      -4.754  -8.833   6.147  1.00  0.00           H  
ATOM   1696  HA  THR A 105      -6.177  -7.395   8.081  1.00  0.00           H  
ATOM   1697  HB  THR A 105      -6.473  -6.913   5.727  1.00  0.00           H  
ATOM   1698  HG1 THR A 105      -8.254  -6.462   7.105  1.00  0.00           H  
ATOM   1699 HG21 THR A 105      -6.249  -9.160   4.755  1.00  0.00           H  
ATOM   1700 HG22 THR A 105      -7.736  -8.391   4.198  1.00  0.00           H  
ATOM   1701 HG23 THR A 105      -7.802  -9.633   5.449  1.00  0.00           H  
ATOM   1702  N   CYS A 106      -6.982 -10.562   7.865  1.00  0.00           N  
ATOM   1703  CA  CYS A 106      -7.544 -11.702   8.592  1.00  0.00           C  
ATOM   1704  C   CYS A 106      -6.589 -12.899   8.407  1.00  0.00           C  
ATOM   1705  O   CYS A 106      -5.880 -13.293   9.344  1.00  0.00           O  
ATOM   1706  CB  CYS A 106      -8.972 -12.024   8.083  1.00  0.00           C  
ATOM   1707  SG  CYS A 106      -9.821 -13.326   8.998  1.00  0.00           S  
ATOM   1708  H   CYS A 106      -6.399 -10.749   7.099  1.00  0.00           H  
ATOM   1709  HA  CYS A 106      -7.590 -11.447   9.650  1.00  0.00           H  
ATOM   1710  HB2 CYS A 106      -9.585 -11.135   8.155  1.00  0.00           H  
ATOM   1711  HB3 CYS A 106      -8.924 -12.332   7.044  1.00  0.00           H  
ATOM   1712  HG  CYS A 106      -9.828 -14.416   8.237  1.00  0.00           H  
ATOM   1713  N   ASP A 107      -6.547 -13.424   7.165  1.00  0.00           N  
ATOM   1714  CA  ASP A 107      -5.651 -14.517   6.743  1.00  0.00           C  
ATOM   1715  C   ASP A 107      -5.759 -14.701   5.224  1.00  0.00           C  
ATOM   1716  O   ASP A 107      -6.816 -14.452   4.632  1.00  0.00           O  
ATOM   1717  CB  ASP A 107      -5.966 -15.859   7.476  1.00  0.00           C  
ATOM   1718  CG  ASP A 107      -7.411 -16.352   7.264  1.00  0.00           C  
ATOM   1719  OD1 ASP A 107      -8.304 -15.944   8.038  1.00  0.00           O  
ATOM   1720  OD2 ASP A 107      -7.669 -17.128   6.323  1.00  0.00           O  
ATOM   1721  H   ASP A 107      -7.153 -13.051   6.492  1.00  0.00           H  
ATOM   1722  HA  ASP A 107      -4.635 -14.210   6.981  1.00  0.00           H  
ATOM   1723  HB2 ASP A 107      -5.283 -16.625   7.126  1.00  0.00           H  
ATOM   1724  HB3 ASP A 107      -5.802 -15.721   8.540  1.00  0.00           H  
ATOM   1725  N   LYS A 108      -4.682 -15.191   4.608  1.00  0.00           N  
ATOM   1726  CA  LYS A 108      -4.571 -15.318   3.136  1.00  0.00           C  
ATOM   1727  C   LYS A 108      -5.138 -16.670   2.626  1.00  0.00           C  
ATOM   1728  O   LYS A 108      -4.663 -17.226   1.627  1.00  0.00           O  
ATOM   1729  CB  LYS A 108      -3.086 -15.089   2.719  1.00  0.00           C  
ATOM   1730  CG  LYS A 108      -2.051 -15.958   3.476  1.00  0.00           C  
ATOM   1731  CD  LYS A 108      -0.585 -15.521   3.226  1.00  0.00           C  
ATOM   1732  CE  LYS A 108      -0.156 -15.662   1.757  1.00  0.00           C  
ATOM   1733  NZ  LYS A 108      -0.238 -17.067   1.284  1.00  0.00           N  
ATOM   1734  H   LYS A 108      -3.936 -15.496   5.162  1.00  0.00           H  
ATOM   1735  HA  LYS A 108      -5.171 -14.527   2.689  1.00  0.00           H  
ATOM   1736  HB2 LYS A 108      -2.987 -15.287   1.656  1.00  0.00           H  
ATOM   1737  HB3 LYS A 108      -2.839 -14.044   2.889  1.00  0.00           H  
ATOM   1738  HG2 LYS A 108      -2.256 -15.887   4.540  1.00  0.00           H  
ATOM   1739  HG3 LYS A 108      -2.170 -16.989   3.166  1.00  0.00           H  
ATOM   1740  HD2 LYS A 108      -0.471 -14.484   3.524  1.00  0.00           H  
ATOM   1741  HD3 LYS A 108       0.070 -16.134   3.840  1.00  0.00           H  
ATOM   1742  HE2 LYS A 108      -0.798 -15.050   1.139  1.00  0.00           H  
ATOM   1743  HE3 LYS A 108       0.866 -15.320   1.654  1.00  0.00           H  
ATOM   1744  HZ1 LYS A 108      -1.227 -17.390   1.282  1.00  0.00           H  
ATOM   1745  HZ2 LYS A 108       0.318 -17.688   1.905  1.00  0.00           H  
ATOM   1746  HZ3 LYS A 108       0.140 -17.142   0.319  1.00  0.00           H  
ATOM   1747  N   LYS A 109      -6.191 -17.171   3.311  1.00  0.00           N  
ATOM   1748  CA  LYS A 109      -6.973 -18.351   2.886  1.00  0.00           C  
ATOM   1749  C   LYS A 109      -8.428 -17.924   2.604  1.00  0.00           C  
ATOM   1750  O   LYS A 109      -8.889 -16.894   3.122  1.00  0.00           O  
ATOM   1751  CB  LYS A 109      -6.974 -19.436   3.998  1.00  0.00           C  
ATOM   1752  CG  LYS A 109      -5.583 -19.879   4.490  1.00  0.00           C  
ATOM   1753  CD  LYS A 109      -5.635 -20.859   5.696  1.00  0.00           C  
ATOM   1754  CE  LYS A 109      -6.150 -20.224   7.017  1.00  0.00           C  
ATOM   1755  NZ  LYS A 109      -7.617 -19.935   7.025  1.00  0.00           N  
ATOM   1756  H   LYS A 109      -6.462 -16.723   4.137  1.00  0.00           H  
ATOM   1757  HA  LYS A 109      -6.534 -18.758   1.978  1.00  0.00           H  
ATOM   1758  HB2 LYS A 109      -7.521 -19.049   4.849  1.00  0.00           H  
ATOM   1759  HB3 LYS A 109      -7.498 -20.317   3.627  1.00  0.00           H  
ATOM   1760  HG2 LYS A 109      -5.066 -20.364   3.670  1.00  0.00           H  
ATOM   1761  HG3 LYS A 109      -5.021 -18.996   4.780  1.00  0.00           H  
ATOM   1762  HD2 LYS A 109      -6.281 -21.690   5.445  1.00  0.00           H  
ATOM   1763  HD3 LYS A 109      -4.632 -21.244   5.868  1.00  0.00           H  
ATOM   1764  HE2 LYS A 109      -5.940 -20.905   7.834  1.00  0.00           H  
ATOM   1765  HE3 LYS A 109      -5.613 -19.300   7.192  1.00  0.00           H  
ATOM   1766  HZ1 LYS A 109      -8.150 -20.778   6.729  1.00  0.00           H  
ATOM   1767  HZ2 LYS A 109      -7.834 -19.152   6.372  1.00  0.00           H  
ATOM   1768  HZ3 LYS A 109      -7.925 -19.668   7.980  1.00  0.00           H  
ATOM   1769  N   ASN A 110      -9.152 -18.731   1.807  1.00  0.00           N  
ATOM   1770  CA  ASN A 110     -10.601 -18.561   1.575  1.00  0.00           C  
ATOM   1771  C   ASN A 110     -11.328 -19.855   2.007  1.00  0.00           C  
ATOM   1772  O   ASN A 110     -11.903 -19.889   3.121  1.00  0.00           O  
ATOM   1773  CB  ASN A 110     -10.906 -18.214   0.082  1.00  0.00           C  
ATOM   1774  CG  ASN A 110     -10.367 -16.852  -0.393  1.00  0.00           C  
ATOM   1775  OD1 ASN A 110     -10.061 -16.677  -1.570  1.00  0.00           O  
ATOM   1776  ND2 ASN A 110     -10.256 -15.874   0.503  1.00  0.00           N  
ATOM   1777  OXT ASN A 110     -11.273 -20.857   1.254  1.00  0.00           O  
ATOM   1778  H   ASN A 110      -8.694 -19.473   1.360  1.00  0.00           H  
ATOM   1779  HA  ASN A 110     -10.955 -17.735   2.202  1.00  0.00           H  
ATOM   1780  HB2 ASN A 110     -10.474 -18.986  -0.547  1.00  0.00           H  
ATOM   1781  HB3 ASN A 110     -11.980 -18.213  -0.067  1.00  0.00           H  
ATOM   1782 HD21 ASN A 110     -10.519 -16.054   1.427  1.00  0.00           H  
ATOM   1783 HD22 ASN A 110      -9.900 -15.010   0.203  1.00  0.00           H  
TER    1784      ASN A 110                                                      
END
MOLECULE T0411.pdb
ATOM      1  N   SER    20      23.383  16.708  14.252  0.80 17.27           N  
ATOM      2  CA  SER    20      23.666  15.746  13.160  0.80 15.92           C  
ATOM      3  C   SER    20      22.476  15.495  12.278  0.80 13.44           C  
ATOM      4  O   SER    20      21.317  15.511  12.700  0.80 15.60           O  
ATOM      5  CB  SER    20      24.215  14.417  13.698  0.80 17.48           C  
ATOM      6  OG  SER    20      23.257  13.716  14.438  0.80 22.08           O  
ATOM      7  N   ASN    21      22.790  15.226  11.033  0.80 11.57           N  
ATOM      8  CA  ASN    21      21.799  14.886  10.050  0.80 10.66           C  
ATOM      9  C   ASN    21      21.016  13.672  10.572  0.80 10.50           C  
ATOM     10  O   ASN    21      21.625  12.772  11.156  0.80 12.22           O  
ATOM     11  CB  ASN    21      22.527  14.565   8.733  0.80 10.39           C  
ATOM     12  CG  ASN    21      21.644  14.679   7.510  0.80 10.55           C  
ATOM     13  OD1 ASN    21      21.440  15.758   7.041  0.80 12.42           O  
ATOM     14  ND2 ASN    21      21.075  13.574   7.057  0.80 13.97           N  
ATOM     15  N   ILE    22      19.702  13.612  10.337  1.00 10.95           N  
ATOM     16  CA  ILE    22      18.928  12.460  10.733  1.00 11.03           C  
ATOM     17  C   ILE    22      19.511  11.260   9.987  1.00  9.32           C  
ATOM     18  O   ILE    22      19.727  11.303   8.764  1.00 10.99           O  
ATOM     19  CB  ILE    22      17.457  12.632  10.369  1.00 11.59           C  
ATOM     20  CG1 ILE    22      16.804  13.845  11.054  1.00 13.57           C  
ATOM     21  CG2 ILE    22      16.692  11.323  10.585  1.00 11.49           C  
ATOM     22  CD1 ILE    22      15.526  14.302  10.345  1.00 14.59           C  
ATOM     23  N   GLN    23      19.722  10.205  10.701  1.00 10.03           N  
ATOM     24  CA  GLN    23      20.202   9.026  10.107  1.00  7.97           C  
ATOM     25  C   GLN    23      19.164   8.505   9.136  1.00  6.39           C  
ATOM     26  O   GLN    23      17.996   8.376   9.487  1.00  8.10           O  
ATOM     27  CB  GLN    23      20.434   7.978  11.189  1.00 10.93           C  
ATOM     28  CG  GLN    23      20.924   6.641  10.664  1.00 14.01           C  
ATOM     29  CD  GLN    23      22.276   6.695   9.980  1.00 17.14           C  
ATOM     30  OE1 GLN    23      22.415   6.425   8.780  1.00 22.09           O  
ATOM     31  NE2 GLN    23      23.286   7.076  10.734  1.00 21.70           N  
ATOM     32  N   SER    24      19.580   8.181   7.926  1.00  6.02           N  
ATOM     33  CA  SER    24      18.730   7.632   6.909  0.50  5.38           C  
ATOM     35  C   SER    24      19.314   6.309   6.403  1.00  5.20           C  
ATOM     36  O   SER    24      20.540   6.139   6.354  1.00  6.34           O  
ATOM     37  CB  SER    24      18.620   8.604   5.752  0.50  6.73           C  
ATOM     39  OG  SER    24      19.903   8.982   5.331  0.50  6.31           O  
ATOM     41  N   TYR    25      18.430   5.409   5.975  1.00  4.90           N  
ATOM     42  CA  TYR    25      18.808   4.061   5.582  1.00  4.36           C  
ATOM     43  C   TYR    25      18.307   3.735   4.175  1.00  4.30           C  
ATOM     44  O   TYR    25      17.151   4.018   3.830  1.00  4.70           O  
ATOM     45  CB  TYR    25      18.244   3.055   6.559  1.00  4.48           C  
ATOM     46  CG  TYR    25      18.793   3.226   7.967  1.00  4.25           C  
ATOM     47  CD1 TYR    25      20.157   3.141   8.226  1.00  4.90           C  
ATOM     48  CD2 TYR    25      17.959   3.440   9.028  1.00  5.20           C  
ATOM     49  CE1 TYR    25      20.662   3.254   9.519  1.00  5.78           C  
ATOM     50  CE2 TYR    25      18.462   3.530  10.349  1.00  5.38           C  
ATOM     51  CZ  TYR    25      19.818   3.453  10.577  1.00  5.83           C  
ATOM     52  OH  TYR    25      20.352   3.513  11.834  1.00  7.58           O  
ATOM     53  N   SER    26      19.164   3.101   3.384  1.00  4.64           N  
ATOM     54  CA  SER    26      18.810   2.501   2.107  1.00  4.76           C  
ATOM     55  C   SER    26      18.144   1.145   2.296  1.00  4.12           C  
ATOM     56  O   SER    26      18.123   0.572   3.389  1.00  4.46           O  
ATOM     57  CB  SER    26      20.068   2.275   1.296  1.00  5.25           C  
ATOM     58  OG  SER    26      20.846   1.281   1.938  1.00  5.71           O  
ATOM     59  N   PHE    27      17.684   0.566   1.199  1.00  4.20           N  
ATOM     60  CA  PHE    27      17.183  -0.814   1.228  1.00  4.85           C  
ATOM     61  C   PHE    27      18.203  -1.781   1.840  1.00  4.15           C  
ATOM     62  O   PHE    27      17.863  -2.567   2.715  1.00  4.54           O  
ATOM     63  CB  PHE    27      16.840  -1.289  -0.187  1.00  4.65           C  
ATOM     64  CG  PHE    27      16.405  -2.720  -0.195  1.00  4.75           C  
ATOM     65  CD1 PHE    27      15.200  -3.108   0.378  1.00  5.63           C  
ATOM     66  CD2 PHE    27      17.199  -3.718  -0.775  1.00  5.22           C  
ATOM     67  CE1 PHE    27      14.812  -4.423   0.418  1.00  6.31           C  
ATOM     68  CE2 PHE    27      16.798  -5.031  -0.764  1.00  6.95           C  
ATOM     69  CZ  PHE    27      15.581  -5.385  -0.175  1.00  6.90           C  
ATOM     70  N   GLU    28      19.449  -1.741   1.365  1.00  4.46           N  
ATOM     71  CA  GLU    28      20.433  -2.657   1.884  1.00  4.55           C  
ATOM     72  C   GLU    28      20.686  -2.438   3.365  1.00  4.97           C  
ATOM     73  O   GLU    28      20.864  -3.396   4.146  1.00  5.45           O  
ATOM     74  CB  GLU    28      21.728  -2.584   1.075  1.00  5.35           C  
ATOM     75  CG  GLU    28      21.576  -3.230  -0.271  1.00  8.61           C  
ATOM     76  CD  GLU    28      21.516  -4.793  -0.207  1.00  7.80           C  
ATOM     77  OE1 GLU    28      22.246  -5.318   0.605  1.00 10.36           O  
ATOM     78  OE2 GLU    28      20.795  -5.361  -1.051  1.00 10.99           O  
ATOM     79  N   ASP    29      20.690  -1.170   3.804  1.00  4.63           N  
ATOM     80  CA  ASP    29      20.816  -0.894   5.215  1.00  5.09           C  
ATOM     81  C   ASP    29      19.659  -1.511   6.021  1.00  4.66           C  
ATOM     82  O   ASP    29      19.885  -2.069   7.101  1.00  5.52           O  
ATOM     83  CB  ASP    29      20.792   0.610   5.459  1.00  5.73           C  
ATOM     84  CG  ASP    29      21.998   1.390   4.943  1.00  5.96           C  
ATOM     85  OD1 ASP    29      23.097   0.801   4.810  1.00  9.45           O  
ATOM     86  OD2 ASP    29      21.791   2.606   4.675  1.00  6.58           O  
ATOM     87  N   MET    30      18.438  -1.378   5.486  1.00  4.52           N  
ATOM     88  CA  MET    30      17.275  -1.926   6.170  1.00  4.57           C  
ATOM     89  C   MET    30      17.290  -3.442   6.216  1.00  4.62           C  
ATOM     90  O   MET    30      16.909  -4.031   7.218  1.00  5.57           O  
ATOM     91  CB  MET    30      15.990  -1.409   5.534  1.00  4.62           C  
ATOM     92  CG  MET    30      15.744   0.062   5.760  1.00  4.73           C  
ATOM     93  SD  MET    30      15.580   0.571   7.603  0.90  5.90          SE  
ATOM     94  CE  MET    30      13.979  -0.293   7.946  1.00 10.68           C  
ATOM     95  N   LYS    31      17.771  -4.079   5.165  0.50  4.72           N  
ATOM     97  CA  LYS    31      17.941  -5.503   5.166  0.25  5.00           C  
ATOM    100  C   LYS    31      18.911  -5.892   6.320  0.50  4.65           C  
ATOM    102  O   LYS    31      18.659  -6.843   7.086  0.50  5.54           O  
ATOM    104  CB  LYS    31      18.436  -5.931   3.780  0.25  5.09           C  
ATOM    107  CG  LYS    31      18.633  -7.408   3.587  0.25  4.45           C  
ATOM    110  CD  LYS    31      19.621  -7.678   2.406  0.25  5.89           C  
ATOM    113  CE  LYS    31      18.982  -7.379   1.062  0.25  5.98           C  
ATOM    116  NZ  LYS    31      19.966  -7.513  -0.063  0.25  4.92           N  
ATOM    119  N   ARG    32      20.016  -5.189   6.457  0.80  5.55           N  
ATOM    121  CA  ARG    32      20.906  -5.475   7.551  0.80  7.17           C  
ATOM    123  C   ARG    32      20.232  -5.309   8.893  0.80  6.23           C  
ATOM    125  O   ARG    32      20.276  -6.181   9.765  0.80  7.14           O  
ATOM    127  CB  ARG    32      22.169  -4.635   7.440  0.80  8.36           C  
ATOM    129  CG  ARG    32      23.095  -5.165   6.360  0.80 11.35           C  
ATOM    131  CD  ARG    32      24.391  -4.363   6.278  0.80 15.69           C  
ATOM    133  NE  ARG    32      24.132  -3.113   5.578  0.80 22.23           N  
ATOM    135  CZ  ARG    32      24.689  -2.712   4.435  0.80 21.88           C  
ATOM    137  NH1 ARG    32      24.317  -1.537   3.898  0.80 19.62           N  
ATOM    139  NH2 ARG    32      25.626  -3.443   3.842  0.80 24.64           N  
ATOM    141  N   ILE    33      19.520  -4.204   9.045  1.00  5.62           N  
ATOM    142  CA  ILE    33      18.872  -3.915  10.333  1.00  5.84           C  
ATOM    143  C   ILE    33      17.838  -4.978  10.666  1.00  5.82           C  
ATOM    144  O   ILE    33      17.810  -5.485  11.796  1.00  6.61           O  
ATOM    145  CB  ILE    33      18.279  -2.507  10.301  1.00  6.44           C  
ATOM    146  CG1 ILE    33      19.414  -1.505  10.308  1.00  7.28           C  
ATOM    147  CG2 ILE    33      17.317  -2.274  11.453  1.00  8.16           C  
ATOM    148  CD1 ILE    33      18.996  -0.081   9.899  1.00  8.84           C  
ATOM    149  N   VAL    34      16.990  -5.341   9.707  1.00  5.88           N  
ATOM    150  CA  VAL    34      16.002  -6.368   9.967  1.00  6.66           C  
ATOM    151  C   VAL    34      16.670  -7.668  10.385  1.00  6.17           C  
ATOM    152  O   VAL    34      16.259  -8.310  11.351  1.00  7.34           O  
ATOM    153  CB  VAL    34      15.074  -6.537   8.746  1.00  7.43           C  
ATOM    154  CG1 VAL    34      14.163  -7.763   8.914  1.00  9.58           C  
ATOM    155  CG2 VAL    34      14.239  -5.264   8.563  1.00  8.70           C  
ATOM    156  N   GLY    35      17.738  -8.033   9.671  1.00  6.43           N  
ATOM    157  CA  GLY    35      18.439  -9.261   9.977  1.00  6.66           C  
ATOM    158  C   GLY    35      19.162  -9.306  11.311  1.00  6.57           C  
ATOM    159  O   GLY    35      19.486 -10.374  11.803  1.00  8.37           O  
ATOM    160  N   LYS    36      19.460  -8.140  11.881  1.00  6.29           N  
ATOM    161  CA  LYS    36      20.074  -8.045  13.201  0.25  6.74           C  
ATOM    164  C   LYS    36      19.111  -8.321  14.326  1.00  7.11           C  
ATOM    165  O   LYS    36      19.523  -8.692  15.430  1.00  8.42           O  
ATOM    166  CB  LYS    36      20.649  -6.659  13.450  0.25  7.30           C  
ATOM    169  CG  LYS    36      21.870  -6.372  12.639  0.25  7.35           C  
ATOM    172  CD  LYS    36      22.234  -4.913  12.683  0.25  7.90           C  
ATOM    175  CE  LYS    36      22.881  -4.526  14.003  0.25  6.97           C  
ATOM    178  NZ  LYS    36      23.143  -3.054  13.963  0.25  7.30           N  
ATOM    181  N   HIS    37      17.826  -8.110  14.096  1.00  7.61           N  
ATOM    182  CA  HIS    37      16.828  -8.314  15.165  1.00  8.62           C  
ATOM    183  C   HIS    37      17.270  -7.588  16.434  1.00  7.84           C  
ATOM    184  O   HIS    37      17.249  -8.164  17.524  1.00  8.43           O  
ATOM    185  CB  HIS    37      16.586  -9.818  15.436  1.00 10.04           C  
ATOM    186  CG  HIS    37      16.065 -10.524  14.232  1.00 11.70           C  
ATOM    187  ND1 HIS    37      14.752 -10.435  13.832  1.00 17.45           N  
ATOM    188  CD2 HIS    37      16.693 -11.224  13.259  1.00 12.70           C  
ATOM    189  CE1 HIS    37      14.590 -11.111  12.703  1.00 17.15           C  
ATOM    190  NE2 HIS    37      15.756 -11.604  12.337  1.00 14.42           N  
ATOM    191  N   ASP    38      17.670  -6.339  16.335  1.00  8.59           N  
ATOM    192  CA  ASP    38      18.203  -5.607  17.459  1.00  8.40           C  
ATOM    193  C   ASP    38      17.066  -5.247  18.402  1.00  8.57           C  
ATOM    194  O   ASP    38      16.109  -4.578  18.000  1.00  8.80           O  
ATOM    195  CB  ASP    38      18.850  -4.368  16.870  1.00 11.30           C  
ATOM    196  CG  ASP    38      19.619  -3.582  17.830  1.00 14.90           C  
ATOM    197  OD1 ASP    38      19.305  -3.575  19.031  1.00 13.89           O  
ATOM    198  OD2 ASP    38      20.525  -2.882  17.308  1.00 20.42           O  
ATOM    199  N   PRO    39      17.161  -5.670  19.671  1.00  9.42           N  
ATOM    200  CA  PRO    39      16.081  -5.410  20.604  1.00 10.88           C  
ATOM    201  C   PRO    39      15.866  -3.959  20.898  1.00 10.52           C  
ATOM    202  O   PRO    39      14.815  -3.569  21.460  1.00 13.03           O  
ATOM    203  CB  PRO    39      16.529  -6.159  21.854  1.00 11.33           C  
ATOM    204  CG  PRO    39      17.990  -6.224  21.786  1.00 12.34           C  
ATOM    205  CD  PRO    39      18.248  -6.420  20.316  1.00 11.01           C  
ATOM    206  N   ASN    40      16.849  -3.128  20.572  1.00  9.50           N  
ATOM    207  CA  ASN    40      16.758  -1.718  20.866  0.70  9.40           C  
ATOM    209  C   ASN    40      16.493  -0.844  19.622  1.00  8.33           C  
ATOM    210  O   ASN    40      16.728   0.358  19.653  1.00  8.99           O  
ATOM    211  CB  ASN    40      17.923  -1.351  21.740  0.70 11.15           C  
ATOM    213  CG  ASN    40      17.781  -1.941  23.175  0.70 12.91           C  
ATOM    215  OD1 ASN    40      16.695  -1.927  23.785  0.70 16.59           O  
ATOM    217  ND2 ASN    40      18.874  -2.447  23.692  0.70 19.60           N  
ATOM    219  N   VAL    41      15.951  -1.474  18.588  1.00  6.99           N  
ATOM    220  CA  VAL    41      15.496  -0.806  17.374  1.00  7.02           C  
ATOM    221  C   VAL    41      14.005  -1.096  17.203  1.00  5.94           C  
ATOM    222  O   VAL    41      13.545  -2.232  17.442  1.00  8.12           O  
ATOM    223  CB  VAL    41      16.280  -1.295  16.174  1.00  8.84           C  
ATOM    224  CG1 VAL    41      15.632  -0.818  14.857  1.00 11.68           C  
ATOM    225  CG2 VAL    41      17.745  -0.854  16.309  1.00 11.84           C  
ATOM    226  N   VAL    42      13.245  -0.066  16.842  1.00  5.37           N  
ATOM    227  CA  VAL    42      11.829  -0.165  16.581  1.00  5.48           C  
ATOM    228  C   VAL    42      11.588   0.308  15.157  1.00  4.86           C  
ATOM    229  O   VAL    42      12.012   1.394  14.793  1.00  5.55           O  
ATOM    230  CB  VAL    42      11.003   0.700  17.548  1.00  6.60           C  
ATOM    231  CG1 VAL    42       9.512   0.573  17.290  1.00  8.10           C  
ATOM    232  CG2 VAL    42      11.329   0.348  19.012  1.00  8.91           C  
ATOM    233  N   LEU    43      10.860  -0.510  14.397  0.50  4.63           N  
ATOM    235  CA  LEU    43      10.520  -0.219  12.994  0.50  4.37           C  
ATOM    237  C   LEU    43       9.110   0.354  12.991  0.50  3.98           C  
ATOM    239  O   LEU    43       8.134  -0.360  13.243  0.50  5.19           O  
ATOM    241  CB  LEU    43      10.568  -1.505  12.162  0.50  4.41           C  
ATOM    243  CG  LEU    43      11.927  -2.221  12.180  0.50  5.41           C  
ATOM    245  CD1 LEU    43      11.875  -3.496  11.343  0.50  8.93           C  
ATOM    247  CD2 LEU    43      13.037  -1.314  11.712  0.50  8.67           C  
ATOM    249  N   VAL    44       9.000   1.652  12.736  1.00  4.06           N  
ATOM    250  CA  VAL    44       7.740   2.378  12.881  1.00  4.25           C  
ATOM    251  C   VAL    44       7.147   2.669  11.506  1.00  3.95           C  
ATOM    252  O   VAL    44       7.555   3.581  10.806  1.00  4.41           O  
ATOM    253  CB  VAL    44       7.902   3.677  13.657  1.00  4.88           C  
ATOM    254  CG1 VAL    44       6.529   4.262  13.921  1.00  5.95           C  
ATOM    255  CG2 VAL    44       8.673   3.463  14.990  1.00  6.06           C  
ATOM    256  N   ASP    45       6.151   1.846  11.156  1.00  3.90           N  
ATOM    257  CA  ASP    45       5.442   1.950   9.890  1.00  3.71           C  
ATOM    258  C   ASP    45       4.191   2.777  10.142  1.00  3.91           C  
ATOM    259  O   ASP    45       3.299   2.388  10.900  1.00  4.37           O  
ATOM    260  CB  ASP    45       5.090   0.528   9.423  1.00  3.86           C  
ATOM    261  CG  ASP    45       4.448   0.448   8.065  1.00  4.16           C  
ATOM    262  OD1 ASP    45       3.766   1.386   7.622  1.00  4.52           O  
ATOM    263  OD2 ASP    45       4.619  -0.635   7.445  1.00  5.13           O  
ATOM    264  N   VAL    46       4.143   3.959   9.534  1.00  3.64           N  
ATOM    265  CA  VAL    46       3.064   4.909   9.809  1.00  3.77           C  
ATOM    266  C   VAL    46       2.029   4.957   8.685  1.00  4.00           C  
ATOM    267  O   VAL    46       1.222   5.882   8.626  1.00  4.07           O  
ATOM    268  CB  VAL    46       3.598   6.308  10.187  1.00  4.06           C  
ATOM    269  CG1 VAL    46       4.585   6.189  11.327  1.00  4.83           C  
ATOM    270  CG2 VAL    46       4.204   7.057   9.036  1.00  4.55           C  
ATOM    271  N   ARG    47       2.003   3.935   7.839  1.00  3.76           N  
ATOM    272  CA  ARG    47       0.884   3.772   6.921  1.00  3.93           C  
ATOM    273  C   ARG    47      -0.412   3.481   7.693  1.00  3.94           C  
ATOM    274  O   ARG    47      -0.403   3.207   8.893  1.00  4.15           O  
ATOM    275  CB  ARG    47       1.188   2.654   5.923  1.00  4.16           C  
ATOM    276  CG  ARG    47       2.367   2.950   5.015  1.00  4.41           C  
ATOM    277  CD  ARG    47       2.700   1.812   4.070  1.00  4.36           C  
ATOM    278  NE  ARG    47       3.029   0.614   4.852  1.00  4.91           N  
ATOM    279  CZ  ARG    47       2.867  -0.628   4.472  1.00  4.68           C  
ATOM    280  NH1 ARG    47       2.440  -0.932   3.273  1.00  6.72           N  
ATOM    281  NH2 ARG    47       3.136  -1.589   5.344  1.00  5.67           N  
ATOM    282  N   GLU    48      -1.532   3.555   6.981  1.00  4.09           N  
ATOM    283  CA  GLU    48      -2.806   3.203   7.583  1.00  4.53           C  
ATOM    284  C   GLU    48      -2.890   1.692   7.786  1.00  4.44           C  
ATOM    285  O   GLU    48      -2.183   0.927   7.132  1.00  4.87           O  
ATOM    286  CB  GLU    48      -3.978   3.702   6.752  1.00  4.95           C  
ATOM    287  CG  GLU    48      -4.072   5.230   6.741  1.00  5.30           C  
ATOM    288  CD  GLU    48      -4.203   5.796   8.148  1.00  5.46           C  
ATOM    289  OE1 GLU    48      -5.176   5.400   8.836  1.00  7.30           O  
ATOM    290  OE2 GLU    48      -3.321   6.546   8.603  1.00  5.88           O  
ATOM    291  N   PRO    49      -3.765   1.230   8.667  1.00  5.07           N  
ATOM    292  CA  PRO    49      -3.842  -0.216   8.944  1.00  5.88           C  
ATOM    293  C   PRO    49      -4.113  -1.065   7.703  1.00  5.59           C  
ATOM    294  O   PRO    49      -3.590  -2.164   7.577  1.00  6.38           O  
ATOM    295  CB  PRO    49      -4.937  -0.303  10.007  1.00  7.08           C  
ATOM    296  CG  PRO    49      -4.851   1.011  10.738  1.00  6.97           C  
ATOM    297  CD  PRO    49      -4.612   1.988   9.621  1.00  6.19           C  
ATOM    298  N   SER    50      -4.936  -0.567   6.778  1.00  6.07           N  
ATOM    299  CA  SER    50      -5.245  -1.286   5.570  1.00  6.89           C  
ATOM    300  C   SER    50      -4.005  -1.467   4.730  1.00  8.82           C  
ATOM    301  O   SER    50      -3.692  -2.647   4.387  1.00 11.66           O  
ATOM    302  CB  SER    50      -6.402  -0.583   4.864  1.00  8.18           C  
ATOM    303  OG  SER    50      -6.141   0.781   4.672  1.00  9.85           O  
ATOM    304  N   GLU    51      -3.183  -0.409   4.608  1.00  6.34           N  
ATOM    305  CA  GLU    51      -1.884  -0.514   3.894  1.00  6.38           C  
ATOM    306  C   GLU    51      -0.938  -1.517   4.559  1.00  6.84           C  
ATOM    307  O   GLU    51      -0.271  -2.363   3.937  1.00  9.87           O  
ATOM    308  CB  GLU    51      -1.187   0.833   3.816  1.00  6.45           C  
ATOM    309  CG  GLU    51      -1.825   1.884   2.936  1.00  6.93           C  
ATOM    310  CD  GLU    51      -1.213   3.265   3.116  1.00  6.09           C  
ATOM    311  OE1 GLU    51      -1.500   3.925   4.126  1.00  5.52           O  
ATOM    312  OE2 GLU    51      -0.401   3.683   2.254  1.00  7.55           O  
ATOM    313  N   TYR    52      -0.916  -1.495   5.874  0.50  6.32           N  
ATOM    315  CA  TYR    52      -0.057  -2.406   6.644  0.50  6.07           C  
ATOM    317  C   TYR    52      -0.470  -3.849   6.476  0.50  5.86           C  
ATOM    319  O   TYR    52       0.366  -4.768   6.534  0.50  7.51           O  
ATOM    321  CB  TYR    52      -0.144  -1.997   8.110  0.50  6.62           C  
ATOM    323  CG  TYR    52       0.892  -2.603   8.989  0.50  5.83           C  
ATOM    325  CD1 TYR    52       2.105  -1.968   9.173  0.50  6.83           C  
ATOM    327  CD2 TYR    52       0.642  -3.786   9.673  0.50  7.08           C  
ATOM    329  CE1 TYR    52       3.067  -2.478  10.005  0.50  5.81           C  
ATOM    331  CE2 TYR    52       1.565  -4.306  10.531  0.50  6.54           C  
ATOM    333  CZ  TYR    52       2.800  -3.670  10.674  0.50  5.84           C  
ATOM    335  OH  TYR    52       3.723  -4.245  11.535  0.50  7.40           O  
ATOM    337  N   SER    53      -1.764  -4.079   6.330  0.50  5.43           N  
ATOM    339  CA  SER    53      -2.219  -5.414   6.209  0.50  6.90           C  
ATOM    341  C   SER    53      -1.818  -5.969   4.833  0.50  6.17           C  
ATOM    343  O   SER    53      -1.635  -7.185   4.723  0.50  7.67           O  
ATOM    345  CB  SER    53      -3.697  -5.499   6.487  0.50  7.43           C  
ATOM    347  OG  SER    53      -4.418  -4.913   5.460  0.50 13.76           O  
ATOM    349  N   ILE    54      -1.678  -5.142   3.794  0.50  5.58           N  
ATOM    351  CA  ILE    54      -1.227  -5.645   2.484  0.50  5.83           C  
ATOM    353  C   ILE    54       0.166  -6.287   2.599  0.50  5.76           C  
ATOM    355  O   ILE    54       0.397  -7.379   2.078  0.50  6.45           O  
ATOM    357  CB  ILE    54      -1.212  -4.535   1.411  0.50  5.60           C  
ATOM    359  CG1 ILE    54      -2.635  -4.115   1.094  0.50  6.79           C  
ATOM    361  CG2 ILE    54      -0.463  -4.984   0.154  0.50  6.39           C  
ATOM    363  CD1 ILE    54      -2.804  -3.180   1.890  0.50  7.99           C  
ATOM    365  N   VAL    55       1.106  -5.554   3.200  0.50  5.87           N  
ATOM    367  CA  VAL    55       2.442  -6.139   3.379  0.50  7.15           C  
ATOM    369  C   VAL    55       3.172  -5.287   4.420  0.50  5.98           C  
ATOM    371  O   VAL    55       2.966  -4.089   4.462  0.50  7.84           O  
ATOM    373  CB  VAL    55       3.232  -6.295   2.008  0.50  7.51           C  
ATOM    375  CG1 VAL    55       4.737  -6.182   2.192  0.50  7.32           C  
ATOM    377  CG2 VAL    55       2.873  -7.584   1.140  0.50  6.68           C  
ATOM    379  N   HIS    56       4.011  -5.884   5.273  1.00  6.64           N  
ATOM    380  CA  HIS    56       4.737  -5.075   6.240  1.00  5.79           C  
ATOM    381  C   HIS    56       6.027  -5.801   6.574  1.00  6.24           C  
ATOM    382  O   HIS    56       6.199  -6.985   6.280  1.00  9.13           O  
ATOM    383  CB  HIS    56       3.907  -4.718   7.445  1.00  7.71           C  
ATOM    384  CG  HIS    56       3.388  -5.867   8.177  1.00  9.52           C  
ATOM    385  ND1 HIS    56       2.078  -6.258   8.044  1.00 11.75           N  
ATOM    386  CD2 HIS    56       3.958  -6.701   9.075  1.00 12.20           C  
ATOM    387  CE1 HIS    56       1.856  -7.287   8.843  1.00 15.12           C  
ATOM    388  NE2 HIS    56       2.981  -7.576   9.477  1.00 15.99           N  
ATOM    389  N   ILE    57       6.973  -5.068   7.148  1.00  6.13           N  
ATOM    390  CA  ILE    57       8.204  -5.694   7.595  1.00  6.83           C  
ATOM    391  C   ILE    57       7.907  -6.485   8.874  1.00  7.02           C  
ATOM    392  O   ILE    57       7.323  -5.947   9.816  1.00  6.76           O  
ATOM    393  CB  ILE    57       9.320  -4.677   7.801  1.00  7.12           C  
ATOM    394  CG1 ILE    57       9.588  -3.954   6.492  1.00  8.15           C  
ATOM    395  CG2 ILE    57      10.571  -5.370   8.357  1.00  8.78           C  
ATOM    396  CD1 ILE    57      10.670  -2.906   6.578  1.00  9.39           C  
ATOM    397  N   PRO    58       8.313  -7.760   8.977  1.00  9.09           N  
ATOM    398  CA  PRO    58       8.059  -8.494  10.204  1.00 10.43           C  
ATOM    399  C   PRO    58       8.647  -7.782  11.415  1.00 10.46           C  
ATOM    400  O   PRO    58       9.742  -7.269  11.374  1.00 10.73           O  
ATOM    401  CB  PRO    58       8.731  -9.853   9.936  1.00 12.37           C  
ATOM    402  CG  PRO    58       8.691 -10.013   8.501  1.00 13.37           C  
ATOM    403  CD  PRO    58       8.935  -8.605   7.965  1.00 10.81           C  
ATOM    404  N   ALA    59       7.887  -7.805  12.482  1.00 11.11           N  
ATOM    405  CA  ALA    59       8.284  -7.244  13.763  1.00 11.14           C  
ATOM    406  C   ALA    59       8.200  -5.727  13.826  1.00  9.23           C  
ATOM    407  O   ALA    59       8.397  -5.138  14.872  1.00 10.44           O  
ATOM    408  CB  ALA    59       9.698  -7.747  14.216  1.00 13.99           C  
ATOM    409  N   SER    60       7.815  -5.081  12.729  1.00  7.06           N  
ATOM    410  CA  SER    60       7.530  -3.662  12.795  1.00  6.07           C  
ATOM    411  C   SER    60       6.259  -3.429  13.583  1.00  6.01           C  
ATOM    412  O   SER    60       5.460  -4.349  13.789  1.00  8.98           O  
ATOM    413  CB  SER    60       7.393  -3.089  11.398  1.00  5.31           C  
ATOM    414  OG  SER    60       6.289  -3.649  10.675  1.00  5.74           O  
ATOM    415  N   ILE    61       6.068  -2.177  13.976  1.00  5.05           N  
ATOM    416  CA  ILE    61       4.824  -1.719  14.572  1.00  5.46           C  
ATOM    417  C   ILE    61       4.122  -0.783  13.606  1.00  5.12           C  
ATOM    418  O   ILE    61       4.739  -0.193  12.726  1.00  5.56           O  
ATOM    419  CB  ILE    61       5.039  -1.052  15.946  1.00  5.64           C  
ATOM    420  CG1 ILE    61       5.807   0.283  15.839  1.00  5.75           C  
ATOM    421  CG2 ILE    61       5.709  -2.048  16.890  1.00  7.78           C  
ATOM    422  CD1 ILE    61       5.872   1.051  17.154  1.00  6.86           C  
ATOM    423  N   ASN    62       2.803  -0.677  13.767  1.00  4.89           N  
ATOM    424  CA  ASN    62       2.000   0.213  12.928  1.00  4.46           C  
ATOM    425  C   ASN    62       1.446   1.326  13.813  1.00  4.77           C  
ATOM    426  O   ASN    62       0.697   1.089  14.746  1.00  5.91           O  
ATOM    427  CB  ASN    62       0.864  -0.577  12.297  1.00  5.06           C  
ATOM    428  CG  ASN    62       0.015   0.234  11.314  1.00  4.91           C  
ATOM    429  OD1 ASN    62      -1.194  -0.010  11.168  1.00  6.38           O  
ATOM    430  ND2 ASN    62       0.628   1.127  10.556  1.00  5.05           N  
ATOM    431  N   VAL    63       1.838   2.569  13.496  1.00  4.55           N  
ATOM    432  CA  VAL    63       1.373   3.747  14.230  1.00  4.66           C  
ATOM    433  C   VAL    63       0.883   4.753  13.178  1.00  4.33           C  
ATOM    434  O   VAL    63       1.630   5.624  12.737  1.00  4.71           O  
ATOM    435  CB  VAL    63       2.446   4.362  15.135  1.00  5.22           C  
ATOM    436  CG1 VAL    63       1.808   5.465  15.979  1.00  5.91           C  
ATOM    437  CG2 VAL    63       3.073   3.283  16.038  1.00  6.23           C  
ATOM    438  N   PRO    64      -0.344   4.573  12.704  1.00  4.83           N  
ATOM    439  CA  PRO    64      -0.790   5.313  11.517  1.00  4.78           C  
ATOM    440  C   PRO    64      -0.709   6.830  11.660  1.00  4.83           C  
ATOM    441  O   PRO    64      -1.275   7.421  12.588  1.00  6.06           O  
ATOM    442  CB  PRO    64      -2.251   4.860  11.361  1.00  5.14           C  
ATOM    443  CG  PRO    64      -2.277   3.459  11.971  1.00  5.58           C  
ATOM    444  CD  PRO    64      -1.339   3.569  13.143  1.00  5.10           C  
ATOM    445  N   TYR    65      -0.076   7.491  10.670  1.00  5.06           N  
ATOM    446  CA  TYR    65       0.092   8.927  10.739  1.00  5.19           C  
ATOM    447  C   TYR    65      -1.185   9.675  10.355  1.00  5.36           C  
ATOM    448  O   TYR    65      -1.579  10.595  11.046  1.00  7.60           O  
ATOM    449  CB  TYR    65       1.281   9.392   9.895  1.00  5.62           C  
ATOM    450  CG  TYR    65       1.492  10.869  10.029  1.00  6.04           C  
ATOM    451  CD1 TYR    65       2.015  11.401  11.191  1.00  7.21           C  
ATOM    452  CD2 TYR    65       1.139  11.743   9.009  1.00  8.62           C  
ATOM    453  CE1 TYR    65       2.153  12.796  11.360  1.00  9.84           C  
ATOM    454  CE2 TYR    65       1.266  13.094   9.180  1.00 11.40           C  
ATOM    455  CZ  TYR    65       1.774  13.607  10.349  1.00 11.36           C  
ATOM    456  OH  TYR    65       1.900  14.974  10.486  1.00 14.93           O  
ATOM    457  N   ARG    66      -1.813   9.271   9.256  1.00  5.70           N  
ATOM    458  CA  ARG    66      -3.018   9.939   8.772  1.00  5.86           C  
ATOM    459  C   ARG    66      -4.132   9.955   9.817  1.00  6.43           C  
ATOM    460  O   ARG    66      -4.778  10.980  10.033  1.00  7.67           O  
ATOM    461  CB  ARG    66      -3.515   9.278   7.485  1.00  7.66           C  
ATOM    462  CG  ARG    66      -2.882   9.831   6.219  1.00  9.54           C  
ATOM    463  CD  ARG    66      -3.332   9.054   4.992  0.80 10.84           C  
ATOM    464  NE  ARG    66      -4.733   9.306   4.668  0.80 12.36           N  
ATOM    465  CZ  ARG    66      -5.181  10.427   4.111  0.80 14.16           C  
ATOM    466  NH1 ARG    66      -4.337  11.405   3.812  0.80 15.06           N  
ATOM    467  NH2 ARG    66      -6.474  10.570   3.851  0.80 13.94           N  
ATOM    468  N   SER    67      -4.354   8.812  10.457  1.00  5.24           N  
ATOM    469  CA  SER    67      -5.410   8.673  11.435  1.00  6.08           C  
ATOM    470  C   SER    67      -4.985   8.938  12.877  1.00  5.88           C  
ATOM    471  O   SER    67      -5.865   9.124  13.718  1.00  7.16           O  
ATOM    472  CB  SER    67      -6.131   7.357  11.271  1.00  7.36           C  
ATOM    473  OG  SER    67      -5.238   6.289  11.344  1.00  7.49           O  
ATOM    474  N   HIS    68      -3.683   9.001  13.146  1.00  5.81           N  
ATOM    475  CA  HIS    68      -3.166   9.301  14.470  1.00  5.91           C  
ATOM    476  C   HIS    68      -1.916  10.180  14.349  1.00  6.23           C  
ATOM    477  O   HIS    68      -0.826   9.782  14.789  1.00  6.38           O  
ATOM    478  CB  HIS    68      -2.854   8.020  15.266  1.00  6.58           C  
ATOM    479  CG  HIS    68      -4.033   7.179  15.481  1.00  7.46           C  
ATOM    480  ND1 HIS    68      -4.919   7.414  16.510  1.00  9.92           N  
ATOM    481  CD2 HIS    68      -4.511   6.113  14.809  1.00  9.74           C  
ATOM    482  CE1 HIS    68      -5.871   6.505  16.481  1.00 11.96           C  
ATOM    483  NE2 HIS    68      -5.663   5.721  15.446  1.00 12.70           N  
ATOM    484  N   PRO    69      -2.026  11.385  13.790  1.00  6.13           N  
ATOM    485  CA  PRO    69      -0.813  12.188  13.545  1.00  7.07           C  
ATOM    486  C   PRO    69      -0.095  12.626  14.799  1.00  7.79           C  
ATOM    487  O   PRO    69       1.109  12.919  14.777  1.00  8.93           O  
ATOM    488  CB  PRO    69      -1.340  13.372  12.727  1.00  8.41           C  
ATOM    489  CG  PRO    69      -2.792  13.472  13.133  1.00  8.62           C  
ATOM    490  CD  PRO    69      -3.242  12.017  13.256  1.00  6.77           C  
ATOM    491  N   ASP    70      -0.849  12.745  15.889  1.00  7.90           N  
ATOM    492  CA  ASP    70      -0.346  13.087  17.215  1.00  8.22           C  
ATOM    493  C   ASP    70       0.132  11.927  18.035  1.00  7.09           C  
ATOM    494  O   ASP    70       0.483  12.131  19.181  1.00  7.91           O  
ATOM    495  CB  ASP    70      -1.478  13.778  18.044  1.00 10.32           C  
ATOM    496  CG  ASP    70      -2.756  12.887  18.175  1.00 12.66           C  
ATOM    497  OD1 ASP    70      -3.048  11.961  17.282  1.00 14.07           O  
ATOM    498  OD2 ASP    70      -3.526  13.205  19.139  1.00 16.93           O  
ATOM    499  N   ALA    71       0.154  10.710  17.485  1.00  6.89           N  
ATOM    500  CA  ALA    71       0.447   9.557  18.291  1.00  6.32           C  
ATOM    501  C   ALA    71       1.741   9.730  19.085  1.00  6.32           C  
ATOM    502  O   ALA    71       1.769   9.444  20.275  1.00  7.16           O  
ATOM    503  CB  ALA    71       0.578   8.305  17.425  1.00  6.74           C  
ATOM    504  N   PHE    72       2.802  10.196  18.434  1.00  6.20           N  
ATOM    505  CA  PHE    72       4.073  10.262  19.117  1.00  7.02           C  
ATOM    506  C   PHE    72       4.212  11.418  20.090  1.00  7.74           C  
ATOM    507  O   PHE    72       5.256  11.532  20.740  1.00 10.61           O  
ATOM    508  CB  PHE    72       5.243  10.170  18.140  1.00  7.43           C  
ATOM    509  CG  PHE    72       5.489   8.744  17.714  1.00  6.23           C  
ATOM    510  CD1 PHE    72       6.156   7.881  18.577  1.00  7.50           C  
ATOM    511  CD2 PHE    72       4.989   8.235  16.536  1.00  6.47           C  
ATOM    512  CE1 PHE    72       6.307   6.551  18.286  1.00  8.63           C  
ATOM    513  CE2 PHE    72       5.152   6.905  16.222  1.00  7.11           C  
ATOM    514  CZ  PHE    72       5.818   6.051  17.110  1.00  7.95           C  
ATOM    515  N   ALA    73       3.145  12.208  20.247  1.00  7.31           N  
ATOM    516  CA  ALA    73       3.045  13.231  21.275  1.00  7.83           C  
ATOM    517  C   ALA    73       2.231  12.763  22.470  1.00  8.56           C  
ATOM    518  O   ALA    73       2.118  13.492  23.459  1.00 10.70           O  
ATOM    519  CB  ALA    73       2.427  14.503  20.703  1.00  8.88           C  
ATOM    520  N   LEU    74       1.663  11.562  22.436  1.00  8.50           N  
ATOM    521  CA  LEU    74       0.816  11.092  23.525  1.00  8.80           C  
ATOM    522  C   LEU    74       1.620  10.491  24.656  1.00  9.91           C  
ATOM    523  O   LEU    74       2.640   9.858  24.443  1.00 10.83           O  
ATOM    524  CB  LEU    74      -0.150  10.018  22.995  1.00  8.41           C  
ATOM    525  CG  LEU    74      -1.070  10.473  21.874  1.00  8.90           C  
ATOM    526  CD1 LEU    74      -1.903   9.312  21.360  1.00  9.06           C  
ATOM    527  CD2 LEU    74      -1.951  11.640  22.293  1.00 11.36           C  
ATOM    528  N   ASP    75       1.115  10.654  25.867  1.00 11.38           N  
ATOM    529  CA  ASP    75       1.714   9.953  27.007  1.00 12.23           C  
ATOM    530  C   ASP    75       1.473   8.439  26.878  1.00 12.37           C  
ATOM    531  O   ASP    75       0.653   8.004  26.055  1.00 11.95           O  
ATOM    532  CB  ASP    75       1.199  10.509  28.320  1.00 13.44           C  
ATOM    533  CG  ASP    75      -0.207  10.092  28.612  1.00 14.52           C  
ATOM    534  OD1 ASP    75      -0.532   8.884  28.631  1.00 16.72           O  
ATOM    535  OD2 ASP    75      -1.035  10.981  28.899  1.00 19.77           O  
ATOM    536  N   PRO    76       2.218   7.611  27.630  1.00 12.93           N  
ATOM    537  CA  PRO    76       2.115   6.172  27.427  1.00 12.29           C  
ATOM    538  C   PRO    76       0.723   5.586  27.570  1.00 11.45           C  
ATOM    539  O   PRO    76       0.365   4.743  26.799  1.00 11.34           O  
ATOM    540  CB  PRO    76       3.095   5.570  28.451  1.00 14.68           C  
ATOM    541  CG  PRO    76       4.083   6.674  28.688  1.00 16.39           C  
ATOM    542  CD  PRO    76       3.253   7.942  28.619  1.00 14.93           C  
ATOM    543  N   LEU    77      -0.045   6.002  28.562  1.00 10.97           N  
ATOM    544  CA  LEU    77      -1.364   5.431  28.769  0.50 10.50           C  
ATOM    546  C   LEU    77      -2.304   5.801  27.614  1.00  9.42           C  
ATOM    547  O   LEU    77      -3.022   4.952  27.069  1.00 10.45           O  
ATOM    548  CB  LEU    77      -1.905   5.875  30.124  0.50 10.23           C  
ATOM    550  CG  LEU    77      -3.269   5.313  30.499  0.50 10.33           C  
ATOM    552  CD1 LEU    77      -3.195   3.841  30.874  0.50 14.10           C  
ATOM    554  CD2 LEU    77      -3.853   6.131  31.674  0.50 11.65           C  
ATOM    556  N   GLU    78      -2.276   7.058  27.222  1.00  9.30           N  
ATOM    557  CA  GLU    78      -3.131   7.528  26.153  1.00  8.89           C  
ATOM    558  C   GLU    78      -2.703   6.953  24.798  1.00  7.55           C  
ATOM    559  O   GLU    78      -3.558   6.630  23.968  1.00  8.67           O  
ATOM    560  CB  GLU    78      -3.136   9.070  26.108  1.00  9.48           C  
ATOM    561  CG  GLU    78      -4.079   9.689  25.083  1.00  9.79           C  
ATOM    562  CD  GLU    78      -5.572   9.520  25.386  1.00 10.38           C  
ATOM    563  OE1 GLU    78      -5.933   8.992  26.458  1.00 11.33           O  
ATOM    564  OE2 GLU    78      -6.367   9.941  24.556  1.00 13.54           O  
ATOM    565  N   PHE    79      -1.391   6.776  24.603  1.00  7.74           N  
ATOM    566  CA  PHE    79      -0.913   6.141  23.386  1.00  7.31           C  
ATOM    567  C   PHE    79      -1.551   4.750  23.236  1.00  7.50           C  
ATOM    568  O   PHE    79      -2.054   4.388  22.179  1.00  7.68           O  
ATOM    569  CB  PHE    79       0.607   6.044  23.434  1.00  7.67           C  
ATOM    570  CG  PHE    79       1.240   5.532  22.145  1.00  7.10           C  
ATOM    571  CD1 PHE    79       1.872   6.387  21.292  1.00  7.29           C  
ATOM    572  CD2 PHE    79       1.204   4.181  21.839  1.00  6.60           C  
ATOM    573  CE1 PHE    79       2.464   5.922  20.117  1.00  7.50           C  
ATOM    574  CE2 PHE    79       1.787   3.721  20.654  1.00  7.36           C  
ATOM    575  CZ  PHE    79       2.419   4.600  19.803  1.00  6.66           C  
ATOM    576  N   GLU    80      -1.492   3.937  24.285  0.90  8.14           N  
ATOM    578  CA  GLU    80      -2.037   2.611  24.153  0.90  8.94           C  
ATOM    580  C   GLU    80      -3.550   2.654  23.958  0.90  8.49           C  
ATOM    582  O   GLU    80      -4.090   1.869  23.167  0.90  9.26           O  
ATOM    584  CB  GLU    80      -1.626   1.736  25.323  0.90 10.94           C  
ATOM    586  CG  GLU    80      -1.923   0.274  25.125  0.90 12.87           C  
ATOM    588  CD  GLU    80      -3.316  -0.153  25.486  0.90 14.79           C  
ATOM    590  OE1 GLU    80      -4.032   0.611  26.163  0.90 15.76           O  
ATOM    592  OE2 GLU    80      -3.714  -1.266  25.086  0.90 19.69           O  
ATOM    594  N   LYS    81      -4.261   3.592  24.590  1.00  8.78           N  
ATOM    595  CA  LYS    81      -5.687   3.674  24.333  0.50  9.31           C  
ATOM    597  C   LYS    81      -5.995   4.025  22.884  1.00  8.87           C  
ATOM    598  O   LYS    81      -6.964   3.487  22.310  1.00 10.43           O  
ATOM    599  CB  LYS    81      -6.329   4.673  25.282  0.50  9.93           C  
ATOM    601  CG  LYS    81      -6.331   4.204  26.709  0.50 10.96           C  
ATOM    603  CD  LYS    81      -6.819   5.341  27.592  0.50 10.36           C  
ATOM    605  CE  LYS    81      -6.945   4.955  29.026  0.50 12.69           C  
ATOM    607  NZ  LYS    81      -7.100   6.159  29.871  0.50 14.18           N  
ATOM    609  N   GLN    82      -5.227   4.943  22.298  1.00  8.48           N  
ATOM    610  CA  GLN    82      -5.507   5.384  20.963  1.00  9.68           C  
ATOM    611  C   GLN    82      -5.016   4.414  19.894  1.00  9.17           C  
ATOM    612  O   GLN    82      -5.688   4.225  18.883  1.00 11.34           O  
ATOM    613  CB  GLN    82      -4.922   6.776  20.759  1.00  9.86           C  
ATOM    614  CG  GLN    82      -5.607   7.856  21.696  1.00 12.49           C  
ATOM    615  CD  GLN    82      -7.154   8.042  21.566  1.00 12.54           C  
ATOM    616  OE1 GLN    82      -7.666   7.875  20.483  1.00 15.24           O  
ATOM    617  NE2 GLN    82      -7.876   8.429  22.678  1.00 13.84           N  
ATOM    618  N   ILE    83      -3.822   3.860  20.083  1.00  8.72           N  
ATOM    619  CA  ILE    83      -3.164   3.062  19.059  1.00  9.26           C  
ATOM    620  C   ILE    83      -3.360   1.578  19.272  1.00  9.94           C  
ATOM    621  O   ILE    83      -3.348   0.837  18.311  1.00 13.92           O  
ATOM    622  CB  ILE    83      -1.645   3.402  19.021  1.00  9.41           C  
ATOM    623  CG1 ILE    83      -1.436   4.907  18.950  1.00  9.94           C  
ATOM    624  CG2 ILE    83      -0.943   2.713  17.844  1.00 11.05           C  
ATOM    625  CD1 ILE    83      -2.063   5.618  17.779  1.00 12.33           C  
ATOM    626  N   GLY    84      -3.539   1.147  20.507  1.00  9.29           N  
ATOM    627  CA  GLY    84      -3.753  -0.257  20.814  1.00  9.83           C  
ATOM    628  C   GLY    84      -2.526  -1.096  21.078  1.00  8.85           C  
ATOM    629  O   GLY    84      -2.663  -2.302  21.251  1.00 11.00           O  
ATOM    630  N   ILE    85      -1.352  -0.462  21.076  1.00  8.30           N  
ATOM    631  CA  ILE    85      -0.096  -1.089  21.387  1.00  8.21           C  
ATOM    632  C   ILE    85       0.649  -0.160  22.333  1.00  7.46           C  
ATOM    633  O   ILE    85       0.338   1.017  22.432  1.00  8.38           O  
ATOM    634  CB  ILE    85       0.740  -1.363  20.121  1.00  8.29           C  
ATOM    635  CG1 ILE    85       1.120  -0.054  19.416  1.00  9.73           C  
ATOM    636  CG2 ILE    85      -0.003  -2.340  19.247  1.00 10.74           C  
ATOM    637  CD1 ILE    85       2.112  -0.267  18.259  1.00  9.86           C  
ATOM    638  N   PRO    86       1.667  -0.664  23.035  1.00  8.01           N  
ATOM    639  CA  PRO    86       2.420   0.178  23.961  1.00  8.48           C  
ATOM    640  C   PRO    86       3.224   1.241  23.235  1.00  7.80           C  
ATOM    641  O   PRO    86       3.724   1.044  22.119  1.00  8.34           O  
ATOM    642  CB  PRO    86       3.371  -0.806  24.686  1.00  9.49           C  
ATOM    643  CG  PRO    86       2.688  -2.111  24.531  1.00 10.38           C  
ATOM    644  CD  PRO    86       2.083  -2.063  23.155  1.00  9.31           C  
ATOM    645  N   LYS    87       3.379   2.362  23.912  1.00  7.88           N  
ATOM    646  CA  LYS    87       4.205   3.432  23.386  0.80  7.54           C  
ATOM    648  C   LYS    87       5.662   2.981  23.347  1.00  7.42           C  
ATOM    649  O   LYS    87       6.183   2.482  24.333  1.00  9.42           O  
ATOM    650  CB  LYS    87       4.082   4.659  24.274  0.80  8.13           C  
ATOM    652  CG  LYS    87       4.787   5.864  23.700  0.80  8.63           C  
ATOM    654  CD  LYS    87       4.604   7.123  24.546  0.80  9.77           C  
ATOM    656  CE  LYS    87       5.343   8.336  23.983  0.80 10.65           C  
ATOM    658  NZ  LYS    87       5.318   9.490  24.914  0.80 11.03           N  
ATOM    660  N   PRO    88       6.331   3.144  22.204  1.00  7.30           N  
ATOM    661  CA  PRO    88       7.716   2.702  22.136  1.00  7.45           C  
ATOM    662  C   PRO    88       8.601   3.365  23.170  1.00  7.42           C  
ATOM    663  O   PRO    88       8.466   4.563  23.469  1.00  7.76           O  
ATOM    664  CB  PRO    88       8.143   3.094  20.709  1.00  7.68           C  
ATOM    665  CG  PRO    88       6.881   3.004  19.944  1.00  7.88           C  
ATOM    666  CD  PRO    88       5.839   3.552  20.883  1.00  7.34           C  
ATOM    667  N   ASP    89       9.566   2.605  23.642  1.00  7.78           N  
ATOM    668  CA  ASP    89      10.569   3.092  24.598  1.00  8.01           C  
ATOM    669  C   ASP    89      11.435   4.166  23.945  1.00  8.28           C  
ATOM    670  O   ASP    89      12.072   3.906  22.923  1.00  8.32           O  
ATOM    671  CB  ASP    89      11.394   1.859  24.977  1.00  8.92           C  
ATOM    672  CG  ASP    89      12.533   2.113  25.924  1.00 10.72           C  
ATOM    673  OD1 ASP    89      12.864   3.262  26.257  1.00 11.95           O  
ATOM    674  OD2 ASP    89      13.097   1.085  26.356  1.00 14.30           O  
ATOM    675  N   SER    90      11.500   5.358  24.568  1.00  9.48           N  
ATOM    676  CA  SER    90      12.265   6.445  23.983  1.00 10.63           C  
ATOM    677  C   SER    90      13.765   6.240  23.999  1.00  9.42           C  
ATOM    678  O   SER    90      14.475   6.999  23.351  1.00 11.63           O  
ATOM    679  CB  SER    90      11.887   7.770  24.542  1.00 12.89           C  
ATOM    680  OG  SER    90      12.243   7.774  25.888  1.00 16.17           O  
ATOM    681  N   ALA    91      14.256   5.246  24.718  1.00  8.51           N  
ATOM    682  CA  ALA    91      15.673   4.933  24.711  1.00  9.11           C  
ATOM    683  C   ALA    91      16.074   4.196  23.446  1.00  9.07           C  
ATOM    684  O   ALA    91      17.265   4.072  23.186  1.00 11.24           O  
ATOM    685  CB  ALA    91      16.038   4.059  25.935  1.00 11.22           C  
ATOM    686  N   LYS    92      15.119   3.662  22.690  1.00  7.03           N  
ATOM    687  CA  LYS    92      15.414   2.895  21.501  0.80  6.87           C  
ATOM    689  C   LYS    92      15.581   3.804  20.298  1.00  6.20           C  
ATOM    690  O   LYS    92      15.169   4.952  20.297  1.00  7.57           O  
ATOM    691  CB  LYS    92      14.282   1.913  21.255  0.80  6.68           C  
ATOM    693  CG  LYS    92      14.211   0.818  22.325  0.80  7.06           C  
ATOM    695  CD  LYS    92      13.161  -0.217  21.984  0.80  8.08           C  
ATOM    697  CE  LYS    92      12.977  -1.320  23.013  0.80  8.53           C  
ATOM    699  NZ  LYS    92      11.985  -2.316  22.548  0.80 11.35           N  
ATOM    701  N   GLU    93      16.183   3.243  19.247  1.00  5.90           N  
ATOM    702  CA  GLU    93      16.205   3.883  17.943  1.00  5.79           C  
ATOM    703  C   GLU    93      14.889   3.566  17.219  1.00  5.43           C  
ATOM    704  O   GLU    93      14.588   2.397  16.996  1.00  7.19           O  
ATOM    705  CB  GLU    93      17.352   3.361  17.083  1.00  6.18           C  
ATOM    706  CG  GLU    93      17.389   3.990  15.724  1.00  6.50           C  
ATOM    707  CD  GLU    93      18.444   3.443  14.778  1.00  6.24           C  
ATOM    708  OE1 GLU    93      19.138   2.477  15.111  1.00  9.44           O  
ATOM    709  OE2 GLU    93      18.548   3.999  13.660  1.00  8.01           O  
ATOM    710  N   LEU    94      14.129   4.590  16.868  1.00  5.30           N  
ATOM    711  CA  LEU    94      12.891   4.411  16.116  1.00  4.81           C  
ATOM    712  C   LEU    94      13.163   4.809  14.664  1.00  4.73           C  
ATOM    713  O   LEU    94      13.650   5.920  14.412  1.00  5.65           O  
ATOM    714  CB  LEU    94      11.770   5.294  16.661  1.00  5.24           C  
ATOM    715  CG  LEU    94      10.963   4.701  17.820  1.00  5.62           C  
ATOM    716  CD1 LEU    94      11.836   4.382  19.069  1.00  7.25           C  
ATOM    717  CD2 LEU    94       9.819   5.638  18.164  1.00  6.54           C  
ATOM    718  N   ILE    95      12.858   3.911  13.738  1.00  4.22           N  
ATOM    719  CA  ILE    95      13.091   4.118  12.314  1.00  4.07           C  
ATOM    720  C   ILE    95      11.732   4.295  11.644  1.00  3.87           C  
ATOM    721  O   ILE    95      10.928   3.375  11.649  1.00  4.97           O  
ATOM    722  CB  ILE    95      13.833   2.949  11.678  1.00  4.36           C  
ATOM    723  CG1 ILE    95      15.110   2.625  12.432  1.00  5.35           C  
ATOM    724  CG2 ILE    95      14.112   3.267  10.202  1.00  5.16           C  
ATOM    725  CD1 ILE    95      15.873   1.393  11.877  1.00  6.26           C  
ATOM    726  N   PHE    96      11.484   5.473  11.080  1.00  4.13           N  
ATOM    727  CA  PHE    96      10.177   5.827  10.575  1.00  4.04           C  
ATOM    728  C   PHE    96      10.083   5.688   9.061  1.00  4.15           C  
ATOM    729  O   PHE    96      11.003   6.076   8.322  1.00  4.70           O  
ATOM    730  CB  PHE    96       9.885   7.294  10.893  1.00  4.72           C  
ATOM    731  CG  PHE    96       9.654   7.529  12.339  1.00  5.07           C  
ATOM    732  CD1 PHE    96       8.369   7.496  12.872  1.00  6.51           C  
ATOM    733  CD2 PHE    96      10.724   7.742  13.206  1.00  5.56           C  
ATOM    734  CE1 PHE    96       8.177   7.695  14.230  1.00  7.88           C  
ATOM    735  CE2 PHE    96      10.517   7.917  14.571  1.00  6.93           C  
ATOM    736  CZ  PHE    96       9.247   7.863  15.061  1.00  7.62           C  
ATOM    737  N   TYR    97       8.931   5.210   8.592  1.00  3.99           N  
ATOM    738  CA  TYR    97       8.671   5.113   7.146  1.00  3.91           C  
ATOM    739  C   TYR    97       7.169   4.947   6.933  1.00  3.74           C  
ATOM    740  O   TYR    97       6.413   4.602   7.837  1.00  3.98           O  
ATOM    741  CB  TYR    97       9.448   3.952   6.517  1.00  4.23           C  
ATOM    742  CG  TYR    97       9.224   2.625   7.182  1.00  4.19           C  
ATOM    743  CD1 TYR    97       8.214   1.771   6.749  1.00  4.31           C  
ATOM    744  CD2 TYR    97      10.004   2.192   8.242  1.00  4.31           C  
ATOM    745  CE1 TYR    97       7.995   0.562   7.342  1.00  4.59           C  
ATOM    746  CE2 TYR    97       9.792   0.986   8.870  1.00  4.85           C  
ATOM    747  CZ  TYR    97       8.791   0.143   8.414  1.00  4.56           C  
ATOM    748  OH  TYR    97       8.607  -1.063   9.024  1.00  5.52           O  
ATOM    749  N   CYS    98       6.783   5.140   5.676  1.00  3.72           N  
ATOM    750  CA  CYS    98       5.397   4.924   5.250  1.00  3.59           C  
ATOM    751  C   CYS    98       5.423   4.123   3.933  1.00  3.45           C  
ATOM    752  O   CYS    98       5.981   3.034   3.901  1.00  3.84           O  
ATOM    753  CB  CYS    98       4.589   6.248   5.230  1.00  4.07           C  
ATOM    754  SG  CYS    98       5.270   7.526   4.165  1.00  4.60           S  
ATOM    755  N   ALA    99       4.783   4.671   2.880  1.00  3.83           N  
ATOM    756  CA  ALA    99       4.796   4.067   1.537  1.00  3.72           C  
ATOM    757  C   ALA    99       5.854   4.781   0.691  1.00  3.81           C  
ATOM    758  O   ALA    99       6.824   4.156   0.284  1.00  4.15           O  
ATOM    759  CB  ALA    99       3.424   4.128   0.902  1.00  5.74           C  
ATOM    760  N   SER   100       5.676   6.088   0.457  1.00  4.26           N  
ATOM    761  CA  SER   100       6.620   6.835  -0.338  1.00  4.84           C  
ATOM    762  C   SER   100       7.540   7.758   0.462  1.00  4.52           C  
ATOM    763  O   SER   100       8.467   8.328  -0.107  1.00  5.77           O  
ATOM    764  CB  SER   100       5.938   7.644  -1.446  1.00  6.55           C  
ATOM    765  OG  SER   100       5.015   8.529  -0.959  1.00  8.80           O  
ATOM    766  N   GLY   101       7.314   7.906   1.771  1.00  4.88           N  
ATOM    767  CA  GLY   101       8.192   8.612   2.672  1.00  5.06           C  
ATOM    768  C   GLY   101       7.637   9.843   3.357  1.00  4.71           C  
ATOM    769  O   GLY   101       8.158  10.230   4.392  1.00  5.18           O  
ATOM    770  N   LYS   102       6.632  10.512   2.802  1.00  5.31           N  
ATOM    771  CA  LYS   102       6.226  11.814   3.373  1.00  6.25           C  
ATOM    772  C   LYS   102       5.700  11.667   4.789  1.00  5.42           C  
ATOM    773  O   LYS   102       6.060  12.433   5.699  1.00  6.42           O  
ATOM    774  CB  LYS   102       5.200  12.508   2.515  1.00  8.24           C  
ATOM    775  CG  LYS   102       4.808  13.881   3.067  1.00 10.22           C  
ATOM    776  CD  LYS   102       3.960  14.679   2.127  0.50 10.43           C  
ATOM    777  CE  LYS   102       3.301  15.880   2.790  0.50 13.54           C  
ATOM    778  NZ  LYS   102       2.750  16.816   1.809  0.50 16.32           N  
ATOM    779  N   ARG   103       4.762  10.724   4.983  1.00  4.79           N  
ATOM    780  CA  ARG   103       4.191  10.545   6.297  1.00  4.54           C  
ATOM    781  C   ARG   103       5.241  10.072   7.294  1.00  4.28           C  
ATOM    782  O   ARG   103       5.224  10.482   8.458  1.00  5.11           O  
ATOM    783  CB  ARG   103       3.024   9.571   6.249  1.00  4.67           C  
ATOM    784  CG  ARG   103       1.852  10.087   5.414  1.00  5.46           C  
ATOM    785  CD  ARG   103       0.837   9.001   5.183  1.00  5.48           C  
ATOM    786  NE  ARG   103       1.316   7.999   4.254  1.00  5.57           N  
ATOM    787  CZ  ARG   103       0.726   6.850   3.969  1.00  5.15           C  
ATOM    788  NH1 ARG   103      -0.286   6.420   4.709  1.00  4.82           N  
ATOM    789  NH2 ARG   103       1.152   6.098   2.963  1.00  6.22           N  
ATOM    790  N   GLY   104       6.137   9.177   6.867  1.00  4.65           N  
ATOM    791  CA  GLY   104       7.238   8.775   7.731  1.00  4.55           C  
ATOM    792  C   GLY   104       8.055   9.972   8.228  1.00  4.53           C  
ATOM    793  O   GLY   104       8.400  10.055   9.396  1.00  5.29           O  
ATOM    794  N   GLY   105       8.347  10.892   7.330  1.00  4.88           N  
ATOM    795  CA  GLY   105       9.103  12.061   7.706  1.00  5.31           C  
ATOM    796  C   GLY   105       8.352  12.934   8.699  1.00  5.73           C  
ATOM    797  O   GLY   105       8.940  13.479   9.652  1.00  6.59           O  
ATOM    798  N   GLU   106       7.047  13.085   8.492  1.00  5.79           N  
ATOM    799  CA  GLU   106       6.205  13.877   9.404  0.50  5.78           C  
ATOM    801  C   GLU   106       6.175  13.251  10.786  1.00  6.15           C  
ATOM    802  O   GLU   106       6.249  13.937  11.814  1.00  6.87           O  
ATOM    803  CB  GLU   106       4.765  13.993   8.877  0.50  6.72           C  
ATOM    805  CG  GLU   106       4.634  14.891   7.660  0.50  8.74           C  
ATOM    807  CD  GLU   106       5.250  16.297   7.896  0.50 14.10           C  
ATOM    809  OE1 GLU   106       4.916  16.926   8.912  0.50 16.14           O  
ATOM    811  OE2 GLU   106       6.111  16.740   7.110  0.50 19.81           O  
ATOM    813  N   ALA   107       5.983  11.939  10.825  1.00  5.63           N  
ATOM    814  CA  ALA   107       5.923  11.239  12.109  1.00  5.97           C  
ATOM    815  C   ALA   107       7.241  11.310  12.844  1.00  5.28           C  
ATOM    816  O   ALA   107       7.269  11.486  14.078  1.00  6.07           O  
ATOM    817  CB  ALA   107       5.495   9.790  11.883  1.00  5.83           C  
ATOM    818  N   GLN   108       8.352  11.222  12.129  1.00  5.35           N  
ATOM    819  CA  GLN   108       9.671  11.355  12.746  0.70  5.95           C  
ATOM    821  C   GLN   108       9.785  12.708  13.434  1.00  6.34           C  
ATOM    822  O   GLN   108      10.346  12.803  14.531  1.00  7.57           O  
ATOM    823  CB  GLN   108      10.782  11.166  11.705  0.70  5.79           C  
ATOM    825  CG  GLN   108      12.180  11.200  12.277  0.70  6.62           C  
ATOM    827  CD  GLN   108      12.804  12.599  12.514  0.70  7.05           C  
ATOM    829  OE1 GLN   108      13.714  12.746  13.386  0.70  9.86           O  
ATOM    831  NE2 GLN   108      12.353  13.592  11.818  0.70  6.57           N  
ATOM    833  N   LYS   109       9.268  13.749  12.815  1.00  6.66           N  
ATOM    834  CA  LYS   109       9.332  15.086  13.406  1.00  7.47           C  
ATOM    835  C   LYS   109       8.516  15.163  14.677  1.00  6.95           C  
ATOM    836  O   LYS   109       8.923  15.820  15.652  1.00  8.43           O  
ATOM    837  CB  LYS   109       8.865  16.128  12.410  1.00  8.40           C  
ATOM    838  CG  LYS   109       9.899  16.414  11.334  1.00 11.98           C  
ATOM    839  CD  LYS   109       9.420  17.302  10.199  1.00 13.99           C  
ATOM    840  CE  LYS   109      10.580  17.684   9.279  0.80 14.86           C  
ATOM    841  NZ  LYS   109      10.223  18.249   7.939  0.80 18.08           N  
ATOM    842  N   VAL   110       7.334  14.526  14.696  1.00  6.46           N  
ATOM    843  CA  VAL   110       6.543  14.498  15.923  1.00  7.30           C  
ATOM    844  C   VAL   110       7.335  13.809  17.030  1.00  6.59           C  
ATOM    845  O   VAL   110       7.450  14.315  18.141  1.00  7.66           O  
ATOM    846  CB  VAL   110       5.179  13.805  15.707  1.00  6.81           C  
ATOM    847  CG1 VAL   110       4.413  13.739  17.034  1.00  7.86           C  
ATOM    848  CG2 VAL   110       4.360  14.519  14.638  1.00  8.53           C  
ATOM    849  N   ALA   111       7.878  12.634  16.736  1.00  6.25           N  
ATOM    850  CA  ALA   111       8.587  11.898  17.775  1.00  6.44           C  
ATOM    851  C   ALA   111       9.813  12.662  18.294  1.00  6.55           C  
ATOM    852  O   ALA   111      10.037  12.764  19.497  1.00  7.23           O  
ATOM    853  CB  ALA   111       9.000  10.502  17.233  1.00  6.91           C  
ATOM    854  N   SER   112      10.597  13.198  17.371  1.00  6.91           N  
ATOM    855  CA  SER   112      11.838  13.856  17.755  0.50  7.97           C  
ATOM    857  C   SER   112      11.569  15.119  18.578  1.00  8.71           C  
ATOM    858  O   SER   112      12.402  15.486  19.385  1.00 11.07           O  
ATOM    859  CB  SER   112      12.717  14.152  16.530  0.50  8.49           C  
ATOM    861  OG  SER   112      12.096  15.095  15.671  0.50  9.64           O  
ATOM    863  N   SER   113      10.403  15.745  18.391  1.00  8.30           N  
ATOM    864  CA  SER   113       9.935  16.916  19.134  0.50  9.12           C  
ATOM    866  C   SER   113       9.259  16.563  20.456  1.00  8.56           C  
ATOM    867  O   SER   113       8.882  17.467  21.204  1.00  9.94           O  
ATOM    868  CB  SER   113       8.898  17.677  18.288  0.50 10.45           C  
ATOM    870  OG  SER   113       9.490  18.283  17.156  0.50 15.37           O  
ATOM    872  N   HIS   114       9.023  15.281  20.705  1.00  7.79           N  
ATOM    873  CA  HIS   114       8.324  14.809  21.885  1.00  7.83           C  
ATOM    874  C   HIS   114       9.069  13.713  22.609  1.00  8.28           C  
ATOM    875  O   HIS   114       8.496  12.745  23.090  1.00  9.87           O  
ATOM    876  CB  HIS   114       6.869  14.400  21.562  1.00  8.35           C  
ATOM    877  CG  HIS   114       6.066  15.538  21.049  1.00  8.39           C  
ATOM    878  ND1 HIS   114       5.234  16.370  21.762  1.00 12.03           N  
ATOM    879  CD2 HIS   114       6.042  15.973  19.773  1.00  7.75           C  
ATOM    880  CE1 HIS   114       4.721  17.262  20.921  1.00 10.24           C  
ATOM    881  NE2 HIS   114       5.197  17.037  19.714  1.00 13.52           N  
ATOM    882  N   GLY   115      10.379  13.904  22.750  1.00  8.04           N  
ATOM    883  CA  GLY   115      11.136  13.101  23.678  1.00  8.92           C  
ATOM    884  C   GLY   115      11.885  11.910  23.143  1.00  8.53           C  
ATOM    885  O   GLY   115      12.534  11.202  23.936  1.00 10.87           O  
ATOM    886  N   TYR   116      11.865  11.699  21.818  1.00  7.42           N  
ATOM    887  CA  TYR   116      12.617  10.613  21.237  1.00  7.88           C  
ATOM    888  C   TYR   116      13.886  11.204  20.645  1.00  8.36           C  
ATOM    889  O   TYR   116      13.867  11.829  19.596  1.00  9.94           O  
ATOM    890  CB  TYR   116      11.822   9.904  20.128  1.00  7.27           C  
ATOM    891  CG  TYR   116      10.689   9.086  20.672  1.00  7.06           C  
ATOM    892  CD1 TYR   116      10.880   7.750  20.961  1.00  7.23           C  
ATOM    893  CD2 TYR   116       9.420   9.641  20.909  1.00  7.09           C  
ATOM    894  CE1 TYR   116       9.852   6.944  21.464  1.00  7.42           C  
ATOM    895  CE2 TYR   116       8.399   8.858  21.410  1.00  7.13           C  
ATOM    896  CZ  TYR   116       8.609   7.514  21.683  1.00  7.28           C  
ATOM    897  OH  TYR   116       7.548   6.756  22.143  1.00  8.85           O  
ATOM    898  N   SER   117      15.012  10.963  21.308  1.00  9.24           N  
ATOM    899  CA  SER   117      16.310  11.508  20.932  0.50  9.26           C  
ATOM    901  C   SER   117      17.024  10.669  19.883  1.00  9.18           C  
ATOM    902  O   SER   117      18.034  11.122  19.359  1.00 10.73           O  
ATOM    903  CB  SER   117      17.222  11.640  22.154  0.50 10.04           C  
ATOM    905  OG  SER   117      17.610  10.398  22.671  0.50 12.56           O  
ATOM    907  N   ASN   118      16.547   9.429  19.632  1.00  7.59           N  
ATOM    908  CA  ASN   118      17.230   8.515  18.705  1.00  7.19           C  
ATOM    909  C   ASN   118      16.214   8.080  17.660  1.00  6.53           C  
ATOM    910  O   ASN   118      15.453   7.130  17.866  1.00  7.15           O  
ATOM    911  CB  ASN   118      17.828   7.313  19.399  1.00  8.35           C  
ATOM    912  CG  ASN   118      18.776   6.576  18.487  1.00  9.59           C  
ATOM    913  OD1 ASN   118      18.841   6.865  17.290  1.00 12.34           O  
ATOM    914  ND2 ASN   118      19.470   5.588  18.999  1.00 12.25           N  
ATOM    915  N   THR   119      16.127   8.854  16.591  1.00  6.94           N  
ATOM    916  CA  THR   119      15.179   8.577  15.541  1.00  6.53           C  
ATOM    917  C   THR   119      15.901   8.628  14.190  1.00  6.38           C  
ATOM    918  O   THR   119      16.911   9.327  14.010  1.00  7.96           O  
ATOM    919  CB  THR   119      14.000   9.574  15.490  1.00  7.22           C  
ATOM    920  OG1 THR   119      14.473  10.889  15.205  1.00  9.42           O  
ATOM    921  CG2 THR   119      13.226   9.594  16.807  1.00  8.55           C  
ATOM    922  N   SER   120      15.368   7.863  13.253  1.00  5.51           N  
ATOM    923  CA  SER   120      15.944   7.677  11.949  1.00  5.29           C  
ATOM    924  C   SER   120      14.853   7.551  10.920  1.00  4.26           C  
ATOM    925  O   SER   120      13.678   7.376  11.252  1.00  4.97           O  
ATOM    926  CB  SER   120      16.805   6.411  11.921  1.00  6.20           C  
ATOM    927  OG  SER   120      17.765   6.453  12.944  1.00  7.62           O  
ATOM    928  N   LEU   121      15.250   7.606   9.645  1.00  4.46           N  
ATOM    929  CA  LEU   121      14.317   7.455   8.521  0.80  4.26           C  
ATOM    931  C   LEU   121      14.733   6.291   7.643  1.00  4.09           C  
ATOM    932  O   LEU   121      15.920   6.048   7.412  1.00  5.18           O  
ATOM    933  CB  LEU   121      14.326   8.671   7.606  0.80  5.48           C  
ATOM    935  CG  LEU   121      13.854   9.969   8.202  0.80  5.51           C  
ATOM    937  CD1 LEU   121      14.135  11.139   7.266  0.80  8.67           C  
ATOM    939  CD2 LEU   121      12.370   9.905   8.512  0.80  6.72           C  
ATOM    941  N   TYR   122      13.726   5.629   7.100  1.00  3.94           N  
ATOM    942  CA  TYR   122      13.872   4.763   5.921  1.00  3.85           C  
ATOM    943  C   TYR   122      13.156   5.523   4.806  1.00  3.66           C  
ATOM    944  O   TYR   122      11.966   5.342   4.588  1.00  4.17           O  
ATOM    945  CB  TYR   122      13.247   3.394   6.157  1.00  3.95           C  
ATOM    946  CG  TYR   122      13.202   2.471   4.976  1.00  3.68           C  
ATOM    947  CD1 TYR   122      12.279   1.443   4.940  1.00  4.04           C  
ATOM    948  CD2 TYR   122      14.062   2.599   3.885  1.00  4.06           C  
ATOM    949  CE1 TYR   122      12.268   0.524   3.918  1.00  4.09           C  
ATOM    950  CE2 TYR   122      14.050   1.692   2.831  1.00  3.91           C  
ATOM    951  CZ  TYR   122      13.129   0.649   2.841  1.00  4.07           C  
ATOM    952  OH  TYR   122      13.077  -0.285   1.855  1.00  4.47           O  
ATOM    953  N   PRO   123      13.849   6.463   4.142  1.00  4.14           N  
ATOM    954  CA  PRO   123      13.138   7.375   3.237  1.00  4.65           C  
ATOM    955  C   PRO   123      12.396   6.651   2.119  1.00  4.10           C  
ATOM    956  O   PRO   123      11.326   7.076   1.718  1.00  5.12           O  
ATOM    957  CB  PRO   123      14.255   8.307   2.719  1.00  6.56           C  
ATOM    958  CG  PRO   123      15.395   7.915   3.287  1.00 10.08           C  
ATOM    959  CD  PRO   123      15.273   6.827   4.251  1.00  4.12           C  
ATOM    960  N   GLY   124      13.015   5.604   1.575  1.00  4.01           N  
ATOM    961  CA  GLY   124      12.403   4.887   0.494  1.00  4.35           C  
ATOM    962  C   GLY   124      11.110   4.194   0.879  1.00  3.60           C  
ATOM    963  O   GLY   124      10.226   3.980   0.046  1.00  3.88           O  
ATOM    964  N   SER   125      11.007   3.833   2.160  1.00  3.30           N  
ATOM    965  CA  SER   125       9.769   3.381   2.742  1.00  3.33           C  
ATOM    966  C   SER   125       9.300   2.067   2.099  1.00  3.27           C  
ATOM    967  O   SER   125      10.076   1.348   1.484  1.00  3.48           O  
ATOM    968  CB  SER   125       8.736   4.510   2.729  1.00  4.01           C  
ATOM    969  OG  SER   125       9.097   5.537   3.667  1.00  4.43           O  
ATOM    970  N   MET   126       8.020   1.709   2.316  1.00  3.33           N  
ATOM    971  CA  MET   126       7.588   0.395   1.839  0.80  3.44           C  
ATOM    973  C   MET   126       7.575   0.294   0.330  1.00  3.61           C  
ATOM    974  O   MET   126       7.699  -0.811  -0.213  1.00  4.24           O  
ATOM    975  CB  MET   126       6.249   0.002   2.467  0.80  4.02           C  
ATOM    977  CG  MET   126       6.343  -0.301   3.941  0.80  4.27           C  
ATOM    979  SD  MET   126       7.499  -1.795   4.379  0.80  5.51          SE  
ATOM    981  CE  MET   126       6.491  -3.168   3.482  0.80  6.80           C  
ATOM    983  N   ASN   127       7.471   1.417  -0.400  1.00  3.55           N  
ATOM    984  CA  ASN   127       7.586   1.335  -1.845  1.00  3.71           C  
ATOM    985  C   ASN   127       8.975   0.824  -2.210  1.00  3.64           C  
ATOM    986  O   ASN   127       9.127  -0.021  -3.093  1.00  4.42           O  
ATOM    987  CB  ASN   127       7.349   2.703  -2.504  1.00  4.44           C  
ATOM    988  CG  ASN   127       5.915   3.143  -2.465  1.00  4.85           C  
ATOM    989  OD1 ASN   127       5.029   2.508  -1.890  1.00  5.85           O  
ATOM    990  ND2 ASN   127       5.677   4.330  -3.077  1.00  6.65           N  
ATOM    991  N   ASP   128       9.999   1.360  -1.545  1.00  3.44           N  
ATOM    992  CA  ASP   128      11.362   0.913  -1.764  1.00  3.90           C  
ATOM    993  C   ASP   128      11.535  -0.552  -1.367  1.00  3.51           C  
ATOM    994  O   ASP   128      12.152  -1.352  -2.094  1.00  4.13           O  
ATOM    995  CB  ASP   128      12.301   1.824  -0.996  1.00  4.05           C  
ATOM    996  CG  ASP   128      13.769   1.443  -1.119  1.00  4.04           C  
ATOM    997  OD1 ASP   128      14.484   2.115  -1.899  1.00  5.33           O  
ATOM    998  OD2 ASP   128      14.185   0.505  -0.411  1.00  4.84           O  
ATOM    999  N   TRP   129      10.978  -0.923  -0.224  1.00  3.58           N  
ATOM   1000  CA  TRP   129      11.118  -2.279   0.279  1.00  3.68           C  
ATOM   1001  C   TRP   129      10.575  -3.272  -0.747  1.00  3.61           C  
ATOM   1002  O   TRP   129      11.252  -4.235  -1.148  1.00  4.41           O  
ATOM   1003  CB  TRP   129      10.394  -2.398   1.619  1.00  4.11           C  
ATOM   1004  CG  TRP   129      10.558  -3.726   2.308  1.00  3.84           C  
ATOM   1005  CD1 TRP   129       9.614  -4.693   2.432  1.00  4.29           C  
ATOM   1006  CD2 TRP   129      11.708  -4.178   3.064  1.00  4.09           C  
ATOM   1007  NE1 TRP   129      10.093  -5.730   3.205  1.00  4.47           N  
ATOM   1008  CE2 TRP   129      11.373  -5.436   3.599  1.00  4.27           C  
ATOM   1009  CE3 TRP   129      12.972  -3.633   3.353  1.00  4.65           C  
ATOM   1010  CZ2 TRP   129      12.278  -6.175   4.380  1.00  5.21           C  
ATOM   1011  CZ3 TRP   129      13.864  -4.361   4.102  1.00  5.69           C  
ATOM   1012  CH2 TRP   129      13.501  -5.624   4.611  1.00  5.59           C  
ATOM   1013  N   VAL   130       9.339  -3.042  -1.194  1.00  3.61           N  
ATOM   1014  CA  VAL   130       8.708  -3.942  -2.145  1.00  3.83           C  
ATOM   1015  C   VAL   130       9.390  -3.851  -3.511  1.00  4.04           C  
ATOM   1016  O   VAL   130       9.563  -4.874  -4.197  1.00  4.86           O  
ATOM   1017  CB  VAL   130       7.210  -3.665  -2.222  1.00  4.37           C  
ATOM   1018  CG1 VAL   130       6.529  -4.415  -3.377  1.00  5.73           C  
ATOM   1019  CG2 VAL   130       6.574  -4.015  -0.888  1.00  5.44           C  
ATOM   1020  N   SER   131       9.816  -2.682  -3.959  1.00  4.33           N  
ATOM   1021  CA  SER   131      10.509  -2.554  -5.230  0.50  4.63           C  
ATOM   1024  C   SER   131      11.725  -3.462  -5.309  1.00  4.94           C  
ATOM   1025  O   SER   131      12.048  -3.979  -6.379  1.00  7.00           O  
ATOM   1026  CB  SER   131      10.977  -1.105  -5.462  0.50  5.09           C  
ATOM   1029  OG  SER   131       9.891  -0.247  -5.776  0.50  4.79           O  
ATOM   1032  N   HIS   132      12.434  -3.601  -4.190  1.00  4.09           N  
ATOM   1033  CA  HIS   132      13.653  -4.387  -4.120  1.00  5.00           C  
ATOM   1034  C   HIS   132      13.407  -5.825  -3.700  1.00  5.16           C  
ATOM   1035  O   HIS   132      14.366  -6.579  -3.546  1.00  6.97           O  
ATOM   1036  CB  HIS   132      14.651  -3.741  -3.159  1.00  6.29           C  
ATOM   1037  CG  HIS   132      15.173  -2.425  -3.605  1.00  7.34           C  
ATOM   1038  ND1 HIS   132      14.569  -1.247  -3.294  1.00  8.04           N  
ATOM   1039  CD2 HIS   132      16.276  -2.083  -4.305  1.00 12.11           C  
ATOM   1040  CE1 HIS   132      15.249  -0.241  -3.804  1.00 10.56           C  
ATOM   1041  NE2 HIS   132      16.280  -0.718  -4.447  1.00 13.22           N  
ATOM   1042  N   GLY   133      12.154  -6.207  -3.489  1.00  5.03           N  
ATOM   1043  CA  GLY   133      11.806  -7.578  -3.156  1.00  5.84           C  
ATOM   1044  C   GLY   133      11.894  -7.915  -1.668  1.00  5.32           C  
ATOM   1045  O   GLY   133      11.886  -9.110  -1.321  1.00  5.03           O  
ATOM   1046  N   GLY   134      11.909  -6.905  -0.802  1.00  5.00           N  
ATOM   1047  CA  GLY   134      11.989  -7.156   0.610  1.00  5.55           C  
ATOM   1048  C   GLY   134      10.906  -8.023   1.172  1.00  4.95           C  
ATOM   1049  O   GLY   134      11.122  -8.750   2.153  1.00  5.96           O  
ATOM   1050  N   ASP   135       9.725  -7.953   0.591  1.00  5.67           N  
ATOM   1051  CA  ASP   135       8.617  -8.770   1.049  1.00  6.29           C  
ATOM   1052  C   ASP   135       8.818 -10.273   0.822  1.00  5.75           C  
ATOM   1053  O   ASP   135       8.085 -11.067   1.405  1.00  7.57           O  
ATOM   1054  CB  ASP   135       7.307  -8.294   0.391  1.00  7.45           C  
ATOM   1055  CG  ASP   135       7.385  -8.341  -1.120  1.00  8.12           C  
ATOM   1056  OD1 ASP   135       8.281  -7.699  -1.702  1.00  7.76           O  
ATOM   1057  OD2 ASP   135       6.580  -9.093  -1.739  1.00 13.52           O  
ATOM   1058  N   LYS   136       9.807 -10.636  -0.010  1.00  4.79           N  
ATOM   1059  CA  LYS   136      10.115 -12.031  -0.256  0.50  4.79           C  
ATOM   1061  C   LYS   136      11.260 -12.555   0.618  1.00  5.02           C  
ATOM   1062  O   LYS   136      11.670 -13.713   0.474  1.00  5.04           O  
ATOM   1063  CB  LYS   136      10.482 -12.246  -1.718  0.50  4.93           C  
ATOM   1065  CG  LYS   136       9.422 -11.816  -2.688  0.50  4.76           C  
ATOM   1067  CD  LYS   136       8.058 -12.371  -2.399  0.50  5.14           C  
ATOM   1069  CE  LYS   136       7.081 -12.233  -3.537  0.50  6.88           C  
ATOM   1071  NZ  LYS   136       7.051 -10.800  -4.022  0.50  7.26           N  
ATOM   1073  N   LEU   137      11.803 -11.706   1.487  1.00  5.59           N  
ATOM   1074  CA  LEU   137      12.840 -12.118   2.406  1.00  5.41           C  
ATOM   1075  C   LEU   137      12.245 -12.825   3.617  1.00  6.68           C  
ATOM   1076  O   LEU   137      11.058 -12.684   3.923  1.00  8.80           O  
ATOM   1077  CB  LEU   137      13.636 -10.911   2.889  1.00  5.66           C  
ATOM   1078  CG  LEU   137      14.328 -10.125   1.761  1.00  5.65           C  
ATOM   1079  CD1 LEU   137      14.925  -8.864   2.331  1.00  7.54           C  
ATOM   1080  CD2 LEU   137      15.411 -10.949   1.085  1.00  7.87           C  
ATOM   1081  N   ASP   138      13.096 -13.562   4.315  1.00  6.41           N  
ATOM   1082  CA  ASP   138      12.745 -14.216   5.555  1.00  7.90           C  
ATOM   1083  C   ASP   138      13.943 -14.092   6.510  1.00  8.72           C  
ATOM   1084  O   ASP   138      14.589 -15.076   6.851  1.00 12.84           O  
ATOM   1085  CB  ASP   138      12.391 -15.698   5.280  1.00  9.13           C  
ATOM   1086  CG  ASP   138      11.835 -16.421   6.470  1.00 11.58           C  
ATOM   1087  OD1 ASP   138      11.324 -15.777   7.390  1.00 15.42           O  
ATOM   1088  OD2 ASP   138      11.913 -17.655   6.525  1.00 14.90           O  
ATOM   1089  N   LEU   139      14.265 -12.876   6.930  1.00 11.14           N  
ATOM   1090  CA  LEU   139      15.484 -12.587   7.712  1.00 12.59           C  
ATOM   1091  C   LEU   139      15.303 -12.694   9.201  1.00 15.51           C  
ATOM   1092  O   LEU   139      14.166 -12.670   9.679  1.00 16.67           O  
ATOM   1093  CB  LEU   139      15.978 -11.192   7.404  1.00 14.21           C  
ATOM   1094  CG  LEU   139      16.279 -10.807   5.972  1.00 15.95           C  
ATOM   1095  CD1 LEU   139      16.667  -9.342   5.909  1.00 18.14           C  
ATOM   1096  CD2 LEU   139      17.346 -11.740   5.432  1.00 19.85           C  
ATOM   1097  OXT LEU   139      16.299 -12.751   9.943  1.00 18.29           O  
END
