
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  184 ( 1386),  selected  184 , name 1tf1_A
# Molecule2: number of CA atoms  176 ( 1390),  selected  176 , name T0412.pdb
# PARAMETERS: 1tf1_A.T0412.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    R     2_A      -       -           -
LGA    E     3_A      -       -           -
LGA    N     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    Y     6_A      -       -           -
LGA    F     7_A      -       -           -
LGA    Q     8_A      S       1           #
LGA    G     9_A      N       2           -
LGA    H    10_A      -       -           -
LGA    M    11_A      -       -           -
LGA    D    12_A      A       3          4.132
LGA    V    13_A      L       4           -
LGA    L    14_A      F       5           -
LGA    -       -      S       6           -
LGA    S    15_A      S       7          2.084
LGA    V    16_A      R       8          2.966
LGA    -       -      D       9           -
LGA    A    17_A      I      10          1.785
LGA    G    18_A      L      11          1.041
LGA    P    19_A      E      12          0.562
LGA    F    20_A      V      13          0.745
LGA    M    21_A      L      14          0.819
LGA    R    22_A      Q      15          0.701
LGA    R    23_A      D      16          0.587
LGA    L    24_A      I      17          0.831
LGA    M    25_A      H      18          1.058
LGA    L    26_A      M      19          1.790
LGA    L    27_A      E      20          2.078
LGA    S    28_A      T      21          2.305
LGA    G    29_A      G      22          2.475
LGA    E    30_A      E      23          0.646
LGA    T    31_A      T      24          0.687
LGA    V    32_A      V      25          0.277
LGA    N    33_A      A      26          1.105
LGA    V    34_A      I      27          1.310
LGA    A    35_A      A      28          1.183
LGA    I    36_A      T      29          1.354
LGA    R    37_A      K      30          0.594
LGA    N    38_A      N      31          0.857
LGA    G    39_A      D      32          3.421
LGA    N    40_A      I      33          1.169
LGA    E    41_A      Y      34          0.475
LGA    A    42_A      L      35          0.198
LGA    V    43_A      Q      36          1.596
LGA    L    44_A      Y      37          1.692
LGA    I    45_A      I      38          2.263
LGA    G    46_A      Q      39          0.527
LGA    Q    47_A      I      40          0.621
LGA    L    48_A      I      41          0.916
LGA    E    49_A      E      42          1.465
LGA    C    50_A      S      43          2.225
LGA    K    51_A      V      44          1.484
LGA    S    52_A      H      45          1.464
LGA    M    53_A      A      46          2.192
LGA    V    54_A      L      47          1.685
LGA    R    55_A      R      48          1.078
LGA    M    56_A      F      49          1.005
LGA    C    57_A      H      50          1.495
LGA    A    58_A      V      51          0.895
LGA    P    59_A      D      52          3.310
LGA    L    60_A      E      53          3.878
LGA    G    61_A      N      54          5.096
LGA    S    62_A      A      55          3.807
LGA    R    63_A      I      56          3.053
LGA    L    64_A      R      57          2.289
LGA    P    65_A      P      58          2.273
LGA    L    66_A      L      59          0.477
LGA    H    67_A      T      60          1.043
LGA    A    68_A      M      61          1.786
LGA    S    69_A      S      62          0.596
LGA    G    70_A      S      63          1.588
LGA    A    71_A      N      64          1.473
LGA    G    72_A      G      65          1.102
LGA    K    73_A      W      66          1.372
LGA    A    74_A      M      67          1.503
LGA    L    75_A      L      68          0.779
LGA    L    76_A      M      69          1.170
LGA    Y    77_A      S      70          1.631
LGA    P    78_A      T      71          2.445
LGA    L    79_A      M      72          2.342
LGA    A    80_A      N      73          2.386
LGA    E    81_A      D      74          2.049
LGA    E    82_A      K      75          2.190
LGA    E    83_A      A      76          1.785
LGA    L    84_A      I      77          0.633
LGA    M    85_A      D      78          1.068
LGA    S    86_A      N      79          2.114
LGA    I    87_A      T      80          1.572
LGA    I    88_A      V      81          1.823
LGA    L    89_A      R      82          2.600
LGA    Q    90_A      R      83          1.984
LGA    T    91_A      A      84          1.855
LGA    G    92_A      N      85          1.875
LGA    L    93_A      T      86           #
LGA    -       -      I      87           -
LGA    -       -      T      88           -
LGA    -       -      Q      89           -
LGA    -       -      K      90           -
LGA    -       -      D      91           -
LGA    Q    94_A      G      92           #
LGA    Q    95_A      I      93          1.662
LGA    F    96_A      -       -           -
LGA    T    97_A      -       -           -
LGA    P    98_A      -       -           -
LGA    T    99_A      -       -           -
LGA    T   100_A      -       -           -
LGA    L   101_A      R      94           #
LGA    V   102_A      F      95          1.252
LGA    D   103_A      E      96          1.494
LGA    M   104_A      V      97          1.811
LGA    P   105_A      D      98          2.114
LGA    T   106_A      D      99          1.809
LGA    L   107_A      M     100          1.472
LGA    L   108_A      M     101          2.107
LGA    K   109_A      A     102          2.165
LGA    D   110_A      R     103          1.675
LGA    L   111_A      I     104          1.724
LGA    E   112_A      R     105          2.106
LGA    Q   113_A      Q     106          2.119
LGA    A   114_A      V     107          1.644
LGA    R   115_A      R     108          1.627
LGA    E   116_A      E     109          2.055
LGA    L   117_A      Q     110          1.985
LGA    G   118_A      G     111          1.161
LGA    Y   119_A      Y     112          0.720
LGA    T   120_A      A     113          0.206
LGA    V   121_A      S     114          0.519
LGA    D   122_A      A     115          1.517
LGA    K   123_A      E     116          0.967
LGA    E   124_A      H     117          0.836
LGA    E   125_A      I     118          1.906
LGA    H   126_A      P     119          0.607
LGA    V   127_A      F     120          0.766
LGA    V   128_A      V     121          0.668
LGA    G   129_A      G     122          0.914
LGA    L   130_A      G     123          1.046
LGA    N   131_A      G     124          0.893
LGA    C   132_A      T     125          1.089
LGA    I   133_A      I     126          0.650
LGA    A   134_A      C     127          0.937
LGA    S   135_A      V     128          1.132
LGA    A   136_A      L     129          1.386
LGA    I   137_A      L     130          2.092
LGA    Y   138_A      P     131          3.569
LGA    D   139_A      M     132          2.855
LGA    D   140_A      T     133           #
LGA    V   141_A      I     134           -
LGA    G   142_A      Q     135           -
LGA    S   143_A      G     136           #
LGA    V   144_A      Q     137          5.576
LGA    V   145_A      P     138          1.677
LGA    A   146_A      V     139          1.285
LGA    A   147_A      T     140          0.932
LGA    I   148_A      M     141          1.120
LGA    S   149_A      G     142          0.763
LGA    I   150_A      L     143          0.102
LGA    S   151_A      G     144          0.581
LGA    G   152_A      G     145          0.537
LGA    P   153_A      A     146          0.712
LGA    S   154_A      L     147          0.724
LGA    S   155_A      D     148          1.945
LGA    R   156_A      R     149          1.133
LGA    L   157_A      I     150          0.784
LGA    T   158_A      K     151          1.104
LGA    E   159_A      -       -           -
LGA    D   160_A      Q     152          4.516
LGA    R   161_A      N     153          3.141
LGA    F   162_A      Y     154          2.780
LGA    V   163_A      D     155          3.396
LGA    S   164_A      R     156          3.176
LGA    Q   165_A      Y     157          1.935
LGA    G   166_A      L     158          2.256
LGA    E   167_A      E     159          3.119
LGA    L   168_A      L     160          2.079
LGA    V   169_A      L     161          1.632
LGA    R   170_A      L     162          2.744
LGA    D   171_A      N     163          2.739
LGA    T   172_A      G     164          1.942
LGA    A   173_A      V     165          3.624
LGA    R   174_A      Q     166          4.399
LGA    D   175_A      Q     167          3.323
LGA    I   176_A      L     168          3.972
LGA    S   177_A      K     169           #
LGA    T   178_A      K     170          3.516
LGA    A   179_A      S     171          1.959
LGA    L   180_A      D     172          3.251
LGA    G   181_A      S     173          4.173
LGA    L   182_A      F     174           #
LGA    K   183_A      H     175           -
LGA    A   184_A      Q     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  184  176    5.0    154    2.03    17.53     69.966     7.221

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.323556 * X  +   0.873598 * Y  +  -0.363509 * Z  +  19.389858
  Y_new =  -0.710908 * X  +   0.029090 * Y  +   0.702683 * Z  +  56.043213
  Z_new =   0.624436 * X  +   0.485779 * Y  +   0.611636 * Z  +  71.943100 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.671212   -2.470381  [ DEG:    38.4576   -141.5424 ]
  Theta =  -0.674410   -2.467183  [ DEG:   -38.6408   -141.3592 ]
  Phi   =  -1.997908    1.143684  [ DEG:  -114.4717     65.5283 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tf1_A                                        
REMARK     2: T0412.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tf1_A.T0412.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  184  176   5.0  154   2.03   17.53  69.966
REMARK  ---------------------------------------------------------- 
MOLECULE 1tf1_A
HEADER    TRANSCRIPTION                           26-MAY-04   1TF1              
TITLE     CRYSTAL STRUCTURE OF THE E. COLI GLYOXYLATE REGULATORY                
TITLE    2 PROTEIN LIGAND BINDING DOMAIN                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NEGATIVE REGULATOR OF ALLANTOIN AND GLYOXYLATE             
COMPND   3 UTILIZATION OPERONS;                                                 
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 FRAGMENT: LIGAND BINDING DOMAIN;                                     
COMPND   6 SYNONYM: TRANSCRIPTIONAL REGULATOR ALLR, APC5051;                    
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GLXA3;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    MIDWEST CENTER FOR STRUCTURAL GENOMICS, GLCR, LIGAND                  
KEYWDS   2 BINDING DOMAIN, TRANSCRIPTIONAL REGULATOR, PSI, PROTEIN              
KEYWDS   3 STRUCTURE INITIATIVE, MCSG                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.R.WALKER,T.SKARINA,M.KUDRYTSKA,A.JOACHIMIAK,C.ARROWSMITH,           
AUTHOR   2 A.EDWARDS,A.SAVCHENKO,MIDWEST CENTER FOR STRUCTURAL                  
AUTHOR   3 GENOMICS (MCSG)                                                      
REVDAT   3   18-JAN-05 1TF1    1       AUTHOR KEYWDS REMARK                     
REVDAT   2   31-AUG-04 1TF1    1       SOURCE                                   
REVDAT   1   03-AUG-04 1TF1    0                                                
JRNL        AUTH   J.R.WALKER,S.ALTAMENTOVA,A.EZERSKY,G.LORCA,                  
JRNL        AUTH 2 T.SKARINA,M.KUDRITSKA,L.J.BALL,A.BOCHKAREV,                  
JRNL        AUTH 3 A.SAVCHENKO                                                  
JRNL        TITL   STRUCTURAL AND BIOCHEMICAL STUDY OF EFFECTOR                 
JRNL        TITL 2 MOLECULE RECOGNITION BY THE E.COLI GLYOXYLATE AND            
JRNL        TITL 3 ALLANTOIN UTILIZATION REGULATORY PROTEIN ALLR.               
JRNL        REF    J.MOL.BIOL.                   V. 358   810 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1TF1 A   12   186  UNP    P0ACN4   ALLR_ECOLI      97    271             
DBREF  1TF1 B   12   186  UNP    P0ACN4   ALLR_ECOLI      97    271             
DBREF  1TF1 C   12   186  UNP    P0ACN4   ALLR_ECOLI      97    271             
DBREF  1TF1 D   12   186  UNP    P0ACN4   ALLR_ECOLI      97    271             
SEQRES   1 A  198  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  198  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET ASP VAL LEU          
SEQRES   3 A  198  SER VAL ALA GLY PRO PHE MET ARG ARG LEU MET LEU LEU          
SEQRES   4 A  198  SER GLY GLU THR VAL ASN VAL ALA ILE ARG ASN GLY ASN          
SEQRES   5 A  198  GLU ALA VAL LEU ILE GLY GLN LEU GLU CYS LYS SER MET          
SEQRES   6 A  198  VAL ARG MET CYS ALA PRO LEU GLY SER ARG LEU PRO LEU          
SEQRES   7 A  198  HIS ALA SER GLY ALA GLY LYS ALA LEU LEU TYR PRO LEU          
SEQRES   8 A  198  ALA GLU GLU GLU LEU MET SER ILE ILE LEU GLN THR GLY          
SEQRES   9 A  198  LEU GLN GLN PHE THR PRO THR THR LEU VAL ASP MET PRO          
SEQRES  10 A  198  THR LEU LEU LYS ASP LEU GLU GLN ALA ARG GLU LEU GLY          
SEQRES  11 A  198  TYR THR VAL ASP LYS GLU GLU HIS VAL VAL GLY LEU ASN          
SEQRES  12 A  198  CYS ILE ALA SER ALA ILE TYR ASP ASP VAL GLY SER VAL          
SEQRES  13 A  198  VAL ALA ALA ILE SER ILE SER GLY PRO SER SER ARG LEU          
SEQRES  14 A  198  THR GLU ASP ARG PHE VAL SER GLN GLY GLU LEU VAL ARG          
SEQRES  15 A  198  ASP THR ALA ARG ASP ILE SER THR ALA LEU GLY LEU LYS          
SEQRES  16 A  198  ALA HIS PRO                                                  
SEQRES   1 B  198  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 B  198  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET ASP VAL LEU          
SEQRES   3 B  198  SER VAL ALA GLY PRO PHE MET ARG ARG LEU MET LEU LEU          
SEQRES   4 B  198  SER GLY GLU THR VAL ASN VAL ALA ILE ARG ASN GLY ASN          
SEQRES   5 B  198  GLU ALA VAL LEU ILE GLY GLN LEU GLU CYS LYS SER MET          
SEQRES   6 B  198  VAL ARG MET CYS ALA PRO LEU GLY SER ARG LEU PRO LEU          
SEQRES   7 B  198  HIS ALA SER GLY ALA GLY LYS ALA LEU LEU TYR PRO LEU          
SEQRES   8 B  198  ALA GLU GLU GLU LEU MET SER ILE ILE LEU GLN THR GLY          
SEQRES   9 B  198  LEU GLN GLN PHE THR PRO THR THR LEU VAL ASP MET PRO          
SEQRES  10 B  198  THR LEU LEU LYS ASP LEU GLU GLN ALA ARG GLU LEU GLY          
SEQRES  11 B  198  TYR THR VAL ASP LYS GLU GLU HIS VAL VAL GLY LEU ASN          
SEQRES  12 B  198  CYS ILE ALA SER ALA ILE TYR ASP ASP VAL GLY SER VAL          
SEQRES  13 B  198  VAL ALA ALA ILE SER ILE SER GLY PRO SER SER ARG LEU          
SEQRES  14 B  198  THR GLU ASP ARG PHE VAL SER GLN GLY GLU LEU VAL ARG          
SEQRES  15 B  198  ASP THR ALA ARG ASP ILE SER THR ALA LEU GLY LEU LYS          
SEQRES  16 B  198  ALA HIS PRO                                                  
SEQRES   1 C  198  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 C  198  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET ASP VAL LEU          
SEQRES   3 C  198  SER VAL ALA GLY PRO PHE MET ARG ARG LEU MET LEU LEU          
SEQRES   4 C  198  SER GLY GLU THR VAL ASN VAL ALA ILE ARG ASN GLY ASN          
SEQRES   5 C  198  GLU ALA VAL LEU ILE GLY GLN LEU GLU CYS LYS SER MET          
SEQRES   6 C  198  VAL ARG MET CYS ALA PRO LEU GLY SER ARG LEU PRO LEU          
SEQRES   7 C  198  HIS ALA SER GLY ALA GLY LYS ALA LEU LEU TYR PRO LEU          
SEQRES   8 C  198  ALA GLU GLU GLU LEU MET SER ILE ILE LEU GLN THR GLY          
SEQRES   9 C  198  LEU GLN GLN PHE THR PRO THR THR LEU VAL ASP MET PRO          
SEQRES  10 C  198  THR LEU LEU LYS ASP LEU GLU GLN ALA ARG GLU LEU GLY          
SEQRES  11 C  198  TYR THR VAL ASP LYS GLU GLU HIS VAL VAL GLY LEU ASN          
SEQRES  12 C  198  CYS ILE ALA SER ALA ILE TYR ASP ASP VAL GLY SER VAL          
SEQRES  13 C  198  VAL ALA ALA ILE SER ILE SER GLY PRO SER SER ARG LEU          
SEQRES  14 C  198  THR GLU ASP ARG PHE VAL SER GLN GLY GLU LEU VAL ARG          
SEQRES  15 C  198  ASP THR ALA ARG ASP ILE SER THR ALA LEU GLY LEU LYS          
SEQRES  16 C  198  ALA HIS PRO                                                  
SEQRES   1 D  198  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 D  198  ARG GLU ASN LEU TYR PHE GLN GLY HIS MET ASP VAL LEU          
SEQRES   3 D  198  SER VAL ALA GLY PRO PHE MET ARG ARG LEU MET LEU LEU          
SEQRES   4 D  198  SER GLY GLU THR VAL ASN VAL ALA ILE ARG ASN GLY ASN          
SEQRES   5 D  198  GLU ALA VAL LEU ILE GLY GLN LEU GLU CYS LYS SER MET          
SEQRES   6 D  198  VAL ARG MET CYS ALA PRO LEU GLY SER ARG LEU PRO LEU          
SEQRES   7 D  198  HIS ALA SER GLY ALA GLY LYS ALA LEU LEU TYR PRO LEU          
SEQRES   8 D  198  ALA GLU GLU GLU LEU MET SER ILE ILE LEU GLN THR GLY          
SEQRES   9 D  198  LEU GLN GLN PHE THR PRO THR THR LEU VAL ASP MET PRO          
SEQRES  10 D  198  THR LEU LEU LYS ASP LEU GLU GLN ALA ARG GLU LEU GLY          
SEQRES  11 D  198  TYR THR VAL ASP LYS GLU GLU HIS VAL VAL GLY LEU ASN          
SEQRES  12 D  198  CYS ILE ALA SER ALA ILE TYR ASP ASP VAL GLY SER VAL          
SEQRES  13 D  198  VAL ALA ALA ILE SER ILE SER GLY PRO SER SER ARG LEU          
SEQRES  14 D  198  THR GLU ASP ARG PHE VAL SER GLN GLY GLU LEU VAL ARG          
SEQRES  15 D  198  ASP THR ALA ARG ASP ILE SER THR ALA LEU GLY LEU LYS          
SEQRES  16 D  198  ALA HIS PRO                                                  
FORMUL   5  HOH   *595(H2 O)                                                    
CRYST1   92.796   97.538  144.488  90.00  90.00  90.00 C 2 2 21     32          
ATOM      1  N   GLY A   1      24.747  16.789  82.166  1.00 46.21           N  
ATOM      2  CA  GLY A   1      24.573  17.932  83.108  1.00 46.22           C  
ATOM      3  C   GLY A   1      24.874  19.270  82.449  1.00 46.83           C  
ATOM      4  O   GLY A   1      24.204  19.662  81.490  1.00 46.60           O  
ATOM      5  N   ARG A   2      25.883  19.972  82.959  1.00 46.96           N  
ATOM      6  CA  ARG A   2      26.260  21.283  82.426  1.00 47.85           C  
ATOM      7  C   ARG A   2      26.744  21.162  80.993  1.00 47.14           C  
ATOM      8  O   ARG A   2      26.956  22.157  80.297  1.00 46.48           O  
ATOM      9  CB  ARG A   2      27.340  21.923  83.305  1.00 49.09           C  
ATOM     10  CG  ARG A   2      28.555  21.048  83.544  1.00 50.92           C  
ATOM     11  CD  ARG A   2      29.350  21.528  84.764  1.00 52.95           C  
ATOM     12  NE  ARG A   2      30.105  20.423  85.354  1.00 55.03           N  
ATOM     13  CZ  ARG A   2      30.635  20.430  86.576  1.00 56.61           C  
ATOM     14  NH1 ARG A   2      30.500  21.495  87.362  1.00 57.16           N  
ATOM     15  NH2 ARG A   2      31.292  19.359  87.024  1.00 56.98           N  
ATOM     16  N   GLU A   3      26.909  19.931  80.536  1.00 46.10           N  
ATOM     17  CA  GLU A   3      27.356  19.764  79.177  1.00 45.22           C  
ATOM     18  C   GLU A   3      26.151  19.852  78.239  1.00 43.34           C  
ATOM     19  O   GLU A   3      26.304  19.835  77.020  1.00 43.38           O  
ATOM     20  CB  GLU A   3      28.106  18.440  79.026  1.00 47.95           C  
ATOM     21  CG  GLU A   3      28.966  18.357  77.760  1.00 49.91           C  
ATOM     22  CD  GLU A   3      29.597  19.694  77.362  1.00 50.88           C  
ATOM     23  OE1 GLU A   3      30.263  20.346  78.204  1.00 51.86           O  
ATOM     24  OE2 GLU A   3      29.426  20.091  76.190  1.00 50.70           O  
ATOM     25  N   ASN A   4      24.952  19.966  78.812  1.00 39.76           N  
ATOM     26  CA  ASN A   4      23.735  20.085  78.011  1.00 36.43           C  
ATOM     27  C   ASN A   4      23.524  21.587  77.738  1.00 33.68           C  
ATOM     28  O   ASN A   4      23.633  22.401  78.646  1.00 31.41           O  
ATOM     29  CB  ASN A   4      22.526  19.511  78.781  1.00 36.65           C  
ATOM     30  CG  ASN A   4      21.308  19.272  77.886  1.00 37.76           C  
ATOM     31  OD1 ASN A   4      20.930  18.126  77.619  1.00 40.09           O  
ATOM     32  ND2 ASN A   4      20.683  20.348  77.428  1.00 35.07           N  
ATOM     33  N   LEU A   5      23.228  21.941  76.492  1.00 30.95           N  
ATOM     34  CA  LEU A   5      23.005  23.343  76.098  1.00 29.84           C  
ATOM     35  C   LEU A   5      21.876  24.026  76.888  1.00 28.32           C  
ATOM     36  O   LEU A   5      21.872  25.244  77.084  1.00 27.62           O  
ATOM     37  CB  LEU A   5      22.663  23.385  74.613  1.00 31.73           C  
ATOM     38  CG  LEU A   5      23.031  24.594  73.760  1.00 34.60           C  
ATOM     39  CD1 LEU A   5      24.517  24.918  73.915  1.00 35.85           C  
ATOM     40  CD2 LEU A   5      22.728  24.274  72.300  1.00 36.42           C  
ATOM     41  N   TYR A   6      20.896  23.239  77.308  1.00 26.90           N  
ATOM     42  CA  TYR A   6      19.767  23.765  78.056  1.00 26.61           C  
ATOM     43  C   TYR A   6      19.939  23.669  79.575  1.00 26.62           C  
ATOM     44  O   TYR A   6      19.006  23.948  80.335  1.00 23.57           O  
ATOM     45  CB  TYR A   6      18.493  23.017  77.627  1.00 27.91           C  
ATOM     46  CG  TYR A   6      18.216  23.124  76.143  1.00 29.72           C  
ATOM     47  CD1 TYR A   6      18.617  22.122  75.269  1.00 31.29           C  
ATOM     48  CD2 TYR A   6      17.625  24.277  75.601  1.00 28.63           C  
ATOM     49  CE1 TYR A   6      18.439  22.270  73.878  1.00 32.40           C  
ATOM     50  CE2 TYR A   6      17.454  24.434  74.230  1.00 29.74           C  
ATOM     51  CZ  TYR A   6      17.862  23.434  73.374  1.00 30.22           C  
ATOM     52  OH  TYR A   6      17.717  23.602  72.008  1.00 31.05           O  
ATOM     53  N   PHE A   7      21.121  23.245  80.009  1.00 26.22           N  
ATOM     54  CA  PHE A   7      21.429  23.095  81.440  1.00 26.23           C  
ATOM     55  C   PHE A   7      20.831  24.261  82.240  1.00 26.36           C  
ATOM     56  O   PHE A   7      21.013  25.426  81.864  1.00 25.77           O  
ATOM     57  CB  PHE A   7      22.955  23.053  81.608  1.00 28.41           C  
ATOM     58  CG  PHE A   7      23.405  23.017  83.026  1.00 29.66           C  
ATOM     59  CD1 PHE A   7      23.017  21.966  83.849  1.00 30.38           C  
ATOM     60  CD2 PHE A   7      24.216  24.032  83.554  1.00 30.85           C  
ATOM     61  CE1 PHE A   7      23.413  21.924  85.188  1.00 32.65           C  
ATOM     62  CE2 PHE A   7      24.625  23.990  84.912  1.00 30.77           C  
ATOM     63  CZ  PHE A   7      24.217  22.928  85.716  1.00 31.41           C  
ATOM     64  N   GLN A   8      20.141  23.972  83.342  1.00 24.79           N  
ATOM     65  CA  GLN A   8      19.518  25.053  84.126  1.00 25.56           C  
ATOM     66  C   GLN A   8      20.488  26.163  84.556  1.00 25.09           C  
ATOM     67  O   GLN A   8      20.117  27.328  84.593  1.00 26.58           O  
ATOM     68  CB  GLN A   8      18.793  24.490  85.353  1.00 25.87           C  
ATOM     69  CG  GLN A   8      17.956  25.519  86.132  1.00 27.82           C  
ATOM     70  CD  GLN A   8      16.809  26.114  85.298  1.00 31.52           C  
ATOM     71  OE1 GLN A   8      15.964  25.386  84.736  1.00 30.93           O  
ATOM     72  NE2 GLN A   8      16.773  27.438  85.217  1.00 32.10           N  
ATOM     73  N   GLY A   9      21.725  25.804  84.872  1.00 26.04           N  
ATOM     74  CA  GLY A   9      22.697  26.805  85.281  1.00 25.09           C  
ATOM     75  C   GLY A   9      22.860  27.874  84.209  1.00 23.65           C  
ATOM     76  O   GLY A   9      23.005  29.066  84.520  1.00 25.08           O  
ATOM     77  N   HIS A  10      22.845  27.452  82.949  1.00 23.11           N  
ATOM     78  CA  HIS A  10      22.963  28.391  81.821  1.00 22.75           C  
ATOM     79  C   HIS A  10      21.747  29.332  81.788  1.00 22.25           C  
ATOM     80  O   HIS A  10      21.863  30.521  81.547  1.00 23.97           O  
ATOM     81  CB  HIS A  10      22.995  27.627  80.495  1.00 24.23           C  
ATOM     82  CG  HIS A  10      24.163  26.699  80.335  1.00 25.09           C  
ATOM     83  ND1 HIS A  10      24.197  25.699  79.387  1.00 28.24           N  
ATOM     84  CD2 HIS A  10      25.351  26.639  80.979  1.00 24.98           C  
ATOM     85  CE1 HIS A  10      25.352  25.062  79.453  1.00 24.23           C  
ATOM     86  NE2 HIS A  10      26.070  25.618  80.413  1.00 27.41           N  
ATOM     87  N   MET A  11      20.570  28.748  81.937  1.00 20.29           N  
ATOM     88  CA  MET A  11      19.340  29.486  81.923  1.00 21.16           C  
ATOM     89  C   MET A  11      19.316  30.449  83.096  1.00 20.81           C  
ATOM     90  O   MET A  11      18.747  31.545  83.000  1.00 20.79           O  
ATOM     91  CB  MET A  11      18.164  28.503  82.000  1.00 22.86           C  
ATOM     92  CG  MET A  11      18.129  27.529  80.828  1.00 24.73           C  
ATOM     93  SD  MET A  11      18.104  28.342  79.179  1.00 27.22           S  
ATOM     94  CE  MET A  11      19.801  28.029  78.559  1.00 27.82           C  
ATOM     95  N   ASP A  12      19.956  30.056  84.192  1.00 21.81           N  
ATOM     96  CA  ASP A  12      19.986  30.920  85.386  1.00 22.52           C  
ATOM     97  C   ASP A  12      20.830  32.137  85.086  1.00 21.58           C  
ATOM     98  O   ASP A  12      20.525  33.249  85.518  1.00 18.74           O  
ATOM     99  CB  ASP A  12      20.573  30.187  86.589  1.00 25.55           C  
ATOM    100  CG  ASP A  12      19.665  29.058  87.102  1.00 27.15           C  
ATOM    101  OD1 ASP A  12      18.459  29.076  86.816  1.00 31.15           O  
ATOM    102  OD2 ASP A  12      20.165  28.178  87.803  1.00 28.03           O  
ATOM    103  N   VAL A  13      21.918  31.933  84.352  1.00 20.99           N  
ATOM    104  CA  VAL A  13      22.705  33.090  83.989  1.00 21.37           C  
ATOM    105  C   VAL A  13      21.814  34.011  83.141  1.00 19.34           C  
ATOM    106  O   VAL A  13      21.775  35.223  83.357  1.00 20.31           O  
ATOM    107  CB  VAL A  13      23.958  32.713  83.137  1.00 21.74           C  
ATOM    108  CG1 VAL A  13      24.627  34.001  82.603  1.00 22.46           C  
ATOM    109  CG2 VAL A  13      24.956  31.902  83.986  1.00 23.93           C  
ATOM    110  N   LEU A  14      21.085  33.462  82.176  1.00 18.99           N  
ATOM    111  CA  LEU A  14      20.252  34.349  81.326  1.00 20.56           C  
ATOM    112  C   LEU A  14      19.181  35.101  82.118  1.00 22.72           C  
ATOM    113  O   LEU A  14      18.919  36.284  81.873  1.00 24.30           O  
ATOM    114  CB  LEU A  14      19.567  33.537  80.198  1.00 21.18           C  
ATOM    115  CG  LEU A  14      20.595  32.992  79.192  1.00 23.22           C  
ATOM    116  CD1 LEU A  14      19.986  32.076  78.135  1.00 24.12           C  
ATOM    117  CD2 LEU A  14      21.256  34.216  78.533  1.00 21.62           C  
ATOM    118  N   SER A  15      18.572  34.425  83.074  1.00 23.88           N  
ATOM    119  CA  SER A  15      17.503  35.060  83.842  1.00 25.86           C  
ATOM    120  C   SER A  15      17.949  36.274  84.631  1.00 25.61           C  
ATOM    121  O   SER A  15      17.143  37.177  84.858  1.00 27.47           O  
ATOM    122  CB  SER A  15      16.852  34.072  84.805  1.00 26.94           C  
ATOM    123  OG  SER A  15      17.741  33.724  85.843  1.00 32.96           O  
ATOM    124  N   VAL A  16      19.200  36.306  85.072  1.00 22.90           N  
ATOM    125  CA  VAL A  16      19.636  37.461  85.845  1.00 23.17           C  
ATOM    126  C   VAL A  16      20.410  38.476  85.012  1.00 21.92           C  
ATOM    127  O   VAL A  16      20.588  39.632  85.427  1.00 21.31           O  
ATOM    128  CB  VAL A  16      20.533  37.048  87.057  1.00 24.46           C  
ATOM    129  CG1 VAL A  16      19.862  35.940  87.848  1.00 24.63           C  
ATOM    130  CG2 VAL A  16      21.907  36.597  86.587  1.00 21.84           C  
ATOM    131  N   ALA A  17      20.857  38.050  83.835  1.00 21.75           N  
ATOM    132  CA  ALA A  17      21.678  38.914  82.991  1.00 21.28           C  
ATOM    133  C   ALA A  17      21.003  40.083  82.290  1.00 22.53           C  
ATOM    134  O   ALA A  17      21.650  41.088  81.978  1.00 22.05           O  
ATOM    135  CB  ALA A  17      22.448  38.050  81.961  1.00 22.97           C  
ATOM    136  N   GLY A  18      19.704  39.972  82.063  1.00 22.00           N  
ATOM    137  CA  GLY A  18      18.984  41.004  81.343  1.00 24.14           C  
ATOM    138  C   GLY A  18      19.314  42.463  81.534  1.00 24.22           C  
ATOM    139  O   GLY A  18      19.708  43.154  80.576  1.00 24.27           O  
ATOM    140  N   PRO A  19      19.141  42.980  82.759  1.00 23.76           N  
ATOM    141  CA  PRO A  19      19.391  44.363  83.157  1.00 24.43           C  
ATOM    142  C   PRO A  19      20.819  44.809  82.879  1.00 24.34           C  
ATOM    143  O   PRO A  19      21.060  45.947  82.496  1.00 22.90           O  
ATOM    144  CB  PRO A  19      19.082  44.339  84.653  1.00 25.07           C  
ATOM    145  CG  PRO A  19      18.043  43.299  84.762  1.00 24.87           C  
ATOM    146  CD  PRO A  19      18.562  42.212  83.881  1.00 27.02           C  
ATOM    147  N   PHE A  20      21.758  43.894  83.089  1.00 23.01           N  
ATOM    148  CA  PHE A  20      23.168  44.184  82.892  1.00 21.49           C  
ATOM    149  C   PHE A  20      23.533  44.191  81.427  1.00 20.07           C  
ATOM    150  O   PHE A  20      24.413  44.930  81.005  1.00 17.61           O  
ATOM    151  CB  PHE A  20      23.982  43.152  83.663  1.00 22.16           C  
ATOM    152  CG  PHE A  20      23.607  43.110  85.112  1.00 22.01           C  
ATOM    153  CD1 PHE A  20      23.894  44.180  85.921  1.00 23.57           C  
ATOM    154  CD2 PHE A  20      22.872  42.054  85.629  1.00 23.03           C  
ATOM    155  CE1 PHE A  20      23.431  44.231  87.229  1.00 26.20           C  
ATOM    156  CE2 PHE A  20      22.407  42.083  86.937  1.00 24.74           C  
ATOM    157  CZ  PHE A  20      22.703  43.181  87.736  1.00 25.43           C  
ATOM    158  N   MET A  21      22.866  43.355  80.664  1.00 19.53           N  
ATOM    159  CA  MET A  21      23.114  43.321  79.215  1.00 21.03           C  
ATOM    160  C   MET A  21      22.606  44.612  78.646  1.00 21.00           C  
ATOM    161  O   MET A  21      23.233  45.235  77.773  1.00 21.66           O  
ATOM    162  CB  MET A  21      22.370  42.149  78.580  1.00 21.02           C  
ATOM    163  CG  MET A  21      23.011  40.856  78.855  1.00 20.41           C  
ATOM    164  SD  MET A  21      21.950  39.473  78.441  1.00 23.79           S  
ATOM    165  CE  MET A  21      21.995  39.587  76.695  1.00 21.50           C  
ATOM    166  N   ARG A  22      21.471  45.057  79.166  1.00 22.09           N  
ATOM    167  CA  ARG A  22      20.910  46.321  78.666  1.00 23.88           C  
ATOM    168  C   ARG A  22      21.842  47.496  78.917  1.00 21.88           C  
ATOM    169  O   ARG A  22      22.096  48.271  78.011  1.00 23.30           O  
ATOM    170  CB  ARG A  22      19.538  46.596  79.302  1.00 27.34           C  
ATOM    171  CG  ARG A  22      18.449  45.668  78.793  1.00 33.08           C  
ATOM    172  CD  ARG A  22      17.020  46.217  79.048  1.00 36.81           C  
ATOM    173  NE  ARG A  22      16.658  46.240  80.464  1.00 39.32           N  
ATOM    174  CZ  ARG A  22      16.266  45.180  81.170  1.00 41.04           C  
ATOM    175  NH1 ARG A  22      16.175  43.980  80.600  1.00 42.66           N  
ATOM    176  NH2 ARG A  22      15.955  45.325  82.459  1.00 41.35           N  
ATOM    177  N   ARG A  23      22.339  47.618  80.146  1.00 21.35           N  
ATOM    178  CA  ARG A  23      23.243  48.687  80.522  1.00 22.94           C  
ATOM    179  C   ARG A  23      24.528  48.641  79.701  1.00 21.95           C  
ATOM    180  O   ARG A  23      25.041  49.656  79.309  1.00 20.77           O  
ATOM    181  CB  ARG A  23      23.592  48.585  82.010  1.00 27.48           C  
ATOM    182  CG  ARG A  23      24.583  49.627  82.486  1.00 32.92           C  
ATOM    183  CD  ARG A  23      24.571  49.787  84.024  1.00 37.51           C  
ATOM    184  NE  ARG A  23      25.518  50.818  84.467  1.00 41.39           N  
ATOM    185  CZ  ARG A  23      26.844  50.659  84.511  1.00 44.67           C  
ATOM    186  NH1 ARG A  23      27.406  49.496  84.154  1.00 45.00           N  
ATOM    187  NH2 ARG A  23      27.619  51.677  84.883  1.00 44.68           N  
ATOM    188  N   LEU A  24      25.053  47.440  79.482  1.00 21.60           N  
ATOM    189  CA  LEU A  24      26.278  47.302  78.719  1.00 20.40           C  
ATOM    190  C   LEU A  24      26.087  47.695  77.237  1.00 20.38           C  
ATOM    191  O   LEU A  24      26.960  48.344  76.637  1.00 20.35           O  
ATOM    192  CB  LEU A  24      26.777  45.867  78.856  1.00 18.94           C  
ATOM    193  CG  LEU A  24      28.055  45.479  78.107  1.00 18.62           C  
ATOM    194  CD1 LEU A  24      29.199  46.436  78.446  1.00 19.81           C  
ATOM    195  CD2 LEU A  24      28.414  44.037  78.432  1.00 16.34           C  
ATOM    196  N   MET A  25      24.960  47.299  76.655  1.00 20.24           N  
ATOM    197  CA  MET A  25      24.682  47.628  75.260  1.00 20.73           C  
ATOM    198  C   MET A  25      24.574  49.156  75.124  1.00 21.91           C  
ATOM    199  O   MET A  25      25.138  49.773  74.199  1.00 20.10           O  
ATOM    200  CB  MET A  25      23.399  46.914  74.781  1.00 22.18           C  
ATOM    201  CG  MET A  25      23.035  47.138  73.285  1.00 23.31           C  
ATOM    202  SD  MET A  25      22.233  48.739  73.036  1.00 24.80           S  
ATOM    203  CE  MET A  25      20.527  48.302  73.828  1.00 25.54           C  
ATOM    204  N   LEU A  26      23.884  49.774  76.061  1.00 22.45           N  
ATOM    205  CA  LEU A  26      23.729  51.216  76.006  1.00 26.33           C  
ATOM    206  C   LEU A  26      25.056  51.967  76.175  1.00 25.85           C  
ATOM    207  O   LEU A  26      25.310  52.936  75.474  1.00 27.17           O  
ATOM    208  CB  LEU A  26      22.751  51.662  77.092  1.00 27.13           C  
ATOM    209  CG  LEU A  26      22.754  53.143  77.469  1.00 33.09           C  
ATOM    210  CD1 LEU A  26      22.016  53.977  76.402  1.00 34.84           C  
ATOM    211  CD2 LEU A  26      22.077  53.300  78.840  1.00 34.74           C  
ATOM    212  N   LEU A  27      25.878  51.528  77.121  1.00 25.34           N  
ATOM    213  CA  LEU A  27      27.137  52.194  77.391  1.00 25.03           C  
ATOM    214  C   LEU A  27      28.206  51.931  76.350  1.00 24.53           C  
ATOM    215  O   LEU A  27      29.053  52.777  76.098  1.00 24.97           O  
ATOM    216  CB  LEU A  27      27.647  51.798  78.768  1.00 25.97           C  
ATOM    217  CG  LEU A  27      26.815  52.322  79.944  1.00 28.04           C  
ATOM    218  CD1 LEU A  27      27.405  51.810  81.265  1.00 26.15           C  
ATOM    219  CD2 LEU A  27      26.809  53.823  79.933  1.00 29.43           C  
ATOM    220  N   SER A  28      28.174  50.757  75.737  1.00 22.71           N  
ATOM    221  CA  SER A  28      29.199  50.418  74.772  1.00 21.41           C  
ATOM    222  C   SER A  28      28.801  50.744  73.347  1.00 21.48           C  
ATOM    223  O   SER A  28      29.681  50.918  72.488  1.00 21.67           O  
ATOM    224  CB  SER A  28      29.514  48.928  74.841  1.00 20.43           C  
ATOM    225  OG  SER A  28      28.439  48.166  74.360  1.00 18.04           O  
ATOM    226  N   GLY A  29      27.493  50.778  73.090  1.00 20.48           N  
ATOM    227  CA  GLY A  29      27.004  51.032  71.731  1.00 20.39           C  
ATOM    228  C   GLY A  29      27.187  49.816  70.807  1.00 20.38           C  
ATOM    229  O   GLY A  29      27.140  49.951  69.571  1.00 20.40           O  
ATOM    230  N   GLU A  30      27.409  48.626  71.373  1.00 19.09           N  
ATOM    231  CA  GLU A  30      27.596  47.428  70.516  1.00 20.29           C  
ATOM    232  C   GLU A  30      26.725  46.276  70.986  1.00 21.26           C  
ATOM    233  O   GLU A  30      26.237  46.287  72.111  1.00 20.40           O  
ATOM    234  CB  GLU A  30      29.047  46.929  70.565  1.00 20.79           C  
ATOM    235  CG  GLU A  30      30.113  47.934  70.099  1.00 19.68           C  
ATOM    236  CD  GLU A  30      29.919  48.333  68.658  1.00 19.44           C  
ATOM    237  OE1 GLU A  30      29.237  47.594  67.920  1.00 18.77           O  
ATOM    238  OE2 GLU A  30      30.484  49.379  68.251  1.00 21.48           O  
ATOM    239  N   THR A  31      26.585  45.253  70.142  1.00 20.28           N  
ATOM    240  CA  THR A  31      25.795  44.078  70.475  1.00 20.08           C  
ATOM    241  C   THR A  31      26.467  43.340  71.638  1.00 19.72           C  
ATOM    242  O   THR A  31      27.677  43.182  71.684  1.00 19.65           O  
ATOM    243  CB  THR A  31      25.678  43.115  69.242  1.00 18.88           C  
ATOM    244  OG1 THR A  31      24.864  43.743  68.237  1.00 21.02           O  
ATOM    245  CG2 THR A  31      25.047  41.720  69.646  1.00 19.04           C  
ATOM    246  N   VAL A  32      25.650  42.875  72.572  1.00 18.33           N  
ATOM    247  CA  VAL A  32      26.127  42.187  73.750  1.00 18.28           C  
ATOM    248  C   VAL A  32      25.754  40.701  73.622  1.00 19.76           C  
ATOM    249  O   VAL A  32      24.626  40.360  73.280  1.00 20.53           O  
ATOM    250  CB  VAL A  32      25.461  42.786  75.010  1.00 21.08           C  
ATOM    251  CG1 VAL A  32      25.880  41.999  76.274  1.00 17.39           C  
ATOM    252  CG2 VAL A  32      25.896  44.265  75.128  1.00 18.97           C  
ATOM    253  N   ASN A  33      26.704  39.814  73.889  1.00 19.77           N  
ATOM    254  CA  ASN A  33      26.426  38.376  73.809  1.00 21.16           C  
ATOM    255  C   ASN A  33      26.769  37.663  75.123  1.00 19.41           C  
ATOM    256  O   ASN A  33      27.647  38.093  75.847  1.00 19.37           O  
ATOM    257  CB  ASN A  33      27.284  37.756  72.698  1.00 18.35           C  
ATOM    258  CG  ASN A  33      26.926  38.299  71.339  1.00 23.12           C  
ATOM    259  OD1 ASN A  33      25.860  38.020  70.847  1.00 26.84           O  
ATOM    260  ND2 ASN A  33      27.804  39.099  70.745  1.00 29.01           N  
ATOM    261  N   VAL A  34      26.076  36.561  75.383  1.00 18.67           N  
ATOM    262  CA  VAL A  34      26.334  35.693  76.523  1.00 18.92           C  
ATOM    263  C   VAL A  34      26.580  34.305  75.932  1.00 18.37           C  
ATOM    264  O   VAL A  34      25.746  33.754  75.193  1.00 19.25           O  
ATOM    265  CB  VAL A  34      25.118  35.590  77.499  1.00 18.04           C  
ATOM    266  CG1 VAL A  34      25.435  34.580  78.575  1.00 16.62           C  
ATOM    267  CG2 VAL A  34      24.824  36.957  78.125  1.00 19.28           C  
ATOM    268  N   ALA A  35      27.736  33.749  76.235  1.00 18.77           N  
ATOM    269  CA  ALA A  35      28.098  32.439  75.742  1.00 18.15           C  
ATOM    270  C   ALA A  35      28.425  31.477  76.867  1.00 19.03           C  
ATOM    271  O   ALA A  35      28.819  31.885  77.970  1.00 17.44           O  
ATOM    272  CB  ALA A  35      29.321  32.549  74.796  1.00 16.78           C  
ATOM    273  N   ILE A  36      28.257  30.176  76.575  1.00 19.61           N  
ATOM    274  CA  ILE A  36      28.629  29.145  77.524  1.00 19.23           C  
ATOM    275  C   ILE A  36      29.480  28.132  76.771  1.00 21.65           C  
ATOM    276  O   ILE A  36      29.523  28.127  75.536  1.00 19.13           O  
ATOM    277  CB  ILE A  36      27.378  28.448  78.187  1.00 19.99           C  
ATOM    278  CG1 ILE A  36      26.350  27.980  77.161  1.00 21.49           C  
ATOM    279  CG2 ILE A  36      26.696  29.464  79.131  1.00 17.39           C  
ATOM    280  CD1 ILE A  36      26.679  26.707  76.457  1.00 25.28           C  
ATOM    281  N   ARG A  37      30.172  27.278  77.506  1.00 21.34           N  
ATOM    282  CA  ARG A  37      31.006  26.284  76.846  1.00 24.85           C  
ATOM    283  C   ARG A  37      30.150  25.035  76.574  1.00 26.06           C  
ATOM    284  O   ARG A  37      29.413  24.583  77.463  1.00 25.75           O  
ATOM    285  CB  ARG A  37      32.188  25.927  77.743  1.00 24.07           C  
ATOM    286  CG  ARG A  37      33.070  24.815  77.175  1.00 27.09           C  
ATOM    287  CD  ARG A  37      34.104  24.356  78.180  1.00 29.33           C  
ATOM    288  NE  ARG A  37      34.795  23.181  77.672  1.00 31.64           N  
ATOM    289  CZ  ARG A  37      35.692  22.491  78.359  1.00 31.56           C  
ATOM    290  NH1 ARG A  37      36.019  22.861  79.596  1.00 29.59           N  
ATOM    291  NH2 ARG A  37      36.253  21.420  77.800  1.00 33.12           N  
ATOM    292  N   ASN A  38      30.234  24.506  75.351  1.00 26.34           N  
ATOM    293  CA  ASN A  38      29.508  23.286  74.964  1.00 28.12           C  
ATOM    294  C   ASN A  38      30.181  22.620  73.754  1.00 28.41           C  
ATOM    295  O   ASN A  38      30.337  23.257  72.728  1.00 27.21           O  
ATOM    296  CB  ASN A  38      28.057  23.621  74.605  1.00 28.26           C  
ATOM    297  CG  ASN A  38      27.268  22.409  74.075  1.00 32.09           C  
ATOM    298  OD1 ASN A  38      27.309  22.085  72.881  1.00 31.48           O  
ATOM    299  ND2 ASN A  38      26.543  21.742  74.973  1.00 29.78           N  
ATOM    300  N   GLY A  39      30.536  21.336  73.863  1.00 31.13           N  
ATOM    301  CA  GLY A  39      31.155  20.638  72.731  1.00 31.14           C  
ATOM    302  C   GLY A  39      32.473  21.277  72.293  1.00 30.95           C  
ATOM    303  O   GLY A  39      32.827  21.297  71.116  1.00 31.91           O  
ATOM    304  N   ASN A  40      33.202  21.784  73.280  1.00 28.99           N  
ATOM    305  CA  ASN A  40      34.486  22.460  73.085  1.00 28.13           C  
ATOM    306  C   ASN A  40      34.447  23.676  72.168  1.00 26.22           C  
ATOM    307  O   ASN A  40      35.441  23.992  71.509  1.00 25.83           O  
ATOM    308  CB  ASN A  40      35.597  21.499  72.610  1.00 28.66           C  
ATOM    309  CG  ASN A  40      36.106  20.594  73.739  1.00 31.76           C  
ATOM    310  OD1 ASN A  40      36.103  20.980  74.912  1.00 31.51           O  
ATOM    311  ND2 ASN A  40      36.545  19.403  73.383  1.00 32.27           N  
ATOM    312  N   GLU A  41      33.305  24.353  72.181  1.00 25.42           N  
ATOM    313  CA  GLU A  41      33.068  25.578  71.451  1.00 26.54           C  
ATOM    314  C   GLU A  41      32.307  26.530  72.368  1.00 25.67           C  
ATOM    315  O   GLU A  41      31.771  26.106  73.400  1.00 25.80           O  
ATOM    316  CB  GLU A  41      32.228  25.321  70.212  1.00 28.12           C  
ATOM    317  CG  GLU A  41      32.891  24.403  69.187  1.00 31.30           C  
ATOM    318  CD  GLU A  41      31.978  24.157  68.013  1.00 33.69           C  
ATOM    319  OE1 GLU A  41      31.084  23.287  68.130  1.00 34.69           O  
ATOM    320  OE2 GLU A  41      32.134  24.862  66.999  1.00 34.66           O  
ATOM    321  N   ALA A  42      32.298  27.811  72.016  1.00 24.09           N  
ATOM    322  CA  ALA A  42      31.551  28.811  72.783  1.00 25.65           C  
ATOM    323  C   ALA A  42      30.247  28.977  72.023  1.00 26.56           C  
ATOM    324  O   ALA A  42      30.261  29.330  70.841  1.00 29.10           O  
ATOM    325  CB  ALA A  42      32.324  30.162  72.813  1.00 24.32           C  
ATOM    326  N   VAL A  43      29.117  28.750  72.684  1.00 24.73           N  
ATOM    327  CA  VAL A  43      27.824  28.861  72.007  1.00 21.96           C  
ATOM    328  C   VAL A  43      27.080  30.079  72.540  1.00 22.00           C  
ATOM    329  O   VAL A  43      27.008  30.277  73.761  1.00 19.12           O  
ATOM    330  CB  VAL A  43      26.978  27.610  72.287  1.00 25.09           C  
ATOM    331  CG1 VAL A  43      25.618  27.724  71.611  1.00 25.39           C  
ATOM    332  CG2 VAL A  43      27.752  26.360  71.827  1.00 27.30           C  
ATOM    333  N   LEU A  44      26.565  30.889  71.627  1.00 19.65           N  
ATOM    334  CA  LEU A  44      25.804  32.079  72.001  1.00 22.35           C  
ATOM    335  C   LEU A  44      24.405  31.678  72.466  1.00 22.25           C  
ATOM    336  O   LEU A  44      23.603  31.125  71.680  1.00 22.64           O  
ATOM    337  CB  LEU A  44      25.670  33.023  70.813  1.00 22.75           C  
ATOM    338  CG  LEU A  44      26.938  33.614  70.229  1.00 24.12           C  
ATOM    339  CD1 LEU A  44      26.502  34.683  69.198  1.00 23.82           C  
ATOM    340  CD2 LEU A  44      27.822  34.284  71.321  1.00 26.32           C  
ATOM    341  N   ILE A  45      24.107  31.939  73.739  1.00 21.78           N  
ATOM    342  CA  ILE A  45      22.792  31.605  74.275  1.00 21.15           C  
ATOM    343  C   ILE A  45      21.951  32.824  74.637  1.00 21.32           C  
ATOM    344  O   ILE A  45      20.760  32.710  74.819  1.00 20.69           O  
ATOM    345  CB  ILE A  45      22.897  30.639  75.485  1.00 21.64           C  
ATOM    346  CG1 ILE A  45      23.666  31.276  76.624  1.00 21.29           C  
ATOM    347  CG2 ILE A  45      23.572  29.365  75.028  1.00 19.34           C  
ATOM    348  CD1 ILE A  45      23.493  30.540  77.946  1.00 22.28           C  
ATOM    349  N   GLY A  46      22.578  33.992  74.733  1.00 19.55           N  
ATOM    350  CA  GLY A  46      21.827  35.198  75.029  1.00 22.49           C  
ATOM    351  C   GLY A  46      22.382  36.295  74.153  1.00 21.87           C  
ATOM    352  O   GLY A  46      23.571  36.245  73.787  1.00 22.25           O  
ATOM    353  N   GLN A  47      21.565  37.277  73.801  1.00 22.09           N  
ATOM    354  CA  GLN A  47      22.078  38.374  72.964  1.00 22.22           C  
ATOM    355  C   GLN A  47      21.156  39.592  73.052  1.00 21.94           C  
ATOM    356  O   GLN A  47      19.940  39.452  73.196  1.00 21.10           O  
ATOM    357  CB  GLN A  47      22.150  37.934  71.503  1.00 22.55           C  
ATOM    358  CG  GLN A  47      22.792  38.978  70.560  1.00 23.94           C  
ATOM    359  CD  GLN A  47      22.904  38.482  69.111  1.00 27.29           C  
ATOM    360  OE1 GLN A  47      23.946  37.938  68.675  1.00 28.64           O  
ATOM    361  NE2 GLN A  47      21.839  38.680  68.357  1.00 26.30           N  
ATOM    362  N   LEU A  48      21.750  40.770  73.001  1.00 19.75           N  
ATOM    363  CA  LEU A  48      20.993  42.013  72.970  1.00 21.73           C  
ATOM    364  C   LEU A  48      21.722  42.924  71.981  1.00 20.10           C  
ATOM    365  O   LEU A  48      22.777  43.476  72.280  1.00 20.48           O  
ATOM    366  CB  LEU A  48      20.928  42.657  74.326  1.00 22.52           C  
ATOM    367  CG  LEU A  48      20.233  44.012  74.256  1.00 24.29           C  
ATOM    368  CD1 LEU A  48      18.778  43.839  73.868  1.00 26.20           C  
ATOM    369  CD2 LEU A  48      20.369  44.660  75.617  1.00 25.74           C  
ATOM    370  N   GLU A  49      21.163  43.021  70.780  1.00 24.31           N  
ATOM    371  CA  GLU A  49      21.747  43.821  69.707  1.00 24.25           C  
ATOM    372  C   GLU A  49      21.730  45.324  69.959  1.00 24.03           C  
ATOM    373  O   GLU A  49      20.804  45.852  70.582  1.00 23.93           O  
ATOM    374  CB  GLU A  49      21.028  43.499  68.384  1.00 25.90           C  
ATOM    375  CG  GLU A  49      21.377  42.095  67.838  1.00 30.17           C  
ATOM    376  CD  GLU A  49      20.530  41.665  66.642  1.00 32.20           C  
ATOM    377  OE1 GLU A  49      19.534  40.945  66.843  1.00 35.35           O  
ATOM    378  OE2 GLU A  49      20.857  42.040  65.495  1.00 33.82           O  
ATOM    379  N   CYS A  50      22.759  46.019  69.482  1.00 23.85           N  
ATOM    380  CA  CYS A  50      22.774  47.466  69.643  1.00 23.10           C  
ATOM    381  C   CYS A  50      21.824  47.952  68.546  1.00 24.24           C  
ATOM    382  O   CYS A  50      21.343  47.156  67.734  1.00 24.40           O  
ATOM    383  CB  CYS A  50      24.179  48.071  69.456  1.00 21.36           C  
ATOM    384  SG  CYS A  50      24.864  47.817  67.809  1.00 25.50           S  
ATOM    385  N   LYS A  51      21.556  49.254  68.522  1.00 24.45           N  
ATOM    386  CA  LYS A  51      20.598  49.795  67.566  1.00 27.17           C  
ATOM    387  C   LYS A  51      21.163  50.241  66.230  1.00 26.45           C  
ATOM    388  O   LYS A  51      20.410  50.690  65.359  1.00 28.35           O  
ATOM    389  CB  LYS A  51      19.841  50.964  68.214  1.00 30.27           C  
ATOM    390  CG  LYS A  51      19.191  50.612  69.559  1.00 34.03           C  
ATOM    391  CD  LYS A  51      18.504  51.840  70.165  1.00 39.23           C  
ATOM    392  CE  LYS A  51      17.862  51.546  71.542  1.00 41.82           C  
ATOM    393  NZ  LYS A  51      18.863  51.275  72.604  1.00 43.98           N  
ATOM    394  N   SER A  52      22.462  50.089  66.027  1.00 24.57           N  
ATOM    395  CA  SER A  52      23.055  50.553  64.775  1.00 25.25           C  
ATOM    396  C   SER A  52      22.793  49.581  63.621  1.00 24.09           C  
ATOM    397  O   SER A  52      22.831  48.374  63.809  1.00 26.16           O  
ATOM    398  CB  SER A  52      24.555  50.755  64.974  1.00 24.82           C  
ATOM    399  OG  SER A  52      25.130  51.186  63.759  1.00 25.86           O  
ATOM    400  N   MET A  53      22.518  50.112  62.426  1.00 24.04           N  
ATOM    401  CA  MET A  53      22.234  49.256  61.281  1.00 24.90           C  
ATOM    402  C   MET A  53      23.409  48.395  60.903  1.00 23.62           C  
ATOM    403  O   MET A  53      23.236  47.337  60.287  1.00 24.14           O  
ATOM    404  CB  MET A  53      21.797  50.092  60.088  1.00 27.48           C  
ATOM    405  CG  MET A  53      20.353  50.347  60.074  1.00 30.44           C  
ATOM    406  SD  MET A  53      19.989  51.345  58.591  1.00 34.35           S  
ATOM    407  CE  MET A  53      19.187  52.605  59.384  1.00 35.32           C  
ATOM    408  N   VAL A  54      24.605  48.848  61.248  1.00 23.57           N  
ATOM    409  CA  VAL A  54      25.790  48.039  60.997  1.00 20.78           C  
ATOM    410  C   VAL A  54      26.289  47.594  62.370  1.00 21.63           C  
ATOM    411  O   VAL A  54      26.625  48.421  63.252  1.00 19.96           O  
ATOM    412  CB  VAL A  54      26.888  48.812  60.170  1.00 21.63           C  
ATOM    413  CG1 VAL A  54      27.458  50.035  60.922  1.00 22.39           C  
ATOM    414  CG2 VAL A  54      28.006  47.857  59.823  1.00 22.96           C  
ATOM    415  N   ARG A  55      26.345  46.277  62.556  1.00 19.21           N  
ATOM    416  CA  ARG A  55      26.717  45.741  63.858  1.00 20.95           C  
ATOM    417  C   ARG A  55      26.981  44.228  63.769  1.00 21.96           C  
ATOM    418  O   ARG A  55      26.957  43.639  62.682  1.00 21.84           O  
ATOM    419  CB  ARG A  55      25.538  45.983  64.797  1.00 21.19           C  
ATOM    420  CG  ARG A  55      24.213  45.306  64.321  1.00 19.28           C  
ATOM    421  CD  ARG A  55      23.131  45.431  65.367  1.00 23.98           C  
ATOM    422  NE  ARG A  55      21.902  44.680  65.064  1.00 23.66           N  
ATOM    423  CZ  ARG A  55      20.827  45.243  64.526  1.00 26.67           C  
ATOM    424  NH1 ARG A  55      20.838  46.549  64.222  1.00 27.87           N  
ATOM    425  NH2 ARG A  55      19.730  44.524  64.328  1.00 29.69           N  
ATOM    426  N   MET A  56      27.230  43.608  64.922  1.00 20.29           N  
ATOM    427  CA  MET A  56      27.437  42.177  64.993  1.00 21.47           C  
ATOM    428  C   MET A  56      26.045  41.585  65.196  1.00 23.93           C  
ATOM    429  O   MET A  56      25.243  42.084  65.996  1.00 22.18           O  
ATOM    430  CB  MET A  56      28.359  41.811  66.166  1.00 21.15           C  
ATOM    431  CG  MET A  56      28.691  40.297  66.263  1.00 23.26           C  
ATOM    432  SD  MET A  56      27.397  39.340  67.117  1.00 26.84           S  
ATOM    433  CE  MET A  56      28.333  37.832  67.725  1.00 29.81           C  
ATOM    434  N   CYS A  57      25.731  40.538  64.463  1.00 25.11           N  
ATOM    435  CA  CYS A  57      24.388  39.987  64.597  1.00 28.52           C  
ATOM    436  C   CYS A  57      24.283  38.524  64.223  1.00 29.10           C  
ATOM    437  O   CYS A  57      23.404  38.115  63.443  1.00 28.93           O  
ATOM    438  CB  CYS A  57      23.396  40.819  63.775  1.00 29.79           C  
ATOM    439  SG  CYS A  57      23.694  40.799  61.999  1.00 34.21           S  
ATOM    440  N   ALA A  58      25.213  37.754  64.774  1.00 28.48           N  
ATOM    441  CA  ALA A  58      25.222  36.318  64.591  1.00 28.47           C  
ATOM    442  C   ALA A  58      23.987  35.880  65.349  1.00 28.82           C  
ATOM    443  O   ALA A  58      23.577  36.547  66.314  1.00 29.81           O  
ATOM    444  CB  ALA A  58      26.451  35.736  65.211  1.00 27.72           C  
ATOM    445  N   PRO A  59      23.348  34.790  64.910  1.00 26.51           N  
ATOM    446  CA  PRO A  59      22.138  34.312  65.599  1.00 26.54           C  
ATOM    447  C   PRO A  59      22.417  33.561  66.893  1.00 25.87           C  
ATOM    448  O   PRO A  59      23.525  33.057  67.106  1.00 24.06           O  
ATOM    449  CB  PRO A  59      21.492  33.377  64.576  1.00 26.96           C  
ATOM    450  CG  PRO A  59      22.692  32.840  63.787  1.00 28.06           C  
ATOM    451  CD  PRO A  59      23.585  34.070  63.646  1.00 26.41           C  
ATOM    452  N   LEU A  60      21.416  33.460  67.765  1.00 24.55           N  
ATOM    453  CA  LEU A  60      21.647  32.671  68.970  1.00 26.39           C  
ATOM    454  C   LEU A  60      21.879  31.269  68.479  1.00 26.34           C  
ATOM    455  O   LEU A  60      21.325  30.878  67.443  1.00 26.34           O  
ATOM    456  CB  LEU A  60      20.428  32.650  69.892  1.00 27.64           C  
ATOM    457  CG  LEU A  60      20.165  33.915  70.686  1.00 28.16           C  
ATOM    458  CD1 LEU A  60      19.207  33.594  71.841  1.00 29.31           C  
ATOM    459  CD2 LEU A  60      21.456  34.448  71.243  1.00 27.61           C  
ATOM    460  N   GLY A  61      22.675  30.523  69.224  1.00 26.58           N  
ATOM    461  CA  GLY A  61      22.977  29.167  68.853  1.00 27.60           C  
ATOM    462  C   GLY A  61      24.250  29.080  68.010  1.00 27.58           C  
ATOM    463  O   GLY A  61      24.743  27.982  67.769  1.00 25.61           O  
ATOM    464  N   SER A  62      24.773  30.218  67.554  1.00 27.01           N  
ATOM    465  CA  SER A  62      26.018  30.204  66.785  1.00 25.97           C  
ATOM    466  C   SER A  62      27.114  29.563  67.625  1.00 26.35           C  
ATOM    467  O   SER A  62      27.203  29.786  68.847  1.00 25.41           O  
ATOM    468  CB  SER A  62      26.468  31.624  66.418  1.00 26.77           C  
ATOM    469  OG  SER A  62      25.518  32.327  65.648  1.00 27.68           O  
ATOM    470  N   ARG A  63      27.987  28.798  66.981  1.00 26.18           N  
ATOM    471  CA  ARG A  63      29.080  28.122  67.699  1.00 26.37           C  
ATOM    472  C   ARG A  63      30.388  28.814  67.371  1.00 26.94           C  
ATOM    473  O   ARG A  63      30.753  28.915  66.201  1.00 26.53           O  
ATOM    474  CB  ARG A  63      29.125  26.656  67.278  1.00 27.77           C  
ATOM    475  CG  ARG A  63      27.805  25.961  67.588  1.00 32.10           C  
ATOM    476  CD  ARG A  63      27.909  24.462  67.336  1.00 35.10           C  
ATOM    477  NE  ARG A  63      28.427  23.765  68.509  1.00 37.59           N  
ATOM    478  CZ  ARG A  63      27.704  23.489  69.592  1.00 39.91           C  
ATOM    479  NH1 ARG A  63      26.431  23.848  69.652  1.00 40.67           N  
ATOM    480  NH2 ARG A  63      28.254  22.856  70.621  1.00 40.39           N  
ATOM    481  N   LEU A  64      31.087  29.312  68.385  1.00 24.44           N  
ATOM    482  CA  LEU A  64      32.324  30.037  68.131  1.00 23.92           C  
ATOM    483  C   LEU A  64      33.576  29.279  68.601  1.00 21.19           C  
ATOM    484  O   LEU A  64      33.510  28.470  69.519  1.00 21.73           O  
ATOM    485  CB  LEU A  64      32.252  31.425  68.805  1.00 25.91           C  
ATOM    486  CG  LEU A  64      31.017  32.299  68.499  1.00 28.85           C  
ATOM    487  CD1 LEU A  64      31.290  33.718  68.999  1.00 32.99           C  
ATOM    488  CD2 LEU A  64      30.705  32.352  67.001  1.00 30.93           C  
ATOM    489  N   PRO A  65      34.748  29.550  67.993  1.00 20.29           N  
ATOM    490  CA  PRO A  65      35.953  28.827  68.432  1.00 19.57           C  
ATOM    491  C   PRO A  65      36.434  29.322  69.800  1.00 18.96           C  
ATOM    492  O   PRO A  65      36.457  30.546  70.055  1.00 18.49           O  
ATOM    493  CB  PRO A  65      36.971  29.145  67.328  1.00 22.46           C  
ATOM    494  CG  PRO A  65      36.569  30.581  66.935  1.00 21.51           C  
ATOM    495  CD  PRO A  65      35.052  30.459  66.873  1.00 21.69           C  
ATOM    496  N   LEU A  66      36.825  28.405  70.683  1.00 16.26           N  
ATOM    497  CA  LEU A  66      37.268  28.837  72.005  1.00 19.52           C  
ATOM    498  C   LEU A  66      38.574  29.679  72.010  1.00 18.01           C  
ATOM    499  O   LEU A  66      38.735  30.585  72.834  1.00 19.69           O  
ATOM    500  CB  LEU A  66      37.460  27.606  72.888  1.00 20.18           C  
ATOM    501  CG  LEU A  66      36.511  27.231  74.032  1.00 28.70           C  
ATOM    502  CD1 LEU A  66      35.165  27.900  73.954  1.00 26.87           C  
ATOM    503  CD2 LEU A  66      36.421  25.712  74.059  1.00 25.42           C  
ATOM    504  N   HIS A  67      39.487  29.387  71.074  1.00 17.25           N  
ATOM    505  CA  HIS A  67      40.753  30.056  71.051  1.00 17.69           C  
ATOM    506  C   HIS A  67      40.831  31.312  70.223  1.00 16.35           C  
ATOM    507  O   HIS A  67      41.841  32.016  70.297  1.00 19.42           O  
ATOM    508  CB  HIS A  67      41.819  29.085  70.515  1.00 19.54           C  
ATOM    509  CG  HIS A  67      41.495  28.603  69.149  1.00 18.38           C  
ATOM    510  ND1 HIS A  67      42.128  29.073  68.014  1.00 21.12           N  
ATOM    511  CD2 HIS A  67      40.502  27.789  68.722  1.00 16.31           C  
ATOM    512  CE1 HIS A  67      41.528  28.565  66.948  1.00 18.79           C  
ATOM    513  NE2 HIS A  67      40.538  27.788  67.357  1.00 22.31           N  
ATOM    514  N   ALA A  68      39.794  31.576  69.448  1.00 20.00           N  
ATOM    515  CA  ALA A  68      39.801  32.698  68.531  1.00 20.96           C  
ATOM    516  C   ALA A  68      38.744  33.791  68.661  1.00 21.97           C  
ATOM    517  O   ALA A  68      38.813  34.780  67.914  1.00 24.61           O  
ATOM    518  CB  ALA A  68      39.788  32.152  67.111  1.00 20.50           C  
ATOM    519  N   SER A  69      37.748  33.614  69.535  1.00 21.22           N  
ATOM    520  CA  SER A  69      36.717  34.638  69.719  1.00 18.66           C  
ATOM    521  C   SER A  69      36.908  35.185  71.127  1.00 19.09           C  
ATOM    522  O   SER A  69      37.460  34.506  72.003  1.00 16.84           O  
ATOM    523  CB  SER A  69      35.322  34.021  69.580  1.00 18.01           C  
ATOM    524  OG  SER A  69      35.155  32.965  70.486  1.00 19.69           O  
ATOM    525  N   GLY A  70      36.491  36.418  71.343  1.00 18.60           N  
ATOM    526  CA  GLY A  70      36.639  37.009  72.650  1.00 19.76           C  
ATOM    527  C   GLY A  70      35.848  36.188  73.647  1.00 19.32           C  
ATOM    528  O   GLY A  70      36.330  35.912  74.759  1.00 20.11           O  
ATOM    529  N   ALA A  71      34.632  35.844  73.263  1.00 20.03           N  
ATOM    530  CA  ALA A  71      33.737  35.088  74.139  1.00 20.60           C  
ATOM    531  C   ALA A  71      34.407  33.767  74.497  1.00 20.67           C  
ATOM    532  O   ALA A  71      34.430  33.372  75.661  1.00 15.72           O  
ATOM    533  CB  ALA A  71      32.407  34.842  73.448  1.00 21.80           C  
ATOM    534  N   GLY A  72      34.975  33.093  73.484  1.00 18.93           N  
ATOM    535  CA  GLY A  72      35.668  31.827  73.759  1.00 18.46           C  
ATOM    536  C   GLY A  72      36.843  31.942  74.711  1.00 18.80           C  
ATOM    537  O   GLY A  72      37.017  31.115  75.598  1.00 20.03           O  
ATOM    538  N   LYS A  73      37.665  32.972  74.523  1.00 19.44           N  
ATOM    539  CA  LYS A  73      38.815  33.160  75.344  1.00 17.22           C  
ATOM    540  C   LYS A  73      38.428  33.471  76.778  1.00 18.26           C  
ATOM    541  O   LYS A  73      39.151  33.106  77.680  1.00 17.30           O  
ATOM    542  CB  LYS A  73      39.733  34.236  74.756  1.00 17.85           C  
ATOM    543  CG  LYS A  73      40.312  33.790  73.412  1.00 15.33           C  
ATOM    544  CD  LYS A  73      41.497  34.647  72.941  1.00 17.31           C  
ATOM    545  CE  LYS A  73      41.037  36.032  72.477  1.00 23.07           C  
ATOM    546  NZ  LYS A  73      42.192  36.916  72.068  1.00 23.62           N  
ATOM    547  N   ALA A  74      37.272  34.090  76.959  1.00 16.62           N  
ATOM    548  CA  ALA A  74      36.804  34.414  78.309  1.00 18.62           C  
ATOM    549  C   ALA A  74      36.384  33.118  79.023  1.00 18.02           C  
ATOM    550  O   ALA A  74      36.472  33.029  80.245  1.00 17.99           O  
ATOM    551  CB  ALA A  74      35.640  35.384  78.254  1.00 21.02           C  
ATOM    552  N   LEU A  75      35.958  32.116  78.257  1.00 17.90           N  
ATOM    553  CA  LEU A  75      35.632  30.826  78.861  1.00 17.57           C  
ATOM    554  C   LEU A  75      36.904  30.054  79.186  1.00 19.40           C  
ATOM    555  O   LEU A  75      36.922  29.184  80.094  1.00 19.16           O  
ATOM    556  CB  LEU A  75      34.722  30.029  77.923  1.00 17.70           C  
ATOM    557  CG  LEU A  75      33.360  30.698  77.638  1.00 19.14           C  
ATOM    558  CD1 LEU A  75      32.650  30.031  76.427  1.00 20.60           C  
ATOM    559  CD2 LEU A  75      32.472  30.568  78.894  1.00 20.77           C  
ATOM    560  N   LEU A  76      37.991  30.362  78.456  1.00 18.81           N  
ATOM    561  CA  LEU A  76      39.287  29.703  78.679  1.00 20.26           C  
ATOM    562  C   LEU A  76      40.226  30.320  79.729  1.00 19.66           C  
ATOM    563  O   LEU A  76      40.875  29.586  80.471  1.00 18.98           O  
ATOM    564  CB  LEU A  76      40.090  29.640  77.366  1.00 19.16           C  
ATOM    565  CG  LEU A  76      39.540  28.876  76.176  1.00 19.32           C  
ATOM    566  CD1 LEU A  76      40.557  28.945  75.044  1.00 19.90           C  
ATOM    567  CD2 LEU A  76      39.292  27.434  76.593  1.00 21.09           C  
ATOM    568  N   TYR A  77      40.288  31.647  79.837  1.00 17.81           N  
ATOM    569  CA  TYR A  77      41.302  32.167  80.732  1.00 19.32           C  
ATOM    570  C   TYR A  77      41.256  31.769  82.207  1.00 20.57           C  
ATOM    571  O   TYR A  77      42.287  31.721  82.845  1.00 20.07           O  
ATOM    572  CB  TYR A  77      41.536  33.689  80.537  1.00 20.40           C  
ATOM    573  CG  TYR A  77      40.492  34.643  81.097  1.00 20.42           C  
ATOM    574  CD1 TYR A  77      40.331  34.814  82.467  1.00 18.21           C  
ATOM    575  CD2 TYR A  77      39.711  35.412  80.246  1.00 17.46           C  
ATOM    576  CE1 TYR A  77      39.420  35.730  82.962  1.00 18.74           C  
ATOM    577  CE2 TYR A  77      38.793  36.349  80.735  1.00 19.61           C  
ATOM    578  CZ  TYR A  77      38.654  36.503  82.091  1.00 19.18           C  
ATOM    579  OH  TYR A  77      37.745  37.438  82.581  1.00 19.45           O  
ATOM    580  N   PRO A  78      40.060  31.411  82.744  1.00 20.81           N  
ATOM    581  CA  PRO A  78      40.042  31.031  84.164  1.00 21.93           C  
ATOM    582  C   PRO A  78      40.511  29.606  84.425  1.00 23.41           C  
ATOM    583  O   PRO A  78      40.732  29.232  85.576  1.00 24.20           O  
ATOM    584  CB  PRO A  78      38.568  31.168  84.557  1.00 21.46           C  
ATOM    585  CG  PRO A  78      37.986  32.164  83.581  1.00 21.72           C  
ATOM    586  CD  PRO A  78      38.710  31.772  82.263  1.00 19.96           C  
ATOM    587  N   LEU A  79      40.611  28.811  83.363  1.00 24.22           N  
ATOM    588  CA  LEU A  79      40.971  27.408  83.464  1.00 25.34           C  
ATOM    589  C   LEU A  79      42.445  27.114  83.713  1.00 27.08           C  
ATOM    590  O   LEU A  79      43.344  27.905  83.381  1.00 24.61           O  
ATOM    591  CB  LEU A  79      40.497  26.674  82.191  1.00 24.21           C  
ATOM    592  CG  LEU A  79      39.009  26.818  81.814  1.00 24.99           C  
ATOM    593  CD1 LEU A  79      38.719  26.022  80.567  1.00 23.44           C  
ATOM    594  CD2 LEU A  79      38.098  26.352  82.965  1.00 26.98           C  
ATOM    595  N   ALA A  80      42.686  25.968  84.343  1.00 29.09           N  
ATOM    596  CA  ALA A  80      44.055  25.555  84.610  1.00 31.07           C  
ATOM    597  C   ALA A  80      44.674  25.127  83.274  1.00 31.75           C  
ATOM    598  O   ALA A  80      43.990  24.589  82.387  1.00 29.09           O  
ATOM    599  CB  ALA A  80      44.081  24.365  85.618  1.00 32.22           C  
ATOM    600  N   GLU A  81      45.964  25.394  83.145  1.00 31.93           N  
ATOM    601  CA  GLU A  81      46.694  25.056  81.943  1.00 33.71           C  
ATOM    602  C   GLU A  81      46.483  23.615  81.489  1.00 32.32           C  
ATOM    603  O   GLU A  81      46.453  23.349  80.293  1.00 31.78           O  
ATOM    604  CB  GLU A  81      48.189  25.317  82.146  1.00 35.65           C  
ATOM    605  CG  GLU A  81      48.970  25.226  80.834  1.00 39.11           C  
ATOM    606  CD  GLU A  81      50.425  25.679  80.942  1.00 41.31           C  
ATOM    607  OE1 GLU A  81      50.686  26.789  81.454  1.00 43.73           O  
ATOM    608  OE2 GLU A  81      51.310  24.929  80.489  1.00 41.86           O  
ATOM    609  N   GLU A  82      46.316  22.686  82.429  1.00 32.94           N  
ATOM    610  CA  GLU A  82      46.134  21.279  82.060  1.00 31.98           C  
ATOM    611  C   GLU A  82      44.810  21.050  81.329  1.00 31.39           C  
ATOM    612  O   GLU A  82      44.725  20.244  80.367  1.00 27.47           O  
ATOM    613  CB  GLU A  82      46.217  20.389  83.301  1.00 36.50           C  
ATOM    614  CG  GLU A  82      46.833  19.017  83.040  1.00 41.14           C  
ATOM    615  CD  GLU A  82      48.210  19.115  82.370  1.00 43.07           C  
ATOM    616  OE1 GLU A  82      49.167  19.594  83.009  1.00 45.46           O  
ATOM    617  OE2 GLU A  82      48.327  18.725  81.192  1.00 44.87           O  
ATOM    618  N   GLU A  83      43.769  21.752  81.776  1.00 28.23           N  
ATOM    619  CA  GLU A  83      42.469  21.630  81.132  1.00 27.86           C  
ATOM    620  C   GLU A  83      42.593  22.291  79.742  1.00 26.78           C  
ATOM    621  O   GLU A  83      42.089  21.776  78.745  1.00 26.02           O  
ATOM    622  CB  GLU A  83      41.396  22.335  81.981  1.00 30.45           C  
ATOM    623  CG  GLU A  83      39.995  22.390  81.336  1.00 31.94           C  
ATOM    624  CD  GLU A  83      39.386  21.006  81.066  1.00 34.51           C  
ATOM    625  OE1 GLU A  83      39.902  20.005  81.609  1.00 32.07           O  
ATOM    626  OE2 GLU A  83      38.382  20.930  80.311  1.00 34.78           O  
ATOM    627  N   LEU A  84      43.280  23.430  79.684  1.00 25.36           N  
ATOM    628  CA  LEU A  84      43.485  24.119  78.408  1.00 26.14           C  
ATOM    629  C   LEU A  84      44.196  23.187  77.421  1.00 25.28           C  
ATOM    630  O   LEU A  84      43.853  23.122  76.245  1.00 25.27           O  
ATOM    631  CB  LEU A  84      44.340  25.366  78.616  1.00 27.57           C  
ATOM    632  CG  LEU A  84      43.660  26.721  78.607  1.00 32.34           C  
ATOM    633  CD1 LEU A  84      42.233  26.627  79.119  1.00 33.17           C  
ATOM    634  CD2 LEU A  84      44.502  27.696  79.438  1.00 32.56           C  
ATOM    635  N   MET A  85      45.217  22.500  77.914  1.00 26.26           N  
ATOM    636  CA  MET A  85      45.974  21.562  77.091  1.00 27.12           C  
ATOM    637  C   MET A  85      45.053  20.458  76.584  1.00 26.99           C  
ATOM    638  O   MET A  85      45.156  20.041  75.428  1.00 27.93           O  
ATOM    639  CB  MET A  85      47.129  20.978  77.911  1.00 27.44           C  
ATOM    640  CG  MET A  85      48.229  22.001  78.219  1.00 33.14           C  
ATOM    641  SD  MET A  85      49.184  22.514  76.761  1.00 35.91           S  
ATOM    642  CE  MET A  85      50.770  21.736  77.135  1.00 38.03           C  
ATOM    643  N   SER A  86      44.136  20.004  77.435  1.00 27.15           N  
ATOM    644  CA  SER A  86      43.175  18.951  77.059  1.00 29.19           C  
ATOM    645  C   SER A  86      42.230  19.403  75.968  1.00 27.64           C  
ATOM    646  O   SER A  86      41.908  18.669  75.032  1.00 27.16           O  
ATOM    647  CB  SER A  86      42.304  18.542  78.250  1.00 30.17           C  
ATOM    648  OG  SER A  86      42.860  17.453  78.935  1.00 35.01           O  
ATOM    649  N   ILE A  87      41.751  20.630  76.120  1.00 26.63           N  
ATOM    650  CA  ILE A  87      40.820  21.169  75.170  1.00 25.58           C  
ATOM    651  C   ILE A  87      41.465  21.335  73.817  1.00 23.42           C  
ATOM    652  O   ILE A  87      40.919  20.892  72.812  1.00 25.46           O  
ATOM    653  CB  ILE A  87      40.247  22.544  75.634  1.00 25.73           C  
ATOM    654  CG1 ILE A  87      39.442  22.370  76.926  1.00 24.16           C  
ATOM    655  CG2 ILE A  87      39.343  23.114  74.526  1.00 25.51           C  
ATOM    656  CD1 ILE A  87      39.061  23.713  77.631  1.00 24.00           C  
ATOM    657  N   ILE A  88      42.629  21.968  73.789  1.00 25.25           N  
ATOM    658  CA  ILE A  88      43.310  22.221  72.535  1.00 25.11           C  
ATOM    659  C   ILE A  88      43.752  20.936  71.864  1.00 26.71           C  
ATOM    660  O   ILE A  88      43.752  20.861  70.633  1.00 25.99           O  
ATOM    661  CB  ILE A  88      44.494  23.172  72.727  1.00 24.29           C  
ATOM    662  CG1 ILE A  88      43.983  24.476  73.376  1.00 24.39           C  
ATOM    663  CG2 ILE A  88      45.126  23.513  71.386  1.00 25.40           C  
ATOM    664  CD1 ILE A  88      42.769  25.042  72.631  1.00 22.34           C  
ATOM    665  N   LEU A  89      44.109  19.923  72.657  1.00 26.90           N  
ATOM    666  CA  LEU A  89      44.520  18.652  72.044  1.00 29.87           C  
ATOM    667  C   LEU A  89      43.392  18.169  71.128  1.00 30.21           C  
ATOM    668  O   LEU A  89      43.638  17.654  70.022  1.00 31.36           O  
ATOM    669  CB  LEU A  89      44.803  17.603  73.121  1.00 29.23           C  
ATOM    670  CG  LEU A  89      45.141  16.189  72.617  1.00 30.66           C  
ATOM    671  CD1 LEU A  89      46.236  16.218  71.538  1.00 30.37           C  
ATOM    672  CD2 LEU A  89      45.616  15.380  73.815  1.00 30.80           C  
ATOM    673  N   GLN A  90      42.156  18.359  71.582  1.00 31.19           N  
ATOM    674  CA  GLN A  90      41.000  17.934  70.799  1.00 32.65           C  
ATOM    675  C   GLN A  90      40.517  18.927  69.737  1.00 30.79           C  
ATOM    676  O   GLN A  90      40.132  18.521  68.653  1.00 31.09           O  
ATOM    677  CB  GLN A  90      39.849  17.595  71.723  1.00 34.46           C  
ATOM    678  CG  GLN A  90      40.221  16.604  72.767  1.00 39.98           C  
ATOM    679  CD  GLN A  90      39.007  15.915  73.325  1.00 44.55           C  
ATOM    680  OE1 GLN A  90      38.092  16.572  73.845  1.00 47.22           O  
ATOM    681  NE2 GLN A  90      38.972  14.576  73.213  1.00 46.10           N  
ATOM    682  N   THR A  91      40.517  20.224  70.031  1.00 28.21           N  
ATOM    683  CA  THR A  91      40.062  21.158  69.013  1.00 27.18           C  
ATOM    684  C   THR A  91      41.110  21.550  67.982  1.00 26.87           C  
ATOM    685  O   THR A  91      40.788  21.823  66.818  1.00 28.64           O  
ATOM    686  CB  THR A  91      39.577  22.470  69.622  1.00 26.40           C  
ATOM    687  OG1 THR A  91      40.704  23.154  70.156  1.00 24.90           O  
ATOM    688  CG2 THR A  91      38.528  22.211  70.701  1.00 27.32           C  
ATOM    689  N   GLY A  92      42.359  21.602  68.411  1.00 27.03           N  
ATOM    690  CA  GLY A  92      43.420  22.062  67.546  1.00 27.28           C  
ATOM    691  C   GLY A  92      43.294  23.576  67.610  1.00 27.79           C  
ATOM    692  O   GLY A  92      42.504  24.094  68.414  1.00 27.88           O  
ATOM    693  N   LEU A  93      44.070  24.296  66.804  1.00 27.72           N  
ATOM    694  CA  LEU A  93      44.006  25.761  66.780  1.00 26.22           C  
ATOM    695  C   LEU A  93      43.774  26.232  65.341  1.00 26.80           C  
ATOM    696  O   LEU A  93      44.664  26.826  64.690  1.00 26.69           O  
ATOM    697  CB  LEU A  93      45.300  26.357  67.322  1.00 25.58           C  
ATOM    698  CG  LEU A  93      45.621  26.072  68.797  1.00 25.10           C  
ATOM    699  CD1 LEU A  93      47.023  26.519  69.132  1.00 27.18           C  
ATOM    700  CD2 LEU A  93      44.593  26.804  69.677  1.00 23.67           C  
ATOM    701  N   GLN A  94      42.576  25.960  64.848  1.00 26.09           N  
ATOM    702  CA  GLN A  94      42.211  26.340  63.488  1.00 27.93           C  
ATOM    703  C   GLN A  94      42.454  27.822  63.268  1.00 28.47           C  
ATOM    704  O   GLN A  94      42.145  28.638  64.144  1.00 26.06           O  
ATOM    705  CB  GLN A  94      40.735  26.041  63.260  1.00 33.10           C  
ATOM    706  CG  GLN A  94      40.150  26.686  62.039  1.00 37.09           C  
ATOM    707  CD  GLN A  94      40.026  25.721  60.920  1.00 42.78           C  
ATOM    708  OE1 GLN A  94      40.974  24.994  60.606  1.00 47.42           O  
ATOM    709  NE2 GLN A  94      38.858  25.693  60.289  1.00 46.03           N  
ATOM    710  N   GLN A  95      42.988  28.183  62.103  1.00 27.59           N  
ATOM    711  CA  GLN A  95      43.220  29.588  61.810  1.00 27.90           C  
ATOM    712  C   GLN A  95      41.980  30.126  61.116  1.00 27.94           C  
ATOM    713  O   GLN A  95      41.488  29.502  60.177  1.00 27.69           O  
ATOM    714  CB  GLN A  95      44.438  29.747  60.903  1.00 27.98           C  
ATOM    715  CG  GLN A  95      44.763  31.199  60.569  1.00 29.27           C  
ATOM    716  CD  GLN A  95      45.945  31.333  59.608  1.00 31.08           C  
ATOM    717  OE1 GLN A  95      46.135  32.370  58.973  1.00 30.73           O  
ATOM    718  NE2 GLN A  95      46.741  30.287  59.514  1.00 30.40           N  
ATOM    719  N   PHE A  96      41.455  31.266  61.576  1.00 23.85           N  
ATOM    720  CA  PHE A  96      40.259  31.833  60.959  1.00 23.45           C  
ATOM    721  C   PHE A  96      40.537  33.103  60.188  1.00 23.53           C  
ATOM    722  O   PHE A  96      39.816  33.419  59.257  1.00 24.42           O  
ATOM    723  CB  PHE A  96      39.191  32.144  62.001  1.00 23.01           C  
ATOM    724  CG  PHE A  96      38.612  30.935  62.640  1.00 21.76           C  
ATOM    725  CD1 PHE A  96      39.245  30.343  63.722  1.00 23.96           C  
ATOM    726  CD2 PHE A  96      37.470  30.346  62.117  1.00 26.81           C  
ATOM    727  CE1 PHE A  96      38.754  29.169  64.285  1.00 25.43           C  
ATOM    728  CE2 PHE A  96      36.955  29.167  62.664  1.00 29.00           C  
ATOM    729  CZ  PHE A  96      37.601  28.575  63.750  1.00 27.55           C  
ATOM    730  N   THR A  97      41.572  33.829  60.595  1.00 23.30           N  
ATOM    731  CA  THR A  97      41.943  35.073  59.932  1.00 21.37           C  
ATOM    732  C   THR A  97      43.456  35.139  59.919  1.00 20.53           C  
ATOM    733  O   THR A  97      44.154  34.297  60.516  1.00 22.42           O  
ATOM    734  CB  THR A  97      41.414  36.311  60.689  1.00 21.59           C  
ATOM    735  OG1 THR A  97      42.224  36.521  61.849  1.00 21.17           O  
ATOM    736  CG2 THR A  97      39.967  36.086  61.096  1.00 22.72           C  
ATOM    737  N   PRO A  98      44.006  36.168  59.267  1.00 22.81           N  
ATOM    738  CA  PRO A  98      45.469  36.187  59.275  1.00 23.51           C  
ATOM    739  C   PRO A  98      46.136  36.362  60.632  1.00 24.58           C  
ATOM    740  O   PRO A  98      47.285  35.972  60.807  1.00 25.56           O  
ATOM    741  CB  PRO A  98      45.825  37.279  58.253  1.00 24.51           C  
ATOM    742  CG  PRO A  98      44.570  38.119  58.122  1.00 28.10           C  
ATOM    743  CD  PRO A  98      43.428  37.149  58.319  1.00 24.61           C  
ATOM    744  N   THR A  99      45.400  36.873  61.632  1.00 23.61           N  
ATOM    745  CA  THR A  99      46.026  37.058  62.943  1.00 23.54           C  
ATOM    746  C   THR A  99      45.509  36.148  64.074  1.00 21.30           C  
ATOM    747  O   THR A  99      45.780  36.387  65.242  1.00 23.29           O  
ATOM    748  CB  THR A  99      45.948  38.534  63.386  1.00 23.04           C  
ATOM    749  OG1 THR A  99      44.581  38.888  63.549  1.00 25.13           O  
ATOM    750  CG2 THR A  99      46.568  39.455  62.304  1.00 24.44           C  
ATOM    751  N   THR A 100      44.767  35.108  63.737  1.00 21.45           N  
ATOM    752  CA  THR A 100      44.291  34.180  64.764  1.00 21.65           C  
ATOM    753  C   THR A 100      45.506  33.661  65.554  1.00 23.15           C  
ATOM    754  O   THR A 100      46.604  33.521  65.000  1.00 24.55           O  
ATOM    755  CB  THR A 100      43.576  32.935  64.105  1.00 19.23           C  
ATOM    756  OG1 THR A 100      42.464  33.379  63.322  1.00 19.26           O  
ATOM    757  CG2 THR A 100      43.135  31.934  65.179  1.00 18.08           C  
ATOM    758  N   LEU A 101      45.325  33.372  66.837  1.00 23.33           N  
ATOM    759  CA  LEU A 101      46.394  32.787  67.626  1.00 25.30           C  
ATOM    760  C   LEU A 101      46.362  31.313  67.310  1.00 26.93           C  
ATOM    761  O   LEU A 101      45.382  30.638  67.632  1.00 27.07           O  
ATOM    762  CB  LEU A 101      46.139  32.977  69.126  1.00 25.06           C  
ATOM    763  CG  LEU A 101      46.085  34.459  69.517  1.00 27.60           C  
ATOM    764  CD1 LEU A 101      45.769  34.646  71.020  1.00 28.98           C  
ATOM    765  CD2 LEU A 101      47.417  35.095  69.121  1.00 30.72           C  
ATOM    766  N   VAL A 102      47.414  30.803  66.680  1.00 28.54           N  
ATOM    767  CA  VAL A 102      47.430  29.391  66.327  1.00 31.00           C  
ATOM    768  C   VAL A 102      48.554  28.591  66.963  1.00 32.12           C  
ATOM    769  O   VAL A 102      48.863  27.489  66.506  1.00 33.80           O  
ATOM    770  CB  VAL A 102      47.504  29.225  64.798  1.00 30.85           C  
ATOM    771  CG1 VAL A 102      46.222  29.737  64.158  1.00 29.51           C  
ATOM    772  CG2 VAL A 102      48.701  29.973  64.267  1.00 32.68           C  
ATOM    773  N   ASP A 103      49.149  29.136  68.018  1.00 32.44           N  
ATOM    774  CA  ASP A 103      50.233  28.480  68.732  1.00 32.69           C  
ATOM    775  C   ASP A 103      49.911  28.518  70.199  1.00 31.16           C  
ATOM    776  O   ASP A 103      49.449  29.529  70.717  1.00 27.85           O  
ATOM    777  CB  ASP A 103      51.564  29.189  68.465  1.00 37.81           C  
ATOM    778  CG  ASP A 103      51.808  29.390  66.984  1.00 41.81           C  
ATOM    779  OD1 ASP A 103      51.379  28.515  66.188  1.00 45.25           O  
ATOM    780  OD2 ASP A 103      52.429  30.401  66.604  1.00 44.04           O  
ATOM    781  N   MET A 104      50.162  27.405  70.868  1.00 29.36           N  
ATOM    782  CA  MET A 104      49.849  27.291  72.276  1.00 29.43           C  
ATOM    783  C   MET A 104      50.559  28.317  73.159  1.00 29.41           C  
ATOM    784  O   MET A 104      49.980  28.842  74.121  1.00 28.27           O  
ATOM    785  CB  MET A 104      50.175  25.870  72.744  1.00 30.89           C  
ATOM    786  CG  MET A 104      49.457  25.442  74.007  1.00 33.72           C  
ATOM    787  SD  MET A 104      47.660  25.582  73.868  1.00 31.94           S  
ATOM    788  CE  MET A 104      47.200  25.570  75.648  1.00 32.85           C  
ATOM    789  N   PRO A 105      51.843  28.605  72.884  1.00 29.40           N  
ATOM    790  CA  PRO A 105      52.473  29.600  73.771  1.00 28.72           C  
ATOM    791  C   PRO A 105      51.872  31.004  73.683  1.00 26.57           C  
ATOM    792  O   PRO A 105      51.715  31.682  74.707  1.00 27.07           O  
ATOM    793  CB  PRO A 105      53.948  29.583  73.333  1.00 31.05           C  
ATOM    794  CG  PRO A 105      54.148  28.162  72.933  1.00 31.03           C  
ATOM    795  CD  PRO A 105      52.866  27.817  72.166  1.00 31.04           C  
ATOM    796  N   THR A 106      51.541  31.441  72.474  1.00 24.20           N  
ATOM    797  CA  THR A 106      50.983  32.771  72.285  1.00 24.91           C  
ATOM    798  C   THR A 106      49.574  32.833  72.886  1.00 24.55           C  
ATOM    799  O   THR A 106      49.183  33.826  73.517  1.00 25.23           O  
ATOM    800  CB  THR A 106      50.957  33.113  70.797  1.00 27.66           C  
ATOM    801  OG1 THR A 106      52.274  32.902  70.248  1.00 33.34           O  
ATOM    802  CG2 THR A 106      50.605  34.536  70.617  1.00 28.14           C  
ATOM    803  N   LEU A 107      48.822  31.758  72.701  1.00 23.58           N  
ATOM    804  CA  LEU A 107      47.474  31.662  73.243  1.00 23.03           C  
ATOM    805  C   LEU A 107      47.555  31.763  74.767  1.00 23.28           C  
ATOM    806  O   LEU A 107      46.833  32.568  75.374  1.00 23.24           O  
ATOM    807  CB  LEU A 107      46.863  30.307  72.870  1.00 21.80           C  
ATOM    808  CG  LEU A 107      45.346  30.170  72.748  1.00 27.17           C  
ATOM    809  CD1 LEU A 107      44.909  28.901  73.411  1.00 25.25           C  
ATOM    810  CD2 LEU A 107      44.582  31.357  73.305  1.00 23.71           C  
ATOM    811  N   LEU A 108      48.436  30.959  75.379  1.00 22.93           N  
ATOM    812  CA  LEU A 108      48.594  30.973  76.842  1.00 25.39           C  
ATOM    813  C   LEU A 108      49.036  32.348  77.325  1.00 24.30           C  
ATOM    814  O   LEU A 108      48.560  32.820  78.352  1.00 22.78           O  
ATOM    815  CB  LEU A 108      49.603  29.902  77.299  1.00 26.42           C  
ATOM    816  CG  LEU A 108      49.114  28.442  77.272  1.00 28.28           C  
ATOM    817  CD1 LEU A 108      50.219  27.531  77.832  1.00 29.31           C  
ATOM    818  CD2 LEU A 108      47.844  28.298  78.129  1.00 28.16           C  
ATOM    819  N   LYS A 109      49.934  32.992  76.585  1.00 24.46           N  
ATOM    820  CA  LYS A 109      50.370  34.330  76.965  1.00 26.18           C  
ATOM    821  C   LYS A 109      49.166  35.296  76.950  1.00 25.14           C  
ATOM    822  O   LYS A 109      49.022  36.173  77.824  1.00 24.29           O  
ATOM    823  CB  LYS A 109      51.408  34.842  75.975  1.00 28.16           C  
ATOM    824  CG  LYS A 109      52.018  36.171  76.377  1.00 32.33           C  
ATOM    825  CD  LYS A 109      52.611  36.068  77.777  1.00 37.04           C  
ATOM    826  CE  LYS A 109      53.704  34.983  77.889  1.00 39.48           C  
ATOM    827  NZ  LYS A 109      55.066  35.445  77.415  1.00 41.38           N  
ATOM    828  N   ASP A 110      48.337  35.161  75.921  1.00 22.84           N  
ATOM    829  CA  ASP A 110      47.165  36.005  75.794  1.00 23.56           C  
ATOM    830  C   ASP A 110      46.162  35.736  76.926  1.00 22.87           C  
ATOM    831  O   ASP A 110      45.583  36.693  77.484  1.00 21.89           O  
ATOM    832  CB  ASP A 110      46.494  35.780  74.438  1.00 24.27           C  
ATOM    833  CG  ASP A 110      45.423  36.814  74.159  1.00 24.90           C  
ATOM    834  OD1 ASP A 110      45.761  38.000  73.942  1.00 27.64           O  
ATOM    835  OD2 ASP A 110      44.249  36.441  74.209  1.00 23.54           O  
ATOM    836  N   LEU A 111      45.955  34.457  77.285  1.00 21.95           N  
ATOM    837  CA  LEU A 111      44.987  34.148  78.358  1.00 22.59           C  
ATOM    838  C   LEU A 111      45.518  34.619  79.715  1.00 24.02           C  
ATOM    839  O   LEU A 111      44.738  35.068  80.563  1.00 21.19           O  
ATOM    840  CB  LEU A 111      44.645  32.656  78.387  1.00 22.92           C  
ATOM    841  CG  LEU A 111      44.034  32.125  77.073  1.00 22.72           C  
ATOM    842  CD1 LEU A 111      43.879  30.619  77.180  1.00 23.92           C  
ATOM    843  CD2 LEU A 111      42.669  32.784  76.760  1.00 21.28           C  
ATOM    844  N   GLU A 112      46.836  34.525  79.918  1.00 23.82           N  
ATOM    845  CA  GLU A 112      47.423  34.995  81.170  1.00 25.61           C  
ATOM    846  C   GLU A 112      47.163  36.513  81.313  1.00 23.68           C  
ATOM    847  O   GLU A 112      46.867  36.989  82.412  1.00 23.90           O  
ATOM    848  CB  GLU A 112      48.923  34.709  81.207  1.00 30.36           C  
ATOM    849  CG  GLU A 112      49.237  33.255  81.564  1.00 35.73           C  
ATOM    850  CD  GLU A 112      50.672  32.877  81.252  1.00 39.26           C  
ATOM    851  OE1 GLU A 112      51.574  33.674  81.602  1.00 43.44           O  
ATOM    852  OE2 GLU A 112      50.901  31.787  80.669  1.00 41.89           O  
ATOM    853  N   GLN A 113      47.262  37.261  80.207  1.00 23.25           N  
ATOM    854  CA  GLN A 113      47.022  38.694  80.261  1.00 24.13           C  
ATOM    855  C   GLN A 113      45.564  38.989  80.616  1.00 22.48           C  
ATOM    856  O   GLN A 113      45.283  39.853  81.453  1.00 21.59           O  
ATOM    857  CB  GLN A 113      47.403  39.380  78.927  1.00 25.88           C  
ATOM    858  CG  GLN A 113      47.147  40.915  78.932  1.00 29.69           C  
ATOM    859  CD  GLN A 113      47.847  41.653  77.782  1.00 30.96           C  
ATOM    860  OE1 GLN A 113      48.961  41.306  77.401  1.00 33.61           O  
ATOM    861  NE2 GLN A 113      47.209  42.693  77.265  1.00 30.36           N  
ATOM    862  N   ALA A 114      44.643  38.238  80.015  1.00 21.34           N  
ATOM    863  CA  ALA A 114      43.210  38.422  80.273  1.00 20.41           C  
ATOM    864  C   ALA A 114      42.883  38.109  81.734  1.00 20.70           C  
ATOM    865  O   ALA A 114      42.048  38.782  82.365  1.00 20.57           O  
ATOM    866  CB  ALA A 114      42.404  37.518  79.335  1.00 23.18           C  
ATOM    867  N   ARG A 115      43.552  37.109  82.294  1.00 21.28           N  
ATOM    868  CA  ARG A 115      43.309  36.760  83.688  1.00 23.11           C  
ATOM    869  C   ARG A 115      43.793  37.897  84.610  1.00 23.82           C  
ATOM    870  O   ARG A 115      43.178  38.194  85.643  1.00 23.60           O  
ATOM    871  CB  ARG A 115      44.001  35.430  83.996  1.00 27.00           C  
ATOM    872  CG  ARG A 115      43.809  34.919  85.374  1.00 29.13           C  
ATOM    873  CD  ARG A 115      44.113  33.422  85.411  1.00 33.08           C  
ATOM    874  NE  ARG A 115      44.160  32.944  86.777  1.00 37.73           N  
ATOM    875  CZ  ARG A 115      44.058  31.669  87.124  1.00 38.89           C  
ATOM    876  NH1 ARG A 115      43.898  30.737  86.182  1.00 40.31           N  
ATOM    877  NH2 ARG A 115      44.124  31.335  88.412  1.00 40.75           N  
ATOM    878  N   GLU A 116      44.882  38.549  84.243  1.00 22.14           N  
ATOM    879  CA  GLU A 116      45.382  39.679  85.036  1.00 23.85           C  
ATOM    880  C   GLU A 116      44.435  40.892  84.941  1.00 22.51           C  
ATOM    881  O   GLU A 116      44.115  41.547  85.936  1.00 22.83           O  
ATOM    882  CB  GLU A 116      46.788  40.087  84.548  1.00 24.52           C  
ATOM    883  CG  GLU A 116      47.342  41.385  85.153  1.00 30.13           C  
ATOM    884  CD  GLU A 116      47.425  41.351  86.676  1.00 34.76           C  
ATOM    885  OE1 GLU A 116      47.923  40.347  87.226  1.00 35.54           O  
ATOM    886  OE2 GLU A 116      46.994  42.337  87.326  1.00 36.81           O  
ATOM    887  N   LEU A 117      43.968  41.192  83.738  1.00 20.47           N  
ATOM    888  CA  LEU A 117      43.088  42.349  83.547  1.00 20.22           C  
ATOM    889  C   LEU A 117      41.610  42.107  83.834  1.00 20.00           C  
ATOM    890  O   LEU A 117      40.866  43.055  84.092  1.00 22.14           O  
ATOM    891  CB  LEU A 117      43.229  42.859  82.111  1.00 21.55           C  
ATOM    892  CG  LEU A 117      44.650  43.301  81.715  1.00 21.61           C  
ATOM    893  CD1 LEU A 117      44.640  43.688  80.239  1.00 24.07           C  
ATOM    894  CD2 LEU A 117      45.102  44.498  82.543  1.00 24.13           C  
ATOM    895  N   GLY A 118      41.185  40.850  83.789  1.00 20.32           N  
ATOM    896  CA  GLY A 118      39.780  40.550  83.994  1.00 20.19           C  
ATOM    897  C   GLY A 118      38.894  40.655  82.753  1.00 19.21           C  
ATOM    898  O   GLY A 118      37.686  40.698  82.849  1.00 18.28           O  
ATOM    899  N   TYR A 119      39.512  40.736  81.587  1.00 17.53           N  
ATOM    900  CA  TYR A 119      38.789  40.764  80.332  1.00 17.79           C  
ATOM    901  C   TYR A 119      39.736  40.380  79.236  1.00 17.81           C  
ATOM    902  O   TYR A 119      40.940  40.499  79.371  1.00 18.61           O  
ATOM    903  CB  TYR A 119      38.179  42.135  80.026  1.00 19.15           C  
ATOM    904  CG  TYR A 119      39.164  43.283  79.971  1.00 22.91           C  
ATOM    905  CD1 TYR A 119      39.872  43.563  78.807  1.00 21.92           C  
ATOM    906  CD2 TYR A 119      39.376  44.083  81.083  1.00 20.01           C  
ATOM    907  CE1 TYR A 119      40.780  44.615  78.747  1.00 23.09           C  
ATOM    908  CE2 TYR A 119      40.282  45.149  81.039  1.00 21.99           C  
ATOM    909  CZ  TYR A 119      40.981  45.399  79.859  1.00 23.71           C  
ATOM    910  OH  TYR A 119      41.895  46.416  79.759  1.00 22.38           O  
ATOM    911  N   THR A 120      39.173  39.886  78.145  1.00 17.63           N  
ATOM    912  CA  THR A 120      39.994  39.514  77.019  1.00 18.88           C  
ATOM    913  C   THR A 120      39.636  40.394  75.823  1.00 18.87           C  
ATOM    914  O   THR A 120      38.552  40.965  75.770  1.00 16.89           O  
ATOM    915  CB  THR A 120      39.721  38.081  76.660  1.00 20.87           C  
ATOM    916  OG1 THR A 120      40.741  37.645  75.752  1.00 27.14           O  
ATOM    917  CG2 THR A 120      38.303  37.975  76.060  1.00 19.09           C  
ATOM    918  N   VAL A 121      40.537  40.466  74.847  1.00 21.20           N  
ATOM    919  CA  VAL A 121      40.282  41.234  73.642  1.00 22.56           C  
ATOM    920  C   VAL A 121      40.561  40.335  72.437  1.00 24.34           C  
ATOM    921  O   VAL A 121      41.597  39.625  72.383  1.00 26.63           O  
ATOM    922  CB  VAL A 121      41.197  42.451  73.509  1.00 26.02           C  
ATOM    923  CG1 VAL A 121      40.856  43.169  72.201  1.00 25.74           C  
ATOM    924  CG2 VAL A 121      41.037  43.396  74.741  1.00 25.38           C  
ATOM    925  N   ASP A 122      39.612  40.338  71.513  1.00 23.12           N  
ATOM    926  CA  ASP A 122      39.676  39.577  70.265  1.00 23.70           C  
ATOM    927  C   ASP A 122      39.705  40.668  69.211  1.00 22.17           C  
ATOM    928  O   ASP A 122      38.717  41.343  68.997  1.00 21.61           O  
ATOM    929  CB  ASP A 122      38.402  38.715  70.150  1.00 25.19           C  
ATOM    930  CG  ASP A 122      38.053  38.313  68.703  1.00 24.29           C  
ATOM    931  OD1 ASP A 122      38.870  38.513  67.785  1.00 24.24           O  
ATOM    932  OD2 ASP A 122      36.932  37.797  68.513  1.00 25.25           O  
ATOM    933  N   LYS A 123      40.853  40.868  68.576  1.00 22.85           N  
ATOM    934  CA  LYS A 123      40.957  41.889  67.561  1.00 23.35           C  
ATOM    935  C   LYS A 123      41.069  41.188  66.213  1.00 23.42           C  
ATOM    936  O   LYS A 123      42.169  40.838  65.794  1.00 20.81           O  
ATOM    937  CB  LYS A 123      42.191  42.737  67.808  1.00 28.97           C  
ATOM    938  CG  LYS A 123      42.570  42.798  69.263  1.00 35.25           C  
ATOM    939  CD  LYS A 123      43.999  43.262  69.438  1.00 39.59           C  
ATOM    940  CE  LYS A 123      44.271  43.559  70.890  1.00 41.02           C  
ATOM    941  NZ  LYS A 123      45.527  44.300  71.003  1.00 43.25           N  
ATOM    942  N   GLU A 124      39.926  40.948  65.584  1.00 19.44           N  
ATOM    943  CA  GLU A 124      39.889  40.322  64.258  1.00 21.87           C  
ATOM    944  C   GLU A 124      40.576  38.951  64.180  1.00 21.55           C  
ATOM    945  O   GLU A 124      41.160  38.569  63.147  1.00 20.97           O  
ATOM    946  CB  GLU A 124      40.514  41.297  63.260  1.00 20.23           C  
ATOM    947  CG  GLU A 124      39.759  42.632  63.200  1.00 20.20           C  
ATOM    948  CD  GLU A 124      40.263  43.538  62.092  1.00 23.59           C  
ATOM    949  OE1 GLU A 124      41.078  44.439  62.401  1.00 28.13           O  
ATOM    950  OE2 GLU A 124      39.878  43.344  60.919  1.00 21.76           O  
ATOM    951  N   GLU A 125      40.496  38.194  65.273  1.00 19.45           N  
ATOM    952  CA  GLU A 125      41.092  36.862  65.312  1.00 19.68           C  
ATOM    953  C   GLU A 125      40.116  35.793  64.828  1.00 20.57           C  
ATOM    954  O   GLU A 125      40.544  34.692  64.438  1.00 21.52           O  
ATOM    955  CB  GLU A 125      41.549  36.519  66.748  1.00 20.32           C  
ATOM    956  CG  GLU A 125      42.726  37.359  67.213  1.00 22.65           C  
ATOM    957  CD  GLU A 125      42.790  37.415  68.709  1.00 28.13           C  
ATOM    958  OE1 GLU A 125      42.716  36.327  69.341  1.00 24.47           O  
ATOM    959  OE2 GLU A 125      42.900  38.553  69.236  1.00 29.58           O  
ATOM    960  N   HIS A 126      38.822  36.115  64.867  1.00 20.10           N  
ATOM    961  CA  HIS A 126      37.745  35.215  64.455  1.00 22.54           C  
ATOM    962  C   HIS A 126      37.122  35.602  63.105  1.00 22.11           C  
ATOM    963  O   HIS A 126      36.996  34.776  62.207  1.00 22.14           O  
ATOM    964  CB  HIS A 126      36.628  35.190  65.513  1.00 22.38           C  
ATOM    965  CG  HIS A 126      35.499  34.267  65.168  1.00 25.08           C  
ATOM    966  ND1 HIS A 126      34.264  34.334  65.780  1.00 27.89           N  
ATOM    967  CD2 HIS A 126      35.426  33.230  64.299  1.00 26.38           C  
ATOM    968  CE1 HIS A 126      33.485  33.379  65.311  1.00 24.59           C  
ATOM    969  NE2 HIS A 126      34.164  32.691  64.411  1.00 28.66           N  
ATOM    970  N   VAL A 127      36.716  36.866  62.998  1.00 22.57           N  
ATOM    971  CA  VAL A 127      36.091  37.395  61.800  1.00 21.58           C  
ATOM    972  C   VAL A 127      36.784  38.713  61.460  1.00 22.65           C  
ATOM    973  O   VAL A 127      36.946  39.578  62.329  1.00 20.59           O  
ATOM    974  CB  VAL A 127      34.588  37.672  62.043  1.00 21.70           C  
ATOM    975  CG1 VAL A 127      33.988  38.380  60.819  1.00 23.51           C  
ATOM    976  CG2 VAL A 127      33.828  36.347  62.311  1.00 21.16           C  
ATOM    977  N   VAL A 128      37.206  38.873  60.206  1.00 21.66           N  
ATOM    978  CA  VAL A 128      37.873  40.121  59.809  1.00 21.22           C  
ATOM    979  C   VAL A 128      36.907  41.281  59.997  1.00 20.40           C  
ATOM    980  O   VAL A 128      35.764  41.196  59.628  1.00 21.06           O  
ATOM    981  CB  VAL A 128      38.317  40.066  58.358  1.00 23.05           C  
ATOM    982  CG1 VAL A 128      38.735  41.465  57.873  1.00 24.28           C  
ATOM    983  CG2 VAL A 128      39.486  39.103  58.253  1.00 23.70           C  
ATOM    984  N   GLY A 129      37.368  42.351  60.616  1.00 21.43           N  
ATOM    985  CA  GLY A 129      36.496  43.497  60.838  1.00 22.82           C  
ATOM    986  C   GLY A 129      35.648  43.448  62.101  1.00 21.95           C  
ATOM    987  O   GLY A 129      34.838  44.347  62.344  1.00 20.20           O  
ATOM    988  N   LEU A 130      35.826  42.418  62.914  1.00 21.98           N  
ATOM    989  CA  LEU A 130      35.021  42.286  64.164  1.00 21.86           C  
ATOM    990  C   LEU A 130      35.948  42.256  65.384  1.00 21.32           C  
ATOM    991  O   LEU A 130      36.878  41.469  65.410  1.00 19.48           O  
ATOM    992  CB  LEU A 130      34.229  40.945  64.140  1.00 21.02           C  
ATOM    993  CG  LEU A 130      33.389  40.505  65.406  1.00 20.68           C  
ATOM    994  CD1 LEU A 130      32.211  41.412  65.574  1.00 19.97           C  
ATOM    995  CD2 LEU A 130      32.879  39.089  65.230  1.00 20.62           C  
ATOM    996  N   ASN A 131      35.707  43.123  66.373  1.00 17.36           N  
ATOM    997  CA  ASN A 131      36.483  43.081  67.590  1.00 17.37           C  
ATOM    998  C   ASN A 131      35.473  42.593  68.648  1.00 17.70           C  
ATOM    999  O   ASN A 131      34.272  42.880  68.534  1.00 18.32           O  
ATOM   1000  CB  ASN A 131      37.011  44.454  68.000  1.00 18.79           C  
ATOM   1001  CG  ASN A 131      38.131  44.958  67.075  1.00 21.24           C  
ATOM   1002  OD1 ASN A 131      38.536  46.119  67.163  1.00 22.61           O  
ATOM   1003  ND2 ASN A 131      38.629  44.096  66.200  1.00 18.76           N  
ATOM   1004  N   CYS A 132      35.968  41.852  69.636  1.00 19.06           N  
ATOM   1005  CA  CYS A 132      35.141  41.283  70.702  1.00 21.62           C  
ATOM   1006  C   CYS A 132      35.897  41.502  72.005  1.00 20.08           C  
ATOM   1007  O   CYS A 132      37.117  41.294  72.075  1.00 22.44           O  
ATOM   1008  CB  CYS A 132      34.998  39.800  70.493  1.00 23.71           C  
ATOM   1009  SG  CYS A 132      34.040  39.393  69.160  1.00 40.25           S  
ATOM   1010  N   ILE A 133      35.197  41.954  73.031  1.00 15.45           N  
ATOM   1011  CA  ILE A 133      35.819  42.206  74.305  1.00 14.97           C  
ATOM   1012  C   ILE A 133      34.922  41.453  75.277  1.00 16.08           C  
ATOM   1013  O   ILE A 133      33.723  41.701  75.339  1.00 16.24           O  
ATOM   1014  CB  ILE A 133      35.839  43.733  74.642  1.00 17.52           C  
ATOM   1015  CG1 ILE A 133      36.802  44.483  73.701  1.00 16.96           C  
ATOM   1016  CG2 ILE A 133      36.356  43.933  76.054  1.00 16.16           C  
ATOM   1017  CD1 ILE A 133      36.731  46.053  73.895  1.00 19.83           C  
ATOM   1018  N   ALA A 134      35.510  40.553  76.059  1.00 17.64           N  
ATOM   1019  CA  ALA A 134      34.712  39.679  76.901  1.00 16.37           C  
ATOM   1020  C   ALA A 134      35.265  39.437  78.299  1.00 15.46           C  
ATOM   1021  O   ALA A 134      36.426  39.608  78.532  1.00 15.61           O  
ATOM   1022  CB  ALA A 134      34.567  38.314  76.169  1.00 18.18           C  
ATOM   1023  N   SER A 135      34.406  39.002  79.211  1.00 14.72           N  
ATOM   1024  CA  SER A 135      34.872  38.708  80.581  1.00 13.91           C  
ATOM   1025  C   SER A 135      34.078  37.542  81.140  1.00 15.36           C  
ATOM   1026  O   SER A 135      32.928  37.374  80.790  1.00 16.98           O  
ATOM   1027  CB  SER A 135      34.744  39.971  81.462  1.00 15.70           C  
ATOM   1028  OG  SER A 135      35.286  39.719  82.745  1.00 19.44           O  
ATOM   1029  N   ALA A 136      34.716  36.737  81.992  1.00 16.14           N  
ATOM   1030  CA  ALA A 136      34.135  35.566  82.600  1.00 16.58           C  
ATOM   1031  C   ALA A 136      33.068  35.796  83.656  1.00 16.60           C  
ATOM   1032  O   ALA A 136      33.172  36.720  84.459  1.00 16.60           O  
ATOM   1033  CB  ALA A 136      35.254  34.725  83.232  1.00 17.90           C  
ATOM   1034  N   ILE A 137      32.057  34.949  83.641  1.00 15.50           N  
ATOM   1035  CA  ILE A 137      31.004  35.012  84.666  1.00 17.42           C  
ATOM   1036  C   ILE A 137      31.280  33.776  85.539  1.00 18.60           C  
ATOM   1037  O   ILE A 137      31.461  32.668  85.035  1.00 17.25           O  
ATOM   1038  CB  ILE A 137      29.635  34.957  84.031  1.00 17.35           C  
ATOM   1039  CG1 ILE A 137      29.392  36.264  83.246  1.00 14.21           C  
ATOM   1040  CG2 ILE A 137      28.544  34.755  85.136  1.00 15.26           C  
ATOM   1041  CD1 ILE A 137      28.271  36.249  82.238  1.00 14.25           C  
ATOM   1042  N   TYR A 138      31.271  33.983  86.848  1.00 18.27           N  
ATOM   1043  CA  TYR A 138      31.586  32.935  87.804  1.00 19.73           C  
ATOM   1044  C   TYR A 138      30.443  32.557  88.746  1.00 20.64           C  
ATOM   1045  O   TYR A 138      29.513  33.359  89.008  1.00 19.05           O  
ATOM   1046  CB  TYR A 138      32.746  33.378  88.689  1.00 18.00           C  
ATOM   1047  CG  TYR A 138      34.003  33.779  87.972  1.00 19.39           C  
ATOM   1048  CD1 TYR A 138      34.318  35.121  87.768  1.00 17.37           C  
ATOM   1049  CD2 TYR A 138      34.905  32.812  87.528  1.00 18.55           C  
ATOM   1050  CE1 TYR A 138      35.501  35.500  87.127  1.00 18.87           C  
ATOM   1051  CE2 TYR A 138      36.095  33.193  86.905  1.00 18.82           C  
ATOM   1052  CZ  TYR A 138      36.384  34.506  86.702  1.00 18.80           C  
ATOM   1053  OH  TYR A 138      37.552  34.887  86.079  1.00 19.97           O  
ATOM   1054  N   ASP A 139      30.505  31.337  89.269  1.00 22.66           N  
ATOM   1055  CA  ASP A 139      29.455  30.906  90.202  1.00 22.84           C  
ATOM   1056  C   ASP A 139      29.963  31.088  91.623  1.00 22.91           C  
ATOM   1057  O   ASP A 139      31.017  31.679  91.849  1.00 22.45           O  
ATOM   1058  CB  ASP A 139      29.050  29.457  89.945  1.00 24.53           C  
ATOM   1059  CG  ASP A 139      30.167  28.471  90.239  1.00 24.01           C  
ATOM   1060  OD1 ASP A 139      31.206  28.884  90.800  1.00 26.33           O  
ATOM   1061  OD2 ASP A 139      30.006  27.271  89.912  1.00 27.84           O  
ATOM   1062  N   ASP A 140      29.214  30.572  92.591  1.00 25.73           N  
ATOM   1063  CA  ASP A 140      29.571  30.723  94.015  1.00 29.52           C  
ATOM   1064  C   ASP A 140      30.937  30.241  94.457  1.00 28.92           C  
ATOM   1065  O   ASP A 140      31.474  30.721  95.470  1.00 28.22           O  
ATOM   1066  CB  ASP A 140      28.553  29.986  94.894  1.00 33.07           C  
ATOM   1067  CG  ASP A 140      27.349  30.808  95.171  1.00 37.64           C  
ATOM   1068  OD1 ASP A 140      27.364  32.007  94.791  1.00 41.32           O  
ATOM   1069  OD2 ASP A 140      26.391  30.270  95.778  1.00 39.51           O  
ATOM   1070  N   VAL A 141      31.464  29.247  93.749  1.00 27.28           N  
ATOM   1071  CA  VAL A 141      32.749  28.668  94.098  1.00 27.87           C  
ATOM   1072  C   VAL A 141      33.901  29.252  93.310  1.00 26.52           C  
ATOM   1073  O   VAL A 141      35.043  28.844  93.491  1.00 26.91           O  
ATOM   1074  CB  VAL A 141      32.749  27.124  93.917  1.00 27.05           C  
ATOM   1075  CG1 VAL A 141      32.075  26.461  95.119  1.00 31.85           C  
ATOM   1076  CG2 VAL A 141      32.023  26.724  92.678  1.00 30.29           C  
ATOM   1077  N   GLY A 142      33.611  30.201  92.426  1.00 25.11           N  
ATOM   1078  CA  GLY A 142      34.692  30.798  91.657  1.00 23.20           C  
ATOM   1079  C   GLY A 142      34.973  30.093  90.334  1.00 23.12           C  
ATOM   1080  O   GLY A 142      35.981  30.391  89.667  1.00 22.80           O  
ATOM   1081  N   SER A 143      34.113  29.158  89.944  1.00 20.35           N  
ATOM   1082  CA  SER A 143      34.339  28.504  88.660  1.00 23.17           C  
ATOM   1083  C   SER A 143      33.640  29.331  87.555  1.00 21.76           C  
ATOM   1084  O   SER A 143      32.615  30.003  87.775  1.00 20.40           O  
ATOM   1085  CB  SER A 143      33.847  27.044  88.697  1.00 25.68           C  
ATOM   1086  OG  SER A 143      32.451  26.969  88.651  1.00 36.88           O  
ATOM   1087  N   VAL A 144      34.214  29.315  86.369  1.00 21.21           N  
ATOM   1088  CA  VAL A 144      33.640  30.092  85.282  1.00 21.38           C  
ATOM   1089  C   VAL A 144      32.479  29.312  84.715  1.00 22.01           C  
ATOM   1090  O   VAL A 144      32.635  28.129  84.394  1.00 23.29           O  
ATOM   1091  CB  VAL A 144      34.689  30.381  84.174  1.00 21.06           C  
ATOM   1092  CG1 VAL A 144      35.326  29.059  83.673  1.00 21.51           C  
ATOM   1093  CG2 VAL A 144      34.014  31.078  83.042  1.00 17.92           C  
ATOM   1094  N   VAL A 145      31.304  29.940  84.638  1.00 19.08           N  
ATOM   1095  CA  VAL A 145      30.125  29.260  84.077  1.00 20.69           C  
ATOM   1096  C   VAL A 145      29.614  29.863  82.752  1.00 20.56           C  
ATOM   1097  O   VAL A 145      28.765  29.265  82.092  1.00 19.89           O  
ATOM   1098  CB  VAL A 145      28.947  29.286  85.068  1.00 21.96           C  
ATOM   1099  CG1 VAL A 145      29.321  28.475  86.308  1.00 22.63           C  
ATOM   1100  CG2 VAL A 145      28.628  30.725  85.430  1.00 22.57           C  
ATOM   1101  N   ALA A 146      30.102  31.051  82.390  1.00 18.58           N  
ATOM   1102  CA  ALA A 146      29.659  31.706  81.157  1.00 18.27           C  
ATOM   1103  C   ALA A 146      30.568  32.908  80.883  1.00 17.96           C  
ATOM   1104  O   ALA A 146      31.484  33.180  81.637  1.00 18.27           O  
ATOM   1105  CB  ALA A 146      28.183  32.180  81.298  1.00 20.79           C  
ATOM   1106  N   ALA A 147      30.328  33.608  79.781  1.00 17.68           N  
ATOM   1107  CA  ALA A 147      31.111  34.794  79.468  1.00 18.05           C  
ATOM   1108  C   ALA A 147      30.153  35.821  78.848  1.00 16.38           C  
ATOM   1109  O   ALA A 147      29.173  35.444  78.215  1.00 18.67           O  
ATOM   1110  CB  ALA A 147      32.221  34.447  78.459  1.00 17.77           C  
ATOM   1111  N   ILE A 148      30.427  37.101  79.037  1.00 16.46           N  
ATOM   1112  CA  ILE A 148      29.612  38.138  78.407  1.00 14.55           C  
ATOM   1113  C   ILE A 148      30.601  38.927  77.570  1.00 16.31           C  
ATOM   1114  O   ILE A 148      31.750  39.047  77.966  1.00 17.34           O  
ATOM   1115  CB  ILE A 148      28.868  39.006  79.428  1.00 15.69           C  
ATOM   1116  CG1 ILE A 148      28.129  40.117  78.683  1.00 16.92           C  
ATOM   1117  CG2 ILE A 148      29.815  39.463  80.509  1.00 15.13           C  
ATOM   1118  CD1 ILE A 148      27.055  40.758  79.551  1.00 19.32           C  
ATOM   1119  N   SER A 149      30.155  39.424  76.406  1.00 15.07           N  
ATOM   1120  CA  SER A 149      31.045  40.156  75.525  1.00 16.33           C  
ATOM   1121  C   SER A 149      30.286  41.244  74.787  1.00 17.37           C  
ATOM   1122  O   SER A 149      29.045  41.250  74.756  1.00 19.86           O  
ATOM   1123  CB  SER A 149      31.640  39.187  74.474  1.00 17.48           C  
ATOM   1124  OG  SER A 149      30.601  38.644  73.668  1.00 22.15           O  
ATOM   1125  N   ILE A 150      31.030  42.224  74.283  1.00 17.18           N  
ATOM   1126  CA  ILE A 150      30.466  43.214  73.388  1.00 18.55           C  
ATOM   1127  C   ILE A 150      31.222  42.879  72.107  1.00 19.67           C  
ATOM   1128  O   ILE A 150      32.419  42.556  72.143  1.00 18.48           O  
ATOM   1129  CB  ILE A 150      30.769  44.658  73.807  1.00 19.30           C  
ATOM   1130  CG1 ILE A 150      32.250  44.870  73.980  1.00 21.07           C  
ATOM   1131  CG2 ILE A 150      30.080  44.950  75.100  1.00 19.43           C  
ATOM   1132  CD1 ILE A 150      32.559  46.374  74.061  1.00 24.38           C  
ATOM   1133  N   SER A 151      30.520  42.910  70.984  1.00 20.12           N  
ATOM   1134  CA  SER A 151      31.153  42.545  69.709  1.00 21.52           C  
ATOM   1135  C   SER A 151      30.719  43.569  68.697  1.00 20.44           C  
ATOM   1136  O   SER A 151      29.542  43.895  68.606  1.00 21.05           O  
ATOM   1137  CB  SER A 151      30.671  41.171  69.202  1.00 22.72           C  
ATOM   1138  OG  SER A 151      30.602  40.207  70.237  1.00 31.52           O  
ATOM   1139  N   GLY A 152      31.655  44.083  67.921  1.00 20.42           N  
ATOM   1140  CA  GLY A 152      31.229  45.031  66.914  1.00 18.85           C  
ATOM   1141  C   GLY A 152      32.300  45.318  65.895  1.00 19.93           C  
ATOM   1142  O   GLY A 152      33.404  44.796  65.991  1.00 17.75           O  
ATOM   1143  N   PRO A 153      31.980  46.165  64.906  1.00 19.34           N  
ATOM   1144  CA  PRO A 153      32.881  46.572  63.815  1.00 21.67           C  
ATOM   1145  C   PRO A 153      34.201  47.127  64.360  1.00 21.90           C  
ATOM   1146  O   PRO A 153      34.195  48.006  65.243  1.00 20.81           O  
ATOM   1147  CB  PRO A 153      32.070  47.648  63.071  1.00 21.05           C  
ATOM   1148  CG  PRO A 153      30.655  47.438  63.505  1.00 22.08           C  
ATOM   1149  CD  PRO A 153      30.768  47.001  64.939  1.00 20.79           C  
ATOM   1150  N   SER A 154      35.328  46.643  63.826  1.00 21.95           N  
ATOM   1151  CA  SER A 154      36.650  47.097  64.278  1.00 24.11           C  
ATOM   1152  C   SER A 154      36.856  48.604  64.102  1.00 23.05           C  
ATOM   1153  O   SER A 154      37.625  49.202  64.836  1.00 24.19           O  
ATOM   1154  CB  SER A 154      37.774  46.318  63.559  1.00 25.83           C  
ATOM   1155  OG  SER A 154      37.570  46.349  62.148  1.00 32.31           O  
ATOM   1156  N   SER A 155      36.121  49.213  63.183  1.00 23.34           N  
ATOM   1157  CA  SER A 155      36.242  50.654  62.962  1.00 23.98           C  
ATOM   1158  C   SER A 155      35.543  51.455  64.061  1.00 24.00           C  
ATOM   1159  O   SER A 155      35.807  52.632  64.213  1.00 24.62           O  
ATOM   1160  CB  SER A 155      35.628  51.028  61.603  1.00 25.80           C  
ATOM   1161  OG  SER A 155      34.215  50.925  61.614  1.00 26.67           O  
ATOM   1162  N   ARG A 156      34.636  50.834  64.826  1.00 22.80           N  
ATOM   1163  CA  ARG A 156      33.906  51.586  65.850  1.00 21.87           C  
ATOM   1164  C   ARG A 156      34.397  51.232  67.241  1.00 22.25           C  
ATOM   1165  O   ARG A 156      34.555  52.114  68.117  1.00 19.38           O  
ATOM   1166  CB  ARG A 156      32.391  51.325  65.712  1.00 23.69           C  
ATOM   1167  CG  ARG A 156      31.472  52.251  66.542  1.00 23.49           C  
ATOM   1168  CD  ARG A 156      30.011  52.113  66.041  1.00 22.22           C  
ATOM   1169  NE  ARG A 156      29.476  50.764  66.169  1.00 22.11           N  
ATOM   1170  CZ  ARG A 156      28.524  50.242  65.397  1.00 22.11           C  
ATOM   1171  NH1 ARG A 156      27.989  50.941  64.392  1.00 23.47           N  
ATOM   1172  NH2 ARG A 156      28.052  49.019  65.654  1.00 19.77           N  
ATOM   1173  N   LEU A 157      34.652  49.941  67.448  1.00 22.53           N  
ATOM   1174  CA  LEU A 157      35.180  49.463  68.723  1.00 23.39           C  
ATOM   1175  C   LEU A 157      36.709  49.469  68.531  1.00 24.47           C  
ATOM   1176  O   LEU A 157      37.381  48.428  68.490  1.00 24.38           O  
ATOM   1177  CB  LEU A 157      34.623  48.057  69.002  1.00 24.93           C  
ATOM   1178  CG  LEU A 157      34.953  47.434  70.354  1.00 27.37           C  
ATOM   1179  CD1 LEU A 157      34.518  48.375  71.492  1.00 24.34           C  
ATOM   1180  CD2 LEU A 157      34.201  46.083  70.461  1.00 27.19           C  
ATOM   1181  N   THR A 158      37.253  50.687  68.447  1.00 22.36           N  
ATOM   1182  CA  THR A 158      38.659  50.917  68.221  1.00 24.27           C  
ATOM   1183  C   THR A 158      39.579  50.690  69.417  1.00 24.18           C  
ATOM   1184  O   THR A 158      39.141  50.727  70.582  1.00 22.53           O  
ATOM   1185  CB  THR A 158      38.862  52.353  67.688  1.00 25.52           C  
ATOM   1186  OG1 THR A 158      38.162  53.270  68.543  1.00 26.91           O  
ATOM   1187  CG2 THR A 158      38.299  52.488  66.279  1.00 26.31           C  
ATOM   1188  N   GLU A 159      40.866  50.480  69.111  1.00 23.95           N  
ATOM   1189  CA  GLU A 159      41.879  50.226  70.127  1.00 25.38           C  
ATOM   1190  C   GLU A 159      41.941  51.244  71.264  1.00 25.39           C  
ATOM   1191  O   GLU A 159      42.245  50.874  72.377  1.00 26.38           O  
ATOM   1192  CB  GLU A 159      43.285  50.099  69.504  1.00 25.36           C  
ATOM   1193  CG  GLU A 159      43.397  49.049  68.435  1.00 29.14           C  
ATOM   1194  CD  GLU A 159      43.300  49.676  67.065  1.00 33.89           C  
ATOM   1195  OE1 GLU A 159      42.403  50.540  66.903  1.00 35.28           O  
ATOM   1196  OE2 GLU A 159      44.104  49.317  66.164  1.00 33.19           O  
ATOM   1197  N   ASP A 160      41.669  52.513  70.990  1.00 24.88           N  
ATOM   1198  CA  ASP A 160      41.708  53.514  72.058  1.00 25.13           C  
ATOM   1199  C   ASP A 160      40.572  53.323  73.075  1.00 23.67           C  
ATOM   1200  O   ASP A 160      40.566  53.944  74.137  1.00 24.00           O  
ATOM   1201  CB  ASP A 160      41.603  54.901  71.461  1.00 29.06           C  
ATOM   1202  CG  ASP A 160      40.363  55.062  70.631  1.00 31.96           C  
ATOM   1203  OD1 ASP A 160      40.244  54.369  69.608  1.00 34.31           O  
ATOM   1204  OD2 ASP A 160      39.498  55.861  71.020  1.00 36.01           O  
ATOM   1205  N   ARG A 161      39.608  52.469  72.744  1.00 21.60           N  
ATOM   1206  CA  ARG A 161      38.476  52.198  73.640  1.00 21.44           C  
ATOM   1207  C   ARG A 161      38.608  50.825  74.339  1.00 20.73           C  
ATOM   1208  O   ARG A 161      37.758  50.468  75.163  1.00 19.57           O  
ATOM   1209  CB  ARG A 161      37.174  52.198  72.846  1.00 21.73           C  
ATOM   1210  CG  ARG A 161      36.894  53.469  72.039  1.00 21.48           C  
ATOM   1211  CD  ARG A 161      35.519  53.383  71.373  1.00 25.41           C  
ATOM   1212  NE  ARG A 161      34.409  53.182  72.317  1.00 23.07           N  
ATOM   1213  CZ  ARG A 161      33.292  52.523  72.012  1.00 23.76           C  
ATOM   1214  NH1 ARG A 161      33.126  52.004  70.804  1.00 23.68           N  
ATOM   1215  NH2 ARG A 161      32.345  52.356  72.933  1.00 26.61           N  
ATOM   1216  N   PHE A 162      39.656  50.065  74.029  1.00 20.24           N  
ATOM   1217  CA  PHE A 162      39.768  48.721  74.631  1.00 21.42           C  
ATOM   1218  C   PHE A 162      39.833  48.731  76.149  1.00 23.74           C  
ATOM   1219  O   PHE A 162      39.216  47.877  76.822  1.00 21.71           O  
ATOM   1220  CB  PHE A 162      41.002  47.975  74.120  1.00 23.41           C  
ATOM   1221  CG  PHE A 162      40.930  47.556  72.675  1.00 23.32           C  
ATOM   1222  CD1 PHE A 162      42.066  47.023  72.059  1.00 23.72           C  
ATOM   1223  CD2 PHE A 162      39.765  47.692  71.923  1.00 24.44           C  
ATOM   1224  CE1 PHE A 162      42.039  46.623  70.730  1.00 23.36           C  
ATOM   1225  CE2 PHE A 162      39.729  47.288  70.583  1.00 24.91           C  
ATOM   1226  CZ  PHE A 162      40.873  46.759  69.989  1.00 24.52           C  
ATOM   1227  N   VAL A 163      40.593  49.662  76.715  1.00 23.36           N  
ATOM   1228  CA  VAL A 163      40.693  49.657  78.178  1.00 27.25           C  
ATOM   1229  C   VAL A 163      39.390  50.093  78.864  1.00 25.50           C  
ATOM   1230  O   VAL A 163      38.964  49.460  79.842  1.00 25.62           O  
ATOM   1231  CB  VAL A 163      41.855  50.560  78.721  1.00 27.30           C  
ATOM   1232  CG1 VAL A 163      41.575  51.993  78.471  1.00 32.25           C  
ATOM   1233  CG2 VAL A 163      42.010  50.340  80.244  1.00 29.96           C  
ATOM   1234  N   SER A 164      38.770  51.160  78.370  1.00 23.97           N  
ATOM   1235  CA  SER A 164      37.529  51.645  78.991  1.00 24.38           C  
ATOM   1236  C   SER A 164      36.393  50.643  78.793  1.00 21.88           C  
ATOM   1237  O   SER A 164      35.566  50.448  79.668  1.00 22.06           O  
ATOM   1238  CB  SER A 164      37.135  52.995  78.386  1.00 25.13           C  
ATOM   1239  OG  SER A 164      36.994  52.851  76.986  1.00 32.83           O  
ATOM   1240  N   GLN A 165      36.355  49.988  77.644  1.00 20.64           N  
ATOM   1241  CA  GLN A 165      35.281  49.020  77.396  1.00 22.74           C  
ATOM   1242  C   GLN A 165      35.561  47.687  78.121  1.00 20.10           C  
ATOM   1243  O   GLN A 165      34.646  47.013  78.568  1.00 19.04           O  
ATOM   1244  CB  GLN A 165      35.123  48.787  75.884  1.00 22.01           C  
ATOM   1245  CG  GLN A 165      34.492  49.979  75.121  1.00 23.46           C  
ATOM   1246  CD  GLN A 165      33.100  50.318  75.646  1.00 23.28           C  
ATOM   1247  OE1 GLN A 165      32.221  49.461  75.668  1.00 24.31           O  
ATOM   1248  NE2 GLN A 165      32.900  51.560  76.085  1.00 26.65           N  
ATOM   1249  N   GLY A 166      36.832  47.308  78.154  1.00 20.39           N  
ATOM   1250  CA  GLY A 166      37.245  46.086  78.836  1.00 17.99           C  
ATOM   1251  C   GLY A 166      36.865  46.176  80.313  1.00 20.45           C  
ATOM   1252  O   GLY A 166      36.335  45.218  80.895  1.00 18.87           O  
ATOM   1253  N   GLU A 167      37.112  47.332  80.928  1.00 20.72           N  
ATOM   1254  CA  GLU A 167      36.759  47.487  82.342  1.00 22.56           C  
ATOM   1255  C   GLU A 167      35.244  47.500  82.537  1.00 20.47           C  
ATOM   1256  O   GLU A 167      34.760  47.040  83.561  1.00 21.61           O  
ATOM   1257  CB  GLU A 167      37.427  48.755  82.913  1.00 25.21           C  
ATOM   1258  CG  GLU A 167      38.958  48.615  82.860  1.00 27.90           C  
ATOM   1259  CD  GLU A 167      39.740  49.792  83.426  1.00 31.60           C  
ATOM   1260  OE1 GLU A 167      39.145  50.847  83.706  1.00 34.02           O  
ATOM   1261  OE2 GLU A 167      40.967  49.636  83.557  1.00 30.70           O  
ATOM   1262  N   LEU A 168      34.497  48.049  81.571  1.00 20.17           N  
ATOM   1263  CA  LEU A 168      33.048  48.054  81.671  1.00 19.15           C  
ATOM   1264  C   LEU A 168      32.532  46.619  81.499  1.00 18.95           C  
ATOM   1265  O   LEU A 168      31.598  46.195  82.179  1.00 17.82           O  
ATOM   1266  CB  LEU A 168      32.445  48.960  80.593  1.00 21.66           C  
ATOM   1267  CG  LEU A 168      30.933  48.914  80.361  1.00 24.91           C  
ATOM   1268  CD1 LEU A 168      30.176  49.537  81.529  1.00 24.78           C  
ATOM   1269  CD2 LEU A 168      30.631  49.712  79.088  1.00 25.66           C  
ATOM   1270  N   VAL A 169      33.120  45.854  80.578  1.00 16.74           N  
ATOM   1271  CA  VAL A 169      32.670  44.466  80.421  1.00 15.63           C  
ATOM   1272  C   VAL A 169      32.994  43.629  81.700  1.00 15.72           C  
ATOM   1273  O   VAL A 169      32.213  42.754  82.133  1.00 18.64           O  
ATOM   1274  CB  VAL A 169      33.323  43.808  79.155  1.00 15.68           C  
ATOM   1275  CG1 VAL A 169      32.906  42.304  79.104  1.00 16.88           C  
ATOM   1276  CG2 VAL A 169      32.793  44.507  77.909  1.00 16.34           C  
ATOM   1277  N   ARG A 170      34.169  43.853  82.261  1.00 17.86           N  
ATOM   1278  CA  ARG A 170      34.597  43.136  83.467  1.00 18.46           C  
ATOM   1279  C   ARG A 170      33.621  43.479  84.609  1.00 17.91           C  
ATOM   1280  O   ARG A 170      33.221  42.598  85.365  1.00 17.92           O  
ATOM   1281  CB  ARG A 170      36.005  43.567  83.845  1.00 19.36           C  
ATOM   1282  CG  ARG A 170      36.577  43.000  85.183  1.00 25.02           C  
ATOM   1283  CD  ARG A 170      37.724  43.913  85.690  1.00 26.30           C  
ATOM   1284  NE  ARG A 170      37.236  45.269  85.952  1.00 34.33           N  
ATOM   1285  CZ  ARG A 170      38.000  46.347  86.140  1.00 37.90           C  
ATOM   1286  NH1 ARG A 170      39.331  46.262  86.101  1.00 39.02           N  
ATOM   1287  NH2 ARG A 170      37.425  47.527  86.366  1.00 39.84           N  
ATOM   1288  N   ASP A 171      33.272  44.758  84.730  1.00 19.01           N  
ATOM   1289  CA  ASP A 171      32.356  45.171  85.796  1.00 20.18           C  
ATOM   1290  C   ASP A 171      31.008  44.550  85.572  1.00 20.84           C  
ATOM   1291  O   ASP A 171      30.365  44.125  86.520  1.00 19.76           O  
ATOM   1292  CB  ASP A 171      32.214  46.696  85.876  1.00 24.47           C  
ATOM   1293  CG  ASP A 171      33.463  47.355  86.374  1.00 27.79           C  
ATOM   1294  OD1 ASP A 171      34.326  46.650  86.923  1.00 28.22           O  
ATOM   1295  OD2 ASP A 171      33.592  48.584  86.225  1.00 30.92           O  
ATOM   1296  N   THR A 172      30.570  44.497  84.313  1.00 18.75           N  
ATOM   1297  CA  THR A 172      29.286  43.916  83.998  1.00 19.08           C  
ATOM   1298  C   THR A 172      29.264  42.425  84.357  1.00 19.22           C  
ATOM   1299  O   THR A 172      28.316  41.941  84.958  1.00 17.56           O  
ATOM   1300  CB  THR A 172      28.925  44.116  82.504  1.00 19.71           C  
ATOM   1301  OG1 THR A 172      28.917  45.525  82.214  1.00 20.03           O  
ATOM   1302  CG2 THR A 172      27.506  43.570  82.224  1.00 21.80           C  
ATOM   1303  N   ALA A 173      30.310  41.698  83.966  1.00 15.28           N  
ATOM   1304  CA  ALA A 173      30.415  40.280  84.292  1.00 17.98           C  
ATOM   1305  C   ALA A 173      30.394  40.095  85.814  1.00 17.24           C  
ATOM   1306  O   ALA A 173      29.785  39.159  86.342  1.00 16.59           O  
ATOM   1307  CB  ALA A 173      31.752  39.720  83.737  1.00 16.44           C  
ATOM   1308  N   ARG A 174      31.080  40.998  86.503  1.00 18.86           N  
ATOM   1309  CA  ARG A 174      31.182  40.931  87.947  1.00 19.73           C  
ATOM   1310  C   ARG A 174      29.789  41.044  88.532  1.00 19.64           C  
ATOM   1311  O   ARG A 174      29.431  40.250  89.404  1.00 17.95           O  
ATOM   1312  CB  ARG A 174      32.090  42.047  88.491  1.00 21.78           C  
ATOM   1313  CG  ARG A 174      32.145  42.074  90.006  1.00 28.39           C  
ATOM   1314  CD  ARG A 174      32.925  43.299  90.502  1.00 32.53           C  
ATOM   1315  NE  ARG A 174      34.329  43.251  90.106  1.00 36.97           N  
ATOM   1316  CZ  ARG A 174      34.996  44.290  89.591  1.00 40.55           C  
ATOM   1317  NH1 ARG A 174      34.375  45.453  89.410  1.00 42.78           N  
ATOM   1318  NH2 ARG A 174      36.285  44.185  89.275  1.00 39.34           N  
ATOM   1319  N   ASP A 175      29.001  42.015  88.050  1.00 18.48           N  
ATOM   1320  CA  ASP A 175      27.626  42.173  88.558  1.00 19.50           C  
ATOM   1321  C   ASP A 175      26.750  40.971  88.227  1.00 19.10           C  
ATOM   1322  O   ASP A 175      25.918  40.535  89.055  1.00 16.72           O  
ATOM   1323  CB  ASP A 175      26.951  43.440  87.991  1.00 22.24           C  
ATOM   1324  CG  ASP A 175      27.552  44.734  88.531  1.00 25.57           C  
ATOM   1325  OD1 ASP A 175      28.115  44.725  89.645  1.00 24.75           O  
ATOM   1326  OD2 ASP A 175      27.437  45.781  87.839  1.00 28.00           O  
ATOM   1327  N   ILE A 176      26.875  40.420  87.015  1.00 17.23           N  
ATOM   1328  CA  ILE A 176      26.078  39.239  86.698  1.00 17.51           C  
ATOM   1329  C   ILE A 176      26.421  38.090  87.650  1.00 17.71           C  
ATOM   1330  O   ILE A 176      25.513  37.380  88.117  1.00 17.22           O  
ATOM   1331  CB  ILE A 176      26.297  38.794  85.246  1.00 17.38           C  
ATOM   1332  CG1 ILE A 176      25.685  39.880  84.333  1.00 19.21           C  
ATOM   1333  CG2 ILE A 176      25.601  37.443  84.993  1.00 16.39           C  
ATOM   1334  CD1 ILE A 176      26.150  39.819  82.887  1.00 18.57           C  
ATOM   1335  N   SER A 177      27.719  37.885  87.906  1.00 18.13           N  
ATOM   1336  CA  SER A 177      28.184  36.831  88.821  1.00 16.39           C  
ATOM   1337  C   SER A 177      27.498  37.053  90.184  1.00 19.25           C  
ATOM   1338  O   SER A 177      26.908  36.144  90.748  1.00 18.48           O  
ATOM   1339  CB  SER A 177      29.704  36.898  88.979  1.00 22.15           C  
ATOM   1340  OG  SER A 177      30.315  36.559  87.743  1.00 19.30           O  
ATOM   1341  N   THR A 178      27.507  38.291  90.650  1.00 19.67           N  
ATOM   1342  CA  THR A 178      26.868  38.580  91.929  1.00 20.29           C  
ATOM   1343  C   THR A 178      25.374  38.263  91.904  1.00 20.18           C  
ATOM   1344  O   THR A 178      24.860  37.567  92.793  1.00 20.85           O  
ATOM   1345  CB  THR A 178      27.104  40.033  92.320  1.00 20.06           C  
ATOM   1346  OG1 THR A 178      28.506  40.290  92.366  1.00 21.50           O  
ATOM   1347  CG2 THR A 178      26.480  40.318  93.684  1.00 22.68           C  
ATOM   1348  N   ALA A 179      24.662  38.752  90.890  1.00 20.96           N  
ATOM   1349  CA  ALA A 179      23.223  38.494  90.783  1.00 20.96           C  
ATOM   1350  C   ALA A 179      22.933  36.985  90.736  1.00 22.73           C  
ATOM   1351  O   ALA A 179      21.983  36.477  91.343  1.00 19.74           O  
ATOM   1352  CB  ALA A 179      22.664  39.203  89.500  1.00 22.31           C  
ATOM   1353  N   LEU A 180      23.759  36.259  89.990  1.00 21.00           N  
ATOM   1354  CA  LEU A 180      23.601  34.816  89.876  1.00 21.77           C  
ATOM   1355  C   LEU A 180      23.718  34.156  91.243  1.00 22.80           C  
ATOM   1356  O   LEU A 180      23.071  33.132  91.490  1.00 23.40           O  
ATOM   1357  CB  LEU A 180      24.696  34.238  88.958  1.00 21.22           C  
ATOM   1358  CG  LEU A 180      24.678  32.748  88.637  1.00 22.54           C  
ATOM   1359  CD1 LEU A 180      23.462  32.371  87.813  1.00 21.99           C  
ATOM   1360  CD2 LEU A 180      25.959  32.410  87.828  1.00 23.54           C  
ATOM   1361  N   GLY A 181      24.546  34.739  92.111  1.00 21.20           N  
ATOM   1362  CA  GLY A 181      24.731  34.186  93.438  1.00 22.66           C  
ATOM   1363  C   GLY A 181      23.592  34.453  94.412  1.00 24.78           C  
ATOM   1364  O   GLY A 181      23.585  33.867  95.500  1.00 26.47           O  
ATOM   1365  N   LEU A 182      22.640  35.310  94.056  1.00 25.35           N  
ATOM   1366  CA  LEU A 182      21.545  35.602  94.988  1.00 27.92           C  
ATOM   1367  C   LEU A 182      20.477  34.514  94.953  1.00 30.94           C  
ATOM   1368  O   LEU A 182      20.165  33.975  93.892  1.00 30.75           O  
ATOM   1369  CB  LEU A 182      20.921  36.965  94.683  1.00 25.98           C  
ATOM   1370  CG  LEU A 182      21.910  38.123  94.725  1.00 24.71           C  
ATOM   1371  CD1 LEU A 182      21.262  39.390  94.201  1.00 23.08           C  
ATOM   1372  CD2 LEU A 182      22.437  38.321  96.142  1.00 26.43           C  
ATOM   1373  N   LYS A 183      19.940  34.175  96.130  1.00 32.74           N  
ATOM   1374  CA  LYS A 183      18.918  33.131  96.237  1.00 37.01           C  
ATOM   1375  C   LYS A 183      17.546  33.779  96.354  1.00 37.96           C  
ATOM   1376  O   LYS A 183      17.057  34.041  97.456  1.00 37.27           O  
ATOM   1377  CB  LYS A 183      19.184  32.221  97.453  1.00 37.49           C  
ATOM   1378  CG  LYS A 183      20.491  31.432  97.398  1.00 41.41           C  
ATOM   1379  CD  LYS A 183      21.551  31.994  98.355  1.00 43.44           C  
ATOM   1380  CE  LYS A 183      22.055  33.351  97.883  1.00 44.57           C  
ATOM   1381  NZ  LYS A 183      23.027  34.028  98.783  1.00 44.46           N  
ATOM   1382  N   ALA A 184      16.950  34.062  95.196  1.00 39.95           N  
ATOM   1383  CA  ALA A 184      15.638  34.685  95.125  1.00 42.11           C  
ATOM   1384  C   ALA A 184      14.544  33.623  95.019  1.00 43.51           C  
ATOM   1385  O   ALA A 184      13.420  33.888  95.501  1.00 43.67           O  
ATOM   1386  CB  ALA A 184      15.578  35.642  93.934  1.00 42.18           C  
TER    1387      ALA A 184                                                      
END
MOLECULE T0412.pdb
ATOM      1  N   SER     1      17.559  26.951  92.213  1.00 54.32           N  
ATOM      2  CA  SER     1      16.245  27.299  92.853  1.00 53.09           C  
ATOM      3  C   SER     1      16.043  28.831  93.060  1.00 52.29           C  
ATOM      4  O   SER     1      15.077  29.281  93.761  1.00 50.93           O  
ATOM      5  CB  SER     1      16.073  26.547  94.152  1.00 52.87           C  
ATOM      6  OG  SER     1      14.779  26.777  94.666  1.00 52.80           O  
ATOM      7  N   ASN     2      16.948  29.599  92.427  1.00 50.24           N  
ATOM      8  CA  ASN     2      16.884  31.054  92.474  1.00 48.93           C  
ATOM      9  C   ASN     2      17.383  31.628  91.189  1.00 47.18           C  
ATOM     10  O   ASN     2      17.733  32.795  91.079  1.00 47.53           O  
ATOM     11  CB  ASN     2      17.619  31.623  93.683  1.00 49.45           C  
ATOM     12  CG  ASN     2      17.125  33.004  94.040  1.00 49.02           C  
ATOM     13  OD1 ASN     2      17.498  33.973  93.384  1.00 51.47           O  
ATOM     14  ND2 ASN     2      16.253  33.099  95.026  1.00 44.65           N  
ATOM     15  N   ALA     3      17.385  30.732  90.212  1.00 45.59           N  
ATOM     16  CA  ALA     3      17.756  30.926  88.865  1.00 42.81           C  
ATOM     17  C   ALA     3      17.150  32.162  88.216  1.00 42.42           C  
ATOM     18  O   ALA     3      17.817  32.797  87.411  1.00 43.10           O  
ATOM     19  CB  ALA     3      17.328  29.686  88.100  1.00 42.78           C  
ATOM     20  N   LEU     4      15.891  32.474  88.499  1.00 40.84           N  
ATOM     21  CA  LEU     4      15.175  33.549  87.776  1.00 41.08           C  
ATOM     22  C   LEU     4      15.595  34.992  88.193  1.00 41.73           C  
ATOM     23  O   LEU     4      15.795  35.891  87.336  1.00 40.99           O  
ATOM     24  CB  LEU     4      13.630  33.366  87.879  1.00 40.15           C  
ATOM     25  CG  LEU     4      13.042  32.123  87.172  1.00 39.13           C  
ATOM     26  CD1 LEU     4      11.515  32.115  87.181  1.00 37.64           C  
ATOM     27  CD2 LEU     4      13.561  32.029  85.757  1.00 33.72           C  
ATOM     28  N   PHE     5      15.747  35.183  89.503  1.00 42.10           N  
ATOM     29  CA  PHE     5      16.276  36.410  90.043  1.00 43.47           C  
ATOM     30  C   PHE     5      17.723  36.613  89.583  1.00 45.53           C  
ATOM     31  O   PHE     5      18.087  37.717  89.179  1.00 45.52           O  
ATOM     32  CB  PHE     5      16.153  36.419  91.539  1.00 41.53           C  
ATOM     33  CG  PHE     5      14.758  36.708  92.026  1.00 42.02           C  
ATOM     34  CD1 PHE     5      14.162  37.953  91.794  1.00 40.73           C  
ATOM     35  CD2 PHE     5      14.057  35.762  92.772  1.00 38.83           C  
ATOM     36  CE1 PHE     5      12.860  38.232  92.300  1.00 39.71           C  
ATOM     37  CE2 PHE     5      12.788  36.019  93.254  1.00 37.43           C  
ATOM     38  CZ  PHE     5      12.175  37.252  93.015  1.00 38.76           C  
ATOM     39  N   SER     6      18.539  35.567  89.550  1.00 47.47           N  
ATOM     40  CA  SER     6      19.873  35.786  88.935  1.00 50.67           C  
ATOM     41  C   SER     6      19.841  36.120  87.464  1.00 51.41           C  
ATOM     42  O   SER     6      20.662  36.934  87.018  1.00 52.33           O  
ATOM     43  CB  SER     6      20.860  34.630  89.193  1.00 50.07           C  
ATOM     44  OG  SER     6      20.888  34.394  90.613  1.00 55.00           O  
ATOM     45  N   SER     7      18.951  35.474  86.693  1.00 52.62           N  
ATOM     46  CA  SER     7      18.913  35.704  85.234  1.00 53.39           C  
ATOM     47  C   SER     7      18.502  37.146  85.049  1.00 53.99           C  
ATOM     48  O   SER     7      19.066  37.871  84.231  1.00 54.98           O  
ATOM     49  CB  SER     7      17.939  34.768  84.510  1.00 53.69           C  
ATOM     50  OG  SER     7      18.384  33.413  84.592  1.00 54.34           O  
ATOM     51  N   ARG     8      17.565  37.583  85.866  1.00 53.65           N  
ATOM     52  CA  ARG     8      17.066  38.939  85.755  1.00 54.53           C  
ATOM     53  C   ARG     8      18.164  39.964  86.086  1.00 54.58           C  
ATOM     54  O   ARG     8      18.327  40.920  85.341  1.00 55.96           O  
ATOM     55  CB  ARG     8      15.819  39.113  86.650  1.00 54.60           C  
ATOM     56  CG  ARG     8      15.233  40.467  86.595  1.00 56.13           C  
ATOM     57  CD  ARG     8      15.106  40.985  88.004  1.00 57.96           C  
ATOM     58  NE  ARG     8      13.696  41.145  88.342  1.00 62.03           N  
ATOM     59  CZ  ARG     8      13.204  41.195  89.577  1.00 61.99           C  
ATOM     60  NH1 ARG     8      11.897  41.360  89.749  1.00 61.14           N  
ATOM     61  NH2 ARG     8      14.011  41.073  90.627  1.00 62.55           N  
ATOM     62  N   ASP     9      18.908  39.772  87.183  1.00 54.12           N  
ATOM     63  CA  ASP     9      20.074  40.595  87.510  1.00 54.08           C  
ATOM     64  C   ASP     9      21.019  40.705  86.305  1.00 54.67           C  
ATOM     65  O   ASP     9      21.399  41.806  85.927  1.00 55.78           O  
ATOM     66  CB  ASP     9      20.870  39.989  88.667  1.00 53.61           C  
ATOM     67  CG  ASP     9      20.139  40.045  90.007  1.00 55.37           C  
ATOM     68  OD1 ASP     9      19.080  40.719  90.144  1.00 57.24           O  
ATOM     69  OD2 ASP     9      20.634  39.387  90.952  1.00 56.96           O  
ATOM     70  N   ILE    10      21.384  39.573  85.702  1.00 54.19           N  
ATOM     71  CA  ILE    10      22.284  39.552  84.544  1.00 54.42           C  
ATOM     72  C   ILE    10      21.722  40.293  83.315  1.00 55.29           C  
ATOM     73  O   ILE    10      22.394  41.116  82.712  1.00 55.62           O  
ATOM     74  CB  ILE    10      22.666  38.098  84.163  1.00 53.93           C  
ATOM     75  CG1 ILE    10      23.447  37.454  85.291  1.00 53.01           C  
ATOM     76  CG2 ILE    10      23.465  38.026  82.840  1.00 53.06           C  
ATOM     77  CD1 ILE    10      23.566  35.934  85.160  1.00 52.08           C  
ATOM     78  N   LEU    11      20.489  39.975  82.942  1.00 56.18           N  
ATOM     79  CA  LEU    11      19.816  40.679  81.877  1.00 56.38           C  
ATOM     80  C   LEU    11      19.798  42.184  82.141  1.00 57.20           C  
ATOM     81  O   LEU    11      20.038  42.959  81.229  1.00 58.40           O  
ATOM     82  CB  LEU    11      18.403  40.149  81.688  1.00 55.51           C  
ATOM     83  CG  LEU    11      17.694  40.821  80.522  1.00 55.16           C  
ATOM     84  CD1 LEU    11      18.433  40.553  79.200  1.00 52.86           C  
ATOM     85  CD2 LEU    11      16.261  40.337  80.481  1.00 49.81           C  
ATOM     86  N   GLU    12      19.507  42.620  83.360  1.00 57.38           N  
ATOM     87  CA  GLU    12      19.500  44.064  83.621  1.00 58.36           C  
ATOM     88  C   GLU    12      20.894  44.699  83.355  1.00 57.39           C  
ATOM     89  O   GLU    12      20.998  45.782  82.776  1.00 57.72           O  
ATOM     90  CB  GLU    12      19.034  44.374  85.047  1.00 57.74           C  
ATOM     91  CG  GLU    12      17.531  44.332  85.205  1.00 60.40           C  
ATOM     92  CD  GLU    12      17.043  44.331  86.701  1.00 61.88           C  
ATOM     93  OE1 GLU    12      17.873  44.459  87.671  1.00 62.94           O  
ATOM     94  OE2 GLU    12      15.796  44.191  86.887  1.00 66.26           O  
ATOM     95  N   VAL    13      21.957  44.040  83.792  1.00 55.98           N  
ATOM     96  CA  VAL    13      23.286  44.551  83.529  1.00 55.60           C  
ATOM     97  C   VAL    13      23.614  44.556  82.022  1.00 55.56           C  
ATOM     98  O   VAL    13      24.168  45.541  81.501  1.00 55.72           O  
ATOM     99  CB  VAL    13      24.357  43.769  84.292  1.00 55.14           C  
ATOM    100  CG1 VAL    13      25.722  44.167  83.806  1.00 54.07           C  
ATOM    101  CG2 VAL    13      24.239  44.064  85.750  1.00 54.66           C  
ATOM    102  N   LEU    14      23.268  43.472  81.339  1.00 55.24           N  
ATOM    103  CA  LEU    14      23.531  43.338  79.920  1.00 56.29           C  
ATOM    104  C   LEU    14      22.733  44.390  79.113  1.00 56.68           C  
ATOM    105  O   LEU    14      23.240  44.984  78.188  1.00 55.03           O  
ATOM    106  CB  LEU    14      23.190  41.918  79.489  1.00 56.15           C  
ATOM    107  CG  LEU    14      23.420  41.464  78.039  1.00 58.26           C  
ATOM    108  CD1 LEU    14      24.902  41.336  77.676  1.00 56.32           C  
ATOM    109  CD2 LEU    14      22.662  40.132  77.744  1.00 56.95           C  
ATOM    110  N   GLN    15      21.476  44.617  79.488  1.00 57.39           N  
ATOM    111  CA  GLN    15      20.712  45.698  78.920  1.00 58.53           C  
ATOM    112  C   GLN    15      21.356  47.067  79.131  1.00 58.92           C  
ATOM    113  O   GLN    15      21.273  47.906  78.234  1.00 59.03           O  
ATOM    114  CB  GLN    15      19.262  45.682  79.394  1.00 57.53           C  
ATOM    115  CG  GLN    15      18.490  44.721  78.582  1.00 60.66           C  
ATOM    116  CD  GLN    15      17.050  44.549  79.011  1.00 67.03           C  
ATOM    117  OE1 GLN    15      16.699  44.686  80.206  1.00 70.49           O  
ATOM    118  NE2 GLN    15      16.197  44.222  78.046  1.00 66.34           N  
ATOM    119  N   ASP    16      21.993  47.297  80.274  1.00 59.06           N  
ATOM    120  CA  ASP    16      22.670  48.569  80.467  1.00 61.14           C  
ATOM    121  C   ASP    16      23.854  48.786  79.522  1.00 60.80           C  
ATOM    122  O   ASP    16      24.084  49.885  79.037  1.00 62.19           O  
ATOM    123  CB  ASP    16      23.144  48.748  81.898  1.00 61.68           C  
ATOM    124  CG  ASP    16      22.232  49.623  82.672  1.00 68.11           C  
ATOM    125  OD1 ASP    16      21.178  49.073  83.077  1.00 74.84           O  
ATOM    126  OD2 ASP    16      22.526  50.864  82.858  1.00 74.19           O  
ATOM    127  N   ILE    17      24.610  47.746  79.266  1.00 59.31           N  
ATOM    128  CA  ILE    17      25.768  47.894  78.435  1.00 58.61           C  
ATOM    129  C   ILE    17      25.329  48.077  76.973  1.00 58.36           C  
ATOM    130  O   ILE    17      25.962  48.806  76.173  1.00 58.26           O  
ATOM    131  CB  ILE    17      26.776  46.737  78.709  1.00 58.41           C  
ATOM    132  CG1 ILE    17      27.396  47.016  80.102  1.00 59.02           C  
ATOM    133  CG2 ILE    17      27.855  46.699  77.673  1.00 55.26           C  
ATOM    134  CD1 ILE    17      27.730  45.783  80.928  1.00 58.25           C  
ATOM    135  N   HIS    18      24.204  47.478  76.654  1.00 57.90           N  
ATOM    136  CA  HIS    18      23.629  47.664  75.351  1.00 58.94           C  
ATOM    137  C   HIS    18      23.112  49.113  75.217  1.00 59.57           C  
ATOM    138  O   HIS    18      23.374  49.768  74.222  1.00 60.69           O  
ATOM    139  CB  HIS    18      22.526  46.645  75.090  1.00 57.67           C  
ATOM    140  CG  HIS    18      21.918  46.772  73.737  1.00 57.96           C  
ATOM    141  ND1 HIS    18      20.628  47.214  73.539  1.00 58.77           N  
ATOM    142  CD2 HIS    18      22.425  46.528  72.505  1.00 58.94           C  
ATOM    143  CE1 HIS    18      20.359  47.219  72.245  1.00 60.89           C  
ATOM    144  NE2 HIS    18      21.434  46.803  71.595  1.00 61.68           N  
ATOM    145  N   MET    19      22.406  49.635  76.201  1.00 60.21           N  
ATOM    146  CA  MET    19      21.950  51.024  76.073  1.00 61.55           C  
ATOM    147  C   MET    19      23.110  51.997  75.938  1.00 61.25           C  
ATOM    148  O   MET    19      23.060  52.863  75.066  1.00 61.91           O  
ATOM    149  CB  MET    19      21.069  51.463  77.232  1.00 62.10           C  
ATOM    150  CG  MET    19      19.700  50.779  77.275  1.00 67.35           C  
ATOM    151  SD  MET    19      18.646  50.737  75.611  0.70 78.76          SE  
ATOM    152  CE  MET    19      17.526  52.242  75.897  1.00 73.10           C  
ATOM    153  N   GLU    20      24.145  51.856  76.772  1.00 60.29           N  
ATOM    154  CA  GLU    20      25.248  52.795  76.767  1.00 60.15           C  
ATOM    155  C   GLU    20      26.152  52.649  75.538  1.00 60.05           C  
ATOM    156  O   GLU    20      26.716  53.622  75.082  1.00 61.14           O  
ATOM    157  CB  GLU    20      26.110  52.629  78.003  1.00 60.63           C  
ATOM    158  CG  GLU    20      25.379  52.438  79.286  1.00 63.50           C  
ATOM    159  CD  GLU    20      25.814  53.410  80.356  1.00 68.04           C  
ATOM    160  OE1 GLU    20      26.697  54.260  80.104  1.00 70.18           O  
ATOM    161  OE2 GLU    20      25.245  53.346  81.463  1.00 72.19           O  
ATOM    162  N   THR    21      26.292  51.453  74.989  1.00 58.97           N  
ATOM    163  CA  THR    21      27.239  51.263  73.902  1.00 58.25           C  
ATOM    164  C   THR    21      26.625  51.052  72.532  1.00 58.63           C  
ATOM    165  O   THR    21      27.294  51.276  71.547  1.00 59.56           O  
ATOM    166  CB  THR    21      28.229  50.062  74.160  1.00 57.95           C  
ATOM    167  OG1 THR    21      27.559  48.822  73.928  1.00 53.65           O  
ATOM    168  CG2 THR    21      28.813  50.091  75.593  1.00 57.31           C  
ATOM    169  N   GLY    22      25.388  50.561  72.458  1.00 59.40           N  
ATOM    170  CA  GLY    22      24.713  50.279  71.177  1.00 58.70           C  
ATOM    171  C   GLY    22      25.251  49.067  70.445  1.00 59.54           C  
ATOM    172  O   GLY    22      24.683  48.653  69.426  1.00 59.78           O  
ATOM    173  N   GLU    23      26.327  48.469  70.976  1.00 59.24           N  
ATOM    174  CA  GLU    23      26.980  47.302  70.367  1.00 58.58           C  
ATOM    175  C   GLU    23      26.200  45.998  70.555  1.00 58.88           C  
ATOM    176  O   GLU    23      25.259  45.959  71.333  1.00 58.65           O  
ATOM    177  CB  GLU    23      28.390  47.164  70.925  1.00 57.76           C  
ATOM    178  CG  GLU    23      29.214  48.414  70.770  1.00 58.46           C  
ATOM    179  CD  GLU    23      29.610  48.755  69.295  1.00 59.54           C  
ATOM    180  OE1 GLU    23      29.386  47.923  68.411  1.00 54.46           O  
ATOM    181  OE2 GLU    23      30.168  49.866  69.047  1.00 60.23           O  
ATOM    182  N   THR    24      26.562  44.942  69.806  1.00 59.29           N  
ATOM    183  CA  THR    24      26.049  43.581  70.074  1.00 59.56           C  
ATOM    184  C   THR    24      26.676  43.137  71.355  1.00 59.12           C  
ATOM    185  O   THR    24      27.906  43.220  71.551  1.00 59.04           O  
ATOM    186  CB  THR    24      26.459  42.569  68.998  1.00 59.44           C  
ATOM    187  OG1 THR    24      26.050  43.044  67.721  1.00 62.46           O  
ATOM    188  CG2 THR    24      25.755  41.242  69.199  1.00 60.40           C  
ATOM    189  N   VAL    25      25.836  42.700  72.267  1.00 58.81           N  
ATOM    190  CA  VAL    25      26.314  42.319  73.595  1.00 57.45           C  
ATOM    191  C   VAL    25      25.838  40.880  73.800  1.00 57.93           C  
ATOM    192  O   VAL    25      24.808  40.483  73.197  1.00 57.90           O  
ATOM    193  CB  VAL    25      25.819  43.293  74.708  1.00 57.29           C  
ATOM    194  CG1 VAL    25      26.282  44.692  74.424  1.00 57.65           C  
ATOM    195  CG2 VAL    25      24.329  43.310  74.816  1.00 58.67           C  
ATOM    196  N   ALA    26      26.564  40.088  74.618  1.00 57.17           N  
ATOM    197  CA  ALA    26      26.181  38.702  74.836  1.00 55.78           C  
ATOM    198  C   ALA    26      26.677  38.156  76.173  1.00 56.21           C  
ATOM    199  O   ALA    26      27.692  38.660  76.718  1.00 56.85           O  
ATOM    200  CB  ALA    26      26.707  37.843  73.700  1.00 55.84           C  
ATOM    201  N   ILE    27      25.957  37.134  76.666  1.00 54.82           N  
ATOM    202  CA  ILE    27      26.373  36.215  77.724  1.00 54.97           C  
ATOM    203  C   ILE    27      26.665  34.880  77.036  1.00 55.40           C  
ATOM    204  O   ILE    27      25.875  34.388  76.208  1.00 55.50           O  
ATOM    205  CB  ILE    27      25.204  35.998  78.727  1.00 54.89           C  
ATOM    206  CG1 ILE    27      24.675  37.364  79.201  1.00 58.42           C  
ATOM    207  CG2 ILE    27      25.620  35.224  79.941  1.00 54.79           C  
ATOM    208  CD1 ILE    27      25.763  38.300  79.861  1.00 56.11           C  
ATOM    209  N   ALA    28      27.814  34.304  77.343  1.00 56.24           N  
ATOM    210  CA  ALA    28      28.220  33.025  76.762  1.00 57.33           C  
ATOM    211  C   ALA    28      28.899  32.114  77.789  1.00 58.02           C  
ATOM    212  O   ALA    28      29.500  32.581  78.756  1.00 59.65           O  
ATOM    213  CB  ALA    28      29.165  33.270  75.595  1.00 57.05           C  
ATOM    214  N   THR    29      28.831  30.815  77.549  1.00 58.45           N  
ATOM    215  CA  THR    29      29.438  29.821  78.373  1.00 59.29           C  
ATOM    216  C   THR    29      30.122  28.796  77.461  1.00 60.09           C  
ATOM    217  O   THR    29      30.062  28.945  76.238  1.00 60.75           O  
ATOM    218  CB  THR    29      28.366  29.129  79.253  1.00 59.14           C  
ATOM    219  OG1 THR    29      29.027  28.212  80.107  1.00 62.44           O  
ATOM    220  CG2 THR    29      27.313  28.329  78.420  1.00 59.03           C  
ATOM    221  N   LYS    30      30.752  27.746  78.017  1.00 60.10           N  
ATOM    222  CA  LYS    30      31.294  26.714  77.138  1.00 60.17           C  
ATOM    223  C   LYS    30      30.503  25.423  77.045  1.00 60.24           C  
ATOM    224  O   LYS    30      29.848  24.988  77.989  1.00 60.38           O  
ATOM    225  CB  LYS    30      32.766  26.424  77.403  1.00 59.87           C  
ATOM    226  CG  LYS    30      33.091  25.799  78.698  1.00 58.67           C  
ATOM    227  CD  LYS    30      34.590  25.975  78.926  1.00 56.57           C  
ATOM    228  CE  LYS    30      34.916  25.743  80.373  1.00 62.17           C  
ATOM    229  NZ  LYS    30      34.346  24.439  80.917  1.00 61.02           N  
ATOM    230  N   ASN    31      30.566  24.829  75.867  1.00 60.09           N  
ATOM    231  CA  ASN    31      29.974  23.554  75.632  1.00 60.15           C  
ATOM    232  C   ASN    31      31.129  22.711  75.064  1.00 60.85           C  
ATOM    233  O   ASN    31      31.450  22.809  73.874  1.00 60.33           O  
ATOM    234  CB  ASN    31      28.809  23.697  74.659  1.00 59.81           C  
ATOM    235  CG  ASN    31      28.273  22.369  74.202  1.00 60.90           C  
ATOM    236  OD1 ASN    31      28.415  21.365  74.897  1.00 62.42           O  
ATOM    237  ND2 ASN    31      27.650  22.343  73.028  1.00 62.72           N  
ATOM    238  N   ASP    32      31.768  21.920  75.944  1.00 60.79           N  
ATOM    239  CA  ASP    32      32.969  21.138  75.588  1.00 60.54           C  
ATOM    240  C   ASP    32      34.075  22.119  75.089  1.00 59.98           C  
ATOM    241  O   ASP    32      34.582  22.895  75.888  1.00 61.62           O  
ATOM    242  CB  ASP    32      32.586  20.014  74.598  1.00 60.03           C  
ATOM    243  CG  ASP    32      33.770  19.211  74.127  1.00 61.08           C  
ATOM    244  OD1 ASP    32      34.747  19.094  74.899  1.00 61.78           O  
ATOM    245  OD2 ASP    32      33.727  18.690  72.982  1.00 60.46           O  
ATOM    246  N   ILE    33      34.429  22.136  73.811  1.00 58.31           N  
ATOM    247  CA  ILE    33      35.454  23.066  73.335  1.00 57.06           C  
ATOM    248  C   ILE    33      34.847  24.188  72.442  1.00 58.02           C  
ATOM    249  O   ILE    33      35.556  24.857  71.665  1.00 57.54           O  
ATOM    250  CB  ILE    33      36.537  22.325  72.532  1.00 56.55           C  
ATOM    251  CG1 ILE    33      35.932  21.627  71.325  1.00 53.36           C  
ATOM    252  CG2 ILE    33      37.325  21.324  73.397  1.00 55.34           C  
ATOM    253  CD1 ILE    33      36.969  21.338  70.290  1.00 56.07           C  
ATOM    254  N   TYR    34      33.531  24.347  72.532  1.00 58.02           N  
ATOM    255  CA  TYR    34      32.789  25.305  71.721  1.00 59.60           C  
ATOM    256  C   TYR    34      32.153  26.416  72.587  1.00 60.55           C  
ATOM    257  O   TYR    34      31.805  26.201  73.766  1.00 60.57           O  
ATOM    258  CB  TYR    34      31.702  24.615  70.881  1.00 58.70           C  
ATOM    259  CG  TYR    34      32.255  23.504  70.077  1.00 59.51           C  
ATOM    260  CD1 TYR    34      32.919  23.749  68.863  1.00 62.22           C  
ATOM    261  CD2 TYR    34      32.182  22.198  70.539  1.00 56.56           C  
ATOM    262  CE1 TYR    34      33.483  22.679  68.123  1.00 61.17           C  
ATOM    263  CE2 TYR    34      32.717  21.160  69.832  1.00 56.81           C  
ATOM    264  CZ  TYR    34      33.370  21.398  68.642  1.00 59.90           C  
ATOM    265  OH  TYR    34      33.887  20.328  67.971  1.00 62.06           O  
ATOM    266  N   LEU    35      31.982  27.581  71.980  1.00 60.82           N  
ATOM    267  CA  LEU    35      31.425  28.696  72.682  1.00 62.79           C  
ATOM    268  C   LEU    35      29.913  28.510  72.508  1.00 62.91           C  
ATOM    269  O   LEU    35      29.501  28.106  71.419  1.00 64.79           O  
ATOM    270  CB  LEU    35      31.945  30.022  72.105  1.00 62.74           C  
ATOM    271  CG  LEU    35      31.470  31.295  72.849  1.00 64.45           C  
ATOM    272  CD1 LEU    35      32.360  31.531  74.025  1.00 60.26           C  
ATOM    273  CD2 LEU    35      31.499  32.507  71.931  1.00 64.70           C  
ATOM    274  N   GLN    36      29.144  28.723  73.586  0.70 62.01           N  
ATOM    276  CA  GLN    36      27.698  28.652  73.584  0.70 61.91           C  
ATOM    278  C   GLN    36      27.186  30.009  74.064  0.70 62.05           C  
ATOM    280  O   GLN    36      27.602  30.512  75.114  0.70 60.93           O  
ATOM    282  CB  GLN    36      27.220  27.558  74.527  0.70 61.83           C  
ATOM    284  CG  GLN    36      25.819  27.041  74.247  0.70 63.49           C  
ATOM    286  CD  GLN    36      25.239  26.247  75.415  0.70 63.28           C  
ATOM    288  OE1 GLN    36      25.812  25.265  75.837  0.70 68.16           O  
ATOM    290  NE2 GLN    36      24.103  26.691  75.946  0.70 65.60           N  
ATOM    292  N   TYR    37      26.295  30.613  73.278  1.00 61.85           N  
ATOM    293  CA  TYR    37      25.624  31.862  73.670  1.00 61.15           C  
ATOM    294  C   TYR    37      24.399  31.593  74.494  1.00 59.84           C  
ATOM    295  O   TYR    37      23.619  30.759  74.123  1.00 60.44           O  
ATOM    296  CB  TYR    37      25.248  32.676  72.430  1.00 61.54           C  
ATOM    297  CG  TYR    37      26.466  33.251  71.790  1.00 62.86           C  
ATOM    298  CD1 TYR    37      27.216  34.220  72.442  1.00 60.43           C  
ATOM    299  CD2 TYR    37      26.901  32.809  70.537  1.00 65.34           C  
ATOM    300  CE1 TYR    37      28.366  34.738  71.876  1.00 60.87           C  
ATOM    301  CE2 TYR    37      28.061  33.346  69.965  1.00 62.90           C  
ATOM    302  CZ  TYR    37      28.768  34.301  70.635  1.00 63.13           C  
ATOM    303  OH  TYR    37      29.918  34.831  70.071  1.00 67.04           O  
ATOM    304  N   ILE    38      24.230  32.289  75.610  1.00 59.21           N  
ATOM    305  CA  ILE    38      23.013  32.139  76.463  1.00 58.20           C  
ATOM    306  C   ILE    38      21.998  33.234  76.094  1.00 57.77           C  
ATOM    307  O   ILE    38      20.779  33.008  76.118  1.00 58.35           O  
ATOM    308  CB  ILE    38      23.383  32.227  77.946  1.00 58.32           C  
ATOM    309  CG1 ILE    38      24.010  30.910  78.398  1.00 58.97           C  
ATOM    310  CG2 ILE    38      22.166  32.562  78.833  1.00 58.69           C  
ATOM    311  CD1 ILE    38      24.888  31.011  79.594  1.00 57.72           C  
ATOM    312  N   GLN    39      22.504  34.415  75.721  1.00 55.55           N  
ATOM    313  CA  GLN    39      21.666  35.556  75.381  1.00 54.01           C  
ATOM    314  C   GLN    39      22.493  36.510  74.615  1.00 53.04           C  
ATOM    315  O   GLN    39      23.646  36.769  74.994  1.00 54.10           O  
ATOM    316  CB  GLN    39      21.143  36.318  76.610  1.00 53.35           C  
ATOM    317  CG  GLN    39      20.273  37.518  76.256  1.00 51.78           C  
ATOM    318  CD  GLN    39      18.924  37.104  75.683  1.00 53.58           C  
ATOM    319  OE1 GLN    39      18.125  36.427  76.351  1.00 54.79           O  
ATOM    320  NE2 GLN    39      18.642  37.543  74.460  1.00 51.38           N  
ATOM    321  N   ILE    40      21.872  37.048  73.576  1.00 53.01           N  
ATOM    322  CA  ILE    40      22.460  37.999  72.648  1.00 54.32           C  
ATOM    323  C   ILE    40      21.443  39.089  72.532  1.00 54.45           C  
ATOM    324  O   ILE    40      20.241  38.802  72.387  1.00 53.13           O  
ATOM    325  CB  ILE    40      22.644  37.356  71.237  1.00 54.92           C  
ATOM    326  CG1 ILE    40      23.673  36.232  71.341  1.00 56.91           C  
ATOM    327  CG2 ILE    40      23.088  38.411  70.174  1.00 53.95           C  
ATOM    328  CD1 ILE    40      23.497  35.220  70.200  1.00 62.70           C  
ATOM    329  N   ILE    41      21.916  40.324  72.646  1.00 54.89           N  
ATOM    330  CA  ILE    41      21.146  41.479  72.242  1.00 56.47           C  
ATOM    331  C   ILE    41      21.851  42.189  71.064  1.00 57.24           C  
ATOM    332  O   ILE    41      23.010  42.600  71.162  1.00 56.09           O  
ATOM    333  CB  ILE    41      20.922  42.413  73.437  1.00 57.58           C  
ATOM    334  CG1 ILE    41      20.309  41.618  74.606  1.00 56.84           C  
ATOM    335  CG2 ILE    41      20.059  43.630  73.025  1.00 56.15           C  
ATOM    336  CD1 ILE    41      20.249  42.418  75.898  1.00 57.64           C  
ATOM    337  N   GLU    42      21.150  42.275  69.930  0.50 58.60           N  
ATOM    339  CA  GLU    42      21.737  42.779  68.677  0.50 59.91           C  
ATOM    341  C   GLU    42      21.887  44.290  68.699  0.50 59.38           C  
ATOM    343  O   GLU    42      21.031  45.008  69.225  0.50 60.09           O  
ATOM    345  CB  GLU    42      20.937  42.327  67.437  0.50 59.70           C  
ATOM    347  CG  GLU    42      21.709  42.516  66.084  0.50 61.58           C  
ATOM    349  CD  GLU    42      21.014  41.884  64.855  0.50 62.17           C  
ATOM    351  OE1 GLU    42      21.072  40.629  64.699  0.50 64.45           O  
ATOM    353  OE2 GLU    42      20.432  42.649  64.041  0.50 60.87           O  
ATOM    355  N   SER    43      23.002  44.740  68.141  1.00 59.25           N  
ATOM    356  CA  SER    43      23.355  46.133  67.959  1.00 58.50           C  
ATOM    357  C   SER    43      22.298  46.897  67.185  1.00 58.46           C  
ATOM    358  O   SER    43      21.519  46.314  66.445  1.00 59.01           O  
ATOM    359  CB  SER    43      24.674  46.202  67.167  1.00 57.90           C  
ATOM    360  OG  SER    43      25.051  47.555  66.994  1.00 59.25           O  
ATOM    361  N   VAL    44      22.286  48.217  67.359  1.00 58.06           N  
ATOM    362  CA  VAL    44      21.468  49.108  66.579  1.00 57.11           C  
ATOM    363  C   VAL    44      22.321  49.846  65.533  1.00 56.38           C  
ATOM    364  O   VAL    44      21.790  50.674  64.814  1.00 55.77           O  
ATOM    365  CB  VAL    44      20.806  50.149  67.484  1.00 57.90           C  
ATOM    366  CG1 VAL    44      19.692  49.471  68.322  1.00 59.20           C  
ATOM    367  CG2 VAL    44      21.886  50.864  68.405  1.00 56.67           C  
ATOM    368  N   HIS    45      23.625  49.575  65.457  1.00 54.20           N  
ATOM    369  CA  HIS    45      24.435  50.225  64.413  1.00 54.33           C  
ATOM    370  C   HIS    45      24.166  49.611  63.037  1.00 54.09           C  
ATOM    371  O   HIS    45      23.789  48.445  62.908  1.00 54.12           O  
ATOM    372  CB  HIS    45      25.929  50.109  64.736  1.00 53.49           C  
ATOM    373  CG  HIS    45      26.285  50.704  66.062  1.00 55.56           C  
ATOM    374  ND1 HIS    45      26.153  52.056  66.339  1.00 52.55           N  
ATOM    375  CD2 HIS    45      26.731  50.123  67.205  1.00 55.86           C  
ATOM    376  CE1 HIS    45      26.518  52.280  67.589  1.00 55.53           C  
ATOM    377  NE2 HIS    45      26.884  51.125  68.132  1.00 58.42           N  
ATOM    378  N   ALA    46      24.391  50.392  62.015  1.00 54.07           N  
ATOM    379  CA  ALA    46      24.227  49.917  60.652  1.00 55.35           C  
ATOM    380  C   ALA    46      25.188  48.734  60.377  1.00 55.86           C  
ATOM    381  O   ALA    46      24.779  47.633  59.972  1.00 55.11           O  
ATOM    382  CB  ALA    46      24.506  51.069  59.699  1.00 54.46           C  
ATOM    383  N   LEU    47      26.467  48.962  60.621  1.00 55.28           N  
ATOM    384  CA  LEU    47      27.377  47.918  60.442  1.00 56.25           C  
ATOM    385  C   LEU    47      27.511  47.148  61.767  1.00 57.03           C  
ATOM    386  O   LEU    47      28.034  47.672  62.734  1.00 57.57           O  
ATOM    387  CB  LEU    47      28.693  48.504  59.974  1.00 55.59           C  
ATOM    388  CG  LEU    47      29.831  47.494  59.835  1.00 57.97           C  
ATOM    389  CD1 LEU    47      29.449  46.359  58.803  1.00 54.62           C  
ATOM    390  CD2 LEU    47      31.099  48.273  59.426  1.00 55.91           C  
ATOM    391  N   ARG    48      27.074  45.897  61.817  1.00 58.29           N  
ATOM    392  CA  ARG    48      27.158  45.153  63.069  1.00 59.99           C  
ATOM    393  C   ARG    48      27.398  43.654  62.958  1.00 61.56           C  
ATOM    394  O   ARG    48      27.378  43.087  61.867  1.00 61.63           O  
ATOM    395  CB  ARG    48      25.875  45.345  63.836  1.00 60.62           C  
ATOM    396  CG  ARG    48      24.702  44.576  63.294  1.00 58.36           C  
ATOM    397  CD  ARG    48      23.538  45.335  63.769  1.00 62.40           C  
ATOM    398  NE  ARG    48      22.270  44.850  63.280  1.00 64.49           N  
ATOM    399  CZ  ARG    48      21.233  45.649  63.067  1.00 64.30           C  
ATOM    400  NH1 ARG    48      21.351  46.959  63.281  1.00 63.31           N  
ATOM    401  NH2 ARG    48      20.094  45.141  62.613  1.00 63.51           N  
ATOM    402  N   PHE    49      27.599  43.027  64.115  1.00 63.14           N  
ATOM    403  CA  PHE    49      27.646  41.567  64.221  1.00 65.24           C  
ATOM    404  C   PHE    49      26.239  41.014  64.215  1.00 65.96           C  
ATOM    405  O   PHE    49      25.409  41.464  65.015  1.00 66.23           O  
ATOM    406  CB  PHE    49      28.359  41.136  65.513  1.00 66.03           C  
ATOM    407  CG  PHE    49      29.859  41.075  65.381  1.00 68.58           C  
ATOM    408  CD1 PHE    49      30.680  41.662  66.330  1.00 70.90           C  
ATOM    409  CD2 PHE    49      30.452  40.445  64.290  1.00 70.05           C  
ATOM    410  CE1 PHE    49      32.091  41.589  66.235  1.00 72.91           C  
ATOM    411  CE2 PHE    49      31.845  40.399  64.170  1.00 73.92           C  
ATOM    412  CZ  PHE    49      32.672  40.974  65.173  1.00 70.09           C  
ATOM    413  N   HIS    50      25.962  40.103  63.284  1.00 66.85           N  
ATOM    414  CA  HIS    50      24.758  39.309  63.317  1.00 68.69           C  
ATOM    415  C   HIS    50      25.208  37.896  63.694  1.00 70.93           C  
ATOM    416  O   HIS    50      25.696  37.140  62.841  1.00 72.02           O  
ATOM    417  CB  HIS    50      24.075  39.262  61.959  1.00 68.34           C  
ATOM    418  CG  HIS    50      23.636  40.593  61.434  1.00 66.68           C  
ATOM    419  ND1 HIS    50      24.521  41.613  61.145  1.00 67.30           N  
ATOM    420  CD2 HIS    50      22.408  41.048  61.085  1.00 66.59           C  
ATOM    421  CE1 HIS    50      23.850  42.645  60.650  1.00 69.25           C  
ATOM    422  NE2 HIS    50      22.565  42.327  60.598  1.00 67.09           N  
ATOM    423  N   VAL    51      25.074  37.542  64.969  1.00 72.80           N  
ATOM    424  CA  VAL    51      25.490  36.225  65.440  1.00 74.54           C  
ATOM    425  C   VAL    51      24.566  35.166  64.884  1.00 76.64           C  
ATOM    426  O   VAL    51      23.370  35.197  65.174  1.00 78.19           O  
ATOM    427  CB  VAL    51      25.536  36.112  67.004  1.00 74.55           C  
ATOM    428  CG1 VAL    51      26.104  34.706  67.433  1.00 74.48           C  
ATOM    429  CG2 VAL    51      26.337  37.271  67.630  1.00 70.10           C  
ATOM    430  N   ASP    52      25.115  34.279  64.049  1.00 78.72           N  
ATOM    431  CA  ASP    52      24.439  33.061  63.575  1.00 81.20           C  
ATOM    432  C   ASP    52      24.609  31.950  64.617  1.00 82.80           C  
ATOM    433  O   ASP    52      25.737  31.513  64.892  1.00 83.06           O  
ATOM    434  CB  ASP    52      25.040  32.609  62.241  1.00 81.03           C  
ATOM    435  CG  ASP    52      24.673  31.184  61.876  1.00 83.02           C  
ATOM    436  OD1 ASP    52      23.734  30.577  62.458  1.00 84.81           O  
ATOM    437  OD2 ASP    52      25.347  30.655  60.982  1.00 84.60           O  
ATOM    438  N   GLU    53      23.492  31.484  65.176  1.00 84.68           N  
ATOM    439  CA  GLU    53      23.530  30.555  66.322  1.00 85.92           C  
ATOM    440  C   GLU    53      23.834  29.109  65.886  1.00 85.79           C  
ATOM    441  O   GLU    53      24.435  28.337  66.633  1.00 85.94           O  
ATOM    442  CB  GLU    53      22.220  30.629  67.119  1.00 86.63           C  
ATOM    443  CG  GLU    53      22.102  31.862  68.024  0.60 87.28           C  
ATOM    444  CD  GLU    53      20.726  32.513  67.933  0.60 89.75           C  
ATOM    445  OE1 GLU    53      19.709  31.792  67.794  0.60 90.02           O  
ATOM    446  OE2 GLU    53      20.658  33.760  68.016  0.60 91.66           O  
ATOM    447  N   ASN    54      23.439  28.755  64.670  1.00 85.26           N  
ATOM    448  CA  ASN    54      23.786  27.446  64.124  1.00 84.59           C  
ATOM    449  C   ASN    54      25.318  27.277  63.940  1.00 83.75           C  
ATOM    450  O   ASN    54      25.804  26.162  63.726  1.00 83.96           O  
ATOM    451  CB  ASN    54      23.039  27.208  62.800  0.60 84.69           C  
ATOM    452  CG  ASN    54      22.767  25.720  62.520  0.60 86.08           C  
ATOM    453  OD1 ASN    54      23.307  24.824  63.184  0.60 86.21           O  
ATOM    454  ND2 ASN    54      21.925  25.459  61.519  0.60 86.49           N  
ATOM    455  N   ALA    55      26.067  28.380  64.003  1.00 81.92           N  
ATOM    456  CA  ALA    55      27.524  28.342  63.826  1.00 80.70           C  
ATOM    457  C   ALA    55      28.178  27.586  64.984  1.00 79.23           C  
ATOM    458  O   ALA    55      27.803  27.762  66.133  1.00 79.82           O  
ATOM    459  CB  ALA    55      28.111  29.781  63.712  1.00 80.15           C  
ATOM    460  N   ILE    56      29.151  26.744  64.673  1.00 77.79           N  
ATOM    461  CA  ILE    56      29.908  25.989  65.678  1.00 75.90           C  
ATOM    462  C   ILE    56      31.181  26.767  65.873  1.00 74.50           C  
ATOM    463  O   ILE    56      31.910  26.976  64.913  1.00 74.29           O  
ATOM    464  CB  ILE    56      30.321  24.589  65.149  1.00 76.40           C  
ATOM    465  CG1 ILE    56      29.092  23.763  64.712  1.00 75.34           C  
ATOM    466  CG2 ILE    56      31.187  23.862  66.178  1.00 75.84           C  
ATOM    467  CD1 ILE    56      29.325  22.980  63.417  1.00 77.73           C  
ATOM    468  N   ARG    57      31.487  27.201  67.086  1.00 72.12           N  
ATOM    469  CA  ARG    57      32.693  27.987  67.183  1.00 69.90           C  
ATOM    470  C   ARG    57      33.635  27.565  68.274  1.00 66.50           C  
ATOM    471  O   ARG    57      33.315  27.693  69.445  1.00 66.81           O  
ATOM    472  CB  ARG    57      32.374  29.478  67.250  1.00 70.93           C  
ATOM    473  CG  ARG    57      31.240  29.833  68.125  1.00 76.49           C  
ATOM    474  CD  ARG    57      30.491  31.104  67.618  1.00 84.39           C  
ATOM    475  NE  ARG    57      29.043  30.863  67.752  1.00 89.80           N  
ATOM    476  CZ  ARG    57      28.082  31.417  67.016  1.00 91.00           C  
ATOM    477  NH1 ARG    57      28.343  32.318  66.062  1.00 89.27           N  
ATOM    478  NH2 ARG    57      26.837  31.055  67.262  1.00 94.92           N  
ATOM    479  N   PRO    58      34.812  27.064  67.894  1.00 63.24           N  
ATOM    480  CA  PRO    58      35.795  26.606  68.893  1.00 60.90           C  
ATOM    481  C   PRO    58      36.292  27.734  69.769  1.00 59.63           C  
ATOM    482  O   PRO    58      36.399  28.876  69.317  1.00 58.11           O  
ATOM    483  CB  PRO    58      36.936  26.041  68.045  1.00 60.40           C  
ATOM    484  CG  PRO    58      36.333  25.842  66.652  1.00 61.19           C  
ATOM    485  CD  PRO    58      35.270  26.871  66.507  1.00 62.00           C  
ATOM    486  N   LEU    59      36.609  27.414  71.019  1.00 59.37           N  
ATOM    487  CA  LEU    59      37.029  28.425  72.022  1.00 59.11           C  
ATOM    488  C   LEU    59      38.287  29.220  71.640  1.00 58.79           C  
ATOM    489  O   LEU    59      38.460  30.373  72.082  1.00 57.89           O  
ATOM    490  CB  LEU    59      37.198  27.794  73.415  1.00 58.49           C  
ATOM    491  CG  LEU    59      35.901  27.243  74.025  1.00 59.78           C  
ATOM    492  CD1 LEU    59      36.126  26.407  75.321  1.00 58.03           C  
ATOM    493  CD2 LEU    59      34.899  28.333  74.296  1.00 61.08           C  
ATOM    494  N   THR    60      39.165  28.627  70.834  1.00 58.42           N  
ATOM    495  CA  THR    60      40.355  29.358  70.385  1.00 59.36           C  
ATOM    496  C   THR    60      40.040  30.565  69.445  1.00 60.12           C  
ATOM    497  O   THR    60      40.906  31.385  69.165  1.00 60.01           O  
ATOM    498  CB  THR    60      41.361  28.430  69.673  1.00 59.36           C  
ATOM    499  OG1 THR    60      40.676  27.731  68.642  1.00 59.76           O  
ATOM    500  CG2 THR    60      42.023  27.433  70.630  1.00 56.72           C  
ATOM    501  N   MET    61      38.809  30.682  68.978  1.00 60.58           N  
ATOM    502  CA  MET    61      38.537  31.613  67.887  1.00 62.59           C  
ATOM    503  C   MET    61      37.882  32.922  68.305  1.00 62.66           C  
ATOM    504  O   MET    61      37.505  33.689  67.422  1.00 63.60           O  
ATOM    505  CB  MET    61      37.683  30.942  66.796  1.00 62.56           C  
ATOM    506  CG  MET    61      38.402  29.794  66.080  1.00 67.94           C  
ATOM    507  SD  MET    61      39.847  30.478  64.868  0.90 83.32          SE  
ATOM    508  CE  MET    61      38.659  31.285  63.505  1.00 77.45           C  
ATOM    509  N   SER    62      37.721  33.171  69.610  1.00 61.38           N  
ATOM    510  CA  SER    62      37.147  34.424  70.072  1.00 61.72           C  
ATOM    511  C   SER    62      37.695  34.811  71.425  1.00 62.10           C  
ATOM    512  O   SER    62      38.123  33.954  72.211  1.00 62.73           O  
ATOM    513  CB  SER    62      35.625  34.314  70.193  1.00 61.40           C  
ATOM    514  OG  SER    62      35.327  33.225  71.043  1.00 61.28           O  
ATOM    515  N   SER    63      37.680  36.107  71.713  1.00 62.25           N  
ATOM    516  CA  SER    63      38.120  36.572  73.022  1.00 61.90           C  
ATOM    517  C   SER    63      37.217  35.966  74.109  1.00 61.96           C  
ATOM    518  O   SER    63      37.692  35.658  75.202  1.00 62.43           O  
ATOM    519  CB  SER    63      38.114  38.099  73.078  1.00 61.78           C  
ATOM    520  OG  SER    63      36.778  38.581  72.922  1.00 63.32           O  
ATOM    521  N   ASN    64      35.928  35.765  73.825  1.00 62.05           N  
ATOM    522  CA  ASN    64      35.058  35.037  74.789  1.00 63.21           C  
ATOM    523  C   ASN    64      35.599  33.635  75.064  1.00 62.15           C  
ATOM    524  O   ASN    64      35.608  33.220  76.205  1.00 62.11           O  
ATOM    525  CB  ASN    64      33.632  34.858  74.260  1.00 65.22           C  
ATOM    526  CG  ASN    64      32.778  36.042  74.477  1.00 68.29           C  
ATOM    527  OD1 ASN    64      32.593  36.515  75.600  1.00 79.28           O  
ATOM    528  ND2 ASN    64      32.227  36.524  73.425  1.00 70.86           N  
ATOM    529  N   GLY    65      36.030  32.934  74.000  1.00 60.23           N  
ATOM    530  CA  GLY    65      36.699  31.675  74.116  1.00 60.81           C  
ATOM    531  C   GLY    65      37.903  31.664  75.057  1.00 60.68           C  
ATOM    532  O   GLY    65      37.973  30.840  75.976  1.00 60.10           O  
ATOM    533  N   TRP    66      38.835  32.588  74.856  1.00 60.85           N  
ATOM    534  CA  TRP    66      40.039  32.658  75.709  1.00 60.06           C  
ATOM    535  C   TRP    66      39.646  32.902  77.155  1.00 61.15           C  
ATOM    536  O   TRP    66      40.247  32.351  78.101  1.00 61.99           O  
ATOM    537  CB  TRP    66      40.997  33.752  75.215  1.00 59.30           C  
ATOM    538  CG  TRP    66      41.271  33.740  73.697  1.00 57.28           C  
ATOM    539  CD1 TRP    66      41.269  32.654  72.901  1.00 57.25           C  
ATOM    540  CD2 TRP    66      41.640  34.855  72.848  1.00 57.57           C  
ATOM    541  NE1 TRP    66      41.578  32.999  71.603  1.00 59.16           N  
ATOM    542  CE2 TRP    66      41.805  34.345  71.537  1.00 58.40           C  
ATOM    543  CE3 TRP    66      41.845  36.233  73.066  1.00 57.46           C  
ATOM    544  CZ2 TRP    66      42.141  35.160  70.434  1.00 58.20           C  
ATOM    545  CZ3 TRP    66      42.174  37.045  71.978  1.00 57.05           C  
ATOM    546  CH2 TRP    66      42.321  36.504  70.679  1.00 58.18           C  
ATOM    547  N   MET    67      38.620  33.721  77.354  1.00 61.67           N  
ATOM    548  CA  MET    67      38.196  34.034  78.730  1.00 61.56           C  
ATOM    549  C   MET    67      37.675  32.751  79.398  1.00 61.45           C  
ATOM    550  O   MET    67      38.030  32.471  80.533  1.00 60.34           O  
ATOM    551  CB  MET    67      37.128  35.144  78.733  1.00 62.34           C  
ATOM    552  CG  MET    67      36.847  35.786  80.055  1.00 62.83           C  
ATOM    553  SD  MET    67      38.278  37.022  80.632  0.85 76.26          SE  
ATOM    554  CE  MET    67      38.995  36.079  82.228  1.00 64.02           C  
ATOM    555  N   LEU    68      36.867  31.969  78.669  1.00 61.35           N  
ATOM    556  CA  LEU    68      36.327  30.715  79.196  1.00 61.71           C  
ATOM    557  C   LEU    68      37.367  29.609  79.436  1.00 62.43           C  
ATOM    558  O   LEU    68      37.310  28.891  80.449  1.00 62.05           O  
ATOM    559  CB  LEU    68      35.192  30.211  78.333  1.00 60.42           C  
ATOM    560  CG  LEU    68      34.014  31.190  78.339  1.00 59.67           C  
ATOM    561  CD1 LEU    68      33.203  31.009  77.111  1.00 53.38           C  
ATOM    562  CD2 LEU    68      33.125  31.045  79.587  1.00 56.87           C  
ATOM    563  N   MET    69      38.317  29.487  78.513  1.00 63.63           N  
ATOM    564  CA  MET    69      39.427  28.542  78.640  1.00 64.95           C  
ATOM    565  C   MET    69      40.298  28.887  79.821  1.00 63.85           C  
ATOM    566  O   MET    69      40.834  27.978  80.490  1.00 64.09           O  
ATOM    567  CB  MET    69      40.270  28.585  77.399  1.00 64.13           C  
ATOM    568  CG  MET    69      39.630  27.926  76.207  1.00 66.68           C  
ATOM    569  SD  MET    69      40.939  27.724  74.726  0.80 72.58          SE  
ATOM    570  CE  MET    69      40.747  29.457  73.987  1.00 62.11           C  
ATOM    571  N   SER    70      40.446  30.189  80.094  1.00 62.96           N  
ATOM    572  CA  SER    70      41.251  30.621  81.248  1.00 62.56           C  
ATOM    573  C   SER    70      40.745  30.049  82.590  1.00 61.84           C  
ATOM    574  O   SER    70      41.468  30.041  83.576  1.00 59.67           O  
ATOM    575  CB  SER    70      41.397  32.144  81.294  1.00 62.63           C  
ATOM    576  OG  SER    70      40.243  32.758  81.855  1.00 63.93           O  
ATOM    577  N   THR    71      39.523  29.517  82.591  1.00 62.19           N  
ATOM    578  CA  THR    71      38.983  28.859  83.794  1.00 63.14           C  
ATOM    579  C   THR    71      39.332  27.364  83.967  1.00 63.92           C  
ATOM    580  O   THR    71      39.199  26.839  85.071  1.00 62.99           O  
ATOM    581  CB  THR    71      37.458  29.064  83.955  1.00 62.41           C  
ATOM    582  OG1 THR    71      36.769  28.302  82.965  1.00 62.66           O  
ATOM    583  CG2 THR    71      37.098  30.522  83.810  1.00 61.93           C  
ATOM    584  N   MET    72      39.778  26.694  82.897  1.00 65.08           N  
ATOM    585  CA  MET    72      40.146  25.276  82.957  1.00 67.60           C  
ATOM    586  C   MET    72      41.548  25.007  83.593  1.00 66.23           C  
ATOM    587  O   MET    72      42.373  25.922  83.722  1.00 65.90           O  
ATOM    588  CB  MET    72      40.104  24.668  81.553  1.00 67.24           C  
ATOM    589  CG  MET    72      38.781  24.730  80.785  1.00 68.31           C  
ATOM    590  SD  MET    72      39.303  24.612  78.854  0.83 75.69          SE  
ATOM    591  CE  MET    72      37.549  24.486  78.022  1.00 70.38           C  
ATOM    592  N   ASN    73      41.822  23.756  83.975  1.00 65.62           N  
ATOM    593  CA  ASN    73      43.211  23.352  84.255  1.00 65.21           C  
ATOM    594  C   ASN    73      44.043  23.140  82.967  1.00 64.52           C  
ATOM    595  O   ASN    73      43.489  23.091  81.854  1.00 64.27           O  
ATOM    596  CB  ASN    73      43.283  22.131  85.181  1.00 65.82           C  
ATOM    597  CG  ASN    73      42.587  20.888  84.604  1.00 67.09           C  
ATOM    598  OD1 ASN    73      42.952  20.361  83.538  1.00 64.81           O  
ATOM    599  ND2 ASN    73      41.595  20.394  85.344  1.00 69.28           N  
ATOM    600  N   ASP    74      45.366  23.035  83.110  1.00 63.68           N  
ATOM    601  CA  ASP    74      46.261  23.053  81.935  1.00 63.28           C  
ATOM    602  C   ASP    74      46.104  21.827  81.067  1.00 62.96           C  
ATOM    603  O   ASP    74      46.128  21.926  79.841  1.00 62.13           O  
ATOM    604  CB  ASP    74      47.734  23.235  82.331  1.00 63.20           C  
ATOM    605  CG  ASP    74      48.018  24.603  82.948  1.00 62.80           C  
ATOM    606  OD1 ASP    74      47.344  25.614  82.582  1.00 57.50           O  
ATOM    607  OD2 ASP    74      48.943  24.654  83.805  1.00 63.27           O  
ATOM    608  N   LYS    75      45.951  20.669  81.716  1.00 63.12           N  
ATOM    609  CA  LYS    75      45.617  19.425  81.016  1.00 63.50           C  
ATOM    610  C   LYS    75      44.442  19.643  80.021  1.00 62.99           C  
ATOM    611  O   LYS    75      44.553  19.282  78.838  1.00 62.58           O  
ATOM    612  CB  LYS    75      45.302  18.311  82.018  1.00 64.00           C  
ATOM    613  CG  LYS    75      44.618  17.073  81.419  1.00 66.39           C  
ATOM    614  CD  LYS    75      45.609  16.170  80.682  1.00 68.66           C  
ATOM    615  CE  LYS    75      45.215  14.702  80.810  1.00 69.70           C  
ATOM    616  NZ  LYS    75      44.822  14.371  82.205  1.00 68.07           N  
ATOM    617  N   ALA    76      43.358  20.251  80.518  1.00 62.16           N  
ATOM    618  CA  ALA    76      42.173  20.555  79.738  1.00 61.81           C  
ATOM    619  C   ALA    76      42.404  21.654  78.702  1.00 61.74           C  
ATOM    620  O   ALA    76      41.778  21.620  77.655  1.00 62.13           O  
ATOM    621  CB  ALA    76      40.962  20.889  80.643  1.00 61.24           C  
ATOM    622  N   ILE    77      43.291  22.611  78.960  1.00 61.38           N  
ATOM    623  CA  ILE    77      43.527  23.668  77.966  1.00 61.49           C  
ATOM    624  C   ILE    77      44.270  23.122  76.741  1.00 61.52           C  
ATOM    625  O   ILE    77      43.900  23.431  75.582  1.00 61.15           O  
ATOM    626  CB  ILE    77      44.272  24.870  78.563  1.00 61.79           C  
ATOM    627  CG1 ILE    77      43.304  25.714  79.384  1.00 62.94           C  
ATOM    628  CG2 ILE    77      44.891  25.749  77.483  1.00 61.12           C  
ATOM    629  CD1 ILE    77      44.013  26.581  80.448  1.00 64.59           C  
ATOM    630  N   ASP    78      45.301  22.325  77.025  1.00 60.60           N  
ATOM    631  CA  ASP    78      46.123  21.617  76.035  1.00 60.87           C  
ATOM    632  C   ASP    78      45.265  20.716  75.162  1.00 60.02           C  
ATOM    633  O   ASP    78      45.365  20.782  73.944  1.00 60.82           O  
ATOM    634  CB  ASP    78      47.235  20.818  76.743  1.00 61.04           C  
ATOM    635  CG  ASP    78      48.164  20.069  75.768  1.00 63.40           C  
ATOM    636  OD1 ASP    78      49.198  20.665  75.346  1.00 64.85           O  
ATOM    637  OD2 ASP    78      47.897  18.863  75.476  1.00 63.02           O  
ATOM    638  N   ASN    79      44.386  19.920  75.764  1.00 58.88           N  
ATOM    639  CA  ASN    79      43.433  19.133  74.969  1.00 58.94           C  
ATOM    640  C   ASN    79      42.545  20.000  74.060  1.00 58.14           C  
ATOM    641  O   ASN    79      42.268  19.633  72.918  1.00 57.90           O  
ATOM    642  CB  ASN    79      42.566  18.223  75.848  1.00 59.09           C  
ATOM    643  CG  ASN    79      43.241  16.904  76.173  1.00 62.16           C  
ATOM    644  OD1 ASN    79      43.004  16.335  77.229  1.00 68.10           O  
ATOM    645  ND2 ASN    79      44.111  16.423  75.286  1.00 64.79           N  
ATOM    646  N   THR    80      42.128  21.144  74.586  1.00 56.98           N  
ATOM    647  CA  THR    80      41.215  22.041  73.923  1.00 56.94           C  
ATOM    648  C   THR    80      41.865  22.679  72.704  1.00 57.00           C  
ATOM    649  O   THR    80      41.270  22.741  71.660  1.00 56.26           O  
ATOM    650  CB  THR    80      40.747  23.142  74.904  1.00 56.98           C  
ATOM    651  OG1 THR    80      40.079  22.527  76.017  1.00 57.25           O  
ATOM    652  CG2 THR    80      39.822  24.144  74.210  1.00 54.70           C  
ATOM    653  N   VAL    81      43.106  23.121  72.845  1.00 57.77           N  
ATOM    654  CA  VAL    81      43.812  23.793  71.760  1.00 58.51           C  
ATOM    655  C   VAL    81      44.132  22.771  70.661  1.00 59.17           C  
ATOM    656  O   VAL    81      43.908  23.026  69.446  1.00 59.51           O  
ATOM    657  CB  VAL    81      45.077  24.485  72.298  1.00 58.47           C  
ATOM    658  CG1 VAL    81      45.956  25.012  71.173  1.00 59.77           C  
ATOM    659  CG2 VAL    81      44.667  25.627  73.229  1.00 58.29           C  
ATOM    660  N   ARG    82      44.650  21.625  71.097  1.00 58.86           N  
ATOM    661  CA  ARG    82      44.843  20.479  70.223  1.00 59.54           C  
ATOM    662  C   ARG    82      43.578  20.079  69.460  1.00 58.76           C  
ATOM    663  O   ARG    82      43.616  19.944  68.232  1.00 58.98           O  
ATOM    664  CB  ARG    82      45.336  19.280  71.016  1.00 59.66           C  
ATOM    665  CG  ARG    82      46.764  19.394  71.436  1.00 62.54           C  
ATOM    666  CD  ARG    82      47.353  18.008  71.689  1.00 68.17           C  
ATOM    667  NE  ARG    82      48.644  18.100  72.370  1.00 72.16           N  
ATOM    668  CZ  ARG    82      49.756  18.641  71.857  1.00 74.78           C  
ATOM    669  NH1 ARG    82      50.854  18.663  72.601  1.00 77.11           N  
ATOM    670  NH2 ARG    82      49.788  19.166  70.627  1.00 74.25           N  
ATOM    671  N   ARG    83      42.471  19.868  70.171  1.00 57.49           N  
ATOM    672  CA  ARG    83      41.263  19.414  69.504  1.00 56.42           C  
ATOM    673  C   ARG    83      40.747  20.521  68.593  1.00 57.09           C  
ATOM    674  O   ARG    83      40.403  20.291  67.422  1.00 57.36           O  
ATOM    675  CB  ARG    83      40.222  19.001  70.508  1.00 55.85           C  
ATOM    676  CG  ARG    83      40.414  17.634  71.086  1.00 52.71           C  
ATOM    677  CD  ARG    83      39.437  17.479  72.198  1.00 49.77           C  
ATOM    678  NE  ARG    83      38.088  17.644  71.693  1.00 50.59           N  
ATOM    679  CZ  ARG    83      36.995  17.770  72.437  1.00 51.09           C  
ATOM    680  NH1 ARG    83      35.796  17.947  71.861  1.00 52.66           N  
ATOM    681  NH2 ARG    83      37.089  17.758  73.743  1.00 48.77           N  
ATOM    682  N   ALA    84      40.759  21.740  69.114  1.00 56.57           N  
ATOM    683  CA  ALA    84      40.339  22.870  68.356  1.00 56.57           C  
ATOM    684  C   ALA    84      41.197  23.105  67.084  1.00 57.76           C  
ATOM    685  O   ALA    84      40.669  23.593  66.068  1.00 57.61           O  
ATOM    686  CB  ALA    84      40.286  24.127  69.264  1.00 55.96           C  
ATOM    687  N   ASN    85      42.490  22.782  67.118  1.00 58.24           N  
ATOM    688  CA  ASN    85      43.273  22.956  65.905  1.00 60.37           C  
ATOM    689  C   ASN    85      42.833  22.048  64.775  1.00 60.82           C  
ATOM    690  O   ASN    85      42.806  22.477  63.633  1.00 60.37           O  
ATOM    691  CB  ASN    85      44.775  22.831  66.141  1.00 60.47           C  
ATOM    692  CG  ASN    85      45.333  24.018  66.874  1.00 62.26           C  
ATOM    693  OD1 ASN    85      44.775  25.138  66.813  1.00 63.47           O  
ATOM    694  ND2 ASN    85      46.422  23.794  67.594  1.00 60.57           N  
ATOM    695  N   THR    86      42.459  20.806  65.091  1.00 61.75           N  
ATOM    696  CA  THR    86      42.035  19.873  64.035  1.00 62.30           C  
ATOM    697  C   THR    86      40.785  20.329  63.280  1.00 63.07           C  
ATOM    698  O   THR    86      40.472  19.804  62.212  1.00 63.65           O  
ATOM    699  CB  THR    86      41.828  18.456  64.559  1.00 62.23           C  
ATOM    700  OG1 THR    86      40.606  18.376  65.330  1.00 61.94           O  
ATOM    701  CG2 THR    86      43.042  18.049  65.370  1.00 60.63           C  
ATOM    702  N   ILE    87      40.077  21.290  63.854  1.00 63.43           N  
ATOM    703  CA  ILE    87      38.855  21.778  63.286  1.00 64.20           C  
ATOM    704  C   ILE    87      39.097  23.083  62.491  1.00 65.71           C  
ATOM    705  O   ILE    87      38.612  23.241  61.347  1.00 66.80           O  
ATOM    706  CB  ILE    87      37.839  22.037  64.409  1.00 64.04           C  
ATOM    707  CG1 ILE    87      37.428  20.720  65.060  1.00 64.25           C  
ATOM    708  CG2 ILE    87      36.622  22.825  63.896  1.00 61.32           C  
ATOM    709  CD1 ILE    87      36.579  20.902  66.315  1.00 64.40           C  
ATOM    710  N   THR    88      39.830  24.013  63.109  1.00 65.78           N  
ATOM    711  CA  THR    88      40.080  25.292  62.519  1.00 65.90           C  
ATOM    712  C   THR    88      41.104  25.172  61.410  1.00 67.94           C  
ATOM    713  O   THR    88      41.161  26.035  60.520  1.00 68.74           O  
ATOM    714  CB  THR    88      40.510  26.352  63.552  1.00 65.51           C  
ATOM    715  OG1 THR    88      41.762  26.000  64.153  1.00 62.03           O  
ATOM    716  CG2 THR    88      39.449  26.507  64.601  1.00 62.86           C  
ATOM    717  N   GLN    89      41.891  24.109  61.435  1.00 69.42           N  
ATOM    718  CA  GLN    89      42.896  23.928  60.401  1.00 72.17           C  
ATOM    719  C   GLN    89      42.322  23.397  59.095  1.00 73.16           C  
ATOM    720  O   GLN    89      43.009  23.403  58.065  1.00 73.16           O  
ATOM    721  CB  GLN    89      44.039  23.048  60.878  1.00 72.31           C  
ATOM    722  CG  GLN    89      43.839  21.604  60.590  1.00 74.64           C  
ATOM    723  CD  GLN    89      45.043  20.815  61.004  1.00 79.85           C  
ATOM    724  OE1 GLN    89      46.007  21.388  61.534  1.00 82.02           O  
ATOM    725  NE2 GLN    89      45.011  19.489  60.776  1.00 79.99           N  
ATOM    726  N   LYS    90      41.071  22.948  59.138  1.00 75.07           N  
ATOM    727  CA  LYS    90      40.334  22.613  57.916  1.00 76.91           C  
ATOM    728  C   LYS    90      40.078  23.899  57.120  1.00 77.20           C  
ATOM    729  O   LYS    90      39.646  23.844  55.972  1.00 77.61           O  
ATOM    730  CB  LYS    90      39.009  21.910  58.248  1.00 76.83           C  
ATOM    731  CG  LYS    90      39.163  20.447  58.696  1.00 78.58           C  
ATOM    732  CD  LYS    90      37.796  19.756  58.977  1.00 78.62           C  
ATOM    733  CE  LYS    90      37.079  20.337  60.220  1.00 80.18           C  
ATOM    734  NZ  LYS    90      36.280  19.307  60.970  1.00 78.76           N  
ATOM    735  N   ASP    91      40.348  25.045  57.747  1.00 77.44           N  
ATOM    736  CA  ASP    91      40.246  26.365  57.120  1.00 77.76           C  
ATOM    737  C   ASP    91      41.585  27.103  57.126  1.00 77.52           C  
ATOM    738  O   ASP    91      41.632  28.325  56.987  1.00 77.39           O  
ATOM    739  CB  ASP    91      39.208  27.222  57.867  1.00 78.38           C  
ATOM    740  CG  ASP    91      37.829  26.569  57.912  1.00 80.49           C  
ATOM    741  OD1 ASP    91      37.535  25.680  57.065  1.00 82.90           O  
ATOM    742  OD2 ASP    91      37.031  26.950  58.792  1.00 82.18           O  
ATOM    743  N   GLY    92      42.672  26.362  57.299  1.00 77.83           N  
ATOM    744  CA  GLY    92      44.023  26.940  57.329  1.00 78.14           C  
ATOM    745  C   GLY    92      44.409  27.771  58.555  1.00 78.53           C  
ATOM    746  O   GLY    92      45.425  28.465  58.523  1.00 79.06           O  
ATOM    747  N   ILE    93      43.619  27.708  59.627  1.00 78.12           N  
ATOM    748  CA  ILE    93      43.927  28.425  60.856  1.00 78.01           C  
ATOM    749  C   ILE    93      44.383  27.445  61.948  1.00 78.31           C  
ATOM    750  O   ILE    93      43.752  26.410  62.152  1.00 78.15           O  
ATOM    751  CB  ILE    93      42.682  29.204  61.341  1.00 78.66           C  
ATOM    752  CG1 ILE    93      42.101  30.093  60.211  1.00 78.35           C  
ATOM    753  CG2 ILE    93      42.945  29.921  62.713  1.00 76.93           C  
ATOM    754  CD1 ILE    93      43.079  31.140  59.608  1.00 81.98           C  
ATOM    755  N   ARG    94      45.467  27.756  62.653  1.00 78.39           N  
ATOM    756  CA  ARG    94      45.864  26.906  63.778  1.00 79.60           C  
ATOM    757  C   ARG    94      46.863  27.551  64.739  1.00 79.87           C  
ATOM    758  O   ARG    94      47.994  27.826  64.356  1.00 80.34           O  
ATOM    759  CB  ARG    94      46.404  25.546  63.289  1.00 79.45           C  
ATOM    760  CG  ARG    94      47.917  25.471  63.148  1.00 80.34           C  
ATOM    761  CD  ARG    94      48.417  24.130  62.626  1.00 80.98           C  
ATOM    762  NE  ARG    94      48.116  23.009  63.522  1.00 83.82           N  
ATOM    763  CZ  ARG    94      48.738  22.766  64.678  1.00 84.40           C  
ATOM    764  NH1 ARG    94      49.699  23.581  65.130  1.00 83.20           N  
ATOM    765  NH2 ARG    94      48.384  21.703  65.397  1.00 83.66           N  
ATOM    766  N   PHE    95      46.456  27.734  65.994  1.00 80.07           N  
ATOM    767  CA  PHE    95      47.285  28.366  67.031  1.00 80.20           C  
ATOM    768  C   PHE    95      48.290  27.422  67.702  1.00 80.50           C  
ATOM    769  O   PHE    95      47.963  26.281  68.021  1.00 80.42           O  
ATOM    770  CB  PHE    95      46.379  29.004  68.083  1.00 80.47           C  
ATOM    771  CG  PHE    95      45.260  29.821  67.488  1.00 80.99           C  
ATOM    772  CD1 PHE    95      45.473  31.141  67.111  1.00 81.79           C  
ATOM    773  CD2 PHE    95      44.012  29.254  67.261  1.00 80.65           C  
ATOM    774  CE1 PHE    95      44.448  31.894  66.533  1.00 83.00           C  
ATOM    775  CE2 PHE    95      42.980  29.995  66.685  1.00 82.25           C  
ATOM    776  CZ  PHE    95      43.192  31.318  66.327  1.00 82.26           C  
ATOM    777  N   GLU    96      49.522  27.882  67.905  1.00 80.58           N  
ATOM    778  CA  GLU    96      50.494  27.020  68.550  1.00 81.30           C  
ATOM    779  C   GLU    96      50.231  26.970  70.046  1.00 80.62           C  
ATOM    780  O   GLU    96      50.088  28.001  70.710  1.00 80.58           O  
ATOM    781  CB  GLU    96      51.942  27.422  68.240  1.00 82.00           C  
ATOM    782  CG  GLU    96      52.438  27.100  66.785  1.00 85.70           C  
ATOM    783  CD  GLU    96      52.380  25.603  66.391  1.00 88.37           C  
ATOM    784  OE1 GLU    96      53.160  24.794  66.957  1.00 87.64           O  
ATOM    785  OE2 GLU    96      51.555  25.257  65.500  1.00 89.69           O  
ATOM    786  N   VAL    97      50.152  25.751  70.559  1.00 80.00           N  
ATOM    787  CA  VAL    97      49.779  25.512  71.943  1.00 79.52           C  
ATOM    788  C   VAL    97      50.508  26.506  72.853  1.00 79.00           C  
ATOM    789  O   VAL    97      49.884  27.239  73.624  1.00 79.10           O  
ATOM    790  CB  VAL    97      50.003  24.009  72.319  1.00 79.44           C  
ATOM    791  CG1 VAL    97      51.460  23.558  72.020  1.00 81.14           C  
ATOM    792  CG2 VAL    97      49.593  23.714  73.766  1.00 78.94           C  
ATOM    793  N   ASP    98      51.826  26.549  72.704  1.00 78.35           N  
ATOM    794  CA  ASP    98      52.696  27.550  73.308  1.00 77.56           C  
ATOM    795  C   ASP    98      52.109  28.969  73.485  1.00 76.70           C  
ATOM    796  O   ASP    98      51.942  29.435  74.613  1.00 76.47           O  
ATOM    797  CB  ASP    98      53.966  27.631  72.460  0.60 77.75           C  
ATOM    798  CG  ASP    98      55.156  28.053  73.258  0.60 78.16           C  
ATOM    799  OD1 ASP    98      55.026  28.992  74.072  0.60 78.47           O  
ATOM    800  OD2 ASP    98      56.226  27.440  73.072  0.60 79.39           O  
ATOM    801  N   ASP    99      51.786  29.611  72.368  0.60 76.19           N  
ATOM    803  CA  ASP    99      51.334  30.997  72.340  0.60 75.94           C  
ATOM    805  C   ASP    99      49.880  31.178  72.794  0.60 75.52           C  
ATOM    807  O   ASP    99      49.511  32.196  73.385  0.60 75.43           O  
ATOM    809  CB  ASP    99      51.500  31.548  70.923  0.60 76.07           C  
ATOM    811  CG  ASP    99      52.906  31.364  70.386  0.60 76.52           C  
ATOM    813  OD1 ASP    99      53.090  31.409  69.148  0.60 77.25           O  
ATOM    815  OD2 ASP    99      53.830  31.168  71.201  0.60 77.63           O  
ATOM    817  N   MET   100      49.047  30.200  72.489  1.00 75.00           N  
ATOM    818  CA  MET   100      47.674  30.236  72.938  1.00 74.50           C  
ATOM    819  C   MET   100      47.674  30.109  74.478  1.00 73.72           C  
ATOM    820  O   MET   100      47.061  30.907  75.168  1.00 73.25           O  
ATOM    821  CB  MET   100      46.866  29.138  72.262  1.00 74.34           C  
ATOM    822  CG  MET   100      45.425  29.075  72.717  1.00 75.88           C  
ATOM    823  SD  MET   100      44.372  30.641  72.207  0.85 76.98          SE  
ATOM    824  CE  MET   100      44.151  31.437  73.926  1.00 75.18           C  
ATOM    825  N   MET   101      48.427  29.135  74.992  1.00 72.91           N  
ATOM    826  CA  MET   101      48.593  28.908  76.424  1.00 72.12           C  
ATOM    827  C   MET   101      49.163  30.128  77.135  1.00 71.11           C  
ATOM    828  O   MET   101      48.882  30.349  78.288  1.00 70.87           O  
ATOM    829  CB  MET   101      49.515  27.710  76.631  1.00 72.60           C  
ATOM    830  CG  MET   101      49.809  27.395  78.061  1.00 73.93           C  
ATOM    831  SD  MET   101      48.149  26.866  78.967  0.60 77.64          SE  
ATOM    832  CE  MET   101      48.324  24.912  78.642  1.00 75.16           C  
ATOM    833  N   ALA   102      49.978  30.897  76.422  1.00 70.44           N  
ATOM    834  CA  ALA   102      50.494  32.171  76.882  1.00 69.35           C  
ATOM    835  C   ALA   102      49.409  33.231  76.908  1.00 68.45           C  
ATOM    836  O   ALA   102      49.242  33.887  77.920  1.00 68.65           O  
ATOM    837  CB  ALA   102      51.652  32.613  76.008  1.00 69.18           C  
ATOM    838  N   ARG   103      48.670  33.396  75.810  1.00 68.30           N  
ATOM    839  CA  ARG   103      47.555  34.377  75.743  1.00 67.14           C  
ATOM    840  C   ARG   103      46.513  34.122  76.825  1.00 65.74           C  
ATOM    841  O   ARG   103      46.047  35.029  77.483  1.00 65.11           O  
ATOM    842  CB  ARG   103      46.894  34.389  74.352  1.00 67.51           C  
ATOM    843  CG  ARG   103      45.843  35.526  74.092  1.00 69.99           C  
ATOM    844  CD  ARG   103      46.368  36.997  74.358  1.00 77.43           C  
ATOM    845  NE  ARG   103      46.236  37.886  73.177  1.00 81.71           N  
ATOM    846  CZ  ARG   103      45.219  38.730  72.955  1.00 85.14           C  
ATOM    847  NH1 ARG   103      44.228  38.831  73.838  1.00 87.71           N  
ATOM    848  NH2 ARG   103      45.170  39.478  71.844  1.00 85.06           N  
ATOM    849  N   ILE   104      46.155  32.866  77.003  1.00 65.17           N  
ATOM    850  CA  ILE   104      45.250  32.469  78.072  1.00 64.96           C  
ATOM    851  C   ILE   104      45.767  32.813  79.462  1.00 64.64           C  
ATOM    852  O   ILE   104      45.010  33.294  80.291  1.00 64.83           O  
ATOM    853  CB  ILE   104      44.872  30.974  77.981  1.00 64.89           C  
ATOM    854  CG1 ILE   104      43.935  30.769  76.796  1.00 66.45           C  
ATOM    855  CG2 ILE   104      44.174  30.506  79.264  1.00 64.73           C  
ATOM    856  CD1 ILE   104      43.932  29.348  76.238  1.00 70.32           C  
ATOM    857  N   ARG   105      47.046  32.581  79.719  0.60 64.58           N  
ATOM    859  CA  ARG   105      47.571  32.898  81.044  0.60 64.64           C  
ATOM    861  C   ARG   105      47.507  34.418  81.296  0.60 65.04           C  
ATOM    863  O   ARG   105      47.146  34.856  82.401  0.60 65.11           O  
ATOM    865  CB  ARG   105      48.959  32.268  81.268  0.60 64.15           C  
ATOM    867  CG  ARG   105      49.019  30.745  80.916  0.60 62.26           C  
ATOM    869  CD  ARG   105      49.908  29.930  81.861  0.60 59.20           C  
ATOM    871  NE  ARG   105      50.733  28.913  81.192  0.60 56.19           N  
ATOM    873  CZ  ARG   105      50.648  27.599  81.405  0.60 53.93           C  
ATOM    875  NH1 ARG   105      51.453  26.771  80.766  0.60 52.55           N  
ATOM    877  NH2 ARG   105      49.757  27.107  82.249  0.60 52.59           N  
ATOM    879  N   GLN   106      47.782  35.202  80.250  1.00 65.19           N  
ATOM    880  CA  GLN   106      47.661  36.674  80.283  1.00 66.44           C  
ATOM    881  C   GLN   106      46.219  37.148  80.563  1.00 66.11           C  
ATOM    882  O   GLN   106      45.987  38.039  81.370  1.00 65.91           O  
ATOM    883  CB  GLN   106      48.139  37.258  78.936  1.00 66.21           C  
ATOM    884  CG  GLN   106      48.160  38.781  78.873  1.00 68.89           C  
ATOM    885  CD  GLN   106      48.161  39.330  77.451  1.00 69.30           C  
ATOM    886  OE1 GLN   106      47.230  39.099  76.691  1.00 78.30           O  
ATOM    887  NE2 GLN   106      49.198  40.075  77.094  1.00 73.54           N  
ATOM    888  N   VAL   107      45.251  36.538  79.892  1.00 66.18           N  
ATOM    889  CA  VAL   107      43.862  36.931  80.045  1.00 66.70           C  
ATOM    890  C   VAL   107      43.368  36.703  81.494  1.00 67.44           C  
ATOM    891  O   VAL   107      42.708  37.561  82.099  1.00 66.39           O  
ATOM    892  CB  VAL   107      43.007  36.198  79.002  1.00 66.50           C  
ATOM    893  CG1 VAL   107      41.573  35.994  79.503  1.00 66.31           C  
ATOM    894  CG2 VAL   107      43.053  36.959  77.686  1.00 64.13           C  
ATOM    895  N   ARG   108      43.711  35.531  82.025  1.00 68.65           N  
ATOM    896  CA  ARG   108      43.437  35.162  83.410  1.00 69.82           C  
ATOM    897  C   ARG   108      44.035  36.222  84.356  1.00 71.05           C  
ATOM    898  O   ARG   108      43.384  36.638  85.340  1.00 70.77           O  
ATOM    899  CB  ARG   108      43.991  33.751  83.721  1.00 69.62           C  
ATOM    900  CG  ARG   108      43.597  33.210  85.119  1.00 69.62           C  
ATOM    901  CD  ARG   108      44.401  31.981  85.533  1.00 68.90           C  
ATOM    902  NE  ARG   108      44.109  30.834  84.678  1.00 67.11           N  
ATOM    903  CZ  ARG   108      45.010  29.969  84.222  1.00 65.78           C  
ATOM    904  NH1 ARG   108      44.619  28.965  83.441  1.00 62.37           N  
ATOM    905  NH2 ARG   108      46.297  30.107  84.545  1.00 67.13           N  
ATOM    906  N   GLU   109      45.259  36.661  84.034  1.00 72.13           N  
ATOM    907  CA  GLU   109      45.939  37.716  84.794  1.00 73.60           C  
ATOM    908  C   GLU   109      45.204  39.061  84.741  1.00 73.35           C  
ATOM    909  O   GLU   109      44.693  39.530  85.763  1.00 73.58           O  
ATOM    910  CB  GLU   109      47.385  37.880  84.320  1.00 73.60           C  
ATOM    911  CG  GLU   109      48.345  38.293  85.440  1.00 74.84           C  
ATOM    912  CD  GLU   109      49.683  38.819  84.920  1.00 75.40           C  
ATOM    913  OE1 GLU   109      49.694  39.511  83.867  1.00 78.84           O  
ATOM    914  OE2 GLU   109      50.721  38.555  85.572  1.00 75.88           O  
ATOM    915  N   GLN   110      45.117  39.652  83.547  1.00 73.36           N  
ATOM    916  CA  GLN   110      44.529  40.995  83.375  1.00 72.79           C  
ATOM    917  C   GLN   110      43.013  41.152  83.647  1.00 71.55           C  
ATOM    918  O   GLN   110      42.564  42.291  83.828  1.00 71.83           O  
ATOM    919  CB  GLN   110      44.899  41.578  82.006  1.00 72.97           C  
ATOM    920  CG  GLN   110      44.154  40.900  80.880  1.00 74.32           C  
ATOM    921  CD  GLN   110      44.831  41.080  79.538  1.00 75.81           C  
ATOM    922  OE1 GLN   110      46.072  41.145  79.455  1.00 74.48           O  
ATOM    923  NE2 GLN   110      44.016  41.145  78.467  1.00 73.00           N  
ATOM    924  N   GLY   111      42.251  40.048  83.693  1.00 70.23           N  
ATOM    925  CA  GLY   111      40.821  40.054  84.127  1.00 68.74           C  
ATOM    926  C   GLY   111      39.765  40.105  83.019  1.00 68.41           C  
ATOM    927  O   GLY   111      38.535  40.009  83.267  1.00 67.72           O  
ATOM    928  N   TYR   112      40.237  40.245  81.785  1.00 67.60           N  
ATOM    929  CA  TYR   112      39.367  40.447  80.621  1.00 67.38           C  
ATOM    930  C   TYR   112      40.115  40.034  79.362  1.00 66.21           C  
ATOM    931  O   TYR   112      41.348  39.829  79.414  1.00 66.31           O  
ATOM    932  CB  TYR   112      39.012  41.939  80.477  1.00 68.34           C  
ATOM    933  CG  TYR   112      40.254  42.789  80.427  1.00 70.12           C  
ATOM    934  CD1 TYR   112      40.904  43.058  79.212  1.00 72.48           C  
ATOM    935  CD2 TYR   112      40.811  43.296  81.603  1.00 70.44           C  
ATOM    936  CE1 TYR   112      42.092  43.844  79.176  1.00 72.21           C  
ATOM    937  CE2 TYR   112      41.962  44.071  81.575  1.00 72.48           C  
ATOM    938  CZ  TYR   112      42.597  44.334  80.362  1.00 72.07           C  
ATOM    939  OH  TYR   112      43.740  45.103  80.381  1.00 73.81           O  
ATOM    940  N   ALA   113      39.396  39.973  78.232  1.00 63.62           N  
ATOM    941  CA  ALA   113      40.045  39.704  76.957  1.00 62.19           C  
ATOM    942  C   ALA   113      39.529  40.638  75.861  1.00 61.50           C  
ATOM    943  O   ALA   113      38.406  41.113  75.914  1.00 62.63           O  
ATOM    944  CB  ALA   113      39.874  38.221  76.557  1.00 61.70           C  
ATOM    945  N   SER   114      40.363  40.940  74.895  1.00 59.84           N  
ATOM    946  CA  SER   114      39.903  41.583  73.708  1.00 59.77           C  
ATOM    947  C   SER   114      40.680  41.049  72.491  1.00 59.17           C  
ATOM    948  O   SER   114      41.711  40.411  72.631  1.00 58.24           O  
ATOM    949  CB  SER   114      40.004  43.083  73.840  1.00 59.57           C  
ATOM    950  OG  SER   114      41.356  43.445  74.060  1.00 62.96           O  
ATOM    951  N   ALA   115      40.152  41.309  71.306  1.00 59.12           N  
ATOM    952  CA  ALA   115      40.660  40.719  70.093  1.00 59.65           C  
ATOM    953  C   ALA   115      40.253  41.616  68.966  1.00 60.51           C  
ATOM    954  O   ALA   115      39.161  42.214  68.986  1.00 60.26           O  
ATOM    955  CB  ALA   115      40.033  39.339  69.879  1.00 59.03           C  
ATOM    956  N   GLU   116      41.131  41.683  67.979  1.00 61.40           N  
ATOM    957  CA  GLU   116      40.941  42.411  66.748  1.00 62.48           C  
ATOM    958  C   GLU   116      40.932  41.386  65.627  1.00 61.94           C  
ATOM    959  O   GLU   116      41.831  40.534  65.562  1.00 61.71           O  
ATOM    960  CB  GLU   116      42.178  43.242  66.470  1.00 62.91           C  
ATOM    961  CG  GLU   116      42.362  44.501  67.253  1.00 64.87           C  
ATOM    962  CD  GLU   116      43.608  45.273  66.759  1.00 66.94           C  
ATOM    963  OE1 GLU   116      44.407  44.722  65.917  1.00 68.23           O  
ATOM    964  OE2 GLU   116      43.771  46.437  67.224  1.00 72.76           O  
ATOM    965  N   HIS   117      39.970  41.495  64.716  1.00 60.74           N  
ATOM    966  CA  HIS   117      39.988  40.687  63.512  1.00 60.71           C  
ATOM    967  C   HIS   117      39.903  39.218  63.820  1.00 60.41           C  
ATOM    968  O   HIS   117      40.269  38.431  62.958  1.00 60.05           O  
ATOM    969  CB  HIS   117      41.242  40.943  62.639  1.00 60.33           C  
ATOM    970  CG  HIS   117      41.425  42.375  62.226  1.00 62.23           C  
ATOM    971  ND1 HIS   117      40.464  43.092  61.535  1.00 61.62           N  
ATOM    972  CD2 HIS   117      42.476  43.214  62.375  1.00 62.71           C  
ATOM    973  CE1 HIS   117      40.911  44.310  61.292  1.00 62.55           C  
ATOM    974  NE2 HIS   117      42.131  44.410  61.787  1.00 63.71           N  
ATOM    975  N   ILE   118      39.426  38.847  65.023  1.00 60.21           N  
ATOM    976  CA  ILE   118      39.269  37.410  65.396  1.00 59.96           C  
ATOM    977  C   ILE   118      37.957  37.150  66.138  1.00 59.73           C  
ATOM    978  O   ILE   118      37.735  37.670  67.213  1.00 59.45           O  
ATOM    979  CB  ILE   118      40.476  36.841  66.252  1.00 60.60           C  
ATOM    980  CG1 ILE   118      41.818  37.029  65.538  1.00 59.99           C  
ATOM    981  CG2 ILE   118      40.294  35.302  66.526  1.00 60.37           C  
ATOM    982  CD1 ILE   118      43.051  36.832  66.477  1.00 59.96           C  
ATOM    983  N   PRO   119      37.076  36.328  65.576  1.00 59.63           N  
ATOM    984  CA  PRO   119      37.199  35.472  64.393  1.00 60.42           C  
ATOM    985  C   PRO   119      37.065  36.229  63.055  1.00 61.73           C  
ATOM    986  O   PRO   119      37.340  35.635  62.013  1.00 62.71           O  
ATOM    987  CB  PRO   119      36.018  34.497  64.547  1.00 59.89           C  
ATOM    988  CG  PRO   119      34.937  35.379  65.254  1.00 58.78           C  
ATOM    989  CD  PRO   119      35.720  36.306  66.159  1.00 59.32           C  
ATOM    990  N   PHE   120      36.657  37.504  63.051  1.00 61.12           N  
ATOM    991  CA  PHE   120      36.338  38.119  61.762  1.00 61.12           C  
ATOM    992  C   PHE   120      37.054  39.400  61.460  1.00 59.48           C  
ATOM    993  O   PHE   120      37.082  40.301  62.261  1.00 58.42           O  
ATOM    994  CB  PHE   120      34.828  38.341  61.622  1.00 62.74           C  
ATOM    995  CG  PHE   120      34.035  37.086  61.735  1.00 64.36           C  
ATOM    996  CD1 PHE   120      34.295  36.006  60.866  1.00 70.01           C  
ATOM    997  CD2 PHE   120      33.064  36.952  62.726  1.00 65.69           C  
ATOM    998  CE1 PHE   120      33.561  34.780  60.953  1.00 69.09           C  
ATOM    999  CE2 PHE   120      32.304  35.779  62.819  1.00 66.11           C  
ATOM   1000  CZ  PHE   120      32.553  34.681  61.937  1.00 66.98           C  
ATOM   1001  N   VAL   121      37.599  39.469  60.256  1.00 58.64           N  
ATOM   1002  CA  VAL   121      38.232  40.683  59.767  1.00 58.37           C  
ATOM   1003  C   VAL   121      37.274  41.873  59.847  1.00 56.99           C  
ATOM   1004  O   VAL   121      36.136  41.809  59.367  1.00 55.51           O  
ATOM   1005  CB  VAL   121      38.725  40.438  58.336  1.00 59.00           C  
ATOM   1006  CG1 VAL   121      39.244  41.673  57.723  1.00 59.59           C  
ATOM   1007  CG2 VAL   121      39.812  39.386  58.387  1.00 60.30           C  
ATOM   1008  N   GLY   122      37.746  42.924  60.514  1.00 56.40           N  
ATOM   1009  CA  GLY   122      37.050  44.197  60.644  1.00 55.08           C  
ATOM   1010  C   GLY   122      36.289  44.261  61.944  1.00 55.39           C  
ATOM   1011  O   GLY   122      35.644  45.275  62.246  1.00 54.99           O  
ATOM   1012  N   GLY   123      36.351  43.178  62.720  1.00 55.30           N  
ATOM   1013  CA  GLY   123      35.632  43.117  63.990  1.00 56.21           C  
ATOM   1014  C   GLY   123      36.539  43.368  65.186  1.00 57.60           C  
ATOM   1015  O   GLY   123      37.764  43.195  65.105  1.00 58.87           O  
ATOM   1016  N   GLY   124      35.937  43.769  66.299  1.00 57.60           N  
ATOM   1017  CA  GLY   124      36.615  43.964  67.568  1.00 56.76           C  
ATOM   1018  C   GLY   124      35.654  43.511  68.645  1.00 57.59           C  
ATOM   1019  O   GLY   124      34.438  43.674  68.502  1.00 58.68           O  
ATOM   1020  N   THR   125      36.195  42.917  69.702  1.00 57.57           N  
ATOM   1021  CA  THR   125      35.421  42.333  70.759  1.00 58.77           C  
ATOM   1022  C   THR   125      36.159  42.557  72.087  1.00 59.95           C  
ATOM   1023  O   THR   125      37.404  42.665  72.108  1.00 61.11           O  
ATOM   1024  CB  THR   125      35.226  40.815  70.555  1.00 58.50           C  
ATOM   1025  OG1 THR   125      36.504  40.198  70.631  1.00 60.10           O  
ATOM   1026  CG2 THR   125      34.581  40.477  69.179  1.00 57.20           C  
ATOM   1027  N   ILE   126      35.392  42.648  73.174  1.00 59.74           N  
ATOM   1028  CA  ILE   126      35.925  42.817  74.500  1.00 60.47           C  
ATOM   1029  C   ILE   126      35.014  42.026  75.389  1.00 60.96           C  
ATOM   1030  O   ILE   126      33.801  42.116  75.250  1.00 60.86           O  
ATOM   1031  CB  ILE   126      35.861  44.292  74.994  1.00 60.70           C  
ATOM   1032  CG1 ILE   126      36.457  45.265  73.965  1.00 60.18           C  
ATOM   1033  CG2 ILE   126      36.660  44.428  76.323  1.00 61.21           C  
ATOM   1034  CD1 ILE   126      36.173  46.739  74.252  1.00 60.30           C  
ATOM   1035  N   CYS   127      35.571  41.266  76.320  1.00 61.17           N  
ATOM   1036  CA  CYS   127      34.720  40.550  77.246  1.00 61.73           C  
ATOM   1037  C   CYS   127      35.336  40.353  78.631  1.00 60.76           C  
ATOM   1038  O   CYS   127      36.552  40.554  78.825  1.00 61.34           O  
ATOM   1039  CB  CYS   127      34.283  39.220  76.645  1.00 62.64           C  
ATOM   1040  SG  CYS   127      35.571  38.057  76.611  1.00 69.38           S  
ATOM   1041  N   VAL   128      34.479  39.997  79.585  1.00 58.72           N  
ATOM   1042  CA  VAL   128      34.880  39.777  80.954  1.00 57.06           C  
ATOM   1043  C   VAL   128      34.217  38.503  81.459  1.00 57.11           C  
ATOM   1044  O   VAL   128      33.236  38.000  80.900  1.00 56.65           O  
ATOM   1045  CB  VAL   128      34.464  40.968  81.850  1.00 57.55           C  
ATOM   1046  CG1 VAL   128      35.306  42.205  81.547  1.00 55.59           C  
ATOM   1047  CG2 VAL   128      32.963  41.291  81.663  1.00 56.91           C  
ATOM   1048  N   LEU   129      34.762  37.965  82.520  1.00 57.32           N  
ATOM   1049  CA  LEU   129      34.166  36.828  83.172  1.00 58.26           C  
ATOM   1050  C   LEU   129      33.140  37.298  84.224  1.00 58.72           C  
ATOM   1051  O   LEU   129      33.452  38.103  85.104  1.00 58.69           O  
ATOM   1052  CB  LEU   129      35.297  36.031  83.830  1.00 58.55           C  
ATOM   1053  CG  LEU   129      35.015  34.628  84.359  1.00 60.42           C  
ATOM   1054  CD1 LEU   129      34.662  33.655  83.226  1.00 57.69           C  
ATOM   1055  CD2 LEU   129      36.257  34.149  85.121  1.00 58.78           C  
ATOM   1056  N   LEU   130      31.924  36.779  84.156  1.00 59.63           N  
ATOM   1057  CA  LEU   130      30.970  37.026  85.231  1.00 61.00           C  
ATOM   1058  C   LEU   130      31.373  36.302  86.514  1.00 62.52           C  
ATOM   1059  O   LEU   130      32.068  35.286  86.451  1.00 63.24           O  
ATOM   1060  CB  LEU   130      29.555  36.661  84.806  1.00 60.61           C  
ATOM   1061  CG  LEU   130      29.064  37.484  83.618  1.00 58.70           C  
ATOM   1062  CD1 LEU   130      27.610  37.233  83.478  1.00 57.62           C  
ATOM   1063  CD2 LEU   130      29.312  38.951  83.901  1.00 58.50           C  
ATOM   1064  N   PRO   131      30.957  36.833  87.684  1.00 63.60           N  
ATOM   1065  CA  PRO   131      31.330  36.289  88.998  1.00 64.67           C  
ATOM   1066  C   PRO   131      30.677  34.948  89.331  1.00 65.20           C  
ATOM   1067  O   PRO   131      31.135  34.235  90.229  1.00 65.42           O  
ATOM   1068  CB  PRO   131      30.763  37.326  89.982  1.00 64.22           C  
ATOM   1069  CG  PRO   131      30.370  38.477  89.184  1.00 63.35           C  
ATOM   1070  CD  PRO   131      30.083  38.008  87.828  1.00 63.62           C  
ATOM   1071  N   MET   132      29.571  34.647  88.672  1.00 64.99           N  
ATOM   1072  CA  MET   132      28.877  33.427  88.993  1.00 65.15           C  
ATOM   1073  C   MET   132      28.979  32.403  87.850  1.00 64.14           C  
ATOM   1074  O   MET   132      29.414  32.717  86.758  1.00 64.03           O  
ATOM   1075  CB  MET   132      27.415  33.726  89.407  1.00 65.70           C  
ATOM   1076  CG  MET   132      26.390  33.794  88.263  1.00 67.04           C  
ATOM   1077  SD  MET   132      26.750  35.218  87.004  0.45 71.81          SE  
ATOM   1078  CE  MET   132      26.107  36.639  88.129  1.00 67.04           C  
ATOM   1079  N   THR   133      28.592  31.168  88.142  1.00 63.08           N  
ATOM   1080  CA  THR   133      28.539  30.109  87.173  1.00 61.87           C  
ATOM   1081  C   THR   133      27.079  29.821  86.836  1.00 62.29           C  
ATOM   1082  O   THR   133      26.172  30.146  87.590  1.00 62.69           O  
ATOM   1083  CB  THR   133      29.236  28.832  87.733  1.00 62.07           C  
ATOM   1084  OG1 THR   133      28.599  28.425  88.955  1.00 59.30           O  
ATOM   1085  CG2 THR   133      30.761  29.080  87.987  1.00 60.89           C  
ATOM   1086  N   ILE   134      26.850  29.216  85.690  1.00 63.11           N  
ATOM   1087  CA  ILE   134      25.523  28.799  85.289  1.00 64.44           C  
ATOM   1088  C   ILE   134      25.672  27.330  84.911  1.00 65.69           C  
ATOM   1089  O   ILE   134      26.460  26.969  84.044  1.00 66.09           O  
ATOM   1090  CB  ILE   134      24.963  29.704  84.146  1.00 64.14           C  
ATOM   1091  CG1 ILE   134      24.566  31.066  84.723  1.00 63.96           C  
ATOM   1092  CG2 ILE   134      23.773  29.071  83.433  1.00 64.15           C  
ATOM   1093  CD1 ILE   134      24.175  32.136  83.679  1.00 64.32           C  
ATOM   1094  N   GLN   135      24.961  26.482  85.641  1.00 67.44           N  
ATOM   1095  CA  GLN   135      25.018  25.030  85.464  1.00 68.27           C  
ATOM   1096  C   GLN   135      26.423  24.443  85.593  1.00 67.51           C  
ATOM   1097  O   GLN   135      26.840  23.603  84.787  1.00 67.63           O  
ATOM   1098  CB  GLN   135      24.338  24.630  84.142  1.00 69.11           C  
ATOM   1099  CG  GLN   135      22.813  24.426  84.322  1.00 72.21           C  
ATOM   1100  CD  GLN   135      22.075  24.392  83.000  1.00 75.06           C  
ATOM   1101  OE1 GLN   135      22.529  24.981  82.028  1.00 73.98           O  
ATOM   1102  NE2 GLN   135      20.923  23.708  82.961  1.00 76.23           N  
ATOM   1103  N   GLY   136      27.140  24.878  86.627  1.00 66.64           N  
ATOM   1104  CA  GLY   136      28.537  24.478  86.814  1.00 65.45           C  
ATOM   1105  C   GLY   136      29.529  25.084  85.834  1.00 64.78           C  
ATOM   1106  O   GLY   136      30.703  25.058  86.102  1.00 63.55           O  
ATOM   1107  N   GLN   137      29.053  25.633  84.708  1.00 65.31           N  
ATOM   1108  CA  GLN   137      29.912  26.263  83.691  1.00 65.72           C  
ATOM   1109  C   GLN   137      30.233  27.713  84.016  1.00 65.55           C  
ATOM   1110  O   GLN   137      29.358  28.463  84.439  1.00 65.69           O  
ATOM   1111  CB  GLN   137      29.245  26.244  82.302  1.00 66.04           C  
ATOM   1112  CG  GLN   137      29.320  24.909  81.507  1.00 68.78           C  
ATOM   1113  CD  GLN   137      30.440  23.996  82.042  1.00 73.24           C  
ATOM   1114  OE1 GLN   137      31.649  24.242  81.825  1.00 72.76           O  
ATOM   1115  NE2 GLN   137      30.031  22.931  82.759  1.00 73.95           N  
ATOM   1116  N   PRO   138      31.472  28.144  83.744  1.00 65.44           N  
ATOM   1117  CA  PRO   138      31.749  29.578  83.801  1.00 64.98           C  
ATOM   1118  C   PRO   138      31.014  30.351  82.669  1.00 64.36           C  
ATOM   1119  O   PRO   138      30.615  29.763  81.628  1.00 63.62           O  
ATOM   1120  CB  PRO   138      33.259  29.641  83.600  1.00 64.70           C  
ATOM   1121  CG  PRO   138      33.523  28.488  82.688  1.00 65.49           C  
ATOM   1122  CD  PRO   138      32.663  27.395  83.312  1.00 65.94           C  
ATOM   1123  N   VAL   139      30.836  31.652  82.906  1.00 63.46           N  
ATOM   1124  CA  VAL   139      30.024  32.527  82.076  1.00 63.27           C  
ATOM   1125  C   VAL   139      30.742  33.834  81.764  1.00 63.64           C  
ATOM   1126  O   VAL   139      31.472  34.407  82.580  1.00 63.82           O  
ATOM   1127  CB  VAL   139      28.685  32.877  82.751  1.00 63.26           C  
ATOM   1128  CG1 VAL   139      27.728  33.535  81.751  1.00 63.44           C  
ATOM   1129  CG2 VAL   139      28.037  31.626  83.319  1.00 63.48           C  
ATOM   1130  N   THR   140      30.473  34.346  80.581  1.00 63.49           N  
ATOM   1131  CA  THR   140      31.209  35.477  80.094  1.00 62.95           C  
ATOM   1132  C   THR   140      30.239  36.548  79.635  1.00 61.34           C  
ATOM   1133  O   THR   140      29.112  36.253  79.198  1.00 61.41           O  
ATOM   1134  CB  THR   140      32.197  34.962  78.979  1.00 64.09           C  
ATOM   1135  OG1 THR   140      33.315  35.835  78.864  1.00 68.35           O  
ATOM   1136  CG2 THR   140      31.527  34.750  77.625  1.00 61.92           C  
ATOM   1137  N   MET   141      30.651  37.795  79.749  1.00 59.52           N  
ATOM   1138  CA  MET   141      29.865  38.896  79.191  1.00 58.85           C  
ATOM   1139  C   MET   141      30.732  39.738  78.273  1.00 57.63           C  
ATOM   1140  O   MET   141      31.805  40.197  78.662  1.00 56.38           O  
ATOM   1141  CB  MET   141      29.254  39.781  80.295  1.00 58.22           C  
ATOM   1142  CG  MET   141      28.359  40.907  79.768  1.00 57.91           C  
ATOM   1143  SD  MET   141      27.439  41.893  81.189  0.70 63.01          SE  
ATOM   1144  CE  MET   141      29.033  42.290  82.338  1.00 57.79           C  
ATOM   1145  N   GLY   142      30.275  39.939  77.045  1.00 57.51           N  
ATOM   1146  CA  GLY   142      31.113  40.646  76.106  1.00 57.02           C  
ATOM   1147  C   GLY   142      30.376  41.500  75.131  1.00 57.66           C  
ATOM   1148  O   GLY   142      29.155  41.396  75.004  1.00 56.64           O  
ATOM   1149  N   LEU   143      31.124  42.363  74.442  1.00 58.30           N  
ATOM   1150  CA  LEU   143      30.546  43.151  73.380  1.00 58.79           C  
ATOM   1151  C   LEU   143      31.353  43.070  72.088  1.00 58.83           C  
ATOM   1152  O   LEU   143      32.559  42.905  72.119  1.00 58.80           O  
ATOM   1153  CB  LEU   143      30.325  44.594  73.858  1.00 58.35           C  
ATOM   1154  CG  LEU   143      31.521  45.419  74.287  1.00 60.18           C  
ATOM   1155  CD1 LEU   143      32.247  46.006  73.071  1.00 60.49           C  
ATOM   1156  CD2 LEU   143      31.061  46.519  75.206  1.00 59.31           C  
ATOM   1157  N   GLY   144      30.678  43.246  70.953  1.00 58.47           N  
ATOM   1158  CA  GLY   144      31.316  43.101  69.659  1.00 58.24           C  
ATOM   1159  C   GLY   144      30.811  44.138  68.683  1.00 57.94           C  
ATOM   1160  O   GLY   144      29.643  44.516  68.749  1.00 59.01           O  
ATOM   1161  N   GLY   145      31.667  44.613  67.784  1.00 56.39           N  
ATOM   1162  CA  GLY   145      31.205  45.540  66.745  1.00 55.65           C  
ATOM   1163  C   GLY   145      32.309  45.840  65.731  1.00 56.12           C  
ATOM   1164  O   GLY   145      33.329  45.104  65.659  1.00 56.23           O  
ATOM   1165  N   ALA   146      32.124  46.900  64.951  1.00 55.07           N  
ATOM   1166  CA  ALA   146      33.100  47.244  63.899  1.00 55.82           C  
ATOM   1167  C   ALA   146      34.349  47.728  64.624  1.00 56.96           C  
ATOM   1168  O   ALA   146      34.230  48.504  65.612  1.00 57.85           O  
ATOM   1169  CB  ALA   146      32.536  48.330  62.929  1.00 52.69           C  
ATOM   1170  N   LEU   147      35.522  47.281  64.155  1.00 57.64           N  
ATOM   1171  CA  LEU   147      36.793  47.504  64.859  1.00 58.41           C  
ATOM   1172  C   LEU   147      37.061  48.955  65.249  1.00 60.34           C  
ATOM   1173  O   LEU   147      37.500  49.227  66.372  1.00 61.03           O  
ATOM   1174  CB  LEU   147      37.975  46.973  64.060  1.00 58.18           C  
ATOM   1175  CG  LEU   147      39.327  46.949  64.806  1.00 58.18           C  
ATOM   1176  CD1 LEU   147      39.244  46.312  66.199  1.00 57.00           C  
ATOM   1177  CD2 LEU   147      40.342  46.197  64.003  1.00 56.44           C  
ATOM   1178  N   ASP   148      36.797  49.886  64.340  1.00 60.98           N  
ATOM   1179  CA  ASP   148      37.114  51.252  64.594  1.00 62.40           C  
ATOM   1180  C   ASP   148      36.348  51.837  65.779  1.00 62.77           C  
ATOM   1181  O   ASP   148      36.896  52.619  66.589  1.00 62.98           O  
ATOM   1182  CB  ASP   148      36.866  52.052  63.329  1.00 63.29           C  
ATOM   1183  CG  ASP   148      37.999  51.865  62.274  1.00 68.49           C  
ATOM   1184  OD1 ASP   148      39.067  51.262  62.588  1.00 73.90           O  
ATOM   1185  OD2 ASP   148      37.832  52.324  61.114  1.00 73.21           O  
ATOM   1186  N   ARG   149      35.081  51.456  65.871  1.00 62.83           N  
ATOM   1187  CA  ARG   149      34.149  51.928  66.902  1.00 62.86           C  
ATOM   1188  C   ARG   149      34.607  51.373  68.242  1.00 62.96           C  
ATOM   1189  O   ARG   149      34.489  52.006  69.274  1.00 63.58           O  
ATOM   1190  CB  ARG   149      32.755  51.373  66.561  1.00 63.17           C  
ATOM   1191  CG  ARG   149      31.541  52.118  67.062  1.00 62.50           C  
ATOM   1192  CD  ARG   149      30.276  51.705  66.243  1.00 62.20           C  
ATOM   1193  NE  ARG   149      29.948  50.271  66.331  1.00 61.59           N  
ATOM   1194  CZ  ARG   149      29.562  49.509  65.295  1.00 61.95           C  
ATOM   1195  NH1 ARG   149      29.438  50.037  64.069  1.00 61.84           N  
ATOM   1196  NH2 ARG   149      29.264  48.218  65.478  1.00 58.63           N  
ATOM   1197  N   ILE   150      35.138  50.168  68.190  1.00 62.84           N  
ATOM   1198  CA  ILE   150      35.667  49.472  69.337  1.00 62.99           C  
ATOM   1199  C   ILE   150      36.976  50.090  69.814  1.00 63.06           C  
ATOM   1200  O   ILE   150      37.093  50.383  70.996  1.00 63.45           O  
ATOM   1201  CB  ILE   150      35.841  47.972  68.975  1.00 62.89           C  
ATOM   1202  CG1 ILE   150      34.475  47.346  68.679  1.00 61.48           C  
ATOM   1203  CG2 ILE   150      36.605  47.214  70.033  1.00 63.63           C  
ATOM   1204  CD1 ILE   150      33.474  47.515  69.720  1.00 59.06           C  
ATOM   1205  N   LYS   151      37.934  50.291  68.898  1.00 63.12           N  
ATOM   1206  CA  LYS   151      39.214  50.921  69.175  1.00 63.61           C  
ATOM   1207  C   LYS   151      39.027  52.307  69.740  1.00 63.88           C  
ATOM   1208  O   LYS   151      39.786  52.735  70.630  1.00 63.74           O  
ATOM   1209  CB  LYS   151      40.053  51.086  67.903  1.00 64.07           C  
ATOM   1210  CG  LYS   151      40.913  49.913  67.566  1.00 65.79           C  
ATOM   1211  CD  LYS   151      41.621  50.162  66.241  1.00 70.75           C  
ATOM   1212  CE  LYS   151      42.944  49.392  66.164  1.00 71.73           C  
ATOM   1213  NZ  LYS   151      43.159  48.731  64.846  1.00 72.52           N  
ATOM   1214  N   GLN   152      38.044  53.040  69.233  1.00 63.75           N  
ATOM   1215  CA  GLN   152      37.961  54.403  69.698  1.00 64.40           C  
ATOM   1216  C   GLN   152      37.173  54.524  71.007  1.00 64.24           C  
ATOM   1217  O   GLN   152      37.196  55.571  71.640  1.00 64.77           O  
ATOM   1218  CB  GLN   152      37.532  55.387  68.592  1.00 64.61           C  
ATOM   1219  CG  GLN   152      36.062  55.680  68.472  1.00 66.54           C  
ATOM   1220  CD  GLN   152      35.799  57.155  68.274  1.00 69.16           C  
ATOM   1221  OE1 GLN   152      34.813  57.540  67.658  1.00 72.32           O  
ATOM   1222  NE2 GLN   152      36.667  57.994  68.821  1.00 71.10           N  
ATOM   1223  N   ASN   153      36.519  53.453  71.429  1.00 63.29           N  
ATOM   1224  CA  ASN   153      35.780  53.492  72.678  1.00 63.53           C  
ATOM   1225  C   ASN   153      36.295  52.514  73.708  1.00 63.79           C  
ATOM   1226  O   ASN   153      35.654  52.292  74.736  1.00 63.26           O  
ATOM   1227  CB  ASN   153      34.302  53.230  72.425  1.00 63.39           C  
ATOM   1228  CG  ASN   153      33.615  54.397  71.765  1.00 62.56           C  
ATOM   1229  OD1 ASN   153      33.481  55.477  72.343  1.00 61.47           O  
ATOM   1230  ND2 ASN   153      33.163  54.181  70.555  1.00 62.37           N  
ATOM   1231  N   TYR   154      37.468  51.959  73.424  1.00 64.35           N  
ATOM   1232  CA  TYR   154      38.021  50.830  74.154  1.00 64.87           C  
ATOM   1233  C   TYR   154      37.977  51.032  75.673  1.00 64.22           C  
ATOM   1234  O   TYR   154      37.372  50.243  76.398  1.00 65.11           O  
ATOM   1235  CB  TYR   154      39.449  50.536  73.666  1.00 65.57           C  
ATOM   1236  CG  TYR   154      40.047  49.273  74.243  1.00 67.42           C  
ATOM   1237  CD1 TYR   154      39.799  48.022  73.644  1.00 69.26           C  
ATOM   1238  CD2 TYR   154      40.871  49.312  75.385  1.00 67.48           C  
ATOM   1239  CE1 TYR   154      40.352  46.840  74.157  1.00 68.18           C  
ATOM   1240  CE2 TYR   154      41.416  48.131  75.928  1.00 67.78           C  
ATOM   1241  CZ  TYR   154      41.145  46.898  75.308  1.00 69.01           C  
ATOM   1242  OH  TYR   154      41.682  45.711  75.808  1.00 70.29           O  
ATOM   1243  N   ASP   155      38.599  52.082  76.167  1.00 63.00           N  
ATOM   1244  CA  ASP   155      38.617  52.284  77.612  1.00 62.08           C  
ATOM   1245  C   ASP   155      37.215  52.364  78.228  1.00 60.93           C  
ATOM   1246  O   ASP   155      36.955  51.704  79.230  1.00 61.07           O  
ATOM   1247  CB  ASP   155      39.532  53.449  78.004  1.00 62.11           C  
ATOM   1248  CG  ASP   155      41.007  53.150  77.710  1.00 63.68           C  
ATOM   1249  OD1 ASP   155      41.404  51.968  77.752  1.00 63.75           O  
ATOM   1250  OD2 ASP   155      41.782  54.096  77.444  1.00 66.92           O  
ATOM   1251  N   ARG   156      36.325  53.142  77.616  0.50 60.35           N  
ATOM   1253  CA  ARG   156      34.951  53.271  78.098  0.50 59.56           C  
ATOM   1255  C   ARG   156      34.210  51.922  78.085  0.50 59.33           C  
ATOM   1257  O   ARG   156      33.566  51.552  79.074  0.50 59.30           O  
ATOM   1259  CB  ARG   156      34.190  54.348  77.303  0.50 59.35           C  
ATOM   1261  CG  ARG   156      32.709  54.514  77.647  0.50 58.27           C  
ATOM   1263  CD  ARG   156      32.496  54.857  79.123  0.50 58.16           C  
ATOM   1265  NE  ARG   156      31.118  55.273  79.401  0.50 57.16           N  
ATOM   1267  CZ  ARG   156      30.603  55.439  80.621  0.50 53.83           C  
ATOM   1269  NH1 ARG   156      31.333  55.214  81.705  0.50 50.49           N  
ATOM   1271  NH2 ARG   156      29.342  55.825  80.748  0.50 53.96           N  
ATOM   1273  N   TYR   157      34.314  51.183  76.983  1.00 59.03           N  
ATOM   1274  CA  TYR   157      33.636  49.896  76.875  1.00 58.63           C  
ATOM   1275  C   TYR   157      34.152  48.951  77.942  1.00 58.96           C  
ATOM   1276  O   TYR   157      33.389  48.380  78.700  1.00 59.40           O  
ATOM   1277  CB  TYR   157      33.846  49.301  75.510  1.00 59.28           C  
ATOM   1278  CG  TYR   157      33.035  49.900  74.385  1.00 59.29           C  
ATOM   1279  CD1 TYR   157      32.203  51.014  74.566  1.00 57.89           C  
ATOM   1280  CD2 TYR   157      33.158  49.380  73.112  1.00 58.11           C  
ATOM   1281  CE1 TYR   157      31.473  51.549  73.483  1.00 57.38           C  
ATOM   1282  CE2 TYR   157      32.439  49.890  72.052  1.00 58.83           C  
ATOM   1283  CZ  TYR   157      31.606  50.972  72.234  1.00 59.78           C  
ATOM   1284  OH  TYR   157      30.926  51.438  71.110  1.00 62.74           O  
ATOM   1285  N   LEU   158      35.464  48.824  78.045  1.00 59.50           N  
ATOM   1286  CA  LEU   158      36.044  47.981  79.075  1.00 59.86           C  
ATOM   1287  C   LEU   158      35.524  48.348  80.462  1.00 60.16           C  
ATOM   1288  O   LEU   158      35.113  47.467  81.220  1.00 60.78           O  
ATOM   1289  CB  LEU   158      37.562  48.099  79.054  1.00 59.80           C  
ATOM   1290  CG  LEU   158      38.262  47.129  80.008  1.00 60.44           C  
ATOM   1291  CD1 LEU   158      37.858  45.663  79.707  1.00 56.36           C  
ATOM   1292  CD2 LEU   158      39.766  47.334  79.948  1.00 59.85           C  
ATOM   1293  N   GLU   159      35.562  49.641  80.781  1.00 59.61           N  
ATOM   1294  CA  GLU   159      35.161  50.153  82.078  1.00 59.73           C  
ATOM   1295  C   GLU   159      33.742  49.670  82.381  1.00 59.78           C  
ATOM   1296  O   GLU   159      33.489  49.106  83.453  1.00 59.87           O  
ATOM   1297  CB  GLU   159      35.214  51.679  82.056  1.00 59.34           C  
ATOM   1298  CG  GLU   159      35.126  52.335  83.418  1.00 61.40           C  
ATOM   1299  CD  GLU   159      34.879  53.857  83.357  0.70 60.72           C  
ATOM   1300  OE1 GLU   159      34.127  54.327  82.466  0.70 63.42           O  
ATOM   1301  OE2 GLU   159      35.421  54.578  84.219  0.70 58.79           O  
ATOM   1302  N   LEU   160      32.818  49.861  81.427  1.00 59.37           N  
ATOM   1303  CA  LEU   160      31.439  49.367  81.576  1.00 58.56           C  
ATOM   1304  C   LEU   160      31.356  47.856  81.818  1.00 58.29           C  
ATOM   1305  O   LEU   160      30.541  47.413  82.616  1.00 59.51           O  
ATOM   1306  CB  LEU   160      30.567  49.737  80.369  1.00 57.95           C  
ATOM   1307  CG  LEU   160      30.347  51.218  80.103  1.00 58.23           C  
ATOM   1308  CD1 LEU   160      29.702  51.460  78.758  1.00 55.29           C  
ATOM   1309  CD2 LEU   160      29.536  51.881  81.245  1.00 56.98           C  
ATOM   1310  N   LEU   161      32.179  47.053  81.159  1.00 56.85           N  
ATOM   1311  CA  LEU   161      32.064  45.623  81.399  1.00 56.27           C  
ATOM   1312  C   LEU   161      32.491  45.340  82.827  1.00 56.63           C  
ATOM   1313  O   LEU   161      31.767  44.702  83.568  1.00 56.98           O  
ATOM   1314  CB  LEU   161      32.873  44.788  80.391  1.00 55.23           C  
ATOM   1315  CG  LEU   161      32.396  44.835  78.945  1.00 53.59           C  
ATOM   1316  CD1 LEU   161      33.466  44.302  77.999  1.00 52.49           C  
ATOM   1317  CD2 LEU   161      31.076  44.077  78.777  1.00 50.92           C  
ATOM   1318  N   LEU   162      33.655  45.845  83.211  1.00 57.06           N  
ATOM   1319  CA  LEU   162      34.197  45.628  84.544  1.00 58.48           C  
ATOM   1320  C   LEU   162      33.282  46.096  85.667  1.00 59.61           C  
ATOM   1321  O   LEU   162      33.264  45.501  86.759  1.00 60.23           O  
ATOM   1322  CB  LEU   162      35.574  46.304  84.700  1.00 58.31           C  
ATOM   1323  CG  LEU   162      36.705  45.644  83.895  1.00 57.84           C  
ATOM   1324  CD1 LEU   162      37.997  46.389  84.102  1.00 58.59           C  
ATOM   1325  CD2 LEU   162      36.901  44.204  84.266  1.00 56.12           C  
ATOM   1326  N   ASN   163      32.542  47.169  85.410  1.00 60.54           N  
ATOM   1327  CA  ASN   163      31.690  47.749  86.439  1.00 62.01           C  
ATOM   1328  C   ASN   163      30.436  46.879  86.527  1.00 62.08           C  
ATOM   1329  O   ASN   163      29.830  46.747  87.593  1.00 61.71           O  
ATOM   1330  CB  ASN   163      31.438  49.239  86.125  1.00 62.45           C  
ATOM   1331  CG  ASN   163      30.150  49.787  86.734  1.00 65.09           C  
ATOM   1332  OD1 ASN   163      30.050  50.022  87.957  1.00 67.46           O  
ATOM   1333  ND2 ASN   163      29.168  50.061  85.862  1.00 65.90           N  
ATOM   1334  N   GLY   164      30.102  46.245  85.397  1.00 62.36           N  
ATOM   1335  CA  GLY   164      28.971  45.325  85.296  1.00 62.20           C  
ATOM   1336  C   GLY   164      29.216  44.094  86.143  1.00 62.33           C  
ATOM   1337  O   GLY   164      28.300  43.587  86.792  1.00 62.50           O  
ATOM   1338  N   VAL   165      30.462  43.636  86.155  1.00 61.66           N  
ATOM   1339  CA  VAL   165      30.900  42.586  87.044  1.00 61.93           C  
ATOM   1340  C   VAL   165      30.706  42.951  88.532  1.00 62.82           C  
ATOM   1341  O   VAL   165      30.158  42.160  89.306  1.00 63.03           O  
ATOM   1342  CB  VAL   165      32.356  42.271  86.742  1.00 61.88           C  
ATOM   1343  CG1 VAL   165      33.024  41.473  87.860  1.00 60.99           C  
ATOM   1344  CG2 VAL   165      32.431  41.557  85.416  1.00 62.26           C  
ATOM   1345  N   GLN   166      31.142  44.149  88.935  1.00 63.51           N  
ATOM   1346  CA  GLN   166      30.938  44.637  90.305  1.00 63.09           C  
ATOM   1347  C   GLN   166      29.471  44.671  90.704  1.00 63.81           C  
ATOM   1348  O   GLN   166      29.126  44.278  91.796  1.00 63.65           O  
ATOM   1349  CB  GLN   166      31.571  46.010  90.467  1.00 62.92           C  
ATOM   1350  CG  GLN   166      33.101  45.969  90.431  1.00 62.83           C  
ATOM   1351  CD  GLN   166      33.682  44.920  91.377  1.00 62.74           C  
ATOM   1352  OE1 GLN   166      34.438  44.038  90.958  1.00 62.14           O  
ATOM   1353  NE2 GLN   166      33.307  44.994  92.653  1.00 62.51           N  
ATOM   1354  N   GLN   167      28.601  45.105  89.800  1.00 64.97           N  
ATOM   1355  CA  GLN   167      27.177  45.100  90.066  1.00 66.64           C  
ATOM   1356  C   GLN   167      26.588  43.715  90.317  1.00 67.34           C  
ATOM   1357  O   GLN   167      25.554  43.602  90.948  1.00 67.90           O  
ATOM   1358  CB  GLN   167      26.417  45.751  88.924  1.00 66.61           C  
ATOM   1359  CG  GLN   167      26.627  47.230  88.784  1.00 68.71           C  
ATOM   1360  CD  GLN   167      25.849  47.782  87.591  1.00 73.66           C  
ATOM   1361  OE1 GLN   167      24.753  48.315  87.760  1.00 78.39           O  
ATOM   1362  NE2 GLN   167      26.397  47.636  86.379  1.00 73.07           N  
ATOM   1363  N   LEU   168      27.233  42.661  89.833  1.00 68.72           N  
ATOM   1364  CA  LEU   168      26.708  41.304  90.031  1.00 69.87           C  
ATOM   1365  C   LEU   168      27.356  40.466  91.131  1.00 71.95           C  
ATOM   1366  O   LEU   168      26.886  39.378  91.409  1.00 72.69           O  
ATOM   1367  CB  LEU   168      26.700  40.502  88.726  1.00 68.81           C  
ATOM   1368  CG  LEU   168      25.923  41.090  87.550  1.00 66.67           C  
ATOM   1369  CD1 LEU   168      26.472  40.555  86.247  1.00 64.39           C  
ATOM   1370  CD2 LEU   168      24.420  40.871  87.662  1.00 64.21           C  
ATOM   1371  N   LYS   169      28.415  40.929  91.769  1.00 74.46           N  
ATOM   1372  CA  LYS   169      28.913  40.198  92.949  1.00 77.56           C  
ATOM   1373  C   LYS   169      27.846  39.801  94.033  1.00 78.83           C  
ATOM   1374  O   LYS   169      28.141  38.998  94.938  1.00 79.44           O  
ATOM   1375  CB  LYS   169      30.106  40.933  93.577  1.00 77.52           C  
ATOM   1376  CG  LYS   169      31.403  40.740  92.790  1.00 78.50           C  
ATOM   1377  CD  LYS   169      32.633  41.233  93.555  1.00 78.42           C  
ATOM   1378  CE  LYS   169      33.945  40.723  92.918  1.00 80.07           C  
ATOM   1379  NZ  LYS   169      35.138  40.771  93.875  1.00 79.99           N  
ATOM   1380  N   LYS   170      26.634  40.359  93.952  0.50 79.57           N  
ATOM   1382  CA  LYS   170      25.538  39.973  94.871  0.50 80.11           C  
ATOM   1384  C   LYS   170      24.549  38.959  94.268  0.50 80.39           C  
ATOM   1386  O   LYS   170      23.591  38.551  94.934  0.50 80.15           O  
ATOM   1388  CB  LYS   170      24.781  41.207  95.387  0.50 80.17           C  
ATOM   1390  CG  LYS   170      25.323  41.807  96.689  0.50 80.36           C  
ATOM   1392  CD  LYS   170      25.130  43.323  96.702  0.50 80.64           C  
ATOM   1394  CE  LYS   170      26.132  43.993  95.748  0.50 81.04           C  
ATOM   1396  NZ  LYS   170      25.532  45.067  94.897  0.50 80.73           N  
ATOM   1398  N   SER   171      24.786  38.562  93.015  1.00 80.70           N  
ATOM   1399  CA  SER   171      23.954  37.549  92.335  1.00 81.42           C  
ATOM   1400  C   SER   171      24.465  36.097  92.432  1.00 81.92           C  
ATOM   1401  O   SER   171      25.649  35.814  92.203  1.00 82.04           O  
ATOM   1402  CB  SER   171      23.759  37.931  90.868  1.00 81.24           C  
ATOM   1403  OG  SER   171      23.207  39.226  90.791  1.00 81.58           O  
ATOM   1404  N   ASP   172      23.545  35.186  92.744  1.00 82.34           N  
ATOM   1405  CA  ASP   172      23.861  33.770  92.943  1.00 82.68           C  
ATOM   1406  C   ASP   172      24.277  33.041  91.674  1.00 82.52           C  
ATOM   1407  O   ASP   172      23.873  33.417  90.568  1.00 82.88           O  
ATOM   1408  CB  ASP   172      22.657  33.062  93.559  1.00 82.79           C  
ATOM   1409  CG  ASP   172      22.438  33.458  95.000  1.00 84.58           C  
ATOM   1410  OD1 ASP   172      23.450  33.670  95.718  1.00 85.73           O  
ATOM   1411  OD2 ASP   172      21.258  33.563  95.417  1.00 86.61           O  
ATOM   1412  N   SER   173      25.096  32.003  91.843  1.00 82.19           N  
ATOM   1413  CA  SER   173      25.301  31.003  90.800  1.00 81.94           C  
ATOM   1414  C   SER   173      24.071  30.069  90.794  1.00 81.85           C  
ATOM   1415  O   SER   173      23.403  29.904  91.826  1.00 81.43           O  
ATOM   1416  CB  SER   173      26.592  30.199  91.050  1.00 81.85           C  
ATOM   1417  OG  SER   173      27.686  31.033  91.420  1.00 81.39           O  
ATOM   1418  N   PHE   174      23.758  29.470  89.644  1.00 81.81           N  
ATOM   1419  CA  PHE   174      22.619  28.543  89.587  1.00 81.63           C  
ATOM   1420  C   PHE   174      22.810  27.343  88.654  1.00 81.91           C  
ATOM   1421  O   PHE   174      23.540  27.415  87.661  1.00 81.37           O  
ATOM   1422  CB  PHE   174      21.292  29.292  89.303  1.00 81.50           C  
ATOM   1423  CG  PHE   174      21.210  29.948  87.929  1.00 79.93           C  
ATOM   1424  CD1 PHE   174      20.686  29.252  86.839  1.00 78.93           C  
ATOM   1425  CD2 PHE   174      21.613  31.277  87.746  1.00 78.89           C  
ATOM   1426  CE1 PHE   174      20.590  29.866  85.571  1.00 79.10           C  
ATOM   1427  CE2 PHE   174      21.518  31.899  86.488  1.00 78.38           C  
ATOM   1428  CZ  PHE   174      21.009  31.192  85.402  1.00 79.22           C  
ATOM   1429  N   HIS   175      22.150  26.239  89.005  1.00 82.82           N  
ATOM   1430  CA  HIS   175      22.171  25.024  88.184  1.00 83.73           C  
ATOM   1431  C   HIS   175      20.784  24.647  87.647  1.00 83.73           C  
ATOM   1432  O   HIS   175      20.188  23.692  88.128  1.00 83.82           O  
ATOM   1433  CB  HIS   175      22.792  23.846  88.952  1.00 83.68           C  
ATOM   1434  CG  HIS   175      23.642  22.961  88.092  1.00 85.07           C  
ATOM   1435  ND1 HIS   175      25.007  22.846  88.258  1.00 86.20           N  
ATOM   1436  CD2 HIS   175      23.328  22.187  87.023  1.00 86.70           C  
ATOM   1437  CE1 HIS   175      25.491  22.015  87.347  1.00 86.84           C  
ATOM   1438  NE2 HIS   175      24.495  21.607  86.580  1.00 86.55           N  
ATOM   1439  N   GLN   176      20.311  25.384  86.631  1.00 84.15           N  
ATOM   1440  CA  GLN   176      18.948  25.260  86.075  1.00 83.95           C  
ATOM   1441  C   GLN   176      18.909  25.379  84.553  1.00 84.23           C  
ATOM   1442  O   GLN   176      17.994  24.871  83.896  1.00 84.64           O  
ATOM   1443  CB  GLN   176      18.045  26.337  86.670  1.00 83.77           C  
ATOM   1444  CG  GLN   176      16.990  25.824  87.634  1.00 83.19           C  
ATOM   1445  CD  GLN   176      17.544  25.260  88.942  1.00 82.37           C  
ATOM   1446  OE1 GLN   176      18.293  25.931  89.668  1.00 82.87           O  
ATOM   1447  NE2 GLN   176      17.149  24.024  89.261  1.00 80.86           N  
END
