
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  182 ( 1395),  selected  182 , name 2o99_C
# Molecule2: number of CA atoms  176 ( 1390),  selected  176 , name T0412.pdb
# PARAMETERS: 2o99_C.T0412.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_C      S       1           -
LGA    H     2_C      N       2           -
LGA    X     3_C      -       -           -
LGA    S     4_C      -       -           -
LGA    R     5_C      A       3          4.664
LGA    N     6_C      L       4          1.081
LGA    -       -      F       5           -
LGA    L     7_C      S       6          1.981
LGA    L     8_C      S       7          1.645
LGA    A     9_C      R       8          1.924
LGA    I    10_C      D       9          2.179
LGA    V    11_C      I      10          1.495
LGA    H    12_C      L      11          0.766
LGA    P    13_C      E      12          1.275
LGA    I    14_C      V      13          0.753
LGA    L    15_C      L      14          0.612
LGA    R    16_C      Q      15          0.796
LGA    N    17_C      D      16          0.449
LGA    L    18_C      I      17          0.528
LGA    X    19_C      H      18          0.913
LGA    E    20_C      M      19          1.471
LGA    E    21_C      E      20          1.669
LGA    S    22_C      T      21          2.085
LGA    G    23_C      G      22          2.331
LGA    E    24_C      E      23          0.692
LGA    T    25_C      T      24          0.891
LGA    V    26_C      V      25          0.562
LGA    N    27_C      A      26          0.398
LGA    X    28_C      I      27          0.558
LGA    A    29_C      A      28          0.584
LGA    V    30_C      T      29          1.408
LGA    L    31_C      K      30          1.193
LGA    D    32_C      N      31          0.321
LGA    Q    33_C      D      32          2.181
LGA    S    34_C      -       -           -
LGA    D    35_C      -       -           -
LGA    H    36_C      I      33          1.043
LGA    E    37_C      Y      34          0.815
LGA    A    38_C      L      35          1.366
LGA    I    39_C      Q      36          0.819
LGA    I    40_C      Y      37          0.881
LGA    I    41_C      I      38          1.162
LGA    D    42_C      Q      39          0.626
LGA    Q    43_C      I      40          1.662
LGA    V    44_C      I      41          1.689
LGA    Q    45_C      E      42          1.752
LGA    C    46_C      S      43          2.029
LGA    T    47_C      V      44          0.714
LGA    H    48_C      H      45          0.738
LGA    L    49_C      A      46          1.321
LGA    X    50_C      L      47          1.064
LGA    R    51_C      R      48          0.804
LGA    X    52_C      F      49          1.096
LGA    S    53_C      H      50          1.996
LGA    A    54_C      V      51          0.612
LGA    P    55_C      D      52           #
LGA    I    56_C      -       -           -
LGA    G    57_C      -       -           -
LGA    G    58_C      E      53          2.385
LGA    K    59_C      N      54           #
LGA    -       -      A      55           -
LGA    -       -      I      56           -
LGA    L    60_C      R      57          3.827
LGA    P    61_C      P      58          2.700
LGA    X    62_C      L      59          0.584
LGA    H    63_C      T      60          1.035
LGA    A    64_C      M      61          1.773
LGA    S    65_C      S      62          0.626
LGA    G    66_C      S      63          1.968
LGA    A    67_C      N      64          1.336
LGA    G    68_C      G      65          0.742
LGA    K    69_C      W      66          0.957
LGA    A    70_C      M      67          0.847
LGA    F    71_C      L      68          0.585
LGA    L    72_C      M      69          1.180
LGA    A    73_C      S      70          1.725
LGA    Q    74_C      T      71          2.077
LGA    L    75_C      M      72          1.686
LGA    S    76_C      N      73          1.641
LGA    E    77_C      D      74          1.478
LGA    E    78_C      K      75          2.534
LGA    Q    79_C      A      76          2.018
LGA    V    80_C      I      77          0.740
LGA    T    81_C      D      78          1.818
LGA    K    82_C      N      79          1.922
LGA    L    83_C      T      80          0.455
LGA    L    84_C      V      81          1.803
LGA    H    85_C      R      82          2.316
LGA    R    86_C      R      83          2.405
LGA    K    87_C      A      84          2.719
LGA    G    88_C      N      85          2.050
LGA    L    89_C      T      86          6.655
LGA    -       -      I      87           -
LGA    -       -      T      88           -
LGA    -       -      Q      89           -
LGA    -       -      K      90           -
LGA    -       -      D      91           -
LGA    H    90_C      G      92           #
LGA    A    91_C      I      93          1.844
LGA    Y    92_C      -       -           -
LGA    T    93_C      -       -           -
LGA    H    94_C      -       -           -
LGA    A    95_C      -       -           -
LGA    T    96_C      -       -           -
LGA    L    97_C      R      94          6.881
LGA    V    98_C      F      95          1.326
LGA    S    99_C      E      96          1.747
LGA    P   100_C      V      97          1.722
LGA    V   101_C      D      98          2.081
LGA    H   102_C      D      99          2.045
LGA    L   103_C      M     100          1.355
LGA    K   104_C      M     101          1.829
LGA    E   105_C      A     102          2.007
LGA    D   106_C      R     103          1.702
LGA    L   107_C      I     104          1.513
LGA    A   108_C      R     105          2.295
LGA    Q   109_C      Q     106          2.250
LGA    T   110_C      V     107          1.296
LGA    R   111_C      R     108          1.913
LGA    K   112_C      E     109          2.352
LGA    R   113_C      Q     110          1.943
LGA    G   114_C      G     111          1.109
LGA    Y   115_C      Y     112          0.570
LGA    S   116_C      A     113          0.803
LGA    F   117_C      S     114          0.893
LGA    D   118_C      A     115          1.971
LGA    D   119_C      E     116          1.360
LGA    E   120_C      H     117          0.880
LGA    E   121_C      I     118          1.687
LGA    H   122_C      P     119          0.276
LGA    A   123_C      F     120          0.729
LGA    L   124_C      V     121          0.692
LGA    G   125_C      G     122          0.837
LGA    L   126_C      G     123          1.156
LGA    R   127_C      G     124          1.129
LGA    C   128_C      T     125          0.898
LGA    L   129_C      I     126          0.780
LGA    A   130_C      C     127          0.895
LGA    A   131_C      V     128          1.108
LGA    C   132_C      L     129          1.290
LGA    I   133_C      L     130          1.957
LGA    F   134_C      P     131          3.422
LGA    D   135_C      M     132          3.836
LGA    E   136_C      T     133           -
LGA    H   137_C      I     134           -
LGA    R   138_C      Q     135           -
LGA    -       -      G     136           -
LGA    E   139_C      Q     137           #
LGA    P   140_C      P     138          2.640
LGA    F   141_C      -       -           -
LGA    A   142_C      V     139          0.732
LGA    A   143_C      T     140          0.386
LGA    I   144_C      M     141          0.583
LGA    S   145_C      G     142          0.986
LGA    I   146_C      L     143          0.451
LGA    S   147_C      G     144          0.645
LGA    G   148_C      G     145          0.628
LGA    P   149_C      A     146          0.761
LGA    I   150_C      L     147          0.750
LGA    S   151_C      D     148          2.805
LGA    R   152_C      R     149          1.108
LGA    I   153_C      I     150          0.927
LGA    T   154_C      K     151          1.760
LGA    D   155_C      -       -           -
LGA    D   156_C      Q     152          4.240
LGA    R   157_C      N     153          2.743
LGA    V   158_C      Y     154          2.471
LGA    T   159_C      D     155          3.265
LGA    E   160_C      R     156          2.921
LGA    F   161_C      Y     157          2.323
LGA    G   162_C      L     158          2.308
LGA    A   163_C      E     159          2.346
LGA    X   164_C      L     160          2.020
LGA    V   165_C      L     161          1.804
LGA    I   166_C      L     162          2.060
LGA    K   167_C      N     163          2.171
LGA    A   168_C      G     164          1.878
LGA    A   169_C      V     165          3.149
LGA    K   170_C      Q     166          3.696
LGA    E   171_C      Q     167          2.879
LGA    V   172_C      L     168          3.209
LGA    T   173_C      K     169          4.247
LGA    L   174_C      K     170          3.289
LGA    A   175_C      S     171          1.410
LGA    Y   176_C      D     172          2.072
LGA    G   177_C      S     173           #
LGA    G   178_C      -       -           -
LGA    X   179_C      -       -           -
LGA    R   180_C      F     174           #
LGA    G   181_C      H     175           -
LGA    S   182_C      Q     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  182  176    5.0    154    1.96    14.94     74.542     7.467

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.432427 * X  +  -0.005041 * Y  +  -0.901655 * Z  + -33.095818
  Y_new =  -0.147751 * X  +   0.986864 * Y  +   0.065343 * Z  +  51.049210
  Z_new =   0.889481 * X  +   0.161476 * Y  +  -0.427492 * Z  +  35.637753 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.780431   -0.361162  [ DEG:   159.3069    -20.6930 ]
  Theta =  -1.096208   -2.045385  [ DEG:   -62.8081   -117.1919 ]
  Phi   =  -2.812351    0.329242  [ DEG:  -161.1358     18.8642 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2o99_C                                        
REMARK     2: T0412.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2o99_C.T0412.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  182  176   5.0  154   1.96   14.94  74.542
REMARK  ---------------------------------------------------------- 
MOLECULE 2o99_C
HEADER    DNA BINDING PROTEIN                     13-DEC-06   2O99              
TITLE     THE CRYSTAL STRUCTURE OF E.COLI ICLR C-TERMINAL FRAGMENT IN           
TITLE    2 COMPLEX WITH GLYOXYLATE                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETATE OPERON REPRESSOR;                                  
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    ICLR                                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.V.LUNIN,A.EZERSKY,E.EVDOKIMOVA,M.KUDRITSKA,A.SAVCHENKO              
REVDAT   3   12-JUN-07 2O99    1       JRNL                                     
REVDAT   2   24-APR-07 2O99    1       AUTHOR                                   
REVDAT   1   10-APR-07 2O99    0                                                
JRNL        AUTH   G.L.LORCA,A.EZERSKY,V.V.LUNIN,J.R.WALKER,                    
JRNL        AUTH 2 S.ALTAMENTOVA,E.EVDOKIMOVA,M.VEDADI,A.BOCHKAREV,             
JRNL        AUTH 3 A.SAVCHENKO                                                  
JRNL        TITL   GLYOXYLATE AND PYRUVATE ARE ANTAGONISTIC EFFECTORS           
JRNL        TITL 2 OF THE ESCHERICHIA COLI ICLR TRANSCRIPTIONAL                 
JRNL        TITL 3 REGULATOR.                                                   
JRNL        REF    J.BIOL.CHEM.                  V. 282 16476 2007              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2O99 A    4   180  UNP    P16528   ICLR_ECOLI      98    274             
DBREF  2O99 B    4   180  UNP    P16528   ICLR_ECOLI      98    274             
DBREF  2O99 C    4   180  UNP    P16528   ICLR_ECOLI      98    274             
DBREF  2O99 D    4   180  UNP    P16528   ICLR_ECOLI      98    274             
SEQRES   1 A  182  GLY HIS MSE SER ARG ASN LEU LEU ALA ILE VAL HIS PRO          
SEQRES   2 A  182  ILE LEU ARG ASN LEU MSE GLU GLU SER GLY GLU THR VAL          
SEQRES   3 A  182  ASN MSE ALA VAL LEU ASP GLN SER ASP HIS GLU ALA ILE          
SEQRES   4 A  182  ILE ILE ASP GLN VAL GLN CYS THR HIS LEU MSE ARG MSE          
SEQRES   5 A  182  SER ALA PRO ILE GLY GLY LYS LEU PRO MSE HIS ALA SER          
SEQRES   6 A  182  GLY ALA GLY LYS ALA PHE LEU ALA GLN LEU SER GLU GLU          
SEQRES   7 A  182  GLN VAL THR LYS LEU LEU HIS ARG LYS GLY LEU HIS ALA          
SEQRES   8 A  182  TYR THR HIS ALA THR LEU VAL SER PRO VAL HIS LEU LYS          
SEQRES   9 A  182  GLU ASP LEU ALA GLN THR ARG LYS ARG GLY TYR SER PHE          
SEQRES  10 A  182  ASP ASP GLU GLU HIS ALA LEU GLY LEU ARG CYS LEU ALA          
SEQRES  11 A  182  ALA CYS ILE PHE ASP GLU HIS ARG GLU PRO PHE ALA ALA          
SEQRES  12 A  182  ILE SER ILE SER GLY PRO ILE SER ARG ILE THR ASP ASP          
SEQRES  13 A  182  ARG VAL THR GLU PHE GLY ALA MSE VAL ILE LYS ALA ALA          
SEQRES  14 A  182  LYS GLU VAL THR LEU ALA TYR GLY GLY MSE ARG GLY SER          
SEQRES   1 B  182  GLY HIS MSE SER ARG ASN LEU LEU ALA ILE VAL HIS PRO          
SEQRES   2 B  182  ILE LEU ARG ASN LEU MSE GLU GLU SER GLY GLU THR VAL          
SEQRES   3 B  182  ASN MSE ALA VAL LEU ASP GLN SER ASP HIS GLU ALA ILE          
SEQRES   4 B  182  ILE ILE ASP GLN VAL GLN CYS THR HIS LEU MSE ARG MSE          
SEQRES   5 B  182  SER ALA PRO ILE GLY GLY LYS LEU PRO MSE HIS ALA SER          
SEQRES   6 B  182  GLY ALA GLY LYS ALA PHE LEU ALA GLN LEU SER GLU GLU          
SEQRES   7 B  182  GLN VAL THR LYS LEU LEU HIS ARG LYS GLY LEU HIS ALA          
SEQRES   8 B  182  TYR THR HIS ALA THR LEU VAL SER PRO VAL HIS LEU LYS          
SEQRES   9 B  182  GLU ASP LEU ALA GLN THR ARG LYS ARG GLY TYR SER PHE          
SEQRES  10 B  182  ASP ASP GLU GLU HIS ALA LEU GLY LEU ARG CYS LEU ALA          
SEQRES  11 B  182  ALA CYS ILE PHE ASP GLU HIS ARG GLU PRO PHE ALA ALA          
SEQRES  12 B  182  ILE SER ILE SER GLY PRO ILE SER ARG ILE THR ASP ASP          
SEQRES  13 B  182  ARG VAL THR GLU PHE GLY ALA MSE VAL ILE LYS ALA ALA          
SEQRES  14 B  182  LYS GLU VAL THR LEU ALA TYR GLY GLY MSE ARG GLY SER          
SEQRES   1 C  182  GLY HIS MSE SER ARG ASN LEU LEU ALA ILE VAL HIS PRO          
SEQRES   2 C  182  ILE LEU ARG ASN LEU MSE GLU GLU SER GLY GLU THR VAL          
SEQRES   3 C  182  ASN MSE ALA VAL LEU ASP GLN SER ASP HIS GLU ALA ILE          
SEQRES   4 C  182  ILE ILE ASP GLN VAL GLN CYS THR HIS LEU MSE ARG MSE          
SEQRES   5 C  182  SER ALA PRO ILE GLY GLY LYS LEU PRO MSE HIS ALA SER          
SEQRES   6 C  182  GLY ALA GLY LYS ALA PHE LEU ALA GLN LEU SER GLU GLU          
SEQRES   7 C  182  GLN VAL THR LYS LEU LEU HIS ARG LYS GLY LEU HIS ALA          
SEQRES   8 C  182  TYR THR HIS ALA THR LEU VAL SER PRO VAL HIS LEU LYS          
SEQRES   9 C  182  GLU ASP LEU ALA GLN THR ARG LYS ARG GLY TYR SER PHE          
SEQRES  10 C  182  ASP ASP GLU GLU HIS ALA LEU GLY LEU ARG CYS LEU ALA          
SEQRES  11 C  182  ALA CYS ILE PHE ASP GLU HIS ARG GLU PRO PHE ALA ALA          
SEQRES  12 C  182  ILE SER ILE SER GLY PRO ILE SER ARG ILE THR ASP ASP          
SEQRES  13 C  182  ARG VAL THR GLU PHE GLY ALA MSE VAL ILE LYS ALA ALA          
SEQRES  14 C  182  LYS GLU VAL THR LEU ALA TYR GLY GLY MSE ARG GLY SER          
SEQRES   1 D  182  GLY HIS MSE SER ARG ASN LEU LEU ALA ILE VAL HIS PRO          
SEQRES   2 D  182  ILE LEU ARG ASN LEU MSE GLU GLU SER GLY GLU THR VAL          
SEQRES   3 D  182  ASN MSE ALA VAL LEU ASP GLN SER ASP HIS GLU ALA ILE          
SEQRES   4 D  182  ILE ILE ASP GLN VAL GLN CYS THR HIS LEU MSE ARG MSE          
SEQRES   5 D  182  SER ALA PRO ILE GLY GLY LYS LEU PRO MSE HIS ALA SER          
SEQRES   6 D  182  GLY ALA GLY LYS ALA PHE LEU ALA GLN LEU SER GLU GLU          
SEQRES   7 D  182  GLN VAL THR LYS LEU LEU HIS ARG LYS GLY LEU HIS ALA          
SEQRES   8 D  182  TYR THR HIS ALA THR LEU VAL SER PRO VAL HIS LEU LYS          
SEQRES   9 D  182  GLU ASP LEU ALA GLN THR ARG LYS ARG GLY TYR SER PHE          
SEQRES  10 D  182  ASP ASP GLU GLU HIS ALA LEU GLY LEU ARG CYS LEU ALA          
SEQRES  11 D  182  ALA CYS ILE PHE ASP GLU HIS ARG GLU PRO PHE ALA ALA          
SEQRES  12 D  182  ILE SER ILE SER GLY PRO ILE SER ARG ILE THR ASP ASP          
SEQRES  13 D  182  ARG VAL THR GLU PHE GLY ALA MSE VAL ILE LYS ALA ALA          
SEQRES  14 D  182  LYS GLU VAL THR LEU ALA TYR GLY GLY MSE ARG GLY SER          
HET    MSE  A   3       8                                                       
HET    MSE  A  19       8                                                       
HET    MSE  A  28       8                                                       
HET    MSE  A  50      16                                                       
HET    MSE  A  52       8                                                       
HET    MSE  A  62       8                                                       
HET    MSE  A 164       8                                                       
HET    MSE  A 179       8                                                       
HET    MSE  B   3      13                                                       
HET    MSE  B  19       8                                                       
HET    MSE  B  28       8                                                       
HET    MSE  B  50      13                                                       
HET    MSE  B  52       8                                                       
HET    MSE  B  62      16                                                       
HET    MSE  B 164       8                                                       
HET    MSE  B 179       8                                                       
HET    MSE  C   3      13                                                       
HET    MSE  C  19       8                                                       
HET    MSE  C  28       8                                                       
HET    MSE  C  50      13                                                       
HET    MSE  C  52       8                                                       
HET    MSE  C  62       8                                                       
HET    MSE  C 164       8                                                       
HET    MSE  C 179      13                                                       
HET    MSE  D   3       8                                                       
HET    MSE  D  19       8                                                       
HET    MSE  D  28      13                                                       
HET    MSE  D  50      16                                                       
HET    MSE  D  52       8                                                       
HET    MSE  D  62       8                                                       
HET    MSE  D 164       8                                                       
HET    MSE  D 179      13                                                       
HET    EDO    801       4                                                       
HET    EDO    802       4                                                       
HET    EDO    803       4                                                       
HET    EDO    804       4                                                       
HET    GOA    901       5                                                       
HET    GOA    902       5                                                       
HET    GOA    903       5                                                       
HET    GOA    904       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     GOA GLYCOLIC ACID                                                    
HETSYN     EDO ETHYLENE GLYCOL                                                  
HETSYN     GOA HYDROXYACETIC ACID; HYDROXYETHANOIC ACID                         
FORMUL   1  MSE    32(C5 H11 N O2 SE)                                           
FORMUL   5  EDO    4(C2 H6 O2)                                                  
FORMUL   9  GOA    4(C2 H4 O3)                                                  
FORMUL  13  HOH   *627(H2 O)                                                    
CRYST1   53.538   81.483  154.693  90.00  90.00  90.00 P 21 21 21   16          
ATOM   2823  N   GLY C   1      28.032  26.506  89.863  1.00 30.89           N  
ATOM   2824  CA  GLY C   1      26.811  27.281  89.577  1.00 29.61           C  
ATOM   2825  C   GLY C   1      26.493  27.318  88.108  1.00 28.41           C  
ATOM   2826  O   GLY C   1      27.220  26.777  87.294  1.00 28.20           O  
ATOM   2827  N   HIS C   2      25.403  28.001  87.777  1.00 27.75           N  
ATOM   2828  CA  HIS C   2      24.809  27.868  86.477  1.00 25.96           C  
ATOM   2829  C   HIS C   2      23.981  29.107  86.135  1.00 26.71           C  
ATOM   2830  O   HIS C   2      23.438  29.760  87.043  1.00 27.33           O  
ATOM   2831  CB  HIS C   2      23.879  26.646  86.464  1.00 26.36           C  
ATOM   2832  CG  HIS C   2      23.144  26.471  85.165  1.00 25.79           C  
ATOM   2833  ND1 HIS C   2      23.740  25.912  84.063  1.00 25.81           N  
ATOM   2834  CD2 HIS C   2      21.884  26.808  84.781  1.00 27.67           C  
ATOM   2835  CE1 HIS C   2      22.883  25.873  83.057  1.00 27.67           C  
ATOM   2836  NE2 HIS C   2      21.742  26.387  83.470  1.00 26.47           N  
HETATM 2837  N   MSE C   3      23.882  29.402  84.835  1.00 24.94           N  
HETATM 2838  CA  MSE C   3      23.082  30.525  84.377  0.50 25.06           C  
HETATM 2840  C   MSE C   3      21.574  30.205  84.372  1.00 24.80           C  
HETATM 2841  O   MSE C   3      20.936  30.025  83.314  1.00 27.57           O  
HETATM 2842  CB  MSE C   3      23.559  31.034  83.018  0.50 25.24           C  
HETATM 2844  CG  MSE C   3      22.832  32.283  82.572  0.50 22.28           C  
HETATM 2846 SE   MSE C   3      22.994  33.859  83.684  0.50 23.95          SE  
HETATM 2848  CE  MSE C   3      24.988  33.788  84.192  0.50 10.83           C  
ATOM   2850  N   SER C   4      21.004  30.132  85.569  1.00 22.49           N  
ATOM   2851  CA  SER C   4      19.603  29.754  85.726  1.00 21.45           C  
ATOM   2852  C   SER C   4      18.653  30.813  85.126  1.00 21.24           C  
ATOM   2853  O   SER C   4      19.033  31.956  84.817  1.00 19.31           O  
ATOM   2854  CB  SER C   4      19.317  29.582  87.211  1.00 18.87           C  
ATOM   2855  OG  SER C   4      19.370  30.862  87.812  1.00 18.33           O  
ATOM   2856  N   ARG C   5      17.399  30.428  84.966  1.00 22.49           N  
ATOM   2857  CA  ARG C   5      16.440  31.390  84.414  1.00 22.30           C  
ATOM   2858  C   ARG C   5      16.338  32.573  85.403  1.00 19.96           C  
ATOM   2859  O   ARG C   5      16.230  33.720  84.976  1.00 18.91           O  
ATOM   2860  CB  ARG C   5      15.142  30.691  84.169  1.00 23.75           C  
ATOM   2861  CG  ARG C   5      14.241  30.569  85.282  1.00 30.76           C  
ATOM   2862  CD  ARG C   5      12.941  31.378  84.990  1.00 38.26           C  
ATOM   2863  NE  ARG C   5      13.033  32.667  85.665  1.00 42.68           N  
ATOM   2864  CZ  ARG C   5      12.171  33.668  85.550  1.00 41.95           C  
ATOM   2865  NH1 ARG C   5      11.084  33.586  84.781  1.00 41.75           N  
ATOM   2866  NH2 ARG C   5      12.442  34.766  86.197  1.00 37.44           N  
ATOM   2867  N   ASN C   6      16.372  32.299  86.725  1.00 19.38           N  
ATOM   2868  CA  ASN C   6      16.247  33.482  87.653  1.00 19.23           C  
ATOM   2869  C   ASN C   6      17.472  34.404  87.540  1.00 18.22           C  
ATOM   2870  O   ASN C   6      17.379  35.626  87.607  1.00 18.01           O  
ATOM   2871  CB  ASN C   6      15.987  33.072  89.109  1.00 18.34           C  
ATOM   2872  CG  ASN C   6      14.535  32.649  89.349  1.00 20.19           C  
ATOM   2873  OD1 ASN C   6      13.766  32.414  88.409  1.00 22.36           O  
ATOM   2874  ND2 ASN C   6      14.151  32.567  90.642  1.00 23.22           N  
ATOM   2875  N   LEU C   7      18.666  33.824  87.473  1.00 19.26           N  
ATOM   2876  CA  LEU C   7      19.858  34.651  87.312  1.00 19.29           C  
ATOM   2877  C   LEU C   7      19.790  35.433  86.000  1.00 18.87           C  
ATOM   2878  O   LEU C   7      20.151  36.627  85.965  1.00 18.26           O  
ATOM   2879  CB  LEU C   7      21.120  33.791  87.417  1.00 17.63           C  
ATOM   2880  CG  LEU C   7      22.445  34.557  87.263  1.00 20.07           C  
ATOM   2881  CD1 LEU C   7      22.606  35.790  88.255  1.00 20.39           C  
ATOM   2882  CD2 LEU C   7      23.577  33.543  87.332  1.00 18.81           C  
ATOM   2883  N   LEU C   8      19.284  34.774  84.940  1.00 19.63           N  
ATOM   2884  CA  LEU C   8      19.126  35.453  83.623  1.00 21.92           C  
ATOM   2885  C   LEU C   8      18.190  36.642  83.777  1.00 22.22           C  
ATOM   2886  O   LEU C   8      18.467  37.703  83.208  1.00 22.04           O  
ATOM   2887  CB  LEU C   8      18.584  34.517  82.523  1.00 21.99           C  
ATOM   2888  CG  LEU C   8      19.688  33.702  81.805  1.00 26.87           C  
ATOM   2889  CD1 LEU C   8      19.032  32.520  81.083  1.00 29.87           C  
ATOM   2890  CD2 LEU C   8      20.536  34.550  80.847  1.00 27.90           C  
ATOM   2891  N   ALA C   9      17.137  36.454  84.580  1.00 21.87           N  
ATOM   2892  CA  ALA C   9      16.132  37.545  84.813  1.00 22.59           C  
ATOM   2893  C   ALA C   9      16.788  38.781  85.427  1.00 22.61           C  
ATOM   2894  O   ALA C   9      16.532  39.944  85.024  1.00 20.69           O  
ATOM   2895  CB  ALA C   9      14.981  37.052  85.731  1.00 22.77           C  
ATOM   2896  N   ILE C  10      17.635  38.533  86.419  1.00 23.45           N  
ATOM   2897  CA  ILE C  10      18.139  39.645  87.191  1.00 25.87           C  
ATOM   2898  C   ILE C  10      19.247  40.397  86.485  1.00 26.49           C  
ATOM   2899  O   ILE C  10      19.379  41.587  86.688  1.00 28.69           O  
ATOM   2900  CB  ILE C  10      18.456  39.340  88.707  1.00 26.93           C  
ATOM   2901  CG1 ILE C  10      19.519  38.289  88.894  1.00 26.48           C  
ATOM   2902  CG2 ILE C  10      17.213  39.031  89.503  1.00 28.60           C  
ATOM   2903  CD1 ILE C  10      20.124  38.398  90.410  1.00 28.49           C  
ATOM   2904  N   VAL C  11      19.995  39.710  85.619  1.00 25.08           N  
ATOM   2905  CA  VAL C  11      21.037  40.316  84.850  1.00 27.41           C  
ATOM   2906  C   VAL C  11      20.692  40.785  83.423  1.00 25.39           C  
ATOM   2907  O   VAL C  11      21.519  41.485  82.825  1.00 25.59           O  
ATOM   2908  CB  VAL C  11      22.206  39.362  84.668  1.00 28.19           C  
ATOM   2909  CG1 VAL C  11      21.888  38.348  83.606  1.00 27.12           C  
ATOM   2910  CG2 VAL C  11      23.440  40.165  84.262  1.00 34.22           C  
ATOM   2911  N   HIS C  12      19.557  40.383  82.875  1.00 24.99           N  
ATOM   2912  CA  HIS C  12      19.158  40.939  81.583  1.00 24.19           C  
ATOM   2913  C   HIS C  12      19.209  42.480  81.596  1.00 24.37           C  
ATOM   2914  O   HIS C  12      19.802  43.083  80.672  1.00 22.93           O  
ATOM   2915  CB  HIS C  12      17.813  40.396  81.030  1.00 24.61           C  
ATOM   2916  CG  HIS C  12      17.609  40.738  79.572  1.00 25.65           C  
ATOM   2917  ND1 HIS C  12      18.194  40.026  78.543  1.00 23.50           N  
ATOM   2918  CD2 HIS C  12      16.952  41.772  78.985  1.00 22.86           C  
ATOM   2919  CE1 HIS C  12      17.857  40.573  77.386  1.00 23.20           C  
ATOM   2920  NE2 HIS C  12      17.115  41.640  77.628  1.00 21.29           N  
ATOM   2921  N   PRO C  13      18.608  43.141  82.630  1.00 24.64           N  
ATOM   2922  CA  PRO C  13      18.860  44.600  82.657  1.00 24.11           C  
ATOM   2923  C   PRO C  13      20.322  45.047  82.604  1.00 23.35           C  
ATOM   2924  O   PRO C  13      20.614  46.122  82.132  1.00 22.22           O  
ATOM   2925  CB  PRO C  13      18.237  45.034  84.007  1.00 24.45           C  
ATOM   2926  CG  PRO C  13      17.169  44.094  84.231  1.00 26.01           C  
ATOM   2927  CD  PRO C  13      17.664  42.760  83.724  1.00 24.02           C  
ATOM   2928  N   ILE C  14      21.247  44.263  83.133  1.00 21.30           N  
ATOM   2929  CA  ILE C  14      22.661  44.669  83.125  1.00 20.54           C  
ATOM   2930  C   ILE C  14      23.158  44.582  81.686  1.00 18.64           C  
ATOM   2931  O   ILE C  14      23.891  45.410  81.247  1.00 18.49           O  
ATOM   2932  CB  ILE C  14      23.523  43.748  84.032  1.00 20.50           C  
ATOM   2933  CG1 ILE C  14      23.088  43.925  85.503  1.00 23.72           C  
ATOM   2934  CG2 ILE C  14      25.005  44.010  83.834  1.00 21.99           C  
ATOM   2935  CD1 ILE C  14      23.478  42.707  86.378  1.00 22.36           C  
ATOM   2936  N   LEU C  15      22.702  43.570  80.939  1.00 19.45           N  
ATOM   2937  CA  LEU C  15      23.092  43.509  79.529  1.00 18.82           C  
ATOM   2938  C   LEU C  15      22.515  44.629  78.689  1.00 19.30           C  
ATOM   2939  O   LEU C  15      23.262  45.188  77.848  1.00 18.56           O  
ATOM   2940  CB  LEU C  15      22.668  42.198  78.884  1.00 18.35           C  
ATOM   2941  CG  LEU C  15      23.082  40.914  79.619  1.00 21.28           C  
ATOM   2942  CD1 LEU C  15      22.648  39.660  78.774  1.00 21.87           C  
ATOM   2943  CD2 LEU C  15      24.580  40.852  80.020  1.00 20.86           C  
ATOM   2944  N   ARG C  16      21.256  44.978  78.942  1.00 19.38           N  
ATOM   2945  CA  ARG C  16      20.642  46.150  78.268  1.00 20.90           C  
ATOM   2946  C   ARG C  16      21.427  47.440  78.541  1.00 19.10           C  
ATOM   2947  O   ARG C  16      21.732  48.257  77.605  1.00 18.32           O  
ATOM   2948  CB  ARG C  16      19.164  46.307  78.662  1.00 20.10           C  
ATOM   2949  CG  ARG C  16      18.281  45.151  78.282  1.00 20.47           C  
ATOM   2950  CD  ARG C  16      16.838  45.489  78.661  1.00 25.38           C  
ATOM   2951  NE  ARG C  16      16.209  46.493  77.756  1.00 24.12           N  
ATOM   2952  CZ  ARG C  16      14.956  46.969  77.943  1.00 26.07           C  
ATOM   2953  NH1 ARG C  16      14.194  46.545  78.971  1.00 23.65           N  
ATOM   2954  NH2 ARG C  16      14.442  47.867  77.115  1.00 25.21           N  
ATOM   2955  N   ASN C  17      21.771  47.655  79.809  1.00 19.33           N  
ATOM   2956  CA  ASN C  17      22.507  48.839  80.147  1.00 21.38           C  
ATOM   2957  C   ASN C  17      23.909  48.833  79.524  1.00 19.71           C  
ATOM   2958  O   ASN C  17      24.422  49.862  79.111  1.00 19.73           O  
ATOM   2959  CB  ASN C  17      22.589  49.028  81.663  1.00 23.30           C  
ATOM   2960  CG  ASN C  17      21.243  49.324  82.315  1.00 25.62           C  
ATOM   2961  OD1 ASN C  17      20.243  49.641  81.656  1.00 32.07           O  
ATOM   2962  ND2 ASN C  17      21.201  49.145  83.621  1.00 33.37           N  
ATOM   2963  N   LEU C  18      24.542  47.652  79.440  1.00 20.61           N  
ATOM   2964  CA  LEU C  18      25.842  47.579  78.852  1.00 19.30           C  
ATOM   2965  C   LEU C  18      25.809  47.870  77.301  1.00 20.67           C  
ATOM   2966  O   LEU C  18      26.754  48.542  76.742  1.00 20.54           O  
ATOM   2967  CB  LEU C  18      26.475  46.216  79.147  1.00 18.36           C  
ATOM   2968  CG  LEU C  18      27.909  45.987  78.663  1.00 20.46           C  
ATOM   2969  CD1 LEU C  18      28.814  47.026  79.386  1.00 15.67           C  
ATOM   2970  CD2 LEU C  18      28.388  44.537  78.912  1.00 18.66           C  
HETATM 2971  N   MSE C  19      24.761  47.332  76.634  1.00 19.79           N  
HETATM 2972  CA  MSE C  19      24.529  47.642  75.199  1.00 19.29           C  
HETATM 2973  C   MSE C  19      24.417  49.195  75.080  1.00 19.52           C  
HETATM 2974  O   MSE C  19      25.100  49.798  74.220  1.00 19.73           O  
HETATM 2975  CB  MSE C  19      23.312  46.948  74.609  1.00 21.00           C  
HETATM 2976  CG  MSE C  19      23.087  47.269  73.131  1.00 19.36           C  
HETATM 2977 SE   MSE C  19      22.111  48.981  72.849  1.00 23.51          SE  
HETATM 2978  CE  MSE C  19      20.377  48.312  73.230  1.00 27.52           C  
ATOM   2979  N   GLU C  20      23.616  49.832  75.958  1.00 20.41           N  
ATOM   2980  CA  GLU C  20      23.375  51.288  75.824  1.00 23.50           C  
ATOM   2981  C   GLU C  20      24.689  52.037  76.056  1.00 22.56           C  
ATOM   2982  O   GLU C  20      25.112  52.848  75.196  1.00 23.87           O  
ATOM   2983  CB  GLU C  20      22.278  51.726  76.795  1.00 22.38           C  
ATOM   2984  CG  GLU C  20      20.868  51.356  76.310  1.00 30.34           C  
ATOM   2985  CD  GLU C  20      20.433  52.058  74.968  1.00 35.42           C  
ATOM   2986  OE1 GLU C  20      19.603  51.474  74.209  1.00 39.35           O  
ATOM   2987  OE2 GLU C  20      20.919  53.189  74.673  1.00 39.45           O  
ATOM   2988  N   GLU C  21      25.420  51.665  77.121  1.00 22.37           N  
ATOM   2989  CA  GLU C  21      26.679  52.347  77.500  1.00 23.57           C  
ATOM   2990  C   GLU C  21      27.775  52.199  76.445  1.00 23.44           C  
ATOM   2991  O   GLU C  21      28.535  53.132  76.126  1.00 21.39           O  
ATOM   2992  CB  GLU C  21      27.134  51.879  78.865  1.00 24.46           C  
ATOM   2993  CG  GLU C  21      28.390  52.613  79.375  1.00 27.46           C  
ATOM   2994  CD  GLU C  21      28.889  52.091  80.725  1.00 28.99           C  
ATOM   2995  OE1 GLU C  21      30.064  52.354  81.055  1.00 34.64           O  
ATOM   2996  OE2 GLU C  21      28.085  51.496  81.490  1.00 37.59           O  
ATOM   2997  N   SER C  22      27.856  50.999  75.881  1.00 20.89           N  
ATOM   2998  CA  SER C  22      28.944  50.672  74.946  1.00 22.43           C  
ATOM   2999  C   SER C  22      28.590  51.075  73.510  1.00 20.63           C  
ATOM   3000  O   SER C  22      29.482  51.415  72.716  1.00 20.57           O  
ATOM   3001  CB  SER C  22      29.246  49.155  74.991  1.00 20.85           C  
ATOM   3002  OG  SER C  22      28.204  48.376  74.399  1.00 22.21           O  
ATOM   3003  N   GLY C  23      27.290  50.975  73.184  1.00 19.09           N  
ATOM   3004  CA  GLY C  23      26.765  51.169  71.833  1.00 18.26           C  
ATOM   3005  C   GLY C  23      26.938  49.990  70.900  1.00 18.97           C  
ATOM   3006  O   GLY C  23      26.746  50.117  69.714  1.00 19.43           O  
ATOM   3007  N   GLU C  24      27.270  48.822  71.471  1.00 17.34           N  
ATOM   3008  CA  GLU C  24      27.522  47.606  70.673  1.00 18.83           C  
ATOM   3009  C   GLU C  24      26.773  46.403  71.188  1.00 19.03           C  
ATOM   3010  O   GLU C  24      26.227  46.428  72.301  1.00 19.84           O  
ATOM   3011  CB  GLU C  24      29.041  47.265  70.622  1.00 17.61           C  
ATOM   3012  CG  GLU C  24      29.890  48.417  70.076  1.00 20.42           C  
ATOM   3013  CD  GLU C  24      29.575  48.700  68.593  1.00 19.86           C  
ATOM   3014  OE1 GLU C  24      29.084  47.804  67.885  1.00 20.79           O  
ATOM   3015  OE2 GLU C  24      29.803  49.831  68.118  1.00 22.34           O  
ATOM   3016  N   THR C  25      26.730  45.348  70.353  1.00 17.05           N  
ATOM   3017  CA  THR C  25      25.983  44.141  70.763  1.00 16.40           C  
ATOM   3018  C   THR C  25      26.695  43.505  71.976  1.00 15.97           C  
ATOM   3019  O   THR C  25      27.914  43.504  72.027  1.00 16.36           O  
ATOM   3020  CB  THR C  25      25.888  43.192  69.550  1.00 16.44           C  
ATOM   3021  OG1 THR C  25      24.996  43.785  68.571  1.00 17.78           O  
ATOM   3022  CG2 THR C  25      25.379  41.820  70.003  1.00 19.57           C  
ATOM   3023  N   VAL C  26      25.904  43.084  72.962  1.00 13.92           N  
ATOM   3024  CA  VAL C  26      26.340  42.382  74.153  1.00 16.80           C  
ATOM   3025  C   VAL C  26      25.757  40.956  74.192  1.00 16.67           C  
ATOM   3026  O   VAL C  26      24.583  40.731  73.887  1.00 17.39           O  
ATOM   3027  CB  VAL C  26      25.848  43.173  75.356  1.00 15.94           C  
ATOM   3028  CG1 VAL C  26      25.988  42.363  76.638  1.00 16.12           C  
ATOM   3029  CG2 VAL C  26      26.610  44.556  75.427  1.00 18.89           C  
ATOM   3030  N   ASN C  27      26.615  39.994  74.467  1.00 15.61           N  
ATOM   3031  CA  ASN C  27      26.226  38.615  74.450  1.00 16.81           C  
ATOM   3032  C   ASN C  27      26.475  38.039  75.842  1.00 16.05           C  
ATOM   3033  O   ASN C  27      27.423  38.458  76.502  1.00 17.56           O  
ATOM   3034  CB  ASN C  27      27.138  37.840  73.474  1.00 15.58           C  
ATOM   3035  CG  ASN C  27      27.059  38.403  72.078  1.00 18.13           C  
ATOM   3036  OD1 ASN C  27      25.990  38.304  71.461  1.00 19.81           O  
ATOM   3037  ND2 ASN C  27      28.101  39.145  71.636  1.00 20.99           N  
HETATM 3038  N   MSE C  28      25.673  37.071  76.231  1.00 16.31           N  
HETATM 3039  CA  MSE C  28      25.937  36.202  77.376  1.00 17.86           C  
HETATM 3040  C   MSE C  28      26.129  34.807  76.832  1.00 19.17           C  
HETATM 3041  O   MSE C  28      25.209  34.260  76.155  1.00 18.52           O  
HETATM 3042  CB  MSE C  28      24.816  36.233  78.414  1.00 19.22           C  
HETATM 3043  CG  MSE C  28      24.994  35.186  79.507  1.00 25.16           C  
HETATM 3044 SE   MSE C  28      26.205  35.986  80.819  1.00 31.36          SE  
HETATM 3045  CE  MSE C  28      24.964  36.986  81.914  1.00 23.17           C  
ATOM   3046  N   ALA C  29      27.294  34.242  77.149  1.00 18.72           N  
ATOM   3047  CA  ALA C  29      27.654  32.898  76.698  1.00 19.21           C  
ATOM   3048  C   ALA C  29      27.903  31.927  77.853  1.00 19.34           C  
ATOM   3049  O   ALA C  29      28.359  32.315  78.937  1.00 17.93           O  
ATOM   3050  CB  ALA C  29      28.908  32.925  75.805  1.00 19.51           C  
ATOM   3051  N   VAL C  30      27.675  30.663  77.574  1.00 18.57           N  
ATOM   3052  CA  VAL C  30      28.057  29.592  78.522  1.00 20.55           C  
ATOM   3053  C   VAL C  30      28.874  28.568  77.728  1.00 22.64           C  
ATOM   3054  O   VAL C  30      28.936  28.615  76.481  1.00 20.61           O  
ATOM   3055  CB  VAL C  30      26.810  28.918  79.186  1.00 20.26           C  
ATOM   3056  CG1 VAL C  30      25.933  29.978  79.949  1.00 21.00           C  
ATOM   3057  CG2 VAL C  30      25.936  28.176  78.128  1.00 20.61           C  
ATOM   3058  N   LEU C  31      29.465  27.643  78.439  1.00 26.03           N  
ATOM   3059  CA  LEU C  31      30.330  26.628  77.837  1.00 30.36           C  
ATOM   3060  C   LEU C  31      29.558  25.400  77.311  1.00 33.15           C  
ATOM   3061  O   LEU C  31      28.570  24.939  77.885  1.00 32.34           O  
ATOM   3062  CB  LEU C  31      31.382  26.261  78.876  1.00 30.79           C  
ATOM   3063  CG  LEU C  31      32.877  26.139  78.591  1.00 32.18           C  
ATOM   3064  CD1 LEU C  31      33.490  27.407  78.037  1.00 36.08           C  
ATOM   3065  CD2 LEU C  31      33.600  25.643  79.824  1.00 32.74           C  
ATOM   3066  N   ASP C  32      29.965  24.921  76.150  1.00 36.12           N  
ATOM   3067  CA  ASP C  32      29.677  23.544  75.754  1.00 40.21           C  
ATOM   3068  C   ASP C  32      30.972  22.780  76.123  1.00 42.27           C  
ATOM   3069  O   ASP C  32      32.063  23.046  75.583  1.00 42.35           O  
ATOM   3070  CB  ASP C  32      29.312  23.450  74.257  1.00 40.68           C  
ATOM   3071  CG  ASP C  32      28.736  22.065  73.854  1.00 44.43           C  
ATOM   3072  OD1 ASP C  32      27.903  22.013  72.899  1.00 45.01           O  
ATOM   3073  OD2 ASP C  32      29.096  21.037  74.489  1.00 44.95           O  
ATOM   3074  N   GLN C  33      30.862  21.914  77.118  1.00 44.58           N  
ATOM   3075  CA  GLN C  33      31.987  21.068  77.534  1.00 47.44           C  
ATOM   3076  C   GLN C  33      32.380  20.094  76.406  1.00 48.07           C  
ATOM   3077  O   GLN C  33      33.562  19.784  76.187  1.00 48.53           O  
ATOM   3078  CB  GLN C  33      31.606  20.306  78.825  1.00 47.40           C  
ATOM   3079  CG  GLN C  33      30.552  19.191  78.681  1.00 49.83           C  
ATOM   3080  CD  GLN C  33      29.094  19.679  78.443  1.00 53.69           C  
ATOM   3081  OE1 GLN C  33      28.264  18.934  77.884  1.00 52.80           O  
ATOM   3082  NE2 GLN C  33      28.777  20.912  78.880  1.00 53.07           N  
ATOM   3083  N   SER C  34      31.350  19.693  75.664  1.00 49.52           N  
ATOM   3084  CA  SER C  34      31.321  18.476  74.830  1.00 50.45           C  
ATOM   3085  C   SER C  34      31.579  18.769  73.340  1.00 50.44           C  
ATOM   3086  O   SER C  34      31.777  17.851  72.518  1.00 50.90           O  
ATOM   3087  CB  SER C  34      29.958  17.749  75.052  1.00 50.37           C  
ATOM   3088  OG  SER C  34      29.920  16.470  74.436  1.00 51.05           O  
ATOM   3089  N   ASP C  35      31.565  20.049  72.986  1.00 50.09           N  
ATOM   3090  CA  ASP C  35      32.043  20.462  71.680  1.00 49.76           C  
ATOM   3091  C   ASP C  35      33.269  21.347  71.879  1.00 48.55           C  
ATOM   3092  O   ASP C  35      33.921  21.736  70.911  1.00 49.33           O  
ATOM   3093  CB  ASP C  35      30.942  21.182  70.887  1.00 50.49           C  
ATOM   3094  CG  ASP C  35      31.145  21.094  69.376  1.00 52.19           C  
ATOM   3095  OD1 ASP C  35      31.587  22.100  68.789  1.00 54.84           O  
ATOM   3096  OD2 ASP C  35      30.869  20.030  68.771  1.00 51.25           O  
ATOM   3097  N   HIS C  36      33.628  21.565  73.140  1.00 46.62           N  
ATOM   3098  CA  HIS C  36      34.525  22.654  73.566  1.00 44.76           C  
ATOM   3099  C   HIS C  36      34.383  23.884  72.675  1.00 42.25           C  
ATOM   3100  O   HIS C  36      35.267  24.205  71.857  1.00 40.72           O  
ATOM   3101  CB  HIS C  36      35.976  22.222  73.822  1.00 46.74           C  
ATOM   3102  CG  HIS C  36      36.466  22.582  75.208  1.00 49.49           C  
ATOM   3103  ND1 HIS C  36      36.697  21.640  76.192  1.00 51.52           N  
ATOM   3104  CD2 HIS C  36      36.723  23.790  75.785  1.00 50.59           C  
ATOM   3105  CE1 HIS C  36      37.088  22.241  77.305  1.00 52.12           C  
ATOM   3106  NE2 HIS C  36      37.118  23.547  77.085  1.00 52.20           N  
ATOM   3107  N   GLU C  37      33.203  24.522  72.820  1.00 40.02           N  
ATOM   3108  CA  GLU C  37      32.890  25.878  72.292  1.00 35.69           C  
ATOM   3109  C   GLU C  37      31.972  26.587  73.294  1.00 32.66           C  
ATOM   3110  O   GLU C  37      31.372  25.954  74.157  1.00 30.24           O  
ATOM   3111  CB  GLU C  37      32.185  25.806  70.930  1.00 35.37           C  
ATOM   3112  CG  GLU C  37      32.826  24.848  69.895  1.00 37.58           C  
ATOM   3113  CD  GLU C  37      32.060  24.739  68.577  1.00 39.28           C  
ATOM   3114  OE1 GLU C  37      30.847  25.067  68.538  1.00 39.89           O  
ATOM   3115  OE2 GLU C  37      32.680  24.273  67.576  1.00 45.16           O  
ATOM   3116  N   ALA C  38      31.866  27.894  73.164  1.00 28.90           N  
ATOM   3117  CA  ALA C  38      30.851  28.639  73.920  1.00 26.86           C  
ATOM   3118  C   ALA C  38      29.558  28.827  73.127  1.00 25.86           C  
ATOM   3119  O   ALA C  38      29.557  28.963  71.899  1.00 26.28           O  
ATOM   3120  CB  ALA C  38      31.398  29.981  74.282  1.00 25.31           C  
ATOM   3121  N   ILE C  39      28.438  28.909  73.819  1.00 22.59           N  
ATOM   3122  CA  ILE C  39      27.183  29.094  73.126  1.00 22.36           C  
ATOM   3123  C   ILE C  39      26.498  30.412  73.639  1.00 20.46           C  
ATOM   3124  O   ILE C  39      26.433  30.633  74.871  1.00 19.60           O  
ATOM   3125  CB  ILE C  39      26.298  27.793  73.323  1.00 21.64           C  
ATOM   3126  CG1 ILE C  39      24.917  27.992  72.713  1.00 23.85           C  
ATOM   3127  CG2 ILE C  39      26.184  27.472  74.759  1.00 26.70           C  
ATOM   3128  CD1 ILE C  39      24.076  26.706  72.523  1.00 26.81           C  
ATOM   3129  N   ILE C  40      26.031  31.269  72.733  1.00 19.62           N  
ATOM   3130  CA  ILE C  40      25.257  32.450  73.125  1.00 18.32           C  
ATOM   3131  C   ILE C  40      23.883  32.016  73.667  1.00 19.62           C  
ATOM   3132  O   ILE C  40      23.067  31.399  72.958  1.00 19.09           O  
ATOM   3133  CB  ILE C  40      25.128  33.457  71.959  1.00 19.81           C  
ATOM   3134  CG1 ILE C  40      26.551  33.841  71.466  1.00 17.44           C  
ATOM   3135  CG2 ILE C  40      24.201  34.650  72.301  1.00 18.76           C  
ATOM   3136  CD1 ILE C  40      26.514  34.820  70.204  1.00 16.22           C  
ATOM   3137  N   ILE C  41      23.631  32.338  74.931  1.00 18.40           N  
ATOM   3138  CA  ILE C  41      22.329  32.079  75.525  1.00 19.04           C  
ATOM   3139  C   ILE C  41      21.454  33.323  75.722  1.00 18.27           C  
ATOM   3140  O   ILE C  41      20.239  33.184  75.900  1.00 17.86           O  
ATOM   3141  CB  ILE C  41      22.469  31.272  76.881  1.00 20.57           C  
ATOM   3142  CG1 ILE C  41      23.085  32.164  78.004  1.00 18.37           C  
ATOM   3143  CG2 ILE C  41      23.093  29.830  76.568  1.00 24.16           C  
ATOM   3144  CD1 ILE C  41      23.228  31.433  79.360  1.00 21.31           C  
ATOM   3145  N   ASP C  42      22.065  34.509  75.785  1.00 17.51           N  
ATOM   3146  CA  ASP C  42      21.257  35.730  75.822  1.00 18.00           C  
ATOM   3147  C   ASP C  42      22.054  36.833  75.075  1.00 16.09           C  
ATOM   3148  O   ASP C  42      23.247  36.680  74.846  1.00 17.98           O  
ATOM   3149  CB  ASP C  42      20.923  36.168  77.293  1.00 17.76           C  
ATOM   3150  CG  ASP C  42      19.708  37.168  77.364  1.00 21.14           C  
ATOM   3151  OD1 ASP C  42      19.079  37.542  76.301  1.00 21.72           O  
ATOM   3152  OD2 ASP C  42      19.393  37.579  78.499  1.00 20.22           O  
ATOM   3153  N   GLN C  43      21.355  37.909  74.707  1.00 17.07           N  
ATOM   3154  CA  GLN C  43      21.954  38.976  73.894  1.00 17.35           C  
ATOM   3155  C   GLN C  43      21.086  40.192  73.963  1.00 18.04           C  
ATOM   3156  O   GLN C  43      19.836  40.086  74.051  1.00 17.63           O  
ATOM   3157  CB  GLN C  43      22.026  38.489  72.449  1.00 18.28           C  
ATOM   3158  CG  GLN C  43      22.723  39.387  71.443  1.00 20.86           C  
ATOM   3159  CD  GLN C  43      22.526  38.805  70.066  1.00 22.61           C  
ATOM   3160  OE1 GLN C  43      21.382  38.647  69.560  1.00 23.46           O  
ATOM   3161  NE2 GLN C  43      23.608  38.380  69.502  1.00 21.52           N  
ATOM   3162  N   VAL C  44      21.734  41.343  73.951  1.00 15.06           N  
ATOM   3163  CA  VAL C  44      21.044  42.562  73.534  1.00 17.35           C  
ATOM   3164  C   VAL C  44      21.794  43.204  72.371  1.00 17.77           C  
ATOM   3165  O   VAL C  44      22.975  43.651  72.516  1.00 18.81           O  
ATOM   3166  CB  VAL C  44      20.937  43.528  74.736  1.00 15.29           C  
ATOM   3167  CG1 VAL C  44      20.164  44.843  74.334  1.00 17.82           C  
ATOM   3168  CG2 VAL C  44      20.215  42.845  75.915  1.00 20.82           C  
ATOM   3169  N   GLN C  45      21.185  43.219  71.192  1.00 18.73           N  
ATOM   3170  CA  GLN C  45      21.918  43.842  70.058  1.00 18.59           C  
ATOM   3171  C   GLN C  45      21.825  45.351  70.126  1.00 19.01           C  
ATOM   3172  O   GLN C  45      20.848  45.904  70.652  1.00 18.53           O  
ATOM   3173  CB  GLN C  45      21.368  43.350  68.713  1.00 19.32           C  
ATOM   3174  CG  GLN C  45      21.550  41.855  68.508  1.00 18.09           C  
ATOM   3175  CD  GLN C  45      21.233  41.415  67.111  1.00 21.08           C  
ATOM   3176  OE1 GLN C  45      21.120  42.243  66.165  1.00 20.26           O  
ATOM   3177  NE2 GLN C  45      21.120  40.109  66.940  1.00 18.87           N  
ATOM   3178  N   CYS C  46      22.870  46.025  69.650  1.00 18.17           N  
ATOM   3179  CA  CYS C  46      22.777  47.473  69.368  1.00 19.70           C  
ATOM   3180  C   CYS C  46      21.908  47.725  68.075  1.00 18.70           C  
ATOM   3181  O   CYS C  46      21.422  46.782  67.431  1.00 18.15           O  
ATOM   3182  CB  CYS C  46      24.198  48.069  69.246  1.00 18.94           C  
ATOM   3183  SG  CYS C  46      25.065  47.496  67.708  1.00 20.43           S  
ATOM   3184  N   THR C  47      21.737  48.993  67.720  1.00 20.32           N  
ATOM   3185  CA  THR C  47      20.789  49.319  66.644  1.00 20.29           C  
ATOM   3186  C   THR C  47      21.567  49.825  65.401  1.00 21.37           C  
ATOM   3187  O   THR C  47      20.964  50.097  64.366  1.00 20.01           O  
ATOM   3188  CB  THR C  47      19.642  50.291  67.119  1.00 22.47           C  
ATOM   3189  OG1 THR C  47      20.243  51.528  67.474  1.00 22.56           O  
ATOM   3190  CG2 THR C  47      18.869  49.691  68.324  1.00 21.77           C  
ATOM   3191  N   HIS C  48      22.907  49.853  65.477  1.00 21.93           N  
ATOM   3192  CA  HIS C  48      23.715  50.151  64.266  1.00 21.79           C  
ATOM   3193  C   HIS C  48      23.430  49.222  63.078  1.00 23.18           C  
ATOM   3194  O   HIS C  48      23.266  48.022  63.213  1.00 22.15           O  
ATOM   3195  CB  HIS C  48      25.214  50.117  64.575  1.00 21.59           C  
ATOM   3196  CG  HIS C  48      25.668  51.109  65.599  1.00 22.51           C  
ATOM   3197  ND1 HIS C  48      25.744  52.474  65.358  1.00 26.22           N  
ATOM   3198  CD2 HIS C  48      26.086  50.934  66.875  1.00 23.40           C  
ATOM   3199  CE1 HIS C  48      26.206  53.086  66.437  1.00 25.89           C  
ATOM   3200  NE2 HIS C  48      26.411  52.176  67.374  1.00 28.44           N  
ATOM   3201  N   LEU C  49      23.420  49.815  61.880  1.00 23.68           N  
ATOM   3202  CA  LEU C  49      23.188  49.101  60.638  1.00 24.42           C  
ATOM   3203  C   LEU C  49      24.166  47.960  60.464  1.00 23.01           C  
ATOM   3204  O   LEU C  49      23.786  46.841  60.134  1.00 22.93           O  
ATOM   3205  CB  LEU C  49      23.367  50.042  59.433  1.00 25.80           C  
ATOM   3206  CG  LEU C  49      22.098  50.164  58.618  1.00 30.11           C  
ATOM   3207  CD1 LEU C  49      22.384  50.941  57.339  1.00 28.42           C  
ATOM   3208  CD2 LEU C  49      21.490  48.778  58.355  1.00 26.16           C  
HETATM 3209  N   MSE C  50      25.407  48.278  60.752  1.00 21.91           N  
HETATM 3210  CA  MSE C  50      26.514  47.329  60.647  0.50 22.01           C  
HETATM 3212  C   MSE C  50      26.828  46.926  62.059  1.00 21.41           C  
HETATM 3213  O   MSE C  50      27.282  47.740  62.850  1.00 22.18           O  
HETATM 3214  CB  MSE C  50      27.764  47.958  60.009  0.50 21.81           C  
HETATM 3216  CG  MSE C  50      29.018  47.085  60.100  0.50 22.09           C  
HETATM 3218 SE   MSE C  50      28.687  45.430  59.171  0.50 22.06          SE  
HETATM 3220  CE  MSE C  50      27.994  46.156  57.500  0.50  6.30           C  
ATOM   3222  N   ARG C  51      26.580  45.683  62.375  1.00 20.03           N  
ATOM   3223  CA  ARG C  51      26.792  45.253  63.777  1.00 18.03           C  
ATOM   3224  C   ARG C  51      26.994  43.748  63.879  1.00 16.65           C  
ATOM   3225  O   ARG C  51      26.804  43.007  62.883  1.00 19.70           O  
ATOM   3226  CB  ARG C  51      25.601  45.701  64.664  1.00 15.04           C  
ATOM   3227  CG  ARG C  51      24.252  45.045  64.201  1.00 19.71           C  
ATOM   3228  CD  ARG C  51      23.190  45.421  65.239  1.00 21.12           C  
ATOM   3229  NE  ARG C  51      21.941  44.703  64.962  1.00 21.21           N  
ATOM   3230  CZ  ARG C  51      20.952  45.247  64.264  1.00 25.91           C  
ATOM   3231  NH1 ARG C  51      21.106  46.499  63.800  1.00 22.23           N  
ATOM   3232  NH2 ARG C  51      19.839  44.541  64.023  1.00 24.50           N  
HETATM 3233  N   MSE C  52      27.437  43.271  65.058  1.00 16.53           N  
HETATM 3234  CA  MSE C  52      27.563  41.836  65.280  1.00 17.86           C  
HETATM 3235  C   MSE C  52      26.119  41.433  65.618  1.00 18.94           C  
HETATM 3236  O   MSE C  52      25.490  42.094  66.435  1.00 20.30           O  
HETATM 3237  CB  MSE C  52      28.521  41.516  66.443  1.00 18.99           C  
HETATM 3238  CG  MSE C  52      28.801  40.029  66.608  1.00 20.29           C  
HETATM 3239 SE   MSE C  52      27.464  39.360  67.953  1.00 23.33          SE  
HETATM 3240  CE  MSE C  52      28.477  37.755  68.536  1.00 23.92           C  
ATOM   3241  N   SER C  53      25.599  40.412  64.969  1.00 21.31           N  
ATOM   3242  CA  SER C  53      24.158  40.071  65.062  1.00 22.54           C  
ATOM   3243  C   SER C  53      24.048  38.559  64.955  1.00 23.33           C  
ATOM   3244  O   SER C  53      23.050  37.997  64.443  1.00 23.79           O  
ATOM   3245  CB  SER C  53      23.293  40.841  63.988  1.00 23.72           C  
ATOM   3246  OG  SER C  53      23.810  40.678  62.651  1.00 23.52           O  
ATOM   3247  N   ALA C  54      25.041  37.880  65.526  1.00 22.56           N  
ATOM   3248  CA  ALA C  54      24.953  36.442  65.637  1.00 22.19           C  
ATOM   3249  C   ALA C  54      23.741  36.131  66.488  1.00 22.50           C  
ATOM   3250  O   ALA C  54      23.344  36.931  67.280  1.00 22.56           O  
ATOM   3251  CB  ALA C  54      26.163  35.872  66.291  1.00 23.39           C  
ATOM   3252  N   PRO C  55      23.077  34.994  66.219  1.00 22.05           N  
ATOM   3253  CA  PRO C  55      21.898  34.703  67.027  1.00 23.62           C  
ATOM   3254  C   PRO C  55      22.162  33.943  68.335  1.00 21.90           C  
ATOM   3255  O   PRO C  55      23.178  33.235  68.503  1.00 21.99           O  
ATOM   3256  CB  PRO C  55      21.106  33.769  66.126  1.00 22.81           C  
ATOM   3257  CG  PRO C  55      22.177  32.948  65.512  1.00 23.83           C  
ATOM   3258  CD  PRO C  55      23.279  33.972  65.182  1.00 24.47           C  
ATOM   3259  N   ILE C  56      21.177  34.034  69.216  1.00 22.65           N  
ATOM   3260  CA  ILE C  56      21.155  33.216  70.437  1.00 23.05           C  
ATOM   3261  C   ILE C  56      21.163  31.751  69.933  1.00 24.35           C  
ATOM   3262  O   ILE C  56      20.553  31.419  68.859  1.00 24.28           O  
ATOM   3263  CB  ILE C  56      19.925  33.538  71.287  1.00 23.78           C  
ATOM   3264  CG1 ILE C  56      20.114  34.912  71.980  1.00 23.94           C  
ATOM   3265  CG2 ILE C  56      19.672  32.393  72.330  1.00 23.19           C  
ATOM   3266  CD1 ILE C  56      18.849  35.512  72.668  1.00 23.96           C  
ATOM   3267  N   GLY C  57      21.912  30.915  70.630  1.00 22.83           N  
ATOM   3268  CA  GLY C  57      22.250  29.585  70.152  1.00 23.84           C  
ATOM   3269  C   GLY C  57      23.485  29.477  69.269  1.00 25.01           C  
ATOM   3270  O   GLY C  57      24.020  28.376  69.096  1.00 25.44           O  
ATOM   3271  N   GLY C  58      23.933  30.586  68.686  1.00 24.53           N  
ATOM   3272  CA  GLY C  58      25.236  30.599  67.989  1.00 24.90           C  
ATOM   3273  C   GLY C  58      26.432  30.191  68.845  1.00 25.30           C  
ATOM   3274  O   GLY C  58      26.464  30.368  70.067  1.00 23.40           O  
ATOM   3275  N   LYS C  59      27.412  29.597  68.192  1.00 25.32           N  
ATOM   3276  CA  LYS C  59      28.555  28.981  68.841  1.00 26.69           C  
ATOM   3277  C   LYS C  59      29.756  29.907  68.627  1.00 26.30           C  
ATOM   3278  O   LYS C  59      29.859  30.545  67.564  1.00 27.04           O  
ATOM   3279  CB  LYS C  59      28.830  27.644  68.184  1.00 28.67           C  
ATOM   3280  CG  LYS C  59      28.274  26.388  68.869  1.00 33.61           C  
ATOM   3281  CD  LYS C  59      26.804  26.400  69.053  1.00 37.35           C  
ATOM   3282  CE  LYS C  59      26.273  24.979  68.996  1.00 39.23           C  
ATOM   3283  NZ  LYS C  59      24.898  25.018  69.507  1.00 43.40           N  
ATOM   3284  N   LEU C  60      30.621  30.045  69.629  1.00 23.69           N  
ATOM   3285  CA  LEU C  60      31.804  30.914  69.483  1.00 21.10           C  
ATOM   3286  C   LEU C  60      33.029  30.045  69.804  1.00 20.97           C  
ATOM   3287  O   LEU C  60      32.979  29.222  70.755  1.00 21.95           O  
ATOM   3288  CB  LEU C  60      31.706  32.176  70.403  1.00 22.09           C  
ATOM   3289  CG  LEU C  60      30.570  33.194  70.112  1.00 18.47           C  
ATOM   3290  CD1 LEU C  60      30.348  34.218  71.291  1.00 21.42           C  
ATOM   3291  CD2 LEU C  60      31.010  33.966  68.885  1.00 16.22           C  
ATOM   3292  N   PRO C  61      34.123  30.172  69.028  1.00 20.69           N  
ATOM   3293  CA  PRO C  61      35.247  29.225  69.251  1.00 20.25           C  
ATOM   3294  C   PRO C  61      36.091  29.562  70.495  1.00 20.43           C  
ATOM   3295  O   PRO C  61      36.240  30.735  70.880  1.00 17.99           O  
ATOM   3296  CB  PRO C  61      36.097  29.399  67.985  1.00 19.77           C  
ATOM   3297  CG  PRO C  61      35.858  30.854  67.599  1.00 20.93           C  
ATOM   3298  CD  PRO C  61      34.393  31.098  67.903  1.00 20.45           C  
HETATM 3299  N   MSE C  62      36.668  28.532  71.112  1.00 19.02           N  
HETATM 3300  CA  MSE C  62      37.381  28.741  72.364  1.00 19.88           C  
HETATM 3301  C   MSE C  62      38.627  29.617  72.219  1.00 18.63           C  
HETATM 3302  O   MSE C  62      38.875  30.414  73.110  1.00 19.33           O  
HETATM 3303  CB  MSE C  62      37.707  27.424  73.114  1.00 19.51           C  
HETATM 3304  CG  MSE C  62      36.412  26.630  73.506  1.00 21.31           C  
HETATM 3305 SE   MSE C  62      35.192  27.544  74.749  1.00 28.24          SE  
HETATM 3306  CE  MSE C  62      36.571  27.862  76.094  1.00 24.44           C  
ATOM   3307  N   HIS C  63      39.366  29.502  71.104  1.00 17.79           N  
ATOM   3308  CA  HIS C  63      40.683  30.107  71.020  1.00 18.39           C  
ATOM   3309  C   HIS C  63      40.670  31.482  70.296  1.00 18.25           C  
ATOM   3310  O   HIS C  63      41.705  32.163  70.259  1.00 19.66           O  
ATOM   3311  CB  HIS C  63      41.678  29.183  70.311  1.00 19.61           C  
ATOM   3312  CG  HIS C  63      41.356  28.956  68.872  1.00 19.47           C  
ATOM   3313  ND1 HIS C  63      40.249  28.239  68.467  1.00 21.14           N  
ATOM   3314  CD2 HIS C  63      41.992  29.348  67.737  1.00 21.00           C  
ATOM   3315  CE1 HIS C  63      40.199  28.232  67.149  1.00 22.84           C  
ATOM   3316  NE2 HIS C  63      41.252  28.879  66.687  1.00 22.27           N  
ATOM   3317  N   ALA C  64      39.527  31.855  69.703  1.00 18.92           N  
ATOM   3318  CA  ALA C  64      39.485  32.900  68.655  1.00 18.11           C  
ATOM   3319  C   ALA C  64      38.378  33.921  68.877  1.00 18.03           C  
ATOM   3320  O   ALA C  64      38.150  34.770  68.013  1.00 21.32           O  
ATOM   3321  CB  ALA C  64      39.315  32.267  67.233  1.00 19.20           C  
ATOM   3322  N   SER C  65      37.633  33.776  69.939  1.00 16.71           N  
ATOM   3323  CA  SER C  65      36.627  34.721  70.255  1.00 17.95           C  
ATOM   3324  C   SER C  65      36.909  35.332  71.646  1.00 17.70           C  
ATOM   3325  O   SER C  65      37.653  34.757  72.443  1.00 17.27           O  
ATOM   3326  CB  SER C  65      35.220  34.090  70.195  1.00 16.77           C  
ATOM   3327  OG  SER C  65      34.999  33.128  71.244  1.00 15.66           O  
ATOM   3328  N   GLY C  66      36.279  36.481  71.911  1.00 18.31           N  
ATOM   3329  CA  GLY C  66      36.240  37.107  73.253  1.00 16.84           C  
ATOM   3330  C   GLY C  66      35.652  36.120  74.280  1.00 16.77           C  
ATOM   3331  O   GLY C  66      36.328  35.797  75.258  1.00 17.88           O  
ATOM   3332  N   ALA C  67      34.403  35.680  74.095  1.00 16.76           N  
ATOM   3333  CA  ALA C  67      33.784  34.771  75.091  1.00 17.28           C  
ATOM   3334  C   ALA C  67      34.688  33.519  75.234  1.00 18.44           C  
ATOM   3335  O   ALA C  67      34.960  33.045  76.365  1.00 16.14           O  
ATOM   3336  CB  ALA C  67      32.386  34.389  74.733  1.00 17.31           C  
ATOM   3337  N   GLY C  68      35.175  32.984  74.103  1.00 20.38           N  
ATOM   3338  CA  GLY C  68      35.958  31.720  74.128  1.00 16.81           C  
ATOM   3339  C   GLY C  68      37.203  31.849  74.972  1.00 18.36           C  
ATOM   3340  O   GLY C  68      37.413  31.072  75.892  1.00 16.38           O  
ATOM   3341  N   LYS C  69      38.013  32.881  74.673  1.00 17.02           N  
ATOM   3342  CA  LYS C  69      39.271  33.118  75.371  1.00 19.49           C  
ATOM   3343  C   LYS C  69      39.092  33.554  76.841  1.00 18.59           C  
ATOM   3344  O   LYS C  69      39.973  33.259  77.689  1.00 20.58           O  
ATOM   3345  CB  LYS C  69      40.131  34.134  74.605  1.00 19.01           C  
ATOM   3346  CG  LYS C  69      40.635  33.567  73.244  1.00 16.59           C  
ATOM   3347  CD  LYS C  69      41.732  34.373  72.604  1.00 19.01           C  
ATOM   3348  CE  LYS C  69      41.230  35.827  72.312  1.00 17.83           C  
ATOM   3349  NZ  LYS C  69      42.332  36.676  71.756  1.00 19.79           N  
ATOM   3350  N   ALA C  70      37.991  34.279  77.111  1.00 18.27           N  
ATOM   3351  CA  ALA C  70      37.640  34.636  78.517  1.00 18.15           C  
ATOM   3352  C   ALA C  70      37.571  33.362  79.371  1.00 19.15           C  
ATOM   3353  O   ALA C  70      38.279  33.212  80.382  1.00 20.71           O  
ATOM   3354  CB  ALA C  70      36.350  35.546  78.594  1.00 18.14           C  
ATOM   3355  N   PHE C  71      36.824  32.394  78.855  1.00 19.56           N  
ATOM   3356  CA  PHE C  71      36.663  31.100  79.480  1.00 19.99           C  
ATOM   3357  C   PHE C  71      37.994  30.366  79.466  1.00 19.98           C  
ATOM   3358  O   PHE C  71      38.432  29.858  80.500  1.00 21.24           O  
ATOM   3359  CB  PHE C  71      35.655  30.269  78.714  1.00 19.93           C  
ATOM   3360  CG  PHE C  71      34.236  30.459  79.135  1.00 19.45           C  
ATOM   3361  CD1 PHE C  71      33.783  30.002  80.373  1.00 19.66           C  
ATOM   3362  CD2 PHE C  71      33.298  30.963  78.225  1.00 21.57           C  
ATOM   3363  CE1 PHE C  71      32.444  30.119  80.737  1.00 26.60           C  
ATOM   3364  CE2 PHE C  71      31.915  31.105  78.621  1.00 21.63           C  
ATOM   3365  CZ  PHE C  71      31.514  30.678  79.858  1.00 18.40           C  
ATOM   3366  N   LEU C  72      38.665  30.313  78.324  1.00 20.82           N  
ATOM   3367  CA  LEU C  72      39.903  29.557  78.271  1.00 21.94           C  
ATOM   3368  C   LEU C  72      40.970  30.039  79.230  1.00 21.72           C  
ATOM   3369  O   LEU C  72      41.689  29.233  79.759  1.00 22.42           O  
ATOM   3370  CB  LEU C  72      40.424  29.465  76.826  1.00 22.81           C  
ATOM   3371  CG  LEU C  72      41.332  28.342  76.436  1.00 23.27           C  
ATOM   3372  CD1 LEU C  72      40.588  27.070  76.701  1.00 21.62           C  
ATOM   3373  CD2 LEU C  72      41.580  28.551  74.936  1.00 19.37           C  
ATOM   3374  N   ALA C  73      41.047  31.357  79.488  1.00 20.23           N  
ATOM   3375  CA  ALA C  73      42.053  31.892  80.401  1.00 22.44           C  
ATOM   3376  C   ALA C  73      41.806  31.443  81.847  1.00 21.33           C  
ATOM   3377  O   ALA C  73      42.717  31.524  82.679  1.00 25.32           O  
ATOM   3378  CB  ALA C  73      42.103  33.428  80.270  1.00 20.74           C  
ATOM   3379  N   GLN C  74      40.592  30.950  82.121  1.00 24.38           N  
ATOM   3380  CA  GLN C  74      40.067  30.604  83.488  1.00 24.46           C  
ATOM   3381  C   GLN C  74      39.744  29.145  83.765  1.00 27.25           C  
ATOM   3382  O   GLN C  74      39.347  28.772  84.902  1.00 25.27           O  
ATOM   3383  CB  GLN C  74      38.794  31.440  83.770  1.00 26.01           C  
ATOM   3384  CG  GLN C  74      38.988  32.936  83.579  1.00 26.19           C  
ATOM   3385  CD  GLN C  74      39.920  33.630  84.585  1.00 24.79           C  
ATOM   3386  OE1 GLN C  74      40.525  34.664  84.276  1.00 34.69           O  
ATOM   3387  NE2 GLN C  74      40.030  33.094  85.752  1.00 23.14           N  
ATOM   3388  N   LEU C  75      39.849  28.307  82.734  1.00 27.83           N  
ATOM   3389  CA  LEU C  75      39.604  26.871  82.911  1.00 28.29           C  
ATOM   3390  C   LEU C  75      40.903  26.163  83.334  1.00 29.35           C  
ATOM   3391  O   LEU C  75      42.036  26.705  83.189  1.00 28.65           O  
ATOM   3392  CB  LEU C  75      39.007  26.229  81.630  1.00 28.33           C  
ATOM   3393  CG  LEU C  75      37.617  26.787  81.181  1.00 27.71           C  
ATOM   3394  CD1 LEU C  75      37.388  26.451  79.694  1.00 30.76           C  
ATOM   3395  CD2 LEU C  75      36.486  26.210  82.072  1.00 26.74           C  
ATOM   3396  N   SER C  76      40.709  24.963  83.888  1.00 30.75           N  
ATOM   3397  CA  SER C  76      41.793  24.152  84.467  1.00 32.30           C  
ATOM   3398  C   SER C  76      42.787  23.803  83.350  1.00 33.11           C  
ATOM   3399  O   SER C  76      42.397  23.749  82.167  1.00 33.80           O  
ATOM   3400  CB  SER C  76      41.215  22.842  85.040  1.00 32.72           C  
ATOM   3401  OG  SER C  76      40.789  21.970  83.974  1.00 33.57           O  
ATOM   3402  N   GLU C  77      44.034  23.521  83.729  1.00 32.65           N  
ATOM   3403  CA  GLU C  77      45.041  23.175  82.761  1.00 34.71           C  
ATOM   3404  C   GLU C  77      44.523  21.979  81.974  1.00 34.35           C  
ATOM   3405  O   GLU C  77      44.779  21.874  80.769  1.00 35.02           O  
ATOM   3406  CB  GLU C  77      46.436  22.936  83.440  1.00 34.29           C  
ATOM   3407  CG  GLU C  77      47.496  22.150  82.629  1.00 37.43           C  
ATOM   3408  CD  GLU C  77      47.967  22.848  81.330  1.00 44.12           C  
ATOM   3409  OE1 GLU C  77      47.716  22.324  80.207  1.00 46.41           O  
ATOM   3410  OE2 GLU C  77      48.586  23.932  81.409  1.00 42.84           O  
ATOM   3411  N   GLU C  78      43.774  21.098  82.641  1.00 34.46           N  
ATOM   3412  CA  GLU C  78      43.317  19.846  81.994  1.00 36.03           C  
ATOM   3413  C   GLU C  78      42.243  20.078  80.910  1.00 35.12           C  
ATOM   3414  O   GLU C  78      42.202  19.404  79.865  1.00 35.26           O  
ATOM   3415  CB  GLU C  78      42.917  18.766  83.028  1.00 36.25           C  
ATOM   3416  CG  GLU C  78      41.870  17.781  82.586  1.00 41.11           C  
ATOM   3417  CD  GLU C  78      40.573  18.042  83.291  1.00 48.23           C  
ATOM   3418  OE1 GLU C  78      40.552  19.027  84.074  1.00 49.95           O  
ATOM   3419  OE2 GLU C  78      39.594  17.278  83.080  1.00 52.10           O  
ATOM   3420  N   GLN C  79      41.405  21.066  81.152  1.00 33.93           N  
ATOM   3421  CA  GLN C  79      40.430  21.483  80.157  1.00 33.40           C  
ATOM   3422  C   GLN C  79      41.120  22.209  78.969  1.00 31.28           C  
ATOM   3423  O   GLN C  79      40.793  21.960  77.819  1.00 29.84           O  
ATOM   3424  CB  GLN C  79      39.375  22.346  80.825  1.00 32.48           C  
ATOM   3425  CG  GLN C  79      38.527  21.625  81.872  1.00 35.27           C  
ATOM   3426  CD  GLN C  79      37.631  22.589  82.662  1.00 35.86           C  
ATOM   3427  OE1 GLN C  79      36.407  22.601  82.482  1.00 41.52           O  
ATOM   3428  NE2 GLN C  79      38.236  23.390  83.547  1.00 36.01           N  
ATOM   3429  N   VAL C  80      42.090  23.080  79.257  1.00 29.11           N  
ATOM   3430  CA  VAL C  80      42.840  23.785  78.216  1.00 29.22           C  
ATOM   3431  C   VAL C  80      43.577  22.822  77.323  1.00 28.93           C  
ATOM   3432  O   VAL C  80      43.530  22.952  76.097  1.00 28.55           O  
ATOM   3433  CB  VAL C  80      43.870  24.809  78.800  1.00 29.18           C  
ATOM   3434  CG1 VAL C  80      44.818  25.409  77.715  1.00 31.32           C  
ATOM   3435  CG2 VAL C  80      43.089  25.932  79.654  1.00 28.80           C  
ATOM   3436  N   THR C  81      44.240  21.862  77.945  1.00 27.73           N  
ATOM   3437  CA  THR C  81      44.983  20.829  77.212  1.00 28.11           C  
ATOM   3438  C   THR C  81      44.072  19.979  76.291  1.00 27.47           C  
ATOM   3439  O   THR C  81      44.410  19.702  75.115  1.00 24.04           O  
ATOM   3440  CB  THR C  81      45.730  19.950  78.224  1.00 28.69           C  
ATOM   3441  OG1 THR C  81      46.744  20.766  78.844  1.00 30.57           O  
ATOM   3442  CG2 THR C  81      46.362  18.695  77.527  1.00 28.30           C  
ATOM   3443  N   LYS C  82      42.942  19.553  76.862  1.00 27.57           N  
ATOM   3444  CA  LYS C  82      41.916  18.830  76.111  1.00 27.52           C  
ATOM   3445  C   LYS C  82      41.420  19.667  74.912  1.00 28.65           C  
ATOM   3446  O   LYS C  82      41.278  19.136  73.797  1.00 27.87           O  
ATOM   3447  CB  LYS C  82      40.781  18.433  77.049  1.00 28.14           C  
ATOM   3448  CG  LYS C  82      39.950  17.254  76.627  1.00 30.23           C  
ATOM   3449  CD  LYS C  82      38.972  16.948  77.787  1.00 30.78           C  
ATOM   3450  CE  LYS C  82      38.435  15.506  77.675  1.00 37.24           C  
ATOM   3451  NZ  LYS C  82      38.284  14.852  79.040  1.00 40.08           N  
ATOM   3452  N   LEU C  83      41.175  20.968  75.118  1.00 28.78           N  
ATOM   3453  CA  LEU C  83      40.812  21.837  73.975  1.00 28.68           C  
ATOM   3454  C   LEU C  83      41.917  21.738  72.921  1.00 29.07           C  
ATOM   3455  O   LEU C  83      41.658  21.478  71.745  1.00 28.65           O  
ATOM   3456  CB  LEU C  83      40.618  23.331  74.391  1.00 28.83           C  
ATOM   3457  CG  LEU C  83      40.658  24.354  73.193  1.00 29.23           C  
ATOM   3458  CD1 LEU C  83      39.426  24.848  72.785  1.00 14.27           C  
ATOM   3459  CD2 LEU C  83      41.622  25.522  73.358  1.00 34.98           C  
ATOM   3460  N   LEU C  84      43.150  21.994  73.354  1.00 26.99           N  
ATOM   3461  CA  LEU C  84      44.251  22.183  72.445  1.00 26.37           C  
ATOM   3462  C   LEU C  84      44.470  20.965  71.572  1.00 26.41           C  
ATOM   3463  O   LEU C  84      44.615  21.075  70.360  1.00 25.35           O  
ATOM   3464  CB  LEU C  84      45.491  22.381  73.251  1.00 27.58           C  
ATOM   3465  CG  LEU C  84      45.706  23.829  73.684  1.00 28.57           C  
ATOM   3466  CD1 LEU C  84      46.705  23.914  74.844  1.00 30.97           C  
ATOM   3467  CD2 LEU C  84      46.131  24.647  72.457  1.00 33.43           C  
ATOM   3468  N   HIS C  85      44.417  19.801  72.219  1.00 25.64           N  
ATOM   3469  CA  HIS C  85      44.765  18.587  71.557  1.00 26.26           C  
ATOM   3470  C   HIS C  85      43.609  17.950  70.858  1.00 25.79           C  
ATOM   3471  O   HIS C  85      43.822  17.381  69.817  1.00 26.91           O  
ATOM   3472  CB  HIS C  85      45.438  17.624  72.523  1.00 26.18           C  
ATOM   3473  CG  HIS C  85      46.778  18.090  72.997  1.00 27.88           C  
ATOM   3474  ND1 HIS C  85      47.303  17.715  74.219  1.00 29.77           N  
ATOM   3475  CD2 HIS C  85      47.718  18.873  72.403  1.00 27.53           C  
ATOM   3476  CE1 HIS C  85      48.491  18.274  74.368  1.00 31.91           C  
ATOM   3477  NE2 HIS C  85      48.772  18.966  73.276  1.00 29.95           N  
ATOM   3478  N   ARG C  86      42.398  18.049  71.417  1.00 25.79           N  
ATOM   3479  CA  ARG C  86      41.246  17.386  70.796  1.00 25.77           C  
ATOM   3480  C   ARG C  86      40.554  18.245  69.736  1.00 26.80           C  
ATOM   3481  O   ARG C  86      40.109  17.740  68.702  1.00 27.53           O  
ATOM   3482  CB  ARG C  86      40.244  16.859  71.832  1.00 25.55           C  
ATOM   3483  CG  ARG C  86      40.872  15.920  72.869  1.00 24.46           C  
ATOM   3484  CD  ARG C  86      39.820  15.070  73.517  1.00 26.43           C  
ATOM   3485  NE  ARG C  86      39.308  13.942  72.720  1.00 26.74           N  
ATOM   3486  CZ  ARG C  86      38.023  13.763  72.419  1.00 27.13           C  
ATOM   3487  NH1 ARG C  86      37.120  14.651  72.826  1.00 29.28           N  
ATOM   3488  NH2 ARG C  86      37.617  12.686  71.747  1.00 26.20           N  
ATOM   3489  N   LYS C  87      40.406  19.517  70.049  1.00 27.31           N  
ATOM   3490  CA  LYS C  87      39.590  20.405  69.225  1.00 28.70           C  
ATOM   3491  C   LYS C  87      40.506  21.062  68.170  1.00 27.89           C  
ATOM   3492  O   LYS C  87      40.143  21.152  66.988  1.00 28.94           O  
ATOM   3493  CB  LYS C  87      38.886  21.446  70.098  1.00 28.82           C  
ATOM   3494  CG  LYS C  87      37.896  22.348  69.307  1.00 29.54           C  
ATOM   3495  CD  LYS C  87      36.565  21.680  68.953  1.00 28.70           C  
ATOM   3496  CE  LYS C  87      35.604  22.735  68.268  1.00 30.58           C  
ATOM   3497  NZ  LYS C  87      34.554  22.156  67.372  1.00 32.49           N  
ATOM   3498  N   GLY C  88      41.691  21.510  68.585  1.00 27.03           N  
ATOM   3499  CA  GLY C  88      42.629  22.109  67.657  1.00 24.93           C  
ATOM   3500  C   GLY C  88      42.332  23.608  67.505  1.00 26.17           C  
ATOM   3501  O   GLY C  88      41.269  24.050  67.936  1.00 26.71           O  
ATOM   3502  N   LEU C  89      43.284  24.355  66.951  1.00 23.99           N  
ATOM   3503  CA  LEU C  89      43.188  25.844  66.738  1.00 25.14           C  
ATOM   3504  C   LEU C  89      42.936  26.310  65.247  1.00 23.83           C  
ATOM   3505  O   LEU C  89      43.844  26.730  64.527  1.00 23.22           O  
ATOM   3506  CB  LEU C  89      44.445  26.499  67.317  1.00 24.23           C  
ATOM   3507  CG  LEU C  89      44.890  26.092  68.733  1.00 27.25           C  
ATOM   3508  CD1 LEU C  89      46.152  26.789  69.096  1.00 25.35           C  
ATOM   3509  CD2 LEU C  89      43.799  26.406  69.729  1.00 28.48           C  
ATOM   3510  N   HIS C  90      41.698  26.234  64.796  1.00 24.30           N  
ATOM   3511  CA  HIS C  90      41.417  26.622  63.395  1.00 25.83           C  
ATOM   3512  C   HIS C  90      41.814  28.100  63.119  1.00 25.91           C  
ATOM   3513  O   HIS C  90      41.523  28.956  63.950  1.00 25.08           O  
ATOM   3514  CB  HIS C  90      39.952  26.393  63.069  1.00 25.72           C  
ATOM   3515  CG  HIS C  90      39.521  27.104  61.841  1.00 29.81           C  
ATOM   3516  ND1 HIS C  90      40.194  26.979  60.647  1.00 37.74           N  
ATOM   3517  CD2 HIS C  90      38.530  28.001  61.629  1.00 31.88           C  
ATOM   3518  CE1 HIS C  90      39.596  27.742  59.739  1.00 39.40           C  
ATOM   3519  NE2 HIS C  90      38.571  28.349  60.305  1.00 33.16           N  
ATOM   3520  N   ALA C  91      42.560  28.363  62.022  1.00 24.83           N  
ATOM   3521  CA  ALA C  91      42.867  29.752  61.575  1.00 27.09           C  
ATOM   3522  C   ALA C  91      41.694  30.400  60.863  1.00 27.43           C  
ATOM   3523  O   ALA C  91      41.481  30.142  59.655  1.00 27.88           O  
ATOM   3524  CB  ALA C  91      44.032  29.783  60.658  1.00 27.94           C  
ATOM   3525  N   TYR C  92      40.934  31.240  61.574  1.00 25.19           N  
ATOM   3526  CA  TYR C  92      39.877  32.031  60.899  1.00 24.78           C  
ATOM   3527  C   TYR C  92      40.470  33.127  59.983  1.00 24.37           C  
ATOM   3528  O   TYR C  92      40.000  33.363  58.882  1.00 24.39           O  
ATOM   3529  CB  TYR C  92      38.937  32.643  61.938  1.00 26.00           C  
ATOM   3530  CG  TYR C  92      38.131  31.574  62.656  1.00 25.36           C  
ATOM   3531  CD1 TYR C  92      36.937  31.120  62.107  1.00 26.60           C  
ATOM   3532  CD2 TYR C  92      38.575  31.022  63.885  1.00 26.40           C  
ATOM   3533  CE1 TYR C  92      36.193  30.114  62.739  1.00 27.73           C  
ATOM   3534  CE2 TYR C  92      37.833  30.029  64.554  1.00 26.12           C  
ATOM   3535  CZ  TYR C  92      36.653  29.569  63.956  1.00 27.02           C  
ATOM   3536  OH  TYR C  92      35.913  28.587  64.541  1.00 26.68           O  
ATOM   3537  N   THR C  93      41.486  33.784  60.491  1.00 22.71           N  
ATOM   3538  CA  THR C  93      42.050  34.944  59.865  1.00 24.95           C  
ATOM   3539  C   THR C  93      43.550  34.921  60.022  1.00 26.09           C  
ATOM   3540  O   THR C  93      44.109  34.117  60.764  1.00 24.58           O  
ATOM   3541  CB  THR C  93      41.453  36.282  60.554  1.00 22.70           C  
ATOM   3542  OG1 THR C  93      41.995  36.416  61.855  1.00 24.59           O  
ATOM   3543  CG2 THR C  93      39.918  36.265  60.607  1.00 24.07           C  
ATOM   3544  N   HIS C  94      44.227  35.854  59.349  1.00 27.44           N  
ATOM   3545  CA  HIS C  94      45.639  36.085  59.601  1.00 28.79           C  
ATOM   3546  C   HIS C  94      46.010  36.457  61.060  1.00 27.99           C  
ATOM   3547  O   HIS C  94      47.182  36.440  61.411  1.00 27.07           O  
ATOM   3548  CB  HIS C  94      46.095  37.209  58.645  1.00 31.20           C  
ATOM   3549  CG  HIS C  94      45.407  38.517  58.927  1.00 37.30           C  
ATOM   3550  ND1 HIS C  94      44.186  38.849  58.374  1.00 40.88           N  
ATOM   3551  CD2 HIS C  94      45.721  39.524  59.784  1.00 39.19           C  
ATOM   3552  CE1 HIS C  94      43.805  40.029  58.843  1.00 44.41           C  
ATOM   3553  NE2 HIS C  94      44.719  40.460  59.697  1.00 44.23           N  
ATOM   3554  N   ALA C  95      45.029  36.792  61.918  1.00 25.00           N  
ATOM   3555  CA  ALA C  95      45.277  37.211  63.315  1.00 25.23           C  
ATOM   3556  C   ALA C  95      45.009  36.133  64.343  1.00 22.32           C  
ATOM   3557  O   ALA C  95      45.463  36.239  65.474  1.00 23.49           O  
ATOM   3558  CB  ALA C  95      44.476  38.462  63.668  1.00 23.55           C  
ATOM   3559  N   THR C  96      44.323  35.077  63.911  1.00 23.52           N  
ATOM   3560  CA  THR C  96      43.978  33.945  64.804  1.00 23.80           C  
ATOM   3561  C   THR C  96      45.217  33.380  65.476  1.00 24.38           C  
ATOM   3562  O   THR C  96      46.243  33.152  64.822  1.00 25.79           O  
ATOM   3563  CB  THR C  96      43.237  32.808  64.046  1.00 22.08           C  
ATOM   3564  OG1 THR C  96      42.179  33.377  63.268  1.00 21.42           O  
ATOM   3565  CG2 THR C  96      42.633  31.832  65.069  1.00 24.11           C  
ATOM   3566  N   LEU C  97      45.141  33.220  66.783  1.00 24.17           N  
ATOM   3567  CA  LEU C  97      46.224  32.640  67.565  1.00 25.51           C  
ATOM   3568  C   LEU C  97      46.186  31.133  67.329  1.00 26.57           C  
ATOM   3569  O   LEU C  97      45.343  30.424  67.853  1.00 28.10           O  
ATOM   3570  CB  LEU C  97      46.140  33.034  69.038  1.00 25.24           C  
ATOM   3571  CG  LEU C  97      46.054  34.555  69.209  1.00 24.24           C  
ATOM   3572  CD1 LEU C  97      45.594  34.778  70.649  1.00 28.36           C  
ATOM   3573  CD2 LEU C  97      47.346  35.257  68.867  1.00 27.75           C  
ATOM   3574  N   VAL C  98      47.088  30.672  66.470  1.00 26.77           N  
ATOM   3575  CA  VAL C  98      47.105  29.244  66.054  1.00 28.46           C  
ATOM   3576  C   VAL C  98      48.272  28.470  66.645  1.00 30.24           C  
ATOM   3577  O   VAL C  98      48.345  27.242  66.504  1.00 30.59           O  
ATOM   3578  CB  VAL C  98      47.091  29.081  64.506  1.00 28.76           C  
ATOM   3579  CG1 VAL C  98      45.845  29.696  63.929  1.00 28.20           C  
ATOM   3580  CG2 VAL C  98      48.361  29.641  63.845  1.00 27.51           C  
ATOM   3581  N   SER C  99      49.192  29.207  67.250  1.00 30.96           N  
ATOM   3582  CA  SER C  99      50.344  28.656  67.957  1.00 33.61           C  
ATOM   3583  C   SER C  99      50.037  28.549  69.443  1.00 34.34           C  
ATOM   3584  O   SER C  99      49.609  29.552  70.051  1.00 33.75           O  
ATOM   3585  CB  SER C  99      51.551  29.566  67.736  1.00 33.84           C  
ATOM   3586  OG  SER C  99      52.236  29.739  68.946  1.00 35.14           O  
ATOM   3587  N   PRO C 100      50.199  27.335  70.037  1.00 35.37           N  
ATOM   3588  CA  PRO C 100      49.927  27.159  71.466  1.00 34.81           C  
ATOM   3589  C   PRO C 100      50.667  28.179  72.338  1.00 35.02           C  
ATOM   3590  O   PRO C 100      50.104  28.637  73.341  1.00 33.89           O  
ATOM   3591  CB  PRO C 100      50.407  25.720  71.754  1.00 35.25           C  
ATOM   3592  CG  PRO C 100      50.294  25.021  70.435  1.00 35.90           C  
ATOM   3593  CD  PRO C 100      50.589  26.056  69.401  1.00 34.71           C  
ATOM   3594  N   VAL C 101      51.889  28.531  71.955  1.00 34.20           N  
ATOM   3595  CA  VAL C 101      52.644  29.536  72.689  1.00 34.56           C  
ATOM   3596  C   VAL C 101      52.049  30.953  72.624  1.00 34.27           C  
ATOM   3597  O   VAL C 101      51.909  31.578  73.680  1.00 33.81           O  
ATOM   3598  CB  VAL C 101      54.215  29.435  72.505  1.00 34.87           C  
ATOM   3599  CG1 VAL C 101      54.888  30.748  72.124  1.00 33.77           C  
ATOM   3600  CG2 VAL C 101      54.817  28.904  73.815  1.00 36.62           C  
ATOM   3601  N   HIS C 102      51.668  31.441  71.440  1.00 33.85           N  
ATOM   3602  CA  HIS C 102      51.084  32.794  71.395  1.00 33.93           C  
ATOM   3603  C   HIS C 102      49.695  32.822  72.083  1.00 31.93           C  
ATOM   3604  O   HIS C 102      49.353  33.826  72.706  1.00 31.38           O  
ATOM   3605  CB  HIS C 102      51.022  33.375  69.981  1.00 34.87           C  
ATOM   3606  CG  HIS C 102      52.336  33.409  69.266  1.00 39.18           C  
ATOM   3607  ND1 HIS C 102      53.516  33.791  69.878  1.00 42.04           N  
ATOM   3608  CD2 HIS C 102      52.653  33.123  67.980  1.00 42.87           C  
ATOM   3609  CE1 HIS C 102      54.501  33.733  68.998  1.00 44.90           C  
ATOM   3610  NE2 HIS C 102      54.006  33.336  67.837  1.00 43.86           N  
ATOM   3611  N   LEU C 103      48.943  31.714  71.996  1.00 30.09           N  
ATOM   3612  CA  LEU C 103      47.631  31.559  72.649  1.00 29.26           C  
ATOM   3613  C   LEU C 103      47.796  31.587  74.156  1.00 30.00           C  
ATOM   3614  O   LEU C 103      47.091  32.328  74.871  1.00 28.95           O  
ATOM   3615  CB  LEU C 103      46.896  30.257  72.231  1.00 27.94           C  
ATOM   3616  CG  LEU C 103      45.501  30.027  72.832  1.00 28.91           C  
ATOM   3617  CD1 LEU C 103      44.523  31.254  72.566  1.00 27.39           C  
ATOM   3618  CD2 LEU C 103      44.870  28.718  72.338  1.00 27.20           C  
ATOM   3619  N   LYS C 104      48.749  30.785  74.645  1.00 30.05           N  
ATOM   3620  CA  LYS C 104      48.929  30.675  76.091  1.00 30.18           C  
ATOM   3621  C   LYS C 104      49.299  32.057  76.673  1.00 29.23           C  
ATOM   3622  O   LYS C 104      48.759  32.467  77.691  1.00 29.67           O  
ATOM   3623  CB  LYS C 104      49.892  29.541  76.480  1.00 30.11           C  
ATOM   3624  CG  LYS C 104      49.212  28.157  76.414  1.00 31.44           C  
ATOM   3625  CD  LYS C 104      50.200  26.925  76.398  1.00 33.28           C  
ATOM   3626  CE  LYS C 104      51.582  27.182  75.627  1.00 38.60           C  
ATOM   3627  NZ  LYS C 104      52.420  25.886  75.279  1.00 35.37           N  
ATOM   3628  N   GLU C 105      50.129  32.802  75.961  1.00 29.56           N  
ATOM   3629  CA  GLU C 105      50.537  34.118  76.397  1.00 29.37           C  
ATOM   3630  C   GLU C 105      49.380  35.127  76.380  1.00 28.65           C  
ATOM   3631  O   GLU C 105      49.244  35.908  77.333  1.00 27.04           O  
ATOM   3632  CB  GLU C 105      51.611  34.651  75.458  1.00 29.96           C  
ATOM   3633  CG  GLU C 105      51.956  36.185  75.588  1.00 36.11           C  
ATOM   3634  CD  GLU C 105      52.417  36.652  76.991  1.00 41.89           C  
ATOM   3635  OE1 GLU C 105      52.877  37.817  77.086  1.00 47.34           O  
ATOM   3636  OE2 GLU C 105      52.306  35.904  78.004  1.00 45.38           O  
ATOM   3637  N   ASP C 106      48.606  35.147  75.271  1.00 26.36           N  
ATOM   3638  CA  ASP C 106      47.386  35.973  75.178  1.00 24.43           C  
ATOM   3639  C   ASP C 106      46.501  35.630  76.380  1.00 24.43           C  
ATOM   3640  O   ASP C 106      45.896  36.552  76.950  1.00 24.02           O  
ATOM   3641  CB  ASP C 106      46.638  35.707  73.875  1.00 22.95           C  
ATOM   3642  CG  ASP C 106      45.457  36.692  73.643  1.00 25.35           C  
ATOM   3643  OD1 ASP C 106      45.712  37.855  73.299  1.00 28.80           O  
ATOM   3644  OD2 ASP C 106      44.308  36.314  73.882  1.00 20.08           O  
ATOM   3645  N   LEU C 107      46.402  34.329  76.767  1.00 22.69           N  
ATOM   3646  CA  LEU C 107      45.600  33.935  77.937  1.00 25.07           C  
ATOM   3647  C   LEU C 107      46.140  34.471  79.275  1.00 26.21           C  
ATOM   3648  O   LEU C 107      45.373  34.848  80.193  1.00 26.66           O  
ATOM   3649  CB  LEU C 107      45.360  32.426  77.980  1.00 24.34           C  
ATOM   3650  CG  LEU C 107      44.744  31.836  76.695  1.00 26.15           C  
ATOM   3651  CD1 LEU C 107      44.508  30.353  76.848  1.00 23.05           C  
ATOM   3652  CD2 LEU C 107      43.455  32.528  76.256  1.00 27.85           C  
ATOM   3653  N   ALA C 108      47.464  34.475  79.396  1.00 28.75           N  
ATOM   3654  CA  ALA C 108      48.138  35.072  80.577  1.00 28.24           C  
ATOM   3655  C   ALA C 108      47.886  36.591  80.665  1.00 29.25           C  
ATOM   3656  O   ALA C 108      47.556  37.077  81.756  1.00 30.93           O  
ATOM   3657  CB  ALA C 108      49.631  34.761  80.519  1.00 28.56           C  
ATOM   3658  N   GLN C 109      48.041  37.320  79.550  1.00 27.85           N  
ATOM   3659  CA  GLN C 109      47.653  38.765  79.452  1.00 29.18           C  
ATOM   3660  C   GLN C 109      46.171  38.988  79.855  1.00 27.56           C  
ATOM   3661  O   GLN C 109      45.850  39.907  80.623  1.00 28.66           O  
ATOM   3662  CB  GLN C 109      47.954  39.351  78.060  1.00 29.52           C  
ATOM   3663  CG  GLN C 109      49.485  39.492  77.770  1.00 33.89           C  
ATOM   3664  CD  GLN C 109      50.222  40.231  78.923  1.00 40.38           C  
ATOM   3665  OE1 GLN C 109      49.895  41.386  79.255  1.00 42.23           O  
ATOM   3666  NE2 GLN C 109      51.221  39.557  79.532  1.00 39.61           N  
ATOM   3667  N   THR C 110      45.278  38.177  79.298  1.00 25.53           N  
ATOM   3668  CA  THR C 110      43.827  38.174  79.677  1.00 23.18           C  
ATOM   3669  C   THR C 110      43.568  38.112  81.189  1.00 24.52           C  
ATOM   3670  O   THR C 110      42.853  38.936  81.745  1.00 25.64           O  
ATOM   3671  CB  THR C 110      43.118  36.986  78.953  1.00 22.11           C  
ATOM   3672  OG1 THR C 110      43.278  37.166  77.554  1.00 20.01           O  
ATOM   3673  CG2 THR C 110      41.650  36.913  79.318  1.00 18.93           C  
ATOM   3674  N   ARG C 111      44.146  37.126  81.875  1.00 25.21           N  
ATOM   3675  CA  ARG C 111      44.021  36.982  83.331  1.00 26.67           C  
ATOM   3676  C   ARG C 111      44.492  38.256  84.066  1.00 27.66           C  
ATOM   3677  O   ARG C 111      43.822  38.734  85.018  1.00 28.72           O  
ATOM   3678  CB  ARG C 111      44.844  35.765  83.810  1.00 26.74           C  
ATOM   3679  CG  ARG C 111      44.102  34.471  83.624  1.00 24.98           C  
ATOM   3680  CD  ARG C 111      44.762  33.331  84.394  1.00 32.81           C  
ATOM   3681  NE  ARG C 111      46.106  33.070  83.885  1.00 34.57           N  
ATOM   3682  CZ  ARG C 111      46.365  32.245  82.873  1.00 35.28           C  
ATOM   3683  NH1 ARG C 111      45.365  31.623  82.235  1.00 34.35           N  
ATOM   3684  NH2 ARG C 111      47.610  32.081  82.478  1.00 32.02           N  
ATOM   3685  N   LYS C 112      45.593  38.809  83.578  1.00 27.99           N  
ATOM   3686  CA  LYS C 112      46.263  39.968  84.196  1.00 31.22           C  
ATOM   3687  C   LYS C 112      45.437  41.246  84.109  1.00 30.36           C  
ATOM   3688  O   LYS C 112      45.291  41.972  85.103  1.00 31.40           O  
ATOM   3689  CB  LYS C 112      47.630  40.240  83.526  1.00 30.32           C  
ATOM   3690  CG  LYS C 112      48.756  39.383  83.987  1.00 34.72           C  
ATOM   3691  CD  LYS C 112      50.090  39.710  83.249  1.00 35.72           C  
ATOM   3692  CE  LYS C 112      51.271  38.874  83.826  1.00 37.81           C  
ATOM   3693  NZ  LYS C 112      52.537  39.641  84.192  1.00 34.56           N  
ATOM   3694  N   ARG C 113      44.974  41.567  82.902  1.00 30.10           N  
ATOM   3695  CA  ARG C 113      44.152  42.765  82.667  1.00 27.76           C  
ATOM   3696  C   ARG C 113      42.647  42.570  83.066  1.00 28.09           C  
ATOM   3697  O   ARG C 113      41.931  43.563  83.259  1.00 28.30           O  
ATOM   3698  CB  ARG C 113      44.363  43.267  81.219  1.00 28.53           C  
ATOM   3699  CG  ARG C 113      43.610  42.455  80.149  1.00 28.57           C  
ATOM   3700  CD  ARG C 113      44.148  42.630  78.749  1.00 28.99           C  
ATOM   3701  NE  ARG C 113      43.641  41.549  77.913  1.00 26.87           N  
ATOM   3702  CZ  ARG C 113      44.156  41.182  76.752  1.00 29.42           C  
ATOM   3703  NH1 ARG C 113      45.198  41.844  76.228  1.00 31.76           N  
ATOM   3704  NH2 ARG C 113      43.632  40.137  76.107  1.00 27.72           N  
ATOM   3705  N   GLY C 114      42.159  41.321  83.148  1.00 25.19           N  
ATOM   3706  CA  GLY C 114      40.779  41.049  83.639  1.00 22.21           C  
ATOM   3707  C   GLY C 114      39.719  40.911  82.531  1.00 19.51           C  
ATOM   3708  O   GLY C 114      38.498  40.829  82.778  1.00 18.65           O  
ATOM   3709  N   TYR C 115      40.186  40.922  81.297  1.00 18.37           N  
ATOM   3710  CA  TYR C 115      39.283  40.756  80.150  1.00 17.58           C  
ATOM   3711  C   TYR C 115      40.035  40.169  78.966  1.00 17.96           C  
ATOM   3712  O   TYR C 115      41.215  40.464  78.762  1.00 18.70           O  
ATOM   3713  CB  TYR C 115      38.637  42.115  79.706  1.00 17.27           C  
ATOM   3714  CG  TYR C 115      39.651  43.160  79.243  1.00 19.21           C  
ATOM   3715  CD1 TYR C 115      40.022  43.252  77.906  1.00 19.29           C  
ATOM   3716  CD2 TYR C 115      40.226  44.091  80.176  1.00 19.08           C  
ATOM   3717  CE1 TYR C 115      40.992  44.234  77.474  1.00 21.74           C  
ATOM   3718  CE2 TYR C 115      41.151  45.087  79.768  1.00 22.84           C  
ATOM   3719  CZ  TYR C 115      41.531  45.134  78.429  1.00 19.34           C  
ATOM   3720  OH  TYR C 115      42.445  46.082  78.068  1.00 22.72           O  
ATOM   3721  N   SER C 116      39.317  39.379  78.155  1.00 17.19           N  
ATOM   3722  CA  SER C 116      39.833  38.936  76.858  1.00 18.41           C  
ATOM   3723  C   SER C 116      39.526  39.968  75.764  1.00 18.35           C  
ATOM   3724  O   SER C 116      38.589  40.819  75.913  1.00 18.79           O  
ATOM   3725  CB  SER C 116      39.168  37.598  76.489  1.00 18.24           C  
ATOM   3726  OG  SER C 116      37.770  37.764  76.294  1.00 15.58           O  
ATOM   3727  N   PHE C 117      40.239  39.856  74.644  1.00 18.25           N  
ATOM   3728  CA  PHE C 117      40.156  40.752  73.502  1.00 18.19           C  
ATOM   3729  C   PHE C 117      40.419  39.933  72.232  1.00 18.38           C  
ATOM   3730  O   PHE C 117      41.510  39.422  72.027  1.00 16.71           O  
ATOM   3731  CB  PHE C 117      41.144  41.921  73.667  1.00 18.99           C  
ATOM   3732  CG  PHE C 117      41.238  42.889  72.479  1.00 17.63           C  
ATOM   3733  CD1 PHE C 117      40.131  43.255  71.702  1.00 17.42           C  
ATOM   3734  CD2 PHE C 117      42.464  43.505  72.173  1.00 21.29           C  
ATOM   3735  CE1 PHE C 117      40.237  44.226  70.586  1.00 18.79           C  
ATOM   3736  CE2 PHE C 117      42.565  44.430  71.056  1.00 21.16           C  
ATOM   3737  CZ  PHE C 117      41.418  44.813  70.301  1.00 16.94           C  
ATOM   3738  N   ASP C 118      39.347  39.730  71.476  1.00 16.87           N  
ATOM   3739  CA  ASP C 118      39.397  39.205  70.123  1.00 17.26           C  
ATOM   3740  C   ASP C 118      39.574  40.368  69.201  1.00 17.69           C  
ATOM   3741  O   ASP C 118      38.694  41.265  69.050  1.00 15.98           O  
ATOM   3742  CB  ASP C 118      38.119  38.384  69.843  1.00 18.19           C  
ATOM   3743  CG  ASP C 118      37.870  38.159  68.383  1.00 17.35           C  
ATOM   3744  OD1 ASP C 118      38.858  38.276  67.594  1.00 17.46           O  
ATOM   3745  OD2 ASP C 118      36.660  37.963  68.017  1.00 17.71           O  
ATOM   3746  N   ASP C 119      40.770  40.413  68.650  1.00 17.47           N  
ATOM   3747  CA  ASP C 119      41.102  41.461  67.708  1.00 19.05           C  
ATOM   3748  C   ASP C 119      41.134  40.971  66.239  1.00 19.08           C  
ATOM   3749  O   ASP C 119      42.214  40.694  65.628  1.00 20.74           O  
ATOM   3750  CB  ASP C 119      42.423  42.142  68.146  1.00 19.57           C  
ATOM   3751  CG  ASP C 119      42.697  43.406  67.339  1.00 20.99           C  
ATOM   3752  OD1 ASP C 119      41.913  43.735  66.417  1.00 24.55           O  
ATOM   3753  OD2 ASP C 119      43.716  44.069  67.698  1.00 25.43           O  
ATOM   3754  N   GLU C 120      39.959  40.873  65.611  1.00 17.20           N  
ATOM   3755  CA  GLU C 120      39.802  40.282  64.270  1.00 17.76           C  
ATOM   3756  C   GLU C 120      40.372  38.828  64.132  1.00 17.29           C  
ATOM   3757  O   GLU C 120      40.907  38.464  63.086  1.00 18.08           O  
ATOM   3758  CB  GLU C 120      40.386  41.175  63.162  1.00 18.90           C  
ATOM   3759  CG  GLU C 120      39.927  42.688  63.136  1.00 22.25           C  
ATOM   3760  CD  GLU C 120      40.398  43.366  61.872  1.00 19.97           C  
ATOM   3761  OE1 GLU C 120      39.865  43.052  60.799  1.00 22.04           O  
ATOM   3762  OE2 GLU C 120      41.412  44.114  61.959  1.00 27.92           O  
ATOM   3763  N   GLU C 121      40.258  38.060  65.204  1.00 17.49           N  
ATOM   3764  CA  GLU C 121      40.773  36.661  65.252  1.00 18.37           C  
ATOM   3765  C   GLU C 121      39.704  35.671  64.815  1.00 18.80           C  
ATOM   3766  O   GLU C 121      40.027  34.536  64.407  1.00 19.39           O  
ATOM   3767  CB  GLU C 121      41.184  36.381  66.668  1.00 17.92           C  
ATOM   3768  CG  GLU C 121      42.492  37.112  67.063  1.00 19.06           C  
ATOM   3769  CD  GLU C 121      42.700  37.240  68.508  1.00 21.58           C  
ATOM   3770  OE1 GLU C 121      42.803  38.406  69.011  1.00 21.33           O  
ATOM   3771  OE2 GLU C 121      42.805  36.206  69.187  1.00 22.33           O  
ATOM   3772  N   HIS C 122      38.441  36.084  64.924  1.00 18.72           N  
ATOM   3773  CA  HIS C 122      37.290  35.246  64.523  1.00 19.46           C  
ATOM   3774  C   HIS C 122      36.790  35.656  63.173  1.00 18.71           C  
ATOM   3775  O   HIS C 122      36.501  34.822  62.343  1.00 20.21           O  
ATOM   3776  CB  HIS C 122      36.163  35.236  65.613  1.00 18.18           C  
ATOM   3777  CG  HIS C 122      35.107  34.187  65.415  1.00 22.23           C  
ATOM   3778  ND1 HIS C 122      35.257  33.139  64.530  1.00 27.45           N  
ATOM   3779  CD2 HIS C 122      33.923  33.974  66.048  1.00 22.11           C  
ATOM   3780  CE1 HIS C 122      34.180  32.370  64.575  1.00 26.39           C  
ATOM   3781  NE2 HIS C 122      33.363  32.848  65.492  1.00 22.12           N  
ATOM   3782  N   ALA C 123      36.758  36.962  62.894  1.00 17.73           N  
ATOM   3783  CA  ALA C 123      36.200  37.416  61.624  1.00 17.66           C  
ATOM   3784  C   ALA C 123      36.814  38.755  61.290  1.00 18.68           C  
ATOM   3785  O   ALA C 123      37.108  39.553  62.223  1.00 17.65           O  
ATOM   3786  CB  ALA C 123      34.623  37.522  61.688  1.00 17.31           C  
ATOM   3787  N   LEU C 124      37.081  38.968  60.002  1.00 18.80           N  
ATOM   3788  CA  LEU C 124      37.722  40.254  59.579  1.00 20.01           C  
ATOM   3789  C   LEU C 124      36.798  41.399  59.948  1.00 17.61           C  
ATOM   3790  O   LEU C 124      35.618  41.336  59.657  1.00 19.91           O  
ATOM   3791  CB  LEU C 124      37.915  40.307  58.075  1.00 20.33           C  
ATOM   3792  CG  LEU C 124      38.826  39.218  57.533  1.00 25.84           C  
ATOM   3793  CD1 LEU C 124      38.873  39.338  56.004  1.00 31.29           C  
ATOM   3794  CD2 LEU C 124      40.203  39.333  58.218  1.00 25.88           C  
ATOM   3795  N   GLY C 125      37.346  42.437  60.578  1.00 19.53           N  
ATOM   3796  CA  GLY C 125      36.554  43.605  60.966  1.00 19.90           C  
ATOM   3797  C   GLY C 125      35.754  43.515  62.283  1.00 19.82           C  
ATOM   3798  O   GLY C 125      35.161  44.486  62.725  1.00 20.55           O  
ATOM   3799  N   LEU C 126      35.769  42.338  62.919  1.00 18.57           N  
ATOM   3800  CA  LEU C 126      35.098  42.116  64.211  1.00 17.00           C  
ATOM   3801  C   LEU C 126      36.089  42.124  65.381  1.00 16.53           C  
ATOM   3802  O   LEU C 126      37.122  41.466  65.369  1.00 16.54           O  
ATOM   3803  CB  LEU C 126      34.332  40.767  64.192  1.00 17.42           C  
ATOM   3804  CG  LEU C 126      33.575  40.435  65.494  1.00 16.77           C  
ATOM   3805  CD1 LEU C 126      32.368  41.355  65.825  1.00 19.34           C  
ATOM   3806  CD2 LEU C 126      33.088  39.003  65.341  1.00 20.71           C  
ATOM   3807  N   ARG C 127      35.734  42.885  66.405  1.00 15.77           N  
ATOM   3808  CA  ARG C 127      36.383  42.864  67.668  1.00 16.53           C  
ATOM   3809  C   ARG C 127      35.388  42.510  68.766  1.00 15.43           C  
ATOM   3810  O   ARG C 127      34.237  42.920  68.736  1.00 14.61           O  
ATOM   3811  CB  ARG C 127      36.983  44.255  67.955  1.00 15.49           C  
ATOM   3812  CG  ARG C 127      38.315  44.436  67.308  1.00 16.82           C  
ATOM   3813  CD  ARG C 127      38.866  45.865  67.444  1.00 18.87           C  
ATOM   3814  NE  ARG C 127      40.314  45.897  67.201  1.00 22.24           N  
ATOM   3815  CZ  ARG C 127      41.107  46.956  67.427  1.00 26.21           C  
ATOM   3816  NH1 ARG C 127      40.596  48.107  67.920  1.00 21.11           N  
ATOM   3817  NH2 ARG C 127      42.412  46.869  67.154  1.00 24.14           N  
ATOM   3818  N   CYS C 128      35.858  41.817  69.785  1.00 17.28           N  
ATOM   3819  CA  CYS C 128      35.097  41.528  70.988  1.00 17.65           C  
ATOM   3820  C   CYS C 128      35.970  41.575  72.220  1.00 16.83           C  
ATOM   3821  O   CYS C 128      37.179  41.230  72.174  1.00 17.75           O  
ATOM   3822  CB  CYS C 128      34.499  40.121  70.934  1.00 17.54           C  
ATOM   3823  SG  CYS C 128      33.646  39.754  69.410  1.00 21.56           S  
ATOM   3824  N   LEU C 129      35.354  42.031  73.300  1.00 16.09           N  
ATOM   3825  CA  LEU C 129      35.931  42.055  74.668  1.00 17.29           C  
ATOM   3826  C   LEU C 129      35.028  41.229  75.587  1.00 17.01           C  
ATOM   3827  O   LEU C 129      33.805  41.367  75.544  1.00 16.10           O  
ATOM   3828  CB  LEU C 129      36.017  43.492  75.203  1.00 16.37           C  
ATOM   3829  CG  LEU C 129      37.195  44.218  74.524  1.00 20.86           C  
ATOM   3830  CD1 LEU C 129      36.710  44.876  73.280  1.00 20.73           C  
ATOM   3831  CD2 LEU C 129      37.644  45.184  75.511  1.00 24.99           C  
ATOM   3832  N   ALA C 130      35.593  40.460  76.500  1.00 17.40           N  
ATOM   3833  CA  ALA C 130      34.796  39.668  77.379  1.00 16.58           C  
ATOM   3834  C   ALA C 130      35.390  39.452  78.776  1.00 16.41           C  
ATOM   3835  O   ALA C 130      36.608  39.520  78.948  1.00 16.48           O  
ATOM   3836  CB  ALA C 130      34.500  38.282  76.727  1.00 16.53           C  
ATOM   3837  N   ALA C 131      34.524  39.101  79.708  1.00 17.57           N  
ATOM   3838  CA  ALA C 131      34.972  38.676  81.042  1.00 17.91           C  
ATOM   3839  C   ALA C 131      34.083  37.558  81.575  1.00 17.58           C  
ATOM   3840  O   ALA C 131      32.911  37.490  81.207  1.00 18.17           O  
ATOM   3841  CB  ALA C 131      34.947  39.904  82.030  1.00 18.85           C  
ATOM   3842  N   CYS C 132      34.630  36.714  82.464  1.00 17.39           N  
ATOM   3843  CA  CYS C 132      33.874  35.580  83.025  1.00 18.30           C  
ATOM   3844  C   CYS C 132      33.030  35.932  84.258  1.00 18.68           C  
ATOM   3845  O   CYS C 132      33.320  36.898  85.000  1.00 20.53           O  
ATOM   3846  CB  CYS C 132      34.744  34.376  83.364  1.00 20.26           C  
ATOM   3847  SG  CYS C 132      35.326  33.531  81.864  1.00 24.21           S  
ATOM   3848  N   ILE C 133      32.032  35.096  84.478  1.00 18.51           N  
ATOM   3849  CA  ILE C 133      31.176  35.125  85.645  1.00 17.99           C  
ATOM   3850  C   ILE C 133      31.585  33.904  86.451  1.00 20.49           C  
ATOM   3851  O   ILE C 133      31.635  32.784  85.874  1.00 18.57           O  
ATOM   3852  CB  ILE C 133      29.675  35.014  85.265  1.00 18.92           C  
ATOM   3853  CG1 ILE C 133      29.158  36.119  84.316  1.00 22.55           C  
ATOM   3854  CG2 ILE C 133      28.761  35.000  86.472  1.00 17.33           C  
ATOM   3855  CD1 ILE C 133      30.019  37.259  84.209  1.00 23.02           C  
ATOM   3856  N   PHE C 134      31.803  34.098  87.760  1.00 17.89           N  
ATOM   3857  CA  PHE C 134      32.352  33.042  88.653  1.00 18.88           C  
ATOM   3858  C   PHE C 134      31.423  32.567  89.705  1.00 18.33           C  
ATOM   3859  O   PHE C 134      30.720  33.363  90.297  1.00 19.14           O  
ATOM   3860  CB  PHE C 134      33.650  33.483  89.312  1.00 17.19           C  
ATOM   3861  CG  PHE C 134      34.753  33.699  88.363  1.00 19.66           C  
ATOM   3862  CD1 PHE C 134      34.929  34.968  87.747  1.00 18.56           C  
ATOM   3863  CD2 PHE C 134      35.638  32.657  88.043  1.00 19.34           C  
ATOM   3864  CE1 PHE C 134      35.940  35.183  86.891  1.00 17.14           C  
ATOM   3865  CE2 PHE C 134      36.663  32.862  87.206  1.00 17.26           C  
ATOM   3866  CZ  PHE C 134      36.846  34.151  86.582  1.00 21.47           C  
ATOM   3867  N   ASP C 135      31.442  31.261  89.978  1.00 18.36           N  
ATOM   3868  CA  ASP C 135      30.663  30.744  91.074  1.00 20.17           C  
ATOM   3869  C   ASP C 135      31.489  30.654  92.425  1.00 20.28           C  
ATOM   3870  O   ASP C 135      32.617  31.107  92.486  1.00 22.08           O  
ATOM   3871  CB  ASP C 135      30.043  29.412  90.672  1.00 20.88           C  
ATOM   3872  CG  ASP C 135      31.085  28.265  90.560  1.00 21.03           C  
ATOM   3873  OD1 ASP C 135      30.646  27.136  90.206  1.00 27.72           O  
ATOM   3874  OD2 ASP C 135      32.282  28.405  90.904  1.00 18.54           O  
ATOM   3875  N   GLU C 136      30.890  30.036  93.450  1.00 21.45           N  
ATOM   3876  CA  GLU C 136      31.456  29.886  94.780  1.00 23.09           C  
ATOM   3877  C   GLU C 136      32.718  28.997  94.822  1.00 23.59           C  
ATOM   3878  O   GLU C 136      33.446  29.032  95.796  1.00 23.30           O  
ATOM   3879  CB  GLU C 136      30.399  29.330  95.736  1.00 23.93           C  
ATOM   3880  CG  GLU C 136      30.063  27.869  95.484  1.00 25.03           C  
ATOM   3881  CD  GLU C 136      28.935  27.633  94.466  1.00 27.94           C  
ATOM   3882  OE1 GLU C 136      28.325  26.560  94.554  1.00 29.92           O  
ATOM   3883  OE2 GLU C 136      28.614  28.488  93.594  1.00 25.18           O  
ATOM   3884  N   HIS C 137      32.927  28.209  93.755  1.00 23.00           N  
ATOM   3885  CA  HIS C 137      34.140  27.400  93.508  1.00 24.60           C  
ATOM   3886  C   HIS C 137      35.210  28.169  92.719  1.00 23.71           C  
ATOM   3887  O   HIS C 137      36.259  27.616  92.374  1.00 24.32           O  
ATOM   3888  CB  HIS C 137      33.769  26.109  92.770  1.00 25.12           C  
ATOM   3889  CG  HIS C 137      32.694  25.321  93.443  1.00 29.25           C  
ATOM   3890  ND1 HIS C 137      32.842  24.787  94.707  1.00 32.26           N  
ATOM   3891  CD2 HIS C 137      31.446  24.989  93.038  1.00 32.86           C  
ATOM   3892  CE1 HIS C 137      31.737  24.152  95.046  1.00 34.63           C  
ATOM   3893  NE2 HIS C 137      30.870  24.270  94.056  1.00 37.15           N  
ATOM   3894  N   ARG C 138      34.938  29.450  92.414  1.00 22.84           N  
ATOM   3895  CA  ARG C 138      35.791  30.249  91.513  1.00 23.80           C  
ATOM   3896  C   ARG C 138      35.955  29.630  90.133  1.00 23.40           C  
ATOM   3897  O   ARG C 138      37.005  29.749  89.503  1.00 24.37           O  
ATOM   3898  CB  ARG C 138      37.149  30.586  92.125  1.00 25.44           C  
ATOM   3899  CG  ARG C 138      37.078  31.495  93.308  1.00 32.36           C  
ATOM   3900  CD  ARG C 138      36.988  30.619  94.545  1.00 38.69           C  
ATOM   3901  NE  ARG C 138      38.293  30.198  95.057  1.00 45.75           N  
ATOM   3902  CZ  ARG C 138      38.468  29.327  96.056  1.00 49.02           C  
ATOM   3903  NH1 ARG C 138      39.708  29.007  96.457  1.00 51.94           N  
ATOM   3904  NH2 ARG C 138      37.408  28.779  96.655  1.00 47.19           N  
ATOM   3905  N   GLU C 139      34.904  28.992  89.659  0.50 22.78           N  
ATOM   3907  CA  GLU C 139      34.920  28.472  88.318  0.50 23.16           C  
ATOM   3909  C   GLU C 139      34.044  29.333  87.402  0.50 22.02           C  
ATOM   3911  O   GLU C 139      32.965  29.768  87.805  0.50 20.64           O  
ATOM   3913  CB  GLU C 139      34.485  27.027  88.305  0.50 23.13           C  
ATOM   3915  CG  GLU C 139      35.563  26.098  88.788  0.50 25.26           C  
ATOM   3917  CD  GLU C 139      35.000  24.775  89.230  0.50 24.78           C  
ATOM   3919  OE1 GLU C 139      35.781  23.980  89.813  0.50 28.35           O  
ATOM   3921  OE2 GLU C 139      33.798  24.534  88.986  0.50 23.79           O  
ATOM   3923  N   PRO C 140      34.535  29.570  86.170  1.00 21.83           N  
ATOM   3924  CA  PRO C 140      33.802  30.436  85.221  1.00 20.74           C  
ATOM   3925  C   PRO C 140      32.628  29.626  84.706  1.00 22.62           C  
ATOM   3926  O   PRO C 140      32.829  28.464  84.255  1.00 25.21           O  
ATOM   3927  CB  PRO C 140      34.806  30.684  84.107  1.00 20.99           C  
ATOM   3928  CG  PRO C 140      35.643  29.313  84.104  1.00 19.12           C  
ATOM   3929  CD  PRO C 140      35.759  28.969  85.569  1.00 22.44           C  
ATOM   3930  N   PHE C 141      31.401  30.134  84.865  1.00 19.55           N  
ATOM   3931  CA  PHE C 141      30.254  29.381  84.331  1.00 19.17           C  
ATOM   3932  C   PHE C 141      29.451  30.150  83.254  1.00 18.32           C  
ATOM   3933  O   PHE C 141      28.409  29.675  82.729  1.00 18.79           O  
ATOM   3934  CB  PHE C 141      29.317  28.847  85.417  1.00 19.68           C  
ATOM   3935  CG  PHE C 141      28.536  29.929  86.150  1.00 16.50           C  
ATOM   3936  CD1 PHE C 141      27.228  30.289  85.764  1.00 20.21           C  
ATOM   3937  CD2 PHE C 141      29.139  30.549  87.257  1.00 22.97           C  
ATOM   3938  CE1 PHE C 141      26.503  31.255  86.510  1.00 16.77           C  
ATOM   3939  CE2 PHE C 141      28.456  31.521  88.034  1.00 23.76           C  
ATOM   3940  CZ  PHE C 141      27.150  31.898  87.642  1.00 16.21           C  
ATOM   3941  N   ALA C 142      29.967  31.325  82.931  1.00 18.11           N  
ATOM   3942  CA  ALA C 142      29.393  32.191  81.917  1.00 17.36           C  
ATOM   3943  C   ALA C 142      30.382  33.318  81.617  1.00 16.18           C  
ATOM   3944  O   ALA C 142      31.373  33.481  82.306  1.00 16.12           O  
ATOM   3945  CB  ALA C 142      28.020  32.723  82.352  1.00 16.09           C  
ATOM   3946  N   ALA C 143      30.154  34.033  80.517  1.00 16.03           N  
ATOM   3947  CA  ALA C 143      31.021  35.140  80.096  1.00 15.71           C  
ATOM   3948  C   ALA C 143      30.138  36.141  79.342  1.00 16.58           C  
ATOM   3949  O   ALA C 143      29.227  35.719  78.638  1.00 15.79           O  
ATOM   3950  CB  ALA C 143      32.115  34.713  79.241  1.00 14.68           C  
ATOM   3951  N   ILE C 144      30.373  37.420  79.579  1.00 15.29           N  
ATOM   3952  CA  ILE C 144      29.657  38.472  78.849  1.00 15.39           C  
ATOM   3953  C   ILE C 144      30.701  38.995  77.830  1.00 15.65           C  
ATOM   3954  O   ILE C 144      31.873  39.259  78.172  1.00 14.01           O  
ATOM   3955  CB  ILE C 144      29.216  39.611  79.771  1.00 15.63           C  
ATOM   3956  CG1 ILE C 144      28.246  39.119  80.820  1.00 14.31           C  
ATOM   3957  CG2 ILE C 144      28.602  40.815  78.931  1.00 16.19           C  
ATOM   3958  CD1 ILE C 144      27.893  40.289  81.866  1.00 19.76           C  
ATOM   3959  N   SER C 145      30.282  39.174  76.585  1.00 15.95           N  
ATOM   3960  CA  SER C 145      31.164  39.806  75.592  1.00 15.77           C  
ATOM   3961  C   SER C 145      30.399  41.017  74.993  1.00 16.89           C  
ATOM   3962  O   SER C 145      29.150  41.034  74.949  1.00 18.30           O  
ATOM   3963  CB  SER C 145      31.579  38.875  74.428  1.00 16.67           C  
ATOM   3964  OG  SER C 145      30.460  38.511  73.646  1.00 16.80           O  
ATOM   3965  N   ILE C 146      31.146  42.029  74.632  1.00 15.75           N  
ATOM   3966  CA  ILE C 146      30.703  43.150  73.802  1.00 17.00           C  
ATOM   3967  C   ILE C 146      31.401  42.974  72.435  1.00 17.46           C  
ATOM   3968  O   ILE C 146      32.611  42.723  72.417  1.00 15.84           O  
ATOM   3969  CB  ILE C 146      31.158  44.487  74.452  1.00 17.29           C  
ATOM   3970  CG1 ILE C 146      30.792  44.485  75.953  1.00 15.44           C  
ATOM   3971  CG2 ILE C 146      30.707  45.700  73.593  1.00 18.42           C  
ATOM   3972  CD1 ILE C 146      31.379  45.651  76.775  1.00 19.69           C  
ATOM   3973  N   SER C 147      30.663  43.084  71.321  1.00 16.75           N  
ATOM   3974  CA  SER C 147      31.131  42.599  70.020  1.00 17.93           C  
ATOM   3975  C   SER C 147      30.748  43.705  69.030  1.00 16.94           C  
ATOM   3976  O   SER C 147      29.560  44.049  68.925  1.00 14.00           O  
ATOM   3977  CB  SER C 147      30.407  41.263  69.633  1.00 18.22           C  
ATOM   3978  OG  SER C 147      30.558  40.387  70.738  1.00 23.10           O  
ATOM   3979  N   GLY C 148      31.687  44.145  68.219  1.00 18.30           N  
ATOM   3980  CA  GLY C 148      31.321  45.075  67.151  1.00 16.76           C  
ATOM   3981  C   GLY C 148      32.436  45.373  66.157  1.00 18.18           C  
ATOM   3982  O   GLY C 148      33.560  44.898  66.314  1.00 17.39           O  
ATOM   3983  N   PRO C 149      32.125  46.207  65.146  1.00 19.84           N  
ATOM   3984  CA  PRO C 149      33.059  46.501  64.060  1.00 19.63           C  
ATOM   3985  C   PRO C 149      34.221  47.347  64.619  1.00 20.58           C  
ATOM   3986  O   PRO C 149      34.040  48.144  65.530  1.00 20.24           O  
ATOM   3987  CB  PRO C 149      32.194  47.310  63.026  1.00 19.36           C  
ATOM   3988  CG  PRO C 149      31.140  47.944  63.845  1.00 20.67           C  
ATOM   3989  CD  PRO C 149      30.881  46.982  65.036  1.00 19.96           C  
ATOM   3990  N   ILE C 150      35.401  47.096  64.083  1.00 21.25           N  
ATOM   3991  CA  ILE C 150      36.613  47.909  64.255  1.00 23.37           C  
ATOM   3992  C   ILE C 150      36.412  49.404  63.883  1.00 24.13           C  
ATOM   3993  O   ILE C 150      37.078  50.275  64.470  1.00 26.29           O  
ATOM   3994  CB  ILE C 150      37.814  47.282  63.391  1.00 21.81           C  
ATOM   3995  CG1 ILE C 150      37.558  47.407  61.908  1.00 20.73           C  
ATOM   3996  CG2 ILE C 150      38.068  45.811  63.736  1.00 20.80           C  
ATOM   3997  CD1 ILE C 150      38.811  47.318  61.033  1.00 26.31           C  
ATOM   3998  N   SER C 151      35.511  49.698  62.930  1.00 25.66           N  
ATOM   3999  CA  SER C 151      35.170  51.102  62.578  1.00 27.97           C  
ATOM   4000  C   SER C 151      34.716  51.837  63.840  1.00 26.97           C  
ATOM   4001  O   SER C 151      34.941  53.051  64.007  1.00 27.90           O  
ATOM   4002  CB  SER C 151      34.101  51.169  61.487  1.00 28.89           C  
ATOM   4003  OG  SER C 151      32.794  50.735  61.941  1.00 34.11           O  
ATOM   4004  N   ARG C 152      34.130  51.093  64.777  1.00 24.62           N  
ATOM   4005  CA  ARG C 152      33.599  51.699  65.968  1.00 24.28           C  
ATOM   4006  C   ARG C 152      34.363  51.350  67.195  1.00 23.42           C  
ATOM   4007  O   ARG C 152      34.626  52.228  68.016  1.00 23.62           O  
ATOM   4008  CB  ARG C 152      32.126  51.372  66.138  1.00 24.01           C  
ATOM   4009  CG  ARG C 152      31.293  52.157  65.193  1.00 25.61           C  
ATOM   4010  CD  ARG C 152      29.775  52.071  65.506  1.00 29.56           C  
ATOM   4011  NE  ARG C 152      29.276  50.699  65.783  1.00 24.92           N  
ATOM   4012  CZ  ARG C 152      28.648  49.914  64.909  1.00 23.67           C  
ATOM   4013  NH1 ARG C 152      28.468  50.280  63.608  1.00 22.00           N  
ATOM   4014  NH2 ARG C 152      28.196  48.732  65.319  1.00 21.40           N  
ATOM   4015  N   ILE C 153      34.723  50.063  67.359  1.00 22.37           N  
ATOM   4016  CA  ILE C 153      35.566  49.692  68.442  1.00 21.02           C  
ATOM   4017  C   ILE C 153      37.067  49.989  68.069  1.00 23.69           C  
ATOM   4018  O   ILE C 153      37.859  49.068  67.738  1.00 23.91           O  
ATOM   4019  CB  ILE C 153      35.363  48.214  68.942  1.00 20.41           C  
ATOM   4020  CG1 ILE C 153      33.865  47.852  69.044  1.00 19.33           C  
ATOM   4021  CG2 ILE C 153      36.135  47.993  70.238  1.00 20.87           C  
ATOM   4022  CD1 ILE C 153      33.617  46.506  69.759  1.00 20.65           C  
ATOM   4023  N   THR C 154      37.459  51.270  68.166  1.00 24.19           N  
ATOM   4024  CA  THR C 154      38.787  51.705  67.658  1.00 23.08           C  
ATOM   4025  C   THR C 154      39.834  51.481  68.760  1.00 21.63           C  
ATOM   4026  O   THR C 154      39.481  51.264  69.931  1.00 21.97           O  
ATOM   4027  CB  THR C 154      38.755  53.196  67.243  1.00 23.55           C  
ATOM   4028  OG1 THR C 154      38.139  53.910  68.310  1.00 25.69           O  
ATOM   4029  CG2 THR C 154      37.940  53.423  65.982  1.00 24.57           C  
ATOM   4030  N   ASP C 155      41.137  51.521  68.434  1.00 22.15           N  
ATOM   4031  CA  ASP C 155      42.161  51.234  69.436  1.00 21.56           C  
ATOM   4032  C   ASP C 155      42.091  52.017  70.755  1.00 22.00           C  
ATOM   4033  O   ASP C 155      42.347  51.477  71.787  1.00 21.69           O  
ATOM   4034  CB  ASP C 155      43.542  51.390  68.849  1.00 22.41           C  
ATOM   4035  CG  ASP C 155      43.826  50.395  67.761  1.00 24.21           C  
ATOM   4036  OD1 ASP C 155      43.133  49.361  67.701  1.00 29.29           O  
ATOM   4037  OD2 ASP C 155      44.736  50.650  66.960  1.00 19.96           O  
ATOM   4038  N   ASP C 156      41.740  53.303  70.667  1.00 22.91           N  
ATOM   4039  CA  ASP C 156      41.621  54.189  71.828  1.00 24.61           C  
ATOM   4040  C   ASP C 156      40.409  53.869  72.694  1.00 24.11           C  
ATOM   4041  O   ASP C 156      40.261  54.479  73.760  1.00 26.96           O  
ATOM   4042  CB  ASP C 156      41.434  55.638  71.365  1.00 24.12           C  
ATOM   4043  CG  ASP C 156      40.183  55.809  70.536  1.00 29.19           C  
ATOM   4044  OD1 ASP C 156      40.133  55.371  69.372  1.00 26.80           O  
ATOM   4045  OD2 ASP C 156      39.212  56.360  71.082  1.00 36.26           O  
ATOM   4046  N   ARG C 157      39.501  53.024  72.195  1.00 23.76           N  
ATOM   4047  CA  ARG C 157      38.342  52.565  72.994  1.00 23.50           C  
ATOM   4048  C   ARG C 157      38.523  51.181  73.658  1.00 22.88           C  
ATOM   4049  O   ARG C 157      37.728  50.817  74.522  1.00 22.04           O  
ATOM   4050  CB  ARG C 157      37.009  52.606  72.168  1.00 23.51           C  
ATOM   4051  CG  ARG C 157      36.586  54.020  71.668  1.00 24.22           C  
ATOM   4052  CD  ARG C 157      35.223  54.047  70.945  1.00 24.10           C  
ATOM   4053  NE  ARG C 157      34.090  53.898  71.869  1.00 25.74           N  
ATOM   4054  CZ  ARG C 157      32.891  53.438  71.510  1.00 24.81           C  
ATOM   4055  NH1 ARG C 157      32.672  53.061  70.250  1.00 19.91           N  
ATOM   4056  NH2 ARG C 157      31.923  53.334  72.415  1.00 26.52           N  
ATOM   4057  N   VAL C 158      39.530  50.392  73.260  1.00 23.33           N  
ATOM   4058  CA  VAL C 158      39.672  49.021  73.823  1.00 22.99           C  
ATOM   4059  C   VAL C 158      39.665  48.911  75.358  1.00 22.29           C  
ATOM   4060  O   VAL C 158      38.896  48.129  75.911  1.00 21.10           O  
ATOM   4061  CB  VAL C 158      40.816  48.240  73.116  1.00 23.33           C  
ATOM   4062  CG1 VAL C 158      41.059  46.818  73.789  1.00 21.73           C  
ATOM   4063  CG2 VAL C 158      40.452  48.126  71.696  1.00 22.67           C  
ATOM   4064  N   THR C 159      40.516  49.684  76.063  1.00 22.71           N  
ATOM   4065  CA  THR C 159      40.547  49.652  77.552  1.00 23.65           C  
ATOM   4066  C   THR C 159      39.238  50.059  78.182  1.00 21.19           C  
ATOM   4067  O   THR C 159      38.858  49.488  79.205  1.00 22.84           O  
ATOM   4068  CB  THR C 159      41.676  50.529  78.197  1.00 24.48           C  
ATOM   4069  OG1 THR C 159      41.710  51.809  77.557  1.00 29.35           O  
ATOM   4070  CG2 THR C 159      42.959  49.900  78.013  1.00 24.42           C  
ATOM   4071  N   GLU C 160      38.591  51.041  77.541  0.50 21.85           N  
ATOM   4073  CA  GLU C 160      37.243  51.479  77.839  0.50 21.11           C  
ATOM   4075  C   GLU C 160      36.288  50.272  77.888  0.50 19.59           C  
ATOM   4077  O   GLU C 160      35.650  49.995  78.897  0.50 18.81           O  
ATOM   4079  CB  GLU C 160      36.794  52.472  76.755  0.50 21.58           C  
ATOM   4081  CG  GLU C 160      35.393  53.050  76.905  0.50 21.67           C  
ATOM   4083  CD  GLU C 160      35.103  54.132  75.853  0.50 23.26           C  
ATOM   4085  OE1 GLU C 160      34.492  53.840  74.789  0.50 22.36           O  
ATOM   4087  OE2 GLU C 160      35.558  55.278  76.082  0.50 29.22           O  
ATOM   4089  N   PHE C 161      36.200  49.589  76.763  1.00 18.82           N  
ATOM   4090  CA  PHE C 161      35.363  48.369  76.592  1.00 18.61           C  
ATOM   4091  C   PHE C 161      35.726  47.294  77.636  1.00 18.33           C  
ATOM   4092  O   PHE C 161      34.822  46.688  78.225  1.00 16.81           O  
ATOM   4093  CB  PHE C 161      35.453  47.852  75.152  1.00 18.80           C  
ATOM   4094  CG  PHE C 161      34.517  48.572  74.171  1.00 19.48           C  
ATOM   4095  CD1 PHE C 161      33.469  47.880  73.575  1.00 22.89           C  
ATOM   4096  CD2 PHE C 161      34.616  49.945  73.934  1.00 23.17           C  
ATOM   4097  CE1 PHE C 161      32.594  48.538  72.682  1.00 23.81           C  
ATOM   4098  CE2 PHE C 161      33.708  50.612  73.050  1.00 22.40           C  
ATOM   4099  CZ  PHE C 161      32.718  49.892  72.442  1.00 23.39           C  
ATOM   4100  N   GLY C 162      37.037  47.114  77.870  1.00 17.07           N  
ATOM   4101  CA  GLY C 162      37.603  46.286  78.931  1.00 18.34           C  
ATOM   4102  C   GLY C 162      36.958  46.552  80.275  1.00 18.85           C  
ATOM   4103  O   GLY C 162      36.368  45.639  80.903  1.00 17.58           O  
ATOM   4104  N   ALA C 163      37.016  47.834  80.679  1.00 18.88           N  
ATOM   4105  CA  ALA C 163      36.515  48.239  81.989  1.00 19.59           C  
ATOM   4106  C   ALA C 163      35.013  47.964  82.042  1.00 18.42           C  
ATOM   4107  O   ALA C 163      34.514  47.476  83.026  1.00 17.88           O  
ATOM   4108  CB  ALA C 163      36.841  49.740  82.243  1.00 20.38           C  
HETATM 4109  N   MSE C 164      34.267  48.264  80.960  1.00 17.85           N  
HETATM 4110  CA  MSE C 164      32.818  48.034  80.942  1.00 19.73           C  
HETATM 4111  C   MSE C 164      32.436  46.581  81.137  1.00 17.05           C  
HETATM 4112  O   MSE C 164      31.532  46.302  81.871  1.00 18.02           O  
HETATM 4113  CB  MSE C 164      32.174  48.601  79.661  1.00 19.14           C  
HETATM 4114  CG  MSE C 164      32.188  50.119  79.655  1.00 21.85           C  
HETATM 4115 SE   MSE C 164      31.273  50.767  78.005  1.00 28.15          SE  
HETATM 4116  CE  MSE C 164      32.513  50.432  76.793  1.00 20.19           C  
ATOM   4117  N   VAL C 165      33.148  45.691  80.476  1.00 17.30           N  
ATOM   4118  CA  VAL C 165      32.839  44.252  80.520  1.00 16.40           C  
ATOM   4119  C   VAL C 165      33.201  43.651  81.905  1.00 17.99           C  
ATOM   4120  O   VAL C 165      32.407  42.886  82.477  1.00 15.65           O  
ATOM   4121  CB  VAL C 165      33.361  43.453  79.265  1.00 17.38           C  
ATOM   4122  CG1 VAL C 165      34.801  43.154  79.301  1.00 17.27           C  
ATOM   4123  CG2 VAL C 165      32.452  42.182  79.112  1.00 20.71           C  
ATOM   4124  N   ILE C 166      34.326  44.089  82.430  1.00 18.03           N  
ATOM   4125  CA  ILE C 166      34.726  43.773  83.821  1.00 19.65           C  
ATOM   4126  C   ILE C 166      33.654  44.117  84.818  1.00 18.79           C  
ATOM   4127  O   ILE C 166      33.243  43.302  85.613  1.00 16.94           O  
ATOM   4128  CB  ILE C 166      36.056  44.383  84.179  1.00 21.11           C  
ATOM   4129  CG1 ILE C 166      37.209  43.616  83.508  1.00 21.19           C  
ATOM   4130  CG2 ILE C 166      36.256  44.426  85.751  1.00 22.60           C  
ATOM   4131  CD1 ILE C 166      38.659  44.348  83.701  1.00 21.69           C  
ATOM   4132  N   LYS C 167      33.198  45.352  84.753  0.50 18.41           N  
ATOM   4134  CA  LYS C 167      32.172  45.781  85.660  0.50 18.95           C  
ATOM   4136  C   LYS C 167      30.867  44.979  85.529  0.50 18.23           C  
ATOM   4138  O   LYS C 167      30.295  44.615  86.553  0.50 18.22           O  
ATOM   4140  CB  LYS C 167      31.953  47.283  85.499  0.50 18.91           C  
ATOM   4142  CG  LYS C 167      31.802  48.049  86.817  0.50 19.50           C  
ATOM   4144  CD  LYS C 167      31.880  49.551  86.554  0.50 19.37           C  
ATOM   4146  CE  LYS C 167      30.556  50.089  86.170  0.50 22.00           C  
ATOM   4148  NZ  LYS C 167      30.704  51.564  85.936  0.50 21.20           N  
ATOM   4150  N   ALA C 168      30.400  44.702  84.289  1.00 17.79           N  
ATOM   4151  CA  ALA C 168      29.182  43.943  84.042  1.00 17.41           C  
ATOM   4152  C   ALA C 168      29.285  42.469  84.528  1.00 17.75           C  
ATOM   4153  O   ALA C 168      28.317  41.961  85.153  1.00 17.75           O  
ATOM   4154  CB  ALA C 168      28.767  44.001  82.546  1.00 17.93           C  
ATOM   4155  N   ALA C 169      30.431  41.839  84.216  1.00 15.94           N  
ATOM   4156  CA  ALA C 169      30.787  40.472  84.713  1.00 16.39           C  
ATOM   4157  C   ALA C 169      30.756  40.455  86.259  1.00 16.21           C  
ATOM   4158  O   ALA C 169      30.130  39.564  86.886  1.00 15.59           O  
ATOM   4159  CB  ALA C 169      32.165  39.989  84.191  1.00 16.74           C  
ATOM   4160  N   LYS C 170      31.423  41.439  86.844  1.00 18.10           N  
ATOM   4161  CA  LYS C 170      31.461  41.568  88.312  1.00 17.92           C  
ATOM   4162  C   LYS C 170      30.042  41.639  88.857  1.00 18.48           C  
ATOM   4163  O   LYS C 170      29.717  40.931  89.809  1.00 18.28           O  
ATOM   4164  CB  LYS C 170      32.288  42.795  88.734  1.00 17.90           C  
ATOM   4165  CG  LYS C 170      32.177  43.085  90.287  1.00 17.52           C  
ATOM   4166  CD  LYS C 170      33.162  44.142  90.742  1.00 19.36           C  
ATOM   4167  CE  LYS C 170      32.974  45.488  90.123  1.00 26.26           C  
ATOM   4168  NZ  LYS C 170      34.144  46.315  90.661  1.00 27.35           N  
ATOM   4169  N   GLU C 171      29.168  42.467  88.232  1.00 17.03           N  
ATOM   4170  CA  GLU C 171      27.827  42.613  88.771  1.00 18.40           C  
ATOM   4171  C   GLU C 171      27.070  41.288  88.749  1.00 16.55           C  
ATOM   4172  O   GLU C 171      26.386  40.928  89.684  1.00 16.44           O  
ATOM   4173  CB  GLU C 171      27.053  43.671  87.997  1.00 18.38           C  
ATOM   4174  CG  GLU C 171      27.539  45.039  88.293  1.00 23.39           C  
ATOM   4175  CD  GLU C 171      26.770  46.082  87.473  1.00 22.64           C  
ATOM   4176  OE1 GLU C 171      25.598  45.833  87.133  1.00 30.54           O  
ATOM   4177  OE2 GLU C 171      27.337  47.162  87.204  1.00 25.18           O  
ATOM   4178  N   VAL C 172      27.301  40.515  87.695  1.00 17.09           N  
ATOM   4179  CA  VAL C 172      26.640  39.230  87.583  1.00 17.23           C  
ATOM   4180  C   VAL C 172      27.180  38.203  88.618  1.00 15.34           C  
ATOM   4181  O   VAL C 172      26.390  37.519  89.287  1.00 18.33           O  
ATOM   4182  CB  VAL C 172      26.658  38.695  86.086  1.00 16.70           C  
ATOM   4183  CG1 VAL C 172      26.106  37.312  86.020  1.00 17.81           C  
ATOM   4184  CG2 VAL C 172      25.831  39.669  85.197  1.00 15.09           C  
ATOM   4185  N   THR C 173      28.483  38.130  88.776  1.00 17.64           N  
ATOM   4186  CA  THR C 173      29.181  37.315  89.841  1.00 17.22           C  
ATOM   4187  C   THR C 173      28.646  37.647  91.223  1.00 17.09           C  
ATOM   4188  O   THR C 173      28.183  36.789  91.931  1.00 15.93           O  
ATOM   4189  CB  THR C 173      30.709  37.495  89.780  1.00 18.73           C  
ATOM   4190  OG1 THR C 173      31.142  37.079  88.476  1.00 18.23           O  
ATOM   4191  CG2 THR C 173      31.431  36.701  90.892  1.00 18.43           C  
ATOM   4192  N   LEU C 174      28.605  38.925  91.538  1.00 18.54           N  
ATOM   4193  CA  LEU C 174      28.020  39.379  92.796  1.00 17.73           C  
ATOM   4194  C   LEU C 174      26.550  39.035  92.913  1.00 17.68           C  
ATOM   4195  O   LEU C 174      26.101  38.719  94.003  1.00 17.06           O  
ATOM   4196  CB  LEU C 174      28.231  40.900  92.960  1.00 17.34           C  
ATOM   4197  CG  LEU C 174      29.678  41.400  93.080  1.00 17.49           C  
ATOM   4198  CD1 LEU C 174      29.775  43.013  93.012  1.00 18.33           C  
ATOM   4199  CD2 LEU C 174      30.478  40.846  94.284  1.00 19.42           C  
ATOM   4200  N   ALA C 175      25.774  39.102  91.814  1.00 18.01           N  
ATOM   4201  CA  ALA C 175      24.336  38.811  91.837  1.00 19.21           C  
ATOM   4202  C   ALA C 175      24.135  37.330  92.082  1.00 16.66           C  
ATOM   4203  O   ALA C 175      23.304  36.933  92.865  1.00 18.83           O  
ATOM   4204  CB  ALA C 175      23.666  39.220  90.478  1.00 19.69           C  
ATOM   4205  N   TYR C 176      25.001  36.515  91.502  1.00 19.31           N  
ATOM   4206  CA  TYR C 176      24.959  35.086  91.778  1.00 18.80           C  
ATOM   4207  C   TYR C 176      25.314  34.800  93.262  1.00 19.28           C  
ATOM   4208  O   TYR C 176      24.626  34.038  93.917  1.00 20.65           O  
ATOM   4209  CB  TYR C 176      25.885  34.301  90.829  1.00 20.43           C  
ATOM   4210  CG  TYR C 176      26.076  32.829  91.246  1.00 21.00           C  
ATOM   4211  CD1 TYR C 176      25.203  31.860  90.805  1.00 21.21           C  
ATOM   4212  CD2 TYR C 176      27.085  32.445  92.153  1.00 22.04           C  
ATOM   4213  CE1 TYR C 176      25.374  30.504  91.141  1.00 21.41           C  
ATOM   4214  CE2 TYR C 176      27.242  31.078  92.546  1.00 22.52           C  
ATOM   4215  CZ  TYR C 176      26.365  30.120  92.005  1.00 21.17           C  
ATOM   4216  OH  TYR C 176      26.430  28.782  92.379  1.00 24.11           O  
ATOM   4217  N   GLY C 177      26.372  35.427  93.793  1.00 17.77           N  
ATOM   4218  CA  GLY C 177      26.711  35.286  95.215  1.00 18.65           C  
ATOM   4219  C   GLY C 177      25.494  35.642  96.079  1.00 18.92           C  
ATOM   4220  O   GLY C 177      25.169  34.951  97.092  1.00 16.56           O  
ATOM   4221  N   GLY C 178      24.752  36.707  95.693  1.00 16.81           N  
ATOM   4222  CA  GLY C 178      23.600  37.171  96.548  1.00 20.34           C  
ATOM   4223  C   GLY C 178      22.517  36.107  96.587  1.00 21.50           C  
ATOM   4224  O   GLY C 178      21.965  35.797  97.633  1.00 22.31           O  
HETATM 4225  N   MSE C 179      22.265  35.486  95.441  1.00 20.89           N  
HETATM 4226  CA  MSE C 179      21.244  34.450  95.333  0.50 21.66           C  
HETATM 4228  C   MSE C 179      21.631  33.234  96.146  1.00 23.88           C  
HETATM 4229  O   MSE C 179      20.773  32.525  96.721  1.00 23.84           O  
HETATM 4230  CB  MSE C 179      21.077  34.029  93.872  0.50 21.57           C  
HETATM 4232  CG  MSE C 179      20.238  34.990  93.059  0.50 18.84           C  
HETATM 4234 SE   MSE C 179      20.222  34.538  91.141  0.50 19.86          SE  
HETATM 4236  CE  MSE C 179      19.150  32.880  91.233  0.50 12.89           C  
ATOM   4238  N   ARG C 180      22.920  32.968  96.195  1.00 25.69           N  
ATOM   4239  CA  ARG C 180      23.346  31.782  96.879  1.00 29.03           C  
ATOM   4240  C   ARG C 180      23.337  32.022  98.391  1.00 30.83           C  
ATOM   4241  O   ARG C 180      23.162  31.078  99.175  1.00 32.35           O  
ATOM   4242  CB  ARG C 180      24.720  31.365  96.339  1.00 27.73           C  
ATOM   4243  CG  ARG C 180      25.335  30.254  97.087  1.00 31.74           C  
ATOM   4244  CD  ARG C 180      26.325  29.493  96.205  1.00 34.80           C  
ATOM   4245  NE  ARG C 180      26.824  28.328  96.942  1.00 36.50           N  
ATOM   4246  CZ  ARG C 180      27.638  28.395  97.999  1.00 39.03           C  
ATOM   4247  NH1 ARG C 180      28.063  29.563  98.469  1.00 38.64           N  
ATOM   4248  NH2 ARG C 180      28.026  27.275  98.597  1.00 40.89           N  
ATOM   4249  N   GLY C 181      23.517  33.277  98.805  1.00 31.37           N  
ATOM   4250  CA  GLY C 181      23.521  33.596 100.218  1.00 33.52           C  
ATOM   4251  C   GLY C 181      22.113  33.935 100.684  1.00 35.76           C  
ATOM   4252  O   GLY C 181      21.933  34.726 101.631  1.00 35.84           O  
ATOM   4253  N   SER C 182      21.105  33.383  99.997  1.00 36.47           N  
ATOM   4254  CA  SER C 182      19.705  33.721 100.260  1.00 38.29           C  
ATOM   4255  C   SER C 182      18.763  32.588  99.834  1.00 38.75           C  
ATOM   4256  O   SER C 182      19.165  31.548  99.305  1.00 39.58           O  
ATOM   4257  CB  SER C 182      19.303  35.085  99.619  1.00 38.92           C  
ATOM   4258  OG  SER C 182      19.160  35.048  98.202  1.00 35.43           O  
ATOM   4259  OXT SER C 182      17.573  32.668 100.037  1.00 40.09           O  
TER    4260      SER C 182                                                      
END
MOLECULE T0412.pdb
ATOM      1  N   SER     1      17.559  26.951  92.213  1.00 54.32           N  
ATOM      2  CA  SER     1      16.245  27.299  92.853  1.00 53.09           C  
ATOM      3  C   SER     1      16.043  28.831  93.060  1.00 52.29           C  
ATOM      4  O   SER     1      15.077  29.281  93.761  1.00 50.93           O  
ATOM      5  CB  SER     1      16.073  26.547  94.152  1.00 52.87           C  
ATOM      6  OG  SER     1      14.779  26.777  94.666  1.00 52.80           O  
ATOM      7  N   ASN     2      16.948  29.599  92.427  1.00 50.24           N  
ATOM      8  CA  ASN     2      16.884  31.054  92.474  1.00 48.93           C  
ATOM      9  C   ASN     2      17.383  31.628  91.189  1.00 47.18           C  
ATOM     10  O   ASN     2      17.733  32.795  91.079  1.00 47.53           O  
ATOM     11  CB  ASN     2      17.619  31.623  93.683  1.00 49.45           C  
ATOM     12  CG  ASN     2      17.125  33.004  94.040  1.00 49.02           C  
ATOM     13  OD1 ASN     2      17.498  33.973  93.384  1.00 51.47           O  
ATOM     14  ND2 ASN     2      16.253  33.099  95.026  1.00 44.65           N  
ATOM     15  N   ALA     3      17.385  30.732  90.212  1.00 45.59           N  
ATOM     16  CA  ALA     3      17.756  30.926  88.865  1.00 42.81           C  
ATOM     17  C   ALA     3      17.150  32.162  88.216  1.00 42.42           C  
ATOM     18  O   ALA     3      17.817  32.797  87.411  1.00 43.10           O  
ATOM     19  CB  ALA     3      17.328  29.686  88.100  1.00 42.78           C  
ATOM     20  N   LEU     4      15.891  32.474  88.499  1.00 40.84           N  
ATOM     21  CA  LEU     4      15.175  33.549  87.776  1.00 41.08           C  
ATOM     22  C   LEU     4      15.595  34.992  88.193  1.00 41.73           C  
ATOM     23  O   LEU     4      15.795  35.891  87.336  1.00 40.99           O  
ATOM     24  CB  LEU     4      13.630  33.366  87.879  1.00 40.15           C  
ATOM     25  CG  LEU     4      13.042  32.123  87.172  1.00 39.13           C  
ATOM     26  CD1 LEU     4      11.515  32.115  87.181  1.00 37.64           C  
ATOM     27  CD2 LEU     4      13.561  32.029  85.757  1.00 33.72           C  
ATOM     28  N   PHE     5      15.747  35.183  89.503  1.00 42.10           N  
ATOM     29  CA  PHE     5      16.276  36.410  90.043  1.00 43.47           C  
ATOM     30  C   PHE     5      17.723  36.613  89.583  1.00 45.53           C  
ATOM     31  O   PHE     5      18.087  37.717  89.179  1.00 45.52           O  
ATOM     32  CB  PHE     5      16.153  36.419  91.539  1.00 41.53           C  
ATOM     33  CG  PHE     5      14.758  36.708  92.026  1.00 42.02           C  
ATOM     34  CD1 PHE     5      14.162  37.953  91.794  1.00 40.73           C  
ATOM     35  CD2 PHE     5      14.057  35.762  92.772  1.00 38.83           C  
ATOM     36  CE1 PHE     5      12.860  38.232  92.300  1.00 39.71           C  
ATOM     37  CE2 PHE     5      12.788  36.019  93.254  1.00 37.43           C  
ATOM     38  CZ  PHE     5      12.175  37.252  93.015  1.00 38.76           C  
ATOM     39  N   SER     6      18.539  35.567  89.550  1.00 47.47           N  
ATOM     40  CA  SER     6      19.873  35.786  88.935  1.00 50.67           C  
ATOM     41  C   SER     6      19.841  36.120  87.464  1.00 51.41           C  
ATOM     42  O   SER     6      20.662  36.934  87.018  1.00 52.33           O  
ATOM     43  CB  SER     6      20.860  34.630  89.193  1.00 50.07           C  
ATOM     44  OG  SER     6      20.888  34.394  90.613  1.00 55.00           O  
ATOM     45  N   SER     7      18.951  35.474  86.693  1.00 52.62           N  
ATOM     46  CA  SER     7      18.913  35.704  85.234  1.00 53.39           C  
ATOM     47  C   SER     7      18.502  37.146  85.049  1.00 53.99           C  
ATOM     48  O   SER     7      19.066  37.871  84.231  1.00 54.98           O  
ATOM     49  CB  SER     7      17.939  34.768  84.510  1.00 53.69           C  
ATOM     50  OG  SER     7      18.384  33.413  84.592  1.00 54.34           O  
ATOM     51  N   ARG     8      17.565  37.583  85.866  1.00 53.65           N  
ATOM     52  CA  ARG     8      17.066  38.939  85.755  1.00 54.53           C  
ATOM     53  C   ARG     8      18.164  39.964  86.086  1.00 54.58           C  
ATOM     54  O   ARG     8      18.327  40.920  85.341  1.00 55.96           O  
ATOM     55  CB  ARG     8      15.819  39.113  86.650  1.00 54.60           C  
ATOM     56  CG  ARG     8      15.233  40.467  86.595  1.00 56.13           C  
ATOM     57  CD  ARG     8      15.106  40.985  88.004  1.00 57.96           C  
ATOM     58  NE  ARG     8      13.696  41.145  88.342  1.00 62.03           N  
ATOM     59  CZ  ARG     8      13.204  41.195  89.577  1.00 61.99           C  
ATOM     60  NH1 ARG     8      11.897  41.360  89.749  1.00 61.14           N  
ATOM     61  NH2 ARG     8      14.011  41.073  90.627  1.00 62.55           N  
ATOM     62  N   ASP     9      18.908  39.772  87.183  1.00 54.12           N  
ATOM     63  CA  ASP     9      20.074  40.595  87.510  1.00 54.08           C  
ATOM     64  C   ASP     9      21.019  40.705  86.305  1.00 54.67           C  
ATOM     65  O   ASP     9      21.399  41.806  85.927  1.00 55.78           O  
ATOM     66  CB  ASP     9      20.870  39.989  88.667  1.00 53.61           C  
ATOM     67  CG  ASP     9      20.139  40.045  90.007  1.00 55.37           C  
ATOM     68  OD1 ASP     9      19.080  40.719  90.144  1.00 57.24           O  
ATOM     69  OD2 ASP     9      20.634  39.387  90.952  1.00 56.96           O  
ATOM     70  N   ILE    10      21.384  39.573  85.702  1.00 54.19           N  
ATOM     71  CA  ILE    10      22.284  39.552  84.544  1.00 54.42           C  
ATOM     72  C   ILE    10      21.722  40.293  83.315  1.00 55.29           C  
ATOM     73  O   ILE    10      22.394  41.116  82.712  1.00 55.62           O  
ATOM     74  CB  ILE    10      22.666  38.098  84.163  1.00 53.93           C  
ATOM     75  CG1 ILE    10      23.447  37.454  85.291  1.00 53.01           C  
ATOM     76  CG2 ILE    10      23.465  38.026  82.840  1.00 53.06           C  
ATOM     77  CD1 ILE    10      23.566  35.934  85.160  1.00 52.08           C  
ATOM     78  N   LEU    11      20.489  39.975  82.942  1.00 56.18           N  
ATOM     79  CA  LEU    11      19.816  40.679  81.877  1.00 56.38           C  
ATOM     80  C   LEU    11      19.798  42.184  82.141  1.00 57.20           C  
ATOM     81  O   LEU    11      20.038  42.959  81.229  1.00 58.40           O  
ATOM     82  CB  LEU    11      18.403  40.149  81.688  1.00 55.51           C  
ATOM     83  CG  LEU    11      17.694  40.821  80.522  1.00 55.16           C  
ATOM     84  CD1 LEU    11      18.433  40.553  79.200  1.00 52.86           C  
ATOM     85  CD2 LEU    11      16.261  40.337  80.481  1.00 49.81           C  
ATOM     86  N   GLU    12      19.507  42.620  83.360  1.00 57.38           N  
ATOM     87  CA  GLU    12      19.500  44.064  83.621  1.00 58.36           C  
ATOM     88  C   GLU    12      20.894  44.699  83.355  1.00 57.39           C  
ATOM     89  O   GLU    12      20.998  45.782  82.776  1.00 57.72           O  
ATOM     90  CB  GLU    12      19.034  44.374  85.047  1.00 57.74           C  
ATOM     91  CG  GLU    12      17.531  44.332  85.205  1.00 60.40           C  
ATOM     92  CD  GLU    12      17.043  44.331  86.701  1.00 61.88           C  
ATOM     93  OE1 GLU    12      17.873  44.459  87.671  1.00 62.94           O  
ATOM     94  OE2 GLU    12      15.796  44.191  86.887  1.00 66.26           O  
ATOM     95  N   VAL    13      21.957  44.040  83.792  1.00 55.98           N  
ATOM     96  CA  VAL    13      23.286  44.551  83.529  1.00 55.60           C  
ATOM     97  C   VAL    13      23.614  44.556  82.022  1.00 55.56           C  
ATOM     98  O   VAL    13      24.168  45.541  81.501  1.00 55.72           O  
ATOM     99  CB  VAL    13      24.357  43.769  84.292  1.00 55.14           C  
ATOM    100  CG1 VAL    13      25.722  44.167  83.806  1.00 54.07           C  
ATOM    101  CG2 VAL    13      24.239  44.064  85.750  1.00 54.66           C  
ATOM    102  N   LEU    14      23.268  43.472  81.339  1.00 55.24           N  
ATOM    103  CA  LEU    14      23.531  43.338  79.920  1.00 56.29           C  
ATOM    104  C   LEU    14      22.733  44.390  79.113  1.00 56.68           C  
ATOM    105  O   LEU    14      23.240  44.984  78.188  1.00 55.03           O  
ATOM    106  CB  LEU    14      23.190  41.918  79.489  1.00 56.15           C  
ATOM    107  CG  LEU    14      23.420  41.464  78.039  1.00 58.26           C  
ATOM    108  CD1 LEU    14      24.902  41.336  77.676  1.00 56.32           C  
ATOM    109  CD2 LEU    14      22.662  40.132  77.744  1.00 56.95           C  
ATOM    110  N   GLN    15      21.476  44.617  79.488  1.00 57.39           N  
ATOM    111  CA  GLN    15      20.712  45.698  78.920  1.00 58.53           C  
ATOM    112  C   GLN    15      21.356  47.067  79.131  1.00 58.92           C  
ATOM    113  O   GLN    15      21.273  47.906  78.234  1.00 59.03           O  
ATOM    114  CB  GLN    15      19.262  45.682  79.394  1.00 57.53           C  
ATOM    115  CG  GLN    15      18.490  44.721  78.582  1.00 60.66           C  
ATOM    116  CD  GLN    15      17.050  44.549  79.011  1.00 67.03           C  
ATOM    117  OE1 GLN    15      16.699  44.686  80.206  1.00 70.49           O  
ATOM    118  NE2 GLN    15      16.197  44.222  78.046  1.00 66.34           N  
ATOM    119  N   ASP    16      21.993  47.297  80.274  1.00 59.06           N  
ATOM    120  CA  ASP    16      22.670  48.569  80.467  1.00 61.14           C  
ATOM    121  C   ASP    16      23.854  48.786  79.522  1.00 60.80           C  
ATOM    122  O   ASP    16      24.084  49.885  79.037  1.00 62.19           O  
ATOM    123  CB  ASP    16      23.144  48.748  81.898  1.00 61.68           C  
ATOM    124  CG  ASP    16      22.232  49.623  82.672  1.00 68.11           C  
ATOM    125  OD1 ASP    16      21.178  49.073  83.077  1.00 74.84           O  
ATOM    126  OD2 ASP    16      22.526  50.864  82.858  1.00 74.19           O  
ATOM    127  N   ILE    17      24.610  47.746  79.266  1.00 59.31           N  
ATOM    128  CA  ILE    17      25.768  47.894  78.435  1.00 58.61           C  
ATOM    129  C   ILE    17      25.329  48.077  76.973  1.00 58.36           C  
ATOM    130  O   ILE    17      25.962  48.806  76.173  1.00 58.26           O  
ATOM    131  CB  ILE    17      26.776  46.737  78.709  1.00 58.41           C  
ATOM    132  CG1 ILE    17      27.396  47.016  80.102  1.00 59.02           C  
ATOM    133  CG2 ILE    17      27.855  46.699  77.673  1.00 55.26           C  
ATOM    134  CD1 ILE    17      27.730  45.783  80.928  1.00 58.25           C  
ATOM    135  N   HIS    18      24.204  47.478  76.654  1.00 57.90           N  
ATOM    136  CA  HIS    18      23.629  47.664  75.351  1.00 58.94           C  
ATOM    137  C   HIS    18      23.112  49.113  75.217  1.00 59.57           C  
ATOM    138  O   HIS    18      23.374  49.768  74.222  1.00 60.69           O  
ATOM    139  CB  HIS    18      22.526  46.645  75.090  1.00 57.67           C  
ATOM    140  CG  HIS    18      21.918  46.772  73.737  1.00 57.96           C  
ATOM    141  ND1 HIS    18      20.628  47.214  73.539  1.00 58.77           N  
ATOM    142  CD2 HIS    18      22.425  46.528  72.505  1.00 58.94           C  
ATOM    143  CE1 HIS    18      20.359  47.219  72.245  1.00 60.89           C  
ATOM    144  NE2 HIS    18      21.434  46.803  71.595  1.00 61.68           N  
ATOM    145  N   MET    19      22.406  49.635  76.201  1.00 60.21           N  
ATOM    146  CA  MET    19      21.950  51.024  76.073  1.00 61.55           C  
ATOM    147  C   MET    19      23.110  51.997  75.938  1.00 61.25           C  
ATOM    148  O   MET    19      23.060  52.863  75.066  1.00 61.91           O  
ATOM    149  CB  MET    19      21.069  51.463  77.232  1.00 62.10           C  
ATOM    150  CG  MET    19      19.700  50.779  77.275  1.00 67.35           C  
ATOM    151  SD  MET    19      18.646  50.737  75.611  0.70 78.76          SE  
ATOM    152  CE  MET    19      17.526  52.242  75.897  1.00 73.10           C  
ATOM    153  N   GLU    20      24.145  51.856  76.772  1.00 60.29           N  
ATOM    154  CA  GLU    20      25.248  52.795  76.767  1.00 60.15           C  
ATOM    155  C   GLU    20      26.152  52.649  75.538  1.00 60.05           C  
ATOM    156  O   GLU    20      26.716  53.622  75.082  1.00 61.14           O  
ATOM    157  CB  GLU    20      26.110  52.629  78.003  1.00 60.63           C  
ATOM    158  CG  GLU    20      25.379  52.438  79.286  1.00 63.50           C  
ATOM    159  CD  GLU    20      25.814  53.410  80.356  1.00 68.04           C  
ATOM    160  OE1 GLU    20      26.697  54.260  80.104  1.00 70.18           O  
ATOM    161  OE2 GLU    20      25.245  53.346  81.463  1.00 72.19           O  
ATOM    162  N   THR    21      26.292  51.453  74.989  1.00 58.97           N  
ATOM    163  CA  THR    21      27.239  51.263  73.902  1.00 58.25           C  
ATOM    164  C   THR    21      26.625  51.052  72.532  1.00 58.63           C  
ATOM    165  O   THR    21      27.294  51.276  71.547  1.00 59.56           O  
ATOM    166  CB  THR    21      28.229  50.062  74.160  1.00 57.95           C  
ATOM    167  OG1 THR    21      27.559  48.822  73.928  1.00 53.65           O  
ATOM    168  CG2 THR    21      28.813  50.091  75.593  1.00 57.31           C  
ATOM    169  N   GLY    22      25.388  50.561  72.458  1.00 59.40           N  
ATOM    170  CA  GLY    22      24.713  50.279  71.177  1.00 58.70           C  
ATOM    171  C   GLY    22      25.251  49.067  70.445  1.00 59.54           C  
ATOM    172  O   GLY    22      24.683  48.653  69.426  1.00 59.78           O  
ATOM    173  N   GLU    23      26.327  48.469  70.976  1.00 59.24           N  
ATOM    174  CA  GLU    23      26.980  47.302  70.367  1.00 58.58           C  
ATOM    175  C   GLU    23      26.200  45.998  70.555  1.00 58.88           C  
ATOM    176  O   GLU    23      25.259  45.959  71.333  1.00 58.65           O  
ATOM    177  CB  GLU    23      28.390  47.164  70.925  1.00 57.76           C  
ATOM    178  CG  GLU    23      29.214  48.414  70.770  1.00 58.46           C  
ATOM    179  CD  GLU    23      29.610  48.755  69.295  1.00 59.54           C  
ATOM    180  OE1 GLU    23      29.386  47.923  68.411  1.00 54.46           O  
ATOM    181  OE2 GLU    23      30.168  49.866  69.047  1.00 60.23           O  
ATOM    182  N   THR    24      26.562  44.942  69.806  1.00 59.29           N  
ATOM    183  CA  THR    24      26.049  43.581  70.074  1.00 59.56           C  
ATOM    184  C   THR    24      26.676  43.137  71.355  1.00 59.12           C  
ATOM    185  O   THR    24      27.906  43.220  71.551  1.00 59.04           O  
ATOM    186  CB  THR    24      26.459  42.569  68.998  1.00 59.44           C  
ATOM    187  OG1 THR    24      26.050  43.044  67.721  1.00 62.46           O  
ATOM    188  CG2 THR    24      25.755  41.242  69.199  1.00 60.40           C  
ATOM    189  N   VAL    25      25.836  42.700  72.267  1.00 58.81           N  
ATOM    190  CA  VAL    25      26.314  42.319  73.595  1.00 57.45           C  
ATOM    191  C   VAL    25      25.838  40.880  73.800  1.00 57.93           C  
ATOM    192  O   VAL    25      24.808  40.483  73.197  1.00 57.90           O  
ATOM    193  CB  VAL    25      25.819  43.293  74.708  1.00 57.29           C  
ATOM    194  CG1 VAL    25      26.282  44.692  74.424  1.00 57.65           C  
ATOM    195  CG2 VAL    25      24.329  43.310  74.816  1.00 58.67           C  
ATOM    196  N   ALA    26      26.564  40.088  74.618  1.00 57.17           N  
ATOM    197  CA  ALA    26      26.181  38.702  74.836  1.00 55.78           C  
ATOM    198  C   ALA    26      26.677  38.156  76.173  1.00 56.21           C  
ATOM    199  O   ALA    26      27.692  38.660  76.718  1.00 56.85           O  
ATOM    200  CB  ALA    26      26.707  37.843  73.700  1.00 55.84           C  
ATOM    201  N   ILE    27      25.957  37.134  76.666  1.00 54.82           N  
ATOM    202  CA  ILE    27      26.373  36.215  77.724  1.00 54.97           C  
ATOM    203  C   ILE    27      26.665  34.880  77.036  1.00 55.40           C  
ATOM    204  O   ILE    27      25.875  34.388  76.208  1.00 55.50           O  
ATOM    205  CB  ILE    27      25.204  35.998  78.727  1.00 54.89           C  
ATOM    206  CG1 ILE    27      24.675  37.364  79.201  1.00 58.42           C  
ATOM    207  CG2 ILE    27      25.620  35.224  79.941  1.00 54.79           C  
ATOM    208  CD1 ILE    27      25.763  38.300  79.861  1.00 56.11           C  
ATOM    209  N   ALA    28      27.814  34.304  77.343  1.00 56.24           N  
ATOM    210  CA  ALA    28      28.220  33.025  76.762  1.00 57.33           C  
ATOM    211  C   ALA    28      28.899  32.114  77.789  1.00 58.02           C  
ATOM    212  O   ALA    28      29.500  32.581  78.756  1.00 59.65           O  
ATOM    213  CB  ALA    28      29.165  33.270  75.595  1.00 57.05           C  
ATOM    214  N   THR    29      28.831  30.815  77.549  1.00 58.45           N  
ATOM    215  CA  THR    29      29.438  29.821  78.373  1.00 59.29           C  
ATOM    216  C   THR    29      30.122  28.796  77.461  1.00 60.09           C  
ATOM    217  O   THR    29      30.062  28.945  76.238  1.00 60.75           O  
ATOM    218  CB  THR    29      28.366  29.129  79.253  1.00 59.14           C  
ATOM    219  OG1 THR    29      29.027  28.212  80.107  1.00 62.44           O  
ATOM    220  CG2 THR    29      27.313  28.329  78.420  1.00 59.03           C  
ATOM    221  N   LYS    30      30.752  27.746  78.017  1.00 60.10           N  
ATOM    222  CA  LYS    30      31.294  26.714  77.138  1.00 60.17           C  
ATOM    223  C   LYS    30      30.503  25.423  77.045  1.00 60.24           C  
ATOM    224  O   LYS    30      29.848  24.988  77.989  1.00 60.38           O  
ATOM    225  CB  LYS    30      32.766  26.424  77.403  1.00 59.87           C  
ATOM    226  CG  LYS    30      33.091  25.799  78.698  1.00 58.67           C  
ATOM    227  CD  LYS    30      34.590  25.975  78.926  1.00 56.57           C  
ATOM    228  CE  LYS    30      34.916  25.743  80.373  1.00 62.17           C  
ATOM    229  NZ  LYS    30      34.346  24.439  80.917  1.00 61.02           N  
ATOM    230  N   ASN    31      30.566  24.829  75.867  1.00 60.09           N  
ATOM    231  CA  ASN    31      29.974  23.554  75.632  1.00 60.15           C  
ATOM    232  C   ASN    31      31.129  22.711  75.064  1.00 60.85           C  
ATOM    233  O   ASN    31      31.450  22.809  73.874  1.00 60.33           O  
ATOM    234  CB  ASN    31      28.809  23.697  74.659  1.00 59.81           C  
ATOM    235  CG  ASN    31      28.273  22.369  74.202  1.00 60.90           C  
ATOM    236  OD1 ASN    31      28.415  21.365  74.897  1.00 62.42           O  
ATOM    237  ND2 ASN    31      27.650  22.343  73.028  1.00 62.72           N  
ATOM    238  N   ASP    32      31.768  21.920  75.944  1.00 60.79           N  
ATOM    239  CA  ASP    32      32.969  21.138  75.588  1.00 60.54           C  
ATOM    240  C   ASP    32      34.075  22.119  75.089  1.00 59.98           C  
ATOM    241  O   ASP    32      34.582  22.895  75.888  1.00 61.62           O  
ATOM    242  CB  ASP    32      32.586  20.014  74.598  1.00 60.03           C  
ATOM    243  CG  ASP    32      33.770  19.211  74.127  1.00 61.08           C  
ATOM    244  OD1 ASP    32      34.747  19.094  74.899  1.00 61.78           O  
ATOM    245  OD2 ASP    32      33.727  18.690  72.982  1.00 60.46           O  
ATOM    246  N   ILE    33      34.429  22.136  73.811  1.00 58.31           N  
ATOM    247  CA  ILE    33      35.454  23.066  73.335  1.00 57.06           C  
ATOM    248  C   ILE    33      34.847  24.188  72.442  1.00 58.02           C  
ATOM    249  O   ILE    33      35.556  24.857  71.665  1.00 57.54           O  
ATOM    250  CB  ILE    33      36.537  22.325  72.532  1.00 56.55           C  
ATOM    251  CG1 ILE    33      35.932  21.627  71.325  1.00 53.36           C  
ATOM    252  CG2 ILE    33      37.325  21.324  73.397  1.00 55.34           C  
ATOM    253  CD1 ILE    33      36.969  21.338  70.290  1.00 56.07           C  
ATOM    254  N   TYR    34      33.531  24.347  72.532  1.00 58.02           N  
ATOM    255  CA  TYR    34      32.789  25.305  71.721  1.00 59.60           C  
ATOM    256  C   TYR    34      32.153  26.416  72.587  1.00 60.55           C  
ATOM    257  O   TYR    34      31.805  26.201  73.766  1.00 60.57           O  
ATOM    258  CB  TYR    34      31.702  24.615  70.881  1.00 58.70           C  
ATOM    259  CG  TYR    34      32.255  23.504  70.077  1.00 59.51           C  
ATOM    260  CD1 TYR    34      32.919  23.749  68.863  1.00 62.22           C  
ATOM    261  CD2 TYR    34      32.182  22.198  70.539  1.00 56.56           C  
ATOM    262  CE1 TYR    34      33.483  22.679  68.123  1.00 61.17           C  
ATOM    263  CE2 TYR    34      32.717  21.160  69.832  1.00 56.81           C  
ATOM    264  CZ  TYR    34      33.370  21.398  68.642  1.00 59.90           C  
ATOM    265  OH  TYR    34      33.887  20.328  67.971  1.00 62.06           O  
ATOM    266  N   LEU    35      31.982  27.581  71.980  1.00 60.82           N  
ATOM    267  CA  LEU    35      31.425  28.696  72.682  1.00 62.79           C  
ATOM    268  C   LEU    35      29.913  28.510  72.508  1.00 62.91           C  
ATOM    269  O   LEU    35      29.501  28.106  71.419  1.00 64.79           O  
ATOM    270  CB  LEU    35      31.945  30.022  72.105  1.00 62.74           C  
ATOM    271  CG  LEU    35      31.470  31.295  72.849  1.00 64.45           C  
ATOM    272  CD1 LEU    35      32.360  31.531  74.025  1.00 60.26           C  
ATOM    273  CD2 LEU    35      31.499  32.507  71.931  1.00 64.70           C  
ATOM    274  N   GLN    36      29.144  28.723  73.586  0.70 62.01           N  
ATOM    276  CA  GLN    36      27.698  28.652  73.584  0.70 61.91           C  
ATOM    278  C   GLN    36      27.186  30.009  74.064  0.70 62.05           C  
ATOM    280  O   GLN    36      27.602  30.512  75.114  0.70 60.93           O  
ATOM    282  CB  GLN    36      27.220  27.558  74.527  0.70 61.83           C  
ATOM    284  CG  GLN    36      25.819  27.041  74.247  0.70 63.49           C  
ATOM    286  CD  GLN    36      25.239  26.247  75.415  0.70 63.28           C  
ATOM    288  OE1 GLN    36      25.812  25.265  75.837  0.70 68.16           O  
ATOM    290  NE2 GLN    36      24.103  26.691  75.946  0.70 65.60           N  
ATOM    292  N   TYR    37      26.295  30.613  73.278  1.00 61.85           N  
ATOM    293  CA  TYR    37      25.624  31.862  73.670  1.00 61.15           C  
ATOM    294  C   TYR    37      24.399  31.593  74.494  1.00 59.84           C  
ATOM    295  O   TYR    37      23.619  30.759  74.123  1.00 60.44           O  
ATOM    296  CB  TYR    37      25.248  32.676  72.430  1.00 61.54           C  
ATOM    297  CG  TYR    37      26.466  33.251  71.790  1.00 62.86           C  
ATOM    298  CD1 TYR    37      27.216  34.220  72.442  1.00 60.43           C  
ATOM    299  CD2 TYR    37      26.901  32.809  70.537  1.00 65.34           C  
ATOM    300  CE1 TYR    37      28.366  34.738  71.876  1.00 60.87           C  
ATOM    301  CE2 TYR    37      28.061  33.346  69.965  1.00 62.90           C  
ATOM    302  CZ  TYR    37      28.768  34.301  70.635  1.00 63.13           C  
ATOM    303  OH  TYR    37      29.918  34.831  70.071  1.00 67.04           O  
ATOM    304  N   ILE    38      24.230  32.289  75.610  1.00 59.21           N  
ATOM    305  CA  ILE    38      23.013  32.139  76.463  1.00 58.20           C  
ATOM    306  C   ILE    38      21.998  33.234  76.094  1.00 57.77           C  
ATOM    307  O   ILE    38      20.779  33.008  76.118  1.00 58.35           O  
ATOM    308  CB  ILE    38      23.383  32.227  77.946  1.00 58.32           C  
ATOM    309  CG1 ILE    38      24.010  30.910  78.398  1.00 58.97           C  
ATOM    310  CG2 ILE    38      22.166  32.562  78.833  1.00 58.69           C  
ATOM    311  CD1 ILE    38      24.888  31.011  79.594  1.00 57.72           C  
ATOM    312  N   GLN    39      22.504  34.415  75.721  1.00 55.55           N  
ATOM    313  CA  GLN    39      21.666  35.556  75.381  1.00 54.01           C  
ATOM    314  C   GLN    39      22.493  36.510  74.615  1.00 53.04           C  
ATOM    315  O   GLN    39      23.646  36.769  74.994  1.00 54.10           O  
ATOM    316  CB  GLN    39      21.143  36.318  76.610  1.00 53.35           C  
ATOM    317  CG  GLN    39      20.273  37.518  76.256  1.00 51.78           C  
ATOM    318  CD  GLN    39      18.924  37.104  75.683  1.00 53.58           C  
ATOM    319  OE1 GLN    39      18.125  36.427  76.351  1.00 54.79           O  
ATOM    320  NE2 GLN    39      18.642  37.543  74.460  1.00 51.38           N  
ATOM    321  N   ILE    40      21.872  37.048  73.576  1.00 53.01           N  
ATOM    322  CA  ILE    40      22.460  37.999  72.648  1.00 54.32           C  
ATOM    323  C   ILE    40      21.443  39.089  72.532  1.00 54.45           C  
ATOM    324  O   ILE    40      20.241  38.802  72.387  1.00 53.13           O  
ATOM    325  CB  ILE    40      22.644  37.356  71.237  1.00 54.92           C  
ATOM    326  CG1 ILE    40      23.673  36.232  71.341  1.00 56.91           C  
ATOM    327  CG2 ILE    40      23.088  38.411  70.174  1.00 53.95           C  
ATOM    328  CD1 ILE    40      23.497  35.220  70.200  1.00 62.70           C  
ATOM    329  N   ILE    41      21.916  40.324  72.646  1.00 54.89           N  
ATOM    330  CA  ILE    41      21.146  41.479  72.242  1.00 56.47           C  
ATOM    331  C   ILE    41      21.851  42.189  71.064  1.00 57.24           C  
ATOM    332  O   ILE    41      23.010  42.600  71.162  1.00 56.09           O  
ATOM    333  CB  ILE    41      20.922  42.413  73.437  1.00 57.58           C  
ATOM    334  CG1 ILE    41      20.309  41.618  74.606  1.00 56.84           C  
ATOM    335  CG2 ILE    41      20.059  43.630  73.025  1.00 56.15           C  
ATOM    336  CD1 ILE    41      20.249  42.418  75.898  1.00 57.64           C  
ATOM    337  N   GLU    42      21.150  42.275  69.930  0.50 58.60           N  
ATOM    339  CA  GLU    42      21.737  42.779  68.677  0.50 59.91           C  
ATOM    341  C   GLU    42      21.887  44.290  68.699  0.50 59.38           C  
ATOM    343  O   GLU    42      21.031  45.008  69.225  0.50 60.09           O  
ATOM    345  CB  GLU    42      20.937  42.327  67.437  0.50 59.70           C  
ATOM    347  CG  GLU    42      21.709  42.516  66.084  0.50 61.58           C  
ATOM    349  CD  GLU    42      21.014  41.884  64.855  0.50 62.17           C  
ATOM    351  OE1 GLU    42      21.072  40.629  64.699  0.50 64.45           O  
ATOM    353  OE2 GLU    42      20.432  42.649  64.041  0.50 60.87           O  
ATOM    355  N   SER    43      23.002  44.740  68.141  1.00 59.25           N  
ATOM    356  CA  SER    43      23.355  46.133  67.959  1.00 58.50           C  
ATOM    357  C   SER    43      22.298  46.897  67.185  1.00 58.46           C  
ATOM    358  O   SER    43      21.519  46.314  66.445  1.00 59.01           O  
ATOM    359  CB  SER    43      24.674  46.202  67.167  1.00 57.90           C  
ATOM    360  OG  SER    43      25.051  47.555  66.994  1.00 59.25           O  
ATOM    361  N   VAL    44      22.286  48.217  67.359  1.00 58.06           N  
ATOM    362  CA  VAL    44      21.468  49.108  66.579  1.00 57.11           C  
ATOM    363  C   VAL    44      22.321  49.846  65.533  1.00 56.38           C  
ATOM    364  O   VAL    44      21.790  50.674  64.814  1.00 55.77           O  
ATOM    365  CB  VAL    44      20.806  50.149  67.484  1.00 57.90           C  
ATOM    366  CG1 VAL    44      19.692  49.471  68.322  1.00 59.20           C  
ATOM    367  CG2 VAL    44      21.886  50.864  68.405  1.00 56.67           C  
ATOM    368  N   HIS    45      23.625  49.575  65.457  1.00 54.20           N  
ATOM    369  CA  HIS    45      24.435  50.225  64.413  1.00 54.33           C  
ATOM    370  C   HIS    45      24.166  49.611  63.037  1.00 54.09           C  
ATOM    371  O   HIS    45      23.789  48.445  62.908  1.00 54.12           O  
ATOM    372  CB  HIS    45      25.929  50.109  64.736  1.00 53.49           C  
ATOM    373  CG  HIS    45      26.285  50.704  66.062  1.00 55.56           C  
ATOM    374  ND1 HIS    45      26.153  52.056  66.339  1.00 52.55           N  
ATOM    375  CD2 HIS    45      26.731  50.123  67.205  1.00 55.86           C  
ATOM    376  CE1 HIS    45      26.518  52.280  67.589  1.00 55.53           C  
ATOM    377  NE2 HIS    45      26.884  51.125  68.132  1.00 58.42           N  
ATOM    378  N   ALA    46      24.391  50.392  62.015  1.00 54.07           N  
ATOM    379  CA  ALA    46      24.227  49.917  60.652  1.00 55.35           C  
ATOM    380  C   ALA    46      25.188  48.734  60.377  1.00 55.86           C  
ATOM    381  O   ALA    46      24.779  47.633  59.972  1.00 55.11           O  
ATOM    382  CB  ALA    46      24.506  51.069  59.699  1.00 54.46           C  
ATOM    383  N   LEU    47      26.467  48.962  60.621  1.00 55.28           N  
ATOM    384  CA  LEU    47      27.377  47.918  60.442  1.00 56.25           C  
ATOM    385  C   LEU    47      27.511  47.148  61.767  1.00 57.03           C  
ATOM    386  O   LEU    47      28.034  47.672  62.734  1.00 57.57           O  
ATOM    387  CB  LEU    47      28.693  48.504  59.974  1.00 55.59           C  
ATOM    388  CG  LEU    47      29.831  47.494  59.835  1.00 57.97           C  
ATOM    389  CD1 LEU    47      29.449  46.359  58.803  1.00 54.62           C  
ATOM    390  CD2 LEU    47      31.099  48.273  59.426  1.00 55.91           C  
ATOM    391  N   ARG    48      27.074  45.897  61.817  1.00 58.29           N  
ATOM    392  CA  ARG    48      27.158  45.153  63.069  1.00 59.99           C  
ATOM    393  C   ARG    48      27.398  43.654  62.958  1.00 61.56           C  
ATOM    394  O   ARG    48      27.378  43.087  61.867  1.00 61.63           O  
ATOM    395  CB  ARG    48      25.875  45.345  63.836  1.00 60.62           C  
ATOM    396  CG  ARG    48      24.702  44.576  63.294  1.00 58.36           C  
ATOM    397  CD  ARG    48      23.538  45.335  63.769  1.00 62.40           C  
ATOM    398  NE  ARG    48      22.270  44.850  63.280  1.00 64.49           N  
ATOM    399  CZ  ARG    48      21.233  45.649  63.067  1.00 64.30           C  
ATOM    400  NH1 ARG    48      21.351  46.959  63.281  1.00 63.31           N  
ATOM    401  NH2 ARG    48      20.094  45.141  62.613  1.00 63.51           N  
ATOM    402  N   PHE    49      27.599  43.027  64.115  1.00 63.14           N  
ATOM    403  CA  PHE    49      27.646  41.567  64.221  1.00 65.24           C  
ATOM    404  C   PHE    49      26.239  41.014  64.215  1.00 65.96           C  
ATOM    405  O   PHE    49      25.409  41.464  65.015  1.00 66.23           O  
ATOM    406  CB  PHE    49      28.359  41.136  65.513  1.00 66.03           C  
ATOM    407  CG  PHE    49      29.859  41.075  65.381  1.00 68.58           C  
ATOM    408  CD1 PHE    49      30.680  41.662  66.330  1.00 70.90           C  
ATOM    409  CD2 PHE    49      30.452  40.445  64.290  1.00 70.05           C  
ATOM    410  CE1 PHE    49      32.091  41.589  66.235  1.00 72.91           C  
ATOM    411  CE2 PHE    49      31.845  40.399  64.170  1.00 73.92           C  
ATOM    412  CZ  PHE    49      32.672  40.974  65.173  1.00 70.09           C  
ATOM    413  N   HIS    50      25.962  40.103  63.284  1.00 66.85           N  
ATOM    414  CA  HIS    50      24.758  39.309  63.317  1.00 68.69           C  
ATOM    415  C   HIS    50      25.208  37.896  63.694  1.00 70.93           C  
ATOM    416  O   HIS    50      25.696  37.140  62.841  1.00 72.02           O  
ATOM    417  CB  HIS    50      24.075  39.262  61.959  1.00 68.34           C  
ATOM    418  CG  HIS    50      23.636  40.593  61.434  1.00 66.68           C  
ATOM    419  ND1 HIS    50      24.521  41.613  61.145  1.00 67.30           N  
ATOM    420  CD2 HIS    50      22.408  41.048  61.085  1.00 66.59           C  
ATOM    421  CE1 HIS    50      23.850  42.645  60.650  1.00 69.25           C  
ATOM    422  NE2 HIS    50      22.565  42.327  60.598  1.00 67.09           N  
ATOM    423  N   VAL    51      25.074  37.542  64.969  1.00 72.80           N  
ATOM    424  CA  VAL    51      25.490  36.225  65.440  1.00 74.54           C  
ATOM    425  C   VAL    51      24.566  35.166  64.884  1.00 76.64           C  
ATOM    426  O   VAL    51      23.370  35.197  65.174  1.00 78.19           O  
ATOM    427  CB  VAL    51      25.536  36.112  67.004  1.00 74.55           C  
ATOM    428  CG1 VAL    51      26.104  34.706  67.433  1.00 74.48           C  
ATOM    429  CG2 VAL    51      26.337  37.271  67.630  1.00 70.10           C  
ATOM    430  N   ASP    52      25.115  34.279  64.049  1.00 78.72           N  
ATOM    431  CA  ASP    52      24.439  33.061  63.575  1.00 81.20           C  
ATOM    432  C   ASP    52      24.609  31.950  64.617  1.00 82.80           C  
ATOM    433  O   ASP    52      25.737  31.513  64.892  1.00 83.06           O  
ATOM    434  CB  ASP    52      25.040  32.609  62.241  1.00 81.03           C  
ATOM    435  CG  ASP    52      24.673  31.184  61.876  1.00 83.02           C  
ATOM    436  OD1 ASP    52      23.734  30.577  62.458  1.00 84.81           O  
ATOM    437  OD2 ASP    52      25.347  30.655  60.982  1.00 84.60           O  
ATOM    438  N   GLU    53      23.492  31.484  65.176  1.00 84.68           N  
ATOM    439  CA  GLU    53      23.530  30.555  66.322  1.00 85.92           C  
ATOM    440  C   GLU    53      23.834  29.109  65.886  1.00 85.79           C  
ATOM    441  O   GLU    53      24.435  28.337  66.633  1.00 85.94           O  
ATOM    442  CB  GLU    53      22.220  30.629  67.119  1.00 86.63           C  
ATOM    443  CG  GLU    53      22.102  31.862  68.024  0.60 87.28           C  
ATOM    444  CD  GLU    53      20.726  32.513  67.933  0.60 89.75           C  
ATOM    445  OE1 GLU    53      19.709  31.792  67.794  0.60 90.02           O  
ATOM    446  OE2 GLU    53      20.658  33.760  68.016  0.60 91.66           O  
ATOM    447  N   ASN    54      23.439  28.755  64.670  1.00 85.26           N  
ATOM    448  CA  ASN    54      23.786  27.446  64.124  1.00 84.59           C  
ATOM    449  C   ASN    54      25.318  27.277  63.940  1.00 83.75           C  
ATOM    450  O   ASN    54      25.804  26.162  63.726  1.00 83.96           O  
ATOM    451  CB  ASN    54      23.039  27.208  62.800  0.60 84.69           C  
ATOM    452  CG  ASN    54      22.767  25.720  62.520  0.60 86.08           C  
ATOM    453  OD1 ASN    54      23.307  24.824  63.184  0.60 86.21           O  
ATOM    454  ND2 ASN    54      21.925  25.459  61.519  0.60 86.49           N  
ATOM    455  N   ALA    55      26.067  28.380  64.003  1.00 81.92           N  
ATOM    456  CA  ALA    55      27.524  28.342  63.826  1.00 80.70           C  
ATOM    457  C   ALA    55      28.178  27.586  64.984  1.00 79.23           C  
ATOM    458  O   ALA    55      27.803  27.762  66.133  1.00 79.82           O  
ATOM    459  CB  ALA    55      28.111  29.781  63.712  1.00 80.15           C  
ATOM    460  N   ILE    56      29.151  26.744  64.673  1.00 77.79           N  
ATOM    461  CA  ILE    56      29.908  25.989  65.678  1.00 75.90           C  
ATOM    462  C   ILE    56      31.181  26.767  65.873  1.00 74.50           C  
ATOM    463  O   ILE    56      31.910  26.976  64.913  1.00 74.29           O  
ATOM    464  CB  ILE    56      30.321  24.589  65.149  1.00 76.40           C  
ATOM    465  CG1 ILE    56      29.092  23.763  64.712  1.00 75.34           C  
ATOM    466  CG2 ILE    56      31.187  23.862  66.178  1.00 75.84           C  
ATOM    467  CD1 ILE    56      29.325  22.980  63.417  1.00 77.73           C  
ATOM    468  N   ARG    57      31.487  27.201  67.086  1.00 72.12           N  
ATOM    469  CA  ARG    57      32.693  27.987  67.183  1.00 69.90           C  
ATOM    470  C   ARG    57      33.635  27.565  68.274  1.00 66.50           C  
ATOM    471  O   ARG    57      33.315  27.693  69.445  1.00 66.81           O  
ATOM    472  CB  ARG    57      32.374  29.478  67.250  1.00 70.93           C  
ATOM    473  CG  ARG    57      31.240  29.833  68.125  1.00 76.49           C  
ATOM    474  CD  ARG    57      30.491  31.104  67.618  1.00 84.39           C  
ATOM    475  NE  ARG    57      29.043  30.863  67.752  1.00 89.80           N  
ATOM    476  CZ  ARG    57      28.082  31.417  67.016  1.00 91.00           C  
ATOM    477  NH1 ARG    57      28.343  32.318  66.062  1.00 89.27           N  
ATOM    478  NH2 ARG    57      26.837  31.055  67.262  1.00 94.92           N  
ATOM    479  N   PRO    58      34.812  27.064  67.894  1.00 63.24           N  
ATOM    480  CA  PRO    58      35.795  26.606  68.893  1.00 60.90           C  
ATOM    481  C   PRO    58      36.292  27.734  69.769  1.00 59.63           C  
ATOM    482  O   PRO    58      36.399  28.876  69.317  1.00 58.11           O  
ATOM    483  CB  PRO    58      36.936  26.041  68.045  1.00 60.40           C  
ATOM    484  CG  PRO    58      36.333  25.842  66.652  1.00 61.19           C  
ATOM    485  CD  PRO    58      35.270  26.871  66.507  1.00 62.00           C  
ATOM    486  N   LEU    59      36.609  27.414  71.019  1.00 59.37           N  
ATOM    487  CA  LEU    59      37.029  28.425  72.022  1.00 59.11           C  
ATOM    488  C   LEU    59      38.287  29.220  71.640  1.00 58.79           C  
ATOM    489  O   LEU    59      38.460  30.373  72.082  1.00 57.89           O  
ATOM    490  CB  LEU    59      37.198  27.794  73.415  1.00 58.49           C  
ATOM    491  CG  LEU    59      35.901  27.243  74.025  1.00 59.78           C  
ATOM    492  CD1 LEU    59      36.126  26.407  75.321  1.00 58.03           C  
ATOM    493  CD2 LEU    59      34.899  28.333  74.296  1.00 61.08           C  
ATOM    494  N   THR    60      39.165  28.627  70.834  1.00 58.42           N  
ATOM    495  CA  THR    60      40.355  29.358  70.385  1.00 59.36           C  
ATOM    496  C   THR    60      40.040  30.565  69.445  1.00 60.12           C  
ATOM    497  O   THR    60      40.906  31.385  69.165  1.00 60.01           O  
ATOM    498  CB  THR    60      41.361  28.430  69.673  1.00 59.36           C  
ATOM    499  OG1 THR    60      40.676  27.731  68.642  1.00 59.76           O  
ATOM    500  CG2 THR    60      42.023  27.433  70.630  1.00 56.72           C  
ATOM    501  N   MET    61      38.809  30.682  68.978  1.00 60.58           N  
ATOM    502  CA  MET    61      38.537  31.613  67.887  1.00 62.59           C  
ATOM    503  C   MET    61      37.882  32.922  68.305  1.00 62.66           C  
ATOM    504  O   MET    61      37.505  33.689  67.422  1.00 63.60           O  
ATOM    505  CB  MET    61      37.683  30.942  66.796  1.00 62.56           C  
ATOM    506  CG  MET    61      38.402  29.794  66.080  1.00 67.94           C  
ATOM    507  SD  MET    61      39.847  30.478  64.868  0.90 83.32          SE  
ATOM    508  CE  MET    61      38.659  31.285  63.505  1.00 77.45           C  
ATOM    509  N   SER    62      37.721  33.171  69.610  1.00 61.38           N  
ATOM    510  CA  SER    62      37.147  34.424  70.072  1.00 61.72           C  
ATOM    511  C   SER    62      37.695  34.811  71.425  1.00 62.10           C  
ATOM    512  O   SER    62      38.123  33.954  72.211  1.00 62.73           O  
ATOM    513  CB  SER    62      35.625  34.314  70.193  1.00 61.40           C  
ATOM    514  OG  SER    62      35.327  33.225  71.043  1.00 61.28           O  
ATOM    515  N   SER    63      37.680  36.107  71.713  1.00 62.25           N  
ATOM    516  CA  SER    63      38.120  36.572  73.022  1.00 61.90           C  
ATOM    517  C   SER    63      37.217  35.966  74.109  1.00 61.96           C  
ATOM    518  O   SER    63      37.692  35.658  75.202  1.00 62.43           O  
ATOM    519  CB  SER    63      38.114  38.099  73.078  1.00 61.78           C  
ATOM    520  OG  SER    63      36.778  38.581  72.922  1.00 63.32           O  
ATOM    521  N   ASN    64      35.928  35.765  73.825  1.00 62.05           N  
ATOM    522  CA  ASN    64      35.058  35.037  74.789  1.00 63.21           C  
ATOM    523  C   ASN    64      35.599  33.635  75.064  1.00 62.15           C  
ATOM    524  O   ASN    64      35.608  33.220  76.205  1.00 62.11           O  
ATOM    525  CB  ASN    64      33.632  34.858  74.260  1.00 65.22           C  
ATOM    526  CG  ASN    64      32.778  36.042  74.477  1.00 68.29           C  
ATOM    527  OD1 ASN    64      32.593  36.515  75.600  1.00 79.28           O  
ATOM    528  ND2 ASN    64      32.227  36.524  73.425  1.00 70.86           N  
ATOM    529  N   GLY    65      36.030  32.934  74.000  1.00 60.23           N  
ATOM    530  CA  GLY    65      36.699  31.675  74.116  1.00 60.81           C  
ATOM    531  C   GLY    65      37.903  31.664  75.057  1.00 60.68           C  
ATOM    532  O   GLY    65      37.973  30.840  75.976  1.00 60.10           O  
ATOM    533  N   TRP    66      38.835  32.588  74.856  1.00 60.85           N  
ATOM    534  CA  TRP    66      40.039  32.658  75.709  1.00 60.06           C  
ATOM    535  C   TRP    66      39.646  32.902  77.155  1.00 61.15           C  
ATOM    536  O   TRP    66      40.247  32.351  78.101  1.00 61.99           O  
ATOM    537  CB  TRP    66      40.997  33.752  75.215  1.00 59.30           C  
ATOM    538  CG  TRP    66      41.271  33.740  73.697  1.00 57.28           C  
ATOM    539  CD1 TRP    66      41.269  32.654  72.901  1.00 57.25           C  
ATOM    540  CD2 TRP    66      41.640  34.855  72.848  1.00 57.57           C  
ATOM    541  NE1 TRP    66      41.578  32.999  71.603  1.00 59.16           N  
ATOM    542  CE2 TRP    66      41.805  34.345  71.537  1.00 58.40           C  
ATOM    543  CE3 TRP    66      41.845  36.233  73.066  1.00 57.46           C  
ATOM    544  CZ2 TRP    66      42.141  35.160  70.434  1.00 58.20           C  
ATOM    545  CZ3 TRP    66      42.174  37.045  71.978  1.00 57.05           C  
ATOM    546  CH2 TRP    66      42.321  36.504  70.679  1.00 58.18           C  
ATOM    547  N   MET    67      38.620  33.721  77.354  1.00 61.67           N  
ATOM    548  CA  MET    67      38.196  34.034  78.730  1.00 61.56           C  
ATOM    549  C   MET    67      37.675  32.751  79.398  1.00 61.45           C  
ATOM    550  O   MET    67      38.030  32.471  80.533  1.00 60.34           O  
ATOM    551  CB  MET    67      37.128  35.144  78.733  1.00 62.34           C  
ATOM    552  CG  MET    67      36.847  35.786  80.055  1.00 62.83           C  
ATOM    553  SD  MET    67      38.278  37.022  80.632  0.85 76.26          SE  
ATOM    554  CE  MET    67      38.995  36.079  82.228  1.00 64.02           C  
ATOM    555  N   LEU    68      36.867  31.969  78.669  1.00 61.35           N  
ATOM    556  CA  LEU    68      36.327  30.715  79.196  1.00 61.71           C  
ATOM    557  C   LEU    68      37.367  29.609  79.436  1.00 62.43           C  
ATOM    558  O   LEU    68      37.310  28.891  80.449  1.00 62.05           O  
ATOM    559  CB  LEU    68      35.192  30.211  78.333  1.00 60.42           C  
ATOM    560  CG  LEU    68      34.014  31.190  78.339  1.00 59.67           C  
ATOM    561  CD1 LEU    68      33.203  31.009  77.111  1.00 53.38           C  
ATOM    562  CD2 LEU    68      33.125  31.045  79.587  1.00 56.87           C  
ATOM    563  N   MET    69      38.317  29.487  78.513  1.00 63.63           N  
ATOM    564  CA  MET    69      39.427  28.542  78.640  1.00 64.95           C  
ATOM    565  C   MET    69      40.298  28.887  79.821  1.00 63.85           C  
ATOM    566  O   MET    69      40.834  27.978  80.490  1.00 64.09           O  
ATOM    567  CB  MET    69      40.270  28.585  77.399  1.00 64.13           C  
ATOM    568  CG  MET    69      39.630  27.926  76.207  1.00 66.68           C  
ATOM    569  SD  MET    69      40.939  27.724  74.726  0.80 72.58          SE  
ATOM    570  CE  MET    69      40.747  29.457  73.987  1.00 62.11           C  
ATOM    571  N   SER    70      40.446  30.189  80.094  1.00 62.96           N  
ATOM    572  CA  SER    70      41.251  30.621  81.248  1.00 62.56           C  
ATOM    573  C   SER    70      40.745  30.049  82.590  1.00 61.84           C  
ATOM    574  O   SER    70      41.468  30.041  83.576  1.00 59.67           O  
ATOM    575  CB  SER    70      41.397  32.144  81.294  1.00 62.63           C  
ATOM    576  OG  SER    70      40.243  32.758  81.855  1.00 63.93           O  
ATOM    577  N   THR    71      39.523  29.517  82.591  1.00 62.19           N  
ATOM    578  CA  THR    71      38.983  28.859  83.794  1.00 63.14           C  
ATOM    579  C   THR    71      39.332  27.364  83.967  1.00 63.92           C  
ATOM    580  O   THR    71      39.199  26.839  85.071  1.00 62.99           O  
ATOM    581  CB  THR    71      37.458  29.064  83.955  1.00 62.41           C  
ATOM    582  OG1 THR    71      36.769  28.302  82.965  1.00 62.66           O  
ATOM    583  CG2 THR    71      37.098  30.522  83.810  1.00 61.93           C  
ATOM    584  N   MET    72      39.778  26.694  82.897  1.00 65.08           N  
ATOM    585  CA  MET    72      40.146  25.276  82.957  1.00 67.60           C  
ATOM    586  C   MET    72      41.548  25.007  83.593  1.00 66.23           C  
ATOM    587  O   MET    72      42.373  25.922  83.722  1.00 65.90           O  
ATOM    588  CB  MET    72      40.104  24.668  81.553  1.00 67.24           C  
ATOM    589  CG  MET    72      38.781  24.730  80.785  1.00 68.31           C  
ATOM    590  SD  MET    72      39.303  24.612  78.854  0.83 75.69          SE  
ATOM    591  CE  MET    72      37.549  24.486  78.022  1.00 70.38           C  
ATOM    592  N   ASN    73      41.822  23.756  83.975  1.00 65.62           N  
ATOM    593  CA  ASN    73      43.211  23.352  84.255  1.00 65.21           C  
ATOM    594  C   ASN    73      44.043  23.140  82.967  1.00 64.52           C  
ATOM    595  O   ASN    73      43.489  23.091  81.854  1.00 64.27           O  
ATOM    596  CB  ASN    73      43.283  22.131  85.181  1.00 65.82           C  
ATOM    597  CG  ASN    73      42.587  20.888  84.604  1.00 67.09           C  
ATOM    598  OD1 ASN    73      42.952  20.361  83.538  1.00 64.81           O  
ATOM    599  ND2 ASN    73      41.595  20.394  85.344  1.00 69.28           N  
ATOM    600  N   ASP    74      45.366  23.035  83.110  1.00 63.68           N  
ATOM    601  CA  ASP    74      46.261  23.053  81.935  1.00 63.28           C  
ATOM    602  C   ASP    74      46.104  21.827  81.067  1.00 62.96           C  
ATOM    603  O   ASP    74      46.128  21.926  79.841  1.00 62.13           O  
ATOM    604  CB  ASP    74      47.734  23.235  82.331  1.00 63.20           C  
ATOM    605  CG  ASP    74      48.018  24.603  82.948  1.00 62.80           C  
ATOM    606  OD1 ASP    74      47.344  25.614  82.582  1.00 57.50           O  
ATOM    607  OD2 ASP    74      48.943  24.654  83.805  1.00 63.27           O  
ATOM    608  N   LYS    75      45.951  20.669  81.716  1.00 63.12           N  
ATOM    609  CA  LYS    75      45.617  19.425  81.016  1.00 63.50           C  
ATOM    610  C   LYS    75      44.442  19.643  80.021  1.00 62.99           C  
ATOM    611  O   LYS    75      44.553  19.282  78.838  1.00 62.58           O  
ATOM    612  CB  LYS    75      45.302  18.311  82.018  1.00 64.00           C  
ATOM    613  CG  LYS    75      44.618  17.073  81.419  1.00 66.39           C  
ATOM    614  CD  LYS    75      45.609  16.170  80.682  1.00 68.66           C  
ATOM    615  CE  LYS    75      45.215  14.702  80.810  1.00 69.70           C  
ATOM    616  NZ  LYS    75      44.822  14.371  82.205  1.00 68.07           N  
ATOM    617  N   ALA    76      43.358  20.251  80.518  1.00 62.16           N  
ATOM    618  CA  ALA    76      42.173  20.555  79.738  1.00 61.81           C  
ATOM    619  C   ALA    76      42.404  21.654  78.702  1.00 61.74           C  
ATOM    620  O   ALA    76      41.778  21.620  77.655  1.00 62.13           O  
ATOM    621  CB  ALA    76      40.962  20.889  80.643  1.00 61.24           C  
ATOM    622  N   ILE    77      43.291  22.611  78.960  1.00 61.38           N  
ATOM    623  CA  ILE    77      43.527  23.668  77.966  1.00 61.49           C  
ATOM    624  C   ILE    77      44.270  23.122  76.741  1.00 61.52           C  
ATOM    625  O   ILE    77      43.900  23.431  75.582  1.00 61.15           O  
ATOM    626  CB  ILE    77      44.272  24.870  78.563  1.00 61.79           C  
ATOM    627  CG1 ILE    77      43.304  25.714  79.384  1.00 62.94           C  
ATOM    628  CG2 ILE    77      44.891  25.749  77.483  1.00 61.12           C  
ATOM    629  CD1 ILE    77      44.013  26.581  80.448  1.00 64.59           C  
ATOM    630  N   ASP    78      45.301  22.325  77.025  1.00 60.60           N  
ATOM    631  CA  ASP    78      46.123  21.617  76.035  1.00 60.87           C  
ATOM    632  C   ASP    78      45.265  20.716  75.162  1.00 60.02           C  
ATOM    633  O   ASP    78      45.365  20.782  73.944  1.00 60.82           O  
ATOM    634  CB  ASP    78      47.235  20.818  76.743  1.00 61.04           C  
ATOM    635  CG  ASP    78      48.164  20.069  75.768  1.00 63.40           C  
ATOM    636  OD1 ASP    78      49.198  20.665  75.346  1.00 64.85           O  
ATOM    637  OD2 ASP    78      47.897  18.863  75.476  1.00 63.02           O  
ATOM    638  N   ASN    79      44.386  19.920  75.764  1.00 58.88           N  
ATOM    639  CA  ASN    79      43.433  19.133  74.969  1.00 58.94           C  
ATOM    640  C   ASN    79      42.545  20.000  74.060  1.00 58.14           C  
ATOM    641  O   ASN    79      42.268  19.633  72.918  1.00 57.90           O  
ATOM    642  CB  ASN    79      42.566  18.223  75.848  1.00 59.09           C  
ATOM    643  CG  ASN    79      43.241  16.904  76.173  1.00 62.16           C  
ATOM    644  OD1 ASN    79      43.004  16.335  77.229  1.00 68.10           O  
ATOM    645  ND2 ASN    79      44.111  16.423  75.286  1.00 64.79           N  
ATOM    646  N   THR    80      42.128  21.144  74.586  1.00 56.98           N  
ATOM    647  CA  THR    80      41.215  22.041  73.923  1.00 56.94           C  
ATOM    648  C   THR    80      41.865  22.679  72.704  1.00 57.00           C  
ATOM    649  O   THR    80      41.270  22.741  71.660  1.00 56.26           O  
ATOM    650  CB  THR    80      40.747  23.142  74.904  1.00 56.98           C  
ATOM    651  OG1 THR    80      40.079  22.527  76.017  1.00 57.25           O  
ATOM    652  CG2 THR    80      39.822  24.144  74.210  1.00 54.70           C  
ATOM    653  N   VAL    81      43.106  23.121  72.845  1.00 57.77           N  
ATOM    654  CA  VAL    81      43.812  23.793  71.760  1.00 58.51           C  
ATOM    655  C   VAL    81      44.132  22.771  70.661  1.00 59.17           C  
ATOM    656  O   VAL    81      43.908  23.026  69.446  1.00 59.51           O  
ATOM    657  CB  VAL    81      45.077  24.485  72.298  1.00 58.47           C  
ATOM    658  CG1 VAL    81      45.956  25.012  71.173  1.00 59.77           C  
ATOM    659  CG2 VAL    81      44.667  25.627  73.229  1.00 58.29           C  
ATOM    660  N   ARG    82      44.650  21.625  71.097  1.00 58.86           N  
ATOM    661  CA  ARG    82      44.843  20.479  70.223  1.00 59.54           C  
ATOM    662  C   ARG    82      43.578  20.079  69.460  1.00 58.76           C  
ATOM    663  O   ARG    82      43.616  19.944  68.232  1.00 58.98           O  
ATOM    664  CB  ARG    82      45.336  19.280  71.016  1.00 59.66           C  
ATOM    665  CG  ARG    82      46.764  19.394  71.436  1.00 62.54           C  
ATOM    666  CD  ARG    82      47.353  18.008  71.689  1.00 68.17           C  
ATOM    667  NE  ARG    82      48.644  18.100  72.370  1.00 72.16           N  
ATOM    668  CZ  ARG    82      49.756  18.641  71.857  1.00 74.78           C  
ATOM    669  NH1 ARG    82      50.854  18.663  72.601  1.00 77.11           N  
ATOM    670  NH2 ARG    82      49.788  19.166  70.627  1.00 74.25           N  
ATOM    671  N   ARG    83      42.471  19.868  70.171  1.00 57.49           N  
ATOM    672  CA  ARG    83      41.263  19.414  69.504  1.00 56.42           C  
ATOM    673  C   ARG    83      40.747  20.521  68.593  1.00 57.09           C  
ATOM    674  O   ARG    83      40.403  20.291  67.422  1.00 57.36           O  
ATOM    675  CB  ARG    83      40.222  19.001  70.508  1.00 55.85           C  
ATOM    676  CG  ARG    83      40.414  17.634  71.086  1.00 52.71           C  
ATOM    677  CD  ARG    83      39.437  17.479  72.198  1.00 49.77           C  
ATOM    678  NE  ARG    83      38.088  17.644  71.693  1.00 50.59           N  
ATOM    679  CZ  ARG    83      36.995  17.770  72.437  1.00 51.09           C  
ATOM    680  NH1 ARG    83      35.796  17.947  71.861  1.00 52.66           N  
ATOM    681  NH2 ARG    83      37.089  17.758  73.743  1.00 48.77           N  
ATOM    682  N   ALA    84      40.759  21.740  69.114  1.00 56.57           N  
ATOM    683  CA  ALA    84      40.339  22.870  68.356  1.00 56.57           C  
ATOM    684  C   ALA    84      41.197  23.105  67.084  1.00 57.76           C  
ATOM    685  O   ALA    84      40.669  23.593  66.068  1.00 57.61           O  
ATOM    686  CB  ALA    84      40.286  24.127  69.264  1.00 55.96           C  
ATOM    687  N   ASN    85      42.490  22.782  67.118  1.00 58.24           N  
ATOM    688  CA  ASN    85      43.273  22.956  65.905  1.00 60.37           C  
ATOM    689  C   ASN    85      42.833  22.048  64.775  1.00 60.82           C  
ATOM    690  O   ASN    85      42.806  22.477  63.633  1.00 60.37           O  
ATOM    691  CB  ASN    85      44.775  22.831  66.141  1.00 60.47           C  
ATOM    692  CG  ASN    85      45.333  24.018  66.874  1.00 62.26           C  
ATOM    693  OD1 ASN    85      44.775  25.138  66.813  1.00 63.47           O  
ATOM    694  ND2 ASN    85      46.422  23.794  67.594  1.00 60.57           N  
ATOM    695  N   THR    86      42.459  20.806  65.091  1.00 61.75           N  
ATOM    696  CA  THR    86      42.035  19.873  64.035  1.00 62.30           C  
ATOM    697  C   THR    86      40.785  20.329  63.280  1.00 63.07           C  
ATOM    698  O   THR    86      40.472  19.804  62.212  1.00 63.65           O  
ATOM    699  CB  THR    86      41.828  18.456  64.559  1.00 62.23           C  
ATOM    700  OG1 THR    86      40.606  18.376  65.330  1.00 61.94           O  
ATOM    701  CG2 THR    86      43.042  18.049  65.370  1.00 60.63           C  
ATOM    702  N   ILE    87      40.077  21.290  63.854  1.00 63.43           N  
ATOM    703  CA  ILE    87      38.855  21.778  63.286  1.00 64.20           C  
ATOM    704  C   ILE    87      39.097  23.083  62.491  1.00 65.71           C  
ATOM    705  O   ILE    87      38.612  23.241  61.347  1.00 66.80           O  
ATOM    706  CB  ILE    87      37.839  22.037  64.409  1.00 64.04           C  
ATOM    707  CG1 ILE    87      37.428  20.720  65.060  1.00 64.25           C  
ATOM    708  CG2 ILE    87      36.622  22.825  63.896  1.00 61.32           C  
ATOM    709  CD1 ILE    87      36.579  20.902  66.315  1.00 64.40           C  
ATOM    710  N   THR    88      39.830  24.013  63.109  1.00 65.78           N  
ATOM    711  CA  THR    88      40.080  25.292  62.519  1.00 65.90           C  
ATOM    712  C   THR    88      41.104  25.172  61.410  1.00 67.94           C  
ATOM    713  O   THR    88      41.161  26.035  60.520  1.00 68.74           O  
ATOM    714  CB  THR    88      40.510  26.352  63.552  1.00 65.51           C  
ATOM    715  OG1 THR    88      41.762  26.000  64.153  1.00 62.03           O  
ATOM    716  CG2 THR    88      39.449  26.507  64.601  1.00 62.86           C  
ATOM    717  N   GLN    89      41.891  24.109  61.435  1.00 69.42           N  
ATOM    718  CA  GLN    89      42.896  23.928  60.401  1.00 72.17           C  
ATOM    719  C   GLN    89      42.322  23.397  59.095  1.00 73.16           C  
ATOM    720  O   GLN    89      43.009  23.403  58.065  1.00 73.16           O  
ATOM    721  CB  GLN    89      44.039  23.048  60.878  1.00 72.31           C  
ATOM    722  CG  GLN    89      43.839  21.604  60.590  1.00 74.64           C  
ATOM    723  CD  GLN    89      45.043  20.815  61.004  1.00 79.85           C  
ATOM    724  OE1 GLN    89      46.007  21.388  61.534  1.00 82.02           O  
ATOM    725  NE2 GLN    89      45.011  19.489  60.776  1.00 79.99           N  
ATOM    726  N   LYS    90      41.071  22.948  59.138  1.00 75.07           N  
ATOM    727  CA  LYS    90      40.334  22.613  57.916  1.00 76.91           C  
ATOM    728  C   LYS    90      40.078  23.899  57.120  1.00 77.20           C  
ATOM    729  O   LYS    90      39.646  23.844  55.972  1.00 77.61           O  
ATOM    730  CB  LYS    90      39.009  21.910  58.248  1.00 76.83           C  
ATOM    731  CG  LYS    90      39.163  20.447  58.696  1.00 78.58           C  
ATOM    732  CD  LYS    90      37.796  19.756  58.977  1.00 78.62           C  
ATOM    733  CE  LYS    90      37.079  20.337  60.220  1.00 80.18           C  
ATOM    734  NZ  LYS    90      36.280  19.307  60.970  1.00 78.76           N  
ATOM    735  N   ASP    91      40.348  25.045  57.747  1.00 77.44           N  
ATOM    736  CA  ASP    91      40.246  26.365  57.120  1.00 77.76           C  
ATOM    737  C   ASP    91      41.585  27.103  57.126  1.00 77.52           C  
ATOM    738  O   ASP    91      41.632  28.325  56.987  1.00 77.39           O  
ATOM    739  CB  ASP    91      39.208  27.222  57.867  1.00 78.38           C  
ATOM    740  CG  ASP    91      37.829  26.569  57.912  1.00 80.49           C  
ATOM    741  OD1 ASP    91      37.535  25.680  57.065  1.00 82.90           O  
ATOM    742  OD2 ASP    91      37.031  26.950  58.792  1.00 82.18           O  
ATOM    743  N   GLY    92      42.672  26.362  57.299  1.00 77.83           N  
ATOM    744  CA  GLY    92      44.023  26.940  57.329  1.00 78.14           C  
ATOM    745  C   GLY    92      44.409  27.771  58.555  1.00 78.53           C  
ATOM    746  O   GLY    92      45.425  28.465  58.523  1.00 79.06           O  
ATOM    747  N   ILE    93      43.619  27.708  59.627  1.00 78.12           N  
ATOM    748  CA  ILE    93      43.927  28.425  60.856  1.00 78.01           C  
ATOM    749  C   ILE    93      44.383  27.445  61.948  1.00 78.31           C  
ATOM    750  O   ILE    93      43.752  26.410  62.152  1.00 78.15           O  
ATOM    751  CB  ILE    93      42.682  29.204  61.341  1.00 78.66           C  
ATOM    752  CG1 ILE    93      42.101  30.093  60.211  1.00 78.35           C  
ATOM    753  CG2 ILE    93      42.945  29.921  62.713  1.00 76.93           C  
ATOM    754  CD1 ILE    93      43.079  31.140  59.608  1.00 81.98           C  
ATOM    755  N   ARG    94      45.467  27.756  62.653  1.00 78.39           N  
ATOM    756  CA  ARG    94      45.864  26.906  63.778  1.00 79.60           C  
ATOM    757  C   ARG    94      46.863  27.551  64.739  1.00 79.87           C  
ATOM    758  O   ARG    94      47.994  27.826  64.356  1.00 80.34           O  
ATOM    759  CB  ARG    94      46.404  25.546  63.289  1.00 79.45           C  
ATOM    760  CG  ARG    94      47.917  25.471  63.148  1.00 80.34           C  
ATOM    761  CD  ARG    94      48.417  24.130  62.626  1.00 80.98           C  
ATOM    762  NE  ARG    94      48.116  23.009  63.522  1.00 83.82           N  
ATOM    763  CZ  ARG    94      48.738  22.766  64.678  1.00 84.40           C  
ATOM    764  NH1 ARG    94      49.699  23.581  65.130  1.00 83.20           N  
ATOM    765  NH2 ARG    94      48.384  21.703  65.397  1.00 83.66           N  
ATOM    766  N   PHE    95      46.456  27.734  65.994  1.00 80.07           N  
ATOM    767  CA  PHE    95      47.285  28.366  67.031  1.00 80.20           C  
ATOM    768  C   PHE    95      48.290  27.422  67.702  1.00 80.50           C  
ATOM    769  O   PHE    95      47.963  26.281  68.021  1.00 80.42           O  
ATOM    770  CB  PHE    95      46.379  29.004  68.083  1.00 80.47           C  
ATOM    771  CG  PHE    95      45.260  29.821  67.488  1.00 80.99           C  
ATOM    772  CD1 PHE    95      45.473  31.141  67.111  1.00 81.79           C  
ATOM    773  CD2 PHE    95      44.012  29.254  67.261  1.00 80.65           C  
ATOM    774  CE1 PHE    95      44.448  31.894  66.533  1.00 83.00           C  
ATOM    775  CE2 PHE    95      42.980  29.995  66.685  1.00 82.25           C  
ATOM    776  CZ  PHE    95      43.192  31.318  66.327  1.00 82.26           C  
ATOM    777  N   GLU    96      49.522  27.882  67.905  1.00 80.58           N  
ATOM    778  CA  GLU    96      50.494  27.020  68.550  1.00 81.30           C  
ATOM    779  C   GLU    96      50.231  26.970  70.046  1.00 80.62           C  
ATOM    780  O   GLU    96      50.088  28.001  70.710  1.00 80.58           O  
ATOM    781  CB  GLU    96      51.942  27.422  68.240  1.00 82.00           C  
ATOM    782  CG  GLU    96      52.438  27.100  66.785  1.00 85.70           C  
ATOM    783  CD  GLU    96      52.380  25.603  66.391  1.00 88.37           C  
ATOM    784  OE1 GLU    96      53.160  24.794  66.957  1.00 87.64           O  
ATOM    785  OE2 GLU    96      51.555  25.257  65.500  1.00 89.69           O  
ATOM    786  N   VAL    97      50.152  25.751  70.559  1.00 80.00           N  
ATOM    787  CA  VAL    97      49.779  25.512  71.943  1.00 79.52           C  
ATOM    788  C   VAL    97      50.508  26.506  72.853  1.00 79.00           C  
ATOM    789  O   VAL    97      49.884  27.239  73.624  1.00 79.10           O  
ATOM    790  CB  VAL    97      50.003  24.009  72.319  1.00 79.44           C  
ATOM    791  CG1 VAL    97      51.460  23.558  72.020  1.00 81.14           C  
ATOM    792  CG2 VAL    97      49.593  23.714  73.766  1.00 78.94           C  
ATOM    793  N   ASP    98      51.826  26.549  72.704  1.00 78.35           N  
ATOM    794  CA  ASP    98      52.696  27.550  73.308  1.00 77.56           C  
ATOM    795  C   ASP    98      52.109  28.969  73.485  1.00 76.70           C  
ATOM    796  O   ASP    98      51.942  29.435  74.613  1.00 76.47           O  
ATOM    797  CB  ASP    98      53.966  27.631  72.460  0.60 77.75           C  
ATOM    798  CG  ASP    98      55.156  28.053  73.258  0.60 78.16           C  
ATOM    799  OD1 ASP    98      55.026  28.992  74.072  0.60 78.47           O  
ATOM    800  OD2 ASP    98      56.226  27.440  73.072  0.60 79.39           O  
ATOM    801  N   ASP    99      51.786  29.611  72.368  0.60 76.19           N  
ATOM    803  CA  ASP    99      51.334  30.997  72.340  0.60 75.94           C  
ATOM    805  C   ASP    99      49.880  31.178  72.794  0.60 75.52           C  
ATOM    807  O   ASP    99      49.511  32.196  73.385  0.60 75.43           O  
ATOM    809  CB  ASP    99      51.500  31.548  70.923  0.60 76.07           C  
ATOM    811  CG  ASP    99      52.906  31.364  70.386  0.60 76.52           C  
ATOM    813  OD1 ASP    99      53.090  31.409  69.148  0.60 77.25           O  
ATOM    815  OD2 ASP    99      53.830  31.168  71.201  0.60 77.63           O  
ATOM    817  N   MET   100      49.047  30.200  72.489  1.00 75.00           N  
ATOM    818  CA  MET   100      47.674  30.236  72.938  1.00 74.50           C  
ATOM    819  C   MET   100      47.674  30.109  74.478  1.00 73.72           C  
ATOM    820  O   MET   100      47.061  30.907  75.168  1.00 73.25           O  
ATOM    821  CB  MET   100      46.866  29.138  72.262  1.00 74.34           C  
ATOM    822  CG  MET   100      45.425  29.075  72.717  1.00 75.88           C  
ATOM    823  SD  MET   100      44.372  30.641  72.207  0.85 76.98          SE  
ATOM    824  CE  MET   100      44.151  31.437  73.926  1.00 75.18           C  
ATOM    825  N   MET   101      48.427  29.135  74.992  1.00 72.91           N  
ATOM    826  CA  MET   101      48.593  28.908  76.424  1.00 72.12           C  
ATOM    827  C   MET   101      49.163  30.128  77.135  1.00 71.11           C  
ATOM    828  O   MET   101      48.882  30.349  78.288  1.00 70.87           O  
ATOM    829  CB  MET   101      49.515  27.710  76.631  1.00 72.60           C  
ATOM    830  CG  MET   101      49.809  27.395  78.061  1.00 73.93           C  
ATOM    831  SD  MET   101      48.149  26.866  78.967  0.60 77.64          SE  
ATOM    832  CE  MET   101      48.324  24.912  78.642  1.00 75.16           C  
ATOM    833  N   ALA   102      49.978  30.897  76.422  1.00 70.44           N  
ATOM    834  CA  ALA   102      50.494  32.171  76.882  1.00 69.35           C  
ATOM    835  C   ALA   102      49.409  33.231  76.908  1.00 68.45           C  
ATOM    836  O   ALA   102      49.242  33.887  77.920  1.00 68.65           O  
ATOM    837  CB  ALA   102      51.652  32.613  76.008  1.00 69.18           C  
ATOM    838  N   ARG   103      48.670  33.396  75.810  1.00 68.30           N  
ATOM    839  CA  ARG   103      47.555  34.377  75.743  1.00 67.14           C  
ATOM    840  C   ARG   103      46.513  34.122  76.825  1.00 65.74           C  
ATOM    841  O   ARG   103      46.047  35.029  77.483  1.00 65.11           O  
ATOM    842  CB  ARG   103      46.894  34.389  74.352  1.00 67.51           C  
ATOM    843  CG  ARG   103      45.843  35.526  74.092  1.00 69.99           C  
ATOM    844  CD  ARG   103      46.368  36.997  74.358  1.00 77.43           C  
ATOM    845  NE  ARG   103      46.236  37.886  73.177  1.00 81.71           N  
ATOM    846  CZ  ARG   103      45.219  38.730  72.955  1.00 85.14           C  
ATOM    847  NH1 ARG   103      44.228  38.831  73.838  1.00 87.71           N  
ATOM    848  NH2 ARG   103      45.170  39.478  71.844  1.00 85.06           N  
ATOM    849  N   ILE   104      46.155  32.866  77.003  1.00 65.17           N  
ATOM    850  CA  ILE   104      45.250  32.469  78.072  1.00 64.96           C  
ATOM    851  C   ILE   104      45.767  32.813  79.462  1.00 64.64           C  
ATOM    852  O   ILE   104      45.010  33.294  80.291  1.00 64.83           O  
ATOM    853  CB  ILE   104      44.872  30.974  77.981  1.00 64.89           C  
ATOM    854  CG1 ILE   104      43.935  30.769  76.796  1.00 66.45           C  
ATOM    855  CG2 ILE   104      44.174  30.506  79.264  1.00 64.73           C  
ATOM    856  CD1 ILE   104      43.932  29.348  76.238  1.00 70.32           C  
ATOM    857  N   ARG   105      47.046  32.581  79.719  0.60 64.58           N  
ATOM    859  CA  ARG   105      47.571  32.898  81.044  0.60 64.64           C  
ATOM    861  C   ARG   105      47.507  34.418  81.296  0.60 65.04           C  
ATOM    863  O   ARG   105      47.146  34.856  82.401  0.60 65.11           O  
ATOM    865  CB  ARG   105      48.959  32.268  81.268  0.60 64.15           C  
ATOM    867  CG  ARG   105      49.019  30.745  80.916  0.60 62.26           C  
ATOM    869  CD  ARG   105      49.908  29.930  81.861  0.60 59.20           C  
ATOM    871  NE  ARG   105      50.733  28.913  81.192  0.60 56.19           N  
ATOM    873  CZ  ARG   105      50.648  27.599  81.405  0.60 53.93           C  
ATOM    875  NH1 ARG   105      51.453  26.771  80.766  0.60 52.55           N  
ATOM    877  NH2 ARG   105      49.757  27.107  82.249  0.60 52.59           N  
ATOM    879  N   GLN   106      47.782  35.202  80.250  1.00 65.19           N  
ATOM    880  CA  GLN   106      47.661  36.674  80.283  1.00 66.44           C  
ATOM    881  C   GLN   106      46.219  37.148  80.563  1.00 66.11           C  
ATOM    882  O   GLN   106      45.987  38.039  81.370  1.00 65.91           O  
ATOM    883  CB  GLN   106      48.139  37.258  78.936  1.00 66.21           C  
ATOM    884  CG  GLN   106      48.160  38.781  78.873  1.00 68.89           C  
ATOM    885  CD  GLN   106      48.161  39.330  77.451  1.00 69.30           C  
ATOM    886  OE1 GLN   106      47.230  39.099  76.691  1.00 78.30           O  
ATOM    887  NE2 GLN   106      49.198  40.075  77.094  1.00 73.54           N  
ATOM    888  N   VAL   107      45.251  36.538  79.892  1.00 66.18           N  
ATOM    889  CA  VAL   107      43.862  36.931  80.045  1.00 66.70           C  
ATOM    890  C   VAL   107      43.368  36.703  81.494  1.00 67.44           C  
ATOM    891  O   VAL   107      42.708  37.561  82.099  1.00 66.39           O  
ATOM    892  CB  VAL   107      43.007  36.198  79.002  1.00 66.50           C  
ATOM    893  CG1 VAL   107      41.573  35.994  79.503  1.00 66.31           C  
ATOM    894  CG2 VAL   107      43.053  36.959  77.686  1.00 64.13           C  
ATOM    895  N   ARG   108      43.711  35.531  82.025  1.00 68.65           N  
ATOM    896  CA  ARG   108      43.437  35.162  83.410  1.00 69.82           C  
ATOM    897  C   ARG   108      44.035  36.222  84.356  1.00 71.05           C  
ATOM    898  O   ARG   108      43.384  36.638  85.340  1.00 70.77           O  
ATOM    899  CB  ARG   108      43.991  33.751  83.721  1.00 69.62           C  
ATOM    900  CG  ARG   108      43.597  33.210  85.119  1.00 69.62           C  
ATOM    901  CD  ARG   108      44.401  31.981  85.533  1.00 68.90           C  
ATOM    902  NE  ARG   108      44.109  30.834  84.678  1.00 67.11           N  
ATOM    903  CZ  ARG   108      45.010  29.969  84.222  1.00 65.78           C  
ATOM    904  NH1 ARG   108      44.619  28.965  83.441  1.00 62.37           N  
ATOM    905  NH2 ARG   108      46.297  30.107  84.545  1.00 67.13           N  
ATOM    906  N   GLU   109      45.259  36.661  84.034  1.00 72.13           N  
ATOM    907  CA  GLU   109      45.939  37.716  84.794  1.00 73.60           C  
ATOM    908  C   GLU   109      45.204  39.061  84.741  1.00 73.35           C  
ATOM    909  O   GLU   109      44.693  39.530  85.763  1.00 73.58           O  
ATOM    910  CB  GLU   109      47.385  37.880  84.320  1.00 73.60           C  
ATOM    911  CG  GLU   109      48.345  38.293  85.440  1.00 74.84           C  
ATOM    912  CD  GLU   109      49.683  38.819  84.920  1.00 75.40           C  
ATOM    913  OE1 GLU   109      49.694  39.511  83.867  1.00 78.84           O  
ATOM    914  OE2 GLU   109      50.721  38.555  85.572  1.00 75.88           O  
ATOM    915  N   GLN   110      45.117  39.652  83.547  1.00 73.36           N  
ATOM    916  CA  GLN   110      44.529  40.995  83.375  1.00 72.79           C  
ATOM    917  C   GLN   110      43.013  41.152  83.647  1.00 71.55           C  
ATOM    918  O   GLN   110      42.564  42.291  83.828  1.00 71.83           O  
ATOM    919  CB  GLN   110      44.899  41.578  82.006  1.00 72.97           C  
ATOM    920  CG  GLN   110      44.154  40.900  80.880  1.00 74.32           C  
ATOM    921  CD  GLN   110      44.831  41.080  79.538  1.00 75.81           C  
ATOM    922  OE1 GLN   110      46.072  41.145  79.455  1.00 74.48           O  
ATOM    923  NE2 GLN   110      44.016  41.145  78.467  1.00 73.00           N  
ATOM    924  N   GLY   111      42.251  40.048  83.693  1.00 70.23           N  
ATOM    925  CA  GLY   111      40.821  40.054  84.127  1.00 68.74           C  
ATOM    926  C   GLY   111      39.765  40.105  83.019  1.00 68.41           C  
ATOM    927  O   GLY   111      38.535  40.009  83.267  1.00 67.72           O  
ATOM    928  N   TYR   112      40.237  40.245  81.785  1.00 67.60           N  
ATOM    929  CA  TYR   112      39.367  40.447  80.621  1.00 67.38           C  
ATOM    930  C   TYR   112      40.115  40.034  79.362  1.00 66.21           C  
ATOM    931  O   TYR   112      41.348  39.829  79.414  1.00 66.31           O  
ATOM    932  CB  TYR   112      39.012  41.939  80.477  1.00 68.34           C  
ATOM    933  CG  TYR   112      40.254  42.789  80.427  1.00 70.12           C  
ATOM    934  CD1 TYR   112      40.904  43.058  79.212  1.00 72.48           C  
ATOM    935  CD2 TYR   112      40.811  43.296  81.603  1.00 70.44           C  
ATOM    936  CE1 TYR   112      42.092  43.844  79.176  1.00 72.21           C  
ATOM    937  CE2 TYR   112      41.962  44.071  81.575  1.00 72.48           C  
ATOM    938  CZ  TYR   112      42.597  44.334  80.362  1.00 72.07           C  
ATOM    939  OH  TYR   112      43.740  45.103  80.381  1.00 73.81           O  
ATOM    940  N   ALA   113      39.396  39.973  78.232  1.00 63.62           N  
ATOM    941  CA  ALA   113      40.045  39.704  76.957  1.00 62.19           C  
ATOM    942  C   ALA   113      39.529  40.638  75.861  1.00 61.50           C  
ATOM    943  O   ALA   113      38.406  41.113  75.914  1.00 62.63           O  
ATOM    944  CB  ALA   113      39.874  38.221  76.557  1.00 61.70           C  
ATOM    945  N   SER   114      40.363  40.940  74.895  1.00 59.84           N  
ATOM    946  CA  SER   114      39.903  41.583  73.708  1.00 59.77           C  
ATOM    947  C   SER   114      40.680  41.049  72.491  1.00 59.17           C  
ATOM    948  O   SER   114      41.711  40.411  72.631  1.00 58.24           O  
ATOM    949  CB  SER   114      40.004  43.083  73.840  1.00 59.57           C  
ATOM    950  OG  SER   114      41.356  43.445  74.060  1.00 62.96           O  
ATOM    951  N   ALA   115      40.152  41.309  71.306  1.00 59.12           N  
ATOM    952  CA  ALA   115      40.660  40.719  70.093  1.00 59.65           C  
ATOM    953  C   ALA   115      40.253  41.616  68.966  1.00 60.51           C  
ATOM    954  O   ALA   115      39.161  42.214  68.986  1.00 60.26           O  
ATOM    955  CB  ALA   115      40.033  39.339  69.879  1.00 59.03           C  
ATOM    956  N   GLU   116      41.131  41.683  67.979  1.00 61.40           N  
ATOM    957  CA  GLU   116      40.941  42.411  66.748  1.00 62.48           C  
ATOM    958  C   GLU   116      40.932  41.386  65.627  1.00 61.94           C  
ATOM    959  O   GLU   116      41.831  40.534  65.562  1.00 61.71           O  
ATOM    960  CB  GLU   116      42.178  43.242  66.470  1.00 62.91           C  
ATOM    961  CG  GLU   116      42.362  44.501  67.253  1.00 64.87           C  
ATOM    962  CD  GLU   116      43.608  45.273  66.759  1.00 66.94           C  
ATOM    963  OE1 GLU   116      44.407  44.722  65.917  1.00 68.23           O  
ATOM    964  OE2 GLU   116      43.771  46.437  67.224  1.00 72.76           O  
ATOM    965  N   HIS   117      39.970  41.495  64.716  1.00 60.74           N  
ATOM    966  CA  HIS   117      39.988  40.687  63.512  1.00 60.71           C  
ATOM    967  C   HIS   117      39.903  39.218  63.820  1.00 60.41           C  
ATOM    968  O   HIS   117      40.269  38.431  62.958  1.00 60.05           O  
ATOM    969  CB  HIS   117      41.242  40.943  62.639  1.00 60.33           C  
ATOM    970  CG  HIS   117      41.425  42.375  62.226  1.00 62.23           C  
ATOM    971  ND1 HIS   117      40.464  43.092  61.535  1.00 61.62           N  
ATOM    972  CD2 HIS   117      42.476  43.214  62.375  1.00 62.71           C  
ATOM    973  CE1 HIS   117      40.911  44.310  61.292  1.00 62.55           C  
ATOM    974  NE2 HIS   117      42.131  44.410  61.787  1.00 63.71           N  
ATOM    975  N   ILE   118      39.426  38.847  65.023  1.00 60.21           N  
ATOM    976  CA  ILE   118      39.269  37.410  65.396  1.00 59.96           C  
ATOM    977  C   ILE   118      37.957  37.150  66.138  1.00 59.73           C  
ATOM    978  O   ILE   118      37.735  37.670  67.213  1.00 59.45           O  
ATOM    979  CB  ILE   118      40.476  36.841  66.252  1.00 60.60           C  
ATOM    980  CG1 ILE   118      41.818  37.029  65.538  1.00 59.99           C  
ATOM    981  CG2 ILE   118      40.294  35.302  66.526  1.00 60.37           C  
ATOM    982  CD1 ILE   118      43.051  36.832  66.477  1.00 59.96           C  
ATOM    983  N   PRO   119      37.076  36.328  65.576  1.00 59.63           N  
ATOM    984  CA  PRO   119      37.199  35.472  64.393  1.00 60.42           C  
ATOM    985  C   PRO   119      37.065  36.229  63.055  1.00 61.73           C  
ATOM    986  O   PRO   119      37.340  35.635  62.013  1.00 62.71           O  
ATOM    987  CB  PRO   119      36.018  34.497  64.547  1.00 59.89           C  
ATOM    988  CG  PRO   119      34.937  35.379  65.254  1.00 58.78           C  
ATOM    989  CD  PRO   119      35.720  36.306  66.159  1.00 59.32           C  
ATOM    990  N   PHE   120      36.657  37.504  63.051  1.00 61.12           N  
ATOM    991  CA  PHE   120      36.338  38.119  61.762  1.00 61.12           C  
ATOM    992  C   PHE   120      37.054  39.400  61.460  1.00 59.48           C  
ATOM    993  O   PHE   120      37.082  40.301  62.261  1.00 58.42           O  
ATOM    994  CB  PHE   120      34.828  38.341  61.622  1.00 62.74           C  
ATOM    995  CG  PHE   120      34.035  37.086  61.735  1.00 64.36           C  
ATOM    996  CD1 PHE   120      34.295  36.006  60.866  1.00 70.01           C  
ATOM    997  CD2 PHE   120      33.064  36.952  62.726  1.00 65.69           C  
ATOM    998  CE1 PHE   120      33.561  34.780  60.953  1.00 69.09           C  
ATOM    999  CE2 PHE   120      32.304  35.779  62.819  1.00 66.11           C  
ATOM   1000  CZ  PHE   120      32.553  34.681  61.937  1.00 66.98           C  
ATOM   1001  N   VAL   121      37.599  39.469  60.256  1.00 58.64           N  
ATOM   1002  CA  VAL   121      38.232  40.683  59.767  1.00 58.37           C  
ATOM   1003  C   VAL   121      37.274  41.873  59.847  1.00 56.99           C  
ATOM   1004  O   VAL   121      36.136  41.809  59.367  1.00 55.51           O  
ATOM   1005  CB  VAL   121      38.725  40.438  58.336  1.00 59.00           C  
ATOM   1006  CG1 VAL   121      39.244  41.673  57.723  1.00 59.59           C  
ATOM   1007  CG2 VAL   121      39.812  39.386  58.387  1.00 60.30           C  
ATOM   1008  N   GLY   122      37.746  42.924  60.514  1.00 56.40           N  
ATOM   1009  CA  GLY   122      37.050  44.197  60.644  1.00 55.08           C  
ATOM   1010  C   GLY   122      36.289  44.261  61.944  1.00 55.39           C  
ATOM   1011  O   GLY   122      35.644  45.275  62.246  1.00 54.99           O  
ATOM   1012  N   GLY   123      36.351  43.178  62.720  1.00 55.30           N  
ATOM   1013  CA  GLY   123      35.632  43.117  63.990  1.00 56.21           C  
ATOM   1014  C   GLY   123      36.539  43.368  65.186  1.00 57.60           C  
ATOM   1015  O   GLY   123      37.764  43.195  65.105  1.00 58.87           O  
ATOM   1016  N   GLY   124      35.937  43.769  66.299  1.00 57.60           N  
ATOM   1017  CA  GLY   124      36.615  43.964  67.568  1.00 56.76           C  
ATOM   1018  C   GLY   124      35.654  43.511  68.645  1.00 57.59           C  
ATOM   1019  O   GLY   124      34.438  43.674  68.502  1.00 58.68           O  
ATOM   1020  N   THR   125      36.195  42.917  69.702  1.00 57.57           N  
ATOM   1021  CA  THR   125      35.421  42.333  70.759  1.00 58.77           C  
ATOM   1022  C   THR   125      36.159  42.557  72.087  1.00 59.95           C  
ATOM   1023  O   THR   125      37.404  42.665  72.108  1.00 61.11           O  
ATOM   1024  CB  THR   125      35.226  40.815  70.555  1.00 58.50           C  
ATOM   1025  OG1 THR   125      36.504  40.198  70.631  1.00 60.10           O  
ATOM   1026  CG2 THR   125      34.581  40.477  69.179  1.00 57.20           C  
ATOM   1027  N   ILE   126      35.392  42.648  73.174  1.00 59.74           N  
ATOM   1028  CA  ILE   126      35.925  42.817  74.500  1.00 60.47           C  
ATOM   1029  C   ILE   126      35.014  42.026  75.389  1.00 60.96           C  
ATOM   1030  O   ILE   126      33.801  42.116  75.250  1.00 60.86           O  
ATOM   1031  CB  ILE   126      35.861  44.292  74.994  1.00 60.70           C  
ATOM   1032  CG1 ILE   126      36.457  45.265  73.965  1.00 60.18           C  
ATOM   1033  CG2 ILE   126      36.660  44.428  76.323  1.00 61.21           C  
ATOM   1034  CD1 ILE   126      36.173  46.739  74.252  1.00 60.30           C  
ATOM   1035  N   CYS   127      35.571  41.266  76.320  1.00 61.17           N  
ATOM   1036  CA  CYS   127      34.720  40.550  77.246  1.00 61.73           C  
ATOM   1037  C   CYS   127      35.336  40.353  78.631  1.00 60.76           C  
ATOM   1038  O   CYS   127      36.552  40.554  78.825  1.00 61.34           O  
ATOM   1039  CB  CYS   127      34.283  39.220  76.645  1.00 62.64           C  
ATOM   1040  SG  CYS   127      35.571  38.057  76.611  1.00 69.38           S  
ATOM   1041  N   VAL   128      34.479  39.997  79.585  1.00 58.72           N  
ATOM   1042  CA  VAL   128      34.880  39.777  80.954  1.00 57.06           C  
ATOM   1043  C   VAL   128      34.217  38.503  81.459  1.00 57.11           C  
ATOM   1044  O   VAL   128      33.236  38.000  80.900  1.00 56.65           O  
ATOM   1045  CB  VAL   128      34.464  40.968  81.850  1.00 57.55           C  
ATOM   1046  CG1 VAL   128      35.306  42.205  81.547  1.00 55.59           C  
ATOM   1047  CG2 VAL   128      32.963  41.291  81.663  1.00 56.91           C  
ATOM   1048  N   LEU   129      34.762  37.965  82.520  1.00 57.32           N  
ATOM   1049  CA  LEU   129      34.166  36.828  83.172  1.00 58.26           C  
ATOM   1050  C   LEU   129      33.140  37.298  84.224  1.00 58.72           C  
ATOM   1051  O   LEU   129      33.452  38.103  85.104  1.00 58.69           O  
ATOM   1052  CB  LEU   129      35.297  36.031  83.830  1.00 58.55           C  
ATOM   1053  CG  LEU   129      35.015  34.628  84.359  1.00 60.42           C  
ATOM   1054  CD1 LEU   129      34.662  33.655  83.226  1.00 57.69           C  
ATOM   1055  CD2 LEU   129      36.257  34.149  85.121  1.00 58.78           C  
ATOM   1056  N   LEU   130      31.924  36.779  84.156  1.00 59.63           N  
ATOM   1057  CA  LEU   130      30.970  37.026  85.231  1.00 61.00           C  
ATOM   1058  C   LEU   130      31.373  36.302  86.514  1.00 62.52           C  
ATOM   1059  O   LEU   130      32.068  35.286  86.451  1.00 63.24           O  
ATOM   1060  CB  LEU   130      29.555  36.661  84.806  1.00 60.61           C  
ATOM   1061  CG  LEU   130      29.064  37.484  83.618  1.00 58.70           C  
ATOM   1062  CD1 LEU   130      27.610  37.233  83.478  1.00 57.62           C  
ATOM   1063  CD2 LEU   130      29.312  38.951  83.901  1.00 58.50           C  
ATOM   1064  N   PRO   131      30.957  36.833  87.684  1.00 63.60           N  
ATOM   1065  CA  PRO   131      31.330  36.289  88.998  1.00 64.67           C  
ATOM   1066  C   PRO   131      30.677  34.948  89.331  1.00 65.20           C  
ATOM   1067  O   PRO   131      31.135  34.235  90.229  1.00 65.42           O  
ATOM   1068  CB  PRO   131      30.763  37.326  89.982  1.00 64.22           C  
ATOM   1069  CG  PRO   131      30.370  38.477  89.184  1.00 63.35           C  
ATOM   1070  CD  PRO   131      30.083  38.008  87.828  1.00 63.62           C  
ATOM   1071  N   MET   132      29.571  34.647  88.672  1.00 64.99           N  
ATOM   1072  CA  MET   132      28.877  33.427  88.993  1.00 65.15           C  
ATOM   1073  C   MET   132      28.979  32.403  87.850  1.00 64.14           C  
ATOM   1074  O   MET   132      29.414  32.717  86.758  1.00 64.03           O  
ATOM   1075  CB  MET   132      27.415  33.726  89.407  1.00 65.70           C  
ATOM   1076  CG  MET   132      26.390  33.794  88.263  1.00 67.04           C  
ATOM   1077  SD  MET   132      26.750  35.218  87.004  0.45 71.81          SE  
ATOM   1078  CE  MET   132      26.107  36.639  88.129  1.00 67.04           C  
ATOM   1079  N   THR   133      28.592  31.168  88.142  1.00 63.08           N  
ATOM   1080  CA  THR   133      28.539  30.109  87.173  1.00 61.87           C  
ATOM   1081  C   THR   133      27.079  29.821  86.836  1.00 62.29           C  
ATOM   1082  O   THR   133      26.172  30.146  87.590  1.00 62.69           O  
ATOM   1083  CB  THR   133      29.236  28.832  87.733  1.00 62.07           C  
ATOM   1084  OG1 THR   133      28.599  28.425  88.955  1.00 59.30           O  
ATOM   1085  CG2 THR   133      30.761  29.080  87.987  1.00 60.89           C  
ATOM   1086  N   ILE   134      26.850  29.216  85.690  1.00 63.11           N  
ATOM   1087  CA  ILE   134      25.523  28.799  85.289  1.00 64.44           C  
ATOM   1088  C   ILE   134      25.672  27.330  84.911  1.00 65.69           C  
ATOM   1089  O   ILE   134      26.460  26.969  84.044  1.00 66.09           O  
ATOM   1090  CB  ILE   134      24.963  29.704  84.146  1.00 64.14           C  
ATOM   1091  CG1 ILE   134      24.566  31.066  84.723  1.00 63.96           C  
ATOM   1092  CG2 ILE   134      23.773  29.071  83.433  1.00 64.15           C  
ATOM   1093  CD1 ILE   134      24.175  32.136  83.679  1.00 64.32           C  
ATOM   1094  N   GLN   135      24.961  26.482  85.641  1.00 67.44           N  
ATOM   1095  CA  GLN   135      25.018  25.030  85.464  1.00 68.27           C  
ATOM   1096  C   GLN   135      26.423  24.443  85.593  1.00 67.51           C  
ATOM   1097  O   GLN   135      26.840  23.603  84.787  1.00 67.63           O  
ATOM   1098  CB  GLN   135      24.338  24.630  84.142  1.00 69.11           C  
ATOM   1099  CG  GLN   135      22.813  24.426  84.322  1.00 72.21           C  
ATOM   1100  CD  GLN   135      22.075  24.392  83.000  1.00 75.06           C  
ATOM   1101  OE1 GLN   135      22.529  24.981  82.028  1.00 73.98           O  
ATOM   1102  NE2 GLN   135      20.923  23.708  82.961  1.00 76.23           N  
ATOM   1103  N   GLY   136      27.140  24.878  86.627  1.00 66.64           N  
ATOM   1104  CA  GLY   136      28.537  24.478  86.814  1.00 65.45           C  
ATOM   1105  C   GLY   136      29.529  25.084  85.834  1.00 64.78           C  
ATOM   1106  O   GLY   136      30.703  25.058  86.102  1.00 63.55           O  
ATOM   1107  N   GLN   137      29.053  25.633  84.708  1.00 65.31           N  
ATOM   1108  CA  GLN   137      29.912  26.263  83.691  1.00 65.72           C  
ATOM   1109  C   GLN   137      30.233  27.713  84.016  1.00 65.55           C  
ATOM   1110  O   GLN   137      29.358  28.463  84.439  1.00 65.69           O  
ATOM   1111  CB  GLN   137      29.245  26.244  82.302  1.00 66.04           C  
ATOM   1112  CG  GLN   137      29.320  24.909  81.507  1.00 68.78           C  
ATOM   1113  CD  GLN   137      30.440  23.996  82.042  1.00 73.24           C  
ATOM   1114  OE1 GLN   137      31.649  24.242  81.825  1.00 72.76           O  
ATOM   1115  NE2 GLN   137      30.031  22.931  82.759  1.00 73.95           N  
ATOM   1116  N   PRO   138      31.472  28.144  83.744  1.00 65.44           N  
ATOM   1117  CA  PRO   138      31.749  29.578  83.801  1.00 64.98           C  
ATOM   1118  C   PRO   138      31.014  30.351  82.669  1.00 64.36           C  
ATOM   1119  O   PRO   138      30.615  29.763  81.628  1.00 63.62           O  
ATOM   1120  CB  PRO   138      33.259  29.641  83.600  1.00 64.70           C  
ATOM   1121  CG  PRO   138      33.523  28.488  82.688  1.00 65.49           C  
ATOM   1122  CD  PRO   138      32.663  27.395  83.312  1.00 65.94           C  
ATOM   1123  N   VAL   139      30.836  31.652  82.906  1.00 63.46           N  
ATOM   1124  CA  VAL   139      30.024  32.527  82.076  1.00 63.27           C  
ATOM   1125  C   VAL   139      30.742  33.834  81.764  1.00 63.64           C  
ATOM   1126  O   VAL   139      31.472  34.407  82.580  1.00 63.82           O  
ATOM   1127  CB  VAL   139      28.685  32.877  82.751  1.00 63.26           C  
ATOM   1128  CG1 VAL   139      27.728  33.535  81.751  1.00 63.44           C  
ATOM   1129  CG2 VAL   139      28.037  31.626  83.319  1.00 63.48           C  
ATOM   1130  N   THR   140      30.473  34.346  80.581  1.00 63.49           N  
ATOM   1131  CA  THR   140      31.209  35.477  80.094  1.00 62.95           C  
ATOM   1132  C   THR   140      30.239  36.548  79.635  1.00 61.34           C  
ATOM   1133  O   THR   140      29.112  36.253  79.198  1.00 61.41           O  
ATOM   1134  CB  THR   140      32.197  34.962  78.979  1.00 64.09           C  
ATOM   1135  OG1 THR   140      33.315  35.835  78.864  1.00 68.35           O  
ATOM   1136  CG2 THR   140      31.527  34.750  77.625  1.00 61.92           C  
ATOM   1137  N   MET   141      30.651  37.795  79.749  1.00 59.52           N  
ATOM   1138  CA  MET   141      29.865  38.896  79.191  1.00 58.85           C  
ATOM   1139  C   MET   141      30.732  39.738  78.273  1.00 57.63           C  
ATOM   1140  O   MET   141      31.805  40.197  78.662  1.00 56.38           O  
ATOM   1141  CB  MET   141      29.254  39.781  80.295  1.00 58.22           C  
ATOM   1142  CG  MET   141      28.359  40.907  79.768  1.00 57.91           C  
ATOM   1143  SD  MET   141      27.439  41.893  81.189  0.70 63.01          SE  
ATOM   1144  CE  MET   141      29.033  42.290  82.338  1.00 57.79           C  
ATOM   1145  N   GLY   142      30.275  39.939  77.045  1.00 57.51           N  
ATOM   1146  CA  GLY   142      31.113  40.646  76.106  1.00 57.02           C  
ATOM   1147  C   GLY   142      30.376  41.500  75.131  1.00 57.66           C  
ATOM   1148  O   GLY   142      29.155  41.396  75.004  1.00 56.64           O  
ATOM   1149  N   LEU   143      31.124  42.363  74.442  1.00 58.30           N  
ATOM   1150  CA  LEU   143      30.546  43.151  73.380  1.00 58.79           C  
ATOM   1151  C   LEU   143      31.353  43.070  72.088  1.00 58.83           C  
ATOM   1152  O   LEU   143      32.559  42.905  72.119  1.00 58.80           O  
ATOM   1153  CB  LEU   143      30.325  44.594  73.858  1.00 58.35           C  
ATOM   1154  CG  LEU   143      31.521  45.419  74.287  1.00 60.18           C  
ATOM   1155  CD1 LEU   143      32.247  46.006  73.071  1.00 60.49           C  
ATOM   1156  CD2 LEU   143      31.061  46.519  75.206  1.00 59.31           C  
ATOM   1157  N   GLY   144      30.678  43.246  70.953  1.00 58.47           N  
ATOM   1158  CA  GLY   144      31.316  43.101  69.659  1.00 58.24           C  
ATOM   1159  C   GLY   144      30.811  44.138  68.683  1.00 57.94           C  
ATOM   1160  O   GLY   144      29.643  44.516  68.749  1.00 59.01           O  
ATOM   1161  N   GLY   145      31.667  44.613  67.784  1.00 56.39           N  
ATOM   1162  CA  GLY   145      31.205  45.540  66.745  1.00 55.65           C  
ATOM   1163  C   GLY   145      32.309  45.840  65.731  1.00 56.12           C  
ATOM   1164  O   GLY   145      33.329  45.104  65.659  1.00 56.23           O  
ATOM   1165  N   ALA   146      32.124  46.900  64.951  1.00 55.07           N  
ATOM   1166  CA  ALA   146      33.100  47.244  63.899  1.00 55.82           C  
ATOM   1167  C   ALA   146      34.349  47.728  64.624  1.00 56.96           C  
ATOM   1168  O   ALA   146      34.230  48.504  65.612  1.00 57.85           O  
ATOM   1169  CB  ALA   146      32.536  48.330  62.929  1.00 52.69           C  
ATOM   1170  N   LEU   147      35.522  47.281  64.155  1.00 57.64           N  
ATOM   1171  CA  LEU   147      36.793  47.504  64.859  1.00 58.41           C  
ATOM   1172  C   LEU   147      37.061  48.955  65.249  1.00 60.34           C  
ATOM   1173  O   LEU   147      37.500  49.227  66.372  1.00 61.03           O  
ATOM   1174  CB  LEU   147      37.975  46.973  64.060  1.00 58.18           C  
ATOM   1175  CG  LEU   147      39.327  46.949  64.806  1.00 58.18           C  
ATOM   1176  CD1 LEU   147      39.244  46.312  66.199  1.00 57.00           C  
ATOM   1177  CD2 LEU   147      40.342  46.197  64.003  1.00 56.44           C  
ATOM   1178  N   ASP   148      36.797  49.886  64.340  1.00 60.98           N  
ATOM   1179  CA  ASP   148      37.114  51.252  64.594  1.00 62.40           C  
ATOM   1180  C   ASP   148      36.348  51.837  65.779  1.00 62.77           C  
ATOM   1181  O   ASP   148      36.896  52.619  66.589  1.00 62.98           O  
ATOM   1182  CB  ASP   148      36.866  52.052  63.329  1.00 63.29           C  
ATOM   1183  CG  ASP   148      37.999  51.865  62.274  1.00 68.49           C  
ATOM   1184  OD1 ASP   148      39.067  51.262  62.588  1.00 73.90           O  
ATOM   1185  OD2 ASP   148      37.832  52.324  61.114  1.00 73.21           O  
ATOM   1186  N   ARG   149      35.081  51.456  65.871  1.00 62.83           N  
ATOM   1187  CA  ARG   149      34.149  51.928  66.902  1.00 62.86           C  
ATOM   1188  C   ARG   149      34.607  51.373  68.242  1.00 62.96           C  
ATOM   1189  O   ARG   149      34.489  52.006  69.274  1.00 63.58           O  
ATOM   1190  CB  ARG   149      32.755  51.373  66.561  1.00 63.17           C  
ATOM   1191  CG  ARG   149      31.541  52.118  67.062  1.00 62.50           C  
ATOM   1192  CD  ARG   149      30.276  51.705  66.243  1.00 62.20           C  
ATOM   1193  NE  ARG   149      29.948  50.271  66.331  1.00 61.59           N  
ATOM   1194  CZ  ARG   149      29.562  49.509  65.295  1.00 61.95           C  
ATOM   1195  NH1 ARG   149      29.438  50.037  64.069  1.00 61.84           N  
ATOM   1196  NH2 ARG   149      29.264  48.218  65.478  1.00 58.63           N  
ATOM   1197  N   ILE   150      35.138  50.168  68.190  1.00 62.84           N  
ATOM   1198  CA  ILE   150      35.667  49.472  69.337  1.00 62.99           C  
ATOM   1199  C   ILE   150      36.976  50.090  69.814  1.00 63.06           C  
ATOM   1200  O   ILE   150      37.093  50.383  70.996  1.00 63.45           O  
ATOM   1201  CB  ILE   150      35.841  47.972  68.975  1.00 62.89           C  
ATOM   1202  CG1 ILE   150      34.475  47.346  68.679  1.00 61.48           C  
ATOM   1203  CG2 ILE   150      36.605  47.214  70.033  1.00 63.63           C  
ATOM   1204  CD1 ILE   150      33.474  47.515  69.720  1.00 59.06           C  
ATOM   1205  N   LYS   151      37.934  50.291  68.898  1.00 63.12           N  
ATOM   1206  CA  LYS   151      39.214  50.921  69.175  1.00 63.61           C  
ATOM   1207  C   LYS   151      39.027  52.307  69.740  1.00 63.88           C  
ATOM   1208  O   LYS   151      39.786  52.735  70.630  1.00 63.74           O  
ATOM   1209  CB  LYS   151      40.053  51.086  67.903  1.00 64.07           C  
ATOM   1210  CG  LYS   151      40.913  49.913  67.566  1.00 65.79           C  
ATOM   1211  CD  LYS   151      41.621  50.162  66.241  1.00 70.75           C  
ATOM   1212  CE  LYS   151      42.944  49.392  66.164  1.00 71.73           C  
ATOM   1213  NZ  LYS   151      43.159  48.731  64.846  1.00 72.52           N  
ATOM   1214  N   GLN   152      38.044  53.040  69.233  1.00 63.75           N  
ATOM   1215  CA  GLN   152      37.961  54.403  69.698  1.00 64.40           C  
ATOM   1216  C   GLN   152      37.173  54.524  71.007  1.00 64.24           C  
ATOM   1217  O   GLN   152      37.196  55.571  71.640  1.00 64.77           O  
ATOM   1218  CB  GLN   152      37.532  55.387  68.592  1.00 64.61           C  
ATOM   1219  CG  GLN   152      36.062  55.680  68.472  1.00 66.54           C  
ATOM   1220  CD  GLN   152      35.799  57.155  68.274  1.00 69.16           C  
ATOM   1221  OE1 GLN   152      34.813  57.540  67.658  1.00 72.32           O  
ATOM   1222  NE2 GLN   152      36.667  57.994  68.821  1.00 71.10           N  
ATOM   1223  N   ASN   153      36.519  53.453  71.429  1.00 63.29           N  
ATOM   1224  CA  ASN   153      35.780  53.492  72.678  1.00 63.53           C  
ATOM   1225  C   ASN   153      36.295  52.514  73.708  1.00 63.79           C  
ATOM   1226  O   ASN   153      35.654  52.292  74.736  1.00 63.26           O  
ATOM   1227  CB  ASN   153      34.302  53.230  72.425  1.00 63.39           C  
ATOM   1228  CG  ASN   153      33.615  54.397  71.765  1.00 62.56           C  
ATOM   1229  OD1 ASN   153      33.481  55.477  72.343  1.00 61.47           O  
ATOM   1230  ND2 ASN   153      33.163  54.181  70.555  1.00 62.37           N  
ATOM   1231  N   TYR   154      37.468  51.959  73.424  1.00 64.35           N  
ATOM   1232  CA  TYR   154      38.021  50.830  74.154  1.00 64.87           C  
ATOM   1233  C   TYR   154      37.977  51.032  75.673  1.00 64.22           C  
ATOM   1234  O   TYR   154      37.372  50.243  76.398  1.00 65.11           O  
ATOM   1235  CB  TYR   154      39.449  50.536  73.666  1.00 65.57           C  
ATOM   1236  CG  TYR   154      40.047  49.273  74.243  1.00 67.42           C  
ATOM   1237  CD1 TYR   154      39.799  48.022  73.644  1.00 69.26           C  
ATOM   1238  CD2 TYR   154      40.871  49.312  75.385  1.00 67.48           C  
ATOM   1239  CE1 TYR   154      40.352  46.840  74.157  1.00 68.18           C  
ATOM   1240  CE2 TYR   154      41.416  48.131  75.928  1.00 67.78           C  
ATOM   1241  CZ  TYR   154      41.145  46.898  75.308  1.00 69.01           C  
ATOM   1242  OH  TYR   154      41.682  45.711  75.808  1.00 70.29           O  
ATOM   1243  N   ASP   155      38.599  52.082  76.167  1.00 63.00           N  
ATOM   1244  CA  ASP   155      38.617  52.284  77.612  1.00 62.08           C  
ATOM   1245  C   ASP   155      37.215  52.364  78.228  1.00 60.93           C  
ATOM   1246  O   ASP   155      36.955  51.704  79.230  1.00 61.07           O  
ATOM   1247  CB  ASP   155      39.532  53.449  78.004  1.00 62.11           C  
ATOM   1248  CG  ASP   155      41.007  53.150  77.710  1.00 63.68           C  
ATOM   1249  OD1 ASP   155      41.404  51.968  77.752  1.00 63.75           O  
ATOM   1250  OD2 ASP   155      41.782  54.096  77.444  1.00 66.92           O  
ATOM   1251  N   ARG   156      36.325  53.142  77.616  0.50 60.35           N  
ATOM   1253  CA  ARG   156      34.951  53.271  78.098  0.50 59.56           C  
ATOM   1255  C   ARG   156      34.210  51.922  78.085  0.50 59.33           C  
ATOM   1257  O   ARG   156      33.566  51.552  79.074  0.50 59.30           O  
ATOM   1259  CB  ARG   156      34.190  54.348  77.303  0.50 59.35           C  
ATOM   1261  CG  ARG   156      32.709  54.514  77.647  0.50 58.27           C  
ATOM   1263  CD  ARG   156      32.496  54.857  79.123  0.50 58.16           C  
ATOM   1265  NE  ARG   156      31.118  55.273  79.401  0.50 57.16           N  
ATOM   1267  CZ  ARG   156      30.603  55.439  80.621  0.50 53.83           C  
ATOM   1269  NH1 ARG   156      31.333  55.214  81.705  0.50 50.49           N  
ATOM   1271  NH2 ARG   156      29.342  55.825  80.748  0.50 53.96           N  
ATOM   1273  N   TYR   157      34.314  51.183  76.983  1.00 59.03           N  
ATOM   1274  CA  TYR   157      33.636  49.896  76.875  1.00 58.63           C  
ATOM   1275  C   TYR   157      34.152  48.951  77.942  1.00 58.96           C  
ATOM   1276  O   TYR   157      33.389  48.380  78.700  1.00 59.40           O  
ATOM   1277  CB  TYR   157      33.846  49.301  75.510  1.00 59.28           C  
ATOM   1278  CG  TYR   157      33.035  49.900  74.385  1.00 59.29           C  
ATOM   1279  CD1 TYR   157      32.203  51.014  74.566  1.00 57.89           C  
ATOM   1280  CD2 TYR   157      33.158  49.380  73.112  1.00 58.11           C  
ATOM   1281  CE1 TYR   157      31.473  51.549  73.483  1.00 57.38           C  
ATOM   1282  CE2 TYR   157      32.439  49.890  72.052  1.00 58.83           C  
ATOM   1283  CZ  TYR   157      31.606  50.972  72.234  1.00 59.78           C  
ATOM   1284  OH  TYR   157      30.926  51.438  71.110  1.00 62.74           O  
ATOM   1285  N   LEU   158      35.464  48.824  78.045  1.00 59.50           N  
ATOM   1286  CA  LEU   158      36.044  47.981  79.075  1.00 59.86           C  
ATOM   1287  C   LEU   158      35.524  48.348  80.462  1.00 60.16           C  
ATOM   1288  O   LEU   158      35.113  47.467  81.220  1.00 60.78           O  
ATOM   1289  CB  LEU   158      37.562  48.099  79.054  1.00 59.80           C  
ATOM   1290  CG  LEU   158      38.262  47.129  80.008  1.00 60.44           C  
ATOM   1291  CD1 LEU   158      37.858  45.663  79.707  1.00 56.36           C  
ATOM   1292  CD2 LEU   158      39.766  47.334  79.948  1.00 59.85           C  
ATOM   1293  N   GLU   159      35.562  49.641  80.781  1.00 59.61           N  
ATOM   1294  CA  GLU   159      35.161  50.153  82.078  1.00 59.73           C  
ATOM   1295  C   GLU   159      33.742  49.670  82.381  1.00 59.78           C  
ATOM   1296  O   GLU   159      33.489  49.106  83.453  1.00 59.87           O  
ATOM   1297  CB  GLU   159      35.214  51.679  82.056  1.00 59.34           C  
ATOM   1298  CG  GLU   159      35.126  52.335  83.418  1.00 61.40           C  
ATOM   1299  CD  GLU   159      34.879  53.857  83.357  0.70 60.72           C  
ATOM   1300  OE1 GLU   159      34.127  54.327  82.466  0.70 63.42           O  
ATOM   1301  OE2 GLU   159      35.421  54.578  84.219  0.70 58.79           O  
ATOM   1302  N   LEU   160      32.818  49.861  81.427  1.00 59.37           N  
ATOM   1303  CA  LEU   160      31.439  49.367  81.576  1.00 58.56           C  
ATOM   1304  C   LEU   160      31.356  47.856  81.818  1.00 58.29           C  
ATOM   1305  O   LEU   160      30.541  47.413  82.616  1.00 59.51           O  
ATOM   1306  CB  LEU   160      30.567  49.737  80.369  1.00 57.95           C  
ATOM   1307  CG  LEU   160      30.347  51.218  80.103  1.00 58.23           C  
ATOM   1308  CD1 LEU   160      29.702  51.460  78.758  1.00 55.29           C  
ATOM   1309  CD2 LEU   160      29.536  51.881  81.245  1.00 56.98           C  
ATOM   1310  N   LEU   161      32.179  47.053  81.159  1.00 56.85           N  
ATOM   1311  CA  LEU   161      32.064  45.623  81.399  1.00 56.27           C  
ATOM   1312  C   LEU   161      32.491  45.340  82.827  1.00 56.63           C  
ATOM   1313  O   LEU   161      31.767  44.702  83.568  1.00 56.98           O  
ATOM   1314  CB  LEU   161      32.873  44.788  80.391  1.00 55.23           C  
ATOM   1315  CG  LEU   161      32.396  44.835  78.945  1.00 53.59           C  
ATOM   1316  CD1 LEU   161      33.466  44.302  77.999  1.00 52.49           C  
ATOM   1317  CD2 LEU   161      31.076  44.077  78.777  1.00 50.92           C  
ATOM   1318  N   LEU   162      33.655  45.845  83.211  1.00 57.06           N  
ATOM   1319  CA  LEU   162      34.197  45.628  84.544  1.00 58.48           C  
ATOM   1320  C   LEU   162      33.282  46.096  85.667  1.00 59.61           C  
ATOM   1321  O   LEU   162      33.264  45.501  86.759  1.00 60.23           O  
ATOM   1322  CB  LEU   162      35.574  46.304  84.700  1.00 58.31           C  
ATOM   1323  CG  LEU   162      36.705  45.644  83.895  1.00 57.84           C  
ATOM   1324  CD1 LEU   162      37.997  46.389  84.102  1.00 58.59           C  
ATOM   1325  CD2 LEU   162      36.901  44.204  84.266  1.00 56.12           C  
ATOM   1326  N   ASN   163      32.542  47.169  85.410  1.00 60.54           N  
ATOM   1327  CA  ASN   163      31.690  47.749  86.439  1.00 62.01           C  
ATOM   1328  C   ASN   163      30.436  46.879  86.527  1.00 62.08           C  
ATOM   1329  O   ASN   163      29.830  46.747  87.593  1.00 61.71           O  
ATOM   1330  CB  ASN   163      31.438  49.239  86.125  1.00 62.45           C  
ATOM   1331  CG  ASN   163      30.150  49.787  86.734  1.00 65.09           C  
ATOM   1332  OD1 ASN   163      30.050  50.022  87.957  1.00 67.46           O  
ATOM   1333  ND2 ASN   163      29.168  50.061  85.862  1.00 65.90           N  
ATOM   1334  N   GLY   164      30.102  46.245  85.397  1.00 62.36           N  
ATOM   1335  CA  GLY   164      28.971  45.325  85.296  1.00 62.20           C  
ATOM   1336  C   GLY   164      29.216  44.094  86.143  1.00 62.33           C  
ATOM   1337  O   GLY   164      28.300  43.587  86.792  1.00 62.50           O  
ATOM   1338  N   VAL   165      30.462  43.636  86.155  1.00 61.66           N  
ATOM   1339  CA  VAL   165      30.900  42.586  87.044  1.00 61.93           C  
ATOM   1340  C   VAL   165      30.706  42.951  88.532  1.00 62.82           C  
ATOM   1341  O   VAL   165      30.158  42.160  89.306  1.00 63.03           O  
ATOM   1342  CB  VAL   165      32.356  42.271  86.742  1.00 61.88           C  
ATOM   1343  CG1 VAL   165      33.024  41.473  87.860  1.00 60.99           C  
ATOM   1344  CG2 VAL   165      32.431  41.557  85.416  1.00 62.26           C  
ATOM   1345  N   GLN   166      31.142  44.149  88.935  1.00 63.51           N  
ATOM   1346  CA  GLN   166      30.938  44.637  90.305  1.00 63.09           C  
ATOM   1347  C   GLN   166      29.471  44.671  90.704  1.00 63.81           C  
ATOM   1348  O   GLN   166      29.126  44.278  91.796  1.00 63.65           O  
ATOM   1349  CB  GLN   166      31.571  46.010  90.467  1.00 62.92           C  
ATOM   1350  CG  GLN   166      33.101  45.969  90.431  1.00 62.83           C  
ATOM   1351  CD  GLN   166      33.682  44.920  91.377  1.00 62.74           C  
ATOM   1352  OE1 GLN   166      34.438  44.038  90.958  1.00 62.14           O  
ATOM   1353  NE2 GLN   166      33.307  44.994  92.653  1.00 62.51           N  
ATOM   1354  N   GLN   167      28.601  45.105  89.800  1.00 64.97           N  
ATOM   1355  CA  GLN   167      27.177  45.100  90.066  1.00 66.64           C  
ATOM   1356  C   GLN   167      26.588  43.715  90.317  1.00 67.34           C  
ATOM   1357  O   GLN   167      25.554  43.602  90.948  1.00 67.90           O  
ATOM   1358  CB  GLN   167      26.417  45.751  88.924  1.00 66.61           C  
ATOM   1359  CG  GLN   167      26.627  47.230  88.784  1.00 68.71           C  
ATOM   1360  CD  GLN   167      25.849  47.782  87.591  1.00 73.66           C  
ATOM   1361  OE1 GLN   167      24.753  48.315  87.760  1.00 78.39           O  
ATOM   1362  NE2 GLN   167      26.397  47.636  86.379  1.00 73.07           N  
ATOM   1363  N   LEU   168      27.233  42.661  89.833  1.00 68.72           N  
ATOM   1364  CA  LEU   168      26.708  41.304  90.031  1.00 69.87           C  
ATOM   1365  C   LEU   168      27.356  40.466  91.131  1.00 71.95           C  
ATOM   1366  O   LEU   168      26.886  39.378  91.409  1.00 72.69           O  
ATOM   1367  CB  LEU   168      26.700  40.502  88.726  1.00 68.81           C  
ATOM   1368  CG  LEU   168      25.923  41.090  87.550  1.00 66.67           C  
ATOM   1369  CD1 LEU   168      26.472  40.555  86.247  1.00 64.39           C  
ATOM   1370  CD2 LEU   168      24.420  40.871  87.662  1.00 64.21           C  
ATOM   1371  N   LYS   169      28.415  40.929  91.769  1.00 74.46           N  
ATOM   1372  CA  LYS   169      28.913  40.198  92.949  1.00 77.56           C  
ATOM   1373  C   LYS   169      27.846  39.801  94.033  1.00 78.83           C  
ATOM   1374  O   LYS   169      28.141  38.998  94.938  1.00 79.44           O  
ATOM   1375  CB  LYS   169      30.106  40.933  93.577  1.00 77.52           C  
ATOM   1376  CG  LYS   169      31.403  40.740  92.790  1.00 78.50           C  
ATOM   1377  CD  LYS   169      32.633  41.233  93.555  1.00 78.42           C  
ATOM   1378  CE  LYS   169      33.945  40.723  92.918  1.00 80.07           C  
ATOM   1379  NZ  LYS   169      35.138  40.771  93.875  1.00 79.99           N  
ATOM   1380  N   LYS   170      26.634  40.359  93.952  0.50 79.57           N  
ATOM   1382  CA  LYS   170      25.538  39.973  94.871  0.50 80.11           C  
ATOM   1384  C   LYS   170      24.549  38.959  94.268  0.50 80.39           C  
ATOM   1386  O   LYS   170      23.591  38.551  94.934  0.50 80.15           O  
ATOM   1388  CB  LYS   170      24.781  41.207  95.387  0.50 80.17           C  
ATOM   1390  CG  LYS   170      25.323  41.807  96.689  0.50 80.36           C  
ATOM   1392  CD  LYS   170      25.130  43.323  96.702  0.50 80.64           C  
ATOM   1394  CE  LYS   170      26.132  43.993  95.748  0.50 81.04           C  
ATOM   1396  NZ  LYS   170      25.532  45.067  94.897  0.50 80.73           N  
ATOM   1398  N   SER   171      24.786  38.562  93.015  1.00 80.70           N  
ATOM   1399  CA  SER   171      23.954  37.549  92.335  1.00 81.42           C  
ATOM   1400  C   SER   171      24.465  36.097  92.432  1.00 81.92           C  
ATOM   1401  O   SER   171      25.649  35.814  92.203  1.00 82.04           O  
ATOM   1402  CB  SER   171      23.759  37.931  90.868  1.00 81.24           C  
ATOM   1403  OG  SER   171      23.207  39.226  90.791  1.00 81.58           O  
ATOM   1404  N   ASP   172      23.545  35.186  92.744  1.00 82.34           N  
ATOM   1405  CA  ASP   172      23.861  33.770  92.943  1.00 82.68           C  
ATOM   1406  C   ASP   172      24.277  33.041  91.674  1.00 82.52           C  
ATOM   1407  O   ASP   172      23.873  33.417  90.568  1.00 82.88           O  
ATOM   1408  CB  ASP   172      22.657  33.062  93.559  1.00 82.79           C  
ATOM   1409  CG  ASP   172      22.438  33.458  95.000  1.00 84.58           C  
ATOM   1410  OD1 ASP   172      23.450  33.670  95.718  1.00 85.73           O  
ATOM   1411  OD2 ASP   172      21.258  33.563  95.417  1.00 86.61           O  
ATOM   1412  N   SER   173      25.096  32.003  91.843  1.00 82.19           N  
ATOM   1413  CA  SER   173      25.301  31.003  90.800  1.00 81.94           C  
ATOM   1414  C   SER   173      24.071  30.069  90.794  1.00 81.85           C  
ATOM   1415  O   SER   173      23.403  29.904  91.826  1.00 81.43           O  
ATOM   1416  CB  SER   173      26.592  30.199  91.050  1.00 81.85           C  
ATOM   1417  OG  SER   173      27.686  31.033  91.420  1.00 81.39           O  
ATOM   1418  N   PHE   174      23.758  29.470  89.644  1.00 81.81           N  
ATOM   1419  CA  PHE   174      22.619  28.543  89.587  1.00 81.63           C  
ATOM   1420  C   PHE   174      22.810  27.343  88.654  1.00 81.91           C  
ATOM   1421  O   PHE   174      23.540  27.415  87.661  1.00 81.37           O  
ATOM   1422  CB  PHE   174      21.292  29.292  89.303  1.00 81.50           C  
ATOM   1423  CG  PHE   174      21.210  29.948  87.929  1.00 79.93           C  
ATOM   1424  CD1 PHE   174      20.686  29.252  86.839  1.00 78.93           C  
ATOM   1425  CD2 PHE   174      21.613  31.277  87.746  1.00 78.89           C  
ATOM   1426  CE1 PHE   174      20.590  29.866  85.571  1.00 79.10           C  
ATOM   1427  CE2 PHE   174      21.518  31.899  86.488  1.00 78.38           C  
ATOM   1428  CZ  PHE   174      21.009  31.192  85.402  1.00 79.22           C  
ATOM   1429  N   HIS   175      22.150  26.239  89.005  1.00 82.82           N  
ATOM   1430  CA  HIS   175      22.171  25.024  88.184  1.00 83.73           C  
ATOM   1431  C   HIS   175      20.784  24.647  87.647  1.00 83.73           C  
ATOM   1432  O   HIS   175      20.188  23.692  88.128  1.00 83.82           O  
ATOM   1433  CB  HIS   175      22.792  23.846  88.952  1.00 83.68           C  
ATOM   1434  CG  HIS   175      23.642  22.961  88.092  1.00 85.07           C  
ATOM   1435  ND1 HIS   175      25.007  22.846  88.258  1.00 86.20           N  
ATOM   1436  CD2 HIS   175      23.328  22.187  87.023  1.00 86.70           C  
ATOM   1437  CE1 HIS   175      25.491  22.015  87.347  1.00 86.84           C  
ATOM   1438  NE2 HIS   175      24.495  21.607  86.580  1.00 86.55           N  
ATOM   1439  N   GLN   176      20.311  25.384  86.631  1.00 84.15           N  
ATOM   1440  CA  GLN   176      18.948  25.260  86.075  1.00 83.95           C  
ATOM   1441  C   GLN   176      18.909  25.379  84.553  1.00 84.23           C  
ATOM   1442  O   GLN   176      17.994  24.871  83.896  1.00 84.64           O  
ATOM   1443  CB  GLN   176      18.045  26.337  86.670  1.00 83.77           C  
ATOM   1444  CG  GLN   176      16.990  25.824  87.634  1.00 83.19           C  
ATOM   1445  CD  GLN   176      17.544  25.260  88.942  1.00 82.37           C  
ATOM   1446  OE1 GLN   176      18.293  25.931  89.668  1.00 82.87           O  
ATOM   1447  NE2 GLN   176      17.149  24.024  89.261  1.00 80.86           N  
END
