
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  135 ( 1033),  selected  135 , name 1j3w_B
# Molecule2: number of CA atoms  176 ( 1390),  selected  176 , name T0412.pdb
# PARAMETERS: 1j3w_B.T0412.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     2_B      S       1           -
LGA    E     3_B      -       -           -
LGA    P     4_B      -       -           -
LGA    S     5_B      -       -           -
LGA    L     6_B      -       -           -
LGA    V     7_B      -       -           -
LGA    L     8_B      N       2           #
LGA    Y     9_B      A       3          5.061
LGA    G    10_B      L       4          2.288
LGA    A    11_B      F       5          2.207
LGA    P    12_B      S       6          1.712
LGA    Y    13_B      S       7          1.494
LGA    E    14_B      R       8          1.869
LGA    R    15_B      D       9          1.744
LGA    A    16_B      I      10          1.109
LGA    V    17_B      L      11          1.243
LGA    E    18_B      E      12          1.420
LGA    V    19_B      V      13          0.976
LGA    L    20_B      L      14          0.956
LGA    E    21_B      Q      15          1.257
LGA    E    22_B      D      16          0.676
LGA    T    23_B      I      17          0.417
LGA    L    24_B      H      18          1.496
LGA    R    25_B      M      19          1.823
LGA    E    26_B      E      20          1.688
LGA    T    27_B      T      21          2.436
LGA    G    28_B      G      22          3.367
LGA    A    29_B      E      23          1.845
LGA    R    30_B      T      24          2.563
LGA    Y    31_B      -       -           -
LGA    A    32_B      V      25          1.143
LGA    L    33_B      A      26          1.157
LGA    L    34_B      I      27          1.225
LGA    I    35_B      A      28          1.303
LGA    D    36_B      T      29          1.675
LGA    R    37_B      K      30          3.541
LGA    K    38_B      N      31          3.301
LGA    -       -      D      32           -
LGA    -       -      I      33           -
LGA    -       -      Y      34           -
LGA    G    39_B      L      35          2.681
LGA    F    40_B      Q      36          2.634
LGA    V    41_B      Y      37          2.147
LGA    L    42_B      I      38          2.447
LGA    A    43_B      Q      39          2.513
LGA    H    44_B      I      40          2.337
LGA    K    45_B      I      41          1.657
LGA    E    46_B      E      42          1.965
LGA    A    47_B      S      43          2.809
LGA    L    48_B      V      44          3.877
LGA    W    49_B      H      45          4.392
LGA    A    50_B      A      46           #
LGA    P    51_B      L      47           #
LGA    -       -      R      48           -
LGA    K    52_B      F      49           #
LGA    P    53_B      H      50          1.047
LGA    P    54_B      V      51          2.656
LGA    P    55_B      D      52          1.380
LGA    L    56_B      E      53          4.153
LGA    D    57_B      N      54           #
LGA    T    58_B      A      55          3.582
LGA    L    59_B      I      56           #
LGA    A    60_B      -       -           -
LGA    T    61_B      R      57          3.670
LGA    L    62_B      P      58          3.615
LGA    V    63_B      -       -           -
LGA    A    64_B      L      59          3.255
LGA    G    65_B      T      60          3.879
LGA    N    66_B      M      61          4.905
LGA    -       -      S      62           -
LGA    -       -      S      63           -
LGA    A    67_B      N      64           #
LGA    -       -      G      65           -
LGA    -       -      W      66           -
LGA    -       -      M      67           -
LGA    -       -      L      68           -
LGA    A    68_B      M      69          2.899
LGA    -       -      S      70           -
LGA    -       -      T      71           -
LGA    -       -      M      72           -
LGA    -       -      N      73           -
LGA    -       -      D      74           -
LGA    -       -      K      75           -
LGA    -       -      A      76           -
LGA    -       -      I      77           -
LGA    -       -      D      78           -
LGA    -       -      N      79           -
LGA    -       -      T      80           -
LGA    -       -      V      81           -
LGA    -       -      R      82           -
LGA    -       -      R      83           -
LGA    -       -      A      84           -
LGA    -       -      N      85           -
LGA    -       -      T      86           -
LGA    -       -      I      87           -
LGA    -       -      T      88           -
LGA    -       -      Q      89           -
LGA    -       -      K      90           -
LGA    -       -      D      91           -
LGA    -       -      G      92           -
LGA    -       -      I      93           -
LGA    -       -      R      94           -
LGA    -       -      F      95           -
LGA    -       -      E      96           -
LGA    -       -      V      97           -
LGA    -       -      D      98           -
LGA    -       -      D      99           -
LGA    A    69_B      M     100          4.956
LGA    T    70_B      M     101          4.026
LGA    Q    71_B      -       -           -
LGA    A    72_B      A     102          4.643
LGA    L    73_B      R     103          4.320
LGA    A    74_B      I     104          4.229
LGA    K    75_B      R     105          4.668
LGA    L    76_B      -       -           -
LGA    L    77_B      -       -           -
LGA    G    78_B      Q     106           #
LGA    E    79_B      -       -           -
LGA    A    80_B      -       -           -
LGA    R    81_B      V     107           #
LGA    F    82_B      R     108          2.482
LGA    Q    83_B      E     109           #
LGA    -       -      Q     110           -
LGA    -       -      G     111           -
LGA    E    84_B      Y     112          1.267
LGA    E    85_B      A     113          1.249
LGA    V    86_B      S     114          1.092
LGA    H    87_B      A     115          0.826
LGA    Q    88_B      E     116          1.903
LGA    G    89_B      H     117          3.390
LGA    E    90_B      I     118           -
LGA    -       -      P     119           -
LGA    -       -      F     120           -
LGA    -       -      V     121           -
LGA    R    91_B      G     122          3.675
LGA    M    92_B      G     123          1.851
LGA    G    93_B      G     124          0.360
LGA    L    94_B      T     125          0.855
LGA    Y    95_B      I     126          0.722
LGA    V    96_B      C     127          1.956
LGA    D    97_B      V     128          1.473
LGA    E    98_B      L     129          1.463
LGA    A    99_B      L     130          1.373
LGA    G   100_B      P     131          2.663
LGA    E   101_B      M     132           #
LGA    -       -      T     133           -
LGA    -       -      I     134           -
LGA    -       -      Q     135           -
LGA    -       -      G     136           -
LGA    H   102_B      Q     137          4.528
LGA    A   103_B      P     138          3.039
LGA    -       -      V     139           -
LGA    L   104_B      T     140          1.327
LGA    L   105_B      M     141          1.323
LGA    V   106_B      G     142          1.921
LGA    L   107_B      L     143          1.022
LGA    V   108_B      G     144          0.587
LGA    F   109_B      G     145          2.010
LGA    D   110_B      A     146          2.063
LGA    -       -      L     147           -
LGA    E   111_B      D     148          3.180
LGA    T   112_B      R     149          3.482
LGA    A   113_B      I     150          4.619
LGA    -       -      K     151           -
LGA    -       -      Q     152           -
LGA    P   114_B      N     153          1.517
LGA    L   115_B      Y     154          1.481
LGA    G   116_B      D     155          1.909
LGA    K   117_B      R     156          1.694
LGA    V   118_B      Y     157          1.104
LGA    K   119_B      L     158          0.782
LGA    L   120_B      E     159          0.949
LGA    H   121_B      L     160          0.470
LGA    G   122_B      L     161          1.507
LGA    K   123_B      L     162          1.312
LGA    R   124_B      N     163          1.478
LGA    A   125_B      G     164          2.071
LGA    S   126_B      V     165          3.303
LGA    E   127_B      Q     166          3.675
LGA    A   128_B      Q     167          3.408
LGA    L   129_B      L     168          4.545
LGA    A   130_B      K     169           #
LGA    R   131_B      K     170          4.550
LGA    I   132_B      S     171          3.011
LGA    A   133_B      -       -           -
LGA    E   134_B      -       -           -
LGA    E   135_B      D     172          0.503
LGA    A   136_B      S     173          3.633
LGA    -       -      F     174           -
LGA    -       -      H     175           -
LGA    -       -      Q     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  135  176    5.0    106    2.63    10.38     39.389     3.888

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.151019 * X  +   0.235581 * Y  +   0.960049 * Z  +  -6.858688
  Y_new =   0.531173 * X  +  -0.799731 * Y  +   0.279797 * Z  +  13.680131
  Z_new =   0.833696 * X  +   0.552207 * Y  +  -0.004360 * Z  +  26.502216 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.578691   -1.562901  [ DEG:    90.4523    -89.5477 ]
  Theta =  -0.985767   -2.155826  [ DEG:   -56.4803   -123.5197 ]
  Phi   =   1.847799   -1.293793  [ DEG:   105.8711    -74.1289 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1j3w_B                                        
REMARK     2: T0412.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1j3w_B.T0412.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  135  176   5.0  106   2.63   10.38  39.389
REMARK  ---------------------------------------------------------- 
MOLECULE 1j3w_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-FEB-03   1J3W              
TITLE     STRUCTURE OF GLIDING PROTEIN-MGLB FROM THERMUS THERMOPHILUS           
TITLE    2 HB8                                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GIDING PROTEIN-MGLB;                                       
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    GLIDING, MOTILITY, MGLB, MUTATIONAL FUNCTION, RIKEN                   
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, STRUCTURAL          
KEYWDS   3 GENOMICS                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.K.LOKANATH,N.KUNISHIMA,M.MIYANO,RIKEN STRUCTURAL                    
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   13-APR-04 1J3W    0                                                
JRNL        AUTH   N.K.LOKANATH,N.KUNISHIMA,M.MIYANO                            
JRNL        TITL   STRUCTURE OF GLIDING PROTEIN-MGLB FROM THERMUS               
JRNL        TITL 2 THERMOPHILUS HB8                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1J3W A    1   163  UNP    Q9X9L0   Q9X9L0_THETH     1    163             
DBREF  1J3W B    1   163  UNP    Q9X9L0   Q9X9L0_THETH     1    163             
DBREF  1J3W C    1   163  UNP    Q9X9L0   Q9X9L0_THETH     1    163             
DBREF  1J3W D    1   163  UNP    Q9X9L0   Q9X9L0_THETH     1    163             
SEQRES   1 A  163  MET VAL GLU PRO SER LEU VAL LEU TYR GLY ALA PRO TYR          
SEQRES   2 A  163  GLU ARG ALA VAL GLU VAL LEU GLU GLU THR LEU ARG GLU          
SEQRES   3 A  163  THR GLY ALA ARG TYR ALA LEU LEU ILE ASP ARG LYS GLY          
SEQRES   4 A  163  PHE VAL LEU ALA HIS LYS GLU ALA LEU TRP ALA PRO LYS          
SEQRES   5 A  163  PRO PRO PRO LEU ASP THR LEU ALA THR LEU VAL ALA GLY          
SEQRES   6 A  163  ASN ALA ALA ALA THR GLN ALA LEU ALA LYS LEU LEU GLY          
SEQRES   7 A  163  GLU ALA ARG PHE GLN GLU GLU VAL HIS GLN GLY GLU ARG          
SEQRES   8 A  163  MET GLY LEU TYR VAL ASP GLU ALA GLY GLU HIS ALA LEU          
SEQRES   9 A  163  LEU VAL LEU VAL PHE ASP GLU THR ALA PRO LEU GLY LYS          
SEQRES  10 A  163  VAL LYS LEU HIS GLY LYS ARG ALA SER GLU ALA LEU ALA          
SEQRES  11 A  163  ARG ILE ALA GLU GLU ALA LEU ALA ASN PRO PRO ARG LEU          
SEQRES  12 A  163  ALA LEU ASP THR GLU TYR ARG GLU GLY ALA GLU ALA LEU          
SEQRES  13 A  163  LEU ASP ASP LEU LEU ARG ASN                                  
SEQRES   1 B  163  MET VAL GLU PRO SER LEU VAL LEU TYR GLY ALA PRO TYR          
SEQRES   2 B  163  GLU ARG ALA VAL GLU VAL LEU GLU GLU THR LEU ARG GLU          
SEQRES   3 B  163  THR GLY ALA ARG TYR ALA LEU LEU ILE ASP ARG LYS GLY          
SEQRES   4 B  163  PHE VAL LEU ALA HIS LYS GLU ALA LEU TRP ALA PRO LYS          
SEQRES   5 B  163  PRO PRO PRO LEU ASP THR LEU ALA THR LEU VAL ALA GLY          
SEQRES   6 B  163  ASN ALA ALA ALA THR GLN ALA LEU ALA LYS LEU LEU GLY          
SEQRES   7 B  163  GLU ALA ARG PHE GLN GLU GLU VAL HIS GLN GLY GLU ARG          
SEQRES   8 B  163  MET GLY LEU TYR VAL ASP GLU ALA GLY GLU HIS ALA LEU          
SEQRES   9 B  163  LEU VAL LEU VAL PHE ASP GLU THR ALA PRO LEU GLY LYS          
SEQRES  10 B  163  VAL LYS LEU HIS GLY LYS ARG ALA SER GLU ALA LEU ALA          
SEQRES  11 B  163  ARG ILE ALA GLU GLU ALA LEU ALA ASN PRO PRO ARG LEU          
SEQRES  12 B  163  ALA LEU ASP THR GLU TYR ARG GLU GLY ALA GLU ALA LEU          
SEQRES  13 B  163  LEU ASP ASP LEU LEU ARG ASN                                  
SEQRES   1 C  163  MET VAL GLU PRO SER LEU VAL LEU TYR GLY ALA PRO TYR          
SEQRES   2 C  163  GLU ARG ALA VAL GLU VAL LEU GLU GLU THR LEU ARG GLU          
SEQRES   3 C  163  THR GLY ALA ARG TYR ALA LEU LEU ILE ASP ARG LYS GLY          
SEQRES   4 C  163  PHE VAL LEU ALA HIS LYS GLU ALA LEU TRP ALA PRO LYS          
SEQRES   5 C  163  PRO PRO PRO LEU ASP THR LEU ALA THR LEU VAL ALA GLY          
SEQRES   6 C  163  ASN ALA ALA ALA THR GLN ALA LEU ALA LYS LEU LEU GLY          
SEQRES   7 C  163  GLU ALA ARG PHE GLN GLU GLU VAL HIS GLN GLY GLU ARG          
SEQRES   8 C  163  MET GLY LEU TYR VAL ASP GLU ALA GLY GLU HIS ALA LEU          
SEQRES   9 C  163  LEU VAL LEU VAL PHE ASP GLU THR ALA PRO LEU GLY LYS          
SEQRES  10 C  163  VAL LYS LEU HIS GLY LYS ARG ALA SER GLU ALA LEU ALA          
SEQRES  11 C  163  ARG ILE ALA GLU GLU ALA LEU ALA ASN PRO PRO ARG LEU          
SEQRES  12 C  163  ALA LEU ASP THR GLU TYR ARG GLU GLY ALA GLU ALA LEU          
SEQRES  13 C  163  LEU ASP ASP LEU LEU ARG ASN                                  
SEQRES   1 D  163  MET VAL GLU PRO SER LEU VAL LEU TYR GLY ALA PRO TYR          
SEQRES   2 D  163  GLU ARG ALA VAL GLU VAL LEU GLU GLU THR LEU ARG GLU          
SEQRES   3 D  163  THR GLY ALA ARG TYR ALA LEU LEU ILE ASP ARG LYS GLY          
SEQRES   4 D  163  PHE VAL LEU ALA HIS LYS GLU ALA LEU TRP ALA PRO LYS          
SEQRES   5 D  163  PRO PRO PRO LEU ASP THR LEU ALA THR LEU VAL ALA GLY          
SEQRES   6 D  163  ASN ALA ALA ALA THR GLN ALA LEU ALA LYS LEU LEU GLY          
SEQRES   7 D  163  GLU ALA ARG PHE GLN GLU GLU VAL HIS GLN GLY GLU ARG          
SEQRES   8 D  163  MET GLY LEU TYR VAL ASP GLU ALA GLY GLU HIS ALA LEU          
SEQRES   9 D  163  LEU VAL LEU VAL PHE ASP GLU THR ALA PRO LEU GLY LYS          
SEQRES  10 D  163  VAL LYS LEU HIS GLY LYS ARG ALA SER GLU ALA LEU ALA          
SEQRES  11 D  163  ARG ILE ALA GLU GLU ALA LEU ALA ASN PRO PRO ARG LEU          
SEQRES  12 D  163  ALA LEU ASP THR GLU TYR ARG GLU GLY ALA GLU ALA LEU          
SEQRES  13 D  163  LEU ASP ASP LEU LEU ARG ASN                                  
HET     MG   1305       1                                                       
HET    SO4   1306       5                                                       
HET    SO4   1307       5                                                       
HET    MES   1303      12                                                       
HET    MES   1304      12                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     SO4 SULFATE ION                                                      
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
FORMUL   5   MG    MG 2+                                                        
FORMUL   6  SO4    2(O4 S 2-)                                                   
FORMUL   8  MES    2(C6 H13 N O4 S)                                             
FORMUL  10  HOH   *553(H2 O)                                                    
CRYST1   99.982  117.186  111.467  90.00  90.00  90.00 C 2 2 21     32          
ATOM   1027  N   VAL B   2      25.804  16.671  77.895  1.00 36.04           N  
ATOM   1028  CA  VAL B   2      26.549  17.767  78.578  1.00 34.93           C  
ATOM   1029  C   VAL B   2      25.621  18.941  78.876  1.00 34.77           C  
ATOM   1030  O   VAL B   2      24.725  19.250  78.093  1.00 35.32           O  
ATOM   1031  CB  VAL B   2      27.723  18.273  77.706  1.00 34.44           C  
ATOM   1032  CG1 VAL B   2      27.198  18.810  76.382  1.00 34.13           C  
ATOM   1033  CG2 VAL B   2      28.499  19.350  78.447  1.00 33.86           C  
ATOM   1034  N   GLU B   3      25.843  19.587  80.015  1.00 34.47           N  
ATOM   1035  CA  GLU B   3      25.030  20.727  80.417  1.00 35.72           C  
ATOM   1036  C   GLU B   3      25.920  21.921  80.744  1.00 35.39           C  
ATOM   1037  O   GLU B   3      27.096  21.761  81.069  1.00 34.71           O  
ATOM   1038  CB  GLU B   3      24.181  20.362  81.638  1.00 37.24           C  
ATOM   1039  CG  GLU B   3      23.207  19.222  81.391  1.00 39.69           C  
ATOM   1040  CD  GLU B   3      22.401  18.861  82.625  1.00 42.13           C  
ATOM   1041  OE1 GLU B   3      21.542  17.958  82.531  1.00 43.72           O  
ATOM   1042  OE2 GLU B   3      22.628  19.477  83.687  1.00 43.52           O  
ATOM   1043  N   PRO B   4      25.368  23.139  80.650  1.00 35.17           N  
ATOM   1044  CA  PRO B   4      26.130  24.356  80.941  1.00 36.15           C  
ATOM   1045  C   PRO B   4      26.550  24.431  82.401  1.00 37.64           C  
ATOM   1046  O   PRO B   4      25.983  23.749  83.256  1.00 37.22           O  
ATOM   1047  CB  PRO B   4      25.150  25.473  80.582  1.00 35.35           C  
ATOM   1048  CG  PRO B   4      24.294  24.857  79.544  1.00 35.35           C  
ATOM   1049  CD  PRO B   4      24.046  23.479  80.102  1.00 35.19           C  
ATOM   1050  N   SER B   5      27.543  25.265  82.681  1.00 39.02           N  
ATOM   1051  CA  SER B   5      27.985  25.456  84.053  1.00 40.49           C  
ATOM   1052  C   SER B   5      27.019  26.376  84.784  1.00 40.26           C  
ATOM   1053  O   SER B   5      27.264  26.866  85.879  1.00 42.05           O  
ATOM   1054  CB  SER B   5      29.381  26.082  84.019  1.00 40.83           C  
ATOM   1055  OG  SER B   5      30.274  25.201  83.339  1.00 42.32           O  
ATOM   1056  N   LEU B   6      25.892  26.627  84.095  1.00 39.41           N  
ATOM   1057  CA  LEU B   6      24.934  27.605  84.574  1.00 37.65           C  
ATOM   1058  C   LEU B   6      23.805  27.783  83.555  1.00 36.17           C  
ATOM   1059  O   LEU B   6      24.001  27.708  82.349  1.00 36.33           O  
ATOM   1060  CB  LEU B   6      25.687  28.925  84.749  1.00 39.34           C  
ATOM   1061  CG  LEU B   6      24.875  29.975  85.507  1.00 40.28           C  
ATOM   1062  CD1 LEU B   6      25.767  31.016  86.188  1.00 40.98           C  
ATOM   1063  CD2 LEU B   6      23.927  30.760  84.599  1.00 40.56           C  
ATOM   1064  N   VAL B   7      22.581  27.973  84.080  1.00 33.42           N  
ATOM   1065  CA  VAL B   7      21.462  28.276  83.194  1.00 32.08           C  
ATOM   1066  C   VAL B   7      20.528  29.313  83.820  1.00 30.15           C  
ATOM   1067  O   VAL B   7      20.124  29.222  84.971  1.00 28.82           O  
ATOM   1068  CB  VAL B   7      20.695  26.985  82.902  1.00 33.26           C  
ATOM   1069  CG1 VAL B   7      21.672  25.863  82.554  1.00 34.92           C  
ATOM   1070  CG2 VAL B   7      19.867  26.580  84.106  1.00 34.43           C  
ATOM   1071  N   LEU B   8      20.213  30.346  83.019  1.00 27.82           N  
ATOM   1072  CA  LEU B   8      19.473  31.469  83.582  1.00 26.10           C  
ATOM   1073  C   LEU B   8      17.972  31.411  83.293  1.00 25.94           C  
ATOM   1074  O   LEU B   8      17.512  31.195  82.176  1.00 24.81           O  
ATOM   1075  CB  LEU B   8      20.072  32.766  83.043  1.00 24.48           C  
ATOM   1076  CG  LEU B   8      21.492  33.009  83.562  1.00 23.47           C  
ATOM   1077  CD1 LEU B   8      22.136  34.258  82.961  1.00 22.38           C  
ATOM   1078  CD2 LEU B   8      21.551  33.184  85.080  1.00 24.19           C  
ATOM   1079  N   TYR B   9      17.211  31.572  84.386  1.00 25.33           N  
ATOM   1080  CA  TYR B   9      15.767  31.692  84.275  1.00 26.80           C  
ATOM   1081  C   TYR B   9      15.229  32.615  85.367  1.00 26.94           C  
ATOM   1082  O   TYR B   9      15.921  32.977  86.309  1.00 27.06           O  
ATOM   1083  CB  TYR B   9      15.166  30.297  84.436  1.00 28.33           C  
ATOM   1084  CG  TYR B   9      15.636  29.704  85.714  1.00 31.05           C  
ATOM   1085  CD1 TYR B   9      16.815  28.966  85.745  1.00 32.75           C  
ATOM   1086  CD2 TYR B   9      14.902  29.888  86.885  1.00 32.01           C  
ATOM   1087  CE1 TYR B   9      17.260  28.417  86.940  1.00 35.17           C  
ATOM   1088  CE2 TYR B   9      15.340  29.331  88.075  1.00 34.03           C  
ATOM   1089  CZ  TYR B   9      16.510  28.592  88.103  1.00 35.97           C  
ATOM   1090  OH  TYR B   9      16.977  28.076  89.293  1.00 37.53           O  
ATOM   1091  N   GLY B  10      13.963  33.008  85.306  1.00 26.34           N  
ATOM   1092  CA  GLY B  10      13.403  33.839  86.357  1.00 25.88           C  
ATOM   1093  C   GLY B  10      14.125  35.151  86.609  1.00 26.33           C  
ATOM   1094  O   GLY B  10      14.512  35.845  85.667  1.00 26.73           O  
ATOM   1095  N   ALA B  11      14.307  35.481  87.887  1.00 25.63           N  
ATOM   1096  CA  ALA B  11      14.959  36.725  88.301  1.00 23.63           C  
ATOM   1097  C   ALA B  11      16.421  36.854  87.887  1.00 23.46           C  
ATOM   1098  O   ALA B  11      16.831  37.897  87.381  1.00 20.75           O  
ATOM   1099  CB  ALA B  11      14.833  36.902  89.817  1.00 24.49           C  
ATOM   1100  N   PRO B  12      17.230  35.808  88.114  1.00 23.02           N  
ATOM   1101  CA  PRO B  12      18.649  35.862  87.740  1.00 23.31           C  
ATOM   1102  C   PRO B  12      18.832  36.200  86.263  1.00 21.49           C  
ATOM   1103  O   PRO B  12      19.675  37.030  85.903  1.00 20.95           O  
ATOM   1104  CB  PRO B  12      19.142  34.459  88.077  1.00 24.52           C  
ATOM   1105  CG  PRO B  12      18.293  34.094  89.258  1.00 24.80           C  
ATOM   1106  CD  PRO B  12      16.925  34.548  88.815  1.00 24.16           C  
ATOM   1107  N   TYR B  13      18.050  35.544  85.410  1.00 21.28           N  
ATOM   1108  CA  TYR B  13      18.116  35.784  83.973  1.00 20.30           C  
ATOM   1109  C   TYR B  13      17.803  37.246  83.692  1.00 19.85           C  
ATOM   1110  O   TYR B  13      18.541  37.920  82.974  1.00 16.59           O  
ATOM   1111  CB  TYR B  13      17.110  34.900  83.222  1.00 21.30           C  
ATOM   1112  CG  TYR B  13      17.046  35.181  81.734  1.00 21.57           C  
ATOM   1113  CD1 TYR B  13      18.022  34.683  80.863  1.00 21.16           C  
ATOM   1114  CD2 TYR B  13      16.043  35.987  81.199  1.00 18.79           C  
ATOM   1115  CE1 TYR B  13      17.996  34.987  79.503  1.00 20.98           C  
ATOM   1116  CE2 TYR B  13      16.011  36.298  79.844  1.00 21.08           C  
ATOM   1117  CZ  TYR B  13      16.990  35.797  78.997  1.00 16.86           C  
ATOM   1118  OH  TYR B  13      16.967  36.123  77.663  1.00 22.83           O  
ATOM   1119  N   GLU B  14      16.705  37.734  84.263  1.00 17.93           N  
ATOM   1120  CA  GLU B  14      16.295  39.118  84.061  1.00 16.73           C  
ATOM   1121  C   GLU B  14      17.357  40.111  84.507  1.00 15.91           C  
ATOM   1122  O   GLU B  14      17.594  41.112  83.836  1.00 15.13           O  
ATOM   1123  CB  GLU B  14      14.991  39.398  84.809  1.00 17.88           C  
ATOM   1124  CG  GLU B  14      13.794  38.668  84.240  1.00 19.63           C  
ATOM   1125  CD  GLU B  14      13.600  38.942  82.760  1.00 22.04           C  
ATOM   1126  OE1 GLU B  14      13.579  40.129  82.372  1.00 27.35           O  
ATOM   1127  OE2 GLU B  14      13.467  37.971  81.989  1.00 21.61           O  
ATOM   1128  N   ARG B  15      17.990  39.847  85.642  1.00 15.74           N  
ATOM   1129  CA  ARG B  15      19.026  40.748  86.125  1.00 15.47           C  
ATOM   1130  C   ARG B  15      20.192  40.749  85.138  1.00 14.59           C  
ATOM   1131  O   ARG B  15      20.766  41.797  84.844  1.00 13.42           O  
ATOM   1132  CB  ARG B  15      19.506  40.320  87.513  1.00 18.03           C  
ATOM   1133  CG  ARG B  15      18.434  40.382  88.598  1.00 22.35           C  
ATOM   1134  CD  ARG B  15      17.893  41.796  88.804  1.00 24.94           C  
ATOM   1135  NE  ARG B  15      16.881  42.180  87.818  1.00 28.62           N  
ATOM   1136  CZ  ARG B  15      15.660  41.655  87.746  1.00 30.08           C  
ATOM   1137  NH1 ARG B  15      15.282  40.711  88.600  1.00 29.99           N  
ATOM   1138  NH2 ARG B  15      14.809  42.079  86.821  1.00 30.16           N  
ATOM   1139  N   ALA B  16      20.525  39.572  84.616  1.00 14.16           N  
ATOM   1140  CA  ALA B  16      21.625  39.448  83.659  1.00 13.23           C  
ATOM   1141  C   ALA B  16      21.298  40.191  82.372  1.00 12.80           C  
ATOM   1142  O   ALA B  16      22.130  40.927  81.837  1.00 11.19           O  
ATOM   1143  CB  ALA B  16      21.893  37.979  83.355  1.00 13.37           C  
ATOM   1144  N   VAL B  17      20.087  39.992  81.867  1.00 14.27           N  
ATOM   1145  CA  VAL B  17      19.670  40.660  80.643  1.00 15.92           C  
ATOM   1146  C   VAL B  17      19.716  42.177  80.802  1.00 15.17           C  
ATOM   1147  O   VAL B  17      20.129  42.892  79.885  1.00 15.21           O  
ATOM   1148  CB  VAL B  17      18.252  40.219  80.237  1.00 20.37           C  
ATOM   1149  CG1 VAL B  17      17.661  41.197  79.245  1.00 22.78           C  
ATOM   1150  CG2 VAL B  17      18.313  38.826  79.633  1.00 20.91           C  
ATOM   1151  N   GLU B  18      19.290  42.673  81.960  1.00 14.50           N  
ATOM   1152  CA  GLU B  18      19.313  44.105  82.214  1.00 15.53           C  
ATOM   1153  C   GLU B  18      20.745  44.630  82.123  1.00 13.93           C  
ATOM   1154  O   GLU B  18      20.985  45.695  81.550  1.00 15.01           O  
ATOM   1155  CB  GLU B  18      18.704  44.401  83.585  1.00 17.44           C  
ATOM   1156  CG  GLU B  18      17.187  44.516  83.539  1.00 23.79           C  
ATOM   1157  CD  GLU B  18      16.531  44.238  84.875  1.00 26.08           C  
ATOM   1158  OE1 GLU B  18      17.163  44.517  85.916  1.00 29.58           O  
ATOM   1159  OE2 GLU B  18      15.378  43.750  84.879  1.00 28.55           O  
ATOM   1160  N   VAL B  19      21.696  43.880  82.675  1.00 12.52           N  
ATOM   1161  CA  VAL B  19      23.093  44.289  82.609  1.00 11.46           C  
ATOM   1162  C   VAL B  19      23.531  44.343  81.146  1.00 10.97           C  
ATOM   1163  O   VAL B  19      24.171  45.305  80.717  1.00 10.84           O  
ATOM   1164  CB  VAL B  19      24.019  43.309  83.361  1.00 12.49           C  
ATOM   1165  CG1 VAL B  19      25.477  43.691  83.124  1.00 13.83           C  
ATOM   1166  CG2 VAL B  19      23.713  43.339  84.855  1.00 15.34           C  
ATOM   1167  N   LEU B  20      23.174  43.321  80.373  1.00 10.66           N  
ATOM   1168  CA  LEU B  20      23.569  43.289  78.966  1.00  9.73           C  
ATOM   1169  C   LEU B  20      22.988  44.457  78.186  1.00 10.19           C  
ATOM   1170  O   LEU B  20      23.693  45.088  77.397  1.00  9.88           O  
ATOM   1171  CB  LEU B  20      23.153  41.966  78.312  1.00  9.54           C  
ATOM   1172  CG  LEU B  20      23.801  40.696  78.875  1.00 10.32           C  
ATOM   1173  CD1 LEU B  20      23.264  39.496  78.127  1.00 12.16           C  
ATOM   1174  CD2 LEU B  20      25.320  40.760  78.750  1.00 10.00           C  
ATOM   1175  N   GLU B  21      21.710  44.750  78.408  1.00 10.23           N  
ATOM   1176  CA  GLU B  21      21.052  45.854  77.720  1.00 12.57           C  
ATOM   1177  C   GLU B  21      21.689  47.195  78.068  1.00 12.08           C  
ATOM   1178  O   GLU B  21      21.947  48.019  77.185  1.00 12.47           O  
ATOM   1179  CB  GLU B  21      19.562  45.878  78.074  1.00 14.30           C  
ATOM   1180  CG  GLU B  21      18.786  44.714  77.483  1.00 20.59           C  
ATOM   1181  CD  GLU B  21      17.374  44.606  78.023  1.00 23.94           C  
ATOM   1182  OE1 GLU B  21      16.575  43.846  77.434  1.00 27.06           O  
ATOM   1183  OE2 GLU B  21      17.063  45.271  79.034  1.00 26.65           O  
ATOM   1184  N   GLU B  22      21.939  47.412  79.353  1.00 11.65           N  
ATOM   1185  CA  GLU B  22      22.550  48.655  79.808  1.00 12.74           C  
ATOM   1186  C   GLU B  22      23.957  48.797  79.238  1.00 12.06           C  
ATOM   1187  O   GLU B  22      24.369  49.885  78.834  1.00 12.01           O  
ATOM   1188  CB  GLU B  22      22.606  48.683  81.338  1.00 15.71           C  
ATOM   1189  CG  GLU B  22      21.234  48.695  81.998  1.00 22.04           C  
ATOM   1190  CD  GLU B  22      21.308  48.499  83.500  1.00 26.34           C  
ATOM   1191  OE1 GLU B  22      20.244  48.528  84.158  1.00 29.26           O  
ATOM   1192  OE2 GLU B  22      22.427  48.313  84.024  1.00 30.07           O  
ATOM   1193  N   THR B  23      24.691  47.690  79.193  1.00 10.17           N  
ATOM   1194  CA  THR B  23      26.055  47.717  78.680  1.00 10.03           C  
ATOM   1195  C   THR B  23      26.081  48.100  77.198  1.00  9.53           C  
ATOM   1196  O   THR B  23      26.966  48.834  76.757  1.00 10.40           O  
ATOM   1197  CB  THR B  23      26.738  46.361  78.917  1.00 10.35           C  
ATOM   1198  OG1 THR B  23      26.727  46.083  80.327  1.00 11.21           O  
ATOM   1199  CG2 THR B  23      28.191  46.391  78.450  1.00 10.88           C  
ATOM   1200  N   LEU B  24      25.110  47.615  76.429  1.00 10.19           N  
ATOM   1201  CA  LEU B  24      25.053  47.974  75.013  1.00  9.92           C  
ATOM   1202  C   LEU B  24      24.844  49.481  74.882  1.00 10.38           C  
ATOM   1203  O   LEU B  24      25.498  50.137  74.074  1.00 11.56           O  
ATOM   1204  CB  LEU B  24      23.915  47.230  74.312  1.00 10.61           C  
ATOM   1205  CG  LEU B  24      24.135  45.729  74.104  1.00 10.43           C  
ATOM   1206  CD1 LEU B  24      22.846  45.097  73.625  1.00 12.79           C  
ATOM   1207  CD2 LEU B  24      25.254  45.498  73.085  1.00 12.76           C  
ATOM   1208  N   ARG B  25      23.933  50.031  75.676  1.00 11.01           N  
ATOM   1209  CA  ARG B  25      23.662  51.463  75.625  1.00 11.95           C  
ATOM   1210  C   ARG B  25      24.864  52.316  76.035  1.00 11.41           C  
ATOM   1211  O   ARG B  25      25.155  53.338  75.406  1.00 13.21           O  
ATOM   1212  CB  ARG B  25      22.462  51.806  76.515  1.00 13.96           C  
ATOM   1213  CG  ARG B  25      21.127  51.332  75.964  1.00 20.59           C  
ATOM   1214  CD  ARG B  25      19.959  51.928  76.741  1.00 24.68           C  
ATOM   1215  NE  ARG B  25      19.752  51.293  78.041  1.00 30.18           N  
ATOM   1216  CZ  ARG B  25      19.235  50.078  78.207  1.00 32.24           C  
ATOM   1217  NH1 ARG B  25      18.870  49.358  77.154  1.00 34.92           N  
ATOM   1218  NH2 ARG B  25      19.077  49.585  79.428  1.00 33.31           N  
ATOM   1219  N   GLU B  26      25.566  51.893  77.080  1.00 11.35           N  
ATOM   1220  CA  GLU B  26      26.721  52.639  77.577  1.00 11.28           C  
ATOM   1221  C   GLU B  26      27.964  52.556  76.702  1.00 11.48           C  
ATOM   1222  O   GLU B  26      28.762  53.490  76.662  1.00 12.78           O  
ATOM   1223  CB  GLU B  26      27.096  52.152  78.984  1.00 11.95           C  
ATOM   1224  CG  GLU B  26      26.037  52.390  80.044  1.00 14.87           C  
ATOM   1225  CD  GLU B  26      26.082  53.788  80.624  1.00 18.49           C  
ATOM   1226  OE1 GLU B  26      26.806  54.650  80.080  1.00 19.04           O  
ATOM   1227  OE2 GLU B  26      25.386  54.025  81.635  1.00 21.84           O  
ATOM   1228  N   THR B  27      28.122  51.437  76.003  1.00 10.57           N  
ATOM   1229  CA  THR B  27      29.310  51.215  75.183  1.00 10.71           C  
ATOM   1230  C   THR B  27      29.183  51.505  73.701  1.00  9.84           C  
ATOM   1231  O   THR B  27      30.169  51.854  73.053  1.00 11.69           O  
ATOM   1232  CB  THR B  27      29.792  49.750  75.279  1.00  9.82           C  
ATOM   1233  OG1 THR B  27      28.773  48.878  74.761  1.00  9.58           O  
ATOM   1234  CG2 THR B  27      30.111  49.376  76.715  1.00 11.22           C  
ATOM   1235  N   GLY B  28      27.978  51.349  73.170  1.00  9.79           N  
ATOM   1236  CA  GLY B  28      27.785  51.535  71.746  1.00  9.75           C  
ATOM   1237  C   GLY B  28      28.080  50.232  71.012  1.00 10.05           C  
ATOM   1238  O   GLY B  28      28.128  50.209  69.783  1.00 10.56           O  
ATOM   1239  N   ALA B  29      28.282  49.146  71.759  1.00  8.72           N  
ATOM   1240  CA  ALA B  29      28.560  47.846  71.149  1.00  8.61           C  
ATOM   1241  C   ALA B  29      27.342  47.290  70.413  1.00  8.83           C  
ATOM   1242  O   ALA B  29      26.207  47.705  70.659  1.00 10.30           O  
ATOM   1243  CB  ALA B  29      29.015  46.846  72.211  1.00  9.38           C  
ATOM   1244  N   ARG B  30      27.591  46.338  69.519  1.00  8.66           N  
ATOM   1245  CA  ARG B  30      26.530  45.715  68.740  1.00  8.70           C  
ATOM   1246  C   ARG B  30      25.834  44.582  69.470  1.00  8.65           C  
ATOM   1247  O   ARG B  30      24.605  44.526  69.526  1.00  8.67           O  
ATOM   1248  CB  ARG B  30      27.079  45.134  67.433  1.00 10.39           C  
ATOM   1249  CG  ARG B  30      27.556  46.128  66.403  1.00 12.99           C  
ATOM   1250  CD  ARG B  30      27.823  45.394  65.090  1.00 16.07           C  
ATOM   1251  NE  ARG B  30      28.224  46.296  64.015  1.00 20.15           N  
ATOM   1252  CZ  ARG B  30      28.308  45.939  62.740  1.00 19.48           C  
ATOM   1253  NH1 ARG B  30      28.012  44.697  62.375  1.00 22.85           N  
ATOM   1254  NH2 ARG B  30      28.707  46.818  61.829  1.00 22.56           N  
ATOM   1255  N   TYR B  31      26.626  43.661  70.014  1.00  8.68           N  
ATOM   1256  CA  TYR B  31      26.063  42.490  70.671  1.00  9.28           C  
ATOM   1257  C   TYR B  31      26.733  42.214  72.001  1.00  8.12           C  
ATOM   1258  O   TYR B  31      27.940  42.424  72.157  1.00  8.42           O  
ATOM   1259  CB  TYR B  31      26.221  41.263  69.754  1.00  9.85           C  
ATOM   1260  CG  TYR B  31      25.931  41.545  68.291  1.00 10.55           C  
ATOM   1261  CD1 TYR B  31      24.679  42.007  67.884  1.00  9.98           C  
ATOM   1262  CD2 TYR B  31      26.925  41.402  67.320  1.00 10.44           C  
ATOM   1263  CE1 TYR B  31      24.427  42.332  66.553  1.00  9.79           C  
ATOM   1264  CE2 TYR B  31      26.682  41.724  65.982  1.00 10.91           C  
ATOM   1265  CZ  TYR B  31      25.431  42.191  65.611  1.00  9.01           C  
ATOM   1266  OH  TYR B  31      25.194  42.541  64.300  1.00 12.52           O  
ATOM   1267  N   ALA B  32      25.943  41.737  72.953  1.00  8.04           N  
ATOM   1268  CA  ALA B  32      26.446  41.416  74.284  1.00  8.66           C  
ATOM   1269  C   ALA B  32      25.940  40.041  74.681  1.00  9.21           C  
ATOM   1270  O   ALA B  32      24.755  39.741  74.535  1.00 10.17           O  
ATOM   1271  CB  ALA B  32      25.975  42.455  75.285  1.00 10.09           C  
ATOM   1272  N   LEU B  33      26.834  39.196  75.179  1.00  8.49           N  
ATOM   1273  CA  LEU B  33      26.435  37.855  75.582  1.00 10.39           C  
ATOM   1274  C   LEU B  33      27.124  37.407  76.848  1.00 10.02           C  
ATOM   1275  O   LEU B  33      28.232  37.848  77.156  1.00 10.25           O  
ATOM   1276  CB  LEU B  33      26.799  36.819  74.516  1.00 14.01           C  
ATOM   1277  CG  LEU B  33      26.514  36.960  73.029  1.00 15.20           C  
ATOM   1278  CD1 LEU B  33      27.548  37.880  72.390  1.00 12.33           C  
ATOM   1279  CD2 LEU B  33      26.594  35.573  72.392  1.00 15.71           C  
ATOM   1280  N   LEU B  34      26.450  36.528  77.582  1.00 10.41           N  
ATOM   1281  CA  LEU B  34      27.051  35.883  78.689  1.00 10.77           C  
ATOM   1282  C   LEU B  34      27.029  34.437  78.345  1.00 10.76           C  
ATOM   1283  O   LEU B  34      25.998  33.869  78.018  1.00 11.30           O  
ATOM   1284  CB  LEU B  34      26.185  36.133  79.922  1.00 10.64           C  
ATOM   1285  CG  LEU B  34      26.718  35.406  81.156  1.00 12.88           C  
ATOM   1286  CD1 LEU B  34      28.012  36.028  81.682  1.00 15.07           C  
ATOM   1287  CD2 LEU B  34      25.733  35.411  82.324  1.00 15.35           C  
ATOM   1288  N   ILE B  35      28.207  33.828  78.317  1.00 10.23           N  
ATOM   1289  CA  ILE B  35      28.326  32.431  77.917  1.00 10.75           C  
ATOM   1290  C   ILE B  35      29.074  31.662  78.990  1.00 12.30           C  
ATOM   1291  O   ILE B  35      29.775  32.253  79.806  1.00 12.15           O  
ATOM   1292  CB  ILE B  35      29.092  32.297  76.576  1.00 10.53           C  
ATOM   1293  CG1 ILE B  35      30.574  32.647  76.764  1.00 12.02           C  
ATOM   1294  CG2 ILE B  35      28.483  33.242  75.540  1.00 11.20           C  
ATOM   1295  CD1 ILE B  35      31.410  32.445  75.514  1.00 12.42           C  
ATOM   1296  N   ASP B  36      28.916  30.344  79.020  1.00 14.35           N  
ATOM   1297  CA  ASP B  36      29.656  29.590  80.018  1.00 16.74           C  
ATOM   1298  C   ASP B  36      30.965  29.182  79.369  1.00 17.80           C  
ATOM   1299  O   ASP B  36      31.119  29.279  78.150  1.00 18.87           O  
ATOM   1300  CB  ASP B  36      28.857  28.379  80.542  1.00 17.07           C  
ATOM   1301  CG  ASP B  36      28.702  27.256  79.527  1.00 19.81           C  
ATOM   1302  OD1 ASP B  36      28.036  26.259  79.881  1.00 25.90           O  
ATOM   1303  OD2 ASP B  36      29.221  27.339  78.399  1.00 20.81           O  
ATOM   1304  N   ARG B  37      31.923  28.739  80.172  1.00 19.18           N  
ATOM   1305  CA  ARG B  37      33.211  28.374  79.610  1.00 21.05           C  
ATOM   1306  C   ARG B  37      33.158  27.174  78.664  1.00 20.92           C  
ATOM   1307  O   ARG B  37      34.158  26.825  78.038  1.00 24.25           O  
ATOM   1308  CB  ARG B  37      34.223  28.156  80.739  1.00 19.82           C  
ATOM   1309  CG  ARG B  37      34.383  29.391  81.630  1.00 22.17           C  
ATOM   1310  CD  ARG B  37      35.582  29.263  82.560  1.00 20.21           C  
ATOM   1311  NE  ARG B  37      36.825  29.172  81.804  1.00 19.03           N  
ATOM   1312  CZ  ARG B  37      37.618  30.201  81.519  1.00 18.48           C  
ATOM   1313  NH1 ARG B  37      37.313  31.423  81.933  1.00 15.52           N  
ATOM   1314  NH2 ARG B  37      38.716  30.008  80.803  1.00 20.92           N  
ATOM   1315  N   LYS B  38      31.986  26.550  78.549  1.00 21.79           N  
ATOM   1316  CA  LYS B  38      31.810  25.415  77.648  1.00 19.68           C  
ATOM   1317  C   LYS B  38      31.262  25.860  76.290  1.00 20.77           C  
ATOM   1318  O   LYS B  38      31.155  25.057  75.363  1.00 21.82           O  
ATOM   1319  CB  LYS B  38      30.857  24.379  78.254  1.00 22.31           C  
ATOM   1320  CG  LYS B  38      31.356  23.716  79.526  1.00 22.96           C  
ATOM   1321  CD  LYS B  38      30.372  22.650  79.989  1.00 25.67           C  
ATOM   1322  CE  LYS B  38      30.787  22.046  81.320  1.00 23.94           C  
ATOM   1323  NZ  LYS B  38      29.824  21.003  81.769  1.00 29.50           N  
ATOM   1324  N   GLY B  39      30.895  27.134  76.178  1.00 16.98           N  
ATOM   1325  CA  GLY B  39      30.382  27.633  74.912  1.00 17.08           C  
ATOM   1326  C   GLY B  39      28.883  27.866  74.823  1.00 14.22           C  
ATOM   1327  O   GLY B  39      28.399  28.416  73.835  1.00 15.95           O  
ATOM   1328  N   PHE B  40      28.134  27.453  75.837  1.00 13.61           N  
ATOM   1329  CA  PHE B  40      26.688  27.653  75.802  1.00 13.03           C  
ATOM   1330  C   PHE B  40      26.345  29.118  76.045  1.00 11.69           C  
ATOM   1331  O   PHE B  40      26.975  29.774  76.872  1.00 13.52           O  
ATOM   1332  CB  PHE B  40      25.986  26.807  76.869  1.00 14.07           C  
ATOM   1333  CG  PHE B  40      25.994  25.333  76.584  1.00 15.13           C  
ATOM   1334  CD1 PHE B  40      26.892  24.491  77.233  1.00 16.86           C  
ATOM   1335  CD2 PHE B  40      25.091  24.785  75.680  1.00 16.94           C  
ATOM   1336  CE1 PHE B  40      26.886  23.119  76.984  1.00 19.61           C  
ATOM   1337  CE2 PHE B  40      25.078  23.416  75.425  1.00 19.81           C  
ATOM   1338  CZ  PHE B  40      25.977  22.583  76.077  1.00 19.51           C  
ATOM   1339  N   VAL B  41      25.350  29.627  75.322  1.00 11.71           N  
ATOM   1340  CA  VAL B  41      24.925  31.010  75.512  1.00 11.34           C  
ATOM   1341  C   VAL B  41      23.902  31.009  76.644  1.00 12.49           C  
ATOM   1342  O   VAL B  41      22.866  30.346  76.553  1.00 14.37           O  
ATOM   1343  CB  VAL B  41      24.276  31.589  74.244  1.00 10.02           C  
ATOM   1344  CG1 VAL B  41      23.784  33.002  74.523  1.00 12.79           C  
ATOM   1345  CG2 VAL B  41      25.289  31.605  73.100  1.00 12.30           C  
ATOM   1346  N   LEU B  42      24.199  31.741  77.711  1.00 11.67           N  
ATOM   1347  CA  LEU B  42      23.312  31.803  78.869  1.00 13.78           C  
ATOM   1348  C   LEU B  42      22.294  32.926  78.738  1.00 12.66           C  
ATOM   1349  O   LEU B  42      21.174  32.820  79.234  1.00 14.47           O  
ATOM   1350  CB  LEU B  42      24.136  32.000  80.142  1.00 15.10           C  
ATOM   1351  CG  LEU B  42      25.287  31.006  80.334  1.00 18.22           C  
ATOM   1352  CD1 LEU B  42      25.961  31.260  81.671  1.00 19.10           C  
ATOM   1353  CD2 LEU B  42      24.759  29.584  80.265  1.00 20.31           C  
ATOM   1354  N   ALA B  43      22.694  34.010  78.079  1.00 11.90           N  
ATOM   1355  CA  ALA B  43      21.823  35.162  77.858  1.00 11.04           C  
ATOM   1356  C   ALA B  43      22.493  36.032  76.802  1.00 11.19           C  
ATOM   1357  O   ALA B  43      23.724  36.094  76.734  1.00 10.32           O  
ATOM   1358  CB  ALA B  43      21.643  35.956  79.148  1.00 12.64           C  
ATOM   1359  N   HIS B  44      21.698  36.688  75.965  1.00 10.35           N  
ATOM   1360  CA  HIS B  44      22.263  37.549  74.933  1.00 10.10           C  
ATOM   1361  C   HIS B  44      21.290  38.647  74.548  1.00 10.27           C  
ATOM   1362  O   HIS B  44      20.076  38.447  74.559  1.00 11.84           O  
ATOM   1363  CB  HIS B  44      22.650  36.734  73.692  1.00 10.94           C  
ATOM   1364  CG  HIS B  44      21.488  36.140  72.960  1.00  9.83           C  
ATOM   1365  ND1 HIS B  44      20.772  36.834  72.007  1.00 11.99           N  
ATOM   1366  CD2 HIS B  44      20.918  34.915  73.040  1.00 12.68           C  
ATOM   1367  CE1 HIS B  44      19.814  36.060  71.530  1.00 14.15           C  
ATOM   1368  NE2 HIS B  44      19.880  34.890  72.141  1.00 12.02           N  
ATOM   1369  N   LYS B  45      21.839  39.814  74.228  1.00 10.13           N  
ATOM   1370  CA  LYS B  45      21.045  40.960  73.812  1.00  9.83           C  
ATOM   1371  C   LYS B  45      21.769  41.673  72.686  1.00  9.79           C  
ATOM   1372  O   LYS B  45      23.003  41.691  72.638  1.00  9.75           O  
ATOM   1373  CB  LYS B  45      20.810  41.910  74.989  1.00 11.26           C  
ATOM   1374  CG  LYS B  45      19.835  41.338  76.010  1.00 15.14           C  
ATOM   1375  CD  LYS B  45      18.453  41.152  75.391  1.00 17.89           C  
ATOM   1376  CE  LYS B  45      17.613  40.169  76.193  1.00 21.88           C  
ATOM   1377  NZ  LYS B  45      16.237  40.009  75.629  1.00 24.40           N  
ATOM   1378  N   GLU B  46      20.998  42.250  71.773  1.00 10.10           N  
ATOM   1379  CA  GLU B  46      21.562  42.947  70.627  1.00 10.55           C  
ATOM   1380  C   GLU B  46      21.071  44.377  70.596  1.00 11.08           C  
ATOM   1381  O   GLU B  46      19.950  44.662  71.018  1.00 13.47           O  
ATOM   1382  CB  GLU B  46      21.154  42.248  69.327  1.00 12.02           C  
ATOM   1383  CG  GLU B  46      21.632  40.799  69.200  1.00 13.57           C  
ATOM   1384  CD  GLU B  46      20.846  39.829  70.066  1.00 15.61           C  
ATOM   1385  OE1 GLU B  46      19.612  39.721  69.879  1.00 17.97           O  
ATOM   1386  OE2 GLU B  46      21.462  39.168  70.927  1.00 13.43           O  
ATOM   1387  N   ALA B  47      21.912  45.282  70.106  1.00 11.00           N  
ATOM   1388  CA  ALA B  47      21.521  46.685  70.014  1.00 11.56           C  
ATOM   1389  C   ALA B  47      20.411  46.805  68.981  1.00 13.53           C  
ATOM   1390  O   ALA B  47      20.462  46.172  67.933  1.00 14.07           O  
ATOM   1391  CB  ALA B  47      22.711  47.536  69.603  1.00 12.06           C  
ATOM   1392  N   LEU B  48      19.410  47.628  69.278  1.00 16.94           N  
ATOM   1393  CA  LEU B  48      18.286  47.804  68.370  1.00 19.52           C  
ATOM   1394  C   LEU B  48      18.702  48.285  66.981  1.00 18.81           C  
ATOM   1395  O   LEU B  48      18.064  47.952  65.985  1.00 20.18           O  
ATOM   1396  CB  LEU B  48      17.281  48.787  68.980  1.00 22.65           C  
ATOM   1397  CG  LEU B  48      16.640  48.348  70.300  1.00 27.17           C  
ATOM   1398  CD1 LEU B  48      15.698  49.435  70.797  1.00 28.46           C  
ATOM   1399  CD2 LEU B  48      15.885  47.041  70.094  1.00 29.13           C  
ATOM   1400  N   TRP B  49      19.786  49.050  66.918  1.00 16.02           N  
ATOM   1401  CA  TRP B  49      20.269  49.595  65.654  1.00 15.93           C  
ATOM   1402  C   TRP B  49      21.141  48.639  64.850  1.00 15.23           C  
ATOM   1403  O   TRP B  49      21.336  48.822  63.649  1.00 15.70           O  
ATOM   1404  CB  TRP B  49      21.072  50.872  65.913  1.00 13.81           C  
ATOM   1405  CG  TRP B  49      22.291  50.657  66.775  1.00 13.39           C  
ATOM   1406  CD1 TRP B  49      22.383  50.818  68.128  1.00 13.28           C  
ATOM   1407  CD2 TRP B  49      23.583  50.214  66.335  1.00 11.08           C  
ATOM   1408  NE1 TRP B  49      23.652  50.501  68.559  1.00 12.48           N  
ATOM   1409  CE2 TRP B  49      24.407  50.128  67.479  1.00 11.88           C  
ATOM   1410  CE3 TRP B  49      24.123  49.881  65.084  1.00 11.42           C  
ATOM   1411  CZ2 TRP B  49      25.745  49.724  67.410  1.00 10.67           C  
ATOM   1412  CZ3 TRP B  49      25.459  49.478  65.016  1.00 12.69           C  
ATOM   1413  CH2 TRP B  49      26.252  49.404  66.177  1.00 12.16           C  
ATOM   1414  N   ALA B  50      21.673  47.621  65.513  1.00 15.18           N  
ATOM   1415  CA  ALA B  50      22.573  46.686  64.856  1.00 15.54           C  
ATOM   1416  C   ALA B  50      21.924  45.690  63.906  1.00 16.06           C  
ATOM   1417  O   ALA B  50      20.765  45.312  64.074  1.00 16.84           O  
ATOM   1418  CB  ALA B  50      23.379  45.936  65.907  1.00 15.38           C  
ATOM   1419  N   PRO B  51      22.672  45.262  62.879  1.00 15.58           N  
ATOM   1420  CA  PRO B  51      22.132  44.295  61.925  1.00 16.97           C  
ATOM   1421  C   PRO B  51      22.110  42.922  62.582  1.00 17.13           C  
ATOM   1422  O   PRO B  51      22.586  42.755  63.711  1.00 16.01           O  
ATOM   1423  CB  PRO B  51      23.121  44.367  60.767  1.00 18.17           C  
ATOM   1424  CG  PRO B  51      24.411  44.679  61.451  1.00 16.65           C  
ATOM   1425  CD  PRO B  51      23.997  45.740  62.449  1.00 15.96           C  
ATOM   1426  N   LYS B  52      21.542  41.948  61.882  1.00 17.08           N  
ATOM   1427  CA  LYS B  52      21.481  40.589  62.391  1.00 18.08           C  
ATOM   1428  C   LYS B  52      22.909  40.174  62.738  1.00 16.20           C  
ATOM   1429  O   LYS B  52      23.826  40.364  61.941  1.00 16.97           O  
ATOM   1430  CB  LYS B  52      20.911  39.662  61.318  1.00 21.58           C  
ATOM   1431  CG  LYS B  52      20.860  38.198  61.704  1.00 25.34           C  
ATOM   1432  CD  LYS B  52      20.366  37.361  60.532  1.00 27.83           C  
ATOM   1433  CE  LYS B  52      20.381  35.876  60.845  1.00 29.88           C  
ATOM   1434  NZ  LYS B  52      19.943  35.074  59.666  1.00 32.47           N  
ATOM   1435  N   PRO B  53      23.116  39.613  63.937  1.00 15.38           N  
ATOM   1436  CA  PRO B  53      24.467  39.200  64.317  1.00 14.35           C  
ATOM   1437  C   PRO B  53      24.894  37.918  63.633  1.00 16.09           C  
ATOM   1438  O   PRO B  53      24.079  37.217  63.036  1.00 16.22           O  
ATOM   1439  CB  PRO B  53      24.349  39.002  65.824  1.00 15.66           C  
ATOM   1440  CG  PRO B  53      22.960  38.458  65.965  1.00 16.25           C  
ATOM   1441  CD  PRO B  53      22.169  39.377  65.043  1.00 14.99           C  
ATOM   1442  N   PRO B  54      26.195  37.614  63.678  1.00 15.64           N  
ATOM   1443  CA  PRO B  54      26.647  36.371  63.054  1.00 15.30           C  
ATOM   1444  C   PRO B  54      26.069  35.299  63.977  1.00 15.26           C  
ATOM   1445  O   PRO B  54      25.603  35.616  65.072  1.00 14.69           O  
ATOM   1446  CB  PRO B  54      28.167  36.477  63.149  1.00 17.86           C  
ATOM   1447  CG  PRO B  54      28.372  37.262  64.400  1.00 17.67           C  
ATOM   1448  CD  PRO B  54      27.320  38.343  64.291  1.00 15.66           C  
ATOM   1449  N   PRO B  55      26.074  34.026  63.558  1.00 14.09           N  
ATOM   1450  CA  PRO B  55      25.524  32.975  64.424  1.00 14.85           C  
ATOM   1451  C   PRO B  55      26.094  33.084  65.838  1.00 13.42           C  
ATOM   1452  O   PRO B  55      27.288  32.875  66.048  1.00 13.09           O  
ATOM   1453  CB  PRO B  55      25.951  31.689  63.718  1.00 15.81           C  
ATOM   1454  CG  PRO B  55      25.982  32.097  62.277  1.00 19.99           C  
ATOM   1455  CD  PRO B  55      26.636  33.456  62.321  1.00 17.02           C  
ATOM   1456  N   LEU B  56      25.242  33.390  66.809  1.00 11.92           N  
ATOM   1457  CA  LEU B  56      25.710  33.562  68.179  1.00 11.90           C  
ATOM   1458  C   LEU B  56      26.217  32.292  68.835  1.00 12.49           C  
ATOM   1459  O   LEU B  56      27.114  32.347  69.676  1.00 12.20           O  
ATOM   1460  CB  LEU B  56      24.620  34.203  69.039  1.00 12.52           C  
ATOM   1461  CG  LEU B  56      24.265  35.641  68.649  1.00 14.59           C  
ATOM   1462  CD1 LEU B  56      23.170  36.145  69.572  1.00 14.71           C  
ATOM   1463  CD2 LEU B  56      25.492  36.538  68.734  1.00 16.50           C  
ATOM   1464  N   ASP B  57      25.645  31.149  68.468  1.00 13.32           N  
ATOM   1465  CA  ASP B  57      26.114  29.899  69.047  1.00 12.20           C  
ATOM   1466  C   ASP B  57      27.534  29.619  68.549  1.00 11.35           C  
ATOM   1467  O   ASP B  57      28.387  29.183  69.318  1.00 11.96           O  
ATOM   1468  CB  ASP B  57      25.145  28.749  68.721  1.00 14.77           C  
ATOM   1469  CG  ASP B  57      24.941  28.532  67.231  1.00 17.56           C  
ATOM   1470  OD1 ASP B  57      25.060  29.481  66.425  1.00 16.90           O  
ATOM   1471  OD2 ASP B  57      24.629  27.380  66.864  1.00 23.13           O  
ATOM   1472  N   THR B  58      27.792  29.908  67.278  1.00 11.20           N  
ATOM   1473  CA  THR B  58      29.125  29.709  66.723  1.00 10.87           C  
ATOM   1474  C   THR B  58      30.094  30.697  67.378  1.00 10.96           C  
ATOM   1475  O   THR B  58      31.217  30.335  67.728  1.00 11.22           O  
ATOM   1476  CB  THR B  58      29.132  29.912  65.204  1.00 11.79           C  
ATOM   1477  OG1 THR B  58      28.166  29.034  64.611  1.00 13.37           O  
ATOM   1478  CG2 THR B  58      30.513  29.599  64.627  1.00 12.37           C  
ATOM   1479  N   LEU B  59      29.657  31.943  67.555  1.00 10.66           N  
ATOM   1480  CA  LEU B  59      30.507  32.949  68.188  1.00 10.37           C  
ATOM   1481  C   LEU B  59      30.903  32.485  69.588  1.00 10.58           C  
ATOM   1482  O   LEU B  59      32.077  32.528  69.961  1.00 11.19           O  
ATOM   1483  CB  LEU B  59      29.773  34.292  68.282  1.00 11.93           C  
ATOM   1484  CG  LEU B  59      30.484  35.381  69.098  1.00 11.36           C  
ATOM   1485  CD1 LEU B  59      31.823  35.716  68.459  1.00 14.42           C  
ATOM   1486  CD2 LEU B  59      29.604  36.627  69.179  1.00 15.17           C  
ATOM   1487  N   ALA B  60      29.916  32.039  70.359  1.00 10.08           N  
ATOM   1488  CA  ALA B  60      30.147  31.568  71.720  1.00  9.58           C  
ATOM   1489  C   ALA B  60      31.087  30.364  71.743  1.00 10.72           C  
ATOM   1490  O   ALA B  60      31.968  30.271  72.597  1.00 11.31           O  
ATOM   1491  CB  ALA B  60      28.818  31.213  72.380  1.00 10.49           C  
ATOM   1492  N   THR B  61      30.896  29.446  70.802  1.00 10.61           N  
ATOM   1493  CA  THR B  61      31.746  28.264  70.718  1.00 11.56           C  
ATOM   1494  C   THR B  61      33.193  28.677  70.465  1.00 11.04           C  
ATOM   1495  O   THR B  61      34.109  28.185  71.124  1.00 10.89           O  
ATOM   1496  CB  THR B  61      31.289  27.337  69.586  1.00 12.23           C  
ATOM   1497  OG1 THR B  61      29.954  26.893  69.848  1.00 14.51           O  
ATOM   1498  CG2 THR B  61      32.202  26.124  69.491  1.00 12.01           C  
ATOM   1499  N   LEU B  62      33.394  29.587  69.515  1.00 10.51           N  
ATOM   1500  CA  LEU B  62      34.741  30.051  69.193  1.00  9.87           C  
ATOM   1501  C   LEU B  62      35.372  30.794  70.365  1.00 10.17           C  
ATOM   1502  O   LEU B  62      36.569  30.657  70.618  1.00 10.57           O  
ATOM   1503  CB  LEU B  62      34.716  30.951  67.958  1.00 10.83           C  
ATOM   1504  CG  LEU B  62      34.325  30.257  66.652  1.00 12.05           C  
ATOM   1505  CD1 LEU B  62      34.220  31.277  65.540  1.00 13.46           C  
ATOM   1506  CD2 LEU B  62      35.362  29.195  66.296  1.00 12.19           C  
ATOM   1507  N   VAL B  63      34.584  31.595  71.077  1.00 10.31           N  
ATOM   1508  CA  VAL B  63      35.127  32.305  72.227  1.00  9.28           C  
ATOM   1509  C   VAL B  63      35.539  31.296  73.296  1.00 10.39           C  
ATOM   1510  O   VAL B  63      36.589  31.446  73.921  1.00 10.86           O  
ATOM   1511  CB  VAL B  63      34.101  33.308  72.801  1.00  9.41           C  
ATOM   1512  CG1 VAL B  63      34.580  33.854  74.138  1.00 11.93           C  
ATOM   1513  CG2 VAL B  63      33.903  34.442  71.812  1.00 11.63           C  
ATOM   1514  N   ALA B  64      34.728  30.255  73.479  1.00 11.73           N  
ATOM   1515  CA  ALA B  64      35.022  29.214  74.460  1.00 13.19           C  
ATOM   1516  C   ALA B  64      36.278  28.447  74.046  1.00 12.77           C  
ATOM   1517  O   ALA B  64      37.129  28.133  74.882  1.00 13.37           O  
ATOM   1518  CB  ALA B  64      33.838  28.256  74.577  1.00 13.54           C  
ATOM   1519  N   GLY B  65      36.386  28.147  72.756  1.00 12.10           N  
ATOM   1520  CA  GLY B  65      37.554  27.439  72.262  1.00 12.87           C  
ATOM   1521  C   GLY B  65      38.800  28.268  72.523  1.00 12.32           C  
ATOM   1522  O   GLY B  65      39.832  27.745  72.946  1.00 13.11           O  
ATOM   1523  N   ASN B  66      38.703  29.572  72.275  1.00 12.35           N  
ATOM   1524  CA  ASN B  66      39.823  30.486  72.484  1.00 12.43           C  
ATOM   1525  C   ASN B  66      40.226  30.547  73.954  1.00 11.87           C  
ATOM   1526  O   ASN B  66      41.417  30.537  74.283  1.00 12.32           O  
ATOM   1527  CB  ASN B  66      39.445  31.892  72.012  1.00 13.48           C  
ATOM   1528  CG  ASN B  66      40.539  32.910  72.269  1.00 15.89           C  
ATOM   1529  OD1 ASN B  66      41.539  32.948  71.562  1.00 18.27           O  
ATOM   1530  ND2 ASN B  66      40.353  33.736  73.293  1.00 18.98           N  
ATOM   1531  N   ALA B  67      39.233  30.621  74.838  1.00 11.38           N  
ATOM   1532  CA  ALA B  67      39.494  30.693  76.269  1.00 12.11           C  
ATOM   1533  C   ALA B  67      40.288  29.481  76.745  1.00 12.01           C  
ATOM   1534  O   ALA B  67      41.087  29.578  77.678  1.00 13.46           O  
ATOM   1535  CB  ALA B  67      38.180  30.798  77.040  1.00 13.50           C  
ATOM   1536  N   ALA B  68      40.063  28.334  76.118  1.00 12.04           N  
ATOM   1537  CA  ALA B  68      40.799  27.143  76.504  1.00 12.76           C  
ATOM   1538  C   ALA B  68      42.213  27.218  75.935  1.00 12.61           C  
ATOM   1539  O   ALA B  68      43.192  26.993  76.643  1.00 13.43           O  
ATOM   1540  CB  ALA B  68      40.094  25.900  75.986  1.00 12.95           C  
ATOM   1541  N   ALA B  69      42.303  27.567  74.657  1.00 12.52           N  
ATOM   1542  CA  ALA B  69      43.576  27.640  73.952  1.00 11.67           C  
ATOM   1543  C   ALA B  69      44.622  28.609  74.491  1.00 12.09           C  
ATOM   1544  O   ALA B  69      45.814  28.293  74.491  1.00 14.48           O  
ATOM   1545  CB  ALA B  69      43.322  27.937  72.480  1.00 13.10           C  
ATOM   1546  N   THR B  70      44.199  29.781  74.948  1.00 12.28           N  
ATOM   1547  CA  THR B  70      45.160  30.766  75.438  1.00 11.77           C  
ATOM   1548  C   THR B  70      45.759  30.451  76.803  1.00 13.23           C  
ATOM   1549  O   THR B  70      46.631  31.176  77.275  1.00 13.82           O  
ATOM   1550  CB  THR B  70      44.540  32.178  75.511  1.00 11.93           C  
ATOM   1551  OG1 THR B  70      43.460  32.180  76.451  1.00 13.71           O  
ATOM   1552  CG2 THR B  70      44.026  32.610  74.146  1.00 14.63           C  
ATOM   1553  N   GLN B  71      45.317  29.372  77.437  1.00 13.69           N  
ATOM   1554  CA  GLN B  71      45.848  29.045  78.753  1.00 13.48           C  
ATOM   1555  C   GLN B  71      47.315  28.618  78.754  1.00 13.08           C  
ATOM   1556  O   GLN B  71      47.987  28.738  79.772  1.00 13.98           O  
ATOM   1557  CB  GLN B  71      44.953  28.007  79.437  1.00 15.36           C  
ATOM   1558  CG  GLN B  71      43.640  28.647  79.885  1.00 15.53           C  
ATOM   1559  CD  GLN B  71      42.751  27.732  80.692  1.00 17.99           C  
ATOM   1560  OE1 GLN B  71      43.228  26.893  81.451  1.00 21.40           O  
ATOM   1561  NE2 GLN B  71      41.441  27.911  80.551  1.00 17.45           N  
ATOM   1562  N   ALA B  72      47.820  28.140  77.620  1.00 14.55           N  
ATOM   1563  CA  ALA B  72      49.231  27.753  77.548  1.00 14.06           C  
ATOM   1564  C   ALA B  72      50.066  29.032  77.686  1.00 13.83           C  
ATOM   1565  O   ALA B  72      51.020  29.090  78.471  1.00 13.90           O  
ATOM   1566  CB  ALA B  72      49.526  27.064  76.219  1.00 16.20           C  
ATOM   1567  N   LEU B  73      49.695  30.054  76.918  1.00 13.61           N  
ATOM   1568  CA  LEU B  73      50.378  31.344  76.966  1.00 13.08           C  
ATOM   1569  C   LEU B  73      50.262  31.927  78.368  1.00 11.79           C  
ATOM   1570  O   LEU B  73      51.228  32.462  78.909  1.00 12.50           O  
ATOM   1571  CB  LEU B  73      49.747  32.327  75.977  1.00 15.65           C  
ATOM   1572  CG  LEU B  73      50.319  32.476  74.569  1.00 18.40           C  
ATOM   1573  CD1 LEU B  73      49.403  33.378  73.754  1.00 17.30           C  
ATOM   1574  CD2 LEU B  73      51.725  33.068  74.641  1.00 17.92           C  
ATOM   1575  N   ALA B  74      49.072  31.827  78.953  1.00 11.41           N  
ATOM   1576  CA  ALA B  74      48.849  32.357  80.290  1.00 11.33           C  
ATOM   1577  C   ALA B  74      49.789  31.701  81.293  1.00 11.79           C  
ATOM   1578  O   ALA B  74      50.451  32.386  82.075  1.00 12.20           O  
ATOM   1579  CB  ALA B  74      47.401  32.135  80.708  1.00 12.62           C  
ATOM   1580  N   LYS B  75      49.843  30.373  81.262  1.00 13.41           N  
ATOM   1581  CA  LYS B  75      50.696  29.621  82.177  1.00 13.69           C  
ATOM   1582  C   LYS B  75      52.159  30.011  82.017  1.00 13.84           C  
ATOM   1583  O   LYS B  75      52.892  30.134  83.002  1.00 14.62           O  
ATOM   1584  CB  LYS B  75      50.538  28.117  81.934  1.00 14.28           C  
ATOM   1585  CG  LYS B  75      49.166  27.555  82.289  1.00 18.37           C  
ATOM   1586  CD  LYS B  75      49.084  26.077  81.929  1.00 21.39           C  
ATOM   1587  CE  LYS B  75      47.682  25.521  82.111  1.00 23.50           C  
ATOM   1588  NZ  LYS B  75      47.236  25.544  83.530  1.00 26.89           N  
ATOM   1589  N   LEU B  76      52.583  30.207  80.773  1.00 12.86           N  
ATOM   1590  CA  LEU B  76      53.968  30.582  80.504  1.00 12.38           C  
ATOM   1591  C   LEU B  76      54.296  31.907  81.182  1.00 13.38           C  
ATOM   1592  O   LEU B  76      55.426  32.121  81.634  1.00 14.64           O  
ATOM   1593  CB  LEU B  76      54.203  30.706  78.997  1.00 12.38           C  
ATOM   1594  CG  LEU B  76      55.644  31.025  78.592  1.00 13.56           C  
ATOM   1595  CD1 LEU B  76      56.536  29.822  78.912  1.00 15.12           C  
ATOM   1596  CD2 LEU B  76      55.713  31.340  77.109  1.00 14.83           C  
ATOM   1597  N   LEU B  77      53.304  32.792  81.251  1.00 14.36           N  
ATOM   1598  CA  LEU B  77      53.487  34.098  81.876  1.00 15.56           C  
ATOM   1599  C   LEU B  77      53.174  34.082  83.373  1.00 15.62           C  
ATOM   1600  O   LEU B  77      53.084  35.135  84.004  1.00 17.61           O  
ATOM   1601  CB  LEU B  77      52.625  35.150  81.165  1.00 14.29           C  
ATOM   1602  CG  LEU B  77      52.943  35.375  79.683  1.00 14.15           C  
ATOM   1603  CD1 LEU B  77      52.055  36.480  79.133  1.00 16.91           C  
ATOM   1604  CD2 LEU B  77      54.416  35.736  79.516  1.00 16.82           C  
ATOM   1605  N   GLY B  78      53.001  32.887  83.932  1.00 15.53           N  
ATOM   1606  CA  GLY B  78      52.729  32.754  85.355  1.00 16.16           C  
ATOM   1607  C   GLY B  78      51.296  32.982  85.794  1.00 16.51           C  
ATOM   1608  O   GLY B  78      51.025  33.132  86.986  1.00 18.93           O  
ATOM   1609  N   GLU B  79      50.377  32.995  84.833  1.00 13.99           N  
ATOM   1610  CA  GLU B  79      48.956  33.208  85.101  1.00 16.71           C  
ATOM   1611  C   GLU B  79      48.191  31.897  84.938  1.00 16.25           C  
ATOM   1612  O   GLU B  79      48.616  31.015  84.195  1.00 19.16           O  
ATOM   1613  CB  GLU B  79      48.379  34.216  84.102  1.00 16.79           C  
ATOM   1614  CG  GLU B  79      49.017  35.593  84.106  1.00 18.53           C  
ATOM   1615  CD  GLU B  79      48.561  36.446  85.271  1.00 19.01           C  
ATOM   1616  OE1 GLU B  79      47.464  36.183  85.811  1.00 18.79           O  
ATOM   1617  OE2 GLU B  79      49.292  37.391  85.629  1.00 19.15           O  
ATOM   1618  N   ALA B  80      47.064  31.769  85.629  1.00 17.26           N  
ATOM   1619  CA  ALA B  80      46.246  30.570  85.496  1.00 16.53           C  
ATOM   1620  C   ALA B  80      45.552  30.677  84.139  1.00 16.92           C  
ATOM   1621  O   ALA B  80      45.400  29.695  83.416  1.00 18.03           O  
ATOM   1622  CB  ALA B  80      45.217  30.506  86.613  1.00 17.20           C  
ATOM   1623  N   ARG B  81      45.139  31.896  83.805  1.00 14.99           N  
ATOM   1624  CA  ARG B  81      44.478  32.169  82.539  1.00 15.31           C  
ATOM   1625  C   ARG B  81      44.320  33.676  82.404  1.00 13.47           C  
ATOM   1626  O   ARG B  81      44.498  34.412  83.373  1.00 15.79           O  
ATOM   1627  CB  ARG B  81      43.111  31.477  82.489  1.00 17.54           C  
ATOM   1628  CG  ARG B  81      42.123  31.928  83.544  1.00 19.12           C  
ATOM   1629  CD  ARG B  81      40.976  30.928  83.648  1.00 20.49           C  
ATOM   1630  NE  ARG B  81      39.888  31.405  84.491  1.00 21.93           N  
ATOM   1631  CZ  ARG B  81      38.855  30.657  84.865  1.00 23.03           C  
ATOM   1632  NH1 ARG B  81      38.771  29.389  84.474  1.00 23.00           N  
ATOM   1633  NH2 ARG B  81      37.898  31.178  85.619  1.00 24.33           N  
ATOM   1634  N   PHE B  82      44.020  34.139  81.197  1.00 13.40           N  
ATOM   1635  CA  PHE B  82      43.824  35.566  80.992  1.00 13.54           C  
ATOM   1636  C   PHE B  82      42.394  35.890  81.383  1.00 14.64           C  
ATOM   1637  O   PHE B  82      41.466  35.181  81.003  1.00 19.52           O  
ATOM   1638  CB  PHE B  82      44.067  35.934  79.530  1.00 12.36           C  
ATOM   1639  CG  PHE B  82      45.495  35.769  79.100  1.00 11.42           C  
ATOM   1640  CD1 PHE B  82      46.501  36.533  79.681  1.00 11.81           C  
ATOM   1641  CD2 PHE B  82      45.834  34.847  78.116  1.00 11.81           C  
ATOM   1642  CE1 PHE B  82      47.828  36.380  79.285  1.00 13.32           C  
ATOM   1643  CE2 PHE B  82      47.153  34.686  77.715  1.00 11.70           C  
ATOM   1644  CZ  PHE B  82      48.154  35.454  78.298  1.00 12.79           C  
ATOM   1645  N   GLN B  83      42.220  36.956  82.151  1.00 14.42           N  
ATOM   1646  CA  GLN B  83      40.890  37.354  82.588  1.00 15.74           C  
ATOM   1647  C   GLN B  83      40.191  38.242  81.571  1.00 14.95           C  
ATOM   1648  O   GLN B  83      38.992  38.105  81.344  1.00 17.05           O  
ATOM   1649  CB  GLN B  83      40.965  38.091  83.928  1.00 17.90           C  
ATOM   1650  CG  GLN B  83      41.187  37.200  85.150  1.00 24.79           C  
ATOM   1651  CD  GLN B  83      42.540  36.519  85.157  1.00 28.08           C  
ATOM   1652  OE1 GLN B  83      43.573  37.163  84.970  1.00 27.54           O  
ATOM   1653  NE2 GLN B  83      42.545  35.210  85.388  1.00 30.28           N  
ATOM   1654  N   GLU B  84      40.947  39.144  80.953  1.00 13.77           N  
ATOM   1655  CA  GLU B  84      40.398  40.080  79.982  1.00 13.13           C  
ATOM   1656  C   GLU B  84      41.159  39.983  78.666  1.00 13.27           C  
ATOM   1657  O   GLU B  84      42.385  39.901  78.658  1.00 13.21           O  
ATOM   1658  CB  GLU B  84      40.507  41.500  80.545  1.00 16.61           C  
ATOM   1659  CG  GLU B  84      39.808  42.584  79.757  1.00 21.59           C  
ATOM   1660  CD  GLU B  84      39.960  43.943  80.415  1.00 23.68           C  
ATOM   1661  OE1 GLU B  84      41.113  44.361  80.652  1.00 28.55           O  
ATOM   1662  OE2 GLU B  84      38.935  44.596  80.700  1.00 26.21           O  
ATOM   1663  N   GLU B  85      40.429  39.995  77.555  1.00 11.37           N  
ATOM   1664  CA  GLU B  85      41.044  39.916  76.239  1.00 12.23           C  
ATOM   1665  C   GLU B  85      40.343  40.832  75.251  1.00 10.63           C  
ATOM   1666  O   GLU B  85      39.115  40.925  75.245  1.00 11.27           O  
ATOM   1667  CB  GLU B  85      40.983  38.483  75.693  1.00 12.69           C  
ATOM   1668  CG  GLU B  85      41.825  37.456  76.455  1.00 17.13           C  
ATOM   1669  CD  GLU B  85      41.836  36.088  75.781  1.00 20.38           C  
ATOM   1670  OE1 GLU B  85      41.537  36.010  74.566  1.00 23.20           O  
ATOM   1671  OE2 GLU B  85      42.161  35.088  76.455  1.00 23.66           O  
ATOM   1672  N   VAL B  86      41.127  41.506  74.416  1.00 11.04           N  
ATOM   1673  CA  VAL B  86      40.575  42.382  73.387  1.00 10.49           C  
ATOM   1674  C   VAL B  86      41.206  41.998  72.052  1.00 11.20           C  
ATOM   1675  O   VAL B  86      42.425  41.879  71.953  1.00 11.68           O  
ATOM   1676  CB  VAL B  86      40.877  43.868  73.670  1.00 11.68           C  
ATOM   1677  CG1 VAL B  86      40.381  44.725  72.516  1.00 16.03           C  
ATOM   1678  CG2 VAL B  86      40.208  44.294  74.964  1.00 14.11           C  
ATOM   1679  N   HIS B  87      40.370  41.772  71.041  1.00  9.82           N  
ATOM   1680  CA  HIS B  87      40.835  41.422  69.697  1.00  9.88           C  
ATOM   1681  C   HIS B  87      40.284  42.493  68.775  1.00 10.93           C  
ATOM   1682  O   HIS B  87      39.069  42.707  68.713  1.00 10.42           O  
ATOM   1683  CB  HIS B  87      40.303  40.053  69.263  1.00 10.74           C  
ATOM   1684  CG  HIS B  87      40.854  38.909  70.056  1.00 12.99           C  
ATOM   1685  ND1 HIS B  87      40.441  38.618  71.338  1.00 16.35           N  
ATOM   1686  CD2 HIS B  87      41.804  37.994  69.750  1.00 14.39           C  
ATOM   1687  CE1 HIS B  87      41.112  37.573  71.787  1.00 12.98           C  
ATOM   1688  NE2 HIS B  87      41.947  37.175  70.843  1.00 16.73           N  
ATOM   1689  N   GLN B  88      41.177  43.164  68.059  1.00 10.73           N  
ATOM   1690  CA  GLN B  88      40.779  44.256  67.188  1.00 11.48           C  
ATOM   1691  C   GLN B  88      41.114  44.044  65.723  1.00 11.54           C  
ATOM   1692  O   GLN B  88      42.263  43.771  65.376  1.00 12.13           O  
ATOM   1693  CB  GLN B  88      41.449  45.542  67.666  1.00 15.25           C  
ATOM   1694  CG  GLN B  88      41.063  46.785  66.887  1.00 19.89           C  
ATOM   1695  CD  GLN B  88      39.689  47.295  67.260  1.00 22.25           C  
ATOM   1696  OE1 GLN B  88      39.463  47.722  68.393  1.00 25.11           O  
ATOM   1697  NE2 GLN B  88      38.763  47.253  66.310  1.00 22.99           N  
ATOM   1698  N   GLY B  89      40.100  44.176  64.875  1.00 12.13           N  
ATOM   1699  CA  GLY B  89      40.301  44.061  63.443  1.00 14.32           C  
ATOM   1700  C   GLY B  89      40.311  45.474  62.881  1.00 15.56           C  
ATOM   1701  O   GLY B  89      40.506  46.437  63.623  1.00 17.51           O  
ATOM   1702  N   GLU B  90      40.095  45.611  61.576  1.00 16.66           N  
ATOM   1703  CA  GLU B  90      40.083  46.928  60.951  1.00 19.24           C  
ATOM   1704  C   GLU B  90      38.842  47.705  61.361  1.00 18.67           C  
ATOM   1705  O   GLU B  90      38.904  48.911  61.600  1.00 20.97           O  
ATOM   1706  CB  GLU B  90      40.115  46.787  59.427  1.00 21.16           C  
ATOM   1707  CG  GLU B  90      41.452  46.326  58.863  1.00 29.25           C  
ATOM   1708  CD  GLU B  90      42.477  47.445  58.794  1.00 33.23           C  
ATOM   1709  OE1 GLU B  90      42.815  48.020  59.851  1.00 36.87           O  
ATOM   1710  OE2 GLU B  90      42.943  47.754  57.676  1.00 36.87           O  
ATOM   1711  N   ARG B  91      37.718  47.004  61.448  1.00 19.02           N  
ATOM   1712  CA  ARG B  91      36.455  47.631  61.811  1.00 20.65           C  
ATOM   1713  C   ARG B  91      35.823  46.991  63.042  1.00 18.78           C  
ATOM   1714  O   ARG B  91      35.357  47.687  63.947  1.00 21.30           O  
ATOM   1715  CB  ARG B  91      35.480  47.532  60.636  1.00 23.44           C  
ATOM   1716  CG  ARG B  91      35.993  48.162  59.348  1.00 29.53           C  
ATOM   1717  CD  ARG B  91      35.081  47.845  58.171  1.00 33.03           C  
ATOM   1718  NE  ARG B  91      35.089  46.423  57.829  1.00 36.72           N  
ATOM   1719  CZ  ARG B  91      36.148  45.770  57.358  1.00 38.20           C  
ATOM   1720  NH1 ARG B  91      37.295  46.409  57.170  1.00 39.77           N  
ATOM   1721  NH2 ARG B  91      36.062  44.478  57.075  1.00 39.76           N  
ATOM   1722  N   MET B  92      35.817  45.662  63.071  1.00 15.17           N  
ATOM   1723  CA  MET B  92      35.213  44.911  64.165  1.00 13.96           C  
ATOM   1724  C   MET B  92      36.172  44.564  65.295  1.00 13.85           C  
ATOM   1725  O   MET B  92      37.348  44.287  65.062  1.00 14.41           O  
ATOM   1726  CB  MET B  92      34.611  43.608  63.639  1.00 14.41           C  
ATOM   1727  CG  MET B  92      33.564  43.771  62.552  1.00 17.71           C  
ATOM   1728  SD  MET B  92      32.208  44.837  63.044  1.00 21.44           S  
ATOM   1729  CE  MET B  92      31.503  43.916  64.358  1.00 20.60           C  
ATOM   1730  N   GLY B  93      35.638  44.563  66.514  1.00 11.03           N  
ATOM   1731  CA  GLY B  93      36.410  44.232  67.695  1.00 11.54           C  
ATOM   1732  C   GLY B  93      35.645  43.284  68.602  1.00  9.70           C  
ATOM   1733  O   GLY B  93      34.415  43.158  68.518  1.00  9.47           O  
ATOM   1734  N   LEU B  94      36.385  42.616  69.478  1.00  9.32           N  
ATOM   1735  CA  LEU B  94      35.818  41.659  70.414  1.00  9.69           C  
ATOM   1736  C   LEU B  94      36.421  41.878  71.795  1.00 10.59           C  
ATOM   1737  O   LEU B  94      37.639  41.959  71.942  1.00 11.13           O  
ATOM   1738  CB  LEU B  94      36.130  40.236  69.933  1.00 12.04           C  
ATOM   1739  CG  LEU B  94      35.649  39.040  70.752  1.00 15.17           C  
ATOM   1740  CD1 LEU B  94      34.139  38.944  70.674  1.00 17.74           C  
ATOM   1741  CD2 LEU B  94      36.286  37.766  70.204  1.00 15.72           C  
ATOM   1742  N   TYR B  95      35.560  41.994  72.798  1.00  9.05           N  
ATOM   1743  CA  TYR B  95      35.980  42.171  74.182  1.00  8.52           C  
ATOM   1744  C   TYR B  95      35.430  40.990  74.965  1.00 10.58           C  
ATOM   1745  O   TYR B  95      34.235  40.699  74.899  1.00 10.53           O  
ATOM   1746  CB  TYR B  95      35.399  43.462  74.764  1.00  9.94           C  
ATOM   1747  CG  TYR B  95      35.656  43.651  76.242  1.00  9.83           C  
ATOM   1748  CD1 TYR B  95      36.847  44.206  76.696  1.00 12.73           C  
ATOM   1749  CD2 TYR B  95      34.705  43.264  77.189  1.00 11.96           C  
ATOM   1750  CE1 TYR B  95      37.094  44.378  78.053  1.00 12.69           C  
ATOM   1751  CE2 TYR B  95      34.943  43.431  78.556  1.00 12.59           C  
ATOM   1752  CZ  TYR B  95      36.139  43.987  78.977  1.00 13.57           C  
ATOM   1753  OH  TYR B  95      36.395  44.141  80.324  1.00 15.90           O  
ATOM   1754  N   VAL B  96      36.303  40.304  75.692  1.00  8.42           N  
ATOM   1755  CA  VAL B  96      35.894  39.172  76.506  1.00  9.39           C  
ATOM   1756  C   VAL B  96      36.472  39.348  77.904  1.00  9.68           C  
ATOM   1757  O   VAL B  96      37.653  39.660  78.060  1.00 10.45           O  
ATOM   1758  CB  VAL B  96      36.402  37.840  75.918  1.00  8.74           C  
ATOM   1759  CG1 VAL B  96      35.937  36.676  76.781  1.00 11.00           C  
ATOM   1760  CG2 VAL B  96      35.897  37.677  74.496  1.00 11.95           C  
ATOM   1761  N   ASP B  97      35.641  39.160  78.923  1.00  9.92           N  
ATOM   1762  CA  ASP B  97      36.106  39.297  80.293  1.00 10.70           C  
ATOM   1763  C   ASP B  97      35.427  38.240  81.152  1.00 12.77           C  
ATOM   1764  O   ASP B  97      34.273  37.884  80.924  1.00 13.59           O  
ATOM   1765  CB  ASP B  97      35.794  40.703  80.821  1.00 13.13           C  
ATOM   1766  CG  ASP B  97      36.502  41.012  82.136  1.00 17.16           C  
ATOM   1767  OD1 ASP B  97      37.542  40.384  82.430  1.00 19.70           O  
ATOM   1768  OD2 ASP B  97      36.025  41.900  82.868  1.00 24.15           O  
ATOM   1769  N   GLU B  98      36.162  37.718  82.123  1.00 12.81           N  
ATOM   1770  CA  GLU B  98      35.614  36.708  83.008  1.00 15.21           C  
ATOM   1771  C   GLU B  98      34.478  37.263  83.847  1.00 15.25           C  
ATOM   1772  O   GLU B  98      34.570  38.369  84.388  1.00 17.38           O  
ATOM   1773  CB  GLU B  98      36.702  36.165  83.938  1.00 17.94           C  
ATOM   1774  CG  GLU B  98      37.578  35.097  83.322  1.00 22.41           C  
ATOM   1775  CD  GLU B  98      38.542  34.495  84.327  1.00 24.43           C  
ATOM   1776  OE1 GLU B  98      38.108  34.190  85.457  1.00 29.19           O  
ATOM   1777  OE2 GLU B  98      39.727  34.319  83.984  1.00 28.36           O  
ATOM   1778  N   ALA B  99      33.401  36.492  83.939  1.00 15.56           N  
ATOM   1779  CA  ALA B  99      32.244  36.863  84.745  1.00 16.62           C  
ATOM   1780  C   ALA B  99      32.157  35.739  85.767  1.00 18.45           C  
ATOM   1781  O   ALA B  99      31.309  34.853  85.673  1.00 19.84           O  
ATOM   1782  CB  ALA B  99      30.986  36.908  83.888  1.00 17.07           C  
ATOM   1783  N   GLY B 100      33.059  35.777  86.739  1.00 19.66           N  
ATOM   1784  CA  GLY B 100      33.085  34.731  87.739  1.00 20.30           C  
ATOM   1785  C   GLY B 100      33.957  33.611  87.213  1.00 20.76           C  
ATOM   1786  O   GLY B 100      34.553  33.725  86.141  1.00 21.66           O  
ATOM   1787  N   GLU B 101      34.020  32.510  87.948  1.00 21.56           N  
ATOM   1788  CA  GLU B 101      34.854  31.390  87.551  1.00 21.92           C  
ATOM   1789  C   GLU B 101      34.332  30.526  86.410  1.00 20.09           C  
ATOM   1790  O   GLU B 101      35.109  29.831  85.762  1.00 20.41           O  
ATOM   1791  CB  GLU B 101      35.119  30.495  88.764  1.00 26.39           C  
ATOM   1792  CG  GLU B 101      35.996  31.141  89.818  1.00 31.47           C  
ATOM   1793  CD  GLU B 101      37.359  31.516  89.273  1.00 34.75           C  
ATOM   1794  OE1 GLU B 101      38.078  30.610  88.801  1.00 36.75           O  
ATOM   1795  OE2 GLU B 101      37.712  32.715  89.315  1.00 37.75           O  
ATOM   1796  N   HIS B 102      33.031  30.574  86.143  1.00 18.06           N  
ATOM   1797  CA  HIS B 102      32.482  29.713  85.104  1.00 17.48           C  
ATOM   1798  C   HIS B 102      31.770  30.369  83.933  1.00 16.70           C  
ATOM   1799  O   HIS B 102      31.113  29.680  83.155  1.00 17.21           O  
ATOM   1800  CB  HIS B 102      31.532  28.694  85.737  1.00 21.23           C  
ATOM   1801  CG  HIS B 102      32.127  27.958  86.896  1.00 24.30           C  
ATOM   1802  ND1 HIS B 102      32.042  28.415  88.192  1.00 28.95           N  
ATOM   1803  CD2 HIS B 102      32.847  26.811  86.948  1.00 27.63           C  
ATOM   1804  CE1 HIS B 102      32.681  27.583  88.994  1.00 28.47           C  
ATOM   1805  NE2 HIS B 102      33.180  26.602  88.264  1.00 28.69           N  
ATOM   1806  N   ALA B 103      31.896  31.683  83.792  1.00 13.56           N  
ATOM   1807  CA  ALA B 103      31.231  32.357  82.684  1.00 11.96           C  
ATOM   1808  C   ALA B 103      32.091  33.467  82.096  1.00 10.37           C  
ATOM   1809  O   ALA B 103      33.070  33.898  82.701  1.00 11.93           O  
ATOM   1810  CB  ALA B 103      29.886  32.916  83.139  1.00 12.59           C  
ATOM   1811  N   LEU B 104      31.702  33.920  80.909  1.00  9.98           N  
ATOM   1812  CA  LEU B 104      32.427  34.962  80.197  1.00 10.24           C  
ATOM   1813  C   LEU B 104      31.473  35.983  79.603  1.00 10.17           C  
ATOM   1814  O   LEU B 104      30.428  35.618  79.063  1.00 10.63           O  
ATOM   1815  CB  LEU B 104      33.224  34.349  79.042  1.00 11.28           C  
ATOM   1816  CG  LEU B 104      34.284  33.291  79.361  1.00 11.80           C  
ATOM   1817  CD1 LEU B 104      34.707  32.572  78.089  1.00 13.61           C  
ATOM   1818  CD2 LEU B 104      35.473  33.954  80.023  1.00 13.43           C  
ATOM   1819  N   LEU B 105      31.838  37.255  79.713  1.00 10.22           N  
ATOM   1820  CA  LEU B 105      31.060  38.335  79.117  1.00  9.56           C  
ATOM   1821  C   LEU B 105      31.705  38.576  77.757  1.00 10.23           C  
ATOM   1822  O   LEU B 105      32.928  38.673  77.661  1.00 10.93           O  
ATOM   1823  CB  LEU B 105      31.165  39.622  79.934  1.00  9.93           C  
ATOM   1824  CG  LEU B 105      30.676  40.862  79.169  1.00 12.60           C  
ATOM   1825  CD1 LEU B 105      29.166  40.789  78.946  1.00 11.68           C  
ATOM   1826  CD2 LEU B 105      31.048  42.109  79.937  1.00 14.40           C  
ATOM   1827  N   VAL B 106      30.890  38.663  76.715  1.00  9.37           N  
ATOM   1828  CA  VAL B 106      31.389  38.896  75.365  1.00  8.98           C  
ATOM   1829  C   VAL B 106      30.708  40.121  74.757  1.00  9.04           C  
ATOM   1830  O   VAL B 106      29.487  40.229  74.780  1.00  9.08           O  
ATOM   1831  CB  VAL B 106      31.095  37.690  74.441  1.00  8.27           C  
ATOM   1832  CG1 VAL B 106      31.638  37.960  73.040  1.00  9.59           C  
ATOM   1833  CG2 VAL B 106      31.709  36.415  75.027  1.00 11.44           C  
ATOM   1834  N   LEU B 107      31.503  41.057  74.245  1.00  9.33           N  
ATOM   1835  CA  LEU B 107      30.954  42.237  73.584  1.00  7.78           C  
ATOM   1836  C   LEU B 107      31.552  42.307  72.191  1.00  8.41           C  
ATOM   1837  O   LEU B 107      32.769  42.221  72.027  1.00  9.22           O  
ATOM   1838  CB  LEU B 107      31.303  43.526  74.333  1.00  8.96           C  
ATOM   1839  CG  LEU B 107      30.753  43.699  75.750  1.00  8.51           C  
ATOM   1840  CD1 LEU B 107      31.231  45.024  76.340  1.00 10.68           C  
ATOM   1841  CD2 LEU B 107      29.226  43.668  75.711  1.00 10.90           C  
ATOM   1842  N   VAL B 108      30.693  42.431  71.188  1.00  8.57           N  
ATOM   1843  CA  VAL B 108      31.133  42.561  69.802  1.00  9.07           C  
ATOM   1844  C   VAL B 108      30.840  44.011  69.451  1.00  9.66           C  
ATOM   1845  O   VAL B 108      29.719  44.491  69.655  1.00  9.25           O  
ATOM   1846  CB  VAL B 108      30.340  41.639  68.862  1.00  9.20           C  
ATOM   1847  CG1 VAL B 108      30.715  41.931  67.408  1.00 10.10           C  
ATOM   1848  CG2 VAL B 108      30.626  40.185  69.207  1.00 12.49           C  
ATOM   1849  N   PHE B 109      31.838  44.712  68.924  1.00  9.31           N  
ATOM   1850  CA  PHE B 109      31.647  46.121  68.618  1.00  9.56           C  
ATOM   1851  C   PHE B 109      32.312  46.539  67.323  1.00 11.71           C  
ATOM   1852  O   PHE B 109      33.141  45.811  66.775  1.00 13.05           O  
ATOM   1853  CB  PHE B 109      32.180  46.966  69.789  1.00 11.56           C  
ATOM   1854  CG  PHE B 109      33.653  46.767  70.080  1.00 10.91           C  
ATOM   1855  CD1 PHE B 109      34.613  47.588  69.492  1.00 12.10           C  
ATOM   1856  CD2 PHE B 109      34.080  45.760  70.949  1.00 12.18           C  
ATOM   1857  CE1 PHE B 109      35.977  47.409  69.762  1.00 13.85           C  
ATOM   1858  CE2 PHE B 109      35.437  45.572  71.225  1.00 12.12           C  
ATOM   1859  CZ  PHE B 109      36.386  46.395  70.633  1.00 13.14           C  
ATOM   1860  N   ASP B 110      31.912  47.699  66.818  1.00 11.39           N  
ATOM   1861  CA  ASP B 110      32.499  48.243  65.602  1.00 12.90           C  
ATOM   1862  C   ASP B 110      33.086  49.614  65.927  1.00 13.63           C  
ATOM   1863  O   ASP B 110      33.265  49.951  67.104  1.00 13.50           O  
ATOM   1864  CB  ASP B 110      31.465  48.292  64.455  1.00 13.48           C  
ATOM   1865  CG  ASP B 110      30.270  49.181  64.750  1.00 13.81           C  
ATOM   1866  OD1 ASP B 110      29.193  48.935  64.166  1.00 15.49           O  
ATOM   1867  OD2 ASP B 110      30.401  50.127  65.538  1.00 13.92           O  
ATOM   1868  N   GLU B 111      33.408  50.398  64.904  1.00 15.01           N  
ATOM   1869  CA  GLU B 111      34.013  51.706  65.130  1.00 17.80           C  
ATOM   1870  C   GLU B 111      33.152  52.698  65.900  1.00 16.17           C  
ATOM   1871  O   GLU B 111      33.667  53.690  66.416  1.00 17.36           O  
ATOM   1872  CB  GLU B 111      34.436  52.339  63.799  1.00 21.40           C  
ATOM   1873  CG  GLU B 111      33.328  52.402  62.769  1.00 27.20           C  
ATOM   1874  CD  GLU B 111      33.422  51.281  61.759  1.00 30.90           C  
ATOM   1875  OE1 GLU B 111      34.257  51.392  60.834  1.00 32.20           O  
ATOM   1876  OE2 GLU B 111      32.674  50.287  61.896  1.00 30.42           O  
ATOM   1877  N   THR B 112      31.852  52.442  65.992  1.00 14.15           N  
ATOM   1878  CA  THR B 112      30.986  53.371  66.708  1.00 14.18           C  
ATOM   1879  C   THR B 112      30.969  53.163  68.218  1.00 13.65           C  
ATOM   1880  O   THR B 112      30.288  53.887  68.941  1.00 14.69           O  
ATOM   1881  CB  THR B 112      29.536  53.358  66.157  1.00 13.23           C  
ATOM   1882  OG1 THR B 112      28.921  52.080  66.367  1.00 14.07           O  
ATOM   1883  CG2 THR B 112      29.547  53.683  64.673  1.00 15.56           C  
ATOM   1884  N   ALA B 113      31.732  52.185  68.693  1.00 13.71           N  
ATOM   1885  CA  ALA B 113      31.830  51.919  70.126  1.00 12.62           C  
ATOM   1886  C   ALA B 113      33.218  52.353  70.588  1.00 13.48           C  
ATOM   1887  O   ALA B 113      34.219  51.707  70.263  1.00 12.99           O  
ATOM   1888  CB  ALA B 113      31.630  50.438  70.405  1.00 12.42           C  
ATOM   1889  N   PRO B 114      33.305  53.464  71.336  1.00 13.07           N  
ATOM   1890  CA  PRO B 114      34.616  53.926  71.808  1.00 14.21           C  
ATOM   1891  C   PRO B 114      35.240  52.828  72.664  1.00 13.75           C  
ATOM   1892  O   PRO B 114      34.606  52.335  73.593  1.00 13.15           O  
ATOM   1893  CB  PRO B 114      34.273  55.171  72.627  1.00 14.96           C  
ATOM   1894  CG  PRO B 114      32.981  55.647  72.016  1.00 14.92           C  
ATOM   1895  CD  PRO B 114      32.231  54.359  71.793  1.00 13.45           C  
ATOM   1896  N   LEU B 115      36.476  52.446  72.358  1.00 13.66           N  
ATOM   1897  CA  LEU B 115      37.133  51.379  73.103  1.00 13.63           C  
ATOM   1898  C   LEU B 115      37.190  51.644  74.603  1.00 12.87           C  
ATOM   1899  O   LEU B 115      37.017  50.728  75.402  1.00 13.80           O  
ATOM   1900  CB  LEU B 115      38.548  51.143  72.569  1.00 15.58           C  
ATOM   1901  CG  LEU B 115      39.291  49.966  73.204  1.00 16.34           C  
ATOM   1902  CD1 LEU B 115      38.514  48.674  72.992  1.00 17.56           C  
ATOM   1903  CD2 LEU B 115      40.676  49.860  72.584  1.00 20.04           C  
ATOM   1904  N   GLY B 116      37.424  52.896  74.982  1.00 12.86           N  
ATOM   1905  CA  GLY B 116      37.492  53.229  76.393  1.00 14.07           C  
ATOM   1906  C   GLY B 116      36.177  52.939  77.092  1.00 13.33           C  
ATOM   1907  O   GLY B 116      36.156  52.507  78.245  1.00 14.41           O  
ATOM   1908  N   LYS B 117      35.074  53.174  76.390  1.00 13.04           N  
ATOM   1909  CA  LYS B 117      33.749  52.931  76.954  1.00 13.45           C  
ATOM   1910  C   LYS B 117      33.513  51.425  77.041  1.00 12.28           C  
ATOM   1911  O   LYS B 117      32.960  50.919  78.020  1.00 11.72           O  
ATOM   1912  CB  LYS B 117      32.671  53.566  76.073  1.00 16.22           C  
ATOM   1913  CG  LYS B 117      32.709  55.086  75.990  1.00 20.83           C  
ATOM   1914  CD  LYS B 117      32.132  55.736  77.232  1.00 25.45           C  
ATOM   1915  CE  LYS B 117      31.949  57.234  77.020  1.00 26.56           C  
ATOM   1916  NZ  LYS B 117      31.169  57.853  78.125  1.00 30.29           N  
ATOM   1917  N   VAL B 118      33.934  50.705  76.007  1.00 11.24           N  
ATOM   1918  CA  VAL B 118      33.774  49.259  75.984  1.00 12.37           C  
ATOM   1919  C   VAL B 118      34.453  48.614  77.191  1.00 12.63           C  
ATOM   1920  O   VAL B 118      33.862  47.781  77.877  1.00 12.83           O  
ATOM   1921  CB  VAL B 118      34.369  48.660  74.681  1.00 11.54           C  
ATOM   1922  CG1 VAL B 118      34.412  47.142  74.771  1.00 12.36           C  
ATOM   1923  CG2 VAL B 118      33.527  49.086  73.484  1.00 11.69           C  
ATOM   1924  N   LYS B 119      35.689  49.014  77.458  1.00 13.36           N  
ATOM   1925  CA  LYS B 119      36.430  48.439  78.572  1.00 14.72           C  
ATOM   1926  C   LYS B 119      35.919  48.878  79.935  1.00 13.84           C  
ATOM   1927  O   LYS B 119      35.859  48.075  80.873  1.00 14.86           O  
ATOM   1928  CB  LYS B 119      37.913  48.767  78.427  1.00 16.76           C  
ATOM   1929  CG  LYS B 119      38.484  48.267  77.105  1.00 20.11           C  
ATOM   1930  CD  LYS B 119      39.997  48.273  77.094  1.00 22.35           C  
ATOM   1931  CE  LYS B 119      40.554  47.195  78.007  1.00 24.96           C  
ATOM   1932  NZ  LYS B 119      42.038  47.197  77.990  1.00 26.06           N  
ATOM   1933  N   LEU B 120      35.543  50.148  80.044  1.00 13.32           N  
ATOM   1934  CA  LEU B 120      35.028  50.683  81.301  1.00 13.98           C  
ATOM   1935  C   LEU B 120      33.728  49.990  81.696  1.00 13.09           C  
ATOM   1936  O   LEU B 120      33.630  49.367  82.754  1.00 12.85           O  
ATOM   1937  CB  LEU B 120      34.780  52.190  81.165  1.00 16.52           C  
ATOM   1938  CG  LEU B 120      34.111  52.888  82.354  1.00 21.49           C  
ATOM   1939  CD1 LEU B 120      35.005  52.777  83.563  1.00 24.43           C  
ATOM   1940  CD2 LEU B 120      33.845  54.350  82.021  1.00 23.12           C  
ATOM   1941  N   HIS B 121      32.729  50.085  80.829  1.00 11.78           N  
ATOM   1942  CA  HIS B 121      31.436  49.485  81.121  1.00 11.53           C  
ATOM   1943  C   HIS B 121      31.447  47.970  80.977  1.00 11.37           C  
ATOM   1944  O   HIS B 121      30.643  47.274  81.600  1.00 12.93           O  
ATOM   1945  CB  HIS B 121      30.375  50.149  80.244  1.00 11.75           C  
ATOM   1946  CG  HIS B 121      30.242  51.618  80.503  1.00 13.07           C  
ATOM   1947  ND1 HIS B 121      29.607  52.120  81.619  1.00 13.81           N  
ATOM   1948  CD2 HIS B 121      30.736  52.690  79.838  1.00 13.08           C  
ATOM   1949  CE1 HIS B 121      29.716  53.437  81.630  1.00 14.07           C  
ATOM   1950  NE2 HIS B 121      30.398  53.808  80.561  1.00 15.29           N  
ATOM   1951  N   GLY B 122      32.366  47.457  80.160  1.00 12.28           N  
ATOM   1952  CA  GLY B 122      32.487  46.020  80.008  1.00 12.43           C  
ATOM   1953  C   GLY B 122      32.966  45.422  81.323  1.00 11.40           C  
ATOM   1954  O   GLY B 122      32.479  44.383  81.751  1.00 12.13           O  
ATOM   1955  N   LYS B 123      33.921  46.085  81.973  1.00 13.17           N  
ATOM   1956  CA  LYS B 123      34.434  45.600  83.254  1.00 12.33           C  
ATOM   1957  C   LYS B 123      33.332  45.654  84.317  1.00 12.74           C  
ATOM   1958  O   LYS B 123      33.181  44.737  85.126  1.00 13.76           O  
ATOM   1959  CB  LYS B 123      35.637  46.444  83.693  1.00 14.71           C  
ATOM   1960  CG  LYS B 123      36.207  46.062  85.050  1.00 17.74           C  
ATOM   1961  CD  LYS B 123      36.647  44.606  85.096  1.00 20.25           C  
ATOM   1962  CE  LYS B 123      37.814  44.339  84.158  1.00 22.77           C  
ATOM   1963  NZ  LYS B 123      38.246  42.912  84.214  1.00 24.55           N  
ATOM   1964  N   ARG B 124      32.557  46.733  84.319  1.00 12.47           N  
ATOM   1965  CA  ARG B 124      31.480  46.842  85.291  1.00 12.43           C  
ATOM   1966  C   ARG B 124      30.460  45.735  85.055  1.00 12.03           C  
ATOM   1967  O   ARG B 124      29.928  45.146  85.997  1.00 12.87           O  
ATOM   1968  CB  ARG B 124      30.805  48.206  85.188  1.00 12.24           C  
ATOM   1969  CG  ARG B 124      31.684  49.356  85.641  1.00 14.22           C  
ATOM   1970  CD  ARG B 124      30.986  50.684  85.458  1.00 14.84           C  
ATOM   1971  NE  ARG B 124      31.780  51.777  86.006  1.00 13.93           N  
ATOM   1972  CZ  ARG B 124      31.456  53.060  85.895  1.00 15.77           C  
ATOM   1973  NH1 ARG B 124      30.350  53.412  85.255  1.00 16.11           N  
ATOM   1974  NH2 ARG B 124      32.242  53.992  86.422  1.00 17.32           N  
ATOM   1975  N   ALA B 125      30.194  45.441  83.789  1.00 11.54           N  
ATOM   1976  CA  ALA B 125      29.231  44.404  83.459  1.00 11.64           C  
ATOM   1977  C   ALA B 125      29.706  43.026  83.895  1.00 11.38           C  
ATOM   1978  O   ALA B 125      28.933  42.247  84.455  1.00 12.71           O  
ATOM   1979  CB  ALA B 125      28.953  44.406  81.964  1.00 11.62           C  
ATOM   1980  N   SER B 126      30.976  42.720  83.645  1.00 11.95           N  
ATOM   1981  CA  SER B 126      31.484  41.407  84.014  1.00 13.13           C  
ATOM   1982  C   SER B 126      31.398  41.188  85.519  1.00 14.06           C  
ATOM   1983  O   SER B 126      31.081  40.090  85.965  1.00 13.58           O  
ATOM   1984  CB  SER B 126      32.923  41.217  83.519  1.00 15.18           C  
ATOM   1985  OG  SER B 126      33.819  42.115  84.144  1.00 17.91           O  
ATOM   1986  N   GLU B 127      31.668  42.226  86.304  1.00 13.98           N  
ATOM   1987  CA  GLU B 127      31.578  42.073  87.752  1.00 16.48           C  
ATOM   1988  C   GLU B 127      30.133  41.870  88.186  1.00 17.27           C  
ATOM   1989  O   GLU B 127      29.841  41.042  89.053  1.00 17.33           O  
ATOM   1990  CB  GLU B 127      32.135  43.289  88.484  1.00 20.36           C  
ATOM   1991  CG  GLU B 127      31.873  43.193  89.978  1.00 26.33           C  
ATOM   1992  CD  GLU B 127      32.298  44.418  90.737  1.00 31.52           C  
ATOM   1993  OE1 GLU B 127      31.841  45.526  90.383  1.00 34.62           O  
ATOM   1994  OE2 GLU B 127      33.085  44.268  91.696  1.00 35.10           O  
ATOM   1995  N   ALA B 128      29.223  42.637  87.592  1.00 14.87           N  
ATOM   1996  CA  ALA B 128      27.813  42.517  87.935  1.00 15.48           C  
ATOM   1997  C   ALA B 128      27.308  41.122  87.590  1.00 15.73           C  
ATOM   1998  O   ALA B 128      26.565  40.509  88.354  1.00 17.32           O  
ATOM   1999  CB  ALA B 128      27.002  43.564  87.193  1.00 15.52           C  
ATOM   2000  N   LEU B 129      27.723  40.617  86.433  1.00 14.44           N  
ATOM   2001  CA  LEU B 129      27.301  39.297  85.996  1.00 15.26           C  
ATOM   2002  C   LEU B 129      27.929  38.197  86.841  1.00 17.06           C  
ATOM   2003  O   LEU B 129      27.332  37.137  87.023  1.00 18.22           O  
ATOM   2004  CB  LEU B 129      27.644  39.103  84.516  1.00 14.37           C  
ATOM   2005  CG  LEU B 129      26.791  39.973  83.588  1.00 14.72           C  
ATOM   2006  CD1 LEU B 129      27.458  40.113  82.229  1.00 14.11           C  
ATOM   2007  CD2 LEU B 129      25.406  39.361  83.450  1.00 14.04           C  
ATOM   2008  N   ALA B 130      29.127  38.451  87.355  1.00 16.87           N  
ATOM   2009  CA  ALA B 130      29.807  37.475  88.198  1.00 18.31           C  
ATOM   2010  C   ALA B 130      28.960  37.249  89.449  1.00 20.93           C  
ATOM   2011  O   ALA B 130      28.777  36.113  89.888  1.00 22.87           O  
ATOM   2012  CB  ALA B 130      31.188  37.982  88.584  1.00 18.27           C  
ATOM   2013  N   ARG B 131      28.435  38.334  90.009  1.00 23.29           N  
ATOM   2014  CA  ARG B 131      27.604  38.242  91.205  1.00 26.53           C  
ATOM   2015  C   ARG B 131      26.282  37.538  90.924  1.00 27.75           C  
ATOM   2016  O   ARG B 131      25.806  36.742  91.736  1.00 27.90           O  
ATOM   2017  CB  ARG B 131      27.325  39.636  91.773  1.00 28.59           C  
ATOM   2018  CG  ARG B 131      28.541  40.322  92.365  1.00 33.36           C  
ATOM   2019  CD  ARG B 131      28.128  41.426  93.329  1.00 37.00           C  
ATOM   2020  NE  ARG B 131      29.276  42.010  94.020  1.00 40.78           N  
ATOM   2021  CZ  ARG B 131      29.184  42.840  95.054  1.00 41.36           C  
ATOM   2022  NH1 ARG B 131      27.994  43.190  95.526  1.00 42.75           N  
ATOM   2023  NH2 ARG B 131      30.283  43.321  95.618  1.00 42.48           N  
ATOM   2024  N   ILE B 132      25.692  37.831  89.771  1.00 28.02           N  
ATOM   2025  CA  ILE B 132      24.426  37.222  89.380  1.00 29.33           C  
ATOM   2026  C   ILE B 132      24.586  35.723  89.134  1.00 31.84           C  
ATOM   2027  O   ILE B 132      23.758  34.919  89.567  1.00 31.75           O  
ATOM   2028  CB  ILE B 132      23.875  37.879  88.094  1.00 27.63           C  
ATOM   2029  CG1 ILE B 132      23.592  39.360  88.350  1.00 26.58           C  
ATOM   2030  CG2 ILE B 132      22.612  37.163  87.636  1.00 28.38           C  
ATOM   2031  CD1 ILE B 132      23.201  40.134  87.104  1.00 25.00           C  
ATOM   2032  N   ALA B 133      25.659  35.358  88.441  1.00 33.70           N  
ATOM   2033  CA  ALA B 133      25.935  33.963  88.121  1.00 36.13           C  
ATOM   2034  C   ALA B 133      26.025  33.096  89.370  1.00 38.08           C  
ATOM   2035  O   ALA B 133      25.463  32.001  89.417  1.00 38.24           O  
ATOM   2036  CB  ALA B 133      27.231  33.862  87.324  1.00 36.41           C  
ATOM   2037  N   GLU B 134      26.731  33.593  90.379  1.00 39.93           N  
ATOM   2038  CA  GLU B 134      26.905  32.864  91.630  1.00 42.57           C  
ATOM   2039  C   GLU B 134      25.585  32.635  92.354  1.00 43.15           C  
ATOM   2040  O   GLU B 134      25.207  31.496  92.629  1.00 43.50           O  
ATOM   2041  CB  GLU B 134      27.863  33.623  92.548  1.00 43.28           C  
ATOM   2042  CG  GLU B 134      29.259  33.795  91.981  1.00 46.27           C  
ATOM   2043  CD  GLU B 134      30.171  34.568  92.910  1.00 47.32           C  
ATOM   2044  OE1 GLU B 134      30.357  34.126  94.064  1.00 48.04           O  
ATOM   2045  OE2 GLU B 134      30.700  35.618  92.487  1.00 48.70           O  
ATOM   2046  N   GLU B 135      24.891  33.724  92.664  1.00 44.24           N  
ATOM   2047  CA  GLU B 135      23.615  33.646  93.363  1.00 45.33           C  
ATOM   2048  C   GLU B 135      22.607  32.789  92.604  1.00 45.95           C  
ATOM   2049  O   GLU B 135      21.742  32.152  93.206  1.00 45.88           O  
ATOM   2050  CB  GLU B 135      23.048  35.051  93.573  1.00 46.42           C  
ATOM   2051  CG  GLU B 135      23.948  35.959  94.397  1.00 48.32           C  
ATOM   2052  CD  GLU B 135      23.349  37.334  94.615  1.00 49.87           C  
ATOM   2053  OE1 GLU B 135      22.244  37.416  95.193  1.00 50.86           O  
ATOM   2054  OE2 GLU B 135      23.981  38.333  94.212  1.00 50.54           O  
ATOM   2055  N   ALA B 136      22.725  32.773  91.280  1.00 46.06           N  
ATOM   2056  CA  ALA B 136      21.823  31.992  90.441  1.00 46.61           C  
ATOM   2057  C   ALA B 136      22.018  30.498  90.678  1.00 47.13           C  
ATOM   2058  O   ALA B 136      21.016  29.816  90.979  1.00 47.34           O  
ATOM   2059  CB  ALA B 136      22.058  32.325  88.973  1.00 46.73           C  
TER    2060      ALA B 136                                                      
END
MOLECULE T0412.pdb
ATOM      1  N   SER     1      17.559  26.951  92.213  1.00 54.32           N  
ATOM      2  CA  SER     1      16.245  27.299  92.853  1.00 53.09           C  
ATOM      3  C   SER     1      16.043  28.831  93.060  1.00 52.29           C  
ATOM      4  O   SER     1      15.077  29.281  93.761  1.00 50.93           O  
ATOM      5  CB  SER     1      16.073  26.547  94.152  1.00 52.87           C  
ATOM      6  OG  SER     1      14.779  26.777  94.666  1.00 52.80           O  
ATOM      7  N   ASN     2      16.948  29.599  92.427  1.00 50.24           N  
ATOM      8  CA  ASN     2      16.884  31.054  92.474  1.00 48.93           C  
ATOM      9  C   ASN     2      17.383  31.628  91.189  1.00 47.18           C  
ATOM     10  O   ASN     2      17.733  32.795  91.079  1.00 47.53           O  
ATOM     11  CB  ASN     2      17.619  31.623  93.683  1.00 49.45           C  
ATOM     12  CG  ASN     2      17.125  33.004  94.040  1.00 49.02           C  
ATOM     13  OD1 ASN     2      17.498  33.973  93.384  1.00 51.47           O  
ATOM     14  ND2 ASN     2      16.253  33.099  95.026  1.00 44.65           N  
ATOM     15  N   ALA     3      17.385  30.732  90.212  1.00 45.59           N  
ATOM     16  CA  ALA     3      17.756  30.926  88.865  1.00 42.81           C  
ATOM     17  C   ALA     3      17.150  32.162  88.216  1.00 42.42           C  
ATOM     18  O   ALA     3      17.817  32.797  87.411  1.00 43.10           O  
ATOM     19  CB  ALA     3      17.328  29.686  88.100  1.00 42.78           C  
ATOM     20  N   LEU     4      15.891  32.474  88.499  1.00 40.84           N  
ATOM     21  CA  LEU     4      15.175  33.549  87.776  1.00 41.08           C  
ATOM     22  C   LEU     4      15.595  34.992  88.193  1.00 41.73           C  
ATOM     23  O   LEU     4      15.795  35.891  87.336  1.00 40.99           O  
ATOM     24  CB  LEU     4      13.630  33.366  87.879  1.00 40.15           C  
ATOM     25  CG  LEU     4      13.042  32.123  87.172  1.00 39.13           C  
ATOM     26  CD1 LEU     4      11.515  32.115  87.181  1.00 37.64           C  
ATOM     27  CD2 LEU     4      13.561  32.029  85.757  1.00 33.72           C  
ATOM     28  N   PHE     5      15.747  35.183  89.503  1.00 42.10           N  
ATOM     29  CA  PHE     5      16.276  36.410  90.043  1.00 43.47           C  
ATOM     30  C   PHE     5      17.723  36.613  89.583  1.00 45.53           C  
ATOM     31  O   PHE     5      18.087  37.717  89.179  1.00 45.52           O  
ATOM     32  CB  PHE     5      16.153  36.419  91.539  1.00 41.53           C  
ATOM     33  CG  PHE     5      14.758  36.708  92.026  1.00 42.02           C  
ATOM     34  CD1 PHE     5      14.162  37.953  91.794  1.00 40.73           C  
ATOM     35  CD2 PHE     5      14.057  35.762  92.772  1.00 38.83           C  
ATOM     36  CE1 PHE     5      12.860  38.232  92.300  1.00 39.71           C  
ATOM     37  CE2 PHE     5      12.788  36.019  93.254  1.00 37.43           C  
ATOM     38  CZ  PHE     5      12.175  37.252  93.015  1.00 38.76           C  
ATOM     39  N   SER     6      18.539  35.567  89.550  1.00 47.47           N  
ATOM     40  CA  SER     6      19.873  35.786  88.935  1.00 50.67           C  
ATOM     41  C   SER     6      19.841  36.120  87.464  1.00 51.41           C  
ATOM     42  O   SER     6      20.662  36.934  87.018  1.00 52.33           O  
ATOM     43  CB  SER     6      20.860  34.630  89.193  1.00 50.07           C  
ATOM     44  OG  SER     6      20.888  34.394  90.613  1.00 55.00           O  
ATOM     45  N   SER     7      18.951  35.474  86.693  1.00 52.62           N  
ATOM     46  CA  SER     7      18.913  35.704  85.234  1.00 53.39           C  
ATOM     47  C   SER     7      18.502  37.146  85.049  1.00 53.99           C  
ATOM     48  O   SER     7      19.066  37.871  84.231  1.00 54.98           O  
ATOM     49  CB  SER     7      17.939  34.768  84.510  1.00 53.69           C  
ATOM     50  OG  SER     7      18.384  33.413  84.592  1.00 54.34           O  
ATOM     51  N   ARG     8      17.565  37.583  85.866  1.00 53.65           N  
ATOM     52  CA  ARG     8      17.066  38.939  85.755  1.00 54.53           C  
ATOM     53  C   ARG     8      18.164  39.964  86.086  1.00 54.58           C  
ATOM     54  O   ARG     8      18.327  40.920  85.341  1.00 55.96           O  
ATOM     55  CB  ARG     8      15.819  39.113  86.650  1.00 54.60           C  
ATOM     56  CG  ARG     8      15.233  40.467  86.595  1.00 56.13           C  
ATOM     57  CD  ARG     8      15.106  40.985  88.004  1.00 57.96           C  
ATOM     58  NE  ARG     8      13.696  41.145  88.342  1.00 62.03           N  
ATOM     59  CZ  ARG     8      13.204  41.195  89.577  1.00 61.99           C  
ATOM     60  NH1 ARG     8      11.897  41.360  89.749  1.00 61.14           N  
ATOM     61  NH2 ARG     8      14.011  41.073  90.627  1.00 62.55           N  
ATOM     62  N   ASP     9      18.908  39.772  87.183  1.00 54.12           N  
ATOM     63  CA  ASP     9      20.074  40.595  87.510  1.00 54.08           C  
ATOM     64  C   ASP     9      21.019  40.705  86.305  1.00 54.67           C  
ATOM     65  O   ASP     9      21.399  41.806  85.927  1.00 55.78           O  
ATOM     66  CB  ASP     9      20.870  39.989  88.667  1.00 53.61           C  
ATOM     67  CG  ASP     9      20.139  40.045  90.007  1.00 55.37           C  
ATOM     68  OD1 ASP     9      19.080  40.719  90.144  1.00 57.24           O  
ATOM     69  OD2 ASP     9      20.634  39.387  90.952  1.00 56.96           O  
ATOM     70  N   ILE    10      21.384  39.573  85.702  1.00 54.19           N  
ATOM     71  CA  ILE    10      22.284  39.552  84.544  1.00 54.42           C  
ATOM     72  C   ILE    10      21.722  40.293  83.315  1.00 55.29           C  
ATOM     73  O   ILE    10      22.394  41.116  82.712  1.00 55.62           O  
ATOM     74  CB  ILE    10      22.666  38.098  84.163  1.00 53.93           C  
ATOM     75  CG1 ILE    10      23.447  37.454  85.291  1.00 53.01           C  
ATOM     76  CG2 ILE    10      23.465  38.026  82.840  1.00 53.06           C  
ATOM     77  CD1 ILE    10      23.566  35.934  85.160  1.00 52.08           C  
ATOM     78  N   LEU    11      20.489  39.975  82.942  1.00 56.18           N  
ATOM     79  CA  LEU    11      19.816  40.679  81.877  1.00 56.38           C  
ATOM     80  C   LEU    11      19.798  42.184  82.141  1.00 57.20           C  
ATOM     81  O   LEU    11      20.038  42.959  81.229  1.00 58.40           O  
ATOM     82  CB  LEU    11      18.403  40.149  81.688  1.00 55.51           C  
ATOM     83  CG  LEU    11      17.694  40.821  80.522  1.00 55.16           C  
ATOM     84  CD1 LEU    11      18.433  40.553  79.200  1.00 52.86           C  
ATOM     85  CD2 LEU    11      16.261  40.337  80.481  1.00 49.81           C  
ATOM     86  N   GLU    12      19.507  42.620  83.360  1.00 57.38           N  
ATOM     87  CA  GLU    12      19.500  44.064  83.621  1.00 58.36           C  
ATOM     88  C   GLU    12      20.894  44.699  83.355  1.00 57.39           C  
ATOM     89  O   GLU    12      20.998  45.782  82.776  1.00 57.72           O  
ATOM     90  CB  GLU    12      19.034  44.374  85.047  1.00 57.74           C  
ATOM     91  CG  GLU    12      17.531  44.332  85.205  1.00 60.40           C  
ATOM     92  CD  GLU    12      17.043  44.331  86.701  1.00 61.88           C  
ATOM     93  OE1 GLU    12      17.873  44.459  87.671  1.00 62.94           O  
ATOM     94  OE2 GLU    12      15.796  44.191  86.887  1.00 66.26           O  
ATOM     95  N   VAL    13      21.957  44.040  83.792  1.00 55.98           N  
ATOM     96  CA  VAL    13      23.286  44.551  83.529  1.00 55.60           C  
ATOM     97  C   VAL    13      23.614  44.556  82.022  1.00 55.56           C  
ATOM     98  O   VAL    13      24.168  45.541  81.501  1.00 55.72           O  
ATOM     99  CB  VAL    13      24.357  43.769  84.292  1.00 55.14           C  
ATOM    100  CG1 VAL    13      25.722  44.167  83.806  1.00 54.07           C  
ATOM    101  CG2 VAL    13      24.239  44.064  85.750  1.00 54.66           C  
ATOM    102  N   LEU    14      23.268  43.472  81.339  1.00 55.24           N  
ATOM    103  CA  LEU    14      23.531  43.338  79.920  1.00 56.29           C  
ATOM    104  C   LEU    14      22.733  44.390  79.113  1.00 56.68           C  
ATOM    105  O   LEU    14      23.240  44.984  78.188  1.00 55.03           O  
ATOM    106  CB  LEU    14      23.190  41.918  79.489  1.00 56.15           C  
ATOM    107  CG  LEU    14      23.420  41.464  78.039  1.00 58.26           C  
ATOM    108  CD1 LEU    14      24.902  41.336  77.676  1.00 56.32           C  
ATOM    109  CD2 LEU    14      22.662  40.132  77.744  1.00 56.95           C  
ATOM    110  N   GLN    15      21.476  44.617  79.488  1.00 57.39           N  
ATOM    111  CA  GLN    15      20.712  45.698  78.920  1.00 58.53           C  
ATOM    112  C   GLN    15      21.356  47.067  79.131  1.00 58.92           C  
ATOM    113  O   GLN    15      21.273  47.906  78.234  1.00 59.03           O  
ATOM    114  CB  GLN    15      19.262  45.682  79.394  1.00 57.53           C  
ATOM    115  CG  GLN    15      18.490  44.721  78.582  1.00 60.66           C  
ATOM    116  CD  GLN    15      17.050  44.549  79.011  1.00 67.03           C  
ATOM    117  OE1 GLN    15      16.699  44.686  80.206  1.00 70.49           O  
ATOM    118  NE2 GLN    15      16.197  44.222  78.046  1.00 66.34           N  
ATOM    119  N   ASP    16      21.993  47.297  80.274  1.00 59.06           N  
ATOM    120  CA  ASP    16      22.670  48.569  80.467  1.00 61.14           C  
ATOM    121  C   ASP    16      23.854  48.786  79.522  1.00 60.80           C  
ATOM    122  O   ASP    16      24.084  49.885  79.037  1.00 62.19           O  
ATOM    123  CB  ASP    16      23.144  48.748  81.898  1.00 61.68           C  
ATOM    124  CG  ASP    16      22.232  49.623  82.672  1.00 68.11           C  
ATOM    125  OD1 ASP    16      21.178  49.073  83.077  1.00 74.84           O  
ATOM    126  OD2 ASP    16      22.526  50.864  82.858  1.00 74.19           O  
ATOM    127  N   ILE    17      24.610  47.746  79.266  1.00 59.31           N  
ATOM    128  CA  ILE    17      25.768  47.894  78.435  1.00 58.61           C  
ATOM    129  C   ILE    17      25.329  48.077  76.973  1.00 58.36           C  
ATOM    130  O   ILE    17      25.962  48.806  76.173  1.00 58.26           O  
ATOM    131  CB  ILE    17      26.776  46.737  78.709  1.00 58.41           C  
ATOM    132  CG1 ILE    17      27.396  47.016  80.102  1.00 59.02           C  
ATOM    133  CG2 ILE    17      27.855  46.699  77.673  1.00 55.26           C  
ATOM    134  CD1 ILE    17      27.730  45.783  80.928  1.00 58.25           C  
ATOM    135  N   HIS    18      24.204  47.478  76.654  1.00 57.90           N  
ATOM    136  CA  HIS    18      23.629  47.664  75.351  1.00 58.94           C  
ATOM    137  C   HIS    18      23.112  49.113  75.217  1.00 59.57           C  
ATOM    138  O   HIS    18      23.374  49.768  74.222  1.00 60.69           O  
ATOM    139  CB  HIS    18      22.526  46.645  75.090  1.00 57.67           C  
ATOM    140  CG  HIS    18      21.918  46.772  73.737  1.00 57.96           C  
ATOM    141  ND1 HIS    18      20.628  47.214  73.539  1.00 58.77           N  
ATOM    142  CD2 HIS    18      22.425  46.528  72.505  1.00 58.94           C  
ATOM    143  CE1 HIS    18      20.359  47.219  72.245  1.00 60.89           C  
ATOM    144  NE2 HIS    18      21.434  46.803  71.595  1.00 61.68           N  
ATOM    145  N   MET    19      22.406  49.635  76.201  1.00 60.21           N  
ATOM    146  CA  MET    19      21.950  51.024  76.073  1.00 61.55           C  
ATOM    147  C   MET    19      23.110  51.997  75.938  1.00 61.25           C  
ATOM    148  O   MET    19      23.060  52.863  75.066  1.00 61.91           O  
ATOM    149  CB  MET    19      21.069  51.463  77.232  1.00 62.10           C  
ATOM    150  CG  MET    19      19.700  50.779  77.275  1.00 67.35           C  
ATOM    151  SD  MET    19      18.646  50.737  75.611  0.70 78.76          SE  
ATOM    152  CE  MET    19      17.526  52.242  75.897  1.00 73.10           C  
ATOM    153  N   GLU    20      24.145  51.856  76.772  1.00 60.29           N  
ATOM    154  CA  GLU    20      25.248  52.795  76.767  1.00 60.15           C  
ATOM    155  C   GLU    20      26.152  52.649  75.538  1.00 60.05           C  
ATOM    156  O   GLU    20      26.716  53.622  75.082  1.00 61.14           O  
ATOM    157  CB  GLU    20      26.110  52.629  78.003  1.00 60.63           C  
ATOM    158  CG  GLU    20      25.379  52.438  79.286  1.00 63.50           C  
ATOM    159  CD  GLU    20      25.814  53.410  80.356  1.00 68.04           C  
ATOM    160  OE1 GLU    20      26.697  54.260  80.104  1.00 70.18           O  
ATOM    161  OE2 GLU    20      25.245  53.346  81.463  1.00 72.19           O  
ATOM    162  N   THR    21      26.292  51.453  74.989  1.00 58.97           N  
ATOM    163  CA  THR    21      27.239  51.263  73.902  1.00 58.25           C  
ATOM    164  C   THR    21      26.625  51.052  72.532  1.00 58.63           C  
ATOM    165  O   THR    21      27.294  51.276  71.547  1.00 59.56           O  
ATOM    166  CB  THR    21      28.229  50.062  74.160  1.00 57.95           C  
ATOM    167  OG1 THR    21      27.559  48.822  73.928  1.00 53.65           O  
ATOM    168  CG2 THR    21      28.813  50.091  75.593  1.00 57.31           C  
ATOM    169  N   GLY    22      25.388  50.561  72.458  1.00 59.40           N  
ATOM    170  CA  GLY    22      24.713  50.279  71.177  1.00 58.70           C  
ATOM    171  C   GLY    22      25.251  49.067  70.445  1.00 59.54           C  
ATOM    172  O   GLY    22      24.683  48.653  69.426  1.00 59.78           O  
ATOM    173  N   GLU    23      26.327  48.469  70.976  1.00 59.24           N  
ATOM    174  CA  GLU    23      26.980  47.302  70.367  1.00 58.58           C  
ATOM    175  C   GLU    23      26.200  45.998  70.555  1.00 58.88           C  
ATOM    176  O   GLU    23      25.259  45.959  71.333  1.00 58.65           O  
ATOM    177  CB  GLU    23      28.390  47.164  70.925  1.00 57.76           C  
ATOM    178  CG  GLU    23      29.214  48.414  70.770  1.00 58.46           C  
ATOM    179  CD  GLU    23      29.610  48.755  69.295  1.00 59.54           C  
ATOM    180  OE1 GLU    23      29.386  47.923  68.411  1.00 54.46           O  
ATOM    181  OE2 GLU    23      30.168  49.866  69.047  1.00 60.23           O  
ATOM    182  N   THR    24      26.562  44.942  69.806  1.00 59.29           N  
ATOM    183  CA  THR    24      26.049  43.581  70.074  1.00 59.56           C  
ATOM    184  C   THR    24      26.676  43.137  71.355  1.00 59.12           C  
ATOM    185  O   THR    24      27.906  43.220  71.551  1.00 59.04           O  
ATOM    186  CB  THR    24      26.459  42.569  68.998  1.00 59.44           C  
ATOM    187  OG1 THR    24      26.050  43.044  67.721  1.00 62.46           O  
ATOM    188  CG2 THR    24      25.755  41.242  69.199  1.00 60.40           C  
ATOM    189  N   VAL    25      25.836  42.700  72.267  1.00 58.81           N  
ATOM    190  CA  VAL    25      26.314  42.319  73.595  1.00 57.45           C  
ATOM    191  C   VAL    25      25.838  40.880  73.800  1.00 57.93           C  
ATOM    192  O   VAL    25      24.808  40.483  73.197  1.00 57.90           O  
ATOM    193  CB  VAL    25      25.819  43.293  74.708  1.00 57.29           C  
ATOM    194  CG1 VAL    25      26.282  44.692  74.424  1.00 57.65           C  
ATOM    195  CG2 VAL    25      24.329  43.310  74.816  1.00 58.67           C  
ATOM    196  N   ALA    26      26.564  40.088  74.618  1.00 57.17           N  
ATOM    197  CA  ALA    26      26.181  38.702  74.836  1.00 55.78           C  
ATOM    198  C   ALA    26      26.677  38.156  76.173  1.00 56.21           C  
ATOM    199  O   ALA    26      27.692  38.660  76.718  1.00 56.85           O  
ATOM    200  CB  ALA    26      26.707  37.843  73.700  1.00 55.84           C  
ATOM    201  N   ILE    27      25.957  37.134  76.666  1.00 54.82           N  
ATOM    202  CA  ILE    27      26.373  36.215  77.724  1.00 54.97           C  
ATOM    203  C   ILE    27      26.665  34.880  77.036  1.00 55.40           C  
ATOM    204  O   ILE    27      25.875  34.388  76.208  1.00 55.50           O  
ATOM    205  CB  ILE    27      25.204  35.998  78.727  1.00 54.89           C  
ATOM    206  CG1 ILE    27      24.675  37.364  79.201  1.00 58.42           C  
ATOM    207  CG2 ILE    27      25.620  35.224  79.941  1.00 54.79           C  
ATOM    208  CD1 ILE    27      25.763  38.300  79.861  1.00 56.11           C  
ATOM    209  N   ALA    28      27.814  34.304  77.343  1.00 56.24           N  
ATOM    210  CA  ALA    28      28.220  33.025  76.762  1.00 57.33           C  
ATOM    211  C   ALA    28      28.899  32.114  77.789  1.00 58.02           C  
ATOM    212  O   ALA    28      29.500  32.581  78.756  1.00 59.65           O  
ATOM    213  CB  ALA    28      29.165  33.270  75.595  1.00 57.05           C  
ATOM    214  N   THR    29      28.831  30.815  77.549  1.00 58.45           N  
ATOM    215  CA  THR    29      29.438  29.821  78.373  1.00 59.29           C  
ATOM    216  C   THR    29      30.122  28.796  77.461  1.00 60.09           C  
ATOM    217  O   THR    29      30.062  28.945  76.238  1.00 60.75           O  
ATOM    218  CB  THR    29      28.366  29.129  79.253  1.00 59.14           C  
ATOM    219  OG1 THR    29      29.027  28.212  80.107  1.00 62.44           O  
ATOM    220  CG2 THR    29      27.313  28.329  78.420  1.00 59.03           C  
ATOM    221  N   LYS    30      30.752  27.746  78.017  1.00 60.10           N  
ATOM    222  CA  LYS    30      31.294  26.714  77.138  1.00 60.17           C  
ATOM    223  C   LYS    30      30.503  25.423  77.045  1.00 60.24           C  
ATOM    224  O   LYS    30      29.848  24.988  77.989  1.00 60.38           O  
ATOM    225  CB  LYS    30      32.766  26.424  77.403  1.00 59.87           C  
ATOM    226  CG  LYS    30      33.091  25.799  78.698  1.00 58.67           C  
ATOM    227  CD  LYS    30      34.590  25.975  78.926  1.00 56.57           C  
ATOM    228  CE  LYS    30      34.916  25.743  80.373  1.00 62.17           C  
ATOM    229  NZ  LYS    30      34.346  24.439  80.917  1.00 61.02           N  
ATOM    230  N   ASN    31      30.566  24.829  75.867  1.00 60.09           N  
ATOM    231  CA  ASN    31      29.974  23.554  75.632  1.00 60.15           C  
ATOM    232  C   ASN    31      31.129  22.711  75.064  1.00 60.85           C  
ATOM    233  O   ASN    31      31.450  22.809  73.874  1.00 60.33           O  
ATOM    234  CB  ASN    31      28.809  23.697  74.659  1.00 59.81           C  
ATOM    235  CG  ASN    31      28.273  22.369  74.202  1.00 60.90           C  
ATOM    236  OD1 ASN    31      28.415  21.365  74.897  1.00 62.42           O  
ATOM    237  ND2 ASN    31      27.650  22.343  73.028  1.00 62.72           N  
ATOM    238  N   ASP    32      31.768  21.920  75.944  1.00 60.79           N  
ATOM    239  CA  ASP    32      32.969  21.138  75.588  1.00 60.54           C  
ATOM    240  C   ASP    32      34.075  22.119  75.089  1.00 59.98           C  
ATOM    241  O   ASP    32      34.582  22.895  75.888  1.00 61.62           O  
ATOM    242  CB  ASP    32      32.586  20.014  74.598  1.00 60.03           C  
ATOM    243  CG  ASP    32      33.770  19.211  74.127  1.00 61.08           C  
ATOM    244  OD1 ASP    32      34.747  19.094  74.899  1.00 61.78           O  
ATOM    245  OD2 ASP    32      33.727  18.690  72.982  1.00 60.46           O  
ATOM    246  N   ILE    33      34.429  22.136  73.811  1.00 58.31           N  
ATOM    247  CA  ILE    33      35.454  23.066  73.335  1.00 57.06           C  
ATOM    248  C   ILE    33      34.847  24.188  72.442  1.00 58.02           C  
ATOM    249  O   ILE    33      35.556  24.857  71.665  1.00 57.54           O  
ATOM    250  CB  ILE    33      36.537  22.325  72.532  1.00 56.55           C  
ATOM    251  CG1 ILE    33      35.932  21.627  71.325  1.00 53.36           C  
ATOM    252  CG2 ILE    33      37.325  21.324  73.397  1.00 55.34           C  
ATOM    253  CD1 ILE    33      36.969  21.338  70.290  1.00 56.07           C  
ATOM    254  N   TYR    34      33.531  24.347  72.532  1.00 58.02           N  
ATOM    255  CA  TYR    34      32.789  25.305  71.721  1.00 59.60           C  
ATOM    256  C   TYR    34      32.153  26.416  72.587  1.00 60.55           C  
ATOM    257  O   TYR    34      31.805  26.201  73.766  1.00 60.57           O  
ATOM    258  CB  TYR    34      31.702  24.615  70.881  1.00 58.70           C  
ATOM    259  CG  TYR    34      32.255  23.504  70.077  1.00 59.51           C  
ATOM    260  CD1 TYR    34      32.919  23.749  68.863  1.00 62.22           C  
ATOM    261  CD2 TYR    34      32.182  22.198  70.539  1.00 56.56           C  
ATOM    262  CE1 TYR    34      33.483  22.679  68.123  1.00 61.17           C  
ATOM    263  CE2 TYR    34      32.717  21.160  69.832  1.00 56.81           C  
ATOM    264  CZ  TYR    34      33.370  21.398  68.642  1.00 59.90           C  
ATOM    265  OH  TYR    34      33.887  20.328  67.971  1.00 62.06           O  
ATOM    266  N   LEU    35      31.982  27.581  71.980  1.00 60.82           N  
ATOM    267  CA  LEU    35      31.425  28.696  72.682  1.00 62.79           C  
ATOM    268  C   LEU    35      29.913  28.510  72.508  1.00 62.91           C  
ATOM    269  O   LEU    35      29.501  28.106  71.419  1.00 64.79           O  
ATOM    270  CB  LEU    35      31.945  30.022  72.105  1.00 62.74           C  
ATOM    271  CG  LEU    35      31.470  31.295  72.849  1.00 64.45           C  
ATOM    272  CD1 LEU    35      32.360  31.531  74.025  1.00 60.26           C  
ATOM    273  CD2 LEU    35      31.499  32.507  71.931  1.00 64.70           C  
ATOM    274  N   GLN    36      29.144  28.723  73.586  0.70 62.01           N  
ATOM    276  CA  GLN    36      27.698  28.652  73.584  0.70 61.91           C  
ATOM    278  C   GLN    36      27.186  30.009  74.064  0.70 62.05           C  
ATOM    280  O   GLN    36      27.602  30.512  75.114  0.70 60.93           O  
ATOM    282  CB  GLN    36      27.220  27.558  74.527  0.70 61.83           C  
ATOM    284  CG  GLN    36      25.819  27.041  74.247  0.70 63.49           C  
ATOM    286  CD  GLN    36      25.239  26.247  75.415  0.70 63.28           C  
ATOM    288  OE1 GLN    36      25.812  25.265  75.837  0.70 68.16           O  
ATOM    290  NE2 GLN    36      24.103  26.691  75.946  0.70 65.60           N  
ATOM    292  N   TYR    37      26.295  30.613  73.278  1.00 61.85           N  
ATOM    293  CA  TYR    37      25.624  31.862  73.670  1.00 61.15           C  
ATOM    294  C   TYR    37      24.399  31.593  74.494  1.00 59.84           C  
ATOM    295  O   TYR    37      23.619  30.759  74.123  1.00 60.44           O  
ATOM    296  CB  TYR    37      25.248  32.676  72.430  1.00 61.54           C  
ATOM    297  CG  TYR    37      26.466  33.251  71.790  1.00 62.86           C  
ATOM    298  CD1 TYR    37      27.216  34.220  72.442  1.00 60.43           C  
ATOM    299  CD2 TYR    37      26.901  32.809  70.537  1.00 65.34           C  
ATOM    300  CE1 TYR    37      28.366  34.738  71.876  1.00 60.87           C  
ATOM    301  CE2 TYR    37      28.061  33.346  69.965  1.00 62.90           C  
ATOM    302  CZ  TYR    37      28.768  34.301  70.635  1.00 63.13           C  
ATOM    303  OH  TYR    37      29.918  34.831  70.071  1.00 67.04           O  
ATOM    304  N   ILE    38      24.230  32.289  75.610  1.00 59.21           N  
ATOM    305  CA  ILE    38      23.013  32.139  76.463  1.00 58.20           C  
ATOM    306  C   ILE    38      21.998  33.234  76.094  1.00 57.77           C  
ATOM    307  O   ILE    38      20.779  33.008  76.118  1.00 58.35           O  
ATOM    308  CB  ILE    38      23.383  32.227  77.946  1.00 58.32           C  
ATOM    309  CG1 ILE    38      24.010  30.910  78.398  1.00 58.97           C  
ATOM    310  CG2 ILE    38      22.166  32.562  78.833  1.00 58.69           C  
ATOM    311  CD1 ILE    38      24.888  31.011  79.594  1.00 57.72           C  
ATOM    312  N   GLN    39      22.504  34.415  75.721  1.00 55.55           N  
ATOM    313  CA  GLN    39      21.666  35.556  75.381  1.00 54.01           C  
ATOM    314  C   GLN    39      22.493  36.510  74.615  1.00 53.04           C  
ATOM    315  O   GLN    39      23.646  36.769  74.994  1.00 54.10           O  
ATOM    316  CB  GLN    39      21.143  36.318  76.610  1.00 53.35           C  
ATOM    317  CG  GLN    39      20.273  37.518  76.256  1.00 51.78           C  
ATOM    318  CD  GLN    39      18.924  37.104  75.683  1.00 53.58           C  
ATOM    319  OE1 GLN    39      18.125  36.427  76.351  1.00 54.79           O  
ATOM    320  NE2 GLN    39      18.642  37.543  74.460  1.00 51.38           N  
ATOM    321  N   ILE    40      21.872  37.048  73.576  1.00 53.01           N  
ATOM    322  CA  ILE    40      22.460  37.999  72.648  1.00 54.32           C  
ATOM    323  C   ILE    40      21.443  39.089  72.532  1.00 54.45           C  
ATOM    324  O   ILE    40      20.241  38.802  72.387  1.00 53.13           O  
ATOM    325  CB  ILE    40      22.644  37.356  71.237  1.00 54.92           C  
ATOM    326  CG1 ILE    40      23.673  36.232  71.341  1.00 56.91           C  
ATOM    327  CG2 ILE    40      23.088  38.411  70.174  1.00 53.95           C  
ATOM    328  CD1 ILE    40      23.497  35.220  70.200  1.00 62.70           C  
ATOM    329  N   ILE    41      21.916  40.324  72.646  1.00 54.89           N  
ATOM    330  CA  ILE    41      21.146  41.479  72.242  1.00 56.47           C  
ATOM    331  C   ILE    41      21.851  42.189  71.064  1.00 57.24           C  
ATOM    332  O   ILE    41      23.010  42.600  71.162  1.00 56.09           O  
ATOM    333  CB  ILE    41      20.922  42.413  73.437  1.00 57.58           C  
ATOM    334  CG1 ILE    41      20.309  41.618  74.606  1.00 56.84           C  
ATOM    335  CG2 ILE    41      20.059  43.630  73.025  1.00 56.15           C  
ATOM    336  CD1 ILE    41      20.249  42.418  75.898  1.00 57.64           C  
ATOM    337  N   GLU    42      21.150  42.275  69.930  0.50 58.60           N  
ATOM    339  CA  GLU    42      21.737  42.779  68.677  0.50 59.91           C  
ATOM    341  C   GLU    42      21.887  44.290  68.699  0.50 59.38           C  
ATOM    343  O   GLU    42      21.031  45.008  69.225  0.50 60.09           O  
ATOM    345  CB  GLU    42      20.937  42.327  67.437  0.50 59.70           C  
ATOM    347  CG  GLU    42      21.709  42.516  66.084  0.50 61.58           C  
ATOM    349  CD  GLU    42      21.014  41.884  64.855  0.50 62.17           C  
ATOM    351  OE1 GLU    42      21.072  40.629  64.699  0.50 64.45           O  
ATOM    353  OE2 GLU    42      20.432  42.649  64.041  0.50 60.87           O  
ATOM    355  N   SER    43      23.002  44.740  68.141  1.00 59.25           N  
ATOM    356  CA  SER    43      23.355  46.133  67.959  1.00 58.50           C  
ATOM    357  C   SER    43      22.298  46.897  67.185  1.00 58.46           C  
ATOM    358  O   SER    43      21.519  46.314  66.445  1.00 59.01           O  
ATOM    359  CB  SER    43      24.674  46.202  67.167  1.00 57.90           C  
ATOM    360  OG  SER    43      25.051  47.555  66.994  1.00 59.25           O  
ATOM    361  N   VAL    44      22.286  48.217  67.359  1.00 58.06           N  
ATOM    362  CA  VAL    44      21.468  49.108  66.579  1.00 57.11           C  
ATOM    363  C   VAL    44      22.321  49.846  65.533  1.00 56.38           C  
ATOM    364  O   VAL    44      21.790  50.674  64.814  1.00 55.77           O  
ATOM    365  CB  VAL    44      20.806  50.149  67.484  1.00 57.90           C  
ATOM    366  CG1 VAL    44      19.692  49.471  68.322  1.00 59.20           C  
ATOM    367  CG2 VAL    44      21.886  50.864  68.405  1.00 56.67           C  
ATOM    368  N   HIS    45      23.625  49.575  65.457  1.00 54.20           N  
ATOM    369  CA  HIS    45      24.435  50.225  64.413  1.00 54.33           C  
ATOM    370  C   HIS    45      24.166  49.611  63.037  1.00 54.09           C  
ATOM    371  O   HIS    45      23.789  48.445  62.908  1.00 54.12           O  
ATOM    372  CB  HIS    45      25.929  50.109  64.736  1.00 53.49           C  
ATOM    373  CG  HIS    45      26.285  50.704  66.062  1.00 55.56           C  
ATOM    374  ND1 HIS    45      26.153  52.056  66.339  1.00 52.55           N  
ATOM    375  CD2 HIS    45      26.731  50.123  67.205  1.00 55.86           C  
ATOM    376  CE1 HIS    45      26.518  52.280  67.589  1.00 55.53           C  
ATOM    377  NE2 HIS    45      26.884  51.125  68.132  1.00 58.42           N  
ATOM    378  N   ALA    46      24.391  50.392  62.015  1.00 54.07           N  
ATOM    379  CA  ALA    46      24.227  49.917  60.652  1.00 55.35           C  
ATOM    380  C   ALA    46      25.188  48.734  60.377  1.00 55.86           C  
ATOM    381  O   ALA    46      24.779  47.633  59.972  1.00 55.11           O  
ATOM    382  CB  ALA    46      24.506  51.069  59.699  1.00 54.46           C  
ATOM    383  N   LEU    47      26.467  48.962  60.621  1.00 55.28           N  
ATOM    384  CA  LEU    47      27.377  47.918  60.442  1.00 56.25           C  
ATOM    385  C   LEU    47      27.511  47.148  61.767  1.00 57.03           C  
ATOM    386  O   LEU    47      28.034  47.672  62.734  1.00 57.57           O  
ATOM    387  CB  LEU    47      28.693  48.504  59.974  1.00 55.59           C  
ATOM    388  CG  LEU    47      29.831  47.494  59.835  1.00 57.97           C  
ATOM    389  CD1 LEU    47      29.449  46.359  58.803  1.00 54.62           C  
ATOM    390  CD2 LEU    47      31.099  48.273  59.426  1.00 55.91           C  
ATOM    391  N   ARG    48      27.074  45.897  61.817  1.00 58.29           N  
ATOM    392  CA  ARG    48      27.158  45.153  63.069  1.00 59.99           C  
ATOM    393  C   ARG    48      27.398  43.654  62.958  1.00 61.56           C  
ATOM    394  O   ARG    48      27.378  43.087  61.867  1.00 61.63           O  
ATOM    395  CB  ARG    48      25.875  45.345  63.836  1.00 60.62           C  
ATOM    396  CG  ARG    48      24.702  44.576  63.294  1.00 58.36           C  
ATOM    397  CD  ARG    48      23.538  45.335  63.769  1.00 62.40           C  
ATOM    398  NE  ARG    48      22.270  44.850  63.280  1.00 64.49           N  
ATOM    399  CZ  ARG    48      21.233  45.649  63.067  1.00 64.30           C  
ATOM    400  NH1 ARG    48      21.351  46.959  63.281  1.00 63.31           N  
ATOM    401  NH2 ARG    48      20.094  45.141  62.613  1.00 63.51           N  
ATOM    402  N   PHE    49      27.599  43.027  64.115  1.00 63.14           N  
ATOM    403  CA  PHE    49      27.646  41.567  64.221  1.00 65.24           C  
ATOM    404  C   PHE    49      26.239  41.014  64.215  1.00 65.96           C  
ATOM    405  O   PHE    49      25.409  41.464  65.015  1.00 66.23           O  
ATOM    406  CB  PHE    49      28.359  41.136  65.513  1.00 66.03           C  
ATOM    407  CG  PHE    49      29.859  41.075  65.381  1.00 68.58           C  
ATOM    408  CD1 PHE    49      30.680  41.662  66.330  1.00 70.90           C  
ATOM    409  CD2 PHE    49      30.452  40.445  64.290  1.00 70.05           C  
ATOM    410  CE1 PHE    49      32.091  41.589  66.235  1.00 72.91           C  
ATOM    411  CE2 PHE    49      31.845  40.399  64.170  1.00 73.92           C  
ATOM    412  CZ  PHE    49      32.672  40.974  65.173  1.00 70.09           C  
ATOM    413  N   HIS    50      25.962  40.103  63.284  1.00 66.85           N  
ATOM    414  CA  HIS    50      24.758  39.309  63.317  1.00 68.69           C  
ATOM    415  C   HIS    50      25.208  37.896  63.694  1.00 70.93           C  
ATOM    416  O   HIS    50      25.696  37.140  62.841  1.00 72.02           O  
ATOM    417  CB  HIS    50      24.075  39.262  61.959  1.00 68.34           C  
ATOM    418  CG  HIS    50      23.636  40.593  61.434  1.00 66.68           C  
ATOM    419  ND1 HIS    50      24.521  41.613  61.145  1.00 67.30           N  
ATOM    420  CD2 HIS    50      22.408  41.048  61.085  1.00 66.59           C  
ATOM    421  CE1 HIS    50      23.850  42.645  60.650  1.00 69.25           C  
ATOM    422  NE2 HIS    50      22.565  42.327  60.598  1.00 67.09           N  
ATOM    423  N   VAL    51      25.074  37.542  64.969  1.00 72.80           N  
ATOM    424  CA  VAL    51      25.490  36.225  65.440  1.00 74.54           C  
ATOM    425  C   VAL    51      24.566  35.166  64.884  1.00 76.64           C  
ATOM    426  O   VAL    51      23.370  35.197  65.174  1.00 78.19           O  
ATOM    427  CB  VAL    51      25.536  36.112  67.004  1.00 74.55           C  
ATOM    428  CG1 VAL    51      26.104  34.706  67.433  1.00 74.48           C  
ATOM    429  CG2 VAL    51      26.337  37.271  67.630  1.00 70.10           C  
ATOM    430  N   ASP    52      25.115  34.279  64.049  1.00 78.72           N  
ATOM    431  CA  ASP    52      24.439  33.061  63.575  1.00 81.20           C  
ATOM    432  C   ASP    52      24.609  31.950  64.617  1.00 82.80           C  
ATOM    433  O   ASP    52      25.737  31.513  64.892  1.00 83.06           O  
ATOM    434  CB  ASP    52      25.040  32.609  62.241  1.00 81.03           C  
ATOM    435  CG  ASP    52      24.673  31.184  61.876  1.00 83.02           C  
ATOM    436  OD1 ASP    52      23.734  30.577  62.458  1.00 84.81           O  
ATOM    437  OD2 ASP    52      25.347  30.655  60.982  1.00 84.60           O  
ATOM    438  N   GLU    53      23.492  31.484  65.176  1.00 84.68           N  
ATOM    439  CA  GLU    53      23.530  30.555  66.322  1.00 85.92           C  
ATOM    440  C   GLU    53      23.834  29.109  65.886  1.00 85.79           C  
ATOM    441  O   GLU    53      24.435  28.337  66.633  1.00 85.94           O  
ATOM    442  CB  GLU    53      22.220  30.629  67.119  1.00 86.63           C  
ATOM    443  CG  GLU    53      22.102  31.862  68.024  0.60 87.28           C  
ATOM    444  CD  GLU    53      20.726  32.513  67.933  0.60 89.75           C  
ATOM    445  OE1 GLU    53      19.709  31.792  67.794  0.60 90.02           O  
ATOM    446  OE2 GLU    53      20.658  33.760  68.016  0.60 91.66           O  
ATOM    447  N   ASN    54      23.439  28.755  64.670  1.00 85.26           N  
ATOM    448  CA  ASN    54      23.786  27.446  64.124  1.00 84.59           C  
ATOM    449  C   ASN    54      25.318  27.277  63.940  1.00 83.75           C  
ATOM    450  O   ASN    54      25.804  26.162  63.726  1.00 83.96           O  
ATOM    451  CB  ASN    54      23.039  27.208  62.800  0.60 84.69           C  
ATOM    452  CG  ASN    54      22.767  25.720  62.520  0.60 86.08           C  
ATOM    453  OD1 ASN    54      23.307  24.824  63.184  0.60 86.21           O  
ATOM    454  ND2 ASN    54      21.925  25.459  61.519  0.60 86.49           N  
ATOM    455  N   ALA    55      26.067  28.380  64.003  1.00 81.92           N  
ATOM    456  CA  ALA    55      27.524  28.342  63.826  1.00 80.70           C  
ATOM    457  C   ALA    55      28.178  27.586  64.984  1.00 79.23           C  
ATOM    458  O   ALA    55      27.803  27.762  66.133  1.00 79.82           O  
ATOM    459  CB  ALA    55      28.111  29.781  63.712  1.00 80.15           C  
ATOM    460  N   ILE    56      29.151  26.744  64.673  1.00 77.79           N  
ATOM    461  CA  ILE    56      29.908  25.989  65.678  1.00 75.90           C  
ATOM    462  C   ILE    56      31.181  26.767  65.873  1.00 74.50           C  
ATOM    463  O   ILE    56      31.910  26.976  64.913  1.00 74.29           O  
ATOM    464  CB  ILE    56      30.321  24.589  65.149  1.00 76.40           C  
ATOM    465  CG1 ILE    56      29.092  23.763  64.712  1.00 75.34           C  
ATOM    466  CG2 ILE    56      31.187  23.862  66.178  1.00 75.84           C  
ATOM    467  CD1 ILE    56      29.325  22.980  63.417  1.00 77.73           C  
ATOM    468  N   ARG    57      31.487  27.201  67.086  1.00 72.12           N  
ATOM    469  CA  ARG    57      32.693  27.987  67.183  1.00 69.90           C  
ATOM    470  C   ARG    57      33.635  27.565  68.274  1.00 66.50           C  
ATOM    471  O   ARG    57      33.315  27.693  69.445  1.00 66.81           O  
ATOM    472  CB  ARG    57      32.374  29.478  67.250  1.00 70.93           C  
ATOM    473  CG  ARG    57      31.240  29.833  68.125  1.00 76.49           C  
ATOM    474  CD  ARG    57      30.491  31.104  67.618  1.00 84.39           C  
ATOM    475  NE  ARG    57      29.043  30.863  67.752  1.00 89.80           N  
ATOM    476  CZ  ARG    57      28.082  31.417  67.016  1.00 91.00           C  
ATOM    477  NH1 ARG    57      28.343  32.318  66.062  1.00 89.27           N  
ATOM    478  NH2 ARG    57      26.837  31.055  67.262  1.00 94.92           N  
ATOM    479  N   PRO    58      34.812  27.064  67.894  1.00 63.24           N  
ATOM    480  CA  PRO    58      35.795  26.606  68.893  1.00 60.90           C  
ATOM    481  C   PRO    58      36.292  27.734  69.769  1.00 59.63           C  
ATOM    482  O   PRO    58      36.399  28.876  69.317  1.00 58.11           O  
ATOM    483  CB  PRO    58      36.936  26.041  68.045  1.00 60.40           C  
ATOM    484  CG  PRO    58      36.333  25.842  66.652  1.00 61.19           C  
ATOM    485  CD  PRO    58      35.270  26.871  66.507  1.00 62.00           C  
ATOM    486  N   LEU    59      36.609  27.414  71.019  1.00 59.37           N  
ATOM    487  CA  LEU    59      37.029  28.425  72.022  1.00 59.11           C  
ATOM    488  C   LEU    59      38.287  29.220  71.640  1.00 58.79           C  
ATOM    489  O   LEU    59      38.460  30.373  72.082  1.00 57.89           O  
ATOM    490  CB  LEU    59      37.198  27.794  73.415  1.00 58.49           C  
ATOM    491  CG  LEU    59      35.901  27.243  74.025  1.00 59.78           C  
ATOM    492  CD1 LEU    59      36.126  26.407  75.321  1.00 58.03           C  
ATOM    493  CD2 LEU    59      34.899  28.333  74.296  1.00 61.08           C  
ATOM    494  N   THR    60      39.165  28.627  70.834  1.00 58.42           N  
ATOM    495  CA  THR    60      40.355  29.358  70.385  1.00 59.36           C  
ATOM    496  C   THR    60      40.040  30.565  69.445  1.00 60.12           C  
ATOM    497  O   THR    60      40.906  31.385  69.165  1.00 60.01           O  
ATOM    498  CB  THR    60      41.361  28.430  69.673  1.00 59.36           C  
ATOM    499  OG1 THR    60      40.676  27.731  68.642  1.00 59.76           O  
ATOM    500  CG2 THR    60      42.023  27.433  70.630  1.00 56.72           C  
ATOM    501  N   MET    61      38.809  30.682  68.978  1.00 60.58           N  
ATOM    502  CA  MET    61      38.537  31.613  67.887  1.00 62.59           C  
ATOM    503  C   MET    61      37.882  32.922  68.305  1.00 62.66           C  
ATOM    504  O   MET    61      37.505  33.689  67.422  1.00 63.60           O  
ATOM    505  CB  MET    61      37.683  30.942  66.796  1.00 62.56           C  
ATOM    506  CG  MET    61      38.402  29.794  66.080  1.00 67.94           C  
ATOM    507  SD  MET    61      39.847  30.478  64.868  0.90 83.32          SE  
ATOM    508  CE  MET    61      38.659  31.285  63.505  1.00 77.45           C  
ATOM    509  N   SER    62      37.721  33.171  69.610  1.00 61.38           N  
ATOM    510  CA  SER    62      37.147  34.424  70.072  1.00 61.72           C  
ATOM    511  C   SER    62      37.695  34.811  71.425  1.00 62.10           C  
ATOM    512  O   SER    62      38.123  33.954  72.211  1.00 62.73           O  
ATOM    513  CB  SER    62      35.625  34.314  70.193  1.00 61.40           C  
ATOM    514  OG  SER    62      35.327  33.225  71.043  1.00 61.28           O  
ATOM    515  N   SER    63      37.680  36.107  71.713  1.00 62.25           N  
ATOM    516  CA  SER    63      38.120  36.572  73.022  1.00 61.90           C  
ATOM    517  C   SER    63      37.217  35.966  74.109  1.00 61.96           C  
ATOM    518  O   SER    63      37.692  35.658  75.202  1.00 62.43           O  
ATOM    519  CB  SER    63      38.114  38.099  73.078  1.00 61.78           C  
ATOM    520  OG  SER    63      36.778  38.581  72.922  1.00 63.32           O  
ATOM    521  N   ASN    64      35.928  35.765  73.825  1.00 62.05           N  
ATOM    522  CA  ASN    64      35.058  35.037  74.789  1.00 63.21           C  
ATOM    523  C   ASN    64      35.599  33.635  75.064  1.00 62.15           C  
ATOM    524  O   ASN    64      35.608  33.220  76.205  1.00 62.11           O  
ATOM    525  CB  ASN    64      33.632  34.858  74.260  1.00 65.22           C  
ATOM    526  CG  ASN    64      32.778  36.042  74.477  1.00 68.29           C  
ATOM    527  OD1 ASN    64      32.593  36.515  75.600  1.00 79.28           O  
ATOM    528  ND2 ASN    64      32.227  36.524  73.425  1.00 70.86           N  
ATOM    529  N   GLY    65      36.030  32.934  74.000  1.00 60.23           N  
ATOM    530  CA  GLY    65      36.699  31.675  74.116  1.00 60.81           C  
ATOM    531  C   GLY    65      37.903  31.664  75.057  1.00 60.68           C  
ATOM    532  O   GLY    65      37.973  30.840  75.976  1.00 60.10           O  
ATOM    533  N   TRP    66      38.835  32.588  74.856  1.00 60.85           N  
ATOM    534  CA  TRP    66      40.039  32.658  75.709  1.00 60.06           C  
ATOM    535  C   TRP    66      39.646  32.902  77.155  1.00 61.15           C  
ATOM    536  O   TRP    66      40.247  32.351  78.101  1.00 61.99           O  
ATOM    537  CB  TRP    66      40.997  33.752  75.215  1.00 59.30           C  
ATOM    538  CG  TRP    66      41.271  33.740  73.697  1.00 57.28           C  
ATOM    539  CD1 TRP    66      41.269  32.654  72.901  1.00 57.25           C  
ATOM    540  CD2 TRP    66      41.640  34.855  72.848  1.00 57.57           C  
ATOM    541  NE1 TRP    66      41.578  32.999  71.603  1.00 59.16           N  
ATOM    542  CE2 TRP    66      41.805  34.345  71.537  1.00 58.40           C  
ATOM    543  CE3 TRP    66      41.845  36.233  73.066  1.00 57.46           C  
ATOM    544  CZ2 TRP    66      42.141  35.160  70.434  1.00 58.20           C  
ATOM    545  CZ3 TRP    66      42.174  37.045  71.978  1.00 57.05           C  
ATOM    546  CH2 TRP    66      42.321  36.504  70.679  1.00 58.18           C  
ATOM    547  N   MET    67      38.620  33.721  77.354  1.00 61.67           N  
ATOM    548  CA  MET    67      38.196  34.034  78.730  1.00 61.56           C  
ATOM    549  C   MET    67      37.675  32.751  79.398  1.00 61.45           C  
ATOM    550  O   MET    67      38.030  32.471  80.533  1.00 60.34           O  
ATOM    551  CB  MET    67      37.128  35.144  78.733  1.00 62.34           C  
ATOM    552  CG  MET    67      36.847  35.786  80.055  1.00 62.83           C  
ATOM    553  SD  MET    67      38.278  37.022  80.632  0.85 76.26          SE  
ATOM    554  CE  MET    67      38.995  36.079  82.228  1.00 64.02           C  
ATOM    555  N   LEU    68      36.867  31.969  78.669  1.00 61.35           N  
ATOM    556  CA  LEU    68      36.327  30.715  79.196  1.00 61.71           C  
ATOM    557  C   LEU    68      37.367  29.609  79.436  1.00 62.43           C  
ATOM    558  O   LEU    68      37.310  28.891  80.449  1.00 62.05           O  
ATOM    559  CB  LEU    68      35.192  30.211  78.333  1.00 60.42           C  
ATOM    560  CG  LEU    68      34.014  31.190  78.339  1.00 59.67           C  
ATOM    561  CD1 LEU    68      33.203  31.009  77.111  1.00 53.38           C  
ATOM    562  CD2 LEU    68      33.125  31.045  79.587  1.00 56.87           C  
ATOM    563  N   MET    69      38.317  29.487  78.513  1.00 63.63           N  
ATOM    564  CA  MET    69      39.427  28.542  78.640  1.00 64.95           C  
ATOM    565  C   MET    69      40.298  28.887  79.821  1.00 63.85           C  
ATOM    566  O   MET    69      40.834  27.978  80.490  1.00 64.09           O  
ATOM    567  CB  MET    69      40.270  28.585  77.399  1.00 64.13           C  
ATOM    568  CG  MET    69      39.630  27.926  76.207  1.00 66.68           C  
ATOM    569  SD  MET    69      40.939  27.724  74.726  0.80 72.58          SE  
ATOM    570  CE  MET    69      40.747  29.457  73.987  1.00 62.11           C  
ATOM    571  N   SER    70      40.446  30.189  80.094  1.00 62.96           N  
ATOM    572  CA  SER    70      41.251  30.621  81.248  1.00 62.56           C  
ATOM    573  C   SER    70      40.745  30.049  82.590  1.00 61.84           C  
ATOM    574  O   SER    70      41.468  30.041  83.576  1.00 59.67           O  
ATOM    575  CB  SER    70      41.397  32.144  81.294  1.00 62.63           C  
ATOM    576  OG  SER    70      40.243  32.758  81.855  1.00 63.93           O  
ATOM    577  N   THR    71      39.523  29.517  82.591  1.00 62.19           N  
ATOM    578  CA  THR    71      38.983  28.859  83.794  1.00 63.14           C  
ATOM    579  C   THR    71      39.332  27.364  83.967  1.00 63.92           C  
ATOM    580  O   THR    71      39.199  26.839  85.071  1.00 62.99           O  
ATOM    581  CB  THR    71      37.458  29.064  83.955  1.00 62.41           C  
ATOM    582  OG1 THR    71      36.769  28.302  82.965  1.00 62.66           O  
ATOM    583  CG2 THR    71      37.098  30.522  83.810  1.00 61.93           C  
ATOM    584  N   MET    72      39.778  26.694  82.897  1.00 65.08           N  
ATOM    585  CA  MET    72      40.146  25.276  82.957  1.00 67.60           C  
ATOM    586  C   MET    72      41.548  25.007  83.593  1.00 66.23           C  
ATOM    587  O   MET    72      42.373  25.922  83.722  1.00 65.90           O  
ATOM    588  CB  MET    72      40.104  24.668  81.553  1.00 67.24           C  
ATOM    589  CG  MET    72      38.781  24.730  80.785  1.00 68.31           C  
ATOM    590  SD  MET    72      39.303  24.612  78.854  0.83 75.69          SE  
ATOM    591  CE  MET    72      37.549  24.486  78.022  1.00 70.38           C  
ATOM    592  N   ASN    73      41.822  23.756  83.975  1.00 65.62           N  
ATOM    593  CA  ASN    73      43.211  23.352  84.255  1.00 65.21           C  
ATOM    594  C   ASN    73      44.043  23.140  82.967  1.00 64.52           C  
ATOM    595  O   ASN    73      43.489  23.091  81.854  1.00 64.27           O  
ATOM    596  CB  ASN    73      43.283  22.131  85.181  1.00 65.82           C  
ATOM    597  CG  ASN    73      42.587  20.888  84.604  1.00 67.09           C  
ATOM    598  OD1 ASN    73      42.952  20.361  83.538  1.00 64.81           O  
ATOM    599  ND2 ASN    73      41.595  20.394  85.344  1.00 69.28           N  
ATOM    600  N   ASP    74      45.366  23.035  83.110  1.00 63.68           N  
ATOM    601  CA  ASP    74      46.261  23.053  81.935  1.00 63.28           C  
ATOM    602  C   ASP    74      46.104  21.827  81.067  1.00 62.96           C  
ATOM    603  O   ASP    74      46.128  21.926  79.841  1.00 62.13           O  
ATOM    604  CB  ASP    74      47.734  23.235  82.331  1.00 63.20           C  
ATOM    605  CG  ASP    74      48.018  24.603  82.948  1.00 62.80           C  
ATOM    606  OD1 ASP    74      47.344  25.614  82.582  1.00 57.50           O  
ATOM    607  OD2 ASP    74      48.943  24.654  83.805  1.00 63.27           O  
ATOM    608  N   LYS    75      45.951  20.669  81.716  1.00 63.12           N  
ATOM    609  CA  LYS    75      45.617  19.425  81.016  1.00 63.50           C  
ATOM    610  C   LYS    75      44.442  19.643  80.021  1.00 62.99           C  
ATOM    611  O   LYS    75      44.553  19.282  78.838  1.00 62.58           O  
ATOM    612  CB  LYS    75      45.302  18.311  82.018  1.00 64.00           C  
ATOM    613  CG  LYS    75      44.618  17.073  81.419  1.00 66.39           C  
ATOM    614  CD  LYS    75      45.609  16.170  80.682  1.00 68.66           C  
ATOM    615  CE  LYS    75      45.215  14.702  80.810  1.00 69.70           C  
ATOM    616  NZ  LYS    75      44.822  14.371  82.205  1.00 68.07           N  
ATOM    617  N   ALA    76      43.358  20.251  80.518  1.00 62.16           N  
ATOM    618  CA  ALA    76      42.173  20.555  79.738  1.00 61.81           C  
ATOM    619  C   ALA    76      42.404  21.654  78.702  1.00 61.74           C  
ATOM    620  O   ALA    76      41.778  21.620  77.655  1.00 62.13           O  
ATOM    621  CB  ALA    76      40.962  20.889  80.643  1.00 61.24           C  
ATOM    622  N   ILE    77      43.291  22.611  78.960  1.00 61.38           N  
ATOM    623  CA  ILE    77      43.527  23.668  77.966  1.00 61.49           C  
ATOM    624  C   ILE    77      44.270  23.122  76.741  1.00 61.52           C  
ATOM    625  O   ILE    77      43.900  23.431  75.582  1.00 61.15           O  
ATOM    626  CB  ILE    77      44.272  24.870  78.563  1.00 61.79           C  
ATOM    627  CG1 ILE    77      43.304  25.714  79.384  1.00 62.94           C  
ATOM    628  CG2 ILE    77      44.891  25.749  77.483  1.00 61.12           C  
ATOM    629  CD1 ILE    77      44.013  26.581  80.448  1.00 64.59           C  
ATOM    630  N   ASP    78      45.301  22.325  77.025  1.00 60.60           N  
ATOM    631  CA  ASP    78      46.123  21.617  76.035  1.00 60.87           C  
ATOM    632  C   ASP    78      45.265  20.716  75.162  1.00 60.02           C  
ATOM    633  O   ASP    78      45.365  20.782  73.944  1.00 60.82           O  
ATOM    634  CB  ASP    78      47.235  20.818  76.743  1.00 61.04           C  
ATOM    635  CG  ASP    78      48.164  20.069  75.768  1.00 63.40           C  
ATOM    636  OD1 ASP    78      49.198  20.665  75.346  1.00 64.85           O  
ATOM    637  OD2 ASP    78      47.897  18.863  75.476  1.00 63.02           O  
ATOM    638  N   ASN    79      44.386  19.920  75.764  1.00 58.88           N  
ATOM    639  CA  ASN    79      43.433  19.133  74.969  1.00 58.94           C  
ATOM    640  C   ASN    79      42.545  20.000  74.060  1.00 58.14           C  
ATOM    641  O   ASN    79      42.268  19.633  72.918  1.00 57.90           O  
ATOM    642  CB  ASN    79      42.566  18.223  75.848  1.00 59.09           C  
ATOM    643  CG  ASN    79      43.241  16.904  76.173  1.00 62.16           C  
ATOM    644  OD1 ASN    79      43.004  16.335  77.229  1.00 68.10           O  
ATOM    645  ND2 ASN    79      44.111  16.423  75.286  1.00 64.79           N  
ATOM    646  N   THR    80      42.128  21.144  74.586  1.00 56.98           N  
ATOM    647  CA  THR    80      41.215  22.041  73.923  1.00 56.94           C  
ATOM    648  C   THR    80      41.865  22.679  72.704  1.00 57.00           C  
ATOM    649  O   THR    80      41.270  22.741  71.660  1.00 56.26           O  
ATOM    650  CB  THR    80      40.747  23.142  74.904  1.00 56.98           C  
ATOM    651  OG1 THR    80      40.079  22.527  76.017  1.00 57.25           O  
ATOM    652  CG2 THR    80      39.822  24.144  74.210  1.00 54.70           C  
ATOM    653  N   VAL    81      43.106  23.121  72.845  1.00 57.77           N  
ATOM    654  CA  VAL    81      43.812  23.793  71.760  1.00 58.51           C  
ATOM    655  C   VAL    81      44.132  22.771  70.661  1.00 59.17           C  
ATOM    656  O   VAL    81      43.908  23.026  69.446  1.00 59.51           O  
ATOM    657  CB  VAL    81      45.077  24.485  72.298  1.00 58.47           C  
ATOM    658  CG1 VAL    81      45.956  25.012  71.173  1.00 59.77           C  
ATOM    659  CG2 VAL    81      44.667  25.627  73.229  1.00 58.29           C  
ATOM    660  N   ARG    82      44.650  21.625  71.097  1.00 58.86           N  
ATOM    661  CA  ARG    82      44.843  20.479  70.223  1.00 59.54           C  
ATOM    662  C   ARG    82      43.578  20.079  69.460  1.00 58.76           C  
ATOM    663  O   ARG    82      43.616  19.944  68.232  1.00 58.98           O  
ATOM    664  CB  ARG    82      45.336  19.280  71.016  1.00 59.66           C  
ATOM    665  CG  ARG    82      46.764  19.394  71.436  1.00 62.54           C  
ATOM    666  CD  ARG    82      47.353  18.008  71.689  1.00 68.17           C  
ATOM    667  NE  ARG    82      48.644  18.100  72.370  1.00 72.16           N  
ATOM    668  CZ  ARG    82      49.756  18.641  71.857  1.00 74.78           C  
ATOM    669  NH1 ARG    82      50.854  18.663  72.601  1.00 77.11           N  
ATOM    670  NH2 ARG    82      49.788  19.166  70.627  1.00 74.25           N  
ATOM    671  N   ARG    83      42.471  19.868  70.171  1.00 57.49           N  
ATOM    672  CA  ARG    83      41.263  19.414  69.504  1.00 56.42           C  
ATOM    673  C   ARG    83      40.747  20.521  68.593  1.00 57.09           C  
ATOM    674  O   ARG    83      40.403  20.291  67.422  1.00 57.36           O  
ATOM    675  CB  ARG    83      40.222  19.001  70.508  1.00 55.85           C  
ATOM    676  CG  ARG    83      40.414  17.634  71.086  1.00 52.71           C  
ATOM    677  CD  ARG    83      39.437  17.479  72.198  1.00 49.77           C  
ATOM    678  NE  ARG    83      38.088  17.644  71.693  1.00 50.59           N  
ATOM    679  CZ  ARG    83      36.995  17.770  72.437  1.00 51.09           C  
ATOM    680  NH1 ARG    83      35.796  17.947  71.861  1.00 52.66           N  
ATOM    681  NH2 ARG    83      37.089  17.758  73.743  1.00 48.77           N  
ATOM    682  N   ALA    84      40.759  21.740  69.114  1.00 56.57           N  
ATOM    683  CA  ALA    84      40.339  22.870  68.356  1.00 56.57           C  
ATOM    684  C   ALA    84      41.197  23.105  67.084  1.00 57.76           C  
ATOM    685  O   ALA    84      40.669  23.593  66.068  1.00 57.61           O  
ATOM    686  CB  ALA    84      40.286  24.127  69.264  1.00 55.96           C  
ATOM    687  N   ASN    85      42.490  22.782  67.118  1.00 58.24           N  
ATOM    688  CA  ASN    85      43.273  22.956  65.905  1.00 60.37           C  
ATOM    689  C   ASN    85      42.833  22.048  64.775  1.00 60.82           C  
ATOM    690  O   ASN    85      42.806  22.477  63.633  1.00 60.37           O  
ATOM    691  CB  ASN    85      44.775  22.831  66.141  1.00 60.47           C  
ATOM    692  CG  ASN    85      45.333  24.018  66.874  1.00 62.26           C  
ATOM    693  OD1 ASN    85      44.775  25.138  66.813  1.00 63.47           O  
ATOM    694  ND2 ASN    85      46.422  23.794  67.594  1.00 60.57           N  
ATOM    695  N   THR    86      42.459  20.806  65.091  1.00 61.75           N  
ATOM    696  CA  THR    86      42.035  19.873  64.035  1.00 62.30           C  
ATOM    697  C   THR    86      40.785  20.329  63.280  1.00 63.07           C  
ATOM    698  O   THR    86      40.472  19.804  62.212  1.00 63.65           O  
ATOM    699  CB  THR    86      41.828  18.456  64.559  1.00 62.23           C  
ATOM    700  OG1 THR    86      40.606  18.376  65.330  1.00 61.94           O  
ATOM    701  CG2 THR    86      43.042  18.049  65.370  1.00 60.63           C  
ATOM    702  N   ILE    87      40.077  21.290  63.854  1.00 63.43           N  
ATOM    703  CA  ILE    87      38.855  21.778  63.286  1.00 64.20           C  
ATOM    704  C   ILE    87      39.097  23.083  62.491  1.00 65.71           C  
ATOM    705  O   ILE    87      38.612  23.241  61.347  1.00 66.80           O  
ATOM    706  CB  ILE    87      37.839  22.037  64.409  1.00 64.04           C  
ATOM    707  CG1 ILE    87      37.428  20.720  65.060  1.00 64.25           C  
ATOM    708  CG2 ILE    87      36.622  22.825  63.896  1.00 61.32           C  
ATOM    709  CD1 ILE    87      36.579  20.902  66.315  1.00 64.40           C  
ATOM    710  N   THR    88      39.830  24.013  63.109  1.00 65.78           N  
ATOM    711  CA  THR    88      40.080  25.292  62.519  1.00 65.90           C  
ATOM    712  C   THR    88      41.104  25.172  61.410  1.00 67.94           C  
ATOM    713  O   THR    88      41.161  26.035  60.520  1.00 68.74           O  
ATOM    714  CB  THR    88      40.510  26.352  63.552  1.00 65.51           C  
ATOM    715  OG1 THR    88      41.762  26.000  64.153  1.00 62.03           O  
ATOM    716  CG2 THR    88      39.449  26.507  64.601  1.00 62.86           C  
ATOM    717  N   GLN    89      41.891  24.109  61.435  1.00 69.42           N  
ATOM    718  CA  GLN    89      42.896  23.928  60.401  1.00 72.17           C  
ATOM    719  C   GLN    89      42.322  23.397  59.095  1.00 73.16           C  
ATOM    720  O   GLN    89      43.009  23.403  58.065  1.00 73.16           O  
ATOM    721  CB  GLN    89      44.039  23.048  60.878  1.00 72.31           C  
ATOM    722  CG  GLN    89      43.839  21.604  60.590  1.00 74.64           C  
ATOM    723  CD  GLN    89      45.043  20.815  61.004  1.00 79.85           C  
ATOM    724  OE1 GLN    89      46.007  21.388  61.534  1.00 82.02           O  
ATOM    725  NE2 GLN    89      45.011  19.489  60.776  1.00 79.99           N  
ATOM    726  N   LYS    90      41.071  22.948  59.138  1.00 75.07           N  
ATOM    727  CA  LYS    90      40.334  22.613  57.916  1.00 76.91           C  
ATOM    728  C   LYS    90      40.078  23.899  57.120  1.00 77.20           C  
ATOM    729  O   LYS    90      39.646  23.844  55.972  1.00 77.61           O  
ATOM    730  CB  LYS    90      39.009  21.910  58.248  1.00 76.83           C  
ATOM    731  CG  LYS    90      39.163  20.447  58.696  1.00 78.58           C  
ATOM    732  CD  LYS    90      37.796  19.756  58.977  1.00 78.62           C  
ATOM    733  CE  LYS    90      37.079  20.337  60.220  1.00 80.18           C  
ATOM    734  NZ  LYS    90      36.280  19.307  60.970  1.00 78.76           N  
ATOM    735  N   ASP    91      40.348  25.045  57.747  1.00 77.44           N  
ATOM    736  CA  ASP    91      40.246  26.365  57.120  1.00 77.76           C  
ATOM    737  C   ASP    91      41.585  27.103  57.126  1.00 77.52           C  
ATOM    738  O   ASP    91      41.632  28.325  56.987  1.00 77.39           O  
ATOM    739  CB  ASP    91      39.208  27.222  57.867  1.00 78.38           C  
ATOM    740  CG  ASP    91      37.829  26.569  57.912  1.00 80.49           C  
ATOM    741  OD1 ASP    91      37.535  25.680  57.065  1.00 82.90           O  
ATOM    742  OD2 ASP    91      37.031  26.950  58.792  1.00 82.18           O  
ATOM    743  N   GLY    92      42.672  26.362  57.299  1.00 77.83           N  
ATOM    744  CA  GLY    92      44.023  26.940  57.329  1.00 78.14           C  
ATOM    745  C   GLY    92      44.409  27.771  58.555  1.00 78.53           C  
ATOM    746  O   GLY    92      45.425  28.465  58.523  1.00 79.06           O  
ATOM    747  N   ILE    93      43.619  27.708  59.627  1.00 78.12           N  
ATOM    748  CA  ILE    93      43.927  28.425  60.856  1.00 78.01           C  
ATOM    749  C   ILE    93      44.383  27.445  61.948  1.00 78.31           C  
ATOM    750  O   ILE    93      43.752  26.410  62.152  1.00 78.15           O  
ATOM    751  CB  ILE    93      42.682  29.204  61.341  1.00 78.66           C  
ATOM    752  CG1 ILE    93      42.101  30.093  60.211  1.00 78.35           C  
ATOM    753  CG2 ILE    93      42.945  29.921  62.713  1.00 76.93           C  
ATOM    754  CD1 ILE    93      43.079  31.140  59.608  1.00 81.98           C  
ATOM    755  N   ARG    94      45.467  27.756  62.653  1.00 78.39           N  
ATOM    756  CA  ARG    94      45.864  26.906  63.778  1.00 79.60           C  
ATOM    757  C   ARG    94      46.863  27.551  64.739  1.00 79.87           C  
ATOM    758  O   ARG    94      47.994  27.826  64.356  1.00 80.34           O  
ATOM    759  CB  ARG    94      46.404  25.546  63.289  1.00 79.45           C  
ATOM    760  CG  ARG    94      47.917  25.471  63.148  1.00 80.34           C  
ATOM    761  CD  ARG    94      48.417  24.130  62.626  1.00 80.98           C  
ATOM    762  NE  ARG    94      48.116  23.009  63.522  1.00 83.82           N  
ATOM    763  CZ  ARG    94      48.738  22.766  64.678  1.00 84.40           C  
ATOM    764  NH1 ARG    94      49.699  23.581  65.130  1.00 83.20           N  
ATOM    765  NH2 ARG    94      48.384  21.703  65.397  1.00 83.66           N  
ATOM    766  N   PHE    95      46.456  27.734  65.994  1.00 80.07           N  
ATOM    767  CA  PHE    95      47.285  28.366  67.031  1.00 80.20           C  
ATOM    768  C   PHE    95      48.290  27.422  67.702  1.00 80.50           C  
ATOM    769  O   PHE    95      47.963  26.281  68.021  1.00 80.42           O  
ATOM    770  CB  PHE    95      46.379  29.004  68.083  1.00 80.47           C  
ATOM    771  CG  PHE    95      45.260  29.821  67.488  1.00 80.99           C  
ATOM    772  CD1 PHE    95      45.473  31.141  67.111  1.00 81.79           C  
ATOM    773  CD2 PHE    95      44.012  29.254  67.261  1.00 80.65           C  
ATOM    774  CE1 PHE    95      44.448  31.894  66.533  1.00 83.00           C  
ATOM    775  CE2 PHE    95      42.980  29.995  66.685  1.00 82.25           C  
ATOM    776  CZ  PHE    95      43.192  31.318  66.327  1.00 82.26           C  
ATOM    777  N   GLU    96      49.522  27.882  67.905  1.00 80.58           N  
ATOM    778  CA  GLU    96      50.494  27.020  68.550  1.00 81.30           C  
ATOM    779  C   GLU    96      50.231  26.970  70.046  1.00 80.62           C  
ATOM    780  O   GLU    96      50.088  28.001  70.710  1.00 80.58           O  
ATOM    781  CB  GLU    96      51.942  27.422  68.240  1.00 82.00           C  
ATOM    782  CG  GLU    96      52.438  27.100  66.785  1.00 85.70           C  
ATOM    783  CD  GLU    96      52.380  25.603  66.391  1.00 88.37           C  
ATOM    784  OE1 GLU    96      53.160  24.794  66.957  1.00 87.64           O  
ATOM    785  OE2 GLU    96      51.555  25.257  65.500  1.00 89.69           O  
ATOM    786  N   VAL    97      50.152  25.751  70.559  1.00 80.00           N  
ATOM    787  CA  VAL    97      49.779  25.512  71.943  1.00 79.52           C  
ATOM    788  C   VAL    97      50.508  26.506  72.853  1.00 79.00           C  
ATOM    789  O   VAL    97      49.884  27.239  73.624  1.00 79.10           O  
ATOM    790  CB  VAL    97      50.003  24.009  72.319  1.00 79.44           C  
ATOM    791  CG1 VAL    97      51.460  23.558  72.020  1.00 81.14           C  
ATOM    792  CG2 VAL    97      49.593  23.714  73.766  1.00 78.94           C  
ATOM    793  N   ASP    98      51.826  26.549  72.704  1.00 78.35           N  
ATOM    794  CA  ASP    98      52.696  27.550  73.308  1.00 77.56           C  
ATOM    795  C   ASP    98      52.109  28.969  73.485  1.00 76.70           C  
ATOM    796  O   ASP    98      51.942  29.435  74.613  1.00 76.47           O  
ATOM    797  CB  ASP    98      53.966  27.631  72.460  0.60 77.75           C  
ATOM    798  CG  ASP    98      55.156  28.053  73.258  0.60 78.16           C  
ATOM    799  OD1 ASP    98      55.026  28.992  74.072  0.60 78.47           O  
ATOM    800  OD2 ASP    98      56.226  27.440  73.072  0.60 79.39           O  
ATOM    801  N   ASP    99      51.786  29.611  72.368  0.60 76.19           N  
ATOM    803  CA  ASP    99      51.334  30.997  72.340  0.60 75.94           C  
ATOM    805  C   ASP    99      49.880  31.178  72.794  0.60 75.52           C  
ATOM    807  O   ASP    99      49.511  32.196  73.385  0.60 75.43           O  
ATOM    809  CB  ASP    99      51.500  31.548  70.923  0.60 76.07           C  
ATOM    811  CG  ASP    99      52.906  31.364  70.386  0.60 76.52           C  
ATOM    813  OD1 ASP    99      53.090  31.409  69.148  0.60 77.25           O  
ATOM    815  OD2 ASP    99      53.830  31.168  71.201  0.60 77.63           O  
ATOM    817  N   MET   100      49.047  30.200  72.489  1.00 75.00           N  
ATOM    818  CA  MET   100      47.674  30.236  72.938  1.00 74.50           C  
ATOM    819  C   MET   100      47.674  30.109  74.478  1.00 73.72           C  
ATOM    820  O   MET   100      47.061  30.907  75.168  1.00 73.25           O  
ATOM    821  CB  MET   100      46.866  29.138  72.262  1.00 74.34           C  
ATOM    822  CG  MET   100      45.425  29.075  72.717  1.00 75.88           C  
ATOM    823  SD  MET   100      44.372  30.641  72.207  0.85 76.98          SE  
ATOM    824  CE  MET   100      44.151  31.437  73.926  1.00 75.18           C  
ATOM    825  N   MET   101      48.427  29.135  74.992  1.00 72.91           N  
ATOM    826  CA  MET   101      48.593  28.908  76.424  1.00 72.12           C  
ATOM    827  C   MET   101      49.163  30.128  77.135  1.00 71.11           C  
ATOM    828  O   MET   101      48.882  30.349  78.288  1.00 70.87           O  
ATOM    829  CB  MET   101      49.515  27.710  76.631  1.00 72.60           C  
ATOM    830  CG  MET   101      49.809  27.395  78.061  1.00 73.93           C  
ATOM    831  SD  MET   101      48.149  26.866  78.967  0.60 77.64          SE  
ATOM    832  CE  MET   101      48.324  24.912  78.642  1.00 75.16           C  
ATOM    833  N   ALA   102      49.978  30.897  76.422  1.00 70.44           N  
ATOM    834  CA  ALA   102      50.494  32.171  76.882  1.00 69.35           C  
ATOM    835  C   ALA   102      49.409  33.231  76.908  1.00 68.45           C  
ATOM    836  O   ALA   102      49.242  33.887  77.920  1.00 68.65           O  
ATOM    837  CB  ALA   102      51.652  32.613  76.008  1.00 69.18           C  
ATOM    838  N   ARG   103      48.670  33.396  75.810  1.00 68.30           N  
ATOM    839  CA  ARG   103      47.555  34.377  75.743  1.00 67.14           C  
ATOM    840  C   ARG   103      46.513  34.122  76.825  1.00 65.74           C  
ATOM    841  O   ARG   103      46.047  35.029  77.483  1.00 65.11           O  
ATOM    842  CB  ARG   103      46.894  34.389  74.352  1.00 67.51           C  
ATOM    843  CG  ARG   103      45.843  35.526  74.092  1.00 69.99           C  
ATOM    844  CD  ARG   103      46.368  36.997  74.358  1.00 77.43           C  
ATOM    845  NE  ARG   103      46.236  37.886  73.177  1.00 81.71           N  
ATOM    846  CZ  ARG   103      45.219  38.730  72.955  1.00 85.14           C  
ATOM    847  NH1 ARG   103      44.228  38.831  73.838  1.00 87.71           N  
ATOM    848  NH2 ARG   103      45.170  39.478  71.844  1.00 85.06           N  
ATOM    849  N   ILE   104      46.155  32.866  77.003  1.00 65.17           N  
ATOM    850  CA  ILE   104      45.250  32.469  78.072  1.00 64.96           C  
ATOM    851  C   ILE   104      45.767  32.813  79.462  1.00 64.64           C  
ATOM    852  O   ILE   104      45.010  33.294  80.291  1.00 64.83           O  
ATOM    853  CB  ILE   104      44.872  30.974  77.981  1.00 64.89           C  
ATOM    854  CG1 ILE   104      43.935  30.769  76.796  1.00 66.45           C  
ATOM    855  CG2 ILE   104      44.174  30.506  79.264  1.00 64.73           C  
ATOM    856  CD1 ILE   104      43.932  29.348  76.238  1.00 70.32           C  
ATOM    857  N   ARG   105      47.046  32.581  79.719  0.60 64.58           N  
ATOM    859  CA  ARG   105      47.571  32.898  81.044  0.60 64.64           C  
ATOM    861  C   ARG   105      47.507  34.418  81.296  0.60 65.04           C  
ATOM    863  O   ARG   105      47.146  34.856  82.401  0.60 65.11           O  
ATOM    865  CB  ARG   105      48.959  32.268  81.268  0.60 64.15           C  
ATOM    867  CG  ARG   105      49.019  30.745  80.916  0.60 62.26           C  
ATOM    869  CD  ARG   105      49.908  29.930  81.861  0.60 59.20           C  
ATOM    871  NE  ARG   105      50.733  28.913  81.192  0.60 56.19           N  
ATOM    873  CZ  ARG   105      50.648  27.599  81.405  0.60 53.93           C  
ATOM    875  NH1 ARG   105      51.453  26.771  80.766  0.60 52.55           N  
ATOM    877  NH2 ARG   105      49.757  27.107  82.249  0.60 52.59           N  
ATOM    879  N   GLN   106      47.782  35.202  80.250  1.00 65.19           N  
ATOM    880  CA  GLN   106      47.661  36.674  80.283  1.00 66.44           C  
ATOM    881  C   GLN   106      46.219  37.148  80.563  1.00 66.11           C  
ATOM    882  O   GLN   106      45.987  38.039  81.370  1.00 65.91           O  
ATOM    883  CB  GLN   106      48.139  37.258  78.936  1.00 66.21           C  
ATOM    884  CG  GLN   106      48.160  38.781  78.873  1.00 68.89           C  
ATOM    885  CD  GLN   106      48.161  39.330  77.451  1.00 69.30           C  
ATOM    886  OE1 GLN   106      47.230  39.099  76.691  1.00 78.30           O  
ATOM    887  NE2 GLN   106      49.198  40.075  77.094  1.00 73.54           N  
ATOM    888  N   VAL   107      45.251  36.538  79.892  1.00 66.18           N  
ATOM    889  CA  VAL   107      43.862  36.931  80.045  1.00 66.70           C  
ATOM    890  C   VAL   107      43.368  36.703  81.494  1.00 67.44           C  
ATOM    891  O   VAL   107      42.708  37.561  82.099  1.00 66.39           O  
ATOM    892  CB  VAL   107      43.007  36.198  79.002  1.00 66.50           C  
ATOM    893  CG1 VAL   107      41.573  35.994  79.503  1.00 66.31           C  
ATOM    894  CG2 VAL   107      43.053  36.959  77.686  1.00 64.13           C  
ATOM    895  N   ARG   108      43.711  35.531  82.025  1.00 68.65           N  
ATOM    896  CA  ARG   108      43.437  35.162  83.410  1.00 69.82           C  
ATOM    897  C   ARG   108      44.035  36.222  84.356  1.00 71.05           C  
ATOM    898  O   ARG   108      43.384  36.638  85.340  1.00 70.77           O  
ATOM    899  CB  ARG   108      43.991  33.751  83.721  1.00 69.62           C  
ATOM    900  CG  ARG   108      43.597  33.210  85.119  1.00 69.62           C  
ATOM    901  CD  ARG   108      44.401  31.981  85.533  1.00 68.90           C  
ATOM    902  NE  ARG   108      44.109  30.834  84.678  1.00 67.11           N  
ATOM    903  CZ  ARG   108      45.010  29.969  84.222  1.00 65.78           C  
ATOM    904  NH1 ARG   108      44.619  28.965  83.441  1.00 62.37           N  
ATOM    905  NH2 ARG   108      46.297  30.107  84.545  1.00 67.13           N  
ATOM    906  N   GLU   109      45.259  36.661  84.034  1.00 72.13           N  
ATOM    907  CA  GLU   109      45.939  37.716  84.794  1.00 73.60           C  
ATOM    908  C   GLU   109      45.204  39.061  84.741  1.00 73.35           C  
ATOM    909  O   GLU   109      44.693  39.530  85.763  1.00 73.58           O  
ATOM    910  CB  GLU   109      47.385  37.880  84.320  1.00 73.60           C  
ATOM    911  CG  GLU   109      48.345  38.293  85.440  1.00 74.84           C  
ATOM    912  CD  GLU   109      49.683  38.819  84.920  1.00 75.40           C  
ATOM    913  OE1 GLU   109      49.694  39.511  83.867  1.00 78.84           O  
ATOM    914  OE2 GLU   109      50.721  38.555  85.572  1.00 75.88           O  
ATOM    915  N   GLN   110      45.117  39.652  83.547  1.00 73.36           N  
ATOM    916  CA  GLN   110      44.529  40.995  83.375  1.00 72.79           C  
ATOM    917  C   GLN   110      43.013  41.152  83.647  1.00 71.55           C  
ATOM    918  O   GLN   110      42.564  42.291  83.828  1.00 71.83           O  
ATOM    919  CB  GLN   110      44.899  41.578  82.006  1.00 72.97           C  
ATOM    920  CG  GLN   110      44.154  40.900  80.880  1.00 74.32           C  
ATOM    921  CD  GLN   110      44.831  41.080  79.538  1.00 75.81           C  
ATOM    922  OE1 GLN   110      46.072  41.145  79.455  1.00 74.48           O  
ATOM    923  NE2 GLN   110      44.016  41.145  78.467  1.00 73.00           N  
ATOM    924  N   GLY   111      42.251  40.048  83.693  1.00 70.23           N  
ATOM    925  CA  GLY   111      40.821  40.054  84.127  1.00 68.74           C  
ATOM    926  C   GLY   111      39.765  40.105  83.019  1.00 68.41           C  
ATOM    927  O   GLY   111      38.535  40.009  83.267  1.00 67.72           O  
ATOM    928  N   TYR   112      40.237  40.245  81.785  1.00 67.60           N  
ATOM    929  CA  TYR   112      39.367  40.447  80.621  1.00 67.38           C  
ATOM    930  C   TYR   112      40.115  40.034  79.362  1.00 66.21           C  
ATOM    931  O   TYR   112      41.348  39.829  79.414  1.00 66.31           O  
ATOM    932  CB  TYR   112      39.012  41.939  80.477  1.00 68.34           C  
ATOM    933  CG  TYR   112      40.254  42.789  80.427  1.00 70.12           C  
ATOM    934  CD1 TYR   112      40.904  43.058  79.212  1.00 72.48           C  
ATOM    935  CD2 TYR   112      40.811  43.296  81.603  1.00 70.44           C  
ATOM    936  CE1 TYR   112      42.092  43.844  79.176  1.00 72.21           C  
ATOM    937  CE2 TYR   112      41.962  44.071  81.575  1.00 72.48           C  
ATOM    938  CZ  TYR   112      42.597  44.334  80.362  1.00 72.07           C  
ATOM    939  OH  TYR   112      43.740  45.103  80.381  1.00 73.81           O  
ATOM    940  N   ALA   113      39.396  39.973  78.232  1.00 63.62           N  
ATOM    941  CA  ALA   113      40.045  39.704  76.957  1.00 62.19           C  
ATOM    942  C   ALA   113      39.529  40.638  75.861  1.00 61.50           C  
ATOM    943  O   ALA   113      38.406  41.113  75.914  1.00 62.63           O  
ATOM    944  CB  ALA   113      39.874  38.221  76.557  1.00 61.70           C  
ATOM    945  N   SER   114      40.363  40.940  74.895  1.00 59.84           N  
ATOM    946  CA  SER   114      39.903  41.583  73.708  1.00 59.77           C  
ATOM    947  C   SER   114      40.680  41.049  72.491  1.00 59.17           C  
ATOM    948  O   SER   114      41.711  40.411  72.631  1.00 58.24           O  
ATOM    949  CB  SER   114      40.004  43.083  73.840  1.00 59.57           C  
ATOM    950  OG  SER   114      41.356  43.445  74.060  1.00 62.96           O  
ATOM    951  N   ALA   115      40.152  41.309  71.306  1.00 59.12           N  
ATOM    952  CA  ALA   115      40.660  40.719  70.093  1.00 59.65           C  
ATOM    953  C   ALA   115      40.253  41.616  68.966  1.00 60.51           C  
ATOM    954  O   ALA   115      39.161  42.214  68.986  1.00 60.26           O  
ATOM    955  CB  ALA   115      40.033  39.339  69.879  1.00 59.03           C  
ATOM    956  N   GLU   116      41.131  41.683  67.979  1.00 61.40           N  
ATOM    957  CA  GLU   116      40.941  42.411  66.748  1.00 62.48           C  
ATOM    958  C   GLU   116      40.932  41.386  65.627  1.00 61.94           C  
ATOM    959  O   GLU   116      41.831  40.534  65.562  1.00 61.71           O  
ATOM    960  CB  GLU   116      42.178  43.242  66.470  1.00 62.91           C  
ATOM    961  CG  GLU   116      42.362  44.501  67.253  1.00 64.87           C  
ATOM    962  CD  GLU   116      43.608  45.273  66.759  1.00 66.94           C  
ATOM    963  OE1 GLU   116      44.407  44.722  65.917  1.00 68.23           O  
ATOM    964  OE2 GLU   116      43.771  46.437  67.224  1.00 72.76           O  
ATOM    965  N   HIS   117      39.970  41.495  64.716  1.00 60.74           N  
ATOM    966  CA  HIS   117      39.988  40.687  63.512  1.00 60.71           C  
ATOM    967  C   HIS   117      39.903  39.218  63.820  1.00 60.41           C  
ATOM    968  O   HIS   117      40.269  38.431  62.958  1.00 60.05           O  
ATOM    969  CB  HIS   117      41.242  40.943  62.639  1.00 60.33           C  
ATOM    970  CG  HIS   117      41.425  42.375  62.226  1.00 62.23           C  
ATOM    971  ND1 HIS   117      40.464  43.092  61.535  1.00 61.62           N  
ATOM    972  CD2 HIS   117      42.476  43.214  62.375  1.00 62.71           C  
ATOM    973  CE1 HIS   117      40.911  44.310  61.292  1.00 62.55           C  
ATOM    974  NE2 HIS   117      42.131  44.410  61.787  1.00 63.71           N  
ATOM    975  N   ILE   118      39.426  38.847  65.023  1.00 60.21           N  
ATOM    976  CA  ILE   118      39.269  37.410  65.396  1.00 59.96           C  
ATOM    977  C   ILE   118      37.957  37.150  66.138  1.00 59.73           C  
ATOM    978  O   ILE   118      37.735  37.670  67.213  1.00 59.45           O  
ATOM    979  CB  ILE   118      40.476  36.841  66.252  1.00 60.60           C  
ATOM    980  CG1 ILE   118      41.818  37.029  65.538  1.00 59.99           C  
ATOM    981  CG2 ILE   118      40.294  35.302  66.526  1.00 60.37           C  
ATOM    982  CD1 ILE   118      43.051  36.832  66.477  1.00 59.96           C  
ATOM    983  N   PRO   119      37.076  36.328  65.576  1.00 59.63           N  
ATOM    984  CA  PRO   119      37.199  35.472  64.393  1.00 60.42           C  
ATOM    985  C   PRO   119      37.065  36.229  63.055  1.00 61.73           C  
ATOM    986  O   PRO   119      37.340  35.635  62.013  1.00 62.71           O  
ATOM    987  CB  PRO   119      36.018  34.497  64.547  1.00 59.89           C  
ATOM    988  CG  PRO   119      34.937  35.379  65.254  1.00 58.78           C  
ATOM    989  CD  PRO   119      35.720  36.306  66.159  1.00 59.32           C  
ATOM    990  N   PHE   120      36.657  37.504  63.051  1.00 61.12           N  
ATOM    991  CA  PHE   120      36.338  38.119  61.762  1.00 61.12           C  
ATOM    992  C   PHE   120      37.054  39.400  61.460  1.00 59.48           C  
ATOM    993  O   PHE   120      37.082  40.301  62.261  1.00 58.42           O  
ATOM    994  CB  PHE   120      34.828  38.341  61.622  1.00 62.74           C  
ATOM    995  CG  PHE   120      34.035  37.086  61.735  1.00 64.36           C  
ATOM    996  CD1 PHE   120      34.295  36.006  60.866  1.00 70.01           C  
ATOM    997  CD2 PHE   120      33.064  36.952  62.726  1.00 65.69           C  
ATOM    998  CE1 PHE   120      33.561  34.780  60.953  1.00 69.09           C  
ATOM    999  CE2 PHE   120      32.304  35.779  62.819  1.00 66.11           C  
ATOM   1000  CZ  PHE   120      32.553  34.681  61.937  1.00 66.98           C  
ATOM   1001  N   VAL   121      37.599  39.469  60.256  1.00 58.64           N  
ATOM   1002  CA  VAL   121      38.232  40.683  59.767  1.00 58.37           C  
ATOM   1003  C   VAL   121      37.274  41.873  59.847  1.00 56.99           C  
ATOM   1004  O   VAL   121      36.136  41.809  59.367  1.00 55.51           O  
ATOM   1005  CB  VAL   121      38.725  40.438  58.336  1.00 59.00           C  
ATOM   1006  CG1 VAL   121      39.244  41.673  57.723  1.00 59.59           C  
ATOM   1007  CG2 VAL   121      39.812  39.386  58.387  1.00 60.30           C  
ATOM   1008  N   GLY   122      37.746  42.924  60.514  1.00 56.40           N  
ATOM   1009  CA  GLY   122      37.050  44.197  60.644  1.00 55.08           C  
ATOM   1010  C   GLY   122      36.289  44.261  61.944  1.00 55.39           C  
ATOM   1011  O   GLY   122      35.644  45.275  62.246  1.00 54.99           O  
ATOM   1012  N   GLY   123      36.351  43.178  62.720  1.00 55.30           N  
ATOM   1013  CA  GLY   123      35.632  43.117  63.990  1.00 56.21           C  
ATOM   1014  C   GLY   123      36.539  43.368  65.186  1.00 57.60           C  
ATOM   1015  O   GLY   123      37.764  43.195  65.105  1.00 58.87           O  
ATOM   1016  N   GLY   124      35.937  43.769  66.299  1.00 57.60           N  
ATOM   1017  CA  GLY   124      36.615  43.964  67.568  1.00 56.76           C  
ATOM   1018  C   GLY   124      35.654  43.511  68.645  1.00 57.59           C  
ATOM   1019  O   GLY   124      34.438  43.674  68.502  1.00 58.68           O  
ATOM   1020  N   THR   125      36.195  42.917  69.702  1.00 57.57           N  
ATOM   1021  CA  THR   125      35.421  42.333  70.759  1.00 58.77           C  
ATOM   1022  C   THR   125      36.159  42.557  72.087  1.00 59.95           C  
ATOM   1023  O   THR   125      37.404  42.665  72.108  1.00 61.11           O  
ATOM   1024  CB  THR   125      35.226  40.815  70.555  1.00 58.50           C  
ATOM   1025  OG1 THR   125      36.504  40.198  70.631  1.00 60.10           O  
ATOM   1026  CG2 THR   125      34.581  40.477  69.179  1.00 57.20           C  
ATOM   1027  N   ILE   126      35.392  42.648  73.174  1.00 59.74           N  
ATOM   1028  CA  ILE   126      35.925  42.817  74.500  1.00 60.47           C  
ATOM   1029  C   ILE   126      35.014  42.026  75.389  1.00 60.96           C  
ATOM   1030  O   ILE   126      33.801  42.116  75.250  1.00 60.86           O  
ATOM   1031  CB  ILE   126      35.861  44.292  74.994  1.00 60.70           C  
ATOM   1032  CG1 ILE   126      36.457  45.265  73.965  1.00 60.18           C  
ATOM   1033  CG2 ILE   126      36.660  44.428  76.323  1.00 61.21           C  
ATOM   1034  CD1 ILE   126      36.173  46.739  74.252  1.00 60.30           C  
ATOM   1035  N   CYS   127      35.571  41.266  76.320  1.00 61.17           N  
ATOM   1036  CA  CYS   127      34.720  40.550  77.246  1.00 61.73           C  
ATOM   1037  C   CYS   127      35.336  40.353  78.631  1.00 60.76           C  
ATOM   1038  O   CYS   127      36.552  40.554  78.825  1.00 61.34           O  
ATOM   1039  CB  CYS   127      34.283  39.220  76.645  1.00 62.64           C  
ATOM   1040  SG  CYS   127      35.571  38.057  76.611  1.00 69.38           S  
ATOM   1041  N   VAL   128      34.479  39.997  79.585  1.00 58.72           N  
ATOM   1042  CA  VAL   128      34.880  39.777  80.954  1.00 57.06           C  
ATOM   1043  C   VAL   128      34.217  38.503  81.459  1.00 57.11           C  
ATOM   1044  O   VAL   128      33.236  38.000  80.900  1.00 56.65           O  
ATOM   1045  CB  VAL   128      34.464  40.968  81.850  1.00 57.55           C  
ATOM   1046  CG1 VAL   128      35.306  42.205  81.547  1.00 55.59           C  
ATOM   1047  CG2 VAL   128      32.963  41.291  81.663  1.00 56.91           C  
ATOM   1048  N   LEU   129      34.762  37.965  82.520  1.00 57.32           N  
ATOM   1049  CA  LEU   129      34.166  36.828  83.172  1.00 58.26           C  
ATOM   1050  C   LEU   129      33.140  37.298  84.224  1.00 58.72           C  
ATOM   1051  O   LEU   129      33.452  38.103  85.104  1.00 58.69           O  
ATOM   1052  CB  LEU   129      35.297  36.031  83.830  1.00 58.55           C  
ATOM   1053  CG  LEU   129      35.015  34.628  84.359  1.00 60.42           C  
ATOM   1054  CD1 LEU   129      34.662  33.655  83.226  1.00 57.69           C  
ATOM   1055  CD2 LEU   129      36.257  34.149  85.121  1.00 58.78           C  
ATOM   1056  N   LEU   130      31.924  36.779  84.156  1.00 59.63           N  
ATOM   1057  CA  LEU   130      30.970  37.026  85.231  1.00 61.00           C  
ATOM   1058  C   LEU   130      31.373  36.302  86.514  1.00 62.52           C  
ATOM   1059  O   LEU   130      32.068  35.286  86.451  1.00 63.24           O  
ATOM   1060  CB  LEU   130      29.555  36.661  84.806  1.00 60.61           C  
ATOM   1061  CG  LEU   130      29.064  37.484  83.618  1.00 58.70           C  
ATOM   1062  CD1 LEU   130      27.610  37.233  83.478  1.00 57.62           C  
ATOM   1063  CD2 LEU   130      29.312  38.951  83.901  1.00 58.50           C  
ATOM   1064  N   PRO   131      30.957  36.833  87.684  1.00 63.60           N  
ATOM   1065  CA  PRO   131      31.330  36.289  88.998  1.00 64.67           C  
ATOM   1066  C   PRO   131      30.677  34.948  89.331  1.00 65.20           C  
ATOM   1067  O   PRO   131      31.135  34.235  90.229  1.00 65.42           O  
ATOM   1068  CB  PRO   131      30.763  37.326  89.982  1.00 64.22           C  
ATOM   1069  CG  PRO   131      30.370  38.477  89.184  1.00 63.35           C  
ATOM   1070  CD  PRO   131      30.083  38.008  87.828  1.00 63.62           C  
ATOM   1071  N   MET   132      29.571  34.647  88.672  1.00 64.99           N  
ATOM   1072  CA  MET   132      28.877  33.427  88.993  1.00 65.15           C  
ATOM   1073  C   MET   132      28.979  32.403  87.850  1.00 64.14           C  
ATOM   1074  O   MET   132      29.414  32.717  86.758  1.00 64.03           O  
ATOM   1075  CB  MET   132      27.415  33.726  89.407  1.00 65.70           C  
ATOM   1076  CG  MET   132      26.390  33.794  88.263  1.00 67.04           C  
ATOM   1077  SD  MET   132      26.750  35.218  87.004  0.45 71.81          SE  
ATOM   1078  CE  MET   132      26.107  36.639  88.129  1.00 67.04           C  
ATOM   1079  N   THR   133      28.592  31.168  88.142  1.00 63.08           N  
ATOM   1080  CA  THR   133      28.539  30.109  87.173  1.00 61.87           C  
ATOM   1081  C   THR   133      27.079  29.821  86.836  1.00 62.29           C  
ATOM   1082  O   THR   133      26.172  30.146  87.590  1.00 62.69           O  
ATOM   1083  CB  THR   133      29.236  28.832  87.733  1.00 62.07           C  
ATOM   1084  OG1 THR   133      28.599  28.425  88.955  1.00 59.30           O  
ATOM   1085  CG2 THR   133      30.761  29.080  87.987  1.00 60.89           C  
ATOM   1086  N   ILE   134      26.850  29.216  85.690  1.00 63.11           N  
ATOM   1087  CA  ILE   134      25.523  28.799  85.289  1.00 64.44           C  
ATOM   1088  C   ILE   134      25.672  27.330  84.911  1.00 65.69           C  
ATOM   1089  O   ILE   134      26.460  26.969  84.044  1.00 66.09           O  
ATOM   1090  CB  ILE   134      24.963  29.704  84.146  1.00 64.14           C  
ATOM   1091  CG1 ILE   134      24.566  31.066  84.723  1.00 63.96           C  
ATOM   1092  CG2 ILE   134      23.773  29.071  83.433  1.00 64.15           C  
ATOM   1093  CD1 ILE   134      24.175  32.136  83.679  1.00 64.32           C  
ATOM   1094  N   GLN   135      24.961  26.482  85.641  1.00 67.44           N  
ATOM   1095  CA  GLN   135      25.018  25.030  85.464  1.00 68.27           C  
ATOM   1096  C   GLN   135      26.423  24.443  85.593  1.00 67.51           C  
ATOM   1097  O   GLN   135      26.840  23.603  84.787  1.00 67.63           O  
ATOM   1098  CB  GLN   135      24.338  24.630  84.142  1.00 69.11           C  
ATOM   1099  CG  GLN   135      22.813  24.426  84.322  1.00 72.21           C  
ATOM   1100  CD  GLN   135      22.075  24.392  83.000  1.00 75.06           C  
ATOM   1101  OE1 GLN   135      22.529  24.981  82.028  1.00 73.98           O  
ATOM   1102  NE2 GLN   135      20.923  23.708  82.961  1.00 76.23           N  
ATOM   1103  N   GLY   136      27.140  24.878  86.627  1.00 66.64           N  
ATOM   1104  CA  GLY   136      28.537  24.478  86.814  1.00 65.45           C  
ATOM   1105  C   GLY   136      29.529  25.084  85.834  1.00 64.78           C  
ATOM   1106  O   GLY   136      30.703  25.058  86.102  1.00 63.55           O  
ATOM   1107  N   GLN   137      29.053  25.633  84.708  1.00 65.31           N  
ATOM   1108  CA  GLN   137      29.912  26.263  83.691  1.00 65.72           C  
ATOM   1109  C   GLN   137      30.233  27.713  84.016  1.00 65.55           C  
ATOM   1110  O   GLN   137      29.358  28.463  84.439  1.00 65.69           O  
ATOM   1111  CB  GLN   137      29.245  26.244  82.302  1.00 66.04           C  
ATOM   1112  CG  GLN   137      29.320  24.909  81.507  1.00 68.78           C  
ATOM   1113  CD  GLN   137      30.440  23.996  82.042  1.00 73.24           C  
ATOM   1114  OE1 GLN   137      31.649  24.242  81.825  1.00 72.76           O  
ATOM   1115  NE2 GLN   137      30.031  22.931  82.759  1.00 73.95           N  
ATOM   1116  N   PRO   138      31.472  28.144  83.744  1.00 65.44           N  
ATOM   1117  CA  PRO   138      31.749  29.578  83.801  1.00 64.98           C  
ATOM   1118  C   PRO   138      31.014  30.351  82.669  1.00 64.36           C  
ATOM   1119  O   PRO   138      30.615  29.763  81.628  1.00 63.62           O  
ATOM   1120  CB  PRO   138      33.259  29.641  83.600  1.00 64.70           C  
ATOM   1121  CG  PRO   138      33.523  28.488  82.688  1.00 65.49           C  
ATOM   1122  CD  PRO   138      32.663  27.395  83.312  1.00 65.94           C  
ATOM   1123  N   VAL   139      30.836  31.652  82.906  1.00 63.46           N  
ATOM   1124  CA  VAL   139      30.024  32.527  82.076  1.00 63.27           C  
ATOM   1125  C   VAL   139      30.742  33.834  81.764  1.00 63.64           C  
ATOM   1126  O   VAL   139      31.472  34.407  82.580  1.00 63.82           O  
ATOM   1127  CB  VAL   139      28.685  32.877  82.751  1.00 63.26           C  
ATOM   1128  CG1 VAL   139      27.728  33.535  81.751  1.00 63.44           C  
ATOM   1129  CG2 VAL   139      28.037  31.626  83.319  1.00 63.48           C  
ATOM   1130  N   THR   140      30.473  34.346  80.581  1.00 63.49           N  
ATOM   1131  CA  THR   140      31.209  35.477  80.094  1.00 62.95           C  
ATOM   1132  C   THR   140      30.239  36.548  79.635  1.00 61.34           C  
ATOM   1133  O   THR   140      29.112  36.253  79.198  1.00 61.41           O  
ATOM   1134  CB  THR   140      32.197  34.962  78.979  1.00 64.09           C  
ATOM   1135  OG1 THR   140      33.315  35.835  78.864  1.00 68.35           O  
ATOM   1136  CG2 THR   140      31.527  34.750  77.625  1.00 61.92           C  
ATOM   1137  N   MET   141      30.651  37.795  79.749  1.00 59.52           N  
ATOM   1138  CA  MET   141      29.865  38.896  79.191  1.00 58.85           C  
ATOM   1139  C   MET   141      30.732  39.738  78.273  1.00 57.63           C  
ATOM   1140  O   MET   141      31.805  40.197  78.662  1.00 56.38           O  
ATOM   1141  CB  MET   141      29.254  39.781  80.295  1.00 58.22           C  
ATOM   1142  CG  MET   141      28.359  40.907  79.768  1.00 57.91           C  
ATOM   1143  SD  MET   141      27.439  41.893  81.189  0.70 63.01          SE  
ATOM   1144  CE  MET   141      29.033  42.290  82.338  1.00 57.79           C  
ATOM   1145  N   GLY   142      30.275  39.939  77.045  1.00 57.51           N  
ATOM   1146  CA  GLY   142      31.113  40.646  76.106  1.00 57.02           C  
ATOM   1147  C   GLY   142      30.376  41.500  75.131  1.00 57.66           C  
ATOM   1148  O   GLY   142      29.155  41.396  75.004  1.00 56.64           O  
ATOM   1149  N   LEU   143      31.124  42.363  74.442  1.00 58.30           N  
ATOM   1150  CA  LEU   143      30.546  43.151  73.380  1.00 58.79           C  
ATOM   1151  C   LEU   143      31.353  43.070  72.088  1.00 58.83           C  
ATOM   1152  O   LEU   143      32.559  42.905  72.119  1.00 58.80           O  
ATOM   1153  CB  LEU   143      30.325  44.594  73.858  1.00 58.35           C  
ATOM   1154  CG  LEU   143      31.521  45.419  74.287  1.00 60.18           C  
ATOM   1155  CD1 LEU   143      32.247  46.006  73.071  1.00 60.49           C  
ATOM   1156  CD2 LEU   143      31.061  46.519  75.206  1.00 59.31           C  
ATOM   1157  N   GLY   144      30.678  43.246  70.953  1.00 58.47           N  
ATOM   1158  CA  GLY   144      31.316  43.101  69.659  1.00 58.24           C  
ATOM   1159  C   GLY   144      30.811  44.138  68.683  1.00 57.94           C  
ATOM   1160  O   GLY   144      29.643  44.516  68.749  1.00 59.01           O  
ATOM   1161  N   GLY   145      31.667  44.613  67.784  1.00 56.39           N  
ATOM   1162  CA  GLY   145      31.205  45.540  66.745  1.00 55.65           C  
ATOM   1163  C   GLY   145      32.309  45.840  65.731  1.00 56.12           C  
ATOM   1164  O   GLY   145      33.329  45.104  65.659  1.00 56.23           O  
ATOM   1165  N   ALA   146      32.124  46.900  64.951  1.00 55.07           N  
ATOM   1166  CA  ALA   146      33.100  47.244  63.899  1.00 55.82           C  
ATOM   1167  C   ALA   146      34.349  47.728  64.624  1.00 56.96           C  
ATOM   1168  O   ALA   146      34.230  48.504  65.612  1.00 57.85           O  
ATOM   1169  CB  ALA   146      32.536  48.330  62.929  1.00 52.69           C  
ATOM   1170  N   LEU   147      35.522  47.281  64.155  1.00 57.64           N  
ATOM   1171  CA  LEU   147      36.793  47.504  64.859  1.00 58.41           C  
ATOM   1172  C   LEU   147      37.061  48.955  65.249  1.00 60.34           C  
ATOM   1173  O   LEU   147      37.500  49.227  66.372  1.00 61.03           O  
ATOM   1174  CB  LEU   147      37.975  46.973  64.060  1.00 58.18           C  
ATOM   1175  CG  LEU   147      39.327  46.949  64.806  1.00 58.18           C  
ATOM   1176  CD1 LEU   147      39.244  46.312  66.199  1.00 57.00           C  
ATOM   1177  CD2 LEU   147      40.342  46.197  64.003  1.00 56.44           C  
ATOM   1178  N   ASP   148      36.797  49.886  64.340  1.00 60.98           N  
ATOM   1179  CA  ASP   148      37.114  51.252  64.594  1.00 62.40           C  
ATOM   1180  C   ASP   148      36.348  51.837  65.779  1.00 62.77           C  
ATOM   1181  O   ASP   148      36.896  52.619  66.589  1.00 62.98           O  
ATOM   1182  CB  ASP   148      36.866  52.052  63.329  1.00 63.29           C  
ATOM   1183  CG  ASP   148      37.999  51.865  62.274  1.00 68.49           C  
ATOM   1184  OD1 ASP   148      39.067  51.262  62.588  1.00 73.90           O  
ATOM   1185  OD2 ASP   148      37.832  52.324  61.114  1.00 73.21           O  
ATOM   1186  N   ARG   149      35.081  51.456  65.871  1.00 62.83           N  
ATOM   1187  CA  ARG   149      34.149  51.928  66.902  1.00 62.86           C  
ATOM   1188  C   ARG   149      34.607  51.373  68.242  1.00 62.96           C  
ATOM   1189  O   ARG   149      34.489  52.006  69.274  1.00 63.58           O  
ATOM   1190  CB  ARG   149      32.755  51.373  66.561  1.00 63.17           C  
ATOM   1191  CG  ARG   149      31.541  52.118  67.062  1.00 62.50           C  
ATOM   1192  CD  ARG   149      30.276  51.705  66.243  1.00 62.20           C  
ATOM   1193  NE  ARG   149      29.948  50.271  66.331  1.00 61.59           N  
ATOM   1194  CZ  ARG   149      29.562  49.509  65.295  1.00 61.95           C  
ATOM   1195  NH1 ARG   149      29.438  50.037  64.069  1.00 61.84           N  
ATOM   1196  NH2 ARG   149      29.264  48.218  65.478  1.00 58.63           N  
ATOM   1197  N   ILE   150      35.138  50.168  68.190  1.00 62.84           N  
ATOM   1198  CA  ILE   150      35.667  49.472  69.337  1.00 62.99           C  
ATOM   1199  C   ILE   150      36.976  50.090  69.814  1.00 63.06           C  
ATOM   1200  O   ILE   150      37.093  50.383  70.996  1.00 63.45           O  
ATOM   1201  CB  ILE   150      35.841  47.972  68.975  1.00 62.89           C  
ATOM   1202  CG1 ILE   150      34.475  47.346  68.679  1.00 61.48           C  
ATOM   1203  CG2 ILE   150      36.605  47.214  70.033  1.00 63.63           C  
ATOM   1204  CD1 ILE   150      33.474  47.515  69.720  1.00 59.06           C  
ATOM   1205  N   LYS   151      37.934  50.291  68.898  1.00 63.12           N  
ATOM   1206  CA  LYS   151      39.214  50.921  69.175  1.00 63.61           C  
ATOM   1207  C   LYS   151      39.027  52.307  69.740  1.00 63.88           C  
ATOM   1208  O   LYS   151      39.786  52.735  70.630  1.00 63.74           O  
ATOM   1209  CB  LYS   151      40.053  51.086  67.903  1.00 64.07           C  
ATOM   1210  CG  LYS   151      40.913  49.913  67.566  1.00 65.79           C  
ATOM   1211  CD  LYS   151      41.621  50.162  66.241  1.00 70.75           C  
ATOM   1212  CE  LYS   151      42.944  49.392  66.164  1.00 71.73           C  
ATOM   1213  NZ  LYS   151      43.159  48.731  64.846  1.00 72.52           N  
ATOM   1214  N   GLN   152      38.044  53.040  69.233  1.00 63.75           N  
ATOM   1215  CA  GLN   152      37.961  54.403  69.698  1.00 64.40           C  
ATOM   1216  C   GLN   152      37.173  54.524  71.007  1.00 64.24           C  
ATOM   1217  O   GLN   152      37.196  55.571  71.640  1.00 64.77           O  
ATOM   1218  CB  GLN   152      37.532  55.387  68.592  1.00 64.61           C  
ATOM   1219  CG  GLN   152      36.062  55.680  68.472  1.00 66.54           C  
ATOM   1220  CD  GLN   152      35.799  57.155  68.274  1.00 69.16           C  
ATOM   1221  OE1 GLN   152      34.813  57.540  67.658  1.00 72.32           O  
ATOM   1222  NE2 GLN   152      36.667  57.994  68.821  1.00 71.10           N  
ATOM   1223  N   ASN   153      36.519  53.453  71.429  1.00 63.29           N  
ATOM   1224  CA  ASN   153      35.780  53.492  72.678  1.00 63.53           C  
ATOM   1225  C   ASN   153      36.295  52.514  73.708  1.00 63.79           C  
ATOM   1226  O   ASN   153      35.654  52.292  74.736  1.00 63.26           O  
ATOM   1227  CB  ASN   153      34.302  53.230  72.425  1.00 63.39           C  
ATOM   1228  CG  ASN   153      33.615  54.397  71.765  1.00 62.56           C  
ATOM   1229  OD1 ASN   153      33.481  55.477  72.343  1.00 61.47           O  
ATOM   1230  ND2 ASN   153      33.163  54.181  70.555  1.00 62.37           N  
ATOM   1231  N   TYR   154      37.468  51.959  73.424  1.00 64.35           N  
ATOM   1232  CA  TYR   154      38.021  50.830  74.154  1.00 64.87           C  
ATOM   1233  C   TYR   154      37.977  51.032  75.673  1.00 64.22           C  
ATOM   1234  O   TYR   154      37.372  50.243  76.398  1.00 65.11           O  
ATOM   1235  CB  TYR   154      39.449  50.536  73.666  1.00 65.57           C  
ATOM   1236  CG  TYR   154      40.047  49.273  74.243  1.00 67.42           C  
ATOM   1237  CD1 TYR   154      39.799  48.022  73.644  1.00 69.26           C  
ATOM   1238  CD2 TYR   154      40.871  49.312  75.385  1.00 67.48           C  
ATOM   1239  CE1 TYR   154      40.352  46.840  74.157  1.00 68.18           C  
ATOM   1240  CE2 TYR   154      41.416  48.131  75.928  1.00 67.78           C  
ATOM   1241  CZ  TYR   154      41.145  46.898  75.308  1.00 69.01           C  
ATOM   1242  OH  TYR   154      41.682  45.711  75.808  1.00 70.29           O  
ATOM   1243  N   ASP   155      38.599  52.082  76.167  1.00 63.00           N  
ATOM   1244  CA  ASP   155      38.617  52.284  77.612  1.00 62.08           C  
ATOM   1245  C   ASP   155      37.215  52.364  78.228  1.00 60.93           C  
ATOM   1246  O   ASP   155      36.955  51.704  79.230  1.00 61.07           O  
ATOM   1247  CB  ASP   155      39.532  53.449  78.004  1.00 62.11           C  
ATOM   1248  CG  ASP   155      41.007  53.150  77.710  1.00 63.68           C  
ATOM   1249  OD1 ASP   155      41.404  51.968  77.752  1.00 63.75           O  
ATOM   1250  OD2 ASP   155      41.782  54.096  77.444  1.00 66.92           O  
ATOM   1251  N   ARG   156      36.325  53.142  77.616  0.50 60.35           N  
ATOM   1253  CA  ARG   156      34.951  53.271  78.098  0.50 59.56           C  
ATOM   1255  C   ARG   156      34.210  51.922  78.085  0.50 59.33           C  
ATOM   1257  O   ARG   156      33.566  51.552  79.074  0.50 59.30           O  
ATOM   1259  CB  ARG   156      34.190  54.348  77.303  0.50 59.35           C  
ATOM   1261  CG  ARG   156      32.709  54.514  77.647  0.50 58.27           C  
ATOM   1263  CD  ARG   156      32.496  54.857  79.123  0.50 58.16           C  
ATOM   1265  NE  ARG   156      31.118  55.273  79.401  0.50 57.16           N  
ATOM   1267  CZ  ARG   156      30.603  55.439  80.621  0.50 53.83           C  
ATOM   1269  NH1 ARG   156      31.333  55.214  81.705  0.50 50.49           N  
ATOM   1271  NH2 ARG   156      29.342  55.825  80.748  0.50 53.96           N  
ATOM   1273  N   TYR   157      34.314  51.183  76.983  1.00 59.03           N  
ATOM   1274  CA  TYR   157      33.636  49.896  76.875  1.00 58.63           C  
ATOM   1275  C   TYR   157      34.152  48.951  77.942  1.00 58.96           C  
ATOM   1276  O   TYR   157      33.389  48.380  78.700  1.00 59.40           O  
ATOM   1277  CB  TYR   157      33.846  49.301  75.510  1.00 59.28           C  
ATOM   1278  CG  TYR   157      33.035  49.900  74.385  1.00 59.29           C  
ATOM   1279  CD1 TYR   157      32.203  51.014  74.566  1.00 57.89           C  
ATOM   1280  CD2 TYR   157      33.158  49.380  73.112  1.00 58.11           C  
ATOM   1281  CE1 TYR   157      31.473  51.549  73.483  1.00 57.38           C  
ATOM   1282  CE2 TYR   157      32.439  49.890  72.052  1.00 58.83           C  
ATOM   1283  CZ  TYR   157      31.606  50.972  72.234  1.00 59.78           C  
ATOM   1284  OH  TYR   157      30.926  51.438  71.110  1.00 62.74           O  
ATOM   1285  N   LEU   158      35.464  48.824  78.045  1.00 59.50           N  
ATOM   1286  CA  LEU   158      36.044  47.981  79.075  1.00 59.86           C  
ATOM   1287  C   LEU   158      35.524  48.348  80.462  1.00 60.16           C  
ATOM   1288  O   LEU   158      35.113  47.467  81.220  1.00 60.78           O  
ATOM   1289  CB  LEU   158      37.562  48.099  79.054  1.00 59.80           C  
ATOM   1290  CG  LEU   158      38.262  47.129  80.008  1.00 60.44           C  
ATOM   1291  CD1 LEU   158      37.858  45.663  79.707  1.00 56.36           C  
ATOM   1292  CD2 LEU   158      39.766  47.334  79.948  1.00 59.85           C  
ATOM   1293  N   GLU   159      35.562  49.641  80.781  1.00 59.61           N  
ATOM   1294  CA  GLU   159      35.161  50.153  82.078  1.00 59.73           C  
ATOM   1295  C   GLU   159      33.742  49.670  82.381  1.00 59.78           C  
ATOM   1296  O   GLU   159      33.489  49.106  83.453  1.00 59.87           O  
ATOM   1297  CB  GLU   159      35.214  51.679  82.056  1.00 59.34           C  
ATOM   1298  CG  GLU   159      35.126  52.335  83.418  1.00 61.40           C  
ATOM   1299  CD  GLU   159      34.879  53.857  83.357  0.70 60.72           C  
ATOM   1300  OE1 GLU   159      34.127  54.327  82.466  0.70 63.42           O  
ATOM   1301  OE2 GLU   159      35.421  54.578  84.219  0.70 58.79           O  
ATOM   1302  N   LEU   160      32.818  49.861  81.427  1.00 59.37           N  
ATOM   1303  CA  LEU   160      31.439  49.367  81.576  1.00 58.56           C  
ATOM   1304  C   LEU   160      31.356  47.856  81.818  1.00 58.29           C  
ATOM   1305  O   LEU   160      30.541  47.413  82.616  1.00 59.51           O  
ATOM   1306  CB  LEU   160      30.567  49.737  80.369  1.00 57.95           C  
ATOM   1307  CG  LEU   160      30.347  51.218  80.103  1.00 58.23           C  
ATOM   1308  CD1 LEU   160      29.702  51.460  78.758  1.00 55.29           C  
ATOM   1309  CD2 LEU   160      29.536  51.881  81.245  1.00 56.98           C  
ATOM   1310  N   LEU   161      32.179  47.053  81.159  1.00 56.85           N  
ATOM   1311  CA  LEU   161      32.064  45.623  81.399  1.00 56.27           C  
ATOM   1312  C   LEU   161      32.491  45.340  82.827  1.00 56.63           C  
ATOM   1313  O   LEU   161      31.767  44.702  83.568  1.00 56.98           O  
ATOM   1314  CB  LEU   161      32.873  44.788  80.391  1.00 55.23           C  
ATOM   1315  CG  LEU   161      32.396  44.835  78.945  1.00 53.59           C  
ATOM   1316  CD1 LEU   161      33.466  44.302  77.999  1.00 52.49           C  
ATOM   1317  CD2 LEU   161      31.076  44.077  78.777  1.00 50.92           C  
ATOM   1318  N   LEU   162      33.655  45.845  83.211  1.00 57.06           N  
ATOM   1319  CA  LEU   162      34.197  45.628  84.544  1.00 58.48           C  
ATOM   1320  C   LEU   162      33.282  46.096  85.667  1.00 59.61           C  
ATOM   1321  O   LEU   162      33.264  45.501  86.759  1.00 60.23           O  
ATOM   1322  CB  LEU   162      35.574  46.304  84.700  1.00 58.31           C  
ATOM   1323  CG  LEU   162      36.705  45.644  83.895  1.00 57.84           C  
ATOM   1324  CD1 LEU   162      37.997  46.389  84.102  1.00 58.59           C  
ATOM   1325  CD2 LEU   162      36.901  44.204  84.266  1.00 56.12           C  
ATOM   1326  N   ASN   163      32.542  47.169  85.410  1.00 60.54           N  
ATOM   1327  CA  ASN   163      31.690  47.749  86.439  1.00 62.01           C  
ATOM   1328  C   ASN   163      30.436  46.879  86.527  1.00 62.08           C  
ATOM   1329  O   ASN   163      29.830  46.747  87.593  1.00 61.71           O  
ATOM   1330  CB  ASN   163      31.438  49.239  86.125  1.00 62.45           C  
ATOM   1331  CG  ASN   163      30.150  49.787  86.734  1.00 65.09           C  
ATOM   1332  OD1 ASN   163      30.050  50.022  87.957  1.00 67.46           O  
ATOM   1333  ND2 ASN   163      29.168  50.061  85.862  1.00 65.90           N  
ATOM   1334  N   GLY   164      30.102  46.245  85.397  1.00 62.36           N  
ATOM   1335  CA  GLY   164      28.971  45.325  85.296  1.00 62.20           C  
ATOM   1336  C   GLY   164      29.216  44.094  86.143  1.00 62.33           C  
ATOM   1337  O   GLY   164      28.300  43.587  86.792  1.00 62.50           O  
ATOM   1338  N   VAL   165      30.462  43.636  86.155  1.00 61.66           N  
ATOM   1339  CA  VAL   165      30.900  42.586  87.044  1.00 61.93           C  
ATOM   1340  C   VAL   165      30.706  42.951  88.532  1.00 62.82           C  
ATOM   1341  O   VAL   165      30.158  42.160  89.306  1.00 63.03           O  
ATOM   1342  CB  VAL   165      32.356  42.271  86.742  1.00 61.88           C  
ATOM   1343  CG1 VAL   165      33.024  41.473  87.860  1.00 60.99           C  
ATOM   1344  CG2 VAL   165      32.431  41.557  85.416  1.00 62.26           C  
ATOM   1345  N   GLN   166      31.142  44.149  88.935  1.00 63.51           N  
ATOM   1346  CA  GLN   166      30.938  44.637  90.305  1.00 63.09           C  
ATOM   1347  C   GLN   166      29.471  44.671  90.704  1.00 63.81           C  
ATOM   1348  O   GLN   166      29.126  44.278  91.796  1.00 63.65           O  
ATOM   1349  CB  GLN   166      31.571  46.010  90.467  1.00 62.92           C  
ATOM   1350  CG  GLN   166      33.101  45.969  90.431  1.00 62.83           C  
ATOM   1351  CD  GLN   166      33.682  44.920  91.377  1.00 62.74           C  
ATOM   1352  OE1 GLN   166      34.438  44.038  90.958  1.00 62.14           O  
ATOM   1353  NE2 GLN   166      33.307  44.994  92.653  1.00 62.51           N  
ATOM   1354  N   GLN   167      28.601  45.105  89.800  1.00 64.97           N  
ATOM   1355  CA  GLN   167      27.177  45.100  90.066  1.00 66.64           C  
ATOM   1356  C   GLN   167      26.588  43.715  90.317  1.00 67.34           C  
ATOM   1357  O   GLN   167      25.554  43.602  90.948  1.00 67.90           O  
ATOM   1358  CB  GLN   167      26.417  45.751  88.924  1.00 66.61           C  
ATOM   1359  CG  GLN   167      26.627  47.230  88.784  1.00 68.71           C  
ATOM   1360  CD  GLN   167      25.849  47.782  87.591  1.00 73.66           C  
ATOM   1361  OE1 GLN   167      24.753  48.315  87.760  1.00 78.39           O  
ATOM   1362  NE2 GLN   167      26.397  47.636  86.379  1.00 73.07           N  
ATOM   1363  N   LEU   168      27.233  42.661  89.833  1.00 68.72           N  
ATOM   1364  CA  LEU   168      26.708  41.304  90.031  1.00 69.87           C  
ATOM   1365  C   LEU   168      27.356  40.466  91.131  1.00 71.95           C  
ATOM   1366  O   LEU   168      26.886  39.378  91.409  1.00 72.69           O  
ATOM   1367  CB  LEU   168      26.700  40.502  88.726  1.00 68.81           C  
ATOM   1368  CG  LEU   168      25.923  41.090  87.550  1.00 66.67           C  
ATOM   1369  CD1 LEU   168      26.472  40.555  86.247  1.00 64.39           C  
ATOM   1370  CD2 LEU   168      24.420  40.871  87.662  1.00 64.21           C  
ATOM   1371  N   LYS   169      28.415  40.929  91.769  1.00 74.46           N  
ATOM   1372  CA  LYS   169      28.913  40.198  92.949  1.00 77.56           C  
ATOM   1373  C   LYS   169      27.846  39.801  94.033  1.00 78.83           C  
ATOM   1374  O   LYS   169      28.141  38.998  94.938  1.00 79.44           O  
ATOM   1375  CB  LYS   169      30.106  40.933  93.577  1.00 77.52           C  
ATOM   1376  CG  LYS   169      31.403  40.740  92.790  1.00 78.50           C  
ATOM   1377  CD  LYS   169      32.633  41.233  93.555  1.00 78.42           C  
ATOM   1378  CE  LYS   169      33.945  40.723  92.918  1.00 80.07           C  
ATOM   1379  NZ  LYS   169      35.138  40.771  93.875  1.00 79.99           N  
ATOM   1380  N   LYS   170      26.634  40.359  93.952  0.50 79.57           N  
ATOM   1382  CA  LYS   170      25.538  39.973  94.871  0.50 80.11           C  
ATOM   1384  C   LYS   170      24.549  38.959  94.268  0.50 80.39           C  
ATOM   1386  O   LYS   170      23.591  38.551  94.934  0.50 80.15           O  
ATOM   1388  CB  LYS   170      24.781  41.207  95.387  0.50 80.17           C  
ATOM   1390  CG  LYS   170      25.323  41.807  96.689  0.50 80.36           C  
ATOM   1392  CD  LYS   170      25.130  43.323  96.702  0.50 80.64           C  
ATOM   1394  CE  LYS   170      26.132  43.993  95.748  0.50 81.04           C  
ATOM   1396  NZ  LYS   170      25.532  45.067  94.897  0.50 80.73           N  
ATOM   1398  N   SER   171      24.786  38.562  93.015  1.00 80.70           N  
ATOM   1399  CA  SER   171      23.954  37.549  92.335  1.00 81.42           C  
ATOM   1400  C   SER   171      24.465  36.097  92.432  1.00 81.92           C  
ATOM   1401  O   SER   171      25.649  35.814  92.203  1.00 82.04           O  
ATOM   1402  CB  SER   171      23.759  37.931  90.868  1.00 81.24           C  
ATOM   1403  OG  SER   171      23.207  39.226  90.791  1.00 81.58           O  
ATOM   1404  N   ASP   172      23.545  35.186  92.744  1.00 82.34           N  
ATOM   1405  CA  ASP   172      23.861  33.770  92.943  1.00 82.68           C  
ATOM   1406  C   ASP   172      24.277  33.041  91.674  1.00 82.52           C  
ATOM   1407  O   ASP   172      23.873  33.417  90.568  1.00 82.88           O  
ATOM   1408  CB  ASP   172      22.657  33.062  93.559  1.00 82.79           C  
ATOM   1409  CG  ASP   172      22.438  33.458  95.000  1.00 84.58           C  
ATOM   1410  OD1 ASP   172      23.450  33.670  95.718  1.00 85.73           O  
ATOM   1411  OD2 ASP   172      21.258  33.563  95.417  1.00 86.61           O  
ATOM   1412  N   SER   173      25.096  32.003  91.843  1.00 82.19           N  
ATOM   1413  CA  SER   173      25.301  31.003  90.800  1.00 81.94           C  
ATOM   1414  C   SER   173      24.071  30.069  90.794  1.00 81.85           C  
ATOM   1415  O   SER   173      23.403  29.904  91.826  1.00 81.43           O  
ATOM   1416  CB  SER   173      26.592  30.199  91.050  1.00 81.85           C  
ATOM   1417  OG  SER   173      27.686  31.033  91.420  1.00 81.39           O  
ATOM   1418  N   PHE   174      23.758  29.470  89.644  1.00 81.81           N  
ATOM   1419  CA  PHE   174      22.619  28.543  89.587  1.00 81.63           C  
ATOM   1420  C   PHE   174      22.810  27.343  88.654  1.00 81.91           C  
ATOM   1421  O   PHE   174      23.540  27.415  87.661  1.00 81.37           O  
ATOM   1422  CB  PHE   174      21.292  29.292  89.303  1.00 81.50           C  
ATOM   1423  CG  PHE   174      21.210  29.948  87.929  1.00 79.93           C  
ATOM   1424  CD1 PHE   174      20.686  29.252  86.839  1.00 78.93           C  
ATOM   1425  CD2 PHE   174      21.613  31.277  87.746  1.00 78.89           C  
ATOM   1426  CE1 PHE   174      20.590  29.866  85.571  1.00 79.10           C  
ATOM   1427  CE2 PHE   174      21.518  31.899  86.488  1.00 78.38           C  
ATOM   1428  CZ  PHE   174      21.009  31.192  85.402  1.00 79.22           C  
ATOM   1429  N   HIS   175      22.150  26.239  89.005  1.00 82.82           N  
ATOM   1430  CA  HIS   175      22.171  25.024  88.184  1.00 83.73           C  
ATOM   1431  C   HIS   175      20.784  24.647  87.647  1.00 83.73           C  
ATOM   1432  O   HIS   175      20.188  23.692  88.128  1.00 83.82           O  
ATOM   1433  CB  HIS   175      22.792  23.846  88.952  1.00 83.68           C  
ATOM   1434  CG  HIS   175      23.642  22.961  88.092  1.00 85.07           C  
ATOM   1435  ND1 HIS   175      25.007  22.846  88.258  1.00 86.20           N  
ATOM   1436  CD2 HIS   175      23.328  22.187  87.023  1.00 86.70           C  
ATOM   1437  CE1 HIS   175      25.491  22.015  87.347  1.00 86.84           C  
ATOM   1438  NE2 HIS   175      24.495  21.607  86.580  1.00 86.55           N  
ATOM   1439  N   GLN   176      20.311  25.384  86.631  1.00 84.15           N  
ATOM   1440  CA  GLN   176      18.948  25.260  86.075  1.00 83.95           C  
ATOM   1441  C   GLN   176      18.909  25.379  84.553  1.00 84.23           C  
ATOM   1442  O   GLN   176      17.994  24.871  83.896  1.00 84.64           O  
ATOM   1443  CB  GLN   176      18.045  26.337  86.670  1.00 83.77           C  
ATOM   1444  CG  GLN   176      16.990  25.824  87.634  1.00 83.19           C  
ATOM   1445  CD  GLN   176      17.544  25.260  88.942  1.00 82.37           C  
ATOM   1446  OE1 GLN   176      18.293  25.931  89.668  1.00 82.87           O  
ATOM   1447  NE2 GLN   176      17.149  24.024  89.261  1.00 80.86           N  
END
