
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  286 ( 2291),  selected  286 , name 2qnk_A
# Molecule2: number of CA atoms  138 ( 1133),  selected  138 , name T0414.pdb
# PARAMETERS: 2qnk_A.T0414.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       3           -
LGA    S     1_A      M       4           #
LGA    E     2_A      K       5           -
LGA    R     3_A      -       -           -
LGA    R     4_A      P       6          3.472
LGA    L     5_A      D       7          2.659
LGA    G     6_A      I       8          4.370
LGA    V     7_A      -       -           -
LGA    R     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    W    10_A      Y       9          2.807
LGA    V    11_A      E      10          2.761
LGA    K    12_A      -       -           -
LGA    E    13_A      -       -           -
LGA    N    14_A      -       -           -
LGA    R    15_A      N      11          4.650
LGA    G    16_A      N      12          2.307
LGA    S    17_A      R      13          1.836
LGA    F    18_A      -       -           -
LGA    Q    19_A      -       -           -
LGA    P    20_A      -       -           -
LGA    P    21_A      -       -           -
LGA    V    22_A      E      14          2.989
LGA    C    23_A      G      15          1.913
LGA    N    24_A      I      16          1.804
LGA    K    25_A      L      17          1.096
LGA    L    26_A      C      18          0.926
LGA    X    27_A      V      19          0.899
LGA    H    28_A      Y      20          1.239
LGA    Q    29_A      K      21          2.842
LGA    E    30_A      N      22          2.956
LGA    Q    31_A      E      23          2.839
LGA    -       -      K      24           -
LGA    L    32_A      W      25          1.100
LGA    K    33_A      L      26          1.707
LGA    V    34_A      V      27          0.520
LGA    X    35_A      C      28          0.227
LGA    F    36_A      I      29          0.275
LGA    I    37_A      K      30          0.648
LGA    G    38_A      N      31          0.874
LGA    G    39_A      W      32          1.005
LGA    P    40_A      K      33          4.587
LGA    N    41_A      P      34          3.525
LGA    T    42_A      D      35          3.509
LGA    R    43_A      N      36          4.272
LGA    -       -      D      37           -
LGA    -       -      I      38           -
LGA    -       -      E      39           -
LGA    -       -      G      40           -
LGA    -       -      I      41           -
LGA    K    44_A      A      42          1.497
LGA    D    45_A      H      43          1.505
LGA    Y    46_A      L      44          0.950
LGA    H    47_A      E      45          0.774
LGA    I    48_A      I      46          0.865
LGA    E    49_A      H      47          0.923
LGA    E    50_A      H      48          1.980
LGA    -       -      S      49           -
LGA    G    51_A      T      50          0.768
LGA    E    52_A      D      51          0.607
LGA    E    53_A      E      52          0.603
LGA    V    54_A      Q      53          0.400
LGA    F    55_A      F      54          0.187
LGA    Y    56_A      I      55          0.390
LGA    Q    57_A      L      56          0.596
LGA    L    58_A      S      57          1.276
LGA    E    59_A      A      58          1.281
LGA    G    60_A      G      59          1.895
LGA    D    61_A      K      60          1.920
LGA    X    62_A      A      61          0.930
LGA    V    63_A      I      62          1.109
LGA    L    64_A      L      63          1.424
LGA    R    65_A      I      64          1.265
LGA    V    66_A      T      65          1.359
LGA    L    67_A      A      66          0.541
LGA    E    68_A      E      67          4.087
LGA    Q    69_A      K      68           #
LGA    G    70_A      E      69          4.738
LGA    -       -      N      70           -
LGA    -       -      D      71           -
LGA    -       -      K      72           -
LGA    -       -      F      73           -
LGA    K    71_A      N      74          1.346
LGA    H    72_A      I      75          0.711
LGA    R    73_A      E      76          1.008
LGA    D    74_A      L      77          0.971
LGA    V    75_A      T      78          1.604
LGA    V    76_A      L      79          1.351
LGA    I    77_A      M      80          0.969
LGA    R    78_A      E      81          2.377
LGA    Q    79_A      K      82          2.525
LGA    G    80_A      G      83          2.596
LGA    E    81_A      K      84          2.404
LGA    I    82_A      V      85          1.288
LGA    F    83_A      Y      86          0.516
LGA    L    84_A      N      87          0.702
LGA    L    85_A      V      88          0.754
LGA    P    86_A      P      89          0.829
LGA    A    87_A      A      90          0.881
LGA    R    88_A      E      91          0.548
LGA    V    89_A      C      92          0.564
LGA    P    90_A      W      93          0.805
LGA    H    91_A      F      94          0.861
LGA    S    92_A      Y      95          1.699
LGA    P    93_A      S      96          1.434
LGA    Q    94_A      I      97          1.563
LGA    R    95_A      T      98          1.756
LGA    F    96_A      Q      99          1.201
LGA    A    97_A      K     100          1.128
LGA    N    98_A      D     101          1.352
LGA    T    99_A      T     102          1.777
LGA    V   100_A      K     103          1.284
LGA    G   101_A      M     104          0.443
LGA    L   102_A      M     105          0.565
LGA    V   103_A      Y     106          0.426
LGA    V   104_A      V     107          0.502
LGA    E   105_A      Q     108          0.699
LGA    R   106_A      D     109          0.676
LGA    R   107_A      S     110          2.747
LGA    R   108_A      N     111          3.355
LGA    L   109_A      C     112           -
LGA    E   110_A      S     113           -
LGA    T   111_A      M     114           -
LGA    E   112_A      D     115           #
LGA    L   113_A      N     116          2.191
LGA    D   114_A      S     117          1.218
LGA    G   115_A      D     118          0.976
LGA    L   116_A      F     119          0.888
LGA    R   117_A      C     120          0.430
LGA    Y   118_A      D     121          0.387
LGA    Y   119_A      L     122          2.423
LGA    V   120_A      S     123          1.672
LGA    G   121_A      K     124          2.108
LGA    D   122_A      E     125          3.609
LGA    T   123_A      E     126          4.694
LGA    X   124_A      I     127           -
LGA    D   125_A      E     128           -
LGA    V   126_A      Y     129           -
LGA    L   127_A      I     130           -
LGA    F   128_A      Q     131           -
LGA    E   129_A      T     132           -
LGA    K   130_A      N     133           -
LGA    W   131_A      A     134           -
LGA    F   132_A      R     135           -
LGA    Y   133_A      K     136           -
LGA    C   134_A      L     137           -
LGA    K   135_A      F     138           -
LGA    D   136_A      E     139           -
LGA    L   137_A      K     140           -
LGA    G   138_A      -       -           -
LGA    T   139_A      -       -           -
LGA    Q   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    P   143_A      -       -           -
LGA    I   144_A      -       -           -
LGA    I   145_A      -       -           -
LGA    Q   146_A      -       -           -
LGA    E   147_A      -       -           -
LGA    F   148_A      -       -           -
LGA    F   149_A      -       -           -
LGA    S   150_A      -       -           -
LGA    S   151_A      -       -           -
LGA    E   152_A      -       -           -
LGA    Q   153_A      -       -           -
LGA    Y   154_A      -       -           -
LGA    R   155_A      -       -           -
LGA    T   156_A      -       -           -
LGA    G   157_A      -       -           -
LGA    K   158_A      -       -           -
LGA    P   159_A      -       -           -
LGA    I   160_A      -       -           -
LGA    P   161_A      -       -           -
LGA    D   162_A      -       -           -
LGA    Q   163_A      -       -           -
LGA    L   164_A      -       -           -
LGA    L   165_A      -       -           -
LGA    K   166_A      -       -           -
LGA    E   167_A      -       -           -
LGA    P   168_A      -       -           -
LGA    P   169_A      -       -           -
LGA    F   170_A      -       -           -
LGA    P   171_A      -       -           -
LGA    L   172_A      -       -           -
LGA    S   173_A      -       -           -
LGA    T   174_A      -       -           -
LGA    R   175_A      -       -           -
LGA    S   176_A      -       -           -
LGA    I   177_A      -       -           -
LGA    X   178_A      -       -           -
LGA    E   179_A      -       -           -
LGA    P   180_A      -       -           -
LGA    X   181_A      -       -           -
LGA    S   182_A      -       -           -
LGA    L   183_A      -       -           -
LGA    D   184_A      -       -           -
LGA    A   185_A      -       -           -
LGA    W   186_A      -       -           -
LGA    L   187_A      -       -           -
LGA    D   188_A      -       -           -
LGA    S   189_A      -       -           -
LGA    H   190_A      -       -           -
LGA    H   191_A      -       -           -
LGA    R   192_A      -       -           -
LGA    E   193_A      -       -           -
LGA    L   194_A      -       -           -
LGA    Q   195_A      -       -           -
LGA    A   196_A      -       -           -
LGA    G   197_A      -       -           -
LGA    T   198_A      -       -           -
LGA    P   199_A      -       -           -
LGA    L   200_A      -       -           -
LGA    S   201_A      -       -           -
LGA    L   202_A      -       -           -
LGA    F   203_A      -       -           -
LGA    G   204_A      -       -           -
LGA    D   205_A      -       -           -
LGA    T   206_A      -       -           -
LGA    Y   207_A      -       -           -
LGA    E   208_A      -       -           -
LGA    T   209_A      -       -           -
LGA    Q   210_A      -       -           -
LGA    V   211_A      -       -           -
LGA    I   212_A      -       -           -
LGA    A   213_A      -       -           -
LGA    Y   214_A      -       -           -
LGA    G   215_A      -       -           -
LGA    Q   216_A      -       -           -
LGA    G   217_A      -       -           -
LGA    S   218_A      -       -           -
LGA    S   219_A      -       -           -
LGA    E   220_A      -       -           -
LGA    G   221_A      -       -           -
LGA    L   222_A      -       -           -
LGA    R   223_A      -       -           -
LGA    Q   224_A      -       -           -
LGA    N   225_A      -       -           -
LGA    V   226_A      -       -           -
LGA    D   227_A      -       -           -
LGA    V   228_A      -       -           -
LGA    W   229_A      -       -           -
LGA    L   230_A      -       -           -
LGA    W   231_A      -       -           -
LGA    Q   232_A      -       -           -
LGA    L   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    G   235_A      -       -           -
LGA    S   236_A      -       -           -
LGA    S   237_A      -       -           -
LGA    V   238_A      -       -           -
LGA    V   239_A      -       -           -
LGA    T   240_A      -       -           -
LGA    X   241_A      -       -           -
LGA    G   242_A      -       -           -
LGA    G   243_A      -       -           -
LGA    R   244_A      -       -           -
LGA    R   245_A      -       -           -
LGA    L   246_A      -       -           -
LGA    S   247_A      -       -           -
LGA    L   248_A      -       -           -
LGA    A   249_A      -       -           -
LGA    P   250_A      -       -           -
LGA    D   251_A      -       -           -
LGA    D   252_A      -       -           -
LGA    S   253_A      -       -           -
LGA    L   254_A      -       -           -
LGA    L   255_A      -       -           -
LGA    V   256_A      -       -           -
LGA    L   257_A      -       -           -
LGA    A   258_A      -       -           -
LGA    G   259_A      -       -           -
LGA    T   260_A      -       -           -
LGA    S   261_A      -       -           -
LGA    Y   262_A      -       -           -
LGA    A   263_A      -       -           -
LGA    W   264_A      -       -           -
LGA    E   265_A      -       -           -
LGA    R   266_A      -       -           -
LGA    T   267_A      -       -           -
LGA    Q   268_A      -       -           -
LGA    G   269_A      -       -           -
LGA    S   270_A      -       -           -
LGA    V   271_A      -       -           -
LGA    A   272_A      -       -           -
LGA    L   273_A      -       -           -
LGA    S   274_A      -       -           -
LGA    V   275_A      -       -           -
LGA    T   276_A      -       -           -
LGA    Q   277_A      -       -           -
LGA    D   278_A      -       -           -
LGA    P   279_A      -       -           -
LGA    A   280_A      -       -           -
LGA    C   281_A      -       -           -
LGA    K   282_A      -       -           -
LGA    K   283_A      -       -           -
LGA    P   284_A      -       -           -
LGA    L   285_A      -       -           -
LGA    G   286_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  286  138    5.0    105    1.97    11.43     66.868     5.065

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.443096 * X  +  -0.851045 * Y  +  -0.281759 * Z  +  78.809380
  Y_new =   0.880761 * X  +   0.354682 * Y  +   0.313785 * Z  + -57.459648
  Z_new =  -0.167111 * X  +  -0.387199 * Y  +   0.906725 * Z  +  21.342968 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.403589    2.738004  [ DEG:   -23.1239    156.8761 ]
  Theta =   0.167899    2.973694  [ DEG:     9.6199    170.3801 ]
  Phi   =   1.104685   -2.036908  [ DEG:    63.2938   -116.7062 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qnk_A                                        
REMARK     2: T0414.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qnk_A.T0414.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  286  138   5.0  105   1.97   11.43  66.868
REMARK  ---------------------------------------------------------- 
MOLECULE 2qnk_A
HEADER    OXIDOREDUCTASE                          18-JUL-07   2QNK              
TITLE     CRYSTAL STRUCTURE OF HUMAN 3-HYDROXYANTHRANILATE 3,4-                 
TITLE    2 DIOXYGENASE                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 3-HYDROXYANTHRANILATE 3,4-DIOXYGENASE;                     
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: 3-HAO, 3-HYDROXYANTHRANILIC ACID DIOXYGENASE, 3-            
COMPND   5 HYDROXYANTHRANILATE OXYGENASE;                                       
COMPND   6 EC: 1.13.11.6;                                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 TISSUE: BRAIN;                                                       
SOURCE   5 GENE: HAAO;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL834(DE3) P(RARE2);                       
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PVP16                                     
KEYWDS    BICUPIN FOLD, CUPIN BARREL, EXTRADIOL DIOXYGENASE,                    
KEYWDS   2 METALLOENZYME, TRYTOPHAN CATABOLISM, NAD+ SYNTHESIS,                 
KEYWDS   3 QUINOLINATE, KYNURENINE PATHWAY, STRUCTURAL GENOMICS                 
KEYWDS   4 MEDICAL RELEVANCE, PROTEIN STRUCTURE INITIATIVE, PSI,                
KEYWDS   5 CENTER FOR EUKARYOTIC STRUCTURAL GENOMICS, CESG,                     
KEYWDS   6 OXIDOREDUCTASE                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.BITTO,C.A.BINGMAN,G.E.WESENBERG,G.N.PHILLIPS JR.,CENTER             
AUTHOR   2 FOR EUKARYOTIC STRUCTURAL GENOMICS (CESG)                            
REVDAT   1   14-AUG-07 2QNK    0                                                
JRNL        AUTH   E.BITTO,C.A.BINGMAN,G.E.WESENBERG,G.N.PHILLIPS JR.           
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN 3-HYDROXYANTHRANILATE             
JRNL        TITL 2 3,4-DIOXYGENASE.                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
SEQRES   1 A  286  SER GLU ARG ARG LEU GLY VAL ARG ALA TRP VAL LYS GLU          
SEQRES   2 A  286  ASN ARG GLY SER PHE GLN PRO PRO VAL CYS ASN LYS LEU          
SEQRES   3 A  286  MSE HIS GLN GLU GLN LEU LYS VAL MSE PHE ILE GLY GLY          
SEQRES   4 A  286  PRO ASN THR ARG LYS ASP TYR HIS ILE GLU GLU GLY GLU          
SEQRES   5 A  286  GLU VAL PHE TYR GLN LEU GLU GLY ASP MSE VAL LEU ARG          
SEQRES   6 A  286  VAL LEU GLU GLN GLY LYS HIS ARG ASP VAL VAL ILE ARG          
SEQRES   7 A  286  GLN GLY GLU ILE PHE LEU LEU PRO ALA ARG VAL PRO HIS          
SEQRES   8 A  286  SER PRO GLN ARG PHE ALA ASN THR VAL GLY LEU VAL VAL          
SEQRES   9 A  286  GLU ARG ARG ARG LEU GLU THR GLU LEU ASP GLY LEU ARG          
SEQRES  10 A  286  TYR TYR VAL GLY ASP THR MSE ASP VAL LEU PHE GLU LYS          
SEQRES  11 A  286  TRP PHE TYR CYS LYS ASP LEU GLY THR GLN LEU ALA PRO          
SEQRES  12 A  286  ILE ILE GLN GLU PHE PHE SER SER GLU GLN TYR ARG THR          
SEQRES  13 A  286  GLY LYS PRO ILE PRO ASP GLN LEU LEU LYS GLU PRO PRO          
SEQRES  14 A  286  PHE PRO LEU SER THR ARG SER ILE MSE GLU PRO MSE SER          
SEQRES  15 A  286  LEU ASP ALA TRP LEU ASP SER HIS HIS ARG GLU LEU GLN          
SEQRES  16 A  286  ALA GLY THR PRO LEU SER LEU PHE GLY ASP THR TYR GLU          
SEQRES  17 A  286  THR GLN VAL ILE ALA TYR GLY GLN GLY SER SER GLU GLY          
SEQRES  18 A  286  LEU ARG GLN ASN VAL ASP VAL TRP LEU TRP GLN LEU GLU          
SEQRES  19 A  286  GLY SER SER VAL VAL THR MSE GLY GLY ARG ARG LEU SER          
SEQRES  20 A  286  LEU ALA PRO ASP ASP SER LEU LEU VAL LEU ALA GLY THR          
SEQRES  21 A  286  SER TYR ALA TRP GLU ARG THR GLN GLY SER VAL ALA LEU          
SEQRES  22 A  286  SER VAL THR GLN ASP PRO ALA CYS LYS LYS PRO LEU GLY          
HET    MSE  A  27       8                                                       
HET    MSE  A  35      16                                                       
HET    MSE  A  62      16                                                       
HET    MSE  A 124       8                                                       
HET    MSE  A 178       8                                                       
HET    MSE  A 181       8                                                       
HET    MSE  A 241       8                                                       
HET     NI  A 287       1                                                       
HET    PO4  A 288       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   1  MSE    7(C5 H11 N O2 SE)                                            
FORMUL   2   NI    NI 2+                                                        
FORMUL   3  PO4    O4 P 3-                                                      
FORMUL   4  HOH   *413(H2 O)                                                    
CRYST1   50.498   78.227   85.080  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   SER A   1      39.334  12.934  32.319  1.00 20.80           N  
ATOM      2  CA  SER A   1      39.834  12.680  30.932  1.00 17.94           C  
ATOM      3  C   SER A   1      38.839  13.179  29.894  1.00 16.57           C  
ATOM      4  O   SER A   1      37.679  12.769  29.891  1.00 16.10           O  
ATOM      5  CB  SER A   1      40.047  11.175  30.656  1.00 20.41           C  
ATOM      6  OG  SER A   1      40.428  10.956  29.300  1.00 24.68           O  
ATOM      7  N   GLU A   2      39.324  13.983  28.938  1.00 14.56           N  
ATOM      8  CA  GLU A   2      38.450  14.495  27.879  1.00 14.24           C  
ATOM      9  C   GLU A   2      38.079  13.369  26.895  1.00 12.66           C  
ATOM     10  O   GLU A   2      37.232  13.585  26.016  1.00 13.76           O  
ATOM     11  CB  GLU A   2      39.140  15.656  27.118  1.00 14.50           C  
ATOM     12  CG  GLU A   2      40.413  15.169  26.415  1.00 14.73           C  
ATOM     13  CD  GLU A   2      40.998  16.133  25.397  1.00 21.78           C  
ATOM     14  OE1 GLU A   2      40.393  17.189  25.108  1.00 25.24           O  
ATOM     15  OE2 GLU A   2      42.083  15.800  24.865  1.00 30.08           O  
ATOM     16  N   ARG A   3      38.684  12.182  27.051  1.00 11.77           N  
ATOM     17  CA  ARG A   3      38.389  11.047  26.170  1.00 12.41           C  
ATOM     18  C   ARG A   3      37.268  10.138  26.707  1.00 13.03           C  
ATOM     19  O   ARG A   3      36.990   9.116  26.103  1.00 13.00           O  
ATOM     20  CB  ARG A   3      39.637  10.168  25.960  1.00 14.04           C  
ATOM     21  CG  ARG A   3      40.845  10.891  25.342  1.00 19.66           C  
ATOM     22  CD  ARG A   3      40.612  11.149  23.887  1.00 20.67           C  
ATOM     23  NE  ARG A   3      41.785  11.779  23.264  1.00 19.09           N  
ATOM     24  CZ  ARG A   3      41.883  11.991  21.954  1.00 23.60           C  
ATOM     25  NH1 ARG A   3      40.879  11.617  21.134  1.00 22.68           N  
ATOM     26  NH2 ARG A   3      42.960  12.587  21.474  1.00 19.73           N  
ATOM     27  N   ARG A   4      36.695  10.486  27.868  1.00 11.72           N  
ATOM     28  CA  ARG A   4      35.540   9.758  28.384  1.00 11.67           C  
ATOM     29  C   ARG A   4      34.287  10.408  27.816  1.00 11.87           C  
ATOM     30  O   ARG A   4      34.032  11.593  28.040  1.00 12.49           O  
ATOM     31  CB  ARG A   4      35.514   9.802  29.917  1.00 12.50           C  
ATOM     32  CG  ARG A   4      34.247   9.123  30.428  1.00 11.79           C  
ATOM     33  CD  ARG A   4      34.108   9.172  31.970  1.00 11.28           C  
ATOM     34  NE  ARG A   4      34.098  10.546  32.439  1.00 12.77           N  
ATOM     35  CZ  ARG A   4      34.243  10.896  33.718  1.00 14.63           C  
ATOM     36  NH1 ARG A   4      34.387   9.951  34.654  1.00 13.72           N  
ATOM     37  NH2 ARG A   4      34.271  12.191  34.080  1.00 15.82           N  
ATOM     38  N   LEU A   5      33.505   9.619  27.071  1.00 11.59           N  
ATOM     39  CA  LEU A   5      32.304  10.106  26.391  1.00 11.31           C  
ATOM     40  C   LEU A   5      31.174   9.094  26.513  1.00 14.17           C  
ATOM     41  O   LEU A   5      31.390   7.890  26.298  1.00 13.44           O  
ATOM     42  CB  LEU A   5      32.583  10.340  24.889  1.00 11.91           C  
ATOM     43  CG  LEU A   5      33.740  11.281  24.556  1.00 12.31           C  
ATOM     44  CD1 LEU A   5      34.069  11.198  23.070  1.00 13.18           C  
ATOM     45  CD2 LEU A   5      33.431  12.727  24.915  1.00 15.31           C  
ATOM     46  N   GLY A   6      29.963   9.570  26.811  1.00 13.69           N  
ATOM     47  CA  GLY A   6      28.802   8.682  26.833  1.00 13.75           C  
ATOM     48  C   GLY A   6      28.459   8.450  25.375  1.00 13.27           C  
ATOM     49  O   GLY A   6      28.281   9.415  24.625  1.00 13.74           O  
ATOM     50  N   VAL A   7      28.393   7.200  24.947  1.00 13.12           N  
ATOM     51  CA  VAL A   7      28.204   6.964  23.483  1.00 13.86           C  
ATOM     52  C   VAL A   7      26.857   7.501  22.942  1.00 13.22           C  
ATOM     53  O   VAL A   7      26.836   8.276  21.979  1.00 13.46           O  
ATOM     54  CB  VAL A   7      28.367   5.477  23.172  1.00 14.37           C  
ATOM     55  CG1 VAL A   7      28.037   5.185  21.694  1.00 13.35           C  
ATOM     56  CG2 VAL A   7      29.787   5.066  23.492  1.00 14.97           C  
ATOM     57  N   ARG A   8      25.736   7.120  23.551  1.00 12.13           N  
ATOM     58  CA  ARG A   8      24.427   7.623  23.080  1.00 12.83           C  
ATOM     59  C   ARG A   8      24.343   9.148  23.230  1.00 13.50           C  
ATOM     60  O   ARG A   8      23.805   9.843  22.371  1.00 14.91           O  
ATOM     61  CB  ARG A   8      23.279   6.971  23.860  1.00 14.32           C  
ATOM     62  CG  ARG A   8      22.753   5.732  23.189  1.00 22.11           C  
ATOM     63  CD  ARG A   8      23.542   4.564  23.503  1.00 30.23           C  
ATOM     64  NE  ARG A   8      22.810   3.341  23.182  1.00 39.83           N  
ATOM     65  CZ  ARG A   8      23.324   2.129  23.344  1.00 46.32           C  
ATOM     66  NH1 ARG A   8      24.559   1.999  23.829  1.00 37.62           N  
ATOM     67  NH2 ARG A   8      22.613   1.056  23.016  1.00 43.74           N  
ATOM     68  N   ALA A   9      24.905   9.676  24.325  1.00 14.24           N  
ATOM     69  CA  ALA A   9      24.900  11.119  24.553  1.00 14.72           C  
ATOM     70  C   ALA A   9      25.652  11.847  23.434  1.00 14.43           C  
ATOM     71  O   ALA A   9      25.198  12.850  22.909  1.00 14.96           O  
ATOM     72  CB  ALA A   9      25.557  11.470  25.915  1.00 16.41           C  
ATOM     73  N   TRP A  10      26.796  11.291  23.057  1.00 13.64           N  
ATOM     74  CA  TRP A  10      27.621  11.884  21.998  1.00 13.42           C  
ATOM     75  C   TRP A  10      26.919  11.805  20.626  1.00 13.07           C  
ATOM     76  O   TRP A  10      26.981  12.754  19.821  1.00 13.71           O  
ATOM     77  CB  TRP A  10      28.978  11.169  21.996  1.00 14.69           C  
ATOM     78  CG  TRP A  10      29.972  11.729  21.017  1.00 14.31           C  
ATOM     79  CD1 TRP A  10      30.923  12.686  21.247  1.00 12.70           C  
ATOM     80  CD2 TRP A  10      30.116  11.340  19.642  1.00 13.82           C  
ATOM     81  NE1 TRP A  10      31.662  12.929  20.083  1.00 14.38           N  
ATOM     82  CE2 TRP A  10      31.187  12.105  19.095  1.00 13.98           C  
ATOM     83  CE3 TRP A  10      29.434  10.426  18.817  1.00 15.45           C  
ATOM     84  CZ2 TRP A  10      31.595  11.984  17.744  1.00 15.53           C  
ATOM     85  CZ3 TRP A  10      29.841  10.308  17.472  1.00 13.25           C  
ATOM     86  CH2 TRP A  10      30.900  11.098  16.952  1.00 15.81           C  
ATOM     87  N   VAL A  11      26.247  10.685  20.361  1.00 13.03           N  
ATOM     88  CA  VAL A  11      25.455  10.556  19.126  1.00 11.39           C  
ATOM     89  C   VAL A  11      24.360  11.638  19.086  1.00 11.90           C  
ATOM     90  O   VAL A  11      24.119  12.292  18.048  1.00 12.02           O  
ATOM     91  CB  VAL A  11      24.879   9.125  18.980  1.00 11.76           C  
ATOM     92  CG1 VAL A  11      23.827   9.048  17.879  1.00 13.94           C  
ATOM     93  CG2 VAL A  11      26.040   8.095  18.718  1.00 13.47           C  
ATOM     94  N   LYS A  12      23.675  11.830  20.216  1.00 12.23           N  
ATOM     95  CA  LYS A  12      22.583  12.829  20.256  1.00 13.22           C  
ATOM     96  C   LYS A  12      23.153  14.224  19.994  1.00 13.61           C  
ATOM     97  O   LYS A  12      22.624  14.986  19.190  1.00 12.81           O  
ATOM     98  CB  LYS A  12      21.881  12.807  21.620  1.00 14.05           C  
ATOM     99  CG  LYS A  12      20.736  13.799  21.706  1.00 14.06           C  
ATOM    100  CD  LYS A  12      19.880  13.623  22.966  1.00 14.00           C  
ATOM    101  CE  LYS A  12      18.875  14.750  23.032  1.00 17.41           C  
ATOM    102  NZ  LYS A  12      17.978  14.599  24.228  1.00 19.24           N  
ATOM    103  N   GLU A  13      24.266  14.518  20.663  1.00 13.89           N  
ATOM    104  CA  GLU A  13      24.913  15.820  20.554  1.00 14.80           C  
ATOM    105  C   GLU A  13      25.342  16.092  19.107  1.00 14.43           C  
ATOM    106  O   GLU A  13      25.290  17.226  18.641  1.00 15.16           O  
ATOM    107  CB  GLU A  13      26.090  15.905  21.529  1.00 16.44           C  
ATOM    108  CG  GLU A  13      26.923  17.188  21.422  1.00 18.74           C  
ATOM    109  CD  GLU A  13      26.165  18.412  21.890  1.00 27.98           C  
ATOM    110  OE1 GLU A  13      25.335  18.276  22.814  1.00 29.52           O  
ATOM    111  OE2 GLU A  13      26.399  19.508  21.344  1.00 29.16           O  
ATOM    112  N   ASN A  14      25.715  15.035  18.403  1.00 12.33           N  
ATOM    113  CA  ASN A  14      26.190  15.164  17.016  1.00 13.74           C  
ATOM    114  C   ASN A  14      25.180  14.681  15.969  1.00 14.76           C  
ATOM    115  O   ASN A  14      25.553  14.383  14.828  1.00 13.82           O  
ATOM    116  CB  ASN A  14      27.526  14.416  16.901  1.00 13.56           C  
ATOM    117  CG  ASN A  14      28.633  15.126  17.657  1.00 15.09           C  
ATOM    118  OD1 ASN A  14      29.093  14.655  18.709  1.00 18.63           O  
ATOM    119  ND2 ASN A  14      29.018  16.285  17.167  1.00 15.15           N  
ATOM    120  N   ARG A  15      23.896  14.670  16.330  1.00 13.02           N  
ATOM    121  CA  ARG A  15      22.895  13.990  15.507  1.00 14.45           C  
ATOM    122  C   ARG A  15      22.886  14.507  14.069  1.00 13.09           C  
ATOM    123  O   ARG A  15      22.666  13.731  13.129  1.00 13.91           O  
ATOM    124  CB  ARG A  15      21.484  14.108  16.106  1.00 15.46           C  
ATOM    125  CG  ARG A  15      20.460  13.117  15.466  1.00 15.08           C  
ATOM    126  CD  ARG A  15      20.510  11.786  16.176  1.00 13.65           C  
ATOM    127  NE  ARG A  15      19.898  10.750  15.374  1.00 15.77           N  
ATOM    128  CZ  ARG A  15      19.787   9.482  15.746  1.00 14.94           C  
ATOM    129  NH1 ARG A  15      20.178   9.113  16.968  1.00 13.23           N  
ATOM    130  NH2 ARG A  15      19.233   8.610  14.902  1.00 14.92           N  
ATOM    131  N   GLY A  16      23.090  15.813  13.895  1.00 13.70           N  
ATOM    132  CA  GLY A  16      23.040  16.436  12.561  1.00 14.43           C  
ATOM    133  C   GLY A  16      24.155  15.977  11.630  1.00 13.95           C  
ATOM    134  O   GLY A  16      24.065  16.177  10.414  1.00 15.81           O  
ATOM    135  N   SER A  17      25.212  15.395  12.187  1.00 13.54           N  
ATOM    136  CA  SER A  17      26.277  14.800  11.360  1.00 13.47           C  
ATOM    137  C   SER A  17      25.850  13.533  10.624  1.00 14.73           C  
ATOM    138  O   SER A  17      26.498  13.168   9.644  1.00 16.39           O  
ATOM    139  CB  SER A  17      27.534  14.491  12.178  1.00 15.22           C  
ATOM    140  OG  SER A  17      28.115  15.670  12.677  1.00 20.41           O  
ATOM    141  N   PHE A  18      24.787  12.865  11.075  1.00 11.13           N  
ATOM    142  CA  PHE A  18      24.491  11.515  10.572  1.00 12.97           C  
ATOM    143  C   PHE A  18      23.489  11.482   9.448  1.00 13.35           C  
ATOM    144  O   PHE A  18      22.644  10.595   9.345  1.00 15.49           O  
ATOM    145  CB  PHE A  18      24.153  10.546  11.719  1.00 11.81           C  
ATOM    146  CG  PHE A  18      25.146  10.617  12.846  1.00 13.17           C  
ATOM    147  CD1 PHE A  18      26.496  10.373  12.612  1.00 11.60           C  
ATOM    148  CD2 PHE A  18      24.742  10.969  14.134  1.00 15.55           C  
ATOM    149  CE1 PHE A  18      27.434  10.432  13.622  1.00 11.75           C  
ATOM    150  CE2 PHE A  18      25.662  11.061  15.161  1.00 14.59           C  
ATOM    151  CZ  PHE A  18      27.010  10.801  14.930  1.00 13.28           C  
ATOM    152  N   GLN A  19      23.622  12.465   8.571  1.00 15.35           N  
ATOM    153  CA  GLN A  19      22.810  12.554   7.372  1.00 16.61           C  
ATOM    154  C   GLN A  19      23.631  13.245   6.280  1.00 17.82           C  
ATOM    155  O   GLN A  19      24.671  13.854   6.577  1.00 17.67           O  
ATOM    156  CB  GLN A  19      21.539  13.345   7.660  1.00 16.57           C  
ATOM    157  CG  GLN A  19      21.808  14.771   8.057  1.00 20.94           C  
ATOM    158  CD  GLN A  19      20.552  15.477   8.512  1.00 30.03           C  
ATOM    159  OE1 GLN A  19      19.995  16.300   7.785  1.00 32.31           O  
ATOM    160  NE2 GLN A  19      20.081  15.144   9.709  1.00 30.11           N  
ATOM    161  N   PRO A  20      23.194  13.120   5.009  1.00 18.05           N  
ATOM    162  CA  PRO A  20      23.905  13.796   3.930  1.00 19.23           C  
ATOM    163  C   PRO A  20      23.909  15.320   4.147  1.00 21.20           C  
ATOM    164  O   PRO A  20      22.940  15.866   4.709  1.00 22.24           O  
ATOM    165  CB  PRO A  20      23.096  13.417   2.676  1.00 19.11           C  
ATOM    166  CG  PRO A  20      22.342  12.181   3.041  1.00 14.87           C  
ATOM    167  CD  PRO A  20      22.031  12.359   4.512  1.00 18.82           C  
ATOM    168  N   PRO A  21      24.984  16.012   3.709  1.00 23.19           N  
ATOM    169  CA  PRO A  21      26.122  15.479   2.950  1.00 23.75           C  
ATOM    170  C   PRO A  21      27.261  14.939   3.827  1.00 25.05           C  
ATOM    171  O   PRO A  21      28.120  14.216   3.329  1.00 27.17           O  
ATOM    172  CB  PRO A  21      26.602  16.697   2.148  1.00 23.31           C  
ATOM    173  CG  PRO A  21      26.183  17.894   2.973  1.00 24.01           C  
ATOM    174  CD  PRO A  21      25.124  17.464   3.958  1.00 23.85           C  
ATOM    175  N   VAL A  22      27.238  15.265   5.119  1.00 24.52           N  
ATOM    176  CA  VAL A  22      28.287  14.893   6.069  1.00 24.19           C  
ATOM    177  C   VAL A  22      28.346  13.358   6.312  1.00 21.34           C  
ATOM    178  O   VAL A  22      29.382  12.720   6.103  1.00 20.79           O  
ATOM    179  CB  VAL A  22      28.117  15.698   7.411  1.00 24.96           C  
ATOM    180  CG1 VAL A  22      29.120  15.267   8.469  1.00 28.32           C  
ATOM    181  CG2 VAL A  22      28.252  17.197   7.151  1.00 26.72           C  
ATOM    182  N   CYS A  23      27.214  12.794   6.731  1.00 19.73           N  
ATOM    183  CA  CYS A  23      27.030  11.359   7.013  1.00 17.65           C  
ATOM    184  C   CYS A  23      27.860  10.775   8.143  1.00 16.64           C  
ATOM    185  O   CYS A  23      27.373   9.938   8.882  1.00 16.15           O  
ATOM    186  CB  CYS A  23      27.214  10.487   5.779  1.00 18.26           C  
ATOM    187  SG  CYS A  23      25.774  10.507   4.706  1.00 22.66           S  
ATOM    188  N   ASN A  24      29.115  11.179   8.274  1.00 16.32           N  
ATOM    189  CA  ASN A  24      29.939  10.573   9.308  1.00 17.38           C  
ATOM    190  C   ASN A  24      30.609  11.575  10.231  1.00 16.12           C  
ATOM    191  O   ASN A  24      30.724  12.764   9.894  1.00 17.37           O  
ATOM    192  CB  ASN A  24      30.984   9.674   8.682  1.00 19.59           C  
ATOM    193  CG  ASN A  24      32.019  10.447   7.916  1.00 28.16           C  
ATOM    194  OD1 ASN A  24      32.901  11.078   8.508  1.00 39.43           O  
ATOM    195  ND2 ASN A  24      31.935  10.401   6.592  1.00 31.21           N  
ATOM    196  N   LYS A  25      31.033  11.094  11.398  1.00 13.85           N  
ATOM    197  CA  LYS A  25      31.797  11.921  12.326  1.00 13.65           C  
ATOM    198  C   LYS A  25      32.753  11.066  13.148  1.00 12.88           C  
ATOM    199  O   LYS A  25      32.334  10.062  13.757  1.00 11.02           O  
ATOM    200  CB  LYS A  25      30.882  12.716  13.268  1.00 14.24           C  
ATOM    201  CG  LYS A  25      31.719  13.665  14.151  1.00 18.74           C  
ATOM    202  CD  LYS A  25      30.920  14.752  14.814  1.00 21.25           C  
ATOM    203  CE  LYS A  25      31.828  15.608  15.704  1.00 25.45           C  
ATOM    204  NZ  LYS A  25      32.581  16.590  14.879  1.00 28.33           N  
ATOM    205  N   LEU A  26      34.025  11.458  13.186  1.00 12.28           N  
ATOM    206  CA  LEU A  26      35.000  10.768  14.010  1.00 11.72           C  
ATOM    207  C   LEU A  26      34.825  11.162  15.465  1.00 12.82           C  
ATOM    208  O   LEU A  26      34.775  12.368  15.792  1.00 15.20           O  
ATOM    209  CB  LEU A  26      36.415  11.094  13.558  1.00 12.64           C  
ATOM    210  CG  LEU A  26      36.851  10.363  12.282  1.00 17.00           C  
ATOM    211  CD1 LEU A  26      37.870  11.251  11.563  1.00 21.17           C  
ATOM    212  CD2 LEU A  26      37.432   9.040  12.647  1.00 20.81           C  
HETATM  213  N   MSE A  27      34.698  10.152  16.319  1.00 10.43           N  
HETATM  214  CA  MSE A  27      34.753  10.401  17.769  1.00 11.32           C  
HETATM  215  C   MSE A  27      36.207  10.523  18.238  1.00 13.50           C  
HETATM  216  O   MSE A  27      36.553  11.427  19.014  1.00 13.55           O  
HETATM  217  CB  MSE A  27      34.052   9.276  18.524  1.00 11.30           C  
HETATM  218  CG  MSE A  27      34.107   9.482  20.049  1.00 10.88           C  
HETATM  219 SE   MSE A  27      33.442   7.907  20.984  1.00 10.66          SE  
HETATM  220  CE  MSE A  27      31.619   8.427  21.324  1.00 13.89           C  
ATOM    221  N   HIS A  28      37.056   9.620  17.758  1.00 11.99           N  
ATOM    222  CA  HIS A  28      38.479   9.636  18.054  1.00 11.10           C  
ATOM    223  C   HIS A  28      39.249   9.378  16.765  1.00 13.31           C  
ATOM    224  O   HIS A  28      38.819   8.559  15.942  1.00 12.49           O  
ATOM    225  CB  HIS A  28      38.838   8.564  19.052  1.00 12.46           C  
ATOM    226  CG  HIS A  28      38.136   8.708  20.362  1.00 11.04           C  
ATOM    227  ND1 HIS A  28      38.378   9.764  21.218  1.00 13.97           N  
ATOM    228  CD2 HIS A  28      37.192   7.938  20.948  1.00 15.36           C  
ATOM    229  CE1 HIS A  28      37.603   9.626  22.289  1.00 12.13           C  
ATOM    230  NE2 HIS A  28      36.881   8.527  22.145  1.00 13.55           N  
ATOM    231  N   GLN A  29      40.356  10.093  16.582  1.00 13.15           N  
ATOM    232  CA  GLN A  29      41.160   9.946  15.346  1.00 14.82           C  
ATOM    233  C   GLN A  29      42.623   9.923  15.774  1.00 17.12           C  
ATOM    234  O   GLN A  29      43.336  10.920  15.641  1.00 19.77           O  
ATOM    235  CB  GLN A  29      40.871  11.124  14.416  1.00 16.05           C  
ATOM    236  CG  GLN A  29      41.641  11.134  13.082  1.00 21.73           C  
ATOM    237  CD  GLN A  29      41.338  12.368  12.226  1.00 20.52           C  
ATOM    238  OE1 GLN A  29      40.950  13.425  12.741  1.00 26.93           O  
ATOM    239  NE2 GLN A  29      41.503  12.230  10.906  1.00 24.53           N  
ATOM    240  N   GLU A  30      43.055   8.816  16.352  1.00 14.91           N  
ATOM    241  CA  GLU A  30      44.407   8.697  16.874  1.00 16.07           C  
ATOM    242  C   GLU A  30      44.973   7.418  16.292  1.00 15.06           C  
ATOM    243  O   GLU A  30      44.871   7.197  15.072  1.00 13.45           O  
ATOM    244  CB  GLU A  30      44.386   8.677  18.422  1.00 18.19           C  
ATOM    245  CG  GLU A  30      43.674   9.903  19.050  1.00 22.57           C  
ATOM    246  CD  GLU A  30      44.418  11.204  18.767  1.00 21.82           C  
ATOM    247  OE1 GLU A  30      45.650  11.160  18.535  1.00 25.41           O  
ATOM    248  OE2 GLU A  30      43.776  12.289  18.785  1.00 23.92           O  
ATOM    249  N   GLN A  31      45.570   6.552  17.109  1.00 12.83           N  
ATOM    250  CA  GLN A  31      45.976   5.248  16.566  1.00 13.95           C  
ATOM    251  C   GLN A  31      44.752   4.384  16.203  1.00 13.25           C  
ATOM    252  O   GLN A  31      44.770   3.648  15.209  1.00 14.09           O  
ATOM    253  CB  GLN A  31      46.955   4.504  17.492  1.00 13.75           C  
ATOM    254  CG  GLN A  31      47.541   3.231  16.879  1.00 15.34           C  
ATOM    255  CD  GLN A  31      46.657   1.990  17.065  1.00 16.26           C  
ATOM    256  OE1 GLN A  31      45.897   1.877  18.053  1.00 15.62           O  
ATOM    257  NE2 GLN A  31      46.765   1.036  16.138  1.00 14.57           N  
ATOM    258  N   LEU A  32      43.698   4.474  17.024  1.00 12.50           N  
ATOM    259  CA  LEU A  32      42.376   3.942  16.669  1.00 11.74           C  
ATOM    260  C   LEU A  32      41.526   5.067  16.069  1.00 12.90           C  
ATOM    261  O   LEU A  32      41.524   6.207  16.565  1.00 15.76           O  
ATOM    262  CB  LEU A  32      41.668   3.350  17.885  1.00 14.23           C  
ATOM    263  CG  LEU A  32      42.100   1.950  18.287  1.00 16.84           C  
ATOM    264  CD1 LEU A  32      41.314   1.568  19.571  1.00 17.54           C  
ATOM    265  CD2 LEU A  32      41.792   0.896  17.193  1.00 13.71           C  
ATOM    266  N   LYS A  33      40.791   4.734  15.006  1.00 11.74           N  
ATOM    267  CA  LYS A  33      39.820   5.645  14.407  1.00 11.57           C  
ATOM    268  C   LYS A  33      38.443   5.122  14.804  1.00 12.47           C  
ATOM    269  O   LYS A  33      38.059   4.012  14.415  1.00 13.01           O  
ATOM    270  CB  LYS A  33      39.957   5.645  12.870  1.00 11.81           C  
ATOM    271  CG  LYS A  33      41.378   5.710  12.332  1.00 11.41           C  
ATOM    272  CD  LYS A  33      42.106   6.975  12.764  1.00 13.28           C  
ATOM    273  CE  LYS A  33      43.527   6.984  12.179  1.00 13.25           C  
ATOM    274  NZ  LYS A  33      44.247   8.266  12.484  1.00 13.99           N  
ATOM    275  N   VAL A  34      37.749   5.867  15.675  1.00 11.18           N  
ATOM    276  CA  VAL A  34      36.460   5.425  16.178  1.00 11.36           C  
ATOM    277  C   VAL A  34      35.461   6.392  15.562  1.00 11.88           C  
ATOM    278  O   VAL A  34      35.484   7.604  15.868  1.00 12.22           O  
ATOM    279  CB  VAL A  34      36.405   5.530  17.719  1.00 12.50           C  
ATOM    280  CG1 VAL A  34      35.004   5.125  18.195  1.00 11.37           C  
ATOM    281  CG2 VAL A  34      37.500   4.667  18.335  1.00 13.92           C  
HETATM  282  N   MSE A  35      34.587   5.884  14.709  0.60 10.97           N  
HETATM  284  CA  MSE A  35      33.713   6.779  13.978  0.60 11.33           C  
HETATM  286  C   MSE A  35      32.275   6.285  13.909  0.60 11.51           C  
HETATM  288  O   MSE A  35      32.004   5.077  13.990  0.60 10.59           O  
HETATM  290  CB  MSE A  35      34.240   6.964  12.576  0.60 12.64           C  
HETATM  292  CG  MSE A  35      33.984   5.780  11.731  0.60 10.21           C  
HETATM  294 SE   MSE A  35      34.936   6.018  10.094  0.60 15.02          SE  
HETATM  296  CE  MSE A  35      33.746   7.280   9.272  0.60  2.51           C  
ATOM    298  N   PHE A  36      31.366   7.238  13.768  1.00 10.24           N  
ATOM    299  CA  PHE A  36      29.945   6.944  13.706  1.00  9.29           C  
ATOM    300  C   PHE A  36      29.400   7.445  12.391  1.00 12.27           C  
ATOM    301  O   PHE A  36      29.789   8.510  11.935  1.00 11.37           O  
ATOM    302  CB  PHE A  36      29.198   7.573  14.896  1.00 11.04           C  
ATOM    303  CG  PHE A  36      29.518   6.896  16.196  1.00  9.43           C  
ATOM    304  CD1 PHE A  36      28.651   5.904  16.718  1.00 12.18           C  
ATOM    305  CD2 PHE A  36      30.718   7.163  16.859  1.00 10.73           C  
ATOM    306  CE1 PHE A  36      28.971   5.243  17.929  1.00 13.42           C  
ATOM    307  CE2 PHE A  36      31.040   6.533  18.055  1.00 11.66           C  
ATOM    308  CZ  PHE A  36      30.177   5.554  18.597  1.00 11.47           C  
ATOM    309  N   ILE A  37      28.493   6.675  11.782  1.00 14.32           N  
ATOM    310  CA  ILE A  37      28.100   6.954  10.395  1.00 15.66           C  
ATOM    311  C   ILE A  37      26.602   6.778  10.225  1.00 15.77           C  
ATOM    312  O   ILE A  37      26.035   5.803  10.693  1.00 15.63           O  
ATOM    313  CB  ILE A  37      28.833   6.030   9.397  1.00 15.96           C  
ATOM    314  CG1 ILE A  37      30.345   5.956   9.707  1.00 15.97           C  
ATOM    315  CG2 ILE A  37      28.607   6.525   7.959  1.00 16.25           C  
ATOM    316  CD1 ILE A  37      31.148   4.898   8.892  1.00 19.15           C  
ATOM    317  N   GLY A  38      25.982   7.713   9.516  1.00 15.81           N  
ATOM    318  CA  GLY A  38      24.549   7.638   9.286  1.00 16.37           C  
ATOM    319  C   GLY A  38      24.314   7.407   7.811  1.00 19.58           C  
ATOM    320  O   GLY A  38      25.164   6.846   7.116  1.00 20.39           O  
ATOM    321  N   GLY A  39      23.153   7.816   7.347  1.00 18.24           N  
ATOM    322  CA  GLY A  39      22.758   7.633   5.959  1.00 17.21           C  
ATOM    323  C   GLY A  39      21.640   8.602   5.603  1.00 16.34           C  
ATOM    324  O   GLY A  39      21.301   9.500   6.385  1.00 15.91           O  
ATOM    325  N   PRO A  40      21.030   8.422   4.423  1.00 16.41           N  
ATOM    326  CA  PRO A  40      21.381   7.378   3.462  1.00 15.72           C  
ATOM    327  C   PRO A  40      22.686   7.682   2.739  1.00 16.88           C  
ATOM    328  O   PRO A  40      23.018   8.842   2.490  1.00 18.41           O  
ATOM    329  CB  PRO A  40      20.228   7.417   2.466  1.00 16.98           C  
ATOM    330  CG  PRO A  40      19.810   8.826   2.466  1.00 15.05           C  
ATOM    331  CD  PRO A  40      19.919   9.250   3.938  1.00 14.28           C  
ATOM    332  N   ASN A  41      23.380   6.619   2.381  1.00 16.36           N  
ATOM    333  CA  ASN A  41      24.611   6.724   1.623  1.00 18.75           C  
ATOM    334  C   ASN A  41      24.806   5.405   0.922  1.00 18.47           C  
ATOM    335  O   ASN A  41      25.267   4.451   1.512  1.00 20.32           O  
ATOM    336  CB  ASN A  41      25.790   7.018   2.544  1.00 20.74           C  
ATOM    337  CG  ASN A  41      27.088   7.265   1.777  1.00 24.25           C  
ATOM    338  OD1 ASN A  41      28.092   6.670   2.076  1.00 28.53           O  
ATOM    339  ND2 ASN A  41      27.047   8.140   0.774  1.00 32.64           N  
ATOM    340  N   THR A  42      24.447   5.373  -0.347  1.00 18.89           N  
ATOM    341  CA  THR A  42      24.660   4.165  -1.125  1.00 18.41           C  
ATOM    342  C   THR A  42      25.661   4.512  -2.216  1.00 19.23           C  
ATOM    343  O   THR A  42      25.724   5.655  -2.689  1.00 20.55           O  
ATOM    344  CB  THR A  42      23.348   3.582  -1.661  1.00 21.79           C  
ATOM    345  OG1 THR A  42      22.720   4.560  -2.476  1.00 19.62           O  
ATOM    346  CG2 THR A  42      22.381   3.212  -0.492  1.00 22.72           C  
ATOM    347  N   ARG A  43      26.448   3.513  -2.588  1.00 16.85           N  
ATOM    348  CA  ARG A  43      27.624   3.758  -3.394  1.00 17.60           C  
ATOM    349  C   ARG A  43      28.095   2.492  -4.080  1.00 15.65           C  
ATOM    350  O   ARG A  43      27.741   1.388  -3.671  1.00 15.63           O  
ATOM    351  CB  ARG A  43      28.742   4.281  -2.489  1.00 16.35           C  
ATOM    352  CG  ARG A  43      29.215   3.307  -1.416  1.00 16.90           C  
ATOM    353  CD  ARG A  43      29.631   4.116  -0.200  1.00 22.67           C  
ATOM    354  NE  ARG A  43      30.945   4.703  -0.439  1.00 27.59           N  
ATOM    355  CZ  ARG A  43      31.409   5.792   0.163  1.00 38.01           C  
ATOM    356  NH1 ARG A  43      32.629   6.235  -0.122  1.00 33.97           N  
ATOM    357  NH2 ARG A  43      30.650   6.451   1.038  1.00 36.60           N  
ATOM    358  N   LYS A  44      28.910   2.668  -5.125  1.00 14.14           N  
ATOM    359  CA  LYS A  44      29.441   1.546  -5.874  1.00 14.55           C  
ATOM    360  C   LYS A  44      30.943   1.323  -5.655  1.00 15.63           C  
ATOM    361  O   LYS A  44      31.500   0.349  -6.176  1.00 16.33           O  
ATOM    362  CB  LYS A  44      29.148   1.717  -7.387  1.00 13.65           C  
ATOM    363  CG  LYS A  44      27.672   1.763  -7.781  1.00 18.89           C  
ATOM    364  CD  LYS A  44      27.024   0.406  -7.638  1.00 28.09           C  
ATOM    365  CE  LYS A  44      25.708   0.365  -8.416  1.00 38.88           C  
ATOM    366  NZ  LYS A  44      24.923  -0.857  -8.073  1.00 46.89           N  
ATOM    367  N   ASP A  45      31.605   2.196  -4.878  1.00 14.04           N  
ATOM    368  CA  ASP A  45      33.044   2.039  -4.661  1.00 14.54           C  
ATOM    369  C   ASP A  45      33.332   1.007  -3.591  1.00 14.35           C  
ATOM    370  O   ASP A  45      32.635   0.958  -2.556  1.00 14.86           O  
ATOM    371  CB  ASP A  45      33.713   3.382  -4.273  1.00 15.21           C  
ATOM    372  CG  ASP A  45      33.043   4.074  -3.095  1.00 15.15           C  
ATOM    373  OD1 ASP A  45      31.891   4.480  -3.268  1.00 15.96           O  
ATOM    374  OD2 ASP A  45      33.707   4.247  -2.043  1.00 17.36           O  
ATOM    375  N   TYR A  46      34.399   0.247  -3.823  1.00 13.24           N  
ATOM    376  CA  TYR A  46      34.882  -0.755  -2.892  1.00 13.48           C  
ATOM    377  C   TYR A  46      36.202  -0.297  -2.313  1.00 14.43           C  
ATOM    378  O   TYR A  46      37.182  -0.008  -3.031  1.00 15.56           O  
ATOM    379  CB  TYR A  46      35.074  -2.115  -3.578  1.00 14.99           C  
ATOM    380  CG  TYR A  46      33.758  -2.821  -3.859  1.00 14.26           C  
ATOM    381  CD1 TYR A  46      33.332  -3.861  -3.054  1.00 13.49           C  
ATOM    382  CD2 TYR A  46      32.942  -2.416  -4.927  1.00 16.64           C  
ATOM    383  CE1 TYR A  46      32.125  -4.511  -3.302  1.00 14.34           C  
ATOM    384  CE2 TYR A  46      31.714  -3.053  -5.187  1.00 17.18           C  
ATOM    385  CZ  TYR A  46      31.321  -4.109  -4.373  1.00 16.09           C  
ATOM    386  OH  TYR A  46      30.101  -4.731  -4.618  1.00 16.36           O  
ATOM    387  N   HIS A  47      36.239  -0.244  -1.001  1.00 13.78           N  
ATOM    388  CA  HIS A  47      37.439   0.134  -0.271  1.00 13.99           C  
ATOM    389  C   HIS A  47      38.247  -1.139   0.016  1.00 15.02           C  
ATOM    390  O   HIS A  47      37.681  -2.229   0.285  1.00 13.68           O  
ATOM    391  CB  HIS A  47      36.995   0.809   1.034  1.00 14.55           C  
ATOM    392  CG  HIS A  47      38.134   1.236   1.916  1.00 16.80           C  
ATOM    393  ND1 HIS A  47      38.096   1.116   3.294  1.00 14.18           N  
ATOM    394  CD2 HIS A  47      39.336   1.782   1.613  1.00 15.94           C  
ATOM    395  CE1 HIS A  47      39.230   1.580   3.798  1.00 15.79           C  
ATOM    396  NE2 HIS A  47      40.005   1.980   2.799  1.00 15.82           N  
ATOM    397  N   ILE A  48      39.564  -1.021  -0.041  1.00 14.65           N  
ATOM    398  CA  ILE A  48      40.440  -2.144   0.293  1.00 15.01           C  
ATOM    399  C   ILE A  48      41.551  -1.612   1.186  1.00 14.96           C  
ATOM    400  O   ILE A  48      42.160  -0.606   0.854  1.00 14.84           O  
ATOM    401  CB  ILE A  48      41.089  -2.816  -0.975  1.00 14.02           C  
ATOM    402  CG1 ILE A  48      40.047  -3.013  -2.074  1.00 17.02           C  
ATOM    403  CG2 ILE A  48      41.793  -4.145  -0.559  1.00 18.76           C  
ATOM    404  CD1 ILE A  48      40.629  -3.549  -3.420  1.00 17.39           C  
ATOM    405  N   GLU A  49      41.818  -2.286   2.314  1.00 15.03           N  
ATOM    406  CA  GLU A  49      42.918  -1.851   3.170  1.00 14.05           C  
ATOM    407  C   GLU A  49      43.590  -3.030   3.850  1.00 13.82           C  
ATOM    408  O   GLU A  49      43.079  -4.174   3.810  1.00 15.34           O  
ATOM    409  CB  GLU A  49      42.447  -0.833   4.219  1.00 13.52           C  
ATOM    410  CG  GLU A  49      41.322  -1.349   5.170  1.00 14.85           C  
ATOM    411  CD  GLU A  49      41.467  -0.829   6.606  1.00 15.98           C  
ATOM    412  OE1 GLU A  49      42.592  -0.880   7.148  1.00 15.98           O  
ATOM    413  OE2 GLU A  49      40.439  -0.423   7.199  1.00 14.78           O  
ATOM    414  N   GLU A  50      44.736  -2.757   4.474  1.00 15.02           N  
ATOM    415  CA  GLU A  50      45.552  -3.808   5.072  1.00 16.16           C  
ATOM    416  C   GLU A  50      45.240  -4.027   6.562  1.00 14.20           C  
ATOM    417  O   GLU A  50      45.730  -5.004   7.149  1.00 16.25           O  
ATOM    418  CB  GLU A  50      47.039  -3.505   4.874  1.00 16.23           C  
ATOM    419  CG  GLU A  50      47.432  -3.537   3.391  1.00 15.62           C  
ATOM    420  CD  GLU A  50      48.929  -3.446   3.121  1.00 19.33           C  
ATOM    421  OE1 GLU A  50      49.706  -4.270   3.647  1.00 22.16           O  
ATOM    422  OE2 GLU A  50      49.331  -2.550   2.338  1.00 24.84           O  
ATOM    423  N   GLY A  51      44.466  -3.107   7.145  1.00 14.81           N  
ATOM    424  CA  GLY A  51      43.912  -3.348   8.479  1.00 14.47           C  
ATOM    425  C   GLY A  51      42.507  -3.949   8.395  1.00 15.72           C  
ATOM    426  O   GLY A  51      41.943  -4.123   7.290  1.00 16.48           O  
ATOM    427  N   GLU A  52      41.913  -4.232   9.566  1.00 13.97           N  
ATOM    428  CA  GLU A  52      40.537  -4.728   9.671  1.00 15.52           C  
ATOM    429  C   GLU A  52      39.567  -3.621  10.045  1.00 15.13           C  
ATOM    430  O   GLU A  52      39.973  -2.541  10.473  1.00 16.00           O  
ATOM    431  CB  GLU A  52      40.467  -5.802  10.739  1.00 15.49           C  
ATOM    432  CG  GLU A  52      41.402  -7.031  10.431  1.00 15.85           C  
ATOM    433  CD  GLU A  52      41.463  -8.069  11.533  1.00 16.45           C  
ATOM    434  OE1 GLU A  52      41.046  -7.772  12.672  1.00 17.11           O  
ATOM    435  OE2 GLU A  52      41.936  -9.201  11.256  1.00 16.08           O  
ATOM    436  N   GLU A  53      38.273  -3.897   9.880  1.00 14.55           N  
ATOM    437  CA  GLU A  53      37.211  -2.930  10.232  1.00 14.99           C  
ATOM    438  C   GLU A  53      36.166  -3.613  11.089  1.00 14.58           C  
ATOM    439  O   GLU A  53      35.652  -4.667  10.707  1.00 15.61           O  
ATOM    440  CB  GLU A  53      36.613  -2.310   8.970  1.00 14.84           C  
ATOM    441  CG  GLU A  53      37.747  -1.610   8.192  1.00 14.15           C  
ATOM    442  CD  GLU A  53      37.264  -0.823   6.936  1.00 14.84           C  
ATOM    443  OE1 GLU A  53      36.061  -0.455   6.718  1.00 15.26           O  
ATOM    444  OE2 GLU A  53      38.171  -0.543   6.088  1.00 16.52           O  
ATOM    445  N   VAL A  54      35.870  -3.005  12.267  1.00 15.08           N  
ATOM    446  CA  VAL A  54      34.797  -3.475  13.127  1.00 15.96           C  
ATOM    447  C   VAL A  54      33.544  -2.663  12.819  1.00 15.86           C  
ATOM    448  O   VAL A  54      33.617  -1.438  12.742  1.00 15.64           O  
ATOM    449  CB  VAL A  54      35.142  -3.188  14.615  1.00 16.77           C  
ATOM    450  CG1 VAL A  54      33.978  -3.646  15.515  1.00 20.87           C  
ATOM    451  CG2 VAL A  54      36.443  -3.864  15.032  1.00 18.51           C  
ATOM    452  N   PHE A  55      32.398  -3.346  12.656  1.00 15.98           N  
ATOM    453  CA  PHE A  55      31.127  -2.682  12.396  1.00 15.60           C  
ATOM    454  C   PHE A  55      30.151  -3.057  13.505  1.00 15.04           C  
ATOM    455  O   PHE A  55      30.012  -4.248  13.831  1.00 16.69           O  
ATOM    456  CB  PHE A  55      30.505  -3.143  11.057  1.00 15.62           C  
ATOM    457  CG  PHE A  55      31.332  -2.761   9.825  1.00 13.22           C  
ATOM    458  CD1 PHE A  55      30.941  -1.692   9.037  1.00 15.74           C  
ATOM    459  CD2 PHE A  55      32.470  -3.512   9.468  1.00 15.26           C  
ATOM    460  CE1 PHE A  55      31.679  -1.342   7.870  1.00 17.52           C  
ATOM    461  CE2 PHE A  55      33.233  -3.168   8.340  1.00 14.71           C  
ATOM    462  CZ  PHE A  55      32.836  -2.081   7.541  1.00 16.75           C  
ATOM    463  N   TYR A  56      29.430  -2.072  14.057  1.00 13.82           N  
ATOM    464  CA  TYR A  56      28.374  -2.398  14.991  1.00 14.24           C  
ATOM    465  C   TYR A  56      27.231  -1.427  14.681  1.00 14.93           C  
ATOM    466  O   TYR A  56      27.437  -0.211  14.631  1.00 15.72           O  
ATOM    467  CB  TYR A  56      28.839  -2.225  16.457  1.00 14.24           C  
ATOM    468  CG  TYR A  56      27.694  -2.274  17.442  1.00 14.01           C  
ATOM    469  CD1 TYR A  56      27.042  -3.460  17.710  1.00 13.74           C  
ATOM    470  CD2 TYR A  56      27.197  -1.101  18.026  1.00 15.79           C  
ATOM    471  CE1 TYR A  56      25.952  -3.504  18.586  1.00 15.22           C  
ATOM    472  CE2 TYR A  56      26.098  -1.119  18.903  1.00 20.43           C  
ATOM    473  CZ  TYR A  56      25.481  -2.333  19.161  1.00 18.82           C  
ATOM    474  OH  TYR A  56      24.407  -2.392  20.012  1.00 20.03           O  
ATOM    475  N   GLN A  57      26.018  -1.950  14.508  1.00 13.48           N  
ATOM    476  CA  GLN A  57      24.885  -1.088  14.215  1.00 12.87           C  
ATOM    477  C   GLN A  57      24.171  -0.666  15.492  1.00 13.12           C  
ATOM    478  O   GLN A  57      23.477  -1.456  16.123  1.00 15.07           O  
ATOM    479  CB  GLN A  57      23.883  -1.739  13.236  1.00 14.02           C  
ATOM    480  CG  GLN A  57      24.422  -1.717  11.804  1.00 13.17           C  
ATOM    481  CD  GLN A  57      24.693  -0.289  11.309  1.00 13.24           C  
ATOM    482  OE1 GLN A  57      25.841   0.100  11.080  1.00 14.94           O  
ATOM    483  NE2 GLN A  57      23.626   0.516  11.225  1.00 12.92           N  
ATOM    484  N   LEU A  58      24.310   0.610  15.838  1.00 14.13           N  
ATOM    485  CA  LEU A  58      23.607   1.140  17.015  1.00 15.44           C  
ATOM    486  C   LEU A  58      22.118   1.326  16.747  1.00 15.03           C  
ATOM    487  O   LEU A  58      21.288   0.993  17.594  1.00 14.99           O  
ATOM    488  CB  LEU A  58      24.242   2.462  17.443  1.00 16.26           C  
ATOM    489  CG  LEU A  58      23.863   3.099  18.779  1.00 25.89           C  
ATOM    490  CD1 LEU A  58      24.110   2.138  19.972  1.00 25.91           C  
ATOM    491  CD2 LEU A  58      24.717   4.385  18.932  1.00 26.57           C  
ATOM    492  N   GLU A  59      21.784   1.885  15.578  1.00 14.84           N  
ATOM    493  CA  GLU A  59      20.389   2.135  15.154  1.00 14.31           C  
ATOM    494  C   GLU A  59      20.234   1.695  13.701  1.00 14.11           C  
ATOM    495  O   GLU A  59      20.994   2.127  12.822  1.00 13.88           O  
ATOM    496  CB  GLU A  59      20.025   3.626  15.228  1.00 15.61           C  
ATOM    497  CG  GLU A  59      20.320   4.249  16.587  1.00 13.54           C  
ATOM    498  CD  GLU A  59      19.822   5.682  16.707  1.00 16.91           C  
ATOM    499  OE1 GLU A  59      18.932   6.072  15.926  1.00 17.54           O  
ATOM    500  OE2 GLU A  59      20.347   6.389  17.611  1.00 17.97           O  
ATOM    501  N   GLY A  60      19.248   0.834  13.477  1.00 13.64           N  
ATOM    502  CA  GLY A  60      18.894   0.403  12.129  1.00 12.40           C  
ATOM    503  C   GLY A  60      19.933  -0.514  11.506  1.00 12.94           C  
ATOM    504  O   GLY A  60      20.990  -0.840  12.085  1.00 14.47           O  
ATOM    505  N   ASP A  61      19.588  -0.949  10.294  1.00 13.36           N  
ATOM    506  CA  ASP A  61      20.371  -1.959   9.586  1.00 12.55           C  
ATOM    507  C   ASP A  61      21.230  -1.300   8.509  1.00 13.68           C  
ATOM    508  O   ASP A  61      20.934  -0.182   8.073  1.00 15.92           O  
ATOM    509  CB  ASP A  61      19.432  -2.943   8.877  1.00 12.56           C  
ATOM    510  CG  ASP A  61      18.399  -3.599   9.810  1.00 15.38           C  
ATOM    511  OD1 ASP A  61      18.582  -3.627  11.056  1.00 16.17           O  
ATOM    512  OD2 ASP A  61      17.394  -4.092   9.285  1.00 18.07           O  
HETATM  513  N   MSE A  62      22.263  -2.011   8.078  0.80 12.89           N  
HETATM  515  CA  MSE A  62      23.040  -1.598   6.896  0.80 12.89           C  
HETATM  517  C   MSE A  62      23.321  -2.839   6.056  0.80 13.34           C  
HETATM  519  O   MSE A  62      23.061  -3.969   6.478  0.80 12.53           O  
HETATM  521  CB  MSE A  62      24.379  -0.963   7.320  0.80 12.26           C  
HETATM  523  CG  MSE A  62      25.339  -1.956   7.932  0.80 14.34           C  
HETATM  525 SE   MSE A  62      27.130  -1.203   8.215  0.80 12.28          SE  
HETATM  527  CE  MSE A  62      27.697  -1.086   6.342  0.80 13.45           C  
ATOM    529  N   VAL A  63      23.908  -2.621   4.870  1.00 13.90           N  
ATOM    530  CA  VAL A  63      24.348  -3.728   4.022  1.00 14.70           C  
ATOM    531  C   VAL A  63      25.810  -3.465   3.661  1.00 13.93           C  
ATOM    532  O   VAL A  63      26.128  -2.414   3.085  1.00 16.57           O  
ATOM    533  CB  VAL A  63      23.481  -3.889   2.752  1.00 14.88           C  
ATOM    534  CG1 VAL A  63      24.073  -4.985   1.856  1.00 16.15           C  
ATOM    535  CG2 VAL A  63      22.035  -4.246   3.109  1.00 15.43           C  
ATOM    536  N   LEU A  64      26.689  -4.399   4.002  1.00 13.86           N  
ATOM    537  CA  LEU A  64      28.095  -4.269   3.600  1.00 13.46           C  
ATOM    538  C   LEU A  64      28.271  -5.195   2.409  1.00 14.64           C  
ATOM    539  O   LEU A  64      28.219  -6.420   2.562  1.00 15.02           O  
ATOM    540  CB  LEU A  64      29.037  -4.646   4.750  1.00 14.97           C  
ATOM    541  CG  LEU A  64      30.515  -4.427   4.438  1.00 16.32           C  
ATOM    542  CD1 LEU A  64      30.887  -2.917   4.360  1.00 16.44           C  
ATOM    543  CD2 LEU A  64      31.319  -5.146   5.525  1.00 17.02           C  
ATOM    544  N   ARG A  65      28.430  -4.625   1.207  1.00 13.05           N  
ATOM    545  CA  ARG A  65      28.687  -5.470   0.026  1.00 13.52           C  
ATOM    546  C   ARG A  65      30.184  -5.823   0.071  1.00 15.03           C  
ATOM    547  O   ARG A  65      31.025  -4.944   0.290  1.00 18.13           O  
ATOM    548  CB  ARG A  65      28.338  -4.714  -1.252  1.00 15.34           C  
ATOM    549  CG  ARG A  65      26.953  -4.069  -1.255  1.00 17.91           C  
ATOM    550  CD  ARG A  65      26.507  -3.866  -2.719  1.00 22.35           C  
ATOM    551  NE  ARG A  65      25.361  -2.982  -2.866  1.00 29.88           N  
ATOM    552  CZ  ARG A  65      24.089  -3.338  -2.679  1.00 38.55           C  
ATOM    553  NH1 ARG A  65      23.129  -2.434  -2.847  1.00 37.17           N  
ATOM    554  NH2 ARG A  65      23.765  -4.583  -2.323  1.00 35.71           N  
ATOM    555  N   VAL A  66      30.523  -7.100  -0.074  1.00 13.93           N  
ATOM    556  CA  VAL A  66      31.922  -7.526  -0.057  1.00 13.82           C  
ATOM    557  C   VAL A  66      32.238  -8.350  -1.306  1.00 13.69           C  
ATOM    558  O   VAL A  66      31.329  -8.883  -1.977  1.00 14.47           O  
ATOM    559  CB  VAL A  66      32.282  -8.359   1.230  1.00 14.39           C  
ATOM    560  CG1 VAL A  66      31.976  -7.536   2.496  1.00 16.21           C  
ATOM    561  CG2 VAL A  66      31.502  -9.664   1.268  1.00 12.90           C  
ATOM    562  N   LEU A  67      33.536  -8.402  -1.628  1.00 12.37           N  
ATOM    563  CA  LEU A  67      34.005  -9.407  -2.591  1.00 13.08           C  
ATOM    564  C   LEU A  67      34.686 -10.500  -1.772  1.00 15.54           C  
ATOM    565  O   LEU A  67      35.773 -10.287  -1.216  1.00 16.29           O  
ATOM    566  CB  LEU A  67      34.928  -8.769  -3.652  1.00 14.22           C  
ATOM    567  CG  LEU A  67      34.264  -7.555  -4.339  1.00 17.54           C  
ATOM    568  CD1 LEU A  67      35.199  -7.063  -5.414  1.00 20.62           C  
ATOM    569  CD2 LEU A  67      32.906  -7.872  -4.969  1.00 19.91           C  
ATOM    570  N   GLU A  68      33.981 -11.632  -1.665  1.00 14.35           N  
ATOM    571  CA  GLU A  68      34.419 -12.747  -0.837  1.00 13.28           C  
ATOM    572  C   GLU A  68      34.772 -13.918  -1.741  1.00 14.10           C  
ATOM    573  O   GLU A  68      33.911 -14.442  -2.455  1.00 13.32           O  
ATOM    574  CB  GLU A  68      33.275 -13.159   0.093  1.00 14.44           C  
ATOM    575  CG  GLU A  68      33.568 -14.439   0.871  1.00 15.68           C  
ATOM    576  CD  GLU A  68      32.345 -14.970   1.571  1.00 18.05           C  
ATOM    577  OE1 GLU A  68      31.293 -15.147   0.912  1.00 22.32           O  
ATOM    578  OE2 GLU A  68      32.446 -15.289   2.762  1.00 17.94           O  
ATOM    579  N   GLN A  69      36.046 -14.316  -1.713  1.00 12.99           N  
ATOM    580  CA  GLN A  69      36.509 -15.484  -2.480  1.00 13.17           C  
ATOM    581  C   GLN A  69      36.065 -15.424  -3.955  1.00 14.42           C  
ATOM    582  O   GLN A  69      35.601 -16.418  -4.530  1.00 15.48           O  
ATOM    583  CB  GLN A  69      36.038 -16.777  -1.821  1.00 12.17           C  
ATOM    584  CG  GLN A  69      36.635 -16.915  -0.418  1.00 12.45           C  
ATOM    585  CD  GLN A  69      36.134 -18.081   0.379  1.00 13.60           C  
ATOM    586  OE1 GLN A  69      34.975 -18.522   0.264  1.00 17.13           O  
ATOM    587  NE2 GLN A  69      37.021 -18.615   1.214  1.00 12.82           N  
ATOM    588  N   GLY A  70      36.204 -14.235  -4.538  1.00 15.33           N  
ATOM    589  CA  GLY A  70      35.981 -14.059  -5.977  1.00 15.06           C  
ATOM    590  C   GLY A  70      34.539 -13.872  -6.410  1.00 15.15           C  
ATOM    591  O   GLY A  70      34.256 -13.908  -7.604  1.00 18.10           O  
ATOM    592  N   LYS A  71      33.634 -13.638  -5.446  1.00 15.77           N  
ATOM    593  CA  LYS A  71      32.195 -13.420  -5.697  1.00 17.91           C  
ATOM    594  C   LYS A  71      31.683 -12.214  -4.916  1.00 16.46           C  
ATOM    595  O   LYS A  71      32.165 -11.937  -3.809  1.00 16.20           O  
ATOM    596  CB  LYS A  71      31.354 -14.616  -5.214  1.00 19.33           C  
ATOM    597  CG  LYS A  71      31.526 -15.913  -5.961  1.00 26.65           C  
ATOM    598  CD  LYS A  71      30.775 -17.046  -5.223  1.00 24.58           C  
ATOM    599  CE  LYS A  71      29.252 -16.839  -5.147  1.00 35.82           C  
ATOM    600  NZ  LYS A  71      28.528 -17.505  -6.281  1.00 41.12           N  
ATOM    601  N   HIS A  72      30.661 -11.558  -5.473  1.00 16.51           N  
ATOM    602  CA  HIS A  72      29.902 -10.521  -4.774  1.00 16.28           C  
ATOM    603  C   HIS A  72      29.003 -11.169  -3.723  1.00 16.85           C  
ATOM    604  O   HIS A  72      28.336 -12.177  -3.974  1.00 18.78           O  
ATOM    605  CB  HIS A  72      29.022  -9.730  -5.773  1.00 17.12           C  
ATOM    606  CG  HIS A  72      29.790  -8.786  -6.659  1.00 22.14           C  
ATOM    607  ND1 HIS A  72      29.756  -7.418  -6.494  1.00 25.74           N  
ATOM    608  CD2 HIS A  72      30.593  -9.013  -7.729  1.00 24.31           C  
ATOM    609  CE1 HIS A  72      30.510  -6.842  -7.417  1.00 28.18           C  
ATOM    610  NE2 HIS A  72      31.033  -7.789  -8.178  1.00 24.03           N  
ATOM    611  N   ARG A  73      29.015 -10.612  -2.523  1.00 14.79           N  
ATOM    612  CA  ARG A  73      28.107 -11.072  -1.506  1.00 16.77           C  
ATOM    613  C   ARG A  73      27.649  -9.886  -0.659  1.00 16.67           C  
ATOM    614  O   ARG A  73      28.453  -8.975  -0.354  1.00 16.30           O  
ATOM    615  CB  ARG A  73      28.768 -12.136  -0.630  1.00 18.33           C  
ATOM    616  CG  ARG A  73      27.775 -12.679   0.398  1.00 27.88           C  
ATOM    617  CD  ARG A  73      27.954 -14.164   0.722  1.00 30.48           C  
ATOM    618  NE  ARG A  73      28.962 -14.328   1.759  1.00 28.51           N  
ATOM    619  CZ  ARG A  73      28.801 -13.993   3.038  1.00 32.26           C  
ATOM    620  NH1 ARG A  73      29.806 -14.180   3.888  1.00 29.81           N  
ATOM    621  NH2 ARG A  73      27.646 -13.486   3.466  1.00 31.08           N  
ATOM    622  N   ASP A  74      26.357  -9.873  -0.317  1.00 15.42           N  
ATOM    623  CA  ASP A  74      25.850  -8.816   0.567  1.00 15.73           C  
ATOM    624  C   ASP A  74      25.778  -9.316   2.002  1.00 16.60           C  
ATOM    625  O   ASP A  74      25.107 -10.332   2.274  1.00 18.12           O  
ATOM    626  CB  ASP A  74      24.450  -8.383   0.142  1.00 15.12           C  
ATOM    627  CG  ASP A  74      24.448  -7.585  -1.148  1.00 19.61           C  
ATOM    628  OD1 ASP A  74      25.523  -7.041  -1.498  1.00 20.32           O  
ATOM    629  OD2 ASP A  74      23.373  -7.503  -1.777  1.00 25.86           O  
ATOM    630  N   VAL A  75      26.403  -8.570   2.909  1.00 14.76           N  
ATOM    631  CA  VAL A  75      26.390  -8.880   4.340  1.00 16.40           C  
ATOM    632  C   VAL A  75      25.435  -7.879   5.015  1.00 15.93           C  
ATOM    633  O   VAL A  75      25.761  -6.694   5.160  1.00 16.37           O  
ATOM    634  CB  VAL A  75      27.807  -8.767   4.958  1.00 16.72           C  
ATOM    635  CG1 VAL A  75      27.746  -9.087   6.470  1.00 20.55           C  
ATOM    636  CG2 VAL A  75      28.787  -9.732   4.252  1.00 19.22           C  
ATOM    637  N   VAL A  76      24.261  -8.364   5.411  1.00 15.80           N  
ATOM    638  CA  VAL A  76      23.305  -7.520   6.126  1.00 14.53           C  
ATOM    639  C   VAL A  76      23.765  -7.475   7.590  1.00 15.53           C  
ATOM    640  O   VAL A  76      23.961  -8.519   8.211  1.00 16.53           O  
ATOM    641  CB  VAL A  76      21.872  -8.062   6.028  1.00 13.76           C  
ATOM    642  CG1 VAL A  76      20.914  -7.172   6.822  1.00 16.40           C  
ATOM    643  CG2 VAL A  76      21.411  -8.144   4.563  1.00 16.25           C  
ATOM    644  N   ILE A  77      23.953  -6.267   8.112  1.00 13.92           N  
ATOM    645  CA  ILE A  77      24.282  -6.092   9.531  1.00 14.14           C  
ATOM    646  C   ILE A  77      23.093  -5.348  10.157  1.00 13.50           C  
ATOM    647  O   ILE A  77      22.836  -4.153   9.891  1.00 14.58           O  
ATOM    648  CB  ILE A  77      25.609  -5.334   9.752  1.00 13.59           C  
ATOM    649  CG1 ILE A  77      26.757  -6.018   8.983  1.00 14.51           C  
ATOM    650  CG2 ILE A  77      25.933  -5.205  11.277  1.00 15.00           C  
ATOM    651  CD1 ILE A  77      27.979  -5.166   8.792  1.00 17.57           C  
ATOM    652  N   ARG A  78      22.352  -6.075  10.988  1.00 13.78           N  
ATOM    653  CA  ARG A  78      21.115  -5.542  11.562  1.00 13.82           C  
ATOM    654  C   ARG A  78      21.430  -4.751  12.836  1.00 13.11           C  
ATOM    655  O   ARG A  78      22.500  -4.932  13.454  1.00 14.05           O  
ATOM    656  CB  ARG A  78      20.138  -6.679  11.882  1.00 14.03           C  
ATOM    657  CG  ARG A  78      19.765  -7.458  10.628  1.00 17.26           C  
ATOM    658  CD  ARG A  78      18.505  -8.288  10.751  1.00 27.23           C  
ATOM    659  NE  ARG A  78      17.847  -8.381   9.444  1.00 40.23           N  
ATOM    660  CZ  ARG A  78      18.218  -9.192   8.456  1.00 42.97           C  
ATOM    661  NH1 ARG A  78      19.258 -10.020   8.603  1.00 42.85           N  
ATOM    662  NH2 ARG A  78      17.541  -9.173   7.313  1.00 44.44           N  
ATOM    663  N   GLN A  79      20.468  -3.901  13.220  1.00 14.49           N  
ATOM    664  CA  GLN A  79      20.574  -3.164  14.483  1.00 15.26           C  
ATOM    665  C   GLN A  79      20.961  -4.153  15.577  1.00 14.53           C  
ATOM    666  O   GLN A  79      20.337  -5.233  15.698  1.00 15.02           O  
ATOM    667  CB  GLN A  79      19.253  -2.474  14.828  1.00 14.78           C  
ATOM    668  CG  GLN A  79      19.369  -1.710  16.152  1.00 15.30           C  
ATOM    669  CD  GLN A  79      18.177  -0.837  16.430  1.00 19.25           C  
ATOM    670  OE1 GLN A  79      17.674  -0.137  15.554  1.00 16.06           O  
ATOM    671  NE2 GLN A  79      17.685  -0.888  17.683  1.00 23.05           N  
ATOM    672  N   GLY A  80      21.982  -3.785  16.351  1.00 13.90           N  
ATOM    673  CA  GLY A  80      22.442  -4.588  17.496  1.00 14.96           C  
ATOM    674  C   GLY A  80      23.423  -5.682  17.139  1.00 14.77           C  
ATOM    675  O   GLY A  80      23.934  -6.387  18.021  1.00 15.00           O  
ATOM    676  N   GLU A  81      23.735  -5.804  15.840  1.00 12.91           N  
ATOM    677  CA  GLU A  81      24.723  -6.815  15.431  1.00 12.62           C  
ATOM    678  C   GLU A  81      26.127  -6.225  15.282  1.00 14.22           C  
ATOM    679  O   GLU A  81      26.292  -5.049  14.891  1.00 14.27           O  
ATOM    680  CB  GLU A  81      24.295  -7.487  14.113  1.00 13.38           C  
ATOM    681  CG  GLU A  81      22.979  -8.232  14.272  1.00 12.63           C  
ATOM    682  CD  GLU A  81      22.560  -9.052  13.047  1.00 13.54           C  
ATOM    683  OE1 GLU A  81      23.032  -8.760  11.916  1.00 15.39           O  
ATOM    684  OE2 GLU A  81      21.699  -9.971  13.248  1.00 18.00           O  
ATOM    685  N   ILE A  82      27.119  -7.078  15.547  1.00 13.52           N  
ATOM    686  CA  ILE A  82      28.529  -6.689  15.436  1.00 15.34           C  
ATOM    687  C   ILE A  82      29.181  -7.638  14.419  1.00 14.90           C  
ATOM    688  O   ILE A  82      28.751  -8.784  14.250  1.00 14.37           O  
ATOM    689  CB  ILE A  82      29.257  -6.718  16.827  1.00 15.76           C  
ATOM    690  CG1 ILE A  82      30.655  -6.116  16.729  1.00 16.57           C  
ATOM    691  CG2 ILE A  82      29.270  -8.153  17.433  1.00 15.50           C  
ATOM    692  CD1 ILE A  82      31.272  -5.775  18.129  1.00 18.69           C  
ATOM    693  N   PHE A  83      30.153  -7.102  13.700  1.00 15.60           N  
ATOM    694  CA  PHE A  83      30.749  -7.827  12.570  1.00 16.15           C  
ATOM    695  C   PHE A  83      32.171  -7.350  12.417  1.00 15.18           C  
ATOM    696  O   PHE A  83      32.456  -6.169  12.587  1.00 16.34           O  
ATOM    697  CB  PHE A  83      29.939  -7.526  11.311  1.00 15.68           C  
ATOM    698  CG  PHE A  83      30.594  -7.991  10.045  1.00 15.90           C  
ATOM    699  CD1 PHE A  83      30.534  -9.325   9.660  1.00 14.29           C  
ATOM    700  CD2 PHE A  83      31.299  -7.086   9.257  1.00 18.16           C  
ATOM    701  CE1 PHE A  83      31.171  -9.764   8.488  1.00 15.95           C  
ATOM    702  CE2 PHE A  83      31.930  -7.509   8.075  1.00 16.07           C  
ATOM    703  CZ  PHE A  83      31.855  -8.833   7.699  1.00 16.42           C  
ATOM    704  N   LEU A  84      33.079  -8.277  12.128  1.00 13.68           N  
ATOM    705  CA  LEU A  84      34.477  -7.932  11.920  1.00 13.82           C  
ATOM    706  C   LEU A  84      34.906  -8.331  10.513  1.00 14.37           C  
ATOM    707  O   LEU A  84      34.750  -9.496  10.123  1.00 14.97           O  
ATOM    708  CB  LEU A  84      35.387  -8.603  12.981  1.00 14.82           C  
ATOM    709  CG  LEU A  84      36.904  -8.408  12.832  1.00 15.83           C  
ATOM    710  CD1 LEU A  84      37.316  -6.923  12.895  1.00 17.98           C  
ATOM    711  CD2 LEU A  84      37.660  -9.190  13.909  1.00 15.57           C  
ATOM    712  N   LEU A  85      35.437  -7.345   9.781  1.00 14.55           N  
ATOM    713  CA  LEU A  85      35.898  -7.587   8.415  1.00 15.69           C  
ATOM    714  C   LEU A  85      37.420  -7.851   8.458  1.00 15.99           C  
ATOM    715  O   LEU A  85      38.172  -7.028   8.955  1.00 17.03           O  
ATOM    716  CB  LEU A  85      35.613  -6.343   7.547  1.00 14.64           C  
ATOM    717  CG  LEU A  85      35.901  -6.637   6.054  1.00 15.34           C  
ATOM    718  CD1 LEU A  85      34.781  -7.510   5.461  1.00 16.65           C  
ATOM    719  CD2 LEU A  85      36.003  -5.306   5.304  1.00 17.76           C  
ATOM    720  N   PRO A  86      37.878  -8.963   7.871  1.00 15.76           N  
ATOM    721  CA  PRO A  86      39.316  -9.210   7.865  1.00 16.01           C  
ATOM    722  C   PRO A  86      40.050  -8.258   6.894  1.00 14.76           C  
ATOM    723  O   PRO A  86      39.418  -7.570   6.072  1.00 14.87           O  
ATOM    724  CB  PRO A  86      39.439 -10.670   7.349  1.00 17.80           C  
ATOM    725  CG  PRO A  86      38.130 -11.038   6.814  1.00 18.34           C  
ATOM    726  CD  PRO A  86      37.093 -10.022   7.200  1.00 17.42           C  
ATOM    727  N   ALA A  87      41.376  -8.254   6.999  1.00 15.13           N  
ATOM    728  CA  ALA A  87      42.197  -7.407   6.147  1.00 15.86           C  
ATOM    729  C   ALA A  87      42.016  -7.776   4.658  1.00 15.28           C  
ATOM    730  O   ALA A  87      41.846  -8.973   4.314  1.00 14.79           O  
ATOM    731  CB  ALA A  87      43.643  -7.594   6.535  1.00 17.62           C  
ATOM    732  N   ARG A  88      42.058  -6.746   3.815  1.00 13.88           N  
ATOM    733  CA  ARG A  88      42.239  -6.912   2.367  1.00 14.57           C  
ATOM    734  C   ARG A  88      41.023  -7.519   1.663  1.00 14.65           C  
ATOM    735  O   ARG A  88      41.128  -8.047   0.556  1.00 13.88           O  
ATOM    736  CB  ARG A  88      43.533  -7.697   2.091  1.00 15.57           C  
ATOM    737  CG  ARG A  88      44.808  -6.959   2.597  1.00 15.79           C  
ATOM    738  CD  ARG A  88      46.084  -7.845   2.436  1.00 14.93           C  
ATOM    739  NE  ARG A  88      46.108  -8.796   3.535  1.00 15.50           N  
ATOM    740  CZ  ARG A  88      45.835 -10.084   3.399  1.00 18.45           C  
ATOM    741  NH1 ARG A  88      45.549 -10.567   2.187  1.00 20.48           N  
ATOM    742  NH2 ARG A  88      45.869 -10.886   4.461  1.00 20.35           N  
ATOM    743  N   VAL A  89      39.860  -7.422   2.314  1.00 14.71           N  
ATOM    744  CA  VAL A  89      38.575  -7.743   1.650  1.00 14.10           C  
ATOM    745  C   VAL A  89      37.983  -6.457   1.046  1.00 15.05           C  
ATOM    746  O   VAL A  89      37.733  -5.502   1.779  1.00 14.61           O  
ATOM    747  CB  VAL A  89      37.562  -8.312   2.692  1.00 12.86           C  
ATOM    748  CG1 VAL A  89      36.218  -8.595   1.985  1.00 14.56           C  
ATOM    749  CG2 VAL A  89      38.083  -9.606   3.321  1.00 16.98           C  
ATOM    750  N   PRO A  90      37.761  -6.411  -0.282  1.00 13.92           N  
ATOM    751  CA  PRO A  90      37.087  -5.246  -0.851  1.00 14.38           C  
ATOM    752  C   PRO A  90      35.667  -5.126  -0.261  1.00 14.73           C  
ATOM    753  O   PRO A  90      34.937  -6.140  -0.188  1.00 14.74           O  
ATOM    754  CB  PRO A  90      37.064  -5.552  -2.371  1.00 15.32           C  
ATOM    755  CG  PRO A  90      38.208  -6.591  -2.572  1.00 11.77           C  
ATOM    756  CD  PRO A  90      38.114  -7.423  -1.316  1.00 13.33           C  
ATOM    757  N   HIS A  91      35.278  -3.915   0.162  1.00 13.38           N  
ATOM    758  CA  HIS A  91      33.955  -3.748   0.789  1.00 13.20           C  
ATOM    759  C   HIS A  91      33.321  -2.429   0.416  1.00 12.77           C  
ATOM    760  O   HIS A  91      34.024  -1.397   0.278  1.00 14.53           O  
ATOM    761  CB  HIS A  91      34.097  -3.876   2.308  1.00 15.21           C  
ATOM    762  CG  HIS A  91      35.129  -2.947   2.894  1.00 15.44           C  
ATOM    763  ND1 HIS A  91      36.489  -3.204   2.837  1.00 14.52           N  
ATOM    764  CD2 HIS A  91      34.997  -1.739   3.511  1.00 16.35           C  
ATOM    765  CE1 HIS A  91      37.150  -2.202   3.407  1.00 15.29           C  
ATOM    766  NE2 HIS A  91      36.268  -1.302   3.823  1.00 14.87           N  
ATOM    767  N   SER A  92      31.988  -2.431   0.281  1.00 12.96           N  
ATOM    768  CA  SER A  92      31.254  -1.235  -0.167  1.00 13.21           C  
ATOM    769  C   SER A  92      30.025  -1.054   0.761  1.00 13.74           C  
ATOM    770  O   SER A  92      29.025  -1.750   0.609  1.00 13.79           O  
ATOM    771  CB  SER A  92      30.818  -1.389  -1.632  1.00 13.94           C  
ATOM    772  OG  SER A  92      30.152  -0.223  -2.086  1.00 12.72           O  
ATOM    773  N   PRO A  93      30.154  -0.181   1.771  1.00 15.21           N  
ATOM    774  CA  PRO A  93      29.064  -0.026   2.767  1.00 13.41           C  
ATOM    775  C   PRO A  93      27.876   0.727   2.195  1.00 14.25           C  
ATOM    776  O   PRO A  93      28.038   1.763   1.547  1.00 14.10           O  
ATOM    777  CB  PRO A  93      29.706   0.809   3.887  1.00 15.98           C  
ATOM    778  CG  PRO A  93      30.849   1.545   3.227  1.00 18.17           C  
ATOM    779  CD  PRO A  93      31.336   0.648   2.079  1.00 15.84           C  
ATOM    780  N   GLN A  94      26.673   0.194   2.456  1.00 12.95           N  
ATOM    781  CA  GLN A  94      25.426   0.809   2.030  1.00 13.58           C  
ATOM    782  C   GLN A  94      24.655   1.150   3.282  1.00 13.86           C  
ATOM    783  O   GLN A  94      24.388   0.264   4.098  1.00 14.70           O  
ATOM    784  CB  GLN A  94      24.572  -0.142   1.192  1.00 13.98           C  
ATOM    785  CG  GLN A  94      25.384  -0.858   0.090  1.00 14.80           C  
ATOM    786  CD  GLN A  94      25.979   0.103  -0.935  1.00 12.96           C  
ATOM    787  OE1 GLN A  94      25.306   0.995  -1.427  1.00 15.46           O  
ATOM    788  NE2 GLN A  94      27.245  -0.128  -1.285  1.00 13.23           N  
ATOM    789  N   ARG A  95      24.321   2.429   3.427  1.00 12.70           N  
ATOM    790  CA  ARG A  95      23.639   2.896   4.643  1.00 13.92           C  
ATOM    791  C   ARG A  95      22.341   3.586   4.312  1.00 14.15           C  
ATOM    792  O   ARG A  95      22.191   4.206   3.249  1.00 16.49           O  
ATOM    793  CB  ARG A  95      24.535   3.825   5.449  1.00 13.83           C  
ATOM    794  CG  ARG A  95      25.744   3.032   6.020  1.00 14.59           C  
ATOM    795  CD  ARG A  95      26.690   3.893   6.862  1.00 16.10           C  
ATOM    796  NE  ARG A  95      27.835   3.109   7.311  1.00 15.81           N  
ATOM    797  CZ  ARG A  95      27.832   2.306   8.381  1.00 14.78           C  
ATOM    798  NH1 ARG A  95      26.708   2.215   9.114  1.00 14.45           N  
ATOM    799  NH2 ARG A  95      28.928   1.644   8.712  1.00 15.49           N  
ATOM    800  N   PHE A  96      21.398   3.491   5.245  1.00 14.57           N  
ATOM    801  CA  PHE A  96      20.047   4.000   5.035  1.00 15.66           C  
ATOM    802  C   PHE A  96      19.725   5.174   5.940  1.00 14.41           C  
ATOM    803  O   PHE A  96      20.448   5.467   6.894  1.00 12.86           O  
ATOM    804  CB  PHE A  96      19.023   2.853   5.138  1.00 15.39           C  
ATOM    805  CG  PHE A  96      19.423   1.665   4.308  1.00 20.65           C  
ATOM    806  CD1 PHE A  96      19.314   1.711   2.923  1.00 25.36           C  
ATOM    807  CD2 PHE A  96      19.968   0.530   4.897  1.00 21.80           C  
ATOM    808  CE1 PHE A  96      19.736   0.630   2.133  1.00 25.45           C  
ATOM    809  CE2 PHE A  96      20.385  -0.550   4.122  1.00 24.35           C  
ATOM    810  CZ  PHE A  96      20.269  -0.495   2.738  1.00 25.68           C  
ATOM    811  N   ALA A  97      18.654   5.867   5.601  1.00 14.56           N  
ATOM    812  CA  ALA A  97      18.214   7.007   6.377  1.00 13.92           C  
ATOM    813  C   ALA A  97      17.942   6.612   7.829  1.00 14.61           C  
ATOM    814  O   ALA A  97      17.486   5.483   8.113  1.00 14.38           O  
ATOM    815  CB  ALA A  97      16.962   7.621   5.763  1.00 12.38           C  
ATOM    816  N   ASN A  98      18.221   7.549   8.731  1.00 14.24           N  
ATOM    817  CA  ASN A  98      17.852   7.396  10.151  1.00 14.50           C  
ATOM    818  C   ASN A  98      18.497   6.175  10.795  1.00 15.89           C  
ATOM    819  O   ASN A  98      17.870   5.487  11.611  1.00 18.67           O  
ATOM    820  CB  ASN A  98      16.329   7.370  10.285  1.00 14.73           C  
ATOM    821  CG  ASN A  98      15.700   8.683   9.833  1.00 18.40           C  
ATOM    822  OD1 ASN A  98      14.846   8.704   8.938  1.00 28.25           O  
ATOM    823  ND2 ASN A  98      16.141   9.791  10.431  1.00 21.32           N  
ATOM    824  N   THR A  99      19.737   5.908  10.392  1.00 13.14           N  
ATOM    825  CA  THR A  99      20.552   4.851  11.003  1.00 12.79           C  
ATOM    826  C   THR A  99      21.824   5.432  11.593  1.00 14.37           C  
ATOM    827  O   THR A  99      22.277   6.496  11.189  1.00 14.20           O  
ATOM    828  CB  THR A  99      20.948   3.712  10.007  1.00 13.60           C  
ATOM    829  OG1 THR A  99      21.796   4.241   8.962  1.00 12.65           O  
ATOM    830  CG2 THR A  99      19.700   3.076   9.378  1.00 13.72           C  
ATOM    831  N   VAL A 100      22.416   4.692  12.537  1.00 13.26           N  
ATOM    832  CA  VAL A 100      23.713   5.076  13.117  1.00 13.62           C  
ATOM    833  C   VAL A 100      24.527   3.815  13.334  1.00 14.62           C  
ATOM    834  O   VAL A 100      24.086   2.873  14.019  1.00 14.06           O  
ATOM    835  CB  VAL A 100      23.533   5.788  14.492  1.00 14.52           C  
ATOM    836  CG1 VAL A 100      24.912   6.192  15.038  1.00 15.76           C  
ATOM    837  CG2 VAL A 100      22.626   7.004  14.391  1.00 16.10           C  
ATOM    838  N   GLY A 101      25.736   3.807  12.747  1.00 13.84           N  
ATOM    839  CA  GLY A 101      26.682   2.703  12.907  1.00 15.41           C  
ATOM    840  C   GLY A 101      28.016   3.166  13.453  1.00 15.39           C  
ATOM    841  O   GLY A 101      28.466   4.273  13.143  1.00 15.85           O  
ATOM    842  N   LEU A 102      28.611   2.322  14.285  1.00 14.11           N  
ATOM    843  CA  LEU A 102      29.988   2.468  14.721  1.00 14.26           C  
ATOM    844  C   LEU A 102      30.884   1.706  13.756  1.00 14.62           C  
ATOM    845  O   LEU A 102      30.552   0.586  13.381  1.00 14.08           O  
ATOM    846  CB  LEU A 102      30.135   1.862  16.127  1.00 13.26           C  
ATOM    847  CG  LEU A 102      31.553   1.575  16.662  1.00 15.31           C  
ATOM    848  CD1 LEU A 102      32.318   2.907  16.911  1.00 15.27           C  
ATOM    849  CD2 LEU A 102      31.506   0.744  17.970  1.00 17.16           C  
ATOM    850  N   VAL A 103      32.019   2.308  13.362  1.00 14.40           N  
ATOM    851  CA  VAL A 103      33.099   1.600  12.687  1.00 14.15           C  
ATOM    852  C   VAL A 103      34.389   1.926  13.427  1.00 14.35           C  
ATOM    853  O   VAL A 103      34.630   3.092  13.831  1.00 15.74           O  
ATOM    854  CB  VAL A 103      33.206   1.991  11.194  1.00 14.91           C  
ATOM    855  CG1 VAL A 103      34.401   1.295  10.504  1.00 17.56           C  
ATOM    856  CG2 VAL A 103      31.871   1.646  10.489  1.00 15.10           C  
ATOM    857  N   VAL A 104      35.185   0.890  13.657  1.00 13.71           N  
ATOM    858  CA  VAL A 104      36.514   1.087  14.212  1.00 15.08           C  
ATOM    859  C   VAL A 104      37.523   0.560  13.225  1.00 15.44           C  
ATOM    860  O   VAL A 104      37.377  -0.565  12.720  1.00 15.93           O  
ATOM    861  CB  VAL A 104      36.708   0.401  15.590  1.00 16.13           C  
ATOM    862  CG1 VAL A 104      38.125   0.694  16.144  1.00 16.66           C  
ATOM    863  CG2 VAL A 104      35.643   0.872  16.583  1.00 18.99           C  
ATOM    864  N   GLU A 105      38.549   1.360  12.930  1.00  9.33           N  
ATOM    865  CA  GLU A 105      39.690   0.907  12.149  1.00  9.72           C  
ATOM    866  C   GLU A 105      40.926   1.642  12.686  1.00 11.44           C  
ATOM    867  O   GLU A 105      40.791   2.366  13.694  1.00 12.38           O  
ATOM    868  CB  GLU A 105      39.468   1.147  10.643  1.00 10.89           C  
ATOM    869  CG  GLU A 105      39.321   2.600  10.214  1.00 13.79           C  
ATOM    870  CD  GLU A 105      38.986   2.695   8.737  1.00 12.97           C  
ATOM    871  OE1 GLU A 105      37.841   2.403   8.345  1.00 14.68           O  
ATOM    872  OE2 GLU A 105      39.911   3.039   7.995  1.00 16.46           O  
ATOM    873  N   ARG A 106      42.099   1.429  12.102  1.00 10.24           N  
ATOM    874  CA  ARG A 106      43.313   1.898  12.767  1.00 10.12           C  
ATOM    875  C   ARG A 106      44.164   2.738  11.836  1.00 10.27           C  
ATOM    876  O   ARG A 106      44.073   2.659  10.610  1.00 10.35           O  
ATOM    877  CB  ARG A 106      44.155   0.743  13.334  1.00 11.30           C  
ATOM    878  CG  ARG A 106      44.749  -0.204  12.261  1.00 11.62           C  
ATOM    879  CD  ARG A 106      45.956  -0.925  12.850  1.00 12.62           C  
ATOM    880  NE  ARG A 106      46.358  -2.094  12.054  1.00 14.37           N  
ATOM    881  CZ  ARG A 106      47.025  -2.017  10.915  1.00 17.20           C  
ATOM    882  NH1 ARG A 106      47.441  -0.820  10.451  1.00 14.56           N  
ATOM    883  NH2 ARG A 106      47.330  -3.152  10.272  1.00 13.58           N  
ATOM    884  N   ARG A 107      45.027   3.537  12.450  1.00 10.44           N  
ATOM    885  CA  ARG A 107      46.054   4.247  11.689  1.00  9.34           C  
ATOM    886  C   ARG A 107      46.850   3.233  10.872  1.00 11.18           C  
ATOM    887  O   ARG A 107      47.186   2.149  11.385  1.00 10.96           O  
ATOM    888  CB  ARG A 107      46.984   4.965  12.667  1.00 11.55           C  
ATOM    889  CG  ARG A 107      48.159   5.702  12.022  1.00 10.68           C  
ATOM    890  CD  ARG A 107      49.081   6.217  13.108  1.00 11.00           C  
ATOM    891  NE  ARG A 107      48.479   7.347  13.777  1.00 14.43           N  
ATOM    892  CZ  ARG A 107      48.564   7.576  15.084  1.00 14.10           C  
ATOM    893  NH1 ARG A 107      49.259   6.754  15.887  1.00 11.42           N  
ATOM    894  NH2 ARG A 107      47.974   8.671  15.575  1.00 15.65           N  
ATOM    895  N   ARG A 108      47.130   3.582   9.622  1.00 11.14           N  
ATOM    896  CA  ARG A 108      47.913   2.696   8.769  1.00 12.52           C  
ATOM    897  C   ARG A 108      49.419   2.771   9.089  1.00 12.90           C  
ATOM    898  O   ARG A 108      49.969   3.828   9.439  1.00 12.92           O  
ATOM    899  CB  ARG A 108      47.703   3.071   7.316  1.00 11.48           C  
ATOM    900  CG  ARG A 108      46.240   3.173   6.870  1.00 12.71           C  
ATOM    901  CD  ARG A 108      45.430   1.889   7.058  1.00 15.21           C  
ATOM    902  NE  ARG A 108      44.158   2.035   6.340  1.00 14.04           N  
ATOM    903  CZ  ARG A 108      42.938   2.212   6.866  1.00 16.13           C  
ATOM    904  NH1 ARG A 108      42.717   2.218   8.200  1.00 14.79           N  
ATOM    905  NH2 ARG A 108      41.885   2.384   6.051  1.00 14.56           N  
ATOM    906  N   LEU A 109      50.108   1.649   8.896  1.00 11.63           N  
ATOM    907  CA  LEU A 109      51.559   1.653   8.888  1.00 13.38           C  
ATOM    908  C   LEU A 109      52.062   2.426   7.662  1.00 13.39           C  
ATOM    909  O   LEU A 109      51.346   2.524   6.659  1.00 13.19           O  
ATOM    910  CB  LEU A 109      52.112   0.232   8.876  1.00 13.76           C  
ATOM    911  CG  LEU A 109      51.656  -0.700   9.995  1.00 17.27           C  
ATOM    912  CD1 LEU A 109      52.223  -2.101   9.793  1.00 17.10           C  
ATOM    913  CD2 LEU A 109      52.084  -0.169  11.371  1.00 15.91           C  
ATOM    914  N   GLU A 110      53.277   2.976   7.746  1.00 16.41           N  
ATOM    915  CA  GLU A 110      53.822   3.746   6.632  1.00 18.03           C  
ATOM    916  C   GLU A 110      53.917   2.922   5.340  1.00 18.02           C  
ATOM    917  O   GLU A 110      53.917   3.476   4.241  1.00 19.08           O  
ATOM    918  CB  GLU A 110      55.198   4.299   6.989  1.00 20.07           C  
ATOM    919  CG  GLU A 110      55.130   5.445   7.966  1.00 31.23           C  
ATOM    920  CD  GLU A 110      56.487   6.063   8.200  1.00 39.00           C  
ATOM    921  OE1 GLU A 110      56.871   6.205   9.385  1.00 44.22           O  
ATOM    922  OE2 GLU A 110      57.164   6.386   7.195  1.00 44.10           O  
ATOM    923  N   THR A 111      53.997   1.599   5.502  1.00 17.41           N  
ATOM    924  CA  THR A 111      54.121   0.657   4.379  1.00 18.37           C  
ATOM    925  C   THR A 111      52.778   0.214   3.791  1.00 16.91           C  
ATOM    926  O   THR A 111      52.740  -0.374   2.711  1.00 18.61           O  
ATOM    927  CB  THR A 111      54.905  -0.610   4.821  1.00 18.89           C  
ATOM    928  OG1 THR A 111      54.294  -1.160   5.998  1.00 23.77           O  
ATOM    929  CG2 THR A 111      56.353  -0.264   5.149  1.00 24.90           C  
ATOM    930  N   GLU A 112      51.678   0.506   4.480  1.00 13.38           N  
ATOM    931  CA  GLU A 112      50.369   0.014   4.064  1.00 13.64           C  
ATOM    932  C   GLU A 112      49.669   0.902   3.060  1.00 14.41           C  
ATOM    933  O   GLU A 112      49.670   2.128   3.193  1.00 15.11           O  
ATOM    934  CB  GLU A 112      49.448  -0.157   5.279  1.00 13.05           C  
ATOM    935  CG  GLU A 112      49.870  -1.346   6.106  1.00 13.71           C  
ATOM    936  CD  GLU A 112      49.099  -1.529   7.400  1.00 13.00           C  
ATOM    937  OE1 GLU A 112      48.565  -0.542   7.961  1.00 14.47           O  
ATOM    938  OE2 GLU A 112      49.048  -2.686   7.892  1.00 14.95           O  
ATOM    939  N   LEU A 113      49.072   0.286   2.046  1.00 14.49           N  
ATOM    940  CA  LEU A 113      48.382   1.021   1.003  1.00 14.28           C  
ATOM    941  C   LEU A 113      46.891   0.705   1.029  1.00 14.03           C  
ATOM    942  O   LEU A 113      46.512  -0.441   1.296  1.00 14.78           O  
ATOM    943  CB  LEU A 113      48.919   0.617  -0.391  1.00 13.56           C  
ATOM    944  CG  LEU A 113      50.203   1.301  -0.837  1.00 16.30           C  
ATOM    945  CD1 LEU A 113      50.795   0.517  -2.011  1.00 22.57           C  
ATOM    946  CD2 LEU A 113      49.925   2.761  -1.255  1.00 20.34           C  
ATOM    947  N   ASP A 114      46.054   1.722   0.774  1.00 12.65           N  
ATOM    948  CA  ASP A 114      44.616   1.581   0.602  1.00 12.95           C  
ATOM    949  C   ASP A 114      44.285   1.645  -0.887  1.00 13.66           C  
ATOM    950  O   ASP A 114      44.997   2.296  -1.653  1.00 12.41           O  
ATOM    951  CB  ASP A 114      43.841   2.716   1.297  1.00 12.12           C  
ATOM    952  CG  ASP A 114      43.676   2.502   2.818  1.00 11.45           C  
ATOM    953  OD1 ASP A 114      44.646   2.087   3.477  1.00 13.94           O  
ATOM    954  OD2 ASP A 114      42.569   2.798   3.299  1.00 12.70           O  
ATOM    955  N   GLY A 115      43.194   0.988  -1.256  1.00 14.34           N  
ATOM    956  CA  GLY A 115      42.687   1.096  -2.601  1.00 13.59           C  
ATOM    957  C   GLY A 115      41.216   1.451  -2.615  1.00 14.19           C  
ATOM    958  O   GLY A 115      40.457   1.203  -1.642  1.00 13.60           O  
ATOM    959  N   LEU A 116      40.792   2.013  -3.738  1.00 14.23           N  
ATOM    960  CA  LEU A 116      39.396   2.294  -3.982  1.00 14.23           C  
ATOM    961  C   LEU A 116      39.159   1.785  -5.396  1.00 14.19           C  
ATOM    962  O   LEU A 116      39.883   2.176  -6.328  1.00 13.69           O  
ATOM    963  CB  LEU A 116      39.078   3.808  -3.860  1.00 14.82           C  
ATOM    964  CG  LEU A 116      37.556   4.067  -3.729  1.00 17.43           C  
ATOM    965  CD1 LEU A 116      37.063   3.591  -2.329  1.00 18.16           C  
ATOM    966  CD2 LEU A 116      37.128   5.492  -4.004  1.00 17.86           C  
ATOM    967  N   ARG A 117      38.195   0.898  -5.539  1.00 14.08           N  
ATOM    968  CA  ARG A 117      37.871   0.264  -6.831  1.00 13.14           C  
ATOM    969  C   ARG A 117      36.402   0.435  -7.190  1.00 13.93           C  
ATOM    970  O   ARG A 117      35.513   0.317  -6.322  1.00 14.83           O  
ATOM    971  CB  ARG A 117      38.170  -1.236  -6.785  1.00 12.95           C  
ATOM    972  CG  ARG A 117      39.645  -1.544  -6.902  1.00 14.05           C  
ATOM    973  CD  ARG A 117      39.867  -3.018  -7.193  1.00 12.23           C  
ATOM    974  NE  ARG A 117      41.261  -3.246  -7.567  1.00 14.97           N  
ATOM    975  CZ  ARG A 117      41.795  -4.446  -7.689  1.00 14.63           C  
ATOM    976  NH1 ARG A 117      41.058  -5.519  -7.418  1.00 16.27           N  
ATOM    977  NH2 ARG A 117      43.066  -4.581  -8.096  1.00 14.22           N  
ATOM    978  N   TYR A 118      36.143   0.643  -8.491  1.00 10.97           N  
ATOM    979  CA  TYR A 118      34.815   0.439  -9.030  1.00 11.63           C  
ATOM    980  C   TYR A 118      34.934  -0.759  -9.968  1.00 12.51           C  
ATOM    981  O   TYR A 118      35.983  -0.930 -10.612  1.00 11.89           O  
ATOM    982  CB  TYR A 118      34.360   1.655  -9.823  1.00 12.53           C  
ATOM    983  CG  TYR A 118      34.157   2.875  -8.938  1.00 11.05           C  
ATOM    984  CD1 TYR A 118      32.871   3.220  -8.476  1.00 10.97           C  
ATOM    985  CD2 TYR A 118      35.238   3.669  -8.592  1.00 12.87           C  
ATOM    986  CE1 TYR A 118      32.693   4.348  -7.649  1.00 12.98           C  
ATOM    987  CE2 TYR A 118      35.074   4.790  -7.773  1.00 13.12           C  
ATOM    988  CZ  TYR A 118      33.813   5.107  -7.319  1.00 10.27           C  
ATOM    989  OH  TYR A 118      33.600   6.230  -6.551  1.00 15.03           O  
ATOM    990  N   TYR A 119      33.873  -1.561  -9.995  1.00 12.56           N  
ATOM    991  CA  TYR A 119      33.789  -2.751 -10.862  1.00 12.47           C  
ATOM    992  C   TYR A 119      32.818  -2.527 -12.004  1.00 15.45           C  
ATOM    993  O   TYR A 119      31.983  -1.624 -11.952  1.00 15.84           O  
ATOM    994  CB  TYR A 119      33.419  -3.972 -10.027  1.00 12.91           C  
ATOM    995  CG  TYR A 119      34.594  -4.447  -9.196  1.00 12.37           C  
ATOM    996  CD1 TYR A 119      35.383  -5.513  -9.628  1.00 14.27           C  
ATOM    997  CD2 TYR A 119      34.959  -3.811  -7.987  1.00 14.08           C  
ATOM    998  CE1 TYR A 119      36.472  -5.977  -8.887  1.00 13.18           C  
ATOM    999  CE2 TYR A 119      36.070  -4.255  -7.251  1.00 16.61           C  
ATOM   1000  CZ  TYR A 119      36.829  -5.340  -7.707  1.00 17.46           C  
ATOM   1001  OH  TYR A 119      37.922  -5.816  -6.994  1.00 19.81           O  
ATOM   1002  N   VAL A 120      32.949  -3.330 -13.067  1.00 14.53           N  
ATOM   1003  CA  VAL A 120      31.992  -3.254 -14.174  1.00 16.93           C  
ATOM   1004  C   VAL A 120      30.676  -3.917 -13.765  1.00 17.98           C  
ATOM   1005  O   VAL A 120      30.602  -5.134 -13.590  1.00 18.88           O  
ATOM   1006  CB  VAL A 120      32.560  -3.909 -15.444  1.00 15.17           C  
ATOM   1007  CG1 VAL A 120      31.522  -3.887 -16.573  1.00 20.48           C  
ATOM   1008  CG2 VAL A 120      33.839  -3.218 -15.860  1.00 16.48           C  
ATOM   1009  N   GLY A 121      29.625  -3.113 -13.618  1.00 20.41           N  
ATOM   1010  CA  GLY A 121      28.329  -3.618 -13.128  1.00 22.23           C  
ATOM   1011  C   GLY A 121      28.498  -4.526 -11.924  1.00 24.38           C  
ATOM   1012  O   GLY A 121      29.183  -4.159 -10.953  1.00 26.50           O  
ATOM   1013  N   ASP A 122      27.898  -5.717 -11.980  1.00 25.58           N  
ATOM   1014  CA  ASP A 122      28.041  -6.705 -10.903  1.00 26.25           C  
ATOM   1015  C   ASP A 122      29.052  -7.810 -11.212  1.00 24.53           C  
ATOM   1016  O   ASP A 122      28.996  -8.913 -10.643  1.00 24.38           O  
ATOM   1017  CB  ASP A 122      26.676  -7.302 -10.540  1.00 29.15           C  
ATOM   1018  CG  ASP A 122      25.921  -6.447  -9.539  1.00 36.70           C  
ATOM   1019  OD1 ASP A 122      26.574  -5.887  -8.619  1.00 41.23           O  
ATOM   1020  OD2 ASP A 122      24.679  -6.344  -9.677  1.00 44.07           O  
ATOM   1021  N   THR A 123      29.983  -7.504 -12.115  1.00 21.61           N  
ATOM   1022  CA  THR A 123      30.996  -8.466 -12.511  1.00 19.05           C  
ATOM   1023  C   THR A 123      32.233  -8.295 -11.639  1.00 16.78           C  
ATOM   1024  O   THR A 123      32.324  -7.356 -10.828  1.00 16.22           O  
ATOM   1025  CB  THR A 123      31.406  -8.312 -14.000  1.00 17.75           C  
ATOM   1026  OG1 THR A 123      32.197  -7.134 -14.153  1.00 15.78           O  
ATOM   1027  CG2 THR A 123      30.187  -8.216 -14.936  1.00 18.64           C  
HETATM 1028  N   MSE A 124      33.191  -9.203 -11.804  1.00 14.97           N  
HETATM 1029  CA  MSE A 124      34.478  -9.104 -11.115  1.00 13.91           C  
HETATM 1030  C   MSE A 124      35.560  -8.342 -11.921  1.00 12.88           C  
HETATM 1031  O   MSE A 124      36.719  -8.277 -11.509  1.00 13.70           O  
HETATM 1032  CB  MSE A 124      34.967 -10.492 -10.692  1.00 14.92           C  
HETATM 1033  CG  MSE A 124      34.000 -11.231  -9.741  1.00 13.84           C  
HETATM 1034 SE   MSE A 124      33.825 -10.262  -8.069  1.00 19.06          SE  
HETATM 1035  CE  MSE A 124      35.574 -10.495  -7.476  1.00 10.42           C  
ATOM   1036  N   ASP A 125      35.168  -7.746 -13.042  1.00 11.07           N  
ATOM   1037  CA  ASP A 125      36.130  -6.955 -13.831  1.00 11.64           C  
ATOM   1038  C   ASP A 125      36.270  -5.581 -13.219  1.00 11.50           C  
ATOM   1039  O   ASP A 125      35.278  -4.881 -13.003  1.00 13.13           O  
ATOM   1040  CB  ASP A 125      35.727  -6.857 -15.309  1.00 12.61           C  
ATOM   1041  CG  ASP A 125      35.674  -8.234 -15.985  1.00 15.60           C  
ATOM   1042  OD1 ASP A 125      36.535  -9.085 -15.676  1.00 18.33           O  
ATOM   1043  OD2 ASP A 125      34.771  -8.466 -16.815  1.00 22.93           O  
ATOM   1044  N   VAL A 126      37.511  -5.171 -12.995  1.00 10.73           N  
ATOM   1045  CA  VAL A 126      37.756  -3.843 -12.453  1.00 10.55           C  
ATOM   1046  C   VAL A 126      37.536  -2.784 -13.520  1.00 12.09           C  
ATOM   1047  O   VAL A 126      38.021  -2.913 -14.667  1.00 12.59           O  
ATOM   1048  CB  VAL A 126      39.197  -3.695 -11.880  1.00 10.89           C  
ATOM   1049  CG1 VAL A 126      39.417  -2.315 -11.296  1.00 12.29           C  
ATOM   1050  CG2 VAL A 126      39.494  -4.784 -10.847  1.00 10.87           C  
ATOM   1051  N   LEU A 127      36.788  -1.746 -13.161  1.00 11.24           N  
ATOM   1052  CA  LEU A 127      36.536  -0.613 -14.058  1.00 11.59           C  
ATOM   1053  C   LEU A 127      37.558   0.512 -13.879  1.00 11.42           C  
ATOM   1054  O   LEU A 127      38.073   1.086 -14.854  1.00 12.73           O  
ATOM   1055  CB  LEU A 127      35.102  -0.088 -13.874  1.00 12.14           C  
ATOM   1056  CG  LEU A 127      34.700   1.168 -14.653  1.00 11.73           C  
ATOM   1057  CD1 LEU A 127      34.850   0.921 -16.171  1.00 14.04           C  
ATOM   1058  CD2 LEU A 127      33.264   1.543 -14.328  1.00 11.28           C  
ATOM   1059  N   PHE A 128      37.830   0.877 -12.618  1.00 11.91           N  
ATOM   1060  CA  PHE A 128      38.701   2.001 -12.297  1.00 13.29           C  
ATOM   1061  C   PHE A 128      39.242   1.708 -10.906  1.00 14.34           C  
ATOM   1062  O   PHE A 128      38.516   1.179 -10.060  1.00 14.68           O  
ATOM   1063  CB  PHE A 128      37.860   3.296 -12.260  1.00 13.72           C  
ATOM   1064  CG  PHE A 128      38.602   4.515 -11.734  1.00 13.76           C  
ATOM   1065  CD1 PHE A 128      39.154   5.446 -12.609  1.00 14.05           C  
ATOM   1066  CD2 PHE A 128      38.724   4.743 -10.347  1.00 15.21           C  
ATOM   1067  CE1 PHE A 128      39.825   6.578 -12.124  1.00 15.06           C  
ATOM   1068  CE2 PHE A 128      39.414   5.868  -9.870  1.00 15.87           C  
ATOM   1069  CZ  PHE A 128      39.952   6.778 -10.753  1.00 15.96           C  
ATOM   1070  N   GLU A 129      40.503   2.042 -10.690  1.00 12.50           N  
ATOM   1071  CA  GLU A 129      41.090   1.868  -9.351  1.00 13.46           C  
ATOM   1072  C   GLU A 129      42.130   2.931  -9.050  1.00 12.86           C  
ATOM   1073  O   GLU A 129      42.838   3.422  -9.946  1.00 14.54           O  
ATOM   1074  CB  GLU A 129      41.659   0.463  -9.196  1.00 13.26           C  
ATOM   1075  CG  GLU A 129      42.938   0.216 -10.025  1.00 13.13           C  
ATOM   1076  CD  GLU A 129      43.400  -1.227  -9.956  1.00 17.71           C  
ATOM   1077  OE1 GLU A 129      43.436  -1.796  -8.842  1.00 15.41           O  
ATOM   1078  OE2 GLU A 129      43.736  -1.779 -11.035  1.00 16.30           O  
ATOM   1079  N   LYS A 130      42.205   3.309  -7.770  1.00 14.01           N  
ATOM   1080  CA  LYS A 130      43.226   4.226  -7.306  1.00 15.24           C  
ATOM   1081  C   LYS A 130      43.767   3.712  -5.968  1.00 14.74           C  
ATOM   1082  O   LYS A 130      42.987   3.200  -5.147  1.00 14.68           O  
ATOM   1083  CB  LYS A 130      42.604   5.606  -7.129  1.00 17.28           C  
ATOM   1084  CG  LYS A 130      43.542   6.688  -6.729  1.00 26.21           C  
ATOM   1085  CD  LYS A 130      44.039   7.452  -7.921  1.00 33.21           C  
ATOM   1086  CE  LYS A 130      44.881   8.635  -7.454  1.00 36.03           C  
ATOM   1087  NZ  LYS A 130      44.861   9.722  -8.462  1.00 34.80           N  
ATOM   1088  N   TRP A 131      45.080   3.797  -5.795  1.00 14.01           N  
ATOM   1089  CA  TRP A 131      45.751   3.332  -4.585  1.00 13.97           C  
ATOM   1090  C   TRP A 131      46.487   4.504  -3.952  1.00 13.84           C  
ATOM   1091  O   TRP A 131      46.992   5.411  -4.646  1.00 14.66           O  
ATOM   1092  CB  TRP A 131      46.696   2.161  -4.903  1.00 15.58           C  
ATOM   1093  CG  TRP A 131      45.884   0.968  -5.383  1.00 14.80           C  
ATOM   1094  CD1 TRP A 131      45.391   0.769  -6.651  1.00 16.21           C  
ATOM   1095  CD2 TRP A 131      45.451  -0.156  -4.607  1.00 14.10           C  
ATOM   1096  NE1 TRP A 131      44.676  -0.402  -6.702  1.00 16.87           N  
ATOM   1097  CE2 TRP A 131      44.682  -0.984  -5.458  1.00 16.33           C  
ATOM   1098  CE3 TRP A 131      45.608  -0.527  -3.265  1.00 16.59           C  
ATOM   1099  CZ2 TRP A 131      44.100  -2.186  -5.020  1.00 15.99           C  
ATOM   1100  CZ3 TRP A 131      45.039  -1.733  -2.829  1.00 17.55           C  
ATOM   1101  CH2 TRP A 131      44.304  -2.553  -3.713  1.00 15.27           C  
ATOM   1102  N   PHE A 132      46.528   4.509  -2.612  1.00 12.79           N  
ATOM   1103  CA  PHE A 132      47.045   5.676  -1.902  1.00 14.19           C  
ATOM   1104  C   PHE A 132      47.433   5.311  -0.467  1.00 13.62           C  
ATOM   1105  O   PHE A 132      46.965   4.317   0.078  1.00 13.59           O  
ATOM   1106  CB  PHE A 132      45.978   6.778  -1.886  1.00 16.06           C  
ATOM   1107  CG  PHE A 132      44.683   6.374  -1.183  1.00 14.54           C  
ATOM   1108  CD1 PHE A 132      44.442   6.796   0.129  1.00 17.11           C  
ATOM   1109  CD2 PHE A 132      43.703   5.585  -1.829  1.00 17.31           C  
ATOM   1110  CE1 PHE A 132      43.257   6.423   0.777  1.00 16.80           C  
ATOM   1111  CE2 PHE A 132      42.528   5.215  -1.175  1.00 16.61           C  
ATOM   1112  CZ  PHE A 132      42.305   5.640   0.122  1.00 16.19           C  
ATOM   1113  N   TYR A 133      48.268   6.149   0.129  1.00 15.62           N  
ATOM   1114  CA  TYR A 133      48.633   6.023   1.544  1.00 15.54           C  
ATOM   1115  C   TYR A 133      47.593   6.783   2.346  1.00 16.45           C  
ATOM   1116  O   TYR A 133      47.450   8.000   2.178  1.00 17.15           O  
ATOM   1117  CB  TYR A 133      50.034   6.605   1.755  1.00 17.02           C  
ATOM   1118  CG  TYR A 133      51.119   5.785   1.085  1.00 18.42           C  
ATOM   1119  CD1 TYR A 133      51.605   4.604   1.691  1.00 22.20           C  
ATOM   1120  CD2 TYR A 133      51.654   6.168  -0.153  1.00 22.55           C  
ATOM   1121  CE1 TYR A 133      52.585   3.841   1.088  1.00 28.73           C  
ATOM   1122  CE2 TYR A 133      52.646   5.407  -0.763  1.00 24.79           C  
ATOM   1123  CZ  TYR A 133      53.098   4.247  -0.146  1.00 24.39           C  
ATOM   1124  OH  TYR A 133      54.081   3.493  -0.752  1.00 29.85           O  
ATOM   1125  N   CYS A 134      46.874   6.065   3.213  1.00 15.02           N  
ATOM   1126  CA  CYS A 134      45.712   6.619   3.905  1.00 14.69           C  
ATOM   1127  C   CYS A 134      46.097   7.277   5.215  1.00 15.01           C  
ATOM   1128  O   CYS A 134      46.554   6.600   6.138  1.00 16.20           O  
ATOM   1129  CB  CYS A 134      44.719   5.521   4.221  1.00 13.49           C  
ATOM   1130  SG  CYS A 134      43.260   6.178   5.052  1.00 19.17           S  
ATOM   1131  N   LYS A 135      45.922   8.593   5.284  1.00 15.36           N  
ATOM   1132  CA  LYS A 135      46.132   9.336   6.527  1.00 16.01           C  
ATOM   1133  C   LYS A 135      44.788   9.744   7.153  1.00 16.68           C  
ATOM   1134  O   LYS A 135      44.576   9.624   8.377  1.00 17.37           O  
ATOM   1135  CB  LYS A 135      47.008  10.555   6.252  1.00 16.88           C  
ATOM   1136  CG  LYS A 135      48.460  10.206   5.915  1.00 24.90           C  
ATOM   1137  CD  LYS A 135      49.230  11.425   5.416  1.00 33.85           C  
ATOM   1138  CE  LYS A 135      50.677  11.436   5.948  1.00 39.86           C  
ATOM   1139  NZ  LYS A 135      51.415  12.710   5.648  1.00 37.61           N  
ATOM   1140  N   ASP A 136      43.889  10.242   6.313  1.00 17.02           N  
ATOM   1141  CA  ASP A 136      42.560  10.635   6.732  1.00 18.52           C  
ATOM   1142  C   ASP A 136      41.627  10.188   5.621  1.00 19.60           C  
ATOM   1143  O   ASP A 136      41.488  10.859   4.586  1.00 19.06           O  
ATOM   1144  CB  ASP A 136      42.502  12.147   6.916  1.00 19.97           C  
ATOM   1145  CG  ASP A 136      41.172  12.619   7.453  1.00 26.19           C  
ATOM   1146  OD1 ASP A 136      40.169  11.875   7.365  1.00 27.37           O  
ATOM   1147  OD2 ASP A 136      41.141  13.751   7.980  1.00 31.07           O  
ATOM   1148  N   LEU A 137      40.992   9.047   5.855  1.00 20.90           N  
ATOM   1149  CA  LEU A 137      40.292   8.347   4.796  1.00 23.36           C  
ATOM   1150  C   LEU A 137      39.282   9.241   4.103  1.00 24.76           C  
ATOM   1151  O   LEU A 137      39.284   9.330   2.875  1.00 26.10           O  
ATOM   1152  CB  LEU A 137      39.641   7.061   5.327  1.00 22.24           C  
ATOM   1153  CG  LEU A 137      39.025   6.158   4.260  1.00 22.64           C  
ATOM   1154  CD1 LEU A 137      40.032   5.810   3.158  1.00 23.28           C  
ATOM   1155  CD2 LEU A 137      38.469   4.915   4.919  1.00 25.46           C  
ATOM   1156  N   GLY A 138      38.451   9.936   4.876  1.00 25.83           N  
ATOM   1157  CA  GLY A 138      37.361  10.719   4.290  1.00 28.33           C  
ATOM   1158  C   GLY A 138      37.847  11.881   3.439  1.00 29.80           C  
ATOM   1159  O   GLY A 138      37.322  12.131   2.336  1.00 31.88           O  
ATOM   1160  N   THR A 139      38.843  12.599   3.965  1.00 28.75           N  
ATOM   1161  CA  THR A 139      39.494  13.710   3.259  1.00 26.69           C  
ATOM   1162  C   THR A 139      40.070  13.251   1.907  1.00 24.80           C  
ATOM   1163  O   THR A 139      39.902  13.914   0.870  1.00 22.94           O  
ATOM   1164  CB  THR A 139      40.609  14.317   4.163  1.00 27.38           C  
ATOM   1165  OG1 THR A 139      39.997  15.082   5.208  1.00 29.48           O  
ATOM   1166  CG2 THR A 139      41.559  15.218   3.373  1.00 27.29           C  
ATOM   1167  N   GLN A 140      40.725  12.101   1.927  1.00 22.34           N  
ATOM   1168  CA  GLN A 140      41.398  11.580   0.742  1.00 21.57           C  
ATOM   1169  C   GLN A 140      40.482  10.889  -0.252  1.00 21.79           C  
ATOM   1170  O   GLN A 140      40.815  10.838  -1.439  1.00 21.58           O  
ATOM   1171  CB  GLN A 140      42.517  10.635   1.166  1.00 20.93           C  
ATOM   1172  CG  GLN A 140      43.646  11.386   1.832  1.00 17.36           C  
ATOM   1173  CD  GLN A 140      44.715  10.475   2.326  1.00 20.89           C  
ATOM   1174  OE1 GLN A 140      44.723  10.102   3.501  1.00 21.00           O  
ATOM   1175  NE2 GLN A 140      45.634  10.098   1.439  1.00 20.25           N  
ATOM   1176  N   LEU A 141      39.360  10.328   0.213  1.00 21.15           N  
ATOM   1177  CA  LEU A 141      38.441   9.621  -0.699  1.00 21.47           C  
ATOM   1178  C   LEU A 141      37.654  10.576  -1.597  1.00 20.78           C  
ATOM   1179  O   LEU A 141      37.410  10.256  -2.757  1.00 18.84           O  
ATOM   1180  CB  LEU A 141      37.475   8.687   0.040  1.00 22.29           C  
ATOM   1181  CG  LEU A 141      37.951   7.308   0.519  1.00 25.80           C  
ATOM   1182  CD1 LEU A 141      36.750   6.500   1.037  1.00 31.57           C  
ATOM   1183  CD2 LEU A 141      38.702   6.523  -0.561  1.00 27.92           C  
ATOM   1184  N   ALA A 142      37.247  11.741  -1.076  1.00 19.98           N  
ATOM   1185  CA  ALA A 142      36.482  12.693  -1.879  1.00 19.30           C  
ATOM   1186  C   ALA A 142      37.107  12.982  -3.258  1.00 18.00           C  
ATOM   1187  O   ALA A 142      36.418  12.844  -4.279  1.00 17.80           O  
ATOM   1188  CB  ALA A 142      36.223  13.998  -1.098  1.00 19.86           C  
ATOM   1189  N   PRO A 143      38.405  13.381  -3.304  1.00 18.84           N  
ATOM   1190  CA  PRO A 143      38.993  13.658  -4.629  1.00 16.79           C  
ATOM   1191  C   PRO A 143      39.078  12.438  -5.549  1.00 15.79           C  
ATOM   1192  O   PRO A 143      38.978  12.602  -6.778  1.00 16.43           O  
ATOM   1193  CB  PRO A 143      40.387  14.217  -4.304  1.00 17.99           C  
ATOM   1194  CG  PRO A 143      40.301  14.669  -2.862  1.00 20.84           C  
ATOM   1195  CD  PRO A 143      39.362  13.689  -2.215  1.00 18.98           C  
ATOM   1196  N   ILE A 144      39.252  11.248  -4.963  1.00 15.63           N  
ATOM   1197  CA  ILE A 144      39.332   9.991  -5.727  1.00 14.29           C  
ATOM   1198  C   ILE A 144      37.990   9.674  -6.355  1.00 14.93           C  
ATOM   1199  O   ILE A 144      37.895   9.328  -7.540  1.00 16.25           O  
ATOM   1200  CB  ILE A 144      39.798   8.796  -4.861  1.00 15.58           C  
ATOM   1201  CG1 ILE A 144      41.214   9.085  -4.348  1.00 18.24           C  
ATOM   1202  CG2 ILE A 144      39.737   7.495  -5.704  1.00 16.87           C  
ATOM   1203  CD1 ILE A 144      41.700   8.108  -3.276  1.00 20.75           C  
ATOM   1204  N   ILE A 145      36.939   9.786  -5.556  1.00 13.76           N  
ATOM   1205  CA  ILE A 145      35.584   9.599  -6.069  1.00 13.88           C  
ATOM   1206  C   ILE A 145      35.270  10.622  -7.168  1.00 14.17           C  
ATOM   1207  O   ILE A 145      34.715  10.269  -8.221  1.00 14.52           O  
ATOM   1208  CB  ILE A 145      34.558   9.639  -4.904  1.00 13.22           C  
ATOM   1209  CG1 ILE A 145      34.794   8.431  -3.982  1.00 16.11           C  
ATOM   1210  CG2 ILE A 145      33.129   9.706  -5.459  1.00 13.19           C  
ATOM   1211  CD1 ILE A 145      33.993   8.503  -2.680  1.00 16.82           C  
ATOM   1212  N   GLN A 146      35.652  11.884  -6.954  1.00 13.56           N  
ATOM   1213  CA  GLN A 146      35.461  12.909  -7.989  1.00 15.50           C  
ATOM   1214  C   GLN A 146      36.252  12.539  -9.252  1.00 14.08           C  
ATOM   1215  O   GLN A 146      35.746  12.690 -10.385  1.00 14.54           O  
ATOM   1216  CB  GLN A 146      35.843  14.299  -7.464  1.00 16.28           C  
ATOM   1217  CG  GLN A 146      35.753  15.412  -8.495  1.00 24.67           C  
ATOM   1218  CD  GLN A 146      34.339  15.594  -9.058  1.00 35.50           C  
ATOM   1219  OE1 GLN A 146      33.437  16.103  -8.367  1.00 36.61           O  
ATOM   1220  NE2 GLN A 146      34.142  15.192 -10.326  1.00 35.17           N  
ATOM   1221  N   GLU A 147      37.461  12.007  -9.059  1.00 13.27           N  
ATOM   1222  CA  GLU A 147      38.273  11.601 -10.225  1.00 13.69           C  
ATOM   1223  C   GLU A 147      37.544  10.539 -11.038  1.00 12.68           C  
ATOM   1224  O   GLU A 147      37.481  10.635 -12.277  1.00 15.07           O  
ATOM   1225  CB  GLU A 147      39.656  11.118  -9.806  1.00 13.09           C  
ATOM   1226  CG  GLU A 147      40.527  10.765 -11.003  1.00 17.12           C  
ATOM   1227  CD  GLU A 147      41.913  10.277 -10.616  1.00 27.85           C  
ATOM   1228  OE1 GLU A 147      42.301  10.434  -9.432  1.00 29.09           O  
ATOM   1229  OE2 GLU A 147      42.620   9.744 -11.502  1.00 27.71           O  
ATOM   1230  N   PHE A 148      36.983   9.542 -10.359  1.00 12.54           N  
ATOM   1231  CA  PHE A 148      36.207   8.509 -11.056  1.00 11.24           C  
ATOM   1232  C   PHE A 148      35.021   9.121 -11.807  1.00 12.21           C  
ATOM   1233  O   PHE A 148      34.788   8.817 -12.977  1.00 12.24           O  
ATOM   1234  CB  PHE A 148      35.701   7.446 -10.108  1.00 13.60           C  
ATOM   1235  CG  PHE A 148      34.768   6.461 -10.779  1.00 12.56           C  
ATOM   1236  CD1 PHE A 148      35.239   5.632 -11.808  1.00 14.50           C  
ATOM   1237  CD2 PHE A 148      33.441   6.389 -10.427  1.00 11.62           C  
ATOM   1238  CE1 PHE A 148      34.368   4.724 -12.428  1.00 11.40           C  
ATOM   1239  CE2 PHE A 148      32.560   5.506 -11.072  1.00 15.66           C  
ATOM   1240  CZ  PHE A 148      33.048   4.664 -12.068  1.00 12.07           C  
ATOM   1241  N   PHE A 149      34.263   9.984 -11.153  1.00 12.45           N  
ATOM   1242  CA  PHE A 149      33.073  10.497 -11.825  1.00 13.04           C  
ATOM   1243  C   PHE A 149      33.393  11.406 -13.016  1.00 14.99           C  
ATOM   1244  O   PHE A 149      32.573  11.558 -13.915  1.00 15.04           O  
ATOM   1245  CB  PHE A 149      32.073  11.087 -10.814  1.00 15.21           C  
ATOM   1246  CG  PHE A 149      31.363  10.022 -10.004  1.00 16.74           C  
ATOM   1247  CD1 PHE A 149      30.490   9.129 -10.627  1.00 20.21           C  
ATOM   1248  CD2 PHE A 149      31.579   9.898  -8.640  1.00 22.49           C  
ATOM   1249  CE1 PHE A 149      29.831   8.128  -9.891  1.00 23.54           C  
ATOM   1250  CE2 PHE A 149      30.921   8.905  -7.895  1.00 25.02           C  
ATOM   1251  CZ  PHE A 149      30.042   8.032  -8.519  1.00 22.29           C  
ATOM   1252  N   SER A 150      34.623  11.921 -13.054  1.00 14.41           N  
ATOM   1253  CA  SER A 150      35.116  12.743 -14.158  1.00 14.66           C  
ATOM   1254  C   SER A 150      35.859  11.910 -15.205  1.00 14.18           C  
ATOM   1255  O   SER A 150      36.313  12.452 -16.207  1.00 13.70           O  
ATOM   1256  CB  SER A 150      36.082  13.789 -13.593  1.00 14.07           C  
ATOM   1257  OG  SER A 150      35.383  14.697 -12.775  1.00 21.72           O  
ATOM   1258  N   SER A 151      35.979  10.601 -14.975  1.00 12.71           N  
ATOM   1259  CA  SER A 151      36.876   9.760 -15.785  1.00 12.62           C  
ATOM   1260  C   SER A 151      36.219   9.242 -17.054  1.00 12.21           C  
ATOM   1261  O   SER A 151      34.993   9.164 -17.167  1.00 11.92           O  
ATOM   1262  CB  SER A 151      37.348   8.542 -14.987  1.00 13.41           C  
ATOM   1263  OG  SER A 151      36.323   7.573 -14.843  1.00 12.42           O  
ATOM   1264  N   GLU A 152      37.070   8.820 -17.983  1.00 12.16           N  
ATOM   1265  CA  GLU A 152      36.582   8.198 -19.211  1.00 11.83           C  
ATOM   1266  C   GLU A 152      35.893   6.876 -18.870  1.00 13.09           C  
ATOM   1267  O   GLU A 152      34.899   6.483 -19.505  1.00 12.66           O  
ATOM   1268  CB  GLU A 152      37.774   8.012 -20.156  1.00 12.94           C  
ATOM   1269  CG  GLU A 152      37.437   7.356 -21.468  1.00 16.48           C  
ATOM   1270  CD  GLU A 152      36.591   8.231 -22.359  1.00 15.47           C  
ATOM   1271  OE1 GLU A 152      36.253   9.374 -21.994  1.00 16.89           O  
ATOM   1272  OE2 GLU A 152      36.267   7.746 -23.457  1.00 17.54           O  
ATOM   1273  N   GLN A 153      36.428   6.179 -17.856  1.00 12.73           N  
ATOM   1274  CA  GLN A 153      35.835   4.884 -17.449  1.00 12.04           C  
ATOM   1275  C   GLN A 153      34.402   5.053 -16.975  1.00 11.62           C  
ATOM   1276  O   GLN A 153      33.544   4.221 -17.271  1.00 13.30           O  
ATOM   1277  CB  GLN A 153      36.669   4.173 -16.378  1.00 12.80           C  
ATOM   1278  CG  GLN A 153      38.067   3.777 -16.844  1.00 13.81           C  
ATOM   1279  CD  GLN A 153      39.138   4.801 -16.529  1.00 13.48           C  
ATOM   1280  OE1 GLN A 153      38.923   6.015 -16.618  1.00 14.07           O  
ATOM   1281  NE2 GLN A 153      40.333   4.310 -16.174  1.00 13.49           N  
ATOM   1282  N   TYR A 154      34.129   6.104 -16.210  1.00 10.87           N  
ATOM   1283  CA  TYR A 154      32.731   6.348 -15.817  1.00 12.63           C  
ATOM   1284  C   TYR A 154      31.864   6.740 -17.026  1.00 13.04           C  
ATOM   1285  O   TYR A 154      30.698   6.330 -17.155  1.00 13.71           O  
ATOM   1286  CB  TYR A 154      32.633   7.430 -14.725  1.00 13.00           C  
ATOM   1287  CG  TYR A 154      31.191   7.682 -14.340  1.00 11.70           C  
ATOM   1288  CD1 TYR A 154      30.436   6.689 -13.673  1.00 15.91           C  
ATOM   1289  CD2 TYR A 154      30.554   8.883 -14.673  1.00 17.95           C  
ATOM   1290  CE1 TYR A 154      29.093   6.917 -13.333  1.00 18.45           C  
ATOM   1291  CE2 TYR A 154      29.210   9.108 -14.341  1.00 20.25           C  
ATOM   1292  CZ  TYR A 154      28.495   8.121 -13.667  1.00 19.08           C  
ATOM   1293  OH  TYR A 154      27.162   8.357 -13.342  1.00 21.67           O  
ATOM   1294  N   ARG A 155      32.442   7.545 -17.918  1.00 10.79           N  
ATOM   1295  CA  ARG A 155      31.689   8.069 -19.068  1.00 10.43           C  
ATOM   1296  C   ARG A 155      31.226   6.954 -20.005  1.00 11.80           C  
ATOM   1297  O   ARG A 155      30.084   6.997 -20.538  1.00 12.14           O  
ATOM   1298  CB  ARG A 155      32.544   9.056 -19.843  1.00 11.59           C  
ATOM   1299  CG  ARG A 155      31.743   9.921 -20.813  1.00 11.68           C  
ATOM   1300  CD  ARG A 155      32.659  10.749 -21.732  1.00 10.81           C  
ATOM   1301  NE  ARG A 155      33.461   9.914 -22.621  1.00 11.41           N  
ATOM   1302  CZ  ARG A 155      33.017   9.370 -23.751  1.00 12.86           C  
ATOM   1303  NH1 ARG A 155      31.767   9.579 -24.149  1.00 10.80           N  
ATOM   1304  NH2 ARG A 155      33.826   8.599 -24.467  1.00 13.33           N  
ATOM   1305  N   THR A 156      32.092   5.951 -20.162  1.00 10.87           N  
ATOM   1306  CA  THR A 156      31.838   4.860 -21.121  1.00 11.83           C  
ATOM   1307  C   THR A 156      31.315   3.611 -20.414  1.00 14.19           C  
ATOM   1308  O   THR A 156      30.676   2.749 -21.029  1.00 14.34           O  
ATOM   1309  CB  THR A 156      33.128   4.440 -21.866  1.00 11.60           C  
ATOM   1310  OG1 THR A 156      34.077   3.949 -20.901  1.00 12.45           O  
ATOM   1311  CG2 THR A 156      33.752   5.601 -22.646  1.00 13.07           C  
ATOM   1312  N   GLY A 157      31.650   3.484 -19.139  1.00 13.11           N  
ATOM   1313  CA  GLY A 157      31.327   2.259 -18.404  1.00 13.88           C  
ATOM   1314  C   GLY A 157      32.257   1.105 -18.790  1.00 14.54           C  
ATOM   1315  O   GLY A 157      32.011  -0.044 -18.391  1.00 16.36           O  
ATOM   1316  N   LYS A 158      33.327   1.404 -19.528  1.00 15.32           N  
ATOM   1317  CA  LYS A 158      34.265   0.383 -19.998  1.00 16.52           C  
ATOM   1318  C   LYS A 158      35.663   0.550 -19.433  1.00 15.94           C  
ATOM   1319  O   LYS A 158      36.187   1.672 -19.373  1.00 15.92           O  
ATOM   1320  CB  LYS A 158      34.282   0.312 -21.523  1.00 20.81           C  
ATOM   1321  CG  LYS A 158      32.997  -0.322 -22.113  1.00 26.57           C  
ATOM   1322  CD  LYS A 158      32.621  -1.706 -21.498  1.00 32.20           C  
ATOM   1323  CE  LYS A 158      31.346  -2.265 -22.130  1.00 27.90           C  
ATOM   1324  NZ  LYS A 158      30.811  -3.413 -21.334  1.00 36.80           N  
ATOM   1325  N   PRO A 159      36.263  -0.559 -18.978  1.00 14.83           N  
ATOM   1326  CA  PRO A 159      37.624  -0.443 -18.486  1.00 15.15           C  
ATOM   1327  C   PRO A 159      38.622  -0.072 -19.582  1.00 15.44           C  
ATOM   1328  O   PRO A 159      38.461  -0.442 -20.765  1.00 14.47           O  
ATOM   1329  CB  PRO A 159      37.944  -1.844 -17.951  1.00 14.86           C  
ATOM   1330  CG  PRO A 159      36.624  -2.552 -17.839  1.00 19.32           C  
ATOM   1331  CD  PRO A 159      35.746  -1.938 -18.887  1.00 12.92           C  
ATOM   1332  N   ILE A 160      39.639   0.676 -19.174  1.00 15.19           N  
ATOM   1333  CA  ILE A 160      40.789   0.937 -20.035  1.00 14.34           C  
ATOM   1334  C   ILE A 160      41.893   0.028 -19.469  1.00 14.76           C  
ATOM   1335  O   ILE A 160      42.406   0.264 -18.354  1.00 13.10           O  
ATOM   1336  CB  ILE A 160      41.206   2.415 -19.964  1.00 13.50           C  
ATOM   1337  CG1 ILE A 160      40.062   3.329 -20.433  1.00 15.98           C  
ATOM   1338  CG2 ILE A 160      42.464   2.646 -20.807  1.00 13.75           C  
ATOM   1339  CD1 ILE A 160      40.334   4.801 -20.204  1.00 16.14           C  
ATOM   1340  N   PRO A 161      42.204  -1.083 -20.160  1.00 15.37           N  
ATOM   1341  CA  PRO A 161      43.121  -2.054 -19.575  1.00 15.64           C  
ATOM   1342  C   PRO A 161      44.454  -1.485 -19.087  1.00 14.49           C  
ATOM   1343  O   PRO A 161      44.906  -1.905 -18.021  1.00 15.83           O  
ATOM   1344  CB  PRO A 161      43.339  -3.076 -20.694  1.00 17.76           C  
ATOM   1345  CG  PRO A 161      42.164  -2.934 -21.568  1.00 17.89           C  
ATOM   1346  CD  PRO A 161      41.674  -1.521 -21.464  1.00 16.80           C  
ATOM   1347  N   ASP A 162      45.030  -0.514 -19.805  1.00 14.06           N  
ATOM   1348  CA  ASP A 162      46.334   0.044 -19.385  1.00 14.01           C  
ATOM   1349  C   ASP A 162      46.244   0.929 -18.160  1.00 11.74           C  
ATOM   1350  O   ASP A 162      47.278   1.249 -17.571  1.00 11.36           O  
ATOM   1351  CB  ASP A 162      46.991   0.853 -20.504  1.00 15.19           C  
ATOM   1352  CG  ASP A 162      47.411   0.006 -21.668  1.00 26.05           C  
ATOM   1353  OD1 ASP A 162      47.945  -1.106 -21.431  1.00 24.98           O  
ATOM   1354  OD2 ASP A 162      47.211   0.465 -22.816  1.00 35.26           O  
ATOM   1355  N   GLN A 163      45.014   1.279 -17.771  1.00 11.70           N  
ATOM   1356  CA  GLN A 163      44.786   2.115 -16.575  1.00 10.92           C  
ATOM   1357  C   GLN A 163      44.544   1.292 -15.307  1.00 14.04           C  
ATOM   1358  O   GLN A 163      44.212   1.839 -14.238  1.00 17.87           O  
ATOM   1359  CB  GLN A 163      43.612   3.096 -16.829  1.00 12.02           C  
ATOM   1360  CG  GLN A 163      44.024   4.209 -17.847  1.00 12.25           C  
ATOM   1361  CD  GLN A 163      45.110   5.097 -17.304  1.00 12.38           C  
ATOM   1362  OE1 GLN A 163      45.144   5.358 -16.089  1.00 15.66           O  
ATOM   1363  NE2 GLN A 163      45.998   5.568 -18.171  1.00 14.99           N  
ATOM   1364  N   LEU A 164      44.737  -0.009 -15.398  1.00 11.60           N  
ATOM   1365  CA  LEU A 164      44.579  -0.892 -14.228  1.00 13.17           C  
ATOM   1366  C   LEU A 164      45.978  -1.384 -13.843  1.00 11.31           C  
ATOM   1367  O   LEU A 164      46.903  -1.415 -14.674  1.00 11.83           O  
ATOM   1368  CB  LEU A 164      43.708  -2.110 -14.631  1.00 14.00           C  
ATOM   1369  CG  LEU A 164      42.269  -1.750 -15.063  1.00 16.09           C  
ATOM   1370  CD1 LEU A 164      41.508  -2.981 -15.545  1.00 22.49           C  
ATOM   1371  CD2 LEU A 164      41.538  -0.999 -13.947  1.00 17.58           C  
ATOM   1372  N   LEU A 165      46.140  -1.813 -12.586  1.00 13.21           N  
ATOM   1373  CA  LEU A 165      47.345  -2.527 -12.177  1.00 13.19           C  
ATOM   1374  C   LEU A 165      47.362  -3.959 -12.730  1.00 16.77           C  
ATOM   1375  O   LEU A 165      46.312  -4.587 -12.834  1.00 18.23           O  
ATOM   1376  CB  LEU A 165      47.403  -2.605 -10.651  1.00 14.87           C  
ATOM   1377  CG  LEU A 165      47.428  -1.303  -9.832  1.00 15.60           C  
ATOM   1378  CD1 LEU A 165      47.583  -1.660  -8.358  1.00 17.66           C  
ATOM   1379  CD2 LEU A 165      48.533  -0.347 -10.299  1.00 21.45           C  
ATOM   1380  N   LYS A 166      48.537  -4.474 -13.087  1.00 15.86           N  
ATOM   1381  CA  LYS A 166      48.660  -5.895 -13.478  1.00 19.28           C  
ATOM   1382  C   LYS A 166      48.234  -6.828 -12.331  1.00 20.62           C  
ATOM   1383  O   LYS A 166      47.668  -7.904 -12.561  1.00 21.25           O  
ATOM   1384  CB  LYS A 166      50.087  -6.222 -13.952  1.00 19.40           C  
ATOM   1385  CG  LYS A 166      50.462  -5.551 -15.252  1.00 27.18           C  
ATOM   1386  CD  LYS A 166      50.060  -6.384 -16.483  1.00 37.73           C  
ATOM   1387  CE  LYS A 166      50.217  -5.579 -17.778  1.00 40.30           C  
ATOM   1388  NZ  LYS A 166      50.079  -6.416 -19.009  1.00 43.32           N  
ATOM   1389  N   GLU A 167      48.510  -6.398 -11.103  1.00 20.37           N  
ATOM   1390  CA  GLU A 167      48.044  -7.077  -9.891  1.00 22.43           C  
ATOM   1391  C   GLU A 167      48.026  -6.080  -8.734  1.00 21.74           C  
ATOM   1392  O   GLU A 167      48.809  -5.124  -8.740  1.00 21.98           O  
ATOM   1393  CB  GLU A 167      48.960  -8.251  -9.533  1.00 23.58           C  
ATOM   1394  CG  GLU A 167      50.419  -7.874  -9.380  1.00 28.95           C  
ATOM   1395  CD  GLU A 167      51.310  -9.082  -9.290  1.00 36.65           C  
ATOM   1396  OE1 GLU A 167      51.478  -9.781 -10.316  1.00 37.42           O  
ATOM   1397  OE2 GLU A 167      51.840  -9.328  -8.188  1.00 40.19           O  
ATOM   1398  N   PRO A 168      47.159  -6.311  -7.723  1.00 22.63           N  
ATOM   1399  CA  PRO A 168      47.182  -5.388  -6.580  1.00 20.02           C  
ATOM   1400  C   PRO A 168      48.558  -5.353  -5.853  1.00 18.38           C  
ATOM   1401  O   PRO A 168      49.387  -6.263  -6.018  1.00 17.70           O  
ATOM   1402  CB  PRO A 168      46.057  -5.933  -5.670  1.00 20.85           C  
ATOM   1403  CG  PRO A 168      45.926  -7.415  -6.063  1.00 21.91           C  
ATOM   1404  CD  PRO A 168      46.142  -7.374  -7.552  1.00 23.59           C  
ATOM   1405  N   PRO A 169      48.817  -4.286  -5.054  1.00 17.12           N  
ATOM   1406  CA  PRO A 169      50.061  -4.154  -4.297  1.00 16.01           C  
ATOM   1407  C   PRO A 169      50.231  -5.237  -3.224  1.00 16.13           C  
ATOM   1408  O   PRO A 169      51.341  -5.474  -2.756  1.00 19.43           O  
ATOM   1409  CB  PRO A 169      49.939  -2.761  -3.642  1.00 16.81           C  
ATOM   1410  CG  PRO A 169      48.552  -2.428  -3.680  1.00 18.80           C  
ATOM   1411  CD  PRO A 169      47.964  -3.098  -4.895  1.00 17.50           C  
ATOM   1412  N   PHE A 170      49.137  -5.907  -2.871  1.00 12.54           N  
ATOM   1413  CA  PHE A 170      49.162  -7.062  -1.947  1.00 12.70           C  
ATOM   1414  C   PHE A 170      48.055  -8.014  -2.418  1.00 11.91           C  
ATOM   1415  O   PHE A 170      47.171  -7.576  -3.132  1.00 12.10           O  
ATOM   1416  CB  PHE A 170      48.902  -6.608  -0.496  1.00 13.28           C  
ATOM   1417  CG  PHE A 170      47.768  -5.651  -0.349  1.00 12.23           C  
ATOM   1418  CD1 PHE A 170      46.431  -6.058  -0.470  1.00 13.09           C  
ATOM   1419  CD2 PHE A 170      48.020  -4.303  -0.074  1.00 14.28           C  
ATOM   1420  CE1 PHE A 170      45.377  -5.151  -0.330  1.00 16.38           C  
ATOM   1421  CE2 PHE A 170      46.976  -3.404   0.068  1.00 13.49           C  
ATOM   1422  CZ  PHE A 170      45.651  -3.806  -0.050  1.00 14.75           C  
ATOM   1423  N   PRO A 171      48.097  -9.295  -1.997  1.00 13.10           N  
ATOM   1424  CA  PRO A 171      46.999 -10.184  -2.397  1.00 13.45           C  
ATOM   1425  C   PRO A 171      45.679  -9.808  -1.709  1.00 11.34           C  
ATOM   1426  O   PRO A 171      45.668  -9.489  -0.527  1.00 11.96           O  
ATOM   1427  CB  PRO A 171      47.467 -11.565  -1.924  1.00 13.26           C  
ATOM   1428  CG  PRO A 171      48.914 -11.416  -1.603  1.00 19.04           C  
ATOM   1429  CD  PRO A 171      49.119 -10.001  -1.211  1.00 12.97           C  
ATOM   1430  N   LEU A 172      44.587  -9.839  -2.457  1.00  9.60           N  
ATOM   1431  CA  LEU A 172      43.275  -9.664  -1.813  1.00  8.28           C  
ATOM   1432  C   LEU A 172      42.999 -10.879  -0.936  1.00  7.40           C  
ATOM   1433  O   LEU A 172      43.481 -11.995  -1.201  1.00  8.43           O  
ATOM   1434  CB  LEU A 172      42.178  -9.574  -2.852  1.00  7.85           C  
ATOM   1435  CG  LEU A 172      42.254  -8.410  -3.832  1.00 11.13           C  
ATOM   1436  CD1 LEU A 172      41.000  -8.434  -4.712  1.00 16.79           C  
ATOM   1437  CD2 LEU A 172      42.431  -7.093  -3.086  1.00 14.70           C  
ATOM   1438  N   SER A 173      42.183 -10.670   0.094  1.00  7.24           N  
ATOM   1439  CA  SER A 173      41.842 -11.750   0.995  1.00  8.37           C  
ATOM   1440  C   SER A 173      41.142 -12.873   0.253  1.00  8.08           C  
ATOM   1441  O   SER A 173      40.322 -12.608  -0.645  1.00  8.14           O  
ATOM   1442  CB  SER A 173      40.870 -11.236   2.017  1.00  8.02           C  
ATOM   1443  OG  SER A 173      40.464 -12.267   2.922  1.00  9.95           O  
ATOM   1444  N   THR A 174      41.480 -14.098   0.642  1.00  7.17           N  
ATOM   1445  CA  THR A 174      40.759 -15.269   0.168  1.00  6.89           C  
ATOM   1446  C   THR A 174      40.001 -15.935   1.323  1.00  6.86           C  
ATOM   1447  O   THR A 174      39.603 -17.128   1.193  1.00  7.62           O  
ATOM   1448  CB  THR A 174      41.707 -16.262  -0.538  1.00  7.43           C  
ATOM   1449  OG1 THR A 174      42.803 -16.574   0.329  1.00 10.11           O  
ATOM   1450  CG2 THR A 174      42.223 -15.677  -1.851  1.00  9.14           C  
ATOM   1451  N   ARG A 175      39.787 -15.192   2.422  1.00  7.58           N  
ATOM   1452  CA  ARG A 175      39.050 -15.710   3.587  1.00  5.78           C  
ATOM   1453  C   ARG A 175      37.544 -15.656   3.365  1.00  8.41           C  
ATOM   1454  O   ARG A 175      37.030 -14.686   2.775  1.00  8.89           O  
ATOM   1455  CB  ARG A 175      39.329 -14.869   4.855  1.00  8.73           C  
ATOM   1456  CG  ARG A 175      40.724 -15.031   5.385  1.00 13.53           C  
ATOM   1457  CD  ARG A 175      40.841 -14.209   6.667  1.00 10.70           C  
ATOM   1458  NE  ARG A 175      40.169 -14.862   7.783  1.00 13.90           N  
ATOM   1459  CZ  ARG A 175      40.511 -14.647   9.062  1.00 15.70           C  
ATOM   1460  NH1 ARG A 175      41.491 -13.791   9.337  1.00 15.92           N  
ATOM   1461  NH2 ARG A 175      39.904 -15.276  10.047  1.00 16.76           N  
ATOM   1462  N   SER A 176      36.827 -16.634   3.902  1.00  7.12           N  
ATOM   1463  CA  SER A 176      35.394 -16.481   4.042  1.00  7.92           C  
ATOM   1464  C   SER A 176      35.119 -15.487   5.161  1.00  8.19           C  
ATOM   1465  O   SER A 176      35.905 -15.337   6.119  1.00 10.38           O  
ATOM   1466  CB  SER A 176      34.697 -17.823   4.304  1.00 10.31           C  
ATOM   1467  OG  SER A 176      35.214 -18.378   5.461  1.00 15.71           O  
ATOM   1468  N   ILE A 177      33.984 -14.814   5.027  1.00  8.08           N  
ATOM   1469  CA  ILE A 177      33.590 -13.725   5.901  1.00  9.06           C  
ATOM   1470  C   ILE A 177      32.546 -14.262   6.889  1.00  8.91           C  
ATOM   1471  O   ILE A 177      31.665 -15.080   6.504  1.00 10.00           O  
ATOM   1472  CB  ILE A 177      32.987 -12.576   5.008  1.00 10.78           C  
ATOM   1473  CG1 ILE A 177      33.989 -12.146   3.911  1.00 17.72           C  
ATOM   1474  CG2 ILE A 177      32.589 -11.417   5.858  1.00 17.58           C  
ATOM   1475  CD1 ILE A 177      35.350 -11.811   4.437  1.00 19.68           C  
HETATM 1476  N   MSE A 178      32.641 -13.810   8.142  1.00  8.59           N  
HETATM 1477  CA  MSE A 178      31.770 -14.305   9.208  1.00  9.57           C  
HETATM 1478  C   MSE A 178      30.347 -13.785   9.049  1.00  7.53           C  
HETATM 1479  O   MSE A 178      30.096 -12.852   8.273  1.00  8.59           O  
HETATM 1480  CB  MSE A 178      32.291 -13.874  10.566  1.00 11.02           C  
HETATM 1481  CG  MSE A 178      32.043 -12.368  10.824  1.00 12.59           C  
HETATM 1482 SE   MSE A 178      32.562 -11.829  12.612  1.00  9.58          SE  
HETATM 1483  CE  MSE A 178      34.466 -12.214  12.494  1.00 14.89           C  
ATOM   1484  N   GLU A 179      29.413 -14.407   9.764  0.50  7.59           N  
ATOM   1486  CA  GLU A 179      28.056 -13.899   9.848  0.50  7.11           C  
ATOM   1488  C   GLU A 179      27.993 -12.890  11.007  0.50  7.13           C  
ATOM   1490  O   GLU A 179      28.391 -13.202  12.122  0.50  5.21           O  
ATOM   1492  CB  GLU A 179      27.081 -15.042  10.112  0.50  8.87           C  
ATOM   1494  CG  GLU A 179      26.942 -15.998   8.940  0.50  9.14           C  
ATOM   1496  CD  GLU A 179      26.371 -15.334   7.708  0.50 16.33           C  
ATOM   1498  OE1 GLU A 179      26.919 -15.553   6.607  0.50 19.20           O  
ATOM   1500  OE2 GLU A 179      25.374 -14.592   7.832  0.50 21.09           O  
ATOM   1502  N   PRO A 180      27.433 -11.694  10.759  1.00  8.95           N  
ATOM   1503  CA  PRO A 180      27.221 -10.756  11.884  1.00  8.34           C  
ATOM   1504  C   PRO A 180      26.458 -11.434  13.011  1.00  8.68           C  
ATOM   1505  O   PRO A 180      25.641 -12.349  12.756  1.00  9.45           O  
ATOM   1506  CB  PRO A 180      26.314  -9.686  11.266  1.00  9.60           C  
ATOM   1507  CG  PRO A 180      26.713  -9.694   9.807  1.00 12.96           C  
ATOM   1508  CD  PRO A 180      26.878 -11.163   9.499  1.00 10.33           C  
HETATM 1509  N   MSE A 181      26.703 -10.997  14.237  1.00  9.85           N  
HETATM 1510  CA  MSE A 181      26.006 -11.638  15.340  1.00 12.34           C  
HETATM 1511  C   MSE A 181      25.415 -10.611  16.301  1.00 10.83           C  
HETATM 1512  O   MSE A 181      25.958  -9.512  16.432  1.00  9.84           O  
HETATM 1513  CB  MSE A 181      26.951 -12.579  16.049  1.00 12.69           C  
HETATM 1514  CG  MSE A 181      28.059 -11.904  16.756  1.00 15.52           C  
HETATM 1515 SE   MSE A 181      29.363 -13.211  17.422  1.00 21.26          SE  
HETATM 1516  CE  MSE A 181      30.207 -11.891  18.580  1.00 16.31           C  
ATOM   1517  N   SER A 182      24.320 -10.976  16.939  1.00  9.31           N  
ATOM   1518  CA  SER A 182      23.713 -10.094  17.907  1.00  9.48           C  
ATOM   1519  C   SER A 182      24.670  -9.946  19.075  1.00 10.32           C  
ATOM   1520  O   SER A 182      25.003 -10.938  19.759  1.00 10.72           O  
ATOM   1521  CB  SER A 182      22.369 -10.645  18.410  1.00  7.97           C  
ATOM   1522  OG  SER A 182      22.005 -10.012  19.627  1.00 10.60           O  
ATOM   1523  N   LEU A 183      25.075  -8.710  19.365  1.00 10.01           N  
ATOM   1524  CA  LEU A 183      25.937  -8.470  20.517  1.00 10.22           C  
ATOM   1525  C   LEU A 183      25.237  -8.850  21.843  1.00  8.58           C  
ATOM   1526  O   LEU A 183      25.843  -9.524  22.701  1.00  9.93           O  
ATOM   1527  CB  LEU A 183      26.401  -7.003  20.529  1.00 10.70           C  
ATOM   1528  CG  LEU A 183      27.344  -6.628  21.690  1.00 12.68           C  
ATOM   1529  CD1 LEU A 183      28.656  -7.460  21.734  1.00 14.73           C  
ATOM   1530  CD2 LEU A 183      27.672  -5.132  21.638  1.00 12.11           C  
ATOM   1531  N   ASP A 184      23.986  -8.432  22.005  1.00  9.82           N  
ATOM   1532  CA  ASP A 184      23.231  -8.723  23.235  1.00 11.35           C  
ATOM   1533  C   ASP A 184      23.130 -10.239  23.424  1.00 11.07           C  
ATOM   1534  O   ASP A 184      23.361 -10.755  24.532  1.00 13.15           O  
ATOM   1535  CB  ASP A 184      21.833  -8.068  23.194  1.00 11.32           C  
ATOM   1536  CG  ASP A 184      21.154  -8.017  24.594  1.00 20.28           C  
ATOM   1537  OD1 ASP A 184      21.859  -8.109  25.612  1.00 31.12           O  
ATOM   1538  OD2 ASP A 184      19.918  -7.864  24.659  1.00 30.83           O  
ATOM   1539  N   ALA A 185      22.831 -10.955  22.339  1.00 10.21           N  
ATOM   1540  CA  ALA A 185      22.635 -12.420  22.473  1.00  9.98           C  
ATOM   1541  C   ALA A 185      23.965 -13.116  22.815  1.00  9.87           C  
ATOM   1542  O   ALA A 185      23.983 -14.052  23.625  1.00 11.12           O  
ATOM   1543  CB  ALA A 185      22.026 -12.994  21.224  1.00 10.52           C  
ATOM   1544  N   TRP A 186      25.061 -12.665  22.209  1.00  8.62           N  
ATOM   1545  CA  TRP A 186      26.383 -13.247  22.499  1.00  9.08           C  
ATOM   1546  C   TRP A 186      26.772 -13.033  23.962  1.00  8.49           C  
ATOM   1547  O   TRP A 186      27.174 -13.956  24.683  1.00  9.63           O  
ATOM   1548  CB  TRP A 186      27.450 -12.650  21.550  1.00  9.47           C  
ATOM   1549  CG  TRP A 186      28.783 -13.345  21.651  1.00 11.12           C  
ATOM   1550  CD1 TRP A 186      29.220 -14.398  20.877  1.00 13.53           C  
ATOM   1551  CD2 TRP A 186      29.846 -13.079  22.596  1.00  9.93           C  
ATOM   1552  NE1 TRP A 186      30.495 -14.766  21.252  1.00 13.87           N  
ATOM   1553  CE2 TRP A 186      30.919 -13.965  22.277  1.00 12.98           C  
ATOM   1554  CE3 TRP A 186      30.021 -12.145  23.625  1.00 11.79           C  
ATOM   1555  CZ2 TRP A 186      32.120 -13.987  22.997  1.00 13.72           C  
ATOM   1556  CZ3 TRP A 186      31.237 -12.157  24.341  1.00 13.64           C  
ATOM   1557  CH2 TRP A 186      32.259 -13.085  24.020  1.00 16.19           C  
ATOM   1558  N   LEU A 187      26.617 -11.786  24.402  1.00 10.35           N  
ATOM   1559  CA  LEU A 187      26.895 -11.459  25.810  1.00 11.62           C  
ATOM   1560  C   LEU A 187      25.996 -12.279  26.756  1.00 11.46           C  
ATOM   1561  O   LEU A 187      26.458 -12.766  27.784  1.00 12.85           O  
ATOM   1562  CB  LEU A 187      26.673  -9.963  26.009  1.00 11.45           C  
ATOM   1563  CG  LEU A 187      27.733  -9.112  25.320  1.00 13.70           C  
ATOM   1564  CD1 LEU A 187      27.253  -7.644  25.316  1.00 15.38           C  
ATOM   1565  CD2 LEU A 187      29.118  -9.296  25.987  1.00 16.37           C  
ATOM   1566  N   ASP A 188      24.724 -12.450  26.409  1.00  9.75           N  
ATOM   1567  CA  ASP A 188      23.824 -13.250  27.242  1.00  8.99           C  
ATOM   1568  C   ASP A 188      24.299 -14.714  27.321  1.00  8.69           C  
ATOM   1569  O   ASP A 188      24.283 -15.344  28.392  1.00 11.18           O  
ATOM   1570  CB  ASP A 188      22.389 -13.196  26.735  1.00 10.87           C  
ATOM   1571  CG  ASP A 188      21.429 -13.879  27.690  1.00 11.01           C  
ATOM   1572  OD1 ASP A 188      21.012 -13.192  28.631  1.00 14.10           O  
ATOM   1573  OD2 ASP A 188      21.103 -15.077  27.515  1.00 13.41           O  
ATOM   1574  N   SER A 189      24.722 -15.276  26.181  1.00  9.44           N  
ATOM   1575  CA  SER A 189      25.091 -16.710  26.170  1.00 10.98           C  
ATOM   1576  C   SER A 189      26.385 -16.976  26.959  1.00 11.09           C  
ATOM   1577  O   SER A 189      26.590 -18.115  27.447  1.00 13.23           O  
ATOM   1578  CB  SER A 189      25.229 -17.219  24.741  1.00 12.65           C  
ATOM   1579  OG  SER A 189      26.414 -16.705  24.211  1.00 18.71           O  
ATOM   1580  N   HIS A 190      27.225 -15.929  27.089  1.00 10.13           N  
ATOM   1581  CA  HIS A 190      28.507 -16.057  27.801  1.00 10.27           C  
ATOM   1582  C   HIS A 190      28.526 -15.382  29.160  1.00 12.85           C  
ATOM   1583  O   HIS A 190      29.613 -15.229  29.758  1.00 13.75           O  
ATOM   1584  CB  HIS A 190      29.654 -15.478  26.940  1.00 10.51           C  
ATOM   1585  CG  HIS A 190      29.860 -16.239  25.668  1.00 13.96           C  
ATOM   1586  ND1 HIS A 190      30.596 -17.404  25.609  1.00 23.75           N  
ATOM   1587  CD2 HIS A 190      29.395 -16.021  24.413  1.00 13.17           C  
ATOM   1588  CE1 HIS A 190      30.595 -17.862  24.366  1.00 18.94           C  
ATOM   1589  NE2 HIS A 190      29.872 -17.046  23.620  1.00 14.95           N  
ATOM   1590  N   HIS A 191      27.351 -15.007  29.679  1.00 12.69           N  
ATOM   1591  CA  HIS A 191      27.337 -14.198  30.898  1.00 11.34           C  
ATOM   1592  C   HIS A 191      27.910 -14.841  32.138  1.00 12.42           C  
ATOM   1593  O   HIS A 191      28.554 -14.147  32.917  1.00 13.47           O  
ATOM   1594  CB  HIS A 191      25.969 -13.540  31.191  1.00 11.47           C  
ATOM   1595  CG  HIS A 191      24.953 -14.447  31.800  1.00  9.33           C  
ATOM   1596  ND1 HIS A 191      24.060 -15.184  31.046  1.00  9.40           N  
ATOM   1597  CD2 HIS A 191      24.680 -14.746  33.102  1.00 10.53           C  
ATOM   1598  CE1 HIS A 191      23.274 -15.882  31.849  1.00 10.78           C  
ATOM   1599  NE2 HIS A 191      23.634 -15.637  33.101  1.00 12.55           N  
ATOM   1600  N   ARG A 192      27.703 -16.139  32.327  1.00 12.95           N  
ATOM   1601  CA  ARG A 192      28.271 -16.798  33.520  1.00 13.81           C  
ATOM   1602  C   ARG A 192      29.788 -16.757  33.538  1.00 14.27           C  
ATOM   1603  O   ARG A 192      30.374 -16.421  34.569  1.00 14.91           O  
ATOM   1604  CB  ARG A 192      27.747 -18.203  33.693  1.00 13.98           C  
ATOM   1605  CG  ARG A 192      26.317 -18.195  34.141  1.00 18.34           C  
ATOM   1606  CD  ARG A 192      25.802 -19.597  34.117  1.00 18.93           C  
ATOM   1607  NE  ARG A 192      25.735 -20.083  32.732  1.00 16.44           N  
ATOM   1608  CZ  ARG A 192      25.393 -21.328  32.384  1.00 17.59           C  
ATOM   1609  NH1 ARG A 192      25.101 -22.249  33.305  1.00 16.79           N  
ATOM   1610  NH2 ARG A 192      25.360 -21.667  31.094  1.00 21.49           N  
ATOM   1611  N   GLU A 193      30.415 -17.013  32.383  1.00 13.33           N  
ATOM   1612  CA  GLU A 193      31.871 -17.001  32.295  1.00 14.16           C  
ATOM   1613  C   GLU A 193      32.408 -15.590  32.521  1.00 10.79           C  
ATOM   1614  O   GLU A 193      33.375 -15.409  33.250  1.00 11.75           O  
ATOM   1615  CB  GLU A 193      32.335 -17.503  30.914  1.00 15.02           C  
ATOM   1616  CG  GLU A 193      33.820 -17.902  30.887  1.00 21.30           C  
ATOM   1617  CD  GLU A 193      34.191 -18.802  29.709  1.00 19.76           C  
ATOM   1618  OE1 GLU A 193      33.378 -18.922  28.751  1.00 27.42           O  
ATOM   1619  OE2 GLU A 193      35.307 -19.384  29.753  1.00 27.02           O  
ATOM   1620  N   LEU A 194      31.749 -14.606  31.934  1.00 10.11           N  
ATOM   1621  CA  LEU A 194      32.183 -13.197  32.064  1.00 12.11           C  
ATOM   1622  C   LEU A 194      32.149 -12.791  33.546  1.00 14.00           C  
ATOM   1623  O   LEU A 194      33.078 -12.184  34.065  1.00 16.45           O  
ATOM   1624  CB  LEU A 194      31.291 -12.262  31.235  1.00 13.71           C  
ATOM   1625  CG  LEU A 194      31.454 -12.348  29.712  1.00 14.20           C  
ATOM   1626  CD1 LEU A 194      30.428 -11.450  29.027  1.00 17.82           C  
ATOM   1627  CD2 LEU A 194      32.872 -11.943  29.325  1.00 16.09           C  
ATOM   1628  N   GLN A 195      31.077 -13.159  34.233  1.00 12.27           N  
ATOM   1629  CA  GLN A 195      30.887 -12.657  35.600  1.00 14.56           C  
ATOM   1630  C   GLN A 195      31.691 -13.484  36.599  1.00 17.06           C  
ATOM   1631  O   GLN A 195      31.908 -13.059  37.756  1.00 20.40           O  
ATOM   1632  CB  GLN A 195      29.396 -12.646  35.949  1.00 15.44           C  
ATOM   1633  CG  GLN A 195      28.580 -11.640  35.136  1.00 15.36           C  
ATOM   1634  CD  GLN A 195      29.179 -10.221  35.168  1.00 17.41           C  
ATOM   1635  OE1 GLN A 195      29.839  -9.834  36.143  1.00 17.99           O  
ATOM   1636  NE2 GLN A 195      28.951  -9.454  34.120  1.00 13.90           N  
ATOM   1637  N   ALA A 196      32.130 -14.659  36.163  1.00 15.07           N  
ATOM   1638  CA  ALA A 196      33.081 -15.453  36.939  1.00 16.90           C  
ATOM   1639  C   ALA A 196      34.487 -14.867  36.870  1.00 17.04           C  
ATOM   1640  O   ALA A 196      35.389 -15.347  37.565  1.00 18.53           O  
ATOM   1641  CB  ALA A 196      33.078 -16.925  36.497  1.00 17.01           C  
ATOM   1642  N   GLY A 197      34.667 -13.838  36.041  1.00 16.19           N  
ATOM   1643  CA  GLY A 197      35.937 -13.110  35.947  1.00 16.60           C  
ATOM   1644  C   GLY A 197      36.855 -13.565  34.818  1.00 17.62           C  
ATOM   1645  O   GLY A 197      38.076 -13.384  34.878  1.00 18.66           O  
ATOM   1646  N   THR A 198      36.265 -14.151  33.784  1.00 14.50           N  
ATOM   1647  CA  THR A 198      37.033 -14.598  32.633  1.00 13.60           C  
ATOM   1648  C   THR A 198      36.673 -13.739  31.424  1.00 14.22           C  
ATOM   1649  O   THR A 198      35.599 -13.886  30.881  1.00 15.42           O  
ATOM   1650  CB  THR A 198      36.746 -16.081  32.334  1.00 14.19           C  
ATOM   1651  OG1 THR A 198      37.129 -16.871  33.469  1.00 17.80           O  
ATOM   1652  CG2 THR A 198      37.541 -16.539  31.116  1.00 17.35           C  
ATOM   1653  N   PRO A 199      37.546 -12.803  31.039  1.00 13.59           N  
ATOM   1654  CA  PRO A 199      37.243 -11.985  29.843  1.00 14.14           C  
ATOM   1655  C   PRO A 199      37.316 -12.860  28.610  1.00 13.26           C  
ATOM   1656  O   PRO A 199      38.097 -13.832  28.585  1.00 12.95           O  
ATOM   1657  CB  PRO A 199      38.371 -10.950  29.828  1.00 15.37           C  
ATOM   1658  CG  PRO A 199      38.866 -10.908  31.293  1.00 18.16           C  
ATOM   1659  CD  PRO A 199      38.804 -12.378  31.679  1.00 16.67           C  
ATOM   1660  N   LEU A 200      36.503 -12.529  27.609  1.00 11.94           N  
ATOM   1661  CA  LEU A 200      36.375 -13.397  26.443  1.00 11.59           C  
ATOM   1662  C   LEU A 200      36.538 -12.583  25.161  1.00 11.31           C  
ATOM   1663  O   LEU A 200      35.965 -11.513  25.015  1.00 12.92           O  
ATOM   1664  CB  LEU A 200      35.007 -14.072  26.394  1.00 12.80           C  
ATOM   1665  CG  LEU A 200      34.730 -15.093  27.496  1.00 13.94           C  
ATOM   1666  CD1 LEU A 200      33.278 -15.535  27.346  1.00 16.52           C  
ATOM   1667  CD2 LEU A 200      35.726 -16.267  27.416  1.00 11.59           C  
ATOM   1668  N   SER A 201      37.326 -13.124  24.232  1.00 11.05           N  
ATOM   1669  CA  SER A 201      37.422 -12.519  22.903  1.00 11.54           C  
ATOM   1670  C   SER A 201      36.196 -12.874  22.040  1.00 11.00           C  
ATOM   1671  O   SER A 201      35.862 -14.084  21.917  1.00 12.16           O  
ATOM   1672  CB  SER A 201      38.682 -13.089  22.245  1.00 11.48           C  
ATOM   1673  OG  SER A 201      38.832 -12.576  20.924  1.00 11.87           O  
ATOM   1674  N   LEU A 202      35.571 -11.869  21.412  1.00 12.46           N  
ATOM   1675  CA  LEU A 202      34.364 -12.097  20.605  1.00 11.79           C  
ATOM   1676  C   LEU A 202      34.710 -12.891  19.358  1.00 12.93           C  
ATOM   1677  O   LEU A 202      33.981 -13.817  18.988  1.00 12.86           O  
ATOM   1678  CB  LEU A 202      33.684 -10.771  20.227  1.00 11.72           C  
ATOM   1679  CG  LEU A 202      32.613 -10.302  21.223  1.00 11.87           C  
ATOM   1680  CD1 LEU A 202      33.259  -9.896  22.553  1.00 15.12           C  
ATOM   1681  CD2 LEU A 202      31.908  -9.122  20.614  1.00 13.46           C  
ATOM   1682  N   PHE A 203      35.831 -12.537  18.743  1.00 12.83           N  
ATOM   1683  CA  PHE A 203      36.159 -13.087  17.405  1.00 11.77           C  
ATOM   1684  C   PHE A 203      37.319 -14.052  17.322  1.00 13.14           C  
ATOM   1685  O   PHE A 203      37.495 -14.730  16.290  1.00 13.41           O  
ATOM   1686  CB  PHE A 203      36.331 -11.947  16.406  1.00 12.64           C  
ATOM   1687  CG  PHE A 203      35.146 -11.024  16.361  1.00 12.09           C  
ATOM   1688  CD1 PHE A 203      33.882 -11.493  15.961  1.00 12.75           C  
ATOM   1689  CD2 PHE A 203      35.274  -9.707  16.795  1.00 14.43           C  
ATOM   1690  CE1 PHE A 203      32.757 -10.621  15.940  1.00 13.95           C  
ATOM   1691  CE2 PHE A 203      34.164  -8.834  16.769  1.00 14.19           C  
ATOM   1692  CZ  PHE A 203      32.924  -9.289  16.373  1.00 15.03           C  
ATOM   1693  N   GLY A 204      38.116 -14.133  18.383  1.00 11.78           N  
ATOM   1694  CA  GLY A 204      39.185 -15.108  18.489  1.00 12.29           C  
ATOM   1695  C   GLY A 204      40.557 -14.716  17.911  1.00 12.91           C  
ATOM   1696  O   GLY A 204      40.822 -13.578  17.521  1.00 13.12           O  
ATOM   1697  N   ASP A 205      41.428 -15.709  17.841  1.00 14.61           N  
ATOM   1698  CA  ASP A 205      42.837 -15.500  17.594  1.00 16.04           C  
ATOM   1699  C   ASP A 205      43.182 -15.355  16.112  1.00 17.92           C  
ATOM   1700  O   ASP A 205      44.312 -14.983  15.796  1.00 19.78           O  
ATOM   1701  CB  ASP A 205      43.599 -16.715  18.129  1.00 19.38           C  
ATOM   1702  CG  ASP A 205      42.964 -18.024  17.684  1.00 26.59           C  
ATOM   1703  OD1 ASP A 205      41.899 -18.386  18.244  1.00 39.70           O  
ATOM   1704  OD2 ASP A 205      43.514 -18.684  16.772  1.00 38.62           O  
ATOM   1705  N   THR A 206      42.227 -15.625  15.215  1.00 14.03           N  
ATOM   1706  CA  THR A 206      42.572 -15.578  13.782  1.00 13.99           C  
ATOM   1707  C   THR A 206      42.436 -14.182  13.146  1.00 14.20           C  
ATOM   1708  O   THR A 206      42.644 -14.024  11.933  1.00 14.84           O  
ATOM   1709  CB  THR A 206      41.770 -16.589  12.934  1.00 13.75           C  
ATOM   1710  OG1 THR A 206      40.405 -16.158  12.835  1.00 15.85           O  
ATOM   1711  CG2 THR A 206      41.859 -17.999  13.511  1.00 15.59           C  
ATOM   1712  N   TYR A 207      42.087 -13.179  13.954  1.00 12.38           N  
ATOM   1713  CA  TYR A 207      42.033 -11.792  13.499  1.00 11.28           C  
ATOM   1714  C   TYR A 207      43.079 -10.933  14.222  1.00 12.67           C  
ATOM   1715  O   TYR A 207      43.532 -11.290  15.325  1.00 13.84           O  
ATOM   1716  CB  TYR A 207      40.651 -11.204  13.759  1.00 12.39           C  
ATOM   1717  CG  TYR A 207      39.572 -11.927  12.968  1.00 12.63           C  
ATOM   1718  CD1 TYR A 207      39.265 -11.535  11.659  1.00 14.13           C  
ATOM   1719  CD2 TYR A 207      38.867 -12.992  13.527  1.00 13.31           C  
ATOM   1720  CE1 TYR A 207      38.280 -12.214  10.930  1.00 12.96           C  
ATOM   1721  CE2 TYR A 207      37.878 -13.649  12.813  1.00 12.62           C  
ATOM   1722  CZ  TYR A 207      37.578 -13.244  11.517  1.00 13.41           C  
ATOM   1723  OH  TYR A 207      36.585 -13.897  10.767  1.00 14.87           O  
ATOM   1724  N   GLU A 208      43.450  -9.822  13.584  1.00 11.24           N  
ATOM   1725  CA  GLU A 208      44.323  -8.840  14.219  1.00 11.79           C  
ATOM   1726  C   GLU A 208      43.588  -8.157  15.367  1.00 12.18           C  
ATOM   1727  O   GLU A 208      44.155  -7.988  16.468  1.00 12.16           O  
ATOM   1728  CB  GLU A 208      44.707  -7.771  13.200  1.00 11.06           C  
ATOM   1729  CG  GLU A 208      45.660  -6.696  13.777  1.00 11.96           C  
ATOM   1730  CD  GLU A 208      45.813  -5.469  12.866  1.00 13.30           C  
ATOM   1731  OE1 GLU A 208      46.502  -5.620  11.833  1.00 15.62           O  
ATOM   1732  OE2 GLU A 208      45.266  -4.380  13.188  1.00 13.47           O  
ATOM   1733  N   THR A 209      42.368  -7.701  15.081  1.00 10.10           N  
ATOM   1734  CA  THR A 209      41.570  -6.948  16.059  1.00 10.83           C  
ATOM   1735  C   THR A 209      41.247  -7.876  17.234  1.00 12.34           C  
ATOM   1736  O   THR A 209      41.035  -9.081  17.059  1.00 12.57           O  
ATOM   1737  CB  THR A 209      40.228  -6.510  15.406  1.00 12.13           C  
ATOM   1738  OG1 THR A 209      40.525  -5.683  14.282  1.00 12.00           O  
ATOM   1739  CG2 THR A 209      39.375  -5.711  16.414  1.00 13.61           C  
ATOM   1740  N   GLN A 210      41.225  -7.304  18.440  1.00 11.18           N  
ATOM   1741  CA  GLN A 210      40.665  -8.010  19.596  1.00 10.81           C  
ATOM   1742  C   GLN A 210      39.567  -7.166  20.161  1.00 12.14           C  
ATOM   1743  O   GLN A 210      39.807  -6.032  20.594  1.00 11.51           O  
ATOM   1744  CB  GLN A 210      41.734  -8.289  20.653  1.00 13.12           C  
ATOM   1745  CG  GLN A 210      42.711  -9.350  20.187  1.00 15.78           C  
ATOM   1746  CD  GLN A 210      42.041 -10.703  19.911  1.00 23.87           C  
ATOM   1747  OE1 GLN A 210      41.163 -11.159  20.673  1.00 21.82           O  
ATOM   1748  NE2 GLN A 210      42.437 -11.342  18.801  1.00 20.47           N  
ATOM   1749  N   VAL A 211      38.365  -7.724  20.159  1.00 11.67           N  
ATOM   1750  CA  VAL A 211      37.223  -7.113  20.865  1.00 12.40           C  
ATOM   1751  C   VAL A 211      36.997  -8.078  22.029  1.00 12.27           C  
ATOM   1752  O   VAL A 211      36.675  -9.247  21.815  1.00 13.13           O  
ATOM   1753  CB  VAL A 211      35.939  -7.019  19.995  1.00 11.83           C  
ATOM   1754  CG1 VAL A 211      34.837  -6.379  20.800  1.00 13.92           C  
ATOM   1755  CG2 VAL A 211      36.165  -6.187  18.700  1.00 12.47           C  
ATOM   1756  N   ILE A 212      37.156  -7.590  23.256  0.50 11.38           N  
ATOM   1758  CA  ILE A 212      37.118  -8.470  24.424  0.50 11.43           C  
ATOM   1760  C   ILE A 212      36.027  -7.973  25.358  0.50 11.42           C  
ATOM   1762  O   ILE A 212      35.945  -6.771  25.654  0.50 11.65           O  
ATOM   1764  CB  ILE A 212      38.479  -8.477  25.161  0.50 10.83           C  
ATOM   1766  CG1 ILE A 212      39.594  -8.930  24.201  0.50 14.27           C  
ATOM   1768  CG2 ILE A 212      38.430  -9.333  26.460  0.50 13.37           C  
ATOM   1770  CD1 ILE A 212      40.972  -8.637  24.698  0.50 13.76           C  
ATOM   1772  N   ALA A 213      35.209  -8.910  25.825  1.00 12.63           N  
ATOM   1773  CA  ALA A 213      34.131  -8.604  26.757  1.00 11.79           C  
ATOM   1774  C   ALA A 213      34.633  -8.917  28.181  1.00 12.27           C  
ATOM   1775  O   ALA A 213      35.382  -9.902  28.417  1.00 12.92           O  
ATOM   1776  CB  ALA A 213      32.880  -9.433  26.450  1.00 11.56           C  
ATOM   1777  N   TYR A 214      34.217  -8.056  29.118  1.00 12.43           N  
ATOM   1778  CA  TYR A 214      34.573  -8.196  30.525  1.00 12.18           C  
ATOM   1779  C   TYR A 214      33.346  -8.047  31.404  1.00 12.54           C  
ATOM   1780  O   TYR A 214      32.507  -7.145  31.187  1.00 13.99           O  
ATOM   1781  CB  TYR A 214      35.524  -7.079  30.951  1.00 12.25           C  
ATOM   1782  CG  TYR A 214      36.760  -6.886  30.111  1.00 11.80           C  
ATOM   1783  CD1 TYR A 214      38.003  -7.315  30.547  1.00 15.24           C  
ATOM   1784  CD2 TYR A 214      36.667  -6.248  28.863  1.00 11.98           C  
ATOM   1785  CE1 TYR A 214      39.139  -7.119  29.754  1.00 12.97           C  
ATOM   1786  CE2 TYR A 214      37.780  -6.034  28.073  1.00 12.51           C  
ATOM   1787  CZ  TYR A 214      39.010  -6.481  28.526  1.00 13.40           C  
ATOM   1788  OH  TYR A 214      40.123  -6.263  27.726  1.00 17.74           O  
ATOM   1789  N   GLY A 215      33.288  -8.903  32.421  1.00 12.38           N  
ATOM   1790  CA  GLY A 215      32.332  -8.710  33.500  1.00 12.87           C  
ATOM   1791  C   GLY A 215      33.034  -8.185  34.756  1.00 11.36           C  
ATOM   1792  O   GLY A 215      34.121  -7.606  34.703  1.00 11.19           O  
ATOM   1793  N   GLN A 216      32.408  -8.432  35.898  1.00 10.54           N  
ATOM   1794  CA  GLN A 216      32.922  -7.952  37.170  1.00 10.67           C  
ATOM   1795  C   GLN A 216      34.347  -8.476  37.372  1.00 12.77           C  
ATOM   1796  O   GLN A 216      34.656  -9.625  36.985  1.00 12.09           O  
ATOM   1797  CB  GLN A 216      32.021  -8.453  38.298  1.00 10.48           C  
ATOM   1798  CG  GLN A 216      32.472  -8.077  39.699  1.00 13.27           C  
ATOM   1799  CD  GLN A 216      31.470  -8.522  40.771  1.00 14.35           C  
ATOM   1800  OE1 GLN A 216      30.610  -9.394  40.530  1.00 18.43           O  
ATOM   1801  NE2 GLN A 216      31.588  -7.933  41.969  1.00 20.33           N  
ATOM   1802  N   GLY A 217      35.206  -7.647  37.957  1.00 13.02           N  
ATOM   1803  CA  GLY A 217      36.598  -8.032  38.195  1.00 12.33           C  
ATOM   1804  C   GLY A 217      37.556  -6.884  38.016  1.00 14.07           C  
ATOM   1805  O   GLY A 217      37.137  -5.764  37.776  1.00 14.95           O  
ATOM   1806  N   SER A 218      38.850  -7.157  38.116  1.00 14.68           N  
ATOM   1807  CA  SER A 218      39.847  -6.105  37.893  1.00 17.75           C  
ATOM   1808  C   SER A 218      40.937  -6.510  36.919  1.00 20.51           C  
ATOM   1809  O   SER A 218      41.203  -7.703  36.730  1.00 21.63           O  
ATOM   1810  CB  SER A 218      40.425  -5.605  39.210  1.00 18.63           C  
ATOM   1811  OG  SER A 218      41.074  -6.646  39.898  1.00 25.93           O  
ATOM   1812  N   SER A 219      41.531  -5.498  36.278  1.00 19.86           N  
ATOM   1813  CA  SER A 219      42.546  -5.663  35.237  1.00 22.32           C  
ATOM   1814  C   SER A 219      43.620  -4.622  35.459  1.00 24.01           C  
ATOM   1815  O   SER A 219      43.381  -3.580  36.065  1.00 23.22           O  
ATOM   1816  CB  SER A 219      41.975  -5.391  33.834  1.00 21.36           C  
ATOM   1817  OG  SER A 219      41.036  -6.344  33.398  1.00 27.80           O  
ATOM   1818  N   GLU A 220      44.812  -4.915  34.961  1.00 27.22           N  
ATOM   1819  CA  GLU A 220      45.811  -3.887  34.766  1.00 29.41           C  
ATOM   1820  C   GLU A 220      46.095  -3.757  33.273  1.00 30.08           C  
ATOM   1821  O   GLU A 220      46.178  -4.759  32.548  1.00 29.29           O  
ATOM   1822  CB  GLU A 220      47.079  -4.168  35.570  1.00 30.09           C  
ATOM   1823  CG  GLU A 220      47.962  -2.931  35.710  1.00 37.60           C  
ATOM   1824  CD  GLU A 220      48.555  -2.763  37.101  1.00 46.86           C  
ATOM   1825  OE1 GLU A 220      47.890  -3.141  38.100  1.00 49.21           O  
ATOM   1826  OE2 GLU A 220      49.690  -2.230  37.195  1.00 49.21           O  
ATOM   1827  N   GLY A 221      46.196  -2.514  32.810  1.00 31.04           N  
ATOM   1828  CA  GLY A 221      46.553  -2.225  31.427  1.00 29.83           C  
ATOM   1829  C   GLY A 221      47.975  -1.708  31.354  1.00 29.65           C  
ATOM   1830  O   GLY A 221      48.330  -0.691  31.961  1.00 28.29           O  
ATOM   1831  N   LEU A 222      48.807  -2.411  30.603  1.00 30.92           N  
ATOM   1832  CA  LEU A 222      50.191  -1.997  30.486  1.00 30.67           C  
ATOM   1833  C   LEU A 222      50.298  -0.906  29.431  1.00 29.54           C  
ATOM   1834  O   LEU A 222      49.485  -0.857  28.508  1.00 29.51           O  
ATOM   1835  CB  LEU A 222      51.094  -3.186  30.126  1.00 31.75           C  
ATOM   1836  CG  LEU A 222      52.506  -3.109  30.712  1.00 34.50           C  
ATOM   1837  CD1 LEU A 222      52.519  -3.759  32.104  1.00 34.93           C  
ATOM   1838  CD2 LEU A 222      53.556  -3.739  29.777  1.00 32.68           C  
ATOM   1839  N   ARG A 223      51.284  -0.026  29.592  1.00 29.18           N  
ATOM   1840  CA  ARG A 223      51.663   0.913  28.545  1.00 29.36           C  
ATOM   1841  C   ARG A 223      51.895   0.151  27.231  1.00 27.63           C  
ATOM   1842  O   ARG A 223      52.890  -0.562  27.096  1.00 28.33           O  
ATOM   1843  CB  ARG A 223      52.950   1.651  28.928  1.00 28.74           C  
ATOM   1844  CG  ARG A 223      52.806   2.733  29.985  1.00 32.04           C  
ATOM   1845  CD  ARG A 223      54.136   3.444  30.233  1.00 31.30           C  
ATOM   1846  NE  ARG A 223      54.876   3.654  28.986  1.00 39.07           N  
ATOM   1847  CZ  ARG A 223      55.052   4.829  28.382  1.00 41.11           C  
ATOM   1848  NH1 ARG A 223      54.558   5.943  28.908  1.00 44.40           N  
ATOM   1849  NH2 ARG A 223      55.737   4.890  27.246  1.00 41.25           N  
ATOM   1850  N   GLN A 224      50.967   0.277  26.283  1.00 26.21           N  
ATOM   1851  CA  GLN A 224      51.149  -0.284  24.939  1.00 22.79           C  
ATOM   1852  C   GLN A 224      51.407   0.850  23.979  1.00 21.24           C  
ATOM   1853  O   GLN A 224      51.091   1.996  24.301  1.00 21.98           O  
ATOM   1854  CB  GLN A 224      49.895  -1.008  24.469  1.00 23.54           C  
ATOM   1855  CG  GLN A 224      49.386  -2.099  25.343  1.00 24.93           C  
ATOM   1856  CD  GLN A 224      48.317  -2.886  24.631  1.00 27.19           C  
ATOM   1857  OE1 GLN A 224      47.121  -2.753  24.918  1.00 27.60           O  
ATOM   1858  NE2 GLN A 224      48.737  -3.688  23.654  1.00 24.99           N  
ATOM   1859  N   ASN A 225      51.955   0.538  22.800  1.00 16.65           N  
ATOM   1860  CA  ASN A 225      52.155   1.544  21.754  1.00 15.10           C  
ATOM   1861  C   ASN A 225      50.956   1.602  20.796  1.00 13.80           C  
ATOM   1862  O   ASN A 225      51.049   2.153  19.708  1.00 13.07           O  
ATOM   1863  CB  ASN A 225      53.470   1.338  20.990  1.00 17.04           C  
ATOM   1864  CG  ASN A 225      53.530   0.010  20.257  1.00 21.30           C  
ATOM   1865  OD1 ASN A 225      52.545  -0.742  20.200  1.00 22.57           O  
ATOM   1866  ND2 ASN A 225      54.707  -0.292  19.688  1.00 23.14           N  
ATOM   1867  N   VAL A 226      49.830   1.055  21.249  1.00 14.51           N  
ATOM   1868  CA  VAL A 226      48.552   1.202  20.547  1.00 14.50           C  
ATOM   1869  C   VAL A 226      47.449   1.711  21.506  1.00 14.19           C  
ATOM   1870  O   VAL A 226      47.559   1.576  22.731  1.00 15.17           O  
ATOM   1871  CB  VAL A 226      48.081  -0.126  19.879  1.00 16.74           C  
ATOM   1872  CG1 VAL A 226      49.168  -0.637  18.913  1.00 16.78           C  
ATOM   1873  CG2 VAL A 226      47.820  -1.184  20.938  1.00 17.03           C  
ATOM   1874  N   ASP A 227      46.416   2.311  20.932  1.00 12.35           N  
ATOM   1875  CA  ASP A 227      45.268   2.804  21.721  1.00 12.17           C  
ATOM   1876  C   ASP A 227      44.405   1.636  22.133  1.00 14.45           C  
ATOM   1877  O   ASP A 227      44.441   0.563  21.500  1.00 15.24           O  
ATOM   1878  CB  ASP A 227      44.413   3.752  20.877  1.00 13.59           C  
ATOM   1879  CG  ASP A 227      45.105   5.058  20.524  1.00 12.00           C  
ATOM   1880  OD1 ASP A 227      46.134   5.440  21.127  1.00 12.94           O  
ATOM   1881  OD2 ASP A 227      44.572   5.758  19.624  1.00 13.03           O  
ATOM   1882  N   VAL A 228      43.593   1.836  23.161  1.00 13.02           N  
ATOM   1883  CA  VAL A 228      42.539   0.880  23.489  1.00 14.13           C  
ATOM   1884  C   VAL A 228      41.273   1.691  23.693  1.00 15.33           C  
ATOM   1885  O   VAL A 228      41.316   2.710  24.379  1.00 16.20           O  
ATOM   1886  CB  VAL A 228      42.850   0.093  24.789  1.00 14.59           C  
ATOM   1887  CG1 VAL A 228      41.685  -0.856  25.155  1.00 16.03           C  
ATOM   1888  CG2 VAL A 228      44.168  -0.681  24.686  1.00 17.47           C  
ATOM   1889  N   TRP A 229      40.166   1.255  23.098  1.00 12.67           N  
ATOM   1890  CA  TRP A 229      38.886   1.931  23.337  1.00 13.76           C  
ATOM   1891  C   TRP A 229      38.025   1.030  24.211  1.00 15.34           C  
ATOM   1892  O   TRP A 229      37.746  -0.122  23.880  1.00 15.80           O  
ATOM   1893  CB  TRP A 229      38.172   2.234  22.021  1.00 14.98           C  
ATOM   1894  CG  TRP A 229      36.986   3.098  22.163  1.00 13.27           C  
ATOM   1895  CD1 TRP A 229      36.969   4.370  22.647  1.00 14.66           C  
ATOM   1896  CD2 TRP A 229      35.619   2.784  21.803  1.00 14.01           C  
ATOM   1897  NE1 TRP A 229      35.684   4.870  22.621  1.00 14.19           N  
ATOM   1898  CE2 TRP A 229      34.834   3.911  22.115  1.00 14.27           C  
ATOM   1899  CE3 TRP A 229      34.987   1.645  21.240  1.00 13.99           C  
ATOM   1900  CZ2 TRP A 229      33.442   3.965  21.866  1.00 13.77           C  
ATOM   1901  CZ3 TRP A 229      33.615   1.674  21.032  1.00 15.03           C  
ATOM   1902  CH2 TRP A 229      32.843   2.815  21.349  1.00 16.19           C  
ATOM   1903  N   LEU A 230      37.598   1.559  25.356  1.00 14.56           N  
ATOM   1904  CA  LEU A 230      36.743   0.821  26.265  1.00 14.36           C  
ATOM   1905  C   LEU A 230      35.312   1.331  26.135  1.00 13.89           C  
ATOM   1906  O   LEU A 230      35.089   2.521  26.011  1.00 14.56           O  
ATOM   1907  CB  LEU A 230      37.191   1.088  27.718  1.00 14.21           C  
ATOM   1908  CG  LEU A 230      38.655   0.825  28.083  1.00 14.37           C  
ATOM   1909  CD1 LEU A 230      38.871   1.045  29.587  1.00 15.83           C  
ATOM   1910  CD2 LEU A 230      39.018  -0.610  27.722  1.00 16.01           C  
ATOM   1911  N   TRP A 231      34.345   0.421  26.219  1.00 13.66           N  
ATOM   1912  CA  TRP A 231      32.947   0.837  26.203  1.00 14.67           C  
ATOM   1913  C   TRP A 231      32.218   0.077  27.308  1.00 15.59           C  
ATOM   1914  O   TRP A 231      32.075  -1.141  27.260  1.00 15.17           O  
ATOM   1915  CB  TRP A 231      32.305   0.594  24.835  1.00 15.24           C  
ATOM   1916  CG  TRP A 231      30.934   1.145  24.673  1.00 14.61           C  
ATOM   1917  CD1 TRP A 231      30.216   1.913  25.551  1.00 15.39           C  
ATOM   1918  CD2 TRP A 231      30.085   0.966  23.521  1.00 16.63           C  
ATOM   1919  NE1 TRP A 231      28.975   2.201  25.020  1.00 16.05           N  
ATOM   1920  CE2 TRP A 231      28.867   1.619  23.783  1.00 20.84           C  
ATOM   1921  CE3 TRP A 231      30.242   0.279  22.307  1.00 16.93           C  
ATOM   1922  CZ2 TRP A 231      27.791   1.639  22.860  1.00 17.48           C  
ATOM   1923  CZ3 TRP A 231      29.189   0.315  21.384  1.00 16.11           C  
ATOM   1924  CH2 TRP A 231      27.976   0.975  21.661  1.00 17.83           C  
ATOM   1925  N   GLN A 232      31.763   0.844  28.324  1.00 13.87           N  
ATOM   1926  CA  GLN A 232      31.068   0.242  29.467  1.00 14.81           C  
ATOM   1927  C   GLN A 232      29.617   0.104  29.051  1.00 15.35           C  
ATOM   1928  O   GLN A 232      28.893   1.070  28.963  1.00 16.90           O  
ATOM   1929  CB  GLN A 232      31.223   1.168  30.711  1.00 14.28           C  
ATOM   1930  CG  GLN A 232      30.701   0.490  32.029  1.00 14.57           C  
ATOM   1931  CD  GLN A 232      31.562  -0.719  32.402  1.00 18.35           C  
ATOM   1932  OE1 GLN A 232      32.768  -0.593  32.522  1.00 16.54           O  
ATOM   1933  NE2 GLN A 232      30.954  -1.910  32.511  1.00 16.36           N  
ATOM   1934  N   LEU A 233      29.186  -1.115  28.716  1.00 14.36           N  
ATOM   1935  CA  LEU A 233      27.836  -1.288  28.146  1.00 15.22           C  
ATOM   1936  C   LEU A 233      26.748  -1.196  29.217  1.00 16.34           C  
ATOM   1937  O   LEU A 233      25.720  -0.520  29.036  1.00 19.10           O  
ATOM   1938  CB  LEU A 233      27.733  -2.649  27.440  1.00 13.96           C  
ATOM   1939  CG  LEU A 233      28.727  -2.832  26.295  1.00 16.88           C  
ATOM   1940  CD1 LEU A 233      28.519  -4.217  25.643  1.00 15.46           C  
ATOM   1941  CD2 LEU A 233      28.553  -1.752  25.235  1.00 17.54           C  
ATOM   1942  N   GLU A 234      26.967  -1.895  30.317  1.00 16.05           N  
ATOM   1943  CA  GLU A 234      25.997  -1.987  31.410  1.00 17.53           C  
ATOM   1944  C   GLU A 234      26.816  -1.967  32.659  1.00 16.15           C  
ATOM   1945  O   GLU A 234      28.001  -2.444  32.681  1.00 15.00           O  
ATOM   1946  CB  GLU A 234      25.330  -3.373  31.426  1.00 18.05           C  
ATOM   1947  CG  GLU A 234      24.700  -3.776  30.171  1.00 25.57           C  
ATOM   1948  CD  GLU A 234      23.682  -4.858  30.420  1.00 25.40           C  
ATOM   1949  OE1 GLU A 234      23.907  -5.991  29.974  1.00 28.74           O  
ATOM   1950  OE2 GLU A 234      22.662  -4.552  31.054  1.00 25.04           O  
ATOM   1951  N   GLY A 235      26.190  -1.500  33.751  1.00 14.88           N  
ATOM   1952  CA  GLY A 235      26.893  -1.380  35.022  1.00 15.70           C  
ATOM   1953  C   GLY A 235      27.995  -0.321  34.966  1.00 15.04           C  
ATOM   1954  O   GLY A 235      28.045   0.487  34.022  1.00 15.21           O  
ATOM   1955  N   SER A 236      28.865  -0.350  35.992  1.00 15.96           N  
ATOM   1956  CA  SER A 236      29.881   0.708  36.147  1.00 15.46           C  
ATOM   1957  C   SER A 236      31.278   0.154  36.390  1.00 15.18           C  
ATOM   1958  O   SER A 236      31.469  -1.002  36.782  1.00 15.75           O  
ATOM   1959  CB  SER A 236      29.537   1.622  37.334  1.00 17.53           C  
ATOM   1960  OG  SER A 236      28.303   2.272  37.110  1.00 21.69           O  
ATOM   1961  N   SER A 237      32.264   1.000  36.173  1.00 13.74           N  
ATOM   1962  CA  SER A 237      33.648   0.645  36.485  1.00 13.51           C  
ATOM   1963  C   SER A 237      34.421   1.874  36.849  1.00 14.20           C  
ATOM   1964  O   SER A 237      33.905   2.989  36.734  1.00 14.11           O  
ATOM   1965  CB  SER A 237      34.309  -0.074  35.288  1.00 14.23           C  
ATOM   1966  OG  SER A 237      34.373   0.765  34.145  1.00 14.07           O  
ATOM   1967  N   VAL A 238      35.654   1.683  37.301  1.00 12.95           N  
ATOM   1968  CA  VAL A 238      36.541   2.797  37.610  1.00 12.87           C  
ATOM   1969  C   VAL A 238      37.875   2.530  36.945  1.00 14.32           C  
ATOM   1970  O   VAL A 238      38.462   1.435  37.095  1.00 13.65           O  
ATOM   1971  CB  VAL A 238      36.747   2.975  39.131  1.00 14.06           C  
ATOM   1972  CG1 VAL A 238      37.782   4.065  39.394  1.00 11.43           C  
ATOM   1973  CG2 VAL A 238      35.391   3.322  39.800  1.00 15.62           C  
ATOM   1974  N   VAL A 239      38.366   3.545  36.230  1.00 12.72           N  
ATOM   1975  CA  VAL A 239      39.654   3.458  35.561  1.00 13.36           C  
ATOM   1976  C   VAL A 239      40.627   4.335  36.346  1.00 13.76           C  
ATOM   1977  O   VAL A 239      40.311   5.488  36.687  1.00 14.33           O  
ATOM   1978  CB  VAL A 239      39.565   3.907  34.073  1.00 11.23           C  
ATOM   1979  CG1 VAL A 239      41.002   4.044  33.486  1.00 12.99           C  
ATOM   1980  CG2 VAL A 239      38.701   2.931  33.255  1.00 13.45           C  
ATOM   1981  N   THR A 240      41.796   3.789  36.689  1.00 13.13           N  
ATOM   1982  CA  THR A 240      42.824   4.594  37.351  1.00 13.66           C  
ATOM   1983  C   THR A 240      43.931   4.873  36.346  1.00 14.95           C  
ATOM   1984  O   THR A 240      44.500   3.941  35.777  1.00 14.90           O  
ATOM   1985  CB  THR A 240      43.405   3.887  38.608  1.00 14.79           C  
ATOM   1986  OG1 THR A 240      42.327   3.561  39.484  1.00 14.14           O  
ATOM   1987  CG2 THR A 240      44.386   4.797  39.340  1.00 15.70           C  
HETATM 1988  N   MSE A 241      44.227   6.162  36.142  1.00 16.53           N  
HETATM 1989  CA  MSE A 241      45.045   6.617  35.022  1.00 18.35           C  
HETATM 1990  C   MSE A 241      45.489   8.045  35.275  1.00 18.52           C  
HETATM 1991  O   MSE A 241      44.679   8.893  35.665  1.00 19.76           O  
HETATM 1992  CB  MSE A 241      44.184   6.537  33.749  1.00 18.32           C  
HETATM 1993  CG  MSE A 241      44.715   7.113  32.498  1.00 26.88           C  
HETATM 1994 SE   MSE A 241      43.363   6.686  31.164  1.00 20.65          SE  
HETATM 1995  CE  MSE A 241      42.392   8.370  31.048  1.00 24.23           C  
ATOM   1996  N   GLY A 242      46.776   8.301  35.068  1.00 19.21           N  
ATOM   1997  CA  GLY A 242      47.328   9.650  35.180  1.00 20.05           C  
ATOM   1998  C   GLY A 242      47.180  10.262  36.558  1.00 20.70           C  
ATOM   1999  O   GLY A 242      47.106  11.484  36.689  1.00 23.22           O  
ATOM   2000  N   GLY A 243      47.161   9.422  37.591  1.00 20.10           N  
ATOM   2001  CA  GLY A 243      47.067   9.889  38.982  1.00 19.64           C  
ATOM   2002  C   GLY A 243      45.651  10.211  39.426  1.00 20.08           C  
ATOM   2003  O   GLY A 243      45.440  10.814  40.484  1.00 19.98           O  
ATOM   2004  N   ARG A 244      44.678   9.815  38.611  1.00 18.99           N  
ATOM   2005  CA  ARG A 244      43.275  10.110  38.874  1.00 19.92           C  
ATOM   2006  C   ARG A 244      42.459   8.832  38.760  1.00 18.42           C  
ATOM   2007  O   ARG A 244      42.836   7.903  38.037  1.00 19.02           O  
ATOM   2008  CB  ARG A 244      42.752  11.167  37.884  1.00 19.74           C  
ATOM   2009  CG  ARG A 244      43.370  12.577  38.076  1.00 21.58           C  
ATOM   2010  CD  ARG A 244      43.068  13.496  36.882  1.00 22.03           C  
ATOM   2011  NE  ARG A 244      41.655  13.893  36.848  1.00 25.97           N  
ATOM   2012  CZ  ARG A 244      41.021  14.391  35.785  1.00 27.44           C  
ATOM   2013  NH1 ARG A 244      39.734  14.716  35.880  1.00 22.88           N  
ATOM   2014  NH2 ARG A 244      41.660  14.547  34.624  1.00 22.47           N  
ATOM   2015  N   ARG A 245      41.350   8.779  39.487  1.00 17.94           N  
ATOM   2016  CA  ARG A 245      40.369   7.731  39.286  1.00 16.36           C  
ATOM   2017  C   ARG A 245      39.212   8.381  38.547  1.00 15.46           C  
ATOM   2018  O   ARG A 245      38.805   9.506  38.880  1.00 16.37           O  
ATOM   2019  CB  ARG A 245      39.893   7.156  40.629  1.00 17.65           C  
ATOM   2020  CG  ARG A 245      40.982   6.359  41.368  1.00 16.24           C  
ATOM   2021  CD  ARG A 245      40.641   6.065  42.833  1.00 17.96           C  
ATOM   2022  NE  ARG A 245      39.347   5.422  43.047  1.00 28.52           N  
ATOM   2023  CZ  ARG A 245      39.122   4.114  42.935  1.00 30.87           C  
ATOM   2024  NH1 ARG A 245      40.111   3.288  42.604  1.00 32.92           N  
ATOM   2025  NH2 ARG A 245      37.905   3.631  43.166  1.00 32.04           N  
ATOM   2026  N   LEU A 246      38.703   7.700  37.529  1.00 12.41           N  
ATOM   2027  CA  LEU A 246      37.521   8.186  36.830  1.00 14.66           C  
ATOM   2028  C   LEU A 246      36.513   7.075  36.680  1.00 14.24           C  
ATOM   2029  O   LEU A 246      36.889   5.934  36.400  1.00 14.66           O  
ATOM   2030  CB  LEU A 246      37.895   8.793  35.455  1.00 14.76           C  
ATOM   2031  CG  LEU A 246      38.407   7.905  34.320  1.00 15.86           C  
ATOM   2032  CD1 LEU A 246      37.245   7.265  33.545  1.00 23.82           C  
ATOM   2033  CD2 LEU A 246      39.319   8.646  33.331  1.00 19.98           C  
ATOM   2034  N   SER A 247      35.236   7.398  36.853  1.00 11.63           N  
ATOM   2035  CA  SER A 247      34.208   6.371  36.706  1.00 13.25           C  
ATOM   2036  C   SER A 247      33.729   6.268  35.264  1.00 13.29           C  
ATOM   2037  O   SER A 247      33.644   7.276  34.560  1.00 13.98           O  
ATOM   2038  CB  SER A 247      33.023   6.637  37.627  1.00 14.70           C  
ATOM   2039  OG  SER A 247      32.400   7.848  37.338  1.00 17.76           O  
ATOM   2040  N   LEU A 248      33.452   5.041  34.832  1.00 13.57           N  
ATOM   2041  CA  LEU A 248      32.678   4.814  33.615  1.00 13.51           C  
ATOM   2042  C   LEU A 248      31.308   4.330  34.093  1.00 13.27           C  
ATOM   2043  O   LEU A 248      31.177   3.231  34.641  1.00 14.82           O  
ATOM   2044  CB  LEU A 248      33.316   3.752  32.712  1.00 13.91           C  
ATOM   2045  CG  LEU A 248      34.730   4.116  32.245  1.00 14.69           C  
ATOM   2046  CD1 LEU A 248      35.256   2.969  31.308  1.00 14.51           C  
ATOM   2047  CD2 LEU A 248      34.810   5.493  31.538  1.00 15.48           C  
ATOM   2048  N   ALA A 249      30.312   5.174  33.887  1.00 13.64           N  
ATOM   2049  CA  ALA A 249      28.930   4.838  34.126  1.00 13.94           C  
ATOM   2050  C   ALA A 249      28.390   4.035  32.945  1.00 14.30           C  
ATOM   2051  O   ALA A 249      29.041   3.953  31.894  1.00 14.50           O  
ATOM   2052  CB  ALA A 249      28.126   6.141  34.269  1.00 14.56           C  
ATOM   2053  N   PRO A 250      27.209   3.441  33.106  1.00 14.53           N  
ATOM   2054  CA  PRO A 250      26.641   2.723  31.964  1.00 14.23           C  
ATOM   2055  C   PRO A 250      26.632   3.633  30.719  1.00 13.45           C  
ATOM   2056  O   PRO A 250      26.194   4.811  30.727  1.00 14.43           O  
ATOM   2057  CB  PRO A 250      25.186   2.468  32.394  1.00 15.64           C  
ATOM   2058  CG  PRO A 250      25.298   2.292  33.875  1.00 16.36           C  
ATOM   2059  CD  PRO A 250      26.342   3.354  34.302  1.00 16.12           C  
ATOM   2060  N   ASP A 251      27.136   3.036  29.631  1.00 13.89           N  
ATOM   2061  CA  ASP A 251      27.248   3.640  28.310  1.00 14.03           C  
ATOM   2062  C   ASP A 251      28.435   4.597  28.115  1.00 14.58           C  
ATOM   2063  O   ASP A 251      28.647   5.109  26.999  1.00 14.83           O  
ATOM   2064  CB  ASP A 251      25.935   4.268  27.826  1.00 15.34           C  
ATOM   2065  CG  ASP A 251      25.891   4.429  26.312  1.00 19.25           C  
ATOM   2066  OD1 ASP A 251      26.205   3.448  25.586  1.00 17.98           O  
ATOM   2067  OD2 ASP A 251      25.546   5.534  25.854  1.00 16.49           O  
ATOM   2068  N   ASP A 252      29.251   4.788  29.158  1.00 14.20           N  
ATOM   2069  CA  ASP A 252      30.472   5.603  28.948  1.00 13.38           C  
ATOM   2070  C   ASP A 252      31.511   4.790  28.189  1.00 11.63           C  
ATOM   2071  O   ASP A 252      31.630   3.587  28.377  1.00 14.40           O  
ATOM   2072  CB  ASP A 252      31.080   5.994  30.296  1.00 13.48           C  
ATOM   2073  CG  ASP A 252      30.409   7.212  30.911  1.00 14.03           C  
ATOM   2074  OD1 ASP A 252      29.656   7.971  30.239  1.00 14.32           O  
ATOM   2075  OD2 ASP A 252      30.681   7.410  32.119  1.00 14.12           O  
ATOM   2076  N   SER A 253      32.250   5.510  27.369  1.00 12.75           N  
ATOM   2077  CA  SER A 253      33.397   4.955  26.652  1.00 13.41           C  
ATOM   2078  C   SER A 253      34.637   5.761  26.991  1.00 13.63           C  
ATOM   2079  O   SER A 253      34.529   6.928  27.420  1.00 14.01           O  
ATOM   2080  CB  SER A 253      33.119   4.972  25.151  1.00 14.77           C  
ATOM   2081  OG  SER A 253      33.000   6.285  24.634  1.00 14.18           O  
ATOM   2082  N   LEU A 254      35.812   5.155  26.823  1.00 13.52           N  
ATOM   2083  CA  LEU A 254      37.077   5.854  27.115  1.00 12.19           C  
ATOM   2084  C   LEU A 254      38.149   5.406  26.129  1.00 13.37           C  
ATOM   2085  O   LEU A 254      38.373   4.202  25.979  1.00 14.79           O  
ATOM   2086  CB  LEU A 254      37.542   5.513  28.542  1.00 13.17           C  
ATOM   2087  CG  LEU A 254      38.886   6.120  28.972  1.00 12.42           C  
ATOM   2088  CD1 LEU A 254      38.810   7.618  29.106  1.00 13.44           C  
ATOM   2089  CD2 LEU A 254      39.315   5.478  30.275  1.00 12.87           C  
ATOM   2090  N   LEU A 255      38.738   6.366  25.426  1.00 12.73           N  
ATOM   2091  CA  LEU A 255      39.940   6.049  24.651  1.00 12.74           C  
ATOM   2092  C   LEU A 255      41.161   6.198  25.562  1.00 12.91           C  
ATOM   2093  O   LEU A 255      41.431   7.294  26.057  1.00 12.04           O  
ATOM   2094  CB  LEU A 255      40.076   7.006  23.450  1.00 12.94           C  
ATOM   2095  CG  LEU A 255      41.198   6.573  22.506  1.00 14.36           C  
ATOM   2096  CD1 LEU A 255      40.735   5.345  21.703  1.00 14.67           C  
ATOM   2097  CD2 LEU A 255      41.602   7.723  21.578  1.00 19.34           C  
ATOM   2098  N   VAL A 256      41.871   5.079  25.778  1.00 13.37           N  
ATOM   2099  CA  VAL A 256      43.124   5.072  26.519  1.00 12.80           C  
ATOM   2100  C   VAL A 256      44.237   5.181  25.470  1.00 13.24           C  
ATOM   2101  O   VAL A 256      44.520   4.217  24.727  1.00 13.90           O  
ATOM   2102  CB  VAL A 256      43.287   3.793  27.325  1.00 13.33           C  
ATOM   2103  CG1 VAL A 256      44.612   3.803  28.074  1.00 13.69           C  
ATOM   2104  CG2 VAL A 256      42.095   3.564  28.284  1.00 14.63           C  
ATOM   2105  N   LEU A 257      44.841   6.357  25.396  1.00 10.92           N  
ATOM   2106  CA  LEU A 257      45.894   6.622  24.411  1.00 10.76           C  
ATOM   2107  C   LEU A 257      47.131   5.731  24.619  1.00 11.93           C  
ATOM   2108  O   LEU A 257      47.568   5.496  25.743  1.00 12.50           O  
ATOM   2109  CB  LEU A 257      46.307   8.109  24.460  1.00 13.04           C  
ATOM   2110  CG  LEU A 257      45.226   9.074  23.952  1.00 13.99           C  
ATOM   2111  CD1 LEU A 257      45.598  10.495  24.358  1.00 18.12           C  
ATOM   2112  CD2 LEU A 257      45.169   8.990  22.408  1.00 16.99           C  
ATOM   2113  N   ALA A 258      47.714   5.263  23.518  1.00 11.61           N  
ATOM   2114  CA  ALA A 258      49.022   4.592  23.548  1.00 12.01           C  
ATOM   2115  C   ALA A 258      50.002   5.292  24.486  1.00 13.43           C  
ATOM   2116  O   ALA A 258      50.155   6.520  24.420  1.00 13.39           O  
ATOM   2117  CB  ALA A 258      49.615   4.568  22.130  1.00 12.75           C  
ATOM   2118  N   GLY A 259      50.688   4.518  25.330  1.00 13.30           N  
ATOM   2119  CA  GLY A 259      51.673   5.072  26.247  1.00 14.21           C  
ATOM   2120  C   GLY A 259      51.157   5.279  27.664  1.00 15.01           C  
ATOM   2121  O   GLY A 259      51.928   5.690  28.536  1.00 15.41           O  
ATOM   2122  N   THR A 260      49.876   4.985  27.889  1.00 15.32           N  
ATOM   2123  CA  THR A 260      49.220   5.202  29.184  1.00 14.82           C  
ATOM   2124  C   THR A 260      49.151   3.925  30.015  1.00 16.44           C  
ATOM   2125  O   THR A 260      48.627   2.916  29.546  1.00 18.53           O  
ATOM   2126  CB  THR A 260      47.792   5.709  28.962  1.00 17.26           C  
ATOM   2127  OG1 THR A 260      47.829   6.863  28.121  1.00 19.71           O  
ATOM   2128  CG2 THR A 260      47.133   6.082  30.307  1.00 16.96           C  
ATOM   2129  N   SER A 261      49.668   3.970  31.242  1.00 17.31           N  
ATOM   2130  CA  SER A 261      49.440   2.899  32.211  1.00 19.69           C  
ATOM   2131  C   SER A 261      48.038   3.097  32.814  1.00 19.96           C  
ATOM   2132  O   SER A 261      47.650   4.227  33.149  1.00 19.93           O  
ATOM   2133  CB  SER A 261      50.463   2.942  33.341  1.00 18.46           C  
ATOM   2134  OG  SER A 261      51.773   3.162  32.872  1.00 25.30           O  
ATOM   2135  N   TYR A 262      47.283   2.013  32.965  1.00 19.10           N  
ATOM   2136  CA  TYR A 262      45.997   2.115  33.649  1.00 20.11           C  
ATOM   2137  C   TYR A 262      45.604   0.837  34.408  1.00 21.18           C  
ATOM   2138  O   TYR A 262      46.170  -0.243  34.177  1.00 22.01           O  
ATOM   2139  CB  TYR A 262      44.906   2.546  32.667  1.00 21.16           C  
ATOM   2140  CG  TYR A 262      44.520   1.491  31.658  1.00 20.09           C  
ATOM   2141  CD1 TYR A 262      43.356   0.750  31.836  1.00 25.76           C  
ATOM   2142  CD2 TYR A 262      45.314   1.230  30.528  1.00 22.76           C  
ATOM   2143  CE1 TYR A 262      42.974  -0.226  30.917  1.00 27.61           C  
ATOM   2144  CE2 TYR A 262      44.941   0.254  29.603  1.00 24.97           C  
ATOM   2145  CZ  TYR A 262      43.772  -0.464  29.808  1.00 26.18           C  
ATOM   2146  OH  TYR A 262      43.373  -1.441  28.920  1.00 29.95           O  
ATOM   2147  N   ALA A 263      44.681   0.994  35.352  1.00 18.87           N  
ATOM   2148  CA  ALA A 263      44.053  -0.122  36.047  1.00 16.40           C  
ATOM   2149  C   ALA A 263      42.545   0.044  35.873  1.00 15.66           C  
ATOM   2150  O   ALA A 263      42.045   1.148  35.629  1.00 15.84           O  
ATOM   2151  CB  ALA A 263      44.444  -0.124  37.516  1.00 16.44           C  
ATOM   2152  N   TRP A 264      41.812  -1.062  35.986  1.00 14.22           N  
ATOM   2153  CA  TRP A 264      40.392  -1.058  35.666  1.00 13.26           C  
ATOM   2154  C   TRP A 264      39.674  -1.981  36.638  1.00 14.69           C  
ATOM   2155  O   TRP A 264      40.052  -3.143  36.782  1.00 15.75           O  
ATOM   2156  CB  TRP A 264      40.220  -1.555  34.234  1.00 13.81           C  
ATOM   2157  CG  TRP A 264      38.891  -1.319  33.663  1.00 13.34           C  
ATOM   2158  CD1 TRP A 264      37.904  -0.466  34.127  1.00 13.65           C  
ATOM   2159  CD2 TRP A 264      38.379  -1.921  32.469  1.00 14.28           C  
ATOM   2160  NE1 TRP A 264      36.811  -0.517  33.283  1.00 13.95           N  
ATOM   2161  CE2 TRP A 264      37.077  -1.399  32.261  1.00 14.41           C  
ATOM   2162  CE3 TRP A 264      38.890  -2.855  31.551  1.00 16.87           C  
ATOM   2163  CZ2 TRP A 264      36.275  -1.781  31.182  1.00 16.51           C  
ATOM   2164  CZ3 TRP A 264      38.079  -3.233  30.461  1.00 13.20           C  
ATOM   2165  CH2 TRP A 264      36.785  -2.686  30.288  1.00 14.97           C  
ATOM   2166  N   GLU A 265      38.709  -1.432  37.366  1.00 13.46           N  
ATOM   2167  CA  GLU A 265      37.963  -2.195  38.391  1.00 14.65           C  
ATOM   2168  C   GLU A 265      36.489  -2.162  38.001  1.00 13.83           C  
ATOM   2169  O   GLU A 265      35.898  -1.092  37.910  1.00 13.84           O  
ATOM   2170  CB  GLU A 265      38.150  -1.566  39.763  1.00 13.70           C  
ATOM   2171  CG  GLU A 265      39.581  -1.583  40.271  1.00 18.96           C  
ATOM   2172  CD  GLU A 265      39.761  -0.704  41.518  1.00 21.82           C  
ATOM   2173  OE1 GLU A 265      39.722   0.555  41.402  1.00 29.05           O  
ATOM   2174  OE2 GLU A 265      39.940  -1.274  42.616  1.00 30.94           O  
ATOM   2175  N   ARG A 266      35.902  -3.328  37.722  1.00 12.43           N  
ATOM   2176  CA  ARG A 266      34.550  -3.378  37.179  1.00 13.39           C  
ATOM   2177  C   ARG A 266      33.602  -3.970  38.208  1.00 10.82           C  
ATOM   2178  O   ARG A 266      33.915  -4.984  38.828  1.00 12.83           O  
ATOM   2179  CB  ARG A 266      34.540  -4.259  35.906  1.00 12.44           C  
ATOM   2180  CG  ARG A 266      35.470  -3.719  34.787  1.00 14.84           C  
ATOM   2181  CD  ARG A 266      35.629  -4.760  33.669  1.00 14.49           C  
ATOM   2182  NE  ARG A 266      36.319  -5.965  34.094  1.00 13.17           N  
ATOM   2183  CZ  ARG A 266      37.644  -6.131  34.172  1.00 14.78           C  
ATOM   2184  NH1 ARG A 266      38.141  -7.310  34.513  1.00 16.95           N  
ATOM   2185  NH2 ARG A 266      38.467  -5.121  33.856  1.00 15.87           N  
ATOM   2186  N   THR A 267      32.458  -3.307  38.380  1.00 13.17           N  
ATOM   2187  CA  THR A 267      31.541  -3.606  39.501  1.00 15.32           C  
ATOM   2188  C   THR A 267      30.633  -4.802  39.195  1.00 13.27           C  
ATOM   2189  O   THR A 267      30.600  -5.309  38.058  1.00 13.84           O  
ATOM   2190  CB  THR A 267      30.623  -2.375  39.802  1.00 16.81           C  
ATOM   2191  OG1 THR A 267      29.688  -2.192  38.728  1.00 24.02           O  
ATOM   2192  CG2 THR A 267      31.434  -1.123  39.991  1.00 20.31           C  
ATOM   2193  N   GLN A 268      29.863  -5.226  40.203  1.00 12.07           N  
ATOM   2194  CA  GLN A 268      28.985  -6.403  40.030  1.00 11.44           C  
ATOM   2195  C   GLN A 268      28.011  -6.209  38.864  1.00 11.78           C  
ATOM   2196  O   GLN A 268      27.456  -5.120  38.694  1.00 14.40           O  
ATOM   2197  CB  GLN A 268      28.221  -6.705  41.333  1.00 11.70           C  
ATOM   2198  CG  GLN A 268      27.312  -5.590  41.752  1.00 12.06           C  
ATOM   2199  CD  GLN A 268      26.668  -5.873  43.101  1.00  9.82           C  
ATOM   2200  OE1 GLN A 268      27.338  -6.245  44.074  1.00 11.44           O  
ATOM   2201  NE2 GLN A 268      25.342  -5.663  43.175  1.00 13.34           N  
ATOM   2202  N   GLY A 269      27.810  -7.283  38.083  1.00 13.64           N  
ATOM   2203  CA  GLY A 269      26.838  -7.251  36.993  1.00 14.01           C  
ATOM   2204  C   GLY A 269      27.239  -6.414  35.794  1.00 15.77           C  
ATOM   2205  O   GLY A 269      26.470  -6.332  34.831  1.00 16.04           O  
ATOM   2206  N   SER A 270      28.394  -5.747  35.870  1.00 13.28           N  
ATOM   2207  CA  SER A 270      28.838  -4.866  34.789  1.00 13.44           C  
ATOM   2208  C   SER A 270      29.295  -5.667  33.558  1.00 13.37           C  
ATOM   2209  O   SER A 270      29.787  -6.787  33.673  1.00 13.86           O  
ATOM   2210  CB  SER A 270      29.932  -3.877  35.257  1.00 13.94           C  
ATOM   2211  OG  SER A 270      31.118  -4.598  35.535  1.00 15.21           O  
ATOM   2212  N   VAL A 271      29.140  -5.049  32.386  1.00 13.20           N  
ATOM   2213  CA  VAL A 271      29.553  -5.672  31.114  1.00 12.11           C  
ATOM   2214  C   VAL A 271      30.197  -4.577  30.281  1.00 14.72           C  
ATOM   2215  O   VAL A 271      29.610  -3.513  30.103  1.00 14.98           O  
ATOM   2216  CB  VAL A 271      28.355  -6.229  30.335  1.00 13.60           C  
ATOM   2217  CG1 VAL A 271      28.835  -6.900  29.024  1.00 16.03           C  
ATOM   2218  CG2 VAL A 271      27.545  -7.240  31.201  1.00 15.18           C  
ATOM   2219  N   ALA A 272      31.425  -4.844  29.810  1.00 14.18           N  
ATOM   2220  CA  ALA A 272      32.182  -3.852  29.029  1.00 14.54           C  
ATOM   2221  C   ALA A 272      32.885  -4.499  27.876  1.00 14.15           C  
ATOM   2222  O   ALA A 272      33.118  -5.701  27.911  1.00 14.01           O  
ATOM   2223  CB  ALA A 272      33.239  -3.153  29.911  1.00 15.68           C  
ATOM   2224  N   LEU A 273      33.233  -3.680  26.878  1.00 14.20           N  
ATOM   2225  CA  LEU A 273      34.108  -4.150  25.800  1.00 15.41           C  
ATOM   2226  C   LEU A 273      35.407  -3.376  25.782  1.00 14.98           C  
ATOM   2227  O   LEU A 273      35.440  -2.225  26.185  1.00 15.17           O  
ATOM   2228  CB  LEU A 273      33.429  -3.959  24.435  1.00 14.82           C  
ATOM   2229  CG  LEU A 273      32.081  -4.628  24.202  1.00 15.98           C  
ATOM   2230  CD1 LEU A 273      31.560  -4.221  22.792  1.00 16.35           C  
ATOM   2231  CD2 LEU A 273      32.168  -6.147  24.302  1.00 16.62           C  
ATOM   2232  N   SER A 274      36.484  -4.010  25.329  1.00 14.67           N  
ATOM   2233  CA  SER A 274      37.665  -3.242  24.888  1.00 14.65           C  
ATOM   2234  C   SER A 274      37.885  -3.559  23.404  1.00 15.90           C  
ATOM   2235  O   SER A 274      37.622  -4.690  22.938  1.00 14.41           O  
ATOM   2236  CB  SER A 274      38.929  -3.607  25.681  1.00 16.01           C  
ATOM   2237  OG  SER A 274      39.338  -4.945  25.475  1.00 17.21           O  
ATOM   2238  N   VAL A 275      38.391  -2.579  22.688  1.00 14.87           N  
ATOM   2239  CA  VAL A 275      38.738  -2.806  21.274  1.00 14.76           C  
ATOM   2240  C   VAL A 275      40.187  -2.372  21.089  1.00 15.42           C  
ATOM   2241  O   VAL A 275      40.545  -1.250  21.467  1.00 13.73           O  
ATOM   2242  CB  VAL A 275      37.825  -1.960  20.321  1.00 15.07           C  
ATOM   2243  CG1 VAL A 275      38.232  -2.156  18.828  1.00 14.00           C  
ATOM   2244  CG2 VAL A 275      36.327  -2.260  20.546  1.00 17.25           C  
ATOM   2245  N   THR A 276      41.004  -3.251  20.509  1.00 14.13           N  
ATOM   2246  CA  THR A 276      42.384  -2.946  20.183  1.00 15.22           C  
ATOM   2247  C   THR A 276      42.601  -3.422  18.750  1.00 16.09           C  
ATOM   2248  O   THR A 276      42.054  -4.441  18.360  1.00 15.75           O  
ATOM   2249  CB  THR A 276      43.347  -3.692  21.114  1.00 18.36           C  
ATOM   2250  OG1 THR A 276      42.930  -3.464  22.483  1.00 19.65           O  
ATOM   2251  CG2 THR A 276      44.759  -3.199  20.907  1.00 20.01           C  
ATOM   2252  N   GLN A 277      43.372  -2.672  17.979  1.00 13.38           N  
ATOM   2253  CA  GLN A 277      43.844  -3.134  16.667  1.00 12.99           C  
ATOM   2254  C   GLN A 277      45.329  -2.866  16.613  1.00 12.83           C  
ATOM   2255  O   GLN A 277      45.783  -1.788  16.170  1.00 12.71           O  
ATOM   2256  CB  GLN A 277      43.120  -2.397  15.532  1.00 12.67           C  
ATOM   2257  CG  GLN A 277      41.651  -2.733  15.469  1.00 14.88           C  
ATOM   2258  CD  GLN A 277      41.041  -2.149  14.212  1.00 21.08           C  
ATOM   2259  OE1 GLN A 277      41.474  -1.094  13.754  1.00 25.77           O  
ATOM   2260  NE2 GLN A 277      40.042  -2.815  13.650  1.00 15.38           N  
ATOM   2261  N   ASP A 278      46.086  -3.854  17.061  1.00 11.93           N  
ATOM   2262  CA  ASP A 278      47.530  -3.719  17.133  1.00 10.46           C  
ATOM   2263  C   ASP A 278      48.153  -4.248  15.837  1.00 12.90           C  
ATOM   2264  O   ASP A 278      48.052  -5.454  15.579  1.00 13.92           O  
ATOM   2265  CB  ASP A 278      48.027  -4.515  18.349  1.00 13.55           C  
ATOM   2266  CG  ASP A 278      49.509  -4.391  18.571  1.00 17.50           C  
ATOM   2267  OD1 ASP A 278      50.240  -3.830  17.711  1.00 16.38           O  
ATOM   2268  OD2 ASP A 278      49.962  -4.899  19.630  1.00 19.89           O  
ATOM   2269  N   PRO A 279      48.833  -3.389  15.036  1.00 13.74           N  
ATOM   2270  CA  PRO A 279      49.410  -3.928  13.783  1.00 15.69           C  
ATOM   2271  C   PRO A 279      50.439  -5.034  13.972  1.00 14.92           C  
ATOM   2272  O   PRO A 279      50.729  -5.782  13.027  1.00 16.73           O  
ATOM   2273  CB  PRO A 279      50.042  -2.708  13.102  1.00 17.28           C  
ATOM   2274  CG  PRO A 279      50.070  -1.618  14.129  1.00 19.46           C  
ATOM   2275  CD  PRO A 279      49.102  -1.945  15.207  1.00 14.74           C  
ATOM   2276  N   ALA A 280      51.029  -5.149  15.162  1.00 12.94           N  
ATOM   2277  CA  ALA A 280      51.957  -6.232  15.443  1.00 14.88           C  
ATOM   2278  C   ALA A 280      51.271  -7.607  15.377  1.00 14.14           C  
ATOM   2279  O   ALA A 280      51.961  -8.639  15.268  1.00 16.04           O  
ATOM   2280  CB  ALA A 280      52.604  -6.020  16.836  1.00 15.67           C  
ATOM   2281  N   CYS A 281      49.941  -7.607  15.468  1.00 14.72           N  
ATOM   2282  CA  CYS A 281      49.107  -8.809  15.448  1.00 15.69           C  
ATOM   2283  C   CYS A 281      48.511  -9.080  14.064  1.00 16.04           C  
ATOM   2284  O   CYS A 281      47.629  -9.937  13.926  1.00 16.04           O  
ATOM   2285  CB  CYS A 281      47.971  -8.678  16.452  1.00 16.53           C  
ATOM   2286  SG  CYS A 281      48.606  -8.610  18.162  1.00 20.85           S  
ATOM   2287  N   LYS A 282      48.993  -8.353  13.061  1.00 17.87           N  
ATOM   2288  CA  LYS A 282      48.544  -8.492  11.675  1.00 20.43           C  
ATOM   2289  C   LYS A 282      48.795  -9.918  11.209  1.00 21.64           C  
ATOM   2290  O   LYS A 282      49.833 -10.507  11.529  1.00 19.18           O  
ATOM   2291  CB  LYS A 282      49.333  -7.519  10.822  1.00 20.12           C  
ATOM   2292  CG  LYS A 282      48.953  -7.378   9.362  1.00 24.07           C  
ATOM   2293  CD  LYS A 282      49.586  -6.065   8.920  1.00 23.38           C  
ATOM   2294  CE  LYS A 282      49.494  -5.819   7.501  1.00 28.24           C  
ATOM   2295  NZ  LYS A 282      50.453  -4.759   7.191  1.00 21.41           N  
ATOM   2296  N   LYS A 283      47.830 -10.484  10.490  1.00 23.88           N  
ATOM   2297  CA  LYS A 283      48.008 -11.803   9.886  1.00 26.54           C  
ATOM   2298  C   LYS A 283      48.971 -11.732   8.692  1.00 29.12           C  
ATOM   2299  O   LYS A 283      48.789 -10.905   7.797  1.00 29.14           O  
ATOM   2300  CB  LYS A 283      46.658 -12.417   9.521  1.00 26.43           C  
ATOM   2301  CG  LYS A 283      45.743 -12.532  10.734  1.00 23.61           C  
ATOM   2302  CD  LYS A 283      46.485 -13.204  11.864  1.00 28.01           C  
ATOM   2303  CE  LYS A 283      45.850 -12.944  13.184  1.00 29.64           C  
ATOM   2304  NZ  LYS A 283      46.696 -13.470  14.293  1.00 27.08           N  
ATOM   2305  N   PRO A 284      50.038 -12.555   8.703  1.00 31.54           N  
ATOM   2306  CA  PRO A 284      51.023 -12.485   7.620  1.00 33.39           C  
ATOM   2307  C   PRO A 284      50.429 -12.676   6.218  1.00 35.29           C  
ATOM   2308  O   PRO A 284      50.992 -12.169   5.234  1.00 37.43           O  
ATOM   2309  CB  PRO A 284      52.014 -13.622   7.949  1.00 33.60           C  
ATOM   2310  CG  PRO A 284      51.371 -14.452   9.007  1.00 32.35           C  
ATOM   2311  CD  PRO A 284      50.414 -13.545   9.729  1.00 32.33           C  
ATOM   2312  N   LEU A 285      49.313 -13.397   6.123  1.00 35.08           N  
ATOM   2313  CA  LEU A 285      48.713 -13.681   4.820  1.00 34.12           C  
ATOM   2314  C   LEU A 285      47.268 -14.155   4.949  1.00 31.70           C  
ATOM   2315  O   LEU A 285      46.740 -14.265   6.069  1.00 30.92           O  
ATOM   2316  CB  LEU A 285      49.580 -14.683   4.018  1.00 34.19           C  
ATOM   2317  CG  LEU A 285      49.790 -16.173   4.358  1.00 37.14           C  
ATOM   2318  CD1 LEU A 285      50.634 -16.813   3.255  1.00 35.93           C  
ATOM   2319  CD2 LEU A 285      50.434 -16.454   5.726  1.00 37.34           C  
ATOM   2320  N   GLY A 286      46.634 -14.387   3.794  1.00 29.08           N  
ATOM   2321  CA  GLY A 286      45.339 -15.069   3.712  1.00 25.47           C  
ATOM   2322  C   GLY A 286      44.186 -14.141   3.406  1.00 20.58           C  
ATOM   2323  O   GLY A 286      43.145 -14.539   2.872  1.00 17.38           O  
ATOM   2324  OXT GLY A 286      44.257 -12.954   3.727  1.00 23.33           O  
TER    2325      GLY A 286                                                      
END
MOLECULE T0414.pdb
ATOM      1  N   ALA     3      33.302  15.772  39.809  1.00 36.36           N  
ATOM      2  CA  ALA     3      33.703  14.577  39.009  1.00 34.68           C  
ATOM      3  C   ALA     3      33.623  14.788  37.490  1.00 33.45           C  
ATOM      4  O   ALA     3      32.753  15.521  36.975  1.00 34.46           O  
ATOM      5  CB  ALA     3      32.891  13.338  39.421  1.00 34.63           C  
ATOM      6  N   MET     4      34.518  14.186  36.727  0.50 33.03           N  
ATOM      8  CA  MET     4      34.520  14.424  35.288  0.50 31.92           C  
ATOM     10  C   MET     4      33.425  13.560  34.616  0.50 29.87           C  
ATOM     12  O   MET     4      33.219  12.421  35.010  0.50 28.81           O  
ATOM     14  CB  MET     4      35.942  14.155  34.757  0.50 32.53           C  
ATOM     16  CG  MET     4      36.126  13.883  33.287  0.50 33.68           C  
ATOM     18  SD  MET     4      37.621  12.592  33.077  0.30 35.37          SE  
ATOM     20  CE  MET     4      38.935  13.454  34.246  0.50 35.07           C  
ATOM     22  N   LYS     5      32.683  14.127  33.663  0.50 27.74           N  
ATOM     24  CA  LYS     5      31.796  13.306  32.842  0.50 25.75           C  
ATOM     26  C   LYS     5      32.631  12.565  31.797  0.50 23.22           C  
ATOM     28  O   LYS     5      33.773  12.916  31.546  0.50 22.57           O  
ATOM     30  CB  LYS     5      30.709  14.150  32.160  0.50 26.57           C  
ATOM     32  CG  LYS     5      29.525  14.483  33.071  0.50 27.85           C  
ATOM     34  CD  LYS     5      28.325  14.912  32.262  0.50 29.82           C  
ATOM     36  CE  LYS     5      27.439  13.747  31.918  0.50 28.42           C  
ATOM     38  NZ  LYS     5      26.334  13.574  32.915  0.50 27.77           N  
ATOM     40  N   PRO     6      32.050  11.528  31.182  1.00 21.30           N  
ATOM     41  CA  PRO     6      32.693  10.923  29.996  1.00 19.52           C  
ATOM     42  C   PRO     6      32.625  11.935  28.854  1.00 18.68           C  
ATOM     43  O   PRO     6      31.774  12.839  28.867  1.00 19.30           O  
ATOM     44  CB  PRO     6      31.790   9.733  29.675  1.00 19.69           C  
ATOM     45  CG  PRO     6      30.458  10.178  30.200  1.00 20.34           C  
ATOM     46  CD  PRO     6      30.766  10.901  31.500  1.00 21.56           C  
ATOM     47  N   ASP     7      33.506  11.792  27.867  1.00 17.52           N  
ATOM     48  CA  ASP     7      33.309  12.556  26.627  1.00 16.91           C  
ATOM     49  C   ASP     7      32.131  11.917  25.899  1.00 15.85           C  
ATOM     50  O   ASP     7      31.966  10.690  25.921  1.00 17.32           O  
ATOM     51  CB  ASP     7      34.552  12.523  25.770  1.00 17.30           C  
ATOM     52  CG  ASP     7      35.764  13.025  26.518  1.00 20.36           C  
ATOM     53  OD1 ASP     7      35.723  14.200  26.989  1.00 22.01           O  
ATOM     54  OD2 ASP     7      36.738  12.272  26.639  1.00 20.73           O  
ATOM     55  N   ILE     8      31.291  12.738  25.293  1.00 16.43           N  
ATOM     56  CA  ILE     8      30.057  12.263  24.664  1.00 16.85           C  
ATOM     57  C   ILE     8      30.093  12.721  23.218  1.00 17.30           C  
ATOM     58  O   ILE     8      30.202  13.939  22.920  1.00 16.82           O  
ATOM     59  CB  ILE     8      28.808  12.859  25.331  1.00 16.75           C  
ATOM     60  CG1 ILE     8      28.809  12.531  26.831  1.00 17.21           C  
ATOM     61  CG2 ILE     8      27.531  12.326  24.628  1.00 17.36           C  
ATOM     62  CD1 ILE     8      27.659  13.134  27.576  1.00 21.50           C  
ATOM     63  N   TYR     9      30.035  11.755  22.304  1.00 16.25           N  
ATOM     64  CA  TYR     9      30.189  12.064  20.879  1.00 16.53           C  
ATOM     65  C   TYR     9      28.922  11.695  20.103  1.00 16.71           C  
ATOM     66  O   TYR     9      28.269  10.652  20.365  1.00 17.09           O  
ATOM     67  CB  TYR     9      31.309  11.207  20.307  1.00 18.16           C  
ATOM     68  CG  TYR     9      32.621  11.239  21.056  1.00 19.13           C  
ATOM     69  CD1 TYR     9      33.272  12.425  21.336  1.00 20.08           C  
ATOM     70  CD2 TYR     9      33.226  10.035  21.442  1.00 21.22           C  
ATOM     71  CE1 TYR     9      34.527  12.415  22.020  1.00 19.52           C  
ATOM     72  CE2 TYR     9      34.442  10.010  22.068  1.00 19.90           C  
ATOM     73  CZ  TYR     9      35.070  11.186  22.368  1.00 19.38           C  
ATOM     74  OH  TYR     9      36.285  11.080  23.009  1.00 22.23           O  
ATOM     75  N   GLU    10      28.590  12.535  19.113  1.00 16.20           N  
ATOM     76  CA  GLU    10      27.458  12.237  18.240  1.00 17.73           C  
ATOM     77  C   GLU    10      27.825  12.717  16.832  1.00 17.84           C  
ATOM     78  O   GLU    10      28.762  13.547  16.657  1.00 17.95           O  
ATOM     79  CB  GLU    10      26.181  12.949  18.724  1.00 18.99           C  
ATOM     80  CG  GLU    10      26.360  14.445  18.695  1.00 21.75           C  
ATOM     81  CD  GLU    10      25.209  15.268  19.281  1.00 25.44           C  
ATOM     82  OE1 GLU    10      24.163  14.693  19.649  1.00 33.26           O  
ATOM     83  OE2 GLU    10      25.399  16.514  19.308  1.00 33.86           O  
ATOM     84  N   ASN    11      27.070  12.220  15.860  1.00 15.68           N  
ATOM     85  CA  ASN    11      27.238  12.683  14.477  1.00 15.50           C  
ATOM     86  C   ASN    11      25.856  12.930  13.910  1.00 16.30           C  
ATOM     87  O   ASN    11      25.046  11.966  13.797  1.00 16.56           O  
ATOM     88  CB  ASN    11      27.966  11.608  13.647  1.00 17.10           C  
ATOM     89  CG  ASN    11      28.062  11.990  12.175  1.00 17.78           C  
ATOM     90  OD1 ASN    11      27.841  13.151  11.836  1.00 17.07           O  
ATOM     91  ND2 ASN    11      28.398  11.027  11.314  1.00 16.10           N  
ATOM     92  N   ASN    12      25.572  14.203  13.592  1.00 17.76           N  
ATOM     93  CA  ASN    12      24.307  14.543  12.923  1.00 18.55           C  
ATOM     94  C   ASN    12      24.489  14.954  11.485  1.00 19.79           C  
ATOM     95  O   ASN    12      23.556  15.494  10.875  1.00 23.14           O  
ATOM     96  CB  ASN    12      23.564  15.640  13.703  1.00 20.05           C  
ATOM     97  CG  ASN    12      23.156  15.160  15.094  1.00 23.62           C  
ATOM     98  OD1 ASN    12      23.532  15.777  16.086  1.00 32.59           O  
ATOM     99  ND2 ASN    12      22.482  14.022  15.159  1.00 27.73           N  
ATOM    100  N   ARG    13      25.665  14.690  10.940  1.00 16.78           N  
ATOM    101  CA  ARG    13      26.007  15.090   9.567  1.00 17.18           C  
ATOM    102  C   ARG    13      25.867  13.915   8.606  1.00 17.32           C  
ATOM    103  O   ARG    13      25.768  12.761   9.017  1.00 18.57           O  
ATOM    104  CB  ARG    13      27.463  15.613   9.536  1.00 16.99           C  
ATOM    105  CG  ARG    13      27.698  16.841  10.366  1.00 16.86           C  
ATOM    106  CD  ARG    13      29.145  17.340  10.231  1.00 18.64           C  
ATOM    107  NE  ARG    13      29.314  18.572  11.017  1.00 20.84           N  
ATOM    108  CZ  ARG    13      29.068  19.795  10.555  1.00 22.46           C  
ATOM    109  NH1 ARG    13      28.699  19.980   9.285  1.00 21.30           N  
ATOM    110  NH2 ARG    13      29.238  20.846  11.368  1.00 26.57           N  
ATOM    111  N   GLU    14      25.874  14.191   7.309  1.00 16.57           N  
ATOM    112  CA  GLU    14      25.895  13.116   6.308  1.00 17.51           C  
ATOM    113  C   GLU    14      27.211  12.302   6.422  1.00 16.26           C  
ATOM    114  O   GLU    14      28.303  12.837   6.662  1.00 18.17           O  
ATOM    115  CB  GLU    14      25.802  13.757   4.918  1.00 18.63           C  
ATOM    116  CG  GLU    14      25.635  12.781   3.785  1.00 22.71           C  
ATOM    117  CD  GLU    14      25.134  13.481   2.513  1.00 24.46           C  
ATOM    118  OE1 GLU    14      23.942  13.830   2.472  1.00 28.70           O  
ATOM    119  OE2 GLU    14      25.953  13.623   1.579  1.00 28.01           O  
ATOM    120  N   GLY    15      27.111  10.995   6.267  1.00 17.10           N  
ATOM    121  CA  GLY    15      28.324  10.243   6.152  1.00 18.01           C  
ATOM    122  C   GLY    15      29.095  10.097   7.455  1.00 17.23           C  
ATOM    123  O   GLY    15      28.526   9.934   8.543  1.00 17.23           O  
ATOM    124  N   ILE    16      30.411  10.148   7.345  1.00 17.29           N  
ATOM    125  CA  ILE    16      31.280   9.730   8.446  1.00 16.95           C  
ATOM    126  C   ILE    16      31.787  10.890   9.280  1.00 16.79           C  
ATOM    127  O   ILE    16      32.203  11.929   8.740  1.00 17.82           O  
ATOM    128  CB  ILE    16      32.507   8.989   7.861  1.00 16.44           C  
ATOM    129  CG1 ILE    16      32.046   7.772   7.049  1.00 18.83           C  
ATOM    130  CG2 ILE    16      33.466   8.593   8.953  1.00 17.93           C  
ATOM    131  CD1 ILE    16      33.193   7.165   6.146  1.00 19.62           C  
ATOM    132  N   LEU    17      31.774  10.717  10.609  1.00 16.67           N  
ATOM    133  CA  LEU    17      32.462  11.624  11.507  1.00 17.09           C  
ATOM    134  C   LEU    17      33.304  10.755  12.436  1.00 17.42           C  
ATOM    135  O   LEU    17      32.781   9.846  13.128  1.00 17.89           O  
ATOM    136  CB  LEU    17      31.464  12.429  12.342  1.00 17.81           C  
ATOM    137  CG  LEU    17      32.111  13.501  13.216  1.00 17.47           C  
ATOM    138  CD1 LEU    17      32.620  14.670  12.347  1.00 19.68           C  
ATOM    139  CD2 LEU    17      31.074  13.984  14.258  1.00 19.13           C  
ATOM    140  N   CYS    18      34.601  11.024  12.429  0.50 18.77           N  
ATOM    142  CA  CYS    18      35.503  10.383  13.334  0.50 18.68           C  
ATOM    144  C   CYS    18      35.329  11.084  14.662  0.50 17.75           C  
ATOM    146  O   CYS    18      35.414  12.342  14.749  0.50 17.11           O  
ATOM    148  CB  CYS    18      36.931  10.520  12.822  0.50 19.68           C  
ATOM    150  SG  CYS    18      38.169   9.741  13.895  0.50 25.35           S  
ATOM    152  N   VAL    19      35.090  10.285  15.703  1.00 17.60           N  
ATOM    153  CA  VAL    19      34.852  10.884  17.017  1.00 17.61           C  
ATOM    154  C   VAL    19      35.901  10.621  18.082  1.00 18.84           C  
ATOM    155  O   VAL    19      36.031  11.426  19.030  1.00 19.37           O  
ATOM    156  CB  VAL    19      33.441  10.554  17.541  1.00 18.37           C  
ATOM    157  CG1 VAL    19      32.386  11.066  16.565  1.00 19.97           C  
ATOM    158  CG2 VAL    19      33.285   9.036  17.807  1.00 19.29           C  
ATOM    159  N   TYR    20      36.659   9.537  17.949  1.00 17.79           N  
ATOM    160  CA  TYR    20      37.705   9.219  18.927  1.00 17.31           C  
ATOM    161  C   TYR    20      38.904   8.679  18.151  1.00 17.74           C  
ATOM    162  O   TYR    20      38.744   7.851  17.253  1.00 17.59           O  
ATOM    163  CB  TYR    20      37.239   8.164  19.938  1.00 18.63           C  
ATOM    164  CG  TYR    20      38.375   7.755  20.831  1.00 18.31           C  
ATOM    165  CD1 TYR    20      38.666   8.491  22.001  1.00 18.30           C  
ATOM    166  CD2 TYR    20      39.252   6.735  20.480  1.00 17.90           C  
ATOM    167  CE1 TYR    20      39.781   8.162  22.798  1.00 16.64           C  
ATOM    168  CE2 TYR    20      40.353   6.396  21.280  1.00 17.14           C  
ATOM    169  CZ  TYR    20      40.610   7.128  22.429  1.00 17.75           C  
ATOM    170  OH  TYR    20      41.720   6.807  23.204  1.00 18.23           O  
ATOM    171  N   LYS    21      40.092   9.175  18.494  0.50 18.45           N  
ATOM    173  CA  LYS    21      41.325   8.709  17.899  0.50 19.23           C  
ATOM    175  C   LYS    21      42.410   8.666  18.967  0.50 18.93           C  
ATOM    177  O   LYS    21      42.492   9.553  19.844  0.50 18.14           O  
ATOM    179  CB  LYS    21      41.769   9.654  16.755  0.50 19.72           C  
ATOM    181  CG  LYS    21      42.986   9.166  15.984  0.50 21.51           C  
ATOM    183  CD  LYS    21      43.277  10.047  14.777  0.50 22.28           C  
ATOM    185  CE  LYS    21      44.165   9.322  13.775  0.50 26.01           C  
ATOM    187  NZ  LYS    21      44.998  10.242  12.956  0.50 28.80           N  
ATOM    189  N   ASN    22      43.246   7.641  18.893  1.00 18.57           N  
ATOM    190  CA  ASN    22      44.510   7.675  19.646  1.00 19.63           C  
ATOM    191  C   ASN    22      45.633   7.170  18.740  1.00 20.21           C  
ATOM    192  O   ASN    22      45.442   7.146  17.525  1.00 21.67           O  
ATOM    193  CB  ASN    22      44.393   6.968  21.000  1.00 19.28           C  
ATOM    194  CG  ASN    22      44.119   5.476  20.878  1.00 18.68           C  
ATOM    195  OD1 ASN    22      44.477   4.855  19.876  1.00 18.07           O  
ATOM    196  ND2 ASN    22      43.512   4.893  21.908  1.00 19.31           N  
ATOM    197  N   GLU    23      46.798   6.802  19.268  0.50 20.33           N  
ATOM    199  CA  GLU    23      47.871   6.392  18.343  0.50 20.79           C  
ATOM    201  C   GLU    23      47.688   4.963  17.811  0.50 20.15           C  
ATOM    203  O   GLU    23      48.445   4.517  16.927  0.50 21.08           O  
ATOM    205  CB  GLU    23      49.271   6.615  18.948  0.50 21.32           C  
ATOM    207  CG  GLU    23      49.531   8.068  19.373  0.50 24.58           C  
ATOM    209  CD  GLU    23      49.988   9.002  18.251  0.50 28.91           C  
ATOM    211  OE1 GLU    23      50.063   8.588  17.074  0.50 31.75           O  
ATOM    213  OE2 GLU    23      50.296  10.181  18.573  0.50 31.68           O  
ATOM    215  N   LYS    24      46.657   4.262  18.314  1.00 19.87           N  
ATOM    216  CA  LYS    24      46.411   2.876  17.906  1.00 18.64           C  
ATOM    217  C   LYS    24      45.123   2.675  17.102  1.00 18.65           C  
ATOM    218  O   LYS    24      45.163   2.084  16.009  1.00 19.79           O  
ATOM    219  CB  LYS    24      46.397   1.937  19.115  1.00 19.67           C  
ATOM    220  CG  LYS    24      47.742   1.895  19.853  1.00 19.24           C  
ATOM    221  CD  LYS    24      47.728   0.842  20.946  1.00 23.27           C  
ATOM    222  CE  LYS    24      49.012   0.890  21.752  1.00 25.06           C  
ATOM    223  NZ  LYS    24      49.012  -0.142  22.838  1.00 26.49           N  
ATOM    224  N   TRP    25      43.996   3.147  17.659  1.00 17.80           N  
ATOM    225  CA  TRP    25      42.710   2.938  16.969  1.00 17.10           C  
ATOM    226  C   TRP    25      41.877   4.189  16.872  1.00 17.05           C  
ATOM    227  O   TRP    25      42.166   5.213  17.501  1.00 17.33           O  
ATOM    228  CB  TRP    25      41.866   1.812  17.636  1.00 17.38           C  
ATOM    229  CG  TRP    25      41.250   2.174  18.989  1.00 17.07           C  
ATOM    230  CD1 TRP    25      40.015   2.746  19.223  1.00 17.16           C  
ATOM    231  CD2 TRP    25      41.857   2.004  20.276  1.00 17.43           C  
ATOM    232  NE1 TRP    25      39.803   2.914  20.576  1.00 16.55           N  
ATOM    233  CE2 TRP    25      40.925   2.472  21.248  1.00 16.10           C  
ATOM    234  CE3 TRP    25      43.109   1.515  20.713  1.00 17.97           C  
ATOM    235  CZ2 TRP    25      41.217   2.471  22.613  1.00 17.89           C  
ATOM    236  CZ3 TRP    25      43.372   1.485  22.082  1.00 18.95           C  
ATOM    237  CH2 TRP    25      42.441   1.975  23.006  1.00 18.93           C  
ATOM    238  N   LEU    26      40.846   4.125  16.057  0.60 17.36           N  
ATOM    240  CA  LEU    26      39.876   5.195  16.053  0.60 18.29           C  
ATOM    242  C   LEU    26      38.473   4.598  16.034  0.60 17.48           C  
ATOM    244  O   LEU    26      38.259   3.406  15.788  0.60 17.47           O  
ATOM    246  CB  LEU    26      40.140   6.186  14.899  0.60 19.00           C  
ATOM    248  CG  LEU    26      40.146   5.630  13.476  0.60 19.25           C  
ATOM    250  CD1 LEU    26      38.728   5.417  13.012  0.60 20.31           C  
ATOM    252  CD2 LEU    26      40.883   6.556  12.503  0.60 20.54           C  
ATOM    254  N   VAL    27      37.519   5.464  16.315  1.00 16.98           N  
ATOM    255  CA  VAL    27      36.079   5.101  16.320  1.00 16.22           C  
ATOM    256  C   VAL    27      35.324   6.179  15.576  1.00 17.45           C  
ATOM    257  O   VAL    27      35.516   7.373  15.844  1.00 17.46           O  
ATOM    258  CB  VAL    27      35.508   5.013  17.747  1.00 17.18           C  
ATOM    259  CG1 VAL    27      34.016   4.551  17.698  1.00 17.61           C  
ATOM    260  CG2 VAL    27      36.386   4.029  18.599  1.00 18.01           C  
ATOM    261  N   CYS    28      34.532   5.742  14.596  1.00 16.21           N  
ATOM    262  CA  CYS    28      33.759   6.689  13.774  1.00 16.26           C  
ATOM    263  C   CYS    28      32.281   6.352  13.879  1.00 16.20           C  
ATOM    264  O   CYS    28      31.899   5.183  14.110  1.00 16.98           O  
ATOM    265  CB  CYS    28      34.172   6.658  12.295  1.00 17.39           C  
ATOM    266  SG  CYS    28      35.986   6.912  12.142  1.00 20.98           S  
ATOM    267  N   ILE    29      31.448   7.378  13.699  1.00 15.71           N  
ATOM    268  CA  ILE    29      30.004   7.183  13.582  1.00 16.13           C  
ATOM    269  C   ILE    29      29.622   7.517  12.143  1.00 16.17           C  
ATOM    270  O   ILE    29      29.951   8.598  11.640  1.00 16.02           O  
ATOM    271  CB  ILE    29      29.218   8.103  14.534  1.00 15.82           C  
ATOM    272  CG1 ILE    29      29.672   7.931  15.981  1.00 15.39           C  
ATOM    273  CG2 ILE    29      27.672   7.900  14.365  1.00 16.09           C  
ATOM    274  CD1 ILE    29      29.037   8.958  16.945  1.00 16.58           C  
ATOM    275  N   LYS    30      28.964   6.585  11.458  1.00 15.88           N  
ATOM    276  CA  LYS    30      28.619   6.785  10.046  1.00 16.21           C  
ATOM    277  C   LYS    30      27.111   6.820   9.855  1.00 16.94           C  
ATOM    278  O   LYS    30      26.400   5.844  10.190  1.00 17.39           O  
ATOM    279  CB  LYS    30      29.211   5.653   9.187  1.00 16.56           C  
ATOM    280  CG  LYS    30      28.903   5.844   7.679  1.00 16.88           C  
ATOM    281  CD  LYS    30      29.732   4.833   6.862  1.00 19.31           C  
ATOM    282  CE  LYS    30      28.991   3.507   6.870  1.00 23.50           C  
ATOM    283  NZ  LYS    30      29.684   2.542   5.986  1.00 28.32           N  
ATOM    284  N   ASN    31      26.611   7.913   9.293  1.00 16.40           N  
ATOM    285  CA  ASN    31      25.209   8.052   8.889  1.00 17.24           C  
ATOM    286  C   ASN    31      25.092   7.792   7.399  1.00 16.60           C  
ATOM    287  O   ASN    31      26.100   7.564   6.719  1.00 16.88           O  
ATOM    288  CB  ASN    31      24.767   9.479   9.184  1.00 17.08           C  
ATOM    289  CG  ASN    31      24.690   9.754  10.673  1.00 17.35           C  
ATOM    290  OD1 ASN    31      24.445   8.818  11.459  1.00 18.51           O  
ATOM    291  ND2 ASN    31      24.915  11.008  11.075  1.00 17.06           N  
ATOM    292  N   TRP    32      23.871   7.844   6.911  1.00 16.43           N  
ATOM    293  CA  TRP    32      23.640   7.654   5.477  1.00 16.87           C  
ATOM    294  C   TRP    32      24.449   8.658   4.661  1.00 16.97           C  
ATOM    295  O   TRP    32      24.639   9.823   5.074  1.00 16.70           O  
ATOM    296  CB  TRP    32      22.156   7.862   5.182  1.00 17.49           C  
ATOM    297  CG  TRP    32      21.767   7.703   3.743  1.00 17.90           C  
ATOM    298  CD1 TRP    32      21.359   6.557   3.112  1.00 18.47           C  
ATOM    299  CD2 TRP    32      21.714   8.745   2.762  1.00 18.65           C  
ATOM    300  NE1 TRP    32      21.081   6.816   1.771  1.00 18.32           N  
ATOM    301  CE2 TRP    32      21.286   8.155   1.538  1.00 18.64           C  
ATOM    302  CE3 TRP    32      22.008  10.118   2.789  1.00 19.67           C  
ATOM    303  CZ2 TRP    32      21.111   8.911   0.360  1.00 20.15           C  
ATOM    304  CZ3 TRP    32      21.847  10.867   1.615  1.00 19.53           C  
ATOM    305  CH2 TRP    32      21.417  10.252   0.420  1.00 19.49           C  
ATOM    306  N   LYS    33      24.952   8.206   3.512  0.50 17.41           N  
ATOM    308  CA  LYS    33      25.520   9.105   2.498  0.50 17.81           C  
ATOM    310  C   LYS    33      25.221   8.457   1.149  0.50 17.76           C  
ATOM    312  O   LYS    33      25.111   7.233   1.067  0.50 17.30           O  
ATOM    314  CB  LYS    33      27.029   9.355   2.697  0.50 18.50           C  
ATOM    316  CG  LYS    33      27.905   8.108   2.859  0.50 17.53           C  
ATOM    318  CD  LYS    33      29.408   8.459   2.928  0.50 18.75           C  
ATOM    320  CE  LYS    33      30.249   7.268   3.434  0.50 20.65           C  
ATOM    322  NZ  LYS    33      30.410   6.095   2.495  0.50 16.18           N  
ATOM    324  N   PRO    34      25.079   9.276   0.086  1.00 18.09           N  
ATOM    325  CA  PRO    34      24.701   8.769  -1.247  1.00 17.70           C  
ATOM    326  C   PRO    34      25.425   7.508  -1.743  1.00 17.56           C  
ATOM    327  O   PRO    34      24.713   6.627  -2.293  1.00 18.77           O  
ATOM    328  CB  PRO    34      24.961   9.981  -2.167  1.00 18.28           C  
ATOM    329  CG  PRO    34      24.611  11.156  -1.256  1.00 18.87           C  
ATOM    330  CD  PRO    34      25.223  10.745   0.112  1.00 18.21           C  
ATOM    331  N   ASP    35      26.747   7.350  -1.534  1.00 17.59           N  
ATOM    332  CA  ASP    35      27.385   6.155  -2.089  1.00 18.40           C  
ATOM    333  C   ASP    35      27.192   4.889  -1.257  1.00 18.59           C  
ATOM    334  O   ASP    35      27.739   3.819  -1.588  1.00 19.50           O  
ATOM    335  CB  ASP    35      28.859   6.364  -2.436  1.00 20.01           C  
ATOM    336  CG  ASP    35      29.792   6.326  -1.216  1.00 22.64           C  
ATOM    337  OD1 ASP    35      29.327   6.354  -0.069  1.00 22.36           O  
ATOM    338  OD2 ASP    35      31.036   6.280  -1.401  1.00 23.21           O  
ATOM    339  N   ASN    36      26.428   5.029  -0.175  1.00 18.02           N  
ATOM    340  CA  ASN    36      25.942   3.845   0.531  1.00 17.85           C  
ATOM    341  C   ASN    36      24.460   3.595   0.249  1.00 17.64           C  
ATOM    342  O   ASN    36      23.911   2.588   0.689  1.00 18.05           O  
ATOM    343  CB  ASN    36      26.070   3.983   2.065  1.00 17.18           C  
ATOM    344  CG  ASN    36      27.514   3.879   2.602  1.00 21.55           C  
ATOM    345  OD1 ASN    36      27.793   4.451   3.630  1.00 30.18           O  
ATOM    346  ND2 ASN    36      28.382   3.116   1.979  1.00 22.47           N  
ATOM    347  N   ASP    37      23.767   4.533  -0.402  1.00 17.32           N  
ATOM    348  CA  ASP    37      22.368   4.259  -0.719  1.00 17.22           C  
ATOM    349  C   ASP    37      22.249   3.126  -1.732  1.00 17.35           C  
ATOM    350  O   ASP    37      23.126   2.958  -2.584  1.00 16.67           O  
ATOM    351  CB  ASP    37      21.719   5.511  -1.320  1.00 17.88           C  
ATOM    352  CG  ASP    37      20.216   5.393  -1.364  1.00 19.89           C  
ATOM    353  OD1 ASP    37      19.582   5.512  -0.288  1.00 21.62           O  
ATOM    354  OD2 ASP    37      19.642   5.158  -2.463  1.00 21.16           O  
ATOM    355  N   ILE    38      21.133   2.394  -1.689  1.00 17.76           N  
ATOM    356  CA  ILE    38      20.948   1.345  -2.698  1.00 19.14           C  
ATOM    357  C   ILE    38      21.100   1.900  -4.142  1.00 19.71           C  
ATOM    358  O   ILE    38      21.650   1.209  -5.026  1.00 20.54           O  
ATOM    359  CB  ILE    38      19.631   0.599  -2.485  1.00 20.17           C  
ATOM    360  CG1 ILE    38      19.657  -0.700  -3.319  1.00 23.22           C  
ATOM    361  CG2 ILE    38      18.432   1.531  -2.673  1.00 21.76           C  
ATOM    362  CD1 ILE    38      18.852  -1.758  -2.799  1.00 26.67           C  
ATOM    363  N   GLU    39      20.657   3.123  -4.368  0.60 18.65           N  
ATOM    365  CA  GLU    39      20.767   3.699  -5.713  0.60 19.62           C  
ATOM    367  C   GLU    39      22.157   4.152  -6.078  0.60 18.83           C  
ATOM    369  O   GLU    39      22.462   4.334  -7.279  0.60 18.82           O  
ATOM    371  CB  GLU    39      19.802   4.868  -5.875  0.60 20.14           C  
ATOM    373  CG  GLU    39      18.363   4.498  -5.623  0.60 22.99           C  
ATOM    375  CD  GLU    39      17.802   3.417  -6.560  0.60 26.07           C  
ATOM    377  OE1 GLU    39      18.361   3.139  -7.646  0.60 28.94           O  
ATOM    379  OE2 GLU    39      16.752   2.856  -6.193  0.60 29.97           O  
ATOM    381  N   GLY    40      22.978   4.383  -5.045  1.00 18.92           N  
ATOM    382  CA  GLY    40      24.291   5.006  -5.202  1.00 18.70           C  
ATOM    383  C   GLY    40      25.463   4.046  -5.085  1.00 19.12           C  
ATOM    384  O   GLY    40      26.595   4.471  -5.205  1.00 19.59           O  
ATOM    385  N   ILE    41      25.200   2.751  -4.884  0.60 18.76           N  
ATOM    387  CA  ILE    41      26.291   1.771  -4.803  0.60 18.02           C  
ATOM    389  C   ILE    41      27.102   1.716  -6.095  0.60 19.31           C  
ATOM    391  O   ILE    41      26.554   1.450  -7.164  0.60 19.38           O  
ATOM    393  CB  ILE    41      25.747   0.371  -4.471  0.60 18.50           C  
ATOM    395  CG1 ILE    41      25.154   0.371  -3.047  0.60 16.67           C  
ATOM    397  CG2 ILE    41      26.865  -0.693  -4.714  0.60 18.56           C  
ATOM    399  CD1 ILE    41      26.117   0.701  -1.919  0.60 18.37           C  
ATOM    401  N   ALA    42      28.406   1.999  -6.003  1.00 18.68           N  
ATOM    402  CA  ALA    42      29.215   2.174  -7.214  1.00 18.88           C  
ATOM    403  C   ALA    42      30.629   1.659  -7.102  1.00 18.31           C  
ATOM    404  O   ALA    42      31.295   1.493  -8.116  1.00 19.25           O  
ATOM    405  CB  ALA    42      29.242   3.688  -7.591  1.00 20.23           C  
ATOM    406  N   HIS    43      31.115   1.464  -5.871  1.00 18.00           N  
ATOM    407  CA  HIS    43      32.509   1.052  -5.664  1.00 16.78           C  
ATOM    408  C   HIS    43      32.608   0.370  -4.335  1.00 17.54           C  
ATOM    409  O   HIS    43      31.736   0.546  -3.468  1.00 17.90           O  
ATOM    410  CB  HIS    43      33.476   2.259  -5.653  1.00 17.86           C  
ATOM    411  CG  HIS    43      32.934   3.453  -4.934  1.00 19.00           C  
ATOM    412  ND1 HIS    43      32.468   4.574  -5.596  1.00 21.45           N  
ATOM    413  CD2 HIS    43      32.713   3.670  -3.607  1.00 20.87           C  
ATOM    414  CE1 HIS    43      32.005   5.442  -4.703  1.00 21.76           C  
ATOM    415  NE2 HIS    43      32.134   4.915  -3.491  1.00 19.81           N  
ATOM    416  N   LEU    44      33.631  -0.452  -4.191  1.00 16.28           N  
ATOM    417  CA  LEU    44      33.989  -1.078  -2.928  1.00 17.41           C  
ATOM    418  C   LEU    44      35.303  -0.515  -2.426  1.00 17.57           C  
ATOM    419  O   LEU    44      36.044   0.102  -3.192  1.00 17.75           O  
ATOM    420  CB  LEU    44      34.140  -2.601  -3.105  1.00 17.41           C  
ATOM    421  CG  LEU    44      32.923  -3.314  -3.708  1.00 17.06           C  
ATOM    422  CD1 LEU    44      33.208  -4.832  -3.740  1.00 18.99           C  
ATOM    423  CD2 LEU    44      31.642  -3.059  -2.890  1.00 17.87           C  
ATOM    424  N   GLU    45      35.613  -0.780  -1.153  1.00 17.32           N  
ATOM    425  CA  GLU    45      36.838  -0.282  -0.525  1.00 17.85           C  
ATOM    426  C   GLU    45      37.617  -1.484  -0.022  1.00 17.53           C  
ATOM    427  O   GLU    45      37.061  -2.561   0.258  1.00 17.19           O  
ATOM    428  CB  GLU    45      36.464   0.633   0.652  1.00 17.71           C  
ATOM    429  CG  GLU    45      37.645   1.395   1.289  1.00 20.73           C  
ATOM    430  CD  GLU    45      37.161   2.412   2.345  1.00 20.50           C  
ATOM    431  OE1 GLU    45      35.935   2.549   2.565  1.00 24.99           O  
ATOM    432  OE2 GLU    45      38.030   3.068   2.921  1.00 32.85           O  
ATOM    433  N   ILE    46      38.916  -1.284   0.170  1.00 18.33           N  
ATOM    434  CA  ILE    46      39.732  -2.349   0.745  1.00 17.98           C  
ATOM    435  C   ILE    46      40.781  -1.674   1.626  1.00 18.08           C  
ATOM    436  O   ILE    46      41.329  -0.614   1.260  1.00 18.26           O  
ATOM    437  CB  ILE    46      40.416  -3.214  -0.352  1.00 18.64           C  
ATOM    438  CG1 ILE    46      41.137  -4.429   0.253  1.00 18.66           C  
ATOM    439  CG2 ILE    46      41.422  -2.371  -1.208  1.00 19.08           C  
ATOM    440  CD1 ILE    46      41.531  -5.521  -0.807  1.00 19.38           C  
ATOM    441  N   HIS    47      41.048  -2.282   2.786  1.00 16.96           N  
ATOM    442  CA  HIS    47      42.132  -1.817   3.653  1.00 17.05           C  
ATOM    443  C   HIS    47      43.253  -2.845   3.589  1.00 18.55           C  
ATOM    444  O   HIS    47      43.075  -4.019   3.928  1.00 19.63           O  
ATOM    445  CB  HIS    47      41.662  -1.750   5.117  1.00 16.94           C  
ATOM    446  CG  HIS    47      40.576  -0.758   5.342  1.00 18.33           C  
ATOM    447  ND1 HIS    47      40.674   0.562   4.944  1.00 20.82           N  
ATOM    448  CD2 HIS    47      39.376  -0.884   5.957  1.00 18.76           C  
ATOM    449  CE1 HIS    47      39.567   1.204   5.295  1.00 22.99           C  
ATOM    450  NE2 HIS    47      38.777   0.359   5.929  1.00 21.68           N  
ATOM    451  N   HIS    48      44.436  -2.396   3.203  1.00 19.42           N  
ATOM    452  CA  HIS    48      45.560  -3.339   3.148  1.00 19.25           C  
ATOM    453  C   HIS    48      46.243  -3.658   4.465  1.00 20.51           C  
ATOM    454  O   HIS    48      46.962  -4.659   4.545  1.00 22.55           O  
ATOM    455  CB  HIS    48      46.594  -2.852   2.116  1.00 19.61           C  
ATOM    456  CG  HIS    48      46.001  -2.629   0.756  1.00 19.32           C  
ATOM    457  ND1 HIS    48      45.428  -3.647   0.021  1.00 21.37           N  
ATOM    458  CD2 HIS    48      45.871  -1.508   0.005  1.00 21.07           C  
ATOM    459  CE1 HIS    48      44.980  -3.168  -1.128  1.00 23.63           C  
ATOM    460  NE2 HIS    48      45.210  -1.868  -1.151  1.00 20.64           N  
ATOM    461  N   SER    49      45.998  -2.843   5.488  0.50 19.93           N  
ATOM    463  CA  SER    49      46.805  -2.926   6.702  0.50 19.80           C  
ATOM    465  C   SER    49      46.013  -2.977   8.005  0.50 19.98           C  
ATOM    467  O   SER    49      46.602  -3.081   9.079  0.50 19.76           O  
ATOM    469  CB  SER    49      47.783  -1.755   6.733  0.50 21.12           C  
ATOM    471  OG  SER    49      48.664  -1.820   5.623  0.50 20.88           O  
ATOM    473  N   THR    50      44.689  -2.893   7.908  1.00 19.07           N  
ATOM    474  CA  THR    50      43.835  -2.910   9.105  1.00 18.53           C  
ATOM    475  C   THR    50      42.602  -3.775   8.911  1.00 18.49           C  
ATOM    476  O   THR    50      42.030  -3.815   7.816  1.00 18.74           O  
ATOM    477  CB  THR    50      43.401  -1.487   9.583  1.00 19.33           C  
ATOM    478  OG1 THR    50      42.743  -1.587  10.864  1.00 18.04           O  
ATOM    479  CG2 THR    50      42.423  -0.839   8.629  1.00 18.56           C  
ATOM    480  N   ASP    51      42.210  -4.431   9.995  1.00 17.41           N  
ATOM    481  CA  ASP    51      40.881  -4.992  10.096  1.00 17.63           C  
ATOM    482  C   ASP    51      39.907  -3.856  10.464  1.00 17.46           C  
ATOM    483  O   ASP    51      40.329  -2.803  10.977  1.00 17.76           O  
ATOM    484  CB  ASP    51      40.800  -6.071  11.184  1.00 17.59           C  
ATOM    485  CG  ASP    51      41.726  -7.267  10.947  1.00 19.72           C  
ATOM    486  OD1 ASP    51      42.217  -7.479   9.811  1.00 20.29           O  
ATOM    487  OD2 ASP    51      41.972  -8.026  11.927  1.00 20.23           O  
ATOM    488  N   GLU    52      38.607  -4.071  10.242  1.00 16.99           N  
ATOM    489  CA  GLU    52      37.626  -3.062  10.649  1.00 16.56           C  
ATOM    490  C   GLU    52      36.385  -3.735  11.205  1.00 16.04           C  
ATOM    491  O   GLU    52      35.928  -4.744  10.655  1.00 16.25           O  
ATOM    492  CB  GLU    52      37.261  -2.210   9.428  1.00 17.33           C  
ATOM    493  CG  GLU    52      36.173  -1.163   9.732  1.00 16.96           C  
ATOM    494  CD  GLU    52      35.956  -0.161   8.605  1.00 20.76           C  
ATOM    495  OE1 GLU    52      36.723  -0.186   7.649  1.00 25.16           O  
ATOM    496  OE2 GLU    52      35.003   0.653   8.675  1.00 22.73           O  
ATOM    497  N   GLN    53      35.891  -3.230  12.338  1.00 15.29           N  
ATOM    498  CA  GLN    53      34.665  -3.780  12.905  1.00 15.57           C  
ATOM    499  C   GLN    53      33.520  -2.794  12.783  1.00 15.96           C  
ATOM    500  O   GLN    53      33.738  -1.562  12.838  1.00 16.46           O  
ATOM    501  CB  GLN    53      34.829  -4.170  14.375  1.00 16.29           C  
ATOM    502  CG  GLN    53      35.923  -5.262  14.568  1.00 16.43           C  
ATOM    503  CD  GLN    53      37.313  -4.679  14.546  1.00 16.79           C  
ATOM    504  OE1 GLN    53      37.608  -3.724  15.302  1.00 18.53           O  
ATOM    505  NE2 GLN    53      38.222  -5.243  13.706  1.00 17.69           N  
ATOM    506  N   PHE    54      32.304  -3.328  12.595  1.00 15.22           N  
ATOM    507  CA  PHE    54      31.127  -2.504  12.339  1.00 16.12           C  
ATOM    508  C   PHE    54      30.054  -2.893  13.333  1.00 16.75           C  
ATOM    509  O   PHE    54      29.820  -4.072  13.596  1.00 16.26           O  
ATOM    510  CB  PHE    54      30.589  -2.820  10.928  1.00 18.13           C  
ATOM    511  CG  PHE    54      31.582  -2.567   9.813  1.00 18.64           C  
ATOM    512  CD1 PHE    54      31.539  -1.357   9.108  1.00 23.57           C  
ATOM    513  CD2 PHE    54      32.565  -3.497   9.498  1.00 20.61           C  
ATOM    514  CE1 PHE    54      32.466  -1.122   8.039  1.00 23.85           C  
ATOM    515  CE2 PHE    54      33.469  -3.245   8.445  1.00 21.03           C  
ATOM    516  CZ  PHE    54      33.403  -2.103   7.732  1.00 23.10           C  
ATOM    517  N   ILE    55      29.342  -1.885  13.826  1.00 16.51           N  
ATOM    518  CA  ILE    55      28.284  -2.074  14.793  1.00 17.03           C  
ATOM    519  C   ILE    55      27.113  -1.256  14.344  1.00 17.63           C  
ATOM    520  O   ILE    55      27.219  -0.042  14.280  1.00 19.02           O  
ATOM    521  CB  ILE    55      28.722  -1.606  16.189  1.00 17.26           C  
ATOM    522  CG1 ILE    55      29.903  -2.450  16.650  1.00 19.11           C  
ATOM    523  CG2 ILE    55      27.555  -1.596  17.205  1.00 20.27           C  
ATOM    524  CD1 ILE    55      30.713  -1.812  17.871  1.00 21.34           C  
ATOM    525  N   LEU    56      25.977  -1.905  14.085  1.00 16.33           N  
ATOM    526  CA  LEU    56      24.747  -1.204  13.647  1.00 16.30           C  
ATOM    527  C   LEU    56      24.031  -0.642  14.872  1.00 18.33           C  
ATOM    528  O   LEU    56      23.734  -1.411  15.823  1.00 18.34           O  
ATOM    529  CB  LEU    56      23.830  -2.203  12.892  1.00 16.00           C  
ATOM    530  CG  LEU    56      22.516  -1.620  12.334  1.00 17.40           C  
ATOM    531  CD1 LEU    56      22.773  -0.483  11.297  1.00 17.23           C  
ATOM    532  CD2 LEU    56      21.728  -2.718  11.668  1.00 17.81           C  
ATOM    533  N   SER    57      23.668   0.645  14.801  1.00 16.83           N  
ATOM    534  CA  SER    57      22.992   1.328  15.912  1.00 17.51           C  
ATOM    535  C   SER    57      21.512   1.580  15.625  1.00 17.72           C  
ATOM    536  O   SER    57      20.643   1.305  16.491  1.00 19.77           O  
ATOM    537  CB  SER    57      23.699   2.672  16.203  1.00 18.26           C  
ATOM    538  OG  SER    57      23.076   3.279  17.342  1.00 19.31           O  
ATOM    539  N   ALA    58      21.206   2.078  14.435  1.00 17.62           N  
ATOM    540  CA  ALA    58      19.819   2.443  14.049  1.00 17.30           C  
ATOM    541  C   ALA    58      19.572   2.038  12.608  1.00 17.02           C  
ATOM    542  O   ALA    58      20.517   1.998  11.804  1.00 17.01           O  
ATOM    543  CB  ALA    58      19.608   3.979  14.147  1.00 18.83           C  
ATOM    544  N   GLY    59      18.307   1.766  12.274  1.00 17.28           N  
ATOM    545  CA  GLY    59      17.964   1.495  10.891  1.00 16.19           C  
ATOM    546  C   GLY    59      18.505   0.148  10.443  1.00 16.70           C  
ATOM    547  O   GLY    59      18.883  -0.706  11.262  1.00 18.82           O  
ATOM    548  N   LYS    60      18.516  -0.003   9.130  1.00 17.10           N  
ATOM    549  CA  LYS    60      18.939  -1.270   8.509  1.00 17.10           C  
ATOM    550  C   LYS    60      20.211  -1.057   7.731  1.00 16.91           C  
ATOM    551  O   LYS    60      20.491   0.048   7.223  1.00 17.29           O  
ATOM    552  CB  LYS    60      17.868  -1.789   7.539  1.00 17.78           C  
ATOM    553  CG  LYS    60      16.534  -2.132   8.176  1.00 19.75           C  
ATOM    554  CD  LYS    60      15.542  -2.331   7.033  1.00 23.56           C  
ATOM    555  CE  LYS    60      14.212  -2.731   7.566  1.00 28.36           C  
ATOM    556  NZ  LYS    60      13.370  -2.904   6.333  1.00 31.59           N  
ATOM    557  N   ALA    61      21.001  -2.123   7.606  1.00 16.77           N  
ATOM    558  CA  ALA    61      22.221  -2.028   6.802  1.00 16.67           C  
ATOM    559  C   ALA    61      22.629  -3.387   6.313  1.00 15.90           C  
ATOM    560  O   ALA    61      22.370  -4.390   6.973  1.00 16.52           O  
ATOM    561  CB  ALA    61      23.365  -1.431   7.605  1.00 17.21           C  
ATOM    562  N   ILE    62      23.253  -3.381   5.140  1.00 15.63           N  
ATOM    563  CA  ILE    62      23.855  -4.564   4.557  1.00 16.08           C  
ATOM    564  C   ILE    62      25.346  -4.326   4.359  1.00 16.56           C  
ATOM    565  O   ILE    62      25.774  -3.236   3.948  1.00 17.64           O  
ATOM    566  CB  ILE    62      23.180  -4.862   3.187  1.00 16.18           C  
ATOM    567  CG1 ILE    62      21.712  -5.258   3.409  1.00 16.39           C  
ATOM    568  CG2 ILE    62      23.914  -5.966   2.429  1.00 17.86           C  
ATOM    569  CD1 ILE    62      20.897  -5.187   2.113  1.00 18.67           C  
ATOM    570  N   LEU    63      26.139  -5.328   4.702  0.60 17.10           N  
ATOM    572  CA  LEU    63      27.582  -5.258   4.487  0.60 17.07           C  
ATOM    574  C   LEU    63      27.917  -6.113   3.262  0.60 17.18           C  
ATOM    576  O   LEU    63      27.628  -7.325   3.249  0.60 17.35           O  
ATOM    578  CB  LEU    63      28.314  -5.806   5.717  0.60 17.84           C  
ATOM    580  CG  LEU    63      29.835  -5.699   5.783  0.60 19.15           C  
ATOM    582  CD1 LEU    63      30.335  -4.263   5.645  0.60 20.68           C  
ATOM    584  CD2 LEU    63      30.261  -6.285   7.125  0.60 20.79           C  
ATOM    586  N   ILE    64      28.462  -5.489   2.213  1.00 17.14           N  
ATOM    587  CA  ILE    64      28.939  -6.178   1.043  1.00 17.08           C  
ATOM    588  C   ILE    64      30.369  -6.603   1.362  1.00 17.38           C  
ATOM    589  O   ILE    64      31.166  -5.790   1.854  1.00 17.79           O  
ATOM    590  CB  ILE    64      29.025  -5.221  -0.204  1.00 17.12           C  
ATOM    591  CG1 ILE    64      27.653  -4.600  -0.477  1.00 20.00           C  
ATOM    592  CG2 ILE    64      29.565  -5.973  -1.440  1.00 18.04           C  
ATOM    593  CD1 ILE    64      27.724  -3.368  -1.404  1.00 18.37           C  
ATOM    594  N   THR    65      30.692  -7.855   1.036  1.00 17.86           N  
ATOM    595  CA  THR    65      32.085  -8.292   1.054  1.00 18.12           C  
ATOM    596  C   THR    65      32.351  -8.962  -0.277  1.00 18.58           C  
ATOM    597  O   THR    65      31.426  -9.489  -0.913  1.00 19.44           O  
ATOM    598  CB  THR    65      32.442  -9.196   2.224  1.00 18.08           C  
ATOM    599  OG1 THR    65      31.489 -10.258   2.313  1.00 17.62           O  
ATOM    600  CG2 THR    65      32.480  -8.375   3.559  1.00 18.10           C  
ATOM    601  N   ALA    66      33.604  -8.910  -0.732  1.00 18.05           N  
ATOM    602  CA  ALA    66      33.887  -9.450  -2.064  1.00 19.25           C  
ATOM    603  C   ALA    66      35.328  -9.878  -2.199  1.00 20.53           C  
ATOM    604  O   ALA    66      36.212  -9.407  -1.476  1.00 19.89           O  
ATOM    605  CB  ALA    66      33.524  -8.414  -3.132  1.00 18.61           C  
ATOM    606  N   GLU    67      35.552 -10.810  -3.119  0.50 21.75           N  
ATOM    608  CA  GLU    67      36.905 -11.053  -3.604  0.50 23.27           C  
ATOM    610  C   GLU    67      36.961 -10.670  -5.072  0.50 23.78           C  
ATOM    612  O   GLU    67      35.966 -10.742  -5.801  0.50 23.10           O  
ATOM    614  CB  GLU    67      37.331 -12.510  -3.419  0.50 24.24           C  
ATOM    616  CG  GLU    67      36.394 -13.509  -4.035  0.50 24.63           C  
ATOM    618  CD  GLU    67      37.087 -14.820  -4.402  0.50 28.22           C  
ATOM    620  OE1 GLU    67      38.147 -15.137  -3.823  0.50 32.90           O  
ATOM    622  OE2 GLU    67      36.559 -15.533  -5.271  0.50 28.66           O  
ATOM    624  N   LYS    68      38.146 -10.272  -5.497  1.00 25.28           N  
ATOM    625  CA  LYS    68      38.360  -9.857  -6.863  1.00 28.72           C  
ATOM    626  C   LYS    68      39.027 -11.029  -7.554  1.00 32.09           C  
ATOM    627  O   LYS    68      40.039 -11.551  -7.074  1.00 31.54           O  
ATOM    628  CB  LYS    68      39.241  -8.601  -6.884  1.00 29.61           C  
ATOM    629  CG  LYS    68      39.108  -7.741  -8.117  1.00 31.87           C  
ATOM    630  CD  LYS    68      40.084  -6.600  -7.985  1.00 36.13           C  
ATOM    631  CE  LYS    68      39.622  -5.388  -8.724  1.00 38.28           C  
ATOM    632  NZ  LYS    68      40.805  -4.612  -9.152  1.00 39.70           N  
ATOM    633  N   GLU    69      38.424 -11.473  -8.649  1.00 35.03           N  
ATOM    634  CA  GLU    69      38.917 -12.620  -9.406  1.00 39.92           C  
ATOM    635  C   GLU    69      39.030 -12.134 -10.841  1.00 40.91           C  
ATOM    636  O   GLU    69      38.033 -11.714 -11.454  1.00 41.18           O  
ATOM    637  CB  GLU    69      37.931 -13.779  -9.292  1.00 39.88           C  
ATOM    638  CG  GLU    69      38.377 -15.100  -9.892  1.00 43.51           C  
ATOM    639  CD  GLU    69      37.375 -16.216  -9.594  1.00 44.52           C  
ATOM    640  OE1 GLU    69      36.155 -16.024  -9.860  1.00 48.99           O  
ATOM    641  OE2 GLU    69      37.811 -17.284  -9.089  1.00 51.23           O  
ATOM    642  N   ASN    70      40.251 -12.181 -11.367  1.00 42.55           N  
ATOM    643  CA  ASN    70      40.575 -11.491 -12.608  1.00 43.92           C  
ATOM    644  C   ASN    70      40.117 -10.034 -12.458  1.00 43.58           C  
ATOM    645  O   ASN    70      40.566  -9.346 -11.534  1.00 44.59           O  
ATOM    646  CB  ASN    70      39.956 -12.229 -13.798  1.00 44.78           C  
ATOM    647  CG  ASN    70      40.392 -13.702 -13.857  1.00 47.87           C  
ATOM    648  OD1 ASN    70      39.561 -14.621 -13.749  1.00 50.12           O  
ATOM    649  ND2 ASN    70      41.705 -13.928 -13.996  1.00 49.37           N  
ATOM    650  N   ASP    71      39.205  -9.566 -13.303  1.00 42.45           N  
ATOM    651  CA  ASP    71      38.738  -8.185 -13.157  1.00 40.43           C  
ATOM    652  C   ASP    71      37.290  -8.046 -12.683  1.00 37.49           C  
ATOM    653  O   ASP    71      36.686  -6.980 -12.864  1.00 38.69           O  
ATOM    654  CB  ASP    71      38.957  -7.396 -14.460  1.00 42.43           C  
ATOM    655  CG  ASP    71      40.191  -6.496 -14.398  1.00 45.99           C  
ATOM    656  OD1 ASP    71      40.131  -5.434 -13.716  1.00 49.92           O  
ATOM    657  OD2 ASP    71      41.221  -6.850 -15.031  1.00 50.27           O  
ATOM    658  N   LYS    72      36.767  -9.099 -12.049  0.50 35.27           N  
ATOM    660  CA  LYS    72      35.371  -9.161 -11.600  0.50 32.39           C  
ATOM    662  C   LYS    72      35.275  -9.506 -10.110  0.50 29.34           C  
ATOM    664  O   LYS    72      36.090 -10.275  -9.587  0.50 28.53           O  
ATOM    666  CB  LYS    72      34.591 -10.201 -12.415  0.50 33.11           C  
ATOM    668  CG  LYS    72      34.608  -9.996 -13.937  0.50 35.22           C  
ATOM    670  CD  LYS    72      33.882  -8.716 -14.352  0.50 38.16           C  
ATOM    672  CE  LYS    72      34.141  -8.381 -15.814  0.50 39.07           C  
ATOM    674  NZ  LYS    72      33.714  -6.985 -16.107  0.50 40.06           N  
ATOM    676  N   PHE    73      34.262  -8.964  -9.438  1.00 26.19           N  
ATOM    677  CA  PHE    73      34.074  -9.258  -8.021  1.00 23.01           C  
ATOM    678  C   PHE    73      33.128 -10.431  -7.845  1.00 22.56           C  
ATOM    679  O   PHE    73      32.081 -10.476  -8.500  1.00 23.23           O  
ATOM    680  CB  PHE    73      33.469  -8.031  -7.331  1.00 20.77           C  
ATOM    681  CG  PHE    73      34.463  -6.919  -7.084  1.00 21.12           C  
ATOM    682  CD1 PHE    73      35.500  -7.085  -6.160  1.00 19.24           C  
ATOM    683  CD2 PHE    73      34.334  -5.723  -7.758  1.00 21.62           C  
ATOM    684  CE1 PHE    73      36.375  -6.072  -5.895  1.00 21.26           C  
ATOM    685  CE2 PHE    73      35.228  -4.661  -7.503  1.00 22.84           C  
ATOM    686  CZ  PHE    73      36.266  -4.864  -6.584  1.00 21.71           C  
ATOM    687  N   ASN    74      33.495 -11.335  -6.947  1.00 21.12           N  
ATOM    688  CA  ASN    74      32.560 -12.346  -6.421  1.00 20.80           C  
ATOM    689  C   ASN    74      31.983 -11.719  -5.159  1.00 20.55           C  
ATOM    690  O   ASN    74      32.750 -11.406  -4.236  1.00 22.73           O  
ATOM    691  CB  ASN    74      33.309 -13.625  -6.086  1.00 20.81           C  
ATOM    692  CG  ASN    74      33.834 -14.312  -7.327  1.00 25.44           C  
ATOM    693  OD1 ASN    74      33.216 -14.214  -8.401  1.00 27.61           O  
ATOM    694  ND2 ASN    74      34.993 -14.981  -7.207  1.00 30.25           N  
ATOM    695  N   ILE    75      30.669 -11.539  -5.100  1.00 18.59           N  
ATOM    696  CA  ILE    75      30.034 -10.671  -4.091  1.00 18.13           C  
ATOM    697  C   ILE    75      29.212 -11.482  -3.061  1.00 19.08           C  
ATOM    698  O   ILE    75      28.517 -12.471  -3.419  1.00 20.00           O  
ATOM    699  CB  ILE    75      29.156  -9.640  -4.810  1.00 18.07           C  
ATOM    700  CG1 ILE    75      30.044  -8.658  -5.589  1.00 20.24           C  
ATOM    701  CG2 ILE    75      28.174  -8.940  -3.848  1.00 20.77           C  
ATOM    702  CD1 ILE    75      29.365  -8.065  -6.753  1.00 22.60           C  
ATOM    703  N   GLU    76      29.308 -11.084  -1.800  0.60 18.87           N  
ATOM    705  CA  GLU    76      28.466 -11.612  -0.735  0.60 19.16           C  
ATOM    707  C   GLU    76      27.745 -10.407  -0.128  0.60 18.09           C  
ATOM    709  O   GLU    76      28.305  -9.282  -0.057  0.60 17.76           O  
ATOM    711  CB  GLU    76      29.339 -12.289   0.332  0.60 20.14           C  
ATOM    713  CG  GLU    76      28.599 -12.731   1.582  0.60 23.37           C  
ATOM    715  CD  GLU    76      27.702 -13.942   1.355  0.60 29.19           C  
ATOM    717  OE1 GLU    76      27.747 -14.565   0.258  0.60 32.28           O  
ATOM    719  OE2 GLU    76      26.959 -14.270   2.308  0.60 32.34           O  
ATOM    721  N   LEU    77      26.507 -10.648   0.309  1.00 17.46           N  
ATOM    722  CA  LEU    77      25.737  -9.644   1.062  1.00 16.79           C  
ATOM    723  C   LEU    77      25.380 -10.220   2.405  1.00 17.12           C  
ATOM    724  O   LEU    77      24.908 -11.374   2.464  1.00 18.05           O  
ATOM    725  CB  LEU    77      24.444  -9.268   0.347  1.00 17.08           C  
ATOM    726  CG  LEU    77      24.616  -8.756  -1.076  1.00 19.68           C  
ATOM    727  CD1 LEU    77      23.246  -8.352  -1.603  1.00 21.69           C  
ATOM    728  CD2 LEU    77      25.579  -7.545  -1.129  1.00 20.67           C  
ATOM    729  N   THR    78      25.559  -9.426   3.459  1.00 16.43           N  
ATOM    730  CA  THR    78      25.221  -9.860   4.834  1.00 15.99           C  
ATOM    731  C   THR    78      24.328  -8.790   5.447  1.00 15.43           C  
ATOM    732  O   THR    78      24.749  -7.629   5.601  1.00 17.08           O  
ATOM    733  CB  THR    78      26.486  -9.986   5.646  1.00 18.10           C  
ATOM    734  OG1 THR    78      27.333 -10.990   5.038  1.00 18.81           O  
ATOM    735  CG2 THR    78      26.154 -10.425   7.078  1.00 19.52           C  
ATOM    736  N   LEU    79      23.096  -9.173   5.798  1.00 16.06           N  
ATOM    737  CA  LEU    79      22.203  -8.219   6.475  1.00 16.46           C  
ATOM    738  C   LEU    79      22.688  -8.061   7.930  1.00 16.23           C  
ATOM    739  O   LEU    79      22.753  -9.061   8.674  1.00 18.78           O  
ATOM    740  CB  LEU    79      20.763  -8.778   6.464  1.00 16.37           C  
ATOM    741  CG  LEU    79      19.661  -7.907   7.062  1.00 17.37           C  
ATOM    742  CD1 LEU    79      19.486  -6.552   6.335  1.00 17.46           C  
ATOM    743  CD2 LEU    79      18.339  -8.679   7.091  1.00 17.44           C  
ATOM    744  N   MET    80      23.043  -6.836   8.320  1.00 17.05           N  
ATOM    745  CA  MET    80      23.489  -6.622   9.699  1.00 17.35           C  
ATOM    746  C   MET    80      22.360  -6.683  10.705  1.00 17.54           C  
ATOM    747  O   MET    80      21.228  -6.227  10.449  1.00 17.87           O  
ATOM    748  CB  MET    80      24.216  -5.268   9.819  1.00 17.15           C  
ATOM    749  CG  MET    80      25.447  -5.249   9.025  1.00 18.39           C  
ATOM    750  SD  MET    80      26.260  -3.413   9.223  0.65 23.14          SE  
ATOM    751  CE  MET    80      27.062  -3.666  10.979  1.00 20.64           C  
ATOM    752  N   GLU    81      22.687  -7.257  11.866  0.60 18.87           N  
ATOM    754  CA  GLU    81      21.777  -7.318  12.996  0.60 20.00           C  
ATOM    756  C   GLU    81      22.268  -6.434  14.122  0.60 18.60           C  
ATOM    758  O   GLU    81      23.461  -6.432  14.462  0.60 18.57           O  
ATOM    760  CB  GLU    81      21.696  -8.754  13.501  0.60 19.45           C  
ATOM    762  CG  GLU    81      21.101  -9.688  12.452  0.60 22.13           C  
ATOM    764  CD  GLU    81      21.019 -11.157  12.881  0.60 24.43           C  
ATOM    766  OE1 GLU    81      20.800 -11.435  14.084  0.60 29.15           O  
ATOM    768  OE2 GLU    81      21.169 -12.041  12.000  0.60 30.97           O  
ATOM    770  N   LYS    82      21.350  -5.682  14.714  0.60 18.42           N  
ATOM    772  CA  LYS    82      21.673  -4.932  15.912  0.60 18.51           C  
ATOM    774  C   LYS    82      21.959  -5.956  17.026  0.60 18.11           C  
ATOM    776  O   LYS    82      21.220  -6.944  17.204  0.60 18.72           O  
ATOM    778  CB  LYS    82      20.511  -4.024  16.313  0.60 18.81           C  
ATOM    780  CG  LYS    82      20.367  -2.809  15.416  0.60 18.90           C  
ATOM    782  CD  LYS    82      19.161  -1.970  15.834  0.60 20.64           C  
ATOM    784  CE  LYS    82      18.782  -1.014  14.727  0.60 21.42           C  
ATOM    786  NZ  LYS    82      18.024  -1.683  13.641  0.60 23.36           N  
ATOM    788  N   GLY    83      23.046  -5.688  17.747  1.00 17.31           N  
ATOM    789  CA  GLY    83      23.527  -6.516  18.854  1.00 17.58           C  
ATOM    790  C   GLY    83      24.740  -7.351  18.496  1.00 17.40           C  
ATOM    791  O   GLY    83      25.387  -7.936  19.376  1.00 18.34           O  
ATOM    792  N   LYS    84      25.042  -7.417  17.207  1.00 16.76           N  
ATOM    793  CA  LYS    84      26.235  -8.150  16.738  1.00 16.39           C  
ATOM    794  C   LYS    84      27.368  -7.205  16.328  1.00 16.76           C  
ATOM    795  O   LYS    84      27.148  -5.985  16.124  1.00 18.19           O  
ATOM    796  CB  LYS    84      25.878  -9.082  15.566  1.00 17.48           C  
ATOM    797  CG  LYS    84      24.850 -10.156  15.982  1.00 18.67           C  
ATOM    798  CD  LYS    84      24.706 -11.195  14.880  1.00 22.19           C  
ATOM    799  CE  LYS    84      23.681 -12.239  15.269  1.00 28.66           C  
ATOM    800  NZ  LYS    84      23.635 -13.207  14.106  1.00 32.70           N  
ATOM    801  N   VAL    85      28.578  -7.780  16.255  1.00 16.21           N  
ATOM    802  CA  VAL    85      29.724  -7.040  15.762  1.00 15.81           C  
ATOM    803  C   VAL    85      30.213  -7.783  14.514  1.00 16.70           C  
ATOM    804  O   VAL    85      30.260  -9.029  14.520  1.00 17.45           O  
ATOM    805  CB  VAL    85      30.846  -6.992  16.798  1.00 16.74           C  
ATOM    806  CG1 VAL    85      32.078  -6.270  16.245  1.00 17.88           C  
ATOM    807  CG2 VAL    85      30.371  -6.241  18.061  1.00 17.90           C  
ATOM    808  N   TYR    86      30.536  -7.031  13.450  1.00 15.64           N  
ATOM    809  CA  TYR    86      31.005  -7.610  12.178  1.00 17.07           C  
ATOM    810  C   TYR    86      32.428  -7.196  11.980  1.00 17.74           C  
ATOM    811  O   TYR    86      32.784  -6.042  12.192  1.00 18.97           O  
ATOM    812  CB  TYR    86      30.128  -7.093  11.010  1.00 16.66           C  
ATOM    813  CG  TYR    86      28.709  -7.580  11.209  1.00 15.88           C  
ATOM    814  CD1 TYR    86      28.249  -8.706  10.552  1.00 16.34           C  
ATOM    815  CD2 TYR    86      27.809  -6.907  12.072  1.00 16.28           C  
ATOM    816  CE1 TYR    86      26.958  -9.193  10.759  1.00 14.73           C  
ATOM    817  CE2 TYR    86      26.521  -7.416  12.280  1.00 15.61           C  
ATOM    818  CZ  TYR    86      26.114  -8.585  11.633  1.00 14.83           C  
ATOM    819  OH  TYR    86      24.834  -9.091  11.844  1.00 17.74           O  
ATOM    820  N   ASN    87      33.252  -8.143  11.539  1.00 16.15           N  
ATOM    821  CA  ASN    87      34.647  -7.813  11.249  1.00 16.28           C  
ATOM    822  C   ASN    87      34.967  -8.085   9.791  1.00 16.88           C  
ATOM    823  O   ASN    87      34.703  -9.187   9.297  1.00 16.54           O  
ATOM    824  CB  ASN    87      35.566  -8.680  12.140  1.00 16.99           C  
ATOM    825  CG  ASN    87      37.049  -8.507  11.803  1.00 18.96           C  
ATOM    826  OD1 ASN    87      37.591  -7.425  11.920  1.00 17.98           O  
ATOM    827  ND2 ASN    87      37.712  -9.592  11.402  1.00 18.13           N  
ATOM    828  N   VAL    88      35.546  -7.085   9.132  1.00 16.41           N  
ATOM    829  CA  VAL    88      36.085  -7.245   7.770  1.00 16.80           C  
ATOM    830  C   VAL    88      37.602  -7.279   7.914  1.00 17.60           C  
ATOM    831  O   VAL    88      38.200  -6.260   8.236  1.00 16.72           O  
ATOM    832  CB  VAL    88      35.655  -6.066   6.852  1.00 16.61           C  
ATOM    833  CG1 VAL    88      36.350  -6.207   5.486  1.00 17.54           C  
ATOM    834  CG2 VAL    88      34.145  -6.101   6.660  1.00 18.60           C  
ATOM    835  N   PRO    89      38.226  -8.441   7.691  1.00 17.46           N  
ATOM    836  CA  PRO    89      39.693  -8.472   7.841  1.00 18.21           C  
ATOM    837  C   PRO    89      40.371  -7.648   6.736  1.00 17.75           C  
ATOM    838  O   PRO    89      39.796  -7.459   5.639  1.00 17.90           O  
ATOM    839  CB  PRO    89      40.068  -9.953   7.641  1.00 19.26           C  
ATOM    840  CG  PRO    89      38.811 -10.684   7.578  1.00 22.10           C  
ATOM    841  CD  PRO    89      37.644  -9.760   7.350  1.00 19.36           C  
ATOM    842  N   ALA    90      41.602  -7.223   7.002  1.00 17.81           N  
ATOM    843  CA  ALA    90      42.410  -6.568   5.984  1.00 17.60           C  
ATOM    844  C   ALA    90      42.467  -7.417   4.715  1.00 17.75           C  
ATOM    845  O   ALA    90      42.462  -8.685   4.788  1.00 18.42           O  
ATOM    846  CB  ALA    90      43.820  -6.416   6.507  1.00 17.36           C  
ATOM    847  N   GLU    91      42.491  -6.715   3.575  1.00 17.80           N  
ATOM    848  CA  GLU    91      42.560  -7.340   2.249  1.00 19.04           C  
ATOM    849  C   GLU    91      41.258  -7.999   1.794  1.00 19.36           C  
ATOM    850  O   GLU    91      41.232  -8.778   0.813  1.00 21.60           O  
ATOM    851  CB  GLU    91      43.726  -8.338   2.133  1.00 19.33           C  
ATOM    852  CG  GLU    91      45.078  -7.770   2.532  1.00 21.26           C  
ATOM    853  CD  GLU    91      45.639  -6.748   1.523  1.00 23.31           C  
ATOM    854  OE1 GLU    91      44.913  -6.288   0.616  1.00 24.66           O  
ATOM    855  OE2 GLU    91      46.819  -6.375   1.678  1.00 27.27           O  
ATOM    856  N   CYS    92      40.167  -7.659   2.459  1.00 19.41           N  
ATOM    857  CA  CYS    92      38.849  -8.089   2.002  1.00 18.30           C  
ATOM    858  C   CYS    92      38.121  -6.846   1.474  1.00 17.59           C  
ATOM    859  O   CYS    92      37.976  -5.859   2.211  1.00 18.82           O  
ATOM    860  CB  CYS    92      38.069  -8.689   3.170  1.00 18.57           C  
ATOM    861  SG  CYS    92      36.398  -9.298   2.672  1.00 22.65           S  
ATOM    862  N   TRP    93      37.619  -6.904   0.239  1.00 16.71           N  
ATOM    863  CA  TRP    93      36.846  -5.767  -0.287  1.00 16.83           C  
ATOM    864  C   TRP    93      35.498  -5.678   0.429  1.00 17.61           C  
ATOM    865  O   TRP    93      34.892  -6.700   0.734  1.00 17.54           O  
ATOM    866  CB  TRP    93      36.578  -6.006  -1.784  1.00 17.22           C  
ATOM    867  CG  TRP    93      37.800  -5.880  -2.605  1.00 17.28           C  
ATOM    868  CD1 TRP    93      38.625  -6.899  -3.028  1.00 18.03           C  
ATOM    869  CD2 TRP    93      38.359  -4.657  -3.124  1.00 17.06           C  
ATOM    870  NE1 TRP    93      39.685  -6.363  -3.791  1.00 18.99           N  
ATOM    871  CE2 TRP    93      39.519  -5.001  -3.878  1.00 19.05           C  
ATOM    872  CE3 TRP    93      37.968  -3.311  -3.050  1.00 18.33           C  
ATOM    873  CZ2 TRP    93      40.312  -4.031  -4.522  1.00 18.83           C  
ATOM    874  CZ3 TRP    93      38.772  -2.329  -3.662  1.00 18.94           C  
ATOM    875  CH2 TRP    93      39.942  -2.697  -4.389  1.00 17.89           C  
ATOM    876  N   PHE    94      35.015  -4.463   0.670  1.00 16.25           N  
ATOM    877  CA  PHE    94      33.733  -4.347   1.367  1.00 16.00           C  
ATOM    878  C   PHE    94      33.103  -3.013   1.053  1.00 16.50           C  
ATOM    879  O   PHE    94      33.760  -2.078   0.536  1.00 16.78           O  
ATOM    880  CB  PHE    94      33.967  -4.407   2.892  1.00 16.42           C  
ATOM    881  CG  PHE    94      34.644  -3.171   3.432  1.00 15.99           C  
ATOM    882  CD1 PHE    94      33.879  -2.105   4.005  1.00 17.05           C  
ATOM    883  CD2 PHE    94      36.019  -3.046   3.357  1.00 18.78           C  
ATOM    884  CE1 PHE    94      34.525  -0.935   4.439  1.00 16.59           C  
ATOM    885  CE2 PHE    94      36.676  -1.882   3.776  1.00 17.42           C  
ATOM    886  CZ  PHE    94      35.928  -0.838   4.327  1.00 17.25           C  
ATOM    887  N   TYR    95      31.823  -2.894   1.409  1.00 16.04           N  
ATOM    888  CA  TYR    95      31.191  -1.568   1.498  1.00 17.12           C  
ATOM    889  C   TYR    95      29.856  -1.764   2.171  1.00 17.96           C  
ATOM    890  O   TYR    95      29.424  -2.879   2.367  1.00 20.58           O  
ATOM    891  CB  TYR    95      30.998  -0.895   0.113  1.00 18.45           C  
ATOM    892  CG  TYR    95      31.337   0.580   0.122  1.00 18.66           C  
ATOM    893  CD1 TYR    95      32.587   0.990   0.570  1.00 19.74           C  
ATOM    894  CD2 TYR    95      30.402   1.534  -0.287  1.00 19.52           C  
ATOM    895  CE1 TYR    95      32.943   2.365   0.605  1.00 19.65           C  
ATOM    896  CE2 TYR    95      30.732   2.907  -0.250  1.00 18.72           C  
ATOM    897  CZ  TYR    95      31.999   3.288   0.206  1.00 20.62           C  
ATOM    898  OH  TYR    95      32.344   4.665   0.229  1.00 22.21           O  
ATOM    899  N   SER    96      29.203  -0.670   2.536  0.60 17.85           N  
ATOM    901  CA  SER    96      27.903  -0.753   3.193  0.60 17.20           C  
ATOM    903  C   SER    96      26.789  -0.333   2.243  0.60 17.09           C  
ATOM    905  O   SER    96      26.997   0.501   1.358  0.60 17.78           O  
ATOM    907  CB  SER    96      27.841   0.244   4.360  0.60 17.61           C  
ATOM    909  OG  SER    96      28.810  -0.014   5.351  0.60 17.19           O  
ATOM    911  N   ILE    97      25.591  -0.868   2.483  1.00 16.44           N  
ATOM    912  CA  ILE    97      24.354  -0.321   1.901  1.00 16.59           C  
ATOM    913  C   ILE    97      23.466   0.075   3.073  1.00 16.37           C  
ATOM    914  O   ILE    97      23.232  -0.712   3.980  1.00 16.97           O  
ATOM    915  CB  ILE    97      23.598  -1.358   1.079  1.00 16.73           C  
ATOM    916  CG1 ILE    97      24.576  -2.160   0.227  1.00 18.48           C  
ATOM    917  CG2 ILE    97      22.560  -0.652   0.174  1.00 16.97           C  
ATOM    918  CD1 ILE    97      23.902  -3.326  -0.606  1.00 17.80           C  
ATOM    919  N   THR    98      23.017   1.331   3.080  1.00 15.49           N  
ATOM    920  CA  THR    98      22.286   1.859   4.223  1.00 16.39           C  
ATOM    921  C   THR    98      21.072   2.651   3.774  1.00 16.27           C  
ATOM    922  O   THR    98      20.908   2.874   2.568  1.00 17.78           O  
ATOM    923  CB  THR    98      23.211   2.765   5.097  1.00 16.82           C  
ATOM    924  OG1 THR    98      23.608   3.912   4.341  1.00 17.49           O  
ATOM    925  CG2 THR    98      24.464   2.014   5.498  1.00 16.73           C  
ATOM    926  N   GLN    99      20.236   3.037   4.733  1.00 16.84           N  
ATOM    927  CA  GLN    99      19.023   3.786   4.445  1.00 17.55           C  
ATOM    928  C   GLN    99      19.118   5.115   5.158  1.00 17.89           C  
ATOM    929  O   GLN    99      20.071   5.344   5.952  1.00 17.09           O  
ATOM    930  CB  GLN    99      17.817   2.960   4.903  1.00 17.09           C  
ATOM    931  CG  GLN    99      17.684   1.680   4.073  1.00 19.07           C  
ATOM    932  CD  GLN    99      16.368   0.929   4.356  1.00 17.48           C  
ATOM    933  OE1 GLN    99      15.827   0.962   5.462  1.00 19.87           O  
ATOM    934  NE2 GLN    99      15.842   0.280   3.318  1.00 20.07           N  
ATOM    935  N   LYS   100      18.167   6.016   4.869  1.00 18.24           N  
ATOM    936  CA  LYS   100      18.372   7.390   5.328  1.00 19.40           C  
ATOM    937  C   LYS   100      18.445   7.522   6.839  1.00 18.81           C  
ATOM    938  O   LYS   100      19.093   8.459   7.347  1.00 20.39           O  
ATOM    939  CB  LYS   100      17.344   8.344   4.722  1.00 20.14           C  
ATOM    940  CG  LYS   100      17.807   8.722   3.296  1.00 25.10           C  
ATOM    941  CD  LYS   100      17.413  10.126   2.880  1.00 35.39           C  
ATOM    942  CE  LYS   100      17.894  10.393   1.474  1.00 37.85           C  
ATOM    943  NZ  LYS   100      17.334   9.340   0.590  1.00 43.07           N  
ATOM    944  N   ASP   101      17.819   6.596   7.562  1.00 18.77           N  
ATOM    945  CA  ASP   101      17.849   6.637   9.032  1.00 18.97           C  
ATOM    946  C   ASP   101      18.862   5.684   9.673  1.00 19.71           C  
ATOM    947  O   ASP   101      18.846   5.468  10.885  1.00 20.13           O  
ATOM    948  CB  ASP   101      16.470   6.352   9.623  1.00 21.14           C  
ATOM    949  CG  ASP   101      15.902   5.004   9.206  1.00 24.80           C  
ATOM    950  OD1 ASP   101      16.414   4.346   8.270  1.00 24.17           O  
ATOM    951  OD2 ASP   101      14.860   4.613   9.808  1.00 30.33           O  
ATOM    952  N   THR   102      19.724   5.102   8.860  1.00 17.06           N  
ATOM    953  CA  THR   102      20.753   4.177   9.371  1.00 17.20           C  
ATOM    954  C   THR   102      21.889   4.902  10.090  1.00 17.58           C  
ATOM    955  O   THR   102      22.381   5.936   9.603  1.00 17.93           O  
ATOM    956  CB  THR   102      21.326   3.378   8.205  1.00 16.57           C  
ATOM    957  OG1 THR   102      20.262   2.654   7.559  1.00 17.53           O  
ATOM    958  CG2 THR   102      22.397   2.359   8.701  1.00 16.80           C  
ATOM    959  N   LYS   103      22.363   4.314  11.198  1.00 17.25           N  
ATOM    960  CA  LYS   103      23.555   4.803  11.872  1.00 16.04           C  
ATOM    961  C   LYS   103      24.375   3.590  12.301  1.00 17.48           C  
ATOM    962  O   LYS   103      23.787   2.647  12.869  1.00 17.08           O  
ATOM    963  CB  LYS   103      23.136   5.585  13.113  1.00 17.08           C  
ATOM    964  CG  LYS   103      24.323   6.281  13.816  1.00 18.18           C  
ATOM    965  CD  LYS   103      23.881   7.037  15.083  1.00 17.54           C  
ATOM    966  CE  LYS   103      22.969   8.210  14.792  1.00 17.74           C  
ATOM    967  NZ  LYS   103      23.675   9.408  14.151  1.00 17.79           N  
ATOM    968  N   MET   104      25.674   3.601  12.015  1.00 16.61           N  
ATOM    969  CA  MET   104      26.548   2.545  12.515  1.00 18.76           C  
ATOM    970  C   MET   104      27.829   3.126  13.028  1.00 18.07           C  
ATOM    971  O   MET   104      28.140   4.287  12.750  1.00 18.20           O  
ATOM    972  CB  MET   104      26.832   1.498  11.444  1.00 21.04           C  
ATOM    973  CG  MET   104      27.693   1.995  10.381  1.00 20.27           C  
ATOM    974  SD  MET   104      28.064   0.469   9.085  0.65 25.94          SE  
ATOM    975  CE  MET   104      26.490   0.644   8.340  1.00 12.83           C  
ATOM    976  N   MET   105      28.546   2.355  13.841  1.00 16.39           N  
ATOM    977  CA  MET   105      29.865   2.791  14.274  1.00 16.00           C  
ATOM    978  C   MET   105      30.870   1.843  13.689  1.00 16.24           C  
ATOM    979  O   MET   105      30.551   0.676  13.404  1.00 16.92           O  
ATOM    980  CB  MET   105      29.987   2.739  15.796  1.00 17.84           C  
ATOM    981  CG  MET   105      29.272   3.873  16.539  1.00 18.81           C  
ATOM    982  SD  MET   105      27.305   3.624  16.437  0.65 22.03          SE  
ATOM    983  CE  MET   105      26.852   4.856  17.895  1.00 19.82           C  
ATOM    984  N   TYR   106      32.079   2.338  13.459  1.00 15.94           N  
ATOM    985  CA  TYR   106      33.147   1.409  13.065  1.00 15.84           C  
ATOM    986  C   TYR   106      34.440   1.718  13.784  1.00 16.88           C  
ATOM    987  O   TYR   106      34.627   2.835  14.304  1.00 15.69           O  
ATOM    988  CB  TYR   106      33.333   1.386  11.548  1.00 17.37           C  
ATOM    989  CG  TYR   106      33.900   2.623  10.865  1.00 17.47           C  
ATOM    990  CD1 TYR   106      35.261   2.903  10.902  1.00 18.62           C  
ATOM    991  CD2 TYR   106      33.066   3.437  10.077  1.00 18.38           C  
ATOM    992  CE1 TYR   106      35.818   4.006  10.169  1.00 19.35           C  
ATOM    993  CE2 TYR   106      33.586   4.511   9.358  1.00 18.20           C  
ATOM    994  CZ  TYR   106      34.954   4.774   9.397  1.00 18.96           C  
ATOM    995  OH  TYR   106      35.485   5.823   8.665  1.00 20.37           O  
ATOM    996  N   VAL   107      35.269   0.673  13.871  1.00 16.69           N  
ATOM    997  CA  VAL   107      36.543   0.737  14.570  1.00 16.04           C  
ATOM    998  C   VAL   107      37.608   0.241  13.612  1.00 17.16           C  
ATOM    999  O   VAL   107      37.430  -0.776  12.944  1.00 16.81           O  
ATOM   1000  CB  VAL   107      36.533  -0.180  15.832  1.00 17.67           C  
ATOM   1001  CG1 VAL   107      37.847   0.002  16.625  1.00 17.38           C  
ATOM   1002  CG2 VAL   107      35.345   0.191  16.747  1.00 17.95           C  
ATOM   1003  N   GLN   108      38.702   0.982  13.518  1.00 17.82           N  
ATOM   1004  CA  GLN   108      39.866   0.519  12.703  1.00 18.01           C  
ATOM   1005  C   GLN   108      41.167   1.158  13.236  1.00 16.91           C  
ATOM   1006  O   GLN   108      41.138   1.936  14.171  1.00 17.32           O  
ATOM   1007  CB  GLN   108      39.712   0.894  11.213  1.00 18.57           C  
ATOM   1008  CG  GLN   108      39.699   2.410  11.035  1.00 19.50           C  
ATOM   1009  CD  GLN   108      39.527   2.873   9.607  1.00 24.12           C  
ATOM   1010  OE1 GLN   108      38.629   2.410   8.870  1.00 30.18           O  
ATOM   1011  NE2 GLN   108      40.376   3.781   9.213  1.00 32.65           N  
ATOM   1012  N   ASP   109      42.305   0.823  12.617  1.00 17.22           N  
ATOM   1013  CA  ASP   109      43.601   1.346  13.028  1.00 18.82           C  
ATOM   1014  C   ASP   109      43.622   2.853  12.801  1.00 20.82           C  
ATOM   1015  O   ASP   109      43.022   3.345  11.842  1.00 22.83           O  
ATOM   1016  CB  ASP   109      44.669   0.676  12.150  1.00 18.66           C  
ATOM   1017  CG  ASP   109      46.071   0.895  12.683  1.00 22.39           C  
ATOM   1018  OD1 ASP   109      46.557   2.062  12.669  1.00 24.76           O  
ATOM   1019  OD2 ASP   109      46.684  -0.113  13.066  1.00 24.55           O  
ATOM   1020  N   SER   110      44.262   3.596  13.694  1.00 21.00           N  
ATOM   1021  CA  SER   110      44.244   5.067  13.586  1.00 22.62           C  
ATOM   1022  C   SER   110      45.081   5.605  12.462  1.00 25.40           C  
ATOM   1023  O   SER   110      44.986   6.794  12.130  1.00 26.13           O  
ATOM   1024  CB  SER   110      44.637   5.744  14.889  1.00 22.48           C  
ATOM   1025  OG  SER   110      45.889   5.282  15.300  1.00 22.98           O  
ATOM   1026  N   ASN   111      45.892   4.759  11.841  0.50 26.61           N  
ATOM   1028  CA  ASN   111      46.619   5.173  10.626  0.50 29.51           C  
ATOM   1030  C   ASN   111      45.681   5.102   9.410  0.50 30.95           C  
ATOM   1032  O   ASN   111      45.748   4.156   8.625  0.50 32.22           O  
ATOM   1034  CB  ASN   111      47.838   4.276  10.385  0.50 29.55           C  
ATOM   1036  CG  ASN   111      48.726   4.132  11.602  0.50 31.43           C  
ATOM   1038  OD1 ASN   111      49.072   5.116  12.262  0.50 34.49           O  
ATOM   1040  ND2 ASN   111      49.124   2.894  11.894  0.50 34.01           N  
ATOM   1042  N   CYS   112      44.802   6.099   9.277  0.70 31.56           N  
ATOM   1043  CA  CYS   112      43.714   6.121   8.291  0.70 33.74           C  
ATOM   1044  C   CYS   112      44.025   6.946   7.039  0.70 35.48           C  
ATOM   1045  O   CYS   112      43.115   7.492   6.392  0.70 36.54           O  
ATOM   1046  CB  CYS   112      42.421   6.617   8.949  0.70 34.26           C  
ATOM   1047  SG  CYS   112      42.624   8.239   9.688  0.70 38.38           S  
ATOM   1048  N   SER   113      45.304   7.035   6.682  0.80 36.18           N  
ATOM   1049  CA  SER   113      45.657   7.515   5.355  0.80 37.26           C  
ATOM   1050  C   SER   113      45.138   6.506   4.323  0.80 37.37           C  
ATOM   1051  O   SER   113      45.038   5.311   4.592  0.80 38.31           O  
ATOM   1052  CB  SER   113      47.163   7.671   5.215  0.80 37.70           C  
ATOM   1053  OG  SER   113      47.763   6.406   5.045  0.80 40.92           O  
ATOM   1054  N   MET   114      44.784   7.001   3.147  1.00 36.61           N  
ATOM   1055  CA  MET   114      44.471   6.162   2.011  1.00 33.90           C  
ATOM   1056  C   MET   114      45.735   5.618   1.356  1.00 32.87           C  
ATOM   1057  O   MET   114      45.671   4.991   0.303  1.00 33.52           O  
ATOM   1058  CB  MET   114      43.673   6.968   0.992  1.00 34.29           C  
ATOM   1059  CG  MET   114      42.287   7.333   1.490  1.00 32.36           C  
ATOM   1060  SD  MET   114      41.175   5.772   1.643  0.55 31.57          SE  
ATOM   1061  CE  MET   114      41.516   4.865  -0.033  1.00 33.03           C  
ATOM   1062  N   ASP   115      46.893   5.872   1.969  1.00 30.98           N  
ATOM   1063  CA  ASP   115      48.127   5.247   1.531  1.00 29.39           C  
ATOM   1064  C   ASP   115      48.030   3.732   1.565  1.00 27.19           C  
ATOM   1065  O   ASP   115      48.696   3.061   0.786  1.00 28.38           O  
ATOM   1066  CB  ASP   115      49.284   5.647   2.457  1.00 31.04           C  
ATOM   1067  CG  ASP   115      49.683   7.106   2.301  1.00 36.35           C  
ATOM   1068  OD1 ASP   115      49.629   7.607   1.145  1.00 42.16           O  
ATOM   1069  OD2 ASP   115      50.065   7.734   3.328  1.00 40.44           O  
ATOM   1070  N   ASN   116      47.228   3.197   2.488  0.50 25.45           N  
ATOM   1072  CA  ASN   116      47.176   1.750   2.681  0.50 24.21           C  
ATOM   1074  C   ASN   116      45.799   1.164   2.389  0.50 22.98           C  
ATOM   1076  O   ASN   116      45.516   0.045   2.797  0.50 22.33           O  
ATOM   1078  CB  ASN   116      47.592   1.358   4.104  0.50 25.01           C  
ATOM   1080  CG  ASN   116      48.980   1.834   4.465  0.50 26.25           C  
ATOM   1082  OD1 ASN   116      49.848   1.970   3.602  0.50 30.22           O  
ATOM   1084  ND2 ASN   116      49.197   2.086   5.746  0.50 29.34           N  
ATOM   1086  N   SER   117      44.963   1.933   1.689  1.00 21.10           N  
ATOM   1087  CA  SER   117      43.626   1.481   1.305  1.00 20.32           C  
ATOM   1088  C   SER   117      43.373   1.845  -0.159  1.00 20.03           C  
ATOM   1089  O   SER   117      44.116   2.635  -0.762  1.00 21.17           O  
ATOM   1090  CB  SER   117      42.552   2.095   2.202  1.00 20.76           C  
ATOM   1091  OG  SER   117      42.802   1.844   3.590  1.00 22.22           O  
ATOM   1092  N   ASP   118      42.327   1.281  -0.746  1.00 18.98           N  
ATOM   1093  CA  ASP   118      41.985   1.582  -2.128  1.00 18.98           C  
ATOM   1094  C   ASP   118      40.481   1.476  -2.334  1.00 17.82           C  
ATOM   1095  O   ASP   118      39.797   0.823  -1.529  1.00 18.84           O  
ATOM   1096  CB  ASP   118      42.653   0.597  -3.081  1.00 18.47           C  
ATOM   1097  CG  ASP   118      44.134   0.915  -3.329  1.00 23.99           C  
ATOM   1098  OD1 ASP   118      44.418   1.937  -4.000  1.00 25.51           O  
ATOM   1099  OD2 ASP   118      44.999   0.142  -2.847  1.00 24.80           O  
ATOM   1100  N   PHE   119      39.976   2.113  -3.390  1.00 16.98           N  
ATOM   1101  CA  PHE   119      38.613   1.890  -3.870  1.00 17.39           C  
ATOM   1102  C   PHE   119      38.675   1.277  -5.266  1.00 17.52           C  
ATOM   1103  O   PHE   119      39.670   1.445  -5.981  1.00 17.46           O  
ATOM   1104  CB  PHE   119      37.807   3.196  -3.976  1.00 18.11           C  
ATOM   1105  CG  PHE   119      37.442   3.782  -2.642  1.00 17.20           C  
ATOM   1106  CD1 PHE   119      36.241   3.464  -2.011  1.00 17.33           C  
ATOM   1107  CD2 PHE   119      38.331   4.662  -2.005  1.00 19.04           C  
ATOM   1108  CE1 PHE   119      35.939   4.024  -0.751  1.00 20.51           C  
ATOM   1109  CE2 PHE   119      38.034   5.201  -0.745  1.00 20.22           C  
ATOM   1110  CZ  PHE   119      36.845   4.895  -0.135  1.00 20.12           C  
ATOM   1111  N   CYS   120      37.628   0.572  -5.670  1.00 17.45           N  
ATOM   1112  CA  CYS   120      37.555   0.047  -7.026  1.00 17.73           C  
ATOM   1113  C   CYS   120      36.106   0.087  -7.475  1.00 18.47           C  
ATOM   1114  O   CYS   120      35.201  -0.272  -6.689  1.00 17.83           O  
ATOM   1115  CB  CYS   120      38.089  -1.401  -7.045  1.00 18.30           C  
ATOM   1116  SG  CYS   120      38.102  -2.100  -8.702  0.85 21.04           S  
ATOM   1117  N   ASP   121      35.859   0.534  -8.706  1.00 18.02           N  
ATOM   1118  CA  ASP   121      34.503   0.578  -9.212  1.00 18.36           C  
ATOM   1119  C   ASP   121      33.919  -0.819  -9.406  1.00 19.09           C  
ATOM   1120  O   ASP   121      34.624  -1.758  -9.800  1.00 20.85           O  
ATOM   1121  CB  ASP   121      34.500   1.247 -10.587  1.00 18.48           C  
ATOM   1122  CG  ASP   121      34.724   2.753 -10.529  1.00 22.48           C  
ATOM   1123  OD1 ASP   121      34.777   3.377  -9.432  1.00 23.19           O  
ATOM   1124  OD2 ASP   121      34.794   3.308 -11.654  1.00 24.90           O  
ATOM   1125  N   LEU   122      32.619  -0.916  -9.181  1.00 18.88           N  
ATOM   1126  CA  LEU   122      31.864  -2.076  -9.555  1.00 19.10           C  
ATOM   1127  C   LEU   122      31.440  -1.902 -11.008  1.00 20.26           C  
ATOM   1128  O   LEU   122      31.216  -0.778 -11.467  1.00 21.26           O  
ATOM   1129  CB  LEU   122      30.615  -2.141  -8.682  1.00 19.71           C  
ATOM   1130  CG  LEU   122      30.854  -2.431  -7.195  1.00 18.36           C  
ATOM   1131  CD1 LEU   122      29.620  -2.013  -6.392  1.00 20.58           C  
ATOM   1132  CD2 LEU   122      31.061  -3.930  -7.010  1.00 21.72           C  
ATOM   1133  N   SER   123      31.288  -3.024 -11.710  1.00 20.30           N  
ATOM   1134  CA  SER   123      30.757  -2.964 -13.084  1.00 21.25           C  
ATOM   1135  C   SER   123      29.244  -2.686 -13.056  1.00 21.59           C  
ATOM   1136  O   SER   123      28.599  -2.828 -11.995  1.00 20.17           O  
ATOM   1137  CB  SER   123      30.982  -4.316 -13.769  1.00 21.57           C  
ATOM   1138  OG  SER   123      30.121  -5.293 -13.208  1.00 21.76           O  
ATOM   1139  N   LYS   124      28.651  -2.482 -14.240  0.50 21.41           N  
ATOM   1141  CA  LYS   124      27.189  -2.349 -14.367  0.50 22.09           C  
ATOM   1143  C   LYS   124      26.407  -3.585 -13.913  0.50 20.42           C  
ATOM   1145  O   LYS   124      25.404  -3.454 -13.193  0.50 19.79           O  
ATOM   1147  CB  LYS   124      26.775  -1.962 -15.804  0.50 22.57           C  
ATOM   1149  CG  LYS   124      25.663  -0.888 -15.824  0.50 25.93           C  
ATOM   1151  CD  LYS   124      25.184  -0.523 -17.241  0.50 25.36           C  
ATOM   1153  CE  LYS   124      26.129   0.427 -17.981  0.50 30.01           C  
ATOM   1155  NZ  LYS   124      25.505   0.962 -19.259  0.50 30.02           N  
ATOM   1157  N   GLU   125      26.825  -4.780 -14.331  0.60 19.59           N  
ATOM   1159  CA  GLU   125      26.131  -5.996 -13.881  0.60 19.69           C  
ATOM   1161  C   GLU   125      26.302  -6.092 -12.373  0.60 18.94           C  
ATOM   1163  O   GLU   125      25.366  -6.501 -11.678  0.60 18.66           O  
ATOM   1165  CB  GLU   125      26.661  -7.290 -14.526  0.60 19.99           C  
ATOM   1167  CG  GLU   125      26.151  -8.577 -13.844  0.60 20.98           C  
ATOM   1169  CD  GLU   125      26.607  -9.843 -14.539  0.60 21.63           C  
ATOM   1171  OE1 GLU   125      26.261 -10.005 -15.714  0.60 19.71           O  
ATOM   1173  OE2 GLU   125      27.260 -10.698 -13.888  0.60 27.62           O  
ATOM   1175  N   GLU   126      27.489  -5.753 -11.848  1.00 19.08           N  
ATOM   1176  CA  GLU   126      27.648  -5.938 -10.406  1.00 18.73           C  
ATOM   1177  C   GLU   126      26.741  -5.028  -9.609  1.00 18.15           C  
ATOM   1178  O   GLU   126      26.161  -5.438  -8.607  1.00 17.99           O  
ATOM   1179  CB  GLU   126      29.117  -5.727 -10.000  1.00 18.57           C  
ATOM   1180  CG  GLU   126      29.971  -6.889 -10.484  1.00 18.38           C  
ATOM   1181  CD  GLU   126      31.451  -6.622 -10.553  1.00 23.86           C  
ATOM   1182  OE1 GLU   126      31.903  -5.448 -10.410  1.00 22.43           O  
ATOM   1183  OE2 GLU   126      32.148  -7.648 -10.769  1.00 26.13           O  
ATOM   1184  N   ILE   127      26.640  -3.766 -10.046  1.00 17.91           N  
ATOM   1185  CA  ILE   127      25.729  -2.831  -9.371  1.00 17.65           C  
ATOM   1186  C   ILE   127      24.278  -3.349  -9.459  1.00 17.13           C  
ATOM   1187  O   ILE   127      23.605  -3.412  -8.428  1.00 17.30           O  
ATOM   1188  CB  ILE   127      25.860  -1.432  -9.962  1.00 18.60           C  
ATOM   1189  CG1 ILE   127      27.226  -0.907  -9.564  1.00 18.46           C  
ATOM   1190  CG2 ILE   127      24.801  -0.512  -9.437  1.00 19.31           C  
ATOM   1191  CD1 ILE   127      27.652   0.347 -10.378  1.00 20.44           C  
ATOM   1192  N   GLU   128      23.824  -3.758 -10.663  1.00 18.39           N  
ATOM   1193  CA  GLU   128      22.454  -4.230 -10.797  1.00 20.00           C  
ATOM   1194  C   GLU   128      22.223  -5.470  -9.953  1.00 18.15           C  
ATOM   1195  O   GLU   128      21.169  -5.629  -9.342  1.00 18.91           O  
ATOM   1196  CB  GLU   128      22.138  -4.598 -12.257  1.00 20.94           C  
ATOM   1197  CG  GLU   128      22.052  -3.429 -13.162  1.00 23.65           C  
ATOM   1198  CD  GLU   128      21.814  -3.828 -14.628  1.00 25.57           C  
ATOM   1199  OE1 GLU   128      21.660  -5.043 -14.953  1.00 30.78           O  
ATOM   1200  OE2 GLU   128      21.811  -2.893 -15.466  1.00 32.76           O  
ATOM   1201  N   TYR   129      23.200  -6.376  -9.937  1.00 17.26           N  
ATOM   1202  CA  TYR   129      23.116  -7.601  -9.141  1.00 17.84           C  
ATOM   1203  C   TYR   129      22.970  -7.266  -7.649  1.00 18.04           C  
ATOM   1204  O   TYR   129      22.105  -7.813  -6.920  1.00 18.35           O  
ATOM   1205  CB  TYR   129      24.391  -8.393  -9.363  1.00 18.21           C  
ATOM   1206  CG  TYR   129      24.534  -9.595  -8.483  1.00 18.38           C  
ATOM   1207  CD1 TYR   129      23.709 -10.725  -8.630  1.00 18.41           C  
ATOM   1208  CD2 TYR   129      25.523  -9.622  -7.498  1.00 20.53           C  
ATOM   1209  CE1 TYR   129      23.864 -11.827  -7.804  1.00 17.58           C  
ATOM   1210  CE2 TYR   129      25.680 -10.727  -6.675  1.00 19.51           C  
ATOM   1211  CZ  TYR   129      24.855 -11.837  -6.813  1.00 18.04           C  
ATOM   1212  OH  TYR   129      25.046 -12.968  -6.031  1.00 20.25           O  
ATOM   1213  N   ILE   130      23.838  -6.374  -7.162  1.00 16.52           N  
ATOM   1214  CA  ILE   130      23.709  -5.978  -5.770  1.00 17.09           C  
ATOM   1215  C   ILE   130      22.356  -5.330  -5.503  1.00 16.91           C  
ATOM   1216  O   ILE   130      21.727  -5.628  -4.479  1.00 18.49           O  
ATOM   1217  CB  ILE   130      24.863  -5.005  -5.382  1.00 17.07           C  
ATOM   1218  CG1 ILE   130      26.193  -5.809  -5.366  1.00 17.50           C  
ATOM   1219  CG2 ILE   130      24.540  -4.313  -4.062  1.00 18.07           C  
ATOM   1220  CD1 ILE   130      27.479  -4.888  -5.348  1.00 19.29           C  
ATOM   1221  N   GLN   131      21.902  -4.417  -6.379  1.00 16.81           N  
ATOM   1222  CA  GLN   131      20.627  -3.733  -6.147  1.00 16.26           C  
ATOM   1223  C   GLN   131      19.446  -4.743  -6.100  1.00 16.96           C  
ATOM   1224  O   GLN   131      18.583  -4.655  -5.232  1.00 17.72           O  
ATOM   1225  CB  GLN   131      20.379  -2.693  -7.226  1.00 17.36           C  
ATOM   1226  CG  GLN   131      21.329  -1.508  -7.062  1.00 17.32           C  
ATOM   1227  CD  GLN   131      21.262  -0.489  -8.196  1.00 18.14           C  
ATOM   1228  OE1 GLN   131      20.970  -0.828  -9.350  1.00 21.38           O  
ATOM   1229  NE2 GLN   131      21.621   0.769  -7.879  1.00 20.80           N  
ATOM   1230  N   THR   132      19.419  -5.674  -7.054  1.00 16.48           N  
ATOM   1231  CA  THR   132      18.346  -6.671  -7.094  1.00 16.57           C  
ATOM   1232  C   THR   132      18.269  -7.419  -5.769  1.00 17.80           C  
ATOM   1233  O   THR   132      17.198  -7.577  -5.188  1.00 18.56           O  
ATOM   1234  CB  THR   132      18.604  -7.637  -8.232  1.00 18.12           C  
ATOM   1235  OG1 THR   132      18.408  -6.933  -9.460  1.00 18.40           O  
ATOM   1236  CG2 THR   132      17.597  -8.815  -8.160  1.00 17.65           C  
ATOM   1237  N   ASN   133      19.409  -7.901  -5.303  1.00 17.31           N  
ATOM   1238  CA  ASN   133      19.415  -8.773  -4.108  1.00 17.08           C  
ATOM   1239  C   ASN   133      19.311  -7.976  -2.822  1.00 17.38           C  
ATOM   1240  O   ASN   133      18.656  -8.409  -1.867  1.00 18.85           O  
ATOM   1241  CB  ASN   133      20.651  -9.693  -4.135  1.00 17.47           C  
ATOM   1242  CG  ASN   133      20.577 -10.696  -5.293  1.00 20.14           C  
ATOM   1243  OD1 ASN   133      21.201 -10.534  -6.357  1.00 20.33           O  
ATOM   1244  ND2 ASN   133      19.772 -11.703  -5.112  1.00 16.52           N  
ATOM   1245  N   ALA   134      19.907  -6.785  -2.801  1.00 17.14           N  
ATOM   1246  CA  ALA   134      19.819  -5.949  -1.597  1.00 17.67           C  
ATOM   1247  C   ALA   134      18.425  -5.402  -1.350  1.00 17.75           C  
ATOM   1248  O   ALA   134      18.010  -5.294  -0.191  1.00 18.61           O  
ATOM   1249  CB  ALA   134      20.833  -4.785  -1.649  1.00 18.35           C  
ATOM   1250  N   ARG   135      17.690  -5.062  -2.413  0.50 17.68           N  
ATOM   1252  CA  ARG   135      16.292  -4.640  -2.250  0.50 18.19           C  
ATOM   1254  C   ARG   135      15.572  -5.671  -1.405  0.50 17.60           C  
ATOM   1256  O   ARG   135      14.915  -5.319  -0.421  0.50 17.24           O  
ATOM   1258  CB  ARG   135      15.558  -4.482  -3.598  0.50 18.84           C  
ATOM   1260  CG  ARG   135      15.634  -3.088  -4.185  0.50 20.89           C  
ATOM   1262  CD  ARG   135      14.767  -2.913  -5.452  0.50 19.82           C  
ATOM   1264  NE  ARG   135      15.253  -3.691  -6.597  0.50 21.02           N  
ATOM   1266  CZ  ARG   135      16.118  -3.257  -7.510  0.50 20.55           C  
ATOM   1268  NH1 ARG   135      16.660  -2.051  -7.414  0.50 19.77           N  
ATOM   1270  NH2 ARG   135      16.470  -4.039  -8.515  0.50 20.94           N  
ATOM   1272  N   LYS   136      15.739  -6.941  -1.769  1.00 17.30           N  
ATOM   1273  CA  LYS   136      15.013  -8.042  -1.104  1.00 16.20           C  
ATOM   1274  C   LYS   136      15.561  -8.221   0.317  1.00 16.60           C  
ATOM   1275  O   LYS   136      14.805  -8.320   1.280  1.00 16.64           O  
ATOM   1276  CB  LYS   136      15.162  -9.303  -1.914  1.00 17.03           C  
ATOM   1277  CG  LYS   136      14.430  -9.172  -3.243  1.00 20.14           C  
ATOM   1278  CD  LYS   136      14.770 -10.338  -4.113  1.00 23.30           C  
ATOM   1279  CE  LYS   136      14.162 -10.175  -5.516  1.00 25.56           C  
ATOM   1280  NZ  LYS   136      12.720 -10.573  -5.377  1.00 29.92           N  
ATOM   1281  N   LEU   137      16.893  -8.204   0.420  1.00 16.81           N  
ATOM   1282  CA  LEU   137      17.533  -8.532   1.692  1.00 16.98           C  
ATOM   1283  C   LEU   137      17.144  -7.528   2.759  1.00 17.23           C  
ATOM   1284  O   LEU   137      16.991  -7.903   3.926  1.00 17.59           O  
ATOM   1285  CB  LEU   137      19.054  -8.638   1.497  1.00 17.81           C  
ATOM   1286  CG  LEU   137      19.910  -9.022   2.716  1.00 18.22           C  
ATOM   1287  CD1 LEU   137      19.354 -10.327   3.309  1.00 18.14           C  
ATOM   1288  CD2 LEU   137      21.383  -9.126   2.302  1.00 17.26           C  
ATOM   1289  N   PHE   138      16.984  -6.245   2.373  1.00 17.07           N  
ATOM   1290  CA  PHE   138      16.586  -5.233   3.356  1.00 18.73           C  
ATOM   1291  C   PHE   138      15.282  -5.558   4.070  1.00 19.99           C  
ATOM   1292  O   PHE   138      15.090  -5.139   5.217  1.00 21.34           O  
ATOM   1293  CB  PHE   138      16.442  -3.844   2.687  1.00 18.10           C  
ATOM   1294  CG  PHE   138      17.686  -3.006   2.719  1.00 17.50           C  
ATOM   1295  CD1 PHE   138      18.139  -2.388   1.555  1.00 16.88           C  
ATOM   1296  CD2 PHE   138      18.396  -2.812   3.903  1.00 17.33           C  
ATOM   1297  CE1 PHE   138      19.283  -1.541   1.583  1.00 18.86           C  
ATOM   1298  CE2 PHE   138      19.527  -1.973   3.909  1.00 19.25           C  
ATOM   1299  CZ  PHE   138      19.952  -1.367   2.760  1.00 17.67           C  
ATOM   1300  N   GLU   139      14.439  -6.386   3.444  1.00 18.92           N  
ATOM   1301  CA  GLU   139      13.138  -6.676   3.996  1.00 19.71           C  
ATOM   1302  C   GLU   139      13.066  -8.043   4.661  1.00 17.95           C  
ATOM   1303  O   GLU   139      12.014  -8.404   5.137  1.00 18.66           O  
ATOM   1304  CB  GLU   139      12.101  -6.581   2.895  1.00 19.85           C  
ATOM   1305  CG  GLU   139      12.117  -5.275   2.063  1.00 23.35           C  
ATOM   1306  CD  GLU   139      12.058  -4.002   2.912  1.00 30.03           C  
ATOM   1307  OE1 GLU   139      11.489  -3.989   4.046  1.00 30.29           O  
ATOM   1308  OE2 GLU   139      12.582  -2.966   2.407  1.00 33.04           O  
ATOM   1309  N   LYS   140      14.176  -8.786   4.703  1.00 17.80           N  
ATOM   1310  CA  LYS   140      14.103 -10.176   5.243  1.00 19.28           C  
ATOM   1311  C   LYS   140      14.286 -10.219   6.749  1.00 21.74           C  
ATOM   1312  O   LYS   140      14.695  -9.206   7.393  1.00 21.57           O  
ATOM   1313  CB  LYS   140      15.170 -11.064   4.589  1.00 18.37           C  
ATOM   1314  CG  LYS   140      14.909 -11.354   3.112  1.00 18.79           C  
ATOM   1315  CD  LYS   140      16.003 -12.193   2.490  1.00 19.32           C  
ATOM   1316  CE  LYS   140      15.652 -12.412   0.999  1.00 21.12           C  
ATOM   1317  NZ  LYS   140      16.766 -13.100   0.285  1.00 22.33           N  
ATOM   1318  OXT LYS   140      14.000 -11.276   7.370  1.00 23.13           O  
END
