
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   64 (  636),  selected   64 , name 1c8c_A
# Molecule2: number of CA atoms  109 (  889),  selected  109 , name T0415.pdb
# PARAMETERS: 1c8c_A.T0415.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      G       1           #
LGA    A     2_A      K       2          3.574
LGA    -       -      S       3           -
LGA    T     3_A      V       4          1.417
LGA    V     4_A      V       5          0.837
LGA    K     5_A      T       6          1.125
LGA    F     6_A      L       7          2.363
LGA    K     7_A      K       8          1.729
LGA    Y     8_A      T       9          0.372
LGA    K     9_A      T      10          1.400
LGA    G    10_A      D      11          1.109
LGA    E    11_A      G      12          0.944
LGA    E    12_A      W      13          1.424
LGA    K    13_A      I      14          1.149
LGA    Q    14_A      P      15          0.907
LGA    V    15_A      V      16          0.697
LGA    D    16_A      P      17          0.777
LGA    I    17_A      F      18          1.419
LGA    S    18_A      S      19          1.234
LGA    K    19_A      K      20          0.362
LGA    I    20_A      V      21          0.864
LGA    K    21_A      M      22          1.516
LGA    K    22_A      Y      23          2.645
LGA    V    23_A      L      24          2.099
LGA    W    24_A      E      25          1.524
LGA    R    25_A      A      26          1.142
LGA    V    26_A      K      27          1.076
LGA    G    27_A      D      28          4.886
LGA    K    28_A      K      29          3.586
LGA    M    29_A      K      30          1.360
LGA    I    30_A      T      31          1.394
LGA    S    31_A      Y      32          1.033
LGA    F    32_A      V      33          2.772
LGA    T    33_A      N      34          1.740
LGA    Y    34_A      A      35          0.980
LGA    D    35_A      E      36          1.676
LGA    E    36_A      E      37          3.652
LGA    G    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    G    39_A      -       -           -
LGA    K    40_A      -       -           -
LGA    T    41_A      -       -           -
LGA    G    42_A      L      38          0.844
LGA    R    43_A      T      39          0.890
LGA    G    44_A      G      40          1.031
LGA    A    45_A      T      41          1.687
LGA    V    46_A      H      42          1.052
LGA    S    47_A      K      43          2.165
LGA    E    48_A      Y      44          2.855
LGA    K    49_A      S      45          4.518
LGA    D    50_A      L      46           -
LGA    -       -      Q      47           -
LGA    A    51_A      E      48          4.819
LGA    P    52_A      F      49          3.396
LGA    K    53_A      E      50          3.098
LGA    -       -      Y      51           -
LGA    -       -      L      52           -
LGA    E    54_A      L      53          1.231
LGA    L    55_A      P      54           -
LGA    L    56_A      K      55           -
LGA    -       -      D      56           -
LGA    -       -      S      57           -
LGA    Q    57_A      F      58          4.930
LGA    M    58_A      I      59          3.585
LGA    L    59_A      R      60          4.030
LGA    A    60_A      C      61          3.137
LGA    K    61_A      H      62           #
LGA    -       -      R      63           -
LGA    -       -      S      64           -
LGA    -       -      F      65           -
LGA    -       -      I      66           -
LGA    Q    62_A      V      67          4.222
LGA    -       -      N      68           -
LGA    -       -      V      69           -
LGA    -       -      N      70           -
LGA    -       -      H      71           -
LGA    -       -      I      72           -
LGA    -       -      K      73           -
LGA    -       -      A      74           -
LGA    -       -      I      75           -
LGA    -       -      Y      76           -
LGA    -       -      P      77           -
LGA    -       -      D      78           -
LGA    -       -      T      79           -
LGA    -       -      H      80           -
LGA    -       -      S      81           -
LGA    -       -      T      82           -
LGA    -       -      F      83           -
LGA    -       -      L      84           -
LGA    -       -      L      85           -
LGA    -       -      S      86           -
LGA    -       -      M      87           -
LGA    -       -      D      88           -
LGA    -       -      N      89           -
LGA    -       -      G      90           -
LGA    -       -      E      91           -
LGA    -       -      R      92           -
LGA    K    63_A      V      93          4.904
LGA    K    64_A      P      94          3.747
LGA    -       -      V      95           -
LGA    -       -      S      96           -
LGA    -       -      Q      97           -
LGA    -       -      S      98           -
LGA    -       -      Y      99           -
LGA    -       -      A     100           -
LGA    -       -      S     101           -
LGA    -       -      Y     102           -
LGA    -       -      F     103           -
LGA    -       -      R     104           -
LGA    -       -      K     105           -
LGA    -       -      L     106           -
LGA    -       -      L     107           -
LGA    -       -      G     108           -
LGA    -       -      F     109           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   64  109    5.0     54    2.48    14.81     38.427     2.094

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.144735 * X  +   0.776954 * Y  +  -0.612695 * Z  + -22.257339
  Y_new =   0.985289 * X  +   0.056300 * Y  +  -0.161358 * Z  +  32.671665
  Z_new =  -0.090873 * X  +  -0.627035 * Y  +  -0.773672 * Z  +  37.484039 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.460502    0.681090  [ DEG:  -140.9764     39.0236 ]
  Theta =   0.090998    3.050594  [ DEG:     5.2138    174.7862 ]
  Phi   =   1.716649   -1.424943  [ DEG:    98.3568    -81.6432 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1c8c_A                                        
REMARK     2: T0415.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1c8c_A.T0415.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   64  109   5.0   54   2.48   14.81  38.427
REMARK  ---------------------------------------------------------- 
MOLECULE 1c8c_A
HEADER    DNA BINDING PROTEIN/DNA                 04-MAY-00   1C8C              
TITLE     CRYSTAL STRUCTURES OF THE CHROMOSOMAL PROTEINS SSO7D/SAC7D            
TITLE    2 BOUND TO DNA CONTAINING T-G MISMATCHED BASE PAIRS                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DNA-BINDING PROTEIN 7A;                                    
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: SSO7D, 7 KDA DNA-BINDING PROTEIN D;                         
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: 5'-D(*GP*TP*GP*AP*TP*CP*GP*C)-3';                          
COMPND   7 CHAIN: B, C;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SULFOLOBUS SOLFATARICUS;                        
SOURCE   3 ATCC: DSM 1617;                                                      
SOURCE   4 COLLECTION: DSM 1617;                                                
SOURCE   5 OTHER_DETAILS: GERMAN COLLECTION OF MICROORGANISMS (DSM)             
SOURCE   6 1617, #1616;                                                         
SOURCE   7 MOL_ID: 2;                                                           
SOURCE   8 SYNTHETIC: YES                                                       
KEYWDS    DNA BINDING PROTEIN, PROTEIN-DNA INTERACTION, PROTEIN                 
KEYWDS   2 STABILITY, HYPERTHERMOPHILE, ACHAEABACTERIA, X-RAY                   
KEYWDS   3 CRYSTALLOGRAPHY, ELECTROSTATICS, MOLECULAR MODELING, T-G             
KEYWDS   4 MISMATCH                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SU,Y.-G.GAO,H.ROBINSON,Y.-C.LIAW,S.P.EDMONDSON,                     
AUTHOR   2 J.W.SHRIVER,A.H.-J.WANG                                              
REVDAT   2   01-APR-03 1C8C    1       JRNL                                     
REVDAT   1   04-MAY-01 1C8C    0                                                
JRNL        AUTH   S.SU,Y.G.GAO,H.ROBINSON,Y.C.LIAW,S.P.EDMONDSON,              
JRNL        AUTH 2 J.W.SHRIVER,A.H.WANG                                         
JRNL        TITL   CRYSTAL STRUCTURES OF THE CHROMOSOMAL PROTEINS               
JRNL        TITL 2 SSO7D/SAC7D BOUND TO DNA CONTAINING T-G MISMATCHED           
JRNL        TITL 3 BASE-PAIRS.                                                  
JRNL        REF    J.MOL.BIOL.                   V. 303   395 2000              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  1C8C A    1    64  UNP    P39476   DN72_SULSO       1     64             
SEQRES   1 A   64  MET ALA THR VAL LYS PHE LYS TYR LYS GLY GLU GLU LYS          
SEQRES   2 A   64  GLN VAL ASP ILE SER LYS ILE LYS LYS VAL TRP ARG VAL          
SEQRES   3 A   64  GLY LYS MET ILE SER PHE THR TYR ASP GLU GLY GLY GLY          
SEQRES   4 A   64  LYS THR GLY ARG GLY ALA VAL SER GLU LYS ASP ALA PRO          
SEQRES   5 A   64  LYS GLU LEU LEU GLN MET LEU ALA LYS GLN LYS LYS              
SEQRES   1 B    8   DG  DT  DG  DA  DT  DC  DG  DC                              
SEQRES   1 C    8   DG  DT  DG  DA  DT  DC  DG  DC                              
FORMUL   4  HOH   *157(H2 O)                                                    
CRYST1   47.475   49.800   37.681  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   MET A   1     -11.275  40.664  27.708  1.00 22.87           N  
ATOM      2  CA  MET A   1     -10.518  41.801  28.227  1.00 41.08           C  
ATOM      3  C   MET A   1      -9.967  42.692  27.121  1.00 49.35           C  
ATOM      4  O   MET A   1     -10.214  43.904  27.137  1.00 63.95           O  
ATOM      5  CB  MET A   1      -9.730  42.636  29.355  1.00 48.29           C  
ATOM      6  CG  MET A   1     -10.244  42.481  30.788  1.00 52.90           C  
ATOM      7  SD  MET A   1     -10.285  40.523  32.451  1.00157.91           S  
ATOM      8  CE  MET A   1      -9.228  40.318  33.883  1.00 58.36           C  
ATOM      9  H1  MET A   1     -10.657  40.083  27.106  1.00  0.00           H  
ATOM     10  H2  MET A   1     -11.627  40.091  28.500  1.00  0.00           H  
ATOM     11  H3  MET A   1     -12.079  41.011  27.146  1.00  0.00           H  
ATOM     12  N   ALA A   2      -9.233  42.132  26.162  1.00 34.33           N  
ATOM     13  CA  ALA A   2      -8.880  42.834  24.926  1.00 20.66           C  
ATOM     14  C   ALA A   2     -10.071  42.838  23.971  1.00 28.91           C  
ATOM     15  O   ALA A   2     -11.078  42.157  24.231  1.00 26.37           O  
ATOM     16  CB  ALA A   2      -7.695  42.154  24.260  1.00 29.49           C  
ATOM     17  H   ALA A   2      -8.917  41.214  26.288  1.00  0.00           H  
ATOM     18  N   THR A   3      -9.972  43.564  22.857  1.00 16.28           N  
ATOM     19  CA  THR A   3     -11.097  43.600  21.929  1.00 13.12           C  
ATOM     20  C   THR A   3     -10.757  42.954  20.594  1.00 17.34           C  
ATOM     21  O   THR A   3      -9.611  42.719  20.203  1.00 19.53           O  
ATOM     22  CB  THR A   3     -11.540  45.051  21.669  1.00 21.73           C  
ATOM     23  OG1 THR A   3     -10.492  45.702  20.937  1.00 28.94           O  
ATOM     24  CG2 THR A   3     -11.720  45.840  22.952  1.00 14.52           C  
ATOM     25  H   THR A   3      -9.154  44.067  22.664  1.00  0.00           H  
ATOM     26  HG1 THR A   3      -9.684  45.687  21.454  1.00  0.00           H  
ATOM     27  N   VAL A   4     -11.818  42.631  19.855  1.00 17.88           N  
ATOM     28  CA  VAL A   4     -11.623  42.127  18.491  1.00 19.07           C  
ATOM     29  C   VAL A   4     -12.365  43.101  17.589  1.00 17.04           C  
ATOM     30  O   VAL A   4     -13.462  43.474  17.989  1.00 14.70           O  
ATOM     31  CB  VAL A   4     -12.153  40.694  18.286  1.00 15.69           C  
ATOM     32  CG1 VAL A   4     -13.606  40.590  18.708  1.00 21.54           C  
ATOM     33  CG2 VAL A   4     -12.015  40.267  16.843  1.00 21.60           C  
ATOM     34  H   VAL A   4     -12.722  42.730  20.220  1.00  0.00           H  
ATOM     35  N   LYS A   5     -11.822  43.510  16.459  1.00 18.42           N  
ATOM     36  CA  LYS A   5     -12.554  44.367  15.523  1.00 16.48           C  
ATOM     37  C   LYS A   5     -12.853  43.540  14.272  1.00 17.80           C  
ATOM     38  O   LYS A   5     -12.043  42.718  13.838  1.00 19.55           O  
ATOM     39  CB  LYS A   5     -11.781  45.614  15.131  1.00 22.37           C  
ATOM     40  CG  LYS A   5     -11.359  46.494  16.303  1.00 23.91           C  
ATOM     41  CD  LYS A   5     -10.422  47.617  15.850  1.00 22.00           C  
ATOM     42  CE  LYS A   5      -8.985  47.361  16.243  1.00 31.37           C  
ATOM     43  NZ  LYS A   5      -8.029  48.415  15.792  1.00 24.46           N  
ATOM     44  H   LYS A   5     -10.908  43.234  16.240  1.00  0.00           H  
ATOM     45  HZ1 LYS A   5      -8.053  48.485  14.755  1.00  0.00           H  
ATOM     46  HZ2 LYS A   5      -8.299  49.330  16.207  1.00  0.00           H  
ATOM     47  HZ3 LYS A   5      -7.067  48.166  16.100  1.00  0.00           H  
ATOM     48  N   PHE A   6     -14.045  43.772  13.713  1.00 16.19           N  
ATOM     49  CA  PHE A   6     -14.400  42.931  12.577  1.00 16.72           C  
ATOM     50  C   PHE A   6     -15.456  43.684  11.796  1.00 17.06           C  
ATOM     51  O   PHE A   6     -16.046  44.603  12.327  1.00 20.16           O  
ATOM     52  CB  PHE A   6     -14.872  41.575  13.060  1.00 20.24           C  
ATOM     53  CG  PHE A   6     -16.042  41.642  14.024  1.00 12.42           C  
ATOM     54  CD1 PHE A   6     -15.877  41.955  15.353  1.00 15.35           C  
ATOM     55  CD2 PHE A   6     -17.322  41.391  13.587  1.00 11.71           C  
ATOM     56  CE1 PHE A   6     -16.931  41.991  16.237  1.00 15.22           C  
ATOM     57  CE2 PHE A   6     -18.363  41.416  14.487  1.00 12.99           C  
ATOM     58  CZ  PHE A   6     -18.235  41.741  15.818  1.00 16.87           C  
ATOM     59  H   PHE A   6     -14.646  44.469  14.048  1.00  0.00           H  
ATOM     60  N   LYS A   7     -15.638  43.280  10.545  1.00 26.88           N  
ATOM     61  CA  LYS A   7     -16.633  44.044   9.775  1.00 30.46           C  
ATOM     62  C   LYS A   7     -17.801  43.105   9.554  1.00 34.22           C  
ATOM     63  O   LYS A   7     -17.540  41.995   9.076  1.00 37.25           O  
ATOM     64  CB  LYS A   7     -16.060  44.564   8.467  1.00 47.89           C  
ATOM     65  CG  LYS A   7     -16.361  43.730   7.232  1.00 58.04           C  
ATOM     66  CD  LYS A   7     -16.013  44.493   5.961  1.00 58.45           C  
ATOM     67  CE  LYS A   7     -16.580  45.908   6.000  1.00 54.63           C  
ATOM     68  NZ  LYS A   7     -17.411  46.174   4.796  1.00 50.89           N  
ATOM     69  H   LYS A   7     -15.144  42.526  10.161  1.00  0.00           H  
ATOM     70  HZ1 LYS A   7     -18.200  45.497   4.762  1.00  0.00           H  
ATOM     71  HZ2 LYS A   7     -17.787  47.143   4.841  1.00  0.00           H  
ATOM     72  HZ3 LYS A   7     -16.828  46.070   3.942  1.00  0.00           H  
ATOM     73  N   TYR A   8     -19.007  43.548   9.911  1.00 30.93           N  
ATOM     74  CA  TYR A   8     -20.104  42.580   9.710  1.00 38.05           C  
ATOM     75  C   TYR A   8     -21.344  43.255   9.134  1.00 37.93           C  
ATOM     76  O   TYR A   8     -21.727  44.330   9.603  1.00 47.33           O  
ATOM     77  CB  TYR A   8     -20.404  41.861  11.030  1.00 30.58           C  
ATOM     78  CG  TYR A   8     -21.211  40.598  10.834  1.00 29.62           C  
ATOM     79  CD1 TYR A   8     -20.609  39.367  10.611  1.00 34.75           C  
ATOM     80  CD2 TYR A   8     -22.602  40.644  10.867  1.00 38.73           C  
ATOM     81  CE1 TYR A   8     -21.362  38.215  10.428  1.00 29.72           C  
ATOM     82  CE2 TYR A   8     -23.367  39.506  10.690  1.00 36.51           C  
ATOM     83  CZ  TYR A   8     -22.737  38.294  10.470  1.00 33.00           C  
ATOM     84  OH  TYR A   8     -23.507  37.158  10.299  1.00 32.52           O  
ATOM     85  H   TYR A   8     -19.154  44.445  10.277  1.00  0.00           H  
ATOM     86  HH  TYR A   8     -22.934  36.401  10.156  1.00  0.00           H  
ATOM     87  N   LYS A   9     -21.957  42.636   8.145  1.00 38.46           N  
ATOM     88  CA  LYS A   9     -22.961  43.181   7.244  1.00 48.12           C  
ATOM     89  C   LYS A   9     -22.685  44.674   6.998  1.00 51.59           C  
ATOM     90  O   LYS A   9     -23.548  45.518   7.260  1.00 47.77           O  
ATOM     91  CB  LYS A   9     -24.404  42.994   7.692  1.00 44.94           C  
ATOM     92  CG  LYS A   9     -24.695  42.435   9.058  1.00 60.14           C  
ATOM     93  CD  LYS A   9     -24.466  43.439  10.172  1.00 71.25           C  
ATOM     94  CE  LYS A   9     -25.722  44.111  10.692  1.00 65.89           C  
ATOM     95  NZ  LYS A   9     -25.681  45.593  10.506  1.00 34.91           N  
ATOM     96  H   LYS A   9     -21.709  41.701   8.000  1.00  0.00           H  
ATOM     97  HZ1 LYS A   9     -25.590  45.813   9.493  1.00  0.00           H  
ATOM     98  HZ2 LYS A   9     -26.558  46.012  10.875  1.00  0.00           H  
ATOM     99  HZ3 LYS A   9     -24.867  45.984  11.020  1.00  0.00           H  
ATOM    100  N   GLY A  10     -21.484  44.975   6.507  1.00 55.45           N  
ATOM    101  CA  GLY A  10     -21.077  46.343   6.227  1.00 67.02           C  
ATOM    102  C   GLY A  10     -20.811  47.155   7.481  1.00 73.55           C  
ATOM    103  O   GLY A  10     -21.684  47.271   8.345  1.00 79.67           O  
ATOM    104  H   GLY A  10     -20.852  44.248   6.329  1.00  0.00           H  
ATOM    105  N   GLU A  11     -19.609  47.702   7.581  1.00 78.32           N  
ATOM    106  CA  GLU A  11     -19.116  48.448   8.721  1.00 84.32           C  
ATOM    107  C   GLU A  11     -18.577  47.545   9.844  1.00 70.80           C  
ATOM    108  O   GLU A  11     -18.944  46.397  10.122  1.00 33.86           O  
ATOM    109  CB  GLU A  11     -20.162  49.406   9.308  1.00 97.13           C  
ATOM    110  CG  GLU A  11     -19.580  50.647   9.961  1.00102.40           C  
ATOM    111  CD  GLU A  11     -20.551  51.796  10.129  1.00104.64           C  
ATOM    112  OE1 GLU A  11     -21.781  51.571  10.073  1.00101.94           O  
ATOM    113  OE2 GLU A  11     -20.081  52.943  10.321  1.00101.14           O  
ATOM    114  H   GLU A  11     -19.003  47.594   6.819  1.00  0.00           H  
ATOM    115  N   GLU A  12     -17.624  48.222  10.484  1.00 53.64           N  
ATOM    116  CA  GLU A  12     -16.762  47.698  11.516  1.00 58.44           C  
ATOM    117  C   GLU A  12     -17.435  47.674  12.885  1.00 45.17           C  
ATOM    118  O   GLU A  12     -18.144  48.574  13.312  1.00 40.39           O  
ATOM    119  CB  GLU A  12     -15.460  48.511  11.619  1.00 64.47           C  
ATOM    120  CG  GLU A  12     -14.218  47.707  11.264  1.00 63.34           C  
ATOM    121  CD  GLU A  12     -14.210  47.328   9.792  1.00 75.58           C  
ATOM    122  OE1 GLU A  12     -14.947  47.956   9.000  1.00 74.65           O  
ATOM    123  OE2 GLU A  12     -13.464  46.391   9.434  1.00103.23           O  
ATOM    124  H   GLU A  12     -17.497  49.160  10.231  1.00  0.00           H  
ATOM    125  N   LYS A  13     -17.158  46.580  13.581  1.00 23.77           N  
ATOM    126  CA  LYS A  13     -17.630  46.402  14.948  1.00 22.20           C  
ATOM    127  C   LYS A  13     -16.381  46.186  15.786  1.00 19.62           C  
ATOM    128  O   LYS A  13     -15.421  45.704  15.187  1.00 18.92           O  
ATOM    129  CB  LYS A  13     -18.579  45.204  14.998  1.00 24.85           C  
ATOM    130  CG  LYS A  13     -19.370  45.049  13.697  1.00 40.13           C  
ATOM    131  CD  LYS A  13     -20.787  44.570  13.911  1.00 54.28           C  
ATOM    132  CE  LYS A  13     -21.842  45.436  13.245  1.00 50.46           C  
ATOM    133  NZ  LYS A  13     -23.108  45.462  14.048  1.00 37.28           N  
ATOM    134  H   LYS A  13     -16.622  45.873  13.166  1.00  0.00           H  
ATOM    135  HZ1 LYS A  13     -23.481  44.495  14.139  1.00  0.00           H  
ATOM    136  HZ2 LYS A  13     -22.911  45.848  14.993  1.00  0.00           H  
ATOM    137  HZ3 LYS A  13     -23.810  46.061  13.568  1.00  0.00           H  
ATOM    138  N   GLN A  14     -16.425  46.547  17.055  1.00 22.74           N  
ATOM    139  CA  GLN A  14     -15.379  46.181  17.993  1.00 17.56           C  
ATOM    140  C   GLN A  14     -16.012  45.624  19.273  1.00 27.57           C  
ATOM    141  O   GLN A  14     -16.766  46.390  19.893  1.00 28.53           O  
ATOM    142  CB  GLN A  14     -14.518  47.385  18.343  1.00 15.11           C  
ATOM    143  CG  GLN A  14     -13.481  47.112  19.408  1.00 17.53           C  
ATOM    144  CD  GLN A  14     -12.434  48.211  19.441  1.00 20.68           C  
ATOM    145  OE1 GLN A  14     -12.684  49.286  18.858  1.00 35.81           O  
ATOM    146  NE2 GLN A  14     -11.358  47.988  20.022  1.00 22.55           N  
ATOM    147  H   GLN A  14     -17.185  47.078  17.373  1.00  0.00           H  
ATOM    148  N   VAL A  15     -15.704  44.394  19.629  1.00 21.64           N  
ATOM    149  CA  VAL A  15     -16.349  43.679  20.749  1.00 16.65           C  
ATOM    150  C   VAL A  15     -15.328  43.305  21.791  1.00 15.95           C  
ATOM    151  O   VAL A  15     -14.226  42.912  21.400  1.00 16.34           O  
ATOM    152  CB  VAL A  15     -17.010  42.401  20.186  1.00 23.49           C  
ATOM    153  CG1 VAL A  15     -17.430  41.429  21.275  1.00 34.18           C  
ATOM    154  CG2 VAL A  15     -18.227  42.743  19.323  1.00 31.08           C  
ATOM    155  H   VAL A  15     -15.008  43.927  19.123  1.00  0.00           H  
ATOM    156  N   ASP A  16     -15.664  43.433  23.087  1.00 15.58           N  
ATOM    157  CA  ASP A  16     -14.749  42.946  24.119  1.00 14.77           C  
ATOM    158  C   ASP A  16     -14.678  41.422  24.001  1.00 17.86           C  
ATOM    159  O   ASP A  16     -15.775  40.839  23.891  1.00 14.54           O  
ATOM    160  CB  ASP A  16     -15.215  43.367  25.516  1.00 15.54           C  
ATOM    161  CG  ASP A  16     -14.053  43.306  26.478  1.00 17.30           C  
ATOM    162  OD1 ASP A  16     -13.581  42.203  26.838  1.00 23.94           O  
ATOM    163  OD2 ASP A  16     -13.546  44.380  26.875  1.00 38.21           O  
ATOM    164  H   ASP A  16     -16.515  43.849  23.338  1.00  0.00           H  
ATOM    165  N   ILE A  17     -13.489  40.841  24.024  1.00 16.10           N  
ATOM    166  CA  ILE A  17     -13.337  39.385  23.853  1.00 17.41           C  
ATOM    167  C   ILE A  17     -13.960  38.661  25.044  1.00 15.73           C  
ATOM    168  O   ILE A  17     -14.347  37.495  24.953  1.00 18.41           O  
ATOM    169  CB  ILE A  17     -11.867  39.021  23.587  1.00 19.22           C  
ATOM    170  CG1 ILE A  17     -11.353  39.600  22.238  1.00 19.89           C  
ATOM    171  CG2 ILE A  17     -11.565  37.543  23.598  1.00 14.29           C  
ATOM    172  CD1 ILE A  17      -9.907  39.275  21.935  1.00 20.36           C  
ATOM    173  H   ILE A  17     -12.690  41.392  24.160  1.00  0.00           H  
ATOM    174  N   SER A  18     -14.150  39.311  26.177  1.00 14.56           N  
ATOM    175  CA  SER A  18     -14.974  38.713  27.231  1.00 22.08           C  
ATOM    176  C   SER A  18     -16.417  38.414  26.827  1.00 13.67           C  
ATOM    177  O   SER A  18     -17.048  37.546  27.446  1.00 16.17           O  
ATOM    178  CB  SER A  18     -14.994  39.653  28.451  1.00 20.97           C  
ATOM    179  OG  SER A  18     -15.827  40.773  28.183  1.00 23.74           O  
ATOM    180  H   SER A  18     -13.741  40.192  26.313  1.00  0.00           H  
ATOM    181  HG  SER A  18     -16.721  40.472  28.001  1.00  0.00           H  
ATOM    182  N   LYS A  19     -17.012  39.071  25.843  1.00 16.63           N  
ATOM    183  CA  LYS A  19     -18.355  38.761  25.370  1.00 12.16           C  
ATOM    184  C   LYS A  19     -18.394  37.580  24.405  1.00 15.93           C  
ATOM    185  O   LYS A  19     -19.513  37.157  24.108  1.00 13.93           O  
ATOM    186  CB  LYS A  19     -18.992  39.966  24.637  1.00 13.41           C  
ATOM    187  CG  LYS A  19     -19.054  41.222  25.490  1.00 13.19           C  
ATOM    188  CD  LYS A  19     -20.092  41.091  26.605  1.00 25.07           C  
ATOM    189  CE  LYS A  19     -20.010  42.206  27.633  1.00 24.17           C  
ATOM    190  NZ  LYS A  19     -20.692  41.831  28.903  1.00 23.94           N  
ATOM    191  H   LYS A  19     -16.524  39.803  25.411  1.00  0.00           H  
ATOM    192  HZ1 LYS A  19     -20.242  40.983  29.302  1.00  0.00           H  
ATOM    193  HZ2 LYS A  19     -20.617  42.615  29.582  1.00  0.00           H  
ATOM    194  HZ3 LYS A  19     -21.696  41.634  28.713  1.00  0.00           H  
ATOM    195  N   ILE A  20     -17.266  37.089  23.911  1.00 12.68           N  
ATOM    196  CA  ILE A  20     -17.294  36.025  22.911  1.00 12.23           C  
ATOM    197  C   ILE A  20     -17.850  34.748  23.490  1.00 10.44           C  
ATOM    198  O   ILE A  20     -17.419  34.321  24.560  1.00 13.01           O  
ATOM    199  CB  ILE A  20     -15.855  35.746  22.409  1.00 13.98           C  
ATOM    200  CG1 ILE A  20     -15.285  36.899  21.603  1.00 18.69           C  
ATOM    201  CG2 ILE A  20     -15.799  34.418  21.664  1.00 14.70           C  
ATOM    202  CD1 ILE A  20     -15.909  37.111  20.257  1.00 21.48           C  
ATOM    203  H   ILE A  20     -16.406  37.441  24.221  1.00  0.00           H  
ATOM    204  N   LYS A  21     -18.779  34.074  22.825  1.00 10.86           N  
ATOM    205  CA  LYS A  21     -19.441  32.919  23.447  1.00 16.60           C  
ATOM    206  C   LYS A  21     -18.833  31.600  22.957  1.00 17.93           C  
ATOM    207  O   LYS A  21     -18.557  30.697  23.762  1.00 14.60           O  
ATOM    208  CB  LYS A  21     -20.943  33.013  23.203  1.00 17.48           C  
ATOM    209  CG  LYS A  21     -21.813  31.830  23.600  1.00 11.17           C  
ATOM    210  CD  LYS A  21     -23.299  32.201  23.490  1.00 16.69           C  
ATOM    211  CE  LYS A  21     -24.149  31.099  24.128  1.00 33.87           C  
ATOM    212  NZ  LYS A  21     -25.564  31.058  23.640  1.00 26.40           N  
ATOM    213  H   LYS A  21     -19.024  34.347  21.916  1.00  0.00           H  
ATOM    214  HZ1 LYS A  21     -26.029  31.964  23.851  1.00  0.00           H  
ATOM    215  HZ2 LYS A  21     -25.572  30.895  22.613  1.00  0.00           H  
ATOM    216  HZ3 LYS A  21     -26.073  30.288  24.118  1.00  0.00           H  
ATOM    217  N   LYS A  22     -18.648  31.509  21.652  1.00 11.65           N  
ATOM    218  CA  LYS A  22     -18.164  30.348  20.946  1.00 16.48           C  
ATOM    219  C   LYS A  22     -17.220  30.798  19.838  1.00 18.35           C  
ATOM    220  O   LYS A  22     -17.474  31.820  19.207  1.00 13.34           O  
ATOM    221  CB  LYS A  22     -19.352  29.574  20.350  1.00 18.09           C  
ATOM    222  CG  LYS A  22     -19.006  28.154  19.923  1.00 22.07           C  
ATOM    223  CD  LYS A  22     -20.226  27.380  19.441  1.00 35.23           C  
ATOM    224  CE  LYS A  22     -19.914  25.883  19.464  1.00 47.07           C  
ATOM    225  NZ  LYS A  22     -21.139  25.041  19.431  1.00 38.65           N  
ATOM    226  H   LYS A  22     -18.859  32.301  21.116  1.00  0.00           H  
ATOM    227  HZ1 LYS A  22     -21.729  25.256  20.260  1.00  0.00           H  
ATOM    228  HZ2 LYS A  22     -21.674  25.240  18.563  1.00  0.00           H  
ATOM    229  HZ3 LYS A  22     -20.869  24.037  19.449  1.00  0.00           H  
ATOM    230  N   VAL A  23     -16.124  30.083  19.588  1.00 10.47           N  
ATOM    231  CA  VAL A  23     -15.284  30.415  18.438  1.00  7.91           C  
ATOM    232  C   VAL A  23     -14.924  29.114  17.761  1.00 13.11           C  
ATOM    233  O   VAL A  23     -14.833  28.058  18.394  1.00 13.17           O  
ATOM    234  CB  VAL A  23     -14.090  31.286  18.885  1.00 17.48           C  
ATOM    235  CG1 VAL A  23     -13.563  30.897  20.254  1.00 25.90           C  
ATOM    236  CG2 VAL A  23     -12.930  31.268  17.886  1.00 19.94           C  
ATOM    237  H   VAL A  23     -15.881  29.337  20.175  1.00  0.00           H  
ATOM    238  N   TRP A  24     -14.768  29.149  16.428  1.00 11.86           N  
ATOM    239  CA  TRP A  24     -14.421  27.952  15.683  1.00  9.36           C  
ATOM    240  C   TRP A  24     -13.568  28.374  14.489  1.00 12.80           C  
ATOM    241  O   TRP A  24     -13.552  29.570  14.155  1.00 12.99           O  
ATOM    242  CB  TRP A  24     -15.626  27.171  15.188  1.00  9.68           C  
ATOM    243  CG  TRP A  24     -16.625  27.852  14.309  1.00 11.45           C  
ATOM    244  CD1 TRP A  24     -16.651  27.755  12.934  1.00 13.03           C  
ATOM    245  CD2 TRP A  24     -17.724  28.700  14.673  1.00  7.30           C  
ATOM    246  NE1 TRP A  24     -17.704  28.501  12.435  1.00 12.60           N  
ATOM    247  CE2 TRP A  24     -18.367  29.083  13.488  1.00 14.85           C  
ATOM    248  CE3 TRP A  24     -18.195  29.151  15.906  1.00  8.66           C  
ATOM    249  CZ2 TRP A  24     -19.481  29.918  13.518  1.00 16.07           C  
ATOM    250  CZ3 TRP A  24     -19.301  29.979  15.942  1.00 11.45           C  
ATOM    251  CH2 TRP A  24     -19.927  30.349  14.745  1.00 14.90           C  
ATOM    252  H   TRP A  24     -14.891  29.997  15.951  1.00  0.00           H  
ATOM    253  HE1 TRP A  24     -17.937  28.597  11.493  1.00  0.00           H  
ATOM    254  N   ARG A  25     -12.864  27.418  13.902  1.00 11.56           N  
ATOM    255  CA  ARG A  25     -11.996  27.716  12.752  1.00 10.70           C  
ATOM    256  C   ARG A  25     -12.639  27.181  11.498  1.00 10.24           C  
ATOM    257  O   ARG A  25     -13.215  26.096  11.468  1.00 15.43           O  
ATOM    258  CB  ARG A  25     -10.593  27.128  12.975  1.00 13.96           C  
ATOM    259  CG  ARG A  25      -9.679  27.272  11.757  1.00 11.78           C  
ATOM    260  CD  ARG A  25      -8.287  26.715  11.977  1.00 14.72           C  
ATOM    261  NE  ARG A  25      -7.449  27.397  12.950  1.00 17.15           N  
ATOM    262  CZ  ARG A  25      -6.760  28.497  12.696  1.00 18.23           C  
ATOM    263  NH1 ARG A  25      -6.844  29.024  11.461  1.00 16.97           N  
ATOM    264  NH2 ARG A  25      -6.019  29.043  13.645  1.00 18.03           N  
ATOM    265  H   ARG A  25     -12.923  26.500  14.238  1.00  0.00           H  
ATOM    266  HE  ARG A  25      -7.392  27.017  13.851  1.00  0.00           H  
ATOM    267 HH11 ARG A  25      -7.415  28.585  10.768  1.00  0.00           H  
ATOM    268 HH12 ARG A  25      -6.335  29.856  11.237  1.00  0.00           H  
ATOM    269 HH21 ARG A  25      -5.981  28.625  14.553  1.00  0.00           H  
ATOM    270 HH22 ARG A  25      -5.497  29.875  13.455  1.00  0.00           H  
ATOM    271  N   VAL A  26     -12.599  27.975  10.432  1.00 12.04           N  
ATOM    272  CA  VAL A  26     -12.966  27.549   9.104  1.00  9.32           C  
ATOM    273  C   VAL A  26     -11.769  27.846   8.206  1.00 13.98           C  
ATOM    274  O   VAL A  26     -11.628  28.927   7.647  1.00 12.69           O  
ATOM    275  CB  VAL A  26     -14.208  28.248   8.551  1.00 11.92           C  
ATOM    276  CG1 VAL A  26     -14.723  27.415   7.378  1.00 10.42           C  
ATOM    277  CG2 VAL A  26     -15.291  28.403   9.604  1.00 13.35           C  
ATOM    278  H   VAL A  26     -12.305  28.901  10.556  1.00  0.00           H  
ATOM    279  N   GLY A  27     -10.838  26.900   8.097  1.00 11.75           N  
ATOM    280  CA  GLY A  27      -9.595  27.176   7.369  1.00 13.33           C  
ATOM    281  C   GLY A  27      -8.824  28.356   7.944  1.00 15.15           C  
ATOM    282  O   GLY A  27      -8.440  28.245   9.100  1.00 15.14           O  
ATOM    283  H   GLY A  27     -10.984  26.020   8.503  1.00  0.00           H  
ATOM    284  N   LYS A  28      -8.594  29.462   7.228  1.00 13.54           N  
ATOM    285  CA  LYS A  28      -7.893  30.622   7.776  1.00 13.39           C  
ATOM    286  C   LYS A  28      -8.836  31.612   8.440  1.00 13.00           C  
ATOM    287  O   LYS A  28      -8.403  32.634   8.965  1.00 13.11           O  
ATOM    288  CB  LYS A  28      -7.124  31.405   6.686  1.00 15.51           C  
ATOM    289  CG  LYS A  28      -6.114  30.517   5.933  1.00 16.12           C  
ATOM    290  CD  LYS A  28      -5.688  31.286   4.685  1.00 16.37           C  
ATOM    291  CE  LYS A  28      -4.697  30.511   3.848  1.00 19.14           C  
ATOM    292  NZ  LYS A  28      -3.463  30.089   4.507  1.00 17.73           N  
ATOM    293  H   LYS A  28      -8.907  29.495   6.300  1.00  0.00           H  
ATOM    294  HZ1 LYS A  28      -3.692  29.472   5.312  1.00  0.00           H  
ATOM    295  HZ2 LYS A  28      -2.869  29.569   3.829  1.00  0.00           H  
ATOM    296  HZ3 LYS A  28      -2.948  30.926   4.847  1.00  0.00           H  
ATOM    297  N   MET A  29     -10.147  31.317   8.408  1.00 13.33           N  
ATOM    298  CA  MET A  29     -11.126  32.183   9.054  1.00  9.15           C  
ATOM    299  C   MET A  29     -11.372  31.783  10.502  1.00 12.00           C  
ATOM    300  O   MET A  29     -11.565  30.597  10.828  1.00 14.04           O  
ATOM    301  CB  MET A  29     -12.440  32.133   8.268  1.00  9.86           C  
ATOM    302  CG  MET A  29     -13.562  33.018   8.846  1.00  8.54           C  
ATOM    303  SD  MET A  29     -14.960  33.130   7.697  1.00 14.74           S  
ATOM    304  CE  MET A  29     -15.682  31.504   8.045  1.00 17.48           C  
ATOM    305  H   MET A  29     -10.449  30.509   7.943  1.00  0.00           H  
ATOM    306  N   ILE A  30     -11.394  32.762  11.408  1.00 10.36           N  
ATOM    307  CA  ILE A  30     -11.791  32.557  12.800  1.00  8.74           C  
ATOM    308  C   ILE A  30     -13.178  33.158  12.986  1.00  9.20           C  
ATOM    309  O   ILE A  30     -13.380  34.352  12.948  1.00  9.53           O  
ATOM    310  CB  ILE A  30     -10.788  33.189  13.769  1.00  7.70           C  
ATOM    311  CG1 ILE A  30      -9.340  32.832  13.411  1.00 10.22           C  
ATOM    312  CG2 ILE A  30     -11.078  32.844  15.230  1.00  9.57           C  
ATOM    313  CD1 ILE A  30      -9.005  31.338  13.464  1.00 13.23           C  
ATOM    314  H   ILE A  30     -11.131  33.662  11.127  1.00  0.00           H  
ATOM    315  N   SER A  31     -14.182  32.304  13.159  1.00  8.95           N  
ATOM    316  CA  SER A  31     -15.589  32.635  13.259  1.00  7.41           C  
ATOM    317  C   SER A  31     -16.065  32.523  14.705  1.00  8.61           C  
ATOM    318  O   SER A  31     -15.573  31.661  15.449  1.00  8.55           O  
ATOM    319  CB  SER A  31     -16.309  31.627  12.367  1.00  8.95           C  
ATOM    320  OG  SER A  31     -17.562  32.054  11.950  1.00 11.04           O  
ATOM    321  H   SER A  31     -13.947  31.356  13.227  1.00  0.00           H  
ATOM    322  HG  SER A  31     -17.473  32.868  11.450  1.00  0.00           H  
ATOM    323  N   PHE A  32     -17.000  33.369  15.129  1.00 11.36           N  
ATOM    324  CA  PHE A  32     -17.452  33.354  16.520  1.00  8.25           C  
ATOM    325  C   PHE A  32     -18.850  33.909  16.653  1.00  9.64           C  
ATOM    326  O   PHE A  32     -19.421  34.514  15.736  1.00 12.97           O  
ATOM    327  CB  PHE A  32     -16.440  34.154  17.355  1.00 11.10           C  
ATOM    328  CG  PHE A  32     -16.101  35.543  16.801  1.00 11.70           C  
ATOM    329  CD1 PHE A  32     -16.917  36.621  17.098  1.00 11.33           C  
ATOM    330  CD2 PHE A  32     -14.995  35.745  16.004  1.00 12.29           C  
ATOM    331  CE1 PHE A  32     -16.621  37.874  16.605  1.00 10.44           C  
ATOM    332  CE2 PHE A  32     -14.676  37.010  15.512  1.00 12.19           C  
ATOM    333  CZ  PHE A  32     -15.501  38.076  15.819  1.00  9.13           C  
ATOM    334  H   PHE A  32     -17.392  34.012  14.501  1.00  0.00           H  
ATOM    335  N   THR A  33     -19.384  33.677  17.839  1.00 10.00           N  
ATOM    336  CA  THR A  33     -20.544  34.380  18.319  1.00 11.67           C  
ATOM    337  C   THR A  33     -20.197  35.137  19.598  1.00 11.81           C  
ATOM    338  O   THR A  33     -19.194  34.916  20.264  1.00 12.27           O  
ATOM    339  CB  THR A  33     -21.728  33.460  18.610  1.00 11.61           C  
ATOM    340  OG1 THR A  33     -21.301  32.451  19.560  1.00 13.07           O  
ATOM    341  CG2 THR A  33     -22.163  32.752  17.353  1.00 11.27           C  
ATOM    342  H   THR A  33     -18.974  32.999  18.416  1.00  0.00           H  
ATOM    343  HG1 THR A  33     -21.009  32.876  20.370  1.00  0.00           H  
ATOM    344  N   TYR A  34     -21.040  36.116  19.910  1.00 11.75           N  
ATOM    345  CA  TYR A  34     -20.766  36.964  21.061  1.00 14.55           C  
ATOM    346  C   TYR A  34     -22.099  37.426  21.650  1.00 18.54           C  
ATOM    347  O   TYR A  34     -23.103  37.532  20.947  1.00 13.85           O  
ATOM    348  CB  TYR A  34     -19.905  38.160  20.716  1.00 12.96           C  
ATOM    349  CG  TYR A  34     -20.429  39.164  19.711  1.00 12.72           C  
ATOM    350  CD1 TYR A  34     -20.232  38.913  18.356  1.00 11.94           C  
ATOM    351  CD2 TYR A  34     -21.085  40.328  20.132  1.00 18.67           C  
ATOM    352  CE1 TYR A  34     -20.704  39.837  17.427  1.00 13.61           C  
ATOM    353  CE2 TYR A  34     -21.560  41.249  19.194  1.00 11.49           C  
ATOM    354  CZ  TYR A  34     -21.350  40.972  17.867  1.00 14.94           C  
ATOM    355  OH  TYR A  34     -21.824  41.868  16.924  1.00 17.89           O  
ATOM    356  H   TYR A  34     -21.843  36.267  19.368  1.00  0.00           H  
ATOM    357  HH  TYR A  34     -21.608  41.552  16.044  1.00  0.00           H  
ATOM    358  N   ASP A  35     -22.079  37.694  22.950  1.00 13.71           N  
ATOM    359  CA  ASP A  35     -23.291  38.147  23.620  1.00  9.19           C  
ATOM    360  C   ASP A  35     -23.527  39.641  23.391  1.00 12.74           C  
ATOM    361  O   ASP A  35     -22.555  40.383  23.600  1.00 15.03           O  
ATOM    362  CB  ASP A  35     -23.086  37.888  25.119  1.00 12.21           C  
ATOM    363  CG  ASP A  35     -23.185  36.423  25.519  1.00 13.61           C  
ATOM    364  OD1 ASP A  35     -23.511  35.570  24.687  1.00 16.94           O  
ATOM    365  OD2 ASP A  35     -22.904  36.169  26.700  1.00 18.22           O  
ATOM    366  H   ASP A  35     -21.248  37.587  23.459  1.00  0.00           H  
ATOM    367  N   GLU A  36     -24.738  40.019  23.009  1.00 13.88           N  
ATOM    368  CA  GLU A  36     -25.150  41.419  22.944  1.00 21.97           C  
ATOM    369  C   GLU A  36     -26.296  41.721  23.927  1.00 22.86           C  
ATOM    370  O   GLU A  36     -26.743  40.853  24.664  1.00 22.78           O  
ATOM    371  CB  GLU A  36     -25.682  41.795  21.564  1.00 19.65           C  
ATOM    372  CG  GLU A  36     -24.770  41.352  20.427  1.00 19.92           C  
ATOM    373  CD  GLU A  36     -25.569  41.315  19.141  1.00 19.52           C  
ATOM    374  OE1 GLU A  36     -26.735  40.889  19.132  1.00 33.15           O  
ATOM    375  OE2 GLU A  36     -24.980  41.733  18.140  1.00 25.24           O  
ATOM    376  H   GLU A  36     -25.386  39.329  22.759  1.00  0.00           H  
ATOM    377  N   GLY A  37     -26.780  42.962  23.877  1.00 18.44           N  
ATOM    378  CA  GLY A  37     -27.885  43.383  24.715  1.00 19.37           C  
ATOM    379  C   GLY A  37     -29.146  42.630  24.375  1.00 21.86           C  
ATOM    380  O   GLY A  37     -29.191  42.019  23.297  1.00 19.20           O  
ATOM    381  H   GLY A  37     -26.378  43.606  23.257  1.00  0.00           H  
ATOM    382  N   GLY A  38     -30.157  42.675  25.242  1.00 20.51           N  
ATOM    383  CA  GLY A  38     -31.462  42.170  24.853  1.00 20.84           C  
ATOM    384  C   GLY A  38     -31.544  40.670  24.784  1.00 22.50           C  
ATOM    385  O   GLY A  38     -32.533  40.117  24.288  1.00 27.84           O  
ATOM    386  H   GLY A  38     -30.020  43.047  26.138  1.00  0.00           H  
ATOM    387  N   GLY A  39     -30.505  39.982  25.255  1.00 24.49           N  
ATOM    388  CA  GLY A  39     -30.543  38.521  25.194  1.00 27.31           C  
ATOM    389  C   GLY A  39     -30.169  37.976  23.825  1.00 22.97           C  
ATOM    390  O   GLY A  39     -30.348  36.799  23.544  1.00 24.08           O  
ATOM    391  H   GLY A  39     -29.729  40.446  25.634  1.00  0.00           H  
ATOM    392  N   LYS A  40     -29.634  38.812  22.948  1.00 16.95           N  
ATOM    393  CA  LYS A  40     -29.287  38.454  21.592  1.00 17.46           C  
ATOM    394  C   LYS A  40     -27.819  38.034  21.494  1.00 16.63           C  
ATOM    395  O   LYS A  40     -26.992  38.353  22.349  1.00 15.04           O  
ATOM    396  CB  LYS A  40     -29.520  39.635  20.644  1.00 25.60           C  
ATOM    397  CG  LYS A  40     -30.955  39.997  20.318  1.00 32.49           C  
ATOM    398  CD  LYS A  40     -31.122  41.504  20.175  1.00 50.73           C  
ATOM    399  CE  LYS A  40     -29.810  42.229  19.927  1.00 54.12           C  
ATOM    400  NZ  LYS A  40     -29.532  43.312  20.917  1.00 30.01           N  
ATOM    401  H   LYS A  40     -29.463  39.732  23.237  1.00  0.00           H  
ATOM    402  HZ1 LYS A  40     -30.292  44.021  20.877  1.00  0.00           H  
ATOM    403  HZ2 LYS A  40     -29.487  42.905  21.873  1.00  0.00           H  
ATOM    404  HZ3 LYS A  40     -28.623  43.764  20.690  1.00  0.00           H  
ATOM    405  N   THR A  41     -27.569  37.302  20.420  1.00 13.32           N  
ATOM    406  CA  THR A  41     -26.290  36.711  20.057  1.00 15.93           C  
ATOM    407  C   THR A  41     -25.861  37.272  18.701  1.00 14.73           C  
ATOM    408  O   THR A  41     -26.603  37.153  17.716  1.00 18.69           O  
ATOM    409  CB  THR A  41     -26.376  35.179  20.001  1.00 16.75           C  
ATOM    410  OG1 THR A  41     -26.619  34.670  21.339  1.00 16.79           O  
ATOM    411  CG2 THR A  41     -25.071  34.515  19.576  1.00 20.01           C  
ATOM    412  H   THR A  41     -28.317  37.143  19.810  1.00  0.00           H  
ATOM    413  HG1 THR A  41     -27.445  35.028  21.673  1.00  0.00           H  
ATOM    414  N   GLY A  42     -24.688  37.887  18.685  1.00 10.88           N  
ATOM    415  CA  GLY A  42     -24.088  38.354  17.451  1.00 13.80           C  
ATOM    416  C   GLY A  42     -23.117  37.391  16.828  1.00  9.76           C  
ATOM    417  O   GLY A  42     -22.605  36.490  17.510  1.00 14.98           O  
ATOM    418  H   GLY A  42     -24.213  38.031  19.530  1.00  0.00           H  
ATOM    419  N   ARG A  43     -22.847  37.564  15.545  1.00  9.02           N  
ATOM    420  CA  ARG A  43     -21.885  36.777  14.776  1.00 10.88           C  
ATOM    421  C   ARG A  43     -20.796  37.684  14.194  1.00 11.39           C  
ATOM    422  O   ARG A  43     -21.001  38.871  13.885  1.00 10.89           O  
ATOM    423  CB  ARG A  43     -22.582  36.000  13.652  1.00 11.64           C  
ATOM    424  CG  ARG A  43     -23.568  34.927  14.099  1.00  9.68           C  
ATOM    425  CD  ARG A  43     -24.496  34.558  12.914  1.00  8.80           C  
ATOM    426  NE  ARG A  43     -25.428  35.660  12.640  1.00 12.77           N  
ATOM    427  CZ  ARG A  43     -26.401  35.567  11.734  1.00 13.65           C  
ATOM    428  NH1 ARG A  43     -26.607  34.464  11.036  1.00 12.97           N  
ATOM    429  NH2 ARG A  43     -27.210  36.596  11.530  1.00 19.19           N  
ATOM    430  H   ARG A  43     -23.329  38.273  15.073  1.00  0.00           H  
ATOM    431  HE  ARG A  43     -25.331  36.495  13.142  1.00  0.00           H  
ATOM    432 HH11 ARG A  43     -26.024  33.665  11.180  1.00  0.00           H  
ATOM    433 HH12 ARG A  43     -27.347  34.428  10.364  1.00  0.00           H  
ATOM    434 HH21 ARG A  43     -27.089  37.439  12.055  1.00  0.00           H  
ATOM    435 HH22 ARG A  43     -27.941  36.531  10.851  1.00  0.00           H  
ATOM    436  N   GLY A  44     -19.595  37.125  14.066  1.00 10.76           N  
ATOM    437  CA  GLY A  44     -18.494  37.842  13.420  1.00 11.08           C  
ATOM    438  C   GLY A  44     -17.391  36.873  13.032  1.00  9.05           C  
ATOM    439  O   GLY A  44     -17.388  35.719  13.444  1.00 11.63           O  
ATOM    440  H   GLY A  44     -19.445  36.220  14.410  1.00  0.00           H  
ATOM    441  N   ALA A  45     -16.428  37.394  12.258  1.00  9.82           N  
ATOM    442  CA  ALA A  45     -15.334  36.539  11.848  1.00  7.83           C  
ATOM    443  C   ALA A  45     -14.152  37.450  11.475  1.00 12.69           C  
ATOM    444  O   ALA A  45     -14.415  38.588  11.034  1.00 12.80           O  
ATOM    445  CB  ALA A  45     -15.702  35.691  10.647  1.00 11.28           C  
ATOM    446  H   ALA A  45     -16.465  38.332  11.977  1.00  0.00           H  
ATOM    447  N   VAL A  46     -12.962  36.900  11.653  1.00  8.16           N  
ATOM    448  CA  VAL A  46     -11.746  37.610  11.294  1.00 13.79           C  
ATOM    449  C   VAL A  46     -10.764  36.645  10.625  1.00 15.47           C  
ATOM    450  O   VAL A  46     -10.869  35.438  10.789  1.00 12.80           O  
ATOM    451  CB  VAL A  46     -11.044  38.262  12.483  1.00 10.19           C  
ATOM    452  CG1 VAL A  46     -11.910  39.371  13.062  1.00 16.26           C  
ATOM    453  CG2 VAL A  46     -10.709  37.239  13.583  1.00 11.31           C  
ATOM    454  H   VAL A  46     -12.900  35.999  12.034  1.00  0.00           H  
ATOM    455  N   SER A  47      -9.810  37.196   9.880  1.00 11.43           N  
ATOM    456  CA  SER A  47      -8.684  36.445   9.380  1.00  9.89           C  
ATOM    457  C   SER A  47      -7.836  35.896  10.489  1.00 11.41           C  
ATOM    458  O   SER A  47      -7.719  36.627  11.495  1.00 14.40           O  
ATOM    459  CB  SER A  47      -7.783  37.422   8.577  1.00 10.66           C  
ATOM    460  OG  SER A  47      -6.624  36.652   8.279  1.00 20.97           O  
ATOM    461  H   SER A  47      -9.874  38.149   9.662  1.00  0.00           H  
ATOM    462  HG  SER A  47      -6.211  36.367   9.096  1.00  0.00           H  
ATOM    463  N   GLU A  48      -7.252  34.708  10.405  1.00 11.36           N  
ATOM    464  CA  GLU A  48      -6.347  34.326  11.490  1.00 11.46           C  
ATOM    465  C   GLU A  48      -5.138  35.237  11.612  1.00 24.80           C  
ATOM    466  O   GLU A  48      -4.587  35.332  12.707  1.00 20.31           O  
ATOM    467  CB  GLU A  48      -5.823  32.908  11.179  1.00 11.03           C  
ATOM    468  CG  GLU A  48      -5.056  32.856   9.862  1.00 15.87           C  
ATOM    469  CD  GLU A  48      -4.536  31.473   9.526  1.00 18.80           C  
ATOM    470  OE1 GLU A  48      -4.822  30.515  10.262  1.00 16.01           O  
ATOM    471  OE2 GLU A  48      -3.846  31.305   8.495  1.00 13.04           O  
ATOM    472  H   GLU A  48      -7.421  34.110   9.648  1.00  0.00           H  
ATOM    473  N   LYS A  49      -4.779  35.844  10.487  1.00 18.53           N  
ATOM    474  CA  LYS A  49      -3.512  36.522  10.280  1.00 26.85           C  
ATOM    475  C   LYS A  49      -3.200  37.410  11.455  1.00 26.90           C  
ATOM    476  O   LYS A  49      -2.189  37.258  12.139  1.00 51.73           O  
ATOM    477  CB  LYS A  49      -3.524  37.367   8.997  1.00 44.44           C  
ATOM    478  CG  LYS A  49      -2.710  36.841   7.830  1.00 47.50           C  
ATOM    479  CD  LYS A  49      -3.092  37.498   6.516  1.00 53.84           C  
ATOM    480  CE  LYS A  49      -3.051  36.541   5.333  1.00 55.75           C  
ATOM    481  NZ  LYS A  49      -4.189  35.569   5.346  1.00 35.68           N  
ATOM    482  H   LYS A  49      -5.415  35.833   9.743  1.00  0.00           H  
ATOM    483  HZ1 LYS A  49      -5.089  36.088   5.308  1.00  0.00           H  
ATOM    484  HZ2 LYS A  49      -4.116  34.939   4.522  1.00  0.00           H  
ATOM    485  HZ3 LYS A  49      -4.152  35.003   6.218  1.00  0.00           H  
ATOM    486  N   ASP A  50      -4.091  38.374  11.723  1.00 24.46           N  
ATOM    487  CA  ASP A  50      -3.707  39.136  12.930  1.00 32.92           C  
ATOM    488  C   ASP A  50      -4.732  39.046  14.045  1.00 47.61           C  
ATOM    489  O   ASP A  50      -4.928  39.998  14.815  1.00 36.30           O  
ATOM    490  CB  ASP A  50      -3.390  40.550  12.411  1.00 43.63           C  
ATOM    491  CG  ASP A  50      -2.138  40.524  11.539  1.00 37.28           C  
ATOM    492  OD1 ASP A  50      -1.057  40.178  12.068  1.00 50.33           O  
ATOM    493  OD2 ASP A  50      -2.226  40.820  10.333  1.00 52.71           O  
ATOM    494  H   ASP A  50      -4.890  38.550  11.190  1.00  0.00           H  
ATOM    495  N   ALA A  51      -5.408  37.902  14.206  1.00 42.20           N  
ATOM    496  CA  ALA A  51      -6.406  37.678  15.246  1.00 19.35           C  
ATOM    497  C   ALA A  51      -5.830  37.772  16.661  1.00 15.10           C  
ATOM    498  O   ALA A  51      -4.719  37.313  16.907  1.00 24.06           O  
ATOM    499  CB  ALA A  51      -7.050  36.310  15.094  1.00 35.40           C  
ATOM    500  H   ALA A  51      -5.221  37.168  13.585  1.00  0.00           H  
ATOM    501  N   PRO A  52      -6.557  38.314  17.632  1.00 23.39           N  
ATOM    502  CA  PRO A  52      -6.018  38.478  18.995  1.00 18.79           C  
ATOM    503  C   PRO A  52      -5.705  37.135  19.632  1.00 22.76           C  
ATOM    504  O   PRO A  52      -6.486  36.188  19.485  1.00 19.55           O  
ATOM    505  CB  PRO A  52      -7.145  39.172  19.757  1.00 21.38           C  
ATOM    506  CG  PRO A  52      -8.072  39.713  18.724  1.00 24.91           C  
ATOM    507  CD  PRO A  52      -7.939  38.807  17.527  1.00 31.59           C  
ATOM    508  N   LYS A  53      -4.563  37.064  20.316  1.00 21.43           N  
ATOM    509  CA  LYS A  53      -4.183  35.773  20.867  1.00 24.68           C  
ATOM    510  C   LYS A  53      -5.268  35.287  21.836  1.00 21.89           C  
ATOM    511  O   LYS A  53      -5.447  34.081  21.917  1.00 24.37           O  
ATOM    512  CB  LYS A  53      -2.836  35.802  21.587  1.00 30.99           C  
ATOM    513  CG  LYS A  53      -1.708  35.074  20.895  1.00 47.00           C  
ATOM    514  CD  LYS A  53      -0.508  34.800  21.790  1.00 53.31           C  
ATOM    515  CE  LYS A  53      -0.850  33.942  22.992  1.00 57.48           C  
ATOM    516  NZ  LYS A  53      -0.245  32.579  22.941  1.00 58.18           N  
ATOM    517  H   LYS A  53      -3.998  37.855  20.444  1.00  0.00           H  
ATOM    518  HZ1 LYS A  53       0.791  32.659  22.901  1.00  0.00           H  
ATOM    519  HZ2 LYS A  53      -0.519  32.046  23.791  1.00  0.00           H  
ATOM    520  HZ3 LYS A  53      -0.587  32.079  22.095  1.00  0.00           H  
ATOM    521  N   GLU A  54      -5.930  36.204  22.526  1.00 21.32           N  
ATOM    522  CA  GLU A  54      -6.936  35.839  23.528  1.00 29.96           C  
ATOM    523  C   GLU A  54      -8.037  35.004  22.885  1.00 22.16           C  
ATOM    524  O   GLU A  54      -8.606  34.082  23.454  1.00 23.46           O  
ATOM    525  CB  GLU A  54      -7.532  37.084  24.186  1.00 25.82           C  
ATOM    526  CG  GLU A  54      -8.619  36.835  25.210  1.00 36.57           C  
ATOM    527  CD  GLU A  54      -9.151  38.061  25.926  1.00 42.54           C  
ATOM    528  OE1 GLU A  54      -8.682  39.197  25.695  1.00 21.12           O  
ATOM    529  OE2 GLU A  54     -10.076  37.926  26.766  1.00 26.21           O  
ATOM    530  H   GLU A  54      -5.742  37.151  22.362  1.00  0.00           H  
ATOM    531  N   LEU A  55      -8.329  35.398  21.648  1.00 16.28           N  
ATOM    532  CA  LEU A  55      -9.385  34.720  20.885  1.00 15.14           C  
ATOM    533  C   LEU A  55      -8.924  33.371  20.350  1.00 14.43           C  
ATOM    534  O   LEU A  55      -9.676  32.382  20.400  1.00 13.77           O  
ATOM    535  CB  LEU A  55      -9.839  35.646  19.752  1.00 16.28           C  
ATOM    536  CG  LEU A  55     -10.920  35.121  18.801  1.00 16.94           C  
ATOM    537  CD1 LEU A  55     -12.239  34.902  19.528  1.00 17.25           C  
ATOM    538  CD2 LEU A  55     -11.088  36.093  17.643  1.00 12.98           C  
ATOM    539  H   LEU A  55      -7.837  36.143  21.244  1.00  0.00           H  
ATOM    540  N   LEU A  56      -7.694  33.322  19.816  1.00 15.89           N  
ATOM    541  CA  LEU A  56      -7.130  32.085  19.315  1.00 18.35           C  
ATOM    542  C   LEU A  56      -6.979  31.050  20.416  1.00 26.36           C  
ATOM    543  O   LEU A  56      -7.247  29.873  20.181  1.00 23.47           O  
ATOM    544  CB  LEU A  56      -5.737  32.284  18.695  1.00 17.95           C  
ATOM    545  CG  LEU A  56      -5.791  33.065  17.375  1.00 21.93           C  
ATOM    546  CD1 LEU A  56      -4.402  33.202  16.796  1.00 20.53           C  
ATOM    547  CD2 LEU A  56      -6.715  32.371  16.373  1.00 20.00           C  
ATOM    548  H   LEU A  56      -7.163  34.144  19.765  1.00  0.00           H  
ATOM    549  N   GLN A  57      -6.558  31.488  21.604  1.00 27.83           N  
ATOM    550  CA  GLN A  57      -6.460  30.468  22.661  1.00 21.88           C  
ATOM    551  C   GLN A  57      -7.829  29.977  23.086  1.00 22.68           C  
ATOM    552  O   GLN A  57      -7.988  28.829  23.533  1.00 31.94           O  
ATOM    553  CB  GLN A  57      -5.641  30.993  23.840  1.00 31.72           C  
ATOM    554  CG  GLN A  57      -6.172  32.150  24.632  1.00 38.65           C  
ATOM    555  CD  GLN A  57      -5.154  32.830  25.533  1.00 51.90           C  
ATOM    556  OE1 GLN A  57      -3.933  32.763  25.360  1.00 53.96           O  
ATOM    557  NE2 GLN A  57      -5.688  33.536  26.531  1.00 25.74           N  
ATOM    558  H   GLN A  57      -6.330  32.428  21.763  1.00  0.00           H  
ATOM    559 HE21 GLN A  57      -5.074  33.994  27.140  1.00  0.00           H  
ATOM    560 HE22 GLN A  57      -6.662  33.582  26.632  1.00  0.00           H  
ATOM    561  N   MET A  58      -8.869  30.796  22.966  1.00 22.52           N  
ATOM    562  CA  MET A  58     -10.207  30.294  23.348  1.00 21.88           C  
ATOM    563  C   MET A  58     -10.560  29.115  22.469  1.00 25.99           C  
ATOM    564  O   MET A  58     -11.101  28.087  22.869  1.00 32.17           O  
ATOM    565  CB  MET A  58     -11.223  31.426  23.242  1.00 26.90           C  
ATOM    566  CG  MET A  58     -12.385  31.394  24.214  1.00 36.21           C  
ATOM    567  SD  MET A  58     -13.369  32.902  24.074  1.00 46.22           S  
ATOM    568  CE  MET A  58     -12.210  34.153  24.623  1.00 18.09           C  
ATOM    569  H   MET A  58      -8.752  31.710  22.633  1.00  0.00           H  
ATOM    570  N   LEU A  59     -10.222  29.265  21.201  1.00 31.60           N  
ATOM    571  CA  LEU A  59     -10.406  28.269  20.163  1.00 33.40           C  
ATOM    572  C   LEU A  59      -9.796  26.934  20.567  1.00 37.80           C  
ATOM    573  O   LEU A  59     -10.448  25.888  20.495  1.00 28.71           O  
ATOM    574  CB  LEU A  59      -9.756  28.819  18.891  1.00 30.53           C  
ATOM    575  CG  LEU A  59      -9.874  27.993  17.624  1.00 27.13           C  
ATOM    576  CD1 LEU A  59     -11.295  28.011  17.102  1.00 21.52           C  
ATOM    577  CD2 LEU A  59      -8.902  28.506  16.566  1.00 32.06           C  
ATOM    578  H   LEU A  59      -9.815  30.117  20.941  1.00  0.00           H  
ATOM    579  N   ALA A  60      -8.537  26.997  20.998  1.00 33.94           N  
ATOM    580  CA  ALA A  60      -7.777  25.816  21.374  1.00 30.10           C  
ATOM    581  C   ALA A  60      -8.253  25.192  22.671  1.00 31.79           C  
ATOM    582  O   ALA A  60      -7.963  24.035  22.962  1.00 55.63           O  
ATOM    583  CB  ALA A  60      -6.290  26.183  21.494  1.00 27.07           C  
ATOM    584  H   ALA A  60      -8.106  27.874  21.064  1.00  0.00           H  
ATOM    585  N   LYS A  61      -8.997  25.935  23.485  1.00 39.78           N  
ATOM    586  CA  LYS A  61      -9.517  25.421  24.738  1.00 40.70           C  
ATOM    587  C   LYS A  61     -11.005  25.111  24.749  1.00 49.16           C  
ATOM    588  O   LYS A  61     -11.550  24.946  25.854  1.00 67.05           O  
ATOM    589  CB  LYS A  61      -9.288  26.430  25.871  1.00 41.55           C  
ATOM    590  CG  LYS A  61      -7.882  26.992  25.959  1.00 49.88           C  
ATOM    591  CD  LYS A  61      -7.815  28.026  27.082  1.00 38.51           C  
ATOM    592  CE  LYS A  61      -8.372  27.404  28.362  1.00 30.21           C  
ATOM    593  NZ  LYS A  61      -9.097  28.420  29.166  1.00 63.48           N  
ATOM    594  H   LYS A  61      -9.201  26.859  23.231  1.00  0.00           H  
ATOM    595  HZ1 LYS A  61      -9.886  28.806  28.609  1.00  0.00           H  
ATOM    596  HZ2 LYS A  61      -9.467  27.978  30.031  1.00  0.00           H  
ATOM    597  HZ3 LYS A  61      -8.445  29.189  29.423  1.00  0.00           H  
ATOM    598  N   GLN A  62     -11.735  25.019  23.638  1.00 49.20           N  
ATOM    599  CA  GLN A  62     -13.152  24.667  23.822  1.00 58.42           C  
ATOM    600  C   GLN A  62     -13.571  23.457  22.995  1.00 66.28           C  
ATOM    601  O   GLN A  62     -13.352  23.411  21.785  1.00 73.71           O  
ATOM    602  CB  GLN A  62     -14.062  25.844  23.490  1.00 62.91           C  
ATOM    603  CG  GLN A  62     -14.179  26.210  22.017  1.00 56.35           C  
ATOM    604  CD  GLN A  62     -14.563  27.684  21.919  1.00 51.62           C  
ATOM    605  OE1 GLN A  62     -15.723  28.020  21.707  1.00 30.36           O  
ATOM    606  NE2 GLN A  62     -13.562  28.534  22.099  1.00 48.12           N  
ATOM    607  H   GLN A  62     -11.351  25.176  22.751  1.00  0.00           H  
ATOM    608 HE21 GLN A  62     -13.765  29.490  22.045  1.00  0.00           H  
ATOM    609 HE22 GLN A  62     -12.660  28.197  22.279  1.00  0.00           H  
ATOM    610  N   LYS A  63     -14.185  22.486  23.670  1.00 69.62           N  
ATOM    611  CA  LYS A  63     -14.630  21.794  24.432  1.00 69.68           C  
ATOM    612  C   LYS A  63     -16.339  21.081  21.179  1.00 91.28           C  
ATOM    613  O   LYS A  63     -16.934  22.165  21.864  1.00101.65           O  
ATOM    614  CB  LYS A  63     -16.306  24.204  25.936  1.00 31.04           C  
ATOM    615  CG  LYS A  63     -17.170  19.723  24.067  1.00 55.39           C  
ATOM    616  CD  LYS A  63     -19.864  22.008  23.364  1.00 48.32           C  
ATOM    617  CE  LYS A  63     -21.508  18.730  23.297  1.00140.56           C  
ATOM    618  NZ  LYS A  63     -18.417  17.083  24.736  1.00 47.57           N  
ATOM    619  H   LYS A  63     -14.452  22.022  22.951  1.00  0.00           H  
ATOM    620  HZ1 LYS A  63     -18.202  17.498  25.664  1.00  0.00           H  
ATOM    621  HZ2 LYS A  63     -18.585  16.062  24.843  1.00  0.00           H  
ATOM    622  HZ3 LYS A  63     -17.612  17.234  24.094  1.00  0.00           H  
ATOM    623  N   LYS A  64     -15.313  20.615  21.888  1.00 81.05           N  
ATOM    624  CA  LYS A  64     -18.606  21.836  19.161  1.00 61.79           C  
ATOM    625  C   LYS A  64     -17.236  19.461  17.325  1.00138.86           C  
ATOM    626  O   LYS A  64     -18.348  19.764  16.851  1.00138.99           O  
ATOM    627  CB  LYS A  64     -14.776  21.659  17.368  1.00 35.26           C  
ATOM    628  CG  LYS A  64     -14.499  24.858  18.155  1.00 29.49           C  
ATOM    629  CD  LYS A  64     -15.907  25.189  19.070  1.00 42.84           C  
ATOM    630  CE  LYS A  64     -11.697  20.265  14.156  1.00 48.10           C  
ATOM    631  NZ  LYS A  64      -8.653  22.514  19.890  1.00 51.70           N  
ATOM    632  OXT LYS A  64     -17.013  19.236  18.530  1.00138.51           O  
ATOM    633  H   LYS A  64     -14.906  20.447  22.197  1.00  0.00           H  
ATOM    634  HZ1 LYS A  64      -9.201  22.205  20.718  1.00  0.00           H  
ATOM    635  HZ2 LYS A  64      -7.690  22.126  19.946  1.00  0.00           H  
ATOM    636  HZ3 LYS A  64      -8.608  23.553  19.874  1.00  0.00           H  
TER     637      LYS A  64                                                      
END
MOLECULE T0415.pdb
ATOM      1  N   GLY     1      -3.414  46.102  27.734  1.00 47.41           N  
ATOM      2  CA  GLY     1      -3.122  45.539  26.359  1.00 47.11           C  
ATOM      3  C   GLY     1      -4.177  45.907  25.333  1.00 47.07           C  
ATOM      4  O   GLY     1      -4.078  46.946  24.671  1.00 46.94           O  
ATOM      5  N   LYS     2      -5.171  45.030  25.198  1.00 46.92           N  
ATOM      6  CA  LYS     2      -6.274  45.185  24.253  1.00 46.81           C  
ATOM      7  C   LYS     2      -7.559  44.609  24.888  1.00 46.36           C  
ATOM      8  O   LYS     2      -7.467  43.735  25.759  1.00 45.55           O  
ATOM      9  CB  LYS     2      -5.938  44.505  22.904  1.00 47.31           C  
ATOM     10  CG  LYS     2      -5.486  45.508  21.817  1.00 47.91           C  
ATOM     11  CD  LYS     2      -4.343  45.056  20.919  1.00 47.60           C  
ATOM     12  CE  LYS     2      -4.032  46.152  19.891  1.00 47.58           C  
ATOM     13  NZ  LYS     2      -2.842  45.845  19.044  1.00 48.43           N  
ATOM     14  N   SER     3      -8.737  45.114  24.499  1.00 45.40           N  
ATOM     15  CA  SER     3      -9.967  44.730  25.214  1.00 45.73           C  
ATOM     16  C   SER     3     -11.200  44.568  24.362  1.00 44.97           C  
ATOM     17  O   SER     3     -12.250  44.270  24.886  1.00 43.15           O  
ATOM     18  CB  SER     3     -10.264  45.688  26.408  1.00 45.39           C  
ATOM     19  OG  SER     3     -10.858  46.926  26.031  1.00 44.69           O  
ATOM     20  N   VAL     4     -11.058  44.781  23.063  1.00 46.52           N  
ATOM     21  CA  VAL     4     -12.119  44.569  22.084  1.00 47.84           C  
ATOM     22  C   VAL     4     -11.586  43.824  20.877  1.00 49.90           C  
ATOM     23  O   VAL     4     -10.415  43.942  20.536  1.00 49.02           O  
ATOM     24  CB  VAL     4     -12.814  45.903  21.614  1.00 48.00           C  
ATOM     25  CG1 VAL     4     -13.403  46.612  22.796  1.00 48.15           C  
ATOM     26  CG2 VAL     4     -11.862  46.801  20.873  1.00 46.59           C  
ATOM     27  N   VAL     5     -12.464  43.017  20.284  1.00 52.98           N  
ATOM     28  CA  VAL     5     -12.249  42.400  18.975  1.00 55.45           C  
ATOM     29  C   VAL     5     -13.255  43.030  17.995  1.00 56.86           C  
ATOM     30  O   VAL     5     -14.440  43.149  18.318  1.00 57.09           O  
ATOM     31  CB  VAL     5     -12.496  40.880  18.971  1.00 54.97           C  
ATOM     32  CG1 VAL     5     -11.696  40.218  17.810  1.00 54.63           C  
ATOM     33  CG2 VAL     5     -12.138  40.263  20.301  1.00 54.64           C  
ATOM     34  N   THR     6     -12.765  43.452  16.823  1.00 58.87           N  
ATOM     35  CA  THR     6     -13.605  44.066  15.788  1.00 59.55           C  
ATOM     36  C   THR     6     -14.006  42.974  14.818  1.00 61.76           C  
ATOM     37  O   THR     6     -13.162  42.393  14.144  1.00 61.58           O  
ATOM     38  CB  THR     6     -12.932  45.268  15.121  1.00 59.79           C  
ATOM     39  OG1 THR     6     -12.480  46.179  16.145  1.00 59.48           O  
ATOM     40  CG2 THR     6     -13.915  46.013  14.231  1.00 58.55           C  
ATOM     41  N   LEU     7     -15.294  42.628  14.861  1.00 63.99           N  
ATOM     42  CA  LEU     7     -15.895  41.687  13.919  1.00 65.67           C  
ATOM     43  C   LEU     7     -16.368  42.441  12.667  1.00 66.61           C  
ATOM     44  O   LEU     7     -16.939  43.524  12.751  1.00 67.07           O  
ATOM     45  CB  LEU     7     -17.108  40.974  14.523  1.00 64.90           C  
ATOM     46  CG  LEU     7     -17.177  40.443  15.946  1.00 64.47           C  
ATOM     47  CD1 LEU     7     -18.054  39.221  16.010  1.00 62.44           C  
ATOM     48  CD2 LEU     7     -15.819  40.134  16.496  1.00 65.25           C  
ATOM     49  N   LYS     8     -16.166  41.836  11.506  1.00 68.76           N  
ATOM     50  CA  LYS     8     -16.680  42.380  10.243  1.00 69.47           C  
ATOM     51  C   LYS     8     -18.103  41.907  10.060  1.00 70.09           C  
ATOM     52  O   LYS     8     -18.347  40.694  10.082  1.00 69.59           O  
ATOM     53  CB  LYS     8     -15.813  41.896   9.086  1.00 69.96           C  
ATOM     54  CG  LYS     8     -16.349  42.153   7.703  1.00 70.04           C  
ATOM     55  CD  LYS     8     -15.243  42.025   6.686  1.00 70.59           C  
ATOM     56  CE  LYS     8     -15.612  42.751   5.399  1.00 72.06           C  
ATOM     57  NZ  LYS     8     -14.397  42.961   4.582  1.00 72.38           N  
ATOM     58  N   THR     9     -19.034  42.866   9.948  1.00 71.30           N  
ATOM     59  CA  THR     9     -20.416  42.587   9.508  1.00 72.31           C  
ATOM     60  C   THR     9     -20.616  42.985   8.048  1.00 72.69           C  
ATOM     61  O   THR     9     -19.697  43.484   7.396  1.00 72.53           O  
ATOM     62  CB  THR     9     -21.478  43.286  10.354  1.00 72.49           C  
ATOM     63  OG1 THR     9     -20.896  44.420  10.993  1.00 74.69           O  
ATOM     64  CG2 THR     9     -22.039  42.319  11.430  1.00 74.62           C  
ATOM     65  N   THR    10     -21.825  42.727   7.546  1.00 73.43           N  
ATOM     66  CA  THR    10     -22.161  42.914   6.126  1.00 73.47           C  
ATOM     67  C   THR    10     -21.839  44.354   5.638  1.00 73.38           C  
ATOM     68  O   THR    10     -21.174  44.550   4.599  1.00 72.70           O  
ATOM     69  CB  THR    10     -23.656  42.495   5.849  1.00 73.49           C  
ATOM     70  OG1 THR    10     -24.506  43.007   6.881  1.00 74.37           O  
ATOM     71  CG2 THR    10     -23.794  40.981   5.833  1.00 73.19           C  
ATOM     72  N   ASP    11     -22.248  45.341   6.434  1.00 73.21           N  
ATOM     73  CA  ASP    11     -22.094  46.754   6.059  1.00 73.27           C  
ATOM     74  C   ASP    11     -20.968  47.486   6.829  1.00 73.41           C  
ATOM     75  O   ASP    11     -20.279  48.348   6.242  1.00 73.86           O  
ATOM     76  CB  ASP    11     -23.437  47.492   6.208  1.00 73.82           C  
ATOM     77  CG  ASP    11     -24.153  47.149   7.512  1.00 74.89           C  
ATOM     78  OD1 ASP    11     -23.756  46.136   8.160  1.00 74.50           O  
ATOM     79  OD2 ASP    11     -25.105  47.888   7.872  1.00 74.98           O  
ATOM     80  N   GLY    12     -20.777  47.148   8.118  1.00 72.48           N  
ATOM     81  CA  GLY    12     -19.792  47.843   8.984  1.00 71.07           C  
ATOM     82  C   GLY    12     -19.007  46.880   9.851  1.00 70.00           C  
ATOM     83  O   GLY    12     -19.016  45.682   9.595  1.00 71.63           O  
ATOM     84  N   TRP    13     -18.304  47.400  10.853  1.00 68.05           N  
ATOM     85  CA  TRP    13     -17.557  46.562  11.841  1.00 66.68           C  
ATOM     86  C   TRP    13     -18.007  46.884  13.261  1.00 65.08           C  
ATOM     87  O   TRP    13     -18.280  48.050  13.606  1.00 64.47           O  
ATOM     88  CB  TRP    13     -16.060  46.842  11.792  1.00 64.59           C  
ATOM     89  CG  TRP    13     -15.332  46.422  10.588  1.00 62.93           C  
ATOM     90  CD1 TRP    13     -14.752  45.202  10.360  1.00 61.34           C  
ATOM     91  CD2 TRP    13     -15.018  47.240   9.461  1.00 61.52           C  
ATOM     92  NE1 TRP    13     -14.121  45.208   9.157  1.00 61.73           N  
ATOM     93  CE2 TRP    13     -14.268  46.448   8.578  1.00 62.18           C  
ATOM     94  CE3 TRP    13     -15.303  48.566   9.113  1.00 61.31           C  
ATOM     95  CZ2 TRP    13     -13.808  46.933   7.358  1.00 62.15           C  
ATOM     96  CZ3 TRP    13     -14.863  49.041   7.917  1.00 61.84           C  
ATOM     97  CH2 TRP    13     -14.116  48.232   7.046  1.00 62.33           C  
ATOM     98  N   ILE    14     -18.024  45.862  14.098  1.00 63.48           N  
ATOM     99  CA  ILE    14     -18.594  45.986  15.416  1.00 62.69           C  
ATOM    100  C   ILE    14     -17.526  45.612  16.442  1.00 62.71           C  
ATOM    101  O   ILE    14     -17.085  44.463  16.481  1.00 62.94           O  
ATOM    102  CB  ILE    14     -19.900  45.154  15.502  1.00 63.10           C  
ATOM    103  CG1 ILE    14     -20.867  45.664  14.398  1.00 62.59           C  
ATOM    104  CG2 ILE    14     -20.506  45.213  16.915  1.00 62.39           C  
ATOM    105  CD1 ILE    14     -22.294  45.381  14.613  1.00 62.33           C  
ATOM    106  N   PRO    15     -17.055  46.604  17.238  1.00 62.46           N  
ATOM    107  CA  PRO    15     -16.190  46.303  18.381  1.00 62.34           C  
ATOM    108  C   PRO    15     -16.956  45.561  19.472  1.00 62.33           C  
ATOM    109  O   PRO    15     -18.029  45.984  19.877  1.00 62.62           O  
ATOM    110  CB  PRO    15     -15.729  47.690  18.879  1.00 62.35           C  
ATOM    111  CG  PRO    15     -16.194  48.684  17.878  1.00 61.95           C  
ATOM    112  CD  PRO    15     -17.283  48.056  17.089  1.00 62.29           C  
ATOM    113  N   VAL    16     -16.411  44.424  19.895  1.00 62.70           N  
ATOM    114  CA  VAL    16     -17.012  43.575  20.936  1.00 62.00           C  
ATOM    115  C   VAL    16     -15.947  43.416  22.050  1.00 61.36           C  
ATOM    116  O   VAL    16     -14.801  43.160  21.741  1.00 62.57           O  
ATOM    117  CB  VAL    16     -17.408  42.199  20.316  1.00 62.01           C  
ATOM    118  CG1 VAL    16     -18.064  41.280  21.347  1.00 61.62           C  
ATOM    119  CG2 VAL    16     -18.307  42.408  19.135  1.00 61.84           C  
ATOM    120  N   PRO    17     -16.306  43.598  23.322  1.00 60.41           N  
ATOM    121  CA  PRO    17     -15.359  43.341  24.392  1.00 60.25           C  
ATOM    122  C   PRO    17     -14.991  41.878  24.466  1.00 59.48           C  
ATOM    123  O   PRO    17     -15.821  41.028  24.158  1.00 60.87           O  
ATOM    124  CB  PRO    17     -16.132  43.701  25.679  1.00 59.73           C  
ATOM    125  CG  PRO    17     -17.373  44.271  25.285  1.00 60.45           C  
ATOM    126  CD  PRO    17     -17.621  44.018  23.839  1.00 61.22           C  
ATOM    127  N   PHE    18     -13.779  41.575  24.878  1.00 59.09           N  
ATOM    128  CA  PHE    18     -13.352  40.180  25.028  1.00 60.00           C  
ATOM    129  C   PHE    18     -14.331  39.371  25.874  1.00 59.66           C  
ATOM    130  O   PHE    18     -14.580  38.201  25.601  1.00 59.27           O  
ATOM    131  CB  PHE    18     -11.943  40.079  25.641  1.00 60.36           C  
ATOM    132  CG  PHE    18     -10.829  40.515  24.716  1.00 61.73           C  
ATOM    133  CD1 PHE    18     -11.007  40.611  23.331  1.00 63.29           C  
ATOM    134  CD2 PHE    18      -9.586  40.789  25.229  1.00 63.45           C  
ATOM    135  CE1 PHE    18      -9.972  41.008  22.489  1.00 61.73           C  
ATOM    136  CE2 PHE    18      -8.538  41.181  24.390  1.00 63.81           C  
ATOM    137  CZ  PHE    18      -8.749  41.298  23.018  1.00 63.81           C  
ATOM    138  N   SER    19     -14.896  40.028  26.881  1.00 59.39           N  
ATOM    139  CA  SER    19     -15.812  39.400  27.822  1.00 59.03           C  
ATOM    140  C   SER    19     -17.096  38.837  27.165  1.00 58.26           C  
ATOM    141  O   SER    19     -17.719  37.937  27.703  1.00 59.05           O  
ATOM    142  CB  SER    19     -16.149  40.424  28.932  1.00 58.56           C  
ATOM    143  OG  SER    19     -17.118  41.375  28.499  1.00 60.75           O  
ATOM    144  N   LYS    20     -17.461  39.376  26.003  1.00 57.56           N  
ATOM    145  CA  LYS    20     -18.622  38.984  25.271  1.00 56.87           C  
ATOM    146  C   LYS    20     -18.322  37.990  24.151  1.00 55.79           C  
ATOM    147  O   LYS    20     -19.242  37.475  23.489  1.00 55.89           O  
ATOM    148  CB  LYS    20     -19.297  40.226  24.683  1.00 58.50           C  
ATOM    149  CG  LYS    20     -19.656  41.281  25.714  1.00 61.62           C  
ATOM    150  CD  LYS    20     -21.134  41.349  26.026  1.00 67.10           C  
ATOM    151  CE  LYS    20     -21.841  42.519  25.253  1.00 72.31           C  
ATOM    152  NZ  LYS    20     -23.196  42.117  24.593  1.00 74.04           N  
ATOM    153  N   VAL    21     -17.050  37.681  23.943  1.00 54.46           N  
ATOM    154  CA  VAL    21     -16.674  36.623  22.977  1.00 52.57           C  
ATOM    155  C   VAL    21     -16.825  35.242  23.636  1.00 50.97           C  
ATOM    156  O   VAL    21     -16.201  34.987  24.690  1.00 52.54           O  
ATOM    157  CB  VAL    21     -15.224  36.823  22.448  1.00 53.00           C  
ATOM    158  CG1 VAL    21     -14.850  35.746  21.373  1.00 50.20           C  
ATOM    159  CG2 VAL    21     -15.069  38.272  21.921  1.00 53.32           C  
ATOM    160  N   MET    22     -17.645  34.392  23.031  1.00 47.48           N  
ATOM    161  CA  MET    22     -17.935  33.066  23.535  1.00 45.74           C  
ATOM    162  C   MET    22     -16.919  32.024  23.033  1.00 46.12           C  
ATOM    163  O   MET    22     -16.448  31.187  23.789  1.00 44.25           O  
ATOM    164  CB  MET    22     -19.358  32.651  23.110  1.00 44.28           C  
ATOM    165  CG  MET    22     -20.425  33.576  23.586  1.00 39.75           C  
ATOM    166  SD  MET    22     -22.258  33.106  23.165  0.65 34.59          SE  
ATOM    167  CE  MET    22     -21.956  33.084  21.247  1.00 31.49           C  
ATOM    168  N   TYR    23     -16.635  32.091  21.739  1.00 47.88           N  
ATOM    169  CA  TYR    23     -15.674  31.233  21.061  1.00 49.56           C  
ATOM    170  C   TYR    23     -15.268  31.816  19.681  1.00 50.94           C  
ATOM    171  O   TYR    23     -15.856  32.791  19.174  1.00 51.25           O  
ATOM    172  CB  TYR    23     -16.185  29.770  20.951  1.00 50.31           C  
ATOM    173  CG  TYR    23     -17.372  29.563  20.024  1.00 50.93           C  
ATOM    174  CD1 TYR    23     -18.670  29.616  20.500  1.00 49.91           C  
ATOM    175  CD2 TYR    23     -17.175  29.286  18.667  1.00 52.85           C  
ATOM    176  CE1 TYR    23     -19.720  29.429  19.667  1.00 50.30           C  
ATOM    177  CE2 TYR    23     -18.208  29.114  17.822  1.00 51.25           C  
ATOM    178  CZ  TYR    23     -19.497  29.195  18.315  1.00 52.04           C  
ATOM    179  OH  TYR    23     -20.564  29.013  17.441  1.00 52.22           O  
ATOM    180  N   LEU    24     -14.183  31.287  19.141  1.00 51.88           N  
ATOM    181  CA  LEU    24     -13.715  31.663  17.815  1.00 52.72           C  
ATOM    182  C   LEU    24     -13.626  30.362  17.061  1.00 55.11           C  
ATOM    183  O   LEU    24     -13.285  29.325  17.648  1.00 55.39           O  
ATOM    184  CB  LEU    24     -12.344  32.388  17.826  1.00 52.44           C  
ATOM    185  CG  LEU    24     -12.203  33.773  18.462  1.00 51.64           C  
ATOM    186  CD1 LEU    24     -12.026  33.718  19.998  1.00 51.46           C  
ATOM    187  CD2 LEU    24     -11.038  34.473  17.904  1.00 51.70           C  
ATOM    188  N   GLU    25     -13.973  30.400  15.778  1.00 57.81           N  
ATOM    189  CA  GLU    25     -13.945  29.200  14.949  1.00 59.82           C  
ATOM    190  C   GLU    25     -13.242  29.431  13.614  1.00 60.44           C  
ATOM    191  O   GLU    25     -13.604  30.367  12.875  1.00 59.87           O  
ATOM    192  CB  GLU    25     -15.354  28.677  14.679  1.00 59.79           C  
ATOM    193  CG  GLU    25     -15.347  27.444  13.750  1.00 59.72           C  
ATOM    194  CD  GLU    25     -16.706  26.844  13.534  1.00 61.31           C  
ATOM    195  OE1 GLU    25     -16.770  25.650  13.104  1.00 61.35           O  
ATOM    196  OE2 GLU    25     -17.683  27.569  13.817  1.00 60.92           O  
ATOM    197  N   ALA    26     -12.258  28.568  13.317  1.00 61.72           N  
ATOM    198  CA  ALA    26     -11.662  28.483  11.973  1.00 62.89           C  
ATOM    199  C   ALA    26     -12.565  27.603  11.100  1.00 65.56           C  
ATOM    200  O   ALA    26     -12.829  26.429  11.378  1.00 65.20           O  
ATOM    201  CB  ALA    26     -10.254  27.931  12.019  1.00 62.69           C  
ATOM    202  N   LYS    27     -13.063  28.199  10.044  1.00 69.29           N  
ATOM    203  CA  LYS    27     -14.038  27.541   9.191  1.00 72.27           C  
ATOM    204  C   LYS    27     -13.991  28.167   7.813  1.00 74.02           C  
ATOM    205  O   LYS    27     -13.931  29.384   7.675  1.00 74.45           O  
ATOM    206  CB  LYS    27     -15.429  27.722   9.796  1.00 72.85           C  
ATOM    207  CG  LYS    27     -16.562  27.045   9.080  1.00 71.39           C  
ATOM    208  CD  LYS    27     -17.859  27.743   9.401  1.00 73.27           C  
ATOM    209  CE  LYS    27     -19.021  26.823   9.163  1.00 75.03           C  
ATOM    210  NZ  LYS    27     -20.097  27.510   8.386  1.00 77.07           N  
ATOM    211  N   ASP    28     -14.003  27.317   6.792  1.00 76.84           N  
ATOM    212  CA  ASP    28     -14.027  27.772   5.401  1.00 77.59           C  
ATOM    213  C   ASP    28     -12.925  28.857   5.134  1.00 77.95           C  
ATOM    214  O   ASP    28     -13.183  29.840   4.426  1.00 78.11           O  
ATOM    215  CB  ASP    28     -15.426  28.300   5.088  1.00 78.53           C  
ATOM    216  CG  ASP    28     -16.548  27.225   5.257  1.00 81.48           C  
ATOM    217  OD1 ASP    28     -16.391  26.062   4.800  1.00 85.00           O  
ATOM    218  OD2 ASP    28     -17.619  27.580   5.817  1.00 84.66           O  
ATOM    219  N   LYS    29     -11.732  28.666   5.747  1.00 77.54           N  
ATOM    220  CA  LYS    29     -10.512  29.518   5.589  1.00 76.82           C  
ATOM    221  C   LYS    29     -10.553  30.922   6.239  1.00 76.10           C  
ATOM    222  O   LYS    29      -9.676  31.767   5.982  1.00 75.77           O  
ATOM    223  CB  LYS    29     -10.095  29.633   4.123  1.00 77.31           C  
ATOM    224  CG  LYS    29      -9.776  28.294   3.467  1.00 79.61           C  
ATOM    225  CD  LYS    29      -8.300  28.168   3.028  1.00 82.32           C  
ATOM    226  CE  LYS    29      -7.955  29.110   1.844  1.00 81.95           C  
ATOM    227  NZ  LYS    29      -7.050  28.464   0.864  1.00 81.33           N  
ATOM    228  N   LYS    30     -11.545  31.145   7.103  1.00 74.77           N  
ATOM    229  CA  LYS    30     -11.693  32.419   7.841  1.00 73.86           C  
ATOM    230  C   LYS    30     -11.796  32.163   9.320  1.00 70.12           C  
ATOM    231  O   LYS    30     -12.089  31.054   9.732  1.00 69.63           O  
ATOM    232  CB  LYS    30     -12.969  33.159   7.380  1.00 73.69           C  
ATOM    233  CG  LYS    30     -12.892  33.658   5.940  1.00 75.38           C  
ATOM    234  CD  LYS    30     -14.271  33.861   5.306  1.00 76.35           C  
ATOM    235  CE  LYS    30     -15.069  32.542   5.226  1.00 78.74           C  
ATOM    236  NZ  LYS    30     -15.844  32.376   3.939  1.00 79.28           N  
ATOM    237  N   THR    31     -11.594  33.207  10.111  1.00 66.89           N  
ATOM    238  CA  THR    31     -11.893  33.163  11.549  1.00 65.08           C  
ATOM    239  C   THR    31     -13.220  33.811  11.855  1.00 63.67           C  
ATOM    240  O   THR    31     -13.442  34.948  11.517  1.00 62.84           O  
ATOM    241  CB  THR    31     -10.816  33.875  12.386  1.00 64.71           C  
ATOM    242  OG1 THR    31      -9.580  33.234  12.126  1.00 62.99           O  
ATOM    243  CG2 THR    31     -11.127  33.820  13.897  1.00 63.56           C  
ATOM    244  N   TYR    32     -14.094  33.071  12.517  1.00 62.97           N  
ATOM    245  CA  TYR    32     -15.375  33.591  12.932  1.00 62.51           C  
ATOM    246  C   TYR    32     -15.293  33.820  14.416  1.00 61.62           C  
ATOM    247  O   TYR    32     -14.985  32.920  15.157  1.00 59.82           O  
ATOM    248  CB  TYR    32     -16.482  32.597  12.613  1.00 62.96           C  
ATOM    249  CG  TYR    32     -16.784  32.554  11.163  1.00 63.75           C  
ATOM    250  CD1 TYR    32     -16.112  31.659  10.310  1.00 64.37           C  
ATOM    251  CD2 TYR    32     -17.720  33.424  10.619  1.00 63.97           C  
ATOM    252  CE1 TYR    32     -16.372  31.623   8.960  1.00 63.90           C  
ATOM    253  CE2 TYR    32     -17.995  33.399   9.262  1.00 65.20           C  
ATOM    254  CZ  TYR    32     -17.315  32.500   8.435  1.00 64.90           C  
ATOM    255  OH  TYR    32     -17.603  32.502   7.092  1.00 66.11           O  
ATOM    256  N   VAL    33     -15.552  35.053  14.816  1.00 61.66           N  
ATOM    257  CA  VAL    33     -15.658  35.444  16.205  1.00 61.87           C  
ATOM    258  C   VAL    33     -17.151  35.415  16.578  1.00 62.05           C  
ATOM    259  O   VAL    33     -17.957  36.188  16.059  1.00 61.79           O  
ATOM    260  CB  VAL    33     -15.008  36.840  16.436  1.00 62.18           C  
ATOM    261  CG1 VAL    33     -14.848  37.108  17.914  1.00 61.84           C  
ATOM    262  CG2 VAL    33     -13.647  36.922  15.752  1.00 60.44           C  
ATOM    263  N   ASN    34     -17.497  34.469  17.451  1.00 62.63           N  
ATOM    264  CA  ASN    34     -18.843  34.272  17.968  1.00 62.74           C  
ATOM    265  C   ASN    34     -19.034  34.955  19.334  1.00 63.11           C  
ATOM    266  O   ASN    34     -18.592  34.446  20.374  1.00 62.77           O  
ATOM    267  CB  ASN    34     -19.123  32.787  18.102  1.00 62.29           C  
ATOM    268  CG  ASN    34     -19.303  32.091  16.759  1.00 63.83           C  
ATOM    269  OD1 ASN    34     -18.327  31.761  16.066  1.00 64.13           O  
ATOM    270  ND2 ASN    34     -20.564  31.825  16.410  1.00 61.91           N  
ATOM    271  N   ALA    35     -19.694  36.106  19.302  1.00 63.82           N  
ATOM    272  CA  ALA    35     -19.983  36.927  20.474  1.00 64.45           C  
ATOM    273  C   ALA    35     -21.436  36.713  20.877  1.00 66.13           C  
ATOM    274  O   ALA    35     -22.229  36.105  20.157  1.00 65.78           O  
ATOM    275  CB  ALA    35     -19.695  38.400  20.190  1.00 63.41           C  
ATOM    276  N   GLU    36     -21.795  37.194  22.050  1.00 68.62           N  
ATOM    277  CA  GLU    36     -23.081  36.813  22.627  1.00 71.28           C  
ATOM    278  C   GLU    36     -24.264  37.179  21.727  1.00 72.31           C  
ATOM    279  O   GLU    36     -25.229  36.416  21.623  1.00 72.56           O  
ATOM    280  CB  GLU    36     -23.270  37.459  23.986  1.00 71.27           C  
ATOM    281  CG  GLU    36     -22.296  37.014  25.046  1.00 72.06           C  
ATOM    282  CD  GLU    36     -22.437  37.838  26.279  1.00 72.04           C  
ATOM    283  OE1 GLU    36     -23.142  38.857  26.238  1.00 79.71           O  
ATOM    284  OE2 GLU    36     -21.848  37.506  27.306  1.00 76.93           O  
ATOM    285  N   GLU    37     -24.176  38.350  21.095  1.00 73.72           N  
ATOM    286  CA  GLU    37     -25.256  38.902  20.300  1.00 74.69           C  
ATOM    287  C   GLU    37     -24.968  38.923  18.809  1.00 73.94           C  
ATOM    288  O   GLU    37     -25.870  39.226  18.044  1.00 74.01           O  
ATOM    289  CB  GLU    37     -25.544  40.340  20.756  1.00 75.48           C  
ATOM    290  CG  GLU    37     -26.188  40.454  22.149  1.00 79.08           C  
ATOM    291  CD  GLU    37     -26.492  41.922  22.561  1.00 81.78           C  
ATOM    292  OE1 GLU    37     -26.163  42.870  21.779  1.00 88.35           O  
ATOM    293  OE2 GLU    37     -27.085  42.122  23.668  1.00 90.68           O  
ATOM    294  N   LEU    38     -23.731  38.686  18.375  1.00 73.06           N  
ATOM    295  CA  LEU    38     -23.468  38.604  16.936  1.00 72.61           C  
ATOM    296  C   LEU    38     -22.227  37.794  16.586  1.00 71.39           C  
ATOM    297  O   LEU    38     -21.450  37.416  17.461  1.00 70.69           O  
ATOM    298  CB  LEU    38     -23.486  39.992  16.249  1.00 72.94           C  
ATOM    299  CG  LEU    38     -22.409  41.099  16.273  1.00 74.37           C  
ATOM    300  CD1 LEU    38     -21.356  40.894  17.336  1.00 75.46           C  
ATOM    301  CD2 LEU    38     -21.758  41.268  14.892  1.00 76.18           C  
ATOM    302  N   THR    39     -22.104  37.494  15.295  1.00 69.92           N  
ATOM    303  CA  THR    39     -20.996  36.762  14.757  1.00 69.17           C  
ATOM    304  C   THR    39     -20.404  37.501  13.595  1.00 67.93           C  
ATOM    305  O   THR    39     -21.063  38.201  12.878  1.00 67.20           O  
ATOM    306  CB  THR    39     -21.369  35.320  14.401  1.00 69.41           C  
ATOM    307  OG1 THR    39     -21.821  34.687  15.605  1.00 71.60           O  
ATOM    308  CG2 THR    39     -20.108  34.536  13.876  1.00 69.54           C  
ATOM    309  N   GLY    40     -19.109  37.374  13.441  1.00 67.61           N  
ATOM    310  CA  GLY    40     -18.450  38.155  12.439  1.00 67.41           C  
ATOM    311  C   GLY    40     -17.090  37.590  12.170  1.00 66.88           C  
ATOM    312  O   GLY    40     -16.639  36.670  12.816  1.00 67.02           O  
ATOM    313  N   THR    41     -16.441  38.197  11.209  1.00 66.71           N  
ATOM    314  CA  THR    41     -15.244  37.685  10.614  1.00 66.20           C  
ATOM    315  C   THR    41     -14.079  38.538  11.166  1.00 65.32           C  
ATOM    316  O   THR    41     -14.253  39.725  11.501  1.00 64.33           O  
ATOM    317  CB  THR    41     -15.448  37.747   9.089  1.00 66.32           C  
ATOM    318  OG1 THR    41     -15.778  36.433   8.622  1.00 69.23           O  
ATOM    319  CG2 THR    41     -14.257  38.300   8.359  1.00 65.71           C  
ATOM    320  N   HIS    42     -12.924  37.902  11.318  1.00 64.06           N  
ATOM    321  CA  HIS    42     -11.723  38.584  11.690  1.00 63.72           C  
ATOM    322  C   HIS    42     -10.599  38.078  10.825  1.00 64.21           C  
ATOM    323  O   HIS    42     -10.583  36.908  10.461  1.00 64.45           O  
ATOM    324  CB  HIS    42     -11.367  38.369  13.166  1.00 63.65           C  
ATOM    325  CG  HIS    42     -10.449  39.428  13.691  1.00 62.41           C  
ATOM    326  ND1 HIS    42      -9.112  39.479  13.366  1.00 61.46           N  
ATOM    327  CD2 HIS    42     -10.691  40.528  14.442  1.00 62.93           C  
ATOM    328  CE1 HIS    42      -8.561  40.552  13.911  1.00 63.05           C  
ATOM    329  NE2 HIS    42      -9.496  41.203  14.578  1.00 62.92           N  
ATOM    330  N   LYS    43      -9.637  38.948  10.534  1.00 64.61           N  
ATOM    331  CA  LYS    43      -8.513  38.581   9.688  1.00 65.27           C  
ATOM    332  C   LYS    43      -7.419  37.763  10.375  1.00 64.45           C  
ATOM    333  O   LYS    43      -6.608  37.136   9.710  1.00 64.94           O  
ATOM    334  CB  LYS    43      -7.914  39.844   9.036  1.00 66.18           C  
ATOM    335  CG  LYS    43      -7.385  40.918  10.010  1.00 67.83           C  
ATOM    336  CD  LYS    43      -6.601  41.976   9.258  1.00 67.72           C  
ATOM    337  CE  LYS    43      -5.732  42.773  10.201  1.00 70.39           C  
ATOM    338  NZ  LYS    43      -5.356  44.057   9.555  1.00 73.82           N  
ATOM    339  N   TYR    44      -7.359  37.765  11.694  1.00 64.49           N  
ATOM    340  CA  TYR    44      -6.292  37.035  12.387  1.00 63.96           C  
ATOM    341  C   TYR    44      -6.623  35.581  12.476  1.00 62.69           C  
ATOM    342  O   TYR    44      -7.781  35.206  12.512  1.00 62.31           O  
ATOM    343  CB  TYR    44      -6.062  37.533  13.813  1.00 65.08           C  
ATOM    344  CG  TYR    44      -5.539  38.923  13.976  1.00 65.75           C  
ATOM    345  CD1 TYR    44      -4.940  39.618  12.936  1.00 67.27           C  
ATOM    346  CD2 TYR    44      -5.636  39.546  15.203  1.00 68.59           C  
ATOM    347  CE1 TYR    44      -4.483  40.907  13.114  1.00 67.96           C  
ATOM    348  CE2 TYR    44      -5.174  40.843  15.389  1.00 68.78           C  
ATOM    349  CZ  TYR    44      -4.605  41.505  14.348  1.00 67.12           C  
ATOM    350  OH  TYR    44      -4.168  42.776  14.566  1.00 68.22           O  
ATOM    351  N   SER    45      -5.580  34.766  12.551  1.00 61.92           N  
ATOM    352  CA  SER    45      -5.718  33.320  12.580  1.00 61.21           C  
ATOM    353  C   SER    45      -5.910  32.966  14.035  1.00 60.89           C  
ATOM    354  O   SER    45      -5.765  33.817  14.906  1.00 60.84           O  
ATOM    355  CB  SER    45      -4.449  32.643  12.015  1.00 60.63           C  
ATOM    356  OG  SER    45      -3.358  32.837  12.896  1.00 61.26           O  
ATOM    357  N   LEU    46      -6.241  31.710  14.294  1.00 60.97           N  
ATOM    358  CA  LEU    46      -6.426  31.228  15.652  1.00 60.86           C  
ATOM    359  C   LEU    46      -5.108  31.226  16.395  1.00 61.40           C  
ATOM    360  O   LEU    46      -5.046  31.396  17.627  1.00 61.30           O  
ATOM    361  CB  LEU    46      -7.046  29.836  15.640  1.00 60.45           C  
ATOM    362  CG  LEU    46      -8.517  29.710  15.243  1.00 59.06           C  
ATOM    363  CD1 LEU    46      -8.975  28.342  15.621  1.00 56.63           C  
ATOM    364  CD2 LEU    46      -9.441  30.795  15.873  1.00 56.73           C  
ATOM    365  N   GLN    47      -4.037  31.061  15.632  1.00 62.21           N  
ATOM    366  CA  GLN    47      -2.701  31.132  16.192  1.00 61.91           C  
ATOM    367  C   GLN    47      -2.410  32.553  16.709  1.00 61.17           C  
ATOM    368  O   GLN    47      -1.915  32.726  17.833  1.00 59.89           O  
ATOM    369  CB  GLN    47      -1.670  30.639  15.172  1.00 61.58           C  
ATOM    370  CG  GLN    47      -0.266  30.464  15.791  1.00 63.42           C  
ATOM    371  CD  GLN    47       0.842  30.263  14.748  1.00 64.22           C  
ATOM    372  OE1 GLN    47       1.908  29.738  15.056  1.00 70.90           O  
ATOM    373  NE2 GLN    47       0.603  30.713  13.533  1.00 65.38           N  
ATOM    374  N   GLU    48      -2.731  33.560  15.894  1.00 61.05           N  
ATOM    375  CA  GLU    48      -2.575  34.950  16.300  1.00 61.50           C  
ATOM    376  C   GLU    48      -3.455  35.319  17.491  1.00 60.76           C  
ATOM    377  O   GLU    48      -2.986  35.927  18.458  1.00 60.41           O  
ATOM    378  CB  GLU    48      -2.822  35.888  15.136  1.00 61.77           C  
ATOM    379  CG  GLU    48      -1.623  35.839  14.139  1.00 64.39           C  
ATOM    380  CD  GLU    48      -1.907  36.338  12.699  1.00 63.87           C  
ATOM    381  OE1 GLU    48      -3.074  36.414  12.227  1.00 63.24           O  
ATOM    382  OE2 GLU    48      -0.890  36.620  12.035  1.00 68.21           O  
ATOM    383  N   PHE    49      -4.719  34.943  17.442  1.00 60.08           N  
ATOM    384  CA  PHE    49      -5.592  35.133  18.596  1.00 59.74           C  
ATOM    385  C   PHE    49      -5.080  34.464  19.874  1.00 59.52           C  
ATOM    386  O   PHE    49      -5.273  34.997  20.948  1.00 59.32           O  
ATOM    387  CB  PHE    49      -7.025  34.672  18.295  1.00 59.41           C  
ATOM    388  CG  PHE    49      -7.869  35.716  17.645  1.00 58.45           C  
ATOM    389  CD1 PHE    49      -8.265  36.829  18.346  1.00 59.31           C  
ATOM    390  CD2 PHE    49      -8.277  35.583  16.337  1.00 59.28           C  
ATOM    391  CE1 PHE    49      -9.062  37.809  17.748  1.00 59.58           C  
ATOM    392  CE2 PHE    49      -9.071  36.546  15.743  1.00 58.97           C  
ATOM    393  CZ  PHE    49      -9.463  37.654  16.452  1.00 58.62           C  
ATOM    394  N   GLU    50      -4.438  33.309  19.785  1.00 59.90           N  
ATOM    395  CA  GLU    50      -3.891  32.692  20.993  1.00 60.98           C  
ATOM    396  C   GLU    50      -2.847  33.566  21.696  1.00 60.69           C  
ATOM    397  O   GLU    50      -2.687  33.525  22.913  1.00 61.09           O  
ATOM    398  CB  GLU    50      -3.245  31.350  20.681  1.00 61.30           C  
ATOM    399  CG  GLU    50      -4.198  30.209  20.578  1.00 62.87           C  
ATOM    400  CD  GLU    50      -3.463  28.877  20.628  1.00 63.39           C  
ATOM    401  OE1 GLU    50      -3.150  28.378  19.529  1.00 62.18           O  
ATOM    402  OE2 GLU    50      -3.203  28.357  21.763  1.00 64.88           O  
ATOM    403  N   TYR    51      -2.100  34.319  20.908  1.00 60.43           N  
ATOM    404  CA  TYR    51      -1.147  35.239  21.431  1.00 59.53           C  
ATOM    405  C   TYR    51      -1.873  36.419  22.104  1.00 58.87           C  
ATOM    406  O   TYR    51      -1.497  36.853  23.180  1.00 57.91           O  
ATOM    407  CB  TYR    51      -0.190  35.717  20.308  1.00 60.13           C  
ATOM    408  CG  TYR    51       0.664  36.911  20.739  1.00 60.63           C  
ATOM    409  CD1 TYR    51       1.815  36.725  21.527  1.00 60.30           C  
ATOM    410  CD2 TYR    51       0.271  38.213  20.442  1.00 59.27           C  
ATOM    411  CE1 TYR    51       2.575  37.801  21.974  1.00 60.07           C  
ATOM    412  CE2 TYR    51       1.015  39.298  20.886  1.00 60.70           C  
ATOM    413  CZ  TYR    51       2.179  39.093  21.652  1.00 61.51           C  
ATOM    414  OH  TYR    51       2.937  40.192  22.068  1.00 61.75           O  
ATOM    415  N   LEU    52      -2.928  36.927  21.484  1.00 59.17           N  
ATOM    416  CA  LEU    52      -3.469  38.211  21.913  1.00 59.78           C  
ATOM    417  C   LEU    52      -4.591  38.163  22.951  1.00 58.88           C  
ATOM    418  O   LEU    52      -4.808  39.121  23.689  1.00 58.40           O  
ATOM    419  CB  LEU    52      -3.838  39.056  20.705  1.00 59.99           C  
ATOM    420  CG  LEU    52      -5.137  38.900  19.986  1.00 62.34           C  
ATOM    421  CD1 LEU    52      -6.204  39.814  20.632  1.00 63.11           C  
ATOM    422  CD2 LEU    52      -4.889  39.263  18.464  1.00 61.78           C  
ATOM    423  N   LEU    53      -5.255  37.025  23.034  1.00 58.60           N  
ATOM    424  CA  LEU    53      -6.360  36.850  23.928  1.00 58.14           C  
ATOM    425  C   LEU    53      -5.816  36.464  25.279  1.00 58.30           C  
ATOM    426  O   LEU    53      -4.794  35.750  25.362  1.00 58.20           O  
ATOM    427  CB  LEU    53      -7.317  35.777  23.404  1.00 58.30           C  
ATOM    428  CG  LEU    53      -8.118  36.061  22.113  1.00 57.08           C  
ATOM    429  CD1 LEU    53      -8.762  34.777  21.657  1.00 51.00           C  
ATOM    430  CD2 LEU    53      -9.141  37.175  22.316  1.00 54.58           C  
ATOM    431  N   PRO    54      -6.464  36.963  26.348  1.00 58.29           N  
ATOM    432  CA  PRO    54      -6.008  36.686  27.722  1.00 58.90           C  
ATOM    433  C   PRO    54      -6.029  35.202  28.076  1.00 59.86           C  
ATOM    434  O   PRO    54      -7.042  34.531  27.929  1.00 60.64           O  
ATOM    435  CB  PRO    54      -6.971  37.490  28.613  1.00 58.39           C  
ATOM    436  CG  PRO    54      -7.991  38.073  27.727  1.00 58.75           C  
ATOM    437  CD  PRO    54      -7.626  37.865  26.299  1.00 57.84           C  
ATOM    438  N   LYS    55      -4.902  34.698  28.537  1.00 61.50           N  
ATOM    439  CA  LYS    55      -4.705  33.267  28.684  1.00 63.14           C  
ATOM    440  C   LYS    55      -5.491  32.742  29.909  1.00 62.48           C  
ATOM    441  O   LYS    55      -5.724  31.537  30.039  1.00 62.64           O  
ATOM    442  CB  LYS    55      -3.189  32.944  28.699  1.00 63.10           C  
ATOM    443  CG  LYS    55      -2.533  33.080  30.067  1.00 66.03           C  
ATOM    444  CD  LYS    55      -0.970  33.110  30.025  1.00 66.76           C  
ATOM    445  CE  LYS    55      -0.329  32.841  31.429  1.00 66.49           C  
ATOM    446  NZ  LYS    55      -1.178  33.499  32.466  1.00 68.77           N  
ATOM    447  N   ASP    56      -5.972  33.653  30.754  1.00 62.23           N  
ATOM    448  CA  ASP    56      -6.820  33.272  31.900  1.00 62.66           C  
ATOM    449  C   ASP    56      -8.286  32.924  31.528  1.00 62.28           C  
ATOM    450  O   ASP    56      -9.004  32.312  32.320  1.00 62.43           O  
ATOM    451  CB  ASP    56      -6.774  34.362  32.996  1.00 63.27           C  
ATOM    452  CG  ASP    56      -7.440  35.702  32.578  1.00 65.72           C  
ATOM    453  OD1 ASP    56      -7.542  36.045  31.388  1.00 71.06           O  
ATOM    454  OD2 ASP    56      -7.837  36.464  33.470  1.00 69.99           O  
ATOM    455  N   SER    57      -8.701  33.304  30.319  1.00 61.57           N  
ATOM    456  CA  SER    57     -10.084  33.188  29.870  1.00 60.88           C  
ATOM    457  C   SER    57     -10.259  32.343  28.635  1.00 59.81           C  
ATOM    458  O   SER    57     -11.243  31.649  28.501  1.00 59.87           O  
ATOM    459  CB  SER    57     -10.622  34.581  29.563  1.00 61.29           C  
ATOM    460  OG  SER    57     -11.419  35.015  30.614  1.00 62.81           O  
ATOM    461  N   PHE    58      -9.303  32.437  27.722  1.00 59.09           N  
ATOM    462  CA  PHE    58      -9.379  31.813  26.399  1.00 58.06           C  
ATOM    463  C   PHE    58      -8.452  30.610  26.317  1.00 57.54           C  
ATOM    464  O   PHE    58      -7.371  30.640  26.831  1.00 56.74           O  
ATOM    465  CB  PHE    58      -9.069  32.868  25.328  1.00 57.04           C  
ATOM    466  CG  PHE    58     -10.143  33.942  25.230  1.00 57.21           C  
ATOM    467  CD1 PHE    58     -10.055  35.107  25.979  1.00 58.12           C  
ATOM    468  CD2 PHE    58     -11.283  33.745  24.453  1.00 56.05           C  
ATOM    469  CE1 PHE    58     -11.056  36.083  25.917  1.00 56.66           C  
ATOM    470  CE2 PHE    58     -12.268  34.687  24.390  1.00 55.56           C  
ATOM    471  CZ  PHE    58     -12.160  35.864  25.123  1.00 57.10           C  
ATOM    472  N   ILE    59      -8.926  29.516  25.717  1.00 58.38           N  
ATOM    473  CA  ILE    59      -8.101  28.330  25.484  1.00 58.40           C  
ATOM    474  C   ILE    59      -8.378  27.708  24.119  1.00 57.04           C  
ATOM    475  O   ILE    59      -9.503  27.433  23.783  1.00 57.12           O  
ATOM    476  CB  ILE    59      -8.278  27.248  26.623  1.00 58.94           C  
ATOM    477  CG1 ILE    59      -7.242  26.113  26.455  1.00 59.95           C  
ATOM    478  CG2 ILE    59      -9.671  26.624  26.591  1.00 61.49           C  
ATOM    479  CD1 ILE    59      -7.061  25.222  27.673  1.00 59.51           C  
ATOM    480  N   ARG    60      -7.331  27.507  23.334  1.00 56.09           N  
ATOM    481  CA  ARG    60      -7.365  26.596  22.210  1.00 55.43           C  
ATOM    482  C   ARG    60      -7.704  25.167  22.655  1.00 55.43           C  
ATOM    483  O   ARG    60      -6.964  24.531  23.401  1.00 54.84           O  
ATOM    484  CB  ARG    60      -6.032  26.595  21.470  1.00 55.35           C  
ATOM    485  CG  ARG    60      -6.111  25.946  20.100  1.00 54.80           C  
ATOM    486  CD  ARG    60      -6.621  26.906  19.054  1.00 54.03           C  
ATOM    487  NE  ARG    60      -6.421  26.382  17.706  1.00 54.40           N  
ATOM    488  CZ  ARG    60      -5.341  26.570  16.948  1.00 54.54           C  
ATOM    489  NH1 ARG    60      -4.317  27.302  17.361  1.00 53.75           N  
ATOM    490  NH2 ARG    60      -5.306  26.062  15.726  1.00 52.56           N  
ATOM    491  N   CYS    61      -8.839  24.669  22.157  1.00 55.76           N  
ATOM    492  CA  CYS    61      -9.343  23.361  22.541  1.00 55.48           C  
ATOM    493  C   CYS    61      -9.510  22.395  21.380  1.00 55.23           C  
ATOM    494  O   CYS    61      -9.906  21.259  21.574  1.00 55.26           O  
ATOM    495  CB  CYS    61     -10.665  23.534  23.288  1.00 55.58           C  
ATOM    496  SG  CYS    61     -11.994  24.211  22.330  1.00 53.65           S  
ATOM    497  N   HIS    62      -9.165  22.841  20.182  1.00 55.99           N  
ATOM    498  CA  HIS    62      -9.402  22.100  18.952  1.00 56.21           C  
ATOM    499  C   HIS    62      -8.646  22.898  17.909  1.00 56.71           C  
ATOM    500  O   HIS    62      -8.516  24.087  18.073  1.00 56.13           O  
ATOM    501  CB  HIS    62     -10.904  22.123  18.682  1.00 55.80           C  
ATOM    502  CG  HIS    62     -11.360  21.244  17.560  1.00 55.15           C  
ATOM    503  ND1 HIS    62     -11.127  21.544  16.235  1.00 55.71           N  
ATOM    504  CD2 HIS    62     -12.114  20.120  17.563  1.00 55.19           C  
ATOM    505  CE1 HIS    62     -11.707  20.639  15.472  1.00 57.18           C  
ATOM    506  NE2 HIS    62     -12.324  19.768  16.249  1.00 56.36           N  
ATOM    507  N   ARG    63      -8.158  22.257  16.842  1.00 58.44           N  
ATOM    508  CA  ARG    63      -7.437  22.946  15.749  1.00 59.37           C  
ATOM    509  C   ARG    63      -8.257  24.034  15.090  1.00 58.79           C  
ATOM    510  O   ARG    63      -7.709  24.907  14.434  1.00 59.46           O  
ATOM    511  CB  ARG    63      -6.927  21.953  14.672  1.00 60.11           C  
ATOM    512  CG  ARG    63      -8.010  21.232  13.863  1.00 62.74           C  
ATOM    513  CD  ARG    63      -7.459  20.502  12.602  1.00 65.11           C  
ATOM    514  NE  ARG    63      -8.414  20.771  11.518  1.00 73.56           N  
ATOM    515  CZ  ARG    63      -8.179  21.504  10.427  1.00 75.10           C  
ATOM    516  NH1 ARG    63      -6.978  21.990  10.151  1.00 78.37           N  
ATOM    517  NH2 ARG    63      -9.161  21.719   9.573  1.00 74.99           N  
ATOM    518  N   SER    64      -9.564  23.969  15.261  1.00 58.15           N  
ATOM    519  CA  SER    64     -10.502  24.915  14.654  1.00 58.67           C  
ATOM    520  C   SER    64     -11.241  25.837  15.662  1.00 58.50           C  
ATOM    521  O   SER    64     -12.032  26.676  15.231  1.00 59.59           O  
ATOM    522  CB  SER    64     -11.533  24.110  13.832  1.00 58.55           C  
ATOM    523  OG  SER    64     -11.020  23.791  12.524  1.00 60.29           O  
ATOM    524  N   PHE    65     -10.976  25.713  16.971  1.00 58.22           N  
ATOM    525  CA  PHE    65     -11.703  26.480  18.006  1.00 58.03           C  
ATOM    526  C   PHE    65     -10.839  27.041  19.093  1.00 56.70           C  
ATOM    527  O   PHE    65      -9.964  26.344  19.638  1.00 56.67           O  
ATOM    528  CB  PHE    65     -12.742  25.606  18.710  1.00 59.19           C  
ATOM    529  CG  PHE    65     -13.870  25.194  17.825  1.00 60.22           C  
ATOM    530  CD1 PHE    65     -13.793  24.021  17.083  1.00 63.71           C  
ATOM    531  CD2 PHE    65     -15.010  25.995  17.713  1.00 60.70           C  
ATOM    532  CE1 PHE    65     -14.870  23.647  16.196  1.00 61.83           C  
ATOM    533  CE2 PHE    65     -16.064  25.636  16.875  1.00 62.73           C  
ATOM    534  CZ  PHE    65     -15.991  24.452  16.116  1.00 61.68           C  
ATOM    535  N   ILE    66     -11.110  28.306  19.428  1.00 55.10           N  
ATOM    536  CA  ILE    66     -10.716  28.874  20.707  1.00 53.34           C  
ATOM    537  C   ILE    66     -12.004  29.164  21.526  1.00 53.38           C  
ATOM    538  O   ILE    66     -12.942  29.786  21.037  1.00 51.87           O  
ATOM    539  CB  ILE    66      -9.875  30.163  20.574  1.00 54.09           C  
ATOM    540  CG1 ILE    66      -8.543  29.891  19.855  1.00 50.40           C  
ATOM    541  CG2 ILE    66      -9.676  30.826  21.994  1.00 54.22           C  
ATOM    542  CD1 ILE    66      -7.818  31.110  19.492  1.00 50.41           C  
ATOM    543  N   VAL    67     -12.046  28.673  22.766  1.00 53.17           N  
ATOM    544  CA  VAL    67     -13.202  28.885  23.634  1.00 53.52           C  
ATOM    545  C   VAL    67     -12.893  29.890  24.778  1.00 53.87           C  
ATOM    546  O   VAL    67     -11.735  29.980  25.302  1.00 54.47           O  
ATOM    547  CB  VAL    67     -13.762  27.510  24.166  1.00 53.86           C  
ATOM    548  CG1 VAL    67     -12.883  26.912  25.260  1.00 50.91           C  
ATOM    549  CG2 VAL    67     -15.235  27.649  24.669  1.00 53.80           C  
ATOM    550  N   ASN    68     -13.909  30.652  25.159  1.00 53.60           N  
ATOM    551  CA  ASN    68     -13.868  31.466  26.397  1.00 54.29           C  
ATOM    552  C   ASN    68     -14.450  30.636  27.529  1.00 54.17           C  
ATOM    553  O   ASN    68     -15.636  30.364  27.539  1.00 53.52           O  
ATOM    554  CB  ASN    68     -14.710  32.747  26.209  1.00 54.77           C  
ATOM    555  CG  ASN    68     -14.520  33.760  27.317  1.00 53.31           C  
ATOM    556  OD1 ASN    68     -14.120  33.424  28.392  1.00 54.57           O  
ATOM    557  ND2 ASN    68     -14.863  35.007  27.044  1.00 52.58           N  
ATOM    558  N   VAL    69     -13.618  30.273  28.499  1.00 54.85           N  
ATOM    559  CA  VAL    69     -14.043  29.415  29.612  1.00 55.43           C  
ATOM    560  C   VAL    69     -15.141  30.083  30.436  1.00 56.62           C  
ATOM    561  O   VAL    69     -15.870  29.393  31.166  1.00 58.19           O  
ATOM    562  CB  VAL    69     -12.846  28.968  30.530  1.00 55.37           C  
ATOM    563  CG1 VAL    69     -11.653  28.422  29.661  1.00 55.16           C  
ATOM    564  CG2 VAL    69     -12.377  30.090  31.405  1.00 55.08           C  
ATOM    565  N   ASN    70     -15.299  31.407  30.314  1.00 56.08           N  
ATOM    566  CA  ASN    70     -16.347  32.088  31.060  1.00 56.16           C  
ATOM    567  C   ASN    70     -17.726  31.956  30.477  1.00 56.59           C  
ATOM    568  O   ASN    70     -18.711  32.302  31.130  1.00 56.78           O  
ATOM    569  CB  ASN    70     -15.976  33.553  31.263  1.00 55.78           C  
ATOM    570  CG  ASN    70     -14.760  33.692  32.167  1.00 57.60           C  
ATOM    571  OD1 ASN    70     -14.802  33.308  33.352  1.00 58.65           O  
ATOM    572  ND2 ASN    70     -13.656  34.173  31.602  1.00 56.66           N  
ATOM    573  N   HIS    71     -17.804  31.474  29.237  1.00 57.27           N  
ATOM    574  CA  HIS    71     -19.077  31.130  28.622  1.00 56.72           C  
ATOM    575  C   HIS    71     -19.350  29.661  28.597  1.00 56.36           C  
ATOM    576  O   HIS    71     -20.374  29.254  28.104  1.00 57.18           O  
ATOM    577  CB  HIS    71     -19.166  31.719  27.246  1.00 57.35           C  
ATOM    578  CG  HIS    71     -19.139  33.203  27.259  1.00 57.90           C  
ATOM    579  ND1 HIS    71     -20.280  33.959  27.383  1.00 63.49           N  
ATOM    580  CD2 HIS    71     -18.109  34.078  27.214  1.00 60.53           C  
ATOM    581  CE1 HIS    71     -19.955  35.244  27.396  1.00 62.23           C  
ATOM    582  NE2 HIS    71     -18.639  35.341  27.291  1.00 62.98           N  
ATOM    583  N   ILE    72     -18.467  28.856  29.160  1.00 56.78           N  
ATOM    584  CA  ILE    72     -18.715  27.416  29.278  1.00 57.01           C  
ATOM    585  C   ILE    72     -19.716  27.212  30.391  1.00 58.60           C  
ATOM    586  O   ILE    72     -19.519  27.704  31.521  1.00 59.44           O  
ATOM    587  CB  ILE    72     -17.442  26.564  29.579  1.00 56.64           C  
ATOM    588  CG1 ILE    72     -16.472  26.602  28.392  1.00 55.81           C  
ATOM    589  CG2 ILE    72     -17.812  25.081  29.890  1.00 55.58           C  
ATOM    590  CD1 ILE    72     -15.142  25.972  28.642  1.00 54.02           C  
ATOM    591  N   LYS    73     -20.772  26.466  30.084  1.00 59.67           N  
ATOM    592  CA  LYS    73     -21.706  26.041  31.113  1.00 61.42           C  
ATOM    593  C   LYS    73     -21.262  24.704  31.775  1.00 60.69           C  
ATOM    594  O   LYS    73     -21.191  24.623  33.016  1.00 61.22           O  
ATOM    595  CB  LYS    73     -23.111  25.949  30.533  1.00 61.67           C  
ATOM    596  CG  LYS    73     -24.142  25.461  31.516  1.00 64.57           C  
ATOM    597  CD  LYS    73     -25.534  25.732  31.000  1.00 66.39           C  
ATOM    598  CE  LYS    73     -26.394  24.489  31.034  1.00 71.85           C  
ATOM    599  NZ  LYS    73     -27.081  24.405  32.361  1.00 75.78           N  
ATOM    600  N   ALA    74     -20.935  23.699  30.963  1.00 59.58           N  
ATOM    601  CA  ALA    74     -20.549  22.375  31.470  1.00 59.98           C  
ATOM    602  C   ALA    74     -19.606  21.709  30.482  1.00 59.82           C  
ATOM    603  O   ALA    74     -19.678  21.978  29.271  1.00 59.65           O  
ATOM    604  CB  ALA    74     -21.780  21.458  31.717  1.00 59.20           C  
ATOM    605  N   ILE    75     -18.718  20.867  31.024  1.00 59.52           N  
ATOM    606  CA  ILE    75     -17.764  20.066  30.280  1.00 60.03           C  
ATOM    607  C   ILE    75     -18.177  18.592  30.458  1.00 60.42           C  
ATOM    608  O   ILE    75     -18.284  18.096  31.585  1.00 59.74           O  
ATOM    609  CB  ILE    75     -16.303  20.229  30.794  1.00 60.12           C  
ATOM    610  CG1 ILE    75     -15.880  21.709  30.841  1.00 60.21           C  
ATOM    611  CG2 ILE    75     -15.338  19.325  29.978  1.00 58.97           C  
ATOM    612  CD1 ILE    75     -14.580  22.010  31.675  1.00 58.17           C  
ATOM    613  N   TYR    76     -18.381  17.912  29.331  1.00 61.43           N  
ATOM    614  CA  TYR    76     -18.799  16.505  29.281  1.00 62.33           C  
ATOM    615  C   TYR    76     -17.750  15.657  28.663  1.00 62.77           C  
ATOM    616  O   TYR    76     -17.159  16.044  27.674  1.00 61.86           O  
ATOM    617  CB  TYR    76     -20.067  16.365  28.420  1.00 64.04           C  
ATOM    618  CG  TYR    76     -21.249  17.027  29.074  1.00 64.55           C  
ATOM    619  CD1 TYR    76     -21.826  16.451  30.207  1.00 66.04           C  
ATOM    620  CD2 TYR    76     -21.780  18.217  28.590  1.00 64.45           C  
ATOM    621  CE1 TYR    76     -22.867  17.032  30.858  1.00 67.30           C  
ATOM    622  CE2 TYR    76     -22.879  18.804  29.232  1.00 64.89           C  
ATOM    623  CZ  TYR    76     -23.410  18.204  30.369  1.00 66.45           C  
ATOM    624  OH  TYR    76     -24.482  18.749  31.069  1.00 68.02           O  
ATOM    625  N   PRO    77     -17.504  14.483  29.243  1.00 64.19           N  
ATOM    626  CA  PRO    77     -16.632  13.542  28.528  1.00 65.35           C  
ATOM    627  C   PRO    77     -17.478  12.787  27.532  1.00 65.44           C  
ATOM    628  O   PRO    77     -18.058  11.803  27.890  1.00 65.52           O  
ATOM    629  CB  PRO    77     -16.077  12.640  29.644  1.00 64.99           C  
ATOM    630  CG  PRO    77     -17.099  12.714  30.759  1.00 64.32           C  
ATOM    631  CD  PRO    77     -17.955  13.963  30.548  1.00 64.28           C  
ATOM    632  N   ASP    78     -17.579  13.279  26.304  1.00 66.55           N  
ATOM    633  CA  ASP    78     -18.605  12.768  25.363  1.00 67.46           C  
ATOM    634  C   ASP    78     -18.200  11.397  24.815  1.00 68.08           C  
ATOM    635  O   ASP    78     -19.042  10.591  24.469  1.00 67.98           O  
ATOM    636  CB  ASP    78     -18.926  13.781  24.241  1.00 66.88           C  
ATOM    637  CG  ASP    78     -17.714  14.146  23.391  1.00 68.06           C  
ATOM    638  OD1 ASP    78     -16.610  14.309  23.934  1.00 69.21           O  
ATOM    639  OD2 ASP    78     -17.872  14.306  22.161  1.00 71.97           O  
ATOM    640  N   THR    79     -16.891  11.169  24.769  1.00 69.38           N  
ATOM    641  CA  THR    79     -16.302   9.900  24.417  1.00 69.80           C  
ATOM    642  C   THR    79     -15.089   9.708  25.342  1.00 71.24           C  
ATOM    643  O   THR    79     -14.815  10.525  26.225  1.00 71.66           O  
ATOM    644  CB  THR    79     -15.882   9.878  22.934  1.00 69.96           C  
ATOM    645  OG1 THR    79     -14.634  10.563  22.764  1.00 69.81           O  
ATOM    646  CG2 THR    79     -16.962  10.518  22.057  1.00 67.37           C  
ATOM    647  N   HIS    80     -14.357   8.624  25.156  1.00 72.15           N  
ATOM    648  CA  HIS    80     -13.262   8.321  26.067  1.00 72.09           C  
ATOM    649  C   HIS    80     -12.036   9.199  25.796  1.00 71.66           C  
ATOM    650  O   HIS    80     -11.197   9.380  26.680  1.00 71.54           O  
ATOM    651  CB  HIS    80     -12.905   6.838  25.952  1.00 74.54           C  
ATOM    652  CG  HIS    80     -12.424   6.435  24.588  1.00 77.71           C  
ATOM    653  ND1 HIS    80     -11.076   6.276  24.288  1.00 83.05           N  
ATOM    654  CD2 HIS    80     -13.105   6.163  23.443  1.00 82.06           C  
ATOM    655  CE1 HIS    80     -10.956   5.922  23.015  1.00 84.98           C  
ATOM    656  NE2 HIS    80     -12.172   5.846  22.480  1.00 84.43           N  
ATOM    657  N   SER    81     -11.942   9.770  24.582  1.00 70.35           N  
ATOM    658  CA  SER    81     -10.762  10.594  24.179  1.00 68.31           C  
ATOM    659  C   SER    81     -11.008  12.131  24.030  1.00 66.70           C  
ATOM    660  O   SER    81     -10.070  12.889  23.928  1.00 65.88           O  
ATOM    661  CB  SER    81     -10.207  10.050  22.870  1.00 67.88           C  
ATOM    662  OG  SER    81     -11.261   9.953  21.925  1.00 69.17           O  
ATOM    663  N   THR    82     -12.264  12.568  24.023  1.00 65.31           N  
ATOM    664  CA  THR    82     -12.635  13.963  23.752  1.00 63.25           C  
ATOM    665  C   THR    82     -13.548  14.516  24.859  1.00 62.65           C  
ATOM    666  O   THR    82     -14.080  13.751  25.698  1.00 62.99           O  
ATOM    667  CB  THR    82     -13.446  14.076  22.436  1.00 62.72           C  
ATOM    668  OG1 THR    82     -14.598  13.261  22.563  1.00 60.82           O  
ATOM    669  CG2 THR    82     -12.671  13.635  21.218  1.00 60.62           C  
ATOM    670  N   PHE    83     -13.745  15.848  24.839  1.00 60.99           N  
ATOM    671  CA  PHE    83     -14.822  16.516  25.603  1.00 58.92           C  
ATOM    672  C   PHE    83     -15.751  17.254  24.670  1.00 56.16           C  
ATOM    673  O   PHE    83     -15.435  17.547  23.530  1.00 54.69           O  
ATOM    674  CB  PHE    83     -14.277  17.502  26.651  1.00 59.27           C  
ATOM    675  CG  PHE    83     -13.275  16.897  27.611  1.00 59.80           C  
ATOM    676  CD1 PHE    83     -13.700  16.106  28.681  1.00 59.77           C  
ATOM    677  CD2 PHE    83     -11.904  17.127  27.454  1.00 60.92           C  
ATOM    678  CE1 PHE    83     -12.790  15.550  29.559  1.00 58.13           C  
ATOM    679  CE2 PHE    83     -10.990  16.583  28.347  1.00 59.35           C  
ATOM    680  CZ  PHE    83     -11.440  15.786  29.391  1.00 59.19           C  
ATOM    681  N   LEU    84     -16.918  17.556  25.185  1.00 53.95           N  
ATOM    682  CA  LEU    84     -17.848  18.373  24.479  1.00 53.17           C  
ATOM    683  C   LEU    84     -18.238  19.442  25.469  1.00 51.78           C  
ATOM    684  O   LEU    84     -18.518  19.129  26.641  1.00 52.43           O  
ATOM    685  CB  LEU    84     -19.058  17.527  24.077  1.00 53.53           C  
ATOM    686  CG  LEU    84     -19.986  17.984  23.007  1.00 53.39           C  
ATOM    687  CD1 LEU    84     -19.198  18.656  21.855  1.00 52.65           C  
ATOM    688  CD2 LEU    84     -20.822  16.736  22.567  1.00 53.10           C  
ATOM    689  N   LEU    85     -18.202  20.699  25.019  1.00 49.78           N  
ATOM    690  CA  LEU    85     -18.481  21.845  25.874  1.00 47.93           C  
ATOM    691  C   LEU    85     -19.883  22.320  25.598  1.00 47.39           C  
ATOM    692  O   LEU    85     -20.253  22.639  24.491  1.00 46.54           O  
ATOM    693  CB  LEU    85     -17.478  22.989  25.620  1.00 47.12           C  
ATOM    694  CG  LEU    85     -15.994  22.593  25.581  1.00 45.60           C  
ATOM    695  CD1 LEU    85     -15.078  23.803  25.371  1.00 36.85           C  
ATOM    696  CD2 LEU    85     -15.635  21.783  26.820  1.00 43.69           C  
ATOM    697  N   SER    86     -20.664  22.376  26.648  1.00 47.97           N  
ATOM    698  CA  SER    86     -21.970  23.000  26.640  1.00 48.07           C  
ATOM    699  C   SER    86     -21.781  24.472  26.939  1.00 45.91           C  
ATOM    700  O   SER    86     -21.316  24.814  28.027  1.00 45.30           O  
ATOM    701  CB  SER    86     -22.819  22.353  27.758  1.00 49.42           C  
ATOM    702  OG  SER    86     -24.209  22.619  27.619  1.00 55.91           O  
ATOM    703  N   MET    87     -22.133  25.339  25.988  1.00 44.13           N  
ATOM    704  CA  MET    87     -22.013  26.758  26.179  1.00 43.18           C  
ATOM    705  C   MET    87     -23.277  27.327  26.847  1.00 44.86           C  
ATOM    706  O   MET    87     -24.316  26.668  26.840  1.00 46.03           O  
ATOM    707  CB  MET    87     -21.706  27.472  24.867  1.00 42.05           C  
ATOM    708  CG  MET    87     -20.544  26.909  24.091  1.00 39.14           C  
ATOM    709  SD  MET    87     -18.853  26.839  25.025  0.65 32.51          SE  
ATOM    710  CE  MET    87     -18.588  28.706  25.170  1.00 25.61           C  
ATOM    711  N   ASP    88     -23.161  28.530  27.421  1.00 45.01           N  
ATOM    712  CA  ASP    88     -24.228  29.167  28.115  1.00 46.81           C  
ATOM    713  C   ASP    88     -25.432  29.481  27.224  1.00 47.90           C  
ATOM    714  O   ASP    88     -26.553  29.445  27.691  1.00 49.37           O  
ATOM    715  CB  ASP    88     -23.747  30.512  28.706  1.00 47.48           C  
ATOM    716  CG  ASP    88     -23.081  30.369  30.055  1.00 47.38           C  
ATOM    717  OD1 ASP    88     -23.214  29.307  30.694  1.00 48.80           O  
ATOM    718  OD2 ASP    88     -22.425  31.343  30.484  1.00 50.10           O  
ATOM    719  N   ASN    89     -25.211  29.867  25.973  1.00 48.07           N  
ATOM    720  CA  ASN    89     -26.304  30.126  25.034  1.00 47.90           C  
ATOM    721  C   ASN    89     -26.907  28.853  24.347  1.00 49.95           C  
ATOM    722  O   ASN    89     -27.642  28.968  23.413  1.00 50.38           O  
ATOM    723  CB  ASN    89     -25.798  31.069  23.958  1.00 45.44           C  
ATOM    724  CG  ASN    89     -24.879  30.381  22.963  1.00 39.40           C  
ATOM    725  OD1 ASN    89     -24.424  29.257  23.175  1.00 34.26           O  
ATOM    726  ND2 ASN    89     -24.603  31.048  21.883  1.00 29.72           N  
ATOM    727  N   GLY    90     -26.542  27.654  24.776  1.00 53.52           N  
ATOM    728  CA  GLY    90     -27.030  26.399  24.204  1.00 54.20           C  
ATOM    729  C   GLY    90     -26.150  25.776  23.133  1.00 56.18           C  
ATOM    730  O   GLY    90     -26.474  24.680  22.628  1.00 57.36           O  
ATOM    731  N   GLU    91     -25.073  26.457  22.720  1.00 56.93           N  
ATOM    732  CA  GLU    91     -24.254  25.886  21.631  1.00 56.95           C  
ATOM    733  C   GLU    91     -23.350  24.827  22.213  1.00 57.61           C  
ATOM    734  O   GLU    91     -23.290  24.685  23.431  1.00 58.02           O  
ATOM    735  CB  GLU    91     -23.433  26.916  20.890  1.00 56.78           C  
ATOM    736  CG  GLU    91     -24.264  28.017  20.270  1.00 57.08           C  
ATOM    737  CD  GLU    91     -23.401  28.924  19.417  1.00 57.47           C  
ATOM    738  OE1 GLU    91     -23.367  30.121  19.688  1.00 58.86           O  
ATOM    739  OE2 GLU    91     -22.730  28.435  18.479  1.00 59.86           O  
ATOM    740  N   ARG    92     -22.687  24.057  21.356  1.00 57.41           N  
ATOM    741  CA  ARG    92     -21.666  23.125  21.835  1.00 57.56           C  
ATOM    742  C   ARG    92     -20.394  23.313  21.051  1.00 56.61           C  
ATOM    743  O   ARG    92     -20.410  23.760  19.911  1.00 55.30           O  
ATOM    744  CB  ARG    92     -22.124  21.647  21.825  1.00 57.51           C  
ATOM    745  CG  ARG    92     -22.418  21.066  20.425  1.00 58.70           C  
ATOM    746  CD  ARG    92     -22.994  19.651  20.473  1.00 57.48           C  
ATOM    747  NE  ARG    92     -24.233  19.646  21.242  1.00 59.27           N  
ATOM    748  CZ  ARG    92     -25.438  19.980  20.770  1.00 57.86           C  
ATOM    749  NH1 ARG    92     -25.613  20.330  19.505  1.00 59.25           N  
ATOM    750  NH2 ARG    92     -26.483  19.936  21.573  1.00 52.87           N  
ATOM    751  N   VAL    93     -19.289  22.972  21.689  1.00 57.11           N  
ATOM    752  CA  VAL    93     -17.965  23.112  21.087  1.00 57.84           C  
ATOM    753  C   VAL    93     -17.180  21.874  21.437  1.00 58.17           C  
ATOM    754  O   VAL    93     -17.187  21.457  22.599  1.00 58.56           O  
ATOM    755  CB  VAL    93     -17.239  24.386  21.619  1.00 58.64           C  
ATOM    756  CG1 VAL    93     -15.810  24.448  21.084  1.00 58.11           C  
ATOM    757  CG2 VAL    93     -18.051  25.676  21.270  1.00 55.82           C  
ATOM    758  N   PRO    94     -16.515  21.252  20.444  1.00 58.02           N  
ATOM    759  CA  PRO    94     -15.689  20.114  20.763  1.00 57.04           C  
ATOM    760  C   PRO    94     -14.266  20.415  21.276  1.00 56.72           C  
ATOM    761  O   PRO    94     -13.595  21.314  20.812  1.00 55.21           O  
ATOM    762  CB  PRO    94     -15.623  19.371  19.431  1.00 56.88           C  
ATOM    763  CG  PRO    94     -15.728  20.410  18.407  1.00 56.55           C  
ATOM    764  CD  PRO    94     -16.513  21.540  18.998  1.00 58.06           C  
ATOM    765  N   VAL    95     -13.806  19.590  22.216  1.00 57.49           N  
ATOM    766  CA  VAL    95     -12.400  19.496  22.558  1.00 57.43           C  
ATOM    767  C   VAL    95     -11.897  18.200  21.906  1.00 57.84           C  
ATOM    768  O   VAL    95     -12.341  17.103  22.256  1.00 58.08           O  
ATOM    769  CB  VAL    95     -12.138  19.493  24.114  1.00 57.16           C  
ATOM    770  CG1 VAL    95     -10.658  19.644  24.393  1.00 56.72           C  
ATOM    771  CG2 VAL    95     -12.952  20.582  24.824  1.00 55.41           C  
ATOM    772  N   SER    96     -10.987  18.327  20.944  1.00 58.18           N  
ATOM    773  CA  SER    96     -10.524  17.194  20.222  1.00 57.67           C  
ATOM    774  C   SER    96      -9.576  16.357  21.065  1.00 59.98           C  
ATOM    775  O   SER    96      -9.000  16.821  22.069  1.00 61.04           O  
ATOM    776  CB  SER    96      -9.863  17.634  18.932  1.00 57.68           C  
ATOM    777  OG  SER    96      -8.690  18.397  19.113  1.00 54.88           O  
ATOM    778  N   GLN    97      -9.437  15.100  20.663  1.00 62.13           N  
ATOM    779  CA  GLN    97      -8.498  14.165  21.247  1.00 63.68           C  
ATOM    780  C   GLN    97      -7.093  14.711  21.379  1.00 63.20           C  
ATOM    781  O   GLN    97      -6.396  14.355  22.310  1.00 63.88           O  
ATOM    782  CB  GLN    97      -8.426  12.893  20.401  1.00 63.98           C  
ATOM    783  CG  GLN    97      -7.315  11.913  20.765  1.00 65.68           C  
ATOM    784  CD  GLN    97      -7.566  10.570  20.093  1.00 69.25           C  
ATOM    785  OE1 GLN    97      -7.594   9.510  20.746  1.00 77.40           O  
ATOM    786  NE2 GLN    97      -7.790  10.611  18.775  1.00 77.67           N  
ATOM    787  N   SER    98      -6.677  15.555  20.444  1.00 62.68           N  
ATOM    788  CA  SER    98      -5.321  15.990  20.399  1.00 62.54           C  
ATOM    789  C   SER    98      -5.065  17.182  21.349  1.00 62.49           C  
ATOM    790  O   SER    98      -3.925  17.399  21.797  1.00 63.19           O  
ATOM    791  CB  SER    98      -4.908  16.235  18.949  1.00 62.74           C  
ATOM    792  OG  SER    98      -4.721  17.590  18.659  1.00 66.44           O  
ATOM    793  N   TYR    99      -6.130  17.908  21.684  1.00 61.58           N  
ATOM    794  CA  TYR    99      -6.099  18.982  22.674  1.00 60.92           C  
ATOM    795  C   TYR    99      -6.635  18.599  24.064  1.00 60.08           C  
ATOM    796  O   TYR    99      -6.529  19.379  25.015  1.00 60.11           O  
ATOM    797  CB  TYR    99      -6.913  20.160  22.157  1.00 60.45           C  
ATOM    798  CG  TYR    99      -6.178  20.969  21.133  1.00 61.16           C  
ATOM    799  CD1 TYR    99      -6.142  20.577  19.804  1.00 61.60           C  
ATOM    800  CD2 TYR    99      -5.482  22.103  21.496  1.00 59.09           C  
ATOM    801  CE1 TYR    99      -5.481  21.325  18.881  1.00 61.32           C  
ATOM    802  CE2 TYR    99      -4.860  22.840  20.583  1.00 59.27           C  
ATOM    803  CZ  TYR    99      -4.861  22.464  19.287  1.00 60.11           C  
ATOM    804  OH  TYR    99      -4.169  23.214  18.389  1.00 62.07           O  
ATOM    805  N   ALA   100      -7.203  17.414  24.189  1.00 59.50           N  
ATOM    806  CA  ALA   100      -7.931  17.070  25.399  1.00 59.34           C  
ATOM    807  C   ALA   100      -7.050  17.117  26.668  1.00 59.43           C  
ATOM    808  O   ALA   100      -7.522  17.572  27.707  1.00 58.27           O  
ATOM    809  CB  ALA   100      -8.656  15.714  25.226  1.00 57.93           C  
ATOM    810  N   SER   101      -5.774  16.692  26.594  1.00 60.28           N  
ATOM    811  CA  SER   101      -4.890  16.751  27.798  1.00 60.88           C  
ATOM    812  C   SER   101      -4.494  18.138  28.204  1.00 60.03           C  
ATOM    813  O   SER   101      -4.503  18.456  29.387  1.00 60.35           O  
ATOM    814  CB  SER   101      -3.608  15.932  27.633  1.00 61.76           C  
ATOM    815  OG  SER   101      -3.970  14.573  27.408  1.00 65.08           O  
ATOM    816  N   TYR   102      -4.134  18.944  27.213  1.00 59.68           N  
ATOM    817  CA  TYR   102      -3.797  20.350  27.403  1.00 59.73           C  
ATOM    818  C   TYR   102      -5.014  21.030  27.984  1.00 59.63           C  
ATOM    819  O   TYR   102      -4.918  21.703  28.992  1.00 59.77           O  
ATOM    820  CB  TYR   102      -3.347  20.956  26.057  1.00 60.33           C  
ATOM    821  CG  TYR   102      -3.183  22.451  25.981  1.00 60.01           C  
ATOM    822  CD1 TYR   102      -2.045  23.086  26.447  1.00 60.73           C  
ATOM    823  CD2 TYR   102      -4.178  23.235  25.376  1.00 62.93           C  
ATOM    824  CE1 TYR   102      -1.932  24.485  26.353  1.00 61.97           C  
ATOM    825  CE2 TYR   102      -4.077  24.605  25.265  1.00 60.78           C  
ATOM    826  CZ  TYR   102      -2.961  25.230  25.733  1.00 61.47           C  
ATOM    827  OH  TYR   102      -2.924  26.614  25.611  1.00 61.28           O  
ATOM    828  N   PHE   103      -6.186  20.787  27.401  1.00 58.87           N  
ATOM    829  CA  PHE   103      -7.393  21.423  27.906  1.00 58.44           C  
ATOM    830  C   PHE   103      -7.610  21.102  29.395  1.00 58.43           C  
ATOM    831  O   PHE   103      -7.761  21.995  30.191  1.00 57.76           O  
ATOM    832  CB  PHE   103      -8.614  21.024  27.056  1.00 57.19           C  
ATOM    833  CG  PHE   103      -9.893  21.695  27.462  1.00 57.46           C  
ATOM    834  CD1 PHE   103     -10.193  22.988  27.016  1.00 58.39           C  
ATOM    835  CD2 PHE   103     -10.785  21.066  28.302  1.00 54.61           C  
ATOM    836  CE1 PHE   103     -11.359  23.605  27.359  1.00 54.93           C  
ATOM    837  CE2 PHE   103     -11.956  21.670  28.670  1.00 53.26           C  
ATOM    838  CZ  PHE   103     -12.261  22.937  28.187  1.00 55.72           C  
ATOM    839  N   ARG   104      -7.637  19.834  29.774  1.00 59.22           N  
ATOM    840  CA  ARG   104      -7.950  19.494  31.162  1.00 60.00           C  
ATOM    841  C   ARG   104      -6.859  19.893  32.152  1.00 60.47           C  
ATOM    842  O   ARG   104      -7.148  20.233  33.297  1.00 59.73           O  
ATOM    843  CB  ARG   104      -8.299  18.011  31.298  1.00 59.80           C  
ATOM    844  CG  ARG   104      -7.128  17.081  31.373  1.00 59.77           C  
ATOM    845  CD  ARG   104      -7.547  15.631  31.419  1.00 59.52           C  
ATOM    846  NE  ARG   104      -8.482  15.391  32.508  1.00 59.77           N  
ATOM    847  CZ  ARG   104      -9.353  14.386  32.582  1.00 60.33           C  
ATOM    848  NH1 ARG   104      -9.450  13.478  31.628  1.00 61.97           N  
ATOM    849  NH2 ARG   104     -10.167  14.309  33.614  1.00 62.23           N  
ATOM    850  N   LYS   105      -5.604  19.865  31.698  1.00 62.10           N  
ATOM    851  CA  LYS   105      -4.470  20.312  32.517  1.00 63.34           C  
ATOM    852  C   LYS   105      -4.582  21.811  32.887  1.00 62.97           C  
ATOM    853  O   LYS   105      -4.444  22.184  34.047  1.00 62.68           O  
ATOM    854  CB  LYS   105      -3.128  20.027  31.812  1.00 64.24           C  
ATOM    855  CG  LYS   105      -2.427  18.736  32.260  1.00 66.61           C  
ATOM    856  CD  LYS   105      -1.311  18.291  31.238  1.00 68.13           C  
ATOM    857  CE  LYS   105      -0.252  17.240  31.780  1.00 70.28           C  
ATOM    858  NZ  LYS   105       1.029  17.832  32.420  1.00 70.83           N  
ATOM    859  N   LEU   106      -4.834  22.641  31.883  1.00 62.79           N  
ATOM    860  CA  LEU   106      -4.997  24.068  32.057  1.00 63.04           C  
ATOM    861  C   LEU   106      -6.188  24.423  32.910  1.00 62.22           C  
ATOM    862  O   LEU   106      -6.162  25.437  33.602  1.00 62.09           O  
ATOM    863  CB  LEU   106      -5.076  24.795  30.700  1.00 62.74           C  
ATOM    864  CG  LEU   106      -3.709  25.365  30.317  1.00 64.99           C  
ATOM    865  CD1 LEU   106      -2.561  24.315  30.481  1.00 67.46           C  
ATOM    866  CD2 LEU   106      -3.670  25.949  28.926  1.00 64.48           C  
ATOM    867  N   LEU   107      -7.233  23.619  32.843  1.00 61.85           N  
ATOM    868  CA  LEU   107      -8.463  23.878  33.588  1.00 61.64           C  
ATOM    869  C   LEU   107      -8.471  23.158  34.946  1.00 60.91           C  
ATOM    870  O   LEU   107      -9.338  23.387  35.776  1.00 60.53           O  
ATOM    871  CB  LEU   107      -9.697  23.514  32.736  1.00 61.95           C  
ATOM    872  CG  LEU   107     -10.266  24.672  31.899  1.00 65.01           C  
ATOM    873  CD1 LEU   107      -9.536  24.876  30.576  1.00 66.58           C  
ATOM    874  CD2 LEU   107     -11.706  24.443  31.610  1.00 62.97           C  
ATOM    875  N   GLY   108      -7.511  22.273  35.159  1.00 61.07           N  
ATOM    876  CA  GLY   108      -7.292  21.663  36.452  1.00 61.13           C  
ATOM    877  C   GLY   108      -8.218  20.536  36.869  1.00 61.63           C  
ATOM    878  O   GLY   108      -8.499  20.447  38.068  1.00 62.09           O  
ATOM    879  N   PHE   109      -8.649  19.662  35.931  1.00 60.70           N  
ATOM    880  CA  PHE   109      -9.548  18.522  36.261  1.00 60.08           C  
ATOM    881  C   PHE   109      -9.140  17.140  35.727  1.00 59.62           C  
ATOM    882  O   PHE   109      -8.160  17.063  34.987  1.00 61.02           O  
ATOM    883  CB  PHE   109     -10.971  18.842  35.853  1.00 59.83           C  
ATOM    884  CG  PHE   109     -11.195  18.905  34.371  1.00 58.91           C  
ATOM    885  CD1 PHE   109     -11.609  17.796  33.678  1.00 57.22           C  
ATOM    886  CD2 PHE   109     -11.047  20.087  33.688  1.00 57.96           C  
ATOM    887  CE1 PHE   109     -11.843  17.866  32.347  1.00 59.48           C  
ATOM    888  CE2 PHE   109     -11.274  20.147  32.342  1.00 57.93           C  
ATOM    889  CZ  PHE   109     -11.683  19.047  31.674  1.00 59.32           C  
END
