
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 2310),  selected  150 , name 1wg7_A
# Molecule2: number of CA atoms  109 (  889),  selected  109 , name T0415.pdb
# PARAMETERS: 1wg7_A.T0415.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    A     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    S    10_A      -       -           -
LGA    L    11_A      -       -           -
LGA    G    12_A      G       1           #
LGA    S    13_A      K       2           -
LGA    Q    14_A      S       3           -
LGA    K    15_A      V       4           -
LGA    G    16_A      V       5           -
LGA    G    17_A      T       6           -
LGA    I    18_A      L       7           -
LGA    T    19_A      K       8           -
LGA    K    20_A      T       9           -
LGA    H    21_A      T      10           -
LGA    G    22_A      D      11           -
LGA    W    23_A      G      12           -
LGA    L    24_A      W      13           -
LGA    Y    25_A      I      14           -
LGA    K    26_A      P      15           -
LGA    G    27_A      V      16           -
LGA    N    28_A      P      17           -
LGA    M    29_A      F      18           -
LGA    N    30_A      S      19           -
LGA    S    31_A      K      20           -
LGA    A    32_A      V      21           -
LGA    I    33_A      M      22           -
LGA    S    34_A      Y      23           -
LGA    V    35_A      L      24           -
LGA    T    36_A      E      25           -
LGA    M    37_A      A      26           -
LGA    R    38_A      K      27           -
LGA    S    39_A      D      28           -
LGA    F    40_A      K      29           -
LGA    K    41_A      K      30           -
LGA    R    42_A      T      31           -
LGA    R    43_A      Y      32           -
LGA    -       -      V      33           -
LGA    -       -      N      34           -
LGA    -       -      A      35           -
LGA    -       -      E      36           -
LGA    -       -      E      37           -
LGA    -       -      L      38           -
LGA    -       -      T      39           -
LGA    -       -      G      40           -
LGA    -       -      T      41           -
LGA    -       -      H      42           -
LGA    -       -      K      43           -
LGA    -       -      Y      44           -
LGA    F    44_A      S      45           #
LGA    F    45_A      L      46           #
LGA    -       -      Q      47           -
LGA    -       -      E      48           -
LGA    H    46_A      F      49           #
LGA    L    47_A      E      50          5.014
LGA    -       -      Y      51           -
LGA    -       -      L      52           -
LGA    I    48_A      L      53          4.302
LGA    Q    49_A      P      54          1.408
LGA    L    50_A      K      55           #
LGA    G    51_A      -       -           -
LGA    D    52_A      -       -           -
LGA    G    53_A      -       -           -
LGA    S    54_A      D      56          4.228
LGA    Y    55_A      S      57          1.480
LGA    N    56_A      F      58          1.294
LGA    L    57_A      I      59          2.465
LGA    N    58_A      R      60          4.392
LGA    -       -      C      61           -
LGA    F    59_A      H      62           #
LGA    Y    60_A      R      63          5.382
LGA    K    61_A      -       -           -
LGA    D    62_A      -       -           -
LGA    E    63_A      -       -           -
LGA    K    64_A      -       -           -
LGA    I    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    K    67_A      -       -           -
LGA    E    68_A      -       -           -
LGA    P    69_A      -       -           -
LGA    K    70_A      S      64          5.297
LGA    G    71_A      F      65          4.783
LGA    S    72_A      I      66          3.189
LGA    I    73_A      V      67          1.516
LGA    F    74_A      N      68          1.861
LGA    L    75_A      V      69          1.357
LGA    D    76_A      N      70          1.298
LGA    S    77_A      H      71          0.975
LGA    C    78_A      I      72          1.015
LGA    M    79_A      K      73          2.237
LGA    G    80_A      A      74          3.240
LGA    V    81_A      I      75          1.973
LGA    V    82_A      Y      76          1.386
LGA    Q    83_A      P      77          0.598
LGA    N    84_A      D      78          1.188
LGA    N    85_A      T      79          1.506
LGA    K    86_A      -       -           -
LGA    V    87_A      -       -           -
LGA    R    88_A      -       -           -
LGA    R    89_A      H      80          3.239
LGA    F    90_A      S      81          0.374
LGA    A    91_A      T      82          1.074
LGA    F    92_A      F      83          0.894
LGA    E    93_A      L      84          0.825
LGA    L    94_A      L      85          1.094
LGA    K    95_A      S      86          1.798
LGA    M    96_A      M      87          1.349
LGA    Q    97_A      D      88          0.935
LGA    D    98_A      N      89          2.145
LGA    K    99_A      G      90          1.355
LGA    S   100_A      E      91          1.121
LGA    S   101_A      R      92          1.364
LGA    Y   102_A      V      93          1.162
LGA    L   103_A      P      94          1.895
LGA    L   104_A      V      95          1.604
LGA    A   105_A      S      96          2.265
LGA    A   106_A      Q      97          1.675
LGA    D   107_A      S      98          4.065
LGA    S   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    V   110_A      -       -           -
LGA    E   111_A      Y      99           #
LGA    M   112_A      A     100          2.630
LGA    E   113_A      S     101          3.635
LGA    E   114_A      Y     102          3.618
LGA    W   115_A      F     103          1.286
LGA    I   116_A      R     104          2.257
LGA    T   117_A      K     105          3.411
LGA    I   118_A      L     106          2.059
LGA    L   119_A      L     107          3.735
LGA    N   120_A      -       -           -
LGA    K   121_A      G     108          4.172
LGA    I   122_A      -       -           -
LGA    L   123_A      -       -           -
LGA    Q   124_A      F     109           #
LGA    L   125_A      -       -           -
LGA    N   126_A      -       -           -
LGA    F   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    A   129_A      -       -           -
LGA    A   130_A      -       -           -
LGA    M   131_A      -       -           -
LGA    Q   132_A      -       -           -
LGA    E   133_A      -       -           -
LGA    K   134_A      -       -           -
LGA    R   135_A      -       -           -
LGA    N   136_A      -       -           -
LGA    G   137_A      -       -           -
LGA    D   138_A      -       -           -
LGA    S   139_A      -       -           -
LGA    H   140_A      -       -           -
LGA    E   141_A      -       -           -
LGA    D   142_A      -       -           -
LGA    D   143_A      -       -           -
LGA    E   144_A      -       -           -
LGA    S   145_A      -       -           -
LGA    G   146_A      -       -           -
LGA    P   147_A      -       -           -
LGA    S   148_A      -       -           -
LGA    S   149_A      -       -           -
LGA    G   150_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150  109    5.0     53    2.64     7.55     37.252     1.936

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.797947 * X  +  -0.016735 * Y  +  -0.602496 * Z  +  -9.159630
  Y_new =  -0.385286 * X  +   0.782875 * Y  +   0.488529 * Z  +  28.089628
  Z_new =   0.463503 * X  +   0.621953 * Y  +  -0.631141 * Z  +  31.867111 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.363526   -0.778067  [ DEG:   135.4201    -44.5799 ]
  Theta =  -0.481945   -2.659648  [ DEG:   -27.6134   -152.3866 ]
  Phi   =  -2.691761    0.449832  [ DEG:  -154.2265     25.7734 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wg7_A                                        
REMARK     2: T0415.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wg7_A.T0415.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150  109   5.0   53   2.64    7.55  37.252
REMARK  ---------------------------------------------------------- 
MOLECULE 1wg7_A
HEADER    SIGNALING PROTEIN                       27-MAY-04   1WG7              
TITLE     SOLUTION STRUCTURE OF PLECKSTRIN HOMOLOGY DOMAIN FROM HUMAN           
TITLE    2 KIAA1058 PROTEIN                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEDICATOR OF CYTOKINESIS PROTEIN 9;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PH DOMAIN;                                                 
COMPND   5 SYNONYM: KIAA1058 PROTEIN, CDC42 GUANINE NUCLEOTIDE                  
COMPND   6 EXCHANGE FACTOR ZIZIMIN 1;                                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA HH12146S1;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P030428-80;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    PLECKSTRIN HOMOLOGY DOMAIN, ZIZIMIN1, STRUCTURAL GENOMICS,            
KEYWDS   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.SUETAKE,K.INOUE,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL               
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   27-NOV-04 1WG7    0                                                
JRNL        AUTH   T.SUETAKE,K.INOUE,F.HAYASHI,S.YOKOYAMA                       
JRNL        TITL   SOLUTION STRUCTURE OF PLECKSTRIN HOMOLOGY DOMAIN             
JRNL        TITL 2 FROM HUMAN KIAA1058 PROTEIN                                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WG7 A    8   144  UNP    Q9BZ29   DOCK9_HUMAN    165    301             
SEQRES   1 A  150  GLY SER SER GLY SER SER GLY ALA ALA SER LEU GLY SER          
SEQRES   2 A  150  GLN LYS GLY GLY ILE THR LYS HIS GLY TRP LEU TYR LYS          
SEQRES   3 A  150  GLY ASN MET ASN SER ALA ILE SER VAL THR MET ARG SER          
SEQRES   4 A  150  PHE LYS ARG ARG PHE PHE HIS LEU ILE GLN LEU GLY ASP          
SEQRES   5 A  150  GLY SER TYR ASN LEU ASN PHE TYR LYS ASP GLU LYS ILE          
SEQRES   6 A  150  SER LYS GLU PRO LYS GLY SER ILE PHE LEU ASP SER CYS          
SEQRES   7 A  150  MET GLY VAL VAL GLN ASN ASN LYS VAL ARG ARG PHE ALA          
SEQRES   8 A  150  PHE GLU LEU LYS MET GLN ASP LYS SER SER TYR LEU LEU          
SEQRES   9 A  150  ALA ALA ASP SER GLU VAL GLU MET GLU GLU TRP ILE THR          
SEQRES  10 A  150  ILE LEU ASN LYS ILE LEU GLN LEU ASN PHE GLU ALA ALA          
SEQRES  11 A  150  MET GLN GLU LYS ARG ASN GLY ASP SER HIS GLU ASP ASP          
SEQRES  12 A  150  GLU SER GLY PRO SER SER GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -22.117  65.719  21.219  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -21.126  64.672  21.034  1.00  0.00           C  
ATOM      3  C   GLY A   1     -21.714  63.492  20.258  1.00  0.00           C  
ATOM      4  O   GLY A   1     -22.431  63.684  19.277  1.00  0.00           O  
ATOM      5  HA2 GLY A   1     -20.266  65.072  20.499  1.00  0.00           H  
ATOM      6  HA3 GLY A   1     -20.767  64.331  22.006  1.00  0.00           H  
ATOM      7  H1  GLY A   1     -23.065  65.431  21.084  1.00  0.00           H  
ATOM      8  N   SER A   2     -21.389  62.296  20.726  1.00  0.00           N  
ATOM      9  CA  SER A   2     -21.876  61.084  20.089  1.00  0.00           C  
ATOM     10  C   SER A   2     -22.179  60.022  21.147  1.00  0.00           C  
ATOM     11  O   SER A   2     -23.311  59.553  21.255  1.00  0.00           O  
ATOM     12  CB  SER A   2     -20.861  60.549  19.076  1.00  0.00           C  
ATOM     13  OG  SER A   2     -20.872  61.300  17.864  1.00  0.00           O  
ATOM     14  H   SER A   2     -20.805  62.148  21.525  1.00  0.00           H  
ATOM     15  HA  SER A   2     -22.787  61.378  19.569  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -19.863  60.580  19.512  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -21.083  59.506  18.858  1.00  0.00           H  
ATOM     18  HG  SER A   2     -21.660  61.914  17.849  1.00  0.00           H  
ATOM     19  N   SER A   3     -21.148  59.672  21.902  1.00  0.00           N  
ATOM     20  CA  SER A   3     -21.290  58.673  22.948  1.00  0.00           C  
ATOM     21  C   SER A   3     -19.951  58.466  23.659  1.00  0.00           C  
ATOM     22  O   SER A   3     -18.917  58.942  23.194  1.00  0.00           O  
ATOM     23  CB  SER A   3     -21.799  57.348  22.377  1.00  0.00           C  
ATOM     24  OG  SER A   3     -23.119  57.049  22.822  1.00  0.00           O  
ATOM     25  H   SER A   3     -20.230  60.059  21.808  1.00  0.00           H  
ATOM     26  HA  SER A   3     -22.030  59.080  23.636  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -21.783  57.392  21.289  1.00  0.00           H  
ATOM     28  HB3 SER A   3     -21.125  56.544  22.674  1.00  0.00           H  
ATOM     29  HG  SER A   3     -23.777  57.653  22.373  1.00  0.00           H  
ATOM     30  N   GLY A   4     -20.015  57.755  24.775  1.00  0.00           N  
ATOM     31  CA  GLY A   4     -18.821  57.480  25.556  1.00  0.00           C  
ATOM     32  C   GLY A   4     -18.989  57.950  27.001  1.00  0.00           C  
ATOM     33  O   GLY A   4     -19.536  59.024  27.249  1.00  0.00           O  
ATOM     34  H   GLY A   4     -20.860  57.372  25.146  1.00  0.00           H  
ATOM     35  HA2 GLY A   4     -18.611  56.410  25.540  1.00  0.00           H  
ATOM     36  HA3 GLY A   4     -17.963  57.980  25.104  1.00  0.00           H  
ATOM     37  N   SER A   5     -18.508  57.124  27.918  1.00  0.00           N  
ATOM     38  CA  SER A   5     -18.599  57.443  29.333  1.00  0.00           C  
ATOM     39  C   SER A   5     -17.197  57.538  29.939  1.00  0.00           C  
ATOM     40  O   SER A   5     -16.768  56.641  30.663  1.00  0.00           O  
ATOM     41  CB  SER A   5     -19.429  56.398  30.081  1.00  0.00           C  
ATOM     42  OG  SER A   5     -18.768  55.137  30.149  1.00  0.00           O  
ATOM     43  H   SER A   5     -18.064  56.254  27.709  1.00  0.00           H  
ATOM     44  HA  SER A   5     -19.103  58.408  29.380  1.00  0.00           H  
ATOM     45  HB2 SER A   5     -19.636  56.754  31.091  1.00  0.00           H  
ATOM     46  HB3 SER A   5     -20.391  56.276  29.584  1.00  0.00           H  
ATOM     47  HG  SER A   5     -19.118  54.529  29.437  1.00  0.00           H  
ATOM     48  N   SER A   6     -16.523  58.634  29.621  1.00  0.00           N  
ATOM     49  CA  SER A   6     -15.179  58.858  30.125  1.00  0.00           C  
ATOM     50  C   SER A   6     -14.387  57.549  30.106  1.00  0.00           C  
ATOM     51  O   SER A   6     -14.175  56.933  31.149  1.00  0.00           O  
ATOM     52  CB  SER A   6     -15.211  59.440  31.540  1.00  0.00           C  
ATOM     53  OG  SER A   6     -14.059  60.231  31.818  1.00  0.00           O  
ATOM     54  H   SER A   6     -16.880  59.358  29.031  1.00  0.00           H  
ATOM     55  HA  SER A   6     -14.734  59.585  29.444  1.00  0.00           H  
ATOM     56  HB2 SER A   6     -16.107  60.048  31.662  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -15.277  58.627  32.263  1.00  0.00           H  
ATOM     58  HG  SER A   6     -13.406  59.705  32.364  1.00  0.00           H  
ATOM     59  N   GLY A   7     -13.973  57.163  28.908  1.00  0.00           N  
ATOM     60  CA  GLY A   7     -13.209  55.938  28.740  1.00  0.00           C  
ATOM     61  C   GLY A   7     -13.760  54.822  29.630  1.00  0.00           C  
ATOM     62  O   GLY A   7     -14.952  54.796  29.933  1.00  0.00           O  
ATOM     63  H   GLY A   7     -14.149  57.670  28.064  1.00  0.00           H  
ATOM     64  HA2 GLY A   7     -13.242  55.626  27.697  1.00  0.00           H  
ATOM     65  HA3 GLY A   7     -12.163  56.122  28.985  1.00  0.00           H  
ATOM     66  N   ALA A   8     -12.866  53.928  30.024  1.00  0.00           N  
ATOM     67  CA  ALA A   8     -13.246  52.812  30.873  1.00  0.00           C  
ATOM     68  C   ALA A   8     -12.255  52.698  32.033  1.00  0.00           C  
ATOM     69  O   ALA A   8     -11.424  53.582  32.233  1.00  0.00           O  
ATOM     70  CB  ALA A   8     -13.315  51.534  30.037  1.00  0.00           C  
ATOM     71  H   ALA A   8     -11.898  53.957  29.773  1.00  0.00           H  
ATOM     72  HA  ALA A   8     -14.238  53.023  31.274  1.00  0.00           H  
ATOM     73  HB1 ALA A   8     -14.101  50.886  30.426  1.00  0.00           H  
ATOM     74  HB2 ALA A   8     -13.534  51.789  29.000  1.00  0.00           H  
ATOM     75  HB3 ALA A   8     -12.358  51.014  30.088  1.00  0.00           H  
ATOM     76  N   ALA A   9     -12.376  51.601  32.767  1.00  0.00           N  
ATOM     77  CA  ALA A   9     -11.501  51.360  33.902  1.00  0.00           C  
ATOM     78  C   ALA A   9     -11.648  49.905  34.353  1.00  0.00           C  
ATOM     79  O   ALA A   9     -12.325  49.114  33.698  1.00  0.00           O  
ATOM     80  CB  ALA A   9     -11.827  52.353  35.019  1.00  0.00           C  
ATOM     81  H   ALA A   9     -13.055  50.887  32.597  1.00  0.00           H  
ATOM     82  HA  ALA A   9     -10.476  51.527  33.571  1.00  0.00           H  
ATOM     83  HB1 ALA A   9     -11.306  52.060  35.929  1.00  0.00           H  
ATOM     84  HB2 ALA A   9     -11.506  53.352  34.722  1.00  0.00           H  
ATOM     85  HB3 ALA A   9     -12.902  52.356  35.200  1.00  0.00           H  
ATOM     86  N   SER A  10     -11.004  49.597  35.469  1.00  0.00           N  
ATOM     87  CA  SER A  10     -11.055  48.253  36.016  1.00  0.00           C  
ATOM     88  C   SER A  10     -10.430  47.263  35.031  1.00  0.00           C  
ATOM     89  O   SER A  10     -10.709  46.066  35.086  1.00  0.00           O  
ATOM     90  CB  SER A  10     -12.494  47.843  36.338  1.00  0.00           C  
ATOM     91  OG  SER A  10     -12.871  48.215  37.661  1.00  0.00           O  
ATOM     92  H   SER A  10     -10.457  50.248  35.997  1.00  0.00           H  
ATOM     93  HA  SER A  10     -10.474  48.294  36.938  1.00  0.00           H  
ATOM     94  HB2 SER A  10     -13.172  48.308  35.624  1.00  0.00           H  
ATOM     95  HB3 SER A  10     -12.598  46.765  36.221  1.00  0.00           H  
ATOM     96  HG  SER A  10     -12.185  47.898  38.315  1.00  0.00           H  
ATOM     97  N   LEU A  11      -9.595  47.799  34.153  1.00  0.00           N  
ATOM     98  CA  LEU A  11      -8.928  46.979  33.157  1.00  0.00           C  
ATOM     99  C   LEU A  11      -7.485  46.722  33.598  1.00  0.00           C  
ATOM    100  O   LEU A  11      -6.738  47.662  33.869  1.00  0.00           O  
ATOM    101  CB  LEU A  11      -9.043  47.617  31.771  1.00  0.00           C  
ATOM    102  CG  LEU A  11     -10.421  47.542  31.111  1.00  0.00           C  
ATOM    103  CD1 LEU A  11     -10.581  48.632  30.049  1.00  0.00           C  
ATOM    104  CD2 LEU A  11     -10.679  46.145  30.540  1.00  0.00           C  
ATOM    105  H   LEU A  11      -9.373  48.774  34.116  1.00  0.00           H  
ATOM    106  HA  LEU A  11      -9.452  46.024  33.116  1.00  0.00           H  
ATOM    107  HB2 LEU A  11      -8.758  48.666  31.852  1.00  0.00           H  
ATOM    108  HB3 LEU A  11      -8.319  47.140  31.111  1.00  0.00           H  
ATOM    109  HG  LEU A  11     -11.176  47.722  31.875  1.00  0.00           H  
ATOM    110 HD11 LEU A  11      -9.632  48.779  29.534  1.00  0.00           H  
ATOM    111 HD12 LEU A  11     -11.343  48.330  29.331  1.00  0.00           H  
ATOM    112 HD13 LEU A  11     -10.882  49.563  30.529  1.00  0.00           H  
ATOM    113 HD21 LEU A  11     -10.347  45.393  31.257  1.00  0.00           H  
ATOM    114 HD22 LEU A  11     -11.746  46.022  30.351  1.00  0.00           H  
ATOM    115 HD23 LEU A  11     -10.128  46.026  29.608  1.00  0.00           H  
ATOM    116  N   GLY A  12      -7.136  45.445  33.655  1.00  0.00           N  
ATOM    117  CA  GLY A  12      -5.796  45.053  34.057  1.00  0.00           C  
ATOM    118  C   GLY A  12      -5.794  43.647  34.661  1.00  0.00           C  
ATOM    119  O   GLY A  12      -6.852  43.086  34.939  1.00  0.00           O  
ATOM    120  H   GLY A  12      -7.749  44.687  33.432  1.00  0.00           H  
ATOM    121  HA2 GLY A  12      -5.130  45.082  33.196  1.00  0.00           H  
ATOM    122  HA3 GLY A  12      -5.407  45.766  34.785  1.00  0.00           H  
ATOM    123  N   SER A  13      -4.593  43.119  34.847  1.00  0.00           N  
ATOM    124  CA  SER A  13      -4.440  41.790  35.413  1.00  0.00           C  
ATOM    125  C   SER A  13      -3.264  41.770  36.392  1.00  0.00           C  
ATOM    126  O   SER A  13      -2.663  42.808  36.667  1.00  0.00           O  
ATOM    127  CB  SER A  13      -4.234  40.744  34.316  1.00  0.00           C  
ATOM    128  OG  SER A  13      -5.464  40.160  33.897  1.00  0.00           O  
ATOM    129  H   SER A  13      -3.737  43.582  34.618  1.00  0.00           H  
ATOM    130  HA  SER A  13      -5.375  41.589  35.935  1.00  0.00           H  
ATOM    131  HB2 SER A  13      -3.743  41.209  33.461  1.00  0.00           H  
ATOM    132  HB3 SER A  13      -3.567  39.962  34.680  1.00  0.00           H  
ATOM    133  HG  SER A  13      -6.233  40.677  34.274  1.00  0.00           H  
ATOM    134  N   GLN A  14      -2.972  40.579  36.893  1.00  0.00           N  
ATOM    135  CA  GLN A  14      -1.879  40.411  37.835  1.00  0.00           C  
ATOM    136  C   GLN A  14      -1.370  38.969  37.806  1.00  0.00           C  
ATOM    137  O   GLN A  14      -2.102  38.055  37.431  1.00  0.00           O  
ATOM    138  CB  GLN A  14      -2.307  40.813  39.249  1.00  0.00           C  
ATOM    139  CG  GLN A  14      -1.756  42.192  39.616  1.00  0.00           C  
ATOM    140  CD  GLN A  14      -2.823  43.039  40.314  1.00  0.00           C  
ATOM    141  OE1 GLN A  14      -3.999  42.991  39.994  1.00  0.00           O  
ATOM    142  NE2 GLN A  14      -2.348  43.815  41.284  1.00  0.00           N  
ATOM    143  H   GLN A  14      -3.466  39.740  36.665  1.00  0.00           H  
ATOM    144  HA  GLN A  14      -1.095  41.087  37.493  1.00  0.00           H  
ATOM    145  HB2 GLN A  14      -3.394  40.822  39.315  1.00  0.00           H  
ATOM    146  HB3 GLN A  14      -1.951  40.072  39.964  1.00  0.00           H  
ATOM    147  HG2 GLN A  14      -0.891  42.080  40.269  1.00  0.00           H  
ATOM    148  HG3 GLN A  14      -1.414  42.703  38.717  1.00  0.00           H  
ATOM    149 HE21 GLN A  14      -1.370  43.808  41.497  1.00  0.00           H  
ATOM    150 HE22 GLN A  14      -2.967  44.407  41.801  1.00  0.00           H  
ATOM    151  N   LYS A  15      -0.117  38.808  38.207  1.00  0.00           N  
ATOM    152  CA  LYS A  15       0.499  37.493  38.231  1.00  0.00           C  
ATOM    153  C   LYS A  15       0.379  36.853  36.847  1.00  0.00           C  
ATOM    154  O   LYS A  15      -0.319  37.371  35.977  1.00  0.00           O  
ATOM    155  CB  LYS A  15      -0.098  36.643  39.354  1.00  0.00           C  
ATOM    156  CG  LYS A  15       0.988  35.828  40.061  1.00  0.00           C  
ATOM    157  CD  LYS A  15       0.413  34.536  40.643  1.00  0.00           C  
ATOM    158  CE  LYS A  15       1.140  34.142  41.931  1.00  0.00           C  
ATOM    159  NZ  LYS A  15       0.327  34.498  43.115  1.00  0.00           N  
ATOM    160  H   LYS A  15       0.473  39.557  38.510  1.00  0.00           H  
ATOM    161  HA  LYS A  15       1.556  37.630  38.458  1.00  0.00           H  
ATOM    162  HB2 LYS A  15      -0.600  37.287  40.076  1.00  0.00           H  
ATOM    163  HB3 LYS A  15      -0.853  35.972  38.946  1.00  0.00           H  
ATOM    164  HG2 LYS A  15       1.785  35.590  39.357  1.00  0.00           H  
ATOM    165  HG3 LYS A  15       1.434  36.423  40.858  1.00  0.00           H  
ATOM    166  HD2 LYS A  15      -0.650  34.667  40.848  1.00  0.00           H  
ATOM    167  HD3 LYS A  15       0.500  33.732  39.911  1.00  0.00           H  
ATOM    168  HE2 LYS A  15       1.341  33.071  41.928  1.00  0.00           H  
ATOM    169  HE3 LYS A  15       2.105  34.647  41.979  1.00  0.00           H  
ATOM    170  HZ1 LYS A  15      -0.318  33.761  43.311  1.00  0.00           H  
ATOM    171  HZ2 LYS A  15       0.929  34.632  43.903  1.00  0.00           H  
ATOM    172  HZ3 LYS A  15      -0.176  35.343  42.932  1.00  0.00           H  
ATOM    173  N   GLY A  16       1.073  35.735  36.684  1.00  0.00           N  
ATOM    174  CA  GLY A  16       1.053  35.019  35.420  1.00  0.00           C  
ATOM    175  C   GLY A  16      -0.334  34.436  35.142  1.00  0.00           C  
ATOM    176  O   GLY A  16      -1.326  35.164  35.126  1.00  0.00           O  
ATOM    177  H   GLY A  16       1.638  35.320  37.396  1.00  0.00           H  
ATOM    178  HA2 GLY A  16       1.337  35.693  34.612  1.00  0.00           H  
ATOM    179  HA3 GLY A  16       1.791  34.217  35.441  1.00  0.00           H  
ATOM    180  N   GLY A  17      -0.359  33.129  34.931  1.00  0.00           N  
ATOM    181  CA  GLY A  17      -1.608  32.440  34.653  1.00  0.00           C  
ATOM    182  C   GLY A  17      -1.350  31.026  34.128  1.00  0.00           C  
ATOM    183  O   GLY A  17      -0.318  30.427  34.429  1.00  0.00           O  
ATOM    184  H   GLY A  17       0.451  32.544  34.946  1.00  0.00           H  
ATOM    185  HA2 GLY A  17      -2.209  32.389  35.561  1.00  0.00           H  
ATOM    186  HA3 GLY A  17      -2.185  33.004  33.921  1.00  0.00           H  
ATOM    187  N   ILE A  18      -2.303  30.534  33.351  1.00  0.00           N  
ATOM    188  CA  ILE A  18      -2.193  29.203  32.780  1.00  0.00           C  
ATOM    189  C   ILE A  18      -1.988  29.315  31.268  1.00  0.00           C  
ATOM    190  O   ILE A  18      -1.761  30.407  30.749  1.00  0.00           O  
ATOM    191  CB  ILE A  18      -3.398  28.347  33.175  1.00  0.00           C  
ATOM    192  CG1 ILE A  18      -3.996  28.823  34.501  1.00  0.00           C  
ATOM    193  CG2 ILE A  18      -3.028  26.863  33.213  1.00  0.00           C  
ATOM    194  CD1 ILE A  18      -5.312  28.102  34.799  1.00  0.00           C  
ATOM    195  H   ILE A  18      -3.140  31.028  33.111  1.00  0.00           H  
ATOM    196  HA  ILE A  18      -1.309  28.734  33.214  1.00  0.00           H  
ATOM    197  HB  ILE A  18      -4.168  28.469  32.413  1.00  0.00           H  
ATOM    198 HG12 ILE A  18      -3.288  28.642  35.309  1.00  0.00           H  
ATOM    199 HG13 ILE A  18      -4.167  29.899  34.462  1.00  0.00           H  
ATOM    200 HG21 ILE A  18      -1.976  26.744  32.956  1.00  0.00           H  
ATOM    201 HG22 ILE A  18      -3.206  26.470  34.214  1.00  0.00           H  
ATOM    202 HG23 ILE A  18      -3.642  26.319  32.495  1.00  0.00           H  
ATOM    203 HD11 ILE A  18      -6.119  28.571  34.235  1.00  0.00           H  
ATOM    204 HD12 ILE A  18      -5.227  27.055  34.509  1.00  0.00           H  
ATOM    205 HD13 ILE A  18      -5.530  28.166  35.865  1.00  0.00           H  
ATOM    206  N   THR A  19      -2.077  28.173  30.604  1.00  0.00           N  
ATOM    207  CA  THR A  19      -1.905  28.130  29.162  1.00  0.00           C  
ATOM    208  C   THR A  19      -1.811  26.681  28.678  1.00  0.00           C  
ATOM    209  O   THR A  19      -1.700  25.759  29.486  1.00  0.00           O  
ATOM    210  CB  THR A  19      -0.676  28.970  28.807  1.00  0.00           C  
ATOM    211  OG1 THR A  19      -0.258  28.458  27.545  1.00  0.00           O  
ATOM    212  CG2 THR A  19       0.510  28.691  29.733  1.00  0.00           C  
ATOM    213  H   THR A  19      -2.263  27.290  31.034  1.00  0.00           H  
ATOM    214  HA  THR A  19      -2.790  28.565  28.697  1.00  0.00           H  
ATOM    215  HB  THR A  19      -0.921  30.032  28.795  1.00  0.00           H  
ATOM    216  HG1 THR A  19      -0.223  29.195  26.872  1.00  0.00           H  
ATOM    217 HG21 THR A  19       0.311  29.118  30.716  1.00  0.00           H  
ATOM    218 HG22 THR A  19       0.653  27.616  29.827  1.00  0.00           H  
ATOM    219 HG23 THR A  19       1.409  29.144  29.316  1.00  0.00           H  
ATOM    220  N   LYS A  20      -1.860  26.525  27.364  1.00  0.00           N  
ATOM    221  CA  LYS A  20      -1.782  25.205  26.763  1.00  0.00           C  
ATOM    222  C   LYS A  20      -1.964  25.326  25.250  1.00  0.00           C  
ATOM    223  O   LYS A  20      -2.682  26.205  24.775  1.00  0.00           O  
ATOM    224  CB  LYS A  20      -2.780  24.254  27.429  1.00  0.00           C  
ATOM    225  CG  LYS A  20      -2.923  22.960  26.624  1.00  0.00           C  
ATOM    226  CD  LYS A  20      -2.986  21.743  27.550  1.00  0.00           C  
ATOM    227  CE  LYS A  20      -2.373  20.513  26.879  1.00  0.00           C  
ATOM    228  NZ  LYS A  20      -1.005  20.812  26.397  1.00  0.00           N  
ATOM    229  H   LYS A  20      -1.950  27.280  26.715  1.00  0.00           H  
ATOM    230  HA  LYS A  20      -0.784  24.815  26.962  1.00  0.00           H  
ATOM    231  HB2 LYS A  20      -2.448  24.022  28.440  1.00  0.00           H  
ATOM    232  HB3 LYS A  20      -3.750  24.743  27.516  1.00  0.00           H  
ATOM    233  HG2 LYS A  20      -3.827  23.005  26.016  1.00  0.00           H  
ATOM    234  HG3 LYS A  20      -2.083  22.858  25.939  1.00  0.00           H  
ATOM    235  HD2 LYS A  20      -2.454  21.959  28.477  1.00  0.00           H  
ATOM    236  HD3 LYS A  20      -4.022  21.538  27.817  1.00  0.00           H  
ATOM    237  HE2 LYS A  20      -2.343  19.683  27.586  1.00  0.00           H  
ATOM    238  HE3 LYS A  20      -2.998  20.197  26.043  1.00  0.00           H  
ATOM    239  HZ1 LYS A  20      -0.640  21.597  26.898  1.00  0.00           H  
ATOM    240  HZ2 LYS A  20      -0.418  20.018  26.548  1.00  0.00           H  
ATOM    241  HZ3 LYS A  20      -1.036  21.024  25.421  1.00  0.00           H  
ATOM    242  N   HIS A  21      -1.301  24.431  24.532  1.00  0.00           N  
ATOM    243  CA  HIS A  21      -1.380  24.426  23.081  1.00  0.00           C  
ATOM    244  C   HIS A  21      -1.195  22.999  22.561  1.00  0.00           C  
ATOM    245  O   HIS A  21      -0.484  22.200  23.170  1.00  0.00           O  
ATOM    246  CB  HIS A  21      -0.376  25.412  22.479  1.00  0.00           C  
ATOM    247  CG  HIS A  21       1.043  25.211  22.956  1.00  0.00           C  
ATOM    248  ND1 HIS A  21       1.453  25.522  24.241  1.00  0.00           N  
ATOM    249  CD2 HIS A  21       2.141  24.728  22.307  1.00  0.00           C  
ATOM    250  CE1 HIS A  21       2.742  25.235  24.349  1.00  0.00           C  
ATOM    251  NE2 HIS A  21       3.166  24.743  23.149  1.00  0.00           N  
ATOM    252  H   HIS A  21      -0.718  23.719  24.926  1.00  0.00           H  
ATOM    253  HA  HIS A  21      -2.381  24.771  22.822  1.00  0.00           H  
ATOM    254  HB2 HIS A  21      -0.400  25.320  21.393  1.00  0.00           H  
ATOM    255  HB3 HIS A  21      -0.690  26.427  22.721  1.00  0.00           H  
ATOM    256  HD1 HIS A  21       0.875  25.898  24.964  1.00  0.00           H  
ATOM    257  HD2 HIS A  21       2.171  24.387  21.273  1.00  0.00           H  
ATOM    258  HE1 HIS A  21       3.355  25.368  25.240  1.00  0.00           H  
ATOM    259  N   GLY A  22      -1.846  22.723  21.442  1.00  0.00           N  
ATOM    260  CA  GLY A  22      -1.762  21.406  20.833  1.00  0.00           C  
ATOM    261  C   GLY A  22      -2.849  21.222  19.771  1.00  0.00           C  
ATOM    262  O   GLY A  22      -3.758  22.043  19.661  1.00  0.00           O  
ATOM    263  H   GLY A  22      -2.422  23.377  20.953  1.00  0.00           H  
ATOM    264  HA2 GLY A  22      -0.780  21.272  20.380  1.00  0.00           H  
ATOM    265  HA3 GLY A  22      -1.866  20.639  21.601  1.00  0.00           H  
ATOM    266  N   TRP A  23      -2.719  20.140  19.018  1.00  0.00           N  
ATOM    267  CA  TRP A  23      -3.678  19.839  17.969  1.00  0.00           C  
ATOM    268  C   TRP A  23      -4.805  19.007  18.584  1.00  0.00           C  
ATOM    269  O   TRP A  23      -4.568  17.910  19.088  1.00  0.00           O  
ATOM    270  CB  TRP A  23      -2.998  19.143  16.788  1.00  0.00           C  
ATOM    271  CG  TRP A  23      -1.986  20.020  16.048  1.00  0.00           C  
ATOM    272  CD1 TRP A  23      -0.845  20.540  16.519  1.00  0.00           C  
ATOM    273  CD2 TRP A  23      -2.073  20.463  14.677  1.00  0.00           C  
ATOM    274  NE1 TRP A  23      -0.191  21.281  15.555  1.00  0.00           N  
ATOM    275  CE2 TRP A  23      -0.962  21.232  14.400  1.00  0.00           C  
ATOM    276  CE3 TRP A  23      -3.058  20.220  13.703  1.00  0.00           C  
ATOM    277  CZ2 TRP A  23      -0.730  21.823  13.152  1.00  0.00           C  
ATOM    278  CZ3 TRP A  23      -2.811  20.817  12.461  1.00  0.00           C  
ATOM    279  CH2 TRP A  23      -1.697  21.595  12.166  1.00  0.00           C  
ATOM    280  H   TRP A  23      -1.977  19.477  19.115  1.00  0.00           H  
ATOM    281  HA  TRP A  23      -4.073  20.783  17.598  1.00  0.00           H  
ATOM    282  HB2 TRP A  23      -2.492  18.247  17.149  1.00  0.00           H  
ATOM    283  HB3 TRP A  23      -3.763  18.815  16.084  1.00  0.00           H  
ATOM    284  HD1 TRP A  23      -0.477  20.394  17.535  1.00  0.00           H  
ATOM    285  HE1 TRP A  23       0.755  21.808  15.678  1.00  0.00           H  
ATOM    286  HE3 TRP A  23      -3.944  19.615  13.897  1.00  0.00           H  
ATOM    287  HZ2 TRP A  23       0.156  22.427  12.958  1.00  0.00           H  
ATOM    288  HZ3 TRP A  23      -3.544  20.660  11.668  1.00  0.00           H  
ATOM    289  HH2 TRP A  23      -1.578  22.025  11.172  1.00  0.00           H  
ATOM    290  N   LEU A  24      -6.007  19.560  18.524  1.00  0.00           N  
ATOM    291  CA  LEU A  24      -7.172  18.883  19.069  1.00  0.00           C  
ATOM    292  C   LEU A  24      -8.083  18.442  17.922  1.00  0.00           C  
ATOM    293  O   LEU A  24      -7.758  18.644  16.752  1.00  0.00           O  
ATOM    294  CB  LEU A  24      -7.870  19.766  20.104  1.00  0.00           C  
ATOM    295  CG  LEU A  24      -7.576  19.442  21.570  1.00  0.00           C  
ATOM    296  CD1 LEU A  24      -8.259  20.445  22.501  1.00  0.00           C  
ATOM    297  CD2 LEU A  24      -7.964  17.998  21.899  1.00  0.00           C  
ATOM    298  H   LEU A  24      -6.191  20.452  18.112  1.00  0.00           H  
ATOM    299  HA  LEU A  24      -6.818  17.994  19.590  1.00  0.00           H  
ATOM    300  HB2 LEU A  24      -7.586  20.802  19.919  1.00  0.00           H  
ATOM    301  HB3 LEU A  24      -8.946  19.698  19.945  1.00  0.00           H  
ATOM    302  HG  LEU A  24      -6.502  19.532  21.732  1.00  0.00           H  
ATOM    303 HD11 LEU A  24      -7.508  21.096  22.949  1.00  0.00           H  
ATOM    304 HD12 LEU A  24      -8.968  21.047  21.931  1.00  0.00           H  
ATOM    305 HD13 LEU A  24      -8.790  19.908  23.288  1.00  0.00           H  
ATOM    306 HD21 LEU A  24      -8.972  17.800  21.536  1.00  0.00           H  
ATOM    307 HD22 LEU A  24      -7.264  17.316  21.418  1.00  0.00           H  
ATOM    308 HD23 LEU A  24      -7.931  17.851  22.979  1.00  0.00           H  
ATOM    309  N   TYR A  25      -9.207  17.848  18.295  1.00  0.00           N  
ATOM    310  CA  TYR A  25     -10.168  17.377  17.313  1.00  0.00           C  
ATOM    311  C   TYR A  25     -11.554  17.971  17.573  1.00  0.00           C  
ATOM    312  O   TYR A  25     -12.348  17.399  18.318  1.00  0.00           O  
ATOM    313  CB  TYR A  25     -10.236  15.859  17.483  1.00  0.00           C  
ATOM    314  CG  TYR A  25      -9.284  15.086  16.568  1.00  0.00           C  
ATOM    315  CD1 TYR A  25      -7.933  15.367  16.584  1.00  0.00           C  
ATOM    316  CD2 TYR A  25      -9.776  14.109  15.727  1.00  0.00           C  
ATOM    317  CE1 TYR A  25      -7.035  14.640  15.723  1.00  0.00           C  
ATOM    318  CE2 TYR A  25      -8.879  13.382  14.866  1.00  0.00           C  
ATOM    319  CZ  TYR A  25      -7.554  13.683  14.907  1.00  0.00           C  
ATOM    320  OH  TYR A  25      -6.707  12.997  14.093  1.00  0.00           O  
ATOM    321  H   TYR A  25      -9.464  17.687  19.248  1.00  0.00           H  
ATOM    322  HA  TYR A  25      -9.825  17.694  16.327  1.00  0.00           H  
ATOM    323  HB2 TYR A  25     -10.009  15.609  18.520  1.00  0.00           H  
ATOM    324  HB3 TYR A  25     -11.256  15.528  17.291  1.00  0.00           H  
ATOM    325  HD1 TYR A  25      -7.544  16.139  17.248  1.00  0.00           H  
ATOM    326  HD2 TYR A  25     -10.842  13.888  15.715  1.00  0.00           H  
ATOM    327  HE1 TYR A  25      -5.967  14.852  15.726  1.00  0.00           H  
ATOM    328  HE2 TYR A  25      -9.255  12.607  14.197  1.00  0.00           H  
ATOM    329  HH  TYR A  25      -5.819  12.885  14.540  1.00  0.00           H  
ATOM    330  N   LYS A  26     -11.803  19.110  16.944  1.00  0.00           N  
ATOM    331  CA  LYS A  26     -13.079  19.787  17.099  1.00  0.00           C  
ATOM    332  C   LYS A  26     -14.147  19.041  16.298  1.00  0.00           C  
ATOM    333  O   LYS A  26     -13.845  18.423  15.278  1.00  0.00           O  
ATOM    334  CB  LYS A  26     -12.950  21.265  16.723  1.00  0.00           C  
ATOM    335  CG  LYS A  26     -13.919  22.124  17.538  1.00  0.00           C  
ATOM    336  CD  LYS A  26     -13.956  23.559  17.011  1.00  0.00           C  
ATOM    337  CE  LYS A  26     -14.935  23.689  15.842  1.00  0.00           C  
ATOM    338  NZ  LYS A  26     -15.761  24.908  15.991  1.00  0.00           N  
ATOM    339  H   LYS A  26     -11.151  19.569  16.340  1.00  0.00           H  
ATOM    340  HA  LYS A  26     -13.345  19.745  18.155  1.00  0.00           H  
ATOM    341  HB2 LYS A  26     -11.928  21.601  16.896  1.00  0.00           H  
ATOM    342  HB3 LYS A  26     -13.151  21.393  15.659  1.00  0.00           H  
ATOM    343  HG2 LYS A  26     -14.919  21.691  17.495  1.00  0.00           H  
ATOM    344  HG3 LYS A  26     -13.618  22.125  18.585  1.00  0.00           H  
ATOM    345  HD2 LYS A  26     -14.249  24.237  17.812  1.00  0.00           H  
ATOM    346  HD3 LYS A  26     -12.958  23.858  16.689  1.00  0.00           H  
ATOM    347  HE2 LYS A  26     -14.385  23.730  14.903  1.00  0.00           H  
ATOM    348  HE3 LYS A  26     -15.577  22.810  15.798  1.00  0.00           H  
ATOM    349  HZ1 LYS A  26     -16.320  24.833  16.818  1.00  0.00           H  
ATOM    350  HZ2 LYS A  26     -15.167  25.709  16.063  1.00  0.00           H  
ATOM    351  HZ3 LYS A  26     -16.358  25.006  15.195  1.00  0.00           H  
ATOM    352  N   GLY A  27     -15.375  19.121  16.791  1.00  0.00           N  
ATOM    353  CA  GLY A  27     -16.489  18.460  16.135  1.00  0.00           C  
ATOM    354  C   GLY A  27     -17.674  19.415  15.970  1.00  0.00           C  
ATOM    355  O   GLY A  27     -17.549  20.612  16.222  1.00  0.00           O  
ATOM    356  H   GLY A  27     -15.611  19.624  17.622  1.00  0.00           H  
ATOM    357  HA2 GLY A  27     -16.176  18.093  15.157  1.00  0.00           H  
ATOM    358  HA3 GLY A  27     -16.797  17.591  16.717  1.00  0.00           H  
ATOM    359  N   ASN A  28     -18.796  18.849  15.549  1.00  0.00           N  
ATOM    360  CA  ASN A  28     -20.001  19.635  15.349  1.00  0.00           C  
ATOM    361  C   ASN A  28     -20.967  19.384  16.509  1.00  0.00           C  
ATOM    362  O   ASN A  28     -21.652  20.300  16.961  1.00  0.00           O  
ATOM    363  CB  ASN A  28     -20.707  19.240  14.051  1.00  0.00           C  
ATOM    364  CG  ASN A  28     -21.314  20.464  13.362  1.00  0.00           C  
ATOM    365  OD1 ASN A  28     -20.874  21.589  13.537  1.00  0.00           O  
ATOM    366  ND2 ASN A  28     -22.344  20.183  12.570  1.00  0.00           N  
ATOM    367  H   ASN A  28     -18.888  17.874  15.348  1.00  0.00           H  
ATOM    368  HA  ASN A  28     -19.663  20.671  15.305  1.00  0.00           H  
ATOM    369  HB2 ASN A  28     -19.997  18.754  13.380  1.00  0.00           H  
ATOM    370  HB3 ASN A  28     -21.491  18.513  14.266  1.00  0.00           H  
ATOM    371 HD21 ASN A  28     -22.656  19.238  12.470  1.00  0.00           H  
ATOM    372 HD22 ASN A  28     -22.809  20.917  12.076  1.00  0.00           H  
ATOM    373  N   MET A  29     -20.992  18.137  16.957  1.00  0.00           N  
ATOM    374  CA  MET A  29     -21.862  17.754  18.054  1.00  0.00           C  
ATOM    375  C   MET A  29     -23.334  17.837  17.643  1.00  0.00           C  
ATOM    376  O   MET A  29     -23.785  18.866  17.141  1.00  0.00           O  
ATOM    377  CB  MET A  29     -21.614  18.676  19.250  1.00  0.00           C  
ATOM    378  CG  MET A  29     -21.042  17.896  20.435  1.00  0.00           C  
ATOM    379  SD  MET A  29     -22.354  17.050  21.300  1.00  0.00           S  
ATOM    380  CE  MET A  29     -21.466  15.614  21.881  1.00  0.00           C  
ATOM    381  H   MET A  29     -20.432  17.398  16.584  1.00  0.00           H  
ATOM    382  HA  MET A  29     -21.602  16.722  18.289  1.00  0.00           H  
ATOM    383  HB2 MET A  29     -20.923  19.469  18.964  1.00  0.00           H  
ATOM    384  HB3 MET A  29     -22.547  19.157  19.543  1.00  0.00           H  
ATOM    385  HG2 MET A  29     -20.303  17.176  20.084  1.00  0.00           H  
ATOM    386  HG3 MET A  29     -20.527  18.576  21.114  1.00  0.00           H  
ATOM    387  HE1 MET A  29     -20.466  15.605  21.448  1.00  0.00           H  
ATOM    388  HE2 MET A  29     -21.393  15.647  22.967  1.00  0.00           H  
ATOM    389  HE3 MET A  29     -22.000  14.711  21.580  1.00  0.00           H  
ATOM    390  N   ASN A  30     -24.042  16.741  17.869  1.00  0.00           N  
ATOM    391  CA  ASN A  30     -25.452  16.677  17.527  1.00  0.00           C  
ATOM    392  C   ASN A  30     -26.055  15.394  18.103  1.00  0.00           C  
ATOM    393  O   ASN A  30     -25.360  14.617  18.758  1.00  0.00           O  
ATOM    394  CB  ASN A  30     -25.652  16.652  16.010  1.00  0.00           C  
ATOM    395  CG  ASN A  30     -26.288  17.955  15.520  1.00  0.00           C  
ATOM    396  OD1 ASN A  30     -27.489  18.151  15.584  1.00  0.00           O  
ATOM    397  ND2 ASN A  30     -25.416  18.830  15.027  1.00  0.00           N  
ATOM    398  H   ASN A  30     -23.668  15.908  18.277  1.00  0.00           H  
ATOM    399  HA  ASN A  30     -25.893  17.576  17.960  1.00  0.00           H  
ATOM    400  HB2 ASN A  30     -24.691  16.503  15.517  1.00  0.00           H  
ATOM    401  HB3 ASN A  30     -26.285  15.809  15.737  1.00  0.00           H  
ATOM    402 HD21 ASN A  30     -24.441  18.606  15.002  1.00  0.00           H  
ATOM    403 HD22 ASN A  30     -25.734  19.712  14.680  1.00  0.00           H  
ATOM    404  N   SER A  31     -27.341  15.212  17.841  1.00  0.00           N  
ATOM    405  CA  SER A  31     -28.044  14.036  18.326  1.00  0.00           C  
ATOM    406  C   SER A  31     -27.292  12.770  17.915  1.00  0.00           C  
ATOM    407  O   SER A  31     -26.537  12.208  18.707  1.00  0.00           O  
ATOM    408  CB  SER A  31     -29.479  13.997  17.797  1.00  0.00           C  
ATOM    409  OG  SER A  31     -30.384  14.690  18.652  1.00  0.00           O  
ATOM    410  H   SER A  31     -27.898  15.849  17.309  1.00  0.00           H  
ATOM    411  HA  SER A  31     -28.060  14.137  19.411  1.00  0.00           H  
ATOM    412  HB2 SER A  31     -29.511  14.439  16.800  1.00  0.00           H  
ATOM    413  HB3 SER A  31     -29.800  12.960  17.695  1.00  0.00           H  
ATOM    414  HG  SER A  31     -31.289  14.731  18.231  1.00  0.00           H  
ATOM    415  N   ALA A  32     -27.524  12.356  16.678  1.00  0.00           N  
ATOM    416  CA  ALA A  32     -26.877  11.167  16.152  1.00  0.00           C  
ATOM    417  C   ALA A  32     -25.374  11.244  16.429  1.00  0.00           C  
ATOM    418  O   ALA A  32     -24.887  12.242  16.957  1.00  0.00           O  
ATOM    419  CB  ALA A  32     -27.189  11.032  14.660  1.00  0.00           C  
ATOM    420  H   ALA A  32     -28.139  12.820  16.039  1.00  0.00           H  
ATOM    421  HA  ALA A  32     -27.291  10.305  16.676  1.00  0.00           H  
ATOM    422  HB1 ALA A  32     -26.347  10.561  14.154  1.00  0.00           H  
ATOM    423  HB2 ALA A  32     -28.081  10.420  14.529  1.00  0.00           H  
ATOM    424  HB3 ALA A  32     -27.361  12.021  14.234  1.00  0.00           H  
ATOM    425  N   ILE A  33     -24.682  10.176  16.060  1.00  0.00           N  
ATOM    426  CA  ILE A  33     -23.245  10.110  16.261  1.00  0.00           C  
ATOM    427  C   ILE A  33     -22.534  10.657  15.022  1.00  0.00           C  
ATOM    428  O   ILE A  33     -21.703  11.558  15.124  1.00  0.00           O  
ATOM    429  CB  ILE A  33     -22.820   8.689  16.637  1.00  0.00           C  
ATOM    430  CG1 ILE A  33     -21.447   8.686  17.311  1.00  0.00           C  
ATOM    431  CG2 ILE A  33     -22.863   7.764  15.419  1.00  0.00           C  
ATOM    432  CD1 ILE A  33     -21.584   8.660  18.834  1.00  0.00           C  
ATOM    433  H   ILE A  33     -25.086   9.368  15.631  1.00  0.00           H  
ATOM    434  HA  ILE A  33     -23.004  10.753  17.109  1.00  0.00           H  
ATOM    435  HB  ILE A  33     -23.536   8.299  17.362  1.00  0.00           H  
ATOM    436 HG12 ILE A  33     -20.877   7.819  16.979  1.00  0.00           H  
ATOM    437 HG13 ILE A  33     -20.887   9.571  17.008  1.00  0.00           H  
ATOM    438 HG21 ILE A  33     -22.654   6.741  15.731  1.00  0.00           H  
ATOM    439 HG22 ILE A  33     -23.852   7.809  14.962  1.00  0.00           H  
ATOM    440 HG23 ILE A  33     -22.113   8.083  14.694  1.00  0.00           H  
ATOM    441 HD11 ILE A  33     -21.277   7.683  19.210  1.00  0.00           H  
ATOM    442 HD12 ILE A  33     -20.949   9.432  19.270  1.00  0.00           H  
ATOM    443 HD13 ILE A  33     -22.622   8.846  19.109  1.00  0.00           H  
ATOM    444  N   SER A  34     -22.887  10.088  13.878  1.00  0.00           N  
ATOM    445  CA  SER A  34     -22.293  10.507  12.620  1.00  0.00           C  
ATOM    446  C   SER A  34     -22.377  12.028  12.483  1.00  0.00           C  
ATOM    447  O   SER A  34     -21.612  12.630  11.730  1.00  0.00           O  
ATOM    448  CB  SER A  34     -22.982   9.828  11.433  1.00  0.00           C  
ATOM    449  OG  SER A  34     -22.698   8.433  11.379  1.00  0.00           O  
ATOM    450  H   SER A  34     -23.564   9.356  13.803  1.00  0.00           H  
ATOM    451  HA  SER A  34     -21.253  10.183  12.670  1.00  0.00           H  
ATOM    452  HB2 SER A  34     -24.058   9.978  11.506  1.00  0.00           H  
ATOM    453  HB3 SER A  34     -22.655  10.301  10.507  1.00  0.00           H  
ATOM    454  HG  SER A  34     -21.748   8.266  11.645  1.00  0.00           H  
ATOM    455  N   VAL A  35     -23.312  12.607  13.222  1.00  0.00           N  
ATOM    456  CA  VAL A  35     -23.506  14.047  13.192  1.00  0.00           C  
ATOM    457  C   VAL A  35     -22.680  14.691  14.307  1.00  0.00           C  
ATOM    458  O   VAL A  35     -22.095  15.756  14.115  1.00  0.00           O  
ATOM    459  CB  VAL A  35     -24.997  14.376  13.284  1.00  0.00           C  
ATOM    460  CG1 VAL A  35     -25.594  13.856  14.593  1.00  0.00           C  
ATOM    461  CG2 VAL A  35     -25.237  15.879  13.131  1.00  0.00           C  
ATOM    462  H   VAL A  35     -23.930  12.110  13.831  1.00  0.00           H  
ATOM    463  HA  VAL A  35     -23.139  14.408  12.231  1.00  0.00           H  
ATOM    464  HB  VAL A  35     -25.504  13.872  12.461  1.00  0.00           H  
ATOM    465 HG11 VAL A  35     -26.633  14.173  14.670  1.00  0.00           H  
ATOM    466 HG12 VAL A  35     -25.543  12.767  14.608  1.00  0.00           H  
ATOM    467 HG13 VAL A  35     -25.028  14.257  15.435  1.00  0.00           H  
ATOM    468 HG21 VAL A  35     -24.384  16.426  13.535  1.00  0.00           H  
ATOM    469 HG22 VAL A  35     -25.358  16.122  12.076  1.00  0.00           H  
ATOM    470 HG23 VAL A  35     -26.138  16.161  13.675  1.00  0.00           H  
ATOM    471  N   THR A  36     -22.660  14.018  15.448  1.00  0.00           N  
ATOM    472  CA  THR A  36     -21.917  14.512  16.595  1.00  0.00           C  
ATOM    473  C   THR A  36     -20.468  14.811  16.203  1.00  0.00           C  
ATOM    474  O   THR A  36     -19.903  15.820  16.620  1.00  0.00           O  
ATOM    475  CB  THR A  36     -22.042  13.482  17.719  1.00  0.00           C  
ATOM    476  OG1 THR A  36     -22.351  14.261  18.871  1.00  0.00           O  
ATOM    477  CG2 THR A  36     -20.704  12.824  18.063  1.00  0.00           C  
ATOM    478  H   THR A  36     -23.139  13.153  15.596  1.00  0.00           H  
ATOM    479  HA  THR A  36     -22.362  15.455  16.913  1.00  0.00           H  
ATOM    480  HB  THR A  36     -22.794  12.732  17.477  1.00  0.00           H  
ATOM    481  HG1 THR A  36     -23.154  13.885  19.333  1.00  0.00           H  
ATOM    482 HG21 THR A  36     -19.944  13.594  18.200  1.00  0.00           H  
ATOM    483 HG22 THR A  36     -20.808  12.247  18.982  1.00  0.00           H  
ATOM    484 HG23 THR A  36     -20.406  12.161  17.250  1.00  0.00           H  
ATOM    485  N   MET A  37     -19.908  13.912  15.406  1.00  0.00           N  
ATOM    486  CA  MET A  37     -18.535  14.066  14.952  1.00  0.00           C  
ATOM    487  C   MET A  37     -18.483  14.757  13.587  1.00  0.00           C  
ATOM    488  O   MET A  37     -17.534  15.478  13.289  1.00  0.00           O  
ATOM    489  CB  MET A  37     -17.873  12.691  14.855  1.00  0.00           C  
ATOM    490  CG  MET A  37     -18.784  11.692  14.139  1.00  0.00           C  
ATOM    491  SD  MET A  37     -17.799  10.491  13.260  1.00  0.00           S  
ATOM    492  CE  MET A  37     -17.920   9.109  14.384  1.00  0.00           C  
ATOM    493  H   MET A  37     -20.374  13.093  15.071  1.00  0.00           H  
ATOM    494  HA  MET A  37     -18.048  14.691  15.702  1.00  0.00           H  
ATOM    495  HB2 MET A  37     -16.927  12.777  14.319  1.00  0.00           H  
ATOM    496  HB3 MET A  37     -17.639  12.324  15.855  1.00  0.00           H  
ATOM    497  HG2 MET A  37     -19.426  11.190  14.862  1.00  0.00           H  
ATOM    498  HG3 MET A  37     -19.437  12.219  13.443  1.00  0.00           H  
ATOM    499  HE1 MET A  37     -18.406   8.273  13.882  1.00  0.00           H  
ATOM    500  HE2 MET A  37     -16.921   8.811  14.702  1.00  0.00           H  
ATOM    501  HE3 MET A  37     -18.507   9.400  15.255  1.00  0.00           H  
ATOM    502  N   ARG A  38     -19.516  14.510  12.795  1.00  0.00           N  
ATOM    503  CA  ARG A  38     -19.600  15.098  11.470  1.00  0.00           C  
ATOM    504  C   ARG A  38     -18.205  15.221  10.854  1.00  0.00           C  
ATOM    505  O   ARG A  38     -17.849  16.268  10.318  1.00  0.00           O  
ATOM    506  CB  ARG A  38     -20.251  16.482  11.521  1.00  0.00           C  
ATOM    507  CG  ARG A  38     -21.748  16.396  11.218  1.00  0.00           C  
ATOM    508  CD  ARG A  38     -22.139  17.367  10.102  1.00  0.00           C  
ATOM    509  NE  ARG A  38     -23.490  17.913  10.358  1.00  0.00           N  
ATOM    510  CZ  ARG A  38     -24.151  18.710   9.506  1.00  0.00           C  
ATOM    511  NH1 ARG A  38     -23.590  19.057   8.341  1.00  0.00           N  
ATOM    512  NH2 ARG A  38     -25.374  19.159   9.821  1.00  0.00           N  
ATOM    513  H   ARG A  38     -20.285  13.921  13.046  1.00  0.00           H  
ATOM    514  HA  ARG A  38     -20.221  14.409  10.898  1.00  0.00           H  
ATOM    515  HB2 ARG A  38     -20.100  16.922  12.507  1.00  0.00           H  
ATOM    516  HB3 ARG A  38     -19.767  17.142  10.800  1.00  0.00           H  
ATOM    517  HG2 ARG A  38     -22.006  15.378  10.926  1.00  0.00           H  
ATOM    518  HG3 ARG A  38     -22.319  16.622  12.119  1.00  0.00           H  
ATOM    519  HD2 ARG A  38     -21.414  18.179  10.045  1.00  0.00           H  
ATOM    520  HD3 ARG A  38     -22.120  16.855   9.140  1.00  0.00           H  
ATOM    521  HE  ARG A  38     -23.938  17.673  11.219  1.00  0.00           H  
ATOM    522 HH11 ARG A  38     -22.677  18.722   8.105  1.00  0.00           H  
ATOM    523 HH12 ARG A  38     -24.083  19.652   7.705  1.00  0.00           H  
ATOM    524 HH21 ARG A  38     -25.794  18.899  10.691  1.00  0.00           H  
ATOM    525 HH22 ARG A  38     -25.868  19.754   9.186  1.00  0.00           H  
ATOM    526  N   SER A  39     -17.452  14.135  10.952  1.00  0.00           N  
ATOM    527  CA  SER A  39     -16.103  14.108  10.412  1.00  0.00           C  
ATOM    528  C   SER A  39     -15.161  14.904  11.317  1.00  0.00           C  
ATOM    529  O   SER A  39     -14.728  15.999  10.959  1.00  0.00           O  
ATOM    530  CB  SER A  39     -16.069  14.666   8.988  1.00  0.00           C  
ATOM    531  OG  SER A  39     -17.185  14.229   8.217  1.00  0.00           O  
ATOM    532  H   SER A  39     -17.749  13.286  11.390  1.00  0.00           H  
ATOM    533  HA  SER A  39     -15.820  13.056  10.397  1.00  0.00           H  
ATOM    534  HB2 SER A  39     -16.058  15.755   9.026  1.00  0.00           H  
ATOM    535  HB3 SER A  39     -15.146  14.354   8.499  1.00  0.00           H  
ATOM    536  HG  SER A  39     -18.004  14.737   8.484  1.00  0.00           H  
ATOM    537  N   PHE A  40     -14.871  14.324  12.472  1.00  0.00           N  
ATOM    538  CA  PHE A  40     -13.987  14.966  13.431  1.00  0.00           C  
ATOM    539  C   PHE A  40     -12.744  15.530  12.740  1.00  0.00           C  
ATOM    540  O   PHE A  40     -11.940  14.777  12.191  1.00  0.00           O  
ATOM    541  CB  PHE A  40     -13.557  13.891  14.432  1.00  0.00           C  
ATOM    542  CG  PHE A  40     -14.152  14.069  15.830  1.00  0.00           C  
ATOM    543  CD1 PHE A  40     -15.398  14.594  15.976  1.00  0.00           C  
ATOM    544  CD2 PHE A  40     -13.436  13.701  16.926  1.00  0.00           C  
ATOM    545  CE1 PHE A  40     -15.951  14.759  17.274  1.00  0.00           C  
ATOM    546  CE2 PHE A  40     -13.989  13.866  18.224  1.00  0.00           C  
ATOM    547  CZ  PHE A  40     -15.235  14.392  18.370  1.00  0.00           C  
ATOM    548  H   PHE A  40     -15.227  13.433  12.756  1.00  0.00           H  
ATOM    549  HA  PHE A  40     -14.546  15.781  13.890  1.00  0.00           H  
ATOM    550  HB2 PHE A  40     -13.846  12.914  14.046  1.00  0.00           H  
ATOM    551  HB3 PHE A  40     -12.470  13.896  14.508  1.00  0.00           H  
ATOM    552  HD1 PHE A  40     -15.972  14.889  15.098  1.00  0.00           H  
ATOM    553  HD2 PHE A  40     -12.438  13.280  16.809  1.00  0.00           H  
ATOM    554  HE1 PHE A  40     -16.949  15.181  17.391  1.00  0.00           H  
ATOM    555  HE2 PHE A  40     -13.415  13.571  19.102  1.00  0.00           H  
ATOM    556  HZ  PHE A  40     -15.659  14.518  19.367  1.00  0.00           H  
ATOM    557  N   LYS A  41     -12.626  16.848  12.788  1.00  0.00           N  
ATOM    558  CA  LYS A  41     -11.494  17.521  12.174  1.00  0.00           C  
ATOM    559  C   LYS A  41     -10.491  17.918  13.258  1.00  0.00           C  
ATOM    560  O   LYS A  41     -10.870  18.144  14.407  1.00  0.00           O  
ATOM    561  CB  LYS A  41     -11.971  18.696  11.317  1.00  0.00           C  
ATOM    562  CG  LYS A  41     -11.992  18.321   9.834  1.00  0.00           C  
ATOM    563  CD  LYS A  41     -10.575  18.290   9.256  1.00  0.00           C  
ATOM    564  CE  LYS A  41     -10.589  17.841   7.793  1.00  0.00           C  
ATOM    565  NZ  LYS A  41      -9.554  18.562   7.020  1.00  0.00           N  
ATOM    566  H   LYS A  41     -13.285  17.453  13.236  1.00  0.00           H  
ATOM    567  HA  LYS A  41     -11.015  16.808  11.503  1.00  0.00           H  
ATOM    568  HB2 LYS A  41     -12.968  19.001  11.633  1.00  0.00           H  
ATOM    569  HB3 LYS A  41     -11.313  19.553  11.471  1.00  0.00           H  
ATOM    570  HG2 LYS A  41     -12.461  17.346   9.710  1.00  0.00           H  
ATOM    571  HG3 LYS A  41     -12.598  19.040   9.282  1.00  0.00           H  
ATOM    572  HD2 LYS A  41     -10.126  19.280   9.332  1.00  0.00           H  
ATOM    573  HD3 LYS A  41      -9.955  17.612   9.842  1.00  0.00           H  
ATOM    574  HE2 LYS A  41     -10.415  16.768   7.735  1.00  0.00           H  
ATOM    575  HE3 LYS A  41     -11.572  18.029   7.358  1.00  0.00           H  
ATOM    576  HZ1 LYS A  41      -9.765  18.505   6.044  1.00  0.00           H  
ATOM    577  HZ2 LYS A  41      -9.535  19.522   7.301  1.00  0.00           H  
ATOM    578  HZ3 LYS A  41      -8.661  18.147   7.193  1.00  0.00           H  
ATOM    579  N   ARG A  42      -9.231  17.989  12.856  1.00  0.00           N  
ATOM    580  CA  ARG A  42      -8.170  18.354  13.780  1.00  0.00           C  
ATOM    581  C   ARG A  42      -7.731  19.800  13.539  1.00  0.00           C  
ATOM    582  O   ARG A  42      -7.616  20.235  12.394  1.00  0.00           O  
ATOM    583  CB  ARG A  42      -6.961  17.429  13.625  1.00  0.00           C  
ATOM    584  CG  ARG A  42      -5.856  17.801  14.614  1.00  0.00           C  
ATOM    585  CD  ARG A  42      -4.577  17.010  14.329  1.00  0.00           C  
ATOM    586  NE  ARG A  42      -3.972  16.551  15.599  1.00  0.00           N  
ATOM    587  CZ  ARG A  42      -2.931  15.710  15.675  1.00  0.00           C  
ATOM    588  NH1 ARG A  42      -2.376  15.230  14.554  1.00  0.00           N  
ATOM    589  NH2 ARG A  42      -2.449  15.347  16.871  1.00  0.00           N  
ATOM    590  H   ARG A  42      -8.931  17.803  11.920  1.00  0.00           H  
ATOM    591  HA  ARG A  42      -8.611  18.238  14.770  1.00  0.00           H  
ATOM    592  HB2 ARG A  42      -7.268  16.395  13.787  1.00  0.00           H  
ATOM    593  HB3 ARG A  42      -6.579  17.491  12.606  1.00  0.00           H  
ATOM    594  HG2 ARG A  42      -5.649  18.869  14.550  1.00  0.00           H  
ATOM    595  HG3 ARG A  42      -6.192  17.601  15.633  1.00  0.00           H  
ATOM    596  HD2 ARG A  42      -4.802  16.154  13.693  1.00  0.00           H  
ATOM    597  HD3 ARG A  42      -3.869  17.634  13.784  1.00  0.00           H  
ATOM    598  HE  ARG A  42      -4.364  16.890  16.454  1.00  0.00           H  
ATOM    599 HH11 ARG A  42      -2.737  15.500  13.662  1.00  0.00           H  
ATOM    600 HH12 ARG A  42      -1.600  14.601  14.611  1.00  0.00           H  
ATOM    601 HH21 ARG A  42      -2.864  15.706  17.707  1.00  0.00           H  
ATOM    602 HH22 ARG A  42      -1.673  14.719  16.928  1.00  0.00           H  
ATOM    603  N   ARG A  43      -7.496  20.504  14.637  1.00  0.00           N  
ATOM    604  CA  ARG A  43      -7.072  21.892  14.559  1.00  0.00           C  
ATOM    605  C   ARG A  43      -6.166  22.237  15.743  1.00  0.00           C  
ATOM    606  O   ARG A  43      -6.218  21.578  16.781  1.00  0.00           O  
ATOM    607  CB  ARG A  43      -8.276  22.836  14.554  1.00  0.00           C  
ATOM    608  CG  ARG A  43      -8.209  23.803  13.371  1.00  0.00           C  
ATOM    609  CD  ARG A  43      -9.282  23.473  12.332  1.00  0.00           C  
ATOM    610  NE  ARG A  43      -8.973  24.149  11.051  1.00  0.00           N  
ATOM    611  CZ  ARG A  43      -9.413  23.731   9.856  1.00  0.00           C  
ATOM    612  NH1 ARG A  43     -10.183  22.638   9.771  1.00  0.00           N  
ATOM    613  NH2 ARG A  43      -9.082  24.405   8.747  1.00  0.00           N  
ATOM    614  H   ARG A  43      -7.591  20.142  15.564  1.00  0.00           H  
ATOM    615  HA  ARG A  43      -6.530  21.965  13.617  1.00  0.00           H  
ATOM    616  HB2 ARG A  43      -9.197  22.256  14.503  1.00  0.00           H  
ATOM    617  HB3 ARG A  43      -8.305  23.399  15.487  1.00  0.00           H  
ATOM    618  HG2 ARG A  43      -8.342  24.826  13.724  1.00  0.00           H  
ATOM    619  HG3 ARG A  43      -7.223  23.751  12.909  1.00  0.00           H  
ATOM    620  HD2 ARG A  43      -9.335  22.395  12.180  1.00  0.00           H  
ATOM    621  HD3 ARG A  43     -10.260  23.791  12.693  1.00  0.00           H  
ATOM    622  HE  ARG A  43      -8.400  24.967  11.080  1.00  0.00           H  
ATOM    623 HH11 ARG A  43     -10.430  22.134  10.598  1.00  0.00           H  
ATOM    624 HH12 ARG A  43     -10.511  22.327   8.878  1.00  0.00           H  
ATOM    625 HH21 ARG A  43      -8.506  25.221   8.812  1.00  0.00           H  
ATOM    626 HH22 ARG A  43      -9.409  24.094   7.855  1.00  0.00           H  
ATOM    627  N   PHE A  44      -5.359  23.269  15.549  1.00  0.00           N  
ATOM    628  CA  PHE A  44      -4.443  23.709  16.587  1.00  0.00           C  
ATOM    629  C   PHE A  44      -5.131  24.681  17.548  1.00  0.00           C  
ATOM    630  O   PHE A  44      -5.391  25.830  17.195  1.00  0.00           O  
ATOM    631  CB  PHE A  44      -3.289  24.432  15.890  1.00  0.00           C  
ATOM    632  CG  PHE A  44      -2.124  24.784  16.817  1.00  0.00           C  
ATOM    633  CD1 PHE A  44      -1.309  23.803  17.287  1.00  0.00           C  
ATOM    634  CD2 PHE A  44      -1.905  26.079  17.171  1.00  0.00           C  
ATOM    635  CE1 PHE A  44      -0.227  24.130  18.147  1.00  0.00           C  
ATOM    636  CE2 PHE A  44      -0.823  26.406  18.031  1.00  0.00           C  
ATOM    637  CZ  PHE A  44      -0.007  25.424  18.501  1.00  0.00           C  
ATOM    638  H   PHE A  44      -5.324  23.799  14.701  1.00  0.00           H  
ATOM    639  HA  PHE A  44      -4.126  22.822  17.136  1.00  0.00           H  
ATOM    640  HB2 PHE A  44      -2.918  23.804  15.078  1.00  0.00           H  
ATOM    641  HB3 PHE A  44      -3.668  25.347  15.436  1.00  0.00           H  
ATOM    642  HD1 PHE A  44      -1.485  22.765  17.003  1.00  0.00           H  
ATOM    643  HD2 PHE A  44      -2.559  26.865  16.794  1.00  0.00           H  
ATOM    644  HE1 PHE A  44       0.426  23.343  18.524  1.00  0.00           H  
ATOM    645  HE2 PHE A  44      -0.647  27.444  18.315  1.00  0.00           H  
ATOM    646  HZ  PHE A  44       0.823  25.675  19.162  1.00  0.00           H  
ATOM    647  N   PHE A  45      -5.407  24.184  18.745  1.00  0.00           N  
ATOM    648  CA  PHE A  45      -6.059  24.994  19.760  1.00  0.00           C  
ATOM    649  C   PHE A  45      -5.029  25.729  20.621  1.00  0.00           C  
ATOM    650  O   PHE A  45      -4.261  25.100  21.347  1.00  0.00           O  
ATOM    651  CB  PHE A  45      -6.860  24.039  20.646  1.00  0.00           C  
ATOM    652  CG  PHE A  45      -8.216  23.638  20.063  1.00  0.00           C  
ATOM    653  CD1 PHE A  45      -8.273  22.895  18.924  1.00  0.00           C  
ATOM    654  CD2 PHE A  45      -9.364  24.022  20.681  1.00  0.00           C  
ATOM    655  CE1 PHE A  45      -9.531  22.521  18.383  1.00  0.00           C  
ATOM    656  CE2 PHE A  45     -10.623  23.649  20.140  1.00  0.00           C  
ATOM    657  CZ  PHE A  45     -10.679  22.907  19.001  1.00  0.00           C  
ATOM    658  H   PHE A  45      -5.192  23.248  19.025  1.00  0.00           H  
ATOM    659  HA  PHE A  45      -6.682  25.723  19.240  1.00  0.00           H  
ATOM    660  HB2 PHE A  45      -6.270  23.140  20.822  1.00  0.00           H  
ATOM    661  HB3 PHE A  45      -7.019  24.509  21.617  1.00  0.00           H  
ATOM    662  HD1 PHE A  45      -7.353  22.586  18.429  1.00  0.00           H  
ATOM    663  HD2 PHE A  45      -9.319  24.618  21.594  1.00  0.00           H  
ATOM    664  HE1 PHE A  45      -9.577  21.926  17.471  1.00  0.00           H  
ATOM    665  HE2 PHE A  45     -11.543  23.957  20.635  1.00  0.00           H  
ATOM    666  HZ  PHE A  45     -11.645  22.620  18.586  1.00  0.00           H  
ATOM    667  N   HIS A  46      -5.047  27.048  20.511  1.00  0.00           N  
ATOM    668  CA  HIS A  46      -4.125  27.876  21.271  1.00  0.00           C  
ATOM    669  C   HIS A  46      -4.896  28.664  22.330  1.00  0.00           C  
ATOM    670  O   HIS A  46      -5.961  29.214  22.048  1.00  0.00           O  
ATOM    671  CB  HIS A  46      -3.309  28.774  20.341  1.00  0.00           C  
ATOM    672  CG  HIS A  46      -2.758  30.012  21.009  1.00  0.00           C  
ATOM    673  ND1 HIS A  46      -2.841  31.270  20.440  1.00  0.00           N  
ATOM    674  CD2 HIS A  46      -2.118  30.170  22.202  1.00  0.00           C  
ATOM    675  CE1 HIS A  46      -2.273  32.139  21.262  1.00  0.00           C  
ATOM    676  NE2 HIS A  46      -1.825  31.455  22.354  1.00  0.00           N  
ATOM    677  H   HIS A  46      -5.676  27.552  19.918  1.00  0.00           H  
ATOM    678  HA  HIS A  46      -3.433  27.196  21.769  1.00  0.00           H  
ATOM    679  HB2 HIS A  46      -2.480  28.196  19.930  1.00  0.00           H  
ATOM    680  HB3 HIS A  46      -3.934  29.074  19.500  1.00  0.00           H  
ATOM    681  HD1 HIS A  46      -3.259  31.487  19.557  1.00  0.00           H  
ATOM    682  HD2 HIS A  46      -1.886  29.375  22.912  1.00  0.00           H  
ATOM    683  HE1 HIS A  46      -2.179  33.213  21.096  1.00  0.00           H  
ATOM    684  N   LEU A  47      -4.330  28.696  23.527  1.00  0.00           N  
ATOM    685  CA  LEU A  47      -4.952  29.409  24.631  1.00  0.00           C  
ATOM    686  C   LEU A  47      -4.270  30.768  24.803  1.00  0.00           C  
ATOM    687  O   LEU A  47      -3.044  30.863  24.755  1.00  0.00           O  
ATOM    688  CB  LEU A  47      -4.939  28.551  25.898  1.00  0.00           C  
ATOM    689  CG  LEU A  47      -5.539  29.194  27.149  1.00  0.00           C  
ATOM    690  CD1 LEU A  47      -7.042  29.428  26.979  1.00  0.00           C  
ATOM    691  CD2 LEU A  47      -5.226  28.365  28.396  1.00  0.00           C  
ATOM    692  H   LEU A  47      -3.464  28.247  23.749  1.00  0.00           H  
ATOM    693  HA  LEU A  47      -5.996  29.577  24.365  1.00  0.00           H  
ATOM    694  HB2 LEU A  47      -5.482  27.628  25.692  1.00  0.00           H  
ATOM    695  HB3 LEU A  47      -3.908  28.273  26.115  1.00  0.00           H  
ATOM    696  HG  LEU A  47      -5.076  30.171  27.288  1.00  0.00           H  
ATOM    697 HD11 LEU A  47      -7.592  28.601  27.429  1.00  0.00           H  
ATOM    698 HD12 LEU A  47      -7.323  30.360  27.470  1.00  0.00           H  
ATOM    699 HD13 LEU A  47      -7.283  29.489  25.918  1.00  0.00           H  
ATOM    700 HD21 LEU A  47      -6.154  27.985  28.822  1.00  0.00           H  
ATOM    701 HD22 LEU A  47      -4.581  27.529  28.125  1.00  0.00           H  
ATOM    702 HD23 LEU A  47      -4.719  28.991  29.130  1.00  0.00           H  
ATOM    703  N   ILE A  48      -5.094  31.787  24.999  1.00  0.00           N  
ATOM    704  CA  ILE A  48      -4.586  33.136  25.179  1.00  0.00           C  
ATOM    705  C   ILE A  48      -5.419  33.853  26.244  1.00  0.00           C  
ATOM    706  O   ILE A  48      -6.623  33.625  26.353  1.00  0.00           O  
ATOM    707  CB  ILE A  48      -4.536  33.872  23.838  1.00  0.00           C  
ATOM    708  CG1 ILE A  48      -4.846  35.360  24.018  1.00  0.00           C  
ATOM    709  CG2 ILE A  48      -5.464  33.213  22.816  1.00  0.00           C  
ATOM    710  CD1 ILE A  48      -4.241  36.187  22.882  1.00  0.00           C  
ATOM    711  H   ILE A  48      -6.089  31.702  25.038  1.00  0.00           H  
ATOM    712  HA  ILE A  48      -3.561  33.055  25.540  1.00  0.00           H  
ATOM    713  HB  ILE A  48      -3.522  33.800  23.446  1.00  0.00           H  
ATOM    714 HG12 ILE A  48      -5.926  35.509  24.046  1.00  0.00           H  
ATOM    715 HG13 ILE A  48      -4.451  35.704  24.974  1.00  0.00           H  
ATOM    716 HG21 ILE A  48      -6.451  33.073  23.258  1.00  0.00           H  
ATOM    717 HG22 ILE A  48      -5.547  33.851  21.936  1.00  0.00           H  
ATOM    718 HG23 ILE A  48      -5.056  32.245  22.526  1.00  0.00           H  
ATOM    719 HD11 ILE A  48      -4.914  36.176  22.025  1.00  0.00           H  
ATOM    720 HD12 ILE A  48      -4.098  37.214  23.217  1.00  0.00           H  
ATOM    721 HD13 ILE A  48      -3.280  35.760  22.595  1.00  0.00           H  
ATOM    722  N   GLN A  49      -4.745  34.705  27.001  1.00  0.00           N  
ATOM    723  CA  GLN A  49      -5.407  35.457  28.054  1.00  0.00           C  
ATOM    724  C   GLN A  49      -5.850  36.824  27.531  1.00  0.00           C  
ATOM    725  O   GLN A  49      -5.017  37.652  27.164  1.00  0.00           O  
ATOM    726  CB  GLN A  49      -4.500  35.604  29.277  1.00  0.00           C  
ATOM    727  CG  GLN A  49      -5.211  36.365  30.398  1.00  0.00           C  
ATOM    728  CD  GLN A  49      -4.213  36.842  31.456  1.00  0.00           C  
ATOM    729  OE1 GLN A  49      -3.077  37.179  31.166  1.00  0.00           O  
ATOM    730  NE2 GLN A  49      -4.700  36.850  32.694  1.00  0.00           N  
ATOM    731  H   GLN A  49      -3.766  34.885  26.906  1.00  0.00           H  
ATOM    732  HA  GLN A  49      -6.281  34.865  28.327  1.00  0.00           H  
ATOM    733  HB2 GLN A  49      -4.202  34.619  29.634  1.00  0.00           H  
ATOM    734  HB3 GLN A  49      -3.589  36.131  28.997  1.00  0.00           H  
ATOM    735  HG2 GLN A  49      -5.742  37.221  29.982  1.00  0.00           H  
ATOM    736  HG3 GLN A  49      -5.959  35.721  30.862  1.00  0.00           H  
ATOM    737 HE21 GLN A  49      -5.642  36.561  32.862  1.00  0.00           H  
ATOM    738 HE22 GLN A  49      -4.123  37.147  33.455  1.00  0.00           H  
ATOM    739  N   LEU A  50      -7.160  37.021  27.514  1.00  0.00           N  
ATOM    740  CA  LEU A  50      -7.724  38.274  27.042  1.00  0.00           C  
ATOM    741  C   LEU A  50      -7.063  39.437  27.786  1.00  0.00           C  
ATOM    742  O   LEU A  50      -6.416  39.235  28.812  1.00  0.00           O  
ATOM    743  CB  LEU A  50      -9.249  38.255  27.162  1.00  0.00           C  
ATOM    744  CG  LEU A  50      -9.976  37.211  26.310  1.00  0.00           C  
ATOM    745  CD1 LEU A  50      -9.208  36.928  25.017  1.00  0.00           C  
ATOM    746  CD2 LEU A  50     -10.236  35.935  27.113  1.00  0.00           C  
ATOM    747  H   LEU A  50      -7.831  36.342  27.815  1.00  0.00           H  
ATOM    748  HA  LEU A  50      -7.484  38.361  25.982  1.00  0.00           H  
ATOM    749  HB2 LEU A  50      -9.510  38.088  28.206  1.00  0.00           H  
ATOM    750  HB3 LEU A  50      -9.627  39.241  26.893  1.00  0.00           H  
ATOM    751  HG  LEU A  50     -10.946  37.617  26.026  1.00  0.00           H  
ATOM    752 HD11 LEU A  50      -8.895  37.870  24.567  1.00  0.00           H  
ATOM    753 HD12 LEU A  50      -8.329  36.322  25.241  1.00  0.00           H  
ATOM    754 HD13 LEU A  50      -9.852  36.390  24.322  1.00  0.00           H  
ATOM    755 HD21 LEU A  50     -11.266  35.613  26.958  1.00  0.00           H  
ATOM    756 HD22 LEU A  50      -9.557  35.151  26.779  1.00  0.00           H  
ATOM    757 HD23 LEU A  50     -10.072  36.131  28.172  1.00  0.00           H  
ATOM    758  N   GLY A  51      -7.249  40.629  27.239  1.00  0.00           N  
ATOM    759  CA  GLY A  51      -6.679  41.824  27.837  1.00  0.00           C  
ATOM    760  C   GLY A  51      -7.515  42.291  29.031  1.00  0.00           C  
ATOM    761  O   GLY A  51      -8.055  43.396  29.020  1.00  0.00           O  
ATOM    762  H   GLY A  51      -7.777  40.784  26.403  1.00  0.00           H  
ATOM    763  HA2 GLY A  51      -5.658  41.622  28.160  1.00  0.00           H  
ATOM    764  HA3 GLY A  51      -6.627  42.618  27.092  1.00  0.00           H  
ATOM    765  N   ASP A  52      -7.595  41.426  30.031  1.00  0.00           N  
ATOM    766  CA  ASP A  52      -8.356  41.736  31.229  1.00  0.00           C  
ATOM    767  C   ASP A  52      -7.981  40.748  32.336  1.00  0.00           C  
ATOM    768  O   ASP A  52      -7.785  41.141  33.485  1.00  0.00           O  
ATOM    769  CB  ASP A  52      -9.860  41.613  30.975  1.00  0.00           C  
ATOM    770  CG  ASP A  52     -10.747  42.386  31.953  1.00  0.00           C  
ATOM    771  OD1 ASP A  52     -10.243  43.386  32.506  1.00  0.00           O  
ATOM    772  OD2 ASP A  52     -11.908  41.959  32.125  1.00  0.00           O  
ATOM    773  H   ASP A  52      -7.152  40.529  30.032  1.00  0.00           H  
ATOM    774  HA  ASP A  52      -8.090  42.763  31.480  1.00  0.00           H  
ATOM    775  HB2 ASP A  52     -10.071  41.959  29.963  1.00  0.00           H  
ATOM    776  HB3 ASP A  52     -10.134  40.558  31.014  1.00  0.00           H  
ATOM    777  N   GLY A  53      -7.893  39.483  31.951  1.00  0.00           N  
ATOM    778  CA  GLY A  53      -7.545  38.436  32.897  1.00  0.00           C  
ATOM    779  C   GLY A  53      -8.171  37.100  32.489  1.00  0.00           C  
ATOM    780  O   GLY A  53      -7.643  36.038  32.815  1.00  0.00           O  
ATOM    781  H   GLY A  53      -8.055  39.171  31.015  1.00  0.00           H  
ATOM    782  HA2 GLY A  53      -6.462  38.332  32.948  1.00  0.00           H  
ATOM    783  HA3 GLY A  53      -7.887  38.713  33.894  1.00  0.00           H  
ATOM    784  N   SER A  54      -9.288  37.198  31.783  1.00  0.00           N  
ATOM    785  CA  SER A  54      -9.991  36.010  31.328  1.00  0.00           C  
ATOM    786  C   SER A  54      -9.142  35.261  30.298  1.00  0.00           C  
ATOM    787  O   SER A  54      -8.147  35.790  29.806  1.00  0.00           O  
ATOM    788  CB  SER A  54     -11.353  36.371  30.731  1.00  0.00           C  
ATOM    789  OG  SER A  54     -11.276  37.505  29.872  1.00  0.00           O  
ATOM    790  H   SER A  54      -9.711  38.065  31.522  1.00  0.00           H  
ATOM    791  HA  SER A  54     -10.136  35.400  32.220  1.00  0.00           H  
ATOM    792  HB2 SER A  54     -11.741  35.518  30.172  1.00  0.00           H  
ATOM    793  HB3 SER A  54     -12.059  36.573  31.536  1.00  0.00           H  
ATOM    794  HG  SER A  54     -12.163  37.963  29.830  1.00  0.00           H  
ATOM    795  N   TYR A  55      -9.566  34.041  30.004  1.00  0.00           N  
ATOM    796  CA  TYR A  55      -8.857  33.214  29.042  1.00  0.00           C  
ATOM    797  C   TYR A  55      -9.780  32.789  27.898  1.00  0.00           C  
ATOM    798  O   TYR A  55     -10.926  32.403  28.130  1.00  0.00           O  
ATOM    799  CB  TYR A  55      -8.408  31.968  29.807  1.00  0.00           C  
ATOM    800  CG  TYR A  55      -6.967  32.036  30.317  1.00  0.00           C  
ATOM    801  CD1 TYR A  55      -6.478  33.213  30.847  1.00  0.00           C  
ATOM    802  CD2 TYR A  55      -6.156  30.922  30.246  1.00  0.00           C  
ATOM    803  CE1 TYR A  55      -5.121  33.278  31.326  1.00  0.00           C  
ATOM    804  CE2 TYR A  55      -4.800  30.987  30.726  1.00  0.00           C  
ATOM    805  CZ  TYR A  55      -4.349  32.161  31.242  1.00  0.00           C  
ATOM    806  OH  TYR A  55      -3.068  32.222  31.694  1.00  0.00           O  
ATOM    807  H   TYR A  55     -10.377  33.617  30.409  1.00  0.00           H  
ATOM    808  HA  TYR A  55      -8.034  33.801  28.636  1.00  0.00           H  
ATOM    809  HB2 TYR A  55      -9.075  31.814  30.656  1.00  0.00           H  
ATOM    810  HB3 TYR A  55      -8.512  31.098  29.159  1.00  0.00           H  
ATOM    811  HD1 TYR A  55      -7.118  34.094  30.904  1.00  0.00           H  
ATOM    812  HD2 TYR A  55      -6.542  29.992  29.827  1.00  0.00           H  
ATOM    813  HE1 TYR A  55      -4.723  34.200  31.748  1.00  0.00           H  
ATOM    814  HE2 TYR A  55      -4.148  30.113  30.675  1.00  0.00           H  
ATOM    815  HH  TYR A  55      -2.677  33.121  31.494  1.00  0.00           H  
ATOM    816  N   ASN A  56      -9.248  32.875  26.688  1.00  0.00           N  
ATOM    817  CA  ASN A  56     -10.010  32.506  25.507  1.00  0.00           C  
ATOM    818  C   ASN A  56      -9.233  31.453  24.714  1.00  0.00           C  
ATOM    819  O   ASN A  56      -8.042  31.618  24.457  1.00  0.00           O  
ATOM    820  CB  ASN A  56     -10.235  33.714  24.596  1.00  0.00           C  
ATOM    821  CG  ASN A  56     -11.599  34.354  24.861  1.00  0.00           C  
ATOM    822  OD1 ASN A  56     -12.294  34.027  25.810  1.00  0.00           O  
ATOM    823  ND2 ASN A  56     -11.943  35.282  23.973  1.00  0.00           N  
ATOM    824  H   ASN A  56      -8.316  33.190  26.508  1.00  0.00           H  
ATOM    825  HA  ASN A  56     -10.959  32.126  25.886  1.00  0.00           H  
ATOM    826  HB2 ASN A  56      -9.447  34.449  24.759  1.00  0.00           H  
ATOM    827  HB3 ASN A  56     -10.173  33.404  23.553  1.00  0.00           H  
ATOM    828 HD21 ASN A  56     -11.327  35.504  23.218  1.00  0.00           H  
ATOM    829 HD22 ASN A  56     -12.818  35.759  24.062  1.00  0.00           H  
ATOM    830  N   LEU A  57      -9.940  30.394  24.347  1.00  0.00           N  
ATOM    831  CA  LEU A  57      -9.332  29.315  23.588  1.00  0.00           C  
ATOM    832  C   LEU A  57      -9.577  29.545  22.095  1.00  0.00           C  
ATOM    833  O   LEU A  57     -10.698  29.387  21.615  1.00  0.00           O  
ATOM    834  CB  LEU A  57      -9.830  27.959  24.091  1.00  0.00           C  
ATOM    835  CG  LEU A  57      -9.144  26.728  23.494  1.00  0.00           C  
ATOM    836  CD1 LEU A  57      -7.724  26.573  24.042  1.00  0.00           C  
ATOM    837  CD2 LEU A  57      -9.985  25.469  23.716  1.00  0.00           C  
ATOM    838  H   LEU A  57     -10.909  30.267  24.560  1.00  0.00           H  
ATOM    839  HA  LEU A  57      -8.258  29.351  23.771  1.00  0.00           H  
ATOM    840  HB2 LEU A  57      -9.710  27.928  25.174  1.00  0.00           H  
ATOM    841  HB3 LEU A  57     -10.898  27.888  23.887  1.00  0.00           H  
ATOM    842  HG  LEU A  57      -9.059  26.872  22.417  1.00  0.00           H  
ATOM    843 HD11 LEU A  57      -7.748  25.970  24.950  1.00  0.00           H  
ATOM    844 HD12 LEU A  57      -7.098  26.082  23.297  1.00  0.00           H  
ATOM    845 HD13 LEU A  57      -7.313  27.557  24.270  1.00  0.00           H  
ATOM    846 HD21 LEU A  57     -10.563  25.576  24.635  1.00  0.00           H  
ATOM    847 HD22 LEU A  57     -10.662  25.332  22.874  1.00  0.00           H  
ATOM    848 HD23 LEU A  57      -9.328  24.604  23.800  1.00  0.00           H  
ATOM    849  N   ASN A  58      -8.510  29.916  21.403  1.00  0.00           N  
ATOM    850  CA  ASN A  58      -8.595  30.171  19.976  1.00  0.00           C  
ATOM    851  C   ASN A  58      -7.834  29.079  19.221  1.00  0.00           C  
ATOM    852  O   ASN A  58      -6.679  28.793  19.534  1.00  0.00           O  
ATOM    853  CB  ASN A  58      -7.967  31.519  19.617  1.00  0.00           C  
ATOM    854  CG  ASN A  58      -8.339  32.588  20.646  1.00  0.00           C  
ATOM    855  OD1 ASN A  58      -9.303  32.467  21.385  1.00  0.00           O  
ATOM    856  ND2 ASN A  58      -7.525  33.639  20.654  1.00  0.00           N  
ATOM    857  H   ASN A  58      -7.601  30.043  21.802  1.00  0.00           H  
ATOM    858  HA  ASN A  58      -9.661  30.170  19.748  1.00  0.00           H  
ATOM    859  HB2 ASN A  58      -6.883  31.417  19.569  1.00  0.00           H  
ATOM    860  HB3 ASN A  58      -8.302  31.829  18.628  1.00  0.00           H  
ATOM    861 HD21 ASN A  58      -6.751  33.676  20.022  1.00  0.00           H  
ATOM    862 HD22 ASN A  58      -7.685  34.392  21.292  1.00  0.00           H  
ATOM    863  N   PHE A  59      -8.511  28.498  18.242  1.00  0.00           N  
ATOM    864  CA  PHE A  59      -7.913  27.444  17.440  1.00  0.00           C  
ATOM    865  C   PHE A  59      -7.651  27.923  16.011  1.00  0.00           C  
ATOM    866  O   PHE A  59      -8.478  28.622  15.425  1.00  0.00           O  
ATOM    867  CB  PHE A  59      -8.915  26.288  17.402  1.00  0.00           C  
ATOM    868  CG  PHE A  59     -10.344  26.714  17.059  1.00  0.00           C  
ATOM    869  CD1 PHE A  59     -11.172  27.165  18.038  1.00  0.00           C  
ATOM    870  CD2 PHE A  59     -10.785  26.642  15.774  1.00  0.00           C  
ATOM    871  CE1 PHE A  59     -12.499  27.561  17.720  1.00  0.00           C  
ATOM    872  CE2 PHE A  59     -12.111  27.038  15.456  1.00  0.00           C  
ATOM    873  CZ  PHE A  59     -12.940  27.489  16.435  1.00  0.00           C  
ATOM    874  H   PHE A  59      -9.451  28.736  17.994  1.00  0.00           H  
ATOM    875  HA  PHE A  59      -6.967  27.177  17.912  1.00  0.00           H  
ATOM    876  HB2 PHE A  59      -8.580  25.554  16.669  1.00  0.00           H  
ATOM    877  HB3 PHE A  59      -8.918  25.791  18.372  1.00  0.00           H  
ATOM    878  HD1 PHE A  59     -10.819  27.224  19.067  1.00  0.00           H  
ATOM    879  HD2 PHE A  59     -10.120  26.280  14.989  1.00  0.00           H  
ATOM    880  HE1 PHE A  59     -13.163  27.923  18.505  1.00  0.00           H  
ATOM    881  HE2 PHE A  59     -12.465  26.979  14.427  1.00  0.00           H  
ATOM    882  HZ  PHE A  59     -13.958  27.793  16.191  1.00  0.00           H  
ATOM    883  N   TYR A  60      -6.497  27.530  15.491  1.00  0.00           N  
ATOM    884  CA  TYR A  60      -6.116  27.910  14.143  1.00  0.00           C  
ATOM    885  C   TYR A  60      -6.006  26.682  13.236  1.00  0.00           C  
ATOM    886  O   TYR A  60      -6.140  25.551  13.700  1.00  0.00           O  
ATOM    887  CB  TYR A  60      -4.739  28.566  14.263  1.00  0.00           C  
ATOM    888  CG  TYR A  60      -4.725  29.835  15.116  1.00  0.00           C  
ATOM    889  CD1 TYR A  60      -4.998  29.761  16.467  1.00  0.00           C  
ATOM    890  CD2 TYR A  60      -4.441  31.055  14.536  1.00  0.00           C  
ATOM    891  CE1 TYR A  60      -4.985  30.956  17.270  1.00  0.00           C  
ATOM    892  CE2 TYR A  60      -4.429  32.250  15.339  1.00  0.00           C  
ATOM    893  CZ  TYR A  60      -4.701  32.142  16.667  1.00  0.00           C  
ATOM    894  OH  TYR A  60      -4.690  33.270  17.425  1.00  0.00           O  
ATOM    895  H   TYR A  60      -5.831  26.962  15.974  1.00  0.00           H  
ATOM    896  HA  TYR A  60      -6.886  28.575  13.750  1.00  0.00           H  
ATOM    897  HB2 TYR A  60      -4.040  27.845  14.691  1.00  0.00           H  
ATOM    898  HB3 TYR A  60      -4.374  28.808  13.265  1.00  0.00           H  
ATOM    899  HD1 TYR A  60      -5.222  28.799  16.926  1.00  0.00           H  
ATOM    900  HD2 TYR A  60      -4.225  31.113  13.468  1.00  0.00           H  
ATOM    901  HE1 TYR A  60      -5.200  30.913  18.339  1.00  0.00           H  
ATOM    902  HE2 TYR A  60      -4.205  33.218  14.893  1.00  0.00           H  
ATOM    903  HH  TYR A  60      -3.897  33.265  18.034  1.00  0.00           H  
ATOM    904  N   LYS A  61      -5.763  26.948  11.961  1.00  0.00           N  
ATOM    905  CA  LYS A  61      -5.634  25.878  10.986  1.00  0.00           C  
ATOM    906  C   LYS A  61      -4.332  25.115  11.243  1.00  0.00           C  
ATOM    907  O   LYS A  61      -4.252  23.914  10.985  1.00  0.00           O  
ATOM    908  CB  LYS A  61      -5.750  26.433   9.565  1.00  0.00           C  
ATOM    909  CG  LYS A  61      -4.445  27.102   9.128  1.00  0.00           C  
ATOM    910  CD  LYS A  61      -4.721  28.289   8.202  1.00  0.00           C  
ATOM    911  CE  LYS A  61      -3.418  28.978   7.791  1.00  0.00           C  
ATOM    912  NZ  LYS A  61      -3.589  30.447   7.784  1.00  0.00           N  
ATOM    913  H   LYS A  61      -5.655  27.872  11.593  1.00  0.00           H  
ATOM    914  HA  LYS A  61      -6.471  25.196  11.136  1.00  0.00           H  
ATOM    915  HB2 LYS A  61      -5.999  25.626   8.875  1.00  0.00           H  
ATOM    916  HB3 LYS A  61      -6.566  27.153   9.517  1.00  0.00           H  
ATOM    917  HG2 LYS A  61      -3.895  27.440  10.005  1.00  0.00           H  
ATOM    918  HG3 LYS A  61      -3.814  26.375   8.615  1.00  0.00           H  
ATOM    919  HD2 LYS A  61      -5.251  27.946   7.313  1.00  0.00           H  
ATOM    920  HD3 LYS A  61      -5.372  29.004   8.706  1.00  0.00           H  
ATOM    921  HE2 LYS A  61      -2.621  28.701   8.481  1.00  0.00           H  
ATOM    922  HE3 LYS A  61      -3.116  28.635   6.801  1.00  0.00           H  
ATOM    923  HZ1 LYS A  61      -2.942  30.855   7.140  1.00  0.00           H  
ATOM    924  HZ2 LYS A  61      -4.522  30.673   7.507  1.00  0.00           H  
ATOM    925  HZ3 LYS A  61      -3.418  30.807   8.701  1.00  0.00           H  
ATOM    926  N   ASP A  62      -3.347  25.841  11.748  1.00  0.00           N  
ATOM    927  CA  ASP A  62      -2.054  25.246  12.042  1.00  0.00           C  
ATOM    928  C   ASP A  62      -1.504  25.849  13.337  1.00  0.00           C  
ATOM    929  O   ASP A  62      -2.252  26.424  14.126  1.00  0.00           O  
ATOM    930  CB  ASP A  62      -1.049  25.531  10.925  1.00  0.00           C  
ATOM    931  CG  ASP A  62      -1.661  25.704   9.533  1.00  0.00           C  
ATOM    932  OD1 ASP A  62      -2.195  24.696   9.020  1.00  0.00           O  
ATOM    933  OD2 ASP A  62      -1.581  26.838   9.014  1.00  0.00           O  
ATOM    934  H   ASP A  62      -3.420  26.817  11.955  1.00  0.00           H  
ATOM    935  HA  ASP A  62      -2.244  24.177  12.128  1.00  0.00           H  
ATOM    936  HB2 ASP A  62      -0.495  26.436  11.176  1.00  0.00           H  
ATOM    937  HB3 ASP A  62      -0.327  24.716  10.890  1.00  0.00           H  
ATOM    938  N   GLU A  63      -0.201  25.694  13.517  1.00  0.00           N  
ATOM    939  CA  GLU A  63       0.458  26.215  14.702  1.00  0.00           C  
ATOM    940  C   GLU A  63       0.706  27.718  14.555  1.00  0.00           C  
ATOM    941  O   GLU A  63       0.683  28.454  15.540  1.00  0.00           O  
ATOM    942  CB  GLU A  63       1.765  25.469  14.976  1.00  0.00           C  
ATOM    943  CG  GLU A  63       1.532  23.958  15.035  1.00  0.00           C  
ATOM    944  CD  GLU A  63       2.773  23.193  14.573  1.00  0.00           C  
ATOM    945  OE1 GLU A  63       3.393  23.656  13.592  1.00  0.00           O  
ATOM    946  OE2 GLU A  63       3.074  22.160  15.212  1.00  0.00           O  
ATOM    947  H   GLU A  63       0.401  25.225  12.872  1.00  0.00           H  
ATOM    948  HA  GLU A  63      -0.236  26.034  15.523  1.00  0.00           H  
ATOM    949  HB2 GLU A  63       2.490  25.697  14.195  1.00  0.00           H  
ATOM    950  HB3 GLU A  63       2.194  25.812  15.918  1.00  0.00           H  
ATOM    951  HG2 GLU A  63       1.278  23.665  16.055  1.00  0.00           H  
ATOM    952  HG3 GLU A  63       0.682  23.693  14.406  1.00  0.00           H  
ATOM    953  N   LYS A  64       0.936  28.128  13.317  1.00  0.00           N  
ATOM    954  CA  LYS A  64       1.188  29.531  13.028  1.00  0.00           C  
ATOM    955  C   LYS A  64      -0.056  30.350  13.377  1.00  0.00           C  
ATOM    956  O   LYS A  64      -1.004  30.410  12.596  1.00  0.00           O  
ATOM    957  CB  LYS A  64       1.652  29.704  11.581  1.00  0.00           C  
ATOM    958  CG  LYS A  64       2.867  28.822  11.285  1.00  0.00           C  
ATOM    959  CD  LYS A  64       3.903  29.579  10.450  1.00  0.00           C  
ATOM    960  CE  LYS A  64       4.943  30.253  11.347  1.00  0.00           C  
ATOM    961  NZ  LYS A  64       6.200  29.471  11.363  1.00  0.00           N  
ATOM    962  H   LYS A  64       0.953  27.523  12.521  1.00  0.00           H  
ATOM    963  HA  LYS A  64       2.006  29.855  13.670  1.00  0.00           H  
ATOM    964  HB2 LYS A  64       0.840  29.450  10.900  1.00  0.00           H  
ATOM    965  HB3 LYS A  64       1.904  30.749  11.398  1.00  0.00           H  
ATOM    966  HG2 LYS A  64       3.319  28.494  12.221  1.00  0.00           H  
ATOM    967  HG3 LYS A  64       2.550  27.926  10.753  1.00  0.00           H  
ATOM    968  HD2 LYS A  64       4.400  28.887   9.768  1.00  0.00           H  
ATOM    969  HD3 LYS A  64       3.404  30.329   9.837  1.00  0.00           H  
ATOM    970  HE2 LYS A  64       5.141  31.263  10.988  1.00  0.00           H  
ATOM    971  HE3 LYS A  64       4.553  30.346  12.360  1.00  0.00           H  
ATOM    972  HZ1 LYS A  64       6.460  29.240  10.426  1.00  0.00           H  
ATOM    973  HZ2 LYS A  64       6.925  30.014  11.786  1.00  0.00           H  
ATOM    974  HZ3 LYS A  64       6.062  28.631  11.888  1.00  0.00           H  
ATOM    975  N   ILE A  65      -0.013  30.960  14.552  1.00  0.00           N  
ATOM    976  CA  ILE A  65      -1.125  31.774  15.014  1.00  0.00           C  
ATOM    977  C   ILE A  65      -0.836  33.245  14.710  1.00  0.00           C  
ATOM    978  O   ILE A  65      -0.272  33.568  13.665  1.00  0.00           O  
ATOM    979  CB  ILE A  65      -1.415  31.497  16.490  1.00  0.00           C  
ATOM    980  CG1 ILE A  65      -0.271  31.996  17.376  1.00  0.00           C  
ATOM    981  CG2 ILE A  65      -1.712  30.014  16.722  1.00  0.00           C  
ATOM    982  CD1 ILE A  65       0.001  31.019  18.522  1.00  0.00           C  
ATOM    983  H   ILE A  65       0.762  30.907  15.182  1.00  0.00           H  
ATOM    984  HA  ILE A  65      -2.007  31.471  14.450  1.00  0.00           H  
ATOM    985  HB  ILE A  65      -2.308  32.053  16.774  1.00  0.00           H  
ATOM    986 HG12 ILE A  65       0.630  32.120  16.777  1.00  0.00           H  
ATOM    987 HG13 ILE A  65      -0.523  32.976  17.782  1.00  0.00           H  
ATOM    988 HG21 ILE A  65      -2.266  29.618  15.870  1.00  0.00           H  
ATOM    989 HG22 ILE A  65      -0.777  29.467  16.832  1.00  0.00           H  
ATOM    990 HG23 ILE A  65      -2.309  29.900  17.627  1.00  0.00           H  
ATOM    991 HD11 ILE A  65       0.574  30.170  18.147  1.00  0.00           H  
ATOM    992 HD12 ILE A  65       0.569  31.524  19.303  1.00  0.00           H  
ATOM    993 HD13 ILE A  65      -0.945  30.666  18.932  1.00  0.00           H  
ATOM    994  N   SER A  66      -1.235  34.099  15.641  1.00  0.00           N  
ATOM    995  CA  SER A  66      -1.026  35.528  15.486  1.00  0.00           C  
ATOM    996  C   SER A  66      -2.123  36.124  14.600  1.00  0.00           C  
ATOM    997  O   SER A  66      -2.748  37.118  14.965  1.00  0.00           O  
ATOM    998  CB  SER A  66       0.353  35.822  14.893  1.00  0.00           C  
ATOM    999  OG  SER A  66       0.852  37.092  15.304  1.00  0.00           O  
ATOM   1000  H   SER A  66      -1.693  33.828  16.489  1.00  0.00           H  
ATOM   1001  HA  SER A  66      -1.083  35.940  16.494  1.00  0.00           H  
ATOM   1002  HB2 SER A  66       1.052  35.043  15.198  1.00  0.00           H  
ATOM   1003  HB3 SER A  66       0.294  35.789  13.805  1.00  0.00           H  
ATOM   1004  HG  SER A  66       0.693  37.770  14.585  1.00  0.00           H  
ATOM   1005  N   LYS A  67      -2.321  35.491  13.454  1.00  0.00           N  
ATOM   1006  CA  LYS A  67      -3.331  35.947  12.513  1.00  0.00           C  
ATOM   1007  C   LYS A  67      -4.720  35.618  13.065  1.00  0.00           C  
ATOM   1008  O   LYS A  67      -4.853  35.204  14.215  1.00  0.00           O  
ATOM   1009  CB  LYS A  67      -3.069  35.366  11.122  1.00  0.00           C  
ATOM   1010  CG  LYS A  67      -1.684  35.770  10.612  1.00  0.00           C  
ATOM   1011  CD  LYS A  67      -1.699  35.985   9.098  1.00  0.00           C  
ATOM   1012  CE  LYS A  67      -0.335  35.664   8.484  1.00  0.00           C  
ATOM   1013  NZ  LYS A  67      -0.434  34.493   7.584  1.00  0.00           N  
ATOM   1014  H   LYS A  67      -1.808  34.683  13.165  1.00  0.00           H  
ATOM   1015  HA  LYS A  67      -3.238  37.030  12.434  1.00  0.00           H  
ATOM   1016  HB2 LYS A  67      -3.144  34.279  11.157  1.00  0.00           H  
ATOM   1017  HB3 LYS A  67      -3.833  35.716  10.428  1.00  0.00           H  
ATOM   1018  HG2 LYS A  67      -1.362  36.685  11.109  1.00  0.00           H  
ATOM   1019  HG3 LYS A  67      -0.959  34.997  10.866  1.00  0.00           H  
ATOM   1020  HD2 LYS A  67      -2.463  35.353   8.644  1.00  0.00           H  
ATOM   1021  HD3 LYS A  67      -1.967  37.018   8.876  1.00  0.00           H  
ATOM   1022  HE2 LYS A  67       0.034  36.527   7.929  1.00  0.00           H  
ATOM   1023  HE3 LYS A  67       0.388  35.461   9.275  1.00  0.00           H  
ATOM   1024  HZ1 LYS A  67      -0.699  33.687   8.113  1.00  0.00           H  
ATOM   1025  HZ2 LYS A  67      -1.122  34.672   6.881  1.00  0.00           H  
ATOM   1026  HZ3 LYS A  67       0.452  34.331   7.150  1.00  0.00           H  
ATOM   1027  N   GLU A  68      -5.720  35.815  12.217  1.00  0.00           N  
ATOM   1028  CA  GLU A  68      -7.093  35.545  12.605  1.00  0.00           C  
ATOM   1029  C   GLU A  68      -7.337  34.036  12.682  1.00  0.00           C  
ATOM   1030  O   GLU A  68      -7.182  33.327  11.688  1.00  0.00           O  
ATOM   1031  CB  GLU A  68      -8.077  36.209  11.639  1.00  0.00           C  
ATOM   1032  CG  GLU A  68      -8.190  37.710  11.920  1.00  0.00           C  
ATOM   1033  CD  GLU A  68      -9.625  38.199  11.715  1.00  0.00           C  
ATOM   1034  OE1 GLU A  68     -10.528  37.572  12.310  1.00  0.00           O  
ATOM   1035  OE2 GLU A  68      -9.787  39.188  10.970  1.00  0.00           O  
ATOM   1036  H   GLU A  68      -5.603  36.151  11.283  1.00  0.00           H  
ATOM   1037  HA  GLU A  68      -7.208  35.988  13.594  1.00  0.00           H  
ATOM   1038  HB2 GLU A  68      -7.747  36.052  10.613  1.00  0.00           H  
ATOM   1039  HB3 GLU A  68      -9.057  35.744  11.735  1.00  0.00           H  
ATOM   1040  HG2 GLU A  68      -7.873  37.918  12.941  1.00  0.00           H  
ATOM   1041  HG3 GLU A  68      -7.518  38.258  11.259  1.00  0.00           H  
ATOM   1042  N   PRO A  69      -7.724  33.577  13.902  1.00  0.00           N  
ATOM   1043  CA  PRO A  69      -7.990  32.166  14.122  1.00  0.00           C  
ATOM   1044  C   PRO A  69      -9.329  31.758  13.506  1.00  0.00           C  
ATOM   1045  O   PRO A  69     -10.090  32.609  13.046  1.00  0.00           O  
ATOM   1046  CB  PRO A  69      -7.951  31.989  15.631  1.00  0.00           C  
ATOM   1047  CG  PRO A  69      -8.127  33.379  16.219  1.00  0.00           C  
ATOM   1048  CD  PRO A  69      -7.917  34.387  15.102  1.00  0.00           C  
ATOM   1049  HA  PRO A  69      -7.297  31.607  13.665  1.00  0.00           H  
ATOM   1050  HB2 PRO A  69      -8.743  31.320  15.966  1.00  0.00           H  
ATOM   1051  HB3 PRO A  69      -7.006  31.547  15.949  1.00  0.00           H  
ATOM   1052  HG2 PRO A  69      -9.122  33.488  16.650  1.00  0.00           H  
ATOM   1053  HG3 PRO A  69      -7.412  33.547  17.024  1.00  0.00           H  
ATOM   1054  HD2 PRO A  69      -8.777  35.049  14.998  1.00  0.00           H  
ATOM   1055  HD3 PRO A  69      -7.050  35.020  15.296  1.00  0.00           H  
ATOM   1056  N   LYS A  70      -9.577  30.457  13.516  1.00  0.00           N  
ATOM   1057  CA  LYS A  70     -10.812  29.926  12.964  1.00  0.00           C  
ATOM   1058  C   LYS A  70     -11.978  30.301  13.881  1.00  0.00           C  
ATOM   1059  O   LYS A  70     -13.107  30.464  13.420  1.00  0.00           O  
ATOM   1060  CB  LYS A  70     -10.685  28.422  12.715  1.00  0.00           C  
ATOM   1061  CG  LYS A  70      -9.431  28.106  11.896  1.00  0.00           C  
ATOM   1062  CD  LYS A  70      -9.796  27.733  10.458  1.00  0.00           C  
ATOM   1063  CE  LYS A  70      -9.240  28.758   9.467  1.00  0.00           C  
ATOM   1064  NZ  LYS A  70     -10.102  28.842   8.268  1.00  0.00           N  
ATOM   1065  H   LYS A  70      -8.953  29.771  13.891  1.00  0.00           H  
ATOM   1066  HA  LYS A  70     -10.968  30.401  11.996  1.00  0.00           H  
ATOM   1067  HB2 LYS A  70     -10.644  27.894  13.667  1.00  0.00           H  
ATOM   1068  HB3 LYS A  70     -11.568  28.061  12.189  1.00  0.00           H  
ATOM   1069  HG2 LYS A  70      -8.767  28.970  11.894  1.00  0.00           H  
ATOM   1070  HG3 LYS A  70      -8.886  27.285  12.362  1.00  0.00           H  
ATOM   1071  HD2 LYS A  70      -9.401  26.744  10.223  1.00  0.00           H  
ATOM   1072  HD3 LYS A  70     -10.880  27.675  10.357  1.00  0.00           H  
ATOM   1073  HE2 LYS A  70      -9.175  29.736   9.946  1.00  0.00           H  
ATOM   1074  HE3 LYS A  70      -8.227  28.478   9.176  1.00  0.00           H  
ATOM   1075  HZ1 LYS A  70     -10.354  27.920   7.973  1.00  0.00           H  
ATOM   1076  HZ2 LYS A  70     -10.930  29.359   8.488  1.00  0.00           H  
ATOM   1077  HZ3 LYS A  70      -9.607  29.304   7.533  1.00  0.00           H  
ATOM   1078  N   GLY A  71     -11.665  30.427  15.163  1.00  0.00           N  
ATOM   1079  CA  GLY A  71     -12.672  30.779  16.148  1.00  0.00           C  
ATOM   1080  C   GLY A  71     -12.068  30.839  17.553  1.00  0.00           C  
ATOM   1081  O   GLY A  71     -10.914  30.465  17.752  1.00  0.00           O  
ATOM   1082  H   GLY A  71     -10.744  30.292  15.529  1.00  0.00           H  
ATOM   1083  HA2 GLY A  71     -13.111  31.745  15.895  1.00  0.00           H  
ATOM   1084  HA3 GLY A  71     -13.480  30.047  16.126  1.00  0.00           H  
ATOM   1085  N   SER A  72     -12.877  31.311  18.490  1.00  0.00           N  
ATOM   1086  CA  SER A  72     -12.437  31.425  19.870  1.00  0.00           C  
ATOM   1087  C   SER A  72     -13.559  30.991  20.815  1.00  0.00           C  
ATOM   1088  O   SER A  72     -14.719  31.350  20.612  1.00  0.00           O  
ATOM   1089  CB  SER A  72     -11.994  32.854  20.191  1.00  0.00           C  
ATOM   1090  OG  SER A  72     -12.733  33.821  19.451  1.00  0.00           O  
ATOM   1091  H   SER A  72     -13.815  31.613  18.319  1.00  0.00           H  
ATOM   1092  HA  SER A  72     -11.584  30.752  19.957  1.00  0.00           H  
ATOM   1093  HB2 SER A  72     -12.120  33.041  21.258  1.00  0.00           H  
ATOM   1094  HB3 SER A  72     -10.932  32.962  19.971  1.00  0.00           H  
ATOM   1095  HG  SER A  72     -12.469  34.743  19.734  1.00  0.00           H  
ATOM   1096  N   ILE A  73     -13.176  30.227  21.827  1.00  0.00           N  
ATOM   1097  CA  ILE A  73     -14.137  29.742  22.803  1.00  0.00           C  
ATOM   1098  C   ILE A  73     -14.098  30.641  24.040  1.00  0.00           C  
ATOM   1099  O   ILE A  73     -13.057  30.774  24.683  1.00  0.00           O  
ATOM   1100  CB  ILE A  73     -13.890  28.263  23.109  1.00  0.00           C  
ATOM   1101  CG1 ILE A  73     -14.095  27.403  21.861  1.00  0.00           C  
ATOM   1102  CG2 ILE A  73     -14.755  27.793  24.279  1.00  0.00           C  
ATOM   1103  CD1 ILE A  73     -12.995  26.347  21.734  1.00  0.00           C  
ATOM   1104  H   ILE A  73     -12.232  29.940  21.985  1.00  0.00           H  
ATOM   1105  HA  ILE A  73     -15.126  29.816  22.353  1.00  0.00           H  
ATOM   1106  HB  ILE A  73     -12.848  28.147  23.412  1.00  0.00           H  
ATOM   1107 HG12 ILE A  73     -15.069  26.915  21.908  1.00  0.00           H  
ATOM   1108 HG13 ILE A  73     -14.099  28.037  20.975  1.00  0.00           H  
ATOM   1109 HG21 ILE A  73     -14.596  26.727  24.443  1.00  0.00           H  
ATOM   1110 HG22 ILE A  73     -14.481  28.344  25.178  1.00  0.00           H  
ATOM   1111 HG23 ILE A  73     -15.805  27.973  24.049  1.00  0.00           H  
ATOM   1112 HD11 ILE A  73     -12.146  26.631  22.357  1.00  0.00           H  
ATOM   1113 HD12 ILE A  73     -13.378  25.381  22.062  1.00  0.00           H  
ATOM   1114 HD13 ILE A  73     -12.676  26.278  20.695  1.00  0.00           H  
ATOM   1115  N   PHE A  74     -15.245  31.235  24.338  1.00  0.00           N  
ATOM   1116  CA  PHE A  74     -15.355  32.117  25.487  1.00  0.00           C  
ATOM   1117  C   PHE A  74     -15.416  31.316  26.788  1.00  0.00           C  
ATOM   1118  O   PHE A  74     -16.477  31.196  27.399  1.00  0.00           O  
ATOM   1119  CB  PHE A  74     -16.658  32.903  25.324  1.00  0.00           C  
ATOM   1120  CG  PHE A  74     -16.815  33.571  23.956  1.00  0.00           C  
ATOM   1121  CD1 PHE A  74     -15.745  34.164  23.362  1.00  0.00           C  
ATOM   1122  CD2 PHE A  74     -18.025  33.572  23.334  1.00  0.00           C  
ATOM   1123  CE1 PHE A  74     -15.890  34.783  22.093  1.00  0.00           C  
ATOM   1124  CE2 PHE A  74     -18.170  34.192  22.066  1.00  0.00           C  
ATOM   1125  CZ  PHE A  74     -17.100  34.785  21.472  1.00  0.00           C  
ATOM   1126  H   PHE A  74     -16.087  31.120  23.809  1.00  0.00           H  
ATOM   1127  HA  PHE A  74     -14.469  32.751  25.493  1.00  0.00           H  
ATOM   1128  HB2 PHE A  74     -17.499  32.229  25.486  1.00  0.00           H  
ATOM   1129  HB3 PHE A  74     -16.708  33.668  26.098  1.00  0.00           H  
ATOM   1130  HD1 PHE A  74     -14.776  34.163  23.860  1.00  0.00           H  
ATOM   1131  HD2 PHE A  74     -18.883  33.097  23.811  1.00  0.00           H  
ATOM   1132  HE1 PHE A  74     -15.032  35.259  21.617  1.00  0.00           H  
ATOM   1133  HE2 PHE A  74     -19.140  34.193  21.567  1.00  0.00           H  
ATOM   1134  HZ  PHE A  74     -17.212  35.261  20.497  1.00  0.00           H  
ATOM   1135  N   LEU A  75     -14.264  30.791  27.177  1.00  0.00           N  
ATOM   1136  CA  LEU A  75     -14.172  30.004  28.396  1.00  0.00           C  
ATOM   1137  C   LEU A  75     -14.896  30.739  29.526  1.00  0.00           C  
ATOM   1138  O   LEU A  75     -15.432  30.109  30.436  1.00  0.00           O  
ATOM   1139  CB  LEU A  75     -12.712  29.676  28.712  1.00  0.00           C  
ATOM   1140  CG  LEU A  75     -11.824  29.341  27.512  1.00  0.00           C  
ATOM   1141  CD1 LEU A  75     -10.466  28.804  27.968  1.00  0.00           C  
ATOM   1142  CD2 LEU A  75     -12.531  28.375  26.559  1.00  0.00           C  
ATOM   1143  H   LEU A  75     -13.405  30.893  26.676  1.00  0.00           H  
ATOM   1144  HA  LEU A  75     -14.683  29.059  28.215  1.00  0.00           H  
ATOM   1145  HB2 LEU A  75     -12.274  30.524  29.238  1.00  0.00           H  
ATOM   1146  HB3 LEU A  75     -12.692  28.830  29.401  1.00  0.00           H  
ATOM   1147  HG  LEU A  75     -11.637  30.261  26.959  1.00  0.00           H  
ATOM   1148 HD11 LEU A  75      -9.680  29.221  27.337  1.00  0.00           H  
ATOM   1149 HD12 LEU A  75     -10.290  29.093  29.005  1.00  0.00           H  
ATOM   1150 HD13 LEU A  75     -10.459  27.718  27.887  1.00  0.00           H  
ATOM   1151 HD21 LEU A  75     -11.967  27.445  26.500  1.00  0.00           H  
ATOM   1152 HD22 LEU A  75     -13.535  28.170  26.929  1.00  0.00           H  
ATOM   1153 HD23 LEU A  75     -12.595  28.826  25.568  1.00  0.00           H  
ATOM   1154  N   ASP A  76     -14.888  32.060  29.431  1.00  0.00           N  
ATOM   1155  CA  ASP A  76     -15.538  32.887  30.434  1.00  0.00           C  
ATOM   1156  C   ASP A  76     -16.992  32.441  30.593  1.00  0.00           C  
ATOM   1157  O   ASP A  76     -17.604  32.668  31.635  1.00  0.00           O  
ATOM   1158  CB  ASP A  76     -15.538  34.360  30.019  1.00  0.00           C  
ATOM   1159  CG  ASP A  76     -16.375  35.282  30.906  1.00  0.00           C  
ATOM   1160  OD1 ASP A  76     -16.658  34.865  32.051  1.00  0.00           O  
ATOM   1161  OD2 ASP A  76     -16.715  36.382  30.421  1.00  0.00           O  
ATOM   1162  H   ASP A  76     -14.449  32.564  28.687  1.00  0.00           H  
ATOM   1163  HA  ASP A  76     -14.955  32.743  31.344  1.00  0.00           H  
ATOM   1164  HB2 ASP A  76     -14.509  34.720  30.014  1.00  0.00           H  
ATOM   1165  HB3 ASP A  76     -15.906  34.432  28.995  1.00  0.00           H  
ATOM   1166  N   SER A  77     -17.503  31.813  29.544  1.00  0.00           N  
ATOM   1167  CA  SER A  77     -18.874  31.332  29.554  1.00  0.00           C  
ATOM   1168  C   SER A  77     -18.896  29.817  29.761  1.00  0.00           C  
ATOM   1169  O   SER A  77     -19.824  29.283  30.366  1.00  0.00           O  
ATOM   1170  CB  SER A  77     -19.597  31.702  28.256  1.00  0.00           C  
ATOM   1171  OG  SER A  77     -19.898  33.093  28.191  1.00  0.00           O  
ATOM   1172  H   SER A  77     -16.998  31.632  28.700  1.00  0.00           H  
ATOM   1173  HA  SER A  77     -19.352  31.840  30.392  1.00  0.00           H  
ATOM   1174  HB2 SER A  77     -18.975  31.425  27.405  1.00  0.00           H  
ATOM   1175  HB3 SER A  77     -20.519  31.126  28.179  1.00  0.00           H  
ATOM   1176  HG  SER A  77     -19.592  33.468  27.317  1.00  0.00           H  
ATOM   1177  N   CYS A  78     -17.863  29.166  29.246  1.00  0.00           N  
ATOM   1178  CA  CYS A  78     -17.752  27.723  29.366  1.00  0.00           C  
ATOM   1179  C   CYS A  78     -18.220  27.320  30.766  1.00  0.00           C  
ATOM   1180  O   CYS A  78     -17.748  27.863  31.764  1.00  0.00           O  
ATOM   1181  CB  CYS A  78     -16.328  27.239  29.079  1.00  0.00           C  
ATOM   1182  SG  CYS A  78     -16.243  25.418  29.239  1.00  0.00           S  
ATOM   1183  H   CYS A  78     -17.112  29.608  28.754  1.00  0.00           H  
ATOM   1184  HA  CYS A  78     -18.400  27.294  28.602  1.00  0.00           H  
ATOM   1185  HB2 CYS A  78     -16.029  27.539  28.076  1.00  0.00           H  
ATOM   1186  HB3 CYS A  78     -15.630  27.706  29.774  1.00  0.00           H  
ATOM   1187  HG  CYS A  78     -15.196  25.257  28.434  1.00  0.00           H  
ATOM   1188  N   MET A  79     -19.145  26.371  30.795  1.00  0.00           N  
ATOM   1189  CA  MET A  79     -19.683  25.889  32.056  1.00  0.00           C  
ATOM   1190  C   MET A  79     -18.769  24.828  32.672  1.00  0.00           C  
ATOM   1191  O   MET A  79     -18.496  24.860  33.871  1.00  0.00           O  
ATOM   1192  CB  MET A  79     -21.073  25.294  31.824  1.00  0.00           C  
ATOM   1193  CG  MET A  79     -21.932  26.226  30.967  1.00  0.00           C  
ATOM   1194  SD  MET A  79     -23.570  26.360  31.666  1.00  0.00           S  
ATOM   1195  CE  MET A  79     -23.315  27.718  32.795  1.00  0.00           C  
ATOM   1196  H   MET A  79     -19.524  25.934  29.980  1.00  0.00           H  
ATOM   1197  HA  MET A  79     -19.728  26.762  32.707  1.00  0.00           H  
ATOM   1198  HB2 MET A  79     -20.980  24.326  31.333  1.00  0.00           H  
ATOM   1199  HB3 MET A  79     -21.563  25.120  32.782  1.00  0.00           H  
ATOM   1200  HG2 MET A  79     -21.470  27.212  30.912  1.00  0.00           H  
ATOM   1201  HG3 MET A  79     -21.993  25.845  29.949  1.00  0.00           H  
ATOM   1202  HE1 MET A  79     -23.571  28.655  32.301  1.00  0.00           H  
ATOM   1203  HE2 MET A  79     -23.948  27.585  33.672  1.00  0.00           H  
ATOM   1204  HE3 MET A  79     -22.270  27.743  33.103  1.00  0.00           H  
ATOM   1205  N   GLY A  80     -18.323  23.913  31.825  1.00  0.00           N  
ATOM   1206  CA  GLY A  80     -17.445  22.844  32.270  1.00  0.00           C  
ATOM   1207  C   GLY A  80     -17.165  21.856  31.136  1.00  0.00           C  
ATOM   1208  O   GLY A  80     -17.838  21.879  30.108  1.00  0.00           O  
ATOM   1209  H   GLY A  80     -18.550  23.895  30.851  1.00  0.00           H  
ATOM   1210  HA2 GLY A  80     -16.507  23.265  32.630  1.00  0.00           H  
ATOM   1211  HA3 GLY A  80     -17.903  22.321  33.110  1.00  0.00           H  
ATOM   1212  N   VAL A  81     -16.171  21.010  31.364  1.00  0.00           N  
ATOM   1213  CA  VAL A  81     -15.794  20.015  30.375  1.00  0.00           C  
ATOM   1214  C   VAL A  81     -16.376  18.658  30.775  1.00  0.00           C  
ATOM   1215  O   VAL A  81     -16.184  18.204  31.902  1.00  0.00           O  
ATOM   1216  CB  VAL A  81     -14.272  19.989  30.213  1.00  0.00           C  
ATOM   1217  CG1 VAL A  81     -13.854  19.006  29.117  1.00  0.00           C  
ATOM   1218  CG2 VAL A  81     -13.727  21.390  29.931  1.00  0.00           C  
ATOM   1219  H   VAL A  81     -15.629  20.998  32.205  1.00  0.00           H  
ATOM   1220  HA  VAL A  81     -16.229  20.316  29.422  1.00  0.00           H  
ATOM   1221  HB  VAL A  81     -13.841  19.645  31.153  1.00  0.00           H  
ATOM   1222 HG11 VAL A  81     -12.795  19.136  28.897  1.00  0.00           H  
ATOM   1223 HG12 VAL A  81     -14.033  17.986  29.456  1.00  0.00           H  
ATOM   1224 HG13 VAL A  81     -14.438  19.197  28.216  1.00  0.00           H  
ATOM   1225 HG21 VAL A  81     -14.556  22.092  29.843  1.00  0.00           H  
ATOM   1226 HG22 VAL A  81     -13.075  21.698  30.747  1.00  0.00           H  
ATOM   1227 HG23 VAL A  81     -13.161  21.379  28.998  1.00  0.00           H  
ATOM   1228  N   VAL A  82     -17.075  18.048  29.830  1.00  0.00           N  
ATOM   1229  CA  VAL A  82     -17.687  16.752  30.070  1.00  0.00           C  
ATOM   1230  C   VAL A  82     -16.871  15.669  29.361  1.00  0.00           C  
ATOM   1231  O   VAL A  82     -15.973  15.975  28.579  1.00  0.00           O  
ATOM   1232  CB  VAL A  82     -19.154  16.776  29.635  1.00  0.00           C  
ATOM   1233  CG1 VAL A  82     -19.963  17.755  30.489  1.00  0.00           C  
ATOM   1234  CG2 VAL A  82     -19.278  17.112  28.148  1.00  0.00           C  
ATOM   1235  H   VAL A  82     -17.227  18.423  28.916  1.00  0.00           H  
ATOM   1236  HA  VAL A  82     -17.656  16.568  31.144  1.00  0.00           H  
ATOM   1237  HB  VAL A  82     -19.565  15.778  29.788  1.00  0.00           H  
ATOM   1238 HG11 VAL A  82     -20.762  17.218  30.999  1.00  0.00           H  
ATOM   1239 HG12 VAL A  82     -19.308  18.219  31.226  1.00  0.00           H  
ATOM   1240 HG13 VAL A  82     -20.393  18.525  29.848  1.00  0.00           H  
ATOM   1241 HG21 VAL A  82     -19.883  16.351  27.653  1.00  0.00           H  
ATOM   1242 HG22 VAL A  82     -19.755  18.086  28.034  1.00  0.00           H  
ATOM   1243 HG23 VAL A  82     -18.286  17.138  27.696  1.00  0.00           H  
ATOM   1244  N   GLN A  83     -17.213  14.424  29.660  1.00  0.00           N  
ATOM   1245  CA  GLN A  83     -16.523  13.294  29.062  1.00  0.00           C  
ATOM   1246  C   GLN A  83     -17.477  12.508  28.160  1.00  0.00           C  
ATOM   1247  O   GLN A  83     -18.413  11.873  28.644  1.00  0.00           O  
ATOM   1248  CB  GLN A  83     -15.914  12.391  30.136  1.00  0.00           C  
ATOM   1249  CG  GLN A  83     -14.453  12.759  30.398  1.00  0.00           C  
ATOM   1250  CD  GLN A  83     -13.573  11.509  30.452  1.00  0.00           C  
ATOM   1251  OE1 GLN A  83     -14.018  10.395  30.228  1.00  0.00           O  
ATOM   1252  NE2 GLN A  83     -12.303  11.754  30.762  1.00  0.00           N  
ATOM   1253  H   GLN A  83     -17.944  14.183  30.298  1.00  0.00           H  
ATOM   1254  HA  GLN A  83     -15.722  13.728  28.463  1.00  0.00           H  
ATOM   1255  HB2 GLN A  83     -16.487  12.481  31.060  1.00  0.00           H  
ATOM   1256  HB3 GLN A  83     -15.979  11.349  29.821  1.00  0.00           H  
ATOM   1257  HG2 GLN A  83     -14.095  13.426  29.612  1.00  0.00           H  
ATOM   1258  HG3 GLN A  83     -14.374  13.305  31.339  1.00  0.00           H  
ATOM   1259 HE21 GLN A  83     -12.003  12.691  30.934  1.00  0.00           H  
ATOM   1260 HE22 GLN A  83     -11.649  10.999  30.822  1.00  0.00           H  
ATOM   1261  N   ASN A  84     -17.206  12.573  26.865  1.00  0.00           N  
ATOM   1262  CA  ASN A  84     -18.028  11.875  25.892  1.00  0.00           C  
ATOM   1263  C   ASN A  84     -17.702  10.381  25.934  1.00  0.00           C  
ATOM   1264  O   ASN A  84     -18.432   9.599  26.543  1.00  0.00           O  
ATOM   1265  CB  ASN A  84     -17.752  12.379  24.474  1.00  0.00           C  
ATOM   1266  CG  ASN A  84     -18.611  13.603  24.150  1.00  0.00           C  
ATOM   1267  OD1 ASN A  84     -19.288  14.160  24.998  1.00  0.00           O  
ATOM   1268  ND2 ASN A  84     -18.545  13.988  22.878  1.00  0.00           N  
ATOM   1269  H   ASN A  84     -16.442  13.091  26.479  1.00  0.00           H  
ATOM   1270  HA  ASN A  84     -19.057  12.086  26.182  1.00  0.00           H  
ATOM   1271  HB2 ASN A  84     -16.697  12.635  24.375  1.00  0.00           H  
ATOM   1272  HB3 ASN A  84     -17.956  11.586  23.756  1.00  0.00           H  
ATOM   1273 HD21 ASN A  84     -17.970  13.487  22.233  1.00  0.00           H  
ATOM   1274 HD22 ASN A  84     -19.072  14.780  22.569  1.00  0.00           H  
ATOM   1275  N   ASN A  85     -16.606  10.028  25.279  1.00  0.00           N  
ATOM   1276  CA  ASN A  85     -16.174   8.641  25.234  1.00  0.00           C  
ATOM   1277  C   ASN A  85     -16.867   7.933  24.067  1.00  0.00           C  
ATOM   1278  O   ASN A  85     -16.234   7.184  23.327  1.00  0.00           O  
ATOM   1279  CB  ASN A  85     -16.549   7.906  26.523  1.00  0.00           C  
ATOM   1280  CG  ASN A  85     -15.608   6.725  26.773  1.00  0.00           C  
ATOM   1281  OD1 ASN A  85     -14.753   6.754  27.643  1.00  0.00           O  
ATOM   1282  ND2 ASN A  85     -15.813   5.690  25.964  1.00  0.00           N  
ATOM   1283  H   ASN A  85     -16.018  10.670  24.786  1.00  0.00           H  
ATOM   1284  HA  ASN A  85     -15.092   8.682  25.114  1.00  0.00           H  
ATOM   1285  HB2 ASN A  85     -16.505   8.596  27.364  1.00  0.00           H  
ATOM   1286  HB3 ASN A  85     -17.577   7.548  26.456  1.00  0.00           H  
ATOM   1287 HD21 ASN A  85     -16.532   5.731  25.271  1.00  0.00           H  
ATOM   1288 HD22 ASN A  85     -15.247   4.869  26.050  1.00  0.00           H  
ATOM   1289  N   LYS A  86     -18.159   8.198  23.940  1.00  0.00           N  
ATOM   1290  CA  LYS A  86     -18.945   7.596  22.876  1.00  0.00           C  
ATOM   1291  C   LYS A  86     -18.255   7.847  21.533  1.00  0.00           C  
ATOM   1292  O   LYS A  86     -17.815   6.909  20.873  1.00  0.00           O  
ATOM   1293  CB  LYS A  86     -20.390   8.096  22.928  1.00  0.00           C  
ATOM   1294  CG  LYS A  86     -21.260   7.174  23.784  1.00  0.00           C  
ATOM   1295  CD  LYS A  86     -21.642   5.909  23.013  1.00  0.00           C  
ATOM   1296  CE  LYS A  86     -22.724   5.121  23.752  1.00  0.00           C  
ATOM   1297  NZ  LYS A  86     -24.070   5.572  23.336  1.00  0.00           N  
ATOM   1298  H   LYS A  86     -18.668   8.809  24.546  1.00  0.00           H  
ATOM   1299  HA  LYS A  86     -18.970   6.522  23.056  1.00  0.00           H  
ATOM   1300  HB2 LYS A  86     -20.415   9.107  23.337  1.00  0.00           H  
ATOM   1301  HB3 LYS A  86     -20.796   8.152  21.918  1.00  0.00           H  
ATOM   1302  HG2 LYS A  86     -20.722   6.901  24.692  1.00  0.00           H  
ATOM   1303  HG3 LYS A  86     -22.162   7.701  24.093  1.00  0.00           H  
ATOM   1304  HD2 LYS A  86     -21.999   6.179  22.018  1.00  0.00           H  
ATOM   1305  HD3 LYS A  86     -20.760   5.282  22.875  1.00  0.00           H  
ATOM   1306  HE2 LYS A  86     -22.611   4.056  23.548  1.00  0.00           H  
ATOM   1307  HE3 LYS A  86     -22.606   5.253  24.829  1.00  0.00           H  
ATOM   1308  HZ1 LYS A  86     -24.075   6.568  23.245  1.00  0.00           H  
ATOM   1309  HZ2 LYS A  86     -24.304   5.156  22.457  1.00  0.00           H  
ATOM   1310  HZ3 LYS A  86     -24.741   5.297  24.024  1.00  0.00           H  
ATOM   1311  N   VAL A  87     -18.183   9.120  21.171  1.00  0.00           N  
ATOM   1312  CA  VAL A  87     -17.555   9.506  19.919  1.00  0.00           C  
ATOM   1313  C   VAL A  87     -16.195   8.814  19.800  1.00  0.00           C  
ATOM   1314  O   VAL A  87     -16.029   7.898  18.996  1.00  0.00           O  
ATOM   1315  CB  VAL A  87     -17.458  11.031  19.830  1.00  0.00           C  
ATOM   1316  CG1 VAL A  87     -17.002  11.471  18.438  1.00  0.00           C  
ATOM   1317  CG2 VAL A  87     -18.788  11.687  20.206  1.00  0.00           C  
ATOM   1318  H   VAL A  87     -18.544   9.878  21.714  1.00  0.00           H  
ATOM   1319  HA  VAL A  87     -18.196   9.161  19.108  1.00  0.00           H  
ATOM   1320  HB  VAL A  87     -16.708  11.362  20.549  1.00  0.00           H  
ATOM   1321 HG11 VAL A  87     -17.871  11.575  17.787  1.00  0.00           H  
ATOM   1322 HG12 VAL A  87     -16.487  12.428  18.511  1.00  0.00           H  
ATOM   1323 HG13 VAL A  87     -16.325  10.725  18.024  1.00  0.00           H  
ATOM   1324 HG21 VAL A  87     -18.910  12.610  19.639  1.00  0.00           H  
ATOM   1325 HG22 VAL A  87     -19.607  11.007  19.972  1.00  0.00           H  
ATOM   1326 HG23 VAL A  87     -18.795  11.911  21.272  1.00  0.00           H  
ATOM   1327  N   ARG A  88     -15.258   9.276  20.615  1.00  0.00           N  
ATOM   1328  CA  ARG A  88     -13.919   8.713  20.612  1.00  0.00           C  
ATOM   1329  C   ARG A  88     -13.511   8.306  22.029  1.00  0.00           C  
ATOM   1330  O   ARG A  88     -14.175   8.669  22.998  1.00  0.00           O  
ATOM   1331  CB  ARG A  88     -12.901   9.715  20.064  1.00  0.00           C  
ATOM   1332  CG  ARG A  88     -12.286   9.212  18.755  1.00  0.00           C  
ATOM   1333  CD  ARG A  88     -10.764   9.363  18.771  1.00  0.00           C  
ATOM   1334  NE  ARG A  88     -10.130   8.160  18.188  1.00  0.00           N  
ATOM   1335  CZ  ARG A  88     -10.167   7.848  16.885  1.00  0.00           C  
ATOM   1336  NH1 ARG A  88     -10.807   8.648  16.022  1.00  0.00           N  
ATOM   1337  NH2 ARG A  88      -9.563   6.735  16.445  1.00  0.00           N  
ATOM   1338  H   ARG A  88     -15.402  10.021  21.267  1.00  0.00           H  
ATOM   1339  HA  ARG A  88     -13.984   7.844  19.957  1.00  0.00           H  
ATOM   1340  HB2 ARG A  88     -13.385  10.676  19.895  1.00  0.00           H  
ATOM   1341  HB3 ARG A  88     -12.113   9.879  20.799  1.00  0.00           H  
ATOM   1342  HG2 ARG A  88     -12.550   8.165  18.604  1.00  0.00           H  
ATOM   1343  HG3 ARG A  88     -12.703   9.770  17.916  1.00  0.00           H  
ATOM   1344  HD2 ARG A  88     -10.473  10.248  18.205  1.00  0.00           H  
ATOM   1345  HD3 ARG A  88     -10.415   9.509  19.793  1.00  0.00           H  
ATOM   1346  HE  ARG A  88      -9.644   7.541  18.804  1.00  0.00           H  
ATOM   1347 HH11 ARG A  88     -11.257   9.478  16.350  1.00  0.00           H  
ATOM   1348 HH12 ARG A  88     -10.835   8.415  15.050  1.00  0.00           H  
ATOM   1349 HH21 ARG A  88      -9.085   6.138  17.089  1.00  0.00           H  
ATOM   1350 HH22 ARG A  88      -9.590   6.502  15.473  1.00  0.00           H  
ATOM   1351  N   ARG A  89     -12.419   7.558  22.105  1.00  0.00           N  
ATOM   1352  CA  ARG A  89     -11.916   7.097  23.388  1.00  0.00           C  
ATOM   1353  C   ARG A  89     -11.551   8.290  24.273  1.00  0.00           C  
ATOM   1354  O   ARG A  89     -11.869   8.306  25.461  1.00  0.00           O  
ATOM   1355  CB  ARG A  89     -10.683   6.209  23.208  1.00  0.00           C  
ATOM   1356  CG  ARG A  89     -11.023   4.740  23.469  1.00  0.00           C  
ATOM   1357  CD  ARG A  89     -11.253   4.487  24.961  1.00  0.00           C  
ATOM   1358  NE  ARG A  89     -12.043   3.249  25.149  1.00  0.00           N  
ATOM   1359  CZ  ARG A  89     -12.552   2.855  26.323  1.00  0.00           C  
ATOM   1360  NH1 ARG A  89     -12.358   3.598  27.422  1.00  0.00           N  
ATOM   1361  NH2 ARG A  89     -13.255   1.717  26.400  1.00  0.00           N  
ATOM   1362  H   ARG A  89     -11.885   7.266  21.311  1.00  0.00           H  
ATOM   1363  HA  ARG A  89     -12.735   6.524  23.819  1.00  0.00           H  
ATOM   1364  HB2 ARG A  89     -10.294   6.321  22.195  1.00  0.00           H  
ATOM   1365  HB3 ARG A  89      -9.896   6.531  23.889  1.00  0.00           H  
ATOM   1366  HG2 ARG A  89     -11.916   4.464  22.907  1.00  0.00           H  
ATOM   1367  HG3 ARG A  89     -10.212   4.106  23.111  1.00  0.00           H  
ATOM   1368  HD2 ARG A  89     -10.296   4.401  25.475  1.00  0.00           H  
ATOM   1369  HD3 ARG A  89     -11.778   5.334  25.404  1.00  0.00           H  
ATOM   1370  HE  ARG A  89     -12.206   2.672  24.349  1.00  0.00           H  
ATOM   1371 HH11 ARG A  89     -11.833   4.447  27.364  1.00  0.00           H  
ATOM   1372 HH12 ARG A  89     -12.738   3.303  28.298  1.00  0.00           H  
ATOM   1373 HH21 ARG A  89     -13.400   1.162  25.580  1.00  0.00           H  
ATOM   1374 HH22 ARG A  89     -13.635   1.422  27.276  1.00  0.00           H  
ATOM   1375  N   PHE A  90     -10.889   9.261  23.661  1.00  0.00           N  
ATOM   1376  CA  PHE A  90     -10.478  10.455  24.378  1.00  0.00           C  
ATOM   1377  C   PHE A  90     -11.096  11.709  23.757  1.00  0.00           C  
ATOM   1378  O   PHE A  90     -10.411  12.471  23.076  1.00  0.00           O  
ATOM   1379  CB  PHE A  90      -8.955  10.542  24.267  1.00  0.00           C  
ATOM   1380  CG  PHE A  90      -8.239   9.202  24.455  1.00  0.00           C  
ATOM   1381  CD1 PHE A  90      -8.246   8.592  25.670  1.00  0.00           C  
ATOM   1382  CD2 PHE A  90      -7.597   8.623  23.405  1.00  0.00           C  
ATOM   1383  CE1 PHE A  90      -7.583   7.349  25.843  1.00  0.00           C  
ATOM   1384  CE2 PHE A  90      -6.933   7.379  23.579  1.00  0.00           C  
ATOM   1385  CZ  PHE A  90      -6.941   6.768  24.794  1.00  0.00           C  
ATOM   1386  H   PHE A  90     -10.634   9.241  22.694  1.00  0.00           H  
ATOM   1387  HA  PHE A  90     -10.828  10.352  25.406  1.00  0.00           H  
ATOM   1388  HB2 PHE A  90      -8.695  10.947  23.290  1.00  0.00           H  
ATOM   1389  HB3 PHE A  90      -8.585  11.247  25.012  1.00  0.00           H  
ATOM   1390  HD1 PHE A  90      -8.762   9.056  26.510  1.00  0.00           H  
ATOM   1391  HD2 PHE A  90      -7.591   9.112  22.432  1.00  0.00           H  
ATOM   1392  HE1 PHE A  90      -7.589   6.859  26.817  1.00  0.00           H  
ATOM   1393  HE2 PHE A  90      -6.418   6.914  22.739  1.00  0.00           H  
ATOM   1394  HZ  PHE A  90      -6.432   5.814  24.927  1.00  0.00           H  
ATOM   1395  N   ALA A  91     -12.384  11.885  24.012  1.00  0.00           N  
ATOM   1396  CA  ALA A  91     -13.101  13.033  23.484  1.00  0.00           C  
ATOM   1397  C   ALA A  91     -13.975  13.633  24.588  1.00  0.00           C  
ATOM   1398  O   ALA A  91     -14.704  12.912  25.268  1.00  0.00           O  
ATOM   1399  CB  ALA A  91     -13.917  12.609  22.261  1.00  0.00           C  
ATOM   1400  H   ALA A  91     -12.935  11.261  24.566  1.00  0.00           H  
ATOM   1401  HA  ALA A  91     -12.363  13.773  23.176  1.00  0.00           H  
ATOM   1402  HB1 ALA A  91     -13.323  11.930  21.648  1.00  0.00           H  
ATOM   1403  HB2 ALA A  91     -14.826  12.104  22.588  1.00  0.00           H  
ATOM   1404  HB3 ALA A  91     -14.179  13.491  21.677  1.00  0.00           H  
ATOM   1405  N   PHE A  92     -13.874  14.946  24.732  1.00  0.00           N  
ATOM   1406  CA  PHE A  92     -14.647  15.651  25.740  1.00  0.00           C  
ATOM   1407  C   PHE A  92     -15.464  16.783  25.115  1.00  0.00           C  
ATOM   1408  O   PHE A  92     -15.005  17.443  24.184  1.00  0.00           O  
ATOM   1409  CB  PHE A  92     -13.647  16.248  26.733  1.00  0.00           C  
ATOM   1410  CG  PHE A  92     -12.395  16.836  26.077  1.00  0.00           C  
ATOM   1411  CD1 PHE A  92     -11.478  16.014  25.503  1.00  0.00           C  
ATOM   1412  CD2 PHE A  92     -12.201  18.183  26.069  1.00  0.00           C  
ATOM   1413  CE1 PHE A  92     -10.317  16.560  24.895  1.00  0.00           C  
ATOM   1414  CE2 PHE A  92     -11.040  18.729  25.461  1.00  0.00           C  
ATOM   1415  CZ  PHE A  92     -10.122  17.906  24.887  1.00  0.00           C  
ATOM   1416  H   PHE A  92     -13.279  15.525  24.174  1.00  0.00           H  
ATOM   1417  HA  PHE A  92     -15.321  14.926  26.196  1.00  0.00           H  
ATOM   1418  HB2 PHE A  92     -14.144  17.029  27.309  1.00  0.00           H  
ATOM   1419  HB3 PHE A  92     -13.344  15.475  27.439  1.00  0.00           H  
ATOM   1420  HD1 PHE A  92     -11.633  14.935  25.510  1.00  0.00           H  
ATOM   1421  HD2 PHE A  92     -12.937  18.842  26.530  1.00  0.00           H  
ATOM   1422  HE1 PHE A  92      -9.581  15.900  24.435  1.00  0.00           H  
ATOM   1423  HE2 PHE A  92     -10.884  19.808  25.455  1.00  0.00           H  
ATOM   1424  HZ  PHE A  92      -9.231  18.325  24.420  1.00  0.00           H  
ATOM   1425  N   GLU A  93     -16.661  16.972  25.650  1.00  0.00           N  
ATOM   1426  CA  GLU A  93     -17.546  18.012  25.156  1.00  0.00           C  
ATOM   1427  C   GLU A  93     -17.479  19.242  26.063  1.00  0.00           C  
ATOM   1428  O   GLU A  93     -17.410  19.114  27.285  1.00  0.00           O  
ATOM   1429  CB  GLU A  93     -18.982  17.498  25.034  1.00  0.00           C  
ATOM   1430  CG  GLU A  93     -19.986  18.647  25.138  1.00  0.00           C  
ATOM   1431  CD  GLU A  93     -21.299  18.294  24.437  1.00  0.00           C  
ATOM   1432  OE1 GLU A  93     -22.036  17.456  25.000  1.00  0.00           O  
ATOM   1433  OE2 GLU A  93     -21.536  18.868  23.352  1.00  0.00           O  
ATOM   1434  H   GLU A  93     -17.027  16.430  26.407  1.00  0.00           H  
ATOM   1435  HA  GLU A  93     -17.171  18.264  24.163  1.00  0.00           H  
ATOM   1436  HB2 GLU A  93     -19.108  16.985  24.081  1.00  0.00           H  
ATOM   1437  HB3 GLU A  93     -19.178  16.767  25.819  1.00  0.00           H  
ATOM   1438  HG2 GLU A  93     -20.179  18.873  26.186  1.00  0.00           H  
ATOM   1439  HG3 GLU A  93     -19.562  19.547  24.691  1.00  0.00           H  
ATOM   1440  N   LEU A  94     -17.500  20.406  25.430  1.00  0.00           N  
ATOM   1441  CA  LEU A  94     -17.443  21.658  26.166  1.00  0.00           C  
ATOM   1442  C   LEU A  94     -18.857  22.222  26.315  1.00  0.00           C  
ATOM   1443  O   LEU A  94     -19.472  22.632  25.333  1.00  0.00           O  
ATOM   1444  CB  LEU A  94     -16.462  22.626  25.501  1.00  0.00           C  
ATOM   1445  CG  LEU A  94     -14.988  22.214  25.531  1.00  0.00           C  
ATOM   1446  CD1 LEU A  94     -14.546  21.865  26.955  1.00  0.00           C  
ATOM   1447  CD2 LEU A  94     -14.717  21.071  24.551  1.00  0.00           C  
ATOM   1448  H   LEU A  94     -17.555  20.502  24.437  1.00  0.00           H  
ATOM   1449  HA  LEU A  94     -17.052  21.436  27.159  1.00  0.00           H  
ATOM   1450  HB2 LEU A  94     -16.760  22.757  24.461  1.00  0.00           H  
ATOM   1451  HB3 LEU A  94     -16.556  23.598  25.985  1.00  0.00           H  
ATOM   1452  HG  LEU A  94     -14.389  23.064  25.207  1.00  0.00           H  
ATOM   1453 HD11 LEU A  94     -13.478  21.645  26.960  1.00  0.00           H  
ATOM   1454 HD12 LEU A  94     -14.747  22.709  27.614  1.00  0.00           H  
ATOM   1455 HD13 LEU A  94     -15.098  20.992  27.303  1.00  0.00           H  
ATOM   1456 HD21 LEU A  94     -14.276  20.230  25.086  1.00  0.00           H  
ATOM   1457 HD22 LEU A  94     -15.655  20.756  24.092  1.00  0.00           H  
ATOM   1458 HD23 LEU A  94     -14.031  21.411  23.776  1.00  0.00           H  
ATOM   1459  N   LYS A  95     -19.331  22.225  27.553  1.00  0.00           N  
ATOM   1460  CA  LYS A  95     -20.661  22.733  27.843  1.00  0.00           C  
ATOM   1461  C   LYS A  95     -20.603  24.255  27.978  1.00  0.00           C  
ATOM   1462  O   LYS A  95     -20.277  24.776  29.043  1.00  0.00           O  
ATOM   1463  CB  LYS A  95     -21.246  22.028  29.069  1.00  0.00           C  
ATOM   1464  CG  LYS A  95     -21.320  20.516  28.851  1.00  0.00           C  
ATOM   1465  CD  LYS A  95     -22.243  20.175  27.679  1.00  0.00           C  
ATOM   1466  CE  LYS A  95     -22.849  18.781  27.848  1.00  0.00           C  
ATOM   1467  NZ  LYS A  95     -24.325  18.864  27.929  1.00  0.00           N  
ATOM   1468  H   LYS A  95     -18.824  21.890  28.346  1.00  0.00           H  
ATOM   1469  HA  LYS A  95     -21.298  22.484  26.994  1.00  0.00           H  
ATOM   1470  HB2 LYS A  95     -20.634  22.244  29.945  1.00  0.00           H  
ATOM   1471  HB3 LYS A  95     -22.243  22.418  29.275  1.00  0.00           H  
ATOM   1472  HG2 LYS A  95     -20.320  20.125  28.657  1.00  0.00           H  
ATOM   1473  HG3 LYS A  95     -21.681  20.031  29.757  1.00  0.00           H  
ATOM   1474  HD2 LYS A  95     -23.039  20.917  27.611  1.00  0.00           H  
ATOM   1475  HD3 LYS A  95     -21.683  20.221  26.745  1.00  0.00           H  
ATOM   1476  HE2 LYS A  95     -22.560  18.148  27.008  1.00  0.00           H  
ATOM   1477  HE3 LYS A  95     -22.456  18.313  28.750  1.00  0.00           H  
ATOM   1478  HZ1 LYS A  95     -24.585  19.389  28.739  1.00  0.00           H  
ATOM   1479  HZ2 LYS A  95     -24.678  19.317  27.110  1.00  0.00           H  
ATOM   1480  HZ3 LYS A  95     -24.708  17.942  27.991  1.00  0.00           H  
ATOM   1481  N   MET A  96     -20.925  24.927  26.882  1.00  0.00           N  
ATOM   1482  CA  MET A  96     -20.914  26.379  26.864  1.00  0.00           C  
ATOM   1483  C   MET A  96     -22.154  26.946  27.558  1.00  0.00           C  
ATOM   1484  O   MET A  96     -23.013  26.193  28.014  1.00  0.00           O  
ATOM   1485  CB  MET A  96     -20.870  26.872  25.416  1.00  0.00           C  
ATOM   1486  CG  MET A  96     -19.426  26.992  24.922  1.00  0.00           C  
ATOM   1487  SD  MET A  96     -19.016  28.707  24.647  1.00  0.00           S  
ATOM   1488  CE  MET A  96     -17.944  28.999  26.044  1.00  0.00           C  
ATOM   1489  H   MET A  96     -21.189  24.496  26.019  1.00  0.00           H  
ATOM   1490  HA  MET A  96     -20.018  26.673  27.411  1.00  0.00           H  
ATOM   1491  HB2 MET A  96     -21.420  26.182  24.776  1.00  0.00           H  
ATOM   1492  HB3 MET A  96     -21.364  27.841  25.342  1.00  0.00           H  
ATOM   1493  HG2 MET A  96     -18.745  26.560  25.656  1.00  0.00           H  
ATOM   1494  HG3 MET A  96     -19.301  26.426  23.999  1.00  0.00           H  
ATOM   1495  HE1 MET A  96     -16.916  28.758  25.770  1.00  0.00           H  
ATOM   1496  HE2 MET A  96     -18.006  30.046  26.339  1.00  0.00           H  
ATOM   1497  HE3 MET A  96     -18.254  28.368  26.877  1.00  0.00           H  
ATOM   1498  N   GLN A  97     -22.209  28.269  27.615  1.00  0.00           N  
ATOM   1499  CA  GLN A  97     -23.329  28.945  28.247  1.00  0.00           C  
ATOM   1500  C   GLN A  97     -24.148  29.705  27.200  1.00  0.00           C  
ATOM   1501  O   GLN A  97     -25.274  30.119  27.469  1.00  0.00           O  
ATOM   1502  CB  GLN A  97     -22.851  29.883  29.356  1.00  0.00           C  
ATOM   1503  CG  GLN A  97     -23.030  31.348  28.951  1.00  0.00           C  
ATOM   1504  CD  GLN A  97     -22.589  32.286  30.076  1.00  0.00           C  
ATOM   1505  OE1 GLN A  97     -21.563  32.098  30.709  1.00  0.00           O  
ATOM   1506  NE2 GLN A  97     -23.420  33.302  30.289  1.00  0.00           N  
ATOM   1507  H   GLN A  97     -21.506  28.874  27.242  1.00  0.00           H  
ATOM   1508  HA  GLN A  97     -23.936  28.152  28.686  1.00  0.00           H  
ATOM   1509  HB2 GLN A  97     -23.408  29.684  30.271  1.00  0.00           H  
ATOM   1510  HB3 GLN A  97     -21.800  29.689  29.573  1.00  0.00           H  
ATOM   1511  HG2 GLN A  97     -22.450  31.554  28.053  1.00  0.00           H  
ATOM   1512  HG3 GLN A  97     -24.075  31.534  28.705  1.00  0.00           H  
ATOM   1513 HE21 GLN A  97     -24.246  33.398  29.734  1.00  0.00           H  
ATOM   1514 HE22 GLN A  97     -23.218  33.971  31.006  1.00  0.00           H  
ATOM   1515  N   ASP A  98     -23.549  29.865  26.030  1.00  0.00           N  
ATOM   1516  CA  ASP A  98     -24.207  30.569  24.942  1.00  0.00           C  
ATOM   1517  C   ASP A  98     -25.009  29.568  24.106  1.00  0.00           C  
ATOM   1518  O   ASP A  98     -25.046  29.669  22.881  1.00  0.00           O  
ATOM   1519  CB  ASP A  98     -23.186  31.242  24.023  1.00  0.00           C  
ATOM   1520  CG  ASP A  98     -23.550  32.662  23.583  1.00  0.00           C  
ATOM   1521  OD1 ASP A  98     -24.398  33.269  24.272  1.00  0.00           O  
ATOM   1522  OD2 ASP A  98     -22.972  33.107  22.568  1.00  0.00           O  
ATOM   1523  H   ASP A  98     -22.632  29.526  25.819  1.00  0.00           H  
ATOM   1524  HA  ASP A  98     -24.842  31.312  25.424  1.00  0.00           H  
ATOM   1525  HB2 ASP A  98     -22.224  31.272  24.534  1.00  0.00           H  
ATOM   1526  HB3 ASP A  98     -23.057  30.625  23.135  1.00  0.00           H  
ATOM   1527  N   LYS A  99     -25.631  28.628  24.802  1.00  0.00           N  
ATOM   1528  CA  LYS A  99     -26.430  27.612  24.138  1.00  0.00           C  
ATOM   1529  C   LYS A  99     -25.597  26.955  23.036  1.00  0.00           C  
ATOM   1530  O   LYS A  99     -25.620  27.398  21.889  1.00  0.00           O  
ATOM   1531  CB  LYS A  99     -27.749  28.206  23.642  1.00  0.00           C  
ATOM   1532  CG  LYS A  99     -28.821  28.149  24.732  1.00  0.00           C  
ATOM   1533  CD  LYS A  99     -30.004  27.283  24.294  1.00  0.00           C  
ATOM   1534  CE  LYS A  99     -31.333  27.950  24.646  1.00  0.00           C  
ATOM   1535  NZ  LYS A  99     -32.461  27.025  24.395  1.00  0.00           N  
ATOM   1536  H   LYS A  99     -25.596  28.555  25.799  1.00  0.00           H  
ATOM   1537  HA  LYS A  99     -26.677  26.854  24.883  1.00  0.00           H  
ATOM   1538  HB2 LYS A  99     -27.593  29.240  23.334  1.00  0.00           H  
ATOM   1539  HB3 LYS A  99     -28.090  27.660  22.763  1.00  0.00           H  
ATOM   1540  HG2 LYS A  99     -28.391  27.748  25.649  1.00  0.00           H  
ATOM   1541  HG3 LYS A  99     -29.169  29.157  24.959  1.00  0.00           H  
ATOM   1542  HD2 LYS A  99     -29.953  27.109  23.218  1.00  0.00           H  
ATOM   1543  HD3 LYS A  99     -29.943  26.308  24.777  1.00  0.00           H  
ATOM   1544  HE2 LYS A  99     -31.329  28.253  25.694  1.00  0.00           H  
ATOM   1545  HE3 LYS A  99     -31.460  28.858  24.054  1.00  0.00           H  
ATOM   1546  HZ1 LYS A  99     -33.299  27.406  24.786  1.00  0.00           H  
ATOM   1547  HZ2 LYS A  99     -32.579  26.904  23.409  1.00  0.00           H  
ATOM   1548  HZ3 LYS A  99     -32.267  26.141  24.818  1.00  0.00           H  
ATOM   1549  N   SER A 100     -24.883  25.909  23.422  1.00  0.00           N  
ATOM   1550  CA  SER A 100     -24.045  25.185  22.480  1.00  0.00           C  
ATOM   1551  C   SER A 100     -22.944  24.432  23.229  1.00  0.00           C  
ATOM   1552  O   SER A 100     -22.812  24.567  24.445  1.00  0.00           O  
ATOM   1553  CB  SER A 100     -23.430  26.134  21.449  1.00  0.00           C  
ATOM   1554  OG  SER A 100     -22.235  25.605  20.882  1.00  0.00           O  
ATOM   1555  H   SER A 100     -24.870  25.554  24.357  1.00  0.00           H  
ATOM   1556  HA  SER A 100     -24.713  24.486  21.977  1.00  0.00           H  
ATOM   1557  HB2 SER A 100     -24.154  26.325  20.655  1.00  0.00           H  
ATOM   1558  HB3 SER A 100     -23.216  27.093  21.921  1.00  0.00           H  
ATOM   1559  HG  SER A 100     -21.712  26.336  20.445  1.00  0.00           H  
ATOM   1560  N   SER A 101     -22.183  23.655  22.474  1.00  0.00           N  
ATOM   1561  CA  SER A 101     -21.099  22.880  23.051  1.00  0.00           C  
ATOM   1562  C   SER A 101     -20.160  22.389  21.947  1.00  0.00           C  
ATOM   1563  O   SER A 101     -20.612  22.009  20.868  1.00  0.00           O  
ATOM   1564  CB  SER A 101     -21.636  21.695  23.856  1.00  0.00           C  
ATOM   1565  OG  SER A 101     -22.864  21.202  23.326  1.00  0.00           O  
ATOM   1566  H   SER A 101     -22.297  23.551  21.486  1.00  0.00           H  
ATOM   1567  HA  SER A 101     -20.577  23.565  23.718  1.00  0.00           H  
ATOM   1568  HB2 SER A 101     -20.896  20.894  23.861  1.00  0.00           H  
ATOM   1569  HB3 SER A 101     -21.785  21.999  24.892  1.00  0.00           H  
ATOM   1570  HG  SER A 101     -22.724  20.867  22.394  1.00  0.00           H  
ATOM   1571  N   TYR A 102     -18.872  22.413  22.255  1.00  0.00           N  
ATOM   1572  CA  TYR A 102     -17.866  21.975  21.303  1.00  0.00           C  
ATOM   1573  C   TYR A 102     -17.393  20.555  21.619  1.00  0.00           C  
ATOM   1574  O   TYR A 102     -17.332  20.161  22.782  1.00  0.00           O  
ATOM   1575  CB  TYR A 102     -16.688  22.938  21.459  1.00  0.00           C  
ATOM   1576  CG  TYR A 102     -17.068  24.414  21.317  1.00  0.00           C  
ATOM   1577  CD1 TYR A 102     -17.400  24.924  20.078  1.00  0.00           C  
ATOM   1578  CD2 TYR A 102     -17.079  25.234  22.426  1.00  0.00           C  
ATOM   1579  CE1 TYR A 102     -17.758  26.312  19.943  1.00  0.00           C  
ATOM   1580  CE2 TYR A 102     -17.437  26.623  22.292  1.00  0.00           C  
ATOM   1581  CZ  TYR A 102     -17.759  27.093  21.057  1.00  0.00           C  
ATOM   1582  OH  TYR A 102     -18.096  28.405  20.930  1.00  0.00           O  
ATOM   1583  H   TYR A 102     -18.513  22.724  23.135  1.00  0.00           H  
ATOM   1584  HA  TYR A 102     -18.316  21.988  20.310  1.00  0.00           H  
ATOM   1585  HB2 TYR A 102     -16.233  22.785  22.438  1.00  0.00           H  
ATOM   1586  HB3 TYR A 102     -15.931  22.696  20.714  1.00  0.00           H  
ATOM   1587  HD1 TYR A 102     -17.392  24.276  19.202  1.00  0.00           H  
ATOM   1588  HD2 TYR A 102     -16.817  24.831  23.404  1.00  0.00           H  
ATOM   1589  HE1 TYR A 102     -18.022  26.729  18.971  1.00  0.00           H  
ATOM   1590  HE2 TYR A 102     -17.449  27.282  23.160  1.00  0.00           H  
ATOM   1591  HH  TYR A 102     -18.119  28.660  19.964  1.00  0.00           H  
ATOM   1592  N   LEU A 103     -17.069  19.824  20.562  1.00  0.00           N  
ATOM   1593  CA  LEU A 103     -16.603  18.455  20.712  1.00  0.00           C  
ATOM   1594  C   LEU A 103     -15.086  18.415  20.524  1.00  0.00           C  
ATOM   1595  O   LEU A 103     -14.596  18.439  19.396  1.00  0.00           O  
ATOM   1596  CB  LEU A 103     -17.365  17.523  19.768  1.00  0.00           C  
ATOM   1597  CG  LEU A 103     -17.863  16.211  20.378  1.00  0.00           C  
ATOM   1598  CD1 LEU A 103     -18.409  15.277  19.297  1.00  0.00           C  
ATOM   1599  CD2 LEU A 103     -16.766  15.544  21.211  1.00  0.00           C  
ATOM   1600  H   LEU A 103     -17.121  20.151  19.618  1.00  0.00           H  
ATOM   1601  HA  LEU A 103     -16.834  18.142  21.730  1.00  0.00           H  
ATOM   1602  HB2 LEU A 103     -18.225  18.064  19.371  1.00  0.00           H  
ATOM   1603  HB3 LEU A 103     -16.719  17.286  18.923  1.00  0.00           H  
ATOM   1604  HG  LEU A 103     -18.687  16.439  21.054  1.00  0.00           H  
ATOM   1605 HD11 LEU A 103     -18.560  15.837  18.374  1.00  0.00           H  
ATOM   1606 HD12 LEU A 103     -17.699  14.470  19.120  1.00  0.00           H  
ATOM   1607 HD13 LEU A 103     -19.360  14.857  19.626  1.00  0.00           H  
ATOM   1608 HD21 LEU A 103     -16.766  14.471  21.020  1.00  0.00           H  
ATOM   1609 HD22 LEU A 103     -15.797  15.962  20.938  1.00  0.00           H  
ATOM   1610 HD23 LEU A 103     -16.953  15.724  22.269  1.00  0.00           H  
ATOM   1611  N   LEU A 104     -14.384  18.354  21.645  1.00  0.00           N  
ATOM   1612  CA  LEU A 104     -12.932  18.309  21.618  1.00  0.00           C  
ATOM   1613  C   LEU A 104     -12.466  16.863  21.796  1.00  0.00           C  
ATOM   1614  O   LEU A 104     -13.181  16.044  22.372  1.00  0.00           O  
ATOM   1615  CB  LEU A 104     -12.347  19.275  22.652  1.00  0.00           C  
ATOM   1616  CG  LEU A 104     -12.015  20.680  22.145  1.00  0.00           C  
ATOM   1617  CD1 LEU A 104     -13.140  21.223  21.260  1.00  0.00           C  
ATOM   1618  CD2 LEU A 104     -11.695  21.621  23.308  1.00  0.00           C  
ATOM   1619  H   LEU A 104     -14.790  18.336  22.559  1.00  0.00           H  
ATOM   1620  HA  LEU A 104     -12.613  18.657  20.636  1.00  0.00           H  
ATOM   1621  HB2 LEU A 104     -13.053  19.365  23.476  1.00  0.00           H  
ATOM   1622  HB3 LEU A 104     -11.437  18.833  23.058  1.00  0.00           H  
ATOM   1623  HG  LEU A 104     -11.120  20.617  21.525  1.00  0.00           H  
ATOM   1624 HD11 LEU A 104     -13.205  20.629  20.349  1.00  0.00           H  
ATOM   1625 HD12 LEU A 104     -14.085  21.168  21.800  1.00  0.00           H  
ATOM   1626 HD13 LEU A 104     -12.929  22.261  21.003  1.00  0.00           H  
ATOM   1627 HD21 LEU A 104     -12.076  21.196  24.235  1.00  0.00           H  
ATOM   1628 HD22 LEU A 104     -10.615  21.750  23.384  1.00  0.00           H  
ATOM   1629 HD23 LEU A 104     -12.165  22.589  23.131  1.00  0.00           H  
ATOM   1630  N   ALA A 105     -11.272  16.593  21.291  1.00  0.00           N  
ATOM   1631  CA  ALA A 105     -10.703  15.260  21.386  1.00  0.00           C  
ATOM   1632  C   ALA A 105      -9.192  15.336  21.155  1.00  0.00           C  
ATOM   1633  O   ALA A 105      -8.734  16.029  20.248  1.00  0.00           O  
ATOM   1634  CB  ALA A 105     -11.400  14.334  20.386  1.00  0.00           C  
ATOM   1635  H   ALA A 105     -10.697  17.265  20.824  1.00  0.00           H  
ATOM   1636  HA  ALA A 105     -10.890  14.891  22.394  1.00  0.00           H  
ATOM   1637  HB1 ALA A 105     -10.726  13.523  20.111  1.00  0.00           H  
ATOM   1638  HB2 ALA A 105     -12.300  13.920  20.841  1.00  0.00           H  
ATOM   1639  HB3 ALA A 105     -11.670  14.900  19.494  1.00  0.00           H  
ATOM   1640  N   ALA A 106      -8.461  14.615  21.992  1.00  0.00           N  
ATOM   1641  CA  ALA A 106      -7.011  14.593  21.890  1.00  0.00           C  
ATOM   1642  C   ALA A 106      -6.569  13.268  21.267  1.00  0.00           C  
ATOM   1643  O   ALA A 106      -7.390  12.381  21.036  1.00  0.00           O  
ATOM   1644  CB  ALA A 106      -6.399  14.821  23.273  1.00  0.00           C  
ATOM   1645  H   ALA A 106      -8.841  14.054  22.727  1.00  0.00           H  
ATOM   1646  HA  ALA A 106      -6.712  15.411  21.235  1.00  0.00           H  
ATOM   1647  HB1 ALA A 106      -7.145  14.613  24.040  1.00  0.00           H  
ATOM   1648  HB2 ALA A 106      -5.546  14.155  23.406  1.00  0.00           H  
ATOM   1649  HB3 ALA A 106      -6.069  15.856  23.357  1.00  0.00           H  
ATOM   1650  N   ASP A 107      -5.271  13.174  21.013  1.00  0.00           N  
ATOM   1651  CA  ASP A 107      -4.710  11.971  20.421  1.00  0.00           C  
ATOM   1652  C   ASP A 107      -4.516  10.914  21.511  1.00  0.00           C  
ATOM   1653  O   ASP A 107      -4.694   9.723  21.264  1.00  0.00           O  
ATOM   1654  CB  ASP A 107      -3.345  12.255  19.789  1.00  0.00           C  
ATOM   1655  CG  ASP A 107      -3.137  11.644  18.401  1.00  0.00           C  
ATOM   1656  OD1 ASP A 107      -4.014  10.855  17.991  1.00  0.00           O  
ATOM   1657  OD2 ASP A 107      -2.104  11.980  17.783  1.00  0.00           O  
ATOM   1658  H   ASP A 107      -4.611  13.899  21.203  1.00  0.00           H  
ATOM   1659  HA  ASP A 107      -5.429  11.661  19.663  1.00  0.00           H  
ATOM   1660  HB2 ASP A 107      -3.211  13.334  19.719  1.00  0.00           H  
ATOM   1661  HB3 ASP A 107      -2.569  11.879  20.455  1.00  0.00           H  
ATOM   1662  N   SER A 108      -4.154  11.390  22.693  1.00  0.00           N  
ATOM   1663  CA  SER A 108      -3.934  10.501  23.822  1.00  0.00           C  
ATOM   1664  C   SER A 108      -4.738  10.982  25.031  1.00  0.00           C  
ATOM   1665  O   SER A 108      -5.150  12.140  25.086  1.00  0.00           O  
ATOM   1666  CB  SER A 108      -2.448  10.414  24.173  1.00  0.00           C  
ATOM   1667  OG  SER A 108      -1.776   9.416  23.411  1.00  0.00           O  
ATOM   1668  H   SER A 108      -4.011  12.361  22.885  1.00  0.00           H  
ATOM   1669  HA  SER A 108      -4.286   9.524  23.491  1.00  0.00           H  
ATOM   1670  HB2 SER A 108      -1.977  11.382  23.997  1.00  0.00           H  
ATOM   1671  HB3 SER A 108      -2.339  10.195  25.235  1.00  0.00           H  
ATOM   1672  HG  SER A 108      -2.088   9.442  22.461  1.00  0.00           H  
ATOM   1673  N   GLU A 109      -4.939  10.067  25.969  1.00  0.00           N  
ATOM   1674  CA  GLU A 109      -5.687  10.384  27.174  1.00  0.00           C  
ATOM   1675  C   GLU A 109      -5.145  11.664  27.815  1.00  0.00           C  
ATOM   1676  O   GLU A 109      -5.912  12.560  28.164  1.00  0.00           O  
ATOM   1677  CB  GLU A 109      -5.650   9.218  28.164  1.00  0.00           C  
ATOM   1678  CG  GLU A 109      -4.219   8.935  28.625  1.00  0.00           C  
ATOM   1679  CD  GLU A 109      -4.157   7.661  29.471  1.00  0.00           C  
ATOM   1680  OE1 GLU A 109      -4.604   7.732  30.636  1.00  0.00           O  
ATOM   1681  OE2 GLU A 109      -3.666   6.646  28.934  1.00  0.00           O  
ATOM   1682  H   GLU A 109      -4.600   9.128  25.916  1.00  0.00           H  
ATOM   1683  HA  GLU A 109      -6.713  10.541  26.845  1.00  0.00           H  
ATOM   1684  HB2 GLU A 109      -6.275   9.448  29.026  1.00  0.00           H  
ATOM   1685  HB3 GLU A 109      -6.069   8.326  27.696  1.00  0.00           H  
ATOM   1686  HG2 GLU A 109      -3.567   8.831  27.757  1.00  0.00           H  
ATOM   1687  HG3 GLU A 109      -3.846   9.779  29.204  1.00  0.00           H  
ATOM   1688  N   VAL A 110      -3.827  11.708  27.950  1.00  0.00           N  
ATOM   1689  CA  VAL A 110      -3.175  12.863  28.542  1.00  0.00           C  
ATOM   1690  C   VAL A 110      -3.639  14.131  27.824  1.00  0.00           C  
ATOM   1691  O   VAL A 110      -4.274  14.994  28.428  1.00  0.00           O  
ATOM   1692  CB  VAL A 110      -1.656  12.680  28.509  1.00  0.00           C  
ATOM   1693  CG1 VAL A 110      -1.185  12.255  27.116  1.00  0.00           C  
ATOM   1694  CG2 VAL A 110      -0.940  13.952  28.966  1.00  0.00           C  
ATOM   1695  H   VAL A 110      -3.211  10.975  27.663  1.00  0.00           H  
ATOM   1696  HA  VAL A 110      -3.485  12.917  29.585  1.00  0.00           H  
ATOM   1697  HB  VAL A 110      -1.399  11.882  29.206  1.00  0.00           H  
ATOM   1698 HG11 VAL A 110      -0.791  13.122  26.586  1.00  0.00           H  
ATOM   1699 HG12 VAL A 110      -0.405  11.501  27.211  1.00  0.00           H  
ATOM   1700 HG13 VAL A 110      -2.025  11.841  26.560  1.00  0.00           H  
ATOM   1701 HG21 VAL A 110      -0.594  14.508  28.094  1.00  0.00           H  
ATOM   1702 HG22 VAL A 110      -1.629  14.571  29.540  1.00  0.00           H  
ATOM   1703 HG23 VAL A 110      -0.086  13.686  29.588  1.00  0.00           H  
ATOM   1704  N   GLU A 111      -3.306  14.203  26.544  1.00  0.00           N  
ATOM   1705  CA  GLU A 111      -3.682  15.351  25.736  1.00  0.00           C  
ATOM   1706  C   GLU A 111      -5.174  15.647  25.895  1.00  0.00           C  
ATOM   1707  O   GLU A 111      -5.619  16.766  25.645  1.00  0.00           O  
ATOM   1708  CB  GLU A 111      -3.320  15.129  24.265  1.00  0.00           C  
ATOM   1709  CG  GLU A 111      -2.000  15.819  23.916  1.00  0.00           C  
ATOM   1710  CD  GLU A 111      -1.399  15.234  22.636  1.00  0.00           C  
ATOM   1711  OE1 GLU A 111      -1.013  14.045  22.681  1.00  0.00           O  
ATOM   1712  OE2 GLU A 111      -1.337  15.988  21.641  1.00  0.00           O  
ATOM   1713  H   GLU A 111      -2.789  13.497  26.059  1.00  0.00           H  
ATOM   1714  HA  GLU A 111      -3.096  16.184  26.126  1.00  0.00           H  
ATOM   1715  HB2 GLU A 111      -3.242  14.061  24.064  1.00  0.00           H  
ATOM   1716  HB3 GLU A 111      -4.116  15.516  23.630  1.00  0.00           H  
ATOM   1717  HG2 GLU A 111      -2.165  16.888  23.787  1.00  0.00           H  
ATOM   1718  HG3 GLU A 111      -1.294  15.701  24.739  1.00  0.00           H  
ATOM   1719  N   MET A 112      -5.906  14.623  26.311  1.00  0.00           N  
ATOM   1720  CA  MET A 112      -7.340  14.759  26.506  1.00  0.00           C  
ATOM   1721  C   MET A 112      -7.658  15.207  27.934  1.00  0.00           C  
ATOM   1722  O   MET A 112      -8.630  15.926  28.160  1.00  0.00           O  
ATOM   1723  CB  MET A 112      -8.022  13.419  26.226  1.00  0.00           C  
ATOM   1724  CG  MET A 112      -9.517  13.488  26.545  1.00  0.00           C  
ATOM   1725  SD  MET A 112     -10.058  11.951  27.272  1.00  0.00           S  
ATOM   1726  CE  MET A 112      -8.843  11.777  28.569  1.00  0.00           C  
ATOM   1727  H   MET A 112      -5.536  13.717  26.511  1.00  0.00           H  
ATOM   1728  HA  MET A 112      -7.661  15.524  25.798  1.00  0.00           H  
ATOM   1729  HB2 MET A 112      -7.883  13.147  25.179  1.00  0.00           H  
ATOM   1730  HB3 MET A 112      -7.555  12.637  26.824  1.00  0.00           H  
ATOM   1731  HG2 MET A 112      -9.714  14.313  27.230  1.00  0.00           H  
ATOM   1732  HG3 MET A 112     -10.083  13.689  25.636  1.00  0.00           H  
ATOM   1733  HE1 MET A 112      -9.310  11.328  29.446  1.00  0.00           H  
ATOM   1734  HE2 MET A 112      -8.031  11.139  28.223  1.00  0.00           H  
ATOM   1735  HE3 MET A 112      -8.448  12.758  28.831  1.00  0.00           H  
ATOM   1736  N   GLU A 113      -6.821  14.763  28.859  1.00  0.00           N  
ATOM   1737  CA  GLU A 113      -7.001  15.108  30.259  1.00  0.00           C  
ATOM   1738  C   GLU A 113      -6.450  16.509  30.535  1.00  0.00           C  
ATOM   1739  O   GLU A 113      -7.051  17.280  31.282  1.00  0.00           O  
ATOM   1740  CB  GLU A 113      -6.341  14.071  31.169  1.00  0.00           C  
ATOM   1741  CG  GLU A 113      -4.882  14.436  31.450  1.00  0.00           C  
ATOM   1742  CD  GLU A 113      -4.236  13.424  32.398  1.00  0.00           C  
ATOM   1743  OE1 GLU A 113      -4.715  12.270  32.409  1.00  0.00           O  
ATOM   1744  OE2 GLU A 113      -3.279  13.828  33.093  1.00  0.00           O  
ATOM   1745  H   GLU A 113      -6.033  14.178  28.666  1.00  0.00           H  
ATOM   1746  HA  GLU A 113      -8.078  15.096  30.425  1.00  0.00           H  
ATOM   1747  HB2 GLU A 113      -6.890  14.005  32.109  1.00  0.00           H  
ATOM   1748  HB3 GLU A 113      -6.390  13.088  30.702  1.00  0.00           H  
ATOM   1749  HG2 GLU A 113      -4.325  14.468  30.513  1.00  0.00           H  
ATOM   1750  HG3 GLU A 113      -4.830  15.434  31.886  1.00  0.00           H  
ATOM   1751  N   GLU A 114      -5.313  16.796  29.919  1.00  0.00           N  
ATOM   1752  CA  GLU A 114      -4.675  18.090  30.088  1.00  0.00           C  
ATOM   1753  C   GLU A 114      -5.682  19.215  29.843  1.00  0.00           C  
ATOM   1754  O   GLU A 114      -5.903  20.056  30.713  1.00  0.00           O  
ATOM   1755  CB  GLU A 114      -3.462  18.228  29.165  1.00  0.00           C  
ATOM   1756  CG  GLU A 114      -2.525  17.027  29.307  1.00  0.00           C  
ATOM   1757  CD  GLU A 114      -1.072  17.481  29.460  1.00  0.00           C  
ATOM   1758  OE1 GLU A 114      -0.510  17.938  28.442  1.00  0.00           O  
ATOM   1759  OE2 GLU A 114      -0.556  17.360  30.592  1.00  0.00           O  
ATOM   1760  H   GLU A 114      -4.831  16.163  29.312  1.00  0.00           H  
ATOM   1761  HA  GLU A 114      -4.339  18.113  31.124  1.00  0.00           H  
ATOM   1762  HB2 GLU A 114      -3.796  18.314  28.131  1.00  0.00           H  
ATOM   1763  HB3 GLU A 114      -2.923  19.146  29.403  1.00  0.00           H  
ATOM   1764  HG2 GLU A 114      -2.818  16.434  30.173  1.00  0.00           H  
ATOM   1765  HG3 GLU A 114      -2.619  16.384  28.433  1.00  0.00           H  
ATOM   1766  N   TRP A 115      -6.266  19.194  28.654  1.00  0.00           N  
ATOM   1767  CA  TRP A 115      -7.245  20.202  28.282  1.00  0.00           C  
ATOM   1768  C   TRP A 115      -8.366  20.178  29.324  1.00  0.00           C  
ATOM   1769  O   TRP A 115      -8.699  21.208  29.907  1.00  0.00           O  
ATOM   1770  CB  TRP A 115      -7.749  19.978  26.856  1.00  0.00           C  
ATOM   1771  CG  TRP A 115      -6.787  20.468  25.772  1.00  0.00           C  
ATOM   1772  CD1 TRP A 115      -6.141  19.739  24.851  1.00  0.00           C  
ATOM   1773  CD2 TRP A 115      -6.385  21.833  25.531  1.00  0.00           C  
ATOM   1774  NE1 TRP A 115      -5.357  20.531  24.037  1.00  0.00           N  
ATOM   1775  CE2 TRP A 115      -5.510  21.845  24.465  1.00  0.00           C  
ATOM   1776  CE3 TRP A 115      -6.750  23.018  26.193  1.00  0.00           C  
ATOM   1777  CZ2 TRP A 115      -4.925  23.015  23.965  1.00  0.00           C  
ATOM   1778  CZ3 TRP A 115      -6.158  24.180  25.682  1.00  0.00           C  
ATOM   1779  CH2 TRP A 115      -5.274  24.208  24.609  1.00  0.00           C  
ATOM   1780  H   TRP A 115      -6.081  18.507  27.951  1.00  0.00           H  
ATOM   1781  HA  TRP A 115      -6.746  21.171  28.294  1.00  0.00           H  
ATOM   1782  HB2 TRP A 115      -7.934  18.914  26.710  1.00  0.00           H  
ATOM   1783  HB3 TRP A 115      -8.705  20.486  26.735  1.00  0.00           H  
ATOM   1784  HD1 TRP A 115      -6.225  18.656  24.755  1.00  0.00           H  
ATOM   1785  HE1 TRP A 115      -4.732  20.189  23.212  1.00  0.00           H  
ATOM   1786  HE3 TRP A 115      -7.440  23.035  27.037  1.00  0.00           H  
ATOM   1787  HZ2 TRP A 115      -4.236  22.998  23.121  1.00  0.00           H  
ATOM   1788  HZ3 TRP A 115      -6.407  25.127  26.159  1.00  0.00           H  
ATOM   1789  HH2 TRP A 115      -4.856  25.155  24.270  1.00  0.00           H  
ATOM   1790  N   ILE A 116      -8.917  18.990  29.525  1.00  0.00           N  
ATOM   1791  CA  ILE A 116      -9.995  18.818  30.485  1.00  0.00           C  
ATOM   1792  C   ILE A 116      -9.608  19.492  31.804  1.00  0.00           C  
ATOM   1793  O   ILE A 116     -10.475  19.938  32.554  1.00  0.00           O  
ATOM   1794  CB  ILE A 116     -10.350  17.337  30.632  1.00  0.00           C  
ATOM   1795  CG1 ILE A 116     -11.159  16.846  29.430  1.00  0.00           C  
ATOM   1796  CG2 ILE A 116     -11.073  17.075  31.955  1.00  0.00           C  
ATOM   1797  CD1 ILE A 116     -11.340  15.328  29.475  1.00  0.00           C  
ATOM   1798  H   ILE A 116      -8.641  18.157  29.047  1.00  0.00           H  
ATOM   1799  HA  ILE A 116     -10.874  19.322  30.084  1.00  0.00           H  
ATOM   1800  HB  ILE A 116      -9.424  16.764  30.652  1.00  0.00           H  
ATOM   1801 HG12 ILE A 116     -12.136  17.332  29.422  1.00  0.00           H  
ATOM   1802 HG13 ILE A 116     -10.654  17.129  28.506  1.00  0.00           H  
ATOM   1803 HG21 ILE A 116     -11.785  17.879  32.145  1.00  0.00           H  
ATOM   1804 HG22 ILE A 116     -11.602  16.125  31.898  1.00  0.00           H  
ATOM   1805 HG23 ILE A 116     -10.345  17.038  32.765  1.00  0.00           H  
ATOM   1806 HD11 ILE A 116     -10.595  14.893  30.141  1.00  0.00           H  
ATOM   1807 HD12 ILE A 116     -12.339  15.091  29.843  1.00  0.00           H  
ATOM   1808 HD13 ILE A 116     -11.216  14.917  28.473  1.00  0.00           H  
ATOM   1809  N   THR A 117      -8.307  19.544  32.046  1.00  0.00           N  
ATOM   1810  CA  THR A 117      -7.796  20.155  33.260  1.00  0.00           C  
ATOM   1811  C   THR A 117      -7.574  21.655  33.051  1.00  0.00           C  
ATOM   1812  O   THR A 117      -7.816  22.454  33.954  1.00  0.00           O  
ATOM   1813  CB  THR A 117      -6.526  19.406  33.668  1.00  0.00           C  
ATOM   1814  OG1 THR A 117      -6.979  18.452  34.626  1.00  0.00           O  
ATOM   1815  CG2 THR A 117      -5.552  20.287  34.454  1.00  0.00           C  
ATOM   1816  H   THR A 117      -7.608  19.179  31.430  1.00  0.00           H  
ATOM   1817  HA  THR A 117      -8.547  20.050  34.042  1.00  0.00           H  
ATOM   1818  HB  THR A 117      -6.038  18.964  32.801  1.00  0.00           H  
ATOM   1819  HG1 THR A 117      -6.508  17.580  34.490  1.00  0.00           H  
ATOM   1820 HG21 THR A 117      -5.176  21.078  33.806  1.00  0.00           H  
ATOM   1821 HG22 THR A 117      -6.068  20.729  35.306  1.00  0.00           H  
ATOM   1822 HG23 THR A 117      -4.718  19.681  34.808  1.00  0.00           H  
ATOM   1823  N   ILE A 118      -7.117  21.991  31.853  1.00  0.00           N  
ATOM   1824  CA  ILE A 118      -6.860  23.380  31.514  1.00  0.00           C  
ATOM   1825  C   ILE A 118      -8.183  24.148  31.491  1.00  0.00           C  
ATOM   1826  O   ILE A 118      -8.407  25.033  32.316  1.00  0.00           O  
ATOM   1827  CB  ILE A 118      -6.072  23.475  30.205  1.00  0.00           C  
ATOM   1828  CG1 ILE A 118      -4.599  23.790  30.475  1.00  0.00           C  
ATOM   1829  CG2 ILE A 118      -6.709  24.488  29.253  1.00  0.00           C  
ATOM   1830  CD1 ILE A 118      -4.073  22.978  31.661  1.00  0.00           C  
ATOM   1831  H   ILE A 118      -6.922  21.335  31.124  1.00  0.00           H  
ATOM   1832  HA  ILE A 118      -6.232  23.799  32.300  1.00  0.00           H  
ATOM   1833  HB  ILE A 118      -6.109  22.503  29.714  1.00  0.00           H  
ATOM   1834 HG12 ILE A 118      -4.007  23.567  29.586  1.00  0.00           H  
ATOM   1835 HG13 ILE A 118      -4.482  24.854  30.678  1.00  0.00           H  
ATOM   1836 HG21 ILE A 118      -7.588  24.044  28.785  1.00  0.00           H  
ATOM   1837 HG22 ILE A 118      -7.006  25.377  29.812  1.00  0.00           H  
ATOM   1838 HG23 ILE A 118      -5.989  24.767  28.484  1.00  0.00           H  
ATOM   1839 HD11 ILE A 118      -4.297  23.505  32.589  1.00  0.00           H  
ATOM   1840 HD12 ILE A 118      -4.553  22.000  31.672  1.00  0.00           H  
ATOM   1841 HD13 ILE A 118      -2.994  22.854  31.565  1.00  0.00           H  
ATOM   1842  N   LEU A 119      -9.027  23.782  30.537  1.00  0.00           N  
ATOM   1843  CA  LEU A 119     -10.322  24.425  30.395  1.00  0.00           C  
ATOM   1844  C   LEU A 119     -11.007  24.489  31.763  1.00  0.00           C  
ATOM   1845  O   LEU A 119     -11.436  25.556  32.195  1.00  0.00           O  
ATOM   1846  CB  LEU A 119     -11.156  23.722  29.322  1.00  0.00           C  
ATOM   1847  CG  LEU A 119     -10.549  23.686  27.918  1.00  0.00           C  
ATOM   1848  CD1 LEU A 119     -11.517  23.049  26.919  1.00  0.00           C  
ATOM   1849  CD2 LEU A 119     -10.106  25.082  27.477  1.00  0.00           C  
ATOM   1850  H   LEU A 119      -8.838  23.062  29.870  1.00  0.00           H  
ATOM   1851  HA  LEU A 119     -10.145  25.444  30.050  1.00  0.00           H  
ATOM   1852  HB2 LEU A 119     -11.336  22.696  29.645  1.00  0.00           H  
ATOM   1853  HB3 LEU A 119     -12.127  24.213  29.265  1.00  0.00           H  
ATOM   1854  HG  LEU A 119      -9.658  23.059  27.947  1.00  0.00           H  
ATOM   1855 HD11 LEU A 119     -11.219  23.314  25.904  1.00  0.00           H  
ATOM   1856 HD12 LEU A 119     -11.496  21.966  27.033  1.00  0.00           H  
ATOM   1857 HD13 LEU A 119     -12.527  23.415  27.107  1.00  0.00           H  
ATOM   1858 HD21 LEU A 119     -10.923  25.788  27.630  1.00  0.00           H  
ATOM   1859 HD22 LEU A 119      -9.243  25.392  28.065  1.00  0.00           H  
ATOM   1860 HD23 LEU A 119      -9.838  25.062  26.420  1.00  0.00           H  
ATOM   1861  N   ASN A 120     -11.086  23.332  32.403  1.00  0.00           N  
ATOM   1862  CA  ASN A 120     -11.711  23.243  33.712  1.00  0.00           C  
ATOM   1863  C   ASN A 120     -11.081  24.279  34.645  1.00  0.00           C  
ATOM   1864  O   ASN A 120     -11.786  24.959  35.389  1.00  0.00           O  
ATOM   1865  CB  ASN A 120     -11.500  21.860  34.330  1.00  0.00           C  
ATOM   1866  CG  ASN A 120     -12.550  20.867  33.826  1.00  0.00           C  
ATOM   1867  OD1 ASN A 120     -13.471  21.212  33.105  1.00  0.00           O  
ATOM   1868  ND2 ASN A 120     -12.359  19.620  34.246  1.00  0.00           N  
ATOM   1869  H   ASN A 120     -10.734  22.468  32.043  1.00  0.00           H  
ATOM   1870  HA  ASN A 120     -12.771  23.429  33.537  1.00  0.00           H  
ATOM   1871  HB2 ASN A 120     -10.503  21.496  34.084  1.00  0.00           H  
ATOM   1872  HB3 ASN A 120     -11.553  21.931  35.417  1.00  0.00           H  
ATOM   1873 HD21 ASN A 120     -11.583  19.404  34.836  1.00  0.00           H  
ATOM   1874 HD22 ASN A 120     -12.994  18.898  33.969  1.00  0.00           H  
ATOM   1875  N   LYS A 121      -9.761  24.367  34.574  1.00  0.00           N  
ATOM   1876  CA  LYS A 121      -9.027  25.309  35.403  1.00  0.00           C  
ATOM   1877  C   LYS A 121      -9.601  26.713  35.201  1.00  0.00           C  
ATOM   1878  O   LYS A 121     -10.122  27.315  36.138  1.00  0.00           O  
ATOM   1879  CB  LYS A 121      -7.526  25.210  35.125  1.00  0.00           C  
ATOM   1880  CG  LYS A 121      -6.780  24.651  36.337  1.00  0.00           C  
ATOM   1881  CD  LYS A 121      -5.274  24.896  36.216  1.00  0.00           C  
ATOM   1882  CE  LYS A 121      -4.506  24.128  37.293  1.00  0.00           C  
ATOM   1883  NZ  LYS A 121      -3.074  24.020  36.930  1.00  0.00           N  
ATOM   1884  H   LYS A 121      -9.195  23.810  33.966  1.00  0.00           H  
ATOM   1885  HA  LYS A 121      -9.183  25.019  36.443  1.00  0.00           H  
ATOM   1886  HB2 LYS A 121      -7.353  24.572  34.260  1.00  0.00           H  
ATOM   1887  HB3 LYS A 121      -7.134  26.197  34.876  1.00  0.00           H  
ATOM   1888  HG2 LYS A 121      -7.157  25.117  37.248  1.00  0.00           H  
ATOM   1889  HG3 LYS A 121      -6.972  23.582  36.425  1.00  0.00           H  
ATOM   1890  HD2 LYS A 121      -4.931  24.588  35.229  1.00  0.00           H  
ATOM   1891  HD3 LYS A 121      -5.068  25.962  36.308  1.00  0.00           H  
ATOM   1892  HE2 LYS A 121      -4.606  24.635  38.252  1.00  0.00           H  
ATOM   1893  HE3 LYS A 121      -4.932  23.132  37.412  1.00  0.00           H  
ATOM   1894  HZ1 LYS A 121      -2.545  24.680  37.462  1.00  0.00           H  
ATOM   1895  HZ2 LYS A 121      -2.750  23.095  37.127  1.00  0.00           H  
ATOM   1896  HZ3 LYS A 121      -2.963  24.211  35.954  1.00  0.00           H  
ATOM   1897  N   ILE A 122      -9.486  27.193  33.971  1.00  0.00           N  
ATOM   1898  CA  ILE A 122      -9.985  28.514  33.634  1.00  0.00           C  
ATOM   1899  C   ILE A 122     -11.482  28.584  33.946  1.00  0.00           C  
ATOM   1900  O   ILE A 122     -11.987  29.631  34.350  1.00  0.00           O  
ATOM   1901  CB  ILE A 122      -9.642  28.864  32.184  1.00  0.00           C  
ATOM   1902  CG1 ILE A 122      -8.131  29.010  31.998  1.00  0.00           C  
ATOM   1903  CG2 ILE A 122     -10.400  30.111  31.726  1.00  0.00           C  
ATOM   1904  CD1 ILE A 122      -7.517  27.719  31.453  1.00  0.00           C  
ATOM   1905  H   ILE A 122      -9.060  26.696  33.214  1.00  0.00           H  
ATOM   1906  HA  ILE A 122      -9.466  29.233  34.269  1.00  0.00           H  
ATOM   1907  HB  ILE A 122      -9.966  28.039  31.549  1.00  0.00           H  
ATOM   1908 HG12 ILE A 122      -7.923  29.833  31.314  1.00  0.00           H  
ATOM   1909 HG13 ILE A 122      -7.667  29.263  32.951  1.00  0.00           H  
ATOM   1910 HG21 ILE A 122     -10.300  30.221  30.646  1.00  0.00           H  
ATOM   1911 HG22 ILE A 122     -11.454  30.012  31.985  1.00  0.00           H  
ATOM   1912 HG23 ILE A 122      -9.985  30.990  32.220  1.00  0.00           H  
ATOM   1913 HD11 ILE A 122      -6.584  27.949  30.940  1.00  0.00           H  
ATOM   1914 HD12 ILE A 122      -7.319  27.034  32.277  1.00  0.00           H  
ATOM   1915 HD13 ILE A 122      -8.212  27.254  30.753  1.00  0.00           H  
ATOM   1916  N   LEU A 123     -12.148  27.457  33.745  1.00  0.00           N  
ATOM   1917  CA  LEU A 123     -13.577  27.377  34.000  1.00  0.00           C  
ATOM   1918  C   LEU A 123     -13.838  27.603  35.491  1.00  0.00           C  
ATOM   1919  O   LEU A 123     -14.583  28.508  35.864  1.00  0.00           O  
ATOM   1920  CB  LEU A 123     -14.143  26.058  33.470  1.00  0.00           C  
ATOM   1921  CG  LEU A 123     -14.505  26.033  31.984  1.00  0.00           C  
ATOM   1922  CD1 LEU A 123     -13.801  27.162  31.229  1.00  0.00           C  
ATOM   1923  CD2 LEU A 123     -14.211  24.662  31.370  1.00  0.00           C  
ATOM   1924  H   LEU A 123     -11.730  26.611  33.415  1.00  0.00           H  
ATOM   1925  HA  LEU A 123     -14.054  28.181  33.439  1.00  0.00           H  
ATOM   1926  HB2 LEU A 123     -13.412  25.271  33.659  1.00  0.00           H  
ATOM   1927  HB3 LEU A 123     -15.034  25.811  34.045  1.00  0.00           H  
ATOM   1928  HG  LEU A 123     -15.577  26.203  31.891  1.00  0.00           H  
ATOM   1929 HD11 LEU A 123     -14.308  28.105  31.431  1.00  0.00           H  
ATOM   1930 HD12 LEU A 123     -12.764  27.228  31.558  1.00  0.00           H  
ATOM   1931 HD13 LEU A 123     -13.830  26.956  30.159  1.00  0.00           H  
ATOM   1932 HD21 LEU A 123     -15.084  24.019  31.482  1.00  0.00           H  
ATOM   1933 HD22 LEU A 123     -13.977  24.780  30.313  1.00  0.00           H  
ATOM   1934 HD23 LEU A 123     -13.361  24.210  31.883  1.00  0.00           H  
ATOM   1935  N   GLN A 124     -13.209  26.767  36.303  1.00  0.00           N  
ATOM   1936  CA  GLN A 124     -13.365  26.864  37.744  1.00  0.00           C  
ATOM   1937  C   GLN A 124     -12.764  28.175  38.255  1.00  0.00           C  
ATOM   1938  O   GLN A 124     -13.351  28.841  39.107  1.00  0.00           O  
ATOM   1939  CB  GLN A 124     -12.732  25.661  38.446  1.00  0.00           C  
ATOM   1940  CG  GLN A 124     -13.728  24.504  38.555  1.00  0.00           C  
ATOM   1941  CD  GLN A 124     -13.933  24.092  40.014  1.00  0.00           C  
ATOM   1942  OE1 GLN A 124     -13.070  24.260  40.861  1.00  0.00           O  
ATOM   1943  NE2 GLN A 124     -15.119  23.544  40.261  1.00  0.00           N  
ATOM   1944  H   GLN A 124     -12.605  26.033  35.992  1.00  0.00           H  
ATOM   1945  HA  GLN A 124     -14.440  26.856  37.921  1.00  0.00           H  
ATOM   1946  HB2 GLN A 124     -11.850  25.335  37.895  1.00  0.00           H  
ATOM   1947  HB3 GLN A 124     -12.397  25.951  39.442  1.00  0.00           H  
ATOM   1948  HG2 GLN A 124     -14.683  24.799  38.119  1.00  0.00           H  
ATOM   1949  HG3 GLN A 124     -13.365  23.652  37.980  1.00  0.00           H  
ATOM   1950 HE21 GLN A 124     -15.782  23.434  39.520  1.00  0.00           H  
ATOM   1951 HE22 GLN A 124     -15.347  23.241  41.186  1.00  0.00           H  
ATOM   1952  N   LEU A 125     -11.601  28.507  37.714  1.00  0.00           N  
ATOM   1953  CA  LEU A 125     -10.914  29.726  38.104  1.00  0.00           C  
ATOM   1954  C   LEU A 125     -11.753  30.935  37.684  1.00  0.00           C  
ATOM   1955  O   LEU A 125     -11.782  31.947  38.384  1.00  0.00           O  
ATOM   1956  CB  LEU A 125      -9.490  29.742  37.545  1.00  0.00           C  
ATOM   1957  CG  LEU A 125      -8.463  28.899  38.302  1.00  0.00           C  
ATOM   1958  CD1 LEU A 125      -9.131  27.705  38.987  1.00  0.00           C  
ATOM   1959  CD2 LEU A 125      -7.322  28.465  37.380  1.00  0.00           C  
ATOM   1960  H   LEU A 125     -11.130  27.960  37.021  1.00  0.00           H  
ATOM   1961  HA  LEU A 125     -10.833  29.722  39.190  1.00  0.00           H  
ATOM   1962  HB2 LEU A 125      -9.523  29.397  36.512  1.00  0.00           H  
ATOM   1963  HB3 LEU A 125      -9.141  30.774  37.525  1.00  0.00           H  
ATOM   1964  HG  LEU A 125      -8.026  29.516  39.087  1.00  0.00           H  
ATOM   1965 HD11 LEU A 125      -9.695  28.052  39.853  1.00  0.00           H  
ATOM   1966 HD12 LEU A 125      -9.806  27.215  38.286  1.00  0.00           H  
ATOM   1967 HD13 LEU A 125      -8.367  26.997  39.311  1.00  0.00           H  
ATOM   1968 HD21 LEU A 125      -6.372  28.809  37.791  1.00  0.00           H  
ATOM   1969 HD22 LEU A 125      -7.310  27.379  37.301  1.00  0.00           H  
ATOM   1970 HD23 LEU A 125      -7.468  28.900  36.391  1.00  0.00           H  
ATOM   1971  N   ASN A 126     -12.414  30.790  36.546  1.00  0.00           N  
ATOM   1972  CA  ASN A 126     -13.251  31.858  36.025  1.00  0.00           C  
ATOM   1973  C   ASN A 126     -14.292  32.243  37.077  1.00  0.00           C  
ATOM   1974  O   ASN A 126     -14.686  33.405  37.170  1.00  0.00           O  
ATOM   1975  CB  ASN A 126     -13.995  31.410  34.765  1.00  0.00           C  
ATOM   1976  CG  ASN A 126     -13.315  31.950  33.505  1.00  0.00           C  
ATOM   1977  OD1 ASN A 126     -12.750  33.032  33.489  1.00  0.00           O  
ATOM   1978  ND2 ASN A 126     -13.402  31.141  32.454  1.00  0.00           N  
ATOM   1979  H   ASN A 126     -12.385  29.964  35.983  1.00  0.00           H  
ATOM   1980  HA  ASN A 126     -12.565  32.674  35.798  1.00  0.00           H  
ATOM   1981  HB2 ASN A 126     -14.028  30.322  34.726  1.00  0.00           H  
ATOM   1982  HB3 ASN A 126     -15.027  31.760  34.804  1.00  0.00           H  
ATOM   1983 HD21 ASN A 126     -13.880  30.266  32.535  1.00  0.00           H  
ATOM   1984 HD22 ASN A 126     -12.988  31.406  31.584  1.00  0.00           H  
ATOM   1985  N   PHE A 127     -14.709  31.246  37.844  1.00  0.00           N  
ATOM   1986  CA  PHE A 127     -15.697  31.466  38.886  1.00  0.00           C  
ATOM   1987  C   PHE A 127     -15.099  32.259  40.051  1.00  0.00           C  
ATOM   1988  O   PHE A 127     -15.729  33.180  40.567  1.00  0.00           O  
ATOM   1989  CB  PHE A 127     -16.128  30.088  39.392  1.00  0.00           C  
ATOM   1990  CG  PHE A 127     -17.424  30.101  40.205  1.00  0.00           C  
ATOM   1991  CD1 PHE A 127     -17.505  30.844  41.343  1.00  0.00           C  
ATOM   1992  CD2 PHE A 127     -18.493  29.370  39.793  1.00  0.00           C  
ATOM   1993  CE1 PHE A 127     -18.708  30.856  42.098  1.00  0.00           C  
ATOM   1994  CE2 PHE A 127     -19.696  29.382  40.548  1.00  0.00           C  
ATOM   1995  CZ  PHE A 127     -19.778  30.125  41.685  1.00  0.00           C  
ATOM   1996  H   PHE A 127     -14.384  30.304  37.763  1.00  0.00           H  
ATOM   1997  HA  PHE A 127     -16.514  32.035  38.443  1.00  0.00           H  
ATOM   1998  HB2 PHE A 127     -16.254  29.422  38.538  1.00  0.00           H  
ATOM   1999  HB3 PHE A 127     -15.329  29.671  40.006  1.00  0.00           H  
ATOM   2000  HD1 PHE A 127     -16.648  31.429  41.674  1.00  0.00           H  
ATOM   2001  HD2 PHE A 127     -18.428  28.774  38.882  1.00  0.00           H  
ATOM   2002  HE1 PHE A 127     -18.773  31.450  43.008  1.00  0.00           H  
ATOM   2003  HE2 PHE A 127     -20.553  28.796  40.218  1.00  0.00           H  
ATOM   2004  HZ  PHE A 127     -20.700  30.133  42.265  1.00  0.00           H  
ATOM   2005  N   GLU A 128     -13.890  31.872  40.429  1.00  0.00           N  
ATOM   2006  CA  GLU A 128     -13.199  32.535  41.522  1.00  0.00           C  
ATOM   2007  C   GLU A 128     -12.624  33.872  41.053  1.00  0.00           C  
ATOM   2008  O   GLU A 128     -12.392  34.771  41.861  1.00  0.00           O  
ATOM   2009  CB  GLU A 128     -12.103  31.639  42.103  1.00  0.00           C  
ATOM   2010  CG  GLU A 128     -12.538  30.172  42.103  1.00  0.00           C  
ATOM   2011  CD  GLU A 128     -11.743  29.365  43.132  1.00  0.00           C  
ATOM   2012  OE1 GLU A 128     -10.498  29.468  43.095  1.00  0.00           O  
ATOM   2013  OE2 GLU A 128     -12.399  28.663  43.932  1.00  0.00           O  
ATOM   2014  H   GLU A 128     -13.384  31.121  40.003  1.00  0.00           H  
ATOM   2015  HA  GLU A 128     -13.961  32.706  42.283  1.00  0.00           H  
ATOM   2016  HB2 GLU A 128     -11.190  31.751  41.519  1.00  0.00           H  
ATOM   2017  HB3 GLU A 128     -11.873  31.953  43.120  1.00  0.00           H  
ATOM   2018  HG2 GLU A 128     -13.603  30.104  42.326  1.00  0.00           H  
ATOM   2019  HG3 GLU A 128     -12.393  29.745  41.110  1.00  0.00           H  
ATOM   2020  N   ALA A 129     -12.407  33.961  39.748  1.00  0.00           N  
ATOM   2021  CA  ALA A 129     -11.863  35.174  39.163  1.00  0.00           C  
ATOM   2022  C   ALA A 129     -12.917  36.281  39.218  1.00  0.00           C  
ATOM   2023  O   ALA A 129     -12.590  37.444  39.451  1.00  0.00           O  
ATOM   2024  CB  ALA A 129     -11.397  34.886  37.734  1.00  0.00           C  
ATOM   2025  H   ALA A 129     -12.599  33.226  39.099  1.00  0.00           H  
ATOM   2026  HA  ALA A 129     -11.001  35.474  39.759  1.00  0.00           H  
ATOM   2027  HB1 ALA A 129     -12.101  34.210  37.251  1.00  0.00           H  
ATOM   2028  HB2 ALA A 129     -11.345  35.818  37.172  1.00  0.00           H  
ATOM   2029  HB3 ALA A 129     -10.410  34.423  37.760  1.00  0.00           H  
ATOM   2030  N   ALA A 130     -14.161  35.882  39.002  1.00  0.00           N  
ATOM   2031  CA  ALA A 130     -15.266  36.825  39.027  1.00  0.00           C  
ATOM   2032  C   ALA A 130     -15.337  37.486  40.405  1.00  0.00           C  
ATOM   2033  O   ALA A 130     -15.376  38.712  40.508  1.00  0.00           O  
ATOM   2034  CB  ALA A 130     -16.563  36.103  38.658  1.00  0.00           C  
ATOM   2035  H   ALA A 130     -14.419  34.934  38.814  1.00  0.00           H  
ATOM   2036  HA  ALA A 130     -15.065  37.590  38.276  1.00  0.00           H  
ATOM   2037  HB1 ALA A 130     -16.880  36.411  37.663  1.00  0.00           H  
ATOM   2038  HB2 ALA A 130     -16.395  35.026  38.670  1.00  0.00           H  
ATOM   2039  HB3 ALA A 130     -17.339  36.357  39.382  1.00  0.00           H  
ATOM   2040  N   MET A 131     -15.351  36.646  41.428  1.00  0.00           N  
ATOM   2041  CA  MET A 131     -15.417  37.134  42.796  1.00  0.00           C  
ATOM   2042  C   MET A 131     -14.137  37.882  43.172  1.00  0.00           C  
ATOM   2043  O   MET A 131     -14.148  38.727  44.067  1.00  0.00           O  
ATOM   2044  CB  MET A 131     -15.617  35.954  43.749  1.00  0.00           C  
ATOM   2045  CG  MET A 131     -16.961  35.267  43.497  1.00  0.00           C  
ATOM   2046  SD  MET A 131     -18.297  36.326  44.026  1.00  0.00           S  
ATOM   2047  CE  MET A 131     -19.435  35.101  44.651  1.00  0.00           C  
ATOM   2048  H   MET A 131     -15.319  35.651  41.335  1.00  0.00           H  
ATOM   2049  HA  MET A 131     -16.266  37.815  42.823  1.00  0.00           H  
ATOM   2050  HB2 MET A 131     -14.807  35.235  43.620  1.00  0.00           H  
ATOM   2051  HB3 MET A 131     -15.572  36.303  44.780  1.00  0.00           H  
ATOM   2052  HG2 MET A 131     -17.068  35.036  42.437  1.00  0.00           H  
ATOM   2053  HG3 MET A 131     -17.002  34.320  44.035  1.00  0.00           H  
ATOM   2054  HE1 MET A 131     -19.192  34.128  44.224  1.00  0.00           H  
ATOM   2055  HE2 MET A 131     -19.354  35.052  45.737  1.00  0.00           H  
ATOM   2056  HE3 MET A 131     -20.453  35.376  44.374  1.00  0.00           H  
ATOM   2057  N   GLN A 132     -13.064  37.547  42.471  1.00  0.00           N  
ATOM   2058  CA  GLN A 132     -11.779  38.178  42.720  1.00  0.00           C  
ATOM   2059  C   GLN A 132     -11.712  39.539  42.025  1.00  0.00           C  
ATOM   2060  O   GLN A 132     -11.166  40.495  42.575  1.00  0.00           O  
ATOM   2061  CB  GLN A 132     -10.629  37.274  42.271  1.00  0.00           C  
ATOM   2062  CG  GLN A 132     -10.045  36.500  43.455  1.00  0.00           C  
ATOM   2063  CD  GLN A 132      -8.600  36.083  43.178  1.00  0.00           C  
ATOM   2064  OE1 GLN A 132      -8.235  35.708  42.075  1.00  0.00           O  
ATOM   2065  NE2 GLN A 132      -7.800  36.170  44.237  1.00  0.00           N  
ATOM   2066  H   GLN A 132     -13.064  36.860  41.745  1.00  0.00           H  
ATOM   2067  HA  GLN A 132     -11.728  38.312  43.801  1.00  0.00           H  
ATOM   2068  HB2 GLN A 132     -10.985  36.576  41.514  1.00  0.00           H  
ATOM   2069  HB3 GLN A 132      -9.848  37.878  41.806  1.00  0.00           H  
ATOM   2070  HG2 GLN A 132     -10.084  37.117  44.353  1.00  0.00           H  
ATOM   2071  HG3 GLN A 132     -10.652  35.615  43.648  1.00  0.00           H  
ATOM   2072 HE21 GLN A 132      -8.163  36.485  45.113  1.00  0.00           H  
ATOM   2073 HE22 GLN A 132      -6.834  35.919  44.156  1.00  0.00           H  
ATOM   2074  N   GLU A 133     -12.274  39.584  40.826  1.00  0.00           N  
ATOM   2075  CA  GLU A 133     -12.285  40.812  40.050  1.00  0.00           C  
ATOM   2076  C   GLU A 133     -13.312  41.792  40.621  1.00  0.00           C  
ATOM   2077  O   GLU A 133     -13.067  42.996  40.669  1.00  0.00           O  
ATOM   2078  CB  GLU A 133     -12.563  40.525  38.573  1.00  0.00           C  
ATOM   2079  CG  GLU A 133     -11.261  40.286  37.806  1.00  0.00           C  
ATOM   2080  CD  GLU A 133     -11.438  40.588  36.317  1.00  0.00           C  
ATOM   2081  OE1 GLU A 133     -12.006  41.662  36.020  1.00  0.00           O  
ATOM   2082  OE2 GLU A 133     -11.002  39.740  35.510  1.00  0.00           O  
ATOM   2083  H   GLU A 133     -12.716  38.802  40.386  1.00  0.00           H  
ATOM   2084  HA  GLU A 133     -11.282  41.227  40.150  1.00  0.00           H  
ATOM   2085  HB2 GLU A 133     -13.207  39.650  38.485  1.00  0.00           H  
ATOM   2086  HB3 GLU A 133     -13.101  41.364  38.131  1.00  0.00           H  
ATOM   2087  HG2 GLU A 133     -10.472  40.916  38.218  1.00  0.00           H  
ATOM   2088  HG3 GLU A 133     -10.943  39.251  37.936  1.00  0.00           H  
ATOM   2089  N   LYS A 134     -14.440  41.239  41.040  1.00  0.00           N  
ATOM   2090  CA  LYS A 134     -15.506  42.049  41.606  1.00  0.00           C  
ATOM   2091  C   LYS A 134     -14.919  42.993  42.657  1.00  0.00           C  
ATOM   2092  O   LYS A 134     -15.215  44.187  42.658  1.00  0.00           O  
ATOM   2093  CB  LYS A 134     -16.631  41.159  42.138  1.00  0.00           C  
ATOM   2094  CG  LYS A 134     -18.002  41.745  41.795  1.00  0.00           C  
ATOM   2095  CD  LYS A 134     -19.127  40.834  42.292  1.00  0.00           C  
ATOM   2096  CE  LYS A 134     -20.216  41.644  42.999  1.00  0.00           C  
ATOM   2097  NZ  LYS A 134     -20.139  41.447  44.464  1.00  0.00           N  
ATOM   2098  H   LYS A 134     -14.633  40.258  40.998  1.00  0.00           H  
ATOM   2099  HA  LYS A 134     -15.925  42.649  40.798  1.00  0.00           H  
ATOM   2100  HB2 LYS A 134     -16.542  40.160  41.712  1.00  0.00           H  
ATOM   2101  HB3 LYS A 134     -16.537  41.054  43.218  1.00  0.00           H  
ATOM   2102  HG2 LYS A 134     -18.103  42.732  42.246  1.00  0.00           H  
ATOM   2103  HG3 LYS A 134     -18.086  41.878  40.717  1.00  0.00           H  
ATOM   2104  HD2 LYS A 134     -19.560  40.293  41.450  1.00  0.00           H  
ATOM   2105  HD3 LYS A 134     -18.721  40.089  42.975  1.00  0.00           H  
ATOM   2106  HE2 LYS A 134     -20.103  42.702  42.762  1.00  0.00           H  
ATOM   2107  HE3 LYS A 134     -21.197  41.339  42.636  1.00  0.00           H  
ATOM   2108  HZ1 LYS A 134     -19.664  42.222  44.880  1.00  0.00           H  
ATOM   2109  HZ2 LYS A 134     -21.063  41.383  44.841  1.00  0.00           H  
ATOM   2110  HZ3 LYS A 134     -19.639  40.604  44.661  1.00  0.00           H  
ATOM   2111  N   ARG A 135     -14.099  42.422  43.527  1.00  0.00           N  
ATOM   2112  CA  ARG A 135     -13.468  43.198  44.582  1.00  0.00           C  
ATOM   2113  C   ARG A 135     -12.000  43.460  44.242  1.00  0.00           C  
ATOM   2114  O   ARG A 135     -11.110  43.141  45.029  1.00  0.00           O  
ATOM   2115  CB  ARG A 135     -13.552  42.471  45.925  1.00  0.00           C  
ATOM   2116  CG  ARG A 135     -15.004  42.332  46.384  1.00  0.00           C  
ATOM   2117  CD  ARG A 135     -15.279  43.206  47.610  1.00  0.00           C  
ATOM   2118  NE  ARG A 135     -16.088  42.456  48.595  1.00  0.00           N  
ATOM   2119  CZ  ARG A 135     -16.297  42.857  49.856  1.00  0.00           C  
ATOM   2120  NH1 ARG A 135     -15.757  44.003  50.294  1.00  0.00           N  
ATOM   2121  NH2 ARG A 135     -17.047  42.113  50.682  1.00  0.00           N  
ATOM   2122  H   ARG A 135     -13.865  41.450  43.520  1.00  0.00           H  
ATOM   2123  HA  ARG A 135     -14.034  44.129  44.620  1.00  0.00           H  
ATOM   2124  HB2 ARG A 135     -13.099  41.484  45.838  1.00  0.00           H  
ATOM   2125  HB3 ARG A 135     -12.981  43.018  46.675  1.00  0.00           H  
ATOM   2126  HG2 ARG A 135     -15.675  42.617  45.573  1.00  0.00           H  
ATOM   2127  HG3 ARG A 135     -15.217  41.290  46.621  1.00  0.00           H  
ATOM   2128  HD2 ARG A 135     -14.337  43.518  48.063  1.00  0.00           H  
ATOM   2129  HD3 ARG A 135     -15.804  44.113  47.310  1.00  0.00           H  
ATOM   2130  HE  ARG A 135     -16.506  41.596  48.302  1.00  0.00           H  
ATOM   2131 HH11 ARG A 135     -15.199  44.559  49.678  1.00  0.00           H  
ATOM   2132 HH12 ARG A 135     -15.913  44.302  51.236  1.00  0.00           H  
ATOM   2133 HH21 ARG A 135     -17.449  41.257  50.356  1.00  0.00           H  
ATOM   2134 HH22 ARG A 135     -17.202  42.412  51.622  1.00  0.00           H  
ATOM   2135  N   ASN A 136     -11.792  44.039  43.068  1.00  0.00           N  
ATOM   2136  CA  ASN A 136     -10.446  44.347  42.615  1.00  0.00           C  
ATOM   2137  C   ASN A 136     -10.522  45.280  41.404  1.00  0.00           C  
ATOM   2138  O   ASN A 136     -10.867  44.849  40.305  1.00  0.00           O  
ATOM   2139  CB  ASN A 136      -9.704  43.079  42.189  1.00  0.00           C  
ATOM   2140  CG  ASN A 136      -8.207  43.349  42.025  1.00  0.00           C  
ATOM   2141  OD1 ASN A 136      -7.478  43.553  42.982  1.00  0.00           O  
ATOM   2142  ND2 ASN A 136      -7.790  43.338  40.762  1.00  0.00           N  
ATOM   2143  H   ASN A 136     -12.521  44.295  42.434  1.00  0.00           H  
ATOM   2144  HA  ASN A 136      -9.955  44.814  43.469  1.00  0.00           H  
ATOM   2145  HB2 ASN A 136      -9.857  42.297  42.932  1.00  0.00           H  
ATOM   2146  HB3 ASN A 136     -10.115  42.711  41.250  1.00  0.00           H  
ATOM   2147 HD21 ASN A 136      -8.440  43.165  40.022  1.00  0.00           H  
ATOM   2148 HD22 ASN A 136      -6.826  43.504  40.552  1.00  0.00           H  
ATOM   2149  N   GLY A 137     -10.194  46.540  41.646  1.00  0.00           N  
ATOM   2150  CA  GLY A 137     -10.220  47.538  40.589  1.00  0.00           C  
ATOM   2151  C   GLY A 137      -8.808  47.836  40.082  1.00  0.00           C  
ATOM   2152  O   GLY A 137      -8.525  47.682  38.896  1.00  0.00           O  
ATOM   2153  H   GLY A 137      -9.915  46.883  42.543  1.00  0.00           H  
ATOM   2154  HA2 GLY A 137     -10.839  47.182  39.765  1.00  0.00           H  
ATOM   2155  HA3 GLY A 137     -10.679  48.453  40.960  1.00  0.00           H  
ATOM   2156  N   ASP A 138      -7.959  48.261  41.007  1.00  0.00           N  
ATOM   2157  CA  ASP A 138      -6.583  48.583  40.669  1.00  0.00           C  
ATOM   2158  C   ASP A 138      -6.032  47.516  39.721  1.00  0.00           C  
ATOM   2159  O   ASP A 138      -5.823  46.372  40.122  1.00  0.00           O  
ATOM   2160  CB  ASP A 138      -5.700  48.607  41.918  1.00  0.00           C  
ATOM   2161  CG  ASP A 138      -6.131  49.605  42.995  1.00  0.00           C  
ATOM   2162  OD1 ASP A 138      -6.223  50.804  42.653  1.00  0.00           O  
ATOM   2163  OD2 ASP A 138      -6.359  49.147  44.135  1.00  0.00           O  
ATOM   2164  H   ASP A 138      -8.197  48.383  41.970  1.00  0.00           H  
ATOM   2165  HA  ASP A 138      -6.626  49.569  40.207  1.00  0.00           H  
ATOM   2166  HB2 ASP A 138      -5.686  47.609  42.354  1.00  0.00           H  
ATOM   2167  HB3 ASP A 138      -4.678  48.839  41.617  1.00  0.00           H  
ATOM   2168  N   SER A 139      -5.813  47.927  38.481  1.00  0.00           N  
ATOM   2169  CA  SER A 139      -5.290  47.021  37.473  1.00  0.00           C  
ATOM   2170  C   SER A 139      -4.912  47.802  36.213  1.00  0.00           C  
ATOM   2171  O   SER A 139      -5.543  48.806  35.888  1.00  0.00           O  
ATOM   2172  CB  SER A 139      -6.305  45.927  37.136  1.00  0.00           C  
ATOM   2173  OG  SER A 139      -7.324  46.398  36.258  1.00  0.00           O  
ATOM   2174  H   SER A 139      -5.986  48.859  38.162  1.00  0.00           H  
ATOM   2175  HA  SER A 139      -4.406  46.568  37.922  1.00  0.00           H  
ATOM   2176  HB2 SER A 139      -5.791  45.084  36.674  1.00  0.00           H  
ATOM   2177  HB3 SER A 139      -6.760  45.558  38.055  1.00  0.00           H  
ATOM   2178  HG  SER A 139      -7.945  47.008  36.751  1.00  0.00           H  
ATOM   2179  N   HIS A 140      -3.884  47.310  35.537  1.00  0.00           N  
ATOM   2180  CA  HIS A 140      -3.415  47.949  34.319  1.00  0.00           C  
ATOM   2181  C   HIS A 140      -3.366  46.922  33.186  1.00  0.00           C  
ATOM   2182  O   HIS A 140      -2.988  45.772  33.402  1.00  0.00           O  
ATOM   2183  CB  HIS A 140      -2.069  48.640  34.552  1.00  0.00           C  
ATOM   2184  CG  HIS A 140      -1.788  49.775  33.596  1.00  0.00           C  
ATOM   2185  ND1 HIS A 140      -0.519  50.061  33.126  1.00  0.00           N  
ATOM   2186  CD2 HIS A 140      -2.624  50.690  33.029  1.00  0.00           C  
ATOM   2187  CE1 HIS A 140      -0.599  51.104  32.314  1.00  0.00           C  
ATOM   2188  NE2 HIS A 140      -1.905  51.493  32.254  1.00  0.00           N  
ATOM   2189  H   HIS A 140      -3.376  46.493  35.807  1.00  0.00           H  
ATOM   2190  HA  HIS A 140      -4.144  48.720  34.069  1.00  0.00           H  
ATOM   2191  HB2 HIS A 140      -2.039  49.021  35.572  1.00  0.00           H  
ATOM   2192  HB3 HIS A 140      -1.273  47.899  34.465  1.00  0.00           H  
ATOM   2193  HD1 HIS A 140       0.318  49.565  33.360  1.00  0.00           H  
ATOM   2194  HD2 HIS A 140      -3.702  50.751  33.185  1.00  0.00           H  
ATOM   2195  HE1 HIS A 140       0.232  51.570  31.784  1.00  0.00           H  
ATOM   2196  N   GLU A 141      -3.755  47.375  32.003  1.00  0.00           N  
ATOM   2197  CA  GLU A 141      -3.760  46.509  30.836  1.00  0.00           C  
ATOM   2198  C   GLU A 141      -3.333  47.292  29.593  1.00  0.00           C  
ATOM   2199  O   GLU A 141      -3.103  48.498  29.663  1.00  0.00           O  
ATOM   2200  CB  GLU A 141      -5.135  45.869  30.634  1.00  0.00           C  
ATOM   2201  CG  GLU A 141      -5.063  44.351  30.807  1.00  0.00           C  
ATOM   2202  CD  GLU A 141      -4.626  43.671  29.508  1.00  0.00           C  
ATOM   2203  OE1 GLU A 141      -5.217  44.014  28.461  1.00  0.00           O  
ATOM   2204  OE2 GLU A 141      -3.712  42.823  29.590  1.00  0.00           O  
ATOM   2205  H   GLU A 141      -4.060  48.312  31.836  1.00  0.00           H  
ATOM   2206  HA  GLU A 141      -3.031  45.728  31.050  1.00  0.00           H  
ATOM   2207  HB2 GLU A 141      -5.843  46.287  31.350  1.00  0.00           H  
ATOM   2208  HB3 GLU A 141      -5.509  46.108  29.639  1.00  0.00           H  
ATOM   2209  HG2 GLU A 141      -4.361  44.105  31.604  1.00  0.00           H  
ATOM   2210  HG3 GLU A 141      -6.038  43.969  31.112  1.00  0.00           H  
ATOM   2211  N   ASP A 142      -3.240  46.574  28.483  1.00  0.00           N  
ATOM   2212  CA  ASP A 142      -2.844  47.186  27.226  1.00  0.00           C  
ATOM   2213  C   ASP A 142      -3.257  46.276  26.068  1.00  0.00           C  
ATOM   2214  O   ASP A 142      -2.919  45.093  26.053  1.00  0.00           O  
ATOM   2215  CB  ASP A 142      -1.327  47.377  27.160  1.00  0.00           C  
ATOM   2216  CG  ASP A 142      -0.504  46.223  27.736  1.00  0.00           C  
ATOM   2217  OD1 ASP A 142      -0.259  46.258  28.961  1.00  0.00           O  
ATOM   2218  OD2 ASP A 142      -0.139  45.333  26.938  1.00  0.00           O  
ATOM   2219  H   ASP A 142      -3.429  45.593  28.434  1.00  0.00           H  
ATOM   2220  HA  ASP A 142      -3.355  48.148  27.203  1.00  0.00           H  
ATOM   2221  HB2 ASP A 142      -1.039  47.525  26.119  1.00  0.00           H  
ATOM   2222  HB3 ASP A 142      -1.068  48.291  27.695  1.00  0.00           H  
ATOM   2223  N   ASP A 143      -3.980  46.862  25.125  1.00  0.00           N  
ATOM   2224  CA  ASP A 143      -4.442  46.118  23.965  1.00  0.00           C  
ATOM   2225  C   ASP A 143      -4.341  47.004  22.723  1.00  0.00           C  
ATOM   2226  O   ASP A 143      -4.725  48.172  22.757  1.00  0.00           O  
ATOM   2227  CB  ASP A 143      -5.903  45.696  24.129  1.00  0.00           C  
ATOM   2228  CG  ASP A 143      -6.815  46.752  24.755  1.00  0.00           C  
ATOM   2229  OD1 ASP A 143      -7.273  47.632  23.994  1.00  0.00           O  
ATOM   2230  OD2 ASP A 143      -7.034  46.657  25.982  1.00  0.00           O  
ATOM   2231  H   ASP A 143      -4.249  47.824  25.144  1.00  0.00           H  
ATOM   2232  HA  ASP A 143      -3.792  45.245  23.908  1.00  0.00           H  
ATOM   2233  HB2 ASP A 143      -6.300  45.430  23.149  1.00  0.00           H  
ATOM   2234  HB3 ASP A 143      -5.939  44.795  24.742  1.00  0.00           H  
ATOM   2235  N   GLU A 144      -3.823  46.416  21.654  1.00  0.00           N  
ATOM   2236  CA  GLU A 144      -3.667  47.138  20.404  1.00  0.00           C  
ATOM   2237  C   GLU A 144      -3.097  46.214  19.325  1.00  0.00           C  
ATOM   2238  O   GLU A 144      -1.892  45.972  19.284  1.00  0.00           O  
ATOM   2239  CB  GLU A 144      -2.783  48.373  20.590  1.00  0.00           C  
ATOM   2240  CG  GLU A 144      -2.830  49.272  19.352  1.00  0.00           C  
ATOM   2241  CD  GLU A 144      -4.101  50.123  19.339  1.00  0.00           C  
ATOM   2242  OE1 GLU A 144      -4.490  50.578  20.437  1.00  0.00           O  
ATOM   2243  OE2 GLU A 144      -4.655  50.298  18.232  1.00  0.00           O  
ATOM   2244  H   GLU A 144      -3.513  45.465  21.635  1.00  0.00           H  
ATOM   2245  HA  GLU A 144      -4.671  47.455  20.126  1.00  0.00           H  
ATOM   2246  HB2 GLU A 144      -3.117  48.934  21.464  1.00  0.00           H  
ATOM   2247  HB3 GLU A 144      -1.756  48.065  20.782  1.00  0.00           H  
ATOM   2248  HG2 GLU A 144      -1.954  49.921  19.337  1.00  0.00           H  
ATOM   2249  HG3 GLU A 144      -2.788  48.659  18.452  1.00  0.00           H  
ATOM   2250  N   SER A 145      -3.991  45.724  18.479  1.00  0.00           N  
ATOM   2251  CA  SER A 145      -3.591  44.832  17.403  1.00  0.00           C  
ATOM   2252  C   SER A 145      -4.427  45.114  16.153  1.00  0.00           C  
ATOM   2253  O   SER A 145      -5.655  45.143  16.216  1.00  0.00           O  
ATOM   2254  CB  SER A 145      -3.738  43.368  17.819  1.00  0.00           C  
ATOM   2255  OG  SER A 145      -2.628  42.579  17.398  1.00  0.00           O  
ATOM   2256  H   SER A 145      -4.969  45.926  18.519  1.00  0.00           H  
ATOM   2257  HA  SER A 145      -2.540  45.054  17.220  1.00  0.00           H  
ATOM   2258  HB2 SER A 145      -3.834  43.306  18.904  1.00  0.00           H  
ATOM   2259  HB3 SER A 145      -4.654  42.959  17.394  1.00  0.00           H  
ATOM   2260  HG  SER A 145      -1.820  43.158  17.288  1.00  0.00           H  
ATOM   2261  N   GLY A 146      -3.728  45.315  15.046  1.00  0.00           N  
ATOM   2262  CA  GLY A 146      -4.389  45.594  13.783  1.00  0.00           C  
ATOM   2263  C   GLY A 146      -5.498  46.632  13.962  1.00  0.00           C  
ATOM   2264  O   GLY A 146      -6.635  46.283  14.275  1.00  0.00           O  
ATOM   2265  H   GLY A 146      -2.729  45.290  15.003  1.00  0.00           H  
ATOM   2266  HA2 GLY A 146      -3.660  45.957  13.059  1.00  0.00           H  
ATOM   2267  HA3 GLY A 146      -4.810  44.674  13.378  1.00  0.00           H  
ATOM   2268  N   PRO A 147      -5.119  47.921  13.750  1.00  0.00           N  
ATOM   2269  CA  PRO A 147      -6.069  49.013  13.886  1.00  0.00           C  
ATOM   2270  C   PRO A 147      -7.022  49.061  12.691  1.00  0.00           C  
ATOM   2271  O   PRO A 147      -8.240  49.033  12.863  1.00  0.00           O  
ATOM   2272  CB  PRO A 147      -5.214  50.263  14.015  1.00  0.00           C  
ATOM   2273  CG  PRO A 147      -3.841  49.887  13.484  1.00  0.00           C  
ATOM   2274  CD  PRO A 147      -3.781  48.372  13.378  1.00  0.00           C  
ATOM   2275  HA  PRO A 147      -6.645  48.873  14.691  1.00  0.00           H  
ATOM   2276  HB2 PRO A 147      -5.642  51.089  13.445  1.00  0.00           H  
ATOM   2277  HB3 PRO A 147      -5.155  50.590  15.054  1.00  0.00           H  
ATOM   2278  HG2 PRO A 147      -3.670  50.344  12.509  1.00  0.00           H  
ATOM   2279  HG3 PRO A 147      -3.060  50.254  14.150  1.00  0.00           H  
ATOM   2280  HD2 PRO A 147      -3.524  48.054  12.368  1.00  0.00           H  
ATOM   2281  HD3 PRO A 147      -3.025  47.958  14.045  1.00  0.00           H  
ATOM   2282  N   SER A 148      -6.433  49.133  11.506  1.00  0.00           N  
ATOM   2283  CA  SER A 148      -7.215  49.185  10.283  1.00  0.00           C  
ATOM   2284  C   SER A 148      -6.286  49.295   9.072  1.00  0.00           C  
ATOM   2285  O   SER A 148      -5.101  49.593   9.219  1.00  0.00           O  
ATOM   2286  CB  SER A 148      -8.198  50.358  10.308  1.00  0.00           C  
ATOM   2287  OG  SER A 148      -7.577  51.565  10.737  1.00  0.00           O  
ATOM   2288  H   SER A 148      -5.442  49.155  11.375  1.00  0.00           H  
ATOM   2289  HA  SER A 148      -7.770  48.248  10.255  1.00  0.00           H  
ATOM   2290  HB2 SER A 148      -8.617  50.499   9.311  1.00  0.00           H  
ATOM   2291  HB3 SER A 148      -9.028  50.120  10.972  1.00  0.00           H  
ATOM   2292  HG  SER A 148      -6.643  51.616  10.381  1.00  0.00           H  
ATOM   2293  N   SER A 149      -6.858  49.050   7.903  1.00  0.00           N  
ATOM   2294  CA  SER A 149      -6.096  49.119   6.668  1.00  0.00           C  
ATOM   2295  C   SER A 149      -7.046  49.184   5.470  1.00  0.00           C  
ATOM   2296  O   SER A 149      -8.117  48.580   5.489  1.00  0.00           O  
ATOM   2297  CB  SER A 149      -5.155  47.920   6.534  1.00  0.00           C  
ATOM   2298  OG  SER A 149      -3.943  48.265   5.869  1.00  0.00           O  
ATOM   2299  H   SER A 149      -7.822  48.808   7.792  1.00  0.00           H  
ATOM   2300  HA  SER A 149      -5.509  50.035   6.741  1.00  0.00           H  
ATOM   2301  HB2 SER A 149      -4.926  47.527   7.524  1.00  0.00           H  
ATOM   2302  HB3 SER A 149      -5.657  47.125   5.984  1.00  0.00           H  
ATOM   2303  HG  SER A 149      -4.094  49.049   5.266  1.00  0.00           H  
ATOM   2304  N   GLY A 150      -6.620  49.923   4.456  1.00  0.00           N  
ATOM   2305  CA  GLY A 150      -7.418  50.075   3.253  1.00  0.00           C  
ATOM   2306  C   GLY A 150      -8.907  50.172   3.591  1.00  0.00           C  
ATOM   2307  O   GLY A 150      -9.324  51.070   4.323  1.00  0.00           O  
ATOM   2308  H   GLY A 150      -5.747  50.411   4.449  1.00  0.00           H  
ATOM   2309  HA2 GLY A 150      -7.104  50.970   2.714  1.00  0.00           H  
ATOM   2310  HA3 GLY A 150      -7.247  49.228   2.589  1.00  0.00           H  
TER    2311      GLY A 150                                                      
END
MOLECULE T0415.pdb
ATOM      1  N   GLY     1      -3.414  46.102  27.734  1.00 47.41           N  
ATOM      2  CA  GLY     1      -3.122  45.539  26.359  1.00 47.11           C  
ATOM      3  C   GLY     1      -4.177  45.907  25.333  1.00 47.07           C  
ATOM      4  O   GLY     1      -4.078  46.946  24.671  1.00 46.94           O  
ATOM      5  N   LYS     2      -5.171  45.030  25.198  1.00 46.92           N  
ATOM      6  CA  LYS     2      -6.274  45.185  24.253  1.00 46.81           C  
ATOM      7  C   LYS     2      -7.559  44.609  24.888  1.00 46.36           C  
ATOM      8  O   LYS     2      -7.467  43.735  25.759  1.00 45.55           O  
ATOM      9  CB  LYS     2      -5.938  44.505  22.904  1.00 47.31           C  
ATOM     10  CG  LYS     2      -5.486  45.508  21.817  1.00 47.91           C  
ATOM     11  CD  LYS     2      -4.343  45.056  20.919  1.00 47.60           C  
ATOM     12  CE  LYS     2      -4.032  46.152  19.891  1.00 47.58           C  
ATOM     13  NZ  LYS     2      -2.842  45.845  19.044  1.00 48.43           N  
ATOM     14  N   SER     3      -8.737  45.114  24.499  1.00 45.40           N  
ATOM     15  CA  SER     3      -9.967  44.730  25.214  1.00 45.73           C  
ATOM     16  C   SER     3     -11.200  44.568  24.362  1.00 44.97           C  
ATOM     17  O   SER     3     -12.250  44.270  24.886  1.00 43.15           O  
ATOM     18  CB  SER     3     -10.264  45.688  26.408  1.00 45.39           C  
ATOM     19  OG  SER     3     -10.858  46.926  26.031  1.00 44.69           O  
ATOM     20  N   VAL     4     -11.058  44.781  23.063  1.00 46.52           N  
ATOM     21  CA  VAL     4     -12.119  44.569  22.084  1.00 47.84           C  
ATOM     22  C   VAL     4     -11.586  43.824  20.877  1.00 49.90           C  
ATOM     23  O   VAL     4     -10.415  43.942  20.536  1.00 49.02           O  
ATOM     24  CB  VAL     4     -12.814  45.903  21.614  1.00 48.00           C  
ATOM     25  CG1 VAL     4     -13.403  46.612  22.796  1.00 48.15           C  
ATOM     26  CG2 VAL     4     -11.862  46.801  20.873  1.00 46.59           C  
ATOM     27  N   VAL     5     -12.464  43.017  20.284  1.00 52.98           N  
ATOM     28  CA  VAL     5     -12.249  42.400  18.975  1.00 55.45           C  
ATOM     29  C   VAL     5     -13.255  43.030  17.995  1.00 56.86           C  
ATOM     30  O   VAL     5     -14.440  43.149  18.318  1.00 57.09           O  
ATOM     31  CB  VAL     5     -12.496  40.880  18.971  1.00 54.97           C  
ATOM     32  CG1 VAL     5     -11.696  40.218  17.810  1.00 54.63           C  
ATOM     33  CG2 VAL     5     -12.138  40.263  20.301  1.00 54.64           C  
ATOM     34  N   THR     6     -12.765  43.452  16.823  1.00 58.87           N  
ATOM     35  CA  THR     6     -13.605  44.066  15.788  1.00 59.55           C  
ATOM     36  C   THR     6     -14.006  42.974  14.818  1.00 61.76           C  
ATOM     37  O   THR     6     -13.162  42.393  14.144  1.00 61.58           O  
ATOM     38  CB  THR     6     -12.932  45.268  15.121  1.00 59.79           C  
ATOM     39  OG1 THR     6     -12.480  46.179  16.145  1.00 59.48           O  
ATOM     40  CG2 THR     6     -13.915  46.013  14.231  1.00 58.55           C  
ATOM     41  N   LEU     7     -15.294  42.628  14.861  1.00 63.99           N  
ATOM     42  CA  LEU     7     -15.895  41.687  13.919  1.00 65.67           C  
ATOM     43  C   LEU     7     -16.368  42.441  12.667  1.00 66.61           C  
ATOM     44  O   LEU     7     -16.939  43.524  12.751  1.00 67.07           O  
ATOM     45  CB  LEU     7     -17.108  40.974  14.523  1.00 64.90           C  
ATOM     46  CG  LEU     7     -17.177  40.443  15.946  1.00 64.47           C  
ATOM     47  CD1 LEU     7     -18.054  39.221  16.010  1.00 62.44           C  
ATOM     48  CD2 LEU     7     -15.819  40.134  16.496  1.00 65.25           C  
ATOM     49  N   LYS     8     -16.166  41.836  11.506  1.00 68.76           N  
ATOM     50  CA  LYS     8     -16.680  42.380  10.243  1.00 69.47           C  
ATOM     51  C   LYS     8     -18.103  41.907  10.060  1.00 70.09           C  
ATOM     52  O   LYS     8     -18.347  40.694  10.082  1.00 69.59           O  
ATOM     53  CB  LYS     8     -15.813  41.896   9.086  1.00 69.96           C  
ATOM     54  CG  LYS     8     -16.349  42.153   7.703  1.00 70.04           C  
ATOM     55  CD  LYS     8     -15.243  42.025   6.686  1.00 70.59           C  
ATOM     56  CE  LYS     8     -15.612  42.751   5.399  1.00 72.06           C  
ATOM     57  NZ  LYS     8     -14.397  42.961   4.582  1.00 72.38           N  
ATOM     58  N   THR     9     -19.034  42.866   9.948  1.00 71.30           N  
ATOM     59  CA  THR     9     -20.416  42.587   9.508  1.00 72.31           C  
ATOM     60  C   THR     9     -20.616  42.985   8.048  1.00 72.69           C  
ATOM     61  O   THR     9     -19.697  43.484   7.396  1.00 72.53           O  
ATOM     62  CB  THR     9     -21.478  43.286  10.354  1.00 72.49           C  
ATOM     63  OG1 THR     9     -20.896  44.420  10.993  1.00 74.69           O  
ATOM     64  CG2 THR     9     -22.039  42.319  11.430  1.00 74.62           C  
ATOM     65  N   THR    10     -21.825  42.727   7.546  1.00 73.43           N  
ATOM     66  CA  THR    10     -22.161  42.914   6.126  1.00 73.47           C  
ATOM     67  C   THR    10     -21.839  44.354   5.638  1.00 73.38           C  
ATOM     68  O   THR    10     -21.174  44.550   4.599  1.00 72.70           O  
ATOM     69  CB  THR    10     -23.656  42.495   5.849  1.00 73.49           C  
ATOM     70  OG1 THR    10     -24.506  43.007   6.881  1.00 74.37           O  
ATOM     71  CG2 THR    10     -23.794  40.981   5.833  1.00 73.19           C  
ATOM     72  N   ASP    11     -22.248  45.341   6.434  1.00 73.21           N  
ATOM     73  CA  ASP    11     -22.094  46.754   6.059  1.00 73.27           C  
ATOM     74  C   ASP    11     -20.968  47.486   6.829  1.00 73.41           C  
ATOM     75  O   ASP    11     -20.279  48.348   6.242  1.00 73.86           O  
ATOM     76  CB  ASP    11     -23.437  47.492   6.208  1.00 73.82           C  
ATOM     77  CG  ASP    11     -24.153  47.149   7.512  1.00 74.89           C  
ATOM     78  OD1 ASP    11     -23.756  46.136   8.160  1.00 74.50           O  
ATOM     79  OD2 ASP    11     -25.105  47.888   7.872  1.00 74.98           O  
ATOM     80  N   GLY    12     -20.777  47.148   8.118  1.00 72.48           N  
ATOM     81  CA  GLY    12     -19.792  47.843   8.984  1.00 71.07           C  
ATOM     82  C   GLY    12     -19.007  46.880   9.851  1.00 70.00           C  
ATOM     83  O   GLY    12     -19.016  45.682   9.595  1.00 71.63           O  
ATOM     84  N   TRP    13     -18.304  47.400  10.853  1.00 68.05           N  
ATOM     85  CA  TRP    13     -17.557  46.562  11.841  1.00 66.68           C  
ATOM     86  C   TRP    13     -18.007  46.884  13.261  1.00 65.08           C  
ATOM     87  O   TRP    13     -18.280  48.050  13.606  1.00 64.47           O  
ATOM     88  CB  TRP    13     -16.060  46.842  11.792  1.00 64.59           C  
ATOM     89  CG  TRP    13     -15.332  46.422  10.588  1.00 62.93           C  
ATOM     90  CD1 TRP    13     -14.752  45.202  10.360  1.00 61.34           C  
ATOM     91  CD2 TRP    13     -15.018  47.240   9.461  1.00 61.52           C  
ATOM     92  NE1 TRP    13     -14.121  45.208   9.157  1.00 61.73           N  
ATOM     93  CE2 TRP    13     -14.268  46.448   8.578  1.00 62.18           C  
ATOM     94  CE3 TRP    13     -15.303  48.566   9.113  1.00 61.31           C  
ATOM     95  CZ2 TRP    13     -13.808  46.933   7.358  1.00 62.15           C  
ATOM     96  CZ3 TRP    13     -14.863  49.041   7.917  1.00 61.84           C  
ATOM     97  CH2 TRP    13     -14.116  48.232   7.046  1.00 62.33           C  
ATOM     98  N   ILE    14     -18.024  45.862  14.098  1.00 63.48           N  
ATOM     99  CA  ILE    14     -18.594  45.986  15.416  1.00 62.69           C  
ATOM    100  C   ILE    14     -17.526  45.612  16.442  1.00 62.71           C  
ATOM    101  O   ILE    14     -17.085  44.463  16.481  1.00 62.94           O  
ATOM    102  CB  ILE    14     -19.900  45.154  15.502  1.00 63.10           C  
ATOM    103  CG1 ILE    14     -20.867  45.664  14.398  1.00 62.59           C  
ATOM    104  CG2 ILE    14     -20.506  45.213  16.915  1.00 62.39           C  
ATOM    105  CD1 ILE    14     -22.294  45.381  14.613  1.00 62.33           C  
ATOM    106  N   PRO    15     -17.055  46.604  17.238  1.00 62.46           N  
ATOM    107  CA  PRO    15     -16.190  46.303  18.381  1.00 62.34           C  
ATOM    108  C   PRO    15     -16.956  45.561  19.472  1.00 62.33           C  
ATOM    109  O   PRO    15     -18.029  45.984  19.877  1.00 62.62           O  
ATOM    110  CB  PRO    15     -15.729  47.690  18.879  1.00 62.35           C  
ATOM    111  CG  PRO    15     -16.194  48.684  17.878  1.00 61.95           C  
ATOM    112  CD  PRO    15     -17.283  48.056  17.089  1.00 62.29           C  
ATOM    113  N   VAL    16     -16.411  44.424  19.895  1.00 62.70           N  
ATOM    114  CA  VAL    16     -17.012  43.575  20.936  1.00 62.00           C  
ATOM    115  C   VAL    16     -15.947  43.416  22.050  1.00 61.36           C  
ATOM    116  O   VAL    16     -14.801  43.160  21.741  1.00 62.57           O  
ATOM    117  CB  VAL    16     -17.408  42.199  20.316  1.00 62.01           C  
ATOM    118  CG1 VAL    16     -18.064  41.280  21.347  1.00 61.62           C  
ATOM    119  CG2 VAL    16     -18.307  42.408  19.135  1.00 61.84           C  
ATOM    120  N   PRO    17     -16.306  43.598  23.322  1.00 60.41           N  
ATOM    121  CA  PRO    17     -15.359  43.341  24.392  1.00 60.25           C  
ATOM    122  C   PRO    17     -14.991  41.878  24.466  1.00 59.48           C  
ATOM    123  O   PRO    17     -15.821  41.028  24.158  1.00 60.87           O  
ATOM    124  CB  PRO    17     -16.132  43.701  25.679  1.00 59.73           C  
ATOM    125  CG  PRO    17     -17.373  44.271  25.285  1.00 60.45           C  
ATOM    126  CD  PRO    17     -17.621  44.018  23.839  1.00 61.22           C  
ATOM    127  N   PHE    18     -13.779  41.575  24.878  1.00 59.09           N  
ATOM    128  CA  PHE    18     -13.352  40.180  25.028  1.00 60.00           C  
ATOM    129  C   PHE    18     -14.331  39.371  25.874  1.00 59.66           C  
ATOM    130  O   PHE    18     -14.580  38.201  25.601  1.00 59.27           O  
ATOM    131  CB  PHE    18     -11.943  40.079  25.641  1.00 60.36           C  
ATOM    132  CG  PHE    18     -10.829  40.515  24.716  1.00 61.73           C  
ATOM    133  CD1 PHE    18     -11.007  40.611  23.331  1.00 63.29           C  
ATOM    134  CD2 PHE    18      -9.586  40.789  25.229  1.00 63.45           C  
ATOM    135  CE1 PHE    18      -9.972  41.008  22.489  1.00 61.73           C  
ATOM    136  CE2 PHE    18      -8.538  41.181  24.390  1.00 63.81           C  
ATOM    137  CZ  PHE    18      -8.749  41.298  23.018  1.00 63.81           C  
ATOM    138  N   SER    19     -14.896  40.028  26.881  1.00 59.39           N  
ATOM    139  CA  SER    19     -15.812  39.400  27.822  1.00 59.03           C  
ATOM    140  C   SER    19     -17.096  38.837  27.165  1.00 58.26           C  
ATOM    141  O   SER    19     -17.719  37.937  27.703  1.00 59.05           O  
ATOM    142  CB  SER    19     -16.149  40.424  28.932  1.00 58.56           C  
ATOM    143  OG  SER    19     -17.118  41.375  28.499  1.00 60.75           O  
ATOM    144  N   LYS    20     -17.461  39.376  26.003  1.00 57.56           N  
ATOM    145  CA  LYS    20     -18.622  38.984  25.271  1.00 56.87           C  
ATOM    146  C   LYS    20     -18.322  37.990  24.151  1.00 55.79           C  
ATOM    147  O   LYS    20     -19.242  37.475  23.489  1.00 55.89           O  
ATOM    148  CB  LYS    20     -19.297  40.226  24.683  1.00 58.50           C  
ATOM    149  CG  LYS    20     -19.656  41.281  25.714  1.00 61.62           C  
ATOM    150  CD  LYS    20     -21.134  41.349  26.026  1.00 67.10           C  
ATOM    151  CE  LYS    20     -21.841  42.519  25.253  1.00 72.31           C  
ATOM    152  NZ  LYS    20     -23.196  42.117  24.593  1.00 74.04           N  
ATOM    153  N   VAL    21     -17.050  37.681  23.943  1.00 54.46           N  
ATOM    154  CA  VAL    21     -16.674  36.623  22.977  1.00 52.57           C  
ATOM    155  C   VAL    21     -16.825  35.242  23.636  1.00 50.97           C  
ATOM    156  O   VAL    21     -16.201  34.987  24.690  1.00 52.54           O  
ATOM    157  CB  VAL    21     -15.224  36.823  22.448  1.00 53.00           C  
ATOM    158  CG1 VAL    21     -14.850  35.746  21.373  1.00 50.20           C  
ATOM    159  CG2 VAL    21     -15.069  38.272  21.921  1.00 53.32           C  
ATOM    160  N   MET    22     -17.645  34.392  23.031  1.00 47.48           N  
ATOM    161  CA  MET    22     -17.935  33.066  23.535  1.00 45.74           C  
ATOM    162  C   MET    22     -16.919  32.024  23.033  1.00 46.12           C  
ATOM    163  O   MET    22     -16.448  31.187  23.789  1.00 44.25           O  
ATOM    164  CB  MET    22     -19.358  32.651  23.110  1.00 44.28           C  
ATOM    165  CG  MET    22     -20.425  33.576  23.586  1.00 39.75           C  
ATOM    166  SD  MET    22     -22.258  33.106  23.165  0.65 34.59          SE  
ATOM    167  CE  MET    22     -21.956  33.084  21.247  1.00 31.49           C  
ATOM    168  N   TYR    23     -16.635  32.091  21.739  1.00 47.88           N  
ATOM    169  CA  TYR    23     -15.674  31.233  21.061  1.00 49.56           C  
ATOM    170  C   TYR    23     -15.268  31.816  19.681  1.00 50.94           C  
ATOM    171  O   TYR    23     -15.856  32.791  19.174  1.00 51.25           O  
ATOM    172  CB  TYR    23     -16.185  29.770  20.951  1.00 50.31           C  
ATOM    173  CG  TYR    23     -17.372  29.563  20.024  1.00 50.93           C  
ATOM    174  CD1 TYR    23     -18.670  29.616  20.500  1.00 49.91           C  
ATOM    175  CD2 TYR    23     -17.175  29.286  18.667  1.00 52.85           C  
ATOM    176  CE1 TYR    23     -19.720  29.429  19.667  1.00 50.30           C  
ATOM    177  CE2 TYR    23     -18.208  29.114  17.822  1.00 51.25           C  
ATOM    178  CZ  TYR    23     -19.497  29.195  18.315  1.00 52.04           C  
ATOM    179  OH  TYR    23     -20.564  29.013  17.441  1.00 52.22           O  
ATOM    180  N   LEU    24     -14.183  31.287  19.141  1.00 51.88           N  
ATOM    181  CA  LEU    24     -13.715  31.663  17.815  1.00 52.72           C  
ATOM    182  C   LEU    24     -13.626  30.362  17.061  1.00 55.11           C  
ATOM    183  O   LEU    24     -13.285  29.325  17.648  1.00 55.39           O  
ATOM    184  CB  LEU    24     -12.344  32.388  17.826  1.00 52.44           C  
ATOM    185  CG  LEU    24     -12.203  33.773  18.462  1.00 51.64           C  
ATOM    186  CD1 LEU    24     -12.026  33.718  19.998  1.00 51.46           C  
ATOM    187  CD2 LEU    24     -11.038  34.473  17.904  1.00 51.70           C  
ATOM    188  N   GLU    25     -13.973  30.400  15.778  1.00 57.81           N  
ATOM    189  CA  GLU    25     -13.945  29.200  14.949  1.00 59.82           C  
ATOM    190  C   GLU    25     -13.242  29.431  13.614  1.00 60.44           C  
ATOM    191  O   GLU    25     -13.604  30.367  12.875  1.00 59.87           O  
ATOM    192  CB  GLU    25     -15.354  28.677  14.679  1.00 59.79           C  
ATOM    193  CG  GLU    25     -15.347  27.444  13.750  1.00 59.72           C  
ATOM    194  CD  GLU    25     -16.706  26.844  13.534  1.00 61.31           C  
ATOM    195  OE1 GLU    25     -16.770  25.650  13.104  1.00 61.35           O  
ATOM    196  OE2 GLU    25     -17.683  27.569  13.817  1.00 60.92           O  
ATOM    197  N   ALA    26     -12.258  28.568  13.317  1.00 61.72           N  
ATOM    198  CA  ALA    26     -11.662  28.483  11.973  1.00 62.89           C  
ATOM    199  C   ALA    26     -12.565  27.603  11.100  1.00 65.56           C  
ATOM    200  O   ALA    26     -12.829  26.429  11.378  1.00 65.20           O  
ATOM    201  CB  ALA    26     -10.254  27.931  12.019  1.00 62.69           C  
ATOM    202  N   LYS    27     -13.063  28.199  10.044  1.00 69.29           N  
ATOM    203  CA  LYS    27     -14.038  27.541   9.191  1.00 72.27           C  
ATOM    204  C   LYS    27     -13.991  28.167   7.813  1.00 74.02           C  
ATOM    205  O   LYS    27     -13.931  29.384   7.675  1.00 74.45           O  
ATOM    206  CB  LYS    27     -15.429  27.722   9.796  1.00 72.85           C  
ATOM    207  CG  LYS    27     -16.562  27.045   9.080  1.00 71.39           C  
ATOM    208  CD  LYS    27     -17.859  27.743   9.401  1.00 73.27           C  
ATOM    209  CE  LYS    27     -19.021  26.823   9.163  1.00 75.03           C  
ATOM    210  NZ  LYS    27     -20.097  27.510   8.386  1.00 77.07           N  
ATOM    211  N   ASP    28     -14.003  27.317   6.792  1.00 76.84           N  
ATOM    212  CA  ASP    28     -14.027  27.772   5.401  1.00 77.59           C  
ATOM    213  C   ASP    28     -12.925  28.857   5.134  1.00 77.95           C  
ATOM    214  O   ASP    28     -13.183  29.840   4.426  1.00 78.11           O  
ATOM    215  CB  ASP    28     -15.426  28.300   5.088  1.00 78.53           C  
ATOM    216  CG  ASP    28     -16.548  27.225   5.257  1.00 81.48           C  
ATOM    217  OD1 ASP    28     -16.391  26.062   4.800  1.00 85.00           O  
ATOM    218  OD2 ASP    28     -17.619  27.580   5.817  1.00 84.66           O  
ATOM    219  N   LYS    29     -11.732  28.666   5.747  1.00 77.54           N  
ATOM    220  CA  LYS    29     -10.512  29.518   5.589  1.00 76.82           C  
ATOM    221  C   LYS    29     -10.553  30.922   6.239  1.00 76.10           C  
ATOM    222  O   LYS    29      -9.676  31.767   5.982  1.00 75.77           O  
ATOM    223  CB  LYS    29     -10.095  29.633   4.123  1.00 77.31           C  
ATOM    224  CG  LYS    29      -9.776  28.294   3.467  1.00 79.61           C  
ATOM    225  CD  LYS    29      -8.300  28.168   3.028  1.00 82.32           C  
ATOM    226  CE  LYS    29      -7.955  29.110   1.844  1.00 81.95           C  
ATOM    227  NZ  LYS    29      -7.050  28.464   0.864  1.00 81.33           N  
ATOM    228  N   LYS    30     -11.545  31.145   7.103  1.00 74.77           N  
ATOM    229  CA  LYS    30     -11.693  32.419   7.841  1.00 73.86           C  
ATOM    230  C   LYS    30     -11.796  32.163   9.320  1.00 70.12           C  
ATOM    231  O   LYS    30     -12.089  31.054   9.732  1.00 69.63           O  
ATOM    232  CB  LYS    30     -12.969  33.159   7.380  1.00 73.69           C  
ATOM    233  CG  LYS    30     -12.892  33.658   5.940  1.00 75.38           C  
ATOM    234  CD  LYS    30     -14.271  33.861   5.306  1.00 76.35           C  
ATOM    235  CE  LYS    30     -15.069  32.542   5.226  1.00 78.74           C  
ATOM    236  NZ  LYS    30     -15.844  32.376   3.939  1.00 79.28           N  
ATOM    237  N   THR    31     -11.594  33.207  10.111  1.00 66.89           N  
ATOM    238  CA  THR    31     -11.893  33.163  11.549  1.00 65.08           C  
ATOM    239  C   THR    31     -13.220  33.811  11.855  1.00 63.67           C  
ATOM    240  O   THR    31     -13.442  34.948  11.517  1.00 62.84           O  
ATOM    241  CB  THR    31     -10.816  33.875  12.386  1.00 64.71           C  
ATOM    242  OG1 THR    31      -9.580  33.234  12.126  1.00 62.99           O  
ATOM    243  CG2 THR    31     -11.127  33.820  13.897  1.00 63.56           C  
ATOM    244  N   TYR    32     -14.094  33.071  12.517  1.00 62.97           N  
ATOM    245  CA  TYR    32     -15.375  33.591  12.932  1.00 62.51           C  
ATOM    246  C   TYR    32     -15.293  33.820  14.416  1.00 61.62           C  
ATOM    247  O   TYR    32     -14.985  32.920  15.157  1.00 59.82           O  
ATOM    248  CB  TYR    32     -16.482  32.597  12.613  1.00 62.96           C  
ATOM    249  CG  TYR    32     -16.784  32.554  11.163  1.00 63.75           C  
ATOM    250  CD1 TYR    32     -16.112  31.659  10.310  1.00 64.37           C  
ATOM    251  CD2 TYR    32     -17.720  33.424  10.619  1.00 63.97           C  
ATOM    252  CE1 TYR    32     -16.372  31.623   8.960  1.00 63.90           C  
ATOM    253  CE2 TYR    32     -17.995  33.399   9.262  1.00 65.20           C  
ATOM    254  CZ  TYR    32     -17.315  32.500   8.435  1.00 64.90           C  
ATOM    255  OH  TYR    32     -17.603  32.502   7.092  1.00 66.11           O  
ATOM    256  N   VAL    33     -15.552  35.053  14.816  1.00 61.66           N  
ATOM    257  CA  VAL    33     -15.658  35.444  16.205  1.00 61.87           C  
ATOM    258  C   VAL    33     -17.151  35.415  16.578  1.00 62.05           C  
ATOM    259  O   VAL    33     -17.957  36.188  16.059  1.00 61.79           O  
ATOM    260  CB  VAL    33     -15.008  36.840  16.436  1.00 62.18           C  
ATOM    261  CG1 VAL    33     -14.848  37.108  17.914  1.00 61.84           C  
ATOM    262  CG2 VAL    33     -13.647  36.922  15.752  1.00 60.44           C  
ATOM    263  N   ASN    34     -17.497  34.469  17.451  1.00 62.63           N  
ATOM    264  CA  ASN    34     -18.843  34.272  17.968  1.00 62.74           C  
ATOM    265  C   ASN    34     -19.034  34.955  19.334  1.00 63.11           C  
ATOM    266  O   ASN    34     -18.592  34.446  20.374  1.00 62.77           O  
ATOM    267  CB  ASN    34     -19.123  32.787  18.102  1.00 62.29           C  
ATOM    268  CG  ASN    34     -19.303  32.091  16.759  1.00 63.83           C  
ATOM    269  OD1 ASN    34     -18.327  31.761  16.066  1.00 64.13           O  
ATOM    270  ND2 ASN    34     -20.564  31.825  16.410  1.00 61.91           N  
ATOM    271  N   ALA    35     -19.694  36.106  19.302  1.00 63.82           N  
ATOM    272  CA  ALA    35     -19.983  36.927  20.474  1.00 64.45           C  
ATOM    273  C   ALA    35     -21.436  36.713  20.877  1.00 66.13           C  
ATOM    274  O   ALA    35     -22.229  36.105  20.157  1.00 65.78           O  
ATOM    275  CB  ALA    35     -19.695  38.400  20.190  1.00 63.41           C  
ATOM    276  N   GLU    36     -21.795  37.194  22.050  1.00 68.62           N  
ATOM    277  CA  GLU    36     -23.081  36.813  22.627  1.00 71.28           C  
ATOM    278  C   GLU    36     -24.264  37.179  21.727  1.00 72.31           C  
ATOM    279  O   GLU    36     -25.229  36.416  21.623  1.00 72.56           O  
ATOM    280  CB  GLU    36     -23.270  37.459  23.986  1.00 71.27           C  
ATOM    281  CG  GLU    36     -22.296  37.014  25.046  1.00 72.06           C  
ATOM    282  CD  GLU    36     -22.437  37.838  26.279  1.00 72.04           C  
ATOM    283  OE1 GLU    36     -23.142  38.857  26.238  1.00 79.71           O  
ATOM    284  OE2 GLU    36     -21.848  37.506  27.306  1.00 76.93           O  
ATOM    285  N   GLU    37     -24.176  38.350  21.095  1.00 73.72           N  
ATOM    286  CA  GLU    37     -25.256  38.902  20.300  1.00 74.69           C  
ATOM    287  C   GLU    37     -24.968  38.923  18.809  1.00 73.94           C  
ATOM    288  O   GLU    37     -25.870  39.226  18.044  1.00 74.01           O  
ATOM    289  CB  GLU    37     -25.544  40.340  20.756  1.00 75.48           C  
ATOM    290  CG  GLU    37     -26.188  40.454  22.149  1.00 79.08           C  
ATOM    291  CD  GLU    37     -26.492  41.922  22.561  1.00 81.78           C  
ATOM    292  OE1 GLU    37     -26.163  42.870  21.779  1.00 88.35           O  
ATOM    293  OE2 GLU    37     -27.085  42.122  23.668  1.00 90.68           O  
ATOM    294  N   LEU    38     -23.731  38.686  18.375  1.00 73.06           N  
ATOM    295  CA  LEU    38     -23.468  38.604  16.936  1.00 72.61           C  
ATOM    296  C   LEU    38     -22.227  37.794  16.586  1.00 71.39           C  
ATOM    297  O   LEU    38     -21.450  37.416  17.461  1.00 70.69           O  
ATOM    298  CB  LEU    38     -23.486  39.992  16.249  1.00 72.94           C  
ATOM    299  CG  LEU    38     -22.409  41.099  16.273  1.00 74.37           C  
ATOM    300  CD1 LEU    38     -21.356  40.894  17.336  1.00 75.46           C  
ATOM    301  CD2 LEU    38     -21.758  41.268  14.892  1.00 76.18           C  
ATOM    302  N   THR    39     -22.104  37.494  15.295  1.00 69.92           N  
ATOM    303  CA  THR    39     -20.996  36.762  14.757  1.00 69.17           C  
ATOM    304  C   THR    39     -20.404  37.501  13.595  1.00 67.93           C  
ATOM    305  O   THR    39     -21.063  38.201  12.878  1.00 67.20           O  
ATOM    306  CB  THR    39     -21.369  35.320  14.401  1.00 69.41           C  
ATOM    307  OG1 THR    39     -21.821  34.687  15.605  1.00 71.60           O  
ATOM    308  CG2 THR    39     -20.108  34.536  13.876  1.00 69.54           C  
ATOM    309  N   GLY    40     -19.109  37.374  13.441  1.00 67.61           N  
ATOM    310  CA  GLY    40     -18.450  38.155  12.439  1.00 67.41           C  
ATOM    311  C   GLY    40     -17.090  37.590  12.170  1.00 66.88           C  
ATOM    312  O   GLY    40     -16.639  36.670  12.816  1.00 67.02           O  
ATOM    313  N   THR    41     -16.441  38.197  11.209  1.00 66.71           N  
ATOM    314  CA  THR    41     -15.244  37.685  10.614  1.00 66.20           C  
ATOM    315  C   THR    41     -14.079  38.538  11.166  1.00 65.32           C  
ATOM    316  O   THR    41     -14.253  39.725  11.501  1.00 64.33           O  
ATOM    317  CB  THR    41     -15.448  37.747   9.089  1.00 66.32           C  
ATOM    318  OG1 THR    41     -15.778  36.433   8.622  1.00 69.23           O  
ATOM    319  CG2 THR    41     -14.257  38.300   8.359  1.00 65.71           C  
ATOM    320  N   HIS    42     -12.924  37.902  11.318  1.00 64.06           N  
ATOM    321  CA  HIS    42     -11.723  38.584  11.690  1.00 63.72           C  
ATOM    322  C   HIS    42     -10.599  38.078  10.825  1.00 64.21           C  
ATOM    323  O   HIS    42     -10.583  36.908  10.461  1.00 64.45           O  
ATOM    324  CB  HIS    42     -11.367  38.369  13.166  1.00 63.65           C  
ATOM    325  CG  HIS    42     -10.449  39.428  13.691  1.00 62.41           C  
ATOM    326  ND1 HIS    42      -9.112  39.479  13.366  1.00 61.46           N  
ATOM    327  CD2 HIS    42     -10.691  40.528  14.442  1.00 62.93           C  
ATOM    328  CE1 HIS    42      -8.561  40.552  13.911  1.00 63.05           C  
ATOM    329  NE2 HIS    42      -9.496  41.203  14.578  1.00 62.92           N  
ATOM    330  N   LYS    43      -9.637  38.948  10.534  1.00 64.61           N  
ATOM    331  CA  LYS    43      -8.513  38.581   9.688  1.00 65.27           C  
ATOM    332  C   LYS    43      -7.419  37.763  10.375  1.00 64.45           C  
ATOM    333  O   LYS    43      -6.608  37.136   9.710  1.00 64.94           O  
ATOM    334  CB  LYS    43      -7.914  39.844   9.036  1.00 66.18           C  
ATOM    335  CG  LYS    43      -7.385  40.918  10.010  1.00 67.83           C  
ATOM    336  CD  LYS    43      -6.601  41.976   9.258  1.00 67.72           C  
ATOM    337  CE  LYS    43      -5.732  42.773  10.201  1.00 70.39           C  
ATOM    338  NZ  LYS    43      -5.356  44.057   9.555  1.00 73.82           N  
ATOM    339  N   TYR    44      -7.359  37.765  11.694  1.00 64.49           N  
ATOM    340  CA  TYR    44      -6.292  37.035  12.387  1.00 63.96           C  
ATOM    341  C   TYR    44      -6.623  35.581  12.476  1.00 62.69           C  
ATOM    342  O   TYR    44      -7.781  35.206  12.512  1.00 62.31           O  
ATOM    343  CB  TYR    44      -6.062  37.533  13.813  1.00 65.08           C  
ATOM    344  CG  TYR    44      -5.539  38.923  13.976  1.00 65.75           C  
ATOM    345  CD1 TYR    44      -4.940  39.618  12.936  1.00 67.27           C  
ATOM    346  CD2 TYR    44      -5.636  39.546  15.203  1.00 68.59           C  
ATOM    347  CE1 TYR    44      -4.483  40.907  13.114  1.00 67.96           C  
ATOM    348  CE2 TYR    44      -5.174  40.843  15.389  1.00 68.78           C  
ATOM    349  CZ  TYR    44      -4.605  41.505  14.348  1.00 67.12           C  
ATOM    350  OH  TYR    44      -4.168  42.776  14.566  1.00 68.22           O  
ATOM    351  N   SER    45      -5.580  34.766  12.551  1.00 61.92           N  
ATOM    352  CA  SER    45      -5.718  33.320  12.580  1.00 61.21           C  
ATOM    353  C   SER    45      -5.910  32.966  14.035  1.00 60.89           C  
ATOM    354  O   SER    45      -5.765  33.817  14.906  1.00 60.84           O  
ATOM    355  CB  SER    45      -4.449  32.643  12.015  1.00 60.63           C  
ATOM    356  OG  SER    45      -3.358  32.837  12.896  1.00 61.26           O  
ATOM    357  N   LEU    46      -6.241  31.710  14.294  1.00 60.97           N  
ATOM    358  CA  LEU    46      -6.426  31.228  15.652  1.00 60.86           C  
ATOM    359  C   LEU    46      -5.108  31.226  16.395  1.00 61.40           C  
ATOM    360  O   LEU    46      -5.046  31.396  17.627  1.00 61.30           O  
ATOM    361  CB  LEU    46      -7.046  29.836  15.640  1.00 60.45           C  
ATOM    362  CG  LEU    46      -8.517  29.710  15.243  1.00 59.06           C  
ATOM    363  CD1 LEU    46      -8.975  28.342  15.621  1.00 56.63           C  
ATOM    364  CD2 LEU    46      -9.441  30.795  15.873  1.00 56.73           C  
ATOM    365  N   GLN    47      -4.037  31.061  15.632  1.00 62.21           N  
ATOM    366  CA  GLN    47      -2.701  31.132  16.192  1.00 61.91           C  
ATOM    367  C   GLN    47      -2.410  32.553  16.709  1.00 61.17           C  
ATOM    368  O   GLN    47      -1.915  32.726  17.833  1.00 59.89           O  
ATOM    369  CB  GLN    47      -1.670  30.639  15.172  1.00 61.58           C  
ATOM    370  CG  GLN    47      -0.266  30.464  15.791  1.00 63.42           C  
ATOM    371  CD  GLN    47       0.842  30.263  14.748  1.00 64.22           C  
ATOM    372  OE1 GLN    47       1.908  29.738  15.056  1.00 70.90           O  
ATOM    373  NE2 GLN    47       0.603  30.713  13.533  1.00 65.38           N  
ATOM    374  N   GLU    48      -2.731  33.560  15.894  1.00 61.05           N  
ATOM    375  CA  GLU    48      -2.575  34.950  16.300  1.00 61.50           C  
ATOM    376  C   GLU    48      -3.455  35.319  17.491  1.00 60.76           C  
ATOM    377  O   GLU    48      -2.986  35.927  18.458  1.00 60.41           O  
ATOM    378  CB  GLU    48      -2.822  35.888  15.136  1.00 61.77           C  
ATOM    379  CG  GLU    48      -1.623  35.839  14.139  1.00 64.39           C  
ATOM    380  CD  GLU    48      -1.907  36.338  12.699  1.00 63.87           C  
ATOM    381  OE1 GLU    48      -3.074  36.414  12.227  1.00 63.24           O  
ATOM    382  OE2 GLU    48      -0.890  36.620  12.035  1.00 68.21           O  
ATOM    383  N   PHE    49      -4.719  34.943  17.442  1.00 60.08           N  
ATOM    384  CA  PHE    49      -5.592  35.133  18.596  1.00 59.74           C  
ATOM    385  C   PHE    49      -5.080  34.464  19.874  1.00 59.52           C  
ATOM    386  O   PHE    49      -5.273  34.997  20.948  1.00 59.32           O  
ATOM    387  CB  PHE    49      -7.025  34.672  18.295  1.00 59.41           C  
ATOM    388  CG  PHE    49      -7.869  35.716  17.645  1.00 58.45           C  
ATOM    389  CD1 PHE    49      -8.265  36.829  18.346  1.00 59.31           C  
ATOM    390  CD2 PHE    49      -8.277  35.583  16.337  1.00 59.28           C  
ATOM    391  CE1 PHE    49      -9.062  37.809  17.748  1.00 59.58           C  
ATOM    392  CE2 PHE    49      -9.071  36.546  15.743  1.00 58.97           C  
ATOM    393  CZ  PHE    49      -9.463  37.654  16.452  1.00 58.62           C  
ATOM    394  N   GLU    50      -4.438  33.309  19.785  1.00 59.90           N  
ATOM    395  CA  GLU    50      -3.891  32.692  20.993  1.00 60.98           C  
ATOM    396  C   GLU    50      -2.847  33.566  21.696  1.00 60.69           C  
ATOM    397  O   GLU    50      -2.687  33.525  22.913  1.00 61.09           O  
ATOM    398  CB  GLU    50      -3.245  31.350  20.681  1.00 61.30           C  
ATOM    399  CG  GLU    50      -4.198  30.209  20.578  1.00 62.87           C  
ATOM    400  CD  GLU    50      -3.463  28.877  20.628  1.00 63.39           C  
ATOM    401  OE1 GLU    50      -3.150  28.378  19.529  1.00 62.18           O  
ATOM    402  OE2 GLU    50      -3.203  28.357  21.763  1.00 64.88           O  
ATOM    403  N   TYR    51      -2.100  34.319  20.908  1.00 60.43           N  
ATOM    404  CA  TYR    51      -1.147  35.239  21.431  1.00 59.53           C  
ATOM    405  C   TYR    51      -1.873  36.419  22.104  1.00 58.87           C  
ATOM    406  O   TYR    51      -1.497  36.853  23.180  1.00 57.91           O  
ATOM    407  CB  TYR    51      -0.190  35.717  20.308  1.00 60.13           C  
ATOM    408  CG  TYR    51       0.664  36.911  20.739  1.00 60.63           C  
ATOM    409  CD1 TYR    51       1.815  36.725  21.527  1.00 60.30           C  
ATOM    410  CD2 TYR    51       0.271  38.213  20.442  1.00 59.27           C  
ATOM    411  CE1 TYR    51       2.575  37.801  21.974  1.00 60.07           C  
ATOM    412  CE2 TYR    51       1.015  39.298  20.886  1.00 60.70           C  
ATOM    413  CZ  TYR    51       2.179  39.093  21.652  1.00 61.51           C  
ATOM    414  OH  TYR    51       2.937  40.192  22.068  1.00 61.75           O  
ATOM    415  N   LEU    52      -2.928  36.927  21.484  1.00 59.17           N  
ATOM    416  CA  LEU    52      -3.469  38.211  21.913  1.00 59.78           C  
ATOM    417  C   LEU    52      -4.591  38.163  22.951  1.00 58.88           C  
ATOM    418  O   LEU    52      -4.808  39.121  23.689  1.00 58.40           O  
ATOM    419  CB  LEU    52      -3.838  39.056  20.705  1.00 59.99           C  
ATOM    420  CG  LEU    52      -5.137  38.900  19.986  1.00 62.34           C  
ATOM    421  CD1 LEU    52      -6.204  39.814  20.632  1.00 63.11           C  
ATOM    422  CD2 LEU    52      -4.889  39.263  18.464  1.00 61.78           C  
ATOM    423  N   LEU    53      -5.255  37.025  23.034  1.00 58.60           N  
ATOM    424  CA  LEU    53      -6.360  36.850  23.928  1.00 58.14           C  
ATOM    425  C   LEU    53      -5.816  36.464  25.279  1.00 58.30           C  
ATOM    426  O   LEU    53      -4.794  35.750  25.362  1.00 58.20           O  
ATOM    427  CB  LEU    53      -7.317  35.777  23.404  1.00 58.30           C  
ATOM    428  CG  LEU    53      -8.118  36.061  22.113  1.00 57.08           C  
ATOM    429  CD1 LEU    53      -8.762  34.777  21.657  1.00 51.00           C  
ATOM    430  CD2 LEU    53      -9.141  37.175  22.316  1.00 54.58           C  
ATOM    431  N   PRO    54      -6.464  36.963  26.348  1.00 58.29           N  
ATOM    432  CA  PRO    54      -6.008  36.686  27.722  1.00 58.90           C  
ATOM    433  C   PRO    54      -6.029  35.202  28.076  1.00 59.86           C  
ATOM    434  O   PRO    54      -7.042  34.531  27.929  1.00 60.64           O  
ATOM    435  CB  PRO    54      -6.971  37.490  28.613  1.00 58.39           C  
ATOM    436  CG  PRO    54      -7.991  38.073  27.727  1.00 58.75           C  
ATOM    437  CD  PRO    54      -7.626  37.865  26.299  1.00 57.84           C  
ATOM    438  N   LYS    55      -4.902  34.698  28.537  1.00 61.50           N  
ATOM    439  CA  LYS    55      -4.705  33.267  28.684  1.00 63.14           C  
ATOM    440  C   LYS    55      -5.491  32.742  29.909  1.00 62.48           C  
ATOM    441  O   LYS    55      -5.724  31.537  30.039  1.00 62.64           O  
ATOM    442  CB  LYS    55      -3.189  32.944  28.699  1.00 63.10           C  
ATOM    443  CG  LYS    55      -2.533  33.080  30.067  1.00 66.03           C  
ATOM    444  CD  LYS    55      -0.970  33.110  30.025  1.00 66.76           C  
ATOM    445  CE  LYS    55      -0.329  32.841  31.429  1.00 66.49           C  
ATOM    446  NZ  LYS    55      -1.178  33.499  32.466  1.00 68.77           N  
ATOM    447  N   ASP    56      -5.972  33.653  30.754  1.00 62.23           N  
ATOM    448  CA  ASP    56      -6.820  33.272  31.900  1.00 62.66           C  
ATOM    449  C   ASP    56      -8.286  32.924  31.528  1.00 62.28           C  
ATOM    450  O   ASP    56      -9.004  32.312  32.320  1.00 62.43           O  
ATOM    451  CB  ASP    56      -6.774  34.362  32.996  1.00 63.27           C  
ATOM    452  CG  ASP    56      -7.440  35.702  32.578  1.00 65.72           C  
ATOM    453  OD1 ASP    56      -7.542  36.045  31.388  1.00 71.06           O  
ATOM    454  OD2 ASP    56      -7.837  36.464  33.470  1.00 69.99           O  
ATOM    455  N   SER    57      -8.701  33.304  30.319  1.00 61.57           N  
ATOM    456  CA  SER    57     -10.084  33.188  29.870  1.00 60.88           C  
ATOM    457  C   SER    57     -10.259  32.343  28.635  1.00 59.81           C  
ATOM    458  O   SER    57     -11.243  31.649  28.501  1.00 59.87           O  
ATOM    459  CB  SER    57     -10.622  34.581  29.563  1.00 61.29           C  
ATOM    460  OG  SER    57     -11.419  35.015  30.614  1.00 62.81           O  
ATOM    461  N   PHE    58      -9.303  32.437  27.722  1.00 59.09           N  
ATOM    462  CA  PHE    58      -9.379  31.813  26.399  1.00 58.06           C  
ATOM    463  C   PHE    58      -8.452  30.610  26.317  1.00 57.54           C  
ATOM    464  O   PHE    58      -7.371  30.640  26.831  1.00 56.74           O  
ATOM    465  CB  PHE    58      -9.069  32.868  25.328  1.00 57.04           C  
ATOM    466  CG  PHE    58     -10.143  33.942  25.230  1.00 57.21           C  
ATOM    467  CD1 PHE    58     -10.055  35.107  25.979  1.00 58.12           C  
ATOM    468  CD2 PHE    58     -11.283  33.745  24.453  1.00 56.05           C  
ATOM    469  CE1 PHE    58     -11.056  36.083  25.917  1.00 56.66           C  
ATOM    470  CE2 PHE    58     -12.268  34.687  24.390  1.00 55.56           C  
ATOM    471  CZ  PHE    58     -12.160  35.864  25.123  1.00 57.10           C  
ATOM    472  N   ILE    59      -8.926  29.516  25.717  1.00 58.38           N  
ATOM    473  CA  ILE    59      -8.101  28.330  25.484  1.00 58.40           C  
ATOM    474  C   ILE    59      -8.378  27.708  24.119  1.00 57.04           C  
ATOM    475  O   ILE    59      -9.503  27.433  23.783  1.00 57.12           O  
ATOM    476  CB  ILE    59      -8.278  27.248  26.623  1.00 58.94           C  
ATOM    477  CG1 ILE    59      -7.242  26.113  26.455  1.00 59.95           C  
ATOM    478  CG2 ILE    59      -9.671  26.624  26.591  1.00 61.49           C  
ATOM    479  CD1 ILE    59      -7.061  25.222  27.673  1.00 59.51           C  
ATOM    480  N   ARG    60      -7.331  27.507  23.334  1.00 56.09           N  
ATOM    481  CA  ARG    60      -7.365  26.596  22.210  1.00 55.43           C  
ATOM    482  C   ARG    60      -7.704  25.167  22.655  1.00 55.43           C  
ATOM    483  O   ARG    60      -6.964  24.531  23.401  1.00 54.84           O  
ATOM    484  CB  ARG    60      -6.032  26.595  21.470  1.00 55.35           C  
ATOM    485  CG  ARG    60      -6.111  25.946  20.100  1.00 54.80           C  
ATOM    486  CD  ARG    60      -6.621  26.906  19.054  1.00 54.03           C  
ATOM    487  NE  ARG    60      -6.421  26.382  17.706  1.00 54.40           N  
ATOM    488  CZ  ARG    60      -5.341  26.570  16.948  1.00 54.54           C  
ATOM    489  NH1 ARG    60      -4.317  27.302  17.361  1.00 53.75           N  
ATOM    490  NH2 ARG    60      -5.306  26.062  15.726  1.00 52.56           N  
ATOM    491  N   CYS    61      -8.839  24.669  22.157  1.00 55.76           N  
ATOM    492  CA  CYS    61      -9.343  23.361  22.541  1.00 55.48           C  
ATOM    493  C   CYS    61      -9.510  22.395  21.380  1.00 55.23           C  
ATOM    494  O   CYS    61      -9.906  21.259  21.574  1.00 55.26           O  
ATOM    495  CB  CYS    61     -10.665  23.534  23.288  1.00 55.58           C  
ATOM    496  SG  CYS    61     -11.994  24.211  22.330  1.00 53.65           S  
ATOM    497  N   HIS    62      -9.165  22.841  20.182  1.00 55.99           N  
ATOM    498  CA  HIS    62      -9.402  22.100  18.952  1.00 56.21           C  
ATOM    499  C   HIS    62      -8.646  22.898  17.909  1.00 56.71           C  
ATOM    500  O   HIS    62      -8.516  24.087  18.073  1.00 56.13           O  
ATOM    501  CB  HIS    62     -10.904  22.123  18.682  1.00 55.80           C  
ATOM    502  CG  HIS    62     -11.360  21.244  17.560  1.00 55.15           C  
ATOM    503  ND1 HIS    62     -11.127  21.544  16.235  1.00 55.71           N  
ATOM    504  CD2 HIS    62     -12.114  20.120  17.563  1.00 55.19           C  
ATOM    505  CE1 HIS    62     -11.707  20.639  15.472  1.00 57.18           C  
ATOM    506  NE2 HIS    62     -12.324  19.768  16.249  1.00 56.36           N  
ATOM    507  N   ARG    63      -8.158  22.257  16.842  1.00 58.44           N  
ATOM    508  CA  ARG    63      -7.437  22.946  15.749  1.00 59.37           C  
ATOM    509  C   ARG    63      -8.257  24.034  15.090  1.00 58.79           C  
ATOM    510  O   ARG    63      -7.709  24.907  14.434  1.00 59.46           O  
ATOM    511  CB  ARG    63      -6.927  21.953  14.672  1.00 60.11           C  
ATOM    512  CG  ARG    63      -8.010  21.232  13.863  1.00 62.74           C  
ATOM    513  CD  ARG    63      -7.459  20.502  12.602  1.00 65.11           C  
ATOM    514  NE  ARG    63      -8.414  20.771  11.518  1.00 73.56           N  
ATOM    515  CZ  ARG    63      -8.179  21.504  10.427  1.00 75.10           C  
ATOM    516  NH1 ARG    63      -6.978  21.990  10.151  1.00 78.37           N  
ATOM    517  NH2 ARG    63      -9.161  21.719   9.573  1.00 74.99           N  
ATOM    518  N   SER    64      -9.564  23.969  15.261  1.00 58.15           N  
ATOM    519  CA  SER    64     -10.502  24.915  14.654  1.00 58.67           C  
ATOM    520  C   SER    64     -11.241  25.837  15.662  1.00 58.50           C  
ATOM    521  O   SER    64     -12.032  26.676  15.231  1.00 59.59           O  
ATOM    522  CB  SER    64     -11.533  24.110  13.832  1.00 58.55           C  
ATOM    523  OG  SER    64     -11.020  23.791  12.524  1.00 60.29           O  
ATOM    524  N   PHE    65     -10.976  25.713  16.971  1.00 58.22           N  
ATOM    525  CA  PHE    65     -11.703  26.480  18.006  1.00 58.03           C  
ATOM    526  C   PHE    65     -10.839  27.041  19.093  1.00 56.70           C  
ATOM    527  O   PHE    65      -9.964  26.344  19.638  1.00 56.67           O  
ATOM    528  CB  PHE    65     -12.742  25.606  18.710  1.00 59.19           C  
ATOM    529  CG  PHE    65     -13.870  25.194  17.825  1.00 60.22           C  
ATOM    530  CD1 PHE    65     -13.793  24.021  17.083  1.00 63.71           C  
ATOM    531  CD2 PHE    65     -15.010  25.995  17.713  1.00 60.70           C  
ATOM    532  CE1 PHE    65     -14.870  23.647  16.196  1.00 61.83           C  
ATOM    533  CE2 PHE    65     -16.064  25.636  16.875  1.00 62.73           C  
ATOM    534  CZ  PHE    65     -15.991  24.452  16.116  1.00 61.68           C  
ATOM    535  N   ILE    66     -11.110  28.306  19.428  1.00 55.10           N  
ATOM    536  CA  ILE    66     -10.716  28.874  20.707  1.00 53.34           C  
ATOM    537  C   ILE    66     -12.004  29.164  21.526  1.00 53.38           C  
ATOM    538  O   ILE    66     -12.942  29.786  21.037  1.00 51.87           O  
ATOM    539  CB  ILE    66      -9.875  30.163  20.574  1.00 54.09           C  
ATOM    540  CG1 ILE    66      -8.543  29.891  19.855  1.00 50.40           C  
ATOM    541  CG2 ILE    66      -9.676  30.826  21.994  1.00 54.22           C  
ATOM    542  CD1 ILE    66      -7.818  31.110  19.492  1.00 50.41           C  
ATOM    543  N   VAL    67     -12.046  28.673  22.766  1.00 53.17           N  
ATOM    544  CA  VAL    67     -13.202  28.885  23.634  1.00 53.52           C  
ATOM    545  C   VAL    67     -12.893  29.890  24.778  1.00 53.87           C  
ATOM    546  O   VAL    67     -11.735  29.980  25.302  1.00 54.47           O  
ATOM    547  CB  VAL    67     -13.762  27.510  24.166  1.00 53.86           C  
ATOM    548  CG1 VAL    67     -12.883  26.912  25.260  1.00 50.91           C  
ATOM    549  CG2 VAL    67     -15.235  27.649  24.669  1.00 53.80           C  
ATOM    550  N   ASN    68     -13.909  30.652  25.159  1.00 53.60           N  
ATOM    551  CA  ASN    68     -13.868  31.466  26.397  1.00 54.29           C  
ATOM    552  C   ASN    68     -14.450  30.636  27.529  1.00 54.17           C  
ATOM    553  O   ASN    68     -15.636  30.364  27.539  1.00 53.52           O  
ATOM    554  CB  ASN    68     -14.710  32.747  26.209  1.00 54.77           C  
ATOM    555  CG  ASN    68     -14.520  33.760  27.317  1.00 53.31           C  
ATOM    556  OD1 ASN    68     -14.120  33.424  28.392  1.00 54.57           O  
ATOM    557  ND2 ASN    68     -14.863  35.007  27.044  1.00 52.58           N  
ATOM    558  N   VAL    69     -13.618  30.273  28.499  1.00 54.85           N  
ATOM    559  CA  VAL    69     -14.043  29.415  29.612  1.00 55.43           C  
ATOM    560  C   VAL    69     -15.141  30.083  30.436  1.00 56.62           C  
ATOM    561  O   VAL    69     -15.870  29.393  31.166  1.00 58.19           O  
ATOM    562  CB  VAL    69     -12.846  28.968  30.530  1.00 55.37           C  
ATOM    563  CG1 VAL    69     -11.653  28.422  29.661  1.00 55.16           C  
ATOM    564  CG2 VAL    69     -12.377  30.090  31.405  1.00 55.08           C  
ATOM    565  N   ASN    70     -15.299  31.407  30.314  1.00 56.08           N  
ATOM    566  CA  ASN    70     -16.347  32.088  31.060  1.00 56.16           C  
ATOM    567  C   ASN    70     -17.726  31.956  30.477  1.00 56.59           C  
ATOM    568  O   ASN    70     -18.711  32.302  31.130  1.00 56.78           O  
ATOM    569  CB  ASN    70     -15.976  33.553  31.263  1.00 55.78           C  
ATOM    570  CG  ASN    70     -14.760  33.692  32.167  1.00 57.60           C  
ATOM    571  OD1 ASN    70     -14.802  33.308  33.352  1.00 58.65           O  
ATOM    572  ND2 ASN    70     -13.656  34.173  31.602  1.00 56.66           N  
ATOM    573  N   HIS    71     -17.804  31.474  29.237  1.00 57.27           N  
ATOM    574  CA  HIS    71     -19.077  31.130  28.622  1.00 56.72           C  
ATOM    575  C   HIS    71     -19.350  29.661  28.597  1.00 56.36           C  
ATOM    576  O   HIS    71     -20.374  29.254  28.104  1.00 57.18           O  
ATOM    577  CB  HIS    71     -19.166  31.719  27.246  1.00 57.35           C  
ATOM    578  CG  HIS    71     -19.139  33.203  27.259  1.00 57.90           C  
ATOM    579  ND1 HIS    71     -20.280  33.959  27.383  1.00 63.49           N  
ATOM    580  CD2 HIS    71     -18.109  34.078  27.214  1.00 60.53           C  
ATOM    581  CE1 HIS    71     -19.955  35.244  27.396  1.00 62.23           C  
ATOM    582  NE2 HIS    71     -18.639  35.341  27.291  1.00 62.98           N  
ATOM    583  N   ILE    72     -18.467  28.856  29.160  1.00 56.78           N  
ATOM    584  CA  ILE    72     -18.715  27.416  29.278  1.00 57.01           C  
ATOM    585  C   ILE    72     -19.716  27.212  30.391  1.00 58.60           C  
ATOM    586  O   ILE    72     -19.519  27.704  31.521  1.00 59.44           O  
ATOM    587  CB  ILE    72     -17.442  26.564  29.579  1.00 56.64           C  
ATOM    588  CG1 ILE    72     -16.472  26.602  28.392  1.00 55.81           C  
ATOM    589  CG2 ILE    72     -17.812  25.081  29.890  1.00 55.58           C  
ATOM    590  CD1 ILE    72     -15.142  25.972  28.642  1.00 54.02           C  
ATOM    591  N   LYS    73     -20.772  26.466  30.084  1.00 59.67           N  
ATOM    592  CA  LYS    73     -21.706  26.041  31.113  1.00 61.42           C  
ATOM    593  C   LYS    73     -21.262  24.704  31.775  1.00 60.69           C  
ATOM    594  O   LYS    73     -21.191  24.623  33.016  1.00 61.22           O  
ATOM    595  CB  LYS    73     -23.111  25.949  30.533  1.00 61.67           C  
ATOM    596  CG  LYS    73     -24.142  25.461  31.516  1.00 64.57           C  
ATOM    597  CD  LYS    73     -25.534  25.732  31.000  1.00 66.39           C  
ATOM    598  CE  LYS    73     -26.394  24.489  31.034  1.00 71.85           C  
ATOM    599  NZ  LYS    73     -27.081  24.405  32.361  1.00 75.78           N  
ATOM    600  N   ALA    74     -20.935  23.699  30.963  1.00 59.58           N  
ATOM    601  CA  ALA    74     -20.549  22.375  31.470  1.00 59.98           C  
ATOM    602  C   ALA    74     -19.606  21.709  30.482  1.00 59.82           C  
ATOM    603  O   ALA    74     -19.678  21.978  29.271  1.00 59.65           O  
ATOM    604  CB  ALA    74     -21.780  21.458  31.717  1.00 59.20           C  
ATOM    605  N   ILE    75     -18.718  20.867  31.024  1.00 59.52           N  
ATOM    606  CA  ILE    75     -17.764  20.066  30.280  1.00 60.03           C  
ATOM    607  C   ILE    75     -18.177  18.592  30.458  1.00 60.42           C  
ATOM    608  O   ILE    75     -18.284  18.096  31.585  1.00 59.74           O  
ATOM    609  CB  ILE    75     -16.303  20.229  30.794  1.00 60.12           C  
ATOM    610  CG1 ILE    75     -15.880  21.709  30.841  1.00 60.21           C  
ATOM    611  CG2 ILE    75     -15.338  19.325  29.978  1.00 58.97           C  
ATOM    612  CD1 ILE    75     -14.580  22.010  31.675  1.00 58.17           C  
ATOM    613  N   TYR    76     -18.381  17.912  29.331  1.00 61.43           N  
ATOM    614  CA  TYR    76     -18.799  16.505  29.281  1.00 62.33           C  
ATOM    615  C   TYR    76     -17.750  15.657  28.663  1.00 62.77           C  
ATOM    616  O   TYR    76     -17.159  16.044  27.674  1.00 61.86           O  
ATOM    617  CB  TYR    76     -20.067  16.365  28.420  1.00 64.04           C  
ATOM    618  CG  TYR    76     -21.249  17.027  29.074  1.00 64.55           C  
ATOM    619  CD1 TYR    76     -21.826  16.451  30.207  1.00 66.04           C  
ATOM    620  CD2 TYR    76     -21.780  18.217  28.590  1.00 64.45           C  
ATOM    621  CE1 TYR    76     -22.867  17.032  30.858  1.00 67.30           C  
ATOM    622  CE2 TYR    76     -22.879  18.804  29.232  1.00 64.89           C  
ATOM    623  CZ  TYR    76     -23.410  18.204  30.369  1.00 66.45           C  
ATOM    624  OH  TYR    76     -24.482  18.749  31.069  1.00 68.02           O  
ATOM    625  N   PRO    77     -17.504  14.483  29.243  1.00 64.19           N  
ATOM    626  CA  PRO    77     -16.632  13.542  28.528  1.00 65.35           C  
ATOM    627  C   PRO    77     -17.478  12.787  27.532  1.00 65.44           C  
ATOM    628  O   PRO    77     -18.058  11.803  27.890  1.00 65.52           O  
ATOM    629  CB  PRO    77     -16.077  12.640  29.644  1.00 64.99           C  
ATOM    630  CG  PRO    77     -17.099  12.714  30.759  1.00 64.32           C  
ATOM    631  CD  PRO    77     -17.955  13.963  30.548  1.00 64.28           C  
ATOM    632  N   ASP    78     -17.579  13.279  26.304  1.00 66.55           N  
ATOM    633  CA  ASP    78     -18.605  12.768  25.363  1.00 67.46           C  
ATOM    634  C   ASP    78     -18.200  11.397  24.815  1.00 68.08           C  
ATOM    635  O   ASP    78     -19.042  10.591  24.469  1.00 67.98           O  
ATOM    636  CB  ASP    78     -18.926  13.781  24.241  1.00 66.88           C  
ATOM    637  CG  ASP    78     -17.714  14.146  23.391  1.00 68.06           C  
ATOM    638  OD1 ASP    78     -16.610  14.309  23.934  1.00 69.21           O  
ATOM    639  OD2 ASP    78     -17.872  14.306  22.161  1.00 71.97           O  
ATOM    640  N   THR    79     -16.891  11.169  24.769  1.00 69.38           N  
ATOM    641  CA  THR    79     -16.302   9.900  24.417  1.00 69.80           C  
ATOM    642  C   THR    79     -15.089   9.708  25.342  1.00 71.24           C  
ATOM    643  O   THR    79     -14.815  10.525  26.225  1.00 71.66           O  
ATOM    644  CB  THR    79     -15.882   9.878  22.934  1.00 69.96           C  
ATOM    645  OG1 THR    79     -14.634  10.563  22.764  1.00 69.81           O  
ATOM    646  CG2 THR    79     -16.962  10.518  22.057  1.00 67.37           C  
ATOM    647  N   HIS    80     -14.357   8.624  25.156  1.00 72.15           N  
ATOM    648  CA  HIS    80     -13.262   8.321  26.067  1.00 72.09           C  
ATOM    649  C   HIS    80     -12.036   9.199  25.796  1.00 71.66           C  
ATOM    650  O   HIS    80     -11.197   9.380  26.680  1.00 71.54           O  
ATOM    651  CB  HIS    80     -12.905   6.838  25.952  1.00 74.54           C  
ATOM    652  CG  HIS    80     -12.424   6.435  24.588  1.00 77.71           C  
ATOM    653  ND1 HIS    80     -11.076   6.276  24.288  1.00 83.05           N  
ATOM    654  CD2 HIS    80     -13.105   6.163  23.443  1.00 82.06           C  
ATOM    655  CE1 HIS    80     -10.956   5.922  23.015  1.00 84.98           C  
ATOM    656  NE2 HIS    80     -12.172   5.846  22.480  1.00 84.43           N  
ATOM    657  N   SER    81     -11.942   9.770  24.582  1.00 70.35           N  
ATOM    658  CA  SER    81     -10.762  10.594  24.179  1.00 68.31           C  
ATOM    659  C   SER    81     -11.008  12.131  24.030  1.00 66.70           C  
ATOM    660  O   SER    81     -10.070  12.889  23.928  1.00 65.88           O  
ATOM    661  CB  SER    81     -10.207  10.050  22.870  1.00 67.88           C  
ATOM    662  OG  SER    81     -11.261   9.953  21.925  1.00 69.17           O  
ATOM    663  N   THR    82     -12.264  12.568  24.023  1.00 65.31           N  
ATOM    664  CA  THR    82     -12.635  13.963  23.752  1.00 63.25           C  
ATOM    665  C   THR    82     -13.548  14.516  24.859  1.00 62.65           C  
ATOM    666  O   THR    82     -14.080  13.751  25.698  1.00 62.99           O  
ATOM    667  CB  THR    82     -13.446  14.076  22.436  1.00 62.72           C  
ATOM    668  OG1 THR    82     -14.598  13.261  22.563  1.00 60.82           O  
ATOM    669  CG2 THR    82     -12.671  13.635  21.218  1.00 60.62           C  
ATOM    670  N   PHE    83     -13.745  15.848  24.839  1.00 60.99           N  
ATOM    671  CA  PHE    83     -14.822  16.516  25.603  1.00 58.92           C  
ATOM    672  C   PHE    83     -15.751  17.254  24.670  1.00 56.16           C  
ATOM    673  O   PHE    83     -15.435  17.547  23.530  1.00 54.69           O  
ATOM    674  CB  PHE    83     -14.277  17.502  26.651  1.00 59.27           C  
ATOM    675  CG  PHE    83     -13.275  16.897  27.611  1.00 59.80           C  
ATOM    676  CD1 PHE    83     -13.700  16.106  28.681  1.00 59.77           C  
ATOM    677  CD2 PHE    83     -11.904  17.127  27.454  1.00 60.92           C  
ATOM    678  CE1 PHE    83     -12.790  15.550  29.559  1.00 58.13           C  
ATOM    679  CE2 PHE    83     -10.990  16.583  28.347  1.00 59.35           C  
ATOM    680  CZ  PHE    83     -11.440  15.786  29.391  1.00 59.19           C  
ATOM    681  N   LEU    84     -16.918  17.556  25.185  1.00 53.95           N  
ATOM    682  CA  LEU    84     -17.848  18.373  24.479  1.00 53.17           C  
ATOM    683  C   LEU    84     -18.238  19.442  25.469  1.00 51.78           C  
ATOM    684  O   LEU    84     -18.518  19.129  26.641  1.00 52.43           O  
ATOM    685  CB  LEU    84     -19.058  17.527  24.077  1.00 53.53           C  
ATOM    686  CG  LEU    84     -19.986  17.984  23.007  1.00 53.39           C  
ATOM    687  CD1 LEU    84     -19.198  18.656  21.855  1.00 52.65           C  
ATOM    688  CD2 LEU    84     -20.822  16.736  22.567  1.00 53.10           C  
ATOM    689  N   LEU    85     -18.202  20.699  25.019  1.00 49.78           N  
ATOM    690  CA  LEU    85     -18.481  21.845  25.874  1.00 47.93           C  
ATOM    691  C   LEU    85     -19.883  22.320  25.598  1.00 47.39           C  
ATOM    692  O   LEU    85     -20.253  22.639  24.491  1.00 46.54           O  
ATOM    693  CB  LEU    85     -17.478  22.989  25.620  1.00 47.12           C  
ATOM    694  CG  LEU    85     -15.994  22.593  25.581  1.00 45.60           C  
ATOM    695  CD1 LEU    85     -15.078  23.803  25.371  1.00 36.85           C  
ATOM    696  CD2 LEU    85     -15.635  21.783  26.820  1.00 43.69           C  
ATOM    697  N   SER    86     -20.664  22.376  26.648  1.00 47.97           N  
ATOM    698  CA  SER    86     -21.970  23.000  26.640  1.00 48.07           C  
ATOM    699  C   SER    86     -21.781  24.472  26.939  1.00 45.91           C  
ATOM    700  O   SER    86     -21.316  24.814  28.027  1.00 45.30           O  
ATOM    701  CB  SER    86     -22.819  22.353  27.758  1.00 49.42           C  
ATOM    702  OG  SER    86     -24.209  22.619  27.619  1.00 55.91           O  
ATOM    703  N   MET    87     -22.133  25.339  25.988  1.00 44.13           N  
ATOM    704  CA  MET    87     -22.013  26.758  26.179  1.00 43.18           C  
ATOM    705  C   MET    87     -23.277  27.327  26.847  1.00 44.86           C  
ATOM    706  O   MET    87     -24.316  26.668  26.840  1.00 46.03           O  
ATOM    707  CB  MET    87     -21.706  27.472  24.867  1.00 42.05           C  
ATOM    708  CG  MET    87     -20.544  26.909  24.091  1.00 39.14           C  
ATOM    709  SD  MET    87     -18.853  26.839  25.025  0.65 32.51          SE  
ATOM    710  CE  MET    87     -18.588  28.706  25.170  1.00 25.61           C  
ATOM    711  N   ASP    88     -23.161  28.530  27.421  1.00 45.01           N  
ATOM    712  CA  ASP    88     -24.228  29.167  28.115  1.00 46.81           C  
ATOM    713  C   ASP    88     -25.432  29.481  27.224  1.00 47.90           C  
ATOM    714  O   ASP    88     -26.553  29.445  27.691  1.00 49.37           O  
ATOM    715  CB  ASP    88     -23.747  30.512  28.706  1.00 47.48           C  
ATOM    716  CG  ASP    88     -23.081  30.369  30.055  1.00 47.38           C  
ATOM    717  OD1 ASP    88     -23.214  29.307  30.694  1.00 48.80           O  
ATOM    718  OD2 ASP    88     -22.425  31.343  30.484  1.00 50.10           O  
ATOM    719  N   ASN    89     -25.211  29.867  25.973  1.00 48.07           N  
ATOM    720  CA  ASN    89     -26.304  30.126  25.034  1.00 47.90           C  
ATOM    721  C   ASN    89     -26.907  28.853  24.347  1.00 49.95           C  
ATOM    722  O   ASN    89     -27.642  28.968  23.413  1.00 50.38           O  
ATOM    723  CB  ASN    89     -25.798  31.069  23.958  1.00 45.44           C  
ATOM    724  CG  ASN    89     -24.879  30.381  22.963  1.00 39.40           C  
ATOM    725  OD1 ASN    89     -24.424  29.257  23.175  1.00 34.26           O  
ATOM    726  ND2 ASN    89     -24.603  31.048  21.883  1.00 29.72           N  
ATOM    727  N   GLY    90     -26.542  27.654  24.776  1.00 53.52           N  
ATOM    728  CA  GLY    90     -27.030  26.399  24.204  1.00 54.20           C  
ATOM    729  C   GLY    90     -26.150  25.776  23.133  1.00 56.18           C  
ATOM    730  O   GLY    90     -26.474  24.680  22.628  1.00 57.36           O  
ATOM    731  N   GLU    91     -25.073  26.457  22.720  1.00 56.93           N  
ATOM    732  CA  GLU    91     -24.254  25.886  21.631  1.00 56.95           C  
ATOM    733  C   GLU    91     -23.350  24.827  22.213  1.00 57.61           C  
ATOM    734  O   GLU    91     -23.290  24.685  23.431  1.00 58.02           O  
ATOM    735  CB  GLU    91     -23.433  26.916  20.890  1.00 56.78           C  
ATOM    736  CG  GLU    91     -24.264  28.017  20.270  1.00 57.08           C  
ATOM    737  CD  GLU    91     -23.401  28.924  19.417  1.00 57.47           C  
ATOM    738  OE1 GLU    91     -23.367  30.121  19.688  1.00 58.86           O  
ATOM    739  OE2 GLU    91     -22.730  28.435  18.479  1.00 59.86           O  
ATOM    740  N   ARG    92     -22.687  24.057  21.356  1.00 57.41           N  
ATOM    741  CA  ARG    92     -21.666  23.125  21.835  1.00 57.56           C  
ATOM    742  C   ARG    92     -20.394  23.313  21.051  1.00 56.61           C  
ATOM    743  O   ARG    92     -20.410  23.760  19.911  1.00 55.30           O  
ATOM    744  CB  ARG    92     -22.124  21.647  21.825  1.00 57.51           C  
ATOM    745  CG  ARG    92     -22.418  21.066  20.425  1.00 58.70           C  
ATOM    746  CD  ARG    92     -22.994  19.651  20.473  1.00 57.48           C  
ATOM    747  NE  ARG    92     -24.233  19.646  21.242  1.00 59.27           N  
ATOM    748  CZ  ARG    92     -25.438  19.980  20.770  1.00 57.86           C  
ATOM    749  NH1 ARG    92     -25.613  20.330  19.505  1.00 59.25           N  
ATOM    750  NH2 ARG    92     -26.483  19.936  21.573  1.00 52.87           N  
ATOM    751  N   VAL    93     -19.289  22.972  21.689  1.00 57.11           N  
ATOM    752  CA  VAL    93     -17.965  23.112  21.087  1.00 57.84           C  
ATOM    753  C   VAL    93     -17.180  21.874  21.437  1.00 58.17           C  
ATOM    754  O   VAL    93     -17.187  21.457  22.599  1.00 58.56           O  
ATOM    755  CB  VAL    93     -17.239  24.386  21.619  1.00 58.64           C  
ATOM    756  CG1 VAL    93     -15.810  24.448  21.084  1.00 58.11           C  
ATOM    757  CG2 VAL    93     -18.051  25.676  21.270  1.00 55.82           C  
ATOM    758  N   PRO    94     -16.515  21.252  20.444  1.00 58.02           N  
ATOM    759  CA  PRO    94     -15.689  20.114  20.763  1.00 57.04           C  
ATOM    760  C   PRO    94     -14.266  20.415  21.276  1.00 56.72           C  
ATOM    761  O   PRO    94     -13.595  21.314  20.812  1.00 55.21           O  
ATOM    762  CB  PRO    94     -15.623  19.371  19.431  1.00 56.88           C  
ATOM    763  CG  PRO    94     -15.728  20.410  18.407  1.00 56.55           C  
ATOM    764  CD  PRO    94     -16.513  21.540  18.998  1.00 58.06           C  
ATOM    765  N   VAL    95     -13.806  19.590  22.216  1.00 57.49           N  
ATOM    766  CA  VAL    95     -12.400  19.496  22.558  1.00 57.43           C  
ATOM    767  C   VAL    95     -11.897  18.200  21.906  1.00 57.84           C  
ATOM    768  O   VAL    95     -12.341  17.103  22.256  1.00 58.08           O  
ATOM    769  CB  VAL    95     -12.138  19.493  24.114  1.00 57.16           C  
ATOM    770  CG1 VAL    95     -10.658  19.644  24.393  1.00 56.72           C  
ATOM    771  CG2 VAL    95     -12.952  20.582  24.824  1.00 55.41           C  
ATOM    772  N   SER    96     -10.987  18.327  20.944  1.00 58.18           N  
ATOM    773  CA  SER    96     -10.524  17.194  20.222  1.00 57.67           C  
ATOM    774  C   SER    96      -9.576  16.357  21.065  1.00 59.98           C  
ATOM    775  O   SER    96      -9.000  16.821  22.069  1.00 61.04           O  
ATOM    776  CB  SER    96      -9.863  17.634  18.932  1.00 57.68           C  
ATOM    777  OG  SER    96      -8.690  18.397  19.113  1.00 54.88           O  
ATOM    778  N   GLN    97      -9.437  15.100  20.663  1.00 62.13           N  
ATOM    779  CA  GLN    97      -8.498  14.165  21.247  1.00 63.68           C  
ATOM    780  C   GLN    97      -7.093  14.711  21.379  1.00 63.20           C  
ATOM    781  O   GLN    97      -6.396  14.355  22.310  1.00 63.88           O  
ATOM    782  CB  GLN    97      -8.426  12.893  20.401  1.00 63.98           C  
ATOM    783  CG  GLN    97      -7.315  11.913  20.765  1.00 65.68           C  
ATOM    784  CD  GLN    97      -7.566  10.570  20.093  1.00 69.25           C  
ATOM    785  OE1 GLN    97      -7.594   9.510  20.746  1.00 77.40           O  
ATOM    786  NE2 GLN    97      -7.790  10.611  18.775  1.00 77.67           N  
ATOM    787  N   SER    98      -6.677  15.555  20.444  1.00 62.68           N  
ATOM    788  CA  SER    98      -5.321  15.990  20.399  1.00 62.54           C  
ATOM    789  C   SER    98      -5.065  17.182  21.349  1.00 62.49           C  
ATOM    790  O   SER    98      -3.925  17.399  21.797  1.00 63.19           O  
ATOM    791  CB  SER    98      -4.908  16.235  18.949  1.00 62.74           C  
ATOM    792  OG  SER    98      -4.721  17.590  18.659  1.00 66.44           O  
ATOM    793  N   TYR    99      -6.130  17.908  21.684  1.00 61.58           N  
ATOM    794  CA  TYR    99      -6.099  18.982  22.674  1.00 60.92           C  
ATOM    795  C   TYR    99      -6.635  18.599  24.064  1.00 60.08           C  
ATOM    796  O   TYR    99      -6.529  19.379  25.015  1.00 60.11           O  
ATOM    797  CB  TYR    99      -6.913  20.160  22.157  1.00 60.45           C  
ATOM    798  CG  TYR    99      -6.178  20.969  21.133  1.00 61.16           C  
ATOM    799  CD1 TYR    99      -6.142  20.577  19.804  1.00 61.60           C  
ATOM    800  CD2 TYR    99      -5.482  22.103  21.496  1.00 59.09           C  
ATOM    801  CE1 TYR    99      -5.481  21.325  18.881  1.00 61.32           C  
ATOM    802  CE2 TYR    99      -4.860  22.840  20.583  1.00 59.27           C  
ATOM    803  CZ  TYR    99      -4.861  22.464  19.287  1.00 60.11           C  
ATOM    804  OH  TYR    99      -4.169  23.214  18.389  1.00 62.07           O  
ATOM    805  N   ALA   100      -7.203  17.414  24.189  1.00 59.50           N  
ATOM    806  CA  ALA   100      -7.931  17.070  25.399  1.00 59.34           C  
ATOM    807  C   ALA   100      -7.050  17.117  26.668  1.00 59.43           C  
ATOM    808  O   ALA   100      -7.522  17.572  27.707  1.00 58.27           O  
ATOM    809  CB  ALA   100      -8.656  15.714  25.226  1.00 57.93           C  
ATOM    810  N   SER   101      -5.774  16.692  26.594  1.00 60.28           N  
ATOM    811  CA  SER   101      -4.890  16.751  27.798  1.00 60.88           C  
ATOM    812  C   SER   101      -4.494  18.138  28.204  1.00 60.03           C  
ATOM    813  O   SER   101      -4.503  18.456  29.387  1.00 60.35           O  
ATOM    814  CB  SER   101      -3.608  15.932  27.633  1.00 61.76           C  
ATOM    815  OG  SER   101      -3.970  14.573  27.408  1.00 65.08           O  
ATOM    816  N   TYR   102      -4.134  18.944  27.213  1.00 59.68           N  
ATOM    817  CA  TYR   102      -3.797  20.350  27.403  1.00 59.73           C  
ATOM    818  C   TYR   102      -5.014  21.030  27.984  1.00 59.63           C  
ATOM    819  O   TYR   102      -4.918  21.703  28.992  1.00 59.77           O  
ATOM    820  CB  TYR   102      -3.347  20.956  26.057  1.00 60.33           C  
ATOM    821  CG  TYR   102      -3.183  22.451  25.981  1.00 60.01           C  
ATOM    822  CD1 TYR   102      -2.045  23.086  26.447  1.00 60.73           C  
ATOM    823  CD2 TYR   102      -4.178  23.235  25.376  1.00 62.93           C  
ATOM    824  CE1 TYR   102      -1.932  24.485  26.353  1.00 61.97           C  
ATOM    825  CE2 TYR   102      -4.077  24.605  25.265  1.00 60.78           C  
ATOM    826  CZ  TYR   102      -2.961  25.230  25.733  1.00 61.47           C  
ATOM    827  OH  TYR   102      -2.924  26.614  25.611  1.00 61.28           O  
ATOM    828  N   PHE   103      -6.186  20.787  27.401  1.00 58.87           N  
ATOM    829  CA  PHE   103      -7.393  21.423  27.906  1.00 58.44           C  
ATOM    830  C   PHE   103      -7.610  21.102  29.395  1.00 58.43           C  
ATOM    831  O   PHE   103      -7.761  21.995  30.191  1.00 57.76           O  
ATOM    832  CB  PHE   103      -8.614  21.024  27.056  1.00 57.19           C  
ATOM    833  CG  PHE   103      -9.893  21.695  27.462  1.00 57.46           C  
ATOM    834  CD1 PHE   103     -10.193  22.988  27.016  1.00 58.39           C  
ATOM    835  CD2 PHE   103     -10.785  21.066  28.302  1.00 54.61           C  
ATOM    836  CE1 PHE   103     -11.359  23.605  27.359  1.00 54.93           C  
ATOM    837  CE2 PHE   103     -11.956  21.670  28.670  1.00 53.26           C  
ATOM    838  CZ  PHE   103     -12.261  22.937  28.187  1.00 55.72           C  
ATOM    839  N   ARG   104      -7.637  19.834  29.774  1.00 59.22           N  
ATOM    840  CA  ARG   104      -7.950  19.494  31.162  1.00 60.00           C  
ATOM    841  C   ARG   104      -6.859  19.893  32.152  1.00 60.47           C  
ATOM    842  O   ARG   104      -7.148  20.233  33.297  1.00 59.73           O  
ATOM    843  CB  ARG   104      -8.299  18.011  31.298  1.00 59.80           C  
ATOM    844  CG  ARG   104      -7.128  17.081  31.373  1.00 59.77           C  
ATOM    845  CD  ARG   104      -7.547  15.631  31.419  1.00 59.52           C  
ATOM    846  NE  ARG   104      -8.482  15.391  32.508  1.00 59.77           N  
ATOM    847  CZ  ARG   104      -9.353  14.386  32.582  1.00 60.33           C  
ATOM    848  NH1 ARG   104      -9.450  13.478  31.628  1.00 61.97           N  
ATOM    849  NH2 ARG   104     -10.167  14.309  33.614  1.00 62.23           N  
ATOM    850  N   LYS   105      -5.604  19.865  31.698  1.00 62.10           N  
ATOM    851  CA  LYS   105      -4.470  20.312  32.517  1.00 63.34           C  
ATOM    852  C   LYS   105      -4.582  21.811  32.887  1.00 62.97           C  
ATOM    853  O   LYS   105      -4.444  22.184  34.047  1.00 62.68           O  
ATOM    854  CB  LYS   105      -3.128  20.027  31.812  1.00 64.24           C  
ATOM    855  CG  LYS   105      -2.427  18.736  32.260  1.00 66.61           C  
ATOM    856  CD  LYS   105      -1.311  18.291  31.238  1.00 68.13           C  
ATOM    857  CE  LYS   105      -0.252  17.240  31.780  1.00 70.28           C  
ATOM    858  NZ  LYS   105       1.029  17.832  32.420  1.00 70.83           N  
ATOM    859  N   LEU   106      -4.834  22.641  31.883  1.00 62.79           N  
ATOM    860  CA  LEU   106      -4.997  24.068  32.057  1.00 63.04           C  
ATOM    861  C   LEU   106      -6.188  24.423  32.910  1.00 62.22           C  
ATOM    862  O   LEU   106      -6.162  25.437  33.602  1.00 62.09           O  
ATOM    863  CB  LEU   106      -5.076  24.795  30.700  1.00 62.74           C  
ATOM    864  CG  LEU   106      -3.709  25.365  30.317  1.00 64.99           C  
ATOM    865  CD1 LEU   106      -2.561  24.315  30.481  1.00 67.46           C  
ATOM    866  CD2 LEU   106      -3.670  25.949  28.926  1.00 64.48           C  
ATOM    867  N   LEU   107      -7.233  23.619  32.843  1.00 61.85           N  
ATOM    868  CA  LEU   107      -8.463  23.878  33.588  1.00 61.64           C  
ATOM    869  C   LEU   107      -8.471  23.158  34.946  1.00 60.91           C  
ATOM    870  O   LEU   107      -9.338  23.387  35.776  1.00 60.53           O  
ATOM    871  CB  LEU   107      -9.697  23.514  32.736  1.00 61.95           C  
ATOM    872  CG  LEU   107     -10.266  24.672  31.899  1.00 65.01           C  
ATOM    873  CD1 LEU   107      -9.536  24.876  30.576  1.00 66.58           C  
ATOM    874  CD2 LEU   107     -11.706  24.443  31.610  1.00 62.97           C  
ATOM    875  N   GLY   108      -7.511  22.273  35.159  1.00 61.07           N  
ATOM    876  CA  GLY   108      -7.292  21.663  36.452  1.00 61.13           C  
ATOM    877  C   GLY   108      -8.218  20.536  36.869  1.00 61.63           C  
ATOM    878  O   GLY   108      -8.499  20.447  38.068  1.00 62.09           O  
ATOM    879  N   PHE   109      -8.649  19.662  35.931  1.00 60.70           N  
ATOM    880  CA  PHE   109      -9.548  18.522  36.261  1.00 60.08           C  
ATOM    881  C   PHE   109      -9.140  17.140  35.727  1.00 59.62           C  
ATOM    882  O   PHE   109      -8.160  17.063  34.987  1.00 61.02           O  
ATOM    883  CB  PHE   109     -10.971  18.842  35.853  1.00 59.83           C  
ATOM    884  CG  PHE   109     -11.195  18.905  34.371  1.00 58.91           C  
ATOM    885  CD1 PHE   109     -11.609  17.796  33.678  1.00 57.22           C  
ATOM    886  CD2 PHE   109     -11.047  20.087  33.688  1.00 57.96           C  
ATOM    887  CE1 PHE   109     -11.843  17.866  32.347  1.00 59.48           C  
ATOM    888  CE2 PHE   109     -11.274  20.147  32.342  1.00 57.93           C  
ATOM    889  CZ  PHE   109     -11.683  19.047  31.674  1.00 59.32           C  
END
