
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   66 (  520),  selected   66 , name 1xyi_A
# Molecule2: number of CA atoms  109 (  889),  selected  109 , name T0415.pdb
# PARAMETERS: 1xyi_A.T0415.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      G       1           #
LGA    V     2_A      K       2          3.473
LGA    -       -      S       3           -
LGA    K     3_A      V       4          0.885
LGA    V     4_A      V       5          0.573
LGA    K     5_A      T       6          1.356
LGA    F     6_A      L       7          2.218
LGA    K     7_A      K       8          1.485
LGA    Y     8_A      T       9          0.649
LGA    K     9_A      T      10          0.796
LGA    G    10_A      D      11          3.008
LGA    E    11_A      G      12          0.414
LGA    E    12_A      W      13          1.906
LGA    K    13_A      I      14          1.272
LGA    E    14_A      P      15          0.871
LGA    V    15_A      V      16          0.643
LGA    D    16_A      P      17          1.143
LGA    T    17_A      F      18          1.364
LGA    S    18_A      S      19          1.134
LGA    K    19_A      K      20          0.441
LGA    I    20_A      V      21          1.129
LGA    K    21_A      M      22          1.558
LGA    K    22_A      Y      23          2.545
LGA    V    23_A      L      24          2.150
LGA    W    24_A      E      25          1.592
LGA    R    25_A      A      26          1.022
LGA    A    26_A      K      27          0.379
LGA    G    27_A      D      28          2.997
LGA    K    28_A      K      29          2.707
LGA    A    29_A      K      30          1.486
LGA    V    30_A      T      31          1.647
LGA    S    31_A      Y      32          1.283
LGA    F    32_A      V      33          2.651
LGA    T    33_A      N      34          1.835
LGA    Y    34_A      A      35          1.375
LGA    D    35_A      E      36          1.946
LGA    D    36_A      -       -           -
LGA    N    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    K    39_A      -       -           -
LGA    T    40_A      E      37          1.223
LGA    G    41_A      L      38          1.081
LGA    R    42_A      T      39          0.729
LGA    G    43_A      G      40          1.573
LGA    A    44_A      T      41          1.916
LGA    V    45_A      H      42          0.902
LGA    S    46_A      K      43          2.388
LGA    E    47_A      Y      44          3.030
LGA    K    48_A      S      45          4.405
LGA    D    49_A      L      46           -
LGA    -       -      Q      47           -
LGA    A    50_A      E      48          5.284
LGA    P    51_A      F      49          4.036
LGA    K    52_A      E      50          3.996
LGA    -       -      Y      51           -
LGA    -       -      L      52           -
LGA    E    53_A      L      53          0.901
LGA    L    54_A      P      54           -
LGA    L    55_A      K      55           -
LGA    -       -      D      56           -
LGA    -       -      S      57           -
LGA    D    56_A      F      58          5.357
LGA    M    57_A      -       -           -
LGA    L    58_A      I      59          5.963
LGA    A    59_A      R      60          1.517
LGA    R    60_A      -       -           -
LGA    A    61_A      C      61          3.096
LGA    E    62_A      H      62          1.243
LGA    R    63_A      R      63           #
LGA    -       -      S      64           -
LGA    -       -      F      65           -
LGA    -       -      I      66           -
LGA    -       -      V      67           -
LGA    -       -      N      68           -
LGA    -       -      V      69           -
LGA    -       -      N      70           -
LGA    -       -      H      71           -
LGA    -       -      I      72           -
LGA    -       -      K      73           -
LGA    -       -      A      74           -
LGA    -       -      I      75           -
LGA    -       -      Y      76           -
LGA    -       -      P      77           -
LGA    -       -      D      78           -
LGA    -       -      T      79           -
LGA    -       -      H      80           -
LGA    -       -      S      81           -
LGA    -       -      T      82           -
LGA    -       -      F      83           -
LGA    -       -      L      84           -
LGA    -       -      L      85           -
LGA    -       -      S      86           -
LGA    -       -      M      87           -
LGA    -       -      D      88           -
LGA    -       -      N      89           -
LGA    -       -      G      90           -
LGA    -       -      E      91           -
LGA    -       -      R      92           -
LGA    -       -      V      93           -
LGA    -       -      P      94           -
LGA    E    64_A      V      95          1.109
LGA    K    65_A      S      96           #
LGA    K    66_A      Q      97           -
LGA    -       -      S      98           -
LGA    -       -      Y      99           -
LGA    -       -      A     100           -
LGA    -       -      S     101           -
LGA    -       -      Y     102           -
LGA    -       -      F     103           -
LGA    -       -      R     104           -
LGA    -       -      K     105           -
LGA    -       -      L     106           -
LGA    -       -      L     107           -
LGA    -       -      G     108           -
LGA    -       -      F     109           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   66  109    5.0     53    2.32    13.21     39.369     2.190

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.505905 * X  +  -0.332912 * Y  +   0.795757 * Z  + -34.119648
  Y_new =  -0.367588 * X  +   0.917769 * Y  +   0.150261 * Z  +  34.397118
  Z_new =  -0.780345 * X  +  -0.216493 * Y  +  -0.586679 * Z  +  45.118881 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.788080    0.353513  [ DEG:  -159.7452     20.2548 ]
  Theta =   0.895218    2.246375  [ DEG:    51.2922    128.7078 ]
  Phi   =  -2.513240    0.628353  [ DEG:  -143.9980     36.0020 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xyi_A                                        
REMARK     2: T0415.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xyi_A.T0415.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   66  109   5.0   53   2.32   13.21  39.369
REMARK  ---------------------------------------------------------- 
MOLECULE 1xyi_A
HEADER    STRUCTURAL PROTEIN/DNA                  10-NOV-04   1XYI              
TITLE     HYPERTHERMOPHILE CHROMOSOMAL PROTEIN SAC7D DOUBLE MUTANT              
TITLE    2 VAL26ALA/MET29ALA IN COMPLEX WITH DNA GCGATCGC                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DNA-BINDING PROTEINS 7A/7B/7D;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: CHROMOSOMAL PROTEIN SAC7D;                                  
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES;                                                       
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: 5'-D(*GP*CP*GP*AP*TP*CP*GP*C)-3';                          
COMPND   9 CHAIN: B, C;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SULFOLOBUS ACIDOCALDARIUS;                      
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: SAC7D;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET3B;                                    
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 SYNTHETIC: YES                                                       
KEYWDS    PROTEIN-DNA COMPLEX, OLIGONUCLEOTIDE BINDING FOLD                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.-Y.CHEN,T.-P.KO,T.-W.LIN,C.-C.CHOU,C.-J.CHEN,A.H.-J.WANG            
REVDAT   1   08-FEB-05 1XYI    0                                                
JRNL        AUTH   C.-Y.CHEN,T.-P.KO,T.-W.LIN,C.-C.CHOU,C.-J.CHEN,              
JRNL        AUTH 2 A.H.-J.WANG                                                  
JRNL        TITL   PROBING THE DNA KINK STRUCTURE INDUCED BY THE                
JRNL        TITL 2 HYPERTHERMOPHILIC CHROMOSOMAL PROTEIN SAC7D                  
JRNL        REF    NUCLEIC ACIDS RES.            V.  33   430 2005              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  1XYI A    1    66  UNP    P13123   DN71_SULAC       0     65             
SEQRES   1 A   66  MET VAL LYS VAL LYS PHE LYS TYR LYS GLY GLU GLU LYS          
SEQRES   2 A   66  GLU VAL ASP THR SER LYS ILE LYS LYS VAL TRP ARG ALA          
SEQRES   3 A   66  GLY LYS ALA VAL SER PHE THR TYR ASP ASP ASN GLY LYS          
SEQRES   4 A   66  THR GLY ARG GLY ALA VAL SER GLU LYS ASP ALA PRO LYS          
SEQRES   5 A   66  GLU LEU LEU ASP MET LEU ALA ARG ALA GLU ARG GLU LYS          
SEQRES   6 A   66  LYS                                                          
SEQRES   1 B    8   DG  DC  DG  DA  DT  DC  DG  DC                              
SEQRES   1 C    8   DG  DC  DG  DA  DT  DC  DG  DC                              
FORMUL   4  HOH   *207(H2 O)                                                    
CRYST1   37.780   47.270   52.650  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   MET A   1      -8.973  42.357  29.262  1.00 36.80           N  
ATOM      2  CA  MET A   1     -10.134  42.882  28.473  1.00 36.47           C  
ATOM      3  C   MET A   1      -9.726  43.562  27.173  1.00 36.21           C  
ATOM      4  O   MET A   1      -9.656  44.802  27.092  1.00 38.00           O  
ATOM      5  N   VAL A   2      -9.460  42.734  26.166  1.00 35.21           N  
ATOM      6  CA  VAL A   2      -9.035  43.161  24.838  1.00 33.74           C  
ATOM      7  C   VAL A   2     -10.261  43.183  23.933  1.00 31.67           C  
ATOM      8  O   VAL A   2     -11.216  42.430  24.140  1.00 31.86           O  
ATOM      9  CB  VAL A   2      -7.985  42.175  24.259  1.00 34.36           C  
ATOM     10  CG1 VAL A   2      -8.541  40.780  24.260  1.00 34.89           C  
ATOM     11  CG2 VAL A   2      -7.606  42.560  22.838  1.00 36.39           C  
ATOM     12  N   LYS A   3     -10.223  44.027  22.923  1.00 30.08           N  
ATOM     13  CA  LYS A   3     -11.352  44.131  22.035  1.00 29.15           C  
ATOM     14  C   LYS A   3     -11.022  43.504  20.710  1.00 27.96           C  
ATOM     15  O   LYS A   3      -9.920  43.689  20.170  1.00 28.39           O  
ATOM     16  CB  LYS A   3     -11.757  45.585  21.822  1.00 32.99           C  
ATOM     17  CG  LYS A   3     -11.971  46.357  23.096  1.00 35.50           C  
ATOM     18  CD  LYS A   3     -12.362  47.785  22.775  1.00 38.15           C  
ATOM     19  CE  LYS A   3     -11.581  48.759  23.662  1.00 38.81           C  
ATOM     20  NZ  LYS A   3     -11.376  50.070  22.958  1.00 40.00           N  
ATOM     21  N   VAL A   4     -11.966  42.726  20.193  1.00 23.12           N  
ATOM     22  CA  VAL A   4     -11.756  42.117  18.900  1.00 21.35           C  
ATOM     23  C   VAL A   4     -12.475  42.979  17.867  1.00 21.71           C  
ATOM     24  O   VAL A   4     -13.662  43.291  18.032  1.00 20.35           O  
ATOM     25  CB  VAL A   4     -12.302  40.681  18.812  1.00 21.52           C  
ATOM     26  CG1 VAL A   4     -12.249  40.204  17.362  1.00 20.92           C  
ATOM     27  CG2 VAL A   4     -11.490  39.757  19.717  1.00 21.58           C  
ATOM     28  N   LYS A   5     -11.734  43.373  16.836  1.00 22.50           N  
ATOM     29  CA  LYS A   5     -12.259  44.225  15.769  1.00 23.97           C  
ATOM     30  C   LYS A   5     -12.603  43.355  14.598  1.00 23.37           C  
ATOM     31  O   LYS A   5     -11.788  42.598  14.143  1.00 24.28           O  
ATOM     32  CB  LYS A   5     -11.207  45.216  15.308  1.00 26.06           C  
ATOM     33  CG  LYS A   5     -10.990  46.333  16.275  1.00 28.18           C  
ATOM     34  CD  LYS A   5     -11.133  47.702  15.586  1.00 33.69           C  
ATOM     35  CE  LYS A   5     -12.589  48.081  15.242  1.00 34.55           C  
ATOM     36  NZ  LYS A   5     -12.697  49.557  14.921  1.00 36.99           N  
ATOM     37  N   PHE A   6     -13.812  43.507  14.063  1.00 23.44           N  
ATOM     38  CA  PHE A   6     -14.202  42.717  12.924  1.00 22.11           C  
ATOM     39  C   PHE A   6     -15.149  43.516  12.054  1.00 22.47           C  
ATOM     40  O   PHE A   6     -15.774  44.466  12.519  1.00 23.37           O  
ATOM     41  CB  PHE A   6     -14.908  41.428  13.376  1.00 18.95           C  
ATOM     42  CG  PHE A   6     -16.127  41.653  14.270  1.00 18.40           C  
ATOM     43  CD1 PHE A   6     -15.988  41.945  15.618  1.00 18.36           C  
ATOM     44  CD2 PHE A   6     -17.419  41.477  13.753  1.00 16.15           C  
ATOM     45  CE1 PHE A   6     -17.094  42.033  16.419  1.00 18.05           C  
ATOM     46  CE2 PHE A   6     -18.552  41.574  14.566  1.00 17.82           C  
ATOM     47  CZ  PHE A   6     -18.399  41.847  15.885  1.00 18.66           C  
ATOM     48  N   LYS A   7     -15.264  43.064  10.820  1.00 22.77           N  
ATOM     49  CA  LYS A   7     -16.126  43.689   9.812  1.00 24.05           C  
ATOM     50  C   LYS A   7     -17.377  42.822   9.676  1.00 22.35           C  
ATOM     51  O   LYS A   7     -17.291  41.603   9.528  1.00 23.08           O  
ATOM     52  CB  LYS A   7     -15.379  43.747   8.483  1.00 27.71           C  
ATOM     53  CG  LYS A   7     -16.124  44.451   7.378  1.00 31.36           C  
ATOM     54  CD  LYS A   7     -15.276  44.644   6.115  1.00 34.13           C  
ATOM     55  CE  LYS A   7     -14.078  45.555   6.354  1.00 35.48           C  
ATOM     56  NZ  LYS A   7     -13.374  45.866   5.059  1.00 38.35           N  
ATOM     57  N   TYR A   8     -18.544  43.429   9.772  1.00 22.47           N  
ATOM     58  CA  TYR A   8     -19.790  42.690   9.648  1.00 21.11           C  
ATOM     59  C   TYR A   8     -20.668  43.465   8.670  1.00 22.64           C  
ATOM     60  O   TYR A   8     -21.037  44.594   8.957  1.00 23.36           O  
ATOM     61  CB  TYR A   8     -20.440  42.563  11.028  1.00 23.45           C  
ATOM     62  CG  TYR A   8     -21.799  41.912  11.045  1.00 21.59           C  
ATOM     63  CD1 TYR A   8     -21.942  40.540  10.874  1.00 23.67           C  
ATOM     64  CD2 TYR A   8     -22.954  42.690  11.188  1.00 24.40           C  
ATOM     65  CE1 TYR A   8     -23.234  39.933  10.848  1.00 24.10           C  
ATOM     66  CE2 TYR A   8     -24.227  42.117  11.151  1.00 24.50           C  
ATOM     67  CZ  TYR A   8     -24.347  40.732  10.988  1.00 24.48           C  
ATOM     68  OH  TYR A   8     -25.585  40.141  10.992  1.00 24.13           O  
ATOM     69  N   LYS A   9     -20.939  42.868   7.524  1.00 22.21           N  
ATOM     70  CA  LYS A   9     -21.757  43.499   6.483  1.00 24.83           C  
ATOM     71  C   LYS A   9     -21.190  44.857   6.170  1.00 27.06           C  
ATOM     72  O   LYS A   9     -21.939  45.859   6.071  1.00 27.96           O  
ATOM     73  CB  LYS A   9     -23.217  43.619   6.953  1.00 23.62           C  
ATOM     74  CG  LYS A   9     -23.874  42.275   7.200  1.00 22.42           C  
ATOM     75  CD  LYS A   9     -25.383  42.394   7.440  1.00 22.57           C  
ATOM     76  CE  LYS A   9     -26.045  41.021   7.665  1.00 22.31           C  
ATOM     77  NZ  LYS A   9     -27.509  41.076   7.953  1.00 24.36           N  
ATOM     78  N   GLY A  10     -19.868  44.892   6.028  1.00 28.32           N  
ATOM     79  CA  GLY A  10     -19.172  46.129   5.706  1.00 32.07           C  
ATOM     80  C   GLY A  10     -18.851  47.080   6.849  1.00 32.63           C  
ATOM     81  O   GLY A  10     -17.902  47.870   6.706  1.00 35.39           O  
ATOM     82  N   GLU A  11     -19.597  47.016   7.958  1.00 33.91           N  
ATOM     83  CA  GLU A  11     -19.407  47.889   9.129  1.00 33.30           C  
ATOM     84  C   GLU A  11     -18.247  47.443  10.042  1.00 33.30           C  
ATOM     85  O   GLU A  11     -17.926  46.253  10.147  1.00 32.14           O  
ATOM     86  CB  GLU A  11     -20.707  47.936   9.968  1.00 36.65           C  
ATOM     87  CG  GLU A  11     -20.675  48.801  11.246  1.00 39.67           C  
ATOM     88  CD  GLU A  11     -21.970  48.717  12.105  1.00 41.71           C  
ATOM     89  OE1 GLU A  11     -22.091  49.493  13.085  1.00 42.58           O  
ATOM     90  OE2 GLU A  11     -22.857  47.875  11.824  1.00 42.38           O  
ATOM     91  N   GLU A  12     -17.640  48.411  10.710  1.00 32.27           N  
ATOM     92  CA  GLU A  12     -16.538  48.158  11.628  1.00 31.31           C  
ATOM     93  C   GLU A  12     -17.198  47.923  12.986  1.00 31.29           C  
ATOM     94  O   GLU A  12     -17.949  48.761  13.479  1.00 31.65           O  
ATOM     95  CB  GLU A  12     -15.622  49.403  11.643  1.00 32.64           C  
ATOM     96  CG  GLU A  12     -14.139  49.143  11.781  1.00 33.51           C  
ATOM     97  CD  GLU A  12     -13.637  47.921  11.013  1.00 33.45           C  
ATOM     98  OE1 GLU A  12     -13.851  47.795   9.776  1.00 34.18           O  
ATOM     99  OE2 GLU A  12     -12.985  47.093  11.663  1.00 35.95           O  
ATOM    100  N   LYS A  13     -16.934  46.765  13.600  1.00 27.95           N  
ATOM    101  CA  LYS A  13     -17.533  46.429  14.870  1.00 26.81           C  
ATOM    102  C   LYS A  13     -16.457  46.014  15.847  1.00 23.92           C  
ATOM    103  O   LYS A  13     -15.351  45.725  15.455  1.00 25.27           O  
ATOM    104  CB  LYS A  13     -18.512  45.255  14.667  1.00 27.81           C  
ATOM    105  CG  LYS A  13     -19.850  45.637  14.000  1.00 30.80           C  
ATOM    106  CD  LYS A  13     -20.729  46.382  15.018  1.00 34.04           C  
ATOM    107  CE  LYS A  13     -22.010  46.974  14.440  1.00 35.28           C  
ATOM    108  NZ  LYS A  13     -22.723  47.869  15.432  1.00 36.54           N  
ATOM    109  N   GLU A  14     -16.791  46.000  17.114  1.00 25.34           N  
ATOM    110  CA  GLU A  14     -15.852  45.541  18.127  1.00 26.74           C  
ATOM    111  C   GLU A  14     -16.585  44.857  19.272  1.00 25.63           C  
ATOM    112  O   GLU A  14     -17.715  45.210  19.583  1.00 26.16           O  
ATOM    113  CB  GLU A  14     -15.024  46.737  18.654  1.00 29.18           C  
ATOM    114  CG  GLU A  14     -13.607  46.807  18.078  1.00 35.08           C  
ATOM    115  CD  GLU A  14     -12.835  48.085  18.462  1.00 37.80           C  
ATOM    116  OE1 GLU A  14     -11.576  48.059  18.409  1.00 38.82           O  
ATOM    117  OE2 GLU A  14     -13.484  49.112  18.799  1.00 40.15           O  
ATOM    118  N   VAL A  15     -15.982  43.807  19.839  1.00 22.71           N  
ATOM    119  CA  VAL A  15     -16.547  43.134  20.991  1.00 22.16           C  
ATOM    120  C   VAL A  15     -15.409  42.732  21.899  1.00 21.18           C  
ATOM    121  O   VAL A  15     -14.337  42.340  21.412  1.00 20.07           O  
ATOM    122  CB  VAL A  15     -17.413  41.879  20.604  1.00 22.56           C  
ATOM    123  CG1 VAL A  15     -16.566  40.812  19.897  1.00 22.98           C  
ATOM    124  CG2 VAL A  15     -18.047  41.284  21.857  1.00 24.91           C  
ATOM    125  N   ASP A  16     -15.609  42.902  23.197  1.00 21.64           N  
ATOM    126  CA  ASP A  16     -14.599  42.515  24.175  1.00 23.05           C  
ATOM    127  C   ASP A  16     -14.568  40.992  24.176  1.00 22.28           C  
ATOM    128  O   ASP A  16     -15.608  40.328  24.075  1.00 21.66           O  
ATOM    129  CB  ASP A  16     -14.937  42.945  25.609  1.00 25.71           C  
ATOM    130  CG  ASP A  16     -15.136  44.439  25.765  1.00 27.67           C  
ATOM    131  OD1 ASP A  16     -14.573  45.223  24.965  1.00 32.03           O  
ATOM    132  OD2 ASP A  16     -15.851  44.794  26.720  1.00 30.53           O  
ATOM    133  N   THR A  17     -13.378  40.438  24.338  1.00 23.10           N  
ATOM    134  CA  THR A  17     -13.237  38.994  24.364  1.00 23.15           C  
ATOM    135  C   THR A  17     -14.095  38.338  25.425  1.00 22.79           C  
ATOM    136  O   THR A  17     -14.530  37.185  25.261  1.00 22.63           O  
ATOM    137  CB  THR A  17     -11.790  38.578  24.557  1.00 24.32           C  
ATOM    138  OG1 THR A  17     -11.266  39.216  25.731  1.00 25.68           O  
ATOM    139  CG2 THR A  17     -10.988  38.955  23.334  1.00 25.67           C  
ATOM    140  N   SER A  18     -14.318  39.031  26.537  1.00 20.96           N  
ATOM    141  CA  SER A  18     -15.156  38.501  27.605  1.00 21.66           C  
ATOM    142  C   SER A  18     -16.644  38.360  27.201  1.00 21.12           C  
ATOM    143  O   SER A  18     -17.424  37.787  27.951  1.00 22.57           O  
ATOM    144  CB  SER A  18     -15.053  39.396  28.867  1.00 21.39           C  
ATOM    145  OG  SER A  18     -15.680  40.638  28.609  1.00 25.81           O  
ATOM    146  N   LYS A  19     -17.044  38.856  26.028  1.00 21.53           N  
ATOM    147  CA  LYS A  19     -18.449  38.732  25.589  1.00 20.96           C  
ATOM    148  C   LYS A  19     -18.563  37.543  24.627  1.00 19.25           C  
ATOM    149  O   LYS A  19     -19.655  37.186  24.231  1.00 18.17           O  
ATOM    150  CB  LYS A  19     -18.948  39.940  24.761  1.00 22.03           C  
ATOM    151  CG  LYS A  19     -18.622  41.360  25.242  1.00 25.69           C  
ATOM    152  CD  LYS A  19     -19.361  41.591  26.489  1.00 26.48           C  
ATOM    153  CE  LYS A  19     -19.212  43.045  26.946  1.00 26.75           C  
ATOM    154  NZ  LYS A  19     -20.105  43.243  28.138  1.00 29.02           N  
ATOM    155  N   ILE A  20     -17.429  36.946  24.260  1.00 19.05           N  
ATOM    156  CA  ILE A  20     -17.429  35.841  23.284  1.00 18.34           C  
ATOM    157  C   ILE A  20     -17.855  34.564  23.930  1.00 20.03           C  
ATOM    158  O   ILE A  20     -17.348  34.176  24.962  1.00 20.86           O  
ATOM    159  CB  ILE A  20     -16.075  35.712  22.644  1.00 17.75           C  
ATOM    160  CG1 ILE A  20     -15.873  36.893  21.697  1.00 18.29           C  
ATOM    161  CG2 ILE A  20     -15.960  34.383  21.930  1.00 17.44           C  
ATOM    162  CD1 ILE A  20     -14.474  37.031  21.091  1.00 19.15           C  
ATOM    163  N   LYS A  21     -18.825  33.932  23.270  1.00 20.72           N  
ATOM    164  CA  LYS A  21     -19.437  32.693  23.711  1.00 21.31           C  
ATOM    165  C   LYS A  21     -18.789  31.394  23.235  1.00 23.80           C  
ATOM    166  O   LYS A  21     -18.590  30.461  24.022  1.00 27.36           O  
ATOM    167  CB  LYS A  21     -20.896  32.676  23.242  1.00 21.48           C  
ATOM    168  CG  LYS A  21     -21.784  33.584  24.046  1.00 23.61           C  
ATOM    169  CD  LYS A  21     -23.094  33.894  23.419  1.00 26.26           C  
ATOM    170  CE  LYS A  21     -24.004  32.688  23.240  1.00 26.83           C  
ATOM    171  NZ  LYS A  21     -25.329  33.111  22.647  1.00 29.12           N  
ATOM    172  N   LYS A  22     -18.510  31.340  21.944  1.00 21.63           N  
ATOM    173  CA  LYS A  22     -17.990  30.194  21.236  1.00 22.50           C  
ATOM    174  C   LYS A  22     -17.039  30.679  20.162  1.00 20.42           C  
ATOM    175  O   LYS A  22     -17.311  31.667  19.533  1.00 19.08           O  
ATOM    176  CB  LYS A  22     -19.159  29.498  20.530  1.00 23.96           C  
ATOM    177  CG  LYS A  22     -18.780  28.431  19.633  1.00 28.87           C  
ATOM    178  CD  LYS A  22     -19.647  27.256  19.971  1.00 30.61           C  
ATOM    179  CE  LYS A  22     -19.138  26.018  19.361  1.00 32.27           C  
ATOM    180  NZ  LYS A  22     -20.069  24.932  19.766  1.00 33.54           N  
ATOM    181  N   VAL A  23     -15.924  30.002  19.972  1.00 18.70           N  
ATOM    182  CA  VAL A  23     -14.977  30.312  18.912  1.00 17.92           C  
ATOM    183  C   VAL A  23     -14.603  29.029  18.134  1.00 16.73           C  
ATOM    184  O   VAL A  23     -14.391  27.948  18.721  1.00 18.41           O  
ATOM    185  CB  VAL A  23     -13.651  30.898  19.465  1.00 19.68           C  
ATOM    186  CG1 VAL A  23     -12.697  31.274  18.345  1.00 21.19           C  
ATOM    187  CG2 VAL A  23     -13.918  32.089  20.290  1.00 21.50           C  
ATOM    188  N   TRP A  24     -14.516  29.137  16.819  1.00 14.89           N  
ATOM    189  CA  TRP A  24     -14.121  28.016  15.998  1.00 14.17           C  
ATOM    190  C   TRP A  24     -13.390  28.523  14.740  1.00 15.80           C  
ATOM    191  O   TRP A  24     -13.332  29.733  14.500  1.00 14.65           O  
ATOM    192  CB  TRP A  24     -15.379  27.205  15.591  1.00 14.51           C  
ATOM    193  CG  TRP A  24     -16.357  27.892  14.681  1.00 13.68           C  
ATOM    194  CD1 TRP A  24     -16.404  27.762  13.313  1.00 13.86           C  
ATOM    195  CD2 TRP A  24     -17.441  28.742  15.063  1.00 13.83           C  
ATOM    196  NE1 TRP A  24     -17.487  28.497  12.810  1.00 13.15           N  
ATOM    197  CE2 TRP A  24     -18.133  29.084  13.872  1.00 11.75           C  
ATOM    198  CE3 TRP A  24     -17.904  29.235  16.287  1.00 14.41           C  
ATOM    199  CZ2 TRP A  24     -19.272  29.906  13.874  1.00 13.94           C  
ATOM    200  CZ3 TRP A  24     -19.064  30.070  16.284  1.00 16.05           C  
ATOM    201  CH2 TRP A  24     -19.718  30.385  15.077  1.00 16.01           C  
ATOM    202  N   ARG A  25     -12.836  27.616  13.931  1.00 15.68           N  
ATOM    203  CA  ARG A  25     -12.164  27.975  12.704  1.00 17.78           C  
ATOM    204  C   ARG A  25     -12.931  27.381  11.526  1.00 16.84           C  
ATOM    205  O   ARG A  25     -13.086  26.164  11.402  1.00 17.82           O  
ATOM    206  CB  ARG A  25     -10.712  27.454  12.694  1.00 21.33           C  
ATOM    207  CG  ARG A  25      -9.843  28.139  11.659  1.00 24.59           C  
ATOM    208  CD  ARG A  25      -8.798  27.159  11.023  1.00 29.60           C  
ATOM    209  NE  ARG A  25      -7.759  26.685  11.926  1.00 34.76           N  
ATOM    210  CZ  ARG A  25      -6.927  25.669  11.668  1.00 37.55           C  
ATOM    211  NH1 ARG A  25      -6.999  24.991  10.524  1.00 39.78           N  
ATOM    212  NH2 ARG A  25      -5.996  25.331  12.551  1.00 39.84           N  
ATOM    213  N   ALA A  26     -13.426  28.247  10.656  1.00 15.42           N  
ATOM    214  CA  ALA A  26     -14.139  27.803   9.446  1.00 17.18           C  
ATOM    215  C   ALA A  26     -13.178  28.198   8.336  1.00 18.98           C  
ATOM    216  O   ALA A  26     -13.091  29.347   7.959  1.00 17.08           O  
ATOM    217  CB  ALA A  26     -15.462  28.555   9.308  1.00 17.42           C  
ATOM    218  N   GLY A  27     -12.389  27.246   7.836  1.00 21.02           N  
ATOM    219  CA  GLY A  27     -11.398  27.608   6.830  1.00 22.40           C  
ATOM    220  C   GLY A  27     -10.367  28.504   7.513  1.00 23.55           C  
ATOM    221  O   GLY A  27      -9.789  28.081   8.510  1.00 24.84           O  
ATOM    222  N   LYS A  28     -10.139  29.723   7.036  1.00 23.91           N  
ATOM    223  CA  LYS A  28      -9.194  30.611   7.685  1.00 24.71           C  
ATOM    224  C   LYS A  28      -9.920  31.727   8.448  1.00 22.97           C  
ATOM    225  O   LYS A  28      -9.320  32.713   8.955  1.00 24.29           O  
ATOM    226  CB  LYS A  28      -8.217  31.199   6.680  1.00 28.50           C  
ATOM    227  CG  LYS A  28      -7.684  30.160   5.720  1.00 31.12           C  
ATOM    228  CD  LYS A  28      -6.308  30.542   5.182  1.00 34.15           C  
ATOM    229  CE  LYS A  28      -5.883  29.589   4.079  1.00 36.08           C  
ATOM    230  NZ  LYS A  28      -4.459  29.880   3.756  1.00 36.63           N  
ATOM    231  N   ALA A  29     -11.233  31.579   8.531  1.00 19.24           N  
ATOM    232  CA  ALA A  29     -12.027  32.514   9.285  1.00 18.60           C  
ATOM    233  C   ALA A  29     -12.145  32.122  10.762  1.00 17.03           C  
ATOM    234  O   ALA A  29     -12.828  31.147  11.086  1.00 15.86           O  
ATOM    235  CB  ALA A  29     -13.418  32.619   8.650  1.00 17.58           C  
ATOM    236  N   VAL A  30     -11.458  32.827  11.648  1.00 14.70           N  
ATOM    237  CA  VAL A  30     -11.622  32.588  13.068  1.00 14.03           C  
ATOM    238  C   VAL A  30     -12.968  33.237  13.378  1.00 15.30           C  
ATOM    239  O   VAL A  30     -13.126  34.489  13.368  1.00 15.45           O  
ATOM    240  CB  VAL A  30     -10.497  33.252  13.875  1.00 15.29           C  
ATOM    241  CG1 VAL A  30     -10.749  33.051  15.360  1.00 16.95           C  
ATOM    242  CG2 VAL A  30      -9.110  32.694  13.400  1.00 16.76           C  
ATOM    243  N   SER A  31     -13.916  32.385  13.723  1.00 14.33           N  
ATOM    244  CA  SER A  31     -15.301  32.721  13.872  1.00 13.81           C  
ATOM    245  C   SER A  31     -15.755  32.646  15.303  1.00 14.31           C  
ATOM    246  O   SER A  31     -15.307  31.799  16.047  1.00 14.60           O  
ATOM    247  CB  SER A  31     -16.108  31.767  12.988  1.00 13.15           C  
ATOM    248  OG  SER A  31     -15.587  31.835  11.657  1.00 15.32           O  
ATOM    249  N   PHE A  32     -16.746  33.446  15.667  1.00 13.54           N  
ATOM    250  CA  PHE A  32     -17.201  33.459  17.045  1.00 12.30           C  
ATOM    251  C   PHE A  32     -18.580  34.052  17.221  1.00 14.13           C  
ATOM    252  O   PHE A  32     -19.046  34.915  16.415  1.00 15.79           O  
ATOM    253  CB  PHE A  32     -16.208  34.255  17.938  1.00 13.30           C  
ATOM    254  CG  PHE A  32     -15.923  35.659  17.432  1.00 13.61           C  
ATOM    255  CD1 PHE A  32     -14.876  35.840  16.556  1.00 13.03           C  
ATOM    256  CD2 PHE A  32     -16.716  36.765  17.759  1.00 14.99           C  
ATOM    257  CE1 PHE A  32     -14.583  37.084  15.967  1.00 13.04           C  
ATOM    258  CE2 PHE A  32     -16.427  38.056  17.187  1.00 15.55           C  
ATOM    259  CZ  PHE A  32     -15.372  38.206  16.297  1.00 15.49           C  
ATOM    260  N   THR A  33     -19.265  33.578  18.249  1.00 12.99           N  
ATOM    261  CA  THR A  33     -20.560  34.149  18.605  1.00 14.65           C  
ATOM    262  C   THR A  33     -20.307  34.942  19.882  1.00 14.57           C  
ATOM    263  O   THR A  33     -19.306  34.737  20.577  1.00 15.59           O  
ATOM    264  CB  THR A  33     -21.613  33.079  18.835  1.00 14.84           C  
ATOM    265  OG1 THR A  33     -21.121  32.187  19.829  1.00 15.05           O  
ATOM    266  CG2 THR A  33     -21.883  32.303  17.539  1.00 13.79           C  
ATOM    267  N   TYR A  34     -21.192  35.877  20.172  1.00 15.43           N  
ATOM    268  CA  TYR A  34     -21.019  36.718  21.354  1.00 15.61           C  
ATOM    269  C   TYR A  34     -22.357  37.270  21.811  1.00 17.07           C  
ATOM    270  O   TYR A  34     -23.366  37.179  21.103  1.00 16.10           O  
ATOM    271  CB  TYR A  34     -20.043  37.874  21.001  1.00 16.10           C  
ATOM    272  CG  TYR A  34     -20.574  38.806  19.958  1.00 15.68           C  
ATOM    273  CD1 TYR A  34     -20.267  38.626  18.609  1.00 14.93           C  
ATOM    274  CD2 TYR A  34     -21.431  39.859  20.294  1.00 18.44           C  
ATOM    275  CE1 TYR A  34     -20.789  39.451  17.629  1.00 16.65           C  
ATOM    276  CE2 TYR A  34     -21.970  40.699  19.287  1.00 19.63           C  
ATOM    277  CZ  TYR A  34     -21.632  40.469  17.943  1.00 18.27           C  
ATOM    278  OH  TYR A  34     -22.155  41.179  16.871  1.00 20.67           O  
ATOM    279  N   ASP A  35     -22.358  37.803  23.040  1.00 18.66           N  
ATOM    280  CA  ASP A  35     -23.549  38.453  23.564  1.00 19.90           C  
ATOM    281  C   ASP A  35     -22.982  39.741  24.147  1.00 20.20           C  
ATOM    282  O   ASP A  35     -22.263  39.727  25.137  1.00 20.40           O  
ATOM    283  CB  ASP A  35     -24.272  37.639  24.649  1.00 23.28           C  
ATOM    284  CG  ASP A  35     -25.530  38.339  25.153  1.00 26.16           C  
ATOM    285  OD1 ASP A  35     -26.465  37.641  25.601  1.00 26.97           O  
ATOM    286  OD2 ASP A  35     -25.593  39.591  25.083  1.00 26.92           O  
ATOM    287  N   ASP A  36     -23.279  40.841  23.480  1.00 19.28           N  
ATOM    288  CA  ASP A  36     -22.799  42.171  23.920  1.00 20.85           C  
ATOM    289  C   ASP A  36     -23.969  42.990  24.432  1.00 19.91           C  
ATOM    290  O   ASP A  36     -24.746  43.559  23.652  1.00 21.39           O  
ATOM    291  CB  ASP A  36     -22.089  42.886  22.762  1.00 21.88           C  
ATOM    292  CG  ASP A  36     -21.344  44.128  23.196  1.00 23.68           C  
ATOM    293  OD1 ASP A  36     -21.589  44.610  24.302  1.00 26.08           O  
ATOM    294  OD2 ASP A  36     -20.513  44.625  22.416  1.00 26.98           O  
ATOM    295  N   ASN A  37     -24.101  43.023  25.746  1.00 20.51           N  
ATOM    296  CA  ASN A  37     -25.166  43.791  26.437  1.00 23.25           C  
ATOM    297  C   ASN A  37     -26.534  43.482  25.847  1.00 24.28           C  
ATOM    298  O   ASN A  37     -27.306  44.390  25.522  1.00 24.25           O  
ATOM    299  CB  ASN A  37     -24.853  45.303  26.333  1.00 21.21           C  
ATOM    300  CG  ASN A  37     -25.771  46.170  27.209  1.00 22.27           C  
ATOM    301  OD1 ASN A  37     -26.148  45.769  28.304  1.00 23.49           O  
ATOM    302  ND2 ASN A  37     -26.125  47.350  26.718  1.00 20.99           N  
ATOM    303  N   GLY A  38     -26.834  42.193  25.684  1.00 25.74           N  
ATOM    304  CA  GLY A  38     -28.130  41.810  25.116  1.00 27.30           C  
ATOM    305  C   GLY A  38     -28.140  41.598  23.603  1.00 27.55           C  
ATOM    306  O   GLY A  38     -29.088  41.025  23.053  1.00 30.09           O  
ATOM    307  N   LYS A  39     -27.108  42.081  22.919  1.00 27.70           N  
ATOM    308  CA  LYS A  39     -27.027  41.931  21.465  1.00 28.39           C  
ATOM    309  C   LYS A  39     -26.245  40.666  21.130  1.00 26.84           C  
ATOM    310  O   LYS A  39     -25.023  40.648  21.251  1.00 26.93           O  
ATOM    311  CB  LYS A  39     -26.346  43.153  20.852  1.00 27.77           C  
ATOM    312  N   THR A  40     -26.962  39.620  20.712  1.00 25.63           N  
ATOM    313  CA  THR A  40     -26.335  38.332  20.378  1.00 24.08           C  
ATOM    314  C   THR A  40     -26.000  38.365  18.934  1.00 21.70           C  
ATOM    315  O   THR A  40     -26.806  38.783  18.129  1.00 22.31           O  
ATOM    316  CB  THR A  40     -27.283  37.231  20.696  1.00 24.46           C  
ATOM    317  OG1 THR A  40     -27.476  37.225  22.127  1.00 27.65           O  
ATOM    318  CG2 THR A  40     -26.682  35.874  20.290  1.00 25.86           C  
ATOM    319  N   GLY A  41     -24.786  37.925  18.600  1.00 17.10           N  
ATOM    320  CA  GLY A  41     -24.342  38.042  17.236  1.00 17.01           C  
ATOM    321  C   GLY A  41     -23.160  37.132  16.913  1.00 16.16           C  
ATOM    322  O   GLY A  41     -22.750  36.301  17.727  1.00 15.88           O  
ATOM    323  N   ARG A  42     -22.638  37.317  15.713  1.00 15.72           N  
ATOM    324  CA  ARG A  42     -21.525  36.531  15.203  1.00 15.66           C  
ATOM    325  C   ARG A  42     -20.551  37.413  14.483  1.00 17.05           C  
ATOM    326  O   ARG A  42     -20.928  38.411  13.840  1.00 18.77           O  
ATOM    327  CB  ARG A  42     -22.009  35.444  14.232  1.00 15.88           C  
ATOM    328  CG  ARG A  42     -20.899  34.495  13.727  1.00 18.48           C  
ATOM    329  CD  ARG A  42     -21.444  33.594  12.597  1.00 21.12           C  
ATOM    330  NE  ARG A  42     -22.363  32.610  13.172  1.00 19.89           N  
ATOM    331  CZ  ARG A  42     -22.534  31.393  12.683  1.00 16.46           C  
ATOM    332  NH1 ARG A  42     -23.370  30.521  13.281  1.00 17.45           N  
ATOM    333  NH2 ARG A  42     -21.856  31.081  11.574  1.00 17.08           N  
ATOM    334  N   GLY A  43     -19.279  37.087  14.639  1.00 14.68           N  
ATOM    335  CA  GLY A  43     -18.226  37.834  13.962  1.00 16.67           C  
ATOM    336  C   GLY A  43     -17.165  36.879  13.476  1.00 16.11           C  
ATOM    337  O   GLY A  43     -17.191  35.714  13.846  1.00 15.70           O  
ATOM    338  N   ALA A  44     -16.261  37.345  12.626  1.00 15.61           N  
ATOM    339  CA  ALA A  44     -15.173  36.512  12.128  1.00 16.67           C  
ATOM    340  C   ALA A  44     -14.073  37.429  11.695  1.00 19.01           C  
ATOM    341  O   ALA A  44     -14.339  38.525  11.240  1.00 19.33           O  
ATOM    342  CB  ALA A  44     -15.607  35.698  10.931  1.00 16.09           C  
ATOM    343  N   VAL A  45     -12.828  36.978  11.822  1.00 18.64           N  
ATOM    344  CA  VAL A  45     -11.665  37.749  11.353  1.00 18.29           C  
ATOM    345  C   VAL A  45     -10.706  36.716  10.775  1.00 19.25           C  
ATOM    346  O   VAL A  45     -10.799  35.509  11.081  1.00 20.83           O  
ATOM    347  CB  VAL A  45     -10.904  38.449  12.486  1.00 19.27           C  
ATOM    348  CG1 VAL A  45     -11.774  39.497  13.206  1.00 18.86           C  
ATOM    349  CG2 VAL A  45     -10.395  37.406  13.468  1.00 21.14           C  
ATOM    350  N   SER A  46      -9.755  37.158   9.961  1.00 18.15           N  
ATOM    351  CA  SER A  46      -8.776  36.222   9.433  1.00 20.04           C  
ATOM    352  C   SER A  46      -7.829  35.838  10.562  1.00 20.48           C  
ATOM    353  O   SER A  46      -7.639  36.595  11.541  1.00 19.63           O  
ATOM    354  CB  SER A  46      -8.019  36.839   8.287  1.00 20.66           C  
ATOM    355  OG  SER A  46      -7.281  37.927   8.783  1.00 23.96           O  
ATOM    356  N   GLU A  47      -7.255  34.643  10.438  1.00 22.60           N  
ATOM    357  CA  GLU A  47      -6.348  34.151  11.459  1.00 25.81           C  
ATOM    358  C   GLU A  47      -5.178  35.121  11.583  1.00 26.24           C  
ATOM    359  O   GLU A  47      -4.712  35.465  12.688  1.00 26.46           O  
ATOM    360  CB  GLU A  47      -5.857  32.751  11.089  1.00 28.83           C  
ATOM    361  CG  GLU A  47      -4.913  32.161  12.134  1.00 31.55           C  
ATOM    362  CD  GLU A  47      -4.414  30.787  11.732  1.00 34.73           C  
ATOM    363  OE1 GLU A  47      -4.842  29.788  12.346  1.00 35.94           O  
ATOM    364  OE2 GLU A  47      -3.599  30.689  10.789  1.00 35.57           O  
ATOM    365  N   LYS A  48      -4.745  35.616  10.442  1.00 27.16           N  
ATOM    366  CA  LYS A  48      -3.627  36.534  10.413  1.00 28.24           C  
ATOM    367  C   LYS A  48      -3.920  37.911  11.062  1.00 27.80           C  
ATOM    368  O   LYS A  48      -2.990  38.639  11.455  1.00 30.41           O  
ATOM    369  CB  LYS A  48      -3.127  36.599   8.966  1.00 27.25           C  
ATOM    370  CG  LYS A  48      -3.133  37.927   8.329  1.00 28.00           C  
ATOM    371  CD  LYS A  48      -2.447  37.825   6.970  1.00 28.17           C  
ATOM    372  CE  LYS A  48      -3.366  37.268   5.928  1.00 28.21           C  
ATOM    373  NZ  LYS A  48      -2.687  37.469   4.611  1.00 30.98           N  
ATOM    374  N   ASP A  49      -5.193  38.257  11.260  1.00 26.52           N  
ATOM    375  CA  ASP A  49      -5.557  39.541  11.904  1.00 25.18           C  
ATOM    376  C   ASP A  49      -6.133  39.373  13.324  1.00 23.52           C  
ATOM    377  O   ASP A  49      -6.473  40.334  13.981  1.00 26.94           O  
ATOM    378  CB  ASP A  49      -6.591  40.319  11.080  1.00 28.79           C  
ATOM    379  CG  ASP A  49      -6.112  40.660   9.674  1.00 30.17           C  
ATOM    380  OD1 ASP A  49      -6.974  41.038   8.858  1.00 31.89           O  
ATOM    381  OD2 ASP A  49      -4.902  40.558   9.370  1.00 33.78           O  
ATOM    382  N   ALA A  50      -6.268  38.143  13.797  1.00 22.18           N  
ATOM    383  CA  ALA A  50      -6.816  37.875  15.125  1.00 18.28           C  
ATOM    384  C   ALA A  50      -5.830  38.217  16.237  1.00 18.42           C  
ATOM    385  O   ALA A  50      -4.640  37.914  16.110  1.00 20.66           O  
ATOM    386  CB  ALA A  50      -7.183  36.364  15.251  1.00 18.97           C  
ATOM    387  N   PRO A  51      -6.318  38.828  17.338  1.00 17.67           N  
ATOM    388  CA  PRO A  51      -5.402  39.161  18.444  1.00 18.93           C  
ATOM    389  C   PRO A  51      -5.045  37.879  19.146  1.00 18.55           C  
ATOM    390  O   PRO A  51      -5.826  36.910  19.096  1.00 17.93           O  
ATOM    391  CB  PRO A  51      -6.216  40.107  19.332  1.00 18.67           C  
ATOM    392  CG  PRO A  51      -7.662  39.709  19.104  1.00 19.11           C  
ATOM    393  CD  PRO A  51      -7.699  39.303  17.609  1.00 18.31           C  
ATOM    394  N   LYS A  52      -3.914  37.855  19.858  1.00 18.71           N  
ATOM    395  CA  LYS A  52      -3.490  36.641  20.533  1.00 17.76           C  
ATOM    396  C   LYS A  52      -4.532  36.075  21.512  1.00 17.53           C  
ATOM    397  O   LYS A  52      -4.692  34.882  21.610  1.00 18.57           O  
ATOM    398  CB  LYS A  52      -2.133  36.843  21.239  1.00 20.87           C  
ATOM    399  CG  LYS A  52      -1.548  35.499  21.722  1.00 22.07           C  
ATOM    400  CD  LYS A  52      -0.107  35.616  22.180  1.00 25.26           C  
ATOM    401  CE  LYS A  52       0.413  34.264  22.667  1.00 23.54           C  
ATOM    402  NZ  LYS A  52      -0.272  33.797  23.873  1.00 23.72           N  
ATOM    403  N   GLU A  53      -5.223  36.916  22.234  1.00 18.41           N  
ATOM    404  CA  GLU A  53      -6.221  36.429  23.144  1.00 18.81           C  
ATOM    405  C   GLU A  53      -7.279  35.645  22.404  1.00 19.03           C  
ATOM    406  O   GLU A  53      -7.727  34.628  22.913  1.00 19.06           O  
ATOM    407  CB  GLU A  53      -6.851  37.587  23.907  1.00 21.54           C  
ATOM    408  CG  GLU A  53      -5.867  38.288  24.862  1.00 23.63           C  
ATOM    409  CD  GLU A  53      -4.972  39.364  24.203  1.00 24.07           C  
ATOM    410  OE1 GLU A  53      -4.861  39.482  22.957  1.00 23.05           O  
ATOM    411  OE2 GLU A  53      -4.352  40.118  24.985  1.00 25.33           O  
ATOM    412  N   LEU A  54      -7.649  36.074  21.206  1.00 17.75           N  
ATOM    413  CA  LEU A  54      -8.687  35.298  20.456  1.00 18.21           C  
ATOM    414  C   LEU A  54      -8.099  33.976  19.984  1.00 17.16           C  
ATOM    415  O   LEU A  54      -8.766  32.945  20.079  1.00 17.66           O  
ATOM    416  CB  LEU A  54      -9.264  36.106  19.287  1.00 17.45           C  
ATOM    417  CG  LEU A  54     -10.430  35.434  18.473  1.00 17.09           C  
ATOM    418  CD1 LEU A  54     -11.654  35.228  19.338  1.00 18.76           C  
ATOM    419  CD2 LEU A  54     -10.749  36.302  17.251  1.00 17.40           C  
ATOM    420  N   LEU A  55      -6.864  33.981  19.473  1.00 17.41           N  
ATOM    421  CA  LEU A  55      -6.249  32.717  19.075  1.00 17.77           C  
ATOM    422  C   LEU A  55      -6.090  31.771  20.254  1.00 17.32           C  
ATOM    423  O   LEU A  55      -6.213  30.556  20.108  1.00 16.73           O  
ATOM    424  CB  LEU A  55      -4.885  32.954  18.397  1.00 18.92           C  
ATOM    425  CG  LEU A  55      -5.095  33.813  17.146  1.00 16.32           C  
ATOM    426  CD1 LEU A  55      -3.722  34.269  16.545  1.00 21.23           C  
ATOM    427  CD2 LEU A  55      -5.897  32.965  16.145  1.00 20.56           C  
ATOM    428  N   ASP A  56      -5.803  32.313  21.435  1.00 17.37           N  
ATOM    429  CA  ASP A  56      -5.648  31.417  22.575  1.00 19.15           C  
ATOM    430  C   ASP A  56      -7.016  30.813  22.921  1.00 19.03           C  
ATOM    431  O   ASP A  56      -7.118  29.657  23.297  1.00 19.58           O  
ATOM    432  CB  ASP A  56      -5.054  32.163  23.764  1.00 20.92           C  
ATOM    433  CG  ASP A  56      -3.572  32.437  23.599  1.00 21.66           C  
ATOM    434  OD1 ASP A  56      -2.893  31.760  22.773  1.00 23.09           O  
ATOM    435  OD2 ASP A  56      -3.077  33.335  24.333  1.00 26.10           O  
ATOM    436  N   MET A  57      -8.075  31.582  22.776  1.00 18.98           N  
ATOM    437  CA  MET A  57      -9.399  31.056  23.050  1.00 19.78           C  
ATOM    438  C   MET A  57      -9.695  29.956  22.050  1.00 19.03           C  
ATOM    439  O   MET A  57     -10.312  28.919  22.378  1.00 19.48           O  
ATOM    440  CB  MET A  57     -10.430  32.177  22.872  1.00 20.89           C  
ATOM    441  CG  MET A  57     -10.446  33.115  24.027  1.00 22.90           C  
ATOM    442  SD  MET A  57     -11.719  34.408  23.842  1.00 28.98           S  
ATOM    443  CE  MET A  57     -13.020  33.418  23.824  1.00 22.52           C  
ATOM    444  N   LEU A  58      -9.303  30.182  20.821  1.00 17.93           N  
ATOM    445  CA  LEU A  58      -9.550  29.202  19.766  1.00 18.40           C  
ATOM    446  C   LEU A  58      -8.813  27.876  20.090  1.00 19.27           C  
ATOM    447  O   LEU A  58      -9.402  26.808  19.943  1.00 18.11           O  
ATOM    448  CB  LEU A  58      -9.115  29.707  18.401  1.00 18.90           C  
ATOM    449  CG  LEU A  58      -9.157  28.667  17.266  1.00 18.77           C  
ATOM    450  CD1 LEU A  58     -10.622  28.191  16.976  1.00 17.62           C  
ATOM    451  CD2 LEU A  58      -8.579  29.287  16.037  1.00 20.91           C  
ATOM    452  N   ALA A  59      -7.538  27.976  20.483  1.00 18.16           N  
ATOM    453  CA  ALA A  59      -6.794  26.765  20.815  1.00 20.64           C  
ATOM    454  C   ALA A  59      -7.462  26.018  21.952  1.00 19.28           C  
ATOM    455  O   ALA A  59      -7.517  24.777  21.938  1.00 20.24           O  
ATOM    456  CB  ALA A  59      -5.360  27.113  21.178  1.00 18.18           C  
ATOM    457  N   ARG A  60      -7.980  26.724  22.945  1.00 19.78           N  
ATOM    458  CA  ARG A  60      -8.648  26.032  24.055  1.00 20.90           C  
ATOM    459  C   ARG A  60      -9.867  25.292  23.581  1.00 21.48           C  
ATOM    460  O   ARG A  60     -10.175  24.169  24.037  1.00 21.40           O  
ATOM    461  CB  ARG A  60      -9.050  26.993  25.164  1.00 24.04           C  
ATOM    462  CG  ARG A  60      -7.876  27.485  26.003  1.00 26.94           C  
ATOM    463  CD  ARG A  60      -8.323  28.036  27.341  1.00 30.25           C  
ATOM    464  NE  ARG A  60      -8.956  29.341  27.188  1.00 31.26           N  
ATOM    465  CZ  ARG A  60      -8.305  30.480  26.964  1.00 33.75           C  
ATOM    466  NH1 ARG A  60      -6.977  30.493  26.873  1.00 33.21           N  
ATOM    467  NH2 ARG A  60      -8.993  31.613  26.808  1.00 33.11           N  
ATOM    468  N   ALA A  61     -10.585  25.899  22.646  1.00 20.70           N  
ATOM    469  CA  ALA A  61     -11.764  25.243  22.118  1.00 20.71           C  
ATOM    470  C   ALA A  61     -11.401  24.039  21.230  1.00 19.50           C  
ATOM    471  O   ALA A  61     -12.109  23.026  21.245  1.00 21.26           O  
ATOM    472  CB  ALA A  61     -12.587  26.247  21.341  1.00 19.38           C  
ATOM    473  N   GLU A  62     -10.310  24.121  20.486  1.00 20.01           N  
ATOM    474  CA  GLU A  62      -9.906  23.009  19.633  1.00 19.28           C  
ATOM    475  C   GLU A  62      -9.422  21.818  20.450  1.00 20.17           C  
ATOM    476  O   GLU A  62      -9.419  20.702  19.954  1.00 21.28           O  
ATOM    477  CB  GLU A  62      -8.858  23.498  18.644  1.00 21.56           C  
ATOM    478  CG  GLU A  62      -9.624  24.399  17.656  1.00 22.86           C  
ATOM    479  CD  GLU A  62      -8.860  24.862  16.475  1.00 28.28           C  
ATOM    480  OE1 GLU A  62      -9.538  25.166  15.447  1.00 29.54           O  
ATOM    481  OE2 GLU A  62      -7.632  24.961  16.571  1.00 30.62           O  
ATOM    482  N   ARG A  63      -9.045  22.065  21.703  1.00 19.60           N  
ATOM    483  CA  ARG A  63      -8.577  20.984  22.567  1.00 20.19           C  
ATOM    484  C   ARG A  63      -9.738  20.140  23.079  1.00 22.92           C  
ATOM    485  O   ARG A  63      -9.531  19.000  23.506  1.00 24.25           O  
ATOM    486  CB  ARG A  63      -7.782  21.590  23.741  1.00 18.29           C  
ATOM    487  CG  ARG A  63      -7.066  20.538  24.670  1.00 19.59           C  
ATOM    488  CD  ARG A  63      -5.848  19.821  23.978  1.00 17.22           C  
ATOM    489  NE  ARG A  63      -4.996  19.199  25.008  1.00 18.58           N  
ATOM    490  CZ  ARG A  63      -4.102  19.894  25.698  1.00 20.78           C  
ATOM    491  NH1 ARG A  63      -3.383  19.319  26.644  1.00 22.24           N  
ATOM    492  NH2 ARG A  63      -3.869  21.169  25.408  1.00 21.12           N  
ATOM    493  N   GLU A  64     -10.953  20.651  23.032  1.00 24.64           N  
ATOM    494  CA  GLU A  64     -12.057  19.836  23.556  1.00 25.53           C  
ATOM    495  C   GLU A  64     -12.855  19.047  22.528  1.00 25.86           C  
ATOM    496  O   GLU A  64     -12.769  19.250  21.306  1.00 26.56           O  
ATOM    497  CB  GLU A  64     -13.024  20.629  24.452  1.00 28.74           C  
ATOM    498  CG  GLU A  64     -12.803  22.125  24.633  1.00 32.65           C  
ATOM    499  CD  GLU A  64     -13.373  22.667  25.959  1.00 36.17           C  
ATOM    500  OE1 GLU A  64     -14.591  22.536  26.236  1.00 37.99           O  
ATOM    501  OE2 GLU A  64     -12.594  23.233  26.745  1.00 38.80           O  
ATOM    502  N   LYS A  65     -13.592  18.089  23.044  1.00 25.76           N  
ATOM    503  CA  LYS A  65     -14.413  17.213  22.221  1.00 28.87           C  
ATOM    504  C   LYS A  65     -15.480  17.939  21.455  1.00 32.29           C  
ATOM    505  O   LYS A  65     -15.847  19.050  21.783  1.00 30.65           O  
ATOM    506  CB  LYS A  65     -15.100  16.153  23.065  1.00 28.71           C  
ATOM    507  CG  LYS A  65     -16.012  16.729  24.082  1.00 30.51           C  
ATOM    508  CD  LYS A  65     -16.657  15.628  24.893  1.00 31.86           C  
ATOM    509  CE  LYS A  65     -17.232  16.210  26.148  1.00 31.76           C  
ATOM    510  NZ  LYS A  65     -18.060  15.222  26.868  1.00 33.49           N  
ATOM    511  N   LYS A  66     -15.955  17.288  20.405  1.00 36.18           N  
ATOM    512  CA  LYS A  66     -16.993  17.859  19.572  1.00 39.37           C  
ATOM    513  C   LYS A  66     -18.256  17.069  19.836  1.00 40.65           C  
ATOM    514  O   LYS A  66     -18.561  16.878  21.037  1.00 40.92           O  
ATOM    515  CB  LYS A  66     -16.585  17.787  18.098  1.00 41.16           C  
ATOM    516  CG  LYS A  66     -15.324  18.590  17.798  1.00 43.06           C  
ATOM    517  CD  LYS A  66     -15.168  18.886  16.319  1.00 43.96           C  
ATOM    518  CE  LYS A  66     -16.255  19.840  15.833  1.00 43.33           C  
ATOM    519  NZ  LYS A  66     -16.039  20.152  14.398  1.00 43.68           N  
ATOM    520  OXT LYS A  66     -18.912  16.649  18.852  1.00 42.54           O  
TER     521      LYS A  66                                                      
END
MOLECULE T0415.pdb
ATOM      1  N   GLY     1      -3.414  46.102  27.734  1.00 47.41           N  
ATOM      2  CA  GLY     1      -3.122  45.539  26.359  1.00 47.11           C  
ATOM      3  C   GLY     1      -4.177  45.907  25.333  1.00 47.07           C  
ATOM      4  O   GLY     1      -4.078  46.946  24.671  1.00 46.94           O  
ATOM      5  N   LYS     2      -5.171  45.030  25.198  1.00 46.92           N  
ATOM      6  CA  LYS     2      -6.274  45.185  24.253  1.00 46.81           C  
ATOM      7  C   LYS     2      -7.559  44.609  24.888  1.00 46.36           C  
ATOM      8  O   LYS     2      -7.467  43.735  25.759  1.00 45.55           O  
ATOM      9  CB  LYS     2      -5.938  44.505  22.904  1.00 47.31           C  
ATOM     10  CG  LYS     2      -5.486  45.508  21.817  1.00 47.91           C  
ATOM     11  CD  LYS     2      -4.343  45.056  20.919  1.00 47.60           C  
ATOM     12  CE  LYS     2      -4.032  46.152  19.891  1.00 47.58           C  
ATOM     13  NZ  LYS     2      -2.842  45.845  19.044  1.00 48.43           N  
ATOM     14  N   SER     3      -8.737  45.114  24.499  1.00 45.40           N  
ATOM     15  CA  SER     3      -9.967  44.730  25.214  1.00 45.73           C  
ATOM     16  C   SER     3     -11.200  44.568  24.362  1.00 44.97           C  
ATOM     17  O   SER     3     -12.250  44.270  24.886  1.00 43.15           O  
ATOM     18  CB  SER     3     -10.264  45.688  26.408  1.00 45.39           C  
ATOM     19  OG  SER     3     -10.858  46.926  26.031  1.00 44.69           O  
ATOM     20  N   VAL     4     -11.058  44.781  23.063  1.00 46.52           N  
ATOM     21  CA  VAL     4     -12.119  44.569  22.084  1.00 47.84           C  
ATOM     22  C   VAL     4     -11.586  43.824  20.877  1.00 49.90           C  
ATOM     23  O   VAL     4     -10.415  43.942  20.536  1.00 49.02           O  
ATOM     24  CB  VAL     4     -12.814  45.903  21.614  1.00 48.00           C  
ATOM     25  CG1 VAL     4     -13.403  46.612  22.796  1.00 48.15           C  
ATOM     26  CG2 VAL     4     -11.862  46.801  20.873  1.00 46.59           C  
ATOM     27  N   VAL     5     -12.464  43.017  20.284  1.00 52.98           N  
ATOM     28  CA  VAL     5     -12.249  42.400  18.975  1.00 55.45           C  
ATOM     29  C   VAL     5     -13.255  43.030  17.995  1.00 56.86           C  
ATOM     30  O   VAL     5     -14.440  43.149  18.318  1.00 57.09           O  
ATOM     31  CB  VAL     5     -12.496  40.880  18.971  1.00 54.97           C  
ATOM     32  CG1 VAL     5     -11.696  40.218  17.810  1.00 54.63           C  
ATOM     33  CG2 VAL     5     -12.138  40.263  20.301  1.00 54.64           C  
ATOM     34  N   THR     6     -12.765  43.452  16.823  1.00 58.87           N  
ATOM     35  CA  THR     6     -13.605  44.066  15.788  1.00 59.55           C  
ATOM     36  C   THR     6     -14.006  42.974  14.818  1.00 61.76           C  
ATOM     37  O   THR     6     -13.162  42.393  14.144  1.00 61.58           O  
ATOM     38  CB  THR     6     -12.932  45.268  15.121  1.00 59.79           C  
ATOM     39  OG1 THR     6     -12.480  46.179  16.145  1.00 59.48           O  
ATOM     40  CG2 THR     6     -13.915  46.013  14.231  1.00 58.55           C  
ATOM     41  N   LEU     7     -15.294  42.628  14.861  1.00 63.99           N  
ATOM     42  CA  LEU     7     -15.895  41.687  13.919  1.00 65.67           C  
ATOM     43  C   LEU     7     -16.368  42.441  12.667  1.00 66.61           C  
ATOM     44  O   LEU     7     -16.939  43.524  12.751  1.00 67.07           O  
ATOM     45  CB  LEU     7     -17.108  40.974  14.523  1.00 64.90           C  
ATOM     46  CG  LEU     7     -17.177  40.443  15.946  1.00 64.47           C  
ATOM     47  CD1 LEU     7     -18.054  39.221  16.010  1.00 62.44           C  
ATOM     48  CD2 LEU     7     -15.819  40.134  16.496  1.00 65.25           C  
ATOM     49  N   LYS     8     -16.166  41.836  11.506  1.00 68.76           N  
ATOM     50  CA  LYS     8     -16.680  42.380  10.243  1.00 69.47           C  
ATOM     51  C   LYS     8     -18.103  41.907  10.060  1.00 70.09           C  
ATOM     52  O   LYS     8     -18.347  40.694  10.082  1.00 69.59           O  
ATOM     53  CB  LYS     8     -15.813  41.896   9.086  1.00 69.96           C  
ATOM     54  CG  LYS     8     -16.349  42.153   7.703  1.00 70.04           C  
ATOM     55  CD  LYS     8     -15.243  42.025   6.686  1.00 70.59           C  
ATOM     56  CE  LYS     8     -15.612  42.751   5.399  1.00 72.06           C  
ATOM     57  NZ  LYS     8     -14.397  42.961   4.582  1.00 72.38           N  
ATOM     58  N   THR     9     -19.034  42.866   9.948  1.00 71.30           N  
ATOM     59  CA  THR     9     -20.416  42.587   9.508  1.00 72.31           C  
ATOM     60  C   THR     9     -20.616  42.985   8.048  1.00 72.69           C  
ATOM     61  O   THR     9     -19.697  43.484   7.396  1.00 72.53           O  
ATOM     62  CB  THR     9     -21.478  43.286  10.354  1.00 72.49           C  
ATOM     63  OG1 THR     9     -20.896  44.420  10.993  1.00 74.69           O  
ATOM     64  CG2 THR     9     -22.039  42.319  11.430  1.00 74.62           C  
ATOM     65  N   THR    10     -21.825  42.727   7.546  1.00 73.43           N  
ATOM     66  CA  THR    10     -22.161  42.914   6.126  1.00 73.47           C  
ATOM     67  C   THR    10     -21.839  44.354   5.638  1.00 73.38           C  
ATOM     68  O   THR    10     -21.174  44.550   4.599  1.00 72.70           O  
ATOM     69  CB  THR    10     -23.656  42.495   5.849  1.00 73.49           C  
ATOM     70  OG1 THR    10     -24.506  43.007   6.881  1.00 74.37           O  
ATOM     71  CG2 THR    10     -23.794  40.981   5.833  1.00 73.19           C  
ATOM     72  N   ASP    11     -22.248  45.341   6.434  1.00 73.21           N  
ATOM     73  CA  ASP    11     -22.094  46.754   6.059  1.00 73.27           C  
ATOM     74  C   ASP    11     -20.968  47.486   6.829  1.00 73.41           C  
ATOM     75  O   ASP    11     -20.279  48.348   6.242  1.00 73.86           O  
ATOM     76  CB  ASP    11     -23.437  47.492   6.208  1.00 73.82           C  
ATOM     77  CG  ASP    11     -24.153  47.149   7.512  1.00 74.89           C  
ATOM     78  OD1 ASP    11     -23.756  46.136   8.160  1.00 74.50           O  
ATOM     79  OD2 ASP    11     -25.105  47.888   7.872  1.00 74.98           O  
ATOM     80  N   GLY    12     -20.777  47.148   8.118  1.00 72.48           N  
ATOM     81  CA  GLY    12     -19.792  47.843   8.984  1.00 71.07           C  
ATOM     82  C   GLY    12     -19.007  46.880   9.851  1.00 70.00           C  
ATOM     83  O   GLY    12     -19.016  45.682   9.595  1.00 71.63           O  
ATOM     84  N   TRP    13     -18.304  47.400  10.853  1.00 68.05           N  
ATOM     85  CA  TRP    13     -17.557  46.562  11.841  1.00 66.68           C  
ATOM     86  C   TRP    13     -18.007  46.884  13.261  1.00 65.08           C  
ATOM     87  O   TRP    13     -18.280  48.050  13.606  1.00 64.47           O  
ATOM     88  CB  TRP    13     -16.060  46.842  11.792  1.00 64.59           C  
ATOM     89  CG  TRP    13     -15.332  46.422  10.588  1.00 62.93           C  
ATOM     90  CD1 TRP    13     -14.752  45.202  10.360  1.00 61.34           C  
ATOM     91  CD2 TRP    13     -15.018  47.240   9.461  1.00 61.52           C  
ATOM     92  NE1 TRP    13     -14.121  45.208   9.157  1.00 61.73           N  
ATOM     93  CE2 TRP    13     -14.268  46.448   8.578  1.00 62.18           C  
ATOM     94  CE3 TRP    13     -15.303  48.566   9.113  1.00 61.31           C  
ATOM     95  CZ2 TRP    13     -13.808  46.933   7.358  1.00 62.15           C  
ATOM     96  CZ3 TRP    13     -14.863  49.041   7.917  1.00 61.84           C  
ATOM     97  CH2 TRP    13     -14.116  48.232   7.046  1.00 62.33           C  
ATOM     98  N   ILE    14     -18.024  45.862  14.098  1.00 63.48           N  
ATOM     99  CA  ILE    14     -18.594  45.986  15.416  1.00 62.69           C  
ATOM    100  C   ILE    14     -17.526  45.612  16.442  1.00 62.71           C  
ATOM    101  O   ILE    14     -17.085  44.463  16.481  1.00 62.94           O  
ATOM    102  CB  ILE    14     -19.900  45.154  15.502  1.00 63.10           C  
ATOM    103  CG1 ILE    14     -20.867  45.664  14.398  1.00 62.59           C  
ATOM    104  CG2 ILE    14     -20.506  45.213  16.915  1.00 62.39           C  
ATOM    105  CD1 ILE    14     -22.294  45.381  14.613  1.00 62.33           C  
ATOM    106  N   PRO    15     -17.055  46.604  17.238  1.00 62.46           N  
ATOM    107  CA  PRO    15     -16.190  46.303  18.381  1.00 62.34           C  
ATOM    108  C   PRO    15     -16.956  45.561  19.472  1.00 62.33           C  
ATOM    109  O   PRO    15     -18.029  45.984  19.877  1.00 62.62           O  
ATOM    110  CB  PRO    15     -15.729  47.690  18.879  1.00 62.35           C  
ATOM    111  CG  PRO    15     -16.194  48.684  17.878  1.00 61.95           C  
ATOM    112  CD  PRO    15     -17.283  48.056  17.089  1.00 62.29           C  
ATOM    113  N   VAL    16     -16.411  44.424  19.895  1.00 62.70           N  
ATOM    114  CA  VAL    16     -17.012  43.575  20.936  1.00 62.00           C  
ATOM    115  C   VAL    16     -15.947  43.416  22.050  1.00 61.36           C  
ATOM    116  O   VAL    16     -14.801  43.160  21.741  1.00 62.57           O  
ATOM    117  CB  VAL    16     -17.408  42.199  20.316  1.00 62.01           C  
ATOM    118  CG1 VAL    16     -18.064  41.280  21.347  1.00 61.62           C  
ATOM    119  CG2 VAL    16     -18.307  42.408  19.135  1.00 61.84           C  
ATOM    120  N   PRO    17     -16.306  43.598  23.322  1.00 60.41           N  
ATOM    121  CA  PRO    17     -15.359  43.341  24.392  1.00 60.25           C  
ATOM    122  C   PRO    17     -14.991  41.878  24.466  1.00 59.48           C  
ATOM    123  O   PRO    17     -15.821  41.028  24.158  1.00 60.87           O  
ATOM    124  CB  PRO    17     -16.132  43.701  25.679  1.00 59.73           C  
ATOM    125  CG  PRO    17     -17.373  44.271  25.285  1.00 60.45           C  
ATOM    126  CD  PRO    17     -17.621  44.018  23.839  1.00 61.22           C  
ATOM    127  N   PHE    18     -13.779  41.575  24.878  1.00 59.09           N  
ATOM    128  CA  PHE    18     -13.352  40.180  25.028  1.00 60.00           C  
ATOM    129  C   PHE    18     -14.331  39.371  25.874  1.00 59.66           C  
ATOM    130  O   PHE    18     -14.580  38.201  25.601  1.00 59.27           O  
ATOM    131  CB  PHE    18     -11.943  40.079  25.641  1.00 60.36           C  
ATOM    132  CG  PHE    18     -10.829  40.515  24.716  1.00 61.73           C  
ATOM    133  CD1 PHE    18     -11.007  40.611  23.331  1.00 63.29           C  
ATOM    134  CD2 PHE    18      -9.586  40.789  25.229  1.00 63.45           C  
ATOM    135  CE1 PHE    18      -9.972  41.008  22.489  1.00 61.73           C  
ATOM    136  CE2 PHE    18      -8.538  41.181  24.390  1.00 63.81           C  
ATOM    137  CZ  PHE    18      -8.749  41.298  23.018  1.00 63.81           C  
ATOM    138  N   SER    19     -14.896  40.028  26.881  1.00 59.39           N  
ATOM    139  CA  SER    19     -15.812  39.400  27.822  1.00 59.03           C  
ATOM    140  C   SER    19     -17.096  38.837  27.165  1.00 58.26           C  
ATOM    141  O   SER    19     -17.719  37.937  27.703  1.00 59.05           O  
ATOM    142  CB  SER    19     -16.149  40.424  28.932  1.00 58.56           C  
ATOM    143  OG  SER    19     -17.118  41.375  28.499  1.00 60.75           O  
ATOM    144  N   LYS    20     -17.461  39.376  26.003  1.00 57.56           N  
ATOM    145  CA  LYS    20     -18.622  38.984  25.271  1.00 56.87           C  
ATOM    146  C   LYS    20     -18.322  37.990  24.151  1.00 55.79           C  
ATOM    147  O   LYS    20     -19.242  37.475  23.489  1.00 55.89           O  
ATOM    148  CB  LYS    20     -19.297  40.226  24.683  1.00 58.50           C  
ATOM    149  CG  LYS    20     -19.656  41.281  25.714  1.00 61.62           C  
ATOM    150  CD  LYS    20     -21.134  41.349  26.026  1.00 67.10           C  
ATOM    151  CE  LYS    20     -21.841  42.519  25.253  1.00 72.31           C  
ATOM    152  NZ  LYS    20     -23.196  42.117  24.593  1.00 74.04           N  
ATOM    153  N   VAL    21     -17.050  37.681  23.943  1.00 54.46           N  
ATOM    154  CA  VAL    21     -16.674  36.623  22.977  1.00 52.57           C  
ATOM    155  C   VAL    21     -16.825  35.242  23.636  1.00 50.97           C  
ATOM    156  O   VAL    21     -16.201  34.987  24.690  1.00 52.54           O  
ATOM    157  CB  VAL    21     -15.224  36.823  22.448  1.00 53.00           C  
ATOM    158  CG1 VAL    21     -14.850  35.746  21.373  1.00 50.20           C  
ATOM    159  CG2 VAL    21     -15.069  38.272  21.921  1.00 53.32           C  
ATOM    160  N   MET    22     -17.645  34.392  23.031  1.00 47.48           N  
ATOM    161  CA  MET    22     -17.935  33.066  23.535  1.00 45.74           C  
ATOM    162  C   MET    22     -16.919  32.024  23.033  1.00 46.12           C  
ATOM    163  O   MET    22     -16.448  31.187  23.789  1.00 44.25           O  
ATOM    164  CB  MET    22     -19.358  32.651  23.110  1.00 44.28           C  
ATOM    165  CG  MET    22     -20.425  33.576  23.586  1.00 39.75           C  
ATOM    166  SD  MET    22     -22.258  33.106  23.165  0.65 34.59          SE  
ATOM    167  CE  MET    22     -21.956  33.084  21.247  1.00 31.49           C  
ATOM    168  N   TYR    23     -16.635  32.091  21.739  1.00 47.88           N  
ATOM    169  CA  TYR    23     -15.674  31.233  21.061  1.00 49.56           C  
ATOM    170  C   TYR    23     -15.268  31.816  19.681  1.00 50.94           C  
ATOM    171  O   TYR    23     -15.856  32.791  19.174  1.00 51.25           O  
ATOM    172  CB  TYR    23     -16.185  29.770  20.951  1.00 50.31           C  
ATOM    173  CG  TYR    23     -17.372  29.563  20.024  1.00 50.93           C  
ATOM    174  CD1 TYR    23     -18.670  29.616  20.500  1.00 49.91           C  
ATOM    175  CD2 TYR    23     -17.175  29.286  18.667  1.00 52.85           C  
ATOM    176  CE1 TYR    23     -19.720  29.429  19.667  1.00 50.30           C  
ATOM    177  CE2 TYR    23     -18.208  29.114  17.822  1.00 51.25           C  
ATOM    178  CZ  TYR    23     -19.497  29.195  18.315  1.00 52.04           C  
ATOM    179  OH  TYR    23     -20.564  29.013  17.441  1.00 52.22           O  
ATOM    180  N   LEU    24     -14.183  31.287  19.141  1.00 51.88           N  
ATOM    181  CA  LEU    24     -13.715  31.663  17.815  1.00 52.72           C  
ATOM    182  C   LEU    24     -13.626  30.362  17.061  1.00 55.11           C  
ATOM    183  O   LEU    24     -13.285  29.325  17.648  1.00 55.39           O  
ATOM    184  CB  LEU    24     -12.344  32.388  17.826  1.00 52.44           C  
ATOM    185  CG  LEU    24     -12.203  33.773  18.462  1.00 51.64           C  
ATOM    186  CD1 LEU    24     -12.026  33.718  19.998  1.00 51.46           C  
ATOM    187  CD2 LEU    24     -11.038  34.473  17.904  1.00 51.70           C  
ATOM    188  N   GLU    25     -13.973  30.400  15.778  1.00 57.81           N  
ATOM    189  CA  GLU    25     -13.945  29.200  14.949  1.00 59.82           C  
ATOM    190  C   GLU    25     -13.242  29.431  13.614  1.00 60.44           C  
ATOM    191  O   GLU    25     -13.604  30.367  12.875  1.00 59.87           O  
ATOM    192  CB  GLU    25     -15.354  28.677  14.679  1.00 59.79           C  
ATOM    193  CG  GLU    25     -15.347  27.444  13.750  1.00 59.72           C  
ATOM    194  CD  GLU    25     -16.706  26.844  13.534  1.00 61.31           C  
ATOM    195  OE1 GLU    25     -16.770  25.650  13.104  1.00 61.35           O  
ATOM    196  OE2 GLU    25     -17.683  27.569  13.817  1.00 60.92           O  
ATOM    197  N   ALA    26     -12.258  28.568  13.317  1.00 61.72           N  
ATOM    198  CA  ALA    26     -11.662  28.483  11.973  1.00 62.89           C  
ATOM    199  C   ALA    26     -12.565  27.603  11.100  1.00 65.56           C  
ATOM    200  O   ALA    26     -12.829  26.429  11.378  1.00 65.20           O  
ATOM    201  CB  ALA    26     -10.254  27.931  12.019  1.00 62.69           C  
ATOM    202  N   LYS    27     -13.063  28.199  10.044  1.00 69.29           N  
ATOM    203  CA  LYS    27     -14.038  27.541   9.191  1.00 72.27           C  
ATOM    204  C   LYS    27     -13.991  28.167   7.813  1.00 74.02           C  
ATOM    205  O   LYS    27     -13.931  29.384   7.675  1.00 74.45           O  
ATOM    206  CB  LYS    27     -15.429  27.722   9.796  1.00 72.85           C  
ATOM    207  CG  LYS    27     -16.562  27.045   9.080  1.00 71.39           C  
ATOM    208  CD  LYS    27     -17.859  27.743   9.401  1.00 73.27           C  
ATOM    209  CE  LYS    27     -19.021  26.823   9.163  1.00 75.03           C  
ATOM    210  NZ  LYS    27     -20.097  27.510   8.386  1.00 77.07           N  
ATOM    211  N   ASP    28     -14.003  27.317   6.792  1.00 76.84           N  
ATOM    212  CA  ASP    28     -14.027  27.772   5.401  1.00 77.59           C  
ATOM    213  C   ASP    28     -12.925  28.857   5.134  1.00 77.95           C  
ATOM    214  O   ASP    28     -13.183  29.840   4.426  1.00 78.11           O  
ATOM    215  CB  ASP    28     -15.426  28.300   5.088  1.00 78.53           C  
ATOM    216  CG  ASP    28     -16.548  27.225   5.257  1.00 81.48           C  
ATOM    217  OD1 ASP    28     -16.391  26.062   4.800  1.00 85.00           O  
ATOM    218  OD2 ASP    28     -17.619  27.580   5.817  1.00 84.66           O  
ATOM    219  N   LYS    29     -11.732  28.666   5.747  1.00 77.54           N  
ATOM    220  CA  LYS    29     -10.512  29.518   5.589  1.00 76.82           C  
ATOM    221  C   LYS    29     -10.553  30.922   6.239  1.00 76.10           C  
ATOM    222  O   LYS    29      -9.676  31.767   5.982  1.00 75.77           O  
ATOM    223  CB  LYS    29     -10.095  29.633   4.123  1.00 77.31           C  
ATOM    224  CG  LYS    29      -9.776  28.294   3.467  1.00 79.61           C  
ATOM    225  CD  LYS    29      -8.300  28.168   3.028  1.00 82.32           C  
ATOM    226  CE  LYS    29      -7.955  29.110   1.844  1.00 81.95           C  
ATOM    227  NZ  LYS    29      -7.050  28.464   0.864  1.00 81.33           N  
ATOM    228  N   LYS    30     -11.545  31.145   7.103  1.00 74.77           N  
ATOM    229  CA  LYS    30     -11.693  32.419   7.841  1.00 73.86           C  
ATOM    230  C   LYS    30     -11.796  32.163   9.320  1.00 70.12           C  
ATOM    231  O   LYS    30     -12.089  31.054   9.732  1.00 69.63           O  
ATOM    232  CB  LYS    30     -12.969  33.159   7.380  1.00 73.69           C  
ATOM    233  CG  LYS    30     -12.892  33.658   5.940  1.00 75.38           C  
ATOM    234  CD  LYS    30     -14.271  33.861   5.306  1.00 76.35           C  
ATOM    235  CE  LYS    30     -15.069  32.542   5.226  1.00 78.74           C  
ATOM    236  NZ  LYS    30     -15.844  32.376   3.939  1.00 79.28           N  
ATOM    237  N   THR    31     -11.594  33.207  10.111  1.00 66.89           N  
ATOM    238  CA  THR    31     -11.893  33.163  11.549  1.00 65.08           C  
ATOM    239  C   THR    31     -13.220  33.811  11.855  1.00 63.67           C  
ATOM    240  O   THR    31     -13.442  34.948  11.517  1.00 62.84           O  
ATOM    241  CB  THR    31     -10.816  33.875  12.386  1.00 64.71           C  
ATOM    242  OG1 THR    31      -9.580  33.234  12.126  1.00 62.99           O  
ATOM    243  CG2 THR    31     -11.127  33.820  13.897  1.00 63.56           C  
ATOM    244  N   TYR    32     -14.094  33.071  12.517  1.00 62.97           N  
ATOM    245  CA  TYR    32     -15.375  33.591  12.932  1.00 62.51           C  
ATOM    246  C   TYR    32     -15.293  33.820  14.416  1.00 61.62           C  
ATOM    247  O   TYR    32     -14.985  32.920  15.157  1.00 59.82           O  
ATOM    248  CB  TYR    32     -16.482  32.597  12.613  1.00 62.96           C  
ATOM    249  CG  TYR    32     -16.784  32.554  11.163  1.00 63.75           C  
ATOM    250  CD1 TYR    32     -16.112  31.659  10.310  1.00 64.37           C  
ATOM    251  CD2 TYR    32     -17.720  33.424  10.619  1.00 63.97           C  
ATOM    252  CE1 TYR    32     -16.372  31.623   8.960  1.00 63.90           C  
ATOM    253  CE2 TYR    32     -17.995  33.399   9.262  1.00 65.20           C  
ATOM    254  CZ  TYR    32     -17.315  32.500   8.435  1.00 64.90           C  
ATOM    255  OH  TYR    32     -17.603  32.502   7.092  1.00 66.11           O  
ATOM    256  N   VAL    33     -15.552  35.053  14.816  1.00 61.66           N  
ATOM    257  CA  VAL    33     -15.658  35.444  16.205  1.00 61.87           C  
ATOM    258  C   VAL    33     -17.151  35.415  16.578  1.00 62.05           C  
ATOM    259  O   VAL    33     -17.957  36.188  16.059  1.00 61.79           O  
ATOM    260  CB  VAL    33     -15.008  36.840  16.436  1.00 62.18           C  
ATOM    261  CG1 VAL    33     -14.848  37.108  17.914  1.00 61.84           C  
ATOM    262  CG2 VAL    33     -13.647  36.922  15.752  1.00 60.44           C  
ATOM    263  N   ASN    34     -17.497  34.469  17.451  1.00 62.63           N  
ATOM    264  CA  ASN    34     -18.843  34.272  17.968  1.00 62.74           C  
ATOM    265  C   ASN    34     -19.034  34.955  19.334  1.00 63.11           C  
ATOM    266  O   ASN    34     -18.592  34.446  20.374  1.00 62.77           O  
ATOM    267  CB  ASN    34     -19.123  32.787  18.102  1.00 62.29           C  
ATOM    268  CG  ASN    34     -19.303  32.091  16.759  1.00 63.83           C  
ATOM    269  OD1 ASN    34     -18.327  31.761  16.066  1.00 64.13           O  
ATOM    270  ND2 ASN    34     -20.564  31.825  16.410  1.00 61.91           N  
ATOM    271  N   ALA    35     -19.694  36.106  19.302  1.00 63.82           N  
ATOM    272  CA  ALA    35     -19.983  36.927  20.474  1.00 64.45           C  
ATOM    273  C   ALA    35     -21.436  36.713  20.877  1.00 66.13           C  
ATOM    274  O   ALA    35     -22.229  36.105  20.157  1.00 65.78           O  
ATOM    275  CB  ALA    35     -19.695  38.400  20.190  1.00 63.41           C  
ATOM    276  N   GLU    36     -21.795  37.194  22.050  1.00 68.62           N  
ATOM    277  CA  GLU    36     -23.081  36.813  22.627  1.00 71.28           C  
ATOM    278  C   GLU    36     -24.264  37.179  21.727  1.00 72.31           C  
ATOM    279  O   GLU    36     -25.229  36.416  21.623  1.00 72.56           O  
ATOM    280  CB  GLU    36     -23.270  37.459  23.986  1.00 71.27           C  
ATOM    281  CG  GLU    36     -22.296  37.014  25.046  1.00 72.06           C  
ATOM    282  CD  GLU    36     -22.437  37.838  26.279  1.00 72.04           C  
ATOM    283  OE1 GLU    36     -23.142  38.857  26.238  1.00 79.71           O  
ATOM    284  OE2 GLU    36     -21.848  37.506  27.306  1.00 76.93           O  
ATOM    285  N   GLU    37     -24.176  38.350  21.095  1.00 73.72           N  
ATOM    286  CA  GLU    37     -25.256  38.902  20.300  1.00 74.69           C  
ATOM    287  C   GLU    37     -24.968  38.923  18.809  1.00 73.94           C  
ATOM    288  O   GLU    37     -25.870  39.226  18.044  1.00 74.01           O  
ATOM    289  CB  GLU    37     -25.544  40.340  20.756  1.00 75.48           C  
ATOM    290  CG  GLU    37     -26.188  40.454  22.149  1.00 79.08           C  
ATOM    291  CD  GLU    37     -26.492  41.922  22.561  1.00 81.78           C  
ATOM    292  OE1 GLU    37     -26.163  42.870  21.779  1.00 88.35           O  
ATOM    293  OE2 GLU    37     -27.085  42.122  23.668  1.00 90.68           O  
ATOM    294  N   LEU    38     -23.731  38.686  18.375  1.00 73.06           N  
ATOM    295  CA  LEU    38     -23.468  38.604  16.936  1.00 72.61           C  
ATOM    296  C   LEU    38     -22.227  37.794  16.586  1.00 71.39           C  
ATOM    297  O   LEU    38     -21.450  37.416  17.461  1.00 70.69           O  
ATOM    298  CB  LEU    38     -23.486  39.992  16.249  1.00 72.94           C  
ATOM    299  CG  LEU    38     -22.409  41.099  16.273  1.00 74.37           C  
ATOM    300  CD1 LEU    38     -21.356  40.894  17.336  1.00 75.46           C  
ATOM    301  CD2 LEU    38     -21.758  41.268  14.892  1.00 76.18           C  
ATOM    302  N   THR    39     -22.104  37.494  15.295  1.00 69.92           N  
ATOM    303  CA  THR    39     -20.996  36.762  14.757  1.00 69.17           C  
ATOM    304  C   THR    39     -20.404  37.501  13.595  1.00 67.93           C  
ATOM    305  O   THR    39     -21.063  38.201  12.878  1.00 67.20           O  
ATOM    306  CB  THR    39     -21.369  35.320  14.401  1.00 69.41           C  
ATOM    307  OG1 THR    39     -21.821  34.687  15.605  1.00 71.60           O  
ATOM    308  CG2 THR    39     -20.108  34.536  13.876  1.00 69.54           C  
ATOM    309  N   GLY    40     -19.109  37.374  13.441  1.00 67.61           N  
ATOM    310  CA  GLY    40     -18.450  38.155  12.439  1.00 67.41           C  
ATOM    311  C   GLY    40     -17.090  37.590  12.170  1.00 66.88           C  
ATOM    312  O   GLY    40     -16.639  36.670  12.816  1.00 67.02           O  
ATOM    313  N   THR    41     -16.441  38.197  11.209  1.00 66.71           N  
ATOM    314  CA  THR    41     -15.244  37.685  10.614  1.00 66.20           C  
ATOM    315  C   THR    41     -14.079  38.538  11.166  1.00 65.32           C  
ATOM    316  O   THR    41     -14.253  39.725  11.501  1.00 64.33           O  
ATOM    317  CB  THR    41     -15.448  37.747   9.089  1.00 66.32           C  
ATOM    318  OG1 THR    41     -15.778  36.433   8.622  1.00 69.23           O  
ATOM    319  CG2 THR    41     -14.257  38.300   8.359  1.00 65.71           C  
ATOM    320  N   HIS    42     -12.924  37.902  11.318  1.00 64.06           N  
ATOM    321  CA  HIS    42     -11.723  38.584  11.690  1.00 63.72           C  
ATOM    322  C   HIS    42     -10.599  38.078  10.825  1.00 64.21           C  
ATOM    323  O   HIS    42     -10.583  36.908  10.461  1.00 64.45           O  
ATOM    324  CB  HIS    42     -11.367  38.369  13.166  1.00 63.65           C  
ATOM    325  CG  HIS    42     -10.449  39.428  13.691  1.00 62.41           C  
ATOM    326  ND1 HIS    42      -9.112  39.479  13.366  1.00 61.46           N  
ATOM    327  CD2 HIS    42     -10.691  40.528  14.442  1.00 62.93           C  
ATOM    328  CE1 HIS    42      -8.561  40.552  13.911  1.00 63.05           C  
ATOM    329  NE2 HIS    42      -9.496  41.203  14.578  1.00 62.92           N  
ATOM    330  N   LYS    43      -9.637  38.948  10.534  1.00 64.61           N  
ATOM    331  CA  LYS    43      -8.513  38.581   9.688  1.00 65.27           C  
ATOM    332  C   LYS    43      -7.419  37.763  10.375  1.00 64.45           C  
ATOM    333  O   LYS    43      -6.608  37.136   9.710  1.00 64.94           O  
ATOM    334  CB  LYS    43      -7.914  39.844   9.036  1.00 66.18           C  
ATOM    335  CG  LYS    43      -7.385  40.918  10.010  1.00 67.83           C  
ATOM    336  CD  LYS    43      -6.601  41.976   9.258  1.00 67.72           C  
ATOM    337  CE  LYS    43      -5.732  42.773  10.201  1.00 70.39           C  
ATOM    338  NZ  LYS    43      -5.356  44.057   9.555  1.00 73.82           N  
ATOM    339  N   TYR    44      -7.359  37.765  11.694  1.00 64.49           N  
ATOM    340  CA  TYR    44      -6.292  37.035  12.387  1.00 63.96           C  
ATOM    341  C   TYR    44      -6.623  35.581  12.476  1.00 62.69           C  
ATOM    342  O   TYR    44      -7.781  35.206  12.512  1.00 62.31           O  
ATOM    343  CB  TYR    44      -6.062  37.533  13.813  1.00 65.08           C  
ATOM    344  CG  TYR    44      -5.539  38.923  13.976  1.00 65.75           C  
ATOM    345  CD1 TYR    44      -4.940  39.618  12.936  1.00 67.27           C  
ATOM    346  CD2 TYR    44      -5.636  39.546  15.203  1.00 68.59           C  
ATOM    347  CE1 TYR    44      -4.483  40.907  13.114  1.00 67.96           C  
ATOM    348  CE2 TYR    44      -5.174  40.843  15.389  1.00 68.78           C  
ATOM    349  CZ  TYR    44      -4.605  41.505  14.348  1.00 67.12           C  
ATOM    350  OH  TYR    44      -4.168  42.776  14.566  1.00 68.22           O  
ATOM    351  N   SER    45      -5.580  34.766  12.551  1.00 61.92           N  
ATOM    352  CA  SER    45      -5.718  33.320  12.580  1.00 61.21           C  
ATOM    353  C   SER    45      -5.910  32.966  14.035  1.00 60.89           C  
ATOM    354  O   SER    45      -5.765  33.817  14.906  1.00 60.84           O  
ATOM    355  CB  SER    45      -4.449  32.643  12.015  1.00 60.63           C  
ATOM    356  OG  SER    45      -3.358  32.837  12.896  1.00 61.26           O  
ATOM    357  N   LEU    46      -6.241  31.710  14.294  1.00 60.97           N  
ATOM    358  CA  LEU    46      -6.426  31.228  15.652  1.00 60.86           C  
ATOM    359  C   LEU    46      -5.108  31.226  16.395  1.00 61.40           C  
ATOM    360  O   LEU    46      -5.046  31.396  17.627  1.00 61.30           O  
ATOM    361  CB  LEU    46      -7.046  29.836  15.640  1.00 60.45           C  
ATOM    362  CG  LEU    46      -8.517  29.710  15.243  1.00 59.06           C  
ATOM    363  CD1 LEU    46      -8.975  28.342  15.621  1.00 56.63           C  
ATOM    364  CD2 LEU    46      -9.441  30.795  15.873  1.00 56.73           C  
ATOM    365  N   GLN    47      -4.037  31.061  15.632  1.00 62.21           N  
ATOM    366  CA  GLN    47      -2.701  31.132  16.192  1.00 61.91           C  
ATOM    367  C   GLN    47      -2.410  32.553  16.709  1.00 61.17           C  
ATOM    368  O   GLN    47      -1.915  32.726  17.833  1.00 59.89           O  
ATOM    369  CB  GLN    47      -1.670  30.639  15.172  1.00 61.58           C  
ATOM    370  CG  GLN    47      -0.266  30.464  15.791  1.00 63.42           C  
ATOM    371  CD  GLN    47       0.842  30.263  14.748  1.00 64.22           C  
ATOM    372  OE1 GLN    47       1.908  29.738  15.056  1.00 70.90           O  
ATOM    373  NE2 GLN    47       0.603  30.713  13.533  1.00 65.38           N  
ATOM    374  N   GLU    48      -2.731  33.560  15.894  1.00 61.05           N  
ATOM    375  CA  GLU    48      -2.575  34.950  16.300  1.00 61.50           C  
ATOM    376  C   GLU    48      -3.455  35.319  17.491  1.00 60.76           C  
ATOM    377  O   GLU    48      -2.986  35.927  18.458  1.00 60.41           O  
ATOM    378  CB  GLU    48      -2.822  35.888  15.136  1.00 61.77           C  
ATOM    379  CG  GLU    48      -1.623  35.839  14.139  1.00 64.39           C  
ATOM    380  CD  GLU    48      -1.907  36.338  12.699  1.00 63.87           C  
ATOM    381  OE1 GLU    48      -3.074  36.414  12.227  1.00 63.24           O  
ATOM    382  OE2 GLU    48      -0.890  36.620  12.035  1.00 68.21           O  
ATOM    383  N   PHE    49      -4.719  34.943  17.442  1.00 60.08           N  
ATOM    384  CA  PHE    49      -5.592  35.133  18.596  1.00 59.74           C  
ATOM    385  C   PHE    49      -5.080  34.464  19.874  1.00 59.52           C  
ATOM    386  O   PHE    49      -5.273  34.997  20.948  1.00 59.32           O  
ATOM    387  CB  PHE    49      -7.025  34.672  18.295  1.00 59.41           C  
ATOM    388  CG  PHE    49      -7.869  35.716  17.645  1.00 58.45           C  
ATOM    389  CD1 PHE    49      -8.265  36.829  18.346  1.00 59.31           C  
ATOM    390  CD2 PHE    49      -8.277  35.583  16.337  1.00 59.28           C  
ATOM    391  CE1 PHE    49      -9.062  37.809  17.748  1.00 59.58           C  
ATOM    392  CE2 PHE    49      -9.071  36.546  15.743  1.00 58.97           C  
ATOM    393  CZ  PHE    49      -9.463  37.654  16.452  1.00 58.62           C  
ATOM    394  N   GLU    50      -4.438  33.309  19.785  1.00 59.90           N  
ATOM    395  CA  GLU    50      -3.891  32.692  20.993  1.00 60.98           C  
ATOM    396  C   GLU    50      -2.847  33.566  21.696  1.00 60.69           C  
ATOM    397  O   GLU    50      -2.687  33.525  22.913  1.00 61.09           O  
ATOM    398  CB  GLU    50      -3.245  31.350  20.681  1.00 61.30           C  
ATOM    399  CG  GLU    50      -4.198  30.209  20.578  1.00 62.87           C  
ATOM    400  CD  GLU    50      -3.463  28.877  20.628  1.00 63.39           C  
ATOM    401  OE1 GLU    50      -3.150  28.378  19.529  1.00 62.18           O  
ATOM    402  OE2 GLU    50      -3.203  28.357  21.763  1.00 64.88           O  
ATOM    403  N   TYR    51      -2.100  34.319  20.908  1.00 60.43           N  
ATOM    404  CA  TYR    51      -1.147  35.239  21.431  1.00 59.53           C  
ATOM    405  C   TYR    51      -1.873  36.419  22.104  1.00 58.87           C  
ATOM    406  O   TYR    51      -1.497  36.853  23.180  1.00 57.91           O  
ATOM    407  CB  TYR    51      -0.190  35.717  20.308  1.00 60.13           C  
ATOM    408  CG  TYR    51       0.664  36.911  20.739  1.00 60.63           C  
ATOM    409  CD1 TYR    51       1.815  36.725  21.527  1.00 60.30           C  
ATOM    410  CD2 TYR    51       0.271  38.213  20.442  1.00 59.27           C  
ATOM    411  CE1 TYR    51       2.575  37.801  21.974  1.00 60.07           C  
ATOM    412  CE2 TYR    51       1.015  39.298  20.886  1.00 60.70           C  
ATOM    413  CZ  TYR    51       2.179  39.093  21.652  1.00 61.51           C  
ATOM    414  OH  TYR    51       2.937  40.192  22.068  1.00 61.75           O  
ATOM    415  N   LEU    52      -2.928  36.927  21.484  1.00 59.17           N  
ATOM    416  CA  LEU    52      -3.469  38.211  21.913  1.00 59.78           C  
ATOM    417  C   LEU    52      -4.591  38.163  22.951  1.00 58.88           C  
ATOM    418  O   LEU    52      -4.808  39.121  23.689  1.00 58.40           O  
ATOM    419  CB  LEU    52      -3.838  39.056  20.705  1.00 59.99           C  
ATOM    420  CG  LEU    52      -5.137  38.900  19.986  1.00 62.34           C  
ATOM    421  CD1 LEU    52      -6.204  39.814  20.632  1.00 63.11           C  
ATOM    422  CD2 LEU    52      -4.889  39.263  18.464  1.00 61.78           C  
ATOM    423  N   LEU    53      -5.255  37.025  23.034  1.00 58.60           N  
ATOM    424  CA  LEU    53      -6.360  36.850  23.928  1.00 58.14           C  
ATOM    425  C   LEU    53      -5.816  36.464  25.279  1.00 58.30           C  
ATOM    426  O   LEU    53      -4.794  35.750  25.362  1.00 58.20           O  
ATOM    427  CB  LEU    53      -7.317  35.777  23.404  1.00 58.30           C  
ATOM    428  CG  LEU    53      -8.118  36.061  22.113  1.00 57.08           C  
ATOM    429  CD1 LEU    53      -8.762  34.777  21.657  1.00 51.00           C  
ATOM    430  CD2 LEU    53      -9.141  37.175  22.316  1.00 54.58           C  
ATOM    431  N   PRO    54      -6.464  36.963  26.348  1.00 58.29           N  
ATOM    432  CA  PRO    54      -6.008  36.686  27.722  1.00 58.90           C  
ATOM    433  C   PRO    54      -6.029  35.202  28.076  1.00 59.86           C  
ATOM    434  O   PRO    54      -7.042  34.531  27.929  1.00 60.64           O  
ATOM    435  CB  PRO    54      -6.971  37.490  28.613  1.00 58.39           C  
ATOM    436  CG  PRO    54      -7.991  38.073  27.727  1.00 58.75           C  
ATOM    437  CD  PRO    54      -7.626  37.865  26.299  1.00 57.84           C  
ATOM    438  N   LYS    55      -4.902  34.698  28.537  1.00 61.50           N  
ATOM    439  CA  LYS    55      -4.705  33.267  28.684  1.00 63.14           C  
ATOM    440  C   LYS    55      -5.491  32.742  29.909  1.00 62.48           C  
ATOM    441  O   LYS    55      -5.724  31.537  30.039  1.00 62.64           O  
ATOM    442  CB  LYS    55      -3.189  32.944  28.699  1.00 63.10           C  
ATOM    443  CG  LYS    55      -2.533  33.080  30.067  1.00 66.03           C  
ATOM    444  CD  LYS    55      -0.970  33.110  30.025  1.00 66.76           C  
ATOM    445  CE  LYS    55      -0.329  32.841  31.429  1.00 66.49           C  
ATOM    446  NZ  LYS    55      -1.178  33.499  32.466  1.00 68.77           N  
ATOM    447  N   ASP    56      -5.972  33.653  30.754  1.00 62.23           N  
ATOM    448  CA  ASP    56      -6.820  33.272  31.900  1.00 62.66           C  
ATOM    449  C   ASP    56      -8.286  32.924  31.528  1.00 62.28           C  
ATOM    450  O   ASP    56      -9.004  32.312  32.320  1.00 62.43           O  
ATOM    451  CB  ASP    56      -6.774  34.362  32.996  1.00 63.27           C  
ATOM    452  CG  ASP    56      -7.440  35.702  32.578  1.00 65.72           C  
ATOM    453  OD1 ASP    56      -7.542  36.045  31.388  1.00 71.06           O  
ATOM    454  OD2 ASP    56      -7.837  36.464  33.470  1.00 69.99           O  
ATOM    455  N   SER    57      -8.701  33.304  30.319  1.00 61.57           N  
ATOM    456  CA  SER    57     -10.084  33.188  29.870  1.00 60.88           C  
ATOM    457  C   SER    57     -10.259  32.343  28.635  1.00 59.81           C  
ATOM    458  O   SER    57     -11.243  31.649  28.501  1.00 59.87           O  
ATOM    459  CB  SER    57     -10.622  34.581  29.563  1.00 61.29           C  
ATOM    460  OG  SER    57     -11.419  35.015  30.614  1.00 62.81           O  
ATOM    461  N   PHE    58      -9.303  32.437  27.722  1.00 59.09           N  
ATOM    462  CA  PHE    58      -9.379  31.813  26.399  1.00 58.06           C  
ATOM    463  C   PHE    58      -8.452  30.610  26.317  1.00 57.54           C  
ATOM    464  O   PHE    58      -7.371  30.640  26.831  1.00 56.74           O  
ATOM    465  CB  PHE    58      -9.069  32.868  25.328  1.00 57.04           C  
ATOM    466  CG  PHE    58     -10.143  33.942  25.230  1.00 57.21           C  
ATOM    467  CD1 PHE    58     -10.055  35.107  25.979  1.00 58.12           C  
ATOM    468  CD2 PHE    58     -11.283  33.745  24.453  1.00 56.05           C  
ATOM    469  CE1 PHE    58     -11.056  36.083  25.917  1.00 56.66           C  
ATOM    470  CE2 PHE    58     -12.268  34.687  24.390  1.00 55.56           C  
ATOM    471  CZ  PHE    58     -12.160  35.864  25.123  1.00 57.10           C  
ATOM    472  N   ILE    59      -8.926  29.516  25.717  1.00 58.38           N  
ATOM    473  CA  ILE    59      -8.101  28.330  25.484  1.00 58.40           C  
ATOM    474  C   ILE    59      -8.378  27.708  24.119  1.00 57.04           C  
ATOM    475  O   ILE    59      -9.503  27.433  23.783  1.00 57.12           O  
ATOM    476  CB  ILE    59      -8.278  27.248  26.623  1.00 58.94           C  
ATOM    477  CG1 ILE    59      -7.242  26.113  26.455  1.00 59.95           C  
ATOM    478  CG2 ILE    59      -9.671  26.624  26.591  1.00 61.49           C  
ATOM    479  CD1 ILE    59      -7.061  25.222  27.673  1.00 59.51           C  
ATOM    480  N   ARG    60      -7.331  27.507  23.334  1.00 56.09           N  
ATOM    481  CA  ARG    60      -7.365  26.596  22.210  1.00 55.43           C  
ATOM    482  C   ARG    60      -7.704  25.167  22.655  1.00 55.43           C  
ATOM    483  O   ARG    60      -6.964  24.531  23.401  1.00 54.84           O  
ATOM    484  CB  ARG    60      -6.032  26.595  21.470  1.00 55.35           C  
ATOM    485  CG  ARG    60      -6.111  25.946  20.100  1.00 54.80           C  
ATOM    486  CD  ARG    60      -6.621  26.906  19.054  1.00 54.03           C  
ATOM    487  NE  ARG    60      -6.421  26.382  17.706  1.00 54.40           N  
ATOM    488  CZ  ARG    60      -5.341  26.570  16.948  1.00 54.54           C  
ATOM    489  NH1 ARG    60      -4.317  27.302  17.361  1.00 53.75           N  
ATOM    490  NH2 ARG    60      -5.306  26.062  15.726  1.00 52.56           N  
ATOM    491  N   CYS    61      -8.839  24.669  22.157  1.00 55.76           N  
ATOM    492  CA  CYS    61      -9.343  23.361  22.541  1.00 55.48           C  
ATOM    493  C   CYS    61      -9.510  22.395  21.380  1.00 55.23           C  
ATOM    494  O   CYS    61      -9.906  21.259  21.574  1.00 55.26           O  
ATOM    495  CB  CYS    61     -10.665  23.534  23.288  1.00 55.58           C  
ATOM    496  SG  CYS    61     -11.994  24.211  22.330  1.00 53.65           S  
ATOM    497  N   HIS    62      -9.165  22.841  20.182  1.00 55.99           N  
ATOM    498  CA  HIS    62      -9.402  22.100  18.952  1.00 56.21           C  
ATOM    499  C   HIS    62      -8.646  22.898  17.909  1.00 56.71           C  
ATOM    500  O   HIS    62      -8.516  24.087  18.073  1.00 56.13           O  
ATOM    501  CB  HIS    62     -10.904  22.123  18.682  1.00 55.80           C  
ATOM    502  CG  HIS    62     -11.360  21.244  17.560  1.00 55.15           C  
ATOM    503  ND1 HIS    62     -11.127  21.544  16.235  1.00 55.71           N  
ATOM    504  CD2 HIS    62     -12.114  20.120  17.563  1.00 55.19           C  
ATOM    505  CE1 HIS    62     -11.707  20.639  15.472  1.00 57.18           C  
ATOM    506  NE2 HIS    62     -12.324  19.768  16.249  1.00 56.36           N  
ATOM    507  N   ARG    63      -8.158  22.257  16.842  1.00 58.44           N  
ATOM    508  CA  ARG    63      -7.437  22.946  15.749  1.00 59.37           C  
ATOM    509  C   ARG    63      -8.257  24.034  15.090  1.00 58.79           C  
ATOM    510  O   ARG    63      -7.709  24.907  14.434  1.00 59.46           O  
ATOM    511  CB  ARG    63      -6.927  21.953  14.672  1.00 60.11           C  
ATOM    512  CG  ARG    63      -8.010  21.232  13.863  1.00 62.74           C  
ATOM    513  CD  ARG    63      -7.459  20.502  12.602  1.00 65.11           C  
ATOM    514  NE  ARG    63      -8.414  20.771  11.518  1.00 73.56           N  
ATOM    515  CZ  ARG    63      -8.179  21.504  10.427  1.00 75.10           C  
ATOM    516  NH1 ARG    63      -6.978  21.990  10.151  1.00 78.37           N  
ATOM    517  NH2 ARG    63      -9.161  21.719   9.573  1.00 74.99           N  
ATOM    518  N   SER    64      -9.564  23.969  15.261  1.00 58.15           N  
ATOM    519  CA  SER    64     -10.502  24.915  14.654  1.00 58.67           C  
ATOM    520  C   SER    64     -11.241  25.837  15.662  1.00 58.50           C  
ATOM    521  O   SER    64     -12.032  26.676  15.231  1.00 59.59           O  
ATOM    522  CB  SER    64     -11.533  24.110  13.832  1.00 58.55           C  
ATOM    523  OG  SER    64     -11.020  23.791  12.524  1.00 60.29           O  
ATOM    524  N   PHE    65     -10.976  25.713  16.971  1.00 58.22           N  
ATOM    525  CA  PHE    65     -11.703  26.480  18.006  1.00 58.03           C  
ATOM    526  C   PHE    65     -10.839  27.041  19.093  1.00 56.70           C  
ATOM    527  O   PHE    65      -9.964  26.344  19.638  1.00 56.67           O  
ATOM    528  CB  PHE    65     -12.742  25.606  18.710  1.00 59.19           C  
ATOM    529  CG  PHE    65     -13.870  25.194  17.825  1.00 60.22           C  
ATOM    530  CD1 PHE    65     -13.793  24.021  17.083  1.00 63.71           C  
ATOM    531  CD2 PHE    65     -15.010  25.995  17.713  1.00 60.70           C  
ATOM    532  CE1 PHE    65     -14.870  23.647  16.196  1.00 61.83           C  
ATOM    533  CE2 PHE    65     -16.064  25.636  16.875  1.00 62.73           C  
ATOM    534  CZ  PHE    65     -15.991  24.452  16.116  1.00 61.68           C  
ATOM    535  N   ILE    66     -11.110  28.306  19.428  1.00 55.10           N  
ATOM    536  CA  ILE    66     -10.716  28.874  20.707  1.00 53.34           C  
ATOM    537  C   ILE    66     -12.004  29.164  21.526  1.00 53.38           C  
ATOM    538  O   ILE    66     -12.942  29.786  21.037  1.00 51.87           O  
ATOM    539  CB  ILE    66      -9.875  30.163  20.574  1.00 54.09           C  
ATOM    540  CG1 ILE    66      -8.543  29.891  19.855  1.00 50.40           C  
ATOM    541  CG2 ILE    66      -9.676  30.826  21.994  1.00 54.22           C  
ATOM    542  CD1 ILE    66      -7.818  31.110  19.492  1.00 50.41           C  
ATOM    543  N   VAL    67     -12.046  28.673  22.766  1.00 53.17           N  
ATOM    544  CA  VAL    67     -13.202  28.885  23.634  1.00 53.52           C  
ATOM    545  C   VAL    67     -12.893  29.890  24.778  1.00 53.87           C  
ATOM    546  O   VAL    67     -11.735  29.980  25.302  1.00 54.47           O  
ATOM    547  CB  VAL    67     -13.762  27.510  24.166  1.00 53.86           C  
ATOM    548  CG1 VAL    67     -12.883  26.912  25.260  1.00 50.91           C  
ATOM    549  CG2 VAL    67     -15.235  27.649  24.669  1.00 53.80           C  
ATOM    550  N   ASN    68     -13.909  30.652  25.159  1.00 53.60           N  
ATOM    551  CA  ASN    68     -13.868  31.466  26.397  1.00 54.29           C  
ATOM    552  C   ASN    68     -14.450  30.636  27.529  1.00 54.17           C  
ATOM    553  O   ASN    68     -15.636  30.364  27.539  1.00 53.52           O  
ATOM    554  CB  ASN    68     -14.710  32.747  26.209  1.00 54.77           C  
ATOM    555  CG  ASN    68     -14.520  33.760  27.317  1.00 53.31           C  
ATOM    556  OD1 ASN    68     -14.120  33.424  28.392  1.00 54.57           O  
ATOM    557  ND2 ASN    68     -14.863  35.007  27.044  1.00 52.58           N  
ATOM    558  N   VAL    69     -13.618  30.273  28.499  1.00 54.85           N  
ATOM    559  CA  VAL    69     -14.043  29.415  29.612  1.00 55.43           C  
ATOM    560  C   VAL    69     -15.141  30.083  30.436  1.00 56.62           C  
ATOM    561  O   VAL    69     -15.870  29.393  31.166  1.00 58.19           O  
ATOM    562  CB  VAL    69     -12.846  28.968  30.530  1.00 55.37           C  
ATOM    563  CG1 VAL    69     -11.653  28.422  29.661  1.00 55.16           C  
ATOM    564  CG2 VAL    69     -12.377  30.090  31.405  1.00 55.08           C  
ATOM    565  N   ASN    70     -15.299  31.407  30.314  1.00 56.08           N  
ATOM    566  CA  ASN    70     -16.347  32.088  31.060  1.00 56.16           C  
ATOM    567  C   ASN    70     -17.726  31.956  30.477  1.00 56.59           C  
ATOM    568  O   ASN    70     -18.711  32.302  31.130  1.00 56.78           O  
ATOM    569  CB  ASN    70     -15.976  33.553  31.263  1.00 55.78           C  
ATOM    570  CG  ASN    70     -14.760  33.692  32.167  1.00 57.60           C  
ATOM    571  OD1 ASN    70     -14.802  33.308  33.352  1.00 58.65           O  
ATOM    572  ND2 ASN    70     -13.656  34.173  31.602  1.00 56.66           N  
ATOM    573  N   HIS    71     -17.804  31.474  29.237  1.00 57.27           N  
ATOM    574  CA  HIS    71     -19.077  31.130  28.622  1.00 56.72           C  
ATOM    575  C   HIS    71     -19.350  29.661  28.597  1.00 56.36           C  
ATOM    576  O   HIS    71     -20.374  29.254  28.104  1.00 57.18           O  
ATOM    577  CB  HIS    71     -19.166  31.719  27.246  1.00 57.35           C  
ATOM    578  CG  HIS    71     -19.139  33.203  27.259  1.00 57.90           C  
ATOM    579  ND1 HIS    71     -20.280  33.959  27.383  1.00 63.49           N  
ATOM    580  CD2 HIS    71     -18.109  34.078  27.214  1.00 60.53           C  
ATOM    581  CE1 HIS    71     -19.955  35.244  27.396  1.00 62.23           C  
ATOM    582  NE2 HIS    71     -18.639  35.341  27.291  1.00 62.98           N  
ATOM    583  N   ILE    72     -18.467  28.856  29.160  1.00 56.78           N  
ATOM    584  CA  ILE    72     -18.715  27.416  29.278  1.00 57.01           C  
ATOM    585  C   ILE    72     -19.716  27.212  30.391  1.00 58.60           C  
ATOM    586  O   ILE    72     -19.519  27.704  31.521  1.00 59.44           O  
ATOM    587  CB  ILE    72     -17.442  26.564  29.579  1.00 56.64           C  
ATOM    588  CG1 ILE    72     -16.472  26.602  28.392  1.00 55.81           C  
ATOM    589  CG2 ILE    72     -17.812  25.081  29.890  1.00 55.58           C  
ATOM    590  CD1 ILE    72     -15.142  25.972  28.642  1.00 54.02           C  
ATOM    591  N   LYS    73     -20.772  26.466  30.084  1.00 59.67           N  
ATOM    592  CA  LYS    73     -21.706  26.041  31.113  1.00 61.42           C  
ATOM    593  C   LYS    73     -21.262  24.704  31.775  1.00 60.69           C  
ATOM    594  O   LYS    73     -21.191  24.623  33.016  1.00 61.22           O  
ATOM    595  CB  LYS    73     -23.111  25.949  30.533  1.00 61.67           C  
ATOM    596  CG  LYS    73     -24.142  25.461  31.516  1.00 64.57           C  
ATOM    597  CD  LYS    73     -25.534  25.732  31.000  1.00 66.39           C  
ATOM    598  CE  LYS    73     -26.394  24.489  31.034  1.00 71.85           C  
ATOM    599  NZ  LYS    73     -27.081  24.405  32.361  1.00 75.78           N  
ATOM    600  N   ALA    74     -20.935  23.699  30.963  1.00 59.58           N  
ATOM    601  CA  ALA    74     -20.549  22.375  31.470  1.00 59.98           C  
ATOM    602  C   ALA    74     -19.606  21.709  30.482  1.00 59.82           C  
ATOM    603  O   ALA    74     -19.678  21.978  29.271  1.00 59.65           O  
ATOM    604  CB  ALA    74     -21.780  21.458  31.717  1.00 59.20           C  
ATOM    605  N   ILE    75     -18.718  20.867  31.024  1.00 59.52           N  
ATOM    606  CA  ILE    75     -17.764  20.066  30.280  1.00 60.03           C  
ATOM    607  C   ILE    75     -18.177  18.592  30.458  1.00 60.42           C  
ATOM    608  O   ILE    75     -18.284  18.096  31.585  1.00 59.74           O  
ATOM    609  CB  ILE    75     -16.303  20.229  30.794  1.00 60.12           C  
ATOM    610  CG1 ILE    75     -15.880  21.709  30.841  1.00 60.21           C  
ATOM    611  CG2 ILE    75     -15.338  19.325  29.978  1.00 58.97           C  
ATOM    612  CD1 ILE    75     -14.580  22.010  31.675  1.00 58.17           C  
ATOM    613  N   TYR    76     -18.381  17.912  29.331  1.00 61.43           N  
ATOM    614  CA  TYR    76     -18.799  16.505  29.281  1.00 62.33           C  
ATOM    615  C   TYR    76     -17.750  15.657  28.663  1.00 62.77           C  
ATOM    616  O   TYR    76     -17.159  16.044  27.674  1.00 61.86           O  
ATOM    617  CB  TYR    76     -20.067  16.365  28.420  1.00 64.04           C  
ATOM    618  CG  TYR    76     -21.249  17.027  29.074  1.00 64.55           C  
ATOM    619  CD1 TYR    76     -21.826  16.451  30.207  1.00 66.04           C  
ATOM    620  CD2 TYR    76     -21.780  18.217  28.590  1.00 64.45           C  
ATOM    621  CE1 TYR    76     -22.867  17.032  30.858  1.00 67.30           C  
ATOM    622  CE2 TYR    76     -22.879  18.804  29.232  1.00 64.89           C  
ATOM    623  CZ  TYR    76     -23.410  18.204  30.369  1.00 66.45           C  
ATOM    624  OH  TYR    76     -24.482  18.749  31.069  1.00 68.02           O  
ATOM    625  N   PRO    77     -17.504  14.483  29.243  1.00 64.19           N  
ATOM    626  CA  PRO    77     -16.632  13.542  28.528  1.00 65.35           C  
ATOM    627  C   PRO    77     -17.478  12.787  27.532  1.00 65.44           C  
ATOM    628  O   PRO    77     -18.058  11.803  27.890  1.00 65.52           O  
ATOM    629  CB  PRO    77     -16.077  12.640  29.644  1.00 64.99           C  
ATOM    630  CG  PRO    77     -17.099  12.714  30.759  1.00 64.32           C  
ATOM    631  CD  PRO    77     -17.955  13.963  30.548  1.00 64.28           C  
ATOM    632  N   ASP    78     -17.579  13.279  26.304  1.00 66.55           N  
ATOM    633  CA  ASP    78     -18.605  12.768  25.363  1.00 67.46           C  
ATOM    634  C   ASP    78     -18.200  11.397  24.815  1.00 68.08           C  
ATOM    635  O   ASP    78     -19.042  10.591  24.469  1.00 67.98           O  
ATOM    636  CB  ASP    78     -18.926  13.781  24.241  1.00 66.88           C  
ATOM    637  CG  ASP    78     -17.714  14.146  23.391  1.00 68.06           C  
ATOM    638  OD1 ASP    78     -16.610  14.309  23.934  1.00 69.21           O  
ATOM    639  OD2 ASP    78     -17.872  14.306  22.161  1.00 71.97           O  
ATOM    640  N   THR    79     -16.891  11.169  24.769  1.00 69.38           N  
ATOM    641  CA  THR    79     -16.302   9.900  24.417  1.00 69.80           C  
ATOM    642  C   THR    79     -15.089   9.708  25.342  1.00 71.24           C  
ATOM    643  O   THR    79     -14.815  10.525  26.225  1.00 71.66           O  
ATOM    644  CB  THR    79     -15.882   9.878  22.934  1.00 69.96           C  
ATOM    645  OG1 THR    79     -14.634  10.563  22.764  1.00 69.81           O  
ATOM    646  CG2 THR    79     -16.962  10.518  22.057  1.00 67.37           C  
ATOM    647  N   HIS    80     -14.357   8.624  25.156  1.00 72.15           N  
ATOM    648  CA  HIS    80     -13.262   8.321  26.067  1.00 72.09           C  
ATOM    649  C   HIS    80     -12.036   9.199  25.796  1.00 71.66           C  
ATOM    650  O   HIS    80     -11.197   9.380  26.680  1.00 71.54           O  
ATOM    651  CB  HIS    80     -12.905   6.838  25.952  1.00 74.54           C  
ATOM    652  CG  HIS    80     -12.424   6.435  24.588  1.00 77.71           C  
ATOM    653  ND1 HIS    80     -11.076   6.276  24.288  1.00 83.05           N  
ATOM    654  CD2 HIS    80     -13.105   6.163  23.443  1.00 82.06           C  
ATOM    655  CE1 HIS    80     -10.956   5.922  23.015  1.00 84.98           C  
ATOM    656  NE2 HIS    80     -12.172   5.846  22.480  1.00 84.43           N  
ATOM    657  N   SER    81     -11.942   9.770  24.582  1.00 70.35           N  
ATOM    658  CA  SER    81     -10.762  10.594  24.179  1.00 68.31           C  
ATOM    659  C   SER    81     -11.008  12.131  24.030  1.00 66.70           C  
ATOM    660  O   SER    81     -10.070  12.889  23.928  1.00 65.88           O  
ATOM    661  CB  SER    81     -10.207  10.050  22.870  1.00 67.88           C  
ATOM    662  OG  SER    81     -11.261   9.953  21.925  1.00 69.17           O  
ATOM    663  N   THR    82     -12.264  12.568  24.023  1.00 65.31           N  
ATOM    664  CA  THR    82     -12.635  13.963  23.752  1.00 63.25           C  
ATOM    665  C   THR    82     -13.548  14.516  24.859  1.00 62.65           C  
ATOM    666  O   THR    82     -14.080  13.751  25.698  1.00 62.99           O  
ATOM    667  CB  THR    82     -13.446  14.076  22.436  1.00 62.72           C  
ATOM    668  OG1 THR    82     -14.598  13.261  22.563  1.00 60.82           O  
ATOM    669  CG2 THR    82     -12.671  13.635  21.218  1.00 60.62           C  
ATOM    670  N   PHE    83     -13.745  15.848  24.839  1.00 60.99           N  
ATOM    671  CA  PHE    83     -14.822  16.516  25.603  1.00 58.92           C  
ATOM    672  C   PHE    83     -15.751  17.254  24.670  1.00 56.16           C  
ATOM    673  O   PHE    83     -15.435  17.547  23.530  1.00 54.69           O  
ATOM    674  CB  PHE    83     -14.277  17.502  26.651  1.00 59.27           C  
ATOM    675  CG  PHE    83     -13.275  16.897  27.611  1.00 59.80           C  
ATOM    676  CD1 PHE    83     -13.700  16.106  28.681  1.00 59.77           C  
ATOM    677  CD2 PHE    83     -11.904  17.127  27.454  1.00 60.92           C  
ATOM    678  CE1 PHE    83     -12.790  15.550  29.559  1.00 58.13           C  
ATOM    679  CE2 PHE    83     -10.990  16.583  28.347  1.00 59.35           C  
ATOM    680  CZ  PHE    83     -11.440  15.786  29.391  1.00 59.19           C  
ATOM    681  N   LEU    84     -16.918  17.556  25.185  1.00 53.95           N  
ATOM    682  CA  LEU    84     -17.848  18.373  24.479  1.00 53.17           C  
ATOM    683  C   LEU    84     -18.238  19.442  25.469  1.00 51.78           C  
ATOM    684  O   LEU    84     -18.518  19.129  26.641  1.00 52.43           O  
ATOM    685  CB  LEU    84     -19.058  17.527  24.077  1.00 53.53           C  
ATOM    686  CG  LEU    84     -19.986  17.984  23.007  1.00 53.39           C  
ATOM    687  CD1 LEU    84     -19.198  18.656  21.855  1.00 52.65           C  
ATOM    688  CD2 LEU    84     -20.822  16.736  22.567  1.00 53.10           C  
ATOM    689  N   LEU    85     -18.202  20.699  25.019  1.00 49.78           N  
ATOM    690  CA  LEU    85     -18.481  21.845  25.874  1.00 47.93           C  
ATOM    691  C   LEU    85     -19.883  22.320  25.598  1.00 47.39           C  
ATOM    692  O   LEU    85     -20.253  22.639  24.491  1.00 46.54           O  
ATOM    693  CB  LEU    85     -17.478  22.989  25.620  1.00 47.12           C  
ATOM    694  CG  LEU    85     -15.994  22.593  25.581  1.00 45.60           C  
ATOM    695  CD1 LEU    85     -15.078  23.803  25.371  1.00 36.85           C  
ATOM    696  CD2 LEU    85     -15.635  21.783  26.820  1.00 43.69           C  
ATOM    697  N   SER    86     -20.664  22.376  26.648  1.00 47.97           N  
ATOM    698  CA  SER    86     -21.970  23.000  26.640  1.00 48.07           C  
ATOM    699  C   SER    86     -21.781  24.472  26.939  1.00 45.91           C  
ATOM    700  O   SER    86     -21.316  24.814  28.027  1.00 45.30           O  
ATOM    701  CB  SER    86     -22.819  22.353  27.758  1.00 49.42           C  
ATOM    702  OG  SER    86     -24.209  22.619  27.619  1.00 55.91           O  
ATOM    703  N   MET    87     -22.133  25.339  25.988  1.00 44.13           N  
ATOM    704  CA  MET    87     -22.013  26.758  26.179  1.00 43.18           C  
ATOM    705  C   MET    87     -23.277  27.327  26.847  1.00 44.86           C  
ATOM    706  O   MET    87     -24.316  26.668  26.840  1.00 46.03           O  
ATOM    707  CB  MET    87     -21.706  27.472  24.867  1.00 42.05           C  
ATOM    708  CG  MET    87     -20.544  26.909  24.091  1.00 39.14           C  
ATOM    709  SD  MET    87     -18.853  26.839  25.025  0.65 32.51          SE  
ATOM    710  CE  MET    87     -18.588  28.706  25.170  1.00 25.61           C  
ATOM    711  N   ASP    88     -23.161  28.530  27.421  1.00 45.01           N  
ATOM    712  CA  ASP    88     -24.228  29.167  28.115  1.00 46.81           C  
ATOM    713  C   ASP    88     -25.432  29.481  27.224  1.00 47.90           C  
ATOM    714  O   ASP    88     -26.553  29.445  27.691  1.00 49.37           O  
ATOM    715  CB  ASP    88     -23.747  30.512  28.706  1.00 47.48           C  
ATOM    716  CG  ASP    88     -23.081  30.369  30.055  1.00 47.38           C  
ATOM    717  OD1 ASP    88     -23.214  29.307  30.694  1.00 48.80           O  
ATOM    718  OD2 ASP    88     -22.425  31.343  30.484  1.00 50.10           O  
ATOM    719  N   ASN    89     -25.211  29.867  25.973  1.00 48.07           N  
ATOM    720  CA  ASN    89     -26.304  30.126  25.034  1.00 47.90           C  
ATOM    721  C   ASN    89     -26.907  28.853  24.347  1.00 49.95           C  
ATOM    722  O   ASN    89     -27.642  28.968  23.413  1.00 50.38           O  
ATOM    723  CB  ASN    89     -25.798  31.069  23.958  1.00 45.44           C  
ATOM    724  CG  ASN    89     -24.879  30.381  22.963  1.00 39.40           C  
ATOM    725  OD1 ASN    89     -24.424  29.257  23.175  1.00 34.26           O  
ATOM    726  ND2 ASN    89     -24.603  31.048  21.883  1.00 29.72           N  
ATOM    727  N   GLY    90     -26.542  27.654  24.776  1.00 53.52           N  
ATOM    728  CA  GLY    90     -27.030  26.399  24.204  1.00 54.20           C  
ATOM    729  C   GLY    90     -26.150  25.776  23.133  1.00 56.18           C  
ATOM    730  O   GLY    90     -26.474  24.680  22.628  1.00 57.36           O  
ATOM    731  N   GLU    91     -25.073  26.457  22.720  1.00 56.93           N  
ATOM    732  CA  GLU    91     -24.254  25.886  21.631  1.00 56.95           C  
ATOM    733  C   GLU    91     -23.350  24.827  22.213  1.00 57.61           C  
ATOM    734  O   GLU    91     -23.290  24.685  23.431  1.00 58.02           O  
ATOM    735  CB  GLU    91     -23.433  26.916  20.890  1.00 56.78           C  
ATOM    736  CG  GLU    91     -24.264  28.017  20.270  1.00 57.08           C  
ATOM    737  CD  GLU    91     -23.401  28.924  19.417  1.00 57.47           C  
ATOM    738  OE1 GLU    91     -23.367  30.121  19.688  1.00 58.86           O  
ATOM    739  OE2 GLU    91     -22.730  28.435  18.479  1.00 59.86           O  
ATOM    740  N   ARG    92     -22.687  24.057  21.356  1.00 57.41           N  
ATOM    741  CA  ARG    92     -21.666  23.125  21.835  1.00 57.56           C  
ATOM    742  C   ARG    92     -20.394  23.313  21.051  1.00 56.61           C  
ATOM    743  O   ARG    92     -20.410  23.760  19.911  1.00 55.30           O  
ATOM    744  CB  ARG    92     -22.124  21.647  21.825  1.00 57.51           C  
ATOM    745  CG  ARG    92     -22.418  21.066  20.425  1.00 58.70           C  
ATOM    746  CD  ARG    92     -22.994  19.651  20.473  1.00 57.48           C  
ATOM    747  NE  ARG    92     -24.233  19.646  21.242  1.00 59.27           N  
ATOM    748  CZ  ARG    92     -25.438  19.980  20.770  1.00 57.86           C  
ATOM    749  NH1 ARG    92     -25.613  20.330  19.505  1.00 59.25           N  
ATOM    750  NH2 ARG    92     -26.483  19.936  21.573  1.00 52.87           N  
ATOM    751  N   VAL    93     -19.289  22.972  21.689  1.00 57.11           N  
ATOM    752  CA  VAL    93     -17.965  23.112  21.087  1.00 57.84           C  
ATOM    753  C   VAL    93     -17.180  21.874  21.437  1.00 58.17           C  
ATOM    754  O   VAL    93     -17.187  21.457  22.599  1.00 58.56           O  
ATOM    755  CB  VAL    93     -17.239  24.386  21.619  1.00 58.64           C  
ATOM    756  CG1 VAL    93     -15.810  24.448  21.084  1.00 58.11           C  
ATOM    757  CG2 VAL    93     -18.051  25.676  21.270  1.00 55.82           C  
ATOM    758  N   PRO    94     -16.515  21.252  20.444  1.00 58.02           N  
ATOM    759  CA  PRO    94     -15.689  20.114  20.763  1.00 57.04           C  
ATOM    760  C   PRO    94     -14.266  20.415  21.276  1.00 56.72           C  
ATOM    761  O   PRO    94     -13.595  21.314  20.812  1.00 55.21           O  
ATOM    762  CB  PRO    94     -15.623  19.371  19.431  1.00 56.88           C  
ATOM    763  CG  PRO    94     -15.728  20.410  18.407  1.00 56.55           C  
ATOM    764  CD  PRO    94     -16.513  21.540  18.998  1.00 58.06           C  
ATOM    765  N   VAL    95     -13.806  19.590  22.216  1.00 57.49           N  
ATOM    766  CA  VAL    95     -12.400  19.496  22.558  1.00 57.43           C  
ATOM    767  C   VAL    95     -11.897  18.200  21.906  1.00 57.84           C  
ATOM    768  O   VAL    95     -12.341  17.103  22.256  1.00 58.08           O  
ATOM    769  CB  VAL    95     -12.138  19.493  24.114  1.00 57.16           C  
ATOM    770  CG1 VAL    95     -10.658  19.644  24.393  1.00 56.72           C  
ATOM    771  CG2 VAL    95     -12.952  20.582  24.824  1.00 55.41           C  
ATOM    772  N   SER    96     -10.987  18.327  20.944  1.00 58.18           N  
ATOM    773  CA  SER    96     -10.524  17.194  20.222  1.00 57.67           C  
ATOM    774  C   SER    96      -9.576  16.357  21.065  1.00 59.98           C  
ATOM    775  O   SER    96      -9.000  16.821  22.069  1.00 61.04           O  
ATOM    776  CB  SER    96      -9.863  17.634  18.932  1.00 57.68           C  
ATOM    777  OG  SER    96      -8.690  18.397  19.113  1.00 54.88           O  
ATOM    778  N   GLN    97      -9.437  15.100  20.663  1.00 62.13           N  
ATOM    779  CA  GLN    97      -8.498  14.165  21.247  1.00 63.68           C  
ATOM    780  C   GLN    97      -7.093  14.711  21.379  1.00 63.20           C  
ATOM    781  O   GLN    97      -6.396  14.355  22.310  1.00 63.88           O  
ATOM    782  CB  GLN    97      -8.426  12.893  20.401  1.00 63.98           C  
ATOM    783  CG  GLN    97      -7.315  11.913  20.765  1.00 65.68           C  
ATOM    784  CD  GLN    97      -7.566  10.570  20.093  1.00 69.25           C  
ATOM    785  OE1 GLN    97      -7.594   9.510  20.746  1.00 77.40           O  
ATOM    786  NE2 GLN    97      -7.790  10.611  18.775  1.00 77.67           N  
ATOM    787  N   SER    98      -6.677  15.555  20.444  1.00 62.68           N  
ATOM    788  CA  SER    98      -5.321  15.990  20.399  1.00 62.54           C  
ATOM    789  C   SER    98      -5.065  17.182  21.349  1.00 62.49           C  
ATOM    790  O   SER    98      -3.925  17.399  21.797  1.00 63.19           O  
ATOM    791  CB  SER    98      -4.908  16.235  18.949  1.00 62.74           C  
ATOM    792  OG  SER    98      -4.721  17.590  18.659  1.00 66.44           O  
ATOM    793  N   TYR    99      -6.130  17.908  21.684  1.00 61.58           N  
ATOM    794  CA  TYR    99      -6.099  18.982  22.674  1.00 60.92           C  
ATOM    795  C   TYR    99      -6.635  18.599  24.064  1.00 60.08           C  
ATOM    796  O   TYR    99      -6.529  19.379  25.015  1.00 60.11           O  
ATOM    797  CB  TYR    99      -6.913  20.160  22.157  1.00 60.45           C  
ATOM    798  CG  TYR    99      -6.178  20.969  21.133  1.00 61.16           C  
ATOM    799  CD1 TYR    99      -6.142  20.577  19.804  1.00 61.60           C  
ATOM    800  CD2 TYR    99      -5.482  22.103  21.496  1.00 59.09           C  
ATOM    801  CE1 TYR    99      -5.481  21.325  18.881  1.00 61.32           C  
ATOM    802  CE2 TYR    99      -4.860  22.840  20.583  1.00 59.27           C  
ATOM    803  CZ  TYR    99      -4.861  22.464  19.287  1.00 60.11           C  
ATOM    804  OH  TYR    99      -4.169  23.214  18.389  1.00 62.07           O  
ATOM    805  N   ALA   100      -7.203  17.414  24.189  1.00 59.50           N  
ATOM    806  CA  ALA   100      -7.931  17.070  25.399  1.00 59.34           C  
ATOM    807  C   ALA   100      -7.050  17.117  26.668  1.00 59.43           C  
ATOM    808  O   ALA   100      -7.522  17.572  27.707  1.00 58.27           O  
ATOM    809  CB  ALA   100      -8.656  15.714  25.226  1.00 57.93           C  
ATOM    810  N   SER   101      -5.774  16.692  26.594  1.00 60.28           N  
ATOM    811  CA  SER   101      -4.890  16.751  27.798  1.00 60.88           C  
ATOM    812  C   SER   101      -4.494  18.138  28.204  1.00 60.03           C  
ATOM    813  O   SER   101      -4.503  18.456  29.387  1.00 60.35           O  
ATOM    814  CB  SER   101      -3.608  15.932  27.633  1.00 61.76           C  
ATOM    815  OG  SER   101      -3.970  14.573  27.408  1.00 65.08           O  
ATOM    816  N   TYR   102      -4.134  18.944  27.213  1.00 59.68           N  
ATOM    817  CA  TYR   102      -3.797  20.350  27.403  1.00 59.73           C  
ATOM    818  C   TYR   102      -5.014  21.030  27.984  1.00 59.63           C  
ATOM    819  O   TYR   102      -4.918  21.703  28.992  1.00 59.77           O  
ATOM    820  CB  TYR   102      -3.347  20.956  26.057  1.00 60.33           C  
ATOM    821  CG  TYR   102      -3.183  22.451  25.981  1.00 60.01           C  
ATOM    822  CD1 TYR   102      -2.045  23.086  26.447  1.00 60.73           C  
ATOM    823  CD2 TYR   102      -4.178  23.235  25.376  1.00 62.93           C  
ATOM    824  CE1 TYR   102      -1.932  24.485  26.353  1.00 61.97           C  
ATOM    825  CE2 TYR   102      -4.077  24.605  25.265  1.00 60.78           C  
ATOM    826  CZ  TYR   102      -2.961  25.230  25.733  1.00 61.47           C  
ATOM    827  OH  TYR   102      -2.924  26.614  25.611  1.00 61.28           O  
ATOM    828  N   PHE   103      -6.186  20.787  27.401  1.00 58.87           N  
ATOM    829  CA  PHE   103      -7.393  21.423  27.906  1.00 58.44           C  
ATOM    830  C   PHE   103      -7.610  21.102  29.395  1.00 58.43           C  
ATOM    831  O   PHE   103      -7.761  21.995  30.191  1.00 57.76           O  
ATOM    832  CB  PHE   103      -8.614  21.024  27.056  1.00 57.19           C  
ATOM    833  CG  PHE   103      -9.893  21.695  27.462  1.00 57.46           C  
ATOM    834  CD1 PHE   103     -10.193  22.988  27.016  1.00 58.39           C  
ATOM    835  CD2 PHE   103     -10.785  21.066  28.302  1.00 54.61           C  
ATOM    836  CE1 PHE   103     -11.359  23.605  27.359  1.00 54.93           C  
ATOM    837  CE2 PHE   103     -11.956  21.670  28.670  1.00 53.26           C  
ATOM    838  CZ  PHE   103     -12.261  22.937  28.187  1.00 55.72           C  
ATOM    839  N   ARG   104      -7.637  19.834  29.774  1.00 59.22           N  
ATOM    840  CA  ARG   104      -7.950  19.494  31.162  1.00 60.00           C  
ATOM    841  C   ARG   104      -6.859  19.893  32.152  1.00 60.47           C  
ATOM    842  O   ARG   104      -7.148  20.233  33.297  1.00 59.73           O  
ATOM    843  CB  ARG   104      -8.299  18.011  31.298  1.00 59.80           C  
ATOM    844  CG  ARG   104      -7.128  17.081  31.373  1.00 59.77           C  
ATOM    845  CD  ARG   104      -7.547  15.631  31.419  1.00 59.52           C  
ATOM    846  NE  ARG   104      -8.482  15.391  32.508  1.00 59.77           N  
ATOM    847  CZ  ARG   104      -9.353  14.386  32.582  1.00 60.33           C  
ATOM    848  NH1 ARG   104      -9.450  13.478  31.628  1.00 61.97           N  
ATOM    849  NH2 ARG   104     -10.167  14.309  33.614  1.00 62.23           N  
ATOM    850  N   LYS   105      -5.604  19.865  31.698  1.00 62.10           N  
ATOM    851  CA  LYS   105      -4.470  20.312  32.517  1.00 63.34           C  
ATOM    852  C   LYS   105      -4.582  21.811  32.887  1.00 62.97           C  
ATOM    853  O   LYS   105      -4.444  22.184  34.047  1.00 62.68           O  
ATOM    854  CB  LYS   105      -3.128  20.027  31.812  1.00 64.24           C  
ATOM    855  CG  LYS   105      -2.427  18.736  32.260  1.00 66.61           C  
ATOM    856  CD  LYS   105      -1.311  18.291  31.238  1.00 68.13           C  
ATOM    857  CE  LYS   105      -0.252  17.240  31.780  1.00 70.28           C  
ATOM    858  NZ  LYS   105       1.029  17.832  32.420  1.00 70.83           N  
ATOM    859  N   LEU   106      -4.834  22.641  31.883  1.00 62.79           N  
ATOM    860  CA  LEU   106      -4.997  24.068  32.057  1.00 63.04           C  
ATOM    861  C   LEU   106      -6.188  24.423  32.910  1.00 62.22           C  
ATOM    862  O   LEU   106      -6.162  25.437  33.602  1.00 62.09           O  
ATOM    863  CB  LEU   106      -5.076  24.795  30.700  1.00 62.74           C  
ATOM    864  CG  LEU   106      -3.709  25.365  30.317  1.00 64.99           C  
ATOM    865  CD1 LEU   106      -2.561  24.315  30.481  1.00 67.46           C  
ATOM    866  CD2 LEU   106      -3.670  25.949  28.926  1.00 64.48           C  
ATOM    867  N   LEU   107      -7.233  23.619  32.843  1.00 61.85           N  
ATOM    868  CA  LEU   107      -8.463  23.878  33.588  1.00 61.64           C  
ATOM    869  C   LEU   107      -8.471  23.158  34.946  1.00 60.91           C  
ATOM    870  O   LEU   107      -9.338  23.387  35.776  1.00 60.53           O  
ATOM    871  CB  LEU   107      -9.697  23.514  32.736  1.00 61.95           C  
ATOM    872  CG  LEU   107     -10.266  24.672  31.899  1.00 65.01           C  
ATOM    873  CD1 LEU   107      -9.536  24.876  30.576  1.00 66.58           C  
ATOM    874  CD2 LEU   107     -11.706  24.443  31.610  1.00 62.97           C  
ATOM    875  N   GLY   108      -7.511  22.273  35.159  1.00 61.07           N  
ATOM    876  CA  GLY   108      -7.292  21.663  36.452  1.00 61.13           C  
ATOM    877  C   GLY   108      -8.218  20.536  36.869  1.00 61.63           C  
ATOM    878  O   GLY   108      -8.499  20.447  38.068  1.00 62.09           O  
ATOM    879  N   PHE   109      -8.649  19.662  35.931  1.00 60.70           N  
ATOM    880  CA  PHE   109      -9.548  18.522  36.261  1.00 60.08           C  
ATOM    881  C   PHE   109      -9.140  17.140  35.727  1.00 59.62           C  
ATOM    882  O   PHE   109      -8.160  17.063  34.987  1.00 61.02           O  
ATOM    883  CB  PHE   109     -10.971  18.842  35.853  1.00 59.83           C  
ATOM    884  CG  PHE   109     -11.195  18.905  34.371  1.00 58.91           C  
ATOM    885  CD1 PHE   109     -11.609  17.796  33.678  1.00 57.22           C  
ATOM    886  CD2 PHE   109     -11.047  20.087  33.688  1.00 57.96           C  
ATOM    887  CE1 PHE   109     -11.843  17.866  32.347  1.00 59.48           C  
ATOM    888  CE2 PHE   109     -11.274  20.147  32.342  1.00 57.93           C  
ATOM    889  CZ  PHE   109     -11.683  19.047  31.674  1.00 59.32           C  
END
