
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  869),  selected  103 , name 3bs1_A
# Molecule2: number of CA atoms  109 (  889),  selected  109 , name T0415.pdb
# PARAMETERS: 3bs1_A.T0415.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M   136_A      G       1           -
LGA    D   137_A      -       -           -
LGA    N   138_A      -       -           -
LGA    S   139_A      -       -           -
LGA    V   140_A      K       2           #
LGA    E   141_A      S       3          2.506
LGA    T   142_A      V       4          1.531
LGA    I   143_A      V       5          1.702
LGA    E   144_A      T       6          2.347
LGA    L   145_A      L       7          2.771
LGA    K   146_A      -       -           -
LGA    R   147_A      K       8          3.406
LGA    G   148_A      T       9           -
LGA    -       -      T      10           -
LGA    S   149_A      D      11           #
LGA    N   150_A      G      12          4.072
LGA    S   151_A      W      13          2.885
LGA    V   152_A      I      14          1.636
LGA    Y   153_A      P      15          0.738
LGA    V   154_A      V      16          0.538
LGA    Q   155_A      P      17          0.922
LGA    Y   156_A      F      18          0.874
LGA    D   157_A      S      19          1.779
LGA    D   158_A      K      20          1.061
LGA    I   159_A      V      21          1.167
LGA    M   160_A      M      22          0.951
LGA    F   161_A      Y      23          0.467
LGA    F   162_A      L      24          0.538
LGA    E   163_A      E      25          0.538
LGA    S   164_A      A      26          1.159
LGA    S   165_A      K      27          2.291
LGA    T   166_A      D      28          1.992
LGA    K   167_A      -       -           -
LGA    S   168_A      K      29          2.396
LGA    H   169_A      K      30          3.455
LGA    R   170_A      -       -           -
LGA    L   171_A      T      31          1.341
LGA    I   172_A      Y      32          1.281
LGA    A   173_A      V      33          1.404
LGA    H   174_A      N      34          1.496
LGA    L   175_A      A      35          1.660
LGA    D   176_A      E      36          1.643
LGA    N   177_A      E      37          3.379
LGA    R   178_A      L      38          2.198
LGA    Q   179_A      T      39          1.646
LGA    I   180_A      G      40          1.351
LGA    E   181_A      T      41          2.415
LGA    F   182_A      H      42          2.908
LGA    Y   183_A      K      43          2.396
LGA    G   184_A      Y      44          2.199
LGA    N   185_A      S      45          0.477
LGA    L   186_A      L      46          0.438
LGA    K   187_A      Q      47          0.756
LGA    E   188_A      E      48          1.024
LGA    L   189_A      F      49          0.996
LGA    S   190_A      E      50          1.419
LGA    Q   191_A      Y      51          1.371
LGA    L   192_A      L      52          1.510
LGA    D   193_A      L      53          2.740
LGA    D   194_A      P      54          3.461
LGA    -       -      K      55           -
LGA    -       -      D      56           -
LGA    R   195_A      S      57          1.747
LGA    F   196_A      F      58          1.726
LGA    F   197_A      I      59          1.026
LGA    R   198_A      R      60          0.783
LGA    C   199_A      C      61          0.323
LGA    H   200_A      H      62          0.487
LGA    N   201_A      R      63          0.307
LGA    S   202_A      S      64          0.429
LGA    F   203_A      F      65          0.399
LGA    V   204_A      I      66          0.470
LGA    V   205_A      V      67          0.535
LGA    N   206_A      N      68          0.793
LGA    R   207_A      V      69          1.415
LGA    H   208_A      N      70          1.505
LGA    N   209_A      H      71          1.198
LGA    I   210_A      I      72          1.074
LGA    E   211_A      K      73          1.135
LGA    S   212_A      A      74          1.013
LGA    I   213_A      I      75          1.098
LGA    D   214_A      Y      76          1.228
LGA    S   215_A      P      77          2.092
LGA    K   216_A      D      78          3.088
LGA    E   217_A      T      79          3.526
LGA    -       -      H      80           -
LGA    -       -      S      81           -
LGA    -       -      T      82           -
LGA    R   218_A      F      83          1.695
LGA    I   219_A      L      84          1.008
LGA    V   220_A      L      85          1.192
LGA    Y   221_A      S      86          1.433
LGA    F   222_A      M      87          1.171
LGA    K   223_A      D      88          1.133
LGA    N   224_A      N      89          1.064
LGA    K   225_A      G      90          1.137
LGA    E   226_A      E      91          0.867
LGA    H   227_A      R      92          1.032
LGA    C   228_A      V      93          1.076
LGA    Y   229_A      P      94          1.008
LGA    A   230_A      V      95          0.920
LGA    S   231_A      S      96          1.149
LGA    V   232_A      Q      97          0.935
LGA    R   233_A      S      98          2.334
LGA    N   234_A      Y      99          1.430
LGA    V   235_A      A     100          2.217
LGA    K   236_A      S     101          3.410
LGA    K   237_A      Y     102          2.964
LGA    I   238_A      F     103          2.834
LGA    -       -      R     104           -
LGA    -       -      K     105           -
LGA    -       -      L     106           -
LGA    -       -      L     107           -
LGA    -       -      G     108           -
LGA    -       -      F     109           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103  109    5.0     93    1.79    21.51     76.676     4.924

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.477951 * X  +   0.859385 * Y  +  -0.181713 * Z  + -23.661272
  Y_new =   0.521719 * X  +  -0.111310 * Y  +   0.845825 * Z  +  24.986174
  Z_new =   0.706663 * X  +  -0.499066 * Y  +  -0.501559 * Z  +  25.149897 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.358686    0.782907  [ DEG:  -135.1427     44.8573 ]
  Theta =  -0.784770   -2.356822  [ DEG:   -44.9640   -135.0360 ]
  Phi   =   0.829153   -2.312440  [ DEG:    47.5070   -132.4930 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bs1_A                                        
REMARK     2: T0415.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bs1_A.T0415.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103  109   5.0   93   1.79   21.51  76.676
REMARK  ---------------------------------------------------------- 
MOLECULE 3bs1_A
HEADER    TRANSCRIPTION REGULATOR                 21-DEC-07   3BS1              
TITLE     STRUCTURE OF THE STAPHYLOCOCCUS AUREUS AGRA LYTTR DOMAIN              
TITLE    2 BOUND TO DNA REVEALS A BETA FOLD WITH A NOVEL MODE OF                
TITLE    3 BINDING                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACCESSORY GENE REGULATOR PROTEIN A;                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL DOMAIN, RESIDUES 137-238;                       
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: DNA (5'-                                                   
COMPND   8 D(*DTP*DTP*DTP*DAP*DAP*DCP*DAP*DGP*DTP*DTP*DAP*DAP*DGP*(BRU          
COMPND   9 )P*DAP*DT)-3');                                                      
COMPND  10 CHAIN: B;                                                            
COMPND  11 ENGINEERED: YES;                                                     
COMPND  12 MOL_ID: 3;                                                           
COMPND  13 MOLECULE: DNA (5'-D(*DAP*DAP*(BRU)                                   
COMPND  14 P*DAP*DCP*DTP*DTP*DAP*DAP*DCP*DTP*DGP*DTP*DTP*DAP*DA)-3');           
COMPND  15 CHAIN: C;                                                            
COMPND  16 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 STRAIN: DB;                                                          
SOURCE   4 GENE: AGRA, AGR;                                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET9A;                                    
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 SYNTHETIC: YES;                                                      
SOURCE  11 OTHER_DETAILS: THIS SEQUENCE OCCURS NATURALLY IN                     
SOURCE  12 STAPHYLOCOCCUS AUREUS;                                               
SOURCE  13 MOL_ID: 3;                                                           
SOURCE  14 SYNTHETIC: YES;                                                      
SOURCE  15 OTHER_DETAILS: THIS SEQUENCE OCCURS NATURALLY IN                     
SOURCE  16 STAPHYLOCOCCUS AUREUS                                                
KEYWDS    LYTTR, AGRA, RESPONSE REGULATOR, DNA BINDING DOMAIN,                  
KEYWDS   2 ACTIVATOR, CYTOPLASM, DNA-BINDING, PHOSPHOPROTEIN,                   
KEYWDS   3 TRANSCRIPTION, TRANSCRIPTION REGULATION, TWO-COMPONENT               
KEYWDS   4 REGULATORY SYSTEM, TRANSCRIPTION REGULATOR                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.J.SIDOTE,C.BARBIERI,T.WU,A.M.STOCK                                  
REVDAT   2   20-MAY-08 3BS1    1       JRNL                                     
REVDAT   1   08-APR-08 3BS1    0                                                
JRNL        AUTH   D.J.SIDOTE,C.M.BARBIERI,T.WU,A.M.STOCK                       
JRNL        TITL   STRUCTURE OF THE STAPHYLOCOCCUS AUREUS AGRA LYTTR            
JRNL        TITL 2 DOMAIN BOUND TO DNA REVEALS A BETA FOLD WITH AN              
JRNL        TITL 3 UNUSUAL MODE OF BINDING.                                     
JRNL        REF    STRUCTURE                     V.  16   727 2008              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  3BS1 B    1    16  PDB    3BS1     3BS1             1     16             
DBREF  3BS1 C    1    16  PDB    3BS1     3BS1             1     16             
DBREF  3BS1 A  137   238  UNP    P0A0I7   AGRA_STAAU     137    238             
SEQRES   1 A  103  MET ASP ASN SER VAL GLU THR ILE GLU LEU LYS ARG GLY          
SEQRES   2 A  103  SER ASN SER VAL TYR VAL GLN TYR ASP ASP ILE MET PHE          
SEQRES   3 A  103  PHE GLU SER SER THR LYS SER HIS ARG LEU ILE ALA HIS          
SEQRES   4 A  103  LEU ASP ASN ARG GLN ILE GLU PHE TYR GLY ASN LEU LYS          
SEQRES   5 A  103  GLU LEU SER GLN LEU ASP ASP ARG PHE PHE ARG CYS HIS          
SEQRES   6 A  103  ASN SER PHE VAL VAL ASN ARG HIS ASN ILE GLU SER ILE          
SEQRES   7 A  103  ASP SER LYS GLU ARG ILE VAL TYR PHE LYS ASN LYS GLU          
SEQRES   8 A  103  HIS CYS TYR ALA SER VAL ARG ASN VAL LYS LYS ILE              
SEQRES   1 B   16   DT  DT  DT  DA  DA  DC  DA  DG  DT  DT  DA  DA  DG          
SEQRES   2 B   16  BRU  DA  DT                                                  
SEQRES   1 C   16   DA  DA BRU  DA  DC  DT  DT  DA  DA  DC  DT  DG  DT          
SEQRES   2 C   16   DT  DA  DA                                                  
HET    BRU  B  14      20                                                       
HET    BRU  C   3      20                                                       
HET     MG  A   1       1                                                       
HET     MG  A   2       1                                                       
HETNAM     BRU 5-BROMO-2'-DEOXYURIDINE-5'-MONOPHOSPHATE                         
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  BRU    2(C9 H12 BR N2 O8 P)                                         
FORMUL   4   MG    2(MG 2+)                                                     
FORMUL   6  HOH   *223(H2 O)                                                    
CRYST1   47.938   47.938  100.112  90.00  90.00  90.00 P 41          4          
ATOM      1  N   MET A 136     -13.999  54.956  22.180  1.00 29.55           N  
ATOM      2  CA  MET A 136     -13.337  53.654  22.474  1.00 29.57           C  
ATOM      3  C   MET A 136     -13.779  53.117  23.834  1.00 28.92           C  
ATOM      4  O   MET A 136     -13.814  53.857  24.814  1.00 28.81           O  
ATOM      5  CB  MET A 136     -11.817  53.815  22.433  1.00 30.37           C  
ATOM      6  CG  MET A 136     -11.047  52.524  22.171  1.00 32.65           C  
ATOM      7  SD  MET A 136     -11.412  51.750  20.573  1.00 38.83           S  
ATOM      8  CE  MET A 136     -10.773  52.966  19.414  1.00 37.75           C  
ATOM      9  N   ASP A 137     -14.129  51.831  23.884  1.00 28.28           N  
ATOM     10  CA  ASP A 137     -14.469  51.174  25.148  1.00 27.35           C  
ATOM     11  C   ASP A 137     -13.184  50.773  25.867  1.00 26.85           C  
ATOM     12  O   ASP A 137     -12.545  49.780  25.511  1.00 26.92           O  
ATOM     13  CB  ASP A 137     -15.368  49.952  24.898  1.00 27.58           C  
ATOM     14  CG  ASP A 137     -15.695  49.166  26.172  1.00 27.85           C  
ATOM     15  OD1 ASP A 137     -15.295  49.568  27.295  1.00 27.11           O  
ATOM     16  OD2 ASP A 137     -16.370  48.121  26.036  1.00 29.05           O  
ATOM     17  N   ASN A 138     -12.813  51.557  26.878  1.00 25.73           N  
ATOM     18  CA  ASN A 138     -11.580  51.316  27.625  1.00 24.91           C  
ATOM     19  C   ASN A 138     -11.802  50.489  28.896  1.00 23.46           C  
ATOM     20  O   ASN A 138     -10.868  49.850  29.389  1.00 24.44           O  
ATOM     21  CB  ASN A 138     -10.882  52.644  27.972  1.00 25.70           C  
ATOM     22  CG  ASN A 138     -10.404  53.409  26.738  1.00 27.40           C  
ATOM     23  OD1 ASN A 138      -9.602  52.905  25.952  1.00 30.52           O  
ATOM     24  ND2 ASN A 138     -10.880  54.642  26.581  1.00 28.39           N  
ATOM     25  N   SER A 139     -13.028  50.482  29.421  1.00 21.32           N  
ATOM     26  CA  SER A 139     -13.262  49.898  30.741  1.00 19.78           C  
ATOM     27  C   SER A 139     -13.421  48.378  30.725  1.00 18.63           C  
ATOM     28  O   SER A 139     -13.321  47.733  31.771  1.00 18.64           O  
ATOM     29  CB  SER A 139     -14.446  50.559  31.458  1.00 19.64           C  
ATOM     30  OG  SER A 139     -15.639  50.392  30.727  1.00 21.10           O  
ATOM     31  N   VAL A 140     -13.677  47.821  29.544  1.00 17.29           N  
ATOM     32  CA  VAL A 140     -13.842  46.379  29.375  1.00 16.62           C  
ATOM     33  C   VAL A 140     -12.985  45.964  28.179  1.00 16.13           C  
ATOM     34  O   VAL A 140     -12.929  46.677  27.182  1.00 16.05           O  
ATOM     35  CB  VAL A 140     -15.317  45.986  29.156  1.00 16.29           C  
ATOM     36  CG1 VAL A 140     -15.471  44.461  29.026  1.00 16.87           C  
ATOM     37  CG2 VAL A 140     -16.194  46.512  30.308  1.00 16.24           C  
ATOM     38  N   GLU A 141     -12.292  44.840  28.308  1.00 15.54           N  
ATOM     39  CA  GLU A 141     -11.395  44.385  27.244  1.00 15.50           C  
ATOM     40  C   GLU A 141     -12.178  44.067  25.991  1.00 15.57           C  
ATOM     41  O   GLU A 141     -13.238  43.431  26.050  1.00 15.16           O  
ATOM     42  CB  GLU A 141     -10.558  43.195  27.702  1.00 15.78           C  
ATOM     43  CG  GLU A 141      -9.611  43.554  28.836  1.00 17.01           C  
ATOM     44  CD  GLU A 141      -8.638  42.449  29.133  1.00 19.38           C  
ATOM     45  OE1 GLU A 141      -7.669  42.284  28.358  1.00 21.28           O  
ATOM     46  OE2 GLU A 141      -8.843  41.748  30.140  1.00 20.40           O  
ATOM     47  N   THR A 142     -11.659  44.544  24.861  1.00 16.09           N  
ATOM     48  CA  THR A 142     -12.371  44.448  23.590  1.00 16.54           C  
ATOM     49  C   THR A 142     -11.435  44.001  22.478  1.00 16.33           C  
ATOM     50  O   THR A 142     -10.216  44.217  22.535  1.00 16.19           O  
ATOM     51  CB  THR A 142     -12.999  45.793  23.164  1.00 17.06           C  
ATOM     52  OG1 THR A 142     -11.952  46.747  22.935  1.00 20.13           O  
ATOM     53  CG2 THR A 142     -13.982  46.327  24.218  1.00 16.13           C  
ATOM     54  N   ILE A 143     -12.020  43.354  21.481  1.00 15.78           N  
ATOM     55  CA  ILE A 143     -11.304  42.971  20.270  1.00 16.05           C  
ATOM     56  C   ILE A 143     -11.992  43.636  19.085  1.00 16.03           C  
ATOM     57  O   ILE A 143     -13.224  43.697  19.015  1.00 15.42           O  
ATOM     58  CB  ILE A 143     -11.253  41.439  20.088  1.00 16.44           C  
ATOM     59  CG1 ILE A 143     -10.450  41.082  18.839  1.00 16.28           C  
ATOM     60  CG2 ILE A 143     -12.663  40.831  20.026  1.00 15.61           C  
ATOM     61  CD1 ILE A 143     -10.150  39.622  18.700  1.00 19.83           C  
ATOM     62  N   GLU A 144     -11.182  44.152  18.166  1.00 16.92           N  
ATOM     63  CA  GLU A 144     -11.687  44.760  16.949  1.00 18.44           C  
ATOM     64  C   GLU A 144     -11.804  43.672  15.893  1.00 18.26           C  
ATOM     65  O   GLU A 144     -10.806  43.027  15.545  1.00 18.86           O  
ATOM     66  CB  GLU A 144     -10.743  45.872  16.476  1.00 18.17           C  
ATOM     67  CG  GLU A 144     -11.234  46.599  15.230  1.00 20.80           C  
ATOM     68  CD  GLU A 144     -10.258  47.655  14.711  1.00 21.35           C  
ATOM     69  OE1 GLU A 144      -9.164  47.838  15.291  1.00 25.12           O  
ATOM     70  OE2 GLU A 144     -10.606  48.308  13.707  1.00 24.98           O  
ATOM     71  N   LEU A 145     -13.027  43.449  15.420  1.00 18.53           N  
ATOM     72  CA  LEU A 145     -13.289  42.546  14.308  1.00 19.08           C  
ATOM     73  C   LEU A 145     -13.606  43.399  13.079  1.00 20.11           C  
ATOM     74  O   LEU A 145     -14.511  44.244  13.108  1.00 21.24           O  
ATOM     75  CB  LEU A 145     -14.448  41.599  14.641  1.00 18.31           C  
ATOM     76  CG  LEU A 145     -14.317  40.790  15.944  1.00 15.66           C  
ATOM     77  CD1 LEU A 145     -15.537  39.908  16.150  1.00 13.95           C  
ATOM     78  CD2 LEU A 145     -13.027  39.952  16.001  1.00 16.42           C  
ATOM     79  N   LYS A 146     -12.830  43.213  12.019  1.00 22.03           N  
ATOM     80  CA  LYS A 146     -12.913  44.108  10.861  1.00 22.87           C  
ATOM     81  C   LYS A 146     -13.693  43.484   9.711  1.00 23.12           C  
ATOM     82  O   LYS A 146     -13.654  42.279   9.516  1.00 22.95           O  
ATOM     83  CB  LYS A 146     -11.507  44.501  10.379  1.00 23.22           C  
ATOM     84  CG  LYS A 146     -10.658  45.212  11.419  1.00 23.41           C  
ATOM     85  CD  LYS A 146      -9.197  45.307  11.002  1.00 24.38           C  
ATOM     86  CE  LYS A 146      -8.415  46.174  11.971  1.00 26.33           C  
ATOM     87  NZ  LYS A 146      -6.958  46.207  11.645  1.00 27.96           N  
ATOM     88  N   ARG A 147     -14.407  44.306   8.951  1.00 23.48           N  
ATOM     89  CA  ARG A 147     -14.971  43.841   7.684  1.00 24.13           C  
ATOM     90  C   ARG A 147     -14.744  44.940   6.666  1.00 23.37           C  
ATOM     91  O   ARG A 147     -15.393  45.984   6.722  1.00 22.65           O  
ATOM     92  CB  ARG A 147     -16.460  43.498   7.816  1.00 23.98           C  
ATOM     93  CG  ARG A 147     -16.786  42.283   8.700  1.00 26.13           C  
ATOM     94  CD  ARG A 147     -18.258  41.859   8.529  1.00 26.85           C  
ATOM     95  NE  ARG A 147     -18.563  41.590   7.119  1.00 32.61           N  
ATOM     96  CZ  ARG A 147     -18.771  40.380   6.612  1.00 33.85           C  
ATOM     97  NH1 ARG A 147     -18.747  39.308   7.395  1.00 34.88           N  
ATOM     98  NH2 ARG A 147     -19.015  40.244   5.318  1.00 35.03           N  
ATOM     99  N   GLY A 148     -13.803  44.714   5.748  1.00 23.46           N  
ATOM    100  CA  GLY A 148     -13.336  45.784   4.881  1.00 23.94           C  
ATOM    101  C   GLY A 148     -12.935  46.940   5.776  1.00 23.70           C  
ATOM    102  O   GLY A 148     -12.217  46.744   6.760  1.00 23.93           O  
ATOM    103  N   SER A 149     -13.426  48.138   5.471  1.00 23.89           N  
ATOM    104  CA  SER A 149     -13.067  49.322   6.252  1.00 23.98           C  
ATOM    105  C   SER A 149     -13.986  49.542   7.460  1.00 24.21           C  
ATOM    106  O   SER A 149     -13.832  50.526   8.189  1.00 24.29           O  
ATOM    107  CB  SER A 149     -13.041  50.569   5.365  1.00 24.56           C  
ATOM    108  OG  SER A 149     -14.266  50.712   4.669  1.00 23.94           O  
ATOM    109  N   ASN A 150     -14.926  48.620   7.668  1.00 23.87           N  
ATOM    110  CA  ASN A 150     -15.807  48.663   8.837  1.00 24.24           C  
ATOM    111  C   ASN A 150     -15.170  47.915   9.996  1.00 24.44           C  
ATOM    112  O   ASN A 150     -14.453  46.940   9.793  1.00 24.51           O  
ATOM    113  CB  ASN A 150     -17.169  48.034   8.529  1.00 23.64           C  
ATOM    114  CG  ASN A 150     -17.844  48.643   7.316  1.00 23.86           C  
ATOM    115  OD1 ASN A 150     -18.496  47.937   6.539  1.00 24.34           O  
ATOM    116  ND2 ASN A 150     -17.702  49.951   7.147  1.00 22.82           N  
ATOM    117  N   SER A 151     -15.441  48.374  11.209  1.00 24.80           N  
ATOM    118  CA  SER A 151     -14.958  47.684  12.396  1.00 25.37           C  
ATOM    119  C   SER A 151     -16.117  47.499  13.355  1.00 25.10           C  
ATOM    120  O   SER A 151     -17.020  48.333  13.426  1.00 25.54           O  
ATOM    121  CB  SER A 151     -13.848  48.490  13.080  1.00 25.24           C  
ATOM    122  OG  SER A 151     -12.674  48.556  12.277  1.00 27.64           O  
ATOM    123  N   VAL A 152     -16.091  46.394  14.088  1.00 24.80           N  
ATOM    124  CA  VAL A 152     -16.988  46.226  15.219  1.00 24.60           C  
ATOM    125  C   VAL A 152     -16.123  45.804  16.399  1.00 23.73           C  
ATOM    126  O   VAL A 152     -15.310  44.876  16.291  1.00 23.62           O  
ATOM    127  CB  VAL A 152     -18.180  45.254  14.922  1.00 24.86           C  
ATOM    128  CG1 VAL A 152     -17.709  43.854  14.550  1.00 24.95           C  
ATOM    129  CG2 VAL A 152     -19.171  45.221  16.098  1.00 25.95           C  
ATOM    130  N   TYR A 153     -16.254  46.544  17.491  1.00 23.49           N  
ATOM    131  CA  TYR A 153     -15.532  46.242  18.710  1.00 22.88           C  
ATOM    132  C   TYR A 153     -16.420  45.383  19.582  1.00 21.61           C  
ATOM    133  O   TYR A 153     -17.569  45.739  19.870  1.00 22.14           O  
ATOM    134  CB  TYR A 153     -15.113  47.519  19.442  1.00 24.45           C  
ATOM    135  CG  TYR A 153     -13.899  48.195  18.838  1.00 26.03           C  
ATOM    136  CD1 TYR A 153     -14.039  49.119  17.808  1.00 27.89           C  
ATOM    137  CD2 TYR A 153     -12.616  47.915  19.307  1.00 27.44           C  
ATOM    138  CE1 TYR A 153     -12.925  49.746  17.250  1.00 28.48           C  
ATOM    139  CE2 TYR A 153     -11.492  48.532  18.757  1.00 28.93           C  
ATOM    140  CZ  TYR A 153     -11.657  49.444  17.726  1.00 28.11           C  
ATOM    141  OH  TYR A 153     -10.553  50.060  17.175  1.00 29.60           O  
ATOM    142  N   VAL A 154     -15.886  44.237  19.972  1.00 18.67           N  
ATOM    143  CA  VAL A 154     -16.635  43.250  20.732  1.00 17.48           C  
ATOM    144  C   VAL A 154     -15.915  43.021  22.046  1.00 16.18           C  
ATOM    145  O   VAL A 154     -14.715  42.781  22.063  1.00 16.39           O  
ATOM    146  CB  VAL A 154     -16.692  41.914  19.956  1.00 17.12           C  
ATOM    147  CG1 VAL A 154     -17.472  40.875  20.731  1.00 18.69           C  
ATOM    148  CG2 VAL A 154     -17.303  42.139  18.566  1.00 17.99           C  
ATOM    149  N   GLN A 155     -16.653  43.077  23.153  1.00 15.38           N  
ATOM    150  CA  GLN A 155     -16.063  42.748  24.450  1.00 14.91           C  
ATOM    151  C   GLN A 155     -15.671  41.278  24.498  1.00 13.46           C  
ATOM    152  O   GLN A 155     -16.393  40.422  23.994  1.00 13.10           O  
ATOM    153  CB  GLN A 155     -17.040  43.073  25.582  1.00 14.91           C  
ATOM    154  CG  GLN A 155     -17.323  44.559  25.701  1.00 16.26           C  
ATOM    155  CD  GLN A 155     -18.278  44.902  26.836  1.00 17.06           C  
ATOM    156  OE1 GLN A 155     -18.870  44.023  27.468  1.00 19.93           O  
ATOM    157  NE2 GLN A 155     -18.415  46.192  27.103  1.00 19.42           N  
ATOM    158  N   TYR A 156     -14.525  40.991  25.110  1.00 12.79           N  
ATOM    159  CA  TYR A 156     -14.008  39.618  25.163  1.00 11.78           C  
ATOM    160  C   TYR A 156     -15.068  38.614  25.599  1.00 11.67           C  
ATOM    161  O   TYR A 156     -15.247  37.573  24.961  1.00 11.60           O  
ATOM    162  CB  TYR A 156     -12.845  39.531  26.147  1.00 12.39           C  
ATOM    163  CG  TYR A 156     -11.492  39.997  25.645  1.00 12.54           C  
ATOM    164  CD1 TYR A 156     -11.352  40.699  24.442  1.00 13.98           C  
ATOM    165  CD2 TYR A 156     -10.357  39.751  26.401  1.00 13.29           C  
ATOM    166  CE1 TYR A 156     -10.095  41.133  24.004  1.00 14.81           C  
ATOM    167  CE2 TYR A 156      -9.094  40.187  25.983  1.00 14.04           C  
ATOM    168  CZ  TYR A 156      -8.980  40.873  24.778  1.00 14.39           C  
ATOM    169  OH  TYR A 156      -7.742  41.306  24.339  1.00 16.34           O  
ATOM    170  N   ASP A 157     -15.771  38.931  26.690  1.00 11.42           N  
ATOM    171  CA  ASP A 157     -16.710  37.969  27.265  1.00 11.28           C  
ATOM    172  C   ASP A 157     -18.084  37.964  26.592  1.00 11.20           C  
ATOM    173  O   ASP A 157     -18.970  37.204  26.997  1.00 11.29           O  
ATOM    174  CB  ASP A 157     -16.782  38.091  28.798  1.00 11.14           C  
ATOM    175  CG  ASP A 157     -15.531  37.545  29.486  1.00 11.82           C  
ATOM    176  OD1 ASP A 157     -14.637  37.010  28.802  1.00 11.21           O  
ATOM    177  OD2 ASP A 157     -15.445  37.637  30.729  1.00 12.19           O  
ATOM    178  N   ASP A 158     -18.248  38.780  25.548  1.00 11.07           N  
ATOM    179  CA  ASP A 158     -19.373  38.623  24.614  1.00 12.11           C  
ATOM    180  C   ASP A 158     -19.151  37.357  23.789  1.00 11.40           C  
ATOM    181  O   ASP A 158     -20.095  36.821  23.214  1.00 12.33           O  
ATOM    182  CB  ASP A 158     -19.429  39.751  23.570  1.00 13.10           C  
ATOM    183  CG  ASP A 158     -19.873  41.096  24.114  1.00 17.31           C  
ATOM    184  OD1 ASP A 158     -20.482  41.178  25.202  1.00 19.89           O  
ATOM    185  OD2 ASP A 158     -19.619  42.096  23.392  1.00 22.42           O  
ATOM    186  N   ILE A 159     -17.893  36.918  23.693  1.00 11.32           N  
ATOM    187  CA  ILE A 159     -17.513  35.833  22.792  1.00 11.66           C  
ATOM    188  C   ILE A 159     -17.478  34.483  23.497  1.00 10.83           C  
ATOM    189  O   ILE A 159     -16.778  34.307  24.495  1.00 11.46           O  
ATOM    190  CB  ILE A 159     -16.145  36.125  22.111  1.00 11.61           C  
ATOM    191  CG1 ILE A 159     -16.235  37.462  21.374  1.00 12.87           C  
ATOM    192  CG2 ILE A 159     -15.763  34.990  21.145  1.00 12.28           C  
ATOM    193  CD1 ILE A 159     -14.910  38.035  20.890  1.00 14.13           C  
ATOM    194  N   MET A 160     -18.229  33.531  22.953  1.00 10.14           N  
ATOM    195  CA  MET A 160     -18.232  32.165  23.482  1.00 10.33           C  
ATOM    196  C   MET A 160     -17.000  31.433  22.968  1.00 10.61           C  
ATOM    197  O   MET A 160     -16.196  30.920  23.746  1.00 10.16           O  
ATOM    198  CB  MET A 160     -19.498  31.387  23.065  1.00 11.06           C  
ATOM    199  CG  MET A 160     -20.828  32.057  23.379  1.00 11.34           C  
ATOM    200  SD  MET A 160     -21.127  32.308  25.154  1.00 12.67           S  
ATOM    201  CE  MET A 160     -21.097  34.079  25.259  1.00 14.61           C  
ATOM    202  N   PHE A 161     -16.850  31.412  21.645  1.00 10.26           N  
ATOM    203  CA  PHE A 161     -15.698  30.771  21.004  1.00 10.03           C  
ATOM    204  C   PHE A 161     -15.526  31.306  19.597  1.00 10.45           C  
ATOM    205  O   PHE A 161     -16.419  31.965  19.075  1.00  9.92           O  
ATOM    206  CB  PHE A 161     -15.848  29.250  20.986  1.00 10.26           C  
ATOM    207  CG  PHE A 161     -17.004  28.746  20.152  1.00 10.88           C  
ATOM    208  CD1 PHE A 161     -18.283  28.650  20.692  1.00 12.44           C  
ATOM    209  CD2 PHE A 161     -16.802  28.316  18.839  1.00 11.82           C  
ATOM    210  CE1 PHE A 161     -19.349  28.154  19.930  1.00 12.17           C  
ATOM    211  CE2 PHE A 161     -17.862  27.815  18.070  1.00 11.61           C  
ATOM    212  CZ  PHE A 161     -19.131  27.734  18.620  1.00 11.65           C  
ATOM    213  N   PHE A 162     -14.357  31.044  19.015  1.00 10.30           N  
ATOM    214  CA  PHE A 162     -14.091  31.334  17.615  1.00 11.14           C  
ATOM    215  C   PHE A 162     -13.928  29.988  16.924  1.00 10.94           C  
ATOM    216  O   PHE A 162     -13.391  29.041  17.514  1.00 10.21           O  
ATOM    217  CB  PHE A 162     -12.764  32.072  17.444  1.00 11.04           C  
ATOM    218  CG  PHE A 162     -12.669  33.380  18.165  1.00 11.43           C  
ATOM    219  CD1 PHE A 162     -13.089  34.558  17.547  1.00 11.33           C  
ATOM    220  CD2 PHE A 162     -12.083  33.447  19.428  1.00 12.24           C  
ATOM    221  CE1 PHE A 162     -12.977  35.781  18.186  1.00 10.85           C  
ATOM    222  CE2 PHE A 162     -11.955  34.682  20.089  1.00 11.86           C  
ATOM    223  CZ  PHE A 162     -12.393  35.846  19.465  1.00 11.72           C  
ATOM    224  N   GLU A 163     -14.375  29.904  15.672  1.00 11.47           N  
ATOM    225  CA  GLU A 163     -14.136  28.703  14.871  1.00 12.26           C  
ATOM    226  C   GLU A 163     -13.688  29.117  13.488  1.00 12.20           C  
ATOM    227  O   GLU A 163     -13.994  30.217  13.023  1.00 12.63           O  
ATOM    228  CB  GLU A 163     -15.402  27.854  14.736  1.00 12.89           C  
ATOM    229  CG  GLU A 163     -16.500  28.545  13.991  1.00 16.37           C  
ATOM    230  CD  GLU A 163     -17.694  27.649  13.683  1.00 20.69           C  
ATOM    231  OE1 GLU A 163     -17.583  26.401  13.836  1.00 21.29           O  
ATOM    232  OE2 GLU A 163     -18.731  28.223  13.260  1.00 22.60           O  
ATOM    233  N   SER A 164     -12.980  28.225  12.811  1.00 12.51           N  
ATOM    234  CA  SER A 164     -12.673  28.437  11.407  0.50 12.72           C  
ATOM    236  C   SER A 164     -13.964  28.470  10.581  1.00 13.37           C  
ATOM    237  O   SER A 164     -14.893  27.690  10.814  1.00 13.44           O  
ATOM    238  CB  SER A 164     -11.731  27.342  10.910  0.50 12.54           C  
ATOM    240  OG  SER A 164     -12.287  26.068  11.149  0.50 11.04           O  
ATOM    242  N   SER A 165     -14.022  29.404   9.635  1.00 14.03           N  
ATOM    243  CA  SER A 165     -15.136  29.493   8.707  1.00 14.95           C  
ATOM    244  C   SER A 165     -14.972  28.472   7.584  1.00 15.88           C  
ATOM    245  O   SER A 165     -13.873  27.962   7.355  1.00 16.72           O  
ATOM    246  CB  SER A 165     -15.181  30.894   8.100  1.00 14.94           C  
ATOM    247  OG  SER A 165     -16.255  31.018   7.184  1.00 15.75           O  
ATOM    248  N   THR A 166     -16.068  28.175   6.888  1.00 16.95           N  
ATOM    249  CA  THR A 166     -15.969  27.405   5.648  1.00 18.05           C  
ATOM    250  C   THR A 166     -15.312  28.274   4.572  1.00 18.35           C  
ATOM    251  O   THR A 166     -14.787  27.754   3.580  1.00 18.99           O  
ATOM    252  CB  THR A 166     -17.344  26.883   5.156  1.00 18.42           C  
ATOM    253  OG1 THR A 166     -18.242  27.975   4.970  1.00 20.38           O  
ATOM    254  CG2 THR A 166     -17.946  25.892   6.160  1.00 19.27           C  
ATOM    255  N   LYS A 167     -15.338  29.590   4.779  1.00 17.52           N  
ATOM    256  CA  LYS A 167     -14.689  30.544   3.873  1.00 17.53           C  
ATOM    257  C   LYS A 167     -13.205  30.695   4.219  1.00 17.11           C  
ATOM    258  O   LYS A 167     -12.840  31.026   5.355  1.00 16.54           O  
ATOM    259  CB  LYS A 167     -15.385  31.911   3.908  1.00 17.58           C  
ATOM    260  CG  LYS A 167     -16.888  31.892   3.608  1.00 18.90           C  
ATOM    261  CD  LYS A 167     -17.438  33.311   3.553  1.00 18.89           C  
ATOM    262  CE  LYS A 167     -18.922  33.350   3.238  1.00 21.33           C  
ATOM    263  NZ  LYS A 167     -19.781  32.983   4.392  1.00 24.36           N  
ATOM    264  N   SER A 168     -12.352  30.460   3.224  1.00 16.84           N  
ATOM    265  CA  SER A 168     -10.899  30.445   3.414  1.00 16.49           C  
ATOM    266  C   SER A 168     -10.370  31.698   4.124  1.00 15.43           C  
ATOM    267  O   SER A 168     -10.747  32.823   3.779  1.00 14.92           O  
ATOM    268  CB  SER A 168     -10.210  30.268   2.057  1.00 16.95           C  
ATOM    269  OG  SER A 168      -8.799  30.253   2.190  1.00 19.08           O  
ATOM    270  N   HIS A 169      -9.519  31.486   5.131  1.00 15.15           N  
ATOM    271  CA  HIS A 169      -8.854  32.559   5.876  1.00 14.40           C  
ATOM    272  C   HIS A 169      -9.763  33.412   6.776  1.00 13.67           C  
ATOM    273  O   HIS A 169      -9.332  34.429   7.326  1.00 13.98           O  
ATOM    274  CB  HIS A 169      -8.031  33.441   4.939  1.00 14.92           C  
ATOM    275  CG  HIS A 169      -6.827  32.745   4.399  1.00 16.87           C  
ATOM    276  ND1 HIS A 169      -5.571  32.899   4.942  1.00 21.45           N  
ATOM    277  CD2 HIS A 169      -6.696  31.853   3.391  1.00 19.06           C  
ATOM    278  CE1 HIS A 169      -4.715  32.146   4.274  1.00 18.84           C  
ATOM    279  NE2 HIS A 169      -5.371  31.509   3.325  1.00 21.21           N  
ATOM    280  N   ARG A 170     -11.009  32.972   6.911  1.00 12.86           N  
ATOM    281  CA  ARG A 170     -11.951  33.647   7.795  1.00 12.17           C  
ATOM    282  C   ARG A 170     -12.323  32.790   8.996  1.00 12.18           C  
ATOM    283  O   ARG A 170     -12.211  31.548   8.985  1.00 12.46           O  
ATOM    284  CB  ARG A 170     -13.195  34.089   7.021  1.00 12.42           C  
ATOM    285  CG  ARG A 170     -12.993  35.384   6.226  1.00 12.05           C  
ATOM    286  CD  ARG A 170     -13.749  35.351   4.896  1.00 13.25           C  
ATOM    287  NE  ARG A 170     -13.078  34.516   3.901  1.00 15.28           N  
ATOM    288  CZ  ARG A 170     -13.439  34.428   2.619  1.00 16.09           C  
ATOM    289  NH1 ARG A 170     -14.469  35.131   2.157  1.00 17.42           N  
ATOM    290  NH2 ARG A 170     -12.776  33.618   1.803  1.00 17.15           N  
ATOM    291  N   LEU A 171     -12.754  33.483  10.043  1.00 11.70           N  
ATOM    292  CA  LEU A 171     -13.170  32.852  11.282  1.00 11.44           C  
ATOM    293  C   LEU A 171     -14.560  33.336  11.600  1.00 11.32           C  
ATOM    294  O   LEU A 171     -14.996  34.342  11.067  1.00 11.47           O  
ATOM    295  CB  LEU A 171     -12.250  33.268  12.417  1.00 11.09           C  
ATOM    296  CG  LEU A 171     -10.759  32.990  12.232  1.00 11.17           C  
ATOM    297  CD1 LEU A 171     -10.022  33.598  13.414  1.00 11.64           C  
ATOM    298  CD2 LEU A 171     -10.514  31.499  12.114  1.00 13.84           C  
ATOM    299  N   ILE A 172     -15.242  32.616  12.475  1.00 11.07           N  
ATOM    300  CA  ILE A 172     -16.545  33.070  12.968  1.00 11.83           C  
ATOM    301  C   ILE A 172     -16.441  33.217  14.480  1.00 11.19           C  
ATOM    302  O   ILE A 172     -16.158  32.236  15.177  1.00 11.07           O  
ATOM    303  CB  ILE A 172     -17.678  32.070  12.631  1.00 11.67           C  
ATOM    304  CG1 ILE A 172     -17.709  31.737  11.131  1.00 13.96           C  
ATOM    305  CG2 ILE A 172     -19.023  32.601  13.136  1.00 11.64           C  
ATOM    306  CD1 ILE A 172     -18.697  30.660  10.770  1.00 15.58           C  
ATOM    307  N   ALA A 173     -16.696  34.433  14.976  1.00 11.45           N  
ATOM    308  CA  ALA A 173     -16.814  34.674  16.412  1.00 11.34           C  
ATOM    309  C   ALA A 173     -18.255  34.404  16.807  1.00 11.56           C  
ATOM    310  O   ALA A 173     -19.172  35.002  16.243  1.00 12.18           O  
ATOM    311  CB  ALA A 173     -16.430  36.098  16.751  1.00 11.41           C  
ATOM    312  N   HIS A 174     -18.444  33.471  17.737  1.00 11.44           N  
ATOM    313  CA  HIS A 174     -19.768  33.128  18.244  1.00 11.48           C  
ATOM    314  C   HIS A 174     -20.005  33.915  19.526  1.00 12.05           C  
ATOM    315  O   HIS A 174     -19.394  33.630  20.553  1.00 12.05           O  
ATOM    316  CB  HIS A 174     -19.870  31.616  18.485  1.00 11.90           C  
ATOM    317  CG  HIS A 174     -19.934  30.807  17.226  1.00 13.49           C  
ATOM    318  ND1 HIS A 174     -21.073  30.138  16.829  1.00 14.85           N  
ATOM    319  CD2 HIS A 174     -18.996  30.547  16.283  1.00 12.39           C  
ATOM    320  CE1 HIS A 174     -20.831  29.490  15.701  1.00 14.98           C  
ATOM    321  NE2 HIS A 174     -19.585  29.738  15.339  1.00 13.39           N  
ATOM    322  N   LEU A 175     -20.859  34.932  19.430  1.00 12.51           N  
ATOM    323  CA  LEU A 175     -21.196  35.797  20.554  1.00 13.95           C  
ATOM    324  C   LEU A 175     -22.455  35.282  21.233  1.00 14.30           C  
ATOM    325  O   LEU A 175     -23.025  34.282  20.812  1.00 14.14           O  
ATOM    326  CB  LEU A 175     -21.401  37.238  20.075  1.00 14.34           C  
ATOM    327  CG  LEU A 175     -20.183  38.144  19.835  1.00 15.54           C  
ATOM    328  CD1 LEU A 175     -19.234  37.615  18.770  1.00 17.15           C  
ATOM    329  CD2 LEU A 175     -20.629  39.560  19.464  1.00 15.39           C  
ATOM    330  N   ASP A 176     -22.887  35.976  22.288  1.00 15.19           N  
ATOM    331  CA  ASP A 176     -24.099  35.582  23.012  1.00 17.23           C  
ATOM    332  C   ASP A 176     -25.236  35.157  22.077  1.00 17.35           C  
ATOM    333  O   ASP A 176     -25.756  34.042  22.185  1.00 18.08           O  
ATOM    334  CB  ASP A 176     -24.579  36.730  23.912  1.00 17.48           C  
ATOM    335  CG  ASP A 176     -23.524  37.169  24.914  1.00 19.06           C  
ATOM    336  OD1 ASP A 176     -23.360  36.469  25.926  1.00 20.86           O  
ATOM    337  OD2 ASP A 176     -22.879  38.218  24.701  1.00 22.52           O  
ATOM    338  N   ASN A 177     -25.602  36.057  21.159  1.00 18.28           N  
ATOM    339  CA  ASN A 177     -26.755  35.875  20.271  1.00 18.90           C  
ATOM    340  C   ASN A 177     -26.472  36.350  18.855  1.00 18.81           C  
ATOM    341  O   ASN A 177     -27.398  36.696  18.113  1.00 19.46           O  
ATOM    342  CB  ASN A 177     -27.965  36.663  20.799  1.00 19.62           C  
ATOM    343  CG  ASN A 177     -28.357  36.264  22.199  1.00 23.13           C  
ATOM    344  OD1 ASN A 177     -28.671  35.102  22.463  1.00 27.76           O  
ATOM    345  ND2 ASN A 177     -28.342  37.231  23.111  1.00 26.90           N  
ATOM    346  N   ARG A 178     -25.196  36.388  18.481  1.00 16.91           N  
ATOM    347  CA  ARG A 178     -24.794  36.864  17.150  1.00 16.63           C  
ATOM    348  C   ARG A 178     -23.539  36.116  16.734  1.00 16.01           C  
ATOM    349  O   ARG A 178     -22.773  35.666  17.584  1.00 15.26           O  
ATOM    350  CB  ARG A 178     -24.446  38.355  17.161  1.00 16.45           C  
ATOM    351  CG  ARG A 178     -25.434  39.319  17.802  1.00 19.63           C  
ATOM    352  CD  ARG A 178     -26.522  39.780  16.863  1.00 21.29           C  
ATOM    353  NE  ARG A 178     -27.285  40.879  17.461  1.00 23.85           N  
ATOM    354  CZ  ARG A 178     -28.372  40.721  18.211  1.00 25.46           C  
ATOM    355  NH1 ARG A 178     -28.847  39.506  18.472  1.00 26.12           N  
ATOM    356  NH2 ARG A 178     -28.989  41.788  18.706  1.00 26.14           N  
ATOM    357  N   GLN A 179     -23.324  36.010  15.426  1.00 14.88           N  
ATOM    358  CA  GLN A 179     -22.061  35.515  14.897  1.00 15.21           C  
ATOM    359  C   GLN A 179     -21.443  36.541  13.969  1.00 14.10           C  
ATOM    360  O   GLN A 179     -22.147  37.202  13.197  1.00 14.04           O  
ATOM    361  CB  GLN A 179     -22.268  34.192  14.171  1.00 15.38           C  
ATOM    362  CG  GLN A 179     -22.614  33.050  15.122  1.00 17.73           C  
ATOM    363  CD  GLN A 179     -22.925  31.738  14.430  1.00 21.55           C  
ATOM    364  OE1 GLN A 179     -23.533  30.843  15.033  1.00 27.02           O  
ATOM    365  NE2 GLN A 179     -22.517  31.606  13.171  1.00 25.08           N  
ATOM    366  N   ILE A 180     -20.123  36.674  14.034  1.00 13.11           N  
ATOM    367  CA  ILE A 180     -19.431  37.654  13.221  1.00 12.95           C  
ATOM    368  C   ILE A 180     -18.311  36.949  12.473  1.00 13.05           C  
ATOM    369  O   ILE A 180     -17.478  36.285  13.078  1.00 12.17           O  
ATOM    370  CB  ILE A 180     -18.844  38.781  14.088  1.00 13.04           C  
ATOM    371  CG1 ILE A 180     -19.970  39.521  14.831  1.00 13.57           C  
ATOM    372  CG2 ILE A 180     -17.974  39.747  13.246  1.00 13.03           C  
ATOM    373  CD1 ILE A 180     -19.475  40.541  15.850  1.00 14.03           C  
ATOM    374  N   GLU A 181     -18.324  37.092  11.153  1.00 13.34           N  
ATOM    375  CA  GLU A 181     -17.314  36.478  10.306  1.00 13.69           C  
ATOM    376  C   GLU A 181     -16.279  37.530   9.928  1.00 13.42           C  
ATOM    377  O   GLU A 181     -16.620  38.648   9.513  1.00 14.01           O  
ATOM    378  CB  GLU A 181     -17.981  35.881   9.066  1.00 14.23           C  
ATOM    379  CG  GLU A 181     -17.043  35.063   8.185  1.00 15.49           C  
ATOM    380  CD  GLU A 181     -17.783  34.409   7.047  1.00 19.55           C  
ATOM    381  OE1 GLU A 181     -18.458  35.145   6.289  1.00 21.97           O  
ATOM    382  OE2 GLU A 181     -17.693  33.171   6.902  1.00 20.73           O  
ATOM    383  N   PHE A 182     -15.008  37.169  10.053  1.00 12.81           N  
ATOM    384  CA  PHE A 182     -13.933  38.131   9.854  1.00 12.21           C  
ATOM    385  C   PHE A 182     -12.653  37.420   9.430  1.00 12.22           C  
ATOM    386  O   PHE A 182     -12.521  36.219   9.624  1.00 12.04           O  
ATOM    387  CB  PHE A 182     -13.705  38.941  11.140  1.00 12.53           C  
ATOM    388  CG  PHE A 182     -13.191  38.119  12.304  1.00 11.90           C  
ATOM    389  CD1 PHE A 182     -14.060  37.318  13.051  1.00 11.95           C  
ATOM    390  CD2 PHE A 182     -11.846  38.141  12.652  1.00 12.97           C  
ATOM    391  CE1 PHE A 182     -13.594  36.551  14.120  1.00 11.61           C  
ATOM    392  CE2 PHE A 182     -11.381  37.380  13.723  1.00 11.46           C  
ATOM    393  CZ  PHE A 182     -12.247  36.587  14.449  1.00 12.48           C  
ATOM    394  N   TYR A 183     -11.723  38.178   8.848  1.00 12.75           N  
ATOM    395  CA  TYR A 183     -10.402  37.648   8.548  1.00 13.49           C  
ATOM    396  C   TYR A 183      -9.509  37.660   9.784  1.00 13.85           C  
ATOM    397  O   TYR A 183      -9.312  38.693  10.425  1.00 14.90           O  
ATOM    398  CB  TYR A 183      -9.744  38.466   7.436  1.00 13.61           C  
ATOM    399  CG  TYR A 183     -10.345  38.245   6.076  1.00 13.29           C  
ATOM    400  CD1 TYR A 183      -9.852  37.261   5.228  1.00 13.80           C  
ATOM    401  CD2 TYR A 183     -11.420  39.016   5.636  1.00 15.48           C  
ATOM    402  CE1 TYR A 183     -10.413  37.048   3.963  1.00 13.30           C  
ATOM    403  CE2 TYR A 183     -11.982  38.814   4.368  1.00 14.24           C  
ATOM    404  CZ  TYR A 183     -11.464  37.840   3.542  1.00 14.34           C  
ATOM    405  OH  TYR A 183     -12.032  37.624   2.311  1.00 14.43           O  
ATOM    406  N   GLY A 184      -8.969  36.493  10.109  1.00 14.77           N  
ATOM    407  CA  GLY A 184      -8.043  36.371  11.235  1.00 14.54           C  
ATOM    408  C   GLY A 184      -7.539  34.953  11.340  1.00 14.70           C  
ATOM    409  O   GLY A 184      -7.876  34.099  10.512  1.00 15.71           O  
ATOM    410  N   ASN A 185      -6.701  34.711  12.342  1.00 14.77           N  
ATOM    411  CA  ASN A 185      -6.192  33.375  12.569  1.00 14.20           C  
ATOM    412  C   ASN A 185      -6.319  32.990  14.037  1.00 12.93           C  
ATOM    413  O   ASN A 185      -6.161  33.821  14.937  1.00 13.05           O  
ATOM    414  CB  ASN A 185      -4.756  33.204  12.039  1.00 15.26           C  
ATOM    415  CG  ASN A 185      -3.742  34.032  12.800  1.00 15.99           C  
ATOM    416  OD1 ASN A 185      -3.124  33.561  13.762  1.00 18.64           O  
ATOM    417  ND2 ASN A 185      -3.573  35.290  12.384  1.00 19.93           N  
ATOM    418  N   LEU A 186      -6.605  31.714  14.261  1.00 12.57           N  
ATOM    419  CA  LEU A 186      -6.859  31.195  15.594  1.00 12.60           C  
ATOM    420  C   LEU A 186      -5.643  31.296  16.498  1.00 13.09           C  
ATOM    421  O   LEU A 186      -5.778  31.554  17.693  1.00 12.38           O  
ATOM    422  CB  LEU A 186      -7.341  29.749  15.510  1.00 12.59           C  
ATOM    423  CG  LEU A 186      -8.682  29.541  14.796  1.00 11.65           C  
ATOM    424  CD1 LEU A 186      -8.882  28.068  14.557  1.00 13.04           C  
ATOM    425  CD2 LEU A 186      -9.844  30.106  15.627  1.00  9.80           C  
ATOM    426  N   LYS A 187      -4.453  31.094  15.932  1.00 13.46           N  
ATOM    427  CA  LYS A 187      -3.231  31.215  16.725  1.00 14.94           C  
ATOM    428  C   LYS A 187      -3.101  32.584  17.394  1.00 14.95           C  
ATOM    429  O   LYS A 187      -2.861  32.665  18.603  1.00 16.19           O  
ATOM    430  CB  LYS A 187      -1.987  30.924  15.874  1.00 15.02           C  
ATOM    431  CG  LYS A 187      -0.664  31.094  16.622  1.00 18.41           C  
ATOM    432  CD  LYS A 187      -0.453  30.033  17.697  1.00 24.01           C  
ATOM    433  CE  LYS A 187       0.929  30.174  18.330  1.00 27.60           C  
ATOM    434  NZ  LYS A 187       0.982  29.681  19.739  1.00 30.67           N  
ATOM    435  N   GLU A 188      -3.276  33.645  16.614  1.00 15.27           N  
ATOM    436  CA  GLU A 188      -3.175  35.007  17.128  1.00 15.51           C  
ATOM    437  C   GLU A 188      -4.200  35.254  18.246  1.00 15.68           C  
ATOM    438  O   GLU A 188      -3.894  35.887  19.243  1.00 15.89           O  
ATOM    439  CB  GLU A 188      -3.338  36.036  15.998  1.00 16.47           C  
ATOM    440  CG  GLU A 188      -3.145  37.500  16.424  1.00 18.83           C  
ATOM    441  CD  GLU A 188      -4.415  38.161  17.002  1.00 21.31           C  
ATOM    442  OE1 GLU A 188      -5.541  37.746  16.652  1.00 22.88           O  
ATOM    443  OE2 GLU A 188      -4.277  39.119  17.793  1.00 24.58           O  
ATOM    444  N   LEU A 189      -5.413  34.742  18.068  1.00 15.02           N  
ATOM    445  CA  LEU A 189      -6.459  34.957  19.054  1.00 15.11           C  
ATOM    446  C   LEU A 189      -6.114  34.263  20.363  1.00 15.27           C  
ATOM    447  O   LEU A 189      -6.333  34.821  21.439  1.00 15.56           O  
ATOM    448  CB  LEU A 189      -7.802  34.466  18.517  1.00 14.58           C  
ATOM    449  CG  LEU A 189      -8.351  35.267  17.338  1.00 14.58           C  
ATOM    450  CD1 LEU A 189      -9.587  34.565  16.796  1.00 15.03           C  
ATOM    451  CD2 LEU A 189      -8.690  36.701  17.718  1.00 15.93           C  
ATOM    452  N   SER A 190      -5.570  33.050  20.268  1.00 15.66           N  
ATOM    453  CA  SER A 190      -5.174  32.307  21.463  1.00 16.33           C  
ATOM    454  C   SER A 190      -4.052  33.043  22.217  1.00 17.08           C  
ATOM    455  O   SER A 190      -3.964  32.950  23.432  1.00 17.92           O  
ATOM    456  CB  SER A 190      -4.768  30.867  21.120  1.00 16.50           C  
ATOM    457  OG  SER A 190      -3.537  30.838  20.429  1.00 16.79           O  
ATOM    458  N   GLN A 191      -3.222  33.786  21.486  1.00 17.83           N  
ATOM    459  CA  GLN A 191      -2.122  34.544  22.097  1.00 18.49           C  
ATOM    460  C   GLN A 191      -2.567  35.840  22.758  1.00 18.63           C  
ATOM    461  O   GLN A 191      -1.805  36.439  23.525  1.00 18.86           O  
ATOM    462  CB  GLN A 191      -1.047  34.855  21.054  1.00 18.61           C  
ATOM    463  CG  GLN A 191      -0.326  33.618  20.593  1.00 20.67           C  
ATOM    464  CD  GLN A 191       0.570  33.860  19.402  1.00 23.45           C  
ATOM    465  OE1 GLN A 191       0.367  34.796  18.622  1.00 26.30           O  
ATOM    466  NE2 GLN A 191       1.568  33.006  19.245  1.00 27.15           N  
ATOM    467  N   LEU A 192      -3.788  36.279  22.456  1.00 18.37           N  
ATOM    468  CA  LEU A 192      -4.316  37.541  22.969  1.00 18.60           C  
ATOM    469  C   LEU A 192      -4.504  37.597  24.480  1.00 18.44           C  
ATOM    470  O   LEU A 192      -4.269  38.636  25.099  1.00 18.98           O  
ATOM    471  CB  LEU A 192      -5.661  37.868  22.306  1.00 19.08           C  
ATOM    472  CG  LEU A 192      -5.791  38.917  21.218  1.00 20.68           C  
ATOM    473  CD1 LEU A 192      -7.264  39.003  20.821  1.00 20.09           C  
ATOM    474  CD2 LEU A 192      -5.278  40.276  21.711  1.00 20.34           C  
ATOM    475  N   ASP A 193      -4.950  36.491  25.072  1.00 17.23           N  
ATOM    476  CA  ASP A 193      -5.371  36.488  26.457  1.00 17.22           C  
ATOM    477  C   ASP A 193      -5.406  35.057  26.942  1.00 16.85           C  
ATOM    478  O   ASP A 193      -5.745  34.153  26.169  1.00 15.54           O  
ATOM    479  CB  ASP A 193      -6.760  37.113  26.587  1.00 17.58           C  
ATOM    480  CG  ASP A 193      -7.115  37.454  28.020  1.00 19.11           C  
ATOM    481  OD1 ASP A 193      -7.560  36.561  28.765  1.00 18.93           O  
ATOM    482  OD2 ASP A 193      -6.937  38.636  28.408  1.00 22.60           O  
ATOM    483  N   ASP A 194      -5.063  34.855  28.211  1.00 16.74           N  
ATOM    484  CA  ASP A 194      -5.095  33.532  28.817  1.00 17.07           C  
ATOM    485  C   ASP A 194      -6.461  32.860  28.709  1.00 15.69           C  
ATOM    486  O   ASP A 194      -6.541  31.634  28.682  1.00 16.06           O  
ATOM    487  CB  ASP A 194      -4.665  33.595  30.288  1.00 17.91           C  
ATOM    488  CG  ASP A 194      -3.181  33.877  30.455  1.00 22.13           C  
ATOM    489  OD1 ASP A 194      -2.423  33.795  29.455  1.00 24.93           O  
ATOM    490  OD2 ASP A 194      -2.776  34.182  31.602  1.00 26.98           O  
ATOM    491  N   ARG A 195      -7.534  33.652  28.637  1.00 14.33           N  
ATOM    492  CA  ARG A 195      -8.877  33.061  28.614  1.00 13.32           C  
ATOM    493  C   ARG A 195      -9.198  32.421  27.272  1.00 12.79           C  
ATOM    494  O   ARG A 195     -10.103  31.580  27.205  1.00 12.61           O  
ATOM    495  CB  ARG A 195      -9.969  34.068  29.009  1.00 13.10           C  
ATOM    496  CG  ARG A 195     -10.389  35.007  27.890  1.00 12.89           C  
ATOM    497  CD  ARG A 195     -11.301  36.108  28.384  1.00 12.93           C  
ATOM    498  NE  ARG A 195     -10.531  37.116  29.112  1.00 14.03           N  
ATOM    499  CZ  ARG A 195     -11.054  38.221  29.633  1.00 13.47           C  
ATOM    500  NH1 ARG A 195     -12.356  38.457  29.532  1.00 12.71           N  
ATOM    501  NH2 ARG A 195     -10.276  39.088  30.270  1.00 14.55           N  
ATOM    502  N   PHE A 196      -8.485  32.833  26.219  1.00 12.44           N  
ATOM    503  CA  PHE A 196      -8.722  32.303  24.880  1.00 11.86           C  
ATOM    504  C   PHE A 196      -7.802  31.113  24.661  1.00 12.26           C  
ATOM    505  O   PHE A 196      -6.582  31.285  24.545  1.00 13.33           O  
ATOM    506  CB  PHE A 196      -8.488  33.371  23.814  1.00 12.25           C  
ATOM    507  CG  PHE A 196      -9.484  34.499  23.861  1.00 11.37           C  
ATOM    508  CD1 PHE A 196     -10.854  34.239  23.834  1.00 11.42           C  
ATOM    509  CD2 PHE A 196      -9.054  35.820  23.914  1.00 15.09           C  
ATOM    510  CE1 PHE A 196     -11.787  35.272  23.861  1.00 11.00           C  
ATOM    511  CE2 PHE A 196      -9.979  36.855  23.953  1.00 14.54           C  
ATOM    512  CZ  PHE A 196     -11.344  36.579  23.929  1.00 12.36           C  
ATOM    513  N   PHE A 197      -8.387  29.917  24.650  1.00 11.46           N  
ATOM    514  CA  PHE A 197      -7.621  28.673  24.645  1.00 11.35           C  
ATOM    515  C   PHE A 197      -7.908  27.838  23.399  1.00 11.20           C  
ATOM    516  O   PHE A 197      -9.068  27.591  23.051  1.00 10.48           O  
ATOM    517  CB  PHE A 197      -7.905  27.848  25.910  1.00 11.58           C  
ATOM    518  CG  PHE A 197      -7.234  26.510  25.915  1.00 12.24           C  
ATOM    519  CD1 PHE A 197      -5.853  26.420  26.072  1.00 15.18           C  
ATOM    520  CD2 PHE A 197      -7.967  25.340  25.745  1.00 11.50           C  
ATOM    521  CE1 PHE A 197      -5.215  25.189  26.058  1.00 15.74           C  
ATOM    522  CE2 PHE A 197      -7.349  24.110  25.733  1.00 13.60           C  
ATOM    523  CZ  PHE A 197      -5.960  24.025  25.888  1.00 13.86           C  
ATOM    524  N   ARG A 198      -6.835  27.404  22.740  1.00 10.53           N  
ATOM    525  CA  ARG A 198      -6.934  26.545  21.558  1.00 11.05           C  
ATOM    526  C   ARG A 198      -7.293  25.122  21.966  1.00 11.25           C  
ATOM    527  O   ARG A 198      -6.408  24.305  22.242  1.00 12.59           O  
ATOM    528  CB  ARG A 198      -5.609  26.573  20.790  1.00 11.21           C  
ATOM    529  CG  ARG A 198      -5.672  25.936  19.408  1.00 11.12           C  
ATOM    530  CD  ARG A 198      -6.436  26.839  18.409  1.00 11.86           C  
ATOM    531  NE  ARG A 198      -6.300  26.410  17.022  1.00 13.49           N  
ATOM    532  CZ  ARG A 198      -5.286  26.759  16.233  1.00 12.99           C  
ATOM    533  NH1 ARG A 198      -4.313  27.537  16.698  1.00 13.41           N  
ATOM    534  NH2 ARG A 198      -5.242  26.330  14.972  1.00 13.58           N  
ATOM    535  N   CYS A 199      -8.597  24.837  22.053  1.00 10.88           N  
ATOM    536  CA  CYS A 199      -9.061  23.496  22.461  1.00 11.60           C  
ATOM    537  C   CYS A 199      -9.083  22.467  21.323  1.00 10.95           C  
ATOM    538  O   CYS A 199      -9.317  21.294  21.562  1.00 11.07           O  
ATOM    539  CB  CYS A 199     -10.435  23.570  23.147  1.00 11.80           C  
ATOM    540  SG  CYS A 199     -11.781  24.069  22.061  1.00 15.07           S  
ATOM    541  N   HIS A 200      -8.834  22.927  20.099  1.00 11.23           N  
ATOM    542  CA  HIS A 200      -8.918  22.086  18.900  1.00 11.14           C  
ATOM    543  C   HIS A 200      -8.265  22.897  17.800  1.00 11.30           C  
ATOM    544  O   HIS A 200      -8.231  24.126  17.853  1.00 10.73           O  
ATOM    545  CB  HIS A 200     -10.392  21.855  18.567  1.00 11.19           C  
ATOM    546  CG  HIS A 200     -10.645  20.859  17.476  1.00 11.52           C  
ATOM    547  ND1 HIS A 200     -10.483  21.163  16.143  1.00 11.91           N  
ATOM    548  CD2 HIS A 200     -11.116  19.589  17.520  1.00 11.21           C  
ATOM    549  CE1 HIS A 200     -10.826  20.115  15.411  1.00 12.46           C  
ATOM    550  NE2 HIS A 200     -11.207  19.145  16.222  1.00 12.28           N  
ATOM    551  N   ASN A 201      -7.702  22.213  16.813  1.00 11.12           N  
ATOM    552  CA  ASN A 201      -7.145  22.904  15.666  1.00 11.66           C  
ATOM    553  C   ASN A 201      -8.110  23.942  15.059  1.00 11.61           C  
ATOM    554  O   ASN A 201      -7.668  24.981  14.582  1.00 12.12           O  
ATOM    555  CB  ASN A 201      -6.745  21.874  14.616  1.00 11.42           C  
ATOM    556  CG  ASN A 201      -5.811  22.430  13.576  1.00 11.83           C  
ATOM    557  OD1 ASN A 201      -4.940  23.264  13.857  1.00 12.73           O  
ATOM    558  ND2 ASN A 201      -5.964  21.939  12.344  1.00 13.67           N  
ATOM    559  N   SER A 202      -9.418  23.668  15.118  1.00 11.30           N  
ATOM    560  CA  SER A 202     -10.419  24.532  14.482  1.00 11.41           C  
ATOM    561  C   SER A 202     -11.173  25.460  15.438  1.00 11.06           C  
ATOM    562  O   SER A 202     -12.044  26.200  14.981  1.00 11.14           O  
ATOM    563  CB  SER A 202     -11.438  23.694  13.686  1.00 12.00           C  
ATOM    564  OG  SER A 202     -10.780  22.867  12.725  1.00 13.44           O  
ATOM    565  N   PHE A 203     -10.841  25.432  16.736  1.00 10.65           N  
ATOM    566  CA  PHE A 203     -11.602  26.202  17.738  1.00 10.42           C  
ATOM    567  C   PHE A 203     -10.746  26.865  18.808  1.00 10.11           C  
ATOM    568  O   PHE A 203      -9.814  26.257  19.324  1.00 10.41           O  
ATOM    569  CB  PHE A 203     -12.603  25.304  18.463  1.00 10.51           C  
ATOM    570  CG  PHE A 203     -13.626  24.664  17.563  1.00 10.35           C  
ATOM    571  CD1 PHE A 203     -14.787  25.347  17.226  1.00 10.76           C  
ATOM    572  CD2 PHE A 203     -13.452  23.362  17.106  1.00 11.11           C  
ATOM    573  CE1 PHE A 203     -15.749  24.746  16.416  1.00 12.02           C  
ATOM    574  CE2 PHE A 203     -14.417  22.758  16.280  1.00 12.80           C  
ATOM    575  CZ  PHE A 203     -15.557  23.460  15.937  1.00 11.94           C  
ATOM    576  N   VAL A 204     -11.093  28.103  19.154  1.00  9.86           N  
ATOM    577  CA  VAL A 204     -10.494  28.803  20.299  1.00 10.05           C  
ATOM    578  C   VAL A 204     -11.650  29.182  21.207  1.00 10.15           C  
ATOM    579  O   VAL A 204     -12.557  29.889  20.787  1.00 11.36           O  
ATOM    580  CB  VAL A 204      -9.704  30.064  19.863  1.00  9.97           C  
ATOM    581  CG1 VAL A 204      -9.377  30.996  21.070  1.00 10.55           C  
ATOM    582  CG2 VAL A 204      -8.426  29.657  19.139  1.00  9.94           C  
ATOM    583  N   VAL A 205     -11.625  28.676  22.439  1.00  9.64           N  
ATOM    584  CA  VAL A 205     -12.735  28.891  23.373  1.00 10.59           C  
ATOM    585  C   VAL A 205     -12.425  30.012  24.328  1.00 10.66           C  
ATOM    586  O   VAL A 205     -11.266  30.226  24.676  1.00 11.81           O  
ATOM    587  CB  VAL A 205     -13.080  27.609  24.164  1.00 10.60           C  
ATOM    588  CG1 VAL A 205     -13.501  26.532  23.216  1.00 13.72           C  
ATOM    589  CG2 VAL A 205     -11.887  27.133  25.025  1.00 13.51           C  
ATOM    590  N   ASN A 206     -13.465  30.723  24.752  1.00 10.10           N  
ATOM    591  CA  ASN A 206     -13.328  31.667  25.852  1.00  9.87           C  
ATOM    592  C   ASN A 206     -13.658  30.942  27.146  1.00 10.03           C  
ATOM    593  O   ASN A 206     -14.810  30.637  27.416  1.00 10.29           O  
ATOM    594  CB  ASN A 206     -14.230  32.895  25.642  1.00 10.09           C  
ATOM    595  CG  ASN A 206     -14.077  33.924  26.742  1.00 10.82           C  
ATOM    596  OD1 ASN A 206     -13.511  33.631  27.790  1.00 11.81           O  
ATOM    597  ND2 ASN A 206     -14.590  35.139  26.509  1.00  9.39           N  
ATOM    598  N   ARG A 207     -12.620  30.667  27.940  1.00  9.87           N  
ATOM    599  CA  ARG A 207     -12.793  29.930  29.192  1.00 10.40           C  
ATOM    600  C   ARG A 207     -13.829  30.566  30.125  1.00 10.34           C  
ATOM    601  O   ARG A 207     -14.485  29.859  30.902  1.00 11.70           O  
ATOM    602  CB  ARG A 207     -11.454  29.789  29.918  1.00 10.61           C  
ATOM    603  CG  ARG A 207     -10.517  28.786  29.280  1.00 11.11           C  
ATOM    604  CD  ARG A 207      -9.094  28.929  29.837  1.00 13.20           C  
ATOM    605  NE  ARG A 207      -8.298  27.719  29.645  1.00 15.11           N  
ATOM    606  CZ  ARG A 207      -6.975  27.702  29.509  1.00 17.16           C  
ATOM    607  NH1 ARG A 207      -6.297  28.840  29.457  1.00 19.07           N  
ATOM    608  NH2 ARG A 207      -6.335  26.551  29.372  1.00 17.96           N  
ATOM    609  N   HIS A 208     -13.982  31.886  30.056  1.00 11.17           N  
ATOM    610  CA  HIS A 208     -14.937  32.597  30.928  1.00 10.94           C  
ATOM    611  C   HIS A 208     -16.382  32.207  30.654  1.00 11.20           C  
ATOM    612  O   HIS A 208     -17.265  32.376  31.511  1.00 12.35           O  
ATOM    613  CB  HIS A 208     -14.805  34.106  30.753  1.00 11.21           C  
ATOM    614  CG  HIS A 208     -13.592  34.690  31.412  1.00 11.59           C  
ATOM    615  ND1 HIS A 208     -13.450  36.043  31.632  1.00 13.18           N  
ATOM    616  CD2 HIS A 208     -12.480  34.105  31.916  1.00 12.97           C  
ATOM    617  CE1 HIS A 208     -12.287  36.269  32.220  1.00 14.01           C  
ATOM    618  NE2 HIS A 208     -11.691  35.108  32.426  1.00 12.58           N  
ATOM    619  N   ASN A 209     -16.624  31.704  29.449  1.00 10.59           N  
ATOM    620  CA  ASN A 209     -17.983  31.429  29.009  1.00 10.97           C  
ATOM    621  C   ASN A 209     -18.340  29.973  28.903  1.00 10.74           C  
ATOM    622  O   ASN A 209     -19.468  29.639  28.501  1.00 11.18           O  
ATOM    623  CB  ASN A 209     -18.275  32.167  27.709  1.00 10.53           C  
ATOM    624  CG  ASN A 209     -18.518  33.627  27.954  1.00 11.52           C  
ATOM    625  OD1 ASN A 209     -19.112  33.988  28.971  1.00 13.40           O  
ATOM    626  ND2 ASN A 209     -18.016  34.480  27.076  1.00 11.85           N  
ATOM    627  N   ILE A 210     -17.399  29.105  29.268  1.00 10.78           N  
ATOM    628  CA  ILE A 210     -17.672  27.673  29.289  1.00 11.20           C  
ATOM    629  C   ILE A 210     -18.615  27.388  30.451  1.00 11.85           C  
ATOM    630  O   ILE A 210     -18.394  27.842  31.572  1.00 12.47           O  
ATOM    631  CB  ILE A 210     -16.380  26.849  29.440  1.00 10.50           C  
ATOM    632  CG1 ILE A 210     -15.496  27.041  28.197  1.00 11.11           C  
ATOM    633  CG2 ILE A 210     -16.709  25.367  29.663  1.00 10.54           C  
ATOM    634  CD1 ILE A 210     -14.123  26.346  28.277  1.00 12.15           C  
ATOM    635  N   GLU A 211     -19.685  26.662  30.165  1.00 12.89           N  
ATOM    636  CA  GLU A 211     -20.591  26.225  31.219  1.00 14.19           C  
ATOM    637  C   GLU A 211     -20.196  24.846  31.729  1.00 14.32           C  
ATOM    638  O   GLU A 211     -20.100  24.633  32.939  1.00 14.68           O  
ATOM    639  CB  GLU A 211     -22.008  26.197  30.688  1.00 14.34           C  
ATOM    640  CG  GLU A 211     -23.035  25.798  31.729  1.00 16.98           C  
ATOM    641  CD  GLU A 211     -24.434  25.988  31.223  1.00 20.47           C  
ATOM    642  OE1 GLU A 211     -24.954  27.122  31.339  1.00 21.70           O  
ATOM    643  OE2 GLU A 211     -25.004  25.011  30.693  1.00 22.64           O  
ATOM    644  N   SER A 212     -19.977  23.910  30.805  1.00 13.62           N  
ATOM    645  CA  SER A 212     -19.597  22.546  31.168  1.00 13.43           C  
ATOM    646  C   SER A 212     -18.869  21.917  30.007  1.00 13.39           C  
ATOM    647  O   SER A 212     -18.866  22.464  28.908  1.00 13.55           O  
ATOM    648  CB  SER A 212     -20.837  21.708  31.488  1.00 14.11           C  
ATOM    649  OG  SER A 212     -21.671  21.591  30.343  1.00 14.24           O  
ATOM    650  N   ILE A 213     -18.268  20.762  30.252  1.00 13.58           N  
ATOM    651  CA  ILE A 213     -17.629  19.998  29.192  1.00 14.11           C  
ATOM    652  C   ILE A 213     -18.096  18.557  29.287  1.00 14.75           C  
ATOM    653  O   ILE A 213     -18.116  17.983  30.364  1.00 15.37           O  
ATOM    654  CB  ILE A 213     -16.086  20.038  29.307  1.00 13.40           C  
ATOM    655  CG1 ILE A 213     -15.567  21.471  29.166  1.00 14.53           C  
ATOM    656  CG2 ILE A 213     -15.429  19.173  28.228  1.00 15.09           C  
ATOM    657  CD1 ILE A 213     -14.200  21.684  29.794  1.00 17.03           C  
ATOM    658  N   ASP A 214     -18.496  17.988  28.156  1.00 15.55           N  
ATOM    659  CA  ASP A 214     -18.696  16.546  28.058  1.00 17.12           C  
ATOM    660  C   ASP A 214     -17.340  15.955  27.672  1.00 18.32           C  
ATOM    661  O   ASP A 214     -16.977  15.954  26.494  1.00 18.28           O  
ATOM    662  CB  ASP A 214     -19.757  16.259  26.989  1.00 16.83           C  
ATOM    663  CG  ASP A 214     -20.091  14.776  26.857  1.00 18.96           C  
ATOM    664  OD1 ASP A 214     -19.275  13.926  27.273  1.00 20.93           O  
ATOM    665  OD2 ASP A 214     -21.187  14.480  26.311  1.00 22.01           O  
ATOM    666  N   SER A 215     -16.557  15.493  28.650  1.00 19.93           N  
ATOM    667  CA  SER A 215     -15.193  15.049  28.341  1.00 21.76           C  
ATOM    668  C   SER A 215     -15.141  13.754  27.535  1.00 22.09           C  
ATOM    669  O   SER A 215     -14.201  13.547  26.779  1.00 23.14           O  
ATOM    670  CB  SER A 215     -14.295  14.949  29.583  1.00 22.65           C  
ATOM    671  OG  SER A 215     -14.745  13.949  30.465  1.00 26.05           O  
ATOM    672  N   LYS A 216     -16.146  12.897  27.700  1.00 22.60           N  
ATOM    673  CA  LYS A 216     -16.207  11.640  26.948  1.00 23.30           C  
ATOM    674  C   LYS A 216     -16.321  11.910  25.448  1.00 22.59           C  
ATOM    675  O   LYS A 216     -15.599  11.311  24.651  1.00 23.21           O  
ATOM    676  CB  LYS A 216     -17.370  10.765  27.425  1.00 23.52           C  
ATOM    677  CG  LYS A 216     -17.431   9.381  26.779  1.00 24.84           C  
ATOM    678  CD  LYS A 216     -18.652   8.611  27.285  1.00 25.31           C  
ATOM    679  CE  LYS A 216     -18.705   7.201  26.712  1.00 28.47           C  
ATOM    680  NZ  LYS A 216     -17.722   6.300  27.366  1.00 30.21           N  
ATOM    681  N   GLU A 217     -17.220  12.817  25.074  1.00 21.63           N  
ATOM    682  CA  GLU A 217     -17.443  13.150  23.664  1.00 20.78           C  
ATOM    683  C   GLU A 217     -16.577  14.320  23.218  1.00 19.60           C  
ATOM    684  O   GLU A 217     -16.521  14.648  22.025  1.00 19.66           O  
ATOM    685  CB  GLU A 217     -18.924  13.456  23.404  1.00 21.51           C  
ATOM    686  CG  GLU A 217     -19.890  12.349  23.847  1.00 23.89           C  
ATOM    687  CD  GLU A 217     -19.492  10.960  23.365  1.00 27.98           C  
ATOM    688  OE1 GLU A 217     -18.981  10.822  22.229  1.00 30.01           O  
ATOM    689  OE2 GLU A 217     -19.702   9.989  24.131  1.00 30.69           O  
ATOM    690  N   ARG A 218     -15.917  14.947  24.192  1.00 18.06           N  
ATOM    691  CA  ARG A 218     -15.079  16.132  23.972  1.00 17.04           C  
ATOM    692  C   ARG A 218     -15.862  17.293  23.343  1.00 16.22           C  
ATOM    693  O   ARG A 218     -15.452  17.890  22.340  1.00 16.80           O  
ATOM    694  CB  ARG A 218     -13.815  15.778  23.175  1.00 17.65           C  
ATOM    695  CG  ARG A 218     -12.974  14.671  23.812  1.00 17.92           C  
ATOM    696  CD  ARG A 218     -11.681  14.463  23.056  1.00 19.11           C  
ATOM    697  NE  ARG A 218     -11.894  14.431  21.615  1.00 21.72           N  
ATOM    698  CZ  ARG A 218     -12.319  13.370  20.938  1.00 21.44           C  
ATOM    699  NH1 ARG A 218     -12.572  12.229  21.566  1.00 23.93           N  
ATOM    700  NH2 ARG A 218     -12.484  13.453  19.624  1.00 22.77           N  
ATOM    701  N   ILE A 219     -17.009  17.599  23.946  1.00 15.18           N  
ATOM    702  CA  ILE A 219     -17.838  18.726  23.535  1.00 14.27           C  
ATOM    703  C   ILE A 219     -17.853  19.767  24.650  1.00 13.54           C  
ATOM    704  O   ILE A 219     -18.063  19.429  25.819  1.00 13.51           O  
ATOM    705  CB  ILE A 219     -19.277  18.275  23.162  1.00 14.56           C  
ATOM    706  CG1 ILE A 219     -19.204  17.274  21.998  1.00 16.11           C  
ATOM    707  CG2 ILE A 219     -20.154  19.480  22.807  1.00 14.21           C  
ATOM    708  CD1 ILE A 219     -20.526  16.574  21.681  1.00 16.25           C  
ATOM    709  N   VAL A 220     -17.575  21.013  24.273  1.00 12.43           N  
ATOM    710  CA  VAL A 220     -17.562  22.148  25.179  1.00 12.08           C  
ATOM    711  C   VAL A 220     -18.882  22.907  25.042  1.00 12.09           C  
ATOM    712  O   VAL A 220     -19.269  23.297  23.944  1.00 12.26           O  
ATOM    713  CB  VAL A 220     -16.373  23.089  24.877  1.00 11.83           C  
ATOM    714  CG1 VAL A 220     -16.280  24.193  25.924  1.00 12.30           C  
ATOM    715  CG2 VAL A 220     -15.071  22.303  24.806  1.00 11.73           C  
ATOM    716  N   TYR A 221     -19.555  23.106  26.170  1.00 12.40           N  
ATOM    717  CA  TYR A 221     -20.850  23.793  26.229  1.00 13.90           C  
ATOM    718  C   TYR A 221     -20.706  25.172  26.818  1.00 13.87           C  
ATOM    719  O   TYR A 221     -20.012  25.363  27.817  1.00 13.74           O  
ATOM    720  CB  TYR A 221     -21.855  22.984  27.058  1.00 13.78           C  
ATOM    721  CG  TYR A 221     -22.256  21.723  26.334  1.00 15.25           C  
ATOM    722  CD1 TYR A 221     -23.254  21.762  25.364  1.00 17.81           C  
ATOM    723  CD2 TYR A 221     -21.582  20.519  26.552  1.00 16.10           C  
ATOM    724  CE1 TYR A 221     -23.607  20.628  24.657  1.00 17.45           C  
ATOM    725  CE2 TYR A 221     -21.940  19.361  25.846  1.00 18.30           C  
ATOM    726  CZ  TYR A 221     -22.954  19.437  24.899  1.00 18.11           C  
ATOM    727  OH  TYR A 221     -23.319  18.317  24.176  1.00 20.40           O  
ATOM    728  N   PHE A 222     -21.358  26.137  26.186  1.00 14.17           N  
ATOM    729  CA  PHE A 222     -21.237  27.525  26.604  1.00 14.45           C  
ATOM    730  C   PHE A 222     -22.489  28.035  27.280  1.00 14.88           C  
ATOM    731  O   PHE A 222     -23.557  27.425  27.165  1.00 15.35           O  
ATOM    732  CB  PHE A 222     -20.830  28.380  25.399  1.00 15.10           C  
ATOM    733  CG  PHE A 222     -19.503  27.985  24.859  1.00 13.38           C  
ATOM    734  CD1 PHE A 222     -18.340  28.515  25.396  1.00 13.74           C  
ATOM    735  CD2 PHE A 222     -19.398  27.004  23.872  1.00 14.18           C  
ATOM    736  CE1 PHE A 222     -17.099  28.101  24.940  1.00 14.33           C  
ATOM    737  CE2 PHE A 222     -18.165  26.588  23.414  1.00 14.60           C  
ATOM    738  CZ  PHE A 222     -17.009  27.134  23.950  1.00 14.71           C  
ATOM    739  N   LYS A 223     -22.349  29.146  27.993  1.00 15.50           N  
ATOM    740  CA  LYS A 223     -23.462  29.691  28.764  1.00 16.08           C  
ATOM    741  C   LYS A 223     -24.689  30.010  27.894  1.00 16.24           C  
ATOM    742  O   LYS A 223     -25.816  29.993  28.391  1.00 17.00           O  
ATOM    743  CB  LYS A 223     -23.025  30.899  29.603  1.00 16.28           C  
ATOM    744  CG  LYS A 223     -22.697  32.152  28.813  1.00 17.64           C  
ATOM    745  CD  LYS A 223     -22.339  33.292  29.738  1.00 20.30           C  
ATOM    746  CE  LYS A 223     -22.373  34.631  29.026  1.00 20.48           C  
ATOM    747  NZ  LYS A 223     -22.358  35.785  29.990  1.00 23.41           N  
ATOM    748  N   ASN A 224     -24.471  30.257  26.599  1.00 16.40           N  
ATOM    749  CA  ASN A 224     -25.564  30.558  25.666  1.00 16.40           C  
ATOM    750  C   ASN A 224     -26.149  29.324  24.966  1.00 16.43           C  
ATOM    751  O   ASN A 224     -26.951  29.459  24.036  1.00 16.61           O  
ATOM    752  CB  ASN A 224     -25.104  31.576  24.617  1.00 16.20           C  
ATOM    753  CG  ASN A 224     -24.224  30.944  23.546  1.00 16.31           C  
ATOM    754  OD1 ASN A 224     -23.637  29.884  23.765  1.00 17.36           O  
ATOM    755  ND2 ASN A 224     -24.130  31.596  22.382  1.00 15.52           N  
ATOM    756  N   LYS A 225     -25.719  28.134  25.388  1.00 16.86           N  
ATOM    757  CA  LYS A 225     -26.240  26.840  24.893  1.00 17.60           C  
ATOM    758  C   LYS A 225     -25.595  26.325  23.605  1.00 17.43           C  
ATOM    759  O   LYS A 225     -25.898  25.217  23.138  1.00 18.17           O  
ATOM    760  CB  LYS A 225     -27.766  26.852  24.736  1.00 18.53           C  
ATOM    761  CG  LYS A 225     -28.540  27.336  25.953  1.00 21.02           C  
ATOM    762  CD  LYS A 225     -28.397  26.447  27.157  1.00 24.45           C  
ATOM    763  CE  LYS A 225     -29.512  26.758  28.140  1.00 25.98           C  
ATOM    764  NZ  LYS A 225     -29.215  26.228  29.490  1.00 27.47           N  
ATOM    765  N   GLU A 226     -24.712  27.122  23.022  1.00 16.52           N  
ATOM    766  CA  GLU A 226     -23.913  26.632  21.913  1.00 16.29           C  
ATOM    767  C   GLU A 226     -22.879  25.631  22.410  1.00 15.71           C  
ATOM    768  O   GLU A 226     -22.608  25.532  23.614  1.00 15.35           O  
ATOM    769  CB  GLU A 226     -23.211  27.781  21.212  1.00 16.22           C  
ATOM    770  CG  GLU A 226     -24.131  28.701  20.448  1.00 17.37           C  
ATOM    771  CD  GLU A 226     -23.329  29.614  19.543  1.00 17.96           C  
ATOM    772  OE1 GLU A 226     -22.799  30.621  20.054  1.00 18.25           O  
ATOM    773  OE2 GLU A 226     -23.203  29.295  18.339  1.00 21.01           O  
ATOM    774  N   HIS A 227     -22.292  24.903  21.467  1.00 15.52           N  
ATOM    775  CA  HIS A 227     -21.176  24.031  21.784  1.00 15.18           C  
ATOM    776  C   HIS A 227     -20.131  24.026  20.673  1.00 14.80           C  
ATOM    777  O   HIS A 227     -20.400  24.396  19.530  1.00 14.26           O  
ATOM    778  CB  HIS A 227     -21.668  22.610  22.063  1.00 16.03           C  
ATOM    779  CG  HIS A 227     -22.234  21.912  20.866  1.00 18.55           C  
ATOM    780  ND1 HIS A 227     -23.568  21.978  20.527  1.00 22.80           N  
ATOM    781  CD2 HIS A 227     -21.647  21.123  19.935  1.00 20.44           C  
ATOM    782  CE1 HIS A 227     -23.777  21.268  19.433  1.00 22.04           C  
ATOM    783  NE2 HIS A 227     -22.628  20.739  19.053  1.00 23.49           N  
ATOM    784  N   CYS A 228     -18.926  23.600  21.032  1.00 13.68           N  
ATOM    785  CA  CYS A 228     -17.898  23.342  20.038  1.00 13.96           C  
ATOM    786  C   CYS A 228     -17.129  22.099  20.433  1.00 13.77           C  
ATOM    787  O   CYS A 228     -17.469  21.440  21.410  1.00 13.59           O  
ATOM    788  CB  CYS A 228     -16.983  24.550  19.857  1.00 14.00           C  
ATOM    789  SG  CYS A 228     -15.822  24.872  21.210  1.00 13.99           S  
ATOM    790  N   TYR A 229     -16.118  21.750  19.652  1.00 13.75           N  
ATOM    791  CA  TYR A 229     -15.407  20.504  19.878  1.00 14.08           C  
ATOM    792  C   TYR A 229     -14.022  20.748  20.412  1.00 12.94           C  
ATOM    793  O   TYR A 229     -13.403  21.773  20.113  1.00 12.96           O  
ATOM    794  CB  TYR A 229     -15.400  19.667  18.595  1.00 15.63           C  
ATOM    795  CG  TYR A 229     -16.831  19.378  18.228  1.00 17.73           C  
ATOM    796  CD1 TYR A 229     -17.465  18.229  18.690  1.00 19.32           C  
ATOM    797  CD2 TYR A 229     -17.588  20.315  17.518  1.00 20.86           C  
ATOM    798  CE1 TYR A 229     -18.801  17.983  18.400  1.00 20.79           C  
ATOM    799  CE2 TYR A 229     -18.932  20.079  17.225  1.00 22.15           C  
ATOM    800  CZ  TYR A 229     -19.525  18.910  17.674  1.00 21.44           C  
ATOM    801  OH  TYR A 229     -20.847  18.673  17.384  1.00 21.90           O  
ATOM    802  N   ALA A 230     -13.569  19.815  21.244  1.00 12.24           N  
ATOM    803  CA  ALA A 230     -12.187  19.790  21.712  1.00 11.92           C  
ATOM    804  C   ALA A 230     -11.488  18.550  21.176  1.00 12.14           C  
ATOM    805  O   ALA A 230     -12.103  17.488  21.023  1.00 12.96           O  
ATOM    806  CB  ALA A 230     -12.140  19.812  23.224  1.00 11.96           C  
ATOM    807  N   SER A 231     -10.198  18.680  20.894  1.00 11.88           N  
ATOM    808  CA  SER A 231      -9.442  17.565  20.334  1.00 12.20           C  
ATOM    809  C   SER A 231      -8.938  16.656  21.448  1.00 12.20           C  
ATOM    810  O   SER A 231      -8.877  17.063  22.608  1.00 12.94           O  
ATOM    811  CB  SER A 231      -8.290  18.087  19.491  1.00 11.96           C  
ATOM    812  OG  SER A 231      -7.357  18.776  20.295  1.00 12.58           O  
ATOM    813  N   VAL A 232      -8.584  15.422  21.081  1.00 12.47           N  
ATOM    814  CA  VAL A 232      -8.071  14.441  22.031  1.00 13.58           C  
ATOM    815  C   VAL A 232      -6.860  15.015  22.787  1.00 13.40           C  
ATOM    816  O   VAL A 232      -6.744  14.868  24.013  1.00 14.33           O  
ATOM    817  CB  VAL A 232      -7.663  13.135  21.290  1.00 13.53           C  
ATOM    818  CG1 VAL A 232      -6.892  12.192  22.213  1.00 15.20           C  
ATOM    819  CG2 VAL A 232      -8.891  12.431  20.682  1.00 14.69           C  
ATOM    820  N   ARG A 233      -5.972  15.685  22.054  1.00 13.29           N  
ATOM    821  CA  ARG A 233      -4.735  16.184  22.649  1.00 13.59           C  
ATOM    822  C   ARG A 233      -4.890  17.453  23.502  1.00 13.91           C  
ATOM    823  O   ARG A 233      -4.000  17.772  24.290  1.00 14.86           O  
ATOM    824  CB  ARG A 233      -3.666  16.367  21.572  1.00 12.98           C  
ATOM    825  CG  ARG A 233      -3.288  15.055  20.890  1.00 13.34           C  
ATOM    826  CD  ARG A 233      -2.497  15.299  19.632  1.00 12.95           C  
ATOM    827  NE  ARG A 233      -2.047  14.051  18.984  1.00 13.65           N  
ATOM    828  CZ  ARG A 233      -2.815  13.277  18.221  1.00 14.07           C  
ATOM    829  NH1 ARG A 233      -4.087  13.609  17.980  1.00 12.58           N  
ATOM    830  NH2 ARG A 233      -2.299  12.171  17.678  1.00 13.23           N  
ATOM    831  N   ASN A 234      -6.004  18.171  23.350  1.00 14.11           N  
ATOM    832  CA  ASN A 234      -6.144  19.474  24.016  1.00 14.23           C  
ATOM    833  C   ASN A 234      -7.232  19.522  25.088  1.00 14.09           C  
ATOM    834  O   ASN A 234      -7.221  20.414  25.935  1.00 14.20           O  
ATOM    835  CB  ASN A 234      -6.436  20.583  22.991  1.00 14.22           C  
ATOM    836  CG  ASN A 234      -5.371  20.704  21.876  1.00 16.68           C  
ATOM    837  OD1 ASN A 234      -4.359  20.010  21.856  1.00 17.68           O  
ATOM    838  ND2 ASN A 234      -5.624  21.609  20.936  1.00 18.30           N  
ATOM    839  N   VAL A 235      -8.188  18.597  25.029  1.00 14.24           N  
ATOM    840  CA  VAL A 235      -9.380  18.673  25.894  1.00 15.17           C  
ATOM    841  C   VAL A 235      -9.045  18.759  27.391  1.00 15.44           C  
ATOM    842  O   VAL A 235      -9.677  19.516  28.136  1.00 15.56           O  
ATOM    843  CB  VAL A 235     -10.379  17.510  25.606  1.00 14.79           C  
ATOM    844  CG1 VAL A 235      -9.729  16.149  25.865  1.00 16.16           C  
ATOM    845  CG2 VAL A 235     -11.705  17.678  26.404  1.00 15.37           C  
ATOM    846  N   LYS A 236      -8.044  18.003  27.826  1.00 16.46           N  
ATOM    847  CA  LYS A 236      -7.742  17.917  29.260  1.00 17.32           C  
ATOM    848  C   LYS A 236      -7.108  19.187  29.807  1.00 17.44           C  
ATOM    849  O   LYS A 236      -7.087  19.391  31.019  1.00 17.99           O  
ATOM    850  CB  LYS A 236      -6.858  16.703  29.554  1.00 17.68           C  
ATOM    851  CG  LYS A 236      -7.567  15.386  29.340  1.00 20.16           C  
ATOM    852  CD  LYS A 236      -6.683  14.217  29.743  1.00 24.88           C  
ATOM    853  CE  LYS A 236      -7.384  12.898  29.478  1.00 26.19           C  
ATOM    854  NZ  LYS A 236      -6.523  11.748  29.854  1.00 29.75           N  
ATOM    855  N   LYS A 237      -6.623  20.036  28.907  1.00 16.57           N  
ATOM    856  CA  LYS A 237      -5.916  21.266  29.263  1.00 16.87           C  
ATOM    857  C   LYS A 237      -6.823  22.503  29.303  1.00 16.18           C  
ATOM    858  O   LYS A 237      -6.376  23.601  29.657  1.00 16.46           O  
ATOM    859  CB  LYS A 237      -4.726  21.457  28.314  1.00 17.19           C  
ATOM    860  CG  LYS A 237      -3.673  20.356  28.477  1.00 19.57           C  
ATOM    861  CD  LYS A 237      -2.697  20.286  27.308  1.00 24.07           C  
ATOM    862  CE  LYS A 237      -1.737  19.117  27.476  1.00 26.86           C  
ATOM    863  NZ  LYS A 237      -0.795  18.970  26.324  1.00 28.10           N  
ATOM    864  N   ILE A 238      -8.102  22.325  28.965  1.00 15.46           N  
ATOM    865  CA  ILE A 238      -9.060  23.428  29.017  1.00 15.14           C  
ATOM    866  C   ILE A 238      -9.172  24.002  30.425  1.00 15.81           C  
ATOM    867  O   ILE A 238      -9.182  25.220  30.603  1.00 16.80           O  
ATOM    868  CB  ILE A 238     -10.464  23.006  28.529  1.00 14.26           C  
ATOM    869  CG1 ILE A 238     -10.421  22.633  27.043  1.00 14.08           C  
ATOM    870  CG2 ILE A 238     -11.486  24.128  28.779  1.00 15.53           C  
ATOM    871  CD1 ILE A 238     -11.703  21.893  26.551  1.00 14.91           C  
ATOM    872  OXT ILE A 238      -9.238  23.258  31.407  1.00 16.48           O  
TER     873      ILE A 238                                                      
END
MOLECULE T0415.pdb
ATOM      1  N   GLY     1      -3.414  46.102  27.734  1.00 47.41           N  
ATOM      2  CA  GLY     1      -3.122  45.539  26.359  1.00 47.11           C  
ATOM      3  C   GLY     1      -4.177  45.907  25.333  1.00 47.07           C  
ATOM      4  O   GLY     1      -4.078  46.946  24.671  1.00 46.94           O  
ATOM      5  N   LYS     2      -5.171  45.030  25.198  1.00 46.92           N  
ATOM      6  CA  LYS     2      -6.274  45.185  24.253  1.00 46.81           C  
ATOM      7  C   LYS     2      -7.559  44.609  24.888  1.00 46.36           C  
ATOM      8  O   LYS     2      -7.467  43.735  25.759  1.00 45.55           O  
ATOM      9  CB  LYS     2      -5.938  44.505  22.904  1.00 47.31           C  
ATOM     10  CG  LYS     2      -5.486  45.508  21.817  1.00 47.91           C  
ATOM     11  CD  LYS     2      -4.343  45.056  20.919  1.00 47.60           C  
ATOM     12  CE  LYS     2      -4.032  46.152  19.891  1.00 47.58           C  
ATOM     13  NZ  LYS     2      -2.842  45.845  19.044  1.00 48.43           N  
ATOM     14  N   SER     3      -8.737  45.114  24.499  1.00 45.40           N  
ATOM     15  CA  SER     3      -9.967  44.730  25.214  1.00 45.73           C  
ATOM     16  C   SER     3     -11.200  44.568  24.362  1.00 44.97           C  
ATOM     17  O   SER     3     -12.250  44.270  24.886  1.00 43.15           O  
ATOM     18  CB  SER     3     -10.264  45.688  26.408  1.00 45.39           C  
ATOM     19  OG  SER     3     -10.858  46.926  26.031  1.00 44.69           O  
ATOM     20  N   VAL     4     -11.058  44.781  23.063  1.00 46.52           N  
ATOM     21  CA  VAL     4     -12.119  44.569  22.084  1.00 47.84           C  
ATOM     22  C   VAL     4     -11.586  43.824  20.877  1.00 49.90           C  
ATOM     23  O   VAL     4     -10.415  43.942  20.536  1.00 49.02           O  
ATOM     24  CB  VAL     4     -12.814  45.903  21.614  1.00 48.00           C  
ATOM     25  CG1 VAL     4     -13.403  46.612  22.796  1.00 48.15           C  
ATOM     26  CG2 VAL     4     -11.862  46.801  20.873  1.00 46.59           C  
ATOM     27  N   VAL     5     -12.464  43.017  20.284  1.00 52.98           N  
ATOM     28  CA  VAL     5     -12.249  42.400  18.975  1.00 55.45           C  
ATOM     29  C   VAL     5     -13.255  43.030  17.995  1.00 56.86           C  
ATOM     30  O   VAL     5     -14.440  43.149  18.318  1.00 57.09           O  
ATOM     31  CB  VAL     5     -12.496  40.880  18.971  1.00 54.97           C  
ATOM     32  CG1 VAL     5     -11.696  40.218  17.810  1.00 54.63           C  
ATOM     33  CG2 VAL     5     -12.138  40.263  20.301  1.00 54.64           C  
ATOM     34  N   THR     6     -12.765  43.452  16.823  1.00 58.87           N  
ATOM     35  CA  THR     6     -13.605  44.066  15.788  1.00 59.55           C  
ATOM     36  C   THR     6     -14.006  42.974  14.818  1.00 61.76           C  
ATOM     37  O   THR     6     -13.162  42.393  14.144  1.00 61.58           O  
ATOM     38  CB  THR     6     -12.932  45.268  15.121  1.00 59.79           C  
ATOM     39  OG1 THR     6     -12.480  46.179  16.145  1.00 59.48           O  
ATOM     40  CG2 THR     6     -13.915  46.013  14.231  1.00 58.55           C  
ATOM     41  N   LEU     7     -15.294  42.628  14.861  1.00 63.99           N  
ATOM     42  CA  LEU     7     -15.895  41.687  13.919  1.00 65.67           C  
ATOM     43  C   LEU     7     -16.368  42.441  12.667  1.00 66.61           C  
ATOM     44  O   LEU     7     -16.939  43.524  12.751  1.00 67.07           O  
ATOM     45  CB  LEU     7     -17.108  40.974  14.523  1.00 64.90           C  
ATOM     46  CG  LEU     7     -17.177  40.443  15.946  1.00 64.47           C  
ATOM     47  CD1 LEU     7     -18.054  39.221  16.010  1.00 62.44           C  
ATOM     48  CD2 LEU     7     -15.819  40.134  16.496  1.00 65.25           C  
ATOM     49  N   LYS     8     -16.166  41.836  11.506  1.00 68.76           N  
ATOM     50  CA  LYS     8     -16.680  42.380  10.243  1.00 69.47           C  
ATOM     51  C   LYS     8     -18.103  41.907  10.060  1.00 70.09           C  
ATOM     52  O   LYS     8     -18.347  40.694  10.082  1.00 69.59           O  
ATOM     53  CB  LYS     8     -15.813  41.896   9.086  1.00 69.96           C  
ATOM     54  CG  LYS     8     -16.349  42.153   7.703  1.00 70.04           C  
ATOM     55  CD  LYS     8     -15.243  42.025   6.686  1.00 70.59           C  
ATOM     56  CE  LYS     8     -15.612  42.751   5.399  1.00 72.06           C  
ATOM     57  NZ  LYS     8     -14.397  42.961   4.582  1.00 72.38           N  
ATOM     58  N   THR     9     -19.034  42.866   9.948  1.00 71.30           N  
ATOM     59  CA  THR     9     -20.416  42.587   9.508  1.00 72.31           C  
ATOM     60  C   THR     9     -20.616  42.985   8.048  1.00 72.69           C  
ATOM     61  O   THR     9     -19.697  43.484   7.396  1.00 72.53           O  
ATOM     62  CB  THR     9     -21.478  43.286  10.354  1.00 72.49           C  
ATOM     63  OG1 THR     9     -20.896  44.420  10.993  1.00 74.69           O  
ATOM     64  CG2 THR     9     -22.039  42.319  11.430  1.00 74.62           C  
ATOM     65  N   THR    10     -21.825  42.727   7.546  1.00 73.43           N  
ATOM     66  CA  THR    10     -22.161  42.914   6.126  1.00 73.47           C  
ATOM     67  C   THR    10     -21.839  44.354   5.638  1.00 73.38           C  
ATOM     68  O   THR    10     -21.174  44.550   4.599  1.00 72.70           O  
ATOM     69  CB  THR    10     -23.656  42.495   5.849  1.00 73.49           C  
ATOM     70  OG1 THR    10     -24.506  43.007   6.881  1.00 74.37           O  
ATOM     71  CG2 THR    10     -23.794  40.981   5.833  1.00 73.19           C  
ATOM     72  N   ASP    11     -22.248  45.341   6.434  1.00 73.21           N  
ATOM     73  CA  ASP    11     -22.094  46.754   6.059  1.00 73.27           C  
ATOM     74  C   ASP    11     -20.968  47.486   6.829  1.00 73.41           C  
ATOM     75  O   ASP    11     -20.279  48.348   6.242  1.00 73.86           O  
ATOM     76  CB  ASP    11     -23.437  47.492   6.208  1.00 73.82           C  
ATOM     77  CG  ASP    11     -24.153  47.149   7.512  1.00 74.89           C  
ATOM     78  OD1 ASP    11     -23.756  46.136   8.160  1.00 74.50           O  
ATOM     79  OD2 ASP    11     -25.105  47.888   7.872  1.00 74.98           O  
ATOM     80  N   GLY    12     -20.777  47.148   8.118  1.00 72.48           N  
ATOM     81  CA  GLY    12     -19.792  47.843   8.984  1.00 71.07           C  
ATOM     82  C   GLY    12     -19.007  46.880   9.851  1.00 70.00           C  
ATOM     83  O   GLY    12     -19.016  45.682   9.595  1.00 71.63           O  
ATOM     84  N   TRP    13     -18.304  47.400  10.853  1.00 68.05           N  
ATOM     85  CA  TRP    13     -17.557  46.562  11.841  1.00 66.68           C  
ATOM     86  C   TRP    13     -18.007  46.884  13.261  1.00 65.08           C  
ATOM     87  O   TRP    13     -18.280  48.050  13.606  1.00 64.47           O  
ATOM     88  CB  TRP    13     -16.060  46.842  11.792  1.00 64.59           C  
ATOM     89  CG  TRP    13     -15.332  46.422  10.588  1.00 62.93           C  
ATOM     90  CD1 TRP    13     -14.752  45.202  10.360  1.00 61.34           C  
ATOM     91  CD2 TRP    13     -15.018  47.240   9.461  1.00 61.52           C  
ATOM     92  NE1 TRP    13     -14.121  45.208   9.157  1.00 61.73           N  
ATOM     93  CE2 TRP    13     -14.268  46.448   8.578  1.00 62.18           C  
ATOM     94  CE3 TRP    13     -15.303  48.566   9.113  1.00 61.31           C  
ATOM     95  CZ2 TRP    13     -13.808  46.933   7.358  1.00 62.15           C  
ATOM     96  CZ3 TRP    13     -14.863  49.041   7.917  1.00 61.84           C  
ATOM     97  CH2 TRP    13     -14.116  48.232   7.046  1.00 62.33           C  
ATOM     98  N   ILE    14     -18.024  45.862  14.098  1.00 63.48           N  
ATOM     99  CA  ILE    14     -18.594  45.986  15.416  1.00 62.69           C  
ATOM    100  C   ILE    14     -17.526  45.612  16.442  1.00 62.71           C  
ATOM    101  O   ILE    14     -17.085  44.463  16.481  1.00 62.94           O  
ATOM    102  CB  ILE    14     -19.900  45.154  15.502  1.00 63.10           C  
ATOM    103  CG1 ILE    14     -20.867  45.664  14.398  1.00 62.59           C  
ATOM    104  CG2 ILE    14     -20.506  45.213  16.915  1.00 62.39           C  
ATOM    105  CD1 ILE    14     -22.294  45.381  14.613  1.00 62.33           C  
ATOM    106  N   PRO    15     -17.055  46.604  17.238  1.00 62.46           N  
ATOM    107  CA  PRO    15     -16.190  46.303  18.381  1.00 62.34           C  
ATOM    108  C   PRO    15     -16.956  45.561  19.472  1.00 62.33           C  
ATOM    109  O   PRO    15     -18.029  45.984  19.877  1.00 62.62           O  
ATOM    110  CB  PRO    15     -15.729  47.690  18.879  1.00 62.35           C  
ATOM    111  CG  PRO    15     -16.194  48.684  17.878  1.00 61.95           C  
ATOM    112  CD  PRO    15     -17.283  48.056  17.089  1.00 62.29           C  
ATOM    113  N   VAL    16     -16.411  44.424  19.895  1.00 62.70           N  
ATOM    114  CA  VAL    16     -17.012  43.575  20.936  1.00 62.00           C  
ATOM    115  C   VAL    16     -15.947  43.416  22.050  1.00 61.36           C  
ATOM    116  O   VAL    16     -14.801  43.160  21.741  1.00 62.57           O  
ATOM    117  CB  VAL    16     -17.408  42.199  20.316  1.00 62.01           C  
ATOM    118  CG1 VAL    16     -18.064  41.280  21.347  1.00 61.62           C  
ATOM    119  CG2 VAL    16     -18.307  42.408  19.135  1.00 61.84           C  
ATOM    120  N   PRO    17     -16.306  43.598  23.322  1.00 60.41           N  
ATOM    121  CA  PRO    17     -15.359  43.341  24.392  1.00 60.25           C  
ATOM    122  C   PRO    17     -14.991  41.878  24.466  1.00 59.48           C  
ATOM    123  O   PRO    17     -15.821  41.028  24.158  1.00 60.87           O  
ATOM    124  CB  PRO    17     -16.132  43.701  25.679  1.00 59.73           C  
ATOM    125  CG  PRO    17     -17.373  44.271  25.285  1.00 60.45           C  
ATOM    126  CD  PRO    17     -17.621  44.018  23.839  1.00 61.22           C  
ATOM    127  N   PHE    18     -13.779  41.575  24.878  1.00 59.09           N  
ATOM    128  CA  PHE    18     -13.352  40.180  25.028  1.00 60.00           C  
ATOM    129  C   PHE    18     -14.331  39.371  25.874  1.00 59.66           C  
ATOM    130  O   PHE    18     -14.580  38.201  25.601  1.00 59.27           O  
ATOM    131  CB  PHE    18     -11.943  40.079  25.641  1.00 60.36           C  
ATOM    132  CG  PHE    18     -10.829  40.515  24.716  1.00 61.73           C  
ATOM    133  CD1 PHE    18     -11.007  40.611  23.331  1.00 63.29           C  
ATOM    134  CD2 PHE    18      -9.586  40.789  25.229  1.00 63.45           C  
ATOM    135  CE1 PHE    18      -9.972  41.008  22.489  1.00 61.73           C  
ATOM    136  CE2 PHE    18      -8.538  41.181  24.390  1.00 63.81           C  
ATOM    137  CZ  PHE    18      -8.749  41.298  23.018  1.00 63.81           C  
ATOM    138  N   SER    19     -14.896  40.028  26.881  1.00 59.39           N  
ATOM    139  CA  SER    19     -15.812  39.400  27.822  1.00 59.03           C  
ATOM    140  C   SER    19     -17.096  38.837  27.165  1.00 58.26           C  
ATOM    141  O   SER    19     -17.719  37.937  27.703  1.00 59.05           O  
ATOM    142  CB  SER    19     -16.149  40.424  28.932  1.00 58.56           C  
ATOM    143  OG  SER    19     -17.118  41.375  28.499  1.00 60.75           O  
ATOM    144  N   LYS    20     -17.461  39.376  26.003  1.00 57.56           N  
ATOM    145  CA  LYS    20     -18.622  38.984  25.271  1.00 56.87           C  
ATOM    146  C   LYS    20     -18.322  37.990  24.151  1.00 55.79           C  
ATOM    147  O   LYS    20     -19.242  37.475  23.489  1.00 55.89           O  
ATOM    148  CB  LYS    20     -19.297  40.226  24.683  1.00 58.50           C  
ATOM    149  CG  LYS    20     -19.656  41.281  25.714  1.00 61.62           C  
ATOM    150  CD  LYS    20     -21.134  41.349  26.026  1.00 67.10           C  
ATOM    151  CE  LYS    20     -21.841  42.519  25.253  1.00 72.31           C  
ATOM    152  NZ  LYS    20     -23.196  42.117  24.593  1.00 74.04           N  
ATOM    153  N   VAL    21     -17.050  37.681  23.943  1.00 54.46           N  
ATOM    154  CA  VAL    21     -16.674  36.623  22.977  1.00 52.57           C  
ATOM    155  C   VAL    21     -16.825  35.242  23.636  1.00 50.97           C  
ATOM    156  O   VAL    21     -16.201  34.987  24.690  1.00 52.54           O  
ATOM    157  CB  VAL    21     -15.224  36.823  22.448  1.00 53.00           C  
ATOM    158  CG1 VAL    21     -14.850  35.746  21.373  1.00 50.20           C  
ATOM    159  CG2 VAL    21     -15.069  38.272  21.921  1.00 53.32           C  
ATOM    160  N   MET    22     -17.645  34.392  23.031  1.00 47.48           N  
ATOM    161  CA  MET    22     -17.935  33.066  23.535  1.00 45.74           C  
ATOM    162  C   MET    22     -16.919  32.024  23.033  1.00 46.12           C  
ATOM    163  O   MET    22     -16.448  31.187  23.789  1.00 44.25           O  
ATOM    164  CB  MET    22     -19.358  32.651  23.110  1.00 44.28           C  
ATOM    165  CG  MET    22     -20.425  33.576  23.586  1.00 39.75           C  
ATOM    166  SD  MET    22     -22.258  33.106  23.165  0.65 34.59          SE  
ATOM    167  CE  MET    22     -21.956  33.084  21.247  1.00 31.49           C  
ATOM    168  N   TYR    23     -16.635  32.091  21.739  1.00 47.88           N  
ATOM    169  CA  TYR    23     -15.674  31.233  21.061  1.00 49.56           C  
ATOM    170  C   TYR    23     -15.268  31.816  19.681  1.00 50.94           C  
ATOM    171  O   TYR    23     -15.856  32.791  19.174  1.00 51.25           O  
ATOM    172  CB  TYR    23     -16.185  29.770  20.951  1.00 50.31           C  
ATOM    173  CG  TYR    23     -17.372  29.563  20.024  1.00 50.93           C  
ATOM    174  CD1 TYR    23     -18.670  29.616  20.500  1.00 49.91           C  
ATOM    175  CD2 TYR    23     -17.175  29.286  18.667  1.00 52.85           C  
ATOM    176  CE1 TYR    23     -19.720  29.429  19.667  1.00 50.30           C  
ATOM    177  CE2 TYR    23     -18.208  29.114  17.822  1.00 51.25           C  
ATOM    178  CZ  TYR    23     -19.497  29.195  18.315  1.00 52.04           C  
ATOM    179  OH  TYR    23     -20.564  29.013  17.441  1.00 52.22           O  
ATOM    180  N   LEU    24     -14.183  31.287  19.141  1.00 51.88           N  
ATOM    181  CA  LEU    24     -13.715  31.663  17.815  1.00 52.72           C  
ATOM    182  C   LEU    24     -13.626  30.362  17.061  1.00 55.11           C  
ATOM    183  O   LEU    24     -13.285  29.325  17.648  1.00 55.39           O  
ATOM    184  CB  LEU    24     -12.344  32.388  17.826  1.00 52.44           C  
ATOM    185  CG  LEU    24     -12.203  33.773  18.462  1.00 51.64           C  
ATOM    186  CD1 LEU    24     -12.026  33.718  19.998  1.00 51.46           C  
ATOM    187  CD2 LEU    24     -11.038  34.473  17.904  1.00 51.70           C  
ATOM    188  N   GLU    25     -13.973  30.400  15.778  1.00 57.81           N  
ATOM    189  CA  GLU    25     -13.945  29.200  14.949  1.00 59.82           C  
ATOM    190  C   GLU    25     -13.242  29.431  13.614  1.00 60.44           C  
ATOM    191  O   GLU    25     -13.604  30.367  12.875  1.00 59.87           O  
ATOM    192  CB  GLU    25     -15.354  28.677  14.679  1.00 59.79           C  
ATOM    193  CG  GLU    25     -15.347  27.444  13.750  1.00 59.72           C  
ATOM    194  CD  GLU    25     -16.706  26.844  13.534  1.00 61.31           C  
ATOM    195  OE1 GLU    25     -16.770  25.650  13.104  1.00 61.35           O  
ATOM    196  OE2 GLU    25     -17.683  27.569  13.817  1.00 60.92           O  
ATOM    197  N   ALA    26     -12.258  28.568  13.317  1.00 61.72           N  
ATOM    198  CA  ALA    26     -11.662  28.483  11.973  1.00 62.89           C  
ATOM    199  C   ALA    26     -12.565  27.603  11.100  1.00 65.56           C  
ATOM    200  O   ALA    26     -12.829  26.429  11.378  1.00 65.20           O  
ATOM    201  CB  ALA    26     -10.254  27.931  12.019  1.00 62.69           C  
ATOM    202  N   LYS    27     -13.063  28.199  10.044  1.00 69.29           N  
ATOM    203  CA  LYS    27     -14.038  27.541   9.191  1.00 72.27           C  
ATOM    204  C   LYS    27     -13.991  28.167   7.813  1.00 74.02           C  
ATOM    205  O   LYS    27     -13.931  29.384   7.675  1.00 74.45           O  
ATOM    206  CB  LYS    27     -15.429  27.722   9.796  1.00 72.85           C  
ATOM    207  CG  LYS    27     -16.562  27.045   9.080  1.00 71.39           C  
ATOM    208  CD  LYS    27     -17.859  27.743   9.401  1.00 73.27           C  
ATOM    209  CE  LYS    27     -19.021  26.823   9.163  1.00 75.03           C  
ATOM    210  NZ  LYS    27     -20.097  27.510   8.386  1.00 77.07           N  
ATOM    211  N   ASP    28     -14.003  27.317   6.792  1.00 76.84           N  
ATOM    212  CA  ASP    28     -14.027  27.772   5.401  1.00 77.59           C  
ATOM    213  C   ASP    28     -12.925  28.857   5.134  1.00 77.95           C  
ATOM    214  O   ASP    28     -13.183  29.840   4.426  1.00 78.11           O  
ATOM    215  CB  ASP    28     -15.426  28.300   5.088  1.00 78.53           C  
ATOM    216  CG  ASP    28     -16.548  27.225   5.257  1.00 81.48           C  
ATOM    217  OD1 ASP    28     -16.391  26.062   4.800  1.00 85.00           O  
ATOM    218  OD2 ASP    28     -17.619  27.580   5.817  1.00 84.66           O  
ATOM    219  N   LYS    29     -11.732  28.666   5.747  1.00 77.54           N  
ATOM    220  CA  LYS    29     -10.512  29.518   5.589  1.00 76.82           C  
ATOM    221  C   LYS    29     -10.553  30.922   6.239  1.00 76.10           C  
ATOM    222  O   LYS    29      -9.676  31.767   5.982  1.00 75.77           O  
ATOM    223  CB  LYS    29     -10.095  29.633   4.123  1.00 77.31           C  
ATOM    224  CG  LYS    29      -9.776  28.294   3.467  1.00 79.61           C  
ATOM    225  CD  LYS    29      -8.300  28.168   3.028  1.00 82.32           C  
ATOM    226  CE  LYS    29      -7.955  29.110   1.844  1.00 81.95           C  
ATOM    227  NZ  LYS    29      -7.050  28.464   0.864  1.00 81.33           N  
ATOM    228  N   LYS    30     -11.545  31.145   7.103  1.00 74.77           N  
ATOM    229  CA  LYS    30     -11.693  32.419   7.841  1.00 73.86           C  
ATOM    230  C   LYS    30     -11.796  32.163   9.320  1.00 70.12           C  
ATOM    231  O   LYS    30     -12.089  31.054   9.732  1.00 69.63           O  
ATOM    232  CB  LYS    30     -12.969  33.159   7.380  1.00 73.69           C  
ATOM    233  CG  LYS    30     -12.892  33.658   5.940  1.00 75.38           C  
ATOM    234  CD  LYS    30     -14.271  33.861   5.306  1.00 76.35           C  
ATOM    235  CE  LYS    30     -15.069  32.542   5.226  1.00 78.74           C  
ATOM    236  NZ  LYS    30     -15.844  32.376   3.939  1.00 79.28           N  
ATOM    237  N   THR    31     -11.594  33.207  10.111  1.00 66.89           N  
ATOM    238  CA  THR    31     -11.893  33.163  11.549  1.00 65.08           C  
ATOM    239  C   THR    31     -13.220  33.811  11.855  1.00 63.67           C  
ATOM    240  O   THR    31     -13.442  34.948  11.517  1.00 62.84           O  
ATOM    241  CB  THR    31     -10.816  33.875  12.386  1.00 64.71           C  
ATOM    242  OG1 THR    31      -9.580  33.234  12.126  1.00 62.99           O  
ATOM    243  CG2 THR    31     -11.127  33.820  13.897  1.00 63.56           C  
ATOM    244  N   TYR    32     -14.094  33.071  12.517  1.00 62.97           N  
ATOM    245  CA  TYR    32     -15.375  33.591  12.932  1.00 62.51           C  
ATOM    246  C   TYR    32     -15.293  33.820  14.416  1.00 61.62           C  
ATOM    247  O   TYR    32     -14.985  32.920  15.157  1.00 59.82           O  
ATOM    248  CB  TYR    32     -16.482  32.597  12.613  1.00 62.96           C  
ATOM    249  CG  TYR    32     -16.784  32.554  11.163  1.00 63.75           C  
ATOM    250  CD1 TYR    32     -16.112  31.659  10.310  1.00 64.37           C  
ATOM    251  CD2 TYR    32     -17.720  33.424  10.619  1.00 63.97           C  
ATOM    252  CE1 TYR    32     -16.372  31.623   8.960  1.00 63.90           C  
ATOM    253  CE2 TYR    32     -17.995  33.399   9.262  1.00 65.20           C  
ATOM    254  CZ  TYR    32     -17.315  32.500   8.435  1.00 64.90           C  
ATOM    255  OH  TYR    32     -17.603  32.502   7.092  1.00 66.11           O  
ATOM    256  N   VAL    33     -15.552  35.053  14.816  1.00 61.66           N  
ATOM    257  CA  VAL    33     -15.658  35.444  16.205  1.00 61.87           C  
ATOM    258  C   VAL    33     -17.151  35.415  16.578  1.00 62.05           C  
ATOM    259  O   VAL    33     -17.957  36.188  16.059  1.00 61.79           O  
ATOM    260  CB  VAL    33     -15.008  36.840  16.436  1.00 62.18           C  
ATOM    261  CG1 VAL    33     -14.848  37.108  17.914  1.00 61.84           C  
ATOM    262  CG2 VAL    33     -13.647  36.922  15.752  1.00 60.44           C  
ATOM    263  N   ASN    34     -17.497  34.469  17.451  1.00 62.63           N  
ATOM    264  CA  ASN    34     -18.843  34.272  17.968  1.00 62.74           C  
ATOM    265  C   ASN    34     -19.034  34.955  19.334  1.00 63.11           C  
ATOM    266  O   ASN    34     -18.592  34.446  20.374  1.00 62.77           O  
ATOM    267  CB  ASN    34     -19.123  32.787  18.102  1.00 62.29           C  
ATOM    268  CG  ASN    34     -19.303  32.091  16.759  1.00 63.83           C  
ATOM    269  OD1 ASN    34     -18.327  31.761  16.066  1.00 64.13           O  
ATOM    270  ND2 ASN    34     -20.564  31.825  16.410  1.00 61.91           N  
ATOM    271  N   ALA    35     -19.694  36.106  19.302  1.00 63.82           N  
ATOM    272  CA  ALA    35     -19.983  36.927  20.474  1.00 64.45           C  
ATOM    273  C   ALA    35     -21.436  36.713  20.877  1.00 66.13           C  
ATOM    274  O   ALA    35     -22.229  36.105  20.157  1.00 65.78           O  
ATOM    275  CB  ALA    35     -19.695  38.400  20.190  1.00 63.41           C  
ATOM    276  N   GLU    36     -21.795  37.194  22.050  1.00 68.62           N  
ATOM    277  CA  GLU    36     -23.081  36.813  22.627  1.00 71.28           C  
ATOM    278  C   GLU    36     -24.264  37.179  21.727  1.00 72.31           C  
ATOM    279  O   GLU    36     -25.229  36.416  21.623  1.00 72.56           O  
ATOM    280  CB  GLU    36     -23.270  37.459  23.986  1.00 71.27           C  
ATOM    281  CG  GLU    36     -22.296  37.014  25.046  1.00 72.06           C  
ATOM    282  CD  GLU    36     -22.437  37.838  26.279  1.00 72.04           C  
ATOM    283  OE1 GLU    36     -23.142  38.857  26.238  1.00 79.71           O  
ATOM    284  OE2 GLU    36     -21.848  37.506  27.306  1.00 76.93           O  
ATOM    285  N   GLU    37     -24.176  38.350  21.095  1.00 73.72           N  
ATOM    286  CA  GLU    37     -25.256  38.902  20.300  1.00 74.69           C  
ATOM    287  C   GLU    37     -24.968  38.923  18.809  1.00 73.94           C  
ATOM    288  O   GLU    37     -25.870  39.226  18.044  1.00 74.01           O  
ATOM    289  CB  GLU    37     -25.544  40.340  20.756  1.00 75.48           C  
ATOM    290  CG  GLU    37     -26.188  40.454  22.149  1.00 79.08           C  
ATOM    291  CD  GLU    37     -26.492  41.922  22.561  1.00 81.78           C  
ATOM    292  OE1 GLU    37     -26.163  42.870  21.779  1.00 88.35           O  
ATOM    293  OE2 GLU    37     -27.085  42.122  23.668  1.00 90.68           O  
ATOM    294  N   LEU    38     -23.731  38.686  18.375  1.00 73.06           N  
ATOM    295  CA  LEU    38     -23.468  38.604  16.936  1.00 72.61           C  
ATOM    296  C   LEU    38     -22.227  37.794  16.586  1.00 71.39           C  
ATOM    297  O   LEU    38     -21.450  37.416  17.461  1.00 70.69           O  
ATOM    298  CB  LEU    38     -23.486  39.992  16.249  1.00 72.94           C  
ATOM    299  CG  LEU    38     -22.409  41.099  16.273  1.00 74.37           C  
ATOM    300  CD1 LEU    38     -21.356  40.894  17.336  1.00 75.46           C  
ATOM    301  CD2 LEU    38     -21.758  41.268  14.892  1.00 76.18           C  
ATOM    302  N   THR    39     -22.104  37.494  15.295  1.00 69.92           N  
ATOM    303  CA  THR    39     -20.996  36.762  14.757  1.00 69.17           C  
ATOM    304  C   THR    39     -20.404  37.501  13.595  1.00 67.93           C  
ATOM    305  O   THR    39     -21.063  38.201  12.878  1.00 67.20           O  
ATOM    306  CB  THR    39     -21.369  35.320  14.401  1.00 69.41           C  
ATOM    307  OG1 THR    39     -21.821  34.687  15.605  1.00 71.60           O  
ATOM    308  CG2 THR    39     -20.108  34.536  13.876  1.00 69.54           C  
ATOM    309  N   GLY    40     -19.109  37.374  13.441  1.00 67.61           N  
ATOM    310  CA  GLY    40     -18.450  38.155  12.439  1.00 67.41           C  
ATOM    311  C   GLY    40     -17.090  37.590  12.170  1.00 66.88           C  
ATOM    312  O   GLY    40     -16.639  36.670  12.816  1.00 67.02           O  
ATOM    313  N   THR    41     -16.441  38.197  11.209  1.00 66.71           N  
ATOM    314  CA  THR    41     -15.244  37.685  10.614  1.00 66.20           C  
ATOM    315  C   THR    41     -14.079  38.538  11.166  1.00 65.32           C  
ATOM    316  O   THR    41     -14.253  39.725  11.501  1.00 64.33           O  
ATOM    317  CB  THR    41     -15.448  37.747   9.089  1.00 66.32           C  
ATOM    318  OG1 THR    41     -15.778  36.433   8.622  1.00 69.23           O  
ATOM    319  CG2 THR    41     -14.257  38.300   8.359  1.00 65.71           C  
ATOM    320  N   HIS    42     -12.924  37.902  11.318  1.00 64.06           N  
ATOM    321  CA  HIS    42     -11.723  38.584  11.690  1.00 63.72           C  
ATOM    322  C   HIS    42     -10.599  38.078  10.825  1.00 64.21           C  
ATOM    323  O   HIS    42     -10.583  36.908  10.461  1.00 64.45           O  
ATOM    324  CB  HIS    42     -11.367  38.369  13.166  1.00 63.65           C  
ATOM    325  CG  HIS    42     -10.449  39.428  13.691  1.00 62.41           C  
ATOM    326  ND1 HIS    42      -9.112  39.479  13.366  1.00 61.46           N  
ATOM    327  CD2 HIS    42     -10.691  40.528  14.442  1.00 62.93           C  
ATOM    328  CE1 HIS    42      -8.561  40.552  13.911  1.00 63.05           C  
ATOM    329  NE2 HIS    42      -9.496  41.203  14.578  1.00 62.92           N  
ATOM    330  N   LYS    43      -9.637  38.948  10.534  1.00 64.61           N  
ATOM    331  CA  LYS    43      -8.513  38.581   9.688  1.00 65.27           C  
ATOM    332  C   LYS    43      -7.419  37.763  10.375  1.00 64.45           C  
ATOM    333  O   LYS    43      -6.608  37.136   9.710  1.00 64.94           O  
ATOM    334  CB  LYS    43      -7.914  39.844   9.036  1.00 66.18           C  
ATOM    335  CG  LYS    43      -7.385  40.918  10.010  1.00 67.83           C  
ATOM    336  CD  LYS    43      -6.601  41.976   9.258  1.00 67.72           C  
ATOM    337  CE  LYS    43      -5.732  42.773  10.201  1.00 70.39           C  
ATOM    338  NZ  LYS    43      -5.356  44.057   9.555  1.00 73.82           N  
ATOM    339  N   TYR    44      -7.359  37.765  11.694  1.00 64.49           N  
ATOM    340  CA  TYR    44      -6.292  37.035  12.387  1.00 63.96           C  
ATOM    341  C   TYR    44      -6.623  35.581  12.476  1.00 62.69           C  
ATOM    342  O   TYR    44      -7.781  35.206  12.512  1.00 62.31           O  
ATOM    343  CB  TYR    44      -6.062  37.533  13.813  1.00 65.08           C  
ATOM    344  CG  TYR    44      -5.539  38.923  13.976  1.00 65.75           C  
ATOM    345  CD1 TYR    44      -4.940  39.618  12.936  1.00 67.27           C  
ATOM    346  CD2 TYR    44      -5.636  39.546  15.203  1.00 68.59           C  
ATOM    347  CE1 TYR    44      -4.483  40.907  13.114  1.00 67.96           C  
ATOM    348  CE2 TYR    44      -5.174  40.843  15.389  1.00 68.78           C  
ATOM    349  CZ  TYR    44      -4.605  41.505  14.348  1.00 67.12           C  
ATOM    350  OH  TYR    44      -4.168  42.776  14.566  1.00 68.22           O  
ATOM    351  N   SER    45      -5.580  34.766  12.551  1.00 61.92           N  
ATOM    352  CA  SER    45      -5.718  33.320  12.580  1.00 61.21           C  
ATOM    353  C   SER    45      -5.910  32.966  14.035  1.00 60.89           C  
ATOM    354  O   SER    45      -5.765  33.817  14.906  1.00 60.84           O  
ATOM    355  CB  SER    45      -4.449  32.643  12.015  1.00 60.63           C  
ATOM    356  OG  SER    45      -3.358  32.837  12.896  1.00 61.26           O  
ATOM    357  N   LEU    46      -6.241  31.710  14.294  1.00 60.97           N  
ATOM    358  CA  LEU    46      -6.426  31.228  15.652  1.00 60.86           C  
ATOM    359  C   LEU    46      -5.108  31.226  16.395  1.00 61.40           C  
ATOM    360  O   LEU    46      -5.046  31.396  17.627  1.00 61.30           O  
ATOM    361  CB  LEU    46      -7.046  29.836  15.640  1.00 60.45           C  
ATOM    362  CG  LEU    46      -8.517  29.710  15.243  1.00 59.06           C  
ATOM    363  CD1 LEU    46      -8.975  28.342  15.621  1.00 56.63           C  
ATOM    364  CD2 LEU    46      -9.441  30.795  15.873  1.00 56.73           C  
ATOM    365  N   GLN    47      -4.037  31.061  15.632  1.00 62.21           N  
ATOM    366  CA  GLN    47      -2.701  31.132  16.192  1.00 61.91           C  
ATOM    367  C   GLN    47      -2.410  32.553  16.709  1.00 61.17           C  
ATOM    368  O   GLN    47      -1.915  32.726  17.833  1.00 59.89           O  
ATOM    369  CB  GLN    47      -1.670  30.639  15.172  1.00 61.58           C  
ATOM    370  CG  GLN    47      -0.266  30.464  15.791  1.00 63.42           C  
ATOM    371  CD  GLN    47       0.842  30.263  14.748  1.00 64.22           C  
ATOM    372  OE1 GLN    47       1.908  29.738  15.056  1.00 70.90           O  
ATOM    373  NE2 GLN    47       0.603  30.713  13.533  1.00 65.38           N  
ATOM    374  N   GLU    48      -2.731  33.560  15.894  1.00 61.05           N  
ATOM    375  CA  GLU    48      -2.575  34.950  16.300  1.00 61.50           C  
ATOM    376  C   GLU    48      -3.455  35.319  17.491  1.00 60.76           C  
ATOM    377  O   GLU    48      -2.986  35.927  18.458  1.00 60.41           O  
ATOM    378  CB  GLU    48      -2.822  35.888  15.136  1.00 61.77           C  
ATOM    379  CG  GLU    48      -1.623  35.839  14.139  1.00 64.39           C  
ATOM    380  CD  GLU    48      -1.907  36.338  12.699  1.00 63.87           C  
ATOM    381  OE1 GLU    48      -3.074  36.414  12.227  1.00 63.24           O  
ATOM    382  OE2 GLU    48      -0.890  36.620  12.035  1.00 68.21           O  
ATOM    383  N   PHE    49      -4.719  34.943  17.442  1.00 60.08           N  
ATOM    384  CA  PHE    49      -5.592  35.133  18.596  1.00 59.74           C  
ATOM    385  C   PHE    49      -5.080  34.464  19.874  1.00 59.52           C  
ATOM    386  O   PHE    49      -5.273  34.997  20.948  1.00 59.32           O  
ATOM    387  CB  PHE    49      -7.025  34.672  18.295  1.00 59.41           C  
ATOM    388  CG  PHE    49      -7.869  35.716  17.645  1.00 58.45           C  
ATOM    389  CD1 PHE    49      -8.265  36.829  18.346  1.00 59.31           C  
ATOM    390  CD2 PHE    49      -8.277  35.583  16.337  1.00 59.28           C  
ATOM    391  CE1 PHE    49      -9.062  37.809  17.748  1.00 59.58           C  
ATOM    392  CE2 PHE    49      -9.071  36.546  15.743  1.00 58.97           C  
ATOM    393  CZ  PHE    49      -9.463  37.654  16.452  1.00 58.62           C  
ATOM    394  N   GLU    50      -4.438  33.309  19.785  1.00 59.90           N  
ATOM    395  CA  GLU    50      -3.891  32.692  20.993  1.00 60.98           C  
ATOM    396  C   GLU    50      -2.847  33.566  21.696  1.00 60.69           C  
ATOM    397  O   GLU    50      -2.687  33.525  22.913  1.00 61.09           O  
ATOM    398  CB  GLU    50      -3.245  31.350  20.681  1.00 61.30           C  
ATOM    399  CG  GLU    50      -4.198  30.209  20.578  1.00 62.87           C  
ATOM    400  CD  GLU    50      -3.463  28.877  20.628  1.00 63.39           C  
ATOM    401  OE1 GLU    50      -3.150  28.378  19.529  1.00 62.18           O  
ATOM    402  OE2 GLU    50      -3.203  28.357  21.763  1.00 64.88           O  
ATOM    403  N   TYR    51      -2.100  34.319  20.908  1.00 60.43           N  
ATOM    404  CA  TYR    51      -1.147  35.239  21.431  1.00 59.53           C  
ATOM    405  C   TYR    51      -1.873  36.419  22.104  1.00 58.87           C  
ATOM    406  O   TYR    51      -1.497  36.853  23.180  1.00 57.91           O  
ATOM    407  CB  TYR    51      -0.190  35.717  20.308  1.00 60.13           C  
ATOM    408  CG  TYR    51       0.664  36.911  20.739  1.00 60.63           C  
ATOM    409  CD1 TYR    51       1.815  36.725  21.527  1.00 60.30           C  
ATOM    410  CD2 TYR    51       0.271  38.213  20.442  1.00 59.27           C  
ATOM    411  CE1 TYR    51       2.575  37.801  21.974  1.00 60.07           C  
ATOM    412  CE2 TYR    51       1.015  39.298  20.886  1.00 60.70           C  
ATOM    413  CZ  TYR    51       2.179  39.093  21.652  1.00 61.51           C  
ATOM    414  OH  TYR    51       2.937  40.192  22.068  1.00 61.75           O  
ATOM    415  N   LEU    52      -2.928  36.927  21.484  1.00 59.17           N  
ATOM    416  CA  LEU    52      -3.469  38.211  21.913  1.00 59.78           C  
ATOM    417  C   LEU    52      -4.591  38.163  22.951  1.00 58.88           C  
ATOM    418  O   LEU    52      -4.808  39.121  23.689  1.00 58.40           O  
ATOM    419  CB  LEU    52      -3.838  39.056  20.705  1.00 59.99           C  
ATOM    420  CG  LEU    52      -5.137  38.900  19.986  1.00 62.34           C  
ATOM    421  CD1 LEU    52      -6.204  39.814  20.632  1.00 63.11           C  
ATOM    422  CD2 LEU    52      -4.889  39.263  18.464  1.00 61.78           C  
ATOM    423  N   LEU    53      -5.255  37.025  23.034  1.00 58.60           N  
ATOM    424  CA  LEU    53      -6.360  36.850  23.928  1.00 58.14           C  
ATOM    425  C   LEU    53      -5.816  36.464  25.279  1.00 58.30           C  
ATOM    426  O   LEU    53      -4.794  35.750  25.362  1.00 58.20           O  
ATOM    427  CB  LEU    53      -7.317  35.777  23.404  1.00 58.30           C  
ATOM    428  CG  LEU    53      -8.118  36.061  22.113  1.00 57.08           C  
ATOM    429  CD1 LEU    53      -8.762  34.777  21.657  1.00 51.00           C  
ATOM    430  CD2 LEU    53      -9.141  37.175  22.316  1.00 54.58           C  
ATOM    431  N   PRO    54      -6.464  36.963  26.348  1.00 58.29           N  
ATOM    432  CA  PRO    54      -6.008  36.686  27.722  1.00 58.90           C  
ATOM    433  C   PRO    54      -6.029  35.202  28.076  1.00 59.86           C  
ATOM    434  O   PRO    54      -7.042  34.531  27.929  1.00 60.64           O  
ATOM    435  CB  PRO    54      -6.971  37.490  28.613  1.00 58.39           C  
ATOM    436  CG  PRO    54      -7.991  38.073  27.727  1.00 58.75           C  
ATOM    437  CD  PRO    54      -7.626  37.865  26.299  1.00 57.84           C  
ATOM    438  N   LYS    55      -4.902  34.698  28.537  1.00 61.50           N  
ATOM    439  CA  LYS    55      -4.705  33.267  28.684  1.00 63.14           C  
ATOM    440  C   LYS    55      -5.491  32.742  29.909  1.00 62.48           C  
ATOM    441  O   LYS    55      -5.724  31.537  30.039  1.00 62.64           O  
ATOM    442  CB  LYS    55      -3.189  32.944  28.699  1.00 63.10           C  
ATOM    443  CG  LYS    55      -2.533  33.080  30.067  1.00 66.03           C  
ATOM    444  CD  LYS    55      -0.970  33.110  30.025  1.00 66.76           C  
ATOM    445  CE  LYS    55      -0.329  32.841  31.429  1.00 66.49           C  
ATOM    446  NZ  LYS    55      -1.178  33.499  32.466  1.00 68.77           N  
ATOM    447  N   ASP    56      -5.972  33.653  30.754  1.00 62.23           N  
ATOM    448  CA  ASP    56      -6.820  33.272  31.900  1.00 62.66           C  
ATOM    449  C   ASP    56      -8.286  32.924  31.528  1.00 62.28           C  
ATOM    450  O   ASP    56      -9.004  32.312  32.320  1.00 62.43           O  
ATOM    451  CB  ASP    56      -6.774  34.362  32.996  1.00 63.27           C  
ATOM    452  CG  ASP    56      -7.440  35.702  32.578  1.00 65.72           C  
ATOM    453  OD1 ASP    56      -7.542  36.045  31.388  1.00 71.06           O  
ATOM    454  OD2 ASP    56      -7.837  36.464  33.470  1.00 69.99           O  
ATOM    455  N   SER    57      -8.701  33.304  30.319  1.00 61.57           N  
ATOM    456  CA  SER    57     -10.084  33.188  29.870  1.00 60.88           C  
ATOM    457  C   SER    57     -10.259  32.343  28.635  1.00 59.81           C  
ATOM    458  O   SER    57     -11.243  31.649  28.501  1.00 59.87           O  
ATOM    459  CB  SER    57     -10.622  34.581  29.563  1.00 61.29           C  
ATOM    460  OG  SER    57     -11.419  35.015  30.614  1.00 62.81           O  
ATOM    461  N   PHE    58      -9.303  32.437  27.722  1.00 59.09           N  
ATOM    462  CA  PHE    58      -9.379  31.813  26.399  1.00 58.06           C  
ATOM    463  C   PHE    58      -8.452  30.610  26.317  1.00 57.54           C  
ATOM    464  O   PHE    58      -7.371  30.640  26.831  1.00 56.74           O  
ATOM    465  CB  PHE    58      -9.069  32.868  25.328  1.00 57.04           C  
ATOM    466  CG  PHE    58     -10.143  33.942  25.230  1.00 57.21           C  
ATOM    467  CD1 PHE    58     -10.055  35.107  25.979  1.00 58.12           C  
ATOM    468  CD2 PHE    58     -11.283  33.745  24.453  1.00 56.05           C  
ATOM    469  CE1 PHE    58     -11.056  36.083  25.917  1.00 56.66           C  
ATOM    470  CE2 PHE    58     -12.268  34.687  24.390  1.00 55.56           C  
ATOM    471  CZ  PHE    58     -12.160  35.864  25.123  1.00 57.10           C  
ATOM    472  N   ILE    59      -8.926  29.516  25.717  1.00 58.38           N  
ATOM    473  CA  ILE    59      -8.101  28.330  25.484  1.00 58.40           C  
ATOM    474  C   ILE    59      -8.378  27.708  24.119  1.00 57.04           C  
ATOM    475  O   ILE    59      -9.503  27.433  23.783  1.00 57.12           O  
ATOM    476  CB  ILE    59      -8.278  27.248  26.623  1.00 58.94           C  
ATOM    477  CG1 ILE    59      -7.242  26.113  26.455  1.00 59.95           C  
ATOM    478  CG2 ILE    59      -9.671  26.624  26.591  1.00 61.49           C  
ATOM    479  CD1 ILE    59      -7.061  25.222  27.673  1.00 59.51           C  
ATOM    480  N   ARG    60      -7.331  27.507  23.334  1.00 56.09           N  
ATOM    481  CA  ARG    60      -7.365  26.596  22.210  1.00 55.43           C  
ATOM    482  C   ARG    60      -7.704  25.167  22.655  1.00 55.43           C  
ATOM    483  O   ARG    60      -6.964  24.531  23.401  1.00 54.84           O  
ATOM    484  CB  ARG    60      -6.032  26.595  21.470  1.00 55.35           C  
ATOM    485  CG  ARG    60      -6.111  25.946  20.100  1.00 54.80           C  
ATOM    486  CD  ARG    60      -6.621  26.906  19.054  1.00 54.03           C  
ATOM    487  NE  ARG    60      -6.421  26.382  17.706  1.00 54.40           N  
ATOM    488  CZ  ARG    60      -5.341  26.570  16.948  1.00 54.54           C  
ATOM    489  NH1 ARG    60      -4.317  27.302  17.361  1.00 53.75           N  
ATOM    490  NH2 ARG    60      -5.306  26.062  15.726  1.00 52.56           N  
ATOM    491  N   CYS    61      -8.839  24.669  22.157  1.00 55.76           N  
ATOM    492  CA  CYS    61      -9.343  23.361  22.541  1.00 55.48           C  
ATOM    493  C   CYS    61      -9.510  22.395  21.380  1.00 55.23           C  
ATOM    494  O   CYS    61      -9.906  21.259  21.574  1.00 55.26           O  
ATOM    495  CB  CYS    61     -10.665  23.534  23.288  1.00 55.58           C  
ATOM    496  SG  CYS    61     -11.994  24.211  22.330  1.00 53.65           S  
ATOM    497  N   HIS    62      -9.165  22.841  20.182  1.00 55.99           N  
ATOM    498  CA  HIS    62      -9.402  22.100  18.952  1.00 56.21           C  
ATOM    499  C   HIS    62      -8.646  22.898  17.909  1.00 56.71           C  
ATOM    500  O   HIS    62      -8.516  24.087  18.073  1.00 56.13           O  
ATOM    501  CB  HIS    62     -10.904  22.123  18.682  1.00 55.80           C  
ATOM    502  CG  HIS    62     -11.360  21.244  17.560  1.00 55.15           C  
ATOM    503  ND1 HIS    62     -11.127  21.544  16.235  1.00 55.71           N  
ATOM    504  CD2 HIS    62     -12.114  20.120  17.563  1.00 55.19           C  
ATOM    505  CE1 HIS    62     -11.707  20.639  15.472  1.00 57.18           C  
ATOM    506  NE2 HIS    62     -12.324  19.768  16.249  1.00 56.36           N  
ATOM    507  N   ARG    63      -8.158  22.257  16.842  1.00 58.44           N  
ATOM    508  CA  ARG    63      -7.437  22.946  15.749  1.00 59.37           C  
ATOM    509  C   ARG    63      -8.257  24.034  15.090  1.00 58.79           C  
ATOM    510  O   ARG    63      -7.709  24.907  14.434  1.00 59.46           O  
ATOM    511  CB  ARG    63      -6.927  21.953  14.672  1.00 60.11           C  
ATOM    512  CG  ARG    63      -8.010  21.232  13.863  1.00 62.74           C  
ATOM    513  CD  ARG    63      -7.459  20.502  12.602  1.00 65.11           C  
ATOM    514  NE  ARG    63      -8.414  20.771  11.518  1.00 73.56           N  
ATOM    515  CZ  ARG    63      -8.179  21.504  10.427  1.00 75.10           C  
ATOM    516  NH1 ARG    63      -6.978  21.990  10.151  1.00 78.37           N  
ATOM    517  NH2 ARG    63      -9.161  21.719   9.573  1.00 74.99           N  
ATOM    518  N   SER    64      -9.564  23.969  15.261  1.00 58.15           N  
ATOM    519  CA  SER    64     -10.502  24.915  14.654  1.00 58.67           C  
ATOM    520  C   SER    64     -11.241  25.837  15.662  1.00 58.50           C  
ATOM    521  O   SER    64     -12.032  26.676  15.231  1.00 59.59           O  
ATOM    522  CB  SER    64     -11.533  24.110  13.832  1.00 58.55           C  
ATOM    523  OG  SER    64     -11.020  23.791  12.524  1.00 60.29           O  
ATOM    524  N   PHE    65     -10.976  25.713  16.971  1.00 58.22           N  
ATOM    525  CA  PHE    65     -11.703  26.480  18.006  1.00 58.03           C  
ATOM    526  C   PHE    65     -10.839  27.041  19.093  1.00 56.70           C  
ATOM    527  O   PHE    65      -9.964  26.344  19.638  1.00 56.67           O  
ATOM    528  CB  PHE    65     -12.742  25.606  18.710  1.00 59.19           C  
ATOM    529  CG  PHE    65     -13.870  25.194  17.825  1.00 60.22           C  
ATOM    530  CD1 PHE    65     -13.793  24.021  17.083  1.00 63.71           C  
ATOM    531  CD2 PHE    65     -15.010  25.995  17.713  1.00 60.70           C  
ATOM    532  CE1 PHE    65     -14.870  23.647  16.196  1.00 61.83           C  
ATOM    533  CE2 PHE    65     -16.064  25.636  16.875  1.00 62.73           C  
ATOM    534  CZ  PHE    65     -15.991  24.452  16.116  1.00 61.68           C  
ATOM    535  N   ILE    66     -11.110  28.306  19.428  1.00 55.10           N  
ATOM    536  CA  ILE    66     -10.716  28.874  20.707  1.00 53.34           C  
ATOM    537  C   ILE    66     -12.004  29.164  21.526  1.00 53.38           C  
ATOM    538  O   ILE    66     -12.942  29.786  21.037  1.00 51.87           O  
ATOM    539  CB  ILE    66      -9.875  30.163  20.574  1.00 54.09           C  
ATOM    540  CG1 ILE    66      -8.543  29.891  19.855  1.00 50.40           C  
ATOM    541  CG2 ILE    66      -9.676  30.826  21.994  1.00 54.22           C  
ATOM    542  CD1 ILE    66      -7.818  31.110  19.492  1.00 50.41           C  
ATOM    543  N   VAL    67     -12.046  28.673  22.766  1.00 53.17           N  
ATOM    544  CA  VAL    67     -13.202  28.885  23.634  1.00 53.52           C  
ATOM    545  C   VAL    67     -12.893  29.890  24.778  1.00 53.87           C  
ATOM    546  O   VAL    67     -11.735  29.980  25.302  1.00 54.47           O  
ATOM    547  CB  VAL    67     -13.762  27.510  24.166  1.00 53.86           C  
ATOM    548  CG1 VAL    67     -12.883  26.912  25.260  1.00 50.91           C  
ATOM    549  CG2 VAL    67     -15.235  27.649  24.669  1.00 53.80           C  
ATOM    550  N   ASN    68     -13.909  30.652  25.159  1.00 53.60           N  
ATOM    551  CA  ASN    68     -13.868  31.466  26.397  1.00 54.29           C  
ATOM    552  C   ASN    68     -14.450  30.636  27.529  1.00 54.17           C  
ATOM    553  O   ASN    68     -15.636  30.364  27.539  1.00 53.52           O  
ATOM    554  CB  ASN    68     -14.710  32.747  26.209  1.00 54.77           C  
ATOM    555  CG  ASN    68     -14.520  33.760  27.317  1.00 53.31           C  
ATOM    556  OD1 ASN    68     -14.120  33.424  28.392  1.00 54.57           O  
ATOM    557  ND2 ASN    68     -14.863  35.007  27.044  1.00 52.58           N  
ATOM    558  N   VAL    69     -13.618  30.273  28.499  1.00 54.85           N  
ATOM    559  CA  VAL    69     -14.043  29.415  29.612  1.00 55.43           C  
ATOM    560  C   VAL    69     -15.141  30.083  30.436  1.00 56.62           C  
ATOM    561  O   VAL    69     -15.870  29.393  31.166  1.00 58.19           O  
ATOM    562  CB  VAL    69     -12.846  28.968  30.530  1.00 55.37           C  
ATOM    563  CG1 VAL    69     -11.653  28.422  29.661  1.00 55.16           C  
ATOM    564  CG2 VAL    69     -12.377  30.090  31.405  1.00 55.08           C  
ATOM    565  N   ASN    70     -15.299  31.407  30.314  1.00 56.08           N  
ATOM    566  CA  ASN    70     -16.347  32.088  31.060  1.00 56.16           C  
ATOM    567  C   ASN    70     -17.726  31.956  30.477  1.00 56.59           C  
ATOM    568  O   ASN    70     -18.711  32.302  31.130  1.00 56.78           O  
ATOM    569  CB  ASN    70     -15.976  33.553  31.263  1.00 55.78           C  
ATOM    570  CG  ASN    70     -14.760  33.692  32.167  1.00 57.60           C  
ATOM    571  OD1 ASN    70     -14.802  33.308  33.352  1.00 58.65           O  
ATOM    572  ND2 ASN    70     -13.656  34.173  31.602  1.00 56.66           N  
ATOM    573  N   HIS    71     -17.804  31.474  29.237  1.00 57.27           N  
ATOM    574  CA  HIS    71     -19.077  31.130  28.622  1.00 56.72           C  
ATOM    575  C   HIS    71     -19.350  29.661  28.597  1.00 56.36           C  
ATOM    576  O   HIS    71     -20.374  29.254  28.104  1.00 57.18           O  
ATOM    577  CB  HIS    71     -19.166  31.719  27.246  1.00 57.35           C  
ATOM    578  CG  HIS    71     -19.139  33.203  27.259  1.00 57.90           C  
ATOM    579  ND1 HIS    71     -20.280  33.959  27.383  1.00 63.49           N  
ATOM    580  CD2 HIS    71     -18.109  34.078  27.214  1.00 60.53           C  
ATOM    581  CE1 HIS    71     -19.955  35.244  27.396  1.00 62.23           C  
ATOM    582  NE2 HIS    71     -18.639  35.341  27.291  1.00 62.98           N  
ATOM    583  N   ILE    72     -18.467  28.856  29.160  1.00 56.78           N  
ATOM    584  CA  ILE    72     -18.715  27.416  29.278  1.00 57.01           C  
ATOM    585  C   ILE    72     -19.716  27.212  30.391  1.00 58.60           C  
ATOM    586  O   ILE    72     -19.519  27.704  31.521  1.00 59.44           O  
ATOM    587  CB  ILE    72     -17.442  26.564  29.579  1.00 56.64           C  
ATOM    588  CG1 ILE    72     -16.472  26.602  28.392  1.00 55.81           C  
ATOM    589  CG2 ILE    72     -17.812  25.081  29.890  1.00 55.58           C  
ATOM    590  CD1 ILE    72     -15.142  25.972  28.642  1.00 54.02           C  
ATOM    591  N   LYS    73     -20.772  26.466  30.084  1.00 59.67           N  
ATOM    592  CA  LYS    73     -21.706  26.041  31.113  1.00 61.42           C  
ATOM    593  C   LYS    73     -21.262  24.704  31.775  1.00 60.69           C  
ATOM    594  O   LYS    73     -21.191  24.623  33.016  1.00 61.22           O  
ATOM    595  CB  LYS    73     -23.111  25.949  30.533  1.00 61.67           C  
ATOM    596  CG  LYS    73     -24.142  25.461  31.516  1.00 64.57           C  
ATOM    597  CD  LYS    73     -25.534  25.732  31.000  1.00 66.39           C  
ATOM    598  CE  LYS    73     -26.394  24.489  31.034  1.00 71.85           C  
ATOM    599  NZ  LYS    73     -27.081  24.405  32.361  1.00 75.78           N  
ATOM    600  N   ALA    74     -20.935  23.699  30.963  1.00 59.58           N  
ATOM    601  CA  ALA    74     -20.549  22.375  31.470  1.00 59.98           C  
ATOM    602  C   ALA    74     -19.606  21.709  30.482  1.00 59.82           C  
ATOM    603  O   ALA    74     -19.678  21.978  29.271  1.00 59.65           O  
ATOM    604  CB  ALA    74     -21.780  21.458  31.717  1.00 59.20           C  
ATOM    605  N   ILE    75     -18.718  20.867  31.024  1.00 59.52           N  
ATOM    606  CA  ILE    75     -17.764  20.066  30.280  1.00 60.03           C  
ATOM    607  C   ILE    75     -18.177  18.592  30.458  1.00 60.42           C  
ATOM    608  O   ILE    75     -18.284  18.096  31.585  1.00 59.74           O  
ATOM    609  CB  ILE    75     -16.303  20.229  30.794  1.00 60.12           C  
ATOM    610  CG1 ILE    75     -15.880  21.709  30.841  1.00 60.21           C  
ATOM    611  CG2 ILE    75     -15.338  19.325  29.978  1.00 58.97           C  
ATOM    612  CD1 ILE    75     -14.580  22.010  31.675  1.00 58.17           C  
ATOM    613  N   TYR    76     -18.381  17.912  29.331  1.00 61.43           N  
ATOM    614  CA  TYR    76     -18.799  16.505  29.281  1.00 62.33           C  
ATOM    615  C   TYR    76     -17.750  15.657  28.663  1.00 62.77           C  
ATOM    616  O   TYR    76     -17.159  16.044  27.674  1.00 61.86           O  
ATOM    617  CB  TYR    76     -20.067  16.365  28.420  1.00 64.04           C  
ATOM    618  CG  TYR    76     -21.249  17.027  29.074  1.00 64.55           C  
ATOM    619  CD1 TYR    76     -21.826  16.451  30.207  1.00 66.04           C  
ATOM    620  CD2 TYR    76     -21.780  18.217  28.590  1.00 64.45           C  
ATOM    621  CE1 TYR    76     -22.867  17.032  30.858  1.00 67.30           C  
ATOM    622  CE2 TYR    76     -22.879  18.804  29.232  1.00 64.89           C  
ATOM    623  CZ  TYR    76     -23.410  18.204  30.369  1.00 66.45           C  
ATOM    624  OH  TYR    76     -24.482  18.749  31.069  1.00 68.02           O  
ATOM    625  N   PRO    77     -17.504  14.483  29.243  1.00 64.19           N  
ATOM    626  CA  PRO    77     -16.632  13.542  28.528  1.00 65.35           C  
ATOM    627  C   PRO    77     -17.478  12.787  27.532  1.00 65.44           C  
ATOM    628  O   PRO    77     -18.058  11.803  27.890  1.00 65.52           O  
ATOM    629  CB  PRO    77     -16.077  12.640  29.644  1.00 64.99           C  
ATOM    630  CG  PRO    77     -17.099  12.714  30.759  1.00 64.32           C  
ATOM    631  CD  PRO    77     -17.955  13.963  30.548  1.00 64.28           C  
ATOM    632  N   ASP    78     -17.579  13.279  26.304  1.00 66.55           N  
ATOM    633  CA  ASP    78     -18.605  12.768  25.363  1.00 67.46           C  
ATOM    634  C   ASP    78     -18.200  11.397  24.815  1.00 68.08           C  
ATOM    635  O   ASP    78     -19.042  10.591  24.469  1.00 67.98           O  
ATOM    636  CB  ASP    78     -18.926  13.781  24.241  1.00 66.88           C  
ATOM    637  CG  ASP    78     -17.714  14.146  23.391  1.00 68.06           C  
ATOM    638  OD1 ASP    78     -16.610  14.309  23.934  1.00 69.21           O  
ATOM    639  OD2 ASP    78     -17.872  14.306  22.161  1.00 71.97           O  
ATOM    640  N   THR    79     -16.891  11.169  24.769  1.00 69.38           N  
ATOM    641  CA  THR    79     -16.302   9.900  24.417  1.00 69.80           C  
ATOM    642  C   THR    79     -15.089   9.708  25.342  1.00 71.24           C  
ATOM    643  O   THR    79     -14.815  10.525  26.225  1.00 71.66           O  
ATOM    644  CB  THR    79     -15.882   9.878  22.934  1.00 69.96           C  
ATOM    645  OG1 THR    79     -14.634  10.563  22.764  1.00 69.81           O  
ATOM    646  CG2 THR    79     -16.962  10.518  22.057  1.00 67.37           C  
ATOM    647  N   HIS    80     -14.357   8.624  25.156  1.00 72.15           N  
ATOM    648  CA  HIS    80     -13.262   8.321  26.067  1.00 72.09           C  
ATOM    649  C   HIS    80     -12.036   9.199  25.796  1.00 71.66           C  
ATOM    650  O   HIS    80     -11.197   9.380  26.680  1.00 71.54           O  
ATOM    651  CB  HIS    80     -12.905   6.838  25.952  1.00 74.54           C  
ATOM    652  CG  HIS    80     -12.424   6.435  24.588  1.00 77.71           C  
ATOM    653  ND1 HIS    80     -11.076   6.276  24.288  1.00 83.05           N  
ATOM    654  CD2 HIS    80     -13.105   6.163  23.443  1.00 82.06           C  
ATOM    655  CE1 HIS    80     -10.956   5.922  23.015  1.00 84.98           C  
ATOM    656  NE2 HIS    80     -12.172   5.846  22.480  1.00 84.43           N  
ATOM    657  N   SER    81     -11.942   9.770  24.582  1.00 70.35           N  
ATOM    658  CA  SER    81     -10.762  10.594  24.179  1.00 68.31           C  
ATOM    659  C   SER    81     -11.008  12.131  24.030  1.00 66.70           C  
ATOM    660  O   SER    81     -10.070  12.889  23.928  1.00 65.88           O  
ATOM    661  CB  SER    81     -10.207  10.050  22.870  1.00 67.88           C  
ATOM    662  OG  SER    81     -11.261   9.953  21.925  1.00 69.17           O  
ATOM    663  N   THR    82     -12.264  12.568  24.023  1.00 65.31           N  
ATOM    664  CA  THR    82     -12.635  13.963  23.752  1.00 63.25           C  
ATOM    665  C   THR    82     -13.548  14.516  24.859  1.00 62.65           C  
ATOM    666  O   THR    82     -14.080  13.751  25.698  1.00 62.99           O  
ATOM    667  CB  THR    82     -13.446  14.076  22.436  1.00 62.72           C  
ATOM    668  OG1 THR    82     -14.598  13.261  22.563  1.00 60.82           O  
ATOM    669  CG2 THR    82     -12.671  13.635  21.218  1.00 60.62           C  
ATOM    670  N   PHE    83     -13.745  15.848  24.839  1.00 60.99           N  
ATOM    671  CA  PHE    83     -14.822  16.516  25.603  1.00 58.92           C  
ATOM    672  C   PHE    83     -15.751  17.254  24.670  1.00 56.16           C  
ATOM    673  O   PHE    83     -15.435  17.547  23.530  1.00 54.69           O  
ATOM    674  CB  PHE    83     -14.277  17.502  26.651  1.00 59.27           C  
ATOM    675  CG  PHE    83     -13.275  16.897  27.611  1.00 59.80           C  
ATOM    676  CD1 PHE    83     -13.700  16.106  28.681  1.00 59.77           C  
ATOM    677  CD2 PHE    83     -11.904  17.127  27.454  1.00 60.92           C  
ATOM    678  CE1 PHE    83     -12.790  15.550  29.559  1.00 58.13           C  
ATOM    679  CE2 PHE    83     -10.990  16.583  28.347  1.00 59.35           C  
ATOM    680  CZ  PHE    83     -11.440  15.786  29.391  1.00 59.19           C  
ATOM    681  N   LEU    84     -16.918  17.556  25.185  1.00 53.95           N  
ATOM    682  CA  LEU    84     -17.848  18.373  24.479  1.00 53.17           C  
ATOM    683  C   LEU    84     -18.238  19.442  25.469  1.00 51.78           C  
ATOM    684  O   LEU    84     -18.518  19.129  26.641  1.00 52.43           O  
ATOM    685  CB  LEU    84     -19.058  17.527  24.077  1.00 53.53           C  
ATOM    686  CG  LEU    84     -19.986  17.984  23.007  1.00 53.39           C  
ATOM    687  CD1 LEU    84     -19.198  18.656  21.855  1.00 52.65           C  
ATOM    688  CD2 LEU    84     -20.822  16.736  22.567  1.00 53.10           C  
ATOM    689  N   LEU    85     -18.202  20.699  25.019  1.00 49.78           N  
ATOM    690  CA  LEU    85     -18.481  21.845  25.874  1.00 47.93           C  
ATOM    691  C   LEU    85     -19.883  22.320  25.598  1.00 47.39           C  
ATOM    692  O   LEU    85     -20.253  22.639  24.491  1.00 46.54           O  
ATOM    693  CB  LEU    85     -17.478  22.989  25.620  1.00 47.12           C  
ATOM    694  CG  LEU    85     -15.994  22.593  25.581  1.00 45.60           C  
ATOM    695  CD1 LEU    85     -15.078  23.803  25.371  1.00 36.85           C  
ATOM    696  CD2 LEU    85     -15.635  21.783  26.820  1.00 43.69           C  
ATOM    697  N   SER    86     -20.664  22.376  26.648  1.00 47.97           N  
ATOM    698  CA  SER    86     -21.970  23.000  26.640  1.00 48.07           C  
ATOM    699  C   SER    86     -21.781  24.472  26.939  1.00 45.91           C  
ATOM    700  O   SER    86     -21.316  24.814  28.027  1.00 45.30           O  
ATOM    701  CB  SER    86     -22.819  22.353  27.758  1.00 49.42           C  
ATOM    702  OG  SER    86     -24.209  22.619  27.619  1.00 55.91           O  
ATOM    703  N   MET    87     -22.133  25.339  25.988  1.00 44.13           N  
ATOM    704  CA  MET    87     -22.013  26.758  26.179  1.00 43.18           C  
ATOM    705  C   MET    87     -23.277  27.327  26.847  1.00 44.86           C  
ATOM    706  O   MET    87     -24.316  26.668  26.840  1.00 46.03           O  
ATOM    707  CB  MET    87     -21.706  27.472  24.867  1.00 42.05           C  
ATOM    708  CG  MET    87     -20.544  26.909  24.091  1.00 39.14           C  
ATOM    709  SD  MET    87     -18.853  26.839  25.025  0.65 32.51          SE  
ATOM    710  CE  MET    87     -18.588  28.706  25.170  1.00 25.61           C  
ATOM    711  N   ASP    88     -23.161  28.530  27.421  1.00 45.01           N  
ATOM    712  CA  ASP    88     -24.228  29.167  28.115  1.00 46.81           C  
ATOM    713  C   ASP    88     -25.432  29.481  27.224  1.00 47.90           C  
ATOM    714  O   ASP    88     -26.553  29.445  27.691  1.00 49.37           O  
ATOM    715  CB  ASP    88     -23.747  30.512  28.706  1.00 47.48           C  
ATOM    716  CG  ASP    88     -23.081  30.369  30.055  1.00 47.38           C  
ATOM    717  OD1 ASP    88     -23.214  29.307  30.694  1.00 48.80           O  
ATOM    718  OD2 ASP    88     -22.425  31.343  30.484  1.00 50.10           O  
ATOM    719  N   ASN    89     -25.211  29.867  25.973  1.00 48.07           N  
ATOM    720  CA  ASN    89     -26.304  30.126  25.034  1.00 47.90           C  
ATOM    721  C   ASN    89     -26.907  28.853  24.347  1.00 49.95           C  
ATOM    722  O   ASN    89     -27.642  28.968  23.413  1.00 50.38           O  
ATOM    723  CB  ASN    89     -25.798  31.069  23.958  1.00 45.44           C  
ATOM    724  CG  ASN    89     -24.879  30.381  22.963  1.00 39.40           C  
ATOM    725  OD1 ASN    89     -24.424  29.257  23.175  1.00 34.26           O  
ATOM    726  ND2 ASN    89     -24.603  31.048  21.883  1.00 29.72           N  
ATOM    727  N   GLY    90     -26.542  27.654  24.776  1.00 53.52           N  
ATOM    728  CA  GLY    90     -27.030  26.399  24.204  1.00 54.20           C  
ATOM    729  C   GLY    90     -26.150  25.776  23.133  1.00 56.18           C  
ATOM    730  O   GLY    90     -26.474  24.680  22.628  1.00 57.36           O  
ATOM    731  N   GLU    91     -25.073  26.457  22.720  1.00 56.93           N  
ATOM    732  CA  GLU    91     -24.254  25.886  21.631  1.00 56.95           C  
ATOM    733  C   GLU    91     -23.350  24.827  22.213  1.00 57.61           C  
ATOM    734  O   GLU    91     -23.290  24.685  23.431  1.00 58.02           O  
ATOM    735  CB  GLU    91     -23.433  26.916  20.890  1.00 56.78           C  
ATOM    736  CG  GLU    91     -24.264  28.017  20.270  1.00 57.08           C  
ATOM    737  CD  GLU    91     -23.401  28.924  19.417  1.00 57.47           C  
ATOM    738  OE1 GLU    91     -23.367  30.121  19.688  1.00 58.86           O  
ATOM    739  OE2 GLU    91     -22.730  28.435  18.479  1.00 59.86           O  
ATOM    740  N   ARG    92     -22.687  24.057  21.356  1.00 57.41           N  
ATOM    741  CA  ARG    92     -21.666  23.125  21.835  1.00 57.56           C  
ATOM    742  C   ARG    92     -20.394  23.313  21.051  1.00 56.61           C  
ATOM    743  O   ARG    92     -20.410  23.760  19.911  1.00 55.30           O  
ATOM    744  CB  ARG    92     -22.124  21.647  21.825  1.00 57.51           C  
ATOM    745  CG  ARG    92     -22.418  21.066  20.425  1.00 58.70           C  
ATOM    746  CD  ARG    92     -22.994  19.651  20.473  1.00 57.48           C  
ATOM    747  NE  ARG    92     -24.233  19.646  21.242  1.00 59.27           N  
ATOM    748  CZ  ARG    92     -25.438  19.980  20.770  1.00 57.86           C  
ATOM    749  NH1 ARG    92     -25.613  20.330  19.505  1.00 59.25           N  
ATOM    750  NH2 ARG    92     -26.483  19.936  21.573  1.00 52.87           N  
ATOM    751  N   VAL    93     -19.289  22.972  21.689  1.00 57.11           N  
ATOM    752  CA  VAL    93     -17.965  23.112  21.087  1.00 57.84           C  
ATOM    753  C   VAL    93     -17.180  21.874  21.437  1.00 58.17           C  
ATOM    754  O   VAL    93     -17.187  21.457  22.599  1.00 58.56           O  
ATOM    755  CB  VAL    93     -17.239  24.386  21.619  1.00 58.64           C  
ATOM    756  CG1 VAL    93     -15.810  24.448  21.084  1.00 58.11           C  
ATOM    757  CG2 VAL    93     -18.051  25.676  21.270  1.00 55.82           C  
ATOM    758  N   PRO    94     -16.515  21.252  20.444  1.00 58.02           N  
ATOM    759  CA  PRO    94     -15.689  20.114  20.763  1.00 57.04           C  
ATOM    760  C   PRO    94     -14.266  20.415  21.276  1.00 56.72           C  
ATOM    761  O   PRO    94     -13.595  21.314  20.812  1.00 55.21           O  
ATOM    762  CB  PRO    94     -15.623  19.371  19.431  1.00 56.88           C  
ATOM    763  CG  PRO    94     -15.728  20.410  18.407  1.00 56.55           C  
ATOM    764  CD  PRO    94     -16.513  21.540  18.998  1.00 58.06           C  
ATOM    765  N   VAL    95     -13.806  19.590  22.216  1.00 57.49           N  
ATOM    766  CA  VAL    95     -12.400  19.496  22.558  1.00 57.43           C  
ATOM    767  C   VAL    95     -11.897  18.200  21.906  1.00 57.84           C  
ATOM    768  O   VAL    95     -12.341  17.103  22.256  1.00 58.08           O  
ATOM    769  CB  VAL    95     -12.138  19.493  24.114  1.00 57.16           C  
ATOM    770  CG1 VAL    95     -10.658  19.644  24.393  1.00 56.72           C  
ATOM    771  CG2 VAL    95     -12.952  20.582  24.824  1.00 55.41           C  
ATOM    772  N   SER    96     -10.987  18.327  20.944  1.00 58.18           N  
ATOM    773  CA  SER    96     -10.524  17.194  20.222  1.00 57.67           C  
ATOM    774  C   SER    96      -9.576  16.357  21.065  1.00 59.98           C  
ATOM    775  O   SER    96      -9.000  16.821  22.069  1.00 61.04           O  
ATOM    776  CB  SER    96      -9.863  17.634  18.932  1.00 57.68           C  
ATOM    777  OG  SER    96      -8.690  18.397  19.113  1.00 54.88           O  
ATOM    778  N   GLN    97      -9.437  15.100  20.663  1.00 62.13           N  
ATOM    779  CA  GLN    97      -8.498  14.165  21.247  1.00 63.68           C  
ATOM    780  C   GLN    97      -7.093  14.711  21.379  1.00 63.20           C  
ATOM    781  O   GLN    97      -6.396  14.355  22.310  1.00 63.88           O  
ATOM    782  CB  GLN    97      -8.426  12.893  20.401  1.00 63.98           C  
ATOM    783  CG  GLN    97      -7.315  11.913  20.765  1.00 65.68           C  
ATOM    784  CD  GLN    97      -7.566  10.570  20.093  1.00 69.25           C  
ATOM    785  OE1 GLN    97      -7.594   9.510  20.746  1.00 77.40           O  
ATOM    786  NE2 GLN    97      -7.790  10.611  18.775  1.00 77.67           N  
ATOM    787  N   SER    98      -6.677  15.555  20.444  1.00 62.68           N  
ATOM    788  CA  SER    98      -5.321  15.990  20.399  1.00 62.54           C  
ATOM    789  C   SER    98      -5.065  17.182  21.349  1.00 62.49           C  
ATOM    790  O   SER    98      -3.925  17.399  21.797  1.00 63.19           O  
ATOM    791  CB  SER    98      -4.908  16.235  18.949  1.00 62.74           C  
ATOM    792  OG  SER    98      -4.721  17.590  18.659  1.00 66.44           O  
ATOM    793  N   TYR    99      -6.130  17.908  21.684  1.00 61.58           N  
ATOM    794  CA  TYR    99      -6.099  18.982  22.674  1.00 60.92           C  
ATOM    795  C   TYR    99      -6.635  18.599  24.064  1.00 60.08           C  
ATOM    796  O   TYR    99      -6.529  19.379  25.015  1.00 60.11           O  
ATOM    797  CB  TYR    99      -6.913  20.160  22.157  1.00 60.45           C  
ATOM    798  CG  TYR    99      -6.178  20.969  21.133  1.00 61.16           C  
ATOM    799  CD1 TYR    99      -6.142  20.577  19.804  1.00 61.60           C  
ATOM    800  CD2 TYR    99      -5.482  22.103  21.496  1.00 59.09           C  
ATOM    801  CE1 TYR    99      -5.481  21.325  18.881  1.00 61.32           C  
ATOM    802  CE2 TYR    99      -4.860  22.840  20.583  1.00 59.27           C  
ATOM    803  CZ  TYR    99      -4.861  22.464  19.287  1.00 60.11           C  
ATOM    804  OH  TYR    99      -4.169  23.214  18.389  1.00 62.07           O  
ATOM    805  N   ALA   100      -7.203  17.414  24.189  1.00 59.50           N  
ATOM    806  CA  ALA   100      -7.931  17.070  25.399  1.00 59.34           C  
ATOM    807  C   ALA   100      -7.050  17.117  26.668  1.00 59.43           C  
ATOM    808  O   ALA   100      -7.522  17.572  27.707  1.00 58.27           O  
ATOM    809  CB  ALA   100      -8.656  15.714  25.226  1.00 57.93           C  
ATOM    810  N   SER   101      -5.774  16.692  26.594  1.00 60.28           N  
ATOM    811  CA  SER   101      -4.890  16.751  27.798  1.00 60.88           C  
ATOM    812  C   SER   101      -4.494  18.138  28.204  1.00 60.03           C  
ATOM    813  O   SER   101      -4.503  18.456  29.387  1.00 60.35           O  
ATOM    814  CB  SER   101      -3.608  15.932  27.633  1.00 61.76           C  
ATOM    815  OG  SER   101      -3.970  14.573  27.408  1.00 65.08           O  
ATOM    816  N   TYR   102      -4.134  18.944  27.213  1.00 59.68           N  
ATOM    817  CA  TYR   102      -3.797  20.350  27.403  1.00 59.73           C  
ATOM    818  C   TYR   102      -5.014  21.030  27.984  1.00 59.63           C  
ATOM    819  O   TYR   102      -4.918  21.703  28.992  1.00 59.77           O  
ATOM    820  CB  TYR   102      -3.347  20.956  26.057  1.00 60.33           C  
ATOM    821  CG  TYR   102      -3.183  22.451  25.981  1.00 60.01           C  
ATOM    822  CD1 TYR   102      -2.045  23.086  26.447  1.00 60.73           C  
ATOM    823  CD2 TYR   102      -4.178  23.235  25.376  1.00 62.93           C  
ATOM    824  CE1 TYR   102      -1.932  24.485  26.353  1.00 61.97           C  
ATOM    825  CE2 TYR   102      -4.077  24.605  25.265  1.00 60.78           C  
ATOM    826  CZ  TYR   102      -2.961  25.230  25.733  1.00 61.47           C  
ATOM    827  OH  TYR   102      -2.924  26.614  25.611  1.00 61.28           O  
ATOM    828  N   PHE   103      -6.186  20.787  27.401  1.00 58.87           N  
ATOM    829  CA  PHE   103      -7.393  21.423  27.906  1.00 58.44           C  
ATOM    830  C   PHE   103      -7.610  21.102  29.395  1.00 58.43           C  
ATOM    831  O   PHE   103      -7.761  21.995  30.191  1.00 57.76           O  
ATOM    832  CB  PHE   103      -8.614  21.024  27.056  1.00 57.19           C  
ATOM    833  CG  PHE   103      -9.893  21.695  27.462  1.00 57.46           C  
ATOM    834  CD1 PHE   103     -10.193  22.988  27.016  1.00 58.39           C  
ATOM    835  CD2 PHE   103     -10.785  21.066  28.302  1.00 54.61           C  
ATOM    836  CE1 PHE   103     -11.359  23.605  27.359  1.00 54.93           C  
ATOM    837  CE2 PHE   103     -11.956  21.670  28.670  1.00 53.26           C  
ATOM    838  CZ  PHE   103     -12.261  22.937  28.187  1.00 55.72           C  
ATOM    839  N   ARG   104      -7.637  19.834  29.774  1.00 59.22           N  
ATOM    840  CA  ARG   104      -7.950  19.494  31.162  1.00 60.00           C  
ATOM    841  C   ARG   104      -6.859  19.893  32.152  1.00 60.47           C  
ATOM    842  O   ARG   104      -7.148  20.233  33.297  1.00 59.73           O  
ATOM    843  CB  ARG   104      -8.299  18.011  31.298  1.00 59.80           C  
ATOM    844  CG  ARG   104      -7.128  17.081  31.373  1.00 59.77           C  
ATOM    845  CD  ARG   104      -7.547  15.631  31.419  1.00 59.52           C  
ATOM    846  NE  ARG   104      -8.482  15.391  32.508  1.00 59.77           N  
ATOM    847  CZ  ARG   104      -9.353  14.386  32.582  1.00 60.33           C  
ATOM    848  NH1 ARG   104      -9.450  13.478  31.628  1.00 61.97           N  
ATOM    849  NH2 ARG   104     -10.167  14.309  33.614  1.00 62.23           N  
ATOM    850  N   LYS   105      -5.604  19.865  31.698  1.00 62.10           N  
ATOM    851  CA  LYS   105      -4.470  20.312  32.517  1.00 63.34           C  
ATOM    852  C   LYS   105      -4.582  21.811  32.887  1.00 62.97           C  
ATOM    853  O   LYS   105      -4.444  22.184  34.047  1.00 62.68           O  
ATOM    854  CB  LYS   105      -3.128  20.027  31.812  1.00 64.24           C  
ATOM    855  CG  LYS   105      -2.427  18.736  32.260  1.00 66.61           C  
ATOM    856  CD  LYS   105      -1.311  18.291  31.238  1.00 68.13           C  
ATOM    857  CE  LYS   105      -0.252  17.240  31.780  1.00 70.28           C  
ATOM    858  NZ  LYS   105       1.029  17.832  32.420  1.00 70.83           N  
ATOM    859  N   LEU   106      -4.834  22.641  31.883  1.00 62.79           N  
ATOM    860  CA  LEU   106      -4.997  24.068  32.057  1.00 63.04           C  
ATOM    861  C   LEU   106      -6.188  24.423  32.910  1.00 62.22           C  
ATOM    862  O   LEU   106      -6.162  25.437  33.602  1.00 62.09           O  
ATOM    863  CB  LEU   106      -5.076  24.795  30.700  1.00 62.74           C  
ATOM    864  CG  LEU   106      -3.709  25.365  30.317  1.00 64.99           C  
ATOM    865  CD1 LEU   106      -2.561  24.315  30.481  1.00 67.46           C  
ATOM    866  CD2 LEU   106      -3.670  25.949  28.926  1.00 64.48           C  
ATOM    867  N   LEU   107      -7.233  23.619  32.843  1.00 61.85           N  
ATOM    868  CA  LEU   107      -8.463  23.878  33.588  1.00 61.64           C  
ATOM    869  C   LEU   107      -8.471  23.158  34.946  1.00 60.91           C  
ATOM    870  O   LEU   107      -9.338  23.387  35.776  1.00 60.53           O  
ATOM    871  CB  LEU   107      -9.697  23.514  32.736  1.00 61.95           C  
ATOM    872  CG  LEU   107     -10.266  24.672  31.899  1.00 65.01           C  
ATOM    873  CD1 LEU   107      -9.536  24.876  30.576  1.00 66.58           C  
ATOM    874  CD2 LEU   107     -11.706  24.443  31.610  1.00 62.97           C  
ATOM    875  N   GLY   108      -7.511  22.273  35.159  1.00 61.07           N  
ATOM    876  CA  GLY   108      -7.292  21.663  36.452  1.00 61.13           C  
ATOM    877  C   GLY   108      -8.218  20.536  36.869  1.00 61.63           C  
ATOM    878  O   GLY   108      -8.499  20.447  38.068  1.00 62.09           O  
ATOM    879  N   PHE   109      -8.649  19.662  35.931  1.00 60.70           N  
ATOM    880  CA  PHE   109      -9.548  18.522  36.261  1.00 60.08           C  
ATOM    881  C   PHE   109      -9.140  17.140  35.727  1.00 59.62           C  
ATOM    882  O   PHE   109      -8.160  17.063  34.987  1.00 61.02           O  
ATOM    883  CB  PHE   109     -10.971  18.842  35.853  1.00 59.83           C  
ATOM    884  CG  PHE   109     -11.195  18.905  34.371  1.00 58.91           C  
ATOM    885  CD1 PHE   109     -11.609  17.796  33.678  1.00 57.22           C  
ATOM    886  CD2 PHE   109     -11.047  20.087  33.688  1.00 57.96           C  
ATOM    887  CE1 PHE   109     -11.843  17.866  32.347  1.00 59.48           C  
ATOM    888  CE2 PHE   109     -11.274  20.147  32.342  1.00 57.93           C  
ATOM    889  CZ  PHE   109     -11.683  19.047  31.674  1.00 59.32           C  
END
