
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  196 ( 1495),  selected  196 , name 2bwj_A
# Molecule2: number of CA atoms  232 ( 1859),  selected  232 , name T0416_6_115_194_315.pdb
# PARAMETERS: 2bwj_A.T0416_6_115_194_315.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_A      -       -           -
LGA    F     4_A      -       -           -
LGA    M     5_A      -       -           -
LGA    E     6_A      -       -           -
LGA    D     7_A      -       -           -
LGA    L     8_A      -       -           -
LGA    R     9_A      -       -           -
LGA    K    10_A      K       6          2.337
LGA    C    11_A      P       7          1.758
LGA    K    12_A      F       8          0.983
LGA    I    13_A      L       9          1.238
LGA    I    14_A      I      10          2.006
LGA    F    15_A      V      11          1.832
LGA    I    16_A      I      12          1.582
LGA    I    17_A      V      13          1.433
LGA    G    18_A      G      14          0.619
LGA    G    19_A      P      15          1.014
LGA    P    20_A      T      16          1.827
LGA    G    21_A      A      17          3.345
LGA    S    22_A      S      18          1.724
LGA    G    23_A      G      19          1.353
LGA    K    24_A      K      20          0.983
LGA    G    25_A      T      21          0.994
LGA    T    26_A      E      22          0.951
LGA    Q    27_A      L      23          0.916
LGA    C    28_A      S      24          0.833
LGA    E    29_A      I      25          1.062
LGA    K    30_A      E      26          0.779
LGA    L    31_A      V      27          0.911
LGA    V    32_A      A      28          0.608
LGA    E    33_A      K      29          0.649
LGA    K    34_A      K      30          0.830
LGA    Y    35_A      F      31          1.362
LGA    G    36_A      N      32          1.570
LGA    F    37_A      G      33          2.147
LGA    T    38_A      E      34          2.014
LGA    H    39_A      I      35          1.220
LGA    L    40_A      I      36          0.982
LGA    S    41_A      S      37          1.659
LGA    T    42_A      G      38          3.149
LGA    G    43_A      D      39          3.503
LGA    E    44_A      S      40           -
LGA    L    45_A      M      41           -
LGA    -       -      Q      42           -
LGA    L    46_A      V      43          3.035
LGA    -       -      Y      44           -
LGA    -       -      Q      45           -
LGA    -       -      G      46           -
LGA    -       -      M      47           -
LGA    -       -      D      48           -
LGA    -       -      I      49           -
LGA    -       -      G      50           -
LGA    -       -      T      51           -
LGA    -       -      A      52           -
LGA    -       -      K      53           -
LGA    -       -      V      54           -
LGA    -       -      T      55           -
LGA    -       -      T      56           -
LGA    -       -      E      57           -
LGA    -       -      E      58           -
LGA    -       -      M      59           -
LGA    -       -      E      60           -
LGA    -       -      G      61           -
LGA    -       -      I      62           -
LGA    -       -      P      63           -
LGA    -       -      X      64           -
LGA    -       -      Y      65           -
LGA    -       -      M      66           -
LGA    R    47_A      I      67          3.402
LGA    E    48_A      D      68          4.256
LGA    E    49_A      I      69          3.054
LGA    L    50_A      L      70          1.879
LGA    A    51_A      P      71           #
LGA    S    52_A      P      72           -
LGA    E    53_A      -       -           -
LGA    S    54_A      -       -           -
LGA    E    55_A      -       -           -
LGA    R    56_A      -       -           -
LGA    S    57_A      -       -           -
LGA    K    58_A      -       -           -
LGA    L    59_A      -       -           -
LGA    I    60_A      D      73           #
LGA    R    61_A      A      74          1.083
LGA    D    62_A      -       -           -
LGA    I    63_A      S      75          2.687
LGA    M    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    R    66_A      -       -           -
LGA    G    67_A      -       -           -
LGA    D    68_A      -       -           -
LGA    L    69_A      -       -           -
LGA    V    70_A      F      76          2.579
LGA    P    71_A      S      77          2.942
LGA    S    72_A      A      78          2.431
LGA    G    73_A      Y      79          2.248
LGA    I    74_A      E      80          1.338
LGA    V    75_A      F      81          1.242
LGA    L    76_A      K      82          0.894
LGA    E    77_A      K      83          0.968
LGA    L    78_A      R      84          0.859
LGA    L    79_A      A      85          0.481
LGA    K    80_A      E      86          1.434
LGA    E    81_A      K      87          1.921
LGA    A    82_A      Y      88          1.436
LGA    M    83_A      I      89          1.666
LGA    V    84_A      K      90          2.561
LGA    A    85_A      D      91          2.408
LGA    S    86_A      I      92          1.681
LGA    L    87_A      T      93          2.452
LGA    G    88_A      R      94          2.586
LGA    D    89_A      R      95          2.280
LGA    -       -      G      96           -
LGA    T    90_A      K      97          0.754
LGA    R    91_A      V      98          2.843
LGA    G    92_A      -       -           -
LGA    F    93_A      P      99          1.903
LGA    L    94_A      I     100          1.692
LGA    I    95_A      I     101          1.661
LGA    D    96_A      A     102          2.087
LGA    G    97_A      G     103          2.477
LGA    Y    98_A      G     104          3.463
LGA    -       -      T     105           -
LGA    -       -      G     106           -
LGA    -       -      L     107           -
LGA    P    99_A      Y     108          3.005
LGA    R   100_A      I     109          4.956
LGA    E   101_A      Q     110          5.568
LGA    V   102_A      -       -           -
LGA    K   103_A      -       -           -
LGA    Q   104_A      S     111          1.663
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    E   107_A      L     112           #
LGA    F   108_A      L     113          3.797
LGA    G   109_A      Y     114          2.786
LGA    R   110_A      N     115          3.189
LGA    R   111_A      -       -           -
LGA    I   112_A      E     194           #
LGA    G   113_A      N     195          1.527
LGA    D   114_A      Y     196          2.742
LGA    P   115_A      D     197          3.989
LGA    Q   116_A      T     198          2.737
LGA    L   117_A      L     199          1.690
LGA    V   118_A      L     200          1.110
LGA    I   119_A      I     201          0.450
LGA    C   120_A      G     202          1.393
LGA    M   121_A      I     203          0.696
LGA    D   122_A      E     204          0.666
LGA    C   123_A      M     205          1.339
LGA    S   124_A      S     206          1.945
LGA    A   125_A      R     207          2.662
LGA    D   126_A      E     208          2.379
LGA    T   127_A      T     209          1.729
LGA    M   128_A      L     210          2.655
LGA    T   129_A      Y     211          3.151
LGA    N   130_A      L     212          3.033
LGA    R   131_A      R     213          2.982
LGA    L   132_A      I     214          3.670
LGA    L   133_A      N     215          4.220
LGA    Q   134_A      K     216          4.189
LGA    M   135_A      R     217          4.041
LGA    -       -      V     218           -
LGA    S   136_A      D     219          2.725
LGA    R   137_A      I     220          2.865
LGA    -       -      M     221           -
LGA    S   138_A      L     222          2.857
LGA    S   139_A      G     223           #
LGA    -       -      X     224           -
LGA    -       -      G     225           -
LGA    -       -      L     226           -
LGA    -       -      F     227           -
LGA    -       -      N     228           -
LGA    -       -      E     229           -
LGA    -       -      V     230           -
LGA    -       -      Q     231           -
LGA    -       -      X     232           -
LGA    -       -      L     233           -
LGA    -       -      V     234           -
LGA    -       -      E     235           -
LGA    -       -      Q     236           -
LGA    -       -      G     237           -
LGA    -       -      F     238           -
LGA    -       -      E     239           -
LGA    -       -      A     240           -
LGA    -       -      S     241           -
LGA    -       -      Q     242           -
LGA    -       -      S     243           -
LGA    -       -      M     244           -
LGA    -       -      Q     245           -
LGA    -       -      A     246           -
LGA    -       -      I     247           -
LGA    -       -      G     248           -
LGA    -       -      Y     249           -
LGA    -       -      K     250           -
LGA    -       -      E     251           -
LGA    -       -      L     252           -
LGA    -       -      V     253           -
LGA    -       -      P     254           -
LGA    -       -      V     255           -
LGA    -       -      I     256           -
LGA    -       -      K     257           -
LGA    -       -      G     258           -
LGA    -       -      N     259           -
LGA    -       -      I     260           -
LGA    -       -      S     261           -
LGA    L   140_A      M     262          5.684
LGA    P   141_A      E     263          5.566
LGA    V   142_A      N     264           -
LGA    D   143_A      A     265           -
LGA    D   144_A      V     266          4.026
LGA    T   145_A      -       -           -
LGA    T   146_A      E     267          5.932
LGA    K   147_A      K     268          4.763
LGA    T   148_A      L     269          2.462
LGA    I   149_A      K     270          2.792
LGA    A   150_A      Q     271          3.451
LGA    K   151_A      X     272          1.871
LGA    R   152_A      S     273          1.738
LGA    L   153_A      R     274          3.219
LGA    E   154_A      Q     275          1.866
LGA    A   155_A      Y     276          1.633
LGA    Y   156_A      A     277          2.958
LGA    Y   157_A      K     278          3.080
LGA    R   158_A      R     279          2.477
LGA    A   159_A      Q     280          3.386
LGA    S   160_A      L     281          4.215
LGA    I   161_A      T     282          2.734
LGA    P   162_A      W     283          3.028
LGA    V   163_A      F     284          3.901
LGA    I   164_A      K     285          3.532
LGA    A   165_A      N     286          2.718
LGA    Y   166_A      K     287          2.686
LGA    Y   167_A      M     288          2.735
LGA    E   168_A      N     289          2.220
LGA    T   169_A      -       -           -
LGA    K   170_A      -       -           -
LGA    T   171_A      -       -           -
LGA    Q   172_A      -       -           -
LGA    L   173_A      V     290          3.100
LGA    H   174_A      X     291          1.243
LGA    K   175_A      W     292          1.108
LGA    I   176_A      L     293          0.433
LGA    N   177_A      N     294          0.780
LGA    A   178_A      K     295          1.062
LGA    E   179_A      E     296          1.637
LGA    G   180_A      R     297          3.529
LGA    -       -      M     298           -
LGA    T   181_A      S     299          3.176
LGA    P   182_A      L     300          2.736
LGA    E   183_A      Q     301          2.761
LGA    D   184_A      M     302          2.720
LGA    V   185_A      M     303          3.061
LGA    F   186_A      L     304          2.896
LGA    L   187_A      D     305          2.958
LGA    Q   188_A      E     306          2.809
LGA    L   189_A      I     307          3.305
LGA    C   190_A      T     308          2.784
LGA    T   191_A      T     309          3.127
LGA    A   192_A      Q     310          3.527
LGA    I   193_A      I     311          3.504
LGA    D   194_A      N     312          3.228
LGA    S   195_A      -       -           -
LGA    I   196_A      K     313          4.157
LGA    F   197_A      R     314          1.766
LGA    L   198_A      S     315          3.812

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  196  232    5.0    153    2.63    15.03     40.450     5.599

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.114049 * X  +  -0.776678 * Y  +  -0.619487 * Z  +  31.483562
  Y_new =   0.498875 * X  +   0.494466 * Y  +  -0.711778 * Z  + -40.442822
  Z_new =   0.859137 * X  +  -0.390224 * Y  +   0.331071 * Z  + -47.325439 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.867224    2.274369  [ DEG:   -49.6883    130.3117 ]
  Theta =  -1.033581   -2.108011  [ DEG:   -59.2199   -120.7801 ]
  Phi   =   1.795547   -1.346045  [ DEG:   102.8773    -77.1227 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bwj_A                                        
REMARK     2: T0416_6_115_194_315.pdb                       
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bwj_A.T0416_6_115_194_315.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  196  232   5.0  153   2.63   15.03  40.450
REMARK  ---------------------------------------------------------- 
MOLECULE 2bwj_A
HEADER    TRANSFERASE                             14-JUL-05   2BWJ              
TITLE     STRUCTURE OF ADENYLATE KINASE 5                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ADENYLATE KINASE 5;                                        
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: ATP-AMP, TRANSPHOSPHORYLASE5;                               
COMPND   5 EC: 2.7.4.3;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   5 EXPRESSION_SYSTEM_CELL_LINE: DE3;                                    
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PLIC-SGC                                  
KEYWDS    ADENYLATE KINASE, PHOSPHORYL TRANSFER REACTION, TRANSFERASE           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    G.BUNKOCZI,P.FILIPPAKOPOULOS,O.FEDOROV,A.JANSSON,E.LONGMAN,           
AUTHOR   2 E.UGOCHUKWU,S.KNAPP,F.VON DELFT,C.ARROWSMITH,A.EDWARDS,              
AUTHOR   3 M.SUNDSTROM,J.WEIGELT                                                
REVDAT   1   21-JUL-05 2BWJ    0                                                
JRNL        AUTH   P.FILIPPAKOPOULOS,G.BUNKOCZI,A.JANSSON,E.LONGMAN,            
JRNL        AUTH 2 S.KNAPP                                                      
JRNL        TITL   STRUCTURE OF ADENYLATE KINASE 5                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2BWJ A    0     0  UNP    Q9Y6K8   KAD5_HUMAN       0      0             
DBREF  2BWJ A    1   197  UNP    Q9Y6K8   KAD5_HUMAN     340    536             
DBREF  2BWJ A  198   198  UNP    Q9Y6K8   KAD5_HUMAN     198    198             
DBREF  2BWJ B    0     0  UNP    Q9Y6K8   KAD5_HUMAN       0      0             
DBREF  2BWJ B    1   197  UNP    Q9Y6K8   KAD5_HUMAN     340    536             
DBREF  2BWJ B  198   198  UNP    Q9Y6K8   KAD5_HUMAN     198    198             
DBREF  2BWJ C    0     0  UNP    Q9Y6K8   KAD5_HUMAN       0      0             
DBREF  2BWJ C    1   197  UNP    Q9Y6K8   KAD5_HUMAN     340    536             
DBREF  2BWJ C  198   198  UNP    Q9Y6K8   KAD5_HUMAN     198    198             
DBREF  2BWJ D    0     0  UNP    Q9Y6K8   KAD5_HUMAN       0      0             
DBREF  2BWJ D    1   197  UNP    Q9Y6K8   KAD5_HUMAN     340    536             
DBREF  2BWJ D  198   198  UNP    Q9Y6K8   KAD5_HUMAN     198    198             
DBREF  2BWJ E    0     0  UNP    Q9Y6K8   KAD5_HUMAN       0      0             
DBREF  2BWJ E    1   197  UNP    Q9Y6K8   KAD5_HUMAN     340    536             
DBREF  2BWJ E  198   198  UNP    Q9Y6K8   KAD5_HUMAN     198    198             
DBREF  2BWJ F    0     0  UNP    Q9Y6K8   KAD5_HUMAN       0      0             
DBREF  2BWJ F    1   197  UNP    Q9Y6K8   KAD5_HUMAN     340    536             
DBREF  2BWJ F  198   198  UNP    Q9Y6K8   KAD5_HUMAN     198    198             
SEQRES   1 A  199  SER MET GLY GLY PHE MET GLU ASP LEU ARG LYS CYS LYS          
SEQRES   2 A  199  ILE ILE PHE ILE ILE GLY GLY PRO GLY SER GLY LYS GLY          
SEQRES   3 A  199  THR GLN CYS GLU LYS LEU VAL GLU LYS TYR GLY PHE THR          
SEQRES   4 A  199  HIS LEU SER THR GLY GLU LEU LEU ARG GLU GLU LEU ALA          
SEQRES   5 A  199  SER GLU SER GLU ARG SER LYS LEU ILE ARG ASP ILE MET          
SEQRES   6 A  199  GLU ARG GLY ASP LEU VAL PRO SER GLY ILE VAL LEU GLU          
SEQRES   7 A  199  LEU LEU LYS GLU ALA MET VAL ALA SER LEU GLY ASP THR          
SEQRES   8 A  199  ARG GLY PHE LEU ILE ASP GLY TYR PRO ARG GLU VAL LYS          
SEQRES   9 A  199  GLN GLY GLU GLU PHE GLY ARG ARG ILE GLY ASP PRO GLN          
SEQRES  10 A  199  LEU VAL ILE CYS MET ASP CYS SER ALA ASP THR MET THR          
SEQRES  11 A  199  ASN ARG LEU LEU GLN MET SER ARG SER SER LEU PRO VAL          
SEQRES  12 A  199  ASP ASP THR THR LYS THR ILE ALA LYS ARG LEU GLU ALA          
SEQRES  13 A  199  TYR TYR ARG ALA SER ILE PRO VAL ILE ALA TYR TYR GLU          
SEQRES  14 A  199  THR LYS THR GLN LEU HIS LYS ILE ASN ALA GLU GLY THR          
SEQRES  15 A  199  PRO GLU ASP VAL PHE LEU GLN LEU CYS THR ALA ILE ASP          
SEQRES  16 A  199  SER ILE PHE LEU                                              
SEQRES   1 B  199  SER MET GLY GLY PHE MET GLU ASP LEU ARG LYS CYS LYS          
SEQRES   2 B  199  ILE ILE PHE ILE ILE GLY GLY PRO GLY SER GLY LYS GLY          
SEQRES   3 B  199  THR GLN CYS GLU LYS LEU VAL GLU LYS TYR GLY PHE THR          
SEQRES   4 B  199  HIS LEU SER THR GLY GLU LEU LEU ARG GLU GLU LEU ALA          
SEQRES   5 B  199  SER GLU SER GLU ARG SER LYS LEU ILE ARG ASP ILE MET          
SEQRES   6 B  199  GLU ARG GLY ASP LEU VAL PRO SER GLY ILE VAL LEU GLU          
SEQRES   7 B  199  LEU LEU LYS GLU ALA MET VAL ALA SER LEU GLY ASP THR          
SEQRES   8 B  199  ARG GLY PHE LEU ILE ASP GLY TYR PRO ARG GLU VAL LYS          
SEQRES   9 B  199  GLN GLY GLU GLU PHE GLY ARG ARG ILE GLY ASP PRO GLN          
SEQRES  10 B  199  LEU VAL ILE CYS MET ASP CYS SER ALA ASP THR MET THR          
SEQRES  11 B  199  ASN ARG LEU LEU GLN MET SER ARG SER SER LEU PRO VAL          
SEQRES  12 B  199  ASP ASP THR THR LYS THR ILE ALA LYS ARG LEU GLU ALA          
SEQRES  13 B  199  TYR TYR ARG ALA SER ILE PRO VAL ILE ALA TYR TYR GLU          
SEQRES  14 B  199  THR LYS THR GLN LEU HIS LYS ILE ASN ALA GLU GLY THR          
SEQRES  15 B  199  PRO GLU ASP VAL PHE LEU GLN LEU CYS THR ALA ILE ASP          
SEQRES  16 B  199  SER ILE PHE LEU                                              
SEQRES   1 C  199  SER MET GLY GLY PHE MET GLU ASP LEU ARG LYS CYS LYS          
SEQRES   2 C  199  ILE ILE PHE ILE ILE GLY GLY PRO GLY SER GLY LYS GLY          
SEQRES   3 C  199  THR GLN CYS GLU LYS LEU VAL GLU LYS TYR GLY PHE THR          
SEQRES   4 C  199  HIS LEU SER THR GLY GLU LEU LEU ARG GLU GLU LEU ALA          
SEQRES   5 C  199  SER GLU SER GLU ARG SER LYS LEU ILE ARG ASP ILE MET          
SEQRES   6 C  199  GLU ARG GLY ASP LEU VAL PRO SER GLY ILE VAL LEU GLU          
SEQRES   7 C  199  LEU LEU LYS GLU ALA MET VAL ALA SER LEU GLY ASP THR          
SEQRES   8 C  199  ARG GLY PHE LEU ILE ASP GLY TYR PRO ARG GLU VAL LYS          
SEQRES   9 C  199  GLN GLY GLU GLU PHE GLY ARG ARG ILE GLY ASP PRO GLN          
SEQRES  10 C  199  LEU VAL ILE CYS MET ASP CYS SER ALA ASP THR MET THR          
SEQRES  11 C  199  ASN ARG LEU LEU GLN MET SER ARG SER SER LEU PRO VAL          
SEQRES  12 C  199  ASP ASP THR THR LYS THR ILE ALA LYS ARG LEU GLU ALA          
SEQRES  13 C  199  TYR TYR ARG ALA SER ILE PRO VAL ILE ALA TYR TYR GLU          
SEQRES  14 C  199  THR LYS THR GLN LEU HIS LYS ILE ASN ALA GLU GLY THR          
SEQRES  15 C  199  PRO GLU ASP VAL PHE LEU GLN LEU CYS THR ALA ILE ASP          
SEQRES  16 C  199  SER ILE PHE LEU                                              
SEQRES   1 D  199  SER MET GLY GLY PHE MET GLU ASP LEU ARG LYS CYS LYS          
SEQRES   2 D  199  ILE ILE PHE ILE ILE GLY GLY PRO GLY SER GLY LYS GLY          
SEQRES   3 D  199  THR GLN CYS GLU LYS LEU VAL GLU LYS TYR GLY PHE THR          
SEQRES   4 D  199  HIS LEU SER THR GLY GLU LEU LEU ARG GLU GLU LEU ALA          
SEQRES   5 D  199  SER GLU SER GLU ARG SER LYS LEU ILE ARG ASP ILE MET          
SEQRES   6 D  199  GLU ARG GLY ASP LEU VAL PRO SER GLY ILE VAL LEU GLU          
SEQRES   7 D  199  LEU LEU LYS GLU ALA MET VAL ALA SER LEU GLY ASP THR          
SEQRES   8 D  199  ARG GLY PHE LEU ILE ASP GLY TYR PRO ARG GLU VAL LYS          
SEQRES   9 D  199  GLN GLY GLU GLU PHE GLY ARG ARG ILE GLY ASP PRO GLN          
SEQRES  10 D  199  LEU VAL ILE CYS MET ASP CYS SER ALA ASP THR MET THR          
SEQRES  11 D  199  ASN ARG LEU LEU GLN MET SER ARG SER SER LEU PRO VAL          
SEQRES  12 D  199  ASP ASP THR THR LYS THR ILE ALA LYS ARG LEU GLU ALA          
SEQRES  13 D  199  TYR TYR ARG ALA SER ILE PRO VAL ILE ALA TYR TYR GLU          
SEQRES  14 D  199  THR LYS THR GLN LEU HIS LYS ILE ASN ALA GLU GLY THR          
SEQRES  15 D  199  PRO GLU ASP VAL PHE LEU GLN LEU CYS THR ALA ILE ASP          
SEQRES  16 D  199  SER ILE PHE LEU                                              
SEQRES   1 E  199  SER MET GLY GLY PHE MET GLU ASP LEU ARG LYS CYS LYS          
SEQRES   2 E  199  ILE ILE PHE ILE ILE GLY GLY PRO GLY SER GLY LYS GLY          
SEQRES   3 E  199  THR GLN CYS GLU LYS LEU VAL GLU LYS TYR GLY PHE THR          
SEQRES   4 E  199  HIS LEU SER THR GLY GLU LEU LEU ARG GLU GLU LEU ALA          
SEQRES   5 E  199  SER GLU SER GLU ARG SER LYS LEU ILE ARG ASP ILE MET          
SEQRES   6 E  199  GLU ARG GLY ASP LEU VAL PRO SER GLY ILE VAL LEU GLU          
SEQRES   7 E  199  LEU LEU LYS GLU ALA MET VAL ALA SER LEU GLY ASP THR          
SEQRES   8 E  199  ARG GLY PHE LEU ILE ASP GLY TYR PRO ARG GLU VAL LYS          
SEQRES   9 E  199  GLN GLY GLU GLU PHE GLY ARG ARG ILE GLY ASP PRO GLN          
SEQRES  10 E  199  LEU VAL ILE CYS MET ASP CYS SER ALA ASP THR MET THR          
SEQRES  11 E  199  ASN ARG LEU LEU GLN MET SER ARG SER SER LEU PRO VAL          
SEQRES  12 E  199  ASP ASP THR THR LYS THR ILE ALA LYS ARG LEU GLU ALA          
SEQRES  13 E  199  TYR TYR ARG ALA SER ILE PRO VAL ILE ALA TYR TYR GLU          
SEQRES  14 E  199  THR LYS THR GLN LEU HIS LYS ILE ASN ALA GLU GLY THR          
SEQRES  15 E  199  PRO GLU ASP VAL PHE LEU GLN LEU CYS THR ALA ILE ASP          
SEQRES  16 E  199  SER ILE PHE LEU                                              
SEQRES   1 F  199  SER MET GLY GLY PHE MET GLU ASP LEU ARG LYS CYS LYS          
SEQRES   2 F  199  ILE ILE PHE ILE ILE GLY GLY PRO GLY SER GLY LYS GLY          
SEQRES   3 F  199  THR GLN CYS GLU LYS LEU VAL GLU LYS TYR GLY PHE THR          
SEQRES   4 F  199  HIS LEU SER THR GLY GLU LEU LEU ARG GLU GLU LEU ALA          
SEQRES   5 F  199  SER GLU SER GLU ARG SER LYS LEU ILE ARG ASP ILE MET          
SEQRES   6 F  199  GLU ARG GLY ASP LEU VAL PRO SER GLY ILE VAL LEU GLU          
SEQRES   7 F  199  LEU LEU LYS GLU ALA MET VAL ALA SER LEU GLY ASP THR          
SEQRES   8 F  199  ARG GLY PHE LEU ILE ASP GLY TYR PRO ARG GLU VAL LYS          
SEQRES   9 F  199  GLN GLY GLU GLU PHE GLY ARG ARG ILE GLY ASP PRO GLN          
SEQRES  10 F  199  LEU VAL ILE CYS MET ASP CYS SER ALA ASP THR MET THR          
SEQRES  11 F  199  ASN ARG LEU LEU GLN MET SER ARG SER SER LEU PRO VAL          
SEQRES  12 F  199  ASP ASP THR THR LYS THR ILE ALA LYS ARG LEU GLU ALA          
SEQRES  13 F  199  TYR TYR ARG ALA SER ILE PRO VAL ILE ALA TYR TYR GLU          
SEQRES  14 F  199  THR LYS THR GLN LEU HIS LYS ILE ASN ALA GLU GLY THR          
SEQRES  15 F  199  PRO GLU ASP VAL PHE LEU GLN LEU CYS THR ALA ILE ASP          
SEQRES  16 F  199  SER ILE PHE LEU                                              
HET    SO4  A1199       5                                                       
HET    SO4  A1200       5                                                       
HET     CL  A1201       1                                                       
HET    SO4  B1199       5                                                       
HET     CL  B1200       1                                                       
HET    SO4  C1198       5                                                       
HET    SO4  D1197       5                                                       
HET    SO4  E1198       5                                                       
HET     CL  E1199       1                                                       
HET    SO4  F1199       5                                                       
HET     CL  F1200       1                                                       
HET     CL  F1201       1                                                       
HET    AMP  B1201      23                                                       
HET    AMP  C1199      19                                                       
HET    AMP  F1202      19                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      CL CHLORIDE ION                                                     
HETNAM     AMP ADENOSINE MONOPHOSPHATE                                          
FORMUL   7  SO4    7(O4 S 2-)                                                   
FORMUL   9   CL    5(CL 1-)                                                     
FORMUL  19  AMP    3(C10 H14 N5 O7 P)                                           
FORMUL  22  HOH   *460(H2 O)                                                    
CRYST1  180.375  180.375  121.701  90.00  90.00 120.00 P 61         36          
ATOM      1  N   GLY A   3      20.451 -14.738  14.563  1.00 97.64           N  
ATOM      2  CA  GLY A   3      21.064 -15.318  15.799  1.00 96.98           C  
ATOM      3  C   GLY A   3      20.307 -14.836  17.019  1.00 95.89           C  
ATOM      4  O   GLY A   3      19.447 -15.543  17.533  1.00 89.74           O  
ATOM      5  N   PHE A   4      20.630 -13.622  17.471  1.00 98.03           N  
ATOM      6  CA  PHE A   4      19.798 -12.896  18.450  1.00 95.03           C  
ATOM      7  C   PHE A   4      18.433 -12.570  17.836  1.00 86.78           C  
ATOM      8  O   PHE A   4      17.409 -12.709  18.498  1.00 88.35           O  
ATOM      9  CB  PHE A   4      20.469 -11.589  18.926  1.00 96.84           C  
ATOM     10  CG  PHE A   4      21.660 -11.793  19.847  1.00103.44           C  
ATOM     11  CD1 PHE A   4      22.870 -11.136  19.599  1.00103.98           C  
ATOM     12  CD2 PHE A   4      21.568 -12.624  20.969  1.00100.63           C  
ATOM     13  CE1 PHE A   4      23.970 -11.312  20.448  1.00100.09           C  
ATOM     14  CE2 PHE A   4      22.660 -12.806  21.821  1.00 98.39           C  
ATOM     15  CZ  PHE A   4      23.867 -12.150  21.557  1.00 96.10           C  
ATOM     16  N   MET A   5      18.437 -12.144  16.567  1.00 76.57           N  
ATOM     17  CA  MET A   5      17.214 -11.790  15.820  1.00 74.23           C  
ATOM     18  C   MET A   5      16.158 -12.914  15.923  1.00 72.76           C  
ATOM     19  O   MET A   5      15.079 -12.717  16.483  1.00 66.85           O  
ATOM     20  CB  MET A   5      17.568 -11.478  14.346  1.00 75.52           C  
ATOM     21  CG  MET A   5      16.642 -10.489  13.650  1.00 78.97           C  
ATOM     22  N   GLU A   6      16.493 -14.099  15.419  1.00 72.09           N  
ATOM     23  CA  GLU A   6      15.590 -15.239  15.486  1.00 69.63           C  
ATOM     24  C   GLU A   6      15.393 -15.708  16.932  1.00 67.22           C  
ATOM     25  O   GLU A   6      14.342 -16.255  17.250  1.00 63.36           O  
ATOM     26  CB  GLU A   6      16.114 -16.386  14.615  1.00 74.54           C  
ATOM     27  CG  GLU A   6      15.287 -17.686  14.687  1.00 85.60           C  
ATOM     28  N   ASP A   7      16.395 -15.512  17.798  1.00 66.04           N  
ATOM     29  CA  ASP A   7      16.266 -15.859  19.231  1.00 67.12           C  
ATOM     30  C   ASP A   7      15.228 -14.970  19.905  1.00 64.53           C  
ATOM     31  O   ASP A   7      14.347 -15.464  20.604  1.00 61.15           O  
ATOM     32  CB  ASP A   7      17.600 -15.706  19.990  1.00 71.40           C  
ATOM     33  CG  ASP A   7      18.476 -16.970  19.954  1.00 81.91           C  
ATOM     34  OD1 ASP A   7      17.955 -18.100  19.803  1.00 83.01           O  
ATOM     35  OD2 ASP A   7      19.706 -16.813  20.109  1.00 75.32           O  
ATOM     36  N   LEU A   8      15.366 -13.661  19.694  1.00 65.07           N  
ATOM     37  CA  LEU A   8      14.438 -12.671  20.237  1.00 67.39           C  
ATOM     38  C   LEU A   8      13.027 -12.870  19.730  1.00 63.43           C  
ATOM     39  O   LEU A   8      12.089 -12.664  20.476  1.00 62.28           O  
ATOM     40  CB  LEU A   8      14.879 -11.245  19.897  1.00 65.61           C  
ATOM     41  CG  LEU A   8      15.931 -10.594  20.786  1.00 74.29           C  
ATOM     42  CD1 LEU A   8      16.319  -9.228  20.194  1.00 74.44           C  
ATOM     43  CD2 LEU A   8      15.425 -10.466  22.213  1.00 70.68           C  
ATOM     44  N   ARG A   9      12.889 -13.267  18.466  1.00 62.73           N  
ATOM     45  CA  ARG A   9      11.578 -13.471  17.860  1.00 66.57           C  
ATOM     46  C   ARG A   9      10.856 -14.710  18.415  1.00 68.15           C  
ATOM     47  O   ARG A   9       9.630 -14.767  18.363  1.00 69.06           O  
ATOM     48  CB  ARG A   9      11.672 -13.615  16.337  1.00 64.07           C  
ATOM     49  CG  ARG A   9      11.997 -12.348  15.573  1.00 72.73           C  
ATOM     50  CD  ARG A   9      11.258 -12.307  14.247  1.00 71.97           C  
ATOM     51  NE  ARG A   9       9.819 -12.143  14.467  1.00 77.69           N  
ATOM     52  CZ  ARG A   9       9.195 -10.977  14.626  1.00 78.22           C  
ATOM     53  NH1 ARG A   9       9.862  -9.830  14.582  1.00 60.00           N  
ATOM     54  NH2 ARG A   9       7.882 -10.964  14.822  1.00 83.29           N  
ATOM     55  N   LYS A  10      11.609 -15.679  18.931  1.00 63.95           N  
ATOM     56  CA  LYS A  10      11.037 -16.927  19.399  1.00 66.17           C  
ATOM     57  C   LYS A  10      10.998 -17.058  20.936  1.00 68.80           C  
ATOM     58  O   LYS A  10      10.557 -18.080  21.450  1.00 71.20           O  
ATOM     59  CB  LYS A  10      11.780 -18.112  18.768  1.00 65.58           C  
ATOM     60  CG  LYS A  10      13.171 -18.396  19.344  1.00 71.83           C  
ATOM     61  N   CYS A  11      11.414 -16.034  21.674  1.00 68.61           N  
ATOM     62  CA  CYS A  11      11.398 -16.114  23.139  1.00 65.69           C  
ATOM     63  C   CYS A  11      10.026 -15.728  23.732  1.00 62.53           C  
ATOM     64  O   CYS A  11       9.189 -15.145  23.033  1.00 60.08           O  
ATOM     65  CB  CYS A  11      12.510 -15.234  23.699  1.00 65.95           C  
ATOM     66  SG  CYS A  11      12.164 -13.493  23.632  1.00 74.10           S  
ATOM     67  N   LYS A  12       9.788 -16.046  25.010  1.00 57.76           N  
ATOM     68  CA  LYS A  12       8.511 -15.703  25.648  1.00 55.25           C  
ATOM     69  C   LYS A  12       8.467 -14.218  25.948  1.00 57.51           C  
ATOM     70  O   LYS A  12       9.354 -13.698  26.633  1.00 54.71           O  
ATOM     71  CB  LYS A  12       8.278 -16.467  26.953  1.00 58.40           C  
ATOM     72  CG  LYS A  12       8.508 -17.947  26.863  1.00 51.10           C  
ATOM     73  CD  LYS A  12       7.997 -18.674  28.099  1.00 59.63           C  
ATOM     74  CE  LYS A  12       8.476 -20.108  28.099  1.00 52.46           C  
ATOM     75  NZ  LYS A  12       9.980 -20.168  28.382  1.00 60.79           N  
ATOM     76  N   ILE A  13       7.440 -13.557  25.413  1.00 52.12           N  
ATOM     77  CA  ILE A  13       7.203 -12.151  25.607  1.00 54.73           C  
ATOM     78  C   ILE A  13       5.771 -11.940  26.103  1.00 53.56           C  
ATOM     79  O   ILE A  13       4.782 -12.296  25.433  1.00 50.82           O  
ATOM     80  CB  ILE A  13       7.466 -11.334  24.321  1.00 60.67           C  
ATOM     81  CG1 ILE A  13       8.886 -11.590  23.833  1.00 54.56           C  
ATOM     82  CG2 ILE A  13       7.304  -9.840  24.590  1.00 55.92           C  
ATOM     83  CD1 ILE A  13       9.240 -10.882  22.533  1.00 58.71           C  
ATOM     84  N   ILE A  14       5.689 -11.399  27.317  1.00 53.22           N  
ATOM     85  CA  ILE A  14       4.428 -11.094  27.956  1.00 55.84           C  
ATOM     86  C   ILE A  14       4.408  -9.589  28.234  1.00 52.35           C  
ATOM     87  O   ILE A  14       5.366  -9.042  28.758  1.00 52.22           O  
ATOM     88  CB  ILE A  14       4.273 -11.855  29.270  1.00 56.75           C  
ATOM     89  CG1 ILE A  14       4.368 -13.361  29.019  1.00 62.26           C  
ATOM     90  CG2 ILE A  14       2.910 -11.511  29.957  1.00 57.84           C  
ATOM     91  CD1 ILE A  14       4.558 -14.137  30.293  1.00 61.76           C  
ATOM     92  N   PHE A  15       3.343  -8.921  27.827  1.00 54.48           N  
ATOM     93  CA  PHE A  15       3.154  -7.522  28.201  1.00 56.22           C  
ATOM     94  C   PHE A  15       2.134  -7.508  29.349  1.00 55.85           C  
ATOM     95  O   PHE A  15       1.143  -8.226  29.321  1.00 54.42           O  
ATOM     96  CB  PHE A  15       2.589  -6.714  27.054  1.00 54.59           C  
ATOM     97  CG  PHE A  15       3.527  -6.458  25.927  1.00 56.45           C  
ATOM     98  CD1 PHE A  15       3.046  -5.833  24.786  1.00 59.90           C  
ATOM     99  CD2 PHE A  15       4.876  -6.800  25.981  1.00 67.39           C  
ATOM    100  CE1 PHE A  15       3.886  -5.560  23.715  1.00 65.98           C  
ATOM    101  CE2 PHE A  15       5.717  -6.536  24.912  1.00 62.98           C  
ATOM    102  CZ  PHE A  15       5.223  -5.905  23.778  1.00 65.49           C  
ATOM    103  N   ILE A  16       2.388  -6.694  30.355  1.00 57.25           N  
ATOM    104  CA  ILE A  16       1.467  -6.578  31.468  1.00 57.02           C  
ATOM    105  C   ILE A  16       1.139  -5.095  31.674  1.00 58.22           C  
ATOM    106  O   ILE A  16       2.026  -4.259  31.829  1.00 61.69           O  
ATOM    107  CB  ILE A  16       1.985  -7.295  32.747  1.00 59.40           C  
ATOM    108  CG1 ILE A  16       0.967  -7.113  33.891  1.00 65.56           C  
ATOM    109  CG2 ILE A  16       3.384  -6.809  33.142  1.00 66.45           C  
ATOM    110  CD1 ILE A  16       0.944  -8.267  34.838  1.00 64.07           C  
ATOM    111  N   ILE A  17      -0.155  -4.800  31.617  1.00 58.99           N  
ATOM    112  CA  ILE A  17      -0.704  -3.467  31.645  1.00 59.85           C  
ATOM    113  C   ILE A  17      -1.730  -3.337  32.792  1.00 59.06           C  
ATOM    114  O   ILE A  17      -2.555  -4.205  33.016  1.00 57.16           O  
ATOM    115  CB  ILE A  17      -1.398  -3.189  30.300  1.00 64.30           C  
ATOM    116  CG1 ILE A  17      -0.348  -3.062  29.196  1.00 67.94           C  
ATOM    117  CG2 ILE A  17      -2.221  -1.903  30.344  1.00 71.43           C  
ATOM    118  CD1 ILE A  17      -0.893  -3.404  27.849  1.00 79.50           C  
ATOM    119  N   GLY A  18      -1.657  -2.242  33.528  1.00 56.10           N  
ATOM    120  CA  GLY A  18      -2.467  -2.097  34.719  1.00 56.69           C  
ATOM    121  C   GLY A  18      -2.324  -0.677  35.225  1.00 54.89           C  
ATOM    122  O   GLY A  18      -1.275  -0.078  35.092  1.00 55.14           O  
ATOM    123  N   GLY A  19      -3.383  -0.149  35.809  1.00 53.27           N  
ATOM    124  CA  GLY A  19      -3.393   1.204  36.313  1.00 54.36           C  
ATOM    125  C   GLY A  19      -2.699   1.337  37.643  1.00 52.35           C  
ATOM    126  O   GLY A  19      -2.435   0.337  38.296  1.00 54.43           O  
ATOM    127  N   PRO A  20      -2.355   2.580  38.033  1.00 55.00           N  
ATOM    128  CA  PRO A  20      -1.721   2.774  39.353  1.00 56.37           C  
ATOM    129  C   PRO A  20      -2.693   2.330  40.465  1.00 54.15           C  
ATOM    130  O   PRO A  20      -3.859   2.664  40.427  1.00 54.27           O  
ATOM    131  CB  PRO A  20      -1.466   4.290  39.405  1.00 55.49           C  
ATOM    132  CG  PRO A  20      -2.519   4.868  38.481  1.00 56.82           C  
ATOM    133  CD  PRO A  20      -2.556   3.865  37.333  1.00 53.59           C  
ATOM    134  N   GLY A  21      -2.212   1.551  41.417  1.00 54.55           N  
ATOM    135  CA  GLY A  21      -3.080   0.973  42.420  1.00 56.54           C  
ATOM    136  C   GLY A  21      -3.655  -0.388  42.070  1.00 60.03           C  
ATOM    137  O   GLY A  21      -4.349  -0.973  42.891  1.00 59.52           O  
ATOM    138  N   SER A  22      -3.365  -0.904  40.876  1.00 59.47           N  
ATOM    139  CA  SER A  22      -3.921  -2.190  40.435  1.00 58.20           C  
ATOM    140  C   SER A  22      -3.188  -3.372  41.085  1.00 60.54           C  
ATOM    141  O   SER A  22      -3.743  -4.467  41.216  1.00 66.72           O  
ATOM    142  CB  SER A  22      -3.876  -2.321  38.912  1.00 52.59           C  
ATOM    143  OG  SER A  22      -2.542  -2.255  38.409  1.00 57.36           O  
ATOM    144  N   GLY A  23      -1.953  -3.125  41.515  1.00 58.71           N  
ATOM    145  CA  GLY A  23      -1.139  -4.116  42.173  1.00 56.97           C  
ATOM    146  C   GLY A  23      -0.121  -4.704  41.227  1.00 59.63           C  
ATOM    147  O   GLY A  23       0.496  -5.725  41.525  1.00 60.80           O  
ATOM    148  N   LYS A  24       0.069  -4.048  40.093  1.00 56.78           N  
ATOM    149  CA  LYS A  24       0.870  -4.615  39.018  1.00 59.64           C  
ATOM    150  C   LYS A  24       2.310  -4.826  39.460  1.00 58.97           C  
ATOM    151  O   LYS A  24       2.876  -5.876  39.214  1.00 59.16           O  
ATOM    152  CB  LYS A  24       0.769  -3.746  37.746  1.00 57.75           C  
ATOM    153  CG  LYS A  24       1.801  -4.040  36.679  1.00 62.00           C  
ATOM    154  CD  LYS A  24       1.452  -3.420  35.321  1.00 62.06           C  
ATOM    155  CE  LYS A  24       1.450  -1.892  35.328  1.00 62.11           C  
ATOM    156  NZ  LYS A  24       2.607  -1.238  35.948  1.00 63.70           N  
ATOM    157  N   GLY A  25       2.889  -3.838  40.133  1.00 62.39           N  
ATOM    158  CA  GLY A  25       4.289  -3.899  40.553  1.00 59.50           C  
ATOM    159  C   GLY A  25       4.610  -5.098  41.415  1.00 62.99           C  
ATOM    160  O   GLY A  25       5.574  -5.825  41.168  1.00 63.62           O  
ATOM    161  N   THR A  26       3.800  -5.322  42.441  1.00 64.91           N  
ATOM    162  CA  THR A  26       4.073  -6.411  43.353  1.00 63.58           C  
ATOM    163  C   THR A  26       3.797  -7.786  42.691  1.00 63.51           C  
ATOM    164  O   THR A  26       4.467  -8.791  42.996  1.00 61.60           O  
ATOM    165  CB  THR A  26       3.296  -6.249  44.686  1.00 71.77           C  
ATOM    166  OG1 THR A  26       1.895  -6.145  44.424  1.00 91.21           O  
ATOM    167  CG2 THR A  26       3.763  -5.000  45.435  1.00 75.96           C  
ATOM    168  N   GLN A  27       2.832  -7.830  41.780  1.00 59.63           N  
ATOM    169  CA  GLN A  27       2.577  -9.050  41.037  1.00 59.11           C  
ATOM    170  C   GLN A  27       3.749  -9.456  40.126  1.00 55.27           C  
ATOM    171  O   GLN A  27       4.037 -10.633  39.951  1.00 57.57           O  
ATOM    172  CB  GLN A  27       1.281  -8.898  40.229  1.00 59.83           C  
ATOM    173  CG  GLN A  27       0.002  -8.851  41.114  1.00 55.87           C  
ATOM    174  CD  GLN A  27      -0.201 -10.059  42.016  1.00 55.42           C  
ATOM    175  OE1 GLN A  27       0.262 -11.155  41.728  1.00 66.57           O  
ATOM    176  NE2 GLN A  27      -0.910  -9.855  43.121  1.00 58.98           N  
ATOM    177  N   CYS A  28       4.417  -8.472  39.552  1.00 57.59           N  
ATOM    178  CA  CYS A  28       5.543  -8.702  38.660  1.00 56.58           C  
ATOM    179  C   CYS A  28       6.739  -9.314  39.385  1.00 56.31           C  
ATOM    180  O   CYS A  28       7.414 -10.183  38.839  1.00 56.91           O  
ATOM    181  CB  CYS A  28       5.936  -7.401  37.975  1.00 61.60           C  
ATOM    182  SG  CYS A  28       4.856  -6.904  36.590  1.00 63.03           S  
ATOM    183  N   GLU A  29       6.987  -8.864  40.616  1.00 58.08           N  
ATOM    184  CA  GLU A  29       8.067  -9.385  41.473  1.00 62.08           C  
ATOM    185  C   GLU A  29       7.851 -10.870  41.797  1.00 61.50           C  
ATOM    186  O   GLU A  29       8.809 -11.651  41.823  1.00 58.67           O  
ATOM    187  CB  GLU A  29       8.175  -8.592  42.791  1.00 61.14           C  
ATOM    188  CG  GLU A  29       8.616  -7.129  42.616  1.00 77.50           C  
ATOM    189  CD  GLU A  29       8.281  -6.196  43.824  1.00 81.47           C  
ATOM    190  OE1 GLU A  29       7.694  -6.661  44.831  1.00 88.34           O  
ATOM    191  OE2 GLU A  29       8.615  -4.980  43.750  1.00 95.09           O  
ATOM    192  N   LYS A  30       6.594 -11.233  42.039  1.00 57.93           N  
ATOM    193  CA  LYS A  30       6.209 -12.619  42.297  1.00 57.90           C  
ATOM    194  C   LYS A  30       6.267 -13.494  41.053  1.00 54.63           C  
ATOM    195  O   LYS A  30       6.679 -14.634  41.114  1.00 60.65           O  
ATOM    196  CB  LYS A  30       4.789 -12.652  42.883  1.00 57.88           C  
ATOM    197  CG  LYS A  30       4.725 -12.004  44.257  1.00 66.72           C  
ATOM    198  CD  LYS A  30       3.364 -11.426  44.561  1.00 83.99           C  
ATOM    199  CE  LYS A  30       2.319 -12.479  44.770  1.00 76.34           C  
ATOM    200  NZ  LYS A  30       1.058 -11.867  45.287  1.00 84.51           N  
ATOM    201  N   LEU A  31       5.797 -12.975  39.932  1.00 56.42           N  
ATOM    202  CA  LEU A  31       5.942 -13.667  38.649  1.00 56.33           C  
ATOM    203  C   LEU A  31       7.406 -13.942  38.279  1.00 54.89           C  
ATOM    204  O   LEU A  31       7.729 -15.001  37.794  1.00 57.68           O  
ATOM    205  CB  LEU A  31       5.281 -12.854  37.538  1.00 55.44           C  
ATOM    206  CG  LEU A  31       3.749 -12.817  37.538  1.00 52.46           C  
ATOM    207  CD1 LEU A  31       3.268 -11.862  36.426  1.00 63.00           C  
ATOM    208  CD2 LEU A  31       3.125 -14.205  37.384  1.00 57.44           C  
ATOM    209  N   VAL A  32       8.282 -12.974  38.495  1.00 58.18           N  
ATOM    210  CA  VAL A  32       9.708 -13.144  38.218  1.00 56.61           C  
ATOM    211  C   VAL A  32      10.260 -14.293  39.013  1.00 55.71           C  
ATOM    212  O   VAL A  32      10.869 -15.209  38.462  1.00 58.38           O  
ATOM    213  CB  VAL A  32      10.483 -11.841  38.560  1.00 64.26           C  
ATOM    214  CG1 VAL A  32      11.996 -12.082  38.735  1.00 64.05           C  
ATOM    215  CG2 VAL A  32      10.236 -10.831  37.500  1.00 60.52           C  
ATOM    216  N   GLU A  33       9.983 -14.253  40.306  1.00 53.83           N  
ATOM    217  CA  GLU A  33      10.449 -15.240  41.240  1.00 56.76           C  
ATOM    218  C   GLU A  33       9.956 -16.663  40.915  1.00 59.06           C  
ATOM    219  O   GLU A  33      10.722 -17.606  41.027  1.00 59.43           O  
ATOM    220  CB  GLU A  33      10.022 -14.831  42.659  1.00 57.69           C  
ATOM    221  CG  GLU A  33      10.662 -15.688  43.761  1.00 77.36           C  
ATOM    222  N   LYS A  34       8.693 -16.805  40.513  1.00 56.15           N  
ATOM    223  CA  LYS A  34       8.081 -18.104  40.262  1.00 55.04           C  
ATOM    224  C   LYS A  34       8.507 -18.703  38.929  1.00 53.71           C  
ATOM    225  O   LYS A  34       8.828 -19.890  38.849  1.00 52.05           O  
ATOM    226  CB  LYS A  34       6.541 -17.985  40.276  1.00 53.28           C  
ATOM    227  CG  LYS A  34       5.834 -19.288  39.926  1.00 60.49           C  
ATOM    228  CD  LYS A  34       4.423 -19.325  40.404  1.00 55.14           C  
ATOM    229  CE  LYS A  34       3.476 -20.072  39.463  1.00 51.93           C  
ATOM    230  NZ  LYS A  34       3.807 -21.381  39.020  1.00 51.59           N  
ATOM    231  N   TYR A  35       8.465 -17.879  37.894  1.00 50.77           N  
ATOM    232  CA  TYR A  35       8.679 -18.306  36.505  1.00 50.68           C  
ATOM    233  C   TYR A  35      10.112 -18.144  35.996  1.00 52.52           C  
ATOM    234  O   TYR A  35      10.453 -18.686  34.930  1.00 51.98           O  
ATOM    235  CB  TYR A  35       7.737 -17.515  35.574  1.00 49.37           C  
ATOM    236  CG  TYR A  35       6.308 -17.941  35.718  1.00 52.00           C  
ATOM    237  CD1 TYR A  35       5.364 -17.141  36.364  1.00 53.14           C  
ATOM    238  CD2 TYR A  35       5.911 -19.188  35.262  1.00 55.17           C  
ATOM    239  CE1 TYR A  35       4.035 -17.583  36.516  1.00 45.73           C  
ATOM    240  CE2 TYR A  35       4.613 -19.639  35.412  1.00 49.56           C  
ATOM    241  CZ  TYR A  35       3.684 -18.842  36.004  1.00 57.28           C  
ATOM    242  OH  TYR A  35       2.437 -19.352  36.082  1.00 50.18           O  
ATOM    243  N   GLY A  36      10.937 -17.402  36.734  1.00 51.22           N  
ATOM    244  CA  GLY A  36      12.262 -17.038  36.263  1.00 53.88           C  
ATOM    245  C   GLY A  36      12.209 -16.156  35.008  1.00 56.20           C  
ATOM    246  O   GLY A  36      12.997 -16.330  34.092  1.00 52.93           O  
ATOM    247  N   PHE A  37      11.245 -15.239  34.950  1.00 58.35           N  
ATOM    248  CA  PHE A  37      11.193 -14.277  33.869  1.00 54.54           C  
ATOM    249  C   PHE A  37      12.073 -13.085  34.229  1.00 57.04           C  
ATOM    250  O   PHE A  37      12.363 -12.804  35.398  1.00 56.05           O  
ATOM    251  CB  PHE A  37       9.779 -13.740  33.616  1.00 62.57           C  
ATOM    252  CG  PHE A  37       8.812 -14.747  33.108  1.00 62.00           C  
ATOM    253  CD1 PHE A  37       7.471 -14.665  33.481  1.00 75.15           C  
ATOM    254  CD2 PHE A  37       9.221 -15.793  32.282  1.00 66.96           C  
ATOM    255  CE1 PHE A  37       6.547 -15.607  33.017  1.00 69.83           C  
ATOM    256  CE2 PHE A  37       8.318 -16.724  31.810  1.00 57.61           C  
ATOM    257  CZ  PHE A  37       6.981 -16.641  32.174  1.00 68.19           C  
ATOM    258  N   THR A  38      12.465 -12.364  33.198  1.00 54.36           N  
ATOM    259  CA  THR A  38      13.125 -11.076  33.368  1.00 58.16           C  
ATOM    260  C   THR A  38      12.048  -9.993  33.289  1.00 54.89           C  
ATOM    261  O   THR A  38      11.365  -9.875  32.291  1.00 53.55           O  
ATOM    262  CB  THR A  38      14.187 -10.908  32.267  1.00 57.02           C  
ATOM    263  OG1 THR A  38      15.127 -11.995  32.382  1.00 52.41           O  
ATOM    264  CG2 THR A  38      14.922  -9.588  32.383  1.00 52.31           C  
ATOM    265  N   HIS A  39      11.908  -9.213  34.357  1.00 58.02           N  
ATOM    266  CA  HIS A  39      10.997  -8.059  34.391  1.00 56.12           C  
ATOM    267  C   HIS A  39      11.639  -6.761  33.834  1.00 59.49           C  
ATOM    268  O   HIS A  39      12.596  -6.250  34.398  1.00 58.61           O  
ATOM    269  CB  HIS A  39      10.534  -7.842  35.834  1.00 55.94           C  
ATOM    270  CG  HIS A  39       9.578  -6.702  36.001  1.00 66.26           C  
ATOM    271  ND1 HIS A  39       9.394  -6.064  37.208  1.00 63.35           N  
ATOM    272  CD2 HIS A  39       8.738  -6.102  35.126  1.00 65.71           C  
ATOM    273  CE1 HIS A  39       8.491  -5.114  37.066  1.00 61.20           C  
ATOM    274  NE2 HIS A  39       8.098  -5.096  35.806  1.00 66.34           N  
ATOM    275  N   LEU A  40      11.088  -6.231  32.737  1.00 57.64           N  
ATOM    276  CA  LEU A  40      11.586  -5.019  32.113  1.00 57.62           C  
ATOM    277  C   LEU A  40      10.509  -3.932  32.128  1.00 59.17           C  
ATOM    278  O   LEU A  40       9.362  -4.217  31.870  1.00 62.01           O  
ATOM    279  CB  LEU A  40      12.016  -5.298  30.671  1.00 59.79           C  
ATOM    280  CG  LEU A  40      13.126  -6.345  30.492  1.00 54.27           C  
ATOM    281  CD1 LEU A  40      13.340  -6.621  29.037  1.00 55.51           C  
ATOM    282  CD2 LEU A  40      14.397  -5.898  31.154  1.00 54.38           C  
ATOM    283  N   SER A  41      10.873  -2.713  32.504  1.00 57.00           N  
ATOM    284  CA  SER A  41       9.974  -1.575  32.360  1.00 60.53           C  
ATOM    285  C   SER A  41      10.746  -0.374  31.856  1.00 55.87           C  
ATOM    286  O   SER A  41      11.938  -0.248  32.067  1.00 56.21           O  
ATOM    287  CB  SER A  41       9.271  -1.249  33.682  1.00 56.50           C  
ATOM    288  OG  SER A  41      10.222  -0.813  34.622  1.00 61.16           O  
ATOM    289  N   THR A  42      10.037   0.510  31.191  1.00 56.48           N  
ATOM    290  CA  THR A  42      10.612   1.733  30.663  1.00 59.38           C  
ATOM    291  C   THR A  42      11.250   2.570  31.785  1.00 55.03           C  
ATOM    292  O   THR A  42      12.346   3.073  31.633  1.00 53.82           O  
ATOM    293  CB  THR A  42       9.514   2.557  29.937  1.00 62.85           C  
ATOM    294  OG1 THR A  42       9.063   1.847  28.784  1.00 60.15           O  
ATOM    295  CG2 THR A  42      10.047   3.921  29.488  1.00 74.80           C  
ATOM    296  N   GLY A  43      10.537   2.742  32.886  1.00 52.14           N  
ATOM    297  CA  GLY A  43      11.043   3.511  34.010  1.00 55.85           C  
ATOM    298  C   GLY A  43      12.393   2.981  34.466  1.00 56.51           C  
ATOM    299  O   GLY A  43      13.369   3.720  34.606  1.00 57.63           O  
ATOM    300  N   GLU A  44      12.458   1.677  34.669  1.00 56.53           N  
ATOM    301  CA  GLU A  44      13.666   1.080  35.178  1.00 56.67           C  
ATOM    302  C   GLU A  44      14.816   1.130  34.150  1.00 53.50           C  
ATOM    303  O   GLU A  44      15.950   1.379  34.508  1.00 52.89           O  
ATOM    304  CB  GLU A  44      13.353  -0.336  35.649  1.00 55.58           C  
ATOM    305  CG  GLU A  44      14.545  -1.103  36.211  1.00 73.43           C  
ATOM    306  CD  GLU A  44      15.259  -0.373  37.352  1.00 87.17           C  
ATOM    307  OE1 GLU A  44      14.611   0.426  38.085  1.00 84.64           O  
ATOM    308  OE2 GLU A  44      16.473  -0.623  37.511  1.00 88.87           O  
ATOM    309  N   LEU A  45      14.509   0.877  32.884  1.00 54.73           N  
ATOM    310  CA  LEU A  45      15.480   0.996  31.797  1.00 55.69           C  
ATOM    311  C   LEU A  45      16.075   2.388  31.678  1.00 55.61           C  
ATOM    312  O   LEU A  45      17.295   2.536  31.467  1.00 53.93           O  
ATOM    313  CB  LEU A  45      14.840   0.607  30.463  1.00 60.86           C  
ATOM    314  CG  LEU A  45      14.561  -0.904  30.277  1.00 54.29           C  
ATOM    315  CD1 LEU A  45      13.692  -1.071  29.058  1.00 65.01           C  
ATOM    316  CD2 LEU A  45      15.816  -1.717  30.152  1.00 62.94           C  
ATOM    317  N   LEU A  46      15.209   3.398  31.798  1.00 53.68           N  
ATOM    318  CA  LEU A  46      15.622   4.797  31.759  1.00 56.10           C  
ATOM    319  C   LEU A  46      16.502   5.114  32.964  1.00 57.07           C  
ATOM    320  O   LEU A  46      17.578   5.630  32.809  1.00 57.33           O  
ATOM    321  CB  LEU A  46      14.404   5.735  31.724  1.00 55.87           C  
ATOM    322  CG  LEU A  46      13.631   5.770  30.397  1.00 54.82           C  
ATOM    323  CD1 LEU A  46      12.354   6.565  30.531  1.00 51.65           C  
ATOM    324  CD2 LEU A  46      14.526   6.316  29.270  1.00 57.20           C  
ATOM    325  N   ARG A  47      16.035   4.765  34.159  1.00 57.80           N  
ATOM    326  CA  ARG A  47      16.821   4.942  35.380  1.00 58.86           C  
ATOM    327  C   ARG A  47      18.230   4.340  35.216  1.00 57.29           C  
ATOM    328  O   ARG A  47      19.233   4.994  35.498  1.00 61.21           O  
ATOM    329  CB  ARG A  47      16.070   4.316  36.575  1.00 64.19           C  
ATOM    330  CG  ARG A  47      16.518   4.817  37.964  1.00 64.96           C  
ATOM    331  CD  ARG A  47      16.410   3.738  39.059  1.00 77.81           C  
ATOM    332  NE  ARG A  47      17.091   2.501  38.647  1.00 95.66           N  
ATOM    333  CZ  ARG A  47      18.417   2.308  38.602  1.00 92.56           C  
ATOM    334  NH1 ARG A  47      19.283   3.255  38.970  1.00 88.29           N  
ATOM    335  NH2 ARG A  47      18.889   1.145  38.169  1.00 83.68           N  
ATOM    336  N   GLU A  48      18.293   3.114  34.704  1.00 60.53           N  
ATOM    337  CA  GLU A  48      19.558   2.392  34.539  1.00 61.38           C  
ATOM    338  C   GLU A  48      20.523   3.014  33.530  1.00 58.44           C  
ATOM    339  O   GLU A  48      21.728   3.104  33.779  1.00 57.20           O  
ATOM    340  CB  GLU A  48      19.268   0.940  34.136  1.00 66.38           C  
ATOM    341  CG  GLU A  48      20.530   0.054  33.998  1.00 73.91           C  
ATOM    342  CD  GLU A  48      20.225  -1.370  33.536  1.00 82.01           C  
ATOM    343  OE1 GLU A  48      19.061  -1.656  33.143  1.00 79.46           O  
ATOM    344  OE2 GLU A  48      21.168  -2.196  33.571  1.00 97.72           O  
ATOM    345  N   GLU A  49      19.998   3.425  32.384  1.00 59.85           N  
ATOM    346  CA  GLU A  49      20.778   4.144  31.385  1.00 59.37           C  
ATOM    347  C   GLU A  49      21.392   5.427  31.964  1.00 57.61           C  
ATOM    348  O   GLU A  49      22.592   5.736  31.767  1.00 53.61           O  
ATOM    349  CB  GLU A  49      19.876   4.462  30.183  1.00 61.87           C  
ATOM    350  CG  GLU A  49      20.504   5.309  29.077  1.00 66.88           C  
ATOM    351  CD  GLU A  49      21.565   4.592  28.246  1.00 72.56           C  
ATOM    352  OE1 GLU A  49      21.959   5.176  27.218  1.00 69.45           O  
ATOM    353  OE2 GLU A  49      21.992   3.468  28.592  1.00 67.33           O  
ATOM    354  N   LEU A  50      20.560   6.168  32.684  1.00 57.60           N  
ATOM    355  CA  LEU A  50      20.987   7.420  33.303  1.00 60.70           C  
ATOM    356  C   LEU A  50      22.104   7.212  34.328  1.00 57.77           C  
ATOM    357  O   LEU A  50      23.086   7.936  34.337  1.00 63.97           O  
ATOM    358  CB  LEU A  50      19.781   8.131  33.942  1.00 65.01           C  
ATOM    359  CG  LEU A  50      18.729   8.753  33.007  1.00 68.94           C  
ATOM    360  CD1 LEU A  50      17.582   9.289  33.827  1.00 69.02           C  
ATOM    361  CD2 LEU A  50      19.312   9.861  32.129  1.00 64.61           C  
ATOM    362  N   ALA A  51      21.950   6.196  35.169  1.00 59.24           N  
ATOM    363  CA  ALA A  51      22.953   5.830  36.183  1.00 56.91           C  
ATOM    364  C   ALA A  51      24.282   5.364  35.573  1.00 59.08           C  
ATOM    365  O   ALA A  51      25.328   5.463  36.221  1.00 60.75           O  
ATOM    366  CB  ALA A  51      22.380   4.712  37.082  1.00 60.68           C  
ATOM    367  N   SER A  52      24.226   4.832  34.346  1.00 60.72           N  
ATOM    368  CA  SER A  52      25.405   4.335  33.643  1.00 60.16           C  
ATOM    369  C   SER A  52      26.376   5.457  33.358  1.00 62.47           C  
ATOM    370  O   SER A  52      27.555   5.194  33.193  1.00 67.18           O  
ATOM    371  CB  SER A  52      25.048   3.645  32.317  1.00 62.91           C  
ATOM    372  OG  SER A  52      24.864   4.584  31.256  1.00 62.55           O  
ATOM    373  N   GLU A  53      25.885   6.696  33.271  1.00 63.26           N  
ATOM    374  CA  GLU A  53      26.736   7.858  32.936  1.00 64.51           C  
ATOM    375  C   GLU A  53      27.385   7.776  31.534  1.00 61.56           C  
ATOM    376  O   GLU A  53      28.302   8.570  31.220  1.00 58.49           O  
ATOM    377  CB  GLU A  53      27.839   8.071  33.998  1.00 68.19           C  
ATOM    378  CG  GLU A  53      27.334   8.477  35.379  1.00 81.20           C  
ATOM    379  CD  GLU A  53      26.697   9.857  35.394  1.00 93.26           C  
ATOM    380  OE1 GLU A  53      27.383  10.864  35.087  1.00107.43           O  
ATOM    381  OE2 GLU A  53      25.500   9.933  35.723  1.00 77.83           O  
ATOM    382  N   SER A  54      26.909   6.853  30.692  1.00 58.38           N  
ATOM    383  CA  SER A  54      27.376   6.754  29.306  1.00 55.50           C  
ATOM    384  C   SER A  54      27.135   8.078  28.602  1.00 53.85           C  
ATOM    385  O   SER A  54      26.290   8.868  29.042  1.00 55.24           O  
ATOM    386  CB  SER A  54      26.633   5.646  28.568  1.00 52.52           C  
ATOM    387  OG  SER A  54      25.247   5.972  28.403  1.00 58.64           O  
ATOM    388  N   GLU A  55      27.880   8.328  27.528  1.00 51.53           N  
ATOM    389  CA  GLU A  55      27.683   9.529  26.714  1.00 52.03           C  
ATOM    390  C   GLU A  55      26.322   9.526  26.064  1.00 49.37           C  
ATOM    391  O   GLU A  55      25.676  10.571  25.957  1.00 57.53           O  
ATOM    392  CB  GLU A  55      28.749   9.633  25.624  1.00 58.58           C  
ATOM    393  CG  GLU A  55      30.126   9.877  26.158  1.00 63.63           C  
ATOM    394  CD  GLU A  55      30.262  11.252  26.714  1.00 59.20           C  
ATOM    395  OE1 GLU A  55      29.698  12.170  26.112  1.00 64.23           O  
ATOM    396  OE2 GLU A  55      30.922  11.407  27.755  1.00 69.38           O  
ATOM    397  N   ARG A  56      25.879   8.337  25.653  1.00 54.40           N  
ATOM    398  CA  ARG A  56      24.555   8.140  25.080  1.00 53.10           C  
ATOM    399  C   ARG A  56      23.467   8.549  26.068  1.00 51.89           C  
ATOM    400  O   ARG A  56      22.488   9.159  25.681  1.00 56.72           O  
ATOM    401  CB  ARG A  56      24.396   6.668  24.672  1.00 58.36           C  
ATOM    402  CG  ARG A  56      23.065   6.349  24.035  1.00 62.58           C  
ATOM    403  CD  ARG A  56      22.948   4.912  23.632  1.00 71.48           C  
ATOM    404  NE  ARG A  56      22.633   4.074  24.783  1.00 69.36           N  
ATOM    405  CZ  ARG A  56      22.509   2.753  24.734  1.00 60.61           C  
ATOM    406  NH1 ARG A  56      22.673   2.106  23.595  1.00 72.63           N  
ATOM    407  NH2 ARG A  56      22.237   2.075  25.840  1.00 63.72           N  
ATOM    408  N   SER A  57      23.649   8.200  27.345  1.00 52.16           N  
ATOM    409  CA  SER A  57      22.708   8.564  28.410  1.00 51.11           C  
ATOM    410  C   SER A  57      22.465  10.070  28.544  1.00 53.64           C  
ATOM    411  O   SER A  57      21.408  10.474  29.005  1.00 54.47           O  
ATOM    412  CB  SER A  57      23.175   8.007  29.775  1.00 56.86           C  
ATOM    413  OG  SER A  57      24.188   8.807  30.401  1.00 52.38           O  
ATOM    414  N   LYS A  58      23.435  10.899  28.159  1.00 53.86           N  
ATOM    415  CA  LYS A  58      23.314  12.357  28.354  1.00 51.95           C  
ATOM    416  C   LYS A  58      22.240  12.991  27.459  1.00 53.08           C  
ATOM    417  O   LYS A  58      21.636  13.995  27.821  1.00 53.99           O  
ATOM    418  CB  LYS A  58      24.667  13.028  28.183  1.00 53.55           C  
ATOM    419  CG  LYS A  58      25.638  12.611  29.282  1.00 52.88           C  
ATOM    420  CD  LYS A  58      27.037  13.095  29.040  1.00 66.75           C  
ATOM    421  CE  LYS A  58      27.935  12.591  30.137  1.00 61.27           C  
ATOM    422  NZ  LYS A  58      29.314  12.882  29.819  1.00 62.07           N  
ATOM    423  N   LEU A  59      21.972  12.366  26.317  1.00 52.43           N  
ATOM    424  CA  LEU A  59      20.895  12.801  25.448  1.00 54.80           C  
ATOM    425  C   LEU A  59      19.527  12.626  26.131  1.00 51.74           C  
ATOM    426  O   LEU A  59      18.705  13.512  26.103  1.00 57.59           O  
ATOM    427  CB  LEU A  59      20.951  12.019  24.132  1.00 54.62           C  
ATOM    428  CG  LEU A  59      19.853  12.341  23.116  1.00 65.87           C  
ATOM    429  CD1 LEU A  59      19.438  13.858  23.052  1.00 68.79           C  
ATOM    430  CD2 LEU A  59      20.309  11.865  21.764  1.00 77.11           C  
ATOM    431  N   ILE A  60      19.328  11.495  26.782  1.00 54.18           N  
ATOM    432  CA  ILE A  60      18.129  11.245  27.569  1.00 57.33           C  
ATOM    433  C   ILE A  60      18.044  12.188  28.775  1.00 55.73           C  
ATOM    434  O   ILE A  60      16.973  12.656  29.131  1.00 53.99           O  
ATOM    435  CB  ILE A  60      18.097   9.768  28.058  1.00 63.11           C  
ATOM    436  CG1 ILE A  60      17.927   8.831  26.872  1.00 67.24           C  
ATOM    437  CG2 ILE A  60      16.947   9.513  29.051  1.00 76.14           C  
ATOM    438  CD1 ILE A  60      18.299   7.382  27.199  1.00 74.93           C  
ATOM    439  N   ARG A  61      19.169  12.429  29.432  1.00 55.27           N  
ATOM    440  CA  ARG A  61      19.191  13.374  30.527  1.00 58.43           C  
ATOM    441  C   ARG A  61      18.757  14.782  30.050  1.00 54.97           C  
ATOM    442  O   ARG A  61      17.941  15.411  30.691  1.00 57.64           O  
ATOM    443  CB  ARG A  61      20.562  13.385  31.205  1.00 57.96           C  
ATOM    444  CG  ARG A  61      20.628  14.256  32.454  1.00 67.40           C  
ATOM    445  CD  ARG A  61      21.919  14.024  33.247  1.00 65.96           C  
ATOM    446  N   ASP A  62      19.242  15.236  28.901  1.00 52.77           N  
ATOM    447  CA  ASP A  62      18.787  16.518  28.336  1.00 55.90           C  
ATOM    448  C   ASP A  62      17.276  16.571  28.137  1.00 57.76           C  
ATOM    449  O   ASP A  62      16.618  17.555  28.455  1.00 59.63           O  
ATOM    450  CB  ASP A  62      19.422  16.744  26.988  1.00 53.22           C  
ATOM    451  CG  ASP A  62      20.929  16.980  27.055  1.00 65.39           C  
ATOM    452  OD1 ASP A  62      21.491  17.198  28.167  1.00 60.71           O  
ATOM    453  OD2 ASP A  62      21.539  16.965  25.958  1.00 57.12           O  
ATOM    454  N   ILE A  63      16.740  15.506  27.570  1.00 56.99           N  
ATOM    455  CA  ILE A  63      15.310  15.398  27.291  1.00 59.61           C  
ATOM    456  C   ILE A  63      14.484  15.431  28.573  1.00 59.88           C  
ATOM    457  O   ILE A  63      13.527  16.166  28.700  1.00 61.03           O  
ATOM    458  CB  ILE A  63      15.028  14.069  26.548  1.00 61.14           C  
ATOM    459  CG1 ILE A  63      15.567  14.143  25.115  1.00 56.68           C  
ATOM    460  CG2 ILE A  63      13.537  13.731  26.542  1.00 60.42           C  
ATOM    461  CD1 ILE A  63      15.740  12.748  24.463  1.00 62.96           C  
ATOM    462  N   MET A  64      14.866  14.609  29.523  1.00 59.71           N  
ATOM    463  CA  MET A  64      14.106  14.466  30.741  1.00 62.05           C  
ATOM    464  C   MET A  64      14.183  15.651  31.690  1.00 59.84           C  
ATOM    465  O   MET A  64      13.278  15.853  32.492  1.00 65.06           O  
ATOM    466  CB  MET A  64      14.548  13.192  31.451  1.00 56.84           C  
ATOM    467  CG  MET A  64      14.119  11.966  30.673  1.00 73.04           C  
ATOM    468  SD  MET A  64      14.548  10.471  31.549  1.00 74.82           S  
ATOM    469  CE  MET A  64      13.300  10.439  32.839  1.00 96.42           C  
ATOM    470  N   GLU A  65      15.261  16.407  31.616  1.00 57.51           N  
ATOM    471  CA  GLU A  65      15.392  17.640  32.367  1.00 63.19           C  
ATOM    472  C   GLU A  65      14.442  18.757  31.885  1.00 64.40           C  
ATOM    473  O   GLU A  65      14.150  19.683  32.633  1.00 62.49           O  
ATOM    474  CB  GLU A  65      16.827  18.145  32.263  1.00 64.87           C  
ATOM    475  CG  GLU A  65      17.791  17.337  33.113  1.00 80.19           C  
ATOM    476  CD  GLU A  65      19.213  17.852  33.029  1.00 91.67           C  
ATOM    477  OE1 GLU A  65      19.533  18.595  32.070  1.00 92.57           O  
ATOM    478  OE2 GLU A  65      20.005  17.499  33.929  1.00103.94           O  
ATOM    479  N   ARG A  66      14.007  18.686  30.630  1.00 61.53           N  
ATOM    480  CA  ARG A  66      13.002  19.600  30.131  1.00 58.29           C  
ATOM    481  C   ARG A  66      11.613  19.017  30.349  1.00 56.61           C  
ATOM    482  O   ARG A  66      10.636  19.669  30.053  1.00 59.54           O  
ATOM    483  CB  ARG A  66      13.173  19.816  28.647  1.00 54.42           C  
ATOM    484  CG  ARG A  66      14.515  20.344  28.193  1.00 54.32           C  
ATOM    485  CD  ARG A  66      14.486  20.361  26.677  1.00 60.33           C  
ATOM    486  NE  ARG A  66      15.771  20.034  26.067  1.00 87.33           N  
ATOM    487  CZ  ARG A  66      15.988  19.029  25.216  1.00 95.17           C  
ATOM    488  NH1 ARG A  66      14.985  18.212  24.842  1.00 76.77           N  
ATOM    489  NH2 ARG A  66      17.228  18.848  24.723  1.00 89.49           N  
ATOM    490  N   GLY A  67      11.515  17.785  30.829  1.00 53.10           N  
ATOM    491  CA  GLY A  67      10.232  17.112  30.926  1.00 54.60           C  
ATOM    492  C   GLY A  67       9.717  16.725  29.558  1.00 59.24           C  
ATOM    493  O   GLY A  67       8.516  16.497  29.377  1.00 60.08           O  
ATOM    494  N   ASP A  68      10.626  16.684  28.580  1.00 61.15           N  
ATOM    495  CA  ASP A  68      10.257  16.367  27.207  1.00 59.34           C  
ATOM    496  C   ASP A  68      10.071  14.842  27.062  1.00 62.24           C  
ATOM    497  O   ASP A  68      10.465  14.041  27.920  1.00 58.54           O  
ATOM    498  CB  ASP A  68      11.323  16.882  26.211  1.00 60.08           C  
ATOM    499  CG  ASP A  68      11.022  18.284  25.660  1.00 62.23           C  
ATOM    500  OD1 ASP A  68       9.842  18.694  25.595  1.00 78.88           O  
ATOM    501  OD2 ASP A  68      11.980  18.976  25.267  1.00 90.07           O  
ATOM    502  N   LEU A  69       9.469  14.470  25.949  1.00 60.73           N  
ATOM    503  CA  LEU A  69       9.174  13.099  25.621  1.00 62.25           C  
ATOM    504  C   LEU A  69      10.451  12.384  25.183  1.00 62.31           C  
ATOM    505  O   LEU A  69      11.200  12.890  24.350  1.00 58.32           O  
ATOM    506  CB  LEU A  69       8.192  13.113  24.455  1.00 62.30           C  
ATOM    507  CG  LEU A  69       7.991  11.849  23.648  1.00 65.19           C  
ATOM    508  CD1 LEU A  69       7.098  10.918  24.399  1.00 62.37           C  
ATOM    509  CD2 LEU A  69       7.355  12.254  22.339  1.00 73.66           C  
ATOM    510  N   VAL A  70      10.664  11.182  25.692  1.00 62.16           N  
ATOM    511  CA  VAL A  70      11.780  10.366  25.235  1.00 62.60           C  
ATOM    512  C   VAL A  70      11.322   9.634  23.985  1.00 61.29           C  
ATOM    513  O   VAL A  70      10.340   8.909  24.047  1.00 54.89           O  
ATOM    514  CB  VAL A  70      12.225   9.365  26.297  1.00 55.44           C  
ATOM    515  CG1 VAL A  70      13.424   8.562  25.791  1.00 59.79           C  
ATOM    516  CG2 VAL A  70      12.554  10.099  27.592  1.00 58.75           C  
ATOM    517  N   PRO A  71      12.007   9.850  22.840  1.00 58.28           N  
ATOM    518  CA  PRO A  71      11.604   9.138  21.628  1.00 58.88           C  
ATOM    519  C   PRO A  71      11.518   7.628  21.784  1.00 59.02           C  
ATOM    520  O   PRO A  71      12.281   7.026  22.537  1.00 58.85           O  
ATOM    521  CB  PRO A  71      12.686   9.523  20.617  1.00 56.80           C  
ATOM    522  CG  PRO A  71      13.178  10.860  21.089  1.00 59.22           C  
ATOM    523  CD  PRO A  71      13.141  10.765  22.585  1.00 62.29           C  
ATOM    524  N   SER A  72      10.582   7.031  21.060  1.00 61.20           N  
ATOM    525  CA  SER A  72      10.302   5.604  21.165  1.00 62.30           C  
ATOM    526  C   SER A  72      11.484   4.751  20.772  1.00 59.44           C  
ATOM    527  O   SER A  72      11.668   3.667  21.335  1.00 57.75           O  
ATOM    528  CB  SER A  72       9.132   5.223  20.257  1.00 62.38           C  
ATOM    529  OG  SER A  72       7.962   5.863  20.678  1.00 88.58           O  
ATOM    530  N   GLY A  73      12.254   5.224  19.785  1.00 57.59           N  
ATOM    531  CA  GLY A  73      13.431   4.508  19.297  1.00 55.71           C  
ATOM    532  C   GLY A  73      14.472   4.323  20.385  1.00 55.75           C  
ATOM    533  O   GLY A  73      15.165   3.315  20.443  1.00 57.81           O  
ATOM    534  N   ILE A  74      14.571   5.303  21.261  1.00 57.21           N  
ATOM    535  CA  ILE A  74      15.565   5.264  22.330  1.00 60.73           C  
ATOM    536  C   ILE A  74      15.125   4.229  23.332  1.00 57.26           C  
ATOM    537  O   ILE A  74      15.911   3.414  23.775  1.00 60.97           O  
ATOM    538  CB  ILE A  74      15.748   6.668  23.020  1.00 62.93           C  
ATOM    539  CG1 ILE A  74      16.614   7.615  22.176  1.00 73.11           C  
ATOM    540  CG2 ILE A  74      16.425   6.536  24.375  1.00 65.44           C  
ATOM    541  CD1 ILE A  74      16.130   7.810  20.766  1.00 83.51           C  
ATOM    542  N   VAL A  75      13.843   4.245  23.686  1.00 60.10           N  
ATOM    543  CA  VAL A  75      13.335   3.269  24.639  1.00 57.67           C  
ATOM    544  C   VAL A  75      13.460   1.855  24.078  1.00 57.61           C  
ATOM    545  O   VAL A  75      13.838   0.930  24.793  1.00 56.51           O  
ATOM    546  CB  VAL A  75      11.831   3.548  25.016  1.00 61.66           C  
ATOM    547  CG1 VAL A  75      11.316   2.470  25.967  1.00 57.13           C  
ATOM    548  CG2 VAL A  75      11.652   4.970  25.620  1.00 53.79           C  
ATOM    549  N   LEU A  76      13.085   1.683  22.813  1.00 54.87           N  
ATOM    550  CA  LEU A  76      13.175   0.394  22.158  1.00 57.97           C  
ATOM    551  C   LEU A  76      14.603  -0.119  22.135  1.00 59.99           C  
ATOM    552  O   LEU A  76      14.844  -1.305  22.377  1.00 60.78           O  
ATOM    553  CB  LEU A  76      12.669   0.483  20.726  1.00 61.46           C  
ATOM    554  CG  LEU A  76      12.485  -0.833  19.966  1.00 65.34           C  
ATOM    555  CD1 LEU A  76      11.382  -1.687  20.565  1.00 69.46           C  
ATOM    556  CD2 LEU A  76      12.171  -0.551  18.523  1.00 77.90           C  
ATOM    557  N   GLU A  77      15.545   0.774  21.859  1.00 56.70           N  
ATOM    558  CA  GLU A  77      16.958   0.404  21.817  1.00 62.08           C  
ATOM    559  C   GLU A  77      17.312  -0.170  23.181  1.00 55.86           C  
ATOM    560  O   GLU A  77      17.833  -1.261  23.263  1.00 57.51           O  
ATOM    561  CB  GLU A  77      17.801   1.626  21.438  1.00 57.12           C  
ATOM    562  CG  GLU A  77      19.332   1.518  21.419  1.00 72.41           C  
ATOM    563  CD  GLU A  77      20.024   2.863  20.976  1.00 77.80           C  
ATOM    564  OE1 GLU A  77      19.335   3.918  20.835  1.00 94.98           O  
ATOM    565  OE2 GLU A  77      21.261   2.871  20.755  1.00100.00           O  
ATOM    566  N   LEU A  78      16.963   0.540  24.250  1.00 56.04           N  
ATOM    567  CA  LEU A  78      17.300   0.098  25.611  1.00 57.12           C  
ATOM    568  C   LEU A  78      16.650  -1.239  25.968  1.00 57.28           C  
ATOM    569  O   LEU A  78      17.259  -2.077  26.632  1.00 59.53           O  
ATOM    570  CB  LEU A  78      16.878   1.137  26.642  1.00 62.45           C  
ATOM    571  CG  LEU A  78      17.510   2.519  26.602  1.00 56.52           C  
ATOM    572  CD1 LEU A  78      16.832   3.356  27.631  1.00 60.32           C  
ATOM    573  CD2 LEU A  78      18.996   2.444  26.862  1.00 62.35           C  
ATOM    574  N   LEU A  79      15.417  -1.415  25.522  1.00 55.65           N  
ATOM    575  CA  LEU A  79      14.664  -2.651  25.694  1.00 56.88           C  
ATOM    576  C   LEU A  79      15.338  -3.847  24.998  1.00 59.73           C  
ATOM    577  O   LEU A  79      15.560  -4.910  25.616  1.00 57.70           O  
ATOM    578  CB  LEU A  79      13.271  -2.443  25.120  1.00 63.86           C  
ATOM    579  CG  LEU A  79      12.049  -3.216  25.595  1.00 71.88           C  
ATOM    580  CD1 LEU A  79      11.980  -3.401  27.095  1.00 81.44           C  
ATOM    581  CD2 LEU A  79      10.844  -2.444  25.114  1.00 80.69           C  
ATOM    582  N   LYS A  80      15.693  -3.652  23.728  1.00 54.72           N  
ATOM    583  CA  LYS A  80      16.354  -4.681  22.954  1.00 56.70           C  
ATOM    584  C   LYS A  80      17.674  -5.111  23.588  1.00 56.36           C  
ATOM    585  O   LYS A  80      17.993  -6.290  23.622  1.00 57.93           O  
ATOM    586  CB  LYS A  80      16.592  -4.205  21.522  1.00 65.20           C  
ATOM    587  CG  LYS A  80      17.081  -5.290  20.574  1.00 67.63           C  
ATOM    588  CD  LYS A  80      17.213  -4.721  19.171  1.00 81.01           C  
ATOM    589  CE  LYS A  80      17.692  -5.782  18.163  1.00 89.15           C  
ATOM    590  NZ  LYS A  80      17.470  -5.313  16.750  1.00 82.19           N  
ATOM    591  N   GLU A  81      18.425  -4.140  24.081  1.00 54.46           N  
ATOM    592  CA  GLU A  81      19.674  -4.404  24.749  1.00 55.79           C  
ATOM    593  C   GLU A  81      19.515  -5.191  26.052  1.00 55.33           C  
ATOM    594  O   GLU A  81      20.314  -6.091  26.346  1.00 55.63           O  
ATOM    595  CB  GLU A  81      20.416  -3.100  24.988  1.00 53.68           C  
ATOM    596  CG  GLU A  81      20.909  -2.518  23.689  1.00 67.60           C  
ATOM    597  CD  GLU A  81      21.671  -1.232  23.856  1.00 72.67           C  
ATOM    598  OE1 GLU A  81      21.715  -0.755  25.007  1.00 63.01           O  
ATOM    599  OE2 GLU A  81      22.222  -0.730  22.835  1.00 68.82           O  
ATOM    600  N   ALA A  82      18.478  -4.863  26.811  1.00 58.44           N  
ATOM    601  CA  ALA A  82      18.189  -5.566  28.062  1.00 59.20           C  
ATOM    602  C   ALA A  82      17.807  -7.029  27.807  1.00 58.52           C  
ATOM    603  O   ALA A  82      18.203  -7.923  28.561  1.00 60.29           O  
ATOM    604  CB  ALA A  82      17.101  -4.853  28.822  1.00 55.57           C  
ATOM    605  N   MET A  83      17.065  -7.242  26.726  1.00 56.30           N  
ATOM    606  CA  MET A  83      16.599  -8.552  26.321  1.00 56.83           C  
ATOM    607  C   MET A  83      17.713  -9.391  25.734  1.00 57.00           C  
ATOM    608  O   MET A  83      17.784 -10.584  26.003  1.00 59.65           O  
ATOM    609  CB  MET A  83      15.432  -8.441  25.313  1.00 47.71           C  
ATOM    610  CG  MET A  83      14.200  -7.771  25.886  1.00 57.14           C  
ATOM    611  SD  MET A  83      12.928  -7.505  24.631  1.00 57.90           S  
ATOM    612  CE  MET A  83      12.363  -9.182  24.330  1.00 61.38           C  
ATOM    613  N   VAL A  84      18.573  -8.776  24.928  1.00 61.79           N  
ATOM    614  CA  VAL A  84      19.746  -9.452  24.385  1.00 57.46           C  
ATOM    615  C   VAL A  84      20.690  -9.854  25.534  1.00 60.71           C  
ATOM    616  O   VAL A  84      21.171 -10.985  25.570  1.00 61.08           O  
ATOM    617  CB  VAL A  84      20.443  -8.583  23.349  1.00 59.96           C  
ATOM    618  CG1 VAL A  84      21.828  -9.133  22.986  1.00 60.12           C  
ATOM    619  CG2 VAL A  84      19.581  -8.446  22.104  1.00 60.89           C  
ATOM    620  N   ALA A  85      20.922  -8.955  26.489  1.00 61.30           N  
ATOM    621  CA  ALA A  85      21.783  -9.263  27.646  1.00 59.50           C  
ATOM    622  C   ALA A  85      21.239 -10.361  28.556  1.00 59.62           C  
ATOM    623  O   ALA A  85      22.005 -10.998  29.247  1.00 61.19           O  
ATOM    624  CB  ALA A  85      22.032  -8.005  28.477  1.00 59.80           C  
ATOM    625  N   SER A  86      19.927 -10.569  28.585  1.00 64.02           N  
ATOM    626  CA  SER A  86      19.317 -11.589  29.473  1.00 63.18           C  
ATOM    627  C   SER A  86      19.044 -12.898  28.766  1.00 59.70           C  
ATOM    628  O   SER A  86      18.781 -13.891  29.401  1.00 60.11           O  
ATOM    629  CB  SER A  86      18.000 -11.084  30.054  1.00 57.93           C  
ATOM    630  OG  SER A  86      18.179  -9.855  30.728  1.00 83.09           O  
ATOM    631  N   LEU A  87      19.067 -12.876  27.446  1.00 64.12           N  
ATOM    632  CA  LEU A  87      18.806 -14.054  26.645  1.00 71.45           C  
ATOM    633  C   LEU A  87      19.787 -15.159  27.047  1.00 73.93           C  
ATOM    634  O   LEU A  87      20.986 -14.920  27.161  1.00 75.94           O  
ATOM    635  CB  LEU A  87      18.994 -13.703  25.170  1.00 74.00           C  
ATOM    636  CG  LEU A  87      17.985 -14.192  24.138  1.00 76.10           C  
ATOM    637  CD1 LEU A  87      16.551 -13.899  24.555  1.00 83.56           C  
ATOM    638  CD2 LEU A  87      18.329 -13.524  22.802  1.00 78.18           C  
ATOM    639  N   GLY A  88      19.282 -16.354  27.296  1.00 73.80           N  
ATOM    640  CA  GLY A  88      20.158 -17.473  27.656  1.00 77.32           C  
ATOM    641  C   GLY A  88      20.352 -17.668  29.150  1.00 77.04           C  
ATOM    642  O   GLY A  88      20.832 -18.706  29.568  1.00 78.77           O  
ATOM    643  N   ASP A  89      20.015 -16.668  29.957  1.00 76.12           N  
ATOM    644  CA  ASP A  89      19.888 -16.874  31.389  1.00 75.61           C  
ATOM    645  C   ASP A  89      18.526 -16.368  31.840  1.00 74.44           C  
ATOM    646  O   ASP A  89      18.409 -15.794  32.913  1.00 77.16           O  
ATOM    647  CB  ASP A  89      21.016 -16.176  32.155  1.00 75.19           C  
ATOM    648  N   THR A  90      17.499 -16.568  31.009  1.00 70.73           N  
ATOM    649  CA  THR A  90      16.126 -16.217  31.381  1.00 65.70           C  
ATOM    650  C   THR A  90      15.137 -17.152  30.741  1.00 59.20           C  
ATOM    651  O   THR A  90      15.420 -17.702  29.701  1.00 58.89           O  
ATOM    652  CB  THR A  90      15.736 -14.744  31.000  1.00 72.00           C  
ATOM    653  OG1 THR A  90      14.626 -14.342  31.803  1.00 64.42           O  
ATOM    654  CG2 THR A  90      15.342 -14.595  29.506  1.00 59.43           C  
ATOM    655  N   ARG A  91      13.964 -17.303  31.358  1.00 57.58           N  
ATOM    656  CA  ARG A  91      12.889 -18.096  30.790  1.00 56.93           C  
ATOM    657  C   ARG A  91      11.836 -17.284  29.998  1.00 56.39           C  
ATOM    658  O   ARG A  91      10.966 -17.849  29.357  1.00 59.83           O  
ATOM    659  CB  ARG A  91      12.261 -18.950  31.903  1.00 58.08           C  
ATOM    660  CG  ARG A  91      13.156 -20.167  32.291  1.00 58.54           C  
ATOM    661  CD  ARG A  91      12.770 -20.731  33.647  1.00 84.34           C  
ATOM    662  NE  ARG A  91      13.832 -21.505  34.289  1.00 91.92           N  
ATOM    663  N   GLY A  92      11.927 -15.960  30.031  1.00 56.53           N  
ATOM    664  CA  GLY A  92      10.959 -15.119  29.369  1.00 54.35           C  
ATOM    665  C   GLY A  92      11.020 -13.698  29.854  1.00 54.23           C  
ATOM    666  O   GLY A  92      11.674 -13.380  30.846  1.00 55.59           O  
ATOM    667  N   PHE A  93      10.340 -12.837  29.124  1.00 53.66           N  
ATOM    668  CA  PHE A  93      10.306 -11.413  29.435  1.00 56.89           C  
ATOM    669  C   PHE A  93       8.935 -10.979  29.835  1.00 55.16           C  
ATOM    670  O   PHE A  93       7.966 -11.294  29.158  1.00 53.63           O  
ATOM    671  CB  PHE A  93      10.784 -10.593  28.242  1.00 57.23           C  
ATOM    672  CG  PHE A  93      12.186 -10.890  27.899  1.00 53.43           C  
ATOM    673  CD1 PHE A  93      13.204 -10.374  28.672  1.00 54.90           C  
ATOM    674  CD2 PHE A  93      12.491 -11.789  26.905  1.00 57.93           C  
ATOM    675  CE1 PHE A  93      14.510 -10.676  28.412  1.00 52.03           C  
ATOM    676  CE2 PHE A  93      13.809 -12.117  26.656  1.00 53.43           C  
ATOM    677  CZ  PHE A  93      14.817 -11.552  27.407  1.00 61.78           C  
ATOM    678  N   LEU A  94       8.883 -10.271  30.958  1.00 53.16           N  
ATOM    679  CA  LEU A  94       7.681  -9.618  31.428  1.00 55.67           C  
ATOM    680  C   LEU A  94       7.890  -8.113  31.260  1.00 56.48           C  
ATOM    681  O   LEU A  94       8.653  -7.478  31.997  1.00 52.63           O  
ATOM    682  CB  LEU A  94       7.454  -9.985  32.884  1.00 55.05           C  
ATOM    683  CG  LEU A  94       6.160  -9.589  33.546  1.00 56.59           C  
ATOM    684  CD1 LEU A  94       4.973 -10.125  32.747  1.00 65.83           C  
ATOM    685  CD2 LEU A  94       6.168 -10.113  34.951  1.00 67.68           C  
ATOM    686  N   ILE A  95       7.228  -7.555  30.257  1.00 56.84           N  
ATOM    687  CA  ILE A  95       7.396  -6.153  29.918  1.00 58.12           C  
ATOM    688  C   ILE A  95       6.224  -5.357  30.481  1.00 55.85           C  
ATOM    689  O   ILE A  95       5.102  -5.481  30.048  1.00 55.61           O  
ATOM    690  CB  ILE A  95       7.636  -5.966  28.400  1.00 57.27           C  
ATOM    691  CG1 ILE A  95       8.918  -6.735  27.999  1.00 58.76           C  
ATOM    692  CG2 ILE A  95       7.830  -4.514  28.082  1.00 65.96           C  
ATOM    693  CD1 ILE A  95       9.042  -7.046  26.556  1.00 69.95           C  
ATOM    694  N   ASP A  96       6.544  -4.520  31.450  1.00 56.29           N  
ATOM    695  CA  ASP A  96       5.589  -3.967  32.378  1.00 57.59           C  
ATOM    696  C   ASP A  96       5.285  -2.565  31.908  1.00 59.03           C  
ATOM    697  O   ASP A  96       6.196  -1.794  31.625  1.00 58.11           O  
ATOM    698  CB  ASP A  96       6.203  -4.070  33.786  1.00 60.59           C  
ATOM    699  CG  ASP A  96       5.574  -3.159  34.814  1.00 63.00           C  
ATOM    700  OD1 ASP A  96       4.574  -2.510  34.491  1.00 58.74           O  
ATOM    701  OD2 ASP A  96       6.111  -3.105  35.971  1.00 59.06           O  
ATOM    702  N   GLY A  97       3.981  -2.303  31.746  1.00 61.50           N  
ATOM    703  CA  GLY A  97       3.436  -1.009  31.359  1.00 59.58           C  
ATOM    704  C   GLY A  97       3.880  -0.551  29.984  1.00 62.68           C  
ATOM    705  O   GLY A  97       4.045   0.634  29.743  1.00 65.10           O  
ATOM    706  N   TYR A  98       4.060  -1.499  29.077  1.00 65.82           N  
ATOM    707  CA  TYR A  98       4.557  -1.212  27.737  1.00 68.24           C  
ATOM    708  C   TYR A  98       3.787  -2.040  26.692  1.00 68.89           C  
ATOM    709  O   TYR A  98       3.313  -3.163  27.032  1.00 68.61           O  
ATOM    710  CB  TYR A  98       6.022  -1.527  27.683  1.00 67.03           C  
ATOM    711  CG  TYR A  98       6.639  -1.288  26.360  1.00 68.60           C  
ATOM    712  CD1 TYR A  98       6.543  -2.235  25.343  1.00 74.80           C  
ATOM    713  CD2 TYR A  98       7.336  -0.135  26.114  1.00 46.65           C  
ATOM    714  CE1 TYR A  98       7.137  -2.019  24.099  1.00 65.42           C  
ATOM    715  CE2 TYR A  98       7.930   0.094  24.873  1.00 68.28           C  
ATOM    716  CZ  TYR A  98       7.830  -0.863  23.876  1.00 55.08           C  
ATOM    717  OH  TYR A  98       8.391  -0.646  22.642  1.00 69.37           O  
ATOM    718  N   PRO A  99       3.586  -1.459  25.465  1.00 65.77           N  
ATOM    719  CA  PRO A  99       3.922  -0.059  25.013  1.00 63.37           C  
ATOM    720  C   PRO A  99       2.899   1.001  25.494  1.00 57.41           C  
ATOM    721  O   PRO A  99       1.889   0.642  26.064  1.00 59.42           O  
ATOM    722  CB  PRO A  99       3.864  -0.173  23.503  1.00 64.79           C  
ATOM    723  CG  PRO A  99       2.753  -1.144  23.292  1.00 70.31           C  
ATOM    724  CD  PRO A  99       2.898  -2.191  24.389  1.00 69.36           C  
ATOM    725  N   ARG A 100       3.186   2.275  25.278  1.00 60.60           N  
ATOM    726  CA  ARG A 100       2.311   3.393  25.709  1.00 62.45           C  
ATOM    727  C   ARG A 100       1.404   3.905  24.578  1.00 58.15           C  
ATOM    728  O   ARG A 100       0.495   4.720  24.815  1.00 57.72           O  
ATOM    729  CB  ARG A 100       3.153   4.571  26.239  1.00 69.53           C  
ATOM    730  CG  ARG A 100       4.228   5.105  25.239  1.00 66.05           C  
ATOM    731  CD  ARG A 100       4.768   6.457  25.603  1.00 67.33           C  
ATOM    732  NE  ARG A 100       6.224   6.625  25.397  1.00 84.12           N  
ATOM    733  CZ  ARG A 100       6.817   7.287  24.391  1.00 86.09           C  
ATOM    734  NH1 ARG A 100       6.109   7.831  23.404  1.00 96.42           N  
ATOM    735  NH2 ARG A 100       8.149   7.395  24.358  1.00 51.01           N  
ATOM    736  N   GLU A 101       1.701   3.484  23.351  1.00 57.18           N  
ATOM    737  CA  GLU A 101       0.826   3.717  22.206  1.00 61.10           C  
ATOM    738  C   GLU A 101       1.004   2.596  21.179  1.00 54.10           C  
ATOM    739  O   GLU A 101       1.936   1.826  21.257  1.00 53.51           O  
ATOM    740  CB  GLU A 101       1.102   5.084  21.578  1.00 64.96           C  
ATOM    741  CG  GLU A 101       2.411   5.121  20.826  1.00 80.47           C  
ATOM    742  CD  GLU A 101       3.125   6.438  20.972  1.00 81.45           C  
ATOM    743  OE1 GLU A 101       4.359   6.422  21.217  1.00 99.95           O  
ATOM    744  OE2 GLU A 101       2.445   7.473  20.860  1.00 84.28           O  
ATOM    745  N   VAL A 102       0.087   2.523  20.221  1.00 55.00           N  
ATOM    746  CA  VAL A 102      -0.000   1.402  19.290  1.00 53.86           C  
ATOM    747  C   VAL A 102       1.161   1.304  18.310  1.00 55.32           C  
ATOM    748  O   VAL A 102       1.718   0.216  18.116  1.00 54.28           O  
ATOM    749  CB  VAL A 102      -1.308   1.457  18.500  1.00 50.68           C  
ATOM    750  CG1 VAL A 102      -1.278   0.443  17.365  1.00 54.52           C  
ATOM    751  CG2 VAL A 102      -2.500   1.221  19.438  1.00 54.79           C  
ATOM    752  N   LYS A 103       1.523   2.418  17.676  1.00 55.51           N  
ATOM    753  CA  LYS A 103       2.653   2.405  16.742  1.00 56.62           C  
ATOM    754  C   LYS A 103       3.956   1.904  17.411  1.00 55.17           C  
ATOM    755  O   LYS A 103       4.772   1.235  16.782  1.00 54.83           O  
ATOM    756  CB  LYS A 103       2.844   3.784  16.102  1.00 60.96           C  
ATOM    757  CG  LYS A 103       3.377   4.851  17.030  1.00 78.28           C  
ATOM    758  N   GLN A 104       4.123   2.211  18.694  1.00 55.94           N  
ATOM    759  CA  GLN A 104       5.270   1.772  19.463  1.00 58.27           C  
ATOM    760  C   GLN A 104       5.220   0.237  19.666  1.00 61.38           C  
ATOM    761  O   GLN A 104       6.248  -0.447  19.612  1.00 62.68           O  
ATOM    762  CB  GLN A 104       5.294   2.541  20.790  1.00 55.39           C  
ATOM    763  CG  GLN A 104       6.499   2.283  21.671  1.00 79.27           C  
ATOM    764  CD  GLN A 104       6.362   2.859  23.074  1.00 77.00           C  
ATOM    765  OE1 GLN A 104       5.251   3.053  23.567  1.00 76.48           O  
ATOM    766  NE2 GLN A 104       7.504   3.109  23.735  1.00 89.91           N  
ATOM    767  N   GLY A 105       4.020  -0.305  19.884  1.00 61.77           N  
ATOM    768  CA  GLY A 105       3.811  -1.749  19.891  1.00 59.09           C  
ATOM    769  C   GLY A 105       4.031  -2.435  18.560  1.00 58.81           C  
ATOM    770  O   GLY A 105       4.630  -3.505  18.512  1.00 63.39           O  
ATOM    771  N   GLU A 106       3.574  -1.820  17.479  1.00 56.57           N  
ATOM    772  CA  GLU A 106       3.842  -2.321  16.134  1.00 56.00           C  
ATOM    773  C   GLU A 106       5.331  -2.369  15.830  1.00 55.09           C  
ATOM    774  O   GLU A 106       5.817  -3.367  15.303  1.00 55.77           O  
ATOM    775  CB  GLU A 106       3.120  -1.483  15.092  1.00 56.20           C  
ATOM    776  CG  GLU A 106       1.579  -1.560  15.242  1.00 68.38           C  
ATOM    777  CD  GLU A 106       0.816  -0.709  14.226  1.00 63.47           C  
ATOM    778  OE1 GLU A 106      -0.072  -1.275  13.561  1.00 78.24           O  
ATOM    779  OE2 GLU A 106       1.095   0.507  14.093  1.00 66.32           O  
ATOM    780  N   GLU A 107       6.043  -1.311  16.214  1.00 55.37           N  
ATOM    781  CA  GLU A 107       7.495  -1.215  16.064  1.00 55.44           C  
ATOM    782  C   GLU A 107       8.221  -2.304  16.868  1.00 55.39           C  
ATOM    783  O   GLU A 107       9.143  -2.931  16.382  1.00 58.30           O  
ATOM    784  CB  GLU A 107       7.975   0.192  16.461  1.00 51.82           C  
ATOM    785  CG  GLU A 107       9.439   0.512  16.148  1.00 64.91           C  
ATOM    786  N   PHE A 108       7.812  -2.528  18.100  1.00 55.91           N  
ATOM    787  CA  PHE A 108       8.368  -3.611  18.905  1.00 54.47           C  
ATOM    788  C   PHE A 108       8.227  -4.965  18.194  1.00 56.09           C  
ATOM    789  O   PHE A 108       9.162  -5.794  18.187  1.00 54.26           O  
ATOM    790  CB  PHE A 108       7.647  -3.662  20.249  1.00 50.98           C  
ATOM    791  CG  PHE A 108       8.169  -4.711  21.168  1.00 54.39           C  
ATOM    792  CD1 PHE A 108       9.099  -4.389  22.141  1.00 54.17           C  
ATOM    793  CD2 PHE A 108       7.731  -6.014  21.063  1.00 50.55           C  
ATOM    794  CE1 PHE A 108       9.596  -5.345  22.964  1.00 62.94           C  
ATOM    795  CE2 PHE A 108       8.221  -6.974  21.899  1.00 58.16           C  
ATOM    796  CZ  PHE A 108       9.162  -6.642  22.844  1.00 53.30           C  
ATOM    797  N   GLY A 109       7.059  -5.162  17.589  1.00 56.71           N  
ATOM    798  CA  GLY A 109       6.705  -6.409  16.944  1.00 57.76           C  
ATOM    799  C   GLY A 109       7.563  -6.686  15.739  1.00 58.68           C  
ATOM    800  O   GLY A 109       7.969  -7.824  15.508  1.00 61.75           O  
ATOM    801  N   ARG A 110       7.845  -5.634  14.981  1.00 58.09           N  
ATOM    802  CA  ARG A 110       8.689  -5.726  13.808  1.00 60.48           C  
ATOM    803  C   ARG A 110      10.159  -5.880  14.177  1.00 58.98           C  
ATOM    804  O   ARG A 110      10.872  -6.684  13.574  1.00 59.48           O  
ATOM    805  CB  ARG A 110       8.524  -4.479  12.946  1.00 67.16           C  
ATOM    806  CG  ARG A 110       7.171  -4.359  12.255  1.00 75.55           C  
ATOM    807  CD  ARG A 110       7.112  -3.105  11.352  1.00 75.60           C  
ATOM    808  NE  ARG A 110       6.088  -2.146  11.804  1.00 91.03           N  
ATOM    809  CZ  ARG A 110       6.320  -0.935  12.324  1.00 81.52           C  
ATOM    810  NH1 ARG A 110       5.289  -0.177  12.675  1.00 74.56           N  
ATOM    811  NH2 ARG A 110       7.561  -0.464  12.485  1.00 74.08           N  
ATOM    812  N   ARG A 111      10.605  -5.114  15.171  1.00 56.65           N  
ATOM    813  CA  ARG A 111      12.023  -5.039  15.495  1.00 56.03           C  
ATOM    814  C   ARG A 111      12.498  -6.089  16.490  1.00 55.44           C  
ATOM    815  O   ARG A 111      13.672  -6.376  16.546  1.00 57.11           O  
ATOM    816  CB  ARG A 111      12.361  -3.645  16.014  1.00 51.62           C  
ATOM    817  CG  ARG A 111      12.264  -2.550  14.952  1.00 63.37           C  
ATOM    818  CD  ARG A 111      13.639  -2.097  14.437  1.00 70.94           C  
ATOM    819  N   ILE A 112      11.607  -6.653  17.296  1.00 58.05           N  
ATOM    820  CA  ILE A 112      12.031  -7.563  18.359  1.00 57.26           C  
ATOM    821  C   ILE A 112      11.205  -8.845  18.285  1.00 59.84           C  
ATOM    822  O   ILE A 112      11.731  -9.906  17.967  1.00 60.88           O  
ATOM    823  CB  ILE A 112      11.919  -6.879  19.755  1.00 57.93           C  
ATOM    824  CG1 ILE A 112      12.931  -5.726  19.863  1.00 62.86           C  
ATOM    825  CG2 ILE A 112      12.177  -7.860  20.875  1.00 53.09           C  
ATOM    826  CD1 ILE A 112      12.975  -5.054  21.244  1.00 58.12           C  
ATOM    827  N   GLY A 113       9.915  -8.734  18.562  1.00 56.90           N  
ATOM    828  CA  GLY A 113       9.041  -9.867  18.480  1.00 60.60           C  
ATOM    829  C   GLY A 113       7.625  -9.582  18.929  1.00 58.90           C  
ATOM    830  O   GLY A 113       7.340  -8.564  19.530  1.00 63.64           O  
ATOM    831  N   ASP A 114       6.752 -10.526  18.648  1.00 57.86           N  
ATOM    832  CA  ASP A 114       5.337 -10.432  18.992  1.00 59.08           C  
ATOM    833  C   ASP A 114       5.062 -11.043  20.367  1.00 57.74           C  
ATOM    834  O   ASP A 114       5.410 -12.193  20.592  1.00 56.12           O  
ATOM    835  CB  ASP A 114       4.539 -11.191  17.946  1.00 57.61           C  
ATOM    836  CG  ASP A 114       4.700 -10.604  16.566  1.00 71.10           C  
ATOM    837  OD1 ASP A 114       4.580  -9.363  16.442  1.00 76.90           O  
ATOM    838  OD2 ASP A 114       4.960 -11.380  15.618  1.00 72.70           O  
ATOM    839  N   PRO A 115       4.420 -10.287  21.281  1.00 58.82           N  
ATOM    840  CA  PRO A 115       4.055 -10.894  22.581  1.00 58.42           C  
ATOM    841  C   PRO A 115       3.063 -12.046  22.399  1.00 55.93           C  
ATOM    842  O   PRO A 115       2.093 -11.925  21.658  1.00 54.53           O  
ATOM    843  CB  PRO A 115       3.369  -9.740  23.348  1.00 54.91           C  
ATOM    844  CG  PRO A 115       2.866  -8.825  22.263  1.00 64.83           C  
ATOM    845  CD  PRO A 115       3.928  -8.899  21.166  1.00 56.95           C  
ATOM    846  N   GLN A 116       3.276 -13.151  23.089  1.00 55.61           N  
ATOM    847  CA  GLN A 116       2.301 -14.254  23.014  1.00 55.58           C  
ATOM    848  C   GLN A 116       1.099 -14.049  23.964  1.00 55.84           C  
ATOM    849  O   GLN A 116       0.075 -14.699  23.820  1.00 58.94           O  
ATOM    850  CB  GLN A 116       2.993 -15.581  23.295  1.00 50.34           C  
ATOM    851  CG  GLN A 116       4.130 -15.892  22.330  1.00 48.59           C  
ATOM    852  CD  GLN A 116       5.509 -15.561  22.903  1.00 54.35           C  
ATOM    853  OE1 GLN A 116       5.646 -14.745  23.805  1.00 53.21           O  
ATOM    854  NE2 GLN A 116       6.525 -16.244  22.406  1.00 59.10           N  
ATOM    855  N   LEU A 117       1.247 -13.141  24.919  1.00 53.03           N  
ATOM    856  CA  LEU A 117       0.256 -12.874  25.928  1.00 52.09           C  
ATOM    857  C   LEU A 117       0.347 -11.405  26.355  1.00 55.29           C  
ATOM    858  O   LEU A 117       1.439 -10.897  26.631  1.00 54.85           O  
ATOM    859  CB  LEU A 117       0.506 -13.755  27.123  1.00 51.54           C  
ATOM    860  CG  LEU A 117      -0.407 -13.592  28.347  1.00 62.20           C  
ATOM    861  CD1 LEU A 117      -1.882 -13.820  28.005  1.00 48.28           C  
ATOM    862  CD2 LEU A 117       0.042 -14.528  29.455  1.00 57.57           C  
ATOM    863  N   VAL A 118      -0.798 -10.729  26.350  1.00 55.94           N  
ATOM    864  CA  VAL A 118      -0.971  -9.440  27.012  1.00 56.07           C  
ATOM    865  C   VAL A 118      -1.933  -9.596  28.190  1.00 54.70           C  
ATOM    866  O   VAL A 118      -3.056 -10.014  28.047  1.00 52.60           O  
ATOM    867  CB  VAL A 118      -1.496  -8.345  26.050  1.00 60.18           C  
ATOM    868  CG1 VAL A 118      -1.586  -6.974  26.780  1.00 57.39           C  
ATOM    869  CG2 VAL A 118      -0.610  -8.257  24.813  1.00 54.22           C  
ATOM    870  N   ILE A 119      -1.441  -9.284  29.366  1.00 59.75           N  
ATOM    871  CA  ILE A 119      -2.233  -9.319  30.569  1.00 58.01           C  
ATOM    872  C   ILE A 119      -2.673  -7.891  30.913  1.00 61.68           C  
ATOM    873  O   ILE A 119      -1.841  -6.966  30.965  1.00 63.37           O  
ATOM    874  CB  ILE A 119      -1.390  -9.858  31.701  1.00 58.39           C  
ATOM    875  CG1 ILE A 119      -0.962 -11.285  31.414  1.00 56.90           C  
ATOM    876  CG2 ILE A 119      -2.135  -9.771  33.026  1.00 61.05           C  
ATOM    877  CD1 ILE A 119       0.116 -11.772  32.368  1.00 66.84           C  
ATOM    878  N   CYS A 120      -3.967  -7.719  31.119  1.00 60.05           N  
ATOM    879  CA  CYS A 120      -4.538  -6.464  31.593  1.00 63.68           C  
ATOM    880  C   CYS A 120      -5.124  -6.663  32.983  1.00 62.44           C  
ATOM    881  O   CYS A 120      -6.032  -7.460  33.179  1.00 60.00           O  
ATOM    882  CB  CYS A 120      -5.654  -5.976  30.673  1.00 63.97           C  
ATOM    883  SG  CYS A 120      -5.140  -6.069  29.030  1.00 82.04           S  
ATOM    884  N   MET A 121      -4.594  -5.912  33.933  1.00 58.58           N  
ATOM    885  CA  MET A 121      -5.095  -5.930  35.274  1.00 64.00           C  
ATOM    886  C   MET A 121      -6.190  -4.909  35.452  1.00 63.90           C  
ATOM    887  O   MET A 121      -5.936  -3.715  35.613  1.00 70.87           O  
ATOM    888  CB  MET A 121      -3.948  -5.733  36.232  1.00 69.46           C  
ATOM    889  CG  MET A 121      -3.168  -7.060  36.360  1.00 73.66           C  
ATOM    890  SD  MET A 121      -1.744  -6.841  37.362  1.00 73.38           S  
ATOM    891  CE  MET A 121      -2.492  -6.533  38.958  1.00 66.34           C  
ATOM    892  N   ASP A 122      -7.414  -5.410  35.358  1.00 62.71           N  
ATOM    893  CA  ASP A 122      -8.642  -4.627  35.387  1.00 64.51           C  
ATOM    894  C   ASP A 122      -8.926  -4.277  36.825  1.00 62.93           C  
ATOM    895  O   ASP A 122      -8.991  -5.161  37.694  1.00 59.89           O  
ATOM    896  CB  ASP A 122      -9.856  -5.457  34.909  1.00 72.45           C  
ATOM    897  CG  ASP A 122     -10.339  -5.095  33.532  1.00 85.38           C  
ATOM    898  OD1 ASP A 122     -10.253  -3.913  33.128  1.00 97.77           O  
ATOM    899  OD2 ASP A 122     -10.868  -6.016  32.865  1.00100.39           O  
ATOM    900  N   CYS A 123      -9.199  -3.005  37.043  1.00 60.64           N  
ATOM    901  CA  CYS A 123      -9.542  -2.514  38.333  1.00 62.04           C  
ATOM    902  C   CYS A 123     -10.433  -1.292  38.119  1.00 57.48           C  
ATOM    903  O   CYS A 123     -10.194  -0.522  37.209  1.00 64.01           O  
ATOM    904  CB  CYS A 123      -8.239  -2.141  39.045  1.00 64.36           C  
ATOM    905  SG  CYS A 123      -8.422  -1.960  40.789  1.00 74.82           S  
ATOM    906  N   SER A 124     -11.432  -1.091  38.962  1.00 54.67           N  
ATOM    907  CA  SER A 124     -12.288   0.097  38.857  1.00 56.61           C  
ATOM    908  C   SER A 124     -11.557   1.366  39.294  1.00 55.91           C  
ATOM    909  O   SER A 124     -10.582   1.334  40.044  1.00 59.46           O  
ATOM    910  CB  SER A 124     -13.565  -0.054  39.677  1.00 51.02           C  
ATOM    911  OG  SER A 124     -13.284  -0.146  41.064  1.00 62.37           O  
ATOM    912  N   ALA A 125     -12.043   2.489  38.810  1.00 59.77           N  
ATOM    913  CA  ALA A 125     -11.485   3.770  39.160  1.00 57.77           C  
ATOM    914  C   ALA A 125     -11.661   4.019  40.655  1.00 58.09           C  
ATOM    915  O   ALA A 125     -10.750   4.548  41.307  1.00 58.90           O  
ATOM    916  CB  ALA A 125     -12.150   4.860  38.348  1.00 61.70           C  
ATOM    917  N   ASP A 126     -12.825   3.649  41.188  1.00 56.13           N  
ATOM    918  CA  ASP A 126     -13.090   3.782  42.622  1.00 60.49           C  
ATOM    919  C   ASP A 126     -12.090   3.002  43.467  1.00 58.78           C  
ATOM    920  O   ASP A 126     -11.662   3.465  44.527  1.00 61.18           O  
ATOM    921  CB  ASP A 126     -14.497   3.266  42.978  1.00 62.70           C  
ATOM    922  CG  ASP A 126     -15.627   4.211  42.537  1.00 88.17           C  
ATOM    923  OD1 ASP A 126     -15.361   5.354  42.086  1.00 81.76           O  
ATOM    924  OD2 ASP A 126     -16.812   3.787  42.652  1.00105.86           O  
ATOM    925  N   THR A 127     -11.778   1.778  43.041  1.00 59.04           N  
ATOM    926  CA  THR A 127     -10.859   0.913  43.800  1.00 58.22           C  
ATOM    927  C   THR A 127      -9.416   1.389  43.667  1.00 55.00           C  
ATOM    928  O   THR A 127      -8.696   1.431  44.645  1.00 60.42           O  
ATOM    929  CB  THR A 127     -10.995  -0.538  43.378  1.00 55.74           C  
ATOM    930  OG1 THR A 127     -12.276  -1.013  43.789  1.00 61.98           O  
ATOM    931  CG2 THR A 127      -9.931  -1.403  44.014  1.00 62.72           C  
ATOM    932  N   MET A 128      -8.999   1.766  42.471  1.00 54.59           N  
ATOM    933  CA  MET A 128      -7.664   2.348  42.299  1.00 57.23           C  
ATOM    934  C   MET A 128      -7.497   3.626  43.119  1.00 54.64           C  
ATOM    935  O   MET A 128      -6.520   3.807  43.809  1.00 57.71           O  
ATOM    936  CB  MET A 128      -7.411   2.651  40.835  1.00 56.82           C  
ATOM    937  CG  MET A 128      -7.237   1.393  39.972  1.00 57.57           C  
ATOM    938  SD  MET A 128      -6.492   1.707  38.342  1.00 65.74           S  
ATOM    939  CE  MET A 128      -7.917   2.201  37.425  1.00 61.60           C  
ATOM    940  N   THR A 129      -8.467   4.513  43.040  1.00 55.78           N  
ATOM    941  CA  THR A 129      -8.507   5.738  43.845  1.00 55.74           C  
ATOM    942  C   THR A 129      -8.355   5.485  45.338  1.00 55.32           C  
ATOM    943  O   THR A 129      -7.537   6.101  45.997  1.00 59.19           O  
ATOM    944  CB  THR A 129      -9.830   6.488  43.545  1.00 58.64           C  
ATOM    945  OG1 THR A 129      -9.857   6.786  42.143  1.00 58.45           O  
ATOM    946  CG2 THR A 129      -9.954   7.770  44.348  1.00 56.63           C  
ATOM    947  N   ASN A 130      -9.159   4.577  45.872  1.00 56.02           N  
ATOM    948  CA  ASN A 130      -9.101   4.239  47.289  1.00 56.00           C  
ATOM    949  C   ASN A 130      -7.754   3.632  47.724  1.00 55.41           C  
ATOM    950  O   ASN A 130      -7.220   3.987  48.761  1.00 56.09           O  
ATOM    951  CB  ASN A 130     -10.256   3.277  47.636  1.00 55.00           C  
ATOM    952  CG  ASN A 130     -10.163   2.764  49.041  1.00 58.15           C  
ATOM    953  OD1 ASN A 130      -9.563   1.716  49.286  1.00 55.35           O  
ATOM    954  ND2 ASN A 130     -10.737   3.507  49.989  1.00 47.59           N  
ATOM    955  N   ARG A 131      -7.213   2.709  46.930  1.00 53.69           N  
ATOM    956  CA  ARG A 131      -5.878   2.174  47.188  1.00 56.77           C  
ATOM    957  C   ARG A 131      -4.764   3.207  47.187  1.00 51.52           C  
ATOM    958  O   ARG A 131      -3.876   3.191  48.022  1.00 56.36           O  
ATOM    959  CB  ARG A 131      -5.553   1.067  46.182  1.00 55.66           C  
ATOM    960  CG  ARG A 131      -6.353  -0.226  46.476  1.00 50.56           C  
ATOM    961  CD  ARG A 131      -6.152  -1.206  45.321  1.00 61.20           C  
ATOM    962  NE  ARG A 131      -6.876  -2.456  45.481  1.00 59.18           N  
ATOM    963  CZ  ARG A 131      -6.880  -3.432  44.577  1.00 55.78           C  
ATOM    964  NH1 ARG A 131      -6.210  -3.303  43.448  1.00 58.91           N  
ATOM    965  NH2 ARG A 131      -7.581  -4.537  44.796  1.00 60.49           N  
ATOM    966  N   LEU A 132      -4.791   4.072  46.197  1.00 56.99           N  
ATOM    967  CA  LEU A 132      -3.840   5.135  46.081  1.00 55.20           C  
ATOM    968  C   LEU A 132      -3.985   6.140  47.253  1.00 55.29           C  
ATOM    969  O   LEU A 132      -2.991   6.634  47.763  1.00 59.23           O  
ATOM    970  CB  LEU A 132      -3.963   5.818  44.705  1.00 60.51           C  
ATOM    971  CG  LEU A 132      -3.468   5.012  43.490  1.00 52.88           C  
ATOM    972  CD1 LEU A 132      -3.677   5.788  42.228  1.00 55.05           C  
ATOM    973  CD2 LEU A 132      -2.034   4.621  43.615  1.00 54.97           C  
ATOM    974  N   LEU A 133      -5.192   6.417  47.708  1.00 56.18           N  
ATOM    975  CA  LEU A 133      -5.336   7.171  48.966  1.00 54.98           C  
ATOM    976  C   LEU A 133      -4.736   6.465  50.183  1.00 51.98           C  
ATOM    977  O   LEU A 133      -4.128   7.084  51.059  1.00 54.11           O  
ATOM    978  CB  LEU A 133      -6.791   7.492  49.232  1.00 54.82           C  
ATOM    979  CG  LEU A 133      -7.442   8.492  48.281  1.00 49.80           C  
ATOM    980  CD1 LEU A 133      -8.944   8.496  48.568  1.00 59.04           C  
ATOM    981  CD2 LEU A 133      -6.878   9.905  48.417  1.00 59.06           C  
ATOM    982  N   GLN A 134      -4.888   5.158  50.244  1.00 56.95           N  
ATOM    983  CA  GLN A 134      -4.278   4.397  51.328  1.00 53.76           C  
ATOM    984  C   GLN A 134      -2.762   4.432  51.322  1.00 54.32           C  
ATOM    985  O   GLN A 134      -2.133   4.232  52.351  1.00 58.74           O  
ATOM    986  CB  GLN A 134      -4.745   2.953  51.285  1.00 54.34           C  
ATOM    987  CG  GLN A 134      -6.189   2.745  51.737  1.00 53.69           C  
ATOM    988  CD  GLN A 134      -6.533   1.271  51.780  1.00 49.05           C  
ATOM    989  OE1 GLN A 134      -5.868   0.513  52.438  1.00 58.98           O  
ATOM    990  NE2 GLN A 134      -7.563   0.870  51.058  1.00 61.83           N  
ATOM    991  N   MET A 135      -2.182   4.632  50.149  1.00 57.54           N  
ATOM    992  CA  MET A 135      -0.732   4.737  49.974  1.00 61.54           C  
ATOM    993  C   MET A 135      -0.272   6.189  49.895  1.00 58.77           C  
ATOM    994  O   MET A 135       0.884   6.458  49.649  1.00 62.69           O  
ATOM    995  CB  MET A 135      -0.341   4.069  48.664  1.00 54.38           C  
ATOM    996  CG  MET A 135      -0.388   2.533  48.658  1.00 83.84           C  
ATOM    997  SD  MET A 135      -0.483   1.949  46.928  1.00 95.71           S  
ATOM    998  CE  MET A 135       1.057   2.569  46.232  1.00116.23           C  
ATOM    999  N   SER A 136      -1.175   7.135  50.078  1.00 57.71           N  
ATOM   1000  CA  SER A 136      -0.825   8.534  49.957  1.00 58.62           C  
ATOM   1001  C   SER A 136       0.044   9.035  51.114  1.00 58.69           C  
ATOM   1002  O   SER A 136      -0.100   8.591  52.271  1.00 58.08           O  
ATOM   1003  CB  SER A 136      -2.085   9.384  49.891  1.00 60.56           C  
ATOM   1004  OG  SER A 136      -1.751  10.670  49.445  1.00 61.49           O  
ATOM   1005  N   ARG A 137       0.948   9.951  50.759  1.00 60.21           N  
ATOM   1006  CA  ARG A 137       1.709  10.764  51.704  1.00 59.11           C  
ATOM   1007  C   ARG A 137       1.420  12.275  51.477  1.00 57.83           C  
ATOM   1008  O   ARG A 137       2.200  13.144  51.830  1.00 61.18           O  
ATOM   1009  CB  ARG A 137       3.182  10.429  51.572  1.00 57.80           C  
ATOM   1010  CG  ARG A 137       3.583   9.024  52.131  1.00 64.70           C  
ATOM   1011  CD  ARG A 137       3.433   8.938  53.653  1.00 85.42           C  
ATOM   1012  NE  ARG A 137       4.228   9.973  54.324  1.00105.45           N  
ATOM   1013  CZ  ARG A 137       4.064  10.396  55.581  1.00101.99           C  
ATOM   1014  NH1 ARG A 137       3.121   9.883  56.375  1.00 98.77           N  
ATOM   1015  NH2 ARG A 137       4.862  11.353  56.046  1.00 97.18           N  
ATOM   1016  N   SER A 138       0.259  12.550  50.901  1.00 57.20           N  
ATOM   1017  CA  SER A 138      -0.220  13.882  50.687  1.00 58.63           C  
ATOM   1018  C   SER A 138      -0.422  14.640  51.995  1.00 56.63           C  
ATOM   1019  O   SER A 138      -1.023  14.141  52.913  1.00 60.35           O  
ATOM   1020  CB  SER A 138      -1.526  13.852  49.895  1.00 52.34           C  
ATOM   1021  OG  SER A 138      -1.947  15.171  49.578  1.00 57.76           O  
ATOM   1022  N   SER A 139       0.096  15.858  52.010  1.00 55.23           N  
ATOM   1023  CA  SER A 139      -0.106  16.862  53.046  1.00 59.68           C  
ATOM   1024  C   SER A 139      -1.178  17.864  52.648  1.00 54.76           C  
ATOM   1025  O   SER A 139      -1.268  18.934  53.242  1.00 55.50           O  
ATOM   1026  CB  SER A 139       1.200  17.654  53.212  1.00 53.52           C  
ATOM   1027  OG  SER A 139       2.179  16.806  53.751  1.00 72.80           O  
ATOM   1028  N   LEU A 140      -1.929  17.539  51.604  1.00 54.42           N  
ATOM   1029  CA  LEU A 140      -2.986  18.393  51.082  1.00 57.35           C  
ATOM   1030  C   LEU A 140      -4.318  17.732  51.421  1.00 54.82           C  
ATOM   1031  O   LEU A 140      -4.345  16.543  51.691  1.00 56.14           O  
ATOM   1032  CB  LEU A 140      -2.840  18.550  49.560  1.00 58.05           C  
ATOM   1033  CG  LEU A 140      -1.547  19.192  49.061  1.00 63.30           C  
ATOM   1034  CD1 LEU A 140      -1.486  19.107  47.552  1.00 59.58           C  
ATOM   1035  CD2 LEU A 140      -1.465  20.631  49.497  1.00 66.31           C  
ATOM   1036  N   PRO A 141      -5.424  18.513  51.462  1.00 54.58           N  
ATOM   1037  CA  PRO A 141      -6.737  17.933  51.759  1.00 54.85           C  
ATOM   1038  C   PRO A 141      -7.135  16.794  50.826  1.00 56.65           C  
ATOM   1039  O   PRO A 141      -6.606  16.691  49.740  1.00 62.02           O  
ATOM   1040  CB  PRO A 141      -7.689  19.119  51.619  1.00 53.11           C  
ATOM   1041  CG  PRO A 141      -6.844  20.313  51.898  1.00 58.12           C  
ATOM   1042  CD  PRO A 141      -5.504  19.977  51.286  1.00 53.50           C  
ATOM   1043  N   VAL A 142      -8.045  15.930  51.256  1.00 56.20           N  
ATOM   1044  CA  VAL A 142      -8.405  14.788  50.441  1.00 56.74           C  
ATOM   1045  C   VAL A 142      -9.006  15.180  49.078  1.00 58.80           C  
ATOM   1046  O   VAL A 142      -8.856  14.445  48.117  1.00 60.37           O  
ATOM   1047  CB  VAL A 142      -9.319  13.793  51.189  1.00 59.44           C  
ATOM   1048  CG1 VAL A 142     -10.756  14.354  51.400  1.00 55.54           C  
ATOM   1049  CG2 VAL A 142      -9.382  12.493  50.448  1.00 57.96           C  
ATOM   1050  N   ASP A 143      -9.709  16.309  49.009  1.00 62.28           N  
ATOM   1051  CA  ASP A 143     -10.280  16.771  47.732  1.00 66.01           C  
ATOM   1052  C   ASP A 143      -9.207  17.094  46.698  1.00 61.92           C  
ATOM   1053  O   ASP A 143      -9.341  16.707  45.547  1.00 63.30           O  
ATOM   1054  CB  ASP A 143     -11.177  18.009  47.923  1.00 66.14           C  
ATOM   1055  CG  ASP A 143     -12.542  17.668  48.548  1.00 94.02           C  
ATOM   1056  OD1 ASP A 143     -12.854  16.461  48.787  1.00 96.80           O  
ATOM   1057  OD2 ASP A 143     -13.301  18.631  48.811  1.00100.32           O  
ATOM   1058  N   ASP A 144      -8.182  17.843  47.109  1.00 58.92           N  
ATOM   1059  CA  ASP A 144      -7.073  18.212  46.235  1.00 57.89           C  
ATOM   1060  C   ASP A 144      -6.290  16.965  45.879  1.00 57.52           C  
ATOM   1061  O   ASP A 144      -5.919  16.760  44.744  1.00 58.14           O  
ATOM   1062  CB  ASP A 144      -6.105  19.174  46.934  1.00 65.02           C  
ATOM   1063  CG  ASP A 144      -6.803  20.417  47.553  1.00 87.18           C  
ATOM   1064  OD1 ASP A 144      -8.036  20.380  47.835  1.00 97.58           O  
ATOM   1065  OD2 ASP A 144      -6.088  21.428  47.804  1.00 90.92           O  
ATOM   1066  N   THR A 145      -6.031  16.142  46.894  1.00 58.84           N  
ATOM   1067  CA  THR A 145      -5.308  14.899  46.752  1.00 55.73           C  
ATOM   1068  C   THR A 145      -6.007  13.955  45.757  1.00 57.52           C  
ATOM   1069  O   THR A 145      -5.375  13.374  44.879  1.00 53.23           O  
ATOM   1070  CB  THR A 145      -5.122  14.244  48.114  1.00 54.29           C  
ATOM   1071  OG1 THR A 145      -4.339  15.102  48.953  1.00 58.96           O  
ATOM   1072  CG2 THR A 145      -4.439  12.913  47.994  1.00 54.54           C  
ATOM   1073  N   THR A 146      -7.314  13.832  45.877  1.00 56.78           N  
ATOM   1074  CA  THR A 146      -8.085  12.950  44.998  1.00 58.47           C  
ATOM   1075  C   THR A 146      -8.172  13.471  43.563  1.00 57.88           C  
ATOM   1076  O   THR A 146      -8.193  12.682  42.634  1.00 59.43           O  
ATOM   1077  CB  THR A 146      -9.497  12.717  45.579  1.00 61.98           C  
ATOM   1078  OG1 THR A 146      -9.369  12.201  46.910  1.00 63.41           O  
ATOM   1079  CG2 THR A 146     -10.260  11.742  44.726  1.00 67.32           C  
ATOM   1080  N   LYS A 147      -8.212  14.789  43.383  1.00 58.88           N  
ATOM   1081  CA  LYS A 147      -8.155  15.381  42.040  1.00 61.45           C  
ATOM   1082  C   LYS A 147      -6.874  15.031  41.288  1.00 59.89           C  
ATOM   1083  O   LYS A 147      -6.900  14.823  40.065  1.00 62.62           O  
ATOM   1084  CB  LYS A 147      -8.361  16.915  42.063  1.00 55.99           C  
ATOM   1085  CG  LYS A 147      -9.831  17.311  42.337  1.00 68.57           C  
ATOM   1086  CD  LYS A 147     -10.056  18.826  42.460  1.00 72.55           C  
ATOM   1087  N   THR A 148      -5.758  14.997  42.006  1.00 58.25           N  
ATOM   1088  CA  THR A 148      -4.489  14.613  41.423  1.00 57.08           C  
ATOM   1089  C   THR A 148      -4.465  13.122  41.111  1.00 55.59           C  
ATOM   1090  O   THR A 148      -3.881  12.720  40.118  1.00 53.66           O  
ATOM   1091  CB  THR A 148      -3.313  14.949  42.357  1.00 56.75           C  
ATOM   1092  OG1 THR A 148      -3.318  16.344  42.628  1.00 52.28           O  
ATOM   1093  CG2 THR A 148      -1.987  14.609  41.734  1.00 54.13           C  
ATOM   1094  N   ILE A 149      -5.069  12.309  41.971  1.00 56.09           N  
ATOM   1095  CA  ILE A 149      -5.202  10.885  41.702  1.00 57.13           C  
ATOM   1096  C   ILE A 149      -6.073  10.649  40.459  1.00 57.89           C  
ATOM   1097  O   ILE A 149      -5.770   9.796  39.634  1.00 59.42           O  
ATOM   1098  CB  ILE A 149      -5.764  10.133  42.919  1.00 57.92           C  
ATOM   1099  CG1 ILE A 149      -4.705  10.017  44.015  1.00 57.87           C  
ATOM   1100  CG2 ILE A 149      -6.230   8.713  42.549  1.00 61.01           C  
ATOM   1101  CD1 ILE A 149      -5.285   9.531  45.338  1.00 55.63           C  
ATOM   1102  N   ALA A 150      -7.163  11.390  40.343  1.00 54.43           N  
ATOM   1103  CA  ALA A 150      -8.013  11.329  39.140  1.00 59.35           C  
ATOM   1104  C   ALA A 150      -7.203  11.609  37.857  1.00 58.29           C  
ATOM   1105  O   ALA A 150      -7.370  10.960  36.834  1.00 60.83           O  
ATOM   1106  CB  ALA A 150      -9.200  12.314  39.286  1.00 59.32           C  
ATOM   1107  N   LYS A 151      -6.290  12.561  37.919  1.00 62.98           N  
ATOM   1108  CA  LYS A 151      -5.382  12.824  36.791  1.00 57.77           C  
ATOM   1109  C   LYS A 151      -4.417  11.684  36.456  1.00 54.15           C  
ATOM   1110  O   LYS A 151      -4.078  11.455  35.290  1.00 58.37           O  
ATOM   1111  CB  LYS A 151      -4.579  14.076  37.069  1.00 59.24           C  
ATOM   1112  CG  LYS A 151      -5.371  15.319  37.047  1.00 54.71           C  
ATOM   1113  CD  LYS A 151      -4.436  16.507  37.263  1.00 68.88           C  
ATOM   1114  CE  LYS A 151      -5.186  17.854  37.245  1.00 85.84           C  
ATOM   1115  N   ARG A 152      -3.920  11.013  37.478  1.00 53.82           N  
ATOM   1116  CA  ARG A 152      -3.143   9.800  37.309  1.00 57.46           C  
ATOM   1117  C   ARG A 152      -3.906   8.680  36.594  1.00 55.22           C  
ATOM   1118  O   ARG A 152      -3.339   7.947  35.796  1.00 61.47           O  
ATOM   1119  CB  ARG A 152      -2.676   9.274  38.667  1.00 59.46           C  
ATOM   1120  CG  ARG A 152      -1.804  10.257  39.447  1.00 55.73           C  
ATOM   1121  CD  ARG A 152      -1.402   9.639  40.763  1.00 59.66           C  
ATOM   1122  NE  ARG A 152      -0.520   8.513  40.517  1.00 60.57           N  
ATOM   1123  CZ  ARG A 152      -0.062   7.693  41.460  1.00 62.16           C  
ATOM   1124  NH1 ARG A 152      -0.381   7.886  42.734  1.00 62.68           N  
ATOM   1125  NH2 ARG A 152       0.715   6.681  41.107  1.00 54.71           N  
ATOM   1126  N   LEU A 153      -5.174   8.523  36.907  1.00 57.41           N  
ATOM   1127  CA  LEU A 153      -6.011   7.527  36.222  1.00 56.73           C  
ATOM   1128  C   LEU A 153      -6.320   7.943  34.781  1.00 56.01           C  
ATOM   1129  O   LEU A 153      -6.234   7.133  33.866  1.00 59.17           O  
ATOM   1130  CB  LEU A 153      -7.293   7.305  37.008  1.00 60.85           C  
ATOM   1131  CG  LEU A 153      -7.139   6.645  38.406  1.00 59.24           C  
ATOM   1132  CD1 LEU A 153      -8.473   6.215  38.893  1.00 70.51           C  
ATOM   1133  CD2 LEU A 153      -6.206   5.489  38.384  1.00 72.66           C  
ATOM   1134  N   GLU A 154      -6.620   9.219  34.582  1.00 50.90           N  
ATOM   1135  CA  GLU A 154      -6.813   9.768  33.249  1.00 57.30           C  
ATOM   1136  C   GLU A 154      -5.638   9.459  32.367  1.00 57.78           C  
ATOM   1137  O   GLU A 154      -5.837   9.080  31.222  1.00 56.45           O  
ATOM   1138  CB  GLU A 154      -7.017  11.281  33.301  1.00 52.09           C  
ATOM   1139  CG  GLU A 154      -8.371  11.621  33.934  1.00 60.81           C  
ATOM   1140  CD  GLU A 154      -8.551  13.107  34.215  1.00 68.45           C  
ATOM   1141  OE1 GLU A 154      -7.706  13.901  33.773  1.00 81.10           O  
ATOM   1142  OE2 GLU A 154      -9.545  13.482  34.879  1.00 87.29           O  
ATOM   1143  N   ALA A 155      -4.421   9.624  32.898  1.00 56.27           N  
ATOM   1144  CA  ALA A 155      -3.222   9.388  32.112  1.00 56.78           C  
ATOM   1145  C   ALA A 155      -3.071   7.927  31.777  1.00 54.45           C  
ATOM   1146  O   ALA A 155      -2.633   7.571  30.676  1.00 60.12           O  
ATOM   1147  CB  ALA A 155      -1.985   9.896  32.816  1.00 59.10           C  
ATOM   1148  N   TYR A 156      -3.418   7.081  32.724  1.00 56.12           N  
ATOM   1149  CA  TYR A 156      -3.455   5.642  32.478  1.00 56.45           C  
ATOM   1150  C   TYR A 156      -4.455   5.247  31.399  1.00 54.67           C  
ATOM   1151  O   TYR A 156      -4.140   4.456  30.535  1.00 58.03           O  
ATOM   1152  CB  TYR A 156      -3.758   4.864  33.768  1.00 58.27           C  
ATOM   1153  CG  TYR A 156      -3.997   3.404  33.499  1.00 54.84           C  
ATOM   1154  CD1 TYR A 156      -2.974   2.599  32.996  1.00 61.74           C  
ATOM   1155  CD2 TYR A 156      -5.268   2.852  33.631  1.00 55.11           C  
ATOM   1156  CE1 TYR A 156      -3.202   1.261  32.686  1.00 57.36           C  
ATOM   1157  CE2 TYR A 156      -5.495   1.523  33.353  1.00 62.37           C  
ATOM   1158  CZ  TYR A 156      -4.458   0.740  32.864  1.00 49.59           C  
ATOM   1159  OH  TYR A 156      -4.725  -0.562  32.590  1.00 64.42           O  
ATOM   1160  N   TYR A 157      -5.670   5.772  31.462  1.00 57.94           N  
ATOM   1161  CA  TYR A 157      -6.684   5.401  30.481  1.00 54.93           C  
ATOM   1162  C   TYR A 157      -6.272   5.838  29.073  1.00 55.97           C  
ATOM   1163  O   TYR A 157      -6.502   5.146  28.083  1.00 54.19           O  
ATOM   1164  CB  TYR A 157      -8.015   6.015  30.872  1.00 57.28           C  
ATOM   1165  CG  TYR A 157      -8.585   5.470  32.157  1.00 52.94           C  
ATOM   1166  CD1 TYR A 157      -8.653   4.108  32.386  1.00 53.21           C  
ATOM   1167  CD2 TYR A 157      -9.059   6.321  33.152  1.00 61.03           C  
ATOM   1168  CE1 TYR A 157      -9.193   3.607  33.555  1.00 51.03           C  
ATOM   1169  CE2 TYR A 157      -9.589   5.816  34.337  1.00 54.80           C  
ATOM   1170  CZ  TYR A 157      -9.653   4.458  34.532  1.00 64.20           C  
ATOM   1171  OH  TYR A 157     -10.191   3.924  35.706  1.00 59.92           O  
ATOM   1172  N   ARG A 158      -5.665   7.004  28.977  1.00 57.00           N  
ATOM   1173  CA  ARG A 158      -5.173   7.493  27.699  1.00 58.63           C  
ATOM   1174  C   ARG A 158      -4.139   6.560  27.108  1.00 59.29           C  
ATOM   1175  O   ARG A 158      -4.154   6.281  25.922  1.00 65.28           O  
ATOM   1176  CB  ARG A 158      -4.541   8.860  27.880  1.00 59.53           C  
ATOM   1177  CG  ARG A 158      -5.480   9.981  27.681  1.00 58.77           C  
ATOM   1178  CD  ARG A 158      -4.731  11.323  27.778  1.00 63.72           C  
ATOM   1179  NE  ARG A 158      -5.188  12.070  28.957  1.00 77.67           N  
ATOM   1180  CZ  ARG A 158      -4.447  12.428  30.006  1.00 80.41           C  
ATOM   1181  NH1 ARG A 158      -3.109  12.241  30.056  1.00 74.60           N  
ATOM   1182  NH2 ARG A 158      -5.063  13.064  30.992  1.00 84.97           N  
ATOM   1183  N   ALA A 159      -3.221   6.097  27.939  1.00 60.91           N  
ATOM   1184  CA  ALA A 159      -2.148   5.240  27.481  1.00 64.81           C  
ATOM   1185  C   ALA A 159      -2.622   3.829  27.138  1.00 62.35           C  
ATOM   1186  O   ALA A 159      -2.053   3.176  26.262  1.00 70.34           O  
ATOM   1187  CB  ALA A 159      -1.038   5.176  28.546  1.00 64.15           C  
ATOM   1188  N   SER A 160      -3.641   3.355  27.839  1.00 59.85           N  
ATOM   1189  CA  SER A 160      -3.959   1.936  27.881  1.00 57.85           C  
ATOM   1190  C   SER A 160      -5.044   1.526  26.901  1.00 58.80           C  
ATOM   1191  O   SER A 160      -4.956   0.477  26.278  1.00 60.15           O  
ATOM   1192  CB  SER A 160      -4.358   1.520  29.306  1.00 61.07           C  
ATOM   1193  OG  SER A 160      -5.555   2.146  29.730  1.00 66.12           O  
ATOM   1194  N   ILE A 161      -6.079   2.348  26.774  1.00 56.26           N  
ATOM   1195  CA  ILE A 161      -7.263   1.965  26.000  1.00 55.88           C  
ATOM   1196  C   ILE A 161      -6.951   1.592  24.538  1.00 53.00           C  
ATOM   1197  O   ILE A 161      -7.393   0.537  24.074  1.00 55.65           O  
ATOM   1198  CB  ILE A 161      -8.386   3.044  26.114  1.00 51.66           C  
ATOM   1199  CG1 ILE A 161      -9.001   2.991  27.527  1.00 54.16           C  
ATOM   1200  CG2 ILE A 161      -9.445   2.851  25.034  1.00 53.10           C  
ATOM   1201  CD1 ILE A 161     -10.071   4.037  27.795  1.00 50.13           C  
ATOM   1202  N   PRO A 162      -6.211   2.448  23.810  1.00 52.33           N  
ATOM   1203  CA  PRO A 162      -5.899   2.123  22.413  1.00 53.90           C  
ATOM   1204  C   PRO A 162      -5.068   0.858  22.278  1.00 51.15           C  
ATOM   1205  O   PRO A 162      -5.278   0.066  21.390  1.00 52.78           O  
ATOM   1206  CB  PRO A 162      -5.094   3.336  21.936  1.00 57.50           C  
ATOM   1207  CG  PRO A 162      -5.330   4.407  22.915  1.00 55.59           C  
ATOM   1208  CD  PRO A 162      -5.662   3.749  24.208  1.00 52.66           C  
ATOM   1209  N   VAL A 163      -4.134   0.696  23.196  1.00 55.39           N  
ATOM   1210  CA  VAL A 163      -3.212  -0.398  23.225  1.00 55.40           C  
ATOM   1211  C   VAL A 163      -3.900  -1.725  23.501  1.00 54.17           C  
ATOM   1212  O   VAL A 163      -3.682  -2.717  22.785  1.00 55.04           O  
ATOM   1213  CB  VAL A 163      -2.066  -0.099  24.248  1.00 57.95           C  
ATOM   1214  CG1 VAL A 163      -1.225  -1.340  24.505  1.00 63.51           C  
ATOM   1215  CG2 VAL A 163      -1.194   1.047  23.725  1.00 57.55           C  
ATOM   1216  N   ILE A 164      -4.734  -1.747  24.531  1.00 58.03           N  
ATOM   1217  CA  ILE A 164      -5.521  -2.932  24.845  1.00 54.38           C  
ATOM   1218  C   ILE A 164      -6.434  -3.336  23.697  1.00 53.34           C  
ATOM   1219  O   ILE A 164      -6.509  -4.502  23.360  1.00 56.28           O  
ATOM   1220  CB  ILE A 164      -6.296  -2.752  26.165  1.00 58.56           C  
ATOM   1221  CG1 ILE A 164      -5.323  -2.852  27.347  1.00 57.69           C  
ATOM   1222  CG2 ILE A 164      -7.363  -3.814  26.325  1.00 61.11           C  
ATOM   1223  CD1 ILE A 164      -5.887  -2.314  28.650  1.00 63.65           C  
ATOM   1224  N   ALA A 165      -7.117  -2.360  23.095  1.00 56.06           N  
ATOM   1225  CA  ALA A 165      -7.988  -2.600  21.968  1.00 52.03           C  
ATOM   1226  C   ALA A 165      -7.209  -3.204  20.806  1.00 51.70           C  
ATOM   1227  O   ALA A 165      -7.685  -4.105  20.143  1.00 55.19           O  
ATOM   1228  CB  ALA A 165      -8.660  -1.286  21.530  1.00 55.90           C  
ATOM   1229  N   TYR A 166      -6.018  -2.680  20.542  1.00 55.42           N  
ATOM   1230  CA  TYR A 166      -5.166  -3.220  19.488  1.00 54.87           C  
ATOM   1231  C   TYR A 166      -4.747  -4.688  19.727  1.00 54.12           C  
ATOM   1232  O   TYR A 166      -4.923  -5.531  18.849  1.00 54.18           O  
ATOM   1233  CB  TYR A 166      -3.947  -2.313  19.262  1.00 54.09           C  
ATOM   1234  CG  TYR A 166      -2.930  -2.893  18.318  1.00 56.98           C  
ATOM   1235  CD1 TYR A 166      -3.106  -2.822  16.926  1.00 55.33           C  
ATOM   1236  CD2 TYR A 166      -1.768  -3.500  18.811  1.00 48.48           C  
ATOM   1237  CE1 TYR A 166      -2.151  -3.355  16.054  1.00 60.68           C  
ATOM   1238  CE2 TYR A 166      -0.817  -4.042  17.949  1.00 56.17           C  
ATOM   1239  CZ  TYR A 166      -1.004  -3.964  16.579  1.00 59.81           C  
ATOM   1240  OH  TYR A 166      -0.038  -4.508  15.766  1.00 60.30           O  
ATOM   1241  N   TYR A 167      -4.188  -4.989  20.892  1.00 52.67           N  
ATOM   1242  CA  TYR A 167      -3.696  -6.346  21.155  1.00 56.48           C  
ATOM   1243  C   TYR A 167      -4.783  -7.391  21.305  1.00 59.33           C  
ATOM   1244  O   TYR A 167      -4.509  -8.577  21.136  1.00 61.93           O  
ATOM   1245  CB  TYR A 167      -2.748  -6.391  22.352  1.00 58.03           C  
ATOM   1246  CG  TYR A 167      -1.390  -5.880  21.999  1.00 52.40           C  
ATOM   1247  CD1 TYR A 167      -0.576  -6.582  21.109  1.00 54.50           C  
ATOM   1248  CD2 TYR A 167      -0.927  -4.665  22.511  1.00 61.36           C  
ATOM   1249  CE1 TYR A 167       0.685  -6.093  20.752  1.00 53.49           C  
ATOM   1250  CE2 TYR A 167       0.328  -4.169  22.159  1.00 63.56           C  
ATOM   1251  CZ  TYR A 167       1.121  -4.882  21.283  1.00 61.72           C  
ATOM   1252  OH  TYR A 167       2.355  -4.386  20.954  1.00 62.67           O  
ATOM   1253  N   GLU A 168      -6.008  -6.954  21.591  1.00 57.75           N  
ATOM   1254  CA  GLU A 168      -7.190  -7.809  21.458  1.00 62.72           C  
ATOM   1255  C   GLU A 168      -7.338  -8.416  20.079  1.00 61.70           C  
ATOM   1256  O   GLU A 168      -7.791  -9.542  19.947  1.00 60.48           O  
ATOM   1257  CB  GLU A 168      -8.474  -7.016  21.751  1.00 59.17           C  
ATOM   1258  CG  GLU A 168      -8.773  -6.875  23.216  1.00 78.06           C  
ATOM   1259  CD  GLU A 168     -10.001  -6.017  23.496  1.00 79.66           C  
ATOM   1260  OE1 GLU A 168     -10.876  -5.858  22.600  1.00 92.94           O  
ATOM   1261  OE2 GLU A 168     -10.078  -5.514  24.634  1.00 78.18           O  
ATOM   1262  N   THR A 169      -7.007  -7.642  19.049  1.00 63.77           N  
ATOM   1263  CA  THR A 169      -7.109  -8.111  17.670  1.00 65.00           C  
ATOM   1264  C   THR A 169      -5.908  -8.979  17.263  1.00 64.40           C  
ATOM   1265  O   THR A 169      -6.006  -9.764  16.326  1.00 65.09           O  
ATOM   1266  CB  THR A 169      -7.275  -6.920  16.677  1.00 60.80           C  
ATOM   1267  OG1 THR A 169      -6.092  -6.092  16.664  1.00 67.66           O  
ATOM   1268  CG2 THR A 169      -8.454  -6.065  17.085  1.00 65.36           C  
ATOM   1269  N   LYS A 170      -4.795  -8.854  17.976  1.00 63.61           N  
ATOM   1270  CA  LYS A 170      -3.523  -9.373  17.483  1.00 64.50           C  
ATOM   1271  C   LYS A 170      -3.006 -10.596  18.213  1.00 64.33           C  
ATOM   1272  O   LYS A 170      -2.360 -11.417  17.606  1.00 68.94           O  
ATOM   1273  CB  LYS A 170      -2.446  -8.271  17.474  1.00 61.59           C  
ATOM   1274  CG  LYS A 170      -2.724  -7.129  16.492  1.00 75.47           C  
ATOM   1275  CD  LYS A 170      -2.734  -7.565  15.006  1.00 83.97           C  
ATOM   1276  CE  LYS A 170      -3.475  -6.550  14.091  1.00 80.04           C  
ATOM   1277  N   THR A 171      -3.277 -10.737  19.500  1.00 66.32           N  
ATOM   1278  CA  THR A 171      -2.707 -11.847  20.249  1.00 62.23           C  
ATOM   1279  C   THR A 171      -3.689 -12.304  21.319  1.00 60.61           C  
ATOM   1280  O   THR A 171      -4.861 -11.957  21.278  1.00 61.87           O  
ATOM   1281  CB  THR A 171      -1.294 -11.454  20.817  1.00 62.43           C  
ATOM   1282  OG1 THR A 171      -0.586 -12.622  21.264  1.00 59.51           O  
ATOM   1283  CG2 THR A 171      -1.382 -10.434  21.938  1.00 56.91           C  
ATOM   1284  N   GLN A 172      -3.223 -13.117  22.252  1.00 59.42           N  
ATOM   1285  CA  GLN A 172      -4.031 -13.508  23.413  1.00 57.17           C  
ATOM   1286  C   GLN A 172      -3.930 -12.423  24.461  1.00 57.82           C  
ATOM   1287  O   GLN A 172      -2.820 -12.081  24.906  1.00 60.35           O  
ATOM   1288  CB  GLN A 172      -3.511 -14.819  24.000  1.00 60.64           C  
ATOM   1289  CG  GLN A 172      -3.713 -15.989  23.091  1.00 61.56           C  
ATOM   1290  CD  GLN A 172      -5.170 -16.375  23.002  1.00 74.04           C  
ATOM   1291  OE1 GLN A 172      -5.829 -16.613  24.024  1.00 66.63           O  
ATOM   1292  NE2 GLN A 172      -5.696 -16.401  21.782  1.00 87.47           N  
ATOM   1293  N   LEU A 173      -5.079 -11.861  24.828  1.00 56.41           N  
ATOM   1294  CA  LEU A 173      -5.182 -10.841  25.851  1.00 57.54           C  
ATOM   1295  C   LEU A 173      -6.110 -11.360  26.966  1.00 55.63           C  
ATOM   1296  O   LEU A 173      -7.238 -11.747  26.714  1.00 56.78           O  
ATOM   1297  CB  LEU A 173      -5.687  -9.508  25.225  1.00 61.91           C  
ATOM   1298  CG  LEU A 173      -5.667  -8.267  26.140  1.00 56.10           C  
ATOM   1299  CD1 LEU A 173      -5.138  -6.992  25.450  1.00 55.78           C  
ATOM   1300  CD2 LEU A 173      -7.063  -8.035  26.664  1.00 62.69           C  
ATOM   1301  N   HIS A 174      -5.601 -11.409  28.194  1.00 58.87           N  
ATOM   1302  CA  HIS A 174      -6.359 -11.902  29.340  1.00 56.50           C  
ATOM   1303  C   HIS A 174      -6.566 -10.733  30.272  1.00 60.53           C  
ATOM   1304  O   HIS A 174      -5.604 -10.075  30.665  1.00 55.42           O  
ATOM   1305  CB  HIS A 174      -5.640 -13.042  30.042  1.00 58.40           C  
ATOM   1306  CG  HIS A 174      -5.596 -14.320  29.250  1.00 60.94           C  
ATOM   1307  ND1 HIS A 174      -5.532 -14.348  27.875  1.00 78.81           N  
ATOM   1308  CD2 HIS A 174      -5.558 -15.611  29.648  1.00 72.59           C  
ATOM   1309  CE1 HIS A 174      -5.474 -15.599  27.459  1.00 68.60           C  
ATOM   1310  NE2 HIS A 174      -5.472 -16.384  28.516  1.00 60.41           N  
ATOM   1311  N   LYS A 175      -7.836 -10.434  30.553  1.00 59.23           N  
ATOM   1312  CA  LYS A 175      -8.185  -9.416  31.517  1.00 62.46           C  
ATOM   1313  C   LYS A 175      -8.322 -10.095  32.872  1.00 61.12           C  
ATOM   1314  O   LYS A 175      -9.110 -10.992  33.031  1.00 65.45           O  
ATOM   1315  CB  LYS A 175      -9.452  -8.663  31.085  1.00 59.13           C  
ATOM   1316  CG  LYS A 175      -9.212  -7.968  29.744  1.00 72.27           C  
ATOM   1317  CD  LYS A 175     -10.283  -6.982  29.274  1.00 76.54           C  
ATOM   1318  CE  LYS A 175      -9.942  -6.460  27.850  1.00 83.18           C  
ATOM   1319  NZ  LYS A 175     -10.588  -5.151  27.462  1.00 84.09           N  
ATOM   1320  N   ILE A 176      -7.488  -9.683  33.818  1.00 63.93           N  
ATOM   1321  CA  ILE A 176      -7.482 -10.191  35.174  1.00 61.35           C  
ATOM   1322  C   ILE A 176      -8.213  -9.201  36.066  1.00 59.74           C  
ATOM   1323  O   ILE A 176      -8.003  -8.007  36.008  1.00 60.36           O  
ATOM   1324  CB  ILE A 176      -6.019 -10.476  35.671  1.00 70.00           C  
ATOM   1325  CG1 ILE A 176      -5.623 -11.919  35.304  1.00 85.22           C  
ATOM   1326  CG2 ILE A 176      -5.875 -10.329  37.202  1.00 72.45           C  
ATOM   1327  CD1 ILE A 176      -4.993 -12.063  33.963  1.00 90.61           C  
ATOM   1328  N   ASN A 177      -9.108  -9.721  36.879  1.00 61.58           N  
ATOM   1329  CA  ASN A 177      -9.799  -8.935  37.872  1.00 58.64           C  
ATOM   1330  C   ASN A 177      -8.855  -8.644  39.035  1.00 60.68           C  
ATOM   1331  O   ASN A 177      -8.560  -9.522  39.857  1.00 60.94           O  
ATOM   1332  CB  ASN A 177     -11.018  -9.696  38.353  1.00 59.74           C  
ATOM   1333  CG  ASN A 177     -11.844  -8.894  39.339  1.00 63.73           C  
ATOM   1334  OD1 ASN A 177     -11.510  -7.778  39.670  1.00 55.33           O  
ATOM   1335  ND2 ASN A 177     -12.925  -9.475  39.811  1.00 59.02           N  
ATOM   1336  N   ALA A 178      -8.340  -7.415  39.072  1.00 60.23           N  
ATOM   1337  CA  ALA A 178      -7.373  -7.037  40.081  1.00 56.85           C  
ATOM   1338  C   ALA A 178      -8.072  -6.393  41.274  1.00 58.66           C  
ATOM   1339  O   ALA A 178      -7.435  -5.750  42.094  1.00 61.35           O  
ATOM   1340  CB  ALA A 178      -6.329  -6.116  39.493  1.00 53.83           C  
ATOM   1341  N   GLU A 179      -9.382  -6.559  41.379  1.00 59.95           N  
ATOM   1342  CA  GLU A 179     -10.127  -6.082  42.544  1.00 62.16           C  
ATOM   1343  C   GLU A 179     -10.008  -7.050  43.730  1.00 59.78           C  
ATOM   1344  O   GLU A 179     -10.340  -6.683  44.858  1.00 59.83           O  
ATOM   1345  CB  GLU A 179     -11.616  -5.937  42.209  1.00 68.96           C  
ATOM   1346  CG  GLU A 179     -11.910  -4.986  41.067  1.00 73.64           C  
ATOM   1347  CD  GLU A 179     -12.431  -3.655  41.516  1.00 73.18           C  
ATOM   1348  OE1 GLU A 179     -12.385  -3.364  42.730  1.00 78.58           O  
ATOM   1349  OE2 GLU A 179     -12.885  -2.899  40.640  1.00 78.63           O  
ATOM   1350  N   GLY A 180      -9.553  -8.277  43.460  1.00 61.23           N  
ATOM   1351  CA  GLY A 180      -9.462  -9.344  44.471  1.00 56.51           C  
ATOM   1352  C   GLY A 180      -8.240  -9.167  45.359  1.00 59.72           C  
ATOM   1353  O   GLY A 180      -7.494  -8.161  45.263  1.00 56.79           O  
ATOM   1354  N   THR A 181      -8.032 -10.138  46.229  1.00 54.40           N  
ATOM   1355  CA  THR A 181      -6.859 -10.131  47.088  1.00 57.46           C  
ATOM   1356  C   THR A 181      -5.630 -10.269  46.208  1.00 57.52           C  
ATOM   1357  O   THR A 181      -5.725 -10.818  45.114  1.00 58.04           O  
ATOM   1358  CB  THR A 181      -6.853 -11.332  48.004  1.00 59.72           C  
ATOM   1359  OG1 THR A 181      -6.831 -12.514  47.201  1.00 60.11           O  
ATOM   1360  CG2 THR A 181      -8.101 -11.342  48.901  1.00 58.81           C  
ATOM   1361  N   PRO A 182      -4.465  -9.802  46.683  1.00 57.12           N  
ATOM   1362  CA  PRO A 182      -3.273 -10.006  45.863  1.00 60.22           C  
ATOM   1363  C   PRO A 182      -2.981 -11.476  45.573  1.00 59.28           C  
ATOM   1364  O   PRO A 182      -2.448 -11.800  44.511  1.00 62.90           O  
ATOM   1365  CB  PRO A 182      -2.140  -9.352  46.690  1.00 61.11           C  
ATOM   1366  CG  PRO A 182      -2.812  -8.491  47.672  1.00 63.96           C  
ATOM   1367  CD  PRO A 182      -4.169  -9.077  47.930  1.00 59.73           C  
ATOM   1368  N   GLU A 183      -3.334 -12.351  46.497  1.00 59.85           N  
ATOM   1369  CA  GLU A 183      -3.066 -13.781  46.325  1.00 63.50           C  
ATOM   1370  C   GLU A 183      -4.003 -14.398  45.281  1.00 61.82           C  
ATOM   1371  O   GLU A 183      -3.556 -15.244  44.499  1.00 59.02           O  
ATOM   1372  CB  GLU A 183      -3.062 -14.551  47.665  1.00 60.13           C  
ATOM   1373  CG  GLU A 183      -3.875 -13.954  48.806  1.00 80.40           C  
ATOM   1374  CD  GLU A 183      -3.210 -12.755  49.504  1.00 80.48           C  
ATOM   1375  OE1 GLU A 183      -3.925 -11.782  49.799  1.00 88.64           O  
ATOM   1376  OE2 GLU A 183      -1.995 -12.779  49.766  1.00 82.35           O  
ATOM   1377  N   ASP A 184      -5.267 -13.949  45.230  1.00 56.49           N  
ATOM   1378  CA  ASP A 184      -6.163 -14.338  44.133  1.00 58.81           C  
ATOM   1379  C   ASP A 184      -5.756 -13.779  42.776  1.00 57.93           C  
ATOM   1380  O   ASP A 184      -5.924 -14.437  41.758  1.00 56.63           O  
ATOM   1381  CB  ASP A 184      -7.600 -13.897  44.347  1.00 59.48           C  
ATOM   1382  CG  ASP A 184      -8.521 -14.377  43.210  1.00 72.53           C  
ATOM   1383  OD1 ASP A 184      -8.816 -15.603  43.108  1.00 69.85           O  
ATOM   1384  OD2 ASP A 184      -8.928 -13.533  42.392  1.00 75.67           O  
ATOM   1385  N   VAL A 185      -5.280 -12.545  42.760  1.00 57.44           N  
ATOM   1386  CA  VAL A 185      -4.782 -11.951  41.531  1.00 57.09           C  
ATOM   1387  C   VAL A 185      -3.585 -12.775  41.024  1.00 55.76           C  
ATOM   1388  O   VAL A 185      -3.503 -13.080  39.842  1.00 58.23           O  
ATOM   1389  CB  VAL A 185      -4.420 -10.478  41.750  1.00 58.56           C  
ATOM   1390  CG1 VAL A 185      -3.703  -9.889  40.543  1.00 54.02           C  
ATOM   1391  CG2 VAL A 185      -5.684  -9.689  42.064  1.00 54.97           C  
ATOM   1392  N   PHE A 186      -2.677 -13.158  41.919  1.00 55.82           N  
ATOM   1393  CA  PHE A 186      -1.529 -13.993  41.531  1.00 52.58           C  
ATOM   1394  C   PHE A 186      -1.976 -15.310  40.925  1.00 53.45           C  
ATOM   1395  O   PHE A 186      -1.444 -15.749  39.925  1.00 58.36           O  
ATOM   1396  CB  PHE A 186      -0.595 -14.274  42.732  1.00 58.02           C  
ATOM   1397  CG  PHE A 186       0.765 -14.835  42.328  1.00 52.15           C  
ATOM   1398  CD1 PHE A 186       1.560 -14.156  41.398  1.00 58.91           C  
ATOM   1399  CD2 PHE A 186       1.244 -16.014  42.868  1.00 58.19           C  
ATOM   1400  CE1 PHE A 186       2.792 -14.663  41.017  1.00 58.58           C  
ATOM   1401  CE2 PHE A 186       2.492 -16.507  42.492  1.00 52.58           C  
ATOM   1402  CZ  PHE A 186       3.247 -15.839  41.563  1.00 57.32           C  
ATOM   1403  N   LEU A 187      -2.963 -15.937  41.548  1.00 55.45           N  
ATOM   1404  CA  LEU A 187      -3.506 -17.203  41.096  1.00 56.43           C  
ATOM   1405  C   LEU A 187      -3.987 -17.101  39.645  1.00 58.16           C  
ATOM   1406  O   LEU A 187      -3.660 -17.964  38.823  1.00 58.54           O  
ATOM   1407  CB  LEU A 187      -4.631 -17.645  42.059  1.00 53.94           C  
ATOM   1408  CG  LEU A 187      -5.456 -18.916  41.841  1.00 61.24           C  
ATOM   1409  CD1 LEU A 187      -6.242 -19.250  43.107  1.00 55.59           C  
ATOM   1410  CD2 LEU A 187      -6.415 -18.789  40.686  1.00 58.95           C  
ATOM   1411  N   GLN A 188      -4.768 -16.059  39.352  1.00 61.76           N  
ATOM   1412  CA  GLN A 188      -5.306 -15.789  38.002  1.00 61.62           C  
ATOM   1413  C   GLN A 188      -4.214 -15.467  36.975  1.00 59.44           C  
ATOM   1414  O   GLN A 188      -4.304 -15.830  35.820  1.00 56.97           O  
ATOM   1415  CB  GLN A 188      -6.236 -14.588  38.042  1.00 61.20           C  
ATOM   1416  CG  GLN A 188      -7.571 -14.702  38.797  1.00 61.70           C  
ATOM   1417  CD  GLN A 188      -8.290 -13.332  38.778  1.00 71.75           C  
ATOM   1418  OE1 GLN A 188      -8.825 -12.905  37.738  1.00 76.90           O  
ATOM   1419  NE2 GLN A 188      -8.242 -12.616  39.903  1.00 70.08           N  
ATOM   1420  N   LEU A 189      -3.210 -14.722  37.397  1.00 55.89           N  
ATOM   1421  CA  LEU A 189      -2.075 -14.436  36.542  1.00 61.15           C  
ATOM   1422  C   LEU A 189      -1.355 -15.713  36.108  1.00 59.58           C  
ATOM   1423  O   LEU A 189      -1.050 -15.883  34.923  1.00 58.76           O  
ATOM   1424  CB  LEU A 189      -1.102 -13.490  37.240  1.00 62.05           C  
ATOM   1425  CG  LEU A 189      -1.511 -12.016  37.330  1.00 59.52           C  
ATOM   1426  CD1 LEU A 189      -0.626 -11.257  38.280  1.00 58.37           C  
ATOM   1427  CD2 LEU A 189      -1.441 -11.356  35.989  1.00 63.35           C  
ATOM   1428  N   CYS A 190      -1.093 -16.596  37.080  1.00 59.62           N  
ATOM   1429  CA  CYS A 190      -0.422 -17.863  36.837  1.00 57.12           C  
ATOM   1430  C   CYS A 190      -1.248 -18.794  35.960  1.00 56.27           C  
ATOM   1431  O   CYS A 190      -0.722 -19.489  35.100  1.00 58.37           O  
ATOM   1432  CB  CYS A 190      -0.091 -18.549  38.161  1.00 56.52           C  
ATOM   1433  SG  CYS A 190       1.167 -17.674  39.104  1.00 55.64           S  
ATOM   1434  N   THR A 191      -2.547 -18.810  36.182  1.00 54.29           N  
ATOM   1435  CA  THR A 191      -3.460 -19.511  35.289  1.00 59.32           C  
ATOM   1436  C   THR A 191      -3.353 -19.034  33.822  1.00 57.60           C  
ATOM   1437  O   THR A 191      -3.241 -19.840  32.906  1.00 62.69           O  
ATOM   1438  CB  THR A 191      -4.897 -19.354  35.791  1.00 59.92           C  
ATOM   1439  OG1 THR A 191      -4.984 -19.911  37.111  1.00 56.65           O  
ATOM   1440  CG2 THR A 191      -5.878 -20.078  34.868  1.00 59.40           C  
ATOM   1441  N   ALA A 192      -3.370 -17.727  33.625  1.00 57.64           N  
ATOM   1442  CA  ALA A 192      -3.257 -17.121  32.303  1.00 58.38           C  
ATOM   1443  C   ALA A 192      -1.964 -17.532  31.621  1.00 58.07           C  
ATOM   1444  O   ALA A 192      -1.970 -17.996  30.488  1.00 61.27           O  
ATOM   1445  CB  ALA A 192      -3.305 -15.614  32.427  1.00 58.06           C  
ATOM   1446  N   ILE A 193      -0.861 -17.357  32.334  1.00 57.37           N  
ATOM   1447  CA  ILE A 193       0.475 -17.646  31.807  1.00 57.04           C  
ATOM   1448  C   ILE A 193       0.693 -19.130  31.480  1.00 60.14           C  
ATOM   1449  O   ILE A 193       1.265 -19.448  30.422  1.00 59.30           O  
ATOM   1450  CB  ILE A 193       1.540 -17.166  32.792  1.00 54.36           C  
ATOM   1451  CG1 ILE A 193       1.564 -15.623  32.815  1.00 61.84           C  
ATOM   1452  CG2 ILE A 193       2.915 -17.734  32.443  1.00 50.19           C  
ATOM   1453  CD1 ILE A 193       2.316 -15.052  33.999  1.00 64.74           C  
ATOM   1454  N   ASP A 194       0.245 -20.012  32.386  1.00 58.12           N  
ATOM   1455  CA  ASP A 194       0.310 -21.457  32.193  1.00 55.51           C  
ATOM   1456  C   ASP A 194      -0.530 -21.888  31.001  1.00 57.12           C  
ATOM   1457  O   ASP A 194      -0.189 -22.850  30.328  1.00 59.68           O  
ATOM   1458  CB  ASP A 194      -0.174 -22.232  33.449  1.00 50.73           C  
ATOM   1459  CG  ASP A 194       0.738 -22.030  34.687  1.00 55.32           C  
ATOM   1460  OD1 ASP A 194       1.795 -21.391  34.545  1.00 59.10           O  
ATOM   1461  OD2 ASP A 194       0.378 -22.478  35.816  1.00 57.58           O  
ATOM   1462  N   SER A 195      -1.637 -21.202  30.749  1.00 54.37           N  
ATOM   1463  CA  SER A 195      -2.501 -21.573  29.631  1.00 60.93           C  
ATOM   1464  C   SER A 195      -1.846 -21.265  28.294  1.00 59.47           C  
ATOM   1465  O   SER A 195      -2.162 -21.891  27.298  1.00 61.15           O  
ATOM   1466  CB  SER A 195      -3.878 -20.868  29.716  1.00 60.15           C  
ATOM   1467  OG  SER A 195      -3.760 -19.471  29.393  1.00 70.65           O  
ATOM   1468  N   ILE A 196      -0.950 -20.280  28.267  1.00 61.40           N  
ATOM   1469  CA  ILE A 196      -0.286 -19.881  27.041  1.00 62.10           C  
ATOM   1470  C   ILE A 196       0.983 -20.686  26.802  1.00 59.87           C  
ATOM   1471  O   ILE A 196       1.240 -21.139  25.691  1.00 57.75           O  
ATOM   1472  CB  ILE A 196       0.070 -18.347  27.048  1.00 66.03           C  
ATOM   1473  CG1 ILE A 196      -1.202 -17.485  27.092  1.00 67.31           C  
ATOM   1474  CG2 ILE A 196       0.933 -17.973  25.833  1.00 66.55           C  
ATOM   1475  CD1 ILE A 196      -2.151 -17.693  25.957  1.00 65.42           C  
ATOM   1476  N   PHE A 197       1.795 -20.858  27.831  1.00 59.15           N  
ATOM   1477  CA  PHE A 197       3.102 -21.492  27.629  1.00 59.84           C  
ATOM   1478  C   PHE A 197       2.983 -22.968  27.852  1.00 60.86           C  
ATOM   1479  O   PHE A 197       3.549 -23.508  28.766  1.00 59.41           O  
ATOM   1480  CB  PHE A 197       4.184 -20.743  28.398  1.00 58.52           C  
ATOM   1481  CG  PHE A 197       4.332 -19.342  27.886  1.00 54.53           C  
ATOM   1482  CD1 PHE A 197       4.854 -19.120  26.612  1.00 54.25           C  
ATOM   1483  CD2 PHE A 197       3.772 -18.268  28.573  1.00 54.87           C  
ATOM   1484  CE1 PHE A 197       4.932 -17.838  26.089  1.00 54.77           C  
ATOM   1485  CE2 PHE A 197       3.837 -16.977  28.048  1.00 58.22           C  
ATOM   1486  CZ  PHE A 197       4.433 -16.763  26.811  1.00 49.52           C  
ATOM   1487  N   LEU A 198       2.214 -23.534  26.905  1.00 74.78           N  
ATOM   1488  CA  LEU A 198       1.700 -24.907  26.739  1.00 78.97           C  
ATOM   1489  C   LEU A 198       0.223 -25.086  27.075  1.00 83.26           C  
ATOM   1490  O   LEU A 198      -0.559 -25.350  26.167  1.00 79.11           O  
ATOM   1491  CB  LEU A 198       2.513 -25.943  27.453  1.00 81.01           C  
ATOM   1492  CG  LEU A 198       3.935 -26.083  26.941  1.00 92.49           C  
ATOM   1493  CD1 LEU A 198       4.308 -27.489  27.291  1.00104.80           C  
ATOM   1494  CD2 LEU A 198       4.146 -25.776  25.429  1.00 87.43           C  
ATOM   1495  OXT LEU A 198      -0.230 -24.985  28.217  1.00 91.74           O  
TER    1496      LEU A 198                                                      
END
MOLECULE T0416_6_115_194_315.pdb
ATOM      1  N   LYS     6       9.770 -16.706  17.344  1.00 47.34          
ATOM      2  CA  LYS     6       9.686 -15.469  18.171  1.00 47.92          
ATOM      3  C   LYS     6       9.964 -15.789  19.633  1.00 48.21          
ATOM      4  O   LYS     6       9.492 -16.801  20.167  1.00 48.06          
ATOM      5  CB  LYS     6       8.296 -14.851  18.062  1.00 48.33          
ATOM      6  CG  LYS     6       7.859 -14.572  16.663  1.00 51.47          
ATOM      7  CD  LYS     6       6.355 -14.397  16.582  1.00 55.16          
ATOM      8  CE  LYS     6       5.919 -14.283  15.119  1.00 58.23          
ATOM      9  NZ  LYS     6       4.444 -14.137  14.929  1.00 59.84          
ATOM     10  N   PRO     7      10.743 -14.930  20.304  1.00 47.62          
ATOM     11  CA  PRO     7      11.079 -15.125  21.721  1.00 47.47          
ATOM     12  C   PRO     7       9.897 -14.902  22.682  1.00 46.63          
ATOM     13  O   PRO     7       9.082 -13.993  22.493  1.00 46.51          
ATOM     14  CB  PRO     7      12.203 -14.114  21.955  1.00 48.11          
ATOM     15  CG  PRO     7      11.877 -13.021  20.986  1.00 48.00          
ATOM     16  CD  PRO     7      11.471 -13.782  19.741  1.00 46.88          
ATOM     17  N   PHE     8       9.814 -15.737  23.715  1.00 44.40          
ATOM     18  CA  PHE     8       8.747 -15.622  24.697  1.00 41.95          
ATOM     19  C   PHE     8       8.958 -14.388  25.566  1.00 40.54          
ATOM     20  O   PHE     8      10.068 -14.136  26.041  1.00 40.58          
ATOM     21  CB  PHE     8       8.694 -16.865  25.591  1.00 41.58          
ATOM     22  CG  PHE     8       7.522 -16.884  26.531  1.00 41.07          
ATOM     23  CD1 PHE     8       6.222 -16.919  26.036  1.00 42.79          
ATOM     24  CD2 PHE     8       7.707 -16.854  27.901  1.00 39.99          
ATOM     25  CE1 PHE     8       5.122 -16.927  26.895  1.00 42.19          
ATOM     26  CE2 PHE     8       6.611 -16.863  28.767  1.00 41.03          
ATOM     27  CZ  PHE     8       5.315 -16.899  28.253  1.00 40.90          
ATOM     28  N   LEU     9       7.881 -13.631  25.767  1.00 38.04          
ATOM     29  CA  LEU     9       7.915 -12.418  26.583  1.00 36.38          
ATOM     30  C   LEU     9       6.629 -12.238  27.393  1.00 35.98          
ATOM     31  O   LEU     9       5.542 -12.412  26.847  1.00 37.94          
ATOM     32  CB  LEU     9       8.085 -11.198  25.687  1.00 33.92          
ATOM     33  CG  LEU     9       8.128  -9.872  26.431  1.00 31.31          
ATOM     34  CD1 LEU     9       9.465  -9.700  27.105  1.00 30.33          
ATOM     35  CD2 LEU     9       7.901  -8.759  25.453  1.00 32.13          
ATOM     36  N   ILE    10       6.742 -11.899  28.680  1.00 34.13          
ATOM     37  CA  ILE    10       5.554 -11.660  29.516  1.00 33.61          
ATOM     38  C   ILE    10       5.402 -10.159  29.661  1.00 32.88          
ATOM     39  O   ILE    10       6.389  -9.457  29.867  1.00 32.89          
ATOM     40  CB  ILE    10       5.671 -12.221  30.978  1.00 34.19          
ATOM     41  CG1 ILE    10       5.795 -13.745  30.994  1.00 34.92          
ATOM     42  CG2 ILE    10       4.410 -11.875  31.762  1.00 32.53          
ATOM     43  CD  ILE    10       4.537 -14.446  30.557  1.00 35.17          
ATOM     44  N   VAL    11       4.179  -9.656  29.545  1.00 32.25          
ATOM     45  CA  VAL    11       3.953  -8.211  29.699  1.00 33.18          
ATOM     46  C   VAL    11       2.799  -7.993  30.705  1.00 33.37          
ATOM     47  O   VAL    11       1.670  -8.456  30.494  1.00 33.93          
ATOM     48  CB  VAL    11       3.605  -7.524  28.325  1.00 31.73          
ATOM     49  CG1 VAL    11       3.619  -6.017  28.467  1.00 30.56          
ATOM     50  CG2 VAL    11       4.587  -7.943  27.263  1.00 29.73          
ATOM     51  N   ILE    12       3.091  -7.290  31.797  1.00 31.84          
ATOM     52  CA  ILE    12       2.106  -7.032  32.842  1.00 30.80          
ATOM     53  C   ILE    12       1.866  -5.536  33.017  1.00 31.11          
ATOM     54  O   ILE    12       2.624  -4.849  33.708  1.00 30.46          
ATOM     55  CB  ILE    12       2.569  -7.632  34.189  1.00 29.53          
ATOM     56  CG1 ILE    12       2.895  -9.114  33.996  1.00 29.86          
ATOM     57  CG2 ILE    12       1.478  -7.487  35.230  1.00 30.33          
ATOM     58  CD  ILE    12       3.522  -9.776  35.203  1.00 26.96          
ATOM     59  N   VAL    13       0.808  -5.035  32.383  1.00 30.72          
ATOM     60  CA  VAL    13       0.466  -3.620  32.457  1.00 29.94          
ATOM     61  C   VAL    13      -0.652  -3.426  33.452  1.00 29.66          
ATOM     62  O   VAL    13      -1.336  -4.374  33.801  1.00 30.84          
ATOM     63  CB  VAL    13      -0.002  -3.077  31.090  1.00 29.53          
ATOM     64  CG1 VAL    13       1.132  -3.140  30.075  1.00 29.05          
ATOM     65  CG2 VAL    13      -1.188  -3.876  30.601  1.00 28.45          
ATOM     66  N   GLY    14      -0.839  -2.199  33.909  1.00 30.29          
ATOM     67  CA  GLY    14      -1.889  -1.938  34.871  1.00 31.58          
ATOM     68  C   GLY    14      -1.642  -0.598  35.525  1.00 32.22          
ATOM     69  O   GLY    14      -0.521  -0.108  35.523  1.00 31.01          
ATOM     70  N   PRO    15      -2.677   0.021  36.103  1.00 33.98          
ATOM     71  CA  PRO    15      -2.483   1.323  36.744  1.00 35.35          
ATOM     72  C   PRO    15      -1.478   1.279  37.893  1.00 36.07          
ATOM     73  O   PRO    15      -1.230   0.218  38.457  1.00 36.01          
ATOM     74  CB  PRO    15      -3.897   1.696  37.187  1.00 34.89          
ATOM     75  CG  PRO    15      -4.545   0.365  37.419  1.00 34.89          
ATOM     76  CD  PRO    15      -4.070  -0.442  36.245  1.00 35.07          
ATOM     77  N   THR    16      -0.891   2.431  38.211  1.00 36.66          
ATOM     78  CA  THR    16       0.089   2.538  39.286  1.00 38.58          
ATOM     79  C   THR    16      -0.373   1.853  40.573  1.00 40.27          
ATOM     80  O   THR    16      -1.523   2.001  40.989  1.00 40.98          
ATOM     81  CB  THR    16       0.385   3.997  39.643  1.00 37.33          
ATOM     82  OG1 THR    16       0.786   4.705  38.474  1.00 36.77          
ATOM     83  CG2 THR    16       1.495   4.061  40.671  1.00 38.23          
ATOM     84  N   ALA    17       0.536   1.118  41.208  1.00 40.72          
ATOM     85  CA  ALA    17       0.219   0.417  42.443  1.00 42.57          
ATOM     86  C   ALA    17      -1.083  -0.378  42.324  1.00 43.15          
ATOM     87  O   ALA    17      -2.011  -0.205  43.123  1.00 43.42          
ATOM     88  CB  ALA    17       0.109   1.412  43.597  1.00 43.65          
ATOM     89  N   SER    18      -1.159  -1.238  41.317  1.00 42.43          
ATOM     90  CA  SER    18      -2.344  -2.051  41.119  1.00 40.61          
ATOM     91  C   SER    18      -1.921  -3.495  41.298  1.00 40.77          
ATOM     92  O   SER    18      -2.693  -4.424  41.054  1.00 42.04          
ATOM     93  CB  SER    18      -2.892  -1.870  39.719  1.00 38.47          
ATOM     94  OG  SER    18      -2.013  -2.466  38.804  1.00 36.84          
ATOM     95  N   GLY    19      -0.681  -3.681  41.730  1.00 40.01          
ATOM     96  CA  GLY    19      -0.170  -5.026  41.920  1.00 40.03          
ATOM     97  C   GLY    19       0.645  -5.548  40.744  1.00 38.18          
ATOM     98  O   GLY    19       1.235  -6.625  40.806  1.00 38.21          
ATOM     99  N   LYS    20       0.684  -4.791  39.660  1.00 36.98          
ATOM    100  CA  LYS    20       1.444  -5.241  38.522  1.00 35.89          
ATOM    101  C   LYS    20       2.908  -5.443  38.936  1.00 36.34          
ATOM    102  O   LYS    20       3.527  -6.452  38.590  1.00 37.13          
ATOM    103  CB  LYS    20       1.330  -4.248  37.362  1.00 33.94          
ATOM    104  CG  LYS    20       1.849  -2.871  37.685  1.00 32.57          
ATOM    105  CD  LYS    20       1.824  -1.935  36.498  1.00 29.33          
ATOM    106  CE  LYS    20       2.436  -0.614  36.924  1.00 31.07          
ATOM    107  NZ  LYS    20       2.250   0.476  35.923  1.00 35.59          
ATOM    108  N   THR    21       3.455  -4.511  39.705  1.00 35.70          
ATOM    109  CA  THR    21       4.840  -4.619  40.147  1.00 35.75          
ATOM    110  C   THR    21       5.079  -5.838  41.024  1.00 35.78          
ATOM    111  O   THR    21       6.054  -6.572  40.832  1.00 35.67          
ATOM    112  CB  THR    21       5.269  -3.372  40.918  1.00 36.24          
ATOM    113  OG1 THR    21       5.065  -2.221  40.090  1.00 38.69          
ATOM    114  CG2 THR    21       6.742  -3.464  41.302  1.00 36.35          
ATOM    115  N   GLU    22       4.197  -6.056  41.989  1.00 35.56          
ATOM    116  CA  GLU    22       4.326  -7.196  42.879  1.00 36.42          
ATOM    117  C   GLU    22       4.155  -8.475  42.073  1.00 35.88          
ATOM    118  O   GLU    22       4.979  -9.381  42.161  1.00 37.29          
ATOM    119  CB  GLU    22       3.271  -7.119  43.984  1.00 39.34          
ATOM    120  CG  GLU    22       3.439  -5.935  44.935  1.00 43.60          
ATOM    121  CD  GLU    22       3.007  -4.586  44.343  1.00 45.57          
ATOM    122  OE1 GLU    22       3.218  -3.557  45.018  1.00 48.08          
ATOM    123  OE2 GLU    22       2.457  -4.544  43.224  1.00 46.06          
ATOM    124  N   LEU    23       3.090  -8.539  41.276  1.00 34.58          
ATOM    125  CA  LEU    23       2.826  -9.704  40.445  1.00 32.10          
ATOM    126  C   LEU    23       4.039 -10.051  39.576  1.00 31.09          
ATOM    127  O   LEU    23       4.403 -11.217  39.458  1.00 27.98          
ATOM    128  CB  LEU    23       1.599  -9.455  39.558  1.00 30.74          
ATOM    129  CG  LEU    23       1.222 -10.580  38.579  1.00 28.65          
ATOM    130  CD1 LEU    23       0.822 -11.814  39.341  1.00 28.78          
ATOM    131  CD2 LEU    23       0.098 -10.121  37.709  1.00 27.36          
ATOM    132  N   SER    24       4.663  -9.040  38.973  1.00 32.29          
ATOM    133  CA  SER    24       5.842  -9.271  38.129  1.00 34.51          
ATOM    134  C   SER    24       6.915 -10.040  38.890  1.00 34.30          
ATOM    135  O   SER    24       7.439 -11.030  38.403  1.00 35.07          
ATOM    136  CB  SER    24       6.445  -7.954  37.634  1.00 35.30          
ATOM    137  OG  SER    24       5.598  -7.333  36.691  1.00 39.93          
ATOM    138  N   ILE    25       7.237  -9.584  40.089  1.00 33.62          
ATOM    139  CA  ILE    25       8.251 -10.244  40.876  1.00 33.95          
ATOM    140  C   ILE    25       7.850 -11.690  41.196  1.00 35.37          
ATOM    141  O   ILE    25       8.677 -12.608  41.097  1.00 35.34          
ATOM    142  CB  ILE    25       8.529  -9.434  42.163  1.00 32.96          
ATOM    143  CG1 ILE    25       9.066  -8.055  41.768  1.00 30.36          
ATOM    144  CG2 ILE    25       9.512 -10.154  43.053  1.00 31.35          
ATOM    145  CD  ILE    25       9.495  -7.203  42.916  1.00 28.44          
ATOM    146  N   GLU    26       6.586 -11.909  41.554  1.00 36.42          
ATOM    147  CA  GLU    26       6.106 -13.262  41.869  1.00 38.00          
ATOM    148  C   GLU    26       6.267 -14.202  40.671  1.00 37.34          
ATOM    149  O   GLU    26       6.623 -15.369  40.836  1.00 37.59          
ATOM    150  CB  GLU    26       4.635 -13.220  42.317  1.00 39.45          
ATOM    151  CG  GLU    26       4.434 -12.560  43.690  1.00 44.45          
ATOM    152  CD  GLU    26       5.131 -13.307  44.839  1.00 47.76          
ATOM    153  OE1 GLU    26       4.635 -14.390  45.253  1.00 48.13          
ATOM    154  OE2 GLU    26       6.188 -12.815  45.322  1.00 48.16          
ATOM    155  N   VAL    27       6.001 -13.683  39.473  1.00 36.34          
ATOM    156  CA  VAL    27       6.141 -14.460  38.248  1.00 34.75          
ATOM    157  C   VAL    27       7.627 -14.683  37.994  1.00 35.06          
ATOM    158  O   VAL    27       8.044 -15.752  37.567  1.00 34.96          
ATOM    159  CB  VAL    27       5.549 -13.714  37.055  1.00 31.86          
ATOM    160  CG1 VAL    27       5.834 -14.462  35.783  1.00 29.36          
ATOM    161  CG2 VAL    27       4.072 -13.543  37.255  1.00 31.53          
ATOM    162  N   ALA    28       8.419 -13.657  38.275  1.00 35.66          
ATOM    163  CA  ALA    28       9.849 -13.720  38.085  1.00 36.34          
ATOM    164  C   ALA    28      10.465 -14.753  39.009  1.00 38.34          
ATOM    165  O   ALA    28      11.452 -15.406  38.660  1.00 39.44          
ATOM    166  CB  ALA    28      10.464 -12.368  38.340  1.00 36.23          
ATOM    167  N   LYS    29       9.889 -14.910  40.194  1.00 39.77          
ATOM    168  CA  LYS    29      10.408 -15.880  41.146  1.00 40.39          
ATOM    169  C   LYS    29       9.949 -17.299  40.859  1.00 40.52          
ATOM    170  O   LYS    29      10.622 -18.239  41.252  1.00 41.59          
ATOM    171  CB  LYS    29      10.006 -15.511  42.574  1.00 40.53          
ATOM    172  CG  LYS    29      10.744 -14.316  43.150  1.00 41.23          
ATOM    173  CD  LYS    29      10.663 -14.309  44.681  1.00 44.42          
ATOM    174  CE  LYS    29       9.211 -14.279  45.195  1.00 44.59          
ATOM    175  NZ  LYS    29       9.113 -14.333  46.690  1.00 43.59          
ATOM    176  N   LYS    30       8.816 -17.465  40.186  1.00 40.21          
ATOM    177  CA  LYS    30       8.337 -18.806  39.901  1.00 41.59          
ATOM    178  C   LYS    30       8.884 -19.327  38.571  1.00 43.51          
ATOM    179  O   LYS    30       8.861 -20.529  38.327  1.00 43.62          
ATOM    180  CB  LYS    30       6.801 -18.834  39.902  1.00 42.72          
ATOM    181  CG  LYS    30       6.171 -20.223  39.924  1.00 43.38          
ATOM    182  CD  LYS    30       4.653 -20.122  39.904  1.00 45.84          
ATOM    183  CE  LYS    30       3.983 -21.471  40.139  1.00 47.92          
ATOM    184  NZ  LYS    30       2.499 -21.323  40.293  1.00 50.92          
ATOM    185  N   PHE    31       9.388 -18.430  37.721  1.00 44.17          
ATOM    186  CA  PHE    31       9.940 -18.814  36.419  1.00 44.51          
ATOM    187  C   PHE    31      11.289 -18.170  36.195  1.00 45.33          
ATOM    188  O   PHE    31      11.634 -17.818  35.068  1.00 45.02          
ATOM    189  CB  PHE    31       8.991 -18.398  35.307  1.00 44.39          
ATOM    190  CG  PHE    31       7.643 -19.013  35.427  1.00 45.82          
ATOM    191  CD1 PHE    31       7.406 -20.293  34.943  1.00 47.34          
ATOM    192  CD2 PHE    31       6.620 -18.344  36.087  1.00 46.46          
ATOM    193  CE1 PHE    31       6.160 -20.904  35.118  1.00 48.67          
ATOM    194  CE2 PHE    31       5.371 -18.940  36.271  1.00 47.96          
ATOM    195  CZ  PHE    31       5.137 -20.224  35.787  1.00 48.48          
ATOM    196  N   ASN    32      12.050 -18.044  37.282  1.00 47.84          
ATOM    197  CA  ASN    32      13.382 -17.419  37.295  1.00 49.84          
ATOM    198  C   ASN    32      13.603 -16.505  36.095  1.00 49.50          
ATOM    199  O   ASN    32      14.394 -16.794  35.191  1.00 50.98          
ATOM    200  CB  ASN    32      14.500 -18.479  37.383  1.00 51.79          
ATOM    201  CG  ASN    32      14.698 -19.234  36.078  1.00 54.42          
ATOM    202  OD1 ASN    32      13.726 -19.668  35.450  1.00 56.40          
ATOM    203  ND2 ASN    32      15.954 -19.411  35.670  1.00 55.03          
ATOM    204  N   GLY    33      12.871 -15.398  36.096  1.00 47.07          
ATOM    205  CA  GLY    33      12.994 -14.433  35.027  1.00 44.42          
ATOM    206  C   GLY    33      13.567 -13.138  35.566  1.00 42.58          
ATOM    207  O   GLY    33      13.970 -13.059  36.725  1.00 41.73          
ATOM    208  N   GLU    34      13.620 -12.124  34.711  1.00 41.54          
ATOM    209  CA  GLU    34      14.122 -10.821  35.099  1.00 39.53          
ATOM    210  C   GLU    34      13.166  -9.801  34.512  1.00 38.04          
ATOM    211  O   GLU    34      12.592 -10.005  33.440  1.00 36.36          
ATOM    212  CB  GLU    34      15.537 -10.613  34.582  1.00 39.38          
ATOM    213  CG  GLU    34      16.453 -11.766  34.939  1.00 40.36          
ATOM    214  CD  GLU    34      17.877 -11.540  34.490  1.00 41.95          
ATOM    215  OE1 GLU    34      18.066 -10.907  33.422  1.00 43.40          
ATOM    216  OE2 GLU    34      18.814 -12.009  35.185  1.00 40.07          
ATOM    217  N   ILE    35      13.008  -8.695  35.222  1.00 37.64          
ATOM    218  CA  ILE    35      12.066  -7.665  34.828  1.00 37.78          
ATOM    219  C   ILE    35      12.679  -6.440  34.183  1.00 37.21          
ATOM    220  O   ILE    35      13.723  -5.963  34.602  1.00 37.93          
ATOM    221  CB  ILE    35      11.252  -7.203  36.064  1.00 37.03          
ATOM    222  CG1 ILE    35      10.621  -8.415  36.738  1.00 36.19          
ATOM    223  CG2 ILE    35      10.186  -6.211  35.656  1.00 37.14          
ATOM    224  CD  ILE    35       9.858  -8.090  37.952  1.00 35.95          
ATOM    225  N   ILE    36      12.003  -5.926  33.166  1.00 37.04          
ATOM    226  CA  ILE    36      12.438  -4.716  32.496  1.00 36.12          
ATOM    227  C   ILE    36      11.354  -3.669  32.787  1.00 37.69          
ATOM    228  O   ILE    36      10.207  -3.833  32.380  1.00 38.12          
ATOM    229  CB  ILE    36      12.548  -4.928  30.981  1.00 33.73          
ATOM    230  CG1 ILE    36      13.667  -5.921  30.678  1.00 31.77          
ATOM    231  CG2 ILE    36      12.795  -3.610  30.292  1.00 31.97          
ATOM    232  CD  ILE    36      13.730  -6.342  29.233  1.00 26.96          
ATOM    233  N   SER    37      11.709  -2.610  33.506  1.00 37.83          
ATOM    234  CA  SER    37      10.744  -1.571  33.829  1.00 37.74          
ATOM    235  C   SER    37      10.202  -0.918  32.553  1.00 37.95          
ATOM    236  O   SER    37      10.969  -0.487  31.692  1.00 37.35          
ATOM    237  CB  SER    37      11.403  -0.535  34.740  1.00 36.72          
ATOM    238  OG  SER    37      10.688   0.680  34.738  1.00 36.77          
ATOM    239  N   GLY    38       8.874  -0.871  32.426  1.00 38.61          
ATOM    240  CA  GLY    38       8.253  -0.268  31.252  1.00 39.20          
ATOM    241  C   GLY    38       7.872   1.183  31.485  1.00 41.13          
ATOM    242  O   GLY    38       7.455   1.899  30.565  1.00 39.58          
ATOM    243  N   ASP    39       8.020   1.615  32.734  1.00 42.10          
ATOM    244  CA  ASP    39       7.694   2.977  33.129  1.00 44.59          
ATOM    245  C   ASP    39       8.674   3.991  32.530  1.00 45.44          
ATOM    246  O   ASP    39       9.884   3.849  32.665  1.00 46.29          
ATOM    247  CB  ASP    39       7.719   3.090  34.648  1.00 46.64          
ATOM    248  CG  ASP    39       7.028   4.342  35.149  1.00 49.62          
ATOM    249  OD1 ASP    39       7.453   5.452  34.775  1.00 51.11          
ATOM    250  OD2 ASP    39       6.046   4.214  35.915  1.00 52.78          
ATOM    251  N   SER    40       8.149   5.028  31.890  1.00 45.73          
ATOM    252  CA  SER    40       9.007   6.038  31.286  1.00 46.96          
ATOM    253  C   SER    40       9.523   7.073  32.276  1.00 47.74          
ATOM    254  O   SER    40      10.194   8.033  31.886  1.00 47.33          
ATOM    255  CB  SER    40       8.276   6.763  30.142  1.00 46.76          
ATOM    256  OG  SER    40       7.151   7.504  30.591  1.00 44.02          
ATOM    257  N   MET    41       9.212   6.894  33.554  1.00 49.05          
ATOM    258  CA  MET    41       9.645   7.852  34.575  1.00 50.21          
ATOM    259  C   MET    41      10.623   7.277  35.575  1.00 48.79          
ATOM    260  O   MET    41      11.443   7.998  36.156  1.00 48.16          
ATOM    261  CB  MET    41       8.430   8.401  35.322  1.00 54.92          
ATOM    262  CG  MET    41       7.630   9.422  34.534  1.00 60.15          
ATOM    263  SD  MET    41       8.726  10.939  33.973  1.00 69.60          
ATOM    264  CE  MET    41       9.133  11.711  35.709  1.00 65.89          
ATOM    265  N   GLN    42      10.521   5.967  35.778  1.00 47.21          
ATOM    266  CA  GLN    42      11.387   5.258  36.710  1.00 44.79          
ATOM    267  C   GLN    42      12.805   5.173  36.162  1.00 43.38          
ATOM    268  O   GLN    42      13.702   4.659  36.822  1.00 42.91          
ATOM    269  CB  GLN    42      10.808   3.867  36.988  1.00 44.81          
ATOM    270  CG  GLN    42       9.722   3.895  38.074  1.00 45.40          
ATOM    271  CD  GLN    42       9.045   2.552  38.305  1.00 46.04          
ATOM    272  OE1 GLN    42       9.697   1.498  38.352  1.00 47.48          
ATOM    273  NE2 GLN    42       7.731   2.587  38.483  1.00 45.63          
ATOM    274  N   VAL    43      13.002   5.709  34.960  1.00 41.63          
ATOM    275  CA  VAL    43      14.308   5.709  34.338  1.00 39.69          
ATOM    276  C   VAL    43      15.179   6.815  34.916  1.00 39.24          
ATOM    277  O   VAL    43      16.398   6.742  34.848  1.00 39.12          
ATOM    278  CB  VAL    43      14.194   5.913  32.814  1.00 40.00          
ATOM    279  CG1 VAL    43      13.727   4.629  32.143  1.00 39.83          
ATOM    280  CG2 VAL    43      13.216   7.035  32.519  1.00 37.24          
ATOM    281  N   TYR    44      14.547   7.831  35.496  1.00 39.65          
ATOM    282  CA  TYR    44      15.278   8.961  36.069  1.00 40.32          
ATOM    283  C   TYR    44      15.685   8.755  37.538  1.00 42.44          
ATOM    284  O   TYR    44      14.876   8.359  38.372  1.00 42.07          
ATOM    285  CB  TYR    44      14.450  10.236  35.952  1.00 39.33          
ATOM    286  CG  TYR    44      14.102  10.623  34.536  1.00 40.85          
ATOM    287  CD1 TYR    44      15.075  11.124  33.664  1.00 40.75          
ATOM    288  CD2 TYR    44      12.798  10.482  34.059  1.00 40.46          
ATOM    289  CE1 TYR    44      14.750  11.471  32.350  1.00 41.84          
ATOM    290  CE2 TYR    44      12.467  10.829  32.753  1.00 41.49          
ATOM    291  CZ  TYR    44      13.437  11.319  31.901  1.00 42.05          
ATOM    292  OH  TYR    44      13.093  11.647  30.599  1.00 42.46          
ATOM    293  N   GLN    45      16.945   9.042  37.847  1.00 43.92          
ATOM    294  CA  GLN    45      17.452   8.884  39.196  1.00 46.34          
ATOM    295  C   GLN    45      17.102  10.118  40.029  1.00 47.78          
ATOM    296  O   GLN    45      17.187  11.249  39.548  1.00 47.56          
ATOM    297  CB  GLN    45      18.965   8.648  39.145  1.00 47.12          
ATOM    298  CG  GLN    45      19.690   9.695  38.307  1.00 50.07          
ATOM    299  CD  GLN    45      20.942   9.167  37.622  1.00 50.58          
ATOM    300  OE1 GLN    45      20.898   8.142  36.937  1.00 50.72          
ATOM    301  NE2 GLN    45      22.057   9.879  37.783  1.00 49.70          
ATOM    302  N   GLY    46      16.685   9.896  41.274  1.00 48.21          
ATOM    303  CA  GLY    46      16.318  11.011  42.135  1.00 49.37          
ATOM    304  C   GLY    46      14.813  11.171  42.212  1.00 50.77          
ATOM    305  O   GLY    46      14.273  11.756  43.159  1.00 49.20          
ATOM    306  N   MET    47      14.137  10.648  41.193  1.00 52.76          
ATOM    307  CA  MET    47      12.685  10.704  41.117  1.00 54.61          
ATOM    308  C   MET    47      12.150   9.309  41.425  1.00 53.36          
ATOM    309  O   MET    47      11.777   8.565  40.523  1.00 53.21          
ATOM    310  CB  MET    47      12.261  11.145  39.723  1.00 56.82          
ATOM    311  CG  MET    47      13.015  12.367  39.261  1.00 61.64          
ATOM    312  SD  MET    47      12.390  13.007  37.567  1.00 70.25          
ATOM    313  CE  MET    47      11.239  14.436  38.153  1.00 69.01          
ATOM    314  N   ASP    48      12.109   8.969  42.713  1.00 52.63          
ATOM    315  CA  ASP    48      11.651   7.657  43.149  1.00 51.41          
ATOM    316  C   ASP    48      10.236   7.640  43.742  1.00 49.19          
ATOM    317  O   ASP    48       9.437   6.753  43.438  1.00 48.61          
ATOM    318  CB  ASP    48      12.644   7.074  44.166  1.00 52.25          
ATOM    319  CG  ASP    48      14.094   7.486  43.887  1.00 52.83          
ATOM    320  OD1 ASP    48      14.559   7.391  42.724  1.00 52.86          
ATOM    321  OD2 ASP    48      14.782   7.901  44.845  1.00 52.66          
ATOM    322  N   ILE    49       9.924   8.620  44.578  1.00 46.94          
ATOM    323  CA  ILE    49       8.617   8.680  45.210  1.00 45.38          
ATOM    324  C   ILE    49       7.471   9.008  44.261  1.00 43.66          
ATOM    325  O   ILE    49       6.463   8.309  44.243  1.00 43.49          
ATOM    326  CB  ILE    49       8.618   9.712  46.353  1.00 45.88          
ATOM    327  CG1 ILE    49       9.599   9.276  47.434  1.00 44.79          
ATOM    328  CG2 ILE    49       7.206   9.873  46.912  1.00 46.48          
ATOM    329  CD  ILE    49       9.745  10.265  48.557  1.00 47.30          
ATOM    330  N   GLY    50       7.617  10.070  43.479  1.00 42.05          
ATOM    331  CA  GLY    50       6.546  10.454  42.569  1.00 41.84          
ATOM    332  C   GLY    50       6.304   9.495  41.416  1.00 39.86          
ATOM    333  O   GLY    50       5.323   9.614  40.685  1.00 38.30          
ATOM    334  N   THR    51       7.185   8.522  41.268  1.00 38.59          
ATOM    335  CA  THR    51       7.065   7.593  40.177  1.00 39.16          
ATOM    336  C   THR    51       6.732   6.186  40.632  1.00 39.81          
ATOM    337  O   THR    51       6.650   5.269  39.811  1.00 40.79          
ATOM    338  CB  THR    51       8.364   7.555  39.405  1.00 39.85          
ATOM    339  OG1 THR    51       9.419   7.139  40.288  1.00 39.12          
ATOM    340  CG2 THR    51       8.684   8.950  38.852  1.00 39.88          
ATOM    341  N   ALA    52       6.545   6.017  41.939  1.00 39.14          
ATOM    342  CA  ALA    52       6.226   4.717  42.538  1.00 37.57          
ATOM    343  C   ALA    52       7.338   3.724  42.226  1.00 38.14          
ATOM    344  O   ALA    52       7.094   2.532  42.036  1.00 37.54          
ATOM    345  CB  ALA    52       4.886   4.200  42.022  1.00 35.81          
ATOM    346  N   LYS    53       8.565   4.235  42.181  1.00 40.06          
ATOM    347  CA  LYS    53       9.741   3.420  41.888  1.00 42.16          
ATOM    348  C   LYS    53       9.989   2.345  42.939  1.00 42.20          
ATOM    349  O   LYS    53      10.161   2.651  44.121  1.00 42.30          
ATOM    350  CB  LYS    53      10.978   4.311  41.782  1.00 42.37          
ATOM    351  CG  LYS    53      12.272   3.549  41.536  1.00 42.48          
ATOM    352  CD  LYS    53      13.408   4.512  41.341  1.00 41.69          
ATOM    353  CE  LYS    53      13.132   5.409  40.152  1.00 42.68          
ATOM    354  NZ  LYS    53      14.081   6.557  40.102  1.00 44.19          
ATOM    355  N   VAL    54      10.027   1.089  42.498  1.00 42.43          
ATOM    356  CA  VAL    54      10.262  -0.040  43.395  1.00 42.54          
ATOM    357  C   VAL    54      11.678  -0.002  43.960  1.00 42.74          
ATOM    358  O   VAL    54      12.640   0.289  43.238  1.00 42.21          
ATOM    359  CB  VAL    54      10.024  -1.382  42.660  1.00 43.26          
ATOM    360  CG1 VAL    54      10.765  -1.401  41.325  1.00 43.42          
ATOM    361  CG2 VAL    54      10.471  -2.525  43.538  1.00 44.75          
ATOM    362  N   THR    55      11.810  -0.291  45.250  1.00 41.88          
ATOM    363  CA  THR    55      13.120  -0.254  45.891  1.00 42.17          
ATOM    364  C   THR    55      13.915  -1.537  45.748  1.00 40.91          
ATOM    365  O   THR    55      13.357  -2.611  45.534  1.00 37.85          
ATOM    366  CB  THR    55      12.999   0.093  47.397  1.00 42.92          
ATOM    367  OG1 THR    55      12.447  -1.019  48.126  1.00 45.00          
ATOM    368  CG2 THR    55      12.105   1.306  47.580  1.00 44.24          
ATOM    369  N   THR    56      15.233  -1.406  45.856  1.00 42.43          
ATOM    370  CA  THR    56      16.114  -2.557  45.731  1.00 44.85          
ATOM    371  C   THR    56      15.630  -3.688  46.640  1.00 45.98          
ATOM    372  O   THR    56      15.676  -4.852  46.262  1.00 46.23          
ATOM    373  CB  THR    56      17.581  -2.218  46.109  1.00 44.96          
ATOM    374  OG1 THR    56      17.663  -1.947  47.513  1.00 47.28          
ATOM    375  CG2 THR    56      18.067  -0.995  45.350  1.00 46.18          
ATOM    376  N   GLU    57      15.143  -3.343  47.828  1.00 47.39          
ATOM    377  CA  GLU    57      14.674  -4.344  48.773  1.00 47.62          
ATOM    378  C   GLU    57      13.441  -5.053  48.306  1.00 47.71          
ATOM    379  O   GLU    57      13.327  -6.260  48.438  1.00 48.16          
ATOM    380  CB  GLU    57      14.361  -3.712  50.117  1.00 49.17          
ATOM    381  CG  GLU    57      13.931  -4.714  51.180  1.00 50.98          
ATOM    382  CD  GLU    57      13.395  -4.031  52.437  1.00 52.75          
ATOM    383  OE1 GLU    57      13.203  -4.714  53.468  1.00 53.26          
ATOM    384  OE2 GLU    57      13.154  -2.807  52.382  1.00 54.01          
ATOM    385  N   GLU    58      12.502  -4.291  47.779  1.00 48.34          
ATOM    386  CA  GLU    58      11.257  -4.857  47.314  1.00 50.36          
ATOM    387  C   GLU    58      11.435  -5.758  46.103  1.00 51.67          
ATOM    388  O   GLU    58      10.605  -6.627  45.843  1.00 51.05          
ATOM    389  CB  GLU    58      10.276  -3.730  47.011  1.00 51.70          
ATOM    390  CG  GLU    58      10.044  -2.804  48.205  1.00 54.05          
ATOM    391  CD  GLU    58       9.059  -1.690  47.897  1.00 54.95          
ATOM    392  OE1 GLU    58       9.289  -0.952  46.911  1.00 53.56          
ATOM    393  OE2 GLU    58       8.062  -1.554  48.646  1.00 56.23          
ATOM    394  N   MET    59      12.522  -5.561  45.366  1.00 53.00          
ATOM    395  CA  MET    59      12.804  -6.374  44.179  1.00 54.52          
ATOM    396  C   MET    59      13.089  -7.828  44.530  1.00 54.25          
ATOM    397  O   MET    59      13.251  -8.662  43.641  1.00 54.07          
ATOM    398  CB  MET    59      14.009  -5.814  43.428  1.00 57.77          
ATOM    399  CG  MET    59      13.794  -4.457  42.799  1.00 62.25          
ATOM    400  SD  MET    59      15.363  -3.879  41.807  1.00 70.44          
ATOM    401  CE  MET    59      15.371  -1.998  42.290  1.00 67.49          
ATOM    402  N   GLU    60      13.163  -8.110  45.831  1.00 53.56          
ATOM    403  CA  GLU    60      13.433  -9.453  46.352  1.00 52.64          
ATOM    404  C   GLU    60      14.481 -10.251  45.585  1.00 50.43          
ATOM    405  O   GLU    60      14.318 -11.450  45.392  1.00 51.35          
ATOM    406  CB  GLU    60      12.135 -10.261  46.420  1.00 53.57          
ATOM    407  CG  GLU    60      11.354 -10.074  47.708  1.00 56.49          
ATOM    408  CD  GLU    60       9.894 -10.467  47.562  1.00 59.54          
ATOM    409  OE1 GLU    60       9.610 -11.476  46.869  1.00 60.10          
ATOM    410  OE2 GLU    60       9.029  -9.774  48.151  1.00 60.23          
ATOM    411  N   GLY    61      15.554  -9.601  45.154  1.00 48.05          
ATOM    412  CA  GLY    61      16.582 -10.330  44.443  1.00 46.22          
ATOM    413  C   GLY    61      16.423 -10.307  42.939  1.00 45.02          
ATOM    414  O   GLY    61      17.412 -10.296  42.208  1.00 46.21          
ATOM    415  N   ILE    62      15.189 -10.308  42.455  1.00 43.60          
ATOM    416  CA  ILE    62      14.969 -10.276  41.019  1.00 41.23          
ATOM    417  C   ILE    62      15.599  -9.022  40.419  1.00 40.65          
ATOM    418  O   ILE    62      15.292  -7.905  40.821  1.00 41.62          
ATOM    419  CB  ILE    62      13.479 -10.248  40.689  1.00 40.73          
ATOM    420  CG1 ILE    62      12.776 -11.464  41.306  1.00 38.20          
ATOM    421  CG2 ILE    62      13.306 -10.157  39.179  1.00 41.74          
ATOM    422  CD  ILE    62      13.258 -12.789  40.784  1.00 36.15          
ATOM    423  N   PRO    63      16.491  -9.190  39.442  1.00 40.13          
ATOM    424  CA  PRO    63      17.144  -8.041  38.805  1.00 40.32          
ATOM    425  C   PRO    63      16.221  -7.197  37.917  1.00 39.75          
ATOM    426  O   PRO    63      15.509  -7.736  37.073  1.00 39.18          
ATOM    427  CB  PRO    63      18.277  -8.694  38.008  1.00 40.21          
ATOM    428  CG  PRO    63      17.715 -10.036  37.661  1.00 39.66          
ATOM    429  CD  PRO    63      17.070 -10.455  38.959  1.00 40.22          
ATOM    430  N   HSD    64      16.235  -5.877  38.115  1.00 39.80          
ATOM    431  CA  HSD    64      15.404  -4.971  37.322  1.00 40.76          
ATOM    432  C   HSD    64      16.240  -4.041  36.409  1.00 42.95          
ATOM    433  O   HSD    64      17.318  -3.576  36.786  1.00 41.97          
ATOM    434  CB  HSD    64      14.493  -4.123  38.232  1.00 37.92          
ATOM    435  CG  HSD    64      13.430  -4.905  38.944  1.00 36.17          
ATOM    436  ND1 HSD    64      12.239  -4.340  39.346  1.00 36.89          
ATOM    437  CD2 HSD    64      13.383  -6.196  39.354  1.00 35.64          
ATOM    438  CE1 HSD    64      11.505  -5.244  39.969  1.00 35.10          
ATOM    439  NE2 HSD    64      12.177  -6.380  39.986  1.00 33.58          
ATOM    440  N   TYR    65      15.734  -3.786  35.201  1.00 44.46          
ATOM    441  CA  TYR    65      16.416  -2.924  34.246  1.00 46.92          
ATOM    442  C   TYR    65      15.558  -1.722  33.913  1.00 48.79          
ATOM    443  O   TYR    65      14.356  -1.716  34.197  1.00 48.51          
ATOM    444  CB  TYR    65      16.734  -3.679  32.956  1.00 46.24          
ATOM    445  CG  TYR    65      17.495  -4.956  33.189  1.00 46.04          
ATOM    446  CD1 TYR    65      16.839  -6.181  33.203  1.00 45.12          
ATOM    447  CD2 TYR    65      18.876  -4.940  33.421  1.00 46.83          
ATOM    448  CE1 TYR    65      17.538  -7.365  33.439  1.00 45.27          
ATOM    449  CE2 TYR    65      19.587  -6.118  33.664  1.00 44.91          
ATOM    450  CZ  TYR    65      18.915  -7.324  33.666  1.00 44.46          
ATOM    451  OH  TYR    65      19.618  -8.485  33.861  1.00 42.99          
ATOM    452  N   MET    66      16.180  -0.709  33.310  1.00 50.14          
ATOM    453  CA  MET    66      15.474   0.511  32.938  1.00 52.49          
ATOM    454  C   MET    66      15.065   1.366  34.144  1.00 51.53          
ATOM    455  O   MET    66      14.097   2.124  34.068  1.00 50.60          
ATOM    456  CB  MET    66      14.225   0.152  32.137  1.00 57.56          
ATOM    457  CG  MET    66      14.507  -0.541  30.808  1.00 65.45          
ATOM    458  SD  MET    66      15.334   0.620  29.477  1.00 71.33          
ATOM    459  CE  MET    66      13.820   1.809  29.184  1.00 69.78          
ATOM    460  N   ILE    67      15.790   1.237  35.256  1.00 50.85          
ATOM    461  CA  ILE    67      15.494   2.005  36.472  1.00 49.39          
ATOM    462  C   ILE    67      16.742   2.762  36.944  1.00 48.87          
ATOM    463  O   ILE    67      17.774   2.150  37.219  1.00 49.58          
ATOM    464  CB  ILE    67      14.973   1.076  37.606  1.00 48.43          
ATOM    465  CG1 ILE    67      13.742   0.313  37.121  1.00 47.01          
ATOM    466  CG2 ILE    67      14.617   1.897  38.840  1.00 47.68          
ATOM    467  CD  ILE    67      13.258  -0.716  38.065  1.00 46.08          
ATOM    468  N   ASP    68      16.639   4.090  37.028  1.00 47.81          
ATOM    469  CA  ASP    68      17.760   4.942  37.434  1.00 47.06          
ATOM    470  C   ASP    68      18.911   4.812  36.444  1.00 46.44          
ATOM    471  O   ASP    68      20.064   4.604  36.838  1.00 46.29          
ATOM    472  CB  ASP    68      18.277   4.568  38.826  1.00 48.04          
ATOM    473  CG  ASP    68      17.305   4.924  39.929  1.00 49.01          
ATOM    474  OD1 ASP    68      16.806   6.072  39.939  1.00 51.42          
ATOM    475  OD2 ASP    68      17.052   4.068  40.799  1.00 48.86          
ATOM    476  N   ILE    69      18.599   4.922  35.158  1.00 44.44          
ATOM    477  CA  ILE    69      19.616   4.812  34.129  1.00 42.98          
ATOM    478  C   ILE    69      19.953   6.161  33.496  1.00 42.60          
ATOM    479  O   ILE    69      20.851   6.252  32.664  1.00 42.00          
ATOM    480  CB  ILE    69      19.170   3.854  33.018  1.00 43.70          
ATOM    481  CG1 ILE    69      17.845   4.328  32.414  1.00 43.50          
ATOM    482  CG2 ILE    69      19.052   2.449  33.565  1.00 44.67          
ATOM    483  CD  ILE    69      17.404   3.536  31.203  1.00 42.90          
ATOM    484  N   LEU    70      19.245   7.212  33.902  1.00 42.59          
ATOM    485  CA  LEU    70      19.486   8.549  33.359  1.00 40.82          
ATOM    486  C   LEU    70      19.250   9.633  34.407  1.00 41.05          
ATOM    487  O   LEU    70      18.577   9.405  35.398  1.00 41.88          
ATOM    488  CB  LEU    70      18.548   8.791  32.171  1.00 39.27          
ATOM    489  CG  LEU    70      18.589   7.800  31.020  1.00 36.21          
ATOM    490  CD1 LEU    70      17.340   7.949  30.200  1.00 36.04          
ATOM    491  CD2 LEU    70      19.824   8.038  30.194  1.00 34.44          
ATOM    492  N   PRO    71      19.835  10.825  34.214  1.00 43.24          
ATOM    493  CA  PRO    71      19.650  11.934  35.154  1.00 41.06          
ATOM    494  C   PRO    71      18.362  12.638  34.725  1.00 42.77          
ATOM    495  O   PRO    71      17.904  12.457  33.605  1.00 42.17          
ATOM    496  CB  PRO    71      20.879  12.792  34.919  1.00 42.02          
ATOM    497  CG  PRO    71      21.065  12.653  33.448  1.00 41.82          
ATOM    498  CD  PRO    71      20.887  11.154  33.242  1.00 42.37          
ATOM    499  N   PRO    72      17.770  13.460  35.603  1.00 46.11          
ATOM    500  CA  PRO    72      16.522  14.173  35.299  1.00 45.97          
ATOM    501  C   PRO    72      16.497  14.962  33.990  1.00 48.27          
ATOM    502  O   PRO    72      15.500  14.933  33.254  1.00 49.06          
ATOM    503  CB  PRO    72      16.327  15.057  36.521  1.00 45.64          
ATOM    504  CG  PRO    72      16.892  14.201  37.619  1.00 45.86          
ATOM    505  CD  PRO    72      18.180  13.706  36.995  1.00 45.76          
ATOM    506  N   ASP    73      17.593  15.659  33.693  1.00 50.27          
ATOM    507  CA  ASP    73      17.710  16.484  32.476  1.00 50.11          
ATOM    508  C   ASP    73      17.880  15.666  31.197  1.00 50.04          
ATOM    509  O   ASP    73      17.918  16.220  30.087  1.00 51.02          
ATOM    510  CB  ASP    73      18.889  17.460  32.625  1.00 52.01          
ATOM    511  CG  ASP    73      20.224  16.746  32.837  1.00 54.57          
ATOM    512  OD1 ASP    73      20.667  16.017  31.911  1.00 55.67          
ATOM    513  OD2 ASP    73      20.834  16.922  33.921  1.00 53.87          
ATOM    514  N   ALA    74      17.997  14.350  31.356  1.00 48.21          
ATOM    515  CA  ALA    74      18.159  13.464  30.210  1.00 45.93          
ATOM    516  C   ALA    74      16.842  13.337  29.472  1.00 44.07          
ATOM    517  O   ALA    74      15.780  13.627  30.015  1.00 41.10          
ATOM    518  CB  ALA    74      18.645  12.094  30.668  1.00 46.53          
ATOM    519  N   SER    75      16.921  12.893  28.229  1.00 44.15          
ATOM    520  CA  SER    75      15.727  12.747  27.425  1.00 44.33          
ATOM    521  C   SER    75      15.354  11.285  27.232  1.00 42.90          
ATOM    522  O   SER    75      16.217  10.409  27.187  1.00 42.46          
ATOM    523  CB  SER    75      15.932  13.425  26.073  1.00 45.22          
ATOM    524  OG  SER    75      14.852  13.131  25.206  1.00 48.08          
ATOM    525  N   PHE    76      14.058  11.028  27.128  1.00 42.25          
ATOM    526  CA  PHE    76      13.589   9.677  26.939  1.00 42.63          
ATOM    527  C   PHE    76      12.435   9.680  25.950  1.00 44.28          
ATOM    528  O   PHE    76      11.843  10.731  25.681  1.00 44.93          
ATOM    529  CB  PHE    76      13.158   9.080  28.272  1.00 41.10          
ATOM    530  CG  PHE    76      13.230   7.592  28.304  1.00 40.73          
ATOM    531  CD1 PHE    76      14.438   6.943  28.082  1.00 40.57          
ATOM    532  CD2 PHE    76      12.091   6.830  28.513  1.00 40.81          
ATOM    533  CE1 PHE    76      14.515   5.548  28.069  1.00 40.33          
ATOM    534  CE2 PHE    76      12.157   5.431  28.503  1.00 40.80          
ATOM    535  CZ  PHE    76      13.375   4.793  28.276  1.00 39.45          
ATOM    536  N   SER    77      12.112   8.506  25.413  1.00 44.42          
ATOM    537  CA  SER    77      11.050   8.409  24.423  1.00 44.38          
ATOM    538  C   SER    77      10.626   6.972  24.168  1.00 44.19          
ATOM    539  O   SER    77      11.321   6.029  24.532  1.00 43.90          
ATOM    540  CB  SER    77      11.537   8.990  23.107  1.00 45.47          
ATOM    541  OG  SER    77      12.572   8.162  22.578  1.00 47.33          
ATOM    542  N   ALA    78       9.481   6.813  23.521  1.00 42.68          
ATOM    543  CA  ALA    78       8.996   5.488  23.212  1.00 42.21          
ATOM    544  C   ALA    78      10.066   4.637  22.487  1.00 43.10          
ATOM    545  O   ALA    78      10.303   3.504  22.882  1.00 42.31          
ATOM    546  CB  ALA    78       7.714   5.577  22.377  1.00 41.89          
ATOM    547  N   TYR    79      10.724   5.159  21.448  1.00 44.68          
ATOM    548  CA  TYR    79      11.728   4.350  20.756  1.00 46.27          
ATOM    549  C   TYR    79      12.962   4.134  21.609  1.00 44.55          
ATOM    550  O   TYR    79      13.531   3.041  21.616  1.00 43.90          
ATOM    551  CB  TYR    79      12.148   4.962  19.403  1.00 52.71          
ATOM    552  CG  TYR    79      13.289   4.209  18.700  1.00 58.76          
ATOM    553  CD1 TYR    79      14.585   4.755  18.646  1.00 61.33          
ATOM    554  CD2 TYR    79      13.085   2.935  18.131  1.00 60.40          
ATOM    555  CE1 TYR    79      15.655   4.053  18.050  1.00 63.02          
ATOM    556  CE2 TYR    79      14.152   2.218  17.531  1.00 62.10          
ATOM    557  CZ  TYR    79      15.431   2.784  17.497  1.00 63.41          
ATOM    558  OH  TYR    79      16.489   2.099  16.917  1.00 62.92          
ATOM    559  N   GLU    80      13.384   5.165  22.327  1.00 42.75          
ATOM    560  CA  GLU    80      14.558   5.030  23.179  1.00 41.93          
ATOM    561  C   GLU    80      14.369   3.772  24.037  1.00 40.72          
ATOM    562  O   GLU    80      15.285   2.960  24.174  1.00 41.10          
ATOM    563  CB  GLU    80      14.726   6.288  24.053  1.00 41.99          
ATOM    564  CG  GLU    80      15.937   6.271  24.984  1.00 43.40          
ATOM    565  CD  GLU    80      17.244   5.907  24.289  1.00 44.68          
ATOM    566  OE1 GLU    80      18.281   5.855  24.990  1.00 44.88          
ATOM    567  OE2 GLU    80      17.247   5.676  23.057  1.00 44.63          
ATOM    568  N   PHE    81      13.158   3.609  24.570  1.00 38.87          
ATOM    569  CA  PHE    81      12.781   2.465  25.407  1.00 36.19          
ATOM    570  C   PHE    81      12.849   1.170  24.596  1.00 36.54          
ATOM    571  O   PHE    81      13.312   0.137  25.086  1.00 35.85          
ATOM    572  CB  PHE    81      11.357   2.689  25.962  1.00 33.12          
ATOM    573  CG  PHE    81      10.681   1.435  26.465  1.00 30.51          
ATOM    574  CD1 PHE    81      11.210   0.717  27.524  1.00 29.09          
ATOM    575  CD2 PHE    81       9.528   0.957  25.850  1.00 30.08          
ATOM    576  CE1 PHE    81      10.613  -0.454  27.955  1.00 28.28          
ATOM    577  CE2 PHE    81       8.925  -0.218  26.280  1.00 28.60          
ATOM    578  CZ  PHE    81       9.470  -0.921  27.330  1.00 27.92          
ATOM    579  N   LYS    82      12.394   1.239  23.347  1.00 37.42          
ATOM    580  CA  LYS    82      12.392   0.079  22.453  1.00 38.62          
ATOM    581  C   LYS    82      13.807  -0.407  22.131  1.00 38.47          
ATOM    582  O   LYS    82      14.089  -1.606  22.162  1.00 36.19          
ATOM    583  CB  LYS    82      11.656   0.420  21.148  1.00 39.34          
ATOM    584  CG  LYS    82      11.549  -0.733  20.172  1.00 38.40          
ATOM    585  CD  LYS    82      10.907  -0.297  18.874  1.00 39.39          
ATOM    586  CE  LYS    82      10.964  -1.429  17.858  1.00 41.17          
ATOM    587  NZ  LYS    82       9.977  -1.274  16.742  1.00 42.70          
ATOM    588  N   LYS    83      14.690   0.535  21.822  1.00 39.75          
ATOM    589  CA  LYS    83      16.067   0.201  21.496  1.00 40.53          
ATOM    590  C   LYS    83      16.724  -0.543  22.648  1.00 40.76          
ATOM    591  O   LYS    83      17.320  -1.608  22.444  1.00 41.80          
ATOM    592  CB  LYS    83      16.863   1.470  21.177  1.00 40.74          
ATOM    593  CG  LYS    83      18.312   1.194  20.853  1.00 42.46          
ATOM    594  CD  LYS    83      19.071   2.446  20.455  1.00 45.99          
ATOM    595  CE  LYS    83      20.459   2.070  19.928  1.00 48.24          
ATOM    596  NZ  LYS    83      21.259   3.243  19.463  1.00 50.23          
ATOM    597  N   ARG    84      16.607   0.020  23.856  1.00 40.35          
ATOM    598  CA  ARG    84      17.190  -0.572  25.084  1.00 39.35          
ATOM    599  C   ARG    84      16.484  -1.854  25.530  1.00 37.92          
ATOM    600  O   ARG    84      17.133  -2.806  25.954  1.00 36.85          
ATOM    601  CB  ARG    84      17.156   0.429  26.250  1.00 36.67          
ATOM    602  CG  ARG    84      17.859   1.728  25.980  1.00 36.15          
ATOM    603  CD  ARG    84      18.054   2.528  27.259  1.00 38.44          
ATOM    604  NE  ARG    84      18.593   3.855  26.966  1.00 40.06          
ATOM    605  CZ  ARG    84      19.648   4.396  27.567  1.00 40.78          
ATOM    606  NH1 ARG    84      20.299   3.728  28.515  1.00 40.28          
ATOM    607  NH2 ARG    84      20.058   5.606  27.202  1.00 41.15          
ATOM    608  N   ALA    85      15.158  -1.862  25.438  1.00 37.30          
ATOM    609  CA  ALA    85      14.393  -3.027  25.822  1.00 38.07          
ATOM    610  C   ALA    85      14.677  -4.226  24.905  1.00 38.96          
ATOM    611  O   ALA    85      14.838  -5.338  25.393  1.00 38.84          
ATOM    612  CB  ALA    85      12.906  -2.698  25.837  1.00 37.62          
ATOM    613  N   GLU    86      14.755  -4.012  23.590  1.00 40.01          
ATOM    614  CA  GLU    86      15.020  -5.119  22.663  1.00 40.70          
ATOM    615  C   GLU    86      16.344  -5.794  22.966  1.00 39.19          
ATOM    616  O   GLU    86      16.460  -7.009  22.858  1.00 37.95          
ATOM    617  CB  GLU    86      15.035  -4.644  21.199  1.00 43.09          
ATOM    618  CG  GLU    86      13.732  -4.026  20.702  1.00 48.93          
ATOM    619  CD  GLU    86      13.759  -3.649  19.220  1.00 52.55          
ATOM    620  OE1 GLU    86      13.735  -4.566  18.368  1.00 56.38          
ATOM    621  OE2 GLU    86      13.814  -2.435  18.898  1.00 54.39          
ATOM    622  N   LYS    87      17.346  -5.012  23.343  1.00 38.58          
ATOM    623  CA  LYS    87      18.640  -5.592  23.648  1.00 38.74          
ATOM    624  C   LYS    87      18.535  -6.451  24.909  1.00 37.94          
ATOM    625  O   LYS    87      18.982  -7.593  24.913  1.00 37.92          
ATOM    626  CB  LYS    87      19.692  -4.489  23.821  1.00 40.10          
ATOM    627  CG  LYS    87      19.922  -3.647  22.563  1.00 40.60          
ATOM    628  CD  LYS    87      20.746  -2.395  22.866  1.00 42.69          
ATOM    629  CE  LYS    87      20.904  -1.490  21.628  1.00 42.87          
ATOM    630  NZ  LYS    87      21.492  -0.138  21.934  1.00 39.82          
ATOM    631  N   TYR    88      17.925  -5.910  25.962  1.00 36.95          
ATOM    632  CA  TYR    88      17.762  -6.644  27.214  1.00 37.15          
ATOM    633  C   TYR    88      16.916  -7.913  27.029  1.00 37.80          
ATOM    634  O   TYR    88      17.218  -8.973  27.580  1.00 37.94          
ATOM    635  CB  TYR    88      17.124  -5.756  28.295  1.00 37.25          
ATOM    636  CG  TYR    88      18.036  -4.700  28.910  1.00 39.23          
ATOM    637  CD1 TYR    88      17.783  -3.333  28.719  1.00 41.10          
ATOM    638  CD2 TYR    88      19.113  -5.059  29.734  1.00 38.28          
ATOM    639  CE1 TYR    88      18.568  -2.351  29.335  1.00 41.52          
ATOM    640  CE2 TYR    88      19.908  -4.081  30.358  1.00 38.86          
ATOM    641  CZ  TYR    88      19.626  -2.732  30.153  1.00 41.28          
ATOM    642  OH  TYR    88      20.390  -1.755  30.754  1.00 40.69          
ATOM    643  N   ILE    89      15.853  -7.815  26.250  1.00 37.05          
ATOM    644  CA  ILE    89      15.015  -8.973  26.022  1.00 36.98          
ATOM    645  C   ILE    89      15.820 -10.109  25.369  1.00 37.79          
ATOM    646  O   ILE    89      15.541 -11.282  25.617  1.00 37.75          
ATOM    647  CB  ILE    89      13.792  -8.608  25.139  1.00 35.57          
ATOM    648  CG1 ILE    89      12.904  -7.602  25.886  1.00 33.73          
ATOM    649  CG2 ILE    89      13.017  -9.859  24.777  1.00 33.51          
ATOM    650  CD  ILE    89      11.739  -7.066  25.077  1.00 30.08          
ATOM    651  N   LYS    90      16.806  -9.776  24.533  1.00 38.00          
ATOM    652  CA  LYS    90      17.631 -10.807  23.886  1.00 38.01          
ATOM    653  C   LYS    90      18.670 -11.334  24.868  1.00 38.13          
ATOM    654  O   LYS    90      18.861 -12.542  24.992  1.00 37.33          
ATOM    655  CB  LYS    90      18.349 -10.258  22.639  1.00 39.66          
ATOM    656  CG  LYS    90      17.608 -10.447  21.296  1.00 40.93          
ATOM    657  CD  LYS    90      18.408  -9.912  20.066  1.00 41.15          
ATOM    658  CE  LYS    90      18.564  -8.369  20.076  1.00 42.47          
ATOM    659  NZ  LYS    90      19.370  -7.772  18.962  1.00 39.46          
ATOM    660  N   ASP    91      19.342 -10.428  25.565  1.00 37.73          
ATOM    661  CA  ASP    91      20.350 -10.837  26.521  1.00 38.39          
ATOM    662  C   ASP    91      19.727 -11.783  27.541  1.00 38.89          
ATOM    663  O   ASP    91      20.293 -12.821  27.849  1.00 39.41          
ATOM    664  CB  ASP    91      20.930  -9.613  27.221  1.00 39.76          
ATOM    665  CG  ASP    91      22.095  -9.957  28.110  1.00 40.54          
ATOM    666  OD1 ASP    91      23.143 -10.368  27.568  1.00 41.54          
ATOM    667  OD2 ASP    91      21.961  -9.820  29.341  1.00 39.83          
ATOM    668  N   ILE    92      18.553 -11.418  28.052  1.00 38.96          
ATOM    669  CA  ILE    92      17.828 -12.232  29.034  1.00 39.57          
ATOM    670  C   ILE    92      17.530 -13.640  28.495  1.00 40.37          
ATOM    671  O   ILE    92      17.873 -14.645  29.131  1.00 41.32          
ATOM    672  CB  ILE    92      16.481 -11.547  29.448  1.00 38.05          
ATOM    673  CG1 ILE    92      16.772 -10.233  30.174  1.00 38.15          
ATOM    674  CG2 ILE    92      15.653 -12.464  30.338  1.00 36.72          
ATOM    675  CD  ILE    92      15.537  -9.460  30.585  1.00 35.07          
ATOM    676  N   THR    93      16.896 -13.717  27.326  1.00 40.55          
ATOM    677  CA  THR    93      16.551 -15.012  26.745  1.00 39.43          
ATOM    678  C   THR    93      17.799 -15.812  26.487  1.00 38.37          
ATOM    679  O   THR    93      17.805 -17.030  26.638  1.00 37.61          
ATOM    680  CB  THR    93      15.849 -14.890  25.379  1.00 40.05          
ATOM    681  OG1 THR    93      14.887 -13.822  25.391  1.00 40.47          
ATOM    682  CG2 THR    93      15.152 -16.199  25.048  1.00 38.13          
ATOM    683  N   ARG    94      18.851 -15.102  26.091  1.00 38.34          
ATOM    684  CA  ARG    94      20.141 -15.708  25.766  1.00 38.82          
ATOM    685  C   ARG    94      20.741 -16.429  26.954  1.00 37.58          
ATOM    686  O   ARG    94      21.525 -17.358  26.788  1.00 37.56          
ATOM    687  CB  ARG    94      21.106 -14.625  25.251  1.00 39.26          
ATOM    688  CG  ARG    94      22.336 -15.144  24.519  1.00 39.09          
ATOM    689  CD  ARG    94      23.214 -13.978  24.047  1.00 39.93          
ATOM    690  NE  ARG    94      23.583 -13.091  25.149  1.00 43.31          
ATOM    691  CZ  ARG    94      24.223 -13.484  26.250  1.00 44.23          
ATOM    692  NH1 ARG    94      24.509 -12.604  27.209  1.00 45.12          
ATOM    693  NH2 ARG    94      24.578 -14.756  26.396  1.00 44.13          
ATOM    694  N   ARG    95      20.374 -15.999  28.152  1.00 38.15          
ATOM    695  CA  ARG    95      20.890 -16.641  29.355  1.00 39.17          
ATOM    696  C   ARG    95      19.842 -17.586  29.935  1.00 40.16          
ATOM    697  O   ARG    95      19.773 -17.807  31.148  1.00 40.51          
ATOM    698  CB  ARG    95      21.312 -15.597  30.384  1.00 39.03          
ATOM    699  CG  ARG    95      22.321 -14.600  29.835  1.00 40.05          
ATOM    700  CD  ARG    95      22.995 -13.810  30.936  1.00 42.08          
ATOM    701  NE  ARG    95      22.028 -13.214  31.869  1.00 44.60          
ATOM    702  CZ  ARG    95      21.082 -12.352  31.516  1.00 45.39          
ATOM    703  NH1 ARG    95      20.262 -11.869  32.426  1.00 45.54          
ATOM    704  NH2 ARG    95      20.957 -11.974  30.249  1.00 47.84          
ATOM    705  N   GLY    96      19.024 -18.134  29.035  1.00 41.04          
ATOM    706  CA  GLY    96      17.982 -19.081  29.403  1.00 41.01          
ATOM    707  C   GLY    96      16.998 -18.627  30.459  1.00 41.51          
ATOM    708  O   GLY    96      16.566 -19.424  31.286  1.00 41.53          
ATOM    709  N   LYS    97      16.644 -17.350  30.443  1.00 41.90          
ATOM    710  CA  LYS    97      15.692 -16.832  31.419  1.00 42.49          
ATOM    711  C   LYS    97      14.426 -16.318  30.727  1.00 41.53          
ATOM    712  O   LYS    97      14.305 -16.363  29.498  1.00 42.10          
ATOM    713  CB  LYS    97      16.334 -15.716  32.252  1.00 43.46          
ATOM    714  CG  LYS    97      17.166 -16.206  33.436  1.00 45.45          
ATOM    715  CD  LYS    97      17.908 -15.050  34.122  1.00 48.34          
ATOM    716  CE  LYS    97      18.004 -15.240  35.662  1.00 50.04          
ATOM    717  NZ  LYS    97      18.682 -16.515  36.088  1.00 48.07          
ATOM    718  N   VAL    98      13.483 -15.833  31.524  1.00 38.99          
ATOM    719  CA  VAL    98      12.230 -15.338  30.989  1.00 36.53          
ATOM    720  C   VAL    98      12.110 -13.838  31.071  1.00 37.14          
ATOM    721  O   VAL    98      11.898 -13.280  32.152  1.00 36.62          
ATOM    722  CB  VAL    98      11.041 -15.936  31.733  1.00 35.74          
ATOM    723  CG1 VAL    98       9.748 -15.385  31.159  1.00 34.97          
ATOM    724  CG2 VAL    98      11.084 -17.440  31.629  1.00 34.69          
ATOM    725  N   PRO    99      12.236 -13.158  29.924  1.00 36.43          
ATOM    726  CA  PRO    99      12.133 -11.702  29.880  1.00 35.92          
ATOM    727  C   PRO    99      10.707 -11.243  30.242  1.00 36.90          
ATOM    728  O   PRO    99       9.723 -11.657  29.609  1.00 36.32          
ATOM    729  CB  PRO    99      12.510 -11.383  28.444  1.00 35.09          
ATOM    730  CG  PRO    99      11.952 -12.549  27.710  1.00 35.11          
ATOM    731  CD  PRO    99      12.350 -13.717  28.570  1.00 35.83          
ATOM    732  N   ILE   100      10.609 -10.378  31.256  1.00 35.85          
ATOM    733  CA  ILE   100       9.324  -9.866  31.746  1.00 34.09          
ATOM    734  C   ILE   100       9.369  -8.347  31.820  1.00 34.92          
ATOM    735  O   ILE   100      10.280  -7.778  32.418  1.00 35.54          
ATOM    736  CB  ILE   100       9.038 -10.371  33.182  1.00 33.56          
ATOM    737  CG1 ILE   100       9.218 -11.888  33.261  1.00 33.93          
ATOM    738  CG2 ILE   100       7.648 -10.007  33.583  1.00 30.85          
ATOM    739  CD  ILE   100       9.497 -12.376  34.658  1.00 33.77          
ATOM    740  N   ILE   101       8.394  -7.688  31.213  1.00 35.33          
ATOM    741  CA  ILE   101       8.345  -6.238  31.279  1.00 35.38          
ATOM    742  C   ILE   101       7.166  -5.844  32.173  1.00 35.55          
ATOM    743  O   ILE   101       6.032  -6.270  31.972  1.00 34.79          
ATOM    744  CB  ILE   101       8.215  -5.592  29.879  1.00 34.99          
ATOM    745  CG1 ILE   101       7.036  -6.192  29.133  1.00 36.58          
ATOM    746  CG2 ILE   101       9.498  -5.807  29.099  1.00 34.45          
ATOM    747  CD  ILE   101       6.915  -5.691  27.723  1.00 39.07          
ATOM    748  N   ALA   102       7.478  -5.049  33.189  1.00 35.59          
ATOM    749  CA  ALA   102       6.510  -4.580  34.147  1.00 34.62          
ATOM    750  C   ALA   102       6.215  -3.135  33.837  1.00 36.25          
ATOM    751  O   ALA   102       7.129  -2.337  33.607  1.00 36.56          
ATOM    752  CB  ALA   102       7.066  -4.700  35.535  1.00 31.84          
ATOM    753  N   GLY   103       4.928  -2.806  33.808  1.00 36.86          
ATOM    754  CA  GLY   103       4.514  -1.438  33.547  1.00 34.82          
ATOM    755  C   GLY   103       4.605  -1.026  32.101  1.00 34.11          
ATOM    756  O   GLY   103       4.742  -1.863  31.211  1.00 34.68          
ATOM    757  N   GLY   104       4.527   0.282  31.880  1.00 34.21          
ATOM    758  CA  GLY   104       4.591   0.823  30.538  1.00 32.64          
ATOM    759  C   GLY   104       3.248   1.377  30.095  1.00 32.24          
ATOM    760  O   GLY   104       2.210   0.989  30.619  1.00 30.34          
ATOM    761  N   THR   105       3.271   2.290  29.129  1.00 34.02          
ATOM    762  CA  THR   105       2.050   2.892  28.604  1.00 36.46          
ATOM    763  C   THR   105       1.713   2.289  27.233  1.00 37.92          
ATOM    764  O   THR   105       2.510   1.540  26.673  1.00 39.04          
ATOM    765  CB  THR   105       2.202   4.430  28.452  1.00 35.92          
ATOM    766  OG1 THR   105       3.371   4.736  27.677  1.00 35.55          
ATOM    767  CG2 THR   105       2.293   5.096  29.818  1.00 36.82          
ATOM    768  N   GLY   106       0.540   2.619  26.698  1.00 38.11          
ATOM    769  CA  GLY   106       0.146   2.102  25.400  1.00 37.56          
ATOM    770  C   GLY   106       1.221   2.304  24.344  1.00 37.63          
ATOM    771  O   GLY   106       1.659   1.346  23.714  1.00 35.90          
ATOM    772  N   LEU   107       1.653   3.544  24.140  1.00 38.20          
ATOM    773  CA  LEU   107       2.685   3.791  23.151  1.00 39.43          
ATOM    774  C   LEU   107       3.891   2.894  23.389  1.00 39.89          
ATOM    775  O   LEU   107       4.174   2.017  22.579  1.00 41.10          
ATOM    776  CB  LEU   107       3.131   5.252  23.168  1.00 41.15          
ATOM    777  CG  LEU   107       2.421   6.254  22.244  1.00 41.69          
ATOM    778  CD1 LEU   107       2.941   7.651  22.577  1.00 42.07          
ATOM    779  CD2 LEU   107       2.684   5.922  20.777  1.00 41.61          
ATOM    780  N   TYR   108       4.583   3.096  24.509  1.00 39.43          
ATOM    781  CA  TYR   108       5.766   2.308  24.847  1.00 38.14          
ATOM    782  C   TYR   108       5.590   0.811  24.689  1.00 37.73          
ATOM    783  O   TYR   108       6.523   0.120  24.310  1.00 37.59          
ATOM    784  CB  TYR   108       6.209   2.586  26.283  1.00 40.80          
ATOM    785  CG  TYR   108       6.759   3.969  26.516  1.00 43.04          
ATOM    786  CD1 TYR   108       8.091   4.149  26.882  1.00 42.95          
ATOM    787  CD2 TYR   108       5.943   5.101  26.371  1.00 44.06          
ATOM    788  CE1 TYR   108       8.609   5.421  27.098  1.00 45.65          
ATOM    789  CE2 TYR   108       6.446   6.384  26.583  1.00 46.23          
ATOM    790  CZ  TYR   108       7.788   6.536  26.947  1.00 47.17          
ATOM    791  OH  TYR   108       8.307   7.800  27.154  1.00 48.96          
ATOM    792  N   ILE   109       4.403   0.303  24.987  1.00 38.17          
ATOM    793  CA  ILE   109       4.185  -1.120  24.881  1.00 39.47          
ATOM    794  C   ILE   109       3.935  -1.613  23.469  1.00 40.68          
ATOM    795  O   ILE   109       4.524  -2.605  23.053  1.00 42.01          
ATOM    796  CB  ILE   109       3.038  -1.567  25.781  1.00 39.28          
ATOM    797  CG1 ILE   109       3.376  -1.240  27.225  1.00 41.80          
ATOM    798  CG2 ILE   109       2.815  -3.062  25.646  1.00 39.71          
ATOM    799  CD  ILE   109       4.689  -1.861  27.711  1.00 43.04          
ATOM    800  N   GLN   110       3.070  -0.944  22.718  1.00 41.74          
ATOM    801  CA  GLN   110       2.827  -1.410  21.365  1.00 42.65          
ATOM    802  C   GLN   110       4.045  -1.161  20.478  1.00 42.85          
ATOM    803  O   GLN   110       4.395  -1.985  19.624  1.00 43.03          
ATOM    804  CB  GLN   110       1.574  -0.757  20.759  1.00 43.38          
ATOM    805  CG  GLN   110       1.751   0.625  20.174  1.00 43.67          
ATOM    806  CD  GLN   110       0.605   0.995  19.236  1.00 44.36          
ATOM    807  OE1 GLN   110       0.534   2.121  18.741  1.00 44.31          
ATOM    808  NE2 GLN   110      -0.294   0.039  18.983  1.00 43.98          
ATOM    809  N   SER   111       4.712  -0.038  20.695  1.00 42.96          
ATOM    810  CA  SER   111       5.890   0.292  19.900  1.00 43.29          
ATOM    811  C   SER   111       6.911  -0.835  20.019  1.00 43.63          
ATOM    812  O   SER   111       7.658  -1.120  19.081  1.00 43.24          
ATOM    813  CB  SER   111       6.490   1.620  20.382  1.00 41.83          
ATOM    814  OG  SER   111       5.519   2.653  20.359  1.00 38.04          
ATOM    815  N   LEU   112       6.910  -1.484  21.179  1.00 42.94          
ATOM    816  CA  LEU   112       7.820  -2.589  21.466  1.00 43.24          
ATOM    817  C   LEU   112       7.305  -3.932  20.984  1.00 42.84          
ATOM    818  O   LEU   112       8.084  -4.826  20.664  1.00 43.39          
ATOM    819  CB  LEU   112       8.073  -2.679  22.980  1.00 42.95          
ATOM    820  CG  LEU   112       8.738  -3.944  23.539  1.00 41.60          
ATOM    821  CD1 LEU   112      10.130  -4.145  22.941  1.00 40.14          
ATOM    822  CD2 LEU   112       8.806  -3.824  25.042  1.00 40.07          
ATOM    823  N   LEU   113       5.991  -4.079  20.943  1.00 42.94          
ATOM    824  CA  LEU   113       5.404  -5.342  20.529  1.00 43.87          
ATOM    825  C   LEU   113       5.256  -5.507  19.022  1.00 43.65          
ATOM    826  O   LEU   113       5.468  -6.595  18.492  1.00 43.18          
ATOM    827  CB  LEU   113       4.040  -5.520  21.201  1.00 44.22          
ATOM    828  CG  LEU   113       4.098  -5.537  22.733  1.00 45.40          
ATOM    829  CD1 LEU   113       2.696  -5.608  23.294  1.00 45.75          
ATOM    830  CD2 LEU   113       4.926  -6.726  23.201  1.00 45.87          
ATOM    831  N   TYR   114       4.929  -4.421  18.335  1.00 43.62          
ATOM    832  CA  TYR   114       4.706  -4.469  16.899  1.00 43.89          
ATOM    833  C   TYR   114       5.617  -3.561  16.106  1.00 45.49          
ATOM    834  O   TYR   114       5.993  -2.496  16.576  1.00 47.98          
ATOM    835  CB  TYR   114       3.260  -4.078  16.614  1.00 43.38          
ATOM    836  CG  TYR   114       2.270  -4.789  17.502  1.00 40.83          
ATOM    837  CD1 TYR   114       2.213  -6.172  17.514  1.00 39.48          
ATOM    838  CD2 TYR   114       1.400  -4.079  18.333  1.00 40.02          
ATOM    839  CE1 TYR   114       1.327  -6.844  18.322  1.00 40.57          
ATOM    840  CE2 TYR   114       0.495  -4.743  19.155  1.00 40.05          
ATOM    841  CZ  TYR   114       0.471  -6.140  19.138  1.00 40.06          
ATOM    842  OH  TYR   114      -0.394  -6.860  19.917  1.00 39.18          
ATOM    843  N   ASN   115       5.955  -3.974  14.892  1.00 47.91          
ATOM    844  CA  ASN   115       6.802  -3.165  14.034  1.00 49.56          
ATOM    845  C   ASN   115       6.010  -2.369  13.028  1.00 50.49          
ATOM    846  O   ASN   115       6.268  -2.476  11.836  1.00 50.90          
ATOM    847  CB  ASN   115       7.765  -4.042  13.268  1.00 49.54          
ATOM    848  CG  ASN   115       9.037  -4.256  13.998  1.00 51.39          
ATOM    849  OD1 ASN   115       9.954  -4.869  13.468  1.00 52.45          
ATOM    850  ND2 ASN   115       9.117  -3.749  15.233  1.00 52.07          
ATOM   1490  N   GLU   194       4.232  -8.569  14.796  1.00 47.75          
ATOM   1491  CA  GLU   194       4.617  -8.834  16.179  1.00 49.40          
ATOM   1492  C   GLU   194       6.024  -9.388  16.317  1.00 48.31          
ATOM   1493  O   GLU   194       6.399 -10.332  15.638  1.00 48.33          
ATOM   1494  CB  GLU   194       3.630  -9.789  16.843  1.00 51.42          
ATOM   1495  CG  GLU   194       3.490 -11.112  16.136  1.00 56.87          
ATOM   1496  CD  GLU   194       2.523 -12.042  16.848  1.00 60.08          
ATOM   1497  OE1 GLU   194       2.177 -13.105  16.267  1.00 61.22          
ATOM   1498  OE2 GLU   194       2.115 -11.713  17.992  1.00 60.95          
ATOM   1499  N   ASN   195       6.787  -8.798  17.226  1.00 46.51          
ATOM   1500  CA  ASN   195       8.143  -9.207  17.436  1.00 45.67          
ATOM   1501  C   ASN   195       8.302 -10.310  18.443  1.00 45.98          
ATOM   1502  O   ASN   195       9.308 -11.001  18.434  1.00 47.00          
ATOM   1503  CB  ASN   195       8.982  -8.016  17.860  1.00 47.07          
ATOM   1504  CG  ASN   195       8.897  -6.874  16.867  1.00 48.46          
ATOM   1505  OD1 ASN   195       8.841  -7.099  15.655  1.00 49.07          
ATOM   1506  ND2 ASN   195       8.880  -5.641  17.372  1.00 48.06          
ATOM   1507  N   TYR   196       7.326 -10.499  19.315  1.00 46.29          
ATOM   1508  CA  TYR   196       7.467 -11.540  20.317  1.00 47.17          
ATOM   1509  C   TYR   196       6.232 -12.389  20.522  1.00 47.82          
ATOM   1510  O   TYR   196       5.125 -12.002  20.152  1.00 47.37          
ATOM   1511  CB  TYR   196       7.860 -10.918  21.664  1.00 46.04          
ATOM   1512  CG  TYR   196       8.973  -9.899  21.584  1.00 45.49          
ATOM   1513  CD1 TYR   196       8.701  -8.549  21.361  1.00 44.85          
ATOM   1514  CD2 TYR   196      10.304 -10.286  21.742  1.00 45.74          
ATOM   1515  CE1 TYR   196       9.736  -7.609  21.307  1.00 44.31          
ATOM   1516  CE2 TYR   196      11.340  -9.361  21.684  1.00 43.91          
ATOM   1517  CZ  TYR   196      11.055  -8.032  21.471  1.00 43.56          
ATOM   1518  OH  TYR   196      12.099  -7.141  21.438  1.00 42.22          
ATOM   1519  N   ASP   197       6.451 -13.561  21.112  1.00 48.93          
ATOM   1520  CA  ASP   197       5.371 -14.486  21.452  1.00 50.31          
ATOM   1521  C   ASP   197       4.840 -13.955  22.786  1.00 50.43          
ATOM   1522  O   ASP   197       4.990 -14.599  23.832  1.00 51.08          
ATOM   1523  CB  ASP   197       5.918 -15.900  21.660  1.00 51.47          
ATOM   1524  CG  ASP   197       4.886 -16.831  22.266  1.00 53.27          
ATOM   1525  OD1 ASP   197       5.258 -17.893  22.809  1.00 53.86          
ATOM   1526  OD2 ASP   197       3.686 -16.493  22.203  1.00 55.59          
ATOM   1527  N   THR   198       4.213 -12.782  22.737  1.00 49.76          
ATOM   1528  CA  THR   198       3.713 -12.096  23.932  1.00 49.28          
ATOM   1529  C   THR   198       2.563 -12.709  24.722  1.00 47.06          
ATOM   1530  O   THR   198       1.661 -13.327  24.170  1.00 46.55          
ATOM   1531  CB  THR   198       3.316 -10.626  23.597  1.00 50.79          
ATOM   1532  OG1 THR   198       2.051 -10.612  22.924  1.00 52.00          
ATOM   1533  CG2 THR   198       4.370  -9.971  22.696  1.00 51.01          
ATOM   1534  N   LEU   199       2.632 -12.528  26.034  1.00 46.23          
ATOM   1535  CA  LEU   199       1.601 -12.991  26.946  1.00 45.60          
ATOM   1536  C   LEU   199       1.181 -11.716  27.675  1.00 44.21          
ATOM   1537  O   LEU   199       1.519 -11.500  28.833  1.00 44.85          
ATOM   1538  CB  LEU   199       2.165 -14.024  27.925  1.00 44.96          
ATOM   1539  CG  LEU   199       1.253 -14.518  29.057  1.00 44.18          
ATOM   1540  CD1 LEU   199      -0.198 -14.656  28.608  1.00 43.89          
ATOM   1541  CD2 LEU   199       1.800 -15.840  29.538  1.00 45.05          
ATOM   1542  N   LEU   200       0.460 -10.863  26.959  1.00 41.66          
ATOM   1543  CA  LEU   200       0.026  -9.582  27.478  1.00 40.53          
ATOM   1544  C   LEU   200      -1.114  -9.672  28.479  1.00 39.77          
ATOM   1545  O   LEU   200      -2.234 -10.034  28.127  1.00 37.94          
ATOM   1546  CB  LEU   200      -0.372  -8.688  26.310  1.00 40.26          
ATOM   1547  CG  LEU   200      -0.657  -7.221  26.580  1.00 41.39          
ATOM   1548  CD1 LEU   200       0.606  -6.499  27.040  1.00 40.32          
ATOM   1549  CD2 LEU   200      -1.184  -6.590  25.299  1.00 42.87          
ATOM   1550  N   ILE   201      -0.821  -9.338  29.732  1.00 39.53          
ATOM   1551  CA  ILE   201      -1.838  -9.382  30.775  1.00 41.00          
ATOM   1552  C   ILE   201      -1.965  -8.007  31.463  1.00 40.72          
ATOM   1553  O   ILE   201      -0.981  -7.287  31.653  1.00 39.19          
ATOM   1554  CB  ILE   201      -1.542 -10.523  31.829  1.00 40.54          
ATOM   1555  CG1 ILE   201      -0.531 -10.072  32.855  1.00 40.51          
ATOM   1556  CG2 ILE   201      -0.955 -11.744  31.155  1.00 40.02          
ATOM   1557  CD  ILE   201      -1.170  -9.597  34.101  1.00 41.99          
ATOM   1558  N   GLY   202      -3.196  -7.644  31.809  1.00 41.71          
ATOM   1559  CA  GLY   202      -3.450  -6.372  32.457  1.00 42.46          
ATOM   1560  C   GLY   202      -4.338  -6.522  33.676  1.00 43.59          
ATOM   1561  O   GLY   202      -5.207  -7.391  33.711  1.00 43.17          
ATOM   1562  N   ILE   203      -4.107  -5.686  34.684  1.00 45.16          
ATOM   1563  CA  ILE   203      -4.900  -5.716  35.906  1.00 46.85          
ATOM   1564  C   ILE   203      -5.963  -4.638  35.810  1.00 48.66          
ATOM   1565  O   ILE   203      -5.655  -3.452  35.710  1.00 48.68          
ATOM   1566  CB  ILE   203      -4.041  -5.445  37.133  1.00 45.94          
ATOM   1567  CG1 ILE   203      -2.866  -6.419  37.179  1.00 46.14          
ATOM   1568  CG2 ILE   203      -4.882  -5.594  38.376  1.00 46.19          
ATOM   1569  CD  ILE   203      -1.912  -6.143  38.319  1.00 45.78          
ATOM   1570  N   GLU   204      -7.216  -5.058  35.849  1.00 51.48          
ATOM   1571  CA  GLU   204      -8.332  -4.138  35.715  1.00 55.82          
ATOM   1572  C   GLU   204      -9.114  -3.943  37.015  1.00 56.85          
ATOM   1573  O   GLU   204      -8.898  -4.644  37.995  1.00 56.30          
ATOM   1574  CB  GLU   204      -9.269  -4.675  34.637  1.00 59.26          
ATOM   1575  CG  GLU   204     -10.412  -3.758  34.261  1.00 64.70          
ATOM   1576  CD  GLU   204     -11.575  -4.512  33.653  1.00 67.29          
ATOM   1577  OE1 GLU   204     -12.163  -5.358  34.370  1.00 69.22          
ATOM   1578  OE2 GLU   204     -11.889  -4.257  32.466  1.00 68.13          
ATOM   1579  N   MET   205     -10.035  -2.988  37.010  1.00 58.68          
ATOM   1580  CA  MET   205     -10.855  -2.725  38.174  1.00 61.00          
ATOM   1581  C   MET   205     -11.885  -1.669  37.811  1.00 59.37          
ATOM   1582  O   MET   205     -11.719  -0.954  36.826  1.00 58.70          
ATOM   1583  CB  MET   205      -9.978  -2.261  39.332  1.00 66.33          
ATOM   1584  CG  MET   205      -9.104  -1.084  38.972  1.00 74.24          
ATOM   1585  SD  MET   205      -7.625  -0.835  40.201  1.00 86.23          
ATOM   1586  CE  MET   205      -8.641  -0.116  41.686  1.00 83.03          
ATOM   1587  N   SER   206     -12.954  -1.581  38.598  1.00 57.85          
ATOM   1588  CA  SER   206     -14.017  -0.622  38.331  1.00 57.29          
ATOM   1589  C   SER   206     -13.525   0.799  38.510  1.00 57.42          
ATOM   1590  O   SER   206     -12.622   1.049  39.304  1.00 57.34          
ATOM   1591  CB  SER   206     -15.212  -0.875  39.253  1.00 58.20          
ATOM   1592  OG  SER   206     -14.949  -0.485  40.595  1.00 58.30          
ATOM   1593  N   ARG   207     -14.121   1.732  37.774  1.00 57.81          
ATOM   1594  CA  ARG   207     -13.720   3.130  37.862  1.00 57.90          
ATOM   1595  C   ARG   207     -13.876   3.620  39.294  1.00 57.25          
ATOM   1596  O   ARG   207     -13.126   4.486  39.747  1.00 57.38          
ATOM   1597  CB  ARG   207     -14.567   4.018  36.933  1.00 59.77          
ATOM   1598  CG  ARG   207     -13.797   5.238  36.402  1.00 61.95          
ATOM   1599  CD  ARG   207     -14.603   6.536  36.316  1.00 63.77          
ATOM   1600  NE  ARG   207     -15.787   6.495  35.515  1.00 65.96          
ATOM   1601  CZ  ARG   207     -16.987   7.059  35.671  1.00 66.23          
ATOM   1602  NH1 ARG   207     -17.834   6.800  34.702  1.00 66.18          
ATOM   1603  NH2 ARG   207     -17.386   7.808  36.700  1.00 64.90          
ATOM   1604  N   GLU   208     -14.856   3.069  40.004  1.00 56.65          
ATOM   1605  CA  GLU   208     -15.097   3.463  41.387  1.00 56.14          
ATOM   1606  C   GLU   208     -13.862   3.162  42.237  1.00 55.10          
ATOM   1607  O   GLU   208     -13.262   4.069  42.819  1.00 54.75          
ATOM   1608  CB  GLU   208     -16.300   2.709  41.977  1.00 56.67          
ATOM   1609  CG  GLU   208     -17.676   2.979  41.343  1.00 57.91          
ATOM   1610  CD  GLU   208     -18.003   2.049  40.169  1.00 58.56          
ATOM   1611  OE1 GLU   208     -17.721   2.435  39.013  1.00 58.35          
ATOM   1612  OE2 GLU   208     -18.530   0.931  40.407  1.00 57.29          
ATOM   1613  N   THR   209     -13.490   1.883  42.301  1.00 54.16          
ATOM   1614  CA  THR   209     -12.340   1.456  43.092  1.00 53.60          
ATOM   1615  C   THR   209     -11.061   2.129  42.604  1.00 53.06          
ATOM   1616  O   THR   209     -10.239   2.571  43.400  1.00 52.72          
ATOM   1617  CB  THR   209     -12.153  -0.092  43.046  1.00 52.87          
ATOM   1618  OG1 THR   209     -13.366  -0.746  43.439  1.00 51.02          
ATOM   1619  CG2 THR   209     -11.043  -0.527  43.995  1.00 52.66          
ATOM   1620  N   LEU   210     -10.901   2.203  41.291  1.00 52.94          
ATOM   1621  CA  LEU   210      -9.730   2.828  40.703  1.00 52.98          
ATOM   1622  C   LEU   210      -9.528   4.235  41.261  1.00 52.71          
ATOM   1623  O   LEU   210      -8.509   4.528  41.891  1.00 52.92          
ATOM   1624  CB  LEU   210      -9.889   2.903  39.180  1.00 54.27          
ATOM   1625  CG  LEU   210      -8.820   3.668  38.374  1.00 54.83          
ATOM   1626  CD1 LEU   210      -7.497   2.944  38.513  1.00 56.79          
ATOM   1627  CD2 LEU   210      -9.212   3.773  36.904  1.00 53.90          
ATOM   1628  N   TYR   211     -10.512   5.097  41.028  1.00 52.09          
ATOM   1629  CA  TYR   211     -10.454   6.482  41.481  1.00 52.39          
ATOM   1630  C   TYR   211     -10.234   6.630  42.979  1.00 51.09          
ATOM   1631  O   TYR   211      -9.549   7.548  43.435  1.00 50.28          
ATOM   1632  CB  TYR   211     -11.728   7.237  41.061  1.00 54.07          
ATOM   1633  CG  TYR   211     -11.758   7.638  39.596  1.00 56.55          
ATOM   1634  CD1 TYR   211     -12.669   8.581  39.128  1.00 57.92          
ATOM   1635  CD2 TYR   211     -10.858   7.092  38.684  1.00 57.95          
ATOM   1636  CE1 TYR   211     -12.681   8.975  37.789  1.00 59.13          
ATOM   1637  CE2 TYR   211     -10.859   7.474  37.347  1.00 59.28          
ATOM   1638  CZ  TYR   211     -11.772   8.419  36.907  1.00 60.34          
ATOM   1639  OH  TYR   211     -11.763   8.810  35.586  1.00 61.94          
ATOM   1640  N   LEU   212     -10.808   5.721  43.748  1.00 50.37          
ATOM   1641  CA  LEU   212     -10.654   5.778  45.187  1.00 49.40          
ATOM   1642  C   LEU   212      -9.215   5.448  45.593  1.00 48.18          
ATOM   1643  O   LEU   212      -8.628   6.134  46.430  1.00 47.77          
ATOM   1644  CB  LEU   212     -11.630   4.805  45.834  1.00 50.41          
ATOM   1645  CG  LEU   212     -11.704   4.886  47.349  1.00 51.44          
ATOM   1646  CD1 LEU   212     -12.122   6.288  47.772  1.00 51.12          
ATOM   1647  CD2 LEU   212     -12.696   3.850  47.841  1.00 52.30          
ATOM   1648  N   ARG   213      -8.648   4.411  44.982  1.00 47.23          
ATOM   1649  CA  ARG   213      -7.288   3.993  45.291  1.00 45.81          
ATOM   1650  C   ARG   213      -6.283   5.054  44.893  1.00 45.00          
ATOM   1651  O   ARG   213      -5.316   5.301  45.618  1.00 45.34          
ATOM   1652  CB  ARG   213      -6.953   2.680  44.589  1.00 46.12          
ATOM   1653  CG  ARG   213      -7.893   1.561  44.947  1.00 47.50          
ATOM   1654  CD  ARG   213      -7.285   0.226  44.633  1.00 49.26          
ATOM   1655  NE  ARG   213      -6.204  -0.149  45.481  1.00 50.85          
ATOM   1656  CZ  ARG   213      -4.999  -0.646  45.219  1.00 52.07          
ATOM   1657  NH1 ARG   213      -4.277  -0.882  46.291  1.00 51.27          
ATOM   1658  NH2 ARG   213      -4.484  -0.876  44.015  1.00 52.18          
ATOM   1659  N   ILE   214      -6.505   5.677  43.740  1.00 42.90          
ATOM   1660  CA  ILE   214      -5.607   6.723  43.284  1.00 42.58          
ATOM   1661  C   ILE   214      -5.609   7.858  44.301  1.00 44.04          
ATOM   1662  O   ILE   214      -4.549   8.290  44.754  1.00 44.37          
ATOM   1663  CB  ILE   214      -6.015   7.257  41.894  1.00 42.38          
ATOM   1664  CG1 ILE   214      -5.905   6.130  40.856  1.00 41.56          
ATOM   1665  CG2 ILE   214      -5.131   8.432  41.499  1.00 40.53          
ATOM   1666  CD  ILE   214      -6.409   6.490  39.488  1.00 40.18          
ATOM   1667  N   ASN   215      -6.780   8.339  44.694  1.00 44.37          
ATOM   1668  CA  ASN   215      -6.782   9.402  45.689  1.00 46.12          
ATOM   1669  C   ASN   215      -5.987   8.978  46.906  1.00 45.68          
ATOM   1670  O   ASN   215      -5.266   9.777  47.492  1.00 45.52          
ATOM   1671  CB  ASN   215      -8.198   9.764  46.118  1.00 47.65          
ATOM   1672  CG  ASN   215      -9.003  10.321  44.984  1.00 49.26          
ATOM   1673  OD1 ASN   215      -8.501  11.116  44.187  1.00 50.48          
ATOM   1674  ND2 ASN   215     -10.263   9.922  44.902  1.00 50.51          
ATOM   1675  N   LYS   216      -6.107   7.711  47.274  1.00 45.88          
ATOM   1676  CA  LYS   216      -5.394   7.213  48.435  1.00 46.84          
ATOM   1677  C   LYS   216      -3.888   7.081  48.215  1.00 46.74          
ATOM   1678  O   LYS   216      -3.116   7.192  49.158  1.00 46.10          
ATOM   1679  CB  LYS   216      -5.984   5.876  48.880  1.00 48.06          
ATOM   1680  CG  LYS   216      -5.384   5.354  50.172  1.00 51.11          
ATOM   1681  CD  LYS   216      -6.408   4.614  51.040  1.00 52.88          
ATOM   1682  CE  LYS   216      -5.802   4.179  52.382  1.00 52.11          
ATOM   1683  NZ  LYS   216      -6.811   3.570  53.287  1.00 51.76          
ATOM   1684  N   ARG   217      -3.464   6.859  46.978  1.00 47.09          
ATOM   1685  CA  ARG   217      -2.040   6.725  46.708  1.00 47.24          
ATOM   1686  C   ARG   217      -1.372   8.088  46.677  1.00 46.13          
ATOM   1687  O   ARG   217      -0.179   8.219  46.959  1.00 46.25          
ATOM   1688  CB  ARG   217      -1.820   6.000  45.388  1.00 48.37          
ATOM   1689  CG  ARG   217      -0.383   5.876  44.976  1.00 50.40          
ATOM   1690  CD  ARG   217      -0.312   5.084  43.691  1.00 55.04          
ATOM   1691  NE  ARG   217      -1.153   5.631  42.611  1.00 58.04          
ATOM   1692  CZ  ARG   217      -0.829   6.677  41.851  1.00 58.71          
ATOM   1693  NH1 ARG   217      -1.659   7.091  40.896  1.00 58.58          
ATOM   1694  NH2 ARG   217       0.322   7.310  42.050  1.00 58.89          
ATOM   1695  N   VAL   218      -2.145   9.108  46.333  1.00 46.00          
ATOM   1696  CA  VAL   218      -1.609  10.455  46.284  1.00 46.08          
ATOM   1697  C   VAL   218      -1.417  10.905  47.725  1.00 47.54          
ATOM   1698  O   VAL   218      -0.449  11.586  48.042  1.00 46.77          
ATOM   1699  CB  VAL   218      -2.564  11.419  45.510  1.00 44.61          
ATOM   1700  CG1 VAL   218      -2.020  12.835  45.537  1.00 44.97          
ATOM   1701  CG2 VAL   218      -2.703  10.968  44.068  1.00 41.49          
ATOM   1702  N   ASP   219      -2.329  10.501  48.608  1.00 49.53          
ATOM   1703  CA  ASP   219      -2.219  10.875  50.019  1.00 50.83          
ATOM   1704  C   ASP   219      -0.959  10.273  50.608  1.00 51.42          
ATOM   1705  O   ASP   219      -0.230  10.942  51.334  1.00 52.60          
ATOM   1706  CB  ASP   219      -3.429  10.395  50.829  1.00 51.95          
ATOM   1707  CG  ASP   219      -4.704  11.146  50.482  1.00 54.27          
ATOM   1708  OD1 ASP   219      -4.604  12.292  49.978  1.00 54.93          
ATOM   1709  OD2 ASP   219      -5.813  10.598  50.730  1.00 54.88          
ATOM   1710  N   ILE   220      -0.704   9.007  50.298  1.00 50.93          
ATOM   1711  CA  ILE   220       0.475   8.335  50.820  1.00 50.35          
ATOM   1712  C   ILE   220       1.763   8.987  50.330  1.00 50.83          
ATOM   1713  O   ILE   220       2.692   9.191  51.107  1.00 49.12          
ATOM   1714  CB  ILE   220       0.489   6.861  50.422  1.00 50.25          
ATOM   1715  CG1 ILE   220      -0.829   6.199  50.819  1.00 49.65          
ATOM   1716  CG2 ILE   220       1.650   6.162  51.101  1.00 49.47          
ATOM   1717  CD  ILE   220      -0.965   4.771  50.337  1.00 48.90          
ATOM   1718  N   MET   221       1.819   9.308  49.040  1.00 52.75          
ATOM   1719  CA  MET   221       3.011   9.936  48.478  1.00 54.09          
ATOM   1720  C   MET   221       3.341  11.226  49.222  1.00 53.07          
ATOM   1721  O   MET   221       4.496  11.462  49.582  1.00 53.63          
ATOM   1722  CB  MET   221       2.829  10.262  46.996  1.00 57.37          
ATOM   1723  CG  MET   221       2.482   9.089  46.099  1.00 61.31          
ATOM   1724  SD  MET   221       2.805   9.516  44.215  1.00 68.30          
ATOM   1725  CE  MET   221       1.657  11.071  43.994  1.00 66.79          
ATOM   1726  N   LEU   222       2.329  12.066  49.435  1.00 51.20          
ATOM   1727  CA  LEU   222       2.529  13.324  50.144  1.00 48.78          
ATOM   1728  C   LEU   222       3.049  12.992  51.524  1.00 47.82          
ATOM   1729  O   LEU   222       3.943  13.657  52.041  1.00 46.99          
ATOM   1730  CB  LEU   222       1.211  14.101  50.261  1.00 47.68          
ATOM   1731  CG  LEU   222       0.761  14.988  49.091  1.00 47.08          
ATOM   1732  CD1 LEU   222       1.733  16.140  48.895  1.00 47.95          
ATOM   1733  CD2 LEU   222       0.673  14.168  47.838  1.00 47.74          
ATOM   1734  N   GLY   223       2.490  11.934  52.102  1.00 47.54          
ATOM   1735  CA  GLY   223       2.885  11.507  53.429  1.00 46.72          
ATOM   1736  C   GLY   223       4.254  10.872  53.473  1.00 47.26          
ATOM   1737  O   GLY   223       4.836  10.750  54.540  1.00 46.92          
ATOM   1738  N   HSD   224       4.783  10.465  52.326  1.00 48.55          
ATOM   1739  CA  HSD   224       6.096   9.847  52.324  1.00 49.09          
ATOM   1740  C   HSD   224       7.240  10.792  51.959  1.00 49.59          
ATOM   1741  O   HSD   224       8.401  10.389  51.959  1.00 50.22          
ATOM   1742  CB  HSD   224       6.102   8.628  51.408  1.00 50.46          
ATOM   1743  CG  HSD   224       5.612   7.376  52.070  1.00 52.48          
ATOM   1744  ND1 HSD   224       5.705   6.134  51.476  1.00 53.25          
ATOM   1745  CD2 HSD   224       5.035   7.170  53.278  1.00 52.96          
ATOM   1746  CE1 HSD   224       5.207   5.219  52.288  1.00 52.93          
ATOM   1747  NE2 HSD   224       4.793   5.821  53.389  1.00 53.58          
ATOM   1748  N   GLY   225       6.922  12.046  51.652  1.00 48.30          
ATOM   1749  CA  GLY   225       7.965  12.995  51.318  1.00 48.19          
ATOM   1750  C   GLY   225       8.060  13.385  49.858  1.00 48.65          
ATOM   1751  O   GLY   225       9.127  13.797  49.398  1.00 48.46          
ATOM   1752  N   LEU   226       6.955  13.245  49.126  1.00 49.00          
ATOM   1753  CA  LEU   226       6.908  13.607  47.703  1.00 48.60          
ATOM   1754  C   LEU   226       7.306  15.064  47.518  1.00 48.18          
ATOM   1755  O   LEU   226       8.145  15.389  46.681  1.00 47.55          
ATOM   1756  CB  LEU   226       5.495  13.408  47.131  1.00 46.67          
ATOM   1757  CG  LEU   226       5.224  14.068  45.771  1.00 46.21          
ATOM   1758  CD1 LEU   226       6.161  13.498  44.722  1.00 44.40          
ATOM   1759  CD2 LEU   226       3.772  13.858  45.362  1.00 45.96          
ATOM   1760  N   PHE   227       6.690  15.939  48.303  1.00 48.68          
ATOM   1761  CA  PHE   227       6.985  17.353  48.209  1.00 49.66          
ATOM   1762  C   PHE   227       8.466  17.600  48.501  1.00 50.70          
ATOM   1763  O   PHE   227       9.099  18.414  47.833  1.00 51.23          
ATOM   1764  CB  PHE   227       6.100  18.141  49.178  1.00 49.58          
ATOM   1765  CG  PHE   227       6.176  19.632  49.000  1.00 49.04          
ATOM   1766  CD1 PHE   227       7.235  20.359  49.538  1.00 49.30          
ATOM   1767  CD2 PHE   227       5.205  20.306  48.266  1.00 49.29          
ATOM   1768  CE1 PHE   227       7.327  21.743  49.355  1.00 49.51          
ATOM   1769  CE2 PHE   227       5.285  21.687  48.077  1.00 49.75          
ATOM   1770  CZ  PHE   227       6.354  22.409  48.620  1.00 49.71          
ATOM   1771  N   ASN   228       9.027  16.894  49.480  1.00 50.89          
ATOM   1772  CA  ASN   228      10.435  17.082  49.808  1.00 51.21          
ATOM   1773  C   ASN   228      11.299  16.702  48.605  1.00 51.40          
ATOM   1774  O   ASN   228      12.339  17.312  48.347  1.00 50.59          
ATOM   1775  CB  ASN   228      10.834  16.227  51.009  1.00 52.09          
ATOM   1776  CG  ASN   228      12.219  16.566  51.521  1.00 53.59          
ATOM   1777  OD1 ASN   228      12.820  15.809  52.281  1.00 54.96          
ATOM   1778  ND2 ASN   228      12.733  17.718  51.109  1.00 55.01          
ATOM   1779  N   GLU   229      10.853  15.695  47.866  1.00 51.04          
ATOM   1780  CA  GLU   229      11.586  15.244  46.706  1.00 51.72          
ATOM   1781  C   GLU   229      11.588  16.311  45.614  1.00 52.23          
ATOM   1782  O   GLU   229      12.655  16.693  45.128  1.00 53.72          
ATOM   1783  CB  GLU   229      10.979  13.954  46.175  1.00 52.05          
ATOM   1784  CG  GLU   229      11.899  13.129  45.301  1.00 52.84          
ATOM   1785  CD  GLU   229      11.213  11.880  44.807  1.00 53.57          
ATOM   1786  OE1 GLU   229      10.385  11.998  43.877  1.00 54.71          
ATOM   1787  OE2 GLU   229      11.478  10.787  45.357  1.00 52.14          
ATOM   1788  N   VAL   230      10.411  16.805  45.229  1.00 51.22          
ATOM   1789  CA  VAL   230      10.349  17.821  44.184  1.00 50.77          
ATOM   1790  C   VAL   230      11.131  19.055  44.597  1.00 50.92          
ATOM   1791  O   VAL   230      11.509  19.868  43.758  1.00 50.86          
ATOM   1792  CB  VAL   230       8.906  18.250  43.857  1.00 49.81          
ATOM   1793  CG1 VAL   230       8.028  17.040  43.649  1.00 50.73          
ATOM   1794  CG2 VAL   230       8.371  19.127  44.939  1.00 51.11          
ATOM   1795  N   GLN   231      11.382  19.188  45.894  1.00 51.90          
ATOM   1796  CA  GLN   231      12.138  20.326  46.401  1.00 52.73          
ATOM   1797  C   GLN   231      13.605  20.151  46.074  1.00 52.44          
ATOM   1798  O   GLN   231      14.255  21.086  45.636  1.00 52.48          
ATOM   1799  CB  GLN   231      11.968  20.457  47.914  1.00 53.42          
ATOM   1800  CG  GLN   231      10.643  21.061  48.363  1.00 53.33          
ATOM   1801  CD  GLN   231      10.629  21.347  49.861  1.00 53.59          
ATOM   1802  OE1 GLN   231      10.758  20.433  50.678  1.00 52.65          
ATOM   1803  NE2 GLN   231      10.476  22.620  50.225  1.00 53.06          
ATOM   1804  N   HSD   232      14.119  18.949  46.296  1.00 52.83          
ATOM   1805  CA  HSD   232      15.516  18.668  46.014  1.00 54.59          
ATOM   1806  C   HSD   232      15.772  18.771  44.522  1.00 54.60          
ATOM   1807  O   HSD   232      16.822  19.255  44.092  1.00 55.63          
ATOM   1808  CB  HSD   232      15.883  17.271  46.496  1.00 57.52          
ATOM   1809  CG  HSD   232      15.827  17.112  47.986  1.00 61.50          
ATOM   1810  ND1 HSD   232      15.522  15.912  48.596  1.00 62.41          
ATOM   1811  CD2 HSD   232      16.055  17.995  48.991  1.00 62.97          
ATOM   1812  CE1 HSD   232      15.564  16.062  49.910  1.00 63.57          
ATOM   1813  NE2 HSD   232      15.886  17.316  50.176  1.00 63.76          
ATOM   1814  N   LEU   233      14.814  18.311  43.724  1.00 54.34          
ATOM   1815  CA  LEU   233      14.948  18.351  42.267  1.00 53.56          
ATOM   1816  C   LEU   233      14.915  19.773  41.744  1.00 53.10          
ATOM   1817  O   LEU   233      15.781  20.168  40.973  1.00 53.07          
ATOM   1818  CB  LEU   233      13.830  17.547  41.616  1.00 53.05          
ATOM   1819  CG  LEU   233      13.928  16.035  41.776  1.00 53.98          
ATOM   1820  CD1 LEU   233      12.601  15.396  41.410  1.00 54.57          
ATOM   1821  CD2 LEU   233      15.049  15.502  40.893  1.00 53.99          
ATOM   1822  N   VAL   234      13.908  20.533  42.160  1.00 53.72          
ATOM   1823  CA  VAL   234      13.772  21.911  41.720  1.00 54.50          
ATOM   1824  C   VAL   234      14.955  22.759  42.197  1.00 55.31          
ATOM   1825  O   VAL   234      15.336  23.719  41.538  1.00 55.74          
ATOM   1826  CB  VAL   234      12.433  22.518  42.204  1.00 53.90          
ATOM   1827  CG1 VAL   234      12.458  22.698  43.704  1.00 56.91          
ATOM   1828  CG2 VAL   234      12.178  23.828  41.514  1.00 54.67          
ATOM   1829  N   GLU   235      15.539  22.398  43.334  1.00 56.55          
ATOM   1830  CA  GLU   235      16.690  23.125  43.862  1.00 58.23          
ATOM   1831  C   GLU   235      17.933  22.818  43.029  1.00 58.14          
ATOM   1832  O   GLU   235      18.782  23.685  42.822  1.00 58.69          
ATOM   1833  CB  GLU   235      16.941  22.758  45.333  1.00 60.13          
ATOM   1834  CG  GLU   235      16.176  23.627  46.343  1.00 63.27          
ATOM   1835  CD  GLU   235      16.297  23.141  47.793  1.00 65.19          
ATOM   1836  OE1 GLU   235      15.981  23.935  48.716  1.00 64.07          
ATOM   1837  OE2 GLU   235      16.690  21.967  48.007  1.00 66.28          
ATOM   1838  N   GLN   236      18.039  21.584  42.548  1.00 57.92          
ATOM   1839  CA  GLN   236      19.172  21.193  41.718  1.00 58.19          
ATOM   1840  C   GLN   236      19.008  21.716  40.289  1.00 58.15          
ATOM   1841  O   GLN   236      19.696  21.276  39.366  1.00 58.41          
ATOM   1842  CB  GLN   236      19.319  19.675  41.714  1.00 57.21          
ATOM   1843  CG  GLN   236      19.913  19.154  42.992  1.00 59.59          
ATOM   1844  CD  GLN   236      19.697  17.669  43.162  1.00 62.56          
ATOM   1845  OE1 GLN   236      18.555  17.205  43.234  1.00 64.35          
ATOM   1846  NE2 GLN   236      20.791  16.909  43.237  1.00 62.86          
ATOM   1847  N   GLY   237      18.081  22.656  40.120  1.00 57.82          
ATOM   1848  CA  GLY   237      17.834  23.252  38.823  1.00 55.54          
ATOM   1849  C   GLY   237      17.242  22.339  37.777  1.00 55.47          
ATOM   1850  O   GLY   237      17.083  22.752  36.627  1.00 55.87          
ATOM   1851  N   PHE   238      16.909  21.108  38.150  1.00 54.70          
ATOM   1852  CA  PHE   238      16.333  20.175  37.186  1.00 54.43          
ATOM   1853  C   PHE   238      14.965  20.597  36.686  1.00 54.15          
ATOM   1854  O   PHE   238      14.288  19.833  36.016  1.00 54.72          
ATOM   1855  CB  PHE   238      16.248  18.776  37.778  1.00 55.06          
ATOM   1856  CG  PHE   238      17.564  18.088  37.871  1.00 55.44          
ATOM   1857  CD1 PHE   238      18.398  18.015  36.769  1.00 55.52          
ATOM   1858  CD2 PHE   238      17.956  17.473  39.050  1.00 57.40          
ATOM   1859  CE1 PHE   238      19.610  17.327  36.837  1.00 56.79          
ATOM   1860  CE2 PHE   238      19.170  16.778  39.135  1.00 58.19          
ATOM   1861  CZ  PHE   238      19.997  16.706  38.026  1.00 57.47          
ATOM   1862  N   GLU   239      14.561  21.814  37.019  1.00 54.78          
ATOM   1863  CA  GLU   239      13.286  22.357  36.580  1.00 55.30          
ATOM   1864  C   GLU   239      13.415  22.627  35.071  1.00 55.95          
ATOM   1865  O   GLU   239      14.525  22.618  34.540  1.00 56.90          
ATOM   1866  CB  GLU   239      13.040  23.654  37.338  1.00 56.17          
ATOM   1867  CG  GLU   239      11.688  24.276  37.127  1.00 58.62          
ATOM   1868  CD  GLU   239      11.557  25.627  37.821  1.00 60.91          
ATOM   1869  OE1 GLU   239      12.351  25.889  38.762  1.00 59.94          
ATOM   1870  OE2 GLU   239      10.650  26.411  37.436  1.00 60.79          
ATOM   1871  N   ALA   240      12.301  22.865  34.384  1.00 54.47          
ATOM   1872  CA  ALA   240      12.335  23.137  32.950  1.00 53.29          
ATOM   1873  C   ALA   240      12.608  21.881  32.109  1.00 52.86          
ATOM   1874  O   ALA   240      12.584  21.917  30.869  1.00 51.49          
ATOM   1875  CB  ALA   240      13.383  24.219  32.646  1.00 51.46          
ATOM   1876  N   SER   241      12.863  20.770  32.795  1.00 52.63          
ATOM   1877  CA  SER   241      13.141  19.487  32.150  1.00 52.57          
ATOM   1878  C   SER   241      11.859  18.723  31.846  1.00 52.68          
ATOM   1879  O   SER   241      10.835  18.927  32.496  1.00 53.04          
ATOM   1880  CB  SER   241      14.023  18.630  33.060  1.00 51.54          
ATOM   1881  OG  SER   241      15.177  19.335  33.450  1.00 50.84          
ATOM   1882  N   GLN   242      11.921  17.833  30.867  1.00 53.10          
ATOM   1883  CA  GLN   242      10.756  17.044  30.494  1.00 53.88          
ATOM   1884  C   GLN   242      10.242  16.263  31.687  1.00 54.11          
ATOM   1885  O   GLN   242       9.048  16.248  31.968  1.00 54.86          
ATOM   1886  CB  GLN   242      11.121  16.079  29.365  1.00 55.50          
ATOM   1887  CG  GLN   242      10.373  14.752  29.387  1.00 56.34          
ATOM   1888  CD  GLN   242      10.874  13.787  28.333  1.00 56.34          
ATOM   1889  OE1 GLN   242      12.054  13.449  28.295  1.00 56.46          
ATOM   1890  NE2 GLN   242       9.975  13.343  27.465  1.00 57.42          
ATOM   1891  N   SER   243      11.153  15.610  32.394  1.00 54.24          
ATOM   1892  CA  SER   243      10.773  14.819  33.554  1.00 53.83          
ATOM   1893  C   SER   243       9.962  15.619  34.578  1.00 54.07          
ATOM   1894  O   SER   243       8.988  15.111  35.121  1.00 53.71          
ATOM   1895  CB  SER   243      12.025  14.264  34.206  1.00 53.39          
ATOM   1896  OG  SER   243      12.933  15.318  34.435  1.00 54.65          
ATOM   1897  N   MET   244      10.358  16.866  34.835  1.00 54.91          
ATOM   1898  CA  MET   244       9.664  17.713  35.810  1.00 55.19          
ATOM   1899  C   MET   244       8.284  18.155  35.370  1.00 53.27          
ATOM   1900  O   MET   244       7.635  18.944  36.058  1.00 52.57          
ATOM   1901  CB  MET   244      10.485  18.962  36.112  1.00 60.45          
ATOM   1902  CG  MET   244      11.764  18.715  36.878  1.00 66.90          
ATOM   1903  SD  MET   244      11.481  18.227  38.722  1.00 76.91          
ATOM   1904  CE  MET   244      11.439  19.994  39.505  1.00 74.29          
ATOM   1905  N   GLN   245       7.845  17.657  34.218  1.00 52.02          
ATOM   1906  CA  GLN   245       6.538  18.002  33.662  1.00 50.21          
ATOM   1907  C   GLN   245       5.555  16.882  33.851  1.00 49.21          
ATOM   1908  O   GLN   245       4.385  17.019  33.509  1.00 49.73          
ATOM   1909  CB  GLN   245       6.667  18.312  32.173  1.00 49.10          
ATOM   1910  CG  GLN   245       7.278  19.652  31.894  1.00 48.85          
ATOM   1911  CD  GLN   245       6.407  20.759  32.420  1.00 49.81          
ATOM   1912  OE1 GLN   245       5.255  20.891  32.015  1.00 51.70          
ATOM   1913  NE2 GLN   245       6.944  21.564  33.330  1.00 50.84          
ATOM   1914  N   ALA   246       6.041  15.767  34.383  1.00 49.21          
ATOM   1915  CA  ALA   246       5.190  14.602  34.612  1.00 49.16          
ATOM   1916  C   ALA   246       4.235  14.858  35.766  1.00 48.33          
ATOM   1917  O   ALA   246       4.560  15.586  36.709  1.00 47.49          
ATOM   1918  CB  ALA   246       6.041  13.373  34.907  1.00 48.23          
ATOM   1919  N   ILE   247       3.053  14.257  35.684  1.00 47.65          
ATOM   1920  CA  ILE   247       2.060  14.423  36.725  1.00 46.43          
ATOM   1921  C   ILE   247       2.682  14.001  38.062  1.00 45.24          
ATOM   1922  O   ILE   247       3.232  12.906  38.193  1.00 43.81          
ATOM   1923  CB  ILE   247       0.783  13.592  36.405  1.00 46.72          
ATOM   1924  CG1 ILE   247       0.287  12.915  37.681  1.00 47.64          
ATOM   1925  CG2 ILE   247       1.049  12.611  35.247  1.00 46.66          
ATOM   1926  CD  ILE   247      -0.708  11.809  37.439  1.00 50.82          
ATOM   1927  N   GLY   248       2.611  14.896  39.040  1.00 44.32          
ATOM   1928  CA  GLY   248       3.194  14.618  40.338  1.00 44.63          
ATOM   1929  C   GLY   248       4.406  15.502  40.631  1.00 43.81          
ATOM   1930  O   GLY   248       4.998  15.439  41.706  1.00 43.85          
ATOM   1931  N   TYR   249       4.786  16.326  39.668  1.00 43.00          
ATOM   1932  CA  TYR   249       5.906  17.209  39.852  1.00 42.47          
ATOM   1933  C   TYR   249       5.543  18.571  39.321  1.00 44.75          
ATOM   1934  O   TYR   249       5.803  19.581  39.971  1.00 46.97          
ATOM   1935  CB  TYR   249       7.158  16.700  39.130  1.00 39.81          
ATOM   1936  CG  TYR   249       7.706  15.406  39.667  1.00 36.35          
ATOM   1937  CD1 TYR   249       7.136  14.201  39.319  1.00 35.98          
ATOM   1938  CD2 TYR   249       8.783  15.392  40.535  1.00 34.84          
ATOM   1939  CE1 TYR   249       7.625  13.006  39.818  1.00 36.42          
ATOM   1940  CE2 TYR   249       9.283  14.202  41.043  1.00 35.06          
ATOM   1941  CZ  TYR   249       8.700  13.011  40.676  1.00 35.44          
ATOM   1942  OH  TYR   249       9.197  11.819  41.146  1.00 35.17          
ATOM   1943  N   LYS   250       4.931  18.609  38.142  1.00 45.83          
ATOM   1944  CA  LYS   250       4.546  19.883  37.540  1.00 46.38          
ATOM   1945  C   LYS   250       3.497  20.619  38.381  1.00 46.13          
ATOM   1946  O   LYS   250       3.433  21.845  38.349  1.00 47.15          
ATOM   1947  CB  LYS   250       4.017  19.679  36.108  1.00 47.06          
ATOM   1948  CG  LYS   250       2.721  18.900  36.022  1.00 48.18          
ATOM   1949  CD  LYS   250       2.125  18.891  34.618  1.00 47.37          
ATOM   1950  CE  LYS   250       0.813  18.109  34.616  1.00 47.67          
ATOM   1951  NZ  LYS   250       0.166  18.049  33.283  1.00 48.34          
ATOM   1952  N   GLU   251       2.692  19.882  39.145  1.00 45.84          
ATOM   1953  CA  GLU   251       1.669  20.512  39.974  1.00 45.20          
ATOM   1954  C   GLU   251       2.257  21.083  41.245  1.00 43.71          
ATOM   1955  O   GLU   251       1.835  22.130  41.721  1.00 42.83          
ATOM   1956  CB  GLU   251       0.565  19.517  40.338  1.00 46.13          
ATOM   1957  CG  GLU   251      -0.155  18.934  39.135  1.00 48.53          
ATOM   1958  CD  GLU   251       0.410  17.596  38.709  1.00 49.88          
ATOM   1959  OE1 GLU   251       1.544  17.265  39.138  1.00 50.12          
ATOM   1960  OE2 GLU   251      -0.278  16.889  37.932  1.00 49.85          
ATOM   1961  N   LEU   252       3.245  20.390  41.788  1.00 43.53          
ATOM   1962  CA  LEU   252       3.886  20.831  43.012  1.00 42.57          
ATOM   1963  C   LEU   252       4.928  21.922  42.821  1.00 42.00          
ATOM   1964  O   LEU   252       5.227  22.648  43.756  1.00 42.30          
ATOM   1965  CB  LEU   252       4.512  19.635  43.736  1.00 41.74          
ATOM   1966  CG  LEU   252       3.547  18.511  44.150  1.00 41.92          
ATOM   1967  CD1 LEU   252       4.312  17.378  44.828  1.00 42.76          
ATOM   1968  CD2 LEU   252       2.494  19.048  45.086  1.00 40.89          
ATOM   1969  N   VAL   253       5.494  22.055  41.630  1.00 42.00          
ATOM   1970  CA  VAL   253       6.506  23.098  41.440  1.00 42.95          
ATOM   1971  C   VAL   253       5.957  24.484  41.772  1.00 44.10          
ATOM   1972  O   VAL   253       6.607  25.265  42.460  1.00 44.41          
ATOM   1973  CB  VAL   253       7.078  23.119  39.992  1.00 41.99          
ATOM   1974  CG1 VAL   253       8.115  24.221  39.854  1.00 39.96          
ATOM   1975  CG2 VAL   253       7.720  21.787  39.669  1.00 42.77          
ATOM   1976  N   PRO   254       4.743  24.805  41.291  1.00 45.20          
ATOM   1977  CA  PRO   254       4.124  26.111  41.551  1.00 45.81          
ATOM   1978  C   PRO   254       3.925  26.422  43.034  1.00 45.87          
ATOM   1979  O   PRO   254       4.113  27.558  43.471  1.00 46.34          
ATOM   1980  CB  PRO   254       2.789  26.018  40.804  1.00 45.36          
ATOM   1981  CG  PRO   254       3.108  25.114  39.670  1.00 45.40          
ATOM   1982  CD  PRO   254       3.917  24.032  40.348  1.00 46.25          
ATOM   1983  N   VAL   255       3.555  25.407  43.804  1.00 45.65          
ATOM   1984  CA  VAL   255       3.323  25.591  45.224  1.00 46.52          
ATOM   1985  C   VAL   255       4.634  25.881  45.971  1.00 45.46          
ATOM   1986  O   VAL   255       4.631  26.462  47.057  1.00 44.66          
ATOM   1987  CB  VAL   255       2.562  24.354  45.825  1.00 46.99          
ATOM   1988  CG1 VAL   255       3.439  23.133  45.793  1.00 48.49          
ATOM   1989  CG2 VAL   255       2.109  24.654  47.237  1.00 49.86          
ATOM   1990  N   ILE   256       5.751  25.507  45.362  1.00 45.49          
ATOM   1991  CA  ILE   256       7.056  25.745  45.954  1.00 46.29          
ATOM   1992  C   ILE   256       7.435  27.214  45.784  1.00 47.82          
ATOM   1993  O   ILE   256       8.270  27.754  46.516  1.00 48.39          
ATOM   1994  CB  ILE   256       8.130  24.897  45.280  1.00 46.02          
ATOM   1995  CG1 ILE   256       7.762  23.427  45.383  1.00 47.63          
ATOM   1996  CG2 ILE   256       9.468  25.123  45.943  1.00 46.15          
ATOM   1997  CD  ILE   256       8.770  22.513  44.697  1.00 47.88          
ATOM   1998  N   LYS   257       6.808  27.856  44.811  1.00 47.54          
ATOM   1999  CA  LYS   257       7.057  29.256  44.529  1.00 48.04          
ATOM   2000  C   LYS   257       6.095  30.144  45.315  1.00 47.94          
ATOM   2001  O   LYS   257       6.389  31.307  45.602  1.00 48.31          
ATOM   2002  CB  LYS   257       6.926  29.490  43.023  1.00 49.79          
ATOM   2003  CG  LYS   257       7.852  28.570  42.220  1.00 51.05          
ATOM   2004  CD  LYS   257       7.865  28.896  40.744  1.00 51.18          
ATOM   2005  CE  LYS   257       8.949  28.114  40.016  1.00 52.26          
ATOM   2006  NZ  LYS   257       8.908  28.350  38.537  1.00 51.23          
ATOM   2007  N   GLY   258       4.946  29.582  45.669  1.00 46.79          
ATOM   2008  CA  GLY   258       3.973  30.325  46.436  1.00 45.83          
ATOM   2009  C   GLY   258       2.921  30.953  45.554  1.00 45.01          
ATOM   2010  O   GLY   258       2.265  31.921  45.944  1.00 44.91          
ATOM   2011  N   ASN   259       2.756  30.414  44.356  1.00 43.60          
ATOM   2012  CA  ASN   259       1.757  30.948  43.445  1.00 43.75          
ATOM   2013  C   ASN   259       0.458  30.169  43.563  1.00 43.71          
ATOM   2014  O   ASN   259      -0.609  30.661  43.208  1.00 42.68          
ATOM   2015  CB  ASN   259       2.277  30.909  42.009  1.00 43.72          
ATOM   2016  CG  ASN   259       3.456  31.826  41.802  1.00 44.15          
ATOM   2017  OD1 ASN   259       4.545  31.383  41.428  1.00 45.04          
ATOM   2018  ND2 ASN   259       3.254  33.113  42.060  1.00 43.19          
ATOM   2019  N   ILE   260       0.550  28.954  44.081  1.00 43.37          
ATOM   2020  CA  ILE   260      -0.637  28.137  44.252  1.00 43.46          
ATOM   2021  C   ILE   260      -0.611  27.477  45.638  1.00 43.92          
ATOM   2022  O   ILE   260       0.465  27.206  46.190  1.00 42.74          
ATOM   2023  CB  ILE   260      -0.726  27.095  43.115  1.00 43.21          
ATOM   2024  CG1 ILE   260      -1.974  26.234  43.282  1.00 43.70          
ATOM   2025  CG2 ILE   260       0.541  26.255  43.068  1.00 43.86          
ATOM   2026  CD  ILE   260      -2.181  25.234  42.160  1.00 44.18          
ATOM   2027  N   SER   261      -1.789  27.245  46.219  1.00 44.15          
ATOM   2028  CA  SER   261      -1.874  26.646  47.560  1.00 44.65          
ATOM   2029  C   SER   261      -1.703  25.141  47.512  1.00 44.60          
ATOM   2030  O   SER   261      -2.022  24.509  46.516  1.00 44.23          
ATOM   2031  CB  SER   261      -3.218  26.984  48.215  1.00 43.24          
ATOM   2032  OG  SER   261      -4.290  26.404  47.507  1.00 43.70          
ATOM   2033  N   MET   262      -1.201  24.572  48.599  1.00 46.15          
ATOM   2034  CA  MET   262      -0.993  23.135  48.663  1.00 47.95          
ATOM   2035  C   MET   262      -2.303  22.393  48.419  1.00 46.17          
ATOM   2036  O   MET   262      -2.341  21.413  47.676  1.00 45.54          
ATOM   2037  CB  MET   262      -0.418  22.746  50.029  1.00 51.56          
ATOM   2038  CG  MET   262      -0.078  21.262  50.196  1.00 56.73          
ATOM   2039  SD  MET   262       1.519  20.694  49.227  1.00 68.54          
ATOM   2040  CE  MET   262       0.661  20.288  47.543  1.00 64.64          
ATOM   2041  N   GLU   263      -3.376  22.871  49.040  1.00 45.51          
ATOM   2042  CA  GLU   263      -4.690  22.247  48.899  1.00 45.04          
ATOM   2043  C   GLU   263      -5.118  22.133  47.447  1.00 44.37          
ATOM   2044  O   GLU   263      -5.347  21.035  46.935  1.00 42.41          
ATOM   2045  CB  GLU   263      -5.738  23.045  49.678  1.00 45.88          
ATOM   2046  CG  GLU   263      -5.523  23.008  51.187  1.00 48.51          
ATOM   2047  CD  GLU   263      -4.644  24.132  51.716  1.00 50.02          
ATOM   2048  OE1 GLU   263      -4.298  24.079  52.917  1.00 50.44          
ATOM   2049  OE2 GLU   263      -4.319  25.069  50.948  1.00 51.15          
ATOM   2050  N   ASN   264      -5.226  23.289  46.798  1.00 44.68          
ATOM   2051  CA  ASN   264      -5.613  23.378  45.397  1.00 44.86          
ATOM   2052  C   ASN   264      -4.731  22.509  44.490  1.00 44.40          
ATOM   2053  O   ASN   264      -5.232  21.786  43.621  1.00 44.99          
ATOM   2054  CB  ASN   264      -5.571  24.840  44.954  1.00 45.20          
ATOM   2055  CG  ASN   264      -6.725  25.644  45.526  1.00 47.47          
ATOM   2056  OD1 ASN   264      -6.823  26.848  45.318  1.00 47.36          
ATOM   2057  ND2 ASN   264      -7.620  24.967  46.247  1.00 49.46          
ATOM   2058  N   ALA   265      -3.422  22.574  44.707  1.00 43.68          
ATOM   2059  CA  ALA   265      -2.468  21.794  43.935  1.00 42.84          
ATOM   2060  C   ALA   265      -2.749  20.305  44.092  1.00 42.53          
ATOM   2061  O   ALA   265      -2.871  19.580  43.103  1.00 42.36          
ATOM   2062  CB  ALA   265      -1.052  22.109  44.390  1.00 42.55          
ATOM   2063  N   VAL   266      -2.843  19.841  45.331  1.00 42.41          
ATOM   2064  CA  VAL   266      -3.108  18.434  45.571  1.00 43.43          
ATOM   2065  C   VAL   266      -4.404  18.022  44.900  1.00 44.60          
ATOM   2066  O   VAL   266      -4.527  16.904  44.404  1.00 44.52          
ATOM   2067  CB  VAL   266      -3.202  18.130  47.074  1.00 44.20          
ATOM   2068  CG1 VAL   266      -3.556  16.660  47.287  1.00 42.88          
ATOM   2069  CG2 VAL   266      -1.875  18.457  47.741  1.00 43.74          
ATOM   2070  N   GLU   267      -5.373  18.931  44.890  1.00 46.48          
ATOM   2071  CA  GLU   267      -6.658  18.660  44.259  1.00 47.56          
ATOM   2072  C   GLU   267      -6.456  18.351  42.774  1.00 47.85          
ATOM   2073  O   GLU   267      -7.092  17.447  42.222  1.00 47.49          
ATOM   2074  CB  GLU   267      -7.572  19.865  44.396  1.00 49.81          
ATOM   2075  CG  GLU   267      -8.763  19.766  43.492  1.00 55.10          
ATOM   2076  CD  GLU   267     -10.067  19.881  44.229  1.00 58.36          
ATOM   2077  OE1 GLU   267     -10.443  21.026  44.578  1.00 60.03          
ATOM   2078  OE2 GLU   267     -10.697  18.825  44.483  1.00 60.12          
ATOM   2079  N   LYS   268      -5.566  19.113  42.135  1.00 47.95          
ATOM   2080  CA  LYS   268      -5.262  18.927  40.722  1.00 48.04          
ATOM   2081  C   LYS   268      -4.369  17.712  40.488  1.00 47.98          
ATOM   2082  O   LYS   268      -4.441  17.072  39.438  1.00 48.31          
ATOM   2083  CB  LYS   268      -4.604  20.187  40.154  1.00 47.51          
ATOM   2084  CG  LYS   268      -5.534  21.394  40.148  1.00 49.27          
ATOM   2085  CD  LYS   268      -4.978  22.558  39.331  1.00 50.77          
ATOM   2086  CE  LYS   268      -3.645  23.070  39.900  1.00 51.57          
ATOM   2087  NZ  LYS   268      -3.096  24.265  39.171  1.00 50.01          
ATOM   2088  N   LEU   269      -3.529  17.396  41.470  1.00 48.23          
ATOM   2089  CA  LEU   269      -2.643  16.242  41.371  1.00 47.71          
ATOM   2090  C   LEU   269      -3.442  14.928  41.365  1.00 47.84          
ATOM   2091  O   LEU   269      -3.144  14.018  40.591  1.00 47.71          
ATOM   2092  CB  LEU   269      -1.637  16.252  42.532  1.00 46.71          
ATOM   2093  CG  LEU   269      -0.758  15.019  42.762  1.00 45.77          
ATOM   2094  CD1 LEU   269      -0.011  14.668  41.499  1.00 46.01          
ATOM   2095  CD2 LEU   269       0.216  15.295  43.894  1.00 45.49          
ATOM   2096  N   LYS   270      -4.456  14.827  42.221  1.00 47.27          
ATOM   2097  CA  LYS   270      -5.276  13.617  42.276  1.00 47.21          
ATOM   2098  C   LYS   270      -6.162  13.535  41.038  1.00 47.74          
ATOM   2099  O   LYS   270      -6.550  12.448  40.614  1.00 47.84          
ATOM   2100  CB  LYS   270      -6.160  13.615  43.523  1.00 46.87          
ATOM   2101  CG  LYS   270      -5.398  13.685  44.847  1.00 45.75          
ATOM   2102  CD  LYS   270      -6.354  13.642  46.036  1.00 43.37          
ATOM   2103  CE  LYS   270      -5.619  13.777  47.346  1.00 42.55          
ATOM   2104  NZ  LYS   270      -6.516  13.481  48.479  1.00 42.55          
ATOM   2105  N   GLN   271      -6.491  14.689  40.466  1.00 47.50          
ATOM   2106  CA  GLN   271      -7.318  14.706  39.279  1.00 47.55          
ATOM   2107  C   GLN   271      -6.498  14.205  38.090  1.00 46.89          
ATOM   2108  O   GLN   271      -6.837  13.186  37.493  1.00 48.08          
ATOM   2109  CB  GLN   271      -7.846  16.116  39.008  1.00 50.10          
ATOM   2110  CG  GLN   271      -9.040  16.129  38.072  1.00 51.28          
ATOM   2111  CD  GLN   271      -9.270  17.471  37.406  1.00 51.63          
ATOM   2112  OE1 GLN   271     -10.281  17.664  36.729  1.00 51.74          
ATOM   2113  NE2 GLN   271      -8.332  18.401  37.585  1.00 51.56          
ATOM   2114  N   HSD   272      -5.418  14.908  37.746  1.00 45.28          
ATOM   2115  CA  HSD   272      -4.553  14.493  36.629  1.00 42.45          
ATOM   2116  C   HSD   272      -4.225  13.007  36.753  1.00 40.81          
ATOM   2117  O   HSD   272      -4.041  12.325  35.754  1.00 39.84          
ATOM   2118  CB  HSD   272      -3.221  15.258  36.637  1.00 43.50          
ATOM   2119  CG  HSD   272      -3.334  16.704  36.277  1.00 45.07          
ATOM   2120  ND1 HSD   272      -4.092  17.599  36.999  1.00 45.43          
ATOM   2121  CD2 HSD   272      -2.752  17.416  35.286  1.00 46.21          
ATOM   2122  CE1 HSD   272      -3.972  18.803  36.470  1.00 45.55          
ATOM   2123  NE2 HSD   272      -3.164  18.719  35.430  1.00 46.84          
ATOM   2124  N   SER   273      -4.126  12.519  37.989  1.00 38.20          
ATOM   2125  CA  SER   273      -3.803  11.130  38.213  1.00 35.52          
ATOM   2126  C   SER   273      -4.983  10.267  37.835  1.00 35.68          
ATOM   2127  O   SER   273      -4.811   9.191  37.264  1.00 35.30          
ATOM   2128  CB  SER   273      -3.412  10.895  39.668  1.00 35.90          
ATOM   2129  OG  SER   273      -2.188  11.530  39.993  1.00 32.29          
ATOM   2130  N   ARG   274      -6.187  10.727  38.149  1.00 35.75          
ATOM   2131  CA  ARG   274      -7.390   9.969  37.802  1.00 36.75          
ATOM   2132  C   ARG   274      -7.588   9.937  36.285  1.00 37.28          
ATOM   2133  O   ARG   274      -7.869   8.888  35.722  1.00 38.52          
ATOM   2134  CB  ARG   274      -8.637  10.580  38.459  1.00 36.95          
ATOM   2135  CG  ARG   274      -8.698  10.466  39.974  1.00 36.82          
ATOM   2136  CD  ARG   274     -10.054  10.929  40.488  1.00 36.70          
ATOM   2137  NE  ARG   274     -10.274  12.356  40.263  1.00 38.35          
ATOM   2138  CZ  ARG   274     -10.032  13.306  41.167  1.00 38.14          
ATOM   2139  NH1 ARG   274      -9.561  12.981  42.363  1.00 36.22          
ATOM   2140  NH2 ARG   274     -10.264  14.582  40.878  1.00 37.03          
ATOM   2141  N   GLN   275      -7.443  11.086  35.629  1.00 38.05          
ATOM   2142  CA  GLN   275      -7.617  11.169  34.183  1.00 38.52          
ATOM   2143  C   GLN   275      -6.583  10.312  33.478  1.00 38.01          
ATOM   2144  O   GLN   275      -6.896   9.574  32.543  1.00 39.39          
ATOM   2145  CB  GLN   275      -7.474  12.608  33.709  1.00 40.25          
ATOM   2146  CG  GLN   275      -8.511  13.556  34.284  1.00 43.98          
ATOM   2147  CD  GLN   275      -8.149  15.020  34.056  1.00 46.35          
ATOM   2148  OE1 GLN   275      -7.853  15.427  32.936  1.00 48.91          
ATOM   2149  NE2 GLN   275      -8.177  15.816  35.123  1.00 47.14          
ATOM   2150  N   TYR   276      -5.344  10.411  33.934  1.00 36.36          
ATOM   2151  CA  TYR   276      -4.262   9.650  33.344  1.00 35.31          
ATOM   2152  C   TYR   276      -4.531   8.157  33.426  1.00 34.41          
ATOM   2153  O   TYR   276      -4.445   7.449  32.430  1.00 33.63          
ATOM   2154  CB  TYR   276      -2.950  10.005  34.050  1.00 35.75          
ATOM   2155  CG  TYR   276      -1.751   9.236  33.559  1.00 36.20          
ATOM   2156  CD1 TYR   276      -1.464   7.966  34.054  1.00 36.58          
ATOM   2157  CD2 TYR   276      -0.903   9.778  32.600  1.00 35.33          
ATOM   2158  CE1 TYR   276      -0.358   7.257  33.609  1.00 37.87          
ATOM   2159  CE2 TYR   276       0.202   9.082  32.142  1.00 36.76          
ATOM   2160  CZ  TYR   276       0.473   7.820  32.654  1.00 38.26          
ATOM   2161  OH  TYR   276       1.582   7.126  32.231  1.00 40.41          
ATOM   2162  N   ALA   277      -4.858   7.685  34.619  1.00 34.89          
ATOM   2163  CA  ALA   277      -5.136   6.275  34.828  1.00 36.30          
ATOM   2164  C   ALA   277      -6.255   5.819  33.905  1.00 38.00          
ATOM   2165  O   ALA   277      -6.225   4.706  33.376  1.00 36.91          
ATOM   2166  CB  ALA   277      -5.530   6.026  36.276  1.00 35.53          
ATOM   2167  N   LYS   278      -7.251   6.679  33.723  1.00 40.20          
ATOM   2168  CA  LYS   278      -8.383   6.359  32.865  1.00 42.32          
ATOM   2169  C   LYS   278      -7.949   6.259  31.429  1.00 43.49          
ATOM   2170  O   LYS   278      -8.225   5.263  30.762  1.00 44.62          
ATOM   2171  CB  LYS   278      -9.477   7.419  32.990  1.00 43.95          
ATOM   2172  CG  LYS   278     -10.619   7.243  31.998  1.00 46.27          
ATOM   2173  CD  LYS   278     -11.846   8.053  32.398  1.00 49.97          
ATOM   2174  CE  LYS   278     -13.027   7.776  31.461  1.00 51.38          
ATOM   2175  NZ  LYS   278     -14.346   8.206  32.045  1.00 53.63          
ATOM   2176  N   ARG   279      -7.271   7.296  30.948  1.00 44.33          
ATOM   2177  CA  ARG   279      -6.798   7.321  29.561  1.00 45.32          
ATOM   2178  C   ARG   279      -5.950   6.079  29.228  1.00 45.13          
ATOM   2179  O   ARG   279      -6.048   5.529  28.134  1.00 44.57          
ATOM   2180  CB  ARG   279      -6.008   8.619  29.301  1.00 47.62          
ATOM   2181  CG  ARG   279      -5.490   8.795  27.863  1.00 50.39          
ATOM   2182  CD  ARG   279      -5.468  10.270  27.446  1.00 53.84          
ATOM   2183  NE  ARG   279      -4.936  11.132  28.466  1.00 57.92          
ATOM   2184  CZ  ARG   279      -5.349  12.289  28.988  1.00 58.57          
ATOM   2185  NH1 ARG   279      -4.546  12.767  29.919  1.00 59.22          
ATOM   2186  NH2 ARG   279      -6.458  12.959  28.669  1.00 58.05          
ATOM   2187  N   GLN   280      -5.142   5.629  30.186  1.00 44.54          
ATOM   2188  CA  GLN   280      -4.299   4.466  29.979  1.00 42.49          
ATOM   2189  C   GLN   280      -5.092   3.179  29.965  1.00 42.31          
ATOM   2190  O   GLN   280      -4.725   2.219  29.298  1.00 42.76          
ATOM   2191  CB  GLN   280      -3.229   4.386  31.065  1.00 41.79          
ATOM   2192  CG  GLN   280      -1.842   4.200  30.515  1.00 42.04          
ATOM   2193  CD  GLN   280      -1.452   5.345  29.597  1.00 42.96          
ATOM   2194  OE1 GLN   280      -0.920   5.137  28.501  1.00 41.69          
ATOM   2195  NE2 GLN   280      -1.723   6.569  30.040  1.00 42.65          
ATOM   2196  N   LEU   281      -6.177   3.149  30.720  1.00 43.60          
ATOM   2197  CA  LEU   281      -7.005   1.954  30.795  1.00 44.86          
ATOM   2198  C   LEU   281      -7.760   1.866  29.474  1.00 46.02          
ATOM   2199  O   LEU   281      -7.866   0.798  28.873  1.00 46.62          
ATOM   2200  CB  LEU   281      -7.986   2.084  31.964  1.00 46.05          
ATOM   2201  CG  LEU   281      -8.521   0.834  32.659  1.00 47.29          
ATOM   2202  CD1 LEU   281      -9.210  -0.042  31.635  1.00 48.02          
ATOM   2203  CD2 LEU   281      -7.383   0.073  33.349  1.00 47.94          
ATOM   2204  N   THR   282      -8.259   3.012  29.018  1.00 46.51          
ATOM   2205  CA  THR   282      -9.011   3.086  27.779  1.00 46.62          
ATOM   2206  C   THR   282      -8.209   2.592  26.578  1.00 47.68          
ATOM   2207  O   THR   282      -8.715   1.818  25.766  1.00 48.50          
ATOM   2208  CB  THR   282      -9.477   4.525  27.521  1.00 46.54          
ATOM   2209  OG1 THR   282     -10.263   4.981  28.627  1.00 44.95          
ATOM   2210  CG2 THR   282     -10.313   4.591  26.265  1.00 48.15          
ATOM   2211  N   TRP   283      -6.960   3.041  26.478  1.00 49.10          
ATOM   2212  CA  TRP   283      -6.054   2.668  25.387  1.00 48.96          
ATOM   2213  C   TRP   283      -5.796   1.160  25.333  1.00 48.30          
ATOM   2214  O   TRP   283      -5.877   0.555  24.268  1.00 48.47          
ATOM   2215  CB  TRP   283      -4.710   3.386  25.551  1.00 50.31          
ATOM   2216  CG  TRP   283      -3.929   3.535  24.282  1.00 53.10          
ATOM   2217  CD1 TRP   283      -3.892   4.632  23.471  1.00 53.65          
ATOM   2218  CD2 TRP   283      -3.116   2.541  23.645  1.00 53.31          
ATOM   2219  NE1 TRP   283      -3.107   4.384  22.379  1.00 53.64          
ATOM   2220  CE2 TRP   283      -2.611   3.113  22.464  1.00 53.34          
ATOM   2221  CE3 TRP   283      -2.748   1.233  23.970  1.00 54.28          
ATOM   2222  CZ2 TRP   283      -1.788   2.417  21.588  1.00 55.15          
ATOM   2223  CZ3 TRP   283      -1.924   0.534  23.101  1.00 54.82          
ATOM   2224  CH2 TRP   283      -1.443   1.133  21.924  1.00 55.31          
ATOM   2225  N   PHE   284      -5.472   0.568  26.480  1.00 47.17          
ATOM   2226  CA  PHE   284      -5.194  -0.858  26.554  1.00 45.95          
ATOM   2227  C   PHE   284      -6.413  -1.712  26.276  1.00 46.16          
ATOM   2228  O   PHE   284      -6.318  -2.934  26.213  1.00 47.88          
ATOM   2229  CB  PHE   284      -4.607  -1.229  27.922  1.00 42.99          
ATOM   2230  CG  PHE   284      -3.119  -1.052  28.005  1.00 40.18          
ATOM   2231  CD1 PHE   284      -2.281  -1.783  27.178  1.00 38.71          
ATOM   2232  CD2 PHE   284      -2.555  -0.133  28.888  1.00 40.20          
ATOM   2233  CE1 PHE   284      -0.906  -1.610  27.230  1.00 38.81          
ATOM   2234  CE2 PHE   284      -1.174   0.054  28.951  1.00 38.51          
ATOM   2235  CZ  PHE   284      -0.352  -0.684  28.118  1.00 39.99          
ATOM   2236  N   LYS   285      -7.569  -1.093  26.111  1.00 46.47          
ATOM   2237  CA  LYS   285      -8.747  -1.884  25.829  1.00 47.62          
ATOM   2238  C   LYS   285      -9.215  -1.695  24.405  1.00 48.73          
ATOM   2239  O   LYS   285      -9.863  -2.571  23.847  1.00 49.63          
ATOM   2240  CB  LYS   285      -9.860  -1.528  26.789  1.00 47.52          
ATOM   2241  CG  LYS   285      -9.475  -1.804  28.215  1.00 49.56          
ATOM   2242  CD  LYS   285     -10.683  -1.752  29.140  1.00 51.10          
ATOM   2243  CE  LYS   285     -11.397  -3.104  29.245  1.00 51.69          
ATOM   2244  NZ  LYS   285     -10.700  -4.102  30.117  1.00 51.69          
ATOM   2245  N   ASN   286      -8.868  -0.558  23.814  1.00 49.04          
ATOM   2246  CA  ASN   286      -9.260  -0.247  22.453  1.00 50.46          
ATOM   2247  C   ASN   286      -8.121  -0.338  21.443  1.00 50.96          
ATOM   2248  O   ASN   286      -8.236   0.171  20.333  1.00 51.83          
ATOM   2249  CB  ASN   286      -9.847   1.164  22.407  1.00 52.33          
ATOM   2250  CG  ASN   286     -11.065   1.320  23.282  1.00 54.53          
ATOM   2251  OD1 ASN   286     -11.519   2.441  23.545  1.00 55.13          
ATOM   2252  ND2 ASN   286     -11.610   0.197  23.740  1.00 55.49          
ATOM   2253  N   LYS   287      -7.020  -0.974  21.809  1.00 49.95          
ATOM   2254  CA  LYS   287      -5.896  -1.048  20.890  1.00 50.52          
ATOM   2255  C   LYS   287      -5.153  -2.352  21.034  1.00 51.97          
ATOM   2256  O   LYS   287      -4.591  -2.877  20.072  1.00 52.44          
ATOM   2257  CB  LYS   287      -4.909   0.091  21.161  1.00 50.17          
ATOM   2258  CG  LYS   287      -5.476   1.494  21.098  1.00 48.41          
ATOM   2259  CD  LYS   287      -5.691   1.932  19.669  1.00 49.42          
ATOM   2260  CE  LYS   287      -5.956   3.434  19.586  1.00 50.59          
ATOM   2261  NZ  LYS   287      -4.832   4.254  20.139  1.00 50.42          
ATOM   2262  N   MET   288      -5.140  -2.869  22.252  1.00 54.12          
ATOM   2263  CA  MET   288      -4.431  -4.106  22.540  1.00 56.02          
ATOM   2264  C   MET   288      -5.382  -5.213  22.882  1.00 54.23          
ATOM   2265  O   MET   288      -6.522  -4.988  23.288  1.00 53.68          
ATOM   2266  CB  MET   288      -3.501  -3.926  23.735  1.00 61.19          
ATOM   2267  CG  MET   288      -2.671  -2.667  23.730  1.00 67.84          
ATOM   2268  SD  MET   288      -1.138  -2.799  22.617  1.00 79.05          
ATOM   2269  CE  MET   288       0.044  -3.697  23.862  1.00 75.12          
ATOM   2270  N   ASN   289      -4.886  -6.422  22.726  1.00 53.34          
ATOM   2271  CA  ASN   289      -5.667  -7.579  23.057  1.00 53.29          
ATOM   2272  C   ASN   289      -5.017  -8.084  24.333  1.00 50.83          
ATOM   2273  O   ASN   289      -4.131  -8.932  24.302  1.00 49.74          
ATOM   2274  CB  ASN   289      -5.564  -8.625  21.953  1.00 56.36          
ATOM   2275  CG  ASN   289      -6.458  -9.808  22.210  1.00 58.29          
ATOM   2276  OD1 ASN   289      -7.680  -9.659  22.324  1.00 58.96          
ATOM   2277  ND2 ASN   289      -5.863 -10.994  22.316  1.00 59.23          
ATOM   2278  N   VAL   290      -5.446  -7.523  25.453  1.00 48.80          
ATOM   2279  CA  VAL   290      -4.910  -7.887  26.751  1.00 47.23          
ATOM   2280  C   VAL   290      -5.792  -8.891  27.489  1.00 45.86          
ATOM   2281  O   VAL   290      -7.021  -8.836  27.398  1.00 44.14          
ATOM   2282  CB  VAL   290      -4.785  -6.651  27.664  1.00 46.63          
ATOM   2283  CG1 VAL   290      -4.015  -7.007  28.914  1.00 46.42          
ATOM   2284  CG2 VAL   290      -4.128  -5.517  26.915  1.00 46.08          
ATOM   2285  N   HSD   291      -5.153  -9.801  28.228  1.00 45.26          
ATOM   2286  CA  HSD   291      -5.853 -10.808  29.039  1.00 43.68          
ATOM   2287  C   HSD   291      -5.984 -10.136  30.408  1.00 41.95          
ATOM   2288  O   HSD   291      -5.090 -10.212  31.242  1.00 41.42          
ATOM   2289  CB  HSD   291      -5.017 -12.093  29.139  1.00 45.12          
ATOM   2290  CG  HSD   291      -5.728 -13.236  29.801  1.00 47.50          
ATOM   2291  ND1 HSD   291      -6.067 -13.231  31.137  1.00 49.19          
ATOM   2292  CD2 HSD   291      -6.129 -14.434  29.315  1.00 48.36          
ATOM   2293  CE1 HSD   291      -6.643 -14.379  31.450  1.00 48.95          
ATOM   2294  NE2 HSD   291      -6.692 -15.126  30.362  1.00 49.58          
ATOM   2295  N   TRP   292      -7.105  -9.462  30.613  1.00 40.90          
ATOM   2296  CA  TRP   292      -7.368  -8.742  31.843  1.00 40.61          
ATOM   2297  C   TRP   292      -7.686  -9.607  33.055  1.00 40.95          
ATOM   2298  O   TRP   292      -8.454 -10.557  32.958  1.00 41.63          
ATOM   2299  CB  TRP   292      -8.526  -7.771  31.636  1.00 40.25          
ATOM   2300  CG  TRP   292      -8.274  -6.779  30.563  1.00 39.85          
ATOM   2301  CD1 TRP   292      -8.661  -6.855  29.260  1.00 38.13          
ATOM   2302  CD2 TRP   292      -7.531  -5.564  30.696  1.00 40.33          
ATOM   2303  NE1 TRP   292      -8.205  -5.752  28.571  1.00 39.14          
ATOM   2304  CE2 TRP   292      -7.509  -4.945  29.429  1.00 40.04          
ATOM   2305  CE3 TRP   292      -6.886  -4.937  31.769  1.00 40.44          
ATOM   2306  CZ2 TRP   292      -6.859  -3.733  29.200  1.00 40.75          
ATOM   2307  CZ3 TRP   292      -6.241  -3.732  31.548  1.00 40.21          
ATOM   2308  CH2 TRP   292      -6.234  -3.139  30.268  1.00 42.10          
ATOM   2309  N   LEU   293      -7.089  -9.257  34.196  1.00 41.00          
ATOM   2310  CA  LEU   293      -7.307  -9.933  35.475  1.00 40.14          
ATOM   2311  C   LEU   293      -8.026  -8.905  36.313  1.00 40.38          
ATOM   2312  O   LEU   293      -7.472  -7.843  36.581  1.00 40.60          
ATOM   2313  CB  LEU   293      -5.984 -10.274  36.154  1.00 38.82          
ATOM   2314  CG  LEU   293      -5.110 -11.199  35.326  1.00 39.72          
ATOM   2315  CD1 LEU   293      -3.797 -11.494  36.031  1.00 38.67          
ATOM   2316  CD2 LEU   293      -5.895 -12.473  35.064  1.00 40.48          
ATOM   2317  N   ASN   294      -9.250  -9.211  36.730  1.00 42.06          
ATOM   2318  CA  ASN   294     -10.041  -8.275  37.536  1.00 42.99          
ATOM   2319  C   ASN   294      -9.539  -8.244  38.994  1.00 42.40          
ATOM   2320  O   ASN   294      -9.800  -9.147  39.767  1.00 43.13          
ATOM   2321  CB  ASN   294     -11.521  -8.682  37.457  1.00 43.12          
ATOM   2322  CG  ASN   294     -12.457  -7.637  38.043  1.00 43.42          
ATOM   2323  OD1 ASN   294     -13.669  -7.699  37.821  1.00 44.84          
ATOM   2324  ND2 ASN   294     -11.906  -6.680  38.800  1.00 41.98          
ATOM   2325  N   LYS   295      -8.811  -7.194  39.348  1.00 43.13          
ATOM   2326  CA  LYS   295      -8.253  -7.047  40.677  1.00 44.01          
ATOM   2327  C   LYS   295      -9.313  -7.034  41.774  1.00 47.25          
ATOM   2328  O   LYS   295      -9.015  -7.299  42.942  1.00 48.02          
ATOM   2329  CB  LYS   295      -7.446  -5.766  40.753  1.00 42.24          
ATOM   2330  CG  LYS   295      -6.686  -5.590  42.016  1.00 42.84          
ATOM   2331  CD  LYS   295      -6.654  -4.138  42.427  1.00 41.97          
ATOM   2332  CE  LYS   295      -5.265  -3.736  42.874  1.00 42.08          
ATOM   2333  NZ  LYS   295      -4.617  -4.779  43.697  1.00 40.12          
ATOM   2334  N   GLU   296     -10.554  -6.736  41.414  1.00 49.88          
ATOM   2335  CA  GLU   296     -11.635  -6.700  42.395  1.00 52.31          
ATOM   2336  C   GLU   296     -12.243  -8.072  42.657  1.00 52.26          
ATOM   2337  O   GLU   296     -13.304  -8.179  43.273  1.00 53.05          
ATOM   2338  CB  GLU   296     -12.728  -5.742  41.914  1.00 54.20          
ATOM   2339  CG  GLU   296     -12.342  -4.282  41.971  1.00 57.99          
ATOM   2340  CD  GLU   296     -13.383  -3.378  41.337  1.00 60.64          
ATOM   2341  OE1 GLU   296     -13.255  -2.139  41.457  1.00 62.59          
ATOM   2342  OE2 GLU   296     -14.328  -3.905  40.710  1.00 60.61          
ATOM   2343  N   ARG   297     -11.552  -9.115  42.213  1.00 52.15          
ATOM   2344  CA  ARG   297     -12.045 -10.478  42.350  1.00 52.31          
ATOM   2345  C   ARG   297     -10.908 -11.491  42.500  1.00 50.64          
ATOM   2346  O   ARG   297     -11.123 -12.649  42.850  1.00 49.87          
ATOM   2347  CB  ARG   297     -12.922 -10.796  41.124  1.00 53.68          
ATOM   2348  CG  ARG   297     -13.339 -12.235  40.948  1.00 58.16          
ATOM   2349  CD  ARG   297     -12.319 -12.955  40.102  1.00 62.33          
ATOM   2350  NE  ARG   297     -12.864 -14.119  39.483  1.00 67.18          
ATOM   2351  CZ  ARG   297     -12.451 -15.380  39.413  1.00 69.01          
ATOM   2352  NH1 ARG   297     -11.343 -15.881  39.961  1.00 68.90          
ATOM   2353  NH2 ARG   297     -13.246 -16.161  38.703  1.00 69.75          
ATOM   2354  N   MET   298      -9.693 -11.038  42.250  1.00 49.65          
ATOM   2355  CA  MET   298      -8.541 -11.903  42.356  1.00 50.50          
ATOM   2356  C   MET   298      -7.472 -11.290  43.238  1.00 48.11          
ATOM   2357  O   MET   298      -7.401 -10.075  43.404  1.00 47.23          
ATOM   2358  CB  MET   298      -7.949 -12.163  40.986  1.00 56.16          
ATOM   2359  CG  MET   298      -8.803 -13.028  40.098  1.00 64.13          
ATOM   2360  SD  MET   298      -7.976 -13.256  38.354  1.00 73.14          
ATOM   2361  CE  MET   298      -9.250 -12.214  37.289  1.00 70.76          
ATOM   2362  N   SER   299      -6.617 -12.143  43.776  1.00 44.79          
ATOM   2363  CA  SER   299      -5.559 -11.700  44.652  1.00 43.78          
ATOM   2364  C   SER   299      -4.202 -11.928  44.027  1.00 43.59          
ATOM   2365  O   SER   299      -4.092 -12.631  43.038  1.00 44.01          
ATOM   2366  CB  SER   299      -5.630 -12.478  45.948  1.00 43.01          
ATOM   2367  OG  SER   299      -5.428 -13.850  45.693  1.00 38.72          
ATOM   2368  N   LEU   300      -3.164 -11.360  44.631  1.00 45.42          
ATOM   2369  CA  LEU   300      -1.813 -11.519  44.113  1.00 46.46          
ATOM   2370  C   LEU   300      -1.527 -12.981  43.790  1.00 46.29          
ATOM   2371  O   LEU   300      -0.977 -13.281  42.736  1.00 47.27          
ATOM   2372  CB  LEU   300      -0.793 -10.992  45.119  1.00 46.38          
ATOM   2373  CG  LEU   300       0.675 -11.080  44.682  1.00 47.84          
ATOM   2374  CD1 LEU   300       0.876 -10.362  43.352  1.00 45.68          
ATOM   2375  CD2 LEU   300       1.578 -10.470  45.764  1.00 48.95          
ATOM   2376  N   GLN   301      -1.914 -13.884  44.686  1.00 45.54          
ATOM   2377  CA  GLN   301      -1.695 -15.308  44.478  1.00 46.12          
ATOM   2378  C   GLN   301      -2.615 -15.887  43.416  1.00 47.69          
ATOM   2379  O   GLN   301      -2.218 -16.753  42.641  1.00 47.50          
ATOM   2380  CB  GLN   301      -1.924 -16.082  45.763  1.00 46.17          
ATOM   2381  CG  GLN   301      -1.622 -17.564  45.643  1.00 46.12          
ATOM   2382  CD  GLN   301      -0.136 -17.838  45.601  1.00 45.52          
ATOM   2383  OE1 GLN   301       0.572 -17.307  44.754  1.00 44.36          
ATOM   2384  NE2 GLN   301       0.346 -18.671  46.524  1.00 45.99          
ATOM   2385  N   MET   302      -3.861 -15.439  43.399  1.00 49.31          
ATOM   2386  CA  MET   302      -4.797 -15.938  42.409  1.00 51.32          
ATOM   2387  C   MET   302      -4.385 -15.528  41.006  1.00 52.45          
ATOM   2388  O   MET   302      -4.563 -16.285  40.061  1.00 52.64          
ATOM   2389  CB  MET   302      -6.200 -15.436  42.704  1.00 52.89          
ATOM   2390  CG  MET   302      -6.855 -16.153  43.851  1.00 57.45          
ATOM   2391  SD  MET   302      -8.378 -15.173  44.471  1.00 62.65          
ATOM   2392  CE  MET   302      -9.628 -15.560  43.052  1.00 62.89          
ATOM   2393  N   MET   303      -3.845 -14.325  40.867  1.00 53.09          
ATOM   2394  CA  MET   303      -3.406 -13.857  39.571  1.00 53.97          
ATOM   2395  C   MET   303      -2.217 -14.696  39.122  1.00 52.85          
ATOM   2396  O   MET   303      -2.169 -15.134  37.982  1.00 52.25          
ATOM   2397  CB  MET   303      -2.999 -12.391  39.643  1.00 57.76          
ATOM   2398  CG  MET   303      -4.109 -11.452  40.071  1.00 63.73          
ATOM   2399  SD  MET   303      -3.617  -9.563  39.822  1.00 70.50          
ATOM   2400  CE  MET   303      -3.534  -8.998  41.681  1.00 70.66          
ATOM   2401  N   LEU   304      -1.267 -14.928  40.027  1.00 52.23          
ATOM   2402  CA  LEU   304      -0.086 -15.718  39.706  1.00 51.04          
ATOM   2403  C   LEU   304      -0.471 -17.097  39.207  1.00 51.98          
ATOM   2404  O   LEU   304       0.309 -17.748  38.525  1.00 53.52          
ATOM   2405  CB  LEU   304       0.837 -15.844  40.922  1.00 49.65          
ATOM   2406  CG  LEU   304       2.130 -16.655  40.773  1.00 47.72          
ATOM   2407  CD1 LEU   304       2.999 -16.079  39.681  1.00 46.43          
ATOM   2408  CD2 LEU   304       2.876 -16.643  42.087  1.00 46.76          
ATOM   2409  N   ASP   305      -1.671 -17.551  39.540  1.00 53.53          
ATOM   2410  CA  ASP   305      -2.109 -18.859  39.081  1.00 54.88          
ATOM   2411  C   ASP   305      -2.729 -18.774  37.718  1.00 54.61          
ATOM   2412  O   ASP   305      -2.629 -19.709  36.933  1.00 55.30          
ATOM   2413  CB  ASP   305      -3.099 -19.477  40.055  1.00 56.92          
ATOM   2414  CG  ASP   305      -2.415 -20.011  41.284  1.00 60.74          
ATOM   2415  OD1 ASP   305      -1.398 -20.735  41.116  1.00 62.71          
ATOM   2416  OD2 ASP   305      -2.884 -19.724  42.412  1.00 61.25          
ATOM   2417  N   GLU   306      -3.393 -17.660  37.445  1.00 55.22          
ATOM   2418  CA  GLU   306      -4.012 -17.454  36.147  1.00 55.87          
ATOM   2419  C   GLU   306      -2.905 -17.445  35.105  1.00 55.93          
ATOM   2420  O   GLU   306      -3.042 -18.029  34.029  1.00 56.27          
ATOM   2421  CB  GLU   306      -4.748 -16.122  36.124  1.00 57.59          
ATOM   2422  CG  GLU   306      -6.257 -16.253  36.166  1.00 61.17          
ATOM   2423  CD  GLU   306      -6.816 -16.815  34.885  1.00 62.73          
ATOM   2424  OE1 GLU   306      -6.546 -16.211  33.817  1.00 63.01          
ATOM   2425  OE2 GLU   306      -7.521 -17.852  34.950  1.00 64.03          
ATOM   2426  N   ILE   307      -1.805 -16.778  35.443  1.00 55.01          
ATOM   2427  CA  ILE   307      -0.650 -16.667  34.563  1.00 54.51          
ATOM   2428  C   ILE   307       0.085 -17.996  34.460  1.00 54.74          
ATOM   2429  O   ILE   307       0.626 -18.335  33.411  1.00 53.61          
ATOM   2430  CB  ILE   307       0.339 -15.581  35.081  1.00 53.45          
ATOM   2431  CG1 ILE   307      -0.316 -14.207  35.000  1.00 53.10          
ATOM   2432  CG2 ILE   307       1.616 -15.576  34.253  1.00 53.14          
ATOM   2433  CD  ILE   307       0.533 -13.103  35.547  1.00 51.89          
ATOM   2434  N   THR   308       0.094 -18.752  35.551  1.00 55.72          
ATOM   2435  CA  THR   308       0.789 -20.028  35.573  1.00 57.22          
ATOM   2436  C   THR   308       0.082 -21.019  34.656  1.00 57.78          
ATOM   2437  O   THR   308       0.712 -21.883  34.057  1.00 58.79          
ATOM   2438  CB  THR   308       0.891 -20.562  37.028  1.00 57.17          
ATOM   2439  OG1 THR   308       2.063 -21.375  37.156  1.00 57.44          
ATOM   2440  CG2 THR   308      -0.331 -21.372  37.397  1.00 58.77          
ATOM   2441  N   THR   309      -1.228 -20.869  34.523  1.00 58.23          
ATOM   2442  CA  THR   309      -2.000 -21.748  33.664  1.00 58.17          
ATOM   2443  C   THR   309      -1.745 -21.379  32.214  1.00 57.88          
ATOM   2444  O   THR   309      -1.687 -22.234  31.336  1.00 57.72          
ATOM   2445  CB  THR   309      -3.494 -21.600  33.955  1.00 59.17          
ATOM   2446  OG1 THR   309      -3.746 -21.966  35.317  1.00 59.29          
ATOM   2447  CG2 THR   309      -4.319 -22.476  33.022  1.00 59.28          
ATOM   2448  N   GLN   310      -1.598 -20.086  31.977  1.00 58.69          
ATOM   2449  CA  GLN   310      -1.347 -19.579  30.646  1.00 59.14          
ATOM   2450  C   GLN   310       0.065 -19.993  30.215  1.00 59.03          
ATOM   2451  O   GLN   310       0.296 -20.278  29.046  1.00 60.40          
ATOM   2452  CB  GLN   310      -1.489 -18.054  30.644  1.00 59.01          
ATOM   2453  CG  GLN   310      -2.202 -17.467  29.433  1.00 59.91          
ATOM   2454  CD  GLN   310      -3.696 -17.758  29.409  1.00 59.59          
ATOM   2455  OE1 GLN   310      -4.416 -17.289  28.525  1.00 58.69          
ATOM   2456  NE2 GLN   310      -4.168 -18.532  30.378  1.00 58.43          
ATOM   2457  N   ILE   311       1.003 -20.039  31.157  1.00 58.73          
ATOM   2458  CA  ILE   311       2.376 -20.425  30.835  1.00 59.08          
ATOM   2459  C   ILE   311       2.537 -21.934  30.661  1.00 61.03          
ATOM   2460  O   ILE   311       3.463 -22.396  29.979  1.00 60.61          
ATOM   2461  CB  ILE   311       3.380 -19.950  31.918  1.00 57.94          
ATOM   2462  CG1 ILE   311       3.404 -18.424  31.978  1.00 56.82          
ATOM   2463  CG2 ILE   311       4.774 -20.463  31.601  1.00 56.28          
ATOM   2464  CD  ILE   311       4.156 -17.877  33.159  1.00 56.25          
ATOM   2465  N   ASN   312       1.653 -22.710  31.286  1.00 61.99          
ATOM   2466  CA  ASN   312       1.719 -24.167  31.149  1.00 62.47          
ATOM   2467  C   ASN   312       1.166 -24.608  29.776  1.00 64.15          
ATOM   2468  O   ASN   312       0.939 -25.796  29.548  1.00 64.42          
ATOM   2469  CB  ASN   312       0.962 -24.876  32.295  1.00 61.80          
ATOM   2470  CG  ASN   312       1.702 -24.806  33.644  1.00 60.42          
ATOM   2471  OD1 ASN   312       2.883 -24.439  33.716  1.00 60.65          
ATOM   2472  ND2 ASN   312       1.003 -25.178  34.715  1.00 57.04          
ATOM   2473  N   LYS   313       0.990 -23.648  28.861  1.00 65.63          
ATOM   2474  CA  LYS   313       0.534 -23.932  27.492  1.00 67.33          
ATOM   2475  C   LYS   313       1.699 -23.596  26.559  1.00 68.99          
ATOM   2476  O   LYS   313       2.085 -24.409  25.706  1.00 68.36          
ATOM   2477  CB  LYS   313      -0.703 -23.097  27.105  1.00 66.37          
ATOM   2478  CG  LYS   313      -1.966 -23.428  27.904  1.00 65.14          
ATOM   2479  CD  LYS   313      -2.291 -24.916  27.830  1.00 64.60          
ATOM   2480  CE  LYS   313      -3.074 -25.401  29.056  1.00 63.38          
ATOM   2481  NZ  LYS   313      -3.453 -26.856  28.978  1.00 60.24          
ATOM   2482  N   ARG   314       2.267 -22.402  26.745  1.00 71.80          
ATOM   2483  CA  ARG   314       3.410 -21.937  25.948  1.00 74.39          
ATOM   2484  C   ARG   314       4.544 -22.959  26.006  1.00 75.46          
ATOM   2485  O   ARG   314       5.475 -22.905  25.199  1.00 76.09          
ATOM   2486  CB  ARG   314       3.946 -20.593  26.469  1.00 73.93          
ATOM   2487  CG  ARG   314       3.064 -19.379  26.240  1.00 74.77          
ATOM   2488  CD  ARG   314       2.928 -19.011  24.764  1.00 75.33          
ATOM   2489  NE  ARG   314       2.398 -17.655  24.608  1.00 75.78          
ATOM   2490  CZ  ARG   314       1.191 -17.260  25.009  1.00 75.66          
ATOM   2491  NH1 ARG   314       0.364 -18.116  25.589  1.00 76.05          
ATOM   2492  NH2 ARG   314       0.815 -15.997  24.857  1.00 75.79          
ATOM   2493  N   SER   315       4.472 -23.873  26.973  1.00 76.96          
ATOM   2494  CA  SER   315       5.494 -24.906  27.118  1.00 79.42          
ATOM   2495  C   SER   315       4.966 -26.290  26.719  1.00 80.34          
ATOM   2496  O   SER   315       5.372 -26.766  25.630  1.00 80.78          
ATOM   2497  CB  SER   315       6.047 -24.927  28.561  1.00 79.23          
ATOM   2498  OG  SER   315       5.022 -25.081  29.532  1.00 79.03          
END
