
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  191 ( 1562),  selected  191 , name 1z6g_A
# Molecule2: number of CA atoms  232 ( 1859),  selected  232 , name T0416_6_115_194_315.pdb
# PARAMETERS: 1z6g_A.T0416_6_115_194_315.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     3_A      K       6          3.967
LGA    I     4_A      P       7          2.238
LGA    Y     5_A      F       8          2.106
LGA    P     6_A      L       9          1.325
LGA    L     7_A      I      10          1.253
LGA    V     8_A      V      11          0.724
LGA    I     9_A      I      12          1.100
LGA    C    10_A      V      13          1.250
LGA    G    11_A      G      14          1.831
LGA    P    12_A      P      15          1.863
LGA    S    13_A      T      16          1.746
LGA    G    14_A      A      17          3.187
LGA    V    15_A      S      18          2.487
LGA    G    16_A      G      19          1.580
LGA    K    17_A      K      20          0.919
LGA    G    18_A      T      21          1.708
LGA    T    19_A      E      22          2.233
LGA    L    20_A      L      23          1.616
LGA    I    21_A      S      24          1.609
LGA    K    22_A      I      25          2.024
LGA    K    23_A      E      26          1.705
LGA    L    24_A      V      27          1.353
LGA    L    25_A      A      28          1.649
LGA    N    26_A      K      29          1.948
LGA    E    27_A      K      30          1.821
LGA    F    28_A      F      31          2.006
LGA    P    29_A      N      32          1.722
LGA    N    30_A      -       -           -
LGA    Y    31_A      -       -           -
LGA    F    32_A      G      33          1.698
LGA    Y    33_A      E      34          2.541
LGA    F    34_A      I      35          1.552
LGA    S    35_A      I      36          1.352
LGA    V    36_A      S      37          4.053
LGA    S    37_A      G      38          5.679
LGA    C    38_A      D      39           #
LGA    -       -      S      40           -
LGA    -       -      M      41           -
LGA    -       -      Q      42           -
LGA    T    39_A      V      43          1.361
LGA    T    40_A      Y      44          2.040
LGA    R    41_A      Q      45          3.967
LGA    K    42_A      G      46          1.030
LGA    K    43_A      M      47           #
LGA    R    44_A      D      48          5.292
LGA    E    45_A      I      49           -
LGA    -       -      G      50           -
LGA    -       -      T      51           -
LGA    -       -      A      52           -
LGA    -       -      K      53           -
LGA    -       -      V      54           -
LGA    K    46_A      T      55          5.565
LGA    E    47_A      -       -           -
LGA    K    48_A      T      56          4.675
LGA    E    49_A      E      57           -
LGA    G    50_A      E      58           -
LGA    -       -      M      59           -
LGA    -       -      E      60           -
LGA    -       -      G      61           -
LGA    -       -      I      62           -
LGA    V    51_A      P      63          5.094
LGA    D    52_A      X      64          5.455
LGA    -       -      Y      65           -
LGA    Y    53_A      M      66          4.573
LGA    Y    54_A      I      67          3.490
LGA    F    55_A      D      68          1.867
LGA    -       -      I      69           -
LGA    I    56_A      L      70          1.052
LGA    D    57_A      P      71          1.801
LGA    -       -      P      72           -
LGA    K    58_A      D      73          2.830
LGA    T    59_A      A      74          3.305
LGA    I    60_A      -       -           -
LGA    F    61_A      S      75          3.251
LGA    E    62_A      F      76          5.070
LGA    D    63_A      -       -           -
LGA    K    64_A      -       -           -
LGA    L    65_A      S      77          4.906
LGA    K    66_A      A      78           -
LGA    N    67_A      -       -           -
LGA    E    68_A      Y      79          4.126
LGA    D    69_A      E      80          3.283
LGA    F    70_A      F      81          2.133
LGA    L    71_A      K      82          1.810
LGA    E    72_A      -       -           -
LGA    Y    73_A      -       -           -
LGA    D    74_A      -       -           -
LGA    N    75_A      -       -           -
LGA    Y    76_A      -       -           -
LGA    A    77_A      -       -           -
LGA    N    78_A      -       -           -
LGA    N    79_A      -       -           -
LGA    F    80_A      -       -           -
LGA    Y    81_A      -       -           -
LGA    G    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    L    84_A      -       -           -
LGA    K    85_A      K      83          3.200
LGA    S    86_A      R      84          3.371
LGA    E    87_A      A      85          3.737
LGA    Y    88_A      E      86          3.644
LGA    D    89_A      K      87          2.768
LGA    K    90_A      Y      88          3.308
LGA    -       -      I      89           -
LGA    -       -      K      90           -
LGA    -       -      D      91           -
LGA    A    91_A      I      92          1.426
LGA    K    92_A      T      93          3.052
LGA    E    93_A      R      94          2.872
LGA    Q    94_A      R      95          1.446
LGA    N    95_A      G      96          2.950
LGA    K    96_A      K      97          2.351
LGA    I    97_A      V      98          2.271
LGA    C    98_A      P      99          1.207
LGA    L    99_A      I     100          0.579
LGA    F   100_A      I     101          0.689
LGA    E   101_A      A     102          1.030
LGA    M   102_A      G     103          2.151
LGA    N   103_A      G     104          3.753
LGA    I   104_A      T     105          3.915
LGA    N   105_A      G     106          2.642
LGA    -       -      L     107           -
LGA    G   106_A      Y     108          3.280
LGA    V   107_A      I     109          2.588
LGA    K   108_A      Q     110          3.296
LGA    Q   109_A      S     111          2.978
LGA    L   110_A      L     112          2.772
LGA    K   111_A      L     113          3.713
LGA    K   112_A      Y     114          3.733
LGA    S   113_A      N     115          4.342
LGA    T   114_A      E     194           -
LGA    H   115_A      -       -           -
LGA    I   116_A      N     195          3.364
LGA    K   117_A      Y     196          3.440
LGA    N   118_A      D     197          3.618
LGA    A   119_A      T     198          2.182
LGA    L   120_A      L     199          2.296
LGA    Y   121_A      L     200          1.017
LGA    I   122_A      I     201          1.168
LGA    F   123_A      G     202          1.858
LGA    I   124_A      I     203          1.804
LGA    K   125_A      E     204          1.146
LGA    P   126_A      M     205          1.973
LGA    P   127_A      -       -           -
LGA    S   128_A      S     206          1.133
LGA    T   129_A      R     207          1.282
LGA    D   130_A      E     208          1.200
LGA    V   131_A      T     209          1.033
LGA    L   132_A      L     210          1.299
LGA    L   133_A      Y     211          1.402
LGA    S   134_A      L     212          1.263
LGA    R   135_A      R     213          1.267
LGA    L   136_A      I     214          0.988
LGA    L   137_A      N     215          1.252
LGA    T   138_A      K     216          1.208
LGA    R   139_A      R     217          1.658
LGA    N   140_A      V     218          1.118
LGA    T   141_A      D     219          2.736
LGA    -       -      I     220           -
LGA    -       -      M     221           -
LGA    -       -      L     222           -
LGA    -       -      G     223           -
LGA    -       -      X     224           -
LGA    -       -      G     225           -
LGA    -       -      L     226           -
LGA    -       -      F     227           -
LGA    -       -      N     228           -
LGA    -       -      E     229           -
LGA    -       -      V     230           -
LGA    -       -      Q     231           -
LGA    -       -      X     232           -
LGA    -       -      L     233           -
LGA    -       -      V     234           -
LGA    -       -      E     235           -
LGA    -       -      Q     236           -
LGA    -       -      G     237           -
LGA    -       -      F     238           -
LGA    -       -      E     239           -
LGA    -       -      A     240           -
LGA    -       -      S     241           -
LGA    -       -      Q     242           -
LGA    -       -      S     243           -
LGA    -       -      M     244           -
LGA    -       -      Q     245           -
LGA    -       -      A     246           -
LGA    -       -      I     247           -
LGA    -       -      G     248           -
LGA    -       -      Y     249           -
LGA    -       -      K     250           -
LGA    -       -      E     251           -
LGA    -       -      L     252           -
LGA    -       -      V     253           -
LGA    -       -      P     254           -
LGA    -       -      V     255           -
LGA    -       -      I     256           -
LGA    -       -      K     257           -
LGA    -       -      G     258           -
LGA    -       -      N     259           -
LGA    -       -      I     260           -
LGA    -       -      S     261           -
LGA    -       -      M     262           -
LGA    -       -      E     263           -
LGA    -       -      N     264           -
LGA    E   142_A      A     265           #
LGA    N   143_A      V     266          0.833
LGA    Q   144_A      E     267          0.625
LGA    E   145_A      K     268          1.194
LGA    Q   146_A      L     269          1.509
LGA    I   147_A      K     270          1.119
LGA    Q   148_A      Q     271          0.589
LGA    K   149_A      X     272          0.551
LGA    R   150_A      S     273          0.601
LGA    M   151_A      R     274          0.557
LGA    E   152_A      Q     275          0.514
LGA    Q   153_A      Y     276          0.417
LGA    L   154_A      A     277          1.044
LGA    N   155_A      K     278          1.287
LGA    I   156_A      R     279          0.634
LGA    E   157_A      Q     280          1.316
LGA    L   158_A      L     281          1.780
LGA    H   159_A      T     282          1.469
LGA    E   160_A      W     283          1.117
LGA    A   161_A      F     284          1.956
LGA    N   162_A      K     285          2.143
LGA    L   163_A      N     286          0.585
LGA    L   164_A      K     287          2.239
LGA    N   165_A      M     288          3.232
LGA    F   166_A      N     289          2.230
LGA    N   167_A      V     290          5.071
LGA    L   168_A      X     291          2.029
LGA    S   169_A      W     292          1.996
LGA    I   170_A      L     293          1.725
LGA    I   171_A      N     294          1.031
LGA    N   172_A      K     295          2.126
LGA    D   173_A      E     296          2.690
LGA    -       -      R     297           -
LGA    D   174_A      M     298          2.033
LGA    L   175_A      S     299          0.942
LGA    -       -      L     300           -
LGA    T   176_A      Q     301          3.243
LGA    L   177_A      M     302          2.728
LGA    T   178_A      M     303          2.312
LGA    Y   179_A      L     304          2.215
LGA    Q   180_A      D     305          1.689
LGA    Q   181_A      E     306          1.472
LGA    L   182_A      I     307          1.636
LGA    K   183_A      T     308          1.198
LGA    N   184_A      T     309          0.695
LGA    Y   185_A      Q     310          0.786
LGA    L   186_A      I     311          1.364
LGA    L   187_A      N     312          1.766
LGA    N   188_A      K     313          1.428
LGA    S   189_A      R     314          1.688
LGA    Y   190_A      S     315          3.644
LGA    I   191_A      -       -           -
LGA    H   192_A      -       -           -
LGA    L   193_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  191  232    5.0    158    2.48    13.29     44.935     6.114

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.716627 * X  +   0.434821 * Y  +   0.545322 * Z  +  34.536839
  Y_new =  -0.393111 * X  +   0.394028 * Y  +  -0.830786 * Z  +  61.490147
  Z_new =  -0.576115 * X  +  -0.809736 * Y  +  -0.111439 * Z  + 102.883995 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.707560    1.434032  [ DEG:   -97.8360     82.1640 ]
  Theta =   0.613968    2.527625  [ DEG:    35.1778    144.8222 ]
  Phi   =  -2.639858    0.501735  [ DEG:  -151.2527     28.7473 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z6g_A                                        
REMARK     2: T0416_6_115_194_315.pdb                       
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z6g_A.T0416_6_115_194_315.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  191  232   5.0  158   2.48   13.29  44.935
REMARK  ---------------------------------------------------------- 
MOLECULE 1z6g_A
HEADER    TRANSFERASE                             22-MAR-05   1Z6G              
TITLE     CRYSTAL STRUCTURE OF GUANYLATE KINASE FROM PLASMODIUM                 
TITLE    2 FALCIPARUM                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GUANYLATE KINASE;                                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 2.7.4.8;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PLASMODIUM FALCIPARUM;                          
SOURCE   3 ORGANISM_COMMON: PROTOZOA;                                           
SOURCE   4 STRAIN: 3D7;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: CUSTOM PET-28A                            
KEYWDS    GUANYLATE KINASE, STRUCTURAL GENOMICS, SGC , STRUCTURAL               
KEYWDS   2 GENOMICS CONSORTIUM                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.M.MULICHAK,J.LEW,J.ARTZ,J.CHOE,J.R.WALKER,Y.ZHAO,                   
AUTHOR   2 M.SUNDSTROM,C.ARROWSMITH,A.EDWARDS,A.BOCHKAREV,R.HUI,M.GAO,          
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   3   26-DEC-06 1Z6G    1       JRNL                                     
REVDAT   2   27-SEP-05 1Z6G    1       AUTHOR                                   
REVDAT   1   05-APR-05 1Z6G    0                                                
JRNL        AUTH   M.VEDADI,J.LEW,J.ARTZ,M.AMANI,Y.ZHAO,A.DONG,                 
JRNL        AUTH 2 G.A.WASNEY,M.GAO,T.HILLS,S.BROKX,W.QIU,S.SHARMA,             
JRNL        AUTH 3 A.DIASSITI,Z.ALAM,M.MELONE,A.MULICHAK,A.WERNIMONT,           
JRNL        AUTH 4 J.BRAY,P.LOPPNAU,O.PLOTNIKOVA,K.NEWBERRY,                    
JRNL        AUTH 5 E.SUNDARARAJAN,S.HOUSTON,J.WALKER,W.TEMPEL,                  
JRNL        AUTH 6 A.BOCHKAREV,I.KOZIERADZKI,A.EDWARDS,C.ARROWSMITH,            
JRNL        AUTH 7 D.ROOS,K.KAIN,R.HUI                                          
JRNL        TITL   GENOME-SCALE PROTEIN EXPRESSION AND STRUCTURAL               
JRNL        TITL 2 BIOLOGY OF PLASMODIUM FALCIPARUM AND RELATED                 
JRNL        TITL 3 APICOMPLEXAN ORGANISMS.                                      
JRNL        REF    MOL.BIOCHEM.PARASITOL.        V. 151   100 2007              
JRNL        REFN   ASTM MBIPDP  NE ISSN 0166-6851                               
REMARK   2 RESOLUTION. 2.18 ANGSTROMS.                                          
DBREF  1Z6G A    1   199  UNP    Q8I2M1   Q8I2M1_PLAF7     1    199             
SEQRES   1 A  218  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  218  LEU VAL PRO ARG GLY SER MET ASN ASN ILE TYR PRO LEU          
SEQRES   3 A  218  VAL ILE CYS GLY PRO SER GLY VAL GLY LYS GLY THR LEU          
SEQRES   4 A  218  ILE LYS LYS LEU LEU ASN GLU PHE PRO ASN TYR PHE TYR          
SEQRES   5 A  218  PHE SER VAL SER CYS THR THR ARG LYS LYS ARG GLU LYS          
SEQRES   6 A  218  GLU LYS GLU GLY VAL ASP TYR TYR PHE ILE ASP LYS THR          
SEQRES   7 A  218  ILE PHE GLU ASP LYS LEU LYS ASN GLU ASP PHE LEU GLU          
SEQRES   8 A  218  TYR ASP ASN TYR ALA ASN ASN PHE TYR GLY THR LEU LYS          
SEQRES   9 A  218  SER GLU TYR ASP LYS ALA LYS GLU GLN ASN LYS ILE CYS          
SEQRES  10 A  218  LEU PHE GLU MET ASN ILE ASN GLY VAL LYS GLN LEU LYS          
SEQRES  11 A  218  LYS SER THR HIS ILE LYS ASN ALA LEU TYR ILE PHE ILE          
SEQRES  12 A  218  LYS PRO PRO SER THR ASP VAL LEU LEU SER ARG LEU LEU          
SEQRES  13 A  218  THR ARG ASN THR GLU ASN GLN GLU GLN ILE GLN LYS ARG          
SEQRES  14 A  218  MET GLU GLN LEU ASN ILE GLU LEU HIS GLU ALA ASN LEU          
SEQRES  15 A  218  LEU ASN PHE ASN LEU SER ILE ILE ASN ASP ASP LEU THR          
SEQRES  16 A  218  LEU THR TYR GLN GLN LEU LYS ASN TYR LEU LEU ASN SER          
SEQRES  17 A  218  TYR ILE HIS LEU ASN ASN HIS THR ARG ASN                      
HET    SO4    400       5                                                       
HET    SO4    401       5                                                       
HET    SO4    402       5                                                       
HET    SO4    403       5                                                       
HET    SO4    404       5                                                       
HET    EPE    430      15                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     EPE 4-(2-HYDROXYETHYL)-1-PIPERAZINE ETHANESULFONIC ACID              
HETSYN     EPE HEPES                                                            
FORMUL   2  SO4    5(O4 S 2-)                                                   
FORMUL   7  EPE    C8 H18 N2 O4 S                                               
FORMUL   8  HOH   *131(H2 O)                                                    
CRYST1   41.420   47.240  118.245  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   ASN A   3      13.265 -18.205  19.131  1.00 48.11           N  
ATOM      2  CA  ASN A   3      13.010 -16.895  19.801  1.00 47.74           C  
ATOM      3  C   ASN A   3      11.907 -17.022  20.846  1.00 47.25           C  
ATOM      4  O   ASN A   3      10.769 -17.376  20.529  1.00 48.48           O  
ATOM      5  CB  ASN A   3      12.621 -15.848  18.768  1.00 48.01           C  
ATOM      6  N   ILE A   4      12.248 -16.734  22.097  1.00 45.50           N  
ATOM      7  CA  ILE A   4      11.277 -16.810  23.180  1.00 43.05           C  
ATOM      8  C   ILE A   4      10.424 -15.545  23.151  1.00 41.05           C  
ATOM      9  O   ILE A   4      10.946 -14.433  23.263  1.00 40.55           O  
ATOM     10  CB  ILE A   4      11.975 -16.908  24.552  1.00 43.80           C  
ATOM     11  CG1 ILE A   4      13.025 -18.022  24.524  1.00 43.95           C  
ATOM     12  CG2 ILE A   4      10.945 -17.175  25.638  1.00 43.42           C  
ATOM     13  CD1 ILE A   4      13.824 -18.149  25.801  1.00 45.28           C  
ATOM     14  N   TYR A   5       9.116 -15.718  22.992  1.00 38.31           N  
ATOM     15  CA  TYR A   5       8.200 -14.586  22.947  1.00 36.52           C  
ATOM     16  C   TYR A   5       8.205 -13.855  24.282  1.00 32.89           C  
ATOM     17  O   TYR A   5       8.078 -14.474  25.336  1.00 32.67           O  
ATOM     18  CB  TYR A   5       6.779 -15.060  22.630  1.00 40.47           C  
ATOM     19  CG  TYR A   5       6.666 -15.841  21.343  1.00 45.70           C  
ATOM     20  CD1 TYR A   5       7.289 -15.394  20.178  1.00 48.01           C  
ATOM     21  CD2 TYR A   5       5.918 -17.017  21.282  1.00 48.72           C  
ATOM     22  CE1 TYR A   5       7.170 -16.098  18.978  1.00 50.72           C  
ATOM     23  CE2 TYR A   5       5.790 -17.732  20.085  1.00 51.46           C  
ATOM     24  CZ  TYR A   5       6.419 -17.264  18.937  1.00 51.42           C  
ATOM     25  OH  TYR A   5       6.295 -17.955  17.754  1.00 52.61           O  
ATOM     26  N   PRO A   6       8.366 -12.523  24.256  1.00 29.63           N  
ATOM     27  CA  PRO A   6       8.374 -11.778  25.517  1.00 27.43           C  
ATOM     28  C   PRO A   6       7.008 -11.826  26.197  1.00 24.82           C  
ATOM     29  O   PRO A   6       5.983 -12.028  25.544  1.00 25.09           O  
ATOM     30  CB  PRO A   6       8.740 -10.358  25.083  1.00 27.45           C  
ATOM     31  CG  PRO A   6       9.540 -10.570  23.837  1.00 28.36           C  
ATOM     32  CD  PRO A   6       8.769 -11.659  23.133  1.00 28.33           C  
ATOM     33  N   LEU A   7       7.008 -11.645  27.512  1.00 23.13           N  
ATOM     34  CA  LEU A   7       5.773 -11.632  28.283  1.00 21.53           C  
ATOM     35  C   LEU A   7       5.548 -10.225  28.840  1.00 22.30           C  
ATOM     36  O   LEU A   7       6.401  -9.683  29.545  1.00 22.06           O  
ATOM     37  CB  LEU A   7       5.852 -12.637  29.437  1.00 20.19           C  
ATOM     38  CG  LEU A   7       4.698 -12.582  30.447  1.00 21.64           C  
ATOM     39  CD1 LEU A   7       3.369 -12.791  29.725  1.00 20.36           C  
ATOM     40  CD2 LEU A   7       4.904 -13.649  31.516  1.00 18.35           C  
ATOM     41  N   VAL A   8       4.400  -9.639  28.517  1.00 20.79           N  
ATOM     42  CA  VAL A   8       4.065  -8.307  28.990  1.00 20.21           C  
ATOM     43  C   VAL A   8       2.862  -8.352  29.945  1.00 21.29           C  
ATOM     44  O   VAL A   8       1.760  -8.751  29.557  1.00 18.02           O  
ATOM     45  CB  VAL A   8       3.735  -7.361  27.803  1.00 21.66           C  
ATOM     46  CG1 VAL A   8       3.520  -5.941  28.300  1.00 20.85           C  
ATOM     47  CG2 VAL A   8       4.870  -7.388  26.780  1.00 17.50           C  
ATOM     48  N   ILE A   9       3.097  -7.976  31.201  1.00 18.90           N  
ATOM     49  CA  ILE A   9       2.027  -7.922  32.201  1.00 19.75           C  
ATOM     50  C   ILE A   9       1.708  -6.432  32.244  1.00 20.82           C  
ATOM     51  O   ILE A   9       2.550  -5.617  32.628  1.00 19.36           O  
ATOM     52  CB  ILE A   9       2.510  -8.369  33.599  1.00 22.26           C  
ATOM     53  CG1 ILE A   9       2.977  -9.831  33.558  1.00 24.82           C  
ATOM     54  CG2 ILE A   9       1.392  -8.177  34.620  1.00 23.49           C  
ATOM     55  CD1 ILE A   9       1.899 -10.825  33.165  1.00 28.96           C  
ATOM     56  N   CYS A  10       0.502  -6.064  31.847  1.00 19.40           N  
ATOM     57  CA  CYS A  10       0.184  -4.652  31.811  1.00 21.58           C  
ATOM     58  C   CYS A  10      -1.113  -4.258  32.469  1.00 21.89           C  
ATOM     59  O   CYS A  10      -1.931  -5.101  32.827  1.00 20.36           O  
ATOM     60  CB  CYS A  10       0.160  -4.184  30.364  1.00 21.83           C  
ATOM     61  SG  CYS A  10      -1.051  -5.073  29.392  1.00 25.45           S  
ATOM     62  N   GLY A  11      -1.284  -2.945  32.593  1.00 21.13           N  
ATOM     63  CA  GLY A  11      -2.474  -2.388  33.196  1.00 20.70           C  
ATOM     64  C   GLY A  11      -2.089  -1.102  33.884  1.00 21.57           C  
ATOM     65  O   GLY A  11      -0.896  -0.839  34.074  1.00 21.99           O  
ATOM     66  N   PRO A  12      -3.064  -0.263  34.254  1.00 22.43           N  
ATOM     67  CA  PRO A  12      -2.758   1.001  34.930  1.00 22.04           C  
ATOM     68  C   PRO A  12      -2.163   0.760  36.319  1.00 23.82           C  
ATOM     69  O   PRO A  12      -2.278  -0.334  36.870  1.00 22.38           O  
ATOM     70  CB  PRO A  12      -4.113   1.703  34.975  1.00 23.61           C  
ATOM     71  CG  PRO A  12      -5.100   0.558  35.010  1.00 24.33           C  
ATOM     72  CD  PRO A  12      -4.507  -0.384  33.985  1.00 23.14           C  
ATOM     73  N   SER A  13      -1.514   1.773  36.877  1.00 22.88           N  
ATOM     74  CA  SER A  13      -0.918   1.624  38.191  1.00 26.93           C  
ATOM     75  C   SER A  13      -2.016   1.366  39.219  1.00 26.86           C  
ATOM     76  O   SER A  13      -3.096   1.955  39.145  1.00 27.56           O  
ATOM     77  CB  SER A  13      -0.151   2.886  38.568  1.00 28.74           C  
ATOM     78  OG  SER A  13      -1.052   3.933  38.852  1.00 36.80           O  
ATOM     79  N   GLY A  14      -1.737   0.473  40.165  1.00 26.23           N  
ATOM     80  CA  GLY A  14      -2.704   0.160  41.200  1.00 25.13           C  
ATOM     81  C   GLY A  14      -3.515  -1.108  41.004  1.00 24.76           C  
ATOM     82  O   GLY A  14      -4.324  -1.446  41.870  1.00 24.59           O  
ATOM     83  N   VAL A  15      -3.317  -1.819  39.893  1.00 22.34           N  
ATOM     84  CA  VAL A  15      -4.092  -3.045  39.655  1.00 21.89           C  
ATOM     85  C   VAL A  15      -3.471  -4.304  40.238  1.00 22.00           C  
ATOM     86  O   VAL A  15      -4.073  -5.379  40.167  1.00 24.32           O  
ATOM     87  CB  VAL A  15      -4.337  -3.316  38.147  1.00 21.52           C  
ATOM     88  CG1 VAL A  15      -5.149  -2.184  37.530  1.00 22.91           C  
ATOM     89  CG2 VAL A  15      -3.013  -3.507  37.428  1.00 18.04           C  
ATOM     90  N   GLY A  16      -2.275  -4.185  40.806  1.00 20.55           N  
ATOM     91  CA  GLY A  16      -1.624  -5.347  41.391  1.00 20.57           C  
ATOM     92  C   GLY A  16      -0.590  -6.033  40.501  1.00 20.81           C  
ATOM     93  O   GLY A  16      -0.187  -7.171  40.782  1.00 18.65           O  
ATOM     94  N   LYS A  17      -0.157  -5.361  39.432  1.00 19.13           N  
ATOM     95  CA  LYS A  17       0.849  -5.941  38.537  1.00 20.88           C  
ATOM     96  C   LYS A  17       2.082  -6.378  39.331  1.00 20.66           C  
ATOM     97  O   LYS A  17       2.533  -7.516  39.217  1.00 21.59           O  
ATOM     98  CB  LYS A  17       1.311  -4.931  37.475  1.00 18.85           C  
ATOM     99  CG  LYS A  17       0.250  -4.463  36.504  1.00 19.82           C  
ATOM    100  CD  LYS A  17       0.879  -3.654  35.354  1.00 20.12           C  
ATOM    101  CE  LYS A  17       1.610  -2.408  35.849  1.00 18.42           C  
ATOM    102  NZ  LYS A  17       0.699  -1.433  36.518  1.00 17.14           N  
ATOM    103  N   GLY A  18       2.615  -5.457  40.131  1.00 20.87           N  
ATOM    104  CA  GLY A  18       3.803  -5.734  40.921  1.00 21.58           C  
ATOM    105  C   GLY A  18       3.730  -6.981  41.784  1.00 23.25           C  
ATOM    106  O   GLY A  18       4.665  -7.791  41.798  1.00 22.50           O  
ATOM    107  N   THR A  19       2.623  -7.142  42.504  1.00 22.55           N  
ATOM    108  CA  THR A  19       2.447  -8.299  43.369  1.00 24.21           C  
ATOM    109  C   THR A  19       2.457  -9.592  42.551  1.00 23.32           C  
ATOM    110  O   THR A  19       3.144 -10.560  42.898  1.00 23.00           O  
ATOM    111  CB  THR A  19       1.119  -8.207  44.153  1.00 27.12           C  
ATOM    112  OG1 THR A  19       1.028  -6.922  44.781  1.00 29.46           O  
ATOM    113  CG2 THR A  19       1.062  -9.287  45.237  1.00 26.30           C  
ATOM    114  N   LEU A  20       1.695  -9.602  41.463  1.00 22.66           N  
ATOM    115  CA  LEU A  20       1.617 -10.765  40.596  1.00 21.93           C  
ATOM    116  C   LEU A  20       2.975 -11.128  40.010  1.00 22.13           C  
ATOM    117  O   LEU A  20       3.356 -12.298  39.989  1.00 21.31           O  
ATOM    118  CB  LEU A  20       0.616 -10.514  39.461  1.00 21.64           C  
ATOM    119  CG  LEU A  20      -0.859 -10.517  39.874  1.00 23.09           C  
ATOM    120  CD1 LEU A  20      -1.741 -10.099  38.701  1.00 23.67           C  
ATOM    121  CD2 LEU A  20      -1.240 -11.917  40.360  1.00 22.90           C  
ATOM    122  N   ILE A  21       3.708 -10.128  39.536  1.00 21.91           N  
ATOM    123  CA  ILE A  21       5.018 -10.383  38.950  1.00 21.03           C  
ATOM    124  C   ILE A  21       6.012 -10.930  39.982  1.00 22.56           C  
ATOM    125  O   ILE A  21       6.800 -11.829  39.675  1.00 21.91           O  
ATOM    126  CB  ILE A  21       5.577  -9.098  38.289  1.00 21.65           C  
ATOM    127  CG1 ILE A  21       4.703  -8.733  37.078  1.00 21.47           C  
ATOM    128  CG2 ILE A  21       7.015  -9.311  37.836  1.00 20.03           C  
ATOM    129  CD1 ILE A  21       5.019  -7.375  36.467  1.00 21.03           C  
ATOM    130  N   LYS A  22       5.972 -10.410  41.206  1.00 22.76           N  
ATOM    131  CA  LYS A  22       6.893 -10.893  42.230  1.00 24.11           C  
ATOM    132  C   LYS A  22       6.663 -12.368  42.529  1.00 22.86           C  
ATOM    133  O   LYS A  22       7.621 -13.128  42.675  1.00 22.18           O  
ATOM    134  CB  LYS A  22       6.783 -10.078  43.522  1.00 27.69           C  
ATOM    135  CG  LYS A  22       7.785 -10.537  44.580  1.00 31.29           C  
ATOM    136  CD  LYS A  22       8.062  -9.478  45.623  1.00 36.18           C  
ATOM    137  CE  LYS A  22       9.281  -9.856  46.459  1.00 38.63           C  
ATOM    138  NZ  LYS A  22       9.681  -8.770  47.400  1.00 43.02           N  
ATOM    139  N   LYS A  23       5.400 -12.773  42.617  1.00 24.67           N  
ATOM    140  CA  LYS A  23       5.075 -14.173  42.875  1.00 24.11           C  
ATOM    141  C   LYS A  23       5.611 -15.012  41.723  1.00 24.36           C  
ATOM    142  O   LYS A  23       6.225 -16.062  41.929  1.00 23.04           O  
ATOM    143  CB  LYS A  23       3.561 -14.373  42.979  1.00 25.29           C  
ATOM    144  CG  LYS A  23       2.922 -13.710  44.189  1.00 30.98           C  
ATOM    145  CD  LYS A  23       1.408 -13.882  44.189  1.00 34.64           C  
ATOM    146  CE  LYS A  23       1.002 -15.350  44.248  1.00 33.81           C  
ATOM    147  NZ  LYS A  23       1.489 -16.003  45.493  1.00 38.38           N  
ATOM    148  N   LEU A  24       5.396 -14.523  40.505  1.00 21.98           N  
ATOM    149  CA  LEU A  24       5.832 -15.236  39.313  1.00 22.29           C  
ATOM    150  C   LEU A  24       7.345 -15.440  39.289  1.00 21.72           C  
ATOM    151  O   LEU A  24       7.831 -16.548  39.056  1.00 23.77           O  
ATOM    152  CB  LEU A  24       5.388 -14.468  38.071  1.00 25.53           C  
ATOM    153  CG  LEU A  24       5.361 -15.243  36.760  1.00 30.25           C  
ATOM    154  CD1 LEU A  24       4.337 -16.379  36.852  1.00 28.98           C  
ATOM    155  CD2 LEU A  24       5.004 -14.277  35.625  1.00 29.45           C  
ATOM    156  N   LEU A  25       8.089 -14.368  39.531  1.00 19.80           N  
ATOM    157  CA  LEU A  25       9.545 -14.436  39.539  1.00 20.53           C  
ATOM    158  C   LEU A  25      10.056 -15.315  40.679  1.00 22.17           C  
ATOM    159  O   LEU A  25      11.049 -16.027  40.524  1.00 19.92           O  
ATOM    160  CB  LEU A  25      10.129 -13.029  39.665  1.00 19.81           C  
ATOM    161  CG  LEU A  25       9.830 -12.066  38.503  1.00 18.10           C  
ATOM    162  CD1 LEU A  25      10.421 -10.701  38.809  1.00 18.48           C  
ATOM    163  CD2 LEU A  25      10.424 -12.618  37.208  1.00 20.01           C  
ATOM    164  N   ASN A  26       9.378 -15.257  41.824  1.00 23.02           N  
ATOM    165  CA  ASN A  26       9.769 -16.057  42.978  1.00 26.11           C  
ATOM    166  C   ASN A  26       9.566 -17.537  42.683  1.00 26.38           C  
ATOM    167  O   ASN A  26      10.380 -18.369  43.081  1.00 26.24           O  
ATOM    168  CB  ASN A  26       8.939 -15.690  44.214  1.00 27.37           C  
ATOM    169  CG  ASN A  26       9.302 -14.333  44.795  1.00 32.18           C  
ATOM    170  OD1 ASN A  26       8.648 -13.858  45.733  1.00 34.96           O  
ATOM    171  ND2 ASN A  26      10.341 -13.704  44.255  1.00 30.77           N  
ATOM    172  N   GLU A  27       8.482 -17.855  41.982  1.00 25.82           N  
ATOM    173  CA  GLU A  27       8.148 -19.239  41.659  1.00 25.90           C  
ATOM    174  C   GLU A  27       8.889 -19.845  40.465  1.00 26.02           C  
ATOM    175  O   GLU A  27       9.135 -21.049  40.441  1.00 25.08           O  
ATOM    176  CB  GLU A  27       6.635 -19.380  41.447  1.00 27.14           C  
ATOM    177  CG  GLU A  27       6.201 -20.810  41.145  1.00 29.87           C  
ATOM    178  CD  GLU A  27       4.717 -21.045  41.366  1.00 31.77           C  
ATOM    179  OE1 GLU A  27       3.987 -20.079  41.670  1.00 31.93           O  
ATOM    180  OE2 GLU A  27       4.282 -22.206  41.230  1.00 32.33           O  
ATOM    181  N   PHE A  28       9.238 -19.024  39.476  1.00 23.83           N  
ATOM    182  CA  PHE A  28       9.958 -19.506  38.302  1.00 22.82           C  
ATOM    183  C   PHE A  28      11.185 -18.629  38.054  1.00 23.76           C  
ATOM    184  O   PHE A  28      11.376 -18.094  36.958  1.00 22.24           O  
ATOM    185  CB  PHE A  28       9.035 -19.496  37.079  1.00 23.94           C  
ATOM    186  CG  PHE A  28       7.744 -20.248  37.289  1.00 23.51           C  
ATOM    187  CD1 PHE A  28       6.593 -19.583  37.703  1.00 22.26           C  
ATOM    188  CD2 PHE A  28       7.691 -21.628  37.106  1.00 23.38           C  
ATOM    189  CE1 PHE A  28       5.401 -20.283  37.931  1.00 23.85           C  
ATOM    190  CE2 PHE A  28       6.508 -22.336  37.332  1.00 25.24           C  
ATOM    191  CZ  PHE A  28       5.363 -21.663  37.745  1.00 22.90           C  
ATOM    192  N   PRO A  29      12.053 -18.500  39.071  1.00 23.49           N  
ATOM    193  CA  PRO A  29      13.266 -17.686  38.992  1.00 23.93           C  
ATOM    194  C   PRO A  29      14.235 -17.999  37.867  1.00 23.90           C  
ATOM    195  O   PRO A  29      14.927 -17.108  37.384  1.00 24.77           O  
ATOM    196  CB  PRO A  29      13.897 -17.869  40.372  1.00 25.14           C  
ATOM    197  CG  PRO A  29      13.456 -19.256  40.763  1.00 25.53           C  
ATOM    198  CD  PRO A  29      12.014 -19.261  40.337  1.00 24.83           C  
ATOM    199  N   ASN A  30      14.288 -19.246  37.428  1.00 24.93           N  
ATOM    200  CA  ASN A  30      15.224 -19.584  36.365  1.00 27.30           C  
ATOM    201  C   ASN A  30      14.648 -19.423  34.957  1.00 26.31           C  
ATOM    202  O   ASN A  30      15.339 -19.662  33.972  1.00 26.33           O  
ATOM    203  CB  ASN A  30      15.744 -21.014  36.563  1.00 30.02           C  
ATOM    204  CG  ASN A  30      17.118 -21.226  35.942  1.00 32.43           C  
ATOM    205  OD1 ASN A  30      18.027 -20.413  36.127  1.00 36.04           O  
ATOM    206  ND2 ASN A  30      17.277 -22.322  35.211  1.00 33.85           N  
ATOM    207  N   TYR A  31      13.394 -18.994  34.852  1.00 24.77           N  
ATOM    208  CA  TYR A  31      12.778 -18.842  33.538  1.00 26.54           C  
ATOM    209  C   TYR A  31      12.669 -17.413  33.021  1.00 25.56           C  
ATOM    210  O   TYR A  31      12.522 -17.200  31.818  1.00 23.98           O  
ATOM    211  CB  TYR A  31      11.368 -19.438  33.530  1.00 28.22           C  
ATOM    212  CG  TYR A  31      11.301 -20.940  33.667  1.00 33.22           C  
ATOM    213  CD1 TYR A  31      11.345 -21.552  34.921  1.00 33.49           C  
ATOM    214  CD2 TYR A  31      11.171 -21.753  32.543  1.00 34.99           C  
ATOM    215  CE1 TYR A  31      11.253 -22.935  35.053  1.00 36.07           C  
ATOM    216  CE2 TYR A  31      11.081 -23.144  32.665  1.00 37.93           C  
ATOM    217  CZ  TYR A  31      11.120 -23.724  33.923  1.00 36.83           C  
ATOM    218  OH  TYR A  31      11.006 -25.093  34.055  1.00 40.12           O  
ATOM    219  N   PHE A  32      12.755 -16.437  33.916  1.00 23.31           N  
ATOM    220  CA  PHE A  32      12.566 -15.052  33.504  1.00 23.81           C  
ATOM    221  C   PHE A  32      13.710 -14.076  33.651  1.00 22.47           C  
ATOM    222  O   PHE A  32      14.593 -14.242  34.487  1.00 22.34           O  
ATOM    223  CB  PHE A  32      11.370 -14.461  34.266  1.00 23.78           C  
ATOM    224  CG  PHE A  32      10.050 -15.071  33.906  1.00 23.06           C  
ATOM    225  CD1 PHE A  32       9.473 -14.829  32.665  1.00 21.66           C  
ATOM    226  CD2 PHE A  32       9.381 -15.896  34.809  1.00 24.40           C  
ATOM    227  CE1 PHE A  32       8.246 -15.398  32.325  1.00 21.00           C  
ATOM    228  CE2 PHE A  32       8.151 -16.473  34.478  1.00 24.17           C  
ATOM    229  CZ  PHE A  32       7.584 -16.224  33.235  1.00 22.84           C  
ATOM    230  N   TYR A  33      13.670 -13.051  32.806  1.00 22.47           N  
ATOM    231  CA  TYR A  33      14.608 -11.946  32.873  1.00 21.62           C  
ATOM    232  C   TYR A  33      13.663 -10.755  33.025  1.00 22.22           C  
ATOM    233  O   TYR A  33      12.932 -10.426  32.092  1.00 21.11           O  
ATOM    234  CB  TYR A  33      15.420 -11.756  31.591  1.00 21.58           C  
ATOM    235  CG  TYR A  33      16.216 -10.470  31.664  1.00 23.70           C  
ATOM    236  CD1 TYR A  33      17.402 -10.401  32.396  1.00 24.97           C  
ATOM    237  CD2 TYR A  33      15.714  -9.287  31.115  1.00 24.89           C  
ATOM    238  CE1 TYR A  33      18.067  -9.186  32.591  1.00 25.77           C  
ATOM    239  CE2 TYR A  33      16.368  -8.067  31.303  1.00 25.96           C  
ATOM    240  CZ  TYR A  33      17.543  -8.021  32.042  1.00 27.67           C  
ATOM    241  OH  TYR A  33      18.186  -6.810  32.237  1.00 26.86           O  
ATOM    242  N   PHE A  34      13.660 -10.127  34.199  1.00 22.59           N  
ATOM    243  CA  PHE A  34      12.780  -8.992  34.456  1.00 21.83           C  
ATOM    244  C   PHE A  34      13.367  -7.707  33.870  1.00 23.19           C  
ATOM    245  O   PHE A  34      14.448  -7.268  34.261  1.00 21.77           O  
ATOM    246  CB  PHE A  34      12.573  -8.818  35.963  1.00 23.19           C  
ATOM    247  CG  PHE A  34      11.442  -7.893  36.320  1.00 26.02           C  
ATOM    248  CD1 PHE A  34      11.439  -7.220  37.537  1.00 26.64           C  
ATOM    249  CD2 PHE A  34      10.378  -7.691  35.441  1.00 25.74           C  
ATOM    250  CE1 PHE A  34      10.398  -6.355  37.875  1.00 29.44           C  
ATOM    251  CE2 PHE A  34       9.333  -6.831  35.769  1.00 27.36           C  
ATOM    252  CZ  PHE A  34       9.344  -6.160  36.990  1.00 26.96           C  
ATOM    253  N   SER A  35      12.645  -7.104  32.931  1.00 22.45           N  
ATOM    254  CA  SER A  35      13.108  -5.874  32.305  1.00 23.47           C  
ATOM    255  C   SER A  35      13.236  -4.726  33.306  1.00 23.52           C  
ATOM    256  O   SER A  35      12.363  -4.519  34.142  1.00 22.68           O  
ATOM    257  CB  SER A  35      12.152  -5.465  31.188  1.00 23.30           C  
ATOM    258  OG  SER A  35      12.578  -4.256  30.593  1.00 28.50           O  
ATOM    259  N   VAL A  36      14.337  -3.987  33.212  1.00 24.65           N  
ATOM    260  CA  VAL A  36      14.586  -2.839  34.077  1.00 24.34           C  
ATOM    261  C   VAL A  36      14.514  -1.572  33.221  1.00 25.55           C  
ATOM    262  O   VAL A  36      15.135  -1.490  32.154  1.00 24.02           O  
ATOM    263  CB  VAL A  36      15.977  -2.926  34.732  1.00 25.52           C  
ATOM    264  CG1 VAL A  36      16.300  -1.624  35.449  1.00 24.39           C  
ATOM    265  CG2 VAL A  36      16.015  -4.095  35.715  1.00 24.79           C  
ATOM    266  N   SER A  37      13.755  -0.590  33.693  1.00 24.72           N  
ATOM    267  CA  SER A  37      13.587   0.665  32.965  1.00 27.28           C  
ATOM    268  C   SER A  37      14.582   1.757  33.346  1.00 27.25           C  
ATOM    269  O   SER A  37      15.284   1.665  34.358  1.00 26.64           O  
ATOM    270  CB  SER A  37      12.164   1.206  33.174  1.00 27.00           C  
ATOM    271  OG  SER A  37      11.198   0.340  32.610  1.00 29.83           O  
ATOM    272  N   CYS A  38      14.632   2.783  32.502  1.00 26.52           N  
ATOM    273  CA  CYS A  38      15.485   3.945  32.714  1.00 27.00           C  
ATOM    274  C   CYS A  38      14.586   5.042  33.244  1.00 26.39           C  
ATOM    275  O   CYS A  38      13.398   5.096  32.903  1.00 25.10           O  
ATOM    276  CB  CYS A  38      16.069   4.465  31.397  1.00 26.84           C  
ATOM    277  SG  CYS A  38      17.192   3.393  30.521  1.00 34.85           S  
ATOM    278  N   THR A  39      15.145   5.927  34.058  1.00 24.28           N  
ATOM    279  CA  THR A  39      14.375   7.051  34.555  1.00 23.96           C  
ATOM    280  C   THR A  39      15.292   8.227  34.833  1.00 24.78           C  
ATOM    281  O   THR A  39      16.457   8.036  35.174  1.00 24.27           O  
ATOM    282  CB  THR A  39      13.625   6.722  35.841  1.00 24.00           C  
ATOM    283  OG1 THR A  39      12.808   7.843  36.190  1.00 22.43           O  
ATOM    284  CG2 THR A  39      14.608   6.425  36.981  1.00 19.27           C  
ATOM    285  N   THR A  40      14.767   9.442  34.668  1.00 24.78           N  
ATOM    286  CA  THR A  40      15.548  10.637  34.938  1.00 25.48           C  
ATOM    287  C   THR A  40      15.289  11.077  36.370  1.00 25.89           C  
ATOM    288  O   THR A  40      15.930  11.991  36.871  1.00 26.83           O  
ATOM    289  CB  THR A  40      15.197  11.797  33.977  1.00 23.70           C  
ATOM    290  OG1 THR A  40      13.787  12.053  34.013  1.00 21.87           O  
ATOM    291  CG2 THR A  40      15.626  11.448  32.555  1.00 24.59           C  
ATOM    292  N   ARG A  41      14.343  10.420  37.031  1.00 26.65           N  
ATOM    293  CA  ARG A  41      14.041  10.751  38.413  1.00 27.64           C  
ATOM    294  C   ARG A  41      15.274  10.438  39.245  1.00 29.37           C  
ATOM    295  O   ARG A  41      16.036   9.525  38.918  1.00 29.88           O  
ATOM    296  CB  ARG A  41      12.850   9.935  38.925  1.00 25.88           C  
ATOM    297  CG  ARG A  41      12.609  10.095  40.412  1.00 27.22           C  
ATOM    298  CD  ARG A  41      11.295   9.490  40.863  1.00 28.20           C  
ATOM    299  NE  ARG A  41      11.216   8.036  40.716  1.00 28.83           N  
ATOM    300  CZ  ARG A  41      12.015   7.160  41.321  1.00 31.16           C  
ATOM    301  NH1 ARG A  41      11.837   5.862  41.119  1.00 30.93           N  
ATOM    302  NH2 ARG A  41      13.000   7.569  42.112  1.00 32.72           N  
ATOM    303  N   LYS A  42      15.479  11.193  40.316  1.00 31.56           N  
ATOM    304  CA  LYS A  42      16.638  10.951  41.158  1.00 32.98           C  
ATOM    305  C   LYS A  42      16.438   9.684  41.973  1.00 33.06           C  
ATOM    306  O   LYS A  42      15.343   9.418  42.483  1.00 31.68           O  
ATOM    307  CB  LYS A  42      16.890  12.122  42.108  1.00 35.47           C  
ATOM    308  CG  LYS A  42      18.149  11.920  42.936  1.00 36.39           C  
ATOM    309  CD  LYS A  42      18.297  12.949  44.028  1.00 37.80           C  
ATOM    310  CE  LYS A  42      19.526  12.629  44.857  1.00 36.20           C  
ATOM    311  NZ  LYS A  42      19.436  11.244  45.397  1.00 35.42           N  
ATOM    312  N   LYS A  43      17.509   8.907  42.090  1.00 34.04           N  
ATOM    313  CA  LYS A  43      17.487   7.665  42.845  1.00 35.26           C  
ATOM    314  C   LYS A  43      17.220   7.932  44.323  1.00 35.80           C  
ATOM    315  O   LYS A  43      17.887   8.763  44.937  1.00 34.55           O  
ATOM    316  CB  LYS A  43      18.826   6.943  42.681  1.00 34.63           C  
ATOM    317  CG  LYS A  43      18.905   5.628  43.429  1.00 36.45           C  
ATOM    318  CD  LYS A  43      20.149   4.837  43.048  1.00 37.05           C  
ATOM    319  CE  LYS A  43      21.423   5.577  43.415  1.00 39.80           C  
ATOM    320  NZ  LYS A  43      22.629   4.814  42.978  1.00 41.04           N  
ATOM    321  N   ARG A  44      16.230   7.242  44.884  1.00 36.88           N  
ATOM    322  CA  ARG A  44      15.895   7.395  46.299  1.00 39.29           C  
ATOM    323  C   ARG A  44      16.901   6.609  47.136  1.00 40.08           C  
ATOM    324  O   ARG A  44      17.694   5.840  46.595  1.00 40.69           O  
ATOM    325  CB  ARG A  44      14.493   6.864  46.580  1.00 40.45           C  
ATOM    326  CG  ARG A  44      13.395   7.631  45.888  1.00 43.87           C  
ATOM    327  CD  ARG A  44      12.149   6.781  45.801  1.00 46.50           C  
ATOM    328  NE  ARG A  44      11.152   7.370  44.917  1.00 49.25           N  
ATOM    329  CZ  ARG A  44      10.111   6.707  44.431  1.00 49.67           C  
ATOM    330  NH1 ARG A  44       9.249   7.321  43.633  1.00 51.19           N  
ATOM    331  NH2 ARG A  44       9.936   5.428  44.737  1.00 50.91           N  
ATOM    332  N   GLU A  45      16.853   6.792  48.453  1.00 41.21           N  
ATOM    333  CA  GLU A  45      17.777   6.112  49.357  1.00 43.04           C  
ATOM    334  C   GLU A  45      17.806   4.594  49.223  1.00 42.71           C  
ATOM    335  O   GLU A  45      18.862   4.012  48.996  1.00 43.03           O  
ATOM    336  CB  GLU A  45      17.462   6.471  50.809  1.00 45.42           C  
ATOM    337  CG  GLU A  45      17.523   7.954  51.112  1.00 49.01           C  
ATOM    338  CD  GLU A  45      17.499   8.237  52.601  1.00 50.75           C  
ATOM    339  OE1 GLU A  45      16.643   7.651  53.300  1.00 51.67           O  
ATOM    340  OE2 GLU A  45      18.332   9.046  53.070  1.00 50.22           O  
ATOM    341  N   LYS A  46      16.649   3.955  49.366  1.00 43.26           N  
ATOM    342  CA  LYS A  46      16.565   2.498  49.286  1.00 43.00           C  
ATOM    343  C   LYS A  46      16.653   1.920  47.872  1.00 43.73           C  
ATOM    344  O   LYS A  46      16.778   0.703  47.703  1.00 44.28           O  
ATOM    345  CB  LYS A  46      15.280   2.023  49.958  1.00 43.47           C  
ATOM    346  N   GLU A  47      16.594   2.776  46.857  1.00 42.65           N  
ATOM    347  CA  GLU A  47      16.659   2.298  45.479  1.00 41.90           C  
ATOM    348  C   GLU A  47      18.041   1.822  45.034  1.00 41.22           C  
ATOM    349  O   GLU A  47      19.068   2.367  45.441  1.00 42.50           O  
ATOM    350  CB  GLU A  47      16.131   3.372  44.530  1.00 41.69           C  
ATOM    351  CG  GLU A  47      14.636   3.259  44.298  1.00 41.52           C  
ATOM    352  CD  GLU A  47      14.088   4.362  43.420  1.00 42.66           C  
ATOM    353  OE1 GLU A  47      12.997   4.169  42.845  1.00 44.25           O  
ATOM    354  OE2 GLU A  47      14.738   5.422  43.311  1.00 42.99           O  
ATOM    355  N   LYS A  48      18.049   0.801  44.181  1.00 40.45           N  
ATOM    356  CA  LYS A  48      19.282   0.200  43.678  1.00 39.61           C  
ATOM    357  C   LYS A  48      19.459   0.372  42.171  1.00 38.47           C  
ATOM    358  O   LYS A  48      18.588  -0.003  41.390  1.00 39.07           O  
ATOM    359  CB  LYS A  48      19.277  -1.294  44.014  1.00 40.50           C  
ATOM    360  CG  LYS A  48      20.529  -2.056  43.623  1.00 42.21           C  
ATOM    361  CD  LYS A  48      21.650  -1.795  44.604  1.00 43.25           C  
ATOM    362  CE  LYS A  48      22.794  -2.772  44.408  1.00 41.68           C  
ATOM    363  NZ  LYS A  48      23.951  -2.377  45.255  1.00 41.39           N  
ATOM    364  N   GLU A  49      20.597   0.926  41.770  1.00 37.26           N  
ATOM    365  CA  GLU A  49      20.904   1.129  40.356  1.00 37.07           C  
ATOM    366  C   GLU A  49      20.927  -0.213  39.628  1.00 36.52           C  
ATOM    367  O   GLU A  49      21.482  -1.189  40.128  1.00 36.65           O  
ATOM    368  CB  GLU A  49      22.266   1.815  40.221  1.00 37.88           C  
ATOM    369  CG  GLU A  49      22.821   1.906  38.805  1.00 40.33           C  
ATOM    370  CD  GLU A  49      22.031   2.844  37.910  1.00 42.56           C  
ATOM    371  OE1 GLU A  49      21.542   3.880  38.412  1.00 44.06           O  
ATOM    372  OE2 GLU A  49      21.917   2.555  36.700  1.00 42.78           O  
ATOM    373  N   GLY A  50      20.323  -0.266  38.447  1.00 35.38           N  
ATOM    374  CA  GLY A  50      20.308  -1.508  37.695  1.00 34.78           C  
ATOM    375  C   GLY A  50      19.259  -2.493  38.173  1.00 33.50           C  
ATOM    376  O   GLY A  50      19.039  -3.518  37.533  1.00 34.28           O  
ATOM    377  N   VAL A  51      18.613  -2.196  39.299  1.00 33.33           N  
ATOM    378  CA  VAL A  51      17.570  -3.071  39.836  1.00 32.49           C  
ATOM    379  C   VAL A  51      16.216  -2.377  39.738  1.00 31.08           C  
ATOM    380  O   VAL A  51      15.356  -2.790  38.968  1.00 29.78           O  
ATOM    381  CB  VAL A  51      17.840  -3.449  41.312  1.00 33.29           C  
ATOM    382  CG1 VAL A  51      16.669  -4.242  41.868  1.00 34.28           C  
ATOM    383  CG2 VAL A  51      19.113  -4.281  41.408  1.00 34.80           C  
ATOM    384  N   ASP A  52      16.030  -1.323  40.524  1.00 30.21           N  
ATOM    385  CA  ASP A  52      14.784  -0.572  40.487  1.00 31.24           C  
ATOM    386  C   ASP A  52      14.659   0.085  39.113  1.00 29.76           C  
ATOM    387  O   ASP A  52      13.625  -0.021  38.452  1.00 28.68           O  
ATOM    388  CB  ASP A  52      14.789   0.496  41.582  1.00 34.31           C  
ATOM    389  CG  ASP A  52      14.744  -0.103  42.975  1.00 35.73           C  
ATOM    390  OD1 ASP A  52      13.628  -0.285  43.509  1.00 38.09           O  
ATOM    391  OD2 ASP A  52      15.822  -0.407  43.526  1.00 37.68           O  
ATOM    392  N   TYR A  53      15.730   0.755  38.697  1.00 29.06           N  
ATOM    393  CA  TYR A  53      15.796   1.440  37.404  1.00 28.96           C  
ATOM    394  C   TYR A  53      17.246   1.674  37.039  1.00 28.70           C  
ATOM    395  O   TYR A  53      18.154   1.388  37.813  1.00 28.43           O  
ATOM    396  CB  TYR A  53      15.178   2.846  37.456  1.00 25.85           C  
ATOM    397  CG  TYR A  53      13.696   2.935  37.681  1.00 26.14           C  
ATOM    398  CD1 TYR A  53      13.169   2.977  38.970  1.00 25.55           C  
ATOM    399  CD2 TYR A  53      12.818   3.003  36.604  1.00 25.55           C  
ATOM    400  CE1 TYR A  53      11.801   3.086  39.181  1.00 26.79           C  
ATOM    401  CE2 TYR A  53      11.445   3.114  36.802  1.00 25.09           C  
ATOM    402  CZ  TYR A  53      10.947   3.155  38.092  1.00 26.74           C  
ATOM    403  OH  TYR A  53       9.595   3.281  38.297  1.00 29.25           O  
ATOM    404  N   TYR A  54      17.436   2.210  35.840  1.00 29.96           N  
ATOM    405  CA  TYR A  54      18.748   2.627  35.374  1.00 29.91           C  
ATOM    406  C   TYR A  54      18.559   4.134  35.541  1.00 29.62           C  
ATOM    407  O   TYR A  54      17.826   4.760  34.765  1.00 28.30           O  
ATOM    408  CB  TYR A  54      18.959   2.313  33.891  1.00 30.53           C  
ATOM    409  CG  TYR A  54      19.159   0.851  33.568  1.00 32.17           C  
ATOM    410  CD1 TYR A  54      20.230   0.136  34.106  1.00 31.14           C  
ATOM    411  CD2 TYR A  54      18.287   0.184  32.708  1.00 31.39           C  
ATOM    412  CE1 TYR A  54      20.424  -1.211  33.794  1.00 31.61           C  
ATOM    413  CE2 TYR A  54      18.472  -1.158  32.393  1.00 33.13           C  
ATOM    414  CZ  TYR A  54      19.539  -1.850  32.939  1.00 31.87           C  
ATOM    415  OH  TYR A  54      19.706  -3.184  32.635  1.00 33.24           O  
ATOM    416  N   PHE A  55      19.178   4.713  36.563  1.00 29.40           N  
ATOM    417  CA  PHE A  55      19.042   6.141  36.799  1.00 29.11           C  
ATOM    418  C   PHE A  55      20.000   6.951  35.931  1.00 30.63           C  
ATOM    419  O   PHE A  55      21.213   6.898  36.107  1.00 32.65           O  
ATOM    420  CB  PHE A  55      19.267   6.465  38.280  1.00 26.94           C  
ATOM    421  CG  PHE A  55      18.308   5.765  39.205  1.00 27.23           C  
ATOM    422  CD1 PHE A  55      18.575   4.479  39.667  1.00 26.06           C  
ATOM    423  CD2 PHE A  55      17.119   6.378  39.590  1.00 26.63           C  
ATOM    424  CE1 PHE A  55      17.671   3.815  40.499  1.00 25.74           C  
ATOM    425  CE2 PHE A  55      16.210   5.723  40.421  1.00 25.45           C  
ATOM    426  CZ  PHE A  55      16.489   4.435  40.876  1.00 25.82           C  
ATOM    427  N   ILE A  56      19.441   7.695  34.981  1.00 31.04           N  
ATOM    428  CA  ILE A  56      20.241   8.529  34.091  1.00 32.87           C  
ATOM    429  C   ILE A  56      19.663   9.940  34.119  1.00 33.52           C  
ATOM    430  O   ILE A  56      18.667  10.189  34.798  1.00 33.90           O  
ATOM    431  CB  ILE A  56      20.213   7.988  32.645  1.00 31.08           C  
ATOM    432  CG1 ILE A  56      18.772   7.938  32.129  1.00 32.76           C  
ATOM    433  CG2 ILE A  56      20.820   6.599  32.600  1.00 31.23           C  
ATOM    434  CD1 ILE A  56      18.647   7.397  30.714  1.00 31.78           C  
ATOM    435  N   ASP A  57      20.287  10.870  33.405  1.00 34.99           N  
ATOM    436  CA  ASP A  57      19.772  12.240  33.383  1.00 36.38           C  
ATOM    437  C   ASP A  57      19.093  12.575  32.063  1.00 35.68           C  
ATOM    438  O   ASP A  57      19.112  11.784  31.122  1.00 34.67           O  
ATOM    439  CB  ASP A  57      20.884  13.253  33.667  1.00 38.58           C  
ATOM    440  CG  ASP A  57      22.131  12.979  32.875  1.00 39.63           C  
ATOM    441  OD1 ASP A  57      22.006  12.579  31.703  1.00 42.00           O  
ATOM    442  OD2 ASP A  57      23.237  13.173  33.425  1.00 42.90           O  
ATOM    443  N   LYS A  58      18.485  13.753  32.006  1.00 36.51           N  
ATOM    444  CA  LYS A  58      17.773  14.193  30.816  1.00 37.17           C  
ATOM    445  C   LYS A  58      18.597  14.181  29.535  1.00 37.89           C  
ATOM    446  O   LYS A  58      18.095  13.802  28.480  1.00 38.76           O  
ATOM    447  CB  LYS A  58      17.189  15.588  31.048  1.00 37.09           C  
ATOM    448  CG  LYS A  58      16.004  15.585  32.001  1.00 39.41           C  
ATOM    449  CD  LYS A  58      15.462  16.978  32.250  1.00 39.34           C  
ATOM    450  CE  LYS A  58      16.381  17.777  33.152  1.00 39.43           C  
ATOM    451  NZ  LYS A  58      15.770  19.086  33.478  1.00 40.83           N  
ATOM    452  N   THR A  59      19.860  14.581  29.616  1.00 38.61           N  
ATOM    453  CA  THR A  59      20.690  14.613  28.422  1.00 39.77           C  
ATOM    454  C   THR A  59      20.842  13.221  27.820  1.00 39.28           C  
ATOM    455  O   THR A  59      20.665  13.031  26.616  1.00 38.99           O  
ATOM    456  CB  THR A  59      22.089  15.218  28.714  1.00 41.58           C  
ATOM    457  OG1 THR A  59      22.816  15.361  27.485  1.00 43.46           O  
ATOM    458  CG2 THR A  59      22.879  14.326  29.650  1.00 43.01           C  
ATOM    459  N   ILE A  60      21.155  12.241  28.657  1.00 39.08           N  
ATOM    460  CA  ILE A  60      21.321  10.879  28.173  1.00 37.33           C  
ATOM    461  C   ILE A  60      19.993  10.328  27.648  1.00 35.82           C  
ATOM    462  O   ILE A  60      19.956   9.673  26.607  1.00 33.75           O  
ATOM    463  CB  ILE A  60      21.864   9.959  29.291  1.00 39.67           C  
ATOM    464  CG1 ILE A  60      23.253  10.442  29.718  1.00 40.75           C  
ATOM    465  CG2 ILE A  60      21.937   8.516  28.799  1.00 39.50           C  
ATOM    466  CD1 ILE A  60      23.914   9.571  30.780  1.00 43.69           C  
ATOM    467  N   PHE A  61      18.906  10.608  28.360  1.00 33.26           N  
ATOM    468  CA  PHE A  61      17.589  10.133  27.945  1.00 32.81           C  
ATOM    469  C   PHE A  61      17.236  10.691  26.566  1.00 32.44           C  
ATOM    470  O   PHE A  61      16.681   9.987  25.720  1.00 30.54           O  
ATOM    471  CB  PHE A  61      16.525  10.565  28.951  1.00 33.71           C  
ATOM    472  CG  PHE A  61      15.262   9.749  28.887  1.00 34.70           C  
ATOM    473  CD1 PHE A  61      15.077   8.663  29.736  1.00 35.31           C  
ATOM    474  CD2 PHE A  61      14.264  10.057  27.973  1.00 34.47           C  
ATOM    475  CE1 PHE A  61      13.914   7.896  29.674  1.00 35.48           C  
ATOM    476  CE2 PHE A  61      13.099   9.295  27.903  1.00 34.79           C  
ATOM    477  CZ  PHE A  61      12.926   8.213  28.756  1.00 33.81           C  
ATOM    478  N   GLU A  62      17.555  11.964  26.351  1.00 31.04           N  
ATOM    479  CA  GLU A  62      17.280  12.612  25.077  1.00 31.46           C  
ATOM    480  C   GLU A  62      18.136  12.007  23.973  1.00 30.21           C  
ATOM    481  O   GLU A  62      17.684  11.862  22.843  1.00 28.98           O  
ATOM    482  CB  GLU A  62      17.526  14.123  25.186  1.00 32.59           C  
ATOM    483  CG  GLU A  62      16.398  14.857  25.898  1.00 37.88           C  
ATOM    484  CD  GLU A  62      16.692  16.324  26.165  1.00 40.74           C  
ATOM    485  OE1 GLU A  62      17.116  17.038  25.229  1.00 42.03           O  
ATOM    486  OE2 GLU A  62      16.483  16.766  27.315  1.00 40.97           O  
ATOM    487  N   ASP A  63      19.370  11.644  24.307  1.00 30.33           N  
ATOM    488  CA  ASP A  63      20.269  11.040  23.328  1.00 31.37           C  
ATOM    489  C   ASP A  63      19.707   9.687  22.908  1.00 32.27           C  
ATOM    490  O   ASP A  63      19.770   9.309  21.734  1.00 32.12           O  
ATOM    491  CB  ASP A  63      21.656  10.874  23.923  1.00 32.76           C  
ATOM    492  N   LYS A  64      19.149   8.963  23.876  1.00 31.72           N  
ATOM    493  CA  LYS A  64      18.554   7.655  23.617  1.00 30.88           C  
ATOM    494  C   LYS A  64      17.358   7.773  22.679  1.00 29.67           C  
ATOM    495  O   LYS A  64      17.206   6.975  21.757  1.00 29.87           O  
ATOM    496  CB  LYS A  64      18.100   7.009  24.928  1.00 32.09           C  
ATOM    497  CG  LYS A  64      18.965   5.868  25.413  1.00 34.84           C  
ATOM    498  CD  LYS A  64      20.264   6.335  26.025  1.00 39.18           C  
ATOM    499  CE  LYS A  64      21.024   5.143  26.600  1.00 41.87           C  
ATOM    500  NZ  LYS A  64      22.350   5.512  27.163  1.00 44.14           N  
ATOM    501  N   LEU A  65      16.494   8.759  22.926  1.00 29.07           N  
ATOM    502  CA  LEU A  65      15.322   8.967  22.077  1.00 28.90           C  
ATOM    503  C   LEU A  65      15.807   9.332  20.678  1.00 30.35           C  
ATOM    504  O   LEU A  65      15.266   8.864  19.678  1.00 30.57           O  
ATOM    505  CB  LEU A  65      14.448  10.105  22.616  1.00 28.14           C  
ATOM    506  CG  LEU A  65      13.641   9.901  23.902  1.00 27.95           C  
ATOM    507  CD1 LEU A  65      13.136  11.244  24.403  1.00 26.40           C  
ATOM    508  CD2 LEU A  65      12.484   8.950  23.641  1.00 21.45           C  
ATOM    509  N   LYS A  66      16.830  10.177  20.618  1.00 31.45           N  
ATOM    510  CA  LYS A  66      17.385  10.597  19.338  1.00 36.27           C  
ATOM    511  C   LYS A  66      17.736   9.359  18.511  1.00 36.60           C  
ATOM    512  O   LYS A  66      17.462   9.311  17.313  1.00 38.42           O  
ATOM    513  CB  LYS A  66      18.630  11.466  19.565  1.00 36.63           C  
ATOM    514  CG  LYS A  66      19.122  12.208  18.325  1.00 38.74           C  
ATOM    515  CD  LYS A  66      20.264  13.155  18.681  1.00 39.17           C  
ATOM    516  CE  LYS A  66      20.686  14.012  17.498  1.00 42.13           C  
ATOM    517  NZ  LYS A  66      21.731  15.008  17.890  1.00 42.96           N  
ATOM    518  N   ASN A  67      18.319   8.356  19.161  1.00 38.00           N  
ATOM    519  CA  ASN A  67      18.696   7.111  18.489  1.00 39.11           C  
ATOM    520  C   ASN A  67      17.521   6.142  18.394  1.00 39.69           C  
ATOM    521  O   ASN A  67      17.647   5.069  17.806  1.00 39.12           O  
ATOM    522  CB  ASN A  67      19.822   6.397  19.245  1.00 40.46           C  
ATOM    523  CG  ASN A  67      21.036   7.274  19.464  1.00 43.93           C  
ATOM    524  OD1 ASN A  67      21.519   7.932  18.542  1.00 45.25           O  
ATOM    525  ND2 ASN A  67      21.549   7.274  20.693  1.00 45.21           N  
ATOM    526  N   GLU A  68      16.387   6.509  18.980  1.00 38.93           N  
ATOM    527  CA  GLU A  68      15.216   5.642  18.969  1.00 38.15           C  
ATOM    528  C   GLU A  68      15.561   4.317  19.656  1.00 37.21           C  
ATOM    529  O   GLU A  68      15.162   3.250  19.200  1.00 38.15           O  
ATOM    530  CB  GLU A  68      14.761   5.394  17.535  1.00 37.90           C  
ATOM    531  N   ASP A  69      16.307   4.399  20.753  1.00 36.46           N  
ATOM    532  CA  ASP A  69      16.719   3.215  21.501  1.00 35.94           C  
ATOM    533  C   ASP A  69      15.662   2.649  22.443  1.00 34.21           C  
ATOM    534  O   ASP A  69      15.911   1.644  23.111  1.00 34.84           O  
ATOM    535  CB  ASP A  69      17.970   3.517  22.331  1.00 37.55           C  
ATOM    536  CG  ASP A  69      19.193   3.771  21.478  1.00 40.79           C  
ATOM    537  OD1 ASP A  69      19.362   3.060  20.468  1.00 41.14           O  
ATOM    538  OD2 ASP A  69      19.994   4.665  21.830  1.00 42.60           O  
ATOM    539  N   PHE A  70      14.494   3.278  22.503  1.00 31.53           N  
ATOM    540  CA  PHE A  70      13.437   2.823  23.410  1.00 28.90           C  
ATOM    541  C   PHE A  70      12.325   1.994  22.782  1.00 28.23           C  
ATOM    542  O   PHE A  70      11.918   2.238  21.651  1.00 25.60           O  
ATOM    543  CB  PHE A  70      12.781   4.027  24.098  1.00 29.05           C  
ATOM    544  CG  PHE A  70      13.645   4.693  25.122  1.00 29.78           C  
ATOM    545  CD1 PHE A  70      13.882   4.086  26.353  1.00 30.79           C  
ATOM    546  CD2 PHE A  70      14.214   5.933  24.866  1.00 29.50           C  
ATOM    547  CE1 PHE A  70      14.674   4.709  27.315  1.00 29.60           C  
ATOM    548  CE2 PHE A  70      15.008   6.562  25.822  1.00 29.07           C  
ATOM    549  CZ  PHE A  70      15.238   5.951  27.045  1.00 31.46           C  
ATOM    550  N   LEU A  71      11.831   1.018  23.540  1.00 26.86           N  
ATOM    551  CA  LEU A  71      10.707   0.199  23.104  1.00 26.79           C  
ATOM    552  C   LEU A  71       9.482   1.051  23.447  1.00 26.10           C  
ATOM    553  O   LEU A  71       8.463   1.016  22.760  1.00 24.32           O  
ATOM    554  CB  LEU A  71      10.655  -1.117  23.888  1.00 28.78           C  
ATOM    555  CG  LEU A  71      11.767  -2.131  23.596  1.00 32.05           C  
ATOM    556  CD1 LEU A  71      11.696  -3.286  24.594  1.00 32.16           C  
ATOM    557  CD2 LEU A  71      11.627  -2.634  22.161  1.00 32.75           C  
ATOM    558  N   GLU A  72       9.603   1.807  24.536  1.00 25.25           N  
ATOM    559  CA  GLU A  72       8.547   2.708  24.995  1.00 25.20           C  
ATOM    560  C   GLU A  72       9.106   3.732  25.981  1.00 23.87           C  
ATOM    561  O   GLU A  72      10.048   3.450  26.718  1.00 22.73           O  
ATOM    562  CB  GLU A  72       7.386   1.924  25.635  1.00 26.90           C  
ATOM    563  CG  GLU A  72       7.698   1.122  26.915  1.00 29.72           C  
ATOM    564  CD  GLU A  72       7.920   1.992  28.152  1.00 31.75           C  
ATOM    565  OE1 GLU A  72       7.138   2.940  28.377  1.00 33.00           O  
ATOM    566  OE2 GLU A  72       8.872   1.716  28.913  1.00 33.83           O  
ATOM    567  N   TYR A  73       8.546   4.935  25.961  1.00 24.39           N  
ATOM    568  CA  TYR A  73       8.969   5.997  26.867  1.00 24.84           C  
ATOM    569  C   TYR A  73       7.712   6.648  27.434  1.00 24.34           C  
ATOM    570  O   TYR A  73       6.637   6.579  26.831  1.00 23.20           O  
ATOM    571  CB  TYR A  73       9.821   7.039  26.131  1.00 25.85           C  
ATOM    572  CG  TYR A  73       9.050   7.912  25.165  1.00 29.77           C  
ATOM    573  CD1 TYR A  73       8.369   9.046  25.612  1.00 29.67           C  
ATOM    574  CD2 TYR A  73       8.997   7.604  23.805  1.00 30.29           C  
ATOM    575  CE1 TYR A  73       7.655   9.851  24.733  1.00 31.82           C  
ATOM    576  CE2 TYR A  73       8.284   8.408  22.913  1.00 32.03           C  
ATOM    577  CZ  TYR A  73       7.617   9.527  23.389  1.00 31.90           C  
ATOM    578  OH  TYR A  73       6.909  10.326  22.525  1.00 34.20           O  
ATOM    579  N   ASP A  74       7.851   7.294  28.582  1.00 23.92           N  
ATOM    580  CA  ASP A  74       6.711   7.919  29.224  1.00 25.32           C  
ATOM    581  C   ASP A  74       7.205   9.056  30.105  1.00 24.96           C  
ATOM    582  O   ASP A  74       8.408   9.204  30.315  1.00 24.94           O  
ATOM    583  CB  ASP A  74       5.987   6.868  30.076  1.00 26.32           C  
ATOM    584  CG  ASP A  74       4.621   7.331  30.562  1.00 31.19           C  
ATOM    585  OD1 ASP A  74       4.076   6.677  31.483  1.00 30.88           O  
ATOM    586  OD2 ASP A  74       4.090   8.332  30.024  1.00 29.65           O  
ATOM    587  N   ASN A  75       6.278   9.880  30.581  1.00 26.42           N  
ATOM    588  CA  ASN A  75       6.603  10.979  31.478  1.00 28.68           C  
ATOM    589  C   ASN A  75       5.600  10.923  32.623  1.00 29.01           C  
ATOM    590  O   ASN A  75       4.398  10.820  32.402  1.00 30.25           O  
ATOM    591  CB  ASN A  75       6.533  12.343  30.762  1.00 31.97           C  
ATOM    592  CG  ASN A  75       5.141  12.678  30.244  1.00 36.13           C  
ATOM    593  OD1 ASN A  75       4.559  11.931  29.453  1.00 39.36           O  
ATOM    594  ND2 ASN A  75       4.608  13.815  30.679  1.00 36.71           N  
ATOM    595  N   TYR A  76       6.102  10.958  33.848  1.00 28.86           N  
ATOM    596  CA  TYR A  76       5.246  10.905  35.021  1.00 29.70           C  
ATOM    597  C   TYR A  76       5.853  11.754  36.131  1.00 28.67           C  
ATOM    598  O   TYR A  76       7.064  11.734  36.345  1.00 28.88           O  
ATOM    599  CB  TYR A  76       5.099   9.457  35.494  1.00 32.48           C  
ATOM    600  CG  TYR A  76       4.507   9.335  36.872  1.00 35.69           C  
ATOM    601  CD1 TYR A  76       3.153   9.575  37.099  1.00 39.49           C  
ATOM    602  CD2 TYR A  76       5.312   9.021  37.964  1.00 38.21           C  
ATOM    603  CE1 TYR A  76       2.614   9.506  38.387  1.00 40.83           C  
ATOM    604  CE2 TYR A  76       4.789   8.951  39.249  1.00 40.43           C  
ATOM    605  CZ  TYR A  76       3.442   9.196  39.453  1.00 41.61           C  
ATOM    606  OH  TYR A  76       2.936   9.145  40.733  1.00 45.36           O  
ATOM    607  N   ALA A  77       5.003  12.499  36.829  1.00 28.75           N  
ATOM    608  CA  ALA A  77       5.449  13.361  37.917  1.00 28.42           C  
ATOM    609  C   ALA A  77       6.711  14.149  37.564  1.00 27.81           C  
ATOM    610  O   ALA A  77       7.645  14.230  38.358  1.00 27.17           O  
ATOM    611  CB  ALA A  77       5.681  12.535  39.186  1.00 29.04           C  
ATOM    612  N   ASN A  78       6.733  14.713  36.361  1.00 26.63           N  
ATOM    613  CA  ASN A  78       7.844  15.531  35.899  1.00 25.30           C  
ATOM    614  C   ASN A  78       9.196  14.841  35.751  1.00 23.98           C  
ATOM    615  O   ASN A  78      10.243  15.453  35.941  1.00 25.54           O  
ATOM    616  CB  ASN A  78       7.964  16.763  36.807  1.00 28.48           C  
ATOM    617  CG  ASN A  78       6.727  17.652  36.737  1.00 28.60           C  
ATOM    618  OD1 ASN A  78       6.319  18.252  37.732  1.00 33.27           O  
ATOM    619  ND2 ASN A  78       6.134  17.745  35.554  1.00 27.01           N  
ATOM    620  N   ASN A  79       9.171  13.561  35.404  1.00 23.18           N  
ATOM    621  CA  ASN A  79      10.392  12.805  35.172  1.00 22.33           C  
ATOM    622  C   ASN A  79      10.102  11.892  33.980  1.00 23.18           C  
ATOM    623  O   ASN A  79       8.939  11.592  33.689  1.00 21.99           O  
ATOM    624  CB  ASN A  79      10.784  11.982  36.406  1.00 22.23           C  
ATOM    625  CG  ASN A  79      11.295  12.849  37.548  1.00 26.02           C  
ATOM    626  OD1 ASN A  79      10.677  12.924  38.612  1.00 28.99           O  
ATOM    627  ND2 ASN A  79      12.422  13.516  37.329  1.00 22.70           N  
ATOM    628  N   PHE A  80      11.152  11.476  33.283  1.00 22.73           N  
ATOM    629  CA  PHE A  80      10.998  10.610  32.122  1.00 24.71           C  
ATOM    630  C   PHE A  80      11.344   9.158  32.428  1.00 23.99           C  
ATOM    631  O   PHE A  80      12.261   8.879  33.196  1.00 22.49           O  
ATOM    632  CB  PHE A  80      11.878  11.117  30.977  1.00 28.43           C  
ATOM    633  CG  PHE A  80      11.423  12.434  30.401  1.00 32.36           C  
ATOM    634  CD1 PHE A  80      11.316  13.560  31.204  1.00 34.57           C  
ATOM    635  CD2 PHE A  80      11.082  12.538  29.059  1.00 36.28           C  
ATOM    636  CE1 PHE A  80      10.874  14.778  30.680  1.00 38.75           C  
ATOM    637  CE2 PHE A  80      10.640  13.754  28.521  1.00 39.46           C  
ATOM    638  CZ  PHE A  80      10.536  14.874  29.335  1.00 37.96           C  
ATOM    639  N   TYR A  81      10.601   8.241  31.817  1.00 23.33           N  
ATOM    640  CA  TYR A  81      10.822   6.810  31.997  1.00 22.83           C  
ATOM    641  C   TYR A  81      10.816   6.139  30.632  1.00 23.54           C  
ATOM    642  O   TYR A  81      10.190   6.638  29.696  1.00 23.40           O  
ATOM    643  CB  TYR A  81       9.716   6.192  32.858  1.00 21.62           C  
ATOM    644  CG  TYR A  81       9.605   6.775  34.247  1.00 22.55           C  
ATOM    645  CD1 TYR A  81       9.100   8.061  34.447  1.00 22.71           C  
ATOM    646  CD2 TYR A  81      10.019   6.046  35.364  1.00 21.29           C  
ATOM    647  CE1 TYR A  81       9.011   8.607  35.727  1.00 24.79           C  
ATOM    648  CE2 TYR A  81       9.937   6.581  36.640  1.00 23.71           C  
ATOM    649  CZ  TYR A  81       9.433   7.861  36.818  1.00 24.54           C  
ATOM    650  OH  TYR A  81       9.359   8.396  38.085  1.00 26.16           O  
ATOM    651  N   GLY A  82      11.507   5.008  30.521  1.00 22.49           N  
ATOM    652  CA  GLY A  82      11.541   4.298  29.258  1.00 24.83           C  
ATOM    653  C   GLY A  82      12.296   2.987  29.312  1.00 26.27           C  
ATOM    654  O   GLY A  82      13.289   2.858  30.026  1.00 27.44           O  
ATOM    655  N   THR A  83      11.815   2.005  28.558  1.00 27.08           N  
ATOM    656  CA  THR A  83      12.457   0.700  28.507  1.00 26.28           C  
ATOM    657  C   THR A  83      13.265   0.595  27.219  1.00 25.42           C  
ATOM    658  O   THR A  83      12.731   0.750  26.120  1.00 23.28           O  
ATOM    659  CB  THR A  83      11.426  -0.439  28.545  1.00 27.51           C  
ATOM    660  OG1 THR A  83      10.626  -0.313  29.725  1.00 30.72           O  
ATOM    661  CG2 THR A  83      12.128  -1.790  28.564  1.00 28.70           C  
ATOM    662  N   LEU A  84      14.557   0.335  27.371  1.00 25.72           N  
ATOM    663  CA  LEU A  84      15.462   0.219  26.235  1.00 27.87           C  
ATOM    664  C   LEU A  84      15.340  -1.121  25.533  1.00 28.35           C  
ATOM    665  O   LEU A  84      15.069  -2.154  26.163  1.00 25.42           O  
ATOM    666  CB  LEU A  84      16.907   0.408  26.694  1.00 28.78           C  
ATOM    667  CG  LEU A  84      17.294   1.775  27.259  1.00 28.95           C  
ATOM    668  CD1 LEU A  84      18.681   1.685  27.868  1.00 30.45           C  
ATOM    669  CD2 LEU A  84      17.252   2.829  26.157  1.00 29.88           C  
ATOM    670  N   LYS A  85      15.541  -1.095  24.219  1.00 29.25           N  
ATOM    671  CA  LYS A  85      15.492  -2.300  23.408  1.00 30.19           C  
ATOM    672  C   LYS A  85      16.545  -3.283  23.911  1.00 29.22           C  
ATOM    673  O   LYS A  85      16.394  -4.493  23.757  1.00 29.73           O  
ATOM    674  CB  LYS A  85      15.772  -1.964  21.939  1.00 31.55           C  
ATOM    675  CG  LYS A  85      14.693  -1.131  21.271  1.00 33.17           C  
ATOM    676  CD  LYS A  85      15.139  -0.663  19.893  1.00 36.65           C  
ATOM    677  CE  LYS A  85      14.071   0.182  19.217  1.00 37.05           C  
ATOM    678  NZ  LYS A  85      14.535   0.680  17.893  1.00 39.03           N  
ATOM    679  N   SER A  86      17.604  -2.756  24.520  1.00 28.88           N  
ATOM    680  CA  SER A  86      18.689  -3.591  25.024  1.00 29.73           C  
ATOM    681  C   SER A  86      18.254  -4.551  26.131  1.00 31.22           C  
ATOM    682  O   SER A  86      18.872  -5.604  26.315  1.00 31.45           O  
ATOM    683  CB  SER A  86      19.856  -2.720  25.504  1.00 28.48           C  
ATOM    684  OG  SER A  86      19.429  -1.730  26.420  1.00 32.99           O  
ATOM    685  N   GLU A  87      17.203  -4.196  26.873  1.00 29.41           N  
ATOM    686  CA  GLU A  87      16.703  -5.078  27.925  1.00 27.76           C  
ATOM    687  C   GLU A  87      16.293  -6.405  27.304  1.00 28.29           C  
ATOM    688  O   GLU A  87      16.509  -7.476  27.883  1.00 25.65           O  
ATOM    689  CB  GLU A  87      15.497  -4.456  28.628  1.00 28.07           C  
ATOM    690  CG  GLU A  87      15.882  -3.366  29.599  1.00 28.07           C  
ATOM    691  CD  GLU A  87      16.825  -3.880  30.664  1.00 30.43           C  
ATOM    692  OE1 GLU A  87      16.394  -4.722  31.484  1.00 31.33           O  
ATOM    693  OE2 GLU A  87      18.000  -3.453  30.679  1.00 32.27           O  
ATOM    694  N   TYR A  88      15.696  -6.324  26.118  1.00 29.17           N  
ATOM    695  CA  TYR A  88      15.253  -7.511  25.402  1.00 30.50           C  
ATOM    696  C   TYR A  88      16.457  -8.331  24.945  1.00 29.31           C  
ATOM    697  O   TYR A  88      16.416  -9.564  24.945  1.00 28.03           O  
ATOM    698  CB  TYR A  88      14.389  -7.104  24.206  1.00 32.26           C  
ATOM    699  CG  TYR A  88      13.805  -8.260  23.428  1.00 35.53           C  
ATOM    700  CD1 TYR A  88      13.308  -9.386  24.081  1.00 38.91           C  
ATOM    701  CD2 TYR A  88      13.717  -8.212  22.040  1.00 39.39           C  
ATOM    702  CE1 TYR A  88      12.739 -10.437  23.369  1.00 40.79           C  
ATOM    703  CE2 TYR A  88      13.146  -9.253  21.318  1.00 40.88           C  
ATOM    704  CZ  TYR A  88      12.659 -10.363  21.987  1.00 42.10           C  
ATOM    705  OH  TYR A  88      12.100 -11.398  21.271  1.00 44.66           O  
ATOM    706  N   ASP A  89      17.529  -7.645  24.556  1.00 29.84           N  
ATOM    707  CA  ASP A  89      18.748  -8.319  24.114  1.00 30.20           C  
ATOM    708  C   ASP A  89      19.404  -9.059  25.275  1.00 30.05           C  
ATOM    709  O   ASP A  89      19.946 -10.148  25.101  1.00 29.55           O  
ATOM    710  CB  ASP A  89      19.738  -7.311  23.533  1.00 32.08           C  
ATOM    711  CG  ASP A  89      19.220  -6.649  22.271  1.00 35.73           C  
ATOM    712  OD1 ASP A  89      18.697  -7.374  21.400  1.00 37.62           O  
ATOM    713  OD2 ASP A  89      19.342  -5.413  22.148  1.00 37.98           O  
ATOM    714  N   LYS A  90      19.354  -8.466  26.462  1.00 28.67           N  
ATOM    715  CA  LYS A  90      19.943  -9.096  27.630  1.00 28.24           C  
ATOM    716  C   LYS A  90      19.181 -10.371  27.980  1.00 27.68           C  
ATOM    717  O   LYS A  90      19.776 -11.364  28.400  1.00 26.26           O  
ATOM    718  CB  LYS A  90      19.943  -8.116  28.801  1.00 30.79           C  
ATOM    719  CG  LYS A  90      20.879  -6.935  28.572  1.00 33.77           C  
ATOM    720  CD  LYS A  90      20.878  -5.953  29.736  1.00 36.02           C  
ATOM    721  CE  LYS A  90      21.747  -4.746  29.405  1.00 38.37           C  
ATOM    722  NZ  LYS A  90      21.729  -3.718  30.483  1.00 41.38           N  
ATOM    723  N   ALA A  91      17.865 -10.348  27.795  1.00 26.72           N  
ATOM    724  CA  ALA A  91      17.045 -11.521  28.078  1.00 26.97           C  
ATOM    725  C   ALA A  91      17.429 -12.628  27.089  1.00 26.90           C  
ATOM    726  O   ALA A  91      17.515 -13.806  27.450  1.00 25.55           O  
ATOM    727  CB  ALA A  91      15.567 -11.177  27.935  1.00 24.34           C  
ATOM    728  N   LYS A  92      17.658 -12.239  25.838  1.00 27.67           N  
ATOM    729  CA  LYS A  92      18.044 -13.191  24.804  1.00 29.85           C  
ATOM    730  C   LYS A  92      19.412 -13.771  25.130  1.00 29.92           C  
ATOM    731  O   LYS A  92      19.635 -14.976  25.021  1.00 30.21           O  
ATOM    732  CB  LYS A  92      18.096 -12.507  23.441  1.00 32.32           C  
ATOM    733  CG  LYS A  92      16.747 -12.111  22.879  1.00 36.67           C  
ATOM    734  CD  LYS A  92      16.934 -11.377  21.556  1.00 40.90           C  
ATOM    735  CE  LYS A  92      15.617 -11.181  20.838  1.00 44.00           C  
ATOM    736  NZ  LYS A  92      15.771 -10.377  19.590  1.00 46.48           N  
ATOM    737  N   GLU A  93      20.327 -12.895  25.530  1.00 30.79           N  
ATOM    738  CA  GLU A  93      21.680 -13.287  25.887  1.00 32.02           C  
ATOM    739  C   GLU A  93      21.661 -14.394  26.948  1.00 31.07           C  
ATOM    740  O   GLU A  93      22.435 -15.345  26.871  1.00 30.82           O  
ATOM    741  CB  GLU A  93      22.443 -12.065  26.418  1.00 34.35           C  
ATOM    742  CG  GLU A  93      23.906 -12.325  26.753  1.00 40.14           C  
ATOM    743  CD  GLU A  93      24.602 -11.120  27.377  1.00 44.31           C  
ATOM    744  OE1 GLU A  93      25.852 -11.118  27.411  1.00 47.71           O  
ATOM    745  OE2 GLU A  93      23.913 -10.181  27.842  1.00 45.14           O  
ATOM    746  N   GLN A  94      20.774 -14.267  27.932  1.00 30.10           N  
ATOM    747  CA  GLN A  94      20.665 -15.255  29.010  1.00 29.38           C  
ATOM    748  C   GLN A  94      19.701 -16.384  28.675  1.00 30.42           C  
ATOM    749  O   GLN A  94      19.469 -17.283  29.485  1.00 31.36           O  
ATOM    750  CB  GLN A  94      20.212 -14.574  30.307  1.00 27.83           C  
ATOM    751  CG  GLN A  94      21.257 -13.663  30.936  1.00 28.41           C  
ATOM    752  CD  GLN A  94      20.766 -13.004  32.211  1.00 29.19           C  
ATOM    753  OE1 GLN A  94      20.151 -13.650  33.056  1.00 30.30           O  
ATOM    754  NE2 GLN A  94      21.049 -11.717  32.362  1.00 26.96           N  
ATOM    755  N   ASN A  95      19.140 -16.335  27.475  1.00 31.64           N  
ATOM    756  CA  ASN A  95      18.187 -17.340  27.030  1.00 33.04           C  
ATOM    757  C   ASN A  95      17.027 -17.511  28.014  1.00 33.10           C  
ATOM    758  O   ASN A  95      16.794 -18.600  28.548  1.00 31.52           O  
ATOM    759  CB  ASN A  95      18.894 -18.676  26.819  1.00 36.95           C  
ATOM    760  CG  ASN A  95      18.497 -19.332  25.517  1.00 42.08           C  
ATOM    761  OD1 ASN A  95      17.359 -19.783  25.354  1.00 44.00           O  
ATOM    762  ND2 ASN A  95      19.432 -19.376  24.569  1.00 42.94           N  
ATOM    763  N   LYS A  96      16.303 -16.424  28.258  1.00 31.00           N  
ATOM    764  CA  LYS A  96      15.162 -16.470  29.157  1.00 29.55           C  
ATOM    765  C   LYS A  96      14.030 -15.605  28.652  1.00 27.09           C  
ATOM    766  O   LYS A  96      14.223 -14.773  27.772  1.00 25.25           O  
ATOM    767  CB  LYS A  96      15.586 -16.064  30.568  1.00 32.92           C  
ATOM    768  CG  LYS A  96      16.189 -17.251  31.311  1.00 34.78           C  
ATOM    769  CD  LYS A  96      17.038 -16.862  32.471  1.00 35.45           C  
ATOM    770  CE  LYS A  96      17.747 -18.095  33.008  1.00 34.41           C  
ATOM    771  NZ  LYS A  96      18.816 -17.701  33.949  1.00 38.00           N  
ATOM    772  N   ILE A  97      12.846 -15.815  29.209  1.00 24.06           N  
ATOM    773  CA  ILE A  97      11.669 -15.063  28.806  1.00 24.78           C  
ATOM    774  C   ILE A  97      11.791 -13.631  29.300  1.00 25.05           C  
ATOM    775  O   ILE A  97      11.948 -13.400  30.503  1.00 25.25           O  
ATOM    776  CB  ILE A  97      10.378 -15.684  29.406  1.00 24.07           C  
ATOM    777  CG1 ILE A  97      10.306 -17.177  29.065  1.00 23.27           C  
ATOM    778  CG2 ILE A  97       9.147 -14.958  28.870  1.00 23.83           C  
ATOM    779  CD1 ILE A  97       9.286 -17.929  29.904  1.00 24.82           C  
ATOM    780  N   CYS A  98      11.738 -12.671  28.383  1.00 21.97           N  
ATOM    781  CA  CYS A  98      11.812 -11.282  28.795  1.00 22.09           C  
ATOM    782  C   CYS A  98      10.438 -10.892  29.335  1.00 21.11           C  
ATOM    783  O   CYS A  98       9.431 -10.984  28.626  1.00 22.14           O  
ATOM    784  CB  CYS A  98      12.185 -10.369  27.621  1.00 20.84           C  
ATOM    785  SG  CYS A  98      12.622  -8.699  28.175  1.00 26.30           S  
ATOM    786  N   LEU A  99      10.397 -10.471  30.595  1.00 21.52           N  
ATOM    787  CA  LEU A  99       9.144 -10.074  31.236  1.00 20.76           C  
ATOM    788  C   LEU A  99       9.094  -8.555  31.375  1.00 20.65           C  
ATOM    789  O   LEU A  99       9.916  -7.969  32.074  1.00 20.70           O  
ATOM    790  CB  LEU A  99       9.043 -10.728  32.625  1.00 20.52           C  
ATOM    791  CG  LEU A  99       7.667 -10.762  33.306  1.00 21.59           C  
ATOM    792  CD1 LEU A  99       7.751 -11.596  34.586  1.00 27.64           C  
ATOM    793  CD2 LEU A  99       7.194  -9.354  33.613  1.00 25.50           C  
ATOM    794  N   PHE A 100       8.134  -7.924  30.701  1.00 22.44           N  
ATOM    795  CA  PHE A 100       7.965  -6.472  30.753  1.00 22.44           C  
ATOM    796  C   PHE A 100       6.765  -6.085  31.613  1.00 22.75           C  
ATOM    797  O   PHE A 100       5.673  -6.612  31.418  1.00 23.06           O  
ATOM    798  CB  PHE A 100       7.695  -5.883  29.357  1.00 22.92           C  
ATOM    799  CG  PHE A 100       8.847  -5.966  28.407  1.00 22.18           C  
ATOM    800  CD1 PHE A 100       9.955  -5.146  28.562  1.00 23.75           C  
ATOM    801  CD2 PHE A 100       8.807  -6.849  27.328  1.00 25.35           C  
ATOM    802  CE1 PHE A 100      11.014  -5.200  27.655  1.00 25.45           C  
ATOM    803  CE2 PHE A 100       9.859  -6.912  26.415  1.00 24.71           C  
ATOM    804  CZ  PHE A 100      10.965  -6.083  26.580  1.00 24.57           C  
ATOM    805  N   GLU A 101       6.960  -5.169  32.557  1.00 23.53           N  
ATOM    806  CA  GLU A 101       5.848  -4.669  33.364  1.00 24.85           C  
ATOM    807  C   GLU A 101       5.538  -3.304  32.738  1.00 24.89           C  
ATOM    808  O   GLU A 101       6.385  -2.419  32.775  1.00 25.26           O  
ATOM    809  CB  GLU A 101       6.246  -4.467  34.829  1.00 26.62           C  
ATOM    810  CG  GLU A 101       5.067  -3.964  35.660  1.00 29.83           C  
ATOM    811  CD  GLU A 101       5.405  -3.688  37.108  1.00 32.92           C  
ATOM    812  OE1 GLU A 101       4.471  -3.325  37.856  1.00 35.30           O  
ATOM    813  OE2 GLU A 101       6.584  -3.834  37.500  1.00 32.44           O  
ATOM    814  N   MET A 102       4.340  -3.130  32.174  1.00 25.09           N  
ATOM    815  CA  MET A 102       3.980  -1.870  31.508  1.00 24.46           C  
ATOM    816  C   MET A 102       2.580  -1.357  31.818  1.00 23.78           C  
ATOM    817  O   MET A 102       1.699  -2.127  32.197  1.00 21.36           O  
ATOM    818  CB  MET A 102       4.020  -2.050  29.991  1.00 25.88           C  
ATOM    819  CG  MET A 102       5.320  -2.503  29.411  1.00 31.04           C  
ATOM    820  SD  MET A 102       6.469  -1.149  29.308  1.00 37.36           S  
ATOM    821  CE  MET A 102       7.895  -2.014  28.604  1.00 32.80           C  
ATOM    822  N   ASN A 103       2.381  -0.054  31.625  1.00 19.85           N  
ATOM    823  CA  ASN A 103       1.061   0.533  31.781  1.00 21.76           C  
ATOM    824  C   ASN A 103       0.512   0.527  30.348  1.00 23.02           C  
ATOM    825  O   ASN A 103       1.224   0.136  29.415  1.00 22.93           O  
ATOM    826  CB  ASN A 103       1.112   1.962  32.355  1.00 21.69           C  
ATOM    827  CG  ASN A 103       2.010   2.900  31.564  1.00 23.18           C  
ATOM    828  OD1 ASN A 103       2.266   2.692  30.379  1.00 22.77           O  
ATOM    829  ND2 ASN A 103       2.479   3.953  32.223  1.00 23.76           N  
ATOM    830  N   ILE A 104      -0.730   0.949  30.155  1.00 23.11           N  
ATOM    831  CA  ILE A 104      -1.316   0.905  28.820  1.00 23.59           C  
ATOM    832  C   ILE A 104      -0.597   1.776  27.788  1.00 25.18           C  
ATOM    833  O   ILE A 104      -0.499   1.406  26.616  1.00 24.78           O  
ATOM    834  CB  ILE A 104      -2.813   1.269  28.865  1.00 23.93           C  
ATOM    835  CG1 ILE A 104      -3.540   0.355  29.863  1.00 24.86           C  
ATOM    836  CG2 ILE A 104      -3.428   1.114  27.474  1.00 23.42           C  
ATOM    837  CD1 ILE A 104      -3.379  -1.152  29.587  1.00 26.20           C  
ATOM    838  N   ASN A 105      -0.093   2.926  28.224  1.00 25.85           N  
ATOM    839  CA  ASN A 105       0.627   3.834  27.336  1.00 25.62           C  
ATOM    840  C   ASN A 105       1.848   3.117  26.770  1.00 26.08           C  
ATOM    841  O   ASN A 105       2.260   3.364  25.634  1.00 25.53           O  
ATOM    842  CB  ASN A 105       1.077   5.074  28.107  1.00 26.18           C  
ATOM    843  CG  ASN A 105       1.810   6.085  27.226  1.00 29.67           C  
ATOM    844  OD1 ASN A 105       1.222   6.680  26.323  1.00 28.98           O  
ATOM    845  ND2 ASN A 105       3.098   6.278  27.490  1.00 28.04           N  
ATOM    846  N   GLY A 106       2.419   2.225  27.576  1.00 23.13           N  
ATOM    847  CA  GLY A 106       3.591   1.483  27.159  1.00 23.91           C  
ATOM    848  C   GLY A 106       3.253   0.371  26.189  1.00 23.88           C  
ATOM    849  O   GLY A 106       3.957   0.172  25.197  1.00 23.00           O  
ATOM    850  N   VAL A 107       2.176  -0.354  26.482  1.00 23.02           N  
ATOM    851  CA  VAL A 107       1.733  -1.458  25.635  1.00 23.99           C  
ATOM    852  C   VAL A 107       1.451  -1.028  24.189  1.00 25.89           C  
ATOM    853  O   VAL A 107       1.824  -1.726  23.253  1.00 26.87           O  
ATOM    854  CB  VAL A 107       0.450  -2.114  26.202  1.00 24.11           C  
ATOM    855  CG1 VAL A 107      -0.080  -3.148  25.228  1.00 24.67           C  
ATOM    856  CG2 VAL A 107       0.747  -2.767  27.547  1.00 22.74           C  
ATOM    857  N   LYS A 108       0.790   0.111  23.998  1.00 26.34           N  
ATOM    858  CA  LYS A 108       0.492   0.537  22.639  1.00 29.11           C  
ATOM    859  C   LYS A 108       1.757   0.871  21.862  1.00 28.58           C  
ATOM    860  O   LYS A 108       1.781   0.769  20.638  1.00 30.58           O  
ATOM    861  CB  LYS A 108      -0.500   1.705  22.630  1.00 30.57           C  
ATOM    862  CG  LYS A 108      -0.138   2.892  23.484  1.00 34.96           C  
ATOM    863  CD  LYS A 108      -1.323   3.848  23.564  1.00 37.23           C  
ATOM    864  CE  LYS A 108      -1.807   4.248  22.176  1.00 36.74           C  
ATOM    865  NZ  LYS A 108      -2.949   5.193  22.243  1.00 39.20           N  
ATOM    866  N   GLN A 109       2.815   1.249  22.571  1.00 28.51           N  
ATOM    867  CA  GLN A 109       4.084   1.536  21.914  1.00 28.57           C  
ATOM    868  C   GLN A 109       4.768   0.208  21.603  1.00 28.93           C  
ATOM    869  O   GLN A 109       5.449   0.076  20.591  1.00 29.81           O  
ATOM    870  CB  GLN A 109       4.989   2.386  22.809  1.00 26.32           C  
ATOM    871  CG  GLN A 109       4.473   3.788  23.055  1.00 26.34           C  
ATOM    872  CD  GLN A 109       5.350   4.560  24.018  1.00 26.99           C  
ATOM    873  OE1 GLN A 109       6.496   4.894  23.708  1.00 26.37           O  
ATOM    874  NE2 GLN A 109       4.817   4.841  25.204  1.00 23.29           N  
ATOM    875  N   LEU A 110       4.603  -0.777  22.480  1.00 29.79           N  
ATOM    876  CA  LEU A 110       5.204  -2.082  22.230  1.00 30.69           C  
ATOM    877  C   LEU A 110       4.530  -2.724  21.022  1.00 30.99           C  
ATOM    878  O   LEU A 110       5.194  -3.305  20.166  1.00 31.64           O  
ATOM    879  CB  LEU A 110       5.040  -3.019  23.429  1.00 33.49           C  
ATOM    880  CG  LEU A 110       5.874  -2.802  24.691  1.00 35.12           C  
ATOM    881  CD1 LEU A 110       5.755  -4.040  25.578  1.00 37.27           C  
ATOM    882  CD2 LEU A 110       7.331  -2.575  24.322  1.00 37.18           C  
ATOM    883  N   LYS A 111       3.207  -2.615  20.961  1.00 32.12           N  
ATOM    884  CA  LYS A 111       2.446  -3.198  19.867  1.00 34.94           C  
ATOM    885  C   LYS A 111       2.779  -2.606  18.504  1.00 36.35           C  
ATOM    886  O   LYS A 111       2.411  -3.167  17.479  1.00 37.35           O  
ATOM    887  CB  LYS A 111       0.949  -3.079  20.150  1.00 34.55           C  
ATOM    888  CG  LYS A 111       0.460  -4.106  21.154  1.00 34.69           C  
ATOM    889  CD  LYS A 111      -0.970  -3.846  21.580  1.00 35.58           C  
ATOM    890  CE  LYS A 111      -1.491  -4.984  22.436  1.00 36.66           C  
ATOM    891  NZ  LYS A 111      -1.600  -6.246  21.640  1.00 37.57           N  
ATOM    892  N   LYS A 112       3.478  -1.477  18.493  1.00 38.15           N  
ATOM    893  CA  LYS A 112       3.876  -0.845  17.236  1.00 40.07           C  
ATOM    894  C   LYS A 112       5.368  -1.064  17.015  1.00 41.60           C  
ATOM    895  O   LYS A 112       5.857  -0.970  15.894  1.00 41.93           O  
ATOM    896  CB  LYS A 112       3.586   0.654  17.263  1.00 39.81           C  
ATOM    897  CG  LYS A 112       2.117   1.020  17.313  1.00 42.17           C  
ATOM    898  CD  LYS A 112       1.949   2.532  17.390  1.00 44.86           C  
ATOM    899  CE  LYS A 112       0.481   2.939  17.441  1.00 48.06           C  
ATOM    900  NZ  LYS A 112      -0.261   2.551  16.205  1.00 49.04           N  
ATOM    901  N   SER A 113       6.088  -1.369  18.092  1.00 43.64           N  
ATOM    902  CA  SER A 113       7.528  -1.589  18.014  1.00 46.94           C  
ATOM    903  C   SER A 113       7.935  -2.642  16.993  1.00 49.66           C  
ATOM    904  O   SER A 113       7.346  -3.721  16.917  1.00 49.51           O  
ATOM    905  CB  SER A 113       8.087  -1.986  19.381  1.00 47.16           C  
ATOM    906  OG  SER A 113       9.465  -2.306  19.277  1.00 46.75           O  
ATOM    907  N   THR A 114       8.960  -2.315  16.215  1.00 52.04           N  
ATOM    908  CA  THR A 114       9.476  -3.212  15.192  1.00 54.20           C  
ATOM    909  C   THR A 114      10.539  -4.150  15.760  1.00 54.31           C  
ATOM    910  O   THR A 114      10.789  -5.223  15.207  1.00 54.64           O  
ATOM    911  CB  THR A 114      10.094  -2.415  14.022  1.00 54.74           C  
ATOM    912  OG1 THR A 114      10.883  -3.292  13.212  1.00 56.88           O  
ATOM    913  CG2 THR A 114      10.971  -1.285  14.543  1.00 55.39           C  
ATOM    914  N   HIS A 115      11.155  -3.741  16.866  1.00 53.92           N  
ATOM    915  CA  HIS A 115      12.202  -4.530  17.509  1.00 53.50           C  
ATOM    916  C   HIS A 115      11.663  -5.841  18.072  1.00 52.99           C  
ATOM    917  O   HIS A 115      12.305  -6.884  17.952  1.00 53.48           O  
ATOM    918  CB  HIS A 115      12.858  -3.723  18.632  1.00 53.78           C  
ATOM    919  CG  HIS A 115      14.139  -4.314  19.133  1.00 54.85           C  
ATOM    920  ND1 HIS A 115      15.268  -4.415  18.349  1.00 55.79           N  
ATOM    921  CD2 HIS A 115      14.472  -4.832  20.340  1.00 55.20           C  
ATOM    922  CE1 HIS A 115      16.241  -4.969  19.052  1.00 55.55           C  
ATOM    923  NE2 HIS A 115      15.783  -5.230  20.263  1.00 56.15           N  
ATOM    924  N   ILE A 116      10.488  -5.785  18.690  1.00 51.93           N  
ATOM    925  CA  ILE A 116       9.872  -6.976  19.266  1.00 50.50           C  
ATOM    926  C   ILE A 116       8.635  -7.383  18.479  1.00 49.54           C  
ATOM    927  O   ILE A 116       7.984  -6.549  17.849  1.00 49.24           O  
ATOM    928  CB  ILE A 116       9.473  -6.746  20.744  1.00 51.15           C  
ATOM    929  CG1 ILE A 116      10.730  -6.596  21.604  1.00 51.40           C  
ATOM    930  CG2 ILE A 116       8.625  -7.907  21.251  1.00 52.07           C  
ATOM    931  CD1 ILE A 116      10.448  -6.329  23.067  1.00 50.94           C  
ATOM    932  N   LYS A 117       8.320  -8.673  18.518  1.00 48.18           N  
ATOM    933  CA  LYS A 117       7.162  -9.200  17.814  1.00 46.96           C  
ATOM    934  C   LYS A 117       6.704 -10.503  18.460  1.00 45.86           C  
ATOM    935  O   LYS A 117       7.491 -11.201  19.103  1.00 46.55           O  
ATOM    936  CB  LYS A 117       7.507  -9.437  16.352  1.00 47.37           C  
ATOM    937  N   ASN A 118       5.424 -10.815  18.295  1.00 43.95           N  
ATOM    938  CA  ASN A 118       4.854 -12.035  18.842  1.00 41.36           C  
ATOM    939  C   ASN A 118       4.847 -12.087  20.372  1.00 39.12           C  
ATOM    940  O   ASN A 118       4.857 -13.170  20.961  1.00 38.36           O  
ATOM    941  CB  ASN A 118       5.609 -13.245  18.289  1.00 44.69           C  
ATOM    942  CG  ASN A 118       5.569 -13.311  16.776  1.00 47.81           C  
ATOM    943  OD1 ASN A 118       4.497 -13.307  16.173  1.00 50.46           O  
ATOM    944  ND2 ASN A 118       6.743 -13.375  16.154  1.00 48.78           N  
ATOM    945  N   ALA A 119       4.826 -10.928  21.017  1.00 34.10           N  
ATOM    946  CA  ALA A 119       4.809 -10.902  22.471  1.00 30.91           C  
ATOM    947  C   ALA A 119       3.431 -11.295  22.999  1.00 27.78           C  
ATOM    948  O   ALA A 119       2.424 -11.148  22.311  1.00 25.54           O  
ATOM    949  CB  ALA A 119       5.189  -9.510  22.987  1.00 29.39           C  
ATOM    950  N   LEU A 120       3.403 -11.810  24.222  1.00 26.57           N  
ATOM    951  CA  LEU A 120       2.157 -12.198  24.864  1.00 25.70           C  
ATOM    952  C   LEU A 120       1.767 -11.063  25.804  1.00 24.91           C  
ATOM    953  O   LEU A 120       2.553 -10.665  26.662  1.00 25.51           O  
ATOM    954  CB  LEU A 120       2.339 -13.495  25.657  1.00 29.69           C  
ATOM    955  CG  LEU A 120       2.760 -14.734  24.858  1.00 32.51           C  
ATOM    956  CD1 LEU A 120       2.688 -15.960  25.755  1.00 33.06           C  
ATOM    957  CD2 LEU A 120       1.844 -14.906  23.644  1.00 35.32           C  
ATOM    958  N   TYR A 121       0.559 -10.540  25.641  1.00 22.65           N  
ATOM    959  CA  TYR A 121       0.098  -9.441  26.473  1.00 22.84           C  
ATOM    960  C   TYR A 121      -0.982  -9.870  27.459  1.00 22.23           C  
ATOM    961  O   TYR A 121      -2.014 -10.413  27.069  1.00 20.49           O  
ATOM    962  CB  TYR A 121      -0.436  -8.306  25.596  1.00 23.63           C  
ATOM    963  CG  TYR A 121       0.612  -7.665  24.707  1.00 25.36           C  
ATOM    964  CD1 TYR A 121       0.935  -8.205  23.465  1.00 25.77           C  
ATOM    965  CD2 TYR A 121       1.277  -6.514  25.112  1.00 25.24           C  
ATOM    966  CE1 TYR A 121       1.902  -7.598  22.640  1.00 27.69           C  
ATOM    967  CE2 TYR A 121       2.239  -5.909  24.309  1.00 26.39           C  
ATOM    968  CZ  TYR A 121       2.545  -6.449  23.078  1.00 26.95           C  
ATOM    969  OH  TYR A 121       3.494  -5.826  22.293  1.00 29.99           O  
ATOM    970  N   ILE A 122      -0.737  -9.622  28.738  1.00 21.27           N  
ATOM    971  CA  ILE A 122      -1.701  -9.970  29.776  1.00 20.90           C  
ATOM    972  C   ILE A 122      -2.163  -8.703  30.483  1.00 19.34           C  
ATOM    973  O   ILE A 122      -1.401  -8.084  31.227  1.00 19.28           O  
ATOM    974  CB  ILE A 122      -1.088 -10.906  30.828  1.00 23.96           C  
ATOM    975  CG1 ILE A 122      -0.433 -12.115  30.146  1.00 27.43           C  
ATOM    976  CG2 ILE A 122      -2.164 -11.357  31.808  1.00 23.98           C  
ATOM    977  CD1 ILE A 122      -1.369 -12.919  29.274  1.00 29.87           C  
ATOM    978  N   PHE A 123      -3.419  -8.338  30.264  1.00 18.97           N  
ATOM    979  CA  PHE A 123      -4.004  -7.146  30.862  1.00 19.79           C  
ATOM    980  C   PHE A 123      -4.590  -7.431  32.243  1.00 21.71           C  
ATOM    981  O   PHE A 123      -5.514  -8.229  32.382  1.00 22.45           O  
ATOM    982  CB  PHE A 123      -5.089  -6.611  29.920  1.00 19.35           C  
ATOM    983  CG  PHE A 123      -5.815  -5.381  30.417  1.00 22.07           C  
ATOM    984  CD1 PHE A 123      -5.237  -4.518  31.342  1.00 22.24           C  
ATOM    985  CD2 PHE A 123      -7.064  -5.055  29.891  1.00 19.97           C  
ATOM    986  CE1 PHE A 123      -5.888  -3.346  31.730  1.00 24.31           C  
ATOM    987  CE2 PHE A 123      -7.722  -3.884  30.271  1.00 23.40           C  
ATOM    988  CZ  PHE A 123      -7.132  -3.029  31.191  1.00 23.86           C  
ATOM    989  N   ILE A 124      -4.041  -6.779  33.262  1.00 21.78           N  
ATOM    990  CA  ILE A 124      -4.537  -6.935  34.627  1.00 25.28           C  
ATOM    991  C   ILE A 124      -5.459  -5.738  34.871  1.00 25.96           C  
ATOM    992  O   ILE A 124      -5.010  -4.595  34.914  1.00 25.53           O  
ATOM    993  CB  ILE A 124      -3.386  -6.926  35.666  1.00 25.09           C  
ATOM    994  CG1 ILE A 124      -2.359  -8.017  35.329  1.00 25.16           C  
ATOM    995  CG2 ILE A 124      -3.950  -7.155  37.071  1.00 23.35           C  
ATOM    996  CD1 ILE A 124      -2.932  -9.426  35.271  1.00 21.83           C  
ATOM    997  N   LYS A 125      -6.749  -6.023  35.014  1.00 25.90           N  
ATOM    998  CA  LYS A 125      -7.770  -5.004  35.218  1.00 26.95           C  
ATOM    999  C   LYS A 125      -8.142  -4.849  36.681  1.00 27.46           C  
ATOM   1000  O   LYS A 125      -8.004  -5.784  37.473  1.00 26.87           O  
ATOM   1001  CB  LYS A 125      -9.026  -5.369  34.418  1.00 29.60           C  
ATOM   1002  CG  LYS A 125      -8.785  -5.500  32.923  1.00 32.16           C  
ATOM   1003  CD  LYS A 125      -9.530  -6.687  32.314  1.00 35.54           C  
ATOM   1004  CE  LYS A 125     -11.034  -6.548  32.436  1.00 37.25           C  
ATOM   1005  NZ  LYS A 125     -11.735  -7.730  31.846  1.00 41.79           N  
ATOM   1006  N   PRO A 126      -8.624  -3.654  37.060  1.00 26.68           N  
ATOM   1007  CA  PRO A 126      -9.019  -3.397  38.444  1.00 27.18           C  
ATOM   1008  C   PRO A 126     -10.421  -3.961  38.654  1.00 28.64           C  
ATOM   1009  O   PRO A 126     -11.138  -4.225  37.690  1.00 27.29           O  
ATOM   1010  CB  PRO A 126      -8.997  -1.873  38.519  1.00 27.87           C  
ATOM   1011  CG  PRO A 126      -9.527  -1.490  37.178  1.00 25.87           C  
ATOM   1012  CD  PRO A 126      -8.766  -2.435  36.241  1.00 27.35           C  
ATOM   1013  N   PRO A 127     -10.825  -4.176  39.913  1.00 30.44           N  
ATOM   1014  CA  PRO A 127     -12.175  -4.710  40.104  1.00 31.12           C  
ATOM   1015  C   PRO A 127     -13.218  -3.694  39.630  1.00 31.68           C  
ATOM   1016  O   PRO A 127     -14.344  -4.053  39.298  1.00 33.26           O  
ATOM   1017  CB  PRO A 127     -12.233  -4.981  41.606  1.00 32.42           C  
ATOM   1018  CG  PRO A 127     -11.268  -3.994  42.180  1.00 34.78           C  
ATOM   1019  CD  PRO A 127     -10.120  -4.029  41.196  1.00 32.12           C  
ATOM   1020  N   SER A 128     -12.825  -2.424  39.587  1.00 30.19           N  
ATOM   1021  CA  SER A 128     -13.715  -1.360  39.136  1.00 29.69           C  
ATOM   1022  C   SER A 128     -12.935  -0.061  39.014  1.00 29.89           C  
ATOM   1023  O   SER A 128     -11.806   0.045  39.500  1.00 28.03           O  
ATOM   1024  CB  SER A 128     -14.855  -1.148  40.133  1.00 30.07           C  
ATOM   1025  OG  SER A 128     -14.384  -0.454  41.274  1.00 26.11           O  
ATOM   1026  N   THR A 129     -13.545   0.930  38.375  1.00 30.60           N  
ATOM   1027  CA  THR A 129     -12.892   2.219  38.219  1.00 30.84           C  
ATOM   1028  C   THR A 129     -12.819   2.897  39.585  1.00 31.61           C  
ATOM   1029  O   THR A 129     -11.797   3.488  39.932  1.00 30.38           O  
ATOM   1030  CB  THR A 129     -13.651   3.107  37.211  1.00 32.40           C  
ATOM   1031  OG1 THR A 129     -13.665   2.458  35.934  1.00 32.32           O  
ATOM   1032  CG2 THR A 129     -12.968   4.476  37.063  1.00 30.78           C  
ATOM   1033  N   ASP A 130     -13.898   2.789  40.363  1.00 31.43           N  
ATOM   1034  CA  ASP A 130     -13.942   3.378  41.702  1.00 30.85           C  
ATOM   1035  C   ASP A 130     -12.772   2.893  42.549  1.00 29.42           C  
ATOM   1036  O   ASP A 130     -12.107   3.684  43.216  1.00 27.03           O  
ATOM   1037  CB  ASP A 130     -15.249   3.020  42.426  1.00 34.34           C  
ATOM   1038  CG  ASP A 130     -16.435   3.835  41.945  1.00 38.22           C  
ATOM   1039  OD1 ASP A 130     -16.312   5.072  41.855  1.00 42.33           O  
ATOM   1040  OD2 ASP A 130     -17.501   3.245  41.672  1.00 43.26           O  
ATOM   1041  N   VAL A 131     -12.531   1.584  42.530  1.00 27.86           N  
ATOM   1042  CA  VAL A 131     -11.436   1.002  43.299  1.00 27.61           C  
ATOM   1043  C   VAL A 131     -10.079   1.495  42.793  1.00 27.69           C  
ATOM   1044  O   VAL A 131      -9.173   1.762  43.579  1.00 26.87           O  
ATOM   1045  CB  VAL A 131     -11.467  -0.551  43.235  1.00 27.40           C  
ATOM   1046  CG1 VAL A 131     -10.193  -1.122  43.821  1.00 28.03           C  
ATOM   1047  CG2 VAL A 131     -12.674  -1.083  44.008  1.00 28.85           C  
ATOM   1048  N   LEU A 132      -9.944   1.613  41.477  1.00 27.88           N  
ATOM   1049  CA  LEU A 132      -8.691   2.070  40.883  1.00 27.81           C  
ATOM   1050  C   LEU A 132      -8.395   3.500  41.337  1.00 28.88           C  
ATOM   1051  O   LEU A 132      -7.295   3.798  41.812  1.00 28.37           O  
ATOM   1052  CB  LEU A 132      -8.787   2.019  39.354  1.00 27.50           C  
ATOM   1053  CG  LEU A 132      -7.508   2.280  38.553  1.00 28.72           C  
ATOM   1054  CD1 LEU A 132      -6.518   1.148  38.773  1.00 27.16           C  
ATOM   1055  CD2 LEU A 132      -7.849   2.395  37.081  1.00 27.66           C  
ATOM   1056  N   LEU A 133      -9.389   4.375  41.197  1.00 28.16           N  
ATOM   1057  CA  LEU A 133      -9.248   5.775  41.590  1.00 29.21           C  
ATOM   1058  C   LEU A 133      -9.028   5.926  43.087  1.00 29.87           C  
ATOM   1059  O   LEU A 133      -8.250   6.778  43.516  1.00 31.37           O  
ATOM   1060  CB  LEU A 133     -10.483   6.574  41.167  1.00 28.08           C  
ATOM   1061  CG  LEU A 133     -10.711   6.622  39.652  1.00 31.72           C  
ATOM   1062  CD1 LEU A 133     -11.941   7.468  39.339  1.00 30.37           C  
ATOM   1063  CD2 LEU A 133      -9.473   7.202  38.971  1.00 30.73           C  
ATOM   1064  N   SER A 134      -9.710   5.102  43.879  1.00 29.89           N  
ATOM   1065  CA  SER A 134      -9.568   5.150  45.331  1.00 31.69           C  
ATOM   1066  C   SER A 134      -8.148   4.788  45.764  1.00 32.51           C  
ATOM   1067  O   SER A 134      -7.588   5.413  46.665  1.00 33.03           O  
ATOM   1068  CB  SER A 134     -10.558   4.191  46.008  1.00 33.30           C  
ATOM   1069  OG  SER A 134     -11.902   4.607  45.820  1.00 36.46           O  
ATOM   1070  N   ARG A 135      -7.567   3.770  45.134  1.00 32.24           N  
ATOM   1071  CA  ARG A 135      -6.209   3.356  45.478  1.00 31.98           C  
ATOM   1072  C   ARG A 135      -5.222   4.455  45.109  1.00 31.92           C  
ATOM   1073  O   ARG A 135      -4.137   4.547  45.677  1.00 30.79           O  
ATOM   1074  CB  ARG A 135      -5.842   2.060  44.756  1.00 31.35           C  
ATOM   1075  CG  ARG A 135      -6.665   0.874  45.209  1.00 30.56           C  
ATOM   1076  CD  ARG A 135      -6.318  -0.373  44.434  1.00 30.63           C  
ATOM   1077  NE  ARG A 135      -7.126  -1.501  44.878  1.00 31.07           N  
ATOM   1078  CZ  ARG A 135      -7.194  -2.671  44.253  1.00 30.26           C  
ATOM   1079  NH1 ARG A 135      -7.961  -3.629  44.745  1.00 28.72           N  
ATOM   1080  NH2 ARG A 135      -6.507  -2.877  43.135  1.00 29.01           N  
ATOM   1081  N   LEU A 136      -5.610   5.281  44.143  1.00 32.04           N  
ATOM   1082  CA  LEU A 136      -4.778   6.395  43.709  1.00 33.03           C  
ATOM   1083  C   LEU A 136      -4.725   7.417  44.844  1.00 33.48           C  
ATOM   1084  O   LEU A 136      -3.646   7.817  45.278  1.00 33.77           O  
ATOM   1085  CB  LEU A 136      -5.371   7.039  42.453  1.00 32.31           C  
ATOM   1086  CG  LEU A 136      -4.725   8.331  41.947  1.00 35.56           C  
ATOM   1087  CD1 LEU A 136      -3.255   8.091  41.630  1.00 36.82           C  
ATOM   1088  CD2 LEU A 136      -5.463   8.816  40.711  1.00 36.53           C  
ATOM   1089  N   LEU A 137      -5.894   7.828  45.328  1.00 34.80           N  
ATOM   1090  CA  LEU A 137      -5.960   8.801  46.418  1.00 37.90           C  
ATOM   1091  C   LEU A 137      -5.289   8.280  47.680  1.00 37.91           C  
ATOM   1092  O   LEU A 137      -4.639   9.033  48.398  1.00 37.04           O  
ATOM   1093  CB  LEU A 137      -7.411   9.164  46.756  1.00 37.09           C  
ATOM   1094  CG  LEU A 137      -8.328   9.772  45.696  1.00 39.87           C  
ATOM   1095  CD1 LEU A 137      -9.293  10.707  46.409  1.00 40.57           C  
ATOM   1096  CD2 LEU A 137      -7.544  10.539  44.653  1.00 38.92           C  
ATOM   1097  N   THR A 138      -5.456   6.991  47.950  1.00 40.21           N  
ATOM   1098  CA  THR A 138      -4.864   6.386  49.139  1.00 43.90           C  
ATOM   1099  C   THR A 138      -3.344   6.516  49.185  1.00 45.95           C  
ATOM   1100  O   THR A 138      -2.786   6.933  50.199  1.00 47.20           O  
ATOM   1101  CB  THR A 138      -5.240   4.891  49.257  1.00 44.01           C  
ATOM   1102  OG1 THR A 138      -6.633   4.776  49.586  1.00 45.21           O  
ATOM   1103  CG2 THR A 138      -4.409   4.210  50.341  1.00 43.55           C  
ATOM   1104  N   ARG A 139      -2.670   6.166  48.095  1.00 48.24           N  
ATOM   1105  CA  ARG A 139      -1.215   6.253  48.067  1.00 50.11           C  
ATOM   1106  C   ARG A 139      -0.702   7.622  47.610  1.00 52.24           C  
ATOM   1107  O   ARG A 139       0.471   7.768  47.263  1.00 53.15           O  
ATOM   1108  CB  ARG A 139      -0.638   5.151  47.172  1.00 49.20           C  
ATOM   1109  CG  ARG A 139      -1.109   5.197  45.730  1.00 48.86           C  
ATOM   1110  CD  ARG A 139      -0.367   4.182  44.863  1.00 47.17           C  
ATOM   1111  NE  ARG A 139      -0.771   4.291  43.462  1.00 46.39           N  
ATOM   1112  CZ  ARG A 139      -1.930   3.852  42.980  1.00 45.31           C  
ATOM   1113  NH1 ARG A 139      -2.213   4.005  41.693  1.00 42.09           N  
ATOM   1114  NH2 ARG A 139      -2.793   3.237  43.777  1.00 45.23           N  
ATOM   1115  N   ASN A 140      -1.578   8.624  47.620  1.00 53.56           N  
ATOM   1116  CA  ASN A 140      -1.193   9.972  47.203  1.00 55.41           C  
ATOM   1117  C   ASN A 140      -1.645  11.068  48.165  1.00 55.91           C  
ATOM   1118  O   ASN A 140      -2.723  10.997  48.754  1.00 55.87           O  
ATOM   1119  CB  ASN A 140      -1.741  10.272  45.803  1.00 55.94           C  
ATOM   1120  CG  ASN A 140      -0.890   9.670  44.702  1.00 56.65           C  
ATOM   1121  OD1 ASN A 140       0.238  10.106  44.467  1.00 57.11           O  
ATOM   1122  ND2 ASN A 140      -1.423   8.659  44.024  1.00 56.88           N  
ATOM   1123  N   THR A 141      -0.798  12.081  48.317  1.00 56.56           N  
ATOM   1124  CA  THR A 141      -1.087  13.220  49.179  1.00 57.61           C  
ATOM   1125  C   THR A 141      -0.897  14.475  48.332  1.00 57.84           C  
ATOM   1126  O   THR A 141      -0.032  15.306  48.611  1.00 58.13           O  
ATOM   1127  CB  THR A 141      -0.139  13.238  50.374  1.00 58.04           C  
ATOM   1128  N   GLU A 142      -1.711  14.590  47.286  1.00 57.38           N  
ATOM   1129  CA  GLU A 142      -1.645  15.717  46.367  1.00 56.28           C  
ATOM   1130  C   GLU A 142      -2.782  16.707  46.573  1.00 54.32           C  
ATOM   1131  O   GLU A 142      -3.694  16.475  47.371  1.00 54.21           O  
ATOM   1132  CB  GLU A 142      -1.686  15.211  44.922  1.00 58.81           C  
ATOM   1133  CG  GLU A 142      -0.484  14.384  44.512  1.00 61.91           C  
ATOM   1134  CD  GLU A 142       0.766  15.225  44.361  1.00 64.73           C  
ATOM   1135  OE1 GLU A 142       0.777  16.123  43.491  1.00 65.52           O  
ATOM   1136  OE2 GLU A 142       1.737  14.991  45.114  1.00 66.28           O  
ATOM   1137  N   ASN A 143      -2.718  17.816  45.844  1.00 50.82           N  
ATOM   1138  CA  ASN A 143      -3.748  18.836  45.921  1.00 47.70           C  
ATOM   1139  C   ASN A 143      -4.749  18.578  44.797  1.00 45.35           C  
ATOM   1140  O   ASN A 143      -4.474  17.811  43.873  1.00 44.25           O  
ATOM   1141  CB  ASN A 143      -3.132  20.222  45.790  1.00 47.92           C  
ATOM   1142  N   GLN A 144      -5.905  19.223  44.888  1.00 42.14           N  
ATOM   1143  CA  GLN A 144      -6.985  19.069  43.918  1.00 39.54           C  
ATOM   1144  C   GLN A 144      -6.607  18.940  42.442  1.00 38.33           C  
ATOM   1145  O   GLN A 144      -6.823  17.890  41.832  1.00 36.61           O  
ATOM   1146  CB  GLN A 144      -7.982  20.219  44.091  1.00 38.65           C  
ATOM   1147  CG  GLN A 144      -8.755  20.167  45.395  1.00 36.09           C  
ATOM   1148  CD  GLN A 144      -9.692  21.341  45.560  1.00 35.90           C  
ATOM   1149  OE1 GLN A 144      -9.286  22.423  45.990  1.00 38.17           O  
ATOM   1150  NE2 GLN A 144     -10.953  21.144  45.196  1.00 34.42           N  
ATOM   1151  N   GLU A 145      -6.059  20.005  41.867  1.00 38.36           N  
ATOM   1152  CA  GLU A 145      -5.683  20.012  40.455  1.00 37.89           C  
ATOM   1153  C   GLU A 145      -4.763  18.857  40.065  1.00 37.61           C  
ATOM   1154  O   GLU A 145      -4.969  18.215  39.036  1.00 35.77           O  
ATOM   1155  CB  GLU A 145      -5.025  21.347  40.096  1.00 38.60           C  
ATOM   1156  N   GLN A 146      -3.749  18.596  40.882  1.00 37.90           N  
ATOM   1157  CA  GLN A 146      -2.808  17.522  40.589  1.00 38.34           C  
ATOM   1158  C   GLN A 146      -3.432  16.132  40.686  1.00 37.07           C  
ATOM   1159  O   GLN A 146      -3.215  15.295  39.810  1.00 35.81           O  
ATOM   1160  CB  GLN A 146      -1.591  17.614  41.514  1.00 40.83           C  
ATOM   1161  CG  GLN A 146      -0.780  18.892  41.319  1.00 47.36           C  
ATOM   1162  CD  GLN A 146      -0.236  19.042  39.901  1.00 50.29           C  
ATOM   1163  OE1 GLN A 146       0.202  20.125  39.503  1.00 52.41           O  
ATOM   1164  NE2 GLN A 146      -0.254  17.952  39.139  1.00 50.30           N  
ATOM   1165  N   ILE A 147      -4.200  15.879  41.743  1.00 35.10           N  
ATOM   1166  CA  ILE A 147      -4.829  14.571  41.899  1.00 33.00           C  
ATOM   1167  C   ILE A 147      -5.863  14.334  40.802  1.00 32.42           C  
ATOM   1168  O   ILE A 147      -6.119  13.190  40.411  1.00 31.42           O  
ATOM   1169  CB  ILE A 147      -5.522  14.421  43.273  1.00 34.79           C  
ATOM   1170  CG1 ILE A 147      -5.805  12.946  43.541  1.00 34.53           C  
ATOM   1171  CG2 ILE A 147      -6.837  15.193  43.296  1.00 33.97           C  
ATOM   1172  CD1 ILE A 147      -4.558  12.084  43.572  1.00 36.30           C  
ATOM   1173  N   GLN A 148      -6.467  15.411  40.307  1.00 30.24           N  
ATOM   1174  CA  GLN A 148      -7.457  15.278  39.246  1.00 29.31           C  
ATOM   1175  C   GLN A 148      -6.755  14.859  37.961  1.00 29.91           C  
ATOM   1176  O   GLN A 148      -7.313  14.121  37.155  1.00 27.36           O  
ATOM   1177  CB  GLN A 148      -8.208  16.598  39.027  1.00 28.56           C  
ATOM   1178  CG  GLN A 148      -9.261  16.534  37.922  1.00 29.95           C  
ATOM   1179  CD  GLN A 148      -8.674  16.712  36.522  1.00 29.90           C  
ATOM   1180  OE1 GLN A 148      -9.302  16.359  35.521  1.00 31.65           O  
ATOM   1181  NE2 GLN A 148      -7.473  17.270  36.451  1.00 31.79           N  
ATOM   1182  N   LYS A 149      -5.529  15.337  37.771  1.00 32.37           N  
ATOM   1183  CA  LYS A 149      -4.770  14.997  36.572  1.00 35.99           C  
ATOM   1184  C   LYS A 149      -4.443  13.507  36.541  1.00 35.63           C  
ATOM   1185  O   LYS A 149      -4.502  12.873  35.490  1.00 34.58           O  
ATOM   1186  CB  LYS A 149      -3.487  15.833  36.491  1.00 37.77           C  
ATOM   1187  CG  LYS A 149      -3.771  17.312  36.258  1.00 41.85           C  
ATOM   1188  CD  LYS A 149      -2.516  18.101  35.929  1.00 44.36           C  
ATOM   1189  CE  LYS A 149      -2.858  19.565  35.698  1.00 45.10           C  
ATOM   1190  NZ  LYS A 149      -1.667  20.375  35.327  1.00 46.19           N  
ATOM   1191  N   ARG A 150      -4.110  12.947  37.696  1.00 35.80           N  
ATOM   1192  CA  ARG A 150      -3.801  11.528  37.763  1.00 36.52           C  
ATOM   1193  C   ARG A 150      -5.063  10.691  37.579  1.00 35.19           C  
ATOM   1194  O   ARG A 150      -5.008   9.591  37.031  1.00 35.02           O  
ATOM   1195  CB  ARG A 150      -3.094  11.217  39.082  1.00 39.63           C  
ATOM   1196  CG  ARG A 150      -1.722  11.874  39.127  1.00 44.66           C  
ATOM   1197  CD  ARG A 150      -0.990  11.682  40.436  1.00 49.82           C  
ATOM   1198  NE  ARG A 150       0.324  12.320  40.371  1.00 53.77           N  
ATOM   1199  CZ  ARG A 150       1.158  12.434  41.397  1.00 54.87           C  
ATOM   1200  NH1 ARG A 150       2.331  13.032  41.230  1.00 55.90           N  
ATOM   1201  NH2 ARG A 150       0.821  11.956  42.589  1.00 56.58           N  
ATOM   1202  N   MET A 151      -6.204  11.220  38.013  1.00 33.47           N  
ATOM   1203  CA  MET A 151      -7.476  10.517  37.846  1.00 32.52           C  
ATOM   1204  C   MET A 151      -7.813  10.457  36.356  1.00 31.78           C  
ATOM   1205  O   MET A 151      -8.277   9.434  35.843  1.00 30.06           O  
ATOM   1206  CB  MET A 151      -8.601  11.250  38.579  1.00 32.29           C  
ATOM   1207  CG  MET A 151      -8.625  11.034  40.079  1.00 35.02           C  
ATOM   1208  SD  MET A 151      -9.867  12.067  40.887  1.00 35.83           S  
ATOM   1209  CE  MET A 151      -8.934  12.640  42.268  1.00 36.84           C  
ATOM   1210  N   GLU A 152      -7.583  11.564  35.662  1.00 31.32           N  
ATOM   1211  CA  GLU A 152      -7.865  11.616  34.239  1.00 32.22           C  
ATOM   1212  C   GLU A 152      -6.913  10.683  33.500  1.00 29.87           C  
ATOM   1213  O   GLU A 152      -7.308  10.031  32.544  1.00 29.05           O  
ATOM   1214  CB  GLU A 152      -7.729  13.048  33.715  1.00 35.75           C  
ATOM   1215  CG  GLU A 152      -8.144  13.217  32.261  1.00 40.83           C  
ATOM   1216  CD  GLU A 152      -9.459  12.519  31.937  1.00 46.09           C  
ATOM   1217  OE1 GLU A 152     -10.428  12.660  32.719  1.00 49.38           O  
ATOM   1218  OE2 GLU A 152      -9.527  11.830  30.894  1.00 47.62           O  
ATOM   1219  N   GLN A 153      -5.661  10.623  33.948  1.00 29.20           N  
ATOM   1220  CA  GLN A 153      -4.668   9.746  33.326  1.00 28.72           C  
ATOM   1221  C   GLN A 153      -5.111   8.289  33.411  1.00 27.20           C  
ATOM   1222  O   GLN A 153      -4.946   7.523  32.459  1.00 26.19           O  
ATOM   1223  CB  GLN A 153      -3.306   9.912  34.010  1.00 31.13           C  
ATOM   1224  CG  GLN A 153      -2.535  11.156  33.572  1.00 34.03           C  
ATOM   1225  CD  GLN A 153      -1.419  11.535  34.531  1.00 36.63           C  
ATOM   1226  OE1 GLN A 153      -0.535  10.732  34.836  1.00 37.75           O  
ATOM   1227  NE2 GLN A 153      -1.454  12.772  35.010  1.00 41.51           N  
ATOM   1228  N   LEU A 154      -5.672   7.906  34.551  1.00 25.78           N  
ATOM   1229  CA  LEU A 154      -6.142   6.541  34.734  1.00 28.59           C  
ATOM   1230  C   LEU A 154      -7.391   6.270  33.897  1.00 28.14           C  
ATOM   1231  O   LEU A 154      -7.601   5.147  33.435  1.00 29.30           O  
ATOM   1232  CB  LEU A 154      -6.411   6.263  36.219  1.00 29.38           C  
ATOM   1233  CG  LEU A 154      -5.152   6.215  37.096  1.00 32.82           C  
ATOM   1234  CD1 LEU A 154      -5.519   5.917  38.550  1.00 34.16           C  
ATOM   1235  CD2 LEU A 154      -4.217   5.138  36.572  1.00 33.63           C  
ATOM   1236  N   ASN A 155      -8.221   7.291  33.696  1.00 29.07           N  
ATOM   1237  CA  ASN A 155      -9.421   7.119  32.885  1.00 30.83           C  
ATOM   1238  C   ASN A 155      -8.977   6.909  31.445  1.00 30.24           C  
ATOM   1239  O   ASN A 155      -9.580   6.135  30.709  1.00 29.25           O  
ATOM   1240  CB  ASN A 155     -10.346   8.345  32.961  1.00 33.20           C  
ATOM   1241  CG  ASN A 155     -11.035   8.481  34.310  1.00 37.36           C  
ATOM   1242  OD1 ASN A 155     -11.502   7.494  34.883  1.00 39.46           O  
ATOM   1243  ND2 ASN A 155     -11.119   9.709  34.814  1.00 38.01           N  
ATOM   1244  N   ILE A 156      -7.916   7.600  31.047  1.00 29.98           N  
ATOM   1245  CA  ILE A 156      -7.405   7.452  29.690  1.00 31.29           C  
ATOM   1246  C   ILE A 156      -6.827   6.045  29.510  1.00 32.06           C  
ATOM   1247  O   ILE A 156      -7.065   5.400  28.492  1.00 33.61           O  
ATOM   1248  CB  ILE A 156      -6.334   8.523  29.372  1.00 32.21           C  
ATOM   1249  CG1 ILE A 156      -6.955   9.918  29.509  1.00 31.83           C  
ATOM   1250  CG2 ILE A 156      -5.801   8.333  27.949  1.00 32.68           C  
ATOM   1251  CD1 ILE A 156      -5.981  11.074  29.293  1.00 33.13           C  
ATOM   1252  N   GLU A 157      -6.086   5.561  30.504  1.00 31.09           N  
ATOM   1253  CA  GLU A 157      -5.511   4.219  30.428  1.00 31.75           C  
ATOM   1254  C   GLU A 157      -6.585   3.183  30.103  1.00 31.34           C  
ATOM   1255  O   GLU A 157      -6.432   2.382  29.179  1.00 30.72           O  
ATOM   1256  CB  GLU A 157      -4.844   3.835  31.758  1.00 32.04           C  
ATOM   1257  CG  GLU A 157      -3.473   4.446  31.993  1.00 33.85           C  
ATOM   1258  CD  GLU A 157      -2.325   3.579  31.478  1.00 37.38           C  
ATOM   1259  OE1 GLU A 157      -2.173   2.433  31.967  1.00 35.82           O  
ATOM   1260  OE2 GLU A 157      -1.570   4.048  30.592  1.00 36.22           O  
ATOM   1261  N   LEU A 158      -7.668   3.198  30.876  1.00 30.05           N  
ATOM   1262  CA  LEU A 158      -8.756   2.251  30.681  1.00 30.60           C  
ATOM   1263  C   LEU A 158      -9.418   2.424  29.317  1.00 30.56           C  
ATOM   1264  O   LEU A 158      -9.787   1.445  28.675  1.00 30.24           O  
ATOM   1265  CB  LEU A 158      -9.803   2.410  31.793  1.00 31.66           C  
ATOM   1266  CG  LEU A 158      -9.325   2.229  33.240  1.00 33.04           C  
ATOM   1267  CD1 LEU A 158     -10.485   2.487  34.189  1.00 33.34           C  
ATOM   1268  CD2 LEU A 158      -8.767   0.828  33.441  1.00 31.29           C  
ATOM   1269  N   HIS A 159      -9.573   3.669  28.880  1.00 31.03           N  
ATOM   1270  CA  HIS A 159     -10.189   3.943  27.587  1.00 32.47           C  
ATOM   1271  C   HIS A 159      -9.306   3.415  26.455  1.00 31.67           C  
ATOM   1272  O   HIS A 159      -9.801   2.822  25.497  1.00 31.01           O  
ATOM   1273  CB  HIS A 159     -10.426   5.449  27.433  1.00 36.55           C  
ATOM   1274  CG  HIS A 159     -10.993   5.844  26.105  1.00 39.22           C  
ATOM   1275  ND1 HIS A 159     -10.217   5.975  24.973  1.00 41.40           N  
ATOM   1276  CD2 HIS A 159     -12.262   6.131  25.727  1.00 41.54           C  
ATOM   1277  CE1 HIS A 159     -10.982   6.329  23.955  1.00 42.05           C  
ATOM   1278  NE2 HIS A 159     -12.227   6.430  24.385  1.00 42.57           N  
ATOM   1279  N   GLU A 160      -7.997   3.624  26.578  1.00 31.03           N  
ATOM   1280  CA  GLU A 160      -7.038   3.160  25.578  1.00 31.45           C  
ATOM   1281  C   GLU A 160      -6.985   1.637  25.552  1.00 31.49           C  
ATOM   1282  O   GLU A 160      -6.834   1.029  24.489  1.00 29.14           O  
ATOM   1283  CB  GLU A 160      -5.644   3.713  25.882  1.00 33.04           C  
ATOM   1284  CG  GLU A 160      -5.514   5.218  25.685  1.00 36.91           C  
ATOM   1285  CD  GLU A 160      -5.829   5.636  24.261  1.00 40.53           C  
ATOM   1286  OE1 GLU A 160      -5.216   5.070  23.328  1.00 42.99           O  
ATOM   1287  OE2 GLU A 160      -6.687   6.526  24.072  1.00 41.76           O  
ATOM   1288  N   ALA A 161      -7.105   1.027  26.730  1.00 29.97           N  
ATOM   1289  CA  ALA A 161      -7.078  -0.424  26.850  1.00 29.78           C  
ATOM   1290  C   ALA A 161      -8.233  -1.049  26.085  1.00 30.31           C  
ATOM   1291  O   ALA A 161      -8.104  -2.139  25.525  1.00 29.38           O  
ATOM   1292  CB  ALA A 161      -7.140  -0.841  28.320  1.00 27.33           C  
ATOM   1293  N   ASN A 162      -9.360  -0.347  26.062  1.00 31.37           N  
ATOM   1294  CA  ASN A 162     -10.554  -0.825  25.373  1.00 32.88           C  
ATOM   1295  C   ASN A 162     -10.366  -0.914  23.857  1.00 32.26           C  
ATOM   1296  O   ASN A 162     -11.099  -1.636  23.184  1.00 32.67           O  
ATOM   1297  CB  ASN A 162     -11.734   0.097  25.684  1.00 36.25           C  
ATOM   1298  CG  ASN A 162     -13.031  -0.392  25.075  1.00 40.34           C  
ATOM   1299  OD1 ASN A 162     -13.951   0.388  24.845  1.00 44.17           O  
ATOM   1300  ND2 ASN A 162     -13.117  -1.695  24.823  1.00 43.38           N  
ATOM   1301  N   LEU A 163      -9.389  -0.183  23.326  1.00 31.22           N  
ATOM   1302  CA  LEU A 163      -9.126  -0.181  21.888  1.00 31.50           C  
ATOM   1303  C   LEU A 163      -8.050  -1.178  21.460  1.00 31.11           C  
ATOM   1304  O   LEU A 163      -7.756  -1.316  20.273  1.00 31.29           O  
ATOM   1305  CB  LEU A 163      -8.724   1.226  21.434  1.00 32.69           C  
ATOM   1306  CG  LEU A 163      -9.801   2.293  21.667  1.00 33.74           C  
ATOM   1307  CD1 LEU A 163      -9.283   3.674  21.304  1.00 34.99           C  
ATOM   1308  CD2 LEU A 163     -11.019   1.946  20.841  1.00 34.62           C  
ATOM   1309  N   LEU A 164      -7.470  -1.884  22.424  1.00 29.14           N  
ATOM   1310  CA  LEU A 164      -6.426  -2.847  22.113  1.00 26.44           C  
ATOM   1311  C   LEU A 164      -6.869  -4.275  22.373  1.00 26.04           C  
ATOM   1312  O   LEU A 164      -7.868  -4.524  23.058  1.00 25.72           O  
ATOM   1313  CB  LEU A 164      -5.170  -2.559  22.946  1.00 26.00           C  
ATOM   1314  CG  LEU A 164      -4.481  -1.193  22.840  1.00 25.33           C  
ATOM   1315  CD1 LEU A 164      -3.456  -1.059  23.958  1.00 25.23           C  
ATOM   1316  CD2 LEU A 164      -3.805  -1.052  21.478  1.00 25.22           C  
ATOM   1317  N   ASN A 165      -6.110  -5.212  21.824  1.00 24.30           N  
ATOM   1318  CA  ASN A 165      -6.388  -6.625  22.016  1.00 26.24           C  
ATOM   1319  C   ASN A 165      -5.280  -7.225  22.882  1.00 25.70           C  
ATOM   1320  O   ASN A 165      -4.105  -6.908  22.712  1.00 23.81           O  
ATOM   1321  CB  ASN A 165      -6.441  -7.361  20.674  1.00 26.22           C  
ATOM   1322  CG  ASN A 165      -7.542  -6.845  19.765  1.00 29.20           C  
ATOM   1323  OD1 ASN A 165      -8.639  -6.524  20.217  1.00 30.07           O  
ATOM   1324  ND2 ASN A 165      -7.255  -6.775  18.475  1.00 31.42           N  
ATOM   1325  N   PHE A 166      -5.671  -8.077  23.821  1.00 25.52           N  
ATOM   1326  CA  PHE A 166      -4.728  -8.746  24.709  1.00 25.67           C  
ATOM   1327  C   PHE A 166      -4.936 -10.246  24.560  1.00 26.56           C  
ATOM   1328  O   PHE A 166      -6.010 -10.683  24.150  1.00 24.67           O  
ATOM   1329  CB  PHE A 166      -4.977  -8.333  26.162  1.00 24.83           C  
ATOM   1330  CG  PHE A 166      -4.879  -6.857  26.390  1.00 24.04           C  
ATOM   1331  CD1 PHE A 166      -6.026  -6.075  26.469  1.00 24.55           C  
ATOM   1332  CD2 PHE A 166      -3.638  -6.240  26.484  1.00 23.56           C  
ATOM   1333  CE1 PHE A 166      -5.934  -4.695  26.636  1.00 24.93           C  
ATOM   1334  CE2 PHE A 166      -3.534  -4.861  26.651  1.00 23.07           C  
ATOM   1335  CZ  PHE A 166      -4.679  -4.092  26.727  1.00 24.56           C  
ATOM   1336  N   ASN A 167      -3.914 -11.033  24.884  1.00 25.58           N  
ATOM   1337  CA  ASN A 167      -4.031 -12.476  24.780  1.00 25.67           C  
ATOM   1338  C   ASN A 167      -4.892 -13.003  25.917  1.00 25.24           C  
ATOM   1339  O   ASN A 167      -5.568 -14.020  25.778  1.00 25.40           O  
ATOM   1340  CB  ASN A 167      -2.652 -13.124  24.806  1.00 25.30           C  
ATOM   1341  CG  ASN A 167      -1.785 -12.668  23.652  1.00 27.98           C  
ATOM   1342  OD1 ASN A 167      -1.032 -11.698  23.766  1.00 25.39           O  
ATOM   1343  ND2 ASN A 167      -1.906 -13.354  22.518  1.00 28.84           N  
ATOM   1344  N   LEU A 168      -4.867 -12.291  27.035  1.00 23.99           N  
ATOM   1345  CA  LEU A 168      -5.655 -12.647  28.206  1.00 23.38           C  
ATOM   1346  C   LEU A 168      -5.889 -11.397  29.037  1.00 23.99           C  
ATOM   1347  O   LEU A 168      -5.005 -10.545  29.152  1.00 24.91           O  
ATOM   1348  CB  LEU A 168      -4.927 -13.686  29.061  1.00 22.12           C  
ATOM   1349  CG  LEU A 168      -5.645 -14.069  30.369  1.00 23.05           C  
ATOM   1350  CD1 LEU A 168      -6.908 -14.846  30.048  1.00 25.01           C  
ATOM   1351  CD2 LEU A 168      -4.726 -14.902  31.248  1.00 18.39           C  
ATOM   1352  N   SER A 169      -7.088 -11.293  29.602  1.00 24.72           N  
ATOM   1353  CA  SER A 169      -7.461 -10.165  30.446  1.00 25.56           C  
ATOM   1354  C   SER A 169      -8.026 -10.757  31.727  1.00 26.27           C  
ATOM   1355  O   SER A 169      -8.848 -11.670  31.677  1.00 25.55           O  
ATOM   1356  CB  SER A 169      -8.532  -9.301  29.765  1.00 27.09           C  
ATOM   1357  OG  SER A 169      -8.006  -8.610  28.641  1.00 31.54           O  
ATOM   1358  N   ILE A 170      -7.577 -10.248  32.872  1.00 25.40           N  
ATOM   1359  CA  ILE A 170      -8.056 -10.753  34.155  1.00 27.15           C  
ATOM   1360  C   ILE A 170      -8.450  -9.646  35.117  1.00 26.79           C  
ATOM   1361  O   ILE A 170      -7.657  -8.746  35.391  1.00 24.70           O  
ATOM   1362  CB  ILE A 170      -6.983 -11.590  34.894  1.00 27.19           C  
ATOM   1363  CG1 ILE A 170      -6.464 -12.722  34.010  1.00 27.73           C  
ATOM   1364  CG2 ILE A 170      -7.582 -12.171  36.174  1.00 30.36           C  
ATOM   1365  CD1 ILE A 170      -5.333 -13.506  34.655  1.00 27.30           C  
ATOM   1366  N   ILE A 171      -9.671  -9.715  35.636  1.00 27.09           N  
ATOM   1367  CA  ILE A 171     -10.114  -8.735  36.616  1.00 28.54           C  
ATOM   1368  C   ILE A 171      -9.508  -9.217  37.932  1.00 29.63           C  
ATOM   1369  O   ILE A 171      -9.923 -10.241  38.472  1.00 31.15           O  
ATOM   1370  CB  ILE A 171     -11.654  -8.695  36.726  1.00 29.77           C  
ATOM   1371  CG1 ILE A 171     -12.246  -8.190  35.406  1.00 31.58           C  
ATOM   1372  CG2 ILE A 171     -12.079  -7.781  37.876  1.00 30.16           C  
ATOM   1373  CD1 ILE A 171     -13.763  -8.103  35.396  1.00 32.72           C  
ATOM   1374  N   ASN A 172      -8.516  -8.488  38.439  1.00 30.05           N  
ATOM   1375  CA  ASN A 172      -7.845  -8.877  39.674  1.00 30.36           C  
ATOM   1376  C   ASN A 172      -8.630  -8.519  40.929  1.00 31.03           C  
ATOM   1377  O   ASN A 172      -8.319  -7.544  41.611  1.00 28.48           O  
ATOM   1378  CB  ASN A 172      -6.442  -8.255  39.736  1.00 29.30           C  
ATOM   1379  CG  ASN A 172      -5.646  -8.710  40.953  1.00 31.34           C  
ATOM   1380  OD1 ASN A 172      -5.965  -9.723  41.581  1.00 31.18           O  
ATOM   1381  ND2 ASN A 172      -4.594  -7.970  41.281  1.00 30.81           N  
ATOM   1382  N   ASP A 173      -9.652  -9.321  41.218  1.00 33.61           N  
ATOM   1383  CA  ASP A 173     -10.486  -9.132  42.400  1.00 37.12           C  
ATOM   1384  C   ASP A 173      -9.817  -9.817  43.585  1.00 37.11           C  
ATOM   1385  O   ASP A 173      -9.736  -9.260  44.676  1.00 38.80           O  
ATOM   1386  CB  ASP A 173     -11.875  -9.750  42.196  1.00 39.39           C  
ATOM   1387  CG  ASP A 173     -12.697  -9.017  41.162  1.00 43.20           C  
ATOM   1388  OD1 ASP A 173     -12.804  -7.776  41.263  1.00 44.43           O  
ATOM   1389  OD2 ASP A 173     -13.243  -9.681  40.251  1.00 46.63           O  
ATOM   1390  N   ASP A 174      -9.350 -11.039  43.354  1.00 38.22           N  
ATOM   1391  CA  ASP A 174      -8.687 -11.836  44.383  1.00 38.30           C  
ATOM   1392  C   ASP A 174      -7.313 -12.269  43.869  1.00 36.32           C  
ATOM   1393  O   ASP A 174      -7.214 -12.976  42.868  1.00 35.84           O  
ATOM   1394  CB  ASP A 174      -9.538 -13.069  44.713  1.00 40.96           C  
ATOM   1395  CG  ASP A 174      -8.820 -14.055  45.619  1.00 44.35           C  
ATOM   1396  OD1 ASP A 174      -9.387 -15.137  45.886  1.00 49.12           O  
ATOM   1397  OD2 ASP A 174      -7.695 -13.759  46.069  1.00 47.32           O  
ATOM   1398  N   LEU A 175      -6.264 -11.845  44.564  1.00 34.58           N  
ATOM   1399  CA  LEU A 175      -4.895 -12.164  44.172  1.00 34.24           C  
ATOM   1400  C   LEU A 175      -4.648 -13.643  43.881  1.00 33.96           C  
ATOM   1401  O   LEU A 175      -4.088 -13.994  42.843  1.00 34.48           O  
ATOM   1402  CB  LEU A 175      -3.917 -11.694  45.253  1.00 34.62           C  
ATOM   1403  CG  LEU A 175      -2.453 -12.060  45.011  1.00 35.26           C  
ATOM   1404  CD1 LEU A 175      -1.957 -11.397  43.723  1.00 37.18           C  
ATOM   1405  CD2 LEU A 175      -1.619 -11.618  46.195  1.00 37.04           C  
ATOM   1406  N   THR A 176      -5.054 -14.501  44.809  1.00 32.95           N  
ATOM   1407  CA  THR A 176      -4.869 -15.944  44.671  1.00 32.13           C  
ATOM   1408  C   THR A 176      -5.453 -16.489  43.368  1.00 30.92           C  
ATOM   1409  O   THR A 176      -4.772 -17.182  42.614  1.00 30.60           O  
ATOM   1410  CB  THR A 176      -5.508 -16.681  45.875  1.00 32.48           C  
ATOM   1411  OG1 THR A 176      -4.764 -16.373  47.060  1.00 35.15           O  
ATOM   1412  CG2 THR A 176      -5.514 -18.186  45.662  1.00 31.09           C  
ATOM   1413  N   LEU A 177      -6.714 -16.167  43.109  1.00 29.79           N  
ATOM   1414  CA  LEU A 177      -7.389 -16.626  41.908  1.00 29.81           C  
ATOM   1415  C   LEU A 177      -6.752 -16.047  40.649  1.00 28.28           C  
ATOM   1416  O   LEU A 177      -6.651 -16.720  39.631  1.00 28.14           O  
ATOM   1417  CB  LEU A 177      -8.865 -16.237  41.971  1.00 32.94           C  
ATOM   1418  CG  LEU A 177      -9.573 -16.758  43.226  1.00 36.11           C  
ATOM   1419  CD1 LEU A 177     -10.966 -16.153  43.325  1.00 38.45           C  
ATOM   1420  CD2 LEU A 177      -9.634 -18.284  43.180  1.00 36.84           C  
ATOM   1421  N   THR A 178      -6.321 -14.795  40.724  1.00 27.17           N  
ATOM   1422  CA  THR A 178      -5.701 -14.144  39.581  1.00 26.25           C  
ATOM   1423  C   THR A 178      -4.366 -14.804  39.261  1.00 25.82           C  
ATOM   1424  O   THR A 178      -4.069 -15.109  38.102  1.00 21.78           O  
ATOM   1425  CB  THR A 178      -5.473 -12.650  39.856  1.00 25.80           C  
ATOM   1426  OG1 THR A 178      -6.733 -12.036  40.142  1.00 25.14           O  
ATOM   1427  CG2 THR A 178      -4.847 -11.959  38.643  1.00 23.33           C  
ATOM   1428  N   TYR A 179      -3.562 -15.034  40.293  1.00 24.42           N  
ATOM   1429  CA  TYR A 179      -2.268 -15.656  40.078  1.00 25.75           C  
ATOM   1430  C   TYR A 179      -2.431 -17.064  39.513  1.00 26.26           C  
ATOM   1431  O   TYR A 179      -1.650 -17.496  38.666  1.00 26.66           O  
ATOM   1432  CB  TYR A 179      -1.471 -15.729  41.375  1.00 25.10           C  
ATOM   1433  CG  TYR A 179      -0.104 -16.312  41.147  1.00 26.36           C  
ATOM   1434  CD1 TYR A 179       0.863 -15.598  40.439  1.00 26.49           C  
ATOM   1435  CD2 TYR A 179       0.203 -17.605  41.564  1.00 26.03           C  
ATOM   1436  CE1 TYR A 179       2.097 -16.156  40.146  1.00 26.89           C  
ATOM   1437  CE2 TYR A 179       1.440 -18.178  41.277  1.00 25.78           C  
ATOM   1438  CZ  TYR A 179       2.380 -17.444  40.562  1.00 27.12           C  
ATOM   1439  OH  TYR A 179       3.593 -18.001  40.233  1.00 27.19           O  
ATOM   1440  N   GLN A 180      -3.444 -17.776  39.993  1.00 27.35           N  
ATOM   1441  CA  GLN A 180      -3.713 -19.134  39.534  1.00 28.73           C  
ATOM   1442  C   GLN A 180      -4.048 -19.162  38.041  1.00 27.84           C  
ATOM   1443  O   GLN A 180      -3.528 -19.992  37.298  1.00 27.04           O  
ATOM   1444  CB  GLN A 180      -4.860 -19.743  40.347  1.00 31.63           C  
ATOM   1445  CG  GLN A 180      -5.477 -20.986  39.729  1.00 35.37           C  
ATOM   1446  CD  GLN A 180      -6.494 -21.638  40.642  1.00 38.08           C  
ATOM   1447  OE1 GLN A 180      -6.133 -22.340  41.585  1.00 40.22           O  
ATOM   1448  NE2 GLN A 180      -7.775 -21.399  40.373  1.00 38.93           N  
ATOM   1449  N   GLN A 181      -4.919 -18.261  37.602  1.00 27.45           N  
ATOM   1450  CA  GLN A 181      -5.275 -18.209  36.190  1.00 27.98           C  
ATOM   1451  C   GLN A 181      -4.026 -17.815  35.408  1.00 27.54           C  
ATOM   1452  O   GLN A 181      -3.735 -18.370  34.350  1.00 27.75           O  
ATOM   1453  CB  GLN A 181      -6.356 -17.159  35.931  1.00 28.85           C  
ATOM   1454  CG  GLN A 181      -7.641 -17.318  36.720  1.00 34.46           C  
ATOM   1455  CD  GLN A 181      -8.568 -16.123  36.528  1.00 35.69           C  
ATOM   1456  OE1 GLN A 181      -8.992 -15.824  35.410  1.00 37.57           O  
ATOM   1457  NE2 GLN A 181      -8.875 -15.428  37.619  1.00 35.31           N  
ATOM   1458  N   LEU A 182      -3.291 -16.845  35.940  1.00 27.33           N  
ATOM   1459  CA  LEU A 182      -2.085 -16.361  35.287  1.00 26.53           C  
ATOM   1460  C   LEU A 182      -1.067 -17.477  35.131  1.00 26.23           C  
ATOM   1461  O   LEU A 182      -0.541 -17.708  34.043  1.00 25.88           O  
ATOM   1462  CB  LEU A 182      -1.467 -15.216  36.089  1.00 27.03           C  
ATOM   1463  CG  LEU A 182      -0.207 -14.615  35.452  1.00 29.90           C  
ATOM   1464  CD1 LEU A 182      -0.540 -14.104  34.047  1.00 28.65           C  
ATOM   1465  CD2 LEU A 182       0.337 -13.493  36.327  1.00 28.67           C  
ATOM   1466  N   LYS A 183      -0.795 -18.163  36.234  1.00 24.84           N  
ATOM   1467  CA  LYS A 183       0.157 -19.259  36.240  1.00 23.86           C  
ATOM   1468  C   LYS A 183      -0.223 -20.368  35.257  1.00 23.05           C  
ATOM   1469  O   LYS A 183       0.623 -20.837  34.501  1.00 21.87           O  
ATOM   1470  CB  LYS A 183       0.272 -19.834  37.654  1.00 23.78           C  
ATOM   1471  CG  LYS A 183       1.163 -21.068  37.762  1.00 26.29           C  
ATOM   1472  CD  LYS A 183       1.213 -21.594  39.194  1.00 29.14           C  
ATOM   1473  CE  LYS A 183       1.896 -22.950  39.245  1.00 33.93           C  
ATOM   1474  NZ  LYS A 183       2.101 -23.443  40.639  1.00 35.68           N  
ATOM   1475  N   ASN A 184      -1.487 -20.781  35.246  1.00 22.85           N  
ATOM   1476  CA  ASN A 184      -1.876 -21.854  34.339  1.00 23.90           C  
ATOM   1477  C   ASN A 184      -1.665 -21.449  32.890  1.00 23.94           C  
ATOM   1478  O   ASN A 184      -1.185 -22.237  32.080  1.00 22.63           O  
ATOM   1479  CB  ASN A 184      -3.334 -22.268  34.554  1.00 23.28           C  
ATOM   1480  CG  ASN A 184      -3.682 -23.538  33.798  1.00 25.51           C  
ATOM   1481  OD1 ASN A 184      -4.446 -23.514  32.832  1.00 27.31           O  
ATOM   1482  ND2 ASN A 184      -3.104 -24.655  34.224  1.00 25.18           N  
ATOM   1483  N   TYR A 185      -2.009 -20.205  32.581  1.00 25.24           N  
ATOM   1484  CA  TYR A 185      -1.854 -19.675  31.239  1.00 24.42           C  
ATOM   1485  C   TYR A 185      -0.390 -19.708  30.809  1.00 23.72           C  
ATOM   1486  O   TYR A 185      -0.071 -20.086  29.680  1.00 23.15           O  
ATOM   1487  CB  TYR A 185      -2.357 -18.232  31.198  1.00 28.24           C  
ATOM   1488  CG  TYR A 185      -2.488 -17.683  29.803  1.00 30.72           C  
ATOM   1489  CD1 TYR A 185      -3.645 -17.893  29.063  1.00 32.79           C  
ATOM   1490  CD2 TYR A 185      -1.450 -16.968  29.214  1.00 31.05           C  
ATOM   1491  CE1 TYR A 185      -3.771 -17.402  27.769  1.00 35.26           C  
ATOM   1492  CE2 TYR A 185      -1.565 -16.475  27.913  1.00 33.51           C  
ATOM   1493  CZ  TYR A 185      -2.728 -16.697  27.202  1.00 33.08           C  
ATOM   1494  OH  TYR A 185      -2.865 -16.210  25.924  1.00 38.66           O  
ATOM   1495  N   LEU A 186       0.501 -19.310  31.715  1.00 24.34           N  
ATOM   1496  CA  LEU A 186       1.928 -19.279  31.423  1.00 24.19           C  
ATOM   1497  C   LEU A 186       2.549 -20.675  31.365  1.00 23.91           C  
ATOM   1498  O   LEU A 186       3.483 -20.916  30.597  1.00 23.92           O  
ATOM   1499  CB  LEU A 186       2.657 -18.413  32.455  1.00 25.60           C  
ATOM   1500  CG  LEU A 186       2.213 -16.945  32.483  1.00 27.08           C  
ATOM   1501  CD1 LEU A 186       3.115 -16.167  33.427  1.00 28.20           C  
ATOM   1502  CD2 LEU A 186       2.283 -16.342  31.070  1.00 27.31           C  
ATOM   1503  N   LEU A 187       2.034 -21.596  32.173  1.00 23.17           N  
ATOM   1504  CA  LEU A 187       2.536 -22.965  32.153  1.00 22.81           C  
ATOM   1505  C   LEU A 187       2.277 -23.558  30.771  1.00 21.86           C  
ATOM   1506  O   LEU A 187       3.131 -24.240  30.212  1.00 21.07           O  
ATOM   1507  CB  LEU A 187       1.828 -23.816  33.207  1.00 23.81           C  
ATOM   1508  CG  LEU A 187       2.184 -23.529  34.668  1.00 25.80           C  
ATOM   1509  CD1 LEU A 187       1.298 -24.357  35.601  1.00 27.43           C  
ATOM   1510  CD2 LEU A 187       3.644 -23.856  34.892  1.00 25.93           C  
ATOM   1511  N   ASN A 188       1.095 -23.288  30.221  1.00 20.39           N  
ATOM   1512  CA  ASN A 188       0.729 -23.807  28.901  1.00 21.82           C  
ATOM   1513  C   ASN A 188       1.445 -23.101  27.759  1.00 22.80           C  
ATOM   1514  O   ASN A 188       1.703 -23.704  26.714  1.00 22.81           O  
ATOM   1515  CB  ASN A 188      -0.780 -23.696  28.677  1.00 20.82           C  
ATOM   1516  CG  ASN A 188      -1.578 -24.567  29.625  1.00 22.82           C  
ATOM   1517  OD1 ASN A 188      -1.033 -25.462  30.275  1.00 20.48           O  
ATOM   1518  ND2 ASN A 188      -2.878 -24.315  29.703  1.00 22.65           N  
ATOM   1519  N   SER A 189       1.756 -21.823  27.964  1.00 23.69           N  
ATOM   1520  CA  SER A 189       2.422 -21.008  26.953  1.00 25.03           C  
ATOM   1521  C   SER A 189       3.927 -21.176  26.931  1.00 25.24           C  
ATOM   1522  O   SER A 189       4.531 -21.153  25.865  1.00 25.70           O  
ATOM   1523  CB  SER A 189       2.128 -19.517  27.177  1.00 24.16           C  
ATOM   1524  OG  SER A 189       0.742 -19.242  27.193  1.00 23.65           O  
ATOM   1525  N   TYR A 190       4.537 -21.353  28.102  1.00 26.05           N  
ATOM   1526  CA  TYR A 190       5.993 -21.452  28.167  1.00 26.23           C  
ATOM   1527  C   TYR A 190       6.651 -22.645  28.852  1.00 28.99           C  
ATOM   1528  O   TYR A 190       7.577 -23.245  28.307  1.00 28.37           O  
ATOM   1529  CB  TYR A 190       6.570 -20.222  28.864  1.00 24.71           C  
ATOM   1530  CG  TYR A 190       6.308 -18.881  28.238  1.00 22.43           C  
ATOM   1531  CD1 TYR A 190       5.349 -18.025  28.769  1.00 20.53           C  
ATOM   1532  CD2 TYR A 190       7.110 -18.411  27.195  1.00 22.12           C  
ATOM   1533  CE1 TYR A 190       5.205 -16.733  28.295  1.00 23.39           C  
ATOM   1534  CE2 TYR A 190       6.972 -17.113  26.708  1.00 21.61           C  
ATOM   1535  CZ  TYR A 190       6.024 -16.280  27.266  1.00 22.94           C  
ATOM   1536  OH  TYR A 190       5.914 -14.982  26.823  1.00 24.84           O  
ATOM   1537  N   ILE A 191       6.197 -22.951  30.065  1.00 30.86           N  
ATOM   1538  CA  ILE A 191       6.803 -24.002  30.881  1.00 32.34           C  
ATOM   1539  C   ILE A 191       6.618 -25.467  30.491  1.00 34.02           C  
ATOM   1540  O   ILE A 191       7.600 -26.169  30.252  1.00 35.17           O  
ATOM   1541  CB  ILE A 191       6.384 -23.831  32.362  1.00 32.47           C  
ATOM   1542  CG1 ILE A 191       6.472 -22.354  32.755  1.00 31.08           C  
ATOM   1543  CG2 ILE A 191       7.298 -24.653  33.266  1.00 31.80           C  
ATOM   1544  CD1 ILE A 191       7.821 -21.731  32.510  1.00 31.92           C  
ATOM   1545  N   HIS A 192       5.375 -25.936  30.445  1.00 33.76           N  
ATOM   1546  CA  HIS A 192       5.105 -27.328  30.097  1.00 33.78           C  
ATOM   1547  C   HIS A 192       5.814 -27.815  28.842  1.00 34.59           C  
ATOM   1548  O   HIS A 192       5.833 -27.128  27.822  1.00 34.30           O  
ATOM   1549  CB  HIS A 192       3.603 -27.560  29.928  1.00 31.63           C  
ATOM   1550  CG  HIS A 192       2.859 -27.653  31.220  1.00 30.78           C  
ATOM   1551  ND1 HIS A 192       3.298 -28.427  32.272  1.00 29.76           N  
ATOM   1552  CD2 HIS A 192       1.687 -27.104  31.617  1.00 30.34           C  
ATOM   1553  CE1 HIS A 192       2.427 -28.352  33.262  1.00 29.09           C  
ATOM   1554  NE2 HIS A 192       1.440 -27.556  32.891  1.00 31.05           N  
ATOM   1555  N   LEU A 193       6.387 -29.014  28.937  1.00 36.24           N  
ATOM   1556  CA  LEU A 193       7.087 -29.646  27.825  1.00 38.01           C  
ATOM   1557  C   LEU A 193       8.150 -28.747  27.196  1.00 39.81           C  
ATOM   1558  O   LEU A 193       8.570 -27.768  27.852  1.00 41.64           O  
ATOM   1559  CB  LEU A 193       6.076 -30.083  26.761  1.00 38.94           C  
ATOM   1560  CG  LEU A 193       4.954 -31.012  27.247  1.00 38.86           C  
ATOM   1561  CD1 LEU A 193       3.929 -31.203  26.137  1.00 39.37           C  
ATOM   1562  CD2 LEU A 193       5.540 -32.349  27.670  1.00 39.33           C  
TER    1563      LEU A 193                                                      
END
MOLECULE T0416_6_115_194_315.pdb
ATOM      1  N   LYS     6       9.770 -16.706  17.344  1.00 47.34          
ATOM      2  CA  LYS     6       9.686 -15.469  18.171  1.00 47.92          
ATOM      3  C   LYS     6       9.964 -15.789  19.633  1.00 48.21          
ATOM      4  O   LYS     6       9.492 -16.801  20.167  1.00 48.06          
ATOM      5  CB  LYS     6       8.296 -14.851  18.062  1.00 48.33          
ATOM      6  CG  LYS     6       7.859 -14.572  16.663  1.00 51.47          
ATOM      7  CD  LYS     6       6.355 -14.397  16.582  1.00 55.16          
ATOM      8  CE  LYS     6       5.919 -14.283  15.119  1.00 58.23          
ATOM      9  NZ  LYS     6       4.444 -14.137  14.929  1.00 59.84          
ATOM     10  N   PRO     7      10.743 -14.930  20.304  1.00 47.62          
ATOM     11  CA  PRO     7      11.079 -15.125  21.721  1.00 47.47          
ATOM     12  C   PRO     7       9.897 -14.902  22.682  1.00 46.63          
ATOM     13  O   PRO     7       9.082 -13.993  22.493  1.00 46.51          
ATOM     14  CB  PRO     7      12.203 -14.114  21.955  1.00 48.11          
ATOM     15  CG  PRO     7      11.877 -13.021  20.986  1.00 48.00          
ATOM     16  CD  PRO     7      11.471 -13.782  19.741  1.00 46.88          
ATOM     17  N   PHE     8       9.814 -15.737  23.715  1.00 44.40          
ATOM     18  CA  PHE     8       8.747 -15.622  24.697  1.00 41.95          
ATOM     19  C   PHE     8       8.958 -14.388  25.566  1.00 40.54          
ATOM     20  O   PHE     8      10.068 -14.136  26.041  1.00 40.58          
ATOM     21  CB  PHE     8       8.694 -16.865  25.591  1.00 41.58          
ATOM     22  CG  PHE     8       7.522 -16.884  26.531  1.00 41.07          
ATOM     23  CD1 PHE     8       6.222 -16.919  26.036  1.00 42.79          
ATOM     24  CD2 PHE     8       7.707 -16.854  27.901  1.00 39.99          
ATOM     25  CE1 PHE     8       5.122 -16.927  26.895  1.00 42.19          
ATOM     26  CE2 PHE     8       6.611 -16.863  28.767  1.00 41.03          
ATOM     27  CZ  PHE     8       5.315 -16.899  28.253  1.00 40.90          
ATOM     28  N   LEU     9       7.881 -13.631  25.767  1.00 38.04          
ATOM     29  CA  LEU     9       7.915 -12.418  26.583  1.00 36.38          
ATOM     30  C   LEU     9       6.629 -12.238  27.393  1.00 35.98          
ATOM     31  O   LEU     9       5.542 -12.412  26.847  1.00 37.94          
ATOM     32  CB  LEU     9       8.085 -11.198  25.687  1.00 33.92          
ATOM     33  CG  LEU     9       8.128  -9.872  26.431  1.00 31.31          
ATOM     34  CD1 LEU     9       9.465  -9.700  27.105  1.00 30.33          
ATOM     35  CD2 LEU     9       7.901  -8.759  25.453  1.00 32.13          
ATOM     36  N   ILE    10       6.742 -11.899  28.680  1.00 34.13          
ATOM     37  CA  ILE    10       5.554 -11.660  29.516  1.00 33.61          
ATOM     38  C   ILE    10       5.402 -10.159  29.661  1.00 32.88          
ATOM     39  O   ILE    10       6.389  -9.457  29.867  1.00 32.89          
ATOM     40  CB  ILE    10       5.671 -12.221  30.978  1.00 34.19          
ATOM     41  CG1 ILE    10       5.795 -13.745  30.994  1.00 34.92          
ATOM     42  CG2 ILE    10       4.410 -11.875  31.762  1.00 32.53          
ATOM     43  CD  ILE    10       4.537 -14.446  30.557  1.00 35.17          
ATOM     44  N   VAL    11       4.179  -9.656  29.545  1.00 32.25          
ATOM     45  CA  VAL    11       3.953  -8.211  29.699  1.00 33.18          
ATOM     46  C   VAL    11       2.799  -7.993  30.705  1.00 33.37          
ATOM     47  O   VAL    11       1.670  -8.456  30.494  1.00 33.93          
ATOM     48  CB  VAL    11       3.605  -7.524  28.325  1.00 31.73          
ATOM     49  CG1 VAL    11       3.619  -6.017  28.467  1.00 30.56          
ATOM     50  CG2 VAL    11       4.587  -7.943  27.263  1.00 29.73          
ATOM     51  N   ILE    12       3.091  -7.290  31.797  1.00 31.84          
ATOM     52  CA  ILE    12       2.106  -7.032  32.842  1.00 30.80          
ATOM     53  C   ILE    12       1.866  -5.536  33.017  1.00 31.11          
ATOM     54  O   ILE    12       2.624  -4.849  33.708  1.00 30.46          
ATOM     55  CB  ILE    12       2.569  -7.632  34.189  1.00 29.53          
ATOM     56  CG1 ILE    12       2.895  -9.114  33.996  1.00 29.86          
ATOM     57  CG2 ILE    12       1.478  -7.487  35.230  1.00 30.33          
ATOM     58  CD  ILE    12       3.522  -9.776  35.203  1.00 26.96          
ATOM     59  N   VAL    13       0.808  -5.035  32.383  1.00 30.72          
ATOM     60  CA  VAL    13       0.466  -3.620  32.457  1.00 29.94          
ATOM     61  C   VAL    13      -0.652  -3.426  33.452  1.00 29.66          
ATOM     62  O   VAL    13      -1.336  -4.374  33.801  1.00 30.84          
ATOM     63  CB  VAL    13      -0.002  -3.077  31.090  1.00 29.53          
ATOM     64  CG1 VAL    13       1.132  -3.140  30.075  1.00 29.05          
ATOM     65  CG2 VAL    13      -1.188  -3.876  30.601  1.00 28.45          
ATOM     66  N   GLY    14      -0.839  -2.199  33.909  1.00 30.29          
ATOM     67  CA  GLY    14      -1.889  -1.938  34.871  1.00 31.58          
ATOM     68  C   GLY    14      -1.642  -0.598  35.525  1.00 32.22          
ATOM     69  O   GLY    14      -0.521  -0.108  35.523  1.00 31.01          
ATOM     70  N   PRO    15      -2.677   0.021  36.103  1.00 33.98          
ATOM     71  CA  PRO    15      -2.483   1.323  36.744  1.00 35.35          
ATOM     72  C   PRO    15      -1.478   1.279  37.893  1.00 36.07          
ATOM     73  O   PRO    15      -1.230   0.218  38.457  1.00 36.01          
ATOM     74  CB  PRO    15      -3.897   1.696  37.187  1.00 34.89          
ATOM     75  CG  PRO    15      -4.545   0.365  37.419  1.00 34.89          
ATOM     76  CD  PRO    15      -4.070  -0.442  36.245  1.00 35.07          
ATOM     77  N   THR    16      -0.891   2.431  38.211  1.00 36.66          
ATOM     78  CA  THR    16       0.089   2.538  39.286  1.00 38.58          
ATOM     79  C   THR    16      -0.373   1.853  40.573  1.00 40.27          
ATOM     80  O   THR    16      -1.523   2.001  40.989  1.00 40.98          
ATOM     81  CB  THR    16       0.385   3.997  39.643  1.00 37.33          
ATOM     82  OG1 THR    16       0.786   4.705  38.474  1.00 36.77          
ATOM     83  CG2 THR    16       1.495   4.061  40.671  1.00 38.23          
ATOM     84  N   ALA    17       0.536   1.118  41.208  1.00 40.72          
ATOM     85  CA  ALA    17       0.219   0.417  42.443  1.00 42.57          
ATOM     86  C   ALA    17      -1.083  -0.378  42.324  1.00 43.15          
ATOM     87  O   ALA    17      -2.011  -0.205  43.123  1.00 43.42          
ATOM     88  CB  ALA    17       0.109   1.412  43.597  1.00 43.65          
ATOM     89  N   SER    18      -1.159  -1.238  41.317  1.00 42.43          
ATOM     90  CA  SER    18      -2.344  -2.051  41.119  1.00 40.61          
ATOM     91  C   SER    18      -1.921  -3.495  41.298  1.00 40.77          
ATOM     92  O   SER    18      -2.693  -4.424  41.054  1.00 42.04          
ATOM     93  CB  SER    18      -2.892  -1.870  39.719  1.00 38.47          
ATOM     94  OG  SER    18      -2.013  -2.466  38.804  1.00 36.84          
ATOM     95  N   GLY    19      -0.681  -3.681  41.730  1.00 40.01          
ATOM     96  CA  GLY    19      -0.170  -5.026  41.920  1.00 40.03          
ATOM     97  C   GLY    19       0.645  -5.548  40.744  1.00 38.18          
ATOM     98  O   GLY    19       1.235  -6.625  40.806  1.00 38.21          
ATOM     99  N   LYS    20       0.684  -4.791  39.660  1.00 36.98          
ATOM    100  CA  LYS    20       1.444  -5.241  38.522  1.00 35.89          
ATOM    101  C   LYS    20       2.908  -5.443  38.936  1.00 36.34          
ATOM    102  O   LYS    20       3.527  -6.452  38.590  1.00 37.13          
ATOM    103  CB  LYS    20       1.330  -4.248  37.362  1.00 33.94          
ATOM    104  CG  LYS    20       1.849  -2.871  37.685  1.00 32.57          
ATOM    105  CD  LYS    20       1.824  -1.935  36.498  1.00 29.33          
ATOM    106  CE  LYS    20       2.436  -0.614  36.924  1.00 31.07          
ATOM    107  NZ  LYS    20       2.250   0.476  35.923  1.00 35.59          
ATOM    108  N   THR    21       3.455  -4.511  39.705  1.00 35.70          
ATOM    109  CA  THR    21       4.840  -4.619  40.147  1.00 35.75          
ATOM    110  C   THR    21       5.079  -5.838  41.024  1.00 35.78          
ATOM    111  O   THR    21       6.054  -6.572  40.832  1.00 35.67          
ATOM    112  CB  THR    21       5.269  -3.372  40.918  1.00 36.24          
ATOM    113  OG1 THR    21       5.065  -2.221  40.090  1.00 38.69          
ATOM    114  CG2 THR    21       6.742  -3.464  41.302  1.00 36.35          
ATOM    115  N   GLU    22       4.197  -6.056  41.989  1.00 35.56          
ATOM    116  CA  GLU    22       4.326  -7.196  42.879  1.00 36.42          
ATOM    117  C   GLU    22       4.155  -8.475  42.073  1.00 35.88          
ATOM    118  O   GLU    22       4.979  -9.381  42.161  1.00 37.29          
ATOM    119  CB  GLU    22       3.271  -7.119  43.984  1.00 39.34          
ATOM    120  CG  GLU    22       3.439  -5.935  44.935  1.00 43.60          
ATOM    121  CD  GLU    22       3.007  -4.586  44.343  1.00 45.57          
ATOM    122  OE1 GLU    22       3.218  -3.557  45.018  1.00 48.08          
ATOM    123  OE2 GLU    22       2.457  -4.544  43.224  1.00 46.06          
ATOM    124  N   LEU    23       3.090  -8.539  41.276  1.00 34.58          
ATOM    125  CA  LEU    23       2.826  -9.704  40.445  1.00 32.10          
ATOM    126  C   LEU    23       4.039 -10.051  39.576  1.00 31.09          
ATOM    127  O   LEU    23       4.403 -11.217  39.458  1.00 27.98          
ATOM    128  CB  LEU    23       1.599  -9.455  39.558  1.00 30.74          
ATOM    129  CG  LEU    23       1.222 -10.580  38.579  1.00 28.65          
ATOM    130  CD1 LEU    23       0.822 -11.814  39.341  1.00 28.78          
ATOM    131  CD2 LEU    23       0.098 -10.121  37.709  1.00 27.36          
ATOM    132  N   SER    24       4.663  -9.040  38.973  1.00 32.29          
ATOM    133  CA  SER    24       5.842  -9.271  38.129  1.00 34.51          
ATOM    134  C   SER    24       6.915 -10.040  38.890  1.00 34.30          
ATOM    135  O   SER    24       7.439 -11.030  38.403  1.00 35.07          
ATOM    136  CB  SER    24       6.445  -7.954  37.634  1.00 35.30          
ATOM    137  OG  SER    24       5.598  -7.333  36.691  1.00 39.93          
ATOM    138  N   ILE    25       7.237  -9.584  40.089  1.00 33.62          
ATOM    139  CA  ILE    25       8.251 -10.244  40.876  1.00 33.95          
ATOM    140  C   ILE    25       7.850 -11.690  41.196  1.00 35.37          
ATOM    141  O   ILE    25       8.677 -12.608  41.097  1.00 35.34          
ATOM    142  CB  ILE    25       8.529  -9.434  42.163  1.00 32.96          
ATOM    143  CG1 ILE    25       9.066  -8.055  41.768  1.00 30.36          
ATOM    144  CG2 ILE    25       9.512 -10.154  43.053  1.00 31.35          
ATOM    145  CD  ILE    25       9.495  -7.203  42.916  1.00 28.44          
ATOM    146  N   GLU    26       6.586 -11.909  41.554  1.00 36.42          
ATOM    147  CA  GLU    26       6.106 -13.262  41.869  1.00 38.00          
ATOM    148  C   GLU    26       6.267 -14.202  40.671  1.00 37.34          
ATOM    149  O   GLU    26       6.623 -15.369  40.836  1.00 37.59          
ATOM    150  CB  GLU    26       4.635 -13.220  42.317  1.00 39.45          
ATOM    151  CG  GLU    26       4.434 -12.560  43.690  1.00 44.45          
ATOM    152  CD  GLU    26       5.131 -13.307  44.839  1.00 47.76          
ATOM    153  OE1 GLU    26       4.635 -14.390  45.253  1.00 48.13          
ATOM    154  OE2 GLU    26       6.188 -12.815  45.322  1.00 48.16          
ATOM    155  N   VAL    27       6.001 -13.683  39.473  1.00 36.34          
ATOM    156  CA  VAL    27       6.141 -14.460  38.248  1.00 34.75          
ATOM    157  C   VAL    27       7.627 -14.683  37.994  1.00 35.06          
ATOM    158  O   VAL    27       8.044 -15.752  37.567  1.00 34.96          
ATOM    159  CB  VAL    27       5.549 -13.714  37.055  1.00 31.86          
ATOM    160  CG1 VAL    27       5.834 -14.462  35.783  1.00 29.36          
ATOM    161  CG2 VAL    27       4.072 -13.543  37.255  1.00 31.53          
ATOM    162  N   ALA    28       8.419 -13.657  38.275  1.00 35.66          
ATOM    163  CA  ALA    28       9.849 -13.720  38.085  1.00 36.34          
ATOM    164  C   ALA    28      10.465 -14.753  39.009  1.00 38.34          
ATOM    165  O   ALA    28      11.452 -15.406  38.660  1.00 39.44          
ATOM    166  CB  ALA    28      10.464 -12.368  38.340  1.00 36.23          
ATOM    167  N   LYS    29       9.889 -14.910  40.194  1.00 39.77          
ATOM    168  CA  LYS    29      10.408 -15.880  41.146  1.00 40.39          
ATOM    169  C   LYS    29       9.949 -17.299  40.859  1.00 40.52          
ATOM    170  O   LYS    29      10.622 -18.239  41.252  1.00 41.59          
ATOM    171  CB  LYS    29      10.006 -15.511  42.574  1.00 40.53          
ATOM    172  CG  LYS    29      10.744 -14.316  43.150  1.00 41.23          
ATOM    173  CD  LYS    29      10.663 -14.309  44.681  1.00 44.42          
ATOM    174  CE  LYS    29       9.211 -14.279  45.195  1.00 44.59          
ATOM    175  NZ  LYS    29       9.113 -14.333  46.690  1.00 43.59          
ATOM    176  N   LYS    30       8.816 -17.465  40.186  1.00 40.21          
ATOM    177  CA  LYS    30       8.337 -18.806  39.901  1.00 41.59          
ATOM    178  C   LYS    30       8.884 -19.327  38.571  1.00 43.51          
ATOM    179  O   LYS    30       8.861 -20.529  38.327  1.00 43.62          
ATOM    180  CB  LYS    30       6.801 -18.834  39.902  1.00 42.72          
ATOM    181  CG  LYS    30       6.171 -20.223  39.924  1.00 43.38          
ATOM    182  CD  LYS    30       4.653 -20.122  39.904  1.00 45.84          
ATOM    183  CE  LYS    30       3.983 -21.471  40.139  1.00 47.92          
ATOM    184  NZ  LYS    30       2.499 -21.323  40.293  1.00 50.92          
ATOM    185  N   PHE    31       9.388 -18.430  37.721  1.00 44.17          
ATOM    186  CA  PHE    31       9.940 -18.814  36.419  1.00 44.51          
ATOM    187  C   PHE    31      11.289 -18.170  36.195  1.00 45.33          
ATOM    188  O   PHE    31      11.634 -17.818  35.068  1.00 45.02          
ATOM    189  CB  PHE    31       8.991 -18.398  35.307  1.00 44.39          
ATOM    190  CG  PHE    31       7.643 -19.013  35.427  1.00 45.82          
ATOM    191  CD1 PHE    31       7.406 -20.293  34.943  1.00 47.34          
ATOM    192  CD2 PHE    31       6.620 -18.344  36.087  1.00 46.46          
ATOM    193  CE1 PHE    31       6.160 -20.904  35.118  1.00 48.67          
ATOM    194  CE2 PHE    31       5.371 -18.940  36.271  1.00 47.96          
ATOM    195  CZ  PHE    31       5.137 -20.224  35.787  1.00 48.48          
ATOM    196  N   ASN    32      12.050 -18.044  37.282  1.00 47.84          
ATOM    197  CA  ASN    32      13.382 -17.419  37.295  1.00 49.84          
ATOM    198  C   ASN    32      13.603 -16.505  36.095  1.00 49.50          
ATOM    199  O   ASN    32      14.394 -16.794  35.191  1.00 50.98          
ATOM    200  CB  ASN    32      14.500 -18.479  37.383  1.00 51.79          
ATOM    201  CG  ASN    32      14.698 -19.234  36.078  1.00 54.42          
ATOM    202  OD1 ASN    32      13.726 -19.668  35.450  1.00 56.40          
ATOM    203  ND2 ASN    32      15.954 -19.411  35.670  1.00 55.03          
ATOM    204  N   GLY    33      12.871 -15.398  36.096  1.00 47.07          
ATOM    205  CA  GLY    33      12.994 -14.433  35.027  1.00 44.42          
ATOM    206  C   GLY    33      13.567 -13.138  35.566  1.00 42.58          
ATOM    207  O   GLY    33      13.970 -13.059  36.725  1.00 41.73          
ATOM    208  N   GLU    34      13.620 -12.124  34.711  1.00 41.54          
ATOM    209  CA  GLU    34      14.122 -10.821  35.099  1.00 39.53          
ATOM    210  C   GLU    34      13.166  -9.801  34.512  1.00 38.04          
ATOM    211  O   GLU    34      12.592 -10.005  33.440  1.00 36.36          
ATOM    212  CB  GLU    34      15.537 -10.613  34.582  1.00 39.38          
ATOM    213  CG  GLU    34      16.453 -11.766  34.939  1.00 40.36          
ATOM    214  CD  GLU    34      17.877 -11.540  34.490  1.00 41.95          
ATOM    215  OE1 GLU    34      18.066 -10.907  33.422  1.00 43.40          
ATOM    216  OE2 GLU    34      18.814 -12.009  35.185  1.00 40.07          
ATOM    217  N   ILE    35      13.008  -8.695  35.222  1.00 37.64          
ATOM    218  CA  ILE    35      12.066  -7.665  34.828  1.00 37.78          
ATOM    219  C   ILE    35      12.679  -6.440  34.183  1.00 37.21          
ATOM    220  O   ILE    35      13.723  -5.963  34.602  1.00 37.93          
ATOM    221  CB  ILE    35      11.252  -7.203  36.064  1.00 37.03          
ATOM    222  CG1 ILE    35      10.621  -8.415  36.738  1.00 36.19          
ATOM    223  CG2 ILE    35      10.186  -6.211  35.656  1.00 37.14          
ATOM    224  CD  ILE    35       9.858  -8.090  37.952  1.00 35.95          
ATOM    225  N   ILE    36      12.003  -5.926  33.166  1.00 37.04          
ATOM    226  CA  ILE    36      12.438  -4.716  32.496  1.00 36.12          
ATOM    227  C   ILE    36      11.354  -3.669  32.787  1.00 37.69          
ATOM    228  O   ILE    36      10.207  -3.833  32.380  1.00 38.12          
ATOM    229  CB  ILE    36      12.548  -4.928  30.981  1.00 33.73          
ATOM    230  CG1 ILE    36      13.667  -5.921  30.678  1.00 31.77          
ATOM    231  CG2 ILE    36      12.795  -3.610  30.292  1.00 31.97          
ATOM    232  CD  ILE    36      13.730  -6.342  29.233  1.00 26.96          
ATOM    233  N   SER    37      11.709  -2.610  33.506  1.00 37.83          
ATOM    234  CA  SER    37      10.744  -1.571  33.829  1.00 37.74          
ATOM    235  C   SER    37      10.202  -0.918  32.553  1.00 37.95          
ATOM    236  O   SER    37      10.969  -0.487  31.692  1.00 37.35          
ATOM    237  CB  SER    37      11.403  -0.535  34.740  1.00 36.72          
ATOM    238  OG  SER    37      10.688   0.680  34.738  1.00 36.77          
ATOM    239  N   GLY    38       8.874  -0.871  32.426  1.00 38.61          
ATOM    240  CA  GLY    38       8.253  -0.268  31.252  1.00 39.20          
ATOM    241  C   GLY    38       7.872   1.183  31.485  1.00 41.13          
ATOM    242  O   GLY    38       7.455   1.899  30.565  1.00 39.58          
ATOM    243  N   ASP    39       8.020   1.615  32.734  1.00 42.10          
ATOM    244  CA  ASP    39       7.694   2.977  33.129  1.00 44.59          
ATOM    245  C   ASP    39       8.674   3.991  32.530  1.00 45.44          
ATOM    246  O   ASP    39       9.884   3.849  32.665  1.00 46.29          
ATOM    247  CB  ASP    39       7.719   3.090  34.648  1.00 46.64          
ATOM    248  CG  ASP    39       7.028   4.342  35.149  1.00 49.62          
ATOM    249  OD1 ASP    39       7.453   5.452  34.775  1.00 51.11          
ATOM    250  OD2 ASP    39       6.046   4.214  35.915  1.00 52.78          
ATOM    251  N   SER    40       8.149   5.028  31.890  1.00 45.73          
ATOM    252  CA  SER    40       9.007   6.038  31.286  1.00 46.96          
ATOM    253  C   SER    40       9.523   7.073  32.276  1.00 47.74          
ATOM    254  O   SER    40      10.194   8.033  31.886  1.00 47.33          
ATOM    255  CB  SER    40       8.276   6.763  30.142  1.00 46.76          
ATOM    256  OG  SER    40       7.151   7.504  30.591  1.00 44.02          
ATOM    257  N   MET    41       9.212   6.894  33.554  1.00 49.05          
ATOM    258  CA  MET    41       9.645   7.852  34.575  1.00 50.21          
ATOM    259  C   MET    41      10.623   7.277  35.575  1.00 48.79          
ATOM    260  O   MET    41      11.443   7.998  36.156  1.00 48.16          
ATOM    261  CB  MET    41       8.430   8.401  35.322  1.00 54.92          
ATOM    262  CG  MET    41       7.630   9.422  34.534  1.00 60.15          
ATOM    263  SD  MET    41       8.726  10.939  33.973  1.00 69.60          
ATOM    264  CE  MET    41       9.133  11.711  35.709  1.00 65.89          
ATOM    265  N   GLN    42      10.521   5.967  35.778  1.00 47.21          
ATOM    266  CA  GLN    42      11.387   5.258  36.710  1.00 44.79          
ATOM    267  C   GLN    42      12.805   5.173  36.162  1.00 43.38          
ATOM    268  O   GLN    42      13.702   4.659  36.822  1.00 42.91          
ATOM    269  CB  GLN    42      10.808   3.867  36.988  1.00 44.81          
ATOM    270  CG  GLN    42       9.722   3.895  38.074  1.00 45.40          
ATOM    271  CD  GLN    42       9.045   2.552  38.305  1.00 46.04          
ATOM    272  OE1 GLN    42       9.697   1.498  38.352  1.00 47.48          
ATOM    273  NE2 GLN    42       7.731   2.587  38.483  1.00 45.63          
ATOM    274  N   VAL    43      13.002   5.709  34.960  1.00 41.63          
ATOM    275  CA  VAL    43      14.308   5.709  34.338  1.00 39.69          
ATOM    276  C   VAL    43      15.179   6.815  34.916  1.00 39.24          
ATOM    277  O   VAL    43      16.398   6.742  34.848  1.00 39.12          
ATOM    278  CB  VAL    43      14.194   5.913  32.814  1.00 40.00          
ATOM    279  CG1 VAL    43      13.727   4.629  32.143  1.00 39.83          
ATOM    280  CG2 VAL    43      13.216   7.035  32.519  1.00 37.24          
ATOM    281  N   TYR    44      14.547   7.831  35.496  1.00 39.65          
ATOM    282  CA  TYR    44      15.278   8.961  36.069  1.00 40.32          
ATOM    283  C   TYR    44      15.685   8.755  37.538  1.00 42.44          
ATOM    284  O   TYR    44      14.876   8.359  38.372  1.00 42.07          
ATOM    285  CB  TYR    44      14.450  10.236  35.952  1.00 39.33          
ATOM    286  CG  TYR    44      14.102  10.623  34.536  1.00 40.85          
ATOM    287  CD1 TYR    44      15.075  11.124  33.664  1.00 40.75          
ATOM    288  CD2 TYR    44      12.798  10.482  34.059  1.00 40.46          
ATOM    289  CE1 TYR    44      14.750  11.471  32.350  1.00 41.84          
ATOM    290  CE2 TYR    44      12.467  10.829  32.753  1.00 41.49          
ATOM    291  CZ  TYR    44      13.437  11.319  31.901  1.00 42.05          
ATOM    292  OH  TYR    44      13.093  11.647  30.599  1.00 42.46          
ATOM    293  N   GLN    45      16.945   9.042  37.847  1.00 43.92          
ATOM    294  CA  GLN    45      17.452   8.884  39.196  1.00 46.34          
ATOM    295  C   GLN    45      17.102  10.118  40.029  1.00 47.78          
ATOM    296  O   GLN    45      17.187  11.249  39.548  1.00 47.56          
ATOM    297  CB  GLN    45      18.965   8.648  39.145  1.00 47.12          
ATOM    298  CG  GLN    45      19.690   9.695  38.307  1.00 50.07          
ATOM    299  CD  GLN    45      20.942   9.167  37.622  1.00 50.58          
ATOM    300  OE1 GLN    45      20.898   8.142  36.937  1.00 50.72          
ATOM    301  NE2 GLN    45      22.057   9.879  37.783  1.00 49.70          
ATOM    302  N   GLY    46      16.685   9.896  41.274  1.00 48.21          
ATOM    303  CA  GLY    46      16.318  11.011  42.135  1.00 49.37          
ATOM    304  C   GLY    46      14.813  11.171  42.212  1.00 50.77          
ATOM    305  O   GLY    46      14.273  11.756  43.159  1.00 49.20          
ATOM    306  N   MET    47      14.137  10.648  41.193  1.00 52.76          
ATOM    307  CA  MET    47      12.685  10.704  41.117  1.00 54.61          
ATOM    308  C   MET    47      12.150   9.309  41.425  1.00 53.36          
ATOM    309  O   MET    47      11.777   8.565  40.523  1.00 53.21          
ATOM    310  CB  MET    47      12.261  11.145  39.723  1.00 56.82          
ATOM    311  CG  MET    47      13.015  12.367  39.261  1.00 61.64          
ATOM    312  SD  MET    47      12.390  13.007  37.567  1.00 70.25          
ATOM    313  CE  MET    47      11.239  14.436  38.153  1.00 69.01          
ATOM    314  N   ASP    48      12.109   8.969  42.713  1.00 52.63          
ATOM    315  CA  ASP    48      11.651   7.657  43.149  1.00 51.41          
ATOM    316  C   ASP    48      10.236   7.640  43.742  1.00 49.19          
ATOM    317  O   ASP    48       9.437   6.753  43.438  1.00 48.61          
ATOM    318  CB  ASP    48      12.644   7.074  44.166  1.00 52.25          
ATOM    319  CG  ASP    48      14.094   7.486  43.887  1.00 52.83          
ATOM    320  OD1 ASP    48      14.559   7.391  42.724  1.00 52.86          
ATOM    321  OD2 ASP    48      14.782   7.901  44.845  1.00 52.66          
ATOM    322  N   ILE    49       9.924   8.620  44.578  1.00 46.94          
ATOM    323  CA  ILE    49       8.617   8.680  45.210  1.00 45.38          
ATOM    324  C   ILE    49       7.471   9.008  44.261  1.00 43.66          
ATOM    325  O   ILE    49       6.463   8.309  44.243  1.00 43.49          
ATOM    326  CB  ILE    49       8.618   9.712  46.353  1.00 45.88          
ATOM    327  CG1 ILE    49       9.599   9.276  47.434  1.00 44.79          
ATOM    328  CG2 ILE    49       7.206   9.873  46.912  1.00 46.48          
ATOM    329  CD  ILE    49       9.745  10.265  48.557  1.00 47.30          
ATOM    330  N   GLY    50       7.617  10.070  43.479  1.00 42.05          
ATOM    331  CA  GLY    50       6.546  10.454  42.569  1.00 41.84          
ATOM    332  C   GLY    50       6.304   9.495  41.416  1.00 39.86          
ATOM    333  O   GLY    50       5.323   9.614  40.685  1.00 38.30          
ATOM    334  N   THR    51       7.185   8.522  41.268  1.00 38.59          
ATOM    335  CA  THR    51       7.065   7.593  40.177  1.00 39.16          
ATOM    336  C   THR    51       6.732   6.186  40.632  1.00 39.81          
ATOM    337  O   THR    51       6.650   5.269  39.811  1.00 40.79          
ATOM    338  CB  THR    51       8.364   7.555  39.405  1.00 39.85          
ATOM    339  OG1 THR    51       9.419   7.139  40.288  1.00 39.12          
ATOM    340  CG2 THR    51       8.684   8.950  38.852  1.00 39.88          
ATOM    341  N   ALA    52       6.545   6.017  41.939  1.00 39.14          
ATOM    342  CA  ALA    52       6.226   4.717  42.538  1.00 37.57          
ATOM    343  C   ALA    52       7.338   3.724  42.226  1.00 38.14          
ATOM    344  O   ALA    52       7.094   2.532  42.036  1.00 37.54          
ATOM    345  CB  ALA    52       4.886   4.200  42.022  1.00 35.81          
ATOM    346  N   LYS    53       8.565   4.235  42.181  1.00 40.06          
ATOM    347  CA  LYS    53       9.741   3.420  41.888  1.00 42.16          
ATOM    348  C   LYS    53       9.989   2.345  42.939  1.00 42.20          
ATOM    349  O   LYS    53      10.161   2.651  44.121  1.00 42.30          
ATOM    350  CB  LYS    53      10.978   4.311  41.782  1.00 42.37          
ATOM    351  CG  LYS    53      12.272   3.549  41.536  1.00 42.48          
ATOM    352  CD  LYS    53      13.408   4.512  41.341  1.00 41.69          
ATOM    353  CE  LYS    53      13.132   5.409  40.152  1.00 42.68          
ATOM    354  NZ  LYS    53      14.081   6.557  40.102  1.00 44.19          
ATOM    355  N   VAL    54      10.027   1.089  42.498  1.00 42.43          
ATOM    356  CA  VAL    54      10.262  -0.040  43.395  1.00 42.54          
ATOM    357  C   VAL    54      11.678  -0.002  43.960  1.00 42.74          
ATOM    358  O   VAL    54      12.640   0.289  43.238  1.00 42.21          
ATOM    359  CB  VAL    54      10.024  -1.382  42.660  1.00 43.26          
ATOM    360  CG1 VAL    54      10.765  -1.401  41.325  1.00 43.42          
ATOM    361  CG2 VAL    54      10.471  -2.525  43.538  1.00 44.75          
ATOM    362  N   THR    55      11.810  -0.291  45.250  1.00 41.88          
ATOM    363  CA  THR    55      13.120  -0.254  45.891  1.00 42.17          
ATOM    364  C   THR    55      13.915  -1.537  45.748  1.00 40.91          
ATOM    365  O   THR    55      13.357  -2.611  45.534  1.00 37.85          
ATOM    366  CB  THR    55      12.999   0.093  47.397  1.00 42.92          
ATOM    367  OG1 THR    55      12.447  -1.019  48.126  1.00 45.00          
ATOM    368  CG2 THR    55      12.105   1.306  47.580  1.00 44.24          
ATOM    369  N   THR    56      15.233  -1.406  45.856  1.00 42.43          
ATOM    370  CA  THR    56      16.114  -2.557  45.731  1.00 44.85          
ATOM    371  C   THR    56      15.630  -3.688  46.640  1.00 45.98          
ATOM    372  O   THR    56      15.676  -4.852  46.262  1.00 46.23          
ATOM    373  CB  THR    56      17.581  -2.218  46.109  1.00 44.96          
ATOM    374  OG1 THR    56      17.663  -1.947  47.513  1.00 47.28          
ATOM    375  CG2 THR    56      18.067  -0.995  45.350  1.00 46.18          
ATOM    376  N   GLU    57      15.143  -3.343  47.828  1.00 47.39          
ATOM    377  CA  GLU    57      14.674  -4.344  48.773  1.00 47.62          
ATOM    378  C   GLU    57      13.441  -5.053  48.306  1.00 47.71          
ATOM    379  O   GLU    57      13.327  -6.260  48.438  1.00 48.16          
ATOM    380  CB  GLU    57      14.361  -3.712  50.117  1.00 49.17          
ATOM    381  CG  GLU    57      13.931  -4.714  51.180  1.00 50.98          
ATOM    382  CD  GLU    57      13.395  -4.031  52.437  1.00 52.75          
ATOM    383  OE1 GLU    57      13.203  -4.714  53.468  1.00 53.26          
ATOM    384  OE2 GLU    57      13.154  -2.807  52.382  1.00 54.01          
ATOM    385  N   GLU    58      12.502  -4.291  47.779  1.00 48.34          
ATOM    386  CA  GLU    58      11.257  -4.857  47.314  1.00 50.36          
ATOM    387  C   GLU    58      11.435  -5.758  46.103  1.00 51.67          
ATOM    388  O   GLU    58      10.605  -6.627  45.843  1.00 51.05          
ATOM    389  CB  GLU    58      10.276  -3.730  47.011  1.00 51.70          
ATOM    390  CG  GLU    58      10.044  -2.804  48.205  1.00 54.05          
ATOM    391  CD  GLU    58       9.059  -1.690  47.897  1.00 54.95          
ATOM    392  OE1 GLU    58       9.289  -0.952  46.911  1.00 53.56          
ATOM    393  OE2 GLU    58       8.062  -1.554  48.646  1.00 56.23          
ATOM    394  N   MET    59      12.522  -5.561  45.366  1.00 53.00          
ATOM    395  CA  MET    59      12.804  -6.374  44.179  1.00 54.52          
ATOM    396  C   MET    59      13.089  -7.828  44.530  1.00 54.25          
ATOM    397  O   MET    59      13.251  -8.662  43.641  1.00 54.07          
ATOM    398  CB  MET    59      14.009  -5.814  43.428  1.00 57.77          
ATOM    399  CG  MET    59      13.794  -4.457  42.799  1.00 62.25          
ATOM    400  SD  MET    59      15.363  -3.879  41.807  1.00 70.44          
ATOM    401  CE  MET    59      15.371  -1.998  42.290  1.00 67.49          
ATOM    402  N   GLU    60      13.163  -8.110  45.831  1.00 53.56          
ATOM    403  CA  GLU    60      13.433  -9.453  46.352  1.00 52.64          
ATOM    404  C   GLU    60      14.481 -10.251  45.585  1.00 50.43          
ATOM    405  O   GLU    60      14.318 -11.450  45.392  1.00 51.35          
ATOM    406  CB  GLU    60      12.135 -10.261  46.420  1.00 53.57          
ATOM    407  CG  GLU    60      11.354 -10.074  47.708  1.00 56.49          
ATOM    408  CD  GLU    60       9.894 -10.467  47.562  1.00 59.54          
ATOM    409  OE1 GLU    60       9.610 -11.476  46.869  1.00 60.10          
ATOM    410  OE2 GLU    60       9.029  -9.774  48.151  1.00 60.23          
ATOM    411  N   GLY    61      15.554  -9.601  45.154  1.00 48.05          
ATOM    412  CA  GLY    61      16.582 -10.330  44.443  1.00 46.22          
ATOM    413  C   GLY    61      16.423 -10.307  42.939  1.00 45.02          
ATOM    414  O   GLY    61      17.412 -10.296  42.208  1.00 46.21          
ATOM    415  N   ILE    62      15.189 -10.308  42.455  1.00 43.60          
ATOM    416  CA  ILE    62      14.969 -10.276  41.019  1.00 41.23          
ATOM    417  C   ILE    62      15.599  -9.022  40.419  1.00 40.65          
ATOM    418  O   ILE    62      15.292  -7.905  40.821  1.00 41.62          
ATOM    419  CB  ILE    62      13.479 -10.248  40.689  1.00 40.73          
ATOM    420  CG1 ILE    62      12.776 -11.464  41.306  1.00 38.20          
ATOM    421  CG2 ILE    62      13.306 -10.157  39.179  1.00 41.74          
ATOM    422  CD  ILE    62      13.258 -12.789  40.784  1.00 36.15          
ATOM    423  N   PRO    63      16.491  -9.190  39.442  1.00 40.13          
ATOM    424  CA  PRO    63      17.144  -8.041  38.805  1.00 40.32          
ATOM    425  C   PRO    63      16.221  -7.197  37.917  1.00 39.75          
ATOM    426  O   PRO    63      15.509  -7.736  37.073  1.00 39.18          
ATOM    427  CB  PRO    63      18.277  -8.694  38.008  1.00 40.21          
ATOM    428  CG  PRO    63      17.715 -10.036  37.661  1.00 39.66          
ATOM    429  CD  PRO    63      17.070 -10.455  38.959  1.00 40.22          
ATOM    430  N   HSD    64      16.235  -5.877  38.115  1.00 39.80          
ATOM    431  CA  HSD    64      15.404  -4.971  37.322  1.00 40.76          
ATOM    432  C   HSD    64      16.240  -4.041  36.409  1.00 42.95          
ATOM    433  O   HSD    64      17.318  -3.576  36.786  1.00 41.97          
ATOM    434  CB  HSD    64      14.493  -4.123  38.232  1.00 37.92          
ATOM    435  CG  HSD    64      13.430  -4.905  38.944  1.00 36.17          
ATOM    436  ND1 HSD    64      12.239  -4.340  39.346  1.00 36.89          
ATOM    437  CD2 HSD    64      13.383  -6.196  39.354  1.00 35.64          
ATOM    438  CE1 HSD    64      11.505  -5.244  39.969  1.00 35.10          
ATOM    439  NE2 HSD    64      12.177  -6.380  39.986  1.00 33.58          
ATOM    440  N   TYR    65      15.734  -3.786  35.201  1.00 44.46          
ATOM    441  CA  TYR    65      16.416  -2.924  34.246  1.00 46.92          
ATOM    442  C   TYR    65      15.558  -1.722  33.913  1.00 48.79          
ATOM    443  O   TYR    65      14.356  -1.716  34.197  1.00 48.51          
ATOM    444  CB  TYR    65      16.734  -3.679  32.956  1.00 46.24          
ATOM    445  CG  TYR    65      17.495  -4.956  33.189  1.00 46.04          
ATOM    446  CD1 TYR    65      16.839  -6.181  33.203  1.00 45.12          
ATOM    447  CD2 TYR    65      18.876  -4.940  33.421  1.00 46.83          
ATOM    448  CE1 TYR    65      17.538  -7.365  33.439  1.00 45.27          
ATOM    449  CE2 TYR    65      19.587  -6.118  33.664  1.00 44.91          
ATOM    450  CZ  TYR    65      18.915  -7.324  33.666  1.00 44.46          
ATOM    451  OH  TYR    65      19.618  -8.485  33.861  1.00 42.99          
ATOM    452  N   MET    66      16.180  -0.709  33.310  1.00 50.14          
ATOM    453  CA  MET    66      15.474   0.511  32.938  1.00 52.49          
ATOM    454  C   MET    66      15.065   1.366  34.144  1.00 51.53          
ATOM    455  O   MET    66      14.097   2.124  34.068  1.00 50.60          
ATOM    456  CB  MET    66      14.225   0.152  32.137  1.00 57.56          
ATOM    457  CG  MET    66      14.507  -0.541  30.808  1.00 65.45          
ATOM    458  SD  MET    66      15.334   0.620  29.477  1.00 71.33          
ATOM    459  CE  MET    66      13.820   1.809  29.184  1.00 69.78          
ATOM    460  N   ILE    67      15.790   1.237  35.256  1.00 50.85          
ATOM    461  CA  ILE    67      15.494   2.005  36.472  1.00 49.39          
ATOM    462  C   ILE    67      16.742   2.762  36.944  1.00 48.87          
ATOM    463  O   ILE    67      17.774   2.150  37.219  1.00 49.58          
ATOM    464  CB  ILE    67      14.973   1.076  37.606  1.00 48.43          
ATOM    465  CG1 ILE    67      13.742   0.313  37.121  1.00 47.01          
ATOM    466  CG2 ILE    67      14.617   1.897  38.840  1.00 47.68          
ATOM    467  CD  ILE    67      13.258  -0.716  38.065  1.00 46.08          
ATOM    468  N   ASP    68      16.639   4.090  37.028  1.00 47.81          
ATOM    469  CA  ASP    68      17.760   4.942  37.434  1.00 47.06          
ATOM    470  C   ASP    68      18.911   4.812  36.444  1.00 46.44          
ATOM    471  O   ASP    68      20.064   4.604  36.838  1.00 46.29          
ATOM    472  CB  ASP    68      18.277   4.568  38.826  1.00 48.04          
ATOM    473  CG  ASP    68      17.305   4.924  39.929  1.00 49.01          
ATOM    474  OD1 ASP    68      16.806   6.072  39.939  1.00 51.42          
ATOM    475  OD2 ASP    68      17.052   4.068  40.799  1.00 48.86          
ATOM    476  N   ILE    69      18.599   4.922  35.158  1.00 44.44          
ATOM    477  CA  ILE    69      19.616   4.812  34.129  1.00 42.98          
ATOM    478  C   ILE    69      19.953   6.161  33.496  1.00 42.60          
ATOM    479  O   ILE    69      20.851   6.252  32.664  1.00 42.00          
ATOM    480  CB  ILE    69      19.170   3.854  33.018  1.00 43.70          
ATOM    481  CG1 ILE    69      17.845   4.328  32.414  1.00 43.50          
ATOM    482  CG2 ILE    69      19.052   2.449  33.565  1.00 44.67          
ATOM    483  CD  ILE    69      17.404   3.536  31.203  1.00 42.90          
ATOM    484  N   LEU    70      19.245   7.212  33.902  1.00 42.59          
ATOM    485  CA  LEU    70      19.486   8.549  33.359  1.00 40.82          
ATOM    486  C   LEU    70      19.250   9.633  34.407  1.00 41.05          
ATOM    487  O   LEU    70      18.577   9.405  35.398  1.00 41.88          
ATOM    488  CB  LEU    70      18.548   8.791  32.171  1.00 39.27          
ATOM    489  CG  LEU    70      18.589   7.800  31.020  1.00 36.21          
ATOM    490  CD1 LEU    70      17.340   7.949  30.200  1.00 36.04          
ATOM    491  CD2 LEU    70      19.824   8.038  30.194  1.00 34.44          
ATOM    492  N   PRO    71      19.835  10.825  34.214  1.00 43.24          
ATOM    493  CA  PRO    71      19.650  11.934  35.154  1.00 41.06          
ATOM    494  C   PRO    71      18.362  12.638  34.725  1.00 42.77          
ATOM    495  O   PRO    71      17.904  12.457  33.605  1.00 42.17          
ATOM    496  CB  PRO    71      20.879  12.792  34.919  1.00 42.02          
ATOM    497  CG  PRO    71      21.065  12.653  33.448  1.00 41.82          
ATOM    498  CD  PRO    71      20.887  11.154  33.242  1.00 42.37          
ATOM    499  N   PRO    72      17.770  13.460  35.603  1.00 46.11          
ATOM    500  CA  PRO    72      16.522  14.173  35.299  1.00 45.97          
ATOM    501  C   PRO    72      16.497  14.962  33.990  1.00 48.27          
ATOM    502  O   PRO    72      15.500  14.933  33.254  1.00 49.06          
ATOM    503  CB  PRO    72      16.327  15.057  36.521  1.00 45.64          
ATOM    504  CG  PRO    72      16.892  14.201  37.619  1.00 45.86          
ATOM    505  CD  PRO    72      18.180  13.706  36.995  1.00 45.76          
ATOM    506  N   ASP    73      17.593  15.659  33.693  1.00 50.27          
ATOM    507  CA  ASP    73      17.710  16.484  32.476  1.00 50.11          
ATOM    508  C   ASP    73      17.880  15.666  31.197  1.00 50.04          
ATOM    509  O   ASP    73      17.918  16.220  30.087  1.00 51.02          
ATOM    510  CB  ASP    73      18.889  17.460  32.625  1.00 52.01          
ATOM    511  CG  ASP    73      20.224  16.746  32.837  1.00 54.57          
ATOM    512  OD1 ASP    73      20.667  16.017  31.911  1.00 55.67          
ATOM    513  OD2 ASP    73      20.834  16.922  33.921  1.00 53.87          
ATOM    514  N   ALA    74      17.997  14.350  31.356  1.00 48.21          
ATOM    515  CA  ALA    74      18.159  13.464  30.210  1.00 45.93          
ATOM    516  C   ALA    74      16.842  13.337  29.472  1.00 44.07          
ATOM    517  O   ALA    74      15.780  13.627  30.015  1.00 41.10          
ATOM    518  CB  ALA    74      18.645  12.094  30.668  1.00 46.53          
ATOM    519  N   SER    75      16.921  12.893  28.229  1.00 44.15          
ATOM    520  CA  SER    75      15.727  12.747  27.425  1.00 44.33          
ATOM    521  C   SER    75      15.354  11.285  27.232  1.00 42.90          
ATOM    522  O   SER    75      16.217  10.409  27.187  1.00 42.46          
ATOM    523  CB  SER    75      15.932  13.425  26.073  1.00 45.22          
ATOM    524  OG  SER    75      14.852  13.131  25.206  1.00 48.08          
ATOM    525  N   PHE    76      14.058  11.028  27.128  1.00 42.25          
ATOM    526  CA  PHE    76      13.589   9.677  26.939  1.00 42.63          
ATOM    527  C   PHE    76      12.435   9.680  25.950  1.00 44.28          
ATOM    528  O   PHE    76      11.843  10.731  25.681  1.00 44.93          
ATOM    529  CB  PHE    76      13.158   9.080  28.272  1.00 41.10          
ATOM    530  CG  PHE    76      13.230   7.592  28.304  1.00 40.73          
ATOM    531  CD1 PHE    76      14.438   6.943  28.082  1.00 40.57          
ATOM    532  CD2 PHE    76      12.091   6.830  28.513  1.00 40.81          
ATOM    533  CE1 PHE    76      14.515   5.548  28.069  1.00 40.33          
ATOM    534  CE2 PHE    76      12.157   5.431  28.503  1.00 40.80          
ATOM    535  CZ  PHE    76      13.375   4.793  28.276  1.00 39.45          
ATOM    536  N   SER    77      12.112   8.506  25.413  1.00 44.42          
ATOM    537  CA  SER    77      11.050   8.409  24.423  1.00 44.38          
ATOM    538  C   SER    77      10.626   6.972  24.168  1.00 44.19          
ATOM    539  O   SER    77      11.321   6.029  24.532  1.00 43.90          
ATOM    540  CB  SER    77      11.537   8.990  23.107  1.00 45.47          
ATOM    541  OG  SER    77      12.572   8.162  22.578  1.00 47.33          
ATOM    542  N   ALA    78       9.481   6.813  23.521  1.00 42.68          
ATOM    543  CA  ALA    78       8.996   5.488  23.212  1.00 42.21          
ATOM    544  C   ALA    78      10.066   4.637  22.487  1.00 43.10          
ATOM    545  O   ALA    78      10.303   3.504  22.882  1.00 42.31          
ATOM    546  CB  ALA    78       7.714   5.577  22.377  1.00 41.89          
ATOM    547  N   TYR    79      10.724   5.159  21.448  1.00 44.68          
ATOM    548  CA  TYR    79      11.728   4.350  20.756  1.00 46.27          
ATOM    549  C   TYR    79      12.962   4.134  21.609  1.00 44.55          
ATOM    550  O   TYR    79      13.531   3.041  21.616  1.00 43.90          
ATOM    551  CB  TYR    79      12.148   4.962  19.403  1.00 52.71          
ATOM    552  CG  TYR    79      13.289   4.209  18.700  1.00 58.76          
ATOM    553  CD1 TYR    79      14.585   4.755  18.646  1.00 61.33          
ATOM    554  CD2 TYR    79      13.085   2.935  18.131  1.00 60.40          
ATOM    555  CE1 TYR    79      15.655   4.053  18.050  1.00 63.02          
ATOM    556  CE2 TYR    79      14.152   2.218  17.531  1.00 62.10          
ATOM    557  CZ  TYR    79      15.431   2.784  17.497  1.00 63.41          
ATOM    558  OH  TYR    79      16.489   2.099  16.917  1.00 62.92          
ATOM    559  N   GLU    80      13.384   5.165  22.327  1.00 42.75          
ATOM    560  CA  GLU    80      14.558   5.030  23.179  1.00 41.93          
ATOM    561  C   GLU    80      14.369   3.772  24.037  1.00 40.72          
ATOM    562  O   GLU    80      15.285   2.960  24.174  1.00 41.10          
ATOM    563  CB  GLU    80      14.726   6.288  24.053  1.00 41.99          
ATOM    564  CG  GLU    80      15.937   6.271  24.984  1.00 43.40          
ATOM    565  CD  GLU    80      17.244   5.907  24.289  1.00 44.68          
ATOM    566  OE1 GLU    80      18.281   5.855  24.990  1.00 44.88          
ATOM    567  OE2 GLU    80      17.247   5.676  23.057  1.00 44.63          
ATOM    568  N   PHE    81      13.158   3.609  24.570  1.00 38.87          
ATOM    569  CA  PHE    81      12.781   2.465  25.407  1.00 36.19          
ATOM    570  C   PHE    81      12.849   1.170  24.596  1.00 36.54          
ATOM    571  O   PHE    81      13.312   0.137  25.086  1.00 35.85          
ATOM    572  CB  PHE    81      11.357   2.689  25.962  1.00 33.12          
ATOM    573  CG  PHE    81      10.681   1.435  26.465  1.00 30.51          
ATOM    574  CD1 PHE    81      11.210   0.717  27.524  1.00 29.09          
ATOM    575  CD2 PHE    81       9.528   0.957  25.850  1.00 30.08          
ATOM    576  CE1 PHE    81      10.613  -0.454  27.955  1.00 28.28          
ATOM    577  CE2 PHE    81       8.925  -0.218  26.280  1.00 28.60          
ATOM    578  CZ  PHE    81       9.470  -0.921  27.330  1.00 27.92          
ATOM    579  N   LYS    82      12.394   1.239  23.347  1.00 37.42          
ATOM    580  CA  LYS    82      12.392   0.079  22.453  1.00 38.62          
ATOM    581  C   LYS    82      13.807  -0.407  22.131  1.00 38.47          
ATOM    582  O   LYS    82      14.089  -1.606  22.162  1.00 36.19          
ATOM    583  CB  LYS    82      11.656   0.420  21.148  1.00 39.34          
ATOM    584  CG  LYS    82      11.549  -0.733  20.172  1.00 38.40          
ATOM    585  CD  LYS    82      10.907  -0.297  18.874  1.00 39.39          
ATOM    586  CE  LYS    82      10.964  -1.429  17.858  1.00 41.17          
ATOM    587  NZ  LYS    82       9.977  -1.274  16.742  1.00 42.70          
ATOM    588  N   LYS    83      14.690   0.535  21.822  1.00 39.75          
ATOM    589  CA  LYS    83      16.067   0.201  21.496  1.00 40.53          
ATOM    590  C   LYS    83      16.724  -0.543  22.648  1.00 40.76          
ATOM    591  O   LYS    83      17.320  -1.608  22.444  1.00 41.80          
ATOM    592  CB  LYS    83      16.863   1.470  21.177  1.00 40.74          
ATOM    593  CG  LYS    83      18.312   1.194  20.853  1.00 42.46          
ATOM    594  CD  LYS    83      19.071   2.446  20.455  1.00 45.99          
ATOM    595  CE  LYS    83      20.459   2.070  19.928  1.00 48.24          
ATOM    596  NZ  LYS    83      21.259   3.243  19.463  1.00 50.23          
ATOM    597  N   ARG    84      16.607   0.020  23.856  1.00 40.35          
ATOM    598  CA  ARG    84      17.190  -0.572  25.084  1.00 39.35          
ATOM    599  C   ARG    84      16.484  -1.854  25.530  1.00 37.92          
ATOM    600  O   ARG    84      17.133  -2.806  25.954  1.00 36.85          
ATOM    601  CB  ARG    84      17.156   0.429  26.250  1.00 36.67          
ATOM    602  CG  ARG    84      17.859   1.728  25.980  1.00 36.15          
ATOM    603  CD  ARG    84      18.054   2.528  27.259  1.00 38.44          
ATOM    604  NE  ARG    84      18.593   3.855  26.966  1.00 40.06          
ATOM    605  CZ  ARG    84      19.648   4.396  27.567  1.00 40.78          
ATOM    606  NH1 ARG    84      20.299   3.728  28.515  1.00 40.28          
ATOM    607  NH2 ARG    84      20.058   5.606  27.202  1.00 41.15          
ATOM    608  N   ALA    85      15.158  -1.862  25.438  1.00 37.30          
ATOM    609  CA  ALA    85      14.393  -3.027  25.822  1.00 38.07          
ATOM    610  C   ALA    85      14.677  -4.226  24.905  1.00 38.96          
ATOM    611  O   ALA    85      14.838  -5.338  25.393  1.00 38.84          
ATOM    612  CB  ALA    85      12.906  -2.698  25.837  1.00 37.62          
ATOM    613  N   GLU    86      14.755  -4.012  23.590  1.00 40.01          
ATOM    614  CA  GLU    86      15.020  -5.119  22.663  1.00 40.70          
ATOM    615  C   GLU    86      16.344  -5.794  22.966  1.00 39.19          
ATOM    616  O   GLU    86      16.460  -7.009  22.858  1.00 37.95          
ATOM    617  CB  GLU    86      15.035  -4.644  21.199  1.00 43.09          
ATOM    618  CG  GLU    86      13.732  -4.026  20.702  1.00 48.93          
ATOM    619  CD  GLU    86      13.759  -3.649  19.220  1.00 52.55          
ATOM    620  OE1 GLU    86      13.735  -4.566  18.368  1.00 56.38          
ATOM    621  OE2 GLU    86      13.814  -2.435  18.898  1.00 54.39          
ATOM    622  N   LYS    87      17.346  -5.012  23.343  1.00 38.58          
ATOM    623  CA  LYS    87      18.640  -5.592  23.648  1.00 38.74          
ATOM    624  C   LYS    87      18.535  -6.451  24.909  1.00 37.94          
ATOM    625  O   LYS    87      18.982  -7.593  24.913  1.00 37.92          
ATOM    626  CB  LYS    87      19.692  -4.489  23.821  1.00 40.10          
ATOM    627  CG  LYS    87      19.922  -3.647  22.563  1.00 40.60          
ATOM    628  CD  LYS    87      20.746  -2.395  22.866  1.00 42.69          
ATOM    629  CE  LYS    87      20.904  -1.490  21.628  1.00 42.87          
ATOM    630  NZ  LYS    87      21.492  -0.138  21.934  1.00 39.82          
ATOM    631  N   TYR    88      17.925  -5.910  25.962  1.00 36.95          
ATOM    632  CA  TYR    88      17.762  -6.644  27.214  1.00 37.15          
ATOM    633  C   TYR    88      16.916  -7.913  27.029  1.00 37.80          
ATOM    634  O   TYR    88      17.218  -8.973  27.580  1.00 37.94          
ATOM    635  CB  TYR    88      17.124  -5.756  28.295  1.00 37.25          
ATOM    636  CG  TYR    88      18.036  -4.700  28.910  1.00 39.23          
ATOM    637  CD1 TYR    88      17.783  -3.333  28.719  1.00 41.10          
ATOM    638  CD2 TYR    88      19.113  -5.059  29.734  1.00 38.28          
ATOM    639  CE1 TYR    88      18.568  -2.351  29.335  1.00 41.52          
ATOM    640  CE2 TYR    88      19.908  -4.081  30.358  1.00 38.86          
ATOM    641  CZ  TYR    88      19.626  -2.732  30.153  1.00 41.28          
ATOM    642  OH  TYR    88      20.390  -1.755  30.754  1.00 40.69          
ATOM    643  N   ILE    89      15.853  -7.815  26.250  1.00 37.05          
ATOM    644  CA  ILE    89      15.015  -8.973  26.022  1.00 36.98          
ATOM    645  C   ILE    89      15.820 -10.109  25.369  1.00 37.79          
ATOM    646  O   ILE    89      15.541 -11.282  25.617  1.00 37.75          
ATOM    647  CB  ILE    89      13.792  -8.608  25.139  1.00 35.57          
ATOM    648  CG1 ILE    89      12.904  -7.602  25.886  1.00 33.73          
ATOM    649  CG2 ILE    89      13.017  -9.859  24.777  1.00 33.51          
ATOM    650  CD  ILE    89      11.739  -7.066  25.077  1.00 30.08          
ATOM    651  N   LYS    90      16.806  -9.776  24.533  1.00 38.00          
ATOM    652  CA  LYS    90      17.631 -10.807  23.886  1.00 38.01          
ATOM    653  C   LYS    90      18.670 -11.334  24.868  1.00 38.13          
ATOM    654  O   LYS    90      18.861 -12.542  24.992  1.00 37.33          
ATOM    655  CB  LYS    90      18.349 -10.258  22.639  1.00 39.66          
ATOM    656  CG  LYS    90      17.608 -10.447  21.296  1.00 40.93          
ATOM    657  CD  LYS    90      18.408  -9.912  20.066  1.00 41.15          
ATOM    658  CE  LYS    90      18.564  -8.369  20.076  1.00 42.47          
ATOM    659  NZ  LYS    90      19.370  -7.772  18.962  1.00 39.46          
ATOM    660  N   ASP    91      19.342 -10.428  25.565  1.00 37.73          
ATOM    661  CA  ASP    91      20.350 -10.837  26.521  1.00 38.39          
ATOM    662  C   ASP    91      19.727 -11.783  27.541  1.00 38.89          
ATOM    663  O   ASP    91      20.293 -12.821  27.849  1.00 39.41          
ATOM    664  CB  ASP    91      20.930  -9.613  27.221  1.00 39.76          
ATOM    665  CG  ASP    91      22.095  -9.957  28.110  1.00 40.54          
ATOM    666  OD1 ASP    91      23.143 -10.368  27.568  1.00 41.54          
ATOM    667  OD2 ASP    91      21.961  -9.820  29.341  1.00 39.83          
ATOM    668  N   ILE    92      18.553 -11.418  28.052  1.00 38.96          
ATOM    669  CA  ILE    92      17.828 -12.232  29.034  1.00 39.57          
ATOM    670  C   ILE    92      17.530 -13.640  28.495  1.00 40.37          
ATOM    671  O   ILE    92      17.873 -14.645  29.131  1.00 41.32          
ATOM    672  CB  ILE    92      16.481 -11.547  29.448  1.00 38.05          
ATOM    673  CG1 ILE    92      16.772 -10.233  30.174  1.00 38.15          
ATOM    674  CG2 ILE    92      15.653 -12.464  30.338  1.00 36.72          
ATOM    675  CD  ILE    92      15.537  -9.460  30.585  1.00 35.07          
ATOM    676  N   THR    93      16.896 -13.717  27.326  1.00 40.55          
ATOM    677  CA  THR    93      16.551 -15.012  26.745  1.00 39.43          
ATOM    678  C   THR    93      17.799 -15.812  26.487  1.00 38.37          
ATOM    679  O   THR    93      17.805 -17.030  26.638  1.00 37.61          
ATOM    680  CB  THR    93      15.849 -14.890  25.379  1.00 40.05          
ATOM    681  OG1 THR    93      14.887 -13.822  25.391  1.00 40.47          
ATOM    682  CG2 THR    93      15.152 -16.199  25.048  1.00 38.13          
ATOM    683  N   ARG    94      18.851 -15.102  26.091  1.00 38.34          
ATOM    684  CA  ARG    94      20.141 -15.708  25.766  1.00 38.82          
ATOM    685  C   ARG    94      20.741 -16.429  26.954  1.00 37.58          
ATOM    686  O   ARG    94      21.525 -17.358  26.788  1.00 37.56          
ATOM    687  CB  ARG    94      21.106 -14.625  25.251  1.00 39.26          
ATOM    688  CG  ARG    94      22.336 -15.144  24.519  1.00 39.09          
ATOM    689  CD  ARG    94      23.214 -13.978  24.047  1.00 39.93          
ATOM    690  NE  ARG    94      23.583 -13.091  25.149  1.00 43.31          
ATOM    691  CZ  ARG    94      24.223 -13.484  26.250  1.00 44.23          
ATOM    692  NH1 ARG    94      24.509 -12.604  27.209  1.00 45.12          
ATOM    693  NH2 ARG    94      24.578 -14.756  26.396  1.00 44.13          
ATOM    694  N   ARG    95      20.374 -15.999  28.152  1.00 38.15          
ATOM    695  CA  ARG    95      20.890 -16.641  29.355  1.00 39.17          
ATOM    696  C   ARG    95      19.842 -17.586  29.935  1.00 40.16          
ATOM    697  O   ARG    95      19.773 -17.807  31.148  1.00 40.51          
ATOM    698  CB  ARG    95      21.312 -15.597  30.384  1.00 39.03          
ATOM    699  CG  ARG    95      22.321 -14.600  29.835  1.00 40.05          
ATOM    700  CD  ARG    95      22.995 -13.810  30.936  1.00 42.08          
ATOM    701  NE  ARG    95      22.028 -13.214  31.869  1.00 44.60          
ATOM    702  CZ  ARG    95      21.082 -12.352  31.516  1.00 45.39          
ATOM    703  NH1 ARG    95      20.262 -11.869  32.426  1.00 45.54          
ATOM    704  NH2 ARG    95      20.957 -11.974  30.249  1.00 47.84          
ATOM    705  N   GLY    96      19.024 -18.134  29.035  1.00 41.04          
ATOM    706  CA  GLY    96      17.982 -19.081  29.403  1.00 41.01          
ATOM    707  C   GLY    96      16.998 -18.627  30.459  1.00 41.51          
ATOM    708  O   GLY    96      16.566 -19.424  31.286  1.00 41.53          
ATOM    709  N   LYS    97      16.644 -17.350  30.443  1.00 41.90          
ATOM    710  CA  LYS    97      15.692 -16.832  31.419  1.00 42.49          
ATOM    711  C   LYS    97      14.426 -16.318  30.727  1.00 41.53          
ATOM    712  O   LYS    97      14.305 -16.363  29.498  1.00 42.10          
ATOM    713  CB  LYS    97      16.334 -15.716  32.252  1.00 43.46          
ATOM    714  CG  LYS    97      17.166 -16.206  33.436  1.00 45.45          
ATOM    715  CD  LYS    97      17.908 -15.050  34.122  1.00 48.34          
ATOM    716  CE  LYS    97      18.004 -15.240  35.662  1.00 50.04          
ATOM    717  NZ  LYS    97      18.682 -16.515  36.088  1.00 48.07          
ATOM    718  N   VAL    98      13.483 -15.833  31.524  1.00 38.99          
ATOM    719  CA  VAL    98      12.230 -15.338  30.989  1.00 36.53          
ATOM    720  C   VAL    98      12.110 -13.838  31.071  1.00 37.14          
ATOM    721  O   VAL    98      11.898 -13.280  32.152  1.00 36.62          
ATOM    722  CB  VAL    98      11.041 -15.936  31.733  1.00 35.74          
ATOM    723  CG1 VAL    98       9.748 -15.385  31.159  1.00 34.97          
ATOM    724  CG2 VAL    98      11.084 -17.440  31.629  1.00 34.69          
ATOM    725  N   PRO    99      12.236 -13.158  29.924  1.00 36.43          
ATOM    726  CA  PRO    99      12.133 -11.702  29.880  1.00 35.92          
ATOM    727  C   PRO    99      10.707 -11.243  30.242  1.00 36.90          
ATOM    728  O   PRO    99       9.723 -11.657  29.609  1.00 36.32          
ATOM    729  CB  PRO    99      12.510 -11.383  28.444  1.00 35.09          
ATOM    730  CG  PRO    99      11.952 -12.549  27.710  1.00 35.11          
ATOM    731  CD  PRO    99      12.350 -13.717  28.570  1.00 35.83          
ATOM    732  N   ILE   100      10.609 -10.378  31.256  1.00 35.85          
ATOM    733  CA  ILE   100       9.324  -9.866  31.746  1.00 34.09          
ATOM    734  C   ILE   100       9.369  -8.347  31.820  1.00 34.92          
ATOM    735  O   ILE   100      10.280  -7.778  32.418  1.00 35.54          
ATOM    736  CB  ILE   100       9.038 -10.371  33.182  1.00 33.56          
ATOM    737  CG1 ILE   100       9.218 -11.888  33.261  1.00 33.93          
ATOM    738  CG2 ILE   100       7.648 -10.007  33.583  1.00 30.85          
ATOM    739  CD  ILE   100       9.497 -12.376  34.658  1.00 33.77          
ATOM    740  N   ILE   101       8.394  -7.688  31.213  1.00 35.33          
ATOM    741  CA  ILE   101       8.345  -6.238  31.279  1.00 35.38          
ATOM    742  C   ILE   101       7.166  -5.844  32.173  1.00 35.55          
ATOM    743  O   ILE   101       6.032  -6.270  31.972  1.00 34.79          
ATOM    744  CB  ILE   101       8.215  -5.592  29.879  1.00 34.99          
ATOM    745  CG1 ILE   101       7.036  -6.192  29.133  1.00 36.58          
ATOM    746  CG2 ILE   101       9.498  -5.807  29.099  1.00 34.45          
ATOM    747  CD  ILE   101       6.915  -5.691  27.723  1.00 39.07          
ATOM    748  N   ALA   102       7.478  -5.049  33.189  1.00 35.59          
ATOM    749  CA  ALA   102       6.510  -4.580  34.147  1.00 34.62          
ATOM    750  C   ALA   102       6.215  -3.135  33.837  1.00 36.25          
ATOM    751  O   ALA   102       7.129  -2.337  33.607  1.00 36.56          
ATOM    752  CB  ALA   102       7.066  -4.700  35.535  1.00 31.84          
ATOM    753  N   GLY   103       4.928  -2.806  33.808  1.00 36.86          
ATOM    754  CA  GLY   103       4.514  -1.438  33.547  1.00 34.82          
ATOM    755  C   GLY   103       4.605  -1.026  32.101  1.00 34.11          
ATOM    756  O   GLY   103       4.742  -1.863  31.211  1.00 34.68          
ATOM    757  N   GLY   104       4.527   0.282  31.880  1.00 34.21          
ATOM    758  CA  GLY   104       4.591   0.823  30.538  1.00 32.64          
ATOM    759  C   GLY   104       3.248   1.377  30.095  1.00 32.24          
ATOM    760  O   GLY   104       2.210   0.989  30.619  1.00 30.34          
ATOM    761  N   THR   105       3.271   2.290  29.129  1.00 34.02          
ATOM    762  CA  THR   105       2.050   2.892  28.604  1.00 36.46          
ATOM    763  C   THR   105       1.713   2.289  27.233  1.00 37.92          
ATOM    764  O   THR   105       2.510   1.540  26.673  1.00 39.04          
ATOM    765  CB  THR   105       2.202   4.430  28.452  1.00 35.92          
ATOM    766  OG1 THR   105       3.371   4.736  27.677  1.00 35.55          
ATOM    767  CG2 THR   105       2.293   5.096  29.818  1.00 36.82          
ATOM    768  N   GLY   106       0.540   2.619  26.698  1.00 38.11          
ATOM    769  CA  GLY   106       0.146   2.102  25.400  1.00 37.56          
ATOM    770  C   GLY   106       1.221   2.304  24.344  1.00 37.63          
ATOM    771  O   GLY   106       1.659   1.346  23.714  1.00 35.90          
ATOM    772  N   LEU   107       1.653   3.544  24.140  1.00 38.20          
ATOM    773  CA  LEU   107       2.685   3.791  23.151  1.00 39.43          
ATOM    774  C   LEU   107       3.891   2.894  23.389  1.00 39.89          
ATOM    775  O   LEU   107       4.174   2.017  22.579  1.00 41.10          
ATOM    776  CB  LEU   107       3.131   5.252  23.168  1.00 41.15          
ATOM    777  CG  LEU   107       2.421   6.254  22.244  1.00 41.69          
ATOM    778  CD1 LEU   107       2.941   7.651  22.577  1.00 42.07          
ATOM    779  CD2 LEU   107       2.684   5.922  20.777  1.00 41.61          
ATOM    780  N   TYR   108       4.583   3.096  24.509  1.00 39.43          
ATOM    781  CA  TYR   108       5.766   2.308  24.847  1.00 38.14          
ATOM    782  C   TYR   108       5.590   0.811  24.689  1.00 37.73          
ATOM    783  O   TYR   108       6.523   0.120  24.310  1.00 37.59          
ATOM    784  CB  TYR   108       6.209   2.586  26.283  1.00 40.80          
ATOM    785  CG  TYR   108       6.759   3.969  26.516  1.00 43.04          
ATOM    786  CD1 TYR   108       8.091   4.149  26.882  1.00 42.95          
ATOM    787  CD2 TYR   108       5.943   5.101  26.371  1.00 44.06          
ATOM    788  CE1 TYR   108       8.609   5.421  27.098  1.00 45.65          
ATOM    789  CE2 TYR   108       6.446   6.384  26.583  1.00 46.23          
ATOM    790  CZ  TYR   108       7.788   6.536  26.947  1.00 47.17          
ATOM    791  OH  TYR   108       8.307   7.800  27.154  1.00 48.96          
ATOM    792  N   ILE   109       4.403   0.303  24.987  1.00 38.17          
ATOM    793  CA  ILE   109       4.185  -1.120  24.881  1.00 39.47          
ATOM    794  C   ILE   109       3.935  -1.613  23.469  1.00 40.68          
ATOM    795  O   ILE   109       4.524  -2.605  23.053  1.00 42.01          
ATOM    796  CB  ILE   109       3.038  -1.567  25.781  1.00 39.28          
ATOM    797  CG1 ILE   109       3.376  -1.240  27.225  1.00 41.80          
ATOM    798  CG2 ILE   109       2.815  -3.062  25.646  1.00 39.71          
ATOM    799  CD  ILE   109       4.689  -1.861  27.711  1.00 43.04          
ATOM    800  N   GLN   110       3.070  -0.944  22.718  1.00 41.74          
ATOM    801  CA  GLN   110       2.827  -1.410  21.365  1.00 42.65          
ATOM    802  C   GLN   110       4.045  -1.161  20.478  1.00 42.85          
ATOM    803  O   GLN   110       4.395  -1.985  19.624  1.00 43.03          
ATOM    804  CB  GLN   110       1.574  -0.757  20.759  1.00 43.38          
ATOM    805  CG  GLN   110       1.751   0.625  20.174  1.00 43.67          
ATOM    806  CD  GLN   110       0.605   0.995  19.236  1.00 44.36          
ATOM    807  OE1 GLN   110       0.534   2.121  18.741  1.00 44.31          
ATOM    808  NE2 GLN   110      -0.294   0.039  18.983  1.00 43.98          
ATOM    809  N   SER   111       4.712  -0.038  20.695  1.00 42.96          
ATOM    810  CA  SER   111       5.890   0.292  19.900  1.00 43.29          
ATOM    811  C   SER   111       6.911  -0.835  20.019  1.00 43.63          
ATOM    812  O   SER   111       7.658  -1.120  19.081  1.00 43.24          
ATOM    813  CB  SER   111       6.490   1.620  20.382  1.00 41.83          
ATOM    814  OG  SER   111       5.519   2.653  20.359  1.00 38.04          
ATOM    815  N   LEU   112       6.910  -1.484  21.179  1.00 42.94          
ATOM    816  CA  LEU   112       7.820  -2.589  21.466  1.00 43.24          
ATOM    817  C   LEU   112       7.305  -3.932  20.984  1.00 42.84          
ATOM    818  O   LEU   112       8.084  -4.826  20.664  1.00 43.39          
ATOM    819  CB  LEU   112       8.073  -2.679  22.980  1.00 42.95          
ATOM    820  CG  LEU   112       8.738  -3.944  23.539  1.00 41.60          
ATOM    821  CD1 LEU   112      10.130  -4.145  22.941  1.00 40.14          
ATOM    822  CD2 LEU   112       8.806  -3.824  25.042  1.00 40.07          
ATOM    823  N   LEU   113       5.991  -4.079  20.943  1.00 42.94          
ATOM    824  CA  LEU   113       5.404  -5.342  20.529  1.00 43.87          
ATOM    825  C   LEU   113       5.256  -5.507  19.022  1.00 43.65          
ATOM    826  O   LEU   113       5.468  -6.595  18.492  1.00 43.18          
ATOM    827  CB  LEU   113       4.040  -5.520  21.201  1.00 44.22          
ATOM    828  CG  LEU   113       4.098  -5.537  22.733  1.00 45.40          
ATOM    829  CD1 LEU   113       2.696  -5.608  23.294  1.00 45.75          
ATOM    830  CD2 LEU   113       4.926  -6.726  23.201  1.00 45.87          
ATOM    831  N   TYR   114       4.929  -4.421  18.335  1.00 43.62          
ATOM    832  CA  TYR   114       4.706  -4.469  16.899  1.00 43.89          
ATOM    833  C   TYR   114       5.617  -3.561  16.106  1.00 45.49          
ATOM    834  O   TYR   114       5.993  -2.496  16.576  1.00 47.98          
ATOM    835  CB  TYR   114       3.260  -4.078  16.614  1.00 43.38          
ATOM    836  CG  TYR   114       2.270  -4.789  17.502  1.00 40.83          
ATOM    837  CD1 TYR   114       2.213  -6.172  17.514  1.00 39.48          
ATOM    838  CD2 TYR   114       1.400  -4.079  18.333  1.00 40.02          
ATOM    839  CE1 TYR   114       1.327  -6.844  18.322  1.00 40.57          
ATOM    840  CE2 TYR   114       0.495  -4.743  19.155  1.00 40.05          
ATOM    841  CZ  TYR   114       0.471  -6.140  19.138  1.00 40.06          
ATOM    842  OH  TYR   114      -0.394  -6.860  19.917  1.00 39.18          
ATOM    843  N   ASN   115       5.955  -3.974  14.892  1.00 47.91          
ATOM    844  CA  ASN   115       6.802  -3.165  14.034  1.00 49.56          
ATOM    845  C   ASN   115       6.010  -2.369  13.028  1.00 50.49          
ATOM    846  O   ASN   115       6.268  -2.476  11.836  1.00 50.90          
ATOM    847  CB  ASN   115       7.765  -4.042  13.268  1.00 49.54          
ATOM    848  CG  ASN   115       9.037  -4.256  13.998  1.00 51.39          
ATOM    849  OD1 ASN   115       9.954  -4.869  13.468  1.00 52.45          
ATOM    850  ND2 ASN   115       9.117  -3.749  15.233  1.00 52.07          
ATOM   1490  N   GLU   194       4.232  -8.569  14.796  1.00 47.75          
ATOM   1491  CA  GLU   194       4.617  -8.834  16.179  1.00 49.40          
ATOM   1492  C   GLU   194       6.024  -9.388  16.317  1.00 48.31          
ATOM   1493  O   GLU   194       6.399 -10.332  15.638  1.00 48.33          
ATOM   1494  CB  GLU   194       3.630  -9.789  16.843  1.00 51.42          
ATOM   1495  CG  GLU   194       3.490 -11.112  16.136  1.00 56.87          
ATOM   1496  CD  GLU   194       2.523 -12.042  16.848  1.00 60.08          
ATOM   1497  OE1 GLU   194       2.177 -13.105  16.267  1.00 61.22          
ATOM   1498  OE2 GLU   194       2.115 -11.713  17.992  1.00 60.95          
ATOM   1499  N   ASN   195       6.787  -8.798  17.226  1.00 46.51          
ATOM   1500  CA  ASN   195       8.143  -9.207  17.436  1.00 45.67          
ATOM   1501  C   ASN   195       8.302 -10.310  18.443  1.00 45.98          
ATOM   1502  O   ASN   195       9.308 -11.001  18.434  1.00 47.00          
ATOM   1503  CB  ASN   195       8.982  -8.016  17.860  1.00 47.07          
ATOM   1504  CG  ASN   195       8.897  -6.874  16.867  1.00 48.46          
ATOM   1505  OD1 ASN   195       8.841  -7.099  15.655  1.00 49.07          
ATOM   1506  ND2 ASN   195       8.880  -5.641  17.372  1.00 48.06          
ATOM   1507  N   TYR   196       7.326 -10.499  19.315  1.00 46.29          
ATOM   1508  CA  TYR   196       7.467 -11.540  20.317  1.00 47.17          
ATOM   1509  C   TYR   196       6.232 -12.389  20.522  1.00 47.82          
ATOM   1510  O   TYR   196       5.125 -12.002  20.152  1.00 47.37          
ATOM   1511  CB  TYR   196       7.860 -10.918  21.664  1.00 46.04          
ATOM   1512  CG  TYR   196       8.973  -9.899  21.584  1.00 45.49          
ATOM   1513  CD1 TYR   196       8.701  -8.549  21.361  1.00 44.85          
ATOM   1514  CD2 TYR   196      10.304 -10.286  21.742  1.00 45.74          
ATOM   1515  CE1 TYR   196       9.736  -7.609  21.307  1.00 44.31          
ATOM   1516  CE2 TYR   196      11.340  -9.361  21.684  1.00 43.91          
ATOM   1517  CZ  TYR   196      11.055  -8.032  21.471  1.00 43.56          
ATOM   1518  OH  TYR   196      12.099  -7.141  21.438  1.00 42.22          
ATOM   1519  N   ASP   197       6.451 -13.561  21.112  1.00 48.93          
ATOM   1520  CA  ASP   197       5.371 -14.486  21.452  1.00 50.31          
ATOM   1521  C   ASP   197       4.840 -13.955  22.786  1.00 50.43          
ATOM   1522  O   ASP   197       4.990 -14.599  23.832  1.00 51.08          
ATOM   1523  CB  ASP   197       5.918 -15.900  21.660  1.00 51.47          
ATOM   1524  CG  ASP   197       4.886 -16.831  22.266  1.00 53.27          
ATOM   1525  OD1 ASP   197       5.258 -17.893  22.809  1.00 53.86          
ATOM   1526  OD2 ASP   197       3.686 -16.493  22.203  1.00 55.59          
ATOM   1527  N   THR   198       4.213 -12.782  22.737  1.00 49.76          
ATOM   1528  CA  THR   198       3.713 -12.096  23.932  1.00 49.28          
ATOM   1529  C   THR   198       2.563 -12.709  24.722  1.00 47.06          
ATOM   1530  O   THR   198       1.661 -13.327  24.170  1.00 46.55          
ATOM   1531  CB  THR   198       3.316 -10.626  23.597  1.00 50.79          
ATOM   1532  OG1 THR   198       2.051 -10.612  22.924  1.00 52.00          
ATOM   1533  CG2 THR   198       4.370  -9.971  22.696  1.00 51.01          
ATOM   1534  N   LEU   199       2.632 -12.528  26.034  1.00 46.23          
ATOM   1535  CA  LEU   199       1.601 -12.991  26.946  1.00 45.60          
ATOM   1536  C   LEU   199       1.181 -11.716  27.675  1.00 44.21          
ATOM   1537  O   LEU   199       1.519 -11.500  28.833  1.00 44.85          
ATOM   1538  CB  LEU   199       2.165 -14.024  27.925  1.00 44.96          
ATOM   1539  CG  LEU   199       1.253 -14.518  29.057  1.00 44.18          
ATOM   1540  CD1 LEU   199      -0.198 -14.656  28.608  1.00 43.89          
ATOM   1541  CD2 LEU   199       1.800 -15.840  29.538  1.00 45.05          
ATOM   1542  N   LEU   200       0.460 -10.863  26.959  1.00 41.66          
ATOM   1543  CA  LEU   200       0.026  -9.582  27.478  1.00 40.53          
ATOM   1544  C   LEU   200      -1.114  -9.672  28.479  1.00 39.77          
ATOM   1545  O   LEU   200      -2.234 -10.034  28.127  1.00 37.94          
ATOM   1546  CB  LEU   200      -0.372  -8.688  26.310  1.00 40.26          
ATOM   1547  CG  LEU   200      -0.657  -7.221  26.580  1.00 41.39          
ATOM   1548  CD1 LEU   200       0.606  -6.499  27.040  1.00 40.32          
ATOM   1549  CD2 LEU   200      -1.184  -6.590  25.299  1.00 42.87          
ATOM   1550  N   ILE   201      -0.821  -9.338  29.732  1.00 39.53          
ATOM   1551  CA  ILE   201      -1.838  -9.382  30.775  1.00 41.00          
ATOM   1552  C   ILE   201      -1.965  -8.007  31.463  1.00 40.72          
ATOM   1553  O   ILE   201      -0.981  -7.287  31.653  1.00 39.19          
ATOM   1554  CB  ILE   201      -1.542 -10.523  31.829  1.00 40.54          
ATOM   1555  CG1 ILE   201      -0.531 -10.072  32.855  1.00 40.51          
ATOM   1556  CG2 ILE   201      -0.955 -11.744  31.155  1.00 40.02          
ATOM   1557  CD  ILE   201      -1.170  -9.597  34.101  1.00 41.99          
ATOM   1558  N   GLY   202      -3.196  -7.644  31.809  1.00 41.71          
ATOM   1559  CA  GLY   202      -3.450  -6.372  32.457  1.00 42.46          
ATOM   1560  C   GLY   202      -4.338  -6.522  33.676  1.00 43.59          
ATOM   1561  O   GLY   202      -5.207  -7.391  33.711  1.00 43.17          
ATOM   1562  N   ILE   203      -4.107  -5.686  34.684  1.00 45.16          
ATOM   1563  CA  ILE   203      -4.900  -5.716  35.906  1.00 46.85          
ATOM   1564  C   ILE   203      -5.963  -4.638  35.810  1.00 48.66          
ATOM   1565  O   ILE   203      -5.655  -3.452  35.710  1.00 48.68          
ATOM   1566  CB  ILE   203      -4.041  -5.445  37.133  1.00 45.94          
ATOM   1567  CG1 ILE   203      -2.866  -6.419  37.179  1.00 46.14          
ATOM   1568  CG2 ILE   203      -4.882  -5.594  38.376  1.00 46.19          
ATOM   1569  CD  ILE   203      -1.912  -6.143  38.319  1.00 45.78          
ATOM   1570  N   GLU   204      -7.216  -5.058  35.849  1.00 51.48          
ATOM   1571  CA  GLU   204      -8.332  -4.138  35.715  1.00 55.82          
ATOM   1572  C   GLU   204      -9.114  -3.943  37.015  1.00 56.85          
ATOM   1573  O   GLU   204      -8.898  -4.644  37.995  1.00 56.30          
ATOM   1574  CB  GLU   204      -9.269  -4.675  34.637  1.00 59.26          
ATOM   1575  CG  GLU   204     -10.412  -3.758  34.261  1.00 64.70          
ATOM   1576  CD  GLU   204     -11.575  -4.512  33.653  1.00 67.29          
ATOM   1577  OE1 GLU   204     -12.163  -5.358  34.370  1.00 69.22          
ATOM   1578  OE2 GLU   204     -11.889  -4.257  32.466  1.00 68.13          
ATOM   1579  N   MET   205     -10.035  -2.988  37.010  1.00 58.68          
ATOM   1580  CA  MET   205     -10.855  -2.725  38.174  1.00 61.00          
ATOM   1581  C   MET   205     -11.885  -1.669  37.811  1.00 59.37          
ATOM   1582  O   MET   205     -11.719  -0.954  36.826  1.00 58.70          
ATOM   1583  CB  MET   205      -9.978  -2.261  39.332  1.00 66.33          
ATOM   1584  CG  MET   205      -9.104  -1.084  38.972  1.00 74.24          
ATOM   1585  SD  MET   205      -7.625  -0.835  40.201  1.00 86.23          
ATOM   1586  CE  MET   205      -8.641  -0.116  41.686  1.00 83.03          
ATOM   1587  N   SER   206     -12.954  -1.581  38.598  1.00 57.85          
ATOM   1588  CA  SER   206     -14.017  -0.622  38.331  1.00 57.29          
ATOM   1589  C   SER   206     -13.525   0.799  38.510  1.00 57.42          
ATOM   1590  O   SER   206     -12.622   1.049  39.304  1.00 57.34          
ATOM   1591  CB  SER   206     -15.212  -0.875  39.253  1.00 58.20          
ATOM   1592  OG  SER   206     -14.949  -0.485  40.595  1.00 58.30          
ATOM   1593  N   ARG   207     -14.121   1.732  37.774  1.00 57.81          
ATOM   1594  CA  ARG   207     -13.720   3.130  37.862  1.00 57.90          
ATOM   1595  C   ARG   207     -13.876   3.620  39.294  1.00 57.25          
ATOM   1596  O   ARG   207     -13.126   4.486  39.747  1.00 57.38          
ATOM   1597  CB  ARG   207     -14.567   4.018  36.933  1.00 59.77          
ATOM   1598  CG  ARG   207     -13.797   5.238  36.402  1.00 61.95          
ATOM   1599  CD  ARG   207     -14.603   6.536  36.316  1.00 63.77          
ATOM   1600  NE  ARG   207     -15.787   6.495  35.515  1.00 65.96          
ATOM   1601  CZ  ARG   207     -16.987   7.059  35.671  1.00 66.23          
ATOM   1602  NH1 ARG   207     -17.834   6.800  34.702  1.00 66.18          
ATOM   1603  NH2 ARG   207     -17.386   7.808  36.700  1.00 64.90          
ATOM   1604  N   GLU   208     -14.856   3.069  40.004  1.00 56.65          
ATOM   1605  CA  GLU   208     -15.097   3.463  41.387  1.00 56.14          
ATOM   1606  C   GLU   208     -13.862   3.162  42.237  1.00 55.10          
ATOM   1607  O   GLU   208     -13.262   4.069  42.819  1.00 54.75          
ATOM   1608  CB  GLU   208     -16.300   2.709  41.977  1.00 56.67          
ATOM   1609  CG  GLU   208     -17.676   2.979  41.343  1.00 57.91          
ATOM   1610  CD  GLU   208     -18.003   2.049  40.169  1.00 58.56          
ATOM   1611  OE1 GLU   208     -17.721   2.435  39.013  1.00 58.35          
ATOM   1612  OE2 GLU   208     -18.530   0.931  40.407  1.00 57.29          
ATOM   1613  N   THR   209     -13.490   1.883  42.301  1.00 54.16          
ATOM   1614  CA  THR   209     -12.340   1.456  43.092  1.00 53.60          
ATOM   1615  C   THR   209     -11.061   2.129  42.604  1.00 53.06          
ATOM   1616  O   THR   209     -10.239   2.571  43.400  1.00 52.72          
ATOM   1617  CB  THR   209     -12.153  -0.092  43.046  1.00 52.87          
ATOM   1618  OG1 THR   209     -13.366  -0.746  43.439  1.00 51.02          
ATOM   1619  CG2 THR   209     -11.043  -0.527  43.995  1.00 52.66          
ATOM   1620  N   LEU   210     -10.901   2.203  41.291  1.00 52.94          
ATOM   1621  CA  LEU   210      -9.730   2.828  40.703  1.00 52.98          
ATOM   1622  C   LEU   210      -9.528   4.235  41.261  1.00 52.71          
ATOM   1623  O   LEU   210      -8.509   4.528  41.891  1.00 52.92          
ATOM   1624  CB  LEU   210      -9.889   2.903  39.180  1.00 54.27          
ATOM   1625  CG  LEU   210      -8.820   3.668  38.374  1.00 54.83          
ATOM   1626  CD1 LEU   210      -7.497   2.944  38.513  1.00 56.79          
ATOM   1627  CD2 LEU   210      -9.212   3.773  36.904  1.00 53.90          
ATOM   1628  N   TYR   211     -10.512   5.097  41.028  1.00 52.09          
ATOM   1629  CA  TYR   211     -10.454   6.482  41.481  1.00 52.39          
ATOM   1630  C   TYR   211     -10.234   6.630  42.979  1.00 51.09          
ATOM   1631  O   TYR   211      -9.549   7.548  43.435  1.00 50.28          
ATOM   1632  CB  TYR   211     -11.728   7.237  41.061  1.00 54.07          
ATOM   1633  CG  TYR   211     -11.758   7.638  39.596  1.00 56.55          
ATOM   1634  CD1 TYR   211     -12.669   8.581  39.128  1.00 57.92          
ATOM   1635  CD2 TYR   211     -10.858   7.092  38.684  1.00 57.95          
ATOM   1636  CE1 TYR   211     -12.681   8.975  37.789  1.00 59.13          
ATOM   1637  CE2 TYR   211     -10.859   7.474  37.347  1.00 59.28          
ATOM   1638  CZ  TYR   211     -11.772   8.419  36.907  1.00 60.34          
ATOM   1639  OH  TYR   211     -11.763   8.810  35.586  1.00 61.94          
ATOM   1640  N   LEU   212     -10.808   5.721  43.748  1.00 50.37          
ATOM   1641  CA  LEU   212     -10.654   5.778  45.187  1.00 49.40          
ATOM   1642  C   LEU   212      -9.215   5.448  45.593  1.00 48.18          
ATOM   1643  O   LEU   212      -8.628   6.134  46.430  1.00 47.77          
ATOM   1644  CB  LEU   212     -11.630   4.805  45.834  1.00 50.41          
ATOM   1645  CG  LEU   212     -11.704   4.886  47.349  1.00 51.44          
ATOM   1646  CD1 LEU   212     -12.122   6.288  47.772  1.00 51.12          
ATOM   1647  CD2 LEU   212     -12.696   3.850  47.841  1.00 52.30          
ATOM   1648  N   ARG   213      -8.648   4.411  44.982  1.00 47.23          
ATOM   1649  CA  ARG   213      -7.288   3.993  45.291  1.00 45.81          
ATOM   1650  C   ARG   213      -6.283   5.054  44.893  1.00 45.00          
ATOM   1651  O   ARG   213      -5.316   5.301  45.618  1.00 45.34          
ATOM   1652  CB  ARG   213      -6.953   2.680  44.589  1.00 46.12          
ATOM   1653  CG  ARG   213      -7.893   1.561  44.947  1.00 47.50          
ATOM   1654  CD  ARG   213      -7.285   0.226  44.633  1.00 49.26          
ATOM   1655  NE  ARG   213      -6.204  -0.149  45.481  1.00 50.85          
ATOM   1656  CZ  ARG   213      -4.999  -0.646  45.219  1.00 52.07          
ATOM   1657  NH1 ARG   213      -4.277  -0.882  46.291  1.00 51.27          
ATOM   1658  NH2 ARG   213      -4.484  -0.876  44.015  1.00 52.18          
ATOM   1659  N   ILE   214      -6.505   5.677  43.740  1.00 42.90          
ATOM   1660  CA  ILE   214      -5.607   6.723  43.284  1.00 42.58          
ATOM   1661  C   ILE   214      -5.609   7.858  44.301  1.00 44.04          
ATOM   1662  O   ILE   214      -4.549   8.290  44.754  1.00 44.37          
ATOM   1663  CB  ILE   214      -6.015   7.257  41.894  1.00 42.38          
ATOM   1664  CG1 ILE   214      -5.905   6.130  40.856  1.00 41.56          
ATOM   1665  CG2 ILE   214      -5.131   8.432  41.499  1.00 40.53          
ATOM   1666  CD  ILE   214      -6.409   6.490  39.488  1.00 40.18          
ATOM   1667  N   ASN   215      -6.780   8.339  44.694  1.00 44.37          
ATOM   1668  CA  ASN   215      -6.782   9.402  45.689  1.00 46.12          
ATOM   1669  C   ASN   215      -5.987   8.978  46.906  1.00 45.68          
ATOM   1670  O   ASN   215      -5.266   9.777  47.492  1.00 45.52          
ATOM   1671  CB  ASN   215      -8.198   9.764  46.118  1.00 47.65          
ATOM   1672  CG  ASN   215      -9.003  10.321  44.984  1.00 49.26          
ATOM   1673  OD1 ASN   215      -8.501  11.116  44.187  1.00 50.48          
ATOM   1674  ND2 ASN   215     -10.263   9.922  44.902  1.00 50.51          
ATOM   1675  N   LYS   216      -6.107   7.711  47.274  1.00 45.88          
ATOM   1676  CA  LYS   216      -5.394   7.213  48.435  1.00 46.84          
ATOM   1677  C   LYS   216      -3.888   7.081  48.215  1.00 46.74          
ATOM   1678  O   LYS   216      -3.116   7.192  49.158  1.00 46.10          
ATOM   1679  CB  LYS   216      -5.984   5.876  48.880  1.00 48.06          
ATOM   1680  CG  LYS   216      -5.384   5.354  50.172  1.00 51.11          
ATOM   1681  CD  LYS   216      -6.408   4.614  51.040  1.00 52.88          
ATOM   1682  CE  LYS   216      -5.802   4.179  52.382  1.00 52.11          
ATOM   1683  NZ  LYS   216      -6.811   3.570  53.287  1.00 51.76          
ATOM   1684  N   ARG   217      -3.464   6.859  46.978  1.00 47.09          
ATOM   1685  CA  ARG   217      -2.040   6.725  46.708  1.00 47.24          
ATOM   1686  C   ARG   217      -1.372   8.088  46.677  1.00 46.13          
ATOM   1687  O   ARG   217      -0.179   8.219  46.959  1.00 46.25          
ATOM   1688  CB  ARG   217      -1.820   6.000  45.388  1.00 48.37          
ATOM   1689  CG  ARG   217      -0.383   5.876  44.976  1.00 50.40          
ATOM   1690  CD  ARG   217      -0.312   5.084  43.691  1.00 55.04          
ATOM   1691  NE  ARG   217      -1.153   5.631  42.611  1.00 58.04          
ATOM   1692  CZ  ARG   217      -0.829   6.677  41.851  1.00 58.71          
ATOM   1693  NH1 ARG   217      -1.659   7.091  40.896  1.00 58.58          
ATOM   1694  NH2 ARG   217       0.322   7.310  42.050  1.00 58.89          
ATOM   1695  N   VAL   218      -2.145   9.108  46.333  1.00 46.00          
ATOM   1696  CA  VAL   218      -1.609  10.455  46.284  1.00 46.08          
ATOM   1697  C   VAL   218      -1.417  10.905  47.725  1.00 47.54          
ATOM   1698  O   VAL   218      -0.449  11.586  48.042  1.00 46.77          
ATOM   1699  CB  VAL   218      -2.564  11.419  45.510  1.00 44.61          
ATOM   1700  CG1 VAL   218      -2.020  12.835  45.537  1.00 44.97          
ATOM   1701  CG2 VAL   218      -2.703  10.968  44.068  1.00 41.49          
ATOM   1702  N   ASP   219      -2.329  10.501  48.608  1.00 49.53          
ATOM   1703  CA  ASP   219      -2.219  10.875  50.019  1.00 50.83          
ATOM   1704  C   ASP   219      -0.959  10.273  50.608  1.00 51.42          
ATOM   1705  O   ASP   219      -0.230  10.942  51.334  1.00 52.60          
ATOM   1706  CB  ASP   219      -3.429  10.395  50.829  1.00 51.95          
ATOM   1707  CG  ASP   219      -4.704  11.146  50.482  1.00 54.27          
ATOM   1708  OD1 ASP   219      -4.604  12.292  49.978  1.00 54.93          
ATOM   1709  OD2 ASP   219      -5.813  10.598  50.730  1.00 54.88          
ATOM   1710  N   ILE   220      -0.704   9.007  50.298  1.00 50.93          
ATOM   1711  CA  ILE   220       0.475   8.335  50.820  1.00 50.35          
ATOM   1712  C   ILE   220       1.763   8.987  50.330  1.00 50.83          
ATOM   1713  O   ILE   220       2.692   9.191  51.107  1.00 49.12          
ATOM   1714  CB  ILE   220       0.489   6.861  50.422  1.00 50.25          
ATOM   1715  CG1 ILE   220      -0.829   6.199  50.819  1.00 49.65          
ATOM   1716  CG2 ILE   220       1.650   6.162  51.101  1.00 49.47          
ATOM   1717  CD  ILE   220      -0.965   4.771  50.337  1.00 48.90          
ATOM   1718  N   MET   221       1.819   9.308  49.040  1.00 52.75          
ATOM   1719  CA  MET   221       3.011   9.936  48.478  1.00 54.09          
ATOM   1720  C   MET   221       3.341  11.226  49.222  1.00 53.07          
ATOM   1721  O   MET   221       4.496  11.462  49.582  1.00 53.63          
ATOM   1722  CB  MET   221       2.829  10.262  46.996  1.00 57.37          
ATOM   1723  CG  MET   221       2.482   9.089  46.099  1.00 61.31          
ATOM   1724  SD  MET   221       2.805   9.516  44.215  1.00 68.30          
ATOM   1725  CE  MET   221       1.657  11.071  43.994  1.00 66.79          
ATOM   1726  N   LEU   222       2.329  12.066  49.435  1.00 51.20          
ATOM   1727  CA  LEU   222       2.529  13.324  50.144  1.00 48.78          
ATOM   1728  C   LEU   222       3.049  12.992  51.524  1.00 47.82          
ATOM   1729  O   LEU   222       3.943  13.657  52.041  1.00 46.99          
ATOM   1730  CB  LEU   222       1.211  14.101  50.261  1.00 47.68          
ATOM   1731  CG  LEU   222       0.761  14.988  49.091  1.00 47.08          
ATOM   1732  CD1 LEU   222       1.733  16.140  48.895  1.00 47.95          
ATOM   1733  CD2 LEU   222       0.673  14.168  47.838  1.00 47.74          
ATOM   1734  N   GLY   223       2.490  11.934  52.102  1.00 47.54          
ATOM   1735  CA  GLY   223       2.885  11.507  53.429  1.00 46.72          
ATOM   1736  C   GLY   223       4.254  10.872  53.473  1.00 47.26          
ATOM   1737  O   GLY   223       4.836  10.750  54.540  1.00 46.92          
ATOM   1738  N   HSD   224       4.783  10.465  52.326  1.00 48.55          
ATOM   1739  CA  HSD   224       6.096   9.847  52.324  1.00 49.09          
ATOM   1740  C   HSD   224       7.240  10.792  51.959  1.00 49.59          
ATOM   1741  O   HSD   224       8.401  10.389  51.959  1.00 50.22          
ATOM   1742  CB  HSD   224       6.102   8.628  51.408  1.00 50.46          
ATOM   1743  CG  HSD   224       5.612   7.376  52.070  1.00 52.48          
ATOM   1744  ND1 HSD   224       5.705   6.134  51.476  1.00 53.25          
ATOM   1745  CD2 HSD   224       5.035   7.170  53.278  1.00 52.96          
ATOM   1746  CE1 HSD   224       5.207   5.219  52.288  1.00 52.93          
ATOM   1747  NE2 HSD   224       4.793   5.821  53.389  1.00 53.58          
ATOM   1748  N   GLY   225       6.922  12.046  51.652  1.00 48.30          
ATOM   1749  CA  GLY   225       7.965  12.995  51.318  1.00 48.19          
ATOM   1750  C   GLY   225       8.060  13.385  49.858  1.00 48.65          
ATOM   1751  O   GLY   225       9.127  13.797  49.398  1.00 48.46          
ATOM   1752  N   LEU   226       6.955  13.245  49.126  1.00 49.00          
ATOM   1753  CA  LEU   226       6.908  13.607  47.703  1.00 48.60          
ATOM   1754  C   LEU   226       7.306  15.064  47.518  1.00 48.18          
ATOM   1755  O   LEU   226       8.145  15.389  46.681  1.00 47.55          
ATOM   1756  CB  LEU   226       5.495  13.408  47.131  1.00 46.67          
ATOM   1757  CG  LEU   226       5.224  14.068  45.771  1.00 46.21          
ATOM   1758  CD1 LEU   226       6.161  13.498  44.722  1.00 44.40          
ATOM   1759  CD2 LEU   226       3.772  13.858  45.362  1.00 45.96          
ATOM   1760  N   PHE   227       6.690  15.939  48.303  1.00 48.68          
ATOM   1761  CA  PHE   227       6.985  17.353  48.209  1.00 49.66          
ATOM   1762  C   PHE   227       8.466  17.600  48.501  1.00 50.70          
ATOM   1763  O   PHE   227       9.099  18.414  47.833  1.00 51.23          
ATOM   1764  CB  PHE   227       6.100  18.141  49.178  1.00 49.58          
ATOM   1765  CG  PHE   227       6.176  19.632  49.000  1.00 49.04          
ATOM   1766  CD1 PHE   227       7.235  20.359  49.538  1.00 49.30          
ATOM   1767  CD2 PHE   227       5.205  20.306  48.266  1.00 49.29          
ATOM   1768  CE1 PHE   227       7.327  21.743  49.355  1.00 49.51          
ATOM   1769  CE2 PHE   227       5.285  21.687  48.077  1.00 49.75          
ATOM   1770  CZ  PHE   227       6.354  22.409  48.620  1.00 49.71          
ATOM   1771  N   ASN   228       9.027  16.894  49.480  1.00 50.89          
ATOM   1772  CA  ASN   228      10.435  17.082  49.808  1.00 51.21          
ATOM   1773  C   ASN   228      11.299  16.702  48.605  1.00 51.40          
ATOM   1774  O   ASN   228      12.339  17.312  48.347  1.00 50.59          
ATOM   1775  CB  ASN   228      10.834  16.227  51.009  1.00 52.09          
ATOM   1776  CG  ASN   228      12.219  16.566  51.521  1.00 53.59          
ATOM   1777  OD1 ASN   228      12.820  15.809  52.281  1.00 54.96          
ATOM   1778  ND2 ASN   228      12.733  17.718  51.109  1.00 55.01          
ATOM   1779  N   GLU   229      10.853  15.695  47.866  1.00 51.04          
ATOM   1780  CA  GLU   229      11.586  15.244  46.706  1.00 51.72          
ATOM   1781  C   GLU   229      11.588  16.311  45.614  1.00 52.23          
ATOM   1782  O   GLU   229      12.655  16.693  45.128  1.00 53.72          
ATOM   1783  CB  GLU   229      10.979  13.954  46.175  1.00 52.05          
ATOM   1784  CG  GLU   229      11.899  13.129  45.301  1.00 52.84          
ATOM   1785  CD  GLU   229      11.213  11.880  44.807  1.00 53.57          
ATOM   1786  OE1 GLU   229      10.385  11.998  43.877  1.00 54.71          
ATOM   1787  OE2 GLU   229      11.478  10.787  45.357  1.00 52.14          
ATOM   1788  N   VAL   230      10.411  16.805  45.229  1.00 51.22          
ATOM   1789  CA  VAL   230      10.349  17.821  44.184  1.00 50.77          
ATOM   1790  C   VAL   230      11.131  19.055  44.597  1.00 50.92          
ATOM   1791  O   VAL   230      11.509  19.868  43.758  1.00 50.86          
ATOM   1792  CB  VAL   230       8.906  18.250  43.857  1.00 49.81          
ATOM   1793  CG1 VAL   230       8.028  17.040  43.649  1.00 50.73          
ATOM   1794  CG2 VAL   230       8.371  19.127  44.939  1.00 51.11          
ATOM   1795  N   GLN   231      11.382  19.188  45.894  1.00 51.90          
ATOM   1796  CA  GLN   231      12.138  20.326  46.401  1.00 52.73          
ATOM   1797  C   GLN   231      13.605  20.151  46.074  1.00 52.44          
ATOM   1798  O   GLN   231      14.255  21.086  45.636  1.00 52.48          
ATOM   1799  CB  GLN   231      11.968  20.457  47.914  1.00 53.42          
ATOM   1800  CG  GLN   231      10.643  21.061  48.363  1.00 53.33          
ATOM   1801  CD  GLN   231      10.629  21.347  49.861  1.00 53.59          
ATOM   1802  OE1 GLN   231      10.758  20.433  50.678  1.00 52.65          
ATOM   1803  NE2 GLN   231      10.476  22.620  50.225  1.00 53.06          
ATOM   1804  N   HSD   232      14.119  18.949  46.296  1.00 52.83          
ATOM   1805  CA  HSD   232      15.516  18.668  46.014  1.00 54.59          
ATOM   1806  C   HSD   232      15.772  18.771  44.522  1.00 54.60          
ATOM   1807  O   HSD   232      16.822  19.255  44.092  1.00 55.63          
ATOM   1808  CB  HSD   232      15.883  17.271  46.496  1.00 57.52          
ATOM   1809  CG  HSD   232      15.827  17.112  47.986  1.00 61.50          
ATOM   1810  ND1 HSD   232      15.522  15.912  48.596  1.00 62.41          
ATOM   1811  CD2 HSD   232      16.055  17.995  48.991  1.00 62.97          
ATOM   1812  CE1 HSD   232      15.564  16.062  49.910  1.00 63.57          
ATOM   1813  NE2 HSD   232      15.886  17.316  50.176  1.00 63.76          
ATOM   1814  N   LEU   233      14.814  18.311  43.724  1.00 54.34          
ATOM   1815  CA  LEU   233      14.948  18.351  42.267  1.00 53.56          
ATOM   1816  C   LEU   233      14.915  19.773  41.744  1.00 53.10          
ATOM   1817  O   LEU   233      15.781  20.168  40.973  1.00 53.07          
ATOM   1818  CB  LEU   233      13.830  17.547  41.616  1.00 53.05          
ATOM   1819  CG  LEU   233      13.928  16.035  41.776  1.00 53.98          
ATOM   1820  CD1 LEU   233      12.601  15.396  41.410  1.00 54.57          
ATOM   1821  CD2 LEU   233      15.049  15.502  40.893  1.00 53.99          
ATOM   1822  N   VAL   234      13.908  20.533  42.160  1.00 53.72          
ATOM   1823  CA  VAL   234      13.772  21.911  41.720  1.00 54.50          
ATOM   1824  C   VAL   234      14.955  22.759  42.197  1.00 55.31          
ATOM   1825  O   VAL   234      15.336  23.719  41.538  1.00 55.74          
ATOM   1826  CB  VAL   234      12.433  22.518  42.204  1.00 53.90          
ATOM   1827  CG1 VAL   234      12.458  22.698  43.704  1.00 56.91          
ATOM   1828  CG2 VAL   234      12.178  23.828  41.514  1.00 54.67          
ATOM   1829  N   GLU   235      15.539  22.398  43.334  1.00 56.55          
ATOM   1830  CA  GLU   235      16.690  23.125  43.862  1.00 58.23          
ATOM   1831  C   GLU   235      17.933  22.818  43.029  1.00 58.14          
ATOM   1832  O   GLU   235      18.782  23.685  42.822  1.00 58.69          
ATOM   1833  CB  GLU   235      16.941  22.758  45.333  1.00 60.13          
ATOM   1834  CG  GLU   235      16.176  23.627  46.343  1.00 63.27          
ATOM   1835  CD  GLU   235      16.297  23.141  47.793  1.00 65.19          
ATOM   1836  OE1 GLU   235      15.981  23.935  48.716  1.00 64.07          
ATOM   1837  OE2 GLU   235      16.690  21.967  48.007  1.00 66.28          
ATOM   1838  N   GLN   236      18.039  21.584  42.548  1.00 57.92          
ATOM   1839  CA  GLN   236      19.172  21.193  41.718  1.00 58.19          
ATOM   1840  C   GLN   236      19.008  21.716  40.289  1.00 58.15          
ATOM   1841  O   GLN   236      19.696  21.276  39.366  1.00 58.41          
ATOM   1842  CB  GLN   236      19.319  19.675  41.714  1.00 57.21          
ATOM   1843  CG  GLN   236      19.913  19.154  42.992  1.00 59.59          
ATOM   1844  CD  GLN   236      19.697  17.669  43.162  1.00 62.56          
ATOM   1845  OE1 GLN   236      18.555  17.205  43.234  1.00 64.35          
ATOM   1846  NE2 GLN   236      20.791  16.909  43.237  1.00 62.86          
ATOM   1847  N   GLY   237      18.081  22.656  40.120  1.00 57.82          
ATOM   1848  CA  GLY   237      17.834  23.252  38.823  1.00 55.54          
ATOM   1849  C   GLY   237      17.242  22.339  37.777  1.00 55.47          
ATOM   1850  O   GLY   237      17.083  22.752  36.627  1.00 55.87          
ATOM   1851  N   PHE   238      16.909  21.108  38.150  1.00 54.70          
ATOM   1852  CA  PHE   238      16.333  20.175  37.186  1.00 54.43          
ATOM   1853  C   PHE   238      14.965  20.597  36.686  1.00 54.15          
ATOM   1854  O   PHE   238      14.288  19.833  36.016  1.00 54.72          
ATOM   1855  CB  PHE   238      16.248  18.776  37.778  1.00 55.06          
ATOM   1856  CG  PHE   238      17.564  18.088  37.871  1.00 55.44          
ATOM   1857  CD1 PHE   238      18.398  18.015  36.769  1.00 55.52          
ATOM   1858  CD2 PHE   238      17.956  17.473  39.050  1.00 57.40          
ATOM   1859  CE1 PHE   238      19.610  17.327  36.837  1.00 56.79          
ATOM   1860  CE2 PHE   238      19.170  16.778  39.135  1.00 58.19          
ATOM   1861  CZ  PHE   238      19.997  16.706  38.026  1.00 57.47          
ATOM   1862  N   GLU   239      14.561  21.814  37.019  1.00 54.78          
ATOM   1863  CA  GLU   239      13.286  22.357  36.580  1.00 55.30          
ATOM   1864  C   GLU   239      13.415  22.627  35.071  1.00 55.95          
ATOM   1865  O   GLU   239      14.525  22.618  34.540  1.00 56.90          
ATOM   1866  CB  GLU   239      13.040  23.654  37.338  1.00 56.17          
ATOM   1867  CG  GLU   239      11.688  24.276  37.127  1.00 58.62          
ATOM   1868  CD  GLU   239      11.557  25.627  37.821  1.00 60.91          
ATOM   1869  OE1 GLU   239      12.351  25.889  38.762  1.00 59.94          
ATOM   1870  OE2 GLU   239      10.650  26.411  37.436  1.00 60.79          
ATOM   1871  N   ALA   240      12.301  22.865  34.384  1.00 54.47          
ATOM   1872  CA  ALA   240      12.335  23.137  32.950  1.00 53.29          
ATOM   1873  C   ALA   240      12.608  21.881  32.109  1.00 52.86          
ATOM   1874  O   ALA   240      12.584  21.917  30.869  1.00 51.49          
ATOM   1875  CB  ALA   240      13.383  24.219  32.646  1.00 51.46          
ATOM   1876  N   SER   241      12.863  20.770  32.795  1.00 52.63          
ATOM   1877  CA  SER   241      13.141  19.487  32.150  1.00 52.57          
ATOM   1878  C   SER   241      11.859  18.723  31.846  1.00 52.68          
ATOM   1879  O   SER   241      10.835  18.927  32.496  1.00 53.04          
ATOM   1880  CB  SER   241      14.023  18.630  33.060  1.00 51.54          
ATOM   1881  OG  SER   241      15.177  19.335  33.450  1.00 50.84          
ATOM   1882  N   GLN   242      11.921  17.833  30.867  1.00 53.10          
ATOM   1883  CA  GLN   242      10.756  17.044  30.494  1.00 53.88          
ATOM   1884  C   GLN   242      10.242  16.263  31.687  1.00 54.11          
ATOM   1885  O   GLN   242       9.048  16.248  31.968  1.00 54.86          
ATOM   1886  CB  GLN   242      11.121  16.079  29.365  1.00 55.50          
ATOM   1887  CG  GLN   242      10.373  14.752  29.387  1.00 56.34          
ATOM   1888  CD  GLN   242      10.874  13.787  28.333  1.00 56.34          
ATOM   1889  OE1 GLN   242      12.054  13.449  28.295  1.00 56.46          
ATOM   1890  NE2 GLN   242       9.975  13.343  27.465  1.00 57.42          
ATOM   1891  N   SER   243      11.153  15.610  32.394  1.00 54.24          
ATOM   1892  CA  SER   243      10.773  14.819  33.554  1.00 53.83          
ATOM   1893  C   SER   243       9.962  15.619  34.578  1.00 54.07          
ATOM   1894  O   SER   243       8.988  15.111  35.121  1.00 53.71          
ATOM   1895  CB  SER   243      12.025  14.264  34.206  1.00 53.39          
ATOM   1896  OG  SER   243      12.933  15.318  34.435  1.00 54.65          
ATOM   1897  N   MET   244      10.358  16.866  34.835  1.00 54.91          
ATOM   1898  CA  MET   244       9.664  17.713  35.810  1.00 55.19          
ATOM   1899  C   MET   244       8.284  18.155  35.370  1.00 53.27          
ATOM   1900  O   MET   244       7.635  18.944  36.058  1.00 52.57          
ATOM   1901  CB  MET   244      10.485  18.962  36.112  1.00 60.45          
ATOM   1902  CG  MET   244      11.764  18.715  36.878  1.00 66.90          
ATOM   1903  SD  MET   244      11.481  18.227  38.722  1.00 76.91          
ATOM   1904  CE  MET   244      11.439  19.994  39.505  1.00 74.29          
ATOM   1905  N   GLN   245       7.845  17.657  34.218  1.00 52.02          
ATOM   1906  CA  GLN   245       6.538  18.002  33.662  1.00 50.21          
ATOM   1907  C   GLN   245       5.555  16.882  33.851  1.00 49.21          
ATOM   1908  O   GLN   245       4.385  17.019  33.509  1.00 49.73          
ATOM   1909  CB  GLN   245       6.667  18.312  32.173  1.00 49.10          
ATOM   1910  CG  GLN   245       7.278  19.652  31.894  1.00 48.85          
ATOM   1911  CD  GLN   245       6.407  20.759  32.420  1.00 49.81          
ATOM   1912  OE1 GLN   245       5.255  20.891  32.015  1.00 51.70          
ATOM   1913  NE2 GLN   245       6.944  21.564  33.330  1.00 50.84          
ATOM   1914  N   ALA   246       6.041  15.767  34.383  1.00 49.21          
ATOM   1915  CA  ALA   246       5.190  14.602  34.612  1.00 49.16          
ATOM   1916  C   ALA   246       4.235  14.858  35.766  1.00 48.33          
ATOM   1917  O   ALA   246       4.560  15.586  36.709  1.00 47.49          
ATOM   1918  CB  ALA   246       6.041  13.373  34.907  1.00 48.23          
ATOM   1919  N   ILE   247       3.053  14.257  35.684  1.00 47.65          
ATOM   1920  CA  ILE   247       2.060  14.423  36.725  1.00 46.43          
ATOM   1921  C   ILE   247       2.682  14.001  38.062  1.00 45.24          
ATOM   1922  O   ILE   247       3.232  12.906  38.193  1.00 43.81          
ATOM   1923  CB  ILE   247       0.783  13.592  36.405  1.00 46.72          
ATOM   1924  CG1 ILE   247       0.287  12.915  37.681  1.00 47.64          
ATOM   1925  CG2 ILE   247       1.049  12.611  35.247  1.00 46.66          
ATOM   1926  CD  ILE   247      -0.708  11.809  37.439  1.00 50.82          
ATOM   1927  N   GLY   248       2.611  14.896  39.040  1.00 44.32          
ATOM   1928  CA  GLY   248       3.194  14.618  40.338  1.00 44.63          
ATOM   1929  C   GLY   248       4.406  15.502  40.631  1.00 43.81          
ATOM   1930  O   GLY   248       4.998  15.439  41.706  1.00 43.85          
ATOM   1931  N   TYR   249       4.786  16.326  39.668  1.00 43.00          
ATOM   1932  CA  TYR   249       5.906  17.209  39.852  1.00 42.47          
ATOM   1933  C   TYR   249       5.543  18.571  39.321  1.00 44.75          
ATOM   1934  O   TYR   249       5.803  19.581  39.971  1.00 46.97          
ATOM   1935  CB  TYR   249       7.158  16.700  39.130  1.00 39.81          
ATOM   1936  CG  TYR   249       7.706  15.406  39.667  1.00 36.35          
ATOM   1937  CD1 TYR   249       7.136  14.201  39.319  1.00 35.98          
ATOM   1938  CD2 TYR   249       8.783  15.392  40.535  1.00 34.84          
ATOM   1939  CE1 TYR   249       7.625  13.006  39.818  1.00 36.42          
ATOM   1940  CE2 TYR   249       9.283  14.202  41.043  1.00 35.06          
ATOM   1941  CZ  TYR   249       8.700  13.011  40.676  1.00 35.44          
ATOM   1942  OH  TYR   249       9.197  11.819  41.146  1.00 35.17          
ATOM   1943  N   LYS   250       4.931  18.609  38.142  1.00 45.83          
ATOM   1944  CA  LYS   250       4.546  19.883  37.540  1.00 46.38          
ATOM   1945  C   LYS   250       3.497  20.619  38.381  1.00 46.13          
ATOM   1946  O   LYS   250       3.433  21.845  38.349  1.00 47.15          
ATOM   1947  CB  LYS   250       4.017  19.679  36.108  1.00 47.06          
ATOM   1948  CG  LYS   250       2.721  18.900  36.022  1.00 48.18          
ATOM   1949  CD  LYS   250       2.125  18.891  34.618  1.00 47.37          
ATOM   1950  CE  LYS   250       0.813  18.109  34.616  1.00 47.67          
ATOM   1951  NZ  LYS   250       0.166  18.049  33.283  1.00 48.34          
ATOM   1952  N   GLU   251       2.692  19.882  39.145  1.00 45.84          
ATOM   1953  CA  GLU   251       1.669  20.512  39.974  1.00 45.20          
ATOM   1954  C   GLU   251       2.257  21.083  41.245  1.00 43.71          
ATOM   1955  O   GLU   251       1.835  22.130  41.721  1.00 42.83          
ATOM   1956  CB  GLU   251       0.565  19.517  40.338  1.00 46.13          
ATOM   1957  CG  GLU   251      -0.155  18.934  39.135  1.00 48.53          
ATOM   1958  CD  GLU   251       0.410  17.596  38.709  1.00 49.88          
ATOM   1959  OE1 GLU   251       1.544  17.265  39.138  1.00 50.12          
ATOM   1960  OE2 GLU   251      -0.278  16.889  37.932  1.00 49.85          
ATOM   1961  N   LEU   252       3.245  20.390  41.788  1.00 43.53          
ATOM   1962  CA  LEU   252       3.886  20.831  43.012  1.00 42.57          
ATOM   1963  C   LEU   252       4.928  21.922  42.821  1.00 42.00          
ATOM   1964  O   LEU   252       5.227  22.648  43.756  1.00 42.30          
ATOM   1965  CB  LEU   252       4.512  19.635  43.736  1.00 41.74          
ATOM   1966  CG  LEU   252       3.547  18.511  44.150  1.00 41.92          
ATOM   1967  CD1 LEU   252       4.312  17.378  44.828  1.00 42.76          
ATOM   1968  CD2 LEU   252       2.494  19.048  45.086  1.00 40.89          
ATOM   1969  N   VAL   253       5.494  22.055  41.630  1.00 42.00          
ATOM   1970  CA  VAL   253       6.506  23.098  41.440  1.00 42.95          
ATOM   1971  C   VAL   253       5.957  24.484  41.772  1.00 44.10          
ATOM   1972  O   VAL   253       6.607  25.265  42.460  1.00 44.41          
ATOM   1973  CB  VAL   253       7.078  23.119  39.992  1.00 41.99          
ATOM   1974  CG1 VAL   253       8.115  24.221  39.854  1.00 39.96          
ATOM   1975  CG2 VAL   253       7.720  21.787  39.669  1.00 42.77          
ATOM   1976  N   PRO   254       4.743  24.805  41.291  1.00 45.20          
ATOM   1977  CA  PRO   254       4.124  26.111  41.551  1.00 45.81          
ATOM   1978  C   PRO   254       3.925  26.422  43.034  1.00 45.87          
ATOM   1979  O   PRO   254       4.113  27.558  43.471  1.00 46.34          
ATOM   1980  CB  PRO   254       2.789  26.018  40.804  1.00 45.36          
ATOM   1981  CG  PRO   254       3.108  25.114  39.670  1.00 45.40          
ATOM   1982  CD  PRO   254       3.917  24.032  40.348  1.00 46.25          
ATOM   1983  N   VAL   255       3.555  25.407  43.804  1.00 45.65          
ATOM   1984  CA  VAL   255       3.323  25.591  45.224  1.00 46.52          
ATOM   1985  C   VAL   255       4.634  25.881  45.971  1.00 45.46          
ATOM   1986  O   VAL   255       4.631  26.462  47.057  1.00 44.66          
ATOM   1987  CB  VAL   255       2.562  24.354  45.825  1.00 46.99          
ATOM   1988  CG1 VAL   255       3.439  23.133  45.793  1.00 48.49          
ATOM   1989  CG2 VAL   255       2.109  24.654  47.237  1.00 49.86          
ATOM   1990  N   ILE   256       5.751  25.507  45.362  1.00 45.49          
ATOM   1991  CA  ILE   256       7.056  25.745  45.954  1.00 46.29          
ATOM   1992  C   ILE   256       7.435  27.214  45.784  1.00 47.82          
ATOM   1993  O   ILE   256       8.270  27.754  46.516  1.00 48.39          
ATOM   1994  CB  ILE   256       8.130  24.897  45.280  1.00 46.02          
ATOM   1995  CG1 ILE   256       7.762  23.427  45.383  1.00 47.63          
ATOM   1996  CG2 ILE   256       9.468  25.123  45.943  1.00 46.15          
ATOM   1997  CD  ILE   256       8.770  22.513  44.697  1.00 47.88          
ATOM   1998  N   LYS   257       6.808  27.856  44.811  1.00 47.54          
ATOM   1999  CA  LYS   257       7.057  29.256  44.529  1.00 48.04          
ATOM   2000  C   LYS   257       6.095  30.144  45.315  1.00 47.94          
ATOM   2001  O   LYS   257       6.389  31.307  45.602  1.00 48.31          
ATOM   2002  CB  LYS   257       6.926  29.490  43.023  1.00 49.79          
ATOM   2003  CG  LYS   257       7.852  28.570  42.220  1.00 51.05          
ATOM   2004  CD  LYS   257       7.865  28.896  40.744  1.00 51.18          
ATOM   2005  CE  LYS   257       8.949  28.114  40.016  1.00 52.26          
ATOM   2006  NZ  LYS   257       8.908  28.350  38.537  1.00 51.23          
ATOM   2007  N   GLY   258       4.946  29.582  45.669  1.00 46.79          
ATOM   2008  CA  GLY   258       3.973  30.325  46.436  1.00 45.83          
ATOM   2009  C   GLY   258       2.921  30.953  45.554  1.00 45.01          
ATOM   2010  O   GLY   258       2.265  31.921  45.944  1.00 44.91          
ATOM   2011  N   ASN   259       2.756  30.414  44.356  1.00 43.60          
ATOM   2012  CA  ASN   259       1.757  30.948  43.445  1.00 43.75          
ATOM   2013  C   ASN   259       0.458  30.169  43.563  1.00 43.71          
ATOM   2014  O   ASN   259      -0.609  30.661  43.208  1.00 42.68          
ATOM   2015  CB  ASN   259       2.277  30.909  42.009  1.00 43.72          
ATOM   2016  CG  ASN   259       3.456  31.826  41.802  1.00 44.15          
ATOM   2017  OD1 ASN   259       4.545  31.383  41.428  1.00 45.04          
ATOM   2018  ND2 ASN   259       3.254  33.113  42.060  1.00 43.19          
ATOM   2019  N   ILE   260       0.550  28.954  44.081  1.00 43.37          
ATOM   2020  CA  ILE   260      -0.637  28.137  44.252  1.00 43.46          
ATOM   2021  C   ILE   260      -0.611  27.477  45.638  1.00 43.92          
ATOM   2022  O   ILE   260       0.465  27.206  46.190  1.00 42.74          
ATOM   2023  CB  ILE   260      -0.726  27.095  43.115  1.00 43.21          
ATOM   2024  CG1 ILE   260      -1.974  26.234  43.282  1.00 43.70          
ATOM   2025  CG2 ILE   260       0.541  26.255  43.068  1.00 43.86          
ATOM   2026  CD  ILE   260      -2.181  25.234  42.160  1.00 44.18          
ATOM   2027  N   SER   261      -1.789  27.245  46.219  1.00 44.15          
ATOM   2028  CA  SER   261      -1.874  26.646  47.560  1.00 44.65          
ATOM   2029  C   SER   261      -1.703  25.141  47.512  1.00 44.60          
ATOM   2030  O   SER   261      -2.022  24.509  46.516  1.00 44.23          
ATOM   2031  CB  SER   261      -3.218  26.984  48.215  1.00 43.24          
ATOM   2032  OG  SER   261      -4.290  26.404  47.507  1.00 43.70          
ATOM   2033  N   MET   262      -1.201  24.572  48.599  1.00 46.15          
ATOM   2034  CA  MET   262      -0.993  23.135  48.663  1.00 47.95          
ATOM   2035  C   MET   262      -2.303  22.393  48.419  1.00 46.17          
ATOM   2036  O   MET   262      -2.341  21.413  47.676  1.00 45.54          
ATOM   2037  CB  MET   262      -0.418  22.746  50.029  1.00 51.56          
ATOM   2038  CG  MET   262      -0.078  21.262  50.196  1.00 56.73          
ATOM   2039  SD  MET   262       1.519  20.694  49.227  1.00 68.54          
ATOM   2040  CE  MET   262       0.661  20.288  47.543  1.00 64.64          
ATOM   2041  N   GLU   263      -3.376  22.871  49.040  1.00 45.51          
ATOM   2042  CA  GLU   263      -4.690  22.247  48.899  1.00 45.04          
ATOM   2043  C   GLU   263      -5.118  22.133  47.447  1.00 44.37          
ATOM   2044  O   GLU   263      -5.347  21.035  46.935  1.00 42.41          
ATOM   2045  CB  GLU   263      -5.738  23.045  49.678  1.00 45.88          
ATOM   2046  CG  GLU   263      -5.523  23.008  51.187  1.00 48.51          
ATOM   2047  CD  GLU   263      -4.644  24.132  51.716  1.00 50.02          
ATOM   2048  OE1 GLU   263      -4.298  24.079  52.917  1.00 50.44          
ATOM   2049  OE2 GLU   263      -4.319  25.069  50.948  1.00 51.15          
ATOM   2050  N   ASN   264      -5.226  23.289  46.798  1.00 44.68          
ATOM   2051  CA  ASN   264      -5.613  23.378  45.397  1.00 44.86          
ATOM   2052  C   ASN   264      -4.731  22.509  44.490  1.00 44.40          
ATOM   2053  O   ASN   264      -5.232  21.786  43.621  1.00 44.99          
ATOM   2054  CB  ASN   264      -5.571  24.840  44.954  1.00 45.20          
ATOM   2055  CG  ASN   264      -6.725  25.644  45.526  1.00 47.47          
ATOM   2056  OD1 ASN   264      -6.823  26.848  45.318  1.00 47.36          
ATOM   2057  ND2 ASN   264      -7.620  24.967  46.247  1.00 49.46          
ATOM   2058  N   ALA   265      -3.422  22.574  44.707  1.00 43.68          
ATOM   2059  CA  ALA   265      -2.468  21.794  43.935  1.00 42.84          
ATOM   2060  C   ALA   265      -2.749  20.305  44.092  1.00 42.53          
ATOM   2061  O   ALA   265      -2.871  19.580  43.103  1.00 42.36          
ATOM   2062  CB  ALA   265      -1.052  22.109  44.390  1.00 42.55          
ATOM   2063  N   VAL   266      -2.843  19.841  45.331  1.00 42.41          
ATOM   2064  CA  VAL   266      -3.108  18.434  45.571  1.00 43.43          
ATOM   2065  C   VAL   266      -4.404  18.022  44.900  1.00 44.60          
ATOM   2066  O   VAL   266      -4.527  16.904  44.404  1.00 44.52          
ATOM   2067  CB  VAL   266      -3.202  18.130  47.074  1.00 44.20          
ATOM   2068  CG1 VAL   266      -3.556  16.660  47.287  1.00 42.88          
ATOM   2069  CG2 VAL   266      -1.875  18.457  47.741  1.00 43.74          
ATOM   2070  N   GLU   267      -5.373  18.931  44.890  1.00 46.48          
ATOM   2071  CA  GLU   267      -6.658  18.660  44.259  1.00 47.56          
ATOM   2072  C   GLU   267      -6.456  18.351  42.774  1.00 47.85          
ATOM   2073  O   GLU   267      -7.092  17.447  42.222  1.00 47.49          
ATOM   2074  CB  GLU   267      -7.572  19.865  44.396  1.00 49.81          
ATOM   2075  CG  GLU   267      -8.763  19.766  43.492  1.00 55.10          
ATOM   2076  CD  GLU   267     -10.067  19.881  44.229  1.00 58.36          
ATOM   2077  OE1 GLU   267     -10.443  21.026  44.578  1.00 60.03          
ATOM   2078  OE2 GLU   267     -10.697  18.825  44.483  1.00 60.12          
ATOM   2079  N   LYS   268      -5.566  19.113  42.135  1.00 47.95          
ATOM   2080  CA  LYS   268      -5.262  18.927  40.722  1.00 48.04          
ATOM   2081  C   LYS   268      -4.369  17.712  40.488  1.00 47.98          
ATOM   2082  O   LYS   268      -4.441  17.072  39.438  1.00 48.31          
ATOM   2083  CB  LYS   268      -4.604  20.187  40.154  1.00 47.51          
ATOM   2084  CG  LYS   268      -5.534  21.394  40.148  1.00 49.27          
ATOM   2085  CD  LYS   268      -4.978  22.558  39.331  1.00 50.77          
ATOM   2086  CE  LYS   268      -3.645  23.070  39.900  1.00 51.57          
ATOM   2087  NZ  LYS   268      -3.096  24.265  39.171  1.00 50.01          
ATOM   2088  N   LEU   269      -3.529  17.396  41.470  1.00 48.23          
ATOM   2089  CA  LEU   269      -2.643  16.242  41.371  1.00 47.71          
ATOM   2090  C   LEU   269      -3.442  14.928  41.365  1.00 47.84          
ATOM   2091  O   LEU   269      -3.144  14.018  40.591  1.00 47.71          
ATOM   2092  CB  LEU   269      -1.637  16.252  42.532  1.00 46.71          
ATOM   2093  CG  LEU   269      -0.758  15.019  42.762  1.00 45.77          
ATOM   2094  CD1 LEU   269      -0.011  14.668  41.499  1.00 46.01          
ATOM   2095  CD2 LEU   269       0.216  15.295  43.894  1.00 45.49          
ATOM   2096  N   LYS   270      -4.456  14.827  42.221  1.00 47.27          
ATOM   2097  CA  LYS   270      -5.276  13.617  42.276  1.00 47.21          
ATOM   2098  C   LYS   270      -6.162  13.535  41.038  1.00 47.74          
ATOM   2099  O   LYS   270      -6.550  12.448  40.614  1.00 47.84          
ATOM   2100  CB  LYS   270      -6.160  13.615  43.523  1.00 46.87          
ATOM   2101  CG  LYS   270      -5.398  13.685  44.847  1.00 45.75          
ATOM   2102  CD  LYS   270      -6.354  13.642  46.036  1.00 43.37          
ATOM   2103  CE  LYS   270      -5.619  13.777  47.346  1.00 42.55          
ATOM   2104  NZ  LYS   270      -6.516  13.481  48.479  1.00 42.55          
ATOM   2105  N   GLN   271      -6.491  14.689  40.466  1.00 47.50          
ATOM   2106  CA  GLN   271      -7.318  14.706  39.279  1.00 47.55          
ATOM   2107  C   GLN   271      -6.498  14.205  38.090  1.00 46.89          
ATOM   2108  O   GLN   271      -6.837  13.186  37.493  1.00 48.08          
ATOM   2109  CB  GLN   271      -7.846  16.116  39.008  1.00 50.10          
ATOM   2110  CG  GLN   271      -9.040  16.129  38.072  1.00 51.28          
ATOM   2111  CD  GLN   271      -9.270  17.471  37.406  1.00 51.63          
ATOM   2112  OE1 GLN   271     -10.281  17.664  36.729  1.00 51.74          
ATOM   2113  NE2 GLN   271      -8.332  18.401  37.585  1.00 51.56          
ATOM   2114  N   HSD   272      -5.418  14.908  37.746  1.00 45.28          
ATOM   2115  CA  HSD   272      -4.553  14.493  36.629  1.00 42.45          
ATOM   2116  C   HSD   272      -4.225  13.007  36.753  1.00 40.81          
ATOM   2117  O   HSD   272      -4.041  12.325  35.754  1.00 39.84          
ATOM   2118  CB  HSD   272      -3.221  15.258  36.637  1.00 43.50          
ATOM   2119  CG  HSD   272      -3.334  16.704  36.277  1.00 45.07          
ATOM   2120  ND1 HSD   272      -4.092  17.599  36.999  1.00 45.43          
ATOM   2121  CD2 HSD   272      -2.752  17.416  35.286  1.00 46.21          
ATOM   2122  CE1 HSD   272      -3.972  18.803  36.470  1.00 45.55          
ATOM   2123  NE2 HSD   272      -3.164  18.719  35.430  1.00 46.84          
ATOM   2124  N   SER   273      -4.126  12.519  37.989  1.00 38.20          
ATOM   2125  CA  SER   273      -3.803  11.130  38.213  1.00 35.52          
ATOM   2126  C   SER   273      -4.983  10.267  37.835  1.00 35.68          
ATOM   2127  O   SER   273      -4.811   9.191  37.264  1.00 35.30          
ATOM   2128  CB  SER   273      -3.412  10.895  39.668  1.00 35.90          
ATOM   2129  OG  SER   273      -2.188  11.530  39.993  1.00 32.29          
ATOM   2130  N   ARG   274      -6.187  10.727  38.149  1.00 35.75          
ATOM   2131  CA  ARG   274      -7.390   9.969  37.802  1.00 36.75          
ATOM   2132  C   ARG   274      -7.588   9.937  36.285  1.00 37.28          
ATOM   2133  O   ARG   274      -7.869   8.888  35.722  1.00 38.52          
ATOM   2134  CB  ARG   274      -8.637  10.580  38.459  1.00 36.95          
ATOM   2135  CG  ARG   274      -8.698  10.466  39.974  1.00 36.82          
ATOM   2136  CD  ARG   274     -10.054  10.929  40.488  1.00 36.70          
ATOM   2137  NE  ARG   274     -10.274  12.356  40.263  1.00 38.35          
ATOM   2138  CZ  ARG   274     -10.032  13.306  41.167  1.00 38.14          
ATOM   2139  NH1 ARG   274      -9.561  12.981  42.363  1.00 36.22          
ATOM   2140  NH2 ARG   274     -10.264  14.582  40.878  1.00 37.03          
ATOM   2141  N   GLN   275      -7.443  11.086  35.629  1.00 38.05          
ATOM   2142  CA  GLN   275      -7.617  11.169  34.183  1.00 38.52          
ATOM   2143  C   GLN   275      -6.583  10.312  33.478  1.00 38.01          
ATOM   2144  O   GLN   275      -6.896   9.574  32.543  1.00 39.39          
ATOM   2145  CB  GLN   275      -7.474  12.608  33.709  1.00 40.25          
ATOM   2146  CG  GLN   275      -8.511  13.556  34.284  1.00 43.98          
ATOM   2147  CD  GLN   275      -8.149  15.020  34.056  1.00 46.35          
ATOM   2148  OE1 GLN   275      -7.853  15.427  32.936  1.00 48.91          
ATOM   2149  NE2 GLN   275      -8.177  15.816  35.123  1.00 47.14          
ATOM   2150  N   TYR   276      -5.344  10.411  33.934  1.00 36.36          
ATOM   2151  CA  TYR   276      -4.262   9.650  33.344  1.00 35.31          
ATOM   2152  C   TYR   276      -4.531   8.157  33.426  1.00 34.41          
ATOM   2153  O   TYR   276      -4.445   7.449  32.430  1.00 33.63          
ATOM   2154  CB  TYR   276      -2.950  10.005  34.050  1.00 35.75          
ATOM   2155  CG  TYR   276      -1.751   9.236  33.559  1.00 36.20          
ATOM   2156  CD1 TYR   276      -1.464   7.966  34.054  1.00 36.58          
ATOM   2157  CD2 TYR   276      -0.903   9.778  32.600  1.00 35.33          
ATOM   2158  CE1 TYR   276      -0.358   7.257  33.609  1.00 37.87          
ATOM   2159  CE2 TYR   276       0.202   9.082  32.142  1.00 36.76          
ATOM   2160  CZ  TYR   276       0.473   7.820  32.654  1.00 38.26          
ATOM   2161  OH  TYR   276       1.582   7.126  32.231  1.00 40.41          
ATOM   2162  N   ALA   277      -4.858   7.685  34.619  1.00 34.89          
ATOM   2163  CA  ALA   277      -5.136   6.275  34.828  1.00 36.30          
ATOM   2164  C   ALA   277      -6.255   5.819  33.905  1.00 38.00          
ATOM   2165  O   ALA   277      -6.225   4.706  33.376  1.00 36.91          
ATOM   2166  CB  ALA   277      -5.530   6.026  36.276  1.00 35.53          
ATOM   2167  N   LYS   278      -7.251   6.679  33.723  1.00 40.20          
ATOM   2168  CA  LYS   278      -8.383   6.359  32.865  1.00 42.32          
ATOM   2169  C   LYS   278      -7.949   6.259  31.429  1.00 43.49          
ATOM   2170  O   LYS   278      -8.225   5.263  30.762  1.00 44.62          
ATOM   2171  CB  LYS   278      -9.477   7.419  32.990  1.00 43.95          
ATOM   2172  CG  LYS   278     -10.619   7.243  31.998  1.00 46.27          
ATOM   2173  CD  LYS   278     -11.846   8.053  32.398  1.00 49.97          
ATOM   2174  CE  LYS   278     -13.027   7.776  31.461  1.00 51.38          
ATOM   2175  NZ  LYS   278     -14.346   8.206  32.045  1.00 53.63          
ATOM   2176  N   ARG   279      -7.271   7.296  30.948  1.00 44.33          
ATOM   2177  CA  ARG   279      -6.798   7.321  29.561  1.00 45.32          
ATOM   2178  C   ARG   279      -5.950   6.079  29.228  1.00 45.13          
ATOM   2179  O   ARG   279      -6.048   5.529  28.134  1.00 44.57          
ATOM   2180  CB  ARG   279      -6.008   8.619  29.301  1.00 47.62          
ATOM   2181  CG  ARG   279      -5.490   8.795  27.863  1.00 50.39          
ATOM   2182  CD  ARG   279      -5.468  10.270  27.446  1.00 53.84          
ATOM   2183  NE  ARG   279      -4.936  11.132  28.466  1.00 57.92          
ATOM   2184  CZ  ARG   279      -5.349  12.289  28.988  1.00 58.57          
ATOM   2185  NH1 ARG   279      -4.546  12.767  29.919  1.00 59.22          
ATOM   2186  NH2 ARG   279      -6.458  12.959  28.669  1.00 58.05          
ATOM   2187  N   GLN   280      -5.142   5.629  30.186  1.00 44.54          
ATOM   2188  CA  GLN   280      -4.299   4.466  29.979  1.00 42.49          
ATOM   2189  C   GLN   280      -5.092   3.179  29.965  1.00 42.31          
ATOM   2190  O   GLN   280      -4.725   2.219  29.298  1.00 42.76          
ATOM   2191  CB  GLN   280      -3.229   4.386  31.065  1.00 41.79          
ATOM   2192  CG  GLN   280      -1.842   4.200  30.515  1.00 42.04          
ATOM   2193  CD  GLN   280      -1.452   5.345  29.597  1.00 42.96          
ATOM   2194  OE1 GLN   280      -0.920   5.137  28.501  1.00 41.69          
ATOM   2195  NE2 GLN   280      -1.723   6.569  30.040  1.00 42.65          
ATOM   2196  N   LEU   281      -6.177   3.149  30.720  1.00 43.60          
ATOM   2197  CA  LEU   281      -7.005   1.954  30.795  1.00 44.86          
ATOM   2198  C   LEU   281      -7.760   1.866  29.474  1.00 46.02          
ATOM   2199  O   LEU   281      -7.866   0.798  28.873  1.00 46.62          
ATOM   2200  CB  LEU   281      -7.986   2.084  31.964  1.00 46.05          
ATOM   2201  CG  LEU   281      -8.521   0.834  32.659  1.00 47.29          
ATOM   2202  CD1 LEU   281      -9.210  -0.042  31.635  1.00 48.02          
ATOM   2203  CD2 LEU   281      -7.383   0.073  33.349  1.00 47.94          
ATOM   2204  N   THR   282      -8.259   3.012  29.018  1.00 46.51          
ATOM   2205  CA  THR   282      -9.011   3.086  27.779  1.00 46.62          
ATOM   2206  C   THR   282      -8.209   2.592  26.578  1.00 47.68          
ATOM   2207  O   THR   282      -8.715   1.818  25.766  1.00 48.50          
ATOM   2208  CB  THR   282      -9.477   4.525  27.521  1.00 46.54          
ATOM   2209  OG1 THR   282     -10.263   4.981  28.627  1.00 44.95          
ATOM   2210  CG2 THR   282     -10.313   4.591  26.265  1.00 48.15          
ATOM   2211  N   TRP   283      -6.960   3.041  26.478  1.00 49.10          
ATOM   2212  CA  TRP   283      -6.054   2.668  25.387  1.00 48.96          
ATOM   2213  C   TRP   283      -5.796   1.160  25.333  1.00 48.30          
ATOM   2214  O   TRP   283      -5.877   0.555  24.268  1.00 48.47          
ATOM   2215  CB  TRP   283      -4.710   3.386  25.551  1.00 50.31          
ATOM   2216  CG  TRP   283      -3.929   3.535  24.282  1.00 53.10          
ATOM   2217  CD1 TRP   283      -3.892   4.632  23.471  1.00 53.65          
ATOM   2218  CD2 TRP   283      -3.116   2.541  23.645  1.00 53.31          
ATOM   2219  NE1 TRP   283      -3.107   4.384  22.379  1.00 53.64          
ATOM   2220  CE2 TRP   283      -2.611   3.113  22.464  1.00 53.34          
ATOM   2221  CE3 TRP   283      -2.748   1.233  23.970  1.00 54.28          
ATOM   2222  CZ2 TRP   283      -1.788   2.417  21.588  1.00 55.15          
ATOM   2223  CZ3 TRP   283      -1.924   0.534  23.101  1.00 54.82          
ATOM   2224  CH2 TRP   283      -1.443   1.133  21.924  1.00 55.31          
ATOM   2225  N   PHE   284      -5.472   0.568  26.480  1.00 47.17          
ATOM   2226  CA  PHE   284      -5.194  -0.858  26.554  1.00 45.95          
ATOM   2227  C   PHE   284      -6.413  -1.712  26.276  1.00 46.16          
ATOM   2228  O   PHE   284      -6.318  -2.934  26.213  1.00 47.88          
ATOM   2229  CB  PHE   284      -4.607  -1.229  27.922  1.00 42.99          
ATOM   2230  CG  PHE   284      -3.119  -1.052  28.005  1.00 40.18          
ATOM   2231  CD1 PHE   284      -2.281  -1.783  27.178  1.00 38.71          
ATOM   2232  CD2 PHE   284      -2.555  -0.133  28.888  1.00 40.20          
ATOM   2233  CE1 PHE   284      -0.906  -1.610  27.230  1.00 38.81          
ATOM   2234  CE2 PHE   284      -1.174   0.054  28.951  1.00 38.51          
ATOM   2235  CZ  PHE   284      -0.352  -0.684  28.118  1.00 39.99          
ATOM   2236  N   LYS   285      -7.569  -1.093  26.111  1.00 46.47          
ATOM   2237  CA  LYS   285      -8.747  -1.884  25.829  1.00 47.62          
ATOM   2238  C   LYS   285      -9.215  -1.695  24.405  1.00 48.73          
ATOM   2239  O   LYS   285      -9.863  -2.571  23.847  1.00 49.63          
ATOM   2240  CB  LYS   285      -9.860  -1.528  26.789  1.00 47.52          
ATOM   2241  CG  LYS   285      -9.475  -1.804  28.215  1.00 49.56          
ATOM   2242  CD  LYS   285     -10.683  -1.752  29.140  1.00 51.10          
ATOM   2243  CE  LYS   285     -11.397  -3.104  29.245  1.00 51.69          
ATOM   2244  NZ  LYS   285     -10.700  -4.102  30.117  1.00 51.69          
ATOM   2245  N   ASN   286      -8.868  -0.558  23.814  1.00 49.04          
ATOM   2246  CA  ASN   286      -9.260  -0.247  22.453  1.00 50.46          
ATOM   2247  C   ASN   286      -8.121  -0.338  21.443  1.00 50.96          
ATOM   2248  O   ASN   286      -8.236   0.171  20.333  1.00 51.83          
ATOM   2249  CB  ASN   286      -9.847   1.164  22.407  1.00 52.33          
ATOM   2250  CG  ASN   286     -11.065   1.320  23.282  1.00 54.53          
ATOM   2251  OD1 ASN   286     -11.519   2.441  23.545  1.00 55.13          
ATOM   2252  ND2 ASN   286     -11.610   0.197  23.740  1.00 55.49          
ATOM   2253  N   LYS   287      -7.020  -0.974  21.809  1.00 49.95          
ATOM   2254  CA  LYS   287      -5.896  -1.048  20.890  1.00 50.52          
ATOM   2255  C   LYS   287      -5.153  -2.352  21.034  1.00 51.97          
ATOM   2256  O   LYS   287      -4.591  -2.877  20.072  1.00 52.44          
ATOM   2257  CB  LYS   287      -4.909   0.091  21.161  1.00 50.17          
ATOM   2258  CG  LYS   287      -5.476   1.494  21.098  1.00 48.41          
ATOM   2259  CD  LYS   287      -5.691   1.932  19.669  1.00 49.42          
ATOM   2260  CE  LYS   287      -5.956   3.434  19.586  1.00 50.59          
ATOM   2261  NZ  LYS   287      -4.832   4.254  20.139  1.00 50.42          
ATOM   2262  N   MET   288      -5.140  -2.869  22.252  1.00 54.12          
ATOM   2263  CA  MET   288      -4.431  -4.106  22.540  1.00 56.02          
ATOM   2264  C   MET   288      -5.382  -5.213  22.882  1.00 54.23          
ATOM   2265  O   MET   288      -6.522  -4.988  23.288  1.00 53.68          
ATOM   2266  CB  MET   288      -3.501  -3.926  23.735  1.00 61.19          
ATOM   2267  CG  MET   288      -2.671  -2.667  23.730  1.00 67.84          
ATOM   2268  SD  MET   288      -1.138  -2.799  22.617  1.00 79.05          
ATOM   2269  CE  MET   288       0.044  -3.697  23.862  1.00 75.12          
ATOM   2270  N   ASN   289      -4.886  -6.422  22.726  1.00 53.34          
ATOM   2271  CA  ASN   289      -5.667  -7.579  23.057  1.00 53.29          
ATOM   2272  C   ASN   289      -5.017  -8.084  24.333  1.00 50.83          
ATOM   2273  O   ASN   289      -4.131  -8.932  24.302  1.00 49.74          
ATOM   2274  CB  ASN   289      -5.564  -8.625  21.953  1.00 56.36          
ATOM   2275  CG  ASN   289      -6.458  -9.808  22.210  1.00 58.29          
ATOM   2276  OD1 ASN   289      -7.680  -9.659  22.324  1.00 58.96          
ATOM   2277  ND2 ASN   289      -5.863 -10.994  22.316  1.00 59.23          
ATOM   2278  N   VAL   290      -5.446  -7.523  25.453  1.00 48.80          
ATOM   2279  CA  VAL   290      -4.910  -7.887  26.751  1.00 47.23          
ATOM   2280  C   VAL   290      -5.792  -8.891  27.489  1.00 45.86          
ATOM   2281  O   VAL   290      -7.021  -8.836  27.398  1.00 44.14          
ATOM   2282  CB  VAL   290      -4.785  -6.651  27.664  1.00 46.63          
ATOM   2283  CG1 VAL   290      -4.015  -7.007  28.914  1.00 46.42          
ATOM   2284  CG2 VAL   290      -4.128  -5.517  26.915  1.00 46.08          
ATOM   2285  N   HSD   291      -5.153  -9.801  28.228  1.00 45.26          
ATOM   2286  CA  HSD   291      -5.853 -10.808  29.039  1.00 43.68          
ATOM   2287  C   HSD   291      -5.984 -10.136  30.408  1.00 41.95          
ATOM   2288  O   HSD   291      -5.090 -10.212  31.242  1.00 41.42          
ATOM   2289  CB  HSD   291      -5.017 -12.093  29.139  1.00 45.12          
ATOM   2290  CG  HSD   291      -5.728 -13.236  29.801  1.00 47.50          
ATOM   2291  ND1 HSD   291      -6.067 -13.231  31.137  1.00 49.19          
ATOM   2292  CD2 HSD   291      -6.129 -14.434  29.315  1.00 48.36          
ATOM   2293  CE1 HSD   291      -6.643 -14.379  31.450  1.00 48.95          
ATOM   2294  NE2 HSD   291      -6.692 -15.126  30.362  1.00 49.58          
ATOM   2295  N   TRP   292      -7.105  -9.462  30.613  1.00 40.90          
ATOM   2296  CA  TRP   292      -7.368  -8.742  31.843  1.00 40.61          
ATOM   2297  C   TRP   292      -7.686  -9.607  33.055  1.00 40.95          
ATOM   2298  O   TRP   292      -8.454 -10.557  32.958  1.00 41.63          
ATOM   2299  CB  TRP   292      -8.526  -7.771  31.636  1.00 40.25          
ATOM   2300  CG  TRP   292      -8.274  -6.779  30.563  1.00 39.85          
ATOM   2301  CD1 TRP   292      -8.661  -6.855  29.260  1.00 38.13          
ATOM   2302  CD2 TRP   292      -7.531  -5.564  30.696  1.00 40.33          
ATOM   2303  NE1 TRP   292      -8.205  -5.752  28.571  1.00 39.14          
ATOM   2304  CE2 TRP   292      -7.509  -4.945  29.429  1.00 40.04          
ATOM   2305  CE3 TRP   292      -6.886  -4.937  31.769  1.00 40.44          
ATOM   2306  CZ2 TRP   292      -6.859  -3.733  29.200  1.00 40.75          
ATOM   2307  CZ3 TRP   292      -6.241  -3.732  31.548  1.00 40.21          
ATOM   2308  CH2 TRP   292      -6.234  -3.139  30.268  1.00 42.10          
ATOM   2309  N   LEU   293      -7.089  -9.257  34.196  1.00 41.00          
ATOM   2310  CA  LEU   293      -7.307  -9.933  35.475  1.00 40.14          
ATOM   2311  C   LEU   293      -8.026  -8.905  36.313  1.00 40.38          
ATOM   2312  O   LEU   293      -7.472  -7.843  36.581  1.00 40.60          
ATOM   2313  CB  LEU   293      -5.984 -10.274  36.154  1.00 38.82          
ATOM   2314  CG  LEU   293      -5.110 -11.199  35.326  1.00 39.72          
ATOM   2315  CD1 LEU   293      -3.797 -11.494  36.031  1.00 38.67          
ATOM   2316  CD2 LEU   293      -5.895 -12.473  35.064  1.00 40.48          
ATOM   2317  N   ASN   294      -9.250  -9.211  36.730  1.00 42.06          
ATOM   2318  CA  ASN   294     -10.041  -8.275  37.536  1.00 42.99          
ATOM   2319  C   ASN   294      -9.539  -8.244  38.994  1.00 42.40          
ATOM   2320  O   ASN   294      -9.800  -9.147  39.767  1.00 43.13          
ATOM   2321  CB  ASN   294     -11.521  -8.682  37.457  1.00 43.12          
ATOM   2322  CG  ASN   294     -12.457  -7.637  38.043  1.00 43.42          
ATOM   2323  OD1 ASN   294     -13.669  -7.699  37.821  1.00 44.84          
ATOM   2324  ND2 ASN   294     -11.906  -6.680  38.800  1.00 41.98          
ATOM   2325  N   LYS   295      -8.811  -7.194  39.348  1.00 43.13          
ATOM   2326  CA  LYS   295      -8.253  -7.047  40.677  1.00 44.01          
ATOM   2327  C   LYS   295      -9.313  -7.034  41.774  1.00 47.25          
ATOM   2328  O   LYS   295      -9.015  -7.299  42.942  1.00 48.02          
ATOM   2329  CB  LYS   295      -7.446  -5.766  40.753  1.00 42.24          
ATOM   2330  CG  LYS   295      -6.686  -5.590  42.016  1.00 42.84          
ATOM   2331  CD  LYS   295      -6.654  -4.138  42.427  1.00 41.97          
ATOM   2332  CE  LYS   295      -5.265  -3.736  42.874  1.00 42.08          
ATOM   2333  NZ  LYS   295      -4.617  -4.779  43.697  1.00 40.12          
ATOM   2334  N   GLU   296     -10.554  -6.736  41.414  1.00 49.88          
ATOM   2335  CA  GLU   296     -11.635  -6.700  42.395  1.00 52.31          
ATOM   2336  C   GLU   296     -12.243  -8.072  42.657  1.00 52.26          
ATOM   2337  O   GLU   296     -13.304  -8.179  43.273  1.00 53.05          
ATOM   2338  CB  GLU   296     -12.728  -5.742  41.914  1.00 54.20          
ATOM   2339  CG  GLU   296     -12.342  -4.282  41.971  1.00 57.99          
ATOM   2340  CD  GLU   296     -13.383  -3.378  41.337  1.00 60.64          
ATOM   2341  OE1 GLU   296     -13.255  -2.139  41.457  1.00 62.59          
ATOM   2342  OE2 GLU   296     -14.328  -3.905  40.710  1.00 60.61          
ATOM   2343  N   ARG   297     -11.552  -9.115  42.213  1.00 52.15          
ATOM   2344  CA  ARG   297     -12.045 -10.478  42.350  1.00 52.31          
ATOM   2345  C   ARG   297     -10.908 -11.491  42.500  1.00 50.64          
ATOM   2346  O   ARG   297     -11.123 -12.649  42.850  1.00 49.87          
ATOM   2347  CB  ARG   297     -12.922 -10.796  41.124  1.00 53.68          
ATOM   2348  CG  ARG   297     -13.339 -12.235  40.948  1.00 58.16          
ATOM   2349  CD  ARG   297     -12.319 -12.955  40.102  1.00 62.33          
ATOM   2350  NE  ARG   297     -12.864 -14.119  39.483  1.00 67.18          
ATOM   2351  CZ  ARG   297     -12.451 -15.380  39.413  1.00 69.01          
ATOM   2352  NH1 ARG   297     -11.343 -15.881  39.961  1.00 68.90          
ATOM   2353  NH2 ARG   297     -13.246 -16.161  38.703  1.00 69.75          
ATOM   2354  N   MET   298      -9.693 -11.038  42.250  1.00 49.65          
ATOM   2355  CA  MET   298      -8.541 -11.903  42.356  1.00 50.50          
ATOM   2356  C   MET   298      -7.472 -11.290  43.238  1.00 48.11          
ATOM   2357  O   MET   298      -7.401 -10.075  43.404  1.00 47.23          
ATOM   2358  CB  MET   298      -7.949 -12.163  40.986  1.00 56.16          
ATOM   2359  CG  MET   298      -8.803 -13.028  40.098  1.00 64.13          
ATOM   2360  SD  MET   298      -7.976 -13.256  38.354  1.00 73.14          
ATOM   2361  CE  MET   298      -9.250 -12.214  37.289  1.00 70.76          
ATOM   2362  N   SER   299      -6.617 -12.143  43.776  1.00 44.79          
ATOM   2363  CA  SER   299      -5.559 -11.700  44.652  1.00 43.78          
ATOM   2364  C   SER   299      -4.202 -11.928  44.027  1.00 43.59          
ATOM   2365  O   SER   299      -4.092 -12.631  43.038  1.00 44.01          
ATOM   2366  CB  SER   299      -5.630 -12.478  45.948  1.00 43.01          
ATOM   2367  OG  SER   299      -5.428 -13.850  45.693  1.00 38.72          
ATOM   2368  N   LEU   300      -3.164 -11.360  44.631  1.00 45.42          
ATOM   2369  CA  LEU   300      -1.813 -11.519  44.113  1.00 46.46          
ATOM   2370  C   LEU   300      -1.527 -12.981  43.790  1.00 46.29          
ATOM   2371  O   LEU   300      -0.977 -13.281  42.736  1.00 47.27          
ATOM   2372  CB  LEU   300      -0.793 -10.992  45.119  1.00 46.38          
ATOM   2373  CG  LEU   300       0.675 -11.080  44.682  1.00 47.84          
ATOM   2374  CD1 LEU   300       0.876 -10.362  43.352  1.00 45.68          
ATOM   2375  CD2 LEU   300       1.578 -10.470  45.764  1.00 48.95          
ATOM   2376  N   GLN   301      -1.914 -13.884  44.686  1.00 45.54          
ATOM   2377  CA  GLN   301      -1.695 -15.308  44.478  1.00 46.12          
ATOM   2378  C   GLN   301      -2.615 -15.887  43.416  1.00 47.69          
ATOM   2379  O   GLN   301      -2.218 -16.753  42.641  1.00 47.50          
ATOM   2380  CB  GLN   301      -1.924 -16.082  45.763  1.00 46.17          
ATOM   2381  CG  GLN   301      -1.622 -17.564  45.643  1.00 46.12          
ATOM   2382  CD  GLN   301      -0.136 -17.838  45.601  1.00 45.52          
ATOM   2383  OE1 GLN   301       0.572 -17.307  44.754  1.00 44.36          
ATOM   2384  NE2 GLN   301       0.346 -18.671  46.524  1.00 45.99          
ATOM   2385  N   MET   302      -3.861 -15.439  43.399  1.00 49.31          
ATOM   2386  CA  MET   302      -4.797 -15.938  42.409  1.00 51.32          
ATOM   2387  C   MET   302      -4.385 -15.528  41.006  1.00 52.45          
ATOM   2388  O   MET   302      -4.563 -16.285  40.061  1.00 52.64          
ATOM   2389  CB  MET   302      -6.200 -15.436  42.704  1.00 52.89          
ATOM   2390  CG  MET   302      -6.855 -16.153  43.851  1.00 57.45          
ATOM   2391  SD  MET   302      -8.378 -15.173  44.471  1.00 62.65          
ATOM   2392  CE  MET   302      -9.628 -15.560  43.052  1.00 62.89          
ATOM   2393  N   MET   303      -3.845 -14.325  40.867  1.00 53.09          
ATOM   2394  CA  MET   303      -3.406 -13.857  39.571  1.00 53.97          
ATOM   2395  C   MET   303      -2.217 -14.696  39.122  1.00 52.85          
ATOM   2396  O   MET   303      -2.169 -15.134  37.982  1.00 52.25          
ATOM   2397  CB  MET   303      -2.999 -12.391  39.643  1.00 57.76          
ATOM   2398  CG  MET   303      -4.109 -11.452  40.071  1.00 63.73          
ATOM   2399  SD  MET   303      -3.617  -9.563  39.822  1.00 70.50          
ATOM   2400  CE  MET   303      -3.534  -8.998  41.681  1.00 70.66          
ATOM   2401  N   LEU   304      -1.267 -14.928  40.027  1.00 52.23          
ATOM   2402  CA  LEU   304      -0.086 -15.718  39.706  1.00 51.04          
ATOM   2403  C   LEU   304      -0.471 -17.097  39.207  1.00 51.98          
ATOM   2404  O   LEU   304       0.309 -17.748  38.525  1.00 53.52          
ATOM   2405  CB  LEU   304       0.837 -15.844  40.922  1.00 49.65          
ATOM   2406  CG  LEU   304       2.130 -16.655  40.773  1.00 47.72          
ATOM   2407  CD1 LEU   304       2.999 -16.079  39.681  1.00 46.43          
ATOM   2408  CD2 LEU   304       2.876 -16.643  42.087  1.00 46.76          
ATOM   2409  N   ASP   305      -1.671 -17.551  39.540  1.00 53.53          
ATOM   2410  CA  ASP   305      -2.109 -18.859  39.081  1.00 54.88          
ATOM   2411  C   ASP   305      -2.729 -18.774  37.718  1.00 54.61          
ATOM   2412  O   ASP   305      -2.629 -19.709  36.933  1.00 55.30          
ATOM   2413  CB  ASP   305      -3.099 -19.477  40.055  1.00 56.92          
ATOM   2414  CG  ASP   305      -2.415 -20.011  41.284  1.00 60.74          
ATOM   2415  OD1 ASP   305      -1.398 -20.735  41.116  1.00 62.71          
ATOM   2416  OD2 ASP   305      -2.884 -19.724  42.412  1.00 61.25          
ATOM   2417  N   GLU   306      -3.393 -17.660  37.445  1.00 55.22          
ATOM   2418  CA  GLU   306      -4.012 -17.454  36.147  1.00 55.87          
ATOM   2419  C   GLU   306      -2.905 -17.445  35.105  1.00 55.93          
ATOM   2420  O   GLU   306      -3.042 -18.029  34.029  1.00 56.27          
ATOM   2421  CB  GLU   306      -4.748 -16.122  36.124  1.00 57.59          
ATOM   2422  CG  GLU   306      -6.257 -16.253  36.166  1.00 61.17          
ATOM   2423  CD  GLU   306      -6.816 -16.815  34.885  1.00 62.73          
ATOM   2424  OE1 GLU   306      -6.546 -16.211  33.817  1.00 63.01          
ATOM   2425  OE2 GLU   306      -7.521 -17.852  34.950  1.00 64.03          
ATOM   2426  N   ILE   307      -1.805 -16.778  35.443  1.00 55.01          
ATOM   2427  CA  ILE   307      -0.650 -16.667  34.563  1.00 54.51          
ATOM   2428  C   ILE   307       0.085 -17.996  34.460  1.00 54.74          
ATOM   2429  O   ILE   307       0.626 -18.335  33.411  1.00 53.61          
ATOM   2430  CB  ILE   307       0.339 -15.581  35.081  1.00 53.45          
ATOM   2431  CG1 ILE   307      -0.316 -14.207  35.000  1.00 53.10          
ATOM   2432  CG2 ILE   307       1.616 -15.576  34.253  1.00 53.14          
ATOM   2433  CD  ILE   307       0.533 -13.103  35.547  1.00 51.89          
ATOM   2434  N   THR   308       0.094 -18.752  35.551  1.00 55.72          
ATOM   2435  CA  THR   308       0.789 -20.028  35.573  1.00 57.22          
ATOM   2436  C   THR   308       0.082 -21.019  34.656  1.00 57.78          
ATOM   2437  O   THR   308       0.712 -21.883  34.057  1.00 58.79          
ATOM   2438  CB  THR   308       0.891 -20.562  37.028  1.00 57.17          
ATOM   2439  OG1 THR   308       2.063 -21.375  37.156  1.00 57.44          
ATOM   2440  CG2 THR   308      -0.331 -21.372  37.397  1.00 58.77          
ATOM   2441  N   THR   309      -1.228 -20.869  34.523  1.00 58.23          
ATOM   2442  CA  THR   309      -2.000 -21.748  33.664  1.00 58.17          
ATOM   2443  C   THR   309      -1.745 -21.379  32.214  1.00 57.88          
ATOM   2444  O   THR   309      -1.687 -22.234  31.336  1.00 57.72          
ATOM   2445  CB  THR   309      -3.494 -21.600  33.955  1.00 59.17          
ATOM   2446  OG1 THR   309      -3.746 -21.966  35.317  1.00 59.29          
ATOM   2447  CG2 THR   309      -4.319 -22.476  33.022  1.00 59.28          
ATOM   2448  N   GLN   310      -1.598 -20.086  31.977  1.00 58.69          
ATOM   2449  CA  GLN   310      -1.347 -19.579  30.646  1.00 59.14          
ATOM   2450  C   GLN   310       0.065 -19.993  30.215  1.00 59.03          
ATOM   2451  O   GLN   310       0.296 -20.278  29.046  1.00 60.40          
ATOM   2452  CB  GLN   310      -1.489 -18.054  30.644  1.00 59.01          
ATOM   2453  CG  GLN   310      -2.202 -17.467  29.433  1.00 59.91          
ATOM   2454  CD  GLN   310      -3.696 -17.758  29.409  1.00 59.59          
ATOM   2455  OE1 GLN   310      -4.416 -17.289  28.525  1.00 58.69          
ATOM   2456  NE2 GLN   310      -4.168 -18.532  30.378  1.00 58.43          
ATOM   2457  N   ILE   311       1.003 -20.039  31.157  1.00 58.73          
ATOM   2458  CA  ILE   311       2.376 -20.425  30.835  1.00 59.08          
ATOM   2459  C   ILE   311       2.537 -21.934  30.661  1.00 61.03          
ATOM   2460  O   ILE   311       3.463 -22.396  29.979  1.00 60.61          
ATOM   2461  CB  ILE   311       3.380 -19.950  31.918  1.00 57.94          
ATOM   2462  CG1 ILE   311       3.404 -18.424  31.978  1.00 56.82          
ATOM   2463  CG2 ILE   311       4.774 -20.463  31.601  1.00 56.28          
ATOM   2464  CD  ILE   311       4.156 -17.877  33.159  1.00 56.25          
ATOM   2465  N   ASN   312       1.653 -22.710  31.286  1.00 61.99          
ATOM   2466  CA  ASN   312       1.719 -24.167  31.149  1.00 62.47          
ATOM   2467  C   ASN   312       1.166 -24.608  29.776  1.00 64.15          
ATOM   2468  O   ASN   312       0.939 -25.796  29.548  1.00 64.42          
ATOM   2469  CB  ASN   312       0.962 -24.876  32.295  1.00 61.80          
ATOM   2470  CG  ASN   312       1.702 -24.806  33.644  1.00 60.42          
ATOM   2471  OD1 ASN   312       2.883 -24.439  33.716  1.00 60.65          
ATOM   2472  ND2 ASN   312       1.003 -25.178  34.715  1.00 57.04          
ATOM   2473  N   LYS   313       0.990 -23.648  28.861  1.00 65.63          
ATOM   2474  CA  LYS   313       0.534 -23.932  27.492  1.00 67.33          
ATOM   2475  C   LYS   313       1.699 -23.596  26.559  1.00 68.99          
ATOM   2476  O   LYS   313       2.085 -24.409  25.706  1.00 68.36          
ATOM   2477  CB  LYS   313      -0.703 -23.097  27.105  1.00 66.37          
ATOM   2478  CG  LYS   313      -1.966 -23.428  27.904  1.00 65.14          
ATOM   2479  CD  LYS   313      -2.291 -24.916  27.830  1.00 64.60          
ATOM   2480  CE  LYS   313      -3.074 -25.401  29.056  1.00 63.38          
ATOM   2481  NZ  LYS   313      -3.453 -26.856  28.978  1.00 60.24          
ATOM   2482  N   ARG   314       2.267 -22.402  26.745  1.00 71.80          
ATOM   2483  CA  ARG   314       3.410 -21.937  25.948  1.00 74.39          
ATOM   2484  C   ARG   314       4.544 -22.959  26.006  1.00 75.46          
ATOM   2485  O   ARG   314       5.475 -22.905  25.199  1.00 76.09          
ATOM   2486  CB  ARG   314       3.946 -20.593  26.469  1.00 73.93          
ATOM   2487  CG  ARG   314       3.064 -19.379  26.240  1.00 74.77          
ATOM   2488  CD  ARG   314       2.928 -19.011  24.764  1.00 75.33          
ATOM   2489  NE  ARG   314       2.398 -17.655  24.608  1.00 75.78          
ATOM   2490  CZ  ARG   314       1.191 -17.260  25.009  1.00 75.66          
ATOM   2491  NH1 ARG   314       0.364 -18.116  25.589  1.00 76.05          
ATOM   2492  NH2 ARG   314       0.815 -15.997  24.857  1.00 75.79          
ATOM   2493  N   SER   315       4.472 -23.873  26.973  1.00 76.96          
ATOM   2494  CA  SER   315       5.494 -24.906  27.118  1.00 79.42          
ATOM   2495  C   SER   315       4.966 -26.290  26.719  1.00 80.34          
ATOM   2496  O   SER   315       5.372 -26.766  25.630  1.00 80.78          
ATOM   2497  CB  SER   315       6.047 -24.927  28.561  1.00 79.23          
ATOM   2498  OG  SER   315       5.022 -25.081  29.532  1.00 79.03          
END
