
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  159 ( 1336),  selected  159 , name 2fia_B
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 2fia_B.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      R      26           -
LGA    M     1_B      Y      27          3.147
LGA    K     2_B      H      28          2.140
LGA    I     3_B      L      29          1.822
LGA    R     4_B      R      30          1.724
LGA    V     5_B      P      31          1.781
LGA    A     6_B      P      32          1.267
LGA    D     7_B      R      33          1.597
LGA    E     8_B      R      34          1.961
LGA    K     9_B      N      35          1.491
LGA    E    10_B      D      36          2.435
LGA    L    11_B      G      37          2.381
LGA    P    12_B      A      38          2.261
LGA    M    13_B      A      39          1.752
LGA    I    14_B      I      40          1.729
LGA    L    15_B      H      41          1.906
LGA    Q    16_B      Q      42          1.700
LGA    F    17_B      L      43          0.997
LGA    L    18_B      V      44          1.118
LGA    T    19_B      S      45          1.511
LGA    E    20_B      E      46          1.320
LGA    V    21_B      C      47          0.784
LGA    K    22_B      P      48          1.546
LGA    A    23_B      -       -           -
LGA    Y    24_B      -       -           -
LGA    M    25_B      P      49          3.445
LGA    D    26_B      -       -           -
LGA    V    27_B      -       -           -
LGA    V    28_B      -       -           -
LGA    G    29_B      -       -           -
LGA    I    30_B      -       -           -
LGA    T    31_B      -       -           -
LGA    Q    32_B      -       -           -
LGA    W    33_B      L      50          3.033
LGA    T    34_B      D      51          3.466
LGA    K    35_B      -       -           -
LGA    D    36_B      -       -           -
LGA    Y    37_B      L      52          3.232
LGA    P    38_B      N      53          2.802
LGA    S    39_B      S      54          2.702
LGA    Q    40_B      L      55          1.614
LGA    G    41_B      Y      56          2.844
LGA    D    42_B      A      57          1.980
LGA    I    43_B      Y      58          0.763
LGA    Q    44_B      L      59          1.716
LGA    E    45_B      L      60          1.882
LGA    D    46_B      L      61          1.079
LGA    I    47_B      C      62          1.494
LGA    T    48_B      E      63          2.135
LGA    K    49_B      H      64          0.922
LGA    K    50_B      H      65          2.749
LGA    R    51_B      A      66          3.279
LGA    -       -      H      67           -
LGA    -       -      T      68           -
LGA    L    52_B      C      69          3.455
LGA    Y    53_B      V      70          1.848
LGA    L    54_B      V      71          0.804
LGA    L    55_B      A      72          1.383
LGA    V    56_B      E      73          1.310
LGA    H    57_B      S      74          2.675
LGA    -       -      P      75           -
LGA    E    58_B      G      76          5.153
LGA    E    59_B      G      77          2.184
LGA    M    60_B      R      78          1.414
LGA    I    61_B      I      79          1.323
LGA    F    62_B      D      80          2.625
LGA    S    63_B      G      81          1.136
LGA    M    64_B      F      82          0.558
LGA    A    65_B      V      83          0.786
LGA    T    66_B      S      84          1.245
LGA    F    67_B      A      85          2.002
LGA    C    68_B      Y      86          0.391
LGA    M    69_B      L      87          2.001
LGA    E    70_B      L      88          4.432
LGA    Q    71_B      P      89          5.427
LGA    E    72_B      T      90           #
LGA    Q    73_B      R      91          3.073
LGA    D    74_B      P      92          3.854
LGA    F    75_B      D      93          2.712
LGA    -       -      V      94           -
LGA    V    76_B      L      95          0.996
LGA    W    77_B      F      96          0.741
LGA    L    78_B      V      97          1.161
LGA    K    79_B      W      98          1.249
LGA    R    80_B      Q      99          0.939
LGA    F    81_B      V     100          1.248
LGA    A    82_B      A     101          1.316
LGA    T    83_B      V     102          1.179
LGA    S    84_B      H     103          1.169
LGA    P    85_B      S     104          1.772
LGA    N    86_B      R     105          1.984
LGA    Y    87_B      A     106          1.652
LGA    I    88_B      R     107          2.452
LGA    A    89_B      G     108          0.911
LGA    K    90_B      H     109          1.415
LGA    G    91_B      R     110          1.062
LGA    Y    92_B      L     111          1.696
LGA    G    93_B      G     112          1.672
LGA    S    94_B      R     113          1.616
LGA    L    95_B      A     114          1.072
LGA    L    96_B      M     115          0.714
LGA    F    97_B      L     116          1.169
LGA    H    98_B      G     117          1.019
LGA    E    99_B      H     118          0.953
LGA    L   100_B      I     119          1.233
LGA    E   101_B      L     120          1.709
LGA    K   102_B      E     121          1.595
LGA    R   103_B      R     122          2.121
LGA    -       -      Q     123           -
LGA    A   104_B      E     124           #
LGA    V   105_B      C     125          4.841
LGA    W   106_B      R     126          2.092
LGA    E   107_B      H     127          3.831
LGA    G   108_B      -       -           -
LGA    R   109_B      V     128          1.368
LGA    R   110_B      R     129          0.826
LGA    K   111_B      H     130          0.849
LGA    M   112_B      L     131          0.902
LGA    Y   113_B      E     132          0.680
LGA    A   114_B      T     133          1.089
LGA    Q   115_B      T     134          1.045
LGA    T   116_B      V     135          1.651
LGA    N   117_B      G     136          1.399
LGA    H   118_B      P     137          1.370
LGA    T   119_B      D     138          2.774
LGA    N   120_B      N     139          1.910
LGA    H   121_B      Q     140          2.084
LGA    R   122_B      A     141          1.602
LGA    M   123_B      S     142          0.537
LGA    I   124_B      R     143          1.952
LGA    R   125_B      R     144          2.181
LGA    F   126_B      T     145          1.829
LGA    F   127_B      F     146          1.891
LGA    E   128_B      A     147          2.452
LGA    S   129_B      G     148          2.747
LGA    K   130_B      L     149          2.323
LGA    G   131_B      A     150          2.153
LGA    F   132_B      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    -       -      H     156           -
LGA    T   133_B      V     157          1.908
LGA    K   134_B      S     158          3.203
LGA    I   135_B      E     159          2.895
LGA    H   136_B      Q     160          1.457
LGA    E   137_B      P     161          1.342
LGA    S   138_B      F     162          2.668
LGA    L   139_B      F     163          2.601
LGA    -       -      D     164           -
LGA    -       -      R     165           -
LGA    -       -      Q     166           -
LGA    Q   140_B      A     167          4.641
LGA    M   141_B      F     168          3.788
LGA    N   142_B      -       -           -
LGA    R   143_B      -       -           -
LGA    L   144_B      G     169           #
LGA    -       -      G     170           -
LGA    -       -      A     171           -
LGA    D   145_B      D     172          1.876
LGA    F   146_B      H     173          2.196
LGA    G   147_B      D     174          2.995
LGA    S   148_B      D     175          1.859
LGA    F   149_B      E     176          0.945
LGA    Y   150_B      M     177          1.604
LGA    L   151_B      L     178          0.908
LGA    Y   152_B      L     179          1.035
LGA    V   153_B      R     180          1.146
LGA    K   154_B      I     181          1.257
LGA    E   155_B      G     182          1.132
LGA    -       -      P     183           -
LGA    L   156_B      F     184          1.509
LGA    E   157_B      -       -           -
LGA    N   158_B      -       -           -
LGA    Q   159_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  159  159    5.0    138    2.12    10.87     63.811     6.219

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.180011 * X  +   0.315981 * Y  +  -0.931532 * Z  + -14.629807
  Y_new =   0.910506 * X  +   0.304857 * Y  +   0.279357 * Z  + -49.230762
  Z_new =   0.372256 * X  +  -0.898453 * Y  +  -0.232825 * Z  + 125.279045 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.824358    1.317234  [ DEG:  -104.5280     75.4720 ]
  Theta =  -0.381438   -2.760154  [ DEG:   -21.8548   -158.1452 ]
  Phi   =   1.375609   -1.765983  [ DEG:    78.8166   -101.1834 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fia_B                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fia_B.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  159  159   5.0  138   2.12   10.87  63.811
REMARK  ---------------------------------------------------------- 
MOLECULE 2fia_B
HEADER    TRANSFERASE                             28-DEC-05   2FIA              
TITLE     THE CRYSTAL STRUCTURE OF THE ACETYLTRANSFERASE FROM                   
TITLE    2 ENTEROCOCCUS FAECALIS                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: V583;                                                        
SOURCE   5 GENE: GI:29343911;                                                   
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    ACETYLTRANSFERASE, STRUCTURAL GENOMICS , PSI, PROTEIN                 
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,M.ZHOU,S.MOY,F.COLLART,A.JOACHIMIAK,MIDWEST CENTER            
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   14-FEB-06 2FIA    0                                                
JRNL        AUTH   R.ZHANG,M.ZHOU,S.MOY,F.COLLART,A.JOACHIMIAK                  
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE ACETYLTRANSFERASE               
JRNL        TITL 2 FROM ENTEROCOCCUS FAECALIS                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2FIA A    1   162  GB     29343911 AAO81671         1    162             
DBREF  2FIA B    1   162  GB     29343911 AAO81671         1    162             
SEQRES   1 A  162  MET LYS ILE ARG VAL ALA ASP GLU LYS GLU LEU PRO MET          
SEQRES   2 A  162  ILE LEU GLN PHE LEU THR GLU VAL LYS ALA TYR MET ASP          
SEQRES   3 A  162  VAL VAL GLY ILE THR GLN TRP THR LYS ASP TYR PRO SER          
SEQRES   4 A  162  GLN GLY ASP ILE GLN GLU ASP ILE THR LYS LYS ARG LEU          
SEQRES   5 A  162  TYR LEU LEU VAL HIS GLU GLU MET ILE PHE SER MET ALA          
SEQRES   6 A  162  THR PHE CYS MET GLU GLN GLU GLN ASP PHE VAL TRP LEU          
SEQRES   7 A  162  LYS ARG PHE ALA THR SER PRO ASN TYR ILE ALA LYS GLY          
SEQRES   8 A  162  TYR GLY SER LEU LEU PHE HIS GLU LEU GLU LYS ARG ALA          
SEQRES   9 A  162  VAL TRP GLU GLY ARG ARG LYS MET TYR ALA GLN THR ASN          
SEQRES  10 A  162  HIS THR ASN HIS ARG MET ILE ARG PHE PHE GLU SER LYS          
SEQRES  11 A  162  GLY PHE THR LYS ILE HIS GLU SER LEU GLN MET ASN ARG          
SEQRES  12 A  162  LEU ASP PHE GLY SER PHE TYR LEU TYR VAL LYS GLU LEU          
SEQRES  13 A  162  GLU ASN GLN SER ILE VAL                                      
SEQRES   1 B  162  MET LYS ILE ARG VAL ALA ASP GLU LYS GLU LEU PRO MET          
SEQRES   2 B  162  ILE LEU GLN PHE LEU THR GLU VAL LYS ALA TYR MET ASP          
SEQRES   3 B  162  VAL VAL GLY ILE THR GLN TRP THR LYS ASP TYR PRO SER          
SEQRES   4 B  162  GLN GLY ASP ILE GLN GLU ASP ILE THR LYS LYS ARG LEU          
SEQRES   5 B  162  TYR LEU LEU VAL HIS GLU GLU MET ILE PHE SER MET ALA          
SEQRES   6 B  162  THR PHE CYS MET GLU GLN GLU GLN ASP PHE VAL TRP LEU          
SEQRES   7 B  162  LYS ARG PHE ALA THR SER PRO ASN TYR ILE ALA LYS GLY          
SEQRES   8 B  162  TYR GLY SER LEU LEU PHE HIS GLU LEU GLU LYS ARG ALA          
SEQRES   9 B  162  VAL TRP GLU GLY ARG ARG LYS MET TYR ALA GLN THR ASN          
SEQRES  10 B  162  HIS THR ASN HIS ARG MET ILE ARG PHE PHE GLU SER LYS          
SEQRES  11 B  162  GLY PHE THR LYS ILE HIS GLU SER LEU GLN MET ASN ARG          
SEQRES  12 B  162  LEU ASP PHE GLY SER PHE TYR LEU TYR VAL LYS GLU LEU          
SEQRES  13 B  162  GLU ASN GLN SER ILE VAL                                      
FORMUL   3  HOH   *160(H2 O)                                                    
CRYST1  122.679   79.658   83.871  90.00 130.54  90.00 C 1 2 1       8          
ATOM   1321  N   MET B   1      -5.181 -18.047  51.967  1.00 81.13           N  
ATOM   1322  CA  MET B   1      -3.978 -18.913  52.014  1.00 80.94           C  
ATOM   1323  C   MET B   1      -4.009 -19.620  50.670  1.00 81.01           C  
ATOM   1324  O   MET B   1      -4.915 -20.432  50.447  1.00 81.27           O  
ATOM   1325  CB  MET B   1      -4.049 -19.919  53.181  1.00 80.71           C  
ATOM   1326  CG  MET B   1      -4.899 -19.501  54.400  1.00 79.48           C  
ATOM   1327  SD  MET B   1      -4.083 -18.411  55.564  1.00 76.44           S  
ATOM   1328  CE  MET B   1      -3.206 -19.660  56.495  1.00 76.67           C  
ATOM   1329  N   LYS B   2      -3.032 -19.377  49.789  1.00 80.87           N  
ATOM   1330  CA  LYS B   2      -1.664 -19.002  50.157  1.00 80.70           C  
ATOM   1331  C   LYS B   2      -1.134 -17.629  49.664  1.00 80.54           C  
ATOM   1332  O   LYS B   2      -1.893 -16.660  49.506  1.00 80.33           O  
ATOM   1333  CB  LYS B   2      -0.734 -20.135  49.712  1.00 80.82           C  
ATOM   1334  N   ILE B   3       0.179 -17.590  49.412  1.00 80.36           N  
ATOM   1335  CA  ILE B   3       0.988 -16.375  49.404  1.00 80.28           C  
ATOM   1336  C   ILE B   3       1.459 -16.039  48.009  1.00 80.12           C  
ATOM   1337  O   ILE B   3       2.057 -16.876  47.350  1.00 80.33           O  
ATOM   1338  CB  ILE B   3       2.265 -16.592  50.248  1.00 80.30           C  
ATOM   1339  CG1 ILE B   3       1.907 -16.984  51.687  1.00 80.24           C  
ATOM   1340  CG2 ILE B   3       3.147 -15.348  50.242  1.00 80.39           C  
ATOM   1341  CD1 ILE B   3       2.939 -17.863  52.355  1.00 80.13           C  
ATOM   1342  N   ARG B   4       1.248 -14.804  47.578  1.00 79.98           N  
ATOM   1343  CA  ARG B   4       1.538 -14.429  46.205  1.00 80.04           C  
ATOM   1344  C   ARG B   4       1.775 -12.945  46.098  1.00 80.45           C  
ATOM   1345  O   ARG B   4       1.332 -12.187  46.954  1.00 80.32           O  
ATOM   1346  CB  ARG B   4       0.356 -14.786  45.317  1.00 79.70           C  
ATOM   1347  CG  ARG B   4      -0.939 -14.101  45.730  1.00 79.40           C  
ATOM   1348  CD  ARG B   4      -2.052 -14.324  44.739  1.00 78.83           C  
ATOM   1349  NE  ARG B   4      -3.310 -13.733  45.199  1.00 78.22           N  
ATOM   1350  CZ  ARG B   4      -3.610 -12.433  45.167  1.00 77.12           C  
ATOM   1351  NH1 ARG B   4      -4.789 -12.031  45.615  1.00 77.56           N  
ATOM   1352  NH2 ARG B   4      -2.750 -11.534  44.707  1.00 75.91           N  
ATOM   1353  N   VAL B   5       2.440 -12.531  45.022  1.00 81.13           N  
ATOM   1354  CA  VAL B   5       2.686 -11.113  44.776  1.00 81.80           C  
ATOM   1355  C   VAL B   5       1.322 -10.448  44.685  1.00 82.34           C  
ATOM   1356  O   VAL B   5       0.365 -11.075  44.259  1.00 82.27           O  
ATOM   1357  CB  VAL B   5       3.509 -10.855  43.478  1.00 81.72           C  
ATOM   1358  CG1 VAL B   5       3.884  -9.382  43.369  1.00 81.78           C  
ATOM   1359  CG2 VAL B   5       4.778 -11.712  43.436  1.00 81.71           C  
ATOM   1360  N   ALA B   6       1.214  -9.201  45.124  1.00 83.27           N  
ATOM   1361  CA  ALA B   6      -0.062  -8.493  45.063  1.00 84.08           C  
ATOM   1362  C   ALA B   6      -0.304  -7.972  43.660  1.00 84.82           C  
ATOM   1363  O   ALA B   6       0.621  -7.510  42.993  1.00 84.65           O  
ATOM   1364  CB  ALA B   6      -0.094  -7.338  46.048  1.00 84.02           C  
ATOM   1365  N   ASP B   7      -1.556  -8.057  43.223  1.00 85.98           N  
ATOM   1366  CA  ASP B   7      -2.004  -7.427  41.984  1.00 86.58           C  
ATOM   1367  C   ASP B   7      -2.307  -5.965  42.274  1.00 87.21           C  
ATOM   1368  O   ASP B   7      -2.581  -5.603  43.410  1.00 87.65           O  
ATOM   1369  CB  ASP B   7      -3.262  -8.130  41.447  1.00 86.71           C  
ATOM   1370  CG  ASP B   7      -3.533  -7.808  39.992  1.00 86.77           C  
ATOM   1371  OD1 ASP B   7      -4.707  -7.531  39.646  1.00 88.02           O  
ATOM   1372  OD2 ASP B   7      -2.568  -7.821  39.196  1.00 87.08           O  
ATOM   1373  N   GLU B   8      -2.268  -5.118  41.256  1.00 87.79           N  
ATOM   1374  CA  GLU B   8      -2.611  -3.722  41.464  1.00 88.24           C  
ATOM   1375  C   GLU B   8      -4.116  -3.538  41.597  1.00 88.54           C  
ATOM   1376  O   GLU B   8      -4.564  -2.439  41.942  1.00 88.41           O  
ATOM   1377  CB  GLU B   8      -2.053  -2.834  40.349  1.00 88.36           C  
ATOM   1378  CG  GLU B   8      -2.724  -2.988  38.991  1.00 88.76           C  
ATOM   1379  CD  GLU B   8      -1.967  -2.261  37.888  1.00 88.87           C  
ATOM   1380  OE1 GLU B   8      -2.515  -1.284  37.325  1.00 89.24           O  
ATOM   1381  OE2 GLU B   8      -0.819  -2.664  37.592  1.00 89.42           O  
ATOM   1382  N   LYS B   9      -4.899  -4.599  41.355  1.00 88.82           N  
ATOM   1383  CA  LYS B   9      -6.355  -4.461  41.443  1.00 89.03           C  
ATOM   1384  C   LYS B   9      -6.792  -3.872  42.776  1.00 88.89           C  
ATOM   1385  O   LYS B   9      -7.834  -3.223  42.843  1.00 88.83           O  
ATOM   1386  CB  LYS B   9      -7.150  -5.658  40.891  1.00 89.40           C  
ATOM   1387  CG  LYS B   9      -7.401  -5.505  39.349  1.00 90.02           C  
ATOM   1388  CD  LYS B   9      -7.425  -3.991  38.906  1.00 90.66           C  
ATOM   1389  CE  LYS B   9      -8.279  -3.669  37.679  1.00 90.62           C  
ATOM   1390  NZ  LYS B   9      -8.630  -2.203  37.667  1.00 90.66           N  
ATOM   1391  N   GLU B  10      -6.067  -4.140  43.859  1.00 88.59           N  
ATOM   1392  CA  GLU B  10      -6.462  -5.003  44.955  1.00 88.14           C  
ATOM   1393  C   GLU B  10      -6.223  -3.905  45.992  1.00 88.01           C  
ATOM   1394  O   GLU B  10      -6.468  -4.071  47.181  1.00 88.04           O  
ATOM   1395  CB  GLU B  10      -5.513  -6.129  45.303  1.00 88.05           C  
ATOM   1396  CG  GLU B  10      -5.293  -7.162  44.273  1.00 87.93           C  
ATOM   1397  CD  GLU B  10      -4.703  -8.406  44.898  1.00 87.86           C  
ATOM   1398  OE1 GLU B  10      -5.437  -9.095  45.625  1.00 87.28           O  
ATOM   1399  OE2 GLU B  10      -3.508  -8.687  44.688  1.00 88.04           O  
ATOM   1400  N   LEU B  11      -5.732  -2.770  45.483  1.00 87.67           N  
ATOM   1401  CA  LEU B  11      -5.103  -1.719  46.246  1.00 87.50           C  
ATOM   1402  C   LEU B  11      -6.035  -1.178  47.303  1.00 87.36           C  
ATOM   1403  O   LEU B  11      -5.632  -1.027  48.449  1.00 87.48           O  
ATOM   1404  CB  LEU B  11      -4.636  -0.601  45.301  1.00 87.45           C  
ATOM   1405  CG  LEU B  11      -4.389   0.798  45.869  1.00 87.52           C  
ATOM   1406  CD1 LEU B  11      -3.183   1.427  45.197  1.00 87.55           C  
ATOM   1407  CD2 LEU B  11      -5.623   1.700  45.722  1.00 87.53           C  
ATOM   1408  N   PRO B  12      -7.294  -0.900  46.934  1.00 87.10           N  
ATOM   1409  CA  PRO B  12      -8.177  -0.341  47.954  1.00 86.69           C  
ATOM   1410  C   PRO B  12      -8.411  -1.344  49.081  1.00 86.24           C  
ATOM   1411  O   PRO B  12      -8.653  -0.953  50.220  1.00 86.22           O  
ATOM   1412  CB  PRO B  12      -9.474  -0.054  47.185  1.00 86.82           C  
ATOM   1413  CG  PRO B  12      -9.096  -0.104  45.740  1.00 86.96           C  
ATOM   1414  CD  PRO B  12      -7.991  -1.080  45.649  1.00 87.06           C  
ATOM   1415  N   MET B  13      -8.314  -2.625  48.749  1.00 85.60           N  
ATOM   1416  CA  MET B  13      -8.425  -3.686  49.726  1.00 85.15           C  
ATOM   1417  C   MET B  13      -7.229  -3.636  50.684  1.00 84.51           C  
ATOM   1418  O   MET B  13      -7.408  -3.633  51.906  1.00 84.62           O  
ATOM   1419  CB  MET B  13      -8.475  -5.021  48.997  1.00 85.26           C  
ATOM   1420  CG  MET B  13      -9.124  -6.159  49.735  1.00 85.67           C  
ATOM   1421  SD  MET B  13      -8.430  -7.700  49.109  1.00 86.10           S  
ATOM   1422  CE  MET B  13      -8.486  -7.446  47.319  1.00 86.41           C  
ATOM   1423  N   ILE B  14      -6.017  -3.582  50.134  1.00 83.52           N  
ATOM   1424  CA  ILE B  14      -4.810  -3.534  50.960  1.00 82.68           C  
ATOM   1425  C   ILE B  14      -4.707  -2.178  51.659  1.00 81.68           C  
ATOM   1426  O   ILE B  14      -4.252  -2.088  52.794  1.00 81.56           O  
ATOM   1427  CB  ILE B  14      -3.499  -3.863  50.160  1.00 82.69           C  
ATOM   1428  CG1 ILE B  14      -3.104  -2.726  49.226  1.00 83.01           C  
ATOM   1429  CG2 ILE B  14      -3.635  -5.171  49.377  1.00 82.67           C  
ATOM   1430  CD1 ILE B  14      -2.208  -3.163  48.055  1.00 83.20           C  
ATOM   1431  N   LEU B  15      -5.156  -1.128  50.987  1.00 80.58           N  
ATOM   1432  CA  LEU B  15      -5.188   0.198  51.584  1.00 79.87           C  
ATOM   1433  C   LEU B  15      -6.122   0.201  52.808  1.00 78.95           C  
ATOM   1434  O   LEU B  15      -5.897   0.940  53.763  1.00 78.72           O  
ATOM   1435  CB  LEU B  15      -5.635   1.233  50.549  1.00 79.87           C  
ATOM   1436  CG  LEU B  15      -4.959   2.603  50.547  1.00 80.36           C  
ATOM   1437  CD1 LEU B  15      -3.474   2.483  50.244  1.00 80.53           C  
ATOM   1438  CD2 LEU B  15      -5.628   3.521  49.518  1.00 80.30           C  
ATOM   1439  N   GLN B  16      -7.163  -0.633  52.780  1.00 77.93           N  
ATOM   1440  CA  GLN B  16      -8.042  -0.805  53.941  1.00 77.02           C  
ATOM   1441  C   GLN B  16      -7.223  -1.468  55.032  1.00 75.92           C  
ATOM   1442  O   GLN B  16      -7.027  -0.905  56.107  1.00 75.84           O  
ATOM   1443  CB  GLN B  16      -9.269  -1.683  53.609  1.00 77.25           C  
ATOM   1444  CG  GLN B  16     -10.634  -1.129  54.067  1.00 78.11           C  
ATOM   1445  CD  GLN B  16     -10.618  -0.470  55.447  1.00 79.41           C  
ATOM   1446  OE1 GLN B  16     -10.913   0.723  55.574  1.00 80.25           O  
ATOM   1447  NE2 GLN B  16     -10.272  -1.238  56.479  1.00 79.72           N  
ATOM   1448  N   PHE B  17      -6.731  -2.661  54.710  1.00 74.61           N  
ATOM   1449  CA  PHE B  17      -5.890  -3.470  55.589  1.00 73.79           C  
ATOM   1450  C   PHE B  17      -4.923  -2.657  56.423  1.00 72.77           C  
ATOM   1451  O   PHE B  17      -4.866  -2.843  57.632  1.00 72.80           O  
ATOM   1452  CB  PHE B  17      -5.093  -4.489  54.765  1.00 73.37           C  
ATOM   1453  CG  PHE B  17      -4.155  -5.348  55.576  1.00 74.06           C  
ATOM   1454  CD1 PHE B  17      -4.549  -6.605  56.020  1.00 69.13           C  
ATOM   1455  CD2 PHE B  17      -2.865  -4.914  55.862  1.00 76.50           C  
ATOM   1456  CE1 PHE B  17      -3.675  -7.410  56.751  1.00 70.64           C  
ATOM   1457  CE2 PHE B  17      -1.993  -5.710  56.593  1.00 75.01           C  
ATOM   1458  CZ  PHE B  17      -2.401  -6.961  57.037  1.00 73.40           C  
ATOM   1459  N   LEU B  18      -4.142  -1.776  55.808  1.00 71.47           N  
ATOM   1460  CA  LEU B  18      -3.160  -1.075  56.614  1.00 70.79           C  
ATOM   1461  C   LEU B  18      -3.749   0.093  57.409  1.00 69.86           C  
ATOM   1462  O   LEU B  18      -3.091   0.620  58.300  1.00 69.85           O  
ATOM   1463  CB  LEU B  18      -1.869  -0.714  55.848  1.00 70.91           C  
ATOM   1464  CG  LEU B  18      -1.836  -0.125  54.451  1.00 71.09           C  
ATOM   1465  CD1 LEU B  18      -2.665   1.107  54.406  1.00 71.70           C  
ATOM   1466  CD2 LEU B  18      -0.403   0.188  54.090  1.00 70.82           C  
ATOM   1467  N   THR B  19      -4.990   0.475  57.128  1.00 68.78           N  
ATOM   1468  CA  THR B  19      -5.689   1.418  58.009  1.00 68.05           C  
ATOM   1469  C   THR B  19      -6.115   0.730  59.313  1.00 66.94           C  
ATOM   1470  O   THR B  19      -6.078   1.341  60.380  1.00 66.23           O  
ATOM   1471  CB  THR B  19      -6.881   2.087  57.301  1.00 68.14           C  
ATOM   1472  OG1 THR B  19      -6.376   3.030  56.350  1.00 68.60           O  
ATOM   1473  CG2 THR B  19      -7.771   2.836  58.284  1.00 68.33           C  
ATOM   1474  N   GLU B  20      -6.496  -0.541  59.215  1.00 66.05           N  
ATOM   1475  CA  GLU B  20      -6.845  -1.340  60.391  1.00 65.67           C  
ATOM   1476  C   GLU B  20      -5.619  -1.653  61.235  1.00 64.63           C  
ATOM   1477  O   GLU B  20      -5.675  -1.583  62.467  1.00 64.89           O  
ATOM   1478  CB  GLU B  20      -7.555  -2.635  59.985  1.00 65.80           C  
ATOM   1479  CG  GLU B  20      -8.966  -2.382  59.421  1.00 67.14           C  
ATOM   1480  CD  GLU B  20      -9.539  -3.565  58.632  1.00 67.82           C  
ATOM   1481  OE1 GLU B  20      -9.175  -4.733  58.937  1.00 70.54           O  
ATOM   1482  OE2 GLU B  20     -10.361  -3.317  57.711  1.00 69.72           O  
ATOM   1483  N   VAL B  21      -4.515  -1.984  60.571  1.00 63.19           N  
ATOM   1484  CA  VAL B  21      -3.248  -2.249  61.249  1.00 61.90           C  
ATOM   1485  C   VAL B  21      -2.741  -0.966  61.907  1.00 60.68           C  
ATOM   1486  O   VAL B  21      -2.189  -1.012  62.988  1.00 60.43           O  
ATOM   1487  CB  VAL B  21      -2.183  -2.867  60.269  1.00 61.70           C  
ATOM   1488  CG1 VAL B  21      -0.777  -2.812  60.850  1.00 61.32           C  
ATOM   1489  CG2 VAL B  21      -2.543  -4.307  59.924  1.00 61.12           C  
ATOM   1490  N   LYS B  22      -2.946   0.176  61.270  1.00 59.69           N  
ATOM   1491  CA  LYS B  22      -2.513   1.441  61.852  1.00 59.16           C  
ATOM   1492  C   LYS B  22      -3.344   1.826  63.061  1.00 58.32           C  
ATOM   1493  O   LYS B  22      -2.863   2.530  63.941  1.00 58.18           O  
ATOM   1494  CB  LYS B  22      -2.566   2.571  60.825  1.00 59.26           C  
ATOM   1495  CG  LYS B  22      -1.363   2.619  59.892  1.00 59.72           C  
ATOM   1496  CD  LYS B  22      -1.485   3.763  58.908  1.00 59.53           C  
ATOM   1497  CE  LYS B  22      -0.707   3.502  57.638  1.00 59.81           C  
ATOM   1498  NZ  LYS B  22      -0.747   4.682  56.734  1.00 60.45           N  
ATOM   1499  N   ALA B  23      -4.594   1.380  63.094  1.00 57.54           N  
ATOM   1500  CA  ALA B  23      -5.471   1.663  64.214  1.00 56.94           C  
ATOM   1501  C   ALA B  23      -5.023   0.832  65.419  1.00 56.46           C  
ATOM   1502  O   ALA B  23      -4.809   1.373  66.503  1.00 56.28           O  
ATOM   1503  CB  ALA B  23      -6.893   1.353  63.845  1.00 56.75           C  
ATOM   1504  N   TYR B  24      -4.871  -0.476  65.211  1.00 55.83           N  
ATOM   1505  CA  TYR B  24      -4.321  -1.391  66.214  1.00 55.28           C  
ATOM   1506  C   TYR B  24      -3.017  -0.865  66.800  1.00 54.71           C  
ATOM   1507  O   TYR B  24      -2.879  -0.714  68.012  1.00 54.72           O  
ATOM   1508  CB  TYR B  24      -4.083  -2.749  65.570  1.00 55.73           C  
ATOM   1509  CG  TYR B  24      -3.248  -3.705  66.381  1.00 56.08           C  
ATOM   1510  CD1 TYR B  24      -3.824  -4.507  67.360  1.00 56.45           C  
ATOM   1511  CD2 TYR B  24      -1.888  -3.837  66.147  1.00 56.47           C  
ATOM   1512  CE1 TYR B  24      -3.065  -5.407  68.101  1.00 56.27           C  
ATOM   1513  CE2 TYR B  24      -1.117  -4.728  66.883  1.00 56.66           C  
ATOM   1514  CZ  TYR B  24      -1.712  -5.512  67.857  1.00 56.63           C  
ATOM   1515  OH  TYR B  24      -0.942  -6.400  68.580  1.00 56.63           O  
ATOM   1516  N   MET B  25      -2.067  -0.596  65.912  1.00 54.18           N  
ATOM   1517  CA  MET B  25      -0.777   0.005  66.261  1.00 53.23           C  
ATOM   1518  C   MET B  25      -1.022   1.155  67.238  1.00 53.63           C  
ATOM   1519  O   MET B  25      -0.368   1.264  68.277  1.00 53.65           O  
ATOM   1520  CB  MET B  25      -0.101   0.531  64.985  1.00 53.16           C  
ATOM   1521  CG  MET B  25       1.394   0.264  64.824  1.00 51.92           C  
ATOM   1522  SD  MET B  25       1.900   0.218  63.083  1.00 48.38           S  
ATOM   1523  CE  MET B  25       1.391  -1.422  62.745  1.00 47.51           C  
ATOM   1524  N   ASP B  26      -2.001   1.985  66.906  1.00 53.95           N  
ATOM   1525  CA  ASP B  26      -2.319   3.173  67.693  1.00 53.79           C  
ATOM   1526  C   ASP B  26      -2.829   2.880  69.125  1.00 53.64           C  
ATOM   1527  O   ASP B  26      -2.272   3.401  70.089  1.00 53.60           O  
ATOM   1528  CB  ASP B  26      -3.333   4.033  66.937  1.00 54.12           C  
ATOM   1529  CG  ASP B  26      -3.492   5.398  67.532  1.00 55.42           C  
ATOM   1530  OD1 ASP B  26      -2.563   5.847  68.230  1.00 58.41           O  
ATOM   1531  OD2 ASP B  26      -4.555   6.032  67.319  1.00 59.52           O  
ATOM   1532  N   VAL B  27      -3.858   2.049  69.280  1.00 53.18           N  
ATOM   1533  CA  VAL B  27      -4.422   1.876  70.613  1.00 53.08           C  
ATOM   1534  C   VAL B  27      -3.406   1.198  71.545  1.00 52.84           C  
ATOM   1535  O   VAL B  27      -3.289   1.571  72.718  1.00 52.92           O  
ATOM   1536  CB  VAL B  27      -5.831   1.155  70.662  1.00 53.33           C  
ATOM   1537  CG1 VAL B  27      -6.598   1.279  69.345  1.00 53.05           C  
ATOM   1538  CG2 VAL B  27      -5.720  -0.296  71.104  1.00 53.66           C  
ATOM   1539  N   VAL B  28      -2.656   0.231  71.024  1.00 52.22           N  
ATOM   1540  CA  VAL B  28      -1.711  -0.504  71.856  1.00 51.72           C  
ATOM   1541  C   VAL B  28      -0.493   0.336  72.241  1.00 51.10           C  
ATOM   1542  O   VAL B  28       0.252  -0.033  73.137  1.00 50.84           O  
ATOM   1543  CB  VAL B  28      -1.242  -1.811  71.199  1.00 51.97           C  
ATOM   1544  CG1 VAL B  28      -2.436  -2.693  70.852  1.00 51.83           C  
ATOM   1545  CG2 VAL B  28      -0.369  -1.528  69.956  1.00 52.63           C  
ATOM   1546  N   GLY B  29      -0.295   1.459  71.563  1.00 50.68           N  
ATOM   1547  CA  GLY B  29       0.792   2.386  71.896  1.00 50.47           C  
ATOM   1548  C   GLY B  29       2.092   2.156  71.130  1.00 49.87           C  
ATOM   1549  O   GLY B  29       3.163   2.587  71.568  1.00 48.62           O  
ATOM   1550  N   ILE B  30       1.989   1.475  69.984  1.00 49.82           N  
ATOM   1551  CA  ILE B  30       3.105   1.377  69.035  1.00 49.92           C  
ATOM   1552  C   ILE B  30       3.168   2.662  68.212  1.00 49.92           C  
ATOM   1553  O   ILE B  30       2.192   3.048  67.584  1.00 50.06           O  
ATOM   1554  CB  ILE B  30       2.969   0.151  68.112  1.00 49.61           C  
ATOM   1555  CG1 ILE B  30       3.212  -1.126  68.922  1.00 49.44           C  
ATOM   1556  CG2 ILE B  30       3.970   0.225  66.960  1.00 49.60           C  
ATOM   1557  CD1 ILE B  30       2.764  -2.411  68.251  1.00 49.51           C  
ATOM   1558  N   THR B  31       4.315   3.325  68.240  1.00 50.29           N  
ATOM   1559  CA  THR B  31       4.550   4.538  67.459  1.00 50.90           C  
ATOM   1560  C   THR B  31       5.475   4.210  66.287  1.00 51.31           C  
ATOM   1561  O   THR B  31       6.694   4.237  66.437  1.00 51.50           O  
ATOM   1562  CB  THR B  31       5.197   5.640  68.342  1.00 50.83           C  
ATOM   1563  OG1 THR B  31       6.434   5.172  68.897  1.00 50.93           O  
ATOM   1564  CG2 THR B  31       4.278   6.005  69.473  1.00 50.38           C  
ATOM   1565  N   GLN B  32       4.909   3.879  65.133  1.00 51.93           N  
ATOM   1566  CA  GLN B  32       5.720   3.384  64.023  1.00 52.76           C  
ATOM   1567  C   GLN B  32       5.243   3.884  62.668  1.00 53.65           C  
ATOM   1568  O   GLN B  32       6.003   4.480  61.921  1.00 53.66           O  
ATOM   1569  CB  GLN B  32       5.741   1.858  64.039  1.00 52.67           C  
ATOM   1570  CG  GLN B  32       6.833   1.244  63.182  1.00 52.14           C  
ATOM   1571  CD  GLN B  32       7.031  -0.235  63.444  1.00 52.04           C  
ATOM   1572  OE1 GLN B  32       7.295  -0.642  64.572  1.00 51.39           O  
ATOM   1573  NE2 GLN B  32       6.940  -1.043  62.395  1.00 51.28           N  
ATOM   1574  N   TRP B  33       3.982   3.637  62.354  1.00 55.04           N  
ATOM   1575  CA  TRP B  33       3.406   4.096  61.105  1.00 56.21           C  
ATOM   1576  C   TRP B  33       2.687   5.417  61.261  1.00 57.84           C  
ATOM   1577  O   TRP B  33       2.466   5.893  62.361  1.00 58.50           O  
ATOM   1578  CB  TRP B  33       2.514   3.006  60.505  1.00 55.29           C  
ATOM   1579  CG  TRP B  33       3.344   1.882  59.966  1.00 54.42           C  
ATOM   1580  CD1 TRP B  33       4.711   1.842  59.891  1.00 57.41           C  
ATOM   1581  CD2 TRP B  33       2.883   0.666  59.381  1.00 53.24           C  
ATOM   1582  NE1 TRP B  33       5.117   0.679  59.317  1.00 54.44           N  
ATOM   1583  CE2 TRP B  33       4.018  -0.065  58.993  1.00 53.89           C  
ATOM   1584  CE3 TRP B  33       1.626   0.121  59.148  1.00 55.79           C  
ATOM   1585  CZ2 TRP B  33       3.934  -1.315  58.382  1.00 54.79           C  
ATOM   1586  CZ3 TRP B  33       1.544  -1.123  58.545  1.00 54.11           C  
ATOM   1587  CH2 TRP B  33       2.691  -1.822  58.169  1.00 53.94           C  
ATOM   1588  N   THR B  34       2.378   6.016  60.122  1.00 60.20           N  
ATOM   1589  CA  THR B  34       1.825   7.359  60.016  1.00 61.38           C  
ATOM   1590  C   THR B  34       0.681   7.241  59.025  1.00 62.89           C  
ATOM   1591  O   THR B  34       0.459   6.170  58.470  1.00 62.61           O  
ATOM   1592  CB  THR B  34       2.914   8.325  59.496  1.00 61.32           C  
ATOM   1593  OG1 THR B  34       4.085   8.189  60.311  1.00 60.66           O  
ATOM   1594  CG2 THR B  34       2.467   9.782  59.552  1.00 61.12           C  
ATOM   1595  N   LYS B  35      -0.083   8.307  58.829  1.00 64.97           N  
ATOM   1596  CA  LYS B  35      -1.016   8.348  57.694  1.00 66.52           C  
ATOM   1597  C   LYS B  35      -0.215   8.344  56.373  1.00 67.41           C  
ATOM   1598  O   LYS B  35      -0.620   7.732  55.392  1.00 67.68           O  
ATOM   1599  CB  LYS B  35      -1.963   9.554  57.789  1.00 66.76           C  
ATOM   1600  CG  LYS B  35      -1.256  10.925  57.774  1.00 67.98           C  
ATOM   1601  CD  LYS B  35      -2.207  12.101  58.086  1.00 68.39           C  
ATOM   1602  CE  LYS B  35      -3.315  12.261  57.020  1.00 70.04           C  
ATOM   1603  NZ  LYS B  35      -2.789  12.398  55.624  1.00 70.39           N  
ATOM   1604  N   ASP B  36       0.948   8.983  56.382  1.00 68.47           N  
ATOM   1605  CA  ASP B  36       1.782   9.117  55.188  1.00 69.23           C  
ATOM   1606  C   ASP B  36       2.806   7.993  55.004  1.00 69.94           C  
ATOM   1607  O   ASP B  36       3.560   8.009  54.026  1.00 70.15           O  
ATOM   1608  CB  ASP B  36       2.513  10.458  55.228  1.00 69.63           C  
ATOM   1609  CG  ASP B  36       1.562  11.629  55.419  1.00 70.92           C  
ATOM   1610  OD1 ASP B  36       0.463  11.617  54.811  1.00 71.54           O  
ATOM   1611  OD2 ASP B  36       1.904  12.550  56.192  1.00 73.20           O  
ATOM   1612  N   TYR B  37       2.848   7.030  55.928  1.00 70.42           N  
ATOM   1613  CA  TYR B  37       3.751   5.887  55.774  1.00 70.33           C  
ATOM   1614  C   TYR B  37       3.269   4.625  56.498  1.00 70.59           C  
ATOM   1615  O   TYR B  37       3.117   4.634  57.706  1.00 70.21           O  
ATOM   1616  CB  TYR B  37       5.172   6.228  56.235  1.00 70.51           C  
ATOM   1617  CG  TYR B  37       6.115   5.084  55.956  1.00 70.57           C  
ATOM   1618  CD1 TYR B  37       6.373   4.126  56.927  1.00 70.85           C  
ATOM   1619  CD2 TYR B  37       6.701   4.922  54.700  1.00 70.52           C  
ATOM   1620  CE1 TYR B  37       7.198   3.056  56.669  1.00 71.03           C  
ATOM   1621  CE2 TYR B  37       7.537   3.852  54.436  1.00 70.25           C  
ATOM   1622  CZ  TYR B  37       7.777   2.925  55.428  1.00 70.54           C  
ATOM   1623  OH  TYR B  37       8.595   1.853  55.199  1.00 70.37           O  
ATOM   1624  N   PRO B  38       3.036   3.533  55.757  1.00 71.10           N  
ATOM   1625  CA  PRO B  38       2.984   3.446  54.303  1.00 71.76           C  
ATOM   1626  C   PRO B  38       1.818   4.241  53.734  1.00 72.13           C  
ATOM   1627  O   PRO B  38       0.706   4.135  54.240  1.00 72.26           O  
ATOM   1628  CB  PRO B  38       2.776   1.953  54.045  1.00 71.57           C  
ATOM   1629  CG  PRO B  38       3.210   1.280  55.285  1.00 71.35           C  
ATOM   1630  CD  PRO B  38       2.868   2.217  56.382  1.00 71.07           C  
ATOM   1631  N   SER B  39       2.090   5.046  52.713  1.00 72.62           N  
ATOM   1632  CA  SER B  39       1.047   5.752  51.985  1.00 73.07           C  
ATOM   1633  C   SER B  39       0.735   4.975  50.710  1.00 73.51           C  
ATOM   1634  O   SER B  39       1.330   3.928  50.447  1.00 73.45           O  
ATOM   1635  CB  SER B  39       1.485   7.184  51.661  1.00 73.12           C  
ATOM   1636  OG  SER B  39       2.698   7.196  50.924  1.00 73.61           O  
ATOM   1637  N   GLN B  40      -0.220   5.491  49.937  1.00 74.10           N  
ATOM   1638  CA  GLN B  40      -0.638   4.889  48.667  1.00 74.09           C  
ATOM   1639  C   GLN B  40       0.536   4.764  47.696  1.00 74.08           C  
ATOM   1640  O   GLN B  40       0.751   3.704  47.100  1.00 73.87           O  
ATOM   1641  CB  GLN B  40      -1.740   5.745  48.040  1.00 74.28           C  
ATOM   1642  CG  GLN B  40      -2.542   5.061  46.934  1.00 74.67           C  
ATOM   1643  CD  GLN B  40      -3.761   5.881  46.510  1.00 74.86           C  
ATOM   1644  OE1 GLN B  40      -4.899   5.396  46.540  1.00 75.75           O  
ATOM   1645  NE2 GLN B  40      -3.526   7.134  46.134  1.00 75.16           N  
ATOM   1646  N   GLY B  41       1.294   5.852  47.553  1.00 74.09           N  
ATOM   1647  CA  GLY B  41       2.473   5.879  46.681  1.00 74.09           C  
ATOM   1648  C   GLY B  41       3.447   4.751  46.970  1.00 74.05           C  
ATOM   1649  O   GLY B  41       3.872   4.028  46.062  1.00 73.91           O  
ATOM   1650  N   ASP B  42       3.782   4.601  48.248  1.00 74.03           N  
ATOM   1651  CA  ASP B  42       4.639   3.512  48.712  1.00 73.91           C  
ATOM   1652  C   ASP B  42       4.125   2.155  48.230  1.00 73.79           C  
ATOM   1653  O   ASP B  42       4.904   1.306  47.803  1.00 73.68           O  
ATOM   1654  CB  ASP B  42       4.732   3.514  50.243  1.00 73.83           C  
ATOM   1655  CG  ASP B  42       5.325   4.797  50.797  1.00 73.92           C  
ATOM   1656  OD1 ASP B  42       6.508   5.078  50.523  1.00 74.30           O  
ATOM   1657  OD2 ASP B  42       4.607   5.526  51.509  1.00 73.98           O  
ATOM   1658  N   ILE B  43       2.813   1.961  48.289  1.00 73.80           N  
ATOM   1659  CA  ILE B  43       2.213   0.685  47.917  1.00 73.90           C  
ATOM   1660  C   ILE B  43       2.270   0.452  46.402  1.00 73.90           C  
ATOM   1661  O   ILE B  43       2.698  -0.616  45.954  1.00 73.73           O  
ATOM   1662  CB  ILE B  43       0.752   0.584  48.440  1.00 73.96           C  
ATOM   1663  CG1 ILE B  43       0.733   0.557  49.974  1.00 74.23           C  
ATOM   1664  CG2 ILE B  43       0.054  -0.659  47.911  1.00 73.82           C  
ATOM   1665  CD1 ILE B  43       1.178  -0.776  50.594  1.00 74.29           C  
ATOM   1666  N   GLN B  44       1.836   1.443  45.625  1.00 73.91           N  
ATOM   1667  CA  GLN B  44       1.877   1.357  44.154  1.00 73.93           C  
ATOM   1668  C   GLN B  44       3.293   1.036  43.689  1.00 73.63           C  
ATOM   1669  O   GLN B  44       3.528   0.021  43.022  1.00 73.40           O  
ATOM   1670  CB  GLN B  44       1.408   2.674  43.506  1.00 74.11           C  
ATOM   1671  CG  GLN B  44      -0.115   2.806  43.307  1.00 74.32           C  
ATOM   1672  CD  GLN B  44      -0.587   4.267  43.247  1.00 74.59           C  
ATOM   1673  OE1 GLN B  44      -1.777   4.554  43.409  1.00 75.83           O  
ATOM   1674  NE2 GLN B  44       0.349   5.195  43.034  1.00 74.90           N  
ATOM   1675  N   GLU B  45       4.232   1.896  44.072  1.00 73.32           N  
ATOM   1676  CA  GLU B  45       5.629   1.686  43.751  1.00 73.31           C  
ATOM   1677  C   GLU B  45       6.034   0.248  44.030  1.00 73.28           C  
ATOM   1678  O   GLU B  45       6.740  -0.354  43.233  1.00 73.66           O  
ATOM   1679  CB  GLU B  45       6.522   2.633  44.543  1.00 73.17           C  
ATOM   1680  CG  GLU B  45       7.980   2.626  44.084  1.00 73.42           C  
ATOM   1681  CD  GLU B  45       8.941   3.195  45.124  1.00 73.57           C  
ATOM   1682  OE1 GLU B  45      10.166   3.066  44.930  1.00 73.31           O  
ATOM   1683  OE2 GLU B  45       8.480   3.765  46.137  1.00 74.61           O  
ATOM   1684  N   ASP B  46       5.588  -0.306  45.153  1.00 73.11           N  
ATOM   1685  CA  ASP B  46       5.963  -1.667  45.511  1.00 73.06           C  
ATOM   1686  C   ASP B  46       5.333  -2.678  44.560  1.00 72.90           C  
ATOM   1687  O   ASP B  46       5.974  -3.659  44.192  1.00 72.56           O  
ATOM   1688  CB  ASP B  46       5.609  -1.990  46.977  1.00 73.12           C  
ATOM   1689  CG  ASP B  46       6.588  -1.361  47.988  1.00 73.07           C  
ATOM   1690  OD1 ASP B  46       7.722  -0.998  47.612  1.00 72.77           O  
ATOM   1691  OD2 ASP B  46       6.221  -1.231  49.175  1.00 72.68           O  
ATOM   1692  N   ILE B  47       4.091  -2.445  44.149  1.00 73.04           N  
ATOM   1693  CA  ILE B  47       3.428  -3.388  43.233  1.00 73.17           C  
ATOM   1694  C   ILE B  47       4.069  -3.311  41.847  1.00 73.18           C  
ATOM   1695  O   ILE B  47       4.405  -4.344  41.260  1.00 72.97           O  
ATOM   1696  CB  ILE B  47       1.919  -3.158  43.112  1.00 73.18           C  
ATOM   1697  CG1 ILE B  47       1.250  -3.287  44.477  1.00 73.30           C  
ATOM   1698  CG2 ILE B  47       1.302  -4.194  42.175  1.00 73.13           C  
ATOM   1699  CD1 ILE B  47      -0.053  -2.556  44.567  1.00 73.38           C  
ATOM   1700  N   THR B  48       4.238  -2.083  41.351  1.00 73.07           N  
ATOM   1701  CA  THR B  48       5.034  -1.814  40.151  1.00 72.93           C  
ATOM   1702  C   THR B  48       6.307  -2.657  40.140  1.00 72.78           C  
ATOM   1703  O   THR B  48       6.567  -3.379  39.180  1.00 72.85           O  
ATOM   1704  CB  THR B  48       5.411  -0.310  40.056  1.00 73.06           C  
ATOM   1705  OG1 THR B  48       4.230   0.457  39.787  1.00 73.38           O  
ATOM   1706  CG2 THR B  48       6.459  -0.050  38.961  1.00 72.90           C  
ATOM   1707  N   LYS B  49       7.078  -2.588  41.220  1.00 72.40           N  
ATOM   1708  CA  LYS B  49       8.354  -3.287  41.288  1.00 72.18           C  
ATOM   1709  C   LYS B  49       8.233  -4.760  41.717  1.00 71.99           C  
ATOM   1710  O   LYS B  49       9.239  -5.389  42.046  1.00 72.01           O  
ATOM   1711  CB  LYS B  49       9.308  -2.528  42.203  1.00 72.07           C  
ATOM   1712  CG  LYS B  49       9.516  -1.081  41.792  1.00 72.04           C  
ATOM   1713  CD  LYS B  49      10.555  -0.418  42.668  1.00 72.25           C  
ATOM   1714  CE  LYS B  49      10.847   0.991  42.207  1.00 72.29           C  
ATOM   1715  NZ  LYS B  49      12.010   1.570  42.928  1.00 72.30           N  
ATOM   1716  N   LYS B  50       7.013  -5.303  41.711  1.00 71.82           N  
ATOM   1717  CA  LYS B  50       6.776  -6.748  41.879  1.00 71.85           C  
ATOM   1718  C   LYS B  50       7.394  -7.280  43.190  1.00 71.57           C  
ATOM   1719  O   LYS B  50       8.181  -8.231  43.217  1.00 71.78           O  
ATOM   1720  CB  LYS B  50       7.281  -7.500  40.641  1.00 72.08           C  
ATOM   1721  CG  LYS B  50       6.364  -8.644  40.160  1.00 72.75           C  
ATOM   1722  CD  LYS B  50       6.390  -8.789  38.614  1.00 72.67           C  
ATOM   1723  CE  LYS B  50       5.595 -10.013  38.130  1.00 72.97           C  
ATOM   1724  NZ  LYS B  50       6.271 -11.318  38.450  1.00 72.82           N  
ATOM   1725  N   ARG B  51       6.948  -6.671  44.281  1.00 71.03           N  
ATOM   1726  CA  ARG B  51       7.708  -6.572  45.524  1.00 70.45           C  
ATOM   1727  C   ARG B  51       6.826  -6.776  46.778  1.00 70.09           C  
ATOM   1728  O   ARG B  51       7.315  -7.179  47.822  1.00 69.75           O  
ATOM   1729  CB  ARG B  51       8.252  -5.159  45.524  1.00 70.22           C  
ATOM   1730  CG  ARG B  51       9.481  -4.847  46.290  1.00 69.93           C  
ATOM   1731  CD  ARG B  51       9.562  -3.335  46.238  1.00 69.98           C  
ATOM   1732  NE  ARG B  51      10.828  -2.765  46.647  1.00 69.74           N  
ATOM   1733  CZ  ARG B  51      11.077  -1.458  46.658  1.00 70.16           C  
ATOM   1734  NH1 ARG B  51      10.146  -0.588  46.270  1.00 69.84           N  
ATOM   1735  NH2 ARG B  51      12.267  -1.014  47.056  1.00 70.90           N  
ATOM   1736  N   LEU B  52       5.536  -6.475  46.649  1.00 69.73           N  
ATOM   1737  CA  LEU B  52       4.573  -6.560  47.723  1.00 69.83           C  
ATOM   1738  C   LEU B  52       3.899  -7.935  47.703  1.00 69.82           C  
ATOM   1739  O   LEU B  52       3.086  -8.219  46.833  1.00 69.76           O  
ATOM   1740  CB  LEU B  52       3.535  -5.443  47.540  1.00 69.58           C  
ATOM   1741  CG  LEU B  52       2.757  -4.918  48.749  1.00 69.57           C  
ATOM   1742  CD1 LEU B  52       1.535  -4.169  48.278  1.00 69.08           C  
ATOM   1743  CD2 LEU B  52       2.342  -6.026  49.697  1.00 69.83           C  
ATOM   1744  N   TYR B  53       4.229  -8.780  48.673  1.00 70.09           N  
ATOM   1745  CA  TYR B  53       3.661 -10.123  48.773  1.00 70.59           C  
ATOM   1746  C   TYR B  53       2.540 -10.178  49.808  1.00 71.05           C  
ATOM   1747  O   TYR B  53       2.601  -9.490  50.816  1.00 71.08           O  
ATOM   1748  CB  TYR B  53       4.749 -11.117  49.152  1.00 70.53           C  
ATOM   1749  CG  TYR B  53       5.738 -11.382  48.049  1.00 70.43           C  
ATOM   1750  CD1 TYR B  53       6.669 -10.418  47.678  1.00 70.94           C  
ATOM   1751  CD2 TYR B  53       5.747 -12.598  47.374  1.00 70.44           C  
ATOM   1752  CE1 TYR B  53       7.583 -10.657  46.657  1.00 71.00           C  
ATOM   1753  CE2 TYR B  53       6.657 -12.851  46.363  1.00 70.52           C  
ATOM   1754  CZ  TYR B  53       7.570 -11.877  46.006  1.00 70.76           C  
ATOM   1755  OH  TYR B  53       8.470 -12.126  45.001  1.00 70.79           O  
ATOM   1756  N   LEU B  54       1.535 -11.018  49.557  1.00 71.72           N  
ATOM   1757  CA  LEU B  54       0.336 -11.109  50.391  1.00 72.28           C  
ATOM   1758  C   LEU B  54       0.059 -12.533  50.840  1.00 73.15           C  
ATOM   1759  O   LEU B  54       0.248 -13.475  50.076  1.00 73.14           O  
ATOM   1760  CB  LEU B  54      -0.879 -10.625  49.609  1.00 72.01           C  
ATOM   1761  CG  LEU B  54      -1.349  -9.188  49.808  1.00 71.74           C  
ATOM   1762  CD1 LEU B  54      -0.212  -8.218  49.747  1.00 71.52           C  
ATOM   1763  CD2 LEU B  54      -2.373  -8.851  48.749  1.00 71.92           C  
ATOM   1764  N   LEU B  55      -0.382 -12.678  52.087  1.00 74.23           N  
ATOM   1765  CA  LEU B  55      -1.054 -13.887  52.534  1.00 74.91           C  
ATOM   1766  C   LEU B  55      -2.521 -13.534  52.382  1.00 75.91           C  
ATOM   1767  O   LEU B  55      -3.000 -12.586  53.012  1.00 75.92           O  
ATOM   1768  CB  LEU B  55      -0.716 -14.215  53.985  1.00 74.82           C  
ATOM   1769  CG  LEU B  55      -0.567 -15.696  54.340  1.00 74.35           C  
ATOM   1770  CD1 LEU B  55      -0.688 -15.882  55.843  1.00 74.51           C  
ATOM   1771  CD2 LEU B  55      -1.574 -16.562  53.633  1.00 74.14           C  
ATOM   1772  N   VAL B  56      -3.228 -14.272  51.527  1.00 76.79           N  
ATOM   1773  CA  VAL B  56      -4.527 -13.815  51.023  1.00 76.73           C  
ATOM   1774  C   VAL B  56      -5.485 -14.964  50.720  1.00 76.51           C  
ATOM   1775  O   VAL B  56      -5.041 -16.079  50.420  1.00 76.55           O  
ATOM   1776  CB  VAL B  56      -4.320 -12.953  49.753  1.00 77.82           C  
ATOM   1777  CG1 VAL B  56      -3.922 -13.825  48.562  1.00 78.68           C  
ATOM   1778  CG2 VAL B  56      -5.549 -12.109  49.449  1.00 78.45           C  
ATOM   1779  N   HIS B  57      -6.793 -14.684  50.806  1.00 75.26           N  
ATOM   1780  CA  HIS B  57      -7.841 -15.692  50.550  1.00 73.15           C  
ATOM   1781  C   HIS B  57      -9.246 -15.138  50.225  1.00 67.51           C  
ATOM   1782  O   HIS B  57     -10.110 -15.062  51.110  1.00 67.58           O  
ATOM   1783  CB  HIS B  57      -7.995 -16.621  51.768  1.00 74.67           C  
ATOM   1784  CG  HIS B  57      -8.693 -17.915  51.465  1.00 77.40           C  
ATOM   1785  ND1 HIS B  57      -9.268 -18.188  50.239  1.00 80.43           N  
ATOM   1786  CD2 HIS B  57      -8.934 -18.999  52.243  1.00 80.78           C  
ATOM   1787  CE1 HIS B  57      -9.810 -19.393  50.266  1.00 81.84           C  
ATOM   1788  NE2 HIS B  57      -9.624 -19.906  51.471  1.00 82.24           N  
ATOM   1789  N   GLU B  58      -9.493 -14.677  49.006  1.00 61.91           N  
ATOM   1790  CA  GLU B  58      -8.534 -13.975  48.177  1.00 58.88           C  
ATOM   1791  C   GLU B  58      -9.485 -13.078  47.420  1.00 63.29           C  
ATOM   1792  O   GLU B  58      -9.425 -13.039  46.185  1.00 63.56           O  
ATOM   1793  CB  GLU B  58      -7.783 -14.954  47.198  1.00 56.87           C  
ATOM   1794  N   GLU B  59     -10.280 -12.256  48.115  1.00 69.99           N  
ATOM   1795  CA  GLU B  59      -9.792 -11.121  48.887  1.00 77.23           C  
ATOM   1796  C   GLU B  59      -9.904 -11.015  50.423  1.00 79.02           C  
ATOM   1797  O   GLU B  59     -10.430 -10.014  50.927  1.00 79.62           O  
ATOM   1798  CB  GLU B  59     -10.542  -9.906  48.293  1.00 77.76           C  
ATOM   1799  CG  GLU B  59     -11.966  -9.655  48.882  1.00 80.48           C  
ATOM   1800  CD  GLU B  59     -12.921  -8.916  47.942  1.00 80.67           C  
ATOM   1801  OE1 GLU B  59     -12.663  -8.834  46.717  1.00 83.07           O  
ATOM   1802  OE2 GLU B  59     -13.953  -8.418  48.449  1.00 83.57           O  
ATOM   1803  N   MET B  60      -9.370 -11.964  51.184  1.00 81.50           N  
ATOM   1804  CA  MET B  60      -9.163 -11.688  52.616  1.00 82.11           C  
ATOM   1805  C   MET B  60      -7.670 -11.739  52.965  1.00 82.41           C  
ATOM   1806  O   MET B  60      -7.094 -12.824  53.151  1.00 82.69           O  
ATOM   1807  CB  MET B  60     -10.022 -12.588  53.525  1.00 83.87           C  
ATOM   1808  CG  MET B  60     -10.769 -11.778  54.618  1.00 85.63           C  
ATOM   1809  SD  MET B  60      -9.763 -11.347  56.078  1.00 88.56           S  
ATOM   1810  CE  MET B  60     -10.311  -9.660  56.412  1.00 87.64           C  
ATOM   1811  N   ILE B  61      -7.067 -10.549  53.048  1.00 81.41           N  
ATOM   1812  CA  ILE B  61      -5.632 -10.394  53.295  1.00 80.41           C  
ATOM   1813  C   ILE B  61      -5.320 -10.559  54.766  1.00 79.28           C  
ATOM   1814  O   ILE B  61      -5.641  -9.692  55.570  1.00 78.93           O  
ATOM   1815  CB  ILE B  61      -5.120  -8.993  52.918  1.00 80.68           C  
ATOM   1816  CG1 ILE B  61      -5.487  -8.629  51.483  1.00 80.64           C  
ATOM   1817  CG2 ILE B  61      -3.609  -8.908  53.109  1.00 81.20           C  
ATOM   1818  CD1 ILE B  61      -5.693  -7.151  51.318  1.00 80.61           C  
ATOM   1819  N   PHE B  62      -4.663 -11.656  55.111  1.00 78.04           N  
ATOM   1820  CA  PHE B  62      -4.287 -11.904  56.496  1.00 76.84           C  
ATOM   1821  C   PHE B  62      -3.020 -11.126  56.863  1.00 75.42           C  
ATOM   1822  O   PHE B  62      -2.908 -10.604  57.972  1.00 75.36           O  
ATOM   1823  CB  PHE B  62      -4.093 -13.405  56.745  1.00 77.59           C  
ATOM   1824  CG  PHE B  62      -5.243 -14.259  56.251  1.00 78.50           C  
ATOM   1825  CD1 PHE B  62      -6.542 -13.998  56.667  1.00 75.41           C  
ATOM   1826  CD2 PHE B  62      -5.027 -15.312  55.360  1.00 80.18           C  
ATOM   1827  CE1 PHE B  62      -7.598 -14.761  56.209  1.00 77.48           C  
ATOM   1828  CE2 PHE B  62      -6.086 -16.081  54.902  1.00 79.21           C  
ATOM   1829  CZ  PHE B  62      -7.367 -15.805  55.326  1.00 78.60           C  
ATOM   1830  N   SER B  63      -2.082 -11.042  55.928  1.00 73.46           N  
ATOM   1831  CA  SER B  63      -0.784 -10.438  56.194  1.00 71.92           C  
ATOM   1832  C   SER B  63      -0.124  -9.977  54.905  1.00 70.45           C  
ATOM   1833  O   SER B  63      -0.451 -10.449  53.823  1.00 70.42           O  
ATOM   1834  CB  SER B  63       0.114 -11.451  56.908  1.00 71.84           C  
ATOM   1835  OG  SER B  63       1.324 -10.860  57.348  1.00 71.58           O  
ATOM   1836  N   MET B  64       0.811  -9.048  55.026  1.00 68.91           N  
ATOM   1837  CA  MET B  64       1.476  -8.486  53.869  1.00 67.82           C  
ATOM   1838  C   MET B  64       2.890  -8.046  54.217  1.00 66.96           C  
ATOM   1839  O   MET B  64       3.207  -7.801  55.368  1.00 66.90           O  
ATOM   1840  CB  MET B  64       0.663  -7.317  53.316  1.00 67.45           C  
ATOM   1841  CG  MET B  64       0.993  -5.967  53.884  1.00 67.31           C  
ATOM   1842  SD  MET B  64      -0.126  -4.724  53.250  1.00 66.89           S  
ATOM   1843  CE  MET B  64       0.983  -3.349  53.016  1.00 66.81           C  
ATOM   1844  N   ALA B  65       3.735  -7.947  53.205  1.00 66.25           N  
ATOM   1845  CA  ALA B  65       5.120  -7.540  53.389  1.00 65.69           C  
ATOM   1846  C   ALA B  65       5.703  -7.182  52.042  1.00 65.05           C  
ATOM   1847  O   ALA B  65       5.306  -7.745  51.038  1.00 65.02           O  
ATOM   1848  CB  ALA B  65       5.909  -8.665  53.997  1.00 65.61           C  
ATOM   1849  N   THR B  66       6.629  -6.237  52.007  1.00 64.52           N  
ATOM   1850  CA  THR B  66       7.381  -6.016  50.797  1.00 64.42           C  
ATOM   1851  C   THR B  66       8.788  -6.544  50.996  1.00 63.97           C  
ATOM   1852  O   THR B  66       9.410  -6.327  52.025  1.00 63.08           O  
ATOM   1853  CB  THR B  66       7.359  -4.557  50.341  1.00 64.27           C  
ATOM   1854  OG1 THR B  66       8.225  -3.777  51.157  1.00 65.19           O  
ATOM   1855  CG2 THR B  66       5.957  -4.011  50.418  1.00 63.97           C  
ATOM   1856  N   PHE B  67       9.258  -7.253  49.978  1.00 64.26           N  
ATOM   1857  CA  PHE B  67      10.452  -8.071  50.028  1.00 64.60           C  
ATOM   1858  C   PHE B  67      11.350  -7.494  48.946  1.00 64.78           C  
ATOM   1859  O   PHE B  67      10.978  -7.492  47.786  1.00 64.74           O  
ATOM   1860  CB  PHE B  67      10.016  -9.516  49.750  1.00 64.63           C  
ATOM   1861  CG  PHE B  67      11.135 -10.513  49.596  1.00 64.52           C  
ATOM   1862  CD1 PHE B  67      11.623 -11.205  50.693  1.00 61.79           C  
ATOM   1863  CD2 PHE B  67      11.648 -10.815  48.331  1.00 65.79           C  
ATOM   1864  CE1 PHE B  67      12.630 -12.151  50.546  1.00 62.98           C  
ATOM   1865  CE2 PHE B  67      12.671 -11.758  48.171  1.00 65.69           C  
ATOM   1866  CZ  PHE B  67      13.158 -12.427  49.284  1.00 65.10           C  
ATOM   1867  N   CYS B  68      12.504  -6.964  49.344  1.00 65.45           N  
ATOM   1868  CA  CYS B  68      13.414  -6.261  48.436  1.00 66.17           C  
ATOM   1869  C   CYS B  68      14.605  -7.086  48.026  1.00 67.13           C  
ATOM   1870  O   CYS B  68      15.380  -7.510  48.875  1.00 67.22           O  
ATOM   1871  CB  CYS B  68      13.969  -5.017  49.101  1.00 65.68           C  
ATOM   1872  SG  CYS B  68      12.722  -3.870  49.510  1.00 63.76           S  
ATOM   1873  N   MET B  69      14.747  -7.288  46.719  1.00 68.54           N  
ATOM   1874  CA  MET B  69      15.968  -7.810  46.121  1.00 69.58           C  
ATOM   1875  C   MET B  69      16.425  -6.829  45.065  1.00 70.17           C  
ATOM   1876  O   MET B  69      15.720  -6.591  44.088  1.00 70.31           O  
ATOM   1877  CB  MET B  69      15.719  -9.161  45.468  1.00 69.61           C  
ATOM   1878  CG  MET B  69      15.902 -10.326  46.407  1.00 70.54           C  
ATOM   1879  SD  MET B  69      15.802 -11.910  45.554  1.00 71.66           S  
ATOM   1880  CE  MET B  69      14.248 -11.691  44.659  1.00 72.14           C  
ATOM   1881  N   GLU B  70      17.584  -6.230  45.284  1.00 71.06           N  
ATOM   1882  CA  GLU B  70      18.245  -5.465  44.241  1.00 71.73           C  
ATOM   1883  C   GLU B  70      19.238  -6.372  43.513  1.00 72.10           C  
ATOM   1884  O   GLU B  70      19.998  -7.126  44.137  1.00 72.05           O  
ATOM   1885  CB  GLU B  70      18.994  -4.252  44.812  1.00 72.32           C  
ATOM   1886  CG  GLU B  70      18.177  -3.326  45.699  1.00 74.05           C  
ATOM   1887  CD  GLU B  70      16.901  -2.838  45.040  1.00 76.59           C  
ATOM   1888  OE1 GLU B  70      15.869  -2.752  45.747  1.00 78.59           O  
ATOM   1889  OE2 GLU B  70      16.927  -2.550  43.822  1.00 78.08           O  
ATOM   1890  N   GLN B  71      19.205  -6.300  42.186  1.00 72.23           N  
ATOM   1891  CA  GLN B  71      20.286  -6.792  41.333  1.00 72.12           C  
ATOM   1892  C   GLN B  71      21.677  -6.724  42.001  1.00 71.73           C  
ATOM   1893  O   GLN B  71      22.107  -5.658  42.461  1.00 71.76           O  
ATOM   1894  CB  GLN B  71      20.293  -5.989  40.014  1.00 72.95           C  
ATOM   1895  CG  GLN B  71      20.775  -4.489  40.096  1.00 74.90           C  
ATOM   1896  CD  GLN B  71      20.199  -3.676  41.284  1.00 77.12           C  
ATOM   1897  OE1 GLN B  71      18.969  -3.490  41.411  1.00 78.31           O  
ATOM   1898  NE2 GLN B  71      21.101  -3.175  42.148  1.00 77.37           N  
ATOM   1899  N   GLU B  72      22.355  -7.872  42.073  1.00 70.90           N  
ATOM   1900  CA  GLU B  72      23.773  -7.951  42.494  1.00 70.10           C  
ATOM   1901  C   GLU B  72      24.065  -7.574  43.962  1.00 68.80           C  
ATOM   1902  O   GLU B  72      25.210  -7.265  44.306  1.00 68.60           O  
ATOM   1903  CB  GLU B  72      24.689  -7.128  41.540  1.00 71.09           C  
ATOM   1904  CG  GLU B  72      25.077  -7.837  40.219  1.00 72.98           C  
ATOM   1905  CD  GLU B  72      26.029  -9.028  40.426  1.00 75.68           C  
ATOM   1906  OE1 GLU B  72      27.240  -8.805  40.676  1.00 77.55           O  
ATOM   1907  OE2 GLU B  72      25.562 -10.190  40.327  1.00 77.47           O  
ATOM   1908  N   GLN B  73      23.049  -7.613  44.821  1.00 67.07           N  
ATOM   1909  CA  GLN B  73      23.273  -7.493  46.259  1.00 65.50           C  
ATOM   1910  C   GLN B  73      23.178  -8.886  46.892  1.00 63.74           C  
ATOM   1911  O   GLN B  73      22.438  -9.742  46.423  1.00 63.13           O  
ATOM   1912  CB  GLN B  73      22.253  -6.548  46.917  1.00 65.76           C  
ATOM   1913  CG  GLN B  73      22.149  -5.129  46.346  1.00 66.16           C  
ATOM   1914  CD  GLN B  73      23.239  -4.178  46.825  1.00 66.75           C  
ATOM   1915  OE1 GLN B  73      24.406  -4.555  46.986  1.00 68.04           O  
ATOM   1916  NE2 GLN B  73      22.862  -2.930  47.040  1.00 66.28           N  
ATOM   1917  N   ASP B  74      23.924  -9.091  47.970  1.00 61.95           N  
ATOM   1918  CA  ASP B  74      23.883 -10.333  48.730  1.00 60.64           C  
ATOM   1919  C   ASP B  74      22.735 -10.430  49.734  1.00 59.05           C  
ATOM   1920  O   ASP B  74      22.546 -11.486  50.343  1.00 59.16           O  
ATOM   1921  CB  ASP B  74      25.194 -10.508  49.499  1.00 61.16           C  
ATOM   1922  CG  ASP B  74      26.371 -10.818  48.587  1.00 62.93           C  
ATOM   1923  OD1 ASP B  74      26.160 -10.982  47.354  1.00 65.45           O  
ATOM   1924  OD2 ASP B  74      27.513 -10.898  49.105  1.00 64.35           O  
ATOM   1925  N   PHE B  75      21.969  -9.359  49.919  1.00 56.81           N  
ATOM   1926  CA  PHE B  75      20.971  -9.325  50.989  1.00 55.35           C  
ATOM   1927  C   PHE B  75      19.591  -8.999  50.481  1.00 53.16           C  
ATOM   1928  O   PHE B  75      19.406  -8.575  49.339  1.00 53.20           O  
ATOM   1929  CB  PHE B  75      21.364  -8.305  52.049  1.00 54.82           C  
ATOM   1930  CG  PHE B  75      21.542  -6.926  51.514  1.00 53.38           C  
ATOM   1931  CD1 PHE B  75      20.456  -6.083  51.360  1.00 49.55           C  
ATOM   1932  CD2 PHE B  75      22.792  -6.472  51.154  1.00 53.92           C  
ATOM   1933  CE1 PHE B  75      20.613  -4.811  50.860  1.00 52.07           C  
ATOM   1934  CE2 PHE B  75      22.958  -5.196  50.644  1.00 54.79           C  
ATOM   1935  CZ  PHE B  75      21.869  -4.364  50.501  1.00 54.40           C  
ATOM   1936  N   VAL B  76      18.615  -9.208  51.348  1.00 51.21           N  
ATOM   1937  CA  VAL B  76      17.262  -8.748  51.094  1.00 49.47           C  
ATOM   1938  C   VAL B  76      16.777  -7.919  52.259  1.00 48.27           C  
ATOM   1939  O   VAL B  76      17.286  -8.023  53.368  1.00 47.43           O  
ATOM   1940  CB  VAL B  76      16.306  -9.900  50.825  1.00 49.64           C  
ATOM   1941  CG1 VAL B  76      16.865 -10.752  49.717  1.00 50.09           C  
ATOM   1942  CG2 VAL B  76      16.093 -10.734  52.064  1.00 49.87           C  
ATOM   1943  N   TRP B  77      15.806  -7.071  51.979  1.00 46.93           N  
ATOM   1944  CA  TRP B  77      15.262  -6.183  52.981  1.00 46.48           C  
ATOM   1945  C   TRP B  77      13.805  -6.502  53.154  1.00 46.74           C  
ATOM   1946  O   TRP B  77      13.040  -6.442  52.193  1.00 46.64           O  
ATOM   1947  CB  TRP B  77      15.410  -4.722  52.570  1.00 47.72           C  
ATOM   1948  CG  TRP B  77      16.316  -3.934  53.438  1.00 50.29           C  
ATOM   1949  CD1 TRP B  77      17.600  -3.587  53.164  1.00 49.62           C  
ATOM   1950  CD2 TRP B  77      16.001  -3.351  54.708  1.00 41.31           C  
ATOM   1951  NE1 TRP B  77      18.117  -2.833  54.192  1.00 49.47           N  
ATOM   1952  CE2 TRP B  77      17.156  -2.672  55.153  1.00 39.17           C  
ATOM   1953  CE3 TRP B  77      14.853  -3.343  55.517  1.00 39.41           C  
ATOM   1954  CZ2 TRP B  77      17.210  -2.005  56.377  1.00 42.71           C  
ATOM   1955  CZ3 TRP B  77      14.898  -2.676  56.731  1.00 34.66           C  
ATOM   1956  CH2 TRP B  77      16.072  -2.014  57.152  1.00 35.85           C  
ATOM   1957  N   LEU B  78      13.431  -6.854  54.378  1.00 47.68           N  
ATOM   1958  CA  LEU B  78      12.035  -7.015  54.734  1.00 48.22           C  
ATOM   1959  C   LEU B  78      11.535  -5.644  55.177  1.00 48.44           C  
ATOM   1960  O   LEU B  78      12.145  -5.001  56.012  1.00 48.31           O  
ATOM   1961  CB  LEU B  78      11.890  -8.055  55.840  1.00 48.17           C  
ATOM   1962  CG  LEU B  78      10.451  -8.474  56.127  1.00 48.32           C  
ATOM   1963  CD1 LEU B  78       9.862  -9.234  54.949  1.00 48.57           C  
ATOM   1964  CD2 LEU B  78      10.396  -9.304  57.412  1.00 48.57           C  
ATOM   1965  N   LYS B  79      10.449  -5.183  54.580  1.00 49.28           N  
ATOM   1966  CA  LYS B  79       9.922  -3.851  54.875  1.00 50.16           C  
ATOM   1967  C   LYS B  79       8.398  -3.871  54.903  1.00 50.54           C  
ATOM   1968  O   LYS B  79       7.768  -4.639  54.179  1.00 50.14           O  
ATOM   1969  CB  LYS B  79      10.403  -2.827  53.833  1.00 50.30           C  
ATOM   1970  CG  LYS B  79      11.849  -2.366  53.996  1.00 50.41           C  
ATOM   1971  CD  LYS B  79      12.218  -1.347  52.907  1.00 50.60           C  
ATOM   1972  CE  LYS B  79      13.688  -0.892  52.982  1.00 51.71           C  
ATOM   1973  NZ  LYS B  79      13.987   0.008  54.177  1.00 53.44           N  
ATOM   1974  N   ARG B  80       7.820  -3.018  55.743  1.00 51.29           N  
ATOM   1975  CA  ARG B  80       6.372  -2.820  55.778  1.00 52.08           C  
ATOM   1976  C   ARG B  80       5.646  -4.144  55.938  1.00 52.10           C  
ATOM   1977  O   ARG B  80       4.699  -4.448  55.225  1.00 51.80           O  
ATOM   1978  CB  ARG B  80       5.916  -2.060  54.535  1.00 52.23           C  
ATOM   1979  CG  ARG B  80       6.602  -0.683  54.414  1.00 53.13           C  
ATOM   1980  CD  ARG B  80       6.199   0.067  53.136  1.00 53.78           C  
ATOM   1981  NE  ARG B  80       7.014  -0.350  51.995  1.00 54.94           N  
ATOM   1982  CZ  ARG B  80       8.198   0.178  51.675  1.00 55.19           C  
ATOM   1983  NH1 ARG B  80       8.733   1.153  52.395  1.00 54.76           N  
ATOM   1984  NH2 ARG B  80       8.862  -0.282  50.620  1.00 55.63           N  
ATOM   1985  N   PHE B  81       6.128  -4.918  56.904  1.00 52.79           N  
ATOM   1986  CA  PHE B  81       5.571  -6.219  57.265  1.00 53.39           C  
ATOM   1987  C   PHE B  81       4.425  -6.001  58.258  1.00 54.39           C  
ATOM   1988  O   PHE B  81       4.599  -5.334  59.265  1.00 54.46           O  
ATOM   1989  CB  PHE B  81       6.705  -7.055  57.873  1.00 52.91           C  
ATOM   1990  CG  PHE B  81       6.322  -8.436  58.300  1.00 52.70           C  
ATOM   1991  CD1 PHE B  81       7.040  -9.057  59.315  1.00 54.96           C  
ATOM   1992  CD2 PHE B  81       5.279  -9.127  57.711  1.00 50.43           C  
ATOM   1993  CE1 PHE B  81       6.729 -10.329  59.730  1.00 55.28           C  
ATOM   1994  CE2 PHE B  81       4.960 -10.405  58.128  1.00 51.00           C  
ATOM   1995  CZ  PHE B  81       5.693 -11.006  59.138  1.00 52.43           C  
ATOM   1996  N   ALA B  82       3.246  -6.538  57.970  1.00 55.55           N  
ATOM   1997  CA  ALA B  82       2.107  -6.353  58.862  1.00 56.70           C  
ATOM   1998  C   ALA B  82       1.183  -7.533  58.772  1.00 57.80           C  
ATOM   1999  O   ALA B  82       0.939  -8.030  57.693  1.00 58.25           O  
ATOM   2000  CB  ALA B  82       1.354  -5.090  58.496  1.00 56.63           C  
ATOM   2001  N   THR B  83       0.679  -7.982  59.911  1.00 59.28           N  
ATOM   2002  CA  THR B  83      -0.346  -9.020  59.977  1.00 60.21           C  
ATOM   2003  C   THR B  83      -1.559  -8.348  60.594  1.00 61.43           C  
ATOM   2004  O   THR B  83      -1.407  -7.517  61.486  1.00 61.58           O  
ATOM   2005  CB  THR B  83       0.120 -10.191  60.854  1.00 60.10           C  
ATOM   2006  OG1 THR B  83       1.392 -10.650  60.391  1.00 60.13           O  
ATOM   2007  CG2 THR B  83      -0.872 -11.345  60.825  1.00 59.88           C  
ATOM   2008  N   SER B  84      -2.760  -8.670  60.127  1.00 62.98           N  
ATOM   2009  CA  SER B  84      -3.950  -8.011  60.672  1.00 64.13           C  
ATOM   2010  C   SER B  84      -4.118  -8.500  62.103  1.00 65.26           C  
ATOM   2011  O   SER B  84      -3.790  -9.653  62.402  1.00 65.52           O  
ATOM   2012  CB  SER B  84      -5.212  -8.288  59.846  1.00 64.24           C  
ATOM   2013  OG  SER B  84      -5.994  -9.307  60.438  1.00 64.61           O  
ATOM   2014  N   PRO B  85      -4.642  -7.638  62.987  1.00 66.59           N  
ATOM   2015  CA  PRO B  85      -4.644  -7.940  64.429  1.00 67.30           C  
ATOM   2016  C   PRO B  85      -5.432  -9.213  64.714  1.00 68.13           C  
ATOM   2017  O   PRO B  85      -5.074 -10.008  65.593  1.00 67.61           O  
ATOM   2018  CB  PRO B  85      -5.337  -6.718  65.046  1.00 67.41           C  
ATOM   2019  CG  PRO B  85      -6.128  -6.086  63.911  1.00 67.33           C  
ATOM   2020  CD  PRO B  85      -5.322  -6.363  62.674  1.00 66.87           C  
ATOM   2021  N   ASN B  86      -6.494  -9.370  63.927  1.00 69.25           N  
ATOM   2022  CA  ASN B  86      -7.369 -10.526  63.934  1.00 70.09           C  
ATOM   2023  C   ASN B  86      -6.655 -11.875  63.788  1.00 70.61           C  
ATOM   2024  O   ASN B  86      -7.073 -12.866  64.389  1.00 70.52           O  
ATOM   2025  CB  ASN B  86      -8.369 -10.355  62.793  1.00 70.67           C  
ATOM   2026  CG  ASN B  86      -9.586 -11.220  62.955  1.00 72.62           C  
ATOM   2027  OD1 ASN B  86     -10.697 -10.715  63.143  1.00 75.11           O  
ATOM   2028  ND2 ASN B  86      -9.392 -12.537  62.903  1.00 74.63           N  
ATOM   2029  N   TYR B  87      -5.585 -11.910  62.992  1.00 71.23           N  
ATOM   2030  CA  TYR B  87      -4.914 -13.172  62.645  1.00 71.51           C  
ATOM   2031  C   TYR B  87      -3.513 -13.328  63.251  1.00 71.63           C  
ATOM   2032  O   TYR B  87      -2.809 -14.307  62.967  1.00 71.66           O  
ATOM   2033  CB  TYR B  87      -4.881 -13.344  61.119  1.00 72.24           C  
ATOM   2034  CG  TYR B  87      -6.262 -13.288  60.505  1.00 71.94           C  
ATOM   2035  CD1 TYR B  87      -7.122 -14.383  60.579  1.00 77.06           C  
ATOM   2036  CD2 TYR B  87      -6.718 -12.135  59.874  1.00 69.11           C  
ATOM   2037  CE1 TYR B  87      -8.408 -14.330  60.029  1.00 76.35           C  
ATOM   2038  CE2 TYR B  87      -7.998 -12.065  59.319  1.00 70.04           C  
ATOM   2039  CZ  TYR B  87      -8.839 -13.168  59.398  1.00 72.69           C  
ATOM   2040  OH  TYR B  87     -10.104 -13.113  58.845  1.00 73.04           O  
ATOM   2041  N   ILE B  88      -3.119 -12.382  64.098  1.00 71.52           N  
ATOM   2042  CA  ILE B  88      -1.884 -12.528  64.862  1.00 71.58           C  
ATOM   2043  C   ILE B  88      -1.968 -13.794  65.718  1.00 71.60           C  
ATOM   2044  O   ILE B  88      -0.981 -14.524  65.865  1.00 71.71           O  
ATOM   2045  CB  ILE B  88      -1.615 -11.297  65.762  1.00 71.56           C  
ATOM   2046  CG1 ILE B  88      -1.306 -10.069  64.896  1.00 71.75           C  
ATOM   2047  CG2 ILE B  88      -0.455 -11.571  66.718  1.00 71.42           C  
ATOM   2048  CD1 ILE B  88      -1.267  -8.752  65.660  1.00 71.79           C  
ATOM   2049  N   ALA B  89      -3.156 -14.053  66.261  1.00 71.52           N  
ATOM   2050  CA  ALA B  89      -3.389 -15.212  67.115  1.00 71.35           C  
ATOM   2051  C   ALA B  89      -3.065 -16.502  66.385  1.00 71.18           C  
ATOM   2052  O   ALA B  89      -2.534 -17.437  66.986  1.00 71.00           O  
ATOM   2053  CB  ALA B  89      -4.825 -15.230  67.599  1.00 71.47           C  
ATOM   2054  N   LYS B  90      -3.365 -16.527  65.084  1.00 71.08           N  
ATOM   2055  CA  LYS B  90      -3.133 -17.708  64.232  1.00 70.79           C  
ATOM   2056  C   LYS B  90      -1.661 -17.910  63.844  1.00 70.40           C  
ATOM   2057  O   LYS B  90      -1.297 -18.971  63.329  1.00 70.50           O  
ATOM   2058  CB  LYS B  90      -3.955 -17.620  62.944  1.00 71.10           C  
ATOM   2059  CG  LYS B  90      -5.428 -17.294  63.123  1.00 71.77           C  
ATOM   2060  CD  LYS B  90      -6.193 -18.453  63.715  1.00 72.12           C  
ATOM   2061  CE  LYS B  90      -7.670 -18.115  63.818  1.00 72.05           C  
ATOM   2062  NZ  LYS B  90      -8.403 -19.179  64.546  1.00 72.32           N  
ATOM   2063  N   GLY B  91      -0.829 -16.894  64.071  1.00 69.70           N  
ATOM   2064  CA  GLY B  91       0.586 -16.955  63.696  1.00 69.02           C  
ATOM   2065  C   GLY B  91       0.791 -16.846  62.193  1.00 68.31           C  
ATOM   2066  O   GLY B  91       1.773 -17.351  61.654  1.00 68.35           O  
ATOM   2067  N   TYR B  92      -0.142 -16.184  61.517  1.00 67.27           N  
ATOM   2068  CA  TYR B  92      -0.086 -16.064  60.072  1.00 66.55           C  
ATOM   2069  C   TYR B  92       1.039 -15.149  59.612  1.00 65.88           C  
ATOM   2070  O   TYR B  92       1.549 -15.317  58.505  1.00 65.93           O  
ATOM   2071  CB  TYR B  92      -1.433 -15.598  59.516  1.00 66.08           C  
ATOM   2072  CG  TYR B  92      -2.530 -16.649  59.556  1.00 65.70           C  
ATOM   2073  CD1 TYR B  92      -2.255 -17.979  59.916  1.00 66.08           C  
ATOM   2074  CD2 TYR B  92      -3.843 -16.322  59.196  1.00 66.46           C  
ATOM   2075  CE1 TYR B  92      -3.254 -18.941  59.934  1.00 65.71           C  
ATOM   2076  CE2 TYR B  92      -4.857 -17.276  59.214  1.00 66.30           C  
ATOM   2077  CZ  TYR B  92      -4.556 -18.589  59.583  1.00 65.76           C  
ATOM   2078  OH  TYR B  92      -5.543 -19.559  59.608  1.00 67.53           O  
ATOM   2079  N   GLY B  93       1.425 -14.195  60.454  1.00 65.04           N  
ATOM   2080  CA  GLY B  93       2.630 -13.401  60.220  1.00 64.24           C  
ATOM   2081  C   GLY B  93       3.849 -14.287  60.056  1.00 63.46           C  
ATOM   2082  O   GLY B  93       4.659 -14.070  59.167  1.00 63.13           O  
ATOM   2083  N   SER B  94       3.966 -15.299  60.910  1.00 62.83           N  
ATOM   2084  CA  SER B  94       5.049 -16.277  60.805  1.00 62.39           C  
ATOM   2085  C   SER B  94       5.040 -17.077  59.499  1.00 61.93           C  
ATOM   2086  O   SER B  94       6.104 -17.404  58.960  1.00 61.64           O  
ATOM   2087  CB  SER B  94       5.028 -17.245  61.985  1.00 62.29           C  
ATOM   2088  OG  SER B  94       6.197 -17.094  62.758  1.00 62.42           O  
ATOM   2089  N   LEU B  95       3.851 -17.403  58.999  1.00 61.45           N  
ATOM   2090  CA  LEU B  95       3.745 -18.111  57.724  1.00 61.08           C  
ATOM   2091  C   LEU B  95       4.336 -17.295  56.582  1.00 60.47           C  
ATOM   2092  O   LEU B  95       5.157 -17.796  55.814  1.00 60.24           O  
ATOM   2093  CB  LEU B  95       2.287 -18.449  57.402  1.00 61.39           C  
ATOM   2094  CG  LEU B  95       1.584 -19.459  58.317  1.00 61.93           C  
ATOM   2095  CD1 LEU B  95       0.207 -19.789  57.744  1.00 62.37           C  
ATOM   2096  CD2 LEU B  95       2.415 -20.723  58.500  1.00 61.83           C  
ATOM   2097  N   LEU B  96       3.910 -16.041  56.470  1.00 59.75           N  
ATOM   2098  CA  LEU B  96       4.403 -15.172  55.417  1.00 59.55           C  
ATOM   2099  C   LEU B  96       5.917 -15.004  55.520  1.00 59.27           C  
ATOM   2100  O   LEU B  96       6.646 -15.159  54.546  1.00 59.23           O  
ATOM   2101  CB  LEU B  96       3.724 -13.809  55.484  1.00 59.25           C  
ATOM   2102  CG  LEU B  96       4.110 -12.829  54.379  1.00 59.26           C  
ATOM   2103  CD1 LEU B  96       4.068 -13.511  53.032  1.00 59.32           C  
ATOM   2104  CD2 LEU B  96       3.201 -11.614  54.378  1.00 59.34           C  
ATOM   2105  N   PHE B  97       6.388 -14.702  56.715  1.00 59.01           N  
ATOM   2106  CA  PHE B  97       7.803 -14.515  56.922  1.00 58.90           C  
ATOM   2107  C   PHE B  97       8.625 -15.722  56.455  1.00 59.12           C  
ATOM   2108  O   PHE B  97       9.548 -15.567  55.668  1.00 59.06           O  
ATOM   2109  CB  PHE B  97       8.098 -14.220  58.385  1.00 58.02           C  
ATOM   2110  CG  PHE B  97       9.530 -14.299  58.707  1.00 57.54           C  
ATOM   2111  CD1 PHE B  97      10.347 -13.209  58.513  1.00 51.02           C  
ATOM   2112  CD2 PHE B  97      10.081 -15.485  59.150  1.00 60.47           C  
ATOM   2113  CE1 PHE B  97      11.697 -13.284  58.777  1.00 52.68           C  
ATOM   2114  CE2 PHE B  97      11.423 -15.573  59.422  1.00 61.29           C  
ATOM   2115  CZ  PHE B  97      12.240 -14.468  59.232  1.00 57.78           C  
ATOM   2116  N   HIS B  98       8.299 -16.916  56.941  1.00 59.61           N  
ATOM   2117  CA  HIS B  98       9.077 -18.119  56.600  1.00 59.97           C  
ATOM   2118  C   HIS B  98       9.038 -18.452  55.114  1.00 60.18           C  
ATOM   2119  O   HIS B  98       9.936 -19.107  54.598  1.00 59.92           O  
ATOM   2120  CB  HIS B  98       8.624 -19.330  57.419  1.00 59.99           C  
ATOM   2121  CG  HIS B  98       9.180 -19.344  58.803  1.00 60.42           C  
ATOM   2122  ND1 HIS B  98       8.433 -19.006  59.910  1.00 61.05           N  
ATOM   2123  CD2 HIS B  98      10.426 -19.618  59.259  1.00 61.34           C  
ATOM   2124  CE1 HIS B  98       9.191 -19.089  60.991  1.00 61.77           C  
ATOM   2125  NE2 HIS B  98      10.407 -19.455  60.624  1.00 61.64           N  
ATOM   2126  N   GLU B  99       7.997 -17.994  54.433  1.00 60.98           N  
ATOM   2127  CA  GLU B  99       7.883 -18.166  52.995  1.00 61.21           C  
ATOM   2128  C   GLU B  99       8.868 -17.262  52.266  1.00 61.52           C  
ATOM   2129  O   GLU B  99       9.571 -17.701  51.345  1.00 61.58           O  
ATOM   2130  CB  GLU B  99       6.462 -17.839  52.545  1.00 61.45           C  
ATOM   2131  CG  GLU B  99       6.170 -18.184  51.095  1.00 62.37           C  
ATOM   2132  CD  GLU B  99       6.359 -19.664  50.777  1.00 65.07           C  
ATOM   2133  OE1 GLU B  99       6.328 -20.507  51.710  1.00 65.96           O  
ATOM   2134  OE2 GLU B  99       6.536 -19.973  49.577  1.00 67.08           O  
ATOM   2135  N   LEU B 100       8.913 -16.000  52.689  1.00 61.61           N  
ATOM   2136  CA  LEU B 100       9.825 -15.023  52.103  1.00 61.76           C  
ATOM   2137  C   LEU B 100      11.281 -15.366  52.384  1.00 61.94           C  
ATOM   2138  O   LEU B 100      12.136 -15.110  51.563  1.00 61.94           O  
ATOM   2139  CB  LEU B 100       9.498 -13.620  52.603  1.00 61.22           C  
ATOM   2140  CG  LEU B 100       8.100 -13.116  52.242  1.00 60.60           C  
ATOM   2141  CD1 LEU B 100       7.925 -11.698  52.722  1.00 60.29           C  
ATOM   2142  CD2 LEU B 100       7.845 -13.198  50.748  1.00 60.46           C  
ATOM   2143  N   GLU B 101      11.555 -15.950  53.539  1.00 62.64           N  
ATOM   2144  CA  GLU B 101      12.902 -16.360  53.891  1.00 63.56           C  
ATOM   2145  C   GLU B 101      13.322 -17.558  53.060  1.00 64.37           C  
ATOM   2146  O   GLU B 101      14.483 -17.688  52.670  1.00 64.17           O  
ATOM   2147  CB  GLU B 101      12.949 -16.725  55.367  1.00 63.34           C  
ATOM   2148  CG  GLU B 101      14.257 -17.311  55.852  1.00 63.15           C  
ATOM   2149  CD  GLU B 101      14.205 -17.603  57.331  1.00 63.92           C  
ATOM   2150  OE1 GLU B 101      13.336 -18.404  57.747  1.00 65.28           O  
ATOM   2151  OE2 GLU B 101      15.010 -17.021  58.086  1.00 64.01           O  
ATOM   2152  N   LYS B 102      12.365 -18.443  52.818  1.00 65.47           N  
ATOM   2153  CA  LYS B 102      12.588 -19.606  51.990  1.00 66.52           C  
ATOM   2154  C   LYS B 102      12.963 -19.098  50.598  1.00 67.04           C  
ATOM   2155  O   LYS B 102      13.951 -19.539  50.015  1.00 67.07           O  
ATOM   2156  CB  LYS B 102      11.323 -20.484  51.943  1.00 66.82           C  
ATOM   2157  CG  LYS B 102      11.564 -21.982  52.186  1.00 67.68           C  
ATOM   2158  CD  LYS B 102      10.279 -22.735  52.653  1.00 68.03           C  
ATOM   2159  CE  LYS B 102      10.284 -23.144  54.166  1.00 69.12           C  
ATOM   2160  NZ  LYS B 102       9.733 -22.122  55.127  1.00 69.25           N  
ATOM   2161  N   ARG B 103      12.182 -18.148  50.094  1.00 67.67           N  
ATOM   2162  CA  ARG B 103      12.461 -17.505  48.819  1.00 68.14           C  
ATOM   2163  C   ARG B 103      13.874 -16.924  48.758  1.00 68.18           C  
ATOM   2164  O   ARG B 103      14.645 -17.259  47.873  1.00 68.42           O  
ATOM   2165  CB  ARG B 103      11.431 -16.406  48.551  1.00 68.18           C  
ATOM   2166  CG  ARG B 103      11.599 -15.699  47.215  1.00 68.68           C  
ATOM   2167  CD  ARG B 103      10.459 -14.737  46.932  1.00 70.71           C  
ATOM   2168  NE  ARG B 103       9.408 -15.299  46.075  1.00 72.28           N  
ATOM   2169  CZ  ARG B 103       8.301 -15.929  46.493  1.00 73.49           C  
ATOM   2170  NH1 ARG B 103       7.429 -16.367  45.593  1.00 74.18           N  
ATOM   2171  NH2 ARG B 103       8.041 -16.133  47.785  1.00 73.85           N  
ATOM   2172  N   ALA B 104      14.212 -16.064  49.707  1.00 68.33           N  
ATOM   2173  CA  ALA B 104      15.527 -15.429  49.742  1.00 68.52           C  
ATOM   2174  C   ALA B 104      16.662 -16.436  49.722  1.00 68.68           C  
ATOM   2175  O   ALA B 104      17.650 -16.243  49.024  1.00 68.61           O  
ATOM   2176  CB  ALA B 104      15.653 -14.555  50.971  1.00 68.40           C  
ATOM   2177  N   VAL B 105      16.523 -17.501  50.506  1.00 69.23           N  
ATOM   2178  CA  VAL B 105      17.583 -18.512  50.652  1.00 69.49           C  
ATOM   2179  C   VAL B 105      17.878 -19.227  49.338  1.00 69.67           C  
ATOM   2180  O   VAL B 105      19.029 -19.533  49.045  1.00 69.50           O  
ATOM   2181  CB  VAL B 105      17.236 -19.553  51.750  1.00 69.49           C  
ATOM   2182  CG1 VAL B 105      18.076 -20.811  51.613  1.00 69.89           C  
ATOM   2183  CG2 VAL B 105      17.442 -18.960  53.129  1.00 69.33           C  
ATOM   2184  N   TRP B 106      16.835 -19.471  48.555  1.00 70.04           N  
ATOM   2185  CA  TRP B 106      16.974 -20.159  47.276  1.00 70.40           C  
ATOM   2186  C   TRP B 106      17.220 -19.205  46.080  1.00 70.27           C  
ATOM   2187  O   TRP B 106      17.161 -19.620  44.919  1.00 70.58           O  
ATOM   2188  CB  TRP B 106      15.744 -21.047  47.035  1.00 72.11           C  
ATOM   2189  CG  TRP B 106      15.675 -22.278  47.935  1.00 73.62           C  
ATOM   2190  CD1 TRP B 106      15.433 -22.300  49.290  1.00 71.01           C  
ATOM   2191  CD2 TRP B 106      15.828 -23.652  47.536  1.00 74.15           C  
ATOM   2192  NE1 TRP B 106      15.442 -23.598  49.758  1.00 74.66           N  
ATOM   2193  CE2 TRP B 106      15.681 -24.449  48.710  1.00 73.46           C  
ATOM   2194  CE3 TRP B 106      16.078 -24.290  46.306  1.00 72.23           C  
ATOM   2195  CZ2 TRP B 106      15.764 -25.854  48.692  1.00 73.01           C  
ATOM   2196  CZ3 TRP B 106      16.177 -25.697  46.287  1.00 73.59           C  
ATOM   2197  CH2 TRP B 106      16.023 -26.460  47.483  1.00 73.70           C  
ATOM   2198  N   GLU B 107      17.484 -17.932  46.369  1.00 69.49           N  
ATOM   2199  CA  GLU B 107      17.971 -16.970  45.381  1.00 68.68           C  
ATOM   2200  C   GLU B 107      19.425 -16.638  45.732  1.00 67.89           C  
ATOM   2201  O   GLU B 107      19.986 -15.648  45.259  1.00 67.97           O  
ATOM   2202  CB  GLU B 107      17.130 -15.696  45.417  1.00 68.97           C  
ATOM   2203  CG  GLU B 107      15.625 -15.914  45.318  1.00 70.35           C  
ATOM   2204  CD  GLU B 107      15.070 -15.585  43.947  1.00 72.52           C  
ATOM   2205  OE1 GLU B 107      15.722 -15.959  42.951  1.00 74.15           O  
ATOM   2206  OE2 GLU B 107      13.983 -14.956  43.865  1.00 73.44           O  
ATOM   2207  N   GLY B 108      20.025 -17.461  46.591  1.00 66.74           N  
ATOM   2208  CA  GLY B 108      21.426 -17.317  46.961  1.00 65.87           C  
ATOM   2209  C   GLY B 108      21.736 -16.193  47.927  1.00 65.02           C  
ATOM   2210  O   GLY B 108      22.900 -15.847  48.107  1.00 64.90           O  
ATOM   2211  N   ARG B 109      20.714 -15.641  48.579  1.00 63.98           N  
ATOM   2212  CA  ARG B 109      20.923 -14.468  49.427  1.00 63.07           C  
ATOM   2213  C   ARG B 109      21.470 -14.889  50.783  1.00 61.83           C  
ATOM   2214  O   ARG B 109      21.096 -15.933  51.301  1.00 61.99           O  
ATOM   2215  CB  ARG B 109      19.629 -13.657  49.549  1.00 63.51           C  
ATOM   2216  CG  ARG B 109      18.942 -13.353  48.193  1.00 64.79           C  
ATOM   2217  CD  ARG B 109      19.877 -12.696  47.165  1.00 67.00           C  
ATOM   2218  NE  ARG B 109      19.771 -11.238  47.168  1.00 67.72           N  
ATOM   2219  CZ  ARG B 109      19.629 -10.468  46.085  1.00 68.35           C  
ATOM   2220  NH1 ARG B 109      19.618 -10.984  44.859  1.00 68.95           N  
ATOM   2221  NH2 ARG B 109      19.537  -9.155  46.224  1.00 68.36           N  
ATOM   2222  N   ARG B 110      22.377 -14.088  51.335  1.00 60.30           N  
ATOM   2223  CA  ARG B 110      23.074 -14.427  52.582  1.00 59.49           C  
ATOM   2224  C   ARG B 110      22.541 -13.729  53.833  1.00 57.44           C  
ATOM   2225  O   ARG B 110      22.732 -14.223  54.940  1.00 57.37           O  
ATOM   2226  CB  ARG B 110      24.549 -14.047  52.472  1.00 59.93           C  
ATOM   2227  CG  ARG B 110      25.315 -14.688  51.321  1.00 61.91           C  
ATOM   2228  CD  ARG B 110      26.822 -14.378  51.415  1.00 63.60           C  
ATOM   2229  NE  ARG B 110      27.110 -12.934  51.376  1.00 66.73           N  
ATOM   2230  CZ  ARG B 110      27.218 -12.129  52.444  1.00 68.19           C  
ATOM   2231  NH1 ARG B 110      27.077 -12.595  53.687  1.00 68.21           N  
ATOM   2232  NH2 ARG B 110      27.472 -10.832  52.269  1.00 68.41           N  
ATOM   2233  N   LYS B 111      21.953 -12.547  53.663  1.00 55.18           N  
ATOM   2234  CA  LYS B 111      21.492 -11.734  54.783  1.00 53.23           C  
ATOM   2235  C   LYS B 111      20.076 -11.228  54.513  1.00 51.35           C  
ATOM   2236  O   LYS B 111      19.666 -11.094  53.357  1.00 50.99           O  
ATOM   2237  CB  LYS B 111      22.432 -10.548  55.035  1.00 52.92           C  
ATOM   2238  CG  LYS B 111      23.815 -10.914  55.519  1.00 52.58           C  
ATOM   2239  CD  LYS B 111      24.685  -9.675  55.769  1.00 52.97           C  
ATOM   2240  CE  LYS B 111      24.988  -8.913  54.474  1.00 53.14           C  
ATOM   2241  NZ  LYS B 111      25.788  -7.656  54.618  1.00 52.86           N  
ATOM   2242  N   MET B 112      19.338 -10.990  55.599  1.00 49.19           N  
ATOM   2243  CA  MET B 112      18.012 -10.360  55.564  1.00 47.62           C  
ATOM   2244  C   MET B 112      17.995  -9.280  56.624  1.00 45.67           C  
ATOM   2245  O   MET B 112      18.312  -9.543  57.770  1.00 44.94           O  
ATOM   2246  CB  MET B 112      16.926 -11.397  55.825  1.00 47.53           C  
ATOM   2247  CG  MET B 112      15.536 -10.844  56.120  1.00 48.06           C  
ATOM   2248  SD  MET B 112      14.170 -12.023  55.864  1.00 47.27           S  
ATOM   2249  CE  MET B 112      14.991 -13.588  56.066  1.00 47.12           C  
ATOM   2250  N   TYR B 113      17.681  -8.060  56.207  1.00 44.01           N  
ATOM   2251  CA  TYR B 113      17.573  -6.926  57.104  1.00 43.26           C  
ATOM   2252  C   TYR B 113      16.106  -6.618  57.390  1.00 42.42           C  
ATOM   2253  O   TYR B 113      15.235  -6.865  56.561  1.00 41.85           O  
ATOM   2254  CB  TYR B 113      18.263  -5.690  56.513  1.00 42.40           C  
ATOM   2255  CG  TYR B 113      19.772  -5.799  56.488  1.00 41.49           C  
ATOM   2256  CD1 TYR B 113      20.514  -5.563  57.632  1.00 45.28           C  
ATOM   2257  CD2 TYR B 113      20.457  -6.153  55.323  1.00 38.43           C  
ATOM   2258  CE1 TYR B 113      21.900  -5.679  57.626  1.00 44.68           C  
ATOM   2259  CE2 TYR B 113      21.840  -6.285  55.315  1.00 38.27           C  
ATOM   2260  CZ  TYR B 113      22.557  -6.044  56.461  1.00 40.88           C  
ATOM   2261  OH  TYR B 113      23.937  -6.152  56.481  1.00 42.02           O  
ATOM   2262  N   ALA B 114      15.845  -6.078  58.575  1.00 42.00           N  
ATOM   2263  CA  ALA B 114      14.504  -5.640  58.949  1.00 41.94           C  
ATOM   2264  C   ALA B 114      14.601  -4.564  60.008  1.00 41.77           C  
ATOM   2265  O   ALA B 114      15.610  -4.436  60.694  1.00 41.71           O  
ATOM   2266  CB  ALA B 114      13.669  -6.798  59.452  1.00 41.53           C  
ATOM   2267  N   GLN B 115      13.542  -3.778  60.125  1.00 41.80           N  
ATOM   2268  CA  GLN B 115      13.510  -2.681  61.068  1.00 41.96           C  
ATOM   2269  C   GLN B 115      12.170  -2.668  61.808  1.00 42.08           C  
ATOM   2270  O   GLN B 115      11.154  -3.124  61.284  1.00 42.10           O  
ATOM   2271  CB  GLN B 115      13.750  -1.357  60.334  1.00 41.72           C  
ATOM   2272  CG  GLN B 115      14.007  -0.193  61.278  1.00 41.98           C  
ATOM   2273  CD  GLN B 115      14.400   1.095  60.576  1.00 42.12           C  
ATOM   2274  OE1 GLN B 115      15.363   1.752  60.976  1.00 43.44           O  
ATOM   2275  NE2 GLN B 115      13.652   1.475  59.551  1.00 41.68           N  
ATOM   2276  N   THR B 116      12.185  -2.173  63.040  1.00 42.37           N  
ATOM   2277  CA  THR B 116      10.954  -1.880  63.779  1.00 42.42           C  
ATOM   2278  C   THR B 116      11.217  -0.767  64.788  1.00 42.34           C  
ATOM   2279  O   THR B 116      12.365  -0.483  65.110  1.00 41.95           O  
ATOM   2280  CB  THR B 116      10.424  -3.129  64.493  1.00 42.55           C  
ATOM   2281  OG1 THR B 116       9.060  -2.919  64.888  1.00 43.51           O  
ATOM   2282  CG2 THR B 116      11.269  -3.475  65.713  1.00 42.20           C  
ATOM   2283  N   ASN B 117      10.160  -0.131  65.284  1.00 42.78           N  
ATOM   2284  CA  ASN B 117      10.320   0.926  66.295  1.00 42.91           C  
ATOM   2285  C   ASN B 117      10.606   0.339  67.681  1.00 42.89           C  
ATOM   2286  O   ASN B 117      10.262  -0.804  67.958  1.00 42.15           O  
ATOM   2287  CB  ASN B 117       9.091   1.824  66.335  1.00 42.91           C  
ATOM   2288  CG  ASN B 117       9.312   3.070  67.168  1.00 43.09           C  
ATOM   2289  OD1 ASN B 117       8.925   3.123  68.334  1.00 43.96           O  
ATOM   2290  ND2 ASN B 117       9.953   4.067  66.583  1.00 43.18           N  
ATOM   2291  N   HIS B 118      11.264   1.114  68.539  1.00 43.64           N  
ATOM   2292  CA  HIS B 118      11.551   0.666  69.915  1.00 44.09           C  
ATOM   2293  C   HIS B 118      10.292   0.317  70.718  1.00 44.01           C  
ATOM   2294  O   HIS B 118      10.343  -0.509  71.612  1.00 44.09           O  
ATOM   2295  CB  HIS B 118      12.416   1.680  70.659  1.00 44.49           C  
ATOM   2296  CG  HIS B 118      11.735   2.980  70.946  1.00 46.13           C  
ATOM   2297  ND1 HIS B 118      11.038   3.212  72.112  1.00 47.79           N  
ATOM   2298  CD2 HIS B 118      11.683   4.136  70.246  1.00 47.07           C  
ATOM   2299  CE1 HIS B 118      10.572   4.447  72.107  1.00 48.04           C  
ATOM   2300  NE2 HIS B 118      10.949   5.028  70.984  1.00 47.87           N  
ATOM   2301  N   THR B 119       9.159   0.894  70.341  1.00 44.24           N  
ATOM   2302  CA  THR B 119       7.873   0.603  70.972  1.00 44.40           C  
ATOM   2303  C   THR B 119       7.229  -0.721  70.549  1.00 44.65           C  
ATOM   2304  O   THR B 119       6.281  -1.171  71.174  1.00 44.89           O  
ATOM   2305  CB  THR B 119       6.870   1.728  70.673  1.00 44.42           C  
ATOM   2306  OG1 THR B 119       6.637   1.803  69.264  1.00 44.55           O  
ATOM   2307  CG2 THR B 119       7.406   3.082  71.168  1.00 44.26           C  
ATOM   2308  N   ASN B 120       7.720  -1.356  69.491  1.00 44.83           N  
ATOM   2309  CA  ASN B 120       7.026  -2.507  68.930  1.00 44.76           C  
ATOM   2310  C   ASN B 120       7.583  -3.819  69.444  1.00 45.30           C  
ATOM   2311  O   ASN B 120       8.226  -4.569  68.695  1.00 45.84           O  
ATOM   2312  CB  ASN B 120       7.074  -2.452  67.420  1.00 44.45           C  
ATOM   2313  CG  ASN B 120       6.110  -3.415  66.766  1.00 44.31           C  
ATOM   2314  OD1 ASN B 120       5.715  -4.431  67.344  1.00 42.44           O  
ATOM   2315  ND2 ASN B 120       5.727  -3.099  65.535  1.00 44.42           N  
ATOM   2316  N   HIS B 121       7.280  -4.114  70.713  1.00 45.53           N  
ATOM   2317  CA  HIS B 121       7.820  -5.294  71.397  1.00 45.54           C  
ATOM   2318  C   HIS B 121       7.392  -6.601  70.764  1.00 45.95           C  
ATOM   2319  O   HIS B 121       8.142  -7.578  70.785  1.00 46.15           O  
ATOM   2320  CB  HIS B 121       7.457  -5.283  72.877  1.00 45.33           C  
ATOM   2321  CG  HIS B 121       8.171  -4.225  73.648  1.00 44.52           C  
ATOM   2322  ND1 HIS B 121       7.694  -2.934  73.754  1.00 44.16           N  
ATOM   2323  CD2 HIS B 121       9.351  -4.251  74.309  1.00 43.89           C  
ATOM   2324  CE1 HIS B 121       8.549  -2.214  74.458  1.00 44.62           C  
ATOM   2325  NE2 HIS B 121       9.559  -2.992  74.811  1.00 44.35           N  
ATOM   2326  N   ARG B 122       6.206  -6.640  70.185  1.00 46.61           N  
ATOM   2327  CA  ARG B 122       5.793  -7.855  69.504  1.00 46.98           C  
ATOM   2328  C   ARG B 122       6.798  -8.190  68.389  1.00 46.77           C  
ATOM   2329  O   ARG B 122       7.220  -9.350  68.253  1.00 46.66           O  
ATOM   2330  CB  ARG B 122       4.396  -7.700  68.929  1.00 47.47           C  
ATOM   2331  CG  ARG B 122       3.912  -8.927  68.173  1.00 47.99           C  
ATOM   2332  CD  ARG B 122       3.029  -8.514  67.037  1.00 49.67           C  
ATOM   2333  NE  ARG B 122       2.885  -9.538  66.005  1.00 51.11           N  
ATOM   2334  CZ  ARG B 122       2.699  -9.258  64.711  1.00 53.82           C  
ATOM   2335  NH1 ARG B 122       2.653  -7.990  64.281  1.00 55.11           N  
ATOM   2336  NH2 ARG B 122       2.557 -10.245  63.828  1.00 54.16           N  
ATOM   2337  N   MET B 123       7.189  -7.172  67.618  1.00 46.19           N  
ATOM   2338  CA  MET B 123       8.080  -7.384  66.478  1.00 46.06           C  
ATOM   2339  C   MET B 123       9.526  -7.564  66.916  1.00 45.91           C  
ATOM   2340  O   MET B 123      10.260  -8.351  66.320  1.00 45.41           O  
ATOM   2341  CB  MET B 123       7.966  -6.253  65.443  1.00 45.68           C  
ATOM   2342  CG  MET B 123       6.710  -6.328  64.569  1.00 44.20           C  
ATOM   2343  SD  MET B 123       6.328  -7.957  63.882  1.00 41.77           S  
ATOM   2344  CE  MET B 123       7.847  -8.303  63.033  1.00 41.67           C  
ATOM   2345  N   ILE B 124       9.933  -6.853  67.961  1.00 46.02           N  
ATOM   2346  CA  ILE B 124      11.252  -7.076  68.530  1.00 46.17           C  
ATOM   2347  C   ILE B 124      11.406  -8.538  68.915  1.00 46.68           C  
ATOM   2348  O   ILE B 124      12.412  -9.168  68.604  1.00 47.01           O  
ATOM   2349  CB  ILE B 124      11.493  -6.221  69.764  1.00 45.97           C  
ATOM   2350  CG1 ILE B 124      11.661  -4.754  69.371  1.00 45.44           C  
ATOM   2351  CG2 ILE B 124      12.736  -6.719  70.514  1.00 46.14           C  
ATOM   2352  CD1 ILE B 124      11.756  -3.799  70.554  1.00 45.44           C  
ATOM   2353  N   ARG B 125      10.406  -9.072  69.604  1.00 47.30           N  
ATOM   2354  CA  ARG B 125      10.416 -10.471  69.985  1.00 47.68           C  
ATOM   2355  C   ARG B 125      10.375 -11.350  68.761  1.00 48.00           C  
ATOM   2356  O   ARG B 125      11.117 -12.312  68.658  1.00 47.72           O  
ATOM   2357  CB  ARG B 125       9.209 -10.793  70.848  1.00 47.71           C  
ATOM   2358  CG  ARG B 125       9.298 -10.261  72.241  1.00 47.74           C  
ATOM   2359  CD  ARG B 125       8.128 -10.745  73.076  1.00 48.20           C  
ATOM   2360  NE  ARG B 125       8.038  -9.920  74.267  1.00 48.72           N  
ATOM   2361  CZ  ARG B 125       7.012  -9.146  74.597  1.00 49.09           C  
ATOM   2362  NH1 ARG B 125       5.903  -9.116  73.865  1.00 48.66           N  
ATOM   2363  NH2 ARG B 125       7.102  -8.410  75.700  1.00 49.42           N  
ATOM   2364  N   PHE B 126       9.473 -11.024  67.847  1.00 48.98           N  
ATOM   2365  CA  PHE B 126       9.379 -11.739  66.587  1.00 49.30           C  
ATOM   2366  C   PHE B 126      10.756 -11.901  65.929  1.00 49.75           C  
ATOM   2367  O   PHE B 126      11.147 -13.021  65.588  1.00 50.00           O  
ATOM   2368  CB  PHE B 126       8.425 -11.024  65.636  1.00 49.95           C  
ATOM   2369  CG  PHE B 126       8.176 -11.776  64.361  1.00 49.71           C  
ATOM   2370  CD1 PHE B 126       7.132 -12.680  64.271  1.00 52.58           C  
ATOM   2371  CD2 PHE B 126       8.997 -11.593  63.260  1.00 48.93           C  
ATOM   2372  CE1 PHE B 126       6.901 -13.376  63.104  1.00 51.87           C  
ATOM   2373  CE2 PHE B 126       8.775 -12.284  62.094  1.00 49.57           C  
ATOM   2374  CZ  PHE B 126       7.723 -13.174  62.008  1.00 50.69           C  
ATOM   2375  N   PHE B 127      11.493 -10.798  65.787  1.00 49.86           N  
ATOM   2376  CA  PHE B 127      12.797 -10.825  65.121  1.00 50.25           C  
ATOM   2377  C   PHE B 127      13.843 -11.595  65.907  1.00 50.59           C  
ATOM   2378  O   PHE B 127      14.530 -12.453  65.361  1.00 50.25           O  
ATOM   2379  CB  PHE B 127      13.293  -9.402  64.793  1.00 49.58           C  
ATOM   2380  CG  PHE B 127      12.493  -8.713  63.699  1.00 49.52           C  
ATOM   2381  CD1 PHE B 127      12.148  -9.387  62.531  1.00 47.86           C  
ATOM   2382  CD2 PHE B 127      12.100  -7.386  63.837  1.00 49.75           C  
ATOM   2383  CE1 PHE B 127      11.411  -8.758  61.551  1.00 48.29           C  
ATOM   2384  CE2 PHE B 127      11.373  -6.753  62.849  1.00 49.33           C  
ATOM   2385  CZ  PHE B 127      11.024  -7.435  61.713  1.00 49.04           C  
ATOM   2386  N   GLU B 128      13.952 -11.313  67.195  1.00 51.61           N  
ATOM   2387  CA  GLU B 128      14.839 -12.106  68.043  1.00 52.57           C  
ATOM   2388  C   GLU B 128      14.465 -13.591  67.981  1.00 52.68           C  
ATOM   2389  O   GLU B 128      15.334 -14.466  68.031  1.00 52.99           O  
ATOM   2390  CB  GLU B 128      14.810 -11.605  69.479  1.00 52.79           C  
ATOM   2391  CG  GLU B 128      15.407 -10.206  69.662  1.00 53.95           C  
ATOM   2392  CD  GLU B 128      15.464  -9.785  71.136  1.00 54.83           C  
ATOM   2393  OE1 GLU B 128      15.039 -10.584  72.016  1.00 57.49           O  
ATOM   2394  OE2 GLU B 128      15.932  -8.653  71.419  1.00 57.44           O  
ATOM   2395  N   SER B 129      13.174 -13.864  67.837  1.00 52.78           N  
ATOM   2396  CA  SER B 129      12.672 -15.234  67.760  1.00 52.86           C  
ATOM   2397  C   SER B 129      13.129 -15.949  66.495  1.00 52.94           C  
ATOM   2398  O   SER B 129      13.387 -17.149  66.531  1.00 53.10           O  
ATOM   2399  CB  SER B 129      11.142 -15.248  67.838  1.00 52.96           C  
ATOM   2400  OG  SER B 129      10.612 -16.387  67.190  1.00 53.71           O  
ATOM   2401  N   LYS B 130      13.221 -15.215  65.387  1.00 52.73           N  
ATOM   2402  CA  LYS B 130      13.551 -15.798  64.090  1.00 52.25           C  
ATOM   2403  C   LYS B 130      15.046 -15.832  63.778  1.00 51.66           C  
ATOM   2404  O   LYS B 130      15.436 -16.247  62.692  1.00 51.49           O  
ATOM   2405  CB  LYS B 130      12.821 -15.043  62.988  1.00 52.82           C  
ATOM   2406  CG  LYS B 130      11.319 -15.061  63.126  1.00 53.89           C  
ATOM   2407  CD  LYS B 130      10.766 -16.473  63.078  1.00 55.10           C  
ATOM   2408  CE  LYS B 130       9.252 -16.461  63.131  1.00 55.44           C  
ATOM   2409  NZ  LYS B 130       8.776 -17.709  63.778  1.00 57.38           N  
ATOM   2410  N   GLY B 131      15.875 -15.405  64.723  1.00 50.84           N  
ATOM   2411  CA  GLY B 131      17.319 -15.483  64.569  1.00 50.34           C  
ATOM   2412  C   GLY B 131      18.011 -14.175  64.218  1.00 49.99           C  
ATOM   2413  O   GLY B 131      19.220 -14.169  63.960  1.00 50.29           O  
ATOM   2414  N   PHE B 132      17.268 -13.064  64.218  1.00 49.07           N  
ATOM   2415  CA  PHE B 132      17.852 -11.770  63.888  1.00 48.26           C  
ATOM   2416  C   PHE B 132      18.629 -11.275  65.077  1.00 47.61           C  
ATOM   2417  O   PHE B 132      18.484 -11.781  66.166  1.00 47.64           O  
ATOM   2418  CB  PHE B 132      16.796 -10.726  63.545  1.00 47.95           C  
ATOM   2419  CG  PHE B 132      16.099 -10.947  62.231  1.00 47.33           C  
ATOM   2420  CD1 PHE B 132      15.157 -11.947  62.087  1.00 48.70           C  
ATOM   2421  CD2 PHE B 132      16.346 -10.118  61.157  1.00 46.22           C  
ATOM   2422  CE1 PHE B 132      14.503 -12.131  60.888  1.00 48.24           C  
ATOM   2423  CE2 PHE B 132      15.686 -10.297  59.964  1.00 46.75           C  
ATOM   2424  CZ  PHE B 132      14.768 -11.302  59.825  1.00 47.04           C  
ATOM   2425  N   THR B 133      19.430 -10.250  64.845  1.00 47.34           N  
ATOM   2426  CA  THR B 133      20.282  -9.643  65.851  1.00 46.95           C  
ATOM   2427  C   THR B 133      20.187  -8.143  65.653  1.00 46.42           C  
ATOM   2428  O   THR B 133      20.396  -7.668  64.549  1.00 46.87           O  
ATOM   2429  CB  THR B 133      21.730 -10.061  65.608  1.00 47.17           C  
ATOM   2430  OG1 THR B 133      21.770 -11.449  65.240  1.00 48.36           O  
ATOM   2431  CG2 THR B 133      22.580  -9.814  66.818  1.00 46.95           C  
ATOM   2432  N   LYS B 134      19.837  -7.398  66.691  1.00 45.88           N  
ATOM   2433  CA  LYS B 134      19.825  -5.939  66.607  1.00 45.62           C  
ATOM   2434  C   LYS B 134      21.256  -5.496  66.334  1.00 45.24           C  
ATOM   2435  O   LYS B 134      22.166  -5.998  66.968  1.00 45.94           O  
ATOM   2436  CB  LYS B 134      19.297  -5.313  67.909  1.00 45.44           C  
ATOM   2437  CG  LYS B 134      19.353  -3.804  67.937  1.00 45.62           C  
ATOM   2438  CD  LYS B 134      18.433  -3.200  68.993  1.00 45.92           C  
ATOM   2439  CE  LYS B 134      19.165  -2.750  70.238  1.00 46.29           C  
ATOM   2440  NZ  LYS B 134      20.265  -1.787  69.918  1.00 47.20           N  
ATOM   2441  N   ILE B 135      21.469  -4.593  65.380  1.00 44.54           N  
ATOM   2442  CA  ILE B 135      22.829  -4.125  65.082  1.00 43.84           C  
ATOM   2443  C   ILE B 135      22.979  -2.626  65.140  1.00 43.46           C  
ATOM   2444  O   ILE B 135      24.088  -2.138  65.097  1.00 43.53           O  
ATOM   2445  CB  ILE B 135      23.316  -4.614  63.710  1.00 43.65           C  
ATOM   2446  CG1 ILE B 135      22.308  -4.229  62.616  1.00 43.71           C  
ATOM   2447  CG2 ILE B 135      23.516  -6.121  63.745  1.00 43.20           C  
ATOM   2448  CD1 ILE B 135      22.755  -4.517  61.204  1.00 43.45           C  
ATOM   2449  N   HIS B 136      21.879  -1.887  65.253  1.00 43.24           N  
ATOM   2450  CA  HIS B 136      21.936  -0.427  65.179  1.00 43.31           C  
ATOM   2451  C   HIS B 136      20.632   0.224  65.646  1.00 43.25           C  
ATOM   2452  O   HIS B 136      19.556  -0.359  65.515  1.00 43.11           O  
ATOM   2453  CB  HIS B 136      22.211  -0.018  63.727  1.00 42.99           C  
ATOM   2454  CG  HIS B 136      22.546   1.426  63.553  1.00 42.26           C  
ATOM   2455  ND1 HIS B 136      23.605   2.028  64.200  1.00 41.08           N  
ATOM   2456  CD2 HIS B 136      21.981   2.380  62.780  1.00 41.34           C  
ATOM   2457  CE1 HIS B 136      23.668   3.296  63.842  1.00 41.56           C  
ATOM   2458  NE2 HIS B 136      22.689   3.538  62.986  1.00 42.11           N  
ATOM   2459  N   GLU B 137      20.742   1.438  66.178  1.00 43.52           N  
ATOM   2460  CA  GLU B 137      19.582   2.259  66.506  1.00 44.07           C  
ATOM   2461  C   GLU B 137      19.696   3.591  65.781  1.00 43.89           C  
ATOM   2462  O   GLU B 137      20.790   4.145  65.674  1.00 43.34           O  
ATOM   2463  CB  GLU B 137      19.506   2.498  68.010  1.00 44.21           C  
ATOM   2464  CG  GLU B 137      19.194   1.232  68.815  1.00 45.59           C  
ATOM   2465  CD  GLU B 137      19.279   1.428  70.337  1.00 45.92           C  
ATOM   2466  OE1 GLU B 137      19.278   0.395  71.062  1.00 47.85           O  
ATOM   2467  OE2 GLU B 137      19.355   2.601  70.799  1.00 47.44           O  
ATOM   2468  N   SER B 138      18.573   4.106  65.283  1.00 44.23           N  
ATOM   2469  CA  SER B 138      18.594   5.345  64.502  1.00 44.39           C  
ATOM   2470  C   SER B 138      17.252   6.025  64.437  1.00 44.66           C  
ATOM   2471  O   SER B 138      16.208   5.382  64.488  1.00 44.57           O  
ATOM   2472  CB  SER B 138      19.038   5.058  63.067  1.00 44.59           C  
ATOM   2473  OG  SER B 138      18.039   4.326  62.353  1.00 45.22           O  
ATOM   2474  N   LEU B 139      17.292   7.337  64.290  1.00 45.30           N  
ATOM   2475  CA  LEU B 139      16.110   8.100  63.959  1.00 46.30           C  
ATOM   2476  C   LEU B 139      15.808   7.915  62.485  1.00 46.57           C  
ATOM   2477  O   LEU B 139      16.717   7.687  61.702  1.00 46.70           O  
ATOM   2478  CB  LEU B 139      16.353   9.572  64.261  1.00 46.43           C  
ATOM   2479  CG  LEU B 139      16.744   9.854  65.719  1.00 46.91           C  
ATOM   2480  CD1 LEU B 139      17.050  11.326  65.916  1.00 46.83           C  
ATOM   2481  CD2 LEU B 139      15.632   9.391  66.645  1.00 47.15           C  
ATOM   2482  N   GLN B 140      14.535   7.997  62.117  1.00 47.32           N  
ATOM   2483  CA  GLN B 140      14.096   7.803  60.735  1.00 48.15           C  
ATOM   2484  C   GLN B 140      13.394   9.044  60.186  1.00 49.29           C  
ATOM   2485  O   GLN B 140      12.622   9.702  60.891  1.00 49.51           O  
ATOM   2486  CB  GLN B 140      13.138   6.616  60.633  1.00 47.62           C  
ATOM   2487  CG  GLN B 140      13.792   5.281  60.854  1.00 46.64           C  
ATOM   2488  CD  GLN B 140      14.772   4.918  59.756  1.00 45.03           C  
ATOM   2489  OE1 GLN B 140      15.991   5.125  59.898  1.00 43.42           O  
ATOM   2490  NE2 GLN B 140      14.249   4.378  58.652  1.00 42.35           N  
ATOM   2491  N   MET B 141      13.643   9.339  58.914  1.00 50.52           N  
ATOM   2492  CA  MET B 141      13.074  10.518  58.268  1.00 51.00           C  
ATOM   2493  C   MET B 141      11.534  10.544  58.351  1.00 51.88           C  
ATOM   2494  O   MET B 141      10.859   9.523  58.147  1.00 51.58           O  
ATOM   2495  CB  MET B 141      13.539  10.585  56.815  1.00 50.91           C  
ATOM   2496  CG  MET B 141      13.187  11.875  56.096  1.00 50.91           C  
ATOM   2497  SD  MET B 141      13.870  11.872  54.420  1.00 50.82           S  
ATOM   2498  CE  MET B 141      15.562  12.365  54.753  1.00 50.00           C  
ATOM   2499  N   ASN B 142      11.011  11.734  58.665  1.00 52.85           N  
ATOM   2500  CA  ASN B 142       9.566  11.995  58.795  1.00 53.43           C  
ATOM   2501  C   ASN B 142       8.895  11.307  59.974  1.00 53.99           C  
ATOM   2502  O   ASN B 142       7.670  11.251  60.039  1.00 54.56           O  
ATOM   2503  CB  ASN B 142       8.820  11.636  57.502  1.00 53.83           C  
ATOM   2504  CG  ASN B 142       9.302  12.440  56.320  1.00 54.67           C  
ATOM   2505  OD1 ASN B 142       9.368  11.931  55.210  1.00 55.82           O  
ATOM   2506  ND2 ASN B 142       9.645  13.711  56.554  1.00 56.14           N  
ATOM   2507  N   ARG B 143       9.694  10.793  60.905  1.00 54.15           N  
ATOM   2508  CA  ARG B 143       9.173  10.063  62.044  1.00 53.93           C  
ATOM   2509  C   ARG B 143      10.092  10.192  63.237  1.00 54.11           C  
ATOM   2510  O   ARG B 143      10.159   9.273  64.042  1.00 54.21           O  
ATOM   2511  CB  ARG B 143       9.007   8.581  61.694  1.00 53.77           C  
ATOM   2512  CG  ARG B 143       7.929   8.287  60.671  1.00 53.57           C  
ATOM   2513  CD  ARG B 143       7.798   6.798  60.437  1.00 53.13           C  
ATOM   2514  NE  ARG B 143       9.007   6.268  59.821  1.00 52.01           N  
ATOM   2515  CZ  ARG B 143       9.245   4.982  59.576  1.00 51.81           C  
ATOM   2516  NH1 ARG B 143       8.367   4.033  59.881  1.00 51.53           N  
ATOM   2517  NH2 ARG B 143      10.386   4.644  59.012  1.00 52.53           N  
ATOM   2518  N   LEU B 144      10.795  11.314  63.384  1.00 54.44           N  
ATOM   2519  CA  LEU B 144      11.688  11.431  64.540  1.00 54.97           C  
ATOM   2520  C   LEU B 144      10.893  11.602  65.828  1.00 54.83           C  
ATOM   2521  O   LEU B 144      11.369  11.271  66.916  1.00 54.94           O  
ATOM   2522  CB  LEU B 144      12.752  12.515  64.384  1.00 55.83           C  
ATOM   2523  CG  LEU B 144      12.340  13.942  64.110  1.00 57.44           C  
ATOM   2524  CD1 LEU B 144      13.115  14.884  65.081  1.00 58.26           C  
ATOM   2525  CD2 LEU B 144      12.588  14.278  62.605  1.00 58.35           C  
ATOM   2526  N   ASP B 145       9.681  12.123  65.673  1.00 54.43           N  
ATOM   2527  CA  ASP B 145       8.569  11.926  66.610  1.00 53.70           C  
ATOM   2528  C   ASP B 145       8.679  10.612  67.393  1.00 52.86           C  
ATOM   2529  O   ASP B 145       8.595  10.594  68.610  1.00 52.70           O  
ATOM   2530  CB  ASP B 145       7.229  11.900  65.832  1.00 54.43           C  
ATOM   2531  CG  ASP B 145       7.330  12.471  64.362  1.00 55.80           C  
ATOM   2532  OD1 ASP B 145       8.104  13.433  64.116  1.00 56.67           O  
ATOM   2533  OD2 ASP B 145       6.609  11.958  63.454  1.00 57.09           O  
ATOM   2534  N   PHE B 146       8.880   9.515  66.670  1.00 51.79           N  
ATOM   2535  CA  PHE B 146       8.772   8.178  67.234  1.00 50.84           C  
ATOM   2536  C   PHE B 146      10.080   7.601  67.791  1.00 49.83           C  
ATOM   2537  O   PHE B 146      10.111   6.440  68.203  1.00 49.46           O  
ATOM   2538  CB  PHE B 146       8.224   7.204  66.180  1.00 50.53           C  
ATOM   2539  CG  PHE B 146       6.911   7.609  65.568  1.00 50.11           C  
ATOM   2540  CD1 PHE B 146       6.102   8.592  66.138  1.00 54.94           C  
ATOM   2541  CD2 PHE B 146       6.460   6.958  64.435  1.00 47.86           C  
ATOM   2542  CE1 PHE B 146       4.888   8.931  65.553  1.00 53.01           C  
ATOM   2543  CE2 PHE B 146       5.254   7.284  63.852  1.00 47.84           C  
ATOM   2544  CZ  PHE B 146       4.467   8.269  64.403  1.00 50.11           C  
ATOM   2545  N   GLY B 147      11.153   8.381  67.806  1.00 48.94           N  
ATOM   2546  CA  GLY B 147      12.382   7.946  68.477  1.00 48.49           C  
ATOM   2547  C   GLY B 147      13.120   6.795  67.799  1.00 48.04           C  
ATOM   2548  O   GLY B 147      13.043   6.617  66.587  1.00 48.47           O  
ATOM   2549  N   SER B 148      13.839   6.005  68.583  1.00 47.13           N  
ATOM   2550  CA  SER B 148      14.745   5.015  68.022  1.00 46.58           C  
ATOM   2551  C   SER B 148      14.048   3.875  67.280  1.00 45.99           C  
ATOM   2552  O   SER B 148      13.074   3.284  67.773  1.00 45.97           O  
ATOM   2553  CB  SER B 148      15.659   4.439  69.109  1.00 47.04           C  
ATOM   2554  OG  SER B 148      16.833   5.234  69.239  1.00 48.30           O  
ATOM   2555  N   PHE B 149      14.556   3.583  66.079  1.00 44.88           N  
ATOM   2556  CA  PHE B 149      14.180   2.385  65.345  1.00 43.94           C  
ATOM   2557  C   PHE B 149      15.343   1.401  65.430  1.00 43.27           C  
ATOM   2558  O   PHE B 149      16.505   1.790  65.423  1.00 42.76           O  
ATOM   2559  CB  PHE B 149      13.871   2.727  63.901  1.00 43.20           C  
ATOM   2560  CG  PHE B 149      12.524   3.363  63.687  1.00 42.79           C  
ATOM   2561  CD1 PHE B 149      11.463   2.619  63.173  1.00 42.16           C  
ATOM   2562  CD2 PHE B 149      12.326   4.715  63.955  1.00 42.26           C  
ATOM   2563  CE1 PHE B 149      10.233   3.210  62.943  1.00 42.41           C  
ATOM   2564  CE2 PHE B 149      11.092   5.317  63.724  1.00 42.13           C  
ATOM   2565  CZ  PHE B 149      10.045   4.565  63.222  1.00 42.29           C  
ATOM   2566  N   TYR B 150      15.022   0.125  65.536  1.00 43.36           N  
ATOM   2567  CA  TYR B 150      16.023  -0.909  65.711  1.00 43.66           C  
ATOM   2568  C   TYR B 150      16.222  -1.650  64.409  1.00 43.42           C  
ATOM   2569  O   TYR B 150      15.249  -2.134  63.827  1.00 42.79           O  
ATOM   2570  CB  TYR B 150      15.578  -1.920  66.771  1.00 44.15           C  
ATOM   2571  CG  TYR B 150      15.411  -1.385  68.184  1.00 44.39           C  
ATOM   2572  CD1 TYR B 150      15.799  -0.094  68.531  1.00 44.48           C  
ATOM   2573  CD2 TYR B 150      14.894  -2.208  69.188  1.00 44.63           C  
ATOM   2574  CE1 TYR B 150      15.650   0.368  69.823  1.00 44.90           C  
ATOM   2575  CE2 TYR B 150      14.740  -1.756  70.481  1.00 44.38           C  
ATOM   2576  CZ  TYR B 150      15.117  -0.469  70.792  1.00 44.89           C  
ATOM   2577  OH  TYR B 150      14.972  -0.025  72.076  1.00 45.36           O  
ATOM   2578  N   LEU B 151      17.484  -1.754  63.984  1.00 43.48           N  
ATOM   2579  CA  LEU B 151      17.869  -2.455  62.757  1.00 43.91           C  
ATOM   2580  C   LEU B 151      18.330  -3.864  63.082  1.00 43.84           C  
ATOM   2581  O   LEU B 151      19.165  -4.055  63.953  1.00 43.56           O  
ATOM   2582  CB  LEU B 151      19.003  -1.699  62.057  1.00 43.71           C  
ATOM   2583  CG  LEU B 151      19.513  -2.255  60.723  1.00 43.49           C  
ATOM   2584  CD1 LEU B 151      18.437  -2.257  59.648  1.00 42.96           C  
ATOM   2585  CD2 LEU B 151      20.723  -1.474  60.261  1.00 43.96           C  
ATOM   2586  N   TYR B 152      17.798  -4.835  62.360  1.00 44.63           N  
ATOM   2587  CA  TYR B 152      18.066  -6.246  62.606  1.00 46.09           C  
ATOM   2588  C   TYR B 152      18.642  -6.918  61.375  1.00 46.90           C  
ATOM   2589  O   TYR B 152      18.280  -6.582  60.255  1.00 46.80           O  
ATOM   2590  CB  TYR B 152      16.761  -6.962  62.981  1.00 45.91           C  
ATOM   2591  CG  TYR B 152      16.293  -6.629  64.362  1.00 45.63           C  
ATOM   2592  CD1 TYR B 152      16.778  -7.327  65.459  1.00 48.47           C  
ATOM   2593  CD2 TYR B 152      15.388  -5.594  64.578  1.00 44.89           C  
ATOM   2594  CE1 TYR B 152      16.366  -7.010  66.738  1.00 47.70           C  
ATOM   2595  CE2 TYR B 152      14.963  -5.271  65.849  1.00 44.77           C  
ATOM   2596  CZ  TYR B 152      15.453  -5.979  66.926  1.00 46.16           C  
ATOM   2597  OH  TYR B 152      15.053  -5.660  68.195  1.00 47.72           O  
ATOM   2598  N   VAL B 153      19.510  -7.892  61.581  1.00 48.28           N  
ATOM   2599  CA  VAL B 153      20.003  -8.672  60.463  1.00 49.95           C  
ATOM   2600  C   VAL B 153      19.958 -10.139  60.808  1.00 51.49           C  
ATOM   2601  O   VAL B 153      20.244 -10.514  61.934  1.00 51.80           O  
ATOM   2602  CB  VAL B 153      21.447  -8.251  60.059  1.00 49.73           C  
ATOM   2603  CG1 VAL B 153      22.458  -8.570  61.167  1.00 49.63           C  
ATOM   2604  CG2 VAL B 153      21.852  -8.891  58.728  1.00 48.78           C  
ATOM   2605  N   LYS B 154      19.571 -10.960  59.843  1.00 53.77           N  
ATOM   2606  CA  LYS B 154      19.688 -12.403  59.970  1.00 55.51           C  
ATOM   2607  C   LYS B 154      20.657 -12.960  58.918  1.00 57.56           C  
ATOM   2608  O   LYS B 154      20.567 -12.601  57.738  1.00 57.21           O  
ATOM   2609  CB  LYS B 154      18.325 -13.061  59.796  1.00 55.07           C  
ATOM   2610  CG  LYS B 154      18.340 -14.496  60.248  1.00 54.58           C  
ATOM   2611  CD  LYS B 154      17.107 -15.254  59.847  1.00 54.90           C  
ATOM   2612  CE  LYS B 154      17.242 -16.705  60.258  1.00 54.16           C  
ATOM   2613  NZ  LYS B 154      15.931 -17.397  60.201  1.00 54.35           N  
ATOM   2614  N   GLU B 155      21.561 -13.846  59.346  1.00 60.30           N  
ATOM   2615  CA  GLU B 155      22.411 -14.618  58.422  1.00 62.63           C  
ATOM   2616  C   GLU B 155      21.612 -15.821  57.902  1.00 64.45           C  
ATOM   2617  O   GLU B 155      20.923 -16.465  58.666  1.00 64.44           O  
ATOM   2618  CB  GLU B 155      23.671 -15.103  59.126  1.00 62.97           C  
ATOM   2619  CG  GLU B 155      24.432 -14.043  59.952  1.00 65.36           C  
ATOM   2620  CD  GLU B 155      25.298 -13.075  59.132  1.00 68.30           C  
ATOM   2621  OE1 GLU B 155      25.579 -11.962  59.648  1.00 70.04           O  
ATOM   2622  OE2 GLU B 155      25.713 -13.413  57.993  1.00 70.08           O  
ATOM   2623  N   LEU B 156      21.715 -16.140  56.616  1.00 67.01           N  
ATOM   2624  CA  LEU B 156      20.766 -17.059  55.981  1.00 69.29           C  
ATOM   2625  C   LEU B 156      21.269 -18.453  55.560  1.00 71.57           C  
ATOM   2626  O   LEU B 156      20.611 -19.116  54.754  1.00 71.88           O  
ATOM   2627  CB  LEU B 156      20.148 -16.378  54.749  1.00 69.06           C  
ATOM   2628  CG  LEU B 156      19.088 -15.311  54.982  1.00 68.83           C  
ATOM   2629  CD1 LEU B 156      18.421 -14.957  53.675  1.00 68.64           C  
ATOM   2630  CD2 LEU B 156      18.052 -15.795  55.973  1.00 69.13           C  
ATOM   2631  N   GLU B 157      22.373 -18.950  56.106  1.00 74.16           N  
ATOM   2632  CA  GLU B 157      22.916 -20.211  55.565  1.00 76.12           C  
ATOM   2633  C   GLU B 157      23.531 -21.189  56.585  1.00 77.79           C  
ATOM   2634  O   GLU B 157      24.758 -21.313  56.701  1.00 78.03           O  
ATOM   2635  CB  GLU B 157      23.882 -19.889  54.424  1.00 76.45           C  
ATOM   2636  CG  GLU B 157      24.603 -18.543  54.569  1.00 77.08           C  
ATOM   2637  CD  GLU B 157      25.227 -18.078  53.259  1.00 77.47           C  
ATOM   2638  OE1 GLU B 157      26.416 -17.679  53.269  1.00 79.13           O  
ATOM   2639  OE2 GLU B 157      24.527 -18.117  52.214  1.00 78.50           O  
ATOM   2640  N   ASN B 158      22.648 -21.900  57.290  1.00 79.44           N  
ATOM   2641  CA  ASN B 158      23.025 -22.898  58.312  1.00 80.40           C  
ATOM   2642  C   ASN B 158      21.843 -23.866  58.590  1.00 81.37           C  
ATOM   2643  O   ASN B 158      20.952 -23.998  57.745  1.00 81.60           O  
ATOM   2644  CB  ASN B 158      23.537 -22.198  59.590  1.00 80.81           C  
ATOM   2645  CG  ASN B 158      22.567 -21.135  60.123  1.00 81.68           C  
ATOM   2646  OD1 ASN B 158      21.356 -21.369  60.240  1.00 82.77           O  
ATOM   2647  ND2 ASN B 158      23.106 -19.961  60.459  1.00 81.85           N  
ATOM   2648  N   GLN B 159      21.829 -24.550  59.739  1.00 82.17           N  
ATOM   2649  CA  GLN B 159      20.735 -25.487  60.061  1.00 82.30           C  
ATOM   2650  C   GLN B 159      20.646 -25.768  61.562  1.00 82.47           C  
ATOM   2651  O   GLN B 159      19.684 -25.377  62.218  1.00 82.47           O  
ATOM   2652  CB  GLN B 159      20.913 -26.801  59.274  1.00 82.66           C  
ATOM   2653  CG  GLN B 159      19.647 -27.658  59.114  1.00 82.57           C  
ATOM   2654  CD  GLN B 159      19.823 -28.839  58.148  1.00 82.63           C  
ATOM   2655  OE1 GLN B 159      18.886 -29.593  57.912  1.00 82.32           O  
ATOM   2656  NE2 GLN B 159      21.025 -28.999  57.596  1.00 82.69           N  
TER    2657      GLN B 159                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
