
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1359),  selected  171 , name 2i79_A
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 2i79_A.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    E     2_A      -       -           -
LGA    Y     3_A      -       -           -
LGA    E     4_A      R      26          3.880
LGA    L     5_A      Y      27          1.748
LGA    L     6_A      H      28          1.462
LGA    I     7_A      L      29          0.744
LGA    R     8_A      R      30          0.647
LGA    E     9_A      P      31          0.826
LGA    A    10_A      P      32          0.723
LGA    E    11_A      R      33          1.100
LGA    P    12_A      R      34          1.385
LGA    K    13_A      N      35          2.673
LGA    D    14_A      D      36          1.752
LGA    A    15_A      G      37          2.252
LGA    A    16_A      A      38          2.334
LGA    E    17_A      A      39          1.765
LGA    L    18_A      I      40          1.862
LGA    V    19_A      H      41          2.241
LGA    A    20_A      Q      42          2.017
LGA    F    21_A      L      43          1.630
LGA    L    22_A      V      44          2.194
LGA    N    23_A      S      45          2.227
LGA    R    24_A      E      46          2.062
LGA    V    25_A      C      47          1.915
LGA    S    26_A      -       -           -
LGA    L    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    T    29_A      P      48          2.711
LGA    D    30_A      P      49          2.277
LGA    F    31_A      -       -           -
LGA    T    32_A      L      50          3.692
LGA    S    33_A      D      51          3.225
LGA    L    34_A      L      52          3.266
LGA    D    35_A      -       -           -
LGA    G    36_A      -       -           -
LGA    D    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    I    39_A      N      53          2.585
LGA    L    40_A      S      54          1.457
LGA    L    41_A      L      55          1.742
LGA    T    42_A      -       -           -
LGA    S    43_A      -       -           -
LGA    E    44_A      -       -           -
LGA    E    45_A      Y      56          3.159
LGA    M    46_A      A      57           #
LGA    -       -      Y      58           -
LGA    E    47_A      L      59          3.755
LGA    I    48_A      L      60          3.977
LGA    F    49_A      L      61          3.336
LGA    L    50_A      C      62          1.481
LGA    N    51_A      E      63          2.058
LGA    K    52_A      H      64          0.981
LGA    Q    53_A      H      65          1.280
LGA    A    54_A      A      66          3.454
LGA    S    55_A      -       -           -
LGA    S    56_A      -       -           -
LGA    D    57_A      -       -           -
LGA    N    58_A      -       -           -
LGA    Q    59_A      H      67          5.408
LGA    I    60_A      T      68          1.209
LGA    T    61_A      C      69          1.219
LGA    L    62_A      V      70          0.514
LGA    L    63_A      V      71          0.460
LGA    A    64_A      A      72          0.149
LGA    F    65_A      E      73          0.801
LGA    L    66_A      S      74          2.602
LGA    N    67_A      P      75          4.472
LGA    G    68_A      G      76          2.663
LGA    -       -      G      77           -
LGA    K    69_A      R      78          0.788
LGA    I    70_A      I      79          0.562
LGA    A    71_A      D      80          0.829
LGA    G    72_A      G      81          0.553
LGA    I    73_A      F      82          0.864
LGA    V    74_A      V      83          1.431
LGA    N    75_A      S      84          1.702
LGA    I    76_A      A      85          1.355
LGA    T    77_A      Y      86          1.884
LGA    A    78_A      L      87          3.109
LGA    D    79_A      L      88          3.561
LGA    Q    80_A      P      89          2.494
LGA    R    81_A      T      90          3.568
LGA    K    82_A      -       -           -
LGA    R    83_A      -       -           -
LGA    V    84_A      R      91          1.636
LGA    R    85_A      P      92          2.209
LGA    H    86_A      D      93          2.077
LGA    I    87_A      V      94          1.758
LGA    G    88_A      L      95          1.608
LGA    D    89_A      F      96          0.973
LGA    L    90_A      V      97          0.687
LGA    F    91_A      W      98          3.145
LGA    -       -      Q      99           -
LGA    I    92_A      V     100          1.285
LGA    V    93_A      A     101          1.372
LGA    I    94_A      V     102          0.411
LGA    G    95_A      H     103          0.702
LGA    K    96_A      S     104          2.044
LGA    R    97_A      R     105          2.564
LGA    Y    98_A      A     106          1.861
LGA    W    99_A      R     107          2.262
LGA    N   100_A      G     108          3.170
LGA    N   101_A      H     109          2.599
LGA    G   102_A      R     110          1.541
LGA    L   103_A      L     111          1.414
LGA    G   104_A      G     112          1.455
LGA    S   105_A      R     113          1.646
LGA    L   106_A      A     114          1.018
LGA    L   107_A      M     115          0.917
LGA    L   108_A      L     116          1.677
LGA    E   109_A      G     117          1.323
LGA    E   110_A      H     118          1.077
LGA    A   111_A      I     119          1.901
LGA    I   112_A      L     120          2.061
LGA    E   113_A      E     121          1.641
LGA    W   114_A      R     122          2.162
LGA    -       -      Q     123           -
LGA    A   115_A      E     124           #
LGA    Q   116_A      C     125          4.181
LGA    A   117_A      R     126          2.442
LGA    S   118_A      -       -           -
LGA    G   119_A      -       -           -
LGA    I   120_A      H     127          3.921
LGA    L   121_A      V     128          2.646
LGA    R   122_A      R     129          2.401
LGA    R   123_A      H     130          1.721
LGA    L   124_A      L     131          1.055
LGA    Q   125_A      E     132          0.290
LGA    L   126_A      T     133          0.681
LGA    T   127_A      T     134          1.039
LGA    V   128_A      V     135          0.233
LGA    Q   129_A      G     136          0.636
LGA    T   130_A      P     137          2.038
LGA    R   131_A      D     138          0.119
LGA    N   132_A      N     139          0.885
LGA    Q   133_A      Q     140          0.980
LGA    A   134_A      A     141          0.986
LGA    A   135_A      S     142          0.525
LGA    V   136_A      R     143          1.138
LGA    H   137_A      R     144          1.182
LGA    L   138_A      T     145          1.231
LGA    Y   139_A      F     146          1.091
LGA    Q   140_A      A     147          0.810
LGA    K   141_A      G     148          1.021
LGA    H   142_A      L     149          0.892
LGA    G   143_A      A     150          0.730
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    F   144_A      H     156           #
LGA    V   145_A      V     157          1.101
LGA    I   146_A      S     158          2.586
LGA    E   147_A      E     159          2.860
LGA    G   148_A      Q     160          1.392
LGA    S   149_A      P     161          2.677
LGA    Q   150_A      F     162          4.272
LGA    -       -      F     163           -
LGA    E   151_A      D     164          4.355
LGA    R   152_A      R     165          3.396
LGA    -       -      Q     166           -
LGA    -       -      A     167           -
LGA    G   153_A      F     168           #
LGA    -       -      G     169           -
LGA    -       -      G     170           -
LGA    -       -      A     171           -
LGA    A   154_A      D     172           #
LGA    Y   155_A      H     173          1.460
LGA    I   156_A      D     174          4.923
LGA    E   157_A      -       -           -
LGA    E   158_A      -       -           -
LGA    G   159_A      -       -           -
LGA    K   160_A      -       -           -
LGA    F   161_A      -       -           -
LGA    I   162_A      -       -           -
LGA    D   163_A      D     175          3.803
LGA    V   164_A      E     176          3.346
LGA    Y   165_A      M     177          2.953
LGA    L   166_A      L     178          1.717
LGA    M   167_A      L     179          1.081
LGA    G   168_A      R     180          1.245
LGA    K   169_A      I     181          1.770
LGA    L   170_A      G     182          2.296
LGA    -       -      P     183           -
LGA    I   171_A      F     184          2.877

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  159    5.0    138    2.20    20.29     63.436     6.006

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.062307 * X  +  -0.938828 * Y  +  -0.338704 * Z  +  21.787760
  Y_new =   0.534374 * X  +  -0.255242 * Y  +   0.805789 * Z  + -39.379505
  Z_new =  -0.842948 * X  +  -0.231201 * Y  +   0.485782 * Z  + 124.485931 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.444211    2.697381  [ DEG:   -25.4514    154.5486 ]
  Theta =   1.002740    2.138853  [ DEG:    57.4528    122.5472 ]
  Phi   =   1.454723   -1.686870  [ DEG:    83.3495    -96.6505 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i79_A                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i79_A.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  159   5.0  138   2.20   20.29  63.436
REMARK  ---------------------------------------------------------- 
MOLECULE 2i79_A
HEADER    TRANSFERASE                             30-AUG-06   2I79              
TITLE     THE CRYSTAL STRUCTURE OF THE ACETYLTRANSFERASE OF GNAT                
TITLE    2 FAMILY FROM STREPTOCOCCUS PNEUMONIAE                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE, GNAT FAMILY;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 EC: 2.3.1.1;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 STRAIN: TIGR4;                                                       
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    ACETYLTRANSFERASE, GNAT FAMILY, ACETYL COENZYME *A,                   
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.G.ZHANG,M.ZHOU,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR           
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   10-OCT-06 2I79    0                                                
JRNL        AUTH   R.G.ZHANG,M.ZHOU,J.ABDULLAH,A.JOACHIMIAK                     
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE ACETYLTRANSFERASE OF            
JRNL        TITL 2 GNAT FAMILY FROM STREPTOCOCCUS PNEUMONIAE                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2I79 A    1   172  UNP    Q97NS4   Q97NS4_STRPN     1    172             
DBREF  2I79 B    1   172  UNP    Q97NS4   Q97NS4_STRPN     1    172             
DBREF  2I79 C    1   172  UNP    Q97NS4   Q97NS4_STRPN     1    172             
DBREF  2I79 D    1   172  UNP    Q97NS4   Q97NS4_STRPN     1    172             
DBREF  2I79 E    1   172  UNP    Q97NS4   Q97NS4_STRPN     1    172             
DBREF  2I79 F    1   172  UNP    Q97NS4   Q97NS4_STRPN     1    172             
SEQRES   1 A  172  MET GLU TYR GLU LEU LEU ILE ARG GLU ALA GLU PRO LYS          
SEQRES   2 A  172  ASP ALA ALA GLU LEU VAL ALA PHE LEU ASN ARG VAL SER          
SEQRES   3 A  172  LEU GLU THR ASP PHE THR SER LEU ASP GLY ASP GLY ILE          
SEQRES   4 A  172  LEU LEU THR SER GLU GLU MET GLU ILE PHE LEU ASN LYS          
SEQRES   5 A  172  GLN ALA SER SER ASP ASN GLN ILE THR LEU LEU ALA PHE          
SEQRES   6 A  172  LEU ASN GLY LYS ILE ALA GLY ILE VAL ASN ILE THR ALA          
SEQRES   7 A  172  ASP GLN ARG LYS ARG VAL ARG HIS ILE GLY ASP LEU PHE          
SEQRES   8 A  172  ILE VAL ILE GLY LYS ARG TYR TRP ASN ASN GLY LEU GLY          
SEQRES   9 A  172  SER LEU LEU LEU GLU GLU ALA ILE GLU TRP ALA GLN ALA          
SEQRES  10 A  172  SER GLY ILE LEU ARG ARG LEU GLN LEU THR VAL GLN THR          
SEQRES  11 A  172  ARG ASN GLN ALA ALA VAL HIS LEU TYR GLN LYS HIS GLY          
SEQRES  12 A  172  PHE VAL ILE GLU GLY SER GLN GLU ARG GLY ALA TYR ILE          
SEQRES  13 A  172  GLU GLU GLY LYS PHE ILE ASP VAL TYR LEU MET GLY LYS          
SEQRES  14 A  172  LEU ILE GLY                                                  
SEQRES   1 B  172  MET GLU TYR GLU LEU LEU ILE ARG GLU ALA GLU PRO LYS          
SEQRES   2 B  172  ASP ALA ALA GLU LEU VAL ALA PHE LEU ASN ARG VAL SER          
SEQRES   3 B  172  LEU GLU THR ASP PHE THR SER LEU ASP GLY ASP GLY ILE          
SEQRES   4 B  172  LEU LEU THR SER GLU GLU MET GLU ILE PHE LEU ASN LYS          
SEQRES   5 B  172  GLN ALA SER SER ASP ASN GLN ILE THR LEU LEU ALA PHE          
SEQRES   6 B  172  LEU ASN GLY LYS ILE ALA GLY ILE VAL ASN ILE THR ALA          
SEQRES   7 B  172  ASP GLN ARG LYS ARG VAL ARG HIS ILE GLY ASP LEU PHE          
SEQRES   8 B  172  ILE VAL ILE GLY LYS ARG TYR TRP ASN ASN GLY LEU GLY          
SEQRES   9 B  172  SER LEU LEU LEU GLU GLU ALA ILE GLU TRP ALA GLN ALA          
SEQRES  10 B  172  SER GLY ILE LEU ARG ARG LEU GLN LEU THR VAL GLN THR          
SEQRES  11 B  172  ARG ASN GLN ALA ALA VAL HIS LEU TYR GLN LYS HIS GLY          
SEQRES  12 B  172  PHE VAL ILE GLU GLY SER GLN GLU ARG GLY ALA TYR ILE          
SEQRES  13 B  172  GLU GLU GLY LYS PHE ILE ASP VAL TYR LEU MET GLY LYS          
SEQRES  14 B  172  LEU ILE GLY                                                  
SEQRES   1 C  172  MET GLU TYR GLU LEU LEU ILE ARG GLU ALA GLU PRO LYS          
SEQRES   2 C  172  ASP ALA ALA GLU LEU VAL ALA PHE LEU ASN ARG VAL SER          
SEQRES   3 C  172  LEU GLU THR ASP PHE THR SER LEU ASP GLY ASP GLY ILE          
SEQRES   4 C  172  LEU LEU THR SER GLU GLU MET GLU ILE PHE LEU ASN LYS          
SEQRES   5 C  172  GLN ALA SER SER ASP ASN GLN ILE THR LEU LEU ALA PHE          
SEQRES   6 C  172  LEU ASN GLY LYS ILE ALA GLY ILE VAL ASN ILE THR ALA          
SEQRES   7 C  172  ASP GLN ARG LYS ARG VAL ARG HIS ILE GLY ASP LEU PHE          
SEQRES   8 C  172  ILE VAL ILE GLY LYS ARG TYR TRP ASN ASN GLY LEU GLY          
SEQRES   9 C  172  SER LEU LEU LEU GLU GLU ALA ILE GLU TRP ALA GLN ALA          
SEQRES  10 C  172  SER GLY ILE LEU ARG ARG LEU GLN LEU THR VAL GLN THR          
SEQRES  11 C  172  ARG ASN GLN ALA ALA VAL HIS LEU TYR GLN LYS HIS GLY          
SEQRES  12 C  172  PHE VAL ILE GLU GLY SER GLN GLU ARG GLY ALA TYR ILE          
SEQRES  13 C  172  GLU GLU GLY LYS PHE ILE ASP VAL TYR LEU MET GLY LYS          
SEQRES  14 C  172  LEU ILE GLY                                                  
SEQRES   1 D  172  MET GLU TYR GLU LEU LEU ILE ARG GLU ALA GLU PRO LYS          
SEQRES   2 D  172  ASP ALA ALA GLU LEU VAL ALA PHE LEU ASN ARG VAL SER          
SEQRES   3 D  172  LEU GLU THR ASP PHE THR SER LEU ASP GLY ASP GLY ILE          
SEQRES   4 D  172  LEU LEU THR SER GLU GLU MET GLU ILE PHE LEU ASN LYS          
SEQRES   5 D  172  GLN ALA SER SER ASP ASN GLN ILE THR LEU LEU ALA PHE          
SEQRES   6 D  172  LEU ASN GLY LYS ILE ALA GLY ILE VAL ASN ILE THR ALA          
SEQRES   7 D  172  ASP GLN ARG LYS ARG VAL ARG HIS ILE GLY ASP LEU PHE          
SEQRES   8 D  172  ILE VAL ILE GLY LYS ARG TYR TRP ASN ASN GLY LEU GLY          
SEQRES   9 D  172  SER LEU LEU LEU GLU GLU ALA ILE GLU TRP ALA GLN ALA          
SEQRES  10 D  172  SER GLY ILE LEU ARG ARG LEU GLN LEU THR VAL GLN THR          
SEQRES  11 D  172  ARG ASN GLN ALA ALA VAL HIS LEU TYR GLN LYS HIS GLY          
SEQRES  12 D  172  PHE VAL ILE GLU GLY SER GLN GLU ARG GLY ALA TYR ILE          
SEQRES  13 D  172  GLU GLU GLY LYS PHE ILE ASP VAL TYR LEU MET GLY LYS          
SEQRES  14 D  172  LEU ILE GLY                                                  
SEQRES   1 E  172  MET GLU TYR GLU LEU LEU ILE ARG GLU ALA GLU PRO LYS          
SEQRES   2 E  172  ASP ALA ALA GLU LEU VAL ALA PHE LEU ASN ARG VAL SER          
SEQRES   3 E  172  LEU GLU THR ASP PHE THR SER LEU ASP GLY ASP GLY ILE          
SEQRES   4 E  172  LEU LEU THR SER GLU GLU MET GLU ILE PHE LEU ASN LYS          
SEQRES   5 E  172  GLN ALA SER SER ASP ASN GLN ILE THR LEU LEU ALA PHE          
SEQRES   6 E  172  LEU ASN GLY LYS ILE ALA GLY ILE VAL ASN ILE THR ALA          
SEQRES   7 E  172  ASP GLN ARG LYS ARG VAL ARG HIS ILE GLY ASP LEU PHE          
SEQRES   8 E  172  ILE VAL ILE GLY LYS ARG TYR TRP ASN ASN GLY LEU GLY          
SEQRES   9 E  172  SER LEU LEU LEU GLU GLU ALA ILE GLU TRP ALA GLN ALA          
SEQRES  10 E  172  SER GLY ILE LEU ARG ARG LEU GLN LEU THR VAL GLN THR          
SEQRES  11 E  172  ARG ASN GLN ALA ALA VAL HIS LEU TYR GLN LYS HIS GLY          
SEQRES  12 E  172  PHE VAL ILE GLU GLY SER GLN GLU ARG GLY ALA TYR ILE          
SEQRES  13 E  172  GLU GLU GLY LYS PHE ILE ASP VAL TYR LEU MET GLY LYS          
SEQRES  14 E  172  LEU ILE GLY                                                  
SEQRES   1 F  172  MET GLU TYR GLU LEU LEU ILE ARG GLU ALA GLU PRO LYS          
SEQRES   2 F  172  ASP ALA ALA GLU LEU VAL ALA PHE LEU ASN ARG VAL SER          
SEQRES   3 F  172  LEU GLU THR ASP PHE THR SER LEU ASP GLY ASP GLY ILE          
SEQRES   4 F  172  LEU LEU THR SER GLU GLU MET GLU ILE PHE LEU ASN LYS          
SEQRES   5 F  172  GLN ALA SER SER ASP ASN GLN ILE THR LEU LEU ALA PHE          
SEQRES   6 F  172  LEU ASN GLY LYS ILE ALA GLY ILE VAL ASN ILE THR ALA          
SEQRES   7 F  172  ASP GLN ARG LYS ARG VAL ARG HIS ILE GLY ASP LEU PHE          
SEQRES   8 F  172  ILE VAL ILE GLY LYS ARG TYR TRP ASN ASN GLY LEU GLY          
SEQRES   9 F  172  SER LEU LEU LEU GLU GLU ALA ILE GLU TRP ALA GLN ALA          
SEQRES  10 F  172  SER GLY ILE LEU ARG ARG LEU GLN LEU THR VAL GLN THR          
SEQRES  11 F  172  ARG ASN GLN ALA ALA VAL HIS LEU TYR GLN LYS HIS GLY          
SEQRES  12 F  172  PHE VAL ILE GLU GLY SER GLN GLU ARG GLY ALA TYR ILE          
SEQRES  13 F  172  GLU GLU GLY LYS PHE ILE ASP VAL TYR LEU MET GLY LYS          
SEQRES  14 F  172  LEU ILE GLY                                                  
HET    ACO    401      51                                                       
HET    ACO    402      51                                                       
HET    ACO    403      51                                                       
HET    ACO    404      51                                                       
HET    ACO    405      51                                                       
HET    ACO    406      51                                                       
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   7  ACO    6(C23 H38 N7 O17 P3 S)                                       
FORMUL  13  HOH   *339(H2 O)                                                    
CRYST1  133.131  174.792   56.573  90.00  90.00  90.00 P 21 21 2    24          
ATOM      1  N   MET A   1     -14.187 -23.629  65.115  1.00 60.29           N  
ATOM      2  CA  MET A   1     -12.866 -23.153  64.544  1.00 59.84           C  
ATOM      3  C   MET A   1     -12.827 -23.364  63.016  1.00 58.69           C  
ATOM      4  O   MET A   1     -12.599 -24.486  62.549  1.00 57.88           O  
ATOM      5  CB  MET A   1     -11.730 -23.914  65.242  1.00 60.53           C  
ATOM      6  CG  MET A   1     -10.303 -23.683  64.712  1.00 61.34           C  
ATOM      7  SD  MET A   1      -9.046 -24.564  65.740  1.00 64.11           S  
ATOM      8  CE  MET A   1      -7.680 -24.368  64.567  1.00 62.77           C  
ATOM      9  N   GLU A   2     -13.050 -22.282  62.255  1.00 57.44           N  
ATOM     10  CA  GLU A   2     -13.244 -22.334  60.789  1.00 56.55           C  
ATOM     11  C   GLU A   2     -12.617 -21.148  60.035  1.00 55.14           C  
ATOM     12  O   GLU A   2     -12.907 -20.003  60.359  1.00 55.16           O  
ATOM     13  CB  GLU A   2     -14.735 -22.331  60.471  1.00 56.09           C  
ATOM     14  CG  GLU A   2     -15.056 -22.576  59.000  1.00 58.01           C  
ATOM     15  CD  GLU A   2     -16.543 -22.853  58.761  1.00 59.31           C  
ATOM     16  OE1 GLU A   2     -17.372 -22.241  59.470  1.00 65.92           O  
ATOM     17  OE2 GLU A   2     -16.893 -23.665  57.875  1.00 62.29           O  
ATOM     18  N   TYR A   3     -11.804 -21.417  59.012  1.00 53.29           N  
ATOM     19  CA  TYR A   3     -11.247 -20.345  58.154  1.00 52.43           C  
ATOM     20  C   TYR A   3     -10.697 -20.861  56.849  1.00 51.48           C  
ATOM     21  O   TYR A   3     -10.395 -22.038  56.683  1.00 50.95           O  
ATOM     22  CB  TYR A   3     -10.120 -19.578  58.857  1.00 50.68           C  
ATOM     23  CG  TYR A   3      -8.909 -20.430  59.146  1.00 50.50           C  
ATOM     24  CD1 TYR A   3      -7.852 -20.519  58.239  1.00 49.06           C  
ATOM     25  CD2 TYR A   3      -8.848 -21.199  60.305  1.00 48.29           C  
ATOM     26  CE1 TYR A   3      -6.752 -21.326  58.504  1.00 48.97           C  
ATOM     27  CE2 TYR A   3      -7.757 -21.999  60.577  1.00 49.88           C  
ATOM     28  CZ  TYR A   3      -6.708 -22.054  59.680  1.00 49.34           C  
ATOM     29  OH  TYR A   3      -5.632 -22.849  59.965  1.00 48.14           O  
ATOM     30  N   GLU A   4     -10.487 -19.920  55.952  1.00 51.26           N  
ATOM     31  CA  GLU A   4      -9.864 -20.177  54.696  1.00 51.36           C  
ATOM     32  C   GLU A   4      -8.609 -19.306  54.595  1.00 49.97           C  
ATOM     33  O   GLU A   4      -8.668 -18.102  54.844  1.00 49.83           O  
ATOM     34  CB  GLU A   4     -10.879 -19.829  53.629  1.00 51.67           C  
ATOM     35  CG  GLU A   4     -10.470 -20.166  52.238  1.00 54.48           C  
ATOM     36  CD  GLU A   4     -11.650 -20.019  51.280  1.00 56.39           C  
ATOM     37  OE1 GLU A   4     -12.555 -19.183  51.585  1.00 62.17           O  
ATOM     38  OE2 GLU A   4     -11.670 -20.755  50.252  1.00 61.71           O  
ATOM     39  N   LEU A   5      -7.478 -19.919  54.249  1.00 49.13           N  
ATOM     40  CA  LEU A   5      -6.180 -19.210  54.145  1.00 48.84           C  
ATOM     41  C   LEU A   5      -5.591 -19.334  52.749  1.00 48.08           C  
ATOM     42  O   LEU A   5      -5.508 -20.429  52.227  1.00 48.04           O  
ATOM     43  CB  LEU A   5      -5.168 -19.767  55.156  1.00 48.13           C  
ATOM     44  CG  LEU A   5      -3.764 -19.124  55.196  1.00 48.71           C  
ATOM     45  CD1 LEU A   5      -3.838 -17.608  55.495  1.00 48.94           C  
ATOM     46  CD2 LEU A   5      -2.836 -19.782  56.210  1.00 48.18           C  
ATOM     47  N   LEU A   6      -5.166 -18.224  52.159  1.00 47.78           N  
ATOM     48  CA  LEU A   6      -4.275 -18.271  50.981  1.00 47.66           C  
ATOM     49  C   LEU A   6      -3.039 -17.392  51.223  1.00 47.04           C  
ATOM     50  O   LEU A   6      -3.159 -16.246  51.636  1.00 46.68           O  
ATOM     51  CB  LEU A   6      -5.015 -17.833  49.683  1.00 47.75           C  
ATOM     52  CG  LEU A   6      -4.163 -17.633  48.407  1.00 47.92           C  
ATOM     53  CD1 LEU A   6      -3.548 -18.946  47.880  1.00 47.58           C  
ATOM     54  CD2 LEU A   6      -4.999 -17.000  47.326  1.00 47.71           C  
ATOM     55  N   ILE A   7      -1.854 -17.945  50.992  1.00 47.16           N  
ATOM     56  CA  ILE A   7      -0.633 -17.147  50.936  1.00 46.85           C  
ATOM     57  C   ILE A   7      -0.060 -17.269  49.536  1.00 46.67           C  
ATOM     58  O   ILE A   7       0.126 -18.386  49.022  1.00 46.56           O  
ATOM     59  CB  ILE A   7       0.397 -17.562  51.974  1.00 46.93           C  
ATOM     60  CG1 ILE A   7      -0.156 -17.252  53.370  1.00 48.06           C  
ATOM     61  CG2 ILE A   7       1.715 -16.815  51.724  1.00 47.27           C  
ATOM     62  CD1 ILE A   7       0.750 -17.646  54.538  1.00 47.39           C  
ATOM     63  N   ARG A   8       0.176 -16.118  48.908  1.00 45.92           N  
ATOM     64  CA  ARG A   8       0.783 -16.064  47.568  1.00 45.90           C  
ATOM     65  C   ARG A   8       1.359 -14.687  47.244  1.00 45.60           C  
ATOM     66  O   ARG A   8       1.000 -13.681  47.867  1.00 44.43           O  
ATOM     67  CB  ARG A   8      -0.245 -16.409  46.477  1.00 45.56           C  
ATOM     68  CG  ARG A   8      -1.410 -15.441  46.372  1.00 44.95           C  
ATOM     69  CD  ARG A   8      -2.095 -15.510  45.007  1.00 45.56           C  
ATOM     70  NE  ARG A   8      -3.342 -14.742  44.968  1.00 44.39           N  
ATOM     71  CZ  ARG A   8      -3.419 -13.420  44.846  1.00 45.77           C  
ATOM     72  NH1 ARG A   8      -2.321 -12.685  44.724  1.00 43.85           N  
ATOM     73  NH2 ARG A   8      -4.603 -12.826  44.818  1.00 45.46           N  
ATOM     74  N   GLU A   9       2.183 -14.654  46.207  1.00 45.72           N  
ATOM     75  CA  GLU A   9       2.741 -13.398  45.692  1.00 46.43           C  
ATOM     76  C   GLU A   9       1.635 -12.449  45.260  1.00 46.07           C  
ATOM     77  O   GLU A   9       0.655 -12.885  44.654  1.00 45.81           O  
ATOM     78  CB  GLU A   9       3.680 -13.685  44.516  1.00 45.77           C  
ATOM     79  CG  GLU A   9       4.506 -12.502  44.105  1.00 47.04           C  
ATOM     80  CD  GLU A   9       5.697 -12.864  43.179  1.00 48.75           C  
ATOM     81  OE1 GLU A   9       5.971 -14.068  42.929  1.00 54.17           O  
ATOM     82  OE2 GLU A   9       6.375 -11.918  42.727  1.00 54.11           O  
ATOM     83  N   ALA A  10       1.787 -11.164  45.582  1.00 46.31           N  
ATOM     84  CA  ALA A  10       0.853 -10.132  45.142  1.00 47.19           C  
ATOM     85  C   ALA A  10       0.880 -10.012  43.618  1.00 47.81           C  
ATOM     86  O   ALA A  10       1.939 -10.168  43.000  1.00 47.89           O  
ATOM     87  CB  ALA A  10       1.199  -8.786  45.769  1.00 46.07           C  
ATOM     88  N   GLU A  11      -0.286  -9.761  43.023  1.00 48.77           N  
ATOM     89  CA  GLU A  11      -0.396  -9.438  41.580  1.00 50.36           C  
ATOM     90  C   GLU A  11      -1.015  -8.051  41.383  1.00 50.10           C  
ATOM     91  O   GLU A  11      -1.717  -7.546  42.256  1.00 48.46           O  
ATOM     92  CB  GLU A  11      -1.228 -10.492  40.834  1.00 50.38           C  
ATOM     93  CG  GLU A  11      -0.654 -11.929  40.931  1.00 53.60           C  
ATOM     94  CD  GLU A  11      -1.705 -13.017  40.640  1.00 55.02           C  
ATOM     95  OE1 GLU A  11      -2.448 -12.874  39.632  1.00 64.08           O  
ATOM     96  OE2 GLU A  11      -1.791 -14.006  41.407  1.00 58.92           O  
ATOM     97  N   PRO A  12      -0.733  -7.410  40.235  1.00 50.90           N  
ATOM     98  CA  PRO A  12      -1.320  -6.078  39.963  1.00 51.17           C  
ATOM     99  C   PRO A  12      -2.832  -5.998  40.237  1.00 50.80           C  
ATOM    100  O   PRO A  12      -3.311  -4.967  40.691  1.00 51.64           O  
ATOM    101  CB  PRO A  12      -0.985  -5.838  38.466  1.00 51.41           C  
ATOM    102  CG  PRO A  12      -0.503  -7.219  37.957  1.00 52.16           C  
ATOM    103  CD  PRO A  12       0.144  -7.853  39.138  1.00 50.83           C  
ATOM    104  N   LYS A  13      -3.561  -7.085  40.009  1.00 50.83           N  
ATOM    105  CA  LYS A  13      -4.994  -7.145  40.332  1.00 50.89           C  
ATOM    106  C   LYS A  13      -5.356  -6.905  41.824  1.00 50.32           C  
ATOM    107  O   LYS A  13      -6.500  -6.517  42.130  1.00 49.73           O  
ATOM    108  CB  LYS A  13      -5.605  -8.480  39.863  1.00 51.24           C  
ATOM    109  CG  LYS A  13      -5.037  -9.725  40.582  1.00 53.54           C  
ATOM    110  CD  LYS A  13      -6.022 -10.903  40.604  1.00 52.92           C  
ATOM    111  CE  LYS A  13      -5.394 -12.152  41.244  1.00 54.08           C  
ATOM    112  NZ  LYS A  13      -6.400 -13.256  41.466  1.00 54.69           N  
ATOM    113  N   ASP A  14      -4.402  -7.152  42.732  1.00 48.76           N  
ATOM    114  CA  ASP A  14      -4.591  -6.916  44.154  1.00 48.59           C  
ATOM    115  C   ASP A  14      -4.445  -5.436  44.594  1.00 48.00           C  
ATOM    116  O   ASP A  14      -4.670  -5.123  45.761  1.00 48.55           O  
ATOM    117  CB  ASP A  14      -3.584  -7.753  44.969  1.00 48.30           C  
ATOM    118  CG  ASP A  14      -3.619  -9.240  44.608  1.00 49.07           C  
ATOM    119  OD1 ASP A  14      -4.707  -9.781  44.406  1.00 47.18           O  
ATOM    120  OD2 ASP A  14      -2.548  -9.876  44.536  1.00 51.44           O  
ATOM    121  N   ALA A  15      -4.044  -4.546  43.694  1.00 47.30           N  
ATOM    122  CA  ALA A  15      -3.661  -3.171  44.064  1.00 46.71           C  
ATOM    123  C   ALA A  15      -4.639  -2.432  45.008  1.00 46.19           C  
ATOM    124  O   ALA A  15      -4.227  -1.826  46.001  1.00 45.81           O  
ATOM    125  CB  ALA A  15      -3.452  -2.355  42.785  1.00 46.89           C  
ATOM    126  N   ALA A  16      -5.924  -2.484  44.682  1.00 45.60           N  
ATOM    127  CA  ALA A  16      -6.955  -1.732  45.395  1.00 46.19           C  
ATOM    128  C   ALA A  16      -7.141  -2.286  46.789  1.00 45.92           C  
ATOM    129  O   ALA A  16      -7.236  -1.525  47.759  1.00 45.25           O  
ATOM    130  CB  ALA A  16      -8.316  -1.769  44.585  1.00 45.60           C  
ATOM    131  N   GLU A  17      -7.206  -3.616  46.885  1.00 46.04           N  
ATOM    132  CA  GLU A  17      -7.365  -4.287  48.193  1.00 46.58           C  
ATOM    133  C   GLU A  17      -6.135  -4.080  49.054  1.00 45.60           C  
ATOM    134  O   GLU A  17      -6.250  -3.904  50.260  1.00 46.49           O  
ATOM    135  CB  GLU A  17      -7.612  -5.781  48.045  1.00 47.19           C  
ATOM    136  CG  GLU A  17      -8.943  -6.189  47.446  1.00 49.68           C  
ATOM    137  CD  GLU A  17      -8.901  -7.643  46.936  1.00 50.44           C  
ATOM    138  OE1 GLU A  17      -8.941  -8.563  47.785  1.00 53.41           O  
ATOM    139  OE2 GLU A  17      -8.795  -7.851  45.702  1.00 53.20           O  
ATOM    140  N   LEU A  18      -4.962  -4.102  48.436  1.00 44.47           N  
ATOM    141  CA  LEU A  18      -3.718  -3.902  49.167  1.00 43.55           C  
ATOM    142  C   LEU A  18      -3.613  -2.472  49.675  1.00 42.50           C  
ATOM    143  O   LEU A  18      -3.162  -2.257  50.777  1.00 41.49           O  
ATOM    144  CB  LEU A  18      -2.512  -4.266  48.295  1.00 44.17           C  
ATOM    145  CG  LEU A  18      -1.118  -4.127  48.949  1.00 44.96           C  
ATOM    146  CD1 LEU A  18      -1.034  -4.791  50.363  1.00 43.10           C  
ATOM    147  CD2 LEU A  18      -0.089  -4.670  48.002  1.00 43.03           C  
ATOM    148  N   VAL A  19      -4.036  -1.489  48.873  1.00 41.81           N  
ATOM    149  CA  VAL A  19      -4.080  -0.102  49.344  1.00 41.17           C  
ATOM    150  C   VAL A  19      -5.027  -0.007  50.541  1.00 40.83           C  
ATOM    151  O   VAL A  19      -4.724   0.618  51.554  1.00 40.46           O  
ATOM    152  CB  VAL A  19      -4.491   0.935  48.218  1.00 41.49           C  
ATOM    153  CG1 VAL A  19      -4.851   2.321  48.846  1.00 39.15           C  
ATOM    154  CG2 VAL A  19      -3.402   1.112  47.175  1.00 39.77           C  
ATOM    155  N   ALA A  20      -6.183  -0.655  50.420  1.00 41.43           N  
ATOM    156  CA  ALA A  20      -7.202  -0.638  51.464  1.00 40.66           C  
ATOM    157  C   ALA A  20      -6.674  -1.223  52.783  1.00 41.08           C  
ATOM    158  O   ALA A  20      -6.837  -0.637  53.889  1.00 40.54           O  
ATOM    159  CB  ALA A  20      -8.428  -1.397  50.980  1.00 39.72           C  
ATOM    160  N   PHE A  21      -6.018  -2.382  52.671  1.00 41.32           N  
ATOM    161  CA  PHE A  21      -5.427  -3.045  53.830  1.00 41.21           C  
ATOM    162  C   PHE A  21      -4.340  -2.193  54.483  1.00 41.65           C  
ATOM    163  O   PHE A  21      -4.245  -2.104  55.722  1.00 40.75           O  
ATOM    164  CB  PHE A  21      -4.855  -4.404  53.415  1.00 41.21           C  
ATOM    165  CG  PHE A  21      -4.104  -5.082  54.512  1.00 41.46           C  
ATOM    166  CD1 PHE A  21      -4.787  -5.621  55.612  1.00 42.09           C  
ATOM    167  CD2 PHE A  21      -2.726  -5.136  54.494  1.00 41.82           C  
ATOM    168  CE1 PHE A  21      -4.097  -6.210  56.631  1.00 41.11           C  
ATOM    169  CE2 PHE A  21      -2.040  -5.724  55.540  1.00 42.54           C  
ATOM    170  CZ  PHE A  21      -2.730  -6.263  56.592  1.00 40.09           C  
ATOM    171  N   LEU A  22      -3.503  -1.549  53.669  1.00 42.54           N  
ATOM    172  CA  LEU A  22      -2.391  -0.797  54.251  1.00 43.04           C  
ATOM    173  C   LEU A  22      -2.916   0.451  54.946  1.00 42.86           C  
ATOM    174  O   LEU A  22      -2.414   0.838  55.959  1.00 42.74           O  
ATOM    175  CB  LEU A  22      -1.328  -0.481  53.211  1.00 43.47           C  
ATOM    176  CG  LEU A  22      -0.488  -1.699  52.794  1.00 45.61           C  
ATOM    177  CD1 LEU A  22       0.160  -1.483  51.428  1.00 47.43           C  
ATOM    178  CD2 LEU A  22       0.578  -2.035  53.879  1.00 43.61           C  
ATOM    179  N   ASN A  23      -3.967   1.042  54.406  1.00 43.78           N  
ATOM    180  CA  ASN A  23      -4.639   2.164  55.068  1.00 44.49           C  
ATOM    181  C   ASN A  23      -5.282   1.730  56.383  1.00 44.79           C  
ATOM    182  O   ASN A  23      -5.217   2.458  57.391  1.00 44.14           O  
ATOM    183  CB  ASN A  23      -5.691   2.785  54.144  1.00 43.89           C  
ATOM    184  CG  ASN A  23      -5.098   3.727  53.118  1.00 43.52           C  
ATOM    185  OD1 ASN A  23      -5.602   3.866  51.978  1.00 42.36           O  
ATOM    186  ND2 ASN A  23      -4.044   4.396  53.511  1.00 42.06           N  
ATOM    187  N   ARG A  24      -5.839   0.532  56.387  1.00 45.48           N  
ATOM    188  CA  ARG A  24      -6.416  -0.008  57.633  1.00 46.49           C  
ATOM    189  C   ARG A  24      -5.360  -0.158  58.715  1.00 45.46           C  
ATOM    190  O   ARG A  24      -5.506   0.394  59.779  1.00 45.11           O  
ATOM    191  CB  ARG A  24      -7.142  -1.339  57.404  1.00 46.58           C  
ATOM    192  CG  ARG A  24      -7.598  -2.013  58.710  1.00 47.49           C  
ATOM    193  CD  ARG A  24      -8.569  -3.171  58.473  1.00 54.06           C  
ATOM    194  NE  ARG A  24      -7.921  -4.450  58.078  1.00 60.64           N  
ATOM    195  CZ  ARG A  24      -7.782  -5.564  58.826  1.00 59.98           C  
ATOM    196  NH1 ARG A  24      -8.220  -5.678  60.087  1.00 63.28           N  
ATOM    197  NH2 ARG A  24      -7.198  -6.613  58.282  1.00 61.33           N  
ATOM    198  N   VAL A  25      -4.273  -0.866  58.431  1.00 45.31           N  
ATOM    199  CA  VAL A  25      -3.261  -1.138  59.459  1.00 44.91           C  
ATOM    200  C   VAL A  25      -2.483   0.114  59.871  1.00 44.53           C  
ATOM    201  O   VAL A  25      -2.006   0.217  60.979  1.00 43.84           O  
ATOM    202  CB  VAL A  25      -2.301  -2.294  59.038  1.00 44.46           C  
ATOM    203  CG1 VAL A  25      -3.084  -3.569  58.846  1.00 43.60           C  
ATOM    204  CG2 VAL A  25      -1.518  -1.932  57.760  1.00 43.43           C  
ATOM    205  N   SER A  26      -2.391   1.098  58.995  1.00 45.64           N  
ATOM    206  CA  SER A  26      -1.681   2.348  59.332  1.00 46.32           C  
ATOM    207  C   SER A  26      -2.360   3.120  60.522  1.00 47.01           C  
ATOM    208  O   SER A  26      -1.718   3.958  61.182  1.00 46.89           O  
ATOM    209  CB  SER A  26      -1.544   3.222  58.072  1.00 46.76           C  
ATOM    210  OG  SER A  26      -2.744   3.864  57.848  1.00 49.12           O  
ATOM    211  N   LEU A  27      -3.629   2.775  60.795  1.00 46.67           N  
ATOM    212  CA  LEU A  27      -4.460   3.362  61.819  1.00 46.71           C  
ATOM    213  C   LEU A  27      -4.516   2.520  63.099  1.00 47.04           C  
ATOM    214  O   LEU A  27      -5.005   2.994  64.134  1.00 46.88           O  
ATOM    215  CB  LEU A  27      -5.894   3.470  61.299  1.00 47.57           C  
ATOM    216  CG  LEU A  27      -6.134   4.336  60.073  1.00 49.24           C  
ATOM    217  CD1 LEU A  27      -7.548   4.139  59.622  1.00 51.71           C  
ATOM    218  CD2 LEU A  27      -5.846   5.790  60.388  1.00 51.41           C  
ATOM    219  N   GLU A  28      -4.027   1.284  63.028  1.00 46.30           N  
ATOM    220  CA  GLU A  28      -4.120   0.342  64.142  1.00 46.90           C  
ATOM    221  C   GLU A  28      -2.985   0.515  65.145  1.00 46.93           C  
ATOM    222  O   GLU A  28      -3.201   0.323  66.332  1.00 47.50           O  
ATOM    223  CB  GLU A  28      -4.131  -1.105  63.633  1.00 46.48           C  
ATOM    224  CG  GLU A  28      -5.381  -1.423  62.884  1.00 47.64           C  
ATOM    225  CD  GLU A  28      -5.437  -2.850  62.366  1.00 47.83           C  
ATOM    226  OE1 GLU A  28      -4.394  -3.534  62.320  1.00 48.60           O  
ATOM    227  OE2 GLU A  28      -6.541  -3.277  61.971  1.00 49.62           O  
ATOM    228  N   THR A  29      -1.779   0.863  64.686  1.00 47.00           N  
ATOM    229  CA  THR A  29      -0.658   1.062  65.606  1.00 46.37           C  
ATOM    230  C   THR A  29       0.174   2.211  65.134  1.00 46.88           C  
ATOM    231  O   THR A  29       0.041   2.682  63.958  1.00 47.07           O  
ATOM    232  CB  THR A  29       0.282  -0.182  65.692  1.00 46.78           C  
ATOM    233  OG1 THR A  29       1.124  -0.245  64.543  1.00 46.55           O  
ATOM    234  CG2 THR A  29      -0.487  -1.518  65.820  1.00 45.91           C  
ATOM    235  N   ASP A  30       1.075   2.657  65.999  1.00 46.39           N  
ATOM    236  CA  ASP A  30       2.153   3.558  65.563  1.00 47.09           C  
ATOM    237  C   ASP A  30       3.547   2.878  65.654  1.00 47.08           C  
ATOM    238  O   ASP A  30       4.559   3.539  65.875  1.00 47.31           O  
ATOM    239  CB  ASP A  30       2.078   4.896  66.324  1.00 47.29           C  
ATOM    240  CG  ASP A  30       2.066   4.725  67.831  1.00 49.71           C  
ATOM    241  OD1 ASP A  30       2.090   3.569  68.330  1.00 48.95           O  
ATOM    242  OD2 ASP A  30       2.053   5.776  68.522  1.00 53.34           O  
ATOM    243  N   PHE A  31       3.574   1.560  65.424  1.00 47.27           N  
ATOM    244  CA  PHE A  31       4.787   0.748  65.495  1.00 47.07           C  
ATOM    245  C   PHE A  31       5.660   0.810  64.231  1.00 47.19           C  
ATOM    246  O   PHE A  31       6.841   0.404  64.260  1.00 46.41           O  
ATOM    247  CB  PHE A  31       4.454  -0.722  65.780  1.00 47.01           C  
ATOM    248  CG  PHE A  31       4.063  -1.009  67.200  1.00 46.43           C  
ATOM    249  CD1 PHE A  31       4.738  -0.437  68.273  1.00 48.66           C  
ATOM    250  CD2 PHE A  31       3.047  -1.906  67.472  1.00 46.09           C  
ATOM    251  CE1 PHE A  31       4.369  -0.752  69.609  1.00 48.17           C  
ATOM    252  CE2 PHE A  31       2.667  -2.206  68.780  1.00 46.32           C  
ATOM    253  CZ  PHE A  31       3.328  -1.632  69.846  1.00 46.99           C  
ATOM    254  N   THR A  32       5.103   1.321  63.138  1.00 46.89           N  
ATOM    255  CA  THR A  32       5.855   1.468  61.899  1.00 47.94           C  
ATOM    256  C   THR A  32       5.745   2.893  61.379  1.00 47.64           C  
ATOM    257  O   THR A  32       5.119   3.734  61.998  1.00 47.11           O  
ATOM    258  CB  THR A  32       5.363   0.469  60.832  1.00 48.30           C  
ATOM    259  OG1 THR A  32       4.128   0.925  60.250  1.00 49.46           O  
ATOM    260  CG2 THR A  32       5.193  -0.930  61.467  1.00 48.60           C  
ATOM    261  N   SER A  33       6.370   3.168  60.251  1.00 48.22           N  
ATOM    262  CA  SER A  33       6.396   4.534  59.716  1.00 49.01           C  
ATOM    263  C   SER A  33       5.033   4.942  59.137  1.00 48.90           C  
ATOM    264  O   SER A  33       4.759   6.135  58.965  1.00 48.65           O  
ATOM    265  CB  SER A  33       7.510   4.668  58.685  1.00 49.76           C  
ATOM    266  OG  SER A  33       7.231   3.767  57.617  1.00 54.44           O  
ATOM    267  N   LEU A  34       4.181   3.944  58.874  1.00 48.82           N  
ATOM    268  CA  LEU A  34       2.748   4.174  58.615  1.00 48.26           C  
ATOM    269  C   LEU A  34       2.108   4.949  59.763  1.00 48.11           C  
ATOM    270  O   LEU A  34       2.324   4.637  60.945  1.00 48.89           O  
ATOM    271  CB  LEU A  34       2.013   2.853  58.431  1.00 48.28           C  
ATOM    272  CG  LEU A  34       2.334   1.967  57.197  1.00 49.46           C  
ATOM    273  CD1 LEU A  34       1.516   0.663  57.291  1.00 50.07           C  
ATOM    274  CD2 LEU A  34       2.078   2.686  55.874  1.00 47.54           C  
ATOM    275  N   ASP A  35       1.332   5.959  59.408  1.00 47.41           N  
ATOM    276  CA  ASP A  35       0.543   6.743  60.346  1.00 47.34           C  
ATOM    277  C   ASP A  35      -0.828   7.057  59.779  1.00 46.62           C  
ATOM    278  O   ASP A  35      -1.221   6.504  58.755  1.00 45.01           O  
ATOM    279  CB  ASP A  35       1.285   8.019  60.789  1.00 47.60           C  
ATOM    280  CG  ASP A  35       1.422   9.080  59.697  1.00 49.44           C  
ATOM    281  OD1 ASP A  35       0.722   9.097  58.668  1.00 51.90           O  
ATOM    282  OD2 ASP A  35       2.269   9.950  59.896  1.00 54.52           O  
ATOM    283  N   GLY A  36      -1.560   7.919  60.477  1.00 46.82           N  
ATOM    284  CA  GLY A  36      -2.932   8.247  60.137  1.00 47.37           C  
ATOM    285  C   GLY A  36      -3.166   8.783  58.737  1.00 47.16           C  
ATOM    286  O   GLY A  36      -4.239   8.598  58.181  1.00 47.09           O  
ATOM    287  N   ASP A  37      -2.156   9.430  58.166  1.00 47.32           N  
ATOM    288  CA  ASP A  37      -2.202   9.850  56.779  1.00 48.32           C  
ATOM    289  C   ASP A  37      -2.335   8.651  55.801  1.00 48.96           C  
ATOM    290  O   ASP A  37      -2.735   8.824  54.638  1.00 49.00           O  
ATOM    291  CB  ASP A  37      -0.991  10.718  56.436  1.00 48.40           C  
ATOM    292  CG  ASP A  37      -1.133  12.178  56.931  1.00 50.60           C  
ATOM    293  OD1 ASP A  37      -1.849  12.449  57.933  1.00 51.77           O  
ATOM    294  OD2 ASP A  37      -0.521  13.070  56.300  1.00 53.97           O  
ATOM    295  N   GLY A  38      -1.991   7.450  56.258  1.00 48.67           N  
ATOM    296  CA  GLY A  38      -2.140   6.273  55.434  1.00 49.61           C  
ATOM    297  C   GLY A  38      -1.012   6.058  54.448  1.00 50.26           C  
ATOM    298  O   GLY A  38       0.028   6.687  54.525  1.00 49.60           O  
ATOM    299  N   ILE A  39      -1.238   5.150  53.509  1.00 51.46           N  
ATOM    300  CA  ILE A  39      -0.205   4.697  52.595  1.00 52.09           C  
ATOM    301  C   ILE A  39       0.154   5.732  51.513  1.00 53.07           C  
ATOM    302  O   ILE A  39       1.246   5.671  50.947  1.00 53.98           O  
ATOM    303  CB  ILE A  39      -0.599   3.320  51.985  1.00 51.93           C  
ATOM    304  CG1 ILE A  39       0.607   2.638  51.310  1.00 52.26           C  
ATOM    305  CG2 ILE A  39      -1.788   3.460  51.051  1.00 51.32           C  
ATOM    306  CD1 ILE A  39       1.630   2.041  52.317  1.00 51.98           C  
ATOM    307  N   LEU A  40      -0.743   6.677  51.234  1.00 53.90           N  
ATOM    308  CA  LEU A  40      -0.445   7.810  50.339  1.00 55.05           C  
ATOM    309  C   LEU A  40      -0.236   7.407  48.842  1.00 55.93           C  
ATOM    310  O   LEU A  40       0.449   8.099  48.072  1.00 56.57           O  
ATOM    311  CB  LEU A  40       0.742   8.615  50.881  1.00 55.41           C  
ATOM    312  CG  LEU A  40       0.493   9.184  52.282  1.00 56.64           C  
ATOM    313  CD1 LEU A  40       1.783   9.679  52.908  1.00 59.66           C  
ATOM    314  CD2 LEU A  40      -0.580  10.285  52.252  1.00 56.99           C  
ATOM    315  N   LEU A  41      -0.845   6.287  48.459  1.00 55.53           N  
ATOM    316  CA  LEU A  41      -0.745   5.731  47.119  1.00 54.75           C  
ATOM    317  C   LEU A  41      -2.146   5.401  46.655  1.00 54.01           C  
ATOM    318  O   LEU A  41      -2.919   4.795  47.388  1.00 53.39           O  
ATOM    319  CB  LEU A  41       0.088   4.450  47.128  1.00 55.03           C  
ATOM    320  CG  LEU A  41       1.611   4.505  47.195  1.00 57.61           C  
ATOM    321  CD1 LEU A  41       2.175   3.081  47.173  1.00 60.99           C  
ATOM    322  CD2 LEU A  41       2.205   5.308  46.057  1.00 59.50           C  
ATOM    323  N   THR A  42      -2.480   5.807  45.437  1.00 53.10           N  
ATOM    324  CA  THR A  42      -3.736   5.427  44.806  1.00 52.82           C  
ATOM    325  C   THR A  42      -3.640   3.958  44.345  1.00 51.66           C  
ATOM    326  O   THR A  42      -2.536   3.411  44.225  1.00 50.00           O  
ATOM    327  CB  THR A  42      -3.980   6.281  43.538  1.00 52.54           C  
ATOM    328  OG1 THR A  42      -2.932   5.982  42.619  1.00 52.37           O  
ATOM    329  CG2 THR A  42      -3.970   7.750  43.868  1.00 53.42           C  
ATOM    330  N   SER A  43      -4.782   3.347  44.039  1.00 51.54           N  
ATOM    331  CA  SER A  43      -4.795   1.975  43.522  1.00 53.01           C  
ATOM    332  C   SER A  43      -3.927   1.861  42.269  1.00 53.78           C  
ATOM    333  O   SER A  43      -3.242   0.853  42.053  1.00 53.36           O  
ATOM    334  CB  SER A  43      -6.221   1.510  43.208  1.00 52.82           C  
ATOM    335  OG  SER A  43      -6.997   1.385  44.391  1.00 52.84           O  
ATOM    336  N   GLU A  44      -3.938   2.921  41.459  1.00 55.47           N  
ATOM    337  CA  GLU A  44      -3.201   2.966  40.188  1.00 56.12           C  
ATOM    338  C   GLU A  44      -1.697   2.979  40.423  1.00 56.55           C  
ATOM    339  O   GLU A  44      -0.953   2.178  39.818  1.00 56.74           O  
ATOM    340  CB  GLU A  44      -3.677   4.169  39.363  1.00 57.47           C  
ATOM    341  CG  GLU A  44      -5.192   4.056  38.924  1.00 58.92           C  
ATOM    342  CD  GLU A  44      -6.263   4.154  40.079  1.00 63.49           C  
ATOM    343  OE1 GLU A  44      -6.054   4.863  41.115  1.00 62.09           O  
ATOM    344  OE2 GLU A  44      -7.351   3.518  39.923  1.00 63.12           O  
ATOM    345  N   GLU A  45      -1.257   3.822  41.359  1.00 56.36           N  
ATOM    346  CA  GLU A  45       0.135   3.824  41.797  1.00 56.85           C  
ATOM    347  C   GLU A  45       0.604   2.517  42.448  1.00 56.72           C  
ATOM    348  O   GLU A  45       1.777   2.130  42.314  1.00 55.87           O  
ATOM    349  CB  GLU A  45       0.374   4.981  42.778  1.00 57.33           C  
ATOM    350  CG  GLU A  45       0.346   6.378  42.125  1.00 58.70           C  
ATOM    351  CD  GLU A  45       0.462   7.500  43.145  1.00 59.44           C  
ATOM    352  OE1 GLU A  45      -0.006   7.316  44.299  1.00 61.39           O  
ATOM    353  OE2 GLU A  45       1.035   8.565  42.798  1.00 63.11           O  
ATOM    354  N   MET A  46      -0.286   1.835  43.173  1.00 56.10           N  
ATOM    355  CA  MET A  46       0.103   0.564  43.768  1.00 56.60           C  
ATOM    356  C   MET A  46       0.353  -0.487  42.682  1.00 56.73           C  
ATOM    357  O   MET A  46       1.233  -1.322  42.821  1.00 55.68           O  
ATOM    358  CB  MET A  46      -0.925   0.069  44.780  1.00 55.24           C  
ATOM    359  CG  MET A  46      -0.533  -1.260  45.422  1.00 54.25           C  
ATOM    360  SD  MET A  46       0.922  -1.179  46.509  1.00 44.00           S  
ATOM    361  CE  MET A  46       0.221  -0.297  47.894  1.00 47.96           C  
ATOM    362  N   GLU A  47      -0.448  -0.440  41.627  1.00 58.52           N  
ATOM    363  CA  GLU A  47      -0.357  -1.386  40.510  1.00 59.86           C  
ATOM    364  C   GLU A  47       1.063  -1.357  39.871  1.00 60.74           C  
ATOM    365  O   GLU A  47       1.639  -2.400  39.553  1.00 61.55           O  
ATOM    366  CB  GLU A  47      -1.471  -1.060  39.510  1.00 60.15           C  
ATOM    367  CG  GLU A  47      -2.000  -2.218  38.684  1.00 60.51           C  
ATOM    368  CD  GLU A  47      -3.356  -1.926  37.989  1.00 62.04           C  
ATOM    369  OE1 GLU A  47      -4.226  -1.189  38.532  1.00 63.94           O  
ATOM    370  OE2 GLU A  47      -3.563  -2.489  36.897  1.00 66.11           O  
ATOM    371  N   ILE A  48       1.640  -0.164  39.741  1.00 61.47           N  
ATOM    372  CA  ILE A  48       3.044   0.010  39.338  1.00 61.43           C  
ATOM    373  C   ILE A  48       4.003  -0.679  40.329  1.00 61.72           C  
ATOM    374  O   ILE A  48       4.753  -1.607  39.982  1.00 61.48           O  
ATOM    375  CB  ILE A  48       3.379   1.532  39.188  1.00 61.97           C  
ATOM    376  CG1 ILE A  48       2.645   2.114  37.958  1.00 61.94           C  
ATOM    377  CG2 ILE A  48       4.919   1.771  39.112  1.00 61.89           C  
ATOM    378  CD1 ILE A  48       2.357   3.620  38.018  1.00 61.98           C  
ATOM    379  N   PHE A  49       3.960  -0.257  41.579  1.00 61.68           N  
ATOM    380  CA  PHE A  49       4.767  -0.923  42.588  1.00 62.03           C  
ATOM    381  C   PHE A  49       4.688  -2.464  42.464  1.00 62.57           C  
ATOM    382  O   PHE A  49       5.716  -3.158  42.518  1.00 62.61           O  
ATOM    383  CB  PHE A  49       4.367  -0.467  43.989  1.00 61.50           C  
ATOM    384  CG  PHE A  49       5.098  -1.190  45.091  1.00 62.01           C  
ATOM    385  CD1 PHE A  49       6.421  -0.881  45.383  1.00 62.20           C  
ATOM    386  CD2 PHE A  49       4.466  -2.192  45.832  1.00 62.06           C  
ATOM    387  CE1 PHE A  49       7.107  -1.552  46.397  1.00 62.51           C  
ATOM    388  CE2 PHE A  49       5.138  -2.857  46.848  1.00 62.31           C  
ATOM    389  CZ  PHE A  49       6.469  -2.535  47.130  1.00 62.23           C  
ATOM    390  N   LEU A  50       3.475  -2.995  42.303  1.00 62.84           N  
ATOM    391  CA  LEU A  50       3.269  -4.447  42.309  1.00 63.08           C  
ATOM    392  C   LEU A  50       3.870  -5.150  41.073  1.00 63.46           C  
ATOM    393  O   LEU A  50       4.404  -6.272  41.197  1.00 63.28           O  
ATOM    394  CB  LEU A  50       1.783  -4.785  42.492  1.00 62.83           C  
ATOM    395  CG  LEU A  50       1.282  -4.551  43.915  1.00 62.22           C  
ATOM    396  CD1 LEU A  50      -0.170  -4.940  44.038  1.00 61.46           C  
ATOM    397  CD2 LEU A  50       2.108  -5.327  44.912  1.00 61.88           C  
ATOM    398  N   ASN A  51       3.794  -4.500  39.908  1.00 63.63           N  
ATOM    399  CA  ASN A  51       4.479  -4.981  38.700  1.00 64.43           C  
ATOM    400  C   ASN A  51       6.013  -5.080  38.922  1.00 64.36           C  
ATOM    401  O   ASN A  51       6.632  -6.122  38.638  1.00 64.56           O  
ATOM    402  CB  ASN A  51       4.141  -4.097  37.468  1.00 64.31           C  
ATOM    403  CG  ASN A  51       2.667  -4.248  37.000  1.00 67.12           C  
ATOM    404  OD1 ASN A  51       2.121  -5.355  36.976  1.00 70.57           O  
ATOM    405  ND2 ASN A  51       2.031  -3.133  36.624  1.00 68.52           N  
ATOM    406  N   LYS A  52       6.612  -4.016  39.446  1.00 64.34           N  
ATOM    407  CA  LYS A  52       8.041  -4.018  39.796  1.00 64.80           C  
ATOM    408  C   LYS A  52       8.461  -5.168  40.721  1.00 64.45           C  
ATOM    409  O   LYS A  52       9.445  -5.858  40.438  1.00 64.40           O  
ATOM    410  CB  LYS A  52       8.435  -2.709  40.478  1.00 65.20           C  
ATOM    411  CG  LYS A  52       8.892  -1.629  39.539  1.00 66.75           C  
ATOM    412  CD  LYS A  52       9.435  -0.428  40.328  1.00 66.92           C  
ATOM    413  CE  LYS A  52       9.647   0.802  39.428  1.00 67.95           C  
ATOM    414  NZ  LYS A  52       8.340   1.347  38.890  1.00 69.00           N  
ATOM    415  N   GLN A  53       7.750  -5.341  41.846  1.00 64.05           N  
ATOM    416  CA  GLN A  53       8.047  -6.444  42.788  1.00 63.72           C  
ATOM    417  C   GLN A  53       8.045  -7.822  42.092  1.00 63.61           C  
ATOM    418  O   GLN A  53       8.975  -8.617  42.285  1.00 63.84           O  
ATOM    419  CB  GLN A  53       7.072  -6.465  43.988  1.00 63.35           C  
ATOM    420  CG  GLN A  53       7.236  -5.325  45.005  1.00 62.77           C  
ATOM    421  CD  GLN A  53       8.585  -5.322  45.741  1.00 61.95           C  
ATOM    422  OE1 GLN A  53       9.564  -4.731  45.268  1.00 60.97           O  
ATOM    423  NE2 GLN A  53       8.625  -5.947  46.912  1.00 60.55           N  
ATOM    424  N   ALA A  54       7.008  -8.099  41.294  1.00 63.15           N  
ATOM    425  CA  ALA A  54       6.907  -9.368  40.555  1.00 62.81           C  
ATOM    426  C   ALA A  54       8.018  -9.501  39.502  1.00 62.76           C  
ATOM    427  O   ALA A  54       8.514 -10.604  39.261  1.00 62.97           O  
ATOM    428  CB  ALA A  54       5.545  -9.485  39.879  1.00 62.69           C  
ATOM    429  N   SER A  55       8.401  -8.376  38.896  1.00 62.03           N  
ATOM    430  CA  SER A  55       9.368  -8.365  37.802  1.00 61.66           C  
ATOM    431  C   SER A  55      10.822  -8.237  38.247  1.00 61.14           C  
ATOM    432  O   SER A  55      11.712  -8.222  37.401  1.00 62.07           O  
ATOM    433  CB  SER A  55       9.073  -7.205  36.866  1.00 61.83           C  
ATOM    434  OG  SER A  55      10.263  -6.466  36.622  1.00 64.47           O  
ATOM    435  N   SER A  56      11.054  -8.101  39.553  1.00 59.88           N  
ATOM    436  CA  SER A  56      12.389  -7.912  40.132  1.00 58.57           C  
ATOM    437  C   SER A  56      12.805  -9.229  40.763  1.00 57.64           C  
ATOM    438  O   SER A  56      11.991  -9.906  41.398  1.00 57.78           O  
ATOM    439  CB  SER A  56      12.324  -6.805  41.202  1.00 58.68           C  
ATOM    440  OG  SER A  56      13.500  -6.729  41.982  1.00 58.02           O  
ATOM    441  N   ASP A  57      14.066  -9.604  40.616  1.00 56.13           N  
ATOM    442  CA  ASP A  57      14.490 -10.908  41.106  1.00 55.35           C  
ATOM    443  C   ASP A  57      14.995 -10.900  42.558  1.00 53.24           C  
ATOM    444  O   ASP A  57      15.247 -11.948  43.111  1.00 52.69           O  
ATOM    445  CB  ASP A  57      15.513 -11.561  40.155  1.00 56.48           C  
ATOM    446  CG  ASP A  57      16.617 -10.613  39.727  1.00 60.34           C  
ATOM    447  OD1 ASP A  57      16.976  -9.692  40.516  1.00 65.49           O  
ATOM    448  OD2 ASP A  57      17.130 -10.790  38.582  1.00 66.59           O  
ATOM    449  N   ASN A  58      15.157  -9.724  43.156  1.00 51.21           N  
ATOM    450  CA  ASN A  58      15.627  -9.626  44.537  1.00 49.82           C  
ATOM    451  C   ASN A  58      14.617  -8.898  45.444  1.00 48.84           C  
ATOM    452  O   ASN A  58      14.919  -8.534  46.576  1.00 48.16           O  
ATOM    453  CB  ASN A  58      17.047  -9.015  44.603  1.00 48.75           C  
ATOM    454  CG  ASN A  58      17.094  -7.500  44.315  1.00 46.89           C  
ATOM    455  OD1 ASN A  58      16.179  -6.905  43.758  1.00 45.42           O  
ATOM    456  ND2 ASN A  58      18.201  -6.892  44.674  1.00 44.01           N  
ATOM    457  N   GLN A  59      13.402  -8.720  44.938  1.00 47.94           N  
ATOM    458  CA  GLN A  59      12.346  -8.144  45.713  1.00 47.46           C  
ATOM    459  C   GLN A  59      11.082  -9.007  45.620  1.00 47.62           C  
ATOM    460  O   GLN A  59      10.933  -9.792  44.677  1.00 48.01           O  
ATOM    461  CB  GLN A  59      12.068  -6.724  45.240  1.00 47.27           C  
ATOM    462  CG  GLN A  59      13.260  -5.771  45.336  1.00 46.53           C  
ATOM    463  CD  GLN A  59      12.931  -4.391  44.830  1.00 46.72           C  
ATOM    464  OE1 GLN A  59      12.865  -4.157  43.612  1.00 50.83           O  
ATOM    465  NE2 GLN A  59      12.719  -3.465  45.741  1.00 40.01           N  
ATOM    466  N   ILE A  60      10.188  -8.864  46.606  1.00 46.79           N  
ATOM    467  CA  ILE A  60       8.911  -9.575  46.614  1.00 45.79           C  
ATOM    468  C   ILE A  60       7.898  -8.984  47.588  1.00 45.12           C  
ATOM    469  O   ILE A  60       8.260  -8.483  48.652  1.00 44.30           O  
ATOM    470  CB  ILE A  60       9.102 -11.080  46.935  1.00 45.95           C  
ATOM    471  CG1 ILE A  60       7.846 -11.879  46.545  1.00 48.18           C  
ATOM    472  CG2 ILE A  60       9.429 -11.293  48.384  1.00 43.84           C  
ATOM    473  CD1 ILE A  60       8.137 -13.341  46.162  1.00 46.55           C  
ATOM    474  N   THR A  61       6.620  -9.091  47.223  1.00 44.08           N  
ATOM    475  CA  THR A  61       5.511  -8.817  48.113  1.00 44.23           C  
ATOM    476  C   THR A  61       4.606 -10.047  48.159  1.00 43.87           C  
ATOM    477  O   THR A  61       4.099 -10.481  47.134  1.00 43.07           O  
ATOM    478  CB  THR A  61       4.676  -7.616  47.667  1.00 44.23           C  
ATOM    479  OG1 THR A  61       5.500  -6.470  47.627  1.00 46.23           O  
ATOM    480  CG2 THR A  61       3.484  -7.348  48.629  1.00 43.13           C  
ATOM    481  N   LEU A  62       4.446 -10.605  49.360  1.00 44.11           N  
ATOM    482  CA  LEU A  62       3.578 -11.751  49.627  1.00 44.26           C  
ATOM    483  C   LEU A  62       2.372 -11.325  50.447  1.00 43.96           C  
ATOM    484  O   LEU A  62       2.497 -10.567  51.413  1.00 43.85           O  
ATOM    485  CB  LEU A  62       4.321 -12.828  50.412  1.00 44.96           C  
ATOM    486  CG  LEU A  62       5.466 -13.610  49.729  1.00 47.21           C  
ATOM    487  CD1 LEU A  62       6.118 -14.563  50.736  1.00 48.14           C  
ATOM    488  CD2 LEU A  62       5.004 -14.383  48.511  1.00 47.28           C  
ATOM    489  N   LEU A  63       1.210 -11.848  50.069  1.00 43.43           N  
ATOM    490  CA  LEU A  63      -0.043 -11.538  50.721  1.00 43.66           C  
ATOM    491  C   LEU A  63      -0.646 -12.779  51.406  1.00 43.91           C  
ATOM    492  O   LEU A  63      -0.534 -13.897  50.890  1.00 44.24           O  
ATOM    493  CB  LEU A  63      -1.030 -11.020  49.674  1.00 43.78           C  
ATOM    494  CG  LEU A  63      -0.647  -9.808  48.809  1.00 42.52           C  
ATOM    495  CD1 LEU A  63      -1.766  -9.463  47.843  1.00 41.57           C  
ATOM    496  CD2 LEU A  63      -0.291  -8.604  49.663  1.00 40.87           C  
ATOM    497  N   ALA A  64      -1.289 -12.571  52.552  1.00 43.63           N  
ATOM    498  CA  ALA A  64      -2.111 -13.594  53.196  1.00 44.10           C  
ATOM    499  C   ALA A  64      -3.558 -13.145  53.121  1.00 44.31           C  
ATOM    500  O   ALA A  64      -3.887 -12.071  53.591  1.00 43.35           O  
ATOM    501  CB  ALA A  64      -1.688 -13.791  54.648  1.00 42.63           C  
ATOM    502  N   PHE A  65      -4.410 -13.969  52.499  1.00 45.62           N  
ATOM    503  CA  PHE A  65      -5.846 -13.787  52.515  1.00 46.02           C  
ATOM    504  C   PHE A  65      -6.446 -14.733  53.558  1.00 46.91           C  
ATOM    505  O   PHE A  65      -6.209 -15.943  53.534  1.00 46.95           O  
ATOM    506  CB  PHE A  65      -6.465 -14.081  51.139  1.00 46.40           C  
ATOM    507  CG  PHE A  65      -5.960 -13.183  50.035  1.00 46.52           C  
ATOM    508  CD1 PHE A  65      -6.693 -12.082  49.635  1.00 45.15           C  
ATOM    509  CD2 PHE A  65      -4.738 -13.446  49.412  1.00 46.95           C  
ATOM    510  CE1 PHE A  65      -6.229 -11.265  48.602  1.00 46.82           C  
ATOM    511  CE2 PHE A  65      -4.253 -12.643  48.409  1.00 45.72           C  
ATOM    512  CZ  PHE A  65      -4.989 -11.545  47.995  1.00 46.97           C  
ATOM    513  N   LEU A  66      -7.207 -14.156  54.480  1.00 48.04           N  
ATOM    514  CA  LEU A  66      -8.012 -14.901  55.429  1.00 49.05           C  
ATOM    515  C   LEU A  66      -9.461 -14.671  55.058  1.00 49.89           C  
ATOM    516  O   LEU A  66      -9.920 -13.515  54.986  1.00 49.81           O  
ATOM    517  CB  LEU A  66      -7.755 -14.395  56.832  1.00 49.44           C  
ATOM    518  CG  LEU A  66      -7.592 -15.349  57.987  1.00 50.37           C  
ATOM    519  CD1 LEU A  66      -6.903 -16.709  57.641  1.00 48.52           C  
ATOM    520  CD2 LEU A  66      -6.792 -14.537  59.023  1.00 50.24           C  
ATOM    521  N   ASN A  67     -10.162 -15.773  54.798  1.00 50.43           N  
ATOM    522  CA  ASN A  67     -11.548 -15.720  54.348  1.00 50.62           C  
ATOM    523  C   ASN A  67     -11.767 -14.760  53.157  1.00 50.64           C  
ATOM    524  O   ASN A  67     -12.723 -13.987  53.130  1.00 50.55           O  
ATOM    525  CB  ASN A  67     -12.436 -15.397  55.554  1.00 51.64           C  
ATOM    526  CG  ASN A  67     -12.261 -16.427  56.661  1.00 52.60           C  
ATOM    527  OD1 ASN A  67     -12.125 -16.102  57.843  1.00 56.44           O  
ATOM    528  ND2 ASN A  67     -12.188 -17.674  56.259  1.00 52.88           N  
ATOM    529  N   GLY A  68     -10.859 -14.827  52.184  1.00 49.58           N  
ATOM    530  CA  GLY A  68     -10.961 -14.003  50.975  1.00 49.30           C  
ATOM    531  C   GLY A  68     -10.540 -12.542  51.097  1.00 48.70           C  
ATOM    532  O   GLY A  68     -10.636 -11.816  50.127  1.00 48.68           O  
ATOM    533  N   LYS A  69     -10.094 -12.105  52.276  1.00 47.73           N  
ATOM    534  CA  LYS A  69      -9.610 -10.729  52.461  1.00 47.26           C  
ATOM    535  C   LYS A  69      -8.164 -10.714  52.932  1.00 46.13           C  
ATOM    536  O   LYS A  69      -7.786 -11.528  53.786  1.00 45.65           O  
ATOM    537  CB  LYS A  69     -10.460  -9.981  53.500  1.00 47.88           C  
ATOM    538  CG  LYS A  69     -11.932  -9.815  53.148  1.00 51.93           C  
ATOM    539  CD  LYS A  69     -12.185  -9.111  51.746  1.00 55.64           C  
ATOM    540  CE  LYS A  69     -11.950  -7.583  51.766  1.00 56.75           C  
ATOM    541  NZ  LYS A  69     -12.094  -7.009  50.392  1.00 56.43           N  
ATOM    542  N   ILE A  70      -7.370  -9.779  52.402  1.00 44.61           N  
ATOM    543  CA  ILE A  70      -5.986  -9.582  52.843  1.00 44.60           C  
ATOM    544  C   ILE A  70      -5.950  -9.349  54.351  1.00 44.02           C  
ATOM    545  O   ILE A  70      -6.592  -8.409  54.862  1.00 42.31           O  
ATOM    546  CB  ILE A  70      -5.289  -8.359  52.146  1.00 44.99           C  
ATOM    547  CG1 ILE A  70      -5.298  -8.516  50.635  1.00 44.66           C  
ATOM    548  CG2 ILE A  70      -3.832  -8.193  52.663  1.00 42.22           C  
ATOM    549  CD1 ILE A  70      -4.609  -7.333  49.869  1.00 44.46           C  
ATOM    550  N   ALA A  71      -5.202 -10.221  55.043  1.00 43.41           N  
ATOM    551  CA  ALA A  71      -5.021 -10.165  56.477  1.00 44.28           C  
ATOM    552  C   ALA A  71      -3.589  -9.761  56.902  1.00 44.41           C  
ATOM    553  O   ALA A  71      -3.382  -9.341  58.045  1.00 42.84           O  
ATOM    554  CB  ALA A  71      -5.391 -11.518  57.094  1.00 43.39           C  
ATOM    555  N   GLY A  72      -2.628  -9.898  55.979  1.00 44.64           N  
ATOM    556  CA  GLY A  72      -1.235  -9.609  56.255  1.00 45.19           C  
ATOM    557  C   GLY A  72      -0.385  -9.474  55.001  1.00 45.99           C  
ATOM    558  O   GLY A  72      -0.763  -9.942  53.933  1.00 47.91           O  
ATOM    559  N   ILE A  73       0.739  -8.782  55.116  1.00 45.97           N  
ATOM    560  CA  ILE A  73       1.703  -8.675  54.023  1.00 46.27           C  
ATOM    561  C   ILE A  73       3.123  -8.772  54.536  1.00 45.42           C  
ATOM    562  O   ILE A  73       3.415  -8.359  55.656  1.00 44.87           O  
ATOM    563  CB  ILE A  73       1.544  -7.366  53.207  1.00 46.84           C  
ATOM    564  CG1 ILE A  73       1.920  -6.128  54.023  1.00 48.81           C  
ATOM    565  CG2 ILE A  73       0.121  -7.257  52.661  1.00 48.73           C  
ATOM    566  CD1 ILE A  73       3.322  -5.568  53.647  1.00 53.08           C  
ATOM    567  N   VAL A  74       3.986  -9.376  53.734  1.00 45.73           N  
ATOM    568  CA  VAL A  74       5.423  -9.299  53.957  1.00 45.64           C  
ATOM    569  C   VAL A  74       6.037  -8.732  52.669  1.00 45.97           C  
ATOM    570  O   VAL A  74       5.691  -9.123  51.551  1.00 44.53           O  
ATOM    571  CB  VAL A  74       6.073 -10.649  54.443  1.00 45.45           C  
ATOM    572  CG1 VAL A  74       5.747 -11.809  53.541  1.00 45.60           C  
ATOM    573  CG2 VAL A  74       7.621 -10.496  54.591  1.00 46.71           C  
ATOM    574  N   ASN A  75       6.931  -7.770  52.851  1.00 46.52           N  
ATOM    575  CA  ASN A  75       7.543  -7.056  51.761  1.00 46.29           C  
ATOM    576  C   ASN A  75       9.055  -7.189  51.876  1.00 46.41           C  
ATOM    577  O   ASN A  75       9.634  -6.942  52.949  1.00 46.40           O  
ATOM    578  CB  ASN A  75       7.131  -5.611  51.892  1.00 47.03           C  
ATOM    579  CG  ASN A  75       6.946  -4.946  50.591  1.00 50.04           C  
ATOM    580  OD1 ASN A  75       7.750  -4.098  50.201  1.00 54.05           O  
ATOM    581  ND2 ASN A  75       5.894  -5.328  49.879  1.00 53.41           N  
ATOM    582  N   ILE A  76       9.698  -7.639  50.809  1.00 45.66           N  
ATOM    583  CA  ILE A  76      11.141  -7.466  50.696  1.00 45.75           C  
ATOM    584  C   ILE A  76      11.451  -6.453  49.603  1.00 45.73           C  
ATOM    585  O   ILE A  76      11.002  -6.573  48.467  1.00 44.76           O  
ATOM    586  CB  ILE A  76      11.890  -8.748  50.411  1.00 45.54           C  
ATOM    587  CG1 ILE A  76      11.621  -9.777  51.514  1.00 45.62           C  
ATOM    588  CG2 ILE A  76      13.373  -8.431  50.286  1.00 45.81           C  
ATOM    589  CD1 ILE A  76      12.173 -11.143  51.192  1.00 45.98           C  
ATOM    590  N   THR A  77      12.214  -5.452  50.002  1.00 45.60           N  
ATOM    591  CA  THR A  77      12.657  -4.355  49.165  1.00 46.17           C  
ATOM    592  C   THR A  77      14.179  -4.398  49.076  1.00 45.54           C  
ATOM    593  O   THR A  77      14.832  -4.916  49.962  1.00 44.22           O  
ATOM    594  CB  THR A  77      12.178  -3.052  49.805  1.00 45.84           C  
ATOM    595  OG1 THR A  77      11.019  -2.612  49.106  1.00 48.99           O  
ATOM    596  CG2 THR A  77      13.242  -1.999  49.808  1.00 49.33           C  
ATOM    597  N   ALA A  78      14.742  -3.857  48.001  1.00 45.72           N  
ATOM    598  CA  ALA A  78      16.185  -3.944  47.772  1.00 46.36           C  
ATOM    599  C   ALA A  78      16.661  -2.979  46.698  1.00 46.61           C  
ATOM    600  O   ALA A  78      15.978  -2.765  45.695  1.00 46.88           O  
ATOM    601  CB  ALA A  78      16.562  -5.368  47.384  1.00 45.46           C  
ATOM    602  N   ASP A  79      17.849  -2.429  46.902  1.00 47.54           N  
ATOM    603  CA  ASP A  79      18.552  -1.653  45.880  1.00 48.22           C  
ATOM    604  C   ASP A  79      19.177  -2.545  44.838  1.00 47.72           C  
ATOM    605  O   ASP A  79      19.352  -3.729  45.072  1.00 47.28           O  
ATOM    606  CB  ASP A  79      19.627  -0.802  46.545  1.00 49.79           C  
ATOM    607  CG  ASP A  79      19.029   0.344  47.338  1.00 54.47           C  
ATOM    608  OD1 ASP A  79      17.789   0.566  47.265  1.00 60.38           O  
ATOM    609  OD2 ASP A  79      19.790   1.031  48.033  1.00 61.44           O  
ATOM    610  N   GLN A  80      19.520  -1.968  43.683  1.00 47.41           N  
ATOM    611  CA  GLN A  80      19.969  -2.747  42.533  1.00 47.52           C  
ATOM    612  C   GLN A  80      21.468  -2.678  42.252  1.00 47.58           C  
ATOM    613  O   GLN A  80      21.973  -3.513  41.512  1.00 48.21           O  
ATOM    614  CB  GLN A  80      19.179  -2.348  41.269  1.00 48.03           C  
ATOM    615  CG  GLN A  80      17.673  -2.672  41.292  1.00 47.11           C  
ATOM    616  CD  GLN A  80      17.380  -4.088  41.746  1.00 46.51           C  
ATOM    617  OE1 GLN A  80      16.651  -4.301  42.728  1.00 48.96           O  
ATOM    618  NE2 GLN A  80      18.020  -5.060  41.101  1.00 46.43           N  
ATOM    619  N   ARG A  81      22.183  -1.719  42.837  1.00 47.36           N  
ATOM    620  CA  ARG A  81      23.663  -1.673  42.734  1.00 47.25           C  
ATOM    621  C   ARG A  81      24.337  -2.869  43.386  1.00 46.22           C  
ATOM    622  O   ARG A  81      23.913  -3.321  44.467  1.00 44.64           O  
ATOM    623  CB  ARG A  81      24.206  -0.400  43.367  1.00 47.60           C  
ATOM    624  CG  ARG A  81      24.015   0.826  42.462  1.00 49.24           C  
ATOM    625  CD  ARG A  81      24.590   2.062  43.097  1.00 49.94           C  
ATOM    626  NE  ARG A  81      24.792   3.158  42.124  1.00 53.19           N  
ATOM    627  CZ  ARG A  81      23.924   4.148  41.898  1.00 54.16           C  
ATOM    628  NH1 ARG A  81      22.766   4.220  42.554  1.00 55.12           N  
ATOM    629  NH2 ARG A  81      24.225   5.086  41.012  1.00 54.52           N  
ATOM    630  N   LYS A  82      25.387  -3.386  42.748  1.00 45.24           N  
ATOM    631  CA  LYS A  82      25.976  -4.640  43.220  1.00 46.50           C  
ATOM    632  C   LYS A  82      26.588  -4.567  44.615  1.00 45.39           C  
ATOM    633  O   LYS A  82      26.691  -5.608  45.281  1.00 45.83           O  
ATOM    634  CB  LYS A  82      26.976  -5.223  42.218  1.00 47.92           C  
ATOM    635  CG  LYS A  82      28.264  -4.458  42.061  1.00 50.92           C  
ATOM    636  CD  LYS A  82      29.433  -5.063  42.930  1.00 55.15           C  
ATOM    637  CE  LYS A  82      30.829  -4.673  42.389  1.00 54.68           C  
ATOM    638  NZ  LYS A  82      30.919  -3.209  42.001  1.00 56.05           N  
ATOM    639  N   ARG A  83      26.968  -3.361  45.067  1.00 44.61           N  
ATOM    640  CA  ARG A  83      27.463  -3.182  46.434  1.00 44.34           C  
ATOM    641  C   ARG A  83      26.472  -3.751  47.461  1.00 43.62           C  
ATOM    642  O   ARG A  83      26.892  -4.354  48.426  1.00 43.17           O  
ATOM    643  CB  ARG A  83      27.742  -1.715  46.783  1.00 43.71           C  
ATOM    644  CG  ARG A  83      28.616  -1.531  48.097  1.00 45.05           C  
ATOM    645  CD  ARG A  83      30.055  -1.041  47.808  1.00 48.93           C  
ATOM    646  NE  ARG A  83      30.642  -1.796  46.705  1.00 49.21           N  
ATOM    647  CZ  ARG A  83      31.281  -1.329  45.655  1.00 49.93           C  
ATOM    648  NH1 ARG A  83      31.538  -0.048  45.462  1.00 49.68           N  
ATOM    649  NH2 ARG A  83      31.705  -2.209  44.769  1.00 55.54           N  
ATOM    650  N   VAL A  84      25.169  -3.567  47.213  1.00 43.55           N  
ATOM    651  CA  VAL A  84      24.101  -3.814  48.188  1.00 43.82           C  
ATOM    652  C   VAL A  84      22.908  -4.649  47.679  1.00 44.18           C  
ATOM    653  O   VAL A  84      21.929  -4.861  48.400  1.00 43.80           O  
ATOM    654  CB  VAL A  84      23.599  -2.468  48.750  1.00 43.80           C  
ATOM    655  CG1 VAL A  84      24.712  -1.817  49.552  1.00 42.95           C  
ATOM    656  CG2 VAL A  84      23.126  -1.557  47.646  1.00 43.32           C  
ATOM    657  N   ARG A  85      23.039  -5.194  46.473  1.00 44.66           N  
ATOM    658  CA  ARG A  85      21.959  -5.937  45.784  1.00 44.57           C  
ATOM    659  C   ARG A  85      21.498  -7.222  46.535  1.00 43.11           C  
ATOM    660  O   ARG A  85      20.385  -7.703  46.337  1.00 42.03           O  
ATOM    661  CB  ARG A  85      22.449  -6.268  44.362  1.00 44.74           C  
ATOM    662  CG  ARG A  85      21.444  -6.920  43.464  1.00 46.85           C  
ATOM    663  CD  ARG A  85      21.723  -6.620  41.982  1.00 51.09           C  
ATOM    664  NE  ARG A  85      22.965  -7.230  41.524  1.00 55.54           N  
ATOM    665  CZ  ARG A  85      23.773  -6.735  40.575  1.00 56.70           C  
ATOM    666  NH1 ARG A  85      23.533  -5.568  39.968  1.00 57.21           N  
ATOM    667  NH2 ARG A  85      24.872  -7.416  40.240  1.00 57.77           N  
ATOM    668  N   HIS A  86      22.356  -7.726  47.407  1.00 41.53           N  
ATOM    669  CA  HIS A  86      22.139  -8.959  48.183  1.00 41.59           C  
ATOM    670  C   HIS A  86      21.412  -8.736  49.511  1.00 41.12           C  
ATOM    671  O   HIS A  86      21.179  -9.691  50.241  1.00 41.65           O  
ATOM    672  CB  HIS A  86      23.509  -9.606  48.474  1.00 41.35           C  
ATOM    673  CG  HIS A  86      24.425  -8.715  49.254  1.00 39.40           C  
ATOM    674  ND1 HIS A  86      24.584  -8.828  50.620  1.00 39.10           N  
ATOM    675  CD2 HIS A  86      25.125  -7.618  48.889  1.00 36.43           C  
ATOM    676  CE1 HIS A  86      25.404  -7.881  51.041  1.00 36.18           C  
ATOM    677  NE2 HIS A  86      25.732  -7.127  50.013  1.00 38.58           N  
ATOM    678  N   ILE A  87      21.061  -7.483  49.807  1.00 40.66           N  
ATOM    679  CA  ILE A  87      20.406  -7.082  51.045  1.00 40.38           C  
ATOM    680  C   ILE A  87      18.918  -6.741  50.807  1.00 40.73           C  
ATOM    681  O   ILE A  87      18.591  -5.809  50.058  1.00 40.98           O  
ATOM    682  CB  ILE A  87      21.081  -5.820  51.640  1.00 40.39           C  
ATOM    683  CG1 ILE A  87      22.594  -6.037  51.855  1.00 40.33           C  
ATOM    684  CG2 ILE A  87      20.411  -5.411  52.946  1.00 40.46           C  
ATOM    685  CD1 ILE A  87      23.358  -4.761  52.159  1.00 39.31           C  
ATOM    686  N   GLY A  88      18.035  -7.496  51.452  1.00 40.75           N  
ATOM    687  CA  GLY A  88      16.595  -7.257  51.414  1.00 40.91           C  
ATOM    688  C   GLY A  88      16.143  -6.607  52.697  1.00 41.08           C  
ATOM    689  O   GLY A  88      16.435  -7.092  53.798  1.00 40.87           O  
ATOM    690  N   ASP A  89      15.460  -5.478  52.560  1.00 42.55           N  
ATOM    691  CA  ASP A  89      14.851  -4.785  53.692  1.00 42.72           C  
ATOM    692  C   ASP A  89      13.468  -5.353  53.870  1.00 43.24           C  
ATOM    693  O   ASP A  89      12.650  -5.318  52.924  1.00 42.61           O  
ATOM    694  CB  ASP A  89      14.776  -3.289  53.386  1.00 43.21           C  
ATOM    695  CG  ASP A  89      16.165  -2.667  53.244  1.00 45.24           C  
ATOM    696  OD1 ASP A  89      16.900  -2.677  54.248  1.00 46.24           O  
ATOM    697  OD2 ASP A  89      16.535  -2.200  52.130  1.00 49.95           O  
ATOM    698  N   LEU A  90      13.211  -5.882  55.062  1.00 43.34           N  
ATOM    699  CA  LEU A  90      11.974  -6.594  55.346  1.00 44.28           C  
ATOM    700  C   LEU A  90      10.948  -5.665  56.028  1.00 44.12           C  
ATOM    701  O   LEU A  90      11.303  -4.816  56.861  1.00 43.93           O  
ATOM    702  CB  LEU A  90      12.287  -7.857  56.190  1.00 44.61           C  
ATOM    703  CG  LEU A  90      11.373  -9.094  56.291  1.00 46.12           C  
ATOM    704  CD1 LEU A  90      11.132  -9.845  55.008  1.00 48.63           C  
ATOM    705  CD2 LEU A  90      12.007 -10.081  57.281  1.00 47.40           C  
ATOM    706  N   PHE A  91       9.674  -5.834  55.639  1.00 44.36           N  
ATOM    707  CA  PHE A  91       8.519  -5.181  56.270  1.00 44.21           C  
ATOM    708  C   PHE A  91       7.370  -6.194  56.369  1.00 44.23           C  
ATOM    709  O   PHE A  91       7.012  -6.795  55.350  1.00 43.76           O  
ATOM    710  CB  PHE A  91       8.070  -3.987  55.424  1.00 45.44           C  
ATOM    711  CG  PHE A  91       6.832  -3.311  55.928  1.00 45.47           C  
ATOM    712  CD1 PHE A  91       6.878  -2.495  57.056  1.00 48.18           C  
ATOM    713  CD2 PHE A  91       5.618  -3.493  55.293  1.00 46.58           C  
ATOM    714  CE1 PHE A  91       5.725  -1.854  57.528  1.00 48.24           C  
ATOM    715  CE2 PHE A  91       4.463  -2.860  55.760  1.00 47.84           C  
ATOM    716  CZ  PHE A  91       4.519  -2.039  56.877  1.00 47.35           C  
ATOM    717  N   ILE A  92       6.799  -6.370  57.569  1.00 42.97           N  
ATOM    718  CA  ILE A  92       5.594  -7.209  57.780  1.00 43.49           C  
ATOM    719  C   ILE A  92       4.538  -6.472  58.604  1.00 42.93           C  
ATOM    720  O   ILE A  92       4.843  -5.822  59.604  1.00 42.19           O  
ATOM    721  CB  ILE A  92       5.927  -8.550  58.513  1.00 43.78           C  
ATOM    722  CG1 ILE A  92       7.071  -9.292  57.804  1.00 45.45           C  
ATOM    723  CG2 ILE A  92       4.681  -9.510  58.613  1.00 44.04           C  
ATOM    724  CD1 ILE A  92       7.453 -10.634  58.466  1.00 45.93           C  
ATOM    725  N   VAL A  93       3.277  -6.585  58.209  1.00 42.80           N  
ATOM    726  CA  VAL A  93       2.205  -6.085  59.052  1.00 42.49           C  
ATOM    727  C   VAL A  93       1.003  -6.996  58.907  1.00 42.34           C  
ATOM    728  O   VAL A  93       0.716  -7.472  57.809  1.00 40.14           O  
ATOM    729  CB  VAL A  93       1.852  -4.612  58.750  1.00 42.54           C  
ATOM    730  CG1 VAL A  93       1.499  -4.428  57.272  1.00 40.87           C  
ATOM    731  CG2 VAL A  93       0.723  -4.150  59.645  1.00 42.56           C  
ATOM    732  N   ILE A  94       0.360  -7.268  60.056  1.00 42.80           N  
ATOM    733  CA  ILE A  94      -0.837  -8.118  60.162  1.00 43.63           C  
ATOM    734  C   ILE A  94      -1.951  -7.240  60.745  1.00 43.71           C  
ATOM    735  O   ILE A  94      -1.682  -6.364  61.582  1.00 42.24           O  
ATOM    736  CB  ILE A  94      -0.592  -9.358  61.065  1.00 43.36           C  
ATOM    737  CG1 ILE A  94       0.572 -10.218  60.519  1.00 45.33           C  
ATOM    738  CG2 ILE A  94      -1.842 -10.237  61.178  1.00 43.02           C  
ATOM    739  CD1 ILE A  94       0.310 -10.872  59.151  1.00 46.50           C  
ATOM    740  N   GLY A  95      -3.181  -7.416  60.248  1.00 44.54           N  
ATOM    741  CA  GLY A  95      -4.335  -6.764  60.854  1.00 46.20           C  
ATOM    742  C   GLY A  95      -4.435  -7.150  62.315  1.00 47.29           C  
ATOM    743  O   GLY A  95      -4.247  -8.317  62.665  1.00 47.64           O  
ATOM    744  N   LYS A  96      -4.693  -6.159  63.160  1.00 49.42           N  
ATOM    745  CA  LYS A  96      -4.667  -6.309  64.596  1.00 50.94           C  
ATOM    746  C   LYS A  96      -5.608  -7.427  65.021  1.00 52.29           C  
ATOM    747  O   LYS A  96      -5.243  -8.301  65.792  1.00 51.50           O  
ATOM    748  CB  LYS A  96      -5.057  -4.992  65.270  1.00 51.32           C  
ATOM    749  CG  LYS A  96      -4.822  -4.962  66.788  1.00 51.77           C  
ATOM    750  CD  LYS A  96      -4.916  -3.526  67.359  1.00 52.32           C  
ATOM    751  CE  LYS A  96      -4.910  -3.566  68.887  1.00 55.75           C  
ATOM    752  NZ  LYS A  96      -4.670  -2.243  69.585  1.00 57.24           N  
ATOM    753  N   ARG A  97      -6.804  -7.407  64.446  1.00 54.14           N  
ATOM    754  CA  ARG A  97      -7.817  -8.434  64.668  1.00 55.20           C  
ATOM    755  C   ARG A  97      -7.268  -9.882  64.564  1.00 54.96           C  
ATOM    756  O   ARG A  97      -7.829 -10.778  65.192  1.00 55.57           O  
ATOM    757  CB  ARG A  97      -8.981  -8.226  63.671  1.00 55.66           C  
ATOM    758  CG  ARG A  97     -10.345  -8.659  64.178  1.00 57.48           C  
ATOM    759  CD  ARG A  97     -11.461  -7.576  63.872  1.00 61.85           C  
ATOM    760  NE  ARG A  97     -11.175  -6.281  64.539  1.00 66.13           N  
ATOM    761  CZ  ARG A  97     -10.859  -5.127  63.932  1.00 67.06           C  
ATOM    762  NH1 ARG A  97     -10.790  -5.026  62.593  1.00 68.51           N  
ATOM    763  NH2 ARG A  97     -10.620  -4.043  64.681  1.00 67.18           N  
ATOM    764  N   TYR A  98      -6.181 -10.104  63.805  1.00 54.26           N  
ATOM    765  CA  TYR A  98      -5.627 -11.465  63.590  1.00 53.88           C  
ATOM    766  C   TYR A  98      -4.286 -11.767  64.263  1.00 52.72           C  
ATOM    767  O   TYR A  98      -3.661 -12.813  63.997  1.00 51.56           O  
ATOM    768  CB  TYR A  98      -5.431 -11.732  62.105  1.00 54.93           C  
ATOM    769  CG  TYR A  98      -6.585 -11.377  61.197  1.00 56.03           C  
ATOM    770  CD1 TYR A  98      -6.568 -10.199  60.468  1.00 55.81           C  
ATOM    771  CD2 TYR A  98      -7.674 -12.253  61.028  1.00 57.65           C  
ATOM    772  CE1 TYR A  98      -7.600  -9.884  59.601  1.00 57.34           C  
ATOM    773  CE2 TYR A  98      -8.719 -11.948  60.143  1.00 57.37           C  
ATOM    774  CZ  TYR A  98      -8.665 -10.756  59.436  1.00 57.06           C  
ATOM    775  OH  TYR A  98      -9.661 -10.396  58.561  1.00 58.73           O  
ATOM    776  N   TRP A  99      -3.822 -10.862  65.111  1.00 51.76           N  
ATOM    777  CA  TRP A  99      -2.582 -11.083  65.824  1.00 51.52           C  
ATOM    778  C   TRP A  99      -2.603 -12.348  66.702  1.00 52.06           C  
ATOM    779  O   TRP A  99      -3.680 -12.831  67.131  1.00 52.27           O  
ATOM    780  CB  TRP A  99      -2.266  -9.894  66.713  1.00 50.69           C  
ATOM    781  CG  TRP A  99      -1.869  -8.642  66.013  1.00 50.07           C  
ATOM    782  CD1 TRP A  99      -1.633  -8.453  64.651  1.00 48.89           C  
ATOM    783  CD2 TRP A  99      -1.618  -7.386  66.637  1.00 49.29           C  
ATOM    784  NE1 TRP A  99      -1.259  -7.149  64.426  1.00 47.93           N  
ATOM    785  CE2 TRP A  99      -1.238  -6.474  65.617  1.00 49.29           C  
ATOM    786  CE3 TRP A  99      -1.671  -6.937  67.966  1.00 49.87           C  
ATOM    787  CZ2 TRP A  99      -0.930  -5.136  65.890  1.00 50.51           C  
ATOM    788  CZ3 TRP A  99      -1.358  -5.605  68.239  1.00 49.88           C  
ATOM    789  CH2 TRP A  99      -1.002  -4.718  67.203  1.00 49.21           C  
ATOM    790  N   ASN A 100      -1.401 -12.869  66.945  1.00 51.81           N  
ATOM    791  CA  ASN A 100      -1.156 -13.995  67.828  1.00 51.59           C  
ATOM    792  C   ASN A 100      -1.918 -15.259  67.491  1.00 51.64           C  
ATOM    793  O   ASN A 100      -2.434 -15.943  68.389  1.00 51.01           O  
ATOM    794  CB  ASN A 100      -1.436 -13.588  69.263  1.00 52.21           C  
ATOM    795  CG  ASN A 100      -0.696 -12.363  69.644  1.00 52.38           C  
ATOM    796  OD1 ASN A 100      -1.291 -11.339  70.010  1.00 52.23           O  
ATOM    797  ND2 ASN A 100       0.622 -12.427  69.512  1.00 51.10           N  
ATOM    798  N   ASN A 101      -1.997 -15.541  66.197  1.00 51.25           N  
ATOM    799  CA  ASN A 101      -2.544 -16.780  65.700  1.00 51.41           C  
ATOM    800  C   ASN A 101      -1.537 -17.519  64.820  1.00 51.42           C  
ATOM    801  O   ASN A 101      -1.883 -18.553  64.223  1.00 52.25           O  
ATOM    802  CB  ASN A 101      -3.830 -16.494  64.920  1.00 51.36           C  
ATOM    803  CG  ASN A 101      -4.983 -16.165  65.822  1.00 52.72           C  
ATOM    804  OD1 ASN A 101      -5.438 -17.015  66.586  1.00 57.55           O  
ATOM    805  ND2 ASN A 101      -5.446 -14.932  65.779  1.00 52.61           N  
ATOM    806  N   GLY A 102      -0.309 -17.001  64.720  1.00 50.36           N  
ATOM    807  CA  GLY A 102       0.720 -17.625  63.882  1.00 50.05           C  
ATOM    808  C   GLY A 102       0.858 -17.046  62.471  1.00 49.26           C  
ATOM    809  O   GLY A 102       1.700 -17.474  61.713  1.00 49.02           O  
ATOM    810  N   LEU A 103       0.057 -16.058  62.102  1.00 48.89           N  
ATOM    811  CA  LEU A 103       0.077 -15.591  60.703  1.00 48.64           C  
ATOM    812  C   LEU A 103       1.382 -14.863  60.347  1.00 47.91           C  
ATOM    813  O   LEU A 103       1.994 -15.129  59.298  1.00 47.66           O  
ATOM    814  CB  LEU A 103      -1.148 -14.718  60.389  1.00 48.72           C  
ATOM    815  CG  LEU A 103      -1.243 -14.289  58.918  1.00 49.02           C  
ATOM    816  CD1 LEU A 103      -1.211 -15.486  57.928  1.00 46.53           C  
ATOM    817  CD2 LEU A 103      -2.488 -13.424  58.742  1.00 48.75           C  
ATOM    818  N   GLY A 104       1.811 -13.968  61.236  1.00 47.50           N  
ATOM    819  CA  GLY A 104       3.106 -13.298  61.123  1.00 47.23           C  
ATOM    820  C   GLY A 104       4.265 -14.261  60.887  1.00 46.97           C  
ATOM    821  O   GLY A 104       5.099 -14.009  60.036  1.00 47.27           O  
ATOM    822  N   SER A 105       4.319 -15.360  61.641  1.00 46.73           N  
ATOM    823  CA  SER A 105       5.361 -16.383  61.478  1.00 47.14           C  
ATOM    824  C   SER A 105       5.322 -17.091  60.146  1.00 47.05           C  
ATOM    825  O   SER A 105       6.347 -17.324  59.549  1.00 47.15           O  
ATOM    826  CB  SER A 105       5.254 -17.469  62.557  1.00 46.94           C  
ATOM    827  OG  SER A 105       5.708 -16.969  63.775  1.00 47.47           O  
ATOM    828  N   LEU A 106       4.138 -17.501  59.725  1.00 47.64           N  
ATOM    829  CA  LEU A 106       3.970 -18.163  58.436  1.00 48.26           C  
ATOM    830  C   LEU A 106       4.497 -17.302  57.265  1.00 48.12           C  
ATOM    831  O   LEU A 106       5.205 -17.787  56.370  1.00 47.71           O  
ATOM    832  CB  LEU A 106       2.493 -18.442  58.237  1.00 48.89           C  
ATOM    833  CG  LEU A 106       2.015 -19.753  57.623  1.00 51.23           C  
ATOM    834  CD1 LEU A 106       2.859 -20.974  58.056  1.00 51.37           C  
ATOM    835  CD2 LEU A 106       0.510 -19.900  58.027  1.00 49.54           C  
ATOM    836  N   LEU A 107       4.146 -16.022  57.304  1.00 47.80           N  
ATOM    837  CA  LEU A 107       4.546 -15.047  56.286  1.00 47.95           C  
ATOM    838  C   LEU A 107       6.052 -14.779  56.342  1.00 47.61           C  
ATOM    839  O   LEU A 107       6.731 -14.794  55.315  1.00 46.89           O  
ATOM    840  CB  LEU A 107       3.769 -13.738  56.492  1.00 48.08           C  
ATOM    841  CG  LEU A 107       2.784 -13.133  55.474  1.00 48.98           C  
ATOM    842  CD1 LEU A 107       2.245 -14.101  54.403  1.00 48.40           C  
ATOM    843  CD2 LEU A 107       1.655 -12.444  56.243  1.00 48.00           C  
ATOM    844  N   LEU A 108       6.575 -14.560  57.550  1.00 48.03           N  
ATOM    845  CA  LEU A 108       8.016 -14.378  57.724  1.00 48.21           C  
ATOM    846  C   LEU A 108       8.779 -15.578  57.173  1.00 48.41           C  
ATOM    847  O   LEU A 108       9.789 -15.406  56.493  1.00 47.45           O  
ATOM    848  CB  LEU A 108       8.411 -14.178  59.202  1.00 47.85           C  
ATOM    849  CG  LEU A 108       9.530 -13.177  59.500  1.00 48.38           C  
ATOM    850  CD1 LEU A 108      10.283 -13.587  60.674  1.00 47.12           C  
ATOM    851  CD2 LEU A 108      10.509 -12.904  58.294  1.00 50.46           C  
ATOM    852  N   GLU A 109       8.305 -16.788  57.463  1.00 48.44           N  
ATOM    853  CA  GLU A 109       9.027 -17.980  56.999  1.00 49.59           C  
ATOM    854  C   GLU A 109       8.966 -18.139  55.501  1.00 49.11           C  
ATOM    855  O   GLU A 109       9.939 -18.567  54.883  1.00 48.43           O  
ATOM    856  CB  GLU A 109       8.536 -19.268  57.643  1.00 50.31           C  
ATOM    857  CG  GLU A 109       9.663 -20.096  58.379  1.00 55.76           C  
ATOM    858  CD  GLU A 109      11.121 -19.844  57.874  1.00 60.47           C  
ATOM    859  OE1 GLU A 109      11.962 -19.483  58.734  1.00 62.35           O  
ATOM    860  OE2 GLU A 109      11.427 -19.998  56.645  1.00 62.82           O  
ATOM    861  N   GLU A 110       7.823 -17.812  54.911  1.00 49.36           N  
ATOM    862  CA  GLU A 110       7.703 -17.871  53.460  1.00 49.70           C  
ATOM    863  C   GLU A 110       8.632 -16.864  52.784  1.00 49.18           C  
ATOM    864  O   GLU A 110       9.241 -17.149  51.726  1.00 49.21           O  
ATOM    865  CB  GLU A 110       6.264 -17.650  53.011  1.00 50.33           C  
ATOM    866  CG  GLU A 110       5.362 -18.863  53.211  1.00 54.94           C  
ATOM    867  CD  GLU A 110       6.008 -20.176  52.772  1.00 59.54           C  
ATOM    868  OE1 GLU A 110       6.543 -20.235  51.642  1.00 62.91           O  
ATOM    869  OE2 GLU A 110       5.993 -21.146  53.575  1.00 64.03           O  
ATOM    870  N   ALA A 111       8.730 -15.685  53.387  1.00 48.53           N  
ATOM    871  CA  ALA A 111       9.588 -14.637  52.858  1.00 47.96           C  
ATOM    872  C   ALA A 111      11.037 -15.101  52.927  1.00 47.67           C  
ATOM    873  O   ALA A 111      11.780 -14.941  51.971  1.00 46.90           O  
ATOM    874  CB  ALA A 111       9.385 -13.325  53.642  1.00 47.28           C  
ATOM    875  N   ILE A 112      11.434 -15.681  54.065  1.00 47.40           N  
ATOM    876  CA  ILE A 112      12.813 -16.166  54.253  1.00 47.60           C  
ATOM    877  C   ILE A 112      13.169 -17.277  53.249  1.00 47.97           C  
ATOM    878  O   ILE A 112      14.273 -17.313  52.700  1.00 47.16           O  
ATOM    879  CB  ILE A 112      13.043 -16.676  55.697  1.00 47.45           C  
ATOM    880  CG1 ILE A 112      12.970 -15.509  56.711  1.00 46.88           C  
ATOM    881  CG2 ILE A 112      14.373 -17.428  55.799  1.00 46.85           C  
ATOM    882  CD1 ILE A 112      12.797 -15.970  58.209  1.00 45.53           C  
ATOM    883  N   GLU A 113      12.221 -18.178  53.025  1.00 48.48           N  
ATOM    884  CA  GLU A 113      12.400 -19.275  52.088  1.00 49.87           C  
ATOM    885  C   GLU A 113      12.570 -18.747  50.662  1.00 49.87           C  
ATOM    886  O   GLU A 113      13.437 -19.216  49.934  1.00 50.09           O  
ATOM    887  CB  GLU A 113      11.185 -20.184  52.134  1.00 50.21           C  
ATOM    888  CG  GLU A 113      11.506 -21.635  52.261  1.00 52.61           C  
ATOM    889  CD  GLU A 113      10.244 -22.465  52.410  1.00 53.98           C  
ATOM    890  OE1 GLU A 113      10.076 -23.113  53.482  1.00 59.40           O  
ATOM    891  OE2 GLU A 113       9.423 -22.439  51.451  1.00 60.17           O  
ATOM    892  N   TRP A 114      11.736 -17.778  50.264  1.00 50.17           N  
ATOM    893  CA  TRP A 114      11.881 -17.147  48.961  1.00 50.31           C  
ATOM    894  C   TRP A 114      13.264 -16.483  48.867  1.00 50.53           C  
ATOM    895  O   TRP A 114      13.964 -16.630  47.864  1.00 50.74           O  
ATOM    896  CB  TRP A 114      10.758 -16.129  48.694  1.00 51.01           C  
ATOM    897  CG  TRP A 114      10.889 -15.473  47.342  1.00 51.37           C  
ATOM    898  CD1 TRP A 114      10.363 -15.916  46.162  1.00 52.01           C  
ATOM    899  CD2 TRP A 114      11.645 -14.293  47.021  1.00 52.87           C  
ATOM    900  NE1 TRP A 114      10.735 -15.090  45.136  1.00 52.29           N  
ATOM    901  CE2 TRP A 114      11.525 -14.088  45.633  1.00 52.76           C  
ATOM    902  CE3 TRP A 114      12.416 -13.394  47.770  1.00 52.72           C  
ATOM    903  CZ2 TRP A 114      12.122 -13.010  44.986  1.00 52.85           C  
ATOM    904  CZ3 TRP A 114      13.012 -12.339  47.124  1.00 51.50           C  
ATOM    905  CH2 TRP A 114      12.865 -12.156  45.748  1.00 52.49           C  
ATOM    906  N   ALA A 115      13.668 -15.776  49.919  1.00 50.24           N  
ATOM    907  CA  ALA A 115      14.916 -15.037  49.889  1.00 50.68           C  
ATOM    908  C   ALA A 115      16.085 -15.998  49.687  1.00 51.02           C  
ATOM    909  O   ALA A 115      16.977 -15.738  48.891  1.00 49.97           O  
ATOM    910  CB  ALA A 115      15.083 -14.218  51.164  1.00 50.08           C  
ATOM    911  N   GLN A 116      16.051 -17.113  50.407  1.00 51.71           N  
ATOM    912  CA  GLN A 116      17.014 -18.206  50.243  1.00 52.84           C  
ATOM    913  C   GLN A 116      17.067 -18.748  48.809  1.00 53.27           C  
ATOM    914  O   GLN A 116      18.147 -18.918  48.237  1.00 54.73           O  
ATOM    915  CB  GLN A 116      16.696 -19.346  51.235  1.00 53.06           C  
ATOM    916  CG  GLN A 116      17.003 -18.997  52.698  1.00 54.30           C  
ATOM    917  CD  GLN A 116      16.407 -19.967  53.725  1.00 55.03           C  
ATOM    918  OE1 GLN A 116      15.485 -20.740  53.434  1.00 60.85           O  
ATOM    919  NE2 GLN A 116      16.921 -19.911  54.942  1.00 58.54           N  
ATOM    920  N   ALA A 117      15.910 -18.990  48.208  1.00 53.37           N  
ATOM    921  CA  ALA A 117      15.876 -19.586  46.883  1.00 52.94           C  
ATOM    922  C   ALA A 117      16.316 -18.619  45.766  1.00 53.38           C  
ATOM    923  O   ALA A 117      16.786 -19.060  44.711  1.00 53.96           O  
ATOM    924  CB  ALA A 117      14.490 -20.143  46.604  1.00 52.86           C  
ATOM    925  N   SER A 118      16.183 -17.312  45.997  1.00 52.99           N  
ATOM    926  CA  SER A 118      16.412 -16.300  44.959  1.00 51.91           C  
ATOM    927  C   SER A 118      17.812 -16.337  44.344  1.00 51.81           C  
ATOM    928  O   SER A 118      17.998 -15.921  43.190  1.00 52.13           O  
ATOM    929  CB  SER A 118      16.145 -14.895  45.504  1.00 51.73           C  
ATOM    930  OG  SER A 118      17.198 -14.472  46.353  1.00 50.13           O  
ATOM    931  N   GLY A 119      18.797 -16.791  45.114  1.00 51.04           N  
ATOM    932  CA  GLY A 119      20.178 -16.836  44.643  1.00 50.38           C  
ATOM    933  C   GLY A 119      20.878 -15.487  44.628  1.00 49.99           C  
ATOM    934  O   GLY A 119      22.028 -15.394  44.210  1.00 50.26           O  
ATOM    935  N   ILE A 120      20.195 -14.444  45.103  1.00 48.81           N  
ATOM    936  CA  ILE A 120      20.719 -13.072  45.069  1.00 47.95           C  
ATOM    937  C   ILE A 120      20.803 -12.521  46.494  1.00 46.80           C  
ATOM    938  O   ILE A 120      21.821 -11.961  46.893  1.00 46.04           O  
ATOM    939  CB  ILE A 120      19.836 -12.152  44.202  1.00 47.80           C  
ATOM    940  CG1 ILE A 120      19.591 -12.792  42.821  1.00 49.27           C  
ATOM    941  CG2 ILE A 120      20.481 -10.742  44.037  1.00 48.56           C  
ATOM    942  CD1 ILE A 120      18.425 -12.186  42.011  1.00 47.88           C  
ATOM    943  N   LEU A 121      19.727 -12.678  47.267  1.00 45.99           N  
ATOM    944  CA  LEU A 121      19.721 -12.137  48.613  1.00 45.20           C  
ATOM    945  C   LEU A 121      20.583 -13.033  49.471  1.00 44.86           C  
ATOM    946  O   LEU A 121      20.455 -14.274  49.423  1.00 44.37           O  
ATOM    947  CB  LEU A 121      18.299 -12.000  49.164  1.00 44.38           C  
ATOM    948  CG  LEU A 121      17.387 -11.025  48.404  1.00 44.55           C  
ATOM    949  CD1 LEU A 121      15.983 -11.133  48.909  1.00 42.65           C  
ATOM    950  CD2 LEU A 121      17.881  -9.541  48.438  1.00 41.35           C  
ATOM    951  N   ARG A 122      21.506 -12.389  50.195  1.00 44.67           N  
ATOM    952  CA  ARG A 122      22.348 -13.027  51.199  1.00 44.34           C  
ATOM    953  C   ARG A 122      22.210 -12.376  52.593  1.00 43.94           C  
ATOM    954  O   ARG A 122      22.931 -12.712  53.528  1.00 44.69           O  
ATOM    955  CB  ARG A 122      23.805 -12.961  50.750  1.00 44.60           C  
ATOM    956  CG  ARG A 122      24.076 -13.578  49.370  1.00 45.34           C  
ATOM    957  CD  ARG A 122      23.700 -15.066  49.265  1.00 47.04           C  
ATOM    958  NE  ARG A 122      24.395 -15.874  50.268  1.00 47.25           N  
ATOM    959  CZ  ARG A 122      25.690 -16.186  50.215  1.00 48.24           C  
ATOM    960  NH1 ARG A 122      26.443 -15.798  49.193  1.00 48.96           N  
ATOM    961  NH2 ARG A 122      26.241 -16.898  51.186  1.00 48.47           N  
ATOM    962  N   ARG A 123      21.294 -11.437  52.729  1.00 43.23           N  
ATOM    963  CA  ARG A 123      21.037 -10.766  54.000  1.00 42.74           C  
ATOM    964  C   ARG A 123      19.618 -10.176  54.000  1.00 42.03           C  
ATOM    965  O   ARG A 123      19.163  -9.614  52.979  1.00 41.49           O  
ATOM    966  CB  ARG A 123      22.086  -9.671  54.274  1.00 42.63           C  
ATOM    967  CG  ARG A 123      21.642  -8.657  55.348  1.00 43.29           C  
ATOM    968  CD  ARG A 123      22.611  -7.500  55.596  1.00 42.66           C  
ATOM    969  NE  ARG A 123      23.217  -7.821  56.815  1.00 48.22           N  
ATOM    970  CZ  ARG A 123      22.889  -7.386  58.034  1.00 46.20           C  
ATOM    971  NH1 ARG A 123      22.032  -6.420  58.279  1.00 42.42           N  
ATOM    972  NH2 ARG A 123      23.558  -7.903  59.023  1.00 45.34           N  
ATOM    973  N   LEU A 124      18.920 -10.353  55.126  1.00 42.21           N  
ATOM    974  CA  LEU A 124      17.679  -9.644  55.420  1.00 42.14           C  
ATOM    975  C   LEU A 124      17.862  -8.773  56.671  1.00 41.63           C  
ATOM    976  O   LEU A 124      18.586  -9.117  57.605  1.00 40.37           O  
ATOM    977  CB  LEU A 124      16.482 -10.596  55.601  1.00 42.40           C  
ATOM    978  CG  LEU A 124      16.153 -11.551  54.449  1.00 43.81           C  
ATOM    979  CD1 LEU A 124      15.054 -12.528  54.871  1.00 45.09           C  
ATOM    980  CD2 LEU A 124      15.741 -10.797  53.177  1.00 42.92           C  
ATOM    981  N   GLN A 125      17.203  -7.626  56.658  1.00 42.06           N  
ATOM    982  CA  GLN A 125      17.362  -6.655  57.707  1.00 42.10           C  
ATOM    983  C   GLN A 125      16.129  -5.773  57.841  1.00 42.94           C  
ATOM    984  O   GLN A 125      15.336  -5.629  56.895  1.00 42.05           O  
ATOM    985  CB  GLN A 125      18.585  -5.781  57.423  1.00 42.03           C  
ATOM    986  CG  GLN A 125      18.420  -4.821  56.227  1.00 40.56           C  
ATOM    987  CD  GLN A 125      19.650  -3.955  56.007  1.00 41.57           C  
ATOM    988  OE1 GLN A 125      20.748  -4.295  56.435  1.00 40.37           O  
ATOM    989  NE2 GLN A 125      19.462  -2.816  55.351  1.00 38.98           N  
ATOM    990  N   LEU A 126      15.985  -5.205  59.040  1.00 43.20           N  
ATOM    991  CA  LEU A 126      14.994  -4.191  59.344  1.00 43.15           C  
ATOM    992  C   LEU A 126      15.432  -3.455  60.583  1.00 43.18           C  
ATOM    993  O   LEU A 126      16.428  -3.805  61.193  1.00 43.10           O  
ATOM    994  CB  LEU A 126      13.632  -4.806  59.613  1.00 43.93           C  
ATOM    995  CG  LEU A 126      13.447  -5.740  60.823  1.00 45.33           C  
ATOM    996  CD1 LEU A 126      11.974  -5.768  61.032  1.00 51.20           C  
ATOM    997  CD2 LEU A 126      13.969  -7.144  60.640  1.00 44.79           C  
ATOM    998  N   THR A 127      14.691  -2.406  60.909  1.00 42.99           N  
ATOM    999  CA  THR A 127      14.774  -1.729  62.174  1.00 43.61           C  
ATOM   1000  C   THR A 127      13.385  -1.874  62.786  1.00 43.31           C  
ATOM   1001  O   THR A 127      12.381  -1.872  62.058  1.00 42.52           O  
ATOM   1002  CB  THR A 127      15.110  -0.240  62.026  1.00 43.28           C  
ATOM   1003  OG1 THR A 127      14.048   0.378  61.333  1.00 44.07           O  
ATOM   1004  CG2 THR A 127      16.373  -0.013  61.229  1.00 44.26           C  
ATOM   1005  N   VAL A 128      13.348  -1.989  64.113  1.00 42.85           N  
ATOM   1006  CA  VAL A 128      12.128  -2.243  64.885  1.00 43.56           C  
ATOM   1007  C   VAL A 128      12.179  -1.366  66.148  1.00 43.93           C  
ATOM   1008  O   VAL A 128      13.208  -1.347  66.834  1.00 44.76           O  
ATOM   1009  CB  VAL A 128      12.028  -3.764  65.347  1.00 43.58           C  
ATOM   1010  CG1 VAL A 128      10.721  -4.037  66.122  1.00 41.55           C  
ATOM   1011  CG2 VAL A 128      12.101  -4.701  64.132  1.00 44.56           C  
ATOM   1012  N   GLN A 129      11.081  -0.688  66.492  1.00 43.50           N  
ATOM   1013  CA  GLN A 129      11.065   0.113  67.719  1.00 44.07           C  
ATOM   1014  C   GLN A 129      11.367  -0.797  68.929  1.00 43.63           C  
ATOM   1015  O   GLN A 129      10.866  -1.919  69.017  1.00 43.10           O  
ATOM   1016  CB  GLN A 129       9.735   0.834  67.900  1.00 44.45           C  
ATOM   1017  CG  GLN A 129       9.378   1.869  66.822  1.00 44.15           C  
ATOM   1018  CD  GLN A 129       7.919   2.345  66.924  1.00 44.58           C  
ATOM   1019  OE1 GLN A 129       7.171   1.919  67.817  1.00 43.75           O  
ATOM   1020  NE2 GLN A 129       7.509   3.220  66.000  1.00 46.27           N  
ATOM   1021  N   THR A 130      12.225  -0.358  69.830  1.00 44.10           N  
ATOM   1022  CA  THR A 130      12.658  -1.275  70.907  1.00 44.64           C  
ATOM   1023  C   THR A 130      11.461  -1.710  71.772  1.00 44.83           C  
ATOM   1024  O   THR A 130      11.368  -2.858  72.197  1.00 44.85           O  
ATOM   1025  CB  THR A 130      13.783  -0.692  71.750  1.00 44.59           C  
ATOM   1026  OG1 THR A 130      13.341   0.524  72.348  1.00 46.42           O  
ATOM   1027  CG2 THR A 130      15.014  -0.434  70.893  1.00 41.38           C  
ATOM   1028  N   ARG A 131      10.498  -0.810  71.940  1.00 45.10           N  
ATOM   1029  CA  ARG A 131       9.262  -1.123  72.660  1.00 45.18           C  
ATOM   1030  C   ARG A 131       8.325  -2.101  71.949  1.00 44.67           C  
ATOM   1031  O   ARG A 131       7.388  -2.593  72.559  1.00 44.42           O  
ATOM   1032  CB  ARG A 131       8.487   0.177  72.911  1.00 45.47           C  
ATOM   1033  CG  ARG A 131       7.884   0.754  71.652  1.00 45.67           C  
ATOM   1034  CD  ARG A 131       7.056   1.977  71.902  1.00 46.07           C  
ATOM   1035  NE  ARG A 131       6.505   2.402  70.642  1.00 46.05           N  
ATOM   1036  CZ  ARG A 131       5.304   2.952  70.450  1.00 48.80           C  
ATOM   1037  NH1 ARG A 131       4.457   3.183  71.443  1.00 48.02           N  
ATOM   1038  NH2 ARG A 131       4.946   3.289  69.226  1.00 48.81           N  
ATOM   1039  N   ASN A 132       8.515  -2.328  70.648  1.00 44.62           N  
ATOM   1040  CA  ASN A 132       7.628  -3.232  69.894  1.00 44.40           C  
ATOM   1041  C   ASN A 132       8.029  -4.713  70.130  1.00 44.44           C  
ATOM   1042  O   ASN A 132       8.510  -5.403  69.249  1.00 43.86           O  
ATOM   1043  CB  ASN A 132       7.594  -2.818  68.403  1.00 44.10           C  
ATOM   1044  CG  ASN A 132       6.588  -3.615  67.579  1.00 43.76           C  
ATOM   1045  OD1 ASN A 132       5.867  -4.475  68.105  1.00 45.79           O  
ATOM   1046  ND2 ASN A 132       6.555  -3.356  66.281  1.00 42.31           N  
ATOM   1047  N   GLN A 133       7.805  -5.203  71.340  1.00 44.92           N  
ATOM   1048  CA  GLN A 133       8.403  -6.475  71.759  1.00 45.85           C  
ATOM   1049  C   GLN A 133       7.838  -7.726  71.066  1.00 45.64           C  
ATOM   1050  O   GLN A 133       8.522  -8.741  70.939  1.00 44.69           O  
ATOM   1051  CB  GLN A 133       8.266  -6.648  73.263  1.00 46.79           C  
ATOM   1052  CG  GLN A 133       9.512  -7.256  73.885  1.00 52.38           C  
ATOM   1053  CD  GLN A 133      10.407  -6.188  74.427  1.00 56.28           C  
ATOM   1054  OE1 GLN A 133      10.469  -5.988  75.653  1.00 63.88           O  
ATOM   1055  NE2 GLN A 133      11.077  -5.458  73.538  1.00 59.65           N  
ATOM   1056  N   ALA A 134       6.579  -7.654  70.647  1.00 45.68           N  
ATOM   1057  CA  ALA A 134       5.964  -8.705  69.844  1.00 45.45           C  
ATOM   1058  C   ALA A 134       6.796  -8.910  68.582  1.00 45.16           C  
ATOM   1059  O   ALA A 134       7.137 -10.043  68.230  1.00 45.73           O  
ATOM   1060  CB  ALA A 134       4.520  -8.314  69.484  1.00 45.84           C  
ATOM   1061  N   ALA A 135       7.119  -7.802  67.927  1.00 44.50           N  
ATOM   1062  CA  ALA A 135       7.928  -7.800  66.707  1.00 44.31           C  
ATOM   1063  C   ALA A 135       9.352  -8.246  66.996  1.00 43.92           C  
ATOM   1064  O   ALA A 135       9.910  -9.046  66.241  1.00 43.44           O  
ATOM   1065  CB  ALA A 135       7.922  -6.455  66.070  1.00 43.53           C  
ATOM   1066  N   VAL A 136       9.918  -7.778  68.113  1.00 43.63           N  
ATOM   1067  CA  VAL A 136      11.297  -8.100  68.426  1.00 43.18           C  
ATOM   1068  C   VAL A 136      11.368  -9.599  68.658  1.00 43.00           C  
ATOM   1069  O   VAL A 136      12.275 -10.271  68.190  1.00 41.55           O  
ATOM   1070  CB  VAL A 136      11.869  -7.253  69.615  1.00 43.83           C  
ATOM   1071  CG1 VAL A 136      13.193  -7.830  70.107  1.00 43.42           C  
ATOM   1072  CG2 VAL A 136      12.084  -5.784  69.201  1.00 41.21           C  
ATOM   1073  N   HIS A 137      10.353 -10.127  69.330  1.00 43.93           N  
ATOM   1074  CA  HIS A 137      10.240 -11.565  69.563  1.00 43.99           C  
ATOM   1075  C   HIS A 137      10.048 -12.405  68.284  1.00 43.83           C  
ATOM   1076  O   HIS A 137      10.673 -13.479  68.116  1.00 42.55           O  
ATOM   1077  CB  HIS A 137       9.088 -11.855  70.515  1.00 44.15           C  
ATOM   1078  CG  HIS A 137       8.797 -13.309  70.651  1.00 44.88           C  
ATOM   1079  ND1 HIS A 137       9.511 -14.130  71.494  1.00 48.49           N  
ATOM   1080  CD2 HIS A 137       7.904 -14.102  70.017  1.00 46.96           C  
ATOM   1081  CE1 HIS A 137       9.052 -15.366  71.393  1.00 49.08           C  
ATOM   1082  NE2 HIS A 137       8.083 -15.376  70.493  1.00 48.26           N  
ATOM   1083  N   LEU A 138       9.146 -11.944  67.422  1.00 44.01           N  
ATOM   1084  CA  LEU A 138       8.811 -12.679  66.223  1.00 44.53           C  
ATOM   1085  C   LEU A 138      10.084 -12.830  65.409  1.00 44.88           C  
ATOM   1086  O   LEU A 138      10.432 -13.930  65.007  1.00 45.07           O  
ATOM   1087  CB  LEU A 138       7.709 -11.967  65.407  1.00 44.75           C  
ATOM   1088  CG  LEU A 138       7.376 -12.569  64.013  1.00 45.62           C  
ATOM   1089  CD1 LEU A 138       6.630 -13.900  64.103  1.00 44.56           C  
ATOM   1090  CD2 LEU A 138       6.622 -11.599  63.162  1.00 44.94           C  
ATOM   1091  N   TYR A 139      10.781 -11.725  65.178  1.00 44.87           N  
ATOM   1092  CA  TYR A 139      11.992 -11.763  64.376  1.00 45.49           C  
ATOM   1093  C   TYR A 139      13.112 -12.643  64.990  1.00 45.48           C  
ATOM   1094  O   TYR A 139      13.754 -13.419  64.257  1.00 44.53           O  
ATOM   1095  CB  TYR A 139      12.456 -10.346  64.054  1.00 46.46           C  
ATOM   1096  CG  TYR A 139      11.622  -9.696  62.966  1.00 47.28           C  
ATOM   1097  CD1 TYR A 139      11.774 -10.082  61.631  1.00 50.12           C  
ATOM   1098  CD2 TYR A 139      10.706  -8.697  63.249  1.00 48.29           C  
ATOM   1099  CE1 TYR A 139      11.044  -9.479  60.600  1.00 49.37           C  
ATOM   1100  CE2 TYR A 139       9.947  -8.089  62.223  1.00 49.03           C  
ATOM   1101  CZ  TYR A 139      10.126  -8.492  60.902  1.00 49.22           C  
ATOM   1102  OH  TYR A 139       9.411  -7.911  59.859  1.00 49.68           O  
ATOM   1103  N   GLN A 140      13.324 -12.551  66.307  1.00 45.32           N  
ATOM   1104  CA  GLN A 140      14.315 -13.412  66.989  1.00 46.10           C  
ATOM   1105  C   GLN A 140      13.992 -14.884  66.751  1.00 45.62           C  
ATOM   1106  O   GLN A 140      14.866 -15.682  66.467  1.00 45.40           O  
ATOM   1107  CB  GLN A 140      14.377 -13.114  68.491  1.00 46.28           C  
ATOM   1108  CG  GLN A 140      14.979 -11.742  68.814  1.00 48.72           C  
ATOM   1109  CD  GLN A 140      15.269 -11.551  70.307  1.00 49.09           C  
ATOM   1110  OE1 GLN A 140      14.390 -11.194  71.108  1.00 53.47           O  
ATOM   1111  NE2 GLN A 140      16.513 -11.797  70.682  1.00 54.10           N  
ATOM   1112  N   LYS A 141      12.718 -15.236  66.858  1.00 45.69           N  
ATOM   1113  CA  LYS A 141      12.281 -16.599  66.588  1.00 45.99           C  
ATOM   1114  C   LYS A 141      12.771 -17.133  65.230  1.00 45.24           C  
ATOM   1115  O   LYS A 141      13.046 -18.317  65.094  1.00 44.61           O  
ATOM   1116  CB  LYS A 141      10.749 -16.665  66.670  1.00 46.05           C  
ATOM   1117  CG  LYS A 141      10.106 -18.054  66.513  1.00 47.33           C  
ATOM   1118  CD  LYS A 141       8.563 -17.936  66.767  1.00 48.66           C  
ATOM   1119  CE  LYS A 141       7.698 -18.803  65.798  1.00 49.94           C  
ATOM   1120  NZ  LYS A 141       6.195 -18.549  65.939  1.00 49.38           N  
ATOM   1121  N   HIS A 142      12.882 -16.264  64.225  1.00 44.55           N  
ATOM   1122  CA  HIS A 142      13.223 -16.721  62.888  1.00 44.27           C  
ATOM   1123  C   HIS A 142      14.653 -16.447  62.546  1.00 43.80           C  
ATOM   1124  O   HIS A 142      14.993 -16.378  61.366  1.00 44.25           O  
ATOM   1125  CB  HIS A 142      12.274 -16.105  61.852  1.00 44.53           C  
ATOM   1126  CG  HIS A 142      10.888 -16.653  61.934  1.00 45.84           C  
ATOM   1127  ND1 HIS A 142       9.954 -16.171  62.824  1.00 45.73           N  
ATOM   1128  CD2 HIS A 142      10.294 -17.678  61.276  1.00 48.14           C  
ATOM   1129  CE1 HIS A 142       8.841 -16.872  62.710  1.00 46.76           C  
ATOM   1130  NE2 HIS A 142       9.021 -17.800  61.785  1.00 48.99           N  
ATOM   1131  N   GLY A 143      15.492 -16.262  63.561  1.00 43.25           N  
ATOM   1132  CA  GLY A 143      16.941 -16.186  63.348  1.00 43.67           C  
ATOM   1133  C   GLY A 143      17.518 -14.797  63.147  1.00 43.41           C  
ATOM   1134  O   GLY A 143      18.680 -14.657  62.840  1.00 43.43           O  
ATOM   1135  N   PHE A 144      16.715 -13.764  63.356  1.00 43.52           N  
ATOM   1136  CA  PHE A 144      17.214 -12.402  63.312  1.00 43.15           C  
ATOM   1137  C   PHE A 144      17.867 -12.046  64.639  1.00 42.62           C  
ATOM   1138  O   PHE A 144      17.312 -12.308  65.677  1.00 41.45           O  
ATOM   1139  CB  PHE A 144      16.081 -11.423  63.034  1.00 43.42           C  
ATOM   1140  CG  PHE A 144      15.639 -11.396  61.598  1.00 45.39           C  
ATOM   1141  CD1 PHE A 144      16.029 -10.363  60.748  1.00 42.70           C  
ATOM   1142  CD2 PHE A 144      14.826 -12.400  61.097  1.00 45.88           C  
ATOM   1143  CE1 PHE A 144      15.623 -10.333  59.441  1.00 44.38           C  
ATOM   1144  CE2 PHE A 144      14.441 -12.387  59.793  1.00 45.62           C  
ATOM   1145  CZ  PHE A 144      14.835 -11.339  58.951  1.00 45.07           C  
ATOM   1146  N   VAL A 145      19.018 -11.383  64.589  1.00 42.59           N  
ATOM   1147  CA  VAL A 145      19.717 -10.960  65.796  1.00 42.10           C  
ATOM   1148  C   VAL A 145      19.777  -9.429  65.841  1.00 41.62           C  
ATOM   1149  O   VAL A 145      19.733  -8.769  64.795  1.00 41.36           O  
ATOM   1150  CB  VAL A 145      21.118 -11.557  65.810  1.00 42.30           C  
ATOM   1151  CG1 VAL A 145      21.023 -13.101  65.699  1.00 43.13           C  
ATOM   1152  CG2 VAL A 145      21.947 -10.990  64.688  1.00 43.19           C  
ATOM   1153  N   ILE A 146      19.863  -8.878  67.038  1.00 40.63           N  
ATOM   1154  CA  ILE A 146      19.983  -7.447  67.225  1.00 41.58           C  
ATOM   1155  C   ILE A 146      21.443  -7.049  67.005  1.00 41.45           C  
ATOM   1156  O   ILE A 146      22.340  -7.559  67.650  1.00 42.05           O  
ATOM   1157  CB  ILE A 146      19.467  -6.989  68.627  1.00 41.31           C  
ATOM   1158  CG1 ILE A 146      17.959  -7.250  68.717  1.00 40.31           C  
ATOM   1159  CG2 ILE A 146      19.790  -5.520  68.854  1.00 40.66           C  
ATOM   1160  CD1 ILE A 146      17.395  -7.281  70.071  1.00 42.45           C  
ATOM   1161  N   GLU A 147      21.654  -6.139  66.076  1.00 41.91           N  
ATOM   1162  CA  GLU A 147      22.982  -5.724  65.642  1.00 42.43           C  
ATOM   1163  C   GLU A 147      23.336  -4.334  66.111  1.00 42.69           C  
ATOM   1164  O   GLU A 147      24.418  -3.833  65.805  1.00 42.56           O  
ATOM   1165  CB  GLU A 147      23.009  -5.735  64.110  1.00 41.89           C  
ATOM   1166  CG  GLU A 147      22.867  -7.143  63.577  1.00 43.16           C  
ATOM   1167  CD  GLU A 147      22.530  -7.203  62.115  1.00 44.26           C  
ATOM   1168  OE1 GLU A 147      21.832  -6.284  61.612  1.00 47.67           O  
ATOM   1169  OE2 GLU A 147      22.980  -8.185  61.470  1.00 46.48           O  
ATOM   1170  N   GLY A 148      22.410  -3.693  66.813  1.00 42.81           N  
ATOM   1171  CA  GLY A 148      22.587  -2.302  67.183  1.00 43.24           C  
ATOM   1172  C   GLY A 148      21.300  -1.644  67.620  1.00 43.23           C  
ATOM   1173  O   GLY A 148      20.225  -2.238  67.563  1.00 42.63           O  
ATOM   1174  N   SER A 149      21.417  -0.397  68.048  1.00 43.73           N  
ATOM   1175  CA  SER A 149      20.243   0.391  68.385  1.00 44.49           C  
ATOM   1176  C   SER A 149      20.539   1.856  68.160  1.00 45.17           C  
ATOM   1177  O   SER A 149      21.714   2.285  68.219  1.00 44.97           O  
ATOM   1178  CB  SER A 149      19.776   0.124  69.819  1.00 44.65           C  
ATOM   1179  OG  SER A 149      20.612   0.750  70.747  1.00 46.17           O  
ATOM   1180  N   GLN A 150      19.472   2.595  67.832  1.00 45.10           N  
ATOM   1181  CA  GLN A 150      19.562   3.969  67.358  1.00 45.20           C  
ATOM   1182  C   GLN A 150      18.553   4.838  68.123  1.00 45.40           C  
ATOM   1183  O   GLN A 150      17.339   4.604  68.143  1.00 44.47           O  
ATOM   1184  CB  GLN A 150      19.364   4.043  65.825  1.00 45.11           C  
ATOM   1185  CG  GLN A 150      20.549   3.398  65.067  1.00 45.32           C  
ATOM   1186  CD  GLN A 150      20.429   3.398  63.579  1.00 45.57           C  
ATOM   1187  OE1 GLN A 150      19.349   3.267  63.044  1.00 48.84           O  
ATOM   1188  NE2 GLN A 150      21.555   3.539  62.889  1.00 46.59           N  
ATOM   1189  N   GLU A 151      19.104   5.832  68.789  1.00 45.69           N  
ATOM   1190  CA  GLU A 151      18.324   6.823  69.494  1.00 46.27           C  
ATOM   1191  C   GLU A 151      17.670   7.807  68.477  1.00 45.08           C  
ATOM   1192  O   GLU A 151      18.282   8.198  67.515  1.00 44.17           O  
ATOM   1193  CB  GLU A 151      19.251   7.525  70.474  1.00 45.83           C  
ATOM   1194  CG  GLU A 151      18.539   8.199  71.593  1.00 50.01           C  
ATOM   1195  CD  GLU A 151      19.512   8.767  72.656  1.00 50.29           C  
ATOM   1196  OE1 GLU A 151      19.091   9.691  73.395  1.00 53.99           O  
ATOM   1197  OE2 GLU A 151      20.686   8.312  72.705  1.00 54.32           O  
ATOM   1198  N   ARG A 152      16.415   8.166  68.727  1.00 44.72           N  
ATOM   1199  CA  ARG A 152      15.582   8.926  67.823  1.00 44.73           C  
ATOM   1200  C   ARG A 152      15.372   8.200  66.498  1.00 45.02           C  
ATOM   1201  O   ARG A 152      15.251   8.831  65.477  1.00 45.03           O  
ATOM   1202  CB  ARG A 152      16.155  10.330  67.572  1.00 44.91           C  
ATOM   1203  CG  ARG A 152      16.533  11.060  68.836  1.00 43.98           C  
ATOM   1204  CD  ARG A 152      16.941  12.463  68.592  1.00 44.44           C  
ATOM   1205  NE  ARG A 152      17.128  13.146  69.871  1.00 44.97           N  
ATOM   1206  CZ  ARG A 152      17.620  14.374  70.035  1.00 46.22           C  
ATOM   1207  NH1 ARG A 152      18.023  15.101  69.004  1.00 46.97           N  
ATOM   1208  NH2 ARG A 152      17.737  14.871  71.264  1.00 46.27           N  
ATOM   1209  N   GLY A 153      15.334   6.879  66.504  1.00 45.04           N  
ATOM   1210  CA  GLY A 153      15.013   6.129  65.305  1.00 45.70           C  
ATOM   1211  C   GLY A 153      13.590   6.368  64.815  1.00 45.99           C  
ATOM   1212  O   GLY A 153      13.280   6.150  63.650  1.00 46.21           O  
ATOM   1213  N   ALA A 154      12.721   6.798  65.718  1.00 47.41           N  
ATOM   1214  CA  ALA A 154      11.319   7.025  65.414  1.00 48.04           C  
ATOM   1215  C   ALA A 154      10.778   8.169  66.282  1.00 49.12           C  
ATOM   1216  O   ALA A 154      11.231   8.391  67.436  1.00 47.11           O  
ATOM   1217  CB  ALA A 154      10.530   5.760  65.671  1.00 46.67           C  
ATOM   1218  N   TYR A 155       9.781   8.848  65.719  1.00 50.63           N  
ATOM   1219  CA  TYR A 155       9.070   9.935  66.364  1.00 51.95           C  
ATOM   1220  C   TYR A 155       7.596   9.547  66.526  1.00 53.06           C  
ATOM   1221  O   TYR A 155       6.949   9.163  65.544  1.00 53.02           O  
ATOM   1222  CB  TYR A 155       9.213  11.160  65.472  1.00 54.14           C  
ATOM   1223  CG  TYR A 155       8.532  12.397  65.969  1.00 53.84           C  
ATOM   1224  CD1 TYR A 155       7.379  12.888  65.339  1.00 57.38           C  
ATOM   1225  CD2 TYR A 155       9.051  13.102  67.036  1.00 56.62           C  
ATOM   1226  CE1 TYR A 155       6.751  14.035  65.793  1.00 57.42           C  
ATOM   1227  CE2 TYR A 155       8.432  14.255  67.506  1.00 58.45           C  
ATOM   1228  CZ  TYR A 155       7.288  14.722  66.875  1.00 59.16           C  
ATOM   1229  OH  TYR A 155       6.690  15.876  67.357  1.00 60.31           O  
ATOM   1230  N   ILE A 156       7.063   9.608  67.747  1.00 53.79           N  
ATOM   1231  CA  ILE A 156       5.657   9.239  67.994  1.00 55.19           C  
ATOM   1232  C   ILE A 156       4.922  10.290  68.820  1.00 56.95           C  
ATOM   1233  O   ILE A 156       5.540  11.158  69.424  1.00 56.95           O  
ATOM   1234  CB  ILE A 156       5.493   7.837  68.710  1.00 54.38           C  
ATOM   1235  CG1 ILE A 156       6.212   7.804  70.063  1.00 54.46           C  
ATOM   1236  CG2 ILE A 156       5.952   6.683  67.817  1.00 52.65           C  
ATOM   1237  CD1 ILE A 156       5.732   6.677  70.991  1.00 53.49           C  
ATOM   1238  N   GLU A 157       3.593  10.200  68.835  1.00 59.24           N  
ATOM   1239  CA  GLU A 157       2.764  10.959  69.789  1.00 61.22           C  
ATOM   1240  C   GLU A 157       3.007  12.473  69.753  1.00 62.80           C  
ATOM   1241  O   GLU A 157       2.875  13.163  70.778  1.00 63.94           O  
ATOM   1242  CB  GLU A 157       2.993  10.435  71.214  1.00 61.10           C  
ATOM   1243  CG  GLU A 157       2.524   8.997  71.386  1.00 62.22           C  
ATOM   1244  CD  GLU A 157       2.979   8.359  72.688  1.00 63.38           C  
ATOM   1245  OE1 GLU A 157       3.675   9.017  73.502  1.00 66.60           O  
ATOM   1246  OE2 GLU A 157       2.636   7.167  72.894  1.00 68.32           O  
ATOM   1247  N   GLU A 158       3.397  12.979  68.587  1.00 64.35           N  
ATOM   1248  CA  GLU A 158       3.615  14.409  68.408  1.00 64.55           C  
ATOM   1249  C   GLU A 158       4.540  14.919  69.543  1.00 64.36           C  
ATOM   1250  O   GLU A 158       4.111  15.685  70.406  1.00 65.17           O  
ATOM   1251  CB  GLU A 158       2.222  15.100  68.338  1.00 65.30           C  
ATOM   1252  CG  GLU A 158       2.108  16.591  68.758  1.00 66.72           C  
ATOM   1253  CD  GLU A 158       0.777  16.905  69.478  1.00 67.94           C  
ATOM   1254  OE1 GLU A 158      -0.277  16.894  68.778  1.00 71.88           O  
ATOM   1255  OE2 GLU A 158       0.802  17.163  70.723  1.00 70.66           O  
ATOM   1256  N   GLY A 159       5.792  14.444  69.565  1.00 63.19           N  
ATOM   1257  CA  GLY A 159       6.791  14.947  70.510  1.00 61.71           C  
ATOM   1258  C   GLY A 159       7.694  13.941  71.214  1.00 60.91           C  
ATOM   1259  O   GLY A 159       8.649  14.342  71.869  1.00 61.42           O  
ATOM   1260  N   LYS A 160       7.427  12.643  71.090  1.00 58.98           N  
ATOM   1261  CA  LYS A 160       8.233  11.650  71.773  1.00 57.49           C  
ATOM   1262  C   LYS A 160       9.161  10.942  70.793  1.00 55.53           C  
ATOM   1263  O   LYS A 160       8.703  10.222  69.926  1.00 54.82           O  
ATOM   1264  CB  LYS A 160       7.335  10.610  72.449  1.00 58.64           C  
ATOM   1265  CG  LYS A 160       7.621  10.325  73.919  1.00 60.79           C  
ATOM   1266  CD  LYS A 160       6.431  10.752  74.804  1.00 63.74           C  
ATOM   1267  CE  LYS A 160       6.808  10.829  76.316  1.00 64.92           C  
ATOM   1268  NZ  LYS A 160       5.746  11.438  77.184  1.00 64.44           N  
ATOM   1269  N   PHE A 161      10.469  11.123  70.964  1.00 53.29           N  
ATOM   1270  CA  PHE A 161      11.462  10.296  70.280  1.00 51.89           C  
ATOM   1271  C   PHE A 161      11.710   8.980  70.988  1.00 50.12           C  
ATOM   1272  O   PHE A 161      11.801   8.928  72.206  1.00 49.21           O  
ATOM   1273  CB  PHE A 161      12.778  11.046  70.140  1.00 51.93           C  
ATOM   1274  CG  PHE A 161      12.673  12.244  69.264  1.00 52.38           C  
ATOM   1275  CD1 PHE A 161      12.703  12.107  67.894  1.00 51.93           C  
ATOM   1276  CD2 PHE A 161      12.554  13.519  69.812  1.00 53.30           C  
ATOM   1277  CE1 PHE A 161      12.607  13.196  67.092  1.00 51.49           C  
ATOM   1278  CE2 PHE A 161      12.478  14.610  69.010  1.00 51.85           C  
ATOM   1279  CZ  PHE A 161      12.491  14.451  67.644  1.00 52.73           C  
ATOM   1280  N   ILE A 162      11.805   7.913  70.212  1.00 48.43           N  
ATOM   1281  CA  ILE A 162      12.055   6.588  70.757  1.00 47.22           C  
ATOM   1282  C   ILE A 162      13.161   5.885  69.962  1.00 46.12           C  
ATOM   1283  O   ILE A 162      13.452   6.230  68.800  1.00 44.94           O  
ATOM   1284  CB  ILE A 162      10.773   5.704  70.777  1.00 47.50           C  
ATOM   1285  CG1 ILE A 162      10.247   5.434  69.354  1.00 46.14           C  
ATOM   1286  CG2 ILE A 162       9.661   6.307  71.674  1.00 46.95           C  
ATOM   1287  CD1 ILE A 162       9.085   4.459  69.358  1.00 46.67           C  
ATOM   1288  N   ASP A 163      13.737   4.871  70.596  1.00 44.74           N  
ATOM   1289  CA  ASP A 163      14.802   4.053  70.021  1.00 44.54           C  
ATOM   1290  C   ASP A 163      14.274   2.911  69.164  1.00 43.16           C  
ATOM   1291  O   ASP A 163      13.176   2.368  69.390  1.00 42.69           O  
ATOM   1292  CB  ASP A 163      15.680   3.413  71.123  1.00 45.38           C  
ATOM   1293  CG  ASP A 163      16.507   4.432  71.922  1.00 47.19           C  
ATOM   1294  OD1 ASP A 163      16.004   5.510  72.266  1.00 50.14           O  
ATOM   1295  OD2 ASP A 163      17.677   4.142  72.235  1.00 54.44           O  
ATOM   1296  N   VAL A 164      15.125   2.514  68.226  1.00 42.70           N  
ATOM   1297  CA  VAL A 164      14.927   1.343  67.375  1.00 42.10           C  
ATOM   1298  C   VAL A 164      16.102   0.362  67.487  1.00 41.92           C  
ATOM   1299  O   VAL A 164      17.224   0.759  67.725  1.00 41.76           O  
ATOM   1300  CB  VAL A 164      14.694   1.733  65.904  1.00 41.66           C  
ATOM   1301  CG1 VAL A 164      13.431   2.589  65.792  1.00 41.74           C  
ATOM   1302  CG2 VAL A 164      15.911   2.465  65.255  1.00 38.87           C  
ATOM   1303  N   TYR A 165      15.817  -0.921  67.312  1.00 41.86           N  
ATOM   1304  CA  TYR A 165      16.836  -1.922  67.098  1.00 41.73           C  
ATOM   1305  C   TYR A 165      17.066  -2.058  65.606  1.00 42.09           C  
ATOM   1306  O   TYR A 165      16.142  -2.015  64.813  1.00 42.59           O  
ATOM   1307  CB  TYR A 165      16.408  -3.287  67.659  1.00 41.77           C  
ATOM   1308  CG  TYR A 165      16.463  -3.398  69.195  1.00 41.36           C  
ATOM   1309  CD1 TYR A 165      17.632  -3.056  69.902  1.00 41.48           C  
ATOM   1310  CD2 TYR A 165      15.370  -3.872  69.920  1.00 41.05           C  
ATOM   1311  CE1 TYR A 165      17.695  -3.168  71.304  1.00 41.79           C  
ATOM   1312  CE2 TYR A 165      15.413  -4.003  71.307  1.00 41.51           C  
ATOM   1313  CZ  TYR A 165      16.590  -3.639  72.002  1.00 42.02           C  
ATOM   1314  OH  TYR A 165      16.667  -3.752  73.380  1.00 43.01           O  
ATOM   1315  N   LEU A 166      18.324  -2.216  65.251  1.00 41.94           N  
ATOM   1316  CA  LEU A 166      18.747  -2.776  63.972  1.00 41.62           C  
ATOM   1317  C   LEU A 166      18.789  -4.298  64.085  1.00 41.51           C  
ATOM   1318  O   LEU A 166      19.461  -4.831  64.989  1.00 41.17           O  
ATOM   1319  CB  LEU A 166      20.178  -2.309  63.696  1.00 42.18           C  
ATOM   1320  CG  LEU A 166      20.474  -0.814  63.653  1.00 41.99           C  
ATOM   1321  CD1 LEU A 166      22.019  -0.614  63.750  1.00 40.99           C  
ATOM   1322  CD2 LEU A 166      19.881  -0.255  62.366  1.00 45.86           C  
ATOM   1323  N   MET A 167      18.058  -4.996  63.216  1.00 40.66           N  
ATOM   1324  CA  MET A 167      18.000  -6.461  63.275  1.00 39.75           C  
ATOM   1325  C   MET A 167      18.366  -7.068  61.910  1.00 40.74           C  
ATOM   1326  O   MET A 167      18.012  -6.525  60.844  1.00 39.10           O  
ATOM   1327  CB  MET A 167      16.603  -6.924  63.668  1.00 39.66           C  
ATOM   1328  CG  MET A 167      16.065  -6.397  65.024  1.00 39.57           C  
ATOM   1329  SD  MET A 167      14.656  -7.323  65.675  1.00 34.60           S  
ATOM   1330  CE  MET A 167      15.464  -8.885  65.962  1.00 37.41           C  
ATOM   1331  N   GLY A 168      19.068  -8.196  61.932  1.00 40.95           N  
ATOM   1332  CA  GLY A 168      19.562  -8.801  60.692  1.00 41.19           C  
ATOM   1333  C   GLY A 168      19.660 -10.310  60.699  1.00 41.53           C  
ATOM   1334  O   GLY A 168      19.741 -10.906  61.756  1.00 41.58           O  
ATOM   1335  N   LYS A 169      19.630 -10.911  59.501  1.00 42.48           N  
ATOM   1336  CA  LYS A 169      19.777 -12.350  59.299  1.00 42.70           C  
ATOM   1337  C   LYS A 169      20.551 -12.647  58.019  1.00 43.63           C  
ATOM   1338  O   LYS A 169      20.239 -12.082  56.946  1.00 44.31           O  
ATOM   1339  CB  LYS A 169      18.404 -13.001  59.225  1.00 42.74           C  
ATOM   1340  CG  LYS A 169      18.438 -14.527  59.138  1.00 43.00           C  
ATOM   1341  CD  LYS A 169      17.097 -15.085  58.716  1.00 43.56           C  
ATOM   1342  CE  LYS A 169      17.150 -16.596  58.574  1.00 43.81           C  
ATOM   1343  NZ  LYS A 169      17.152 -17.280  59.891  1.00 44.08           N  
ATOM   1344  N   LEU A 170      21.560 -13.508  58.112  1.00 43.65           N  
ATOM   1345  CA  LEU A 170      22.290 -13.951  56.918  1.00 44.37           C  
ATOM   1346  C   LEU A 170      21.579 -15.145  56.317  1.00 44.85           C  
ATOM   1347  O   LEU A 170      21.103 -16.003  57.046  1.00 45.46           O  
ATOM   1348  CB  LEU A 170      23.735 -14.313  57.238  1.00 44.16           C  
ATOM   1349  CG  LEU A 170      24.561 -13.232  57.923  1.00 44.27           C  
ATOM   1350  CD1 LEU A 170      26.002 -13.712  58.173  1.00 43.21           C  
ATOM   1351  CD2 LEU A 170      24.529 -11.945  57.124  1.00 40.59           C  
ATOM   1352  N   ILE A 171      21.475 -15.179  54.990  1.00 45.68           N  
ATOM   1353  CA  ILE A 171      20.815 -16.281  54.276  1.00 45.74           C  
ATOM   1354  C   ILE A 171      21.657 -16.811  53.110  1.00 44.92           C  
ATOM   1355  O   ILE A 171      22.568 -16.120  52.645  1.00 43.95           O  
ATOM   1356  CB  ILE A 171      19.420 -15.878  53.789  1.00 46.69           C  
ATOM   1357  CG1 ILE A 171      19.448 -14.568  53.013  1.00 47.34           C  
ATOM   1358  CG2 ILE A 171      18.396 -15.748  54.986  1.00 47.50           C  
ATOM   1359  CD1 ILE A 171      18.067 -14.152  52.634  1.00 46.67           C  
TER    1360      ILE A 171                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
