
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  159 ( 1197),  selected  159 , name 2r7h_B
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 2r7h_B.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    18_B      R      26          3.423
LGA    V    19_B      Y      27          1.609
LGA    A    20_B      H      28          1.378
LGA    F    21_B      L      29          1.292
LGA    R    22_B      R      30          1.382
LGA    R    23_B      P      31          1.009
LGA    Q    24_B      P      32          4.091
LGA    V    25_B      R      33          1.161
LGA    L    26_B      R      34          3.240
LGA    P    27_B      N      35          1.261
LGA    Q    28_B      -       -           -
LGA    D    29_B      D      36          1.251
LGA    A    30_B      G      37          1.358
LGA    L    31_B      A      38          1.528
LGA    L    32_B      A      39          0.915
LGA    V    33_B      I      40          0.845
LGA    R    34_B      H      41          1.629
LGA    R    35_B      Q      42          1.923
LGA    V    36_B      L      43          1.426
LGA    V    37_B      V      44          1.109
LGA    E    38_B      S      45          1.938
LGA    S    39_B      E      46          2.009
LGA    T    40_B      C      47          1.798
LGA    G    41_B      P      48          1.373
LGA    F    42_B      P      49          1.730
LGA    F    43_B      L      50          2.382
LGA    T    44_B      -       -           -
LGA    P    45_B      -       -           -
LGA    E    46_B      -       -           -
LGA    E    47_B      D      51          2.604
LGA    A    48_B      L      52          1.452
LGA    D    49_B      N      53          1.975
LGA    V    50_B      S      54          4.638
LGA    A    51_B      -       -           -
LGA    Q    52_B      L      55          3.598
LGA    E    53_B      Y      56          3.036
LGA    L    54_B      A      57          3.170
LGA    V    55_B      Y      58          2.599
LGA    D    56_B      L      59          1.212
LGA    E    57_B      L      60          1.538
LGA    H    58_B      L      61          4.112
LGA    L    59_B      C      62          5.201
LGA    X    60_B      E      63          5.563
LGA    H    61_B      -       -           -
LGA    G    62_B      -       -           -
LGA    A    63_B      H      64          3.233
LGA    A    64_B      -       -           -
LGA    C    65_B      -       -           -
LGA    G    66_B      H      65          4.521
LGA    Y    67_B      A      66          6.061
LGA    H    68_B      H      67          4.456
LGA    -       -      T      68           -
LGA    F    69_B      C      69          1.597
LGA    V    70_B      V      70          0.757
LGA    F    71_B      V      71          0.826
LGA    A    72_B      A      72          0.851
LGA    T    73_B      E      73          0.472
LGA    E    74_B      S      74          0.630
LGA    D    75_B      P      75          2.356
LGA    D    76_B      G      76          3.228
LGA    -       -      G      77           -
LGA    D    77_B      R      78          0.586
LGA    X    78_B      I      79          0.676
LGA    A    79_B      D      80          1.998
LGA    G    80_B      G      81          0.501
LGA    Y    81_B      F      82          1.328
LGA    A    82_B      V      83          0.956
LGA    C    83_B      S      84          0.820
LGA    Y    84_B      A      85          0.471
LGA    G    85_B      Y      86          0.313
LGA    P    86_B      L      87          0.783
LGA    T    87_B      L      88          0.670
LGA    P    88_B      P      89          1.988
LGA    A    89_B      T      90          0.906
LGA    T    90_B      R      91          1.387
LGA    E    91_B      P      92          3.150
LGA    G    92_B      D      93          1.268
LGA    T    93_B      V      94          1.255
LGA    Y    94_B      L      95          1.341
LGA    D    95_B      F      96          0.271
LGA    L    96_B      V      97          0.993
LGA    Y    97_B      W      98          0.995
LGA    W    98_B      Q      99          1.877
LGA    I    99_B      V     100          1.523
LGA    A   100_B      A     101          0.805
LGA    V   101_B      V     102          0.934
LGA    A   102_B      H     103          0.850
LGA    P   103_B      S     104          0.377
LGA    H   104_B      R     105          1.104
LGA    R   105_B      A     106          0.794
LGA    Q   106_B      R     107          1.557
LGA    H   107_B      G     108          1.582
LGA    S   108_B      H     109          1.297
LGA    G   109_B      R     110          1.501
LGA    L   110_B      L     111          1.401
LGA    G   111_B      G     112          1.413
LGA    R   112_B      R     113          1.280
LGA    A   113_B      A     114          0.739
LGA    L   114_B      M     115          0.528
LGA    L   115_B      L     116          1.035
LGA    A   116_B      G     117          0.779
LGA    E   117_B      H     118          0.390
LGA    V   118_B      I     119          1.389
LGA    V   119_B      L     120          1.085
LGA    H   120_B      E     121          0.771
LGA    D   121_B      R     122          2.083
LGA    -       -      Q     123           -
LGA    V   122_B      E     124          4.981
LGA    R   123_B      C     125          3.299
LGA    L   124_B      R     126          2.955
LGA    T   125_B      -       -           -
LGA    G   126_B      H     127          1.859
LGA    G   127_B      V     128          1.563
LGA    R   128_B      R     129          1.475
LGA    L   129_B      H     130          1.408
LGA    L   130_B      L     131          1.337
LGA    F   131_B      E     132          1.009
LGA    A   132_B      T     133          1.355
LGA    E   133_B      T     134          1.108
LGA    T   134_B      V     135          1.232
LGA    S   135_B      G     136          1.276
LGA    G   136_B      P     137          1.476
LGA    I   137_B      D     138          3.504
LGA    R   138_B      -       -           -
LGA    K   139_B      -       -           -
LGA    Y   140_B      N     139          1.703
LGA    A   141_B      Q     140          2.297
LGA    P   142_B      A     141          1.984
LGA    T   143_B      S     142          1.348
LGA    R   144_B      R     143          1.820
LGA    R   145_B      R     144          2.327
LGA    F   146_B      T     145          2.112
LGA    Y   147_B      F     146          1.810
LGA    E   148_B      A     147          2.041
LGA    R   149_B      G     148          2.791
LGA    A   150_B      L     149          2.564
LGA    G   151_B      A     150          2.087
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    F   152_B      A     155           #
LGA    S   153_B      H     156          4.645
LGA    A   154_B      V     157          4.176
LGA    E   155_B      S     158          2.086
LGA    A   156_B      E     159          3.599
LGA    V   157_B      Q     160          1.775
LGA    L   158_B      P     161          1.620
LGA    K   159_B      F     162           #
LGA    A   160_B      -       -           -
LGA    F   161_B      F     163          2.713
LGA    Y   162_B      D     164          3.315
LGA    R   163_B      R     165          2.363
LGA    A   164_B      Q     166           #
LGA    G   165_B      A     167           -
LGA    -       -      F     168           -
LGA    -       -      G     169           -
LGA    -       -      G     170           -
LGA    -       -      A     171           -
LGA    -       -      D     172           -
LGA    -       -      H     173           -
LGA    D   166_B      D     174          4.268
LGA    D   167_B      D     175          3.733
LGA    K   168_B      E     176          2.838
LGA    I   169_B      M     177          2.154
LGA    I   170_B      L     178          1.798
LGA    Y   171_B      L     179          1.819
LGA    R   172_B      R     180          1.999
LGA    L   173_B      I     181          2.438
LGA    E   174_B      G     182          2.432
LGA    -       -      P     183           -
LGA    V   175_B      F     184          3.225
LGA    A   176_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  159  159    5.0    141    2.25    17.02     65.884     6.001

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.647416 * X  +  -0.624941 * Y  +   0.436236 * Z  +  10.172662
  Y_new =  -0.263537 * X  +   0.353508 * Y  +   0.897541 * Z  + -26.782442
  Z_new =  -0.715123 * X  +  -0.696047 * Y  +   0.064172 * Z  + 102.956566 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.478861    1.662732  [ DEG:   -84.7325     95.2675 ]
  Theta =   0.796800    2.344793  [ DEG:    45.6533    134.3467 ]
  Phi   =  -0.386577    2.755016  [ DEG:   -22.1492    157.8508 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2r7h_B                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2r7h_B.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  159  159   5.0  141   2.25   17.02  65.884
REMARK  ---------------------------------------------------------- 
MOLECULE 2r7h_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   07-SEP-07   2R7H              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE D-ALANINE N-ACETYLTRANSFERASE           
TITLE    2 OF GNAT FAMILY (YP_389533.1) FROM DESULFOVIBRIO                      
TITLE    3 DESULFURICANS G20 AT 1.85 A RESOLUTION                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE D-ALANINE N-ACETYLTRANSFERASE OF GNAT             
COMPND   3 FAMILY;                                                              
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DESULFOVIBRIO DESULFURICANS G20;                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: G20;                                                         
SOURCE   5 GENE: YP_389533.1, DDE_3044;                                         
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_389533.1, PUTATIVE D-ALANINE N-ACETYLTRANSFERASE OF GNAT           
KEYWDS   2 FAMILY, STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL             
KEYWDS   3 GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2,                 
KEYWDS   4 STRUCTURAL GENOMICS, UNKNOWN FUNCTION                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   25-SEP-07 2R7H    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE D-ALANINE                      
JRNL        TITL 2 N-ACETYLTRANSFERASE OF GNAT FAMILY (YP_389533.1)             
JRNL        TITL 3 FROM DESULFOVIBRIO DESULFURICANS G20 AT 1.85 A               
JRNL        TITL 4 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  2R7H A    1   176  UNP    Q30WV8   Q30WV8_DESDG     1    176             
DBREF  2R7H B    1   176  UNP    Q30WV8   Q30WV8_DESDG     1    176             
SEQRES   1 A  177  GLY MSE PRO GLN THR LEU LYS PRO ASP THR PRO ALA GLY          
SEQRES   2 A  177  THR PRO ALA ALA GLY ALA VAL ALA PHE ARG ARG GLN VAL          
SEQRES   3 A  177  LEU PRO GLN ASP ALA LEU LEU VAL ARG ARG VAL VAL GLU          
SEQRES   4 A  177  SER THR GLY PHE PHE THR PRO GLU GLU ALA ASP VAL ALA          
SEQRES   5 A  177  GLN GLU LEU VAL ASP GLU HIS LEU MSE HIS GLY ALA ALA          
SEQRES   6 A  177  CYS GLY TYR HIS PHE VAL PHE ALA THR GLU ASP ASP ASP          
SEQRES   7 A  177  MSE ALA GLY TYR ALA CYS TYR GLY PRO THR PRO ALA THR          
SEQRES   8 A  177  GLU GLY THR TYR ASP LEU TYR TRP ILE ALA VAL ALA PRO          
SEQRES   9 A  177  HIS ARG GLN HIS SER GLY LEU GLY ARG ALA LEU LEU ALA          
SEQRES  10 A  177  GLU VAL VAL HIS ASP VAL ARG LEU THR GLY GLY ARG LEU          
SEQRES  11 A  177  LEU PHE ALA GLU THR SER GLY ILE ARG LYS TYR ALA PRO          
SEQRES  12 A  177  THR ARG ARG PHE TYR GLU ARG ALA GLY PHE SER ALA GLU          
SEQRES  13 A  177  ALA VAL LEU LYS ALA PHE TYR ARG ALA GLY ASP ASP LYS          
SEQRES  14 A  177  ILE ILE TYR ARG LEU GLU VAL ALA                              
SEQRES   1 B  177  GLY MSE PRO GLN THR LEU LYS PRO ASP THR PRO ALA GLY          
SEQRES   2 B  177  THR PRO ALA ALA GLY ALA VAL ALA PHE ARG ARG GLN VAL          
SEQRES   3 B  177  LEU PRO GLN ASP ALA LEU LEU VAL ARG ARG VAL VAL GLU          
SEQRES   4 B  177  SER THR GLY PHE PHE THR PRO GLU GLU ALA ASP VAL ALA          
SEQRES   5 B  177  GLN GLU LEU VAL ASP GLU HIS LEU MSE HIS GLY ALA ALA          
SEQRES   6 B  177  CYS GLY TYR HIS PHE VAL PHE ALA THR GLU ASP ASP ASP          
SEQRES   7 B  177  MSE ALA GLY TYR ALA CYS TYR GLY PRO THR PRO ALA THR          
SEQRES   8 B  177  GLU GLY THR TYR ASP LEU TYR TRP ILE ALA VAL ALA PRO          
SEQRES   9 B  177  HIS ARG GLN HIS SER GLY LEU GLY ARG ALA LEU LEU ALA          
SEQRES  10 B  177  GLU VAL VAL HIS ASP VAL ARG LEU THR GLY GLY ARG LEU          
SEQRES  11 B  177  LEU PHE ALA GLU THR SER GLY ILE ARG LYS TYR ALA PRO          
SEQRES  12 B  177  THR ARG ARG PHE TYR GLU ARG ALA GLY PHE SER ALA GLU          
SEQRES  13 B  177  ALA VAL LEU LYS ALA PHE TYR ARG ALA GLY ASP ASP LYS          
SEQRES  14 B  177  ILE ILE TYR ARG LEU GLU VAL ALA                              
HET    MSE  A  60       5                                                       
HET    MSE  A  78       8                                                       
HET    MSE  B  60       5                                                       
HET    MSE  B  78       8                                                       
HET    ETX  A 177       6                                                       
HET    ETX  B 177       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ETX 2-ETHOXYETHANOL                                                  
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3  ETX    2(C4 H10 O2)                                                 
FORMUL   5  HOH   *128(H2 O)                                                    
CRYST1   71.750   47.350  108.120  90.00  97.04  90.00 C 1 2 1       8          
ATOM   1205  N   ALA B  18      -8.388 -21.926  55.520  1.00 55.86           N  
ATOM   1206  CA  ALA B  18      -7.301 -22.179  54.542  1.00 54.75           C  
ATOM   1207  C   ALA B  18      -6.731 -20.844  54.030  1.00 54.71           C  
ATOM   1208  O   ALA B  18      -7.430 -20.076  53.347  1.00 55.52           O  
ATOM   1209  CB  ALA B  18      -7.816 -23.021  53.382  1.00 53.97           C  
ATOM   1210  N   VAL B  19      -5.477 -20.559  54.386  1.00 53.62           N  
ATOM   1211  CA  VAL B  19      -4.795 -19.347  53.941  1.00 50.62           C  
ATOM   1212  C   VAL B  19      -4.041 -19.656  52.658  1.00 48.59           C  
ATOM   1213  O   VAL B  19      -3.355 -20.687  52.594  1.00 50.85           O  
ATOM   1214  CB  VAL B  19      -3.769 -18.855  54.967  1.00 50.78           C  
ATOM   1215  CG1 VAL B  19      -3.012 -17.659  54.416  1.00 52.43           C  
ATOM   1216  CG2 VAL B  19      -4.453 -18.501  56.256  1.00 51.59           C  
ATOM   1217  N   ALA B  20      -4.180 -18.806  51.638  1.00 44.81           N  
ATOM   1218  CA  ALA B  20      -3.440 -18.967  50.368  1.00 42.49           C  
ATOM   1219  C   ALA B  20      -2.415 -17.821  50.259  1.00 39.44           C  
ATOM   1220  O   ALA B  20      -2.750 -16.671  50.554  1.00 37.32           O  
ATOM   1221  CB  ALA B  20      -4.374 -18.934  49.176  1.00 41.01           C  
ATOM   1222  N   PHE B  21      -1.193 -18.133  49.833  1.00 38.57           N  
ATOM   1223  CA  PHE B  21      -0.128 -17.132  49.645  1.00 40.41           C  
ATOM   1224  C   PHE B  21      -0.039 -16.790  48.163  1.00 42.72           C  
ATOM   1225  O   PHE B  21       0.023 -17.694  47.332  1.00 47.89           O  
ATOM   1226  CB  PHE B  21       1.200 -17.606  50.215  1.00 38.44           C  
ATOM   1227  CG  PHE B  21       1.147 -17.800  51.684  1.00 33.07           C  
ATOM   1228  CD1 PHE B  21       1.111 -16.694  52.523  1.00 31.49           C  
ATOM   1229  CD2 PHE B  21       1.110 -19.057  52.242  1.00 38.90           C  
ATOM   1230  CE1 PHE B  21       1.051 -16.852  53.882  1.00 36.12           C  
ATOM   1231  CE2 PHE B  21       1.045 -19.216  53.622  1.00 42.35           C  
ATOM   1232  CZ  PHE B  21       1.013 -18.103  54.438  1.00 34.97           C  
ATOM   1233  N   ARG B  22      -0.080 -15.500  47.835  1.00 40.75           N  
ATOM   1234  CA  ARG B  22      -0.039 -15.030  46.444  1.00 40.35           C  
ATOM   1235  C   ARG B  22       1.052 -13.977  46.303  1.00 39.79           C  
ATOM   1236  O   ARG B  22       1.181 -13.121  47.162  1.00 41.20           O  
ATOM   1237  CB  ARG B  22      -1.406 -14.437  46.091  1.00 40.19           C  
ATOM   1238  CG  ARG B  22      -1.490 -13.736  44.729  1.00 44.30           C  
ATOM   1239  CD  ARG B  22      -2.920 -13.451  44.288  1.00 43.04           C  
ATOM   1240  NE  ARG B  22      -3.740 -12.788  45.308  1.00 43.24           N  
ATOM   1241  CZ  ARG B  22      -3.712 -11.488  45.606  1.00 46.73           C  
ATOM   1242  NH1 ARG B  22      -2.867 -10.666  45.012  1.00 48.03           N  
ATOM   1243  NH2 ARG B  22      -4.516 -11.008  46.544  1.00 50.66           N  
ATOM   1244  N   ARG B  23       1.832 -14.065  45.235  1.00 40.12           N  
ATOM   1245  CA  ARG B  23       2.891 -13.105  44.932  1.00 41.21           C  
ATOM   1246  C   ARG B  23       2.513 -12.105  43.856  1.00 42.81           C  
ATOM   1247  O   ARG B  23       3.138 -11.058  43.774  1.00 39.46           O  
ATOM   1248  CB  ARG B  23       4.186 -13.770  44.481  1.00 42.87           C  
ATOM   1249  CG  ARG B  23       5.113 -14.319  45.526  1.00 43.56           C  
ATOM   1250  CD  ARG B  23       4.565 -15.468  46.201  1.00 48.53           C  
ATOM   1251  NE  ARG B  23       5.549 -16.063  47.093  1.00 42.30           N  
ATOM   1252  CZ  ARG B  23       5.263 -17.056  47.923  1.00 45.15           C  
ATOM   1253  NH1 ARG B  23       4.056 -17.643  47.952  1.00 46.44           N  
ATOM   1254  NH2 ARG B  23       6.209 -17.507  48.698  1.00 36.34           N  
ATOM   1255  N   GLN B  24       1.542 -12.436  43.004  1.00 44.61           N  
ATOM   1256  CA  GLN B  24       1.129 -11.550  41.909  1.00 49.20           C  
ATOM   1257  C   GLN B  24       0.361 -10.364  42.455  1.00 45.93           C  
ATOM   1258  O   GLN B  24      -0.532 -10.570  43.235  1.00 43.94           O  
ATOM   1259  CB  GLN B  24       0.231 -12.308  40.907  1.00 48.90           C  
ATOM   1260  CG  GLN B  24      -0.070 -11.520  39.607  1.00 56.48           C  
ATOM   1261  CD  GLN B  24      -0.979 -12.270  38.631  1.00 57.76           C  
ATOM   1262  OE1 GLN B  24      -1.894 -13.008  39.032  1.00 66.80           O  
ATOM   1263  NE2 GLN B  24      -0.760 -12.035  37.340  1.00 72.28           N  
ATOM   1264  N   VAL B  25       0.709  -9.145  42.031  1.00 45.14           N  
ATOM   1265  CA  VAL B  25       0.035  -7.940  42.487  1.00 46.12           C  
ATOM   1266  C   VAL B  25      -1.093  -7.659  41.516  1.00 48.84           C  
ATOM   1267  O   VAL B  25      -0.869  -7.603  40.307  1.00 48.47           O  
ATOM   1268  CB  VAL B  25       0.976  -6.725  42.547  1.00 46.72           C  
ATOM   1269  CG1 VAL B  25       0.227  -5.486  43.002  1.00 42.64           C  
ATOM   1270  CG2 VAL B  25       2.095  -7.004  43.485  1.00 38.81           C  
ATOM   1271  N   LEU B  26      -2.299  -7.514  42.056  1.00 51.08           N  
ATOM   1272  CA  LEU B  26      -3.494  -7.230  41.291  1.00 53.48           C  
ATOM   1273  C   LEU B  26      -3.927  -5.791  41.612  1.00 55.14           C  
ATOM   1274  O   LEU B  26      -3.464  -5.218  42.598  1.00 55.73           O  
ATOM   1275  CB  LEU B  26      -4.601  -8.215  41.680  1.00 53.78           C  
ATOM   1276  CG  LEU B  26      -4.220  -9.700  41.573  1.00 52.43           C  
ATOM   1277  CD1 LEU B  26      -5.350 -10.573  42.054  1.00 54.33           C  
ATOM   1278  CD2 LEU B  26      -3.826 -10.082  40.163  1.00 46.07           C  
ATOM   1279  N   PRO B  27      -4.788  -5.185  40.768  1.00 56.40           N  
ATOM   1280  CA  PRO B  27      -5.286  -3.807  41.030  1.00 56.75           C  
ATOM   1281  C   PRO B  27      -6.028  -3.601  42.377  1.00 56.66           C  
ATOM   1282  O   PRO B  27      -5.950  -2.507  42.965  1.00 57.93           O  
ATOM   1283  CB  PRO B  27      -6.231  -3.559  39.857  1.00 56.57           C  
ATOM   1284  CG  PRO B  27      -5.732  -4.466  38.785  1.00 58.38           C  
ATOM   1285  CD  PRO B  27      -5.316  -5.705  39.493  1.00 56.44           C  
ATOM   1286  N   GLN B  28      -6.719  -4.644  42.853  1.00 55.37           N  
ATOM   1287  CA  GLN B  28      -7.429  -4.619  44.133  1.00 53.97           C  
ATOM   1288  C   GLN B  28      -6.505  -4.492  45.360  1.00 53.95           C  
ATOM   1289  O   GLN B  28      -6.922  -4.000  46.412  1.00 54.01           O  
ATOM   1290  CB  GLN B  28      -8.213  -5.934  44.285  1.00 53.49           C  
ATOM   1291  N   ASP B  29      -5.245  -4.900  45.208  1.00 51.73           N  
ATOM   1292  CA  ASP B  29      -4.276  -4.926  46.310  1.00 49.80           C  
ATOM   1293  C   ASP B  29      -3.845  -3.634  47.020  1.00 48.29           C  
ATOM   1294  O   ASP B  29      -3.664  -3.652  48.252  1.00 44.98           O  
ATOM   1295  CB  ASP B  29      -3.021  -5.696  45.866  1.00 49.04           C  
ATOM   1296  CG  ASP B  29      -3.302  -7.166  45.534  1.00 49.85           C  
ATOM   1297  OD1 ASP B  29      -4.273  -7.775  46.045  1.00 48.25           O  
ATOM   1298  OD2 ASP B  29      -2.509  -7.723  44.752  1.00 43.72           O  
ATOM   1299  N   ALA B  30      -3.653  -2.561  46.254  1.00 48.02           N  
ATOM   1300  CA  ALA B  30      -3.241  -1.254  46.791  1.00 48.45           C  
ATOM   1301  C   ALA B  30      -4.160  -0.785  47.925  1.00 48.52           C  
ATOM   1302  O   ALA B  30      -3.680  -0.401  48.991  1.00 49.17           O  
ATOM   1303  CB  ALA B  30      -3.216  -0.212  45.683  1.00 47.88           C  
ATOM   1304  N   LEU B  31      -5.468  -0.862  47.706  1.00 49.05           N  
ATOM   1305  CA  LEU B  31      -6.430  -0.449  48.719  1.00 48.20           C  
ATOM   1306  C   LEU B  31      -6.579  -1.505  49.836  1.00 47.13           C  
ATOM   1307  O   LEU B  31      -6.757  -1.134  50.996  1.00 46.31           O  
ATOM   1308  CB  LEU B  31      -7.780  -0.125  48.094  1.00 49.87           C  
ATOM   1309  CG  LEU B  31      -8.671   0.727  48.993  1.00 51.42           C  
ATOM   1310  CD1 LEU B  31      -8.013   2.112  49.203  1.00 50.58           C  
ATOM   1311  CD2 LEU B  31     -10.085   0.875  48.391  1.00 50.86           C  
ATOM   1312  N   LEU B  32      -6.503  -2.803  49.489  1.00 46.27           N  
ATOM   1313  CA  LEU B  32      -6.592  -3.904  50.475  1.00 43.79           C  
ATOM   1314  C   LEU B  32      -5.424  -3.813  51.433  1.00 42.09           C  
ATOM   1315  O   LEU B  32      -5.593  -4.050  52.632  1.00 43.97           O  
ATOM   1316  CB  LEU B  32      -6.629  -5.290  49.796  1.00 41.90           C  
ATOM   1317  CG  LEU B  32      -7.875  -5.676  49.006  1.00 44.50           C  
ATOM   1318  CD1 LEU B  32      -7.638  -6.867  48.105  1.00 40.62           C  
ATOM   1319  CD2 LEU B  32      -9.054  -5.915  49.945  1.00 45.07           C  
ATOM   1320  N   VAL B  33      -4.239  -3.511  50.893  1.00 40.71           N  
ATOM   1321  CA  VAL B  33      -3.025  -3.332  51.697  1.00 39.29           C  
ATOM   1322  C   VAL B  33      -3.201  -2.140  52.637  1.00 39.00           C  
ATOM   1323  O   VAL B  33      -2.885  -2.223  53.842  1.00 34.85           O  
ATOM   1324  CB  VAL B  33      -1.784  -3.147  50.817  1.00 39.58           C  
ATOM   1325  CG1 VAL B  33      -0.650  -2.451  51.581  1.00 35.48           C  
ATOM   1326  CG2 VAL B  33      -1.375  -4.510  50.218  1.00 39.28           C  
ATOM   1327  N   ARG B  34      -3.716  -1.047  52.088  1.00 38.38           N  
ATOM   1328  CA  ARG B  34      -3.938   0.147  52.907  1.00 39.19           C  
ATOM   1329  C   ARG B  34      -4.836  -0.202  54.077  1.00 37.40           C  
ATOM   1330  O   ARG B  34      -4.482   0.091  55.206  1.00 40.82           O  
ATOM   1331  CB  ARG B  34      -4.555   1.287  52.126  1.00 37.10           C  
ATOM   1332  CG  ARG B  34      -4.422   2.581  52.914  1.00 46.01           C  
ATOM   1333  CD  ARG B  34      -5.188   3.728  52.367  1.00 41.95           C  
ATOM   1334  NE  ARG B  34      -4.890   4.855  53.249  1.00 48.44           N  
ATOM   1335  CZ  ARG B  34      -3.856   5.691  53.139  1.00 47.89           C  
ATOM   1336  NH1 ARG B  34      -3.049   5.620  52.102  1.00 51.39           N  
ATOM   1337  NH2 ARG B  34      -3.681   6.658  54.065  1.00 49.64           N  
ATOM   1338  N   ARG B  35      -5.957  -0.870  53.824  1.00 38.00           N  
ATOM   1339  CA  ARG B  35      -6.879  -1.267  54.904  1.00 37.48           C  
ATOM   1340  C   ARG B  35      -6.222  -2.222  55.921  1.00 38.90           C  
ATOM   1341  O   ARG B  35      -6.474  -2.091  57.120  1.00 35.69           O  
ATOM   1342  CB  ARG B  35      -8.222  -1.802  54.340  1.00 36.48           C  
ATOM   1343  N   VAL B  36      -5.331  -3.121  55.460  1.00 40.03           N  
ATOM   1344  CA  VAL B  36      -4.623  -4.029  56.365  1.00 38.37           C  
ATOM   1345  C   VAL B  36      -3.762  -3.180  57.269  1.00 37.78           C  
ATOM   1346  O   VAL B  36      -3.818  -3.313  58.490  1.00 40.10           O  
ATOM   1347  CB  VAL B  36      -3.702  -5.091  55.646  1.00 38.55           C  
ATOM   1348  CG1 VAL B  36      -2.786  -5.797  56.658  1.00 39.77           C  
ATOM   1349  CG2 VAL B  36      -4.523  -6.136  54.864  1.00 43.71           C  
ATOM   1350  N   VAL B  37      -2.964  -2.315  56.645  1.00 35.98           N  
ATOM   1351  CA  VAL B  37      -2.057  -1.413  57.349  1.00 36.85           C  
ATOM   1352  C   VAL B  37      -2.764  -0.503  58.364  1.00 37.89           C  
ATOM   1353  O   VAL B  37      -2.264  -0.293  59.476  1.00 39.28           O  
ATOM   1354  CB  VAL B  37      -1.209  -0.621  56.305  1.00 35.61           C  
ATOM   1355  CG1 VAL B  37      -0.745   0.644  56.877  1.00 44.43           C  
ATOM   1356  CG2 VAL B  37      -0.098  -1.532  55.714  1.00 33.48           C  
ATOM   1357  N   GLU B  38      -3.910   0.036  57.962  1.00 39.04           N  
ATOM   1358  CA  GLU B  38      -4.723   0.907  58.829  1.00 38.55           C  
ATOM   1359  C   GLU B  38      -5.332   0.171  59.990  1.00 39.65           C  
ATOM   1360  O   GLU B  38      -5.512   0.770  61.023  1.00 43.10           O  
ATOM   1361  CB  GLU B  38      -5.803   1.606  58.038  1.00 39.47           C  
ATOM   1362  CG  GLU B  38      -5.235   2.678  57.117  1.00 38.14           C  
ATOM   1363  CD  GLU B  38      -6.325   3.398  56.342  1.00 30.58           C  
ATOM   1364  OE1 GLU B  38      -7.449   2.865  56.186  1.00 42.00           O  
ATOM   1365  OE2 GLU B  38      -6.025   4.507  55.870  1.00 36.30           O  
ATOM   1366  N   SER B  39      -5.625  -1.120  59.837  1.00 40.78           N  
ATOM   1367  CA  SER B  39      -6.184  -1.929  60.915  1.00 39.96           C  
ATOM   1368  C   SER B  39      -5.193  -2.251  62.054  1.00 43.43           C  
ATOM   1369  O   SER B  39      -5.614  -2.567  63.160  1.00 46.28           O  
ATOM   1370  CB  SER B  39      -6.719  -3.237  60.360  1.00 40.46           C  
ATOM   1371  OG  SER B  39      -5.684  -4.119  60.005  1.00 36.97           O  
ATOM   1372  N   THR B  40      -3.895  -2.124  61.813  1.00 46.02           N  
ATOM   1373  CA  THR B  40      -2.878  -2.456  62.831  1.00 47.60           C  
ATOM   1374  C   THR B  40      -2.522  -1.387  63.860  1.00 49.29           C  
ATOM   1375  O   THR B  40      -2.054  -1.745  64.932  1.00 50.88           O  
ATOM   1376  CB  THR B  40      -1.551  -2.809  62.174  1.00 47.91           C  
ATOM   1377  OG1 THR B  40      -0.951  -1.620  61.629  1.00 48.48           O  
ATOM   1378  CG2 THR B  40      -1.754  -3.897  61.088  1.00 41.15           C  
ATOM   1379  N   GLY B  41      -2.678  -0.099  63.535  1.00 49.69           N  
ATOM   1380  CA  GLY B  41      -2.310   0.987  64.471  1.00 50.08           C  
ATOM   1381  C   GLY B  41      -0.813   1.349  64.517  1.00 50.47           C  
ATOM   1382  O   GLY B  41      -0.382   2.155  65.335  1.00 51.25           O  
ATOM   1383  N   PHE B  42      -0.015   0.753  63.647  1.00 50.83           N  
ATOM   1384  CA  PHE B  42       1.413   1.026  63.574  1.00 50.02           C  
ATOM   1385  C   PHE B  42       1.738   1.929  62.397  1.00 49.94           C  
ATOM   1386  O   PHE B  42       2.911   2.235  62.156  1.00 52.20           O  
ATOM   1387  CB  PHE B  42       2.208  -0.296  63.496  1.00 50.21           C  
ATOM   1388  CG  PHE B  42       2.370  -0.958  64.820  1.00 50.39           C  
ATOM   1389  CD1 PHE B  42       1.321  -1.631  65.406  1.00 53.87           C  
ATOM   1390  CD2 PHE B  42       3.570  -0.878  65.498  1.00 56.17           C  
ATOM   1391  CE1 PHE B  42       1.457  -2.213  66.664  1.00 53.76           C  
ATOM   1392  CE2 PHE B  42       3.723  -1.463  66.755  1.00 58.41           C  
ATOM   1393  CZ  PHE B  42       2.661  -2.128  67.338  1.00 55.10           C  
ATOM   1394  N   PHE B  43       0.723   2.394  61.686  1.00 45.86           N  
ATOM   1395  CA  PHE B  43       0.961   3.210  60.532  1.00 45.82           C  
ATOM   1396  C   PHE B  43       0.202   4.519  60.624  1.00 44.58           C  
ATOM   1397  O   PHE B  43      -1.017   4.514  60.666  1.00 45.70           O  
ATOM   1398  CB  PHE B  43       0.533   2.484  59.258  1.00 47.12           C  
ATOM   1399  CG  PHE B  43       1.427   1.314  58.853  1.00 47.84           C  
ATOM   1400  CD1 PHE B  43       1.347   0.090  59.521  1.00 54.16           C  
ATOM   1401  CD2 PHE B  43       2.257   1.400  57.706  1.00 52.20           C  
ATOM   1402  CE1 PHE B  43       2.142  -1.014  59.109  1.00 46.85           C  
ATOM   1403  CE2 PHE B  43       3.052   0.281  57.272  1.00 44.07           C  
ATOM   1404  CZ  PHE B  43       2.984  -0.906  57.974  1.00 46.93           C  
ATOM   1405  N   THR B  44       0.936   5.621  60.643  1.00 42.52           N  
ATOM   1406  CA  THR B  44       0.334   6.923  60.630  1.00 42.60           C  
ATOM   1407  C   THR B  44      -0.210   7.035  59.193  1.00 39.93           C  
ATOM   1408  O   THR B  44       0.141   6.228  58.323  1.00 40.17           O  
ATOM   1409  CB  THR B  44       1.380   8.008  60.874  1.00 43.39           C  
ATOM   1410  OG1 THR B  44       2.393   7.900  59.874  1.00 39.82           O  
ATOM   1411  CG2 THR B  44       2.007   7.878  62.265  1.00 40.74           C  
ATOM   1412  N   PRO B  45      -1.105   7.979  58.934  1.00 38.07           N  
ATOM   1413  CA  PRO B  45      -1.576   8.083  57.552  1.00 39.32           C  
ATOM   1414  C   PRO B  45      -0.465   8.171  56.506  1.00 40.78           C  
ATOM   1415  O   PRO B  45      -0.595   7.600  55.433  1.00 40.70           O  
ATOM   1416  CB  PRO B  45      -2.435   9.355  57.572  1.00 38.19           C  
ATOM   1417  CG  PRO B  45      -2.900   9.465  58.986  1.00 37.88           C  
ATOM   1418  CD  PRO B  45      -1.757   8.950  59.825  1.00 34.82           C  
ATOM   1419  N   GLU B  46       0.614   8.872  56.853  1.00 43.50           N  
ATOM   1420  CA  GLU B  46       1.781   9.072  56.001  1.00 47.34           C  
ATOM   1421  C   GLU B  46       2.454   7.708  55.723  1.00 43.29           C  
ATOM   1422  O   GLU B  46       2.850   7.415  54.605  1.00 42.63           O  
ATOM   1423  CB  GLU B  46       2.705  10.112  56.679  1.00 46.56           C  
ATOM   1424  CG  GLU B  46       3.865  10.597  55.835  1.00 60.12           C  
ATOM   1425  CD  GLU B  46       4.686  11.733  56.486  1.00 56.61           C  
ATOM   1426  OE1 GLU B  46       4.287  12.242  57.556  1.00 70.89           O  
ATOM   1427  OE2 GLU B  46       5.735  12.118  55.904  1.00 71.32           O  
ATOM   1428  N   GLU B  47       2.520   6.866  56.741  1.00 42.01           N  
ATOM   1429  CA  GLU B  47       3.068   5.529  56.619  1.00 41.89           C  
ATOM   1430  C   GLU B  47       2.117   4.622  55.826  1.00 40.26           C  
ATOM   1431  O   GLU B  47       2.588   3.795  55.056  1.00 43.99           O  
ATOM   1432  CB  GLU B  47       3.354   4.961  58.006  1.00 43.96           C  
ATOM   1433  CG  GLU B  47       4.458   5.761  58.695  1.00 45.89           C  
ATOM   1434  CD  GLU B  47       4.640   5.450  60.155  1.00 52.25           C  
ATOM   1435  OE1 GLU B  47       3.823   4.726  60.748  1.00 49.67           O  
ATOM   1436  OE2 GLU B  47       5.619   5.975  60.730  1.00 65.19           O  
ATOM   1437  N   ALA B  48       0.801   4.736  56.023  1.00 36.70           N  
ATOM   1438  CA  ALA B  48      -0.165   3.955  55.257  1.00 33.32           C  
ATOM   1439  C   ALA B  48      -0.077   4.379  53.765  1.00 36.19           C  
ATOM   1440  O   ALA B  48      -0.282   3.558  52.853  1.00 35.53           O  
ATOM   1441  CB  ALA B  48      -1.653   4.096  55.832  1.00 29.97           C  
ATOM   1442  N   ASP B  49       0.230   5.655  53.508  1.00 39.45           N  
ATOM   1443  CA  ASP B  49       0.402   6.147  52.128  1.00 41.39           C  
ATOM   1444  C   ASP B  49       1.578   5.472  51.474  1.00 40.17           C  
ATOM   1445  O   ASP B  49       1.515   5.128  50.292  1.00 40.68           O  
ATOM   1446  CB  ASP B  49       0.696   7.655  52.066  1.00 43.37           C  
ATOM   1447  CG  ASP B  49      -0.453   8.531  52.511  1.00 46.53           C  
ATOM   1448  OD1 ASP B  49      -1.614   8.167  52.303  1.00 43.94           O  
ATOM   1449  OD2 ASP B  49      -0.168   9.652  52.999  1.00 47.30           O  
ATOM   1450  N   VAL B  50       2.664   5.338  52.229  1.00 39.86           N  
ATOM   1451  CA  VAL B  50       3.859   4.665  51.732  1.00 42.86           C  
ATOM   1452  C   VAL B  50       3.469   3.205  51.403  1.00 44.87           C  
ATOM   1453  O   VAL B  50       3.656   2.762  50.267  1.00 45.97           O  
ATOM   1454  CB  VAL B  50       5.064   4.731  52.741  1.00 42.47           C  
ATOM   1455  CG1 VAL B  50       6.252   3.902  52.229  1.00 41.82           C  
ATOM   1456  CG2 VAL B  50       5.485   6.187  52.995  1.00 44.03           C  
ATOM   1457  N   ALA B  51       2.852   2.516  52.371  1.00 43.82           N  
ATOM   1458  CA  ALA B  51       2.413   1.123  52.202  1.00 43.62           C  
ATOM   1459  C   ALA B  51       1.646   0.916  50.899  1.00 43.36           C  
ATOM   1460  O   ALA B  51       1.959   0.003  50.135  1.00 44.95           O  
ATOM   1461  CB  ALA B  51       1.602   0.663  53.411  1.00 39.10           C  
ATOM   1462  N   GLN B  52       0.707   1.813  50.609  1.00 44.27           N  
ATOM   1463  CA  GLN B  52      -0.088   1.741  49.387  1.00 44.94           C  
ATOM   1464  C   GLN B  52       0.701   2.121  48.132  1.00 45.75           C  
ATOM   1465  O   GLN B  52       0.504   1.500  47.080  1.00 44.43           O  
ATOM   1466  CB  GLN B  52      -1.316   2.642  49.505  1.00 45.65           C  
ATOM   1467  CG  GLN B  52      -2.247   2.590  48.277  1.00 47.13           C  
ATOM   1468  CD  GLN B  52      -3.469   3.466  48.417  1.00 47.85           C  
ATOM   1469  OE1 GLN B  52      -3.660   4.124  49.428  1.00 43.32           O  
ATOM   1470  NE2 GLN B  52      -4.299   3.485  47.385  1.00 52.07           N  
ATOM   1471  N   GLU B  53       1.578   3.125  48.240  1.00 46.25           N  
ATOM   1472  CA  GLU B  53       2.378   3.594  47.093  1.00 47.57           C  
ATOM   1473  C   GLU B  53       3.275   2.494  46.523  1.00 48.42           C  
ATOM   1474  O   GLU B  53       3.393   2.374  45.295  1.00 51.13           O  
ATOM   1475  CB  GLU B  53       3.201   4.839  47.458  1.00 47.52           C  
ATOM   1476  N   LEU B  54       3.883   1.690  47.403  1.00 46.84           N  
ATOM   1477  CA  LEU B  54       4.735   0.562  46.987  1.00 44.32           C  
ATOM   1478  C   LEU B  54       3.970  -0.449  46.123  1.00 44.33           C  
ATOM   1479  O   LEU B  54       4.541  -1.024  45.211  1.00 44.09           O  
ATOM   1480  CB  LEU B  54       5.305  -0.169  48.203  1.00 42.24           C  
ATOM   1481  CG  LEU B  54       6.245   0.570  49.163  1.00 45.10           C  
ATOM   1482  CD1 LEU B  54       6.657  -0.323  50.328  1.00 45.92           C  
ATOM   1483  CD2 LEU B  54       7.476   1.097  48.453  1.00 47.42           C  
ATOM   1484  N   VAL B  55       2.693  -0.679  46.441  1.00 43.87           N  
ATOM   1485  CA  VAL B  55       1.861  -1.607  45.689  1.00 44.90           C  
ATOM   1486  C   VAL B  55       1.530  -0.994  44.324  1.00 47.07           C  
ATOM   1487  O   VAL B  55       1.502  -1.701  43.309  1.00 45.96           O  
ATOM   1488  CB  VAL B  55       0.577  -1.984  46.448  1.00 43.67           C  
ATOM   1489  CG1 VAL B  55      -0.289  -2.881  45.594  1.00 45.79           C  
ATOM   1490  CG2 VAL B  55       0.910  -2.673  47.779  1.00 41.15           C  
ATOM   1491  N   ASP B  56       1.271   0.311  44.311  1.00 50.41           N  
ATOM   1492  CA  ASP B  56       0.979   1.034  43.073  1.00 53.67           C  
ATOM   1493  C   ASP B  56       2.199   1.083  42.147  1.00 54.74           C  
ATOM   1494  O   ASP B  56       2.044   0.871  40.946  1.00 56.00           O  
ATOM   1495  CB  ASP B  56       0.446   2.444  43.362  1.00 55.06           C  
ATOM   1496  CG  ASP B  56      -0.939   2.436  44.001  1.00 57.02           C  
ATOM   1497  OD1 ASP B  56      -1.763   1.539  43.694  1.00 62.32           O  
ATOM   1498  OD2 ASP B  56      -1.221   3.373  44.778  1.00 62.04           O  
ATOM   1499  N   GLU B  57       3.397   1.344  42.685  1.00 55.93           N  
ATOM   1500  CA  GLU B  57       4.624   1.362  41.860  1.00 56.46           C  
ATOM   1501  C   GLU B  57       4.875  -0.028  41.226  1.00 57.62           C  
ATOM   1502  O   GLU B  57       5.385  -0.098  40.103  1.00 57.53           O  
ATOM   1503  CB  GLU B  57       5.870   1.882  42.622  1.00 56.38           C  
ATOM   1504  CG  GLU B  57       5.895   3.382  42.913  1.00 52.97           C  
ATOM   1505  N   HIS B  58       4.526  -1.113  41.932  1.00 57.67           N  
ATOM   1506  CA  HIS B  58       4.666  -2.471  41.385  1.00 58.29           C  
ATOM   1507  C   HIS B  58       3.648  -2.632  40.251  1.00 60.43           C  
ATOM   1508  O   HIS B  58       3.921  -3.344  39.285  1.00 60.58           O  
ATOM   1509  CB  HIS B  58       4.446  -3.548  42.436  1.00 56.98           C  
ATOM   1510  CG  HIS B  58       4.752  -4.931  41.951  1.00 55.31           C  
ATOM   1511  ND1 HIS B  58       5.890  -5.613  42.323  1.00 52.82           N  
ATOM   1512  CD2 HIS B  58       4.082  -5.754  41.109  1.00 54.78           C  
ATOM   1513  CE1 HIS B  58       5.901  -6.798  41.744  1.00 54.32           C  
ATOM   1514  NE2 HIS B  58       4.816  -6.909  41.001  1.00 50.05           N  
ATOM   1515  N   LEU B  59       2.468  -2.020  40.394  1.00 60.86           N  
ATOM   1516  CA  LEU B  59       1.459  -2.043  39.328  1.00 62.68           C  
ATOM   1517  C   LEU B  59       1.847  -1.133  38.141  1.00 63.05           C  
ATOM   1518  O   LEU B  59       1.561  -1.496  37.004  1.00 62.59           O  
ATOM   1519  CB  LEU B  59       0.054  -1.690  39.850  1.00 62.60           C  
ATOM   1520  CG  LEU B  59      -0.685  -2.771  40.638  1.00 61.66           C  
ATOM   1521  CD1 LEU B  59      -1.899  -2.197  41.349  1.00 63.51           C  
ATOM   1522  CD2 LEU B  59      -1.077  -3.906  39.706  1.00 56.18           C  
HETATM 1523  N   MSE B  60       2.489   0.020  38.402  1.00 64.09           N  
HETATM 1524  CA  MSE B  60       2.926   0.979  37.346  1.00 63.96           C  
HETATM 1525  C   MSE B  60       4.315   0.694  36.715  1.00 65.13           C  
HETATM 1526  O   MSE B  60       4.770   1.471  35.863  1.00 65.67           O  
HETATM 1527  CB  MSE B  60       2.909   2.424  37.880  1.00 63.05           C  
ATOM   1528  N   HIS B  61       4.994  -0.378  37.147  1.00 65.55           N  
ATOM   1529  CA  HIS B  61       6.315  -0.771  36.624  1.00 65.37           C  
ATOM   1530  C   HIS B  61       6.422  -2.296  36.513  1.00 66.32           C  
ATOM   1531  O   HIS B  61       6.581  -2.824  35.409  1.00 67.55           O  
ATOM   1532  CB  HIS B  61       7.474  -0.219  37.480  1.00 65.36           C  
ATOM   1533  CG  HIS B  61       7.470   1.277  37.626  1.00 70.07           C  
ATOM   1534  ND1 HIS B  61       7.742   2.129  36.575  1.00 71.84           N  
ATOM   1535  CD2 HIS B  61       7.265   2.071  38.707  1.00 75.49           C  
ATOM   1536  CE1 HIS B  61       7.675   3.381  36.994  1.00 71.09           C  
ATOM   1537  NE2 HIS B  61       7.386   3.373  38.283  1.00 74.35           N  
ATOM   1538  N   GLY B  62       6.306  -2.993  37.645  1.00 66.54           N  
ATOM   1539  CA  GLY B  62       6.406  -4.468  37.718  1.00 65.04           C  
ATOM   1540  C   GLY B  62       7.525  -4.747  38.690  1.00 64.34           C  
ATOM   1541  O   GLY B  62       7.762  -3.936  39.585  1.00 62.30           O  
ATOM   1542  N   ALA B  63       8.235  -5.863  38.503  1.00 64.83           N  
ATOM   1543  CA  ALA B  63       9.381  -6.214  39.363  1.00 63.57           C  
ATOM   1544  C   ALA B  63      10.435  -5.086  39.408  1.00 62.20           C  
ATOM   1545  O   ALA B  63      11.102  -4.912  40.424  1.00 62.87           O  
ATOM   1546  N   ALA B  64      10.546  -4.318  38.311  1.00 61.28           N  
ATOM   1547  CA  ALA B  64      11.464  -3.188  38.163  1.00 58.66           C  
ATOM   1548  C   ALA B  64      11.551  -2.206  39.325  1.00 57.38           C  
ATOM   1549  O   ALA B  64      12.616  -1.647  39.575  1.00 56.97           O  
ATOM   1550  N   CYS B  65      10.448  -1.993  40.040  1.00 56.47           N  
ATOM   1551  CA  CYS B  65      10.454  -1.085  41.192  1.00 55.77           C  
ATOM   1552  C   CYS B  65      11.280  -1.640  42.405  1.00 54.37           C  
ATOM   1553  O   CYS B  65      11.637  -0.887  43.314  1.00 54.63           O  
ATOM   1554  CB  CYS B  65       9.023  -0.794  41.637  1.00 56.39           C  
ATOM   1555  SG  CYS B  65       8.196  -2.282  42.346  1.00 57.94           S  
ATOM   1556  N   GLY B  66      11.570  -2.938  42.427  1.00 53.24           N  
ATOM   1557  CA  GLY B  66      12.336  -3.542  43.519  1.00 53.07           C  
ATOM   1558  C   GLY B  66      11.562  -3.825  44.802  1.00 51.86           C  
ATOM   1559  O   GLY B  66      12.174  -4.001  45.859  1.00 53.25           O  
ATOM   1560  N   TYR B  67      10.234  -3.856  44.705  1.00 48.61           N  
ATOM   1561  CA  TYR B  67       9.355  -4.126  45.832  1.00 46.91           C  
ATOM   1562  C   TYR B  67       8.578  -5.397  45.481  1.00 44.30           C  
ATOM   1563  O   TYR B  67       7.881  -5.448  44.480  1.00 45.96           O  
ATOM   1564  CB  TYR B  67       8.403  -2.959  46.127  1.00 48.31           C  
ATOM   1565  CG  TYR B  67       9.148  -1.702  46.461  1.00 47.68           C  
ATOM   1566  CD1 TYR B  67       9.933  -1.664  47.599  1.00 58.17           C  
ATOM   1567  CD2 TYR B  67       9.048  -0.555  45.682  1.00 51.89           C  
ATOM   1568  CE1 TYR B  67      10.660  -0.553  47.948  1.00 54.77           C  
ATOM   1569  CE2 TYR B  67       9.786   0.593  46.018  1.00 53.42           C  
ATOM   1570  CZ  TYR B  67      10.598   0.569  47.165  1.00 56.71           C  
ATOM   1571  OH  TYR B  67      11.344   1.652  47.574  1.00 60.82           O  
ATOM   1572  N   HIS B  68       8.723  -6.403  46.334  1.00 40.89           N  
ATOM   1573  CA  HIS B  68       8.087  -7.692  46.212  1.00 39.18           C  
ATOM   1574  C   HIS B  68       7.114  -7.844  47.359  1.00 35.42           C  
ATOM   1575  O   HIS B  68       7.292  -7.241  48.425  1.00 35.93           O  
ATOM   1576  CB  HIS B  68       9.154  -8.769  46.255  1.00 35.05           C  
ATOM   1577  CG  HIS B  68      10.128  -8.661  45.137  1.00 42.15           C  
ATOM   1578  ND1 HIS B  68      10.048  -9.452  44.014  1.00 45.83           N  
ATOM   1579  CD2 HIS B  68      11.148  -7.798  44.921  1.00 40.95           C  
ATOM   1580  CE1 HIS B  68      11.025  -9.127  43.184  1.00 49.74           C  
ATOM   1581  NE2 HIS B  68      11.704  -8.123  43.707  1.00 39.92           N  
ATOM   1582  N   PHE B  69       6.120  -8.695  47.135  1.00 35.70           N  
ATOM   1583  CA  PHE B  69       5.027  -8.930  48.064  1.00 36.93           C  
ATOM   1584  C   PHE B  69       4.622 -10.386  48.196  1.00 37.62           C  
ATOM   1585  O   PHE B  69       4.741 -11.138  47.234  1.00 37.57           O  
ATOM   1586  CB  PHE B  69       3.770  -8.212  47.512  1.00 37.21           C  
ATOM   1587  CG  PHE B  69       3.916  -6.730  47.398  1.00 35.80           C  
ATOM   1588  CD1 PHE B  69       4.410  -6.150  46.245  1.00 41.74           C  
ATOM   1589  CD2 PHE B  69       3.617  -5.925  48.466  1.00 37.36           C  
ATOM   1590  CE1 PHE B  69       4.589  -4.773  46.150  1.00 38.75           C  
ATOM   1591  CE2 PHE B  69       3.802  -4.560  48.377  1.00 42.37           C  
ATOM   1592  CZ  PHE B  69       4.291  -3.989  47.213  1.00 39.61           C  
ATOM   1593  N   VAL B  70       4.170 -10.764  49.401  1.00 36.04           N  
ATOM   1594  CA  VAL B  70       3.566 -12.109  49.659  1.00 34.06           C  
ATOM   1595  C   VAL B  70       2.264 -11.733  50.380  1.00 33.21           C  
ATOM   1596  O   VAL B  70       2.311 -11.150  51.465  1.00 31.58           O  
ATOM   1597  CB  VAL B  70       4.372 -13.073  50.573  1.00 32.59           C  
ATOM   1598  CG1 VAL B  70       3.561 -14.375  50.750  1.00 30.12           C  
ATOM   1599  CG2 VAL B  70       5.789 -13.359  50.030  1.00 28.52           C  
ATOM   1600  N   PHE B  71       1.120 -11.967  49.739  1.00 35.72           N  
ATOM   1601  CA  PHE B  71      -0.189 -11.660  50.309  1.00 37.36           C  
ATOM   1602  C   PHE B  71      -0.834 -12.938  50.850  1.00 39.15           C  
ATOM   1603  O   PHE B  71      -0.891 -13.916  50.130  1.00 39.83           O  
ATOM   1604  CB  PHE B  71      -1.123 -11.086  49.228  1.00 38.10           C  
ATOM   1605  CG  PHE B  71      -0.572  -9.873  48.510  1.00 34.64           C  
ATOM   1606  CD1 PHE B  71      -0.543  -8.648  49.136  1.00 38.71           C  
ATOM   1607  CD2 PHE B  71      -0.106  -9.963  47.204  1.00 38.55           C  
ATOM   1608  CE1 PHE B  71      -0.049  -7.537  48.491  1.00 42.03           C  
ATOM   1609  CE2 PHE B  71       0.370  -8.855  46.544  1.00 42.70           C  
ATOM   1610  CZ  PHE B  71       0.399  -7.630  47.195  1.00 37.20           C  
ATOM   1611  N   ALA B  72      -1.261 -12.948  52.118  1.00 40.11           N  
ATOM   1612  CA  ALA B  72      -1.952 -14.094  52.727  1.00 37.88           C  
ATOM   1613  C   ALA B  72      -3.458 -13.800  52.558  1.00 39.24           C  
ATOM   1614  O   ALA B  72      -3.947 -12.767  53.055  1.00 37.20           O  
ATOM   1615  CB  ALA B  72      -1.580 -14.220  54.209  1.00 34.29           C  
ATOM   1616  N   THR B  73      -4.182 -14.639  51.804  1.00 40.93           N  
ATOM   1617  CA  THR B  73      -5.639 -14.439  51.604  1.00 43.91           C  
ATOM   1618  C   THR B  73      -6.499 -15.620  52.123  1.00 44.36           C  
ATOM   1619  O   THR B  73      -6.036 -16.752  52.173  1.00 40.44           O  
ATOM   1620  CB  THR B  73      -6.006 -14.197  50.124  1.00 43.87           C  
ATOM   1621  OG1 THR B  73      -5.566 -15.317  49.346  1.00 49.28           O  
ATOM   1622  CG2 THR B  73      -5.377 -12.937  49.591  1.00 44.42           C  
ATOM   1623  N   GLU B  74      -7.729 -15.311  52.543  1.00 50.06           N  
ATOM   1624  CA  GLU B  74      -8.732 -16.301  53.021  1.00 55.03           C  
ATOM   1625  C   GLU B  74      -9.994 -15.832  52.306  1.00 55.57           C  
ATOM   1626  O   GLU B  74     -10.466 -14.715  52.575  1.00 54.26           O  
ATOM   1627  CB  GLU B  74      -8.991 -16.284  54.537  1.00 55.54           C  
ATOM   1628  CG  GLU B  74      -7.767 -16.478  55.454  1.00 63.24           C  
ATOM   1629  CD  GLU B  74      -8.152 -16.548  56.955  1.00 61.59           C  
ATOM   1630  OE1 GLU B  74      -9.224 -17.117  57.257  1.00 72.90           O  
ATOM   1631  OE2 GLU B  74      -7.367 -16.087  57.827  1.00 68.05           O  
ATOM   1632  N   ASP B  75     -10.500 -16.663  51.388  1.00 57.70           N  
ATOM   1633  CA  ASP B  75     -11.682 -16.351  50.566  1.00 59.34           C  
ATOM   1634  C   ASP B  75     -11.205 -15.161  49.726  1.00 58.65           C  
ATOM   1635  O   ASP B  75     -10.066 -15.174  49.255  1.00 60.41           O  
ATOM   1636  CB  ASP B  75     -12.938 -16.069  51.429  1.00 58.35           C  
ATOM   1637  N   ASP B  76     -12.034 -14.140  49.543  1.00 58.42           N  
ATOM   1638  CA  ASP B  76     -11.601 -12.970  48.818  1.00 56.52           C  
ATOM   1639  C   ASP B  76     -11.026 -11.911  49.749  1.00 55.37           C  
ATOM   1640  O   ASP B  76     -10.865 -10.782  49.290  1.00 59.36           O  
ATOM   1641  N   ASP B  77     -10.721 -12.237  51.022  1.00 50.83           N  
ATOM   1642  CA  ASP B  77     -10.193 -11.261  51.991  1.00 48.54           C  
ATOM   1643  C   ASP B  77      -8.689 -11.392  52.187  1.00 46.95           C  
ATOM   1644  O   ASP B  77      -8.147 -12.499  52.150  1.00 47.25           O  
ATOM   1645  CB  ASP B  77     -10.856 -11.446  53.354  1.00 47.37           C  
HETATM 1646  N   MSE B  78      -8.022 -10.262  52.399  1.00 44.64           N  
HETATM 1647  CA  MSE B  78      -6.581 -10.264  52.666  1.00 42.87           C  
HETATM 1648  C   MSE B  78      -6.350 -10.311  54.192  1.00 41.39           C  
HETATM 1649  O   MSE B  78      -6.612  -9.341  54.904  1.00 44.34           O  
HETATM 1650  CB  MSE B  78      -5.896  -9.045  52.044  1.00 42.38           C  
HETATM 1651  CG  MSE B  78      -4.362  -9.077  52.220  1.00 43.18           C  
HETATM 1652 SE   MSE B  78      -3.528  -7.561  51.419  0.75 44.99          SE  
HETATM 1653  CE  MSE B  78      -3.953  -8.070  49.552  1.00 34.93           C  
ATOM   1654  N   ALA B  79      -5.863 -11.440  54.691  1.00 39.67           N  
ATOM   1655  CA  ALA B  79      -5.582 -11.634  56.124  1.00 39.96           C  
ATOM   1656  C   ALA B  79      -4.331 -10.849  56.587  1.00 38.82           C  
ATOM   1657  O   ALA B  79      -4.226 -10.424  57.742  1.00 39.87           O  
ATOM   1658  CB  ALA B  79      -5.418 -13.112  56.402  1.00 39.85           C  
ATOM   1659  N   GLY B  80      -3.400 -10.652  55.660  1.00 40.06           N  
ATOM   1660  CA  GLY B  80      -2.171  -9.931  55.922  1.00 38.12           C  
ATOM   1661  C   GLY B  80      -1.206 -10.019  54.749  1.00 35.93           C  
ATOM   1662  O   GLY B  80      -1.519 -10.572  53.696  1.00 35.25           O  
ATOM   1663  N   TYR B  81      -0.033  -9.427  54.907  1.00 34.67           N  
ATOM   1664  CA  TYR B  81       0.944  -9.461  53.826  1.00 34.12           C  
ATOM   1665  C   TYR B  81       2.315  -9.043  54.320  1.00 30.38           C  
ATOM   1666  O   TYR B  81       2.455  -8.502  55.430  1.00 29.60           O  
ATOM   1667  CB  TYR B  81       0.525  -8.550  52.647  1.00 34.30           C  
ATOM   1668  CG  TYR B  81       0.875  -7.100  52.797  1.00 35.29           C  
ATOM   1669  CD1 TYR B  81       0.290  -6.313  53.774  1.00 34.52           C  
ATOM   1670  CD2 TYR B  81       1.754  -6.495  51.915  1.00 39.10           C  
ATOM   1671  CE1 TYR B  81       0.635  -4.984  53.925  1.00 41.41           C  
ATOM   1672  CE2 TYR B  81       2.101  -5.172  52.052  1.00 38.75           C  
ATOM   1673  CZ  TYR B  81       1.546  -4.424  53.054  1.00 42.29           C  
ATOM   1674  OH  TYR B  81       1.886  -3.099  53.154  1.00 41.55           O  
ATOM   1675  N   ALA B  82       3.312  -9.311  53.481  1.00 30.52           N  
ATOM   1676  CA  ALA B  82       4.710  -8.936  53.740  1.00 29.68           C  
ATOM   1677  C   ALA B  82       5.171  -8.158  52.492  1.00 31.09           C  
ATOM   1678  O   ALA B  82       4.736  -8.463  51.377  1.00 31.02           O  
ATOM   1679  CB  ALA B  82       5.544 -10.114  53.927  1.00 27.40           C  
ATOM   1680  N   CYS B  83       6.004  -7.151  52.700  1.00 30.25           N  
ATOM   1681  CA  CYS B  83       6.564  -6.291  51.658  1.00 31.12           C  
ATOM   1682  C   CYS B  83       8.094  -6.383  51.857  1.00 28.52           C  
ATOM   1683  O   CYS B  83       8.627  -6.255  52.985  1.00 29.75           O  
ATOM   1684  CB  CYS B  83       6.089  -4.836  51.820  1.00 33.57           C  
ATOM   1685  SG  CYS B  83       6.794  -3.812  50.500  1.00 50.39           S  
ATOM   1686  N   TYR B  84       8.822  -6.645  50.789  1.00 27.85           N  
ATOM   1687  CA  TYR B  84      10.274  -6.784  50.900  1.00 31.49           C  
ATOM   1688  C   TYR B  84      10.956  -6.530  49.560  1.00 33.78           C  
ATOM   1689  O   TYR B  84      10.307  -6.378  48.557  1.00 34.39           O  
ATOM   1690  CB  TYR B  84      10.621  -8.205  51.428  1.00 32.88           C  
ATOM   1691  CG  TYR B  84      10.443  -9.291  50.421  1.00 27.41           C  
ATOM   1692  CD1 TYR B  84       9.214  -9.852  50.163  1.00 27.71           C  
ATOM   1693  CD2 TYR B  84      11.536  -9.725  49.664  1.00 34.86           C  
ATOM   1694  CE1 TYR B  84       9.091 -10.820  49.197  1.00 33.40           C  
ATOM   1695  CE2 TYR B  84      11.426 -10.673  48.742  1.00 35.45           C  
ATOM   1696  CZ  TYR B  84      10.215 -11.221  48.493  1.00 38.11           C  
ATOM   1697  OH  TYR B  84      10.157 -12.164  47.519  1.00 41.57           O  
ATOM   1698  N   GLY B  85      12.289  -6.502  49.546  1.00 34.66           N  
ATOM   1699  CA  GLY B  85      12.969  -6.271  48.280  1.00 34.34           C  
ATOM   1700  C   GLY B  85      14.466  -6.312  48.360  1.00 31.96           C  
ATOM   1701  O   GLY B  85      15.031  -6.268  49.443  1.00 31.34           O  
ATOM   1702  N   PRO B  86      15.135  -6.437  47.194  1.00 32.03           N  
ATOM   1703  CA  PRO B  86      16.598  -6.444  47.302  1.00 27.91           C  
ATOM   1704  C   PRO B  86      17.165  -5.090  47.714  1.00 29.30           C  
ATOM   1705  O   PRO B  86      16.664  -4.030  47.322  1.00 32.29           O  
ATOM   1706  CB  PRO B  86      17.052  -6.784  45.897  1.00 30.38           C  
ATOM   1707  CG  PRO B  86      15.944  -6.215  45.003  1.00 27.61           C  
ATOM   1708  CD  PRO B  86      14.698  -6.575  45.800  1.00 33.90           C  
ATOM   1709  N   THR B  87      18.199  -5.113  48.539  1.00 27.90           N  
ATOM   1710  CA  THR B  87      18.800  -3.871  48.968  1.00 29.77           C  
ATOM   1711  C   THR B  87      19.646  -3.274  47.817  1.00 32.88           C  
ATOM   1712  O   THR B  87      20.472  -3.987  47.235  1.00 36.98           O  
ATOM   1713  CB  THR B  87      19.720  -4.112  50.145  1.00 27.83           C  
ATOM   1714  OG1 THR B  87      18.974  -4.826  51.150  1.00 28.07           O  
ATOM   1715  CG2 THR B  87      20.191  -2.803  50.689  1.00 27.74           C  
ATOM   1716  N   PRO B  88      19.407  -2.002  47.454  1.00 34.18           N  
ATOM   1717  CA  PRO B  88      20.195  -1.385  46.406  1.00 34.13           C  
ATOM   1718  C   PRO B  88      21.685  -1.438  46.676  1.00 31.56           C  
ATOM   1719  O   PRO B  88      22.101  -1.397  47.833  1.00 31.76           O  
ATOM   1720  CB  PRO B  88      19.750   0.091  46.450  1.00 35.97           C  
ATOM   1721  CG  PRO B  88      18.406   0.091  47.033  1.00 38.11           C  
ATOM   1722  CD  PRO B  88      18.326  -1.102  47.929  1.00 37.14           C  
ATOM   1723  N   ALA B  89      22.460  -1.593  45.612  1.00 34.34           N  
ATOM   1724  CA  ALA B  89      23.913  -1.610  45.653  1.00 31.95           C  
ATOM   1725  C   ALA B  89      24.523  -2.760  46.446  1.00 34.74           C  
ATOM   1726  O   ALA B  89      25.578  -2.601  47.029  1.00 30.95           O  
ATOM   1727  CB  ALA B  89      24.415  -0.233  46.196  1.00 33.93           C  
ATOM   1728  N   THR B  90      23.870  -3.913  46.467  1.00 33.69           N  
ATOM   1729  CA  THR B  90      24.376  -5.061  47.219  1.00 30.98           C  
ATOM   1730  C   THR B  90      24.141  -6.312  46.386  1.00 32.58           C  
ATOM   1731  O   THR B  90      23.388  -6.276  45.443  1.00 34.10           O  
ATOM   1732  CB  THR B  90      23.589  -5.274  48.538  1.00 25.64           C  
ATOM   1733  OG1 THR B  90      22.325  -5.898  48.278  1.00 32.22           O  
ATOM   1734  CG2 THR B  90      23.432  -3.971  49.323  1.00 21.46           C  
ATOM   1735  N   GLU B  91      24.829  -7.396  46.758  0.50 34.34           N  
ATOM   1737  CA  GLU B  91      24.722  -8.726  46.123  0.50 33.11           C  
ATOM   1739  C   GLU B  91      24.143  -9.649  47.164  0.50 31.87           C  
ATOM   1741  O   GLU B  91      24.780  -9.867  48.159  0.50 31.55           O  
ATOM   1743  CB  GLU B  91      26.123  -9.240  45.662  0.50 34.02           C  
ATOM   1745  CG  GLU B  91      26.290 -10.774  45.277  0.50 36.01           C  
ATOM   1747  CD  GLU B  91      26.674 -11.746  46.456  0.50 46.17           C  
ATOM   1749  OE1 GLU B  91      27.854 -11.740  46.962  0.50 31.40           O  
ATOM   1751  OE2 GLU B  91      25.811 -12.589  46.812  0.50 40.11           O  
ATOM   1753  N   GLY B  92      22.921 -10.136  46.980  1.00 30.25           N  
ATOM   1754  CA  GLY B  92      22.343 -11.083  47.933  1.00 32.17           C  
ATOM   1755  C   GLY B  92      21.827 -10.589  49.271  1.00 32.19           C  
ATOM   1756  O   GLY B  92      21.605 -11.411  50.172  1.00 29.64           O  
ATOM   1757  N   THR B  93      21.655  -9.276  49.427  1.00 29.64           N  
ATOM   1758  CA  THR B  93      21.108  -8.706  50.660  1.00 29.03           C  
ATOM   1759  C   THR B  93      19.723  -8.163  50.328  1.00 26.48           C  
ATOM   1760  O   THR B  93      19.554  -7.563  49.280  1.00 26.32           O  
ATOM   1761  CB  THR B  93      21.996  -7.635  51.253  1.00 33.06           C  
ATOM   1762  OG1 THR B  93      23.239  -8.238  51.611  1.00 25.39           O  
ATOM   1763  CG2 THR B  93      21.416  -7.070  52.549  1.00 33.85           C  
ATOM   1764  N   TYR B  94      18.781  -8.405  51.224  1.00 28.55           N  
ATOM   1765  CA  TYR B  94      17.385  -8.011  51.082  1.00 25.21           C  
ATOM   1766  C   TYR B  94      16.890  -7.323  52.356  1.00 24.22           C  
ATOM   1767  O   TYR B  94      17.362  -7.603  53.425  1.00 27.78           O  
ATOM   1768  CB  TYR B  94      16.517  -9.275  50.842  1.00 28.13           C  
ATOM   1769  CG  TYR B  94      16.726  -9.878  49.476  1.00 26.11           C  
ATOM   1770  CD1 TYR B  94      17.865 -10.630  49.186  1.00 29.52           C  
ATOM   1771  CD2 TYR B  94      15.808  -9.676  48.471  1.00 30.19           C  
ATOM   1772  CE1 TYR B  94      18.088 -11.127  47.900  1.00 31.27           C  
ATOM   1773  CE2 TYR B  94      16.016 -10.155  47.209  1.00 34.26           C  
ATOM   1774  CZ  TYR B  94      17.146 -10.891  46.928  1.00 37.97           C  
ATOM   1775  OH  TYR B  94      17.332 -11.382  45.664  1.00 40.70           O  
ATOM   1776  N   ASP B  95      15.920  -6.455  52.182  1.00 29.71           N  
ATOM   1777  CA  ASP B  95      15.262  -5.801  53.284  1.00 28.77           C  
ATOM   1778  C   ASP B  95      13.807  -6.231  53.400  1.00 30.41           C  
ATOM   1779  O   ASP B  95      13.104  -6.258  52.406  1.00 25.59           O  
ATOM   1780  CB  ASP B  95      15.267  -4.306  53.125  1.00 28.53           C  
ATOM   1781  CG  ASP B  95      16.627  -3.706  53.410  1.00 30.14           C  
ATOM   1782  OD1 ASP B  95      17.103  -3.773  54.558  1.00 52.36           O  
ATOM   1783  OD2 ASP B  95      17.143  -3.093  52.494  1.00 39.87           O  
ATOM   1784  N   LEU B  96      13.398  -6.618  54.607  1.00 25.95           N  
ATOM   1785  CA  LEU B  96      11.989  -6.900  54.894  1.00 27.74           C  
ATOM   1786  C   LEU B  96      11.458  -5.533  55.337  1.00 29.65           C  
ATOM   1787  O   LEU B  96      11.882  -5.039  56.361  1.00 29.18           O  
ATOM   1788  CB  LEU B  96      11.826  -7.898  56.072  1.00 27.21           C  
ATOM   1789  CG  LEU B  96      10.359  -8.215  56.487  1.00 24.72           C  
ATOM   1790  CD1 LEU B  96       9.506  -8.876  55.336  1.00 25.30           C  
ATOM   1791  CD2 LEU B  96      10.410  -9.125  57.732  1.00 31.99           C  
ATOM   1792  N   TYR B  97      10.570  -4.918  54.563  1.00 27.02           N  
ATOM   1793  CA  TYR B  97      10.004  -3.588  54.872  1.00 31.50           C  
ATOM   1794  C   TYR B  97       9.008  -3.733  56.034  1.00 36.70           C  
ATOM   1795  O   TYR B  97       9.170  -3.054  57.052  1.00 34.70           O  
ATOM   1796  CB  TYR B  97       9.530  -2.887  53.565  1.00 33.73           C  
ATOM   1797  CG  TYR B  97      10.692  -2.786  52.521  1.00 34.11           C  
ATOM   1798  CD1 TYR B  97      11.879  -2.148  52.858  1.00 41.04           C  
ATOM   1799  CD2 TYR B  97      10.578  -3.246  51.196  1.00 37.96           C  
ATOM   1800  CE1 TYR B  97      12.970  -2.051  51.961  1.00 39.49           C  
ATOM   1801  CE2 TYR B  97      11.682  -3.144  50.260  1.00 36.30           C  
ATOM   1802  CZ  TYR B  97      12.885  -2.541  50.657  1.00 45.94           C  
ATOM   1803  OH  TYR B  97      14.035  -2.376  49.812  1.00 36.87           O  
ATOM   1804  N   TRP B  98       8.034  -4.646  55.936  1.00 34.98           N  
ATOM   1805  CA  TRP B  98       7.140  -4.962  57.080  1.00 36.70           C  
ATOM   1806  C   TRP B  98       6.260  -6.152  56.786  1.00 30.45           C  
ATOM   1807  O   TRP B  98       6.180  -6.598  55.637  1.00 27.19           O  
ATOM   1808  CB  TRP B  98       6.251  -3.773  57.572  1.00 39.02           C  
ATOM   1809  CG  TRP B  98       5.559  -3.194  56.456  1.00 44.81           C  
ATOM   1810  CD1 TRP B  98       4.472  -3.701  55.832  1.00 44.43           C  
ATOM   1811  CD2 TRP B  98       5.916  -1.995  55.754  1.00 48.49           C  
ATOM   1812  NE1 TRP B  98       4.143  -2.909  54.787  1.00 49.99           N  
ATOM   1813  CE2 TRP B  98       5.007  -1.853  54.711  1.00 39.98           C  
ATOM   1814  CE3 TRP B  98       6.934  -1.049  55.895  1.00 46.07           C  
ATOM   1815  CZ2 TRP B  98       5.045  -0.795  53.825  1.00 41.78           C  
ATOM   1816  CZ3 TRP B  98       6.980  -0.006  55.011  1.00 42.29           C  
ATOM   1817  CH2 TRP B  98       6.027   0.124  53.995  1.00 43.05           C  
ATOM   1818  N   ILE B  99       5.748  -6.735  57.862  1.00 31.92           N  
ATOM   1819  CA  ILE B  99       4.780  -7.786  57.800  1.00 30.67           C  
ATOM   1820  C   ILE B  99       3.557  -7.175  58.530  1.00 32.63           C  
ATOM   1821  O   ILE B  99       3.693  -6.773  59.669  1.00 35.45           O  
ATOM   1822  CB  ILE B  99       5.201  -9.085  58.476  1.00 33.26           C  
ATOM   1823  CG1 ILE B  99       6.424  -9.664  57.783  1.00 35.18           C  
ATOM   1824  CG2 ILE B  99       4.026 -10.129  58.374  1.00 29.64           C  
ATOM   1825  CD1 ILE B  99       6.933 -10.922  58.397  1.00 32.67           C  
ATOM   1826  N   ALA B 100       2.406  -7.056  57.867  1.00 32.76           N  
ATOM   1827  CA  ALA B 100       1.169  -6.522  58.490  1.00 30.38           C  
ATOM   1828  C   ALA B 100       0.066  -7.590  58.426  1.00 30.28           C  
ATOM   1829  O   ALA B 100      -0.231  -8.120  57.365  1.00 27.52           O  
ATOM   1830  CB  ALA B 100       0.705  -5.208  57.778  1.00 30.98           C  
ATOM   1831  N   VAL B 101      -0.541  -7.892  59.573  1.00 33.22           N  
ATOM   1832  CA  VAL B 101      -1.648  -8.869  59.699  1.00 33.67           C  
ATOM   1833  C   VAL B 101      -2.865  -8.160  60.314  1.00 35.36           C  
ATOM   1834  O   VAL B 101      -2.706  -7.405  61.285  1.00 33.11           O  
ATOM   1835  CB  VAL B 101      -1.231 -10.052  60.597  1.00 35.33           C  
ATOM   1836  CG1 VAL B 101      -2.423 -10.945  60.967  1.00 36.94           C  
ATOM   1837  CG2 VAL B 101      -0.126 -10.884  59.888  1.00 35.58           C  
ATOM   1838  N   ALA B 102      -4.057  -8.403  59.765  1.00 38.55           N  
ATOM   1839  CA  ALA B 102      -5.302  -7.797  60.284  1.00 43.08           C  
ATOM   1840  C   ALA B 102      -5.505  -8.246  61.748  1.00 44.46           C  
ATOM   1841  O   ALA B 102      -5.104  -9.355  62.092  1.00 42.00           O  
ATOM   1842  CB  ALA B 102      -6.466  -8.192  59.443  1.00 42.06           C  
ATOM   1843  N   PRO B 103      -6.088  -7.384  62.615  1.00 50.36           N  
ATOM   1844  CA  PRO B 103      -6.259  -7.734  64.045  1.00 51.75           C  
ATOM   1845  C   PRO B 103      -6.939  -9.062  64.326  1.00 53.13           C  
ATOM   1846  O   PRO B 103      -6.504  -9.776  65.228  1.00 52.63           O  
ATOM   1847  CB  PRO B 103      -7.083  -6.558  64.611  1.00 54.32           C  
ATOM   1848  CG  PRO B 103      -7.697  -5.896  63.412  1.00 54.37           C  
ATOM   1849  CD  PRO B 103      -6.656  -6.045  62.345  1.00 52.71           C  
ATOM   1850  N   HIS B 104      -7.949  -9.405  63.531  1.00 55.56           N  
ATOM   1851  CA  HIS B 104      -8.660 -10.665  63.720  1.00 58.95           C  
ATOM   1852  C   HIS B 104      -7.830 -11.923  63.373  1.00 58.19           C  
ATOM   1853  O   HIS B 104      -8.192 -13.005  63.807  1.00 57.21           O  
ATOM   1854  CB  HIS B 104      -9.975 -10.672  62.941  1.00 62.28           C  
ATOM   1855  CG  HIS B 104      -9.813 -10.874  61.471  1.00 67.31           C  
ATOM   1856  ND1 HIS B 104      -9.410  -9.867  60.619  1.00 72.94           N  
ATOM   1857  CD2 HIS B 104     -10.052 -11.957  60.694  1.00 71.93           C  
ATOM   1858  CE1 HIS B 104      -9.373 -10.334  59.382  1.00 77.50           C  
ATOM   1859  NE2 HIS B 104      -9.765 -11.598  59.400  1.00 78.95           N  
ATOM   1860  N   ARG B 105      -6.757 -11.795  62.577  1.00 57.58           N  
ATOM   1861  CA  ARG B 105      -5.889 -12.948  62.233  1.00 57.24           C  
ATOM   1862  C   ARG B 105      -4.536 -12.811  62.899  1.00 54.67           C  
ATOM   1863  O   ARG B 105      -3.608 -13.503  62.530  1.00 54.14           O  
ATOM   1864  CB  ARG B 105      -5.672 -13.035  60.711  1.00 57.19           C  
ATOM   1865  CG  ARG B 105      -6.933 -13.145  59.866  1.00 59.05           C  
ATOM   1866  CD  ARG B 105      -7.791 -14.367  60.233  1.00 60.93           C  
ATOM   1867  N   GLN B 106      -4.459 -12.029  63.964  1.00 56.09           N  
ATOM   1868  CA  GLN B 106      -3.187 -11.718  64.577  1.00 59.49           C  
ATOM   1869  C   GLN B 106      -2.582 -12.674  65.599  1.00 60.24           C  
ATOM   1870  O   GLN B 106      -1.388 -12.579  65.865  1.00 62.84           O  
ATOM   1871  CB  GLN B 106      -3.244 -10.269  65.068  1.00 61.26           C  
ATOM   1872  CG  GLN B 106      -1.875  -9.628  65.231  1.00 70.66           C  
ATOM   1873  CD  GLN B 106      -1.916  -8.118  65.127  1.00 78.86           C  
ATOM   1874  OE1 GLN B 106      -2.950  -7.481  65.353  1.00 85.67           O  
ATOM   1875  NE2 GLN B 106      -0.780  -7.533  64.763  1.00 79.78           N  
ATOM   1876  N   HIS B 107      -3.357 -13.571  66.187  1.00 60.53           N  
ATOM   1877  CA  HIS B 107      -2.781 -14.562  67.127  1.00 61.85           C  
ATOM   1878  C   HIS B 107      -2.984 -15.935  66.483  1.00 59.95           C  
ATOM   1879  O   HIS B 107      -3.294 -16.912  67.146  1.00 60.12           O  
ATOM   1880  CB  HIS B 107      -3.332 -14.418  68.566  1.00 62.43           C  
ATOM   1881  CG  HIS B 107      -2.776 -13.233  69.298  1.00 67.04           C  
ATOM   1882  ND1 HIS B 107      -1.467 -13.181  69.734  1.00 73.66           N  
ATOM   1883  CD2 HIS B 107      -3.347 -12.068  69.691  1.00 71.06           C  
ATOM   1884  CE1 HIS B 107      -1.248 -12.024  70.338  1.00 71.83           C  
ATOM   1885  NE2 HIS B 107      -2.373 -11.331  70.326  1.00 71.99           N  
ATOM   1886  N   SER B 108      -2.703 -15.975  65.180  1.00 57.77           N  
ATOM   1887  CA  SER B 108      -2.879 -17.128  64.319  1.00 56.65           C  
ATOM   1888  C   SER B 108      -1.598 -17.792  63.800  1.00 53.68           C  
ATOM   1889  O   SER B 108      -1.686 -18.877  63.230  1.00 54.74           O  
ATOM   1890  CB  SER B 108      -3.658 -16.637  63.085  1.00 57.58           C  
ATOM   1891  OG  SER B 108      -3.914 -17.667  62.150  1.00 65.46           O  
ATOM   1892  N   GLY B 109      -0.428 -17.179  63.993  1.00 48.67           N  
ATOM   1893  CA  GLY B 109       0.827 -17.708  63.444  1.00 45.24           C  
ATOM   1894  C   GLY B 109       1.033 -17.273  61.979  1.00 42.28           C  
ATOM   1895  O   GLY B 109       1.994 -17.709  61.333  1.00 40.69           O  
ATOM   1896  N   LEU B 110       0.166 -16.393  61.462  1.00 37.61           N  
ATOM   1897  CA  LEU B 110       0.235 -15.922  60.083  1.00 35.97           C  
ATOM   1898  C   LEU B 110       1.478 -15.047  59.839  1.00 34.62           C  
ATOM   1899  O   LEU B 110       2.045 -15.068  58.752  1.00 30.01           O  
ATOM   1900  CB  LEU B 110      -1.019 -15.138  59.740  1.00 32.48           C  
ATOM   1901  CG  LEU B 110      -1.180 -14.609  58.303  1.00 37.56           C  
ATOM   1902  CD1 LEU B 110      -1.199 -15.717  57.248  1.00 37.24           C  
ATOM   1903  CD2 LEU B 110      -2.417 -13.744  58.208  1.00 35.06           C  
ATOM   1904  N   GLY B 111       1.879 -14.276  60.850  1.00 36.31           N  
ATOM   1905  CA  GLY B 111       3.059 -13.434  60.741  1.00 35.47           C  
ATOM   1906  C   GLY B 111       4.266 -14.300  60.447  1.00 34.22           C  
ATOM   1907  O   GLY B 111       5.017 -13.989  59.509  1.00 31.68           O  
ATOM   1908  N   ARG B 112       4.459 -15.358  61.245  0.50 34.69           N  
ATOM   1910  CA  ARG B 112       5.582 -16.312  61.052  0.50 35.06           C  
ATOM   1912  C   ARG B 112       5.499 -17.041  59.705  0.50 33.85           C  
ATOM   1914  O   ARG B 112       6.536 -17.283  59.100  0.50 34.03           O  
ATOM   1916  CB  ARG B 112       5.900 -17.230  62.291  0.50 34.66           C  
ATOM   1918  CG  ARG B 112       4.737 -17.698  63.214  0.50 38.17           C  
ATOM   1920  CD  ARG B 112       5.160 -18.537  64.443  0.50 38.06           C  
ATOM   1922  NE  ARG B 112       5.188 -19.988  64.253  0.50 41.50           N  
ATOM   1924  CZ  ARG B 112       4.203 -20.793  64.648  0.50 34.86           C  
ATOM   1926  N   ALA B 113       4.280 -17.336  59.241  1.00 33.53           N  
ATOM   1927  CA  ALA B 113       4.027 -17.975  57.947  1.00 32.43           C  
ATOM   1928  C   ALA B 113       4.417 -17.038  56.800  1.00 30.94           C  
ATOM   1929  O   ALA B 113       5.009 -17.469  55.820  1.00 26.54           O  
ATOM   1930  CB  ALA B 113       2.552 -18.345  57.813  1.00 31.79           C  
ATOM   1931  N   LEU B 114       4.042 -15.764  56.909  1.00 30.17           N  
ATOM   1932  CA  LEU B 114       4.417 -14.769  55.904  1.00 29.08           C  
ATOM   1933  C   LEU B 114       5.930 -14.587  55.844  1.00 26.45           C  
ATOM   1934  O   LEU B 114       6.486 -14.541  54.752  1.00 27.20           O  
ATOM   1935  CB  LEU B 114       3.697 -13.439  56.140  1.00 27.57           C  
ATOM   1936  CG  LEU B 114       2.252 -13.387  55.682  1.00 28.93           C  
ATOM   1937  CD1 LEU B 114       1.485 -12.213  56.378  1.00 28.55           C  
ATOM   1938  CD2 LEU B 114       2.176 -13.298  54.164  1.00 30.00           C  
ATOM   1939  N   LEU B 115       6.597 -14.494  56.985  1.00 30.01           N  
ATOM   1940  CA  LEU B 115       8.056 -14.377  56.998  1.00 28.83           C  
ATOM   1941  C   LEU B 115       8.703 -15.633  56.348  1.00 28.87           C  
ATOM   1942  O   LEU B 115       9.696 -15.516  55.633  1.00 28.70           O  
ATOM   1943  CB  LEU B 115       8.588 -14.231  58.414  1.00 28.52           C  
ATOM   1944  CG  LEU B 115      10.105 -14.204  58.619  1.00 28.37           C  
ATOM   1945  CD1 LEU B 115      10.842 -13.016  57.953  1.00 27.00           C  
ATOM   1946  CD2 LEU B 115      10.405 -14.249  60.091  1.00 28.39           C  
ATOM   1947  N   ALA B 116       8.192 -16.834  56.673  1.00 26.61           N  
ATOM   1948  CA  ALA B 116       8.721 -18.066  56.070  1.00 28.63           C  
ATOM   1949  C   ALA B 116       8.633 -18.004  54.521  1.00 27.70           C  
ATOM   1950  O   ALA B 116       9.541 -18.438  53.800  1.00 29.80           O  
ATOM   1951  CB  ALA B 116       8.007 -19.298  56.639  1.00 29.24           C  
ATOM   1952  N   GLU B 117       7.560 -17.440  54.002  1.00 26.09           N  
ATOM   1953  CA  GLU B 117       7.437 -17.321  52.554  1.00 25.62           C  
ATOM   1954  C   GLU B 117       8.443 -16.316  51.951  1.00 28.37           C  
ATOM   1955  O   GLU B 117       8.994 -16.543  50.857  1.00 27.24           O  
ATOM   1956  CB  GLU B 117       5.994 -16.957  52.175  1.00 28.40           C  
ATOM   1957  CG  GLU B 117       4.946 -17.996  52.570  1.00 33.09           C  
ATOM   1958  CD  GLU B 117       5.264 -19.429  52.134  1.00 38.85           C  
ATOM   1959  OE1 GLU B 117       5.647 -19.639  50.983  1.00 38.03           O  
ATOM   1960  OE2 GLU B 117       5.117 -20.342  52.975  1.00 43.07           O  
ATOM   1961  N   VAL B 118       8.644 -15.179  52.631  1.00 26.85           N  
ATOM   1962  CA  VAL B 118       9.606 -14.194  52.173  1.00 25.08           C  
ATOM   1963  C   VAL B 118      10.988 -14.828  52.133  1.00 23.56           C  
ATOM   1964  O   VAL B 118      11.727 -14.624  51.185  1.00 27.78           O  
ATOM   1965  CB  VAL B 118       9.626 -12.942  53.092  1.00 24.70           C  
ATOM   1966  CG1 VAL B 118      10.857 -12.113  52.822  1.00 26.11           C  
ATOM   1967  CG2 VAL B 118       8.255 -12.152  52.939  1.00 22.14           C  
ATOM   1968  N   VAL B 119      11.341 -15.560  53.191  1.00 24.66           N  
ATOM   1969  CA  VAL B 119      12.647 -16.238  53.290  1.00 25.74           C  
ATOM   1970  C   VAL B 119      12.832 -17.271  52.172  1.00 26.90           C  
ATOM   1971  O   VAL B 119      13.892 -17.358  51.611  1.00 26.77           O  
ATOM   1972  CB  VAL B 119      12.846 -16.872  54.660  1.00 26.53           C  
ATOM   1973  CG1 VAL B 119      14.040 -17.804  54.686  1.00 25.61           C  
ATOM   1974  CG2 VAL B 119      12.972 -15.780  55.693  1.00 27.15           C  
ATOM   1975  N   HIS B 120      11.767 -18.000  51.838  1.00 31.23           N  
ATOM   1976  CA  HIS B 120      11.776 -18.956  50.743  1.00 29.75           C  
ATOM   1977  C   HIS B 120      12.108 -18.241  49.448  1.00 30.34           C  
ATOM   1978  O   HIS B 120      12.979 -18.661  48.687  1.00 28.16           O  
ATOM   1979  CB  HIS B 120      10.394 -19.599  50.630  1.00 31.75           C  
ATOM   1980  CG  HIS B 120      10.142 -20.309  49.341  1.00 32.91           C  
ATOM   1981  ND1 HIS B 120       9.655 -19.664  48.223  1.00 43.19           N  
ATOM   1982  CD2 HIS B 120      10.265 -21.615  48.998  1.00 35.84           C  
ATOM   1983  CE1 HIS B 120       9.512 -20.535  47.240  1.00 43.03           C  
ATOM   1984  NE2 HIS B 120       9.866 -21.728  47.688  1.00 38.17           N  
ATOM   1985  N   ASP B 121      11.414 -17.138  49.205  1.00 33.42           N  
ATOM   1986  CA  ASP B 121      11.615 -16.358  47.980  1.00 31.82           C  
ATOM   1987  C   ASP B 121      12.984 -15.739  47.837  1.00 31.84           C  
ATOM   1988  O   ASP B 121      13.512 -15.701  46.746  1.00 31.52           O  
ATOM   1989  CB  ASP B 121      10.567 -15.269  47.836  1.00 31.78           C  
ATOM   1990  CG  ASP B 121       9.187 -15.795  47.677  1.00 36.78           C  
ATOM   1991  OD1 ASP B 121       8.984 -17.035  47.572  1.00 35.36           O  
ATOM   1992  OD2 ASP B 121       8.283 -14.947  47.637  1.00 45.30           O  
ATOM   1993  N   VAL B 122      13.516 -15.218  48.942  1.00 33.07           N  
ATOM   1994  CA  VAL B 122      14.833 -14.611  49.007  1.00 31.43           C  
ATOM   1995  C   VAL B 122      15.884 -15.712  48.791  1.00 31.67           C  
ATOM   1996  O   VAL B 122      16.859 -15.497  48.086  1.00 31.75           O  
ATOM   1997  CB  VAL B 122      15.046 -13.850  50.339  1.00 31.52           C  
ATOM   1998  CG1 VAL B 122      16.498 -13.538  50.569  1.00 30.80           C  
ATOM   1999  CG2 VAL B 122      14.184 -12.581  50.363  1.00 25.93           C  
ATOM   2000  N   ARG B 123      15.722 -16.859  49.436  1.00 31.58           N  
ATOM   2001  CA  ARG B 123      16.622 -17.971  49.179  1.00 34.97           C  
ATOM   2002  C   ARG B 123      16.668 -18.357  47.682  1.00 33.12           C  
ATOM   2003  O   ARG B 123      17.758 -18.551  47.129  1.00 35.05           O  
ATOM   2004  CB  ARG B 123      16.229 -19.191  49.980  1.00 37.04           C  
ATOM   2005  CG  ARG B 123      16.636 -19.110  51.390  1.00 45.49           C  
ATOM   2006  CD  ARG B 123      16.081 -20.246  52.246  1.00 52.96           C  
ATOM   2007  NE  ARG B 123      16.715 -20.198  53.572  1.00 54.30           N  
ATOM   2008  CZ  ARG B 123      16.309 -20.862  54.659  1.00 54.26           C  
ATOM   2009  NH1 ARG B 123      15.151 -21.540  54.703  1.00 46.35           N  
ATOM   2010  NH2 ARG B 123      17.033 -20.728  55.773  1.00 59.03           N  
ATOM   2011  N   LEU B 124      15.514 -18.453  47.036  1.00 34.73           N  
ATOM   2012  CA  LEU B 124      15.480 -18.806  45.598  1.00 37.48           C  
ATOM   2013  C   LEU B 124      16.209 -17.900  44.633  1.00 36.93           C  
ATOM   2014  O   LEU B 124      16.691 -18.362  43.607  1.00 38.43           O  
ATOM   2015  CB  LEU B 124      14.054 -19.009  45.067  1.00 38.39           C  
ATOM   2016  CG  LEU B 124      13.502 -20.422  45.226  1.00 44.55           C  
ATOM   2017  CD1 LEU B 124      13.678 -20.955  46.650  1.00 50.09           C  
ATOM   2018  CD2 LEU B 124      12.065 -20.451  44.756  1.00 40.40           C  
ATOM   2019  N   THR B 125      16.292 -16.624  44.949  1.00 36.63           N  
ATOM   2020  CA  THR B 125      16.949 -15.663  44.100  1.00 37.30           C  
ATOM   2021  C   THR B 125      18.406 -15.527  44.464  1.00 39.03           C  
ATOM   2022  O   THR B 125      19.054 -14.638  43.963  1.00 43.01           O  
ATOM   2023  CB  THR B 125      16.237 -14.310  44.168  1.00 40.55           C  
ATOM   2024  OG1 THR B 125      16.219 -13.851  45.519  1.00 44.39           O  
ATOM   2025  CG2 THR B 125      14.810 -14.455  43.712  1.00 41.10           C  
ATOM   2026  N   GLY B 126      18.919 -16.404  45.334  1.00 38.43           N  
ATOM   2027  CA  GLY B 126      20.313 -16.403  45.746  1.00 38.96           C  
ATOM   2028  C   GLY B 126      20.673 -15.533  46.931  1.00 38.68           C  
ATOM   2029  O   GLY B 126      21.862 -15.297  47.172  1.00 38.93           O  
ATOM   2030  N   GLY B 127      19.686 -15.098  47.710  1.00 35.69           N  
ATOM   2031  CA  GLY B 127      19.965 -14.235  48.845  1.00 34.45           C  
ATOM   2032  C   GLY B 127      20.695 -14.911  49.987  1.00 33.56           C  
ATOM   2033  O   GLY B 127      20.504 -16.104  50.238  1.00 33.22           O  
ATOM   2034  N   ARG B 128      21.563 -14.135  50.638  1.00 31.75           N  
ATOM   2035  CA  ARG B 128      22.351 -14.532  51.784  1.00 32.84           C  
ATOM   2036  C   ARG B 128      21.792 -13.953  53.068  1.00 30.91           C  
ATOM   2037  O   ARG B 128      21.835 -14.622  54.089  1.00 30.43           O  
ATOM   2038  CB  ARG B 128      23.782 -13.960  51.651  1.00 33.38           C  
ATOM   2039  CG  ARG B 128      24.502 -14.310  50.356  1.00 36.40           C  
ATOM   2040  CD  ARG B 128      25.837 -13.568  50.156  1.00 35.40           C  
ATOM   2041  NE  ARG B 128      25.660 -12.114  50.131  1.00 30.63           N  
ATOM   2042  CZ  ARG B 128      25.956 -11.278  51.123  1.00 34.76           C  
ATOM   2043  NH1 ARG B 128      26.499 -11.697  52.260  1.00 28.84           N  
ATOM   2044  NH2 ARG B 128      25.735  -9.992  50.973  1.00 34.59           N  
ATOM   2045  N   LEU B 129      21.305 -12.698  53.017  1.00 30.75           N  
ATOM   2046  CA  LEU B 129      20.822 -11.968  54.192  1.00 26.97           C  
ATOM   2047  C   LEU B 129      19.498 -11.302  54.031  1.00 26.03           C  
ATOM   2048  O   LEU B 129      19.194 -10.842  52.969  1.00 27.27           O  
ATOM   2049  CB  LEU B 129      21.814 -10.846  54.506  1.00 25.80           C  
ATOM   2050  CG  LEU B 129      23.232 -11.282  54.913  1.00 28.83           C  
ATOM   2051  CD1 LEU B 129      24.234 -10.084  54.897  1.00 26.96           C  
ATOM   2052  CD2 LEU B 129      23.073 -11.918  56.228  1.00 25.41           C  
ATOM   2053  N   LEU B 130      18.742 -11.246  55.118  1.00 29.17           N  
ATOM   2054  CA  LEU B 130      17.463 -10.536  55.146  1.00 28.76           C  
ATOM   2055  C   LEU B 130      17.566  -9.641  56.359  1.00 28.28           C  
ATOM   2056  O   LEU B 130      17.789 -10.146  57.474  1.00 28.98           O  
ATOM   2057  CB  LEU B 130      16.250 -11.445  55.318  1.00 27.70           C  
ATOM   2058  CG  LEU B 130      14.868 -10.769  55.369  1.00 31.03           C  
ATOM   2059  CD1 LEU B 130      14.619  -9.987  54.106  1.00 24.07           C  
ATOM   2060  CD2 LEU B 130      13.710 -11.771  55.611  1.00 29.30           C  
ATOM   2061  N   PHE B 131      17.419  -8.334  56.129  1.00 26.24           N  
ATOM   2062  CA  PHE B 131      17.460  -7.375  57.196  1.00 28.74           C  
ATOM   2063  C   PHE B 131      16.080  -6.789  57.478  1.00 29.43           C  
ATOM   2064  O   PHE B 131      15.301  -6.631  56.580  1.00 30.38           O  
ATOM   2065  CB  PHE B 131      18.432  -6.225  56.886  1.00 27.43           C  
ATOM   2066  CG  PHE B 131      19.867  -6.617  56.966  1.00 28.33           C  
ATOM   2067  CD1 PHE B 131      20.502  -6.703  58.197  1.00 23.78           C  
ATOM   2068  CD2 PHE B 131      20.576  -6.959  55.834  1.00 27.84           C  
ATOM   2069  CE1 PHE B 131      21.793  -7.062  58.256  1.00 29.07           C  
ATOM   2070  CE2 PHE B 131      21.838  -7.340  55.894  1.00 30.46           C  
ATOM   2071  CZ  PHE B 131      22.482  -7.382  57.115  1.00 24.03           C  
ATOM   2072  N   ALA B 132      15.808  -6.538  58.768  1.00 32.43           N  
ATOM   2073  CA  ALA B 132      14.578  -5.883  59.235  1.00 28.30           C  
ATOM   2074  C   ALA B 132      14.971  -4.776  60.203  1.00 27.53           C  
ATOM   2075  O   ALA B 132      15.789  -4.971  61.073  1.00 30.99           O  
ATOM   2076  CB  ALA B 132      13.584  -6.882  59.908  1.00 25.90           C  
ATOM   2077  N   GLU B 133      14.333  -3.633  60.105  1.00 29.49           N  
ATOM   2078  CA  GLU B 133      14.622  -2.502  60.998  1.00 33.98           C  
ATOM   2079  C   GLU B 133      13.384  -2.164  61.792  1.00 34.27           C  
ATOM   2080  O   GLU B 133      12.290  -2.197  61.248  1.00 31.52           O  
ATOM   2081  CB  GLU B 133      14.993  -1.268  60.176  1.00 33.32           C  
ATOM   2082  CG  GLU B 133      16.133  -1.483  59.278  1.00 37.84           C  
ATOM   2083  CD  GLU B 133      16.554  -0.222  58.552  1.00 41.42           C  
ATOM   2084  OE1 GLU B 133      15.708   0.657  58.310  1.00 37.05           O  
ATOM   2085  OE2 GLU B 133      17.733  -0.145  58.208  1.00 48.25           O  
ATOM   2086  N   THR B 134      13.543  -1.871  63.078  1.00 32.62           N  
ATOM   2087  CA  THR B 134      12.408  -1.457  63.858  1.00 33.89           C  
ATOM   2088  C   THR B 134      12.850  -0.439  64.905  1.00 33.22           C  
ATOM   2089  O   THR B 134      14.045  -0.088  64.998  1.00 33.44           O  
ATOM   2090  CB  THR B 134      11.619  -2.661  64.451  1.00 36.65           C  
ATOM   2091  OG1 THR B 134      10.364  -2.186  64.932  1.00 37.72           O  
ATOM   2092  CG2 THR B 134      12.394  -3.362  65.560  1.00 36.77           C  
ATOM   2093  N   SER B 135      11.877   0.047  65.656  1.00 32.86           N  
ATOM   2094  CA  SER B 135      12.099   1.038  66.699  1.00 33.31           C  
ATOM   2095  C   SER B 135      12.390   0.386  68.042  1.00 34.74           C  
ATOM   2096  O   SER B 135      11.978  -0.729  68.318  1.00 35.19           O  
ATOM   2097  CB  SER B 135      10.895   1.970  66.795  1.00 34.20           C  
ATOM   2098  OG  SER B 135      10.943   2.734  67.965  1.00 35.05           O  
ATOM   2099  N   GLY B 136      13.103   1.104  68.885  1.00 36.50           N  
ATOM   2100  CA  GLY B 136      13.446   0.612  70.217  1.00 38.03           C  
ATOM   2101  C   GLY B 136      12.464   0.981  71.314  1.00 37.93           C  
ATOM   2102  O   GLY B 136      12.718   0.613  72.470  1.00 38.13           O  
ATOM   2103  N   ILE B 137      11.364   1.679  70.967  1.00 37.01           N  
ATOM   2104  CA  ILE B 137      10.346   2.097  71.947  1.00 37.62           C  
ATOM   2105  C   ILE B 137       9.442   0.939  72.410  1.00 36.46           C  
ATOM   2106  O   ILE B 137       9.287  -0.071  71.709  1.00 34.23           O  
ATOM   2107  CB  ILE B 137       9.491   3.349  71.482  1.00 36.39           C  
ATOM   2108  CG1 ILE B 137       8.556   3.047  70.314  1.00 39.12           C  
ATOM   2109  CG2 ILE B 137      10.364   4.551  71.213  1.00 32.15           C  
ATOM   2110  CD1 ILE B 137       7.744   4.278  69.883  1.00 39.41           C  
ATOM   2111  N   ARG B 138       8.835   1.109  73.593  1.00 37.88           N  
ATOM   2112  CA  ARG B 138       7.941   0.100  74.201  1.00 35.98           C  
ATOM   2113  C   ARG B 138       6.903  -0.502  73.231  1.00 36.76           C  
ATOM   2114  O   ARG B 138       6.764  -1.730  73.142  1.00 36.32           O  
ATOM   2115  CB  ARG B 138       7.237   0.696  75.441  1.00 36.46           C  
ATOM   2116  N   LYS B 139       6.219   0.359  72.479  1.00 37.75           N  
ATOM   2117  CA  LYS B 139       5.207  -0.055  71.494  1.00 40.92           C  
ATOM   2118  C   LYS B 139       5.672  -1.146  70.508  1.00 41.70           C  
ATOM   2119  O   LYS B 139       4.856  -1.946  70.033  1.00 40.77           O  
ATOM   2120  CB  LYS B 139       4.771   1.190  70.706  1.00 42.44           C  
ATOM   2121  CG  LYS B 139       3.756   0.963  69.567  1.00 47.23           C  
ATOM   2122  CD  LYS B 139       3.563   2.250  68.772  1.00 46.94           C  
ATOM   2123  CE  LYS B 139       2.525   2.039  67.696  1.00 56.84           C  
ATOM   2124  NZ  LYS B 139       2.372   3.242  66.860  1.00 64.21           N  
ATOM   2125  N   TYR B 140       6.971  -1.137  70.186  1.00 41.36           N  
ATOM   2126  CA  TYR B 140       7.597  -2.096  69.267  1.00 40.62           C  
ATOM   2127  C   TYR B 140       8.201  -3.319  69.921  1.00 40.96           C  
ATOM   2128  O   TYR B 140       8.814  -4.120  69.237  1.00 40.48           O  
ATOM   2129  CB  TYR B 140       8.623  -1.383  68.383  1.00 41.64           C  
ATOM   2130  CG  TYR B 140       7.944  -0.498  67.376  1.00 39.44           C  
ATOM   2131  CD1 TYR B 140       7.598   0.800  67.686  1.00 41.17           C  
ATOM   2132  CD2 TYR B 140       7.623  -0.982  66.123  1.00 44.50           C  
ATOM   2133  CE1 TYR B 140       6.975   1.612  66.775  1.00 39.98           C  
ATOM   2134  CE2 TYR B 140       6.992  -0.182  65.214  1.00 37.57           C  
ATOM   2135  CZ  TYR B 140       6.678   1.111  65.546  1.00 38.94           C  
ATOM   2136  OH  TYR B 140       6.028   1.897  64.632  1.00 48.30           O  
ATOM   2137  N   ALA B 141       8.027  -3.463  71.240  1.00 40.57           N  
ATOM   2138  CA  ALA B 141       8.507  -4.634  71.968  1.00 40.82           C  
ATOM   2139  C   ALA B 141       8.001  -5.950  71.334  1.00 40.28           C  
ATOM   2140  O   ALA B 141       8.792  -6.876  71.157  1.00 40.00           O  
ATOM   2141  CB  ALA B 141       8.137  -4.525  73.462  1.00 38.70           C  
ATOM   2142  N   PRO B 142       6.694  -6.037  70.981  1.00 41.79           N  
ATOM   2143  CA  PRO B 142       6.191  -7.252  70.322  1.00 40.97           C  
ATOM   2144  C   PRO B 142       6.911  -7.591  69.006  1.00 40.12           C  
ATOM   2145  O   PRO B 142       7.301  -8.738  68.798  1.00 38.57           O  
ATOM   2146  CB  PRO B 142       4.724  -6.916  70.065  1.00 40.69           C  
ATOM   2147  CG  PRO B 142       4.380  -5.911  71.094  1.00 41.62           C  
ATOM   2148  CD  PRO B 142       5.591  -5.084  71.237  1.00 42.21           C  
ATOM   2149  N   THR B 143       7.069  -6.589  68.140  1.00 39.79           N  
ATOM   2150  CA  THR B 143       7.778  -6.719  66.868  1.00 36.82           C  
ATOM   2151  C   THR B 143       9.186  -7.236  67.087  1.00 34.01           C  
ATOM   2152  O   THR B 143       9.622  -8.127  66.386  1.00 34.81           O  
ATOM   2153  CB  THR B 143       7.877  -5.369  66.147  1.00 36.97           C  
ATOM   2154  OG1 THR B 143       6.558  -4.843  65.923  1.00 39.75           O  
ATOM   2155  CG2 THR B 143       8.578  -5.519  64.808  1.00 37.07           C  
ATOM   2156  N   ARG B 144       9.912  -6.659  68.037  1.00 33.77           N  
ATOM   2157  CA  ARG B 144      11.279  -7.128  68.341  1.00 34.81           C  
ATOM   2158  C   ARG B 144      11.301  -8.609  68.767  1.00 39.26           C  
ATOM   2159  O   ARG B 144      12.207  -9.349  68.365  1.00 41.93           O  
ATOM   2160  CB  ARG B 144      11.956  -6.232  69.394  1.00 34.89           C  
ATOM   2161  CG  ARG B 144      12.221  -4.828  68.903  1.00 33.28           C  
ATOM   2162  CD  ARG B 144      13.159  -4.046  69.795  1.00 35.48           C  
ATOM   2163  NE  ARG B 144      12.689  -3.838  71.165  1.00 34.10           N  
ATOM   2164  CZ  ARG B 144      11.793  -2.925  71.541  1.00 35.90           C  
ATOM   2165  NH1 ARG B 144      11.190  -2.147  70.656  1.00 36.84           N  
ATOM   2166  NH2 ARG B 144      11.454  -2.808  72.820  1.00 40.95           N  
ATOM   2167  N   ARG B 145      10.305  -9.015  69.584  1.00 40.78           N  
ATOM   2168  CA  ARG B 145      10.129 -10.402  70.057  1.00 40.49           C  
ATOM   2169  C   ARG B 145       9.908 -11.299  68.849  1.00 37.62           C  
ATOM   2170  O   ARG B 145      10.555 -12.343  68.728  1.00 38.93           O  
ATOM   2171  CB  ARG B 145       8.945 -10.535  71.056  1.00 40.12           C  
ATOM   2172  N   PHE B 146       9.007 -10.873  67.963  1.00 37.07           N  
ATOM   2173  CA  PHE B 146       8.713 -11.598  66.727  1.00 37.51           C  
ATOM   2174  C   PHE B 146       9.973 -11.904  65.938  1.00 37.87           C  
ATOM   2175  O   PHE B 146      10.233 -13.065  65.578  1.00 37.97           O  
ATOM   2176  CB  PHE B 146       7.732 -10.790  65.868  1.00 36.73           C  
ATOM   2177  CG  PHE B 146       7.426 -11.408  64.548  1.00 41.40           C  
ATOM   2178  CD1 PHE B 146       6.511 -12.460  64.451  1.00 38.89           C  
ATOM   2179  CD2 PHE B 146       8.004 -10.922  63.387  1.00 42.80           C  
ATOM   2180  CE1 PHE B 146       6.234 -13.028  63.243  1.00 34.65           C  
ATOM   2181  CE2 PHE B 146       7.704 -11.480  62.185  1.00 45.00           C  
ATOM   2182  CZ  PHE B 146       6.809 -12.535  62.107  1.00 39.49           C  
ATOM   2183  N   TYR B 147      10.771 -10.860  65.690  1.00 39.57           N  
ATOM   2184  CA  TYR B 147      12.019 -11.003  64.960  1.00 37.21           C  
ATOM   2185  C   TYR B 147      13.011 -11.902  65.683  1.00 35.18           C  
ATOM   2186  O   TYR B 147      13.596 -12.787  65.058  1.00 32.28           O  
ATOM   2187  CB  TYR B 147      12.666  -9.644  64.598  1.00 37.55           C  
ATOM   2188  CG  TYR B 147      11.878  -8.779  63.623  1.00 37.71           C  
ATOM   2189  CD1 TYR B 147      11.293  -9.328  62.459  1.00 36.99           C  
ATOM   2190  CD2 TYR B 147      11.849  -7.399  63.756  1.00 37.14           C  
ATOM   2191  CE1 TYR B 147      10.590  -8.551  61.567  1.00 38.33           C  
ATOM   2192  CE2 TYR B 147      11.160  -6.608  62.826  1.00 41.75           C  
ATOM   2193  CZ  TYR B 147      10.546  -7.206  61.730  1.00 36.19           C  
ATOM   2194  OH  TYR B 147       9.860  -6.460  60.786  1.00 42.11           O  
ATOM   2195  N   GLU B 148      13.169 -11.691  66.991  1.00 36.78           N  
ATOM   2196  CA  GLU B 148      14.063 -12.512  67.802  1.00 37.87           C  
ATOM   2197  C   GLU B 148      13.637 -13.964  67.849  1.00 38.76           C  
ATOM   2198  O   GLU B 148      14.502 -14.843  67.762  1.00 39.71           O  
ATOM   2199  CB  GLU B 148      14.211 -11.922  69.196  1.00 35.00           C  
ATOM   2200  CG  GLU B 148      15.013 -10.619  69.131  1.00 42.32           C  
ATOM   2201  CD  GLU B 148      15.041  -9.801  70.415  1.00 43.52           C  
ATOM   2202  OE1 GLU B 148      14.475 -10.236  71.445  1.00 43.05           O  
ATOM   2203  OE2 GLU B 148      15.643  -8.694  70.358  1.00 49.15           O  
ATOM   2204  N   ARG B 149      12.326 -14.216  67.957  1.00 39.19           N  
ATOM   2205  CA  ARG B 149      11.785 -15.598  67.978  1.00 39.30           C  
ATOM   2206  C   ARG B 149      11.969 -16.277  66.619  1.00 40.43           C  
ATOM   2207  O   ARG B 149      12.148 -17.483  66.559  1.00 40.24           O  
ATOM   2208  CB  ARG B 149      10.299 -15.619  68.351  1.00 38.78           C  
ATOM   2209  N   ALA B 150      11.975 -15.493  65.530  1.00 40.29           N  
ATOM   2210  CA  ALA B 150      12.146 -16.033  64.177  1.00 39.83           C  
ATOM   2211  C   ALA B 150      13.610 -16.292  63.819  1.00 39.08           C  
ATOM   2212  O   ALA B 150      13.901 -16.716  62.702  1.00 43.07           O  
ATOM   2213  CB  ALA B 150      11.474 -15.126  63.141  1.00 41.30           C  
ATOM   2214  N   GLY B 151      14.531 -16.055  64.742  1.00 37.48           N  
ATOM   2215  CA  GLY B 151      15.947 -16.298  64.494  1.00 38.78           C  
ATOM   2216  C   GLY B 151      16.762 -15.100  64.025  1.00 37.74           C  
ATOM   2217  O   GLY B 151      17.896 -15.289  63.593  1.00 37.52           O  
ATOM   2218  N   PHE B 152      16.179 -13.897  64.066  1.00 37.88           N  
ATOM   2219  CA  PHE B 152      16.901 -12.670  63.675  1.00 38.99           C  
ATOM   2220  C   PHE B 152      17.717 -12.298  64.884  1.00 38.89           C  
ATOM   2221  O   PHE B 152      17.329 -12.589  66.014  1.00 40.82           O  
ATOM   2222  CB  PHE B 152      16.017 -11.441  63.366  1.00 35.20           C  
ATOM   2223  CG  PHE B 152      15.294 -11.441  62.018  1.00 39.21           C  
ATOM   2224  CD1 PHE B 152      14.111 -12.154  61.808  1.00 35.71           C  
ATOM   2225  CD2 PHE B 152      15.742 -10.591  60.981  1.00 28.11           C  
ATOM   2226  CE1 PHE B 152      13.440 -12.071  60.570  1.00 40.49           C  
ATOM   2227  CE2 PHE B 152      15.087 -10.512  59.739  1.00 34.00           C  
ATOM   2228  CZ  PHE B 152      13.945 -11.254  59.527  1.00 39.34           C  
ATOM   2229  N   SER B 153      18.866 -11.700  64.655  1.00 38.19           N  
ATOM   2230  CA  SER B 153      19.706 -11.247  65.735  1.00 37.39           C  
ATOM   2231  C   SER B 153      19.814  -9.720  65.565  1.00 34.87           C  
ATOM   2232  O   SER B 153      19.823  -9.204  64.448  1.00 32.97           O  
ATOM   2233  CB  SER B 153      21.076 -11.926  65.684  1.00 39.35           C  
ATOM   2234  OG  SER B 153      21.769 -11.565  64.498  1.00 43.56           O  
ATOM   2235  N   ALA B 154      19.776  -9.011  66.684  1.00 34.60           N  
ATOM   2236  CA  ALA B 154      19.926  -7.580  66.744  1.00 34.02           C  
ATOM   2237  C   ALA B 154      21.383  -7.343  66.417  1.00 34.37           C  
ATOM   2238  O   ALA B 154      22.235  -7.693  67.204  1.00 39.06           O  
ATOM   2239  CB  ALA B 154      19.619  -7.098  68.179  1.00 31.50           C  
ATOM   2240  N   GLU B 155      21.701  -6.790  65.252  1.00 32.71           N  
ATOM   2241  CA  GLU B 155      23.120  -6.539  64.890  1.00 30.96           C  
ATOM   2242  C   GLU B 155      23.609  -5.100  65.072  1.00 32.82           C  
ATOM   2243  O   GLU B 155      24.815  -4.890  65.215  1.00 34.42           O  
ATOM   2244  CB  GLU B 155      23.411  -7.033  63.480  1.00 27.43           C  
ATOM   2245  CG  GLU B 155      24.888  -6.958  63.074  1.00 30.94           C  
ATOM   2246  CD  GLU B 155      25.178  -7.556  61.744  1.00 34.34           C  
ATOM   2247  OE1 GLU B 155      24.274  -7.554  60.887  1.00 27.40           O  
ATOM   2248  OE2 GLU B 155      26.346  -7.965  61.529  1.00 29.08           O  
ATOM   2249  N   ALA B 156      22.708  -4.116  65.060  1.00 32.63           N  
ATOM   2250  CA  ALA B 156      23.087  -2.711  65.211  1.00 32.20           C  
ATOM   2251  C   ALA B 156      21.965  -1.930  65.877  1.00 34.00           C  
ATOM   2252  O   ALA B 156      20.782  -2.252  65.713  1.00 30.31           O  
ATOM   2253  CB  ALA B 156      23.375  -2.107  63.836  1.00 28.83           C  
ATOM   2254  N   VAL B 157      22.375  -0.884  66.592  1.00 33.33           N  
ATOM   2255  CA  VAL B 157      21.516   0.043  67.298  1.00 32.87           C  
ATOM   2256  C   VAL B 157      22.047   1.436  66.926  1.00 32.49           C  
ATOM   2257  O   VAL B 157      23.237   1.684  67.041  1.00 31.93           O  
ATOM   2258  CB  VAL B 157      21.581  -0.199  68.831  1.00 33.15           C  
ATOM   2259  CG1 VAL B 157      20.671   0.790  69.588  1.00 29.39           C  
ATOM   2260  CG2 VAL B 157      21.185  -1.623  69.168  1.00 33.45           C  
ATOM   2261  N   LEU B 158      21.193   2.270  66.326  1.00 29.78           N  
ATOM   2262  CA  LEU B 158      21.522   3.637  65.969  1.00 29.88           C  
ATOM   2263  C   LEU B 158      20.706   4.463  66.974  1.00 32.20           C  
ATOM   2264  O   LEU B 158      19.480   4.530  66.861  1.00 30.86           O  
ATOM   2265  CB  LEU B 158      21.213   3.949  64.484  1.00 32.38           C  
ATOM   2266  CG  LEU B 158      21.885   3.009  63.427  1.00 30.34           C  
ATOM   2267  CD1 LEU B 158      21.569   3.558  62.027  1.00 26.06           C  
ATOM   2268  CD2 LEU B 158      23.407   2.853  63.614  1.00 29.29           C  
ATOM   2269  N   LYS B 159      21.392   5.060  67.964  1.00 33.35           N  
ATOM   2270  CA  LYS B 159      20.734   5.819  69.039  1.00 32.75           C  
ATOM   2271  C   LYS B 159      19.993   7.037  68.547  1.00 31.95           C  
ATOM   2272  O   LYS B 159      20.507   7.797  67.737  1.00 34.22           O  
ATOM   2273  CB  LYS B 159      21.714   6.215  70.153  1.00 34.09           C  
ATOM   2274  CG  LYS B 159      22.381   5.050  70.926  1.00 39.06           C  
ATOM   2275  CD  LYS B 159      21.424   4.151  71.751  1.00 37.05           C  
ATOM   2276  CE  LYS B 159      20.751   4.859  72.928  1.00 36.52           C  
ATOM   2277  NZ  LYS B 159      19.732   3.953  73.604  1.00 29.89           N  
ATOM   2278  N   ALA B 160      18.754   7.189  69.002  1.00 31.34           N  
ATOM   2279  CA  ALA B 160      17.891   8.316  68.646  1.00 31.89           C  
ATOM   2280  C   ALA B 160      17.771   8.539  67.156  1.00 31.28           C  
ATOM   2281  O   ALA B 160      17.625   9.649  66.729  1.00 33.98           O  
ATOM   2282  CB  ALA B 160      18.379   9.615  69.347  1.00 32.01           C  
ATOM   2283  N   PHE B 161      17.770   7.470  66.365  1.00 30.95           N  
ATOM   2284  CA  PHE B 161      17.689   7.564  64.930  1.00 28.30           C  
ATOM   2285  C   PHE B 161      16.407   8.214  64.439  1.00 27.34           C  
ATOM   2286  O   PHE B 161      16.460   9.158  63.618  1.00 28.37           O  
ATOM   2287  CB  PHE B 161      17.843   6.152  64.339  1.00 29.47           C  
ATOM   2288  CG  PHE B 161      17.859   6.116  62.851  1.00 27.73           C  
ATOM   2289  CD1 PHE B 161      19.055   6.217  62.183  1.00 29.06           C  
ATOM   2290  CD2 PHE B 161      16.697   5.928  62.124  1.00 30.14           C  
ATOM   2291  CE1 PHE B 161      19.098   6.199  60.813  1.00 28.58           C  
ATOM   2292  CE2 PHE B 161      16.739   5.884  60.745  1.00 32.98           C  
ATOM   2293  CZ  PHE B 161      17.948   6.022  60.092  1.00 29.53           C  
ATOM   2294  N   TYR B 162      15.276   7.776  64.958  1.00 27.29           N  
ATOM   2295  CA  TYR B 162      13.982   8.346  64.496  1.00 32.42           C  
ATOM   2296  C   TYR B 162      13.642   9.678  65.145  1.00 32.78           C  
ATOM   2297  O   TYR B 162      13.083  10.540  64.485  1.00 35.09           O  
ATOM   2298  CB  TYR B 162      12.843   7.366  64.674  1.00 32.30           C  
ATOM   2299  CG  TYR B 162      13.023   6.054  63.976  1.00 32.93           C  
ATOM   2300  CD1 TYR B 162      12.837   5.941  62.603  1.00 33.07           C  
ATOM   2301  CD2 TYR B 162      13.317   4.905  64.687  1.00 27.35           C  
ATOM   2302  CE1 TYR B 162      12.963   4.737  61.953  1.00 34.80           C  
ATOM   2303  CE2 TYR B 162      13.427   3.664  64.043  1.00 33.08           C  
ATOM   2304  CZ  TYR B 162      13.250   3.587  62.674  1.00 29.76           C  
ATOM   2305  OH  TYR B 162      13.398   2.379  62.027  1.00 37.88           O  
ATOM   2306  N   ARG B 163      13.976   9.829  66.423  1.00 35.26           N  
ATOM   2307  CA  ARG B 163      13.772  11.048  67.213  1.00 37.38           C  
ATOM   2308  C   ARG B 163      14.422  10.791  68.555  1.00 37.36           C  
ATOM   2309  O   ARG B 163      14.842   9.663  68.827  1.00 35.72           O  
ATOM   2310  CB  ARG B 163      12.291  11.424  67.393  1.00 37.63           C  
ATOM   2311  CG  ARG B 163      11.409  10.373  68.061  1.00 42.98           C  
ATOM   2312  CD  ARG B 163       9.894  10.722  68.106  1.00 49.12           C  
ATOM   2313  NE  ARG B 163       9.385  10.980  66.757  1.00 63.75           N  
ATOM   2314  CZ  ARG B 163       9.162  10.052  65.812  1.00 71.97           C  
ATOM   2315  NH1 ARG B 163       9.373   8.749  66.028  1.00 75.80           N  
ATOM   2316  NH2 ARG B 163       8.725  10.441  64.609  1.00 73.75           N  
ATOM   2317  N   ALA B 164      14.489  11.825  69.400  1.00 36.88           N  
ATOM   2318  CA  ALA B 164      15.075  11.691  70.727  1.00 37.93           C  
ATOM   2319  C   ALA B 164      14.393  10.522  71.466  1.00 37.59           C  
ATOM   2320  O   ALA B 164      13.183  10.406  71.445  1.00 38.94           O  
ATOM   2321  CB  ALA B 164      14.929  13.025  71.516  1.00 38.22           C  
ATOM   2322  N   GLY B 165      15.178   9.621  72.052  1.00 37.64           N  
ATOM   2323  CA  GLY B 165      14.646   8.452  72.733  1.00 38.05           C  
ATOM   2324  C   GLY B 165      14.078   7.333  71.853  1.00 38.68           C  
ATOM   2325  O   GLY B 165      13.605   6.340  72.393  1.00 39.57           O  
ATOM   2326  N   ASP B 166      14.143   7.452  70.516  1.00 38.87           N  
ATOM   2327  CA  ASP B 166      13.601   6.445  69.597  1.00 35.61           C  
ATOM   2328  C   ASP B 166      14.745   5.899  68.693  1.00 33.40           C  
ATOM   2329  O   ASP B 166      15.063   6.443  67.660  1.00 33.84           O  
ATOM   2330  CB  ASP B 166      12.465   7.054  68.790  1.00 34.92           C  
ATOM   2331  CG  ASP B 166      11.659   6.023  68.046  1.00 33.52           C  
ATOM   2332  OD1 ASP B 166      12.126   4.890  67.858  1.00 32.29           O  
ATOM   2333  OD2 ASP B 166      10.522   6.335  67.653  1.00 39.32           O  
ATOM   2334  N   ASP B 167      15.329   4.794  69.134  1.00 33.64           N  
ATOM   2335  CA  ASP B 167      16.445   4.141  68.462  1.00 33.78           C  
ATOM   2336  C   ASP B 167      16.004   3.229  67.347  1.00 33.39           C  
ATOM   2337  O   ASP B 167      14.894   2.708  67.406  1.00 32.50           O  
ATOM   2338  CB  ASP B 167      17.185   3.254  69.454  1.00 32.63           C  
ATOM   2339  CG  ASP B 167      17.713   4.011  70.659  1.00 35.79           C  
ATOM   2340  OD1 ASP B 167      17.766   5.261  70.637  1.00 31.66           O  
ATOM   2341  OD2 ASP B 167      18.076   3.321  71.625  1.00 36.18           O  
ATOM   2342  N   LYS B 168      16.867   3.047  66.336  1.00 31.69           N  
ATOM   2343  CA  LYS B 168      16.579   2.117  65.252  1.00 30.48           C  
ATOM   2344  C   LYS B 168      17.379   0.903  65.594  1.00 30.84           C  
ATOM   2345  O   LYS B 168      18.571   1.053  65.870  1.00 29.45           O  
ATOM   2346  CB  LYS B 168      17.031   2.623  63.869  1.00 31.97           C  
ATOM   2347  CG  LYS B 168      16.637   1.608  62.731  1.00 33.81           C  
ATOM   2348  CD  LYS B 168      16.722   2.182  61.356  1.00 32.00           C  
ATOM   2349  CE  LYS B 168      18.070   2.415  60.880  1.00 30.43           C  
ATOM   2350  NZ  LYS B 168      18.029   2.746  59.402  1.00 32.21           N  
ATOM   2351  N   ILE B 169      16.743  -0.278  65.588  1.00 28.30           N  
ATOM   2352  CA  ILE B 169      17.427  -1.550  65.852  1.00 31.85           C  
ATOM   2353  C   ILE B 169      17.409  -2.285  64.510  1.00 29.85           C  
ATOM   2354  O   ILE B 169      16.349  -2.370  63.870  1.00 31.33           O  
ATOM   2355  CB  ILE B 169      16.783  -2.451  66.937  1.00 33.28           C  
ATOM   2356  CG1 ILE B 169      16.759  -1.785  68.321  1.00 38.56           C  
ATOM   2357  CG2 ILE B 169      17.621  -3.770  67.088  1.00 26.60           C  
ATOM   2358  CD1 ILE B 169      15.951  -0.594  68.427  1.00 49.60           C  
ATOM   2359  N   ILE B 170      18.569  -2.786  64.085  1.00 29.93           N  
ATOM   2360  CA  ILE B 170      18.697  -3.503  62.804  1.00 30.75           C  
ATOM   2361  C   ILE B 170      18.905  -4.968  63.139  1.00 30.40           C  
ATOM   2362  O   ILE B 170      19.856  -5.334  63.865  1.00 32.91           O  
ATOM   2363  CB  ILE B 170      19.837  -2.978  61.903  1.00 31.81           C  
ATOM   2364  CG1 ILE B 170      19.690  -1.462  61.643  1.00 30.22           C  
ATOM   2365  CG2 ILE B 170      19.811  -3.727  60.560  1.00 26.54           C  
ATOM   2366  CD1 ILE B 170      20.855  -0.802  60.864  1.00 31.72           C  
ATOM   2367  N   TYR B 171      17.964  -5.784  62.655  1.00 26.61           N  
ATOM   2368  CA  TYR B 171      17.916  -7.207  62.852  1.00 28.92           C  
ATOM   2369  C   TYR B 171      18.410  -7.902  61.614  1.00 29.80           C  
ATOM   2370  O   TYR B 171      18.055  -7.561  60.503  1.00 30.12           O  
ATOM   2371  CB  TYR B 171      16.472  -7.651  63.206  1.00 31.68           C  
ATOM   2372  CG  TYR B 171      16.104  -7.371  64.635  1.00 30.75           C  
ATOM   2373  CD1 TYR B 171      16.502  -8.244  65.656  1.00 34.76           C  
ATOM   2374  CD2 TYR B 171      15.349  -6.272  64.977  1.00 35.97           C  
ATOM   2375  CE1 TYR B 171      16.184  -7.997  66.972  1.00 34.49           C  
ATOM   2376  CE2 TYR B 171      15.025  -6.034  66.300  1.00 37.21           C  
ATOM   2377  CZ  TYR B 171      15.445  -6.881  67.276  1.00 32.12           C  
ATOM   2378  OH  TYR B 171      15.120  -6.599  68.567  1.00 35.08           O  
ATOM   2379  N   ARG B 172      19.213  -8.919  61.814  1.00 29.51           N  
ATOM   2380  CA  ARG B 172      19.823  -9.678  60.738  1.00 28.52           C  
ATOM   2381  C   ARG B 172      19.346 -11.145  60.699  1.00 32.12           C  
ATOM   2382  O   ARG B 172      19.308 -11.786  61.732  1.00 30.89           O  
ATOM   2383  CB  ARG B 172      21.321  -9.728  61.062  1.00 27.42           C  
ATOM   2384  CG  ARG B 172      22.232 -10.463  60.074  1.00 25.48           C  
ATOM   2385  CD  ARG B 172      23.478 -10.832  60.782  1.00 31.17           C  
ATOM   2386  NE  ARG B 172      24.419 -11.476  59.888  1.00 29.87           N  
ATOM   2387  CZ  ARG B 172      25.215 -10.833  59.051  1.00 38.66           C  
ATOM   2388  NH1 ARG B 172      25.163  -9.501  58.914  1.00 36.41           N  
ATOM   2389  NH2 ARG B 172      26.031 -11.552  58.297  1.00 33.75           N  
ATOM   2390  N   LEU B 173      18.996 -11.660  59.514  1.00 31.75           N  
ATOM   2391  CA  LEU B 173      18.683 -13.098  59.375  1.00 31.09           C  
ATOM   2392  C   LEU B 173      19.568 -13.641  58.267  1.00 31.37           C  
ATOM   2393  O   LEU B 173      19.533 -13.153  57.148  1.00 28.85           O  
ATOM   2394  CB  LEU B 173      17.231 -13.366  58.989  1.00 30.82           C  
ATOM   2395  CG  LEU B 173      16.757 -14.831  58.910  1.00 31.77           C  
ATOM   2396  CD1 LEU B 173      16.669 -15.448  60.281  1.00 34.57           C  
ATOM   2397  CD2 LEU B 173      15.396 -14.887  58.294  1.00 29.35           C  
ATOM   2398  N   GLU B 174      20.408 -14.612  58.585  1.00 33.56           N  
ATOM   2399  CA  GLU B 174      21.253 -15.268  57.580  1.00 33.79           C  
ATOM   2400  C   GLU B 174      20.333 -16.310  56.973  1.00 35.55           C  
ATOM   2401  O   GLU B 174      19.742 -17.143  57.685  1.00 33.05           O  
ATOM   2402  CB  GLU B 174      22.486 -15.887  58.203  1.00 36.25           C  
ATOM   2403  CG  GLU B 174      23.378 -14.816  58.824  1.00 37.51           C  
ATOM   2404  CD  GLU B 174      24.659 -15.303  59.415  1.00 49.80           C  
ATOM   2405  OE1 GLU B 174      25.018 -16.473  59.197  1.00 61.50           O  
ATOM   2406  OE2 GLU B 174      25.324 -14.495  60.103  1.00 53.42           O  
ATOM   2407  N   VAL B 175      20.185 -16.213  55.660  1.00 38.04           N  
ATOM   2408  CA  VAL B 175      19.296 -17.048  54.821  1.00 42.21           C  
ATOM   2409  C   VAL B 175      19.988 -18.220  54.069  1.00 46.76           C  
ATOM   2410  O   VAL B 175      19.329 -19.189  53.650  1.00 47.91           O  
ATOM   2411  CB  VAL B 175      18.481 -16.088  53.873  1.00 41.88           C  
ATOM   2412  CG1 VAL B 175      18.294 -16.630  52.529  1.00 47.23           C  
ATOM   2413  CG2 VAL B 175      17.159 -15.628  54.551  1.00 38.33           C  
ATOM   2414  N   ALA B 176      21.304 -18.153  53.933  1.00 49.20           N  
ATOM   2415  CA  ALA B 176      22.060 -19.175  53.252  1.00 53.83           C  
ATOM   2416  C   ALA B 176      23.443 -19.185  53.879  1.00 58.73           C  
ATOM   2417  O   ALA B 176      23.572 -18.842  55.068  1.00 62.01           O  
ATOM   2418  CB  ALA B 176      22.127 -18.867  51.763  1.00 52.33           C  
ATOM   2419  OXT ALA B 176      24.447 -19.513  53.235  1.00 62.51           O  
TER    2420      ALA B 176                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
