
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  164 ( 1288),  selected  164 , name 2ge3_A
# Molecule2: number of CA atoms  159 ( 1259),  selected  159 , name T0417.pdb
# PARAMETERS: 2ge3_A.T0417.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     6_A      -       -           -
LGA    T     7_A      R      26          1.839
LGA    V     8_A      Y      27          1.396
LGA    T     9_A      H      28          1.384
LGA    I    10_A      L      29          1.206
LGA    K    11_A      R      30          1.387
LGA    P    12_A      P      31          1.695
LGA    I    13_A      P      32          1.510
LGA    R    14_A      R      33          1.993
LGA    A    15_A      R      34          2.578
LGA    E    16_A      N      35          3.132
LGA    H    17_A      D      36          1.888
LGA    V    18_A      G      37          2.195
LGA    E    19_A      A      38          2.004
LGA    S    20_A      A      39          1.246
LGA    F    21_A      I      40          1.338
LGA    H    22_A      H      41          1.842
LGA    R    23_A      Q      42          1.249
LGA    A    24_A      L      43          1.185
LGA    L    25_A      V      44          2.304
LGA    D    26_A      S      45          2.750
LGA    A    27_A      E      46          2.442
LGA    V    28_A      C      47          2.366
LGA    S    29_A      -       -           -
LGA    R    30_A      -       -           -
LGA    E    31_A      P      48          2.003
LGA    R    32_A      P      49          3.123
LGA    K    33_A      -       -           -
LGA    Y    34_A      L      50          4.005
LGA    L    35_A      D      51          3.962
LGA    S    36_A      -       -           -
LGA    F    37_A      -       -           -
LGA    L    38_A      -       -           -
LGA    E    39_A      L      52          2.316
LGA    A    40_A      N      53          2.428
LGA    P    41_A      S      54          1.343
LGA    P    42_A      L      55          2.779
LGA    L    43_A      Y      56          3.712
LGA    E    44_A      -       -           -
LGA    A    45_A      A      57          3.962
LGA    V    46_A      Y      58          2.579
LGA    R    47_A      L      59          1.812
LGA    A    48_A      L      60          2.890
LGA    F    49_A      L      61          3.101
LGA    V    50_A      C      62          1.420
LGA    L    51_A      E      63          0.969
LGA    D    52_A      H      64          1.158
LGA    X    53_A      H      65          1.543
LGA    I    54_A      A      66          3.347
LGA    E    55_A      -       -           -
LGA    N    56_A      -       -           -
LGA    D    57_A      -       -           -
LGA    H    58_A      H      67          3.388
LGA    P    59_A      T      68          1.302
LGA    Q    60_A      C      69          1.038
LGA    F    61_A      V      70          0.719
LGA    V    62_A      V      71          0.272
LGA    A    63_A      A      72          0.484
LGA    I    64_A      E      73          0.702
LGA    A    65_A      S      74          2.100
LGA    -       -      P      75           -
LGA    D    66_A      G      76          2.948
LGA    G    67_A      G      77          1.226
LGA    D    68_A      R      78          1.527
LGA    V    69_A      I      79          1.260
LGA    I    70_A      D      80          0.824
LGA    G    71_A      G      81          0.863
LGA    W    72_A      F      82          0.939
LGA    C    73_A      V      83          1.432
LGA    D    74_A      S      84          2.771
LGA    I    75_A      A      85          1.890
LGA    R    76_A      Y      86          1.210
LGA    R    77_A      L      87          1.752
LGA    Q    78_A      L      88          1.624
LGA    D    79_A      P      89          2.065
LGA    R    80_A      T      90          2.780
LGA    A    81_A      -       -           -
LGA    T    82_A      -       -           -
LGA    R    83_A      R      91          1.745
LGA    A    84_A      P      92          2.387
LGA    H    85_A      D      93          2.220
LGA    C    86_A      V      94          1.912
LGA    G    87_A      L      95          2.157
LGA    T    88_A      F      96          0.928
LGA    L    89_A      V      97          0.580
LGA    G    90_A      W      98          2.670
LGA    X    91_A      Q      99          3.341
LGA    -       -      V     100           -
LGA    G    92_A      A     101          1.053
LGA    I    93_A      V     102          0.918
LGA    L    94_A      H     103          1.129
LGA    P    95_A      S     104          1.829
LGA    A    96_A      R     105          2.164
LGA    Y    97_A      A     106          1.564
LGA    R    98_A      R     107          2.822
LGA    N    99_A      G     108          4.241
LGA    K   100_A      H     109          3.138
LGA    G   101_A      R     110          1.250
LGA    L   102_A      L     111          1.376
LGA    G   103_A      G     112          1.091
LGA    A   104_A      R     113          1.352
LGA    R   105_A      A     114          0.805
LGA    L   106_A      M     115          0.843
LGA    X   107_A      L     116          1.218
LGA    R   108_A      G     117          0.928
LGA    R   109_A      H     118          0.668
LGA    T   110_A      I     119          1.360
LGA    L   111_A      L     120          1.545
LGA    D   112_A      E     121          1.612
LGA    A   113_A      R     122          1.826
LGA    A   114_A      -       -           -
LGA    H   115_A      Q     123           #
LGA    E   116_A      E     124          4.662
LGA    F   117_A      C     125          3.053
LGA    -       -      R     126           -
LGA    G   118_A      H     127          2.298
LGA    L   119_A      V     128          2.342
LGA    H   120_A      R     129          2.347
LGA    R   121_A      H     130          2.084
LGA    I   122_A      L     131          1.527
LGA    E   123_A      E     132          0.516
LGA    L   124_A      T     133          0.526
LGA    S   125_A      T     134          0.669
LGA    V   126_A      V     135          0.566
LGA    H   127_A      G     136          0.498
LGA    A   128_A      P     137          1.390
LGA    D   129_A      D     138          0.918
LGA    N   130_A      N     139          1.251
LGA    A   131_A      Q     140          1.628
LGA    R   132_A      A     141          1.531
LGA    A   133_A      S     142          0.824
LGA    I   134_A      R     143          1.347
LGA    A   135_A      R     144          1.596
LGA    L   136_A      T     145          1.391
LGA    Y   137_A      F     146          1.409
LGA    E   138_A      A     147          1.351
LGA    K   139_A      G     148          1.594
LGA    I   140_A      L     149          1.553
LGA    G   141_A      A     150          1.391
LGA    -       -      G     151           -
LGA    -       -      E     152           -
LGA    -       -      R     153           -
LGA    -       -      G     154           -
LGA    -       -      A     155           -
LGA    F   142_A      H     156           #
LGA    A   143_A      V     157          0.580
LGA    H   144_A      S     158          1.961
LGA    E   145_A      E     159          3.005
LGA    G   146_A      Q     160          1.468
LGA    R   147_A      P     161          2.827
LGA    A   148_A      F     162          3.729
LGA    R   149_A      F     163           #
LGA    D   150_A      D     164          3.262
LGA    -       -      R     165           -
LGA    -       -      Q     166           -
LGA    A   151_A      A     167          5.612
LGA    V   152_A      F     168          5.617
LGA    S   153_A      G     169           -
LGA    -       -      G     170           -
LGA    I   154_A      A     171          5.534
LGA    D   155_A      D     172          2.507
LGA    G   156_A      -       -           -
LGA    H   157_A      -       -           -
LGA    Y   158_A      H     173           #
LGA    I   159_A      D     174          2.877
LGA    D   160_A      D     175          3.261
LGA    S   161_A      E     176          2.493
LGA    L   162_A      M     177          2.376
LGA    N   163_A      L     178          1.509
LGA    X   164_A      L     179          1.328
LGA    A   165_A      R     180          1.531
LGA    I   166_A      I     181          2.108
LGA    I   167_A      G     182          2.385
LGA    -       -      P     183           -
LGA    F   168_A      F     184          1.949
LGA    G   169_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  164  159    5.0    142    2.20    18.31     72.009     6.178

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.291970 * X  +   0.838882 * Y  +   0.459380 * Z  + -44.127766
  Y_new =  -0.615147 * X  +  -0.203075 * Y  +   0.761810 * Z  +  14.992304
  Z_new =   0.732358 * X  +  -0.505012 * Y  +   0.456744 * Z  +  46.951618 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.835543    2.306050  [ DEG:   -47.8731    132.1269 ]
  Theta =  -0.821778   -2.319814  [ DEG:   -47.0844   -132.9156 ]
  Phi   =  -1.127647    2.013946  [ DEG:   -64.6094    115.3906 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ge3_A                                        
REMARK     2: T0417.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ge3_A.T0417.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  164  159   5.0  142   2.20   18.31  72.009
REMARK  ---------------------------------------------------------- 
MOLECULE 2ge3_A
HEADER    TRANSFERASE                             17-MAR-06   2GE3              
TITLE     CRYSTAL STRUCTURE OF PROBABLE ACETYLTRANSFERASE FROM                  
TITLE    2 AGROBACTERIUM TUMEFACIENS                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE ACETYLTRANSFERASE;                                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AGROBACTERIUM TUMEFACIENS;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)                                  
KEYWDS    ACETYLTRANSFERASE, AGROBACTERIUM TUMEFACIENS, STRUCTURAL              
KEYWDS   2 GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER          
KEYWDS   3 FOR STRUCTURAL GENOMICS, MCSG                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,X.XU,J.GU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK,                 
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   18-APR-06 2GE3    0                                                
JRNL        AUTH   C.CHANG,X.XU,A.SAVCHENKO,A.EDWARDS,A.JOACHIMIAK              
JRNL        TITL   CRYSTAL STRUCTURE OF PROBABLE ACETYLTRANSFERASE              
JRNL        TITL 2 FROM AGROBACTERIUM TUMEFACIENS                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.25 ANGSTROMS.                                          
DBREF  2GE3 A    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
DBREF  2GE3 B    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
DBREF  2GE3 C    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
DBREF  2GE3 D    1   170  UNP    Q8UD38   Q8UD38_AGRT5     1    170             
SEQRES   1 A  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 A  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 A  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 A  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 A  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 A  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 A  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 A  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 A  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 A  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 A  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 A  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 A  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 A  170  ASN                                                          
SEQRES   1 B  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 B  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 B  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 B  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 B  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 B  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 B  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 B  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 B  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 B  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 B  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 B  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 B  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 B  170  ASN                                                          
SEQRES   1 C  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 C  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 C  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 C  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 C  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 C  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 C  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 C  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 C  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 C  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 C  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 C  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 C  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 C  170  ASN                                                          
SEQRES   1 D  170  MSE MSE ALA LEU ASP ASP THR VAL THR ILE LYS PRO ILE          
SEQRES   2 D  170  ARG ALA GLU HIS VAL GLU SER PHE HIS ARG ALA LEU ASP          
SEQRES   3 D  170  ALA VAL SER ARG GLU ARG LYS TYR LEU SER PHE LEU GLU          
SEQRES   4 D  170  ALA PRO PRO LEU GLU ALA VAL ARG ALA PHE VAL LEU ASP          
SEQRES   5 D  170  MSE ILE GLU ASN ASP HIS PRO GLN PHE VAL ALA ILE ALA          
SEQRES   6 D  170  ASP GLY ASP VAL ILE GLY TRP CYS ASP ILE ARG ARG GLN          
SEQRES   7 D  170  ASP ARG ALA THR ARG ALA HIS CYS GLY THR LEU GLY MSE          
SEQRES   8 D  170  GLY ILE LEU PRO ALA TYR ARG ASN LYS GLY LEU GLY ALA          
SEQRES   9 D  170  ARG LEU MSE ARG ARG THR LEU ASP ALA ALA HIS GLU PHE          
SEQRES  10 D  170  GLY LEU HIS ARG ILE GLU LEU SER VAL HIS ALA ASP ASN          
SEQRES  11 D  170  ALA ARG ALA ILE ALA LEU TYR GLU LYS ILE GLY PHE ALA          
SEQRES  12 D  170  HIS GLU GLY ARG ALA ARG ASP ALA VAL SER ILE ASP GLY          
SEQRES  13 D  170  HIS TYR ILE ASP SER LEU ASN MSE ALA ILE ILE PHE GLY          
SEQRES  14 D  170  ASN                                                          
HET    MSE  A  53       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  A 164       8                                                       
HET    MSE  B  53       8                                                       
HET    MSE  B  91       8                                                       
HET    MSE  B 107       8                                                       
HET    MSE  B 164       8                                                       
HET    MSE  C  53       8                                                       
HET    MSE  C  91       8                                                       
HET    MSE  C 107       8                                                       
HET    MSE  C 164       8                                                       
HET    MSE  D  53       8                                                       
HET    MSE  D  91       8                                                       
HET    MSE  D 107       8                                                       
HET    MSE  D 164       8                                                       
HET    ACO   1301      51                                                       
HET    ACO   1302      51                                                       
HET    ACO   1303      51                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5  ACO    3(C23 H38 N7 O17 P3 S)                                       
FORMUL   8  HOH   *375(H2 O)                                                    
CRYST1   79.906   90.796  103.789  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   ASP A   6     -11.335 -20.050  60.563  1.00 59.95           N  
ATOM      2  CA  ASP A   6     -11.574 -19.357  59.271  1.00 59.85           C  
ATOM      3  C   ASP A   6     -10.230 -19.116  58.525  1.00 60.08           C  
ATOM      4  O   ASP A   6      -9.361 -18.345  59.014  1.00 60.77           O  
ATOM      5  CB  ASP A   6     -12.405 -18.050  59.495  1.00 60.73           C  
ATOM      6  N   THR A   7     -10.055 -19.799  57.367  1.00 58.80           N  
ATOM      7  CA  THR A   7      -8.729 -19.978  56.730  1.00 56.70           C  
ATOM      8  C   THR A   7      -7.994 -18.720  56.187  1.00 54.70           C  
ATOM      9  O   THR A   7      -8.578 -17.879  55.491  1.00 55.67           O  
ATOM     10  CB  THR A   7      -8.727 -21.128  55.729  1.00 57.67           C  
ATOM     11  OG1 THR A   7      -7.677 -22.047  56.070  1.00 55.75           O  
ATOM     12  CG2 THR A   7      -8.590 -20.655  54.236  1.00 60.00           C  
ATOM     13  N   VAL A   8      -6.733 -18.566  56.587  1.00 50.53           N  
ATOM     14  CA  VAL A   8      -5.832 -17.622  55.929  1.00 45.93           C  
ATOM     15  C   VAL A   8      -4.950 -18.366  54.959  1.00 43.78           C  
ATOM     16  O   VAL A   8      -4.427 -19.422  55.282  1.00 42.52           O  
ATOM     17  CB  VAL A   8      -4.972 -16.832  56.908  1.00 45.47           C  
ATOM     18  CG1 VAL A   8      -3.952 -16.019  56.180  1.00 41.76           C  
ATOM     19  CG2 VAL A   8      -5.859 -15.896  57.715  1.00 45.50           C  
ATOM     20  N   THR A   9      -4.843 -17.831  53.747  1.00 41.36           N  
ATOM     21  CA  THR A   9      -3.869 -18.315  52.758  1.00 40.09           C  
ATOM     22  C   THR A   9      -2.853 -17.273  52.431  1.00 37.93           C  
ATOM     23  O   THR A   9      -3.180 -16.075  52.321  1.00 36.02           O  
ATOM     24  CB  THR A   9      -4.568 -18.741  51.501  1.00 40.42           C  
ATOM     25  OG1 THR A   9      -5.559 -19.677  51.917  1.00 45.40           O  
ATOM     26  CG2 THR A   9      -3.615 -19.489  50.571  1.00 39.75           C  
ATOM     27  N   ILE A  10      -1.600 -17.735  52.330  1.00 37.32           N  
ATOM     28  CA  ILE A  10      -0.449 -16.882  51.992  1.00 35.83           C  
ATOM     29  C   ILE A  10      -0.040 -17.190  50.550  1.00 35.20           C  
ATOM     30  O   ILE A  10       0.134 -18.310  50.193  1.00 33.58           O  
ATOM     31  CB  ILE A  10       0.696 -17.158  52.979  1.00 36.19           C  
ATOM     32  CG1 ILE A  10       0.306 -16.639  54.368  1.00 38.19           C  
ATOM     33  CG2 ILE A  10       2.032 -16.576  52.445  1.00 36.05           C  
ATOM     34  CD1 ILE A  10       1.024 -17.241  55.435  1.00 38.97           C  
ATOM     35  N   LYS A  11       0.119 -16.186  49.713  1.00 35.14           N  
ATOM     36  CA  LYS A  11       0.488 -16.426  48.325  1.00 35.82           C  
ATOM     37  C   LYS A  11       1.294 -15.223  47.845  1.00 35.17           C  
ATOM     38  O   LYS A  11       1.203 -14.151  48.465  1.00 33.26           O  
ATOM     39  CB  LYS A  11      -0.774 -16.576  47.476  1.00 35.10           C  
ATOM     40  CG  LYS A  11      -1.714 -15.412  47.709  1.00 37.64           C  
ATOM     41  CD  LYS A  11      -3.101 -15.683  47.189  1.00 43.84           C  
ATOM     42  CE  LYS A  11      -3.694 -16.983  47.746  1.00 43.49           C  
ATOM     43  NZ  LYS A  11      -5.173 -16.818  47.963  1.00 48.99           N  
ATOM     44  N   PRO A  12       2.085 -15.399  46.750  1.00 34.65           N  
ATOM     45  CA  PRO A  12       2.766 -14.237  46.133  1.00 34.31           C  
ATOM     46  C   PRO A  12       1.741 -13.210  45.726  1.00 34.11           C  
ATOM     47  O   PRO A  12       0.603 -13.536  45.453  1.00 35.56           O  
ATOM     48  CB  PRO A  12       3.576 -14.841  44.938  1.00 34.73           C  
ATOM     49  CG  PRO A  12       3.734 -16.308  45.339  1.00 34.03           C  
ATOM     50  CD  PRO A  12       2.400 -16.662  46.063  1.00 33.52           C  
ATOM     51  N   ILE A  13       2.080 -11.948  45.825  1.00 34.38           N  
ATOM     52  CA  ILE A  13       1.131 -10.926  45.460  1.00 35.14           C  
ATOM     53  C   ILE A  13       0.930 -10.924  43.907  1.00 36.89           C  
ATOM     54  O   ILE A  13       1.890 -11.153  43.105  1.00 35.56           O  
ATOM     55  CB  ILE A  13       1.564  -9.540  45.989  1.00 34.85           C  
ATOM     56  CG1 ILE A  13       0.359  -8.569  45.987  1.00 34.34           C  
ATOM     57  CG2 ILE A  13       2.758  -9.022  45.162  1.00 29.39           C  
ATOM     58  CD1 ILE A  13       0.547  -7.222  46.881  1.00 33.33           C  
ATOM     59  N   ARG A  14      -0.325 -10.693  43.493  1.00 37.77           N  
ATOM     60  CA  ARG A  14      -0.636 -10.502  42.084  1.00 38.98           C  
ATOM     61  C   ARG A  14      -1.265  -9.117  41.866  1.00 40.12           C  
ATOM     62  O   ARG A  14      -1.728  -8.460  42.835  1.00 40.04           O  
ATOM     63  CB  ARG A  14      -1.559 -11.617  41.634  1.00 39.09           C  
ATOM     64  CG  ARG A  14      -0.923 -13.035  41.726  1.00 39.94           C  
ATOM     65  CD  ARG A  14      -1.790 -14.155  41.033  1.00 41.38           C  
ATOM     66  NE  ARG A  14      -3.188 -14.105  41.447  1.00 46.60           N  
ATOM     67  CZ  ARG A  14      -3.754 -14.807  42.439  1.00 49.28           C  
ATOM     68  NH1 ARG A  14      -3.062 -15.688  43.157  1.00 51.91           N  
ATOM     69  NH2 ARG A  14      -5.049 -14.649  42.692  1.00 46.76           N  
ATOM     70  N   ALA A  15      -1.274  -8.671  40.604  1.00 40.78           N  
ATOM     71  CA  ALA A  15      -1.868  -7.385  40.180  1.00 41.59           C  
ATOM     72  C   ALA A  15      -3.252  -7.072  40.797  1.00 42.11           C  
ATOM     73  O   ALA A  15      -3.550  -5.919  41.119  1.00 42.32           O  
ATOM     74  CB  ALA A  15      -1.958  -7.299  38.618  1.00 41.73           C  
ATOM     75  N   GLU A  16      -4.103  -8.086  40.910  1.00 41.49           N  
ATOM     76  CA  GLU A  16      -5.443  -7.914  41.456  1.00 40.70           C  
ATOM     77  C   GLU A  16      -5.484  -7.487  42.975  1.00 40.46           C  
ATOM     78  O   GLU A  16      -6.439  -6.846  43.422  1.00 39.86           O  
ATOM     79  CB  GLU A  16      -6.164  -9.225  41.265  1.00 40.73           C  
ATOM     80  CG  GLU A  16      -5.760 -10.273  42.254  1.00 45.83           C  
ATOM     81  CD  GLU A  16      -6.255 -11.637  41.849  1.00 52.19           C  
ATOM     82  OE1 GLU A  16      -5.463 -12.367  41.212  1.00 53.17           O  
ATOM     83  OE2 GLU A  16      -7.448 -11.952  42.141  1.00 54.99           O  
ATOM     84  N   HIS A  17      -4.438  -7.843  43.736  1.00 38.50           N  
ATOM     85  CA  HIS A  17      -4.312  -7.566  45.191  1.00 38.62           C  
ATOM     86  C   HIS A  17      -3.989  -6.112  45.490  1.00 37.82           C  
ATOM     87  O   HIS A  17      -4.155  -5.686  46.616  1.00 37.24           O  
ATOM     88  CB  HIS A  17      -3.198  -8.459  45.825  1.00 37.84           C  
ATOM     89  CG  HIS A  17      -3.450  -9.929  45.664  1.00 35.39           C  
ATOM     90  ND1 HIS A  17      -4.680 -10.498  45.935  1.00 37.64           N  
ATOM     91  CD2 HIS A  17      -2.668 -10.935  45.197  1.00 32.05           C  
ATOM     92  CE1 HIS A  17      -4.626 -11.802  45.704  1.00 35.32           C  
ATOM     93  NE2 HIS A  17      -3.413 -12.094  45.259  1.00 31.98           N  
ATOM     94  N   VAL A  18      -3.563  -5.343  44.476  1.00 37.91           N  
ATOM     95  CA  VAL A  18      -3.069  -3.975  44.695  1.00 39.01           C  
ATOM     96  C   VAL A  18      -3.959  -3.022  45.570  1.00 38.79           C  
ATOM     97  O   VAL A  18      -3.473  -2.386  46.536  1.00 38.05           O  
ATOM     98  CB  VAL A  18      -2.730  -3.329  43.343  1.00 39.51           C  
ATOM     99  CG1 VAL A  18      -2.634  -1.811  43.431  1.00 36.48           C  
ATOM    100  CG2 VAL A  18      -1.436  -3.929  42.802  1.00 41.48           C  
ATOM    101  N   GLU A  19      -5.236  -2.915  45.201  1.00 37.62           N  
ATOM    102  CA  GLU A  19      -6.231  -2.167  45.959  1.00 38.01           C  
ATOM    103  C   GLU A  19      -6.530  -2.656  47.408  1.00 36.89           C  
ATOM    104  O   GLU A  19      -6.492  -1.859  48.330  1.00 35.69           O  
ATOM    105  CB  GLU A  19      -7.522  -1.994  45.147  1.00 38.65           C  
ATOM    106  CG  GLU A  19      -7.354  -1.444  43.713  1.00 44.54           C  
ATOM    107  CD  GLU A  19      -6.747  -2.441  42.629  1.00 52.25           C  
ATOM    108  OE1 GLU A  19      -6.503  -3.671  42.884  1.00 54.55           O  
ATOM    109  OE2 GLU A  19      -6.511  -1.947  41.484  1.00 53.77           O  
ATOM    110  N   SER A  20      -6.875  -3.932  47.607  1.00 37.08           N  
ATOM    111  CA  SER A  20      -6.905  -4.557  48.953  1.00 36.58           C  
ATOM    112  C   SER A  20      -5.589  -4.365  49.843  1.00 36.54           C  
ATOM    113  O   SER A  20      -5.647  -4.037  51.059  1.00 36.72           O  
ATOM    114  CB  SER A  20      -7.153  -6.033  48.751  1.00 36.14           C  
ATOM    115  OG  SER A  20      -7.687  -6.590  49.919  1.00 38.14           O  
ATOM    116  N   PHE A  21      -4.439  -4.566  49.215  1.00 34.71           N  
ATOM    117  CA  PHE A  21      -3.135  -4.309  49.796  1.00 35.21           C  
ATOM    118  C   PHE A  21      -2.931  -2.852  50.216  1.00 34.75           C  
ATOM    119  O   PHE A  21      -2.426  -2.571  51.294  1.00 35.62           O  
ATOM    120  CB  PHE A  21      -2.019  -4.822  48.836  1.00 34.81           C  
ATOM    121  CG  PHE A  21      -0.636  -4.396  49.229  1.00 34.32           C  
ATOM    122  CD1 PHE A  21      -0.092  -4.744  50.495  1.00 35.60           C  
ATOM    123  CD2 PHE A  21       0.135  -3.646  48.378  1.00 36.09           C  
ATOM    124  CE1 PHE A  21       1.188  -4.295  50.914  1.00 33.40           C  
ATOM    125  CE2 PHE A  21       1.503  -3.202  48.790  1.00 36.98           C  
ATOM    126  CZ  PHE A  21       1.984  -3.526  50.058  1.00 35.87           C  
ATOM    127  N   HIS A  22      -3.380  -1.909  49.412  1.00 35.57           N  
ATOM    128  CA  HIS A  22      -3.206  -0.518  49.732  1.00 35.10           C  
ATOM    129  C   HIS A  22      -4.045  -0.140  50.927  1.00 36.25           C  
ATOM    130  O   HIS A  22      -3.598   0.699  51.728  1.00 35.61           O  
ATOM    131  CB  HIS A  22      -3.650   0.327  48.544  1.00 37.36           C  
ATOM    132  CG  HIS A  22      -3.818   1.786  48.846  1.00 36.82           C  
ATOM    133  ND1 HIS A  22      -2.748   2.655  48.947  1.00 37.16           N  
ATOM    134  CD2 HIS A  22      -4.935   2.539  49.039  1.00 39.74           C  
ATOM    135  CE1 HIS A  22      -3.199   3.880  49.170  1.00 35.66           C  
ATOM    136  NE2 HIS A  22      -4.517   3.839  49.258  1.00 36.08           N  
ATOM    137  N   ARG A  23      -5.274  -0.690  51.020  1.00 35.24           N  
ATOM    138  CA  ARG A  23      -6.113  -0.524  52.216  1.00 36.17           C  
ATOM    139  C   ARG A  23      -5.518  -1.087  53.518  1.00 35.87           C  
ATOM    140  O   ARG A  23      -5.666  -0.478  54.572  1.00 37.43           O  
ATOM    141  CB  ARG A  23      -7.496  -1.128  52.007  1.00 34.89           C  
ATOM    142  CG  ARG A  23      -8.207  -0.479  50.846  1.00 39.93           C  
ATOM    143  CD  ARG A  23      -9.687  -0.850  50.760  1.00 43.93           C  
ATOM    144  NE  ARG A  23      -9.964  -2.226  50.358  1.00 47.90           N  
ATOM    145  CZ  ARG A  23     -10.199  -2.606  49.100  1.00 50.79           C  
ATOM    146  NH1 ARG A  23     -10.145  -1.722  48.098  1.00 52.95           N  
ATOM    147  NH2 ARG A  23     -10.485  -3.868  48.834  1.00 51.86           N  
ATOM    148  N   ALA A  24      -4.916  -2.273  53.443  1.00 36.16           N  
ATOM    149  CA  ALA A  24      -4.200  -2.964  54.540  1.00 34.89           C  
ATOM    150  C   ALA A  24      -3.044  -2.100  55.029  1.00 35.26           C  
ATOM    151  O   ALA A  24      -2.902  -1.838  56.198  1.00 33.43           O  
ATOM    152  CB  ALA A  24      -3.659  -4.279  53.994  1.00 36.20           C  
ATOM    153  N   LEU A  25      -2.270  -1.603  54.076  1.00 35.86           N  
ATOM    154  CA  LEU A  25      -1.124  -0.805  54.333  1.00 38.90           C  
ATOM    155  C   LEU A  25      -1.574   0.549  54.941  1.00 38.49           C  
ATOM    156  O   LEU A  25      -0.992   1.100  55.906  1.00 38.02           O  
ATOM    157  CB  LEU A  25      -0.325  -0.684  53.017  1.00 38.25           C  
ATOM    158  CG  LEU A  25       0.929   0.147  52.910  1.00 44.31           C  
ATOM    159  CD1 LEU A  25       2.032  -0.329  53.859  1.00 47.84           C  
ATOM    160  CD2 LEU A  25       1.448   0.089  51.488  1.00 43.95           C  
ATOM    161  N   ASP A  26      -2.655   1.068  54.408  1.00 38.27           N  
ATOM    162  CA  ASP A  26      -3.176   2.318  54.909  1.00 37.15           C  
ATOM    163  C   ASP A  26      -3.754   2.208  56.346  1.00 36.28           C  
ATOM    164  O   ASP A  26      -3.496   3.084  57.192  1.00 35.02           O  
ATOM    165  CB  ASP A  26      -4.225   2.816  53.925  1.00 37.93           C  
ATOM    166  CG  ASP A  26      -4.542   4.257  54.123  1.00 42.09           C  
ATOM    167  OD1 ASP A  26      -3.602   5.104  54.150  1.00 42.35           O  
ATOM    168  OD2 ASP A  26      -5.743   4.518  54.338  1.00 47.02           O  
ATOM    169  N   ALA A  27      -4.523   1.142  56.609  1.00 36.01           N  
ATOM    170  CA  ALA A  27      -5.049   0.821  57.957  1.00 35.64           C  
ATOM    171  C   ALA A  27      -3.924   0.662  59.008  1.00 35.67           C  
ATOM    172  O   ALA A  27      -3.958   1.288  60.035  1.00 36.01           O  
ATOM    173  CB  ALA A  27      -5.920  -0.421  57.911  1.00 35.00           C  
ATOM    174  N   VAL A  28      -2.924  -0.169  58.758  1.00 35.14           N  
ATOM    175  CA  VAL A  28      -1.821  -0.356  59.698  1.00 34.17           C  
ATOM    176  C   VAL A  28      -0.934   0.906  59.878  1.00 34.62           C  
ATOM    177  O   VAL A  28      -0.476   1.211  61.021  1.00 33.92           O  
ATOM    178  CB  VAL A  28      -0.970  -1.623  59.328  1.00 33.51           C  
ATOM    179  CG1 VAL A  28       0.217  -1.785  60.197  1.00 31.53           C  
ATOM    180  CG2 VAL A  28      -1.860  -2.952  59.314  1.00 35.12           C  
ATOM    181  N   SER A  29      -0.675   1.641  58.790  1.00 36.30           N  
ATOM    182  CA  SER A  29       0.212   2.869  58.857  1.00 37.42           C  
ATOM    183  C   SER A  29      -0.464   3.923  59.735  1.00 37.69           C  
ATOM    184  O   SER A  29       0.217   4.601  60.583  1.00 37.51           O  
ATOM    185  CB  SER A  29       0.493   3.473  57.493  1.00 36.96           C  
ATOM    186  OG  SER A  29       1.024   2.480  56.638  1.00 45.16           O  
ATOM    187  N   ARG A  30      -1.774   4.019  59.560  1.00 36.32           N  
ATOM    188  CA  ARG A  30      -2.598   5.094  60.225  1.00 39.66           C  
ATOM    189  C   ARG A  30      -2.795   4.924  61.729  1.00 39.37           C  
ATOM    190  O   ARG A  30      -3.277   5.809  62.422  1.00 41.31           O  
ATOM    191  CB  ARG A  30      -3.931   5.323  59.486  1.00 38.19           C  
ATOM    192  CG  ARG A  30      -3.737   6.027  58.113  1.00 41.61           C  
ATOM    193  CD  ARG A  30      -5.072   6.384  57.400  1.00 42.06           C  
ATOM    194  NE  ARG A  30      -6.154   5.548  57.874  1.00 53.57           N  
ATOM    195  CZ  ARG A  30      -7.449   5.890  57.943  1.00 58.87           C  
ATOM    196  NH1 ARG A  30      -7.870   7.110  57.613  1.00 58.58           N  
ATOM    197  NH2 ARG A  30      -8.330   4.995  58.396  1.00 60.80           N  
ATOM    198  N   GLU A  31      -2.384   3.782  62.234  1.00 40.63           N  
ATOM    199  CA  GLU A  31      -2.328   3.524  63.648  1.00 41.50           C  
ATOM    200  C   GLU A  31      -1.217   4.310  64.241  1.00 41.50           C  
ATOM    201  O   GLU A  31      -1.230   4.531  65.444  1.00 43.37           O  
ATOM    202  CB  GLU A  31      -2.070   2.042  63.904  1.00 39.47           C  
ATOM    203  CG  GLU A  31      -3.307   1.187  63.609  1.00 43.53           C  
ATOM    204  CD  GLU A  31      -3.070  -0.359  63.813  1.00 43.79           C  
ATOM    205  OE1 GLU A  31      -2.760  -0.808  64.940  1.00 46.60           O  
ATOM    206  OE2 GLU A  31      -3.233  -1.125  62.840  1.00 49.84           O  
ATOM    207  N   ARG A  32      -0.231   4.679  63.408  1.00 40.13           N  
ATOM    208  CA  ARG A  32       0.905   5.499  63.805  1.00 40.58           C  
ATOM    209  C   ARG A  32       1.724   4.927  64.965  1.00 40.39           C  
ATOM    210  O   ARG A  32       2.279   5.683  65.742  1.00 42.32           O  
ATOM    211  CB  ARG A  32       0.496   6.957  64.113  1.00 39.10           C  
ATOM    212  CG  ARG A  32      -0.290   7.675  63.029  1.00 39.86           C  
ATOM    213  CD  ARG A  32      -0.756   9.077  63.561  1.00 41.39           C  
ATOM    214  NE  ARG A  32      -0.115  10.221  62.879  1.00 40.64           N  
ATOM    215  CZ  ARG A  32       0.611  11.137  63.473  1.00 46.98           C  
ATOM    216  NH1 ARG A  32       0.850  11.092  64.791  1.00 53.60           N  
ATOM    217  NH2 ARG A  32       1.091  12.145  62.758  1.00 51.15           N  
ATOM    218  N   LYS A  33       1.822   3.613  65.104  1.00 40.76           N  
ATOM    219  CA  LYS A  33       2.689   3.055  66.182  1.00 40.48           C  
ATOM    220  C   LYS A  33       3.798   2.144  65.730  1.00 37.42           C  
ATOM    221  O   LYS A  33       4.788   2.016  66.388  1.00 36.58           O  
ATOM    222  CB  LYS A  33       1.888   2.398  67.346  1.00 41.03           C  
ATOM    223  CG  LYS A  33       0.416   2.405  67.210  1.00 48.47           C  
ATOM    224  CD  LYS A  33      -0.265   2.314  68.581  1.00 54.88           C  
ATOM    225  CE  LYS A  33       0.176   1.069  69.383  1.00 56.88           C  
ATOM    226  NZ  LYS A  33      -1.080   0.527  70.028  1.00 61.36           N  
ATOM    227  N   TYR A  34       3.642   1.534  64.586  1.00 34.97           N  
ATOM    228  CA  TYR A  34       4.555   0.494  64.185  1.00 35.01           C  
ATOM    229  C   TYR A  34       5.374   0.812  62.945  1.00 35.47           C  
ATOM    230  O   TYR A  34       6.548   0.553  62.913  1.00 37.04           O  
ATOM    231  CB  TYR A  34       3.770  -0.789  63.970  1.00 34.73           C  
ATOM    232  CG  TYR A  34       2.730  -1.075  65.028  1.00 34.46           C  
ATOM    233  CD1 TYR A  34       1.365  -0.951  64.730  1.00 36.52           C  
ATOM    234  CD2 TYR A  34       3.096  -1.482  66.329  1.00 31.04           C  
ATOM    235  CE1 TYR A  34       0.363  -1.275  65.682  1.00 33.87           C  
ATOM    236  CE2 TYR A  34       2.127  -1.768  67.295  1.00 29.70           C  
ATOM    237  CZ  TYR A  34       0.765  -1.671  66.948  1.00 35.71           C  
ATOM    238  OH  TYR A  34      -0.222  -1.943  67.859  1.00 39.30           O  
ATOM    239  N   LEU A  35       4.763   1.356  61.909  1.00 36.52           N  
ATOM    240  CA  LEU A  35       5.449   1.536  60.619  1.00 36.83           C  
ATOM    241  C   LEU A  35       6.187   2.855  60.533  1.00 36.74           C  
ATOM    242  O   LEU A  35       5.848   3.797  61.243  1.00 36.94           O  
ATOM    243  CB  LEU A  35       4.368   1.446  59.478  1.00 35.53           C  
ATOM    244  CG  LEU A  35       3.643   0.112  59.326  1.00 36.95           C  
ATOM    245  CD1 LEU A  35       2.672   0.063  58.134  1.00 34.61           C  
ATOM    246  CD2 LEU A  35       4.627  -1.037  59.299  1.00 35.05           C  
ATOM    247  N   SER A  36       7.094   2.965  59.601  1.00 38.08           N  
ATOM    248  CA  SER A  36       7.815   4.226  59.395  1.00 42.39           C  
ATOM    249  C   SER A  36       7.136   5.240  58.471  1.00 43.59           C  
ATOM    250  O   SER A  36       7.611   6.377  58.316  1.00 44.30           O  
ATOM    251  CB  SER A  36       9.235   3.995  58.829  1.00 43.55           C  
ATOM    252  OG  SER A  36       9.177   3.714  57.432  1.00 49.53           O  
ATOM    253  N   PHE A  37       6.074   4.819  57.814  1.00 44.70           N  
ATOM    254  CA  PHE A  37       5.212   5.787  57.159  1.00 46.15           C  
ATOM    255  C   PHE A  37       3.891   5.868  57.952  1.00 44.17           C  
ATOM    256  O   PHE A  37       3.500   4.899  58.628  1.00 43.52           O  
ATOM    257  CB  PHE A  37       5.060   5.457  55.660  1.00 48.02           C  
ATOM    258  CG  PHE A  37       4.778   4.059  55.409  1.00 50.88           C  
ATOM    259  CD1 PHE A  37       5.711   3.097  55.701  1.00 56.74           C  
ATOM    260  CD2 PHE A  37       3.549   3.680  54.929  1.00 56.57           C  
ATOM    261  CE1 PHE A  37       5.440   1.787  55.494  1.00 57.30           C  
ATOM    262  CE2 PHE A  37       3.267   2.389  54.724  1.00 54.85           C  
ATOM    263  CZ  PHE A  37       4.216   1.429  54.990  1.00 55.16           C  
ATOM    264  N   LEU A  38       3.283   7.051  57.952  1.00 42.70           N  
ATOM    265  CA  LEU A  38       2.153   7.343  58.821  1.00 41.95           C  
ATOM    266  C   LEU A  38       0.842   7.203  58.015  1.00 43.00           C  
ATOM    267  O   LEU A  38      -0.270   7.251  58.558  1.00 41.66           O  
ATOM    268  CB  LEU A  38       2.299   8.717  59.462  1.00 41.26           C  
ATOM    269  CG  LEU A  38       3.544   8.912  60.380  1.00 38.87           C  
ATOM    270  CD1 LEU A  38       3.691  10.317  60.854  1.00 28.71           C  
ATOM    271  CD2 LEU A  38       3.480   7.970  61.615  1.00 39.39           C  
ATOM    272  N   GLU A  39       1.006   6.907  56.736  1.00 42.72           N  
ATOM    273  CA  GLU A  39      -0.110   6.845  55.820  1.00 44.94           C  
ATOM    274  C   GLU A  39       0.378   6.057  54.632  1.00 44.06           C  
ATOM    275  O   GLU A  39       1.568   6.180  54.289  1.00 42.90           O  
ATOM    276  CB  GLU A  39      -0.360   8.280  55.347  1.00 45.16           C  
ATOM    277  CG  GLU A  39      -1.762   8.591  55.080  1.00 50.10           C  
ATOM    278  CD  GLU A  39      -1.836   9.922  54.404  1.00 56.14           C  
ATOM    279  OE1 GLU A  39      -2.204   9.947  53.203  1.00 57.49           O  
ATOM    280  OE2 GLU A  39      -1.475  10.934  55.061  1.00 60.72           O  
ATOM    281  N   ALA A  40      -0.502   5.326  53.947  1.00 43.69           N  
ATOM    282  CA  ALA A  40      -0.020   4.654  52.727  1.00 44.31           C  
ATOM    283  C   ALA A  40       0.336   5.685  51.625  1.00 45.24           C  
ATOM    284  O   ALA A  40      -0.188   6.815  51.590  1.00 43.71           O  
ATOM    285  CB  ALA A  40      -1.000   3.590  52.200  1.00 43.30           C  
ATOM    286  N   PRO A  41       1.234   5.283  50.715  1.00 46.86           N  
ATOM    287  CA  PRO A  41       1.448   6.063  49.495  1.00 47.39           C  
ATOM    288  C   PRO A  41       0.164   6.038  48.589  1.00 48.55           C  
ATOM    289  O   PRO A  41      -0.699   5.128  48.717  1.00 48.11           O  
ATOM    290  CB  PRO A  41       2.617   5.334  48.824  1.00 48.56           C  
ATOM    291  CG  PRO A  41       3.258   4.516  49.952  1.00 48.66           C  
ATOM    292  CD  PRO A  41       2.073   4.070  50.764  1.00 46.85           C  
ATOM    293  N   PRO A  42       0.010   7.042  47.691  1.00 48.00           N  
ATOM    294  CA  PRO A  42      -1.216   7.026  46.905  1.00 47.60           C  
ATOM    295  C   PRO A  42      -1.408   5.695  46.149  1.00 46.71           C  
ATOM    296  O   PRO A  42      -0.420   5.081  45.758  1.00 45.62           O  
ATOM    297  CB  PRO A  42      -1.039   8.205  45.926  1.00 47.70           C  
ATOM    298  CG  PRO A  42       0.360   8.705  46.086  1.00 48.14           C  
ATOM    299  CD  PRO A  42       0.903   8.177  47.368  1.00 48.42           C  
ATOM    300  N   LEU A  43      -2.653   5.278  45.914  1.00 46.41           N  
ATOM    301  CA  LEU A  43      -2.888   4.003  45.235  1.00 46.34           C  
ATOM    302  C   LEU A  43      -2.023   3.742  43.998  1.00 46.35           C  
ATOM    303  O   LEU A  43      -1.487   2.640  43.842  1.00 46.08           O  
ATOM    304  CB  LEU A  43      -4.365   3.796  44.876  1.00 47.33           C  
ATOM    305  CG  LEU A  43      -4.980   2.390  44.628  1.00 47.51           C  
ATOM    306  CD1 LEU A  43      -4.149   1.425  43.830  1.00 51.77           C  
ATOM    307  CD2 LEU A  43      -5.268   1.695  45.912  1.00 50.64           C  
ATOM    308  N   GLU A  44      -1.876   4.733  43.121  1.00 46.32           N  
ATOM    309  CA  GLU A  44      -1.214   4.470  41.858  1.00 46.38           C  
ATOM    310  C   GLU A  44       0.278   4.392  42.057  1.00 45.46           C  
ATOM    311  O   GLU A  44       0.973   3.726  41.288  1.00 45.09           O  
ATOM    312  CB  GLU A  44      -1.651   5.452  40.758  1.00 47.75           C  
ATOM    313  CG  GLU A  44      -2.586   4.849  39.587  1.00 50.93           C  
ATOM    314  CD  GLU A  44      -3.801   3.990  40.049  1.00 54.77           C  
ATOM    315  OE1 GLU A  44      -4.729   4.533  40.700  1.00 56.90           O  
ATOM    316  OE2 GLU A  44      -3.841   2.772  39.732  1.00 54.21           O  
ATOM    317  N   ALA A  45       0.758   5.039  43.120  1.00 44.51           N  
ATOM    318  CA  ALA A  45       2.131   4.859  43.598  1.00 43.90           C  
ATOM    319  C   ALA A  45       2.323   3.427  44.111  1.00 44.03           C  
ATOM    320  O   ALA A  45       3.353   2.799  43.854  1.00 43.66           O  
ATOM    321  CB  ALA A  45       2.485   5.885  44.710  1.00 43.27           C  
ATOM    322  N   VAL A  46       1.331   2.904  44.840  1.00 43.75           N  
ATOM    323  CA  VAL A  46       1.451   1.547  45.325  1.00 44.01           C  
ATOM    324  C   VAL A  46       1.385   0.534  44.150  1.00 42.94           C  
ATOM    325  O   VAL A  46       2.189  -0.401  44.092  1.00 43.92           O  
ATOM    326  CB  VAL A  46       0.558   1.240  46.592  1.00 44.54           C  
ATOM    327  CG1 VAL A  46       0.654   2.348  47.604  1.00 42.98           C  
ATOM    328  CG2 VAL A  46      -0.928   1.030  46.227  1.00 48.62           C  
ATOM    329  N   ARG A  47       0.495   0.760  43.198  1.00 41.59           N  
ATOM    330  CA  ARG A  47       0.432  -0.076  42.006  1.00 41.12           C  
ATOM    331  C   ARG A  47       1.745  -0.140  41.210  1.00 41.33           C  
ATOM    332  O   ARG A  47       2.104  -1.211  40.725  1.00 41.70           O  
ATOM    333  CB  ARG A  47      -0.710   0.364  41.040  1.00 41.51           C  
ATOM    334  CG  ARG A  47      -0.931  -0.655  39.880  1.00 38.50           C  
ATOM    335  CD  ARG A  47      -2.058  -0.350  38.920  1.00 40.23           C  
ATOM    336  NE  ARG A  47      -3.162   0.285  39.614  1.00 40.59           N  
ATOM    337  CZ  ARG A  47      -4.196  -0.356  40.146  1.00 42.32           C  
ATOM    338  NH1 ARG A  47      -4.300  -1.678  40.039  1.00 44.18           N  
ATOM    339  NH2 ARG A  47      -5.132   0.334  40.783  1.00 37.76           N  
ATOM    340  N   ALA A  48       2.408   1.000  41.006  1.00 40.93           N  
ATOM    341  CA  ALA A  48       3.704   1.026  40.327  1.00 41.63           C  
ATOM    342  C   ALA A  48       4.706   0.108  41.043  1.00 42.64           C  
ATOM    343  O   ALA A  48       5.414  -0.697  40.412  1.00 43.80           O  
ATOM    344  CB  ALA A  48       4.261   2.486  40.250  1.00 40.66           C  
ATOM    345  N   PHE A  49       4.773   0.259  42.365  1.00 42.48           N  
ATOM    346  CA  PHE A  49       5.712  -0.449  43.190  1.00 42.32           C  
ATOM    347  C   PHE A  49       5.365  -1.973  43.178  1.00 41.96           C  
ATOM    348  O   PHE A  49       6.243  -2.800  43.031  1.00 41.76           O  
ATOM    349  CB  PHE A  49       5.693   0.187  44.590  1.00 42.85           C  
ATOM    350  CG  PHE A  49       6.061  -0.755  45.710  1.00 43.69           C  
ATOM    351  CD1 PHE A  49       5.089  -1.318  46.510  1.00 45.63           C  
ATOM    352  CD2 PHE A  49       7.396  -1.056  45.980  1.00 47.59           C  
ATOM    353  CE1 PHE A  49       5.420  -2.192  47.568  1.00 47.44           C  
ATOM    354  CE2 PHE A  49       7.762  -1.922  47.039  1.00 44.22           C  
ATOM    355  CZ  PHE A  49       6.766  -2.498  47.824  1.00 46.79           C  
ATOM    356  N   VAL A  50       4.089  -2.334  43.270  1.00 41.39           N  
ATOM    357  CA  VAL A  50       3.717  -3.749  43.179  1.00 41.21           C  
ATOM    358  C   VAL A  50       3.930  -4.380  41.807  1.00 41.09           C  
ATOM    359  O   VAL A  50       4.415  -5.487  41.730  1.00 40.85           O  
ATOM    360  CB  VAL A  50       2.304  -4.041  43.696  1.00 41.46           C  
ATOM    361  CG1 VAL A  50       1.949  -5.482  43.436  1.00 40.24           C  
ATOM    362  CG2 VAL A  50       2.251  -3.721  45.172  1.00 38.73           C  
ATOM    363  N   LEU A  51       3.591  -3.664  40.730  1.00 42.27           N  
ATOM    364  CA  LEU A  51       3.912  -4.116  39.351  1.00 41.64           C  
ATOM    365  C   LEU A  51       5.401  -4.366  39.163  1.00 40.54           C  
ATOM    366  O   LEU A  51       5.760  -5.390  38.657  1.00 39.82           O  
ATOM    367  CB  LEU A  51       3.324  -3.182  38.268  1.00 42.02           C  
ATOM    368  CG  LEU A  51       1.888  -3.514  37.728  1.00 43.54           C  
ATOM    369  CD1 LEU A  51       0.982  -4.460  38.589  1.00 40.93           C  
ATOM    370  CD2 LEU A  51       1.152  -2.226  37.337  1.00 40.52           C  
ATOM    371  N   ASP A  52       6.240  -3.448  39.622  1.00 41.31           N  
ATOM    372  CA  ASP A  52       7.714  -3.550  39.562  1.00 43.19           C  
ATOM    373  C   ASP A  52       8.306  -4.758  40.333  1.00 43.80           C  
ATOM    374  O   ASP A  52       9.202  -5.469  39.852  1.00 43.77           O  
ATOM    375  CB  ASP A  52       8.289  -2.257  40.163  1.00 44.27           C  
ATOM    376  CG  ASP A  52       9.787  -2.075  39.914  1.00 49.29           C  
ATOM    377  OD1 ASP A  52      10.268  -2.238  38.761  1.00 55.47           O  
ATOM    378  OD2 ASP A  52      10.498  -1.707  40.876  1.00 54.84           O  
HETATM  379  N   MSE A  53       7.833  -4.959  41.555  1.00 43.55           N  
HETATM  380  CA  MSE A  53       8.236  -6.098  42.345  1.00 44.90           C  
HETATM  381  C   MSE A  53       7.946  -7.446  41.653  1.00 43.78           C  
HETATM  382  O   MSE A  53       8.819  -8.306  41.583  1.00 42.93           O  
HETATM  383  CB  MSE A  53       7.511  -6.032  43.672  1.00 46.02           C  
HETATM  384  CG  MSE A  53       7.845  -4.734  44.390  1.00 54.60           C  
HETATM  385 SE   MSE A  53       9.342  -5.021  45.633  1.00 70.98          SE  
HETATM  386  CE  MSE A  53       8.154  -5.450  47.252  1.00 63.53           C  
ATOM    387  N   ILE A  54       6.714  -7.619  41.167  1.00 42.46           N  
ATOM    388  CA  ILE A  54       6.329  -8.803  40.448  1.00 42.54           C  
ATOM    389  C   ILE A  54       7.254  -8.987  39.219  1.00 44.52           C  
ATOM    390  O   ILE A  54       7.758 -10.069  38.970  1.00 45.34           O  
ATOM    391  CB  ILE A  54       4.848  -8.715  40.018  1.00 42.88           C  
ATOM    392  CG1 ILE A  54       3.951  -8.759  41.260  1.00 41.03           C  
ATOM    393  CG2 ILE A  54       4.484  -9.800  38.993  1.00 37.80           C  
ATOM    394  CD1 ILE A  54       2.462  -8.566  40.950  1.00 41.42           C  
ATOM    395  N   GLU A  55       7.510  -7.909  38.497  1.00 45.83           N  
ATOM    396  CA  GLU A  55       8.177  -7.995  37.213  1.00 47.76           C  
ATOM    397  C   GLU A  55       9.642  -8.393  37.393  1.00 47.56           C  
ATOM    398  O   GLU A  55      10.169  -9.250  36.654  1.00 47.07           O  
ATOM    399  CB  GLU A  55       7.973  -6.693  36.411  1.00 47.84           C  
ATOM    400  CG  GLU A  55       6.703  -6.646  35.424  1.00 52.30           C  
ATOM    401  CD  GLU A  55       5.342  -7.369  35.857  1.00 56.61           C  
ATOM    402  OE1 GLU A  55       5.123  -8.488  35.286  1.00 55.38           O  
ATOM    403  OE2 GLU A  55       4.481  -6.825  36.672  1.00 51.88           O  
ATOM    404  N   ASN A  56      10.248  -7.811  38.423  1.00 47.91           N  
ATOM    405  CA  ASN A  56      11.625  -8.070  38.832  1.00 48.92           C  
ATOM    406  C   ASN A  56      11.810  -9.147  39.895  1.00 49.68           C  
ATOM    407  O   ASN A  56      12.894  -9.273  40.491  1.00 49.95           O  
ATOM    408  CB  ASN A  56      12.245  -6.778  39.304  1.00 49.08           C  
ATOM    409  CG  ASN A  56      12.158  -5.721  38.254  1.00 50.61           C  
ATOM    410  OD1 ASN A  56      12.353  -6.010  37.063  1.00 51.34           O  
ATOM    411  ND2 ASN A  56      11.801  -4.518  38.655  1.00 51.16           N  
ATOM    412  N   ASP A  57      10.731  -9.904  40.117  1.00 49.67           N  
ATOM    413  CA  ASP A  57      10.753 -11.139  40.865  1.00 48.99           C  
ATOM    414  C   ASP A  57      11.112 -11.010  42.378  1.00 48.10           C  
ATOM    415  O   ASP A  57      11.519 -12.015  42.988  1.00 46.64           O  
ATOM    416  CB  ASP A  57      11.640 -12.158  40.115  1.00 50.50           C  
ATOM    417  CG  ASP A  57      11.294 -13.598  40.462  1.00 54.48           C  
ATOM    418  OD1 ASP A  57      10.090 -13.955  40.388  1.00 57.51           O  
ATOM    419  OD2 ASP A  57      12.219 -14.379  40.831  1.00 58.40           O  
ATOM    420  N   HIS A  58      10.926  -9.802  42.959  1.00 46.59           N  
ATOM    421  CA  HIS A  58      11.221  -9.503  44.400  1.00 45.63           C  
ATOM    422  C   HIS A  58      10.122 -10.000  45.377  1.00 42.97           C  
ATOM    423  O   HIS A  58       8.918  -9.773  45.109  1.00 42.71           O  
ATOM    424  CB  HIS A  58      11.426  -8.021  44.623  1.00 45.94           C  
ATOM    425  CG  HIS A  58      12.558  -7.451  43.836  1.00 49.45           C  
ATOM    426  ND1 HIS A  58      12.733  -6.098  43.661  1.00 53.55           N  
ATOM    427  CD2 HIS A  58      13.561  -8.055  43.153  1.00 51.87           C  
ATOM    428  CE1 HIS A  58      13.798  -5.887  42.910  1.00 54.90           C  
ATOM    429  NE2 HIS A  58      14.319  -7.063  42.589  1.00 54.96           N  
ATOM    430  N   PRO A  59      10.533 -10.727  46.454  1.00 39.08           N  
ATOM    431  CA  PRO A  59       9.598 -11.528  47.294  1.00 36.90           C  
ATOM    432  C   PRO A  59       8.551 -10.624  47.943  1.00 36.35           C  
ATOM    433  O   PRO A  59       8.914  -9.603  48.533  1.00 35.33           O  
ATOM    434  CB  PRO A  59      10.502 -12.169  48.352  1.00 35.49           C  
ATOM    435  CG  PRO A  59      11.902 -11.936  47.904  1.00 37.35           C  
ATOM    436  CD  PRO A  59      11.941 -10.852  46.881  1.00 38.15           C  
ATOM    437  N   GLN A  60       7.277 -10.918  47.699  1.00 33.67           N  
ATOM    438  CA  GLN A  60       6.235 -10.125  48.217  1.00 34.34           C  
ATOM    439  C   GLN A  60       5.003 -10.997  48.369  1.00 33.08           C  
ATOM    440  O   GLN A  60       4.467 -11.494  47.398  1.00 31.66           O  
ATOM    441  CB  GLN A  60       5.957  -8.908  47.343  1.00 34.80           C  
ATOM    442  CG  GLN A  60       4.828  -8.001  47.882  1.00 36.51           C  
ATOM    443  CD  GLN A  60       4.781  -6.669  47.071  1.00 39.99           C  
ATOM    444  OE1 GLN A  60       4.982  -6.659  45.815  1.00 45.14           O  
ATOM    445  NE2 GLN A  60       4.607  -5.547  47.797  1.00 40.82           N  
ATOM    446  N   PHE A  61       4.576 -11.194  49.611  1.00 32.59           N  
ATOM    447  CA  PHE A  61       3.528 -12.163  49.904  1.00 32.32           C  
ATOM    448  C   PHE A  61       2.374 -11.487  50.603  1.00 33.67           C  
ATOM    449  O   PHE A  61       2.574 -10.549  51.387  1.00 32.97           O  
ATOM    450  CB  PHE A  61       4.121 -13.291  50.790  1.00 32.22           C  
ATOM    451  CG  PHE A  61       5.008 -14.232  50.026  1.00 31.03           C  
ATOM    452  CD1 PHE A  61       6.322 -13.875  49.677  1.00 27.91           C  
ATOM    453  CD2 PHE A  61       4.495 -15.431  49.561  1.00 30.19           C  
ATOM    454  CE1 PHE A  61       7.108 -14.748  48.838  1.00 29.42           C  
ATOM    455  CE2 PHE A  61       5.260 -16.277  48.774  1.00 28.29           C  
ATOM    456  CZ  PHE A  61       6.559 -15.932  48.409  1.00 26.50           C  
ATOM    457  N   VAL A  62       1.152 -11.987  50.346  1.00 34.63           N  
ATOM    458  CA  VAL A  62      -0.045 -11.427  51.005  1.00 33.01           C  
ATOM    459  C   VAL A  62      -0.737 -12.507  51.787  1.00 32.93           C  
ATOM    460  O   VAL A  62      -0.657 -13.664  51.401  1.00 31.37           O  
ATOM    461  CB  VAL A  62      -0.965 -10.675  50.052  1.00 32.70           C  
ATOM    462  CG1 VAL A  62      -0.296  -9.360  49.747  1.00 32.52           C  
ATOM    463  CG2 VAL A  62      -1.341 -11.575  48.782  1.00 28.45           C  
ATOM    464  N   ALA A  63      -1.334 -12.141  52.921  1.00 31.60           N  
ATOM    465  CA  ALA A  63      -2.221 -13.095  53.557  1.00 30.72           C  
ATOM    466  C   ALA A  63      -3.632 -12.696  53.230  1.00 31.44           C  
ATOM    467  O   ALA A  63      -4.041 -11.570  53.469  1.00 32.01           O  
ATOM    468  CB  ALA A  63      -1.989 -13.167  55.036  1.00 29.27           C  
ATOM    469  N   ILE A  64      -4.388 -13.678  52.756  1.00 33.45           N  
ATOM    470  CA  ILE A  64      -5.706 -13.478  52.226  1.00 34.95           C  
ATOM    471  C   ILE A  64      -6.778 -14.176  53.104  1.00 36.59           C  
ATOM    472  O   ILE A  64      -6.675 -15.418  53.395  1.00 35.09           O  
ATOM    473  CB  ILE A  64      -5.783 -13.984  50.742  1.00 35.68           C  
ATOM    474  CG1 ILE A  64      -5.380 -12.829  49.852  1.00 35.55           C  
ATOM    475  CG2 ILE A  64      -7.247 -14.289  50.321  1.00 35.96           C  
ATOM    476  CD1 ILE A  64      -4.210 -13.001  49.422  1.00 37.62           C  
ATOM    477  N   ALA A  65      -7.751 -13.391  53.551  1.00 35.26           N  
ATOM    478  CA  ALA A  65      -8.877 -13.973  54.289  1.00 37.01           C  
ATOM    479  C   ALA A  65     -10.209 -13.416  53.747  1.00 37.76           C  
ATOM    480  O   ALA A  65     -10.440 -12.189  53.688  1.00 36.52           O  
ATOM    481  CB  ALA A  65      -8.760 -13.743  55.846  1.00 34.74           C  
ATOM    482  N   ASP A  66     -11.057 -14.342  53.310  1.00 40.74           N  
ATOM    483  CA  ASP A  66     -12.346 -13.995  52.641  1.00 42.25           C  
ATOM    484  C   ASP A  66     -12.137 -12.985  51.512  1.00 41.24           C  
ATOM    485  O   ASP A  66     -12.757 -11.928  51.463  1.00 40.26           O  
ATOM    486  CB  ASP A  66     -13.357 -13.495  53.672  1.00 43.58           C  
ATOM    487  CG  ASP A  66     -13.824 -14.633  54.644  1.00 50.45           C  
ATOM    488  OD1 ASP A  66     -14.309 -15.721  54.166  1.00 59.17           O  
ATOM    489  OD2 ASP A  66     -13.728 -14.422  55.882  1.00 56.66           O  
ATOM    490  N   GLY A  67     -11.223 -13.324  50.619  1.00 41.23           N  
ATOM    491  CA  GLY A  67     -10.866 -12.428  49.536  1.00 40.90           C  
ATOM    492  C   GLY A  67     -10.071 -11.164  49.885  1.00 40.40           C  
ATOM    493  O   GLY A  67      -9.491 -10.577  48.977  1.00 41.97           O  
ATOM    494  N   ASP A  68     -10.038 -10.712  51.138  1.00 38.63           N  
ATOM    495  CA  ASP A  68      -9.317  -9.448  51.479  1.00 38.82           C  
ATOM    496  C   ASP A  68      -7.828  -9.762  51.801  1.00 36.17           C  
ATOM    497  O   ASP A  68      -7.561 -10.842  52.301  1.00 33.58           O  
ATOM    498  CB  ASP A  68      -9.972  -8.757  52.711  1.00 39.94           C  
ATOM    499  CG  ASP A  68     -11.466  -8.270  52.465  1.00 47.21           C  
ATOM    500  OD1 ASP A  68     -11.657  -7.255  51.735  1.00 52.15           O  
ATOM    501  OD2 ASP A  68     -12.455  -8.836  53.055  1.00 51.37           O  
ATOM    502  N   VAL A  69      -6.901  -8.813  51.526  1.00 36.06           N  
ATOM    503  CA  VAL A  69      -5.516  -8.797  52.043  1.00 34.50           C  
ATOM    504  C   VAL A  69      -5.600  -8.362  53.511  1.00 34.06           C  
ATOM    505  O   VAL A  69      -6.050  -7.254  53.818  1.00 32.83           O  
ATOM    506  CB  VAL A  69      -4.479  -7.885  51.219  1.00 34.86           C  
ATOM    507  CG1 VAL A  69      -3.095  -7.711  51.982  1.00 36.21           C  
ATOM    508  CG2 VAL A  69      -4.219  -8.428  49.763  1.00 34.12           C  
ATOM    509  N   ILE A  70      -5.223  -9.270  54.422  1.00 33.18           N  
ATOM    510  CA  ILE A  70      -5.216  -8.943  55.853  1.00 31.67           C  
ATOM    511  C   ILE A  70      -3.773  -8.836  56.419  1.00 29.66           C  
ATOM    512  O   ILE A  70      -3.565  -8.514  57.582  1.00 28.39           O  
ATOM    513  CB  ILE A  70      -6.130  -9.921  56.659  1.00 33.39           C  
ATOM    514  CG1 ILE A  70      -5.830 -11.353  56.291  1.00 34.81           C  
ATOM    515  CG2 ILE A  70      -7.608  -9.758  56.327  1.00 32.29           C  
ATOM    516  CD1 ILE A  70      -5.259 -12.132  57.393  1.00 36.13           C  
ATOM    517  N   GLY A  71      -2.780  -8.987  55.542  1.00 28.99           N  
ATOM    518  CA  GLY A  71      -1.413  -8.978  55.962  1.00 29.68           C  
ATOM    519  C   GLY A  71      -0.509  -9.111  54.762  1.00 29.71           C  
ATOM    520  O   GLY A  71      -0.959  -9.545  53.750  1.00 28.75           O  
ATOM    521  N   TRP A  72       0.766  -8.711  54.921  1.00 28.22           N  
ATOM    522  CA  TRP A  72       1.757  -8.742  53.846  1.00 28.61           C  
ATOM    523  C   TRP A  72       3.152  -8.819  54.458  1.00 27.64           C  
ATOM    524  O   TRP A  72       3.360  -8.492  55.595  1.00 25.66           O  
ATOM    525  CB  TRP A  72       1.660  -7.514  52.966  1.00 27.30           C  
ATOM    526  CG  TRP A  72       2.220  -6.283  53.629  1.00 29.85           C  
ATOM    527  CD1 TRP A  72       3.497  -5.780  53.495  1.00 26.98           C  
ATOM    528  CD2 TRP A  72       1.527  -5.412  54.527  1.00 25.51           C  
ATOM    529  NE1 TRP A  72       3.603  -4.622  54.200  1.00 28.90           N  
ATOM    530  CE2 TRP A  72       2.413  -4.378  54.852  1.00 29.58           C  
ATOM    531  CE3 TRP A  72       0.196  -5.390  55.050  1.00 29.73           C  
ATOM    532  CZ2 TRP A  72       2.065  -3.318  55.746  1.00 29.96           C  
ATOM    533  CZ3 TRP A  72      -0.164  -4.297  55.931  1.00 29.09           C  
ATOM    534  CH2 TRP A  72       0.767  -3.318  56.264  1.00 29.05           C  
ATOM    535  N   CYS A  73       4.095  -9.284  53.667  1.00 29.94           N  
ATOM    536  CA  CYS A  73       5.459  -9.277  54.062  1.00 30.38           C  
ATOM    537  C   CYS A  73       6.185  -9.099  52.746  1.00 30.82           C  
ATOM    538  O   CYS A  73       5.910  -9.810  51.777  1.00 32.14           O  
ATOM    539  CB  CYS A  73       5.798 -10.605  54.803  1.00 28.93           C  
ATOM    540  SG  CYS A  73       7.515 -10.796  55.332  1.00 31.57           S  
ATOM    541  N   ASP A  74       7.173  -8.225  52.716  1.00 30.63           N  
ATOM    542  CA  ASP A  74       7.892  -8.054  51.485  1.00 32.57           C  
ATOM    543  C   ASP A  74       9.384  -7.723  51.655  1.00 33.06           C  
ATOM    544  O   ASP A  74       9.837  -7.271  52.715  1.00 30.72           O  
ATOM    545  CB  ASP A  74       7.176  -7.131  50.493  1.00 32.55           C  
ATOM    546  CG  ASP A  74       6.911  -5.709  51.024  1.00 38.55           C  
ATOM    547  OD1 ASP A  74       7.712  -5.155  51.835  1.00 44.54           O  
ATOM    548  OD2 ASP A  74       5.884  -5.107  50.557  1.00 47.68           O  
ATOM    549  N   ILE A  75      10.155  -8.055  50.624  1.00 33.39           N  
ATOM    550  CA  ILE A  75      11.603  -7.815  50.700  1.00 34.43           C  
ATOM    551  C   ILE A  75      11.992  -6.944  49.485  1.00 36.67           C  
ATOM    552  O   ILE A  75      11.793  -7.373  48.339  1.00 37.07           O  
ATOM    553  CB  ILE A  75      12.460  -9.133  50.903  1.00 34.13           C  
ATOM    554  CG1 ILE A  75      12.121  -9.798  52.243  1.00 32.93           C  
ATOM    555  CG2 ILE A  75      14.010  -8.851  50.863  1.00 33.29           C  
ATOM    556  CD1 ILE A  75      12.790 -11.178  52.563  1.00 30.26           C  
ATOM    557  N   ARG A  76      12.438  -5.705  49.735  1.00 38.37           N  
ATOM    558  CA  ARG A  76      13.001  -4.863  48.671  1.00 41.76           C  
ATOM    559  C   ARG A  76      14.534  -5.013  48.553  1.00 40.73           C  
ATOM    560  O   ARG A  76      15.299  -4.694  49.494  1.00 37.54           O  
ATOM    561  CB  ARG A  76      12.557  -3.400  48.797  1.00 40.99           C  
ATOM    562  CG  ARG A  76      13.133  -2.619  50.046  1.00 49.58           C  
ATOM    563  CD  ARG A  76      12.576  -1.153  50.168  1.00 50.70           C  
ATOM    564  NE  ARG A  76      11.142  -1.279  49.855  1.00 64.41           N  
ATOM    565  CZ  ARG A  76      10.220  -1.546  50.766  1.00 69.33           C  
ATOM    566  NH1 ARG A  76      10.599  -1.648  52.057  1.00 71.20           N  
ATOM    567  NH2 ARG A  76       8.942  -1.703  50.386  1.00 70.25           N  
ATOM    568  N   ARG A  77      14.958  -5.535  47.390  1.00 41.80           N  
ATOM    569  CA  ARG A  77      16.364  -5.536  46.941  1.00 42.83           C  
ATOM    570  C   ARG A  77      17.025  -4.133  46.884  1.00 43.72           C  
ATOM    571  O   ARG A  77      16.458  -3.219  46.305  1.00 41.59           O  
ATOM    572  CB  ARG A  77      16.505  -6.215  45.589  1.00 42.67           C  
ATOM    573  CG  ARG A  77      17.900  -6.807  45.389  1.00 44.81           C  
ATOM    574  CD  ARG A  77      18.033  -7.553  44.061  1.00 45.32           C  
ATOM    575  NE  ARG A  77      19.369  -8.080  43.868  1.00 48.48           N  
ATOM    576  CZ  ARG A  77      19.862  -8.451  42.676  1.00 55.32           C  
ATOM    577  NH1 ARG A  77      19.124  -8.327  41.568  1.00 55.37           N  
ATOM    578  NH2 ARG A  77      21.098  -8.952  42.563  1.00 53.81           N  
ATOM    579  N   GLN A  78      18.204  -3.997  47.540  1.00 44.75           N  
ATOM    580  CA  GLN A  78      19.047  -2.783  47.488  1.00 46.10           C  
ATOM    581  C   GLN A  78      19.469  -2.540  46.026  1.00 47.03           C  
ATOM    582  O   GLN A  78      19.670  -3.470  45.251  1.00 46.18           O  
ATOM    583  CB  GLN A  78      20.297  -2.884  48.378  1.00 45.06           C  
ATOM    584  CG  GLN A  78      20.080  -2.736  49.891  1.00 47.57           C  
ATOM    585  CD  GLN A  78      19.699  -1.298  50.374  1.00 53.43           C  
ATOM    586  OE1 GLN A  78      18.693  -1.135  51.077  1.00 52.92           O  
ATOM    587  NE2 GLN A  78      20.497  -0.252  49.988  1.00 56.05           N  
ATOM    588  N   ASP A  79      19.571  -1.269  45.658  1.00 49.60           N  
ATOM    589  CA  ASP A  79      19.846  -0.914  44.271  1.00 51.78           C  
ATOM    590  C   ASP A  79      21.298  -0.954  43.938  1.00 50.38           C  
ATOM    591  O   ASP A  79      21.683  -1.572  42.941  1.00 49.77           O  
ATOM    592  CB  ASP A  79      19.271   0.455  43.906  1.00 54.17           C  
ATOM    593  CG  ASP A  79      18.033   0.326  43.011  1.00 60.74           C  
ATOM    594  OD1 ASP A  79      16.970  -0.188  43.503  1.00 64.74           O  
ATOM    595  OD2 ASP A  79      18.149   0.718  41.806  1.00 68.55           O  
ATOM    596  N   ARG A  80      22.118  -0.321  44.770  1.00 48.99           N  
ATOM    597  CA  ARG A  80      23.506  -0.249  44.373  1.00 48.39           C  
ATOM    598  C   ARG A  80      24.195  -1.616  44.236  1.00 46.16           C  
ATOM    599  O   ARG A  80      23.874  -2.577  44.924  1.00 44.80           O  
ATOM    600  CB  ARG A  80      24.313   0.791  45.151  1.00 49.73           C  
ATOM    601  CG  ARG A  80      24.131   0.792  46.626  1.00 53.92           C  
ATOM    602  CD  ARG A  80      25.096   1.780  47.236  1.00 62.32           C  
ATOM    603  NE  ARG A  80      25.227   2.999  46.427  1.00 68.43           N  
ATOM    604  CZ  ARG A  80      24.660   4.183  46.720  1.00 71.54           C  
ATOM    605  NH1 ARG A  80      23.929   4.340  47.819  1.00 71.45           N  
ATOM    606  NH2 ARG A  80      24.837   5.233  45.919  1.00 72.89           N  
ATOM    607  N   ALA A  81      25.137  -1.683  43.298  1.00 43.32           N  
ATOM    608  CA  ALA A  81      25.776  -2.924  42.968  1.00 41.31           C  
ATOM    609  C   ALA A  81      26.500  -3.546  44.173  1.00 40.20           C  
ATOM    610  O   ALA A  81      26.504  -4.776  44.271  1.00 40.64           O  
ATOM    611  CB  ALA A  81      26.750  -2.726  41.821  1.00 41.04           C  
ATOM    612  N   THR A  82      27.110  -2.736  45.057  1.00 36.84           N  
ATOM    613  CA  THR A  82      27.767  -3.278  46.218  1.00 36.86           C  
ATOM    614  C   THR A  82      26.822  -3.792  47.336  1.00 36.94           C  
ATOM    615  O   THR A  82      27.323  -4.395  48.290  1.00 35.85           O  
ATOM    616  CB  THR A  82      28.707  -2.287  46.926  1.00 37.52           C  
ATOM    617  OG1 THR A  82      27.938  -1.253  47.528  1.00 38.01           O  
ATOM    618  CG2 THR A  82      29.760  -1.721  45.974  1.00 40.40           C  
ATOM    619  N   ARG A  83      25.507  -3.559  47.223  1.00 34.91           N  
ATOM    620  CA  ARG A  83      24.562  -3.830  48.295  1.00 34.68           C  
ATOM    621  C   ARG A  83      23.471  -4.717  47.719  1.00 34.97           C  
ATOM    622  O   ARG A  83      22.567  -5.105  48.430  1.00 35.76           O  
ATOM    623  CB  ARG A  83      23.926  -2.520  48.808  1.00 34.57           C  
ATOM    624  CG  ARG A  83      24.893  -1.512  49.409  1.00 38.09           C  
ATOM    625  CD  ARG A  83      25.071  -1.642  50.977  1.00 41.84           C  
ATOM    626  NE  ARG A  83      23.784  -1.374  51.641  1.00 45.32           N  
ATOM    627  CZ  ARG A  83      23.097  -2.209  52.449  1.00 45.06           C  
ATOM    628  NH1 ARG A  83      23.574  -3.427  52.808  1.00 35.89           N  
ATOM    629  NH2 ARG A  83      21.887  -1.810  52.887  1.00 41.44           N  
ATOM    630  N   ALA A  84      23.544  -5.044  46.426  1.00 34.25           N  
ATOM    631  CA  ALA A  84      22.502  -5.890  45.758  1.00 34.42           C  
ATOM    632  C   ALA A  84      22.269  -7.301  46.244  1.00 33.36           C  
ATOM    633  O   ALA A  84      21.243  -7.828  45.876  1.00 35.69           O  
ATOM    634  CB  ALA A  84      22.675  -5.921  44.192  1.00 34.53           C  
ATOM    635  N   HIS A  85      23.178  -7.913  47.041  1.00 32.51           N  
ATOM    636  CA  HIS A  85      22.942  -9.168  47.752  1.00 32.02           C  
ATOM    637  C   HIS A  85      22.068  -8.938  49.048  1.00 33.19           C  
ATOM    638  O   HIS A  85      21.734  -9.897  49.730  1.00 33.10           O  
ATOM    639  CB  HIS A  85      24.296  -9.771  48.198  1.00 32.29           C  
ATOM    640  CG  HIS A  85      25.065  -8.858  49.130  1.00 33.63           C  
ATOM    641  ND1 HIS A  85      25.446  -7.589  48.749  1.00 30.89           N  
ATOM    642  CD2 HIS A  85      25.408  -8.973  50.443  1.00 33.08           C  
ATOM    643  CE1 HIS A  85      26.075  -6.987  49.752  1.00 30.46           C  
ATOM    644  NE2 HIS A  85      26.036  -7.789  50.804  1.00 34.77           N  
ATOM    645  N   CYS A  86      21.633  -7.709  49.294  1.00 35.09           N  
ATOM    646  CA  CYS A  86      20.819  -7.327  50.451  1.00 35.94           C  
ATOM    647  C   CYS A  86      19.382  -6.913  50.158  1.00 34.71           C  
ATOM    648  O   CYS A  86      19.106  -6.254  49.135  1.00 35.97           O  
ATOM    649  CB  CYS A  86      21.479  -6.152  51.116  1.00 36.85           C  
ATOM    650  SG  CYS A  86      20.973  -5.844  52.827  1.00 45.09           S  
ATOM    651  N   GLY A  87      18.449  -7.344  51.017  1.00 32.58           N  
ATOM    652  CA  GLY A  87      17.044  -6.922  50.885  1.00 29.58           C  
ATOM    653  C   GLY A  87      16.542  -6.334  52.222  1.00 29.91           C  
ATOM    654  O   GLY A  87      17.060  -6.717  53.260  1.00 30.72           O  
ATOM    655  N   THR A  88      15.596  -5.383  52.180  1.00 29.13           N  
ATOM    656  CA  THR A  88      14.966  -4.792  53.356  1.00 30.24           C  
ATOM    657  C   THR A  88      13.564  -5.353  53.510  1.00 29.14           C  
ATOM    658  O   THR A  88      12.783  -5.317  52.568  1.00 29.18           O  
ATOM    659  CB  THR A  88      14.853  -3.303  53.225  1.00 30.73           C  
ATOM    660  OG1 THR A  88      16.139  -2.801  53.008  1.00 32.01           O  
ATOM    661  CG2 THR A  88      14.299  -2.611  54.545  1.00 32.17           C  
ATOM    662  N   LEU A  89      13.285  -5.898  54.670  1.00 28.21           N  
ATOM    663  CA  LEU A  89      11.982  -6.473  54.982  1.00 29.42           C  
ATOM    664  C   LEU A  89      10.968  -5.440  55.585  1.00 30.35           C  
ATOM    665  O   LEU A  89      11.348  -4.616  56.385  1.00 30.79           O  
ATOM    666  CB  LEU A  89      12.144  -7.721  55.892  1.00 30.72           C  
ATOM    667  CG  LEU A  89      10.880  -8.614  56.170  1.00 29.89           C  
ATOM    668  CD1 LEU A  89      11.282 -10.031  56.267  1.00 33.82           C  
ATOM    669  CD2 LEU A  89      10.287  -8.171  57.437  1.00 29.28           C  
ATOM    670  N   GLY A  90       9.707  -5.439  55.109  1.00 31.03           N  
ATOM    671  CA  GLY A  90       8.579  -4.803  55.848  1.00 29.46           C  
ATOM    672  C   GLY A  90       7.359  -5.745  55.890  1.00 28.26           C  
ATOM    673  O   GLY A  90       7.226  -6.644  55.084  1.00 27.66           O  
HETATM  674  N   MSE A  91       6.499  -5.566  56.869  1.00 26.39           N  
HETATM  675  CA  MSE A  91       5.352  -6.415  57.027  1.00 30.65           C  
HETATM  676  C   MSE A  91       4.377  -5.795  57.986  1.00 27.82           C  
HETATM  677  O   MSE A  91       4.769  -4.951  58.813  1.00 26.40           O  
HETATM  678  CB  MSE A  91       5.763  -7.746  57.597  1.00 28.62           C  
HETATM  679  CG  MSE A  91       6.324  -7.617  58.960  1.00 30.62           C  
HETATM  680 SE   MSE A  91       6.861  -9.527  59.493  1.00 44.03          SE  
HETATM  681  CE  MSE A  91       5.150 -10.563  58.874  1.00 25.54           C  
ATOM    682  N   GLY A  92       3.135  -6.267  57.896  1.00 24.61           N  
ATOM    683  CA  GLY A  92       2.045  -5.715  58.694  1.00 24.56           C  
ATOM    684  C   GLY A  92       0.879  -6.663  58.651  1.00 25.13           C  
ATOM    685  O   GLY A  92       0.679  -7.410  57.676  1.00 25.72           O  
ATOM    686  N   ILE A  93       0.062  -6.627  59.685  1.00 25.21           N  
ATOM    687  CA  ILE A  93      -1.101  -7.499  59.770  1.00 27.17           C  
ATOM    688  C   ILE A  93      -2.200  -6.659  60.434  1.00 27.30           C  
ATOM    689  O   ILE A  93      -1.911  -5.951  61.401  1.00 27.23           O  
ATOM    690  CB  ILE A  93      -0.746  -8.806  60.615  1.00 25.94           C  
ATOM    691  CG1 ILE A  93       0.269  -9.684  59.871  1.00 32.61           C  
ATOM    692  CG2 ILE A  93      -1.988  -9.651  60.958  1.00 28.12           C  
ATOM    693  CD1 ILE A  93       0.609 -10.971  60.560  1.00 28.96           C  
ATOM    694  N   LEU A  94      -3.437  -6.780  59.930  1.00 28.01           N  
ATOM    695  CA  LEU A  94      -4.601  -6.164  60.492  1.00 27.78           C  
ATOM    696  C   LEU A  94      -4.754  -6.620  61.954  1.00 27.98           C  
ATOM    697  O   LEU A  94      -4.461  -7.759  62.267  1.00 28.22           O  
ATOM    698  CB  LEU A  94      -5.867  -6.514  59.658  1.00 26.53           C  
ATOM    699  CG  LEU A  94      -5.927  -5.914  58.244  1.00 27.34           C  
ATOM    700  CD1 LEU A  94      -7.319  -6.093  57.655  1.00 26.51           C  
ATOM    701  CD2 LEU A  94      -5.477  -4.429  58.263  1.00 30.66           C  
ATOM    702  N   PRO A  95      -5.175  -5.708  62.849  1.00 29.34           N  
ATOM    703  CA  PRO A  95      -5.233  -5.984  64.293  1.00 29.02           C  
ATOM    704  C   PRO A  95      -5.943  -7.285  64.691  1.00 30.74           C  
ATOM    705  O   PRO A  95      -5.406  -8.017  65.572  1.00 31.14           O  
ATOM    706  CB  PRO A  95      -5.947  -4.755  64.867  1.00 29.73           C  
ATOM    707  CG  PRO A  95      -5.727  -3.635  63.888  1.00 29.63           C  
ATOM    708  CD  PRO A  95      -5.626  -4.334  62.509  1.00 28.70           C  
ATOM    709  N   ALA A  96      -7.096  -7.614  64.066  1.00 30.04           N  
ATOM    710  CA  ALA A  96      -7.805  -8.837  64.390  1.00 31.15           C  
ATOM    711  C   ALA A  96      -6.994 -10.098  64.088  1.00 32.45           C  
ATOM    712  O   ALA A  96      -7.315 -11.171  64.588  1.00 31.36           O  
ATOM    713  CB  ALA A  96      -9.208  -8.951  63.545  1.00 32.34           C  
ATOM    714  N   TYR A  97      -5.953 -10.009  63.255  1.00 32.44           N  
ATOM    715  CA  TYR A  97      -5.259 -11.258  62.860  1.00 31.46           C  
ATOM    716  C   TYR A  97      -3.885 -11.429  63.500  1.00 30.08           C  
ATOM    717  O   TYR A  97      -3.189 -12.358  63.213  1.00 30.88           O  
ATOM    718  CB  TYR A  97      -5.189 -11.337  61.361  1.00 32.83           C  
ATOM    719  CG  TYR A  97      -6.570 -11.434  60.702  1.00 35.95           C  
ATOM    720  CD1 TYR A  97      -7.076 -12.702  60.356  1.00 41.00           C  
ATOM    721  CD2 TYR A  97      -7.340 -10.291  60.389  1.00 35.74           C  
ATOM    722  CE1 TYR A  97      -8.315 -12.835  59.713  1.00 44.62           C  
ATOM    723  CE2 TYR A  97      -8.625 -10.423  59.779  1.00 37.89           C  
ATOM    724  CZ  TYR A  97      -9.076 -11.692  59.445  1.00 42.50           C  
ATOM    725  OH  TYR A  97     -10.258 -11.920  58.783  1.00 45.69           O  
ATOM    726  N   ARG A  98      -3.515 -10.506  64.372  1.00 28.69           N  
ATOM    727  CA  ARG A  98      -2.222 -10.593  65.076  1.00 28.10           C  
ATOM    728  C   ARG A  98      -2.204 -11.652  66.148  1.00 28.90           C  
ATOM    729  O   ARG A  98      -3.253 -12.085  66.669  1.00 28.38           O  
ATOM    730  CB  ARG A  98      -1.807  -9.250  65.696  1.00 26.13           C  
ATOM    731  CG  ARG A  98      -1.692  -8.142  64.653  1.00 23.76           C  
ATOM    732  CD  ARG A  98      -1.522  -6.735  65.226  1.00 28.07           C  
ATOM    733  NE  ARG A  98      -1.612  -5.778  64.110  1.00 25.61           N  
ATOM    734  CZ  ARG A  98      -1.822  -4.483  64.197  1.00 23.39           C  
ATOM    735  NH1 ARG A  98      -2.033  -3.909  65.395  1.00 27.37           N  
ATOM    736  NH2 ARG A  98      -1.911  -3.770  63.062  1.00 21.55           N  
ATOM    737  N   ASN A  99      -0.966 -11.959  66.539  1.00 29.19           N  
ATOM    738  CA  ASN A  99      -0.658 -12.820  67.645  1.00 30.39           C  
ATOM    739  C   ASN A  99      -1.189 -14.214  67.435  1.00 30.19           C  
ATOM    740  O   ASN A  99      -1.446 -14.929  68.380  1.00 32.57           O  
ATOM    741  CB  ASN A  99      -1.156 -12.222  68.980  1.00 30.66           C  
ATOM    742  CG  ASN A  99      -0.275 -12.673  70.172  1.00 34.43           C  
ATOM    743  OD1 ASN A  99      -0.747 -12.801  71.304  1.00 38.45           O  
ATOM    744  ND2 ASN A  99       0.987 -12.973  69.895  1.00 27.08           N  
ATOM    745  N   LYS A 100      -1.325 -14.653  66.199  1.00 30.54           N  
ATOM    746  CA  LYS A 100      -1.880 -15.993  65.988  1.00 30.80           C  
ATOM    747  C   LYS A 100      -0.929 -16.844  65.097  1.00 30.53           C  
ATOM    748  O   LYS A 100      -1.346 -17.804  64.514  1.00 29.89           O  
ATOM    749  CB  LYS A 100      -3.276 -15.875  65.346  1.00 29.25           C  
ATOM    750  CG  LYS A 100      -4.408 -15.298  66.291  1.00 31.22           C  
ATOM    751  CD  LYS A 100      -5.763 -15.243  65.497  1.00 32.30           C  
ATOM    752  CE  LYS A 100      -6.728 -14.216  66.026  1.00 34.91           C  
ATOM    753  NZ  LYS A 100      -6.046 -12.927  66.391  1.00 36.74           N  
ATOM    754  N   GLY A 101       0.325 -16.453  64.945  1.00 28.33           N  
ATOM    755  CA  GLY A 101       1.264 -17.272  64.215  1.00 28.49           C  
ATOM    756  C   GLY A 101       1.325 -16.939  62.732  1.00 28.90           C  
ATOM    757  O   GLY A 101       2.128 -17.535  61.968  1.00 29.12           O  
ATOM    758  N   LEU A 102       0.487 -16.002  62.320  1.00 27.12           N  
ATOM    759  CA  LEU A 102       0.421 -15.600  60.921  1.00 28.12           C  
ATOM    760  C   LEU A 102       1.671 -14.792  60.390  1.00 27.32           C  
ATOM    761  O   LEU A 102       2.158 -15.000  59.242  1.00 27.35           O  
ATOM    762  CB  LEU A 102      -0.866 -14.804  60.683  1.00 27.21           C  
ATOM    763  CG  LEU A 102      -1.055 -14.293  59.256  1.00 34.05           C  
ATOM    764  CD1 LEU A 102      -1.241 -15.573  58.264  1.00 33.25           C  
ATOM    765  CD2 LEU A 102      -2.278 -13.393  59.252  1.00 34.25           C  
ATOM    766  N   GLY A 103       2.223 -13.936  61.229  1.00 26.26           N  
ATOM    767  CA  GLY A 103       3.448 -13.244  60.865  1.00 24.14           C  
ATOM    768  C   GLY A 103       4.583 -14.213  60.673  1.00 25.45           C  
ATOM    769  O   GLY A 103       5.384 -14.053  59.771  1.00 24.38           O  
ATOM    770  N   ALA A 104       4.668 -15.205  61.557  1.00 24.84           N  
ATOM    771  CA  ALA A 104       5.698 -16.249  61.448  1.00 26.58           C  
ATOM    772  C   ALA A 104       5.580 -16.974  60.153  1.00 27.79           C  
ATOM    773  O   ALA A 104       6.579 -17.137  59.475  1.00 29.82           O  
ATOM    774  CB  ALA A 104       5.638 -17.174  62.641  1.00 24.40           C  
ATOM    775  N   ARG A 105       4.338 -17.285  59.720  1.00 27.35           N  
ATOM    776  CA  ARG A 105       4.138 -17.975  58.446  1.00 26.43           C  
ATOM    777  C   ARG A 105       4.459 -17.130  57.247  1.00 26.62           C  
ATOM    778  O   ARG A 105       5.072 -17.583  56.313  1.00 25.28           O  
ATOM    779  CB  ARG A 105       2.662 -18.474  58.275  1.00 22.71           C  
ATOM    780  CG  ARG A 105       2.119 -19.510  59.278  1.00 24.37           C  
ATOM    781  CD  ARG A 105       0.947 -20.142  58.567  1.00 35.28           C  
ATOM    782  NE  ARG A 105      -0.297 -19.698  58.994  1.00 43.20           N  
ATOM    783  CZ  ARG A 105      -1.395 -19.620  58.242  1.00 45.26           C  
ATOM    784  NH1 ARG A 105      -1.411 -19.861  56.934  1.00 42.77           N  
ATOM    785  NH2 ARG A 105      -2.497 -19.234  58.852  1.00 42.86           N  
ATOM    786  N   LEU A 106       3.969 -15.908  57.234  1.00 28.52           N  
ATOM    787  CA  LEU A 106       4.318 -14.955  56.154  1.00 29.91           C  
ATOM    788  C   LEU A 106       5.832 -14.722  56.044  1.00 31.16           C  
ATOM    789  O   LEU A 106       6.366 -14.706  54.921  1.00 31.11           O  
ATOM    790  CB  LEU A 106       3.657 -13.624  56.460  1.00 29.27           C  
ATOM    791  CG  LEU A 106       2.750 -12.719  55.616  1.00 31.70           C  
ATOM    792  CD1 LEU A 106       1.971 -13.324  54.470  1.00 29.63           C  
ATOM    793  CD2 LEU A 106       1.808 -11.944  56.664  1.00 30.46           C  
HETATM  794  N   MSE A 107       6.522 -14.529  57.180  1.00 30.25           N  
HETATM  795  CA  MSE A 107       7.972 -14.392  57.179  1.00 35.40           C  
HETATM  796  C   MSE A 107       8.706 -15.593  56.616  1.00 31.74           C  
HETATM  797  O   MSE A 107       9.551 -15.420  55.796  1.00 29.34           O  
HETATM  798  CB  MSE A 107       8.517 -14.165  58.580  1.00 33.23           C  
HETATM  799  CG  MSE A 107       9.731 -13.185  58.627  1.00 44.56           C  
HETATM  800 SE   MSE A 107       9.619 -12.265  60.453  1.00 54.95          SE  
HETATM  801  CE  MSE A 107       7.756 -12.380  60.339  1.00 57.69           C  
ATOM    802  N   ARG A 108       8.380 -16.818  57.077  1.00 31.27           N  
ATOM    803  CA  ARG A 108       8.967 -18.030  56.517  1.00 30.51           C  
ATOM    804  C   ARG A 108       8.884 -18.187  55.024  1.00 30.85           C  
ATOM    805  O   ARG A 108       9.851 -18.653  54.381  1.00 29.70           O  
ATOM    806  CB  ARG A 108       8.386 -19.280  57.220  1.00 31.71           C  
ATOM    807  CG  ARG A 108       8.675 -19.209  58.673  1.00 30.31           C  
ATOM    808  CD  ARG A 108       8.889 -20.460  59.401  1.00 32.21           C  
ATOM    809  NE  ARG A 108       8.099 -20.429  60.606  1.00 32.71           N  
ATOM    810  CZ  ARG A 108       8.515 -20.304  61.856  1.00 39.79           C  
ATOM    811  NH1 ARG A 108       9.869 -20.187  62.242  1.00 40.57           N  
ATOM    812  NH2 ARG A 108       7.514 -20.346  62.751  1.00 31.53           N  
ATOM    813  N   ARG A 109       7.700 -17.916  54.477  1.00 30.21           N  
ATOM    814  CA  ARG A 109       7.505 -17.980  53.032  1.00 29.60           C  
ATOM    815  C   ARG A 109       8.333 -16.919  52.328  1.00 30.39           C  
ATOM    816  O   ARG A 109       8.894 -17.150  51.233  1.00 31.00           O  
ATOM    817  CB  ARG A 109       6.031 -17.772  52.660  1.00 29.25           C  
ATOM    818  CG  ARG A 109       5.116 -19.031  53.002  1.00 29.72           C  
ATOM    819  CD  ARG A 109       5.520 -20.225  52.032  1.00 31.39           C  
ATOM    820  NE  ARG A 109       5.163 -19.924  50.626  1.00 36.18           N  
ATOM    821  CZ  ARG A 109       3.903 -19.934  50.155  1.00 41.68           C  
ATOM    822  NH1 ARG A 109       2.861 -20.167  50.978  1.00 41.93           N  
ATOM    823  NH2 ARG A 109       3.666 -19.668  48.875  1.00 40.48           N  
ATOM    824  N   THR A 110       8.350 -15.724  52.904  1.00 29.53           N  
ATOM    825  CA  THR A 110       8.989 -14.566  52.275  1.00 28.69           C  
ATOM    826  C   THR A 110      10.520 -14.732  52.309  1.00 28.39           C  
ATOM    827  O   THR A 110      11.169 -14.439  51.332  1.00 29.07           O  
ATOM    828  CB  THR A 110       8.512 -13.229  52.907  1.00 29.09           C  
ATOM    829  OG1 THR A 110       7.079 -13.170  52.818  1.00 29.05           O  
ATOM    830  CG2 THR A 110       9.152 -11.928  52.191  1.00 26.79           C  
ATOM    831  N   LEU A 111      11.085 -15.211  53.416  1.00 28.20           N  
ATOM    832  CA  LEU A 111      12.521 -15.527  53.520  1.00 28.79           C  
ATOM    833  C   LEU A 111      12.965 -16.662  52.649  1.00 30.77           C  
ATOM    834  O   LEU A 111      14.102 -16.680  52.091  1.00 30.72           O  
ATOM    835  CB  LEU A 111      12.891 -15.832  54.993  1.00 27.88           C  
ATOM    836  CG  LEU A 111      12.820 -14.603  55.964  1.00 32.16           C  
ATOM    837  CD1 LEU A 111      12.986 -15.086  57.377  1.00 32.09           C  
ATOM    838  CD2 LEU A 111      13.956 -13.521  55.657  1.00 24.73           C  
ATOM    839  N   ASP A 112      12.129 -17.701  52.581  1.00 32.91           N  
ATOM    840  CA  ASP A 112      12.465 -18.745  51.700  1.00 33.15           C  
ATOM    841  C   ASP A 112      12.514 -18.259  50.229  1.00 32.87           C  
ATOM    842  O   ASP A 112      13.473 -18.556  49.499  1.00 31.64           O  
ATOM    843  CB  ASP A 112      11.564 -19.933  51.894  1.00 35.32           C  
ATOM    844  CG  ASP A 112      12.403 -21.257  51.921  1.00 43.33           C  
ATOM    845  OD1 ASP A 112      13.212 -21.515  52.922  1.00 47.49           O  
ATOM    846  OD2 ASP A 112      12.297 -21.957  50.906  1.00 37.98           O  
ATOM    847  N   ALA A 113      11.527 -17.480  49.788  1.00 31.73           N  
ATOM    848  CA  ALA A 113      11.620 -16.956  48.434  1.00 31.23           C  
ATOM    849  C   ALA A 113      12.876 -16.039  48.260  1.00 31.64           C  
ATOM    850  O   ALA A 113      13.455 -15.992  47.163  1.00 30.80           O  
ATOM    851  CB  ALA A 113      10.411 -16.198  48.108  1.00 31.87           C  
ATOM    852  N   ALA A 114      13.260 -15.283  49.299  1.00 30.39           N  
ATOM    853  CA  ALA A 114      14.465 -14.421  49.182  1.00 31.85           C  
ATOM    854  C   ALA A 114      15.751 -15.219  48.992  1.00 30.68           C  
ATOM    855  O   ALA A 114      16.645 -14.835  48.250  1.00 27.88           O  
ATOM    856  CB  ALA A 114      14.619 -13.474  50.369  1.00 30.45           C  
ATOM    857  N   HIS A 115      15.827 -16.314  49.724  1.00 30.88           N  
ATOM    858  CA  HIS A 115      16.946 -17.172  49.634  1.00 32.02           C  
ATOM    859  C   HIS A 115      16.986 -17.815  48.222  1.00 31.55           C  
ATOM    860  O   HIS A 115      18.000 -17.760  47.597  1.00 30.37           O  
ATOM    861  CB  HIS A 115      16.856 -18.199  50.748  1.00 33.18           C  
ATOM    862  CG  HIS A 115      18.101 -19.012  50.960  1.00 39.83           C  
ATOM    863  ND1 HIS A 115      18.323 -19.745  52.110  1.00 43.60           N  
ATOM    864  CD2 HIS A 115      19.191 -19.211  50.186  1.00 46.55           C  
ATOM    865  CE1 HIS A 115      19.490 -20.359  52.027  1.00 43.51           C  
ATOM    866  NE2 HIS A 115      20.044 -20.041  50.879  1.00 45.99           N  
ATOM    867  N   GLU A 116      15.875 -18.376  47.746  1.00 33.64           N  
ATOM    868  CA  GLU A 116      15.750 -18.899  46.402  1.00 36.69           C  
ATOM    869  C   GLU A 116      16.152 -17.875  45.377  1.00 36.77           C  
ATOM    870  O   GLU A 116      16.808 -18.187  44.422  1.00 37.31           O  
ATOM    871  CB  GLU A 116      14.310 -19.334  46.121  1.00 35.83           C  
ATOM    872  CG  GLU A 116      14.185 -20.372  44.867  1.00 39.17           C  
ATOM    873  CD  GLU A 116      12.777 -21.050  44.763  1.00 42.01           C  
ATOM    874  OE1 GLU A 116      11.928 -20.844  45.657  1.00 52.35           O  
ATOM    875  OE2 GLU A 116      12.492 -21.798  43.790  1.00 52.81           O  
ATOM    876  N   PHE A 117      15.735 -16.633  45.557  1.00 36.70           N  
ATOM    877  CA  PHE A 117      16.151 -15.598  44.631  1.00 37.64           C  
ATOM    878  C   PHE A 117      17.685 -15.382  44.652  1.00 35.80           C  
ATOM    879  O   PHE A 117      18.200 -14.848  43.733  1.00 37.35           O  
ATOM    880  CB  PHE A 117      15.385 -14.297  44.958  1.00 38.61           C  
ATOM    881  CG  PHE A 117      15.804 -13.097  44.160  1.00 44.47           C  
ATOM    882  CD1 PHE A 117      14.943 -12.574  43.156  1.00 47.32           C  
ATOM    883  CD2 PHE A 117      17.064 -12.456  44.393  1.00 47.62           C  
ATOM    884  CE1 PHE A 117      15.311 -11.431  42.404  1.00 45.21           C  
ATOM    885  CE2 PHE A 117      17.445 -11.323  43.654  1.00 49.28           C  
ATOM    886  CZ  PHE A 117      16.544 -10.808  42.649  1.00 46.53           C  
ATOM    887  N   GLY A 118      18.421 -15.670  45.722  1.00 34.33           N  
ATOM    888  CA  GLY A 118      19.843 -15.430  45.660  1.00 30.33           C  
ATOM    889  C   GLY A 118      20.378 -14.360  46.580  1.00 31.77           C  
ATOM    890  O   GLY A 118      21.553 -14.068  46.525  1.00 31.35           O  
ATOM    891  N   LEU A 119      19.533 -13.792  47.453  1.00 31.15           N  
ATOM    892  CA  LEU A 119      19.936 -12.812  48.421  1.00 30.29           C  
ATOM    893  C   LEU A 119      20.681 -13.471  49.533  1.00 29.92           C  
ATOM    894  O   LEU A 119      20.480 -14.663  49.829  1.00 31.54           O  
ATOM    895  CB  LEU A 119      18.731 -12.016  48.946  1.00 31.49           C  
ATOM    896  CG  LEU A 119      17.903 -11.174  47.948  1.00 34.00           C  
ATOM    897  CD1 LEU A 119      16.690 -10.528  48.670  1.00 40.33           C  
ATOM    898  CD2 LEU A 119      18.689 -10.024  47.342  1.00 33.85           C  
ATOM    899  N   HIS A 120      21.660 -12.746  50.041  1.00 28.79           N  
ATOM    900  CA  HIS A 120      22.526 -13.218  51.141  1.00 29.81           C  
ATOM    901  C   HIS A 120      22.030 -12.689  52.520  1.00 27.78           C  
ATOM    902  O   HIS A 120      22.040 -13.407  53.578  1.00 27.18           O  
ATOM    903  CB  HIS A 120      24.022 -12.793  50.814  1.00 28.94           C  
ATOM    904  CG  HIS A 120      25.002 -13.043  51.917  1.00 31.70           C  
ATOM    905  ND1 HIS A 120      25.530 -14.291  52.188  1.00 30.72           N  
ATOM    906  CD2 HIS A 120      25.576 -12.190  52.799  1.00 29.74           C  
ATOM    907  CE1 HIS A 120      26.389 -14.193  53.178  1.00 28.67           C  
ATOM    908  NE2 HIS A 120      26.450 -12.927  53.558  1.00 28.34           N  
ATOM    909  N   ARG A 121      21.628 -11.421  52.481  1.00 25.50           N  
ATOM    910  CA  ARG A 121      21.365 -10.622  53.684  1.00 25.38           C  
ATOM    911  C   ARG A 121      19.995  -9.942  53.660  1.00 24.16           C  
ATOM    912  O   ARG A 121      19.639  -9.314  52.673  1.00 25.97           O  
ATOM    913  CB  ARG A 121      22.520  -9.663  53.954  1.00 24.92           C  
ATOM    914  CG  ARG A 121      22.321  -8.715  55.161  1.00 22.01           C  
ATOM    915  CD  ARG A 121      23.504  -7.768  55.158  1.00 23.54           C  
ATOM    916  NE  ARG A 121      23.074  -6.644  55.978  1.00 25.95           N  
ATOM    917  CZ  ARG A 121      23.115  -6.653  57.321  1.00 28.23           C  
ATOM    918  NH1 ARG A 121      23.662  -7.686  58.011  1.00 23.20           N  
ATOM    919  NH2 ARG A 121      22.605  -5.630  57.970  1.00 21.76           N  
ATOM    920  N   ILE A 122      19.183 -10.260  54.671  1.00 22.81           N  
ATOM    921  CA  ILE A 122      17.916  -9.613  54.936  1.00 23.57           C  
ATOM    922  C   ILE A 122      17.994  -8.703  56.207  1.00 24.54           C  
ATOM    923  O   ILE A 122      18.364  -9.137  57.256  1.00 22.85           O  
ATOM    924  CB  ILE A 122      16.709 -10.544  55.024  1.00 22.36           C  
ATOM    925  CG1 ILE A 122      16.678 -11.562  53.906  1.00 24.11           C  
ATOM    926  CG2 ILE A 122      15.390  -9.680  55.068  1.00 25.31           C  
ATOM    927  CD1 ILE A 122      16.790 -10.958  52.438  1.00 21.82           C  
ATOM    928  N   GLU A 123      17.654  -7.423  56.049  1.00 25.55           N  
ATOM    929  CA  GLU A 123      17.774  -6.479  57.136  1.00 27.86           C  
ATOM    930  C   GLU A 123      16.457  -5.753  57.363  1.00 25.00           C  
ATOM    931  O   GLU A 123      15.591  -5.768  56.502  1.00 25.15           O  
ATOM    932  CB  GLU A 123      18.983  -5.524  56.915  1.00 26.95           C  
ATOM    933  CG  GLU A 123      18.729  -4.415  55.972  1.00 32.68           C  
ATOM    934  CD  GLU A 123      20.046  -3.581  55.522  1.00 37.55           C  
ATOM    935  OE1 GLU A 123      19.789  -2.384  55.258  1.00 45.05           O  
ATOM    936  OE2 GLU A 123      21.250  -4.057  55.472  1.00 44.66           O  
ATOM    937  N   LEU A 124      16.288  -5.253  58.583  1.00 25.03           N  
ATOM    938  CA  LEU A 124      15.062  -4.612  59.070  1.00 25.16           C  
ATOM    939  C   LEU A 124      15.402  -3.660  60.186  1.00 26.79           C  
ATOM    940  O   LEU A 124      16.472  -3.740  60.844  1.00 27.44           O  
ATOM    941  CB  LEU A 124      13.982  -5.650  59.474  1.00 24.98           C  
ATOM    942  CG  LEU A 124      14.149  -6.647  60.595  1.00 24.24           C  
ATOM    943  CD1 LEU A 124      14.103  -5.944  62.046  1.00 22.16           C  
ATOM    944  CD2 LEU A 124      13.126  -7.743  60.438  1.00 23.18           C  
ATOM    945  N   SER A 125      14.536  -2.684  60.347  1.00 28.70           N  
ATOM    946  CA  SER A 125      14.572  -1.758  61.480  1.00 29.56           C  
ATOM    947  C   SER A 125      13.264  -1.871  62.235  1.00 28.23           C  
ATOM    948  O   SER A 125      12.243  -1.927  61.598  1.00 29.43           O  
ATOM    949  CB  SER A 125      14.689  -0.351  60.932  1.00 29.52           C  
ATOM    950  OG  SER A 125      16.106  -0.196  60.669  1.00 42.23           O  
ATOM    951  N   VAL A 126      13.288  -1.905  63.561  1.00 25.14           N  
ATOM    952  CA  VAL A 126      12.094  -2.017  64.360  1.00 24.38           C  
ATOM    953  C   VAL A 126      12.126  -1.032  65.550  1.00 26.25           C  
ATOM    954  O   VAL A 126      13.187  -0.839  66.162  1.00 26.06           O  
ATOM    955  CB  VAL A 126      11.885  -3.516  64.805  1.00 23.78           C  
ATOM    956  CG1 VAL A 126      13.086  -4.027  65.703  1.00 17.49           C  
ATOM    957  CG2 VAL A 126      10.613  -3.718  65.463  1.00 20.30           C  
ATOM    958  N   HIS A 127      10.975  -0.434  65.883  1.00 25.96           N  
ATOM    959  CA  HIS A 127      10.899   0.421  67.046  1.00 24.90           C  
ATOM    960  C   HIS A 127      11.219  -0.346  68.300  1.00 25.20           C  
ATOM    961  O   HIS A 127      10.722  -1.471  68.509  1.00 25.29           O  
ATOM    962  CB  HIS A 127       9.532   1.155  67.170  1.00 23.92           C  
ATOM    963  CG  HIS A 127       9.170   2.018  66.002  1.00 24.17           C  
ATOM    964  ND1 HIS A 127       7.924   2.576  65.849  1.00 32.95           N  
ATOM    965  CD2 HIS A 127       9.881   2.420  64.917  1.00 28.76           C  
ATOM    966  CE1 HIS A 127       7.863   3.237  64.707  1.00 30.62           C  
ATOM    967  NE2 HIS A 127       9.027   3.125  64.104  1.00 31.18           N  
ATOM    968  N   ALA A 128      12.032   0.263  69.172  1.00 25.89           N  
ATOM    969  CA  ALA A 128      12.549  -0.438  70.369  1.00 26.82           C  
ATOM    970  C   ALA A 128      11.421  -0.861  71.308  1.00 27.43           C  
ATOM    971  O   ALA A 128      11.563  -1.810  72.114  1.00 27.60           O  
ATOM    972  CB  ALA A 128      13.640   0.355  71.142  1.00 24.55           C  
ATOM    973  N   ASP A 129      10.313  -0.150  71.212  1.00 28.24           N  
ATOM    974  CA  ASP A 129       9.162  -0.455  72.016  1.00 29.91           C  
ATOM    975  C   ASP A 129       8.113  -1.390  71.317  1.00 28.98           C  
ATOM    976  O   ASP A 129       7.119  -1.752  71.923  1.00 26.82           O  
ATOM    977  CB  ASP A 129       8.552   0.846  72.559  1.00 31.79           C  
ATOM    978  CG  ASP A 129       7.954   1.754  71.446  1.00 40.40           C  
ATOM    979  OD1 ASP A 129       8.069   1.427  70.230  1.00 45.60           O  
ATOM    980  OD2 ASP A 129       7.348   2.823  71.797  1.00 49.84           O  
ATOM    981  N   ASN A 130       8.390  -1.854  70.087  1.00 27.60           N  
ATOM    982  CA  ASN A 130       7.480  -2.776  69.409  1.00 26.94           C  
ATOM    983  C   ASN A 130       7.782  -4.216  69.860  1.00 26.74           C  
ATOM    984  O   ASN A 130       8.430  -4.964  69.118  1.00 25.95           O  
ATOM    985  CB  ASN A 130       7.665  -2.660  67.904  1.00 25.80           C  
ATOM    986  CG  ASN A 130       6.571  -3.373  67.106  1.00 23.13           C  
ATOM    987  OD1 ASN A 130       5.833  -4.196  67.617  1.00 23.68           O  
ATOM    988  ND2 ASN A 130       6.426  -2.987  65.848  1.00 21.49           N  
ATOM    989  N   ALA A 131       7.394  -4.596  71.075  1.00 26.01           N  
ATOM    990  CA  ALA A 131       7.917  -5.913  71.628  1.00 26.33           C  
ATOM    991  C   ALA A 131       7.396  -7.169  70.894  1.00 25.95           C  
ATOM    992  O   ALA A 131       8.078  -8.237  70.813  1.00 27.75           O  
ATOM    993  CB  ALA A 131       7.631  -5.979  73.206  1.00 25.66           C  
ATOM    994  N   ARG A 132       6.171  -7.072  70.355  1.00 22.77           N  
ATOM    995  CA  ARG A 132       5.635  -8.137  69.593  1.00 22.37           C  
ATOM    996  C   ARG A 132       6.445  -8.435  68.266  1.00 23.46           C  
ATOM    997  O   ARG A 132       6.694  -9.612  67.972  1.00 22.41           O  
ATOM    998  CB  ARG A 132       4.139  -7.920  69.318  1.00 21.81           C  
ATOM    999  CG  ARG A 132       3.664  -8.840  68.223  1.00 24.69           C  
ATOM   1000  CD  ARG A 132       2.175  -8.966  68.187  1.00 27.45           C  
ATOM   1001  NE  ARG A 132       1.686  -7.701  68.665  1.00 39.09           N  
ATOM   1002  CZ  ARG A 132       1.218  -6.834  67.831  1.00 37.79           C  
ATOM   1003  NH1 ARG A 132       1.188  -7.281  66.600  1.00 49.39           N  
ATOM   1004  NH2 ARG A 132       0.745  -5.659  68.179  1.00 32.21           N  
ATOM   1005  N   ALA A 133       6.806  -7.373  67.499  1.00 21.28           N  
ATOM   1006  CA  ALA A 133       7.585  -7.523  66.286  1.00 21.89           C  
ATOM   1007  C   ALA A 133       8.928  -8.017  66.690  1.00 23.09           C  
ATOM   1008  O   ALA A 133       9.372  -8.973  66.101  1.00 25.00           O  
ATOM   1009  CB  ALA A 133       7.747  -6.165  65.438  1.00 19.87           C  
ATOM   1010  N   ILE A 134       9.595  -7.384  67.678  1.00 23.00           N  
ATOM   1011  CA  ILE A 134      10.876  -7.902  68.119  1.00 22.85           C  
ATOM   1012  C   ILE A 134      10.885  -9.430  68.464  1.00 23.41           C  
ATOM   1013  O   ILE A 134      11.761 -10.152  67.982  1.00 24.43           O  
ATOM   1014  CB  ILE A 134      11.464  -7.051  69.263  1.00 22.95           C  
ATOM   1015  CG1 ILE A 134      11.823  -5.641  68.752  1.00 19.43           C  
ATOM   1016  CG2 ILE A 134      12.732  -7.704  69.847  1.00 21.13           C  
ATOM   1017  CD1 ILE A 134      11.765  -4.683  69.900  1.00 18.10           C  
ATOM   1018  N   ALA A 135       9.959  -9.886  69.322  1.00 22.80           N  
ATOM   1019  CA  ALA A 135       9.847 -11.297  69.703  1.00 22.84           C  
ATOM   1020  C   ALA A 135       9.647 -12.189  68.523  1.00 23.14           C  
ATOM   1021  O   ALA A 135      10.191 -13.304  68.504  1.00 23.81           O  
ATOM   1022  CB  ALA A 135       8.668 -11.530  70.689  1.00 23.47           C  
ATOM   1023  N   LEU A 136       8.845 -11.747  67.553  1.00 22.90           N  
ATOM   1024  CA  LEU A 136       8.688 -12.545  66.320  1.00 23.28           C  
ATOM   1025  C   LEU A 136       9.991 -12.566  65.521  1.00 23.73           C  
ATOM   1026  O   LEU A 136      10.417 -13.625  65.050  1.00 24.27           O  
ATOM   1027  CB  LEU A 136       7.536 -12.037  65.419  1.00 23.68           C  
ATOM   1028  CG  LEU A 136       7.484 -12.737  64.029  1.00 23.56           C  
ATOM   1029  CD1 LEU A 136       7.205 -14.197  64.230  1.00 24.88           C  
ATOM   1030  CD2 LEU A 136       6.520 -12.169  62.980  1.00 21.60           C  
ATOM   1031  N   TYR A 137      10.636 -11.427  65.351  1.00 23.28           N  
ATOM   1032  CA  TYR A 137      11.925 -11.450  64.634  1.00 23.49           C  
ATOM   1033  C   TYR A 137      12.984 -12.318  65.313  1.00 23.25           C  
ATOM   1034  O   TYR A 137      13.680 -13.038  64.657  1.00 19.78           O  
ATOM   1035  CB  TYR A 137      12.475 -10.033  64.445  1.00 22.91           C  
ATOM   1036  CG  TYR A 137      11.557  -9.153  63.691  1.00 23.85           C  
ATOM   1037  CD1 TYR A 137      10.744  -9.674  62.670  1.00 27.08           C  
ATOM   1038  CD2 TYR A 137      11.446  -7.771  64.001  1.00 26.08           C  
ATOM   1039  CE1 TYR A 137       9.772  -8.850  61.982  1.00 26.26           C  
ATOM   1040  CE2 TYR A 137      10.569  -6.917  63.269  1.00 24.26           C  
ATOM   1041  CZ  TYR A 137       9.737  -7.460  62.270  1.00 28.90           C  
ATOM   1042  OH  TYR A 137       8.878  -6.628  61.572  1.00 29.17           O  
ATOM   1043  N   GLU A 138      13.098 -12.232  66.645  1.00 24.49           N  
ATOM   1044  CA  GLU A 138      13.995 -13.167  67.373  1.00 27.63           C  
ATOM   1045  C   GLU A 138      13.663 -14.654  67.106  1.00 27.72           C  
ATOM   1046  O   GLU A 138      14.536 -15.419  66.805  1.00 26.63           O  
ATOM   1047  CB  GLU A 138      13.994 -12.881  68.897  1.00 26.04           C  
ATOM   1048  CG  GLU A 138      14.659 -11.484  69.117  1.00 27.60           C  
ATOM   1049  CD  GLU A 138      14.575 -10.983  70.559  1.00 29.83           C  
ATOM   1050  OE1 GLU A 138      13.776 -11.537  71.335  1.00 36.89           O  
ATOM   1051  OE2 GLU A 138      15.261  -9.998  70.913  1.00 35.04           O  
ATOM   1052  N   LYS A 139      12.375 -15.015  67.185  1.00 28.91           N  
ATOM   1053  CA  LYS A 139      11.928 -16.362  67.021  1.00 29.01           C  
ATOM   1054  C   LYS A 139      12.320 -16.834  65.635  1.00 29.48           C  
ATOM   1055  O   LYS A 139      12.797 -17.921  65.482  1.00 29.56           O  
ATOM   1056  CB  LYS A 139      10.410 -16.408  67.170  1.00 29.71           C  
ATOM   1057  CG  LYS A 139       9.846 -17.732  67.010  1.00 31.92           C  
ATOM   1058  CD  LYS A 139       8.462 -17.718  66.439  1.00 41.36           C  
ATOM   1059  CE  LYS A 139       7.506 -16.774  67.196  1.00 47.61           C  
ATOM   1060  NZ  LYS A 139       6.083 -17.039  66.669  1.00 55.76           N  
ATOM   1061  N   ILE A 140      12.083 -16.017  64.604  1.00 29.19           N  
ATOM   1062  CA  ILE A 140      12.404 -16.431  63.236  1.00 27.63           C  
ATOM   1063  C   ILE A 140      13.926 -16.611  63.039  1.00 27.33           C  
ATOM   1064  O   ILE A 140      14.297 -17.321  62.164  1.00 25.20           O  
ATOM   1065  CB  ILE A 140      11.884 -15.382  62.225  1.00 28.55           C  
ATOM   1066  CG1 ILE A 140      10.339 -15.312  62.259  1.00 27.12           C  
ATOM   1067  CG2 ILE A 140      12.378 -15.681  60.803  1.00 30.02           C  
ATOM   1068  CD1 ILE A 140       9.573 -16.576  62.021  1.00 24.36           C  
ATOM   1069  N   GLY A 141      14.784 -15.940  63.840  1.00 26.28           N  
ATOM   1070  CA  GLY A 141      16.221 -16.110  63.769  1.00 23.91           C  
ATOM   1071  C   GLY A 141      16.967 -14.822  63.307  1.00 25.23           C  
ATOM   1072  O   GLY A 141      18.147 -14.883  63.008  1.00 23.86           O  
ATOM   1073  N   PHE A 142      16.327 -13.635  63.339  1.00 24.85           N  
ATOM   1074  CA  PHE A 142      17.061 -12.373  63.126  1.00 23.94           C  
ATOM   1075  C   PHE A 142      17.991 -12.122  64.323  1.00 24.67           C  
ATOM   1076  O   PHE A 142      17.649 -12.450  65.409  1.00 25.66           O  
ATOM   1077  CB  PHE A 142      16.145 -11.185  62.923  1.00 22.41           C  
ATOM   1078  CG  PHE A 142      15.567 -11.138  61.555  1.00 24.68           C  
ATOM   1079  CD1 PHE A 142      14.501 -11.983  61.198  1.00 22.47           C  
ATOM   1080  CD2 PHE A 142      16.059 -10.231  60.612  1.00 19.51           C  
ATOM   1081  CE1 PHE A 142      13.941 -11.919  59.925  1.00 27.40           C  
ATOM   1082  CE2 PHE A 142      15.513 -10.176  59.310  1.00 28.39           C  
ATOM   1083  CZ  PHE A 142      14.435 -10.990  58.964  1.00 24.57           C  
ATOM   1084  N   ALA A 143      19.195 -11.637  64.063  1.00 23.74           N  
ATOM   1085  CA  ALA A 143      20.144 -11.209  65.041  1.00 23.53           C  
ATOM   1086  C   ALA A 143      20.028  -9.685  65.237  1.00 24.13           C  
ATOM   1087  O   ALA A 143      19.879  -8.891  64.250  1.00 23.94           O  
ATOM   1088  CB  ALA A 143      21.592 -11.596  64.562  1.00 20.85           C  
ATOM   1089  N   HIS A 144      20.188  -9.256  66.491  1.00 23.76           N  
ATOM   1090  CA  HIS A 144      20.358  -7.867  66.746  1.00 23.80           C  
ATOM   1091  C   HIS A 144      21.693  -7.369  66.259  1.00 25.86           C  
ATOM   1092  O   HIS A 144      22.746  -7.983  66.531  1.00 25.02           O  
ATOM   1093  CB  HIS A 144      20.221  -7.603  68.296  1.00 23.89           C  
ATOM   1094  CG  HIS A 144      18.807  -7.774  68.797  1.00 22.62           C  
ATOM   1095  ND1 HIS A 144      17.863  -6.788  68.674  1.00 23.03           N  
ATOM   1096  CD2 HIS A 144      18.178  -8.821  69.385  1.00 22.97           C  
ATOM   1097  CE1 HIS A 144      16.728  -7.182  69.218  1.00 26.10           C  
ATOM   1098  NE2 HIS A 144      16.880  -8.433  69.615  1.00 27.17           N  
ATOM   1099  N   GLU A 145      21.674  -6.179  65.666  1.00 26.37           N  
ATOM   1100  CA  GLU A 145      22.880  -5.610  65.074  1.00 27.85           C  
ATOM   1101  C   GLU A 145      23.206  -4.260  65.618  1.00 28.19           C  
ATOM   1102  O   GLU A 145      24.265  -3.797  65.300  1.00 30.43           O  
ATOM   1103  CB  GLU A 145      22.791  -5.465  63.555  1.00 25.94           C  
ATOM   1104  CG  GLU A 145      22.915  -6.823  62.881  1.00 28.95           C  
ATOM   1105  CD  GLU A 145      23.260  -6.682  61.396  1.00 29.29           C  
ATOM   1106  OE1 GLU A 145      24.013  -7.541  60.882  1.00 24.23           O  
ATOM   1107  OE2 GLU A 145      22.759  -5.691  60.759  1.00 29.42           O  
ATOM   1108  N   GLY A 146      22.298  -3.664  66.399  1.00 26.37           N  
ATOM   1109  CA  GLY A 146      22.539  -2.468  67.123  1.00 24.71           C  
ATOM   1110  C   GLY A 146      21.324  -1.594  67.307  1.00 25.58           C  
ATOM   1111  O   GLY A 146      20.283  -1.893  66.769  1.00 24.66           O  
ATOM   1112  N   ARG A 147      21.471  -0.472  68.042  1.00 26.31           N  
ATOM   1113  CA  ARG A 147      20.325   0.300  68.541  1.00 26.64           C  
ATOM   1114  C   ARG A 147      20.575   1.706  68.013  1.00 27.05           C  
ATOM   1115  O   ARG A 147      21.647   2.245  68.173  1.00 27.49           O  
ATOM   1116  CB  ARG A 147      20.376   0.232  70.049  1.00 27.40           C  
ATOM   1117  CG  ARG A 147      19.489   1.129  70.779  1.00 30.74           C  
ATOM   1118  CD  ARG A 147      19.551   0.731  72.229  1.00 37.23           C  
ATOM   1119  NE  ARG A 147      18.232   0.621  72.848  1.00 43.66           N  
ATOM   1120  CZ  ARG A 147      17.722  -0.545  73.276  1.00 46.06           C  
ATOM   1121  NH1 ARG A 147      18.425  -1.673  73.207  1.00 45.36           N  
ATOM   1122  NH2 ARG A 147      16.516  -0.592  73.783  1.00 47.80           N  
ATOM   1123  N   ALA A 148      19.613   2.274  67.309  1.00 26.59           N  
ATOM   1124  CA  ALA A 148      19.747   3.648  66.850  1.00 25.28           C  
ATOM   1125  C   ALA A 148      19.020   4.632  67.794  1.00 24.09           C  
ATOM   1126  O   ALA A 148      17.853   4.607  67.814  1.00 22.85           O  
ATOM   1127  CB  ALA A 148      19.203   3.725  65.390  1.00 24.43           C  
ATOM   1128  N   ARG A 149      19.717   5.532  68.510  1.00 23.83           N  
ATOM   1129  CA  ARG A 149      19.081   6.356  69.530  1.00 26.44           C  
ATOM   1130  C   ARG A 149      18.310   7.511  68.900  1.00 25.08           C  
ATOM   1131  O   ARG A 149      18.872   8.230  68.109  1.00 22.60           O  
ATOM   1132  CB  ARG A 149      20.112   6.968  70.529  1.00 26.92           C  
ATOM   1133  CG  ARG A 149      21.214   5.965  70.969  1.00 35.36           C  
ATOM   1134  CD  ARG A 149      20.745   4.962  72.110  1.00 42.79           C  
ATOM   1135  NE  ARG A 149      19.833   5.539  73.135  1.00 49.60           N  
ATOM   1136  CZ  ARG A 149      20.182   6.295  74.203  1.00 56.43           C  
ATOM   1137  NH1 ARG A 149      21.449   6.604  74.506  1.00 55.61           N  
ATOM   1138  NH2 ARG A 149      19.232   6.727  75.029  1.00 58.99           N  
ATOM   1139  N   ASP A 150      17.074   7.730  69.340  1.00 23.73           N  
ATOM   1140  CA  ASP A 150      16.274   8.825  68.778  1.00 24.75           C  
ATOM   1141  C   ASP A 150      16.138   8.782  67.228  1.00 23.38           C  
ATOM   1142  O   ASP A 150      16.114   9.792  66.601  1.00 23.72           O  
ATOM   1143  CB  ASP A 150      16.847  10.200  69.155  1.00 21.99           C  
ATOM   1144  CG  ASP A 150      16.790  10.500  70.660  1.00 25.69           C  
ATOM   1145  OD1 ASP A 150      16.162   9.656  71.394  1.00 24.57           O  
ATOM   1146  OD2 ASP A 150      17.385  11.603  71.081  1.00 24.61           O  
ATOM   1147  N   ALA A 151      16.060   7.632  66.639  1.00 23.84           N  
ATOM   1148  CA  ALA A 151      16.098   7.534  65.171  1.00 24.82           C  
ATOM   1149  C   ALA A 151      14.704   7.800  64.560  1.00 25.31           C  
ATOM   1150  O   ALA A 151      14.617   8.094  63.389  1.00 25.05           O  
ATOM   1151  CB  ALA A 151      16.637   6.188  64.710  1.00 23.14           C  
ATOM   1152  N   VAL A 152      13.657   7.771  65.391  1.00 25.80           N  
ATOM   1153  CA  VAL A 152      12.228   7.810  64.956  1.00 24.71           C  
ATOM   1154  C   VAL A 152      11.603   8.954  65.755  1.00 24.48           C  
ATOM   1155  O   VAL A 152      11.920   9.157  66.917  1.00 24.73           O  
ATOM   1156  CB  VAL A 152      11.510   6.410  65.174  1.00 25.42           C  
ATOM   1157  CG1 VAL A 152       9.964   6.469  64.944  1.00 26.38           C  
ATOM   1158  CG2 VAL A 152      12.038   5.364  64.238  1.00 20.55           C  
ATOM   1159  N   SER A 153      10.789   9.768  65.136  1.00 24.17           N  
ATOM   1160  CA  SER A 153      10.049  10.798  65.906  1.00 27.44           C  
ATOM   1161  C   SER A 153       8.618  10.649  65.402  1.00 28.79           C  
ATOM   1162  O   SER A 153       8.411  10.552  64.182  1.00 28.24           O  
ATOM   1163  CB  SER A 153      10.573  12.182  65.548  1.00 26.77           C  
ATOM   1164  OG  SER A 153       9.944  13.203  66.264  1.00 30.48           O  
ATOM   1165  N   ILE A 154       7.643  10.507  66.273  1.00 30.55           N  
ATOM   1166  CA  ILE A 154       6.307  10.297  65.726  1.00 34.55           C  
ATOM   1167  C   ILE A 154       5.294  11.472  65.889  1.00 37.79           C  
ATOM   1168  O   ILE A 154       4.497  11.798  64.967  1.00 41.50           O  
ATOM   1169  CB  ILE A 154       5.703   8.929  66.069  1.00 33.13           C  
ATOM   1170  CG1 ILE A 154       6.356   7.882  65.199  1.00 33.56           C  
ATOM   1171  CG2 ILE A 154       4.177   8.941  65.766  1.00 34.86           C  
ATOM   1172  CD1 ILE A 154       6.022   6.403  65.549  1.00 34.19           C  
ATOM   1173  N   ASP A 155       5.273  12.098  67.042  1.00 38.63           N  
ATOM   1174  CA  ASP A 155       4.621  13.367  67.120  1.00 39.43           C  
ATOM   1175  C   ASP A 155       5.244  14.060  68.316  1.00 39.18           C  
ATOM   1176  O   ASP A 155       4.721  14.056  69.426  1.00 38.91           O  
ATOM   1177  CB  ASP A 155       3.078  13.249  67.139  1.00 41.61           C  
ATOM   1178  CG  ASP A 155       2.557  12.289  68.183  1.00 42.76           C  
ATOM   1179  OD1 ASP A 155       1.704  11.406  67.820  1.00 41.06           O  
ATOM   1180  OD2 ASP A 155       2.997  12.470  69.351  1.00 44.40           O  
ATOM   1181  N   GLY A 156       6.449  14.556  68.059  1.00 38.75           N  
ATOM   1182  CA  GLY A 156       7.255  15.285  69.020  1.00 37.06           C  
ATOM   1183  C   GLY A 156       7.866  14.369  70.036  1.00 36.33           C  
ATOM   1184  O   GLY A 156       8.506  14.858  70.973  1.00 37.62           O  
ATOM   1185  N   HIS A 157       7.676  13.053  69.870  1.00 34.42           N  
ATOM   1186  CA  HIS A 157       8.371  12.076  70.730  1.00 33.80           C  
ATOM   1187  C   HIS A 157       9.450  11.256  69.964  1.00 30.90           C  
ATOM   1188  O   HIS A 157       9.152  10.724  68.929  1.00 28.93           O  
ATOM   1189  CB  HIS A 157       7.381  11.142  71.431  1.00 33.26           C  
ATOM   1190  CG  HIS A 157       6.422  11.852  72.332  1.00 38.29           C  
ATOM   1191  ND1 HIS A 157       6.806  12.901  73.150  1.00 41.17           N  
ATOM   1192  CD2 HIS A 157       5.089  11.677  72.538  1.00 40.22           C  
ATOM   1193  CE1 HIS A 157       5.756  13.343  73.825  1.00 43.10           C  
ATOM   1194  NE2 HIS A 157       4.703  12.612  73.475  1.00 45.63           N  
ATOM   1195  N   TYR A 158      10.671  11.207  70.499  1.00 30.14           N  
ATOM   1196  CA  TYR A 158      11.760  10.342  69.986  1.00 30.13           C  
ATOM   1197  C   TYR A 158      11.680   8.897  70.443  1.00 29.25           C  
ATOM   1198  O   TYR A 158      11.583   8.632  71.632  1.00 29.33           O  
ATOM   1199  CB  TYR A 158      13.142  10.882  70.392  1.00 30.19           C  
ATOM   1200  CG  TYR A 158      13.467  12.225  69.794  1.00 31.07           C  
ATOM   1201  CD1 TYR A 158      13.818  13.295  70.602  1.00 32.60           C  
ATOM   1202  CD2 TYR A 158      13.383  12.441  68.413  1.00 29.34           C  
ATOM   1203  CE1 TYR A 158      14.049  14.563  70.055  1.00 31.97           C  
ATOM   1204  CE2 TYR A 158      13.669  13.710  67.856  1.00 27.83           C  
ATOM   1205  CZ  TYR A 158      13.986  14.748  68.665  1.00 30.55           C  
ATOM   1206  OH  TYR A 158      14.207  16.004  68.103  1.00 32.56           O  
ATOM   1207  N   ILE A 159      11.811   7.987  69.482  1.00 29.52           N  
ATOM   1208  CA  ILE A 159      11.841   6.516  69.668  1.00 29.14           C  
ATOM   1209  C   ILE A 159      13.197   5.980  69.158  1.00 27.44           C  
ATOM   1210  O   ILE A 159      13.677   6.357  68.091  1.00 25.30           O  
ATOM   1211  CB  ILE A 159      10.684   5.774  68.824  1.00 29.23           C  
ATOM   1212  CG1 ILE A 159       9.345   6.504  68.892  1.00 34.79           C  
ATOM   1213  CG2 ILE A 159      10.456   4.340  69.243  1.00 30.84           C  
ATOM   1214  CD1 ILE A 159       8.981   6.864  70.246  1.00 36.88           C  
ATOM   1215  N   ASP A 160      13.800   5.097  69.930  1.00 26.41           N  
ATOM   1216  CA  ASP A 160      14.884   4.267  69.425  1.00 26.04           C  
ATOM   1217  C   ASP A 160      14.431   3.237  68.413  1.00 25.97           C  
ATOM   1218  O   ASP A 160      13.300   2.710  68.409  1.00 24.13           O  
ATOM   1219  CB  ASP A 160      15.555   3.575  70.611  1.00 27.17           C  
ATOM   1220  CG  ASP A 160      16.279   4.582  71.538  1.00 27.06           C  
ATOM   1221  OD1 ASP A 160      16.118   5.797  71.371  1.00 27.23           O  
ATOM   1222  OD2 ASP A 160      17.014   4.168  72.442  1.00 32.50           O  
ATOM   1223  N   SER A 161      15.345   2.932  67.539  1.00 25.84           N  
ATOM   1224  CA  SER A 161      15.070   1.892  66.552  1.00 27.48           C  
ATOM   1225  C   SER A 161      16.152   0.806  66.753  1.00 25.37           C  
ATOM   1226  O   SER A 161      17.267   1.110  67.102  1.00 25.46           O  
ATOM   1227  CB  SER A 161      15.177   2.484  65.133  1.00 26.97           C  
ATOM   1228  OG  SER A 161      14.334   1.743  64.301  1.00 36.76           O  
ATOM   1229  N   LEU A 162      15.805  -0.444  66.559  1.00 25.00           N  
ATOM   1230  CA  LEU A 162      16.762  -1.554  66.616  1.00 23.60           C  
ATOM   1231  C   LEU A 162      16.962  -2.059  65.255  1.00 23.24           C  
ATOM   1232  O   LEU A 162      15.987  -2.321  64.513  1.00 22.61           O  
ATOM   1233  CB  LEU A 162      16.227  -2.724  67.451  1.00 21.86           C  
ATOM   1234  CG  LEU A 162      15.820  -2.372  68.900  1.00 19.39           C  
ATOM   1235  CD1 LEU A 162      15.372  -3.602  69.714  1.00 19.17           C  
ATOM   1236  CD2 LEU A 162      16.887  -1.556  69.683  1.00 19.97           C  
ATOM   1237  N   ASN A 163      18.218  -2.257  64.925  1.00 22.93           N  
ATOM   1238  CA  ASN A 163      18.553  -2.882  63.619  1.00 23.73           C  
ATOM   1239  C   ASN A 163      18.801  -4.324  63.792  1.00 23.04           C  
ATOM   1240  O   ASN A 163      19.492  -4.700  64.704  1.00 23.37           O  
ATOM   1241  CB  ASN A 163      19.835  -2.271  63.036  1.00 25.48           C  
ATOM   1242  CG  ASN A 163      19.609  -0.850  62.662  1.00 29.56           C  
ATOM   1243  OD1 ASN A 163      18.711  -0.620  61.920  1.00 33.30           O  
ATOM   1244  ND2 ASN A 163      20.325   0.108  63.273  1.00 33.45           N  
HETATM 1245  N   MSE A 164      18.301  -5.122  62.883  1.00 22.81           N  
HETATM 1246  CA  MSE A 164      18.407  -6.566  63.031  1.00 25.93           C  
HETATM 1247  C   MSE A 164      18.650  -7.075  61.624  1.00 24.80           C  
HETATM 1248  O   MSE A 164      18.297  -6.399  60.678  1.00 25.20           O  
HETATM 1249  CB  MSE A 164      17.120  -7.140  63.610  1.00 23.76           C  
HETATM 1250  CG  MSE A 164      16.724  -6.486  65.039  1.00 24.63           C  
HETATM 1251 SE   MSE A 164      15.164  -7.560  65.637  1.00 39.00          SE  
HETATM 1252  CE  MSE A 164      16.185  -9.261  66.161  1.00 21.18           C  
ATOM   1253  N   ALA A 165      19.240  -8.254  61.503  1.00 23.89           N  
ATOM   1254  CA  ALA A 165      19.502  -8.854  60.217  1.00 25.73           C  
ATOM   1255  C   ALA A 165      19.589 -10.399  60.283  1.00 24.45           C  
ATOM   1256  O   ALA A 165      19.916 -11.003  61.341  1.00 23.98           O  
ATOM   1257  CB  ALA A 165      20.749  -8.254  59.588  1.00 24.61           C  
ATOM   1258  N   ILE A 166      19.296 -11.020  59.155  1.00 23.92           N  
ATOM   1259  CA  ILE A 166      19.525 -12.459  58.995  1.00 25.85           C  
ATOM   1260  C   ILE A 166      20.437 -12.703  57.821  1.00 25.95           C  
ATOM   1261  O   ILE A 166      20.359 -12.002  56.826  1.00 26.24           O  
ATOM   1262  CB  ILE A 166      18.151 -13.246  58.881  1.00 25.36           C  
ATOM   1263  CG1 ILE A 166      18.271 -14.709  59.307  1.00 29.64           C  
ATOM   1264  CG2 ILE A 166      17.494 -13.004  57.501  1.00 27.81           C  
ATOM   1265  CD1 ILE A 166      16.813 -15.368  59.637  1.00 29.36           C  
ATOM   1266  N   ILE A 167      21.338 -13.683  57.939  1.00 28.21           N  
ATOM   1267  CA  ILE A 167      22.248 -14.025  56.834  1.00 28.84           C  
ATOM   1268  C   ILE A 167      21.950 -15.480  56.448  1.00 29.54           C  
ATOM   1269  O   ILE A 167      21.890 -16.358  57.335  1.00 26.29           O  
ATOM   1270  CB  ILE A 167      23.758 -13.746  57.110  1.00 29.59           C  
ATOM   1271  CG1 ILE A 167      24.100 -12.263  56.922  1.00 31.20           C  
ATOM   1272  CG2 ILE A 167      24.718 -14.562  56.153  1.00 27.11           C  
ATOM   1273  CD1 ILE A 167      24.717 -11.821  58.033  1.00 34.38           C  
ATOM   1274  N   PHE A 168      21.665 -15.715  55.144  1.00 30.35           N  
ATOM   1275  CA  PHE A 168      21.339 -17.094  54.715  1.00 32.02           C  
ATOM   1276  C   PHE A 168      22.638 -17.880  54.651  1.00 33.96           C  
ATOM   1277  O   PHE A 168      23.670 -17.396  54.143  1.00 34.09           O  
ATOM   1278  CB  PHE A 168      20.615 -17.157  53.380  1.00 30.01           C  
ATOM   1279  CG  PHE A 168      19.275 -16.548  53.401  1.00 31.14           C  
ATOM   1280  CD1 PHE A 168      18.999 -15.477  52.539  1.00 25.52           C  
ATOM   1281  CD2 PHE A 168      18.265 -17.015  54.325  1.00 27.32           C  
ATOM   1282  CE1 PHE A 168      17.777 -14.879  52.547  1.00 25.07           C  
ATOM   1283  CE2 PHE A 168      17.042 -16.409  54.367  1.00 26.19           C  
ATOM   1284  CZ  PHE A 168      16.766 -15.361  53.460  1.00 29.81           C  
ATOM   1285  N   GLY A 169      22.564 -19.044  55.270  1.00 37.34           N  
ATOM   1286  CA  GLY A 169      23.618 -20.041  55.216  1.00 40.98           C  
ATOM   1287  C   GLY A 169      23.035 -21.107  54.340  1.00 43.33           C  
ATOM   1288  O   GLY A 169      23.795 -21.822  53.696  1.00 47.97           O  
TER    1289      GLY A 169                                                      
END
MOLECULE T0417.pdb
ATOM      1  N   ARG    26      -8.346 -19.992  57.885  1.00 43.52           N  
ATOM      2  CA  ARG    26      -6.996 -20.186  57.309  1.00 42.87           C  
ATOM      3  C   ARG    26      -6.720 -19.292  56.082  1.00 40.26           C  
ATOM      4  O   ARG    26      -7.623 -18.925  55.355  1.00 41.81           O  
ATOM      5  CB  ARG    26      -6.794 -21.646  56.944  1.00 44.22           C  
ATOM      6  CG  ARG    26      -5.528 -22.164  57.568  1.00 50.33           C  
ATOM      7  CD  ARG    26      -4.338 -22.107  56.614  1.00 57.94           C  
ATOM      8  NE  ARG    26      -3.925 -23.473  56.307  1.00 63.20           N  
ATOM      9  CZ  ARG    26      -3.141 -24.214  57.094  1.00 67.19           C  
ATOM     10  NH1 ARG    26      -2.670 -23.712  58.236  1.00 67.80           N  
ATOM     11  NH2 ARG    26      -2.832 -25.469  56.744  1.00 69.45           N  
ATOM     12  N   TYR    27      -5.463 -18.989  55.840  1.00 37.22           N  
ATOM     13  CA  TYR    27      -5.081 -18.034  54.827  1.00 33.87           C  
ATOM     14  C   TYR    27      -4.220 -18.789  53.867  1.00 33.61           C  
ATOM     15  O   TYR    27      -3.593 -19.751  54.270  1.00 34.13           O  
ATOM     16  CB  TYR    27      -4.241 -16.978  55.500  1.00 33.02           C  
ATOM     17  CG  TYR    27      -5.094 -16.062  56.338  1.00 32.33           C  
ATOM     18  CD1 TYR    27      -5.863 -15.072  55.730  1.00 32.08           C  
ATOM     19  CD2 TYR    27      -5.190 -16.215  57.741  1.00 36.16           C  
ATOM     20  CE1 TYR    27      -6.682 -14.200  56.491  1.00 27.91           C  
ATOM     21  CE2 TYR    27      -6.007 -15.357  58.503  1.00 34.22           C  
ATOM     22  CZ  TYR    27      -6.756 -14.378  57.859  1.00 30.13           C  
ATOM     23  OH  TYR    27      -7.556 -13.514  58.581  1.00 32.02           O  
ATOM     24  N   HIS    28      -4.200 -18.399  52.596  1.00 31.38           N  
ATOM     25  CA  HIS    28      -3.133 -18.828  51.704  1.00 29.66           C  
ATOM     26  C   HIS    28      -2.222 -17.609  51.439  1.00 29.79           C  
ATOM     27  O   HIS    28      -2.664 -16.473  51.590  1.00 29.92           O  
ATOM     28  CB  HIS    28      -3.714 -19.387  50.414  1.00 29.69           C  
ATOM     29  CG  HIS    28      -4.733 -18.514  49.781  1.00 27.79           C  
ATOM     30  ND1 HIS    28      -4.406 -17.527  48.880  1.00 33.31           N  
ATOM     31  CD2 HIS    28      -6.075 -18.479  49.906  1.00 27.26           C  
ATOM     32  CE1 HIS    28      -5.499 -16.883  48.515  1.00 30.56           C  
ATOM     33  NE2 HIS    28      -6.527 -17.455  49.111  1.00 34.84           N  
ATOM     34  N   LEU    29      -0.964 -17.859  51.082  1.00 28.47           N  
ATOM     35  CA  LEU    29       0.044 -16.840  50.892  1.00 28.69           C  
ATOM     36  C   LEU    29       0.368 -16.782  49.412  1.00 29.46           C  
ATOM     37  O   LEU    29       0.441 -17.827  48.773  1.00 26.65           O  
ATOM     38  CB  LEU    29       1.315 -17.178  51.633  1.00 28.79           C  
ATOM     39  CG  LEU    29       1.209 -17.332  53.136  1.00 31.32           C  
ATOM     40  CD1 LEU    29       2.584 -17.475  53.797  1.00 31.37           C  
ATOM     41  CD2 LEU    29       0.465 -16.152  53.746  1.00 27.79           C  
ATOM     42  N   ARG    30       0.472 -15.592  48.857  1.00 26.45           N  
ATOM     43  CA  ARG    30       0.850 -15.438  47.421  1.00 28.49           C  
ATOM     44  C   ARG    30       1.503 -14.076  47.223  1.00 28.52           C  
ATOM     45  O   ARG    30       1.246 -13.151  48.023  1.00 28.69           O  
ATOM     46  CB  ARG    30      -0.398 -15.536  46.509  1.00 27.55           C  
ATOM     47  CG  ARG    30      -1.509 -14.555  46.889  1.00 29.96           C  
ATOM     48  CD  ARG    30      -2.569 -14.424  45.782  1.00 30.98           C  
ATOM     49  NE  ARG    30      -3.645 -13.487  46.083  1.00 29.51           N  
ATOM     50  CZ  ARG    30      -3.588 -12.183  45.767  1.00 29.30           C  
ATOM     51  NH1 ARG    30      -2.490 -11.696  45.232  1.00 27.51           N  
ATOM     52  NH2 ARG    30      -4.599 -11.364  46.024  1.00 30.05           N  
ATOM     53  N   PRO    31       2.289 -13.912  46.147  1.00 29.31           N  
ATOM     54  CA  PRO    31       2.781 -12.578  45.785  1.00 29.25           C  
ATOM     55  C   PRO    31       1.576 -11.677  45.522  1.00 28.45           C  
ATOM     56  O   PRO    31       0.538 -12.140  45.040  1.00 28.22           O  
ATOM     57  CB  PRO    31       3.568 -12.793  44.450  1.00 27.62           C  
ATOM     58  CG  PRO    31       3.832 -14.298  44.399  1.00 31.77           C  
ATOM     59  CD  PRO    31       2.775 -14.983  45.244  1.00 31.08           C  
ATOM     60  N   PRO    32       1.722 -10.383  45.776  1.00 28.65           N  
ATOM     61  CA  PRO    32       0.600  -9.513  45.417  1.00 27.94           C  
ATOM     62  C   PRO    32       0.530  -9.334  43.884  1.00 29.66           C  
ATOM     63  O   PRO    32       1.502  -9.662  43.150  1.00 28.33           O  
ATOM     64  CB  PRO    32       0.978  -8.155  46.056  1.00 28.26           C  
ATOM     65  CG  PRO    32       2.525  -8.120  45.941  1.00 27.98           C  
ATOM     66  CD  PRO    32       2.869  -9.652  46.336  1.00 27.09           C  
ATOM     67  N   ARG    33      -0.623  -8.867  43.407  1.00 30.25           N  
ATOM     68  CA  ARG    33      -0.841  -8.522  41.995  1.00 32.43           C  
ATOM     69  C   ARG    33      -1.143  -7.022  42.003  1.00 32.10           C  
ATOM     70  O   ARG    33      -1.538  -6.471  43.032  1.00 30.61           O  
ATOM     71  CB  ARG    33      -2.040  -9.308  41.456  1.00 33.09           C  
ATOM     72  CG  ARG    33      -1.665 -10.826  41.301  1.00 36.12           C  
ATOM     73  CD  ARG    33      -2.773 -11.718  40.723  1.00 38.47           C  
ATOM     74  NE  ARG    33      -3.928 -11.758  41.601  1.00 48.20           N  
ATOM     75  CZ  ARG    33      -4.301 -12.801  42.347  1.00 50.41           C  
ATOM     76  NH1 ARG    33      -3.618 -13.963  42.324  1.00 50.43           N  
ATOM     77  NH2 ARG    33      -5.386 -12.672  43.108  1.00 47.97           N  
ATOM     78  N   ARG    34      -1.037  -6.379  40.845  1.00 32.63           N  
ATOM     79  CA  ARG    34      -1.252  -4.951  40.766  1.00 33.66           C  
ATOM     80  C   ARG    34      -2.555  -4.456  41.359  1.00 33.45           C  
ATOM     81  O   ARG    34      -2.594  -3.395  42.050  1.00 34.67           O  
ATOM     82  CB  ARG    34      -1.219  -4.558  39.287  1.00 36.26           C  
ATOM     83  CG  ARG    34      -0.054  -3.698  38.981  1.00 44.64           C  
ATOM     84  CD  ARG    34      -0.449  -2.237  38.486  1.00 50.45           C  
ATOM     85  NE  ARG    34      -1.377  -2.197  37.345  1.00 50.08           N  
ATOM     86  CZ  ARG    34      -1.109  -2.490  36.060  1.00 50.81           C  
ATOM     87  NH1 ARG    34       0.080  -2.879  35.630  1.00 48.97           N  
ATOM     88  NH2 ARG    34      -2.090  -2.385  35.180  1.00 44.07           N  
ATOM     89  N   ASN    35      -3.622  -5.210  41.135  1.00 31.69           N  
ATOM     90  CA  ASN    35      -4.929  -4.832  41.671  1.00 32.20           C  
ATOM     91  C   ASN    35      -5.137  -5.068  43.185  1.00 32.68           C  
ATOM     92  O   ASN    35      -6.252  -4.815  43.725  1.00 33.44           O  
ATOM     93  CB  ASN    35      -6.052  -5.445  40.842  1.00 32.80           C  
ATOM     94  CG  ASN    35      -6.124  -4.799  39.448  1.00 37.02           C  
ATOM     95  OD1 ASN    35      -5.603  -3.680  39.256  1.00 38.28           O  
ATOM     96  ND2 ASN    35      -6.720  -5.489  38.486  1.00 37.56           N  
ATOM     97  N   ASP    36      -4.080  -5.517  43.875  1.00 31.38           N  
ATOM     98  CA  ASP    36      -4.155  -5.689  45.326  1.00 30.72           C  
ATOM     99  C   ASP    36      -3.811  -4.373  46.002  1.00 31.33           C  
ATOM    100  O   ASP    36      -3.940  -4.265  47.243  1.00 29.20           O  
ATOM    101  CB  ASP    36      -3.145  -6.743  45.823  1.00 30.37           C  
ATOM    102  CG  ASP    36      -3.559  -8.155  45.498  1.00 33.10           C  
ATOM    103  OD1 ASP    36      -4.793  -8.438  45.430  1.00 31.11           O  
ATOM    104  OD2 ASP    36      -2.643  -9.017  45.303  1.00 34.74           O  
ATOM    105  N   GLY    37      -3.302  -3.397  45.233  1.00 28.72           N  
ATOM    106  CA  GLY    37      -2.790  -2.139  45.866  1.00 29.06           C  
ATOM    107  C   GLY    37      -3.772  -1.464  46.818  1.00 27.90           C  
ATOM    108  O   GLY    37      -3.379  -1.073  47.918  1.00 28.59           O  
ATOM    109  N   ALA    38      -5.052  -1.328  46.411  1.00 26.81           N  
ATOM    110  CA  ALA    38      -6.050  -0.648  47.253  1.00 27.86           C  
ATOM    111  C   ALA    38      -6.302  -1.434  48.538  1.00 26.85           C  
ATOM    112  O   ALA    38      -6.393  -0.859  49.613  1.00 26.00           O  
ATOM    113  CB  ALA    38      -7.404  -0.441  46.524  1.00 28.58           C  
ATOM    114  N   ALA    39      -6.420  -2.743  48.423  1.00 26.15           N  
ATOM    115  CA  ALA    39      -6.681  -3.541  49.640  1.00 27.31           C  
ATOM    116  C   ALA    39      -5.485  -3.539  50.585  1.00 26.72           C  
ATOM    117  O   ALA    39      -5.676  -3.566  51.841  1.00 25.98           O  
ATOM    118  CB  ALA    39      -6.981  -4.976  49.266  1.00 28.08           C  
ATOM    119  N   ILE    40      -4.259  -3.510  50.021  1.00 24.99           N  
ATOM    120  CA  ILE    40      -3.084  -3.519  50.875  1.00 25.29           C  
ATOM    121  C   ILE    40      -2.991  -2.167  51.564  1.00 25.64           C  
ATOM    122  O   ILE    40      -2.692  -2.061  52.785  1.00 26.59           O  
ATOM    123  CB  ILE    40      -1.771  -3.842  50.062  1.00 26.37           C  
ATOM    124  CG1 ILE    40      -1.765  -5.307  49.582  1.00 25.21           C  
ATOM    125  CG2 ILE    40      -0.501  -3.482  50.887  1.00 28.01           C  
ATOM    126  CD1 ILE    40      -0.820  -5.493  48.336  1.00 25.71           C  
ATOM    127  N   HIS    41      -3.226  -1.124  50.812  1.00 24.91           N  
ATOM    128  CA  HIS    41      -3.290   0.226  51.415  1.00 26.65           C  
ATOM    129  C   HIS    41      -4.357   0.361  52.532  1.00 27.01           C  
ATOM    130  O   HIS    41      -4.089   0.938  53.614  1.00 27.31           O  
ATOM    131  CB  HIS    41      -3.421   1.257  50.299  1.00 27.52           C  
ATOM    132  CG  HIS    41      -3.471   2.689  50.767  1.00 29.79           C  
ATOM    133  ND1 HIS    41      -4.657   3.352  50.971  1.00 36.10           N  
ATOM    134  CD2 HIS    41      -2.487   3.553  51.120  1.00 30.28           C  
ATOM    135  CE1 HIS    41      -4.394   4.583  51.409  1.00 34.52           C  
ATOM    136  NE2 HIS    41      -3.080   4.732  51.463  1.00 30.04           N  
ATOM    137  N   GLN    42      -5.549  -0.181  52.287  1.00 26.19           N  
ATOM    138  CA  GLN    42      -6.575  -0.203  53.331  1.00 28.05           C  
ATOM    139  C   GLN    42      -6.133  -1.033  54.531  1.00 27.46           C  
ATOM    140  O   GLN    42      -6.320  -0.609  55.663  1.00 25.37           O  
ATOM    141  CB  GLN    42      -7.895  -0.793  52.829  1.00 28.03           C  
ATOM    142  CG  GLN    42      -9.065  -0.608  53.916  1.00 28.66           C  
ATOM    143  CD  GLN    42     -10.414  -1.142  53.475  1.00 33.32           C  
ATOM    144  OE1 GLN    42     -10.612  -1.447  52.300  1.00 41.41           O  
ATOM    145  NE2 GLN    42     -11.368  -1.274  54.435  1.00 35.69           N  
ATOM    146  N   LEU    43      -5.553  -2.207  54.280  1.00 27.33           N  
ATOM    147  CA  LEU    43      -5.006  -3.048  55.404  1.00 26.81           C  
ATOM    148  C   LEU    43      -4.003  -2.253  56.236  1.00 28.18           C  
ATOM    149  O   LEU    43      -4.098  -2.231  57.472  1.00 26.75           O  
ATOM    150  CB  LEU    43      -4.357  -4.340  54.851  1.00 27.64           C  
ATOM    151  CG  LEU    43      -3.543  -5.187  55.878  1.00 28.07           C  
ATOM    152  CD1 LEU    43      -4.447  -5.675  57.026  1.00 28.03           C  
ATOM    153  CD2 LEU    43      -2.696  -6.319  55.219  1.00 26.79           C  
ATOM    154  N   VAL    44      -3.038  -1.578  55.598  1.00 25.32           N  
ATOM    155  CA  VAL    44      -2.092  -0.803  56.424  1.00 27.38           C  
ATOM    156  C   VAL    44      -2.810   0.307  57.189  1.00 28.00           C  
ATOM    157  O   VAL    44      -2.476   0.543  58.374  1.00 28.99           O  
ATOM    158  CB  VAL    44      -0.938  -0.208  55.564  1.00 26.93           C  
ATOM    159  CG1 VAL    44      -0.058   0.721  56.426  1.00 25.38           C  
ATOM    160  CG2 VAL    44      -0.085  -1.372  54.916  1.00 26.21           C  
ATOM    161  N   SER    45      -3.758   1.019  56.558  0.50 29.31           N  
ATOM    163  CA  SER    45      -4.530   2.069  57.290  0.50 28.98           C  
ATOM    165  C   SER    45      -5.204   1.510  58.552  0.50 30.14           C  
ATOM    167  O   SER    45      -5.327   2.219  59.557  0.50 28.81           O  
ATOM    169  CB  SER    45      -5.610   2.739  56.415  0.50 29.99           C  
ATOM    171  OG  SER    45      -6.666   1.839  56.087  0.50 26.42           O  
ATOM    173  N   GLU    46      -5.603   0.235  58.518  1.00 29.41           N  
ATOM    174  CA  GLU    46      -6.333  -0.365  59.663  1.00 30.42           C  
ATOM    175  C   GLU    46      -5.380  -1.115  60.592  1.00 30.61           C  
ATOM    176  O   GLU    46      -5.800  -1.893  61.437  1.00 32.07           O  
ATOM    177  CB  GLU    46      -7.385  -1.351  59.122  1.00 29.60           C  
ATOM    178  CG  GLU    46      -8.561  -0.603  58.445  1.00 30.64           C  
ATOM    179  CD  GLU    46      -9.644  -1.536  57.896  1.00 33.95           C  
ATOM    180  OE1 GLU    46      -9.492  -2.770  58.054  1.00 35.13           O  
ATOM    181  OE2 GLU    46     -10.681  -1.019  57.398  1.00 37.39           O  
ATOM    182  N   CYS    47      -4.082  -0.928  60.402  1.00 29.99           N  
ATOM    183  CA  CYS    47      -3.106  -1.482  61.336  1.00 32.22           C  
ATOM    184  C   CYS    47      -2.233  -0.385  61.990  1.00 33.20           C  
ATOM    185  O   CYS    47      -0.989  -0.469  61.869  1.00 34.01           O  
ATOM    186  CB  CYS    47      -2.151  -2.416  60.602  1.00 31.67           C  
ATOM    187  SG  CYS    47      -2.907  -3.952  59.988  1.00 35.54           S  
ATOM    188  N   PRO    48      -2.848   0.636  62.636  1.00 34.49           N  
ATOM    189  CA  PRO    48      -1.960   1.588  63.288  1.00 36.81           C  
ATOM    190  C   PRO    48      -1.179   0.786  64.356  1.00 38.94           C  
ATOM    191  O   PRO    48      -1.737  -0.126  64.961  1.00 40.76           O  
ATOM    192  CB  PRO    48      -2.923   2.615  63.920  1.00 36.20           C  
ATOM    193  CG  PRO    48      -4.289   1.884  64.025  1.00 35.83           C  
ATOM    194  CD  PRO    48      -4.276   0.968  62.844  1.00 33.95           C  
ATOM    195  N   PRO    49       0.079   1.149  64.617  1.00 39.35           N  
ATOM    196  CA  PRO    49       0.663   2.420  64.271  1.00 38.77           C  
ATOM    197  C   PRO    49       1.584   2.354  63.048  1.00 37.29           C  
ATOM    198  O   PRO    49       2.427   3.245  62.892  1.00 37.46           O  
ATOM    199  CB  PRO    49       1.470   2.748  65.541  1.00 40.01           C  
ATOM    200  CG  PRO    49       2.034   1.303  65.928  1.00 40.37           C  
ATOM    201  CD  PRO    49       1.058   0.279  65.304  1.00 41.34           C  
ATOM    202  N   LEU    50       1.450   1.339  62.184  1.00 33.60           N  
ATOM    203  CA  LEU    50       2.284   1.281  60.981  1.00 31.37           C  
ATOM    204  C   LEU    50       2.182   2.631  60.288  1.00 31.20           C  
ATOM    205  O   LEU    50       1.073   3.172  60.214  1.00 29.83           O  
ATOM    206  CB  LEU    50       1.787   0.209  59.982  1.00 30.89           C  
ATOM    207  CG  LEU    50       2.256  -1.240  60.149  1.00 35.36           C  
ATOM    208  CD1 LEU    50       1.696  -2.152  58.999  1.00 34.13           C  
ATOM    209  CD2 LEU    50       3.791  -1.342  60.257  1.00 39.60           C  
ATOM    210  N   ASP    51       3.285   3.131  59.727  1.00 30.23           N  
ATOM    211  CA  ASP    51       3.265   4.391  58.953  1.00 32.14           C  
ATOM    212  C   ASP    51       2.478   4.083  57.654  1.00 32.72           C  
ATOM    213  O   ASP    51       2.745   3.101  56.961  1.00 33.65           O  
ATOM    214  CB  ASP    51       4.700   4.857  58.586  1.00 32.53           C  
ATOM    215  CG  ASP    51       5.532   5.165  59.820  1.00 36.98           C  
ATOM    216  OD1 ASP    51       4.926   5.494  60.883  1.00 37.69           O  
ATOM    217  OD2 ASP    51       6.775   5.045  59.780  1.00 40.44           O  
ATOM    218  N   LEU    52       1.508   4.921  57.326  1.00 32.10           N  
ATOM    219  CA  LEU    52       0.755   4.713  56.085  1.00 31.13           C  
ATOM    220  C   LEU    52       1.502   5.463  54.972  1.00 30.90           C  
ATOM    221  O   LEU    52       2.012   6.533  55.194  1.00 36.52           O  
ATOM    222  CB  LEU    52      -0.616   5.308  56.262  1.00 32.12           C  
ATOM    223  CG  LEU    52      -1.594   5.045  55.104  1.00 31.45           C  
ATOM    224  CD1 LEU    52      -1.847   3.528  54.862  1.00 31.65           C  
ATOM    225  CD2 LEU    52      -2.930   5.737  55.507  1.00 29.87           C  
ATOM    226  N   ASN    53       1.700   4.857  53.830  1.00 28.39           N  
ATOM    227  CA  ASN    53       2.218   5.593  52.673  1.00 26.31           C  
ATOM    228  C   ASN    53       1.104   5.797  51.683  1.00 26.38           C  
ATOM    229  O   ASN    53      -0.011   5.313  51.913  1.00 25.57           O  
ATOM    230  CB  ASN    53       3.383   4.793  52.074  1.00 25.78           C  
ATOM    231  CG  ASN    53       4.546   4.710  53.057  1.00 27.10           C  
ATOM    232  OD1 ASN    53       5.246   5.690  53.267  1.00 26.14           O  
ATOM    233  ND2 ASN    53       4.730   3.537  53.722  1.00 24.92           N  
ATOM    234  N   SER    54       1.383   6.532  50.596  1.00 25.16           N  
ATOM    235  CA  SER    54       0.354   6.835  49.608  1.00 25.16           C  
ATOM    236  C   SER    54      -0.118   5.530  48.964  1.00 23.53           C  
ATOM    237  O   SER    54       0.604   4.507  48.912  1.00 25.73           O  
ATOM    238  CB  SER    54       0.928   7.784  48.521  1.00 24.19           C  
ATOM    239  OG  SER    54       1.966   7.067  47.822  1.00 26.19           O  
ATOM    240  N   LEU    55      -1.303   5.553  48.411  1.00 23.74           N  
ATOM    241  CA  LEU    55      -1.746   4.390  47.605  1.00 25.96           C  
ATOM    242  C   LEU    55      -0.731   3.952  46.558  1.00 25.61           C  
ATOM    243  O   LEU    55      -0.473   2.753  46.399  1.00 23.93           O  
ATOM    244  CB  LEU    55      -3.088   4.685  46.939  1.00 26.47           C  
ATOM    245  CG  LEU    55      -3.615   3.669  45.903  1.00 29.78           C  
ATOM    246  CD1 LEU    55      -3.842   2.311  46.576  1.00 28.35           C  
ATOM    247  CD2 LEU    55      -4.939   4.191  45.224  1.00 28.94           C  
ATOM    248  N   TYR    56      -0.213   4.934  45.826  1.00 25.77           N  
ATOM    249  CA  TYR    56       0.735   4.673  44.780  1.00 27.07           C  
ATOM    250  C   TYR    56       1.969   3.962  45.279  1.00 25.81           C  
ATOM    251  O   TYR    56       2.496   3.114  44.599  1.00 25.80           O  
ATOM    252  CB  TYR    56       1.128   6.024  44.188  1.00 29.90           C  
ATOM    253  CG  TYR    56       1.860   5.905  42.933  1.00 34.30           C  
ATOM    254  CD1 TYR    56       3.208   6.312  42.863  1.00 36.92           C  
ATOM    255  CD2 TYR    56       1.239   5.418  41.780  1.00 35.76           C  
ATOM    256  CE1 TYR    56       3.924   6.250  41.701  1.00 37.66           C  
ATOM    257  CE2 TYR    56       1.978   5.346  40.576  1.00 41.36           C  
ATOM    258  CZ  TYR    56       3.330   5.756  40.563  1.00 38.17           C  
ATOM    259  OH  TYR    56       4.107   5.744  39.401  1.00 37.72           O  
ATOM    260  N   ALA    57       2.430   4.245  46.498  1.00 24.29           N  
ATOM    261  CA  ALA    57       3.600   3.522  47.027  1.00 24.86           C  
ATOM    262  C   ALA    57       3.300   2.043  47.112  1.00 26.52           C  
ATOM    263  O   ALA    57       4.136   1.206  46.742  1.00 24.62           O  
ATOM    264  CB  ALA    57       4.022   4.041  48.460  1.00 25.11           C  
ATOM    265  N   TYR    58       2.085   1.677  47.549  1.00 25.92           N  
ATOM    266  CA  TYR    58       1.745   0.230  47.523  1.00 25.14           C  
ATOM    267  C   TYR    58       1.544  -0.336  46.094  1.00 25.37           C  
ATOM    268  O   TYR    58       1.884  -1.535  45.820  1.00 26.48           O  
ATOM    269  CB  TYR    58       0.500  -0.037  48.415  1.00 25.30           C  
ATOM    270  CG  TYR    58       0.848   0.366  49.838  1.00 24.22           C  
ATOM    271  CD1 TYR    58       1.712  -0.443  50.613  1.00 26.80           C  
ATOM    272  CD2 TYR    58       0.434   1.600  50.358  1.00 25.73           C  
ATOM    273  CE1 TYR    58       2.119  -0.052  51.862  1.00 24.96           C  
ATOM    274  CE2 TYR    58       0.829   1.997  51.651  1.00 27.42           C  
ATOM    275  CZ  TYR    58       1.666   1.198  52.361  1.00 26.68           C  
ATOM    276  OH  TYR    58       2.082   1.580  53.589  1.00 26.33           O  
ATOM    277  N   LEU    59       0.993   0.480  45.187  1.00 25.53           N  
ATOM    278  CA  LEU    59       0.833   0.052  43.768  1.00 26.65           C  
ATOM    279  C   LEU    59       2.180  -0.248  43.202  1.00 26.90           C  
ATOM    280  O   LEU    59       2.289  -1.219  42.440  1.00 27.73           O  
ATOM    281  CB  LEU    59       0.110   1.081  42.870  1.00 25.95           C  
ATOM    282  CG  LEU    59      -1.395   1.257  43.234  1.00 30.17           C  
ATOM    283  CD1 LEU    59      -1.913   2.436  42.477  1.00 30.73           C  
ATOM    284  CD2 LEU    59      -2.152  -0.020  42.880  1.00 32.85           C  
ATOM    285  N   LEU    60       3.190   0.583  43.522  1.00 26.74           N  
ATOM    286  CA  LEU    60       4.537   0.344  43.009  1.00 28.23           C  
ATOM    287  C   LEU    60       5.175  -0.951  43.581  1.00 26.91           C  
ATOM    288  O   LEU    60       5.850  -1.697  42.847  1.00 28.49           O  
ATOM    289  CB  LEU    60       5.481   1.514  43.288  1.00 27.52           C  
ATOM    290  CG  LEU    60       5.028   2.794  42.542  1.00 31.15           C  
ATOM    291  CD1 LEU    60       6.040   3.877  42.820  1.00 34.27           C  
ATOM    292  CD2 LEU    60       4.895   2.517  41.057  1.00 34.78           C  
ATOM    293  N   LEU    61       4.973  -1.228  44.867  1.00 25.66           N  
ATOM    294  CA  LEU    61       5.355  -2.555  45.438  1.00 25.96           C  
ATOM    295  C   LEU    61       4.708  -3.706  44.668  1.00 27.92           C  
ATOM    296  O   LEU    61       5.395  -4.736  44.312  1.00 26.78           O  
ATOM    297  CB  LEU    61       5.011  -2.631  46.981  1.00 24.03           C  
ATOM    298  CG  LEU    61       5.942  -1.738  47.856  1.00 27.40           C  
ATOM    299  CD1 LEU    61       5.388  -1.555  49.258  1.00 29.42           C  
ATOM    300  CD2 LEU    61       7.378  -2.403  47.930  1.00 29.76           C  
ATOM    301  N   CYS    62       3.395  -3.594  44.426  1.00 28.08           N  
ATOM    302  CA  CYS    62       2.709  -4.622  43.669  1.00 29.95           C  
ATOM    303  C   CYS    62       3.240  -4.775  42.244  1.00 29.03           C  
ATOM    304  O   CYS    62       3.299  -5.879  41.711  1.00 30.81           O  
ATOM    305  CB  CYS    62       1.200  -4.301  43.597  1.00 27.81           C  
ATOM    306  SG  CYS    62       0.452  -4.497  45.273  1.00 32.08           S  
ATOM    307  N   GLU    63       3.606  -3.660  41.614  1.00 28.85           N  
ATOM    308  CA  GLU    63       3.984  -3.672  40.209  1.00 28.77           C  
ATOM    309  C   GLU    63       5.464  -4.057  40.035  1.00 29.21           C  
ATOM    310  O   GLU    63       5.824  -4.806  39.069  1.00 30.46           O  
ATOM    311  CB  GLU    63       3.736  -2.269  39.615  1.00 29.21           C  
ATOM    312  CG  GLU    63       4.011  -2.222  38.117  1.00 37.67           C  
ATOM    313  CD  GLU    63       2.831  -2.733  37.311  1.00 42.55           C  
ATOM    314  OE1 GLU    63       1.874  -3.245  37.919  1.00 43.83           O  
ATOM    315  OE2 GLU    63       2.830  -2.605  36.080  1.00 47.33           O  
ATOM    316  N   HIS    64       6.324  -3.604  40.928  1.00 28.30           N  
ATOM    317  CA  HIS    64       7.798  -3.733  40.703  1.00 29.07           C  
ATOM    318  C   HIS    64       8.499  -4.765  41.608  1.00 29.26           C  
ATOM    319  O   HIS    64       9.634  -5.197  41.280  1.00 28.57           O  
ATOM    320  CB  HIS    64       8.479  -2.370  40.822  1.00 29.01           C  
ATOM    321  CG  HIS    64       7.974  -1.362  39.825  1.00 28.49           C  
ATOM    322  ND1 HIS    64       7.936  -0.007  40.081  1.00 28.38           N  
ATOM    323  CD2 HIS    64       7.526  -1.515  38.553  1.00 24.53           C  
ATOM    324  CE1 HIS    64       7.455   0.620  39.020  1.00 28.14           C  
ATOM    325  NE2 HIS    64       7.188  -0.268  38.084  1.00 28.59           N  
ATOM    326  N   HIS    65       7.854  -5.122  42.726  1.00 28.00           N  
ATOM    327  CA  HIS    65       8.482  -5.882  43.853  1.00 28.52           C  
ATOM    328  C   HIS    65       7.629  -7.053  44.246  1.00 29.11           C  
ATOM    329  O   HIS    65       7.776  -7.583  45.340  1.00 29.42           O  
ATOM    330  CB  HIS    65       8.708  -4.968  45.082  1.00 28.44           C  
ATOM    331  CG  HIS    65       9.696  -3.874  44.804  1.00 29.33           C  
ATOM    332  ND1 HIS    65      11.035  -4.127  44.603  1.00 30.49           N  
ATOM    333  CD2 HIS    65       9.524  -2.546  44.570  1.00 32.03           C  
ATOM    334  CE1 HIS    65      11.659  -2.990  44.321  1.00 31.66           C  
ATOM    335  NE2 HIS    65      10.761  -2.018  44.311  1.00 32.48           N  
ATOM    336  N   ALA    66       6.734  -7.501  43.352  1.00 28.97           N  
ATOM    337  CA  ALA    66       5.850  -8.614  43.755  1.00 27.60           C  
ATOM    338  C   ALA    66       6.614  -9.902  44.162  1.00 29.41           C  
ATOM    339  O   ALA    66       6.172 -10.655  45.061  1.00 28.82           O  
ATOM    340  CB  ALA    66       4.854  -8.887  42.644  1.00 29.50           C  
ATOM    341  N   HIS    67       7.765 -10.160  43.534  0.60 29.35           N  
ATOM    343  CA  HIS    67       8.490 -11.416  43.798  0.60 30.73           C  
ATOM    345  C   HIS    67       9.115 -11.457  45.178  0.60 30.25           C  
ATOM    347  O   HIS    67       9.508 -12.513  45.645  0.60 29.91           O  
ATOM    349  CB  HIS    67       9.601 -11.631  42.783  0.60 32.25           C  
ATOM    351  CG  HIS    67       9.125 -11.876  41.394  0.60 35.76           C  
ATOM    353  ND1 HIS    67       9.303 -10.959  40.383  0.60 39.69           N  
ATOM    355  CD2 HIS    67       8.568 -12.969  40.819  0.60 39.60           C  
ATOM    357  CE1 HIS    67       8.837 -11.458  39.250  0.60 41.13           C  
ATOM    359  NE2 HIS    67       8.387 -12.677  39.488  0.60 41.48           N  
ATOM    361  N   THR    68       9.227 -10.300  45.818  1.00 28.53           N  
ATOM    362  CA  THR    68       9.747 -10.240  47.181  1.00 28.06           C  
ATOM    363  C   THR    68       8.708  -9.731  48.208  1.00 28.01           C  
ATOM    364  O   THR    68       9.051  -9.481  49.362  1.00 29.14           O  
ATOM    365  CB  THR    68      11.022  -9.397  47.274  1.00 30.04           C  
ATOM    366  OG1 THR    68      10.771  -8.060  46.762  1.00 26.74           O  
ATOM    367  CG2 THR    68      12.220 -10.011  46.441  1.00 31.60           C  
ATOM    368  N   CYS    69       7.443  -9.633  47.826  1.00 27.30           N  
ATOM    369  CA  CYS    69       6.393  -9.288  48.810  1.00 26.87           C  
ATOM    370  C   CYS    69       5.367 -10.433  48.918  1.00 25.92           C  
ATOM    371  O   CYS    69       5.385 -11.363  48.094  1.00 26.43           O  
ATOM    372  CB  CYS    69       5.655  -8.042  48.334  1.00 27.03           C  
ATOM    373  SG  CYS    69       6.671  -6.537  48.199  1.00 29.52           S  
ATOM    374  N   VAL    70       4.429 -10.329  49.868  1.00 25.15           N  
ATOM    375  CA  VAL    70       3.463 -11.459  50.034  1.00 25.33           C  
ATOM    376  C   VAL    70       2.195 -10.879  50.632  1.00 25.27           C  
ATOM    377  O   VAL    70       2.272  -9.847  51.365  1.00 26.70           O  
ATOM    378  CB  VAL    70       4.081 -12.638  50.878  1.00 25.62           C  
ATOM    379  CG1 VAL    70       4.301 -12.275  52.327  1.00 26.59           C  
ATOM    380  CG2 VAL    70       3.183 -13.910  50.750  1.00 25.43           C  
ATOM    381  N   VAL    71       1.076 -11.429  50.234  1.00 25.73           N  
ATOM    382  CA  VAL    71      -0.190 -11.197  50.993  1.00 27.02           C  
ATOM    383  C   VAL    71      -0.700 -12.493  51.564  1.00 26.89           C  
ATOM    384  O   VAL    71      -0.501 -13.535  50.944  1.00 27.92           O  
ATOM    385  CB  VAL    71      -1.297 -10.555  50.119  1.00 27.88           C  
ATOM    386  CG1 VAL    71      -0.903  -9.120  49.756  1.00 26.55           C  
ATOM    387  CG2 VAL    71      -1.611 -11.366  48.866  1.00 27.07           C  
ATOM    388  N   ALA    72      -1.436 -12.405  52.674  1.00 27.30           N  
ATOM    389  CA  ALA    72      -2.130 -13.502  53.312  1.00 27.72           C  
ATOM    390  C   ALA    72      -3.597 -13.243  52.984  1.00 27.98           C  
ATOM    391  O   ALA    72      -4.143 -12.189  53.353  1.00 27.81           O  
ATOM    392  CB  ALA    72      -1.937 -13.486  54.849  1.00 27.15           C  
ATOM    393  N   GLU    73      -4.209 -14.196  52.308  1.00 26.27           N  
ATOM    394  CA  GLU    73      -5.556 -14.020  51.806  1.00 28.32           C  
ATOM    395  C   GLU    73      -6.515 -15.094  52.303  1.00 29.00           C  
ATOM    396  O   GLU    73      -6.209 -16.299  52.198  1.00 28.41           O  
ATOM    397  CB  GLU    73      -5.467 -14.007  50.255  1.00 28.70           C  
ATOM    398  CG  GLU    73      -6.788 -13.841  49.492  1.00 28.92           C  
ATOM    399  CD  GLU    73      -6.522 -13.641  47.984  1.00 32.45           C  
ATOM    400  OE1 GLU    73      -6.024 -14.571  47.289  1.00 27.94           O  
ATOM    401  OE2 GLU    73      -6.801 -12.538  47.503  1.00 34.45           O  
ATOM    402  N   SER    74      -7.731 -14.693  52.694  1.00 29.53           N  
ATOM    403  CA  SER    74      -8.765 -15.673  53.061  1.00 29.75           C  
ATOM    404  C   SER    74      -9.286 -16.458  51.828  1.00 30.06           C  
ATOM    405  O   SER    74      -9.107 -16.011  50.712  1.00 27.77           O  
ATOM    406  CB  SER    74      -9.936 -14.966  53.732  1.00 30.66           C  
ATOM    407  OG  SER    74     -10.589 -14.116  52.794  1.00 33.06           O  
ATOM    408  N   PRO    75      -9.921 -17.647  52.036  1.00 30.63           N  
ATOM    409  CA  PRO    75     -10.562 -18.396  50.904  1.00 30.69           C  
ATOM    410  C   PRO    75     -11.463 -17.474  50.086  1.00 30.82           C  
ATOM    411  O   PRO    75     -11.449 -17.542  48.834  1.00 29.53           O  
ATOM    412  CB  PRO    75     -11.374 -19.484  51.618  1.00 31.01           C  
ATOM    413  CG  PRO    75     -10.601 -19.760  52.810  1.00 30.29           C  
ATOM    414  CD  PRO    75     -10.043 -18.416  53.293  1.00 31.30           C  
ATOM    415  N   GLY    76     -12.172 -16.591  50.798  1.00 30.96           N  
ATOM    416  CA  GLY    76     -13.011 -15.519  50.207  1.00 30.50           C  
ATOM    417  C   GLY    76     -12.343 -14.319  49.514  1.00 31.46           C  
ATOM    418  O   GLY    76     -13.030 -13.535  48.852  1.00 30.66           O  
ATOM    419  N   GLY    77     -11.023 -14.190  49.598  1.00 29.19           N  
ATOM    420  CA  GLY    77     -10.339 -13.232  48.775  1.00 29.58           C  
ATOM    421  C   GLY    77     -10.040 -11.977  49.572  1.00 29.53           C  
ATOM    422  O   GLY    77      -9.684 -10.958  48.995  1.00 31.79           O  
ATOM    423  N   ARG    78     -10.136 -12.044  50.913  1.00 28.48           N  
ATOM    424  CA  ARG    78      -9.873 -10.848  51.727  1.00 29.09           C  
ATOM    425  C   ARG    78      -8.425 -10.891  52.217  1.00 27.79           C  
ATOM    426  O   ARG    78      -7.982 -11.872  52.839  1.00 28.43           O  
ATOM    427  CB  ARG    78     -10.794 -10.803  52.962  1.00 29.24           C  
ATOM    428  CG  ARG    78     -10.674  -9.488  53.783  1.00 29.76           C  
ATOM    429  CD  ARG    78     -11.513  -9.608  55.092  1.00 30.71           C  
ATOM    430  NE  ARG    78     -10.958 -10.669  55.938  1.00 31.17           N  
ATOM    431  CZ  ARG    78     -11.537 -11.832  56.204  1.00 32.87           C  
ATOM    432  NH1 ARG    78     -12.743 -12.132  55.723  1.00 34.43           N  
ATOM    433  NH2 ARG    78     -10.906 -12.702  56.957  1.00 36.64           N  
ATOM    434  N   ILE    79      -7.719  -9.822  51.981  1.00 27.39           N  
ATOM    435  CA  ILE    79      -6.320  -9.697  52.406  1.00 27.72           C  
ATOM    436  C   ILE    79      -6.230  -9.202  53.849  1.00 28.74           C  
ATOM    437  O   ILE    79      -6.599  -8.039  54.157  1.00 28.27           O  
ATOM    438  CB  ILE    79      -5.556  -8.770  51.429  1.00 28.98           C  
ATOM    439  CG1 ILE    79      -5.429  -9.520  50.075  1.00 30.29           C  
ATOM    440  CG2 ILE    79      -4.118  -8.429  51.986  1.00 27.53           C  
ATOM    441  CD1 ILE    79      -4.862  -8.613  48.923  1.00 30.41           C  
ATOM    442  N   ASP    80      -5.729 -10.056  54.735  1.00 27.45           N  
ATOM    443  CA  ASP    80      -5.560  -9.637  56.133  1.00 28.66           C  
ATOM    444  C   ASP    80      -4.080  -9.556  56.572  1.00 27.12           C  
ATOM    445  O   ASP    80      -3.786  -9.295  57.764  1.00 27.99           O  
ATOM    446  CB  ASP    80      -6.302 -10.598  57.051  1.00 28.86           C  
ATOM    447  CG  ASP    80      -7.819 -10.442  56.983  1.00 29.39           C  
ATOM    448  OD1 ASP    80      -8.371  -9.422  56.491  1.00 31.63           O  
ATOM    449  OD2 ASP    80      -8.446 -11.373  57.460  1.00 30.70           O  
ATOM    450  N   GLY    81      -3.150  -9.804  55.643  1.00 26.73           N  
ATOM    451  CA  GLY    81      -1.699  -9.790  56.013  1.00 26.35           C  
ATOM    452  C   GLY    81      -0.916  -9.287  54.805  1.00 27.06           C  
ATOM    453  O   GLY    81      -1.327  -9.574  53.665  1.00 27.66           O  
ATOM    454  N   PHE    82       0.183  -8.565  55.018  1.00 26.51           N  
ATOM    455  CA  PHE    82       1.040  -8.138  53.891  1.00 26.78           C  
ATOM    456  C   PHE    82       2.436  -7.997  54.438  1.00 26.45           C  
ATOM    457  O   PHE    82       2.606  -7.593  55.582  1.00 26.97           O  
ATOM    458  CB  PHE    82       0.543  -6.776  53.385  1.00 25.55           C  
ATOM    459  CG  PHE    82       1.472  -6.089  52.406  1.00 26.55           C  
ATOM    460  CD1 PHE    82       1.701  -6.630  51.137  1.00 26.94           C  
ATOM    461  CD2 PHE    82       2.056  -4.829  52.727  1.00 28.61           C  
ATOM    462  CE1 PHE    82       2.527  -6.009  50.209  1.00 29.39           C  
ATOM    463  CE2 PHE    82       2.893  -4.208  51.782  1.00 28.58           C  
ATOM    464  CZ  PHE    82       3.100  -4.773  50.523  1.00 30.95           C  
ATOM    465  N   VAL    83       3.420  -8.399  53.654  1.00 24.94           N  
ATOM    466  CA  VAL    83       4.809  -8.007  53.940  1.00 25.26           C  
ATOM    467  C   VAL    83       5.398  -7.337  52.693  1.00 26.55           C  
ATOM    468  O   VAL    83       5.277  -7.916  51.586  1.00 27.21           O  
ATOM    469  CB  VAL    83       5.703  -9.191  54.368  1.00 25.08           C  
ATOM    470  CG1 VAL    83       7.258  -8.668  54.534  1.00 23.40           C  
ATOM    471  CG2 VAL    83       5.138  -9.776  55.714  1.00 24.17           C  
ATOM    472  N   SER    84       6.012  -6.150  52.867  1.00 26.00           N  
ATOM    473  CA  SER    84       6.812  -5.520  51.787  1.00 25.97           C  
ATOM    474  C   SER    84       8.260  -5.738  52.063  1.00 26.57           C  
ATOM    475  O   SER    84       8.708  -5.526  53.197  1.00 25.75           O  
ATOM    476  CB  SER    84       6.584  -4.009  51.689  1.00 25.69           C  
ATOM    477  OG  SER    84       6.566  -3.433  52.995  1.00 29.89           O  
ATOM    478  N   ALA    85       8.981  -6.155  51.036  1.00 27.38           N  
ATOM    479  CA  ALA    85      10.420  -6.409  51.144  1.00 27.43           C  
ATOM    480  C   ALA    85      11.047  -6.303  49.764  1.00 27.99           C  
ATOM    481  O   ALA    85      10.339  -6.409  48.746  1.00 25.90           O  
ATOM    482  CB  ALA    85      10.675  -7.820  51.749  1.00 26.76           C  
ATOM    483  N   TYR    86      12.373  -6.084  49.720  1.00 26.25           N  
ATOM    484  CA  TYR    86      13.085  -6.054  48.473  1.00 27.19           C  
ATOM    485  C   TYR    86      14.542  -6.332  48.753  1.00 27.01           C  
ATOM    486  O   TYR    86      15.039  -6.099  49.872  1.00 25.54           O  
ATOM    487  CB  TYR    86      12.930  -4.690  47.804  1.00 27.19           C  
ATOM    488  CG  TYR    86      13.222  -3.493  48.675  1.00 27.65           C  
ATOM    489  CD1 TYR    86      14.527  -2.921  48.729  1.00 26.43           C  
ATOM    490  CD2 TYR    86      12.210  -2.877  49.401  1.00 27.98           C  
ATOM    491  CE1 TYR    86      14.770  -1.791  49.539  1.00 29.99           C  
ATOM    492  CE2 TYR    86      12.431  -1.733  50.185  1.00 30.16           C  
ATOM    493  CZ  TYR    86      13.720  -1.206  50.246  1.00 32.84           C  
ATOM    494  OH  TYR    86      13.937  -0.089  51.017  1.00 30.48           O  
ATOM    495  N   LEU    87      15.214  -6.879  47.759  1.00 26.78           N  
ATOM    496  CA  LEU    87      16.639  -7.019  47.832  1.00 28.40           C  
ATOM    497  C   LEU    87      17.296  -5.651  47.732  1.00 29.06           C  
ATOM    498  O   LEU    87      16.846  -4.805  46.947  1.00 29.51           O  
ATOM    499  CB  LEU    87      17.116  -7.862  46.641  1.00 30.26           C  
ATOM    500  CG  LEU    87      16.613  -9.329  46.576  1.00 29.46           C  
ATOM    501  CD1 LEU    87      17.072 -10.058  45.319  1.00 32.72           C  
ATOM    502  CD2 LEU    87      16.986 -10.139  47.841  1.00 31.05           C  
ATOM    503  N   LEU    88      18.399  -5.442  48.443  1.00 28.70           N  
ATOM    504  CA  LEU    88      19.029  -4.130  48.394  1.00 28.59           C  
ATOM    505  C   LEU    88      19.777  -4.026  47.070  1.00 30.73           C  
ATOM    506  O   LEU    88      20.589  -4.925  46.752  1.00 29.24           O  
ATOM    507  CB  LEU    88      19.982  -3.936  49.566  1.00 28.02           C  
ATOM    508  CG  LEU    88      19.293  -3.794  50.934  1.00 28.39           C  
ATOM    509  CD1 LEU    88      20.279  -3.314  52.018  1.00 28.39           C  
ATOM    510  CD2 LEU    88      18.090  -2.853  50.809  1.00 26.20           C  
ATOM    511  N   PRO    89      19.537  -2.943  46.296  1.00 30.42           N  
ATOM    512  CA  PRO    89      20.219  -2.804  45.014  1.00 32.20           C  
ATOM    513  C   PRO    89      21.762  -2.825  45.095  1.00 32.91           C  
ATOM    514  O   PRO    89      22.425  -3.382  44.199  1.00 33.87           O  
ATOM    515  CB  PRO    89      19.708  -1.448  44.501  1.00 32.80           C  
ATOM    516  CG  PRO    89      18.473  -1.242  45.189  1.00 31.04           C  
ATOM    517  CD  PRO    89      18.620  -1.817  46.540  1.00 31.51           C  
ATOM    518  N   THR    90      22.337  -2.280  46.161  1.00 32.94           N  
ATOM    519  CA  THR    90      23.789  -2.281  46.248  1.00 34.09           C  
ATOM    520  C   THR    90      24.321  -3.484  47.014  1.00 34.35           C  
ATOM    521  O   THR    90      25.531  -3.772  46.941  1.00 33.12           O  
ATOM    522  CB  THR    90      24.364  -1.030  46.892  1.00 34.66           C  
ATOM    523  OG1 THR    90      23.788  -0.864  48.187  1.00 36.62           O  
ATOM    524  CG2 THR    90      24.133   0.240  46.006  1.00 37.20           C  
ATOM    525  N   ARG    91      23.439  -4.200  47.712  1.00 34.03           N  
ATOM    526  CA  ARG    91      23.827  -5.406  48.446  1.00 34.30           C  
ATOM    527  C   ARG    91      22.786  -6.492  48.219  1.00 33.97           C  
ATOM    528  O   ARG    91      21.987  -6.779  49.116  1.00 33.10           O  
ATOM    529  CB  ARG    91      23.918  -5.099  49.926  1.00 35.32           C  
ATOM    530  CG  ARG    91      25.038  -4.153  50.228  1.00 39.65           C  
ATOM    531  CD  ARG    91      25.081  -3.830  51.694  1.00 45.30           C  
ATOM    532  NE  ARG    91      24.050  -2.895  52.145  1.00 49.53           N  
ATOM    533  CZ  ARG    91      23.387  -3.038  53.299  1.00 51.32           C  
ATOM    534  NH1 ARG    91      23.644  -4.086  54.070  1.00 49.57           N  
ATOM    535  NH2 ARG    91      22.462  -2.149  53.688  1.00 50.88           N  
ATOM    536  N   PRO    92      22.792  -7.093  47.026  1.00 33.68           N  
ATOM    537  CA  PRO    92      21.701  -7.972  46.605  1.00 34.12           C  
ATOM    538  C   PRO    92      21.529  -9.270  47.384  1.00 33.82           C  
ATOM    539  O   PRO    92      20.458  -9.870  47.262  1.00 34.58           O  
ATOM    540  CB  PRO    92      21.993  -8.218  45.119  1.00 34.48           C  
ATOM    541  CG  PRO    92      23.428  -7.960  44.972  1.00 33.03           C  
ATOM    542  CD  PRO    92      23.810  -6.941  45.975  1.00 33.84           C  
ATOM    543  N   ASP    93      22.505  -9.659  48.225  1.00 32.31           N  
ATOM    544  CA  ASP    93      22.354 -10.778  49.163  1.00 31.47           C  
ATOM    545  C   ASP    93      21.700 -10.408  50.513  1.00 30.90           C  
ATOM    546  O   ASP    93      21.653 -11.211  51.457  1.00 28.55           O  
ATOM    547  CB  ASP    93      23.721 -11.478  49.413  1.00 33.27           C  
ATOM    548  CG  ASP    93      24.676 -10.625  50.245  1.00 36.78           C  
ATOM    549  OD1 ASP    93      24.443  -9.409  50.429  1.00 40.28           O  
ATOM    550  OD2 ASP    93      25.710 -11.163  50.697  1.00 43.64           O  
ATOM    551  N   VAL    94      21.249  -9.162  50.603  1.00 28.87           N  
ATOM    552  CA  VAL    94      20.457  -8.699  51.733  1.00 28.13           C  
ATOM    553  C   VAL    94      18.981  -8.470  51.323  1.00 28.96           C  
ATOM    554  O   VAL    94      18.695  -7.666  50.418  1.00 28.15           O  
ATOM    555  CB  VAL    94      21.014  -7.370  52.297  1.00 27.32           C  
ATOM    556  CG1 VAL    94      20.109  -6.882  53.458  1.00 27.98           C  
ATOM    557  CG2 VAL    94      22.492  -7.527  52.792  1.00 29.25           C  
ATOM    558  N   LEU    95      18.049  -9.079  52.061  1.00 26.89           N  
ATOM    559  CA  LEU    95      16.633  -8.800  51.864  1.00 26.64           C  
ATOM    560  C   LEU    95      16.230  -7.805  52.970  1.00 27.06           C  
ATOM    561  O   LEU    95      16.477  -8.060  54.160  1.00 28.69           O  
ATOM    562  CB  LEU    95      15.839 -10.098  52.041  1.00 26.26           C  
ATOM    563  CG  LEU    95      14.311  -9.916  51.928  1.00 25.34           C  
ATOM    564  CD1 LEU    95      13.952  -9.685  50.455  1.00 26.94           C  
ATOM    565  CD2 LEU    95      13.604 -11.178  52.432  1.00 32.15           C  
ATOM    566  N   PHE    96      15.679  -6.662  52.566  1.00 27.52           N  
ATOM    567  CA  PHE    96      15.202  -5.675  53.517  1.00 27.55           C  
ATOM    568  C   PHE    96      13.662  -5.765  53.640  1.00 27.78           C  
ATOM    569  O   PHE    96      13.003  -5.745  52.644  1.00 26.91           O  
ATOM    570  CB  PHE    96      15.624  -4.282  53.085  1.00 26.56           C  
ATOM    571  CG  PHE    96      15.205  -3.242  54.081  1.00 30.36           C  
ATOM    572  CD1 PHE    96      15.994  -2.996  55.197  1.00 29.09           C  
ATOM    573  CD2 PHE    96      14.000  -2.540  53.906  1.00 30.48           C  
ATOM    574  CE1 PHE    96      15.624  -2.047  56.130  1.00 31.88           C  
ATOM    575  CE2 PHE    96      13.606  -1.623  54.848  1.00 29.42           C  
ATOM    576  CZ  PHE    96      14.449  -1.386  55.971  1.00 30.26           C  
ATOM    577  N   VAL    97      13.159  -5.909  54.858  1.00 27.66           N  
ATOM    578  CA  VAL    97      11.740  -5.976  55.159  1.00 27.14           C  
ATOM    579  C   VAL    97      11.297  -4.597  55.617  1.00 27.86           C  
ATOM    580  O   VAL    97      11.792  -4.058  56.629  1.00 28.05           O  
ATOM    581  CB  VAL    97      11.463  -7.017  56.234  1.00 28.05           C  
ATOM    582  CG1 VAL    97       9.912  -6.967  56.658  1.00 29.13           C  
ATOM    583  CG2 VAL    97      11.846  -8.350  55.699  1.00 25.98           C  
ATOM    584  N   TRP    98      10.354  -4.026  54.869  1.00 28.94           N  
ATOM    585  CA  TRP    98       9.929  -2.623  55.103  1.00 28.42           C  
ATOM    586  C   TRP    98       8.756  -2.633  56.049  1.00 29.26           C  
ATOM    587  O   TRP    98       8.878  -2.057  57.123  1.00 30.60           O  
ATOM    588  CB  TRP    98       9.587  -1.950  53.765  1.00 27.55           C  
ATOM    589  CG  TRP    98       9.016  -0.590  53.807  1.00 29.09           C  
ATOM    590  CD1 TRP    98       8.785   0.229  54.912  1.00 29.88           C  
ATOM    591  CD2 TRP    98       8.665   0.161  52.671  1.00 30.40           C  
ATOM    592  NE1 TRP    98       8.276   1.440  54.481  1.00 31.04           N  
ATOM    593  CE2 TRP    98       8.181   1.403  53.109  1.00 29.25           C  
ATOM    594  CE3 TRP    98       8.633  -0.145  51.311  1.00 29.88           C  
ATOM    595  CZ2 TRP    98       7.711   2.365  52.224  1.00 31.90           C  
ATOM    596  CZ3 TRP    98       8.212   0.814  50.395  1.00 34.17           C  
ATOM    597  CH2 TRP    98       7.725   2.058  50.859  1.00 30.83           C  
ATOM    598  N   GLN    99       7.614  -3.248  55.678  1.00 25.62           N  
ATOM    599  CA  GLN    99       6.445  -3.289  56.588  1.00 26.52           C  
ATOM    600  C   GLN    99       5.901  -4.710  56.728  1.00 28.09           C  
ATOM    601  O   GLN    99       5.874  -5.466  55.739  1.00 27.74           O  
ATOM    602  CB  GLN    99       5.323  -2.376  56.038  1.00 27.16           C  
ATOM    603  CG  GLN    99       5.757  -0.913  56.070  1.00 29.38           C  
ATOM    604  CD  GLN    99       4.585  -0.002  55.814  1.00 31.01           C  
ATOM    605  OE1 GLN    99       3.976  -0.061  54.750  1.00 29.00           O  
ATOM    606  NE2 GLN    99       4.288   0.883  56.780  1.00 29.69           N  
ATOM    607  N   VAL   100       5.489  -5.065  57.952  1.00 27.68           N  
ATOM    608  CA  VAL   100       4.776  -6.322  58.221  1.00 28.76           C  
ATOM    609  C   VAL   100       3.442  -5.927  58.797  1.00 28.50           C  
ATOM    610  O   VAL   100       3.362  -5.389  59.917  1.00 27.91           O  
ATOM    611  CB  VAL   100       5.543  -7.191  59.220  1.00 28.90           C  
ATOM    612  CG1 VAL   100       4.801  -8.560  59.495  1.00 29.29           C  
ATOM    613  CG2 VAL   100       6.949  -7.415  58.687  1.00 29.67           C  
ATOM    614  N   ALA   101       2.389  -6.094  58.015  1.00 28.23           N  
ATOM    615  CA  ALA   101       1.018  -5.732  58.462  1.00 28.21           C  
ATOM    616  C   ALA   101       0.213  -7.007  58.723  1.00 29.52           C  
ATOM    617  O   ALA   101       0.076  -7.861  57.847  1.00 28.87           O  
ATOM    618  CB  ALA   101       0.330  -4.906  57.384  1.00 30.21           C  
ATOM    619  N   VAL   102      -0.331  -7.127  59.925  1.00 27.61           N  
ATOM    620  CA  VAL   102      -1.207  -8.267  60.262  1.00 28.64           C  
ATOM    621  C   VAL   102      -2.467  -7.696  60.876  1.00 28.88           C  
ATOM    622  O   VAL   102      -2.410  -7.021  61.930  1.00 28.99           O  
ATOM    623  CB  VAL   102      -0.509  -9.219  61.211  1.00 30.54           C  
ATOM    624  CG1 VAL   102      -1.434 -10.307  61.667  1.00 29.44           C  
ATOM    625  CG2 VAL   102       0.720  -9.834  60.558  1.00 28.25           C  
ATOM    626  N   HIS   103      -3.588  -7.835  60.202  1.00 27.37           N  
ATOM    627  CA  HIS   103      -4.831  -7.244  60.725  1.00 26.76           C  
ATOM    628  C   HIS   103      -5.227  -7.777  62.118  1.00 29.75           C  
ATOM    629  O   HIS   103      -4.967  -8.922  62.406  1.00 26.61           O  
ATOM    630  CB  HIS   103      -5.977  -7.524  59.754  1.00 28.19           C  
ATOM    631  CG  HIS   103      -7.130  -6.578  59.921  1.00 28.76           C  
ATOM    632  ND1 HIS   103      -8.104  -6.757  60.883  1.00 29.49           N  
ATOM    633  CD2 HIS   103      -7.419  -5.406  59.298  1.00 30.28           C  
ATOM    634  CE1 HIS   103      -8.984  -5.771  60.801  1.00 31.84           C  
ATOM    635  NE2 HIS   103      -8.599  -4.942  59.840  1.00 32.54           N  
ATOM    636  N   SER   104      -5.849  -6.953  62.977  1.00 31.60           N  
ATOM    637  CA  SER   104      -6.337  -7.442  64.270  1.00 34.74           C  
ATOM    638  C   SER   104      -7.262  -8.656  64.158  1.00 35.83           C  
ATOM    639  O   SER   104      -7.247  -9.472  65.043  1.00 36.87           O  
ATOM    640  CB  SER   104      -7.006  -6.316  65.117  1.00 35.80           C  
ATOM    641  OG  SER   104      -7.916  -5.455  64.372  1.00 39.13           O  
ATOM    642  N   ARG   105      -8.035  -8.808  63.065  1.00 37.04           N  
ATOM    643  CA  ARG   105      -8.992  -9.939  62.956  1.00 37.31           C  
ATOM    644  C   ARG   105      -8.196 -11.217  62.655  1.00 37.29           C  
ATOM    645  O   ARG   105      -8.738 -12.293  62.691  1.00 38.32           O  
ATOM    646  CB  ARG   105     -10.059  -9.717  61.859  1.00 37.38           C  
ATOM    647  CG  ARG   105      -9.546  -9.922  60.417  1.00 37.50           C  
ATOM    648  CD  ARG   105     -10.593  -9.682  59.304  1.00 35.81           C  
ATOM    649  NE  ARG   105     -11.210  -8.341  59.366  1.00 34.57           N  
ATOM    650  CZ  ARG   105     -10.934  -7.297  58.581  1.00 34.77           C  
ATOM    651  NH1 ARG   105     -11.615  -6.151  58.758  1.00 35.83           N  
ATOM    652  NH2 ARG   105      -9.995  -7.344  57.621  1.00 33.39           N  
ATOM    653  N   ALA   106      -6.906 -11.082  62.357  1.00 36.73           N  
ATOM    654  CA  ALA   106      -6.086 -12.231  61.957  1.00 37.30           C  
ATOM    655  C   ALA   106      -5.017 -12.644  62.990  1.00 38.82           C  
ATOM    656  O   ALA   106      -4.114 -13.416  62.680  1.00 38.52           O  
ATOM    657  CB  ALA   106      -5.448 -11.964  60.585  1.00 37.06           C  
ATOM    658  N   ARG   107      -5.113 -12.088  64.193  1.00 40.42           N  
ATOM    659  CA  ARG   107      -4.285 -12.497  65.359  1.00 43.16           C  
ATOM    660  C   ARG   107      -4.401 -13.970  65.700  1.00 42.97           C  
ATOM    661  O   ARG   107      -5.462 -14.594  65.532  1.00 43.89           O  
ATOM    662  CB  ARG   107      -4.697 -11.717  66.605  1.00 43.97           C  
ATOM    663  CG  ARG   107      -4.300 -10.277  66.532  1.00 48.79           C  
ATOM    664  CD  ARG   107      -2.970 -10.143  65.803  1.00 55.48           C  
ATOM    665  NE  ARG   107      -2.759  -8.786  65.308  1.00 59.99           N  
ATOM    666  CZ  ARG   107      -1.573  -8.275  65.013  1.00 62.07           C  
ATOM    667  NH1 ARG   107      -0.462  -9.010  65.150  1.00 62.83           N  
ATOM    668  NH2 ARG   107      -1.500  -7.023  64.583  1.00 65.01           N  
ATOM    669  N   GLY   108      -3.309 -14.542  66.178  1.00 43.59           N  
ATOM    670  CA  GLY   108      -3.320 -15.943  66.575  1.00 43.64           C  
ATOM    671  C   GLY   108      -3.065 -16.904  65.432  1.00 44.48           C  
ATOM    672  O   GLY   108      -3.261 -18.093  65.594  1.00 43.64           O  
ATOM    673  N   HIS   109      -2.608 -16.401  64.287  1.00 43.96           N  
ATOM    674  CA  HIS   109      -2.318 -17.277  63.159  1.00 44.81           C  
ATOM    675  C   HIS   109      -0.822 -17.262  62.841  1.00 44.35           C  
ATOM    676  O   HIS   109      -0.394 -17.882  61.834  1.00 44.94           O  
ATOM    677  CB  HIS   109      -3.116 -16.847  61.894  1.00 45.94           C  
ATOM    678  CG  HIS   109      -4.601 -17.074  61.993  1.00 50.00           C  
ATOM    679  ND1 HIS   109      -5.217 -18.210  61.501  1.00 53.82           N  
ATOM    680  CD2 HIS   109      -5.593 -16.306  62.513  1.00 52.01           C  
ATOM    681  CE1 HIS   109      -6.521 -18.140  61.732  1.00 54.79           C  
ATOM    682  NE2 HIS   109      -6.776 -16.990  62.337  1.00 53.31           N  
ATOM    683  N   ARG   110      -0.046 -16.504  63.638  1.00 42.56           N  
ATOM    684  CA  ARG   110       1.387 -16.316  63.418  1.00 41.19           C  
ATOM    685  C   ARG   110       1.656 -15.936  61.948  1.00 38.86           C  
ATOM    686  O   ARG   110       2.615 -16.457  61.312  1.00 36.36           O  
ATOM    687  CB  ARG   110       2.109 -17.608  63.749  1.00 42.35           C  
ATOM    688  CG  ARG   110       3.175 -17.478  64.793  1.00 49.54           C  
ATOM    689  CD  ARG   110       2.709 -17.960  66.144  1.00 56.27           C  
ATOM    690  NE  ARG   110       3.830 -18.483  66.941  1.00 63.66           N  
ATOM    691  CZ  ARG   110       3.741 -18.939  68.202  1.00 66.48           C  
ATOM    692  NH1 ARG   110       2.579 -18.942  68.859  1.00 67.31           N  
ATOM    693  NH2 ARG   110       4.829 -19.393  68.825  1.00 66.34           N  
ATOM    694  N   LEU   111       0.803 -15.063  61.399  1.00 36.64           N  
ATOM    695  CA  LEU   111       0.934 -14.711  60.004  1.00 36.13           C  
ATOM    696  C   LEU   111       2.263 -14.069  59.730  1.00 35.20           C  
ATOM    697  O   LEU   111       2.786 -14.268  58.647  1.00 35.02           O  
ATOM    698  CB  LEU   111      -0.134 -13.715  59.503  1.00 37.49           C  
ATOM    699  CG  LEU   111      -1.445 -14.246  58.935  1.00 40.47           C  
ATOM    700  CD1 LEU   111      -2.185 -13.067  58.293  1.00 36.90           C  
ATOM    701  CD2 LEU   111      -1.187 -15.437  57.981  1.00 41.44           C  
ATOM    702  N   GLY   112       2.775 -13.237  60.656  1.00 33.27           N  
ATOM    703  CA  GLY   112       4.015 -12.473  60.342  1.00 32.76           C  
ATOM    704  C   GLY   112       5.179 -13.418  60.021  1.00 33.00           C  
ATOM    705  O   GLY   112       5.776 -13.354  58.948  1.00 30.20           O  
ATOM    706  N   ARG   113       5.428 -14.370  60.914  1.00 32.81           N  
ATOM    707  CA  ARG   113       6.415 -15.429  60.648  1.00 34.49           C  
ATOM    708  C   ARG   113       6.133 -16.288  59.440  1.00 32.25           C  
ATOM    709  O   ARG   113       7.054 -16.581  58.686  1.00 31.91           O  
ATOM    710  CB  ARG   113       6.688 -16.370  61.862  1.00 36.39           C  
ATOM    711  CG  ARG   113       5.730 -16.223  62.962  1.00 43.11           C  
ATOM    712  CD  ARG   113       6.218 -15.164  63.983  1.00 49.74           C  
ATOM    713  NE  ARG   113       7.038 -15.759  65.049  1.00 55.53           N  
ATOM    714  CZ  ARG   113       6.763 -15.684  66.340  1.00 54.24           C  
ATOM    715  NH1 ARG   113       7.601 -16.206  67.206  1.00 58.55           N  
ATOM    716  NH2 ARG   113       5.691 -15.044  66.758  1.00 57.00           N  
ATOM    717  N   ALA   114       4.877 -16.694  59.225  1.00 31.63           N  
ATOM    718  CA  ALA   114       4.552 -17.457  57.989  1.00 31.72           C  
ATOM    719  C   ALA   114       4.884 -16.676  56.693  1.00 31.78           C  
ATOM    720  O   ALA   114       5.430 -17.231  55.716  1.00 30.96           O  
ATOM    721  CB  ALA   114       3.104 -17.838  57.959  1.00 31.23           C  
ATOM    722  N   MET   115       4.512 -15.410  56.693  1.00 29.72           N  
ATOM    723  CA  MET   115       4.727 -14.548  55.539  1.00 31.83           C  
ATOM    724  C   MET   115       6.214 -14.314  55.284  1.00 30.40           C  
ATOM    725  O   MET   115       6.680 -14.435  54.137  1.00 30.20           O  
ATOM    726  CB  MET   115       3.932 -13.262  55.684  1.00 31.94           C  
ATOM    727  CG  MET   115       2.395 -13.472  55.437  1.00 30.62           C  
ATOM    728  SD  MET   115       1.599 -11.668  55.459  0.85 34.94          SE  
ATOM    729  CE  MET   115       1.955 -11.047  57.300  1.00 26.83           C  
ATOM    730  N   LEU   116       6.972 -14.034  56.337  1.00 30.11           N  
ATOM    731  CA  LEU   116       8.423 -13.855  56.183  1.00 30.42           C  
ATOM    732  C   LEU   116       9.132 -15.107  55.659  1.00 30.52           C  
ATOM    733  O   LEU   116       9.966 -15.028  54.732  1.00 30.68           O  
ATOM    734  CB  LEU   116       9.049 -13.363  57.495  1.00 29.45           C  
ATOM    735  CG  LEU   116       8.651 -11.953  57.913  1.00 32.33           C  
ATOM    736  CD1 LEU   116       9.015 -11.816  59.419  1.00 35.29           C  
ATOM    737  CD2 LEU   116       9.393 -10.887  57.089  1.00 34.27           C  
ATOM    738  N   GLY   117       8.811 -16.250  56.264  1.00 31.60           N  
ATOM    739  CA  GLY   117       9.225 -17.559  55.761  1.00 32.49           C  
ATOM    740  C   GLY   117       8.870 -17.829  54.321  1.00 33.44           C  
ATOM    741  O   GLY   117       9.713 -18.309  53.581  1.00 34.87           O  
ATOM    742  N   HIS   118       7.643 -17.520  53.908  1.00 32.19           N  
ATOM    743  CA  HIS   118       7.239 -17.655  52.513  1.00 31.65           C  
ATOM    744  C   HIS   118       8.130 -16.889  51.551  1.00 31.42           C  
ATOM    745  O   HIS   118       8.502 -17.405  50.498  1.00 32.19           O  
ATOM    746  CB  HIS   118       5.788 -17.174  52.319  1.00 32.80           C  
ATOM    747  CG  HIS   118       5.195 -17.549  50.997  1.00 32.35           C  
ATOM    748  ND1 HIS   118       5.266 -16.733  49.890  1.00 35.08           N  
ATOM    749  CD2 HIS   118       4.491 -18.640  50.612  1.00 31.11           C  
ATOM    750  CE1 HIS   118       4.647 -17.311  48.877  1.00 34.92           C  
ATOM    751  NE2 HIS   118       4.152 -18.462  49.292  1.00 36.60           N  
ATOM    752  N   ILE   119       8.438 -15.634  51.861  1.00 27.83           N  
ATOM    753  CA  ILE   119       9.319 -14.863  50.990  1.00 28.68           C  
ATOM    754  C   ILE   119      10.745 -15.432  50.966  1.00 29.77           C  
ATOM    755  O   ILE   119      11.387 -15.563  49.902  1.00 30.26           O  
ATOM    756  CB  ILE   119       9.361 -13.371  51.418  1.00 26.17           C  
ATOM    757  CG1 ILE   119       7.980 -12.759  51.268  1.00 27.11           C  
ATOM    758  CG2 ILE   119      10.388 -12.629  50.564  1.00 30.42           C  
ATOM    759  CD1 ILE   119       7.882 -11.398  51.963  1.00 24.95           C  
ATOM    760  N   LEU   120      11.245 -15.784  52.125  1.00 32.96           N  
ATOM    761  CA  LEU   120      12.586 -16.346  52.212  1.00 33.74           C  
ATOM    762  C   LEU   120      12.776 -17.641  51.474  1.00 35.19           C  
ATOM    763  O   LEU   120      13.885 -17.917  51.013  1.00 34.94           O  
ATOM    764  CB  LEU   120      13.022 -16.521  53.656  1.00 33.50           C  
ATOM    765  CG  LEU   120      13.470 -15.247  54.371  1.00 35.70           C  
ATOM    766  CD1 LEU   120      13.544 -15.502  55.849  1.00 38.36           C  
ATOM    767  CD2 LEU   120      14.790 -14.698  53.812  1.00 39.50           C  
ATOM    768  N   GLU   121      11.702 -18.426  51.372  0.50 35.23           N  
ATOM    770  CA  GLU   121      11.690 -19.720  50.677  0.50 35.62           C  
ATOM    772  C   GLU   121      11.723 -19.618  49.173  0.50 35.75           C  
ATOM    774  O   GLU   121      12.049 -20.587  48.503  0.50 34.88           O  
ATOM    776  CB  GLU   121      10.452 -20.526  51.071  0.50 36.69           C  
ATOM    778  CG  GLU   121      10.598 -21.296  52.369  0.50 39.07           C  
ATOM    780  CD  GLU   121      11.349 -22.608  52.206  0.50 42.94           C  
ATOM    782  OE1 GLU   121      12.548 -22.658  52.579  0.50 43.73           O  
ATOM    784  OE2 GLU   121      10.745 -23.587  51.700  0.50 45.46           O  
ATOM    786  N   ARG   122      11.381 -18.453  48.636  1.00 34.98           N  
ATOM    787  CA  ARG   122      11.326 -18.266  47.196  1.00 36.09           C  
ATOM    788  C   ARG   122      12.649 -18.336  46.465  1.00 36.25           C  
ATOM    789  O   ARG   122      13.711 -17.971  47.010  1.00 35.35           O  
ATOM    790  CB  ARG   122      10.743 -16.923  46.844  1.00 34.73           C  
ATOM    791  CG  ARG   122       9.356 -16.751  47.422  1.00 36.99           C  
ATOM    792  CD  ARG   122       8.745 -15.495  46.945  1.00 33.49           C  
ATOM    793  NE  ARG   122       7.382 -15.449  47.459  1.00 31.96           N  
ATOM    794  CZ  ARG   122       6.671 -14.329  47.496  1.00 31.99           C  
ATOM    795  NH1 ARG   122       7.199 -13.234  46.988  1.00 29.85           N  
ATOM    796  NH2 ARG   122       5.442 -14.317  47.987  1.00 32.40           N  
ATOM    797  N   GLN   123      12.554 -18.771  45.212  0.50 36.89           N  
ATOM    799  CA  GLN   123      13.699 -18.931  44.318  0.50 37.61           C  
ATOM    801  C   GLN   123      14.442 -17.601  44.099  0.50 37.74           C  
ATOM    803  O   GLN   123      15.666 -17.585  43.942  0.50 37.85           O  
ATOM    805  CB  GLN   123      13.247 -19.587  42.994  0.50 38.09           C  
ATOM    807  CG  GLN   123      11.711 -19.523  42.707  0.50 40.02           C  
ATOM    809  CD  GLN   123      10.839 -20.426  43.616  0.50 41.57           C  
ATOM    811  OE1 GLN   123       9.933 -19.950  44.313  0.50 39.31           O  
ATOM    813  NE2 GLN   123      11.107 -21.733  43.587  0.50 41.50           N  
ATOM    815  N   GLU   124      13.700 -16.488  44.149  1.00 37.77           N  
ATOM    816  CA  GLU   124      14.272 -15.133  44.085  1.00 37.11           C  
ATOM    817  C   GLU   124      15.204 -14.802  45.267  1.00 35.47           C  
ATOM    818  O   GLU   124      16.125 -13.991  45.123  1.00 36.09           O  
ATOM    819  CB  GLU   124      13.150 -14.074  43.971  1.00 39.80           C  
ATOM    820  CG  GLU   124      12.278 -14.197  42.672  1.00 45.55           C  
ATOM    821  CD  GLU   124      11.085 -15.181  42.758  1.00 49.57           C  
ATOM    822  OE1 GLU   124      11.156 -16.209  43.448  1.00 51.25           O  
ATOM    823  OE2 GLU   124      10.046 -14.917  42.113  1.00 56.74           O  
ATOM    824  N   CYS   125      14.997 -15.449  46.411  1.00 33.75           N  
ATOM    825  CA  CYS   125      15.797 -15.175  47.634  1.00 33.53           C  
ATOM    826  C   CYS   125      16.823 -16.283  47.909  1.00 34.23           C  
ATOM    827  O   CYS   125      17.407 -16.338  48.992  1.00 33.76           O  
ATOM    828  CB  CYS   125      14.878 -14.981  48.857  1.00 31.65           C  
ATOM    829  SG  CYS   125      13.774 -13.531  48.696  1.00 34.67           S  
ATOM    830  N   ARG   126      17.049 -17.157  46.937  0.50 34.15           N  
ATOM    832  CA  ARG   126      17.935 -18.304  47.165  0.50 34.77           C  
ATOM    834  C   ARG   126      19.400 -17.918  47.418  0.50 34.37           C  
ATOM    836  O   ARG   126      20.183 -18.740  47.907  0.50 34.03           O  
ATOM    838  CB  ARG   126      17.821 -19.319  46.026  0.50 35.04           C  
ATOM    840  CG  ARG   126      18.333 -18.817  44.678  0.50 37.29           C  
ATOM    842  CD  ARG   126      17.579 -19.487  43.545  0.50 41.20           C  
ATOM    844  NE  ARG   126      17.995 -19.010  42.229  0.50 42.67           N  
ATOM    846  CZ  ARG   126      17.783 -19.681  41.102  0.50 43.63           C  
ATOM    848  NH1 ARG   126      18.192 -19.174  39.943  0.50 43.05           N  
ATOM    850  NH2 ARG   126      17.164 -20.864  41.139  0.50 42.07           N  
ATOM    852  N   HIS   127      19.775 -16.688  47.079  1.00 33.69           N  
ATOM    853  CA  HIS   127      21.131 -16.196  47.403  1.00 34.51           C  
ATOM    854  C   HIS   127      21.196 -15.224  48.612  1.00 33.68           C  
ATOM    855  O   HIS   127      22.269 -14.732  48.947  1.00 33.77           O  
ATOM    856  CB  HIS   127      21.789 -15.557  46.177  1.00 34.70           C  
ATOM    857  CG  HIS   127      22.155 -16.530  45.106  1.00 39.58           C  
ATOM    858  ND1 HIS   127      21.919 -16.279  43.771  1.00 42.87           N  
ATOM    859  CD2 HIS   127      22.770 -17.740  45.161  1.00 41.75           C  
ATOM    860  CE1 HIS   127      22.375 -17.296  43.048  1.00 45.27           C  
ATOM    861  NE2 HIS   127      22.888 -18.197  43.868  1.00 42.60           N  
ATOM    862  N   VAL   128      20.064 -14.973  49.271  1.00 31.51           N  
ATOM    863  CA  VAL   128      20.045 -14.065  50.396  1.00 31.98           C  
ATOM    864  C   VAL   128      20.826 -14.690  51.529  1.00 33.28           C  
ATOM    865  O   VAL   128      20.625 -15.861  51.855  1.00 33.25           O  
ATOM    866  CB  VAL   128      18.609 -13.790  50.830  1.00 31.75           C  
ATOM    867  CG1 VAL   128      18.528 -13.042  52.204  1.00 29.75           C  
ATOM    868  CG2 VAL   128      17.921 -12.997  49.697  1.00 31.26           C  
ATOM    869  N   ARG   129      21.703 -13.883  52.120  1.00 33.61           N  
ATOM    870  CA  ARG   129      22.571 -14.297  53.224  1.00 34.50           C  
ATOM    871  C   ARG   129      22.190 -13.526  54.517  1.00 33.26           C  
ATOM    872  O   ARG   129      22.449 -14.013  55.628  1.00 31.75           O  
ATOM    873  CB  ARG   129      24.020 -14.099  52.754  1.00 34.29           C  
ATOM    874  CG  ARG   129      25.129 -13.916  53.775  1.00 38.31           C  
ATOM    875  CD  ARG   129      26.523 -13.891  53.047  1.00 39.42           C  
ATOM    876  NE  ARG   129      27.659 -14.088  53.967  1.00 47.11           N  
ATOM    877  CZ  ARG   129      28.008 -15.243  54.525  1.00 49.62           C  
ATOM    878  NH1 ARG   129      27.337 -16.369  54.268  1.00 50.69           N  
ATOM    879  NH2 ARG   129      29.054 -15.275  55.355  1.00 51.11           N  
ATOM    880  N   HIS   130      21.511 -12.368  54.374  1.00 30.80           N  
ATOM    881  CA  HIS   130      21.094 -11.577  55.517  1.00 31.25           C  
ATOM    882  C   HIS   130      19.719 -10.986  55.327  1.00 30.28           C  
ATOM    883  O   HIS   130      19.342 -10.647  54.211  1.00 28.51           O  
ATOM    884  CB  HIS   130      22.004 -10.376  55.683  1.00 32.90           C  
ATOM    885  CG  HIS   130      23.360 -10.734  56.175  1.00 37.29           C  
ATOM    886  ND1 HIS   130      24.436 -10.876  55.325  1.00 42.12           N  
ATOM    887  CD2 HIS   130      23.804 -11.039  57.417  1.00 39.12           C  
ATOM    888  CE1 HIS   130      25.495 -11.229  56.029  1.00 42.47           C  
ATOM    889  NE2 HIS   130      25.139 -11.327  57.299  1.00 42.86           N  
ATOM    890  N   LEU   131      19.027 -10.768  56.433  1.00 28.68           N  
ATOM    891  CA  LEU   131      17.730 -10.086  56.376  1.00 30.58           C  
ATOM    892  C   LEU   131      17.863  -8.857  57.285  1.00 30.29           C  
ATOM    893  O   LEU   131      18.392  -8.977  58.378  1.00 31.90           O  
ATOM    894  CB  LEU   131      16.603 -11.001  56.824  1.00 31.30           C  
ATOM    895  CG  LEU   131      15.193 -10.402  56.770  1.00 34.58           C  
ATOM    896  CD1 LEU   131      14.236 -11.562  56.595  1.00 38.29           C  
ATOM    897  CD2 LEU   131      14.859  -9.562  57.986  1.00 38.57           C  
ATOM    898  N   GLU   132      17.433  -7.691  56.814  1.00 29.02           N  
ATOM    899  CA  GLU   132      17.503  -6.440  57.574  1.00 30.40           C  
ATOM    900  C   GLU   132      16.100  -5.852  57.721  1.00 30.46           C  
ATOM    901  O   GLU   132      15.280  -5.997  56.828  1.00 28.94           O  
ATOM    902  CB  GLU   132      18.375  -5.429  56.802  1.00 29.23           C  
ATOM    903  CG  GLU   132      19.815  -5.591  57.140  1.00 33.74           C  
ATOM    904  CD  GLU   132      20.795  -4.628  56.468  1.00 34.50           C  
ATOM    905  OE1 GLU   132      20.442  -3.536  55.953  1.00 40.50           O  
ATOM    906  OE2 GLU   132      21.979  -4.995  56.487  1.00 38.28           O  
ATOM    907  N   THR   133      15.822  -5.176  58.823  1.00 29.70           N  
ATOM    908  CA  THR   133      14.547  -4.553  58.981  1.00 30.29           C  
ATOM    909  C   THR   133      14.759  -3.544  60.107  1.00 30.59           C  
ATOM    910  O   THR   133      15.825  -3.540  60.727  1.00 30.37           O  
ATOM    911  CB  THR   133      13.463  -5.580  59.356  1.00 31.81           C  
ATOM    912  OG1 THR   133      12.165  -4.978  59.174  1.00 33.20           O  
ATOM    913  CG2 THR   133      13.596  -6.020  60.852  1.00 30.50           C  
ATOM    914  N   THR   134      13.773  -2.722  60.405  1.00 29.32           N  
ATOM    915  CA  THR   134      13.925  -1.880  61.595  1.00 29.75           C  
ATOM    916  C   THR   134      12.775  -2.087  62.577  1.00 29.78           C  
ATOM    917  O   THR   134      11.649  -2.566  62.189  1.00 29.62           O  
ATOM    918  CB  THR   134      14.048  -0.386  61.285  1.00 29.80           C  
ATOM    919  OG1 THR   134      12.767   0.088  60.851  1.00 31.78           O  
ATOM    920  CG2 THR   134      15.133  -0.096  60.202  1.00 30.43           C  
ATOM    921  N   VAL   135      13.073  -1.808  63.835  1.00 30.68           N  
ATOM    922  CA  VAL   135      12.136  -2.013  64.924  1.00 31.53           C  
ATOM    923  C   VAL   135      12.207  -0.818  65.831  1.00 31.82           C  
ATOM    924  O   VAL   135      13.276  -0.305  66.041  1.00 33.90           O  
ATOM    925  CB  VAL   135      12.451  -3.297  65.752  1.00 32.28           C  
ATOM    926  CG1 VAL   135      12.003  -4.557  65.000  1.00 33.93           C  
ATOM    927  CG2 VAL   135      13.919  -3.376  66.200  1.00 33.14           C  
ATOM    928  N   GLY   136      11.088  -0.388  66.412  1.00 33.08           N  
ATOM    929  CA  GLY   136      11.112   0.672  67.420  1.00 34.31           C  
ATOM    930  C   GLY   136      11.590   0.146  68.774  1.00 37.82           C  
ATOM    931  O   GLY   136      11.728  -1.077  68.948  1.00 35.54           O  
ATOM    932  N   PRO   137      11.823   1.064  69.741  1.00 40.57           N  
ATOM    933  CA  PRO   137      12.259   0.716  71.087  1.00 43.55           C  
ATOM    934  C   PRO   137      11.419  -0.339  71.792  1.00 44.62           C  
ATOM    935  O   PRO   137      11.989  -1.224  72.359  1.00 47.20           O  
ATOM    936  CB  PRO   137      12.247   2.059  71.851  1.00 44.14           C  
ATOM    937  CG  PRO   137      11.493   3.033  70.961  1.00 44.40           C  
ATOM    938  CD  PRO   137      11.681   2.523  69.562  1.00 41.56           C  
ATOM    939  N   ASP   138      10.098  -0.287  71.737  1.00 45.76           N  
ATOM    940  CA  ASP   138       9.280  -1.184  72.560  1.00 47.26           C  
ATOM    941  C   ASP   138       8.750  -2.370  71.813  1.00 45.93           C  
ATOM    942  O   ASP   138       7.962  -3.132  72.367  1.00 47.05           O  
ATOM    943  CB  ASP   138       8.013  -0.473  73.063  1.00 49.09           C  
ATOM    944  CG  ASP   138       8.296   0.838  73.789  1.00 53.31           C  
ATOM    945  OD1 ASP   138       9.295   0.909  74.555  1.00 57.05           O  
ATOM    946  OD2 ASP   138       7.484   1.788  73.575  1.00 59.42           O  
ATOM    947  N   ASN   139       9.106  -2.512  70.547  1.00 44.09           N  
ATOM    948  CA  ASN   139       8.455  -3.495  69.723  1.00 42.64           C  
ATOM    949  C   ASN   139       9.029  -4.890  69.965  1.00 40.57           C  
ATOM    950  O   ASN   139       9.709  -5.465  69.104  1.00 38.07           O  
ATOM    951  CB  ASN   139       8.536  -3.075  68.249  1.00 44.42           C  
ATOM    952  CG  ASN   139       7.828  -1.734  67.997  1.00 50.18           C  
ATOM    953  OD1 ASN   139       6.601  -1.663  67.959  1.00 55.95           O  
ATOM    954  ND2 ASN   139       8.601  -0.669  67.886  1.00 52.75           N  
ATOM    955  N   GLN   140       8.770  -5.427  71.157  1.00 38.57           N  
ATOM    956  CA  GLN   140       9.317  -6.737  71.524  1.00 36.96           C  
ATOM    957  C   GLN   140       8.782  -7.919  70.740  1.00 36.24           C  
ATOM    958  O   GLN   140       9.547  -8.850  70.411  1.00 35.42           O  
ATOM    959  CB  GLN   140       9.170  -6.984  73.020  1.00 37.67           C  
ATOM    960  CG  GLN   140       9.872  -5.933  73.868  1.00 41.31           C  
ATOM    961  CD  GLN   140      11.348  -5.776  73.538  1.00 47.33           C  
ATOM    962  OE1 GLN   140      12.036  -6.742  73.198  1.00 48.80           O  
ATOM    963  NE2 GLN   140      11.843  -4.553  73.647  1.00 52.39           N  
ATOM    964  N   ALA   141       7.476  -7.922  70.466  1.00 34.86           N  
ATOM    965  CA  ALA   141       6.894  -9.001  69.703  1.00 34.59           C  
ATOM    966  C   ALA   141       7.500  -9.065  68.306  1.00 35.03           C  
ATOM    967  O   ALA   141       7.748 -10.157  67.773  1.00 35.37           O  
ATOM    968  CB  ALA   141       5.369  -8.880  69.626  1.00 34.68           C  
ATOM    969  N   SER   142       7.753  -7.896  67.722  0.50 35.08           N  
ATOM    971  CA  SER   142       8.337  -7.845  66.381  0.50 34.34           C  
ATOM    973  C   SER   142       9.761  -8.407  66.367  0.50 33.61           C  
ATOM    975  O   SER   142      10.140  -9.132  65.447  0.50 33.91           O  
ATOM    977  CB  SER   142       8.301  -6.414  65.855  0.50 35.14           C  
ATOM    979  OG  SER   142       6.986  -6.105  65.402  0.50 36.83           O  
ATOM    981  N   ARG   143      10.526  -8.107  67.413  1.00 31.92           N  
ATOM    982  CA  ARG   143      11.840  -8.706  67.630  1.00 31.65           C  
ATOM    983  C   ARG   143      11.748 -10.221  67.764  1.00 32.62           C  
ATOM    984  O   ARG   143      12.627 -10.946  67.266  1.00 32.96           O  
ATOM    985  CB  ARG   143      12.555  -8.124  68.855  1.00 31.41           C  
ATOM    986  CG  ARG   143      13.047  -6.696  68.682  1.00 32.38           C  
ATOM    987  CD  ARG   143      13.612  -6.157  70.038  1.00 32.63           C  
ATOM    988  NE  ARG   143      14.354  -4.913  69.907  1.00 33.59           N  
ATOM    989  CZ  ARG   143      13.778  -3.725  69.807  1.00 35.37           C  
ATOM    990  NH1 ARG   143      12.448  -3.613  69.825  1.00 37.45           N  
ATOM    991  NH2 ARG   143      14.531  -2.635  69.695  1.00 38.94           N  
ATOM    992  N   ARG   144      10.694 -10.723  68.420  1.00 31.43           N  
ATOM    993  CA  ARG   144      10.651 -12.163  68.629  1.00 32.29           C  
ATOM    994  C   ARG   144      10.417 -12.893  67.308  1.00 32.97           C  
ATOM    995  O   ARG   144      10.955 -14.015  67.109  1.00 33.70           O  
ATOM    996  CB  ARG   144       9.572 -12.557  69.639  1.00 31.24           C  
ATOM    997  CG  ARG   144      10.041 -12.372  71.087  1.00 31.57           C  
ATOM    998  CD  ARG   144       8.994 -12.898  72.057  1.00 28.92           C  
ATOM    999  NE  ARG   144       7.775 -12.083  72.146  1.00 28.45           N  
ATOM   1000  CZ  ARG   144       7.636 -11.051  73.015  1.00 30.97           C  
ATOM   1001  NH1 ARG   144       8.657 -10.638  73.761  1.00 26.80           N  
ATOM   1002  NH2 ARG   144       6.491 -10.370  73.084  1.00 31.80           N  
ATOM   1003  N   THR   145       9.584 -12.294  66.468  1.00 34.26           N  
ATOM   1004  CA  THR   145       9.315 -12.813  65.108  1.00 37.29           C  
ATOM   1005  C   THR   145      10.660 -12.968  64.373  1.00 37.57           C  
ATOM   1006  O   THR   145      10.990 -14.082  63.937  1.00 36.19           O  
ATOM   1007  CB  THR   145       8.327 -11.943  64.295  1.00 38.03           C  
ATOM   1008  OG1 THR   145       7.046 -11.895  64.937  1.00 38.10           O  
ATOM   1009  CG2 THR   145       8.122 -12.501  62.876  1.00 40.32           C  
ATOM   1010  N   PHE   146      11.463 -11.885  64.308  1.00 37.24           N  
ATOM   1011  CA  PHE   146      12.752 -11.978  63.623  1.00 37.68           C  
ATOM   1012  C   PHE   146      13.739 -12.936  64.331  1.00 39.16           C  
ATOM   1013  O   PHE   146      14.432 -13.733  63.664  1.00 39.77           O  
ATOM   1014  CB  PHE   146      13.302 -10.578  63.240  1.00 38.74           C  
ATOM   1015  CG  PHE   146      12.430  -9.849  62.233  1.00 39.23           C  
ATOM   1016  CD1 PHE   146      12.570 -10.073  60.850  1.00 39.66           C  
ATOM   1017  CD2 PHE   146      11.449  -8.940  62.656  1.00 42.53           C  
ATOM   1018  CE1 PHE   146      11.738  -9.415  59.926  1.00 38.69           C  
ATOM   1019  CE2 PHE   146      10.597  -8.257  61.718  1.00 43.57           C  
ATOM   1020  CZ  PHE   146      10.747  -8.510  60.370  1.00 40.97           C  
ATOM   1021  N   ALA   147      13.764 -12.949  65.679  1.00 38.85           N  
ATOM   1022  CA  ALA   147      14.573 -13.911  66.405  1.00 38.63           C  
ATOM   1023  C   ALA   147      14.224 -15.352  66.060  1.00 38.95           C  
ATOM   1024  O   ALA   147      15.118 -16.185  65.880  1.00 38.97           O  
ATOM   1025  CB  ALA   147      14.489 -13.680  67.919  1.00 38.76           C  
ATOM   1026  N   GLY   148      12.928 -15.655  65.967  1.00 39.30           N  
ATOM   1027  CA  GLY   148      12.488 -17.021  65.682  1.00 39.91           C  
ATOM   1028  C   GLY   148      12.932 -17.477  64.300  1.00 40.74           C  
ATOM   1029  O   GLY   148      13.386 -18.609  64.101  1.00 40.27           O  
ATOM   1030  N   LEU   149      12.802 -16.576  63.352  1.00 40.77           N  
ATOM   1031  CA  LEU   149      13.279 -16.775  62.000  1.00 42.52           C  
ATOM   1032  C   LEU   149      14.793 -17.093  61.926  1.00 42.40           C  
ATOM   1033  O   LEU   149      15.224 -18.004  61.197  1.00 42.72           O  
ATOM   1034  CB  LEU   149      12.971 -15.477  61.243  1.00 41.25           C  
ATOM   1035  CG  LEU   149      12.249 -15.544  59.913  1.00 45.60           C  
ATOM   1036  CD1 LEU   149      11.035 -16.491  59.949  1.00 46.26           C  
ATOM   1037  CD2 LEU   149      11.867 -14.133  59.476  1.00 44.81           C  
ATOM   1038  N   ALA   150      15.591 -16.342  62.677  1.00 42.19           N  
ATOM   1039  CA  ALA   150      17.027 -16.561  62.728  1.00 43.17           C  
ATOM   1040  C   ALA   150      17.367 -17.948  63.296  1.00 44.25           C  
ATOM   1041  O   ALA   150      18.196 -18.677  62.725  1.00 43.93           O  
ATOM   1042  CB  ALA   150      17.687 -15.476  63.536  1.00 43.07           C  
ATOM   1043  N   GLY   151      16.717 -18.312  64.406  1.00 44.73           N  
ATOM   1044  CA  GLY   151      16.996 -19.584  65.091  1.00 45.94           C  
ATOM   1045  C   GLY   151      16.781 -20.785  64.192  1.00 46.14           C  
ATOM   1046  O   GLY   151      17.593 -21.714  64.200  1.00 46.17           O  
ATOM   1047  N   GLU   152      15.701 -20.749  63.405  0.50 46.44           N  
ATOM   1049  CA  GLU   152      15.355 -21.825  62.469  0.50 46.93           C  
ATOM   1051  C   GLU   152      16.289 -21.885  61.233  0.50 47.32           C  
ATOM   1053  O   GLU   152      16.139 -22.769  60.383  0.50 47.10           O  
ATOM   1055  CB  GLU   152      13.879 -21.719  62.035  0.50 46.85           C  
ATOM   1057  CG  GLU   152      12.833 -21.820  63.174  0.50 47.47           C  
ATOM   1059  CD  GLU   152      12.321 -23.254  63.454  0.50 46.92           C  
ATOM   1061  OE1 GLU   152      11.216 -23.391  64.027  0.50 47.24           O  
ATOM   1063  OE2 GLU   152      13.006 -24.237  63.108  0.50 47.10           O  
ATOM   1065  N   ARG   153      17.248 -20.959  61.149  1.00 47.16           N  
ATOM   1066  CA  ARG   153      18.238 -20.930  60.064  1.00 47.60           C  
ATOM   1067  C   ARG   153      19.696 -20.929  60.567  1.00 47.56           C  
ATOM   1068  O   ARG   153      20.636 -20.710  59.783  1.00 48.14           O  
ATOM   1069  CB  ARG   153      17.994 -19.698  59.171  1.00 47.52           C  
ATOM   1070  CG  ARG   153      16.832 -19.877  58.197  1.00 47.85           C  
ATOM   1071  CD  ARG   153      16.214 -18.546  57.703  1.00 48.25           C  
ATOM   1072  NE  ARG   153      15.011 -18.827  56.914  1.00 48.66           N  
ATOM   1073  CZ  ARG   153      13.786 -19.002  57.423  1.00 50.44           C  
ATOM   1074  NH1 ARG   153      12.772 -19.304  56.615  1.00 48.73           N  
ATOM   1075  NH2 ARG   153      13.577 -18.905  58.745  1.00 50.45           N  
ATOM   1076  N   GLY   154      19.888 -21.146  61.865  1.00 46.80           N  
ATOM   1077  CA  GLY   154      21.227 -21.054  62.453  1.00 46.10           C  
ATOM   1078  C   GLY   154      21.881 -19.697  62.200  1.00 45.54           C  
ATOM   1079  O   GLY   154      23.097 -19.614  61.997  1.00 45.73           O  
ATOM   1080  N   ALA   155      21.076 -18.632  62.207  1.00 44.29           N  
ATOM   1081  CA  ALA   155      21.590 -17.269  62.026  1.00 43.19           C  
ATOM   1082  C   ALA   155      21.630 -16.459  63.328  1.00 42.59           C  
ATOM   1083  O   ALA   155      20.902 -16.748  64.267  1.00 43.85           O  
ATOM   1084  CB  ALA   155      20.762 -16.521  60.950  1.00 42.77           C  
ATOM   1085  N   HIS   156      22.501 -15.449  63.335  0.50 41.82           N  
ATOM   1087  CA  HIS   156      22.761 -14.490  64.420  0.50 40.83           C  
ATOM   1089  C   HIS   156      21.740 -13.329  64.284  0.50 40.45           C  
ATOM   1091  O   HIS   156      21.246 -13.088  63.189  0.50 38.80           O  
ATOM   1093  CB  HIS   156      24.227 -14.018  64.216  0.50 40.32           C  
ATOM   1095  CG  HIS   156      24.685 -12.891  65.096  0.50 40.80           C  
ATOM   1097  ND1 HIS   156      24.791 -12.995  66.470  0.50 41.92           N  
ATOM   1099  CD2 HIS   156      25.161 -11.661  64.780  0.50 40.16           C  
ATOM   1101  CE1 HIS   156      25.266 -11.864  66.964  0.50 40.20           C  
ATOM   1103  NE2 HIS   156      25.494 -11.037  65.959  0.50 41.31           N  
ATOM   1105  N   VAL   157      21.385 -12.669  65.389  1.00 40.08           N  
ATOM   1106  CA  VAL   157      20.584 -11.453  65.329  1.00 39.34           C  
ATOM   1107  C   VAL   157      21.385 -10.336  65.956  1.00 38.99           C  
ATOM   1108  O   VAL   157      21.916 -10.490  67.053  1.00 39.41           O  
ATOM   1109  CB  VAL   157      19.272 -11.588  66.093  1.00 40.01           C  
ATOM   1110  CG1 VAL   157      18.442 -10.368  65.866  1.00 38.44           C  
ATOM   1111  CG2 VAL   157      18.469 -12.773  65.588  1.00 41.70           C  
ATOM   1112  N   SER   158      21.497  -9.210  65.278  1.00 37.66           N  
ATOM   1113  CA  SER   158      22.118  -8.062  65.903  1.00 37.51           C  
ATOM   1114  C   SER   158      21.220  -6.839  65.790  1.00 37.11           C  
ATOM   1115  O   SER   158      20.403  -6.749  64.868  1.00 35.42           O  
ATOM   1116  CB  SER   158      23.514  -7.814  65.319  1.00 37.80           C  
ATOM   1117  OG  SER   158      23.502  -6.927  64.215  1.00 43.14           O  
ATOM   1118  N   GLU   159      21.370  -5.902  66.724  1.00 35.91           N  
ATOM   1119  CA  GLU   159      20.530  -4.736  66.732  1.00 36.42           C  
ATOM   1120  C   GLU   159      21.415  -3.544  66.988  1.00 34.94           C  
ATOM   1121  O   GLU   159      22.213  -3.582  67.909  1.00 33.52           O  
ATOM   1122  CB  GLU   159      19.492  -4.883  67.838  1.00 35.95           C  
ATOM   1123  CG  GLU   159      18.476  -3.762  67.893  1.00 39.12           C  
ATOM   1124  CD  GLU   159      17.394  -4.025  68.950  1.00 42.73           C  
ATOM   1125  OE1 GLU   159      16.918  -3.023  69.542  1.00 49.54           O  
ATOM   1126  OE2 GLU   159      17.048  -5.223  69.197  1.00 45.45           O  
ATOM   1127  N   GLN   160      21.300  -2.498  66.174  1.00 33.51           N  
ATOM   1128  CA  GLN   160      22.129  -1.308  66.323  1.00 32.97           C  
ATOM   1129  C   GLN   160      21.274  -0.043  66.169  1.00 33.12           C  
ATOM   1130  O   GLN   160      20.273  -0.044  65.433  1.00 32.75           O  
ATOM   1131  CB  GLN   160      23.248  -1.311  65.271  1.00 33.04           C  
ATOM   1132  CG  GLN   160      24.268  -2.415  65.435  1.00 35.30           C  
ATOM   1133  CD  GLN   160      25.120  -2.256  66.717  1.00 37.92           C  
ATOM   1134  OE1 GLN   160      25.161  -1.165  67.310  1.00 36.23           O  
ATOM   1135  NE2 GLN   160      25.796  -3.344  67.148  1.00 38.98           N  
ATOM   1136  N   PRO   161      21.606   1.025  66.901  1.00 32.36           N  
ATOM   1137  CA  PRO   161      20.919   2.277  66.610  1.00 32.50           C  
ATOM   1138  C   PRO   161      21.023   2.619  65.109  1.00 31.78           C  
ATOM   1139  O   PRO   161      22.044   2.315  64.475  1.00 31.34           O  
ATOM   1140  CB  PRO   161      21.724   3.316  67.388  1.00 32.06           C  
ATOM   1141  CG  PRO   161      22.849   2.550  68.007  1.00 36.00           C  
ATOM   1142  CD  PRO   161      22.550   1.145  68.017  1.00 33.45           C  
ATOM   1143  N   PHE   162      20.003   3.270  64.573  1.00 31.89           N  
ATOM   1144  CA  PHE   162      19.940   3.495  63.129  1.00 30.24           C  
ATOM   1145  C   PHE   162      19.232   4.813  62.816  1.00 30.82           C  
ATOM   1146  O   PHE   162      19.915   5.806  62.484  1.00 31.00           O  
ATOM   1147  CB  PHE   162      19.272   2.276  62.542  1.00 30.99           C  
ATOM   1148  CG  PHE   162      19.224   2.214  61.055  1.00 30.24           C  
ATOM   1149  CD1 PHE   162      20.389   2.274  60.263  1.00 28.98           C  
ATOM   1150  CD2 PHE   162      17.983   1.984  60.440  1.00 30.26           C  
ATOM   1151  CE1 PHE   162      20.299   2.149  58.846  1.00 32.52           C  
ATOM   1152  CE2 PHE   162      17.890   1.837  59.035  1.00 32.42           C  
ATOM   1153  CZ  PHE   162      19.025   1.958  58.233  1.00 29.09           C  
ATOM   1154  N   PHE   163      17.894   4.858  62.874  1.00 28.61           N  
ATOM   1155  CA  PHE   163      17.216   6.123  62.681  1.00 29.80           C  
ATOM   1156  C   PHE   163      16.861   6.665  64.027  1.00 31.94           C  
ATOM   1157  O   PHE   163      16.108   6.009  64.760  1.00 33.39           O  
ATOM   1158  CB  PHE   163      15.921   5.975  61.881  1.00 29.85           C  
ATOM   1159  CG  PHE   163      16.105   5.525  60.438  1.00 26.07           C  
ATOM   1160  CD1 PHE   163      17.286   5.772  59.749  1.00 28.93           C  
ATOM   1161  CD2 PHE   163      15.046   4.906  59.759  1.00 31.95           C  
ATOM   1162  CE1 PHE   163      17.419   5.374  58.366  1.00 31.02           C  
ATOM   1163  CE2 PHE   163      15.150   4.512  58.405  1.00 32.60           C  
ATOM   1164  CZ  PHE   163      16.346   4.772  57.696  1.00 28.90           C  
ATOM   1165  N   ASP   164      17.352   7.854  64.342  1.00 31.19           N  
ATOM   1166  CA  ASP   164      17.091   8.439  65.643  1.00 32.55           C  
ATOM   1167  C   ASP   164      16.350   9.756  65.423  1.00 32.90           C  
ATOM   1168  O   ASP   164      15.909  10.020  64.310  1.00 32.06           O  
ATOM   1169  CB  ASP   164      18.427   8.665  66.335  1.00 34.33           C  
ATOM   1170  CG  ASP   164      19.381   9.524  65.519  1.00 36.82           C  
ATOM   1171  OD1 ASP   164      19.152   9.795  64.293  1.00 39.67           O  
ATOM   1172  OD2 ASP   164      20.402   9.915  66.102  1.00 40.59           O  
ATOM   1173  N   ARG   165      16.294  10.606  66.446  0.50 32.78           N  
ATOM   1175  CA  ARG   165      15.758  11.965  66.319  0.50 34.06           C  
ATOM   1177  C   ARG   165      16.393  12.800  65.194  0.50 32.76           C  
ATOM   1179  O   ARG   165      15.704  13.566  64.520  0.50 32.30           O  
ATOM   1181  CB  ARG   165      15.901  12.736  67.641  0.50 34.03           C  
ATOM   1183  CG  ARG   165      15.044  12.164  68.769  0.50 36.68           C  
ATOM   1185  CD  ARG   165      15.423  12.757  70.129  0.50 37.46           C  
ATOM   1187  NE  ARG   165      14.971  11.910  71.232  0.50 45.30           N  
ATOM   1189  CZ  ARG   165      13.725  11.880  71.709  0.50 48.57           C  
ATOM   1191  NH1 ARG   165      12.779  12.653  71.185  0.50 49.96           N  
ATOM   1193  NH2 ARG   165      13.418  11.076  72.724  0.50 50.43           N  
ATOM   1195  N   GLN   166      17.705  12.665  65.013  0.50 32.09           N  
ATOM   1197  CA  GLN   166      18.420  13.390  63.970  0.50 32.57           C  
ATOM   1199  C   GLN   166      17.857  13.029  62.587  0.50 31.31           C  
ATOM   1201  O   GLN   166      17.595  13.900  61.753  0.50 30.00           O  
ATOM   1203  CB  GLN   166      19.937  13.085  64.055  0.50 32.57           C  
ATOM   1205  CG  GLN   166      20.852  14.026  63.233  0.50 35.47           C  
ATOM   1207  CD  GLN   166      22.346  13.744  63.411  0.50 34.84           C  
ATOM   1209  OE1 GLN   166      22.732  12.898  64.208  0.50 39.56           O  
ATOM   1211  NE2 GLN   166      23.196  14.478  62.674  0.50 38.77           N  
ATOM   1213  N   ALA   167      17.655  11.730  62.373  1.00 29.22           N  
ATOM   1214  CA  ALA   167      17.225  11.213  61.086  1.00 29.75           C  
ATOM   1215  C   ALA   167      15.766  11.616  60.777  1.00 30.76           C  
ATOM   1216  O   ALA   167      15.435  11.877  59.597  1.00 30.39           O  
ATOM   1217  CB  ALA   167      17.364   9.704  61.039  1.00 26.49           C  
ATOM   1218  N   PHE   168      14.932  11.722  61.825  1.00 31.57           N  
ATOM   1219  CA  PHE   168      13.517  12.164  61.650  1.00 31.96           C  
ATOM   1220  C   PHE   168      13.286  13.649  61.710  1.00 32.21           C  
ATOM   1221  O   PHE   168      12.132  14.096  61.604  1.00 32.92           O  
ATOM   1222  CB  PHE   168      12.567  11.443  62.628  1.00 32.43           C  
ATOM   1223  CG  PHE   168      12.409   9.972  62.360  1.00 30.95           C  
ATOM   1224  CD1 PHE   168      11.533   9.522  61.333  1.00 32.26           C  
ATOM   1225  CD2 PHE   168      13.056   9.016  63.156  1.00 32.42           C  
ATOM   1226  CE1 PHE   168      11.319   8.144  61.074  1.00 36.05           C  
ATOM   1227  CE2 PHE   168      12.908   7.664  62.895  1.00 32.07           C  
ATOM   1228  CZ  PHE   168      12.022   7.185  61.874  1.00 35.67           C  
ATOM   1229  N   GLY   169      14.352  14.404  61.892  1.00 32.25           N  
ATOM   1230  CA  GLY   169      14.264  15.872  61.966  1.00 33.51           C  
ATOM   1231  C   GLY   169      13.387  16.346  63.107  1.00 34.34           C  
ATOM   1232  O   GLY   169      12.765  17.414  63.027  1.00 35.41           O  
ATOM   1233  N   GLY   170      13.346  15.586  64.194  1.00 34.82           N  
ATOM   1234  CA  GLY   170      12.547  16.003  65.347  1.00 35.27           C  
ATOM   1235  C   GLY   170      11.069  15.686  65.189  1.00 36.51           C  
ATOM   1236  O   GLY   170      10.260  16.126  65.986  1.00 36.64           O  
ATOM   1237  N   ALA   171      10.690  14.878  64.198  1.00 36.02           N  
ATOM   1238  CA  ALA   171       9.277  14.629  63.983  1.00 36.89           C  
ATOM   1239  C   ALA   171       8.800  13.708  65.085  1.00 37.83           C  
ATOM   1240  O   ALA   171       9.600  13.065  65.742  1.00 37.14           O  
ATOM   1241  CB  ALA   171       9.049  13.995  62.607  1.00 36.67           C  
ATOM   1242  N   ASP   172       7.500  13.666  65.306  1.00 38.13           N  
ATOM   1243  CA  ASP   172       6.938  12.813  66.339  1.00 40.54           C  
ATOM   1244  C   ASP   172       6.880  11.360  65.838  1.00 40.03           C  
ATOM   1245  O   ASP   172       5.830  10.862  65.401  1.00 42.18           O  
ATOM   1246  CB  ASP   172       5.554  13.370  66.698  1.00 41.76           C  
ATOM   1247  CG  ASP   172       4.963  12.759  67.940  1.00 47.72           C  
ATOM   1248  OD1 ASP   172       5.517  11.772  68.502  1.00 53.08           O  
ATOM   1249  OD2 ASP   172       3.897  13.283  68.346  1.00 52.54           O  
ATOM   1250  N   HIS   173       8.025  10.685  65.886  1.00 39.06           N  
ATOM   1251  CA  HIS   173       8.141   9.284  65.445  1.00 37.69           C  
ATOM   1252  C   HIS   173       9.146   8.602  66.377  1.00 37.60           C  
ATOM   1253  O   HIS   173      10.154   9.177  66.733  1.00 35.55           O  
ATOM   1254  CB  HIS   173       8.600   9.248  63.971  1.00 37.68           C  
ATOM   1255  CG  HIS   173       8.488   7.899  63.311  1.00 37.73           C  
ATOM   1256  ND1 HIS   173       9.241   6.819  63.703  1.00 35.65           N  
ATOM   1257  CD2 HIS   173       7.738   7.465  62.259  1.00 41.18           C  
ATOM   1258  CE1 HIS   173       8.964   5.770  62.946  1.00 38.16           C  
ATOM   1259  NE2 HIS   173       8.058   6.138  62.051  1.00 38.08           N  
ATOM   1260  N   ASP   174       8.855   7.380  66.815  1.00 37.19           N  
ATOM   1261  CA  ASP   174       9.824   6.644  67.620  1.00 38.31           C  
ATOM   1262  C   ASP   174      11.102   6.420  66.793  1.00 37.14           C  
ATOM   1263  O   ASP   174      11.037   6.391  65.529  1.00 36.72           O  
ATOM   1264  CB  ASP   174       9.252   5.268  67.946  1.00 38.70           C  
ATOM   1265  CG  ASP   174       8.113   5.326  68.967  1.00 43.22           C  
ATOM   1266  OD1 ASP   174       7.968   6.363  69.667  1.00 49.01           O  
ATOM   1267  OD2 ASP   174       7.365   4.322  69.053  1.00 48.72           O  
ATOM   1268  N   ASP   175      12.224   6.231  67.498  1.00 35.40           N  
ATOM   1269  CA  ASP   175      13.470   5.768  66.899  1.00 35.45           C  
ATOM   1270  C   ASP   175      13.234   4.411  66.236  1.00 35.34           C  
ATOM   1271  O   ASP   175      12.388   3.662  66.702  1.00 35.17           O  
ATOM   1272  CB  ASP   175      14.488   5.573  68.019  1.00 36.20           C  
ATOM   1273  CG  ASP   175      15.088   6.880  68.517  1.00 39.50           C  
ATOM   1274  OD1 ASP   175      14.721   7.973  68.005  1.00 42.16           O  
ATOM   1275  OD2 ASP   175      15.945   6.817  69.437  1.00 44.59           O  
ATOM   1276  N   GLU   176      13.974   4.097  65.169  1.00 34.71           N  
ATOM   1277  CA  GLU   176      13.918   2.790  64.532  1.00 34.11           C  
ATOM   1278  C   GLU   176      15.312   2.186  64.542  1.00 34.73           C  
ATOM   1279  O   GLU   176      16.201   2.707  63.842  1.00 34.95           O  
ATOM   1280  CB  GLU   176      13.455   2.947  63.092  1.00 36.01           C  
ATOM   1281  CG  GLU   176      12.018   3.477  62.968  1.00 36.75           C  
ATOM   1282  CD  GLU   176      10.973   2.356  62.998  1.00 43.16           C  
ATOM   1283  OE1 GLU   176      11.257   1.132  62.730  1.00 39.93           O  
ATOM   1284  OE2 GLU   176       9.810   2.716  63.302  1.00 46.24           O  
ATOM   1285  N   MET   177      15.512   1.111  65.317  1.00 31.93           N  
ATOM   1286  CA  MET   177      16.797   0.443  65.330  1.00 31.94           C  
ATOM   1287  C   MET   177      16.938  -0.556  64.163  1.00 30.52           C  
ATOM   1288  O   MET   177      15.936  -1.086  63.707  1.00 30.12           O  
ATOM   1289  CB  MET   177      16.979  -0.263  66.671  1.00 31.47           C  
ATOM   1290  CG  MET   177      17.307   0.851  67.772  1.00 41.15           C  
ATOM   1291  SD  MET   177      15.602   1.584  68.381  0.45 55.77          SE  
ATOM   1292  CE  MET   177      14.945  -0.016  69.226  1.00 53.35           C  
ATOM   1293  N   LEU   178      18.175  -0.839  63.763  1.00 29.29           N  
ATOM   1294  CA  LEU   178      18.412  -1.735  62.649  1.00 31.28           C  
ATOM   1295  C   LEU   178      18.555  -3.141  63.183  1.00 31.35           C  
ATOM   1296  O   LEU   178      19.461  -3.432  63.988  1.00 31.95           O  
ATOM   1297  CB  LEU   178      19.677  -1.333  61.878  1.00 29.10           C  
ATOM   1298  CG  LEU   178      20.030  -2.319  60.745  1.00 31.33           C  
ATOM   1299  CD1 LEU   178      19.027  -2.317  59.590  1.00 30.10           C  
ATOM   1300  CD2 LEU   178      21.475  -2.062  60.250  1.00 32.35           C  
ATOM   1301  N   LEU   179      17.674  -4.029  62.740  1.00 31.88           N  
ATOM   1302  CA  LEU   179      17.747  -5.419  63.141  1.00 32.27           C  
ATOM   1303  C   LEU   179      18.293  -6.247  61.948  1.00 33.22           C  
ATOM   1304  O   LEU   179      17.807  -6.154  60.821  1.00 32.35           O  
ATOM   1305  CB  LEU   179      16.344  -5.872  63.607  1.00 32.02           C  
ATOM   1306  CG  LEU   179      16.040  -7.172  64.339  1.00 35.18           C  
ATOM   1307  CD1 LEU   179      16.660  -7.096  65.763  1.00 40.95           C  
ATOM   1308  CD2 LEU   179      14.507  -7.435  64.480  1.00 34.77           C  
ATOM   1309  N   ARG   180      19.346  -7.019  62.178  1.00 33.14           N  
ATOM   1310  CA  ARG   180      20.028  -7.723  61.105  1.00 34.71           C  
ATOM   1311  C   ARG   180      20.229  -9.188  61.439  1.00 35.46           C  
ATOM   1312  O   ARG   180      20.797  -9.507  62.470  1.00 36.70           O  
ATOM   1313  CB  ARG   180      21.379  -7.044  60.829  1.00 35.83           C  
ATOM   1314  CG  ARG   180      22.137  -7.590  59.651  1.00 38.09           C  
ATOM   1315  CD  ARG   180      23.177  -6.555  59.260  1.00 45.27           C  
ATOM   1316  NE  ARG   180      23.881  -6.901  58.027  1.00 51.12           N  
ATOM   1317  CZ  ARG   180      24.988  -7.635  58.000  1.00 52.09           C  
ATOM   1318  NH1 ARG   180      25.496  -8.098  59.141  1.00 57.01           N  
ATOM   1319  NH2 ARG   180      25.593  -7.909  56.849  1.00 52.09           N  
ATOM   1320  N   ILE   181      19.764 -10.084  60.581  1.00 36.10           N  
ATOM   1321  CA  ILE   181      19.804 -11.529  60.866  1.00 36.97           C  
ATOM   1322  C   ILE   181      20.643 -12.178  59.794  1.00 38.09           C  
ATOM   1323  O   ILE   181      20.537 -11.816  58.608  1.00 34.62           O  
ATOM   1324  CB  ILE   181      18.406 -12.111  60.751  1.00 38.27           C  
ATOM   1325  CG1 ILE   181      17.432 -11.440  61.708  1.00 41.03           C  
ATOM   1326  CG2 ILE   181      18.386 -13.584  61.005  1.00 40.84           C  
ATOM   1327  CD1 ILE   181      16.062 -11.386  61.071  1.00 48.15           C  
ATOM   1328  N   GLY   182      21.467 -13.164  60.178  1.00 38.91           N  
ATOM   1329  CA  GLY   182      22.320 -13.810  59.209  1.00 40.40           C  
ATOM   1330  C   GLY   182      23.694 -14.077  59.818  1.00 43.20           C  
ATOM   1331  O   GLY   182      23.909 -13.733  60.989  1.00 43.62           O  
ATOM   1332  N   PRO   183      24.631 -14.667  59.034  1.00 43.54           N  
ATOM   1333  CA  PRO   183      24.429 -15.179  57.666  1.00 43.78           C  
ATOM   1334  C   PRO   183      23.517 -16.414  57.641  1.00 43.68           C  
ATOM   1335  O   PRO   183      23.455 -17.141  58.618  1.00 44.02           O  
ATOM   1336  CB  PRO   183      25.856 -15.531  57.193  1.00 43.95           C  
ATOM   1337  CG  PRO   183      26.655 -15.715  58.435  1.00 45.02           C  
ATOM   1338  CD  PRO   183      26.041 -14.805  59.475  1.00 44.24           C  
ATOM   1339  N   PHE   184      22.762 -16.600  56.565  1.00 43.32           N  
ATOM   1340  CA  PHE   184      22.002 -17.819  56.398  1.00 43.90           C  
ATOM   1341  C   PHE   184      22.979 -18.745  55.698  1.00 45.14           C  
ATOM   1342  O   PHE   184      23.746 -18.269  54.855  1.00 45.26           O  
ATOM   1343  CB  PHE   184      20.768 -17.609  55.532  1.00 43.64           C  
ATOM   1344  CG  PHE   184      19.790 -16.620  56.093  1.00 44.04           C  
ATOM   1345  CD1 PHE   184      19.409 -16.675  57.437  1.00 43.12           C  
ATOM   1346  CD2 PHE   184      19.223 -15.648  55.284  1.00 43.20           C  
ATOM   1347  CE1 PHE   184      18.509 -15.769  57.956  1.00 41.15           C  
ATOM   1348  CE2 PHE   184      18.317 -14.734  55.802  1.00 42.25           C  
ATOM   1349  CZ  PHE   184      17.959 -14.791  57.134  1.00 41.41           C  
END
