
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  221 ( 1712),  selected  221 , name 1lvh_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 1lvh_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      K       2          3.117
LGA    F     2_A      Y       3          1.811
LGA    K     3_A      T       4          1.464
LGA    A     4_A      V       5          0.759
LGA    V     5_A      Y       6          0.604
LGA    L     6_A      L       7          0.510
LGA    F     7_A      F       8          0.787
LGA    X     8_A      D       9          0.628
LGA    L     9_A      F      10          0.406
LGA    D    10_A      D      11          1.062
LGA    G    11_A      Y      12          1.531
LGA    V    12_A      T      13          1.071
LGA    I    13_A      L      14          0.277
LGA    T    14_A      A      15          0.641
LGA    D    15_A      D      16          1.771
LGA    T    16_A      S      17          2.110
LGA    A    17_A      S      18          3.081
LGA    E    18_A      R      19          3.038
LGA    Y    19_A      G      20          1.827
LGA    H    20_A      I      21          1.768
LGA    F    21_A      V      22          1.706
LGA    R    22_A      T      23          1.564
LGA    A    23_A      C      24          0.996
LGA    W    24_A      F      25          1.541
LGA    K    25_A      R      26          1.044
LGA    A    26_A      S      27          1.513
LGA    L    27_A      V      28          2.033
LGA    A    28_A      L      29          2.765
LGA    E    29_A      E      30          2.850
LGA    E    30_A      R      31          2.974
LGA    I    31_A      H      32          3.975
LGA    G    32_A      G      33          4.076
LGA    I    33_A      Y      34          3.135
LGA    N    34_A      T      35          1.397
LGA    G    35_A      G      36          1.482
LGA    V    36_A      I      37          1.953
LGA    D    37_A      T      38          1.540
LGA    R    38_A      D      39          2.117
LGA    Q    39_A      D      40          4.086
LGA    F    40_A      M      41          3.419
LGA    N    41_A      I      42          2.125
LGA    E    42_A      K      43           #
LGA    Q    43_A      R      44           #
LGA    L    44_A      T      45          4.065
LGA    K    45_A      I      46          4.590
LGA    G    46_A      G      47           #
LGA    V    47_A      K      48          4.772
LGA    S    48_A      T      49          4.309
LGA    R    49_A      L      50          3.057
LGA    E    50_A      E      51          3.633
LGA    D    51_A      E      52          4.878
LGA    -       -      S      53           -
LGA    S    52_A      F      54          0.792
LGA    L    53_A      S      55          5.681
LGA    -       -      I      56           -
LGA    -       -      L      57           -
LGA    Q    54_A      T      58          4.025
LGA    K    55_A      G      59          2.985
LGA    I    56_A      -       -           -
LGA    L    57_A      -       -           -
LGA    D    58_A      I      60           #
LGA    L    59_A      T      61           -
LGA    A    60_A      D      62           -
LGA    D    61_A      A      63           -
LGA    K    62_A      -       -           -
LGA    K    63_A      -       -           -
LGA    V    64_A      -       -           -
LGA    S    65_A      -       -           -
LGA    A    66_A      D      64          5.259
LGA    E    67_A      -       -           -
LGA    E    68_A      -       -           -
LGA    F    69_A      Q      65          3.629
LGA    K    70_A      L      66           #
LGA    -       -      E      67           -
LGA    E    71_A      S      68          4.300
LGA    L    72_A      F      69          4.211
LGA    A    73_A      R      70          3.532
LGA    K    74_A      Q      71          1.865
LGA    R    75_A      E      72          1.872
LGA    K    76_A      Y      73          1.884
LGA    N    77_A      S      74          1.773
LGA    D    78_A      K      75          1.101
LGA    N    79_A      E      76          1.000
LGA    Y    80_A      A      77          1.864
LGA    V    81_A      D      78          2.214
LGA    K    82_A      I      79          1.005
LGA    M    83_A      Y      80          0.758
LGA    I    84_A      M      81          2.043
LGA    Q    85_A      N      82          3.994
LGA    D    86_A      A      83          1.907
LGA    V    87_A      N      84          5.217
LGA    S    88_A      T      85           #
LGA    P    89_A      -       -           -
LGA    A    90_A      I      86          5.328
LGA    D    91_A      L      87          2.447
LGA    V    92_A      -       -           -
LGA    Y    93_A      F      88          1.116
LGA    P    94_A      P      89          2.235
LGA    G    95_A      D      90          1.808
LGA    I    96_A      T      91          1.885
LGA    L    97_A      L      92          0.901
LGA    Q    98_A      P      93          1.378
LGA    L    99_A      T      94          1.710
LGA    L   100_A      L      95          1.313
LGA    K   101_A      T      96          1.068
LGA    D   102_A      H      97          1.458
LGA    L   103_A      L      98          1.664
LGA    R   104_A      K      99          1.437
LGA    S   105_A      K     100          1.564
LGA    N   106_A      Q     101          1.692
LGA    K   107_A      G     102          1.364
LGA    I   108_A      I     103          1.043
LGA    K   109_A      R     104          0.741
LGA    I   110_A      I     105          0.916
LGA    A   111_A      G     106          1.010
LGA    L   112_A      I     107          0.944
LGA    A   113_A      I     108          1.073
LGA    S   114_A      S     109          1.047
LGA    A   115_A      T     110          1.431
LGA    S   116_A      K     111          1.135
LGA    K   117_A      Y     112          0.422
LGA    -       -      R     113           -
LGA    -       -      F     114           -
LGA    N   118_A      R     115          2.023
LGA    G   119_A      I     116          2.155
LGA    P   120_A      L     117          1.858
LGA    F   121_A      S     118          1.913
LGA    L   122_A      F     119          2.131
LGA    L   123_A      L     120          1.995
LGA    E   124_A      R     121          1.854
LGA    R   125_A      N     122          3.080
LGA    M   126_A      H     123          1.940
LGA    N   127_A      M     124          2.317
LGA    L   128_A      P     125          4.262
LGA    T   129_A      D     126          3.686
LGA    G   130_A      D     127          1.745
LGA    Y   131_A      W     128          1.566
LGA    F   132_A      F     129          0.696
LGA    D   133_A      D     130          1.128
LGA    A   134_A      I     131          1.263
LGA    I   135_A      I     132          1.109
LGA    A   136_A      I     133          1.971
LGA    D   137_A      G     134          4.130
LGA    P   138_A      G     135          3.117
LGA    A   139_A      E     136          2.750
LGA    E   140_A      D     137          3.256
LGA    V   141_A      V     138          2.426
LGA    A   142_A      T     139          3.735
LGA    A   143_A      H     140          2.828
LGA    S   144_A      H     141          1.799
LGA    K   145_A      K     142          1.273
LGA    P   146_A      P     143          1.626
LGA    A   147_A      D     144          2.326
LGA    P   148_A      P     145          2.102
LGA    D   149_A      E     146          2.144
LGA    I   150_A      G     147          1.752
LGA    F   151_A      L     148          1.725
LGA    I   152_A      L     149          1.686
LGA    A   153_A      L     150          1.682
LGA    A   154_A      A     151          1.894
LGA    A   155_A      I     152          2.228
LGA    H   156_A      D     153          2.525
LGA    A   157_A      R     154          2.539
LGA    V   158_A      L     155          2.445
LGA    G   159_A      K     156          2.618
LGA    V   160_A      A     157          1.106
LGA    A   161_A      C     158          1.916
LGA    P   162_A      P     159          2.078
LGA    S   163_A      E     160          1.772
LGA    E   164_A      E     161          1.081
LGA    S   165_A      V     162          0.960
LGA    I   166_A      L     163          0.921
LGA    G   167_A      Y     164          0.932
LGA    L   168_A      I     165          0.640
LGA    E   169_A      G     166          0.889
LGA    D   170_A      D     167          0.703
LGA    S   171_A      S     168          0.945
LGA    Q   172_A      T     169          0.964
LGA    A   173_A      V     170          1.939
LGA    G   174_A      D     171          0.857
LGA    I   175_A      A     172          1.147
LGA    Q   176_A      G     173          2.106
LGA    A   177_A      T     174          1.416
LGA    I   178_A      A     175          1.228
LGA    K   179_A      A     176          2.588
LGA    D   180_A      A     177          3.022
LGA    S   181_A      A     178          2.032
LGA    G   182_A      G     179          2.784
LGA    A   183_A      V     180          2.198
LGA    L   184_A      S     181          1.593
LGA    P   185_A      F     182          0.934
LGA    I   186_A      T     183          0.899
LGA    G   187_A      G     184          0.703
LGA    V   188_A      V     185          0.559
LGA    G   189_A      T     186          1.592
LGA    -       -      S     187           -
LGA    -       -      G     188           -
LGA    -       -      M     189           -
LGA    -       -      T     190           -
LGA    R   190_A      T     191          3.223
LGA    P   191_A      A     192          2.341
LGA    E   192_A      Q     193          1.364
LGA    D   193_A      E     194          1.702
LGA    L   194_A      F     195          1.237
LGA    G   195_A      Q     196          1.631
LGA    D   196_A      A     197           #
LGA    -       -      Y     198           -
LGA    D   197_A      P     199          4.181
LGA    I   198_A      Y     200          2.033
LGA    V   199_A      D     201          3.327
LGA    -       -      R     202           -
LGA    I   200_A      I     203          0.430
LGA    V   201_A      I     204          0.229
LGA    P   202_A      S     205          1.639
LGA    D   203_A      T     206          2.272
LGA    T   204_A      L     207          2.136
LGA    S   205_A      G     208          2.892
LGA    H   206_A      Q     209          1.483
LGA    Y   207_A      L     210          2.170
LGA    T   208_A      I     211          1.709
LGA    L   209_A      -       -           -
LGA    E   210_A      -       -           -
LGA    F   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    K   213_A      -       -           -
LGA    E   214_A      -       -           -
LGA    V   215_A      -       -           -
LGA    W   216_A      -       -           -
LGA    L   217_A      -       -           -
LGA    Q   218_A      -       -           -
LGA    K   219_A      -       -           -
LGA    Q   220_A      -       -           -
LGA    K   221_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  221  210    5.0    188    2.32    17.02     66.274     7.773

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.730663 * X  +  -0.273509 * Y  +   0.625560 * Z  +  22.819889
  Y_new =  -0.331628 * X  +   0.943079 * Y  +   0.024988 * Z  +  28.862335
  Z_new =  -0.596787 * X  +  -0.189195 * Y  +  -0.779776 * Z  + 109.949936 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.903564    0.238028  [ DEG:  -166.3620     13.6380 ]
  Theta =   0.639490    2.502102  [ DEG:    36.6401    143.3599 ]
  Phi   =  -2.715522    0.426070  [ DEG:  -155.5880     24.4120 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1lvh_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1lvh_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  221  210   5.0  188   2.32   17.02  66.274
REMARK  ---------------------------------------------------------- 
MOLECULE 1lvh_A
HEADER    ISOMERASE                               28-MAY-02   1LVH              
TITLE     THE STRUCTURE OF PHOSPHORYLATED BETA-PHOSPHOGLUCOMUTASE               
TITLE    2 FROM LACTOCCOCUS LACTIS TO 2.3 ANGSTROM RESOLUTION                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BETA-PHOSPHOGLUCOMUTASE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 5.4.2.6;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LACTOCOCCUS LACTIS;                             
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PGMB;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET3A                                     
KEYWDS    HAD SUPERFAMILY, PHOSPHOASPARTATE, ASPARTYLPHOSPHATE                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.D.LAHIRI,G.ZHANG,D.DUNAWAY-MARIANO,K.N.ALLEN                        
REVDAT   1   14-AUG-02 1LVH    0                                                
JRNL        AUTH   S.D.LAHIRI,G.ZHANG,D.DUNAWAY-MARIANO,K.N.ALLEN               
JRNL        TITL   CAUGHT IN THE ACT: THE STRUCTURE OF PHOSPHORYLATED           
JRNL        TITL 2 BETA-PHOSPHOGLUCOMUTASE FROM LACTOCOCCUS LACTIS.             
JRNL        REF    BIOCHEMISTRY                  V.  41  8351 2002              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1LVH A    1   221  UNP    P71447   PGMB_LACLA       1    221             
DBREF  1LVH B    1   221  UNP    P71447   PGMB_LACLA       1    221             
SEQRES   1 A  221  MET PHE LYS ALA VAL LEU PHE PHD LEU ASP GLY VAL ILE          
SEQRES   2 A  221  THR ASP THR ALA GLU TYR HIS PHE ARG ALA TRP LYS ALA          
SEQRES   3 A  221  LEU ALA GLU GLU ILE GLY ILE ASN GLY VAL ASP ARG GLN          
SEQRES   4 A  221  PHE ASN GLU GLN LEU LYS GLY VAL SER ARG GLU ASP SER          
SEQRES   5 A  221  LEU GLN LYS ILE LEU ASP LEU ALA ASP LYS LYS VAL SER          
SEQRES   6 A  221  ALA GLU GLU PHE LYS GLU LEU ALA LYS ARG LYS ASN ASP          
SEQRES   7 A  221  ASN TYR VAL LYS MET ILE GLN ASP VAL SER PRO ALA ASP          
SEQRES   8 A  221  VAL TYR PRO GLY ILE LEU GLN LEU LEU LYS ASP LEU ARG          
SEQRES   9 A  221  SER ASN LYS ILE LYS ILE ALA LEU ALA SER ALA SER LYS          
SEQRES  10 A  221  ASN GLY PRO PHE LEU LEU GLU ARG MET ASN LEU THR GLY          
SEQRES  11 A  221  TYR PHE ASP ALA ILE ALA ASP PRO ALA GLU VAL ALA ALA          
SEQRES  12 A  221  SER LYS PRO ALA PRO ASP ILE PHE ILE ALA ALA ALA HIS          
SEQRES  13 A  221  ALA VAL GLY VAL ALA PRO SER GLU SER ILE GLY LEU GLU          
SEQRES  14 A  221  ASP SER GLN ALA GLY ILE GLN ALA ILE LYS ASP SER GLY          
SEQRES  15 A  221  ALA LEU PRO ILE GLY VAL GLY ARG PRO GLU ASP LEU GLY          
SEQRES  16 A  221  ASP ASP ILE VAL ILE VAL PRO ASP THR SER HIS TYR THR          
SEQRES  17 A  221  LEU GLU PHE LEU LYS GLU VAL TRP LEU GLN LYS GLN LYS          
SEQRES   1 B  221  MET PHE LYS ALA VAL LEU PHE PHD LEU ASP GLY VAL ILE          
SEQRES   2 B  221  THR ASP THR ALA GLU TYR HIS PHE ARG ALA TRP LYS ALA          
SEQRES   3 B  221  LEU ALA GLU GLU ILE GLY ILE ASN GLY VAL ASP ARG GLN          
SEQRES   4 B  221  PHE ASN GLU GLN LEU LYS GLY VAL SER ARG GLU ASP SER          
SEQRES   5 B  221  LEU GLN LYS ILE LEU ASP LEU ALA ASP LYS LYS VAL SER          
SEQRES   6 B  221  ALA GLU GLU PHE LYS GLU LEU ALA LYS ARG LYS ASN ASP          
SEQRES   7 B  221  ASN TYR VAL LYS MET ILE GLN ASP VAL SER PRO ALA ASP          
SEQRES   8 B  221  VAL TYR PRO GLY ILE LEU GLN LEU LEU LYS ASP LEU ARG          
SEQRES   9 B  221  SER ASN LYS ILE LYS ILE ALA LEU ALA SER ALA SER LYS          
SEQRES  10 B  221  ASN GLY PRO PHE LEU LEU GLU ARG MET ASN LEU THR GLY          
SEQRES  11 B  221  TYR PHE ASP ALA ILE ALA ASP PRO ALA GLU VAL ALA ALA          
SEQRES  12 B  221  SER LYS PRO ALA PRO ASP ILE PHE ILE ALA ALA ALA HIS          
SEQRES  13 B  221  ALA VAL GLY VAL ALA PRO SER GLU SER ILE GLY LEU GLU          
SEQRES  14 B  221  ASP SER GLN ALA GLY ILE GLN ALA ILE LYS ASP SER GLY          
SEQRES  15 B  221  ALA LEU PRO ILE GLY VAL GLY ARG PRO GLU ASP LEU GLY          
SEQRES  16 B  221  ASP ASP ILE VAL ILE VAL PRO ASP THR SER HIS TYR THR          
SEQRES  17 B  221  LEU GLU PHE LEU LYS GLU VAL TRP LEU GLN LYS GLN LYS          
HET    PHD  A   8      12                                                       
HET    PHD  B   8      12                                                       
HET     MG  B 800       1                                                       
HET     MG  A 801       1                                                       
HETNAM     PHD ASPARTYL PHOSPHATE                                               
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  PHD    2(C4 H8 N O7 P)                                              
FORMUL   3   MG    2(MG 2+)                                                     
FORMUL   5  HOH   *259(H2 O)                                                    
CRYST1   53.667   92.776  111.597  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   MET A   1     -15.746  38.590  68.002  1.00 26.23           N  
ATOM      2  CA  MET A   1     -14.448  39.225  68.397  1.00 29.09           C  
ATOM      3  C   MET A   1     -14.090  38.863  69.849  1.00 27.43           C  
ATOM      4  O   MET A   1     -14.973  38.779  70.721  1.00 27.76           O  
ATOM      5  CB  MET A   1     -14.549  40.750  68.229  1.00 26.87           C  
ATOM      6  CG  MET A   1     -13.230  41.477  68.402  1.00 30.66           C  
ATOM      7  SD  MET A   1     -11.925  40.816  67.360  1.00 24.47           S  
ATOM      8  CE  MET A   1     -11.973  41.929  66.010  1.00 34.22           C  
ATOM      9  N   PHE A   2     -12.804  38.626  70.104  1.00 25.83           N  
ATOM     10  CA  PHE A   2     -12.354  38.269  71.449  1.00 23.70           C  
ATOM     11  C   PHE A   2     -12.558  39.460  72.384  1.00 23.95           C  
ATOM     12  O   PHE A   2     -12.469  40.608  71.953  1.00 24.87           O  
ATOM     13  CB  PHE A   2     -10.886  37.837  71.419  1.00 22.37           C  
ATOM     14  CG  PHE A   2      -9.949  38.891  70.909  1.00 21.83           C  
ATOM     15  CD1 PHE A   2      -9.355  39.798  71.789  1.00 20.37           C  
ATOM     16  CD2 PHE A   2      -9.658  38.979  69.546  1.00 18.90           C  
ATOM     17  CE1 PHE A   2      -8.479  40.782  71.319  1.00 21.48           C  
ATOM     18  CE2 PHE A   2      -8.791  39.953  69.064  1.00 19.69           C  
ATOM     19  CZ  PHE A   2      -8.197  40.858  69.950  1.00 22.81           C  
ATOM     20  N   LYS A   3     -12.813  39.186  73.661  1.00 23.05           N  
ATOM     21  CA  LYS A   3     -13.088  40.242  74.636  1.00 24.16           C  
ATOM     22  C   LYS A   3     -11.961  40.591  75.610  1.00 23.53           C  
ATOM     23  O   LYS A   3     -12.038  41.583  76.331  1.00 22.03           O  
ATOM     24  CB  LYS A   3     -14.337  39.866  75.439  1.00 25.63           C  
ATOM     25  CG  LYS A   3     -15.564  39.522  74.588  1.00 28.13           C  
ATOM     26  CD  LYS A   3     -16.086  40.753  73.833  1.00 31.87           C  
ATOM     27  CE  LYS A   3     -17.483  40.524  73.214  1.00 31.38           C  
ATOM     28  NZ  LYS A   3     -17.483  39.599  72.036  1.00 32.58           N  
ATOM     29  N   ALA A   4     -10.913  39.780  75.635  1.00 23.49           N  
ATOM     30  CA  ALA A   4      -9.804  40.023  76.539  1.00 21.15           C  
ATOM     31  C   ALA A   4      -8.507  39.397  76.058  1.00 19.49           C  
ATOM     32  O   ALA A   4      -8.513  38.423  75.303  1.00 20.22           O  
ATOM     33  CB  ALA A   4     -10.149  39.480  77.920  1.00 20.86           C  
ATOM     34  N   VAL A   5      -7.394  39.972  76.491  1.00 18.43           N  
ATOM     35  CA  VAL A   5      -6.079  39.450  76.158  1.00 17.05           C  
ATOM     36  C   VAL A   5      -5.387  39.178  77.497  1.00 19.03           C  
ATOM     37  O   VAL A   5      -5.315  40.050  78.361  1.00 20.04           O  
ATOM     38  CB  VAL A   5      -5.273  40.445  75.307  1.00 16.65           C  
ATOM     39  CG1 VAL A   5      -3.883  39.897  75.030  1.00 12.29           C  
ATOM     40  CG2 VAL A   5      -5.995  40.682  73.975  1.00 14.38           C  
ATOM     41  N   LEU A   6      -4.916  37.947  77.671  1.00 18.42           N  
ATOM     42  CA  LEU A   6      -4.271  37.528  78.901  1.00 17.95           C  
ATOM     43  C   LEU A   6      -2.752  37.484  78.687  1.00 18.52           C  
ATOM     44  O   LEU A   6      -2.265  36.698  77.878  1.00 15.83           O  
ATOM     45  CB  LEU A   6      -4.803  36.145  79.284  1.00 18.22           C  
ATOM     46  CG  LEU A   6      -6.311  35.937  79.026  1.00 18.94           C  
ATOM     47  CD1 LEU A   6      -6.660  34.481  79.256  1.00 15.40           C  
ATOM     48  CD2 LEU A   6      -7.160  36.848  79.939  1.00 16.42           C  
ATOM     49  N   PHE A   7      -2.020  38.313  79.431  1.00 16.81           N  
ATOM     50  CA  PHE A   7      -0.564  38.414  79.303  1.00 17.39           C  
ATOM     51  C   PHE A   7       0.318  37.639  80.292  1.00 18.11           C  
ATOM     52  O   PHE A   7       0.190  37.793  81.518  1.00 16.01           O  
ATOM     53  CB  PHE A   7      -0.125  39.881  79.408  1.00 17.91           C  
ATOM     54  CG  PHE A   7      -0.608  40.763  78.291  1.00 17.75           C  
ATOM     55  CD1 PHE A   7      -1.944  41.142  78.207  1.00 15.71           C  
ATOM     56  CD2 PHE A   7       0.292  41.257  77.347  1.00 15.69           C  
ATOM     57  CE1 PHE A   7      -2.368  42.009  77.196  1.00 16.73           C  
ATOM     58  CE2 PHE A   7      -0.123  42.122  76.338  1.00 14.84           C  
ATOM     59  CZ  PHE A   7      -1.449  42.500  76.259  1.00 13.59           C  
HETATM   60  N   PHD A   8       1.315  36.912  79.897  1.00 17.03           N  
HETATM   61  CA  PHD A   8       2.253  36.262  80.802  1.00 20.38           C  
HETATM   62  C   PHD A   8       3.185  37.430  81.094  1.00 17.59           C  
HETATM   63  O   PHD A   8       3.223  38.387  80.307  1.00 16.32           O  
HETATM   64  CB  PHD A   8       3.055  35.139  80.117  1.00 18.61           C  
HETATM   65  CG  PHD A   8       4.406  34.858  80.807  1.00 14.12           C  
HETATM   66  OD1 PHD A   8       4.495  34.716  82.065  1.00 18.40           O  
HETATM   67  OD2 PHD A   8       5.403  34.776  80.055  1.00 15.04           O  
HETATM   68  P   PHD A   8       5.672  34.434  83.045  1.00 25.72           P  
HETATM   69  OP1 PHD A   8       5.776  35.571  83.982  1.00 21.51           O  
HETATM   70  OP2 PHD A   8       5.456  33.202  83.779  1.00 21.39           O  
HETATM   71  OP3 PHD A   8       6.965  34.300  82.271  1.00 22.19           O  
ATOM     72  N   LEU A   9       3.980  37.606  82.075  1.00 30.71           N  
ATOM     73  CA  LEU A   9       5.061  38.843  81.955  1.00 26.45           C  
ATOM     74  C   LEU A   9       6.414  38.587  81.300  1.00 23.08           C  
ATOM     75  O   LEU A   9       6.753  39.230  80.298  1.00 18.89           O  
ATOM     76  CB  LEU A   9       5.050  40.191  82.668  1.00 28.80           C  
ATOM     77  CG  LEU A   9       5.401  40.157  84.142  1.00 27.40           C  
ATOM     78  CD1 LEU A   9       6.726  39.504  84.357  1.00 28.66           C  
ATOM     79  CD2 LEU A   9       5.423  41.572  84.645  1.00 29.10           C  
ATOM     80  N   ASP A  10       7.167  37.639  81.857  1.00 19.65           N  
ATOM     81  CA  ASP A  10       8.485  37.299  81.333  1.00 18.05           C  
ATOM     82  C   ASP A  10       8.429  36.677  79.942  1.00 16.89           C  
ATOM     83  O   ASP A  10       7.734  35.666  79.715  1.00 16.79           O  
ATOM     84  CB  ASP A  10       9.213  36.340  82.274  1.00 19.32           C  
ATOM     85  CG  ASP A  10      10.593  35.968  81.757  1.00 22.28           C  
ATOM     86  OD1 ASP A  10      11.485  36.847  81.726  1.00 23.28           O  
ATOM     87  OD2 ASP A  10      10.782  34.797  81.361  1.00 24.99           O  
ATOM     88  N   GLY A  11       9.179  37.292  79.033  1.00 14.94           N  
ATOM     89  CA  GLY A  11       9.245  36.860  77.653  1.00 18.64           C  
ATOM     90  C   GLY A  11       8.211  37.530  76.752  1.00 20.30           C  
ATOM     91  O   GLY A  11       8.290  37.415  75.533  1.00 19.52           O  
ATOM     92  N   VAL A  12       7.241  38.226  77.343  1.00 19.84           N  
ATOM     93  CA  VAL A  12       6.189  38.884  76.572  1.00 17.74           C  
ATOM     94  C   VAL A  12       6.166  40.401  76.810  1.00 17.48           C  
ATOM     95  O   VAL A  12       6.401  41.192  75.890  1.00 13.15           O  
ATOM     96  CB  VAL A  12       4.802  38.300  76.930  1.00 18.08           C  
ATOM     97  CG1 VAL A  12       3.708  39.088  76.229  1.00 18.17           C  
ATOM     98  CG2 VAL A  12       4.731  36.841  76.519  1.00 17.79           C  
ATOM     99  N   ILE A  13       5.872  40.796  78.049  1.00 15.56           N  
ATOM    100  CA  ILE A  13       5.832  42.202  78.424  1.00 14.55           C  
ATOM    101  C   ILE A  13       7.258  42.741  78.624  1.00 17.11           C  
ATOM    102  O   ILE A  13       7.590  43.833  78.169  1.00 16.82           O  
ATOM    103  CB  ILE A  13       4.996  42.390  79.707  1.00 13.52           C  
ATOM    104  CG1 ILE A  13       3.518  42.162  79.373  1.00 12.93           C  
ATOM    105  CG2 ILE A  13       5.199  43.790  80.284  1.00 11.63           C  
ATOM    106  CD1 ILE A  13       2.583  42.341  80.547  1.00 14.92           C  
ATOM    107  N   THR A  14       8.098  41.960  79.289  1.00 16.65           N  
ATOM    108  CA  THR A  14       9.474  42.361  79.533  1.00 19.38           C  
ATOM    109  C   THR A  14      10.295  41.154  79.961  1.00 21.71           C  
ATOM    110  O   THR A  14       9.789  40.026  79.998  1.00 20.90           O  
ATOM    111  CB  THR A  14       9.576  43.440  80.644  1.00 18.87           C  
ATOM    112  OG1 THR A  14      10.926  43.897  80.730  1.00 19.90           O  
ATOM    113  CG2 THR A  14       9.180  42.883  81.998  1.00 18.42           C  
ATOM    114  N   ASP A  15      11.559  41.392  80.297  1.00 21.71           N  
ATOM    115  CA  ASP A  15      12.427  40.311  80.717  1.00 20.91           C  
ATOM    116  C   ASP A  15      12.779  40.387  82.188  1.00 22.56           C  
ATOM    117  O   ASP A  15      13.174  41.444  82.685  1.00 23.53           O  
ATOM    118  CB  ASP A  15      13.736  40.315  79.921  1.00 22.50           C  
ATOM    119  CG  ASP A  15      14.731  39.279  80.440  1.00 24.03           C  
ATOM    120  OD1 ASP A  15      14.727  38.141  79.951  1.00 25.44           O  
ATOM    121  OD2 ASP A  15      15.507  39.590  81.365  1.00 31.06           O  
ATOM    122  N   THR A  16      12.629  39.258  82.874  1.00 21.87           N  
ATOM    123  CA  THR A  16      12.988  39.141  84.283  1.00 22.07           C  
ATOM    124  C   THR A  16      14.007  38.005  84.363  1.00 21.68           C  
ATOM    125  O   THR A  16      14.822  37.956  85.275  1.00 23.23           O  
ATOM    126  CB  THR A  16      11.788  38.759  85.188  1.00 21.92           C  
ATOM    127  OG1 THR A  16      11.286  37.470  84.799  1.00 19.70           O  
ATOM    128  CG2 THR A  16      10.690  39.811  85.104  1.00 22.23           C  
ATOM    129  N   ALA A  17      13.954  37.106  83.385  1.00 21.88           N  
ATOM    130  CA  ALA A  17      14.844  35.948  83.325  1.00 22.36           C  
ATOM    131  C   ALA A  17      16.301  36.299  83.577  1.00 23.67           C  
ATOM    132  O   ALA A  17      16.975  35.623  84.352  1.00 23.75           O  
ATOM    133  CB  ALA A  17      14.706  35.247  81.964  1.00 21.59           C  
ATOM    134  N   GLU A  18      16.788  37.350  82.920  1.00 24.43           N  
ATOM    135  CA  GLU A  18      18.174  37.767  83.092  1.00 26.45           C  
ATOM    136  C   GLU A  18      18.436  38.149  84.546  1.00 26.56           C  
ATOM    137  O   GLU A  18      19.510  37.872  85.082  1.00 25.22           O  
ATOM    138  CB  GLU A  18      18.483  38.952  82.178  1.00 28.15           C  
ATOM    139  CG  GLU A  18      19.927  39.447  82.230  1.00 32.86           C  
ATOM    140  CD  GLU A  18      20.955  38.380  81.828  1.00 35.13           C  
ATOM    141  OE1 GLU A  18      20.647  37.514  80.976  1.00 34.76           O  
ATOM    142  OE2 GLU A  18      22.084  38.428  82.358  1.00 37.19           O  
ATOM    143  N   TYR A  19      17.448  38.766  85.189  1.00 25.66           N  
ATOM    144  CA  TYR A  19      17.604  39.170  86.588  1.00 25.74           C  
ATOM    145  C   TYR A  19      17.648  37.955  87.512  1.00 25.01           C  
ATOM    146  O   TYR A  19      18.364  37.953  88.513  1.00 22.32           O  
ATOM    147  CB  TYR A  19      16.470  40.102  87.015  1.00 24.10           C  
ATOM    148  CG  TYR A  19      16.506  41.466  86.371  1.00 24.02           C  
ATOM    149  CD1 TYR A  19      15.525  41.857  85.460  1.00 23.79           C  
ATOM    150  CD2 TYR A  19      17.490  42.387  86.711  1.00 24.45           C  
ATOM    151  CE1 TYR A  19      15.521  43.144  84.911  1.00 23.32           C  
ATOM    152  CE2 TYR A  19      17.497  43.669  86.171  1.00 25.44           C  
ATOM    153  CZ  TYR A  19      16.505  44.041  85.276  1.00 25.39           C  
ATOM    154  OH  TYR A  19      16.485  45.322  84.783  1.00 26.84           O  
ATOM    155  N   HIS A  20      16.882  36.921  87.180  1.00 24.29           N  
ATOM    156  CA  HIS A  20      16.890  35.712  87.992  1.00 25.58           C  
ATOM    157  C   HIS A  20      18.248  35.026  87.849  1.00 26.21           C  
ATOM    158  O   HIS A  20      18.840  34.568  88.830  1.00 26.45           O  
ATOM    159  CB  HIS A  20      15.754  34.779  87.564  1.00 24.38           C  
ATOM    160  CG  HIS A  20      14.451  35.096  88.223  1.00 22.21           C  
ATOM    161  ND1 HIS A  20      13.306  35.390  87.514  1.00 22.11           N  
ATOM    162  CD2 HIS A  20      14.128  35.229  89.530  1.00 21.01           C  
ATOM    163  CE1 HIS A  20      12.336  35.697  88.356  1.00 20.31           C  
ATOM    164  NE2 HIS A  20      12.809  35.609  89.585  1.00 21.71           N  
ATOM    165  N   PHE A  21      18.745  34.988  86.620  1.00 27.01           N  
ATOM    166  CA  PHE A  21      20.036  34.396  86.326  1.00 27.27           C  
ATOM    167  C   PHE A  21      21.133  35.064  87.153  1.00 27.60           C  
ATOM    168  O   PHE A  21      21.896  34.390  87.846  1.00 26.74           O  
ATOM    169  CB  PHE A  21      20.344  34.540  84.839  1.00 28.36           C  
ATOM    170  CG  PHE A  21      21.725  34.116  84.463  1.00 31.36           C  
ATOM    171  CD1 PHE A  21      22.255  32.922  84.939  1.00 32.62           C  
ATOM    172  CD2 PHE A  21      22.484  34.883  83.589  1.00 33.66           C  
ATOM    173  CE1 PHE A  21      23.516  32.494  84.547  1.00 34.23           C  
ATOM    174  CE2 PHE A  21      23.747  34.466  83.189  1.00 36.09           C  
ATOM    175  CZ  PHE A  21      24.264  33.263  83.671  1.00 36.47           C  
ATOM    176  N   ARG A  22      21.205  36.387  87.088  1.00 26.14           N  
ATOM    177  CA  ARG A  22      22.218  37.112  87.841  1.00 29.50           C  
ATOM    178  C   ARG A  22      22.130  36.904  89.347  1.00 28.46           C  
ATOM    179  O   ARG A  22      23.154  36.810  90.022  1.00 29.91           O  
ATOM    180  CB  ARG A  22      22.141  38.606  87.528  1.00 30.90           C  
ATOM    181  CG  ARG A  22      22.629  38.960  86.138  1.00 34.79           C  
ATOM    182  CD  ARG A  22      22.178  40.364  85.758  1.00 39.40           C  
ATOM    183  NE  ARG A  22      22.557  41.366  86.752  1.00 41.83           N  
ATOM    184  CZ  ARG A  22      22.016  42.579  86.830  1.00 43.75           C  
ATOM    185  NH1 ARG A  22      21.070  42.947  85.974  1.00 45.65           N  
ATOM    186  NH2 ARG A  22      22.418  43.425  87.768  1.00 45.15           N  
ATOM    187  N   ALA A  23      20.913  36.838  89.870  1.00 27.35           N  
ATOM    188  CA  ALA A  23      20.708  36.644  91.294  1.00 27.72           C  
ATOM    189  C   ALA A  23      21.302  35.312  91.752  1.00 28.70           C  
ATOM    190  O   ALA A  23      22.002  35.263  92.763  1.00 28.63           O  
ATOM    191  CB  ALA A  23      19.224  36.687  91.621  1.00 25.81           C  
ATOM    192  N   TRP A  24      21.011  34.239  91.016  1.00 28.87           N  
ATOM    193  CA  TRP A  24      21.524  32.912  91.348  1.00 28.17           C  
ATOM    194  C   TRP A  24      23.034  32.912  91.261  1.00 30.75           C  
ATOM    195  O   TRP A  24      23.718  32.306  92.082  1.00 31.97           O  
ATOM    196  CB  TRP A  24      20.995  31.868  90.375  1.00 27.18           C  
ATOM    197  CG  TRP A  24      19.655  31.362  90.701  1.00 24.55           C  
ATOM    198  CD1 TRP A  24      18.578  31.330  89.879  1.00 24.12           C  
ATOM    199  CD2 TRP A  24      19.235  30.803  91.943  1.00 24.75           C  
ATOM    200  NE1 TRP A  24      17.501  30.785  90.530  1.00 24.29           N  
ATOM    201  CE2 TRP A  24      17.878  30.451  91.803  1.00 24.76           C  
ATOM    202  CE3 TRP A  24      19.874  30.556  93.165  1.00 24.39           C  
ATOM    203  CZ2 TRP A  24      17.142  29.874  92.838  1.00 24.82           C  
ATOM    204  CZ3 TRP A  24      19.143  29.978  94.194  1.00 22.36           C  
ATOM    205  CH2 TRP A  24      17.793  29.643  94.022  1.00 23.75           C  
ATOM    206  N   LYS A  25      23.544  33.590  90.244  1.00 31.72           N  
ATOM    207  CA  LYS A  25      24.971  33.675  90.019  1.00 34.99           C  
ATOM    208  C   LYS A  25      25.668  34.445  91.135  1.00 35.65           C  
ATOM    209  O   LYS A  25      26.810  34.154  91.469  1.00 36.35           O  
ATOM    210  CB  LYS A  25      25.221  34.321  88.657  1.00 35.93           C  
ATOM    211  CG  LYS A  25      26.646  34.249  88.157  1.00 38.12           C  
ATOM    212  CD  LYS A  25      26.679  34.353  86.640  1.00 40.02           C  
ATOM    213  CE  LYS A  25      25.861  35.539  86.131  1.00 41.87           C  
ATOM    214  NZ  LYS A  25      26.276  36.828  86.760  1.00 43.48           N  
ATOM    215  N   ALA A  26      24.984  35.421  91.721  1.00 38.06           N  
ATOM    216  CA  ALA A  26      25.573  36.200  92.808  1.00 39.72           C  
ATOM    217  C   ALA A  26      25.566  35.378  94.096  1.00 40.41           C  
ATOM    218  O   ALA A  26      26.466  35.487  94.933  1.00 40.50           O  
ATOM    219  CB  ALA A  26      24.799  37.497  93.010  1.00 38.32           C  
ATOM    220  N   LEU A  27      24.541  34.557  94.259  1.00 40.96           N  
ATOM    221  CA  LEU A  27      24.458  33.726  95.449  1.00 43.80           C  
ATOM    222  C   LEU A  27      25.580  32.696  95.396  1.00 45.41           C  
ATOM    223  O   LEU A  27      26.344  32.542  96.345  1.00 45.66           O  
ATOM    224  CB  LEU A  27      23.115  33.009  95.505  1.00 41.38           C  
ATOM    225  CG  LEU A  27      22.957  32.081  96.700  1.00 41.87           C  
ATOM    226  CD1 LEU A  27      22.936  32.911  97.981  1.00 41.93           C  
ATOM    227  CD2 LEU A  27      21.684  31.276  96.552  1.00 41.02           C  
ATOM    228  N   ALA A  28      25.672  32.004  94.265  1.00 47.71           N  
ATOM    229  CA  ALA A  28      26.683  30.978  94.059  1.00 50.07           C  
ATOM    230  C   ALA A  28      28.071  31.514  94.374  1.00 51.48           C  
ATOM    231  O   ALA A  28      28.797  30.939  95.184  1.00 52.19           O  
ATOM    232  CB  ALA A  28      26.629  30.483  92.622  1.00 48.98           C  
ATOM    233  N   GLU A  29      28.428  32.619  93.731  1.00 52.44           N  
ATOM    234  CA  GLU A  29      29.726  33.242  93.930  1.00 54.18           C  
ATOM    235  C   GLU A  29      29.928  33.645  95.384  1.00 54.33           C  
ATOM    236  O   GLU A  29      31.046  33.607  95.896  1.00 54.88           O  
ATOM    237  CB  GLU A  29      29.859  34.470  93.024  1.00 55.49           C  
ATOM    238  CG  GLU A  29      29.786  34.144  91.534  1.00 58.64           C  
ATOM    239  CD  GLU A  29      29.735  35.385  90.654  1.00 60.73           C  
ATOM    240  OE1 GLU A  29      28.810  36.209  90.839  1.00 61.55           O  
ATOM    241  OE2 GLU A  29      30.614  35.536  89.774  1.00 62.04           O  
ATOM    242  N   GLU A  30      28.842  34.026  96.049  1.00 54.36           N  
ATOM    243  CA  GLU A  30      28.914  34.441  97.446  1.00 53.50           C  
ATOM    244  C   GLU A  30      29.401  33.284  98.321  1.00 52.88           C  
ATOM    245  O   GLU A  30      30.161  33.490  99.271  1.00 52.76           O  
ATOM    246  CB  GLU A  30      27.540  34.917  97.929  1.00 54.80           C  
ATOM    247  CG  GLU A  30      27.592  35.832  99.145  1.00 56.01           C  
ATOM    248  CD  GLU A  30      26.217  36.125  99.726  1.00 56.87           C  
ATOM    249  OE1 GLU A  30      25.619  35.206 100.326  1.00 57.98           O  
ATOM    250  OE2 GLU A  30      25.733  37.268  99.584  1.00 56.65           O  
ATOM    251  N   ILE A  31      28.968  32.068  97.996  1.00 51.58           N  
ATOM    252  CA  ILE A  31      29.373  30.891  98.759  1.00 49.84           C  
ATOM    253  C   ILE A  31      30.428  30.061  98.033  1.00 49.75           C  
ATOM    254  O   ILE A  31      30.535  28.854  98.244  1.00 50.20           O  
ATOM    255  CB  ILE A  31      28.167  29.989  99.088  1.00 48.83           C  
ATOM    256  CG1 ILE A  31      27.434  29.597  97.803  1.00 46.46           C  
ATOM    257  CG2 ILE A  31      27.236  30.706 100.060  1.00 49.58           C  
ATOM    258  CD1 ILE A  31      26.180  28.788  98.048  1.00 44.48           C  
ATOM    259  N   GLY A  32      31.197  30.714  97.168  1.00 49.10           N  
ATOM    260  CA  GLY A  32      32.254  30.032  96.439  1.00 49.36           C  
ATOM    261  C   GLY A  32      31.900  28.896  95.490  1.00 49.26           C  
ATOM    262  O   GLY A  32      32.767  28.085  95.165  1.00 50.01           O  
ATOM    263  N   ILE A  33      30.650  28.813  95.043  1.00 48.58           N  
ATOM    264  CA  ILE A  33      30.264  27.755  94.112  1.00 48.86           C  
ATOM    265  C   ILE A  33      30.423  28.261  92.680  1.00 50.19           C  
ATOM    266  O   ILE A  33      29.850  29.285  92.307  1.00 50.40           O  
ATOM    267  CB  ILE A  33      28.795  27.313  94.313  1.00 48.88           C  
ATOM    268  CG1 ILE A  33      28.620  26.689  95.701  1.00 47.67           C  
ATOM    269  CG2 ILE A  33      28.392  26.329  93.220  1.00 47.29           C  
ATOM    270  CD1 ILE A  33      27.207  26.221  95.995  1.00 45.37           C  
ATOM    271  N   ASN A  34      31.205  27.544  91.881  1.00 51.19           N  
ATOM    272  CA  ASN A  34      31.436  27.931  90.493  1.00 51.89           C  
ATOM    273  C   ASN A  34      30.714  26.968  89.558  1.00 52.11           C  
ATOM    274  O   ASN A  34      30.433  25.823  89.924  1.00 51.78           O  
ATOM    275  CB  ASN A  34      32.937  27.913  90.179  1.00 53.99           C  
ATOM    276  CG  ASN A  34      33.763  28.640  91.226  1.00 55.53           C  
ATOM    277  OD1 ASN A  34      33.566  29.835  91.476  1.00 57.16           O  
ATOM    278  ND2 ASN A  34      34.695  27.920  91.848  1.00 55.12           N  
ATOM    279  N   GLY A  35      30.413  27.440  88.352  1.00 51.76           N  
ATOM    280  CA  GLY A  35      29.733  26.599  87.385  1.00 50.84           C  
ATOM    281  C   GLY A  35      28.335  27.075  87.051  1.00 49.63           C  
ATOM    282  O   GLY A  35      27.655  26.483  86.211  1.00 49.86           O  
ATOM    283  N   VAL A  36      27.892  28.136  87.715  1.00 49.10           N  
ATOM    284  CA  VAL A  36      26.568  28.677  87.451  1.00 47.85           C  
ATOM    285  C   VAL A  36      26.696  29.672  86.307  1.00 47.01           C  
ATOM    286  O   VAL A  36      26.750  30.878  86.525  1.00 46.73           O  
ATOM    287  CB  VAL A  36      25.990  29.390  88.685  1.00 47.66           C  
ATOM    288  CG1 VAL A  36      24.553  29.816  88.414  1.00 47.03           C  
ATOM    289  CG2 VAL A  36      26.049  28.466  89.892  1.00 46.86           C  
ATOM    290  N   ASP A  37      26.769  29.148  85.088  1.00 46.83           N  
ATOM    291  CA  ASP A  37      26.899  29.979  83.900  1.00 48.38           C  
ATOM    292  C   ASP A  37      25.658  29.921  83.021  1.00 48.05           C  
ATOM    293  O   ASP A  37      24.733  29.148  83.283  1.00 45.63           O  
ATOM    294  CB  ASP A  37      28.126  29.558  83.070  1.00 48.36           C  
ATOM    295  CG  ASP A  37      28.105  28.077  82.669  1.00 49.25           C  
ATOM    296  OD1 ASP A  37      27.032  27.427  82.732  1.00 46.84           O  
ATOM    297  OD2 ASP A  37      29.179  27.565  82.270  1.00 49.71           O  
ATOM    298  N   ARG A  38      25.641  30.758  81.987  1.00 48.87           N  
ATOM    299  CA  ARG A  38      24.522  30.780  81.061  1.00 49.82           C  
ATOM    300  C   ARG A  38      24.679  29.512  80.244  1.00 51.00           C  
ATOM    301  O   ARG A  38      25.219  29.517  79.135  1.00 53.65           O  
ATOM    302  CB  ARG A  38      24.580  32.008  80.145  1.00 49.11           C  
ATOM    303  CG  ARG A  38      23.298  32.237  79.343  1.00 47.97           C  
ATOM    304  CD  ARG A  38      23.450  33.398  78.375  1.00 47.88           C  
ATOM    305  NE  ARG A  38      23.852  34.640  79.034  1.00 46.05           N  
ATOM    306  CZ  ARG A  38      23.040  35.409  79.757  1.00 44.22           C  
ATOM    307  NH1 ARG A  38      21.767  35.073  79.922  1.00 43.23           N  
ATOM    308  NH2 ARG A  38      23.506  36.517  80.311  1.00 41.74           N  
ATOM    309  N   GLN A  39      24.222  28.419  80.835  1.00 50.60           N  
ATOM    310  CA  GLN A  39      24.277  27.097  80.240  1.00 51.42           C  
ATOM    311  C   GLN A  39      23.621  26.254  81.319  1.00 49.31           C  
ATOM    312  O   GLN A  39      22.639  25.545  81.084  1.00 48.10           O  
ATOM    313  CB  GLN A  39      25.736  26.682  80.049  1.00 53.87           C  
ATOM    314  CG  GLN A  39      25.942  25.442  79.212  1.00 57.82           C  
ATOM    315  CD  GLN A  39      27.408  25.052  79.132  1.00 61.12           C  
ATOM    316  OE1 GLN A  39      28.263  25.865  78.761  1.00 62.27           O  
ATOM    317  NE2 GLN A  39      27.708  23.803  79.480  1.00 62.79           N  
ATOM    318  N   PHE A  40      24.181  26.372  82.518  1.00 47.86           N  
ATOM    319  CA  PHE A  40      23.680  25.678  83.688  1.00 47.15           C  
ATOM    320  C   PHE A  40      22.311  26.268  84.031  1.00 46.94           C  
ATOM    321  O   PHE A  40      21.377  25.542  84.371  1.00 45.80           O  
ATOM    322  CB  PHE A  40      24.641  25.886  84.862  1.00 46.62           C  
ATOM    323  CG  PHE A  40      24.145  25.316  86.157  1.00 46.95           C  
ATOM    324  CD1 PHE A  40      24.172  23.944  86.384  1.00 45.94           C  
ATOM    325  CD2 PHE A  40      23.623  26.150  87.142  1.00 46.13           C  
ATOM    326  CE1 PHE A  40      23.686  23.407  87.575  1.00 45.98           C  
ATOM    327  CE2 PHE A  40      23.136  25.626  88.333  1.00 46.97           C  
ATOM    328  CZ  PHE A  40      23.167  24.248  88.551  1.00 46.24           C  
ATOM    329  N   ASN A  41      22.202  27.592  83.929  1.00 46.79           N  
ATOM    330  CA  ASN A  41      20.956  28.279  84.239  1.00 46.63           C  
ATOM    331  C   ASN A  41      19.789  27.728  83.431  1.00 48.04           C  
ATOM    332  O   ASN A  41      18.646  27.751  83.886  1.00 47.66           O  
ATOM    333  CB  ASN A  41      21.109  29.783  84.000  1.00 45.54           C  
ATOM    334  CG  ASN A  41      19.880  30.572  84.428  1.00 44.71           C  
ATOM    335  OD1 ASN A  41      18.995  30.861  83.618  1.00 42.45           O  
ATOM    336  ND2 ASN A  41      19.815  30.911  85.710  1.00 43.23           N  
ATOM    337  N   GLU A  42      20.078  27.220  82.239  1.00 49.76           N  
ATOM    338  CA  GLU A  42      19.038  26.652  81.387  1.00 52.74           C  
ATOM    339  C   GLU A  42      18.328  25.508  82.103  1.00 53.80           C  
ATOM    340  O   GLU A  42      17.176  25.199  81.808  1.00 53.89           O  
ATOM    341  CB  GLU A  42      19.647  26.143  80.074  1.00 54.17           C  
ATOM    342  CG  GLU A  42      20.068  27.246  79.111  1.00 55.36           C  
ATOM    343  CD  GLU A  42      18.880  28.010  78.559  1.00 57.66           C  
ATOM    344  OE1 GLU A  42      18.095  27.407  77.791  1.00 60.30           O  
ATOM    345  OE2 GLU A  42      18.724  29.206  78.895  1.00 57.78           O  
ATOM    346  N   GLN A  43      19.021  24.889  83.052  1.00 55.36           N  
ATOM    347  CA  GLN A  43      18.458  23.776  83.806  1.00 57.54           C  
ATOM    348  C   GLN A  43      17.698  24.270  85.029  1.00 59.11           C  
ATOM    349  O   GLN A  43      17.119  23.478  85.774  1.00 58.94           O  
ATOM    350  CB  GLN A  43      19.573  22.831  84.247  1.00 58.08           C  
ATOM    351  CG  GLN A  43      20.452  22.344  83.109  1.00 58.80           C  
ATOM    352  CD  GLN A  43      21.699  21.651  83.608  1.00 59.91           C  
ATOM    353  OE1 GLN A  43      21.624  20.636  84.303  1.00 60.85           O  
ATOM    354  NE2 GLN A  43      22.860  22.198  83.260  1.00 59.90           N  
ATOM    355  N   LEU A  44      17.704  25.584  85.230  1.00 60.26           N  
ATOM    356  CA  LEU A  44      17.016  26.186  86.364  1.00 62.04           C  
ATOM    357  C   LEU A  44      15.671  26.785  85.956  1.00 63.46           C  
ATOM    358  O   LEU A  44      15.014  27.455  86.755  1.00 63.67           O  
ATOM    359  CB  LEU A  44      17.893  27.274  86.985  1.00 60.13           C  
ATOM    360  CG  LEU A  44      19.255  26.819  87.504  1.00 60.10           C  
ATOM    361  CD1 LEU A  44      20.011  28.013  88.057  1.00 59.57           C  
ATOM    362  CD2 LEU A  44      19.067  25.762  88.581  1.00 59.70           C  
ATOM    363  N   LYS A  45      15.264  26.543  84.714  1.00 65.26           N  
ATOM    364  CA  LYS A  45      14.001  27.077  84.217  1.00 67.12           C  
ATOM    365  C   LYS A  45      12.831  26.138  84.470  1.00 67.41           C  
ATOM    366  O   LYS A  45      12.949  24.925  84.292  1.00 68.31           O  
ATOM    367  CB  LYS A  45      14.102  27.377  82.720  1.00 67.41           C  
ATOM    368  CG  LYS A  45      15.013  28.545  82.386  1.00 68.48           C  
ATOM    369  CD  LYS A  45      14.918  28.895  80.913  1.00 69.68           C  
ATOM    370  CE  LYS A  45      15.744  30.120  80.579  1.00 70.15           C  
ATOM    371  NZ  LYS A  45      15.590  30.480  79.144  1.00 71.18           N  
ATOM    372  N   GLY A  46      11.701  26.709  84.882  1.00 67.73           N  
ATOM    373  CA  GLY A  46      10.524  25.907  85.160  1.00 67.25           C  
ATOM    374  C   GLY A  46      10.752  25.003  86.355  1.00 67.15           C  
ATOM    375  O   GLY A  46      10.053  24.002  86.538  1.00 67.00           O  
ATOM    376  N   VAL A  47      11.742  25.355  87.170  1.00 66.79           N  
ATOM    377  CA  VAL A  47      12.077  24.585  88.366  1.00 65.85           C  
ATOM    378  C   VAL A  47      11.786  25.439  89.603  1.00 65.39           C  
ATOM    379  O   VAL A  47      11.688  26.664  89.503  1.00 65.83           O  
ATOM    380  CB  VAL A  47      13.567  24.179  88.356  1.00 65.30           C  
ATOM    381  CG1 VAL A  47      13.876  23.296  89.544  1.00 66.24           C  
ATOM    382  CG2 VAL A  47      13.899  23.458  87.060  1.00 64.92           C  
ATOM    383  N   SER A  48      11.633  24.799  90.761  1.00 64.35           N  
ATOM    384  CA  SER A  48      11.350  25.521  92.003  1.00 62.46           C  
ATOM    385  C   SER A  48      12.621  26.168  92.543  1.00 61.35           C  
ATOM    386  O   SER A  48      13.731  25.728  92.234  1.00 61.09           O  
ATOM    387  CB  SER A  48      10.781  24.569  93.063  1.00 63.14           C  
ATOM    388  OG  SER A  48      11.764  23.649  93.509  1.00 60.62           O  
ATOM    389  N   ARG A  49      12.455  27.210  93.355  1.00 59.62           N  
ATOM    390  CA  ARG A  49      13.597  27.910  93.925  1.00 58.48           C  
ATOM    391  C   ARG A  49      14.378  26.968  94.828  1.00 57.76           C  
ATOM    392  O   ARG A  49      15.597  27.071  94.942  1.00 57.21           O  
ATOM    393  CB  ARG A  49      13.131  29.134  94.712  1.00 58.62           C  
ATOM    394  CG  ARG A  49      14.186  30.217  94.846  1.00 58.07           C  
ATOM    395  CD  ARG A  49      13.546  31.550  95.171  1.00 58.44           C  
ATOM    396  NE  ARG A  49      13.166  31.653  96.574  1.00 58.37           N  
ATOM    397  CZ  ARG A  49      12.278  32.523  97.042  1.00 58.82           C  
ATOM    398  NH1 ARG A  49      11.670  33.362  96.212  1.00 58.25           N  
ATOM    399  NH2 ARG A  49      12.005  32.566  98.341  1.00 58.03           N  
ATOM    400  N   GLU A  50      13.667  26.044  95.466  1.00 57.19           N  
ATOM    401  CA  GLU A  50      14.304  25.070  96.340  1.00 56.36           C  
ATOM    402  C   GLU A  50      15.079  24.080  95.478  1.00 54.69           C  
ATOM    403  O   GLU A  50      16.254  23.817  95.728  1.00 53.66           O  
ATOM    404  CB  GLU A  50      13.257  24.323  97.171  1.00 58.19           C  
ATOM    405  CG  GLU A  50      12.599  25.149  98.273  1.00 60.38           C  
ATOM    406  CD  GLU A  50      11.774  26.312  97.741  1.00 62.17           C  
ATOM    407  OE1 GLU A  50      10.836  26.065  96.945  1.00 62.60           O  
ATOM    408  OE2 GLU A  50      12.062  27.471  98.123  1.00 61.76           O  
ATOM    409  N   ASP A  51      14.420  23.541  94.457  1.00 52.97           N  
ATOM    410  CA  ASP A  51      15.067  22.585  93.566  1.00 51.80           C  
ATOM    411  C   ASP A  51      16.261  23.210  92.842  1.00 50.29           C  
ATOM    412  O   ASP A  51      17.282  22.546  92.647  1.00 50.43           O  
ATOM    413  CB  ASP A  51      14.061  22.034  92.547  1.00 54.10           C  
ATOM    414  CG  ASP A  51      13.004  21.135  93.186  1.00 55.87           C  
ATOM    415  OD1 ASP A  51      12.070  20.699  92.472  1.00 55.83           O  
ATOM    416  OD2 ASP A  51      13.113  20.865  94.403  1.00 58.50           O  
ATOM    417  N   SER A  52      16.136  24.480  92.451  1.00 47.26           N  
ATOM    418  CA  SER A  52      17.219  25.189  91.758  1.00 43.38           C  
ATOM    419  C   SER A  52      18.435  25.359  92.655  1.00 40.31           C  
ATOM    420  O   SER A  52      19.566  25.119  92.235  1.00 37.98           O  
ATOM    421  CB  SER A  52      16.757  26.567  91.285  1.00 43.03           C  
ATOM    422  OG  SER A  52      15.869  26.463  90.194  1.00 45.02           O  
ATOM    423  N   LEU A  53      18.201  25.793  93.887  1.00 38.61           N  
ATOM    424  CA  LEU A  53      19.286  25.974  94.839  1.00 38.31           C  
ATOM    425  C   LEU A  53      19.972  24.630  95.072  1.00 38.26           C  
ATOM    426  O   LEU A  53      21.198  24.558  95.197  1.00 37.33           O  
ATOM    427  CB  LEU A  53      18.746  26.506  96.167  1.00 36.87           C  
ATOM    428  CG  LEU A  53      19.757  26.531  97.316  1.00 36.58           C  
ATOM    429  CD1 LEU A  53      20.953  27.397  96.934  1.00 35.24           C  
ATOM    430  CD2 LEU A  53      19.083  27.056  98.583  1.00 37.09           C  
ATOM    431  N   GLN A  54      19.176  23.565  95.126  1.00 39.07           N  
ATOM    432  CA  GLN A  54      19.721  22.230  95.350  1.00 40.46           C  
ATOM    433  C   GLN A  54      20.621  21.818  94.192  1.00 40.34           C  
ATOM    434  O   GLN A  54      21.709  21.278  94.406  1.00 38.42           O  
ATOM    435  CB  GLN A  54      18.602  21.199  95.525  1.00 40.83           C  
ATOM    436  CG  GLN A  54      19.130  19.849  95.990  1.00 41.90           C  
ATOM    437  CD  GLN A  54      19.920  19.966  97.287  1.00 43.65           C  
ATOM    438  OE1 GLN A  54      19.352  20.234  98.350  1.00 43.74           O  
ATOM    439  NE2 GLN A  54      21.239  19.784  97.203  1.00 42.27           N  
ATOM    440  N   LYS A  55      20.163  22.079  92.971  1.00 39.74           N  
ATOM    441  CA  LYS A  55      20.939  21.749  91.785  1.00 40.00           C  
ATOM    442  C   LYS A  55      22.290  22.439  91.897  1.00 40.11           C  
ATOM    443  O   LYS A  55      23.324  21.846  91.592  1.00 40.51           O  
ATOM    444  CB  LYS A  55      20.223  22.236  90.525  1.00 41.11           C  
ATOM    445  CG  LYS A  55      19.971  21.158  89.487  1.00 44.58           C  
ATOM    446  CD  LYS A  55      19.404  21.759  88.206  1.00 47.64           C  
ATOM    447  CE  LYS A  55      18.990  20.681  87.207  1.00 50.22           C  
ATOM    448  NZ  LYS A  55      20.115  19.759  86.859  1.00 50.45           N  
ATOM    449  N   ILE A  56      22.270  23.694  92.351  1.00 39.58           N  
ATOM    450  CA  ILE A  56      23.485  24.490  92.503  1.00 39.13           C  
ATOM    451  C   ILE A  56      24.386  23.937  93.595  1.00 41.03           C  
ATOM    452  O   ILE A  56      25.614  23.972  93.473  1.00 39.82           O  
ATOM    453  CB  ILE A  56      23.167  25.960  92.858  1.00 36.94           C  
ATOM    454  CG1 ILE A  56      22.367  26.612  91.731  1.00 35.76           C  
ATOM    455  CG2 ILE A  56      24.459  26.725  93.115  1.00 34.50           C  
ATOM    456  CD1 ILE A  56      22.019  28.060  91.994  1.00 34.53           C  
ATOM    457  N   LEU A  57      23.781  23.445  94.671  1.00 42.52           N  
ATOM    458  CA  LEU A  57      24.567  22.887  95.761  1.00 44.90           C  
ATOM    459  C   LEU A  57      25.170  21.559  95.306  1.00 45.51           C  
ATOM    460  O   LEU A  57      26.295  21.226  95.678  1.00 44.81           O  
ATOM    461  CB  LEU A  57      23.704  22.716  97.018  1.00 43.43           C  
ATOM    462  CG  LEU A  57      23.283  24.042  97.675  1.00 43.26           C  
ATOM    463  CD1 LEU A  57      22.338  23.772  98.833  1.00 41.35           C  
ATOM    464  CD2 LEU A  57      24.514  24.801  98.151  1.00 41.36           C  
ATOM    465  N   ASP A  58      24.429  20.824  94.476  1.00 47.06           N  
ATOM    466  CA  ASP A  58      24.901  19.546  93.940  1.00 48.29           C  
ATOM    467  C   ASP A  58      26.106  19.726  93.010  1.00 49.46           C  
ATOM    468  O   ASP A  58      26.761  18.749  92.643  1.00 50.41           O  
ATOM    469  CB  ASP A  58      23.783  18.824  93.173  1.00 46.90           C  
ATOM    470  CG  ASP A  58      22.772  18.164  94.091  1.00 46.99           C  
ATOM    471  OD1 ASP A  58      23.085  17.986  95.288  1.00 47.51           O  
ATOM    472  OD2 ASP A  58      21.669  17.808  93.617  1.00 44.98           O  
ATOM    473  N   LEU A  59      26.394  20.967  92.621  1.00 50.20           N  
ATOM    474  CA  LEU A  59      27.530  21.237  91.745  1.00 51.07           C  
ATOM    475  C   LEU A  59      28.843  21.128  92.501  1.00 51.78           C  
ATOM    476  O   LEU A  59      29.869  20.750  91.933  1.00 52.77           O  
ATOM    477  CB  LEU A  59      27.439  22.634  91.130  1.00 51.15           C  
ATOM    478  CG  LEU A  59      26.453  22.870  89.991  1.00 52.48           C  
ATOM    479  CD1 LEU A  59      26.622  24.301  89.493  1.00 52.10           C  
ATOM    480  CD2 LEU A  59      26.708  21.880  88.859  1.00 52.05           C  
ATOM    481  N   ALA A  60      28.817  21.482  93.779  1.00 51.31           N  
ATOM    482  CA  ALA A  60      30.021  21.407  94.589  1.00 52.57           C  
ATOM    483  C   ALA A  60      29.814  20.413  95.721  1.00 52.80           C  
ATOM    484  O   ALA A  60      30.613  20.353  96.660  1.00 53.27           O  
ATOM    485  CB  ALA A  60      30.364  22.781  95.153  1.00 52.90           C  
ATOM    486  N   ASP A  61      28.742  19.630  95.623  1.00 52.42           N  
ATOM    487  CA  ASP A  61      28.424  18.649  96.648  1.00 52.31           C  
ATOM    488  C   ASP A  61      28.488  19.366  97.989  1.00 52.88           C  
ATOM    489  O   ASP A  61      29.064  18.864  98.955  1.00 52.61           O  
ATOM    490  CB  ASP A  61      29.441  17.508  96.611  1.00 52.61           C  
ATOM    491  CG  ASP A  61      29.602  16.926  95.223  1.00 51.75           C  
ATOM    492  OD1 ASP A  61      30.691  17.085  94.632  1.00 50.86           O  
ATOM    493  OD2 ASP A  61      28.631  16.319  94.721  1.00 50.85           O  
ATOM    494  N   LYS A  62      27.903  20.558  98.021  1.00 53.75           N  
ATOM    495  CA  LYS A  62      27.877  21.389  99.215  1.00 54.10           C  
ATOM    496  C   LYS A  62      26.709  20.969 100.098  1.00 54.32           C  
ATOM    497  O   LYS A  62      25.567  20.872  99.638  1.00 54.23           O  
ATOM    498  CB  LYS A  62      27.724  22.860  98.819  1.00 55.26           C  
ATOM    499  CG  LYS A  62      28.163  23.875  99.875  1.00 56.62           C  
ATOM    500  CD  LYS A  62      29.683  23.915 100.004  1.00 59.29           C  
ATOM    501  CE  LYS A  62      30.165  25.212 100.662  1.00 60.83           C  
ATOM    502  NZ  LYS A  62      29.626  25.412 102.041  1.00 61.12           N  
ATOM    503  N   LYS A  63      27.000  20.701 101.366  1.00 53.66           N  
ATOM    504  CA  LYS A  63      25.965  20.308 102.305  1.00 53.68           C  
ATOM    505  C   LYS A  63      25.707  21.506 103.215  1.00 53.16           C  
ATOM    506  O   LYS A  63      26.628  22.254 103.542  1.00 51.52           O  
ATOM    507  CB  LYS A  63      26.426  19.108 103.139  1.00 55.04           C  
ATOM    508  CG  LYS A  63      27.078  17.984 102.340  1.00 55.76           C  
ATOM    509  CD  LYS A  63      26.164  17.437 101.248  1.00 57.33           C  
ATOM    510  CE  LYS A  63      26.893  16.393 100.402  1.00 57.15           C  
ATOM    511  NZ  LYS A  63      26.117  16.002  99.193  1.00 56.86           N  
ATOM    512  N   VAL A  64      24.451  21.693 103.604  1.00 53.67           N  
ATOM    513  CA  VAL A  64      24.068  22.797 104.481  1.00 54.95           C  
ATOM    514  C   VAL A  64      22.851  22.392 105.301  1.00 56.27           C  
ATOM    515  O   VAL A  64      22.066  21.540 104.878  1.00 54.61           O  
ATOM    516  CB  VAL A  64      23.713  24.079 103.676  1.00 54.29           C  
ATOM    517  CG1 VAL A  64      24.934  24.586 102.920  1.00 53.51           C  
ATOM    518  CG2 VAL A  64      22.567  23.790 102.712  1.00 53.53           C  
ATOM    519  N   SER A  65      22.702  23.000 106.475  1.00 58.84           N  
ATOM    520  CA  SER A  65      21.572  22.706 107.351  1.00 61.63           C  
ATOM    521  C   SER A  65      20.290  23.197 106.693  1.00 63.91           C  
ATOM    522  O   SER A  65      20.327  24.121 105.877  1.00 64.24           O  
ATOM    523  CB  SER A  65      21.749  23.408 108.698  1.00 61.36           C  
ATOM    524  OG  SER A  65      21.840  24.813 108.527  1.00 62.33           O  
ATOM    525  N   ALA A  66      19.162  22.581 107.036  1.00 65.42           N  
ATOM    526  CA  ALA A  66      17.880  22.990 106.469  1.00 66.58           C  
ATOM    527  C   ALA A  66      17.684  24.478 106.756  1.00 67.53           C  
ATOM    528  O   ALA A  66      16.937  25.170 106.059  1.00 67.80           O  
ATOM    529  CB  ALA A  66      16.749  22.177 107.085  1.00 66.34           C  
ATOM    530  N   GLU A  67      18.370  24.953 107.791  1.00 68.02           N  
ATOM    531  CA  GLU A  67      18.313  26.350 108.206  1.00 68.99           C  
ATOM    532  C   GLU A  67      19.070  27.197 107.186  1.00 68.43           C  
ATOM    533  O   GLU A  67      18.527  28.149 106.621  1.00 68.68           O  
ATOM    534  CB  GLU A  67      18.963  26.507 109.584  1.00 70.86           C  
ATOM    535  CG  GLU A  67      18.880  27.907 110.167  1.00 73.88           C  
ATOM    536  CD  GLU A  67      17.634  28.120 111.007  1.00 76.29           C  
ATOM    537  OE1 GLU A  67      17.519  27.465 112.067  1.00 77.63           O  
ATOM    538  OE2 GLU A  67      16.775  28.941 110.612  1.00 78.04           O  
ATOM    539  N   GLU A  68      20.329  26.841 106.959  1.00 67.41           N  
ATOM    540  CA  GLU A  68      21.173  27.554 106.008  1.00 66.48           C  
ATOM    541  C   GLU A  68      20.569  27.486 104.606  1.00 64.51           C  
ATOM    542  O   GLU A  68      20.798  28.364 103.776  1.00 63.60           O  
ATOM    543  CB  GLU A  68      22.574  26.940 105.990  1.00 67.77           C  
ATOM    544  CG  GLU A  68      23.698  27.923 106.281  1.00 70.68           C  
ATOM    545  CD  GLU A  68      23.706  29.113 105.332  1.00 72.87           C  
ATOM    546  OE1 GLU A  68      22.765  29.935 105.393  1.00 74.28           O  
ATOM    547  OE2 GLU A  68      24.656  29.229 104.525  1.00 73.61           O  
ATOM    548  N   PHE A  69      19.799  26.434 104.356  1.00 62.32           N  
ATOM    549  CA  PHE A  69      19.164  26.224 103.063  1.00 60.33           C  
ATOM    550  C   PHE A  69      18.089  27.279 102.818  1.00 59.22           C  
ATOM    551  O   PHE A  69      18.056  27.907 101.763  1.00 58.61           O  
ATOM    552  CB  PHE A  69      18.538  24.828 103.009  1.00 59.18           C  
ATOM    553  CG  PHE A  69      17.968  24.470 101.667  1.00 57.64           C  
ATOM    554  CD1 PHE A  69      18.803  24.114 100.615  1.00 57.64           C  
ATOM    555  CD2 PHE A  69      16.592  24.494 101.451  1.00 57.58           C  
ATOM    556  CE1 PHE A  69      18.276  23.786  99.366  1.00 56.99           C  
ATOM    557  CE2 PHE A  69      16.052  24.169 100.205  1.00 56.48           C  
ATOM    558  CZ  PHE A  69      16.896  23.815  99.161  1.00 57.31           C  
ATOM    559  N   LYS A  70      17.207  27.463 103.795  1.00 58.01           N  
ATOM    560  CA  LYS A  70      16.141  28.448 103.674  1.00 57.09           C  
ATOM    561  C   LYS A  70      16.712  29.854 103.597  1.00 55.40           C  
ATOM    562  O   LYS A  70      16.164  30.718 102.910  1.00 55.40           O  
ATOM    563  CB  LYS A  70      15.183  28.361 104.865  1.00 57.77           C  
ATOM    564  CG  LYS A  70      14.295  27.132 104.877  1.00 58.94           C  
ATOM    565  CD  LYS A  70      13.342  27.172 106.060  1.00 60.76           C  
ATOM    566  CE  LYS A  70      12.393  25.981 106.059  1.00 60.93           C  
ATOM    567  NZ  LYS A  70      11.408  26.075 107.173  1.00 62.61           N  
ATOM    568  N   GLU A  71      17.815  30.085 104.299  1.00 52.70           N  
ATOM    569  CA  GLU A  71      18.431  31.403 104.300  1.00 51.64           C  
ATOM    570  C   GLU A  71      19.071  31.716 102.947  1.00 50.17           C  
ATOM    571  O   GLU A  71      19.059  32.868 102.504  1.00 50.46           O  
ATOM    572  CB  GLU A  71      19.475  31.500 105.414  1.00 51.34           C  
ATOM    573  CG  GLU A  71      19.626  32.899 106.002  1.00 52.73           C  
ATOM    574  CD  GLU A  71      18.298  33.483 106.497  1.00 54.16           C  
ATOM    575  OE1 GLU A  71      17.455  32.717 107.025  1.00 54.53           O  
ATOM    576  OE2 GLU A  71      18.104  34.714 106.369  1.00 52.38           O  
ATOM    577  N   LEU A  72      19.630  30.698 102.297  1.00 47.52           N  
ATOM    578  CA  LEU A  72      20.249  30.882 100.988  1.00 44.27           C  
ATOM    579  C   LEU A  72      19.150  31.208  99.996  1.00 42.21           C  
ATOM    580  O   LEU A  72      19.292  32.102  99.166  1.00 41.40           O  
ATOM    581  CB  LEU A  72      20.975  29.613 100.540  1.00 43.24           C  
ATOM    582  CG  LEU A  72      22.304  29.324 101.232  1.00 43.43           C  
ATOM    583  CD1 LEU A  72      22.903  28.051 100.656  1.00 44.05           C  
ATOM    584  CD2 LEU A  72      23.252  30.496 101.036  1.00 41.78           C  
ATOM    585  N   ALA A  73      18.053  30.468 100.095  1.00 40.68           N  
ATOM    586  CA  ALA A  73      16.906  30.678  99.228  1.00 40.44           C  
ATOM    587  C   ALA A  73      16.438  32.133  99.376  1.00 40.16           C  
ATOM    588  O   ALA A  73      16.184  32.817  98.380  1.00 39.67           O  
ATOM    589  CB  ALA A  73      15.788  29.707  99.605  1.00 39.11           C  
ATOM    590  N   LYS A  74      16.340  32.604 100.618  1.00 38.57           N  
ATOM    591  CA  LYS A  74      15.921  33.978 100.882  1.00 38.83           C  
ATOM    592  C   LYS A  74      16.912  34.973 100.273  1.00 37.49           C  
ATOM    593  O   LYS A  74      16.517  35.982  99.704  1.00 34.92           O  
ATOM    594  CB  LYS A  74      15.805  34.225 102.395  1.00 40.19           C  
ATOM    595  CG  LYS A  74      15.623  35.702 102.787  1.00 41.26           C  
ATOM    596  CD  LYS A  74      15.527  35.871 104.303  1.00 43.29           C  
ATOM    597  CE  LYS A  74      15.361  37.335 104.720  1.00 43.26           C  
ATOM    598  NZ  LYS A  74      16.578  38.162 104.488  1.00 42.68           N  
ATOM    599  N   ARG A  75      18.201  34.680 100.400  1.00 38.18           N  
ATOM    600  CA  ARG A  75      19.232  35.560  99.858  1.00 39.42           C  
ATOM    601  C   ARG A  75      19.078  35.739  98.356  1.00 35.55           C  
ATOM    602  O   ARG A  75      19.223  36.843  97.836  1.00 33.65           O  
ATOM    603  CB  ARG A  75      20.630  35.002 100.158  1.00 44.64           C  
ATOM    604  CG  ARG A  75      21.093  35.148 101.597  1.00 52.75           C  
ATOM    605  CD  ARG A  75      21.372  36.600 101.962  1.00 61.24           C  
ATOM    606  NE  ARG A  75      22.375  37.227 101.097  1.00 68.33           N  
ATOM    607  CZ  ARG A  75      22.096  38.000 100.046  1.00 70.91           C  
ATOM    608  NH1 ARG A  75      20.839  38.257  99.714  1.00 72.10           N  
ATOM    609  NH2 ARG A  75      23.081  38.518  99.322  1.00 72.30           N  
ATOM    610  N   LYS A  76      18.790  34.648  97.659  1.00 33.30           N  
ATOM    611  CA  LYS A  76      18.630  34.713  96.215  1.00 31.47           C  
ATOM    612  C   LYS A  76      17.503  35.679  95.880  1.00 30.79           C  
ATOM    613  O   LYS A  76      17.645  36.532  94.998  1.00 29.17           O  
ATOM    614  CB  LYS A  76      18.333  33.318  95.645  1.00 31.32           C  
ATOM    615  CG  LYS A  76      18.151  33.272  94.128  1.00 28.23           C  
ATOM    616  CD  LYS A  76      16.733  33.603  93.736  1.00 27.95           C  
ATOM    617  CE  LYS A  76      16.565  33.697  92.236  1.00 28.74           C  
ATOM    618  NZ  LYS A  76      15.121  33.845  91.871  1.00 29.49           N  
ATOM    619  N   ASN A  77      16.389  35.549  96.595  1.00 29.28           N  
ATOM    620  CA  ASN A  77      15.238  36.413  96.365  1.00 28.04           C  
ATOM    621  C   ASN A  77      15.544  37.880  96.664  1.00 27.79           C  
ATOM    622  O   ASN A  77      15.114  38.775  95.920  1.00 25.36           O  
ATOM    623  CB  ASN A  77      14.049  35.961  97.206  1.00 29.46           C  
ATOM    624  CG  ASN A  77      12.787  36.727  96.870  1.00 29.77           C  
ATOM    625  OD1 ASN A  77      12.276  36.644  95.752  1.00 28.63           O  
ATOM    626  ND2 ASN A  77      12.285  37.486  97.833  1.00 31.28           N  
ATOM    627  N   ASP A  78      16.285  38.134  97.743  1.00 25.54           N  
ATOM    628  CA  ASP A  78      16.642  39.506  98.083  1.00 26.45           C  
ATOM    629  C   ASP A  78      17.515  40.110  96.994  1.00 25.02           C  
ATOM    630  O   ASP A  78      17.410  41.302  96.698  1.00 25.05           O  
ATOM    631  CB  ASP A  78      17.397  39.592  99.412  1.00 29.07           C  
ATOM    632  CG  ASP A  78      16.568  39.133 100.588  1.00 30.63           C  
ATOM    633  OD1 ASP A  78      15.349  39.411 100.617  1.00 31.36           O  
ATOM    634  OD2 ASP A  78      17.145  38.505 101.496  1.00 34.21           O  
ATOM    635  N   ASN A  79      18.383  39.300  96.402  1.00 23.30           N  
ATOM    636  CA  ASN A  79      19.238  39.815  95.345  1.00 24.59           C  
ATOM    637  C   ASN A  79      18.337  40.211  94.196  1.00 23.04           C  
ATOM    638  O   ASN A  79      18.437  41.316  93.658  1.00 23.29           O  
ATOM    639  CB  ASN A  79      20.232  38.761  94.853  1.00 27.06           C  
ATOM    640  CG  ASN A  79      21.225  38.343  95.917  1.00 30.15           C  
ATOM    641  OD1 ASN A  79      21.560  39.119  96.827  1.00 29.87           O  
ATOM    642  ND2 ASN A  79      21.725  37.108  95.797  1.00 30.88           N  
ATOM    643  N   TYR A  80      17.442  39.300  93.837  1.00 22.02           N  
ATOM    644  CA  TYR A  80      16.505  39.520  92.747  1.00 21.27           C  
ATOM    645  C   TYR A  80      15.678  40.794  92.923  1.00 21.69           C  
ATOM    646  O   TYR A  80      15.553  41.598  91.997  1.00 21.77           O  
ATOM    647  CB  TYR A  80      15.566  38.327  92.623  1.00 18.72           C  
ATOM    648  CG  TYR A  80      14.519  38.521  91.572  1.00 20.87           C  
ATOM    649  CD1 TYR A  80      14.863  38.570  90.216  1.00 17.59           C  
ATOM    650  CD2 TYR A  80      13.175  38.674  91.924  1.00 20.74           C  
ATOM    651  CE1 TYR A  80      13.895  38.768  89.242  1.00 19.27           C  
ATOM    652  CE2 TYR A  80      12.196  38.873  90.955  1.00 17.96           C  
ATOM    653  CZ  TYR A  80      12.564  38.922  89.621  1.00 19.32           C  
ATOM    654  OH  TYR A  80      11.606  39.145  88.668  1.00 17.72           O  
ATOM    655  N   VAL A  81      15.118  40.966  94.114  1.00 21.79           N  
ATOM    656  CA  VAL A  81      14.292  42.123  94.412  1.00 22.33           C  
ATOM    657  C   VAL A  81      15.124  43.399  94.338  1.00 23.90           C  
ATOM    658  O   VAL A  81      14.628  44.450  93.930  1.00 21.97           O  
ATOM    659  CB  VAL A  81      13.613  41.959  95.816  1.00 24.50           C  
ATOM    660  CG1 VAL A  81      12.892  43.240  96.230  1.00 20.42           C  
ATOM    661  CG2 VAL A  81      12.613  40.779  95.771  1.00 21.07           C  
ATOM    662  N   LYS A  82      16.397  43.302  94.714  1.00 24.85           N  
ATOM    663  CA  LYS A  82      17.284  44.455  94.656  1.00 26.41           C  
ATOM    664  C   LYS A  82      17.590  44.774  93.199  1.00 25.50           C  
ATOM    665  O   LYS A  82      17.608  45.941  92.788  1.00 23.67           O  
ATOM    666  CB  LYS A  82      18.593  44.173  95.397  1.00 30.27           C  
ATOM    667  CG  LYS A  82      19.560  45.342  95.378  1.00 33.92           C  
ATOM    668  CD  LYS A  82      20.787  45.087  96.253  1.00 38.32           C  
ATOM    669  CE  LYS A  82      21.641  46.347  96.397  1.00 37.88           C  
ATOM    670  NZ  LYS A  82      22.790  46.128  97.322  1.00 39.87           N  
ATOM    671  N   MET A  83      17.832  43.729  92.415  1.00 23.48           N  
ATOM    672  CA  MET A  83      18.134  43.909  91.000  1.00 22.84           C  
ATOM    673  C   MET A  83      16.986  44.507  90.180  1.00 20.98           C  
ATOM    674  O   MET A  83      17.246  45.208  89.219  1.00 18.96           O  
ATOM    675  CB  MET A  83      18.570  42.584  90.363  1.00 21.13           C  
ATOM    676  CG  MET A  83      19.992  42.163  90.697  1.00 20.56           C  
ATOM    677  SD  MET A  83      20.307  40.409  90.349  1.00 20.37           S  
ATOM    678  CE  MET A  83      21.895  40.276  91.139  1.00 22.25           C  
ATOM    679  N   ILE A  84      15.728  44.257  90.552  1.00 19.73           N  
ATOM    680  CA  ILE A  84      14.629  44.807  89.757  1.00 19.94           C  
ATOM    681  C   ILE A  84      14.194  46.221  90.136  1.00 21.21           C  
ATOM    682  O   ILE A  84      13.266  46.766  89.534  1.00 20.16           O  
ATOM    683  CB  ILE A  84      13.364  43.894  89.773  1.00 18.09           C  
ATOM    684  CG1 ILE A  84      12.876  43.691  91.203  1.00 15.84           C  
ATOM    685  CG2 ILE A  84      13.657  42.572  89.077  1.00 18.65           C  
ATOM    686  CD1 ILE A  84      11.602  42.894  91.291  1.00 14.92           C  
ATOM    687  N   GLN A  85      14.856  46.813  91.126  1.00 21.39           N  
ATOM    688  CA  GLN A  85      14.522  48.165  91.558  1.00 24.86           C  
ATOM    689  C   GLN A  85      14.655  49.200  90.440  1.00 27.03           C  
ATOM    690  O   GLN A  85      13.986  50.233  90.466  1.00 28.41           O  
ATOM    691  CB  GLN A  85      15.404  48.589  92.745  1.00 23.67           C  
ATOM    692  CG  GLN A  85      15.066  47.875  94.051  1.00 24.37           C  
ATOM    693  CD  GLN A  85      13.578  47.928  94.380  1.00 23.67           C  
ATOM    694  OE1 GLN A  85      13.023  48.995  94.638  1.00 22.30           O  
ATOM    695  NE2 GLN A  85      12.927  46.773  94.357  1.00 22.80           N  
ATOM    696  N   ASP A  86      15.492  48.901  89.453  1.00 28.48           N  
ATOM    697  CA  ASP A  86      15.742  49.815  88.346  1.00 31.42           C  
ATOM    698  C   ASP A  86      14.959  49.538  87.071  1.00 30.85           C  
ATOM    699  O   ASP A  86      15.236  50.134  86.028  1.00 31.32           O  
ATOM    700  CB  ASP A  86      17.238  49.826  88.037  1.00 34.99           C  
ATOM    701  CG  ASP A  86      18.059  50.290  89.226  1.00 40.10           C  
ATOM    702  OD1 ASP A  86      19.168  49.745  89.445  1.00 40.17           O  
ATOM    703  OD2 ASP A  86      17.579  51.204  89.943  1.00 41.46           O  
ATOM    704  N   VAL A  87      13.998  48.624  87.136  1.00 28.09           N  
ATOM    705  CA  VAL A  87      13.193  48.347  85.967  1.00 25.09           C  
ATOM    706  C   VAL A  87      12.461  49.651  85.654  1.00 24.49           C  
ATOM    707  O   VAL A  87      11.996  50.345  86.561  1.00 22.55           O  
ATOM    708  CB  VAL A  87      12.177  47.229  86.237  1.00 24.14           C  
ATOM    709  CG1 VAL A  87      11.233  47.102  85.049  1.00 22.91           C  
ATOM    710  CG2 VAL A  87      12.912  45.910  86.464  1.00 22.01           C  
ATOM    711  N   SER A  88      12.379  49.993  84.377  1.00 24.54           N  
ATOM    712  CA  SER A  88      11.717  51.225  83.971  1.00 26.21           C  
ATOM    713  C   SER A  88      10.959  51.021  82.660  1.00 25.04           C  
ATOM    714  O   SER A  88      11.036  49.957  82.052  1.00 23.99           O  
ATOM    715  CB  SER A  88      12.759  52.330  83.783  1.00 27.77           C  
ATOM    716  OG  SER A  88      13.525  52.089  82.616  1.00 30.93           O  
ATOM    717  N   PRO A  89      10.230  52.051  82.202  1.00 23.65           N  
ATOM    718  CA  PRO A  89       9.463  51.972  80.956  1.00 23.58           C  
ATOM    719  C   PRO A  89      10.286  51.543  79.742  1.00 24.45           C  
ATOM    720  O   PRO A  89       9.759  50.951  78.807  1.00 22.75           O  
ATOM    721  CB  PRO A  89       8.908  53.390  80.807  1.00 25.04           C  
ATOM    722  CG  PRO A  89       8.697  53.806  82.243  1.00 24.14           C  
ATOM    723  CD  PRO A  89       9.975  53.327  82.896  1.00 23.15           C  
ATOM    724  N   ALA A  90      11.580  51.852  79.761  1.00 24.29           N  
ATOM    725  CA  ALA A  90      12.474  51.504  78.664  1.00 22.53           C  
ATOM    726  C   ALA A  90      12.600  49.984  78.523  1.00 22.48           C  
ATOM    727  O   ALA A  90      12.998  49.472  77.465  1.00 20.96           O  
ATOM    728  CB  ALA A  90      13.856  52.124  78.904  1.00 20.40           C  
ATOM    729  N   ASP A  91      12.256  49.267  79.589  1.00 22.60           N  
ATOM    730  CA  ASP A  91      12.356  47.812  79.583  1.00 21.62           C  
ATOM    731  C   ASP A  91      11.130  47.104  79.017  1.00 21.94           C  
ATOM    732  O   ASP A  91      11.086  45.876  79.003  1.00 22.78           O  
ATOM    733  CB  ASP A  91      12.632  47.291  80.994  1.00 21.14           C  
ATOM    734  CG  ASP A  91      13.897  47.879  81.593  1.00 23.80           C  
ATOM    735  OD1 ASP A  91      14.899  47.988  80.852  1.00 26.61           O  
ATOM    736  OD2 ASP A  91      13.898  48.219  82.799  1.00 20.11           O  
ATOM    737  N   VAL A  92      10.133  47.860  78.565  1.00 18.97           N  
ATOM    738  CA  VAL A  92       8.952  47.242  77.980  1.00 18.60           C  
ATOM    739  C   VAL A  92       9.303  46.728  76.571  1.00 19.80           C  
ATOM    740  O   VAL A  92       9.875  47.455  75.759  1.00 20.32           O  
ATOM    741  CB  VAL A  92       7.779  48.249  77.886  1.00 18.56           C  
ATOM    742  CG1 VAL A  92       6.570  47.595  77.229  1.00 15.33           C  
ATOM    743  CG2 VAL A  92       7.415  48.745  79.277  1.00 17.68           C  
ATOM    744  N   TYR A  93       8.967  45.473  76.290  1.00 19.11           N  
ATOM    745  CA  TYR A  93       9.244  44.875  74.993  1.00 17.46           C  
ATOM    746  C   TYR A  93       8.610  45.640  73.847  1.00 19.48           C  
ATOM    747  O   TYR A  93       7.608  46.333  74.024  1.00 22.27           O  
ATOM    748  CB  TYR A  93       8.759  43.423  74.949  1.00 17.45           C  
ATOM    749  CG  TYR A  93       9.773  42.413  75.449  1.00 18.36           C  
ATOM    750  CD1 TYR A  93       9.595  41.049  75.209  1.00 20.79           C  
ATOM    751  CD2 TYR A  93      10.919  42.814  76.139  1.00 17.82           C  
ATOM    752  CE1 TYR A  93      10.534  40.108  75.635  1.00 19.27           C  
ATOM    753  CE2 TYR A  93      11.863  41.880  76.575  1.00 18.50           C  
ATOM    754  CZ  TYR A  93      11.659  40.529  76.317  1.00 19.08           C  
ATOM    755  OH  TYR A  93      12.573  39.594  76.736  1.00 18.74           O  
ATOM    756  N   PRO A  94       9.207  45.545  72.651  1.00 19.35           N  
ATOM    757  CA  PRO A  94       8.681  46.239  71.468  1.00 17.75           C  
ATOM    758  C   PRO A  94       7.246  45.835  71.123  1.00 17.62           C  
ATOM    759  O   PRO A  94       6.901  44.641  71.126  1.00 15.94           O  
ATOM    760  CB  PRO A  94       9.659  45.837  70.361  1.00 17.70           C  
ATOM    761  CG  PRO A  94      10.956  45.663  71.103  1.00 19.99           C  
ATOM    762  CD  PRO A  94      10.526  44.944  72.376  1.00 17.21           C  
ATOM    763  N   GLY A  95       6.420  46.840  70.838  1.00 16.35           N  
ATOM    764  CA  GLY A  95       5.042  46.610  70.456  1.00 17.06           C  
ATOM    765  C   GLY A  95       4.032  46.502  71.580  1.00 17.65           C  
ATOM    766  O   GLY A  95       2.851  46.756  71.373  1.00 20.51           O  
ATOM    767  N   ILE A  96       4.485  46.144  72.774  1.00 17.63           N  
ATOM    768  CA  ILE A  96       3.582  45.978  73.909  1.00 13.73           C  
ATOM    769  C   ILE A  96       2.851  47.245  74.346  1.00 15.38           C  
ATOM    770  O   ILE A  96       1.647  47.206  74.582  1.00 15.55           O  
ATOM    771  CB  ILE A  96       4.327  45.401  75.119  1.00 11.32           C  
ATOM    772  CG1 ILE A  96       4.966  44.058  74.738  1.00 10.93           C  
ATOM    773  CG2 ILE A  96       3.358  45.235  76.295  1.00  8.08           C  
ATOM    774  CD1 ILE A  96       3.971  42.966  74.327  1.00  9.07           C  
ATOM    775  N   LEU A  97       3.560  48.362  74.461  1.00 14.33           N  
ATOM    776  CA  LEU A  97       2.894  49.592  74.886  1.00 18.31           C  
ATOM    777  C   LEU A  97       1.755  49.967  73.938  1.00 18.84           C  
ATOM    778  O   LEU A  97       0.643  50.247  74.374  1.00 19.05           O  
ATOM    779  CB  LEU A  97       3.892  50.752  74.996  1.00 17.89           C  
ATOM    780  CG  LEU A  97       3.242  52.037  75.535  1.00 20.66           C  
ATOM    781  CD1 LEU A  97       2.593  51.755  76.897  1.00 17.67           C  
ATOM    782  CD2 LEU A  97       4.268  53.149  75.633  1.00 16.53           C  
ATOM    783  N   GLN A  98       2.032  49.947  72.639  1.00 20.52           N  
ATOM    784  CA  GLN A  98       1.027  50.276  71.637  1.00 18.59           C  
ATOM    785  C   GLN A  98      -0.132  49.269  71.642  1.00 19.41           C  
ATOM    786  O   GLN A  98      -1.285  49.641  71.416  1.00 19.18           O  
ATOM    787  CB  GLN A  98       1.669  50.334  70.250  1.00 17.64           C  
ATOM    788  CG  GLN A  98       0.790  51.012  69.198  1.00 20.95           C  
ATOM    789  CD  GLN A  98       0.346  52.407  69.628  1.00 23.30           C  
ATOM    790  OE1 GLN A  98      -0.847  52.662  69.834  1.00 24.79           O  
ATOM    791  NE2 GLN A  98       1.308  53.312  69.777  1.00 22.61           N  
ATOM    792  N   LEU A  99       0.172  47.998  71.891  1.00 18.38           N  
ATOM    793  CA  LEU A  99      -0.867  46.980  71.938  1.00 17.92           C  
ATOM    794  C   LEU A  99      -1.829  47.294  73.082  1.00 19.13           C  
ATOM    795  O   LEU A  99      -3.050  47.310  72.898  1.00 17.43           O  
ATOM    796  CB  LEU A  99      -0.252  45.595  72.146  1.00 19.29           C  
ATOM    797  CG  LEU A  99      -1.258  44.454  72.324  1.00 19.89           C  
ATOM    798  CD1 LEU A  99      -2.078  44.289  71.045  1.00 18.41           C  
ATOM    799  CD2 LEU A  99      -0.515  43.161  72.664  1.00 21.42           C  
ATOM    800  N   LEU A 100      -1.275  47.546  74.266  1.00 20.07           N  
ATOM    801  CA  LEU A 100      -2.096  47.873  75.427  1.00 19.93           C  
ATOM    802  C   LEU A 100      -2.965  49.107  75.104  1.00 22.06           C  
ATOM    803  O   LEU A 100      -4.179  49.092  75.330  1.00 21.03           O  
ATOM    804  CB  LEU A 100      -1.204  48.122  76.651  1.00 18.80           C  
ATOM    805  CG  LEU A 100      -0.387  46.900  77.107  1.00 20.46           C  
ATOM    806  CD1 LEU A 100       0.729  47.319  78.051  1.00 17.24           C  
ATOM    807  CD2 LEU A 100      -1.321  45.892  77.773  1.00 14.77           C  
ATOM    808  N   LYS A 101      -2.357  50.164  74.568  1.00 21.64           N  
ATOM    809  CA  LYS A 101      -3.128  51.358  74.208  1.00 23.77           C  
ATOM    810  C   LYS A 101      -4.251  51.001  73.242  1.00 24.06           C  
ATOM    811  O   LYS A 101      -5.394  51.396  73.441  1.00 24.90           O  
ATOM    812  CB  LYS A 101      -2.236  52.412  73.549  1.00 23.98           C  
ATOM    813  CG  LYS A 101      -1.256  53.085  74.489  1.00 25.37           C  
ATOM    814  CD  LYS A 101      -0.294  53.946  73.710  1.00 26.66           C  
ATOM    815  CE  LYS A 101       0.678  54.656  74.631  1.00 27.27           C  
ATOM    816  NZ  LYS A 101       1.689  55.406  73.833  1.00 28.11           N  
ATOM    817  N   ASP A 102      -3.921  50.249  72.195  1.00 24.11           N  
ATOM    818  CA  ASP A 102      -4.907  49.857  71.198  1.00 23.22           C  
ATOM    819  C   ASP A 102      -6.036  48.981  71.764  1.00 24.97           C  
ATOM    820  O   ASP A 102      -7.191  49.093  71.327  1.00 23.07           O  
ATOM    821  CB  ASP A 102      -4.217  49.133  70.037  1.00 24.47           C  
ATOM    822  CG  ASP A 102      -3.316  50.053  69.219  1.00 27.70           C  
ATOM    823  OD1 ASP A 102      -2.599  49.550  68.322  1.00 27.91           O  
ATOM    824  OD2 ASP A 102      -3.320  51.281  69.469  1.00 29.61           O  
ATOM    825  N   LEU A 103      -5.709  48.110  72.723  1.00 23.92           N  
ATOM    826  CA  LEU A 103      -6.711  47.223  73.324  1.00 23.70           C  
ATOM    827  C   LEU A 103      -7.647  48.031  74.210  1.00 24.15           C  
ATOM    828  O   LEU A 103      -8.859  47.821  74.215  1.00 24.38           O  
ATOM    829  CB  LEU A 103      -6.044  46.120  74.163  1.00 19.95           C  
ATOM    830  CG  LEU A 103      -5.236  45.041  73.439  1.00 20.74           C  
ATOM    831  CD1 LEU A 103      -4.531  44.157  74.458  1.00 20.97           C  
ATOM    832  CD2 LEU A 103      -6.167  44.199  72.559  1.00 14.56           C  
ATOM    833  N   ARG A 104      -7.065  48.952  74.963  1.00 26.04           N  
ATOM    834  CA  ARG A 104      -7.828  49.808  75.846  1.00 29.11           C  
ATOM    835  C   ARG A 104      -8.765  50.662  75.004  1.00 29.46           C  
ATOM    836  O   ARG A 104      -9.975  50.677  75.241  1.00 29.19           O  
ATOM    837  CB  ARG A 104      -6.888  50.705  76.651  1.00 32.19           C  
ATOM    838  CG  ARG A 104      -7.573  51.687  77.594  1.00 36.30           C  
ATOM    839  CD  ARG A 104      -6.531  52.573  78.279  1.00 42.36           C  
ATOM    840  NE  ARG A 104      -7.124  53.644  79.077  1.00 48.08           N  
ATOM    841  CZ  ARG A 104      -7.791  53.455  80.214  1.00 51.83           C  
ATOM    842  NH1 ARG A 104      -7.954  52.226  80.700  1.00 53.28           N  
ATOM    843  NH2 ARG A 104      -8.299  54.495  80.869  1.00 51.97           N  
ATOM    844  N   SER A 105      -8.225  51.352  74.003  1.00 28.41           N  
ATOM    845  CA  SER A 105      -9.083  52.202  73.183  1.00 30.39           C  
ATOM    846  C   SER A 105     -10.138  51.397  72.407  1.00 30.18           C  
ATOM    847  O   SER A 105     -11.103  51.963  71.897  1.00 30.54           O  
ATOM    848  CB  SER A 105      -8.253  53.082  72.234  1.00 29.40           C  
ATOM    849  OG  SER A 105      -7.561  52.323  71.262  1.00 33.16           O  
ATOM    850  N   ASN A 106      -9.972  50.080  72.334  1.00 28.47           N  
ATOM    851  CA  ASN A 106     -10.950  49.247  71.638  1.00 28.52           C  
ATOM    852  C   ASN A 106     -11.845  48.541  72.637  1.00 28.85           C  
ATOM    853  O   ASN A 106     -12.616  47.653  72.282  1.00 29.55           O  
ATOM    854  CB  ASN A 106     -10.251  48.222  70.750  1.00 29.27           C  
ATOM    855  CG  ASN A 106      -9.984  48.751  69.364  1.00 29.47           C  
ATOM    856  OD1 ASN A 106     -10.684  48.403  68.414  1.00 33.82           O  
ATOM    857  ND2 ASN A 106      -8.980  49.613  69.240  1.00 30.79           N  
ATOM    858  N   LYS A 107     -11.727  48.945  73.895  1.00 29.18           N  
ATOM    859  CA  LYS A 107     -12.509  48.371  74.979  1.00 29.75           C  
ATOM    860  C   LYS A 107     -12.311  46.862  75.110  1.00 28.06           C  
ATOM    861  O   LYS A 107     -13.253  46.121  75.381  1.00 27.81           O  
ATOM    862  CB  LYS A 107     -14.002  48.689  74.797  1.00 32.13           C  
ATOM    863  CG  LYS A 107     -14.292  50.142  74.418  1.00 36.02           C  
ATOM    864  CD  LYS A 107     -13.664  51.125  75.397  1.00 41.03           C  
ATOM    865  CE  LYS A 107     -14.266  51.009  76.799  1.00 43.88           C  
ATOM    866  NZ  LYS A 107     -15.678  51.498  76.851  1.00 45.74           N  
ATOM    867  N   ILE A 108     -11.084  46.401  74.905  1.00 25.87           N  
ATOM    868  CA  ILE A 108     -10.794  44.981  75.055  1.00 23.38           C  
ATOM    869  C   ILE A 108     -10.100  44.817  76.405  1.00 22.88           C  
ATOM    870  O   ILE A 108      -9.114  45.498  76.692  1.00 20.79           O  
ATOM    871  CB  ILE A 108      -9.887  44.461  73.906  1.00 23.88           C  
ATOM    872  CG1 ILE A 108     -10.671  44.492  72.585  1.00 21.17           C  
ATOM    873  CG2 ILE A 108      -9.396  43.033  74.217  1.00 19.70           C  
ATOM    874  CD1 ILE A 108      -9.830  44.225  71.362  1.00 20.35           C  
ATOM    875  N   LYS A 109     -10.630  43.927  77.237  1.00 22.89           N  
ATOM    876  CA  LYS A 109     -10.078  43.689  78.573  1.00 24.45           C  
ATOM    877  C   LYS A 109      -8.621  43.216  78.581  1.00 22.33           C  
ATOM    878  O   LYS A 109      -8.202  42.438  77.732  1.00 20.74           O  
ATOM    879  CB  LYS A 109     -10.958  42.685  79.318  1.00 27.62           C  
ATOM    880  CG  LYS A 109     -12.381  43.185  79.523  1.00 31.16           C  
ATOM    881  CD  LYS A 109     -12.380  44.411  80.408  1.00 34.89           C  
ATOM    882  CE  LYS A 109     -13.761  45.009  80.547  1.00 37.37           C  
ATOM    883  NZ  LYS A 109     -13.789  45.983  81.674  1.00 40.28           N  
ATOM    884  N   ILE A 110      -7.864  43.698  79.563  1.00 20.63           N  
ATOM    885  CA  ILE A 110      -6.456  43.365  79.706  1.00 19.00           C  
ATOM    886  C   ILE A 110      -6.176  42.811  81.094  1.00 18.90           C  
ATOM    887  O   ILE A 110      -6.500  43.448  82.104  1.00 19.73           O  
ATOM    888  CB  ILE A 110      -5.583  44.613  79.471  1.00 19.55           C  
ATOM    889  CG1 ILE A 110      -5.829  45.148  78.054  1.00 17.89           C  
ATOM    890  CG2 ILE A 110      -4.105  44.267  79.673  1.00 16.08           C  
ATOM    891  CD1 ILE A 110      -5.286  46.541  77.808  1.00 15.50           C  
ATOM    892  N   ALA A 111      -5.570  41.628  81.144  1.00 17.06           N  
ATOM    893  CA  ALA A 111      -5.274  40.979  82.412  1.00 16.46           C  
ATOM    894  C   ALA A 111      -3.892  40.349  82.437  1.00 16.91           C  
ATOM    895  O   ALA A 111      -3.413  39.852  81.424  1.00 16.36           O  
ATOM    896  CB  ALA A 111      -6.325  39.916  82.705  1.00 15.17           C  
ATOM    897  N   LEU A 112      -3.240  40.383  83.592  1.00 17.06           N  
ATOM    898  CA  LEU A 112      -1.922  39.770  83.704  1.00 16.51           C  
ATOM    899  C   LEU A 112      -2.126  38.343  84.210  1.00 14.83           C  
ATOM    900  O   LEU A 112      -2.854  38.129  85.172  1.00 13.87           O  
ATOM    901  CB  LEU A 112      -1.029  40.533  84.695  1.00 16.14           C  
ATOM    902  CG  LEU A 112       0.451  40.084  84.749  1.00 14.45           C  
ATOM    903  CD1 LEU A 112       1.167  40.540  83.487  1.00 12.70           C  
ATOM    904  CD2 LEU A 112       1.144  40.661  85.970  1.00 12.35           C  
ATOM    905  N   ALA A 113      -1.500  37.369  83.555  1.00 15.61           N  
ATOM    906  CA  ALA A 113      -1.611  35.969  83.987  1.00 15.54           C  
ATOM    907  C   ALA A 113      -0.180  35.475  84.186  1.00 16.13           C  
ATOM    908  O   ALA A 113       0.302  34.619  83.451  1.00 16.28           O  
ATOM    909  CB  ALA A 113      -2.312  35.137  82.918  1.00 14.60           C  
ATOM    910  N   SER A 114       0.491  36.023  85.189  1.00 15.35           N  
ATOM    911  CA  SER A 114       1.883  35.689  85.440  1.00 15.80           C  
ATOM    912  C   SER A 114       2.156  35.078  86.814  1.00 17.61           C  
ATOM    913  O   SER A 114       1.489  35.406  87.793  1.00 17.61           O  
ATOM    914  CB  SER A 114       2.718  36.956  85.255  1.00 12.48           C  
ATOM    915  OG  SER A 114       4.072  36.765  85.633  1.00 12.09           O  
ATOM    916  N   ALA A 115       3.153  34.197  86.878  1.00 18.59           N  
ATOM    917  CA  ALA A 115       3.532  33.557  88.134  1.00 19.14           C  
ATOM    918  C   ALA A 115       4.377  34.504  88.986  1.00 19.93           C  
ATOM    919  O   ALA A 115       4.591  34.259  90.172  1.00 20.05           O  
ATOM    920  CB  ALA A 115       4.309  32.289  87.856  1.00 18.52           C  
ATOM    921  N   SER A 116       4.845  35.591  88.383  1.00 20.73           N  
ATOM    922  CA  SER A 116       5.682  36.553  89.097  1.00 22.29           C  
ATOM    923  C   SER A 116       5.049  37.105  90.369  1.00 23.65           C  
ATOM    924  O   SER A 116       3.959  37.672  90.336  1.00 21.73           O  
ATOM    925  CB  SER A 116       6.039  37.722  88.190  1.00 24.34           C  
ATOM    926  OG  SER A 116       6.673  38.747  88.934  1.00 28.36           O  
ATOM    927  N   LYS A 117       5.735  36.933  91.494  1.00 24.18           N  
ATOM    928  CA  LYS A 117       5.233  37.452  92.763  1.00 23.32           C  
ATOM    929  C   LYS A 117       5.489  38.966  92.758  1.00 21.40           C  
ATOM    930  O   LYS A 117       5.043  39.689  93.647  1.00 21.02           O  
ATOM    931  CB  LYS A 117       5.968  36.782  93.932  1.00 26.06           C  
ATOM    932  CG  LYS A 117       5.749  35.256  94.001  1.00 32.15           C  
ATOM    933  CD  LYS A 117       6.623  34.580  95.062  1.00 36.99           C  
ATOM    934  CE  LYS A 117       6.544  33.047  94.996  1.00 40.13           C  
ATOM    935  NZ  LYS A 117       5.167  32.519  95.266  1.00 41.23           N  
ATOM    936  N   ASN A 118       6.195  39.440  91.736  1.00 16.24           N  
ATOM    937  CA  ASN A 118       6.500  40.856  91.645  1.00 15.78           C  
ATOM    938  C   ASN A 118       5.772  41.540  90.494  1.00 15.96           C  
ATOM    939  O   ASN A 118       6.114  42.659  90.111  1.00 16.27           O  
ATOM    940  CB  ASN A 118       8.012  41.041  91.534  1.00 14.58           C  
ATOM    941  CG  ASN A 118       8.742  40.422  92.712  1.00 16.92           C  
ATOM    942  OD1 ASN A 118       8.601  40.883  93.836  1.00 21.16           O  
ATOM    943  ND2 ASN A 118       9.493  39.353  92.467  1.00 17.70           N  
ATOM    944  N   GLY A 119       4.744  40.872  89.976  1.00 13.86           N  
ATOM    945  CA  GLY A 119       3.972  41.423  88.874  1.00 14.04           C  
ATOM    946  C   GLY A 119       3.487  42.858  89.037  1.00 14.86           C  
ATOM    947  O   GLY A 119       3.823  43.716  88.220  1.00 14.83           O  
ATOM    948  N   PRO A 120       2.691  43.156  90.073  1.00 15.55           N  
ATOM    949  CA  PRO A 120       2.202  44.531  90.259  1.00 15.83           C  
ATOM    950  C   PRO A 120       3.332  45.561  90.374  1.00 16.90           C  
ATOM    951  O   PRO A 120       3.248  46.660  89.814  1.00 17.75           O  
ATOM    952  CB  PRO A 120       1.359  44.436  91.537  1.00 14.72           C  
ATOM    953  CG  PRO A 120       0.871  43.006  91.521  1.00 14.73           C  
ATOM    954  CD  PRO A 120       2.098  42.238  91.060  1.00 13.87           C  
ATOM    955  N   PHE A 121       4.386  45.215  91.102  1.00 17.25           N  
ATOM    956  CA  PHE A 121       5.517  46.126  91.259  1.00 16.53           C  
ATOM    957  C   PHE A 121       6.151  46.411  89.905  1.00 15.22           C  
ATOM    958  O   PHE A 121       6.394  47.563  89.546  1.00 14.83           O  
ATOM    959  CB  PHE A 121       6.569  45.519  92.187  1.00 18.83           C  
ATOM    960  CG  PHE A 121       7.911  46.199  92.115  1.00 19.18           C  
ATOM    961  CD1 PHE A 121       8.127  47.427  92.742  1.00 20.73           C  
ATOM    962  CD2 PHE A 121       8.962  45.609  91.426  1.00 18.90           C  
ATOM    963  CE1 PHE A 121       9.379  48.057  92.688  1.00 19.84           C  
ATOM    964  CE2 PHE A 121      10.223  46.229  91.364  1.00 21.91           C  
ATOM    965  CZ  PHE A 121      10.427  47.459  91.999  1.00 20.20           C  
ATOM    966  N   LEU A 122       6.409  45.351  89.149  1.00 14.67           N  
ATOM    967  CA  LEU A 122       7.026  45.489  87.839  1.00 15.52           C  
ATOM    968  C   LEU A 122       6.192  46.321  86.858  1.00 17.66           C  
ATOM    969  O   LEU A 122       6.744  47.117  86.104  1.00 19.70           O  
ATOM    970  CB  LEU A 122       7.319  44.102  87.257  1.00 15.48           C  
ATOM    971  CG  LEU A 122       8.402  43.330  88.030  1.00 15.74           C  
ATOM    972  CD1 LEU A 122       8.449  41.885  87.602  1.00 11.33           C  
ATOM    973  CD2 LEU A 122       9.751  43.997  87.797  1.00 17.96           C  
ATOM    974  N   LEU A 123       4.872  46.150  86.863  1.00 17.84           N  
ATOM    975  CA  LEU A 123       4.016  46.904  85.952  1.00 17.19           C  
ATOM    976  C   LEU A 123       3.985  48.389  86.337  1.00 18.79           C  
ATOM    977  O   LEU A 123       3.878  49.252  85.481  1.00 18.83           O  
ATOM    978  CB  LEU A 123       2.586  46.341  85.965  1.00 16.24           C  
ATOM    979  CG  LEU A 123       2.344  44.938  85.402  1.00 13.45           C  
ATOM    980  CD1 LEU A 123       0.867  44.585  85.568  1.00 11.91           C  
ATOM    981  CD2 LEU A 123       2.756  44.883  83.929  1.00  8.65           C  
ATOM    982  N   GLU A 124       4.069  48.667  87.633  1.00 20.72           N  
ATOM    983  CA  GLU A 124       4.070  50.031  88.144  1.00 21.86           C  
ATOM    984  C   GLU A 124       5.400  50.690  87.763  1.00 22.05           C  
ATOM    985  O   GLU A 124       5.447  51.872  87.413  1.00 22.40           O  
ATOM    986  CB  GLU A 124       3.914  50.009  89.669  1.00 24.44           C  
ATOM    987  CG  GLU A 124       3.159  51.193  90.238  1.00 30.54           C  
ATOM    988  CD  GLU A 124       2.933  51.082  91.738  1.00 31.50           C  
ATOM    989  OE1 GLU A 124       3.892  51.316  92.504  1.00 29.66           O  
ATOM    990  OE2 GLU A 124       1.796  50.753  92.151  1.00 33.00           O  
ATOM    991  N   ARG A 125       6.482  49.923  87.837  1.00 19.35           N  
ATOM    992  CA  ARG A 125       7.797  50.446  87.489  1.00 19.69           C  
ATOM    993  C   ARG A 125       7.889  50.728  85.989  1.00 21.06           C  
ATOM    994  O   ARG A 125       8.628  51.613  85.575  1.00 19.59           O  
ATOM    995  CB  ARG A 125       8.899  49.452  87.878  1.00 20.45           C  
ATOM    996  CG  ARG A 125       9.126  49.306  89.385  1.00 22.41           C  
ATOM    997  CD  ARG A 125       9.721  50.569  89.953  1.00 21.39           C  
ATOM    998  NE  ARG A 125      10.903  50.961  89.202  1.00 27.06           N  
ATOM    999  CZ  ARG A 125      11.561  52.101  89.386  1.00 30.96           C  
ATOM   1000  NH1 ARG A 125      11.151  52.961  90.309  1.00 31.14           N  
ATOM   1001  NH2 ARG A 125      12.616  52.391  88.633  1.00 29.75           N  
ATOM   1002  N   MET A 126       7.160  49.958  85.176  1.00 18.78           N  
ATOM   1003  CA  MET A 126       7.179  50.175  83.733  1.00 19.08           C  
ATOM   1004  C   MET A 126       6.067  51.153  83.309  1.00 20.69           C  
ATOM   1005  O   MET A 126       5.944  51.500  82.133  1.00 21.16           O  
ATOM   1006  CB  MET A 126       7.045  48.834  82.979  1.00 16.82           C  
ATOM   1007  CG  MET A 126       8.332  47.956  83.009  1.00 14.72           C  
ATOM   1008  SD  MET A 126       8.249  46.320  82.224  1.00 11.04           S  
ATOM   1009  CE  MET A 126       6.912  45.667  83.103  1.00 12.91           C  
ATOM   1010  N   ASN A 127       5.282  51.608  84.283  1.00 20.47           N  
ATOM   1011  CA  ASN A 127       4.165  52.525  84.051  1.00 24.22           C  
ATOM   1012  C   ASN A 127       3.028  51.952  83.217  1.00 23.83           C  
ATOM   1013  O   ASN A 127       2.430  52.664  82.397  1.00 22.24           O  
ATOM   1014  CB  ASN A 127       4.637  53.807  83.383  1.00 26.92           C  
ATOM   1015  CG  ASN A 127       4.580  54.970  84.311  1.00 33.97           C  
ATOM   1016  OD1 ASN A 127       5.506  55.197  85.098  1.00 37.73           O  
ATOM   1017  ND2 ASN A 127       3.473  55.714  84.260  1.00 37.17           N  
ATOM   1018  N   LEU A 128       2.716  50.678  83.441  1.00 21.50           N  
ATOM   1019  CA  LEU A 128       1.667  50.019  82.686  1.00 19.58           C  
ATOM   1020  C   LEU A 128       0.437  49.668  83.517  1.00 19.65           C  
ATOM   1021  O   LEU A 128      -0.537  49.164  82.966  1.00 22.31           O  
ATOM   1022  CB  LEU A 128       2.213  48.740  82.058  1.00 18.70           C  
ATOM   1023  CG  LEU A 128       3.408  48.813  81.103  1.00 18.04           C  
ATOM   1024  CD1 LEU A 128       3.832  47.391  80.758  1.00 14.75           C  
ATOM   1025  CD2 LEU A 128       3.046  49.590  79.835  1.00 15.12           C  
ATOM   1026  N   THR A 129       0.478  49.911  84.826  1.00 18.67           N  
ATOM   1027  CA  THR A 129      -0.647  49.576  85.712  1.00 19.06           C  
ATOM   1028  C   THR A 129      -2.018  49.997  85.187  1.00 20.06           C  
ATOM   1029  O   THR A 129      -2.941  49.190  85.144  1.00 21.34           O  
ATOM   1030  CB  THR A 129      -0.505  50.226  87.103  1.00 20.25           C  
ATOM   1031  OG1 THR A 129       0.785  49.936  87.645  1.00 20.18           O  
ATOM   1032  CG2 THR A 129      -1.589  49.689  88.061  1.00 17.86           C  
ATOM   1033  N   GLY A 130      -2.145  51.267  84.815  1.00 19.37           N  
ATOM   1034  CA  GLY A 130      -3.412  51.781  84.325  1.00 20.55           C  
ATOM   1035  C   GLY A 130      -4.054  51.069  83.142  1.00 22.97           C  
ATOM   1036  O   GLY A 130      -5.263  51.214  82.920  1.00 24.30           O  
ATOM   1037  N   TYR A 131      -3.271  50.314  82.375  1.00 21.55           N  
ATOM   1038  CA  TYR A 131      -3.820  49.593  81.226  1.00 22.25           C  
ATOM   1039  C   TYR A 131      -4.459  48.288  81.657  1.00 21.68           C  
ATOM   1040  O   TYR A 131      -5.395  47.806  81.022  1.00 22.44           O  
ATOM   1041  CB  TYR A 131      -2.736  49.277  80.188  1.00 22.76           C  
ATOM   1042  CG  TYR A 131      -2.171  50.494  79.501  1.00 24.24           C  
ATOM   1043  CD1 TYR A 131      -0.857  50.897  79.725  1.00 22.93           C  
ATOM   1044  CD2 TYR A 131      -2.961  51.263  78.652  1.00 23.07           C  
ATOM   1045  CE1 TYR A 131      -0.346  52.035  79.126  1.00 23.96           C  
ATOM   1046  CE2 TYR A 131      -2.457  52.408  78.047  1.00 25.23           C  
ATOM   1047  CZ  TYR A 131      -1.152  52.787  78.289  1.00 25.44           C  
ATOM   1048  OH  TYR A 131      -0.650  53.917  77.691  1.00 26.97           O  
ATOM   1049  N   PHE A 132      -3.957  47.720  82.743  1.00 19.52           N  
ATOM   1050  CA  PHE A 132      -4.475  46.455  83.217  1.00 18.21           C  
ATOM   1051  C   PHE A 132      -5.783  46.531  83.997  1.00 17.66           C  
ATOM   1052  O   PHE A 132      -5.944  47.360  84.887  1.00 16.29           O  
ATOM   1053  CB  PHE A 132      -3.398  45.741  84.039  1.00 16.80           C  
ATOM   1054  CG  PHE A 132      -2.322  45.120  83.192  1.00 15.73           C  
ATOM   1055  CD1 PHE A 132      -1.392  45.910  82.532  1.00 14.85           C  
ATOM   1056  CD2 PHE A 132      -2.287  43.740  82.996  1.00 14.87           C  
ATOM   1057  CE1 PHE A 132      -0.448  45.344  81.689  1.00 13.30           C  
ATOM   1058  CE2 PHE A 132      -1.347  43.166  82.153  1.00 13.37           C  
ATOM   1059  CZ  PHE A 132      -0.429  43.960  81.499  1.00 14.02           C  
ATOM   1060  N   ASP A 133      -6.723  45.661  83.632  1.00 16.90           N  
ATOM   1061  CA  ASP A 133      -8.014  45.600  84.295  1.00 17.99           C  
ATOM   1062  C   ASP A 133      -7.988  44.611  85.449  1.00 17.95           C  
ATOM   1063  O   ASP A 133      -8.838  44.655  86.324  1.00 20.27           O  
ATOM   1064  CB  ASP A 133      -9.097  45.208  83.293  1.00 20.05           C  
ATOM   1065  CG  ASP A 133      -9.258  46.232  82.200  1.00 21.39           C  
ATOM   1066  OD1 ASP A 133      -9.593  47.385  82.534  1.00 24.81           O  
ATOM   1067  OD2 ASP A 133      -9.037  45.901  81.018  1.00 23.45           O  
ATOM   1068  N   ALA A 134      -7.015  43.707  85.452  1.00 19.39           N  
ATOM   1069  CA  ALA A 134      -6.910  42.741  86.537  1.00 18.80           C  
ATOM   1070  C   ALA A 134      -5.557  42.056  86.539  1.00 20.69           C  
ATOM   1071  O   ALA A 134      -4.917  41.904  85.499  1.00 20.54           O  
ATOM   1072  CB  ALA A 134      -8.020  41.701  86.425  1.00 18.43           C  
ATOM   1073  N   ILE A 135      -5.119  41.650  87.722  1.00 22.46           N  
ATOM   1074  CA  ILE A 135      -3.852  40.949  87.862  1.00 25.02           C  
ATOM   1075  C   ILE A 135      -4.203  39.638  88.552  1.00 24.30           C  
ATOM   1076  O   ILE A 135      -4.733  39.650  89.665  1.00 24.01           O  
ATOM   1077  CB  ILE A 135      -2.847  41.704  88.787  1.00 26.56           C  
ATOM   1078  CG1 ILE A 135      -2.580  43.129  88.287  1.00 28.44           C  
ATOM   1079  CG2 ILE A 135      -1.549  40.926  88.868  1.00 26.67           C  
ATOM   1080  CD1 ILE A 135      -1.816  43.221  87.000  1.00 29.97           C  
ATOM   1081  N   ALA A 136      -3.940  38.510  87.908  1.00 22.78           N  
ATOM   1082  CA  ALA A 136      -4.233  37.242  88.567  1.00 23.58           C  
ATOM   1083  C   ALA A 136      -3.120  37.020  89.594  1.00 25.23           C  
ATOM   1084  O   ALA A 136      -1.936  37.028  89.258  1.00 26.30           O  
ATOM   1085  CB  ALA A 136      -4.272  36.121  87.561  1.00 22.91           C  
ATOM   1086  N   ASP A 137      -3.504  36.856  90.854  1.00 26.39           N  
ATOM   1087  CA  ASP A 137      -2.550  36.661  91.941  1.00 26.60           C  
ATOM   1088  C   ASP A 137      -1.996  35.224  91.986  1.00 26.99           C  
ATOM   1089  O   ASP A 137      -2.727  34.280  92.281  1.00 25.31           O  
ATOM   1090  CB  ASP A 137      -3.246  37.009  93.263  1.00 29.89           C  
ATOM   1091  CG  ASP A 137      -2.325  36.922  94.466  1.00 32.37           C  
ATOM   1092  OD1 ASP A 137      -2.787  37.241  95.581  1.00 35.59           O  
ATOM   1093  OD2 ASP A 137      -1.148  36.537  94.309  1.00 34.75           O  
ATOM   1094  N   PRO A 138      -0.689  35.051  91.699  1.00 27.93           N  
ATOM   1095  CA  PRO A 138       0.009  33.758  91.693  1.00 29.16           C  
ATOM   1096  C   PRO A 138      -0.203  32.934  92.967  1.00 30.08           C  
ATOM   1097  O   PRO A 138      -0.276  31.705  92.915  1.00 30.16           O  
ATOM   1098  CB  PRO A 138       1.476  34.154  91.535  1.00 28.84           C  
ATOM   1099  CG  PRO A 138       1.418  35.400  90.785  1.00 28.88           C  
ATOM   1100  CD  PRO A 138       0.259  36.139  91.407  1.00 28.41           C  
ATOM   1101  N   ALA A 139      -0.296  33.612  94.108  1.00 29.87           N  
ATOM   1102  CA  ALA A 139      -0.485  32.926  95.383  1.00 30.57           C  
ATOM   1103  C   ALA A 139      -1.895  32.367  95.574  1.00 33.25           C  
ATOM   1104  O   ALA A 139      -2.149  31.636  96.531  1.00 33.60           O  
ATOM   1105  CB  ALA A 139      -0.135  33.855  96.527  1.00 30.17           C  
ATOM   1106  N   GLU A 140      -2.815  32.717  94.677  1.00 34.80           N  
ATOM   1107  CA  GLU A 140      -4.183  32.213  94.755  1.00 36.11           C  
ATOM   1108  C   GLU A 140      -4.400  31.127  93.697  1.00 36.38           C  
ATOM   1109  O   GLU A 140      -5.509  30.622  93.532  1.00 36.78           O  
ATOM   1110  CB  GLU A 140      -5.186  33.341  94.523  1.00 38.82           C  
ATOM   1111  CG  GLU A 140      -5.244  34.370  95.624  1.00 43.81           C  
ATOM   1112  CD  GLU A 140      -5.479  33.744  96.982  1.00 46.98           C  
ATOM   1113  OE1 GLU A 140      -6.157  32.691  97.044  1.00 49.09           O  
ATOM   1114  OE2 GLU A 140      -4.994  34.311  97.990  1.00 49.56           O  
ATOM   1115  N   VAL A 141      -3.338  30.787  92.971  1.00 34.73           N  
ATOM   1116  CA  VAL A 141      -3.393  29.766  91.927  1.00 32.33           C  
ATOM   1117  C   VAL A 141      -2.898  28.419  92.470  1.00 31.40           C  
ATOM   1118  O   VAL A 141      -1.737  28.280  92.863  1.00 29.16           O  
ATOM   1119  CB  VAL A 141      -2.524  30.188  90.726  1.00 33.46           C  
ATOM   1120  CG1 VAL A 141      -2.480  29.079  89.689  1.00 34.30           C  
ATOM   1121  CG2 VAL A 141      -3.074  31.470  90.121  1.00 32.78           C  
ATOM   1122  N   ALA A 142      -3.782  27.426  92.478  1.00 29.58           N  
ATOM   1123  CA  ALA A 142      -3.451  26.098  92.997  1.00 29.26           C  
ATOM   1124  C   ALA A 142      -2.399  25.324  92.213  1.00 28.46           C  
ATOM   1125  O   ALA A 142      -1.544  24.668  92.803  1.00 27.10           O  
ATOM   1126  CB  ALA A 142      -4.722  25.258  93.112  1.00 27.36           C  
ATOM   1127  N   ALA A 143      -2.466  25.384  90.887  1.00 28.20           N  
ATOM   1128  CA  ALA A 143      -1.519  24.652  90.053  1.00 29.30           C  
ATOM   1129  C   ALA A 143      -0.779  25.561  89.072  1.00 29.54           C  
ATOM   1130  O   ALA A 143      -1.393  26.328  88.328  1.00 29.37           O  
ATOM   1131  CB  ALA A 143      -2.249  23.543  89.303  1.00 29.05           C  
ATOM   1132  N   SER A 144       0.543  25.452  89.063  1.00 29.33           N  
ATOM   1133  CA  SER A 144       1.364  26.291  88.206  1.00 31.61           C  
ATOM   1134  C   SER A 144       1.127  26.117  86.718  1.00 31.29           C  
ATOM   1135  O   SER A 144       0.453  25.193  86.269  1.00 30.43           O  
ATOM   1136  CB  SER A 144       2.851  26.103  88.515  1.00 31.91           C  
ATOM   1137  OG  SER A 144       3.337  24.891  87.967  1.00 36.91           O  
ATOM   1138  N   LYS A 145       1.745  27.028  85.978  1.00 33.11           N  
ATOM   1139  CA  LYS A 145       1.643  27.163  84.537  1.00 32.72           C  
ATOM   1140  C   LYS A 145       1.112  26.043  83.679  1.00 34.05           C  
ATOM   1141  O   LYS A 145       0.073  26.218  83.049  1.00 38.27           O  
ATOM   1142  CB  LYS A 145       2.954  27.659  83.953  1.00 33.44           C  
ATOM   1143  CG  LYS A 145       2.735  28.386  82.646  1.00 34.16           C  
ATOM   1144  CD  LYS A 145       1.702  29.521  82.766  1.00 29.52           C  
ATOM   1145  CE  LYS A 145       2.264  30.737  83.464  1.00 28.15           C  
ATOM   1146  NZ  LYS A 145       1.725  32.024  82.910  1.00 22.94           N  
ATOM   1147  N   PRO A 146       1.791  24.889  83.609  1.00 30.85           N  
ATOM   1148  CA  PRO A 146       1.201  23.854  82.743  1.00 27.47           C  
ATOM   1149  C   PRO A 146      -0.329  23.835  82.882  1.00 25.47           C  
ATOM   1150  O   PRO A 146      -1.069  23.839  81.895  1.00 25.05           O  
ATOM   1151  CB  PRO A 146       1.859  22.574  83.245  1.00 30.69           C  
ATOM   1152  CG  PRO A 146       3.218  23.051  83.645  1.00 31.31           C  
ATOM   1153  CD  PRO A 146       2.945  24.376  84.361  1.00 30.60           C  
ATOM   1154  N   ALA A 147      -0.796  23.856  84.123  1.00 22.65           N  
ATOM   1155  CA  ALA A 147      -2.225  23.860  84.413  1.00 21.76           C  
ATOM   1156  C   ALA A 147      -2.832  25.152  83.872  1.00 21.38           C  
ATOM   1157  O   ALA A 147      -2.152  26.162  83.742  1.00 20.22           O  
ATOM   1158  CB  ALA A 147      -2.447  23.766  85.920  1.00 21.81           C  
ATOM   1159  N   PRO A 148      -4.127  25.143  83.567  1.00 21.85           N  
ATOM   1160  CA  PRO A 148      -4.781  26.338  83.033  1.00 20.62           C  
ATOM   1161  C   PRO A 148      -5.246  27.337  84.085  1.00 21.11           C  
ATOM   1162  O   PRO A 148      -5.620  28.463  83.750  1.00 20.75           O  
ATOM   1163  CB  PRO A 148      -5.955  25.753  82.273  1.00 21.18           C  
ATOM   1164  CG  PRO A 148      -6.373  24.626  83.191  1.00 22.77           C  
ATOM   1165  CD  PRO A 148      -5.049  23.989  83.565  1.00 21.06           C  
ATOM   1166  N   ASP A 149      -5.212  26.916  85.347  1.00 19.69           N  
ATOM   1167  CA  ASP A 149      -5.675  27.724  86.470  1.00 20.23           C  
ATOM   1168  C   ASP A 149      -5.477  29.235  86.405  1.00 21.22           C  
ATOM   1169  O   ASP A 149      -6.432  30.000  86.549  1.00 21.37           O  
ATOM   1170  CB  ASP A 149      -5.054  27.225  87.775  1.00 24.62           C  
ATOM   1171  CG  ASP A 149      -5.343  25.760  88.046  1.00 27.29           C  
ATOM   1172  OD1 ASP A 149      -5.504  25.408  89.233  1.00 30.26           O  
ATOM   1173  OD2 ASP A 149      -5.399  24.960  87.085  1.00 28.28           O  
ATOM   1174  N   ILE A 150      -4.243  29.668  86.182  1.00 20.10           N  
ATOM   1175  CA  ILE A 150      -3.963  31.086  86.171  1.00 16.92           C  
ATOM   1176  C   ILE A 150      -4.582  31.854  85.009  1.00 17.60           C  
ATOM   1177  O   ILE A 150      -4.980  33.010  85.188  1.00 13.42           O  
ATOM   1178  CB  ILE A 150      -2.432  31.349  86.267  1.00 17.64           C  
ATOM   1179  CG1 ILE A 150      -2.188  32.829  86.568  1.00 16.93           C  
ATOM   1180  CG2 ILE A 150      -1.737  30.928  84.986  1.00 15.83           C  
ATOM   1181  CD1 ILE A 150      -0.795  33.118  87.038  1.00 19.06           C  
ATOM   1182  N   PHE A 151      -4.667  31.243  83.825  1.00 18.16           N  
ATOM   1183  CA  PHE A 151      -5.296  31.947  82.706  1.00 17.20           C  
ATOM   1184  C   PHE A 151      -6.810  31.964  82.942  1.00 19.30           C  
ATOM   1185  O   PHE A 151      -7.511  32.892  82.525  1.00 18.73           O  
ATOM   1186  CB  PHE A 151      -4.942  31.300  81.367  1.00 16.80           C  
ATOM   1187  CG  PHE A 151      -3.543  31.620  80.894  1.00 14.11           C  
ATOM   1188  CD1 PHE A 151      -2.504  30.700  81.054  1.00 14.42           C  
ATOM   1189  CD2 PHE A 151      -3.254  32.856  80.335  1.00 12.19           C  
ATOM   1190  CE1 PHE A 151      -1.189  31.016  80.665  1.00 14.95           C  
ATOM   1191  CE2 PHE A 151      -1.947  33.185  79.944  1.00 16.04           C  
ATOM   1192  CZ  PHE A 151      -0.912  32.262  80.112  1.00 15.38           C  
ATOM   1193  N   ILE A 152      -7.310  30.949  83.642  1.00 18.59           N  
ATOM   1194  CA  ILE A 152      -8.724  30.901  83.969  1.00 18.98           C  
ATOM   1195  C   ILE A 152      -9.017  31.996  85.004  1.00 19.39           C  
ATOM   1196  O   ILE A 152     -10.031  32.676  84.925  1.00 18.64           O  
ATOM   1197  CB  ILE A 152      -9.138  29.535  84.579  1.00 20.53           C  
ATOM   1198  CG1 ILE A 152      -9.100  28.447  83.505  1.00 22.68           C  
ATOM   1199  CG2 ILE A 152     -10.557  29.631  85.191  1.00 16.99           C  
ATOM   1200  CD1 ILE A 152      -9.347  27.052  84.056  1.00 21.98           C  
ATOM   1201  N   ALA A 153      -8.129  32.172  85.976  1.00 18.64           N  
ATOM   1202  CA  ALA A 153      -8.367  33.197  86.987  1.00 19.09           C  
ATOM   1203  C   ALA A 153      -8.260  34.598  86.365  1.00 19.03           C  
ATOM   1204  O   ALA A 153      -9.039  35.494  86.691  1.00 18.08           O  
ATOM   1205  CB  ALA A 153      -7.384  33.044  88.128  1.00 15.47           C  
ATOM   1206  N   ALA A 154      -7.308  34.766  85.456  1.00 17.62           N  
ATOM   1207  CA  ALA A 154      -7.089  36.049  84.794  1.00 17.63           C  
ATOM   1208  C   ALA A 154      -8.279  36.452  83.924  1.00 17.86           C  
ATOM   1209  O   ALA A 154      -8.660  37.621  83.875  1.00 15.10           O  
ATOM   1210  CB  ALA A 154      -5.821  35.989  83.951  1.00 14.33           C  
ATOM   1211  N   ALA A 155      -8.856  35.487  83.221  1.00 17.67           N  
ATOM   1212  CA  ALA A 155     -10.006  35.788  82.379  1.00 18.15           C  
ATOM   1213  C   ALA A 155     -11.197  36.133  83.270  1.00 17.74           C  
ATOM   1214  O   ALA A 155     -11.851  37.152  83.076  1.00 16.35           O  
ATOM   1215  CB  ALA A 155     -10.338  34.602  81.487  1.00 16.75           C  
ATOM   1216  N   HIS A 156     -11.467  35.300  84.263  1.00 16.03           N  
ATOM   1217  CA  HIS A 156     -12.594  35.572  85.151  1.00 19.13           C  
ATOM   1218  C   HIS A 156     -12.497  36.912  85.868  1.00 19.40           C  
ATOM   1219  O   HIS A 156     -13.513  37.560  86.111  1.00 18.83           O  
ATOM   1220  CB  HIS A 156     -12.748  34.451  86.176  1.00 18.99           C  
ATOM   1221  CG  HIS A 156     -13.311  33.191  85.601  1.00 19.95           C  
ATOM   1222  ND1 HIS A 156     -13.559  32.070  86.361  1.00 21.74           N  
ATOM   1223  CD2 HIS A 156     -13.668  32.873  84.333  1.00 20.63           C  
ATOM   1224  CE1 HIS A 156     -14.042  31.114  85.588  1.00 22.03           C  
ATOM   1225  NE2 HIS A 156     -14.115  31.578  84.352  1.00 22.84           N  
ATOM   1226  N   ALA A 157     -11.273  37.325  86.184  1.00 20.61           N  
ATOM   1227  CA  ALA A 157     -11.030  38.577  86.887  1.00 20.44           C  
ATOM   1228  C   ALA A 157     -11.490  39.796  86.089  1.00 20.62           C  
ATOM   1229  O   ALA A 157     -11.764  40.852  86.659  1.00 18.60           O  
ATOM   1230  CB  ALA A 157      -9.552  38.699  87.227  1.00 19.52           C  
ATOM   1231  N   VAL A 158     -11.553  39.662  84.768  1.00 21.62           N  
ATOM   1232  CA  VAL A 158     -12.003  40.772  83.938  1.00 21.27           C  
ATOM   1233  C   VAL A 158     -13.430  40.538  83.424  1.00 21.64           C  
ATOM   1234  O   VAL A 158     -13.913  41.253  82.555  1.00 22.51           O  
ATOM   1235  CB  VAL A 158     -11.018  41.025  82.771  1.00 22.20           C  
ATOM   1236  CG1 VAL A 158      -9.643  41.354  83.344  1.00 19.45           C  
ATOM   1237  CG2 VAL A 158     -10.938  39.802  81.856  1.00 20.43           C  
ATOM   1238  N   GLY A 159     -14.095  39.526  83.986  1.00 21.86           N  
ATOM   1239  CA  GLY A 159     -15.470  39.223  83.631  1.00 20.99           C  
ATOM   1240  C   GLY A 159     -15.743  38.520  82.316  1.00 22.81           C  
ATOM   1241  O   GLY A 159     -16.810  38.701  81.730  1.00 23.44           O  
ATOM   1242  N   VAL A 160     -14.788  37.731  81.837  1.00 22.73           N  
ATOM   1243  CA  VAL A 160     -14.981  36.997  80.596  1.00 22.37           C  
ATOM   1244  C   VAL A 160     -14.606  35.540  80.811  1.00 22.13           C  
ATOM   1245  O   VAL A 160     -13.999  35.177  81.817  1.00 21.98           O  
ATOM   1246  CB  VAL A 160     -14.114  37.555  79.443  1.00 23.18           C  
ATOM   1247  CG1 VAL A 160     -14.318  39.058  79.318  1.00 24.82           C  
ATOM   1248  CG2 VAL A 160     -12.656  37.231  79.674  1.00 23.87           C  
ATOM   1249  N   ALA A 161     -14.988  34.696  79.871  1.00 21.11           N  
ATOM   1250  CA  ALA A 161     -14.634  33.297  79.966  1.00 20.71           C  
ATOM   1251  C   ALA A 161     -13.313  33.203  79.206  1.00 20.13           C  
ATOM   1252  O   ALA A 161     -13.003  34.061  78.379  1.00 18.81           O  
ATOM   1253  CB  ALA A 161     -15.701  32.434  79.293  1.00 18.99           C  
ATOM   1254  N   PRO A 162     -12.503  32.185  79.502  1.00 19.79           N  
ATOM   1255  CA  PRO A 162     -11.237  32.070  78.776  1.00 20.33           C  
ATOM   1256  C   PRO A 162     -11.506  31.865  77.283  1.00 21.71           C  
ATOM   1257  O   PRO A 162     -10.731  32.320  76.430  1.00 20.65           O  
ATOM   1258  CB  PRO A 162     -10.588  30.849  79.420  1.00 20.72           C  
ATOM   1259  CG  PRO A 162     -11.057  30.934  80.820  1.00 18.77           C  
ATOM   1260  CD  PRO A 162     -12.524  31.285  80.667  1.00 18.00           C  
ATOM   1261  N   SER A 163     -12.620  31.201  76.965  1.00 21.11           N  
ATOM   1262  CA  SER A 163     -12.961  30.943  75.563  1.00 21.52           C  
ATOM   1263  C   SER A 163     -13.160  32.233  74.775  1.00 20.87           C  
ATOM   1264  O   SER A 163     -13.186  32.214  73.547  1.00 22.91           O  
ATOM   1265  CB  SER A 163     -14.212  30.060  75.445  1.00 22.05           C  
ATOM   1266  OG  SER A 163     -15.386  30.741  75.849  1.00 23.51           O  
ATOM   1267  N   GLU A 164     -13.296  33.354  75.473  1.00 21.02           N  
ATOM   1268  CA  GLU A 164     -13.461  34.639  74.789  1.00 20.69           C  
ATOM   1269  C   GLU A 164     -12.134  35.395  74.800  1.00 19.39           C  
ATOM   1270  O   GLU A 164     -12.102  36.611  74.549  1.00 19.85           O  
ATOM   1271  CB  GLU A 164     -14.486  35.515  75.507  1.00 20.23           C  
ATOM   1272  CG  GLU A 164     -15.801  34.866  75.875  1.00 22.19           C  
ATOM   1273  CD  GLU A 164     -16.631  35.793  76.749  1.00 23.45           C  
ATOM   1274  OE1 GLU A 164     -17.258  36.733  76.205  1.00 26.44           O  
ATOM   1275  OE2 GLU A 164     -16.631  35.599  77.985  1.00 21.76           O  
ATOM   1276  N   SER A 165     -11.046  34.692  75.092  1.00 15.67           N  
ATOM   1277  CA  SER A 165      -9.752  35.351  75.186  1.00 16.20           C  
ATOM   1278  C   SER A 165      -8.627  34.810  74.333  1.00 16.78           C  
ATOM   1279  O   SER A 165      -8.700  33.716  73.775  1.00 18.48           O  
ATOM   1280  CB  SER A 165      -9.268  35.322  76.641  1.00 16.37           C  
ATOM   1281  OG  SER A 165     -10.295  35.712  77.540  1.00 19.37           O  
ATOM   1282  N   ILE A 166      -7.576  35.613  74.260  1.00 17.25           N  
ATOM   1283  CA  ILE A 166      -6.347  35.266  73.572  1.00 19.13           C  
ATOM   1284  C   ILE A 166      -5.287  35.337  74.675  1.00 20.20           C  
ATOM   1285  O   ILE A 166      -5.306  36.253  75.501  1.00 19.57           O  
ATOM   1286  CB  ILE A 166      -5.967  36.287  72.499  1.00 19.62           C  
ATOM   1287  CG1 ILE A 166      -6.880  36.134  71.283  1.00 19.65           C  
ATOM   1288  CG2 ILE A 166      -4.479  36.118  72.131  1.00 17.14           C  
ATOM   1289  CD1 ILE A 166      -6.766  37.278  70.291  1.00 20.57           C  
ATOM   1290  N   GLY A 167      -4.389  34.357  74.702  1.00 20.73           N  
ATOM   1291  CA  GLY A 167      -3.331  34.357  75.692  1.00 19.53           C  
ATOM   1292  C   GLY A 167      -2.003  34.506  74.975  1.00 19.94           C  
ATOM   1293  O   GLY A 167      -1.758  33.812  73.975  1.00 20.46           O  
ATOM   1294  N   LEU A 168      -1.153  35.407  75.462  1.00 17.26           N  
ATOM   1295  CA  LEU A 168       0.163  35.639  74.862  1.00 16.50           C  
ATOM   1296  C   LEU A 168       1.234  34.996  75.746  1.00 17.08           C  
ATOM   1297  O   LEU A 168       1.370  35.340  76.920  1.00 18.78           O  
ATOM   1298  CB  LEU A 168       0.423  37.146  74.721  1.00 13.50           C  
ATOM   1299  CG  LEU A 168      -0.635  37.911  73.910  1.00 15.28           C  
ATOM   1300  CD1 LEU A 168      -0.198  39.347  73.668  1.00 11.29           C  
ATOM   1301  CD2 LEU A 168      -0.852  37.199  72.577  1.00 16.50           C  
ATOM   1302  N   GLU A 169       1.996  34.069  75.174  1.00 17.16           N  
ATOM   1303  CA  GLU A 169       3.027  33.344  75.917  1.00 16.67           C  
ATOM   1304  C   GLU A 169       4.349  33.131  75.189  1.00 15.82           C  
ATOM   1305  O   GLU A 169       4.423  33.152  73.956  1.00 16.30           O  
ATOM   1306  CB  GLU A 169       2.473  31.982  76.355  1.00 15.10           C  
ATOM   1307  CG  GLU A 169       1.893  31.973  77.769  1.00 21.06           C  
ATOM   1308  CD  GLU A 169       2.974  31.895  78.862  1.00 19.90           C  
ATOM   1309  OE1 GLU A 169       4.175  31.811  78.529  1.00 19.70           O  
ATOM   1310  OE2 GLU A 169       2.616  31.912  80.058  1.00 20.69           O  
ATOM   1311  N   ASP A 170       5.395  32.903  75.974  1.00 17.05           N  
ATOM   1312  CA  ASP A 170       6.724  32.652  75.432  1.00 18.23           C  
ATOM   1313  C   ASP A 170       7.233  31.252  75.826  1.00 19.17           C  
ATOM   1314  O   ASP A 170       8.330  30.864  75.436  1.00 18.90           O  
ATOM   1315  CB  ASP A 170       7.701  33.706  75.949  1.00 20.17           C  
ATOM   1316  CG  ASP A 170       8.028  33.539  77.438  1.00 20.33           C  
ATOM   1317  OD1 ASP A 170       7.106  33.407  78.281  1.00 17.96           O  
ATOM   1318  OD2 ASP A 170       9.235  33.563  77.769  1.00 22.05           O  
ATOM   1319  N   SER A 171       6.438  30.498  76.584  1.00 18.04           N  
ATOM   1320  CA  SER A 171       6.868  29.171  77.041  1.00 19.76           C  
ATOM   1321  C   SER A 171       5.937  28.056  76.611  1.00 19.35           C  
ATOM   1322  O   SER A 171       4.745  28.274  76.419  1.00 20.52           O  
ATOM   1323  CB  SER A 171       6.954  29.143  78.566  1.00 21.39           C  
ATOM   1324  OG  SER A 171       5.657  28.979  79.132  1.00 23.25           O  
ATOM   1325  N   GLN A 172       6.475  26.850  76.487  1.00 20.90           N  
ATOM   1326  CA  GLN A 172       5.657  25.713  76.073  1.00 21.19           C  
ATOM   1327  C   GLN A 172       4.607  25.449  77.136  1.00 20.17           C  
ATOM   1328  O   GLN A 172       3.435  25.278  76.822  1.00 19.83           O  
ATOM   1329  CB  GLN A 172       6.531  24.465  75.854  1.00 24.32           C  
ATOM   1330  CG  GLN A 172       5.811  23.259  75.200  1.00 24.70           C  
ATOM   1331  CD  GLN A 172       4.878  22.544  76.160  1.00 25.04           C  
ATOM   1332  OE1 GLN A 172       5.216  22.347  77.325  1.00 25.09           O  
ATOM   1333  NE2 GLN A 172       3.702  22.146  75.676  1.00 25.49           N  
ATOM   1334  N   ALA A 173       5.019  25.434  78.401  1.00 20.51           N  
ATOM   1335  CA  ALA A 173       4.068  25.195  79.485  1.00 20.35           C  
ATOM   1336  C   ALA A 173       2.949  26.243  79.436  1.00 20.25           C  
ATOM   1337  O   ALA A 173       1.774  25.921  79.624  1.00 18.83           O  
ATOM   1338  CB  ALA A 173       4.781  25.246  80.832  1.00 20.13           C  
ATOM   1339  N   GLY A 174       3.328  27.495  79.175  1.00 19.87           N  
ATOM   1340  CA  GLY A 174       2.358  28.580  79.102  1.00 20.77           C  
ATOM   1341  C   GLY A 174       1.364  28.367  77.985  1.00 20.76           C  
ATOM   1342  O   GLY A 174       0.161  28.549  78.160  1.00 20.67           O  
ATOM   1343  N   ILE A 175       1.874  27.966  76.826  1.00 23.30           N  
ATOM   1344  CA  ILE A 175       1.036  27.692  75.670  1.00 21.33           C  
ATOM   1345  C   ILE A 175       0.022  26.602  76.021  1.00 21.55           C  
ATOM   1346  O   ILE A 175      -1.161  26.712  75.704  1.00 19.44           O  
ATOM   1347  CB  ILE A 175       1.896  27.216  74.467  1.00 22.89           C  
ATOM   1348  CG1 ILE A 175       2.749  28.376  73.956  1.00 23.32           C  
ATOM   1349  CG2 ILE A 175       1.007  26.673  73.338  1.00 22.18           C  
ATOM   1350  CD1 ILE A 175       1.947  29.541  73.430  1.00 23.40           C  
ATOM   1351  N   GLN A 176       0.495  25.550  76.678  1.00 21.54           N  
ATOM   1352  CA  GLN A 176      -0.369  24.436  77.051  1.00 21.36           C  
ATOM   1353  C   GLN A 176      -1.426  24.917  78.036  1.00 21.15           C  
ATOM   1354  O   GLN A 176      -2.582  24.502  77.975  1.00 19.48           O  
ATOM   1355  CB  GLN A 176       0.461  23.311  77.687  1.00 22.81           C  
ATOM   1356  CG  GLN A 176      -0.333  22.047  77.972  1.00 24.63           C  
ATOM   1357  CD  GLN A 176      -0.861  21.396  76.701  1.00 24.79           C  
ATOM   1358  OE1 GLN A 176      -2.022  20.999  76.631  1.00 27.29           O  
ATOM   1359  NE2 GLN A 176      -0.004  21.275  75.698  1.00 26.36           N  
ATOM   1360  N   ALA A 177      -1.011  25.797  78.945  1.00 21.73           N  
ATOM   1361  CA  ALA A 177      -1.910  26.354  79.952  1.00 21.96           C  
ATOM   1362  C   ALA A 177      -3.046  27.122  79.285  1.00 20.80           C  
ATOM   1363  O   ALA A 177      -4.191  27.047  79.724  1.00 19.51           O  
ATOM   1364  CB  ALA A 177      -1.141  27.284  80.901  1.00 18.47           C  
ATOM   1365  N   ILE A 178      -2.718  27.865  78.229  1.00 22.77           N  
ATOM   1366  CA  ILE A 178      -3.718  28.650  77.501  1.00 23.04           C  
ATOM   1367  C   ILE A 178      -4.705  27.731  76.780  1.00 24.68           C  
ATOM   1368  O   ILE A 178      -5.918  27.914  76.890  1.00 25.53           O  
ATOM   1369  CB  ILE A 178      -3.043  29.605  76.499  1.00 20.25           C  
ATOM   1370  CG1 ILE A 178      -2.275  30.683  77.274  1.00 21.24           C  
ATOM   1371  CG2 ILE A 178      -4.073  30.237  75.593  1.00 19.53           C  
ATOM   1372  CD1 ILE A 178      -1.372  31.557  76.413  1.00 18.38           C  
ATOM   1373  N   LYS A 179      -4.186  26.737  76.062  1.00 25.39           N  
ATOM   1374  CA  LYS A 179      -5.039  25.787  75.347  1.00 26.18           C  
ATOM   1375  C   LYS A 179      -6.043  25.121  76.286  1.00 25.06           C  
ATOM   1376  O   LYS A 179      -7.244  25.085  76.010  1.00 24.93           O  
ATOM   1377  CB  LYS A 179      -4.187  24.702  74.672  1.00 28.92           C  
ATOM   1378  CG  LYS A 179      -3.387  25.197  73.484  1.00 32.17           C  
ATOM   1379  CD  LYS A 179      -2.305  24.202  73.055  1.00 37.17           C  
ATOM   1380  CE  LYS A 179      -2.881  22.939  72.424  1.00 40.12           C  
ATOM   1381  NZ  LYS A 179      -1.797  22.017  71.978  1.00 38.83           N  
ATOM   1382  N   ASP A 180      -5.556  24.600  77.404  1.00 24.03           N  
ATOM   1383  CA  ASP A 180      -6.434  23.927  78.339  1.00 23.85           C  
ATOM   1384  C   ASP A 180      -7.428  24.823  79.065  1.00 24.38           C  
ATOM   1385  O   ASP A 180      -8.371  24.324  79.673  1.00 24.67           O  
ATOM   1386  CB  ASP A 180      -5.616  23.111  79.345  1.00 26.01           C  
ATOM   1387  CG  ASP A 180      -4.865  21.962  78.685  1.00 24.51           C  
ATOM   1388  OD1 ASP A 180      -5.320  21.483  77.624  1.00 24.39           O  
ATOM   1389  OD2 ASP A 180      -3.826  21.536  79.229  1.00 23.96           O  
ATOM   1390  N   SER A 181      -7.232  26.137  79.006  1.00 23.23           N  
ATOM   1391  CA  SER A 181      -8.177  27.047  79.648  1.00 21.76           C  
ATOM   1392  C   SER A 181      -9.285  27.339  78.641  1.00 20.94           C  
ATOM   1393  O   SER A 181     -10.387  27.735  79.014  1.00 18.87           O  
ATOM   1394  CB  SER A 181      -7.499  28.362  80.043  1.00 21.36           C  
ATOM   1395  OG  SER A 181      -7.270  29.177  78.904  1.00 18.65           O  
ATOM   1396  N   GLY A 182      -8.977  27.134  77.361  1.00 20.58           N  
ATOM   1397  CA  GLY A 182      -9.948  27.382  76.304  1.00 19.25           C  
ATOM   1398  C   GLY A 182      -9.694  28.680  75.565  1.00 18.93           C  
ATOM   1399  O   GLY A 182     -10.403  29.021  74.624  1.00 21.28           O  
ATOM   1400  N   ALA A 183      -8.678  29.414  75.994  1.00 18.83           N  
ATOM   1401  CA  ALA A 183      -8.329  30.679  75.364  1.00 17.59           C  
ATOM   1402  C   ALA A 183      -7.480  30.373  74.126  1.00 17.88           C  
ATOM   1403  O   ALA A 183      -6.936  29.282  74.001  1.00 18.35           O  
ATOM   1404  CB  ALA A 183      -7.543  31.554  76.362  1.00 15.32           C  
ATOM   1405  N   LEU A 184      -7.364  31.333  73.216  1.00 17.40           N  
ATOM   1406  CA  LEU A 184      -6.586  31.126  72.007  1.00 19.45           C  
ATOM   1407  C   LEU A 184      -5.159  31.600  72.207  1.00 19.90           C  
ATOM   1408  O   LEU A 184      -4.912  32.783  72.460  1.00 21.36           O  
ATOM   1409  CB  LEU A 184      -7.206  31.871  70.824  1.00 21.03           C  
ATOM   1410  CG  LEU A 184      -6.409  31.709  69.522  1.00 24.44           C  
ATOM   1411  CD1 LEU A 184      -6.349  30.224  69.148  1.00 24.95           C  
ATOM   1412  CD2 LEU A 184      -7.044  32.525  68.408  1.00 22.17           C  
ATOM   1413  N   PRO A 185      -4.195  30.679  72.096  1.00 20.57           N  
ATOM   1414  CA  PRO A 185      -2.794  31.047  72.279  1.00 19.49           C  
ATOM   1415  C   PRO A 185      -2.137  31.645  71.050  1.00 20.05           C  
ATOM   1416  O   PRO A 185      -2.471  31.296  69.925  1.00 21.35           O  
ATOM   1417  CB  PRO A 185      -2.146  29.726  72.666  1.00 20.56           C  
ATOM   1418  CG  PRO A 185      -2.925  28.734  71.817  1.00 20.37           C  
ATOM   1419  CD  PRO A 185      -4.352  29.216  71.940  1.00 19.83           C  
ATOM   1420  N   ILE A 186      -1.221  32.575  71.281  1.00 18.66           N  
ATOM   1421  CA  ILE A 186      -0.434  33.171  70.219  1.00 18.22           C  
ATOM   1422  C   ILE A 186       0.923  33.287  70.869  1.00 19.85           C  
ATOM   1423  O   ILE A 186       1.160  34.184  71.686  1.00 20.31           O  
ATOM   1424  CB  ILE A 186      -0.883  34.587  69.803  1.00 18.12           C  
ATOM   1425  CG1 ILE A 186      -2.330  34.579  69.296  1.00 18.69           C  
ATOM   1426  CG2 ILE A 186       0.040  35.073  68.685  1.00 15.63           C  
ATOM   1427  CD1 ILE A 186      -2.813  35.936  68.752  1.00 15.74           C  
ATOM   1428  N   GLY A 187       1.823  32.379  70.520  1.00 20.35           N  
ATOM   1429  CA  GLY A 187       3.128  32.411  71.141  1.00 19.20           C  
ATOM   1430  C   GLY A 187       4.118  33.350  70.506  1.00 20.05           C  
ATOM   1431  O   GLY A 187       3.905  33.866  69.412  1.00 19.75           O  
ATOM   1432  N   VAL A 188       5.198  33.610  71.231  1.00 19.61           N  
ATOM   1433  CA  VAL A 188       6.264  34.435  70.707  1.00 19.90           C  
ATOM   1434  C   VAL A 188       7.505  33.597  70.959  1.00 21.84           C  
ATOM   1435  O   VAL A 188       7.792  33.221  72.090  1.00 20.30           O  
ATOM   1436  CB  VAL A 188       6.360  35.828  71.408  1.00 18.90           C  
ATOM   1437  CG1 VAL A 188       6.474  35.680  72.922  1.00 15.16           C  
ATOM   1438  CG2 VAL A 188       7.541  36.597  70.840  1.00 16.49           C  
ATOM   1439  N   GLY A 189       8.203  33.269  69.880  1.00 23.38           N  
ATOM   1440  CA  GLY A 189       9.401  32.459  69.971  1.00 25.48           C  
ATOM   1441  C   GLY A 189       9.522  31.668  68.686  1.00 27.79           C  
ATOM   1442  O   GLY A 189       9.463  32.235  67.586  1.00 26.30           O  
ATOM   1443  N   ARG A 190       9.677  30.356  68.812  1.00 29.65           N  
ATOM   1444  CA  ARG A 190       9.791  29.509  67.637  1.00 32.50           C  
ATOM   1445  C   ARG A 190       9.062  28.179  67.821  1.00 31.87           C  
ATOM   1446  O   ARG A 190       8.993  27.633  68.921  1.00 31.03           O  
ATOM   1447  CB  ARG A 190      11.265  29.270  67.294  1.00 34.18           C  
ATOM   1448  CG  ARG A 190      12.027  28.320  68.211  1.00 39.50           C  
ATOM   1449  CD  ARG A 190      13.332  27.913  67.518  1.00 44.27           C  
ATOM   1450  NE  ARG A 190      14.032  26.805  68.166  1.00 47.76           N  
ATOM   1451  CZ  ARG A 190      14.855  26.939  69.200  1.00 49.91           C  
ATOM   1452  NH1 ARG A 190      15.088  28.143  69.712  1.00 51.36           N  
ATOM   1453  NH2 ARG A 190      15.446  25.871  69.719  1.00 48.00           N  
ATOM   1454  N   PRO A 191       8.505  27.636  66.735  1.00 32.30           N  
ATOM   1455  CA  PRO A 191       7.791  26.364  66.869  1.00 32.83           C  
ATOM   1456  C   PRO A 191       8.555  25.256  67.584  1.00 33.81           C  
ATOM   1457  O   PRO A 191       7.950  24.453  68.292  1.00 34.37           O  
ATOM   1458  CB  PRO A 191       7.436  26.004  65.422  1.00 32.06           C  
ATOM   1459  CG  PRO A 191       8.461  26.754  64.596  1.00 32.41           C  
ATOM   1460  CD  PRO A 191       8.561  28.073  65.330  1.00 32.07           C  
ATOM   1461  N   GLU A 192       9.874  25.223  67.429  1.00 34.85           N  
ATOM   1462  CA  GLU A 192      10.667  24.172  68.059  1.00 36.54           C  
ATOM   1463  C   GLU A 192      10.514  24.091  69.570  1.00 36.89           C  
ATOM   1464  O   GLU A 192      10.651  23.011  70.152  1.00 37.00           O  
ATOM   1465  CB  GLU A 192      12.151  24.321  67.710  1.00 39.33           C  
ATOM   1466  CG  GLU A 192      12.470  24.198  66.228  1.00 41.07           C  
ATOM   1467  CD  GLU A 192      12.423  25.537  65.519  1.00 45.09           C  
ATOM   1468  OE1 GLU A 192      11.360  26.191  65.552  1.00 45.73           O  
ATOM   1469  OE2 GLU A 192      13.455  25.943  64.937  1.00 49.24           O  
ATOM   1470  N   ASP A 193      10.233  25.224  70.211  1.00 35.09           N  
ATOM   1471  CA  ASP A 193      10.058  25.238  71.658  1.00 33.43           C  
ATOM   1472  C   ASP A 193       8.586  25.220  72.034  1.00 32.58           C  
ATOM   1473  O   ASP A 193       8.183  24.556  72.985  1.00 34.64           O  
ATOM   1474  CB  ASP A 193      10.680  26.493  72.276  1.00 33.38           C  
ATOM   1475  CG  ASP A 193      12.157  26.620  71.990  1.00 33.80           C  
ATOM   1476  OD1 ASP A 193      12.868  25.597  72.080  1.00 35.44           O  
ATOM   1477  OD2 ASP A 193      12.609  27.745  71.686  1.00 32.10           O  
ATOM   1478  N   LEU A 194       7.789  25.947  71.262  1.00 31.19           N  
ATOM   1479  CA  LEU A 194       6.370  26.115  71.533  1.00 28.18           C  
ATOM   1480  C   LEU A 194       5.381  25.092  71.015  1.00 29.72           C  
ATOM   1481  O   LEU A 194       4.337  24.873  71.636  1.00 27.99           O  
ATOM   1482  CB  LEU A 194       5.958  27.504  71.053  1.00 25.47           C  
ATOM   1483  CG  LEU A 194       6.223  28.677  72.005  1.00 26.34           C  
ATOM   1484  CD1 LEU A 194       7.287  28.333  73.044  1.00 22.82           C  
ATOM   1485  CD2 LEU A 194       6.612  29.892  71.190  1.00 24.60           C  
ATOM   1486  N   GLY A 195       5.691  24.474  69.880  1.00 31.22           N  
ATOM   1487  CA  GLY A 195       4.784  23.499  69.304  1.00 32.51           C  
ATOM   1488  C   GLY A 195       4.459  23.897  67.877  1.00 34.23           C  
ATOM   1489  O   GLY A 195       4.678  25.041  67.486  1.00 34.10           O  
ATOM   1490  N   ASP A 196       3.929  22.963  67.097  1.00 35.38           N  
ATOM   1491  CA  ASP A 196       3.604  23.237  65.704  1.00 37.46           C  
ATOM   1492  C   ASP A 196       2.125  23.507  65.468  1.00 37.24           C  
ATOM   1493  O   ASP A 196       1.724  23.783  64.343  1.00 36.75           O  
ATOM   1494  CB  ASP A 196       4.044  22.061  64.827  1.00 40.57           C  
ATOM   1495  CG  ASP A 196       5.542  21.792  64.912  1.00 43.10           C  
ATOM   1496  OD1 ASP A 196       6.334  22.700  64.566  1.00 43.80           O  
ATOM   1497  OD2 ASP A 196       5.926  20.674  65.325  1.00 45.52           O  
ATOM   1498  N   ASP A 197       1.325  23.461  66.531  1.00 36.74           N  
ATOM   1499  CA  ASP A 197      -0.116  23.651  66.401  1.00 34.94           C  
ATOM   1500  C   ASP A 197      -0.708  25.006  66.807  1.00 34.93           C  
ATOM   1501  O   ASP A 197      -1.914  25.102  67.057  1.00 34.93           O  
ATOM   1502  CB  ASP A 197      -0.828  22.546  67.171  1.00 36.62           C  
ATOM   1503  CG  ASP A 197      -0.563  22.616  68.654  1.00 38.73           C  
ATOM   1504  OD1 ASP A 197       0.594  22.892  69.036  1.00 43.03           O  
ATOM   1505  OD2 ASP A 197      -1.504  22.393  69.441  1.00 41.68           O  
ATOM   1506  N   ILE A 198       0.114  26.048  66.881  1.00 31.73           N  
ATOM   1507  CA  ILE A 198      -0.406  27.358  67.242  1.00 29.49           C  
ATOM   1508  C   ILE A 198       0.300  28.457  66.472  1.00 27.34           C  
ATOM   1509  O   ILE A 198       1.424  28.274  66.010  1.00 25.09           O  
ATOM   1510  CB  ILE A 198      -0.250  27.669  68.772  1.00 32.11           C  
ATOM   1511  CG1 ILE A 198       1.220  27.979  69.124  1.00 31.50           C  
ATOM   1512  CG2 ILE A 198      -0.819  26.521  69.604  1.00 31.54           C  
ATOM   1513  CD1 ILE A 198       2.184  26.832  68.974  1.00 32.80           C  
ATOM   1514  N   VAL A 199      -0.364  29.601  66.332  1.00 24.32           N  
ATOM   1515  CA  VAL A 199       0.247  30.731  65.652  1.00 22.89           C  
ATOM   1516  C   VAL A 199       1.388  31.246  66.527  1.00 22.27           C  
ATOM   1517  O   VAL A 199       1.265  31.307  67.750  1.00 22.69           O  
ATOM   1518  CB  VAL A 199      -0.762  31.876  65.435  1.00 23.03           C  
ATOM   1519  CG1 VAL A 199      -0.049  33.098  64.863  1.00 22.09           C  
ATOM   1520  CG2 VAL A 199      -1.870  31.419  64.491  1.00 22.90           C  
ATOM   1521  N   ILE A 200       2.502  31.608  65.901  1.00 22.92           N  
ATOM   1522  CA  ILE A 200       3.658  32.119  66.627  1.00 21.43           C  
ATOM   1523  C   ILE A 200       4.308  33.303  65.919  1.00 21.30           C  
ATOM   1524  O   ILE A 200       4.489  33.275  64.698  1.00 21.95           O  
ATOM   1525  CB  ILE A 200       4.729  31.032  66.793  1.00 21.36           C  
ATOM   1526  CG1 ILE A 200       4.185  29.889  67.656  1.00 22.30           C  
ATOM   1527  CG2 ILE A 200       5.977  31.628  67.407  1.00 21.96           C  
ATOM   1528  CD1 ILE A 200       5.135  28.693  67.767  1.00 23.70           C  
ATOM   1529  N   VAL A 201       4.631  34.348  66.679  1.00 20.21           N  
ATOM   1530  CA  VAL A 201       5.320  35.507  66.118  1.00 21.68           C  
ATOM   1531  C   VAL A 201       6.758  35.426  66.634  1.00 22.43           C  
ATOM   1532  O   VAL A 201       6.993  35.131  67.806  1.00 22.39           O  
ATOM   1533  CB  VAL A 201       4.677  36.849  66.539  1.00 21.96           C  
ATOM   1534  CG1 VAL A 201       3.242  36.890  66.059  1.00 21.08           C  
ATOM   1535  CG2 VAL A 201       4.742  37.040  68.055  1.00 22.45           C  
ATOM   1536  N   PRO A 202       7.735  35.669  65.753  1.00 22.74           N  
ATOM   1537  CA  PRO A 202       9.179  35.641  66.001  1.00 22.09           C  
ATOM   1538  C   PRO A 202       9.635  36.550  67.129  1.00 22.17           C  
ATOM   1539  O   PRO A 202      10.586  36.242  67.855  1.00 18.29           O  
ATOM   1540  CB  PRO A 202       9.771  36.107  64.674  1.00 21.46           C  
ATOM   1541  CG  PRO A 202       8.722  35.755  63.684  1.00 25.72           C  
ATOM   1542  CD  PRO A 202       7.462  36.125  64.383  1.00 24.10           C  
ATOM   1543  N   ASP A 203       8.956  37.683  67.252  1.00 20.95           N  
ATOM   1544  CA  ASP A 203       9.315  38.671  68.243  1.00 20.88           C  
ATOM   1545  C   ASP A 203       8.023  39.446  68.587  1.00 21.34           C  
ATOM   1546  O   ASP A 203       7.079  39.447  67.806  1.00 22.84           O  
ATOM   1547  CB  ASP A 203      10.474  39.533  67.651  1.00 18.15           C  
ATOM   1548  CG  ASP A 203      10.046  40.438  66.479  1.00 18.63           C  
ATOM   1549  OD1 ASP A 203       9.476  41.487  66.845  1.00 15.86           O  
ATOM   1550  OD2 ASP A 203      10.273  40.155  65.227  1.00 15.19           O  
ATOM   1551  N   THR A 204       7.962  40.082  69.751  1.00 20.02           N  
ATOM   1552  CA  THR A 204       6.743  40.789  70.160  1.00 19.35           C  
ATOM   1553  C   THR A 204       6.309  42.013  69.350  1.00 19.25           C  
ATOM   1554  O   THR A 204       5.164  42.439  69.467  1.00 17.20           O  
ATOM   1555  CB  THR A 204       6.823  41.262  71.609  1.00 17.11           C  
ATOM   1556  OG1 THR A 204       7.835  42.266  71.705  1.00 17.64           O  
ATOM   1557  CG2 THR A 204       7.142  40.114  72.535  1.00 18.05           C  
ATOM   1558  N   SER A 205       7.198  42.597  68.552  1.00 17.98           N  
ATOM   1559  CA  SER A 205       6.794  43.770  67.779  1.00 19.09           C  
ATOM   1560  C   SER A 205       5.637  43.384  66.870  1.00 20.95           C  
ATOM   1561  O   SER A 205       4.916  44.255  66.360  1.00 20.09           O  
ATOM   1562  CB  SER A 205       7.947  44.305  66.926  1.00 19.76           C  
ATOM   1563  OG  SER A 205       8.251  43.417  65.856  1.00 20.39           O  
ATOM   1564  N   HIS A 206       5.447  42.078  66.679  1.00 20.25           N  
ATOM   1565  CA  HIS A 206       4.368  41.601  65.821  1.00 23.84           C  
ATOM   1566  C   HIS A 206       3.032  41.331  66.540  1.00 25.41           C  
ATOM   1567  O   HIS A 206       2.045  40.916  65.918  1.00 24.61           O  
ATOM   1568  CB  HIS A 206       4.837  40.380  65.026  1.00 22.65           C  
ATOM   1569  CG  HIS A 206       6.067  40.647  64.211  1.00 27.24           C  
ATOM   1570  ND1 HIS A 206       7.344  40.415  64.683  1.00 29.44           N  
ATOM   1571  CD2 HIS A 206       6.218  41.199  62.986  1.00 25.86           C  
ATOM   1572  CE1 HIS A 206       8.226  40.812  63.783  1.00 29.32           C  
ATOM   1573  NE2 HIS A 206       7.568  41.292  62.744  1.00 30.39           N  
ATOM   1574  N   TYR A 207       3.004  41.577  67.846  1.00 23.39           N  
ATOM   1575  CA  TYR A 207       1.777  41.440  68.626  1.00 23.82           C  
ATOM   1576  C   TYR A 207       1.013  42.768  68.462  1.00 25.31           C  
ATOM   1577  O   TYR A 207       1.120  43.646  69.319  1.00 24.68           O  
ATOM   1578  CB  TYR A 207       2.091  41.255  70.115  1.00 20.48           C  
ATOM   1579  CG  TYR A 207       2.392  39.843  70.563  1.00 20.82           C  
ATOM   1580  CD1 TYR A 207       3.238  39.614  71.647  1.00 20.15           C  
ATOM   1581  CD2 TYR A 207       1.778  38.742  69.968  1.00 18.09           C  
ATOM   1582  CE1 TYR A 207       3.467  38.328  72.133  1.00 19.34           C  
ATOM   1583  CE2 TYR A 207       1.997  37.449  70.451  1.00 20.40           C  
ATOM   1584  CZ  TYR A 207       2.846  37.252  71.539  1.00 20.71           C  
ATOM   1585  OH  TYR A 207       3.067  35.986  72.050  1.00 19.72           O  
ATOM   1586  N   THR A 208       0.281  42.938  67.363  1.00 26.70           N  
ATOM   1587  CA  THR A 208      -0.493  44.169  67.155  1.00 27.98           C  
ATOM   1588  C   THR A 208      -1.973  43.828  67.200  1.00 28.42           C  
ATOM   1589  O   THR A 208      -2.347  42.662  67.033  1.00 29.34           O  
ATOM   1590  CB  THR A 208      -0.211  44.824  65.794  1.00 28.08           C  
ATOM   1591  OG1 THR A 208      -0.544  43.908  64.742  1.00 31.33           O  
ATOM   1592  CG2 THR A 208       1.236  45.224  65.686  1.00 27.98           C  
ATOM   1593  N   LEU A 209      -2.815  44.835  67.433  1.00 28.45           N  
ATOM   1594  CA  LEU A 209      -4.254  44.602  67.496  1.00 28.55           C  
ATOM   1595  C   LEU A 209      -4.731  44.018  66.177  1.00 29.82           C  
ATOM   1596  O   LEU A 209      -5.577  43.120  66.152  1.00 29.46           O  
ATOM   1597  CB  LEU A 209      -5.012  45.904  67.782  1.00 26.37           C  
ATOM   1598  CG  LEU A 209      -6.548  45.793  67.867  1.00 27.20           C  
ATOM   1599  CD1 LEU A 209      -6.944  44.603  68.732  1.00 21.84           C  
ATOM   1600  CD2 LEU A 209      -7.133  47.092  68.434  1.00 22.91           C  
ATOM   1601  N   GLU A 210      -4.174  44.520  65.082  1.00 30.54           N  
ATOM   1602  CA  GLU A 210      -4.553  44.047  63.762  1.00 31.86           C  
ATOM   1603  C   GLU A 210      -4.186  42.578  63.597  1.00 29.81           C  
ATOM   1604  O   GLU A 210      -5.001  41.789  63.129  1.00 30.25           O  
ATOM   1605  CB  GLU A 210      -3.882  44.895  62.674  1.00 36.85           C  
ATOM   1606  CG  GLU A 210      -4.417  44.602  61.275  1.00 45.34           C  
ATOM   1607  CD  GLU A 210      -3.963  45.612  60.226  1.00 50.15           C  
ATOM   1608  OE1 GLU A 210      -2.781  45.557  59.804  1.00 52.42           O  
ATOM   1609  OE2 GLU A 210      -4.795  46.466  59.828  1.00 52.56           O  
ATOM   1610  N   PHE A 211      -2.974  42.204  63.992  1.00 26.95           N  
ATOM   1611  CA  PHE A 211      -2.552  40.811  63.870  1.00 25.34           C  
ATOM   1612  C   PHE A 211      -3.419  39.922  64.757  1.00 23.24           C  
ATOM   1613  O   PHE A 211      -3.881  38.873  64.319  1.00 22.41           O  
ATOM   1614  CB  PHE A 211      -1.076  40.627  64.264  1.00 22.95           C  
ATOM   1615  CG  PHE A 211      -0.569  39.203  64.087  1.00 22.60           C  
ATOM   1616  CD1 PHE A 211      -0.212  38.724  62.824  1.00 21.62           C  
ATOM   1617  CD2 PHE A 211      -0.479  38.337  65.173  1.00 20.05           C  
ATOM   1618  CE1 PHE A 211       0.228  37.400  62.648  1.00 21.47           C  
ATOM   1619  CE2 PHE A 211      -0.042  37.014  65.012  1.00 19.84           C  
ATOM   1620  CZ  PHE A 211       0.313  36.543  63.742  1.00 20.96           C  
ATOM   1621  N   LEU A 212      -3.645  40.333  66.002  1.00 21.86           N  
ATOM   1622  CA  LEU A 212      -4.468  39.516  66.888  1.00 23.97           C  
ATOM   1623  C   LEU A 212      -5.852  39.255  66.295  1.00 24.30           C  
ATOM   1624  O   LEU A 212      -6.334  38.127  66.332  1.00 22.11           O  
ATOM   1625  CB  LEU A 212      -4.633  40.159  68.271  1.00 22.60           C  
ATOM   1626  CG  LEU A 212      -3.421  40.347  69.181  1.00 24.79           C  
ATOM   1627  CD1 LEU A 212      -3.869  40.159  70.631  1.00 22.58           C  
ATOM   1628  CD2 LEU A 212      -2.335  39.362  68.845  1.00 23.76           C  
ATOM   1629  N   LYS A 213      -6.481  40.295  65.749  1.00 25.88           N  
ATOM   1630  CA  LYS A 213      -7.803  40.158  65.143  1.00 30.27           C  
ATOM   1631  C   LYS A 213      -7.803  39.169  63.978  1.00 30.91           C  
ATOM   1632  O   LYS A 213      -8.644  38.280  63.919  1.00 30.43           O  
ATOM   1633  CB  LYS A 213      -8.322  41.515  64.655  1.00 31.13           C  
ATOM   1634  CG  LYS A 213      -8.733  42.455  65.774  1.00 33.99           C  
ATOM   1635  CD  LYS A 213      -9.317  43.747  65.227  1.00 38.24           C  
ATOM   1636  CE  LYS A 213      -9.981  44.574  66.327  1.00 40.76           C  
ATOM   1637  NZ  LYS A 213     -10.691  45.772  65.779  1.00 42.58           N  
ATOM   1638  N   GLU A 214      -6.855  39.321  63.060  1.00 32.86           N  
ATOM   1639  CA  GLU A 214      -6.776  38.428  61.912  1.00 32.86           C  
ATOM   1640  C   GLU A 214      -6.587  36.976  62.355  1.00 32.75           C  
ATOM   1641  O   GLU A 214      -7.130  36.065  61.740  1.00 33.19           O  
ATOM   1642  CB  GLU A 214      -5.630  38.863  60.997  1.00 35.55           C  
ATOM   1643  CG  GLU A 214      -5.596  38.160  59.648  1.00 41.05           C  
ATOM   1644  CD  GLU A 214      -6.889  38.332  58.849  1.00 44.32           C  
ATOM   1645  OE1 GLU A 214      -7.345  39.487  58.673  1.00 44.17           O  
ATOM   1646  OE2 GLU A 214      -7.445  37.305  58.393  1.00 46.81           O  
ATOM   1647  N   VAL A 215      -5.825  36.761  63.428  1.00 32.42           N  
ATOM   1648  CA  VAL A 215      -5.592  35.409  63.938  1.00 31.30           C  
ATOM   1649  C   VAL A 215      -6.874  34.858  64.549  1.00 32.42           C  
ATOM   1650  O   VAL A 215      -7.184  33.676  64.410  1.00 31.55           O  
ATOM   1651  CB  VAL A 215      -4.482  35.385  65.019  1.00 31.27           C  
ATOM   1652  CG1 VAL A 215      -4.427  34.018  65.695  1.00 29.17           C  
ATOM   1653  CG2 VAL A 215      -3.144  35.697  64.393  1.00 29.16           C  
ATOM   1654  N   TRP A 216      -7.619  35.724  65.230  1.00 33.56           N  
ATOM   1655  CA  TRP A 216      -8.876  35.327  65.861  1.00 34.71           C  
ATOM   1656  C   TRP A 216      -9.908  34.958  64.796  1.00 35.66           C  
ATOM   1657  O   TRP A 216     -10.703  34.033  64.981  1.00 32.07           O  
ATOM   1658  CB  TRP A 216      -9.403  36.463  66.749  1.00 29.68           C  
ATOM   1659  CG  TRP A 216     -10.668  36.141  67.469  1.00 27.72           C  
ATOM   1660  CD1 TRP A 216     -11.936  36.427  67.058  1.00 26.21           C  
ATOM   1661  CD2 TRP A 216     -10.796  35.469  68.732  1.00 26.25           C  
ATOM   1662  NE1 TRP A 216     -12.848  35.975  67.986  1.00 26.87           N  
ATOM   1663  CE2 TRP A 216     -12.177  35.383  69.022  1.00 25.61           C  
ATOM   1664  CE3 TRP A 216      -9.880  34.931  69.646  1.00 25.46           C  
ATOM   1665  CZ2 TRP A 216     -12.668  34.779  70.190  1.00 25.08           C  
ATOM   1666  CZ3 TRP A 216     -10.366  34.330  70.809  1.00 26.63           C  
ATOM   1667  CH2 TRP A 216     -11.753  34.259  71.069  1.00 26.37           C  
ATOM   1668  N   LEU A 217      -9.890  35.690  63.683  1.00 39.44           N  
ATOM   1669  CA  LEU A 217     -10.809  35.419  62.580  1.00 43.44           C  
ATOM   1670  C   LEU A 217     -10.487  34.061  61.990  1.00 45.32           C  
ATOM   1671  O   LEU A 217     -11.341  33.186  61.928  1.00 45.67           O  
ATOM   1672  CB  LEU A 217     -10.681  36.478  61.481  1.00 43.47           C  
ATOM   1673  CG  LEU A 217     -11.390  37.815  61.701  1.00 45.08           C  
ATOM   1674  CD1 LEU A 217     -11.168  38.707  60.487  1.00 46.69           C  
ATOM   1675  CD2 LEU A 217     -12.875  37.582  61.915  1.00 44.56           C  
ATOM   1676  N   GLN A 218      -9.236  33.899  61.573  1.00 50.08           N  
ATOM   1677  CA  GLN A 218      -8.767  32.661  60.974  1.00 55.61           C  
ATOM   1678  C   GLN A 218      -8.809  31.464  61.916  1.00 59.64           C  
ATOM   1679  O   GLN A 218      -8.398  30.368  61.548  1.00 59.27           O  
ATOM   1680  CB  GLN A 218      -7.354  32.864  60.428  1.00 56.34           C  
ATOM   1681  CG  GLN A 218      -7.323  33.749  59.184  1.00 58.93           C  
ATOM   1682  CD  GLN A 218      -5.915  34.108  58.736  1.00 60.67           C  
ATOM   1683  OE1 GLN A 218      -5.024  33.258  58.699  1.00 61.82           O  
ATOM   1684  NE2 GLN A 218      -5.713  35.371  58.377  1.00 61.07           N  
ATOM   1685  N   LYS A 219      -9.305  31.681  63.129  1.00 64.61           N  
ATOM   1686  CA  LYS A 219      -9.434  30.617  64.119  1.00 71.04           C  
ATOM   1687  C   LYS A 219     -10.830  30.024  63.996  1.00 76.80           C  
ATOM   1688  O   LYS A 219     -11.019  28.811  64.123  1.00 76.57           O  
ATOM   1689  CB  LYS A 219      -9.266  31.171  65.536  1.00 69.75           C  
ATOM   1690  CG  LYS A 219      -9.826  30.250  66.622  1.00 69.53           C  
ATOM   1691  CD  LYS A 219      -9.910  30.929  67.990  1.00 68.01           C  
ATOM   1692  CE  LYS A 219     -10.882  32.112  68.002  1.00 66.59           C  
ATOM   1693  NZ  LYS A 219     -12.309  31.723  67.843  1.00 63.92           N  
ATOM   1694  N   GLN A 220     -11.799  30.906  63.754  1.00 82.27           N  
ATOM   1695  CA  GLN A 220     -13.206  30.541  63.619  1.00 88.63           C  
ATOM   1696  C   GLN A 220     -13.431  29.365  62.669  1.00 91.50           C  
ATOM   1697  O   GLN A 220     -13.662  29.545  61.468  1.00 92.33           O  
ATOM   1698  CB  GLN A 220     -14.013  31.753  63.148  1.00 89.98           C  
ATOM   1699  CG  GLN A 220     -15.507  31.498  63.040  1.00 93.41           C  
ATOM   1700  CD  GLN A 220     -16.037  31.737  61.641  1.00 94.89           C  
ATOM   1701  OE1 GLN A 220     -15.628  31.077  60.684  1.00 94.77           O  
ATOM   1702  NE2 GLN A 220     -16.952  32.689  61.514  1.00 95.81           N  
ATOM   1703  N   LYS A 221     -13.368  28.160  63.230  1.00 93.99           N  
ATOM   1704  CA  LYS A 221     -13.554  26.932  62.471  1.00 95.47           C  
ATOM   1705  C   LYS A 221     -13.636  25.778  63.466  1.00 95.86           C  
ATOM   1706  O   LYS A 221     -14.731  25.189  63.593  1.00 95.63           O  
ATOM   1707  CB  LYS A 221     -12.368  26.717  61.525  1.00 96.67           C  
ATOM   1708  CG  LYS A 221     -12.743  26.264  60.121  1.00 97.92           C  
ATOM   1709  CD  LYS A 221     -13.540  27.335  59.389  1.00 98.70           C  
ATOM   1710  CE  LYS A 221     -13.655  27.020  57.906  1.00 99.25           C  
ATOM   1711  NZ  LYS A 221     -14.250  25.678  57.661  1.00 99.94           N  
ATOM   1712  OXT LYS A 221     -12.607  25.489  64.116  1.00 96.95           O  
TER    1713      LYS A 221                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
