
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  217 ( 1714),  selected  217 , name 2nyv_A
# Molecule2: number of CA atoms  210 ( 1658),  selected  210 , name T0418.pdb
# PARAMETERS: 2nyv_A.T0418.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    S     2_A      K       2          1.473
LGA    L     3_A      Y       3          1.440
LGA    R     4_A      T       4          1.255
LGA    V     5_A      V       5          0.528
LGA    I     6_A      Y       6          0.612
LGA    L     7_A      L       7          0.460
LGA    F     8_A      F       8          0.333
LGA    D     9_A      D       9          0.407
LGA    L    10_A      F      10          0.518
LGA    D    11_A      D      11          0.527
LGA    G    12_A      Y      12          0.794
LGA    T    13_A      T      13          0.445
LGA    L    14_A      L      14          0.489
LGA    I    15_A      A      15          0.712
LGA    D    16_A      D      16          0.480
LGA    S    17_A      S      17          0.706
LGA    A    18_A      S      18          0.694
LGA    K    19_A      R      19          0.449
LGA    D    20_A      G      20          0.406
LGA    I    21_A      I      21          0.616
LGA    A    22_A      V      22          1.334
LGA    L    23_A      T      23          1.481
LGA    A    24_A      C      24          1.196
LGA    L    25_A      F      25          1.658
LGA    E    26_A      R      26          2.750
LGA    K    27_A      S      27          2.721
LGA    T    28_A      V      28          1.974
LGA    L    29_A      L      29          3.113
LGA    K    30_A      E      30          4.727
LGA    E    31_A      -       -           -
LGA    L    32_A      -       -           -
LGA    G    33_A      R      31          2.693
LGA    L    34_A      H      32          2.085
LGA    E    35_A      G      33          4.244
LGA    E    36_A      Y      34          3.313
LGA    Y    37_A      T      35          3.312
LGA    Y    38_A      G      36          5.511
LGA    P    39_A      I      37          1.569
LGA    D    40_A      T      38          1.016
LGA    N    41_A      D      39          2.539
LGA    -       -      D      40           -
LGA    -       -      M      41           -
LGA    V    42_A      I      42          2.487
LGA    T    43_A      K      43          1.354
LGA    K    44_A      R      44          1.674
LGA    Y    45_A      T      45          1.924
LGA    I    46_A      I      46          1.006
LGA    G    47_A      G      47          1.717
LGA    G    48_A      K      48          0.978
LGA    G    49_A      T      49          2.347
LGA    V    50_A      L      50          1.438
LGA    R    51_A      E      51          1.648
LGA    A    52_A      E      52          1.669
LGA    L    53_A      S      53          1.447
LGA    L    54_A      F      54          1.156
LGA    E    55_A      S      55          1.209
LGA    K    56_A      I      56          1.419
LGA    V    57_A      L      57          1.522
LGA    L    58_A      T      58          1.512
LGA    K    59_A      G      59          1.442
LGA    D    60_A      I      60          3.441
LGA    K    61_A      T      61           -
LGA    -       -      D      62           -
LGA    -       -      A      63           -
LGA    -       -      D      64           -
LGA    F    62_A      Q      65           #
LGA    R    63_A      L      66          2.980
LGA    E    64_A      E      67          2.720
LGA    E    65_A      S      68          1.755
LGA    Y    66_A      F      69          1.006
LGA    V    67_A      R      70          0.917
LGA    E    68_A      Q      71          1.395
LGA    V    69_A      E      72          1.170
LGA    F    70_A      Y      73          0.509
LGA    R    71_A      S      74          1.259
LGA    K    72_A      K      75          1.760
LGA    H    73_A      E      76          1.212
LGA    Y    74_A      A      77          0.493
LGA    L    75_A      D      78          1.559
LGA    E    76_A      I      79          2.155
LGA    N    77_A      Y      80          2.378
LGA    P    78_A      M      81          2.614
LGA    V    79_A      N      82          1.857
LGA    V    80_A      A      83          2.314
LGA    Y    81_A      N      84          2.622
LGA    T    82_A      T      85          1.209
LGA    K    83_A      I      86          0.733
LGA    P    84_A      L      87          1.165
LGA    Y    85_A      F      88          1.069
LGA    P    86_A      P      89          1.137
LGA    E    87_A      D      90          0.921
LGA    I    88_A      T      91          0.979
LGA    P    89_A      L      92          0.775
LGA    Y    90_A      P      93          0.730
LGA    T    91_A      T      94          0.474
LGA    L    92_A      L      95          0.564
LGA    E    93_A      T      96          0.527
LGA    A    94_A      H      97          0.467
LGA    L    95_A      L      98          0.580
LGA    K    96_A      K      99          0.830
LGA    S    97_A      K     100          0.737
LGA    K    98_A      Q     101          0.426
LGA    G    99_A      G     102          0.487
LGA    F   100_A      I     103          0.685
LGA    K   101_A      R     104          0.541
LGA    L   102_A      I     105          0.411
LGA    A   103_A      G     106          0.427
LGA    V   104_A      I     107          0.498
LGA    V   105_A      I     108          0.337
LGA    S   106_A      S     109          0.876
LGA    N   107_A      T     110          0.717
LGA    K   108_A      K     111          0.754
LGA    L   109_A      Y     112          1.343
LGA    E   110_A      R     113          1.565
LGA    E   111_A      F     114          1.431
LGA    L   112_A      R     115          1.166
LGA    S   113_A      I     116          1.718
LGA    K   114_A      L     117          1.524
LGA    K   115_A      S     118          1.429
LGA    I   116_A      F     119          1.679
LGA    L   117_A      L     120          1.952
LGA    D   118_A      R     121          1.780
LGA    I   119_A      N     122          2.775
LGA    L   120_A      H     123          2.192
LGA    N   121_A      M     124          2.726
LGA    L   122_A      P     125          5.182
LGA    S   123_A      D     126          4.890
LGA    G   124_A      D     127          2.457
LGA    Y   125_A      W     128          1.888
LGA    F   126_A      F     129          0.851
LGA    D   127_A      D     130          1.120
LGA    L   128_A      I     131          1.342
LGA    I   129_A      I     132          1.282
LGA    V   130_A      I     133          0.983
LGA    G   131_A      G     134          0.729
LGA    G   132_A      G     135          1.451
LGA    D   133_A      E     136          1.538
LGA    T   134_A      D     137          0.546
LGA    F   135_A      V     138          2.761
LGA    G   136_A      T     139          2.455
LGA    E   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    K   139_A      H     140          2.863
LGA    P   140_A      H     141           #
LGA    -       -      K     142           -
LGA    -       -      P     143           -
LGA    S   141_A      D     144          1.718
LGA    P   142_A      P     145          0.820
LGA    T   143_A      E     146          1.406
LGA    P   144_A      G     147          0.729
LGA    V   145_A      L     148          0.642
LGA    L   146_A      L     149          0.771
LGA    K   147_A      L     150          0.830
LGA    T   148_A      A     151          0.435
LGA    L   149_A      I     152          0.822
LGA    E   150_A      D     153          0.867
LGA    I   151_A      R     154          0.631
LGA    L   152_A      L     155          0.924
LGA    G   153_A      K     156          1.304
LGA    E   154_A      A     157          0.574
LGA    E   155_A      C     158          0.971
LGA    P   156_A      P     159          0.822
LGA    E   157_A      E     160          0.902
LGA    K   158_A      E     161          0.609
LGA    A   159_A      V     162          0.189
LGA    L   160_A      L     163          0.237
LGA    I   161_A      Y     164          0.101
LGA    V   162_A      I     165          0.069
LGA    G   163_A      G     166          0.228
LGA    D   164_A      D     167          0.823
LGA    T   165_A      S     168          1.002
LGA    D   166_A      T     169          1.325
LGA    A   167_A      V     170          1.777
LGA    D   168_A      D     171          1.009
LGA    I   169_A      A     172          1.380
LGA    E   170_A      G     173          1.681
LGA    A   171_A      T     174          1.534
LGA    G   172_A      A     175          1.143
LGA    K   173_A      A     176          1.599
LGA    R   174_A      A     177          1.945
LGA    A   175_A      A     178          1.555
LGA    G   176_A      G     179          1.601
LGA    T   177_A      V     180          1.180
LGA    K   178_A      S     181          1.128
LGA    T   179_A      F     182          0.778
LGA    A   180_A      T     183          0.244
LGA    L   181_A      G     184          0.264
LGA    A   182_A      V     185          0.736
LGA    L   183_A      T     186          1.383
LGA    W   184_A      S     187          2.025
LGA    G   185_A      G     188          2.047
LGA    Y   186_A      M     189          2.375
LGA    V   187_A      T     190          1.676
LGA    K   188_A      T     191          3.239
LGA    L   189_A      A     192          5.626
LGA    -       -      Q     193           -
LGA    N   190_A      E     194          1.595
LGA    S   191_A      F     195          3.640
LGA    Q   192_A      Q     196          3.857
LGA    -       -      A     197           -
LGA    -       -      Y     198           -
LGA    I   193_A      P     199          3.272
LGA    P   194_A      Y     200          0.460
LGA    D   195_A      D     201          1.059
LGA    F   196_A      R     202          1.596
LGA    T   197_A      I     203          1.368
LGA    L   198_A      I     204          1.426
LGA    S   199_A      S     205          1.374
LGA    R   200_A      T     206          1.117
LGA    P   201_A      L     207          1.072
LGA    S   202_A      G     208          1.095
LGA    D   203_A      Q     209          0.714
LGA    L   204_A      L     210          0.880
LGA    V   205_A      I     211          0.886
LGA    K   206_A      -       -           -
LGA    L   207_A      -       -           -
LGA    X   208_A      -       -           -
LGA    D   209_A      -       -           -
LGA    N   210_A      -       -           -
LGA    H   211_A      -       -           -
LGA    I   212_A      -       -           -
LGA    V   213_A      -       -           -
LGA    E   214_A      -       -           -
LGA    F   215_A      -       -           -
LGA    E   216_A      -       -           -
LGA    G   217_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  217  210    5.0    197    1.75    23.35     85.647    10.639

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.768776 * X  +   0.637119 * Y  +   0.055339 * Z  +  -7.730193
  Y_new =  -0.639055 * X  +   0.762050 * Y  +   0.104347 * Z  +  22.896236
  Z_new =   0.024310 * X  +  -0.115584 * Y  +   0.993000 * Z  +  83.635056 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.115877    3.025716  [ DEG:    -6.6393    173.3607 ]
  Theta =  -0.024313   -3.117280  [ DEG:    -1.3930   -178.6070 ]
  Phi   =  -0.693515    2.448077  [ DEG:   -39.7355    140.2645 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nyv_A                                        
REMARK     2: T0418.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nyv_A.T0418.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  217  210   5.0  197   1.75   23.35  85.647
REMARK  ---------------------------------------------------------- 
MOLECULE 2nyv_A
HEADER    HYDROLASE                               21-NOV-06   2NYV              
TITLE     X-RAY CRYSTAL STRUCTURE OF A PHOSPHOGLYCOLATE PHOSPHATASE             
TITLE    2 FROM AQUIFEX AEOLICUS                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCOLATE PHOSPHATASE;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PGPASE, PGP;                                                
COMPND   5 EC: 3.1.3.18;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: GPH;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: BC PSGX3(BC)                              
KEYWDS    PHOSPHATASE, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE            
KEYWDS   2 INITIATIVE, NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM,         
KEYWDS   3 NYSGXRC                                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CIATTO,T.MIN,J.GORMAN,S.K.BURLEY,L.SHAPIRO,NEW YORK                 
AUTHOR   2 STRUCTURAL GENOMIX RESEARCH CONSORTIUM (NYSGXRC)                     
REVDAT   1   05-DEC-06 2NYV    0                                                
JRNL        AUTH   C.CIATTO,T.MIN,J.GORMAN,S.K.BURLEY,L.SHAPIRO                 
JRNL        TITL   X-RAY CRYSTAL STRUCTURE OF A PHOSPHOGLYCOLATE                
JRNL        TITL 2 PHOSPHATASE FROM AQUIFEX AEOLICUS                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2NYV A    4   215  UNP    O67359   GPH_AQUAE        2    213             
SEQRES   1 A  222  MSE SER LEU ARG VAL ILE LEU PHE ASP LEU ASP GLY THR          
SEQRES   2 A  222  LEU ILE ASP SER ALA LYS ASP ILE ALA LEU ALA LEU GLU          
SEQRES   3 A  222  LYS THR LEU LYS GLU LEU GLY LEU GLU GLU TYR TYR PRO          
SEQRES   4 A  222  ASP ASN VAL THR LYS TYR ILE GLY GLY GLY VAL ARG ALA          
SEQRES   5 A  222  LEU LEU GLU LYS VAL LEU LYS ASP LYS PHE ARG GLU GLU          
SEQRES   6 A  222  TYR VAL GLU VAL PHE ARG LYS HIS TYR LEU GLU ASN PRO          
SEQRES   7 A  222  VAL VAL TYR THR LYS PRO TYR PRO GLU ILE PRO TYR THR          
SEQRES   8 A  222  LEU GLU ALA LEU LYS SER LYS GLY PHE LYS LEU ALA VAL          
SEQRES   9 A  222  VAL SER ASN LYS LEU GLU GLU LEU SER LYS LYS ILE LEU          
SEQRES  10 A  222  ASP ILE LEU ASN LEU SER GLY TYR PHE ASP LEU ILE VAL          
SEQRES  11 A  222  GLY GLY ASP THR PHE GLY GLU LYS LYS PRO SER PRO THR          
SEQRES  12 A  222  PRO VAL LEU LYS THR LEU GLU ILE LEU GLY GLU GLU PRO          
SEQRES  13 A  222  GLU LYS ALA LEU ILE VAL GLY ASP THR ASP ALA ASP ILE          
SEQRES  14 A  222  GLU ALA GLY LYS ARG ALA GLY THR LYS THR ALA LEU ALA          
SEQRES  15 A  222  LEU TRP GLY TYR VAL LYS LEU ASN SER GLN ILE PRO ASP          
SEQRES  16 A  222  PHE THR LEU SER ARG PRO SER ASP LEU VAL LYS LEU MSE          
SEQRES  17 A  222  ASP ASN HIS ILE VAL GLU PHE GLU GLY HIS HIS HIS HIS          
SEQRES  18 A  222  HIS                                                          
HET    MSE  A   1       8                                                       
HET    MSE  A 208       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *236(H2 O)                                                    
CRYST1   63.084  121.698   74.474  90.00  90.00  90.00 C 2 2 21      8          
HETATM    1  N   MSE A   1     -12.059  35.781  64.352  1.00 17.90           N  
HETATM    2  CA  MSE A   1     -12.015  35.197  65.702  1.00 17.93           C  
HETATM    3  C   MSE A   1     -12.273  36.268  66.745  1.00 16.95           C  
HETATM    4  O   MSE A   1     -11.525  37.258  66.822  1.00 16.83           O  
HETATM    5  CB  MSE A   1     -10.663  34.562  65.980  1.00 18.94           C  
HETATM    6  CG  MSE A   1     -10.649  33.879  67.306  1.00 18.94           C  
HETATM    7 SE   MSE A   1      -8.879  33.086  67.700  1.00 24.02          SE  
HETATM    8  CE  MSE A   1      -8.679  31.560  66.210  1.00 13.49           C  
ATOM      9  N   SER A   2     -13.347  36.074  67.521  1.00 18.01           N  
ATOM     10  CA  SER A   2     -13.873  37.094  68.445  1.00 15.58           C  
ATOM     11  C   SER A   2     -13.326  36.906  69.858  1.00 14.08           C  
ATOM     12  O   SER A   2     -13.441  35.832  70.433  1.00 13.43           O  
ATOM     13  CB  SER A   2     -15.392  37.043  68.418  1.00 18.25           C  
ATOM     14  OG  SER A   2     -15.886  37.305  67.084  1.00 19.78           O  
ATOM     15  N   LEU A   3     -12.716  37.939  70.413  1.00 12.80           N  
ATOM     16  CA  LEU A   3     -12.063  37.813  71.737  1.00 12.03           C  
ATOM     17  C   LEU A   3     -12.374  38.989  72.631  1.00 10.06           C  
ATOM     18  O   LEU A   3     -12.692  40.050  72.148  1.00 10.70           O  
ATOM     19  CB  LEU A   3     -10.546  37.687  71.576  1.00 10.35           C  
ATOM     20  CG  LEU A   3     -10.067  36.354  70.973  1.00 12.02           C  
ATOM     21  CD1 LEU A   3      -8.682  36.495  70.520  1.00 10.44           C  
ATOM     22  CD2 LEU A   3     -10.178  35.205  72.021  1.00 10.67           C  
ATOM     23  N   ARG A   4     -12.238  38.818  73.934  1.00  8.12           N  
ATOM     24  CA  ARG A   4     -12.504  39.922  74.819  1.00  8.05           C  
ATOM     25  C   ARG A   4     -11.347  40.304  75.767  1.00  8.26           C  
ATOM     26  O   ARG A   4     -11.277  41.444  76.263  1.00  6.72           O  
ATOM     27  CB  ARG A   4     -13.781  39.611  75.588  1.00 11.05           C  
ATOM     28  CG  ARG A   4     -15.032  39.609  74.650  1.00 13.45           C  
ATOM     29  CD  ARG A   4     -16.350  39.658  75.346  1.00 14.74           C  
ATOM     30  NE  ARG A   4     -16.362  40.473  76.571  1.00 15.12           N  
ATOM     31  CZ  ARG A   4     -16.684  41.768  76.640  1.00 15.07           C  
ATOM     32  NH1 ARG A   4     -16.985  42.502  75.556  1.00 15.28           N  
ATOM     33  NH2 ARG A   4     -16.644  42.355  77.824  1.00 15.34           N  
ATOM     34  N   VAL A   5     -10.436  39.345  75.985  1.00  6.65           N  
ATOM     35  CA  VAL A   5      -9.433  39.442  77.010  1.00  5.42           C  
ATOM     36  C   VAL A   5      -8.163  38.761  76.531  1.00  5.05           C  
ATOM     37  O   VAL A   5      -8.222  37.707  75.855  1.00  4.64           O  
ATOM     38  CB  VAL A   5      -9.939  38.862  78.353  1.00  6.46           C  
ATOM     39  CG1 VAL A   5     -10.355  37.481  78.202  1.00  7.06           C  
ATOM     40  CG2 VAL A   5      -8.866  38.916  79.414  1.00  6.50           C  
ATOM     41  N   ILE A   6      -7.036  39.422  76.825  1.00  4.04           N  
ATOM     42  CA  ILE A   6      -5.695  38.924  76.523  1.00  3.46           C  
ATOM     43  C   ILE A   6      -4.855  38.827  77.770  1.00  3.01           C  
ATOM     44  O   ILE A   6      -4.696  39.788  78.505  1.00  3.26           O  
ATOM     45  CB  ILE A   6      -5.014  39.816  75.508  1.00  3.13           C  
ATOM     46  CG1 ILE A   6      -5.913  39.886  74.279  1.00  4.21           C  
ATOM     47  CG2 ILE A   6      -3.622  39.225  75.144  1.00  3.16           C  
ATOM     48  CD1 ILE A   6      -5.604  40.994  73.399  1.00  5.83           C  
ATOM     49  N   LEU A   7      -4.372  37.629  78.052  1.00  3.17           N  
ATOM     50  CA  LEU A   7      -3.536  37.375  79.235  1.00  2.63           C  
ATOM     51  C   LEU A   7      -2.083  37.111  78.819  1.00  3.54           C  
ATOM     52  O   LEU A   7      -1.830  36.193  78.029  1.00  2.09           O  
ATOM     53  CB  LEU A   7      -3.998  36.133  79.936  1.00  2.89           C  
ATOM     54  CG  LEU A   7      -5.490  35.879  80.205  1.00  4.57           C  
ATOM     55  CD1 LEU A   7      -5.627  34.656  81.157  1.00  3.37           C  
ATOM     56  CD2 LEU A   7      -6.013  37.120  80.888  1.00  3.67           C  
ATOM     57  N   PHE A   8      -1.150  37.839  79.411  1.00  2.10           N  
ATOM     58  CA  PHE A   8       0.279  37.775  79.062  1.00  2.47           C  
ATOM     59  C   PHE A   8       1.097  37.099  80.188  1.00  3.01           C  
ATOM     60  O   PHE A   8       0.906  37.422  81.359  1.00  2.06           O  
ATOM     61  CB  PHE A   8       0.824  39.194  78.897  1.00  1.70           C  
ATOM     62  CG  PHE A   8       0.273  39.928  77.738  1.00  2.69           C  
ATOM     63  CD1 PHE A   8       0.904  39.876  76.500  1.00  1.85           C  
ATOM     64  CD2 PHE A   8      -0.875  40.700  77.871  1.00  2.12           C  
ATOM     65  CE1 PHE A   8       0.385  40.572  75.412  1.00  2.51           C  
ATOM     66  CE2 PHE A   8      -1.403  41.395  76.768  1.00  2.39           C  
ATOM     67  CZ  PHE A   8      -0.750  41.336  75.549  1.00  1.72           C  
ATOM     68  N   ASP A   9       2.009  36.200  79.855  1.00  2.84           N  
ATOM     69  CA  ASP A   9       3.078  35.851  80.774  1.00  3.15           C  
ATOM     70  C   ASP A   9       3.941  37.130  80.969  1.00  2.96           C  
ATOM     71  O   ASP A   9       3.815  38.100  80.216  1.00  3.22           O  
ATOM     72  CB  ASP A   9       3.899  34.727  80.187  1.00  4.49           C  
ATOM     73  CG  ASP A   9       4.781  34.045  81.219  1.00  5.71           C  
ATOM     74  OD1 ASP A   9       4.900  34.598  82.348  1.00  4.90           O  
ATOM     75  OD2 ASP A   9       5.435  33.001  80.855  1.00  7.61           O  
ATOM     76  N   LEU A  10       4.841  37.136  81.932  1.00  3.79           N  
ATOM     77  CA  LEU A  10       5.647  38.330  82.220  1.00  3.50           C  
ATOM     78  C   LEU A  10       7.097  38.231  81.683  1.00  3.10           C  
ATOM     79  O   LEU A  10       7.421  38.834  80.684  1.00  2.12           O  
ATOM     80  CB  LEU A  10       5.605  38.618  83.726  1.00  3.46           C  
ATOM     81  CG  LEU A  10       6.201  39.919  84.278  1.00  3.51           C  
ATOM     82  CD1 LEU A  10       5.504  41.074  83.653  1.00  2.99           C  
ATOM     83  CD2 LEU A  10       6.004  40.010  85.744  1.00  3.36           C  
ATOM     84  N   ASP A  11       7.949  37.466  82.359  1.00  4.12           N  
ATOM     85  CA  ASP A  11       9.357  37.328  82.002  1.00  3.52           C  
ATOM     86  C   ASP A  11       9.425  36.701  80.625  1.00  4.57           C  
ATOM     87  O   ASP A  11       8.817  35.625  80.403  1.00  4.88           O  
ATOM     88  CB  ASP A  11      10.116  36.398  82.972  1.00  4.77           C  
ATOM     89  CG  ASP A  11      10.127  36.918  84.416  1.00  6.11           C  
ATOM     90  OD1 ASP A  11      10.456  38.102  84.632  1.00  6.86           O  
ATOM     91  OD2 ASP A  11       9.786  36.178  85.377  1.00  9.25           O  
ATOM     92  N   GLY A  12      10.148  37.328  79.689  1.00  3.40           N  
ATOM     93  CA  GLY A  12      10.337  36.697  78.418  1.00  3.54           C  
ATOM     94  C   GLY A  12       9.108  36.913  77.535  1.00  3.52           C  
ATOM     95  O   GLY A  12       9.068  36.416  76.422  1.00  3.56           O  
ATOM     96  N   THR A  13       8.125  37.669  78.019  1.00  2.84           N  
ATOM     97  CA  THR A  13       7.001  38.026  77.189  1.00  2.98           C  
ATOM     98  C   THR A  13       6.783  39.553  77.187  1.00  2.41           C  
ATOM     99  O   THR A  13       7.022  40.205  76.169  1.00  2.10           O  
ATOM    100  CB  THR A  13       5.743  37.202  77.558  1.00  3.34           C  
ATOM    101  OG1 THR A  13       6.032  35.823  77.276  1.00  3.75           O  
ATOM    102  CG2 THR A  13       4.509  37.639  76.751  1.00  2.61           C  
ATOM    103  N   LEU A  14       6.359  40.107  78.311  1.00  1.97           N  
ATOM    104  CA  LEU A  14       6.243  41.563  78.432  1.00  2.13           C  
ATOM    105  C   LEU A  14       7.615  42.182  78.753  1.00  3.00           C  
ATOM    106  O   LEU A  14       7.970  43.257  78.236  1.00  2.22           O  
ATOM    107  CB  LEU A  14       5.254  41.950  79.550  1.00  1.61           C  
ATOM    108  CG  LEU A  14       3.840  41.529  79.287  1.00  1.67           C  
ATOM    109  CD1 LEU A  14       3.070  41.693  80.504  1.00  2.22           C  
ATOM    110  CD2 LEU A  14       3.223  42.304  78.126  1.00  2.43           C  
ATOM    111  N   ILE A  15       8.401  41.533  79.585  1.00  1.81           N  
ATOM    112  CA  ILE A  15       9.659  42.187  80.000  1.00  2.52           C  
ATOM    113  C   ILE A  15      10.889  41.347  79.763  1.00  2.50           C  
ATOM    114  O   ILE A  15      10.846  40.141  79.907  1.00  2.09           O  
ATOM    115  CB  ILE A  15       9.650  42.590  81.495  1.00  1.61           C  
ATOM    116  CG1 ILE A  15       9.466  41.328  82.347  1.00  2.28           C  
ATOM    117  CG2 ILE A  15       8.578  43.639  81.734  1.00  1.61           C  
ATOM    118  CD1 ILE A  15       9.537  41.574  83.950  1.00  2.43           C  
ATOM    119  N   ASP A  16      11.988  42.027  79.466  1.00  2.27           N  
ATOM    120  CA  ASP A  16      13.258  41.370  79.256  1.00  2.82           C  
ATOM    121  C   ASP A  16      14.036  41.438  80.611  1.00  3.08           C  
ATOM    122  O   ASP A  16      14.813  42.360  80.833  1.00  3.26           O  
ATOM    123  CB  ASP A  16      14.033  42.088  78.177  1.00  2.84           C  
ATOM    124  CG  ASP A  16      15.304  41.304  77.730  1.00  5.30           C  
ATOM    125  OD1 ASP A  16      15.736  40.329  78.417  1.00  4.39           O  
ATOM    126  OD2 ASP A  16      15.874  41.677  76.663  1.00  6.88           O  
ATOM    127  N   SER A  17      13.777  40.492  81.494  1.00  2.40           N  
ATOM    128  CA  SER A  17      14.303  40.515  82.844  1.00  2.81           C  
ATOM    129  C   SER A  17      15.533  39.640  83.150  1.00  2.91           C  
ATOM    130  O   SER A  17      15.969  39.605  84.312  1.00  3.02           O  
ATOM    131  CB  SER A  17      13.214  40.052  83.795  1.00  2.83           C  
ATOM    132  OG  SER A  17      12.734  38.791  83.331  1.00  3.10           O  
ATOM    133  N   ALA A  18      16.061  38.926  82.173  1.00  3.03           N  
ATOM    134  CA  ALA A  18      17.101  37.923  82.437  1.00  3.21           C  
ATOM    135  C   ALA A  18      18.310  38.517  83.189  1.00  3.30           C  
ATOM    136  O   ALA A  18      18.882  37.844  84.038  1.00  2.75           O  
ATOM    137  CB  ALA A  18      17.562  37.260  81.162  1.00  4.66           C  
ATOM    138  N   LYS A  19      18.684  39.775  82.902  1.00  3.38           N  
ATOM    139  CA  LYS A  19      19.863  40.340  83.537  1.00  3.72           C  
ATOM    140  C   LYS A  19      19.612  40.618  85.007  1.00  3.60           C  
ATOM    141  O   LYS A  19      20.524  40.497  85.795  1.00  2.88           O  
ATOM    142  CB  LYS A  19      20.371  41.597  82.837  1.00  4.27           C  
ATOM    143  CG  LYS A  19      20.963  41.349  81.388  1.00  5.66           C  
ATOM    144  CD  LYS A  19      21.523  42.675  80.785  1.00  7.61           C  
ATOM    145  CE  LYS A  19      22.589  42.409  79.726  1.00  9.46           C  
ATOM    146  NZ  LYS A  19      22.214  41.205  78.860  1.00 11.35           N  
ATOM    147  N   ASP A  20      18.380  41.033  85.359  1.00  2.90           N  
ATOM    148  CA  ASP A  20      18.041  41.272  86.757  1.00  3.03           C  
ATOM    149  C   ASP A  20      17.818  39.947  87.543  1.00  3.22           C  
ATOM    150  O   ASP A  20      18.065  39.904  88.753  1.00  2.65           O  
ATOM    151  CB  ASP A  20      16.817  42.209  86.947  1.00  3.12           C  
ATOM    152  CG  ASP A  20      17.092  43.652  86.501  1.00  3.97           C  
ATOM    153  OD1 ASP A  20      18.262  44.038  86.395  1.00  4.36           O  
ATOM    154  OD2 ASP A  20      16.127  44.399  86.240  1.00  3.77           O  
ATOM    155  N   ILE A  21      17.320  38.916  86.877  1.00  2.55           N  
ATOM    156  CA  ILE A  21      17.288  37.572  87.452  1.00  2.65           C  
ATOM    157  C   ILE A  21      18.728  37.036  87.720  1.00  2.90           C  
ATOM    158  O   ILE A  21      19.049  36.434  88.787  1.00  2.35           O  
ATOM    159  CB  ILE A  21      16.508  36.643  86.520  1.00  2.82           C  
ATOM    160  CG1 ILE A  21      15.011  36.951  86.629  1.00  3.09           C  
ATOM    161  CG2 ILE A  21      16.828  35.167  86.774  1.00  2.91           C  
ATOM    162  CD1 ILE A  21      14.210  36.387  85.491  1.00  3.83           C  
ATOM    163  N   ALA A  22      19.615  37.268  86.761  1.00  2.24           N  
ATOM    164  CA  ALA A  22      21.024  36.907  86.936  1.00  3.26           C  
ATOM    165  C   ALA A  22      21.649  37.659  88.096  1.00  2.88           C  
ATOM    166  O   ALA A  22      22.429  37.104  88.850  1.00  2.74           O  
ATOM    167  CB  ALA A  22      21.819  37.167  85.637  1.00  3.18           C  
ATOM    168  N   LEU A  23      21.332  38.935  88.220  1.00  2.88           N  
ATOM    169  CA  LEU A  23      21.861  39.738  89.333  1.00  3.39           C  
ATOM    170  C   LEU A  23      21.388  39.177  90.704  1.00  3.26           C  
ATOM    171  O   LEU A  23      22.135  39.084  91.630  1.00  2.68           O  
ATOM    172  CB  LEU A  23      21.424  41.205  89.136  1.00  3.84           C  
ATOM    173  CG  LEU A  23      21.720  42.299  90.170  1.00  4.74           C  
ATOM    174  CD1 LEU A  23      23.175  42.704  90.068  1.00  6.41           C  
ATOM    175  CD2 LEU A  23      20.861  43.545  89.956  1.00  5.02           C  
ATOM    176  N   ALA A  24      20.125  38.785  90.803  1.00  2.67           N  
ATOM    177  CA  ALA A  24      19.609  38.192  92.021  1.00  2.87           C  
ATOM    178  C   ALA A  24      20.216  36.834  92.283  1.00  3.26           C  
ATOM    179  O   ALA A  24      20.524  36.531  93.408  1.00  2.30           O  
ATOM    180  CB  ALA A  24      18.151  38.072  91.968  1.00  3.32           C  
ATOM    181  N   LEU A  25      20.373  36.002  91.242  1.00  3.34           N  
ATOM    182  CA  LEU A  25      21.008  34.702  91.375  1.00  2.41           C  
ATOM    183  C   LEU A  25      22.451  34.849  91.901  1.00  3.10           C  
ATOM    184  O   LEU A  25      22.900  34.107  92.763  1.00  2.75           O  
ATOM    185  CB  LEU A  25      21.099  34.031  90.011  1.00  2.67           C  
ATOM    186  CG  LEU A  25      21.631  32.602  90.044  1.00  3.51           C  
ATOM    187  CD1 LEU A  25      20.835  31.847  91.104  1.00  3.19           C  
ATOM    188  CD2 LEU A  25      21.404  31.941  88.718  1.00  3.45           C  
ATOM    189  N   GLU A  26      23.178  35.783  91.322  1.00  2.81           N  
ATOM    190  CA  GLU A  26      24.497  36.089  91.777  1.00  3.36           C  
ATOM    191  C   GLU A  26      24.542  36.413  93.292  1.00  3.65           C  
ATOM    192  O   GLU A  26      25.332  35.788  94.042  1.00  3.40           O  
ATOM    193  CB  GLU A  26      25.075  37.212  90.947  1.00  3.68           C  
ATOM    194  CG  GLU A  26      26.465  37.545  91.262  1.00  4.64           C  
ATOM    195  CD  GLU A  26      26.569  38.801  92.071  1.00  6.43           C  
ATOM    196  OE1 GLU A  26      26.198  39.894  91.590  1.00  8.20           O  
ATOM    197  OE2 GLU A  26      27.004  38.712  93.227  1.00  9.59           O  
ATOM    198  N   LYS A  27      23.703  37.362  93.743  1.00  3.47           N  
ATOM    199  CA  LYS A  27      23.674  37.734  95.143  1.00  3.91           C  
ATOM    200  C   LYS A  27      23.242  36.532  95.997  1.00  3.29           C  
ATOM    201  O   LYS A  27      23.720  36.343  97.131  1.00  3.47           O  
ATOM    202  CB  LYS A  27      22.756  38.946  95.324  1.00  4.12           C  
ATOM    203  CG  LYS A  27      23.344  40.191  94.675  1.00  4.74           C  
ATOM    204  CD  LYS A  27      22.463  41.354  95.008  1.00  7.36           C  
ATOM    205  CE  LYS A  27      22.514  42.441  93.960  1.00  8.57           C  
ATOM    206  NZ  LYS A  27      21.368  43.308  94.274  1.00  9.57           N  
ATOM    207  N   THR A  28      22.395  35.681  95.428  1.00  2.56           N  
ATOM    208  CA  THR A  28      21.930  34.483  96.128  1.00  3.39           C  
ATOM    209  C   THR A  28      23.052  33.454  96.412  1.00  3.64           C  
ATOM    210  O   THR A  28      23.206  32.946  97.518  1.00  3.50           O  
ATOM    211  CB  THR A  28      20.716  33.838  95.385  1.00  3.50           C  
ATOM    212  OG1 THR A  28      19.605  34.724  95.486  1.00  3.12           O  
ATOM    213  CG2 THR A  28      20.333  32.465  95.968  1.00  3.37           C  
ATOM    214  N   LEU A  29      23.863  33.187  95.403  1.00  3.63           N  
ATOM    215  CA  LEU A  29      24.918  32.168  95.485  1.00  3.55           C  
ATOM    216  C   LEU A  29      26.043  32.674  96.383  1.00  4.02           C  
ATOM    217  O   LEU A  29      26.651  31.920  97.083  1.00  4.34           O  
ATOM    218  CB  LEU A  29      25.405  31.756  94.088  1.00  3.15           C  
ATOM    219  CG  LEU A  29      24.325  31.123  93.179  1.00  3.54           C  
ATOM    220  CD1 LEU A  29      24.844  30.704  91.828  1.00  3.20           C  
ATOM    221  CD2 LEU A  29      23.728  29.943  93.846  1.00  3.84           C  
ATOM    222  N   LYS A  30      26.284  33.965  96.370  1.00  4.36           N  
ATOM    223  CA  LYS A  30      27.225  34.580  97.285  1.00  4.76           C  
ATOM    224  C   LYS A  30      26.710  34.427  98.736  1.00  5.10           C  
ATOM    225  O   LYS A  30      27.405  33.865  99.555  1.00  4.92           O  
ATOM    226  CB  LYS A  30      27.419  36.043  96.940  1.00  5.52           C  
ATOM    227  CG  LYS A  30      28.239  36.864  97.954  1.00  6.60           C  
ATOM    228  CD  LYS A  30      28.236  38.286  97.378  1.00  9.15           C  
ATOM    229  CE  LYS A  30      29.347  39.139  97.837  1.00 12.37           C  
ATOM    230  NZ  LYS A  30      28.973  39.856  99.093  1.00 15.41           N  
ATOM    231  N   GLU A  31      25.485  34.870  99.033  1.00  4.72           N  
ATOM    232  CA  GLU A  31      24.915  34.619 100.366  1.00  5.08           C  
ATOM    233  C   GLU A  31      25.127  33.167 100.863  1.00  5.63           C  
ATOM    234  O   GLU A  31      25.573  32.927 102.000  1.00  5.10           O  
ATOM    235  CB  GLU A  31      23.427  35.023 100.465  1.00  5.95           C  
ATOM    236  CG  GLU A  31      22.952  34.847 101.914  1.00  7.14           C  
ATOM    237  CD  GLU A  31      21.557  35.378 102.244  1.00  8.24           C  
ATOM    238  OE1 GLU A  31      21.142  36.492 101.822  1.00  7.98           O  
ATOM    239  OE2 GLU A  31      20.894  34.680 103.039  1.00  9.13           O  
ATOM    240  N   LEU A  32      24.841  32.214  99.992  1.00  4.75           N  
ATOM    241  CA  LEU A  32      24.826  30.820 100.328  1.00  5.27           C  
ATOM    242  C   LEU A  32      26.169  30.092 100.165  1.00  5.89           C  
ATOM    243  O   LEU A  32      26.237  28.868 100.374  1.00  5.53           O  
ATOM    244  CB  LEU A  32      23.791  30.118  99.458  1.00  5.58           C  
ATOM    245  CG  LEU A  32      22.349  30.645  99.584  1.00  7.11           C  
ATOM    246  CD1 LEU A  32      21.432  29.813  98.727  1.00  6.90           C  
ATOM    247  CD2 LEU A  32      21.767  30.611 101.019  1.00  7.44           C  
ATOM    248  N   GLY A  33      27.197  30.810  99.715  1.00  5.65           N  
ATOM    249  CA  GLY A  33      28.496  30.203  99.393  1.00  5.67           C  
ATOM    250  C   GLY A  33      28.442  29.141  98.296  1.00  6.43           C  
ATOM    251  O   GLY A  33      29.087  28.132  98.398  1.00  6.76           O  
ATOM    252  N   LEU A  34      27.660  29.354  97.239  1.00  5.43           N  
ATOM    253  CA  LEU A  34      27.498  28.346  96.219  1.00  5.71           C  
ATOM    254  C   LEU A  34      27.891  28.938  94.834  1.00  5.55           C  
ATOM    255  O   LEU A  34      27.293  28.657  93.834  1.00  4.45           O  
ATOM    256  CB  LEU A  34      26.041  27.853  96.237  1.00  5.65           C  
ATOM    257  CG  LEU A  34      25.619  26.842  97.323  1.00  6.48           C  
ATOM    258  CD1 LEU A  34      24.115  26.646  97.372  1.00  6.91           C  
ATOM    259  CD2 LEU A  34      26.282  25.478  97.134  1.00  6.76           C  
ATOM    260  N   GLU A  35      28.927  29.765  94.829  1.00  5.45           N  
ATOM    261  CA  GLU A  35      29.342  30.514  93.664  1.00  5.00           C  
ATOM    262  C   GLU A  35      29.663  29.690  92.434  1.00  5.13           C  
ATOM    263  O   GLU A  35      29.392  30.124  91.298  1.00  4.24           O  
ATOM    264  CB  GLU A  35      30.535  31.382  94.001  1.00  4.98           C  
ATOM    265  CG  GLU A  35      30.188  32.503  94.938  1.00  5.46           C  
ATOM    266  CD  GLU A  35      30.493  32.157  96.391  1.00  6.41           C  
ATOM    267  OE1 GLU A  35      30.464  30.948  96.748  1.00  5.38           O  
ATOM    268  OE2 GLU A  35      30.769  33.109  97.169  1.00  6.61           O  
ATOM    269  N   GLU A  36      30.204  28.505  92.661  1.00  4.42           N  
ATOM    270  CA  GLU A  36      30.628  27.669  91.570  1.00  6.15           C  
ATOM    271  C   GLU A  36      29.436  27.137  90.771  1.00  5.86           C  
ATOM    272  O   GLU A  36      29.627  26.594  89.696  1.00  4.80           O  
ATOM    273  CB  GLU A  36      31.409  26.479  92.128  1.00  6.36           C  
ATOM    274  CG  GLU A  36      30.684  25.922  93.344  1.00  7.32           C  
ATOM    275  CD  GLU A  36      30.915  26.737  94.692  1.00  8.94           C  
ATOM    276  OE1 GLU A  36      31.695  27.767  94.841  1.00 10.20           O  
ATOM    277  OE2 GLU A  36      30.335  26.307  95.680  1.00  9.92           O  
ATOM    278  N   TYR A  37      28.227  27.262  91.315  1.00  4.45           N  
ATOM    279  CA  TYR A  37      27.033  26.821  90.616  1.00  5.56           C  
ATOM    280  C   TYR A  37      26.416  27.830  89.622  1.00  4.80           C  
ATOM    281  O   TYR A  37      25.472  27.520  88.898  1.00  4.63           O  
ATOM    282  CB  TYR A  37      25.968  26.416  91.637  1.00  6.16           C  
ATOM    283  CG  TYR A  37      26.366  25.104  92.277  1.00  7.57           C  
ATOM    284  CD1 TYR A  37      27.208  25.079  93.388  1.00  8.39           C  
ATOM    285  CD2 TYR A  37      25.915  23.913  91.766  1.00  8.51           C  
ATOM    286  CE1 TYR A  37      27.574  23.862  93.974  1.00  9.97           C  
ATOM    287  CE2 TYR A  37      26.262  22.701  92.344  1.00 11.16           C  
ATOM    288  CZ  TYR A  37      27.096  22.682  93.429  1.00 10.73           C  
ATOM    289  OH  TYR A  37      27.441  21.471  93.983  1.00 13.39           O  
ATOM    290  N   TYR A  38      26.930  29.036  89.607  1.00  3.75           N  
ATOM    291  CA  TYR A  38      26.371  30.033  88.731  1.00  4.25           C  
ATOM    292  C   TYR A  38      26.521  29.515  87.304  1.00  3.88           C  
ATOM    293  O   TYR A  38      27.631  29.162  86.897  1.00  3.81           O  
ATOM    294  CB  TYR A  38      27.097  31.340  88.892  1.00  3.60           C  
ATOM    295  CG  TYR A  38      26.397  32.441  88.172  1.00  3.28           C  
ATOM    296  CD1 TYR A  38      25.507  33.256  88.843  1.00  2.51           C  
ATOM    297  CD2 TYR A  38      26.596  32.639  86.842  1.00  3.48           C  
ATOM    298  CE1 TYR A  38      24.822  34.215  88.222  1.00  2.99           C  
ATOM    299  CE2 TYR A  38      25.929  33.689  86.179  1.00  4.10           C  
ATOM    300  CZ  TYR A  38      25.044  34.472  86.905  1.00  3.82           C  
ATOM    301  OH  TYR A  38      24.351  35.489  86.297  1.00  3.92           O  
ATOM    302  N   PRO A  39      25.403  29.459  86.556  1.00  4.31           N  
ATOM    303  CA  PRO A  39      25.505  28.700  85.317  1.00  5.22           C  
ATOM    304  C   PRO A  39      26.064  29.525  84.161  1.00  6.32           C  
ATOM    305  O   PRO A  39      26.191  30.755  84.202  1.00  5.18           O  
ATOM    306  CB  PRO A  39      24.050  28.338  85.054  1.00  5.17           C  
ATOM    307  CG  PRO A  39      23.367  29.552  85.426  1.00  5.99           C  
ATOM    308  CD  PRO A  39      24.005  29.870  86.776  1.00  4.31           C  
ATOM    309  N   ASP A  40      26.375  28.825  83.086  1.00  6.52           N  
ATOM    310  CA  ASP A  40      26.922  29.504  81.966  1.00  7.25           C  
ATOM    311  C   ASP A  40      25.873  30.270  81.172  1.00  8.29           C  
ATOM    312  O   ASP A  40      26.161  31.316  80.650  1.00  8.47           O  
ATOM    313  CB  ASP A  40      27.751  28.529  81.145  1.00  7.77           C  
ATOM    314  CG  ASP A  40      29.193  28.481  81.639  1.00  8.70           C  
ATOM    315  OD1 ASP A  40      29.981  29.421  81.338  1.00 10.11           O  
ATOM    316  OD2 ASP A  40      29.587  27.527  82.326  1.00  9.19           O  
ATOM    317  N   ASN A  41      24.649  29.766  81.121  1.00  8.39           N  
ATOM    318  CA  ASN A  41      23.557  30.466  80.454  1.00  9.00           C  
ATOM    319  C   ASN A  41      22.314  30.550  81.381  1.00  8.80           C  
ATOM    320  O   ASN A  41      21.517  29.636  81.467  1.00  8.25           O  
ATOM    321  CB  ASN A  41      23.231  29.788  79.118  1.00  8.89           C  
ATOM    322  CG  ASN A  41      22.152  30.537  78.293  1.00 10.18           C  
ATOM    323  OD1 ASN A  41      21.646  31.599  78.655  1.00  9.79           O  
ATOM    324  ND2 ASN A  41      21.830  29.976  77.166  1.00 11.71           N  
ATOM    325  N   VAL A  42      22.148  31.680  82.047  1.00  7.85           N  
ATOM    326  CA  VAL A  42      21.048  31.799  82.979  1.00  8.47           C  
ATOM    327  C   VAL A  42      19.698  31.827  82.266  1.00  8.70           C  
ATOM    328  O   VAL A  42      18.700  31.406  82.855  1.00  8.39           O  
ATOM    329  CB  VAL A  42      21.198  33.040  83.867  1.00  7.21           C  
ATOM    330  CG1 VAL A  42      20.008  33.170  84.767  1.00  7.31           C  
ATOM    331  CG2 VAL A  42      22.510  32.949  84.679  1.00  6.67           C  
ATOM    332  N   THR A  43      19.642  32.321  81.019  1.00  7.97           N  
ATOM    333  CA  THR A  43      18.322  32.470  80.379  1.00  8.16           C  
ATOM    334  C   THR A  43      17.644  31.151  80.079  1.00  9.00           C  
ATOM    335  O   THR A  43      16.417  31.120  79.969  1.00  8.79           O  
ATOM    336  CB  THR A  43      18.303  33.330  79.095  1.00  8.32           C  
ATOM    337  OG1 THR A  43      18.803  32.555  78.021  1.00  8.40           O  
ATOM    338  CG2 THR A  43      19.112  34.617  79.268  1.00  7.52           C  
ATOM    339  N   LYS A  44      18.438  30.091  79.916  1.00  9.05           N  
ATOM    340  CA  LYS A  44      17.943  28.717  79.815  1.00 10.61           C  
ATOM    341  C   LYS A  44      17.066  28.251  80.975  1.00 12.00           C  
ATOM    342  O   LYS A  44      16.317  27.277  80.806  1.00 11.04           O  
ATOM    343  CB  LYS A  44      19.131  27.729  79.778  1.00 12.25           C  
ATOM    344  CG  LYS A  44      19.824  27.705  78.433  1.00 13.25           C  
ATOM    345  CD  LYS A  44      20.861  26.532  78.333  1.00 15.24           C  
ATOM    346  CE  LYS A  44      21.538  26.516  76.871  1.00 17.32           C  
ATOM    347  NZ  LYS A  44      22.990  27.120  76.700  1.00 14.79           N  
ATOM    348  N   TYR A  45      17.197  28.908  82.145  1.00 10.68           N  
ATOM    349  CA  TYR A  45      16.486  28.502  83.345  1.00 10.98           C  
ATOM    350  C   TYR A  45      15.318  29.376  83.681  1.00 11.48           C  
ATOM    351  O   TYR A  45      14.678  29.138  84.704  1.00 13.35           O  
ATOM    352  CB  TYR A  45      17.416  28.463  84.558  1.00 11.58           C  
ATOM    353  CG  TYR A  45      18.586  27.517  84.359  1.00 12.13           C  
ATOM    354  CD1 TYR A  45      18.403  26.166  84.392  1.00 13.45           C  
ATOM    355  CD2 TYR A  45      19.835  27.986  84.057  1.00 11.67           C  
ATOM    356  CE1 TYR A  45      19.457  25.307  84.185  1.00 13.69           C  
ATOM    357  CE2 TYR A  45      20.867  27.151  83.805  1.00 12.04           C  
ATOM    358  CZ  TYR A  45      20.679  25.809  83.885  1.00 13.66           C  
ATOM    359  OH  TYR A  45      21.736  24.962  83.656  1.00 14.06           O  
ATOM    360  N   ILE A  46      15.043  30.388  82.856  1.00 10.28           N  
ATOM    361  CA  ILE A  46      13.951  31.328  83.088  1.00  9.58           C  
ATOM    362  C   ILE A  46      12.596  30.860  82.492  1.00 11.22           C  
ATOM    363  O   ILE A  46      12.555  30.394  81.363  1.00 11.99           O  
ATOM    364  CB  ILE A  46      14.294  32.656  82.457  1.00  8.55           C  
ATOM    365  CG1 ILE A  46      15.525  33.260  83.139  1.00  8.01           C  
ATOM    366  CG2 ILE A  46      13.082  33.639  82.526  1.00  7.76           C  
ATOM    367  CD1 ILE A  46      15.843  34.655  82.619  1.00  6.26           C  
ATOM    368  N   GLY A  47      11.499  30.993  83.229  1.00 11.70           N  
ATOM    369  CA  GLY A  47      10.189  30.545  82.746  1.00 11.76           C  
ATOM    370  C   GLY A  47       9.277  29.787  83.727  1.00 11.49           C  
ATOM    371  O   GLY A  47       8.066  30.052  83.800  1.00 11.93           O  
ATOM    372  N   GLY A  48       9.847  28.844  84.474  1.00 11.20           N  
ATOM    373  CA  GLY A  48       9.089  28.027  85.405  1.00 10.89           C  
ATOM    374  C   GLY A  48       8.964  28.545  86.828  1.00 11.91           C  
ATOM    375  O   GLY A  48       8.425  27.863  87.698  1.00 10.85           O  
ATOM    376  N   GLY A  49       9.501  29.730  87.101  1.00 10.72           N  
ATOM    377  CA  GLY A  49       9.505  30.219  88.467  1.00  9.82           C  
ATOM    378  C   GLY A  49      10.859  30.123  89.142  1.00  9.05           C  
ATOM    379  O   GLY A  49      11.739  29.398  88.705  1.00  8.19           O  
ATOM    380  N   VAL A  50      11.006  30.860  90.231  1.00  8.74           N  
ATOM    381  CA  VAL A  50      12.223  30.826  91.033  1.00  7.97           C  
ATOM    382  C   VAL A  50      12.560  29.430  91.517  1.00  8.28           C  
ATOM    383  O   VAL A  50      13.725  29.024  91.477  1.00  7.72           O  
ATOM    384  CB  VAL A  50      12.176  31.843  92.184  1.00  7.55           C  
ATOM    385  CG1 VAL A  50      13.248  31.535  93.194  1.00  7.13           C  
ATOM    386  CG2 VAL A  50      12.381  33.204  91.623  1.00  7.80           C  
ATOM    387  N   ARG A  51      11.554  28.661  91.928  1.00  8.86           N  
ATOM    388  CA  ARG A  51      11.830  27.312  92.426  1.00  9.13           C  
ATOM    389  C   ARG A  51      12.460  26.403  91.381  1.00  9.19           C  
ATOM    390  O   ARG A  51      13.472  25.741  91.626  1.00  7.83           O  
ATOM    391  CB  ARG A  51      10.576  26.674  92.969  1.00 10.59           C  
ATOM    392  CG  ARG A  51      10.922  25.480  93.780  1.00 12.40           C  
ATOM    393  CD  ARG A  51       9.710  24.844  94.291  1.00 14.06           C  
ATOM    394  NE  ARG A  51      10.062  23.686  95.085  1.00 17.78           N  
ATOM    395  CZ  ARG A  51       9.870  22.439  94.669  1.00 19.43           C  
ATOM    396  NH1 ARG A  51       9.323  22.236  93.465  1.00 20.04           N  
ATOM    397  NH2 ARG A  51      10.211  21.415  95.460  1.00 19.06           N  
ATOM    398  N   ALA A  52      11.833  26.368  90.205  1.00  9.32           N  
ATOM    399  CA  ALA A  52      12.322  25.533  89.121  1.00 10.12           C  
ATOM    400  C   ALA A  52      13.715  26.018  88.752  1.00  8.69           C  
ATOM    401  O   ALA A  52      14.620  25.202  88.472  1.00  9.08           O  
ATOM    402  CB  ALA A  52      11.354  25.595  87.845  1.00 10.00           C  
ATOM    403  N   LEU A  53      13.904  27.337  88.752  1.00  7.24           N  
ATOM    404  CA  LEU A  53      15.242  27.873  88.408  1.00  7.80           C  
ATOM    405  C   LEU A  53      16.305  27.332  89.333  1.00  8.03           C  
ATOM    406  O   LEU A  53      17.291  26.791  88.845  1.00  7.63           O  
ATOM    407  CB  LEU A  53      15.298  29.392  88.391  1.00  7.80           C  
ATOM    408  CG  LEU A  53      16.658  29.962  87.975  1.00  8.22           C  
ATOM    409  CD1 LEU A  53      16.507  31.161  87.064  1.00  9.25           C  
ATOM    410  CD2 LEU A  53      17.417  30.381  89.221  1.00  6.61           C  
ATOM    411  N   LEU A  54      16.084  27.456  90.660  1.00  7.00           N  
ATOM    412  CA  LEU A  54      17.087  27.060  91.662  1.00  7.85           C  
ATOM    413  C   LEU A  54      17.317  25.553  91.664  1.00  8.15           C  
ATOM    414  O   LEU A  54      18.412  25.092  91.900  1.00  8.31           O  
ATOM    415  CB  LEU A  54      16.712  27.527  93.059  1.00  6.05           C  
ATOM    416  CG  LEU A  54      16.649  29.043  93.215  1.00  6.66           C  
ATOM    417  CD1 LEU A  54      16.268  29.436  94.657  1.00  6.90           C  
ATOM    418  CD2 LEU A  54      18.010  29.627  92.828  1.00  6.68           C  
ATOM    419  N   GLU A  55      16.267  24.796  91.411  1.00  8.34           N  
ATOM    420  CA  GLU A  55      16.372  23.349  91.307  1.00  9.36           C  
ATOM    421  C   GLU A  55      17.225  22.938  90.150  1.00  9.94           C  
ATOM    422  O   GLU A  55      17.952  21.966  90.245  1.00 11.54           O  
ATOM    423  CB  GLU A  55      14.996  22.722  91.148  1.00 10.58           C  
ATOM    424  CG  GLU A  55      14.372  22.378  92.518  1.00 12.41           C  
ATOM    425  CD  GLU A  55      12.902  22.017  92.456  1.00 15.21           C  
ATOM    426  OE1 GLU A  55      12.227  22.308  91.439  1.00 16.66           O  
ATOM    427  OE2 GLU A  55      12.398  21.430  93.450  1.00 19.67           O  
ATOM    428  N   LYS A  56      17.158  23.636  89.023  1.00  9.64           N  
ATOM    429  CA  LYS A  56      17.985  23.153  87.939  1.00 10.83           C  
ATOM    430  C   LYS A  56      19.400  23.666  88.124  1.00 10.80           C  
ATOM    431  O   LYS A  56      20.362  23.047  87.675  1.00 11.53           O  
ATOM    432  CB  LYS A  56      17.479  23.573  86.572  1.00 13.29           C  
ATOM    433  CG  LYS A  56      16.045  23.212  86.253  1.00 13.79           C  
ATOM    434  CD  LYS A  56      15.754  23.679  84.878  1.00 15.32           C  
ATOM    435  CE  LYS A  56      14.242  23.812  84.627  1.00 19.88           C  
ATOM    436  NZ  LYS A  56      13.689  22.789  83.694  1.00 21.14           N  
ATOM    437  N   VAL A  57      19.538  24.807  88.768  1.00  8.87           N  
ATOM    438  CA  VAL A  57      20.860  25.351  88.928  1.00  8.60           C  
ATOM    439  C   VAL A  57      21.629  24.586  89.994  1.00  9.77           C  
ATOM    440  O   VAL A  57      22.788  24.238  89.782  1.00  9.40           O  
ATOM    441  CB  VAL A  57      20.852  26.873  89.192  1.00  8.24           C  
ATOM    442  CG1 VAL A  57      22.213  27.338  89.770  1.00  6.87           C  
ATOM    443  CG2 VAL A  57      20.558  27.624  87.907  1.00  7.38           C  
ATOM    444  N   LEU A  58      20.974  24.290  91.118  1.00  9.49           N  
ATOM    445  CA  LEU A  58      21.687  23.745  92.280  1.00 10.08           C  
ATOM    446  C   LEU A  58      21.683  22.232  92.345  1.00 12.01           C  
ATOM    447  O   LEU A  58      22.485  21.630  93.079  1.00 13.04           O  
ATOM    448  CB  LEU A  58      21.081  24.279  93.560  1.00  9.83           C  
ATOM    449  CG  LEU A  58      21.406  25.747  93.804  1.00 10.02           C  
ATOM    450  CD1 LEU A  58      20.848  26.284  95.172  1.00  8.75           C  
ATOM    451  CD2 LEU A  58      22.934  25.975  93.679  1.00  8.92           C  
ATOM    452  N   LYS A  59      20.745  21.635  91.616  1.00 12.00           N  
ATOM    453  CA  LYS A  59      20.550  20.179  91.580  1.00 15.37           C  
ATOM    454  C   LYS A  59      20.554  19.583  92.968  1.00 14.90           C  
ATOM    455  O   LYS A  59      19.679  19.907  93.716  1.00 13.51           O  
ATOM    456  CB  LYS A  59      21.527  19.527  90.605  1.00 15.46           C  
ATOM    457  CG  LYS A  59      21.013  19.822  89.161  1.00 16.85           C  
ATOM    458  CD  LYS A  59      22.107  19.979  88.111  1.00 17.01           C  
ATOM    459  CE  LYS A  59      23.450  20.341  88.745  1.00 16.14           C  
ATOM    460  NZ  LYS A  59      23.627  21.797  89.056  1.00 14.77           N  
ATOM    461  N   ASP A  60      21.529  18.758  93.338  1.00 17.04           N  
ATOM    462  CA  ASP A  60      21.519  18.167  94.680  1.00 17.13           C  
ATOM    463  C   ASP A  60      21.745  19.162  95.840  1.00 16.22           C  
ATOM    464  O   ASP A  60      21.494  18.859  97.009  1.00 15.41           O  
ATOM    465  CB  ASP A  60      22.487  16.972  94.756  1.00 18.59           C  
ATOM    466  CG  ASP A  60      23.939  17.391  94.764  1.00 22.26           C  
ATOM    467  OD1 ASP A  60      24.345  18.218  93.907  1.00 22.38           O  
ATOM    468  OD2 ASP A  60      24.712  16.891  95.625  1.00 24.02           O  
ATOM    469  N   LYS A  61      22.187  20.379  95.550  1.00 15.67           N  
ATOM    470  CA  LYS A  61      22.420  21.316  96.632  1.00 13.48           C  
ATOM    471  C   LYS A  61      21.195  22.189  96.930  1.00 12.18           C  
ATOM    472  O   LYS A  61      21.287  23.086  97.738  1.00  9.90           O  
ATOM    473  CB  LYS A  61      23.630  22.219  96.350  1.00 13.12           C  
ATOM    474  CG  LYS A  61      24.865  21.454  95.976  1.00 16.15           C  
ATOM    475  CD  LYS A  61      25.283  20.531  97.075  1.00 17.18           C  
ATOM    476  CE  LYS A  61      26.106  21.289  98.074  1.00 19.48           C  
ATOM    477  NZ  LYS A  61      27.316  20.455  98.452  1.00 23.95           N  
ATOM    478  N   PHE A  62      20.096  21.954  96.228  1.00 11.77           N  
ATOM    479  CA  PHE A  62      18.901  22.780  96.393  1.00 11.52           C  
ATOM    480  C   PHE A  62      18.224  22.545  97.732  1.00 10.59           C  
ATOM    481  O   PHE A  62      18.159  21.421  98.170  1.00 11.07           O  
ATOM    482  CB  PHE A  62      17.894  22.479  95.297  1.00 10.41           C  
ATOM    483  CG  PHE A  62      16.596  23.207  95.480  1.00 10.88           C  
ATOM    484  CD1 PHE A  62      16.492  24.574  95.184  1.00  9.70           C  
ATOM    485  CD2 PHE A  62      15.485  22.548  95.969  1.00 11.70           C  
ATOM    486  CE1 PHE A  62      15.299  25.254  95.369  1.00  9.87           C  
ATOM    487  CE2 PHE A  62      14.276  23.238  96.135  1.00 13.40           C  
ATOM    488  CZ  PHE A  62      14.196  24.599  95.833  1.00 11.21           C  
ATOM    489  N   ARG A  63      17.715  23.603  98.345  1.00 10.48           N  
ATOM    490  CA  ARG A  63      16.936  23.568  99.574  1.00 11.55           C  
ATOM    491  C   ARG A  63      15.756  24.540  99.457  1.00 11.55           C  
ATOM    492  O   ARG A  63      15.926  25.685  99.007  1.00 10.17           O  
ATOM    493  CB  ARG A  63      17.784  24.048 100.757  1.00 11.83           C  
ATOM    494  CG  ARG A  63      19.054  23.240 100.976  1.00 14.16           C  
ATOM    495  CD  ARG A  63      19.677  23.677 102.227  1.00 15.17           C  
ATOM    496  NE  ARG A  63      18.907  23.132 103.335  1.00 20.66           N  
ATOM    497  CZ  ARG A  63      19.021  21.861 103.735  1.00 23.33           C  
ATOM    498  NH1 ARG A  63      19.892  21.035 103.118  1.00 24.02           N  
ATOM    499  NH2 ARG A  63      18.268  21.405 104.734  1.00 23.18           N  
ATOM    500  N   GLU A  64      14.591  24.135  99.945  1.00 10.58           N  
ATOM    501  CA  GLU A  64      13.406  24.963  99.762  1.00 11.63           C  
ATOM    502  C   GLU A  64      13.562  26.361 100.334  1.00 10.28           C  
ATOM    503  O   GLU A  64      12.984  27.285  99.821  1.00  9.86           O  
ATOM    504  CB  GLU A  64      12.147  24.320 100.353  1.00 12.85           C  
ATOM    505  CG  GLU A  64      11.836  22.918  99.851  1.00 13.93           C  
ATOM    506  CD  GLU A  64      11.312  22.851  98.417  1.00 15.62           C  
ATOM    507  OE1 GLU A  64      10.943  23.916  97.830  1.00 17.02           O  
ATOM    508  OE2 GLU A  64      11.307  21.721  97.857  1.00 16.28           O  
ATOM    509  N   GLU A  65      14.305  26.539 101.406  1.00  9.85           N  
ATOM    510  CA  GLU A  65      14.477  27.888 101.926  1.00 10.39           C  
ATOM    511  C   GLU A  65      15.259  28.863 101.016  1.00  9.25           C  
ATOM    512  O   GLU A  65      15.373  30.044 101.315  1.00  8.88           O  
ATOM    513  CB  GLU A  65      15.214  27.821 103.252  1.00 12.73           C  
ATOM    514  CG  GLU A  65      16.582  27.212 103.166  1.00 13.59           C  
ATOM    515  CD  GLU A  65      16.567  25.783 103.702  1.00 18.28           C  
ATOM    516  OE1 GLU A  65      17.443  25.485 104.581  1.00 19.57           O  
ATOM    517  OE2 GLU A  65      15.652  24.970 103.281  1.00 16.60           O  
ATOM    518  N   TYR A  66      15.858  28.365  99.957  1.00  8.93           N  
ATOM    519  CA  TYR A  66      16.691  29.223  99.094  1.00  8.24           C  
ATOM    520  C   TYR A  66      15.789  30.080  98.191  1.00  6.70           C  
ATOM    521  O   TYR A  66      16.156  31.168  97.727  1.00  6.16           O  
ATOM    522  CB  TYR A  66      17.608  28.342  98.252  1.00  7.75           C  
ATOM    523  CG  TYR A  66      18.739  27.667  99.010  1.00  9.36           C  
ATOM    524  CD1 TYR A  66      19.097  28.055 100.295  1.00  9.59           C  
ATOM    525  CD2 TYR A  66      19.465  26.660  98.419  1.00 10.24           C  
ATOM    526  CE1 TYR A  66      20.147  27.423 100.972  1.00  9.63           C  
ATOM    527  CE2 TYR A  66      20.508  26.046  99.071  1.00 10.25           C  
ATOM    528  CZ  TYR A  66      20.840  26.442 100.340  1.00 10.30           C  
ATOM    529  OH  TYR A  66      21.888  25.805 100.951  1.00 11.17           O  
ATOM    530  N   VAL A  67      14.591  29.580  97.934  1.00  6.90           N  
ATOM    531  CA  VAL A  67      13.602  30.367  97.233  1.00  6.86           C  
ATOM    532  C   VAL A  67      13.427  31.691  97.934  1.00  5.91           C  
ATOM    533  O   VAL A  67      13.602  32.735  97.302  1.00  4.56           O  
ATOM    534  CB  VAL A  67      12.295  29.551  96.973  1.00  8.44           C  
ATOM    535  CG1 VAL A  67      11.222  30.376  96.281  1.00  8.35           C  
ATOM    536  CG2 VAL A  67      12.628  28.340  96.129  1.00  7.48           C  
ATOM    537  N   GLU A  68      13.132  31.694  99.243  1.00  7.10           N  
ATOM    538  CA  GLU A  68      12.988  32.974  99.976  1.00  6.02           C  
ATOM    539  C   GLU A  68      14.214  33.879  99.858  1.00  5.21           C  
ATOM    540  O   GLU A  68      14.059  35.084  99.717  1.00  3.60           O  
ATOM    541  CB  GLU A  68      12.853  32.771 101.476  1.00  8.19           C  
ATOM    542  CG  GLU A  68      11.512  32.828 102.047  1.00  8.85           C  
ATOM    543  CD  GLU A  68      11.678  32.677 103.529  1.00 11.28           C  
ATOM    544  OE1 GLU A  68      12.105  31.533 103.981  1.00 14.54           O  
ATOM    545  OE2 GLU A  68      11.489  33.724 104.219  1.00 10.16           O  
ATOM    546  N   VAL A  69      15.420  33.280  99.908  1.00  4.98           N  
ATOM    547  CA  VAL A  69      16.663  34.052  99.750  1.00  4.51           C  
ATOM    548  C   VAL A  69      16.761  34.788  98.401  1.00  3.82           C  
ATOM    549  O   VAL A  69      17.089  35.963  98.324  1.00  3.12           O  
ATOM    550  CB  VAL A  69      17.925  33.145  99.880  1.00  4.95           C  
ATOM    551  CG1 VAL A  69      19.209  34.001  99.707  1.00  4.09           C  
ATOM    552  CG2 VAL A  69      17.933  32.427 101.214  1.00  6.49           C  
ATOM    553  N   PHE A  70      16.460  34.064  97.343  1.00  4.30           N  
ATOM    554  CA  PHE A  70      16.510  34.602  95.974  1.00  3.72           C  
ATOM    555  C   PHE A  70      15.519  35.756  95.875  1.00  3.59           C  
ATOM    556  O   PHE A  70      15.848  36.839  95.471  1.00  3.24           O  
ATOM    557  CB  PHE A  70      16.201  33.514  94.953  1.00  3.88           C  
ATOM    558  CG  PHE A  70      16.274  33.986  93.514  1.00  4.02           C  
ATOM    559  CD1 PHE A  70      17.348  33.626  92.706  1.00  4.81           C  
ATOM    560  CD2 PHE A  70      15.250  34.751  92.963  1.00  4.36           C  
ATOM    561  CE1 PHE A  70      17.438  34.053  91.324  1.00  3.83           C  
ATOM    562  CE2 PHE A  70      15.321  35.194  91.563  1.00  4.84           C  
ATOM    563  CZ  PHE A  70      16.408  34.836  90.777  1.00  3.57           C  
ATOM    564  N   ARG A  71      14.306  35.513  96.308  1.00  3.70           N  
ATOM    565  CA  ARG A  71      13.276  36.513  96.249  1.00  3.69           C  
ATOM    566  C   ARG A  71      13.596  37.761  97.037  1.00  3.60           C  
ATOM    567  O   ARG A  71      13.410  38.877  96.560  1.00  2.97           O  
ATOM    568  CB  ARG A  71      11.961  35.894  96.675  1.00  4.81           C  
ATOM    569  CG  ARG A  71      11.469  34.953  95.627  1.00  6.17           C  
ATOM    570  CD  ARG A  71      10.135  34.310  96.085  1.00  7.40           C  
ATOM    571  NE  ARG A  71       9.465  33.773  94.906  1.00  7.63           N  
ATOM    572  CZ  ARG A  71       8.577  32.802  94.946  1.00 10.67           C  
ATOM    573  NH1 ARG A  71       8.305  32.197  96.127  1.00 10.29           N  
ATOM    574  NH2 ARG A  71       7.998  32.421  93.793  1.00 10.70           N  
ATOM    575  N   LYS A  72      14.145  37.582  98.222  1.00  3.06           N  
ATOM    576  CA  LYS A  72      14.653  38.703  98.954  1.00  3.54           C  
ATOM    577  C   LYS A  72      15.640  39.563  98.155  1.00  4.09           C  
ATOM    578  O   LYS A  72      15.536  40.782  98.144  1.00  4.28           O  
ATOM    579  CB  LYS A  72      15.356  38.211 100.204  1.00  5.21           C  
ATOM    580  CG  LYS A  72      15.842  39.295 101.095  1.00  5.63           C  
ATOM    581  CD  LYS A  72      16.640  38.600 102.191  1.00  6.99           C  
ATOM    582  CE  LYS A  72      18.140  38.707 102.001  1.00  7.94           C  
ATOM    583  NZ  LYS A  72      18.868  37.601 102.768  1.00  8.16           N  
ATOM    584  N   HIS A  73      16.610  38.939  97.490  1.00  3.82           N  
ATOM    585  CA  HIS A  73      17.594  39.721  96.764  1.00  3.91           C  
ATOM    586  C   HIS A  73      17.005  40.348  95.518  1.00  4.24           C  
ATOM    587  O   HIS A  73      17.346  41.436  95.186  1.00  4.10           O  
ATOM    588  CB  HIS A  73      18.813  38.849  96.420  1.00  3.37           C  
ATOM    589  CG  HIS A  73      19.676  38.525  97.606  1.00  3.92           C  
ATOM    590  ND1 HIS A  73      20.257  39.491  98.386  1.00  4.48           N  
ATOM    591  CD2 HIS A  73      20.146  37.343  98.067  1.00  4.55           C  
ATOM    592  CE1 HIS A  73      21.008  38.921  99.313  1.00  4.85           C  
ATOM    593  NE2 HIS A  73      20.956  37.619  99.140  1.00  4.89           N  
ATOM    594  N   TYR A  74      16.118  39.638  94.824  1.00  3.59           N  
ATOM    595  CA  TYR A  74      15.465  40.193  93.637  1.00  4.03           C  
ATOM    596  C   TYR A  74      14.631  41.436  94.042  1.00  4.55           C  
ATOM    597  O   TYR A  74      14.609  42.414  93.353  1.00  4.20           O  
ATOM    598  CB  TYR A  74      14.541  39.135  93.004  1.00  3.53           C  
ATOM    599  CG  TYR A  74      14.134  39.371  91.564  1.00  3.75           C  
ATOM    600  CD1 TYR A  74      14.351  40.595  90.912  1.00  3.54           C  
ATOM    601  CD2 TYR A  74      13.487  38.369  90.856  1.00  3.92           C  
ATOM    602  CE1 TYR A  74      13.942  40.790  89.566  1.00  3.65           C  
ATOM    603  CE2 TYR A  74      13.074  38.553  89.540  1.00  4.11           C  
ATOM    604  CZ  TYR A  74      13.300  39.754  88.906  1.00  3.88           C  
ATOM    605  OH  TYR A  74      12.844  39.879  87.627  1.00  3.50           O  
ATOM    606  N   LEU A  75      13.977  41.366  95.210  1.00  4.26           N  
ATOM    607  CA  LEU A  75      13.186  42.482  95.747  1.00  4.63           C  
ATOM    608  C   LEU A  75      14.074  43.645  96.157  1.00  5.63           C  
ATOM    609  O   LEU A  75      13.656  44.801  96.100  1.00  5.90           O  
ATOM    610  CB  LEU A  75      12.364  42.017  96.940  1.00  4.80           C  
ATOM    611  CG  LEU A  75      11.103  41.334  96.445  1.00  6.05           C  
ATOM    612  CD1 LEU A  75      10.313  40.565  97.521  1.00  7.59           C  
ATOM    613  CD2 LEU A  75      10.242  42.385  95.686  1.00  5.99           C  
ATOM    614  N   GLU A  76      15.314  43.393  96.510  1.00  5.27           N  
ATOM    615  CA  GLU A  76      16.123  44.581  96.755  1.00  6.93           C  
ATOM    616  C   GLU A  76      16.545  45.298  95.458  1.00  6.40           C  
ATOM    617  O   GLU A  76      17.019  46.429  95.496  1.00  8.02           O  
ATOM    618  CB  GLU A  76      17.320  44.306  97.714  1.00  7.69           C  
ATOM    619  CG  GLU A  76      17.949  43.001  97.542  1.00  6.60           C  
ATOM    620  CD  GLU A  76      18.941  42.542  98.673  1.00  8.97           C  
ATOM    621  OE1 GLU A  76      18.582  42.340  99.897  1.00  8.19           O  
ATOM    622  OE2 GLU A  76      20.101  42.322  98.247  1.00  9.49           O  
ATOM    623  N   ASN A  77      16.311  44.701  94.286  1.00  6.03           N  
ATOM    624  CA  ASN A  77      16.673  45.355  93.010  1.00  5.43           C  
ATOM    625  C   ASN A  77      15.807  44.844  91.861  1.00  5.45           C  
ATOM    626  O   ASN A  77      16.320  44.199  90.969  1.00  4.53           O  
ATOM    627  CB  ASN A  77      18.159  45.110  92.639  1.00  6.28           C  
ATOM    628  CG  ASN A  77      19.147  45.945  93.485  1.00  9.19           C  
ATOM    629  OD1 ASN A  77      19.308  47.198  93.301  1.00  9.54           O  
ATOM    630  ND2 ASN A  77      19.822  45.263  94.403  1.00  9.08           N  
ATOM    631  N   PRO A  78      14.482  45.110  91.912  1.00  5.23           N  
ATOM    632  CA  PRO A  78      13.496  44.542  90.985  1.00  4.61           C  
ATOM    633  C   PRO A  78      13.737  45.024  89.532  1.00  4.21           C  
ATOM    634  O   PRO A  78      13.500  44.298  88.581  1.00  3.31           O  
ATOM    635  CB  PRO A  78      12.171  45.080  91.540  1.00  4.87           C  
ATOM    636  CG  PRO A  78      12.601  46.366  92.322  1.00  4.72           C  
ATOM    637  CD  PRO A  78      13.833  45.895  92.981  1.00  5.53           C  
ATOM    638  N   VAL A  79      14.278  46.237  89.385  1.00  4.55           N  
ATOM    639  CA  VAL A  79      14.548  46.762  88.060  1.00  4.45           C  
ATOM    640  C   VAL A  79      15.917  47.459  88.017  1.00  4.40           C  
ATOM    641  O   VAL A  79      16.063  48.544  88.573  1.00  5.32           O  
ATOM    642  CB  VAL A  79      13.422  47.739  87.581  1.00  3.48           C  
ATOM    643  CG1 VAL A  79      13.828  48.401  86.267  1.00  3.65           C  
ATOM    644  CG2 VAL A  79      12.063  47.030  87.491  1.00  3.23           C  
ATOM    645  N   VAL A  80      16.897  46.856  87.354  1.00  4.32           N  
ATOM    646  CA  VAL A  80      18.176  47.539  87.075  1.00  4.92           C  
ATOM    647  C   VAL A  80      18.373  47.595  85.571  1.00  5.39           C  
ATOM    648  O   VAL A  80      18.404  48.677  84.973  1.00  5.44           O  
ATOM    649  CB  VAL A  80      19.357  46.795  87.737  1.00  5.69           C  
ATOM    650  CG1 VAL A  80      20.677  47.481  87.420  1.00  7.83           C  
ATOM    651  CG2 VAL A  80      19.149  46.775  89.185  1.00  5.84           C  
ATOM    652  N   TYR A  81      18.456  46.420  84.958  1.00  5.24           N  
ATOM    653  CA  TYR A  81      18.513  46.243  83.509  1.00  4.59           C  
ATOM    654  C   TYR A  81      17.168  45.977  82.844  1.00  4.37           C  
ATOM    655  O   TYR A  81      17.093  46.069  81.602  1.00  5.89           O  
ATOM    656  CB  TYR A  81      19.442  45.074  83.159  1.00  5.15           C  
ATOM    657  CG  TYR A  81      20.755  45.256  83.826  1.00  5.58           C  
ATOM    658  CD1 TYR A  81      21.638  46.202  83.360  1.00  7.46           C  
ATOM    659  CD2 TYR A  81      21.084  44.552  84.974  1.00  6.28           C  
ATOM    660  CE1 TYR A  81      22.823  46.423  83.975  1.00  9.35           C  
ATOM    661  CE2 TYR A  81      22.283  44.780  85.631  1.00  7.04           C  
ATOM    662  CZ  TYR A  81      23.145  45.724  85.115  1.00  8.84           C  
ATOM    663  OH  TYR A  81      24.347  46.000  85.737  1.00 11.49           O  
ATOM    664  N   THR A  82      16.139  45.601  83.610  1.00  3.25           N  
ATOM    665  CA  THR A  82      14.880  45.122  83.017  1.00  3.50           C  
ATOM    666  C   THR A  82      14.168  46.200  82.237  1.00  3.10           C  
ATOM    667  O   THR A  82      14.081  47.316  82.704  1.00  2.68           O  
ATOM    668  CB  THR A  82      13.935  44.648  84.047  1.00  2.72           C  
ATOM    669  OG1 THR A  82      14.374  43.382  84.494  1.00  3.99           O  
ATOM    670  CG2 THR A  82      12.543  44.502  83.460  1.00  3.09           C  
ATOM    671  N   LYS A  83      13.697  45.856  81.044  1.00  3.63           N  
ATOM    672  CA  LYS A  83      12.897  46.776  80.220  1.00  3.30           C  
ATOM    673  C   LYS A  83      11.823  45.998  79.510  1.00  2.57           C  
ATOM    674  O   LYS A  83      12.018  44.816  79.239  1.00  2.53           O  
ATOM    675  CB  LYS A  83      13.748  47.482  79.150  1.00  4.47           C  
ATOM    676  CG  LYS A  83      14.936  48.350  79.619  1.00  6.51           C  
ATOM    677  CD  LYS A  83      15.978  48.386  78.496  1.00  8.03           C  
ATOM    678  CE  LYS A  83      16.384  49.832  78.158  1.00 13.40           C  
ATOM    679  NZ  LYS A  83      16.572  50.635  79.439  1.00 17.41           N  
ATOM    680  N   PRO A  84      10.716  46.689  79.137  1.00  2.31           N  
ATOM    681  CA  PRO A  84       9.726  46.057  78.274  1.00  2.66           C  
ATOM    682  C   PRO A  84      10.436  45.658  76.973  1.00  2.71           C  
ATOM    683  O   PRO A  84      11.384  46.290  76.594  1.00  1.89           O  
ATOM    684  CB  PRO A  84       8.687  47.170  78.032  1.00  3.16           C  
ATOM    685  CG  PRO A  84       8.900  48.157  79.231  1.00  3.63           C  
ATOM    686  CD  PRO A  84      10.418  48.113  79.336  1.00  3.39           C  
ATOM    687  N   TYR A  85       9.987  44.594  76.329  1.00  2.46           N  
ATOM    688  CA  TYR A  85      10.540  44.295  75.029  1.00  3.01           C  
ATOM    689  C   TYR A  85      10.135  45.451  74.106  1.00  3.38           C  
ATOM    690  O   TYR A  85       9.039  46.015  74.267  1.00  2.50           O  
ATOM    691  CB  TYR A  85       9.978  42.964  74.506  1.00  2.74           C  
ATOM    692  CG  TYR A  85      10.708  41.741  75.006  1.00  3.12           C  
ATOM    693  CD1 TYR A  85      11.928  41.359  74.433  1.00  3.29           C  
ATOM    694  CD2 TYR A  85      10.244  41.024  76.097  1.00  2.34           C  
ATOM    695  CE1 TYR A  85      12.632  40.230  74.926  1.00  3.64           C  
ATOM    696  CE2 TYR A  85      10.929  39.903  76.580  1.00  2.59           C  
ATOM    697  CZ  TYR A  85      12.102  39.514  75.993  1.00  3.26           C  
ATOM    698  OH  TYR A  85      12.791  38.446  76.464  1.00  4.05           O  
ATOM    699  N   PRO A  86      11.022  45.798  73.155  1.00  3.71           N  
ATOM    700  CA  PRO A  86      10.674  46.709  72.070  1.00  4.15           C  
ATOM    701  C   PRO A  86       9.267  46.362  71.515  1.00  4.47           C  
ATOM    702  O   PRO A  86       8.891  45.146  71.281  1.00  3.77           O  
ATOM    703  CB  PRO A  86      11.780  46.447  71.019  1.00  5.36           C  
ATOM    704  CG  PRO A  86      12.981  45.904  71.833  1.00  4.79           C  
ATOM    705  CD  PRO A  86      12.333  45.136  72.945  1.00  4.22           C  
ATOM    706  N   GLU A  87       8.477  47.418  71.353  1.00  3.97           N  
ATOM    707  CA  GLU A  87       7.080  47.336  70.870  1.00  3.80           C  
ATOM    708  C   GLU A  87       6.062  46.883  71.911  1.00  3.05           C  
ATOM    709  O   GLU A  87       4.884  46.834  71.603  1.00  2.49           O  
ATOM    710  CB  GLU A  87       6.948  46.420  69.668  1.00  4.11           C  
ATOM    711  CG  GLU A  87       7.997  46.643  68.621  1.00  4.36           C  
ATOM    712  CD  GLU A  87       7.670  45.910  67.324  1.00  5.29           C  
ATOM    713  OE1 GLU A  87       6.999  44.878  67.330  1.00  5.38           O  
ATOM    714  OE2 GLU A  87       8.139  46.356  66.279  1.00  7.86           O  
ATOM    715  N   ILE A  88       6.503  46.500  73.098  1.00  2.48           N  
ATOM    716  CA  ILE A  88       5.531  46.118  74.133  1.00  2.36           C  
ATOM    717  C   ILE A  88       4.560  47.287  74.518  1.00  2.18           C  
ATOM    718  O   ILE A  88       3.353  47.103  74.466  1.00  1.72           O  
ATOM    719  CB  ILE A  88       6.186  45.389  75.346  1.00  2.04           C  
ATOM    720  CG1 ILE A  88       6.553  43.936  74.952  1.00  2.11           C  
ATOM    721  CG2 ILE A  88       5.231  45.313  76.523  1.00  1.97           C  
ATOM    722  CD1 ILE A  88       5.312  43.069  74.743  1.00  1.61           C  
ATOM    723  N   PRO A  89       5.105  48.464  74.896  1.00  2.04           N  
ATOM    724  CA  PRO A  89       4.237  49.612  75.225  1.00  2.45           C  
ATOM    725  C   PRO A  89       3.299  49.927  74.037  1.00  2.11           C  
ATOM    726  O   PRO A  89       2.110  49.980  74.229  1.00  1.81           O  
ATOM    727  CB  PRO A  89       5.234  50.740  75.499  1.00  3.43           C  
ATOM    728  CG  PRO A  89       6.464  50.001  75.958  1.00  3.87           C  
ATOM    729  CD  PRO A  89       6.528  48.796  75.082  1.00  2.72           C  
ATOM    730  N   TYR A  90       3.830  50.006  72.827  1.00  2.53           N  
ATOM    731  CA  TYR A  90       3.001  50.248  71.649  1.00  2.26           C  
ATOM    732  C   TYR A  90       1.849  49.229  71.564  1.00  2.67           C  
ATOM    733  O   TYR A  90       0.659  49.558  71.400  1.00  2.11           O  
ATOM    734  CB  TYR A  90       3.865  50.120  70.440  1.00  2.87           C  
ATOM    735  CG  TYR A  90       2.981  50.044  69.231  1.00  4.01           C  
ATOM    736  CD1 TYR A  90       2.427  51.198  68.685  1.00  3.65           C  
ATOM    737  CD2 TYR A  90       2.714  48.797  68.623  1.00  3.85           C  
ATOM    738  CE1 TYR A  90       1.578  51.099  67.557  1.00  5.05           C  
ATOM    739  CE2 TYR A  90       1.930  48.694  67.529  1.00  4.17           C  
ATOM    740  CZ  TYR A  90       1.350  49.835  67.000  1.00  5.47           C  
ATOM    741  OH  TYR A  90       0.566  49.708  65.875  1.00  7.71           O  
ATOM    742  N   THR A  91       2.184  47.968  71.773  1.00  3.46           N  
ATOM    743  CA  THR A  91       1.229  46.911  71.563  1.00  1.86           C  
ATOM    744  C   THR A  91       0.099  46.882  72.608  1.00  4.12           C  
ATOM    745  O   THR A  91      -1.047  46.737  72.269  1.00  1.84           O  
ATOM    746  CB  THR A  91       1.931  45.530  71.422  1.00  2.27           C  
ATOM    747  OG1 THR A  91       2.884  45.538  70.309  1.00  2.25           O  
ATOM    748  CG2 THR A  91       0.856  44.457  71.181  1.00  2.76           C  
ATOM    749  N   LEU A  92       0.447  47.086  73.879  1.00  1.75           N  
ATOM    750  CA  LEU A  92      -0.511  47.270  74.967  1.00  2.17           C  
ATOM    751  C   LEU A  92      -1.438  48.458  74.691  1.00  3.11           C  
ATOM    752  O   LEU A  92      -2.615  48.329  74.836  1.00  2.54           O  
ATOM    753  CB  LEU A  92       0.214  47.458  76.316  1.00  2.06           C  
ATOM    754  CG  LEU A  92       1.121  46.276  76.722  1.00  2.18           C  
ATOM    755  CD1 LEU A  92       1.931  46.559  77.931  1.00  2.11           C  
ATOM    756  CD2 LEU A  92       0.269  44.997  76.879  1.00  1.88           C  
ATOM    757  N   GLU A  93      -0.878  49.598  74.301  1.00  2.40           N  
ATOM    758  CA  GLU A  93      -1.695  50.766  73.952  1.00  3.56           C  
ATOM    759  C   GLU A  93      -2.721  50.447  72.838  1.00  3.96           C  
ATOM    760  O   GLU A  93      -3.910  50.771  72.941  1.00  3.34           O  
ATOM    761  CB  GLU A  93      -0.808  51.953  73.548  1.00  3.60           C  
ATOM    762  CG  GLU A  93      -1.581  53.101  72.897  1.00  4.17           C  
ATOM    763  CD  GLU A  93      -2.596  53.818  73.830  1.00  5.44           C  
ATOM    764  OE1 GLU A  93      -2.583  53.639  75.084  1.00  4.61           O  
ATOM    765  OE2 GLU A  93      -3.435  54.594  73.275  1.00  5.65           O  
ATOM    766  N   ALA A  94      -2.259  49.798  71.774  1.00  3.24           N  
ATOM    767  CA  ALA A  94      -3.142  49.403  70.667  1.00  4.62           C  
ATOM    768  C   ALA A  94      -4.257  48.481  71.121  1.00  4.85           C  
ATOM    769  O   ALA A  94      -5.386  48.613  70.683  1.00  5.39           O  
ATOM    770  CB  ALA A  94      -2.345  48.696  69.564  1.00  3.65           C  
ATOM    771  N   LEU A  95      -3.928  47.501  71.954  1.00  3.97           N  
ATOM    772  CA  LEU A  95      -4.921  46.487  72.310  1.00  4.94           C  
ATOM    773  C   LEU A  95      -5.960  47.106  73.192  1.00  5.47           C  
ATOM    774  O   LEU A  95      -7.141  46.877  73.021  1.00  5.95           O  
ATOM    775  CB  LEU A  95      -4.319  45.306  73.046  1.00  4.04           C  
ATOM    776  CG  LEU A  95      -3.330  44.405  72.314  1.00  4.38           C  
ATOM    777  CD1 LEU A  95      -2.747  43.377  73.325  1.00  3.60           C  
ATOM    778  CD2 LEU A  95      -4.074  43.716  71.159  1.00  6.34           C  
ATOM    779  N   LYS A  96      -5.491  47.896  74.135  1.00  5.22           N  
ATOM    780  CA  LYS A  96      -6.391  48.464  75.106  1.00  6.37           C  
ATOM    781  C   LYS A  96      -7.313  49.412  74.391  1.00  7.22           C  
ATOM    782  O   LYS A  96      -8.463  49.429  74.675  1.00  8.76           O  
ATOM    783  CB  LYS A  96      -5.628  49.165  76.210  1.00  5.67           C  
ATOM    784  CG  LYS A  96      -6.460  49.267  77.413  1.00  8.49           C  
ATOM    785  CD  LYS A  96      -5.854  50.087  78.505  1.00  9.30           C  
ATOM    786  CE  LYS A  96      -6.831  50.031  79.694  1.00  9.16           C  
ATOM    787  NZ  LYS A  96      -7.538  48.677  79.553  1.00 11.83           N  
ATOM    788  N   SER A  97      -6.832  50.171  73.403  1.00  7.04           N  
ATOM    789  CA  SER A  97      -7.703  51.133  72.738  1.00  8.11           C  
ATOM    790  C   SER A  97      -8.743  50.460  71.807  1.00  9.11           C  
ATOM    791  O   SER A  97      -9.694  51.069  71.354  1.00 10.92           O  
ATOM    792  CB  SER A  97      -6.833  52.127  71.988  1.00  8.86           C  
ATOM    793  OG  SER A  97      -6.446  51.516  70.760  1.00  8.35           O  
ATOM    794  N   LYS A  98      -8.583  49.183  71.552  1.00  8.10           N  
ATOM    795  CA  LYS A  98      -9.489  48.493  70.699  1.00  9.30           C  
ATOM    796  C   LYS A  98     -10.563  47.913  71.661  1.00 11.02           C  
ATOM    797  O   LYS A  98     -11.626  47.419  71.213  1.00 12.57           O  
ATOM    798  CB  LYS A  98      -8.672  47.449  69.941  1.00 10.12           C  
ATOM    799  CG  LYS A  98      -9.414  46.371  69.344  1.00 13.22           C  
ATOM    800  CD  LYS A  98      -9.863  46.698  67.929  1.00 16.29           C  
ATOM    801  CE  LYS A  98     -10.805  45.583  67.428  1.00 17.38           C  
ATOM    802  NZ  LYS A  98     -10.062  44.276  67.307  1.00 17.11           N  
ATOM    803  N   GLY A  99     -10.295  48.038  72.962  1.00  7.54           N  
ATOM    804  CA  GLY A  99     -11.230  47.660  73.998  1.00  9.16           C  
ATOM    805  C   GLY A  99     -10.943  46.353  74.744  1.00  8.80           C  
ATOM    806  O   GLY A  99     -11.662  46.009  75.648  1.00  8.71           O  
ATOM    807  N   PHE A 100      -9.914  45.595  74.351  1.00  9.39           N  
ATOM    808  CA  PHE A 100      -9.549  44.357  75.101  1.00  8.29           C  
ATOM    809  C   PHE A 100      -9.289  44.642  76.567  1.00  6.78           C  
ATOM    810  O   PHE A 100      -8.727  45.666  76.885  1.00  6.79           O  
ATOM    811  CB  PHE A 100      -8.313  43.694  74.477  1.00  6.73           C  
ATOM    812  CG  PHE A 100      -8.578  43.149  73.153  1.00  7.32           C  
ATOM    813  CD1 PHE A 100      -9.238  41.946  73.017  1.00  8.32           C  
ATOM    814  CD2 PHE A 100      -8.232  43.871  72.000  1.00  9.22           C  
ATOM    815  CE1 PHE A 100      -9.541  41.452  71.755  1.00  9.93           C  
ATOM    816  CE2 PHE A 100      -8.534  43.396  70.749  1.00  9.96           C  
ATOM    817  CZ  PHE A 100      -9.182  42.163  70.627  1.00 11.01           C  
ATOM    818  N   LYS A 101      -9.752  43.764  77.452  1.00  6.85           N  
ATOM    819  CA  LYS A 101      -9.240  43.685  78.811  1.00  6.61           C  
ATOM    820  C   LYS A 101      -7.895  42.941  78.739  1.00  4.61           C  
ATOM    821  O   LYS A 101      -7.785  41.984  78.005  1.00  4.88           O  
ATOM    822  CB  LYS A 101     -10.190  42.884  79.721  1.00  7.29           C  
ATOM    823  CG  LYS A 101     -11.390  43.656  80.291  1.00  9.35           C  
ATOM    824  CD  LYS A 101     -12.351  42.651  80.940  1.00 10.53           C  
ATOM    825  CE  LYS A 101     -13.719  43.248  81.286  1.00 10.92           C  
ATOM    826  NZ  LYS A 101     -14.599  42.129  81.719  1.00 11.97           N  
ATOM    827  N   LEU A 102      -6.922  43.366  79.520  1.00  3.77           N  
ATOM    828  CA  LEU A 102      -5.590  42.823  79.551  1.00  2.44           C  
ATOM    829  C   LEU A 102      -5.246  42.425  80.984  1.00  3.34           C  
ATOM    830  O   LEU A 102      -5.605  43.139  81.972  1.00  2.29           O  
ATOM    831  CB  LEU A 102      -4.604  43.894  79.094  1.00  2.72           C  
ATOM    832  CG  LEU A 102      -4.866  44.513  77.719  1.00  3.26           C  
ATOM    833  CD1 LEU A 102      -3.758  45.532  77.314  1.00  3.33           C  
ATOM    834  CD2 LEU A 102      -4.948  43.410  76.688  1.00  3.11           C  
ATOM    835  N   ALA A 103      -4.491  41.335  81.110  1.00  2.23           N  
ATOM    836  CA  ALA A 103      -4.062  40.876  82.419  1.00  2.19           C  
ATOM    837  C   ALA A 103      -2.705  40.196  82.337  1.00  2.56           C  
ATOM    838  O   ALA A 103      -2.350  39.659  81.291  1.00  2.28           O  
ATOM    839  CB  ALA A 103      -5.110  39.895  83.016  1.00  2.25           C  
ATOM    840  N   VAL A 104      -1.980  40.191  83.444  1.00  1.61           N  
ATOM    841  CA  VAL A 104      -0.711  39.489  83.510  1.00  1.86           C  
ATOM    842  C   VAL A 104      -0.932  38.316  84.411  1.00  3.64           C  
ATOM    843  O   VAL A 104      -1.517  38.461  85.491  1.00  2.25           O  
ATOM    844  CB  VAL A 104       0.413  40.378  84.054  1.00  2.19           C  
ATOM    845  CG1 VAL A 104       1.726  39.593  84.211  1.00  2.69           C  
ATOM    846  CG2 VAL A 104       0.642  41.548  83.144  1.00  2.04           C  
ATOM    847  N   VAL A 105      -0.503  37.148  83.952  1.00  2.39           N  
ATOM    848  CA  VAL A 105      -0.551  35.909  84.755  1.00  3.06           C  
ATOM    849  C   VAL A 105       0.812  35.200  84.611  1.00  4.15           C  
ATOM    850  O   VAL A 105       1.246  34.896  83.500  1.00  3.44           O  
ATOM    851  CB  VAL A 105      -1.676  34.940  84.292  1.00  3.81           C  
ATOM    852  CG1 VAL A 105      -1.804  33.729  85.229  1.00  3.68           C  
ATOM    853  CG2 VAL A 105      -3.050  35.663  84.214  1.00  3.19           C  
ATOM    854  N   SER A 106       1.532  35.030  85.721  1.00  4.31           N  
ATOM    855  CA  SER A 106       2.847  34.416  85.669  1.00  5.30           C  
ATOM    856  C   SER A 106       3.225  33.743  86.971  1.00  6.29           C  
ATOM    857  O   SER A 106       2.502  33.818  87.967  1.00  4.52           O  
ATOM    858  CB  SER A 106       3.929  35.442  85.275  1.00  5.99           C  
ATOM    859  OG  SER A 106       4.437  36.141  86.398  1.00  5.26           O  
ATOM    860  N   ASN A 107       4.387  33.086  86.918  1.00  7.01           N  
ATOM    861  CA  ASN A 107       5.011  32.438  88.052  1.00  7.20           C  
ATOM    862  C   ASN A 107       5.753  33.384  88.964  1.00  6.65           C  
ATOM    863  O   ASN A 107       6.202  32.973  90.025  1.00  5.43           O  
ATOM    864  CB  ASN A 107       6.091  31.500  87.525  1.00  8.91           C  
ATOM    865  CG  ASN A 107       5.507  30.389  86.827  1.00  8.85           C  
ATOM    866  OD1 ASN A 107       4.420  29.982  87.183  1.00  9.26           O  
ATOM    867  ND2 ASN A 107       6.147  29.920  85.794  1.00 10.16           N  
ATOM    868  N   LYS A 108       5.947  34.616  88.526  1.00  5.42           N  
ATOM    869  CA  LYS A 108       6.727  35.516  89.334  1.00  5.07           C  
ATOM    870  C   LYS A 108       5.856  35.882  90.543  1.00  5.55           C  
ATOM    871  O   LYS A 108       4.638  35.935  90.425  1.00  4.56           O  
ATOM    872  CB  LYS A 108       7.130  36.726  88.513  1.00  4.58           C  
ATOM    873  CG  LYS A 108       8.177  37.640  89.207  1.00  5.36           C  
ATOM    874  CD  LYS A 108       8.381  38.967  88.414  1.00  5.14           C  
ATOM    875  CE  LYS A 108       9.010  38.666  87.096  1.00  5.24           C  
ATOM    876  NZ  LYS A 108      10.327  38.012  87.264  1.00  5.02           N  
ATOM    877  N   LEU A 109       6.463  36.116  91.705  1.00  5.00           N  
ATOM    878  CA  LEU A 109       5.759  36.589  92.881  1.00  5.48           C  
ATOM    879  C   LEU A 109       4.888  37.804  92.547  1.00  4.66           C  
ATOM    880  O   LEU A 109       5.360  38.706  91.868  1.00  4.34           O  
ATOM    881  CB  LEU A 109       6.835  36.983  93.905  1.00  6.40           C  
ATOM    882  CG  LEU A 109       6.585  36.914  95.416  1.00  8.78           C  
ATOM    883  CD1 LEU A 109       5.851  35.660  95.807  1.00  8.86           C  
ATOM    884  CD2 LEU A 109       7.917  36.983  96.154  1.00  8.48           C  
ATOM    885  N   GLU A 110       3.632  37.844  93.015  1.00  4.80           N  
ATOM    886  CA  GLU A 110       2.746  38.963  92.705  1.00  5.13           C  
ATOM    887  C   GLU A 110       3.320  40.338  93.100  1.00  4.87           C  
ATOM    888  O   GLU A 110       3.198  41.340  92.363  1.00  3.94           O  
ATOM    889  CB  GLU A 110       1.382  38.797  93.409  1.00  6.40           C  
ATOM    890  CG  GLU A 110       0.408  39.924  93.060  1.00  5.91           C  
ATOM    891  CD  GLU A 110      -0.865  39.943  93.965  1.00  8.59           C  
ATOM    892  OE1 GLU A 110      -1.537  38.888  94.034  1.00  9.08           O  
ATOM    893  OE2 GLU A 110      -1.191  40.999  94.628  1.00  8.54           O  
ATOM    894  N   GLU A 111       3.859  40.397  94.303  1.00  4.27           N  
ATOM    895  CA  GLU A 111       4.416  41.637  94.819  1.00  5.43           C  
ATOM    896  C   GLU A 111       5.502  42.193  93.919  1.00  4.14           C  
ATOM    897  O   GLU A 111       5.542  43.350  93.613  1.00  4.10           O  
ATOM    898  CB  GLU A 111       5.054  41.361  96.168  1.00  6.58           C  
ATOM    899  CG  GLU A 111       5.365  42.603  96.941  1.00  8.44           C  
ATOM    900  CD  GLU A 111       5.804  42.227  98.397  1.00 11.20           C  
ATOM    901  OE1 GLU A 111       4.912  41.855  99.263  1.00 11.17           O  
ATOM    902  OE2 GLU A 111       7.039  42.275  98.622  1.00 10.07           O  
ATOM    903  N   LEU A 112       6.391  41.323  93.502  1.00  4.10           N  
ATOM    904  CA  LEU A 112       7.437  41.688  92.591  1.00  4.34           C  
ATOM    905  C   LEU A 112       6.871  42.039  91.202  1.00  3.53           C  
ATOM    906  O   LEU A 112       7.314  42.994  90.589  1.00  3.34           O  
ATOM    907  CB  LEU A 112       8.374  40.523  92.472  1.00  4.12           C  
ATOM    908  CG  LEU A 112       9.642  40.811  91.731  1.00  4.64           C  
ATOM    909  CD1 LEU A 112      10.302  42.061  92.367  1.00  4.70           C  
ATOM    910  CD2 LEU A 112      10.507  39.570  91.911  1.00  4.54           C  
ATOM    911  N   SER A 113       5.922  41.258  90.699  1.00  3.35           N  
ATOM    912  CA  SER A 113       5.278  41.581  89.398  1.00  3.21           C  
ATOM    913  C   SER A 113       4.713  42.971  89.415  1.00  3.12           C  
ATOM    914  O   SER A 113       4.934  43.738  88.489  1.00  2.42           O  
ATOM    915  CB  SER A 113       4.165  40.607  89.121  1.00  3.40           C  
ATOM    916  OG  SER A 113       4.729  39.323  89.088  1.00  3.59           O  
ATOM    917  N   LYS A 114       4.049  43.330  90.521  1.00  3.42           N  
ATOM    918  CA  LYS A 114       3.391  44.650  90.593  1.00  3.90           C  
ATOM    919  C   LYS A 114       4.437  45.749  90.722  1.00  3.70           C  
ATOM    920  O   LYS A 114       4.273  46.820  90.199  1.00  3.70           O  
ATOM    921  CB  LYS A 114       2.362  44.738  91.716  1.00  4.14           C  
ATOM    922  CG  LYS A 114       1.165  43.764  91.556  1.00  4.33           C  
ATOM    923  CD  LYS A 114       0.150  43.851  92.684  1.00  5.33           C  
ATOM    924  CE  LYS A 114      -1.214  43.442  92.166  1.00  5.64           C  
ATOM    925  NZ  LYS A 114      -2.171  43.296  93.277  1.00  7.53           N  
ATOM    926  N   LYS A 115       5.508  45.464  91.423  1.00  3.71           N  
ATOM    927  CA  LYS A 115       6.530  46.473  91.672  1.00  3.75           C  
ATOM    928  C   LYS A 115       7.249  46.794  90.374  1.00  3.52           C  
ATOM    929  O   LYS A 115       7.495  47.932  90.053  1.00  3.84           O  
ATOM    930  CB  LYS A 115       7.502  45.932  92.755  1.00  4.28           C  
ATOM    931  CG  LYS A 115       8.784  46.735  92.941  1.00  5.32           C  
ATOM    932  CD  LYS A 115       9.047  47.201  94.403  1.00  8.74           C  
ATOM    933  CE  LYS A 115       8.928  48.721  94.370  1.00  9.72           C  
ATOM    934  NZ  LYS A 115       8.274  48.791  93.012  1.00  7.36           N  
ATOM    935  N   ILE A 116       7.564  45.759  89.602  1.00  2.77           N  
ATOM    936  CA  ILE A 116       8.250  45.906  88.341  1.00  2.92           C  
ATOM    937  C   ILE A 116       7.411  46.698  87.311  1.00  3.24           C  
ATOM    938  O   ILE A 116       7.886  47.659  86.703  1.00  3.01           O  
ATOM    939  CB  ILE A 116       8.628  44.518  87.821  1.00  2.90           C  
ATOM    940  CG1 ILE A 116       9.844  43.968  88.597  1.00  2.85           C  
ATOM    941  CG2 ILE A 116       8.941  44.544  86.339  1.00  2.66           C  
ATOM    942  CD1 ILE A 116      10.102  42.523  88.267  1.00  3.20           C  
ATOM    943  N   LEU A 117       6.139  46.319  87.174  1.00  2.88           N  
ATOM    944  CA  LEU A 117       5.291  46.981  86.219  1.00  3.62           C  
ATOM    945  C   LEU A 117       5.021  48.422  86.644  1.00  4.07           C  
ATOM    946  O   LEU A 117       4.938  49.271  85.790  1.00  4.66           O  
ATOM    947  CB  LEU A 117       3.997  46.188  86.007  1.00  3.24           C  
ATOM    948  CG  LEU A 117       4.264  44.829  85.373  1.00  3.34           C  
ATOM    949  CD1 LEU A 117       3.147  43.915  85.494  1.00  2.63           C  
ATOM    950  CD2 LEU A 117       4.746  44.991  83.910  1.00  2.88           C  
ATOM    951  N   ASP A 118       4.904  48.706  87.944  1.00  4.34           N  
ATOM    952  CA  ASP A 118       4.823  50.099  88.433  1.00  4.78           C  
ATOM    953  C   ASP A 118       6.056  50.913  88.009  1.00  4.28           C  
ATOM    954  O   ASP A 118       5.960  51.968  87.386  1.00  4.67           O  
ATOM    955  CB  ASP A 118       4.759  50.120  89.973  1.00  5.38           C  
ATOM    956  CG  ASP A 118       3.393  49.776  90.532  1.00  8.35           C  
ATOM    957  OD1 ASP A 118       2.432  49.675  89.717  1.00  8.38           O  
ATOM    958  OD2 ASP A 118       3.237  49.646  91.845  1.00 10.56           O  
ATOM    959  N   ILE A 119       7.241  50.422  88.344  1.00  4.06           N  
ATOM    960  CA  ILE A 119       8.461  51.099  87.965  1.00  3.79           C  
ATOM    961  C   ILE A 119       8.526  51.310  86.415  1.00  3.93           C  
ATOM    962  O   ILE A 119       8.950  52.338  85.923  1.00  3.58           O  
ATOM    963  CB  ILE A 119       9.674  50.306  88.460  1.00  3.48           C  
ATOM    964  CG1 ILE A 119       9.886  50.493  89.951  1.00  3.65           C  
ATOM    965  CG2 ILE A 119      10.944  50.733  87.672  1.00  3.21           C  
ATOM    966  CD1 ILE A 119      10.824  49.410  90.566  1.00  4.23           C  
ATOM    967  N   LEU A 120       8.120  50.326  85.630  1.00  3.87           N  
ATOM    968  CA  LEU A 120       8.174  50.486  84.176  1.00  4.08           C  
ATOM    969  C   LEU A 120       6.988  51.282  83.635  1.00  4.89           C  
ATOM    970  O   LEU A 120       6.824  51.391  82.434  1.00  6.30           O  
ATOM    971  CB  LEU A 120       8.196  49.111  83.504  1.00  3.87           C  
ATOM    972  CG  LEU A 120       9.493  48.315  83.850  1.00  3.70           C  
ATOM    973  CD1 LEU A 120       9.407  46.941  83.361  1.00  3.39           C  
ATOM    974  CD2 LEU A 120      10.717  49.023  83.339  1.00  3.32           C  
ATOM    975  N   ASN A 121       6.115  51.750  84.518  1.00  5.06           N  
ATOM    976  CA  ASN A 121       4.870  52.419  84.151  1.00  5.91           C  
ATOM    977  C   ASN A 121       3.930  51.635  83.198  1.00  5.90           C  
ATOM    978  O   ASN A 121       3.274  52.252  82.370  1.00  6.45           O  
ATOM    979  CB  ASN A 121       5.159  53.834  83.585  1.00  7.50           C  
ATOM    980  CG  ASN A 121       3.916  54.787  83.725  1.00  9.94           C  
ATOM    981  OD1 ASN A 121       3.448  55.407  82.743  1.00 11.82           O  
ATOM    982  ND2 ASN A 121       3.341  54.837  84.925  1.00 10.09           N  
ATOM    983  N   LEU A 122       3.851  50.308  83.306  1.00  4.29           N  
ATOM    984  CA  LEU A 122       2.864  49.523  82.537  1.00  4.82           C  
ATOM    985  C   LEU A 122       1.622  49.049  83.255  1.00  4.42           C  
ATOM    986  O   LEU A 122       0.717  48.498  82.638  1.00  3.10           O  
ATOM    987  CB  LEU A 122       3.504  48.281  81.981  1.00  4.46           C  
ATOM    988  CG  LEU A 122       4.692  48.621  81.077  1.00  4.87           C  
ATOM    989  CD1 LEU A 122       5.399  47.364  80.690  1.00  5.46           C  
ATOM    990  CD2 LEU A 122       4.215  49.381  79.843  1.00  5.63           C  
ATOM    991  N   SER A 123       1.590  49.254  84.577  1.00  4.58           N  
ATOM    992  CA  SER A 123       0.539  48.734  85.426  1.00  4.76           C  
ATOM    993  C   SER A 123      -0.785  49.183  84.914  1.00  3.76           C  
ATOM    994  O   SER A 123      -1.750  48.423  84.914  1.00  3.81           O  
ATOM    995  CB  SER A 123       0.693  49.291  86.868  1.00  5.29           C  
ATOM    996  OG  SER A 123       1.827  48.704  87.381  1.00  6.66           O  
ATOM    997  N   GLY A 124      -0.805  50.423  84.470  1.00  4.46           N  
ATOM    998  CA  GLY A 124      -2.007  51.051  83.950  1.00  4.55           C  
ATOM    999  C   GLY A 124      -2.707  50.270  82.868  1.00  4.03           C  
ATOM   1000  O   GLY A 124      -3.895  50.434  82.680  1.00  3.77           O  
ATOM   1001  N   TYR A 125      -1.984  49.446  82.106  1.00  3.38           N  
ATOM   1002  CA  TYR A 125      -2.629  48.836  80.948  1.00  3.59           C  
ATOM   1003  C   TYR A 125      -3.483  47.660  81.360  1.00  3.33           C  
ATOM   1004  O   TYR A 125      -4.281  47.153  80.576  1.00  3.08           O  
ATOM   1005  CB  TYR A 125      -1.613  48.340  79.923  1.00  3.23           C  
ATOM   1006  CG  TYR A 125      -0.923  49.431  79.178  1.00  3.42           C  
ATOM   1007  CD1 TYR A 125      -1.617  50.218  78.269  1.00  3.95           C  
ATOM   1008  CD2 TYR A 125       0.431  49.681  79.361  1.00  3.77           C  
ATOM   1009  CE1 TYR A 125      -0.989  51.256  77.585  1.00  3.84           C  
ATOM   1010  CE2 TYR A 125       1.075  50.705  78.646  1.00  4.06           C  
ATOM   1011  CZ  TYR A 125       0.347  51.490  77.783  1.00  4.22           C  
ATOM   1012  OH  TYR A 125       0.966  52.499  77.068  1.00  4.58           O  
ATOM   1013  N   PHE A 126      -3.270  47.219  82.591  1.00  3.22           N  
ATOM   1014  CA  PHE A 126      -3.773  45.933  83.051  1.00  3.49           C  
ATOM   1015  C   PHE A 126      -4.914  45.979  84.064  1.00  3.98           C  
ATOM   1016  O   PHE A 126      -4.856  46.687  85.071  1.00  3.83           O  
ATOM   1017  CB  PHE A 126      -2.617  45.093  83.601  1.00  3.12           C  
ATOM   1018  CG  PHE A 126      -1.583  44.763  82.554  1.00  2.70           C  
ATOM   1019  CD1 PHE A 126      -1.873  43.833  81.554  1.00  2.33           C  
ATOM   1020  CD2 PHE A 126      -0.338  45.361  82.582  1.00  1.99           C  
ATOM   1021  CE1 PHE A 126      -0.911  43.521  80.584  1.00  1.96           C  
ATOM   1022  CE2 PHE A 126       0.597  45.067  81.670  1.00  2.29           C  
ATOM   1023  CZ  PHE A 126       0.316  44.139  80.622  1.00  1.61           C  
ATOM   1024  N   ASP A 127      -5.923  45.168  83.775  1.00  4.56           N  
ATOM   1025  CA  ASP A 127      -7.051  44.994  84.638  1.00  5.37           C  
ATOM   1026  C   ASP A 127      -6.703  44.124  85.842  1.00  5.40           C  
ATOM   1027  O   ASP A 127      -7.368  44.194  86.834  1.00  5.10           O  
ATOM   1028  CB  ASP A 127      -8.201  44.405  83.839  1.00  6.56           C  
ATOM   1029  CG  ASP A 127      -8.641  45.312  82.649  1.00  9.25           C  
ATOM   1030  OD1 ASP A 127      -9.768  45.837  82.773  1.00 12.09           O  
ATOM   1031  OD2 ASP A 127      -7.884  45.493  81.599  1.00  9.95           O  
ATOM   1032  N   LEU A 128      -5.670  43.293  85.761  1.00  4.19           N  
ATOM   1033  CA  LEU A 128      -5.378  42.412  86.863  1.00  3.56           C  
ATOM   1034  C   LEU A 128      -3.960  41.891  86.646  1.00  3.58           C  
ATOM   1035  O   LEU A 128      -3.587  41.538  85.526  1.00  2.28           O  
ATOM   1036  CB  LEU A 128      -6.403  41.270  86.947  1.00  4.27           C  
ATOM   1037  CG  LEU A 128      -6.464  40.291  88.110  1.00  5.39           C  
ATOM   1038  CD1 LEU A 128      -6.654  41.053  89.426  1.00  6.77           C  
ATOM   1039  CD2 LEU A 128      -7.605  39.276  87.962  1.00  6.53           C  
ATOM   1040  N   ILE A 129      -3.179  41.906  87.718  1.00  2.35           N  
ATOM   1041  CA  ILE A 129      -1.848  41.327  87.741  1.00  3.09           C  
ATOM   1042  C   ILE A 129      -1.778  40.177  88.733  1.00  3.15           C  
ATOM   1043  O   ILE A 129      -2.011  40.336  89.932  1.00  3.37           O  
ATOM   1044  CB  ILE A 129      -0.732  42.418  88.047  1.00  3.15           C  
ATOM   1045  CG1 ILE A 129      -0.743  43.518  86.961  1.00  2.32           C  
ATOM   1046  CG2 ILE A 129       0.660  41.777  88.191  1.00  3.03           C  
ATOM   1047  CD1 ILE A 129      -0.143  44.861  87.437  1.00  3.19           C  
ATOM   1048  N   VAL A 130      -1.443  39.025  88.209  1.00  2.99           N  
ATOM   1049  CA  VAL A 130      -1.488  37.729  88.914  1.00  3.50           C  
ATOM   1050  C   VAL A 130      -0.129  37.033  88.939  1.00  3.87           C  
ATOM   1051  O   VAL A 130       0.525  36.929  87.888  1.00  3.58           O  
ATOM   1052  CB  VAL A 130      -2.497  36.759  88.231  1.00  3.79           C  
ATOM   1053  CG1 VAL A 130      -2.352  35.312  88.783  1.00  5.10           C  
ATOM   1054  CG2 VAL A 130      -3.939  37.260  88.414  1.00  4.40           C  
ATOM   1055  N   GLY A 131       0.311  36.624  90.128  1.00  3.94           N  
ATOM   1056  CA  GLY A 131       1.595  35.974  90.263  1.00  5.37           C  
ATOM   1057  C   GLY A 131       1.483  34.574  90.820  1.00  5.90           C  
ATOM   1058  O   GLY A 131       0.380  34.142  91.142  1.00  6.27           O  
ATOM   1059  N   GLY A 132       2.594  33.866  90.922  1.00  5.50           N  
ATOM   1060  CA  GLY A 132       2.565  32.482  91.375  1.00  7.33           C  
ATOM   1061  C   GLY A 132       1.791  32.267  92.679  1.00 10.50           C  
ATOM   1062  O   GLY A 132       1.028  31.302  92.794  1.00 12.26           O  
ATOM   1063  N   ASP A 133       1.958  33.174  93.650  1.00  9.56           N  
ATOM   1064  CA  ASP A 133       1.256  33.102  94.946  1.00 10.29           C  
ATOM   1065  C   ASP A 133      -0.199  33.614  95.019  1.00  9.82           C  
ATOM   1066  O   ASP A 133      -0.912  33.398  96.016  1.00 10.90           O  
ATOM   1067  CB  ASP A 133       2.083  33.837  95.994  1.00 10.80           C  
ATOM   1068  CG  ASP A 133       2.328  35.348  95.628  1.00  8.94           C  
ATOM   1069  OD1 ASP A 133       2.505  35.685  94.410  1.00  6.94           O  
ATOM   1070  OD2 ASP A 133       2.354  36.181  96.584  1.00  8.25           O  
ATOM   1071  N   THR A 134      -0.688  34.250  93.980  1.00  8.27           N  
ATOM   1072  CA  THR A 134      -1.959  34.950  94.097  1.00  8.25           C  
ATOM   1073  C   THR A 134      -3.123  34.024  94.503  1.00 11.00           C  
ATOM   1074  O   THR A 134      -3.983  34.411  95.310  1.00 10.91           O  
ATOM   1075  CB  THR A 134      -2.275  35.708  92.778  1.00  6.97           C  
ATOM   1076  OG1 THR A 134      -1.214  36.629  92.529  1.00  6.12           O  
ATOM   1077  CG2 THR A 134      -3.605  36.465  92.844  1.00  7.66           C  
ATOM   1078  N   PHE A 135      -3.175  32.820  93.911  1.00 10.03           N  
ATOM   1079  CA  PHE A 135      -4.275  31.924  94.169  1.00 11.47           C  
ATOM   1080  C   PHE A 135      -3.740  30.703  94.831  1.00 12.54           C  
ATOM   1081  O   PHE A 135      -4.471  29.787  95.085  1.00 14.61           O  
ATOM   1082  CB  PHE A 135      -4.993  31.576  92.875  1.00 10.61           C  
ATOM   1083  CG  PHE A 135      -5.569  32.774  92.187  1.00  9.68           C  
ATOM   1084  CD1 PHE A 135      -6.517  33.549  92.822  1.00  9.64           C  
ATOM   1085  CD2 PHE A 135      -5.152  33.139  90.923  1.00  8.19           C  
ATOM   1086  CE1 PHE A 135      -7.022  34.646  92.218  1.00  8.38           C  
ATOM   1087  CE2 PHE A 135      -5.672  34.191  90.330  1.00  7.35           C  
ATOM   1088  CZ  PHE A 135      -6.614  34.962  90.987  1.00  8.20           C  
ATOM   1089  N   GLY A 136      -2.441  30.702  95.100  1.00 14.43           N  
ATOM   1090  CA  GLY A 136      -1.817  29.652  95.899  1.00 15.13           C  
ATOM   1091  C   GLY A 136      -0.846  28.893  95.016  1.00 15.98           C  
ATOM   1092  O   GLY A 136      -1.188  28.406  93.907  1.00 17.15           O  
ATOM   1093  N   GLU A 137       0.373  28.779  95.512  1.00 16.79           N  
ATOM   1094  CA  GLU A 137       1.495  28.345  94.717  1.00 17.83           C  
ATOM   1095  C   GLU A 137       1.397  26.869  94.400  1.00 18.26           C  
ATOM   1096  O   GLU A 137       2.123  26.336  93.566  1.00 19.26           O  
ATOM   1097  CB  GLU A 137       2.750  28.574  95.534  1.00 19.69           C  
ATOM   1098  CG  GLU A 137       3.071  30.026  95.758  1.00 19.68           C  
ATOM   1099  CD  GLU A 137       4.547  30.207  95.790  1.00 19.92           C  
ATOM   1100  OE1 GLU A 137       5.239  29.316  95.221  1.00 23.46           O  
ATOM   1101  OE2 GLU A 137       5.014  31.183  96.424  1.00 20.74           O  
ATOM   1102  N   LYS A 138       0.510  26.207  95.103  1.00 17.25           N  
ATOM   1103  CA  LYS A 138       0.457  24.761  95.053  1.00 19.34           C  
ATOM   1104  C   LYS A 138      -0.645  24.284  94.109  1.00 16.58           C  
ATOM   1105  O   LYS A 138      -0.783  23.086  93.912  1.00 15.46           O  
ATOM   1106  CB  LYS A 138       0.135  24.286  96.451  1.00 18.90           C  
ATOM   1107  CG  LYS A 138      -0.606  25.398  97.258  1.00 22.29           C  
ATOM   1108  CD  LYS A 138      -1.361  24.755  98.451  1.00 24.02           C  
ATOM   1109  CE  LYS A 138      -1.314  25.637  99.717  1.00 24.02           C  
ATOM   1110  NZ  LYS A 138      -2.350  25.234 100.739  1.00 24.02           N  
ATOM   1111  N   LYS A 139      -1.411  25.223  93.550  1.00 14.73           N  
ATOM   1112  CA  LYS A 139      -2.606  24.903  92.772  1.00 12.78           C  
ATOM   1113  C   LYS A 139      -2.201  24.330  91.433  1.00 11.54           C  
ATOM   1114  O   LYS A 139      -1.193  24.730  90.888  1.00 11.23           O  
ATOM   1115  CB  LYS A 139      -3.425  26.145  92.574  1.00 12.23           C  
ATOM   1116  CG  LYS A 139      -3.877  26.753  93.861  1.00 14.87           C  
ATOM   1117  CD  LYS A 139      -5.130  26.070  94.386  1.00 15.05           C  
ATOM   1118  CE  LYS A 139      -5.466  26.564  95.803  1.00 17.60           C  
ATOM   1119  NZ  LYS A 139      -6.153  27.918  95.772  1.00 20.52           N  
ATOM   1120  N   PRO A 140      -2.973  23.364  90.905  1.00 10.39           N  
ATOM   1121  CA  PRO A 140      -2.621  22.726  89.648  1.00  9.04           C  
ATOM   1122  C   PRO A 140      -2.981  23.603  88.414  1.00  8.80           C  
ATOM   1123  O   PRO A 140      -3.837  24.444  88.464  1.00  8.42           O  
ATOM   1124  CB  PRO A 140      -3.468  21.458  89.648  1.00  8.58           C  
ATOM   1125  CG  PRO A 140      -4.569  21.695  90.548  1.00  7.50           C  
ATOM   1126  CD  PRO A 140      -4.255  22.873  91.431  1.00 10.42           C  
ATOM   1127  N   SER A 141      -2.293  23.422  87.312  1.00  8.40           N  
ATOM   1128  CA  SER A 141      -2.644  24.144  86.073  1.00  7.88           C  
ATOM   1129  C   SER A 141      -4.001  23.643  85.577  1.00  6.26           C  
ATOM   1130  O   SER A 141      -4.259  22.449  85.651  1.00  5.97           O  
ATOM   1131  CB  SER A 141      -1.581  23.770  85.028  1.00  7.94           C  
ATOM   1132  OG  SER A 141      -1.842  24.391  83.795  1.00  8.65           O  
ATOM   1133  N   PRO A 142      -4.853  24.525  85.014  1.00  6.44           N  
ATOM   1134  CA  PRO A 142      -4.633  25.957  84.780  1.00  5.51           C  
ATOM   1135  C   PRO A 142      -5.400  26.865  85.764  1.00  5.74           C  
ATOM   1136  O   PRO A 142      -6.001  27.849  85.322  1.00  4.49           O  
ATOM   1137  CB  PRO A 142      -5.210  26.123  83.390  1.00  4.67           C  
ATOM   1138  CG  PRO A 142      -6.483  25.272  83.483  1.00  5.27           C  
ATOM   1139  CD  PRO A 142      -6.090  24.071  84.333  1.00  5.36           C  
ATOM   1140  N   THR A 143      -5.369  26.587  87.061  1.00  5.68           N  
ATOM   1141  CA  THR A 143      -6.236  27.358  87.936  1.00  6.59           C  
ATOM   1142  C   THR A 143      -6.058  28.905  87.844  1.00  5.75           C  
ATOM   1143  O   THR A 143      -7.053  29.646  87.867  1.00  5.59           O  
ATOM   1144  CB  THR A 143      -6.281  26.866  89.431  1.00  7.99           C  
ATOM   1145  OG1 THR A 143      -5.014  26.426  89.829  1.00  7.63           O  
ATOM   1146  CG2 THR A 143      -7.262  25.668  89.616  1.00  9.27           C  
ATOM   1147  N   PRO A 144      -4.811  29.385  87.757  1.00  5.97           N  
ATOM   1148  CA  PRO A 144      -4.555  30.834  87.736  1.00  6.42           C  
ATOM   1149  C   PRO A 144      -5.186  31.486  86.484  1.00  5.28           C  
ATOM   1150  O   PRO A 144      -5.735  32.545  86.596  1.00  4.79           O  
ATOM   1151  CB  PRO A 144      -3.027  30.925  87.582  1.00  7.10           C  
ATOM   1152  CG  PRO A 144      -2.503  29.531  87.990  1.00  7.16           C  
ATOM   1153  CD  PRO A 144      -3.571  28.611  87.503  1.00  6.61           C  
ATOM   1154  N   VAL A 145      -5.087  30.842  85.331  1.00  4.55           N  
ATOM   1155  CA  VAL A 145      -5.802  31.307  84.156  1.00  4.64           C  
ATOM   1156  C   VAL A 145      -7.283  31.321  84.398  1.00  4.76           C  
ATOM   1157  O   VAL A 145      -7.920  32.309  84.111  1.00  4.02           O  
ATOM   1158  CB  VAL A 145      -5.593  30.409  82.965  1.00  4.71           C  
ATOM   1159  CG1 VAL A 145      -6.440  30.912  81.746  1.00  4.33           C  
ATOM   1160  CG2 VAL A 145      -4.128  30.315  82.683  1.00  5.97           C  
ATOM   1161  N   LEU A 146      -7.828  30.223  84.900  1.00  4.53           N  
ATOM   1162  CA  LEU A 146      -9.270  30.148  85.120  1.00  5.62           C  
ATOM   1163  C   LEU A 146      -9.741  31.197  86.105  1.00  5.33           C  
ATOM   1164  O   LEU A 146     -10.720  31.831  85.878  1.00  6.89           O  
ATOM   1165  CB  LEU A 146      -9.699  28.766  85.623  1.00  5.38           C  
ATOM   1166  CG  LEU A 146      -9.379  27.666  84.608  1.00  5.92           C  
ATOM   1167  CD1 LEU A 146      -9.692  26.343  85.303  1.00  5.57           C  
ATOM   1168  CD2 LEU A 146     -10.180  27.901  83.360  1.00  4.43           C  
ATOM   1169  N   LYS A 147      -9.050  31.370  87.208  1.00  5.76           N  
ATOM   1170  CA  LYS A 147      -9.494  32.258  88.270  1.00  5.89           C  
ATOM   1171  C   LYS A 147      -9.364  33.691  87.833  1.00  5.96           C  
ATOM   1172  O   LYS A 147     -10.168  34.522  88.184  1.00  5.63           O  
ATOM   1173  CB  LYS A 147      -8.669  32.002  89.541  1.00  7.64           C  
ATOM   1174  CG  LYS A 147      -9.119  30.733  90.309  1.00  8.71           C  
ATOM   1175  CD  LYS A 147      -7.933  30.154  91.086  1.00 11.28           C  
ATOM   1176  CE  LYS A 147      -8.311  29.647  92.473  1.00 14.06           C  
ATOM   1177  NZ  LYS A 147      -7.134  28.897  92.998  1.00 13.89           N  
ATOM   1178  N   THR A 148      -8.336  33.983  87.049  1.00  5.96           N  
ATOM   1179  CA  THR A 148      -8.188  35.319  86.494  1.00  5.37           C  
ATOM   1180  C   THR A 148      -9.358  35.611  85.600  1.00  5.76           C  
ATOM   1181  O   THR A 148      -9.940  36.664  85.683  1.00  5.71           O  
ATOM   1182  CB  THR A 148      -6.902  35.440  85.672  1.00  5.16           C  
ATOM   1183  OG1 THR A 148      -5.796  35.103  86.511  1.00  4.42           O  
ATOM   1184  CG2 THR A 148      -6.710  36.865  85.095  1.00  4.15           C  
ATOM   1185  N   LEU A 149      -9.727  34.662  84.754  1.00  5.61           N  
ATOM   1186  CA  LEU A 149     -10.855  34.875  83.874  1.00  6.42           C  
ATOM   1187  C   LEU A 149     -12.165  35.034  84.634  1.00  7.49           C  
ATOM   1188  O   LEU A 149     -12.968  35.900  84.292  1.00  8.51           O  
ATOM   1189  CB  LEU A 149     -10.961  33.762  82.828  1.00  6.81           C  
ATOM   1190  CG  LEU A 149      -9.837  33.861  81.805  1.00  5.64           C  
ATOM   1191  CD1 LEU A 149      -9.692  32.573  80.925  1.00  6.51           C  
ATOM   1192  CD2 LEU A 149      -9.945  35.125  80.976  1.00  6.04           C  
ATOM   1193  N   GLU A 150     -12.406  34.191  85.623  1.00  7.12           N  
ATOM   1194  CA  GLU A 150     -13.573  34.363  86.511  1.00  7.67           C  
ATOM   1195  C   GLU A 150     -13.636  35.746  87.186  1.00  8.22           C  
ATOM   1196  O   GLU A 150     -14.683  36.396  87.205  1.00  8.34           O  
ATOM   1197  CB  GLU A 150     -13.545  33.254  87.558  1.00  8.73           C  
ATOM   1198  CG  GLU A 150     -13.601  31.871  86.851  1.00  9.73           C  
ATOM   1199  CD  GLU A 150     -13.216  30.676  87.765  1.00 10.94           C  
ATOM   1200  OE1 GLU A 150     -13.084  30.878  89.003  1.00 11.88           O  
ATOM   1201  OE2 GLU A 150     -13.089  29.522  87.236  1.00 11.25           O  
ATOM   1202  N   ILE A 151     -12.501  36.247  87.663  1.00  7.10           N  
ATOM   1203  CA  ILE A 151     -12.481  37.610  88.171  1.00  7.38           C  
ATOM   1204  C   ILE A 151     -12.850  38.667  87.164  1.00  8.64           C  
ATOM   1205  O   ILE A 151     -13.639  39.571  87.471  1.00  8.22           O  
ATOM   1206  CB  ILE A 151     -11.161  37.952  88.805  1.00  8.23           C  
ATOM   1207  CG1 ILE A 151     -11.026  37.132  90.114  1.00  7.64           C  
ATOM   1208  CG2 ILE A 151     -11.134  39.482  89.119  1.00  7.93           C  
ATOM   1209  CD1 ILE A 151      -9.591  36.994  90.665  1.00  7.41           C  
ATOM   1210  N   LEU A 152     -12.310  38.539  85.955  1.00  6.76           N  
ATOM   1211  CA  LEU A 152     -12.588  39.491  84.892  1.00  8.92           C  
ATOM   1212  C   LEU A 152     -14.003  39.353  84.321  1.00  9.84           C  
ATOM   1213  O   LEU A 152     -14.424  40.156  83.507  1.00  9.87           O  
ATOM   1214  CB  LEU A 152     -11.572  39.292  83.745  1.00  6.57           C  
ATOM   1215  CG  LEU A 152     -10.131  39.632  84.151  1.00  7.20           C  
ATOM   1216  CD1 LEU A 152      -9.074  39.424  83.031  1.00  5.89           C  
ATOM   1217  CD2 LEU A 152     -10.017  41.053  84.746  1.00  5.80           C  
ATOM   1218  N   GLY A 153     -14.699  38.287  84.689  1.00  9.80           N  
ATOM   1219  CA  GLY A 153     -16.030  38.081  84.178  1.00  9.67           C  
ATOM   1220  C   GLY A 153     -16.034  37.573  82.739  1.00 11.09           C  
ATOM   1221  O   GLY A 153     -16.964  37.867  81.995  1.00 10.61           O  
ATOM   1222  N   GLU A 154     -15.026  36.819  82.322  1.00  9.88           N  
ATOM   1223  CA  GLU A 154     -14.940  36.475  80.898  1.00 11.06           C  
ATOM   1224  C   GLU A 154     -14.803  34.964  80.641  1.00 10.47           C  
ATOM   1225  O   GLU A 154     -14.297  34.254  81.476  1.00  9.77           O  
ATOM   1226  CB  GLU A 154     -13.740  37.185  80.225  1.00 11.01           C  
ATOM   1227  CG  GLU A 154     -13.712  38.687  80.328  1.00 10.67           C  
ATOM   1228  CD  GLU A 154     -14.759  39.354  79.512  1.00 11.15           C  
ATOM   1229  OE1 GLU A 154     -15.457  38.714  78.704  1.00 12.52           O  
ATOM   1230  OE2 GLU A 154     -14.892  40.564  79.674  1.00 13.83           O  
ATOM   1231  N   GLU A 155     -15.263  34.492  79.492  1.00 10.28           N  
ATOM   1232  CA  GLU A 155     -15.135  33.064  79.171  1.00 12.25           C  
ATOM   1233  C   GLU A 155     -13.796  32.731  78.539  1.00 10.59           C  
ATOM   1234  O   GLU A 155     -13.297  33.526  77.764  1.00  8.38           O  
ATOM   1235  CB  GLU A 155     -16.135  32.661  78.099  1.00 14.22           C  
ATOM   1236  CG  GLU A 155     -17.507  33.262  78.178  1.00 17.57           C  
ATOM   1237  CD  GLU A 155     -18.465  32.368  77.428  1.00 23.84           C  
ATOM   1238  OE1 GLU A 155     -18.573  32.491  76.159  1.00 24.02           O  
ATOM   1239  OE2 GLU A 155     -19.078  31.509  78.131  1.00 24.02           O  
ATOM   1240  N   PRO A 156     -13.280  31.516  78.807  1.00 10.31           N  
ATOM   1241  CA  PRO A 156     -12.043  30.989  78.197  1.00  9.17           C  
ATOM   1242  C   PRO A 156     -12.021  31.094  76.656  1.00  9.84           C  
ATOM   1243  O   PRO A 156     -11.040  31.515  76.082  1.00  8.52           O  
ATOM   1244  CB  PRO A 156     -11.996  29.538  78.694  1.00  8.40           C  
ATOM   1245  CG  PRO A 156     -12.698  29.585  80.008  1.00  9.50           C  
ATOM   1246  CD  PRO A 156     -13.756  30.672  79.924  1.00  9.25           C  
ATOM   1247  N   GLU A 157     -13.123  30.788  75.995  1.00 11.82           N  
ATOM   1248  CA  GLU A 157     -13.123  30.740  74.559  1.00 12.30           C  
ATOM   1249  C   GLU A 157     -12.977  32.141  73.984  1.00 11.44           C  
ATOM   1250  O   GLU A 157     -12.670  32.304  72.796  1.00 11.85           O  
ATOM   1251  CB  GLU A 157     -14.410  30.111  74.076  1.00 14.34           C  
ATOM   1252  CG  GLU A 157     -15.547  31.026  74.189  1.00 16.49           C  
ATOM   1253  CD  GLU A 157     -16.908  30.344  73.929  1.00 21.97           C  
ATOM   1254  OE1 GLU A 157     -17.048  29.736  72.836  1.00 23.05           O  
ATOM   1255  OE2 GLU A 157     -17.834  30.454  74.818  1.00 24.02           O  
ATOM   1256  N   LYS A 158     -13.173  33.151  74.823  1.00 10.19           N  
ATOM   1257  CA  LYS A 158     -12.981  34.516  74.365  1.00 10.21           C  
ATOM   1258  C   LYS A 158     -11.649  35.094  74.863  1.00  8.33           C  
ATOM   1259  O   LYS A 158     -11.475  36.303  74.850  1.00  7.29           O  
ATOM   1260  CB  LYS A 158     -14.098  35.457  74.888  1.00 11.94           C  
ATOM   1261  CG  LYS A 158     -15.526  35.061  74.616  1.00 13.63           C  
ATOM   1262  CD  LYS A 158     -15.867  34.993  73.131  1.00 15.46           C  
ATOM   1263  CE  LYS A 158     -17.408  34.708  72.956  1.00 20.11           C  
ATOM   1264  NZ  LYS A 158     -17.934  33.617  73.913  1.00 21.83           N  
ATOM   1265  N   ALA A 159     -10.751  34.248  75.351  1.00  6.83           N  
ATOM   1266  CA  ALA A 159      -9.482  34.758  75.864  1.00  6.04           C  
ATOM   1267  C   ALA A 159      -8.351  34.281  75.017  1.00  5.32           C  
ATOM   1268  O   ALA A 159      -8.388  33.151  74.550  1.00  5.07           O  
ATOM   1269  CB  ALA A 159      -9.234  34.255  77.292  1.00  5.79           C  
ATOM   1270  N   LEU A 160      -7.338  35.131  74.873  1.00  4.24           N  
ATOM   1271  CA  LEU A 160      -6.039  34.763  74.309  1.00  4.45           C  
ATOM   1272  C   LEU A 160      -4.885  34.789  75.349  1.00  3.68           C  
ATOM   1273  O   LEU A 160      -4.674  35.786  76.056  1.00  2.92           O  
ATOM   1274  CB  LEU A 160      -5.710  35.688  73.150  1.00  4.14           C  
ATOM   1275  CG  LEU A 160      -4.427  35.356  72.383  1.00  4.48           C  
ATOM   1276  CD1 LEU A 160      -4.378  33.963  71.760  1.00  3.59           C  
ATOM   1277  CD2 LEU A 160      -4.135  36.455  71.373  1.00  3.90           C  
ATOM   1278  N   ILE A 161      -4.161  33.682  75.447  1.00  3.18           N  
ATOM   1279  CA  ILE A 161      -2.999  33.601  76.291  1.00  3.14           C  
ATOM   1280  C   ILE A 161      -1.738  33.785  75.432  1.00  3.11           C  
ATOM   1281  O   ILE A 161      -1.550  33.058  74.449  1.00  2.53           O  
ATOM   1282  CB  ILE A 161      -3.042  32.238  76.906  1.00  4.18           C  
ATOM   1283  CG1 ILE A 161      -4.015  32.253  78.052  1.00  4.62           C  
ATOM   1284  CG2 ILE A 161      -1.738  31.788  77.352  1.00  4.17           C  
ATOM   1285  CD1 ILE A 161      -3.575  31.207  79.031  1.00  6.49           C  
ATOM   1286  N   VAL A 162      -0.889  34.757  75.783  1.00  2.64           N  
ATOM   1287  CA  VAL A 162       0.358  35.033  75.103  1.00  2.38           C  
ATOM   1288  C   VAL A 162       1.505  34.690  76.057  1.00  2.97           C  
ATOM   1289  O   VAL A 162       1.572  35.197  77.199  1.00  2.79           O  
ATOM   1290  CB  VAL A 162       0.462  36.516  74.727  1.00  2.61           C  
ATOM   1291  CG1 VAL A 162       1.736  36.805  73.897  1.00  2.19           C  
ATOM   1292  CG2 VAL A 162      -0.771  37.036  73.971  1.00  2.19           C  
ATOM   1293  N   GLY A 163       2.425  33.835  75.614  1.00  2.50           N  
ATOM   1294  CA  GLY A 163       3.623  33.517  76.371  1.00  3.45           C  
ATOM   1295  C   GLY A 163       4.667  32.865  75.483  1.00  4.01           C  
ATOM   1296  O   GLY A 163       4.328  32.406  74.407  1.00  2.98           O  
ATOM   1297  N   ASP A 164       5.921  32.869  75.938  1.00  3.81           N  
ATOM   1298  CA  ASP A 164       7.037  32.311  75.215  1.00  4.59           C  
ATOM   1299  C   ASP A 164       7.317  30.822  75.520  1.00  4.95           C  
ATOM   1300  O   ASP A 164       8.046  30.191  74.765  1.00  5.43           O  
ATOM   1301  CB  ASP A 164       8.312  33.158  75.415  1.00  4.72           C  
ATOM   1302  CG  ASP A 164       8.882  33.060  76.837  1.00  5.54           C  
ATOM   1303  OD1 ASP A 164       8.085  32.967  77.800  1.00  5.95           O  
ATOM   1304  OD2 ASP A 164      10.119  33.095  77.017  1.00  5.45           O  
ATOM   1305  N   THR A 165       6.725  30.269  76.576  1.00  5.03           N  
ATOM   1306  CA  THR A 165       6.972  28.860  76.940  1.00  4.91           C  
ATOM   1307  C   THR A 165       5.881  27.868  76.510  1.00  6.00           C  
ATOM   1308  O   THR A 165       4.722  28.241  76.365  1.00  4.78           O  
ATOM   1309  CB  THR A 165       7.251  28.707  78.434  1.00  5.97           C  
ATOM   1310  OG1 THR A 165       6.040  28.582  79.170  1.00  6.08           O  
ATOM   1311  CG2 THR A 165       8.093  29.932  78.987  1.00  6.53           C  
ATOM   1312  N   ASP A 166       6.284  26.617  76.262  1.00  6.38           N  
ATOM   1313  CA  ASP A 166       5.340  25.536  75.969  1.00  7.16           C  
ATOM   1314  C   ASP A 166       4.371  25.388  77.161  1.00  6.25           C  
ATOM   1315  O   ASP A 166       3.218  25.062  76.990  1.00  6.14           O  
ATOM   1316  CB  ASP A 166       6.059  24.214  75.645  1.00  6.46           C  
ATOM   1317  CG  ASP A 166       6.650  24.163  74.185  1.00  9.81           C  
ATOM   1318  OD1 ASP A 166       6.252  24.965  73.261  1.00  8.78           O  
ATOM   1319  OD2 ASP A 166       7.539  23.302  73.960  1.00  9.86           O  
ATOM   1320  N   ALA A 167       4.833  25.666  78.369  1.00  6.35           N  
ATOM   1321  CA  ALA A 167       3.961  25.556  79.554  1.00  6.11           C  
ATOM   1322  C   ALA A 167       2.799  26.578  79.562  1.00  6.23           C  
ATOM   1323  O   ALA A 167       1.667  26.247  79.987  1.00  5.99           O  
ATOM   1324  CB  ALA A 167       4.782  25.669  80.797  1.00  7.20           C  
ATOM   1325  N   ASP A 168       3.082  27.806  79.104  1.00  5.11           N  
ATOM   1326  CA  ASP A 168       2.038  28.826  78.871  1.00  6.02           C  
ATOM   1327  C   ASP A 168       1.014  28.315  77.885  1.00  5.57           C  
ATOM   1328  O   ASP A 168      -0.168  28.457  78.120  1.00  5.17           O  
ATOM   1329  CB  ASP A 168       2.604  30.154  78.342  1.00  5.09           C  
ATOM   1330  CG  ASP A 168       3.651  30.778  79.314  1.00  6.69           C  
ATOM   1331  OD1 ASP A 168       3.596  30.417  80.513  1.00  7.00           O  
ATOM   1332  OD2 ASP A 168       4.516  31.603  78.884  1.00  5.79           O  
ATOM   1333  N   ILE A 169       1.479  27.764  76.761  1.00  5.23           N  
ATOM   1334  CA  ILE A 169       0.548  27.275  75.751  1.00  5.38           C  
ATOM   1335  C   ILE A 169      -0.261  26.107  76.334  1.00  5.19           C  
ATOM   1336  O   ILE A 169      -1.484  26.053  76.176  1.00  5.01           O  
ATOM   1337  CB  ILE A 169       1.267  26.814  74.446  1.00  6.32           C  
ATOM   1338  CG1 ILE A 169       2.192  27.946  73.919  1.00  5.18           C  
ATOM   1339  CG2 ILE A 169       0.212  26.348  73.386  1.00  6.72           C  
ATOM   1340  CD1 ILE A 169       1.448  29.323  73.552  1.00  4.42           C  
ATOM   1341  N   GLU A 170       0.422  25.185  76.991  1.00  5.41           N  
ATOM   1342  CA  GLU A 170      -0.258  24.035  77.568  1.00  6.36           C  
ATOM   1343  C   GLU A 170      -1.286  24.501  78.583  1.00  6.05           C  
ATOM   1344  O   GLU A 170      -2.345  23.893  78.681  1.00  7.58           O  
ATOM   1345  CB  GLU A 170       0.730  23.003  78.122  1.00  8.00           C  
ATOM   1346  CG  GLU A 170       0.116  21.700  78.691  1.00 10.89           C  
ATOM   1347  CD  GLU A 170       1.183  20.794  79.393  1.00 16.87           C  
ATOM   1348  OE1 GLU A 170       2.437  21.075  79.222  1.00 16.06           O  
ATOM   1349  OE2 GLU A 170       0.777  19.830  80.156  1.00 18.31           O  
ATOM   1350  N   ALA A 171      -1.073  25.601  79.294  1.00  5.44           N  
ATOM   1351  CA  ALA A 171      -2.103  25.996  80.266  1.00  5.74           C  
ATOM   1352  C   ALA A 171      -3.312  26.579  79.563  1.00  5.68           C  
ATOM   1353  O   ALA A 171      -4.400  26.314  79.994  1.00  5.25           O  
ATOM   1354  CB  ALA A 171      -1.586  26.973  81.311  1.00  6.53           C  
ATOM   1355  N   GLY A 172      -3.105  27.390  78.514  1.00  4.17           N  
ATOM   1356  CA  GLY A 172      -4.171  27.849  77.605  1.00  5.66           C  
ATOM   1357  C   GLY A 172      -5.038  26.695  77.070  1.00  5.78           C  
ATOM   1358  O   GLY A 172      -6.255  26.692  77.197  1.00  5.24           O  
ATOM   1359  N   LYS A 173      -4.390  25.658  76.556  1.00  5.30           N  
ATOM   1360  CA  LYS A 173      -5.121  24.474  76.079  1.00  5.55           C  
ATOM   1361  C   LYS A 173      -5.900  23.741  77.134  1.00  6.35           C  
ATOM   1362  O   LYS A 173      -7.016  23.343  76.889  1.00  6.44           O  
ATOM   1363  CB  LYS A 173      -4.197  23.526  75.355  1.00  5.89           C  
ATOM   1364  CG  LYS A 173      -3.613  24.236  74.155  1.00  6.82           C  
ATOM   1365  CD  LYS A 173      -2.773  23.321  73.327  1.00  7.88           C  
ATOM   1366  CE  LYS A 173      -2.708  23.895  71.920  1.00  8.50           C  
ATOM   1367  NZ  LYS A 173      -1.635  23.157  71.276  1.00  8.63           N  
ATOM   1368  N   ARG A 174      -5.366  23.629  78.339  1.00  5.64           N  
ATOM   1369  CA  ARG A 174      -6.126  23.025  79.438  1.00  5.64           C  
ATOM   1370  C   ARG A 174      -7.324  23.905  79.779  1.00  5.65           C  
ATOM   1371  O   ARG A 174      -8.407  23.395  80.012  1.00  5.48           O  
ATOM   1372  CB  ARG A 174      -5.245  22.862  80.648  1.00  5.19           C  
ATOM   1373  CG  ARG A 174      -4.245  21.767  80.541  1.00  6.49           C  
ATOM   1374  CD  ARG A 174      -3.644  21.584  81.883  1.00  6.29           C  
ATOM   1375  NE  ARG A 174      -2.558  20.618  81.950  1.00  8.69           N  
ATOM   1376  CZ  ARG A 174      -2.701  19.296  82.054  1.00  9.41           C  
ATOM   1377  NH1 ARG A 174      -3.902  18.717  82.006  1.00  7.15           N  
ATOM   1378  NH2 ARG A 174      -1.614  18.529  82.122  1.00 10.85           N  
ATOM   1379  N   ALA A 175      -7.161  25.218  79.781  1.00  5.06           N  
ATOM   1380  CA  ALA A 175      -8.289  26.104  80.101  1.00  5.08           C  
ATOM   1381  C   ALA A 175      -9.300  26.288  78.951  1.00  5.67           C  
ATOM   1382  O   ALA A 175     -10.391  26.861  79.116  1.00  5.19           O  
ATOM   1383  CB  ALA A 175      -7.757  27.498  80.601  1.00  4.86           C  
ATOM   1384  N   GLY A 176      -8.916  25.836  77.772  1.00  6.25           N  
ATOM   1385  CA  GLY A 176      -9.735  25.997  76.580  1.00  6.13           C  
ATOM   1386  C   GLY A 176      -9.681  27.397  75.984  1.00  6.76           C  
ATOM   1387  O   GLY A 176     -10.649  27.824  75.366  1.00  7.55           O  
ATOM   1388  N   THR A 177      -8.598  28.143  76.184  1.00  5.87           N  
ATOM   1389  CA  THR A 177      -8.511  29.478  75.594  1.00  6.08           C  
ATOM   1390  C   THR A 177      -7.799  29.356  74.238  1.00  5.92           C  
ATOM   1391  O   THR A 177      -7.292  28.267  73.901  1.00  6.67           O  
ATOM   1392  CB  THR A 177      -7.702  30.507  76.501  1.00  5.64           C  
ATOM   1393  OG1 THR A 177      -6.336  30.174  76.443  1.00  4.78           O  
ATOM   1394  CG2 THR A 177      -8.084  30.475  77.985  1.00  6.22           C  
ATOM   1395  N   LYS A 178      -7.750  30.449  73.473  1.00  5.16           N  
ATOM   1396  CA  LYS A 178      -6.836  30.564  72.345  1.00  5.83           C  
ATOM   1397  C   LYS A 178      -5.413  30.817  72.871  1.00  4.69           C  
ATOM   1398  O   LYS A 178      -5.228  31.306  73.992  1.00  4.04           O  
ATOM   1399  CB  LYS A 178      -7.248  31.702  71.402  1.00  5.55           C  
ATOM   1400  CG  LYS A 178      -8.664  31.561  70.896  1.00  8.23           C  
ATOM   1401  CD  LYS A 178      -8.897  30.123  70.423  1.00 10.28           C  
ATOM   1402  CE  LYS A 178     -10.164  29.978  69.602  1.00 13.76           C  
ATOM   1403  NZ  LYS A 178     -11.400  30.013  70.486  1.00 12.98           N  
ATOM   1404  N   THR A 179      -4.416  30.466  72.074  1.00  4.52           N  
ATOM   1405  CA  THR A 179      -3.052  30.620  72.543  1.00  4.25           C  
ATOM   1406  C   THR A 179      -2.196  31.268  71.479  1.00  3.85           C  
ATOM   1407  O   THR A 179      -2.454  31.078  70.312  1.00  4.24           O  
ATOM   1408  CB  THR A 179      -2.472  29.283  72.946  1.00  4.23           C  
ATOM   1409  OG1 THR A 179      -2.554  28.400  71.827  1.00  5.13           O  
ATOM   1410  CG2 THR A 179      -3.266  28.661  74.060  1.00  4.43           C  
ATOM   1411  N   ALA A 180      -1.213  32.039  71.898  1.00  2.82           N  
ATOM   1412  CA  ALA A 180      -0.192  32.601  71.000  1.00  3.42           C  
ATOM   1413  C   ALA A 180       1.213  32.464  71.582  1.00  3.43           C  
ATOM   1414  O   ALA A 180       1.437  32.857  72.734  1.00  2.44           O  
ATOM   1415  CB  ALA A 180      -0.458  34.042  70.628  1.00  3.44           C  
ATOM   1416  N   LEU A 181       2.149  31.950  70.769  1.00  3.43           N  
ATOM   1417  CA  LEU A 181       3.584  31.915  71.104  1.00  3.51           C  
ATOM   1418  C   LEU A 181       4.273  33.202  70.794  1.00  4.19           C  
ATOM   1419  O   LEU A 181       4.188  33.724  69.698  1.00  4.30           O  
ATOM   1420  CB  LEU A 181       4.323  30.839  70.339  1.00  4.61           C  
ATOM   1421  CG  LEU A 181       4.614  29.481  70.907  1.00  4.81           C  
ATOM   1422  CD1 LEU A 181       5.309  28.616  69.846  1.00  5.62           C  
ATOM   1423  CD2 LEU A 181       5.455  29.614  72.183  1.00  5.45           C  
ATOM   1424  N   ALA A 182       4.998  33.701  71.779  1.00  4.27           N  
ATOM   1425  CA  ALA A 182       5.759  34.903  71.670  1.00  3.94           C  
ATOM   1426  C   ALA A 182       7.196  34.521  71.340  1.00  4.80           C  
ATOM   1427  O   ALA A 182       7.973  34.203  72.219  1.00  4.96           O  
ATOM   1428  CB  ALA A 182       5.710  35.617  72.991  1.00  3.68           C  
ATOM   1429  N   LEU A 183       7.575  34.588  70.084  1.00  4.72           N  
ATOM   1430  CA  LEU A 183       8.902  34.129  69.682  1.00  5.78           C  
ATOM   1431  C   LEU A 183      10.081  35.026  70.007  1.00  5.90           C  
ATOM   1432  O   LEU A 183      11.250  34.639  69.793  1.00  5.66           O  
ATOM   1433  CB  LEU A 183       8.905  33.735  68.206  1.00  6.09           C  
ATOM   1434  CG  LEU A 183       7.884  32.676  67.805  1.00  5.67           C  
ATOM   1435  CD1 LEU A 183       7.911  32.511  66.266  1.00  6.34           C  
ATOM   1436  CD2 LEU A 183       8.217  31.395  68.459  1.00  6.50           C  
ATOM   1437  N   TRP A 184       9.798  36.217  70.514  1.00  4.56           N  
ATOM   1438  CA  TRP A 184      10.853  37.164  70.843  1.00  4.87           C  
ATOM   1439  C   TRP A 184      11.475  36.910  72.238  1.00  4.77           C  
ATOM   1440  O   TRP A 184      12.347  37.639  72.643  1.00  4.46           O  
ATOM   1441  CB  TRP A 184      10.317  38.616  70.753  1.00  4.60           C  
ATOM   1442  CG  TRP A 184       9.230  38.898  71.739  1.00  3.95           C  
ATOM   1443  CD1 TRP A 184       9.374  39.311  73.040  1.00  3.60           C  
ATOM   1444  CD2 TRP A 184       7.807  38.804  71.500  1.00  4.61           C  
ATOM   1445  NE1 TRP A 184       8.125  39.479  73.618  1.00  3.59           N  
ATOM   1446  CE2 TRP A 184       7.154  39.172  72.699  1.00  3.67           C  
ATOM   1447  CE3 TRP A 184       7.030  38.456  70.373  1.00  4.39           C  
ATOM   1448  CZ2 TRP A 184       5.741  39.197  72.819  1.00  3.19           C  
ATOM   1449  CZ3 TRP A 184       5.619  38.457  70.501  1.00  4.54           C  
ATOM   1450  CH2 TRP A 184       4.998  38.838  71.710  1.00  3.62           C  
ATOM   1451  N   GLY A 185      10.984  35.898  72.959  1.00  4.96           N  
ATOM   1452  CA  GLY A 185      11.388  35.636  74.328  1.00  5.21           C  
ATOM   1453  C   GLY A 185      12.605  34.740  74.416  1.00  6.37           C  
ATOM   1454  O   GLY A 185      13.475  34.768  73.524  1.00  5.35           O  
ATOM   1455  N   TYR A 186      12.686  33.977  75.516  1.00  5.85           N  
ATOM   1456  CA  TYR A 186      13.947  33.329  75.863  1.00  6.55           C  
ATOM   1457  C   TYR A 186      13.996  31.955  75.299  1.00  8.13           C  
ATOM   1458  O   TYR A 186      15.071  31.408  75.149  1.00  8.00           O  
ATOM   1459  CB  TYR A 186      14.169  33.248  77.373  1.00  6.88           C  
ATOM   1460  CG  TYR A 186      14.308  34.606  77.980  1.00  5.94           C  
ATOM   1461  CD1 TYR A 186      13.526  34.988  79.073  1.00  5.05           C  
ATOM   1462  CD2 TYR A 186      15.187  35.528  77.422  1.00  5.68           C  
ATOM   1463  CE1 TYR A 186      13.614  36.239  79.586  1.00  4.26           C  
ATOM   1464  CE2 TYR A 186      15.328  36.775  77.969  1.00  5.26           C  
ATOM   1465  CZ  TYR A 186      14.527  37.133  79.037  1.00  4.35           C  
ATOM   1466  OH  TYR A 186      14.684  38.382  79.572  1.00  3.58           O  
ATOM   1467  N   VAL A 187      12.825  31.406  74.974  1.00  7.75           N  
ATOM   1468  CA  VAL A 187      12.750  30.008  74.535  1.00  8.48           C  
ATOM   1469  C   VAL A 187      13.184  29.859  73.101  1.00  9.65           C  
ATOM   1470  O   VAL A 187      12.703  30.597  72.211  1.00  9.33           O  
ATOM   1471  CB  VAL A 187      11.366  29.468  74.753  1.00  7.92           C  
ATOM   1472  CG1 VAL A 187      11.274  28.031  74.266  1.00  8.57           C  
ATOM   1473  CG2 VAL A 187      11.101  29.524  76.234  1.00  6.54           C  
ATOM   1474  N   LYS A 188      14.148  28.968  72.908  1.00 10.24           N  
ATOM   1475  CA  LYS A 188      14.744  28.706  71.589  1.00 11.54           C  
ATOM   1476  C   LYS A 188      14.060  27.591  70.864  1.00 11.72           C  
ATOM   1477  O   LYS A 188      14.069  27.600  69.675  1.00 13.50           O  
ATOM   1478  CB  LYS A 188      16.213  28.312  71.674  1.00 12.92           C  
ATOM   1479  CG  LYS A 188      17.217  29.447  71.677  1.00 17.01           C  
ATOM   1480  CD  LYS A 188      18.667  28.872  71.883  1.00 19.96           C  
ATOM   1481  CE  LYS A 188      19.642  29.214  70.716  1.00 24.02           C  
ATOM   1482  NZ  LYS A 188      21.105  29.053  71.142  1.00 24.02           N  
ATOM   1483  N   LEU A 189      13.499  26.607  71.550  1.00 11.44           N  
ATOM   1484  CA  LEU A 189      12.684  25.602  70.861  1.00 12.23           C  
ATOM   1485  C   LEU A 189      11.382  25.390  71.593  1.00 12.40           C  
ATOM   1486  O   LEU A 189      11.351  25.450  72.849  1.00 11.49           O  
ATOM   1487  CB  LEU A 189      13.413  24.258  70.745  1.00 13.01           C  
ATOM   1488  CG  LEU A 189      14.746  24.460  70.018  1.00 14.43           C  
ATOM   1489  CD1 LEU A 189      15.625  23.312  70.387  1.00 17.39           C  
ATOM   1490  CD2 LEU A 189      14.529  24.526  68.505  1.00 14.89           C  
ATOM   1491  N   ASN A 190      10.347  25.110  70.798  1.00 10.50           N  
ATOM   1492  CA  ASN A 190       8.974  24.953  71.225  1.00 10.66           C  
ATOM   1493  C   ASN A 190       8.350  23.690  70.635  1.00 12.28           C  
ATOM   1494  O   ASN A 190       8.398  23.483  69.407  1.00 11.62           O  
ATOM   1495  CB  ASN A 190       8.158  26.134  70.705  1.00  8.96           C  
ATOM   1496  CG  ASN A 190       8.351  27.373  71.559  1.00  9.06           C  
ATOM   1497  OD1 ASN A 190       7.803  27.459  72.681  1.00  9.76           O  
ATOM   1498  ND2 ASN A 190       9.143  28.295  71.090  1.00  6.77           N  
ATOM   1499  N   SER A 191       7.703  22.863  71.439  1.00 11.19           N  
ATOM   1500  CA  SER A 191       6.978  21.761  70.772  1.00 13.38           C  
ATOM   1501  C   SER A 191       5.449  21.894  70.824  1.00 13.16           C  
ATOM   1502  O   SER A 191       4.714  21.052  70.298  1.00 13.93           O  
ATOM   1503  CB  SER A 191       7.435  20.431  71.300  1.00 13.09           C  
ATOM   1504  OG  SER A 191       7.156  20.446  72.674  1.00 15.62           O  
ATOM   1505  N   GLN A 192       4.951  22.967  71.417  1.00 10.43           N  
ATOM   1506  CA  GLN A 192       3.515  23.193  71.373  1.00 11.36           C  
ATOM   1507  C   GLN A 192       3.100  23.941  70.104  1.00 10.84           C  
ATOM   1508  O   GLN A 192       3.813  24.835  69.654  1.00 10.65           O  
ATOM   1509  CB  GLN A 192       3.114  23.978  72.618  1.00 10.53           C  
ATOM   1510  CG  GLN A 192       3.154  23.043  73.858  1.00 10.41           C  
ATOM   1511  CD  GLN A 192       1.871  22.315  73.920  1.00 12.02           C  
ATOM   1512  OE1 GLN A 192       0.863  22.821  73.403  1.00 12.12           O  
ATOM   1513  NE2 GLN A 192       1.871  21.126  74.485  1.00 13.51           N  
ATOM   1514  N   ILE A 193       1.934  23.606  69.552  1.00 11.49           N  
ATOM   1515  CA  ILE A 193       1.360  24.374  68.430  1.00  9.78           C  
ATOM   1516  C   ILE A 193       0.235  25.292  68.914  1.00  7.90           C  
ATOM   1517  O   ILE A 193      -0.843  24.809  69.177  1.00  7.88           O  
ATOM   1518  CB  ILE A 193       0.696  23.435  67.395  1.00 11.15           C  
ATOM   1519  CG1 ILE A 193       1.567  22.211  67.086  1.00 13.63           C  
ATOM   1520  CG2 ILE A 193       0.331  24.231  66.132  1.00 11.32           C  
ATOM   1521  CD1 ILE A 193       0.712  20.879  67.033  1.00 17.56           C  
ATOM   1522  N   PRO A 194       0.460  26.623  68.992  1.00  6.86           N  
ATOM   1523  CA  PRO A 194      -0.577  27.554  69.395  1.00  5.78           C  
ATOM   1524  C   PRO A 194      -1.490  27.952  68.189  1.00  7.20           C  
ATOM   1525  O   PRO A 194      -1.210  27.572  67.044  1.00  6.69           O  
ATOM   1526  CB  PRO A 194       0.247  28.755  69.843  1.00  5.16           C  
ATOM   1527  CG  PRO A 194       1.298  28.802  68.754  1.00  5.74           C  
ATOM   1528  CD  PRO A 194       1.643  27.343  68.497  1.00  7.18           C  
ATOM   1529  N   ASP A 195      -2.583  28.661  68.451  1.00  5.82           N  
ATOM   1530  CA  ASP A 195      -3.348  29.265  67.379  1.00  6.56           C  
ATOM   1531  C   ASP A 195      -2.506  30.258  66.593  1.00  7.06           C  
ATOM   1532  O   ASP A 195      -2.644  30.409  65.403  1.00  5.38           O  
ATOM   1533  CB  ASP A 195      -4.583  29.923  67.961  1.00  6.31           C  
ATOM   1534  CG  ASP A 195      -5.459  28.911  68.659  1.00  8.19           C  
ATOM   1535  OD1 ASP A 195      -6.017  28.002  67.967  1.00  8.60           O  
ATOM   1536  OD2 ASP A 195      -5.514  28.933  69.903  1.00  7.13           O  
ATOM   1537  N   PHE A 196      -1.600  30.931  67.274  1.00  6.62           N  
ATOM   1538  CA  PHE A 196      -0.899  31.994  66.616  1.00  5.67           C  
ATOM   1539  C   PHE A 196       0.548  31.961  67.042  1.00  6.30           C  
ATOM   1540  O   PHE A 196       0.871  31.650  68.180  1.00  4.28           O  
ATOM   1541  CB  PHE A 196      -1.498  33.340  67.022  1.00  6.00           C  
ATOM   1542  CG  PHE A 196      -2.940  33.527  66.599  1.00  6.89           C  
ATOM   1543  CD1 PHE A 196      -3.938  33.640  67.532  1.00  7.74           C  
ATOM   1544  CD2 PHE A 196      -3.294  33.576  65.259  1.00  8.29           C  
ATOM   1545  CE1 PHE A 196      -5.246  33.830  67.141  1.00 10.13           C  
ATOM   1546  CE2 PHE A 196      -4.617  33.784  64.849  1.00  7.89           C  
ATOM   1547  CZ  PHE A 196      -5.583  33.920  65.775  1.00  9.26           C  
ATOM   1548  N   THR A 197       1.424  32.299  66.114  1.00  5.38           N  
ATOM   1549  CA  THR A 197       2.786  32.433  66.458  1.00  5.65           C  
ATOM   1550  C   THR A 197       3.244  33.868  66.144  1.00  6.81           C  
ATOM   1551  O   THR A 197       3.032  34.367  65.030  1.00  7.99           O  
ATOM   1552  CB  THR A 197       3.598  31.433  65.678  1.00  8.41           C  
ATOM   1553  OG1 THR A 197       3.320  30.066  66.133  1.00  7.44           O  
ATOM   1554  CG2 THR A 197       5.067  31.759  65.896  1.00  8.92           C  
ATOM   1555  N   LEU A 198       3.811  34.583  67.127  1.00  5.34           N  
ATOM   1556  CA  LEU A 198       4.162  35.982  66.949  1.00  4.94           C  
ATOM   1557  C   LEU A 198       5.662  36.201  67.004  1.00  5.94           C  
ATOM   1558  O   LEU A 198       6.320  35.761  67.924  1.00  5.16           O  
ATOM   1559  CB  LEU A 198       3.482  36.767  68.051  1.00  5.33           C  
ATOM   1560  CG  LEU A 198       2.002  36.449  68.339  1.00  4.94           C  
ATOM   1561  CD1 LEU A 198       1.517  37.222  69.596  1.00  4.39           C  
ATOM   1562  CD2 LEU A 198       1.164  36.780  67.117  1.00  6.15           C  
ATOM   1563  N   SER A 199       6.237  36.839  65.993  1.00  6.58           N  
ATOM   1564  CA  SER A 199       7.656  37.002  65.974  1.00  6.59           C  
ATOM   1565  C   SER A 199       8.015  38.327  66.636  1.00  6.59           C  
ATOM   1566  O   SER A 199       9.107  38.493  67.105  1.00  5.94           O  
ATOM   1567  CB  SER A 199       8.232  36.875  64.538  1.00  8.58           C  
ATOM   1568  OG  SER A 199       7.772  37.931  63.655  1.00 11.06           O  
ATOM   1569  N   ARG A 200       7.093  39.281  66.645  1.00  5.84           N  
ATOM   1570  CA  ARG A 200       7.297  40.529  67.390  1.00  5.63           C  
ATOM   1571  C   ARG A 200       5.948  40.915  67.993  1.00  5.34           C  
ATOM   1572  O   ARG A 200       4.871  40.501  67.493  1.00  4.03           O  
ATOM   1573  CB  ARG A 200       7.811  41.692  66.502  1.00  5.90           C  
ATOM   1574  CG  ARG A 200       7.215  41.681  65.142  1.00  8.31           C  
ATOM   1575  CD  ARG A 200       7.888  42.602  64.058  1.00  9.62           C  
ATOM   1576  NE  ARG A 200       9.288  42.340  63.739  1.00 12.33           N  
ATOM   1577  CZ  ARG A 200      10.075  43.166  62.996  1.00 13.64           C  
ATOM   1578  NH1 ARG A 200       9.636  44.323  62.456  1.00 11.66           N  
ATOM   1579  NH2 ARG A 200      11.335  42.848  62.758  1.00 15.19           N  
ATOM   1580  N   PRO A 201       5.999  41.766  69.020  1.00  4.19           N  
ATOM   1581  CA  PRO A 201       4.747  42.105  69.690  1.00  4.11           C  
ATOM   1582  C   PRO A 201       3.756  42.786  68.774  1.00  3.74           C  
ATOM   1583  O   PRO A 201       2.597  42.436  68.763  1.00  4.32           O  
ATOM   1584  CB  PRO A 201       5.213  43.010  70.817  1.00  3.12           C  
ATOM   1585  CG  PRO A 201       6.567  42.515  71.139  1.00  3.62           C  
ATOM   1586  CD  PRO A 201       7.176  42.214  69.787  1.00  3.84           C  
ATOM   1587  N   SER A 202       4.201  43.730  67.979  1.00  4.39           N  
ATOM   1588  CA  SER A 202       3.269  44.453  67.071  1.00  5.15           C  
ATOM   1589  C   SER A 202       2.543  43.485  66.100  1.00  6.27           C  
ATOM   1590  O   SER A 202       1.469  43.804  65.544  1.00  6.60           O  
ATOM   1591  CB  SER A 202       4.051  45.517  66.302  1.00  5.42           C  
ATOM   1592  OG  SER A 202       4.921  44.838  65.398  1.00  5.83           O  
ATOM   1593  N   ASP A 203       3.067  42.276  65.922  1.00  5.38           N  
ATOM   1594  CA  ASP A 203       2.307  41.284  65.166  1.00  6.40           C  
ATOM   1595  C   ASP A 203       0.893  41.048  65.692  1.00  6.72           C  
ATOM   1596  O   ASP A 203      -0.024  40.736  64.929  1.00  5.65           O  
ATOM   1597  CB  ASP A 203       3.012  39.943  65.154  1.00  6.51           C  
ATOM   1598  CG  ASP A 203       4.229  39.947  64.273  1.00  7.80           C  
ATOM   1599  OD1 ASP A 203       4.617  41.040  63.742  1.00  8.63           O  
ATOM   1600  OD2 ASP A 203       4.794  38.836  64.090  1.00 10.11           O  
ATOM   1601  N   LEU A 204       0.702  41.151  67.001  1.00  6.56           N  
ATOM   1602  CA  LEU A 204      -0.663  41.085  67.522  1.00  5.95           C  
ATOM   1603  C   LEU A 204      -1.527  42.095  66.880  1.00  7.03           C  
ATOM   1604  O   LEU A 204      -2.675  41.827  66.598  1.00  8.79           O  
ATOM   1605  CB  LEU A 204      -0.717  41.371  69.011  1.00  6.60           C  
ATOM   1606  CG  LEU A 204      -0.738  40.185  69.930  1.00  5.79           C  
ATOM   1607  CD1 LEU A 204      -0.954  40.579  71.405  1.00  6.36           C  
ATOM   1608  CD2 LEU A 204      -1.888  39.398  69.433  1.00  6.88           C  
ATOM   1609  N   VAL A 205      -1.001  43.289  66.710  1.00  7.41           N  
ATOM   1610  CA  VAL A 205      -1.779  44.401  66.161  1.00  9.11           C  
ATOM   1611  C   VAL A 205      -2.126  44.206  64.632  1.00  8.96           C  
ATOM   1612  O   VAL A 205      -3.278  44.444  64.200  1.00 10.00           O  
ATOM   1613  CB  VAL A 205      -1.110  45.761  66.534  1.00  8.05           C  
ATOM   1614  CG1 VAL A 205      -1.901  46.993  65.940  1.00 10.02           C  
ATOM   1615  CG2 VAL A 205      -1.015  45.900  68.043  1.00  6.55           C  
ATOM   1616  N   LYS A 206      -1.186  43.721  63.854  1.00  7.27           N  
ATOM   1617  CA  LYS A 206      -1.506  43.269  62.477  1.00  8.78           C  
ATOM   1618  C   LYS A 206      -2.690  42.261  62.387  1.00  9.47           C  
ATOM   1619  O   LYS A 206      -3.493  42.307  61.482  1.00  9.52           O  
ATOM   1620  CB  LYS A 206      -0.257  42.680  61.812  1.00  8.80           C  
ATOM   1621  CG  LYS A 206      -0.308  42.655  60.248  1.00 11.37           C  
ATOM   1622  CD  LYS A 206       1.078  42.559  59.582  1.00 12.09           C  
ATOM   1623  CE  LYS A 206       1.170  43.267  58.161  1.00 11.05           C  
ATOM   1624  NZ  LYS A 206       2.578  42.982  57.550  1.00 10.45           N  
ATOM   1625  N   LEU A 207      -2.791  41.327  63.317  1.00  9.20           N  
ATOM   1626  CA  LEU A 207      -3.839  40.325  63.249  1.00 10.24           C  
ATOM   1627  C   LEU A 207      -5.152  41.047  63.485  1.00 12.71           C  
ATOM   1628  O   LEU A 207      -6.187  40.726  62.902  1.00 13.09           O  
ATOM   1629  CB  LEU A 207      -3.669  39.260  64.350  1.00 10.07           C  
ATOM   1630  CG  LEU A 207      -2.516  38.285  64.325  1.00  8.60           C  
ATOM   1631  CD1 LEU A 207      -2.710  37.318  65.408  1.00  8.95           C  
ATOM   1632  CD2 LEU A 207      -2.440  37.553  63.046  1.00  9.74           C  
HETATM 1633  N   MSE A 208      -5.110  42.035  64.354  1.00 11.06           N  
HETATM 1634  CA  MSE A 208      -6.276  42.858  64.572  1.00 13.55           C  
HETATM 1635  C   MSE A 208      -6.655  43.699  63.330  1.00 12.34           C  
HETATM 1636  O   MSE A 208      -7.820  43.761  62.939  1.00 12.74           O  
HETATM 1637  CB  MSE A 208      -5.936  43.761  65.755  1.00 13.04           C  
HETATM 1638  CG  MSE A 208      -7.057  44.511  66.329  1.00 17.63           C  
HETATM 1639 SE   MSE A 208      -6.340  44.889  68.152  1.00 24.02          SE  
HETATM 1640  CE  MSE A 208      -5.153  43.239  68.158  1.00 15.40           C  
ATOM   1641  N   ASP A 209      -5.667  44.325  62.695  1.00 11.50           N  
ATOM   1642  CA  ASP A 209      -5.903  45.110  61.467  1.00 12.20           C  
ATOM   1643  C   ASP A 209      -6.533  44.289  60.328  1.00 13.11           C  
ATOM   1644  O   ASP A 209      -7.305  44.810  59.497  1.00 12.48           O  
ATOM   1645  CB  ASP A 209      -4.586  45.674  60.957  1.00 11.90           C  
ATOM   1646  CG  ASP A 209      -4.028  46.812  61.837  1.00 12.75           C  
ATOM   1647  OD1 ASP A 209      -4.640  47.238  62.828  1.00 12.23           O  
ATOM   1648  OD2 ASP A 209      -2.914  47.277  61.512  1.00 14.96           O  
ATOM   1649  N   ASN A 210      -6.188  43.010  60.270  1.00 11.99           N  
ATOM   1650  CA  ASN A 210      -6.725  42.145  59.219  1.00 12.05           C  
ATOM   1651  C   ASN A 210      -8.007  41.470  59.635  1.00 12.16           C  
ATOM   1652  O   ASN A 210      -8.538  40.676  58.902  1.00 11.53           O  
ATOM   1653  CB  ASN A 210      -5.683  41.144  58.764  1.00 10.46           C  
ATOM   1654  CG  ASN A 210      -4.867  41.681  57.602  1.00 11.82           C  
ATOM   1655  OD1 ASN A 210      -4.764  41.060  56.532  1.00  9.86           O  
ATOM   1656  ND2 ASN A 210      -4.372  42.877  57.765  1.00 10.49           N  
ATOM   1657  N   HIS A 211      -8.508  41.826  60.811  1.00 12.47           N  
ATOM   1658  CA  HIS A 211      -9.740  41.249  61.366  1.00 13.63           C  
ATOM   1659  C   HIS A 211      -9.540  39.764  61.582  1.00 14.47           C  
ATOM   1660  O   HIS A 211     -10.469  38.972  61.586  1.00 14.74           O  
ATOM   1661  CB  HIS A 211     -10.971  41.541  60.472  1.00 15.47           C  
ATOM   1662  CG  HIS A 211     -11.414  42.975  60.485  1.00 16.90           C  
ATOM   1663  ND1 HIS A 211     -10.763  43.964  61.209  1.00 17.32           N  
ATOM   1664  CD2 HIS A 211     -12.441  43.603  59.868  1.00 19.92           C  
ATOM   1665  CE1 HIS A 211     -11.356  45.122  61.029  1.00 18.60           C  
ATOM   1666  NE2 HIS A 211     -12.382  44.937  60.214  1.00 21.28           N  
ATOM   1667  N   ILE A 212      -8.301  39.368  61.768  1.00 13.09           N  
ATOM   1668  CA  ILE A 212      -8.020  37.983  62.103  1.00 13.28           C  
ATOM   1669  C   ILE A 212      -8.384  37.752  63.545  1.00 14.24           C  
ATOM   1670  O   ILE A 212      -8.946  36.730  63.899  1.00 14.56           O  
ATOM   1671  CB  ILE A 212      -6.593  37.642  61.820  1.00 12.10           C  
ATOM   1672  CG1 ILE A 212      -6.444  37.514  60.300  1.00 11.86           C  
ATOM   1673  CG2 ILE A 212      -6.245  36.382  62.505  1.00 11.44           C  
ATOM   1674  CD1 ILE A 212      -5.099  37.574  59.857  1.00 10.38           C  
ATOM   1675  N   VAL A 213      -8.095  38.745  64.376  1.00 15.68           N  
ATOM   1676  CA  VAL A 213      -8.696  38.838  65.699  1.00 16.00           C  
ATOM   1677  C   VAL A 213      -9.544  40.102  65.718  1.00 17.01           C  
ATOM   1678  O   VAL A 213      -9.143  41.126  65.136  1.00 17.49           O  
ATOM   1679  CB  VAL A 213      -7.635  38.780  66.817  1.00 14.90           C  
ATOM   1680  CG1 VAL A 213      -6.713  37.600  66.556  1.00 13.98           C  
ATOM   1681  CG2 VAL A 213      -6.846  40.063  66.939  1.00 16.33           C  
ATOM   1682  N   GLU A 214     -10.730  40.018  66.314  1.00 16.62           N  
ATOM   1683  CA  GLU A 214     -11.553  41.189  66.558  1.00 16.68           C  
ATOM   1684  C   GLU A 214     -12.021  41.177  68.018  1.00 15.27           C  
ATOM   1685  O   GLU A 214     -12.191  40.101  68.629  1.00 13.29           O  
ATOM   1686  CB  GLU A 214     -12.753  41.220  65.585  1.00 17.63           C  
ATOM   1687  CG  GLU A 214     -12.378  40.586  64.242  1.00 20.16           C  
ATOM   1688  CD  GLU A 214     -13.482  40.623  63.146  1.00 23.34           C  
ATOM   1689  OE1 GLU A 214     -13.877  39.517  62.688  1.00 24.02           O  
ATOM   1690  OE2 GLU A 214     -13.925  41.732  62.718  1.00 23.41           O  
ATOM   1691  N   PHE A 215     -12.190  42.380  68.569  1.00 14.74           N  
ATOM   1692  CA  PHE A 215     -12.748  42.555  69.906  1.00 14.23           C  
ATOM   1693  C   PHE A 215     -14.259  42.396  69.833  1.00 15.57           C  
ATOM   1694  O   PHE A 215     -14.939  42.976  68.978  1.00 15.41           O  
ATOM   1695  CB  PHE A 215     -12.335  43.894  70.538  1.00 12.73           C  
ATOM   1696  CG  PHE A 215     -13.112  44.252  71.773  1.00 12.14           C  
ATOM   1697  CD1 PHE A 215     -14.068  45.256  71.741  1.00 13.70           C  
ATOM   1698  CD2 PHE A 215     -12.920  43.577  72.951  1.00 11.88           C  
ATOM   1699  CE1 PHE A 215     -14.817  45.585  72.883  1.00 13.62           C  
ATOM   1700  CE2 PHE A 215     -13.669  43.909  74.136  1.00 12.49           C  
ATOM   1701  CZ  PHE A 215     -14.589  44.913  74.098  1.00 12.97           C  
ATOM   1702  N   GLU A 216     -14.764  41.539  70.702  1.00 14.65           N  
ATOM   1703  CA  GLU A 216     -16.184  41.276  70.808  1.00 16.81           C  
ATOM   1704  C   GLU A 216     -16.906  42.206  71.782  1.00 16.67           C  
ATOM   1705  O   GLU A 216     -16.909  41.952  72.957  1.00 17.11           O  
ATOM   1706  CB  GLU A 216     -16.376  39.838  71.275  1.00 16.80           C  
ATOM   1707  CG  GLU A 216     -17.800  39.327  71.146  1.00 18.84           C  
ATOM   1708  CD  GLU A 216     -17.951  37.950  71.755  1.00 20.65           C  
ATOM   1709  OE1 GLU A 216     -17.470  36.949  71.133  1.00 22.12           O  
ATOM   1710  OE2 GLU A 216     -18.524  37.866  72.876  1.00 22.34           O  
ATOM   1711  N   GLY A 217     -17.539  43.278  71.324  1.00 17.73           N  
ATOM   1712  CA  GLY A 217     -18.567  43.872  72.184  1.00 18.24           C  
ATOM   1713  C   GLY A 217     -19.677  42.838  72.381  1.00 19.56           C  
ATOM   1714  O   GLY A 217     -20.038  42.446  73.507  1.00 21.10           O  
TER    1715      GLY A 217                                                      
END
MOLECULE T0418.pdb
ATOM      1  N   LYS     2     -13.076  35.543  67.613  1.00 29.62           N
ATOM      2  CA  LYS     2     -12.478  36.834  68.052  0.50 29.11           C
ATOM      4  CB  LYS     2     -13.375  38.010  67.650  0.50 29.29           C
ATOM      6  CG  LYS     2     -12.641  39.346  67.502  0.50 28.70           C
ATOM      8  CD  LYS     2     -13.620  40.472  67.149  0.50 28.45           C
ATOM     10  CE  LYS     2     -14.745  40.631  68.215  0.50 27.78           C
ATOM     12  NZ  LYS     2     -14.212  40.910  69.618  0.50 23.90           N
ATOM     14  C   LYS     2     -12.217  36.842  69.559  1.00 29.22           C
ATOM     15  O   LYS     2     -13.013  36.324  70.358  1.00 29.48           O
ATOM     16  N   TYR     3     -11.081  37.413  69.934  1.00 28.23           N
ATOM     17  CA  TYR     3     -10.713  37.511  71.337  1.00 28.13           C
ATOM     18  CB  TYR     3      -9.228  37.205  71.499  1.00 27.69           C
ATOM     19  CG  TYR     3      -8.855  35.913  70.851  1.00 27.85           C
ATOM     20  CD1 TYR     3      -9.318  34.695  71.359  1.00 27.15           C
ATOM     21  CE1 TYR     3      -8.963  33.481  70.741  1.00 29.48           C
ATOM     22  CZ  TYR     3      -8.150  33.512  69.615  1.00 28.31           C
ATOM     23  OH  TYR     3      -7.781  32.362  68.998  1.00 29.71           O
ATOM     24  CE2 TYR     3      -7.689  34.704  69.099  1.00 28.68           C
ATOM     25  CD2 TYR     3      -8.054  35.901  69.711  1.00 28.20           C
ATOM     26  C   TYR     3     -11.028  38.898  71.895  1.00 27.71           C
ATOM     27  O   TYR     3     -10.756  39.901  71.237  1.00 28.58           O
ATOM     28  N   THR     4     -11.608  38.949  73.092  1.00 26.98           N
ATOM     29  CA  THR     4     -11.921  40.233  73.752  1.00 26.26           C
ATOM     30  CB  THR     4     -13.434  40.362  74.092  1.00 25.63           C
ATOM     31  OG1 THR     4     -13.795  39.364  75.050  1.00 24.05           O
ATOM     32  CG2 THR     4     -14.272  40.199  72.862  1.00 25.42           C
ATOM     33  C   THR     4     -11.088  40.424  75.028  1.00 26.20           C
ATOM     34  O   THR     4     -11.218  41.432  75.726  1.00 26.38           O
ATOM     35  N   VAL     5     -10.260  39.424  75.320  1.00 26.09           N
ATOM     36  CA  VAL     5      -9.387  39.390  76.487  1.00 25.98           C
ATOM     37  CB  VAL     5      -9.988  38.533  77.656  1.00 26.21           C
ATOM     38  CG1 VAL     5      -9.003  38.455  78.853  1.00 25.67           C
ATOM     39  CG2 VAL     5     -11.398  39.033  78.080  1.00 25.14           C
ATOM     40  C   VAL     5      -8.026  38.798  76.069  1.00 26.19           C
ATOM     41  O   VAL     5      -7.939  37.642  75.627  1.00 25.71           O
ATOM     42  N   TYR     6      -6.974  39.596  76.199  1.00 25.76           N
ATOM     43  CA  TYR     6      -5.616  39.122  75.949  1.00 25.47           C
ATOM     44  CB  TYR     6      -4.867  40.089  75.019  1.00 25.89           C
ATOM     45  CG  TYR     6      -5.233  40.042  73.546  1.00 26.06           C
ATOM     46  CD1 TYR     6      -6.573  40.059  73.118  1.00 27.09           C
ATOM     47  CE1 TYR     6      -6.905  40.033  71.753  1.00 27.02           C
ATOM     48  CZ  TYR     6      -5.886  40.001  70.813  1.00 26.83           C
ATOM     49  OH  TYR     6      -6.181  39.980  69.480  1.00 25.05           O
ATOM     50  CE2 TYR     6      -4.551  40.012  71.213  1.00 25.46           C
ATOM     51  CD2 TYR     6      -4.234  40.029  72.575  1.00 26.76           C
ATOM     52  C   TYR     6      -4.877  39.026  77.278  1.00 25.08           C
ATOM     53  O   TYR     6      -4.674  40.032  77.943  1.00 24.69           O
ATOM     54  N   LEU     7      -4.487  37.816  77.670  1.00 24.54           N
ATOM     55  CA  LEU     7      -3.771  37.624  78.929  1.00 24.14           C
ATOM     56  CB  LEU     7      -4.383  36.496  79.763  1.00 23.59           C
ATOM     57  CG  LEU     7      -5.870  36.734  80.138  1.00 24.16           C
ATOM     58  CD1 LEU     7      -6.521  35.534  80.774  1.00 20.62           C
ATOM     59  CD2 LEU     7      -6.014  37.958  81.059  1.00 22.12           C
ATOM     60  C   LEU     7      -2.323  37.335  78.582  1.00 24.96           C
ATOM     61  O   LEU     7      -2.027  36.555  77.668  1.00 24.77           O
ATOM     62  N   PHE     8      -1.430  38.000  79.300  1.00 25.46           N
ATOM     63  CA  PHE     8      -0.011  37.932  79.019  1.00 25.12           C
ATOM     64  CB  PHE     8       0.536  39.346  78.747  1.00 24.90           C
ATOM     65  CG  PHE     8      -0.072  40.030  77.537  1.00 23.20           C
ATOM     66  CD1 PHE     8       0.543  39.933  76.300  1.00 20.97           C
ATOM     67  CE1 PHE     8       0.002  40.554  75.184  1.00 23.26           C
ATOM     68  CZ  PHE     8      -1.183  41.317  75.319  1.00 23.30           C
ATOM     69  CE2 PHE     8      -1.795  41.414  76.551  1.00 22.61           C
ATOM     70  CD2 PHE     8      -1.243  40.770  77.646  1.00 23.59           C
ATOM     71  C   PHE     8       0.758  37.332  80.185  1.00 25.42           C
ATOM     72  O   PHE     8       0.489  37.647  81.349  1.00 24.56           O
ATOM     73  N   ASP     9       1.705  36.454  79.854  1.00 25.13           N
ATOM     74  CA  ASP     9       2.868  36.191  80.698  1.00 25.05           C
ATOM     75  CB  ASP     9       3.770  35.134  80.038  1.00 25.36           C
ATOM     76  CG  ASP     9       4.800  34.591  80.993  1.00 26.68           C
ATOM     77  OD1 ASP     9       4.592  34.704  82.202  1.00 34.85           O
ATOM     78  OD2 ASP     9       5.854  34.101  80.583  1.00 35.24           O
ATOM     79  C   ASP     9       3.678  37.487  80.915  1.00 24.97           C
ATOM     80  O   ASP     9       3.511  38.454  80.172  1.00 26.37           O
ATOM     81  N   PHE    10       4.517  37.529  81.947  1.00 23.63           N
ATOM     82  CA  PHE    10       5.322  38.732  82.245  1.00 23.16           C
ATOM     83  CB  PHE    10       5.224  39.137  83.733  1.00 22.29           C
ATOM     84  CG  PHE    10       5.966  40.422  84.054  1.00 22.99           C
ATOM     85  CD1 PHE    10       5.373  41.665  83.808  1.00 24.77           C
ATOM     86  CE1 PHE    10       6.080  42.878  84.084  1.00 24.55           C
ATOM     87  CZ  PHE    10       7.384  42.826  84.610  1.00 22.62           C
ATOM     88  CE2 PHE    10       7.982  41.589  84.874  1.00 24.73           C
ATOM     89  CD2 PHE    10       7.276  40.382  84.582  1.00 23.46           C
ATOM     90  C   PHE    10       6.773  38.604  81.815  1.00 22.66           C
ATOM     91  O   PHE    10       7.185  39.218  80.841  1.00 23.91           O
ATOM     92  N   ASP    11       7.552  37.779  82.507  1.00 23.43           N
ATOM     93  CA  ASP    11       8.986  37.643  82.204  1.00 23.44           C
ATOM     94  CB  ASP    11       9.664  36.690  83.184  1.00 23.10           C
ATOM     95  CG  ASP    11       9.732  37.232  84.591  1.00 24.03           C
ATOM     96  OD1 ASP    11      10.159  38.406  84.796  1.00 24.46           O
ATOM     97  OD2 ASP    11       9.374  36.443  85.514  1.00 23.52           O
ATOM     98  C   ASP    11       9.215  37.131  80.776  1.00 23.25           C
ATOM     99  O   ASP    11       8.635  36.114  80.385  1.00 23.39           O
ATOM    100  N   TYR    12      10.044  37.839  80.001  1.00 21.78           N
ATOM    101  CA  TYR    12      10.289  37.470  78.592  1.00 19.73           C
ATOM    102  CB  TYR    12      10.756  36.006  78.503  1.00 20.19           C
ATOM    103  CG  TYR    12      12.274  35.815  78.587  1.00 18.57           C
ATOM    104  CD1 TYR    12      13.161  36.790  78.106  1.00 19.37           C
ATOM    105  CE1 TYR    12      14.573  36.569  78.131  1.00 17.76           C
ATOM    106  CZ  TYR    12      15.053  35.376  78.655  1.00 20.36           C
ATOM    107  OH  TYR    12      16.419  35.108  78.707  1.00 20.14           O
ATOM    108  CE2 TYR    12      14.181  34.426  79.131  1.00 19.24           C
ATOM    109  CD2 TYR    12      12.810  34.625  79.069  1.00 19.14           C
ATOM    110  C   TYR    12       9.134  37.682  77.617  1.00 20.20           C
ATOM    111  O   TYR    12       9.239  37.335  76.430  1.00 18.25           O
ATOM    112  N   THR    13       8.026  38.225  78.105  1.00 19.18           N
ATOM    113  CA  THR    13       6.883  38.448  77.261  1.00 20.06           C
ATOM    114  CB  THR    13       5.674  37.608  77.705  1.00 19.89           C
ATOM    115  OG1 THR    13       5.969  36.211  77.494  1.00 21.97           O
ATOM    116  CG2 THR    13       4.465  37.998  76.843  1.00 19.00           C
ATOM    117  C   THR    13       6.536  39.943  77.240  1.00 19.72           C
ATOM    118  O   THR    13       6.575  40.562  76.173  1.00 19.50           O
ATOM    119  N   LEU    14       6.246  40.526  78.410  1.00 19.60           N
ATOM    120  CA  LEU    14       5.990  41.979  78.467  1.00 20.37           C
ATOM    121  CB  LEU    14       4.878  42.310  79.457  1.00 19.90           C
ATOM    122  CG  LEU    14       3.462  41.924  79.113  1.00 21.71           C
ATOM    123  CD1 LEU    14       2.570  42.180  80.336  1.00 22.39           C
ATOM    124  CD2 LEU    14       2.910  42.633  77.863  1.00 25.95           C
ATOM    125  C   LEU    14       7.227  42.813  78.792  1.00 20.70           C
ATOM    126  O   LEU    14       7.279  44.014  78.491  1.00 21.38           O
ATOM    127  N   ALA    15       8.195  42.183  79.445  1.00 20.70           N
ATOM    128  CA  ALA    15       9.386  42.843  79.946  1.00 21.53           C
ATOM    129  CB  ALA    15       9.167  43.257  81.419  1.00 22.22           C
ATOM    130  C   ALA    15      10.568  41.890  79.847  1.00 21.56           C
ATOM    131  O   ALA    15      10.417  40.686  80.082  1.00 20.75           O
ATOM    132  N   ASP    16      11.748  42.401  79.485  1.00 21.65           N
ATOM    133  CA  ASP    16      12.918  41.546  79.546  1.00 21.72           C
ATOM    134  CB  ASP    16      13.931  41.880  78.453  1.00 22.91           C
ATOM    135  CG  ASP    16      15.158  40.970  78.479  1.00 22.98           C
ATOM    136  OD1 ASP    16      15.256  40.068  79.357  1.00 22.97           O
ATOM    137  OD2 ASP    16      16.035  41.171  77.614  1.00 21.32           O
ATOM    138  C   ASP    16      13.533  41.709  80.935  1.00 22.65           C
ATOM    139  O   ASP    16      14.294  42.647  81.179  1.00 22.64           O
ATOM    140  N   SER    17      13.214  40.769  81.827  1.00 22.73           N
ATOM    141  CA  SER    17      13.740  40.776  83.181  1.00 24.42           C
ATOM    142  CB  SER    17      12.653  40.291  84.135  1.00 23.74           C
ATOM    143  OG  SER    17      12.089  39.109  83.579  1.00 28.12           O
ATOM    144  C   SER    17      14.977  39.871  83.334  1.00 25.00           C
ATOM    145  O   SER    17      15.425  39.655  84.452  1.00 25.03           O
ATOM    146  N   SER    18      15.512  39.351  82.219  1.00 24.93           N
ATOM    147  CA  SER    18      16.539  38.297  82.275  1.00 25.48           C
ATOM    148  CB  SER    18      16.815  37.713  80.860  1.00 24.70           C
ATOM    149  OG  SER    18      17.501  38.638  80.023  1.00 23.20           O
ATOM    150  C   SER    18      17.860  38.750  82.945  1.00 25.77           C
ATOM    151  O   SER    18      18.536  37.947  83.585  1.00 25.96           O
ATOM    152  N   ARG    19      18.228  40.019  82.802  1.00 25.80           N
ATOM    153  CA  ARG    19      19.454  40.500  83.446  0.50 26.04           C
ATOM    155  CB  ARG    19      19.863  41.870  82.902  0.50 26.63           C
ATOM    157  CG  ARG    19      20.266  41.792  81.431  0.50 28.42           C
ATOM    159  CD  ARG    19      20.814  43.097  80.908  0.50 33.31           C
ATOM    161  NE  ARG    19      22.100  43.450  81.509  0.50 36.36           N
ATOM    163  CZ  ARG    19      23.284  43.173  80.967  0.50 38.03           C
ATOM    165  NH1 ARG    19      23.360  42.527  79.802  0.50 37.79           N
ATOM    167  NH2 ARG    19      24.395  43.547  81.592  0.50 38.32           N
ATOM    169  C   ARG    19      19.328  40.492  84.970  1.00 26.05           C
ATOM    170  O   ARG    19      20.254  40.032  85.653  1.00 25.56           O
ATOM    171  N   GLY    20      18.185  40.978  85.489  1.00 25.65           N
ATOM    172  CA  GLY    20      17.898  40.939  86.941  1.00 25.86           C
ATOM    173  C   GLY    20      17.802  39.514  87.472  1.00 25.67           C
ATOM    174  O   GLY    20      18.340  39.205  88.531  1.00 25.83           O
ATOM    175  N   ILE    21      17.082  38.657  86.746  1.00 25.96           N
ATOM    176  CA  ILE    21      16.930  37.230  87.086  1.00 24.89           C
ATOM    177  CB  ILE    21      15.928  36.485  86.153  1.00 24.71           C
ATOM    178  CG1 ILE    21      14.468  37.000  86.334  1.00 22.97           C
ATOM    179  CD1 ILE    21      13.486  36.498  85.345  1.00 23.93           C
ATOM    180  CG2 ILE    21      15.993  34.939  86.382  1.00 24.75           C
ATOM    181  C   ILE    21      18.272  36.513  87.118  1.00 25.94           C
ATOM    182  O   ILE    21      18.568  35.813  88.092  1.00 28.04           O
ATOM    183  N   VAL    22      19.102  36.677  86.098  1.00 25.95           N
ATOM    184  CA  VAL    22      20.438  36.039  86.110  1.00 26.55           C
ATOM    185  CB  VAL    22      21.199  36.235  84.782  1.00 27.39           C
ATOM    186  CG1 VAL    22      22.753  35.940  84.948  1.00 26.72           C
ATOM    187  CG2 VAL    22      20.569  35.413  83.637  1.00 26.40           C
ATOM    188  C   VAL    22      21.314  36.546  87.267  1.00 26.76           C
ATOM    189  O   VAL    22      22.037  35.767  87.887  1.00 25.07           O
ATOM    190  N   THR    23      21.254  37.854  87.561  1.00 27.27           N
ATOM    191  CA  THR    23      22.043  38.424  88.674  1.00 27.43           C
ATOM    192  CB  THR    23      21.883  39.950  88.741  1.00 28.02           C
ATOM    193  OG1 THR    23      22.366  40.506  87.529  1.00 28.87           O
ATOM    194  CG2 THR    23      22.672  40.545  89.947  1.00 28.56           C
ATOM    195  C   THR    23      21.670  37.808  90.029  1.00 27.05           C
ATOM    196  O   THR    23      22.537  37.469  90.850  1.00 26.13           O
ATOM    197  N   CYS    24      20.369  37.652  90.254  1.00 26.85           N
ATOM    198  CA  CYS    24      19.873  37.136  91.525  1.00 26.73           C
ATOM    199  CB  CYS    24      18.362  37.448  91.682  1.00 25.40           C
ATOM    200  SG  CYS    24      18.046  39.289  91.751  1.00 25.35           S
ATOM    201  C   CYS    24      20.150  35.630  91.705  1.00 27.56           C
ATOM    202  O   CYS    24      20.584  35.192  92.794  1.00 27.03           O
ATOM    203  N   PHE    25      19.901  34.853  90.650  1.00 27.63           N
ATOM    204  CA  PHE    25      20.230  33.414  90.679  1.00 28.09           C
ATOM    205  CB  PHE    25      19.819  32.678  89.403  1.00 26.94           C
ATOM    206  CG  PHE    25      18.417  32.106  89.449  1.00 29.51           C
ATOM    207  CD1 PHE    25      17.426  32.624  88.629  1.00 27.94           C
ATOM    208  CE1 PHE    25      16.112  32.110  88.663  1.00 28.76           C
ATOM    209  CZ  PHE    25      15.799  31.079  89.552  1.00 27.62           C
ATOM    210  CE2 PHE    25      16.803  30.546  90.375  1.00 31.73           C
ATOM    211  CD2 PHE    25      18.097  31.047  90.314  1.00 28.80           C
ATOM    212  C   PHE    25      21.703  33.222  90.899  1.00 27.74           C
ATOM    213  O   PHE    25      22.097  32.354  91.684  1.00 29.15           O
ATOM    214  N   ARG    26      22.524  34.010  90.213  1.00 27.88           N
ATOM    215  CA  ARG    26      23.978  33.823  90.308  1.00 28.42           C
ATOM    216  CB  ARG    26      24.713  34.601  89.198  1.00 28.29           C
ATOM    217  CG  ARG    26      26.238  34.359  89.167  1.00 29.57           C
ATOM    218  CD  ARG    26      26.980  34.899  87.936  1.00 29.18           C
ATOM    219  NE  ARG    26      26.549  34.419  86.600  1.00 30.97           N
ATOM    220  CZ  ARG    26      26.561  33.155  86.165  1.00 30.81           C
ATOM    221  NH1 ARG    26      26.934  32.159  86.957  1.00 30.26           N
ATOM    222  NH2 ARG    26      26.155  32.877  84.929  1.00 27.64           N
ATOM    223  C   ARG    26      24.526  34.138  91.711  1.00 28.16           C
ATOM    224  O   ARG    26      25.384  33.418  92.226  1.00 27.54           O
ATOM    225  N   SER    27      24.056  35.235  92.319  1.00 27.95           N
ATOM    226  CA  SER    27      24.483  35.597  93.666  0.50 27.47           C
ATOM    228  CB  SER    27      23.739  36.840  94.141  0.50 27.42           C
ATOM    230  OG  SER    27      24.178  37.951  93.400  0.50 27.80           O
ATOM    232  C   SER    27      24.271  34.432  94.639  1.00 27.30           C
ATOM    233  O   SER    27      25.197  34.015  95.305  1.00 27.61           O
ATOM    234  N   VAL    28      23.052  33.905  94.686  1.00 26.45           N
ATOM    235  CA  VAL    28      22.674  32.755  95.531  1.00 26.89           C
ATOM    236  CB  VAL    28      21.135  32.478  95.479  1.00 27.16           C
ATOM    237  CG1 VAL    28      20.756  31.357  96.422  1.00 24.69           C
ATOM    238  CG2 VAL    28      20.357  33.764  95.817  1.00 26.07           C
ATOM    239  C   VAL    28      23.447  31.484  95.190  1.00 27.64           C
ATOM    240  O   VAL    28      24.032  30.875  96.082  1.00 28.22           O
ATOM    241  N   LEU    29      23.503  31.099  93.912  1.00 27.37           N
ATOM    242  CA  LEU    29      24.213  29.857  93.522  1.00 28.25           C
ATOM    243  CB  LEU    29      24.109  29.593  92.015  1.00 28.45           C
ATOM    244  CG  LEU    29      22.726  29.208  91.464  1.00 29.00           C
ATOM    245  CD1 LEU    29      22.666  29.470  89.947  1.00 26.59           C
ATOM    246  CD2 LEU    29      22.373  27.730  91.821  1.00 29.02           C
ATOM    247  C   LEU    29      25.678  29.901  93.916  1.00 28.97           C
ATOM    248  O   LEU    29      26.217  28.916  94.424  1.00 28.08           O
ATOM    249  N   GLU    30      26.300  31.069  93.709  1.00 28.53           N
ATOM    250  CA  GLU    30      27.712  31.226  93.990  1.00 29.77           C
ATOM    251  CB  GLU    30      28.324  32.327  93.104  1.00 29.25           C
ATOM    252  CG  GLU    30      28.123  31.934  91.613  1.00 32.11           C
ATOM    253  CD  GLU    30      28.977  32.698  90.590  1.00 33.14           C
ATOM    254  OE1 GLU    30      29.451  33.828  90.882  1.00 36.50           O
ATOM    255  OE2 GLU    30      29.133  32.147  89.461  1.00 36.09           O
ATOM    256  C   GLU    30      28.017  31.373  95.490  1.00 29.27           C
ATOM    257  O   GLU    30      29.077  30.947  95.931  1.00 28.69           O
ATOM    258  N   ARG    31      27.092  31.924  96.283  1.00 28.86           N
ATOM    259  CA  ARG    31      27.307  31.954  97.728  0.50 28.90           C
ATOM    261  CB  ARG    31      26.330  32.888  98.438  0.50 28.90           C
ATOM    263  CG  ARG    31      26.840  34.324  98.552  0.50 30.25           C
ATOM    265  CD  ARG    31      25.762  35.237  99.124  0.50 32.63           C
ATOM    267  NE  ARG    31      25.933  36.640  98.735  0.50 32.56           N
ATOM    269  CZ  ARG    31      25.025  37.587  98.954  0.50 32.41           C
ATOM    271  NH1 ARG    31      23.886  37.285  99.557  0.50 33.58           N
ATOM    273  NH2 ARG    31      25.247  38.835  98.564  0.50 32.58           N
ATOM    275  C   ARG    31      27.259  30.550  98.320  1.00 28.59           C
ATOM    276  O   ARG    31      27.828  30.299  99.380  1.00 28.07           O
ATOM    277  N   HIS    32      26.606  29.629  97.618  1.00 28.11           N
ATOM    278  CA  HIS    32      26.520  28.213  98.056  1.00 27.36           C
ATOM    279  CB  HIS    32      25.082  27.701  97.993  1.00 27.06           C
ATOM    280  CG  HIS    32      24.166  28.439  98.915  1.00 29.75           C
ATOM    281  ND1 HIS    32      23.935  28.037 100.210  1.00 29.90           N
ATOM    282  CE1 HIS    32      23.122  28.891 100.798  1.00 31.29           C
ATOM    283  NE2 HIS    32      22.823  29.844  99.931  1.00 33.43           N
ATOM    284  CD2 HIS    32      23.481  29.596  98.752  1.00 29.72           C
ATOM    285  C   HIS    32      27.458  27.267  97.335  1.00 26.95           C
ATOM    286  O   HIS    32      27.357  26.045  97.477  1.00 26.82           O
ATOM    287  N   GLY    33      28.396  27.823  96.585  1.00 27.08           N
ATOM    288  CA  GLY    33      29.522  27.029  96.079  1.00 27.82           C
ATOM    289  C   GLY    33      29.279  26.510  94.672  1.00 28.67           C
ATOM    290  O   GLY    33      30.111  25.775  94.150  1.00 29.18           O
ATOM    291  N   TYR    34      28.154  26.893  94.055  1.00 28.41           N
ATOM    292  CA  TYR    34      27.799  26.396  92.732  1.00 29.53           C
ATOM    293  CB  TYR    34      26.258  26.328  92.567  1.00 30.17           C
ATOM    294  CG  TYR    34      25.622  25.328  93.505  1.00 30.57           C
ATOM    295  CD1 TYR    34      25.627  23.965  93.200  1.00 30.85           C
ATOM    296  CE1 TYR    34      25.053  23.041  94.032  1.00 28.91           C
ATOM    297  CZ  TYR    34      24.477  23.460  95.208  1.00 28.86           C
ATOM    298  OH  TYR    34      23.926  22.531  96.026  1.00 29.07           O
ATOM    299  CE2 TYR    34      24.438  24.804  95.551  1.00 30.83           C
ATOM    300  CD2 TYR    34      25.026  25.733  94.694  1.00 31.63           C
ATOM    301  C   TYR    34      28.450  27.246  91.654  1.00 30.28           C
ATOM    302  O   TYR    34      28.035  28.383  91.420  1.00 32.50           O
ATOM    303  N   THR    35      29.473  26.706  91.004  1.00 30.34           N
ATOM    304  CA  THR    35      30.226  27.444  89.992  1.00 30.36           C
ATOM    305  CB  THR    35      31.744  27.439  90.295  1.00 30.15           C
ATOM    306  OG1 THR    35      32.207  26.087  90.373  1.00 31.03           O
ATOM    307  CG2 THR    35      32.043  28.122  91.593  1.00 30.29           C
ATOM    308  C   THR    35      30.011  26.858  88.601  1.00 30.09           C
ATOM    309  O   THR    35      29.478  25.759  88.459  1.00 29.73           O
ATOM    310  N   GLY    36      30.423  27.616  87.579  1.00 30.97           N
ATOM    311  CA  GLY    36      30.337  27.193  86.168  1.00 31.00           C
ATOM    312  C   GLY    36      28.913  26.995  85.649  1.00 31.00           C
ATOM    313  O   GLY    36      28.680  26.242  84.692  1.00 31.06           O
ATOM    314  N   ILE    37      27.957  27.645  86.303  1.00 30.10           N
ATOM    315  CA  ILE    37      26.598  27.671  85.777  1.00 29.29           C
ATOM    316  CB  ILE    37      25.566  27.724  86.897  1.00 29.00           C
ATOM    317  CG1 ILE    37      25.581  26.392  87.649  1.00 28.44           C
ATOM    318  CD1 ILE    37      24.913  26.451  88.976  1.00 28.07           C
ATOM    319  CG2 ILE    37      24.167  28.102  86.320  1.00 28.30           C
ATOM    320  C   ILE    37      26.493  28.882  84.880  1.00 28.98           C
ATOM    321  O   ILE    37      26.659  30.007  85.347  1.00 30.36           O
ATOM    322  N   THR    38      26.216  28.652  83.598  1.00 28.66           N
ATOM    323  CA  THR    38      26.144  29.711  82.585  1.00 28.14           C
ATOM    324  CB  THR    38      26.280  29.130  81.169  1.00 28.45           C
ATOM    325  OG1 THR    38      25.087  28.398  80.837  1.00 28.74           O
ATOM    326  CG2 THR    38      27.513  28.237  81.063  1.00 26.51           C
ATOM    327  C   THR    38      24.845  30.529  82.605  1.00 27.96           C
ATOM    328  O   THR    38      23.821  30.081  83.120  1.00 27.32           O
ATOM    329  N   ASP    39      24.897  31.739  82.034  1.00 27.46           N
ATOM    330  CA  ASP    39      23.714  32.551  81.894  1.00 27.38           C
ATOM    331  CB  ASP    39      24.037  33.817  81.100  1.00 27.60           C
ATOM    332  CG  ASP    39      24.785  34.880  81.927  1.00 31.78           C
ATOM    333  OD1 ASP    39      25.298  34.578  83.030  1.00 29.76           O
ATOM    334  OD2 ASP    39      24.860  36.041  81.445  1.00 36.82           O
ATOM    335  C   ASP    39      22.581  31.773  81.181  1.00 26.62           C
ATOM    336  O   ASP    39      21.426  31.826  81.579  1.00 24.83           O
ATOM    337  N   ASP    40      22.918  31.086  80.096  1.00 27.24           N
ATOM    338  CA  ASP    40      21.919  30.311  79.342  1.00 27.15           C
ATOM    339  CB  ASP    40      22.520  29.713  78.068  1.00 27.25           C
ATOM    340  CG  ASP    40      22.692  30.744  76.967  1.00 29.12           C
ATOM    341  OD1 ASP    40      22.169  31.883  77.079  1.00 31.87           O
ATOM    342  OD2 ASP    40      23.385  30.427  75.997  1.00 31.62           O
ATOM    343  C   ASP    40      21.226  29.238  80.146  1.00 26.69           C
ATOM    344  O   ASP    40      20.010  29.019  79.964  1.00 26.44           O
ATOM    345  N   MET    41      21.990  28.545  80.996  1.00 27.53           N
ATOM    346  CA  MET    41      21.426  27.505  81.881  1.00 27.55           C
ATOM    347  CB  MET    41      22.518  26.766  82.672  1.00 28.11           C
ATOM    348  CG  MET    41      23.386  25.824  81.832  1.00 27.79           C
ATOM    349  SD  MET    41      24.933  25.250  82.817  0.70 27.86          SE
ATOM    350  CE  MET    41      26.300  25.146  81.476  1.00 33.34           C
ATOM    351  C   MET    41      20.394  28.130  82.818  1.00 26.96           C
ATOM    352  O   MET    41      19.331  27.583  83.044  1.00 26.08           O
ATOM    353  N   ILE    42      20.699  29.311  83.318  1.00 26.33           N
ATOM    354  CA  ILE    42      19.756  30.031  84.158  1.00 25.61           C
ATOM    355  CB  ILE    42      20.467  31.166  84.926  1.00 26.25           C
ATOM    356  CG1 ILE    42      21.518  30.578  85.900  1.00 25.24           C
ATOM    357  CD1 ILE    42      22.476  31.678  86.549  1.00 26.44           C
ATOM    358  CG2 ILE    42      19.420  32.075  85.688  1.00 26.19           C
ATOM    359  C   ILE    42      18.535  30.514  83.347  1.00 25.25           C
ATOM    360  O   ILE    42      17.389  30.269  83.724  1.00 24.15           O
ATOM    361  N   LYS    43      18.796  31.173  82.222  1.00 25.38           N
ATOM    362  CA  LYS    43      17.745  31.762  81.378  1.00 25.62           C
ATOM    363  CB  LYS    43      18.346  32.551  80.214  1.00 26.03           C
ATOM    364  CG  LYS    43      19.143  33.810  80.616  1.00 26.23           C
ATOM    365  CD  LYS    43      19.957  34.262  79.388  1.00 24.38           C
ATOM    366  CE  LYS    43      20.240  35.735  79.486  1.00 27.35           C
ATOM    367  NZ  LYS    43      20.904  36.212  78.237  1.00 26.10           N
ATOM    368  C   LYS    43      16.764  30.710  80.868  1.00 25.85           C
ATOM    369  O   LYS    43      15.580  30.994  80.724  1.00 24.83           O
ATOM    370  N   ARG    44      17.245  29.490  80.614  1.00 26.35           N
ATOM    371  CA  ARG    44      16.340  28.422  80.197  1.00 26.97           C
ATOM    372  CB  ARG    44      17.104  27.195  79.656  1.00 26.69           C
ATOM    373  CG  ARG    44      17.754  27.390  78.281  1.00 30.37           C
ATOM    374  CD  ARG    44      16.801  27.313  77.108  1.00 35.96           C
ATOM    375  NE  ARG    44      16.393  25.938  76.823  1.00 40.15           N
ATOM    376  CZ  ARG    44      15.490  25.586  75.902  1.00 42.70           C
ATOM    377  NH1 ARG    44      14.886  26.506  75.145  1.00 41.39           N
ATOM    378  NH2 ARG    44      15.193  24.300  75.727  1.00 43.13           N
ATOM    379  C   ARG    44      15.321  28.009  81.277  1.00 27.28           C
ATOM    380  O   ARG    44      14.303  27.401  80.948  1.00 27.71           O
ATOM    381  N   THR    45      15.593  28.311  82.547  1.00 27.15           N
ATOM    382  CA  THR    45      14.644  28.019  83.619  1.00 27.61           C
ATOM    383  CB  THR    45      15.326  27.716  84.985  1.00 27.21           C
ATOM    384  OG1 THR    45      15.843  28.937  85.551  1.00 29.09           O
ATOM    385  CG2 THR    45      16.436  26.718  84.856  1.00 27.55           C
ATOM    386  C   THR    45      13.690  29.185  83.899  1.00 27.14           C
ATOM    387  O   THR    45      12.780  29.023  84.684  1.00 28.51           O
ATOM    388  N   ILE    46      13.924  30.360  83.309  1.00 26.38           N
ATOM    389  CA  ILE    46      13.058  31.514  83.513  1.00 24.81           C
ATOM    390  CB  ILE    46      13.543  32.775  82.746  1.00 24.83           C
ATOM    391  CG1 ILE    46      14.857  33.293  83.339  1.00 25.02           C
ATOM    392  CD1 ILE    46      15.489  34.510  82.591  1.00 22.94           C
ATOM    393  CG2 ILE    46      12.504  33.893  82.822  1.00 26.55           C
ATOM    394  C   ILE    46      11.598  31.192  83.185  1.00 24.69           C
ATOM    395  O   ILE    46      11.268  30.770  82.062  1.00 25.30           O
ATOM    396  N   GLY    47      10.732  31.392  84.180  1.00 24.91           N
ATOM    397  CA  GLY    47       9.279  31.139  84.076  1.00 23.33           C
ATOM    398  C   GLY    47       8.809  29.870  84.793  1.00 23.77           C
ATOM    399  O   GLY    47       7.591  29.536  84.791  1.00 23.52           O
ATOM    400  N   LYS    48       9.783  29.127  85.336  1.00 22.70           N
ATOM    401  CA  LYS    48       9.524  28.036  86.281  1.00 23.25           C
ATOM    402  CB  LYS    48      10.654  27.002  86.214  1.00 22.45           C
ATOM    403  CG  LYS    48      10.857  26.464  84.806  1.00 27.54           C
ATOM    404  CD  LYS    48      11.350  25.061  84.810  1.00 32.31           C
ATOM    405  CE  LYS    48      11.689  24.601  83.391  1.00 36.95           C
ATOM    406  NZ  LYS    48      10.491  23.938  82.814  1.00 36.79           N
ATOM    407  C   LYS    48       9.493  28.706  87.663  1.00 22.37           C
ATOM    408  O   LYS    48       9.928  29.880  87.789  1.00 21.60           O
ATOM    409  N   THR    49       8.989  28.002  88.676  1.00 21.17           N
ATOM    410  CA  THR    49       9.003  28.561  90.050  1.00 22.17           C
ATOM    411  CB  THR    49       8.244  27.708  91.077  1.00 20.87           C
ATOM    412  OG1 THR    49       8.903  26.437  91.242  1.00 23.38           O
ATOM    413  CG2 THR    49       6.760  27.488  90.620  1.00 20.40           C
ATOM    414  C   THR    49      10.457  28.665  90.522  1.00 23.46           C
ATOM    415  O   THR    49      11.310  27.913  90.059  1.00 22.38           O
ATOM    416  N   LEU    50      10.739  29.592  91.434  1.00 24.65           N
ATOM    417  CA  LEU    50      12.127  29.725  91.953  1.00 25.29           C
ATOM    418  CB  LEU    50      12.165  30.782  93.045  1.00 25.19           C
ATOM    419  CG  LEU    50      11.881  32.192  92.531  1.00 24.76           C
ATOM    420  CD1 LEU    50      11.707  33.216  93.678  1.00 24.83           C
ATOM    421  CD2 LEU    50      12.921  32.656  91.473  1.00 24.86           C
ATOM    422  C   LEU    50      12.635  28.392  92.498  1.00 25.72           C
ATOM    423  O   LEU    50      13.784  28.031  92.259  1.00 26.37           O
ATOM    424  N   GLU    51      11.762  27.644  93.193  1.00 26.27           N
ATOM    425  CA  GLU    51      12.133  26.327  93.712  1.00 26.53           C
ATOM    426  CB  GLU    51      11.067  25.753  94.662  1.00 26.95           C
ATOM    427  CG  GLU    51      10.799  26.612  95.935  1.00 27.91           C
ATOM    428  CD  GLU    51       9.631  27.616  95.747  1.00 30.98           C
ATOM    429  OE1 GLU    51       9.531  28.225  94.651  1.00 27.84           O
ATOM    430  OE2 GLU    51       8.818  27.796  96.697  1.00 29.30           O
ATOM    431  C   GLU    51      12.495  25.361  92.563  1.00 26.70           C
ATOM    432  O   GLU    51      13.543  24.693  92.622  1.00 26.65           O
ATOM    433  N   GLU    52      11.646  25.293  91.523  1.00 27.02           N
ATOM    434  CA  GLU    52      11.931  24.453  90.331  1.00 26.69           C
ATOM    435  CB  GLU    52      10.818  24.546  89.280  1.00 26.89           C
ATOM    436  CG  GLU    52       9.565  23.708  89.616  1.00 28.41           C
ATOM    437  CD  GLU    52       8.298  24.195  88.906  1.00 28.69           C
ATOM    438  OE1 GLU    52       8.320  25.246  88.220  1.00 31.19           O
ATOM    439  OE2 GLU    52       7.255  23.527  89.047  1.00 31.98           O
ATOM    440  C   GLU    52      13.278  24.832  89.707  1.00 26.26           C
ATOM    441  O   GLU    52      14.060  23.956  89.329  1.00 24.51           O
ATOM    442  N   SER    53      13.532  26.142  89.600  1.00 25.45           N
ATOM    443  CA  SER    53      14.754  26.635  88.976  1.00 26.02           C
ATOM    444  CB  SER    53      14.733  28.183  88.851  1.00 26.87           C
ATOM    445  OG  SER    53      13.863  28.622  87.824  1.00 26.36           O
ATOM    446  C   SER    53      15.994  26.192  89.745  1.00 25.31           C
ATOM    447  O   SER    53      16.960  25.740  89.144  1.00 26.23           O
ATOM    448  N   PHE    54      15.943  26.324  91.074  1.00 24.48           N
ATOM    449  CA  PHE    54      17.041  25.939  91.939  1.00 24.94           C
ATOM    450  CB  PHE    54      16.828  26.429  93.379  1.00 24.22           C
ATOM    451  CG  PHE    54      17.314  27.821  93.595  1.00 24.36           C
ATOM    452  CD1 PHE    54      18.692  28.100  93.537  1.00 25.21           C
ATOM    453  CE1 PHE    54      19.151  29.414  93.696  1.00 23.93           C
ATOM    454  CZ  PHE    54      18.245  30.469  93.922  1.00 22.16           C
ATOM    455  CE2 PHE    54      16.879  30.206  93.962  1.00 21.57           C
ATOM    456  CD2 PHE    54      16.424  28.860  93.808  1.00 24.28           C
ATOM    457  C   PHE    54      17.269  24.459  91.906  1.00 25.07           C
ATOM    458  O   PHE    54      18.403  24.013  91.957  1.00 25.61           O
ATOM    459  N   SER    55      16.185  23.697  91.814  1.00 25.58           N
ATOM    460  CA  SER    55      16.289  22.240  91.782  1.00 25.02           C
ATOM    461  CB  SER    55      14.885  21.632  91.952  1.00 25.86           C
ATOM    462  OG  SER    55      15.001  20.280  92.366  1.00 28.30           O
ATOM    463  C   SER    55      16.974  21.726  90.521  1.00 25.49           C
ATOM    464  O   SER    55      17.877  20.852  90.563  1.00 24.97           O
ATOM    465  N   ILE    56      16.567  22.276  89.382  1.00 25.10           N
ATOM    466  CA  ILE    56      17.206  21.977  88.089  1.00 24.88           C
ATOM    467  CB  ILE    56      16.501  22.738  86.958  1.00 23.93           C
ATOM    468  CG1 ILE    56      15.098  22.148  86.700  1.00 24.64           C
ATOM    469  CD1 ILE    56      14.219  23.069  85.849  1.00 26.32           C
ATOM    470  CG2 ILE    56      17.285  22.712  85.666  1.00 23.81           C
ATOM    471  C   ILE    56      18.725  22.286  88.101  1.00 25.96           C
ATOM    472  O   ILE    56      19.548  21.464  87.658  1.00 26.22           O
ATOM    473  N   LEU    57      19.077  23.437  88.643  1.00 25.28           N
ATOM    474  CA  LEU    57      20.452  23.926  88.580  1.00 26.41           C
ATOM    475  CB  LEU    57      20.476  25.473  88.677  1.00 26.10           C
ATOM    476  CG  LEU    57      19.797  26.281  87.549  1.00 25.31           C
ATOM    477  CD1 LEU    57      19.590  27.811  87.876  1.00 24.42           C
ATOM    478  CD2 LEU    57      20.549  26.150  86.258  1.00 23.96           C
ATOM    479  C   LEU    57      21.404  23.285  89.603  1.00 26.46           C
ATOM    480  O   LEU    57      22.597  23.162  89.332  1.00 27.03           O
ATOM    481  N   THR    58      20.890  22.907  90.779  1.00 26.54           N
ATOM    482  CA  THR    58      21.703  22.296  91.848  1.00 25.19           C
ATOM    483  CB  THR    58      21.407  22.960  93.218  1.00 24.76           C
ATOM    484  OG1 THR    58      20.040  22.701  93.558  1.00 22.88           O
ATOM    485  CG2 THR    58      21.592  24.487  93.148  1.00 23.07           C
ATOM    486  C   THR    58      21.414  20.794  92.006  1.00 25.76           C
ATOM    487  O   THR    58      22.217  20.058  92.544  1.00 27.33           O
ATOM    488  N   GLY    59      20.252  20.343  91.561  1.00 25.51           N
ATOM    489  CA  GLY    59      19.789  18.997  91.902  1.00 24.36           C
ATOM    490  C   GLY    59      19.194  18.863  93.306  1.00 24.11           C
ATOM    491  O   GLY    59      18.716  17.795  93.663  1.00 23.45           O
ATOM    492  N   ILE    60      19.181  19.933  94.109  1.00 24.01           N
ATOM    493  CA  ILE    60      18.608  19.829  95.456  0.60 24.03           C
ATOM    495  CB  ILE    60      18.996  21.031  96.372  0.60 24.36           C
ATOM    497  CG1 ILE    60      20.453  20.901  96.820  0.60 24.92           C
ATOM    499  CD1 ILE    60      21.041  22.199  97.316  0.60 25.59           C
ATOM    501  CG2 ILE    60      18.063  21.154  97.600  0.60 22.40           C
ATOM    503  C   ILE    60      17.097  19.657  95.359  1.00 23.93           C
ATOM    504  O   ILE    60      16.445  20.324  94.582  1.00 24.92           O
ATOM    505  N   THR    61      16.553  18.731  96.142  1.00 24.07           N
ATOM    506  CA  THR    61      15.102  18.557  96.226  1.00 24.63           C
ATOM    507  CB  THR    61      14.642  17.146  95.788  1.00 25.05           C
ATOM    508  OG1 THR    61      15.257  16.165  96.623  1.00 25.67           O
ATOM    509  CG2 THR    61      15.008  16.884  94.295  1.00 23.70           C
ATOM    510  C   THR    61      14.546  18.812  97.622  1.00 25.41           C
ATOM    511  O   THR    61      13.327  18.874  97.799  1.00 25.44           O
ATOM    512  N   ASP    62      15.414  18.953  98.616  1.00 25.97           N
ATOM    513  CA  ASP    62      14.940  19.168  99.975  1.00 26.85           C
ATOM    514  CB  ASP    62      16.123  19.263 100.924  1.00 27.34           C
ATOM    515  CG  ASP    62      15.686  19.493 102.364  1.00 27.87           C
ATOM    516  OD1 ASP    62      15.320  18.536 103.033  1.00 26.73           O
ATOM    517  OD2 ASP    62      15.681  20.648 102.808  1.00 29.98           O
ATOM    518  C   ASP    62      14.055  20.416 100.096  1.00 27.29           C
ATOM    519  O   ASP    62      14.498  21.513  99.759  1.00 27.17           O
ATOM    520  N   ALA    63      12.815  20.247 100.578  1.00 27.89           N
ATOM    521  CA  ALA    63      11.841  21.362 100.623  1.00 28.56           C
ATOM    522  CB  ALA    63      10.473  20.885 101.185  1.00 29.00           C
ATOM    523  C   ALA    63      12.365  22.574 101.413  1.00 28.72           C
ATOM    524  O   ALA    63      12.181  23.737 100.997  1.00 28.41           O
ATOM    525  N   ASP    64      13.062  22.286 102.519  1.00 28.89           N
ATOM    526  CA  ASP    64      13.636  23.318 103.381  1.00 29.22           C
ATOM    527  CB  ASP    64      14.104  22.745 104.727  1.00 29.26           C
ATOM    528  CG  ASP    64      12.955  22.355 105.612  1.00 31.48           C
ATOM    529  OD1 ASP    64      11.883  22.985 105.491  1.00 33.02           O
ATOM    530  OD2 ASP    64      13.117  21.425 106.436  1.00 32.85           O
ATOM    531  C   ASP    64      14.761  24.101 102.734  1.00 28.56           C
ATOM    532  O   ASP    64      14.778  25.332 102.821  1.00 27.54           O
ATOM    533  N   GLN    65      15.693  23.399 102.094  1.00 28.14           N
ATOM    534  CA  GLN    65      16.797  24.053 101.374  1.00 28.49           C
ATOM    535  CB  GLN    65      17.810  23.019 100.894  1.00 28.50           C
ATOM    536  CG  GLN    65      18.506  22.248 102.012  1.00 29.11           C
ATOM    537  CD  GLN    65      19.533  21.230 101.486  1.00 31.31           C
ATOM    538  OE1 GLN    65      19.302  20.014 101.549  1.00 36.90           O
ATOM    539  NE2 GLN    65      20.665  21.718 100.968  1.00 31.64           N
ATOM    540  C   GLN    65      16.294  24.925 100.207  1.00 27.91           C
ATOM    541  O   GLN    65      16.720  26.065 100.039  1.00 26.59           O
ATOM    542  N   LEU    66      15.354  24.399  99.424  1.00 27.56           N
ATOM    543  CA  LEU    66      14.760  25.168  98.315  1.00 27.18           C
ATOM    544  CB  LEU    66      13.828  24.262  97.500  1.00 26.84           C
ATOM    545  CG  LEU    66      14.384  23.094  96.659  1.00 25.18           C
ATOM    546  CD1 LEU    66      13.259  22.275  95.982  1.00 26.79           C
ATOM    547  CD2 LEU    66      15.394  23.586  95.617  1.00 26.21           C
ATOM    548  C   LEU    66      14.021  26.436  98.781  1.00 27.05           C
ATOM    549  O   LEU    66      14.030  27.475  98.112  1.00 27.94           O
ATOM    550  N   GLU    67      13.384  26.341  99.942  1.00 26.89           N
ATOM    551  CA  GLU    67      12.700  27.468 100.554  1.00 26.69           C
ATOM    552  CB  GLU    67      11.852  27.010 101.775  1.00 25.64           C
ATOM    553  CG  GLU    67      11.223  28.113 102.640  1.00 25.90           C
ATOM    554  CD  GLU    67      10.382  29.109 101.877  1.00 26.46           C
ATOM    555  OE1 GLU    67       9.834  28.789 100.804  1.00 28.66           O
ATOM    556  OE2 GLU    67      10.256  30.247 102.350  1.00 27.59           O
ATOM    557  C   GLU    67      13.737  28.504 100.941  1.00 26.18           C
ATOM    558  O   GLU    67      13.521  29.697 100.822  1.00 27.27           O
ATOM    559  N   SER    68      14.864  28.030 101.412  1.00 25.95           N
ATOM    560  CA  SER    68      15.911  28.898 101.879  1.00 26.31           C
ATOM    561  CB  SER    68      16.905  28.051 102.681  1.00 27.25           C
ATOM    562  OG  SER    68      17.994  28.784 103.157  1.00 29.24           O
ATOM    563  C   SER    68      16.535  29.651 100.699  1.00 26.07           C
ATOM    564  O   SER    68      16.763  30.856 100.805  1.00 25.00           O
ATOM    565  N   PHE    69      16.778  28.949  99.576  1.00 25.50           N
ATOM    566  CA  PHE    69      17.248  29.581  98.336  1.00 25.19           C
ATOM    567  CB  PHE    69      17.395  28.567  97.206  1.00 24.70           C
ATOM    568  CG  PHE    69      18.512  27.567  97.370  1.00 25.53           C
ATOM    569  CD1 PHE    69      19.702  27.887  98.035  1.00 26.70           C
ATOM    570  CE1 PHE    69      20.716  26.931  98.150  1.00 28.65           C
ATOM    571  CZ  PHE    69      20.562  25.651  97.571  1.00 27.03           C
ATOM    572  CE2 PHE    69      19.400  25.335  96.879  1.00 26.24           C
ATOM    573  CD2 PHE    69      18.379  26.292  96.790  1.00 24.38           C
ATOM    574  C   PHE    69      16.257  30.631  97.865  1.00 24.69           C
ATOM    575  O   PHE    69      16.655  31.729  97.486  1.00 25.89           O
ATOM    576  N   ARG    70      14.963  30.295  97.896  1.00 24.28           N
ATOM    577  CA  ARG    70      13.876  31.203  97.490  1.00 23.48           C
ATOM    578  CB  ARG    70      12.516  30.535  97.711  1.00 23.43           C
ATOM    579  CG  ARG    70      11.343  31.373  97.169  1.00 25.93           C
ATOM    580  CD  ARG    70      10.008  30.924  97.709  1.00 25.22           C
ATOM    581  NE  ARG    70       9.848  31.220  99.143  1.00 26.87           N
ATOM    582  CZ  ARG    70       9.657  32.446  99.638  1.00 27.45           C
ATOM    583  NH1 ARG    70       9.620  33.480  98.814  1.00 26.75           N
ATOM    584  NH2 ARG    70       9.495  32.643 100.949  1.00 28.49           N
ATOM    585  C   ARG    70      13.917  32.522  98.251  1.00 23.63           C
ATOM    586  O   ARG    70      13.823  33.591  97.647  1.00 22.87           O
ATOM    587  N   GLN    71      13.983  32.423  99.588  1.00 24.69           N
ATOM    588  CA  GLN    71      14.148  33.569 100.473  1.00 24.47           C
ATOM    589  CB  GLN    71      14.208  33.113 101.938  1.00 24.70           C
ATOM    590  CG  GLN    71      12.897  32.571 102.509  1.00 23.50           C
ATOM    591  CD  GLN    71      13.097  31.859 103.828  1.00 24.98           C
ATOM    592  OE1 GLN    71      14.166  31.958 104.450  1.00 26.69           O
ATOM    593  NE2 GLN    71      12.069  31.118 104.266  1.00 23.32           N
ATOM    594  C   GLN    71      15.412  34.369 100.148  1.00 24.87           C
ATOM    595  O   GLN    71      15.378  35.588 100.119  1.00 24.95           O
ATOM    596  N   GLU    72      16.542  33.690  99.980  1.00 24.71           N
ATOM    597  CA  GLU    72      17.777  34.399  99.663  1.00 25.66           C
ATOM    598  CB  GLU    72      18.938  33.406  99.674  1.00 25.45           C
ATOM    599  CG  GLU    72      19.357  32.975 101.071  1.00 26.54           C
ATOM    600  CD  GLU    72      20.359  31.818 101.078  1.00 28.99           C
ATOM    601  OE1 GLU    72      21.071  31.648 100.085  1.00 32.62           O
ATOM    602  OE2 GLU    72      20.431  31.065 102.092  1.00 33.57           O
ATOM    603  C   GLU    72      17.666  35.107  98.301  1.00 25.67           C
ATOM    604  O   GLU    72      18.076  36.264  98.131  1.00 24.17           O
ATOM    605  N   TYR    73      17.052  34.419  97.340  1.00 25.70           N
ATOM    606  CA  TYR    73      16.782  35.028  96.031  1.00 26.68           C
ATOM    607  CB  TYR    73      16.141  33.993  95.088  1.00 27.29           C
ATOM    608  CG  TYR    73      15.817  34.512  93.695  1.00 28.20           C
ATOM    609  CD1 TYR    73      16.590  34.132  92.591  1.00 31.03           C
ATOM    610  CE1 TYR    73      16.285  34.585  91.282  1.00 29.75           C
ATOM    611  CZ  TYR    73      15.199  35.431  91.091  1.00 29.58           C
ATOM    612  OH  TYR    73      14.893  35.862  89.827  1.00 32.21           O
ATOM    613  CE2 TYR    73      14.401  35.810  92.161  1.00 29.04           C
ATOM    614  CD2 TYR    73      14.705  35.338  93.469  1.00 28.75           C
ATOM    615  C   TYR    73      15.905  36.296  96.138  1.00 26.82           C
ATOM    616  O   TYR    73      16.250  37.340  95.564  1.00 26.25           O
ATOM    617  N   SER    74      14.783  36.199  96.862  0.50 26.64           N
ATOM    619  CA  SER    74      13.862  37.328  97.008  0.50 27.01           C
ATOM    621  CB  SER    74      12.685  36.962  97.910  0.50 27.18           C
ATOM    623  OG  SER    74      11.538  37.724  97.557  0.50 26.47           O
ATOM    625  C   SER    74      14.576  38.564  97.555  0.50 27.39           C
ATOM    627  O   SER    74      14.302  39.694  97.129  0.50 27.58           O
ATOM    629  N   LYS    75      15.496  38.332  98.487  1.00 27.15           N
ATOM    630  CA  LYS    75      16.264  39.395  99.111  1.00 28.12           C
ATOM    631  CB  LYS    75      17.103  38.764 100.231  1.00 28.56           C
ATOM    632  CG  LYS    75      17.802  39.682 101.185  1.00 32.79           C
ATOM    633  CD  LYS    75      18.493  38.854 102.259  1.00 38.68           C
ATOM    634  CE  LYS    75      19.947  39.309 102.517  1.00 38.87           C
ATOM    635  NZ  LYS    75      20.549  38.508 103.616  1.00 39.60           N
ATOM    636  C   LYS    75      17.132  40.113  98.068  1.00 27.74           C
ATOM    637  O   LYS    75      17.167  41.341  98.035  1.00 27.27           O
ATOM    638  N   GLU    76      17.836  39.358  97.232  1.00 27.05           N
ATOM    639  CA  GLU    76      18.574  39.934  96.084  1.00 27.52           C
ATOM    640  CB  GLU    76      19.272  38.825  95.298  1.00 28.38           C
ATOM    641  CG  GLU    76      20.420  38.166  96.041  1.00 32.40           C
ATOM    642  CD  GLU    76      21.373  39.177  96.643  1.00 37.32           C
ATOM    643  OE1 GLU    76      22.041  39.882  95.873  1.00 41.38           O
ATOM    644  OE2 GLU    76      21.445  39.279  97.891  1.00 42.83           O
ATOM    645  C   GLU    76      17.646  40.667  95.132  1.00 26.18           C
ATOM    646  O   GLU    76      17.940  41.796  94.680  1.00 25.71           O
ATOM    647  N   ALA    77      16.503  40.036  94.853  1.00 24.98           N
ATOM    648  CA  ALA    77      15.527  40.597  93.911  1.00 25.01           C
ATOM    649  CB  ALA    77      14.441  39.616  93.558  1.00 24.14           C
ATOM    650  C   ALA    77      14.968  41.921  94.385  1.00 25.02           C
ATOM    651  O   ALA    77      14.687  42.790  93.555  1.00 25.34           O
ATOM    652  N   ASP    78      14.808  42.089  95.700  1.00 24.54           N
ATOM    653  CA  ASP    78      14.370  43.367  96.242  1.00 26.20           C
ATOM    654  CB  ASP    78      14.339  43.313  97.762  1.00 26.67           C
ATOM    655  CG  ASP    78      13.163  42.508  98.284  1.00 27.47           C
ATOM    656  OD1 ASP    78      12.146  42.414  97.575  1.00 25.08           O
ATOM    657  OD2 ASP    78      13.260  41.999  99.413  1.00 30.35           O
ATOM    658  C   ASP    78      15.322  44.469  95.810  1.00 26.21           C
ATOM    659  O   ASP    78      14.900  45.567  95.596  1.00 27.41           O
ATOM    660  N   ILE    79      16.608  44.147  95.685  1.00 26.39           N
ATOM    661  CA  ILE    79      17.655  45.100  95.331  1.00 26.83           C
ATOM    662  CB  ILE    79      19.024  44.667  95.967  1.00 26.42           C
ATOM    663  CG1 ILE    79      18.905  44.596  97.489  1.00 28.17           C
ATOM    664  CD1 ILE    79      19.940  43.679  98.124  1.00 32.50           C
ATOM    665  CG2 ILE    79      20.171  45.656  95.620  1.00 26.87           C
ATOM    666  C   ILE    79      17.801  45.282  93.803  1.00 27.25           C
ATOM    667  O   ILE    79      17.844  46.412  93.298  1.00 27.67           O
ATOM    668  N   TYR    80      17.850  44.175  93.065  1.00 28.09           N
ATOM    669  CA  TYR    80      18.283  44.231  91.669  1.00 29.09           C
ATOM    670  CB  TYR    80      19.430  43.251  91.445  1.00 30.35           C
ATOM    671  CG  TYR    80      20.624  43.542  92.288  1.00 31.85           C
ATOM    672  CD1 TYR    80      21.417  44.656  92.027  1.00 33.38           C
ATOM    673  CE1 TYR    80      22.552  44.925  92.804  1.00 34.84           C
ATOM    674  CZ  TYR    80      22.891  44.051  93.829  1.00 34.31           C
ATOM    675  OH  TYR    80      24.003  44.316  94.596  1.00 37.11           O
ATOM    676  CE2 TYR    80      22.118  42.931  94.100  1.00 33.96           C
ATOM    677  CD2 TYR    80      20.994  42.679  93.330  1.00 33.10           C
ATOM    678  C   TYR    80      17.249  43.990  90.600  1.00 28.71           C
ATOM    679  O   TYR    80      17.465  44.332  89.439  1.00 29.24           O
ATOM    680  N   MET    81      16.145  43.358  90.959  1.00 29.54           N
ATOM    681  CA  MET    81      15.196  42.853  89.940  1.00 28.80           C
ATOM    682  CB  MET    81      14.077  42.026  90.588  1.00 28.41           C
ATOM    683  CG  MET    81      13.115  41.381  89.582  1.00 28.54           C
ATOM    684  SD  MET    81      14.037  40.229  88.311  0.70 27.31          SE
ATOM    685  CE  MET    81      14.470  38.788  89.533  1.00 30.27           C
ATOM    686  C   MET    81      14.613  43.911  89.010  1.00 29.54           C
ATOM    687  O   MET    81      14.888  43.911  87.811  1.00 29.33           O
ATOM    688  N   ASN    82      13.792  44.807  89.546  1.00 29.64           N
ATOM    689  CA  ASN    82      13.108  45.772  88.689  1.00 29.82           C
ATOM    690  CB  ASN    82      11.882  46.382  89.386  1.00 29.60           C
ATOM    691  CG  ASN    82      10.784  45.340  89.651  1.00 30.77           C
ATOM    692  OD1 ASN    82      10.740  44.270  89.017  1.00 27.12           O
ATOM    693  ND2 ASN    82       9.870  45.668  90.561  1.00 31.10           N
ATOM    694  C   ASN    82      14.039  46.813  88.082  1.00 29.59           C
ATOM    695  O   ASN    82      13.738  47.380  87.033  1.00 29.59           O
ATOM    696  N   ALA    83      15.190  47.031  88.711  1.00 29.49           N
ATOM    697  CA  ALA    83      16.180  47.968  88.163  1.00 29.25           C
ATOM    698  CB  ALA    83      17.229  48.309  89.216  1.00 28.99           C
ATOM    699  C   ALA    83      16.845  47.377  86.920  1.00 29.57           C
ATOM    700  O   ALA    83      17.412  48.104  86.104  1.00 29.19           O
ATOM    701  N   ASN    84      16.807  46.047  86.816  1.00 29.10           N
ATOM    702  CA  ASN    84      17.450  45.340  85.729  1.00 29.00           C
ATOM    703  CB  ASN    84      18.540  44.429  86.283  1.00 29.02           C
ATOM    704  CG  ASN    84      19.706  45.231  86.858  1.00 31.57           C
ATOM    705  OD1 ASN    84      20.535  45.742  86.100  1.00 33.11           O
ATOM    706  ND2 ASN    84      19.744  45.396  88.188  1.00 28.26           N
ATOM    707  C   ASN    84      16.402  44.576  84.944  1.00 28.17           C
ATOM    708  O   ASN    84      16.602  43.439  84.537  1.00 27.97           O
ATOM    709  N   THR    85      15.251  45.232  84.789  1.00 27.16           N
ATOM    710  CA  THR    85      14.185  44.777  83.944  1.00 25.13           C
ATOM    711  CB  THR    85      12.920  44.432  84.742  1.00 25.07           C
ATOM    712  OG1 THR    85      13.158  43.304  85.625  1.00 25.99           O
ATOM    713  CG2 THR    85      11.824  44.062  83.799  1.00 23.70           C
ATOM    714  C   THR    85      13.914  45.945  82.997  1.00 24.02           C
ATOM    715  O   THR    85      13.845  47.113  83.419  1.00 23.39           O
ATOM    716  N   ILE    86      13.762  45.639  81.713  1.00 23.54           N
ATOM    717  CA  ILE    86      13.426  46.681  80.718  1.00 22.56           C
ATOM    718  CB  ILE    86      14.574  46.876  79.682  1.00 23.19           C
ATOM    719  CG1 ILE    86      14.888  45.576  78.937  1.00 21.71           C
ATOM    720  CD1 ILE    86      15.941  45.757  77.811  1.00 21.68           C
ATOM    721  CG2 ILE    86      15.863  47.412  80.376  1.00 24.58           C
ATOM    722  C   ILE    86      12.104  46.310  80.016  1.00 22.41           C
ATOM    723  O   ILE    86      11.770  45.125  79.931  1.00 22.12           O
ATOM    724  N   LEU    87      11.383  47.301  79.495  1.00 20.46           N
ATOM    725  CA  LEU    87      10.271  47.047  78.556  1.00 21.06           C
ATOM    726  CB  LEU    87       9.527  48.370  78.228  1.00 20.51           C
ATOM    727  CG  LEU    87       8.794  49.100  79.348  1.00 20.09           C
ATOM    728  CD1 LEU    87       8.384  50.552  78.995  1.00 16.88           C
ATOM    729  CD2 LEU    87       7.596  48.304  79.781  1.00 18.68           C
ATOM    730  C   LEU    87      10.799  46.471  77.222  1.00 21.20           C
ATOM    731  O   LEU    87      11.927  46.754  76.831  1.00 21.66           O
ATOM    732  N   PHE    88       9.987  45.674  76.538  1.00 20.05           N
ATOM    733  CA  PHE    88      10.257  45.319  75.142  1.00 20.27           C
ATOM    734  CB  PHE    88       9.515  44.018  74.724  1.00 19.56           C
ATOM    735  CG  PHE    88      10.201  42.735  75.188  1.00 20.59           C
ATOM    736  CD1 PHE    88      11.463  42.382  74.702  1.00 23.45           C
ATOM    737  CE1 PHE    88      12.081  41.228  75.105  1.00 22.55           C
ATOM    738  CZ  PHE    88      11.481  40.419  76.026  1.00 20.15           C
ATOM    739  CE2 PHE    88      10.225  40.743  76.509  1.00 24.68           C
ATOM    740  CD2 PHE    88       9.595  41.893  76.090  1.00 21.23           C
ATOM    741  C   PHE    88       9.828  46.473  74.259  1.00 20.40           C
ATOM    742  O   PHE    88       8.905  47.226  74.628  1.00 21.31           O
ATOM    743  N   PRO    89      10.505  46.651  73.100  1.00 20.26           N
ATOM    744  CA  PRO    89      10.186  47.730  72.178  1.00 20.40           C
ATOM    745  CB  PRO    89      11.007  47.367  70.922  1.00 20.36           C
ATOM    746  CG  PRO    89      12.204  46.716  71.480  1.00 21.73           C
ATOM    747  CD  PRO    89      11.653  45.860  72.614  1.00 20.33           C
ATOM    748  C   PRO    89       8.712  47.879  71.828  1.00 20.08           C
ATOM    749  O   PRO    89       8.274  48.994  71.528  1.00 20.03           O
ATOM    750  N   ASP    90       7.968  46.772  71.838  1.00 20.35           N
ATOM    751  CA  ASP    90       6.579  46.769  71.395  1.00 20.75           C
ATOM    752  CB  ASP    90       6.297  45.545  70.510  1.00 21.27           C
ATOM    753  CG  ASP    90       7.023  45.583  69.186  1.00 22.79           C
ATOM    754  OD1 ASP    90       7.466  46.661  68.743  1.00 24.07           O
ATOM    755  OD2 ASP    90       7.119  44.521  68.561  1.00 25.29           O
ATOM    756  C   ASP    90       5.548  46.757  72.517  1.00 20.34           C
ATOM    757  O   ASP    90       4.351  46.681  72.247  1.00 20.78           O
ATOM    758  N   THR    91       5.989  46.807  73.765  1.00 20.54           N
ATOM    759  CA  THR    91       5.087  46.550  74.890  1.00 19.97           C
ATOM    760  CB  THR    91       5.857  46.390  76.213  1.00 19.95           C
ATOM    761  OG1 THR    91       6.664  45.219  76.137  1.00 22.13           O
ATOM    762  CG2 THR    91       4.911  46.239  77.384  1.00 20.27           C
ATOM    763  C   THR    91       4.029  47.633  75.011  1.00 19.15           C
ATOM    764  O   THR    91       2.838  47.342  75.001  1.00 18.57           O
ATOM    765  N   LEU    92       4.478  48.877  75.141  1.00 18.33           N
ATOM    766  CA  LEU    92       3.569  49.989  75.332  1.00 18.26           C
ATOM    767  CB  LEU    92       4.323  51.266  75.763  1.00 17.66           C
ATOM    768  CG  LEU    92       5.227  51.281  77.007  1.00 15.19           C
ATOM    769  CD1 LEU    92       5.965  52.631  77.097  1.00 11.30           C
ATOM    770  CD2 LEU    92       4.395  51.084  78.225  1.00 16.51           C
ATOM    771  C   LEU    92       2.692  50.262  74.103  1.00 18.76           C
ATOM    772  O   LEU    92       1.479  50.461  74.258  1.00 20.01           O
ATOM    773  N   PRO    93       3.285  50.318  72.885  1.00 18.59           N
ATOM    774  CA  PRO    93       2.364  50.587  71.758  1.00 18.67           C
ATOM    775  CB  PRO    93       3.292  50.693  70.536  1.00 18.83           C
ATOM    776  CG  PRO    93       4.698  50.769  71.074  1.00 18.40           C
ATOM    777  CD  PRO    93       4.685  50.178  72.449  1.00 18.35           C
ATOM    778  C   PRO    93       1.340  49.477  71.546  1.00 18.83           C
ATOM    779  O   PRO    93       0.227  49.749  71.129  1.00 18.94           O
ATOM    780  N   THR    94       1.708  48.232  71.826  1.00 19.04           N
ATOM    781  CA  THR    94       0.799  47.110  71.575  1.00 18.95           C
ATOM    782  CB  THR    94       1.516  45.739  71.710  1.00 19.65           C
ATOM    783  OG1 THR    94       2.523  45.622  70.690  1.00 19.01           O
ATOM    784  CG2 THR    94       0.513  44.590  71.527  1.00 18.15           C
ATOM    785  C   THR    94      -0.385  47.186  72.529  1.00 19.25           C
ATOM    786  O   THR    94      -1.541  47.153  72.113  1.00 19.28           O
ATOM    787  N   LEU    95      -0.073  47.296  73.816  1.00 19.96           N
ATOM    788  CA  LEU    95      -1.064  47.294  74.859  1.00 20.68           C
ATOM    789  CB  LEU    95      -0.380  47.224  76.227  1.00 21.67           C
ATOM    790  CG  LEU    95       0.341  45.925  76.619  1.00 22.31           C
ATOM    791  CD1 LEU    95       0.903  46.007  78.025  1.00 26.20           C
ATOM    792  CD2 LEU    95      -0.599  44.775  76.550  1.00 26.86           C
ATOM    793  C   LEU    95      -1.964  48.513  74.739  1.00 21.16           C
ATOM    794  O   LEU    95      -3.156  48.409  75.010  1.00 21.22           O
ATOM    795  N   THR    96      -1.408  49.655  74.304  1.00 21.25           N
ATOM    796  CA  THR    96      -2.213  50.844  74.008  1.00 21.22           C
ATOM    797  CB  THR    96      -1.338  52.040  73.563  1.00 21.29           C
ATOM    798  OG1 THR    96      -0.447  52.403  74.605  1.00 22.50           O
ATOM    799  CG2 THR    96      -2.194  53.256  73.207  1.00 21.56           C
ATOM    800  C   THR    96      -3.212  50.575  72.883  1.00 21.43           C
ATOM    801  O   THR    96      -4.374  50.993  72.946  1.00 20.99           O
ATOM    802  N   HIS    97      -2.737  49.910  71.833  1.00 21.94           N
ATOM    803  CA  HIS    97      -3.573  49.581  70.677  1.00 22.43           C
ATOM    804  CB  HIS    97      -2.729  48.978  69.553  1.00 22.64           C
ATOM    805  CG  HIS    97      -3.449  48.856  68.245  1.00 25.32           C
ATOM    806  ND1 HIS    97      -4.263  47.784  67.938  1.00 28.13           N
ATOM    807  CE1 HIS    97      -4.763  47.944  66.725  1.00 28.68           C
ATOM    808  NE2 HIS    97      -4.302  49.081  66.232  1.00 29.53           N
ATOM    809  CD2 HIS    97      -3.471  49.667  67.160  1.00 26.78           C
ATOM    810  C   HIS    97      -4.720  48.648  71.076  1.00 22.49           C
ATOM    811  O   HIS    97      -5.854  48.863  70.656  1.00 22.54           O
ATOM    812  N   LEU    98      -4.430  47.629  71.890  1.00 22.90           N
ATOM    813  CA  LEU    98      -5.458  46.702  72.362  1.00 23.05           C
ATOM    814  CB  LEU    98      -4.842  45.521  73.120  1.00 22.74           C
ATOM    815  CG  LEU    98      -3.923  44.586  72.326  1.00 20.64           C
ATOM    816  CD1 LEU    98      -3.169  43.591  73.244  1.00 19.50           C
ATOM    817  CD2 LEU    98      -4.696  43.869  71.205  1.00 15.85           C
ATOM    818  C   LEU    98      -6.521  47.403  73.206  1.00 24.50           C
ATOM    819  O   LEU    98      -7.726  47.184  73.018  1.00 24.67           O
ATOM    820  N   LYS    99      -6.088  48.277  74.109  1.00 25.44           N
ATOM    821  CA  LYS    99      -7.014  48.998  74.982  1.00 26.42           C
ATOM    822  CB  LYS    99      -6.260  49.699  76.127  1.00 26.77           C
ATOM    823  CG  LYS    99      -5.628  48.723  77.140  1.00 26.71           C
ATOM    824  CD  LYS    99      -4.999  49.441  78.340  1.00 26.66           C
ATOM    825  CE  LYS    99      -6.024  50.184  79.192  1.00 27.89           C
ATOM    826  NZ  LYS    99      -6.935  49.263  79.920  1.00 27.25           N
ATOM    827  C   LYS    99      -7.900  49.979  74.213  1.00 26.96           C
ATOM    828  O   LYS    99      -9.057  50.203  74.591  1.00 27.40           O
ATOM    829  N   LYS   100      -7.366  50.550  73.134  1.00 27.31           N
ATOM    830  CA  LYS   100      -8.170  51.373  72.221  1.00 27.99           C
ATOM    831  CB  LYS   100      -7.292  52.088  71.196  1.00 27.98           C
ATOM    832  CG  LYS   100      -6.720  53.359  71.726  1.00 28.10           C
ATOM    833  CD  LYS   100      -5.347  53.618  71.174  1.00 28.05           C
ATOM    834  CE  LYS   100      -4.886  55.015  71.598  1.00 27.96           C
ATOM    835  NZ  LYS   100      -3.640  55.417  70.892  1.00 27.88           N
ATOM    836  C   LYS   100      -9.232  50.545  71.508  1.00 28.41           C
ATOM    837  O   LYS   100     -10.315  51.042  71.219  1.00 28.22           O
ATOM    838  N   GLN   101      -8.914  49.284  71.229  1.00 28.51           N
ATOM    839  CA  GLN   101      -9.890  48.354  70.668  1.00 29.51           C
ATOM    840  CB  GLN   101      -9.191  47.086  70.149  1.00 29.23           C
ATOM    841  CG  GLN   101      -8.506  47.273  68.804  1.00 30.53           C
ATOM    842  CD  GLN   101      -7.812  46.019  68.316  1.00 31.28           C
ATOM    843  OE1 GLN   101      -6.947  45.463  68.993  1.00 33.95           O
ATOM    844  NE2 GLN   101      -8.189  45.565  67.126  1.00 33.53           N
ATOM    845  C   GLN   101     -10.974  47.988  71.693  1.00 28.92           C
ATOM    846  O   GLN   101     -12.006  47.445  71.332  1.00 29.19           O
ATOM    847  N   GLY   102     -10.732  48.279  72.970  1.00 28.44           N
ATOM    848  CA  GLY   102     -11.660  47.886  74.028  1.00 27.66           C
ATOM    849  C   GLY   102     -11.490  46.434  74.428  1.00 26.90           C
ATOM    850  O   GLY   102     -12.374  45.836  75.033  1.00 27.53           O
ATOM    851  N   ILE   103     -10.357  45.856  74.068  1.00 25.97           N
ATOM    852  CA  ILE   103      -9.954  44.571  74.592  1.00 25.15           C
ATOM    853  CB  ILE   103      -8.891  43.916  73.657  1.00 25.72           C
ATOM    854  CG1 ILE   103      -9.598  43.387  72.394  1.00 28.75           C
ATOM    855  CD1 ILE   103      -8.858  43.602  71.071  1.00 32.21           C
ATOM    856  CG2 ILE   103      -8.148  42.768  74.356  1.00 24.81           C
ATOM    857  C   ILE   103      -9.470  44.760  76.047  1.00 24.11           C
ATOM    858  O   ILE   103      -8.841  45.775  76.378  1.00 23.64           O
ATOM    859  N   ARG   104      -9.836  43.809  76.905  1.00 22.93           N
ATOM    860  CA  ARG   104      -9.393  43.739  78.295  1.00 22.38           C
ATOM    861  CB  ARG   104     -10.432  43.052  79.189  1.00 21.82           C
ATOM    862  CG  ARG   104     -11.639  43.963  79.511  1.00 22.99           C
ATOM    863  CD  ARG   104     -12.555  43.350  80.543  1.00 23.79           C
ATOM    864  NE  ARG   104     -13.217  42.158  80.016  1.00 26.02           N
ATOM    865  CZ  ARG   104     -13.959  41.322  80.739  1.00 26.04           C
ATOM    866  NH1 ARG   104     -14.138  41.542  82.034  1.00 25.71           N
ATOM    867  NH2 ARG   104     -14.514  40.259  80.165  1.00 24.78           N
ATOM    868  C   ARG   104      -8.044  43.011  78.368  1.00 22.15           C
ATOM    869  O   ARG   104      -7.842  41.976  77.722  1.00 22.69           O
ATOM    870  N   ILE   105      -7.113  43.562  79.132  1.00 21.37           N
ATOM    871  CA  ILE   105      -5.799  42.950  79.221  1.00 21.36           C
ATOM    872  CB  ILE   105      -4.685  43.845  78.615  1.00 21.45           C
ATOM    873  CG1 ILE   105      -4.622  45.208  79.317  1.00 21.21           C
ATOM    874  CD1 ILE   105      -3.372  46.006  78.973  1.00 20.99           C
ATOM    875  CG2 ILE   105      -4.901  44.025  77.098  1.00 22.71           C
ATOM    876  C   ILE   105      -5.508  42.545  80.651  1.00 21.31           C
ATOM    877  O   ILE   105      -6.029  43.114  81.590  1.00 21.58           O
ATOM    878  N   GLY   106      -4.696  41.517  80.814  1.00 21.48           N
ATOM    879  CA  GLY   106      -4.307  41.082  82.138  1.00 21.34           C
ATOM    880  C   GLY   106      -2.972  40.364  82.072  1.00 20.93           C
ATOM    881  O   GLY   106      -2.430  40.139  80.986  1.00 20.08           O
ATOM    882  N   ILE   107      -2.447  40.026  83.243  1.00 20.95           N
ATOM    883  CA  ILE   107      -1.160  39.319  83.378  1.00 20.93           C
ATOM    884  CB  ILE   107      -0.078  40.214  84.049  1.00 21.11           C
ATOM    885  CG1 ILE   107       0.325  41.388  83.152  1.00 20.55           C
ATOM    886  CD1 ILE   107       1.349  42.345  83.836  1.00 20.00           C
ATOM    887  CG2 ILE   107       1.203  39.438  84.401  1.00 20.89           C
ATOM    888  C   ILE   107      -1.370  38.055  84.222  1.00 21.98           C
ATOM    889  O   ILE   107      -1.968  38.122  85.302  1.00 21.96           O
ATOM    890  N   ILE   108      -0.906  36.905  83.738  1.00 23.06           N
ATOM    891  CA  ILE   108      -0.777  35.707  84.608  1.00 24.09           C
ATOM    892  CB  ILE   108      -1.797  34.550  84.282  1.00 25.43           C
ATOM    893  CG1 ILE   108      -3.226  34.916  84.748  1.00 27.07           C
ATOM    894  CD1 ILE   108      -4.015  35.716  83.788  1.00 27.73           C
ATOM    895  CG2 ILE   108      -1.415  33.269  85.006  1.00 23.92           C
ATOM    896  C   ILE   108       0.689  35.245  84.615  1.00 24.05           C
ATOM    897  O   ILE   108       1.273  34.891  83.595  1.00 24.50           O
ATOM    898  N   SER   109       1.303  35.319  85.788  1.00 24.00           N
ATOM    899  CA  SER   109       2.734  35.260  85.873  1.00 23.46           C
ATOM    900  CB  SER   109       3.332  36.695  85.913  1.00 23.91           C
ATOM    901  OG  SER   109       4.739  36.634  86.160  1.00 21.24           O
ATOM    902  C   SER   109       3.136  34.440  87.085  1.00 24.05           C
ATOM    903  O   SER   109       2.362  34.328  88.051  1.00 22.41           O
ATOM    904  N   THR   110       4.331  33.834  87.005  1.00 23.82           N
ATOM    905  CA  THR   110       4.900  33.138  88.158  1.00 24.02           C
ATOM    906  CB  THR   110       5.718  31.885  87.734  1.00 24.80           C
ATOM    907  OG1 THR   110       4.809  30.972  87.111  1.00 21.86           O
ATOM    908  CG2 THR   110       6.364  31.185  88.960  1.00 22.57           C
ATOM    909  C   THR   110       5.661  34.110  89.087  1.00 24.45           C
ATOM    910  O   THR   110       5.845  33.837  90.248  1.00 23.94           O
ATOM    911  N   LYS   111       6.066  35.266  88.559  1.00 24.80           N
ATOM    912  CA  LYS   111       6.752  36.269  89.351  1.00 24.75           C
ATOM    913  CB  LYS   111       7.350  37.371  88.435  1.00 24.57           C
ATOM    914  CG  LYS   111       7.970  38.551  89.191  1.00 26.03           C
ATOM    915  CD  LYS   111       8.796  39.506  88.308  1.00 25.47           C
ATOM    916  CE  LYS   111      10.151  38.911  87.993  1.00 27.08           C
ATOM    917  NZ  LYS   111      10.973  39.860  87.201  1.00 27.31           N
ATOM    918  C   LYS   111       5.720  36.811  90.357  1.00 24.52           C
ATOM    919  O   LYS   111       4.513  36.795  90.083  1.00 24.83           O
ATOM    920  N   TYR   112       6.184  37.252  91.525  1.00 24.03           N
ATOM    921  CA  TYR   112       5.295  37.800  92.532  1.00 23.93           C
ATOM    922  CB  TYR   112       6.074  38.171  93.792  1.00 24.91           C
ATOM    923  CG  TYR   112       6.854  36.992  94.369  1.00 27.15           C
ATOM    924  CD1 TYR   112       6.283  35.716  94.429  1.00 27.45           C
ATOM    925  CE1 TYR   112       7.013  34.611  94.923  1.00 31.08           C
ATOM    926  CZ  TYR   112       8.303  34.796  95.393  1.00 28.86           C
ATOM    927  OH  TYR   112       9.011  33.713  95.913  1.00 31.26           O
ATOM    928  CE2 TYR   112       8.893  36.058  95.356  1.00 28.90           C
ATOM    929  CD2 TYR   112       8.168  37.152  94.823  1.00 27.43           C
ATOM    930  C   TYR   112       4.610  39.032  91.989  1.00 23.41           C
ATOM    931  O   TYR   112       5.260  39.896  91.364  1.00 23.52           O
ATOM    932  N   ARG   113       3.305  39.103  92.232  1.00 21.97           N
ATOM    933  CA  ARG   113       2.489  40.236  91.833  1.00 21.75           C
ATOM    934  CB  ARG   113       1.031  40.019  92.239  1.00 21.73           C
ATOM    935  CG  ARG   113       0.186  41.140  91.722  1.00 23.08           C
ATOM    936  CD  ARG   113      -1.252  40.797  91.585  1.00 29.65           C
ATOM    937  NE  ARG   113      -1.761  40.257  92.820  1.00 30.40           N
ATOM    938  CZ  ARG   113      -2.146  41.000  93.831  1.00 33.13           C
ATOM    939  NH1 ARG   113      -2.106  42.325  93.727  1.00 34.65           N
ATOM    940  NH2 ARG   113      -2.572  40.409  94.936  1.00 35.49           N
ATOM    941  C   ARG   113       2.954  41.569  92.374  1.00 21.21           C
ATOM    942  O   ARG   113       2.925  42.564  91.658  1.00 21.65           O
ATOM    943  N   PHE   114       3.333  41.612  93.656  1.00 20.92           N
ATOM    944  CA  PHE   114       3.889  42.838  94.247  1.00 20.19           C
ATOM    945  CB  PHE   114       4.199  42.677  95.771  1.00 19.97           C
ATOM    946  CG  PHE   114       5.454  41.888  96.080  1.00 18.39           C
ATOM    947  CD1 PHE   114       6.715  42.526  96.088  1.00 19.63           C
ATOM    948  CE1 PHE   114       7.914  41.829  96.387  1.00 17.93           C
ATOM    949  CZ  PHE   114       7.839  40.450  96.701  1.00 20.29           C
ATOM    950  CE2 PHE   114       6.561  39.810  96.724  1.00 20.01           C
ATOM    951  CD2 PHE   114       5.385  40.531  96.404  1.00 18.78           C
ATOM    952  C   PHE   114       5.106  43.323  93.452  1.00 20.47           C
ATOM    953  O   PHE   114       5.327  44.516  93.314  1.00 20.52           O
ATOM    954  N   ARG   115       5.892  42.388  92.933  1.00 20.95           N
ATOM    955  CA  ARG   115       7.085  42.719  92.176  1.00 22.04           C
ATOM    956  CB  ARG   115       7.924  41.466  92.013  1.00 21.74           C
ATOM    957  CG  ARG   115       9.238  41.681  91.270  1.00 24.56           C
ATOM    958  CD  ARG   115      10.299  42.239  92.221  1.00 27.49           C
ATOM    959  NE  ARG   115      10.697  41.201  93.174  1.00 29.27           N
ATOM    960  CZ  ARG   115      11.068  41.414  94.437  1.00 29.39           C
ATOM    961  NH1 ARG   115      11.103  42.653  94.944  1.00 26.15           N
ATOM    962  NH2 ARG   115      11.415  40.371  95.193  1.00 26.91           N
ATOM    963  C   ARG   115       6.720  43.344  90.811  1.00 22.23           C
ATOM    964  O   ARG   115       7.290  44.373  90.398  1.00 21.97           O
ATOM    965  N   ILE   116       5.744  42.721  90.145  1.00 22.57           N
ATOM    966  CA  ILE   116       5.160  43.221  88.902  1.00 23.16           C
ATOM    967  CB  ILE   116       4.157  42.190  88.356  1.00 23.56           C
ATOM    968  CG1 ILE   116       4.920  40.914  87.940  1.00 21.53           C
ATOM    969  CD1 ILE   116       4.033  39.740  87.742  1.00 18.62           C
ATOM    970  CG2 ILE   116       3.257  42.759  87.229  1.00 24.81           C
ATOM    971  C   ILE   116       4.540  44.618  89.039  1.00 23.20           C
ATOM    972  O   ILE   116       4.736  45.471  88.178  1.00 23.95           O
ATOM    973  N   LEU   117       3.824  44.851  90.128  1.00 23.18           N
ATOM    974  CA  LEU   117       3.142  46.131  90.333  1.00 22.97           C
ATOM    975  CB  LEU   117       2.163  46.067  91.507  1.00 23.35           C
ATOM    976  CG  LEU   117       0.893  45.203  91.358  1.00 22.83           C
ATOM    977  CD1 LEU   117       0.263  45.068  92.731  1.00 23.77           C
ATOM    978  CD2 LEU   117      -0.134  45.791  90.389  1.00 25.25           C
ATOM    979  C   LEU   117       4.157  47.220  90.535  1.00 22.48           C
ATOM    980  O   LEU   117       4.011  48.312  90.031  1.00 22.68           O
ATOM    981  N   SER   118       5.225  46.896  91.239  1.00 22.82           N
ATOM    982  CA  SER   118       6.278  47.867  91.486  1.00 22.55           C
ATOM    983  CB  SER   118       7.256  47.318  92.508  1.00 22.73           C
ATOM    984  OG  SER   118       8.088  48.377  92.966  1.00 25.80           O
ATOM    985  C   SER   118       6.996  48.249  90.170  1.00 21.80           C
ATOM    986  O   SER   118       7.276  49.429  89.930  1.00 20.84           O
ATOM    987  N   PHE   119       7.255  47.248  89.322  1.00 20.76           N
ATOM    988  CA  PHE   119       7.778  47.477  87.980  1.00 20.24           C
ATOM    989  CB  PHE   119       8.059  46.173  87.223  1.00 18.77           C
ATOM    990  CG  PHE   119       8.569  46.403  85.826  1.00 19.44           C
ATOM    991  CD1 PHE   119       9.929  46.704  85.600  1.00 17.91           C
ATOM    992  CE1 PHE   119      10.385  46.994  84.313  1.00 18.19           C
ATOM    993  CZ  PHE   119       9.518  46.942  83.225  1.00 16.24           C
ATOM    994  CE2 PHE   119       8.161  46.658  83.439  1.00 18.27           C
ATOM    995  CD2 PHE   119       7.703  46.382  84.742  1.00 18.20           C
ATOM    996  C   PHE   119       6.840  48.380  87.183  1.00 20.65           C
ATOM    997  O   PHE   119       7.280  49.372  86.593  1.00 21.93           O
ATOM    998  N   LEU   120       5.556  48.053  87.202  1.00 20.45           N
ATOM    999  CA  LEU   120       4.536  48.767  86.441  1.00 20.84           C
ATOM   1000  CB  LEU   120       3.167  48.044  86.517  1.00 20.93           C
ATOM   1001  CG  LEU   120       3.052  46.558  86.041  1.00 19.24           C
ATOM   1002  CD1 LEU   120       1.658  45.978  86.237  1.00 18.53           C
ATOM   1003  CD2 LEU   120       3.431  46.440  84.584  1.00 20.96           C
ATOM   1004  C   LEU   120       4.380  50.189  86.866  1.00 21.73           C
ATOM   1005  O   LEU   120       4.173  51.072  86.033  1.00 21.80           O
ATOM   1006  N   ARG   121       4.476  50.431  88.166  1.00 22.60           N
ATOM   1007  CA  ARG   121       4.314  51.785  88.694  1.00 23.52           C
ATOM   1008  CB  ARG   121       4.536  51.804  90.209  1.00 23.94           C
ATOM   1009  CG  ARG   121       3.243  51.762  90.989  1.00 26.77           C
ATOM   1010  CD  ARG   121       3.460  52.148  92.462  1.00 32.77           C
ATOM   1011  NE  ARG   121       4.296  51.171  93.166  1.00 36.60           N
ATOM   1012  CZ  ARG   121       3.868  49.993  93.621  1.00 37.23           C
ATOM   1013  NH1 ARG   121       2.606  49.615  93.453  1.00 39.05           N
ATOM   1014  NH2 ARG   121       4.712  49.187  94.242  1.00 37.40           N
ATOM   1015  C   ARG   121       5.175  52.842  88.028  1.00 23.70           C
ATOM   1016  O   ARG   121       4.700  53.965  87.795  1.00 22.66           O
ATOM   1017  N   ASN   122       6.433  52.512  87.738  1.00 24.49           N
ATOM   1018  CA  ASN   122       7.322  53.455  87.040  1.00 25.95           C
ATOM   1019  CB  ASN   122       8.592  53.730  87.849  1.00 26.52           C
ATOM   1020  CG  ASN   122       9.381  52.471  88.149  1.00 27.72           C
ATOM   1021  OD1 ASN   122       8.830  51.376  88.204  1.00 27.80           O
ATOM   1022  ND2 ASN   122      10.678  52.627  88.355  1.00 28.40           N
ATOM   1023  C   ASN   122       7.650  53.134  85.563  1.00 26.81           C
ATOM   1024  O   ASN   122       8.660  53.617  85.024  1.00 25.03           O
ATOM   1025  N   HIS   123       6.782  52.336  84.928  1.00 28.90           N
ATOM   1026  CA  HIS   123       6.824  52.065  83.474  1.00 32.33           C
ATOM   1027  CB  HIS   123       7.437  50.688  83.175  1.00 32.18           C
ATOM   1028  CG  HIS   123       8.880  50.598  83.558  1.00 32.54           C
ATOM   1029  ND1 HIS   123       9.292  50.240  84.824  1.00 34.38           N
ATOM   1030  CE1 HIS   123      10.612  50.292  84.887  1.00 34.14           C
ATOM   1031  NE2 HIS   123      11.067  50.684  83.711  1.00 32.80           N
ATOM   1032  CD2 HIS   123      10.004  50.896  82.868  1.00 32.98           C
ATOM   1033  C   HIS   123       5.481  52.284  82.732  1.00 34.73           C
ATOM   1034  O   HIS   123       5.352  53.269  82.000  1.00 35.69           O
ATOM   1035  N   MET   124       4.488  51.397  82.910  1.00 37.36           N
ATOM   1036  CA  MET   124       3.182  51.538  82.200  1.00 40.60           C
ATOM   1037  CB  MET   124       2.354  50.232  82.186  1.00 40.22           C
ATOM   1038  CG  MET   124       3.145  49.006  82.256  1.00 42.29           C
ATOM   1039  SD  MET   124       3.035  47.774  80.747  1.00 48.28          SE
ATOM   1040  CE  MET   124       4.580  46.586  81.143  1.00 45.73           C
ATOM   1041  C   MET   124       2.350  52.657  82.824  1.00 40.03           C
ATOM   1042  O   MET   124       2.549  52.999  83.991  1.00 39.75           O
ATOM   1043  N   PRO   125       1.431  53.264  82.044  1.00 40.89           N
ATOM   1044  CA  PRO   125       0.446  54.102  82.734  1.00 40.98           C
ATOM   1045  CB  PRO   125      -0.462  54.605  81.603  1.00 41.37           C
ATOM   1046  CG  PRO   125       0.315  54.429  80.344  1.00 41.09           C
ATOM   1047  CD  PRO   125       1.246  53.269  80.576  1.00 40.96           C
ATOM   1048  C   PRO   125      -0.353  53.263  83.731  1.00 41.53           C
ATOM   1049  O   PRO   125      -0.658  52.088  83.461  1.00 41.29           O
ATOM   1050  N   ASP   126      -0.656  53.841  84.889  1.00 41.77           N
ATOM   1051  CA  ASP   126      -1.488  53.161  85.878  1.00 42.26           C
ATOM   1052  CB  ASP   126      -1.283  53.797  87.266  1.00 42.73           C
ATOM   1053  CG  ASP   126      -1.286  52.769  88.412  1.00 44.34           C
ATOM   1054  OD1 ASP   126      -1.670  51.593  88.183  1.00 45.63           O
ATOM   1055  OD2 ASP   126      -0.897  53.153  89.552  1.00 45.51           O
ATOM   1056  C   ASP   126      -2.927  53.356  85.389  1.00 41.58           C
ATOM   1057  O   ASP   126      -3.206  54.386  84.784  1.00 42.21           O
ATOM   1058  N   ASP   127      -3.827  52.389  85.556  1.00 40.52           N
ATOM   1059  CA  ASP   127      -3.526  50.998  85.880  1.00 39.96           C
ATOM   1060  CB  ASP   127      -4.189  50.550  87.197  1.00 40.94           C
ATOM   1061  CG  ASP   127      -5.660  50.984  87.315  1.00 41.90           C
ATOM   1062  OD1 ASP   127      -5.953  52.208  87.369  1.00 42.06           O
ATOM   1063  OD2 ASP   127      -6.518  50.079  87.382  1.00 43.64           O
ATOM   1064  C   ASP   127      -4.042  50.185  84.717  1.00 38.20           C
ATOM   1065  O   ASP   127      -5.256  50.109  84.494  1.00 37.67           O
ATOM   1066  N   TRP   128      -3.113  49.592  83.975  1.00 36.61           N
ATOM   1067  CA  TRP   128      -3.429  49.055  82.644  1.00 35.09           C
ATOM   1068  CB  TRP   128      -2.227  48.948  81.688  1.00 35.80           C
ATOM   1069  CG  TRP   128      -2.234  50.138  80.750  1.00 35.09           C
ATOM   1070  CD1 TRP   128      -3.104  51.208  80.783  1.00 35.72           C
ATOM   1071  NE1 TRP   128      -2.822  52.085  79.763  1.00 35.55           N
ATOM   1072  CE2 TRP   128      -1.742  51.607  79.063  1.00 35.42           C
ATOM   1073  CD2 TRP   128      -1.348  50.383  79.658  1.00 34.71           C
ATOM   1074  CE3 TRP   128      -0.265  49.688  79.118  1.00 33.51           C
ATOM   1075  CZ3 TRP   128       0.399  50.231  78.022  1.00 34.61           C
ATOM   1076  CH2 TRP   128      -0.003  51.446  77.455  1.00 35.73           C
ATOM   1077  CZ2 TRP   128      -1.074  52.152  77.957  1.00 36.45           C
ATOM   1078  C   TRP   128      -4.588  48.100  82.448  1.00 33.02           C
ATOM   1079  O   TRP   128      -5.180  48.096  81.379  1.00 32.97           O
ATOM   1080  N   PHE   129      -4.895  47.198  83.368  1.00 30.83           N
ATOM   1081  CA  PHE   129      -4.519  45.796  83.438  1.00 27.41           C
ATOM   1082  CB  PHE   129      -3.210  45.414  84.131  1.00 27.51           C
ATOM   1083  CG  PHE   129      -2.070  45.221  83.163  1.00 24.74           C
ATOM   1084  CD1 PHE   129      -2.191  44.352  82.086  1.00 22.45           C
ATOM   1085  CE1 PHE   129      -1.154  44.219  81.171  1.00 22.50           C
ATOM   1086  CZ  PHE   129       0.024  44.986  81.326  1.00 23.94           C
ATOM   1087  CE2 PHE   129       0.131  45.854  82.373  1.00 22.97           C
ATOM   1088  CD2 PHE   129      -0.908  45.982  83.279  1.00 22.98           C
ATOM   1089  C   PHE   129      -5.747  45.423  84.247  1.00 26.85           C
ATOM   1090  O   PHE   129      -5.857  45.755  85.438  1.00 26.52           O
ATOM   1091  N   ASP   130      -6.726  44.837  83.571  1.00 24.96           N
ATOM   1092  CA  ASP   130      -7.957  44.475  84.234  1.00 24.19           C
ATOM   1093  CB  ASP   130      -9.012  44.086  83.220  1.00 23.88           C
ATOM   1094  CG  ASP   130      -9.437  45.274  82.371  1.00 27.00           C
ATOM   1095  OD1 ASP   130     -10.486  45.869  82.696  1.00 29.29           O
ATOM   1096  OD2 ASP   130      -8.706  45.627  81.403  1.00 28.94           O
ATOM   1097  C   ASP   130      -7.741  43.441  85.330  1.00 22.92           C
ATOM   1098  O   ASP   130      -8.495  43.397  86.287  1.00 21.95           O
ATOM   1099  N   ILE   131      -6.677  42.649  85.206  1.00 22.22           N
ATOM   1100  CA  ILE   131      -6.307  41.674  86.234  1.00 21.82           C
ATOM   1101  CB  ILE   131      -7.161  40.373  86.146  1.00 21.76           C
ATOM   1102  CG1 ILE   131      -6.930  39.485  87.370  1.00 22.46           C
ATOM   1103  CD1 ILE   131      -8.071  38.538  87.621  1.00 24.67           C
ATOM   1104  CG2 ILE   131      -6.894  39.594  84.846  1.00 19.84           C
ATOM   1105  C   ILE   131      -4.825  41.292  86.164  1.00 21.81           C
ATOM   1106  O   ILE   131      -4.235  41.209  85.074  1.00 22.19           O
ATOM   1107  N   ILE   132      -4.244  41.065  87.334  1.00 20.67           N
ATOM   1108  CA  ILE   132      -2.877  40.621  87.448  1.00 21.67           C
ATOM   1109  CB  ILE   132      -1.857  41.769  87.836  1.00 21.11           C
ATOM   1110  CG1 ILE   132      -1.840  42.854  86.755  1.00 22.05           C
ATOM   1111  CD1 ILE   132      -1.142  44.103  87.131  1.00 20.96           C
ATOM   1112  CG2 ILE   132      -0.429  41.186  87.997  1.00 20.87           C
ATOM   1113  C   ILE   132      -2.934  39.561  88.520  1.00 21.42           C
ATOM   1114  O   ILE   132      -3.402  39.825  89.625  1.00 21.70           O
ATOM   1115  N   ILE   133      -2.490  38.372  88.137  1.00 21.45           N
ATOM   1116  CA  ILE   133      -2.309  37.194  88.992  1.00 21.23           C
ATOM   1117  CB  ILE   133      -3.092  35.998  88.411  1.00 20.64           C
ATOM   1118  CG1 ILE   133      -4.604  36.370  88.251  1.00 20.13           C
ATOM   1119  CD1 ILE   133      -5.347  36.639  89.520  1.00 22.28           C
ATOM   1120  CG2 ILE   133      -2.926  34.728  89.265  1.00 20.74           C
ATOM   1121  C   ILE   133      -0.808  36.909  88.984  1.00 21.77           C
ATOM   1122  O   ILE   133      -0.211  36.748  87.891  1.00 22.24           O
ATOM   1123  N   GLY   134      -0.192  36.907  90.173  1.00 21.68           N
ATOM   1124  CA  GLY   134       1.255  36.614  90.338  1.00 20.93           C
ATOM   1125  C   GLY   134       1.469  35.278  91.048  1.00 21.26           C
ATOM   1126  O   GLY   134       0.500  34.563  91.361  1.00 19.97           O
ATOM   1127  N   GLY   135       2.737  34.925  91.268  1.00 21.56           N
ATOM   1128  CA  GLY   135       3.112  33.682  91.980  1.00 22.36           C
ATOM   1129  C   GLY   135       2.520  33.486  93.377  1.00 23.17           C
ATOM   1130  O   GLY   135       2.158  32.354  93.770  1.00 23.27           O
ATOM   1131  N   GLU   136       2.383  34.563  94.140  1.00 22.75           N
ATOM   1132  CA  GLU   136       1.816  34.428  95.487  1.00 23.36           C
ATOM   1133  CB  GLU   136       2.345  35.554  96.403  1.00 23.73           C
ATOM   1134  CG  GLU   136       1.681  36.950  96.250  1.00 22.57           C
ATOM   1135  CD  GLU   136       2.182  37.801  95.055  1.00 25.96           C
ATOM   1136  OE1 GLU   136       2.283  37.277  93.905  1.00 23.49           O
ATOM   1137  OE2 GLU   136       2.415  39.034  95.256  1.00 24.73           O
ATOM   1138  C   GLU   136       0.247  34.280  95.490  1.00 23.83           C
ATOM   1139  O   GLU   136      -0.369  33.896  96.497  1.00 23.40           O
ATOM   1140  N   ASP   137      -0.387  34.529  94.351  1.00 24.09           N
ATOM   1141  CA  ASP   137      -1.859  34.442  94.272  1.00 25.55           C
ATOM   1142  CB  ASP   137      -2.367  35.311  93.131  1.00 25.10           C
ATOM   1143  CG  ASP   137      -2.097  36.779  93.352  1.00 25.54           C
ATOM   1144  OD1 ASP   137      -2.202  37.277  94.485  1.00 28.50           O
ATOM   1145  OD2 ASP   137      -1.772  37.440  92.373  1.00 26.95           O
ATOM   1146  C   ASP   137      -2.416  33.017  94.111  1.00 25.84           C
ATOM   1147  O   ASP   137      -3.638  32.812  94.093  1.00 26.18           O
ATOM   1148  N   VAL   138      -1.521  32.044  93.978  1.00 26.55           N
ATOM   1149  CA  VAL   138      -1.889  30.650  93.613  1.00 26.36           C
ATOM   1150  CB  VAL   138      -1.768  30.341  92.054  1.00 26.04           C
ATOM   1151  CG1 VAL   138      -2.696  31.284  91.225  1.00 26.27           C
ATOM   1152  CG2 VAL   138      -0.311  30.428  91.540  1.00 25.06           C
ATOM   1153  C   VAL   138      -1.035  29.671  94.398  1.00 26.57           C
ATOM   1154  O   VAL   138       0.097  29.981  94.766  1.00 25.71           O
ATOM   1155  N   THR   139      -1.596  28.497  94.651  1.00 27.30           N
ATOM   1156  CA  THR   139      -0.888  27.445  95.356  1.00 28.33           C
ATOM   1157  CB  THR   139      -1.882  26.536  96.095  1.00 28.71           C
ATOM   1158  OG1 THR   139      -2.459  27.267  97.177  1.00 26.46           O
ATOM   1159  CG2 THR   139      -1.208  25.266  96.628  1.00 30.40           C
ATOM   1160  C   THR   139      -0.005  26.648  94.386  1.00 29.17           C
ATOM   1161  O   THR   139       1.149  26.353  94.701  1.00 29.07           O
ATOM   1162  N   HIS   140      -0.571  26.318  93.219  1.00 29.49           N
ATOM   1163  CA  HIS   140       0.113  25.569  92.172  1.00 29.83           C
ATOM   1164  CB  HIS   140      -0.736  24.403  91.704  1.00 30.06           C
ATOM   1165  CG  HIS   140      -0.980  23.395  92.770  1.00 32.33           C
ATOM   1166  ND1 HIS   140      -2.093  23.429  93.583  1.00 35.12           N
ATOM   1167  CE1 HIS   140      -2.036  22.425  94.439  1.00 36.33           C
ATOM   1168  NE2 HIS   140      -0.925  21.748  94.213  1.00 37.23           N
ATOM   1169  CD2 HIS   140      -0.244  22.340  93.177  1.00 34.03           C
ATOM   1170  C   HIS   140       0.384  26.459  90.995  1.00 29.35           C
ATOM   1171  O   HIS   140      -0.478  27.252  90.580  1.00 28.72           O
ATOM   1172  N   HIS   141       1.574  26.307  90.439  1.00 27.98           N
ATOM   1173  CA  HIS   141       2.080  27.301  89.512  1.00 28.07           C
ATOM   1174  CB  HIS   141       3.463  27.750  90.003  1.00 28.04           C
ATOM   1175  CG  HIS   141       3.393  28.496  91.311  1.00 27.71           C
ATOM   1176  ND1 HIS   141       3.534  27.875  92.534  1.00 25.16           N
ATOM   1177  CE1 HIS   141       3.373  28.759  93.499  1.00 24.61           C
ATOM   1178  NE2 HIS   141       3.107  29.934  92.947  1.00 27.11           N
ATOM   1179  CD2 HIS   141       3.111  29.796  91.580  1.00 27.35           C
ATOM   1180  C   HIS   141       2.111  26.777  88.079  1.00 27.50           C
ATOM   1181  O   HIS   141       2.090  25.571  87.879  1.00 26.78           O
ATOM   1182  N   LYS   142       2.171  27.681  87.093  1.00 27.81           N
ATOM   1183  CA  LYS   142       2.224  27.291  85.662  1.00 28.04           C
ATOM   1184  CB  LYS   142       2.551  28.498  84.772  1.00 27.57           C
ATOM   1185  CG  LYS   142       1.552  29.656  84.827  1.00 28.67           C
ATOM   1186  CD  LYS   142       1.857  30.722  83.749  1.00 28.89           C
ATOM   1187  CE  LYS   142       2.936  31.661  84.217  1.00 28.95           C
ATOM   1188  NZ  LYS   142       3.314  32.608  83.107  1.00 28.98           N
ATOM   1189  C   LYS   142       3.255  26.198  85.486  1.00 27.87           C
ATOM   1190  O   LYS   142       4.327  26.282  86.090  1.00 29.23           O
ATOM   1191  N   PRO   143       2.977  25.166  84.663  1.00 28.29           N
ATOM   1192  CA  PRO   143       1.850  24.958  83.744  1.00 28.58           C
ATOM   1193  CB  PRO   143       2.368  23.876  82.765  1.00 28.89           C
ATOM   1194  CG  PRO   143       3.359  23.086  83.546  1.00 28.98           C
ATOM   1195  CD  PRO   143       3.934  24.034  84.621  1.00 28.62           C
ATOM   1196  C   PRO   143       0.482  24.611  84.362  1.00 28.32           C
ATOM   1197  O   PRO   143      -0.478  24.469  83.636  1.00 27.84           O
ATOM   1198  N   ASP   144       0.368  24.539  85.688  1.00 28.21           N
ATOM   1199  CA  ASP   144      -0.954  24.362  86.294  1.00 28.18           C
ATOM   1200  CB  ASP   144      -0.841  24.248  87.817  1.00 27.62           C
ATOM   1201  CG  ASP   144      -2.147  23.834  88.462  1.00 28.37           C
ATOM   1202  OD1 ASP   144      -2.221  22.711  88.967  1.00 26.19           O
ATOM   1203  OD2 ASP   144      -3.102  24.628  88.476  1.00 27.88           O
ATOM   1204  C   ASP   144      -1.830  25.560  85.908  1.00 27.55           C
ATOM   1205  O   ASP   144      -1.396  26.722  86.028  1.00 27.66           O
ATOM   1206  N   PRO   145      -3.062  25.287  85.416  1.00 28.58           N
ATOM   1207  CA  PRO   145      -3.950  26.371  84.963  1.00 27.87           C
ATOM   1208  CB  PRO   145      -4.988  25.617  84.115  1.00 28.13           C
ATOM   1209  CG  PRO   145      -5.068  24.268  84.760  1.00 28.65           C
ATOM   1210  CD  PRO   145      -3.678  23.948  85.218  1.00 27.05           C
ATOM   1211  C   PRO   145      -4.632  27.194  86.078  1.00 28.17           C
ATOM   1212  O   PRO   145      -5.499  28.029  85.778  1.00 28.46           O
ATOM   1213  N   GLU   146      -4.260  26.975  87.338  1.00 28.42           N
ATOM   1214  CA  GLU   146      -4.968  27.605  88.491  1.00 28.55           C
ATOM   1215  CB  GLU   146      -4.235  27.313  89.807  1.00 28.72           C
ATOM   1216  CG  GLU   146      -5.006  27.727  91.073  1.00 29.01           C
ATOM   1217  CD  GLU   146      -4.199  27.550  92.349  1.00 28.29           C
ATOM   1218  OE1 GLU   146      -3.457  26.547  92.459  1.00 29.73           O
ATOM   1219  OE2 GLU   146      -4.301  28.412  93.245  1.00 27.05           O
ATOM   1220  C   GLU   146      -5.100  29.119  88.339  1.00 28.92           C
ATOM   1221  O   GLU   146      -6.187  29.681  88.500  1.00 28.72           O
ATOM   1222  N   GLY   147      -3.982  29.778  88.050  1.00 29.01           N
ATOM   1223  CA  GLY   147      -3.970  31.229  87.917  1.00 29.73           C
ATOM   1224  C   GLY   147      -4.714  31.721  86.699  1.00 30.25           C
ATOM   1225  O   GLY   147      -5.460  32.706  86.778  1.00 30.55           O
ATOM   1226  N   LEU   148      -4.516  31.031  85.574  1.00 30.39           N
ATOM   1227  CA  LEU   148      -5.191  31.387  84.335  1.00 30.29           C
ATOM   1228  CB  LEU   148      -4.668  30.557  83.142  1.00 29.91           C
ATOM   1229  CG  LEU   148      -5.162  30.971  81.723  1.00 31.16           C
ATOM   1230  CD1 LEU   148      -5.102  32.485  81.462  1.00 30.38           C
ATOM   1231  CD2 LEU   148      -4.345  30.284  80.653  1.00 31.39           C
ATOM   1232  C   LEU   148      -6.712  31.250  84.509  1.00 29.93           C
ATOM   1233  O   LEU   148      -7.459  32.187  84.189  1.00 29.74           O
ATOM   1234  N   LEU   149      -7.156  30.093  85.017  1.00 29.50           N
ATOM   1235  CA  LEU   149      -8.573  29.865  85.290  1.00 29.44           C
ATOM   1236  CB  LEU   149      -8.819  28.417  85.759  1.00 29.53           C
ATOM   1237  CG  LEU   149      -8.523  27.271  84.787  1.00 26.91           C
ATOM   1238  CD1 LEU   149      -8.739  25.945  85.501  1.00 25.33           C
ATOM   1239  CD2 LEU   149      -9.358  27.402  83.497  1.00 24.96           C
ATOM   1240  C   LEU   149      -9.113  30.853  86.320  1.00 30.01           C
ATOM   1241  O   LEU   149     -10.254  31.298  86.206  1.00 30.21           O
ATOM   1242  N   LEU   150      -8.294  31.198  87.315  1.00 30.89           N
ATOM   1243  CA  LEU   150      -8.667  32.200  88.308  1.00 31.50           C
ATOM   1244  CB  LEU   150      -7.596  32.361  89.407  1.00 31.23           C
ATOM   1245  CG  LEU   150      -7.868  33.398  90.522  1.00 31.44           C
ATOM   1246  CD1 LEU   150      -9.066  33.029  91.413  1.00 30.04           C
ATOM   1247  CD2 LEU   150      -6.637  33.653  91.380  1.00 31.62           C
ATOM   1248  C   LEU   150      -8.980  33.552  87.647  1.00 32.69           C
ATOM   1249  O   LEU   150     -10.038  34.150  87.928  1.00 33.35           O
ATOM   1250  N   ALA   151      -8.077  34.021  86.780  1.00 32.59           N
ATOM   1251  CA  ALA   151      -8.261  35.279  86.067  1.00 33.62           C
ATOM   1252  CB  ALA   151      -7.054  35.584  85.235  1.00 33.37           C
ATOM   1253  C   ALA   151      -9.529  35.337  85.205  1.00 34.37           C
ATOM   1254  O   ALA   151     -10.314  36.307  85.307  1.00 34.50           O
ATOM   1255  N   ILE   152      -9.718  34.305  84.366  1.00 35.25           N
ATOM   1256  CA  ILE   152     -10.926  34.126  83.543  1.00 35.62           C
ATOM   1257  CB  ILE   152     -10.934  32.763  82.776  1.00 35.62           C
ATOM   1258  CG1 ILE   152      -9.708  32.606  81.876  1.00 34.67           C
ATOM   1259  CD1 ILE   152      -9.417  31.151  81.476  1.00 34.42           C
ATOM   1260  CG2 ILE   152     -12.206  32.625  81.915  1.00 36.65           C
ATOM   1261  C   ILE   152     -12.189  34.206  84.411  1.00 36.96           C
ATOM   1262  O   ILE   152     -13.165  34.867  84.043  1.00 36.65           O
ATOM   1263  N   ASP   153     -12.150  33.527  85.557  1.00 38.06           N
ATOM   1264  CA  ASP   153     -13.238  33.564  86.541  1.00 38.91           C
ATOM   1265  CB  ASP   153     -12.964  32.594  87.693  1.00 38.78           C
ATOM   1266  CG  ASP   153     -14.020  32.677  88.765  1.00 41.18           C
ATOM   1267  OD1 ASP   153     -15.192  32.354  88.469  1.00 38.13           O
ATOM   1268  OD2 ASP   153     -13.685  33.102  89.896  1.00 46.00           O
ATOM   1269  C   ASP   153     -13.527  34.964  87.090  1.00 39.10           C
ATOM   1270  O   ASP   153     -14.683  35.418  87.096  1.00 39.05           O
ATOM   1271  N   ARG   154     -12.478  35.640  87.550  1.00 39.66           N
ATOM   1272  CA  ARG   154     -12.604  36.995  88.098  1.00 40.18           C
ATOM   1273  CB  ARG   154     -11.289  37.457  88.738  1.00 40.91           C
ATOM   1274  CG  ARG   154     -10.921  36.683  89.989  1.00 42.64           C
ATOM   1275  CD  ARG   154     -10.260  37.574  91.020  1.00 45.63           C
ATOM   1276  NE  ARG   154      -9.328  36.801  91.833  1.00 47.12           N
ATOM   1277  CZ  ARG   154      -8.246  37.312  92.406  1.00 48.26           C
ATOM   1278  NH1 ARG   154      -7.970  38.611  92.256  1.00 47.61           N
ATOM   1279  NH2 ARG   154      -7.434  36.525  93.112  1.00 47.30           N
ATOM   1280  C   ARG   154     -13.095  38.035  87.083  1.00 39.58           C
ATOM   1281  O   ARG   154     -13.827  38.975  87.447  1.00 40.22           O
ATOM   1282  N   LEU   155     -12.690  37.865  85.826  1.00 38.30           N
ATOM   1283  CA  LEU   155     -13.117  38.749  84.739  1.00 37.14           C
ATOM   1284  CB  LEU   155     -12.063  38.749  83.609  1.00 36.73           C
ATOM   1285  CG  LEU   155     -10.662  39.400  83.769  1.00 34.97           C
ATOM   1286  CD1 LEU   155      -9.880  39.218  82.484  1.00 36.15           C
ATOM   1287  CD2 LEU   155     -10.715  40.861  84.079  1.00 34.72           C
ATOM   1288  C   LEU   155     -14.549  38.454  84.183  1.00 37.07           C
ATOM   1289  O   LEU   155     -15.064  39.218  83.354  1.00 36.32           O
ATOM   1290  N   LYS   156     -15.181  37.376  84.671  1.00 36.92           N
ATOM   1291  CA  LYS   156     -16.451  36.848  84.132  1.00 37.01           C
ATOM   1292  CB  LYS   156     -17.680  37.720  84.475  1.00 37.18           C
ATOM   1293  CG  LYS   156     -17.712  38.389  85.856  1.00 38.58           C
ATOM   1294  CD  LYS   156     -17.848  37.411  87.018  1.00 39.61           C
ATOM   1295  CE  LYS   156     -17.923  38.158  88.346  1.00 39.57           C
ATOM   1296  NZ  LYS   156     -19.301  38.673  88.683  1.00 40.82           N
ATOM   1297  C   LYS   156     -16.327  36.676  82.618  1.00 37.01           C
ATOM   1298  O   LYS   156     -17.227  37.042  81.846  1.00 36.54           O
ATOM   1299  N   ALA   157     -15.191  36.124  82.202  1.00 36.76           N
ATOM   1300  CA  ALA   157     -14.923  35.911  80.797  1.00 37.12           C
ATOM   1301  CB  ALA   157     -13.416  36.198  80.460  1.00 36.14           C
ATOM   1302  C   ALA   157     -15.338  34.509  80.356  1.00 37.35           C
ATOM   1303  O   ALA   157     -15.522  33.600  81.181  1.00 38.21           O
ATOM   1304  N   CYS   158     -15.552  34.391  79.050  1.00 37.47           N
ATOM   1305  CA  CYS   158     -15.746  33.106  78.417  0.50 37.00           C
ATOM   1307  CB  CYS   158     -16.872  33.168  77.395  0.50 37.04           C
ATOM   1309  SG  CYS   158     -18.511  32.998  78.148  0.50 36.19           S
ATOM   1311  C   CYS   158     -14.429  32.667  77.787  1.00 37.08           C
ATOM   1312  O   CYS   158     -13.785  33.425  77.050  1.00 37.37           O
ATOM   1313  N   PRO   159     -13.986  31.421  78.103  1.00 36.60           N
ATOM   1314  CA  PRO   159     -12.637  31.046  77.632  1.00 35.62           C
ATOM   1315  CB  PRO   159     -12.479  29.599  78.104  1.00 35.48           C
ATOM   1316  CG  PRO   159     -13.877  29.111  78.347  1.00 36.57           C
ATOM   1317  CD  PRO   159     -14.643  30.306  78.813  1.00 36.59           C
ATOM   1318  C   PRO   159     -12.480  31.161  76.108  1.00 35.34           C
ATOM   1319  O   PRO   159     -11.385  31.435  75.621  1.00 34.76           O
ATOM   1320  N   GLU   160     -13.581  31.008  75.371  1.00 34.46           N
ATOM   1321  CA  GLU   160     -13.572  31.187  73.918  1.00 34.88           C
ATOM   1322  CB  GLU   160     -14.945  30.864  73.301  1.00 35.84           C
ATOM   1323  CG  GLU   160     -15.293  29.376  73.320  1.00 39.68           C
ATOM   1324  CD  GLU   160     -15.699  28.846  74.709  1.00 43.90           C
ATOM   1325  OE1 GLU   160     -16.231  29.628  75.539  1.00 42.25           O
ATOM   1326  OE2 GLU   160     -15.485  27.629  74.959  1.00 47.49           O
ATOM   1327  C   GLU   160     -13.089  32.572  73.473  1.00 33.86           C
ATOM   1328  O   GLU   160     -12.526  32.703  72.382  1.00 34.28           O
ATOM   1329  N   GLU   161     -13.253  33.581  74.319  1.00 32.56           N
ATOM   1330  CA  GLU   161     -12.852  34.943  73.950  1.00 32.97           C
ATOM   1331  CB  GLU   161     -13.931  35.966  74.329  1.00 33.11           C
ATOM   1332  CG  GLU   161     -14.101  36.232  75.807  1.00 34.27           C
ATOM   1333  CD  GLU   161     -15.469  36.815  76.099  1.00 36.91           C
ATOM   1334  OE1 GLU   161     -16.134  37.214  75.109  1.00 37.88           O
ATOM   1335  OE2 GLU   161     -15.880  36.864  77.293  1.00 35.47           O
ATOM   1336  C   GLU   161     -11.490  35.365  74.503  1.00 32.61           C
ATOM   1337  O   GLU   161     -11.116  36.542  74.411  1.00 32.64           O
ATOM   1338  N   VAL   162     -10.762  34.387  75.044  1.00 31.89           N
ATOM   1339  CA  VAL   162      -9.492  34.613  75.742  1.00 31.91           C
ATOM   1340  CB  VAL   162      -9.493  33.968  77.159  1.00 32.49           C
ATOM   1341  CG1 VAL   162      -8.100  34.070  77.824  1.00 30.64           C
ATOM   1342  CG2 VAL   162     -10.614  34.582  78.046  1.00 30.78           C
ATOM   1343  C   VAL   162      -8.309  34.091  74.928  1.00 31.63           C
ATOM   1344  O   VAL   162      -8.291  32.936  74.492  1.00 30.72           O
ATOM   1345  N   LEU   163      -7.344  34.977  74.708  1.00 31.17           N
ATOM   1346  CA  LEU   163      -6.061  34.599  74.139  1.00 30.89           C
ATOM   1347  CB  LEU   163      -5.693  35.510  72.979  1.00 30.52           C
ATOM   1348  CG  LEU   163      -4.485  35.088  72.144  1.00 30.76           C
ATOM   1349  CD1 LEU   163      -4.643  33.648  71.634  1.00 29.87           C
ATOM   1350  CD2 LEU   163      -4.230  36.063  70.980  1.00 30.98           C
ATOM   1351  C   LEU   163      -4.992  34.696  75.218  1.00 30.75           C
ATOM   1352  O   LEU   163      -4.896  35.708  75.892  1.00 30.06           O
ATOM   1353  N   TYR   164      -4.220  33.626  75.400  1.00 30.91           N
ATOM   1354  CA  TYR   164      -3.047  33.689  76.276  1.00 31.55           C
ATOM   1355  CB  TYR   164      -2.973  32.470  77.203  1.00 31.30           C
ATOM   1356  CG  TYR   164      -1.902  32.618  78.276  1.00 33.40           C
ATOM   1357  CD1 TYR   164      -1.848  33.781  79.067  1.00 31.47           C
ATOM   1358  CE1 TYR   164      -0.887  33.944  80.053  1.00 31.32           C
ATOM   1359  CZ  TYR   164       0.062  32.967  80.262  1.00 33.71           C
ATOM   1360  OH  TYR   164       0.992  33.188  81.240  1.00 32.32           O
ATOM   1361  CE2 TYR   164       0.062  31.782  79.482  1.00 33.92           C
ATOM   1362  CD2 TYR   164      -0.937  31.621  78.489  1.00 31.66           C
ATOM   1363  C   TYR   164      -1.755  33.813  75.451  1.00 31.34           C
ATOM   1364  O   TYR   164      -1.534  33.038  74.515  1.00 32.53           O
ATOM   1365  N   ILE   165      -0.889  34.758  75.810  1.00 30.69           N
ATOM   1366  CA  ILE   165       0.335  35.049  75.040  1.00 29.49           C
ATOM   1367  CB  ILE   165       0.318  36.514  74.448  1.00 29.51           C
ATOM   1368  CG1 ILE   165      -0.932  36.778  73.604  1.00 30.79           C
ATOM   1369  CD1 ILE   165      -2.039  37.483  74.342  1.00 27.44           C
ATOM   1370  CG2 ILE   165       1.575  36.794  73.636  1.00 31.57           C
ATOM   1371  C   ILE   165       1.578  34.886  75.917  1.00 29.05           C
ATOM   1372  O   ILE   165       1.688  35.541  76.944  1.00 28.44           O
ATOM   1373  N   GLY   166       2.518  34.023  75.520  1.00 28.54           N
ATOM   1374  CA  GLY   166       3.679  33.738  76.376  1.00 27.39           C
ATOM   1375  C   GLY   166       4.878  33.445  75.510  1.00 28.08           C
ATOM   1376  O   GLY   166       4.733  33.328  74.274  1.00 26.75           O
ATOM   1377  N   ASP   167       6.054  33.333  76.146  1.00 27.57           N
ATOM   1378  CA  ASP   167       7.293  33.064  75.426  1.00 27.78           C
ATOM   1379  CB  ASP   167       8.381  34.005  75.922  1.00 27.52           C
ATOM   1380  CG  ASP   167       8.800  33.669  77.324  1.00 28.93           C
ATOM   1381  OD1 ASP   167       7.990  33.939  78.215  1.00 30.91           O
ATOM   1382  OD2 ASP   167       9.906  33.108  77.533  1.00 31.75           O
ATOM   1383  C   ASP   167       7.845  31.632  75.580  1.00 27.57           C
ATOM   1384  O   ASP   167       8.887  31.301  74.972  1.00 27.83           O
ATOM   1385  N   SER   168       7.202  30.825  76.429  1.00 27.47           N
ATOM   1386  CA  SER   168       7.723  29.516  76.835  1.00 26.64           C
ATOM   1387  CB  SER   168       8.025  29.498  78.332  1.00 26.94           C
ATOM   1388  OG  SER   168       6.799  29.549  79.034  1.00 29.70           O
ATOM   1389  C   SER   168       6.726  28.410  76.620  1.00 26.30           C
ATOM   1390  O   SER   168       5.504  28.656  76.474  1.00 26.45           O
ATOM   1391  N   THR   169       7.244  27.180  76.644  1.00 26.12           N
ATOM   1392  CA  THR   169       6.397  25.999  76.621  1.00 26.28           C
ATOM   1393  CB  THR   169       7.173  24.733  76.318  1.00 26.36           C
ATOM   1394  OG1 THR   169       8.277  24.663  77.212  1.00 26.70           O
ATOM   1395  CG2 THR   169       7.683  24.770  74.879  1.00 27.73           C
ATOM   1396  C   THR   169       5.599  25.815  77.893  1.00 25.69           C
ATOM   1397  O   THR   169       4.515  25.237  77.832  1.00 24.92           O
ATOM   1398  N   VAL   170       6.111  26.329  79.025  1.00 26.07           N
ATOM   1399  CA  VAL   170       5.317  26.449  80.275  1.00 25.83           C
ATOM   1400  CB  VAL   170       6.131  27.138  81.409  1.00 25.84           C
ATOM   1401  CG1 VAL   170       5.222  27.558  82.582  1.00 26.91           C
ATOM   1402  CG2 VAL   170       7.246  26.221  81.886  1.00 26.04           C
ATOM   1403  C   VAL   170       4.024  27.208  80.008  1.00 25.47           C
ATOM   1404  O   VAL   170       2.911  26.778  80.406  1.00 25.40           O
ATOM   1405  N   ASP   171       4.162  28.332  79.312  1.00 26.32           N
ATOM   1406  CA  ASP   171       2.985  29.153  78.990  1.00 26.34           C
ATOM   1407  CB  ASP   171       3.435  30.463  78.358  1.00 27.70           C
ATOM   1408  CG  ASP   171       4.084  31.399  79.350  1.00 27.98           C
ATOM   1409  OD1 ASP   171       3.752  31.363  80.551  1.00 28.13           O
ATOM   1410  OD2 ASP   171       4.947  32.188  78.932  1.00 32.79           O
ATOM   1411  C   ASP   171       2.065  28.413  78.038  1.00 26.85           C
ATOM   1412  O   ASP   171       0.828  28.439  78.209  1.00 26.61           O
ATOM   1413  N   ALA   172       2.649  27.764  77.024  1.00 25.61           N
ATOM   1414  CA  ALA   172       1.865  27.000  76.055  1.00 27.11           C
ATOM   1415  CB  ALA   172       2.741  26.409  74.899  1.00 26.48           C
ATOM   1416  C   ALA   172       1.104  25.888  76.751  1.00 27.31           C
ATOM   1417  O   ALA   172      -0.092  25.728  76.502  1.00 26.13           O
ATOM   1418  N   GLY   173       1.804  25.125  77.599  1.00 27.21           N
ATOM   1419  CA  GLY   173       1.167  24.118  78.457  1.00 28.14           C
ATOM   1420  C   GLY   173       0.059  24.691  79.333  1.00 28.11           C
ATOM   1421  O   GLY   173      -0.985  24.062  79.505  1.00 28.46           O
ATOM   1422  N   THR   174       0.263  25.898  79.858  1.00 29.04           N
ATOM   1423  CA  THR   174      -0.746  26.532  80.739  1.00 28.63           C
ATOM   1424  CB  THR   174      -0.239  27.845  81.422  1.00 29.14           C
ATOM   1425  OG1 THR   174       1.062  27.635  82.011  1.00 28.42           O
ATOM   1426  CG2 THR   174      -1.201  28.270  82.494  1.00 28.38           C
ATOM   1427  C   THR   174      -2.017  26.816  79.962  1.00 28.93           C
ATOM   1428  O   THR   174      -3.104  26.500  80.426  1.00 28.93           O
ATOM   1429  N   ALA   175      -1.891  27.400  78.777  1.00 29.27           N
ATOM   1430  CA  ALA   175      -3.101  27.700  77.976  1.00 30.09           C
ATOM   1431  CB  ALA   175      -2.757  28.491  76.732  1.00 29.49           C
ATOM   1432  C   ALA   175      -3.856  26.427  77.621  1.00 30.13           C
ATOM   1433  O   ALA   175      -5.083  26.372  77.793  1.00 31.05           O
ATOM   1434  N   ALA   176      -3.130  25.392  77.172  1.00 29.92           N
ATOM   1435  CA  ALA   176      -3.758  24.090  76.823  1.00 30.22           C
ATOM   1436  CB  ALA   176      -2.712  23.076  76.314  1.00 29.67           C
ATOM   1437  C   ALA   176      -4.493  23.521  78.016  1.00 30.43           C
ATOM   1438  O   ALA   176      -5.688  23.205  77.949  1.00 31.30           O
ATOM   1439  N   ALA   177      -3.789  23.413  79.136  1.00 30.95           N
ATOM   1440  CA  ALA   177      -4.426  22.959  80.380  1.00 30.86           C
ATOM   1441  CB  ALA   177      -3.414  22.929  81.542  1.00 29.64           C
ATOM   1442  C   ALA   177      -5.706  23.754  80.734  1.00 30.96           C
ATOM   1443  O   ALA   177      -6.680  23.173  81.213  1.00 30.26           O
ATOM   1444  N   ALA   178      -5.704  25.069  80.481  1.00 31.93           N
ATOM   1445  CA  ALA   178      -6.880  25.919  80.731  1.00 32.07           C
ATOM   1446  CB  ALA   178      -6.452  27.382  80.979  1.00 32.87           C
ATOM   1447  C   ALA   178      -7.969  25.844  79.648  1.00 32.72           C
ATOM   1448  O   ALA   178      -9.077  26.302  79.867  1.00 32.75           O
ATOM   1449  N   GLY   179      -7.658  25.254  78.492  1.00 33.13           N
ATOM   1450  CA  GLY   179      -8.605  25.194  77.382  1.00 32.75           C
ATOM   1451  C   GLY   179      -8.815  26.571  76.764  1.00 32.66           C
ATOM   1452  O   GLY   179      -9.944  26.923  76.399  1.00 32.34           O
ATOM   1453  N   VAL   180      -7.730  27.353  76.664  1.00 31.61           N
ATOM   1454  CA  VAL   180      -7.770  28.641  75.970  1.00 30.94           C
ATOM   1455  CB  VAL   180      -7.629  29.867  76.972  1.00 31.08           C
ATOM   1456  CG1 VAL   180      -8.695  29.789  78.112  1.00 29.39           C
ATOM   1457  CG2 VAL   180      -6.241  29.942  77.538  1.00 29.49           C
ATOM   1458  C   VAL   180      -6.735  28.739  74.816  1.00 31.18           C
ATOM   1459  O   VAL   180      -5.669  28.123  74.866  1.00 30.89           O
ATOM   1460  N   SER   181      -7.039  29.545  73.803  1.00 30.60           N
ATOM   1461  CA  SER   181      -6.119  29.762  72.685  1.00 30.70           C
ATOM   1462  CB  SER   181      -6.775  30.642  71.613  1.00 30.53           C
ATOM   1463  OG  SER   181      -7.894  29.988  70.999  1.00 29.90           O
ATOM   1464  C   SER   181      -4.772  30.355  73.106  1.00 30.60           C
ATOM   1465  O   SER   181      -4.698  31.208  74.007  1.00 30.11           O
ATOM   1466  N   PHE   182      -3.709  29.900  72.440  1.00 30.07           N
ATOM   1467  CA  PHE   182      -2.341  30.369  72.734  1.00 29.70           C
ATOM   1468  CB  PHE   182      -1.478  29.205  73.229  1.00 28.93           C
ATOM   1469  CG  PHE   182      -0.081  29.612  73.644  1.00 30.73           C
ATOM   1470  CD1 PHE   182       0.124  30.449  74.761  1.00 29.47           C
ATOM   1471  CE1 PHE   182       1.406  30.827  75.151  1.00 31.11           C
ATOM   1472  CZ  PHE   182       2.526  30.332  74.445  1.00 28.39           C
ATOM   1473  CE2 PHE   182       2.328  29.475  73.331  1.00 28.33           C
ATOM   1474  CD2 PHE   182       1.034  29.106  72.962  1.00 28.37           C
ATOM   1475  C   PHE   182      -1.633  31.041  71.564  1.00 29.02           C
ATOM   1476  O   PHE   182      -1.695  30.573  70.424  1.00 28.62           O
ATOM   1477  N   THR   183      -0.943  32.151  71.841  1.00 30.11           N
ATOM   1478  CA  THR   183      -0.018  32.699  70.860  1.00 28.82           C
ATOM   1479  CB  THR   183      -0.516  34.033  70.270  1.00 30.12           C
ATOM   1480  OG1 THR   183      -1.611  33.747  69.388  1.00 30.28           O
ATOM   1481  CG2 THR   183       0.621  34.771  69.486  1.00 27.41           C
ATOM   1482  C   THR   183       1.368  32.763  71.471  1.00 28.92           C
ATOM   1483  O   THR   183       1.591  33.421  72.491  1.00 27.48           O
ATOM   1484  N   GLY   184       2.284  32.020  70.873  1.00 28.36           N
ATOM   1485  CA  GLY   184       3.663  32.001  71.341  1.00 28.69           C
ATOM   1486  C   GLY   184       4.432  33.175  70.739  1.00 29.40           C
ATOM   1487  O   GLY   184       4.204  33.561  69.581  1.00 29.16           O
ATOM   1488  N   VAL   185       5.289  33.775  71.553  1.00 29.52           N
ATOM   1489  CA  VAL   185       6.227  34.823  71.108  0.50 29.57           C
ATOM   1491  CB  VAL   185       5.977  36.191  71.805  0.50 29.47           C
ATOM   1493  CG1 VAL   185       6.778  37.296  71.119  0.50 30.12           C
ATOM   1495  CG2 VAL   185       4.518  36.544  71.808  0.50 29.56           C
ATOM   1497  C   VAL   185       7.653  34.390  71.427  1.00 29.06           C
ATOM   1498  O   VAL   185       7.987  34.165  72.587  1.00 29.80           O
ATOM   1499  N   THR   186       8.501  34.296  70.412  1.00 29.30           N
ATOM   1500  CA  THR   186       9.882  33.835  70.612  1.00 28.58           C
ATOM   1501  CB  THR   186      10.460  33.142  69.334  1.00 28.68           C
ATOM   1502  OG1 THR   186      10.512  34.084  68.261  1.00 29.27           O
ATOM   1503  CG2 THR   186       9.609  31.926  68.898  1.00 27.42           C
ATOM   1504  C   THR   186      10.818  34.915  71.149  1.00 28.67           C
ATOM   1505  O   THR   186      11.954  35.027  70.700  1.00 28.42           O
ATOM   1506  N   SER   187      10.357  35.678  72.149  1.00 28.95           N
ATOM   1507  CA  SER   187      11.169  36.731  72.796  1.00 29.25           C
ATOM   1508  CB  SER   187      10.308  37.935  73.169  1.00 29.27           C
ATOM   1509  OG  SER   187       9.157  37.486  73.857  1.00 31.18           O
ATOM   1510  C   SER   187      11.890  36.215  74.052  1.00 29.26           C
ATOM   1511  O   SER   187      12.588  36.976  74.717  1.00 28.99           O
ATOM   1512  N   GLY   188      11.722  34.929  74.357  1.00 29.16           N
ATOM   1513  CA  GLY   188      12.452  34.291  75.446  1.00 29.38           C
ATOM   1514  C   GLY   188      13.575  33.397  74.951  1.00 29.82           C
ATOM   1515  O   GLY   188      14.352  33.786  74.080  1.00 30.49           O
ATOM   1516  N   MET   189      13.652  32.185  75.503  1.00 30.04           N
ATOM   1517  CA  MET   189      14.651  31.196  75.092  1.00 30.01           C
ATOM   1518  CB  MET   189      15.408  30.630  76.296  1.00 30.07           C
ATOM   1519  CG  MET   189      16.126  31.615  77.109  1.00 31.09           C
ATOM   1520  SD  MET   189      17.657  32.307  76.282  0.70 34.38          SE
ATOM   1521  CE  MET   189      18.750  30.708  76.149  1.00 34.13           C
ATOM   1522  C   MET   189      14.031  30.019  74.345  1.00 29.96           C
ATOM   1523  O   MET   189      14.740  29.062  74.018  1.00 29.46           O
ATOM   1524  N   THR   190      12.727  30.090  74.101  1.00 29.08           N
ATOM   1525  CA  THR   190      11.991  29.049  73.389  1.00 30.03           C
ATOM   1526  CB  THR   190      10.582  28.862  73.995  1.00 30.20           C
ATOM   1527  OG1 THR   190      10.719  28.608  75.384  1.00 34.60           O
ATOM   1528  CG2 THR   190       9.802  27.720  73.330  1.00 30.40           C
ATOM   1529  C   THR   190      11.851  29.425  71.916  1.00 29.62           C
ATOM   1530  O   THR   190      11.431  30.545  71.578  1.00 29.07           O
ATOM   1531  N   THR   191      12.216  28.473  71.061  1.00 29.44           N
ATOM   1532  CA  THR   191      12.183  28.624  69.607  1.00 29.39           C
ATOM   1533  CB  THR   191      13.310  27.793  68.957  1.00 30.38           C
ATOM   1534  OG1 THR   191      12.979  26.401  69.037  1.00 30.50           O
ATOM   1535  CG2 THR   191      14.646  28.058  69.660  1.00 28.76           C
ATOM   1536  C   THR   191      10.853  28.152  69.045  1.00 29.76           C
ATOM   1537  O   THR   191      10.117  27.432  69.739  1.00 29.53           O
ATOM   1538  N   ALA   192      10.544  28.548  67.793  1.00 29.58           N
ATOM   1539  CA  ALA   192       9.320  28.119  67.118  1.00 29.13           C
ATOM   1540  CB  ALA   192       9.172  28.791  65.722  1.00 29.19           C
ATOM   1541  C   ALA   192       9.223  26.577  67.008  1.00 29.09           C
ATOM   1542  O   ALA   192       8.128  26.005  67.122  1.00 28.85           O
ATOM   1543  N   GLN   193      10.355  25.922  66.777  1.00 28.17           N
ATOM   1544  CA  GLN   193      10.406  24.464  66.753  1.00 28.79           C
ATOM   1545  CB  GLN   193      11.809  23.956  66.399  1.00 28.22           C
ATOM   1546  CG  GLN   193      11.884  22.420  66.195  1.00 29.86           C
ATOM   1547  CD  GLN   193      12.031  21.593  67.516  1.00 33.91           C
ATOM   1548  OE1 GLN   193      12.375  22.130  68.580  1.00 36.29           O
ATOM   1549  NE2 GLN   193      11.770  20.281  67.433  1.00 31.80           N
ATOM   1550  C   GLN   193       9.957  23.869  68.077  1.00 28.83           C
ATOM   1551  O   GLN   193       9.182  22.911  68.082  1.00 29.61           O
ATOM   1552  N   GLU   194      10.404  24.455  69.195  1.00 27.92           N
ATOM   1553  CA  GLU   194      10.016  23.973  70.520  1.00 27.72           C
ATOM   1554  CB  GLU   194      10.903  24.578  71.604  1.00 28.41           C
ATOM   1555  CG  GLU   194      12.358  24.124  71.434  1.00 29.11           C
ATOM   1556  CD  GLU   194      13.352  24.946  72.264  1.00 33.55           C
ATOM   1557  OE1 GLU   194      13.063  26.101  72.631  1.00 31.87           O
ATOM   1558  OE2 GLU   194      14.468  24.438  72.505  1.00 36.61           O
ATOM   1559  C   GLU   194       8.539  24.118  70.849  1.00 28.13           C
ATOM   1560  O   GLU   194       7.996  23.286  71.576  1.00 28.95           O
ATOM   1561  N   PHE   195       7.876  25.134  70.291  1.00 27.78           N
ATOM   1562  CA  PHE   195       6.448  25.356  70.560  1.00 27.60           C
ATOM   1563  CB  PHE   195       5.999  26.722  70.031  1.00 27.04           C
ATOM   1564  CG  PHE   195       6.227  27.873  70.988  1.00 28.57           C
ATOM   1565  CD1 PHE   195       5.556  27.932  72.213  1.00 28.10           C
ATOM   1566  CE1 PHE   195       5.738  29.019  73.065  1.00 28.60           C
ATOM   1567  CZ  PHE   195       6.623  30.059  72.707  1.00 28.17           C
ATOM   1568  CE2 PHE   195       7.285  30.014  71.505  1.00 29.42           C
ATOM   1569  CD2 PHE   195       7.073  28.920  70.636  1.00 29.20           C
ATOM   1570  C   PHE   195       5.595  24.322  69.886  1.00 27.81           C
ATOM   1571  O   PHE   195       4.388  24.246  70.172  1.00 28.62           O
ATOM   1572  N   GLN   196       6.193  23.565  68.953  1.00 28.00           N
ATOM   1573  CA  GLN   196       5.415  22.654  68.060  1.00 28.03           C
ATOM   1574  CB  GLN   196       6.234  22.121  66.858  1.00 28.17           C
ATOM   1575  CG  GLN   196       6.634  23.160  65.824  1.00 29.26           C
ATOM   1576  CD  GLN   196       5.496  24.111  65.490  1.00 32.07           C
ATOM   1577  OE1 GLN   196       4.407  23.676  65.136  1.00 31.14           O
ATOM   1578  NE2 GLN   196       5.751  25.418  65.584  1.00 32.53           N
ATOM   1579  C   GLN   196       4.828  21.505  68.847  1.00 27.41           C
ATOM   1580  O   GLN   196       3.836  20.909  68.443  1.00 26.80           O
ATOM   1581  N   ALA   197       5.441  21.233  70.000  1.00 27.36           N
ATOM   1582  CA  ALA   197       4.963  20.211  70.916  1.00 27.34           C
ATOM   1583  CB  ALA   197       5.976  19.969  71.995  1.00 27.40           C
ATOM   1584  C   ALA   197       3.599  20.549  71.529  1.00 26.75           C
ATOM   1585  O   ALA   197       2.985  19.700  72.159  1.00 27.17           O
ATOM   1586  N   TYR   198       3.132  21.784  71.348  1.00 27.66           N
ATOM   1587  CA  TYR   198       1.888  22.273  71.987  1.00 27.71           C
ATOM   1588  CB  TYR   198       2.222  23.218  73.155  1.00 28.98           C
ATOM   1589  CG  TYR   198       3.075  22.606  74.241  1.00 31.68           C
ATOM   1590  CD1 TYR   198       2.493  22.084  75.418  1.00 31.00           C
ATOM   1591  CE1 TYR   198       3.317  21.526  76.432  1.00 33.40           C
ATOM   1592  CZ  TYR   198       4.701  21.471  76.220  1.00 31.87           C
ATOM   1593  OH  TYR   198       5.542  20.945  77.177  1.00 33.47           O
ATOM   1594  CE2 TYR   198       5.276  21.957  75.053  1.00 31.80           C
ATOM   1595  CD2 TYR   198       4.478  22.534  74.089  1.00 30.17           C
ATOM   1596  C   TYR   198       1.028  23.062  71.006  1.00 27.44           C
ATOM   1597  O   TYR   198       1.554  23.596  70.012  1.00 25.39           O
ATOM   1598  N   PRO   199      -0.291  23.188  71.307  1.00 26.95           N
ATOM   1599  CA  PRO   199      -1.191  23.937  70.432  1.00 27.37           C
ATOM   1600  CB  PRO   199      -2.607  23.578  70.968  1.00 27.67           C
ATOM   1601  CG  PRO   199      -2.415  22.459  71.974  1.00 26.62           C
ATOM   1602  CD  PRO   199      -0.996  22.613  72.470  1.00 27.05           C
ATOM   1603  C   PRO   199      -0.940  25.455  70.438  1.00 27.64           C
ATOM   1604  O   PRO   199      -0.574  26.036  71.464  1.00 28.07           O
ATOM   1605  N   TYR   200      -1.122  26.094  69.291  1.00 28.51           N
ATOM   1606  CA  TYR   200      -0.984  27.553  69.181  1.00 28.39           C
ATOM   1607  CB  TYR   200       0.483  27.956  68.937  1.00 28.12           C
ATOM   1608  CG  TYR   200       1.092  27.286  67.713  1.00 29.23           C
ATOM   1609  CD1 TYR   200       1.055  27.904  66.452  1.00 30.22           C
ATOM   1610  CE1 TYR   200       1.600  27.269  65.316  1.00 27.75           C
ATOM   1611  CZ  TYR   200       2.163  26.012  65.453  1.00 28.10           C
ATOM   1612  OH  TYR   200       2.700  25.386  64.349  1.00 28.06           O
ATOM   1613  CE2 TYR   200       2.194  25.374  66.692  1.00 26.81           C
ATOM   1614  CD2 TYR   200       1.675  26.006  67.805  1.00 29.53           C
ATOM   1615  C   TYR   200      -1.854  28.017  68.011  1.00 29.50           C
ATOM   1616  O   TYR   200      -2.206  27.214  67.120  1.00 28.52           O
ATOM   1617  N   ASP   201      -2.167  29.306  68.021  1.00 29.42           N
ATOM   1618  CA  ASP   201      -2.749  29.989  66.892  1.00 30.78           C
ATOM   1619  CB  ASP   201      -3.443  31.268  67.386  1.00 31.84           C
ATOM   1620  CG  ASP   201      -4.895  31.063  67.642  1.00 34.16           C
ATOM   1621  OD1 ASP   201      -5.302  29.885  67.776  1.00 35.12           O
ATOM   1622  OD2 ASP   201      -5.629  32.079  67.695  1.00 37.28           O
ATOM   1623  C   ASP   201      -1.698  30.412  65.906  1.00 30.46           C
ATOM   1624  O   ASP   201      -1.764  30.067  64.733  1.00 30.55           O
ATOM   1625  N   ARG   202      -0.770  31.219  66.409  1.00 30.69           N
ATOM   1626  CA  ARG   202       0.383  31.726  65.703  1.00 30.71           C
ATOM   1627  CB  ARG   202       0.173  33.219  65.357  1.00 30.87           C
ATOM   1628  CG  ARG   202      -0.615  33.475  64.109  1.00 32.31           C
ATOM   1629  CD  ARG   202      -0.559  34.954  63.773  1.00 35.48           C
ATOM   1630  NE  ARG   202      -1.190  35.768  64.806  1.00 37.62           N
ATOM   1631  CZ  ARG   202      -1.028  37.082  64.932  1.00 39.80           C
ATOM   1632  NH1 ARG   202      -0.239  37.745  64.091  1.00 42.12           N
ATOM   1633  NH2 ARG   202      -1.656  37.733  65.893  1.00 38.13           N
ATOM   1634  C   ARG   202       1.593  31.653  66.626  1.00 30.68           C
ATOM   1635  O   ARG   202       1.461  31.511  67.855  1.00 31.05           O
ATOM   1636  N   ILE   203       2.775  31.719  66.016  1.00 29.99           N
ATOM   1637  CA  ILE   203       4.021  31.914  66.733  0.50 29.91           C
ATOM   1639  CB  ILE   203       4.980  30.689  66.644  0.50 29.40           C
ATOM   1641  CG1 ILE   203       4.316  29.388  67.127  0.50 28.07           C
ATOM   1643  CD1 ILE   203       4.012  29.281  68.634  0.50 24.34           C
ATOM   1645  CG2 ILE   203       6.279  30.975  67.415  0.50 30.13           C
ATOM   1647  C   ILE   203       4.680  33.123  66.078  1.00 30.29           C
ATOM   1648  O   ILE   203       5.018  33.072  64.882  1.00 31.17           O
ATOM   1649  N   ILE   204       4.859  34.190  66.853  1.00 30.12           N
ATOM   1650  CA  ILE   204       5.346  35.470  66.342  1.00 30.67           C
ATOM   1651  CB  ILE   204       4.348  36.614  66.701  1.00 30.30           C
ATOM   1652  CG1 ILE   204       3.968  36.571  68.184  1.00 30.24           C
ATOM   1653  CD1 ILE   204       3.245  37.841  68.688  1.00 31.03           C
ATOM   1654  CG2 ILE   204       3.063  36.491  65.837  1.00 30.53           C
ATOM   1655  C   ILE   204       6.740  35.752  66.864  1.00 30.85           C
ATOM   1656  O   ILE   204       7.143  35.145  67.855  1.00 32.34           O
ATOM   1657  N   SER   205       7.479  36.657  66.223  1.00 30.89           N
ATOM   1658  CA  SER   205       8.802  37.060  66.731  1.00 31.63           C
ATOM   1659  CB  SER   205       9.761  37.523  65.616  1.00 31.53           C
ATOM   1660  OG  SER   205       9.422  36.957  64.387  1.00 34.62           O
ATOM   1661  C   SER   205       8.726  38.184  67.727  1.00 31.36           C
ATOM   1662  O   SER   205       9.549  38.262  68.636  1.00 31.48           O
ATOM   1663  N   THR   206       7.780  39.094  67.528  1.00 31.39           N
ATOM   1664  CA  THR   206       7.694  40.256  68.397  1.00 31.78           C
ATOM   1665  CB  THR   206       8.300  41.547  67.768  1.00 31.65           C
ATOM   1666  OG1 THR   206       7.678  41.831  66.496  1.00 29.92           O
ATOM   1667  CG2 THR   206       9.799  41.393  67.560  1.00 31.94           C
ATOM   1668  C   THR   206       6.249  40.468  68.768  1.00 32.33           C
ATOM   1669  O   THR   206       5.361  40.078  68.033  1.00 32.08           O
ATOM   1670  N   LEU   207       6.031  41.076  69.926  1.00 32.23           N
ATOM   1671  CA  LEU   207       4.695  41.333  70.432  1.00 32.50           C
ATOM   1672  CB  LEU   207       4.810  42.054  71.769  1.00 32.65           C
ATOM   1673  CG  LEU   207       3.731  41.888  72.812  1.00 32.55           C
ATOM   1674  CD1 LEU   207       3.511  40.409  73.119  1.00 31.90           C
ATOM   1675  CD2 LEU   207       4.156  42.696  74.074  1.00 32.43           C
ATOM   1676  C   LEU   207       3.883  42.193  69.491  1.00 32.69           C
ATOM   1677  O   LEU   207       2.659  42.042  69.420  1.00 31.97           O
ATOM   1678  N   GLY   208       4.566  43.099  68.785  1.00 33.30           N
ATOM   1679  CA  GLY   208       3.915  44.042  67.854  1.00 34.10           C
ATOM   1680  C   GLY   208       3.157  43.356  66.723  1.00 34.93           C
ATOM   1681  O   GLY   208       2.197  43.917  66.148  1.00 34.41           O
ATOM   1682  N   GLN   209       3.585  42.132  66.426  1.00 35.26           N
ATOM   1683  CA  GLN   209       2.970  41.301  65.428  1.00 37.01           C
ATOM   1684  CB  GLN   209       3.897  40.153  65.086  1.00 37.01           C
ATOM   1685  CG  GLN   209       4.944  40.551  64.079  1.00 39.42           C
ATOM   1686  CD  GLN   209       6.007  39.515  63.924  1.00 43.33           C
ATOM   1687  OE1 GLN   209       5.726  38.322  63.928  1.00 47.40           O
ATOM   1688  NE2 GLN   209       7.246  39.958  63.786  1.00 44.87           N
ATOM   1689  C   GLN   209       1.622  40.782  65.877  1.00 37.66           C
ATOM   1690  O   GLN   209       0.838  40.275  65.078  1.00 37.76           O
ATOM   1691  N   LEU   210       1.340  40.922  67.159  1.00 38.30           N
ATOM   1692  CA  LEU   210       0.026  40.564  67.689  1.00 39.49           C
ATOM   1693  CB  LEU   210       0.023  40.739  69.216  1.00 39.62           C
ATOM   1694  CG  LEU   210      -0.703  39.828  70.214  1.00 39.33           C
ATOM   1695  CD1 LEU   210      -0.693  38.331  69.883  1.00 36.10           C
ATOM   1696  CD2 LEU   210      -0.077  40.083  71.560  1.00 37.45           C
ATOM   1697  C   LEU   210      -1.054  41.400  67.016  1.00 40.60           C
ATOM   1698  O   LEU   210      -2.172  40.925  66.781  1.00 41.32           O
ATOM   1699  N   ILE   211      -0.697  42.640  66.685  1.00 41.56           N
ATOM   1700  CA  ILE   211      -1.547  43.572  65.950  1.00 41.96           C
ATOM   1701  CB  ILE   211      -1.172  45.062  66.259  1.00 42.21           C
ATOM   1702  CG1 ILE   211      -1.168  45.366  67.774  1.00 42.34           C
ATOM   1703  CD1 ILE   211      -2.480  45.107  68.511  1.00 41.30           C
ATOM   1704  CG2 ILE   211      -2.040  46.032  65.448  1.00 43.37           C
ATOM   1705  C   ILE   211      -1.374  43.340  64.456  1.00 41.85           C
ATOM   1706  O   ILE   211      -2.312  42.930  63.776  1.00 42.35           O
END
