
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  245 ( 1897),  selected  245 , name 1h7e_A
# Molecule2: number of CA atoms  178 ( 1356),  selected  178 , name T0420.pdb
# PARAMETERS: 1h7e_A.T0420.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      M       1          2.660
LGA    K     2_A      N       2          1.070
LGA    A     3_A      I       3          0.754
LGA    V     4_A      G       4          1.422
LGA    I     5_A      V       5          1.219
LGA    V     6_A      I       6          1.281
LGA    I     7_A      I       7          1.072
LGA    P     8_A      L       8          0.693
LGA    A     9_A      A       9          0.709
LGA    R    10_A      A      10          2.359
LGA    -       -      G      11           -
LGA    -       -      E      12           -
LGA    -       -      G      13           -
LGA    -       -      K      14           -
LGA    -       -      R      15           -
LGA    -       -      F      16           -
LGA    Y    11_A      G      17          1.765
LGA    G    12_A      G      18           #
LGA    S    13_A      -       -           -
LGA    S    14_A      -       -           -
LGA    R    15_A      -       -           -
LGA    L    16_A      -       -           -
LGA    P    17_A      -       -           -
LGA    G    18_A      D      19          1.209
LGA    K    19_A      K      20          1.439
LGA    P    20_A      L      21          1.175
LGA    L    21_A      L      22          1.021
LGA    L    22_A      A      23          0.904
LGA    D    23_A      K      24          1.813
LGA    I    24_A      I      25          2.121
LGA    V    25_A      D      26          2.679
LGA    G    26_A      N      27          2.692
LGA    K    27_A      T      28          2.182
LGA    P    28_A      P      29          1.327
LGA    M    29_A      I      30          0.654
LGA    I    30_A      I      31          0.359
LGA    Q    31_A      M      32          0.413
LGA    H    32_A      R      33          0.485
LGA    V    33_A      T      34          0.741
LGA    Y    34_A      I      35          0.961
LGA    E    35_A      R      36          1.278
LGA    R    36_A      I      37          1.512
LGA    A    37_A      Y      38          1.260
LGA    L    38_A      G      39          0.833
LGA    Q    39_A      D      40          5.696
LGA    V    40_A      -       -           -
LGA    A    41_A      -       -           -
LGA    G    42_A      -       -           -
LGA    V    43_A      -       -           -
LGA    A    44_A      L      41          3.942
LGA    E    45_A      E      42          0.911
LGA    V    46_A      K      43          1.171
LGA    W    47_A      I      44          1.508
LGA    V    48_A      I      45          1.068
LGA    A    49_A      I      46          1.060
LGA    T    50_A      V      47          1.418
LGA    D    51_A      G      48          1.291
LGA    D    52_A      K      49          3.392
LGA    -       -      Y      50           -
LGA    P    53_A      V      51          1.919
LGA    R    54_A      N      52          1.849
LGA    V    55_A      E      53          4.763
LGA    E    56_A      M      54          4.696
LGA    Q    57_A      L      55          1.474
LGA    A    58_A      P      56          3.144
LGA    V    59_A      L      57          3.814
LGA    Q    60_A      L      58          2.945
LGA    A    61_A      M      59          3.280
LGA    F    62_A      -       -           -
LGA    G    63_A      D      60          1.504
LGA    G    64_A      Q      61          1.998
LGA    K    65_A      I      62          1.991
LGA    A    66_A      V      63          1.186
LGA    I    67_A      I      64          1.227
LGA    M    68_A      Y      65          1.581
LGA    T    69_A      N      66          2.132
LGA    -       -      P      67           -
LGA    R    70_A      F      68          2.422
LGA    N    71_A      W      69          1.296
LGA    D    72_A      N      70          3.927
LGA    H    73_A      E      71          3.884
LGA    E    74_A      G      72          2.610
LGA    S    75_A      I      73          3.328
LGA    G    76_A      -       -           -
LGA    T    77_A      S      74          4.467
LGA    D    78_A      T      75          4.434
LGA    R    79_A      S      76          2.182
LGA    L    80_A      L      77          1.770
LGA    V    81_A      K      78          2.053
LGA    E    82_A      L      79          2.026
LGA    V    83_A      G      80          1.092
LGA    M    84_A      L      81          1.110
LGA    H    85_A      R      82          1.330
LGA    K    86_A      F      83          2.710
LGA    V    87_A      F      84          3.454
LGA    E    88_A      K      85          4.574
LGA    -       -      D      86           -
LGA    A    89_A      Y      87          2.313
LGA    D    90_A      D      88          1.695
LGA    I    91_A      A      89          1.206
LGA    Y    92_A      V      90          0.374
LGA    I    93_A      L      91          0.280
LGA    N    94_A      V      92          1.028
LGA    L    95_A      A      93          1.452
LGA    Q    96_A      L      94          1.715
LGA    G    97_A      G      95          0.987
LGA    D    98_A      D      96          1.243
LGA    E    99_A      M      97          1.925
LGA    P   100_A      P      98          1.621
LGA    M   101_A      F      99          2.104
LGA    I   102_A      V     100          1.734
LGA    R   103_A      T     101          0.730
LGA    P   104_A      K     102          0.498
LGA    R   105_A      E     103          1.069
LGA    D   106_A      D     104          0.772
LGA    V   107_A      V     105          0.834
LGA    E   108_A      N     106          1.182
LGA    T   109_A      K     107          0.912
LGA    L   110_A      I     108          0.852
LGA    L   111_A      I     109          0.790
LGA    Q   112_A      N     110          1.087
LGA    G   113_A      T     111          1.209
LGA    M   114_A      F     112          1.249
LGA    R   115_A      -       -           -
LGA    D   116_A      -       -           -
LGA    D   117_A      K     113          1.683
LGA    P   118_A      P     114          0.860
LGA    A   119_A      N     115          2.577
LGA    L   120_A      C     116          1.087
LGA    P   121_A      K     117          1.225
LGA    V   122_A      A     118          0.956
LGA    A   123_A      V     119          1.148
LGA    T   124_A      I     120          0.995
LGA    L   125_A      P     121          1.024
LGA    C   126_A      T     122          1.170
LGA    H   127_A      H     123          1.138
LGA    A   128_A      K     124          1.602
LGA    I   129_A      -       -           -
LGA    S   130_A      -       -           -
LGA    A   131_A      -       -           -
LGA    A   132_A      -       -           -
LGA    E   133_A      -       -           -
LGA    A   134_A      -       -           -
LGA    A   135_A      -       -           -
LGA    E   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    T   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    K   141_A      -       -           -
LGA    V   142_A      -       -           -
LGA    V   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    N   145_A      -       -           -
LGA    T   146_A      -       -           -
LGA    R   147_A      -       -           -
LGA    Q   148_A      -       -           -
LGA    D   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    Y   152_A      -       -           -
LGA    F   153_A      -       -           -
LGA    S   154_A      -       -           -
LGA    R   155_A      -       -           -
LGA    S   156_A      -       -           -
LGA    P   157_A      -       -           -
LGA    I   158_A      -       -           -
LGA    P   159_A      -       -           -
LGA    Y   160_A      -       -           -
LGA    P   161_A      -       -           -
LGA    R   162_A      -       -           -
LGA    N   163_A      -       -           -
LGA    A   164_A      -       -           -
LGA    E   165_A      -       -           -
LGA    K   166_A      -       -           -
LGA    A   167_A      -       -           -
LGA    R   168_A      -       -           -
LGA    Y   169_A      -       -           -
LGA    L   170_A      G     125          0.861
LGA    K   171_A      E     126          2.335
LGA    H   172_A      R     127          1.983
LGA    V   173_A      G     128          1.522
LGA    G   174_A      N     129          2.535
LGA    I   175_A      P     130          1.548
LGA    Y   176_A      V     131          0.389
LGA    A   177_A      L     132          0.326
LGA    Y   178_A      I     133          0.594
LGA    R   179_A      S     134          0.813
LGA    R   180_A      K     135          2.113
LGA    D   181_A      S     136          3.049
LGA    V   182_A      L     137          0.793
LGA    L   183_A      F     138          1.884
LGA    Q   184_A      N     139          2.422
LGA    N   185_A      E     140          2.848
LGA    Y   186_A      I     141          2.457
LGA    -       -      E     142           -
LGA    S   187_A      K     143          0.685
LGA    Q   188_A      L     144           #
LGA    L   189_A      R     145           -
LGA    P   190_A      G     146           -
LGA    E   191_A      D     147           -
LGA    S   192_A      -       -           -
LGA    M   193_A      -       -           -
LGA    P   194_A      -       -           -
LGA    E   195_A      -       -           -
LGA    Q   196_A      -       -           -
LGA    A   197_A      -       -           -
LGA    E   198_A      -       -           -
LGA    S   199_A      -       -           -
LGA    L   200_A      -       -           -
LGA    E   201_A      V     148           #
LGA    -       -      G     149           -
LGA    -       -      A     150           -
LGA    Q   202_A      R     151          1.753
LGA    L   203_A      V     152          3.804
LGA    R   204_A      I     153          3.717
LGA    L   205_A      L     154          3.306
LGA    M   206_A      N     155          2.775
LGA    N   207_A      K     156          2.891
LGA    A   208_A      -       -           -
LGA    G   209_A      I     157          3.128
LGA    I   210_A      K     158          5.122
LGA    N   211_A      I     159          4.696
LGA    -       -      E     160           -
LGA    -       -      E     161           -
LGA    I   212_A      L     162          2.871
LGA    R   213_A      C     163          2.225
LGA    T   214_A      F     164          2.077
LGA    F   215_A      I     165          1.375
LGA    E   216_A      E     166          1.592
LGA    V   217_A      C     167          2.336
LGA    A   218_A      S     168          3.739
LGA    A   219_A      E     169          3.281
LGA    T   220_A      -       -           -
LGA    G   221_A      G     170          3.922
LGA    P   222_A      V     171           -
LGA    -       -      L     172           -
LGA    -       -      I     173           -
LGA    G   223_A      D     174          3.164
LGA    V   224_A      I     175          1.467
LGA    D   225_A      D     176          0.719
LGA    T   226_A      K     177           #
LGA    P   227_A      -       -           -
LGA    A   228_A      -       -           -
LGA    C   229_A      K     178          3.737
LGA    L   230_A      -       -           -
LGA    E   231_A      -       -           -
LGA    K   232_A      -       -           -
LGA    V   233_A      -       -           -
LGA    R   234_A      -       -           -
LGA    A   235_A      -       -           -
LGA    L   236_A      -       -           -
LGA    M   237_A      -       -           -
LGA    A   238_A      -       -           -
LGA    Q   239_A      -       -           -
LGA    E   240_A      -       -           -
LGA    L   241_A      -       -           -
LGA    A   242_A      -       -           -
LGA    E   243_A      -       -           -
LGA    N   244_A      -       -           -
LGA    A   245_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  245  178    5.0    154    2.21    14.29     61.780     6.675

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.561210 * X  +  -0.667596 * Y  +  -0.489243 * Z  + 194.525009
  Y_new =   0.385868 * X  +  -0.733974 * Y  +   0.558916 * Z  + 126.461060
  Z_new =  -0.732222 * X  +   0.124886 * Y  +   0.669518 * Z  +  15.705433 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.184412   -2.957181  [ DEG:    10.5660   -169.4340 ]
  Theta =   0.821579    2.320014  [ DEG:    47.0730    132.9270 ]
  Phi   =   2.539261   -0.602332  [ DEG:   145.4889    -34.5111 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1h7e_A                                        
REMARK     2: T0420.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1h7e_A.T0420.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  245  178   5.0  154   2.21   14.29  61.780
REMARK  ---------------------------------------------------------- 
MOLECULE 1h7e_A
HEADER    NUCLEOTIDYLTRANSFERASE                  06-JUL-01   1H7E              
TITLE     THE STRUCTURE OF CMP:2-KETO-3-DEOXY-MANNO-OCTONIC ACID                
TITLE    2 SYNTHETASE AND OF ITS COMPLEXES WITH SUBSTRATES AND                  
TITLE    3 SUBSTRATE ANALOGUES, APO-ENZYME                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 3-DEOXY-MANNO-OCTULOSONATE CYTIDYLYLTRANSFERASE;           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: CMP-KDO SYNTHETASE, CKS, CMP-2-KETO-3-                      
COMPND   5 DEOXYOCTULOSONIC ACID SYNTHETASE, CMP-2-KETO-3-DEOXY-MANNO           
COMPND   6 -OCTONIC ACID SYNTHETASE;                                            
COMPND   7 EC: 2.7.7.38;                                                        
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: K5;                                                          
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    CMP-KDO SYNTHETASE, NUCLEOSIDE MONOPHOSPHATE GLYCOSIDES,              
KEYWDS   2 LIPOPOLYSACCHARIDE BIOSYNTHESIS, SUGAR-ACTIVATING ENZYMES            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.JELAKOVIC,G.E.SCHULZ                                                
REVDAT   1   13-SEP-01 1H7E    0                                                
JRNL        AUTH   S.JELAKOVIC,G.E.SCHULZ                                       
JRNL        TITL   THE STRUCTURE OF CMP:2-KETO-3-DEOXY-MANNO-OCTONIC            
JRNL        TITL 2 ACID SYNTHETASE AND OF ITS COMPLEXES WITH                    
JRNL        TITL 3 SUBSTRATES AND SUBSTRATE ANALOGS.                            
JRNL        REF    J.MOL.BIOL.                   V. 312   143 2001              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.83 ANGSTROMS.                                          
DBREF  1H7E A    1   245  UNP    P42216   KSU5_ECOLI       1    245             
DBREF  1H7E B    1   245  UNP    P42216   KSU5_ECOLI       1    245             
SEQRES   1 A  245  SER LYS ALA VAL ILE VAL ILE PRO ALA ARG TYR GLY SER          
SEQRES   2 A  245  SER ARG LEU PRO GLY LYS PRO LEU LEU ASP ILE VAL GLY          
SEQRES   3 A  245  LYS PRO MET ILE GLN HIS VAL TYR GLU ARG ALA LEU GLN          
SEQRES   4 A  245  VAL ALA GLY VAL ALA GLU VAL TRP VAL ALA THR ASP ASP          
SEQRES   5 A  245  PRO ARG VAL GLU GLN ALA VAL GLN ALA PHE GLY GLY LYS          
SEQRES   6 A  245  ALA ILE MET THR ARG ASN ASP HIS GLU SER GLY THR ASP          
SEQRES   7 A  245  ARG LEU VAL GLU VAL MET HIS LYS VAL GLU ALA ASP ILE          
SEQRES   8 A  245  TYR ILE ASN LEU GLN GLY ASP GLU PRO MET ILE ARG PRO          
SEQRES   9 A  245  ARG ASP VAL GLU THR LEU LEU GLN GLY MET ARG ASP ASP          
SEQRES  10 A  245  PRO ALA LEU PRO VAL ALA THR LEU CYS HIS ALA ILE SER          
SEQRES  11 A  245  ALA ALA GLU ALA ALA GLU PRO SER THR VAL LYS VAL VAL          
SEQRES  12 A  245  VAL ASN THR ARG GLN ASP ALA LEU TYR PHE SER ARG SER          
SEQRES  13 A  245  PRO ILE PRO TYR PRO ARG ASN ALA GLU LYS ALA ARG TYR          
SEQRES  14 A  245  LEU LYS HIS VAL GLY ILE TYR ALA TYR ARG ARG ASP VAL          
SEQRES  15 A  245  LEU GLN ASN TYR SER GLN LEU PRO GLU SER MET PRO GLU          
SEQRES  16 A  245  GLN ALA GLU SER LEU GLU GLN LEU ARG LEU MET ASN ALA          
SEQRES  17 A  245  GLY ILE ASN ILE ARG THR PHE GLU VAL ALA ALA THR GLY          
SEQRES  18 A  245  PRO GLY VAL ASP THR PRO ALA CYS LEU GLU LYS VAL ARG          
SEQRES  19 A  245  ALA LEU MET ALA GLN GLU LEU ALA GLU ASN ALA                  
SEQRES   1 B  245  SER LYS ALA VAL ILE VAL ILE PRO ALA ARG TYR GLY SER          
SEQRES   2 B  245  SER ARG LEU PRO GLY LYS PRO LEU LEU ASP ILE VAL GLY          
SEQRES   3 B  245  LYS PRO MET ILE GLN HIS VAL TYR GLU ARG ALA LEU GLN          
SEQRES   4 B  245  VAL ALA GLY VAL ALA GLU VAL TRP VAL ALA THR ASP ASP          
SEQRES   5 B  245  PRO ARG VAL GLU GLN ALA VAL GLN ALA PHE GLY GLY LYS          
SEQRES   6 B  245  ALA ILE MET THR ARG ASN ASP HIS GLU SER GLY THR ASP          
SEQRES   7 B  245  ARG LEU VAL GLU VAL MET HIS LYS VAL GLU ALA ASP ILE          
SEQRES   8 B  245  TYR ILE ASN LEU GLN GLY ASP GLU PRO MET ILE ARG PRO          
SEQRES   9 B  245  ARG ASP VAL GLU THR LEU LEU GLN GLY MET ARG ASP ASP          
SEQRES  10 B  245  PRO ALA LEU PRO VAL ALA THR LEU CYS HIS ALA ILE SER          
SEQRES  11 B  245  ALA ALA GLU ALA ALA GLU PRO SER THR VAL LYS VAL VAL          
SEQRES  12 B  245  VAL ASN THR ARG GLN ASP ALA LEU TYR PHE SER ARG SER          
SEQRES  13 B  245  PRO ILE PRO TYR PRO ARG ASN ALA GLU LYS ALA ARG TYR          
SEQRES  14 B  245  LEU LYS HIS VAL GLY ILE TYR ALA TYR ARG ARG ASP VAL          
SEQRES  15 B  245  LEU GLN ASN TYR SER GLN LEU PRO GLU SER MET PRO GLU          
SEQRES  16 B  245  GLN ALA GLU SER LEU GLU GLN LEU ARG LEU MET ASN ALA          
SEQRES  17 B  245  GLY ILE ASN ILE ARG THR PHE GLU VAL ALA ALA THR GLY          
SEQRES  18 B  245  PRO GLY VAL ASP THR PRO ALA CYS LEU GLU LYS VAL ARG          
SEQRES  19 B  245  ALA LEU MET ALA GLN GLU LEU ALA GLU ASN ALA                  
FORMUL   3  HOH   *464(H2 O)                                                    
CRYST1   46.100  133.800   48.480  90.00 102.57  90.00 P 1 21 1      4          
ATOM      1  N   SER A   1      70.545 105.473  44.877  1.00 46.76           N  
ATOM      2  CA  SER A   1      71.906 105.751  45.422  1.00 45.58           C  
ATOM      3  C   SER A   1      71.942 105.618  46.947  1.00 41.25           C  
ATOM      4  O   SER A   1      71.578 106.544  47.674  1.00 42.88           O  
ATOM      5  CB  SER A   1      72.379 107.148  45.000  1.00 47.58           C  
ATOM      6  OG  SER A   1      73.677 107.095  44.419  1.00 51.42           O  
ATOM      7  N   LYS A   2      72.370 104.453  47.426  1.00 33.95           N  
ATOM      8  CA  LYS A   2      72.454 104.205  48.862  1.00 26.53           C  
ATOM      9  C   LYS A   2      73.811 104.664  49.377  1.00 22.88           C  
ATOM     10  O   LYS A   2      74.856 104.361  48.793  1.00 21.72           O  
ATOM     11  CB  LYS A   2      72.262 102.720  49.148  1.00 25.57           C  
ATOM     12  CG  LYS A   2      72.225 102.361  50.618  1.00 28.98           C  
ATOM     13  CD  LYS A   2      72.198 100.846  50.780  1.00 32.51           C  
ATOM     14  CE  LYS A   2      72.251 100.429  52.238  1.00 34.33           C  
ATOM     15  NZ  LYS A   2      72.428  98.946  52.404  1.00 38.91           N  
ATOM     16  N   ALA A   3      73.789 105.402  50.472  1.00 21.13           N  
ATOM     17  CA  ALA A   3      75.014 105.896  51.067  1.00 17.14           C  
ATOM     18  C   ALA A   3      75.094 105.419  52.491  1.00 18.10           C  
ATOM     19  O   ALA A   3      74.078 105.357  53.181  1.00 19.01           O  
ATOM     20  CB  ALA A   3      75.015 107.420  51.048  1.00 17.90           C  
ATOM     21  N   VAL A   4      76.296 105.061  52.930  1.00 14.43           N  
ATOM     22  CA  VAL A   4      76.497 104.661  54.318  1.00 14.91           C  
ATOM     23  C   VAL A   4      77.687 105.421  54.906  1.00 14.99           C  
ATOM     24  O   VAL A   4      78.587 105.862  54.184  1.00 16.89           O  
ATOM     25  CB  VAL A   4      76.724 103.127  54.501  1.00 17.42           C  
ATOM     26  CG1 VAL A   4      75.581 102.332  53.831  1.00 16.30           C  
ATOM     27  CG2 VAL A   4      78.070 102.713  53.974  1.00 17.80           C  
ATOM     28  N   ILE A   5      77.653 105.643  56.203  1.00 13.05           N  
ATOM     29  CA  ILE A   5      78.749 106.319  56.876  1.00 14.33           C  
ATOM     30  C   ILE A   5      79.512 105.282  57.670  1.00 14.77           C  
ATOM     31  O   ILE A   5      78.910 104.482  58.384  1.00 15.69           O  
ATOM     32  CB  ILE A   5      78.261 107.416  57.837  1.00 13.67           C  
ATOM     33  CG1 ILE A   5      77.735 108.603  57.039  1.00 13.40           C  
ATOM     34  CG2 ILE A   5      79.375 107.817  58.803  1.00 12.82           C  
ATOM     35  CD1 ILE A   5      77.068 109.650  57.894  1.00 16.72           C  
ATOM     36  N   VAL A   6      80.833 105.258  57.501  1.00 13.55           N  
ATOM     37  CA  VAL A   6      81.686 104.329  58.229  1.00 12.57           C  
ATOM     38  C   VAL A   6      82.620 105.156  59.102  1.00 16.32           C  
ATOM     39  O   VAL A   6      83.262 106.101  58.627  1.00 17.54           O  
ATOM     40  CB  VAL A   6      82.519 103.419  57.282  1.00 11.84           C  
ATOM     41  CG1 VAL A   6      83.437 102.524  58.093  1.00 11.57           C  
ATOM     42  CG2 VAL A   6      81.604 102.576  56.425  1.00 13.59           C  
ATOM     43  N   ILE A   7      82.668 104.832  60.386  1.00 15.03           N  
ATOM     44  CA  ILE A   7      83.507 105.540  61.334  1.00 14.92           C  
ATOM     45  C   ILE A   7      84.599 104.607  61.847  1.00 19.54           C  
ATOM     46  O   ILE A   7      84.318 103.678  62.601  1.00 20.23           O  
ATOM     47  CB  ILE A   7      82.687 106.023  62.556  1.00 16.55           C  
ATOM     48  CG1 ILE A   7      81.524 106.914  62.116  1.00 13.63           C  
ATOM     49  CG2 ILE A   7      83.591 106.774  63.551  1.00 15.92           C  
ATOM     50  CD1 ILE A   7      80.470 107.077  63.195  1.00 12.56           C  
ATOM     51  N   PRO A   8      85.850 104.785  61.378  1.00 23.74           N  
ATOM     52  CA  PRO A   8      86.978 103.949  61.819  1.00 25.20           C  
ATOM     53  C   PRO A   8      87.258 104.331  63.269  1.00 29.86           C  
ATOM     54  O   PRO A   8      87.406 105.515  63.581  1.00 32.05           O  
ATOM     55  CB  PRO A   8      88.135 104.430  60.933  1.00 26.64           C  
ATOM     56  CG  PRO A   8      87.466 104.956  59.729  1.00 29.09           C  
ATOM     57  CD  PRO A   8      86.276 105.693  60.299  1.00 25.01           C  
ATOM     58  N   ALA A   9      87.325 103.354  64.160  1.00 33.39           N  
ATOM     59  CA  ALA A   9      87.559 103.660  65.562  1.00 38.19           C  
ATOM     60  C   ALA A   9      88.483 102.653  66.212  1.00 45.52           C  
ATOM     61  O   ALA A   9      88.025 101.680  66.810  1.00 46.39           O  
ATOM     62  CB  ALA A   9      86.231 103.723  66.319  1.00 34.85           C  
ATOM     63  N   ARG A  10      89.787 102.870  66.069  1.00 55.76           N  
ATOM     64  CA  ARG A  10      90.755 101.983  66.693  1.00 67.54           C  
ATOM     65  C   ARG A  10      91.178 102.509  68.081  1.00 72.32           C  
ATOM     66  O   ARG A  10      91.439 103.707  68.265  1.00 72.11           O  
ATOM     67  CB  ARG A  10      91.938 101.679  65.757  1.00 71.28           C  
ATOM     68  CG  ARG A  10      92.531 102.853  64.992  1.00 79.24           C  
ATOM     69  CD  ARG A  10      93.479 102.357  63.893  1.00 86.37           C  
ATOM     70  NE  ARG A  10      94.454 101.376  64.384  1.00 92.71           N  
ATOM     71  CZ  ARG A  10      94.932 100.355  63.668  1.00 96.42           C  
ATOM     72  NH1 ARG A  10      94.535 100.166  62.413  1.00 98.66           N  
ATOM     73  NH2 ARG A  10      95.790  99.502  64.216  1.00 97.80           N  
ATOM     74  N   TYR A  11      91.135 101.605  69.063  1.00 78.89           N  
ATOM     75  CA  TYR A  11      91.460 101.886  70.464  1.00 85.57           C  
ATOM     76  C   TYR A  11      92.886 102.388  70.655  1.00 89.15           C  
ATOM     77  O   TYR A  11      93.106 103.528  71.083  1.00 89.04           O  
ATOM     78  CB  TYR A  11      91.235 100.612  71.297  1.00 87.61           C  
ATOM     79  CG  TYR A  11      91.315 100.781  72.803  1.00 90.37           C  
ATOM     80  CD1 TYR A  11      90.154 100.854  73.577  1.00 91.35           C  
ATOM     81  CD2 TYR A  11      92.548 100.827  73.461  1.00 91.12           C  
ATOM     82  CE1 TYR A  11      90.219 100.963  74.967  1.00 91.40           C  
ATOM     83  CE2 TYR A  11      92.622 100.940  74.850  1.00 92.56           C  
ATOM     84  CZ  TYR A  11      91.454 101.007  75.595  1.00 92.14           C  
ATOM     85  OH  TYR A  11      91.521 101.118  76.964  1.00 92.54           O  
ATOM     86  N   GLY A  12      93.842 101.518  70.328  1.00 93.10           N  
ATOM     87  CA  GLY A  12      95.256 101.824  70.461  1.00 96.50           C  
ATOM     88  C   GLY A  12      95.729 103.109  69.808  1.00 99.06           C  
ATOM     89  O   GLY A  12      95.548 103.335  68.605  1.00100.00           O  
ATOM     90  N   SER A  13      96.340 103.955  70.630  1.00100.00           N  
ATOM     91  CA  SER A  13      96.881 105.238  70.197  1.00100.00           C  
ATOM     92  C   SER A  13      97.970 105.552  71.226  1.00100.00           C  
ATOM     93  O   SER A  13      97.835 105.206  72.406  1.00100.00           O  
ATOM     94  CB  SER A  13      95.779 106.317  70.189  1.00100.00           C  
ATOM     95  OG  SER A  13      96.115 107.420  69.355  1.00100.00           O  
ATOM     96  N   SER A  14      99.063 106.157  70.766  1.00100.00           N  
ATOM     97  CA  SER A  14     100.202 106.497  71.627  1.00100.00           C  
ATOM     98  C   SER A  14      99.970 107.546  72.737  1.00100.00           C  
ATOM     99  O   SER A  14     100.126 107.243  73.928  1.00 99.19           O  
ATOM    100  CB  SER A  14     101.407 106.885  70.756  1.00100.00           C  
ATOM    101  OG  SER A  14     101.035 107.793  69.727  1.00100.00           O  
ATOM    102  N   ARG A  15      99.603 108.767  72.344  1.00100.00           N  
ATOM    103  CA  ARG A  15      99.369 109.863  73.294  1.00100.00           C  
ATOM    104  C   ARG A  15      97.942 109.975  73.863  1.00100.00           C  
ATOM    105  O   ARG A  15      97.618 110.951  74.554  1.00100.00           O  
ATOM    106  CB  ARG A  15      99.826 111.200  72.682  1.00100.00           C  
ATOM    107  CG  ARG A  15     101.348 111.398  72.685  1.00100.00           C  
ATOM    108  CD  ARG A  15     101.800 112.462  71.685  1.00100.00           C  
ATOM    109  NE  ARG A  15     101.169 113.760  71.921  1.00100.00           N  
ATOM    110  CZ  ARG A  15     100.496 114.449  71.000  1.00100.00           C  
ATOM    111  NH1 ARG A  15     100.357 113.970  69.767  1.00 99.78           N  
ATOM    112  NH2 ARG A  15      99.948 115.616  71.318  1.00 99.48           N  
ATOM    113  N   LEU A  16      97.105 108.971  73.578  1.00100.00           N  
ATOM    114  CA  LEU A  16      95.717 108.895  74.063  1.00100.00           C  
ATOM    115  C   LEU A  16      95.165 107.463  73.955  1.00 99.84           C  
ATOM    116  O   LEU A  16      94.317 107.185  73.096  1.00100.00           O  
ATOM    117  CB  LEU A  16      94.791 109.860  73.295  1.00100.00           C  
ATOM    118  CG  LEU A  16      94.734 111.357  73.645  1.00100.00           C  
ATOM    119  CD1 LEU A  16      93.716 112.061  72.749  1.00100.00           C  
ATOM    120  CD2 LEU A  16      94.368 111.563  75.115  1.00100.00           C  
ATOM    121  N   PRO A  17      95.641 106.535  74.824  1.00 99.00           N  
ATOM    122  CA  PRO A  17      95.181 105.135  74.808  1.00 96.90           C  
ATOM    123  C   PRO A  17      93.675 104.990  75.093  1.00 93.11           C  
ATOM    124  O   PRO A  17      93.176 105.435  76.135  1.00 93.26           O  
ATOM    125  CB  PRO A  17      96.058 104.466  75.879  1.00 97.98           C  
ATOM    126  CG  PRO A  17      96.383 105.592  76.821  1.00 99.08           C  
ATOM    127  CD  PRO A  17      96.661 106.738  75.872  1.00 99.35           C  
ATOM    128  N   GLY A  18      92.961 104.388  74.141  1.00 88.18           N  
ATOM    129  CA  GLY A  18      91.521 104.211  74.270  1.00 80.98           C  
ATOM    130  C   GLY A  18      90.789 105.490  73.916  1.00 74.73           C  
ATOM    131  O   GLY A  18      89.741 105.804  74.480  1.00 73.69           O  
ATOM    132  N   LYS A  19      91.335 106.198  72.934  1.00 68.65           N  
ATOM    133  CA  LYS A  19      90.805 107.468  72.474  1.00 62.95           C  
ATOM    134  C   LYS A  19      89.298 107.532  72.169  1.00 58.34           C  
ATOM    135  O   LYS A  19      88.619 108.451  72.634  1.00 58.82           O  
ATOM    136  CB  LYS A  19      91.633 107.952  71.279  1.00 65.39           C  
ATOM    137  CG  LYS A  19      91.524 109.436  71.001  1.00 68.14           C  
ATOM    138  CD  LYS A  19      92.563 109.898  69.984  1.00 70.22           C  
ATOM    139  CE  LYS A  19      92.348 109.272  68.618  1.00 72.33           C  
ATOM    140  NZ  LYS A  19      93.317 109.826  67.630  1.00 73.77           N  
ATOM    141  N   PRO A  20      88.742 106.559  71.413  1.00 53.40           N  
ATOM    142  CA  PRO A  20      87.298 106.643  71.130  1.00 48.98           C  
ATOM    143  C   PRO A  20      86.396 106.473  72.355  1.00 45.74           C  
ATOM    144  O   PRO A  20      85.226 106.840  72.328  1.00 40.81           O  
ATOM    145  CB  PRO A  20      87.084 105.526  70.104  1.00 48.03           C  
ATOM    146  CG  PRO A  20      88.132 104.516  70.475  1.00 48.43           C  
ATOM    147  CD  PRO A  20      89.339 105.384  70.747  1.00 51.13           C  
ATOM    148  N   LEU A  21      86.963 105.954  73.441  1.00 45.61           N  
ATOM    149  CA  LEU A  21      86.196 105.727  74.661  1.00 47.07           C  
ATOM    150  C   LEU A  21      86.321 106.851  75.711  1.00 47.65           C  
ATOM    151  O   LEU A  21      85.750 106.756  76.805  1.00 46.78           O  
ATOM    152  CB  LEU A  21      86.562 104.356  75.262  1.00 46.67           C  
ATOM    153  CG  LEU A  21      86.571 103.154  74.301  1.00 45.98           C  
ATOM    154  CD1 LEU A  21      86.977 101.889  75.022  1.00 45.33           C  
ATOM    155  CD2 LEU A  21      85.216 102.970  73.674  1.00 45.83           C  
ATOM    156  N   LEU A  22      87.052 107.915  75.375  1.00 47.03           N  
ATOM    157  CA  LEU A  22      87.221 109.044  76.295  1.00 47.40           C  
ATOM    158  C   LEU A  22      85.885 109.717  76.551  1.00 45.77           C  
ATOM    159  O   LEU A  22      85.060 109.818  75.652  1.00 44.65           O  
ATOM    160  CB  LEU A  22      88.187 110.082  75.725  1.00 50.13           C  
ATOM    161  CG  LEU A  22      89.692 109.843  75.770  1.00 52.13           C  
ATOM    162  CD1 LEU A  22      90.359 110.952  74.974  1.00 55.16           C  
ATOM    163  CD2 LEU A  22      90.203 109.821  77.204  1.00 53.30           C  
ATOM    164  N   ASP A  23      85.696 110.223  77.765  1.00 46.53           N  
ATOM    165  CA  ASP A  23      84.444 110.875  78.114  1.00 46.27           C  
ATOM    166  C   ASP A  23      84.372 112.357  77.775  1.00 44.26           C  
ATOM    167  O   ASP A  23      85.278 113.126  78.056  1.00 45.78           O  
ATOM    168  CB  ASP A  23      84.127 110.688  79.602  1.00 50.28           C  
ATOM    169  CG  ASP A  23      82.713 111.136  79.953  1.00 53.34           C  
ATOM    170  OD1 ASP A  23      82.475 112.358  80.128  1.00 53.63           O  
ATOM    171  OD2 ASP A  23      81.834 110.251  80.033  1.00 57.60           O  
ATOM    172  N   ILE A  24      83.263 112.742  77.169  1.00 42.04           N  
ATOM    173  CA  ILE A  24      83.000 114.127  76.819  1.00 42.74           C  
ATOM    174  C   ILE A  24      81.537 114.304  77.241  1.00 42.74           C  
ATOM    175  O   ILE A  24      80.642 113.678  76.672  1.00 41.27           O  
ATOM    176  CB  ILE A  24      83.167 114.399  75.285  1.00 41.06           C  
ATOM    177  CG1 ILE A  24      84.590 114.062  74.823  1.00 38.61           C  
ATOM    178  CG2 ILE A  24      82.829 115.862  74.961  1.00 40.02           C  
ATOM    179  CD1 ILE A  24      84.786 114.171  73.319  1.00 37.93           C  
ATOM    180  N   VAL A  25      81.312 115.127  78.264  1.00 43.26           N  
ATOM    181  CA  VAL A  25      79.968 115.385  78.800  1.00 43.41           C  
ATOM    182  C   VAL A  25      79.115 114.123  79.044  1.00 42.00           C  
ATOM    183  O   VAL A  25      77.953 114.045  78.627  1.00 40.52           O  
ATOM    184  CB  VAL A  25      79.156 116.480  77.983  1.00 46.58           C  
ATOM    185  CG1 VAL A  25      79.842 117.833  78.072  1.00 47.05           C  
ATOM    186  CG2 VAL A  25      78.958 116.085  76.515  1.00 48.92           C  
ATOM    187  N   GLY A  26      79.725 113.125  79.688  1.00 38.63           N  
ATOM    188  CA  GLY A  26      79.008 111.903  80.014  1.00 38.62           C  
ATOM    189  C   GLY A  26      78.848 110.801  78.968  1.00 39.80           C  
ATOM    190  O   GLY A  26      78.174 109.809  79.260  1.00 40.56           O  
ATOM    191  N   LYS A  27      79.428 110.963  77.769  1.00 37.16           N  
ATOM    192  CA  LYS A  27      79.349 109.954  76.691  1.00 33.69           C  
ATOM    193  C   LYS A  27      80.732 109.676  76.116  1.00 32.46           C  
ATOM    194  O   LYS A  27      81.577 110.564  76.088  1.00 33.89           O  
ATOM    195  CB  LYS A  27      78.485 110.454  75.528  1.00 29.87           C  
ATOM    196  CG  LYS A  27      77.029 110.597  75.817  1.00 28.44           C  
ATOM    197  CD  LYS A  27      76.374 111.295  74.666  1.00 26.46           C  
ATOM    198  CE  LYS A  27      74.916 111.504  74.960  1.00 29.36           C  
ATOM    199  NZ  LYS A  27      74.238 112.313  73.908  1.00 29.82           N  
ATOM    200  N   PRO A  28      80.988 108.442  75.653  1.00 30.91           N  
ATOM    201  CA  PRO A  28      82.311 108.157  75.079  1.00 28.59           C  
ATOM    202  C   PRO A  28      82.424 108.992  73.797  1.00 30.13           C  
ATOM    203  O   PRO A  28      81.405 109.294  73.149  1.00 26.81           O  
ATOM    204  CB  PRO A  28      82.221 106.675  74.724  1.00 31.21           C  
ATOM    205  CG  PRO A  28      81.168 106.154  75.663  1.00 31.21           C  
ATOM    206  CD  PRO A  28      80.145 107.238  75.650  1.00 30.07           C  
ATOM    207  N   MET A  29      83.646 109.357  73.414  1.00 29.09           N  
ATOM    208  CA  MET A  29      83.821 110.161  72.213  1.00 28.41           C  
ATOM    209  C   MET A  29      83.174 109.531  70.981  1.00 24.89           C  
ATOM    210  O   MET A  29      82.487 110.226  70.209  1.00 24.69           O  
ATOM    211  CB  MET A  29      85.298 110.450  71.951  1.00 30.20           C  
ATOM    212  CG  MET A  29      85.517 111.260  70.676  1.00 34.05           C  
ATOM    213  SD  MET A  29      87.171 111.911  70.550  1.00 41.38           S  
ATOM    214  CE  MET A  29      88.116 110.369  70.414  1.00 41.86           C  
ATOM    215  N   ILE A  30      83.359 108.217  70.829  1.00 22.49           N  
ATOM    216  CA  ILE A  30      82.790 107.477  69.697  1.00 23.07           C  
ATOM    217  C   ILE A  30      81.246 107.629  69.623  1.00 21.28           C  
ATOM    218  O   ILE A  30      80.670 107.694  68.520  1.00 22.63           O  
ATOM    219  CB  ILE A  30      83.258 105.984  69.715  1.00 22.51           C  
ATOM    220  CG1 ILE A  30      83.002 105.309  68.367  1.00 28.02           C  
ATOM    221  CG2 ILE A  30      82.572 105.217  70.808  1.00 26.34           C  
ATOM    222  CD1 ILE A  30      83.769 105.929  67.215  1.00 31.38           C  
ATOM    223  N   GLN A  31      80.591 107.796  70.777  1.00 18.27           N  
ATOM    224  CA  GLN A  31      79.139 107.971  70.777  1.00 19.41           C  
ATOM    225  C   GLN A  31      78.707 109.329  70.190  1.00 17.89           C  
ATOM    226  O   GLN A  31      77.716 109.404  69.446  1.00 19.80           O  
ATOM    227  CB  GLN A  31      78.554 107.776  72.175  1.00 19.22           C  
ATOM    228  CG  GLN A  31      77.010 107.899  72.190  1.00 20.80           C  
ATOM    229  CD  GLN A  31      76.400 107.517  73.532  1.00 21.37           C  
ATOM    230  OE1 GLN A  31      77.040 106.858  74.346  1.00 21.27           O  
ATOM    231  NE2 GLN A  31      75.176 107.945  73.769  1.00 18.28           N  
ATOM    232  N   HIS A  32      79.464 110.387  70.496  1.00 18.81           N  
ATOM    233  CA  HIS A  32      79.164 111.727  69.979  1.00 18.57           C  
ATOM    234  C   HIS A  32      79.245 111.746  68.458  1.00 19.26           C  
ATOM    235  O   HIS A  32      78.398 112.354  67.783  1.00 19.78           O  
ATOM    236  CB  HIS A  32      80.151 112.759  70.540  1.00 22.11           C  
ATOM    237  CG  HIS A  32      79.925 113.088  71.977  1.00 21.92           C  
ATOM    238  ND1 HIS A  32      78.898 113.908  72.399  1.00 22.63           N  
ATOM    239  CD2 HIS A  32      80.583 112.698  73.095  1.00 19.62           C  
ATOM    240  CE1 HIS A  32      78.936 114.009  73.717  1.00 21.90           C  
ATOM    241  NE2 HIS A  32      79.949 113.286  74.161  1.00 21.13           N  
ATOM    242  N   VAL A  33      80.266 111.072  67.920  1.00 17.46           N  
ATOM    243  CA  VAL A  33      80.434 111.008  66.472  1.00 18.97           C  
ATOM    244  C   VAL A  33      79.288 110.221  65.851  1.00 18.13           C  
ATOM    245  O   VAL A  33      78.712 110.625  64.831  1.00 20.16           O  
ATOM    246  CB  VAL A  33      81.788 110.361  66.074  1.00 17.75           C  
ATOM    247  CG1 VAL A  33      81.901 110.279  64.539  1.00 14.77           C  
ATOM    248  CG2 VAL A  33      82.941 111.184  66.644  1.00 17.63           C  
ATOM    249  N   TYR A  34      78.951 109.101  66.491  1.00 20.21           N  
ATOM    250  CA  TYR A  34      77.864 108.251  66.023  1.00 20.09           C  
ATOM    251  C   TYR A  34      76.557 109.032  66.021  1.00 16.89           C  
ATOM    252  O   TYR A  34      75.828 109.021  65.029  1.00 19.43           O  
ATOM    253  CB  TYR A  34      77.742 106.989  66.908  1.00 22.47           C  
ATOM    254  CG  TYR A  34      76.936 105.864  66.265  1.00 24.20           C  
ATOM    255  CD1 TYR A  34      75.539 105.853  66.316  1.00 25.58           C  
ATOM    256  CD2 TYR A  34      77.572 104.843  65.563  1.00 24.06           C  
ATOM    257  CE1 TYR A  34      74.797 104.855  65.671  1.00 24.82           C  
ATOM    258  CE2 TYR A  34      76.840 103.842  64.920  1.00 25.47           C  
ATOM    259  CZ  TYR A  34      75.459 103.858  64.976  1.00 26.65           C  
ATOM    260  OH  TYR A  34      74.763 102.882  64.303  1.00 31.14           O  
ATOM    261  N   GLU A  35      76.277 109.723  67.127  1.00 18.34           N  
ATOM    262  CA  GLU A  35      75.050 110.509  67.239  1.00 19.30           C  
ATOM    263  C   GLU A  35      74.960 111.612  66.189  1.00 22.06           C  
ATOM    264  O   GLU A  35      73.889 111.839  65.631  1.00 20.38           O  
ATOM    265  CB  GLU A  35      74.894 111.081  68.642  1.00 21.70           C  
ATOM    266  CG  GLU A  35      74.751 110.009  69.715  1.00 26.88           C  
ATOM    267  CD  GLU A  35      74.422 110.578  71.084  1.00 30.67           C  
ATOM    268  OE1 GLU A  35      74.134 111.787  71.182  1.00 34.21           O  
ATOM    269  OE2 GLU A  35      74.436 109.814  72.066  1.00 29.63           O  
ATOM    270  N   ARG A  36      76.071 112.291  65.894  1.00 22.15           N  
ATOM    271  CA  ARG A  36      76.037 113.325  64.846  1.00 20.09           C  
ATOM    272  C   ARG A  36      75.864 112.710  63.463  1.00 17.53           C  
ATOM    273  O   ARG A  36      75.141 113.245  62.633  1.00 16.04           O  
ATOM    274  CB  ARG A  36      77.274 114.214  64.903  1.00 23.39           C  
ATOM    275  CG  ARG A  36      77.113 115.300  65.929  1.00 28.81           C  
ATOM    276  CD  ARG A  36      78.387 115.573  66.634  1.00 34.12           C  
ATOM    277  NE  ARG A  36      78.170 116.456  67.774  1.00 41.35           N  
ATOM    278  CZ  ARG A  36      78.230 117.786  67.733  1.00 43.57           C  
ATOM    279  NH1 ARG A  36      78.505 118.427  66.601  1.00 44.50           N  
ATOM    280  NH2 ARG A  36      78.037 118.476  68.848  1.00 45.66           N  
ATOM    281  N   ALA A  37      76.481 111.548  63.241  1.00 16.96           N  
ATOM    282  CA  ALA A  37      76.368 110.841  61.961  1.00 15.29           C  
ATOM    283  C   ALA A  37      74.910 110.467  61.670  1.00 16.88           C  
ATOM    284  O   ALA A  37      74.462 110.525  60.515  1.00 16.60           O  
ATOM    285  CB  ALA A  37      77.253 109.593  61.976  1.00 15.00           C  
ATOM    286  N   LEU A  38      74.160 110.127  62.724  1.00 17.87           N  
ATOM    287  CA  LEU A  38      72.752 109.764  62.567  1.00 20.45           C  
ATOM    288  C   LEU A  38      71.890 110.916  62.089  1.00 23.06           C  
ATOM    289  O   LEU A  38      70.830 110.686  61.513  1.00 26.27           O  
ATOM    290  CB  LEU A  38      72.173 109.221  63.875  1.00 18.70           C  
ATOM    291  CG  LEU A  38      72.588 107.801  64.200  1.00 18.83           C  
ATOM    292  CD1 LEU A  38      72.144 107.444  65.602  1.00 22.84           C  
ATOM    293  CD2 LEU A  38      71.988 106.879  63.173  1.00 17.90           C  
ATOM    294  N   GLN A  39      72.351 112.148  62.327  1.00 24.61           N  
ATOM    295  CA  GLN A  39      71.626 113.348  61.934  1.00 23.74           C  
ATOM    296  C   GLN A  39      71.827 113.740  60.476  1.00 23.65           C  
ATOM    297  O   GLN A  39      71.236 114.709  60.014  1.00 24.50           O  
ATOM    298  CB  GLN A  39      72.023 114.515  62.834  1.00 26.20           C  
ATOM    299  CG  GLN A  39      71.786 114.270  64.323  1.00 35.16           C  
ATOM    300  CD  GLN A  39      72.316 115.406  65.204  1.00 41.81           C  
ATOM    301  OE1 GLN A  39      72.352 116.560  64.779  1.00 45.85           O  
ATOM    302  NE2 GLN A  39      72.736 115.079  66.430  1.00 42.19           N  
ATOM    303  N   VAL A  40      72.659 112.997  59.749  1.00 22.39           N  
ATOM    304  CA  VAL A  40      72.925 113.309  58.345  1.00 19.82           C  
ATOM    305  C   VAL A  40      71.831 112.742  57.466  1.00 21.72           C  
ATOM    306  O   VAL A  40      71.638 111.532  57.406  1.00 22.12           O  
ATOM    307  CB  VAL A  40      74.303 112.754  57.867  1.00 19.32           C  
ATOM    308  CG1 VAL A  40      74.559 113.137  56.424  1.00 13.91           C  
ATOM    309  CG2 VAL A  40      75.422 113.266  58.760  1.00 14.33           C  
ATOM    310  N   ALA A  41      71.114 113.622  56.783  1.00 21.85           N  
ATOM    311  CA  ALA A  41      70.041 113.194  55.899  1.00 24.37           C  
ATOM    312  C   ALA A  41      70.598 112.466  54.688  1.00 26.48           C  
ATOM    313  O   ALA A  41      71.711 112.753  54.252  1.00 28.53           O  
ATOM    314  CB  ALA A  41      69.232 114.402  55.444  1.00 23.60           C  
ATOM    315  N   GLY A  42      69.820 111.527  54.150  1.00 25.67           N  
ATOM    316  CA  GLY A  42      70.230 110.787  52.964  1.00 24.52           C  
ATOM    317  C   GLY A  42      71.135 109.591  53.189  1.00 22.44           C  
ATOM    318  O   GLY A  42      71.533 108.924  52.236  1.00 25.68           O  
ATOM    319  N   VAL A  43      71.452 109.328  54.449  1.00 21.83           N  
ATOM    320  CA  VAL A  43      72.303 108.208  54.824  1.00 23.31           C  
ATOM    321  C   VAL A  43      71.443 107.054  55.349  1.00 25.00           C  
ATOM    322  O   VAL A  43      70.628 107.230  56.260  1.00 23.88           O  
ATOM    323  CB  VAL A  43      73.341 108.662  55.884  1.00 21.99           C  
ATOM    324  CG1 VAL A  43      74.142 107.467  56.434  1.00 16.55           C  
ATOM    325  CG2 VAL A  43      74.283 109.687  55.239  1.00 18.60           C  
ATOM    326  N   ALA A  44      71.651 105.874  54.774  1.00 24.57           N  
ATOM    327  CA  ALA A  44      70.895 104.672  55.138  1.00 25.04           C  
ATOM    328  C   ALA A  44      71.329 103.991  56.429  1.00 24.59           C  
ATOM    329  O   ALA A  44      70.493 103.574  57.222  1.00 25.40           O  
ATOM    330  CB  ALA A  44      70.935 103.680  53.997  1.00 22.76           C  
ATOM    331  N   GLU A  45      72.634 103.851  56.629  1.00 23.32           N  
ATOM    332  CA  GLU A  45      73.148 103.196  57.832  1.00 21.17           C  
ATOM    333  C   GLU A  45      74.435 103.850  58.284  1.00 21.12           C  
ATOM    334  O   GLU A  45      75.158 104.435  57.483  1.00 20.70           O  
ATOM    335  CB  GLU A  45      73.478 101.719  57.554  1.00 26.82           C  
ATOM    336  CG  GLU A  45      72.355 100.849  56.995  1.00 32.59           C  
ATOM    337  CD  GLU A  45      72.874  99.571  56.341  1.00 35.12           C  
ATOM    338  OE1 GLU A  45      73.893  99.021  56.813  1.00 36.28           O  
ATOM    339  OE2 GLU A  45      72.265  99.116  55.345  1.00 39.33           O  
ATOM    340  N   VAL A  46      74.750 103.676  59.556  1.00 16.54           N  
ATOM    341  CA  VAL A  46      75.964 104.206  60.132  1.00 16.62           C  
ATOM    342  C   VAL A  46      76.653 103.054  60.847  1.00 19.54           C  
ATOM    343  O   VAL A  46      76.045 102.364  61.672  1.00 22.36           O  
ATOM    344  CB  VAL A  46      75.686 105.368  61.119  1.00 17.64           C  
ATOM    345  CG1 VAL A  46      76.995 105.862  61.726  1.00 19.57           C  
ATOM    346  CG2 VAL A  46      74.992 106.516  60.394  1.00 16.41           C  
ATOM    347  N   TRP A  47      77.919 102.839  60.504  1.00 16.91           N  
ATOM    348  CA  TRP A  47      78.733 101.764  61.078  1.00 15.58           C  
ATOM    349  C   TRP A  47      80.043 102.222  61.693  1.00 18.05           C  
ATOM    350  O   TRP A  47      80.689 103.119  61.171  1.00 17.53           O  
ATOM    351  CB  TRP A  47      79.123 100.786  59.977  1.00 18.19           C  
ATOM    352  CG  TRP A  47      78.000 100.011  59.423  1.00 22.02           C  
ATOM    353  CD1 TRP A  47      77.123 100.397  58.440  1.00 21.72           C  
ATOM    354  CD2 TRP A  47      77.647  98.674  59.778  1.00 22.15           C  
ATOM    355  NE1 TRP A  47      76.253  99.369  58.158  1.00 21.73           N  
ATOM    356  CE2 TRP A  47      76.554  98.301  58.966  1.00 24.54           C  
ATOM    357  CE3 TRP A  47      78.162  97.750  60.702  1.00 24.26           C  
ATOM    358  CZ2 TRP A  47      75.958  97.037  59.051  1.00 24.25           C  
ATOM    359  CZ3 TRP A  47      77.573  96.501  60.786  1.00 25.41           C  
ATOM    360  CH2 TRP A  47      76.483  96.157  59.963  1.00 24.65           C  
ATOM    361  N   VAL A  48      80.482 101.531  62.739  1.00 16.17           N  
ATOM    362  CA  VAL A  48      81.765 101.802  63.381  1.00 17.18           C  
ATOM    363  C   VAL A  48      82.637 100.601  63.004  1.00 21.85           C  
ATOM    364  O   VAL A  48      82.241  99.446  63.217  1.00 20.52           O  
ATOM    365  CB  VAL A  48      81.658 101.888  64.920  1.00 15.57           C  
ATOM    366  CG1 VAL A  48      83.035 102.007  65.537  1.00 18.21           C  
ATOM    367  CG2 VAL A  48      80.802 103.069  65.332  1.00 17.21           C  
ATOM    368  N   ALA A  49      83.777 100.872  62.371  1.00 17.85           N  
ATOM    369  CA  ALA A  49      84.698  99.828  61.935  1.00 20.75           C  
ATOM    370  C   ALA A  49      85.835  99.807  62.944  1.00 24.00           C  
ATOM    371  O   ALA A  49      86.526 100.811  63.136  1.00 25.14           O  
ATOM    372  CB  ALA A  49      85.220 100.134  60.532  1.00 17.75           C  
ATOM    373  N   THR A  50      86.011  98.677  63.620  1.00 24.94           N  
ATOM    374  CA  THR A  50      87.045  98.591  64.628  1.00 25.36           C  
ATOM    375  C   THR A  50      87.799  97.285  64.584  1.00 29.00           C  
ATOM    376  O   THR A  50      87.381  96.336  63.919  1.00 29.25           O  
ATOM    377  CB  THR A  50      86.451  98.792  66.036  1.00 26.55           C  
ATOM    378  OG1 THR A  50      87.505  98.862  66.999  1.00 29.96           O  
ATOM    379  CG2 THR A  50      85.534  97.655  66.403  1.00 23.71           C  
ATOM    380  N   ASP A  51      88.947  97.273  65.254  1.00 32.84           N  
ATOM    381  CA  ASP A  51      89.795  96.086  65.340  1.00 39.92           C  
ATOM    382  C   ASP A  51      89.942  95.639  66.804  1.00 42.13           C  
ATOM    383  O   ASP A  51      90.665  94.680  67.097  1.00 42.84           O  
ATOM    384  CB  ASP A  51      91.181  96.339  64.704  1.00 42.14           C  
ATOM    385  CG  ASP A  51      91.954  97.498  65.354  1.00 45.36           C  
ATOM    386  OD1 ASP A  51      91.402  98.216  66.214  1.00 46.89           O  
ATOM    387  OD2 ASP A  51      93.137  97.695  64.987  1.00 49.53           O  
ATOM    388  N   ASP A  52      89.201  96.300  67.697  1.00 41.97           N  
ATOM    389  CA  ASP A  52      89.256  96.016  69.128  1.00 43.53           C  
ATOM    390  C   ASP A  52      87.882  95.694  69.735  1.00 43.37           C  
ATOM    391  O   ASP A  52      86.944  96.480  69.594  1.00 43.85           O  
ATOM    392  CB  ASP A  52      89.890  97.216  69.845  1.00 46.49           C  
ATOM    393  CG  ASP A  52      90.261  96.910  71.280  1.00 49.57           C  
ATOM    394  OD1 ASP A  52      89.384  97.061  72.147  1.00 48.78           O  
ATOM    395  OD2 ASP A  52      91.422  96.514  71.538  1.00 52.17           O  
ATOM    396  N   PRO A  53      87.763  94.551  70.451  1.00 43.51           N  
ATOM    397  CA  PRO A  53      86.510  94.112  71.088  1.00 42.24           C  
ATOM    398  C   PRO A  53      85.967  95.059  72.158  1.00 42.06           C  
ATOM    399  O   PRO A  53      84.762  95.081  72.417  1.00 42.17           O  
ATOM    400  CB  PRO A  53      86.873  92.740  71.672  1.00 42.61           C  
ATOM    401  CG  PRO A  53      88.347  92.854  71.925  1.00 43.67           C  
ATOM    402  CD  PRO A  53      88.836  93.567  70.689  1.00 43.45           C  
ATOM    403  N   ARG A  54      86.849  95.835  72.781  1.00 41.45           N  
ATOM    404  CA  ARG A  54      86.421  96.790  73.802  1.00 42.80           C  
ATOM    405  C   ARG A  54      85.586  97.899  73.148  1.00 41.23           C  
ATOM    406  O   ARG A  54      84.552  98.321  73.694  1.00 41.43           O  
ATOM    407  CB  ARG A  54      87.635  97.381  74.538  1.00 47.24           C  
ATOM    408  CG  ARG A  54      88.458  96.349  75.310  1.00 52.97           C  
ATOM    409  CD  ARG A  54      89.734  96.949  75.915  1.00 61.10           C  
ATOM    410  NE  ARG A  54      90.775  97.210  74.914  1.00 66.94           N  
ATOM    411  CZ  ARG A  54      92.040  97.536  75.191  1.00 69.68           C  
ATOM    412  NH1 ARG A  54      92.454  97.650  76.451  1.00 70.17           N  
ATOM    413  NH2 ARG A  54      92.895  97.754  74.198  1.00 70.36           N  
ATOM    414  N   VAL A  55      86.015  98.332  71.958  1.00 35.97           N  
ATOM    415  CA  VAL A  55      85.313  99.369  71.207  1.00 31.49           C  
ATOM    416  C   VAL A  55      84.011  98.797  70.645  1.00 31.70           C  
ATOM    417  O   VAL A  55      82.958  99.446  70.700  1.00 30.21           O  
ATOM    418  CB  VAL A  55      86.195  99.948  70.057  1.00 29.69           C  
ATOM    419  CG1 VAL A  55      85.388 100.894  69.171  1.00 26.57           C  
ATOM    420  CG2 VAL A  55      87.366 100.695  70.629  1.00 29.22           C  
ATOM    421  N   GLU A  56      84.081  97.575  70.118  1.00 30.12           N  
ATOM    422  CA  GLU A  56      82.905  96.921  69.565  1.00 32.12           C  
ATOM    423  C   GLU A  56      81.840  96.836  70.649  1.00 35.86           C  
ATOM    424  O   GLU A  56      80.670  97.132  70.403  1.00 33.56           O  
ATOM    425  CB  GLU A  56      83.252  95.519  69.106  1.00 35.09           C  
ATOM    426  CG  GLU A  56      82.041  94.713  68.678  1.00 37.22           C  
ATOM    427  CD  GLU A  56      82.374  93.251  68.490  1.00 40.37           C  
ATOM    428  OE1 GLU A  56      83.109  92.689  69.340  1.00 42.98           O  
ATOM    429  OE2 GLU A  56      81.911  92.674  67.486  1.00 41.37           O  
ATOM    430  N   GLN A  57      82.261  96.422  71.842  1.00 37.87           N  
ATOM    431  CA  GLN A  57      81.367  96.314  72.992  1.00 43.20           C  
ATOM    432  C   GLN A  57      80.780  97.668  73.375  1.00 39.30           C  
ATOM    433  O   GLN A  57      79.567  97.784  73.577  1.00 39.31           O  
ATOM    434  CB  GLN A  57      82.103  95.709  74.197  1.00 50.47           C  
ATOM    435  CG  GLN A  57      81.958  94.197  74.302  1.00 63.15           C  
ATOM    436  CD  GLN A  57      80.496  93.761  74.333  1.00 70.30           C  
ATOM    437  OE1 GLN A  57      79.811  93.912  75.354  1.00 73.46           O  
ATOM    438  NE2 GLN A  57      80.003  93.242  73.202  1.00 72.88           N  
ATOM    439  N   ALA A  58      81.645  98.679  73.486  1.00 35.22           N  
ATOM    440  CA  ALA A  58      81.213 100.031  73.847  1.00 33.72           C  
ATOM    441  C   ALA A  58      80.180 100.542  72.844  1.00 32.28           C  
ATOM    442  O   ALA A  58      79.199 101.184  73.217  1.00 32.66           O  
ATOM    443  CB  ALA A  58      82.402 100.969  73.905  1.00 34.61           C  
ATOM    444  N   VAL A  59      80.385 100.216  71.572  1.00 27.92           N  
ATOM    445  CA  VAL A  59      79.470 100.643  70.530  1.00 27.23           C  
ATOM    446  C   VAL A  59      78.108  99.944  70.654  1.00 29.84           C  
ATOM    447  O   VAL A  59      77.056 100.588  70.642  1.00 29.78           O  
ATOM    448  CB  VAL A  59      80.105 100.430  69.140  1.00 26.63           C  
ATOM    449  CG1 VAL A  59      79.077 100.692  68.047  1.00 22.14           C  
ATOM    450  CG2 VAL A  59      81.330 101.357  68.986  1.00 20.82           C  
ATOM    451  N   GLN A  60      78.128  98.626  70.799  1.00 33.62           N  
ATOM    452  CA  GLN A  60      76.892  97.862  70.944  1.00 38.12           C  
ATOM    453  C   GLN A  60      76.106  98.299  72.194  1.00 35.76           C  
ATOM    454  O   GLN A  60      74.872  98.407  72.160  1.00 34.49           O  
ATOM    455  CB  GLN A  60      77.207  96.362  70.970  1.00 41.73           C  
ATOM    456  CG  GLN A  60      77.496  95.818  69.582  1.00 50.38           C  
ATOM    457  CD  GLN A  60      78.075  94.418  69.592  1.00 56.19           C  
ATOM    458  OE1 GLN A  60      78.244  93.800  70.649  1.00 58.72           O  
ATOM    459  NE2 GLN A  60      78.405  93.914  68.405  1.00 58.87           N  
ATOM    460  N   ALA A  61      76.841  98.629  73.258  1.00 35.09           N  
ATOM    461  CA  ALA A  61      76.243  99.079  74.513  1.00 33.26           C  
ATOM    462  C   ALA A  61      75.321 100.291  74.312  1.00 32.33           C  
ATOM    463  O   ALA A  61      74.352 100.449  75.056  1.00 32.70           O  
ATOM    464  CB  ALA A  61      77.323  99.385  75.533  1.00 32.26           C  
ATOM    465  N   PHE A  62      75.634 101.181  73.362  1.00 25.05           N  
ATOM    466  CA  PHE A  62      74.721 102.297  73.125  1.00 23.43           C  
ATOM    467  C   PHE A  62      73.793 102.027  71.948  1.00 21.15           C  
ATOM    468  O   PHE A  62      73.019 102.892  71.540  1.00 22.07           O  
ATOM    469  CB  PHE A  62      75.417 103.674  73.044  1.00 24.16           C  
ATOM    470  CG  PHE A  62      76.393 103.830  71.911  1.00 21.87           C  
ATOM    471  CD1 PHE A  62      75.947 103.973  70.597  1.00 19.08           C  
ATOM    472  CD2 PHE A  62      77.765 103.905  72.174  1.00 19.92           C  
ATOM    473  CE1 PHE A  62      76.851 104.196  69.556  1.00 19.76           C  
ATOM    474  CE2 PHE A  62      78.680 104.127  71.141  1.00 19.20           C  
ATOM    475  CZ  PHE A  62      78.221 104.274  69.829  1.00 17.19           C  
ATOM    476  N   GLY A  63      73.849 100.795  71.436  1.00 22.40           N  
ATOM    477  CA  GLY A  63      72.987 100.392  70.335  1.00 24.56           C  
ATOM    478  C   GLY A  63      73.451 100.669  68.914  1.00 25.19           C  
ATOM    479  O   GLY A  63      72.662 100.567  67.967  1.00 26.26           O  
ATOM    480  N   GLY A  64      74.713 101.037  68.747  1.00 22.30           N  
ATOM    481  CA  GLY A  64      75.200 101.303  67.408  1.00 25.07           C  
ATOM    482  C   GLY A  64      75.703 100.044  66.714  1.00 26.12           C  
ATOM    483  O   GLY A  64      75.930  99.013  67.365  1.00 25.90           O  
ATOM    484  N   LYS A  65      75.873 100.119  65.394  1.00 24.53           N  
ATOM    485  CA  LYS A  65      76.376  98.982  64.621  1.00 22.41           C  
ATOM    486  C   LYS A  65      77.898  99.020  64.518  1.00 24.68           C  
ATOM    487  O   LYS A  65      78.487 100.049  64.170  1.00 22.32           O  
ATOM    488  CB  LYS A  65      75.779  98.981  63.220  1.00 24.49           C  
ATOM    489  CG  LYS A  65      74.267  99.024  63.180  1.00 30.28           C  
ATOM    490  CD  LYS A  65      73.783  99.067  61.741  1.00 34.57           C  
ATOM    491  CE  LYS A  65      72.273  99.069  61.668  1.00 41.14           C  
ATOM    492  NZ  LYS A  65      71.820  98.863  60.262  1.00 47.70           N  
ATOM    493  N   ALA A  66      78.533  97.907  64.872  1.00 23.79           N  
ATOM    494  CA  ALA A  66      79.984  97.778  64.807  1.00 24.10           C  
ATOM    495  C   ALA A  66      80.322  96.581  63.915  1.00 27.32           C  
ATOM    496  O   ALA A  66      79.521  95.651  63.775  1.00 26.74           O  
ATOM    497  CB  ALA A  66      80.573  97.577  66.211  1.00 23.70           C  
ATOM    498  N   ILE A  67      81.470  96.646  63.250  1.00 26.88           N  
ATOM    499  CA  ILE A  67      81.926  95.559  62.396  1.00 24.49           C  
ATOM    500  C   ILE A  67      83.410  95.413  62.678  1.00 27.11           C  
ATOM    501  O   ILE A  67      84.145  96.404  62.711  1.00 27.46           O  
ATOM    502  CB  ILE A  67      81.646  95.831  60.895  1.00 23.07           C  
ATOM    503  CG1 ILE A  67      82.244  94.716  60.033  1.00 23.09           C  
ATOM    504  CG2 ILE A  67      82.173  97.204  60.488  1.00 22.15           C  
ATOM    505  CD1 ILE A  67      81.751  94.714  58.628  1.00 25.91           C  
ATOM    506  N   MET A  68      83.814  94.197  63.034  1.00 26.28           N  
ATOM    507  CA  MET A  68      85.204  93.911  63.328  1.00 28.31           C  
ATOM    508  C   MET A  68      85.963  93.789  62.019  1.00 28.40           C  
ATOM    509  O   MET A  68      85.479  93.202  61.043  1.00 27.31           O  
ATOM    510  CB  MET A  68      85.331  92.623  64.134  1.00 32.60           C  
ATOM    511  CG  MET A  68      84.948  92.760  65.595  1.00 37.00           C  
ATOM    512  SD  MET A  68      86.180  93.637  66.577  1.00 46.79           S  
ATOM    513  CE  MET A  68      87.519  92.424  66.670  1.00 46.55           C  
ATOM    514  N   THR A  69      87.155  94.368  62.006  1.00 28.21           N  
ATOM    515  CA  THR A  69      87.999  94.361  60.822  1.00 29.16           C  
ATOM    516  C   THR A  69      89.375  93.876  61.247  1.00 30.05           C  
ATOM    517  O   THR A  69      89.623  93.701  62.431  1.00 28.09           O  
ATOM    518  CB  THR A  69      88.094  95.794  60.204  1.00 30.61           C  
ATOM    519  OG1 THR A  69      88.564  96.719  61.194  1.00 29.89           O  
ATOM    520  CG2 THR A  69      86.728  96.267  59.708  1.00 26.99           C  
ATOM    521  N   ARG A  70      90.253  93.609  60.289  1.00 34.71           N  
ATOM    522  CA  ARG A  70      91.599  93.155  60.619  1.00 41.06           C  
ATOM    523  C   ARG A  70      92.420  94.256  61.295  1.00 46.04           C  
ATOM    524  O   ARG A  70      92.180  95.448  61.077  1.00 45.67           O  
ATOM    525  CB  ARG A  70      92.319  92.657  59.368  1.00 39.67           C  
ATOM    526  CG  ARG A  70      91.687  91.411  58.788  1.00 45.49           C  
ATOM    527  CD  ARG A  70      92.584  90.766  57.759  1.00 50.52           C  
ATOM    528  NE  ARG A  70      92.804  91.645  56.618  1.00 58.14           N  
ATOM    529  CZ  ARG A  70      91.986  91.732  55.570  1.00 63.21           C  
ATOM    530  NH1 ARG A  70      90.883  90.990  55.512  1.00 66.23           N  
ATOM    531  NH2 ARG A  70      92.275  92.557  54.573  1.00 66.09           N  
ATOM    532  N   ASN A  71      93.346  93.855  62.164  1.00 52.56           N  
ATOM    533  CA  ASN A  71      94.212  94.808  62.860  1.00 59.47           C  
ATOM    534  C   ASN A  71      95.502  95.059  62.073  1.00 62.15           C  
ATOM    535  O   ASN A  71      96.229  96.017  62.358  1.00 64.42           O  
ATOM    536  CB  ASN A  71      94.526  94.331  64.290  1.00 63.30           C  
ATOM    537  CG  ASN A  71      94.990  92.876  64.343  1.00 66.94           C  
ATOM    538  OD1 ASN A  71      94.291  92.013  64.879  1.00 68.73           O  
ATOM    539  ND2 ASN A  71      96.174  92.602  63.797  1.00 67.98           N  
ATOM    540  N   ASP A  72      95.745  94.210  61.067  1.00 62.34           N  
ATOM    541  CA  ASP A  72      96.926  94.280  60.194  1.00 62.49           C  
ATOM    542  C   ASP A  72      96.826  95.316  59.057  1.00 61.47           C  
ATOM    543  O   ASP A  72      97.667  95.337  58.157  1.00 61.07           O  
ATOM    544  CB  ASP A  72      97.236  92.889  59.602  1.00 64.95           C  
ATOM    545  CG  ASP A  72      96.072  92.305  58.775  1.00 67.04           C  
ATOM    546  OD1 ASP A  72      95.545  92.981  57.866  1.00 68.44           O  
ATOM    547  OD2 ASP A  72      95.694  91.141  59.021  1.00 69.40           O  
ATOM    548  N   HIS A  73      95.777  96.137  59.081  1.00 59.90           N  
ATOM    549  CA  HIS A  73      95.558  97.171  58.066  1.00 58.88           C  
ATOM    550  C   HIS A  73      96.543  98.313  58.208  1.00 62.45           C  
ATOM    551  O   HIS A  73      96.544  99.016  59.228  1.00 62.27           O  
ATOM    552  CB  HIS A  73      94.150  97.755  58.179  1.00 51.61           C  
ATOM    553  CG  HIS A  73      93.093  96.910  57.553  1.00 44.76           C  
ATOM    554  ND1 HIS A  73      93.247  96.323  56.315  1.00 41.37           N  
ATOM    555  CD2 HIS A  73      91.860  96.560  57.988  1.00 38.45           C  
ATOM    556  CE1 HIS A  73      92.151  95.651  56.013  1.00 40.16           C  
ATOM    557  NE2 HIS A  73      91.296  95.780  57.011  1.00 38.88           N  
ATOM    558  N   GLU A  74      97.344  98.528  57.166  1.00 66.33           N  
ATOM    559  CA  GLU A  74      98.324  99.610  57.175  1.00 70.07           C  
ATOM    560  C   GLU A  74      97.637 100.981  57.097  1.00 68.34           C  
ATOM    561  O   GLU A  74      97.937 101.893  57.879  1.00 68.78           O  
ATOM    562  CB  GLU A  74      99.338  99.442  56.028  1.00 74.97           C  
ATOM    563  CG  GLU A  74      98.729  99.399  54.627  1.00 82.65           C  
ATOM    564  CD  GLU A  74      99.768  99.244  53.515  1.00 86.88           C  
ATOM    565  OE1 GLU A  74     100.525 100.210  53.257  1.00 88.12           O  
ATOM    566  OE2 GLU A  74      99.808  98.161  52.883  1.00 88.48           O  
ATOM    567  N   SER A  75      96.641 101.086  56.222  1.00 64.87           N  
ATOM    568  CA  SER A  75      95.938 102.346  56.037  1.00 59.83           C  
ATOM    569  C   SER A  75      94.450 102.334  56.356  1.00 55.75           C  
ATOM    570  O   SER A  75      93.770 101.322  56.191  1.00 55.99           O  
ATOM    571  CB  SER A  75      96.156 102.820  54.611  1.00 60.34           C  
ATOM    572  OG  SER A  75      95.621 101.912  53.664  1.00 56.61           O  
ATOM    573  N   GLY A  76      93.946 103.484  56.788  1.00 49.53           N  
ATOM    574  CA  GLY A  76      92.538 103.595  57.114  1.00 43.07           C  
ATOM    575  C   GLY A  76      91.629 103.369  55.914  1.00 38.52           C  
ATOM    576  O   GLY A  76      90.424 103.156  56.085  1.00 38.11           O  
ATOM    577  N   THR A  77      92.188 103.469  54.707  1.00 32.93           N  
ATOM    578  CA  THR A  77      91.415 103.255  53.487  1.00 28.68           C  
ATOM    579  C   THR A  77      91.320 101.764  53.241  1.00 25.43           C  
ATOM    580  O   THR A  77      90.309 101.295  52.721  1.00 22.64           O  
ATOM    581  CB  THR A  77      92.005 103.998  52.264  1.00 27.46           C  
ATOM    582  OG1 THR A  77      92.014 105.395  52.549  1.00 29.34           O  
ATOM    583  CG2 THR A  77      91.150 103.795  51.020  1.00 23.81           C  
ATOM    584  N   ASP A  78      92.361 101.019  53.626  1.00 24.11           N  
ATOM    585  CA  ASP A  78      92.340  99.561  53.485  1.00 27.19           C  
ATOM    586  C   ASP A  78      91.242  99.001  54.391  1.00 26.07           C  
ATOM    587  O   ASP A  78      90.585  98.024  54.031  1.00 26.42           O  
ATOM    588  CB  ASP A  78      93.667  98.922  53.894  1.00 31.92           C  
ATOM    589  CG  ASP A  78      94.773  99.130  52.871  1.00 36.21           C  
ATOM    590  OD1 ASP A  78      94.520  99.066  51.647  1.00 35.14           O  
ATOM    591  OD2 ASP A  78      95.916  99.332  53.315  1.00 39.69           O  
ATOM    592  N   ARG A  79      91.068  99.600  55.572  1.00 25.28           N  
ATOM    593  CA  ARG A  79      90.037  99.167  56.514  1.00 22.03           C  
ATOM    594  C   ARG A  79      88.642  99.362  55.911  1.00 20.65           C  
ATOM    595  O   ARG A  79      87.761  98.519  56.084  1.00 18.75           O  
ATOM    596  CB  ARG A  79      90.172  99.919  57.831  1.00 26.50           C  
ATOM    597  CG  ARG A  79      89.033  99.682  58.821  1.00 33.90           C  
ATOM    598  CD  ARG A  79      89.345 100.284  60.214  1.00 40.89           C  
ATOM    599  NE  ARG A  79      90.038  99.332  61.089  1.00 48.60           N  
ATOM    600  CZ  ARG A  79      91.357  99.152  61.139  1.00 52.05           C  
ATOM    601  NH1 ARG A  79      92.174  99.872  60.379  1.00 55.72           N  
ATOM    602  NH2 ARG A  79      91.858  98.175  61.879  1.00 54.92           N  
ATOM    603  N   LEU A  80      88.454 100.456  55.173  1.00 18.41           N  
ATOM    604  CA  LEU A  80      87.174 100.742  54.513  1.00 17.44           C  
ATOM    605  C   LEU A  80      86.911  99.745  53.364  1.00 17.71           C  
ATOM    606  O   LEU A  80      85.758  99.438  53.070  1.00 16.91           O  
ATOM    607  CB  LEU A  80      87.146 102.194  53.989  1.00 15.97           C  
ATOM    608  CG  LEU A  80      85.872 102.771  53.364  1.00 20.36           C  
ATOM    609  CD1 LEU A  80      84.750 102.798  54.372  1.00 18.38           C  
ATOM    610  CD2 LEU A  80      86.143 104.178  52.884  1.00 21.12           C  
ATOM    611  N   VAL A  81      87.968  99.263  52.704  1.00 15.01           N  
ATOM    612  CA  VAL A  81      87.830  98.291  51.607  1.00 16.25           C  
ATOM    613  C   VAL A  81      87.268  96.966  52.165  1.00 17.40           C  
ATOM    614  O   VAL A  81      86.375  96.346  51.568  1.00 15.81           O  
ATOM    615  CB  VAL A  81      89.194  98.065  50.866  1.00 17.49           C  
ATOM    616  CG1 VAL A  81      89.133  96.856  49.943  1.00 17.22           C  
ATOM    617  CG2 VAL A  81      89.539  99.303  50.032  1.00 18.52           C  
ATOM    618  N   GLU A  82      87.759  96.568  53.333  1.00 15.53           N  
ATOM    619  CA  GLU A  82      87.261  95.360  53.964  1.00 19.46           C  
ATOM    620  C   GLU A  82      85.778  95.530  54.323  1.00 19.92           C  
ATOM    621  O   GLU A  82      84.992  94.603  54.135  1.00 19.08           O  
ATOM    622  CB  GLU A  82      88.046  95.007  55.219  1.00 17.14           C  
ATOM    623  CG  GLU A  82      87.554  93.709  55.843  1.00 20.77           C  
ATOM    624  CD  GLU A  82      88.162  93.400  57.195  1.00 25.94           C  
ATOM    625  OE1 GLU A  82      89.038  94.159  57.668  1.00 28.37           O  
ATOM    626  OE2 GLU A  82      87.761  92.378  57.800  1.00 30.33           O  
ATOM    627  N   VAL A  83      85.400  96.697  54.848  1.00 15.88           N  
ATOM    628  CA  VAL A  83      84.008  96.945  55.203  1.00 16.41           C  
ATOM    629  C   VAL A  83      83.124  96.922  53.958  1.00 17.13           C  
ATOM    630  O   VAL A  83      82.000  96.409  53.986  1.00 16.59           O  
ATOM    631  CB  VAL A  83      83.825  98.323  55.928  1.00 14.93           C  
ATOM    632  CG1 VAL A  83      82.331  98.647  56.091  1.00 13.06           C  
ATOM    633  CG2 VAL A  83      84.509  98.294  57.284  1.00 15.80           C  
ATOM    634  N   MET A  84      83.637  97.485  52.867  1.00 16.60           N  
ATOM    635  CA  MET A  84      82.908  97.571  51.604  1.00 16.00           C  
ATOM    636  C   MET A  84      82.415  96.216  51.071  1.00 15.79           C  
ATOM    637  O   MET A  84      81.326  96.127  50.517  1.00 13.74           O  
ATOM    638  CB  MET A  84      83.775  98.280  50.551  1.00 18.35           C  
ATOM    639  CG  MET A  84      83.184  98.363  49.143  1.00 17.44           C  
ATOM    640  SD  MET A  84      83.601  96.931  48.106  1.00 22.92           S  
ATOM    641  CE  MET A  84      85.434  96.973  48.139  1.00 19.65           C  
ATOM    642  N   HIS A  85      83.232  95.180  51.212  1.00 17.35           N  
ATOM    643  CA  HIS A  85      82.840  93.842  50.743  1.00 20.61           C  
ATOM    644  C   HIS A  85      81.641  93.259  51.484  1.00 20.69           C  
ATOM    645  O   HIS A  85      80.857  92.501  50.905  1.00 20.88           O  
ATOM    646  CB  HIS A  85      84.002  92.879  50.871  1.00 20.68           C  
ATOM    647  CG  HIS A  85      85.052  93.084  49.839  1.00 21.89           C  
ATOM    648  ND1 HIS A  85      84.793  92.995  48.488  1.00 25.14           N  
ATOM    649  CD2 HIS A  85      86.369  93.365  49.956  1.00 20.50           C  
ATOM    650  CE1 HIS A  85      85.910  93.213  47.818  1.00 24.09           C  
ATOM    651  NE2 HIS A  85      86.881  93.440  48.684  1.00 26.23           N  
ATOM    652  N   LYS A  86      81.516  93.633  52.756  1.00 20.32           N  
ATOM    653  CA  LYS A  86      80.443  93.183  53.635  1.00 23.70           C  
ATOM    654  C   LYS A  86      79.228  94.083  53.734  1.00 25.60           C  
ATOM    655  O   LYS A  86      78.126  93.585  53.914  1.00 25.25           O  
ATOM    656  CB  LYS A  86      80.987  92.906  55.031  1.00 24.22           C  
ATOM    657  CG  LYS A  86      81.884  91.702  55.043  1.00 28.01           C  
ATOM    658  CD  LYS A  86      82.412  91.393  56.415  1.00 32.25           C  
ATOM    659  CE  LYS A  86      83.183  90.088  56.381  1.00 33.43           C  
ATOM    660  NZ  LYS A  86      83.646  89.738  57.736  1.00 36.79           N  
ATOM    661  N   VAL A  87      79.423  95.400  53.656  1.00 23.75           N  
ATOM    662  CA  VAL A  87      78.313  96.354  53.735  1.00 19.63           C  
ATOM    663  C   VAL A  87      78.091  96.967  52.364  1.00 24.16           C  
ATOM    664  O   VAL A  87      78.927  97.735  51.875  1.00 19.80           O  
ATOM    665  CB  VAL A  87      78.606  97.474  54.752  1.00 20.81           C  
ATOM    666  CG1 VAL A  87      77.503  98.520  54.725  1.00 20.45           C  
ATOM    667  CG2 VAL A  87      78.772  96.897  56.143  1.00 19.12           C  
ATOM    668  N   GLU A  88      76.944  96.663  51.758  1.00 21.96           N  
ATOM    669  CA  GLU A  88      76.645  97.171  50.433  1.00 25.87           C  
ATOM    670  C   GLU A  88      76.158  98.628  50.400  1.00 22.78           C  
ATOM    671  O   GLU A  88      75.307  99.023  51.191  1.00 24.29           O  
ATOM    672  CB  GLU A  88      75.639  96.250  49.739  1.00 31.27           C  
ATOM    673  CG  GLU A  88      75.285  96.698  48.323  1.00 44.05           C  
ATOM    674  CD  GLU A  88      74.261  95.806  47.646  1.00 50.84           C  
ATOM    675  OE1 GLU A  88      73.511  95.089  48.354  1.00 53.87           O  
ATOM    676  OE2 GLU A  88      74.205  95.830  46.394  1.00 56.29           O  
ATOM    677  N   ALA A  89      76.700  99.410  49.465  1.00 19.88           N  
ATOM    678  CA  ALA A  89      76.334 100.812  49.292  1.00 15.62           C  
ATOM    679  C   ALA A  89      76.927 101.306  47.985  1.00 15.43           C  
ATOM    680  O   ALA A  89      77.796 100.672  47.415  1.00 15.23           O  
ATOM    681  CB  ALA A  89      76.856 101.653  50.457  1.00 13.91           C  
ATOM    682  N   ASP A  90      76.375 102.387  47.460  1.00 17.17           N  
ATOM    683  CA  ASP A  90      76.891 102.972  46.234  1.00 18.53           C  
ATOM    684  C   ASP A  90      77.943 104.025  46.626  1.00 19.03           C  
ATOM    685  O   ASP A  90      78.903 104.241  45.896  1.00 18.43           O  
ATOM    686  CB  ASP A  90      75.766 103.654  45.466  1.00 22.95           C  
ATOM    687  CG  ASP A  90      74.651 102.690  45.084  1.00 32.60           C  
ATOM    688  OD1 ASP A  90      74.970 101.622  44.526  1.00 36.94           O  
ATOM    689  OD2 ASP A  90      73.464 102.991  45.349  1.00 33.45           O  
ATOM    690  N   ILE A  91      77.739 104.663  47.783  1.00 17.32           N  
ATOM    691  CA  ILE A  91      78.632 105.717  48.291  1.00 15.88           C  
ATOM    692  C   ILE A  91      79.003 105.487  49.744  1.00 15.57           C  
ATOM    693  O   ILE A  91      78.125 105.321  50.589  1.00 16.91           O  
ATOM    694  CB  ILE A  91      77.945 107.107  48.198  1.00 16.31           C  
ATOM    695  CG1 ILE A  91      77.668 107.460  46.728  1.00 16.57           C  
ATOM    696  CG2 ILE A  91      78.805 108.178  48.888  1.00 15.92           C  
ATOM    697  CD1 ILE A  91      76.705 108.601  46.546  1.00 17.65           C  
ATOM    698  N   TYR A  92      80.301 105.476  50.039  1.00 11.95           N  
ATOM    699  CA  TYR A  92      80.785 105.273  51.401  1.00 10.10           C  
ATOM    700  C   TYR A  92      81.438 106.552  51.883  1.00 13.69           C  
ATOM    701  O   TYR A  92      82.312 107.099  51.207  1.00 14.71           O  
ATOM    702  CB  TYR A  92      81.837 104.167  51.451  1.00 11.03           C  
ATOM    703  CG  TYR A  92      81.327 102.808  51.029  1.00 12.64           C  
ATOM    704  CD1 TYR A  92      81.231 102.473  49.686  1.00 14.05           C  
ATOM    705  CD2 TYR A  92      80.921 101.865  51.985  1.00 15.49           C  
ATOM    706  CE1 TYR A  92      80.735 101.228  49.294  1.00 18.36           C  
ATOM    707  CE2 TYR A  92      80.424 100.617  51.608  1.00 14.91           C  
ATOM    708  CZ  TYR A  92      80.334 100.309  50.266  1.00 18.68           C  
ATOM    709  OH  TYR A  92      79.848  99.083  49.864  1.00 19.10           O  
ATOM    710  N   ILE A  93      81.026 107.019  53.050  1.00 11.70           N  
ATOM    711  CA  ILE A  93      81.581 108.234  53.641  1.00 12.82           C  
ATOM    712  C   ILE A  93      82.418 107.782  54.818  1.00 16.23           C  
ATOM    713  O   ILE A  93      81.956 107.026  55.680  1.00 17.00           O  
ATOM    714  CB  ILE A  93      80.469 109.185  54.113  1.00 12.74           C  
ATOM    715  CG1 ILE A  93      79.697 109.701  52.908  1.00 16.38           C  
ATOM    716  CG2 ILE A  93      81.057 110.357  54.926  1.00 15.85           C  
ATOM    717  CD1 ILE A  93      78.389 110.334  53.273  1.00 19.36           C  
ATOM    718  N   ASN A  94      83.669 108.215  54.843  1.00 12.08           N  
ATOM    719  CA  ASN A  94      84.574 107.839  55.911  1.00 14.52           C  
ATOM    720  C   ASN A  94      84.757 109.047  56.820  1.00 18.12           C  
ATOM    721  O   ASN A  94      85.293 110.062  56.388  1.00 20.40           O  
ATOM    722  CB  ASN A  94      85.911 107.431  55.300  1.00 20.35           C  
ATOM    723  CG  ASN A  94      86.712 106.512  56.192  1.00 31.76           C  
ATOM    724  OD1 ASN A  94      86.192 105.511  56.699  1.00 35.14           O  
ATOM    725  ND2 ASN A  94      88.002 106.816  56.353  1.00 34.56           N  
ATOM    726  N   LEU A  95      84.226 108.960  58.037  1.00 18.85           N  
ATOM    727  CA  LEU A  95      84.328 110.013  59.049  1.00 25.40           C  
ATOM    728  C   LEU A  95      85.373 109.625  60.066  1.00 29.12           C  
ATOM    729  O   LEU A  95      85.473 108.462  60.424  1.00 36.71           O  
ATOM    730  CB  LEU A  95      83.034 110.134  59.841  1.00 26.18           C  
ATOM    731  CG  LEU A  95      81.824 110.865  59.304  1.00 29.78           C  
ATOM    732  CD1 LEU A  95      80.874 111.089  60.479  1.00 33.02           C  
ATOM    733  CD2 LEU A  95      82.239 112.195  58.722  1.00 34.11           C  
ATOM    734  N   GLN A  96      86.078 110.598  60.623  1.00 32.63           N  
ATOM    735  CA  GLN A  96      87.078 110.290  61.644  1.00 35.25           C  
ATOM    736  C   GLN A  96      86.431 110.079  63.023  1.00 33.69           C  
ATOM    737  O   GLN A  96      85.576 110.856  63.443  1.00 34.68           O  
ATOM    738  CB  GLN A  96      88.150 111.382  61.680  1.00 41.88           C  
ATOM    739  CG  GLN A  96      88.972 111.444  60.386  1.00 51.08           C  
ATOM    740  CD  GLN A  96      89.351 110.048  59.876  1.00 57.62           C  
ATOM    741  OE1 GLN A  96      90.099 109.316  60.532  1.00 60.97           O  
ATOM    742  NE2 GLN A  96      88.799 109.663  58.720  1.00 59.60           N  
ATOM    743  N   GLY A  97      86.832 109.013  63.708  1.00 32.78           N  
ATOM    744  CA  GLY A  97      86.259 108.698  65.002  1.00 33.37           C  
ATOM    745  C   GLY A  97      86.714 109.594  66.132  1.00 38.70           C  
ATOM    746  O   GLY A  97      86.256 109.426  67.270  1.00 39.41           O  
ATOM    747  N   ASP A  98      87.590 110.552  65.822  1.00 38.99           N  
ATOM    748  CA  ASP A  98      88.124 111.476  66.832  1.00 40.66           C  
ATOM    749  C   ASP A  98      87.772 112.965  66.656  1.00 40.22           C  
ATOM    750  O   ASP A  98      88.411 113.840  67.250  1.00 40.37           O  
ATOM    751  CB  ASP A  98      89.648 111.283  67.015  1.00 43.00           C  
ATOM    752  CG  ASP A  98      90.454 111.580  65.743  1.00 48.04           C  
ATOM    753  OD1 ASP A  98      89.868 111.947  64.701  1.00 48.62           O  
ATOM    754  OD2 ASP A  98      91.694 111.445  65.790  1.00 51.64           O  
ATOM    755  N   GLU A  99      86.760 113.250  65.841  1.00 38.52           N  
ATOM    756  CA  GLU A  99      86.313 114.626  65.642  1.00 39.47           C  
ATOM    757  C   GLU A  99      84.841 114.672  66.064  1.00 37.71           C  
ATOM    758  O   GLU A  99      83.927 114.641  65.231  1.00 36.31           O  
ATOM    759  CB  GLU A  99      86.483 115.057  64.181  1.00 44.04           C  
ATOM    760  CG  GLU A  99      87.933 115.203  63.720  1.00 54.49           C  
ATOM    761  CD  GLU A  99      88.039 115.540  62.229  1.00 61.43           C  
ATOM    762  OE1 GLU A  99      87.407 116.530  61.794  1.00 64.07           O  
ATOM    763  OE2 GLU A  99      88.741 114.810  61.486  1.00 64.40           O  
ATOM    764  N   PRO A 100      84.593 114.758  67.381  1.00 36.54           N  
ATOM    765  CA  PRO A 100      83.229 114.802  67.934  1.00 36.01           C  
ATOM    766  C   PRO A 100      82.406 116.033  67.570  1.00 34.92           C  
ATOM    767  O   PRO A 100      81.187 116.037  67.715  1.00 32.22           O  
ATOM    768  CB  PRO A 100      83.483 114.745  69.444  1.00 34.97           C  
ATOM    769  CG  PRO A 100      84.756 115.536  69.586  1.00 34.62           C  
ATOM    770  CD  PRO A 100      85.596 114.971  68.444  1.00 35.19           C  
ATOM    771  N   MET A 101      83.069 117.084  67.105  1.00 36.72           N  
ATOM    772  CA  MET A 101      82.362 118.317  66.779  1.00 41.95           C  
ATOM    773  C   MET A 101      81.973 118.481  65.317  1.00 42.13           C  
ATOM    774  O   MET A 101      81.623 119.578  64.876  1.00 42.37           O  
ATOM    775  CB  MET A 101      83.140 119.530  67.290  1.00 48.12           C  
ATOM    776  CG  MET A 101      83.280 119.522  68.812  1.00 55.38           C  
ATOM    777  SD  MET A 101      83.550 121.147  69.492  1.00 61.35           S  
ATOM    778  CE  MET A 101      81.970 121.965  69.019  1.00 60.88           C  
ATOM    779  N   ILE A 102      82.004 117.369  64.586  1.00 38.41           N  
ATOM    780  CA  ILE A 102      81.637 117.323  63.180  1.00 35.02           C  
ATOM    781  C   ILE A 102      80.230 117.916  62.988  1.00 32.94           C  
ATOM    782  O   ILE A 102      79.338 117.669  63.795  1.00 32.94           O  
ATOM    783  CB  ILE A 102      81.675 115.833  62.677  1.00 38.80           C  
ATOM    784  CG1 ILE A 102      81.168 115.721  61.245  1.00 41.41           C  
ATOM    785  CG2 ILE A 102      80.808 114.928  63.549  1.00 36.40           C  
ATOM    786  CD1 ILE A 102      82.035 116.433  60.259  1.00 50.39           C  
ATOM    787  N   ARG A 103      80.052 118.758  61.972  1.00 29.65           N  
ATOM    788  CA  ARG A 103      78.740 119.336  61.688  1.00 28.63           C  
ATOM    789  C   ARG A 103      78.013 118.502  60.639  1.00 27.11           C  
ATOM    790  O   ARG A 103      78.497 118.357  59.526  1.00 24.65           O  
ATOM    791  CB  ARG A 103      78.853 120.763  61.144  1.00 30.34           C  
ATOM    792  CG  ARG A 103      79.311 121.814  62.141  1.00 34.90           C  
ATOM    793  CD  ARG A 103      79.251 123.206  61.496  1.00 38.11           C  
ATOM    794  NE  ARG A 103      80.187 123.313  60.374  1.00 42.32           N  
ATOM    795  CZ  ARG A 103      81.392 123.878  60.442  1.00 42.90           C  
ATOM    796  NH1 ARG A 103      81.831 124.419  61.578  1.00 42.05           N  
ATOM    797  NH2 ARG A 103      82.186 123.834  59.385  1.00 41.22           N  
ATOM    798  N   PRO A 104      76.833 117.953  60.980  1.00 28.00           N  
ATOM    799  CA  PRO A 104      76.048 117.139  60.046  1.00 24.90           C  
ATOM    800  C   PRO A 104      75.839 117.781  58.677  1.00 23.82           C  
ATOM    801  O   PRO A 104      75.836 117.084  57.652  1.00 19.55           O  
ATOM    802  CB  PRO A 104      74.721 116.977  60.787  1.00 26.37           C  
ATOM    803  CG  PRO A 104      75.173 116.843  62.208  1.00 26.68           C  
ATOM    804  CD  PRO A 104      76.231 117.927  62.330  1.00 25.78           C  
ATOM    805  N   ARG A 105      75.670 119.101  58.656  1.00 22.78           N  
ATOM    806  CA  ARG A 105      75.452 119.836  57.406  1.00 25.94           C  
ATOM    807  C   ARG A 105      76.643 119.741  56.449  1.00 21.14           C  
ATOM    808  O   ARG A 105      76.468 119.740  55.236  1.00 21.61           O  
ATOM    809  CB  ARG A 105      75.122 121.309  57.704  1.00 36.75           C  
ATOM    810  CG  ARG A 105      73.706 121.774  57.266  1.00 51.74           C  
ATOM    811  CD  ARG A 105      72.541 120.840  57.721  1.00 61.61           C  
ATOM    812  NE  ARG A 105      72.339 120.774  59.176  1.00 70.22           N  
ATOM    813  CZ  ARG A 105      71.829 119.723  59.826  1.00 72.24           C  
ATOM    814  NH1 ARG A 105      71.456 118.632  59.165  1.00 73.58           N  
ATOM    815  NH2 ARG A 105      71.721 119.746  61.149  1.00 72.14           N  
ATOM    816  N   ASP A 106      77.850 119.635  56.993  1.00 17.38           N  
ATOM    817  CA  ASP A 106      79.048 119.523  56.150  1.00 19.30           C  
ATOM    818  C   ASP A 106      79.095 118.178  55.437  1.00 18.96           C  
ATOM    819  O   ASP A 106      79.559 118.091  54.294  1.00 14.54           O  
ATOM    820  CB  ASP A 106      80.328 119.704  56.973  1.00 20.78           C  
ATOM    821  CG  ASP A 106      80.497 121.120  57.495  1.00 23.88           C  
ATOM    822  OD1 ASP A 106      79.782 122.039  57.033  1.00 22.33           O  
ATOM    823  OD2 ASP A 106      81.357 121.296  58.378  1.00 27.71           O  
ATOM    824  N   VAL A 107      78.662 117.121  56.125  1.00 17.22           N  
ATOM    825  CA  VAL A 107      78.648 115.796  55.507  1.00 17.08           C  
ATOM    826  C   VAL A 107      77.573 115.781  54.406  1.00 14.94           C  
ATOM    827  O   VAL A 107      77.758 115.175  53.344  1.00 17.21           O  
ATOM    828  CB  VAL A 107      78.401 114.675  56.554  1.00 18.14           C  
ATOM    829  CG1 VAL A 107      78.462 113.314  55.884  1.00 14.27           C  
ATOM    830  CG2 VAL A 107      79.426 114.765  57.670  1.00 18.15           C  
ATOM    831  N   GLU A 108      76.459 116.478  54.650  1.00 16.80           N  
ATOM    832  CA  GLU A 108      75.392 116.569  53.659  1.00 16.20           C  
ATOM    833  C   GLU A 108      75.874 117.272  52.390  1.00 19.77           C  
ATOM    834  O   GLU A 108      75.488 116.894  51.276  1.00 17.26           O  
ATOM    835  CB  GLU A 108      74.173 117.284  54.248  1.00 18.66           C  
ATOM    836  CG  GLU A 108      73.385 116.400  55.201  1.00 25.53           C  
ATOM    837  CD  GLU A 108      72.278 117.125  55.962  1.00 28.73           C  
ATOM    838  OE1 GLU A 108      71.902 118.258  55.586  1.00 30.02           O  
ATOM    839  OE2 GLU A 108      71.795 116.548  56.958  1.00 27.32           O  
ATOM    840  N   THR A 109      76.727 118.287  52.565  1.00 21.22           N  
ATOM    841  CA  THR A 109      77.308 119.044  51.443  1.00 22.35           C  
ATOM    842  C   THR A 109      78.136 118.082  50.603  1.00 19.07           C  
ATOM    843  O   THR A 109      78.044 118.063  49.381  1.00 21.64           O  
ATOM    844  CB  THR A 109      78.235 120.192  51.957  1.00 23.59           C  
ATOM    845  OG1 THR A 109      77.435 121.237  52.519  1.00 27.51           O  
ATOM    846  CG2 THR A 109      79.083 120.776  50.827  1.00 26.93           C  
ATOM    847  N   LEU A 110      78.903 117.247  51.287  1.00 21.33           N  
ATOM    848  CA  LEU A 110      79.754 116.265  50.642  1.00 19.77           C  
ATOM    849  C   LEU A 110      78.902 115.259  49.868  1.00 21.12           C  
ATOM    850  O   LEU A 110      79.125 115.032  48.678  1.00 19.29           O  
ATOM    851  CB  LEU A 110      80.586 115.579  51.720  1.00 21.63           C  
ATOM    852  CG  LEU A 110      81.700 114.615  51.366  1.00 23.52           C  
ATOM    853  CD1 LEU A 110      82.790 115.352  50.620  1.00 23.08           C  
ATOM    854  CD2 LEU A 110      82.243 114.036  52.660  1.00 21.60           C  
ATOM    855  N   LEU A 111      77.857 114.738  50.516  1.00 21.89           N  
ATOM    856  CA  LEU A 111      76.964 113.751  49.886  1.00 24.23           C  
ATOM    857  C   LEU A 111      76.229 114.335  48.686  1.00 26.28           C  
ATOM    858  O   LEU A 111      76.044 113.647  47.680  1.00 25.00           O  
ATOM    859  CB  LEU A 111      75.938 113.217  50.893  1.00 25.84           C  
ATOM    860  CG  LEU A 111      75.705 111.710  51.029  1.00 28.31           C  
ATOM    861  CD1 LEU A 111      74.387 111.511  51.733  1.00 29.37           C  
ATOM    862  CD2 LEU A 111      75.682 111.011  49.686  1.00 25.45           C  
ATOM    863  N   GLN A 112      75.790 115.589  48.807  1.00 27.62           N  
ATOM    864  CA  GLN A 112      75.096 116.266  47.716  1.00 30.81           C  
ATOM    865  C   GLN A 112      76.028 116.425  46.499  1.00 29.24           C  
ATOM    866  O   GLN A 112      75.599 116.289  45.347  1.00 26.84           O  
ATOM    867  CB  GLN A 112      74.574 117.639  48.172  1.00 39.15           C  
ATOM    868  CG  GLN A 112      73.569 118.275  47.193  1.00 50.83           C  
ATOM    869  CD  GLN A 112      72.482 117.285  46.753  1.00 58.06           C  
ATOM    870  OE1 GLN A 112      71.571 116.959  47.524  1.00 60.32           O  
ATOM    871  NE2 GLN A 112      72.599 116.776  45.524  1.00 59.64           N  
ATOM    872  N   GLY A 113      77.300 116.714  46.765  1.00 25.07           N  
ATOM    873  CA  GLY A 113      78.263 116.860  45.692  1.00 24.03           C  
ATOM    874  C   GLY A 113      78.391 115.570  44.896  1.00 24.43           C  
ATOM    875  O   GLY A 113      78.452 115.613  43.662  1.00 23.64           O  
ATOM    876  N   MET A 114      78.433 114.430  45.597  1.00 23.84           N  
ATOM    877  CA  MET A 114      78.555 113.105  44.966  1.00 24.23           C  
ATOM    878  C   MET A 114      77.309 112.774  44.140  1.00 26.12           C  
ATOM    879  O   MET A 114      77.406 112.225  43.039  1.00 27.75           O  
ATOM    880  CB  MET A 114      78.777 112.011  46.024  1.00 20.22           C  
ATOM    881  CG  MET A 114      80.111 112.084  46.743  1.00 20.17           C  
ATOM    882  SD  MET A 114      81.440 111.700  45.636  1.00 24.29           S  
ATOM    883  CE  MET A 114      81.439 109.939  45.693  1.00 17.83           C  
ATOM    884  N   ARG A 115      76.137 113.132  44.661  1.00 28.22           N  
ATOM    885  CA  ARG A 115      74.881 112.879  43.957  1.00 30.73           C  
ATOM    886  C   ARG A 115      74.678 113.786  42.752  1.00 33.38           C  
ATOM    887  O   ARG A 115      74.145 113.341  41.739  1.00 35.34           O  
ATOM    888  CB  ARG A 115      73.684 112.924  44.924  1.00 30.02           C  
ATOM    889  CG  ARG A 115      73.706 111.724  45.864  1.00 33.81           C  
ATOM    890  CD  ARG A 115      72.466 111.583  46.697  1.00 37.84           C  
ATOM    891  NE  ARG A 115      72.379 110.237  47.270  1.00 41.40           N  
ATOM    892  CZ  ARG A 115      72.062 109.973  48.537  1.00 44.06           C  
ATOM    893  NH1 ARG A 115      71.803 110.964  49.383  1.00 44.77           N  
ATOM    894  NH2 ARG A 115      71.995 108.715  48.963  1.00 44.42           N  
ATOM    895  N   ASP A 116      75.148 115.033  42.837  1.00 34.64           N  
ATOM    896  CA  ASP A 116      75.015 115.974  41.730  1.00 35.46           C  
ATOM    897  C   ASP A 116      75.909 115.668  40.528  1.00 36.06           C  
ATOM    898  O   ASP A 116      75.649 116.150  39.428  1.00 38.57           O  
ATOM    899  CB  ASP A 116      75.225 117.414  42.202  1.00 41.43           C  
ATOM    900  CG  ASP A 116      74.015 117.974  42.945  1.00 46.33           C  
ATOM    901  OD1 ASP A 116      72.932 117.337  42.924  1.00 49.96           O  
ATOM    902  OD2 ASP A 116      74.144 119.060  43.547  1.00 47.47           O  
ATOM    903  N   ASP A 117      76.968 114.891  40.740  1.00 32.94           N  
ATOM    904  CA  ASP A 117      77.872 114.504  39.662  1.00 30.45           C  
ATOM    905  C   ASP A 117      78.188 113.004  39.795  1.00 32.12           C  
ATOM    906  O   ASP A 117      79.062 112.596  40.571  1.00 29.30           O  
ATOM    907  CB  ASP A 117      79.155 115.350  39.690  1.00 29.96           C  
ATOM    908  CG  ASP A 117      80.087 115.050  38.520  1.00 31.09           C  
ATOM    909  OD1 ASP A 117      79.771 114.148  37.716  1.00 29.90           O  
ATOM    910  OD2 ASP A 117      81.148 115.711  38.400  1.00 31.38           O  
ATOM    911  N   PRO A 118      77.478 112.164  39.015  1.00 33.44           N  
ATOM    912  CA  PRO A 118      77.609 110.701  38.982  1.00 32.12           C  
ATOM    913  C   PRO A 118      78.989 110.194  38.559  1.00 29.43           C  
ATOM    914  O   PRO A 118      79.363 109.067  38.883  1.00 30.71           O  
ATOM    915  CB  PRO A 118      76.542 110.289  37.962  1.00 35.23           C  
ATOM    916  CG  PRO A 118      75.521 111.408  38.056  1.00 35.82           C  
ATOM    917  CD  PRO A 118      76.408 112.609  38.101  1.00 34.91           C  
ATOM    918  N   ALA A 119      79.730 111.017  37.821  1.00 27.45           N  
ATOM    919  CA  ALA A 119      81.068 110.658  37.351  1.00 25.03           C  
ATOM    920  C   ALA A 119      82.179 110.939  38.356  1.00 22.00           C  
ATOM    921  O   ALA A 119      83.317 110.557  38.110  1.00 23.92           O  
ATOM    922  CB  ALA A 119      81.377 111.379  36.061  1.00 23.86           C  
ATOM    923  N   LEU A 120      81.855 111.635  39.452  1.00 19.99           N  
ATOM    924  CA  LEU A 120      82.828 111.990  40.488  1.00 16.17           C  
ATOM    925  C   LEU A 120      83.200 110.774  41.331  1.00 15.63           C  
ATOM    926  O   LEU A 120      82.354 110.202  42.010  1.00 16.22           O  
ATOM    927  CB  LEU A 120      82.273 113.118  41.364  1.00 13.60           C  
ATOM    928  CG  LEU A 120      83.208 113.629  42.462  1.00 16.84           C  
ATOM    929  CD1 LEU A 120      84.551 114.137  41.872  1.00 12.67           C  
ATOM    930  CD2 LEU A 120      82.484 114.737  43.240  1.00 17.29           C  
ATOM    931  N   PRO A 121      84.488 110.391  41.337  1.00 15.08           N  
ATOM    932  CA  PRO A 121      84.877 109.220  42.123  1.00 14.41           C  
ATOM    933  C   PRO A 121      85.035 109.432  43.623  1.00 14.96           C  
ATOM    934  O   PRO A 121      84.648 108.568  44.417  1.00 15.01           O  
ATOM    935  CB  PRO A 121      86.221 108.804  41.497  1.00 13.24           C  
ATOM    936  CG  PRO A 121      86.366 109.684  40.244  1.00 15.21           C  
ATOM    937  CD  PRO A 121      85.633 110.925  40.581  1.00 14.35           C  
ATOM    938  N   VAL A 122      85.633 110.564  44.003  1.00 12.26           N  
ATOM    939  CA  VAL A 122      85.935 110.870  45.401  1.00 10.30           C  
ATOM    940  C   VAL A 122      85.718 112.350  45.681  1.00 14.40           C  
ATOM    941  O   VAL A 122      85.965 113.199  44.815  1.00 13.75           O  
ATOM    942  CB  VAL A 122      87.435 110.565  45.713  1.00 11.15           C  
ATOM    943  CG1 VAL A 122      87.750 110.774  47.196  1.00 10.44           C  
ATOM    944  CG2 VAL A 122      87.819 109.148  45.255  1.00 12.82           C  
ATOM    945  N   ALA A 123      85.229 112.647  46.880  1.00 14.13           N  
ATOM    946  CA  ALA A 123      85.008 114.028  47.308  1.00 13.10           C  
ATOM    947  C   ALA A 123      85.528 114.171  48.743  1.00 13.11           C  
ATOM    948  O   ALA A 123      85.580 113.197  49.497  1.00 13.81           O  
ATOM    949  CB  ALA A 123      83.538 114.402  47.221  1.00 12.55           C  
ATOM    950  N   THR A 124      85.971 115.375  49.099  1.00 10.12           N  
ATOM    951  CA  THR A 124      86.481 115.633  50.430  1.00  7.33           C  
ATOM    952  C   THR A 124      86.201 117.100  50.757  1.00  9.28           C  
ATOM    953  O   THR A 124      85.598 117.813  49.945  1.00  8.09           O  
ATOM    954  CB  THR A 124      87.985 115.273  50.560  1.00  7.12           C  
ATOM    955  OG1 THR A 124      88.369 115.340  51.936  1.00  9.05           O  
ATOM    956  CG2 THR A 124      88.873 116.242  49.714  1.00  9.98           C  
ATOM    957  N   LEU A 125      86.598 117.524  51.952  1.00  8.81           N  
ATOM    958  CA  LEU A 125      86.332 118.887  52.410  1.00 11.86           C  
ATOM    959  C   LEU A 125      87.572 119.727  52.703  1.00 10.45           C  
ATOM    960  O   LEU A 125      88.660 119.201  52.917  1.00 10.48           O  
ATOM    961  CB  LEU A 125      85.474 118.836  53.687  1.00 12.55           C  
ATOM    962  CG  LEU A 125      84.096 118.161  53.594  1.00 14.36           C  
ATOM    963  CD1 LEU A 125      83.490 118.094  54.985  1.00 14.82           C  
ATOM    964  CD2 LEU A 125      83.189 118.909  52.616  1.00 13.30           C  
ATOM    965  N   CYS A 126      87.370 121.045  52.740  1.00 11.30           N  
ATOM    966  CA  CYS A 126      88.440 121.985  53.054  1.00 10.23           C  
ATOM    967  C   CYS A 126      87.818 123.283  53.601  1.00 11.64           C  
ATOM    968  O   CYS A 126      86.609 123.518  53.456  1.00 10.98           O  
ATOM    969  CB  CYS A 126      89.280 122.281  51.799  1.00  6.09           C  
ATOM    970  SG  CYS A 126      88.440 123.209  50.539  1.00 13.58           S  
ATOM    971  N   HIS A 127      88.615 124.070  54.316  1.00 12.15           N  
ATOM    972  CA  HIS A 127      88.149 125.377  54.810  1.00 12.42           C  
ATOM    973  C   HIS A 127      89.332 126.354  54.788  1.00 12.55           C  
ATOM    974  O   HIS A 127      90.492 125.929  54.796  1.00 10.78           O  
ATOM    975  CB  HIS A 127      87.472 125.309  56.195  1.00 10.36           C  
ATOM    976  CG  HIS A 127      88.392 124.984  57.336  1.00 14.10           C  
ATOM    977  ND1 HIS A 127      89.254 125.905  57.890  1.00 16.35           N  
ATOM    978  CD2 HIS A 127      88.542 123.853  58.066  1.00 14.31           C  
ATOM    979  CE1 HIS A 127      89.896 125.355  58.907  1.00 17.64           C  
ATOM    980  NE2 HIS A 127      89.481 124.108  59.035  1.00 17.39           N  
ATOM    981  N   ALA A 128      89.034 127.645  54.664  1.00 11.85           N  
ATOM    982  CA  ALA A 128      90.077 128.676  54.617  1.00  9.50           C  
ATOM    983  C   ALA A 128      90.856 128.814  55.916  1.00 12.45           C  
ATOM    984  O   ALA A 128      90.303 128.643  57.006  1.00 14.11           O  
ATOM    985  CB  ALA A 128      89.466 130.021  54.236  1.00 12.67           C  
ATOM    986  N   ILE A 129      92.167 129.020  55.793  1.00 11.16           N  
ATOM    987  CA  ILE A 129      93.031 129.234  56.944  1.00 10.28           C  
ATOM    988  C   ILE A 129      93.978 130.397  56.607  1.00 10.93           C  
ATOM    989  O   ILE A 129      94.147 130.746  55.446  1.00 12.07           O  
ATOM    990  CB  ILE A 129      93.867 127.981  57.352  1.00  8.98           C  
ATOM    991  CG1 ILE A 129      94.625 127.420  56.152  1.00  8.08           C  
ATOM    992  CG2 ILE A 129      92.951 126.889  57.953  1.00 11.89           C  
ATOM    993  CD1 ILE A 129      95.688 126.427  56.515  1.00 11.92           C  
ATOM    994  N   SER A 130      94.548 131.000  57.641  1.00 14.99           N  
ATOM    995  CA  SER A 130      95.493 132.107  57.499  1.00 12.94           C  
ATOM    996  C   SER A 130      96.847 131.549  57.095  1.00 14.95           C  
ATOM    997  O   SER A 130      97.107 130.349  57.265  1.00 14.58           O  
ATOM    998  CB  SER A 130      95.642 132.802  58.850  1.00 15.06           C  
ATOM    999  OG  SER A 130      96.350 131.989  59.788  1.00 13.71           O  
ATOM   1000  N   ALA A 131      97.728 132.425  56.625  1.00 15.22           N  
ATOM   1001  CA  ALA A 131      99.076 132.028  56.226  1.00 14.82           C  
ATOM   1002  C   ALA A 131      99.875 131.457  57.399  1.00 13.45           C  
ATOM   1003  O   ALA A 131     100.656 130.521  57.228  1.00 13.44           O  
ATOM   1004  CB  ALA A 131      99.808 133.218  55.612  1.00 11.58           C  
ATOM   1005  N   ALA A 132      99.665 131.998  58.594  1.00 13.80           N  
ATOM   1006  CA  ALA A 132     100.385 131.519  59.773  1.00 15.55           C  
ATOM   1007  C   ALA A 132     100.015 130.064  60.089  1.00 16.17           C  
ATOM   1008  O   ALA A 132     100.889 129.258  60.443  1.00 19.18           O  
ATOM   1009  CB  ALA A 132     100.109 132.405  60.958  1.00 13.66           C  
ATOM   1010  N   GLU A 133      98.729 129.729  59.992  1.00 17.05           N  
ATOM   1011  CA  GLU A 133      98.284 128.347  60.235  1.00 19.64           C  
ATOM   1012  C   GLU A 133      98.795 127.399  59.141  1.00 19.17           C  
ATOM   1013  O   GLU A 133      99.105 126.237  59.408  1.00 18.82           O  
ATOM   1014  CB  GLU A 133      96.761 128.259  60.279  1.00 25.30           C  
ATOM   1015  CG  GLU A 133      96.120 128.902  61.483  1.00 40.86           C  
ATOM   1016  CD  GLU A 133      94.756 128.298  61.798  1.00 49.77           C  
ATOM   1017  OE1 GLU A 133      94.065 128.824  62.702  1.00 55.78           O  
ATOM   1018  OE2 GLU A 133      94.379 127.285  61.159  1.00 53.54           O  
ATOM   1019  N   ALA A 134      98.862 127.896  57.907  1.00 15.21           N  
ATOM   1020  CA  ALA A 134      99.344 127.113  56.775  1.00 15.12           C  
ATOM   1021  C   ALA A 134     100.823 126.723  56.885  1.00 16.08           C  
ATOM   1022  O   ALA A 134     101.268 125.775  56.238  1.00 16.96           O  
ATOM   1023  CB  ALA A 134      99.087 127.858  55.479  1.00 13.08           C  
ATOM   1024  N   ALA A 135     101.586 127.418  57.727  1.00 15.39           N  
ATOM   1025  CA  ALA A 135     103.019 127.106  57.881  1.00 17.90           C  
ATOM   1026  C   ALA A 135     103.339 125.759  58.546  1.00 19.67           C  
ATOM   1027  O   ALA A 135     104.418 125.191  58.322  1.00 21.23           O  
ATOM   1028  CB  ALA A 135     103.726 128.233  58.631  1.00 16.81           C  
ATOM   1029  N   GLU A 136     102.416 125.268  59.375  1.00 21.08           N  
ATOM   1030  CA  GLU A 136     102.581 124.001  60.108  1.00 24.69           C  
ATOM   1031  C   GLU A 136     102.482 122.785  59.221  1.00 23.43           C  
ATOM   1032  O   GLU A 136     101.496 122.624  58.499  1.00 17.89           O  
ATOM   1033  CB  GLU A 136     101.528 123.874  61.214  1.00 31.48           C  
ATOM   1034  CG  GLU A 136     101.707 124.874  62.333  1.00 47.01           C  
ATOM   1035  CD  GLU A 136     103.145 124.914  62.835  1.00 55.23           C  
ATOM   1036  OE1 GLU A 136     103.668 123.856  63.257  1.00 61.73           O  
ATOM   1037  OE2 GLU A 136     103.764 126.001  62.784  1.00 60.54           O  
ATOM   1038  N   PRO A 137     103.500 121.907  59.267  1.00 20.91           N  
ATOM   1039  CA  PRO A 137     103.502 120.691  58.446  1.00 19.62           C  
ATOM   1040  C   PRO A 137     102.471 119.666  58.887  1.00 19.69           C  
ATOM   1041  O   PRO A 137     102.162 118.745  58.139  1.00 19.26           O  
ATOM   1042  CB  PRO A 137     104.942 120.191  58.559  1.00 19.29           C  
ATOM   1043  CG  PRO A 137     105.392 120.730  59.898  1.00 23.48           C  
ATOM   1044  CD  PRO A 137     104.811 122.115  59.909  1.00 23.93           C  
ATOM   1045  N   SER A 138     101.900 119.865  60.077  1.00 21.14           N  
ATOM   1046  CA  SER A 138     100.853 118.977  60.604  1.00 23.79           C  
ATOM   1047  C   SER A 138      99.488 119.332  59.987  1.00 21.41           C  
ATOM   1048  O   SER A 138      98.516 118.598  60.150  1.00 21.02           O  
ATOM   1049  CB  SER A 138     100.789 119.049  62.140  1.00 24.63           C  
ATOM   1050  OG  SER A 138     100.546 120.378  62.586  1.00 32.46           O  
ATOM   1051  N   THR A 139      99.427 120.472  59.297  1.00 19.13           N  
ATOM   1052  CA  THR A 139      98.216 120.917  58.611  1.00 16.95           C  
ATOM   1053  C   THR A 139      98.433 120.636  57.131  1.00 15.73           C  
ATOM   1054  O   THR A 139      99.471 120.994  56.586  1.00 17.66           O  
ATOM   1055  CB  THR A 139      97.967 122.415  58.841  1.00 19.06           C  
ATOM   1056  OG1 THR A 139      97.568 122.594  60.199  1.00 23.99           O  
ATOM   1057  CG2 THR A 139      96.855 122.950  57.951  1.00 19.20           C  
ATOM   1058  N   VAL A 140      97.473 119.948  56.505  1.00 11.73           N  
ATOM   1059  CA  VAL A 140      97.573 119.594  55.095  1.00  9.32           C  
ATOM   1060  C   VAL A 140      96.872 120.667  54.268  1.00 10.35           C  
ATOM   1061  O   VAL A 140      95.727 121.019  54.546  1.00 11.98           O  
ATOM   1062  CB  VAL A 140      96.939 118.176  54.831  1.00  8.42           C  
ATOM   1063  CG1 VAL A 140      97.073 117.766  53.364  1.00  3.30           C  
ATOM   1064  CG2 VAL A 140      97.608 117.154  55.735  1.00  7.50           C  
ATOM   1065  N   LYS A 141      97.604 121.242  53.312  1.00  9.20           N  
ATOM   1066  CA  LYS A 141      97.067 122.269  52.430  1.00  9.16           C  
ATOM   1067  C   LYS A 141      96.630 121.622  51.120  1.00  9.43           C  
ATOM   1068  O   LYS A 141      97.145 120.566  50.721  1.00 12.78           O  
ATOM   1069  CB  LYS A 141      98.133 123.351  52.134  1.00  6.85           C  
ATOM   1070  CG  LYS A 141      98.310 124.420  53.236  1.00  6.98           C  
ATOM   1071  CD  LYS A 141      98.898 123.899  54.538  1.00  6.76           C  
ATOM   1072  CE  LYS A 141     100.280 123.256  54.381  1.00  7.20           C  
ATOM   1073  NZ  LYS A 141     100.955 123.041  55.712  1.00  9.68           N  
ATOM   1074  N   VAL A 142      95.654 122.240  50.472  1.00  7.57           N  
ATOM   1075  CA  VAL A 142      95.203 121.781  49.187  1.00  5.34           C  
ATOM   1076  C   VAL A 142      95.028 123.010  48.280  1.00  7.42           C  
ATOM   1077  O   VAL A 142      94.699 124.095  48.752  1.00  8.76           O  
ATOM   1078  CB  VAL A 142      93.868 120.953  49.289  1.00  9.42           C  
ATOM   1079  CG1 VAL A 142      92.749 121.778  49.948  1.00 10.51           C  
ATOM   1080  CG2 VAL A 142      93.433 120.461  47.903  1.00  6.41           C  
ATOM   1081  N   VAL A 143      95.315 122.840  46.993  1.00  7.97           N  
ATOM   1082  CA  VAL A 143      95.124 123.879  45.992  1.00  7.73           C  
ATOM   1083  C   VAL A 143      94.148 123.263  44.992  1.00  8.36           C  
ATOM   1084  O   VAL A 143      94.337 122.107  44.604  1.00  8.65           O  
ATOM   1085  CB  VAL A 143      96.449 124.238  45.283  1.00  9.63           C  
ATOM   1086  CG1 VAL A 143      96.158 125.188  44.110  1.00 15.08           C  
ATOM   1087  CG2 VAL A 143      97.376 124.924  46.273  1.00 12.46           C  
ATOM   1088  N   VAL A 144      93.145 124.028  44.558  1.00  8.04           N  
ATOM   1089  CA  VAL A 144      92.118 123.527  43.642  1.00  8.72           C  
ATOM   1090  C   VAL A 144      91.981 124.342  42.370  1.00  9.10           C  
ATOM   1091  O   VAL A 144      92.423 125.480  42.324  1.00 10.10           O  
ATOM   1092  CB  VAL A 144      90.711 123.485  44.351  1.00 12.73           C  
ATOM   1093  CG1 VAL A 144      90.775 122.675  45.669  1.00 10.22           C  
ATOM   1094  CG2 VAL A 144      90.218 124.898  44.634  1.00 11.22           C  
ATOM   1095  N   ASN A 145      91.389 123.747  41.341  1.00  6.98           N  
ATOM   1096  CA  ASN A 145      91.149 124.415  40.051  1.00 10.34           C  
ATOM   1097  C   ASN A 145      89.736 125.050  40.029  1.00 11.50           C  
ATOM   1098  O   ASN A 145      89.073 125.060  41.074  1.00 11.51           O  
ATOM   1099  CB  ASN A 145      91.401 123.457  38.853  1.00 10.72           C  
ATOM   1100  CG  ASN A 145      90.380 122.322  38.738  1.00 11.76           C  
ATOM   1101  OD1 ASN A 145      89.358 122.297  39.412  1.00 12.20           O  
ATOM   1102  ND2 ASN A 145      90.682 121.363  37.881  1.00 15.69           N  
ATOM   1103  N   THR A 146      89.279 125.605  38.890  1.00 12.36           N  
ATOM   1104  CA  THR A 146      87.938 126.240  38.837  1.00 18.60           C  
ATOM   1105  C   THR A 146      86.742 125.328  39.135  1.00 19.02           C  
ATOM   1106  O   THR A 146      85.693 125.807  39.562  1.00 22.02           O  
ATOM   1107  CB  THR A 146      87.637 126.998  37.501  1.00 19.15           C  
ATOM   1108  OG1 THR A 146      87.847 126.138  36.366  1.00 25.58           O  
ATOM   1109  CG2 THR A 146      88.495 128.217  37.384  1.00 25.63           C  
ATOM   1110  N   ARG A 147      86.907 124.028  38.914  1.00 18.44           N  
ATOM   1111  CA  ARG A 147      85.851 123.053  39.182  1.00 18.17           C  
ATOM   1112  C   ARG A 147      85.943 122.551  40.626  1.00 17.86           C  
ATOM   1113  O   ARG A 147      85.170 121.692  41.053  1.00 20.02           O  
ATOM   1114  CB  ARG A 147      85.979 121.863  38.231  1.00 21.75           C  
ATOM   1115  CG  ARG A 147      85.615 122.159  36.795  1.00 34.02           C  
ATOM   1116  CD  ARG A 147      85.504 120.876  35.980  1.00 42.37           C  
ATOM   1117  NE  ARG A 147      86.805 120.291  35.647  1.00 49.08           N  
ATOM   1118  CZ  ARG A 147      87.590 120.701  34.647  1.00 51.85           C  
ATOM   1119  NH1 ARG A 147      87.231 121.711  33.862  1.00 52.48           N  
ATOM   1120  NH2 ARG A 147      88.728 120.068  34.404  1.00 54.36           N  
ATOM   1121  N   GLN A 148      86.876 123.108  41.386  1.00 12.52           N  
ATOM   1122  CA  GLN A 148      87.105 122.693  42.769  1.00 13.62           C  
ATOM   1123  C   GLN A 148      87.804 121.340  42.880  1.00 11.14           C  
ATOM   1124  O   GLN A 148      87.838 120.735  43.940  1.00 10.66           O  
ATOM   1125  CB  GLN A 148      85.810 122.695  43.585  1.00 21.75           C  
ATOM   1126  CG  GLN A 148      85.168 124.045  43.661  1.00 34.25           C  
ATOM   1127  CD  GLN A 148      84.148 124.091  44.761  1.00 46.88           C  
ATOM   1128  OE1 GLN A 148      83.080 123.469  44.673  1.00 52.08           O  
ATOM   1129  NE2 GLN A 148      84.482 124.795  45.836  1.00 50.50           N  
ATOM   1130  N   ASP A 149      88.324 120.845  41.769  1.00  8.76           N  
ATOM   1131  CA  ASP A 149      89.079 119.599  41.797  1.00 10.70           C  
ATOM   1132  C   ASP A 149      90.435 119.900  42.419  1.00 11.39           C  
ATOM   1133  O   ASP A 149      91.030 120.945  42.142  1.00  9.60           O  
ATOM   1134  CB  ASP A 149      89.316 119.084  40.381  1.00 12.86           C  
ATOM   1135  CG  ASP A 149      88.036 118.641  39.696  1.00 17.51           C  
ATOM   1136  OD1 ASP A 149      87.063 118.266  40.392  1.00 17.73           O  
ATOM   1137  OD2 ASP A 149      88.028 118.639  38.453  1.00 22.62           O  
ATOM   1138  N   ALA A 150      90.950 118.980  43.224  1.00  8.39           N  
ATOM   1139  CA  ALA A 150      92.253 119.184  43.837  1.00  9.18           C  
ATOM   1140  C   ALA A 150      93.375 119.012  42.821  1.00  7.28           C  
ATOM   1141  O   ALA A 150      93.317 118.131  41.943  1.00  7.11           O  
ATOM   1142  CB  ALA A 150      92.455 118.217  45.001  1.00 11.39           C  
ATOM   1143  N   LEU A 151      94.356 119.917  42.885  1.00  7.21           N  
ATOM   1144  CA  LEU A 151      95.540 119.831  42.017  1.00  6.31           C  
ATOM   1145  C   LEU A 151      96.612 119.040  42.792  1.00  6.17           C  
ATOM   1146  O   LEU A 151      97.272 118.167  42.246  1.00 10.46           O  
ATOM   1147  CB  LEU A 151      96.083 121.236  41.669  1.00  7.53           C  
ATOM   1148  CG  LEU A 151      95.168 122.099  40.793  1.00  8.82           C  
ATOM   1149  CD1 LEU A 151      95.863 123.435  40.505  1.00  9.68           C  
ATOM   1150  CD2 LEU A 151      94.838 121.366  39.500  1.00 13.12           C  
ATOM   1151  N   TYR A 152      96.746 119.333  44.075  1.00  6.95           N  
ATOM   1152  CA  TYR A 152      97.739 118.650  44.913  1.00  8.53           C  
ATOM   1153  C   TYR A 152      97.428 118.925  46.386  1.00 10.11           C  
ATOM   1154  O   TYR A 152      96.738 119.902  46.709  1.00 10.02           O  
ATOM   1155  CB  TYR A 152      99.169 119.150  44.547  1.00  7.96           C  
ATOM   1156  CG  TYR A 152     100.331 118.402  45.198  1.00  7.30           C  
ATOM   1157  CD1 TYR A 152     100.521 117.040  44.972  1.00  6.89           C  
ATOM   1158  CD2 TYR A 152     101.221 119.052  46.056  1.00  8.33           C  
ATOM   1159  CE1 TYR A 152     101.553 116.344  45.584  1.00  6.10           C  
ATOM   1160  CE2 TYR A 152     102.272 118.352  46.673  1.00  6.05           C  
ATOM   1161  CZ  TYR A 152     102.419 116.998  46.429  1.00  8.16           C  
ATOM   1162  OH  TYR A 152     103.415 116.284  47.037  1.00 10.97           O  
ATOM   1163  N   PHE A 153      97.901 118.034  47.266  1.00  8.02           N  
ATOM   1164  CA  PHE A 153      97.751 118.153  48.727  1.00  8.59           C  
ATOM   1165  C   PHE A 153      99.202 118.122  49.231  1.00  8.76           C  
ATOM   1166  O   PHE A 153      99.983 117.286  48.781  1.00  7.06           O  
ATOM   1167  CB  PHE A 153      97.060 116.924  49.354  1.00  8.14           C  
ATOM   1168  CG  PHE A 153      95.608 116.765  48.997  1.00  6.70           C  
ATOM   1169  CD1 PHE A 153      95.231 116.124  47.809  1.00  9.26           C  
ATOM   1170  CD2 PHE A 153      94.623 117.242  49.854  1.00  8.86           C  
ATOM   1171  CE1 PHE A 153      93.876 115.958  47.462  1.00  8.17           C  
ATOM   1172  CE2 PHE A 153      93.259 117.089  49.532  1.00  9.26           C  
ATOM   1173  CZ  PHE A 153      92.889 116.447  48.331  1.00  7.65           C  
ATOM   1174  N   SER A 154      99.546 118.965  50.196  1.00  8.02           N  
ATOM   1175  CA  SER A 154     100.908 118.970  50.702  1.00  7.70           C  
ATOM   1176  C   SER A 154     101.031 119.505  52.109  1.00  8.61           C  
ATOM   1177  O   SER A 154     100.173 120.248  52.566  1.00 10.33           O  
ATOM   1178  CB  SER A 154     101.798 119.828  49.789  1.00  8.62           C  
ATOM   1179  OG  SER A 154     103.175 119.677  50.129  1.00  9.98           O  
ATOM   1180  N   ARG A 155     102.109 119.108  52.791  1.00  9.27           N  
ATOM   1181  CA  ARG A 155     102.422 119.611  54.125  1.00  9.15           C  
ATOM   1182  C   ARG A 155     103.182 120.930  53.916  1.00  9.70           C  
ATOM   1183  O   ARG A 155     103.302 121.715  54.841  1.00 11.86           O  
ATOM   1184  CB  ARG A 155     103.283 118.618  54.907  1.00 12.93           C  
ATOM   1185  CG  ARG A 155     102.490 117.362  55.326  1.00 11.19           C  
ATOM   1186  CD  ARG A 155     103.343 116.373  56.105  1.00 16.45           C  
ATOM   1187  NE  ARG A 155     102.608 115.126  56.298  1.00 19.18           N  
ATOM   1188  CZ  ARG A 155     101.584 114.973  57.136  1.00 21.79           C  
ATOM   1189  NH1 ARG A 155     101.164 115.981  57.894  1.00 16.00           N  
ATOM   1190  NH2 ARG A 155     100.917 113.832  57.150  1.00 21.74           N  
ATOM   1191  N   SER A 156     103.691 121.153  52.700  1.00  8.67           N  
ATOM   1192  CA  SER A 156     104.380 122.423  52.381  1.00  9.13           C  
ATOM   1193  C   SER A 156     103.336 123.499  52.137  1.00 13.01           C  
ATOM   1194  O   SER A 156     102.237 123.220  51.649  1.00 10.09           O  
ATOM   1195  CB  SER A 156     105.194 122.354  51.088  1.00 11.49           C  
ATOM   1196  OG  SER A 156     106.356 121.575  51.205  1.00 18.47           O  
ATOM   1197  N   PRO A 157     103.669 124.758  52.462  1.00 14.40           N  
ATOM   1198  CA  PRO A 157     102.675 125.795  52.214  1.00 13.31           C  
ATOM   1199  C   PRO A 157     102.518 125.992  50.701  1.00 14.48           C  
ATOM   1200  O   PRO A 157     103.471 126.352  50.006  1.00 14.44           O  
ATOM   1201  CB  PRO A 157     103.293 127.041  52.870  1.00 15.84           C  
ATOM   1202  CG  PRO A 157     104.210 126.479  53.902  1.00 18.46           C  
ATOM   1203  CD  PRO A 157     104.831 125.298  53.190  1.00 14.36           C  
ATOM   1204  N   ILE A 158     101.340 125.660  50.179  1.00 11.32           N  
ATOM   1205  CA  ILE A 158     101.048 125.868  48.763  1.00 11.01           C  
ATOM   1206  C   ILE A 158      99.703 126.627  48.737  1.00  9.56           C  
ATOM   1207  O   ILE A 158      98.794 126.293  49.485  1.00 12.90           O  
ATOM   1208  CB  ILE A 158     100.961 124.521  47.936  1.00  8.44           C  
ATOM   1209  CG1 ILE A 158      99.996 123.528  48.590  1.00  8.93           C  
ATOM   1210  CG2 ILE A 158     102.359 123.892  47.763  1.00  7.17           C  
ATOM   1211  CD1 ILE A 158      99.711 122.317  47.683  1.00  9.18           C  
ATOM   1212  N   PRO A 159      99.564 127.656  47.890  1.00 10.35           N  
ATOM   1213  CA  PRO A 159     100.586 128.141  46.958  1.00  9.39           C  
ATOM   1214  C   PRO A 159     101.744 128.842  47.687  1.00 11.79           C  
ATOM   1215  O   PRO A 159     101.580 129.355  48.808  1.00 13.94           O  
ATOM   1216  CB  PRO A 159      99.798 129.115  46.081  1.00 11.17           C  
ATOM   1217  CG  PRO A 159      98.809 129.701  47.046  1.00 11.08           C  
ATOM   1218  CD  PRO A 159      98.331 128.461  47.785  1.00 11.40           C  
ATOM   1219  N   TYR A 160     102.932 128.782  47.093  1.00  9.25           N  
ATOM   1220  CA  TYR A 160     104.090 129.451  47.676  1.00 10.96           C  
ATOM   1221  C   TYR A 160     103.767 130.957  47.692  1.00  9.79           C  
ATOM   1222  O   TYR A 160     103.261 131.494  46.700  1.00 11.05           O  
ATOM   1223  CB  TYR A 160     105.337 129.174  46.828  1.00 10.91           C  
ATOM   1224  CG  TYR A 160     106.554 129.904  47.345  1.00 13.17           C  
ATOM   1225  CD1 TYR A 160     107.330 129.362  48.365  1.00 12.07           C  
ATOM   1226  CD2 TYR A 160     106.900 131.161  46.840  1.00 14.43           C  
ATOM   1227  CE1 TYR A 160     108.431 130.064  48.875  1.00 16.32           C  
ATOM   1228  CE2 TYR A 160     107.988 131.862  47.341  1.00 16.64           C  
ATOM   1229  CZ  TYR A 160     108.744 131.312  48.354  1.00 16.69           C  
ATOM   1230  OH  TYR A 160     109.806 132.016  48.867  1.00 23.31           O  
ATOM   1231  N   PRO A 161     104.080 131.663  48.792  1.00 12.18           N  
ATOM   1232  CA  PRO A 161     103.755 133.097  48.811  1.00 13.41           C  
ATOM   1233  C   PRO A 161     104.794 134.042  48.168  1.00 15.72           C  
ATOM   1234  O   PRO A 161     105.463 134.795  48.877  1.00 18.14           O  
ATOM   1235  CB  PRO A 161     103.594 133.369  50.299  1.00 12.21           C  
ATOM   1236  CG  PRO A 161     104.682 132.538  50.891  1.00 11.78           C  
ATOM   1237  CD  PRO A 161     104.695 131.248  50.064  1.00 10.00           C  
ATOM   1238  N   ARG A 162     104.948 133.979  46.850  1.00 14.74           N  
ATOM   1239  CA  ARG A 162     105.894 134.863  46.145  1.00 16.41           C  
ATOM   1240  C   ARG A 162     105.317 136.290  46.274  1.00 16.71           C  
ATOM   1241  O   ARG A 162     106.034 137.221  46.649  1.00 15.66           O  
ATOM   1242  CB  ARG A 162     106.049 134.418  44.690  1.00 15.82           C  
ATOM   1243  CG  ARG A 162     106.784 135.398  43.783  1.00 25.77           C  
ATOM   1244  CD  ARG A 162     108.202 135.572  44.199  1.00 34.67           C  
ATOM   1245  NE  ARG A 162     109.055 135.442  43.032  1.00 44.17           N  
ATOM   1246  CZ  ARG A 162     110.218 134.800  43.022  1.00 46.97           C  
ATOM   1247  NH1 ARG A 162     110.694 134.225  44.127  1.00 45.12           N  
ATOM   1248  NH2 ARG A 162     110.882 134.689  41.881  1.00 50.39           N  
ATOM   1249  N   ASN A 163     104.037 136.449  45.936  1.00 13.67           N  
ATOM   1250  CA  ASN A 163     103.302 137.710  46.102  1.00 14.34           C  
ATOM   1251  C   ASN A 163     102.364 137.325  47.240  1.00 15.60           C  
ATOM   1252  O   ASN A 163     101.240 136.850  47.021  1.00 16.25           O  
ATOM   1253  CB  ASN A 163     102.516 138.072  44.859  1.00 15.49           C  
ATOM   1254  CG  ASN A 163     103.415 138.350  43.682  1.00 24.04           C  
ATOM   1255  OD1 ASN A 163     104.380 139.098  43.802  1.00 26.88           O  
ATOM   1256  ND2 ASN A 163     103.122 137.737  42.540  1.00 28.27           N  
ATOM   1257  N   ALA A 164     102.875 137.482  48.457  1.00 17.18           N  
ATOM   1258  CA  ALA A 164     102.185 137.099  49.679  1.00 18.32           C  
ATOM   1259  C   ALA A 164     100.759 137.573  49.891  1.00 21.48           C  
ATOM   1260  O   ALA A 164      99.926 136.784  50.324  1.00 20.29           O  
ATOM   1261  CB  ALA A 164     103.050 137.411  50.883  1.00 20.55           C  
ATOM   1262  N   GLU A 165     100.449 138.825  49.563  1.00 18.08           N  
ATOM   1263  CA  GLU A 165      99.089 139.339  49.748  1.00 21.06           C  
ATOM   1264  C   GLU A 165      98.045 138.684  48.861  1.00 18.68           C  
ATOM   1265  O   GLU A 165      96.844 138.884  49.079  1.00 22.64           O  
ATOM   1266  CB  GLU A 165      98.980 140.853  49.495  1.00 22.44           C  
ATOM   1267  CG  GLU A 165     100.257 141.604  49.318  1.00 32.02           C  
ATOM   1268  CD  GLU A 165     100.976 141.281  48.019  1.00 34.09           C  
ATOM   1269  OE1 GLU A 165     100.415 141.466  46.907  1.00 36.34           O  
ATOM   1270  OE2 GLU A 165     102.126 140.841  48.131  1.00 34.72           O  
ATOM   1271  N   LYS A 166      98.487 137.978  47.820  1.00 17.10           N  
ATOM   1272  CA  LYS A 166      97.564 137.333  46.891  1.00 15.60           C  
ATOM   1273  C   LYS A 166      97.286 135.871  47.230  1.00 14.11           C  
ATOM   1274  O   LYS A 166      96.420 135.263  46.637  1.00 14.01           O  
ATOM   1275  CB  LYS A 166      98.092 137.420  45.455  1.00 18.90           C  
ATOM   1276  CG  LYS A 166      98.242 138.841  44.901  1.00 27.24           C  
ATOM   1277  CD  LYS A 166      96.888 139.480  44.645  1.00 37.25           C  
ATOM   1278  CE  LYS A 166      97.020 140.890  44.045  1.00 44.90           C  
ATOM   1279  NZ  LYS A 166      95.677 141.512  43.744  1.00 48.79           N  
ATOM   1280  N   ALA A 167      98.043 135.309  48.160  1.00 11.34           N  
ATOM   1281  CA  ALA A 167      97.865 133.908  48.543  1.00 13.87           C  
ATOM   1282  C   ALA A 167      96.678 133.686  49.484  1.00 15.35           C  
ATOM   1283  O   ALA A 167      96.462 134.454  50.430  1.00 12.75           O  
ATOM   1284  CB  ALA A 167      99.146 133.376  49.188  1.00  9.83           C  
ATOM   1285  N   ARG A 168      95.905 132.640  49.188  1.00 13.93           N  
ATOM   1286  CA  ARG A 168      94.762 132.234  49.999  1.00 14.18           C  
ATOM   1287  C   ARG A 168      94.992 130.728  50.249  1.00 14.54           C  
ATOM   1288  O   ARG A 168      95.313 129.981  49.319  1.00 15.55           O  
ATOM   1289  CB  ARG A 168      93.460 132.487  49.243  1.00 18.30           C  
ATOM   1290  CG  ARG A 168      92.224 132.251  50.081  1.00 26.74           C  
ATOM   1291  CD  ARG A 168      90.949 132.681  49.355  1.00 34.88           C  
ATOM   1292  NE  ARG A 168      89.776 132.410  50.189  1.00 41.87           N  
ATOM   1293  CZ  ARG A 168      89.039 131.298  50.137  1.00 42.16           C  
ATOM   1294  NH1 ARG A 168      89.324 130.324  49.278  1.00 40.23           N  
ATOM   1295  NH2 ARG A 168      88.029 131.144  50.984  1.00 40.95           N  
ATOM   1296  N   TYR A 169      94.968 130.332  51.516  1.00 10.81           N  
ATOM   1297  CA  TYR A 169      95.216 128.954  51.913  1.00 10.28           C  
ATOM   1298  C   TYR A 169      93.960 128.186  52.300  1.00 12.09           C  
ATOM   1299  O   TYR A 169      93.014 128.759  52.853  1.00  8.81           O  
ATOM   1300  CB  TYR A 169      96.216 128.916  53.078  1.00  8.55           C  
ATOM   1301  CG  TYR A 169      97.578 129.413  52.662  1.00 10.25           C  
ATOM   1302  CD1 TYR A 169      98.452 128.567  51.992  1.00  9.69           C  
ATOM   1303  CD2 TYR A 169      97.941 130.760  52.826  1.00 10.83           C  
ATOM   1304  CE1 TYR A 169      99.655 129.036  51.472  1.00 12.97           C  
ATOM   1305  CE2 TYR A 169      99.147 131.245  52.308  1.00 10.33           C  
ATOM   1306  CZ  TYR A 169      99.993 130.371  51.633  1.00 13.42           C  
ATOM   1307  OH  TYR A 169     101.182 130.802  51.102  1.00 14.29           O  
ATOM   1308  N   LEU A 170      93.965 126.894  51.963  1.00 10.69           N  
ATOM   1309  CA  LEU A 170      92.864 125.982  52.282  1.00  9.57           C  
ATOM   1310  C   LEU A 170      93.413 124.798  53.038  1.00  9.45           C  
ATOM   1311  O   LEU A 170      94.381 124.184  52.614  1.00 10.12           O  
ATOM   1312  CB  LEU A 170      92.182 125.458  51.013  1.00  7.20           C  
ATOM   1313  CG  LEU A 170      91.406 126.458  50.164  1.00 11.18           C  
ATOM   1314  CD1 LEU A 170      91.032 125.844  48.814  1.00 11.66           C  
ATOM   1315  CD2 LEU A 170      90.164 126.939  50.931  1.00 10.70           C  
ATOM   1316  N   LYS A 171      92.820 124.515  54.188  1.00  8.27           N  
ATOM   1317  CA  LYS A 171      93.201 123.365  54.974  1.00  9.56           C  
ATOM   1318  C   LYS A 171      92.287 122.184  54.563  1.00 12.30           C  
ATOM   1319  O   LYS A 171      91.059 122.331  54.441  1.00 10.60           O  
ATOM   1320  CB  LYS A 171      92.995 123.643  56.454  1.00 11.95           C  
ATOM   1321  CG  LYS A 171      93.165 122.413  57.329  1.00 16.61           C  
ATOM   1322  CD  LYS A 171      92.891 122.746  58.786  1.00 24.22           C  
ATOM   1323  CE  LYS A 171      93.178 121.552  59.665  1.00 30.86           C  
ATOM   1324  NZ  LYS A 171      93.266 121.956  61.093  1.00 37.12           N  
ATOM   1325  N   HIS A 172      92.896 121.016  54.378  1.00 10.72           N  
ATOM   1326  CA  HIS A 172      92.161 119.814  54.020  1.00 10.92           C  
ATOM   1327  C   HIS A 172      91.542 119.222  55.300  1.00 12.97           C  
ATOM   1328  O   HIS A 172      92.224 119.101  56.326  1.00 10.98           O  
ATOM   1329  CB  HIS A 172      93.115 118.813  53.372  1.00 11.28           C  
ATOM   1330  CG  HIS A 172      92.510 117.465  53.126  1.00 14.10           C  
ATOM   1331  ND1 HIS A 172      91.256 117.295  52.574  1.00 15.52           N  
ATOM   1332  CD2 HIS A 172      92.978 116.223  53.385  1.00 11.82           C  
ATOM   1333  CE1 HIS A 172      90.978 116.005  52.506  1.00 12.96           C  
ATOM   1334  NE2 HIS A 172      92.006 115.333  52.990  1.00 16.87           N  
ATOM   1335  N   VAL A 173      90.237 118.931  55.241  1.00 11.10           N  
ATOM   1336  CA  VAL A 173      89.480 118.319  56.353  1.00 13.15           C  
ATOM   1337  C   VAL A 173      89.315 116.850  55.943  1.00 14.45           C  
ATOM   1338  O   VAL A 173      88.646 116.560  54.950  1.00 14.12           O  
ATOM   1339  CB  VAL A 173      88.073 118.988  56.524  1.00 16.72           C  
ATOM   1340  CG1 VAL A 173      87.264 118.255  57.610  1.00 17.25           C  
ATOM   1341  CG2 VAL A 173      88.236 120.467  56.904  1.00 15.59           C  
ATOM   1342  N   GLY A 174      89.922 115.955  56.723  1.00 15.43           N  
ATOM   1343  CA  GLY A 174      89.959 114.523  56.449  1.00 18.83           C  
ATOM   1344  C   GLY A 174      88.730 113.635  56.416  1.00 19.12           C  
ATOM   1345  O   GLY A 174      88.774 112.514  56.925  1.00 19.45           O  
ATOM   1346  N   ILE A 175      87.658 114.126  55.804  1.00 16.17           N  
ATOM   1347  CA  ILE A 175      86.401 113.387  55.635  1.00 16.48           C  
ATOM   1348  C   ILE A 175      86.293 113.128  54.144  1.00 16.05           C  
ATOM   1349  O   ILE A 175      86.418 114.061  53.341  1.00 14.11           O  
ATOM   1350  CB  ILE A 175      85.203 114.222  56.062  1.00 17.32           C  
ATOM   1351  CG1 ILE A 175      85.279 114.465  57.570  1.00 21.05           C  
ATOM   1352  CG2 ILE A 175      83.910 113.499  55.718  1.00 17.52           C  
ATOM   1353  CD1 ILE A 175      84.229 115.395  58.066  1.00 23.83           C  
ATOM   1354  N   TYR A 176      86.037 111.872  53.779  1.00 10.91           N  
ATOM   1355  CA  TYR A 176      85.954 111.481  52.372  1.00 10.88           C  
ATOM   1356  C   TYR A 176      84.678 110.738  52.009  1.00 14.00           C  
ATOM   1357  O   TYR A 176      84.098 110.067  52.861  1.00 15.11           O  
ATOM   1358  CB  TYR A 176      87.090 110.516  52.038  1.00 11.41           C  
ATOM   1359  CG  TYR A 176      88.490 111.044  52.211  1.00 11.95           C  
ATOM   1360  CD1 TYR A 176      89.133 110.974  53.448  1.00 15.53           C  
ATOM   1361  CD2 TYR A 176      89.194 111.561  51.123  1.00 13.11           C  
ATOM   1362  CE1 TYR A 176      90.457 111.403  53.596  1.00 16.61           C  
ATOM   1363  CE2 TYR A 176      90.517 111.990  51.255  1.00 13.43           C  
ATOM   1364  CZ  TYR A 176      91.137 111.905  52.486  1.00 14.66           C  
ATOM   1365  OH  TYR A 176      92.446 112.288  52.611  1.00 18.57           O  
ATOM   1366  N   ALA A 177      84.251 110.880  50.754  1.00 12.12           N  
ATOM   1367  CA  ALA A 177      83.104 110.144  50.196  1.00 11.15           C  
ATOM   1368  C   ALA A 177      83.713 109.403  48.994  1.00 13.54           C  
ATOM   1369  O   ALA A 177      84.376 110.012  48.143  1.00 14.68           O  
ATOM   1370  CB  ALA A 177      81.995 111.083  49.733  1.00 11.48           C  
ATOM   1371  N   TYR A 178      83.537 108.088  48.948  1.00 11.20           N  
ATOM   1372  CA  TYR A 178      84.071 107.276  47.858  1.00 11.41           C  
ATOM   1373  C   TYR A 178      82.968 106.532  47.161  1.00 14.46           C  
ATOM   1374  O   TYR A 178      82.085 106.008  47.817  1.00 15.50           O  
ATOM   1375  CB  TYR A 178      85.001 106.175  48.379  1.00 14.17           C  
ATOM   1376  CG  TYR A 178      86.208 106.635  49.140  1.00 14.90           C  
ATOM   1377  CD1 TYR A 178      87.415 106.890  48.481  1.00 15.03           C  
ATOM   1378  CD2 TYR A 178      86.173 106.758  50.521  1.00 11.96           C  
ATOM   1379  CE1 TYR A 178      88.553 107.243  49.183  1.00 15.68           C  
ATOM   1380  CE2 TYR A 178      87.321 107.121  51.236  1.00 15.87           C  
ATOM   1381  CZ  TYR A 178      88.500 107.356  50.553  1.00 16.24           C  
ATOM   1382  OH  TYR A 178      89.638 107.683  51.242  1.00 23.04           O  
ATOM   1383  N   ARG A 179      83.036 106.480  45.838  1.00 14.43           N  
ATOM   1384  CA  ARG A 179      82.109 105.696  45.032  1.00 14.64           C  
ATOM   1385  C   ARG A 179      82.572 104.233  45.254  1.00 15.91           C  
ATOM   1386  O   ARG A 179      83.767 103.966  45.484  1.00 11.28           O  
ATOM   1387  CB  ARG A 179      82.283 106.043  43.558  1.00 18.96           C  
ATOM   1388  CG  ARG A 179      81.017 106.187  42.803  1.00 27.28           C  
ATOM   1389  CD  ARG A 179      80.735 107.638  42.596  1.00 31.55           C  
ATOM   1390  NE  ARG A 179      79.302 107.895  42.534  1.00 38.89           N  
ATOM   1391  CZ  ARG A 179      78.761 109.110  42.530  1.00 41.43           C  
ATOM   1392  NH1 ARG A 179      79.544 110.193  42.580  1.00 36.86           N  
ATOM   1393  NH2 ARG A 179      77.434 109.239  42.513  1.00 42.98           N  
ATOM   1394  N   ARG A 180      81.632 103.288  45.202  1.00 14.32           N  
ATOM   1395  CA  ARG A 180      81.947 101.874  45.407  1.00 15.30           C  
ATOM   1396  C   ARG A 180      83.059 101.339  44.486  1.00 12.73           C  
ATOM   1397  O   ARG A 180      83.975 100.634  44.942  1.00 13.24           O  
ATOM   1398  CB  ARG A 180      80.664 101.032  45.246  1.00 12.95           C  
ATOM   1399  CG  ARG A 180      80.848  99.552  45.539  1.00 18.49           C  
ATOM   1400  CD  ARG A 180      79.512  98.791  45.529  1.00 22.58           C  
ATOM   1401  NE  ARG A 180      79.727  97.346  45.586  1.00 23.57           N  
ATOM   1402  CZ  ARG A 180      79.864  96.626  46.699  1.00 25.27           C  
ATOM   1403  NH1 ARG A 180      79.791  97.189  47.893  1.00 24.50           N  
ATOM   1404  NH2 ARG A 180      80.161  95.335  46.613  1.00 27.26           N  
ATOM   1405  N   ASP A 181      83.000 101.682  43.206  1.00 15.15           N  
ATOM   1406  CA  ASP A 181      84.007 101.185  42.263  1.00 17.55           C  
ATOM   1407  C   ASP A 181      85.440 101.623  42.565  1.00 18.23           C  
ATOM   1408  O   ASP A 181      86.380 100.919  42.205  1.00 18.67           O  
ATOM   1409  CB  ASP A 181      83.626 101.493  40.810  1.00 27.10           C  
ATOM   1410  CG  ASP A 181      83.413 102.972  40.555  1.00 34.35           C  
ATOM   1411  OD1 ASP A 181      82.274 103.367  40.236  1.00 40.79           O  
ATOM   1412  OD2 ASP A 181      84.388 103.746  40.649  1.00 46.49           O  
ATOM   1413  N   VAL A 182      85.615 102.741  43.276  1.00 15.41           N  
ATOM   1414  CA  VAL A 182      86.963 103.194  43.632  1.00 14.90           C  
ATOM   1415  C   VAL A 182      87.556 102.260  44.673  1.00 15.54           C  
ATOM   1416  O   VAL A 182      88.714 101.850  44.574  1.00 15.14           O  
ATOM   1417  CB  VAL A 182      86.965 104.646  44.183  1.00 15.89           C  
ATOM   1418  CG1 VAL A 182      88.368 105.033  44.656  1.00 17.00           C  
ATOM   1419  CG2 VAL A 182      86.510 105.604  43.096  1.00 16.29           C  
ATOM   1420  N   LEU A 183      86.731 101.880  45.647  1.00 13.66           N  
ATOM   1421  CA  LEU A 183      87.160 100.993  46.710  1.00 10.62           C  
ATOM   1422  C   LEU A 183      87.408  99.565  46.207  1.00 12.74           C  
ATOM   1423  O   LEU A 183      88.315  98.896  46.705  1.00 14.47           O  
ATOM   1424  CB  LEU A 183      86.145 101.013  47.851  1.00 16.08           C  
ATOM   1425  CG  LEU A 183      86.019 102.371  48.569  1.00 14.70           C  
ATOM   1426  CD1 LEU A 183      84.882 102.313  49.549  1.00 15.75           C  
ATOM   1427  CD2 LEU A 183      87.319 102.730  49.295  1.00 15.91           C  
ATOM   1428  N   GLN A 184      86.651  99.131  45.199  1.00 13.37           N  
ATOM   1429  CA  GLN A 184      86.825  97.782  44.621  1.00 16.99           C  
ATOM   1430  C   GLN A 184      88.154  97.637  43.891  1.00 20.26           C  
ATOM   1431  O   GLN A 184      88.729  96.545  43.827  1.00 21.90           O  
ATOM   1432  CB  GLN A 184      85.709  97.454  43.635  1.00 16.27           C  
ATOM   1433  CG  GLN A 184      84.366  97.261  44.300  1.00 20.42           C  
ATOM   1434  CD  GLN A 184      83.256  96.964  43.322  1.00 24.45           C  
ATOM   1435  OE1 GLN A 184      82.969  97.757  42.428  1.00 26.92           O  
ATOM   1436  NE2 GLN A 184      82.598  95.831  43.510  1.00 27.24           N  
ATOM   1437  N   ASN A 185      88.625  98.740  43.318  1.00 21.20           N  
ATOM   1438  CA  ASN A 185      89.884  98.759  42.579  1.00 24.12           C  
ATOM   1439  C   ASN A 185      91.059  99.329  43.375  1.00 22.56           C  
ATOM   1440  O   ASN A 185      92.184  99.346  42.883  1.00 25.43           O  
ATOM   1441  CB  ASN A 185      89.721  99.582  41.293  1.00 28.28           C  
ATOM   1442  CG  ASN A 185      88.693  98.996  40.352  1.00 32.96           C  
ATOM   1443  OD1 ASN A 185      88.658  97.782  40.133  1.00 37.15           O  
ATOM   1444  ND2 ASN A 185      87.841  99.854  39.794  1.00 36.23           N  
ATOM   1445  N   TYR A 186      90.819  99.699  44.627  1.00 19.80           N  
ATOM   1446  CA  TYR A 186      91.840 100.327  45.445  1.00 16.04           C  
ATOM   1447  C   TYR A 186      93.083  99.549  45.772  1.00 20.86           C  
ATOM   1448  O   TYR A 186      94.177 100.106  45.704  1.00 18.81           O  
ATOM   1449  CB  TYR A 186      91.256 100.870  46.753  1.00 17.71           C  
ATOM   1450  CG  TYR A 186      92.234 101.735  47.529  1.00 17.38           C  
ATOM   1451  CD1 TYR A 186      92.452 103.083  47.180  1.00 18.36           C  
ATOM   1452  CD2 TYR A 186      92.953 101.210  48.601  1.00 17.26           C  
ATOM   1453  CE1 TYR A 186      93.371 103.879  47.894  1.00 18.95           C  
ATOM   1454  CE2 TYR A 186      93.869 101.994  49.317  1.00 20.14           C  
ATOM   1455  CZ  TYR A 186      94.070 103.321  48.960  1.00 20.17           C  
ATOM   1456  OH  TYR A 186      94.954 104.060  49.698  1.00 22.72           O  
ATOM   1457  N   SER A 187      92.925  98.288  46.166  1.00 19.96           N  
ATOM   1458  CA  SER A 187      94.076  97.462  46.559  1.00 23.59           C  
ATOM   1459  C   SER A 187      95.089  97.165  45.453  1.00 18.30           C  
ATOM   1460  O   SER A 187      96.171  96.677  45.735  1.00 22.81           O  
ATOM   1461  CB  SER A 187      93.602  96.153  47.213  1.00 28.20           C  
ATOM   1462  OG  SER A 187      93.055  95.269  46.247  1.00 35.77           O  
ATOM   1463  N   GLN A 188      94.717  97.425  44.202  1.00 16.69           N  
ATOM   1464  CA  GLN A 188      95.608  97.217  43.066  1.00 23.39           C  
ATOM   1465  C   GLN A 188      96.493  98.456  42.763  1.00 24.52           C  
ATOM   1466  O   GLN A 188      97.402  98.375  41.938  1.00 27.52           O  
ATOM   1467  CB  GLN A 188      94.804  96.856  41.803  1.00 29.58           C  
ATOM   1468  CG  GLN A 188      93.968  95.562  41.908  1.00 42.46           C  
ATOM   1469  CD  GLN A 188      94.741  94.378  42.501  1.00 49.25           C  
ATOM   1470  OE1 GLN A 188      95.906  94.142  42.168  1.00 53.11           O  
ATOM   1471  NE2 GLN A 188      94.086  93.631  43.388  1.00 53.11           N  
ATOM   1472  N   LEU A 189      96.203  99.601  43.387  1.00 18.76           N  
ATOM   1473  CA  LEU A 189      96.983 100.820  43.154  1.00 15.61           C  
ATOM   1474  C   LEU A 189      98.325 100.757  43.873  1.00 13.28           C  
ATOM   1475  O   LEU A 189      98.423 100.360  45.042  1.00 15.37           O  
ATOM   1476  CB  LEU A 189      96.234 102.053  43.648  1.00 15.64           C  
ATOM   1477  CG  LEU A 189      94.861 102.326  43.057  1.00 16.93           C  
ATOM   1478  CD1 LEU A 189      94.269 103.570  43.682  1.00 18.78           C  
ATOM   1479  CD2 LEU A 189      94.992 102.457  41.567  1.00 21.00           C  
ATOM   1480  N   PRO A 190      99.398 101.111  43.169  1.00 15.78           N  
ATOM   1481  CA  PRO A 190     100.678 101.054  43.882  1.00 18.27           C  
ATOM   1482  C   PRO A 190     100.870 102.339  44.701  1.00 19.22           C  
ATOM   1483  O   PRO A 190     100.218 103.355  44.426  1.00 16.27           O  
ATOM   1484  CB  PRO A 190     101.695 100.968  42.736  1.00 18.90           C  
ATOM   1485  CG  PRO A 190     101.021 101.795  41.622  1.00 18.44           C  
ATOM   1486  CD  PRO A 190      99.562 101.400  41.727  1.00 16.39           C  
ATOM   1487  N   GLU A 191     101.684 102.264  45.753  1.00 17.29           N  
ATOM   1488  CA  GLU A 191     102.023 103.442  46.552  1.00 21.55           C  
ATOM   1489  C   GLU A 191     102.834 104.376  45.613  1.00 19.64           C  
ATOM   1490  O   GLU A 191     103.547 103.910  44.727  1.00 18.87           O  
ATOM   1491  CB  GLU A 191     102.902 103.045  47.738  1.00 27.42           C  
ATOM   1492  CG  GLU A 191     102.219 102.160  48.747  1.00 37.74           C  
ATOM   1493  CD  GLU A 191     103.087 101.893  49.956  1.00 44.92           C  
ATOM   1494  OE1 GLU A 191     103.704 102.849  50.482  1.00 48.76           O  
ATOM   1495  OE2 GLU A 191     103.152 100.723  50.381  1.00 50.72           O  
ATOM   1496  N   SER A 192     102.672 105.681  45.764  1.00 16.36           N  
ATOM   1497  CA  SER A 192     103.389 106.616  44.910  1.00 13.74           C  
ATOM   1498  C   SER A 192     104.513 107.276  45.692  1.00 11.07           C  
ATOM   1499  O   SER A 192     104.508 107.278  46.933  1.00  9.04           O  
ATOM   1500  CB  SER A 192     102.439 107.684  44.370  1.00 10.18           C  
ATOM   1501  OG  SER A 192     102.007 108.580  45.390  1.00 13.85           O  
ATOM   1502  N   MET A 193     105.473 107.850  44.966  1.00 10.08           N  
ATOM   1503  CA  MET A 193     106.578 108.537  45.604  1.00 11.10           C  
ATOM   1504  C   MET A 193     106.064 109.752  46.431  1.00  8.70           C  
ATOM   1505  O   MET A 193     106.445 109.919  47.579  1.00  9.84           O  
ATOM   1506  CB  MET A 193     107.632 108.920  44.546  1.00 10.63           C  
ATOM   1507  CG  MET A 193     108.846 109.700  45.084  1.00 11.22           C  
ATOM   1508  SD  MET A 193     108.496 111.452  45.331  1.00 11.71           S  
ATOM   1509  CE  MET A 193     108.395 111.913  43.666  1.00 10.93           C  
ATOM   1510  N   PRO A 194     105.182 110.605  45.866  1.00  8.72           N  
ATOM   1511  CA  PRO A 194     104.721 111.733  46.696  1.00  7.56           C  
ATOM   1512  C   PRO A 194     103.982 111.268  47.966  1.00  8.75           C  
ATOM   1513  O   PRO A 194     104.134 111.852  49.043  1.00  6.30           O  
ATOM   1514  CB  PRO A 194     103.839 112.540  45.728  1.00  6.12           C  
ATOM   1515  CG  PRO A 194     104.513 112.314  44.416  1.00  6.09           C  
ATOM   1516  CD  PRO A 194     104.784 110.793  44.462  1.00  6.26           C  
ATOM   1517  N   GLU A 195     103.207 110.193  47.853  1.00  8.75           N  
ATOM   1518  CA  GLU A 195     102.519 109.642  49.025  1.00  8.72           C  
ATOM   1519  C   GLU A 195     103.530 109.247  50.122  1.00  7.87           C  
ATOM   1520  O   GLU A 195     103.340 109.560  51.281  1.00 10.44           O  
ATOM   1521  CB  GLU A 195     101.726 108.378  48.629  1.00 10.66           C  
ATOM   1522  CG  GLU A 195     101.169 107.640  49.867  1.00 13.27           C  
ATOM   1523  CD  GLU A 195     100.592 106.273  49.568  1.00 14.94           C  
ATOM   1524  OE1 GLU A 195     100.566 105.839  48.387  1.00 12.11           O  
ATOM   1525  OE2 GLU A 195     100.156 105.638  50.553  1.00 18.95           O  
ATOM   1526  N   GLN A 196     104.575 108.510  49.745  1.00  9.66           N  
ATOM   1527  CA  GLN A 196     105.602 108.052  50.684  1.00 10.95           C  
ATOM   1528  C   GLN A 196     106.426 109.177  51.281  1.00 12.61           C  
ATOM   1529  O   GLN A 196     106.774 109.136  52.456  1.00 12.04           O  
ATOM   1530  CB  GLN A 196     106.539 107.081  49.992  1.00 13.08           C  
ATOM   1531  CG  GLN A 196     105.839 105.824  49.524  1.00 24.91           C  
ATOM   1532  CD  GLN A 196     106.770 104.898  48.769  1.00 32.01           C  
ATOM   1533  OE1 GLN A 196     107.552 105.325  47.904  1.00 35.85           O  
ATOM   1534  NE2 GLN A 196     106.691 103.618  49.090  1.00 37.79           N  
ATOM   1535  N   ALA A 197     106.786 110.144  50.447  1.00 11.53           N  
ATOM   1536  CA  ALA A 197     107.556 111.301  50.895  1.00  7.47           C  
ATOM   1537  C   ALA A 197     106.758 112.167  51.883  1.00  8.00           C  
ATOM   1538  O   ALA A 197     107.240 112.507  52.957  1.00  9.93           O  
ATOM   1539  CB  ALA A 197     108.003 112.128  49.640  1.00  7.48           C  
ATOM   1540  N   GLU A 198     105.509 112.485  51.541  1.00  9.74           N  
ATOM   1541  CA  GLU A 198     104.657 113.344  52.378  1.00  8.82           C  
ATOM   1542  C   GLU A 198     103.925 112.616  53.493  1.00 11.33           C  
ATOM   1543  O   GLU A 198     103.485 113.237  54.470  1.00 12.25           O  
ATOM   1544  CB  GLU A 198     103.592 114.020  51.503  1.00 11.70           C  
ATOM   1545  CG  GLU A 198     104.120 114.915  50.370  1.00 11.69           C  
ATOM   1546  CD  GLU A 198     103.745 116.370  50.560  1.00  9.94           C  
ATOM   1547  OE1 GLU A 198     103.266 116.726  51.656  1.00  8.42           O  
ATOM   1548  OE2 GLU A 198     103.942 117.155  49.621  1.00  9.55           O  
ATOM   1549  N   SER A 199     103.753 111.308  53.313  1.00 11.41           N  
ATOM   1550  CA  SER A 199     103.003 110.476  54.255  1.00 13.14           C  
ATOM   1551  C   SER A 199     101.537 110.959  54.209  1.00 11.31           C  
ATOM   1552  O   SER A 199     100.951 111.341  55.221  1.00 13.41           O  
ATOM   1553  CB  SER A 199     103.602 110.581  55.667  1.00 16.88           C  
ATOM   1554  OG  SER A 199     103.199 109.490  56.471  1.00 24.24           O  
ATOM   1555  N   LEU A 200     100.981 110.998  52.998  1.00 10.18           N  
ATOM   1556  CA  LEU A 200      99.584 111.430  52.753  1.00 10.28           C  
ATOM   1557  C   LEU A 200      98.967 110.389  51.830  1.00 12.68           C  
ATOM   1558  O   LEU A 200      99.249 110.337  50.622  1.00  8.58           O  
ATOM   1559  CB  LEU A 200      99.504 112.820  52.088  1.00  9.06           C  
ATOM   1560  CG  LEU A 200      99.918 114.036  52.928  1.00 10.04           C  
ATOM   1561  CD1 LEU A 200      99.942 115.322  52.060  1.00  9.12           C  
ATOM   1562  CD2 LEU A 200      98.980 114.167  54.132  1.00 10.19           C  
ATOM   1563  N   GLU A 201      98.116 109.550  52.410  1.00 11.46           N  
ATOM   1564  CA  GLU A 201      97.503 108.471  51.660  1.00 14.58           C  
ATOM   1565  C   GLU A 201      96.685 108.886  50.458  1.00 10.13           C  
ATOM   1566  O   GLU A 201      96.672 108.176  49.447  1.00 11.75           O  
ATOM   1567  CB  GLU A 201      96.643 107.608  52.580  1.00 20.17           C  
ATOM   1568  CG  GLU A 201      96.562 106.178  52.070  1.00 35.91           C  
ATOM   1569  CD  GLU A 201      95.560 105.300  52.815  1.00 44.06           C  
ATOM   1570  OE1 GLU A 201      95.087 105.681  53.915  1.00 47.80           O  
ATOM   1571  OE2 GLU A 201      95.254 104.204  52.283  1.00 47.84           O  
ATOM   1572  N   GLN A 202      96.036 110.045  50.530  1.00 11.22           N  
ATOM   1573  CA  GLN A 202      95.215 110.506  49.412  1.00  9.37           C  
ATOM   1574  C   GLN A 202      96.005 110.726  48.106  1.00 10.56           C  
ATOM   1575  O   GLN A 202      95.434 110.707  47.018  1.00  8.50           O  
ATOM   1576  CB  GLN A 202      94.401 111.756  49.790  1.00 12.90           C  
ATOM   1577  CG  GLN A 202      95.219 113.022  50.132  1.00 11.03           C  
ATOM   1578  CD  GLN A 202      95.600 113.104  51.593  1.00 13.46           C  
ATOM   1579  OE1 GLN A 202      96.063 112.140  52.179  1.00 15.94           O  
ATOM   1580  NE2 GLN A 202      95.420 114.278  52.188  1.00 12.67           N  
ATOM   1581  N   LEU A 203      97.322 110.897  48.208  1.00 10.06           N  
ATOM   1582  CA  LEU A 203      98.136 111.096  47.019  1.00  8.58           C  
ATOM   1583  C   LEU A 203      98.220 109.813  46.222  1.00  9.40           C  
ATOM   1584  O   LEU A 203      98.570 109.856  45.050  1.00  8.81           O  
ATOM   1585  CB  LEU A 203      99.535 111.635  47.374  1.00  9.21           C  
ATOM   1586  CG  LEU A 203      99.523 113.058  47.961  1.00 10.94           C  
ATOM   1587  CD1 LEU A 203     100.951 113.518  48.338  1.00  8.01           C  
ATOM   1588  CD2 LEU A 203      98.881 114.020  46.951  1.00  6.75           C  
ATOM   1589  N   ARG A 204      97.887 108.668  46.834  1.00 10.13           N  
ATOM   1590  CA  ARG A 204      97.916 107.410  46.074  1.00 10.59           C  
ATOM   1591  C   ARG A 204      96.862 107.482  44.966  1.00  9.26           C  
ATOM   1592  O   ARG A 204      97.084 107.012  43.841  1.00 10.41           O  
ATOM   1593  CB  ARG A 204      97.619 106.183  46.945  1.00 10.92           C  
ATOM   1594  CG  ARG A 204      97.806 104.876  46.171  1.00 13.40           C  
ATOM   1595  CD  ARG A 204      97.654 103.647  47.050  1.00 10.88           C  
ATOM   1596  NE  ARG A 204      98.431 103.775  48.283  1.00 12.38           N  
ATOM   1597  CZ  ARG A 204      98.388 102.909  49.288  1.00 18.58           C  
ATOM   1598  NH1 ARG A 204      97.615 101.835  49.202  1.00 16.61           N  
ATOM   1599  NH2 ARG A 204      99.044 103.161  50.413  1.00 15.94           N  
ATOM   1600  N   LEU A 205      95.724 108.091  45.281  1.00  8.28           N  
ATOM   1601  CA  LEU A 205      94.632 108.230  44.315  1.00  9.77           C  
ATOM   1602  C   LEU A 205      95.021 109.163  43.160  1.00 12.66           C  
ATOM   1603  O   LEU A 205      94.745 108.877  41.983  1.00  9.66           O  
ATOM   1604  CB  LEU A 205      93.386 108.782  45.011  1.00 10.08           C  
ATOM   1605  CG  LEU A 205      92.775 107.854  46.072  1.00 13.01           C  
ATOM   1606  CD1 LEU A 205      91.715 108.629  46.854  1.00 11.73           C  
ATOM   1607  CD2 LEU A 205      92.172 106.619  45.423  1.00 14.33           C  
ATOM   1608  N   MET A 206      95.647 110.285  43.511  1.00 10.93           N  
ATOM   1609  CA  MET A 206      96.066 111.262  42.523  1.00 10.81           C  
ATOM   1610  C   MET A 206      97.114 110.705  41.582  1.00  8.84           C  
ATOM   1611  O   MET A 206      97.116 111.024  40.392  1.00  9.12           O  
ATOM   1612  CB  MET A 206      96.545 112.525  43.220  1.00 10.50           C  
ATOM   1613  CG  MET A 206      95.441 113.145  44.034  1.00 14.77           C  
ATOM   1614  SD  MET A 206      95.913 114.765  44.557  1.00 23.73           S  
ATOM   1615  CE  MET A 206      95.394 115.687  43.086  1.00 16.08           C  
ATOM   1616  N   ASN A 207      97.970 109.824  42.096  1.00  9.88           N  
ATOM   1617  CA  ASN A 207      99.000 109.197  41.267  1.00  9.81           C  
ATOM   1618  C   ASN A 207      98.373 108.419  40.110  1.00  9.67           C  
ATOM   1619  O   ASN A 207      98.905 108.382  38.994  1.00 12.11           O  
ATOM   1620  CB  ASN A 207      99.846 108.232  42.103  1.00  7.96           C  
ATOM   1621  CG  ASN A 207     101.029 107.682  41.322  1.00 14.41           C  
ATOM   1622  OD1 ASN A 207     101.807 108.445  40.746  1.00 13.70           O  
ATOM   1623  ND2 ASN A 207     101.133 106.355  41.245  1.00 12.84           N  
ATOM   1624  N   ALA A 208      97.243 107.783  40.406  1.00 12.96           N  
ATOM   1625  CA  ALA A 208      96.518 106.961  39.439  1.00 15.01           C  
ATOM   1626  C   ALA A 208      95.536 107.752  38.571  1.00 14.96           C  
ATOM   1627  O   ALA A 208      94.788 107.171  37.793  1.00 15.74           O  
ATOM   1628  CB  ALA A 208      95.786 105.837  40.176  1.00 15.52           C  
ATOM   1629  N   GLY A 209      95.510 109.069  38.734  1.00 13.28           N  
ATOM   1630  CA  GLY A 209      94.625 109.891  37.921  1.00 12.39           C  
ATOM   1631  C   GLY A 209      93.172 109.909  38.368  1.00 15.14           C  
ATOM   1632  O   GLY A 209      92.281 110.241  37.583  1.00 17.40           O  
ATOM   1633  N   ILE A 210      92.918 109.538  39.619  1.00 12.30           N  
ATOM   1634  CA  ILE A 210      91.557 109.535  40.141  1.00 11.00           C  
ATOM   1635  C   ILE A 210      91.281 110.934  40.701  1.00 14.11           C  
ATOM   1636  O   ILE A 210      91.985 111.420  41.585  1.00 15.23           O  
ATOM   1637  CB  ILE A 210      91.390 108.469  41.233  1.00  9.18           C  
ATOM   1638  CG1 ILE A 210      91.521 107.075  40.610  1.00 13.34           C  
ATOM   1639  CG2 ILE A 210      90.038 108.638  41.946  1.00 11.99           C  
ATOM   1640  CD1 ILE A 210      91.858 105.995  41.613  1.00 16.42           C  
ATOM   1641  N   ASN A 211      90.257 111.577  40.163  1.00 12.96           N  
ATOM   1642  CA  ASN A 211      89.898 112.921  40.572  1.00 14.30           C  
ATOM   1643  C   ASN A 211      89.283 113.027  41.958  1.00 15.62           C  
ATOM   1644  O   ASN A 211      88.436 112.225  42.340  1.00 16.20           O  
ATOM   1645  CB  ASN A 211      88.944 113.543  39.551  1.00 16.75           C  
ATOM   1646  CG  ASN A 211      88.623 114.988  39.870  1.00 23.06           C  
ATOM   1647  OD1 ASN A 211      89.527 115.803  40.041  1.00 22.22           O  
ATOM   1648  ND2 ASN A 211      87.329 115.302  39.991  1.00 22.42           N  
ATOM   1649  N   ILE A 212      89.727 114.026  42.715  1.00 11.72           N  
ATOM   1650  CA  ILE A 212      89.198 114.251  44.047  1.00 12.22           C  
ATOM   1651  C   ILE A 212      88.664 115.683  44.074  1.00 14.70           C  
ATOM   1652  O   ILE A 212      89.439 116.632  43.903  1.00 14.30           O  
ATOM   1653  CB  ILE A 212      90.282 114.096  45.125  1.00  7.60           C  
ATOM   1654  CG1 ILE A 212      90.913 112.702  45.083  1.00  9.74           C  
ATOM   1655  CG2 ILE A 212      89.701 114.422  46.510  1.00 10.23           C  
ATOM   1656  CD1 ILE A 212      92.102 112.566  46.063  1.00 10.26           C  
ATOM   1657  N   ARG A 213      87.343 115.838  44.189  1.00 10.65           N  
ATOM   1658  CA  ARG A 213      86.753 117.166  44.260  1.00 11.90           C  
ATOM   1659  C   ARG A 213      86.731 117.581  45.721  1.00 13.95           C  
ATOM   1660  O   ARG A 213      86.343 116.809  46.588  1.00 13.55           O  
ATOM   1661  CB  ARG A 213      85.366 117.209  43.631  1.00 12.78           C  
ATOM   1662  CG  ARG A 213      84.789 118.627  43.589  1.00 16.18           C  
ATOM   1663  CD  ARG A 213      83.750 118.789  42.482  1.00 16.24           C  
ATOM   1664  NE  ARG A 213      84.333 118.537  41.164  1.00 16.77           N  
ATOM   1665  CZ  ARG A 213      83.717 117.918  40.163  1.00 21.37           C  
ATOM   1666  NH1 ARG A 213      82.462 117.480  40.306  1.00 19.26           N  
ATOM   1667  NH2 ARG A 213      84.380 117.689  39.031  1.00 17.42           N  
ATOM   1668  N   THR A 214      87.144 118.815  45.993  1.00 15.07           N  
ATOM   1669  CA  THR A 214      87.264 119.311  47.359  1.00 16.81           C  
ATOM   1670  C   THR A 214      86.362 120.502  47.615  1.00 21.69           C  
ATOM   1671  O   THR A 214      86.705 121.611  47.195  1.00 26.57           O  
ATOM   1672  CB  THR A 214      88.771 119.706  47.645  1.00 17.39           C  
ATOM   1673  OG1 THR A 214      89.628 118.632  47.250  1.00 21.75           O  
ATOM   1674  CG2 THR A 214      89.021 119.930  49.115  1.00 20.89           C  
ATOM   1675  N   PHE A 215      85.267 120.272  48.355  1.00 16.08           N  
ATOM   1676  CA  PHE A 215      84.266 121.292  48.720  1.00 18.33           C  
ATOM   1677  C   PHE A 215      84.616 122.149  49.931  1.00 18.17           C  
ATOM   1678  O   PHE A 215      84.947 121.645  51.003  1.00 17.34           O  
ATOM   1679  CB  PHE A 215      82.899 120.652  48.979  1.00 18.61           C  
ATOM   1680  CG  PHE A 215      82.380 119.865  47.823  1.00 19.44           C  
ATOM   1681  CD1 PHE A 215      81.623 120.478  46.835  1.00 21.82           C  
ATOM   1682  CD2 PHE A 215      82.676 118.514  47.708  1.00 15.18           C  
ATOM   1683  CE1 PHE A 215      81.170 119.758  45.744  1.00 23.25           C  
ATOM   1684  CE2 PHE A 215      82.225 117.783  46.617  1.00 19.31           C  
ATOM   1685  CZ  PHE A 215      81.471 118.406  45.631  1.00 18.88           C  
ATOM   1686  N   GLU A 216      84.449 123.458  49.776  1.00 21.28           N  
ATOM   1687  CA  GLU A 216      84.762 124.388  50.850  1.00 21.38           C  
ATOM   1688  C   GLU A 216      83.620 124.600  51.855  1.00 21.16           C  
ATOM   1689  O   GLU A 216      82.481 124.825  51.459  1.00 23.53           O  
ATOM   1690  CB  GLU A 216      85.198 125.735  50.250  1.00 20.28           C  
ATOM   1691  CG  GLU A 216      85.759 126.669  51.294  1.00 20.61           C  
ATOM   1692  CD  GLU A 216      86.206 128.004  50.746  1.00 22.94           C  
ATOM   1693  OE1 GLU A 216      86.491 128.133  49.542  1.00 20.68           O  
ATOM   1694  OE2 GLU A 216      86.282 128.936  51.554  1.00 26.40           O  
ATOM   1695  N   VAL A 217      83.937 124.511  53.150  1.00 20.31           N  
ATOM   1696  CA  VAL A 217      82.966 124.740  54.228  1.00 21.95           C  
ATOM   1697  C   VAL A 217      83.574 125.737  55.220  1.00 25.20           C  
ATOM   1698  O   VAL A 217      84.715 126.164  55.037  1.00 20.59           O  
ATOM   1699  CB  VAL A 217      82.586 123.428  54.968  1.00 21.72           C  
ATOM   1700  CG1 VAL A 217      81.915 122.467  54.000  1.00 21.72           C  
ATOM   1701  CG2 VAL A 217      83.804 122.799  55.642  1.00 17.19           C  
ATOM   1702  N   ALA A 218      82.822 126.118  56.257  1.00 28.43           N  
ATOM   1703  CA  ALA A 218      83.318 127.058  57.274  1.00 27.91           C  
ATOM   1704  C   ALA A 218      84.362 126.376  58.177  1.00 30.95           C  
ATOM   1705  O   ALA A 218      84.438 125.145  58.208  1.00 29.42           O  
ATOM   1706  CB  ALA A 218      82.160 127.577  58.101  1.00 26.89           C  
ATOM   1707  N   ALA A 219      85.187 127.163  58.876  1.00 30.48           N  
ATOM   1708  CA  ALA A 219      86.201 126.598  59.769  1.00 36.91           C  
ATOM   1709  C   ALA A 219      85.518 125.612  60.721  1.00 41.76           C  
ATOM   1710  O   ALA A 219      84.506 125.940  61.340  1.00 41.64           O  
ATOM   1711  CB  ALA A 219      86.908 127.705  60.559  1.00 34.82           C  
ATOM   1712  N   THR A 220      86.041 124.393  60.792  1.00 46.69           N  
ATOM   1713  CA  THR A 220      85.461 123.358  61.636  1.00 53.81           C  
ATOM   1714  C   THR A 220      85.877 123.499  63.099  1.00 60.78           C  
ATOM   1715  O   THR A 220      86.644 124.401  63.451  1.00 61.55           O  
ATOM   1716  CB  THR A 220      85.825 121.943  61.114  1.00 52.49           C  
ATOM   1717  OG1 THR A 220      87.249 121.797  61.078  1.00 50.74           O  
ATOM   1718  CG2 THR A 220      85.248 121.711  59.704  1.00 50.00           C  
ATOM   1719  N   GLY A 221      85.323 122.632  63.949  1.00 67.76           N  
ATOM   1720  CA  GLY A 221      85.642 122.649  65.368  1.00 75.03           C  
ATOM   1721  C   GLY A 221      86.948 121.929  65.643  1.00 80.31           C  
ATOM   1722  O   GLY A 221      87.383 121.119  64.825  1.00 80.43           O  
ATOM   1723  N   PRO A 222      87.610 122.204  66.779  1.00 85.04           N  
ATOM   1724  CA  PRO A 222      88.875 121.529  67.084  1.00 88.30           C  
ATOM   1725  C   PRO A 222      88.720 120.012  67.314  1.00 90.87           C  
ATOM   1726  O   PRO A 222      87.913 119.569  68.141  1.00 90.90           O  
ATOM   1727  CB  PRO A 222      89.367 122.280  68.329  1.00 87.77           C  
ATOM   1728  CG  PRO A 222      88.093 122.686  69.005  1.00 87.15           C  
ATOM   1729  CD  PRO A 222      87.259 123.166  67.840  1.00 86.50           C  
ATOM   1730  N   GLY A 223      89.412 119.230  66.485  1.00 93.14           N  
ATOM   1731  CA  GLY A 223      89.380 117.782  66.610  1.00 96.07           C  
ATOM   1732  C   GLY A 223      90.236 117.392  67.803  1.00 98.02           C  
ATOM   1733  O   GLY A 223      91.187 118.103  68.143  1.00 98.85           O  
ATOM   1734  N   VAL A 224      89.905 116.280  68.455  1.00 98.78           N  
ATOM   1735  CA  VAL A 224      90.663 115.851  69.627  1.00 98.99           C  
ATOM   1736  C   VAL A 224      91.900 115.027  69.297  1.00 99.30           C  
ATOM   1737  O   VAL A 224      91.802 113.910  68.788  1.00 99.35           O  
ATOM   1738  CB  VAL A 224      89.774 115.092  70.634  1.00 98.89           C  
ATOM   1739  CG1 VAL A 224      90.574 114.736  71.882  1.00 99.15           C  
ATOM   1740  CG2 VAL A 224      88.557 115.936  70.998  1.00 98.50           C  
ATOM   1741  N   ASP A 225      93.063 115.583  69.634  1.00 99.99           N  
ATOM   1742  CA  ASP A 225      94.363 114.948  69.400  1.00100.00           C  
ATOM   1743  C   ASP A 225      95.237 115.091  70.655  1.00 99.84           C  
ATOM   1744  O   ASP A 225      95.868 114.131  71.106  1.00 99.14           O  
ATOM   1745  CB  ASP A 225      95.062 115.619  68.205  1.00100.00           C  
ATOM   1746  CG  ASP A 225      95.460 114.633  67.110  1.00100.00           C  
ATOM   1747  OD1 ASP A 225      94.968 113.477  67.116  1.00100.00           O  
ATOM   1748  OD2 ASP A 225      96.257 115.027  66.230  1.00100.00           O  
ATOM   1749  N   THR A 226      95.244 116.299  71.217  1.00100.00           N  
ATOM   1750  CA  THR A 226      96.021 116.626  72.418  1.00100.00           C  
ATOM   1751  C   THR A 226      95.077 117.011  73.581  1.00100.00           C  
ATOM   1752  O   THR A 226      93.968 117.507  73.339  1.00100.00           O  
ATOM   1753  CB  THR A 226      97.016 117.803  72.115  1.00100.00           C  
ATOM   1754  OG1 THR A 226      97.879 118.033  73.237  1.00100.00           O  
ATOM   1755  CG2 THR A 226      96.266 119.093  71.801  1.00 99.45           C  
ATOM   1756  N   PRO A 227      95.480 116.732  74.847  1.00100.00           N  
ATOM   1757  CA  PRO A 227      94.702 117.039  76.065  1.00100.00           C  
ATOM   1758  C   PRO A 227      94.505 118.537  76.365  1.00 99.58           C  
ATOM   1759  O   PRO A 227      93.743 118.905  77.262  1.00 99.16           O  
ATOM   1760  CB  PRO A 227      95.496 116.332  77.171  1.00100.00           C  
ATOM   1761  CG  PRO A 227      96.901 116.344  76.644  1.00100.00           C  
ATOM   1762  CD  PRO A 227      96.687 115.958  75.194  1.00100.00           C  
ATOM   1763  N   ALA A 228      95.231 119.389  75.646  1.00 99.60           N  
ATOM   1764  CA  ALA A 228      95.096 120.832  75.801  1.00 99.93           C  
ATOM   1765  C   ALA A 228      93.856 121.227  74.989  1.00100.00           C  
ATOM   1766  O   ALA A 228      93.124 122.150  75.360  1.00100.00           O  
ATOM   1767  CB  ALA A 228      96.342 121.548  75.273  1.00 99.41           C  
ATOM   1768  N   CYS A 229      93.624 120.494  73.895  1.00 99.80           N  
ATOM   1769  CA  CYS A 229      92.478 120.706  73.004  1.00 98.92           C  
ATOM   1770  C   CYS A 229      91.268 119.849  73.405  1.00 97.40           C  
ATOM   1771  O   CYS A 229      90.154 120.075  72.927  1.00 98.21           O  
ATOM   1772  CB  CYS A 229      92.853 120.404  71.544  1.00 99.70           C  
ATOM   1773  SG  CYS A 229      93.939 121.611  70.722  1.00100.00           S  
ATOM   1774  N   LEU A 230      91.502 118.837  74.242  1.00 94.63           N  
ATOM   1775  CA  LEU A 230      90.431 117.961  74.721  1.00 91.07           C  
ATOM   1776  C   LEU A 230      89.531 118.758  75.667  1.00 89.00           C  
ATOM   1777  O   LEU A 230      88.304 118.619  75.628  1.00 88.66           O  
ATOM   1778  CB  LEU A 230      91.017 116.735  75.440  1.00 90.29           C  
ATOM   1779  CG  LEU A 230      90.085 115.775  76.191  1.00 89.08           C  
ATOM   1780  CD1 LEU A 230      88.989 115.246  75.279  1.00 89.25           C  
ATOM   1781  CD2 LEU A 230      90.896 114.630  76.768  1.00 88.00           C  
ATOM   1782  N   GLU A 231      90.156 119.602  76.493  1.00 85.33           N  
ATOM   1783  CA  GLU A 231      89.442 120.453  77.447  1.00 81.73           C  
ATOM   1784  C   GLU A 231      88.683 121.549  76.693  1.00 77.81           C  
ATOM   1785  O   GLU A 231      87.635 122.014  77.148  1.00 76.01           O  
ATOM   1786  CB  GLU A 231      90.411 121.092  78.457  1.00 84.55           C  
ATOM   1787  CG  GLU A 231      91.368 120.125  79.168  1.00 87.03           C  
ATOM   1788  CD  GLU A 231      90.673 118.973  79.883  1.00 88.49           C  
ATOM   1789  OE1 GLU A 231      89.626 119.192  80.536  1.00 89.39           O  
ATOM   1790  OE2 GLU A 231      91.191 117.839  79.800  1.00 89.35           O  
ATOM   1791  N   LYS A 232      89.230 121.965  75.547  1.00 73.80           N  
ATOM   1792  CA  LYS A 232      88.595 122.983  74.709  1.00 70.35           C  
ATOM   1793  C   LYS A 232      87.312 122.384  74.114  1.00 65.09           C  
ATOM   1794  O   LYS A 232      86.282 123.059  74.016  1.00 63.46           O  
ATOM   1795  CB  LYS A 232      89.553 123.458  73.597  1.00 73.05           C  
ATOM   1796  CG  LYS A 232      88.962 124.540  72.681  1.00 78.03           C  
ATOM   1797  CD  LYS A 232      90.027 125.440  72.048  1.00 82.14           C  
ATOM   1798  CE  LYS A 232      90.432 124.985  70.651  1.00 85.80           C  
ATOM   1799  NZ  LYS A 232      91.106 123.657  70.639  1.00 87.60           N  
ATOM   1800  N   VAL A 233      87.379 121.105  73.746  1.00 58.84           N  
ATOM   1801  CA  VAL A 233      86.226 120.404  73.200  1.00 53.92           C  
ATOM   1802  C   VAL A 233      85.196 120.148  74.311  1.00 50.58           C  
ATOM   1803  O   VAL A 233      83.997 120.335  74.090  1.00 48.47           O  
ATOM   1804  CB  VAL A 233      86.639 119.084  72.503  1.00 53.79           C  
ATOM   1805  CG1 VAL A 233      85.407 118.252  72.152  1.00 53.00           C  
ATOM   1806  CG2 VAL A 233      87.413 119.406  71.232  1.00 52.76           C  
ATOM   1807  N   ARG A 234      85.660 119.771  75.506  1.00 48.35           N  
ATOM   1808  CA  ARG A 234      84.758 119.529  76.641  1.00 48.01           C  
ATOM   1809  C   ARG A 234      83.984 120.795  76.983  1.00 48.50           C  
ATOM   1810  O   ARG A 234      82.760 120.754  77.172  1.00 47.55           O  
ATOM   1811  CB  ARG A 234      85.515 119.043  77.881  1.00 48.16           C  
ATOM   1812  CG  ARG A 234      85.805 117.552  77.875  1.00 50.92           C  
ATOM   1813  CD  ARG A 234      86.328 117.085  79.214  1.00 54.62           C  
ATOM   1814  NE  ARG A 234      86.480 115.635  79.239  1.00 59.38           N  
ATOM   1815  CZ  ARG A 234      87.652 115.004  79.259  1.00 63.53           C  
ATOM   1816  NH1 ARG A 234      88.780 115.703  79.260  1.00 66.74           N  
ATOM   1817  NH2 ARG A 234      87.700 113.674  79.274  1.00 65.33           N  
ATOM   1818  N   ALA A 235      84.699 121.920  77.030  1.00 47.21           N  
ATOM   1819  CA  ALA A 235      84.091 123.217  77.327  1.00 47.22           C  
ATOM   1820  C   ALA A 235      83.149 123.661  76.198  1.00 46.78           C  
ATOM   1821  O   ALA A 235      82.032 124.137  76.453  1.00 44.49           O  
ATOM   1822  CB  ALA A 235      85.185 124.269  77.556  1.00 46.98           C  
ATOM   1823  N   LEU A 236      83.603 123.467  74.958  1.00 46.69           N  
ATOM   1824  CA  LEU A 236      82.860 123.839  73.752  1.00 48.88           C  
ATOM   1825  C   LEU A 236      81.589 123.009  73.541  1.00 49.81           C  
ATOM   1826  O   LEU A 236      80.556 123.537  73.108  1.00 47.84           O  
ATOM   1827  CB  LEU A 236      83.785 123.721  72.531  1.00 50.71           C  
ATOM   1828  CG  LEU A 236      84.093 124.948  71.658  1.00 52.44           C  
ATOM   1829  CD1 LEU A 236      83.956 126.259  72.440  1.00 53.95           C  
ATOM   1830  CD2 LEU A 236      85.492 124.799  71.073  1.00 50.19           C  
ATOM   1831  N   MET A 237      81.674 121.716  73.857  1.00 51.67           N  
ATOM   1832  CA  MET A 237      80.542 120.800  73.719  1.00 55.25           C  
ATOM   1833  C   MET A 237      79.509 121.066  74.813  1.00 56.06           C  
ATOM   1834  O   MET A 237      78.309 120.904  74.577  1.00 56.28           O  
ATOM   1835  CB  MET A 237      81.010 119.343  73.800  1.00 57.91           C  
ATOM   1836  CG  MET A 237      80.078 118.339  73.125  1.00 61.24           C  
ATOM   1837  SD  MET A 237      80.621 117.938  71.450  1.00 64.98           S  
ATOM   1838  CE  MET A 237      81.833 116.704  71.795  1.00 61.78           C  
ATOM   1839  N   ALA A 238      79.988 121.455  76.002  1.00 57.27           N  
ATOM   1840  CA  ALA A 238      79.140 121.773  77.163  1.00 59.40           C  
ATOM   1841  C   ALA A 238      78.432 123.120  76.985  1.00 60.57           C  
ATOM   1842  O   ALA A 238      77.284 123.290  77.400  1.00 59.27           O  
ATOM   1843  CB  ALA A 238      79.970 121.786  78.443  1.00 57.96           C  
ATOM   1844  N   GLN A 239      79.142 124.077  76.390  1.00 63.62           N  
ATOM   1845  CA  GLN A 239      78.605 125.407  76.118  1.00 67.54           C  
ATOM   1846  C   GLN A 239      77.511 125.277  75.047  1.00 69.60           C  
ATOM   1847  O   GLN A 239      76.568 126.072  75.009  1.00 69.49           O  
ATOM   1848  CB  GLN A 239      79.745 126.325  75.638  1.00 69.23           C  
ATOM   1849  CG  GLN A 239      79.380 127.792  75.383  1.00 71.45           C  
ATOM   1850  CD  GLN A 239      78.943 128.070  73.952  1.00 72.16           C  
ATOM   1851  OE1 GLN A 239      79.580 127.619  72.991  1.00 73.16           O  
ATOM   1852  NE2 GLN A 239      77.858 128.825  73.804  1.00 71.78           N  
ATOM   1853  N   GLU A 240      77.641 124.247  74.205  1.00 72.51           N  
ATOM   1854  CA  GLU A 240      76.692 123.965  73.129  1.00 75.03           C  
ATOM   1855  C   GLU A 240      75.383 123.337  73.635  1.00 76.26           C  
ATOM   1856  O   GLU A 240      74.315 123.606  73.076  1.00 75.61           O  
ATOM   1857  CB  GLU A 240      77.343 123.068  72.074  1.00 75.61           C  
ATOM   1858  CG  GLU A 240      76.558 122.975  70.775  1.00 78.39           C  
ATOM   1859  CD  GLU A 240      77.302 122.222  69.683  1.00 80.94           C  
ATOM   1860  OE1 GLU A 240      76.637 121.523  68.890  1.00 80.83           O  
ATOM   1861  OE2 GLU A 240      78.549 122.334  69.607  1.00 83.31           O  
ATOM   1862  N   LEU A 241      75.474 122.504  74.679  1.00 78.36           N  
ATOM   1863  CA  LEU A 241      74.298 121.851  75.288  1.00 80.87           C  
ATOM   1864  C   LEU A 241      73.410 122.861  76.024  1.00 82.84           C  
ATOM   1865  O   LEU A 241      72.184 122.710  76.073  1.00 83.02           O  
ATOM   1866  CB  LEU A 241      74.715 120.750  76.276  1.00 79.66           C  
ATOM   1867  CG  LEU A 241      75.173 119.389  75.744  1.00 80.16           C  
ATOM   1868  CD1 LEU A 241      75.520 118.486  76.918  1.00 79.79           C  
ATOM   1869  CD2 LEU A 241      74.084 118.747  74.889  1.00 79.42           C  
ATOM   1870  N   ALA A 242      74.049 123.870  76.617  1.00 84.75           N  
ATOM   1871  CA  ALA A 242      73.359 124.929  77.350  1.00 86.50           C  
ATOM   1872  C   ALA A 242      72.755 125.976  76.397  1.00 87.77           C  
ATOM   1873  O   ALA A 242      71.792 126.663  76.749  1.00 88.14           O  
ATOM   1874  CB  ALA A 242      74.325 125.592  78.330  1.00 85.79           C  
ATOM   1875  N   GLU A 243      73.321 126.078  75.193  1.00 88.69           N  
ATOM   1876  CA  GLU A 243      72.861 127.026  74.175  1.00 89.47           C  
ATOM   1877  C   GLU A 243      71.606 126.535  73.443  1.00 90.55           C  
ATOM   1878  O   GLU A 243      70.795 127.341  72.969  1.00 91.35           O  
ATOM   1879  CB  GLU A 243      73.979 127.292  73.157  1.00 88.60           C  
ATOM   1880  CG  GLU A 243      73.628 128.339  72.105  1.00 87.42           C  
ATOM   1881  CD  GLU A 243      74.668 128.449  71.011  1.00 86.80           C  
ATOM   1882  OE1 GLU A 243      75.325 127.430  70.700  1.00 85.89           O  
ATOM   1883  OE2 GLU A 243      74.818 129.558  70.455  1.00 86.86           O  
ATOM   1884  N   ASN A 244      71.463 125.217  73.336  1.00 91.24           N  
ATOM   1885  CA  ASN A 244      70.313 124.617  72.666  1.00 91.68           C  
ATOM   1886  C   ASN A 244      69.307 124.072  73.690  1.00 90.45           C  
ATOM   1887  O   ASN A 244      68.846 122.930  73.588  1.00 90.95           O  
ATOM   1888  CB  ASN A 244      70.781 123.514  71.701  1.00 93.57           C  
ATOM   1889  CG  ASN A 244      71.767 124.031  70.649  1.00 94.94           C  
ATOM   1890  OD1 ASN A 244      71.482 124.988  69.921  1.00 95.78           O  
ATOM   1891  ND2 ASN A 244      72.935 123.401  70.578  1.00 95.07           N  
ATOM   1892  N   ALA A 245      68.973 124.920  74.664  1.00 89.22           N  
ATOM   1893  CA  ALA A 245      68.036 124.596  75.745  1.00 88.65           C  
ATOM   1894  C   ALA A 245      66.632 125.202  75.550  1.00 89.79           C  
ATOM   1895  O   ALA A 245      66.463 126.072  74.662  1.00 92.48           O  
ATOM   1896  CB  ALA A 245      68.625 125.036  77.099  1.00 86.39           C  
ATOM   1897  OXT ALA A 245      65.702 124.801  76.295  1.00 89.51           O  
TER    1898      ALA A 245                                                      
END
MOLECULE T0420.pdb
ATOM      1  N   MET     1      71.619 109.167  47.132  1.00 90.29           N  
ATOM      2  CA  MET     1      71.053 107.807  46.878  1.00 90.45           C  
ATOM      3  C   MET     1      71.689 106.761  47.790  1.00 88.28           C  
ATOM      4  O   MET     1      71.664 106.906  49.016  1.00 88.91           O  
ATOM      5  CB  MET     1      71.260 107.411  45.415  1.00 91.73           C  
ATOM      6  CG  MET     1      71.941 108.488  44.584  1.00 97.36           C  
ATOM      7  SD  MET     1      73.841 108.693  44.978  1.00 99.73          SE  
ATOM      8  CE  MET     1      74.536 108.305  43.197  1.00 99.73           C  
ATOM      9  N   ASN     2      72.267 105.716  47.201  1.00 85.03           N  
ATOM     10  CA  ASN     2      72.888 104.659  47.995  1.00 81.84           C  
ATOM     11  C   ASN     2      74.252 104.994  48.583  1.00 79.10           C  
ATOM     12  O   ASN     2      75.284 104.814  47.940  1.00 78.70           O  
ATOM     13  CB  ASN     2      72.987 103.382  47.174  1.00 82.29           C  
ATOM     14  CG  ASN     2      71.873 102.422  47.485  1.00 83.43           C  
ATOM     15  OD1 ASN     2      70.725 102.827  47.659  1.00 85.52           O  
ATOM     16  ND2 ASN     2      72.199 101.137  47.553  1.00 86.02           N  
ATOM     17  N   ILE     3      74.248 105.472  49.821  1.00 75.30           N  
ATOM     18  CA  ILE     3      75.487 105.816  50.485  1.00 72.19           C  
ATOM     19  C   ILE     3      75.638 105.118  51.830  1.00 69.90           C  
ATOM     20  O   ILE     3      74.729 105.111  52.659  1.00 69.85           O  
ATOM     21  CB  ILE     3      75.600 107.327  50.711  1.00 72.15           C  
ATOM     22  CG1 ILE     3      75.446 108.067  49.383  1.00 72.99           C  
ATOM     23  CG2 ILE     3      76.953 107.658  51.291  1.00 70.73           C  
ATOM     24  CD1 ILE     3      75.531 109.580  49.521  1.00 74.41           C  
ATOM     25  N   GLY     4      76.799 104.515  52.034  1.00 66.94           N  
ATOM     26  CA  GLY     4      77.060 103.854  53.291  1.00 62.89           C  
ATOM     27  C   GLY     4      78.166 104.579  54.036  1.00 59.88           C  
ATOM     28  O   GLY     4      79.154 105.010  53.446  1.00 59.44           O  
ATOM     29  N   VAL     5      77.993 104.742  55.338  1.00 57.63           N  
ATOM     30  CA  VAL     5      79.015 105.385  56.139  1.00 55.30           C  
ATOM     31  C   VAL     5      79.820 104.305  56.867  1.00 54.83           C  
ATOM     32  O   VAL     5      79.258 103.415  57.519  1.00 55.29           O  
ATOM     33  CB  VAL     5      78.407 106.331  57.182  1.00 55.28           C  
ATOM     34  CG1 VAL     5      79.501 107.107  57.868  1.00 52.77           C  
ATOM     35  CG2 VAL     5      77.436 107.269  56.520  1.00 54.18           C  
ATOM     36  N   ILE     6      81.137 104.363  56.711  1.00 52.33           N  
ATOM     37  CA  ILE     6      82.026 103.430  57.382  1.00 49.91           C  
ATOM     38  C   ILE     6      82.772 104.247  58.432  1.00 49.12           C  
ATOM     39  O   ILE     6      83.618 105.076  58.104  1.00 48.62           O  
ATOM     40  CB  ILE     6      83.073 102.802  56.424  1.00 49.52           C  
ATOM     41  CG1 ILE     6      82.382 101.948  55.361  1.00 48.68           C  
ATOM     42  CG2 ILE     6      84.049 101.945  57.211  1.00 48.22           C  
ATOM     43  CD1 ILE     6      83.341 101.418  54.286  1.00 45.37           C  
ATOM     44  N   ILE     7      82.437 104.024  59.694  1.00 48.36           N  
ATOM     45  CA  ILE     7      83.100 104.722  60.774  1.00 47.98           C  
ATOM     46  C   ILE     7      84.274 103.877  61.245  1.00 48.52           C  
ATOM     47  O   ILE     7      84.083 102.855  61.902  1.00 49.70           O  
ATOM     48  CB  ILE     7      82.152 104.964  61.956  1.00 47.36           C  
ATOM     49  CG1 ILE     7      80.950 105.785  61.483  1.00 45.91           C  
ATOM     50  CG2 ILE     7      82.897 105.675  63.069  1.00 45.97           C  
ATOM     51  CD1 ILE     7      79.957 106.127  62.563  1.00 45.22           C  
ATOM     52  N   LEU     8      85.483 104.303  60.877  1.00 49.06           N  
ATOM     53  CA  LEU     8      86.714 103.622  61.268  1.00 49.60           C  
ATOM     54  C   LEU     8      87.006 104.013  62.709  1.00 50.81           C  
ATOM     55  O   LEU     8      87.061 105.197  63.029  1.00 51.50           O  
ATOM     56  CB  LEU     8      87.873 104.067  60.382  1.00 48.30           C  
ATOM     57  CG  LEU     8      87.724 103.786  58.888  1.00 46.60           C  
ATOM     58  CD1 LEU     8      88.961 104.291  58.149  1.00 42.20           C  
ATOM     59  CD2 LEU     8      87.531 102.280  58.665  1.00 43.49           C  
ATOM     60  N   ALA     9      87.171 103.020  63.575  1.00 52.52           N  
ATOM     61  CA  ALA     9      87.443 103.268  64.982  1.00 53.82           C  
ATOM     62  C   ALA     9      88.307 102.171  65.556  1.00 55.51           C  
ATOM     63  O   ALA     9      88.312 101.961  66.758  1.00 56.08           O  
ATOM     64  CB  ALA     9      86.139 103.372  65.772  1.00 52.59           C  
ATOM     65  N   ALA    10      89.020 101.455  64.693  1.00 59.12           N  
ATOM     66  CA  ALA    10      89.924 100.405  65.149  1.00 63.15           C  
ATOM     67  C   ALA    10      91.195 101.151  65.561  1.00 66.75           C  
ATOM     68  O   ALA    10      91.294 102.364  65.350  1.00 68.61           O  
ATOM     69  CB  ALA    10      90.206  99.433  64.026  1.00 62.44           C  
ATOM     70  N   GLY    11      92.175 100.469  66.134  1.00 70.21           N  
ATOM     71  CA  GLY    11      93.361 101.205  66.554  1.00 75.15           C  
ATOM     72  C   GLY    11      94.613 101.061  65.711  1.00 78.33           C  
ATOM     73  O   GLY    11      95.722 101.227  66.230  1.00 78.74           O  
ATOM     74  N   GLU    12      94.437 100.767  64.422  1.00 81.19           N  
ATOM     75  CA  GLU    12      95.550 100.577  63.494  1.00 83.59           C  
ATOM     76  C   GLU    12      96.612 101.665  63.553  1.00 85.71           C  
ATOM     77  O   GLU    12      96.314 102.831  63.835  1.00 85.98           O  
ATOM     78  CB  GLU    12      95.034 100.456  62.063  1.00 83.44           C  
ATOM     79  CG  GLU    12      94.041 101.527  61.667  1.00 82.74           C  
ATOM     80  CD  GLU    12      92.617 101.052  61.810  1.00 83.09           C  
ATOM     81  OE1 GLU    12      92.365  99.880  61.447  1.00 79.28           O  
ATOM     82  OE2 GLU    12      91.759 101.846  62.268  1.00 83.42           O  
ATOM     83  N   GLY    13      97.853 101.269  63.266  1.00 87.93           N  
ATOM     84  CA  GLY    13      98.965 102.201  63.319  1.00 90.43           C  
ATOM     85  C   GLY    13      99.062 102.724  64.740  1.00 92.14           C  
ATOM     86  O   GLY    13      98.707 102.020  65.697  1.00 91.86           O  
ATOM     87  N   LYS    14      99.551 103.951  64.888  1.00 93.73           N  
ATOM     88  CA  LYS    14      99.652 104.561  66.210  1.00 94.77           C  
ATOM     89  C   LYS    14      98.423 105.454  66.350  1.00 95.25           C  
ATOM     90  O   LYS    14      98.420 106.428  67.102  1.00 95.26           O  
ATOM     91  CB  LYS    14     100.936 105.384  66.328  1.00 94.77           C  
ATOM     92  N   ARG    15      97.380 105.105  65.601  1.00 95.97           N  
ATOM     93  CA  ARG    15      96.131 105.855  65.620  1.00 96.80           C  
ATOM     94  C   ARG    15      95.378 105.615  66.920  1.00 97.12           C  
ATOM     95  O   ARG    15      95.823 104.844  67.772  1.00 97.51           O  
ATOM     96  CB  ARG    15      95.254 105.445  64.439  1.00 96.58           C  
ATOM     97  CG  ARG    15      95.877 105.710  63.079  1.00 96.59           C  
ATOM     98  CD  ARG    15      94.898 105.384  61.960  1.00 96.12           C  
ATOM     99  NE  ARG    15      95.475 105.569  60.630  1.00 96.03           N  
ATOM    100  CZ  ARG    15      96.458 104.827  60.126  1.00 96.46           C  
ATOM    101  NH1 ARG    15      96.984 103.835  60.838  1.00 95.19           N  
ATOM    102  NH2 ARG    15      96.918 105.081  58.907  1.00 96.89           N  
ATOM    103  N   PHE    16      94.240 106.283  67.074  1.00 97.18           N  
ATOM    104  CA  PHE    16      93.436 106.119  68.275  1.00 97.49           C  
ATOM    105  C   PHE    16      92.698 104.794  68.262  1.00 97.80           C  
ATOM    106  O   PHE    16      92.768 104.042  67.287  1.00 98.44           O  
ATOM    107  CB  PHE    16      92.419 107.249  68.401  1.00 97.55           C  
ATOM    108  CG  PHE    16      92.908 108.410  69.205  1.00 98.14           C  
ATOM    109  CD1 PHE    16      92.008 109.219  69.890  1.00 98.54           C  
ATOM    110  CD2 PHE    16      94.269 108.692  69.288  1.00 98.99           C  
ATOM    111  CE1 PHE    16      92.454 110.286  70.657  1.00 99.73           C  
ATOM    112  CE2 PHE    16      94.730 109.756  70.052  1.00 99.73           C  
ATOM    113  CZ  PHE    16      93.821 110.559  70.737  1.00 99.73           C  
ATOM    114  N   GLY    17      91.990 104.498  69.346  1.00 97.56           N  
ATOM    115  CA  GLY    17      91.244 103.256  69.372  1.00 97.36           C  
ATOM    116  C   GLY    17      90.894 102.662  70.721  1.00 97.21           C  
ATOM    117  O   GLY    17      91.776 102.255  71.471  1.00 97.85           O  
ATOM    118  N   GLY    18      89.597 102.608  71.018  1.00 96.53           N  
ATOM    119  CA  GLY    18      89.120 102.023  72.260  1.00 94.80           C  
ATOM    120  C   GLY    18      89.396 102.785  73.541  1.00 93.58           C  
ATOM    121  O   GLY    18      88.477 103.303  74.183  1.00 93.59           O  
ATOM    122  N   ASP    19      90.660 102.835  73.938  1.00 91.98           N  
ATOM    123  CA  ASP    19      91.011 103.550  75.145  1.00 90.00           C  
ATOM    124  C   ASP    19      90.709 105.034  74.941  1.00 87.78           C  
ATOM    125  O   ASP    19      89.786 105.568  75.553  1.00 87.48           O  
ATOM    126  CB  ASP    19      92.493 103.309  75.509  1.00 91.01           C  
ATOM    127  CG  ASP    19      93.463 103.733  74.409  1.00 93.15           C  
ATOM    128  OD1 ASP    19      93.323 103.266  73.259  1.00 95.19           O  
ATOM    129  OD2 ASP    19      94.384 104.528  74.701  1.00 97.76           O  
ATOM    130  N   LYS    20      91.456 105.685  74.055  1.00 85.16           N  
ATOM    131  CA  LYS    20      91.273 107.110  73.786  1.00 82.92           C  
ATOM    132  C   LYS    20      89.816 107.477  73.458  1.00 80.52           C  
ATOM    133  O   LYS    20      89.253 108.420  74.027  1.00 80.56           O  
ATOM    134  CB  LYS    20      92.180 107.539  72.627  1.00 83.51           C  
ATOM    135  CG  LYS    20      93.671 107.243  72.823  1.00 86.11           C  
ATOM    136  CD  LYS    20      94.408 108.386  73.521  1.00 91.90           C  
ATOM    137  CE  LYS    20      95.905 108.087  73.660  1.00 92.28           C  
ATOM    138  NZ  LYS    20      96.592 107.877  72.350  1.00 91.97           N  
ATOM    139  N   LEU    21      89.210 106.721  72.546  1.00 77.43           N  
ATOM    140  CA  LEU    21      87.836 106.968  72.122  1.00 74.10           C  
ATOM    141  C   LEU    21      86.754 106.807  73.200  1.00 72.82           C  
ATOM    142  O   LEU    21      85.572 107.019  72.916  1.00 71.48           O  
ATOM    143  CB  LEU    21      87.507 106.089  70.906  1.00 73.69           C  
ATOM    144  CG  LEU    21      88.288 106.394  69.618  1.00 71.25           C  
ATOM    145  CD1 LEU    21      87.938 105.370  68.578  1.00 69.24           C  
ATOM    146  CD2 LEU    21      87.972 107.783  69.103  1.00 68.55           C  
ATOM    147  N   LEU    22      87.143 106.434  74.424  1.00 71.68           N  
ATOM    148  CA  LEU    22      86.172 106.290  75.512  1.00 70.37           C  
ATOM    149  C   LEU    22      86.095 107.557  76.356  1.00 69.76           C  
ATOM    150  O   LEU    22      85.162 107.730  77.144  1.00 69.42           O  
ATOM    151  CB  LEU    22      86.491 105.095  76.416  1.00 70.07           C  
ATOM    152  CG  LEU    22      86.082 103.676  75.982  1.00 71.01           C  
ATOM    153  CD1 LEU    22      85.902 102.800  77.220  1.00 68.76           C  
ATOM    154  CD2 LEU    22      84.773 103.705  75.206  1.00 72.70           C  
ATOM    155  N   ALA    23      87.078 108.441  76.174  1.00 69.46           N  
ATOM    156  CA  ALA    23      87.127 109.724  76.884  1.00 69.28           C  
ATOM    157  C   ALA    23      85.917 110.570  76.485  1.00 69.04           C  
ATOM    158  O   ALA    23      85.341 110.375  75.412  1.00 69.60           O  
ATOM    159  CB  ALA    23      88.409 110.460  76.543  1.00 69.01           C  
ATOM    160  N   LYS    24      85.549 111.522  77.337  1.00 68.45           N  
ATOM    161  CA  LYS    24      84.383 112.367  77.086  1.00 68.28           C  
ATOM    162  C   LYS    24      84.613 113.775  76.519  1.00 68.22           C  
ATOM    163  O   LYS    24      85.726 114.280  76.472  1.00 68.12           O  
ATOM    164  CB  LYS    24      83.569 112.483  78.376  1.00 67.78           C  
ATOM    165  CG  LYS    24      83.078 111.164  78.927  1.00 68.26           C  
ATOM    166  CD  LYS    24      82.344 111.376  80.231  1.00 66.88           C  
ATOM    167  CE  LYS    24      81.781 110.086  80.774  1.00 69.00           C  
ATOM    168  NZ  LYS    24      80.964 110.366  81.975  1.00 71.95           N  
ATOM    169  N   ILE    25      83.522 114.399  76.101  1.00 68.72           N  
ATOM    170  CA  ILE    25      83.525 115.746  75.553  1.00 69.60           C  
ATOM    171  C   ILE    25      82.113 116.231  75.805  1.00 70.70           C  
ATOM    172  O   ILE    25      81.199 115.924  75.039  1.00 70.98           O  
ATOM    173  CB  ILE    25      83.791 115.732  74.042  1.00 69.72           C  
ATOM    174  CG1 ILE    25      85.257 115.399  73.782  1.00 70.89           C  
ATOM    175  CG2 ILE    25      83.412 117.056  73.429  1.00 69.11           C  
ATOM    176  CD1 ILE    25      85.582 115.164  72.325  1.00 72.99           C  
ATOM    177  N   ASP    26      81.931 116.984  76.881  1.00 71.49           N  
ATOM    178  CA  ASP    26      80.604 117.463  77.233  1.00 72.41           C  
ATOM    179  C   ASP    26      79.866 116.270  77.805  1.00 71.27           C  
ATOM    180  O   ASP    26      78.696 116.051  77.478  1.00 71.67           O  
ATOM    181  CB  ASP    26      79.825 117.975  76.006  1.00 73.68           C  
ATOM    182  CG  ASP    26      80.186 119.402  75.626  1.00 79.66           C  
ATOM    183  OD1 ASP    26      80.133 120.280  76.516  1.00 86.88           O  
ATOM    184  OD2 ASP    26      80.510 119.650  74.441  1.00 84.59           O  
ATOM    185  N   ASN    27      80.559 115.481  78.628  1.00 68.93           N  
ATOM    186  CA  ASN    27      79.942 114.315  79.268  1.00 66.22           C  
ATOM    187  C   ASN    27      79.658 113.120  78.385  1.00 64.66           C  
ATOM    188  O   ASN    27      79.094 112.128  78.859  1.00 65.21           O  
ATOM    189  CB  ASN    27      78.612 114.688  79.922  1.00 65.54           C  
ATOM    190  CG  ASN    27      78.784 115.403  81.225  1.00 64.50           C  
ATOM    191  OD1 ASN    27      79.884 115.485  81.765  1.00 64.45           O  
ATOM    192  ND2 ASN    27      77.683 115.917  81.756  1.00 64.06           N  
ATOM    193  N   THR    28      80.000 113.196  77.108  1.00 62.05           N  
ATOM    194  CA  THR    28      79.717 112.060  76.257  1.00 59.69           C  
ATOM    195  C   THR    28      80.960 111.528  75.569  1.00 58.20           C  
ATOM    196  O   THR    28      81.777 112.288  75.050  1.00 57.50           O  
ATOM    197  CB  THR    28      78.640 112.384  75.191  1.00 59.45           C  
ATOM    198  OG1 THR    28      79.251 112.466  73.900  1.00 59.73           O  
ATOM    199  CG2 THR    28      77.942 113.690  75.508  1.00 57.57           C  
ATOM    200  N   PRO    29      81.119 110.198  75.579  1.00 56.76           N  
ATOM    201  CA  PRO    29      82.239 109.478  74.972  1.00 56.34           C  
ATOM    202  C   PRO    29      82.454 109.932  73.529  1.00 55.95           C  
ATOM    203  O   PRO    29      81.504 110.038  72.765  1.00 56.53           O  
ATOM    204  CB  PRO    29      81.788 108.027  75.065  1.00 56.52           C  
ATOM    205  CG  PRO    29      80.997 108.025  76.333  1.00 56.54           C  
ATOM    206  CD  PRO    29      80.176 109.262  76.213  1.00 55.49           C  
ATOM    207  N   ILE    30      83.700 110.192  73.157  1.00 55.38           N  
ATOM    208  CA  ILE    30      84.000 110.645  71.811  1.00 55.43           C  
ATOM    209  C   ILE    30      83.353 109.800  70.720  1.00 55.32           C  
ATOM    210  O   ILE    30      82.564 110.328  69.926  1.00 56.08           O  
ATOM    211  CB  ILE    30      85.522 110.709  71.577  1.00 55.57           C  
ATOM    212  CG1 ILE    30      86.136 111.685  72.580  1.00 58.50           C  
ATOM    213  CG2 ILE    30      85.833 111.166  70.152  1.00 55.90           C  
ATOM    214  CD1 ILE    30      87.631 111.558  72.699  1.00 61.89           C  
ATOM    215  N   ILE    31      83.672 108.504  70.676  1.00 54.45           N  
ATOM    216  CA  ILE    31      83.118 107.613  69.647  1.00 53.69           C  
ATOM    217  C   ILE    31      81.614 107.793  69.494  1.00 54.48           C  
ATOM    218  O   ILE    31      81.101 107.817  68.377  1.00 53.94           O  
ATOM    219  CB  ILE    31      83.430 106.091  69.930  1.00 53.14           C  
ATOM    220  CG1 ILE    31      82.977 105.234  68.744  1.00 52.34           C  
ATOM    221  CG2 ILE    31      82.709 105.612  71.178  1.00 49.66           C  
ATOM    222  CD1 ILE    31      83.529 105.698  67.414  1.00 48.24           C  
ATOM    223  N   MET    32      80.915 107.933  70.614  1.00 55.33           N  
ATOM    224  CA  MET    32      79.468 108.124  70.580  1.00 57.31           C  
ATOM    225  C   MET    32      79.075 109.453  69.925  1.00 57.61           C  
ATOM    226  O   MET    32      78.130 109.518  69.147  1.00 58.36           O  
ATOM    227  CB  MET    32      78.889 108.041  71.994  1.00 57.46           C  
ATOM    228  CG  MET    32      78.996 106.661  72.614  1.00 62.54           C  
ATOM    229  SD  MET    32      78.000 106.473  74.269  1.00 78.05          SE  
ATOM    230  CE  MET    32      76.220 106.221  73.530  1.00 73.81           C  
ATOM    231  N   ARG    33      79.804 110.515  70.236  1.00 57.73           N  
ATOM    232  CA  ARG    33      79.511 111.806  69.650  1.00 57.85           C  
ATOM    233  C   ARG    33      79.694 111.710  68.131  1.00 56.91           C  
ATOM    234  O   ARG    33      78.834 112.133  67.368  1.00 56.97           O  
ATOM    235  CB  ARG    33      80.455 112.857  70.228  1.00 58.89           C  
ATOM    236  CG  ARG    33      80.107 114.287  69.860  1.00 64.39           C  
ATOM    237  CD  ARG    33      81.310 115.202  70.074  1.00 73.49           C  
ATOM    238  NE  ARG    33      80.955 116.619  70.038  1.00 79.65           N  
ATOM    239  CZ  ARG    33      80.209 117.224  70.960  1.00 84.29           C  
ATOM    240  NH1 ARG    33      79.728 116.544  72.002  1.00 85.07           N  
ATOM    241  NH2 ARG    33      79.953 118.518  70.841  1.00 85.09           N  
ATOM    242  N   THR    34      80.818 111.141  67.710  1.00 55.65           N  
ATOM    243  CA  THR    34      81.154 110.977  66.299  1.00 55.20           C  
ATOM    244  C   THR    34      80.093 110.227  65.496  1.00 56.00           C  
ATOM    245  O   THR    34      79.744 110.616  64.383  1.00 57.09           O  
ATOM    246  CB  THR    34      82.487 110.233  66.153  1.00 54.71           C  
ATOM    247  OG1 THR    34      83.528 111.010  66.753  1.00 56.07           O  
ATOM    248  CG2 THR    34      82.817 109.991  64.698  1.00 53.23           C  
ATOM    249  N   ILE    35      79.595 109.135  66.050  1.00 55.81           N  
ATOM    250  CA  ILE    35      78.573 108.350  65.382  1.00 55.24           C  
ATOM    251  C   ILE    35      77.285 109.182  65.289  1.00 56.74           C  
ATOM    252  O   ILE    35      76.516 109.062  64.335  1.00 56.77           O  
ATOM    253  CB  ILE    35      78.314 107.055  66.181  1.00 54.53           C  
ATOM    254  CG1 ILE    35      79.523 106.122  66.057  1.00 52.33           C  
ATOM    255  CG2 ILE    35      77.025 106.392  65.721  1.00 54.33           C  
ATOM    256  CD1 ILE    35      79.511 104.992  67.061  1.00 52.36           C  
ATOM    257  N   ARG    36      77.063 110.034  66.285  1.00 58.78           N  
ATOM    258  CA  ARG    36      75.872 110.873  66.330  1.00 60.98           C  
ATOM    259  C   ARG    36      75.736 111.810  65.126  1.00 60.67           C  
ATOM    260  O   ARG    36      74.623 112.054  64.639  1.00 60.67           O  
ATOM    261  CB  ARG    36      75.856 111.709  67.617  1.00 62.08           C  
ATOM    262  CG  ARG    36      74.700 112.698  67.669  1.00 70.34           C  
ATOM    263  CD  ARG    36      74.838 113.806  68.723  1.00 81.85           C  
ATOM    264  NE  ARG    36      73.929 114.914  68.396  1.00 91.09           N  
ATOM    265  CZ  ARG    36      73.705 115.989  69.155  1.00 95.58           C  
ATOM    266  NH1 ARG    36      74.321 116.134  70.323  1.00 98.47           N  
ATOM    267  NH2 ARG    36      72.864 116.934  68.737  1.00 96.39           N  
ATOM    268  N   ILE    37      76.852 112.330  64.630  1.00 60.37           N  
ATOM    269  CA  ILE    37      76.760 113.262  63.520  1.00 60.38           C  
ATOM    270  C   ILE    37      76.210 112.662  62.239  1.00 59.58           C  
ATOM    271  O   ILE    37      75.575 113.366  61.461  1.00 60.82           O  
ATOM    272  CB  ILE    37      78.127 113.955  63.185  1.00 60.43           C  
ATOM    273  CG1 ILE    37      78.674 113.407  61.868  1.00 62.85           C  
ATOM    274  CG2 ILE    37      79.129 113.773  64.316  1.00 59.72           C  
ATOM    275  CD1 ILE    37      79.796 114.225  61.284  1.00 67.67           C  
ATOM    276  N   TYR    38      76.439 111.376  62.009  1.00 58.46           N  
ATOM    277  CA  TYR    38      75.958 110.767  60.772  1.00 58.42           C  
ATOM    278  C   TYR    38      74.512 110.287  60.843  1.00 59.45           C  
ATOM    279  O   TYR    38      74.027 109.572  59.957  1.00 59.42           O  
ATOM    280  CB  TYR    38      76.898 109.643  60.352  1.00 57.53           C  
ATOM    281  CG  TYR    38      78.318 110.140  60.220  1.00 57.36           C  
ATOM    282  CD1 TYR    38      79.162 110.183  61.328  1.00 55.51           C  
ATOM    283  CD2 TYR    38      78.800 110.631  59.012  1.00 55.63           C  
ATOM    284  CE1 TYR    38      80.441 110.698  61.244  1.00 49.86           C  
ATOM    285  CE2 TYR    38      80.086 111.152  58.916  1.00 54.10           C  
ATOM    286  CZ  TYR    38      80.901 111.178  60.041  1.00 51.45           C  
ATOM    287  OH  TYR    38      82.186 111.662  59.964  1.00 47.93           O  
ATOM    288  N   GLY    39      73.835 110.720  61.907  1.00 60.10           N  
ATOM    289  CA  GLY    39      72.436 110.407  62.143  1.00 60.00           C  
ATOM    290  C   GLY    39      71.855 109.148  61.549  1.00 60.55           C  
ATOM    291  O   GLY    39      72.378 108.058  61.752  1.00 61.52           O  
ATOM    292  N   ASP    40      70.771 109.296  60.796  1.00 60.94           N  
ATOM    293  CA  ASP    40      70.101 108.136  60.216  1.00 61.01           C  
ATOM    294  C   ASP    40      70.751 107.499  58.989  1.00 60.50           C  
ATOM    295  O   ASP    40      70.166 106.593  58.398  1.00 61.61           O  
ATOM    296  CB  ASP    40      68.633 108.467  59.925  1.00 61.37           C  
ATOM    297  N   LEU    41      71.943 107.952  58.601  1.00 59.40           N  
ATOM    298  CA  LEU    41      72.634 107.336  57.466  1.00 58.41           C  
ATOM    299  C   LEU    41      73.003 105.901  57.874  1.00 58.10           C  
ATOM    300  O   LEU    41      73.050 105.601  59.061  1.00 58.57           O  
ATOM    301  CB  LEU    41      73.916 108.105  57.132  1.00 57.99           C  
ATOM    302  CG  LEU    41      73.826 109.512  56.542  1.00 57.23           C  
ATOM    303  CD1 LEU    41      75.230 110.107  56.371  1.00 57.65           C  
ATOM    304  CD2 LEU    41      73.115 109.447  55.218  1.00 57.35           C  
ATOM    305  N   GLU    42      73.254 105.021  56.905  1.00 57.72           N  
ATOM    306  CA  GLU    42      73.638 103.638  57.205  1.00 58.18           C  
ATOM    307  C   GLU    42      75.083 103.558  57.672  1.00 57.58           C  
ATOM    308  O   GLU    42      76.007 103.563  56.865  1.00 58.58           O  
ATOM    309  CB  GLU    42      73.507 102.748  55.983  1.00 58.83           C  
ATOM    310  CG  GLU    42      72.111 102.537  55.499  1.00 63.58           C  
ATOM    311  CD  GLU    42      72.067 101.539  54.355  1.00 70.64           C  
ATOM    312  OE1 GLU    42      72.384 100.347  54.605  1.00 73.15           O  
ATOM    313  OE2 GLU    42      71.728 101.953  53.216  1.00 70.47           O  
ATOM    314  N   LYS    43      75.268 103.444  58.978  1.00 56.57           N  
ATOM    315  CA  LYS    43      76.589 103.388  59.574  1.00 54.94           C  
ATOM    316  C   LYS    43      77.058 101.962  59.729  1.00 53.93           C  
ATOM    317  O   LYS    43      76.296 101.025  59.586  1.00 54.99           O  
ATOM    318  CB  LYS    43      76.539 104.053  60.944  1.00 54.21           C  
ATOM    319  CG  LYS    43      76.089 105.493  60.873  1.00 56.44           C  
ATOM    320  CD  LYS    43      75.508 105.986  62.175  1.00 57.68           C  
ATOM    321  CE  LYS    43      74.133 105.422  62.382  1.00 62.41           C  
ATOM    322  NZ  LYS    43      73.639 105.759  63.752  1.00 70.06           N  
ATOM    323  N   ILE    44      78.336 101.815  60.023  1.00 53.03           N  
ATOM    324  CA  ILE    44      78.956 100.522  60.253  1.00 51.66           C  
ATOM    325  C   ILE    44      80.189 100.978  61.016  1.00 50.86           C  
ATOM    326  O   ILE    44      80.899 101.871  60.552  1.00 50.25           O  
ATOM    327  CB  ILE    44      79.325  99.798  58.892  1.00 51.74           C  
ATOM    328  CG1 ILE    44      78.773  98.381  58.892  1.00 53.42           C  
ATOM    329  CG2 ILE    44      80.828  99.652  58.706  1.00 51.40           C  
ATOM    330  CD1 ILE    44      77.286  98.305  59.143  1.00 58.76           C  
ATOM    331  N   ILE    45      80.414 100.441  62.209  1.00 49.37           N  
ATOM    332  CA  ILE    45      81.605 100.835  62.958  1.00 48.60           C  
ATOM    333  C   ILE    45      82.599  99.678  62.948  1.00 47.89           C  
ATOM    334  O   ILE    45      82.250  98.549  63.296  1.00 47.54           O  
ATOM    335  CB  ILE    45      81.288 101.224  64.429  1.00 48.70           C  
ATOM    336  CG1 ILE    45      80.526 102.551  64.500  1.00 51.62           C  
ATOM    337  CG2 ILE    45      82.577 101.466  65.175  1.00 48.08           C  
ATOM    338  CD1 ILE    45      79.121 102.524  64.017  1.00 50.63           C  
ATOM    339  N   ILE    46      83.832  99.957  62.530  1.00 47.84           N  
ATOM    340  CA  ILE    46      84.878  98.932  62.471  1.00 48.03           C  
ATOM    341  C   ILE    46      85.761  99.062  63.707  1.00 49.81           C  
ATOM    342  O   ILE    46      86.479 100.044  63.874  1.00 49.96           O  
ATOM    343  CB  ILE    46      85.750  99.079  61.206  1.00 47.88           C  
ATOM    344  CG1 ILE    46      84.863  99.339  59.981  1.00 46.63           C  
ATOM    345  CG2 ILE    46      86.567  97.822  61.007  1.00 45.07           C  
ATOM    346  CD1 ILE    46      83.919  98.205  59.659  1.00 46.69           C  
ATOM    347  N   VAL    47      85.713  98.050  64.563  1.00 51.65           N  
ATOM    348  CA  VAL    47      86.454  98.057  65.801  1.00 52.13           C  
ATOM    349  C   VAL    47      87.558  97.039  65.857  1.00 52.86           C  
ATOM    350  O   VAL    47      87.385  95.892  65.465  1.00 53.50           O  
ATOM    351  CB  VAL    47      85.489  97.786  66.997  1.00 52.29           C  
ATOM    352  CG1 VAL    47      86.271  97.710  68.308  1.00 58.76           C  
ATOM    353  CG2 VAL    47      84.434  98.880  67.086  1.00 49.63           C  
ATOM    354  N   GLY    48      88.700  97.489  66.340  1.00 53.86           N  
ATOM    355  CA  GLY    48      89.803  96.591  66.529  1.00 56.32           C  
ATOM    356  C   GLY    48      90.462  96.636  67.900  1.00 58.56           C  
ATOM    357  O   GLY    48      90.053  95.931  68.838  1.00 58.36           O  
ATOM    358  N   LYS    49      91.398  97.574  68.039  1.00 60.27           N  
ATOM    359  CA  LYS    49      92.245  97.618  69.209  1.00 61.92           C  
ATOM    360  C   LYS    49      91.645  97.359  70.559  1.00 62.63           C  
ATOM    361  O   LYS    49      92.151  96.541  71.335  1.00 63.40           O  
ATOM    362  CB  LYS    49      93.101  98.892  69.217  1.00 62.68           C  
ATOM    363  CG  LYS    49      94.220  98.881  70.262  1.00 65.72           C  
ATOM    364  CD  LYS    49      95.293  99.902  69.929  1.00 71.92           C  
ATOM    365  CE  LYS    49      96.442  99.825  70.923  1.00 74.57           C  
ATOM    366  NZ  LYS    49      97.419 100.945  70.723  1.00 77.45           N  
ATOM    367  N   TYR    50      90.541  98.024  70.825  1.00 61.98           N  
ATOM    368  CA  TYR    50      89.878  97.870  72.096  1.00 62.40           C  
ATOM    369  C   TYR    50      88.384  97.537  72.004  1.00 61.32           C  
ATOM    370  O   TYR    50      87.543  98.201  72.619  1.00 60.53           O  
ATOM    371  CB  TYR    50      90.093  99.142  72.913  1.00 64.35           C  
ATOM    372  CG  TYR    50      91.467  99.231  73.557  1.00 69.92           C  
ATOM    373  CD1 TYR    50      91.851  98.321  74.548  1.00 75.20           C  
ATOM    374  CD2 TYR    50      92.380 100.226  73.191  1.00 71.41           C  
ATOM    375  CE1 TYR    50      93.106  98.398  75.162  1.00 76.64           C  
ATOM    376  CE2 TYR    50      93.639 100.315  73.798  1.00 73.94           C  
ATOM    377  CZ  TYR    50      93.993  99.399  74.787  1.00 76.90           C  
ATOM    378  OH  TYR    50      95.211  99.503  75.430  1.00 78.80           O  
ATOM    379  N   VAL    51      88.073  96.495  71.237  1.00 59.63           N  
ATOM    380  CA  VAL    51      86.707  96.020  71.054  1.00 57.84           C  
ATOM    381  C   VAL    51      85.939  95.973  72.370  1.00 58.37           C  
ATOM    382  O   VAL    51      84.792  96.426  72.461  1.00 58.73           O  
ATOM    383  CB  VAL    51      86.667  94.573  70.482  1.00 58.21           C  
ATOM    384  CG1 VAL    51      85.824  94.537  69.223  1.00 57.69           C  
ATOM    385  CG2 VAL    51      88.069  94.054  70.218  1.00 57.30           C  
ATOM    386  N   ASN    52      86.588  95.412  73.385  1.00 58.63           N  
ATOM    387  CA  ASN    52      86.002  95.231  74.703  1.00 59.29           C  
ATOM    388  C   ASN    52      85.566  96.513  75.391  1.00 59.39           C  
ATOM    389  O   ASN    52      84.513  96.545  76.008  1.00 59.70           O  
ATOM    390  CB  ASN    52      86.986  94.443  75.559  1.00 60.17           C  
ATOM    391  CG  ASN    52      87.796  93.442  74.727  1.00 64.37           C  
ATOM    392  OD1 ASN    52      88.879  93.772  74.214  1.00 67.78           O  
ATOM    393  ND2 ASN    52      87.259  92.223  74.562  1.00 65.23           N  
ATOM    394  N   GLU    53      86.366  97.567  75.292  1.00 60.29           N  
ATOM    395  CA  GLU    53      86.020  98.851  75.889  1.00 60.62           C  
ATOM    396  C   GLU    53      84.865  99.468  75.113  1.00 60.18           C  
ATOM    397  O   GLU    53      83.879  99.925  75.678  1.00 60.82           O  
ATOM    398  CB  GLU    53      87.187  99.834  75.787  1.00 61.28           C  
ATOM    399  CG  GLU    53      88.107  99.932  76.968  1.00 65.75           C  
ATOM    400  CD  GLU    53      89.111  98.815  77.002  1.00 74.97           C  
ATOM    401  OE1 GLU    53      90.250  99.080  77.464  1.00 79.21           O  
ATOM    402  OE2 GLU    53      88.760  97.683  76.579  1.00 76.94           O  
ATOM    403  N   MET    54      85.035  99.481  73.800  1.00 59.89           N  
ATOM    404  CA  MET    54      84.103 100.063  72.844  1.00 60.56           C  
ATOM    405  C   MET    54      82.660  99.563  72.773  1.00 58.62           C  
ATOM    406  O   MET    54      81.708 100.349  72.841  1.00 58.00           O  
ATOM    407  CB  MET    54      84.697  99.924  71.449  1.00 62.14           C  
ATOM    408  CG  MET    54      86.053 100.549  71.282  1.00 69.52           C  
ATOM    409  SD  MET    54      85.886 102.012  70.073  1.00 90.15          SE  
ATOM    410  CE  MET    54      85.198 103.287  71.348  1.00 84.00           C  
ATOM    411  N   LEU    55      82.502  98.256  72.622  1.00 55.88           N  
ATOM    412  CA  LEU    55      81.184  97.676  72.459  1.00 54.39           C  
ATOM    413  C   LEU    55      80.040  98.066  73.373  1.00 53.04           C  
ATOM    414  O   LEU    55      78.959  98.398  72.897  1.00 53.20           O  
ATOM    415  CB  LEU    55      81.306  96.155  72.391  1.00 54.90           C  
ATOM    416  CG  LEU    55      81.307  95.787  70.903  1.00 56.33           C  
ATOM    417  CD1 LEU    55      82.157  94.570  70.662  1.00 61.30           C  
ATOM    418  CD2 LEU    55      79.872  95.590  70.432  1.00 52.82           C  
ATOM    419  N   PRO    56      80.249  98.046  74.694  1.00 51.29           N  
ATOM    420  CA  PRO    56      79.124  98.414  75.552  1.00 49.78           C  
ATOM    421  C   PRO    56      78.523  99.780  75.249  1.00 49.42           C  
ATOM    422  O   PRO    56      77.448 100.106  75.750  1.00 48.99           O  
ATOM    423  CB  PRO    56      79.719  98.312  76.948  1.00 49.07           C  
ATOM    424  CG  PRO    56      80.722  97.225  76.789  1.00 49.39           C  
ATOM    425  CD  PRO    56      81.395  97.595  75.498  1.00 49.72           C  
ATOM    426  N   LEU    57      79.216 100.574  74.436  1.00 49.11           N  
ATOM    427  CA  LEU    57      78.729 101.905  74.052  1.00 50.18           C  
ATOM    428  C   LEU    57      78.107 101.899  72.662  1.00 50.24           C  
ATOM    429  O   LEU    57      77.524 102.890  72.243  1.00 51.13           O  
ATOM    430  CB  LEU    57      79.862 102.932  74.024  1.00 50.39           C  
ATOM    431  CG  LEU    57      80.628 103.337  75.273  1.00 52.72           C  
ATOM    432  CD1 LEU    57      81.414 102.155  75.842  1.00 56.04           C  
ATOM    433  CD2 LEU    57      81.565 104.462  74.883  1.00 54.20           C  
ATOM    434  N   LEU    58      78.256 100.789  71.948  1.00 49.46           N  
ATOM    435  CA  LEU    58      77.741 100.660  70.593  1.00 48.48           C  
ATOM    436  C   LEU    58      76.717  99.532  70.493  1.00 49.44           C  
ATOM    437  O   LEU    58      76.510  98.994  69.411  1.00 50.42           O  
ATOM    438  CB  LEU    58      78.896 100.345  69.647  1.00 47.40           C  
ATOM    439  CG  LEU    58      80.166 101.180  69.771  1.00 44.88           C  
ATOM    440  CD1 LEU    58      81.278 100.576  68.929  1.00 42.95           C  
ATOM    441  CD2 LEU    58      79.876 102.572  69.324  1.00 44.85           C  
ATOM    442  N   MET    59      76.078  99.174  71.605  1.00 49.35           N  
ATOM    443  CA  MET    59      75.125  98.067  71.600  1.00 49.73           C  
ATOM    444  C   MET    59      73.985  98.168  70.591  1.00 49.30           C  
ATOM    445  O   MET    59      73.364  97.162  70.244  1.00 49.30           O  
ATOM    446  CB  MET    59      74.559  97.842  73.010  1.00 50.89           C  
ATOM    447  CG  MET    59      75.565  97.287  74.017  1.00 54.13           C  
ATOM    448  SD  MET    59      76.588  95.782  73.324  1.00 70.34          SE  
ATOM    449  CE  MET    59      75.361  94.347  73.753  1.00 58.89           C  
ATOM    450  N   ASP    60      73.708  99.374  70.110  1.00 47.86           N  
ATOM    451  CA  ASP    60      72.653  99.565  69.124  1.00 46.66           C  
ATOM    452  C   ASP    60      73.221  99.860  67.735  1.00 46.22           C  
ATOM    453  O   ASP    60      72.538 100.445  66.911  1.00 47.02           O  
ATOM    454  CB  ASP    60      71.777 100.727  69.535  1.00 46.17           C  
ATOM    455  CG  ASP    60      72.544 102.034  69.589  1.00 48.07           C  
ATOM    456  OD1 ASP    60      73.801 102.003  69.559  1.00 53.28           O  
ATOM    457  OD2 ASP    60      71.888 103.091  69.676  1.00 47.99           O  
ATOM    458  N   GLN    61      74.463  99.468  67.479  1.00 45.11           N  
ATOM    459  CA  GLN    61      75.091  99.721  66.192  1.00 45.51           C  
ATOM    460  C   GLN    61      75.570  98.418  65.558  1.00 45.51           C  
ATOM    461  O   GLN    61      75.632  97.396  66.234  1.00 47.80           O  
ATOM    462  CB  GLN    61      76.304 100.641  66.367  1.00 44.61           C  
ATOM    463  CG  GLN    61      76.029 101.970  67.031  1.00 47.76           C  
ATOM    464  CD  GLN    61      75.216 102.919  66.169  1.00 49.19           C  
ATOM    465  OE1 GLN    61      75.521 103.116  65.002  1.00 50.52           O  
ATOM    466  NE2 GLN    61      74.185 103.520  66.749  1.00 52.55           N  
ATOM    467  N   ILE    62      75.892  98.445  64.267  1.00 43.40           N  
ATOM    468  CA  ILE    62      76.422  97.260  63.623  1.00 42.80           C  
ATOM    469  C   ILE    62      77.933  97.417  63.754  1.00 43.20           C  
ATOM    470  O   ILE    62      78.536  98.329  63.179  1.00 43.46           O  
ATOM    471  CB  ILE    62      76.065  97.163  62.119  1.00 43.54           C  
ATOM    472  CG1 ILE    62      74.578  96.871  61.943  1.00 44.93           C  
ATOM    473  CG2 ILE    62      76.870  96.046  61.466  1.00 40.91           C  
ATOM    474  CD1 ILE    62      74.146  96.881  60.518  1.00 44.82           C  
ATOM    475  N   VAL    63      78.547  96.526  64.519  1.00 43.82           N  
ATOM    476  CA  VAL    63      79.975  96.594  64.738  1.00 42.60           C  
ATOM    477  C   VAL    63      80.726  95.410  64.165  1.00 43.60           C  
ATOM    478  O   VAL    63      80.362  94.255  64.412  1.00 44.70           O  
ATOM    479  CB  VAL    63      80.264  96.654  66.221  1.00 42.01           C  
ATOM    480  CG1 VAL    63      81.728  96.879  66.438  1.00 41.44           C  
ATOM    481  CG2 VAL    63      79.437  97.758  66.849  1.00 40.36           C  
ATOM    482  N   ILE    64      81.760  95.691  63.380  1.00 43.38           N  
ATOM    483  CA  ILE    64      82.579  94.618  62.834  1.00 43.76           C  
ATOM    484  C   ILE    64      83.935  94.756  63.513  1.00 43.62           C  
ATOM    485  O   ILE    64      84.577  95.801  63.455  1.00 43.62           O  
ATOM    486  CB  ILE    64      82.821  94.702  61.278  1.00 44.89           C  
ATOM    487  CG1 ILE    64      81.509  94.822  60.510  1.00 45.55           C  
ATOM    488  CG2 ILE    64      83.526  93.442  60.799  1.00 41.36           C  
ATOM    489  CD1 ILE    64      81.032  96.228  60.377  1.00 50.68           C  
ATOM    490  N   TYR    65      84.349  93.690  64.171  1.00 43.63           N  
ATOM    491  CA  TYR    65      85.625  93.649  64.829  1.00 43.37           C  
ATOM    492  C   TYR    65      86.648  93.145  63.818  1.00 44.75           C  
ATOM    493  O   TYR    65      86.500  92.057  63.249  1.00 43.95           O  
ATOM    494  CB  TYR    65      85.565  92.702  66.019  1.00 43.55           C  
ATOM    495  CG  TYR    65      86.918  92.251  66.487  1.00 41.43           C  
ATOM    496  CD1 TYR    65      87.852  93.164  66.972  1.00 38.27           C  
ATOM    497  CD2 TYR    65      87.280  90.912  66.418  1.00 41.59           C  
ATOM    498  CE1 TYR    65      89.120  92.749  67.377  1.00 40.70           C  
ATOM    499  CE2 TYR    65      88.550  90.489  66.822  1.00 45.09           C  
ATOM    500  CZ  TYR    65      89.460  91.409  67.299  1.00 42.17           C  
ATOM    501  OH  TYR    65      90.693  90.979  67.699  1.00 40.96           O  
ATOM    502  N   ASN    66      87.685  93.944  63.593  1.00 46.17           N  
ATOM    503  CA  ASN    66      88.737  93.574  62.660  1.00 47.65           C  
ATOM    504  C   ASN    66      89.911  92.902  63.383  1.00 49.38           C  
ATOM    505  O   ASN    66      90.732  93.568  63.999  1.00 50.31           O  
ATOM    506  CB  ASN    66      89.215  94.819  61.946  1.00 47.78           C  
ATOM    507  CG  ASN    66      90.256  94.527  60.923  1.00 47.90           C  
ATOM    508  OD1 ASN    66      90.794  95.442  60.318  1.00 49.13           O  
ATOM    509  ND2 ASN    66      90.552  93.247  60.710  1.00 45.03           N  
ATOM    510  N   PRO    67      90.018  91.566  63.301  1.00 50.88           N  
ATOM    511  CA  PRO    67      91.125  90.896  63.985  1.00 51.48           C  
ATOM    512  C   PRO    67      92.476  91.236  63.350  1.00 51.83           C  
ATOM    513  O   PRO    67      93.525  90.865  63.872  1.00 52.03           O  
ATOM    514  CB  PRO    67      90.772  89.428  63.819  1.00 50.88           C  
ATOM    515  CG  PRO    67      90.292  89.417  62.428  1.00 50.27           C  
ATOM    516  CD  PRO    67      89.335  90.615  62.409  1.00 51.26           C  
ATOM    517  N   PHE    68      92.447  91.941  62.226  1.00 51.67           N  
ATOM    518  CA  PHE    68      93.677  92.303  61.527  1.00 51.96           C  
ATOM    519  C   PHE    68      94.032  93.784  61.633  1.00 51.17           C  
ATOM    520  O   PHE    68      94.899  94.260  60.898  1.00 50.54           O  
ATOM    521  CB  PHE    68      93.555  91.945  60.047  1.00 52.16           C  
ATOM    522  CG  PHE    68      93.289  90.497  59.797  1.00 55.38           C  
ATOM    523  CD1 PHE    68      94.332  89.575  59.785  1.00 56.42           C  
ATOM    524  CD2 PHE    68      91.985  90.042  59.594  1.00 58.52           C  
ATOM    525  CE1 PHE    68      94.080  88.223  59.572  1.00 55.86           C  
ATOM    526  CE2 PHE    68      91.724  88.689  59.382  1.00 57.31           C  
ATOM    527  CZ  PHE    68      92.775  87.781  59.372  1.00 57.16           C  
ATOM    528  N   TRP    69      93.372  94.503  62.542  1.00 50.63           N  
ATOM    529  CA  TRP    69      93.603  95.940  62.694  1.00 50.90           C  
ATOM    530  C   TRP    69      95.071  96.320  62.846  1.00 51.38           C  
ATOM    531  O   TRP    69      95.521  97.326  62.316  1.00 50.73           O  
ATOM    532  CB  TRP    69      92.818  96.480  63.889  1.00 49.66           C  
ATOM    533  CG  TRP    69      93.264  95.906  65.183  1.00 49.78           C  
ATOM    534  CD1 TRP    69      92.800  94.774  65.775  1.00 47.87           C  
ATOM    535  CD2 TRP    69      94.302  96.408  66.032  1.00 49.42           C  
ATOM    536  NE1 TRP    69      93.478  94.536  66.941  1.00 49.11           N  
ATOM    537  CE2 TRP    69      94.411  95.524  67.126  1.00 49.69           C  
ATOM    538  CE3 TRP    69      95.154  97.522  65.977  1.00 49.81           C  
ATOM    539  CZ2 TRP    69      95.340  95.710  68.161  1.00 49.98           C  
ATOM    540  CZ3 TRP    69      96.077  97.709  67.006  1.00 48.86           C  
ATOM    541  CH2 TRP    69      96.160  96.806  68.082  1.00 50.99           C  
ATOM    542  N   ASN    70      95.801  95.490  63.574  1.00 52.70           N  
ATOM    543  CA  ASN    70      97.215  95.690  63.847  1.00 54.65           C  
ATOM    544  C   ASN    70      98.005  95.820  62.549  1.00 53.81           C  
ATOM    545  O   ASN    70      99.035  96.490  62.490  1.00 53.07           O  
ATOM    546  CB  ASN    70      97.723  94.499  64.672  1.00 56.29           C  
ATOM    547  CG  ASN    70      99.025  94.795  65.410  1.00 62.67           C  
ATOM    548  OD1 ASN    70      99.292  95.939  65.809  1.00 69.67           O  
ATOM    549  ND2 ASN    70      99.833  93.754  65.620  1.00 69.79           N  
ATOM    550  N   GLU    71      97.494  95.180  61.509  1.00 53.46           N  
ATOM    551  CA  GLU    71      98.120  95.181  60.202  1.00 53.66           C  
ATOM    552  C   GLU    71      98.038  96.539  59.483  1.00 53.22           C  
ATOM    553  O   GLU    71      98.893  96.854  58.649  1.00 53.15           O  
ATOM    554  CB  GLU    71      97.480  94.092  59.347  1.00 53.92           C  
ATOM    555  CG  GLU    71      98.156  93.870  58.026  1.00 58.69           C  
ATOM    556  CD  GLU    71      97.542  92.719  57.273  1.00 65.74           C  
ATOM    557  OE1 GLU    71      97.404  91.637  57.887  1.00 67.82           O  
ATOM    558  OE2 GLU    71      97.205  92.893  56.079  1.00 68.24           O  
ATOM    559  N   GLY    72      97.022  97.341  59.793  1.00 51.92           N  
ATOM    560  CA  GLY    72      96.920  98.636  59.147  1.00 50.61           C  
ATOM    561  C   GLY    72      95.502  99.049  58.821  1.00 49.73           C  
ATOM    562  O   GLY    72      94.600  98.212  58.787  1.00 50.44           O  
ATOM    563  N   ILE    73      95.305 100.336  58.544  1.00 47.95           N  
ATOM    564  CA  ILE    73      93.970 100.851  58.265  1.00 46.95           C  
ATOM    565  C   ILE    73      93.289 100.350  56.984  1.00 48.19           C  
ATOM    566  O   ILE    73      92.067 100.307  56.913  1.00 48.72           O  
ATOM    567  CB  ILE    73      93.965 102.408  58.279  1.00 45.94           C  
ATOM    568  CG1 ILE    73      92.529 102.910  58.439  1.00 44.83           C  
ATOM    569  CG2 ILE    73      94.575 102.956  57.005  1.00 43.64           C  
ATOM    570  CD1 ILE    73      92.435 104.343  58.871  1.00 42.31           C  
ATOM    571  N   SER    74      94.062  99.969  55.977  1.00 49.42           N  
ATOM    572  CA  SER    74      93.464  99.487  54.733  1.00 50.51           C  
ATOM    573  C   SER    74      92.662  98.231  55.036  1.00 51.13           C  
ATOM    574  O   SER    74      91.685  97.907  54.367  1.00 51.71           O  
ATOM    575  CB  SER    74      94.549  99.127  53.714  1.00 51.19           C  
ATOM    576  OG  SER    74      95.090  97.841  53.993  1.00 52.05           O  
ATOM    577  N   THR    75      93.106  97.528  56.064  1.00 51.38           N  
ATOM    578  CA  THR    75      92.490  96.288  56.472  1.00 51.08           C  
ATOM    579  C   THR    75      91.080  96.514  57.000  1.00 50.36           C  
ATOM    580  O   THR    75      90.183  95.709  56.767  1.00 50.15           O  
ATOM    581  CB  THR    75      93.368  95.617  57.536  1.00 51.62           C  
ATOM    582  OG1 THR    75      93.303  94.202  57.378  1.00 56.50           O  
ATOM    583  CG2 THR    75      92.908  95.984  58.939  1.00 50.68           C  
ATOM    584  N   SER    76      90.890  97.620  57.707  1.00 49.57           N  
ATOM    585  CA  SER    76      89.591  97.951  58.269  1.00 50.05           C  
ATOM    586  C   SER    76      88.694  98.509  57.170  1.00 50.81           C  
ATOM    587  O   SER    76      87.514  98.147  57.047  1.00 51.77           O  
ATOM    588  CB  SER    76      89.766  98.980  59.379  1.00 49.11           C  
ATOM    589  OG  SER    76      90.621  98.472  60.377  1.00 47.99           O  
ATOM    590  N   LEU    77      89.285  99.391  56.369  1.00 51.13           N  
ATOM    591  CA  LEU    77      88.623 100.039  55.248  1.00 51.45           C  
ATOM    592  C   LEU    77      88.006  99.002  54.297  1.00 51.62           C  
ATOM    593  O   LEU    77      86.872  99.147  53.844  1.00 51.07           O  
ATOM    594  CB  LEU    77      89.648 100.869  54.485  1.00 50.84           C  
ATOM    595  CG  LEU    77      89.208 102.173  53.837  1.00 52.69           C  
ATOM    596  CD1 LEU    77      90.141 102.457  52.676  1.00 53.42           C  
ATOM    597  CD2 LEU    77      87.781 102.084  53.355  1.00 53.75           C  
ATOM    598  N   LYS    78      88.761  97.957  53.991  1.00 52.16           N  
ATOM    599  CA  LYS    78      88.273  96.937  53.086  1.00 53.11           C  
ATOM    600  C   LYS    78      87.217  96.080  53.748  1.00 54.20           C  
ATOM    601  O   LYS    78      86.285  95.608  53.099  1.00 55.45           O  
ATOM    602  CB  LYS    78      89.437  96.079  52.584  1.00 52.56           C  
ATOM    603  CG  LYS    78      90.489  96.915  51.878  1.00 55.09           C  
ATOM    604  CD  LYS    78      91.324  96.128  50.892  1.00 58.22           C  
ATOM    605  CE  LYS    78      92.303  95.206  51.568  1.00 61.29           C  
ATOM    606  NZ  LYS    78      93.063  94.473  50.536  1.00 63.27           N  
ATOM    607  N   LEU    79      87.353  95.893  55.050  1.00 54.20           N  
ATOM    608  CA  LEU    79      86.397  95.088  55.777  1.00 53.58           C  
ATOM    609  C   LEU    79      85.031  95.748  55.653  1.00 53.51           C  
ATOM    610  O   LEU    79      84.059  95.111  55.263  1.00 53.13           O  
ATOM    611  CB  LEU    79      86.831  94.994  57.237  1.00 54.15           C  
ATOM    612  CG  LEU    79      86.457  93.736  58.017  1.00 55.50           C  
ATOM    613  CD1 LEU    79      86.571  92.523  57.124  1.00 57.45           C  
ATOM    614  CD2 LEU    79      87.383  93.600  59.221  1.00 55.73           C  
ATOM    615  N   GLY    80      84.972  97.039  55.959  1.00 53.82           N  
ATOM    616  CA  GLY    80      83.714  97.756  55.872  1.00 55.07           C  
ATOM    617  C   GLY    80      83.179  97.908  54.458  1.00 56.82           C  
ATOM    618  O   GLY    80      81.963  97.893  54.230  1.00 57.02           O  
ATOM    619  N   LEU    81      84.079  98.054  53.492  1.00 57.52           N  
ATOM    620  CA  LEU    81      83.648  98.220  52.116  1.00 57.35           C  
ATOM    621  C   LEU    81      82.893  97.011  51.573  1.00 57.82           C  
ATOM    622  O   LEU    81      82.142  97.142  50.619  1.00 58.82           O  
ATOM    623  CB  LEU    81      84.837  98.521  51.216  1.00 57.13           C  
ATOM    624  CG  LEU    81      84.401  99.039  49.844  1.00 56.54           C  
ATOM    625  CD1 LEU    81      83.556 100.301  50.013  1.00 58.60           C  
ATOM    626  CD2 LEU    81      85.625  99.330  48.999  1.00 55.16           C  
ATOM    627  N   ARG    82      83.091  95.837  52.163  1.00 58.01           N  
ATOM    628  CA  ARG    82      82.385  94.651  51.696  1.00 59.28           C  
ATOM    629  C   ARG    82      80.888  94.822  51.944  1.00 60.19           C  
ATOM    630  O   ARG    82      80.047  94.463  51.117  1.00 61.66           O  
ATOM    631  CB  ARG    82      82.862  93.400  52.440  1.00 58.88           C  
ATOM    632  CG  ARG    82      84.253  92.902  52.084  1.00 60.07           C  
ATOM    633  CD  ARG    82      84.664  91.815  53.061  1.00 64.01           C  
ATOM    634  NE  ARG    82      84.689  90.481  52.475  1.00 69.56           N  
ATOM    635  CZ  ARG    82      84.530  89.352  53.168  1.00 74.97           C  
ATOM    636  NH1 ARG    82      84.322  89.382  54.488  1.00 78.67           N  
ATOM    637  NH2 ARG    82      84.583  88.183  52.542  1.00 78.06           N  
ATOM    638  N   PHE    83      80.570  95.383  53.098  1.00 60.58           N  
ATOM    639  CA  PHE    83      79.201  95.589  53.510  1.00 61.91           C  
ATOM    640  C   PHE    83      78.471  96.590  52.596  1.00 62.30           C  
ATOM    641  O   PHE    83      77.239  96.590  52.521  1.00 62.65           O  
ATOM    642  CB  PHE    83      79.230  96.029  54.984  1.00 62.22           C  
ATOM    643  CG  PHE    83      77.879  96.200  55.616  1.00 66.17           C  
ATOM    644  CD1 PHE    83      77.191  97.415  55.517  1.00 71.26           C  
ATOM    645  CD2 PHE    83      77.296  95.162  56.333  1.00 69.17           C  
ATOM    646  CE1 PHE    83      75.936  97.597  56.129  1.00 71.89           C  
ATOM    647  CE2 PHE    83      76.044  95.337  56.947  1.00 72.59           C  
ATOM    648  CZ  PHE    83      75.363  96.561  56.841  1.00 71.44           C  
ATOM    649  N   PHE    84      79.223  97.416  51.874  1.00 62.51           N  
ATOM    650  CA  PHE    84      78.621  98.413  50.979  1.00 63.10           C  
ATOM    651  C   PHE    84      79.188  98.342  49.562  1.00 64.76           C  
ATOM    652  O   PHE    84      79.058  99.302  48.800  1.00 63.81           O  
ATOM    653  CB  PHE    84      78.899  99.832  51.485  1.00 62.18           C  
ATOM    654  CG  PHE    84      78.275 100.157  52.801  1.00 60.99           C  
ATOM    655  CD1 PHE    84      76.904 100.276  52.926  1.00 61.57           C  
ATOM    656  CD2 PHE    84      79.068 100.405  53.910  1.00 60.88           C  
ATOM    657  CE1 PHE    84      76.322 100.643  54.144  1.00 63.23           C  
ATOM    658  CE2 PHE    84      78.501 100.772  55.133  1.00 62.44           C  
ATOM    659  CZ  PHE    84      77.126 100.895  55.250  1.00 62.62           C  
ATOM    660  N   LYS    85      79.813  97.226  49.197  1.00 66.95           N  
ATOM    661  CA  LYS    85      80.441  97.130  47.882  1.00 69.13           C  
ATOM    662  C   LYS    85      79.574  97.522  46.688  1.00 70.31           C  
ATOM    663  O   LYS    85      80.069  98.143  45.749  1.00 71.72           O  
ATOM    664  CB  LYS    85      81.027  95.731  47.663  1.00 69.33           C  
ATOM    665  CG  LYS    85      80.041  94.693  47.173  1.00 72.38           C  
ATOM    666  CD  LYS    85      80.705  93.313  47.006  1.00 77.93           C  
ATOM    667  CE  LYS    85      81.890  93.326  46.034  1.00 79.05           C  
ATOM    668  NZ  LYS    85      82.423  91.957  45.746  1.00 80.80           N  
ATOM    669  N   ASP    86      78.290  97.185  46.710  1.00 70.75           N  
ATOM    670  CA  ASP    86      77.429  97.530  45.584  1.00 70.88           C  
ATOM    671  C   ASP    86      76.709  98.877  45.741  1.00 68.94           C  
ATOM    672  O   ASP    86      75.839  99.211  44.940  1.00 70.04           O  
ATOM    673  CB  ASP    86      76.405  96.415  45.354  1.00 72.35           C  
ATOM    674  CG  ASP    86      75.363  96.347  46.458  1.00 79.03           C  
ATOM    675  OD1 ASP    86      75.761  96.439  47.652  1.00 84.31           O  
ATOM    676  OD2 ASP    86      74.155  96.201  46.130  1.00 84.74           O  
ATOM    677  N   TYR    87      77.053  99.644  46.772  1.00 66.71           N  
ATOM    678  CA  TYR    87      76.431 100.956  46.985  1.00 64.20           C  
ATOM    679  C   TYR    87      77.049 101.957  46.031  1.00 64.05           C  
ATOM    680  O   TYR    87      78.094 101.699  45.440  1.00 64.34           O  
ATOM    681  CB  TYR    87      76.652 101.450  48.414  1.00 63.13           C  
ATOM    682  CG  TYR    87      75.656 100.939  49.422  1.00 59.15           C  
ATOM    683  CD1 TYR    87      75.514  99.576  49.662  1.00 54.93           C  
ATOM    684  CD2 TYR    87      74.858 101.828  50.142  1.00 56.10           C  
ATOM    685  CE1 TYR    87      74.593  99.106  50.605  1.00 53.69           C  
ATOM    686  CE2 TYR    87      73.935 101.380  51.080  1.00 54.90           C  
ATOM    687  CZ  TYR    87      73.805 100.017  51.311  1.00 55.64           C  
ATOM    688  OH  TYR    87      72.897  99.568  52.243  1.00 54.58           O  
ATOM    689  N   ASP    88      76.425 103.114  45.893  1.00 63.66           N  
ATOM    690  CA  ASP    88      76.956 104.114  44.983  1.00 64.27           C  
ATOM    691  C   ASP    88      78.246 104.726  45.519  1.00 63.88           C  
ATOM    692  O   ASP    88      79.174 105.003  44.759  1.00 64.49           O  
ATOM    693  CB  ASP    88      75.912 105.211  44.723  1.00 64.96           C  
ATOM    694  CG  ASP    88      74.598 104.650  44.172  1.00 66.85           C  
ATOM    695  OD1 ASP    88      74.657 103.802  43.253  1.00 66.84           O  
ATOM    696  OD2 ASP    88      73.515 105.060  44.654  1.00 69.17           O  
ATOM    697  N   ALA    89      78.302 104.927  46.831  1.00 62.91           N  
ATOM    698  CA  ALA    89      79.478 105.506  47.459  1.00 61.92           C  
ATOM    699  C   ALA    89      79.477 105.253  48.964  1.00 61.48           C  
ATOM    700  O   ALA    89      78.452 104.891  49.550  1.00 61.97           O  
ATOM    701  CB  ALA    89      79.522 107.005  47.184  1.00 61.21           C  
ATOM    702  N   VAL    90      80.636 105.432  49.588  1.00 60.01           N  
ATOM    703  CA  VAL    90      80.749 105.259  51.029  1.00 58.30           C  
ATOM    704  C   VAL    90      81.391 106.492  51.638  1.00 57.14           C  
ATOM    705  O   VAL    90      82.330 107.057  51.076  1.00 56.86           O  
ATOM    706  CB  VAL    90      81.620 104.030  51.415  1.00 58.42           C  
ATOM    707  CG1 VAL    90      80.921 102.750  51.026  1.00 59.19           C  
ATOM    708  CG2 VAL    90      82.986 104.127  50.750  1.00 56.69           C  
ATOM    709  N   LEU    91      80.869 106.918  52.779  1.00 55.61           N  
ATOM    710  CA  LEU    91      81.426 108.057  53.489  1.00 54.63           C  
ATOM    711  C   LEU    91      82.460 107.429  54.438  1.00 54.65           C  
ATOM    712  O   LEU    91      82.096 106.625  55.294  1.00 55.06           O  
ATOM    713  CB  LEU    91      80.334 108.748  54.298  1.00 53.78           C  
ATOM    714  CG  LEU    91      80.245 110.265  54.188  1.00 54.59           C  
ATOM    715  CD1 LEU    91      79.453 110.846  55.380  1.00 51.75           C  
ATOM    716  CD2 LEU    91      81.658 110.832  54.143  1.00 58.18           C  
ATOM    717  N   VAL    92      83.739 107.763  54.279  1.00 53.62           N  
ATOM    718  CA  VAL    92      84.768 107.187  55.140  1.00 52.79           C  
ATOM    719  C   VAL    92      85.057 108.091  56.320  1.00 52.56           C  
ATOM    720  O   VAL    92      85.872 109.001  56.217  1.00 53.69           O  
ATOM    721  CB  VAL    92      86.077 106.949  54.369  1.00 52.25           C  
ATOM    722  CG1 VAL    92      87.152 106.424  55.314  1.00 51.94           C  
ATOM    723  CG2 VAL    92      85.837 105.951  53.246  1.00 54.42           C  
ATOM    724  N   ALA    93      84.405 107.823  57.447  1.00 51.95           N  
ATOM    725  CA  ALA    93      84.571 108.639  58.646  1.00 51.84           C  
ATOM    726  C   ALA    93      85.574 108.062  59.635  1.00 52.15           C  
ATOM    727  O   ALA    93      85.803 106.856  59.683  1.00 52.28           O  
ATOM    728  CB  ALA    93      83.204 108.855  59.344  1.00 50.81           C  
ATOM    729  N   LEU    94      86.164 108.954  60.425  1.00 52.06           N  
ATOM    730  CA  LEU    94      87.140 108.589  61.436  1.00 52.16           C  
ATOM    731  C   LEU    94      86.519 108.758  62.808  1.00 52.91           C  
ATOM    732  O   LEU    94      85.943 109.803  63.096  1.00 52.88           O  
ATOM    733  CB  LEU    94      88.367 109.480  61.305  1.00 52.24           C  
ATOM    734  CG  LEU    94      89.047 109.292  59.954  1.00 51.55           C  
ATOM    735  CD1 LEU    94      89.981 110.437  59.677  1.00 52.65           C  
ATOM    736  CD2 LEU    94      89.772 107.968  59.958  1.00 50.12           C  
ATOM    737  N   GLY    95      86.645 107.719  63.639  1.00 52.92           N  
ATOM    738  CA  GLY    95      86.084 107.727  64.978  1.00 52.70           C  
ATOM    739  C   GLY    95      86.536 108.894  65.817  1.00 53.74           C  
ATOM    740  O   GLY    95      85.732 109.539  66.479  1.00 54.62           O  
ATOM    741  N   ASP    96      87.828 109.186  65.784  1.00 54.69           N  
ATOM    742  CA  ASP    96      88.369 110.287  66.567  1.00 55.37           C  
ATOM    743  C   ASP    96      88.098 111.692  66.000  1.00 56.11           C  
ATOM    744  O   ASP    96      88.752 112.658  66.391  1.00 57.21           O  
ATOM    745  CB  ASP    96      89.872 110.088  66.759  1.00 54.95           C  
ATOM    746  CG  ASP    96      90.627 110.138  65.458  1.00 58.10           C  
ATOM    747  OD1 ASP    96      89.983 110.169  64.388  1.00 60.60           O  
ATOM    748  OD2 ASP    96      91.872 110.139  65.500  1.00 63.56           O  
ATOM    749  N   MET    97      87.150 111.821  65.079  1.00 56.89           N  
ATOM    750  CA  MET    97      86.831 113.139  64.534  1.00 57.64           C  
ATOM    751  C   MET    97      85.379 113.487  64.838  1.00 57.73           C  
ATOM    752  O   MET    97      84.516 113.390  63.973  1.00 58.84           O  
ATOM    753  CB  MET    97      87.064 113.174  63.031  1.00 57.82           C  
ATOM    754  CG  MET    97      88.514 113.141  62.638  1.00 63.08           C  
ATOM    755  SD  MET    97      88.775 113.529  60.755  1.00 81.64          SE  
ATOM    756  CE  MET    97      90.719 113.549  60.713  1.00 79.03           C  
ATOM    757  N   PRO    98      85.097 113.909  66.080  1.00 57.33           N  
ATOM    758  CA  PRO    98      83.743 114.262  66.494  1.00 57.02           C  
ATOM    759  C   PRO    98      83.397 115.741  66.335  1.00 57.95           C  
ATOM    760  O   PRO    98      82.394 116.214  66.887  1.00 57.74           O  
ATOM    761  CB  PRO    98      83.740 113.840  67.950  1.00 56.71           C  
ATOM    762  CG  PRO    98      85.092 114.320  68.391  1.00 56.30           C  
ATOM    763  CD  PRO    98      86.005 113.905  67.244  1.00 57.38           C  
ATOM    764  N   PHE    99      84.215 116.484  65.596  1.00 58.99           N  
ATOM    765  CA  PHE    99      83.935 117.908  65.444  1.00 59.96           C  
ATOM    766  C   PHE    99      83.334 118.255  64.096  1.00 60.17           C  
ATOM    767  O   PHE    99      82.845 119.361  63.902  1.00 59.52           O  
ATOM    768  CB  PHE    99      85.192 118.738  65.731  1.00 60.42           C  
ATOM    769  CG  PHE    99      85.781 118.474  67.093  1.00 61.47           C  
ATOM    770  CD1 PHE    99      85.007 118.635  68.241  1.00 61.18           C  
ATOM    771  CD2 PHE    99      87.086 117.994  67.223  1.00 60.65           C  
ATOM    772  CE1 PHE    99      85.520 118.317  69.497  1.00 60.89           C  
ATOM    773  CE2 PHE    99      87.604 117.675  68.471  1.00 61.94           C  
ATOM    774  CZ  PHE    99      86.820 117.834  69.613  1.00 60.01           C  
ATOM    775  N   VAL   100      83.376 117.315  63.158  1.00 60.42           N  
ATOM    776  CA  VAL   100      82.751 117.542  61.868  1.00 59.65           C  
ATOM    777  C   VAL   100      81.269 117.660  62.251  1.00 59.60           C  
ATOM    778  O   VAL   100      80.797 116.968  63.151  1.00 58.98           O  
ATOM    779  CB  VAL   100      82.999 116.351  60.924  1.00 59.22           C  
ATOM    780  CG1 VAL   100      83.000 115.083  61.705  1.00 59.86           C  
ATOM    781  CG2 VAL   100      81.933 116.284  59.864  1.00 59.54           C  
ATOM    782  N   THR   101      80.538 118.551  61.594  1.00 60.41           N  
ATOM    783  CA  THR   101      79.130 118.766  61.923  1.00 60.04           C  
ATOM    784  C   THR   101      78.182 118.093  60.952  1.00 61.20           C  
ATOM    785  O   THR   101      78.576 117.754  59.839  1.00 61.16           O  
ATOM    786  CB  THR   101      78.803 120.244  61.913  1.00 59.27           C  
ATOM    787  OG1 THR   101      78.981 120.739  60.584  1.00 57.79           O  
ATOM    788  CG2 THR   101      79.711 120.997  62.861  1.00 56.24           C  
ATOM    789  N   LYS   102      76.933 117.903  61.376  1.00 62.74           N  
ATOM    790  CA  LYS   102      75.934 117.286  60.509  1.00 64.81           C  
ATOM    791  C   LYS   102      75.879 118.093  59.232  1.00 65.39           C  
ATOM    792  O   LYS   102      75.819 117.541  58.136  1.00 64.62           O  
ATOM    793  CB  LYS   102      74.548 117.289  61.156  1.00 65.69           C  
ATOM    794  CG  LYS   102      74.235 116.061  61.996  1.00 69.63           C  
ATOM    795  CD  LYS   102      72.739 115.824  62.059  1.00 74.55           C  
ATOM    796  CE  LYS   102      72.405 114.639  62.937  1.00 77.99           C  
ATOM    797  NZ  LYS   102      72.889 114.863  64.326  1.00 81.50           N  
ATOM    798  N   GLU   103      75.902 119.412  59.391  1.00 66.62           N  
ATOM    799  CA  GLU   103      75.878 120.323  58.257  1.00 68.07           C  
ATOM    800  C   GLU   103      76.974 119.993  57.244  1.00 67.62           C  
ATOM    801  O   GLU   103      76.724 119.985  56.037  1.00 67.46           O  
ATOM    802  CB  GLU   103      76.039 121.763  58.744  1.00 69.67           C  
ATOM    803  CG  GLU   103      74.842 122.277  59.505  1.00 75.46           C  
ATOM    804  CD  GLU   103      73.535 122.020  58.757  1.00 83.50           C  
ATOM    805  OE1 GLU   103      73.498 122.265  57.528  1.00 86.84           O  
ATOM    806  OE2 GLU   103      72.549 121.576  59.396  1.00 86.31           O  
ATOM    807  N   ASP   104      78.185 119.731  57.736  1.00 67.07           N  
ATOM    808  CA  ASP   104      79.305 119.393  56.867  1.00 66.63           C  
ATOM    809  C   ASP   104      78.984 118.133  56.083  1.00 66.12           C  
ATOM    810  O   ASP   104      79.264 118.044  54.886  1.00 65.91           O  
ATOM    811  CB  ASP   104      80.577 119.143  57.679  1.00 66.99           C  
ATOM    812  CG  ASP   104      81.038 120.362  58.440  1.00 68.35           C  
ATOM    813  OD1 ASP   104      80.997 121.463  57.863  1.00 72.59           O  
ATOM    814  OD2 ASP   104      81.458 120.220  59.608  1.00 65.48           O  
ATOM    815  N   VAL   105      78.405 117.150  56.761  1.00 65.88           N  
ATOM    816  CA  VAL   105      78.070 115.899  56.099  1.00 66.65           C  
ATOM    817  C   VAL   105      76.964 116.093  55.070  1.00 67.88           C  
ATOM    818  O   VAL   105      76.948 115.429  54.025  1.00 68.40           O  
ATOM    819  CB  VAL   105      77.632 114.819  57.111  1.00 66.21           C  
ATOM    820  CG1 VAL   105      77.236 113.530  56.369  1.00 63.28           C  
ATOM    821  CG2 VAL   105      78.767 114.554  58.092  1.00 64.83           C  
ATOM    822  N   ASN   106      76.046 117.006  55.372  1.00 68.52           N  
ATOM    823  CA  ASN   106      74.945 117.299  54.475  1.00 69.21           C  
ATOM    824  C   ASN   106      75.521 117.899  53.192  1.00 69.46           C  
ATOM    825  O   ASN   106      75.156 117.491  52.084  1.00 69.79           O  
ATOM    826  CB  ASN   106      73.980 118.278  55.146  1.00 70.36           C  
ATOM    827  CG  ASN   106      72.590 118.252  54.523  1.00 73.18           C  
ATOM    828  OD1 ASN   106      71.923 117.213  54.511  1.00 75.38           O  
ATOM    829  ND2 ASN   106      72.146 119.399  54.003  1.00 78.25           N  
ATOM    830  N   LYS   107      76.434 118.859  53.346  1.00 69.38           N  
ATOM    831  CA  LYS   107      77.072 119.498  52.198  1.00 69.64           C  
ATOM    832  C   LYS   107      77.833 118.484  51.361  1.00 69.90           C  
ATOM    833  O   LYS   107      77.671 118.426  50.147  1.00 70.92           O  
ATOM    834  CB  LYS   107      78.064 120.569  52.643  1.00 69.73           C  
ATOM    835  CG  LYS   107      77.466 121.815  53.240  1.00 70.89           C  
ATOM    836  CD  LYS   107      78.581 122.754  53.661  1.00 72.41           C  
ATOM    837  CE  LYS   107      78.020 123.994  54.287  1.00 75.34           C  
ATOM    838  NZ  LYS   107      77.084 123.633  55.384  1.00 78.79           N  
ATOM    839  N   ILE   108      78.674 117.694  52.018  1.00 69.99           N  
ATOM    840  CA  ILE   108      79.475 116.690  51.326  1.00 70.00           C  
ATOM    841  C   ILE   108      78.630 115.750  50.488  1.00 70.52           C  
ATOM    842  O   ILE   108      78.946 115.489  49.322  1.00 69.75           O  
ATOM    843  CB  ILE   108      80.301 115.837  52.323  1.00 69.97           C  
ATOM    844  CG1 ILE   108      81.223 116.744  53.141  1.00 68.99           C  
ATOM    845  CG2 ILE   108      81.121 114.792  51.562  1.00 67.40           C  
ATOM    846  CD1 ILE   108      82.050 116.021  54.165  1.00 68.64           C  
ATOM    847  N   ILE   109      77.559 115.235  51.084  1.00 71.82           N  
ATOM    848  CA  ILE   109      76.694 114.312  50.372  1.00 73.40           C  
ATOM    849  C   ILE   109      75.963 115.030  49.244  1.00 74.95           C  
ATOM    850  O   ILE   109      75.712 114.444  48.188  1.00 74.87           O  
ATOM    851  CB  ILE   109      75.669 113.648  51.317  1.00 72.92           C  
ATOM    852  CG1 ILE   109      76.396 112.902  52.438  1.00 72.32           C  
ATOM    853  CG2 ILE   109      74.815 112.658  50.543  1.00 73.00           C  
ATOM    854  CD1 ILE   109      75.471 112.152  53.374  1.00 72.12           C  
ATOM    855  N   ASN   110      75.640 116.304  49.454  1.00 76.62           N  
ATOM    856  CA  ASN   110      74.943 117.074  48.427  1.00 77.75           C  
ATOM    857  C   ASN   110      75.827 117.519  47.265  1.00 77.54           C  
ATOM    858  O   ASN   110      75.317 117.937  46.227  1.00 78.41           O  
ATOM    859  CB  ASN   110      74.271 118.306  49.037  1.00 78.60           C  
ATOM    860  CG  ASN   110      73.054 117.952  49.879  1.00 81.57           C  
ATOM    861  OD1 ASN   110      72.228 117.114  49.494  1.00 82.58           O  
ATOM    862  ND2 ASN   110      72.930 118.603  51.031  1.00 85.45           N  
ATOM    863  N   THR   111      77.142 117.424  47.427  1.00 76.50           N  
ATOM    864  CA  THR   111      78.069 117.836  46.379  1.00 75.76           C  
ATOM    865  C   THR   111      78.380 116.689  45.426  1.00 76.37           C  
ATOM    866  O   THR   111      78.986 116.884  44.377  1.00 76.43           O  
ATOM    867  CB  THR   111      79.388 118.337  46.994  1.00 75.39           C  
ATOM    868  OG1 THR   111      79.100 119.332  47.978  1.00 74.42           O  
ATOM    869  CG2 THR   111      80.290 118.936  45.937  1.00 75.41           C  
ATOM    870  N   PHE   112      77.945 115.491  45.788  1.00 77.34           N  
ATOM    871  CA  PHE   112      78.210 114.306  44.982  1.00 78.11           C  
ATOM    872  C   PHE   112      77.405 114.191  43.689  1.00 80.28           C  
ATOM    873  O   PHE   112      76.184 114.050  43.716  1.00 80.80           O  
ATOM    874  CB  PHE   112      77.994 113.060  45.836  1.00 76.72           C  
ATOM    875  CG  PHE   112      78.192 111.781  45.096  1.00 73.51           C  
ATOM    876  CD1 PHE   112      79.335 111.578  44.333  1.00 70.01           C  
ATOM    877  CD2 PHE   112      77.249 110.763  45.182  1.00 71.66           C  
ATOM    878  CE1 PHE   112      79.540 110.378  43.663  1.00 69.79           C  
ATOM    879  CE2 PHE   112      77.443 109.558  44.517  1.00 69.27           C  
ATOM    880  CZ  PHE   112      78.596 109.366  43.755  1.00 69.71           C  
ATOM    881  N   LYS   113      78.103 114.242  42.557  1.00 82.83           N  
ATOM    882  CA  LYS   113      77.463 114.128  41.250  1.00 85.02           C  
ATOM    883  C   LYS   113      78.089 112.966  40.486  1.00 86.49           C  
ATOM    884  O   LYS   113      79.163 112.479  40.850  1.00 86.93           O  
ATOM    885  CB  LYS   113      77.649 115.415  40.446  1.00 84.96           C  
ATOM    886  CG  LYS   113      77.320 116.675  41.213  1.00 85.92           C  
ATOM    887  CD  LYS   113      75.900 116.661  41.722  1.00 88.01           C  
ATOM    888  CE  LYS   113      75.673 117.838  42.646  1.00 90.37           C  
ATOM    889  NZ  LYS   113      74.331 117.785  43.276  1.00 92.40           N  
ATOM    890  N   PRO   114      77.430 112.511  39.406  1.00 87.82           N  
ATOM    891  CA  PRO   114      77.936 111.395  38.593  1.00 88.26           C  
ATOM    892  C   PRO   114      79.341 111.625  38.020  1.00 88.54           C  
ATOM    893  O   PRO   114      80.075 110.672  37.744  1.00 88.72           O  
ATOM    894  CB  PRO   114      76.876 111.262  37.495  1.00 88.45           C  
ATOM    895  CG  PRO   114      75.612 111.728  38.184  1.00 88.65           C  
ATOM    896  CD  PRO   114      76.107 112.954  38.921  1.00 87.87           C  
ATOM    897  N   ASN   115      79.708 112.891  37.838  1.00 88.27           N  
ATOM    898  CA  ASN   115      81.017 113.234  37.299  1.00 87.89           C  
ATOM    899  C   ASN   115      82.099 113.053  38.355  1.00 87.58           C  
ATOM    900  O   ASN   115      83.263 112.827  38.024  1.00 88.00           O  
ATOM    901  CB  ASN   115      81.011 114.676  36.803  1.00 87.90           C  
ATOM    902  N   CYS   116      81.701 113.145  39.623  1.00 86.76           N  
ATOM    903  CA  CYS   116      82.625 113.026  40.747  1.00 86.00           C  
ATOM    904  C   CYS   116      83.114 111.618  41.050  1.00 84.42           C  
ATOM    905  O   CYS   116      82.317 110.697  41.241  1.00 84.56           O  
ATOM    906  CB  CYS   116      81.992 113.593  42.023  1.00 86.32           C  
ATOM    907  SG  CYS   116      81.339 115.287  41.872  1.00 90.88           S  
ATOM    908  N   LYS   117      84.436 111.473  41.101  1.00 82.59           N  
ATOM    909  CA  LYS   117      85.085 110.208  41.429  1.00 80.48           C  
ATOM    910  C   LYS   117      85.085 110.109  42.955  1.00 78.41           C  
ATOM    911  O   LYS   117      84.997 109.026  43.536  1.00 77.64           O  
ATOM    912  CB  LYS   117      86.527 110.211  40.926  1.00 81.04           C  
ATOM    913  CG  LYS   117      86.693 109.859  39.469  1.00 83.13           C  
ATOM    914  CD  LYS   117      86.463 108.377  39.259  1.00 87.67           C  
ATOM    915  CE  LYS   117      86.861 107.948  37.863  1.00 91.25           C  
ATOM    916  NZ  LYS   117      86.017 108.607  36.834  1.00 94.86           N  
ATOM    917  N   ALA   118      85.181 111.268  43.592  1.00 75.75           N  
ATOM    918  CA  ALA   118      85.192 111.348  45.036  1.00 73.60           C  
ATOM    919  C   ALA   118      84.942 112.785  45.442  1.00 72.38           C  
ATOM    920  O   ALA   118      85.389 113.704  44.772  1.00 73.59           O  
ATOM    921  CB  ALA   118      86.529 110.890  45.564  1.00 74.01           C  
ATOM    922  N   VAL   119      84.210 112.976  46.530  1.00 70.08           N  
ATOM    923  CA  VAL   119      83.930 114.309  47.032  1.00 68.06           C  
ATOM    924  C   VAL   119      84.834 114.478  48.231  1.00 67.27           C  
ATOM    925  O   VAL   119      84.939 113.568  49.052  1.00 67.93           O  
ATOM    926  CB  VAL   119      82.487 114.445  47.513  1.00 68.04           C  
ATOM    927  CG1 VAL   119      82.307 115.773  48.190  1.00 66.10           C  
ATOM    928  CG2 VAL   119      81.532 114.315  46.355  1.00 68.91           C  
ATOM    929  N   ILE   120      85.481 115.632  48.348  1.00 65.82           N  
ATOM    930  CA  ILE   120      86.382 115.866  49.468  1.00 64.51           C  
ATOM    931  C   ILE   120      86.098 117.157  50.210  1.00 65.04           C  
ATOM    932  O   ILE   120      86.161 118.246  49.639  1.00 64.40           O  
ATOM    933  CB  ILE   120      87.863 115.901  49.012  1.00 63.92           C  
ATOM    934  CG1 ILE   120      88.264 114.544  48.425  1.00 63.65           C  
ATOM    935  CG2 ILE   120      88.763 116.263  50.187  1.00 61.60           C  
ATOM    936  CD1 ILE   120      89.684 114.494  47.896  1.00 60.61           C  
ATOM    937  N   PRO   121      85.773 117.059  51.505  1.00 65.27           N  
ATOM    938  CA  PRO   121      85.510 118.305  52.230  1.00 65.83           C  
ATOM    939  C   PRO   121      86.783 119.147  52.290  1.00 66.58           C  
ATOM    940  O   PRO   121      87.901 118.618  52.304  1.00 65.85           O  
ATOM    941  CB  PRO   121      85.050 117.820  53.605  1.00 65.49           C  
ATOM    942  CG  PRO   121      85.761 116.510  53.754  1.00 64.49           C  
ATOM    943  CD  PRO   121      85.607 115.889  52.382  1.00 64.85           C  
ATOM    944  N   THR   122      86.595 120.461  52.312  1.00 67.79           N  
ATOM    945  CA  THR   122      87.704 121.402  52.356  1.00 69.21           C  
ATOM    946  C   THR   122      87.402 122.530  53.319  1.00 69.43           C  
ATOM    947  O   THR   122      86.245 122.846  53.592  1.00 69.17           O  
ATOM    948  CB  THR   122      87.962 122.032  50.975  1.00 69.52           C  
ATOM    949  OG1 THR   122      88.161 121.001  50.000  1.00 71.78           O  
ATOM    950  CG2 THR   122      89.194 122.902  51.018  1.00 70.92           C  
ATOM    951  N   HIS   123      88.457 123.134  53.839  1.00 70.60           N  
ATOM    952  CA  HIS   123      88.293 124.250  54.742  1.00 72.73           C  
ATOM    953  C   HIS   123      89.555 125.079  54.795  1.00 74.60           C  
ATOM    954  O   HIS   123      90.575 124.650  55.336  1.00 75.01           O  
ATOM    955  CB  HIS   123      87.915 123.777  56.132  1.00 72.08           C  
ATOM    956  CG  HIS   123      87.799 124.884  57.127  1.00 72.75           C  
ATOM    957  ND1 HIS   123      88.891 125.434  57.756  1.00 74.49           N  
ATOM    958  CD2 HIS   123      86.715 125.527  57.625  1.00 73.58           C  
ATOM    959  CE1 HIS   123      88.487 126.361  58.608  1.00 74.84           C  
ATOM    960  NE2 HIS   123      87.170 126.436  58.547  1.00 73.86           N  
ATOM    961  N   LYS   124      89.463 126.272  54.207  1.00 76.62           N  
ATOM    962  CA  LYS   124      90.561 127.221  54.151  1.00 78.11           C  
ATOM    963  C   LYS   124      91.809 126.634  53.499  1.00 78.93           C  
ATOM    964  O   LYS   124      92.879 126.549  54.113  1.00 79.34           O  
ATOM    965  CB  LYS   124      90.867 127.743  55.553  1.00 78.57           C  
ATOM    966  CG  LYS   124      89.752 128.605  56.124  1.00 80.40           C  
ATOM    967  CD  LYS   124      90.060 129.065  57.544  1.00 83.67           C  
ATOM    968  CE  LYS   124      88.898 129.847  58.140  1.00 84.87           C  
ATOM    969  NZ  LYS   124      89.052 130.018  59.615  1.00 87.62           N  
ATOM    970  N   GLY   125      91.643 126.212  52.248  1.00 79.59           N  
ATOM    971  CA  GLY   125      92.753 125.675  51.485  1.00 80.41           C  
ATOM    972  C   GLY   125      93.002 124.184  51.559  1.00 81.19           C  
ATOM    973  O   GLY   125      93.167 123.532  50.525  1.00 81.94           O  
ATOM    974  N   GLU   126      93.037 123.637  52.771  1.00 81.23           N  
ATOM    975  CA  GLU   126      93.299 122.208  52.949  1.00 80.96           C  
ATOM    976  C   GLU   126      92.057 121.321  52.975  1.00 79.32           C  
ATOM    977  O   GLU   126      90.977 121.743  53.408  1.00 79.79           O  
ATOM    978  CB  GLU   126      94.115 121.994  54.225  1.00 81.55           C  
ATOM    979  CG  GLU   126      93.533 122.678  55.439  1.00 84.47           C  
ATOM    980  CD  GLU   126      94.508 122.726  56.598  1.00 89.37           C  
ATOM    981  OE1 GLU   126      94.954 121.646  57.051  1.00 90.89           O  
ATOM    982  OE2 GLU   126      94.831 123.845  57.058  1.00 91.20           O  
ATOM    983  N   ARG   127      92.225 120.093  52.489  1.00 76.70           N  
ATOM    984  CA  ARG   127      91.141 119.121  52.467  1.00 74.71           C  
ATOM    985  C   ARG   127      91.155 118.253  53.731  1.00 72.90           C  
ATOM    986  O   ARG   127      92.216 117.877  54.233  1.00 72.41           O  
ATOM    987  CB  ARG   127      91.232 118.245  51.211  1.00 74.97           C  
ATOM    988  CG  ARG   127      92.639 117.903  50.754  1.00 75.13           C  
ATOM    989  CD  ARG   127      92.898 118.419  49.339  1.00 76.10           C  
ATOM    990  NE  ARG   127      93.050 117.355  48.344  1.00 77.77           N  
ATOM    991  CZ  ARG   127      93.366 117.569  47.065  1.00 79.80           C  
ATOM    992  NH1 ARG   127      93.561 118.811  46.627  1.00 80.34           N  
ATOM    993  NH2 ARG   127      93.501 116.548  46.220  1.00 78.44           N  
ATOM    994  N   GLY   128      89.963 117.955  54.246  1.00 70.72           N  
ATOM    995  CA  GLY   128      89.845 117.150  55.450  1.00 66.93           C  
ATOM    996  C   GLY   128      88.973 115.917  55.308  1.00 64.25           C  
ATOM    997  O   GLY   128      88.916 115.298  54.250  1.00 64.67           O  
ATOM    998  N   ASN   129      88.294 115.559  56.390  1.00 61.56           N  
ATOM    999  CA  ASN   129      87.428 114.384  56.402  1.00 58.87           C  
ATOM   1000  C   ASN   129      86.078 114.722  57.020  1.00 57.79           C  
ATOM   1001  O   ASN   129      85.945 115.703  57.753  1.00 57.31           O  
ATOM   1002  CB  ASN   129      88.093 113.260  57.189  1.00 58.60           C  
ATOM   1003  CG  ASN   129      89.402 112.817  56.574  1.00 57.95           C  
ATOM   1004  OD1 ASN   129      89.422 112.151  55.537  1.00 56.78           O  
ATOM   1005  ND2 ASN   129      90.508 113.198  57.202  1.00 56.02           N  
ATOM   1006  N   PRO   130      85.071 113.869  56.797  1.00 57.42           N  
ATOM   1007  CA  PRO   130      85.104 112.632  56.014  1.00 56.93           C  
ATOM   1008  C   PRO   130      85.084 112.800  54.507  1.00 57.84           C  
ATOM   1009  O   PRO   130      84.498 113.745  53.983  1.00 58.47           O  
ATOM   1010  CB  PRO   130      83.875 111.898  56.512  1.00 56.26           C  
ATOM   1011  CG  PRO   130      82.909 113.030  56.684  1.00 57.24           C  
ATOM   1012  CD  PRO   130      83.743 114.066  57.403  1.00 56.49           C  
ATOM   1013  N   VAL   131      85.714 111.852  53.822  1.00 58.00           N  
ATOM   1014  CA  VAL   131      85.790 111.834  52.371  1.00 57.97           C  
ATOM   1015  C   VAL   131      84.782 110.849  51.776  1.00 58.42           C  
ATOM   1016  O   VAL   131      84.677 109.704  52.234  1.00 58.77           O  
ATOM   1017  CB  VAL   131      87.204 111.441  51.917  1.00 57.59           C  
ATOM   1018  CG1 VAL   131      87.198 111.014  50.476  1.00 59.19           C  
ATOM   1019  CG2 VAL   131      88.124 112.611  52.088  1.00 58.16           C  
ATOM   1020  N   LEU   132      84.055 111.293  50.750  1.00 58.08           N  
ATOM   1021  CA  LEU   132      83.058 110.449  50.092  1.00 57.65           C  
ATOM   1022  C   LEU   132      83.647 109.779  48.851  1.00 57.67           C  
ATOM   1023  O   LEU   132      83.900 110.443  47.856  1.00 59.54           O  
ATOM   1024  CB  LEU   132      81.833 111.293  49.717  1.00 57.41           C  
ATOM   1025  CG  LEU   132      80.631 110.589  49.074  1.00 58.34           C  
ATOM   1026  CD1 LEU   132      80.298 109.336  49.842  1.00 61.60           C  
ATOM   1027  CD2 LEU   132      79.430 111.512  49.063  1.00 55.91           C  
ATOM   1028  N   ILE   133      83.867 108.468  48.909  1.00 56.74           N  
ATOM   1029  CA  ILE   133      84.448 107.730  47.786  1.00 55.35           C  
ATOM   1030  C   ILE   133      83.375 106.967  47.010  1.00 55.07           C  
ATOM   1031  O   ILE   133      82.522 106.298  47.612  1.00 56.48           O  
ATOM   1032  CB  ILE   133      85.510 106.710  48.265  1.00 55.20           C  
ATOM   1033  CG1 ILE   133      86.601 107.417  49.071  1.00 56.29           C  
ATOM   1034  CG2 ILE   133      86.114 105.996  47.063  1.00 55.79           C  
ATOM   1035  CD1 ILE   133      87.725 106.513  49.499  1.00 57.86           C  
ATOM   1036  N   SER   134      83.443 107.040  45.679  1.00 52.85           N  
ATOM   1037  CA  SER   134      82.458 106.394  44.805  1.00 51.80           C  
ATOM   1038  C   SER   134      82.815 104.995  44.295  1.00 52.90           C  
ATOM   1039  O   SER   134      83.985 104.657  44.136  1.00 53.54           O  
ATOM   1040  CB  SER   134      82.181 107.294  43.602  1.00 51.85           C  
ATOM   1041  OG  SER   134      83.293 107.298  42.722  1.00 47.09           O  
ATOM   1042  N   LYS   135      81.789 104.200  44.007  1.00 55.28           N  
ATOM   1043  CA  LYS   135      81.978 102.836  43.526  1.00 57.82           C  
ATOM   1044  C   LYS   135      83.063 102.729  42.459  1.00 59.79           C  
ATOM   1045  O   LYS   135      83.720 101.689  42.340  1.00 60.63           O  
ATOM   1046  CB  LYS   135      80.648 102.266  42.992  1.00 56.16           C  
ATOM   1047  N   SER   136      83.259 103.791  41.681  1.00 62.28           N  
ATOM   1048  CA  SER   136      84.284 103.751  40.639  1.00 63.96           C  
ATOM   1049  C   SER   136      85.636 103.438  41.283  1.00 64.38           C  
ATOM   1050  O   SER   136      86.423 102.647  40.741  1.00 65.17           O  
ATOM   1051  CB  SER   136      84.355 105.083  39.887  1.00 64.03           C  
ATOM   1052  OG  SER   136      84.767 106.133  40.741  1.00 67.09           O  
ATOM   1053  N   LEU   137      85.880 104.042  42.448  1.00 64.20           N  
ATOM   1054  CA  LEU   137      87.118 103.840  43.199  1.00 64.30           C  
ATOM   1055  C   LEU   137      87.153 102.611  44.128  1.00 63.64           C  
ATOM   1056  O   LEU   137      88.192 102.327  44.717  1.00 63.46           O  
ATOM   1057  CB  LEU   137      87.443 105.078  44.042  1.00 64.99           C  
ATOM   1058  CG  LEU   137      87.910 106.363  43.359  1.00 67.10           C  
ATOM   1059  CD1 LEU   137      89.022 106.027  42.382  1.00 68.80           C  
ATOM   1060  CD2 LEU   137      86.754 107.025  42.647  1.00 70.31           C  
ATOM   1061  N   PHE   138      86.051 101.882  44.282  1.00 62.43           N  
ATOM   1062  CA  PHE   138      86.104 100.728  45.172  1.00 62.24           C  
ATOM   1063  C   PHE   138      87.174  99.736  44.722  1.00 63.75           C  
ATOM   1064  O   PHE   138      87.849  99.132  45.552  1.00 65.01           O  
ATOM   1065  CB  PHE   138      84.746 100.011  45.275  1.00 60.61           C  
ATOM   1066  CG  PHE   138      83.649 100.842  45.899  1.00 55.89           C  
ATOM   1067  CD1 PHE   138      83.911 102.108  46.424  1.00 52.20           C  
ATOM   1068  CD2 PHE   138      82.341 100.363  45.939  1.00 54.02           C  
ATOM   1069  CE1 PHE   138      82.884 102.891  46.974  1.00 50.00           C  
ATOM   1070  CE2 PHE   138      81.306 101.135  46.485  1.00 53.26           C  
ATOM   1071  CZ  PHE   138      81.580 102.401  47.005  1.00 52.41           C  
ATOM   1072  N   ASN   139      87.350  99.558  43.418  1.00 65.81           N  
ATOM   1073  CA  ASN   139      88.372  98.615  42.955  1.00 67.56           C  
ATOM   1074  C   ASN   139      89.744  99.043  43.470  1.00 68.24           C  
ATOM   1075  O   ASN   139      90.535  98.219  43.918  1.00 68.02           O  
ATOM   1076  CB  ASN   139      88.384  98.539  41.433  1.00 67.28           C  
ATOM   1077  N   GLU   140      90.012 100.342  43.413  1.00 69.37           N  
ATOM   1078  CA  GLU   140      91.285 100.880  43.863  1.00 70.51           C  
ATOM   1079  C   GLU   140      91.556 100.634  45.329  1.00 70.69           C  
ATOM   1080  O   GLU   140      92.644 100.196  45.703  1.00 71.04           O  
ATOM   1081  CB  GLU   140      91.342 102.380  43.597  1.00 71.48           C  
ATOM   1082  CG  GLU   140      91.568 102.719  42.147  1.00 74.90           C  
ATOM   1083  CD  GLU   140      92.902 102.195  41.651  1.00 79.72           C  
ATOM   1084  OE1 GLU   140      93.952 102.688  42.138  1.00 80.78           O  
ATOM   1085  OE2 GLU   140      92.894 101.287  40.783  1.00 81.31           O  
ATOM   1086  N   ILE   141      90.568 100.928  46.166  1.00 71.01           N  
ATOM   1087  CA  ILE   141      90.736 100.754  47.598  1.00 70.87           C  
ATOM   1088  C   ILE   141      91.025  99.294  47.941  1.00 70.05           C  
ATOM   1089  O   ILE   141      91.832  99.015  48.828  1.00 70.27           O  
ATOM   1090  CB  ILE   141      89.507 101.342  48.385  1.00 71.02           C  
ATOM   1091  CG1 ILE   141      89.560 100.931  49.851  1.00 72.11           C  
ATOM   1092  CG2 ILE   141      88.219 100.909  47.761  1.00 71.02           C  
ATOM   1093  CD1 ILE   141      88.892  99.606  50.139  1.00 75.02           C  
ATOM   1094  N   GLU   142      90.410  98.365  47.217  1.00 69.37           N  
ATOM   1095  CA  GLU   142      90.659  96.947  47.467  1.00 69.15           C  
ATOM   1096  C   GLU   142      92.147  96.636  47.267  1.00 68.76           C  
ATOM   1097  O   GLU   142      92.722  95.818  47.981  1.00 68.80           O  
ATOM   1098  CB  GLU   142      89.813  96.086  46.535  1.00 68.61           C  
ATOM   1099  N   LYS   143      92.766  97.308  46.299  1.00 68.67           N  
ATOM   1100  CA  LYS   143      94.184  97.113  45.980  1.00 68.20           C  
ATOM   1101  C   LYS   143      95.122  97.568  47.105  1.00 67.70           C  
ATOM   1102  O   LYS   143      96.254  97.090  47.225  1.00 68.14           O  
ATOM   1103  CB  LYS   143      94.525  97.850  44.676  1.00 68.56           C  
ATOM   1104  N   LEU   144      94.645  98.499  47.921  1.00 66.67           N  
ATOM   1105  CA  LEU   144      95.408  99.020  49.049  1.00 65.38           C  
ATOM   1106  C   LEU   144      96.016  97.900  49.921  1.00 64.92           C  
ATOM   1107  O   LEU   144      95.476  96.787  49.994  1.00 64.21           O  
ATOM   1108  CB  LEU   144      94.483  99.898  49.897  1.00 65.48           C  
ATOM   1109  CG  LEU   144      94.824 101.371  50.106  1.00 66.58           C  
ATOM   1110  CD1 LEU   144      95.439 101.960  48.858  1.00 67.08           C  
ATOM   1111  CD2 LEU   144      93.557 102.119  50.485  1.00 66.22           C  
ATOM   1112  N   ARG   145      97.138  98.207  50.578  1.00 64.60           N  
ATOM   1113  CA  ARG   145      97.823  97.256  51.465  1.00 64.15           C  
ATOM   1114  C   ARG   145      98.183  97.860  52.819  1.00 63.00           C  
ATOM   1115  O   ARG   145      98.368  99.075  52.951  1.00 62.62           O  
ATOM   1116  CB  ARG   145      99.101  96.724  50.813  1.00 64.74           C  
ATOM   1117  CG  ARG   145      98.853  95.634  49.791  1.00 69.68           C  
ATOM   1118  CD  ARG   145      99.825  95.721  48.615  1.00 76.97           C  
ATOM   1119  NE  ARG   145     101.228  95.680  49.025  1.00 79.89           N  
ATOM   1120  CZ  ARG   145     101.807  94.649  49.633  1.00 80.04           C  
ATOM   1121  NH1 ARG   145     101.106  93.557  49.911  1.00 77.46           N  
ATOM   1122  NH2 ARG   145     103.091  94.713  49.966  1.00 80.64           N  
ATOM   1123  N   GLY   146      98.270  96.987  53.819  1.00 61.83           N  
ATOM   1124  CA  GLY   146      98.634  97.387  55.168  1.00 59.45           C  
ATOM   1125  C   GLY   146      97.976  98.610  55.772  1.00 58.65           C  
ATOM   1126  O   GLY   146      96.751  98.673  55.929  1.00 57.38           O  
ATOM   1127  N   ASP   147      98.812  99.585  56.120  1.00 57.90           N  
ATOM   1128  CA  ASP   147      98.349 100.817  56.742  1.00 57.47           C  
ATOM   1129  C   ASP   147      98.253 101.992  55.776  1.00 57.66           C  
ATOM   1130  O   ASP   147      98.311 103.150  56.189  1.00 58.10           O  
ATOM   1131  CB  ASP   147      99.268 101.203  57.894  1.00 56.82           C  
ATOM   1132  CG  ASP   147      98.572 102.069  58.919  1.00 58.56           C  
ATOM   1133  OD1 ASP   147      99.230 102.956  59.494  1.00 60.43           O  
ATOM   1134  OD2 ASP   147      97.365 101.852  59.160  1.00 61.44           O  
ATOM   1135  N   VAL   148      98.118 101.695  54.491  1.00 57.82           N  
ATOM   1136  CA  VAL   148      97.990 102.741  53.491  1.00 57.65           C  
ATOM   1137  C   VAL   148      96.523 103.100  53.383  1.00 58.26           C  
ATOM   1138  O   VAL   148      95.702 102.241  53.075  1.00 57.77           O  
ATOM   1139  CB  VAL   148      98.470 102.259  52.130  1.00 57.60           C  
ATOM   1140  CG1 VAL   148      98.224 103.321  51.090  1.00 55.84           C  
ATOM   1141  CG2 VAL   148      99.929 101.907  52.207  1.00 57.70           C  
ATOM   1142  N   GLY   149      96.205 104.367  53.632  1.00 59.53           N  
ATOM   1143  CA  GLY   149      94.829 104.826  53.570  1.00 61.31           C  
ATOM   1144  C   GLY   149      94.349 105.192  52.182  1.00 63.72           C  
ATOM   1145  O   GLY   149      95.051 104.994  51.189  1.00 64.43           O  
ATOM   1146  N   ALA   150      93.147 105.746  52.110  1.00 65.36           N  
ATOM   1147  CA  ALA   150      92.564 106.128  50.831  1.00 67.42           C  
ATOM   1148  C   ALA   150      93.150 107.416  50.231  1.00 68.74           C  
ATOM   1149  O   ALA   150      93.027 107.648  49.025  1.00 68.20           O  
ATOM   1150  CB  ALA   150      91.052 106.251  50.975  1.00 67.32           C  
ATOM   1151  N   ARG   151      93.794 108.241  51.058  1.00 71.18           N  
ATOM   1152  CA  ARG   151      94.378 109.491  50.570  1.00 74.01           C  
ATOM   1153  C   ARG   151      95.388 109.269  49.453  1.00 75.14           C  
ATOM   1154  O   ARG   151      95.635 110.154  48.635  1.00 75.26           O  
ATOM   1155  CB  ARG   151      95.047 110.262  51.702  1.00 74.25           C  
ATOM   1156  CG  ARG   151      95.632 111.606  51.257  1.00 77.89           C  
ATOM   1157  CD  ARG   151      95.776 112.564  52.437  1.00 84.37           C  
ATOM   1158  NE  ARG   151      96.526 111.945  53.525  1.00 89.32           N  
ATOM   1159  CZ  ARG   151      97.811 111.612  53.452  1.00 91.28           C  
ATOM   1160  NH1 ARG   151      98.501 111.848  52.338  1.00 90.83           N  
ATOM   1161  NH2 ARG   151      98.400 111.020  54.487  1.00 92.52           N  
ATOM   1162  N   VAL   152      95.969 108.080  49.420  1.00 76.27           N  
ATOM   1163  CA  VAL   152      96.933 107.758  48.390  1.00 77.39           C  
ATOM   1164  C   VAL   152      96.218 107.653  47.055  1.00 77.89           C  
ATOM   1165  O   VAL   152      96.724 108.117  46.035  1.00 77.93           O  
ATOM   1166  CB  VAL   152      97.636 106.434  48.695  1.00 77.65           C  
ATOM   1167  CG1 VAL   152      98.684 106.155  47.643  1.00 76.78           C  
ATOM   1168  CG2 VAL   152      98.274 106.505  50.072  1.00 80.17           C  
ATOM   1169  N   ILE   153      95.033 107.050  47.069  1.00 78.94           N  
ATOM   1170  CA  ILE   153      94.243 106.886  45.852  1.00 79.79           C  
ATOM   1171  C   ILE   153      93.630 108.209  45.401  1.00 80.54           C  
ATOM   1172  O   ILE   153      93.329 108.391  44.220  1.00 80.78           O  
ATOM   1173  CB  ILE   153      93.086 105.892  46.051  1.00 79.53           C  
ATOM   1174  CG1 ILE   153      93.615 104.580  46.613  1.00 79.70           C  
ATOM   1175  CG2 ILE   153      92.392 105.624  44.723  1.00 78.74           C  
ATOM   1176  CD1 ILE   153      92.523 103.590  46.929  1.00 81.12           C  
ATOM   1177  N   LEU   154      93.443 109.130  46.344  1.00 81.43           N  
ATOM   1178  CA  LEU   154      92.851 110.427  46.027  1.00 81.93           C  
ATOM   1179  C   LEU   154      93.848 111.409  45.398  1.00 83.02           C  
ATOM   1180  O   LEU   154      93.465 112.300  44.639  1.00 83.08           O  
ATOM   1181  CB  LEU   154      92.225 111.044  47.288  1.00 81.24           C  
ATOM   1182  CG  LEU   154      91.005 110.341  47.899  1.00 79.35           C  
ATOM   1183  CD1 LEU   154      90.423 111.199  49.010  1.00 76.84           C  
ATOM   1184  CD2 LEU   154      89.957 110.092  46.833  1.00 78.09           C  
ATOM   1185  N   ASN   155      95.129 111.239  45.700  1.00 84.48           N  
ATOM   1186  CA  ASN   155      96.142 112.132  45.157  1.00 85.67           C  
ATOM   1187  C   ASN   155      96.621 111.689  43.787  1.00 86.38           C  
ATOM   1188  O   ASN   155      97.555 112.265  43.236  1.00 87.30           O  
ATOM   1189  CB  ASN   155      97.325 112.227  46.121  1.00 85.40           C  
ATOM   1190  CG  ASN   155      96.916 112.754  47.478  1.00 86.53           C  
ATOM   1191  OD1 ASN   155      96.189 113.743  47.572  1.00 89.43           O  
ATOM   1192  ND2 ASN   155      97.381 112.102  48.538  1.00 88.56           N  
ATOM   1193  N   LYS   156      95.978 110.669  43.234  1.00 86.65           N  
ATOM   1194  CA  LYS   156      96.355 110.163  41.924  1.00 87.07           C  
ATOM   1195  C   LYS   156      95.167 110.174  40.964  1.00 88.18           C  
ATOM   1196  O   LYS   156      95.101 109.362  40.039  1.00 88.52           O  
ATOM   1197  CB  LYS   156      96.917 108.754  42.049  1.00 86.22           C  
ATOM   1198  N   ILE   157      94.216 111.076  41.192  1.00 89.25           N  
ATOM   1199  CA  ILE   157      93.061 111.177  40.306  1.00 90.64           C  
ATOM   1200  C   ILE   157      92.924 112.613  39.819  1.00 91.38           C  
ATOM   1201  O   ILE   157      93.121 113.564  40.587  1.00 91.57           O  
ATOM   1202  CB  ILE   157      91.731 110.739  40.989  1.00 90.77           C  
ATOM   1203  CG1 ILE   157      91.471 111.576  42.236  1.00 91.50           C  
ATOM   1204  CG2 ILE   157      91.781 109.258  41.332  1.00 90.73           C  
ATOM   1205  CD1 ILE   157      90.091 111.361  42.823  1.00 92.69           C  
ATOM   1206  N   LYS   158      92.593 112.748  38.535  1.00 91.96           N  
ATOM   1207  CA  LYS   158      92.438 114.037  37.862  1.00 92.43           C  
ATOM   1208  C   LYS   158      91.547 115.037  38.592  1.00 92.49           C  
ATOM   1209  O   LYS   158      90.382 114.753  38.871  1.00 92.57           O  
ATOM   1210  CB  LYS   158      91.908 113.810  36.451  1.00 92.67           C  
ATOM   1211  N   ILE   159      92.100 116.215  38.877  1.00 92.42           N  
ATOM   1212  CA  ILE   159      91.364 117.269  39.573  1.00 93.01           C  
ATOM   1213  C   ILE   159      90.042 117.573  38.853  1.00 93.01           C  
ATOM   1214  O   ILE   159      89.114 118.143  39.440  1.00 93.13           O  
ATOM   1215  CB  ILE   159      92.188 118.581  39.649  1.00 93.16           C  
ATOM   1216  CG1 ILE   159      93.679 118.262  39.744  1.00 93.98           C  
ATOM   1217  CG2 ILE   159      91.762 119.392  40.874  1.00 92.59           C  
ATOM   1218  CD1 ILE   159      94.577 119.483  39.653  1.00 94.92           C  
ATOM   1219  N   GLU   160      89.963 117.196  37.579  1.00 92.43           N  
ATOM   1220  CA  GLU   160      88.762 117.430  36.794  1.00 91.90           C  
ATOM   1221  C   GLU   160      87.733 116.371  37.149  1.00 91.72           C  
ATOM   1222  O   GLU   160      86.686 116.271  36.510  1.00 91.47           O  
ATOM   1223  CB  GLU   160      89.089 117.375  35.303  1.00 91.77           C  
ATOM   1224  N   GLU   161      88.037 115.586  38.180  1.00 91.67           N  
ATOM   1225  CA  GLU   161      87.147 114.517  38.625  1.00 91.68           C  
ATOM   1226  C   GLU   161      86.845 114.537  40.126  1.00 90.79           C  
ATOM   1227  O   GLU   161      85.991 113.785  40.602  1.00 90.51           O  
ATOM   1228  CB  GLU   161      87.730 113.160  38.217  1.00 92.12           C  
ATOM   1229  CG  GLU   161      87.775 112.968  36.707  1.00 93.63           C  
ATOM   1230  CD  GLU   161      88.567 111.747  36.282  1.00 96.44           C  
ATOM   1231  OE1 GLU   161      89.811 111.760  36.419  1.00 95.88           O  
ATOM   1232  OE2 GLU   161      87.940 110.775  35.811  1.00 98.07           O  
ATOM   1233  N   LEU   162      87.548 115.385  40.871  1.00 89.70           N  
ATOM   1234  CA  LEU   162      87.294 115.503  42.300  1.00 89.10           C  
ATOM   1235  C   LEU   162      86.207 116.551  42.486  1.00 88.72           C  
ATOM   1236  O   LEU   162      85.885 117.288  41.560  1.00 89.15           O  
ATOM   1237  CB  LEU   162      88.553 115.929  43.061  1.00 89.13           C  
ATOM   1238  CG  LEU   162      89.606 114.852  43.310  1.00 89.45           C  
ATOM   1239  CD1 LEU   162      90.307 114.543  42.011  1.00 91.38           C  
ATOM   1240  CD2 LEU   162      90.605 115.324  44.347  1.00 88.04           C  
ATOM   1241  N   CYS   163      85.637 116.614  43.681  1.00 88.09           N  
ATOM   1242  CA  CYS   163      84.587 117.580  43.968  1.00 87.74           C  
ATOM   1243  C   CYS   163      84.738 118.035  45.410  1.00 86.55           C  
ATOM   1244  O   CYS   163      84.544 117.260  46.342  1.00 87.43           O  
ATOM   1245  CB  CYS   163      83.212 116.942  43.719  1.00 87.82           C  
ATOM   1246  SG  CYS   163      82.989 116.485  41.964  1.00 91.64           S  
ATOM   1247  N   PHE   164      85.096 119.298  45.590  1.00 84.52           N  
ATOM   1248  CA  PHE   164      85.305 119.839  46.919  1.00 83.15           C  
ATOM   1249  C   PHE   164      84.154 120.712  47.388  1.00 83.06           C  
ATOM   1250  O   PHE   164      83.250 121.019  46.622  1.00 83.89           O  
ATOM   1251  CB  PHE   164      86.589 120.658  46.921  1.00 82.45           C  
ATOM   1252  CG  PHE   164      87.750 119.951  46.296  1.00 82.05           C  
ATOM   1253  CD1 PHE   164      88.496 119.028  47.023  1.00 82.19           C  
ATOM   1254  CD2 PHE   164      88.092 120.191  44.975  1.00 81.98           C  
ATOM   1255  CE1 PHE   164      89.567 118.349  46.436  1.00 80.81           C  
ATOM   1256  CE2 PHE   164      89.158 119.517  44.382  1.00 82.43           C  
ATOM   1257  CZ  PHE   164      89.899 118.596  45.116  1.00 80.76           C  
ATOM   1258  N   ILE   165      84.194 121.082  48.665  1.00 82.73           N  
ATOM   1259  CA  ILE   165      83.211 121.965  49.289  1.00 82.62           C  
ATOM   1260  C   ILE   165      83.750 122.403  50.634  1.00 82.13           C  
ATOM   1261  O   ILE   165      84.364 121.619  51.355  1.00 82.40           O  
ATOM   1262  CB  ILE   165      81.819 121.317  49.546  1.00 82.92           C  
ATOM   1263  CG1 ILE   165      81.972 119.925  50.151  1.00 84.16           C  
ATOM   1264  CG2 ILE   165      81.006 121.307  48.272  1.00 84.02           C  
ATOM   1265  CD1 ILE   165      82.258 118.853  49.132  1.00 85.27           C  
ATOM   1266  N   GLU   166      83.519 123.664  50.965  1.00 81.04           N  
ATOM   1267  CA  GLU   166      83.980 124.201  52.224  1.00 80.04           C  
ATOM   1268  C   GLU   166      83.012 123.838  53.317  1.00 78.84           C  
ATOM   1269  O   GLU   166      81.819 124.131  53.224  1.00 79.05           O  
ATOM   1270  CB  GLU   166      84.098 125.715  52.143  1.00 80.39           C  
ATOM   1271  CG  GLU   166      85.356 126.183  51.475  1.00 81.73           C  
ATOM   1272  CD  GLU   166      86.570 126.002  52.358  1.00 84.18           C  
ATOM   1273  OE1 GLU   166      86.607 126.634  53.445  1.00 81.27           O  
ATOM   1274  OE2 GLU   166      87.480 125.233  51.962  1.00 87.18           O  
ATOM   1275  N   CYS   167      83.534 123.188  54.350  1.00 77.43           N  
ATOM   1276  CA  CYS   167      82.735 122.793  55.498  1.00 75.91           C  
ATOM   1277  C   CYS   167      83.425 123.449  56.682  1.00 75.37           C  
ATOM   1278  O   CYS   167      84.381 124.194  56.486  1.00 75.36           O  
ATOM   1279  CB  CYS   167      82.721 121.273  55.624  1.00 75.12           C  
ATOM   1280  SG  CYS   167      82.137 120.444  54.115  1.00 74.97           S  
ATOM   1281  N   SER   168      82.950 123.196  57.896  1.00 74.67           N  
ATOM   1282  CA  SER   168      83.546 123.796  59.087  1.00 74.46           C  
ATOM   1283  C   SER   168      84.979 123.341  59.315  1.00 74.78           C  
ATOM   1284  O   SER   168      85.503 122.490  58.590  1.00 74.75           O  
ATOM   1285  CB  SER   168      82.711 123.466  60.324  1.00 74.60           C  
ATOM   1286  OG  SER   168      82.611 122.068  60.524  1.00 75.49           O  
ATOM   1287  N   GLU   169      85.621 123.909  60.328  1.00 74.91           N  
ATOM   1288  CA  GLU   169      86.993 123.531  60.624  1.00 75.60           C  
ATOM   1289  C   GLU   169      87.033 122.111  61.208  1.00 75.03           C  
ATOM   1290  O   GLU   169      88.088 121.463  61.235  1.00 74.81           O  
ATOM   1291  CB  GLU   169      87.621 124.531  61.599  1.00 75.85           C  
ATOM   1292  CG  GLU   169      86.996 124.527  62.974  1.00 78.98           C  
ATOM   1293  CD  GLU   169      87.788 125.349  63.971  1.00 84.36           C  
ATOM   1294  OE1 GLU   169      89.031 125.397  63.838  1.00 85.45           O  
ATOM   1295  OE2 GLU   169      87.173 125.926  64.895  1.00 86.32           O  
ATOM   1296  N   GLY   170      85.872 121.634  61.661  1.00 74.49           N  
ATOM   1297  CA  GLY   170      85.775 120.301  62.230  1.00 73.18           C  
ATOM   1298  C   GLY   170      86.207 119.243  61.235  1.00 72.55           C  
ATOM   1299  O   GLY   170      86.525 118.121  61.612  1.00 73.48           O  
ATOM   1300  N   VAL   171      86.216 119.606  59.961  1.00 71.29           N  
ATOM   1301  CA  VAL   171      86.618 118.706  58.894  1.00 70.37           C  
ATOM   1302  C   VAL   171      88.126 118.515  58.897  1.00 69.66           C  
ATOM   1303  O   VAL   171      88.662 117.689  58.156  1.00 68.11           O  
ATOM   1304  CB  VAL   171      86.207 119.282  57.534  1.00 71.15           C  
ATOM   1305  CG1 VAL   171      86.843 118.491  56.404  1.00 72.17           C  
ATOM   1306  CG2 VAL   171      84.702 119.258  57.411  1.00 71.59           C  
ATOM   1307  N   LEU   172      88.808 119.284  59.740  1.00 70.43           N  
ATOM   1308  CA  LEU   172      90.262 119.220  59.819  1.00 71.06           C  
ATOM   1309  C   LEU   172      90.784 118.808  61.188  1.00 71.89           C  
ATOM   1310  O   LEU   172      91.947 118.422  61.330  1.00 72.18           O  
ATOM   1311  CB  LEU   172      90.859 120.579  59.460  1.00 70.49           C  
ATOM   1312  CG  LEU   172      90.604 121.171  58.072  1.00 71.03           C  
ATOM   1313  CD1 LEU   172      91.313 122.497  57.991  1.00 69.40           C  
ATOM   1314  CD2 LEU   172      91.105 120.243  56.971  1.00 72.40           C  
ATOM   1315  N   ILE   173      89.920 118.877  62.191  1.00 72.89           N  
ATOM   1316  CA  ILE   173      90.302 118.553  63.556  1.00 74.89           C  
ATOM   1317  C   ILE   173      89.966 117.147  64.029  1.00 75.88           C  
ATOM   1318  O   ILE   173      88.888 116.631  63.764  1.00 77.01           O  
ATOM   1319  CB  ILE   173      89.634 119.534  64.529  1.00 74.91           C  
ATOM   1320  CG1 ILE   173      89.966 120.971  64.114  1.00 75.25           C  
ATOM   1321  CG2 ILE   173      90.062 119.233  65.966  1.00 75.63           C  
ATOM   1322  CD1 ILE   173      89.124 122.017  64.825  1.00 77.55           C  
ATOM   1323  N   ASP   174      90.900 116.536  64.742  1.00 77.31           N  
ATOM   1324  CA  ASP   174      90.693 115.212  65.312  1.00 78.94           C  
ATOM   1325  C   ASP   174      91.163 115.357  66.754  1.00 79.67           C  
ATOM   1326  O   ASP   174      91.927 116.269  67.053  1.00 79.46           O  
ATOM   1327  CB  ASP   174      91.515 114.159  64.575  1.00 79.22           C  
ATOM   1328  CG  ASP   174      92.986 114.352  64.757  1.00 80.14           C  
ATOM   1329  OD1 ASP   174      93.473 114.155  65.890  1.00 84.16           O  
ATOM   1330  OD2 ASP   174      93.654 114.714  63.769  1.00 82.30           O  
ATOM   1331  N   ILE   175      90.709 114.474  67.640  1.00 80.72           N  
ATOM   1332  CA  ILE   175      91.065 114.561  69.055  1.00 81.80           C  
ATOM   1333  C   ILE   175      92.454 115.112  69.310  1.00 83.81           C  
ATOM   1334  O   ILE   175      92.608 116.069  70.067  1.00 84.37           O  
ATOM   1335  CB  ILE   175      90.933 113.211  69.766  1.00 81.18           C  
ATOM   1336  CG1 ILE   175      89.501 112.710  69.642  1.00 80.88           C  
ATOM   1337  CG2 ILE   175      91.239 113.373  71.235  1.00 78.89           C  
ATOM   1338  CD1 ILE   175      88.482 113.718  70.110  1.00 80.65           C  
ATOM   1339  N   ASP   176      93.462 114.527  68.675  1.00 85.66           N  
ATOM   1340  CA  ASP   176      94.826 115.003  68.853  1.00 87.67           C  
ATOM   1341  C   ASP   176      94.997 116.454  68.411  1.00 88.57           C  
ATOM   1342  O   ASP   176      95.491 117.284  69.176  1.00 88.51           O  
ATOM   1343  CB  ASP   176      95.794 114.119  68.078  1.00 88.25           C  
ATOM   1344  CG  ASP   176      95.807 112.694  68.588  1.00 91.14           C  
ATOM   1345  OD1 ASP   176      96.135 112.497  69.785  1.00 94.37           O  
ATOM   1346  OD2 ASP   176      95.487 111.777  67.793  1.00 93.54           O  
ATOM   1347  N   LYS   177      94.579 116.758  67.182  1.00 89.58           N  
ATOM   1348  CA  LYS   177      94.696 118.112  66.627  1.00 90.14           C  
ATOM   1349  C   LYS   177      94.159 119.185  67.567  1.00 90.65           C  
ATOM   1350  O   LYS   177      94.568 120.342  67.494  1.00 91.35           O  
ATOM   1351  CB  LYS   177      93.983 118.193  65.279  1.00 89.55           C  
ATOM   1352  N   LYS   178      93.238 118.801  68.444  1.00 90.82           N  
ATOM   1353  CA  LYS   178      92.670 119.738  69.400  1.00 91.07           C  
ATOM   1354  C   LYS   178      93.395 119.565  70.731  1.00 91.59           C  
ATOM   1355  O   LYS   178      92.770 119.099  71.711  1.00 92.20           O  
ATOM   1356  CB  LYS   178      91.170 119.489  69.564  1.00 90.86           C  
END
