
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  241 ( 1828),  selected  241 , name 1vh1_D
# Molecule2: number of CA atoms  178 ( 1356),  selected  178 , name T0420.pdb
# PARAMETERS: 1vh1_D.T0420.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_D      M       1          3.657
LGA    -       -      N       2           -
LGA    F     3_D      I       3          2.126
LGA    V     4_D      G       4          1.745
LGA    V     5_D      V       5          1.353
LGA    I     6_D      I       6          1.195
LGA    I     7_D      I       7          0.883
LGA    P     8_D      L       8          0.575
LGA    A     9_D      A       9          0.570
LGA    R    10_D      A      10          3.668
LGA    Y    11_D      G      11          3.728
LGA    -       -      E      12           -
LGA    -       -      G      13           -
LGA    -       -      K      14           -
LGA    A    12_D      R      15          4.787
LGA    S    13_D      F      16          4.212
LGA    T    14_D      -       -           -
LGA    R    15_D      -       -           -
LGA    L    16_D      -       -           -
LGA    P    17_D      -       -           -
LGA    G    18_D      -       -           -
LGA    K    19_D      G      17          5.075
LGA    P    20_D      G      18          4.337
LGA    -       -      D      19           -
LGA    -       -      K      20           -
LGA    -       -      L      21           -
LGA    L    21_D      L      22          1.426
LGA    V    22_D      A      23          1.544
LGA    D    23_D      K      24          2.736
LGA    I    24_D      I      25          2.885
LGA    N    25_D      D      26          3.260
LGA    G    26_D      N      27          3.013
LGA    K    27_D      T      28          2.703
LGA    P    28_D      P      29          1.714
LGA    X    29_D      I      30          0.858
LGA    I    30_D      I      31          0.554
LGA    V    31_D      M      32          0.590
LGA    H    32_D      R      33          0.568
LGA    V    33_D      T      34          0.463
LGA    L    34_D      I      35          0.787
LGA    E    35_D      R      36          0.696
LGA    R    36_D      I      37          0.929
LGA    A    37_D      Y      38          1.212
LGA    R    38_D      G      39          0.862
LGA    E    39_D      -       -           -
LGA    S    40_D      -       -           -
LGA    G    41_D      D      40          4.451
LGA    A    42_D      L      41          1.493
LGA    E    43_D      -       -           -
LGA    R    44_D      E      42          0.758
LGA    I    45_D      K      43          0.938
LGA    I    46_D      I      44          1.078
LGA    V    47_D      I      45          1.073
LGA    A    48_D      I      46          0.888
LGA    T    49_D      V      47          0.654
LGA    D    50_D      G      48          1.342
LGA    -       -      K      49           -
LGA    H    51_D      Y      50          3.310
LGA    E    52_D      V      51          2.513
LGA    D    53_D      N      52          2.162
LGA    -       -      E      53           -
LGA    V    54_D      M      54          1.288
LGA    A    55_D      L      55          2.594
LGA    R    56_D      P      56          2.781
LGA    A    57_D      L      57          1.640
LGA    V    58_D      L      58          1.183
LGA    E    59_D      M      59          1.551
LGA    A    60_D      -       -           -
LGA    A    61_D      -       -           -
LGA    G    62_D      D      60          1.933
LGA    G    63_D      Q      61          1.964
LGA    E    64_D      I      62          1.906
LGA    V    65_D      V      63          1.261
LGA    C    66_D      I      64          1.836
LGA    X    67_D      Y      65          1.697
LGA    T    68_D      N      66          1.500
LGA    -       -      P      67           -
LGA    -       -      F      68           -
LGA    -       -      W      69           -
LGA    -       -      N      70           -
LGA    -       -      E      71           -
LGA    S    74_D      G      72          3.871
LGA    G    75_D      I      73          3.182
LGA    T    76_D      S      74          4.259
LGA    E    77_D      T      75          4.408
LGA    R    78_D      S      76          2.310
LGA    L    79_D      L      77          1.183
LGA    A    80_D      K      78          1.429
LGA    E    81_D      L      79          1.618
LGA    V    82_D      G      80          1.186
LGA    V    83_D      L      81          1.093
LGA    E    84_D      R      82          1.956
LGA    K    85_D      -       -           -
LGA    C    86_D      -       -           -
LGA    A    87_D      F      83          3.374
LGA    F    88_D      F      84          1.858
LGA    S    89_D      K      85          4.030
LGA    D    90_D      D      86          2.691
LGA    D    91_D      Y      87          3.594
LGA    T    92_D      D      88          2.919
LGA    V    93_D      A      89          2.106
LGA    I    94_D      V      90          1.030
LGA    V    95_D      L      91          0.741
LGA    N    96_D      V      92          1.154
LGA    V    97_D      A      93          1.478
LGA    Q    98_D      L      94          1.277
LGA    G    99_D      G      95          0.884
LGA    D   100_D      D      96          1.111
LGA    E   101_D      M      97          1.625
LGA    P   102_D      P      98          1.721
LGA    X   103_D      F      99          2.419
LGA    I   104_D      V     100          1.315
LGA    P   105_D      T     101          0.653
LGA    A   106_D      K     102          0.889
LGA    T   107_D      E     103          1.383
LGA    I   108_D      D     104          1.216
LGA    I   109_D      V     105          1.356
LGA    R   110_D      N     106          2.077
LGA    Q   111_D      K     107          1.915
LGA    V   112_D      I     108          1.757
LGA    A   113_D      I     109          1.853
LGA    D   114_D      N     110          2.019
LGA    N   115_D      T     111          1.684
LGA    L   116_D      F     112          2.005
LGA    A   117_D      -       -           -
LGA    Q   118_D      K     113          2.268
LGA    R   119_D      P     114          2.520
LGA    Q   120_D      N     115          3.417
LGA    V   121_D      C     116          2.384
LGA    G   122_D      K     117          1.869
LGA    X   123_D      A     118          0.909
LGA    A   124_D      V     119          0.688
LGA    T   125_D      I     120          0.416
LGA    L   126_D      P     121          1.690
LGA    A   127_D      T     122          1.238
LGA    V   128_D      H     123          1.543
LGA    P   129_D      K     124          2.230
LGA    I   130_D      -       -           -
LGA    H   131_D      -       -           -
LGA    N   132_D      -       -           -
LGA    A   133_D      -       -           -
LGA    E   134_D      -       -           -
LGA    E   135_D      -       -           -
LGA    A   136_D      -       -           -
LGA    F   137_D      -       -           -
LGA    N   138_D      -       -           -
LGA    P   139_D      -       -           -
LGA    N   140_D      -       -           -
LGA    A   141_D      -       -           -
LGA    V   142_D      -       -           -
LGA    K   143_D      -       -           -
LGA    V   144_D      -       -           -
LGA    V   145_D      -       -           -
LGA    L   146_D      -       -           -
LGA    D   147_D      -       -           -
LGA    A   148_D      -       -           -
LGA    E   149_D      -       -           -
LGA    G   150_D      -       -           -
LGA    Y   151_D      -       -           -
LGA    A   152_D      -       -           -
LGA    L   153_D      -       -           -
LGA    Y   154_D      -       -           -
LGA    F   155_D      -       -           -
LGA    S   156_D      -       -           -
LGA    R   157_D      -       -           -
LGA    A   158_D      -       -           -
LGA    T   159_D      -       -           -
LGA    I   160_D      -       -           -
LGA    P   161_D      -       -           -
LGA    W   162_D      -       -           -
LGA    D   163_D      -       -           -
LGA    R   164_D      -       -           -
LGA    D   165_D      -       -           -
LGA    R   166_D      -       -           -
LGA    F   167_D      -       -           -
LGA    A   168_D      -       -           -
LGA    E   169_D      -       -           -
LGA    G   170_D      -       -           -
LGA    L   171_D      -       -           -
LGA    E   172_D      -       -           -
LGA    T   173_D      -       -           -
LGA    V   174_D      -       -           -
LGA    G   175_D      -       -           -
LGA    D   176_D      -       -           -
LGA    N   177_D      -       -           -
LGA    F   178_D      -       -           -
LGA    L   179_D      G     125          1.434
LGA    R   180_D      E     126          1.655
LGA    H   181_D      R     127          1.518
LGA    L   182_D      G     128          1.476
LGA    G   183_D      N     129          3.071
LGA    I   184_D      P     130          2.128
LGA    Y   185_D      V     131          0.497
LGA    G   186_D      L     132          0.261
LGA    Y   187_D      I     133          1.267
LGA    R   188_D      S     134          2.428
LGA    A   189_D      K     135          4.084
LGA    G   190_D      S     136          4.997
LGA    F   191_D      L     137          1.972
LGA    I   192_D      F     138          2.490
LGA    R   193_D      -       -           -
LGA    R   194_D      N     139          1.082
LGA    Y   195_D      E     140          1.364
LGA    V   196_D      I     141          2.290
LGA    -       -      E     142           -
LGA    N   197_D      K     143          1.197
LGA    W   198_D      L     144           #
LGA    Q   199_D      R     145           -
LGA    -       -      G     146           -
LGA    -       -      D     147           -
LGA    P   200_D      V     148           #
LGA    S   201_D      G     149           -
LGA    P   202_D      -       -           -
LGA    L   203_D      -       -           -
LGA    E   204_D      -       -           -
LGA    H   205_D      -       -           -
LGA    I   206_D      -       -           -
LGA    E   207_D      -       -           -
LGA    X   208_D      -       -           -
LGA    L   209_D      -       -           -
LGA    E   210_D      A     150           #
LGA    Q   211_D      R     151          3.614
LGA    -       -      V     152           -
LGA    -       -      I     153           -
LGA    L   212_D      L     154          4.860
LGA    R   213_D      N     155          4.391
LGA    V   214_D      K     156          3.232
LGA    L   215_D      I     157          1.860
LGA    W   216_D      K     158           #
LGA    Y   217_D      -       -           -
LGA    G   218_D      -       -           -
LGA    E   219_D      -       -           -
LGA    K   220_D      I     159          5.115
LGA    I   221_D      E     160           #
LGA    -       -      E     161           -
LGA    -       -      L     162           -
LGA    H   222_D      C     163          1.432
LGA    V   223_D      F     164          1.375
LGA    A   224_D      I     165          1.842
LGA    V   225_D      E     166          2.109
LGA    A   226_D      C     167          2.158
LGA    Q   227_D      -       -           -
LGA    E   228_D      -       -           -
LGA    V   229_D      S     168          1.468
LGA    P   230_D      E     169          2.598
LGA    G   231_D      G     170          3.058
LGA    -       -      V     171           -
LGA    -       -      L     172           -
LGA    T   232_D      I     173          1.558
LGA    G   233_D      D     174          1.092
LGA    V   234_D      I     175          0.293
LGA    D   235_D      D     176          2.341
LGA    T   236_D      K     177           #
LGA    P   237_D      -       -           -
LGA    E   238_D      -       -           -
LGA    D   239_D      K     178          3.546
LGA    L   240_D      -       -           -
LGA    E   241_D      -       -           -
LGA    R   242_D      -       -           -
LGA    V   243_D      -       -           -
LGA    R   244_D      -       -           -
LGA    A   245_D      -       -           -
LGA    E   246_D      -       -           -
LGA    X   247_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  241  178    5.0    147    2.30    12.93     61.308     6.123

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.741510 * X  +  -0.099400 * Y  +   0.663538 * Z  + -30.878326
  Y_new =  -0.483052 * X  +  -0.765447 * Y  +   0.425149 * Z  + 162.776932
  Z_new =   0.465643 * X  +  -0.635776 * Y  +  -0.615602 * Z  +  96.250366 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.340075    0.801518  [ DEG:  -134.0764     45.9236 ]
  Theta =  -0.484361   -2.657232  [ DEG:   -27.7518   -152.2482 ]
  Phi   =  -0.577389    2.564203  [ DEG:   -33.0820    146.9180 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vh1_D                                        
REMARK     2: T0420.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vh1_D.T0420.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  241  178   5.0  147   2.30   12.93  61.308
REMARK  ---------------------------------------------------------- 
MOLECULE 1vh1_D
HEADER    TRANSFERASE                             01-DEC-03   1VH1              
TITLE     CRYSTAL STRUCTURE OF CMP-KDO SYNTHETASE                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 3-DEOXY-MANNO-OCTULOSONATE CYTIDYLYLTRANSFERASE;           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: CMP-KDO SYNTHETASE, CMP-2-KETO-3-DEOXYOCTULOSONIC           
COMPND   5 ACID SYNTHETASE, CKS;                                                
COMPND   6 EC: 2.7.7.38;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: KDSB, B0918;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    STRUCTURAL GENOMICS                                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    STRUCTURAL GENOMIX                                                    
REVDAT   2   30-AUG-05 1VH1    1       JRNL                                     
REVDAT   1   30-DEC-03 1VH1    0                                                
JRNL        AUTH   J.BADGER,J.M.SAUDER,J.M.ADAMS,S.ANTONYSAMY,K.BAIN,           
JRNL        AUTH 2 M.G.BERGSEID,S.G.BUCHANAN,M.D.BUCHANAN,Y.BATIYENKO,          
JRNL        AUTH 3 J.A.CHRISTOPHER,S.EMTAGE,A.EROSHKINA,I.FEIL,                 
JRNL        AUTH 4 E.B.FURLONG,K.S.GAJIWALA,X.GAO,D.HE,J.HENDLE,                
JRNL        AUTH 5 A.HUBER,K.HODA,P.KEARINS,C.KISSINGER,B.LAUBERT,              
JRNL        AUTH 6 H.A.LEWIS,J.LIN,K.LOOMIS,D.LORIMER,G.LOUIE,                  
JRNL        AUTH 7 M.MALETIC,C.D.MARSH,I.MILLER,J.MOLINARI,                     
JRNL        AUTH 8 H.J.MULLER-DIECKMANN,J.M.NEWMAN,B.W.NOLAND,                  
JRNL        AUTH 9 B.PAGARIGAN,F.PARK,T.S.PEAT,K.W.POST,S.RADOJICIC,            
JRNL        AUTH10 A.RAMOS,R.ROMERO,M.E.RUTTER,W.E.SANDERSON,                   
JRNL        AUTH11 K.D.SCHWINN,J.TRESSER,J.WINHOVEN,T.A.WRIGHT,L.WU,            
JRNL        AUTH12 J.XU,T.J.HARRIS                                              
JRNL        TITL   STRUCTURAL ANALYSIS OF A SET OF PROTEINS RESULTING           
JRNL        TITL 2 FROM A BACTERIAL GENOMICS PROJECT                            
JRNL        REF    PROTEINS                      V.  60   787 2005              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1VH1 A    2   248  UNP    P04951   KDSB_ECOLI       1    247             
DBREF  1VH1 B    2   248  UNP    P04951   KDSB_ECOLI       1    247             
DBREF  1VH1 C    2   248  UNP    P04951   KDSB_ECOLI       1    247             
DBREF  1VH1 D    2   248  UNP    P04951   KDSB_ECOLI       1    247             
SEQRES   1 A  256  MSE SER PHE VAL VAL ILE ILE PRO ALA ARG TYR ALA SER          
SEQRES   2 A  256  THR ARG LEU PRO GLY LYS PRO LEU VAL ASP ILE ASN GLY          
SEQRES   3 A  256  LYS PRO MSE ILE VAL HIS VAL LEU GLU ARG ALA ARG GLU          
SEQRES   4 A  256  SER GLY ALA GLU ARG ILE ILE VAL ALA THR ASP HIS GLU          
SEQRES   5 A  256  ASP VAL ALA ARG ALA VAL GLU ALA ALA GLY GLY GLU VAL          
SEQRES   6 A  256  CYS MSE THR ARG ALA ASP HIS GLN SER GLY THR GLU ARG          
SEQRES   7 A  256  LEU ALA GLU VAL VAL GLU LYS CYS ALA PHE SER ASP ASP          
SEQRES   8 A  256  THR VAL ILE VAL ASN VAL GLN GLY ASP GLU PRO MSE ILE          
SEQRES   9 A  256  PRO ALA THR ILE ILE ARG GLN VAL ALA ASP ASN LEU ALA          
SEQRES  10 A  256  GLN ARG GLN VAL GLY MSE ALA THR LEU ALA VAL PRO ILE          
SEQRES  11 A  256  HIS ASN ALA GLU GLU ALA PHE ASN PRO ASN ALA VAL LYS          
SEQRES  12 A  256  VAL VAL LEU ASP ALA GLU GLY TYR ALA LEU TYR PHE SER          
SEQRES  13 A  256  ARG ALA THR ILE PRO TRP ASP ARG ASP ARG PHE ALA GLU          
SEQRES  14 A  256  GLY LEU GLU THR VAL GLY ASP ASN PHE LEU ARG HIS LEU          
SEQRES  15 A  256  GLY ILE TYR GLY TYR ARG ALA GLY PHE ILE ARG ARG TYR          
SEQRES  16 A  256  VAL ASN TRP GLN PRO SER PRO LEU GLU HIS ILE GLU MSE          
SEQRES  17 A  256  LEU GLU GLN LEU ARG VAL LEU TRP TYR GLY GLU LYS ILE          
SEQRES  18 A  256  HIS VAL ALA VAL ALA GLN GLU VAL PRO GLY THR GLY VAL          
SEQRES  19 A  256  ASP THR PRO GLU ASP LEU GLU ARG VAL ARG ALA GLU MSE          
SEQRES  20 A  256  ARG GLY SER HIS HIS HIS HIS HIS HIS                          
SEQRES   1 B  256  MSE SER PHE VAL VAL ILE ILE PRO ALA ARG TYR ALA SER          
SEQRES   2 B  256  THR ARG LEU PRO GLY LYS PRO LEU VAL ASP ILE ASN GLY          
SEQRES   3 B  256  LYS PRO MSE ILE VAL HIS VAL LEU GLU ARG ALA ARG GLU          
SEQRES   4 B  256  SER GLY ALA GLU ARG ILE ILE VAL ALA THR ASP HIS GLU          
SEQRES   5 B  256  ASP VAL ALA ARG ALA VAL GLU ALA ALA GLY GLY GLU VAL          
SEQRES   6 B  256  CYS MSE THR ARG ALA ASP HIS GLN SER GLY THR GLU ARG          
SEQRES   7 B  256  LEU ALA GLU VAL VAL GLU LYS CYS ALA PHE SER ASP ASP          
SEQRES   8 B  256  THR VAL ILE VAL ASN VAL GLN GLY ASP GLU PRO MSE ILE          
SEQRES   9 B  256  PRO ALA THR ILE ILE ARG GLN VAL ALA ASP ASN LEU ALA          
SEQRES  10 B  256  GLN ARG GLN VAL GLY MSE ALA THR LEU ALA VAL PRO ILE          
SEQRES  11 B  256  HIS ASN ALA GLU GLU ALA PHE ASN PRO ASN ALA VAL LYS          
SEQRES  12 B  256  VAL VAL LEU ASP ALA GLU GLY TYR ALA LEU TYR PHE SER          
SEQRES  13 B  256  ARG ALA THR ILE PRO TRP ASP ARG ASP ARG PHE ALA GLU          
SEQRES  14 B  256  GLY LEU GLU THR VAL GLY ASP ASN PHE LEU ARG HIS LEU          
SEQRES  15 B  256  GLY ILE TYR GLY TYR ARG ALA GLY PHE ILE ARG ARG TYR          
SEQRES  16 B  256  VAL ASN TRP GLN PRO SER PRO LEU GLU HIS ILE GLU MSE          
SEQRES  17 B  256  LEU GLU GLN LEU ARG VAL LEU TRP TYR GLY GLU LYS ILE          
SEQRES  18 B  256  HIS VAL ALA VAL ALA GLN GLU VAL PRO GLY THR GLY VAL          
SEQRES  19 B  256  ASP THR PRO GLU ASP LEU GLU ARG VAL ARG ALA GLU MSE          
SEQRES  20 B  256  ARG GLY SER HIS HIS HIS HIS HIS HIS                          
SEQRES   1 C  256  MSE SER PHE VAL VAL ILE ILE PRO ALA ARG TYR ALA SER          
SEQRES   2 C  256  THR ARG LEU PRO GLY LYS PRO LEU VAL ASP ILE ASN GLY          
SEQRES   3 C  256  LYS PRO MSE ILE VAL HIS VAL LEU GLU ARG ALA ARG GLU          
SEQRES   4 C  256  SER GLY ALA GLU ARG ILE ILE VAL ALA THR ASP HIS GLU          
SEQRES   5 C  256  ASP VAL ALA ARG ALA VAL GLU ALA ALA GLY GLY GLU VAL          
SEQRES   6 C  256  CYS MSE THR ARG ALA ASP HIS GLN SER GLY THR GLU ARG          
SEQRES   7 C  256  LEU ALA GLU VAL VAL GLU LYS CYS ALA PHE SER ASP ASP          
SEQRES   8 C  256  THR VAL ILE VAL ASN VAL GLN GLY ASP GLU PRO MSE ILE          
SEQRES   9 C  256  PRO ALA THR ILE ILE ARG GLN VAL ALA ASP ASN LEU ALA          
SEQRES  10 C  256  GLN ARG GLN VAL GLY MSE ALA THR LEU ALA VAL PRO ILE          
SEQRES  11 C  256  HIS ASN ALA GLU GLU ALA PHE ASN PRO ASN ALA VAL LYS          
SEQRES  12 C  256  VAL VAL LEU ASP ALA GLU GLY TYR ALA LEU TYR PHE SER          
SEQRES  13 C  256  ARG ALA THR ILE PRO TRP ASP ARG ASP ARG PHE ALA GLU          
SEQRES  14 C  256  GLY LEU GLU THR VAL GLY ASP ASN PHE LEU ARG HIS LEU          
SEQRES  15 C  256  GLY ILE TYR GLY TYR ARG ALA GLY PHE ILE ARG ARG TYR          
SEQRES  16 C  256  VAL ASN TRP GLN PRO SER PRO LEU GLU HIS ILE GLU MSE          
SEQRES  17 C  256  LEU GLU GLN LEU ARG VAL LEU TRP TYR GLY GLU LYS ILE          
SEQRES  18 C  256  HIS VAL ALA VAL ALA GLN GLU VAL PRO GLY THR GLY VAL          
SEQRES  19 C  256  ASP THR PRO GLU ASP LEU GLU ARG VAL ARG ALA GLU MSE          
SEQRES  20 C  256  ARG GLY SER HIS HIS HIS HIS HIS HIS                          
SEQRES   1 D  256  MSE SER PHE VAL VAL ILE ILE PRO ALA ARG TYR ALA SER          
SEQRES   2 D  256  THR ARG LEU PRO GLY LYS PRO LEU VAL ASP ILE ASN GLY          
SEQRES   3 D  256  LYS PRO MSE ILE VAL HIS VAL LEU GLU ARG ALA ARG GLU          
SEQRES   4 D  256  SER GLY ALA GLU ARG ILE ILE VAL ALA THR ASP HIS GLU          
SEQRES   5 D  256  ASP VAL ALA ARG ALA VAL GLU ALA ALA GLY GLY GLU VAL          
SEQRES   6 D  256  CYS MSE THR ARG ALA ASP HIS GLN SER GLY THR GLU ARG          
SEQRES   7 D  256  LEU ALA GLU VAL VAL GLU LYS CYS ALA PHE SER ASP ASP          
SEQRES   8 D  256  THR VAL ILE VAL ASN VAL GLN GLY ASP GLU PRO MSE ILE          
SEQRES   9 D  256  PRO ALA THR ILE ILE ARG GLN VAL ALA ASP ASN LEU ALA          
SEQRES  10 D  256  GLN ARG GLN VAL GLY MSE ALA THR LEU ALA VAL PRO ILE          
SEQRES  11 D  256  HIS ASN ALA GLU GLU ALA PHE ASN PRO ASN ALA VAL LYS          
SEQRES  12 D  256  VAL VAL LEU ASP ALA GLU GLY TYR ALA LEU TYR PHE SER          
SEQRES  13 D  256  ARG ALA THR ILE PRO TRP ASP ARG ASP ARG PHE ALA GLU          
SEQRES  14 D  256  GLY LEU GLU THR VAL GLY ASP ASN PHE LEU ARG HIS LEU          
SEQRES  15 D  256  GLY ILE TYR GLY TYR ARG ALA GLY PHE ILE ARG ARG TYR          
SEQRES  16 D  256  VAL ASN TRP GLN PRO SER PRO LEU GLU HIS ILE GLU MSE          
SEQRES  17 D  256  LEU GLU GLN LEU ARG VAL LEU TRP TYR GLY GLU LYS ILE          
SEQRES  18 D  256  HIS VAL ALA VAL ALA GLN GLU VAL PRO GLY THR GLY VAL          
SEQRES  19 D  256  ASP THR PRO GLU ASP LEU GLU ARG VAL ARG ALA GLU MSE          
SEQRES  20 D  256  ARG GLY SER HIS HIS HIS HIS HIS HIS                          
HET    MSE  A  29       8                                                       
HET    MSE  A  67       8                                                       
HET    MSE  A 103       8                                                       
HET    MSE  A 123       8                                                       
HET    MSE  A 208       8                                                       
HET    MSE  A 247       8                                                       
HET    MSE  B  29       8                                                       
HET    MSE  B  67       8                                                       
HET    MSE  B 103       8                                                       
HET    MSE  B 123       8                                                       
HET    MSE  B 208       8                                                       
HET    MSE  B 247       8                                                       
HET    MSE  C  29       8                                                       
HET    MSE  C  67       8                                                       
HET    MSE  C 103       8                                                       
HET    MSE  C 123       8                                                       
HET    MSE  C 208       8                                                       
HET    MSE  C 247       8                                                       
HET    MSE  D  29       8                                                       
HET    MSE  D  67       8                                                       
HET    MSE  D 103       8                                                       
HET    MSE  D 123       8                                                       
HET    MSE  D 208       8                                                       
HET    MSE  D 247       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    24(C5 H11 N O2 SE)                                           
FORMUL   5  HOH   *156(H2 O)                                                    
CRYST1   51.586  130.811  159.081  90.00  90.00  90.00 P 21 21 21   16          
ATOM   5341  N   SER D   2      70.244 108.547  49.764  1.00 64.56           N  
ATOM   5342  CA  SER D   2      70.708 107.373  50.493  1.00 63.54           C  
ATOM   5343  C   SER D   2      72.219 107.237  50.522  1.00 61.58           C  
ATOM   5344  O   SER D   2      72.905 107.223  49.513  1.00 62.95           O  
ATOM   5345  CB  SER D   2      70.092 106.109  49.901  1.00 66.74           C  
ATOM   5346  OG  SER D   2      70.494 104.979  50.662  1.00 72.30           O  
ATOM   5347  N   PHE D   3      72.795 107.064  51.702  1.00 60.05           N  
ATOM   5348  CA  PHE D   3      74.255 106.949  51.796  1.00 57.88           C  
ATOM   5349  C   PHE D   3      74.647 106.280  53.106  1.00 56.86           C  
ATOM   5350  O   PHE D   3      73.877 106.277  54.079  1.00 56.20           O  
ATOM   5351  CB  PHE D   3      74.914 108.299  51.611  1.00 55.86           C  
ATOM   5352  CG  PHE D   3      74.776 109.301  52.715  1.00 51.03           C  
ATOM   5353  CD1 PHE D   3      75.755 109.408  53.691  1.00 52.08           C  
ATOM   5354  CD2 PHE D   3      73.690 110.148  52.773  1.00 50.48           C  
ATOM   5355  CE1 PHE D   3      75.630 110.338  54.723  1.00 52.28           C  
ATOM   5356  CE2 PHE D   3      73.561 111.071  53.803  1.00 54.36           C  
ATOM   5357  CZ  PHE D   3      74.545 111.181  54.773  1.00 51.89           C  
ATOM   5358  N   VAL D   4      75.850 105.737  53.145  1.00 55.44           N  
ATOM   5359  CA  VAL D   4      76.327 105.044  54.335  1.00 56.25           C  
ATOM   5360  C   VAL D   4      77.528 105.768  54.941  1.00 56.69           C  
ATOM   5361  O   VAL D   4      78.404 106.223  54.226  1.00 57.30           O  
ATOM   5362  CB  VAL D   4      76.722 103.593  54.013  1.00 55.07           C  
ATOM   5363  CG1 VAL D   4      77.594 103.001  55.103  1.00 53.84           C  
ATOM   5364  CG2 VAL D   4      75.468 102.743  53.828  1.00 56.03           C  
ATOM   5365  N   VAL D   5      77.574 105.843  56.266  1.00 55.63           N  
ATOM   5366  CA  VAL D   5      78.718 106.437  56.937  1.00 55.62           C  
ATOM   5367  C   VAL D   5      79.497 105.287  57.596  1.00 55.73           C  
ATOM   5368  O   VAL D   5      78.906 104.365  58.148  1.00 54.98           O  
ATOM   5369  CB  VAL D   5      78.337 107.484  57.998  1.00 55.61           C  
ATOM   5370  CG1 VAL D   5      79.505 107.761  58.951  1.00 54.50           C  
ATOM   5371  CG2 VAL D   5      77.898 108.792  57.362  1.00 53.53           C  
ATOM   5372  N   ILE D   6      80.814 105.306  57.455  1.00 55.60           N  
ATOM   5373  CA  ILE D   6      81.672 104.318  58.099  1.00 54.82           C  
ATOM   5374  C   ILE D   6      82.622 105.065  59.050  1.00 56.30           C  
ATOM   5375  O   ILE D   6      83.181 106.099  58.667  1.00 54.69           O  
ATOM   5376  CB  ILE D   6      82.466 103.467  57.130  1.00 51.24           C  
ATOM   5377  CG1 ILE D   6      81.542 102.593  56.272  1.00 49.57           C  
ATOM   5378  CG2 ILE D   6      83.469 102.576  57.878  1.00 52.16           C  
ATOM   5379  CD1 ILE D   6      82.255 101.933  55.111  1.00 50.49           C  
ATOM   5380  N   ILE D   7      82.671 104.623  60.307  1.00 56.14           N  
ATOM   5381  CA  ILE D   7      83.519 105.320  61.269  1.00 59.19           C  
ATOM   5382  C   ILE D   7      84.639 104.428  61.774  1.00 61.53           C  
ATOM   5383  O   ILE D   7      84.459 103.486  62.552  1.00 61.70           O  
ATOM   5384  CB  ILE D   7      82.714 105.919  62.436  1.00 57.61           C  
ATOM   5385  CG1 ILE D   7      81.490 106.692  61.949  1.00 57.31           C  
ATOM   5386  CG2 ILE D   7      83.590 106.843  63.271  1.00 56.70           C  
ATOM   5387  CD1 ILE D   7      80.489 107.078  62.996  1.00 56.14           C  
ATOM   5388  N   PRO D   8      85.840 104.644  61.255  1.00 64.00           N  
ATOM   5389  CA  PRO D   8      87.007 103.881  61.690  1.00 65.66           C  
ATOM   5390  C   PRO D   8      87.271 104.246  63.154  1.00 68.08           C  
ATOM   5391  O   PRO D   8      87.301 105.457  63.428  1.00 69.79           O  
ATOM   5392  CB  PRO D   8      88.133 104.382  60.828  1.00 64.69           C  
ATOM   5393  CG  PRO D   8      87.572 105.317  59.828  1.00 64.18           C  
ATOM   5394  CD  PRO D   8      86.196 105.697  60.278  1.00 64.63           C  
ATOM   5395  N   ALA D   9      87.395 103.280  64.032  1.00 69.96           N  
ATOM   5396  CA  ALA D   9      87.667 103.527  65.438  1.00 73.52           C  
ATOM   5397  C   ALA D   9      89.063 103.032  65.816  1.00 76.56           C  
ATOM   5398  O   ALA D   9      89.279 101.833  65.982  1.00 76.67           O  
ATOM   5399  CB  ALA D   9      86.623 102.849  66.307  1.00 75.50           C  
ATOM   5400  N   ARG D  10      90.012 103.965  65.920  1.00 79.87           N  
ATOM   5401  CA  ARG D  10      91.380 103.578  66.274  1.00 82.64           C  
ATOM   5402  C   ARG D  10      91.558 103.633  67.792  1.00 84.18           C  
ATOM   5403  O   ARG D  10      91.433 104.688  68.400  1.00 83.78           O  
ATOM   5404  CB  ARG D  10      92.400 104.445  65.556  1.00 83.03           C  
ATOM   5405  N   TYR D  11      91.775 102.468  68.385  1.00 86.27           N  
ATOM   5406  CA  TYR D  11      91.973 102.340  69.822  1.00 88.89           C  
ATOM   5407  C   TYR D  11      93.327 102.980  70.160  1.00 91.09           C  
ATOM   5408  O   TYR D  11      93.445 103.827  71.025  1.00 91.65           O  
ATOM   5409  CB  TYR D  11      92.001 100.860  70.200  1.00 88.93           C  
ATOM   5410  CG  TYR D  11      91.733 100.586  71.658  1.00 89.11           C  
ATOM   5411  CD1 TYR D  11      90.446 100.669  72.160  1.00 89.43           C  
ATOM   5412  CD2 TYR D  11      92.760 100.248  72.523  1.00 89.94           C  
ATOM   5413  CE1 TYR D  11      90.189 100.424  73.493  1.00 91.52           C  
ATOM   5414  CE2 TYR D  11      92.512  99.996  73.858  1.00 91.45           C  
ATOM   5415  CZ  TYR D  11      91.225 100.087  74.335  1.00 92.51           C  
ATOM   5416  OH  TYR D  11      90.931  99.853  75.659  1.00 94.94           O  
ATOM   5417  N   ALA D  12      94.298 102.587  69.355  1.00 93.47           N  
ATOM   5418  CA  ALA D  12      95.667 103.014  69.445  1.00 96.13           C  
ATOM   5419  C   ALA D  12      95.818 104.529  69.455  1.00 97.58           C  
ATOM   5420  O   ALA D  12      95.100 105.243  68.761  1.00 98.16           O  
ATOM   5421  CB  ALA D  12      96.430 102.459  68.221  1.00 96.99           C  
ATOM   5422  N   SER D  13      96.770 105.012  70.238  1.00 98.86           N  
ATOM   5423  CA  SER D  13      97.112 106.411  70.310  1.00 99.76           C  
ATOM   5424  C   SER D  13      98.120 106.687  71.427  1.00100.64           C  
ATOM   5425  O   SER D  13      97.841 106.575  72.615  1.00100.63           O  
ATOM   5426  CB  SER D  13      95.931 107.347  70.384  1.00 99.14           C  
ATOM   5427  OG  SER D  13      96.377 108.692  70.512  1.00 99.99           O  
ATOM   5428  N   THR D  14      99.325 107.041  70.994  1.00100.82           N  
ATOM   5429  CA  THR D  14     100.435 107.336  71.877  1.00102.02           C  
ATOM   5430  C   THR D  14     100.094 108.278  73.015  1.00100.91           C  
ATOM   5431  O   THR D  14     100.332 107.964  74.185  1.00100.45           O  
ATOM   5432  CB  THR D  14     101.620 107.905  71.059  1.00105.41           C  
ATOM   5433  OG1 THR D  14     102.288 106.817  70.392  1.00106.44           O  
ATOM   5434  CG2 THR D  14     102.599 108.665  71.927  1.00106.39           C  
ATOM   5435  N   ARG D  15      99.580 109.465  72.707  1.00100.20           N  
ATOM   5436  CA  ARG D  15      99.264 110.449  73.725  1.00 99.53           C  
ATOM   5437  C   ARG D  15      97.887 110.279  74.337  1.00 98.45           C  
ATOM   5438  O   ARG D  15      97.541 111.006  75.283  1.00 98.17           O  
ATOM   5439  CB  ARG D  15      99.396 111.878  73.159  1.00 99.66           C  
ATOM   5440  N   LEU D  16      97.088 109.356  73.808  1.00 97.09           N  
ATOM   5441  CA  LEU D  16      95.715 109.178  74.314  1.00 94.75           C  
ATOM   5442  C   LEU D  16      95.269 107.737  74.142  1.00 92.44           C  
ATOM   5443  O   LEU D  16      94.719 107.375  73.107  1.00 92.44           O  
ATOM   5444  CB  LEU D  16      94.787 110.097  73.526  1.00 95.98           C  
ATOM   5445  CG  LEU D  16      93.537 110.623  74.204  1.00 96.96           C  
ATOM   5446  CD1 LEU D  16      93.821 111.141  75.604  1.00 96.86           C  
ATOM   5447  CD2 LEU D  16      92.928 111.744  73.347  1.00 97.67           C  
ATOM   5448  N   PRO D  17      95.575 106.897  75.118  1.00 90.37           N  
ATOM   5449  CA  PRO D  17      95.237 105.491  75.058  1.00 88.34           C  
ATOM   5450  C   PRO D  17      93.736 105.274  75.141  1.00 85.68           C  
ATOM   5451  O   PRO D  17      93.043 106.057  75.786  1.00 85.08           O  
ATOM   5452  CB  PRO D  17      95.980 104.872  76.216  1.00 88.94           C  
ATOM   5453  CG  PRO D  17      96.569 105.945  77.016  1.00 89.75           C  
ATOM   5454  CD  PRO D  17      96.219 107.262  76.395  1.00 90.51           C  
ATOM   5455  N   GLY D  18      93.230 104.274  74.447  1.00 83.70           N  
ATOM   5456  CA  GLY D  18      91.829 103.909  74.371  1.00 80.78           C  
ATOM   5457  C   GLY D  18      90.945 105.074  73.940  1.00 78.91           C  
ATOM   5458  O   GLY D  18      89.756 105.139  74.261  1.00 78.81           O  
ATOM   5459  N   LYS D  19      91.435 105.912  73.026  1.00 76.50           N  
ATOM   5460  CA  LYS D  19      90.753 107.114  72.633  1.00 74.62           C  
ATOM   5461  C   LYS D  19      89.318 107.004  72.246  1.00 74.09           C  
ATOM   5462  O   LYS D  19      88.490 107.795  72.769  1.00 73.12           O  
ATOM   5463  CB  LYS D  19      91.576 108.046  71.816  1.00 73.52           C  
ATOM   5464  CG  LYS D  19      91.948 107.728  70.396  1.00 73.18           C  
ATOM   5465  CD  LYS D  19      92.070 109.070  69.639  1.00 71.32           C  
ATOM   5466  CE  LYS D  19      93.099 108.984  68.554  1.00 71.69           C  
ATOM   5467  NZ  LYS D  19      93.272 110.278  67.835  1.00 72.77           N  
ATOM   5468  N   PRO D  20      88.866 106.006  71.508  1.00 74.20           N  
ATOM   5469  CA  PRO D  20      87.452 105.875  71.172  1.00 73.79           C  
ATOM   5470  C   PRO D  20      86.577 105.844  72.406  1.00 74.15           C  
ATOM   5471  O   PRO D  20      85.488 106.430  72.405  1.00 74.13           O  
ATOM   5472  CB  PRO D  20      87.351 104.620  70.355  1.00 73.30           C  
ATOM   5473  CG  PRO D  20      88.669 103.950  70.432  1.00 73.35           C  
ATOM   5474  CD  PRO D  20      89.673 105.010  70.782  1.00 73.94           C  
ATOM   5475  N   LEU D  21      87.033 105.202  73.480  1.00 74.36           N  
ATOM   5476  CA  LEU D  21      86.275 105.119  74.706  1.00 74.19           C  
ATOM   5477  C   LEU D  21      86.459 106.257  75.672  1.00 74.80           C  
ATOM   5478  O   LEU D  21      85.791 106.284  76.721  1.00 75.94           O  
ATOM   5479  CB  LEU D  21      86.502 103.756  75.377  1.00 70.93           C  
ATOM   5480  CG  LEU D  21      85.889 102.580  74.608  1.00 72.79           C  
ATOM   5481  CD1 LEU D  21      85.866 101.310  75.441  1.00 69.43           C  
ATOM   5482  CD2 LEU D  21      84.468 102.918  74.146  1.00 73.64           C  
ATOM   5483  N   VAL D  22      87.328 107.207  75.388  1.00 75.62           N  
ATOM   5484  CA  VAL D  22      87.526 108.363  76.272  1.00 75.60           C  
ATOM   5485  C   VAL D  22      86.184 109.000  76.596  1.00 75.03           C  
ATOM   5486  O   VAL D  22      85.361 109.193  75.705  1.00 74.26           O  
ATOM   5487  CB  VAL D  22      88.457 109.370  75.579  1.00 77.01           C  
ATOM   5488  CG1 VAL D  22      88.209 110.769  76.093  1.00 80.50           C  
ATOM   5489  CG2 VAL D  22      89.913 108.963  75.814  1.00 78.07           C  
ATOM   5490  N   ASP D  23      85.944 109.331  77.860  1.00 75.79           N  
ATOM   5491  CA  ASP D  23      84.661 109.906  78.248  1.00 76.85           C  
ATOM   5492  C   ASP D  23      84.614 111.388  77.931  1.00 76.92           C  
ATOM   5493  O   ASP D  23      85.583 112.093  78.211  1.00 76.83           O  
ATOM   5494  CB  ASP D  23      84.368 109.692  79.734  1.00 81.60           C  
ATOM   5495  CG  ASP D  23      83.232 110.581  80.214  1.00 85.56           C  
ATOM   5496  OD1 ASP D  23      83.507 111.484  81.034  1.00 89.19           O  
ATOM   5497  OD2 ASP D  23      82.086 110.412  79.755  1.00 87.99           O  
ATOM   5498  N   ILE D  24      83.538 111.815  77.284  1.00 77.05           N  
ATOM   5499  CA  ILE D  24      83.369 113.221  76.940  1.00 77.90           C  
ATOM   5500  C   ILE D  24      81.972 113.658  77.404  1.00 78.46           C  
ATOM   5501  O   ILE D  24      80.978 113.326  76.768  1.00 78.81           O  
ATOM   5502  CB  ILE D  24      83.508 113.548  75.454  1.00 78.17           C  
ATOM   5503  CG1 ILE D  24      84.898 113.206  74.924  1.00 78.37           C  
ATOM   5504  CG2 ILE D  24      83.199 115.030  75.207  1.00 76.97           C  
ATOM   5505  CD1 ILE D  24      84.964 112.926  73.448  1.00 76.49           C  
ATOM   5506  N   ASN D  25      81.941 114.313  78.555  1.00 78.51           N  
ATOM   5507  CA  ASN D  25      80.724 114.824  79.142  1.00 77.64           C  
ATOM   5508  C   ASN D  25      79.633 113.779  79.235  1.00 77.19           C  
ATOM   5509  O   ASN D  25      78.487 114.040  78.870  1.00 77.05           O  
ATOM   5510  CB  ASN D  25      80.230 116.050  78.345  1.00 79.55           C  
ATOM   5511  CG  ASN D  25      81.323 117.102  78.275  1.00 83.13           C  
ATOM   5512  OD1 ASN D  25      82.260 117.061  79.089  1.00 85.38           O  
ATOM   5513  ND2 ASN D  25      81.239 117.999  77.314  1.00 83.08           N  
ATOM   5514  N   GLY D  26      79.972 112.572  79.705  1.00 76.77           N  
ATOM   5515  CA  GLY D  26      79.024 111.506  79.854  1.00 74.87           C  
ATOM   5516  C   GLY D  26      79.033 110.384  78.871  1.00 74.46           C  
ATOM   5517  O   GLY D  26      78.468 109.304  79.148  1.00 76.01           O  
ATOM   5518  N   LYS D  27      79.580 110.521  77.660  1.00 73.36           N  
ATOM   5519  CA  LYS D  27      79.566 109.402  76.722  1.00 70.80           C  
ATOM   5520  C   LYS D  27      80.869 109.263  75.971  1.00 68.71           C  
ATOM   5521  O   LYS D  27      81.648 110.217  75.876  1.00 70.48           O  
ATOM   5522  CB  LYS D  27      78.360 109.386  75.826  1.00 70.16           C  
ATOM   5523  CG  LYS D  27      77.720 110.690  75.475  1.00 72.12           C  
ATOM   5524  CD  LYS D  27      76.379 110.489  74.776  1.00 72.50           C  
ATOM   5525  CE  LYS D  27      75.580 111.772  74.803  1.00 75.78           C  
ATOM   5526  NZ  LYS D  27      75.128 112.194  73.456  1.00 76.44           N  
ATOM   5527  N   PRO D  28      81.155 108.052  75.502  1.00 66.50           N  
ATOM   5528  CA  PRO D  28      82.390 107.780  74.792  1.00 65.23           C  
ATOM   5529  C   PRO D  28      82.464 108.491  73.457  1.00 65.03           C  
ATOM   5530  O   PRO D  28      81.558 108.463  72.616  1.00 64.72           O  
ATOM   5531  CB  PRO D  28      82.428 106.276  74.648  1.00 64.93           C  
ATOM   5532  CG  PRO D  28      81.034 105.817  74.810  1.00 65.46           C  
ATOM   5533  CD  PRO D  28      80.288 106.863  75.575  1.00 64.97           C  
HETATM 5534  N   MSE D  29      83.616 109.103  73.203  1.00 64.05           N  
HETATM 5535  CA  MSE D  29      83.890 109.809  71.972  1.00 63.69           C  
HETATM 5536  C   MSE D  29      83.293 109.144  70.732  1.00 61.09           C  
HETATM 5537  O   MSE D  29      82.557 109.782  69.965  1.00 58.47           O  
HETATM 5538  CB  MSE D  29      85.408 109.979  71.787  1.00 68.01           C  
HETATM 5539  CG  MSE D  29      85.713 111.110  70.806  1.00 77.30           C  
HETATM 5540 SE   MSE D  29      87.590 111.293  70.495  1.00 88.59          SE  
HETATM 5541  CE  MSE D  29      88.087 112.172  72.121  1.00 88.42           C  
ATOM   5542  N   ILE D  30      83.550 107.855  70.538  1.00 58.44           N  
ATOM   5543  CA  ILE D  30      82.993 107.127  69.413  1.00 59.12           C  
ATOM   5544  C   ILE D  30      81.492 107.367  69.292  1.00 59.78           C  
ATOM   5545  O   ILE D  30      80.998 107.762  68.238  1.00 58.47           O  
ATOM   5546  CB  ILE D  30      83.353 105.647  69.408  1.00 59.22           C  
ATOM   5547  CG1 ILE D  30      83.214 105.059  67.998  1.00 57.18           C  
ATOM   5548  CG2 ILE D  30      82.571 104.797  70.402  1.00 54.97           C  
ATOM   5549  CD1 ILE D  30      83.843 105.889  66.920  1.00 59.04           C  
ATOM   5550  N   VAL D  31      80.775 107.296  70.413  1.00 59.95           N  
ATOM   5551  CA  VAL D  31      79.343 107.563  70.444  1.00 59.35           C  
ATOM   5552  C   VAL D  31      79.012 108.958  69.987  1.00 59.83           C  
ATOM   5553  O   VAL D  31      78.147 109.167  69.118  1.00 58.79           O  
ATOM   5554  CB  VAL D  31      78.790 107.260  71.859  1.00 58.93           C  
ATOM   5555  CG1 VAL D  31      77.340 107.659  71.979  1.00 54.24           C  
ATOM   5556  CG2 VAL D  31      78.997 105.771  72.142  1.00 53.41           C  
ATOM   5557  N   HIS D  32      79.749 109.973  70.461  1.00 60.34           N  
ATOM   5558  CA  HIS D  32      79.501 111.332  69.962  1.00 61.07           C  
ATOM   5559  C   HIS D  32      79.625 111.358  68.431  1.00 61.76           C  
ATOM   5560  O   HIS D  32      78.830 112.019  67.753  1.00 62.07           O  
ATOM   5561  CB  HIS D  32      80.439 112.348  70.560  1.00 61.76           C  
ATOM   5562  CG  HIS D  32      80.203 112.843  71.940  1.00 66.24           C  
ATOM   5563  ND1 HIS D  32      79.103 113.590  72.320  1.00 66.39           N  
ATOM   5564  CD2 HIS D  32      80.991 112.754  73.055  1.00 66.81           C  
ATOM   5565  CE1 HIS D  32      79.218 113.914  73.600  1.00 67.65           C  
ATOM   5566  NE2 HIS D  32      80.347 113.432  74.066  1.00 66.67           N  
ATOM   5567  N   VAL D  33      80.639 110.694  67.857  1.00 60.14           N  
ATOM   5568  CA  VAL D  33      80.791 110.711  66.408  1.00 58.63           C  
ATOM   5569  C   VAL D  33      79.594 110.038  65.743  1.00 58.42           C  
ATOM   5570  O   VAL D  33      79.085 110.516  64.722  1.00 57.36           O  
ATOM   5571  CB  VAL D  33      82.084 110.054  65.913  1.00 58.71           C  
ATOM   5572  CG1 VAL D  33      82.143 110.114  64.389  1.00 57.17           C  
ATOM   5573  CG2 VAL D  33      83.307 110.687  66.531  1.00 55.30           C  
ATOM   5574  N   LEU D  34      79.146 108.932  66.335  1.00 57.75           N  
ATOM   5575  CA  LEU D  34      77.948 108.249  65.849  1.00 56.19           C  
ATOM   5576  C   LEU D  34      76.771 109.213  65.867  1.00 56.00           C  
ATOM   5577  O   LEU D  34      76.057 109.301  64.863  1.00 56.80           O  
ATOM   5578  CB  LEU D  34      77.668 106.978  66.624  1.00 55.15           C  
ATOM   5579  CG  LEU D  34      76.288 106.328  66.466  1.00 55.99           C  
ATOM   5580  CD1 LEU D  34      76.086 105.742  65.076  1.00 49.27           C  
ATOM   5581  CD2 LEU D  34      76.091 105.261  67.538  1.00 55.45           C  
ATOM   5582  N   GLU D  35      76.603 110.040  66.890  1.00 56.09           N  
ATOM   5583  CA  GLU D  35      75.505 111.015  66.904  1.00 57.14           C  
ATOM   5584  C   GLU D  35      75.618 111.974  65.733  1.00 57.41           C  
ATOM   5585  O   GLU D  35      74.661 112.123  64.958  1.00 59.04           O  
ATOM   5586  CB  GLU D  35      75.404 111.760  68.231  1.00 59.17           C  
ATOM   5587  CG  GLU D  35      75.289 110.882  69.461  1.00 59.06           C  
ATOM   5588  CD  GLU D  35      74.749 111.538  70.691  1.00 64.42           C  
ATOM   5589  OE1 GLU D  35      74.769 112.768  70.891  1.00 64.05           O  
ATOM   5590  OE2 GLU D  35      74.249 110.808  71.605  1.00 70.53           O  
ATOM   5591  N   ARG D  36      76.751 112.639  65.558  1.00 56.88           N  
ATOM   5592  CA  ARG D  36      76.965 113.498  64.394  1.00 56.29           C  
ATOM   5593  C   ARG D  36      76.544 112.769  63.119  1.00 56.23           C  
ATOM   5594  O   ARG D  36      75.662 113.198  62.377  1.00 55.64           O  
ATOM   5595  CB  ARG D  36      78.450 113.871  64.286  1.00 55.12           C  
ATOM   5596  CG  ARG D  36      79.001 114.617  65.475  1.00 56.07           C  
ATOM   5597  CD  ARG D  36      78.394 115.994  65.649  1.00 58.81           C  
ATOM   5598  NE  ARG D  36      77.104 115.976  66.343  1.00 55.87           N  
ATOM   5599  CZ  ARG D  36      76.983 115.606  67.612  1.00 58.43           C  
ATOM   5600  NH1 ARG D  36      78.057 115.216  68.300  1.00 56.85           N  
ATOM   5601  NH2 ARG D  36      75.815 115.608  68.243  1.00 59.57           N  
ATOM   5602  N   ALA D  37      77.126 111.595  62.873  1.00 56.18           N  
ATOM   5603  CA  ALA D  37      76.746 110.816  61.692  1.00 56.89           C  
ATOM   5604  C   ALA D  37      75.256 110.564  61.627  1.00 57.77           C  
ATOM   5605  O   ALA D  37      74.661 110.640  60.525  1.00 56.70           O  
ATOM   5606  CB  ALA D  37      77.577 109.561  61.578  1.00 53.97           C  
ATOM   5607  N   ARG D  38      74.556 110.312  62.755  1.00 57.22           N  
ATOM   5608  CA  ARG D  38      73.100 110.149  62.628  1.00 57.43           C  
ATOM   5609  C   ARG D  38      72.444 111.449  62.177  1.00 57.39           C  
ATOM   5610  O   ARG D  38      71.489 111.429  61.400  1.00 57.20           O  
ATOM   5611  CB  ARG D  38      72.416 109.649  63.888  1.00 52.82           C  
ATOM   5612  CG  ARG D  38      73.149 108.564  64.593  1.00 56.18           C  
ATOM   5613  CD  ARG D  38      72.336 107.348  64.982  1.00 58.04           C  
ATOM   5614  NE  ARG D  38      72.222 107.198  66.372  1.00 57.38           N  
ATOM   5615  CZ  ARG D  38      72.265 106.288  67.287  1.00 56.75           C  
ATOM   5616  NH1 ARG D  38      72.463 105.002  67.077  1.00 52.27           N  
ATOM   5617  NH2 ARG D  38      72.115 106.731  68.565  1.00 55.52           N  
ATOM   5618  N   GLU D  39      72.978 112.578  62.645  1.00 58.81           N  
ATOM   5619  CA  GLU D  39      72.403 113.887  62.322  1.00 58.41           C  
ATOM   5620  C   GLU D  39      72.554 114.203  60.851  1.00 57.48           C  
ATOM   5621  O   GLU D  39      71.752 114.942  60.300  1.00 58.40           O  
ATOM   5622  CB  GLU D  39      72.968 114.981  63.193  1.00 59.37           C  
ATOM   5623  CG  GLU D  39      72.664 114.876  64.674  1.00 62.54           C  
ATOM   5624  CD  GLU D  39      73.621 115.715  65.515  1.00 65.28           C  
ATOM   5625  OE1 GLU D  39      73.416 115.770  66.749  1.00 65.38           O  
ATOM   5626  OE2 GLU D  39      74.566 116.308  64.938  1.00 63.88           O  
ATOM   5627  N   SER D  40      73.523 113.616  60.186  1.00 58.31           N  
ATOM   5628  CA  SER D  40      73.768 113.790  58.772  1.00 58.04           C  
ATOM   5629  C   SER D  40      72.659 113.221  57.911  1.00 57.39           C  
ATOM   5630  O   SER D  40      72.591 113.580  56.730  1.00 59.02           O  
ATOM   5631  CB  SER D  40      75.087 113.097  58.349  1.00 58.68           C  
ATOM   5632  OG  SER D  40      74.893 111.716  58.133  1.00 55.82           O  
ATOM   5633  N   GLY D  41      71.900 112.246  58.405  1.00 55.99           N  
ATOM   5634  CA  GLY D  41      70.834 111.663  57.602  1.00 54.30           C  
ATOM   5635  C   GLY D  41      71.296 110.354  56.971  1.00 56.00           C  
ATOM   5636  O   GLY D  41      70.599 109.758  56.136  1.00 56.81           O  
ATOM   5637  N   ALA D  42      72.502 109.915  57.326  1.00 54.03           N  
ATOM   5638  CA  ALA D  42      72.968 108.636  56.810  1.00 56.92           C  
ATOM   5639  C   ALA D  42      71.929 107.536  57.135  1.00 58.44           C  
ATOM   5640  O   ALA D  42      71.328 107.520  58.199  1.00 57.87           O  
ATOM   5641  CB  ALA D  42      74.327 108.302  57.388  1.00 52.10           C  
ATOM   5642  N   GLU D  43      71.725 106.604  56.214  1.00 58.95           N  
ATOM   5643  CA  GLU D  43      70.807 105.523  56.365  1.00 61.92           C  
ATOM   5644  C   GLU D  43      71.412 104.382  57.187  1.00 61.71           C  
ATOM   5645  O   GLU D  43      70.686 103.615  57.812  1.00 61.81           O  
ATOM   5646  CB  GLU D  43      70.392 104.926  55.004  1.00 70.08           C  
ATOM   5647  CG  GLU D  43      69.014 105.385  54.573  1.00 83.02           C  
ATOM   5648  CD  GLU D  43      68.462 104.677  53.362  1.00 90.36           C  
ATOM   5649  OE1 GLU D  43      68.694 105.116  52.212  1.00 93.36           O  
ATOM   5650  OE2 GLU D  43      67.744 103.661  53.536  1.00 94.65           O  
ATOM   5651  N   ARG D  44      72.718 104.271  57.102  1.00 59.94           N  
ATOM   5652  CA  ARG D  44      73.427 103.191  57.780  1.00 58.77           C  
ATOM   5653  C   ARG D  44      74.754 103.724  58.282  1.00 58.21           C  
ATOM   5654  O   ARG D  44      75.398 104.495  57.549  1.00 57.90           O  
ATOM   5655  CB  ARG D  44      73.619 102.027  56.814  1.00 58.24           C  
ATOM   5656  CG  ARG D  44      73.428 100.678  57.469  1.00 59.73           C  
ATOM   5657  CD  ARG D  44      73.666  99.541  56.518  1.00 59.52           C  
ATOM   5658  NE  ARG D  44      74.486  98.490  57.130  1.00 60.06           N  
ATOM   5659  CZ  ARG D  44      74.823  97.405  56.454  1.00 59.74           C  
ATOM   5660  NH1 ARG D  44      74.398  97.291  55.197  1.00 62.77           N  
ATOM   5661  NH2 ARG D  44      75.552  96.464  56.999  1.00 61.12           N  
ATOM   5662  N   ILE D  45      75.004 103.536  59.560  1.00 58.20           N  
ATOM   5663  CA  ILE D  45      76.242 104.020  60.174  1.00 59.05           C  
ATOM   5664  C   ILE D  45      76.950 102.795  60.718  1.00 60.22           C  
ATOM   5665  O   ILE D  45      76.288 101.906  61.246  1.00 62.54           O  
ATOM   5666  CB  ILE D  45      76.035 105.033  61.277  1.00 58.90           C  
ATOM   5667  CG1 ILE D  45      75.124 106.165  60.802  1.00 60.77           C  
ATOM   5668  CG2 ILE D  45      77.370 105.587  61.782  1.00 58.15           C  
ATOM   5669  CD1 ILE D  45      74.621 107.031  61.943  1.00 67.16           C  
ATOM   5670  N   ILE D  46      78.217 102.633  60.384  1.00 61.19           N  
ATOM   5671  CA  ILE D  46      78.923 101.432  60.831  1.00 59.64           C  
ATOM   5672  C   ILE D  46      80.206 101.852  61.509  1.00 59.58           C  
ATOM   5673  O   ILE D  46      80.997 102.564  60.872  1.00 60.96           O  
ATOM   5674  CB  ILE D  46      79.222 100.543  59.605  1.00 61.90           C  
ATOM   5675  CG1 ILE D  46      77.927 100.101  58.927  1.00 60.33           C  
ATOM   5676  CG2 ILE D  46      80.063  99.344  60.023  1.00 62.76           C  
ATOM   5677  CD1 ILE D  46      78.093  99.283  57.676  1.00 59.31           C  
ATOM   5678  N   VAL D  47      80.387 101.487  62.770  1.00 59.18           N  
ATOM   5679  CA  VAL D  47      81.638 101.782  63.462  1.00 58.48           C  
ATOM   5680  C   VAL D  47      82.585 100.588  63.264  1.00 60.29           C  
ATOM   5681  O   VAL D  47      82.265  99.492  63.737  1.00 60.20           O  
ATOM   5682  CB  VAL D  47      81.493 102.050  64.962  1.00 52.85           C  
ATOM   5683  CG1 VAL D  47      82.875 102.060  65.643  1.00 50.47           C  
ATOM   5684  CG2 VAL D  47      80.825 103.384  65.229  1.00 46.07           C  
ATOM   5685  N   ALA D  48      83.722 100.855  62.640  1.00 61.42           N  
ATOM   5686  CA  ALA D  48      84.714  99.800  62.381  1.00 62.52           C  
ATOM   5687  C   ALA D  48      85.733  99.787  63.510  1.00 63.25           C  
ATOM   5688  O   ALA D  48      86.428 100.757  63.738  1.00 62.42           O  
ATOM   5689  CB  ALA D  48      85.387 100.014  61.047  1.00 62.29           C  
ATOM   5690  N   THR D  49      85.781  98.680  64.227  1.00 66.03           N  
ATOM   5691  CA  THR D  49      86.634  98.539  65.398  1.00 67.66           C  
ATOM   5692  C   THR D  49      87.155  97.118  65.515  1.00 68.19           C  
ATOM   5693  O   THR D  49      86.521  96.182  65.035  1.00 68.79           O  
ATOM   5694  CB  THR D  49      85.823  98.887  66.674  1.00 68.24           C  
ATOM   5695  OG1 THR D  49      86.619  98.646  67.830  1.00 73.58           O  
ATOM   5696  CG2 THR D  49      84.573  98.029  66.760  1.00 66.27           C  
ATOM   5697  N   ASP D  50      88.265  96.952  66.203  1.00 69.83           N  
ATOM   5698  CA  ASP D  50      88.867  95.638  66.395  1.00 72.22           C  
ATOM   5699  C   ASP D  50      88.900  95.315  67.894  1.00 73.04           C  
ATOM   5700  O   ASP D  50      89.556  94.372  68.303  1.00 73.15           O  
ATOM   5701  CB  ASP D  50      90.266  95.571  65.811  1.00 72.06           C  
ATOM   5702  CG  ASP D  50      91.201  96.618  66.386  1.00 74.17           C  
ATOM   5703  OD1 ASP D  50      92.402  96.556  66.048  1.00 75.88           O  
ATOM   5704  OD2 ASP D  50      90.746  97.490  67.162  1.00 74.96           O  
ATOM   5705  N   HIS D  51      88.179  96.121  68.651  1.00 73.97           N  
ATOM   5706  CA  HIS D  51      88.072  95.954  70.089  1.00 76.62           C  
ATOM   5707  C   HIS D  51      86.651  95.610  70.492  1.00 77.85           C  
ATOM   5708  O   HIS D  51      85.710  96.305  70.087  1.00 78.93           O  
ATOM   5709  CB  HIS D  51      88.548  97.237  70.786  1.00 78.69           C  
ATOM   5710  CG  HIS D  51      90.048  97.301  70.858  1.00 83.59           C  
ATOM   5711  ND1 HIS D  51      90.834  97.306  69.723  1.00 84.11           N  
ATOM   5712  CD2 HIS D  51      90.898  97.343  71.911  1.00 84.97           C  
ATOM   5713  CE1 HIS D  51      92.101  97.373  70.067  1.00 84.51           C  
ATOM   5714  NE2 HIS D  51      92.168  97.402  71.388  1.00 85.06           N  
ATOM   5715  N   GLU D  52      86.474  94.589  71.336  1.00 78.39           N  
ATOM   5716  CA  GLU D  52      85.151  94.178  71.760  1.00 78.74           C  
ATOM   5717  C   GLU D  52      84.487  95.219  72.646  1.00 76.64           C  
ATOM   5718  O   GLU D  52      83.257  95.334  72.651  1.00 77.32           O  
ATOM   5719  CB  GLU D  52      85.124  92.810  72.471  1.00 84.19           C  
ATOM   5720  CG  GLU D  52      83.710  92.243  72.552  1.00 93.16           C  
ATOM   5721  CD  GLU D  52      83.522  91.005  73.379  1.00 97.96           C  
ATOM   5722  OE1 GLU D  52      84.161  89.955  73.126  1.00 99.75           O  
ATOM   5723  OE2 GLU D  52      82.673  91.024  74.318  1.00100.09           O  
ATOM   5724  N   ASP D  53      85.288  95.958  73.389  1.00 75.29           N  
ATOM   5725  CA  ASP D  53      84.758  96.956  74.312  1.00 74.98           C  
ATOM   5726  C   ASP D  53      84.205  98.145  73.544  1.00 73.37           C  
ATOM   5727  O   ASP D  53      83.144  98.670  73.895  1.00 73.17           O  
ATOM   5728  CB  ASP D  53      85.759  97.384  75.364  1.00 77.67           C  
ATOM   5729  CG  ASP D  53      87.011  98.021  74.823  1.00 82.54           C  
ATOM   5730  OD1 ASP D  53      87.463  97.640  73.716  1.00 84.93           O  
ATOM   5731  OD2 ASP D  53      87.608  98.904  75.486  1.00 84.14           O  
ATOM   5732  N   VAL D  54      84.910  98.522  72.471  1.00 71.10           N  
ATOM   5733  CA  VAL D  54      84.414  99.644  71.666  1.00 69.65           C  
ATOM   5734  C   VAL D  54      83.043  99.239  71.094  1.00 68.60           C  
ATOM   5735  O   VAL D  54      82.065  99.947  71.255  1.00 67.18           O  
ATOM   5736  CB  VAL D  54      85.338 100.045  70.520  1.00 66.94           C  
ATOM   5737  CG1 VAL D  54      84.619 101.014  69.591  1.00 61.04           C  
ATOM   5738  CG2 VAL D  54      86.622 100.680  71.041  1.00 67.90           C  
ATOM   5739  N   ALA D  55      83.024  98.035  70.538  1.00 67.51           N  
ATOM   5740  CA  ALA D  55      81.828  97.466  69.955  1.00 68.22           C  
ATOM   5741  C   ALA D  55      80.667  97.443  70.944  1.00 68.47           C  
ATOM   5742  O   ALA D  55      79.542  97.817  70.568  1.00 67.81           O  
ATOM   5743  CB  ALA D  55      82.115  96.090  69.385  1.00 66.34           C  
ATOM   5744  N   ARG D  56      80.932  97.091  72.201  1.00 67.95           N  
ATOM   5745  CA  ARG D  56      79.893  97.094  73.228  1.00 67.16           C  
ATOM   5746  C   ARG D  56      79.420  98.500  73.516  1.00 65.09           C  
ATOM   5747  O   ARG D  56      78.221  98.770  73.567  1.00 64.25           O  
ATOM   5748  CB  ARG D  56      80.329  96.365  74.505  1.00 71.70           C  
ATOM   5749  CG  ARG D  56      80.281  94.843  74.308  1.00 81.01           C  
ATOM   5750  CD  ARG D  56      80.291  94.101  75.632  1.00 88.19           C  
ATOM   5751  NE  ARG D  56      81.619  94.060  76.225  1.00 94.15           N  
ATOM   5752  CZ  ARG D  56      82.115  94.883  77.133  1.00 97.32           C  
ATOM   5753  NH1 ARG D  56      81.391  95.878  77.641  1.00 99.22           N  
ATOM   5754  NH2 ARG D  56      83.373  94.723  77.549  1.00 96.55           N  
ATOM   5755  N   ALA D  57      80.356  99.457  73.571  1.00 64.33           N  
ATOM   5756  CA  ALA D  57      79.951 100.844  73.787  1.00 62.60           C  
ATOM   5757  C   ALA D  57      78.984 101.286  72.689  1.00 62.53           C  
ATOM   5758  O   ALA D  57      77.915 101.816  72.994  1.00 61.48           O  
ATOM   5759  CB  ALA D  57      81.162 101.769  73.817  1.00 60.97           C  
ATOM   5760  N   VAL D  58      79.368 101.032  71.432  1.00 61.61           N  
ATOM   5761  CA  VAL D  58      78.578 101.439  70.286  1.00 61.66           C  
ATOM   5762  C   VAL D  58      77.241 100.736  70.177  1.00 63.11           C  
ATOM   5763  O   VAL D  58      76.222 101.412  69.928  1.00 63.21           O  
ATOM   5764  CB  VAL D  58      79.388 101.319  68.980  1.00 60.88           C  
ATOM   5765  CG1 VAL D  58      78.477 101.373  67.758  1.00 56.33           C  
ATOM   5766  CG2 VAL D  58      80.450 102.408  68.928  1.00 55.24           C  
ATOM   5767  N   GLU D  59      77.167  99.432  70.431  1.00 62.93           N  
ATOM   5768  CA  GLU D  59      75.912  98.695  70.421  1.00 63.59           C  
ATOM   5769  C   GLU D  59      74.977  99.120  71.543  1.00 63.25           C  
ATOM   5770  O   GLU D  59      73.749  99.030  71.443  1.00 63.11           O  
ATOM   5771  CB  GLU D  59      76.166  97.173  70.572  1.00 66.80           C  
ATOM   5772  CG  GLU D  59      76.988  96.611  69.443  1.00 74.36           C  
ATOM   5773  CD  GLU D  59      77.524  95.226  69.601  1.00 78.33           C  
ATOM   5774  OE1 GLU D  59      78.565  94.922  68.967  1.00 80.45           O  
ATOM   5775  OE2 GLU D  59      76.934  94.393  70.325  1.00 84.75           O  
ATOM   5776  N   ALA D  60      75.536  99.569  72.663  1.00 61.74           N  
ATOM   5777  CA  ALA D  60      74.730 100.015  73.791  1.00 60.82           C  
ATOM   5778  C   ALA D  60      73.930 101.258  73.413  1.00 60.14           C  
ATOM   5779  O   ALA D  60      72.919 101.579  74.028  1.00 60.15           O  
ATOM   5780  CB  ALA D  60      75.658 100.385  74.961  1.00 60.90           C  
ATOM   5781  N   ALA D  61      74.458 102.036  72.473  1.00 59.31           N  
ATOM   5782  CA  ALA D  61      73.823 103.261  72.032  1.00 57.35           C  
ATOM   5783  C   ALA D  61      73.138 103.084  70.679  1.00 57.87           C  
ATOM   5784  O   ALA D  61      72.873 104.072  69.978  1.00 57.19           O  
ATOM   5785  CB  ALA D  61      74.864 104.367  71.959  1.00 57.75           C  
ATOM   5786  N   GLY D  62      72.828 101.846  70.336  1.00 56.97           N  
ATOM   5787  CA  GLY D  62      72.173 101.438  69.144  1.00 58.40           C  
ATOM   5788  C   GLY D  62      72.971 101.554  67.851  1.00 59.74           C  
ATOM   5789  O   GLY D  62      72.360 101.656  66.773  1.00 59.57           O  
ATOM   5790  N   GLY D  63      74.298 101.495  67.882  1.00 58.16           N  
ATOM   5791  CA  GLY D  63      75.100 101.620  66.692  1.00 57.73           C  
ATOM   5792  C   GLY D  63      75.492 100.291  66.077  1.00 58.38           C  
ATOM   5793  O   GLY D  63      75.732  99.267  66.726  1.00 60.01           O  
ATOM   5794  N   GLU D  64      75.628 100.283  64.765  1.00 58.73           N  
ATOM   5795  CA  GLU D  64      76.056  99.085  64.032  1.00 57.96           C  
ATOM   5796  C   GLU D  64      77.581  99.061  64.046  1.00 57.32           C  
ATOM   5797  O   GLU D  64      78.226 100.095  64.196  1.00 56.18           O  
ATOM   5798  CB  GLU D  64      75.453  99.068  62.661  1.00 60.47           C  
ATOM   5799  CG  GLU D  64      76.009  98.143  61.630  1.00 66.15           C  
ATOM   5800  CD  GLU D  64      75.229  98.093  60.331  1.00 71.36           C  
ATOM   5801  OE1 GLU D  64      74.273  98.874  60.120  1.00 70.55           O  
ATOM   5802  OE2 GLU D  64      75.585  97.226  59.494  1.00 74.42           O  
ATOM   5803  N   VAL D  65      78.162  97.875  64.209  1.00 57.40           N  
ATOM   5804  CA  VAL D  65      79.585  97.703  64.282  1.00 57.82           C  
ATOM   5805  C   VAL D  65      80.086  96.654  63.287  1.00 58.41           C  
ATOM   5806  O   VAL D  65      79.423  95.638  63.082  1.00 57.11           O  
ATOM   5807  CB  VAL D  65      80.066  97.277  65.691  1.00 56.62           C  
ATOM   5808  CG1 VAL D  65      79.504  98.215  66.750  1.00 57.58           C  
ATOM   5809  CG2 VAL D  65      79.718  95.845  66.022  1.00 56.54           C  
ATOM   5810  N   CYS D  66      81.233  96.927  62.686  1.00 59.15           N  
ATOM   5811  CA  CYS D  66      81.884  95.969  61.803  1.00 61.83           C  
ATOM   5812  C   CYS D  66      83.181  95.497  62.483  1.00 63.95           C  
ATOM   5813  O   CYS D  66      84.101  96.320  62.555  1.00 66.09           O  
ATOM   5814  CB  CYS D  66      82.247  96.535  60.440  1.00 61.31           C  
ATOM   5815  SG  CYS D  66      83.024  95.326  59.321  1.00 61.56           S  
HETATM 5816  N   MSE D  67      83.204  94.289  62.996  1.00 64.74           N  
HETATM 5817  CA  MSE D  67      84.389  93.780  63.674  1.00 68.22           C  
HETATM 5818  C   MSE D  67      85.487  93.522  62.646  1.00 68.86           C  
HETATM 5819  O   MSE D  67      85.306  92.687  61.756  1.00 69.88           O  
HETATM 5820  CB  MSE D  67      84.088  92.482  64.424  1.00 75.54           C  
HETATM 5821  CG  MSE D  67      83.186  92.635  65.630  1.00 81.03           C  
HETATM 5822 SE   MSE D  67      83.735  94.059  66.770  1.00 91.32          SE  
HETATM 5823  CE  MSE D  67      85.328  93.381  67.529  1.00 86.98           C  
ATOM   5824  N   THR D  68      86.564  94.282  62.728  1.00 68.51           N  
ATOM   5825  CA  THR D  68      87.663  94.131  61.772  1.00 69.31           C  
ATOM   5826  C   THR D  68      88.819  93.355  62.351  1.00 69.71           C  
ATOM   5827  O   THR D  68      89.812  93.809  62.866  1.00 68.86           O  
ATOM   5828  CB  THR D  68      88.083  95.489  61.206  1.00 71.04           C  
ATOM   5829  OG1 THR D  68      88.558  96.368  62.236  1.00 71.42           O  
ATOM   5830  CG2 THR D  68      86.882  96.176  60.529  1.00 69.94           C  
ATOM   5831  N   SER D  74      95.642  99.831  56.715  1.00108.08           N  
ATOM   5832  CA  SER D  74      96.248 101.059  56.204  1.00107.13           C  
ATOM   5833  C   SER D  74      95.228 102.133  55.877  1.00105.94           C  
ATOM   5834  O   SER D  74      95.207 102.703  54.777  1.00106.01           O  
ATOM   5835  CB  SER D  74      97.100 100.752  54.971  1.00108.32           C  
ATOM   5836  OG  SER D  74      96.291 100.694  53.805  1.00110.30           O  
ATOM   5837  N   GLY D  75      94.351 102.462  56.822  1.00104.41           N  
ATOM   5838  CA  GLY D  75      93.372 103.521  56.641  1.00102.04           C  
ATOM   5839  C   GLY D  75      92.349 103.207  55.567  1.00100.51           C  
ATOM   5840  O   GLY D  75      91.202 102.864  55.867  1.00 99.77           O  
ATOM   5841  N   THR D  76      92.734 103.409  54.302  1.00 98.88           N  
ATOM   5842  CA  THR D  76      91.812 103.102  53.204  1.00 97.05           C  
ATOM   5843  C   THR D  76      91.603 101.592  53.163  1.00 94.74           C  
ATOM   5844  O   THR D  76      90.472 101.121  53.155  1.00 94.42           O  
ATOM   5845  CB  THR D  76      92.300 103.628  51.858  1.00 97.67           C  
ATOM   5846  OG1 THR D  76      93.734 103.630  51.833  1.00 99.75           O  
ATOM   5847  CG2 THR D  76      91.798 105.044  51.622  1.00 97.71           C  
ATOM   5848  N   GLU D  77      92.694 100.840  53.299  1.00 92.64           N  
ATOM   5849  CA  GLU D  77      92.594  99.388  53.339  1.00 90.64           C  
ATOM   5850  C   GLU D  77      91.610  98.926  54.398  1.00 88.58           C  
ATOM   5851  O   GLU D  77      90.752  98.086  54.117  1.00 89.36           O  
ATOM   5852  CB  GLU D  77      93.950  98.733  53.554  1.00 91.60           C  
ATOM   5853  CG  GLU D  77      94.708  98.495  52.248  1.00 93.32           C  
ATOM   5854  CD  GLU D  77      96.109  97.966  52.486  1.00 94.45           C  
ATOM   5855  OE1 GLU D  77      96.432  97.654  53.649  1.00 94.01           O  
ATOM   5856  OE2 GLU D  77      96.893  97.860  51.515  1.00 97.32           O  
ATOM   5857  N   ARG D  78      91.659  99.511  55.590  1.00 86.61           N  
ATOM   5858  CA  ARG D  78      90.728  99.152  56.656  1.00 83.41           C  
ATOM   5859  C   ARG D  78      89.294  99.358  56.206  1.00 82.01           C  
ATOM   5860  O   ARG D  78      88.420  98.505  56.434  1.00 83.08           O  
ATOM   5861  CB  ARG D  78      91.005  99.922  57.938  1.00 83.92           C  
ATOM   5862  N   LEU D  79      89.031 100.456  55.507  1.00 79.07           N  
ATOM   5863  CA  LEU D  79      87.699 100.727  54.982  1.00 76.48           C  
ATOM   5864  C   LEU D  79      87.251  99.635  54.012  1.00 75.27           C  
ATOM   5865  O   LEU D  79      86.071  99.253  53.967  1.00 74.93           O  
ATOM   5866  CB  LEU D  79      87.693 102.092  54.326  1.00 75.82           C  
ATOM   5867  CG  LEU D  79      86.384 102.696  53.841  1.00 73.65           C  
ATOM   5868  CD1 LEU D  79      85.489 103.109  54.997  1.00 72.70           C  
ATOM   5869  CD2 LEU D  79      86.685 103.919  52.969  1.00 74.32           C  
ATOM   5870  N   ALA D  80      88.174  99.104  53.234  1.00 73.20           N  
ATOM   5871  CA  ALA D  80      87.939  98.058  52.265  1.00 72.27           C  
ATOM   5872  C   ALA D  80      87.469  96.768  52.927  1.00 71.99           C  
ATOM   5873  O   ALA D  80      86.542  96.116  52.442  1.00 71.45           O  
ATOM   5874  CB  ALA D  80      89.226  97.789  51.482  1.00 71.98           C  
ATOM   5875  N   GLU D  81      88.109  96.416  54.052  1.00 71.18           N  
ATOM   5876  CA  GLU D  81      87.695  95.242  54.823  1.00 69.14           C  
ATOM   5877  C   GLU D  81      86.209  95.371  55.178  1.00 67.10           C  
ATOM   5878  O   GLU D  81      85.437  94.446  54.924  1.00 66.62           O  
ATOM   5879  CB  GLU D  81      88.507  95.062  56.097  1.00 68.85           C  
ATOM   5880  N   VAL D  82      85.837  96.559  55.647  1.00 65.02           N  
ATOM   5881  CA  VAL D  82      84.449  96.835  56.007  1.00 63.40           C  
ATOM   5882  C   VAL D  82      83.557  96.731  54.784  1.00 62.97           C  
ATOM   5883  O   VAL D  82      82.561  96.001  54.760  1.00 62.58           O  
ATOM   5884  CB  VAL D  82      84.284  98.198  56.686  1.00 62.69           C  
ATOM   5885  CG1 VAL D  82      82.868  98.413  57.195  1.00 59.01           C  
ATOM   5886  CG2 VAL D  82      85.303  98.423  57.793  1.00 58.96           C  
ATOM   5887  N   VAL D  83      83.977  97.351  53.685  1.00 63.88           N  
ATOM   5888  CA  VAL D  83      83.192  97.280  52.436  1.00 63.19           C  
ATOM   5889  C   VAL D  83      83.008  95.828  52.018  1.00 64.33           C  
ATOM   5890  O   VAL D  83      81.929  95.461  51.530  1.00 64.72           O  
ATOM   5891  CB  VAL D  83      83.813  98.117  51.320  1.00 57.05           C  
ATOM   5892  CG1 VAL D  83      83.038  97.991  50.017  1.00 56.47           C  
ATOM   5893  CG2 VAL D  83      83.886  99.584  51.738  1.00 54.59           C  
ATOM   5894  N   GLU D  84      84.020  95.007  52.187  1.00 65.17           N  
ATOM   5895  CA  GLU D  84      84.004  93.580  51.939  1.00 67.54           C  
ATOM   5896  C   GLU D  84      82.997  92.829  52.807  1.00 67.40           C  
ATOM   5897  O   GLU D  84      81.963  92.342  52.326  1.00 65.89           O  
ATOM   5898  CB  GLU D  84      85.424  93.055  52.264  1.00 76.64           C  
ATOM   5899  CG  GLU D  84      86.206  92.704  50.992  1.00 84.42           C  
ATOM   5900  CD  GLU D  84      86.148  91.182  50.810  1.00 87.69           C  
ATOM   5901  OE1 GLU D  84      86.755  90.529  51.686  1.00 89.54           O  
ATOM   5902  OE2 GLU D  84      85.485  90.723  49.868  1.00 89.86           O  
ATOM   5903  N   LYS D  85      83.204  92.843  54.125  1.00 66.62           N  
ATOM   5904  CA  LYS D  85      82.326  92.184  55.067  1.00 67.39           C  
ATOM   5905  C   LYS D  85      80.885  92.635  55.043  1.00 68.38           C  
ATOM   5906  O   LYS D  85      79.969  91.850  55.347  1.00 68.13           O  
ATOM   5907  CB  LYS D  85      82.887  92.303  56.494  1.00 66.05           C  
ATOM   5908  CG  LYS D  85      84.270  91.706  56.630  1.00 64.20           C  
ATOM   5909  CD  LYS D  85      84.997  92.237  57.855  1.00 65.67           C  
ATOM   5910  CE  LYS D  85      86.046  91.222  58.307  1.00 68.00           C  
ATOM   5911  NZ  LYS D  85      86.235  91.247  59.782  1.00 69.93           N  
ATOM   5912  N   CYS D  86      80.610  93.889  54.685  1.00 69.63           N  
ATOM   5913  CA  CYS D  86      79.215  94.343  54.594  1.00 69.26           C  
ATOM   5914  C   CYS D  86      78.683  94.118  53.192  1.00 70.07           C  
ATOM   5915  O   CYS D  86      77.516  94.317  52.890  1.00 68.96           O  
ATOM   5916  CB  CYS D  86      79.117  95.793  55.018  1.00 68.11           C  
ATOM   5917  SG  CYS D  86      79.462  96.041  56.794  1.00 69.67           S  
ATOM   5918  N   ALA D  87      79.575  93.691  52.291  1.00 71.20           N  
ATOM   5919  CA  ALA D  87      79.191  93.446  50.905  1.00 72.47           C  
ATOM   5920  C   ALA D  87      78.305  94.581  50.399  1.00 72.12           C  
ATOM   5921  O   ALA D  87      77.182  94.389  49.939  1.00 72.60           O  
ATOM   5922  CB  ALA D  87      78.501  92.103  50.756  1.00 72.56           C  
ATOM   5923  N   PHE D  88      78.827  95.814  50.507  1.00 71.23           N  
ATOM   5924  CA  PHE D  88      78.011  96.943  50.022  1.00 68.64           C  
ATOM   5925  C   PHE D  88      77.924  96.822  48.496  1.00 66.93           C  
ATOM   5926  O   PHE D  88      78.800  96.292  47.837  1.00 65.20           O  
ATOM   5927  CB  PHE D  88      78.594  98.258  50.425  1.00 67.45           C  
ATOM   5928  CG  PHE D  88      78.501  98.695  51.841  1.00 68.85           C  
ATOM   5929  CD1 PHE D  88      79.642  99.063  52.556  1.00 69.72           C  
ATOM   5930  CD2 PHE D  88      77.271  98.804  52.462  1.00 68.09           C  
ATOM   5931  CE1 PHE D  88      79.548  99.499  53.865  1.00 67.47           C  
ATOM   5932  CE2 PHE D  88      77.175  99.254  53.764  1.00 69.02           C  
ATOM   5933  CZ  PHE D  88      78.311  99.575  54.461  1.00 68.41           C  
ATOM   5934  N   SER D  89      76.814  97.287  47.941  1.00 67.62           N  
ATOM   5935  CA  SER D  89      76.666  97.262  46.478  1.00 65.38           C  
ATOM   5936  C   SER D  89      77.594  98.343  45.905  1.00 64.44           C  
ATOM   5937  O   SER D  89      77.879  99.339  46.578  1.00 61.86           O  
ATOM   5938  CB  SER D  89      75.217  97.574  46.122  1.00 67.42           C  
ATOM   5939  OG  SER D  89      75.022  98.995  46.066  1.00 73.48           O  
ATOM   5940  N   ASP D  90      77.986  98.228  44.660  1.00 63.61           N  
ATOM   5941  CA  ASP D  90      78.871  99.157  44.000  1.00 63.74           C  
ATOM   5942  C   ASP D  90      78.502 100.617  44.019  1.00 61.48           C  
ATOM   5943  O   ASP D  90      79.333 101.476  44.340  1.00 60.22           O  
ATOM   5944  CB  ASP D  90      79.086  98.741  42.523  1.00 65.55           C  
ATOM   5945  CG  ASP D  90      80.022  97.534  42.498  1.00 68.44           C  
ATOM   5946  OD1 ASP D  90      80.642  97.266  43.551  1.00 69.43           O  
ATOM   5947  OD2 ASP D  90      80.097  96.890  41.440  1.00 71.14           O  
ATOM   5948  N   ASP D  91      77.278 100.945  43.708  1.00 60.41           N  
ATOM   5949  CA  ASP D  91      76.777 102.291  43.666  1.00 60.43           C  
ATOM   5950  C   ASP D  91      76.494 102.850  45.047  1.00 59.33           C  
ATOM   5951  O   ASP D  91      75.964 103.954  45.158  1.00 58.97           O  
ATOM   5952  CB  ASP D  91      75.474 102.252  42.818  1.00 66.83           C  
ATOM   5953  CG  ASP D  91      74.615 101.138  43.446  1.00 73.16           C  
ATOM   5954  OD1 ASP D  91      74.889  99.964  43.107  1.00 80.34           O  
ATOM   5955  OD2 ASP D  91      73.806 101.470  44.312  1.00 73.56           O  
ATOM   5956  N   THR D  92      76.845 102.162  46.113  1.00 58.75           N  
ATOM   5957  CA  THR D  92      76.650 102.607  47.465  1.00 58.77           C  
ATOM   5958  C   THR D  92      77.625 103.763  47.783  1.00 59.75           C  
ATOM   5959  O   THR D  92      78.821 103.569  47.622  1.00 59.33           O  
ATOM   5960  CB  THR D  92      76.926 101.511  48.510  1.00 58.30           C  
ATOM   5961  OG1 THR D  92      76.248 100.295  48.163  1.00 61.91           O  
ATOM   5962  CG2 THR D  92      76.509 101.968  49.890  1.00 53.74           C  
ATOM   5963  N   VAL D  93      77.072 104.874  48.212  1.00 59.26           N  
ATOM   5964  CA  VAL D  93      77.800 106.050  48.609  1.00 59.97           C  
ATOM   5965  C   VAL D  93      78.205 105.924  50.077  1.00 61.17           C  
ATOM   5966  O   VAL D  93      77.397 105.699  50.968  1.00 62.34           O  
ATOM   5967  CB  VAL D  93      76.973 107.322  48.378  1.00 60.51           C  
ATOM   5968  CG1 VAL D  93      77.602 108.560  48.968  1.00 59.33           C  
ATOM   5969  CG2 VAL D  93      76.743 107.502  46.872  1.00 58.73           C  
ATOM   5970  N   ILE D  94      79.500 105.970  50.298  1.00 60.92           N  
ATOM   5971  CA  ILE D  94      80.126 105.859  51.588  1.00 59.76           C  
ATOM   5972  C   ILE D  94      80.784 107.188  51.952  1.00 60.77           C  
ATOM   5973  O   ILE D  94      81.309 107.884  51.068  1.00 61.58           O  
ATOM   5974  CB  ILE D  94      81.282 104.804  51.526  1.00 59.36           C  
ATOM   5975  CG1 ILE D  94      80.762 103.536  50.902  1.00 58.26           C  
ATOM   5976  CG2 ILE D  94      81.938 104.658  52.873  1.00 59.18           C  
ATOM   5977  CD1 ILE D  94      81.055 102.214  51.507  1.00 60.58           C  
ATOM   5978  N   VAL D  95      80.677 107.590  53.214  1.00 59.25           N  
ATOM   5979  CA  VAL D  95      81.378 108.773  53.672  1.00 57.39           C  
ATOM   5980  C   VAL D  95      82.242 108.334  54.875  1.00 59.67           C  
ATOM   5981  O   VAL D  95      81.711 107.751  55.814  1.00 58.64           O  
ATOM   5982  CB  VAL D  95      80.516 109.930  54.083  1.00 54.15           C  
ATOM   5983  CG1 VAL D  95      81.377 111.138  54.455  1.00 49.59           C  
ATOM   5984  CG2 VAL D  95      79.464 110.306  53.064  1.00 54.60           C  
ATOM   5985  N   ASN D  96      83.539 108.509  54.729  1.00 61.23           N  
ATOM   5986  CA  ASN D  96      84.478 108.101  55.781  1.00 63.51           C  
ATOM   5987  C   ASN D  96      84.645 109.252  56.776  1.00 64.46           C  
ATOM   5988  O   ASN D  96      85.097 110.326  56.378  1.00 65.74           O  
ATOM   5989  CB  ASN D  96      85.783 107.734  55.124  1.00 68.74           C  
ATOM   5990  CG  ASN D  96      86.659 106.778  55.863  1.00 73.91           C  
ATOM   5991  OD1 ASN D  96      86.758 106.796  57.087  1.00 78.15           O  
ATOM   5992  ND2 ASN D  96      87.336 105.913  55.106  1.00 77.87           N  
ATOM   5993  N   VAL D  97      84.168 109.068  57.991  1.00 63.24           N  
ATOM   5994  CA  VAL D  97      84.247 110.018  59.068  1.00 63.05           C  
ATOM   5995  C   VAL D  97      85.115 109.497  60.219  1.00 64.80           C  
ATOM   5996  O   VAL D  97      84.768 108.491  60.848  1.00 65.08           O  
ATOM   5997  CB  VAL D  97      82.843 110.280  59.659  1.00 60.67           C  
ATOM   5998  CG1 VAL D  97      82.947 111.280  60.795  1.00 59.55           C  
ATOM   5999  CG2 VAL D  97      81.913 110.743  58.554  1.00 60.85           C  
ATOM   6000  N   GLN D  98      86.158 110.216  60.565  1.00 65.47           N  
ATOM   6001  CA  GLN D  98      87.075 109.851  61.618  1.00 67.19           C  
ATOM   6002  C   GLN D  98      86.427 109.771  62.995  1.00 69.54           C  
ATOM   6003  O   GLN D  98      85.604 110.579  63.410  1.00 67.82           O  
ATOM   6004  CB  GLN D  98      88.276 110.785  61.638  1.00 66.16           C  
ATOM   6005  CG  GLN D  98      89.272 110.647  60.522  1.00 68.02           C  
ATOM   6006  CD  GLN D  98      89.457 109.250  59.977  1.00 69.64           C  
ATOM   6007  OE1 GLN D  98      90.114 108.396  60.582  1.00 69.97           O  
ATOM   6008  NE2 GLN D  98      88.869 108.987  58.813  1.00 69.09           N  
ATOM   6009  N   GLY D  99      86.899 108.799  63.791  1.00 71.31           N  
ATOM   6010  CA  GLY D  99      86.402 108.540  65.115  1.00 72.95           C  
ATOM   6011  C   GLY D  99      86.995 109.454  66.180  1.00 73.48           C  
ATOM   6012  O   GLY D  99      86.679 109.272  67.358  1.00 73.39           O  
ATOM   6013  N   ASP D 100      87.806 110.384  65.763  1.00 74.85           N  
ATOM   6014  CA  ASP D 100      88.490 111.391  66.532  1.00 75.50           C  
ATOM   6015  C   ASP D 100      87.768 112.731  66.402  1.00 75.50           C  
ATOM   6016  O   ASP D 100      88.253 113.754  66.878  1.00 74.70           O  
ATOM   6017  CB  ASP D 100      89.937 111.557  65.975  1.00 75.40           C  
ATOM   6018  N   GLU D 101      86.567 112.715  65.792  1.00 75.17           N  
ATOM   6019  CA  GLU D 101      85.821 113.937  65.526  1.00 74.71           C  
ATOM   6020  C   GLU D 101      84.418 114.003  66.063  1.00 74.58           C  
ATOM   6021  O   GLU D 101      83.413 114.050  65.341  1.00 72.76           O  
ATOM   6022  CB  GLU D 101      85.825 114.176  63.990  1.00 71.46           C  
ATOM   6023  CG  GLU D 101      87.213 114.581  63.522  1.00 71.92           C  
ATOM   6024  CD  GLU D 101      87.267 114.994  62.077  1.00 72.81           C  
ATOM   6025  OE1 GLU D 101      86.288 115.612  61.608  1.00 73.11           O  
ATOM   6026  OE2 GLU D 101      88.303 114.716  61.431  1.00 74.28           O  
ATOM   6027  N   PRO D 102      84.295 114.204  67.378  1.00 74.99           N  
ATOM   6028  CA  PRO D 102      83.020 114.265  68.056  1.00 75.48           C  
ATOM   6029  C   PRO D 102      82.213 115.512  67.834  1.00 75.27           C  
ATOM   6030  O   PRO D 102      81.053 115.588  68.268  1.00 74.71           O  
ATOM   6031  CB  PRO D 102      83.368 114.057  69.523  1.00 75.51           C  
ATOM   6032  CG  PRO D 102      84.770 114.525  69.648  1.00 75.42           C  
ATOM   6033  CD  PRO D 102      85.421 114.255  68.332  1.00 74.84           C  
HETATM 6034  N   MSE D 103      82.744 116.522  67.162  1.00 76.21           N  
HETATM 6035  CA  MSE D 103      81.991 117.734  66.873  1.00 76.38           C  
HETATM 6036  C   MSE D 103      81.951 118.026  65.376  1.00 74.22           C  
HETATM 6037  O   MSE D 103      81.519 119.104  64.980  1.00 74.18           O  
HETATM 6038  CB  MSE D 103      82.530 118.916  67.645  1.00 86.52           C  
HETATM 6039  CG  MSE D 103      82.275 118.863  69.146  1.00 98.86           C  
HETATM 6040 SE   MSE D 103      83.175 120.263  70.094  1.00113.90          SE  
HETATM 6041  CE  MSE D 103      84.868 120.277  69.237  1.00110.48           C  
ATOM   6042  N   ILE D 104      82.439 117.084  64.564  1.00 70.95           N  
ATOM   6043  CA  ILE D 104      82.382 117.300  63.107  1.00 67.75           C  
ATOM   6044  C   ILE D 104      80.957 117.700  62.755  1.00 66.83           C  
ATOM   6045  O   ILE D 104      80.012 117.028  63.182  1.00 67.96           O  
ATOM   6046  CB  ILE D 104      82.805 116.017  62.366  1.00 64.35           C  
ATOM   6047  CG1 ILE D 104      82.949 116.266  60.868  1.00 62.31           C  
ATOM   6048  CG2 ILE D 104      81.865 114.863  62.651  1.00 59.86           C  
ATOM   6049  CD1 ILE D 104      83.574 115.135  60.094  1.00 61.35           C  
ATOM   6050  N   PRO D 105      80.763 118.834  62.120  1.00 64.88           N  
ATOM   6051  CA  PRO D 105      79.443 119.313  61.750  1.00 63.69           C  
ATOM   6052  C   PRO D 105      78.712 118.324  60.866  1.00 62.95           C  
ATOM   6053  O   PRO D 105      79.159 118.048  59.734  1.00 63.93           O  
ATOM   6054  CB  PRO D 105      79.730 120.611  60.998  1.00 64.50           C  
ATOM   6055  CG  PRO D 105      81.100 121.038  61.405  1.00 64.05           C  
ATOM   6056  CD  PRO D 105      81.842 119.753  61.685  1.00 65.29           C  
ATOM   6057  N   ALA D 106      77.520 117.879  61.242  1.00 60.86           N  
ATOM   6058  CA  ALA D 106      76.743 116.918  60.493  1.00 59.17           C  
ATOM   6059  C   ALA D 106      76.584 117.331  59.026  1.00 60.12           C  
ATOM   6060  O   ALA D 106      76.634 116.491  58.131  1.00 59.71           O  
ATOM   6061  CB  ALA D 106      75.367 116.686  61.085  1.00 52.65           C  
ATOM   6062  N   THR D 107      76.366 118.616  58.813  1.00 59.81           N  
ATOM   6063  CA  THR D 107      76.190 119.199  57.515  1.00 60.14           C  
ATOM   6064  C   THR D 107      77.338 118.934  56.557  1.00 59.50           C  
ATOM   6065  O   THR D 107      77.052 118.682  55.372  1.00 58.18           O  
ATOM   6066  CB  THR D 107      75.952 120.728  57.595  1.00 59.32           C  
ATOM   6067  OG1 THR D 107      77.018 121.282  58.382  1.00 66.10           O  
ATOM   6068  CG2 THR D 107      74.611 121.050  58.195  1.00 51.38           C  
ATOM   6069  N   ILE D 108      78.602 118.884  57.003  1.00 58.75           N  
ATOM   6070  CA  ILE D 108      79.646 118.594  56.017  1.00 59.10           C  
ATOM   6071  C   ILE D 108      79.667 117.114  55.658  1.00 59.16           C  
ATOM   6072  O   ILE D 108      80.222 116.751  54.635  1.00 58.13           O  
ATOM   6073  CB  ILE D 108      81.033 119.132  56.268  1.00 56.93           C  
ATOM   6074  CG1 ILE D 108      81.816 118.362  57.318  1.00 60.44           C  
ATOM   6075  CG2 ILE D 108      80.979 120.623  56.548  1.00 55.40           C  
ATOM   6076  CD1 ILE D 108      83.136 119.026  57.736  1.00 60.29           C  
ATOM   6077  N   ILE D 109      79.055 116.285  56.515  1.00 59.27           N  
ATOM   6078  CA  ILE D 109      78.949 114.870  56.186  1.00 59.07           C  
ATOM   6079  C   ILE D 109      77.923 114.709  55.046  1.00 58.36           C  
ATOM   6080  O   ILE D 109      78.198 114.053  54.058  1.00 57.42           O  
ATOM   6081  CB  ILE D 109      78.545 114.005  57.375  1.00 58.77           C  
ATOM   6082  CG1 ILE D 109      79.542 114.121  58.512  1.00 58.55           C  
ATOM   6083  CG2 ILE D 109      78.375 112.543  56.916  1.00 57.54           C  
ATOM   6084  CD1 ILE D 109      79.203 113.322  59.772  1.00 57.64           C  
ATOM   6085  N   ARG D 110      76.829 115.437  55.146  1.00 58.43           N  
ATOM   6086  CA  ARG D 110      75.762 115.418  54.143  1.00 59.06           C  
ATOM   6087  C   ARG D 110      76.290 115.930  52.800  1.00 58.05           C  
ATOM   6088  O   ARG D 110      76.091 115.312  51.771  1.00 59.05           O  
ATOM   6089  CB  ARG D 110      74.602 116.242  54.619  1.00 57.21           C  
ATOM   6090  CG  ARG D 110      73.214 115.943  54.413  1.00 65.25           C  
ATOM   6091  CD  ARG D 110      72.717 115.129  53.250  1.00 73.29           C  
ATOM   6092  NE  ARG D 110      71.428 114.501  53.611  1.00 80.70           N  
ATOM   6093  CZ  ARG D 110      70.365 114.370  52.852  1.00 85.07           C  
ATOM   6094  NH1 ARG D 110      70.301 114.817  51.602  1.00 88.87           N  
ATOM   6095  NH2 ARG D 110      69.275 113.771  53.334  1.00 88.80           N  
ATOM   6096  N   GLN D 111      76.960 117.053  52.807  1.00 58.39           N  
ATOM   6097  CA  GLN D 111      77.545 117.720  51.666  1.00 58.40           C  
ATOM   6098  C   GLN D 111      78.412 116.804  50.809  1.00 58.99           C  
ATOM   6099  O   GLN D 111      78.178 116.619  49.607  1.00 58.53           O  
ATOM   6100  CB  GLN D 111      78.377 118.895  52.194  1.00 57.01           C  
ATOM   6101  CG  GLN D 111      78.570 120.026  51.183  1.00 58.29           C  
ATOM   6102  CD  GLN D 111      79.537 121.042  51.812  1.00 57.98           C  
ATOM   6103  OE1 GLN D 111      79.902 120.817  52.969  1.00 55.74           O  
ATOM   6104  NE2 GLN D 111      79.926 122.056  51.070  1.00 54.60           N  
ATOM   6105  N   VAL D 112      79.422 116.176  51.425  1.00 58.20           N  
ATOM   6106  CA  VAL D 112      80.265 115.250  50.703  1.00 59.24           C  
ATOM   6107  C   VAL D 112      79.390 114.197  50.025  1.00 60.40           C  
ATOM   6108  O   VAL D 112      79.573 113.932  48.826  1.00 61.63           O  
ATOM   6109  CB  VAL D 112      81.319 114.610  51.601  1.00 60.94           C  
ATOM   6110  CG1 VAL D 112      82.074 113.503  50.873  1.00 61.75           C  
ATOM   6111  CG2 VAL D 112      82.301 115.672  52.086  1.00 60.24           C  
ATOM   6112  N   ALA D 113      78.435 113.623  50.742  1.00 58.38           N  
ATOM   6113  CA  ALA D 113      77.516 112.666  50.153  1.00 57.11           C  
ATOM   6114  C   ALA D 113      76.686 113.276  49.030  1.00 55.60           C  
ATOM   6115  O   ALA D 113      76.542 112.656  47.972  1.00 53.56           O  
ATOM   6116  CB  ALA D 113      76.587 112.103  51.241  1.00 58.21           C  
ATOM   6117  N   ASP D 114      76.101 114.453  49.234  1.00 55.40           N  
ATOM   6118  CA  ASP D 114      75.297 115.099  48.208  1.00 56.44           C  
ATOM   6119  C   ASP D 114      76.131 115.378  46.949  1.00 56.36           C  
ATOM   6120  O   ASP D 114      75.696 115.183  45.820  1.00 53.70           O  
ATOM   6121  CB  ASP D 114      74.662 116.378  48.686  1.00 61.98           C  
ATOM   6122  CG  ASP D 114      73.601 116.314  49.727  1.00 69.70           C  
ATOM   6123  OD1 ASP D 114      72.855 115.320  49.847  1.00 69.50           O  
ATOM   6124  OD2 ASP D 114      73.467 117.328  50.500  1.00 75.22           O  
ATOM   6125  N   ASN D 115      77.352 115.891  47.168  1.00 56.82           N  
ATOM   6126  CA  ASN D 115      78.240 116.191  46.061  1.00 57.73           C  
ATOM   6127  C   ASN D 115      78.605 114.961  45.254  1.00 59.69           C  
ATOM   6128  O   ASN D 115      78.674 115.017  44.017  1.00 60.68           O  
ATOM   6129  CB  ASN D 115      79.500 116.890  46.571  1.00 53.94           C  
ATOM   6130  CG  ASN D 115      79.162 118.272  47.093  1.00 50.39           C  
ATOM   6131  OD1 ASN D 115      78.161 118.854  46.686  1.00 55.75           O  
ATOM   6132  ND2 ASN D 115      79.951 118.794  47.985  1.00 53.73           N  
ATOM   6133  N   LEU D 116      78.840 113.854  45.934  1.00 61.26           N  
ATOM   6134  CA  LEU D 116      79.232 112.601  45.250  1.00 63.26           C  
ATOM   6135  C   LEU D 116      78.023 112.051  44.525  1.00 65.21           C  
ATOM   6136  O   LEU D 116      78.052 111.887  43.301  1.00 65.87           O  
ATOM   6137  CB  LEU D 116      79.845 111.668  46.241  1.00 64.58           C  
ATOM   6138  CG  LEU D 116      80.482 110.349  45.915  1.00 64.64           C  
ATOM   6139  CD1 LEU D 116      79.424 109.317  45.511  1.00 67.57           C  
ATOM   6140  CD2 LEU D 116      81.576 110.444  44.873  1.00 61.00           C  
ATOM   6141  N   ALA D 117      76.871 112.019  45.175  1.00 66.62           N  
ATOM   6142  CA  ALA D 117      75.650 111.517  44.592  1.00 68.47           C  
ATOM   6143  C   ALA D 117      75.379 111.969  43.184  1.00 70.40           C  
ATOM   6144  O   ALA D 117      74.853 111.147  42.406  1.00 72.16           O  
ATOM   6145  CB  ALA D 117      74.439 111.828  45.480  1.00 64.43           C  
ATOM   6146  N   GLN D 118      75.613 113.213  42.789  1.00 72.44           N  
ATOM   6147  CA  GLN D 118      75.262 113.609  41.413  1.00 74.07           C  
ATOM   6148  C   GLN D 118      76.435 113.734  40.471  1.00 74.03           C  
ATOM   6149  O   GLN D 118      76.340 114.336  39.379  1.00 74.18           O  
ATOM   6150  CB  GLN D 118      74.490 114.928  41.466  1.00 79.02           C  
ATOM   6151  CG  GLN D 118      75.117 115.924  42.439  1.00 84.72           C  
ATOM   6152  CD  GLN D 118      74.117 117.028  42.767  1.00 90.91           C  
ATOM   6153  OE1 GLN D 118      73.159 117.251  42.010  1.00 94.57           O  
ATOM   6154  NE2 GLN D 118      74.334 117.706  43.885  1.00 92.06           N  
ATOM   6155  N   ARG D 119      77.606 113.250  40.879  1.00 72.11           N  
ATOM   6156  CA  ARG D 119      78.769 113.311  40.001  1.00 70.59           C  
ATOM   6157  C   ARG D 119      79.368 111.926  39.854  1.00 71.74           C  
ATOM   6158  O   ARG D 119      79.705 111.267  40.850  1.00 72.27           O  
ATOM   6159  CB  ARG D 119      79.748 114.335  40.529  1.00 66.31           C  
ATOM   6160  CG  ARG D 119      79.316 115.786  40.454  1.00 63.08           C  
ATOM   6161  CD  ARG D 119      80.265 116.687  41.249  1.00 64.41           C  
ATOM   6162  NE  ARG D 119      79.471 117.627  42.067  1.00 68.53           N  
ATOM   6163  CZ  ARG D 119      79.456 118.927  41.872  1.00 68.76           C  
ATOM   6164  NH1 ARG D 119      80.228 119.431  40.891  1.00 74.90           N  
ATOM   6165  NH2 ARG D 119      78.717 119.732  42.592  1.00 68.76           N  
ATOM   6166  N   GLN D 120      79.585 111.445  38.632  1.00 71.88           N  
ATOM   6167  CA  GLN D 120      80.198 110.122  38.446  1.00 72.19           C  
ATOM   6168  C   GLN D 120      81.715 110.219  38.601  1.00 70.77           C  
ATOM   6169  O   GLN D 120      82.481 109.859  37.716  1.00 70.30           O  
ATOM   6170  CB  GLN D 120      79.832 109.527  37.093  1.00 76.78           C  
ATOM   6171  CG  GLN D 120      78.383 109.140  36.892  1.00 79.89           C  
ATOM   6172  CD  GLN D 120      77.729 108.749  38.211  1.00 85.31           C  
ATOM   6173  OE1 GLN D 120      78.169 107.818  38.889  1.00 83.42           O  
ATOM   6174  NE2 GLN D 120      76.721 109.536  38.604  1.00 89.11           N  
ATOM   6175  N   VAL D 121      82.141 110.651  39.761  1.00 71.15           N  
ATOM   6176  CA  VAL D 121      83.519 110.904  40.128  1.00 71.12           C  
ATOM   6177  C   VAL D 121      84.033 109.835  41.061  1.00 69.73           C  
ATOM   6178  O   VAL D 121      83.261 109.193  41.777  1.00 69.89           O  
ATOM   6179  CB  VAL D 121      83.596 112.294  40.818  1.00 73.63           C  
ATOM   6180  CG1 VAL D 121      84.951 112.580  41.392  1.00 75.01           C  
ATOM   6181  CG2 VAL D 121      83.272 113.366  39.764  1.00 78.20           C  
ATOM   6182  N   GLY D 122      85.337 109.618  41.070  1.00 69.76           N  
ATOM   6183  CA  GLY D 122      85.871 108.612  42.003  1.00 70.55           C  
ATOM   6184  C   GLY D 122      85.617 109.046  43.441  1.00 70.69           C  
ATOM   6185  O   GLY D 122      85.097 108.279  44.255  1.00 71.62           O  
HETATM 6186  N   MSE D 123      86.007 110.279  43.789  1.00 69.40           N  
HETATM 6187  CA  MSE D 123      85.849 110.730  45.154  1.00 68.95           C  
HETATM 6188  C   MSE D 123      85.285 112.153  45.232  1.00 64.95           C  
HETATM 6189  O   MSE D 123      85.502 112.967  44.355  1.00 63.01           O  
HETATM 6190  CB  MSE D 123      87.198 110.751  45.900  1.00 76.69           C  
HETATM 6191  CG  MSE D 123      87.895 109.475  46.217  1.00 82.97           C  
HETATM 6192 SE   MSE D 123      89.391 109.710  47.434  1.00 94.41          SE  
HETATM 6193  CE  MSE D 123      89.937 107.887  47.592  1.00 92.61           C  
ATOM   6194  N   ALA D 124      84.726 112.451  46.407  1.00 62.14           N  
ATOM   6195  CA  ALA D 124      84.265 113.814  46.692  1.00 58.91           C  
ATOM   6196  C   ALA D 124      84.876 114.192  48.054  1.00 58.37           C  
ATOM   6197  O   ALA D 124      84.989 113.285  48.882  1.00 55.71           O  
ATOM   6198  CB  ALA D 124      82.772 113.915  46.697  1.00 55.10           C  
ATOM   6199  N   THR D 125      85.420 115.408  48.162  1.00 56.54           N  
ATOM   6200  CA  THR D 125      85.979 115.918  49.378  1.00 53.72           C  
ATOM   6201  C   THR D 125      85.581 117.413  49.538  1.00 54.06           C  
ATOM   6202  O   THR D 125      84.898 117.976  48.726  1.00 52.35           O  
ATOM   6203  CB  THR D 125      87.485 115.947  49.558  1.00 53.06           C  
ATOM   6204  OG1 THR D 125      88.189 115.740  48.351  1.00 60.76           O  
ATOM   6205  CG2 THR D 125      87.988 115.151  50.702  1.00 50.48           C  
ATOM   6206  N   LEU D 126      86.140 117.985  50.613  1.00 54.71           N  
ATOM   6207  CA  LEU D 126      85.947 119.360  50.984  1.00 55.21           C  
ATOM   6208  C   LEU D 126      87.265 120.087  51.307  1.00 56.74           C  
ATOM   6209  O   LEU D 126      88.332 119.525  51.532  1.00 55.62           O  
ATOM   6210  CB  LEU D 126      85.043 119.500  52.214  1.00 47.96           C  
ATOM   6211  CG  LEU D 126      83.805 118.616  52.298  1.00 46.75           C  
ATOM   6212  CD1 LEU D 126      83.135 118.790  53.661  1.00 45.42           C  
ATOM   6213  CD2 LEU D 126      82.833 118.897  51.171  1.00 46.43           C  
ATOM   6214  N   ALA D 127      87.139 121.413  51.347  1.00 57.27           N  
ATOM   6215  CA  ALA D 127      88.271 122.263  51.671  1.00 60.57           C  
ATOM   6216  C   ALA D 127      87.766 123.502  52.417  1.00 62.80           C  
ATOM   6217  O   ALA D 127      86.557 123.727  52.490  1.00 63.66           O  
ATOM   6218  CB  ALA D 127      89.059 122.656  50.454  1.00 57.70           C  
ATOM   6219  N   VAL D 128      88.687 124.236  52.992  1.00 64.34           N  
ATOM   6220  CA  VAL D 128      88.386 125.443  53.768  1.00 66.12           C  
ATOM   6221  C   VAL D 128      89.339 126.553  53.387  1.00 66.50           C  
ATOM   6222  O   VAL D 128      90.523 126.330  53.128  1.00 64.76           O  
ATOM   6223  CB  VAL D 128      88.495 125.081  55.270  1.00 68.94           C  
ATOM   6224  CG1 VAL D 128      88.939 126.229  56.130  1.00 74.35           C  
ATOM   6225  CG2 VAL D 128      87.129 124.571  55.762  1.00 70.36           C  
ATOM   6226  N   PRO D 129      88.858 127.787  53.338  1.00 68.61           N  
ATOM   6227  CA  PRO D 129      89.704 128.929  53.002  1.00 69.45           C  
ATOM   6228  C   PRO D 129      90.850 129.080  53.989  1.00 70.60           C  
ATOM   6229  O   PRO D 129      90.683 128.852  55.197  1.00 71.15           O  
ATOM   6230  CB  PRO D 129      88.754 130.112  53.100  1.00 68.48           C  
ATOM   6231  CG  PRO D 129      87.398 129.544  52.933  1.00 67.63           C  
ATOM   6232  CD  PRO D 129      87.465 128.200  53.624  1.00 68.30           C  
ATOM   6233  N   ILE D 130      92.037 129.340  53.481  1.00 71.91           N  
ATOM   6234  CA  ILE D 130      93.207 129.600  54.315  1.00 74.36           C  
ATOM   6235  C   ILE D 130      93.385 131.133  54.383  1.00 76.48           C  
ATOM   6236  O   ILE D 130      93.576 131.767  53.351  1.00 76.01           O  
ATOM   6237  CB  ILE D 130      94.492 128.986  53.778  1.00 74.15           C  
ATOM   6238  CG1 ILE D 130      94.497 127.461  53.951  1.00 72.98           C  
ATOM   6239  CG2 ILE D 130      95.711 129.611  54.456  1.00 71.18           C  
ATOM   6240  CD1 ILE D 130      95.770 126.807  53.448  1.00 73.16           C  
ATOM   6241  N   HIS D 131      93.256 131.678  55.570  1.00 78.87           N  
ATOM   6242  CA  HIS D 131      93.327 133.099  55.813  1.00 82.85           C  
ATOM   6243  C   HIS D 131      94.672 133.581  56.329  1.00 84.36           C  
ATOM   6244  O   HIS D 131      94.977 134.781  56.240  1.00 85.16           O  
ATOM   6245  CB  HIS D 131      92.232 133.503  56.835  1.00 85.40           C  
ATOM   6246  CG  HIS D 131      90.847 133.375  56.288  1.00 89.48           C  
ATOM   6247  ND1 HIS D 131      90.527 133.741  54.992  1.00 91.90           N  
ATOM   6248  CD2 HIS D 131      89.698 132.935  56.854  1.00 89.49           C  
ATOM   6249  CE1 HIS D 131      89.236 133.527  54.786  1.00 92.33           C  
ATOM   6250  NE2 HIS D 131      88.707 133.045  55.904  1.00 90.67           N  
ATOM   6251  N   ASN D 132      95.465 132.717  56.937  1.00 85.15           N  
ATOM   6252  CA  ASN D 132      96.756 133.155  57.489  1.00 86.75           C  
ATOM   6253  C   ASN D 132      97.880 132.716  56.577  1.00 86.52           C  
ATOM   6254  O   ASN D 132      97.733 131.744  55.831  1.00 88.00           O  
ATOM   6255  CB  ASN D 132      96.882 132.528  58.889  1.00 91.52           C  
ATOM   6256  CG  ASN D 132      96.743 131.011  58.772  1.00 96.18           C  
ATOM   6257  OD1 ASN D 132      97.784 130.383  58.599  1.00 97.64           O  
ATOM   6258  ND2 ASN D 132      95.528 130.500  58.829  1.00 97.98           N  
ATOM   6259  N   ALA D 133      99.028 133.369  56.599  1.00 85.82           N  
ATOM   6260  CA  ALA D 133     100.146 132.999  55.741  1.00 84.66           C  
ATOM   6261  C   ALA D 133     100.950 131.858  56.337  1.00 84.77           C  
ATOM   6262  O   ALA D 133     101.684 131.176  55.617  1.00 84.89           O  
ATOM   6263  CB  ALA D 133     101.017 134.201  55.436  1.00 84.97           C  
ATOM   6264  N   GLU D 134     100.814 131.646  57.641  1.00 84.32           N  
ATOM   6265  CA  GLU D 134     101.475 130.557  58.332  1.00 83.34           C  
ATOM   6266  C   GLU D 134     100.948 129.208  57.838  1.00 82.55           C  
ATOM   6267  O   GLU D 134     101.721 128.272  57.660  1.00 83.80           O  
ATOM   6268  CB  GLU D 134     101.230 130.652  59.845  1.00 85.02           C  
ATOM   6269  N   GLU D 135      99.636 129.104  57.692  1.00 81.54           N  
ATOM   6270  CA  GLU D 135      98.984 127.899  57.219  1.00 79.90           C  
ATOM   6271  C   GLU D 135      99.319 127.681  55.737  1.00 78.48           C  
ATOM   6272  O   GLU D 135      99.652 126.577  55.337  1.00 78.15           O  
ATOM   6273  CB  GLU D 135      97.474 127.962  57.341  1.00 81.16           C  
ATOM   6274  CG  GLU D 135      96.845 127.107  58.418  1.00 84.27           C  
ATOM   6275  CD  GLU D 135      95.336 127.019  58.229  1.00 86.83           C  
ATOM   6276  OE1 GLU D 135      94.717 128.089  58.063  1.00 88.46           O  
ATOM   6277  OE2 GLU D 135      94.796 125.902  58.240  1.00 88.85           O  
ATOM   6278  N   ALA D 136      99.255 128.783  54.988  1.00 76.98           N  
ATOM   6279  CA  ALA D 136      99.563 128.726  53.562  1.00 75.56           C  
ATOM   6280  C   ALA D 136     100.970 128.174  53.354  1.00 73.94           C  
ATOM   6281  O   ALA D 136     101.175 127.389  52.429  1.00 74.31           O  
ATOM   6282  CB  ALA D 136      99.342 130.056  52.885  1.00 72.39           C  
ATOM   6283  N   PHE D 137     101.897 128.490  54.235  1.00 72.25           N  
ATOM   6284  CA  PHE D 137     103.269 128.049  54.164  1.00 72.84           C  
ATOM   6285  C   PHE D 137     103.559 126.854  55.035  1.00 71.54           C  
ATOM   6286  O   PHE D 137     104.656 126.297  55.104  1.00 70.28           O  
ATOM   6287  CB  PHE D 137     104.218 129.244  54.465  1.00 77.45           C  
ATOM   6288  CG  PHE D 137     104.320 130.122  53.226  1.00 79.91           C  
ATOM   6289  CD1 PHE D 137     103.424 131.150  53.012  1.00 79.72           C  
ATOM   6290  CD2 PHE D 137     105.270 129.859  52.256  1.00 81.25           C  
ATOM   6291  CE1 PHE D 137     103.480 131.911  51.864  1.00 80.14           C  
ATOM   6292  CE2 PHE D 137     105.337 130.618  51.104  1.00 81.55           C  
ATOM   6293  CZ  PHE D 137     104.439 131.651  50.905  1.00 81.24           C  
ATOM   6294  N   ASN D 138     102.513 126.315  55.654  1.00 72.42           N  
ATOM   6295  CA  ASN D 138     102.648 125.147  56.522  1.00 72.06           C  
ATOM   6296  C   ASN D 138     102.429 123.857  55.746  1.00 71.52           C  
ATOM   6297  O   ASN D 138     101.323 123.564  55.302  1.00 70.89           O  
ATOM   6298  CB  ASN D 138     101.616 125.249  57.643  1.00 73.24           C  
ATOM   6299  CG  ASN D 138     101.794 124.194  58.705  1.00 74.00           C  
ATOM   6300  OD1 ASN D 138     102.495 123.200  58.525  1.00 74.88           O  
ATOM   6301  ND2 ASN D 138     101.127 124.425  59.826  1.00 74.08           N  
ATOM   6302  N   PRO D 139     103.453 123.017  55.706  1.00 71.52           N  
ATOM   6303  CA  PRO D 139     103.420 121.749  55.001  1.00 71.37           C  
ATOM   6304  C   PRO D 139     102.394 120.788  55.558  1.00 71.25           C  
ATOM   6305  O   PRO D 139     101.941 119.851  54.895  1.00 71.90           O  
ATOM   6306  CB  PRO D 139     104.831 121.198  55.152  1.00 71.27           C  
ATOM   6307  CG  PRO D 139     105.680 122.370  55.433  1.00 71.31           C  
ATOM   6308  CD  PRO D 139     104.816 123.349  56.184  1.00 71.43           C  
ATOM   6309  N   ASN D 140     102.058 120.954  56.835  1.00 70.26           N  
ATOM   6310  CA  ASN D 140     101.036 120.141  57.474  1.00 67.59           C  
ATOM   6311  C   ASN D 140      99.666 120.518  56.953  1.00 65.36           C  
ATOM   6312  O   ASN D 140      98.720 119.726  57.021  1.00 67.02           O  
ATOM   6313  CB  ASN D 140     101.145 120.321  58.996  1.00 71.69           C  
ATOM   6314  CG  ASN D 140     102.386 119.592  59.504  1.00 74.24           C  
ATOM   6315  OD1 ASN D 140     102.771 118.582  58.907  1.00 75.02           O  
ATOM   6316  ND2 ASN D 140     102.991 120.092  60.565  1.00 75.04           N  
ATOM   6317  N   ALA D 141      99.468 121.761  56.533  1.00 62.68           N  
ATOM   6318  CA  ALA D 141      98.201 122.153  55.915  1.00 60.44           C  
ATOM   6319  C   ALA D 141      98.326 121.740  54.436  1.00 60.36           C  
ATOM   6320  O   ALA D 141      99.363 121.973  53.814  1.00 58.80           O  
ATOM   6321  CB  ALA D 141      97.923 123.630  56.012  1.00 58.17           C  
ATOM   6322  N   VAL D 142      97.354 120.971  53.959  1.00 59.96           N  
ATOM   6323  CA  VAL D 142      97.461 120.512  52.565  1.00 57.92           C  
ATOM   6324  C   VAL D 142      96.615 121.437  51.694  1.00 56.73           C  
ATOM   6325  O   VAL D 142      95.425 121.610  51.944  1.00 55.24           O  
ATOM   6326  CB  VAL D 142      97.060 119.061  52.337  1.00 55.92           C  
ATOM   6327  CG1 VAL D 142      97.156 118.710  50.856  1.00 57.70           C  
ATOM   6328  CG2 VAL D 142      97.908 118.085  53.139  1.00 51.88           C  
ATOM   6329  N   LYS D 143      97.302 122.058  50.737  1.00 55.50           N  
ATOM   6330  CA  LYS D 143      96.600 122.968  49.838  1.00 55.23           C  
ATOM   6331  C   LYS D 143      96.102 122.176  48.635  1.00 55.07           C  
ATOM   6332  O   LYS D 143      96.700 121.141  48.339  1.00 57.12           O  
ATOM   6333  CB  LYS D 143      97.497 124.120  49.408  1.00 57.28           C  
ATOM   6334  CG  LYS D 143      97.624 125.206  50.458  1.00 55.21           C  
ATOM   6335  CD  LYS D 143      98.966 125.253  51.105  1.00 57.63           C  
ATOM   6336  CE  LYS D 143      99.450 123.971  51.692  1.00 59.26           C  
ATOM   6337  NZ  LYS D 143     100.328 124.185  52.880  1.00 62.45           N  
ATOM   6338  N   VAL D 144      94.999 122.586  48.075  1.00 54.65           N  
ATOM   6339  CA  VAL D 144      94.376 121.977  46.918  1.00 53.25           C  
ATOM   6340  C   VAL D 144      93.984 123.121  45.957  1.00 52.66           C  
ATOM   6341  O   VAL D 144      93.667 124.203  46.441  1.00 50.01           O  
ATOM   6342  CB  VAL D 144      93.129 121.159  47.255  1.00 54.24           C  
ATOM   6343  CG1 VAL D 144      92.074 121.981  47.992  1.00 51.27           C  
ATOM   6344  CG2 VAL D 144      92.501 120.545  45.995  1.00 51.23           C  
ATOM   6345  N   VAL D 145      94.196 122.887  44.679  1.00 53.14           N  
ATOM   6346  CA  VAL D 145      93.892 123.865  43.616  1.00 51.80           C  
ATOM   6347  C   VAL D 145      92.840 123.235  42.698  1.00 52.61           C  
ATOM   6348  O   VAL D 145      92.986 122.051  42.342  1.00 51.99           O  
ATOM   6349  CB  VAL D 145      95.151 124.192  42.805  1.00 51.39           C  
ATOM   6350  CG1 VAL D 145      94.867 125.215  41.713  1.00 49.33           C  
ATOM   6351  CG2 VAL D 145      96.276 124.677  43.722  1.00 48.92           C  
ATOM   6352  N   LEU D 146      91.744 123.917  42.479  1.00 52.91           N  
ATOM   6353  CA  LEU D 146      90.616 123.425  41.739  1.00 56.23           C  
ATOM   6354  C   LEU D 146      90.446 124.049  40.351  1.00 58.61           C  
ATOM   6355  O   LEU D 146      90.737 125.218  40.112  1.00 57.68           O  
ATOM   6356  CB  LEU D 146      89.340 123.749  42.554  1.00 56.59           C  
ATOM   6357  CG  LEU D 146      88.937 122.908  43.729  1.00 61.00           C  
ATOM   6358  CD1 LEU D 146      90.074 122.223  44.461  1.00 57.39           C  
ATOM   6359  CD2 LEU D 146      88.131 123.732  44.752  1.00 57.61           C  
ATOM   6360  N   ASP D 147      89.864 123.244  39.449  1.00 60.18           N  
ATOM   6361  CA  ASP D 147      89.467 123.724  38.121  1.00 59.71           C  
ATOM   6362  C   ASP D 147      88.142 124.472  38.298  1.00 58.06           C  
ATOM   6363  O   ASP D 147      87.542 124.411  39.368  1.00 57.08           O  
ATOM   6364  CB  ASP D 147      89.311 122.593  37.135  1.00 63.89           C  
ATOM   6365  CG  ASP D 147      88.134 121.664  37.290  1.00 65.16           C  
ATOM   6366  OD1 ASP D 147      87.197 121.884  38.072  1.00 61.56           O  
ATOM   6367  OD2 ASP D 147      88.096 120.635  36.536  1.00 67.23           O  
ATOM   6368  N   ALA D 148      87.604 125.074  37.265  1.00 59.12           N  
ATOM   6369  CA  ALA D 148      86.363 125.821  37.335  1.00 59.78           C  
ATOM   6370  C   ALA D 148      85.184 125.046  37.891  1.00 61.12           C  
ATOM   6371  O   ALA D 148      84.203 125.683  38.327  1.00 60.77           O  
ATOM   6372  CB  ALA D 148      85.997 126.386  35.961  1.00 54.00           C  
ATOM   6373  N   GLU D 149      85.177 123.714  37.820  1.00 62.68           N  
ATOM   6374  CA  GLU D 149      84.028 122.941  38.297  1.00 63.24           C  
ATOM   6375  C   GLU D 149      84.217 122.338  39.671  1.00 62.40           C  
ATOM   6376  O   GLU D 149      83.388 121.531  40.115  1.00 63.68           O  
ATOM   6377  CB  GLU D 149      83.632 121.882  37.265  1.00 65.15           C  
ATOM   6378  CG  GLU D 149      83.300 122.462  35.909  1.00 70.96           C  
ATOM   6379  CD  GLU D 149      82.410 121.603  35.054  1.00 79.34           C  
ATOM   6380  OE1 GLU D 149      82.662 120.379  34.890  1.00 81.26           O  
ATOM   6381  OE2 GLU D 149      81.420 122.178  34.518  1.00 83.65           O  
ATOM   6382  N   GLY D 150      85.254 122.710  40.401  1.00 61.10           N  
ATOM   6383  CA  GLY D 150      85.502 122.205  41.726  1.00 60.21           C  
ATOM   6384  C   GLY D 150      86.366 120.966  41.758  1.00 60.80           C  
ATOM   6385  O   GLY D 150      86.595 120.428  42.863  1.00 61.73           O  
ATOM   6386  N   TYR D 151      86.844 120.476  40.612  1.00 58.70           N  
ATOM   6387  CA  TYR D 151      87.721 119.296  40.640  1.00 57.87           C  
ATOM   6388  C   TYR D 151      89.160 119.659  40.967  1.00 57.51           C  
ATOM   6389  O   TYR D 151      89.708 120.656  40.464  1.00 58.14           O  
ATOM   6390  CB  TYR D 151      87.649 118.549  39.309  1.00 56.50           C  
ATOM   6391  CG  TYR D 151      86.253 118.028  39.041  1.00 55.04           C  
ATOM   6392  CD1 TYR D 151      85.392 118.698  38.186  1.00 55.41           C  
ATOM   6393  CD2 TYR D 151      85.787 116.922  39.726  1.00 54.61           C  
ATOM   6394  CE1 TYR D 151      84.105 118.260  37.978  1.00 54.41           C  
ATOM   6395  CE2 TYR D 151      84.503 116.461  39.514  1.00 55.72           C  
ATOM   6396  CZ  TYR D 151      83.674 117.130  38.636  1.00 55.91           C  
ATOM   6397  OH  TYR D 151      82.414 116.636  38.438  1.00 56.71           O  
ATOM   6398  N   ALA D 152      89.789 118.848  41.814  1.00 56.12           N  
ATOM   6399  CA  ALA D 152      91.154 119.111  42.219  1.00 55.59           C  
ATOM   6400  C   ALA D 152      92.136 118.987  41.055  1.00 56.62           C  
ATOM   6401  O   ALA D 152      92.304 117.923  40.481  1.00 57.18           O  
ATOM   6402  CB  ALA D 152      91.638 118.209  43.331  1.00 49.77           C  
ATOM   6403  N   LEU D 153      92.903 120.060  40.826  1.00 56.01           N  
ATOM   6404  CA  LEU D 153      93.956 119.948  39.813  1.00 56.36           C  
ATOM   6405  C   LEU D 153      95.112 119.134  40.410  1.00 55.68           C  
ATOM   6406  O   LEU D 153      95.607 118.190  39.798  1.00 56.65           O  
ATOM   6407  CB  LEU D 153      94.397 121.308  39.345  1.00 57.66           C  
ATOM   6408  CG  LEU D 153      93.900 121.825  37.996  1.00 61.46           C  
ATOM   6409  CD1 LEU D 153      92.712 121.086  37.439  1.00 56.44           C  
ATOM   6410  CD2 LEU D 153      93.645 123.332  38.105  1.00 60.66           C  
ATOM   6411  N   TYR D 154      95.392 119.397  41.677  1.00 54.62           N  
ATOM   6412  CA  TYR D 154      96.485 118.771  42.400  1.00 53.82           C  
ATOM   6413  C   TYR D 154      96.380 119.111  43.883  1.00 53.59           C  
ATOM   6414  O   TYR D 154      95.835 120.178  44.215  1.00 54.51           O  
ATOM   6415  CB  TYR D 154      97.807 119.363  41.832  1.00 53.07           C  
ATOM   6416  CG  TYR D 154      99.049 118.709  42.388  1.00 53.55           C  
ATOM   6417  CD1 TYR D 154      99.958 119.434  43.152  1.00 53.84           C  
ATOM   6418  CD2 TYR D 154      99.320 117.369  42.151  1.00 52.95           C  
ATOM   6419  CE1 TYR D 154     101.096 118.835  43.671  1.00 52.60           C  
ATOM   6420  CE2 TYR D 154     100.447 116.750  42.660  1.00 53.16           C  
ATOM   6421  CZ  TYR D 154     101.326 117.497  43.432  1.00 53.14           C  
ATOM   6422  OH  TYR D 154     102.452 116.901  43.938  1.00 51.92           O  
ATOM   6423  N   PHE D 155      96.855 118.266  44.753  1.00 52.79           N  
ATOM   6424  CA  PHE D 155      96.870 118.488  46.195  1.00 52.69           C  
ATOM   6425  C   PHE D 155      98.371 118.554  46.541  1.00 53.58           C  
ATOM   6426  O   PHE D 155      99.119 117.850  45.838  1.00 52.73           O  
ATOM   6427  CB  PHE D 155      96.315 117.325  47.016  1.00 52.06           C  
ATOM   6428  CG  PHE D 155      94.858 117.044  46.869  1.00 51.85           C  
ATOM   6429  CD1 PHE D 155      94.355 116.453  45.720  1.00 45.19           C  
ATOM   6430  CD2 PHE D 155      93.979 117.357  47.904  1.00 52.98           C  
ATOM   6431  CE1 PHE D 155      93.002 116.243  45.602  1.00 46.41           C  
ATOM   6432  CE2 PHE D 155      92.613 117.152  47.777  1.00 48.71           C  
ATOM   6433  CZ  PHE D 155      92.126 116.586  46.615  1.00 46.53           C  
ATOM   6434  N   SER D 156      98.778 119.317  47.540  1.00 53.13           N  
ATOM   6435  CA  SER D 156     100.230 119.284  47.791  1.00 54.87           C  
ATOM   6436  C   SER D 156     100.529 119.876  49.151  1.00 56.95           C  
ATOM   6437  O   SER D 156      99.742 120.687  49.635  1.00 59.65           O  
ATOM   6438  CB  SER D 156     100.956 120.125  46.728  1.00 54.36           C  
ATOM   6439  OG  SER D 156     102.350 120.135  46.976  1.00 52.57           O  
ATOM   6440  N   ARG D 157     101.721 119.590  49.637  1.00 57.40           N  
ATOM   6441  CA  ARG D 157     102.174 120.185  50.884  1.00 59.60           C  
ATOM   6442  C   ARG D 157     102.851 121.511  50.563  1.00 60.94           C  
ATOM   6443  O   ARG D 157     103.007 122.367  51.427  1.00 62.29           O  
ATOM   6444  CB  ARG D 157     103.035 119.247  51.701  1.00 60.03           C  
ATOM   6445  CG  ARG D 157     102.208 118.041  52.194  1.00 61.95           C  
ATOM   6446  CD  ARG D 157     103.063 117.077  52.965  1.00 66.91           C  
ATOM   6447  NE  ARG D 157     102.348 115.855  53.380  1.00 66.66           N  
ATOM   6448  CZ  ARG D 157     101.455 115.876  54.368  1.00 65.78           C  
ATOM   6449  NH1 ARG D 157     101.201 117.012  54.998  1.00 63.69           N  
ATOM   6450  NH2 ARG D 157     100.836 114.765  54.703  1.00 67.88           N  
ATOM   6451  N   ALA D 158     103.085 121.723  49.265  1.00 61.27           N  
ATOM   6452  CA  ALA D 158     103.679 122.980  48.791  1.00 60.35           C  
ATOM   6453  C   ALA D 158     102.633 124.089  48.807  1.00 58.77           C  
ATOM   6454  O   ALA D 158     101.439 123.816  48.942  1.00 60.11           O  
ATOM   6455  CB  ALA D 158     104.272 122.769  47.403  1.00 57.44           C  
ATOM   6456  N   THR D 159     103.050 125.335  48.724  1.00 56.95           N  
ATOM   6457  CA  THR D 159     102.092 126.447  48.733  1.00 57.37           C  
ATOM   6458  C   THR D 159     101.546 126.711  47.347  1.00 57.22           C  
ATOM   6459  O   THR D 159     102.236 127.244  46.476  1.00 58.11           O  
ATOM   6460  CB  THR D 159     102.770 127.689  49.344  1.00 57.93           C  
ATOM   6461  OG1 THR D 159     103.388 127.307  50.613  1.00 54.25           O  
ATOM   6462  CG2 THR D 159     101.752 128.763  49.637  1.00 57.17           C  
ATOM   6463  N   ILE D 160     100.335 126.267  47.040  1.00 56.63           N  
ATOM   6464  CA  ILE D 160      99.710 126.425  45.745  1.00 57.44           C  
ATOM   6465  C   ILE D 160      98.272 126.910  45.942  1.00 59.24           C  
ATOM   6466  O   ILE D 160      97.644 126.577  46.935  1.00 59.06           O  
ATOM   6467  CB  ILE D 160      99.622 125.102  44.945  1.00 59.34           C  
ATOM   6468  CG1 ILE D 160      98.890 124.033  45.762  1.00 60.53           C  
ATOM   6469  CG2 ILE D 160     100.980 124.592  44.520  1.00 57.51           C  
ATOM   6470  CD1 ILE D 160      98.835 122.660  45.146  1.00 61.39           C  
ATOM   6471  N   PRO D 161      97.763 127.692  45.001  1.00 60.52           N  
ATOM   6472  CA  PRO D 161      98.547 128.125  43.858  1.00 60.20           C  
ATOM   6473  C   PRO D 161      99.593 129.132  44.342  1.00 60.59           C  
ATOM   6474  O   PRO D 161      99.368 129.824  45.327  1.00 58.46           O  
ATOM   6475  CB  PRO D 161      97.531 128.814  42.968  1.00 59.98           C  
ATOM   6476  CG  PRO D 161      96.461 129.288  43.880  1.00 58.79           C  
ATOM   6477  CD  PRO D 161      96.423 128.302  45.013  1.00 60.03           C  
ATOM   6478  N   TRP D 162     100.726 129.159  43.663  1.00 62.26           N  
ATOM   6479  CA  TRP D 162     101.787 130.104  43.984  1.00 63.43           C  
ATOM   6480  C   TRP D 162     101.396 131.492  43.449  1.00 65.07           C  
ATOM   6481  O   TRP D 162     100.997 131.606  42.295  1.00 65.86           O  
ATOM   6482  CB  TRP D 162     103.087 129.652  43.354  1.00 62.02           C  
ATOM   6483  CG  TRP D 162     104.188 130.638  43.605  1.00 63.68           C  
ATOM   6484  CD1 TRP D 162     104.644 131.619  42.780  1.00 64.74           C  
ATOM   6485  CD2 TRP D 162     104.957 130.716  44.801  1.00 64.21           C  
ATOM   6486  NE1 TRP D 162     105.661 132.309  43.399  1.00 63.12           N  
ATOM   6487  CE2 TRP D 162     105.883 131.765  44.630  1.00 62.61           C  
ATOM   6488  CE3 TRP D 162     104.949 129.989  46.002  1.00 66.86           C  
ATOM   6489  CZ2 TRP D 162     106.792 132.100  45.625  1.00 62.63           C  
ATOM   6490  CZ3 TRP D 162     105.854 130.341  47.003  1.00 66.61           C  
ATOM   6491  CH2 TRP D 162     106.758 131.396  46.795  1.00 64.72           C  
ATOM   6492  N   ASP D 163     101.349 132.470  44.333  1.00 65.53           N  
ATOM   6493  CA  ASP D 163     100.960 133.837  43.917  1.00 66.28           C  
ATOM   6494  C   ASP D 163     102.257 134.557  43.564  1.00 66.78           C  
ATOM   6495  O   ASP D 163     102.864 135.195  44.423  1.00 67.15           O  
ATOM   6496  CB  ASP D 163     100.256 134.483  45.089  1.00 66.35           C  
ATOM   6497  CG  ASP D 163      99.566 135.789  44.824  1.00 65.72           C  
ATOM   6498  OD1 ASP D 163      99.923 136.490  43.852  1.00 68.57           O  
ATOM   6499  OD2 ASP D 163      98.660 136.135  45.627  1.00 62.86           O  
ATOM   6500  N   ARG D 164     102.688 134.473  42.307  1.00 66.64           N  
ATOM   6501  CA  ARG D 164     103.997 135.023  41.971  1.00 68.14           C  
ATOM   6502  C   ARG D 164     104.225 136.482  42.212  1.00 67.60           C  
ATOM   6503  O   ARG D 164     105.286 136.785  42.811  1.00 67.76           O  
ATOM   6504  CB  ARG D 164     104.525 134.469  40.680  1.00 67.29           C  
ATOM   6505  CG  ARG D 164     104.557 135.196  39.427  1.00 64.06           C  
ATOM   6506  CD  ARG D 164     105.673 136.261  39.275  1.00 61.38           C  
ATOM   6507  NE  ARG D 164     105.170 137.084  38.128  1.00 66.44           N  
ATOM   6508  CZ  ARG D 164     105.523 136.742  36.887  1.00 65.09           C  
ATOM   6509  NH1 ARG D 164     106.366 135.725  36.723  1.00 63.34           N  
ATOM   6510  NH2 ARG D 164     105.009 137.407  35.871  1.00 62.54           N  
ATOM   6511  N   ASP D 165     103.343 137.424  41.938  1.00 68.35           N  
ATOM   6512  CA  ASP D 165     103.638 138.834  42.172  1.00 70.04           C  
ATOM   6513  C   ASP D 165     103.669 139.200  43.643  1.00 71.99           C  
ATOM   6514  O   ASP D 165     104.569 139.948  44.094  1.00 70.78           O  
ATOM   6515  CB  ASP D 165     102.773 139.752  41.325  1.00 66.78           C  
ATOM   6516  CG  ASP D 165     102.935 139.500  39.841  1.00 67.37           C  
ATOM   6517  OD1 ASP D 165     104.009 139.044  39.408  1.00 66.38           O  
ATOM   6518  OD2 ASP D 165     101.975 139.716  39.057  1.00 71.69           O  
ATOM   6519  N   ARG D 166     102.783 138.619  44.425  1.00 73.69           N  
ATOM   6520  CA  ARG D 166     102.689 138.827  45.865  1.00 75.29           C  
ATOM   6521  C   ARG D 166     103.882 138.276  46.622  1.00 77.07           C  
ATOM   6522  O   ARG D 166     104.464 138.929  47.484  1.00 77.89           O  
ATOM   6523  CB  ARG D 166     101.425 138.115  46.378  1.00 75.74           C  
ATOM   6524  CG  ARG D 166     101.037 138.398  47.788  1.00 72.88           C  
ATOM   6525  CD  ARG D 166      99.880 137.489  48.253  1.00 75.15           C  
ATOM   6526  NE  ARG D 166      99.024 138.312  49.106  1.00 78.48           N  
ATOM   6527  CZ  ARG D 166      97.968 138.987  48.674  1.00 78.19           C  
ATOM   6528  NH1 ARG D 166      97.587 138.896  47.418  1.00 77.22           N  
ATOM   6529  NH2 ARG D 166      97.309 139.760  49.533  1.00 79.62           N  
ATOM   6530  N   PHE D 167     104.302 137.048  46.302  1.00 78.70           N  
ATOM   6531  CA  PHE D 167     105.435 136.448  46.994  1.00 79.40           C  
ATOM   6532  C   PHE D 167     106.762 137.021  46.557  1.00 80.96           C  
ATOM   6533  O   PHE D 167     107.753 136.864  47.274  1.00 80.56           O  
ATOM   6534  CB  PHE D 167     105.425 134.931  46.912  1.00 76.04           C  
ATOM   6535  CG  PHE D 167     104.158 134.319  47.459  1.00 74.01           C  
ATOM   6536  CD1 PHE D 167     103.388 134.965  48.407  1.00 71.57           C  
ATOM   6537  CD2 PHE D 167     103.747 133.073  47.019  1.00 72.40           C  
ATOM   6538  CE1 PHE D 167     102.228 134.399  48.886  1.00 71.97           C  
ATOM   6539  CE2 PHE D 167     102.599 132.492  47.498  1.00 71.74           C  
ATOM   6540  CZ  PHE D 167     101.825 133.157  48.436  1.00 72.36           C  
ATOM   6541  N   ALA D 168     106.761 137.730  45.430  1.00 83.13           N  
ATOM   6542  CA  ALA D 168     107.984 138.428  44.993  1.00 85.52           C  
ATOM   6543  C   ALA D 168     108.239 139.551  46.012  1.00 86.97           C  
ATOM   6544  O   ALA D 168     109.366 139.818  46.392  1.00 86.69           O  
ATOM   6545  CB  ALA D 168     107.812 138.950  43.586  1.00 85.19           C  
ATOM   6546  N   GLU D 169     107.149 140.113  46.538  1.00 88.88           N  
ATOM   6547  CA  GLU D 169     107.179 141.135  47.548  1.00 91.89           C  
ATOM   6548  C   GLU D 169     107.440 140.591  48.952  1.00 93.25           C  
ATOM   6549  O   GLU D 169     108.313 141.116  49.661  1.00 94.18           O  
ATOM   6550  CB  GLU D 169     105.868 141.942  47.562  1.00 90.93           C  
ATOM   6551  N   GLY D 170     106.669 139.611  49.384  1.00 94.30           N  
ATOM   6552  CA  GLY D 170     106.813 139.035  50.710  1.00 95.62           C  
ATOM   6553  C   GLY D 170     105.879 137.849  50.921  1.00 96.90           C  
ATOM   6554  O   GLY D 170     104.903 137.646  50.196  1.00 96.90           O  
ATOM   6555  N   LEU D 171     106.209 137.044  51.924  1.00 97.61           N  
ATOM   6556  CA  LEU D 171     105.446 135.842  52.237  1.00 99.78           C  
ATOM   6557  C   LEU D 171     104.720 135.956  53.570  1.00100.28           C  
ATOM   6558  O   LEU D 171     104.323 134.954  54.169  1.00101.13           O  
ATOM   6559  CB  LEU D 171     106.402 134.643  52.248  1.00 99.87           C  
ATOM   6560  CG  LEU D 171     107.021 134.208  50.932  1.00 99.84           C  
ATOM   6561  CD1 LEU D 171     108.027 135.207  50.381  1.00100.08           C  
ATOM   6562  CD2 LEU D 171     107.734 132.863  51.122  1.00100.99           C  
ATOM   6563  N   GLU D 172     104.495 137.189  54.017  1.00100.54           N  
ATOM   6564  CA  GLU D 172     103.847 137.421  55.306  1.00100.81           C  
ATOM   6565  C   GLU D 172     102.380 137.766  55.154  1.00 99.73           C  
ATOM   6566  O   GLU D 172     101.694 138.187  56.088  1.00 99.76           O  
ATOM   6567  CB  GLU D 172     104.617 138.508  56.067  1.00103.74           C  
ATOM   6568  N   THR D 173     101.831 137.488  53.970  1.00 98.93           N  
ATOM   6569  CA  THR D 173     100.414 137.747  53.726  1.00 97.74           C  
ATOM   6570  C   THR D 173      99.892 137.036  52.490  1.00 96.40           C  
ATOM   6571  O   THR D 173     100.555 136.986  51.455  1.00 96.31           O  
ATOM   6572  CB  THR D 173     100.162 139.261  53.587  1.00 99.67           C  
ATOM   6573  N   VAL D 174      98.674 136.498  52.567  1.00 95.47           N  
ATOM   6574  CA  VAL D 174      98.081 135.788  51.446  1.00 94.68           C  
ATOM   6575  C   VAL D 174      96.777 136.397  50.963  1.00 94.29           C  
ATOM   6576  O   VAL D 174      96.208 137.307  51.559  1.00 95.22           O  
ATOM   6577  CB  VAL D 174      97.825 134.298  51.737  1.00 93.65           C  
ATOM   6578  CG1 VAL D 174      99.133 133.524  51.734  1.00 94.57           C  
ATOM   6579  CG2 VAL D 174      97.090 134.106  53.046  1.00 93.02           C  
ATOM   6580  N   GLY D 175      96.308 135.900  49.820  1.00 93.92           N  
ATOM   6581  CA  GLY D 175      95.050 136.379  49.254  1.00 93.29           C  
ATOM   6582  C   GLY D 175      93.902 135.484  49.715  1.00 93.61           C  
ATOM   6583  O   GLY D 175      93.915 134.899  50.799  1.00 94.11           O  
ATOM   6584  N   ASP D 176      92.857 135.416  48.901  1.00 93.29           N  
ATOM   6585  CA  ASP D 176      91.712 134.568  49.213  1.00 92.98           C  
ATOM   6586  C   ASP D 176      91.697 133.357  48.278  1.00 91.12           C  
ATOM   6587  O   ASP D 176      90.673 132.687  48.150  1.00 92.27           O  
ATOM   6588  CB  ASP D 176      90.409 135.336  49.012  1.00 97.22           C  
ATOM   6589  CG  ASP D 176      90.254 136.548  49.882  1.00100.21           C  
ATOM   6590  OD1 ASP D 176      89.124 137.100  49.893  1.00102.69           O  
ATOM   6591  OD2 ASP D 176      91.218 136.965  50.554  1.00102.51           O  
ATOM   6592  N   ASN D 177      92.824 133.073  47.627  1.00 88.32           N  
ATOM   6593  CA  ASN D 177      92.807 131.957  46.684  1.00 85.41           C  
ATOM   6594  C   ASN D 177      93.359 130.682  47.271  1.00 82.10           C  
ATOM   6595  O   ASN D 177      93.458 129.679  46.547  1.00 82.91           O  
ATOM   6596  CB  ASN D 177      93.486 132.359  45.379  1.00 87.89           C  
ATOM   6597  CG  ASN D 177      94.938 132.734  45.554  1.00 90.79           C  
ATOM   6598  OD1 ASN D 177      95.792 131.871  45.786  1.00 92.12           O  
ATOM   6599  ND2 ASN D 177      95.235 134.024  45.429  1.00 92.09           N  
ATOM   6600  N   PHE D 178      93.613 130.610  48.573  1.00 78.20           N  
ATOM   6601  CA  PHE D 178      94.147 129.385  49.156  1.00 74.90           C  
ATOM   6602  C   PHE D 178      93.097 128.485  49.773  1.00 72.04           C  
ATOM   6603  O   PHE D 178      92.093 128.981  50.298  1.00 72.85           O  
ATOM   6604  CB  PHE D 178      95.239 129.715  50.177  1.00 76.28           C  
ATOM   6605  CG  PHE D 178      96.477 130.264  49.526  1.00 78.11           C  
ATOM   6606  CD1 PHE D 178      96.696 131.624  49.450  1.00 78.44           C  
ATOM   6607  CD2 PHE D 178      97.407 129.400  48.959  1.00 78.98           C  
ATOM   6608  CE1 PHE D 178      97.830 132.124  48.835  1.00 78.53           C  
ATOM   6609  CE2 PHE D 178      98.537 129.886  48.338  1.00 77.24           C  
ATOM   6610  CZ  PHE D 178      98.745 131.255  48.282  1.00 79.32           C  
ATOM   6611  N   LEU D 179      93.267 127.169  49.661  1.00 68.18           N  
ATOM   6612  CA  LEU D 179      92.329 126.207  50.222  1.00 66.59           C  
ATOM   6613  C   LEU D 179      93.021 125.084  51.002  1.00 64.48           C  
ATOM   6614  O   LEU D 179      93.966 124.454  50.538  1.00 61.98           O  
ATOM   6615  CB  LEU D 179      91.398 125.621  49.161  1.00 64.12           C  
ATOM   6616  CG  LEU D 179      90.369 126.577  48.544  1.00 63.76           C  
ATOM   6617  CD1 LEU D 179      89.755 126.006  47.279  1.00 58.08           C  
ATOM   6618  CD2 LEU D 179      89.275 126.915  49.559  1.00 61.22           C  
ATOM   6619  N   ARG D 180      92.619 124.918  52.262  1.00 63.75           N  
ATOM   6620  CA  ARG D 180      93.138 123.847  53.105  1.00 63.62           C  
ATOM   6621  C   ARG D 180      92.242 122.599  52.917  1.00 64.00           C  
ATOM   6622  O   ARG D 180      91.019 122.703  53.059  1.00 62.50           O  
ATOM   6623  CB  ARG D 180      93.177 124.208  54.582  1.00 58.57           C  
ATOM   6624  CG  ARG D 180      93.546 123.029  55.473  1.00 59.91           C  
ATOM   6625  CD  ARG D 180      93.922 123.444  56.886  1.00 55.79           C  
ATOM   6626  NE  ARG D 180      92.739 124.040  57.533  1.00 63.15           N  
ATOM   6627  CZ  ARG D 180      91.879 123.367  58.289  1.00 59.94           C  
ATOM   6628  NH1 ARG D 180      92.082 122.080  58.501  1.00 60.29           N  
ATOM   6629  NH2 ARG D 180      90.837 123.978  58.840  1.00 61.20           N  
ATOM   6630  N   HIS D 181      92.862 121.503  52.512  1.00 63.63           N  
ATOM   6631  CA  HIS D 181      92.096 120.281  52.247  1.00 66.58           C  
ATOM   6632  C   HIS D 181      91.669 119.619  53.547  1.00 67.69           C  
ATOM   6633  O   HIS D 181      92.446 119.591  54.494  1.00 69.20           O  
ATOM   6634  CB  HIS D 181      92.892 119.322  51.385  1.00 66.97           C  
ATOM   6635  CG  HIS D 181      92.398 117.923  51.273  1.00 63.02           C  
ATOM   6636  ND1 HIS D 181      91.156 117.596  50.805  1.00 64.47           N  
ATOM   6637  CD2 HIS D 181      93.023 116.745  51.525  1.00 64.51           C  
ATOM   6638  CE1 HIS D 181      91.012 116.282  50.800  1.00 64.15           C  
ATOM   6639  NE2 HIS D 181      92.133 115.740  51.225  1.00 63.44           N  
ATOM   6640  N   LEU D 182      90.431 119.140  53.583  1.00 68.11           N  
ATOM   6641  CA  LEU D 182      89.921 118.464  54.781  1.00 67.90           C  
ATOM   6642  C   LEU D 182      89.821 116.965  54.538  1.00 67.84           C  
ATOM   6643  O   LEU D 182      89.290 116.484  53.540  1.00 66.97           O  
ATOM   6644  CB  LEU D 182      88.582 119.058  55.200  1.00 66.48           C  
ATOM   6645  CG  LEU D 182      88.569 120.535  55.629  1.00 65.13           C  
ATOM   6646  CD1 LEU D 182      87.164 121.104  55.536  1.00 64.23           C  
ATOM   6647  CD2 LEU D 182      89.133 120.702  57.037  1.00 57.67           C  
ATOM   6648  N   GLY D 183      90.276 116.165  55.493  1.00 68.74           N  
ATOM   6649  CA  GLY D 183      90.320 114.743  55.432  1.00 67.89           C  
ATOM   6650  C   GLY D 183      89.036 113.979  55.499  1.00 68.48           C  
ATOM   6651  O   GLY D 183      89.064 112.821  55.963  1.00 68.88           O  
ATOM   6652  N   ILE D 184      87.907 114.533  55.095  1.00 68.15           N  
ATOM   6653  CA  ILE D 184      86.644 113.777  55.095  1.00 68.76           C  
ATOM   6654  C   ILE D 184      86.351 113.370  53.658  1.00 68.61           C  
ATOM   6655  O   ILE D 184      86.433 114.204  52.772  1.00 68.76           O  
ATOM   6656  CB  ILE D 184      85.529 114.552  55.785  1.00 69.50           C  
ATOM   6657  CG1 ILE D 184      84.178 113.909  55.502  1.00 66.98           C  
ATOM   6658  CG2 ILE D 184      85.562 116.044  55.492  1.00 65.73           C  
ATOM   6659  CD1 ILE D 184      83.000 114.455  56.229  1.00 66.58           C  
ATOM   6660  N   TYR D 185      86.181 112.087  53.342  1.00 68.98           N  
ATOM   6661  CA  TYR D 185      86.018 111.684  51.956  1.00 68.36           C  
ATOM   6662  C   TYR D 185      84.721 110.948  51.632  1.00 68.23           C  
ATOM   6663  O   TYR D 185      84.210 110.157  52.411  1.00 67.47           O  
ATOM   6664  CB  TYR D 185      87.160 110.751  51.555  1.00 69.27           C  
ATOM   6665  CG  TYR D 185      88.547 111.311  51.578  1.00 70.35           C  
ATOM   6666  CD1 TYR D 185      89.346 111.185  52.708  1.00 69.25           C  
ATOM   6667  CD2 TYR D 185      89.086 111.942  50.454  1.00 71.29           C  
ATOM   6668  CE1 TYR D 185      90.627 111.680  52.734  1.00 70.01           C  
ATOM   6669  CE2 TYR D 185      90.377 112.439  50.480  1.00 71.75           C  
ATOM   6670  CZ  TYR D 185      91.141 112.298  51.616  1.00 71.82           C  
ATOM   6671  OH  TYR D 185      92.432 112.780  51.674  1.00 74.07           O  
ATOM   6672  N   GLY D 186      84.318 111.083  50.367  1.00 67.87           N  
ATOM   6673  CA  GLY D 186      83.124 110.433  49.840  1.00 68.50           C  
ATOM   6674  C   GLY D 186      83.486 109.652  48.580  1.00 68.51           C  
ATOM   6675  O   GLY D 186      84.358 110.078  47.827  1.00 69.72           O  
ATOM   6676  N   TYR D 187      83.000 108.429  48.449  1.00 68.66           N  
ATOM   6677  CA  TYR D 187      83.280 107.565  47.325  1.00 67.79           C  
ATOM   6678  C   TYR D 187      82.287 106.399  47.278  1.00 66.54           C  
ATOM   6679  O   TYR D 187      81.786 106.014  48.323  1.00 65.44           O  
ATOM   6680  CB  TYR D 187      84.665 106.934  47.322  1.00 69.60           C  
ATOM   6681  CG  TYR D 187      85.420 106.892  48.620  1.00 71.13           C  
ATOM   6682  CD1 TYR D 187      86.762 107.274  48.658  1.00 70.60           C  
ATOM   6683  CD2 TYR D 187      84.821 106.540  49.812  1.00 71.72           C  
ATOM   6684  CE1 TYR D 187      87.478 107.268  49.834  1.00 70.66           C  
ATOM   6685  CE2 TYR D 187      85.534 106.531  50.992  1.00 72.82           C  
ATOM   6686  CZ  TYR D 187      86.863 106.892  50.998  1.00 72.32           C  
ATOM   6687  OH  TYR D 187      87.552 106.878  52.189  1.00 74.38           O  
ATOM   6688  N   ARG D 188      82.119 105.837  46.077  1.00 64.72           N  
ATOM   6689  CA  ARG D 188      81.237 104.669  46.001  1.00 62.96           C  
ATOM   6690  C   ARG D 188      82.033 103.421  46.382  1.00 61.99           C  
ATOM   6691  O   ARG D 188      83.241 103.369  46.204  1.00 60.38           O  
ATOM   6692  CB  ARG D 188      80.589 104.485  44.648  1.00 62.00           C  
ATOM   6693  CG  ARG D 188      79.372 105.365  44.388  1.00 59.11           C  
ATOM   6694  CD  ARG D 188      79.249 105.601  42.882  1.00 57.81           C  
ATOM   6695  NE  ARG D 188      78.941 107.023  42.631  1.00 64.43           N  
ATOM   6696  CZ  ARG D 188      77.686 107.467  42.808  1.00 64.92           C  
ATOM   6697  NH1 ARG D 188      76.809 106.554  43.203  1.00 61.53           N  
ATOM   6698  NH2 ARG D 188      77.384 108.732  42.606  1.00 65.56           N  
ATOM   6699  N   ALA D 189      81.312 102.428  46.882  1.00 62.90           N  
ATOM   6700  CA  ALA D 189      81.892 101.137  47.239  1.00 63.36           C  
ATOM   6701  C   ALA D 189      82.588 100.512  46.045  1.00 62.53           C  
ATOM   6702  O   ALA D 189      83.697  99.983  46.158  1.00 62.79           O  
ATOM   6703  CB  ALA D 189      80.841 100.209  47.836  1.00 61.44           C  
ATOM   6704  N   GLY D 190      82.028 100.589  44.846  1.00 62.96           N  
ATOM   6705  CA  GLY D 190      82.773 100.083  43.678  1.00 64.54           C  
ATOM   6706  C   GLY D 190      84.156 100.709  43.568  1.00 64.25           C  
ATOM   6707  O   GLY D 190      85.134 100.015  43.270  1.00 64.23           O  
ATOM   6708  N   PHE D 191      84.293 102.015  43.758  1.00 65.11           N  
ATOM   6709  CA  PHE D 191      85.567 102.709  43.652  1.00 65.36           C  
ATOM   6710  C   PHE D 191      86.546 102.305  44.742  1.00 66.19           C  
ATOM   6711  O   PHE D 191      87.696 101.971  44.437  1.00 65.69           O  
ATOM   6712  CB  PHE D 191      85.370 104.223  43.657  1.00 67.04           C  
ATOM   6713  CG  PHE D 191      86.600 105.021  43.321  1.00 69.56           C  
ATOM   6714  CD1 PHE D 191      86.899 105.315  41.993  1.00 68.71           C  
ATOM   6715  CD2 PHE D 191      87.444 105.484  44.321  1.00 69.02           C  
ATOM   6716  CE1 PHE D 191      88.023 106.050  41.684  1.00 70.85           C  
ATOM   6717  CE2 PHE D 191      88.576 106.208  44.010  1.00 69.90           C  
ATOM   6718  CZ  PHE D 191      88.857 106.496  42.690  1.00 71.46           C  
ATOM   6719  N   ILE D 192      86.117 102.369  45.990  1.00 66.71           N  
ATOM   6720  CA  ILE D 192      86.933 101.998  47.147  1.00 67.91           C  
ATOM   6721  C   ILE D 192      87.597 100.649  46.940  1.00 68.47           C  
ATOM   6722  O   ILE D 192      88.804 100.458  47.032  1.00 66.53           O  
ATOM   6723  CB  ILE D 192      86.027 101.908  48.401  1.00 69.68           C  
ATOM   6724  CG1 ILE D 192      85.825 103.279  49.034  1.00 70.71           C  
ATOM   6725  CG2 ILE D 192      86.526 100.901  49.413  1.00 68.90           C  
ATOM   6726  CD1 ILE D 192      84.534 103.348  49.854  1.00 71.97           C  
ATOM   6727  N   ARG D 193      86.772  99.650  46.563  1.00 70.53           N  
ATOM   6728  CA  ARG D 193      87.318  98.307  46.414  1.00 73.44           C  
ATOM   6729  C   ARG D 193      88.231  98.161  45.229  1.00 75.11           C  
ATOM   6730  O   ARG D 193      88.953  97.148  45.148  1.00 76.98           O  
ATOM   6731  CB  ARG D 193      86.338  97.228  46.651  1.00 72.37           C  
ATOM   6732  CG  ARG D 193      85.539  96.569  45.595  1.00 71.76           C  
ATOM   6733  CD  ARG D 193      84.353  95.811  46.194  1.00 69.78           C  
ATOM   6734  NE  ARG D 193      83.090  96.451  45.862  1.00 71.94           N  
ATOM   6735  CZ  ARG D 193      81.931  96.149  46.464  1.00 72.67           C  
ATOM   6736  NH1 ARG D 193      81.934  95.233  47.428  1.00 72.23           N  
ATOM   6737  NH2 ARG D 193      80.809  96.736  46.080  1.00 67.73           N  
ATOM   6738  N   ARG D 194      88.342  99.157  44.366  1.00 76.17           N  
ATOM   6739  CA  ARG D 194      89.274  99.138  43.246  1.00 76.52           C  
ATOM   6740  C   ARG D 194      90.505  99.965  43.624  1.00 76.67           C  
ATOM   6741  O   ARG D 194      91.642  99.500  43.542  1.00 77.79           O  
ATOM   6742  CB  ARG D 194      88.677  99.708  41.964  1.00 77.04           C  
ATOM   6743  N   TYR D 195      90.245 101.157  44.152  1.00 75.10           N  
ATOM   6744  CA  TYR D 195      91.327 102.023  44.606  1.00 74.20           C  
ATOM   6745  C   TYR D 195      92.362 101.213  45.394  1.00 73.95           C  
ATOM   6746  O   TYR D 195      93.561 101.418  45.212  1.00 73.11           O  
ATOM   6747  CB  TYR D 195      90.757 103.140  45.491  1.00 74.14           C  
ATOM   6748  CG  TYR D 195      91.770 103.958  46.252  1.00 74.98           C  
ATOM   6749  CD1 TYR D 195      92.029 105.280  45.898  1.00 76.13           C  
ATOM   6750  CD2 TYR D 195      92.467 103.438  47.332  1.00 76.14           C  
ATOM   6751  CE1 TYR D 195      92.951 106.038  46.587  1.00 78.12           C  
ATOM   6752  CE2 TYR D 195      93.413 104.165  48.013  1.00 77.73           C  
ATOM   6753  CZ  TYR D 195      93.642 105.474  47.644  1.00 80.09           C  
ATOM   6754  OH  TYR D 195      94.575 106.217  48.341  1.00 82.34           O  
ATOM   6755  N   VAL D 196      91.902 100.398  46.341  1.00 73.07           N  
ATOM   6756  CA  VAL D 196      92.716  99.657  47.248  1.00 73.12           C  
ATOM   6757  C   VAL D 196      93.655  98.647  46.645  1.00 73.75           C  
ATOM   6758  O   VAL D 196      94.632  98.261  47.305  1.00 73.39           O  
ATOM   6759  CB  VAL D 196      91.942  99.030  48.429  1.00 71.18           C  
ATOM   6760  CG1 VAL D 196      90.991 100.071  49.015  1.00 70.65           C  
ATOM   6761  CG2 VAL D 196      91.239  97.760  48.053  1.00 67.40           C  
ATOM   6762  N   ASN D 197      93.435  98.191  45.425  1.00 74.78           N  
ATOM   6763  CA  ASN D 197      94.390  97.263  44.810  1.00 76.57           C  
ATOM   6764  C   ASN D 197      95.292  97.946  43.801  1.00 77.11           C  
ATOM   6765  O   ASN D 197      96.216  97.348  43.237  1.00 77.82           O  
ATOM   6766  CB  ASN D 197      93.647  96.063  44.228  1.00 77.58           C  
ATOM   6767  CG  ASN D 197      92.962  95.305  45.369  1.00 80.36           C  
ATOM   6768  OD1 ASN D 197      93.485  95.248  46.484  1.00 80.36           O  
ATOM   6769  ND2 ASN D 197      91.787  94.785  45.078  1.00 82.62           N  
ATOM   6770  N   TRP D 198      95.089  99.239  43.565  1.00 76.22           N  
ATOM   6771  CA  TRP D 198      95.945  99.980  42.662  1.00 76.24           C  
ATOM   6772  C   TRP D 198      97.389  99.967  43.170  1.00 77.82           C  
ATOM   6773  O   TRP D 198      97.643 100.008  44.368  1.00 78.16           O  
ATOM   6774  CB  TRP D 198      95.433 101.399  42.514  1.00 70.77           C  
ATOM   6775  CG  TRP D 198      94.360 101.594  41.495  1.00 69.91           C  
ATOM   6776  CD1 TRP D 198      93.986 100.757  40.483  1.00 70.20           C  
ATOM   6777  CD2 TRP D 198      93.549 102.770  41.349  1.00 67.87           C  
ATOM   6778  NE1 TRP D 198      92.985 101.330  39.737  1.00 70.56           N  
ATOM   6779  CE2 TRP D 198      92.699 102.567  40.254  1.00 68.40           C  
ATOM   6780  CE3 TRP D 198      93.471 103.975  42.051  1.00 68.72           C  
ATOM   6781  CZ2 TRP D 198      91.781 103.524  39.832  1.00 69.31           C  
ATOM   6782  CZ3 TRP D 198      92.556 104.922  41.640  1.00 69.91           C  
ATOM   6783  CH2 TRP D 198      91.719 104.698  40.532  1.00 69.38           C  
ATOM   6784  N   GLN D 199      98.340  99.857  42.249  1.00 79.12           N  
ATOM   6785  CA  GLN D 199      99.765  99.885  42.671  1.00 80.59           C  
ATOM   6786  C   GLN D 199     100.065 101.311  43.109  1.00 80.47           C  
ATOM   6787  O   GLN D 199      99.774 102.266  42.382  1.00 80.42           O  
ATOM   6788  CB  GLN D 199     100.608  99.431  41.505  1.00 84.71           C  
ATOM   6789  CG  GLN D 199     102.107  99.349  41.668  1.00 87.91           C  
ATOM   6790  CD  GLN D 199     102.774  98.733  40.441  1.00 88.67           C  
ATOM   6791  OE1 GLN D 199     103.677  99.319  39.853  1.00 89.77           O  
ATOM   6792  NE2 GLN D 199     102.313  97.551  40.041  1.00 88.74           N  
ATOM   6793  N   PRO D 200     100.553 101.481  44.322  1.00 80.55           N  
ATOM   6794  CA  PRO D 200     100.860 102.797  44.859  1.00 79.80           C  
ATOM   6795  C   PRO D 200     101.605 103.665  43.856  1.00 79.33           C  
ATOM   6796  O   PRO D 200     102.593 103.282  43.237  1.00 78.97           O  
ATOM   6797  CB  PRO D 200     101.648 102.545  46.111  1.00 79.48           C  
ATOM   6798  CG  PRO D 200     101.826 101.089  46.245  1.00 80.63           C  
ATOM   6799  CD  PRO D 200     100.941 100.399  45.252  1.00 80.70           C  
ATOM   6800  N   SER D 201     101.075 104.859  43.662  1.00 78.77           N  
ATOM   6801  CA  SER D 201     101.621 105.855  42.748  1.00 77.43           C  
ATOM   6802  C   SER D 201     102.885 106.478  43.295  1.00 78.14           C  
ATOM   6803  O   SER D 201     103.043 106.684  44.511  1.00 77.78           O  
ATOM   6804  CB  SER D 201     100.512 106.898  42.547  1.00 72.16           C  
ATOM   6805  OG  SER D 201     101.036 108.189  42.457  1.00 75.86           O  
ATOM   6806  N   PRO D 202     103.858 106.783  42.441  1.00 78.57           N  
ATOM   6807  CA  PRO D 202     105.115 107.379  42.884  1.00 78.47           C  
ATOM   6808  C   PRO D 202     104.922 108.753  43.487  1.00 78.44           C  
ATOM   6809  O   PRO D 202     105.649 109.134  44.411  1.00 79.28           O  
ATOM   6810  CB  PRO D 202     105.983 107.398  41.648  1.00 78.14           C  
ATOM   6811  CG  PRO D 202     105.040 107.322  40.500  1.00 78.84           C  
ATOM   6812  CD  PRO D 202     103.850 106.527  40.989  1.00 78.43           C  
ATOM   6813  N   LEU D 203     103.929 109.509  43.020  1.00 77.72           N  
ATOM   6814  CA  LEU D 203     103.669 110.842  43.550  1.00 75.86           C  
ATOM   6815  C   LEU D 203     103.251 110.754  45.020  1.00 75.85           C  
ATOM   6816  O   LEU D 203     103.764 111.466  45.879  1.00 75.48           O  
ATOM   6817  CB  LEU D 203     102.555 111.504  42.738  1.00 74.20           C  
ATOM   6818  CG  LEU D 203     102.701 113.017  42.550  1.00 73.34           C  
ATOM   6819  CD1 LEU D 203     104.005 113.326  41.833  1.00 73.62           C  
ATOM   6820  CD2 LEU D 203     101.506 113.580  41.792  1.00 75.23           C  
ATOM   6821  N   GLU D 204     102.330 109.860  45.272  1.00 74.73           N  
ATOM   6822  CA  GLU D 204     101.726 109.515  46.536  1.00 74.59           C  
ATOM   6823  C   GLU D 204     102.750 109.497  47.673  1.00 75.13           C  
ATOM   6824  O   GLU D 204     102.521 110.022  48.759  1.00 74.45           O  
ATOM   6825  CB  GLU D 204     101.175 108.105  46.360  1.00 72.94           C  
ATOM   6826  CG  GLU D 204     100.106 107.535  47.167  1.00 74.52           C  
ATOM   6827  CD  GLU D 204      99.769 106.087  46.780  1.00 76.04           C  
ATOM   6828  OE1 GLU D 204      99.419 105.835  45.614  1.00 73.35           O  
ATOM   6829  OE2 GLU D 204      99.851 105.239  47.694  1.00 77.15           O  
ATOM   6830  N   HIS D 205     103.855 108.820  47.399  1.00 75.30           N  
ATOM   6831  CA  HIS D 205     104.913 108.581  48.366  1.00 77.10           C  
ATOM   6832  C   HIS D 205     105.783 109.796  48.595  1.00 75.52           C  
ATOM   6833  O   HIS D 205     106.188 110.061  49.731  1.00 75.26           O  
ATOM   6834  CB  HIS D 205     105.712 107.357  47.950  1.00 84.57           C  
ATOM   6835  CG  HIS D 205     106.878 106.974  48.784  1.00 89.95           C  
ATOM   6836  ND1 HIS D 205     108.171 107.295  48.410  1.00 92.59           N  
ATOM   6837  CD2 HIS D 205     106.989 106.277  49.941  1.00 93.01           C  
ATOM   6838  CE1 HIS D 205     109.021 106.823  49.304  1.00 93.46           C  
ATOM   6839  NE2 HIS D 205     108.333 106.205  50.243  1.00 94.82           N  
ATOM   6840  N   ILE D 206     106.037 110.577  47.543  1.00 73.99           N  
ATOM   6841  CA  ILE D 206     106.813 111.788  47.707  1.00 71.89           C  
ATOM   6842  C   ILE D 206     106.077 112.807  48.569  1.00 70.37           C  
ATOM   6843  O   ILE D 206     106.630 113.336  49.521  1.00 71.05           O  
ATOM   6844  CB  ILE D 206     107.136 112.482  46.386  1.00 73.67           C  
ATOM   6845  CG1 ILE D 206     107.719 111.506  45.365  1.00 74.41           C  
ATOM   6846  CG2 ILE D 206     108.072 113.660  46.630  1.00 71.84           C  
ATOM   6847  CD1 ILE D 206     107.694 112.089  43.951  1.00 75.02           C  
ATOM   6848  N   GLU D 207     104.853 113.143  48.174  1.00 69.56           N  
ATOM   6849  CA  GLU D 207     104.112 114.156  48.934  1.00 69.33           C  
ATOM   6850  C   GLU D 207     103.591 113.613  50.255  1.00 69.80           C  
ATOM   6851  O   GLU D 207     103.293 114.357  51.182  1.00 69.40           O  
ATOM   6852  CB  GLU D 207     102.951 114.702  48.101  1.00 64.33           C  
ATOM   6853  CG  GLU D 207     103.337 115.626  46.984  1.00 61.70           C  
ATOM   6854  CD  GLU D 207     103.067 117.089  47.203  1.00 62.08           C  
ATOM   6855  OE1 GLU D 207     103.234 117.883  46.239  1.00 60.17           O  
ATOM   6856  OE2 GLU D 207     102.667 117.482  48.315  1.00 62.49           O  
HETATM 6857  N   MSE D 208     103.420 112.302  50.329  1.00 70.51           N  
HETATM 6858  CA  MSE D 208     102.846 111.654  51.486  1.00 71.96           C  
HETATM 6859  C   MSE D 208     101.370 112.049  51.564  1.00 70.41           C  
HETATM 6860  O   MSE D 208     100.793 112.287  52.605  1.00 71.11           O  
HETATM 6861  CB  MSE D 208     103.617 111.842  52.759  1.00 81.09           C  
HETATM 6862  CG  MSE D 208     104.987 111.165  52.789  1.00 91.49           C  
HETATM 6863 SE   MSE D 208     104.873 109.238  52.597  1.00106.20          SE  
HETATM 6864  CE  MSE D 208     104.235 108.791  54.344  1.00100.15           C  
ATOM   6865  N   LEU D 209     100.764 112.078  50.377  1.00 68.74           N  
ATOM   6866  CA  LEU D 209      99.344 112.336  50.203  1.00 68.15           C  
ATOM   6867  C   LEU D 209      98.771 111.171  49.382  1.00 67.16           C  
ATOM   6868  O   LEU D 209      99.211 110.967  48.257  1.00 69.70           O  
ATOM   6869  CB  LEU D 209      99.039 113.649  49.518  1.00 66.55           C  
ATOM   6870  CG  LEU D 209      99.517 114.938  50.191  1.00 64.73           C  
ATOM   6871  CD1 LEU D 209      99.271 116.130  49.304  1.00 62.16           C  
ATOM   6872  CD2 LEU D 209      98.838 115.107  51.546  1.00 66.07           C  
ATOM   6873  N   GLU D 210      97.864 110.412  49.932  1.00 66.95           N  
ATOM   6874  CA  GLU D 210      97.319 109.234  49.272  1.00 66.75           C  
ATOM   6875  C   GLU D 210      96.236 109.561  48.280  1.00 65.48           C  
ATOM   6876  O   GLU D 210      95.885 108.748  47.412  1.00 66.90           O  
ATOM   6877  CB  GLU D 210      96.817 108.237  50.329  1.00 65.97           C  
ATOM   6878  N   GLN D 211      95.691 110.770  48.331  1.00 63.44           N  
ATOM   6879  CA  GLN D 211      94.643 111.121  47.356  1.00 61.01           C  
ATOM   6880  C   GLN D 211      95.300 111.330  46.004  1.00 59.47           C  
ATOM   6881  O   GLN D 211      94.688 111.167  44.954  1.00 60.01           O  
ATOM   6882  CB  GLN D 211      93.818 112.291  47.852  1.00 58.17           C  
ATOM   6883  CG  GLN D 211      94.603 113.535  48.179  1.00 61.23           C  
ATOM   6884  CD  GLN D 211      95.157 113.591  49.579  1.00 62.11           C  
ATOM   6885  OE1 GLN D 211      95.611 112.610  50.157  1.00 60.71           O  
ATOM   6886  NE2 GLN D 211      95.134 114.799  50.163  1.00 64.33           N  
ATOM   6887  N   LEU D 212      96.622 111.520  45.987  1.00 58.18           N  
ATOM   6888  CA  LEU D 212      97.381 111.649  44.759  1.00 57.51           C  
ATOM   6889  C   LEU D 212      97.310 110.414  43.895  1.00 59.33           C  
ATOM   6890  O   LEU D 212      97.356 110.450  42.645  1.00 60.65           O  
ATOM   6891  CB  LEU D 212      98.785 112.168  45.053  1.00 52.16           C  
ATOM   6892  CG  LEU D 212      98.847 113.653  45.499  1.00 50.40           C  
ATOM   6893  CD1 LEU D 212     100.281 114.162  45.539  1.00 46.42           C  
ATOM   6894  CD2 LEU D 212      97.979 114.523  44.606  1.00 38.83           C  
ATOM   6895  N   ARG D 213      97.015 109.252  44.473  1.00 60.86           N  
ATOM   6896  CA  ARG D 213      96.791 108.026  43.744  1.00 61.25           C  
ATOM   6897  C   ARG D 213      95.596 108.164  42.805  1.00 62.10           C  
ATOM   6898  O   ARG D 213      95.656 107.692  41.658  1.00 63.73           O  
ATOM   6899  CB  ARG D 213      96.567 106.859  44.702  1.00 61.23           C  
ATOM   6900  CG  ARG D 213      96.429 105.528  43.963  1.00 60.35           C  
ATOM   6901  CD  ARG D 213      96.223 104.412  44.942  1.00 63.12           C  
ATOM   6902  NE  ARG D 213      97.184 104.438  46.064  1.00 63.12           N  
ATOM   6903  CZ  ARG D 213      97.120 103.464  46.988  1.00 63.41           C  
ATOM   6904  NH1 ARG D 213      96.195 102.518  46.856  1.00 64.26           N  
ATOM   6905  NH2 ARG D 213      97.959 103.425  47.995  1.00 63.33           N  
ATOM   6906  N   VAL D 214      94.515 108.815  43.222  1.00 60.37           N  
ATOM   6907  CA  VAL D 214      93.372 108.982  42.313  1.00 60.40           C  
ATOM   6908  C   VAL D 214      93.726 109.838  41.101  1.00 61.29           C  
ATOM   6909  O   VAL D 214      93.354 109.521  39.963  1.00 58.58           O  
ATOM   6910  CB  VAL D 214      92.152 109.565  43.052  1.00 57.10           C  
ATOM   6911  CG1 VAL D 214      91.169 110.228  42.106  1.00 56.49           C  
ATOM   6912  CG2 VAL D 214      91.431 108.453  43.806  1.00 57.53           C  
ATOM   6913  N   LEU D 215      94.398 110.974  41.354  1.00 61.71           N  
ATOM   6914  CA  LEU D 215      94.780 111.888  40.277  1.00 61.97           C  
ATOM   6915  C   LEU D 215      95.769 111.226  39.334  1.00 60.78           C  
ATOM   6916  O   LEU D 215      95.643 111.209  38.125  1.00 58.46           O  
ATOM   6917  CB  LEU D 215      95.352 113.199  40.855  1.00 63.82           C  
ATOM   6918  CG  LEU D 215      94.384 114.042  41.702  1.00 64.66           C  
ATOM   6919  CD1 LEU D 215      95.015 115.311  42.256  1.00 60.95           C  
ATOM   6920  CD2 LEU D 215      93.167 114.420  40.857  1.00 65.20           C  
ATOM   6921  N   TRP D 216      96.752 110.513  39.892  1.00 61.93           N  
ATOM   6922  CA  TRP D 216      97.750 109.849  39.062  1.00 62.44           C  
ATOM   6923  C   TRP D 216      97.155 108.826  38.123  1.00 62.73           C  
ATOM   6924  O   TRP D 216      97.637 108.660  36.983  1.00 63.11           O  
ATOM   6925  CB  TRP D 216      98.812 109.249  39.962  1.00 64.46           C  
ATOM   6926  CG  TRP D 216     100.088 108.898  39.264  1.00 65.33           C  
ATOM   6927  CD1 TRP D 216     101.051 109.734  38.776  1.00 62.62           C  
ATOM   6928  CD2 TRP D 216     100.539 107.559  39.015  1.00 66.52           C  
ATOM   6929  NE1 TRP D 216     102.063 109.004  38.208  1.00 65.65           N  
ATOM   6930  CE2 TRP D 216     101.776 107.659  38.346  1.00 67.35           C  
ATOM   6931  CE3 TRP D 216     100.001 106.301  39.276  1.00 68.16           C  
ATOM   6932  CZ2 TRP D 216     102.487 106.538  37.952  1.00 66.06           C  
ATOM   6933  CZ3 TRP D 216     100.717 105.179  38.883  1.00 70.40           C  
ATOM   6934  CH2 TRP D 216     101.942 105.312  38.220  1.00 69.54           C  
ATOM   6935  N   TYR D 217      96.112 108.115  38.514  1.00 61.89           N  
ATOM   6936  CA  TYR D 217      95.492 107.119  37.661  1.00 62.15           C  
ATOM   6937  C   TYR D 217      94.467 107.676  36.701  1.00 62.37           C  
ATOM   6938  O   TYR D 217      93.743 106.922  36.046  1.00 62.53           O  
ATOM   6939  CB  TYR D 217      94.848 106.020  38.518  1.00 63.33           C  
ATOM   6940  CG  TYR D 217      95.851 104.983  38.972  1.00 65.26           C  
ATOM   6941  CD1 TYR D 217      96.449 105.053  40.205  1.00 66.03           C  
ATOM   6942  CD2 TYR D 217      96.221 103.944  38.123  1.00 67.99           C  
ATOM   6943  CE1 TYR D 217      97.386 104.124  40.609  1.00 67.75           C  
ATOM   6944  CE2 TYR D 217      97.144 102.991  38.518  1.00 69.10           C  
ATOM   6945  CZ  TYR D 217      97.723 103.086  39.767  1.00 68.47           C  
ATOM   6946  OH  TYR D 217      98.625 102.140  40.175  1.00 67.93           O  
ATOM   6947  N   GLY D 218      94.305 108.987  36.615  1.00 62.13           N  
ATOM   6948  CA  GLY D 218      93.380 109.607  35.714  1.00 62.14           C  
ATOM   6949  C   GLY D 218      91.982 109.750  36.234  1.00 62.65           C  
ATOM   6950  O   GLY D 218      91.036 110.066  35.501  1.00 63.12           O  
ATOM   6951  N   GLU D 219      91.794 109.540  37.527  1.00 64.37           N  
ATOM   6952  CA  GLU D 219      90.410 109.687  38.057  1.00 65.32           C  
ATOM   6953  C   GLU D 219      90.280 111.077  38.655  1.00 64.64           C  
ATOM   6954  O   GLU D 219      91.300 111.759  38.816  1.00 65.66           O  
ATOM   6955  CB  GLU D 219      90.140 108.574  39.047  1.00 66.40           C  
ATOM   6956  CG  GLU D 219      90.211 107.193  38.449  1.00 68.65           C  
ATOM   6957  CD  GLU D 219      88.891 106.675  37.922  1.00 73.03           C  
ATOM   6958  OE1 GLU D 219      88.885 105.500  37.456  1.00 77.42           O  
ATOM   6959  OE2 GLU D 219      87.867 107.377  37.975  1.00 72.13           O  
ATOM   6960  N   LYS D 220      89.083 111.517  38.955  1.00 63.65           N  
ATOM   6961  CA  LYS D 220      88.833 112.824  39.497  1.00 62.90           C  
ATOM   6962  C   LYS D 220      88.480 112.850  40.970  1.00 62.56           C  
ATOM   6963  O   LYS D 220      87.868 111.919  41.488  1.00 65.34           O  
ATOM   6964  CB  LYS D 220      87.640 113.473  38.751  1.00 61.14           C  
ATOM   6965  CG  LYS D 220      87.900 113.631  37.286  1.00 66.36           C  
ATOM   6966  CD  LYS D 220      87.084 114.766  36.681  1.00 69.66           C  
ATOM   6967  CE  LYS D 220      87.824 115.298  35.449  1.00 73.49           C  
ATOM   6968  NZ  LYS D 220      86.829 115.885  34.496  1.00 80.58           N  
ATOM   6969  N   ILE D 221      88.775 113.955  41.644  1.00 61.11           N  
ATOM   6970  CA  ILE D 221      88.400 114.173  43.012  1.00 58.33           C  
ATOM   6971  C   ILE D 221      87.635 115.502  43.111  1.00 57.44           C  
ATOM   6972  O   ILE D 221      88.241 116.567  42.943  1.00 56.81           O  
ATOM   6973  CB  ILE D 221      89.533 114.200  44.038  1.00 57.95           C  
ATOM   6974  CG1 ILE D 221      90.274 112.867  44.106  1.00 57.06           C  
ATOM   6975  CG2 ILE D 221      88.921 114.541  45.417  1.00 54.37           C  
ATOM   6976  CD1 ILE D 221      91.431 112.819  45.096  1.00 52.53           C  
ATOM   6977  N   HIS D 222      86.332 115.407  43.359  1.00 55.86           N  
ATOM   6978  CA  HIS D 222      85.554 116.646  43.475  1.00 54.28           C  
ATOM   6979  C   HIS D 222      85.834 117.278  44.840  1.00 55.57           C  
ATOM   6980  O   HIS D 222      86.023 116.543  45.826  1.00 57.53           O  
ATOM   6981  CB  HIS D 222      84.063 116.432  43.317  1.00 46.66           C  
ATOM   6982  CG  HIS D 222      83.312 117.717  43.504  1.00 51.90           C  
ATOM   6983  ND1 HIS D 222      83.312 118.711  42.524  1.00 52.89           N  
ATOM   6984  CD2 HIS D 222      82.598 118.202  44.541  1.00 49.19           C  
ATOM   6985  CE1 HIS D 222      82.610 119.733  42.961  1.00 49.33           C  
ATOM   6986  NE2 HIS D 222      82.162 119.452  44.167  1.00 49.13           N  
ATOM   6987  N   VAL D 223      85.960 118.591  44.873  1.00 54.12           N  
ATOM   6988  CA  VAL D 223      86.263 119.316  46.084  1.00 54.00           C  
ATOM   6989  C   VAL D 223      85.293 120.483  46.229  1.00 55.79           C  
ATOM   6990  O   VAL D 223      85.079 121.192  45.243  1.00 56.60           O  
ATOM   6991  CB  VAL D 223      87.683 119.930  46.076  1.00 53.91           C  
ATOM   6992  CG1 VAL D 223      87.934 120.630  47.410  1.00 49.79           C  
ATOM   6993  CG2 VAL D 223      88.788 118.924  45.774  1.00 47.44           C  
ATOM   6994  N   ALA D 224      84.683 120.666  47.391  1.00 56.78           N  
ATOM   6995  CA  ALA D 224      83.818 121.846  47.554  1.00 56.50           C  
ATOM   6996  C   ALA D 224      84.225 122.554  48.847  1.00 57.56           C  
ATOM   6997  O   ALA D 224      84.930 121.963  49.670  1.00 58.04           O  
ATOM   6998  CB  ALA D 224      82.367 121.549  47.502  1.00 50.92           C  
ATOM   6999  N   VAL D 225      83.860 123.817  48.940  1.00 58.56           N  
ATOM   7000  CA  VAL D 225      84.225 124.570  50.162  1.00 59.88           C  
ATOM   7001  C   VAL D 225      83.325 124.036  51.257  1.00 62.32           C  
ATOM   7002  O   VAL D 225      82.104 124.006  51.072  1.00 62.20           O  
ATOM   7003  CB  VAL D 225      84.035 126.073  49.933  1.00 56.19           C  
ATOM   7004  CG1 VAL D 225      83.975 126.829  51.248  1.00 54.91           C  
ATOM   7005  CG2 VAL D 225      85.182 126.588  49.060  1.00 48.59           C  
ATOM   7006  N   ALA D 226      83.912 123.507  52.327  1.00 64.88           N  
ATOM   7007  CA  ALA D 226      83.032 122.927  53.365  1.00 66.53           C  
ATOM   7008  C   ALA D 226      82.011 123.980  53.776  1.00 68.03           C  
ATOM   7009  O   ALA D 226      82.297 125.164  53.896  1.00 68.74           O  
ATOM   7010  CB  ALA D 226      83.789 122.347  54.510  1.00 63.92           C  
ATOM   7011  N   GLN D 227      80.785 123.518  53.976  1.00 69.66           N  
ATOM   7012  CA  GLN D 227      79.668 124.356  54.366  1.00 70.42           C  
ATOM   7013  C   GLN D 227      79.827 124.855  55.795  1.00 70.19           C  
ATOM   7014  O   GLN D 227      79.119 125.771  56.201  1.00 70.00           O  
ATOM   7015  CB  GLN D 227      78.353 123.625  54.178  1.00 73.85           C  
ATOM   7016  CG  GLN D 227      77.138 124.327  54.753  1.00 77.92           C  
ATOM   7017  CD  GLN D 227      75.901 123.454  54.594  1.00 81.03           C  
ATOM   7018  OE1 GLN D 227      75.796 122.735  53.597  1.00 81.89           O  
ATOM   7019  NE2 GLN D 227      75.004 123.530  55.558  1.00 82.78           N  
ATOM   7020  N   GLU D 228      80.733 124.248  56.546  1.00 69.86           N  
ATOM   7021  CA  GLU D 228      81.012 124.686  57.908  1.00 71.08           C  
ATOM   7022  C   GLU D 228      82.447 124.326  58.256  1.00 70.85           C  
ATOM   7023  O   GLU D 228      82.928 123.262  57.877  1.00 69.79           O  
ATOM   7024  CB  GLU D 228      80.037 124.043  58.879  1.00 74.68           C  
ATOM   7025  CG  GLU D 228      79.501 124.978  59.949  1.00 81.31           C  
ATOM   7026  CD  GLU D 228      78.531 124.268  60.879  1.00 85.30           C  
ATOM   7027  OE1 GLU D 228      78.803 124.191  62.097  1.00 86.84           O  
ATOM   7028  OE2 GLU D 228      77.501 123.767  60.371  1.00 86.22           O  
ATOM   7029  N   VAL D 229      83.162 125.199  58.960  1.00 71.61           N  
ATOM   7030  CA  VAL D 229      84.550 124.849  59.286  1.00 72.57           C  
ATOM   7031  C   VAL D 229      84.620 123.928  60.492  1.00 74.13           C  
ATOM   7032  O   VAL D 229      84.209 124.255  61.600  1.00 73.96           O  
ATOM   7033  CB  VAL D 229      85.472 126.054  59.413  1.00 68.91           C  
ATOM   7034  CG1 VAL D 229      86.900 125.599  59.730  1.00 66.55           C  
ATOM   7035  CG2 VAL D 229      85.466 126.851  58.112  1.00 66.49           C  
ATOM   7036  N   PRO D 230      85.152 122.728  60.258  1.00 74.90           N  
ATOM   7037  CA  PRO D 230      85.252 121.711  61.260  1.00 76.35           C  
ATOM   7038  C   PRO D 230      86.299 121.947  62.323  1.00 78.02           C  
ATOM   7039  O   PRO D 230      87.445 122.271  62.033  1.00 79.58           O  
ATOM   7040  CB  PRO D 230      85.576 120.441  60.487  1.00 76.04           C  
ATOM   7041  CG  PRO D 230      85.782 120.807  59.077  1.00 75.22           C  
ATOM   7042  CD  PRO D 230      85.641 122.279  58.934  1.00 74.69           C  
ATOM   7043  N   GLY D 231      85.920 121.682  63.570  1.00 79.94           N  
ATOM   7044  CA  GLY D 231      86.898 121.756  64.673  1.00 81.41           C  
ATOM   7045  C   GLY D 231      87.846 120.559  64.469  1.00 82.43           C  
ATOM   7046  O   GLY D 231      87.421 119.550  63.920  1.00 82.72           O  
ATOM   7047  N   THR D 232      89.103 120.703  64.838  1.00 84.26           N  
ATOM   7048  CA  THR D 232      90.071 119.649  64.638  1.00 85.95           C  
ATOM   7049  C   THR D 232      89.864 118.475  65.579  1.00 86.84           C  
ATOM   7050  O   THR D 232      89.186 118.556  66.588  1.00 85.49           O  
ATOM   7051  CB  THR D 232      91.521 120.129  64.616  1.00 86.01           C  
ATOM   7052  OG1 THR D 232      91.966 120.630  65.870  1.00 84.72           O  
ATOM   7053  CG2 THR D 232      91.674 121.228  63.561  1.00 85.75           C  
ATOM   7054  N   GLY D 233      90.398 117.330  65.155  1.00 88.97           N  
ATOM   7055  CA  GLY D 233      90.296 116.079  65.844  1.00 91.82           C  
ATOM   7056  C   GLY D 233      90.791 116.086  67.273  1.00 93.30           C  
ATOM   7057  O   GLY D 233      91.160 117.117  67.839  1.00 94.43           O  
ATOM   7058  N   VAL D 234      90.766 114.911  67.897  1.00 93.81           N  
ATOM   7059  CA  VAL D 234      91.173 114.733  69.266  1.00 95.35           C  
ATOM   7060  C   VAL D 234      92.184 113.593  69.405  1.00 97.05           C  
ATOM   7061  O   VAL D 234      91.811 112.421  69.344  1.00 97.17           O  
ATOM   7062  CB  VAL D 234      89.992 114.408  70.213  1.00 93.93           C  
ATOM   7063  CG1 VAL D 234      90.521 114.259  71.641  1.00 93.20           C  
ATOM   7064  CG2 VAL D 234      88.895 115.438  70.163  1.00 91.51           C  
ATOM   7065  N   ASP D 235      93.439 113.933  69.620  1.00 99.01           N  
ATOM   7066  CA  ASP D 235      94.464 112.912  69.843  1.00102.21           C  
ATOM   7067  C   ASP D 235      95.330 113.379  71.014  1.00103.64           C  
ATOM   7068  O   ASP D 235      95.992 112.599  71.676  1.00104.47           O  
ATOM   7069  CB  ASP D 235      95.282 112.590  68.629  1.00104.73           C  
ATOM   7070  CG  ASP D 235      95.789 113.774  67.839  1.00107.09           C  
ATOM   7071  OD1 ASP D 235      96.355 113.545  66.737  1.00107.16           O  
ATOM   7072  OD2 ASP D 235      95.636 114.927  68.297  1.00107.01           O  
ATOM   7073  N   THR D 236      95.188 114.677  71.308  1.00104.99           N  
ATOM   7074  CA  THR D 236      95.951 115.231  72.429  1.00105.76           C  
ATOM   7075  C   THR D 236      95.088 115.345  73.662  1.00106.13           C  
ATOM   7076  O   THR D 236      93.934 115.774  73.608  1.00106.69           O  
ATOM   7077  CB  THR D 236      96.629 116.547  72.065  1.00106.89           C  
ATOM   7078  OG1 THR D 236      98.021 116.462  72.476  1.00109.67           O  
ATOM   7079  CG2 THR D 236      96.071 117.767  72.740  1.00106.30           C  
ATOM   7080  N   PRO D 237      95.678 115.064  74.818  1.00106.20           N  
ATOM   7081  CA  PRO D 237      95.017 115.194  76.105  1.00105.85           C  
ATOM   7082  C   PRO D 237      94.521 116.620  76.305  1.00105.89           C  
ATOM   7083  O   PRO D 237      93.522 116.865  76.984  1.00105.87           O  
ATOM   7084  CB  PRO D 237      96.083 114.822  77.114  1.00105.91           C  
ATOM   7085  CG  PRO D 237      97.380 114.991  76.395  1.00106.01           C  
ATOM   7086  CD  PRO D 237      97.079 114.598  74.969  1.00106.30           C  
ATOM   7087  N   GLU D 238      95.234 117.582  75.720  1.00105.77           N  
ATOM   7088  CA  GLU D 238      94.846 118.977  75.757  1.00106.00           C  
ATOM   7089  C   GLU D 238      93.619 119.210  74.856  1.00105.01           C  
ATOM   7090  O   GLU D 238      92.746 119.999  75.196  1.00104.74           O  
ATOM   7091  CB  GLU D 238      95.975 119.896  75.313  1.00109.45           C  
ATOM   7092  CG  GLU D 238      97.230 119.857  76.157  1.00113.80           C  
ATOM   7093  CD  GLU D 238      98.012 121.162  76.086  1.00116.20           C  
ATOM   7094  OE1 GLU D 238      98.509 121.491  74.986  1.00117.35           O  
ATOM   7095  OE2 GLU D 238      98.101 121.843  77.134  1.00116.93           O  
ATOM   7096  N   ASP D 239      93.592 118.506  73.733  1.00103.65           N  
ATOM   7097  CA  ASP D 239      92.542 118.539  72.735  1.00102.10           C  
ATOM   7098  C   ASP D 239      91.253 117.953  73.352  1.00100.94           C  
ATOM   7099  O   ASP D 239      90.148 118.412  73.107  1.00100.47           O  
ATOM   7100  CB  ASP D 239      92.887 117.728  71.500  1.00102.59           C  
ATOM   7101  CG  ASP D 239      93.809 118.341  70.492  1.00104.33           C  
ATOM   7102  OD1 ASP D 239      93.999 119.578  70.475  1.00105.67           O  
ATOM   7103  OD2 ASP D 239      94.398 117.585  69.670  1.00104.10           O  
ATOM   7104  N   LEU D 240      91.465 116.920  74.164  1.00 98.87           N  
ATOM   7105  CA  LEU D 240      90.393 116.265  74.874  1.00 97.31           C  
ATOM   7106  C   LEU D 240      89.722 117.191  75.880  1.00 97.10           C  
ATOM   7107  O   LEU D 240      88.493 117.322  75.885  1.00 96.71           O  
ATOM   7108  CB  LEU D 240      90.889 114.989  75.569  1.00 94.53           C  
ATOM   7109  CG  LEU D 240      89.773 114.209  76.288  1.00 93.19           C  
ATOM   7110  CD1 LEU D 240      88.725 113.797  75.271  1.00 90.96           C  
ATOM   7111  CD2 LEU D 240      90.328 113.019  77.033  1.00 93.64           C  
ATOM   7112  N   GLU D 241      90.508 117.905  76.693  1.00 96.55           N  
ATOM   7113  CA  GLU D 241      89.919 118.851  77.637  1.00 95.57           C  
ATOM   7114  C   GLU D 241      89.204 119.991  76.926  1.00 94.21           C  
ATOM   7115  O   GLU D 241      88.126 120.425  77.337  1.00 93.63           O  
ATOM   7116  CB  GLU D 241      90.958 119.384  78.619  1.00 98.31           C  
ATOM   7117  CG  GLU D 241      90.944 118.650  79.957  1.00101.93           C  
ATOM   7118  CD  GLU D 241      89.575 118.623  80.610  1.00103.25           C  
ATOM   7119  OE1 GLU D 241      89.322 117.667  81.378  1.00104.54           O  
ATOM   7120  OE2 GLU D 241      88.744 119.527  80.365  1.00103.45           O  
ATOM   7121  N   ARG D 242      89.798 120.475  75.850  1.00 93.41           N  
ATOM   7122  CA  ARG D 242      89.222 121.549  75.035  1.00 93.34           C  
ATOM   7123  C   ARG D 242      87.808 121.171  74.605  1.00 92.46           C  
ATOM   7124  O   ARG D 242      86.817 121.775  75.002  1.00 91.77           O  
ATOM   7125  CB  ARG D 242      90.136 121.762  73.827  1.00 95.99           C  
ATOM   7126  CG  ARG D 242      89.756 122.851  72.860  1.00 98.36           C  
ATOM   7127  CD  ARG D 242      90.928 123.241  71.953  1.00100.21           C  
ATOM   7128  NE  ARG D 242      92.050 123.745  72.724  1.00102.43           N  
ATOM   7129  CZ  ARG D 242      93.248 124.109  72.319  1.00103.32           C  
ATOM   7130  NH1 ARG D 242      93.632 124.066  71.049  1.00103.91           N  
ATOM   7131  NH2 ARG D 242      94.138 124.546  73.216  1.00103.53           N  
ATOM   7132  N   VAL D 243      87.722 120.078  73.859  1.00 92.08           N  
ATOM   7133  CA  VAL D 243      86.470 119.509  73.370  1.00 91.73           C  
ATOM   7134  C   VAL D 243      85.506 119.281  74.523  1.00 91.21           C  
ATOM   7135  O   VAL D 243      84.338 119.637  74.456  1.00 89.97           O  
ATOM   7136  CB  VAL D 243      86.758 118.194  72.621  1.00 91.42           C  
ATOM   7137  CG1 VAL D 243      85.544 117.309  72.501  1.00 90.62           C  
ATOM   7138  CG2 VAL D 243      87.333 118.526  71.235  1.00 89.25           C  
ATOM   7139  N   ARG D 244      86.039 118.743  75.617  1.00 91.63           N  
ATOM   7140  CA  ARG D 244      85.268 118.571  76.838  1.00 93.35           C  
ATOM   7141  C   ARG D 244      84.632 119.914  77.224  1.00 94.89           C  
ATOM   7142  O   ARG D 244      83.455 119.950  77.592  1.00 95.65           O  
ATOM   7143  CB  ARG D 244      86.155 118.072  77.966  1.00 92.30           C  
ATOM   7144  CG  ARG D 244      86.565 116.619  77.912  1.00 92.41           C  
ATOM   7145  CD  ARG D 244      85.892 115.789  78.956  1.00 92.64           C  
ATOM   7146  NE  ARG D 244      86.400 114.487  79.222  1.00 91.24           N  
ATOM   7147  CZ  ARG D 244      87.557 114.059  79.666  1.00 89.91           C  
ATOM   7148  NH1 ARG D 244      88.551 114.886  79.952  1.00 89.86           N  
ATOM   7149  NH2 ARG D 244      87.746 112.747  79.867  1.00 88.87           N  
ATOM   7150  N   ALA D 245      85.390 121.001  77.130  1.00 95.66           N  
ATOM   7151  CA  ALA D 245      84.886 122.322  77.460  1.00 97.35           C  
ATOM   7152  C   ALA D 245      83.888 122.867  76.452  1.00 98.33           C  
ATOM   7153  O   ALA D 245      82.871 123.451  76.856  1.00 97.75           O  
ATOM   7154  CB  ALA D 245      86.041 123.295  77.666  1.00 95.69           C  
ATOM   7155  N   GLU D 246      84.098 122.668  75.159  1.00 99.77           N  
ATOM   7156  CA  GLU D 246      83.220 123.162  74.118  1.00101.81           C  
ATOM   7157  C   GLU D 246      81.839 122.517  74.096  1.00102.90           C  
ATOM   7158  O   GLU D 246      80.918 123.066  73.475  1.00102.88           O  
ATOM   7159  CB  GLU D 246      83.846 122.966  72.728  1.00101.33           C  
ATOM   7160  CG  GLU D 246      85.239 123.513  72.573  1.00101.15           C  
HETATM 7161  N   MSE D 247      81.714 121.324  74.649  1.00104.30           N  
HETATM 7162  CA  MSE D 247      80.436 120.618  74.681  1.00105.86           C  
HETATM 7163  C   MSE D 247      79.800 120.715  76.054  1.00106.02           C  
HETATM 7164  O   MSE D 247      80.164 121.580  76.867  1.00106.45           O  
HETATM 7165  CB  MSE D 247      80.629 119.162  74.219  1.00108.88           C  
HETATM 7166  CG  MSE D 247      81.130 119.053  72.792  1.00113.53           C  
HETATM 7167 SE   MSE D 247      81.646 117.312  72.184  1.00120.12          SE  
HETATM 7168  CE  MSE D 247      79.979 116.599  71.645  1.00116.28           C  
TER    7169      MSE D 247                                                      
END
MOLECULE T0420.pdb
ATOM      1  N   MET     1      71.619 109.167  47.132  1.00 90.29           N  
ATOM      2  CA  MET     1      71.053 107.807  46.878  1.00 90.45           C  
ATOM      3  C   MET     1      71.689 106.761  47.790  1.00 88.28           C  
ATOM      4  O   MET     1      71.664 106.906  49.016  1.00 88.91           O  
ATOM      5  CB  MET     1      71.260 107.411  45.415  1.00 91.73           C  
ATOM      6  CG  MET     1      71.941 108.488  44.584  1.00 97.36           C  
ATOM      7  SD  MET     1      73.841 108.693  44.978  1.00 99.73          SE  
ATOM      8  CE  MET     1      74.536 108.305  43.197  1.00 99.73           C  
ATOM      9  N   ASN     2      72.267 105.716  47.201  1.00 85.03           N  
ATOM     10  CA  ASN     2      72.888 104.659  47.995  1.00 81.84           C  
ATOM     11  C   ASN     2      74.252 104.994  48.583  1.00 79.10           C  
ATOM     12  O   ASN     2      75.284 104.814  47.940  1.00 78.70           O  
ATOM     13  CB  ASN     2      72.987 103.382  47.174  1.00 82.29           C  
ATOM     14  CG  ASN     2      71.873 102.422  47.485  1.00 83.43           C  
ATOM     15  OD1 ASN     2      70.725 102.827  47.659  1.00 85.52           O  
ATOM     16  ND2 ASN     2      72.199 101.137  47.553  1.00 86.02           N  
ATOM     17  N   ILE     3      74.248 105.472  49.821  1.00 75.30           N  
ATOM     18  CA  ILE     3      75.487 105.816  50.485  1.00 72.19           C  
ATOM     19  C   ILE     3      75.638 105.118  51.830  1.00 69.90           C  
ATOM     20  O   ILE     3      74.729 105.111  52.659  1.00 69.85           O  
ATOM     21  CB  ILE     3      75.600 107.327  50.711  1.00 72.15           C  
ATOM     22  CG1 ILE     3      75.446 108.067  49.383  1.00 72.99           C  
ATOM     23  CG2 ILE     3      76.953 107.658  51.291  1.00 70.73           C  
ATOM     24  CD1 ILE     3      75.531 109.580  49.521  1.00 74.41           C  
ATOM     25  N   GLY     4      76.799 104.515  52.034  1.00 66.94           N  
ATOM     26  CA  GLY     4      77.060 103.854  53.291  1.00 62.89           C  
ATOM     27  C   GLY     4      78.166 104.579  54.036  1.00 59.88           C  
ATOM     28  O   GLY     4      79.154 105.010  53.446  1.00 59.44           O  
ATOM     29  N   VAL     5      77.993 104.742  55.338  1.00 57.63           N  
ATOM     30  CA  VAL     5      79.015 105.385  56.139  1.00 55.30           C  
ATOM     31  C   VAL     5      79.820 104.305  56.867  1.00 54.83           C  
ATOM     32  O   VAL     5      79.258 103.415  57.519  1.00 55.29           O  
ATOM     33  CB  VAL     5      78.407 106.331  57.182  1.00 55.28           C  
ATOM     34  CG1 VAL     5      79.501 107.107  57.868  1.00 52.77           C  
ATOM     35  CG2 VAL     5      77.436 107.269  56.520  1.00 54.18           C  
ATOM     36  N   ILE     6      81.137 104.363  56.711  1.00 52.33           N  
ATOM     37  CA  ILE     6      82.026 103.430  57.382  1.00 49.91           C  
ATOM     38  C   ILE     6      82.772 104.247  58.432  1.00 49.12           C  
ATOM     39  O   ILE     6      83.618 105.076  58.104  1.00 48.62           O  
ATOM     40  CB  ILE     6      83.073 102.802  56.424  1.00 49.52           C  
ATOM     41  CG1 ILE     6      82.382 101.948  55.361  1.00 48.68           C  
ATOM     42  CG2 ILE     6      84.049 101.945  57.211  1.00 48.22           C  
ATOM     43  CD1 ILE     6      83.341 101.418  54.286  1.00 45.37           C  
ATOM     44  N   ILE     7      82.437 104.024  59.694  1.00 48.36           N  
ATOM     45  CA  ILE     7      83.100 104.722  60.774  1.00 47.98           C  
ATOM     46  C   ILE     7      84.274 103.877  61.245  1.00 48.52           C  
ATOM     47  O   ILE     7      84.083 102.855  61.902  1.00 49.70           O  
ATOM     48  CB  ILE     7      82.152 104.964  61.956  1.00 47.36           C  
ATOM     49  CG1 ILE     7      80.950 105.785  61.483  1.00 45.91           C  
ATOM     50  CG2 ILE     7      82.897 105.675  63.069  1.00 45.97           C  
ATOM     51  CD1 ILE     7      79.957 106.127  62.563  1.00 45.22           C  
ATOM     52  N   LEU     8      85.483 104.303  60.877  1.00 49.06           N  
ATOM     53  CA  LEU     8      86.714 103.622  61.268  1.00 49.60           C  
ATOM     54  C   LEU     8      87.006 104.013  62.709  1.00 50.81           C  
ATOM     55  O   LEU     8      87.061 105.197  63.029  1.00 51.50           O  
ATOM     56  CB  LEU     8      87.873 104.067  60.382  1.00 48.30           C  
ATOM     57  CG  LEU     8      87.724 103.786  58.888  1.00 46.60           C  
ATOM     58  CD1 LEU     8      88.961 104.291  58.149  1.00 42.20           C  
ATOM     59  CD2 LEU     8      87.531 102.280  58.665  1.00 43.49           C  
ATOM     60  N   ALA     9      87.171 103.020  63.575  1.00 52.52           N  
ATOM     61  CA  ALA     9      87.443 103.268  64.982  1.00 53.82           C  
ATOM     62  C   ALA     9      88.307 102.171  65.556  1.00 55.51           C  
ATOM     63  O   ALA     9      88.312 101.961  66.758  1.00 56.08           O  
ATOM     64  CB  ALA     9      86.139 103.372  65.772  1.00 52.59           C  
ATOM     65  N   ALA    10      89.020 101.455  64.693  1.00 59.12           N  
ATOM     66  CA  ALA    10      89.924 100.405  65.149  1.00 63.15           C  
ATOM     67  C   ALA    10      91.195 101.151  65.561  1.00 66.75           C  
ATOM     68  O   ALA    10      91.294 102.364  65.350  1.00 68.61           O  
ATOM     69  CB  ALA    10      90.206  99.433  64.026  1.00 62.44           C  
ATOM     70  N   GLY    11      92.175 100.469  66.134  1.00 70.21           N  
ATOM     71  CA  GLY    11      93.361 101.205  66.554  1.00 75.15           C  
ATOM     72  C   GLY    11      94.613 101.061  65.711  1.00 78.33           C  
ATOM     73  O   GLY    11      95.722 101.227  66.230  1.00 78.74           O  
ATOM     74  N   GLU    12      94.437 100.767  64.422  1.00 81.19           N  
ATOM     75  CA  GLU    12      95.550 100.577  63.494  1.00 83.59           C  
ATOM     76  C   GLU    12      96.612 101.665  63.553  1.00 85.71           C  
ATOM     77  O   GLU    12      96.314 102.831  63.835  1.00 85.98           O  
ATOM     78  CB  GLU    12      95.034 100.456  62.063  1.00 83.44           C  
ATOM     79  CG  GLU    12      94.041 101.527  61.667  1.00 82.74           C  
ATOM     80  CD  GLU    12      92.617 101.052  61.810  1.00 83.09           C  
ATOM     81  OE1 GLU    12      92.365  99.880  61.447  1.00 79.28           O  
ATOM     82  OE2 GLU    12      91.759 101.846  62.268  1.00 83.42           O  
ATOM     83  N   GLY    13      97.853 101.269  63.266  1.00 87.93           N  
ATOM     84  CA  GLY    13      98.965 102.201  63.319  1.00 90.43           C  
ATOM     85  C   GLY    13      99.062 102.724  64.740  1.00 92.14           C  
ATOM     86  O   GLY    13      98.707 102.020  65.697  1.00 91.86           O  
ATOM     87  N   LYS    14      99.551 103.951  64.888  1.00 93.73           N  
ATOM     88  CA  LYS    14      99.652 104.561  66.210  1.00 94.77           C  
ATOM     89  C   LYS    14      98.423 105.454  66.350  1.00 95.25           C  
ATOM     90  O   LYS    14      98.420 106.428  67.102  1.00 95.26           O  
ATOM     91  CB  LYS    14     100.936 105.384  66.328  1.00 94.77           C  
ATOM     92  N   ARG    15      97.380 105.105  65.601  1.00 95.97           N  
ATOM     93  CA  ARG    15      96.131 105.855  65.620  1.00 96.80           C  
ATOM     94  C   ARG    15      95.378 105.615  66.920  1.00 97.12           C  
ATOM     95  O   ARG    15      95.823 104.844  67.772  1.00 97.51           O  
ATOM     96  CB  ARG    15      95.254 105.445  64.439  1.00 96.58           C  
ATOM     97  CG  ARG    15      95.877 105.710  63.079  1.00 96.59           C  
ATOM     98  CD  ARG    15      94.898 105.384  61.960  1.00 96.12           C  
ATOM     99  NE  ARG    15      95.475 105.569  60.630  1.00 96.03           N  
ATOM    100  CZ  ARG    15      96.458 104.827  60.126  1.00 96.46           C  
ATOM    101  NH1 ARG    15      96.984 103.835  60.838  1.00 95.19           N  
ATOM    102  NH2 ARG    15      96.918 105.081  58.907  1.00 96.89           N  
ATOM    103  N   PHE    16      94.240 106.283  67.074  1.00 97.18           N  
ATOM    104  CA  PHE    16      93.436 106.119  68.275  1.00 97.49           C  
ATOM    105  C   PHE    16      92.698 104.794  68.262  1.00 97.80           C  
ATOM    106  O   PHE    16      92.768 104.042  67.287  1.00 98.44           O  
ATOM    107  CB  PHE    16      92.419 107.249  68.401  1.00 97.55           C  
ATOM    108  CG  PHE    16      92.908 108.410  69.205  1.00 98.14           C  
ATOM    109  CD1 PHE    16      92.008 109.219  69.890  1.00 98.54           C  
ATOM    110  CD2 PHE    16      94.269 108.692  69.288  1.00 98.99           C  
ATOM    111  CE1 PHE    16      92.454 110.286  70.657  1.00 99.73           C  
ATOM    112  CE2 PHE    16      94.730 109.756  70.052  1.00 99.73           C  
ATOM    113  CZ  PHE    16      93.821 110.559  70.737  1.00 99.73           C  
ATOM    114  N   GLY    17      91.990 104.498  69.346  1.00 97.56           N  
ATOM    115  CA  GLY    17      91.244 103.256  69.372  1.00 97.36           C  
ATOM    116  C   GLY    17      90.894 102.662  70.721  1.00 97.21           C  
ATOM    117  O   GLY    17      91.776 102.255  71.471  1.00 97.85           O  
ATOM    118  N   GLY    18      89.597 102.608  71.018  1.00 96.53           N  
ATOM    119  CA  GLY    18      89.120 102.023  72.260  1.00 94.80           C  
ATOM    120  C   GLY    18      89.396 102.785  73.541  1.00 93.58           C  
ATOM    121  O   GLY    18      88.477 103.303  74.183  1.00 93.59           O  
ATOM    122  N   ASP    19      90.660 102.835  73.938  1.00 91.98           N  
ATOM    123  CA  ASP    19      91.011 103.550  75.145  1.00 90.00           C  
ATOM    124  C   ASP    19      90.709 105.034  74.941  1.00 87.78           C  
ATOM    125  O   ASP    19      89.786 105.568  75.553  1.00 87.48           O  
ATOM    126  CB  ASP    19      92.493 103.309  75.509  1.00 91.01           C  
ATOM    127  CG  ASP    19      93.463 103.733  74.409  1.00 93.15           C  
ATOM    128  OD1 ASP    19      93.323 103.266  73.259  1.00 95.19           O  
ATOM    129  OD2 ASP    19      94.384 104.528  74.701  1.00 97.76           O  
ATOM    130  N   LYS    20      91.456 105.685  74.055  1.00 85.16           N  
ATOM    131  CA  LYS    20      91.273 107.110  73.786  1.00 82.92           C  
ATOM    132  C   LYS    20      89.816 107.477  73.458  1.00 80.52           C  
ATOM    133  O   LYS    20      89.253 108.420  74.027  1.00 80.56           O  
ATOM    134  CB  LYS    20      92.180 107.539  72.627  1.00 83.51           C  
ATOM    135  CG  LYS    20      93.671 107.243  72.823  1.00 86.11           C  
ATOM    136  CD  LYS    20      94.408 108.386  73.521  1.00 91.90           C  
ATOM    137  CE  LYS    20      95.905 108.087  73.660  1.00 92.28           C  
ATOM    138  NZ  LYS    20      96.592 107.877  72.350  1.00 91.97           N  
ATOM    139  N   LEU    21      89.210 106.721  72.546  1.00 77.43           N  
ATOM    140  CA  LEU    21      87.836 106.968  72.122  1.00 74.10           C  
ATOM    141  C   LEU    21      86.754 106.807  73.200  1.00 72.82           C  
ATOM    142  O   LEU    21      85.572 107.019  72.916  1.00 71.48           O  
ATOM    143  CB  LEU    21      87.507 106.089  70.906  1.00 73.69           C  
ATOM    144  CG  LEU    21      88.288 106.394  69.618  1.00 71.25           C  
ATOM    145  CD1 LEU    21      87.938 105.370  68.578  1.00 69.24           C  
ATOM    146  CD2 LEU    21      87.972 107.783  69.103  1.00 68.55           C  
ATOM    147  N   LEU    22      87.143 106.434  74.424  1.00 71.68           N  
ATOM    148  CA  LEU    22      86.172 106.290  75.512  1.00 70.37           C  
ATOM    149  C   LEU    22      86.095 107.557  76.356  1.00 69.76           C  
ATOM    150  O   LEU    22      85.162 107.730  77.144  1.00 69.42           O  
ATOM    151  CB  LEU    22      86.491 105.095  76.416  1.00 70.07           C  
ATOM    152  CG  LEU    22      86.082 103.676  75.982  1.00 71.01           C  
ATOM    153  CD1 LEU    22      85.902 102.800  77.220  1.00 68.76           C  
ATOM    154  CD2 LEU    22      84.773 103.705  75.206  1.00 72.70           C  
ATOM    155  N   ALA    23      87.078 108.441  76.174  1.00 69.46           N  
ATOM    156  CA  ALA    23      87.127 109.724  76.884  1.00 69.28           C  
ATOM    157  C   ALA    23      85.917 110.570  76.485  1.00 69.04           C  
ATOM    158  O   ALA    23      85.341 110.375  75.412  1.00 69.60           O  
ATOM    159  CB  ALA    23      88.409 110.460  76.543  1.00 69.01           C  
ATOM    160  N   LYS    24      85.549 111.522  77.337  1.00 68.45           N  
ATOM    161  CA  LYS    24      84.383 112.367  77.086  1.00 68.28           C  
ATOM    162  C   LYS    24      84.613 113.775  76.519  1.00 68.22           C  
ATOM    163  O   LYS    24      85.726 114.280  76.472  1.00 68.12           O  
ATOM    164  CB  LYS    24      83.569 112.483  78.376  1.00 67.78           C  
ATOM    165  CG  LYS    24      83.078 111.164  78.927  1.00 68.26           C  
ATOM    166  CD  LYS    24      82.344 111.376  80.231  1.00 66.88           C  
ATOM    167  CE  LYS    24      81.781 110.086  80.774  1.00 69.00           C  
ATOM    168  NZ  LYS    24      80.964 110.366  81.975  1.00 71.95           N  
ATOM    169  N   ILE    25      83.522 114.399  76.101  1.00 68.72           N  
ATOM    170  CA  ILE    25      83.525 115.746  75.553  1.00 69.60           C  
ATOM    171  C   ILE    25      82.113 116.231  75.805  1.00 70.70           C  
ATOM    172  O   ILE    25      81.199 115.924  75.039  1.00 70.98           O  
ATOM    173  CB  ILE    25      83.791 115.732  74.042  1.00 69.72           C  
ATOM    174  CG1 ILE    25      85.257 115.399  73.782  1.00 70.89           C  
ATOM    175  CG2 ILE    25      83.412 117.056  73.429  1.00 69.11           C  
ATOM    176  CD1 ILE    25      85.582 115.164  72.325  1.00 72.99           C  
ATOM    177  N   ASP    26      81.931 116.984  76.881  1.00 71.49           N  
ATOM    178  CA  ASP    26      80.604 117.463  77.233  1.00 72.41           C  
ATOM    179  C   ASP    26      79.866 116.270  77.805  1.00 71.27           C  
ATOM    180  O   ASP    26      78.696 116.051  77.478  1.00 71.67           O  
ATOM    181  CB  ASP    26      79.825 117.975  76.006  1.00 73.68           C  
ATOM    182  CG  ASP    26      80.186 119.402  75.626  1.00 79.66           C  
ATOM    183  OD1 ASP    26      80.133 120.280  76.516  1.00 86.88           O  
ATOM    184  OD2 ASP    26      80.510 119.650  74.441  1.00 84.59           O  
ATOM    185  N   ASN    27      80.559 115.481  78.628  1.00 68.93           N  
ATOM    186  CA  ASN    27      79.942 114.315  79.268  1.00 66.22           C  
ATOM    187  C   ASN    27      79.658 113.120  78.385  1.00 64.66           C  
ATOM    188  O   ASN    27      79.094 112.128  78.859  1.00 65.21           O  
ATOM    189  CB  ASN    27      78.612 114.688  79.922  1.00 65.54           C  
ATOM    190  CG  ASN    27      78.784 115.403  81.225  1.00 64.50           C  
ATOM    191  OD1 ASN    27      79.884 115.485  81.765  1.00 64.45           O  
ATOM    192  ND2 ASN    27      77.683 115.917  81.756  1.00 64.06           N  
ATOM    193  N   THR    28      80.000 113.196  77.108  1.00 62.05           N  
ATOM    194  CA  THR    28      79.717 112.060  76.257  1.00 59.69           C  
ATOM    195  C   THR    28      80.960 111.528  75.569  1.00 58.20           C  
ATOM    196  O   THR    28      81.777 112.288  75.050  1.00 57.50           O  
ATOM    197  CB  THR    28      78.640 112.384  75.191  1.00 59.45           C  
ATOM    198  OG1 THR    28      79.251 112.466  73.900  1.00 59.73           O  
ATOM    199  CG2 THR    28      77.942 113.690  75.508  1.00 57.57           C  
ATOM    200  N   PRO    29      81.119 110.198  75.579  1.00 56.76           N  
ATOM    201  CA  PRO    29      82.239 109.478  74.972  1.00 56.34           C  
ATOM    202  C   PRO    29      82.454 109.932  73.529  1.00 55.95           C  
ATOM    203  O   PRO    29      81.504 110.038  72.765  1.00 56.53           O  
ATOM    204  CB  PRO    29      81.788 108.027  75.065  1.00 56.52           C  
ATOM    205  CG  PRO    29      80.997 108.025  76.333  1.00 56.54           C  
ATOM    206  CD  PRO    29      80.176 109.262  76.213  1.00 55.49           C  
ATOM    207  N   ILE    30      83.700 110.192  73.157  1.00 55.38           N  
ATOM    208  CA  ILE    30      84.000 110.645  71.811  1.00 55.43           C  
ATOM    209  C   ILE    30      83.353 109.800  70.720  1.00 55.32           C  
ATOM    210  O   ILE    30      82.564 110.328  69.926  1.00 56.08           O  
ATOM    211  CB  ILE    30      85.522 110.709  71.577  1.00 55.57           C  
ATOM    212  CG1 ILE    30      86.136 111.685  72.580  1.00 58.50           C  
ATOM    213  CG2 ILE    30      85.833 111.166  70.152  1.00 55.90           C  
ATOM    214  CD1 ILE    30      87.631 111.558  72.699  1.00 61.89           C  
ATOM    215  N   ILE    31      83.672 108.504  70.676  1.00 54.45           N  
ATOM    216  CA  ILE    31      83.118 107.613  69.647  1.00 53.69           C  
ATOM    217  C   ILE    31      81.614 107.793  69.494  1.00 54.48           C  
ATOM    218  O   ILE    31      81.101 107.817  68.377  1.00 53.94           O  
ATOM    219  CB  ILE    31      83.430 106.091  69.930  1.00 53.14           C  
ATOM    220  CG1 ILE    31      82.977 105.234  68.744  1.00 52.34           C  
ATOM    221  CG2 ILE    31      82.709 105.612  71.178  1.00 49.66           C  
ATOM    222  CD1 ILE    31      83.529 105.698  67.414  1.00 48.24           C  
ATOM    223  N   MET    32      80.915 107.933  70.614  1.00 55.33           N  
ATOM    224  CA  MET    32      79.468 108.124  70.580  1.00 57.31           C  
ATOM    225  C   MET    32      79.075 109.453  69.925  1.00 57.61           C  
ATOM    226  O   MET    32      78.130 109.518  69.147  1.00 58.36           O  
ATOM    227  CB  MET    32      78.889 108.041  71.994  1.00 57.46           C  
ATOM    228  CG  MET    32      78.996 106.661  72.614  1.00 62.54           C  
ATOM    229  SD  MET    32      78.000 106.473  74.269  1.00 78.05          SE  
ATOM    230  CE  MET    32      76.220 106.221  73.530  1.00 73.81           C  
ATOM    231  N   ARG    33      79.804 110.515  70.236  1.00 57.73           N  
ATOM    232  CA  ARG    33      79.511 111.806  69.650  1.00 57.85           C  
ATOM    233  C   ARG    33      79.694 111.710  68.131  1.00 56.91           C  
ATOM    234  O   ARG    33      78.834 112.133  67.368  1.00 56.97           O  
ATOM    235  CB  ARG    33      80.455 112.857  70.228  1.00 58.89           C  
ATOM    236  CG  ARG    33      80.107 114.287  69.860  1.00 64.39           C  
ATOM    237  CD  ARG    33      81.310 115.202  70.074  1.00 73.49           C  
ATOM    238  NE  ARG    33      80.955 116.619  70.038  1.00 79.65           N  
ATOM    239  CZ  ARG    33      80.209 117.224  70.960  1.00 84.29           C  
ATOM    240  NH1 ARG    33      79.728 116.544  72.002  1.00 85.07           N  
ATOM    241  NH2 ARG    33      79.953 118.518  70.841  1.00 85.09           N  
ATOM    242  N   THR    34      80.818 111.141  67.710  1.00 55.65           N  
ATOM    243  CA  THR    34      81.154 110.977  66.299  1.00 55.20           C  
ATOM    244  C   THR    34      80.093 110.227  65.496  1.00 56.00           C  
ATOM    245  O   THR    34      79.744 110.616  64.383  1.00 57.09           O  
ATOM    246  CB  THR    34      82.487 110.233  66.153  1.00 54.71           C  
ATOM    247  OG1 THR    34      83.528 111.010  66.753  1.00 56.07           O  
ATOM    248  CG2 THR    34      82.817 109.991  64.698  1.00 53.23           C  
ATOM    249  N   ILE    35      79.595 109.135  66.050  1.00 55.81           N  
ATOM    250  CA  ILE    35      78.573 108.350  65.382  1.00 55.24           C  
ATOM    251  C   ILE    35      77.285 109.182  65.289  1.00 56.74           C  
ATOM    252  O   ILE    35      76.516 109.062  64.335  1.00 56.77           O  
ATOM    253  CB  ILE    35      78.314 107.055  66.181  1.00 54.53           C  
ATOM    254  CG1 ILE    35      79.523 106.122  66.057  1.00 52.33           C  
ATOM    255  CG2 ILE    35      77.025 106.392  65.721  1.00 54.33           C  
ATOM    256  CD1 ILE    35      79.511 104.992  67.061  1.00 52.36           C  
ATOM    257  N   ARG    36      77.063 110.034  66.285  1.00 58.78           N  
ATOM    258  CA  ARG    36      75.872 110.873  66.330  1.00 60.98           C  
ATOM    259  C   ARG    36      75.736 111.810  65.126  1.00 60.67           C  
ATOM    260  O   ARG    36      74.623 112.054  64.639  1.00 60.67           O  
ATOM    261  CB  ARG    36      75.856 111.709  67.617  1.00 62.08           C  
ATOM    262  CG  ARG    36      74.700 112.698  67.669  1.00 70.34           C  
ATOM    263  CD  ARG    36      74.838 113.806  68.723  1.00 81.85           C  
ATOM    264  NE  ARG    36      73.929 114.914  68.396  1.00 91.09           N  
ATOM    265  CZ  ARG    36      73.705 115.989  69.155  1.00 95.58           C  
ATOM    266  NH1 ARG    36      74.321 116.134  70.323  1.00 98.47           N  
ATOM    267  NH2 ARG    36      72.864 116.934  68.737  1.00 96.39           N  
ATOM    268  N   ILE    37      76.852 112.330  64.630  1.00 60.37           N  
ATOM    269  CA  ILE    37      76.760 113.262  63.520  1.00 60.38           C  
ATOM    270  C   ILE    37      76.210 112.662  62.239  1.00 59.58           C  
ATOM    271  O   ILE    37      75.575 113.366  61.461  1.00 60.82           O  
ATOM    272  CB  ILE    37      78.127 113.955  63.185  1.00 60.43           C  
ATOM    273  CG1 ILE    37      78.674 113.407  61.868  1.00 62.85           C  
ATOM    274  CG2 ILE    37      79.129 113.773  64.316  1.00 59.72           C  
ATOM    275  CD1 ILE    37      79.796 114.225  61.284  1.00 67.67           C  
ATOM    276  N   TYR    38      76.439 111.376  62.009  1.00 58.46           N  
ATOM    277  CA  TYR    38      75.958 110.767  60.772  1.00 58.42           C  
ATOM    278  C   TYR    38      74.512 110.287  60.843  1.00 59.45           C  
ATOM    279  O   TYR    38      74.027 109.572  59.957  1.00 59.42           O  
ATOM    280  CB  TYR    38      76.898 109.643  60.352  1.00 57.53           C  
ATOM    281  CG  TYR    38      78.318 110.140  60.220  1.00 57.36           C  
ATOM    282  CD1 TYR    38      79.162 110.183  61.328  1.00 55.51           C  
ATOM    283  CD2 TYR    38      78.800 110.631  59.012  1.00 55.63           C  
ATOM    284  CE1 TYR    38      80.441 110.698  61.244  1.00 49.86           C  
ATOM    285  CE2 TYR    38      80.086 111.152  58.916  1.00 54.10           C  
ATOM    286  CZ  TYR    38      80.901 111.178  60.041  1.00 51.45           C  
ATOM    287  OH  TYR    38      82.186 111.662  59.964  1.00 47.93           O  
ATOM    288  N   GLY    39      73.835 110.720  61.907  1.00 60.10           N  
ATOM    289  CA  GLY    39      72.436 110.407  62.143  1.00 60.00           C  
ATOM    290  C   GLY    39      71.855 109.148  61.549  1.00 60.55           C  
ATOM    291  O   GLY    39      72.378 108.058  61.752  1.00 61.52           O  
ATOM    292  N   ASP    40      70.771 109.296  60.796  1.00 60.94           N  
ATOM    293  CA  ASP    40      70.101 108.136  60.216  1.00 61.01           C  
ATOM    294  C   ASP    40      70.751 107.499  58.989  1.00 60.50           C  
ATOM    295  O   ASP    40      70.166 106.593  58.398  1.00 61.61           O  
ATOM    296  CB  ASP    40      68.633 108.467  59.925  1.00 61.37           C  
ATOM    297  N   LEU    41      71.943 107.952  58.601  1.00 59.40           N  
ATOM    298  CA  LEU    41      72.634 107.336  57.466  1.00 58.41           C  
ATOM    299  C   LEU    41      73.003 105.901  57.874  1.00 58.10           C  
ATOM    300  O   LEU    41      73.050 105.601  59.061  1.00 58.57           O  
ATOM    301  CB  LEU    41      73.916 108.105  57.132  1.00 57.99           C  
ATOM    302  CG  LEU    41      73.826 109.512  56.542  1.00 57.23           C  
ATOM    303  CD1 LEU    41      75.230 110.107  56.371  1.00 57.65           C  
ATOM    304  CD2 LEU    41      73.115 109.447  55.218  1.00 57.35           C  
ATOM    305  N   GLU    42      73.254 105.021  56.905  1.00 57.72           N  
ATOM    306  CA  GLU    42      73.638 103.638  57.205  1.00 58.18           C  
ATOM    307  C   GLU    42      75.083 103.558  57.672  1.00 57.58           C  
ATOM    308  O   GLU    42      76.007 103.563  56.865  1.00 58.58           O  
ATOM    309  CB  GLU    42      73.507 102.748  55.983  1.00 58.83           C  
ATOM    310  CG  GLU    42      72.111 102.537  55.499  1.00 63.58           C  
ATOM    311  CD  GLU    42      72.067 101.539  54.355  1.00 70.64           C  
ATOM    312  OE1 GLU    42      72.384 100.347  54.605  1.00 73.15           O  
ATOM    313  OE2 GLU    42      71.728 101.953  53.216  1.00 70.47           O  
ATOM    314  N   LYS    43      75.268 103.444  58.978  1.00 56.57           N  
ATOM    315  CA  LYS    43      76.589 103.388  59.574  1.00 54.94           C  
ATOM    316  C   LYS    43      77.058 101.962  59.729  1.00 53.93           C  
ATOM    317  O   LYS    43      76.296 101.025  59.586  1.00 54.99           O  
ATOM    318  CB  LYS    43      76.539 104.053  60.944  1.00 54.21           C  
ATOM    319  CG  LYS    43      76.089 105.493  60.873  1.00 56.44           C  
ATOM    320  CD  LYS    43      75.508 105.986  62.175  1.00 57.68           C  
ATOM    321  CE  LYS    43      74.133 105.422  62.382  1.00 62.41           C  
ATOM    322  NZ  LYS    43      73.639 105.759  63.752  1.00 70.06           N  
ATOM    323  N   ILE    44      78.336 101.815  60.023  1.00 53.03           N  
ATOM    324  CA  ILE    44      78.956 100.522  60.253  1.00 51.66           C  
ATOM    325  C   ILE    44      80.189 100.978  61.016  1.00 50.86           C  
ATOM    326  O   ILE    44      80.899 101.871  60.552  1.00 50.25           O  
ATOM    327  CB  ILE    44      79.325  99.798  58.892  1.00 51.74           C  
ATOM    328  CG1 ILE    44      78.773  98.381  58.892  1.00 53.42           C  
ATOM    329  CG2 ILE    44      80.828  99.652  58.706  1.00 51.40           C  
ATOM    330  CD1 ILE    44      77.286  98.305  59.143  1.00 58.76           C  
ATOM    331  N   ILE    45      80.414 100.441  62.209  1.00 49.37           N  
ATOM    332  CA  ILE    45      81.605 100.835  62.958  1.00 48.60           C  
ATOM    333  C   ILE    45      82.599  99.678  62.948  1.00 47.89           C  
ATOM    334  O   ILE    45      82.250  98.549  63.296  1.00 47.54           O  
ATOM    335  CB  ILE    45      81.288 101.224  64.429  1.00 48.70           C  
ATOM    336  CG1 ILE    45      80.526 102.551  64.500  1.00 51.62           C  
ATOM    337  CG2 ILE    45      82.577 101.466  65.175  1.00 48.08           C  
ATOM    338  CD1 ILE    45      79.121 102.524  64.017  1.00 50.63           C  
ATOM    339  N   ILE    46      83.832  99.957  62.530  1.00 47.84           N  
ATOM    340  CA  ILE    46      84.878  98.932  62.471  1.00 48.03           C  
ATOM    341  C   ILE    46      85.761  99.062  63.707  1.00 49.81           C  
ATOM    342  O   ILE    46      86.479 100.044  63.874  1.00 49.96           O  
ATOM    343  CB  ILE    46      85.750  99.079  61.206  1.00 47.88           C  
ATOM    344  CG1 ILE    46      84.863  99.339  59.981  1.00 46.63           C  
ATOM    345  CG2 ILE    46      86.567  97.822  61.007  1.00 45.07           C  
ATOM    346  CD1 ILE    46      83.919  98.205  59.659  1.00 46.69           C  
ATOM    347  N   VAL    47      85.713  98.050  64.563  1.00 51.65           N  
ATOM    348  CA  VAL    47      86.454  98.057  65.801  1.00 52.13           C  
ATOM    349  C   VAL    47      87.558  97.039  65.857  1.00 52.86           C  
ATOM    350  O   VAL    47      87.385  95.892  65.465  1.00 53.50           O  
ATOM    351  CB  VAL    47      85.489  97.786  66.997  1.00 52.29           C  
ATOM    352  CG1 VAL    47      86.271  97.710  68.308  1.00 58.76           C  
ATOM    353  CG2 VAL    47      84.434  98.880  67.086  1.00 49.63           C  
ATOM    354  N   GLY    48      88.700  97.489  66.340  1.00 53.86           N  
ATOM    355  CA  GLY    48      89.803  96.591  66.529  1.00 56.32           C  
ATOM    356  C   GLY    48      90.462  96.636  67.900  1.00 58.56           C  
ATOM    357  O   GLY    48      90.053  95.931  68.838  1.00 58.36           O  
ATOM    358  N   LYS    49      91.398  97.574  68.039  1.00 60.27           N  
ATOM    359  CA  LYS    49      92.245  97.618  69.209  1.00 61.92           C  
ATOM    360  C   LYS    49      91.645  97.359  70.559  1.00 62.63           C  
ATOM    361  O   LYS    49      92.151  96.541  71.335  1.00 63.40           O  
ATOM    362  CB  LYS    49      93.101  98.892  69.217  1.00 62.68           C  
ATOM    363  CG  LYS    49      94.220  98.881  70.262  1.00 65.72           C  
ATOM    364  CD  LYS    49      95.293  99.902  69.929  1.00 71.92           C  
ATOM    365  CE  LYS    49      96.442  99.825  70.923  1.00 74.57           C  
ATOM    366  NZ  LYS    49      97.419 100.945  70.723  1.00 77.45           N  
ATOM    367  N   TYR    50      90.541  98.024  70.825  1.00 61.98           N  
ATOM    368  CA  TYR    50      89.878  97.870  72.096  1.00 62.40           C  
ATOM    369  C   TYR    50      88.384  97.537  72.004  1.00 61.32           C  
ATOM    370  O   TYR    50      87.543  98.201  72.619  1.00 60.53           O  
ATOM    371  CB  TYR    50      90.093  99.142  72.913  1.00 64.35           C  
ATOM    372  CG  TYR    50      91.467  99.231  73.557  1.00 69.92           C  
ATOM    373  CD1 TYR    50      91.851  98.321  74.548  1.00 75.20           C  
ATOM    374  CD2 TYR    50      92.380 100.226  73.191  1.00 71.41           C  
ATOM    375  CE1 TYR    50      93.106  98.398  75.162  1.00 76.64           C  
ATOM    376  CE2 TYR    50      93.639 100.315  73.798  1.00 73.94           C  
ATOM    377  CZ  TYR    50      93.993  99.399  74.787  1.00 76.90           C  
ATOM    378  OH  TYR    50      95.211  99.503  75.430  1.00 78.80           O  
ATOM    379  N   VAL    51      88.073  96.495  71.237  1.00 59.63           N  
ATOM    380  CA  VAL    51      86.707  96.020  71.054  1.00 57.84           C  
ATOM    381  C   VAL    51      85.939  95.973  72.370  1.00 58.37           C  
ATOM    382  O   VAL    51      84.792  96.426  72.461  1.00 58.73           O  
ATOM    383  CB  VAL    51      86.667  94.573  70.482  1.00 58.21           C  
ATOM    384  CG1 VAL    51      85.824  94.537  69.223  1.00 57.69           C  
ATOM    385  CG2 VAL    51      88.069  94.054  70.218  1.00 57.30           C  
ATOM    386  N   ASN    52      86.588  95.412  73.385  1.00 58.63           N  
ATOM    387  CA  ASN    52      86.002  95.231  74.703  1.00 59.29           C  
ATOM    388  C   ASN    52      85.566  96.513  75.391  1.00 59.39           C  
ATOM    389  O   ASN    52      84.513  96.545  76.008  1.00 59.70           O  
ATOM    390  CB  ASN    52      86.986  94.443  75.559  1.00 60.17           C  
ATOM    391  CG  ASN    52      87.796  93.442  74.727  1.00 64.37           C  
ATOM    392  OD1 ASN    52      88.879  93.772  74.214  1.00 67.78           O  
ATOM    393  ND2 ASN    52      87.259  92.223  74.562  1.00 65.23           N  
ATOM    394  N   GLU    53      86.366  97.567  75.292  1.00 60.29           N  
ATOM    395  CA  GLU    53      86.020  98.851  75.889  1.00 60.62           C  
ATOM    396  C   GLU    53      84.865  99.468  75.113  1.00 60.18           C  
ATOM    397  O   GLU    53      83.879  99.925  75.678  1.00 60.82           O  
ATOM    398  CB  GLU    53      87.187  99.834  75.787  1.00 61.28           C  
ATOM    399  CG  GLU    53      88.107  99.932  76.968  1.00 65.75           C  
ATOM    400  CD  GLU    53      89.111  98.815  77.002  1.00 74.97           C  
ATOM    401  OE1 GLU    53      90.250  99.080  77.464  1.00 79.21           O  
ATOM    402  OE2 GLU    53      88.760  97.683  76.579  1.00 76.94           O  
ATOM    403  N   MET    54      85.035  99.481  73.800  1.00 59.89           N  
ATOM    404  CA  MET    54      84.103 100.063  72.844  1.00 60.56           C  
ATOM    405  C   MET    54      82.660  99.563  72.773  1.00 58.62           C  
ATOM    406  O   MET    54      81.708 100.349  72.841  1.00 58.00           O  
ATOM    407  CB  MET    54      84.697  99.924  71.449  1.00 62.14           C  
ATOM    408  CG  MET    54      86.053 100.549  71.282  1.00 69.52           C  
ATOM    409  SD  MET    54      85.886 102.012  70.073  1.00 90.15          SE  
ATOM    410  CE  MET    54      85.198 103.287  71.348  1.00 84.00           C  
ATOM    411  N   LEU    55      82.502  98.256  72.622  1.00 55.88           N  
ATOM    412  CA  LEU    55      81.184  97.676  72.459  1.00 54.39           C  
ATOM    413  C   LEU    55      80.040  98.066  73.373  1.00 53.04           C  
ATOM    414  O   LEU    55      78.959  98.398  72.897  1.00 53.20           O  
ATOM    415  CB  LEU    55      81.306  96.155  72.391  1.00 54.90           C  
ATOM    416  CG  LEU    55      81.307  95.787  70.903  1.00 56.33           C  
ATOM    417  CD1 LEU    55      82.157  94.570  70.662  1.00 61.30           C  
ATOM    418  CD2 LEU    55      79.872  95.590  70.432  1.00 52.82           C  
ATOM    419  N   PRO    56      80.249  98.046  74.694  1.00 51.29           N  
ATOM    420  CA  PRO    56      79.124  98.414  75.552  1.00 49.78           C  
ATOM    421  C   PRO    56      78.523  99.780  75.249  1.00 49.42           C  
ATOM    422  O   PRO    56      77.448 100.106  75.750  1.00 48.99           O  
ATOM    423  CB  PRO    56      79.719  98.312  76.948  1.00 49.07           C  
ATOM    424  CG  PRO    56      80.722  97.225  76.789  1.00 49.39           C  
ATOM    425  CD  PRO    56      81.395  97.595  75.498  1.00 49.72           C  
ATOM    426  N   LEU    57      79.216 100.574  74.436  1.00 49.11           N  
ATOM    427  CA  LEU    57      78.729 101.905  74.052  1.00 50.18           C  
ATOM    428  C   LEU    57      78.107 101.899  72.662  1.00 50.24           C  
ATOM    429  O   LEU    57      77.524 102.890  72.243  1.00 51.13           O  
ATOM    430  CB  LEU    57      79.862 102.932  74.024  1.00 50.39           C  
ATOM    431  CG  LEU    57      80.628 103.337  75.273  1.00 52.72           C  
ATOM    432  CD1 LEU    57      81.414 102.155  75.842  1.00 56.04           C  
ATOM    433  CD2 LEU    57      81.565 104.462  74.883  1.00 54.20           C  
ATOM    434  N   LEU    58      78.256 100.789  71.948  1.00 49.46           N  
ATOM    435  CA  LEU    58      77.741 100.660  70.593  1.00 48.48           C  
ATOM    436  C   LEU    58      76.717  99.532  70.493  1.00 49.44           C  
ATOM    437  O   LEU    58      76.510  98.994  69.411  1.00 50.42           O  
ATOM    438  CB  LEU    58      78.896 100.345  69.647  1.00 47.40           C  
ATOM    439  CG  LEU    58      80.166 101.180  69.771  1.00 44.88           C  
ATOM    440  CD1 LEU    58      81.278 100.576  68.929  1.00 42.95           C  
ATOM    441  CD2 LEU    58      79.876 102.572  69.324  1.00 44.85           C  
ATOM    442  N   MET    59      76.078  99.174  71.605  1.00 49.35           N  
ATOM    443  CA  MET    59      75.125  98.067  71.600  1.00 49.73           C  
ATOM    444  C   MET    59      73.985  98.168  70.591  1.00 49.30           C  
ATOM    445  O   MET    59      73.364  97.162  70.244  1.00 49.30           O  
ATOM    446  CB  MET    59      74.559  97.842  73.010  1.00 50.89           C  
ATOM    447  CG  MET    59      75.565  97.287  74.017  1.00 54.13           C  
ATOM    448  SD  MET    59      76.588  95.782  73.324  1.00 70.34          SE  
ATOM    449  CE  MET    59      75.361  94.347  73.753  1.00 58.89           C  
ATOM    450  N   ASP    60      73.708  99.374  70.110  1.00 47.86           N  
ATOM    451  CA  ASP    60      72.653  99.565  69.124  1.00 46.66           C  
ATOM    452  C   ASP    60      73.221  99.860  67.735  1.00 46.22           C  
ATOM    453  O   ASP    60      72.538 100.445  66.911  1.00 47.02           O  
ATOM    454  CB  ASP    60      71.777 100.727  69.535  1.00 46.17           C  
ATOM    455  CG  ASP    60      72.544 102.034  69.589  1.00 48.07           C  
ATOM    456  OD1 ASP    60      73.801 102.003  69.559  1.00 53.28           O  
ATOM    457  OD2 ASP    60      71.888 103.091  69.676  1.00 47.99           O  
ATOM    458  N   GLN    61      74.463  99.468  67.479  1.00 45.11           N  
ATOM    459  CA  GLN    61      75.091  99.721  66.192  1.00 45.51           C  
ATOM    460  C   GLN    61      75.570  98.418  65.558  1.00 45.51           C  
ATOM    461  O   GLN    61      75.632  97.396  66.234  1.00 47.80           O  
ATOM    462  CB  GLN    61      76.304 100.641  66.367  1.00 44.61           C  
ATOM    463  CG  GLN    61      76.029 101.970  67.031  1.00 47.76           C  
ATOM    464  CD  GLN    61      75.216 102.919  66.169  1.00 49.19           C  
ATOM    465  OE1 GLN    61      75.521 103.116  65.002  1.00 50.52           O  
ATOM    466  NE2 GLN    61      74.185 103.520  66.749  1.00 52.55           N  
ATOM    467  N   ILE    62      75.892  98.445  64.267  1.00 43.40           N  
ATOM    468  CA  ILE    62      76.422  97.260  63.623  1.00 42.80           C  
ATOM    469  C   ILE    62      77.933  97.417  63.754  1.00 43.20           C  
ATOM    470  O   ILE    62      78.536  98.329  63.179  1.00 43.46           O  
ATOM    471  CB  ILE    62      76.065  97.163  62.119  1.00 43.54           C  
ATOM    472  CG1 ILE    62      74.578  96.871  61.943  1.00 44.93           C  
ATOM    473  CG2 ILE    62      76.870  96.046  61.466  1.00 40.91           C  
ATOM    474  CD1 ILE    62      74.146  96.881  60.518  1.00 44.82           C  
ATOM    475  N   VAL    63      78.547  96.526  64.519  1.00 43.82           N  
ATOM    476  CA  VAL    63      79.975  96.594  64.738  1.00 42.60           C  
ATOM    477  C   VAL    63      80.726  95.410  64.165  1.00 43.60           C  
ATOM    478  O   VAL    63      80.362  94.255  64.412  1.00 44.70           O  
ATOM    479  CB  VAL    63      80.264  96.654  66.221  1.00 42.01           C  
ATOM    480  CG1 VAL    63      81.728  96.879  66.438  1.00 41.44           C  
ATOM    481  CG2 VAL    63      79.437  97.758  66.849  1.00 40.36           C  
ATOM    482  N   ILE    64      81.760  95.691  63.380  1.00 43.38           N  
ATOM    483  CA  ILE    64      82.579  94.618  62.834  1.00 43.76           C  
ATOM    484  C   ILE    64      83.935  94.756  63.513  1.00 43.62           C  
ATOM    485  O   ILE    64      84.577  95.801  63.455  1.00 43.62           O  
ATOM    486  CB  ILE    64      82.821  94.702  61.278  1.00 44.89           C  
ATOM    487  CG1 ILE    64      81.509  94.822  60.510  1.00 45.55           C  
ATOM    488  CG2 ILE    64      83.526  93.442  60.799  1.00 41.36           C  
ATOM    489  CD1 ILE    64      81.032  96.228  60.377  1.00 50.68           C  
ATOM    490  N   TYR    65      84.349  93.690  64.171  1.00 43.63           N  
ATOM    491  CA  TYR    65      85.625  93.649  64.829  1.00 43.37           C  
ATOM    492  C   TYR    65      86.648  93.145  63.818  1.00 44.75           C  
ATOM    493  O   TYR    65      86.500  92.057  63.249  1.00 43.95           O  
ATOM    494  CB  TYR    65      85.565  92.702  66.019  1.00 43.55           C  
ATOM    495  CG  TYR    65      86.918  92.251  66.487  1.00 41.43           C  
ATOM    496  CD1 TYR    65      87.852  93.164  66.972  1.00 38.27           C  
ATOM    497  CD2 TYR    65      87.280  90.912  66.418  1.00 41.59           C  
ATOM    498  CE1 TYR    65      89.120  92.749  67.377  1.00 40.70           C  
ATOM    499  CE2 TYR    65      88.550  90.489  66.822  1.00 45.09           C  
ATOM    500  CZ  TYR    65      89.460  91.409  67.299  1.00 42.17           C  
ATOM    501  OH  TYR    65      90.693  90.979  67.699  1.00 40.96           O  
ATOM    502  N   ASN    66      87.685  93.944  63.593  1.00 46.17           N  
ATOM    503  CA  ASN    66      88.737  93.574  62.660  1.00 47.65           C  
ATOM    504  C   ASN    66      89.911  92.902  63.383  1.00 49.38           C  
ATOM    505  O   ASN    66      90.732  93.568  63.999  1.00 50.31           O  
ATOM    506  CB  ASN    66      89.215  94.819  61.946  1.00 47.78           C  
ATOM    507  CG  ASN    66      90.256  94.527  60.923  1.00 47.90           C  
ATOM    508  OD1 ASN    66      90.794  95.442  60.318  1.00 49.13           O  
ATOM    509  ND2 ASN    66      90.552  93.247  60.710  1.00 45.03           N  
ATOM    510  N   PRO    67      90.018  91.566  63.301  1.00 50.88           N  
ATOM    511  CA  PRO    67      91.125  90.896  63.985  1.00 51.48           C  
ATOM    512  C   PRO    67      92.476  91.236  63.350  1.00 51.83           C  
ATOM    513  O   PRO    67      93.525  90.865  63.872  1.00 52.03           O  
ATOM    514  CB  PRO    67      90.772  89.428  63.819  1.00 50.88           C  
ATOM    515  CG  PRO    67      90.292  89.417  62.428  1.00 50.27           C  
ATOM    516  CD  PRO    67      89.335  90.615  62.409  1.00 51.26           C  
ATOM    517  N   PHE    68      92.447  91.941  62.226  1.00 51.67           N  
ATOM    518  CA  PHE    68      93.677  92.303  61.527  1.00 51.96           C  
ATOM    519  C   PHE    68      94.032  93.784  61.633  1.00 51.17           C  
ATOM    520  O   PHE    68      94.899  94.260  60.898  1.00 50.54           O  
ATOM    521  CB  PHE    68      93.555  91.945  60.047  1.00 52.16           C  
ATOM    522  CG  PHE    68      93.289  90.497  59.797  1.00 55.38           C  
ATOM    523  CD1 PHE    68      94.332  89.575  59.785  1.00 56.42           C  
ATOM    524  CD2 PHE    68      91.985  90.042  59.594  1.00 58.52           C  
ATOM    525  CE1 PHE    68      94.080  88.223  59.572  1.00 55.86           C  
ATOM    526  CE2 PHE    68      91.724  88.689  59.382  1.00 57.31           C  
ATOM    527  CZ  PHE    68      92.775  87.781  59.372  1.00 57.16           C  
ATOM    528  N   TRP    69      93.372  94.503  62.542  1.00 50.63           N  
ATOM    529  CA  TRP    69      93.603  95.940  62.694  1.00 50.90           C  
ATOM    530  C   TRP    69      95.071  96.320  62.846  1.00 51.38           C  
ATOM    531  O   TRP    69      95.521  97.326  62.316  1.00 50.73           O  
ATOM    532  CB  TRP    69      92.818  96.480  63.889  1.00 49.66           C  
ATOM    533  CG  TRP    69      93.264  95.906  65.183  1.00 49.78           C  
ATOM    534  CD1 TRP    69      92.800  94.774  65.775  1.00 47.87           C  
ATOM    535  CD2 TRP    69      94.302  96.408  66.032  1.00 49.42           C  
ATOM    536  NE1 TRP    69      93.478  94.536  66.941  1.00 49.11           N  
ATOM    537  CE2 TRP    69      94.411  95.524  67.126  1.00 49.69           C  
ATOM    538  CE3 TRP    69      95.154  97.522  65.977  1.00 49.81           C  
ATOM    539  CZ2 TRP    69      95.340  95.710  68.161  1.00 49.98           C  
ATOM    540  CZ3 TRP    69      96.077  97.709  67.006  1.00 48.86           C  
ATOM    541  CH2 TRP    69      96.160  96.806  68.082  1.00 50.99           C  
ATOM    542  N   ASN    70      95.801  95.490  63.574  1.00 52.70           N  
ATOM    543  CA  ASN    70      97.215  95.690  63.847  1.00 54.65           C  
ATOM    544  C   ASN    70      98.005  95.820  62.549  1.00 53.81           C  
ATOM    545  O   ASN    70      99.035  96.490  62.490  1.00 53.07           O  
ATOM    546  CB  ASN    70      97.723  94.499  64.672  1.00 56.29           C  
ATOM    547  CG  ASN    70      99.025  94.795  65.410  1.00 62.67           C  
ATOM    548  OD1 ASN    70      99.292  95.939  65.809  1.00 69.67           O  
ATOM    549  ND2 ASN    70      99.833  93.754  65.620  1.00 69.79           N  
ATOM    550  N   GLU    71      97.494  95.180  61.509  1.00 53.46           N  
ATOM    551  CA  GLU    71      98.120  95.181  60.202  1.00 53.66           C  
ATOM    552  C   GLU    71      98.038  96.539  59.483  1.00 53.22           C  
ATOM    553  O   GLU    71      98.893  96.854  58.649  1.00 53.15           O  
ATOM    554  CB  GLU    71      97.480  94.092  59.347  1.00 53.92           C  
ATOM    555  CG  GLU    71      98.156  93.870  58.026  1.00 58.69           C  
ATOM    556  CD  GLU    71      97.542  92.719  57.273  1.00 65.74           C  
ATOM    557  OE1 GLU    71      97.404  91.637  57.887  1.00 67.82           O  
ATOM    558  OE2 GLU    71      97.205  92.893  56.079  1.00 68.24           O  
ATOM    559  N   GLY    72      97.022  97.341  59.793  1.00 51.92           N  
ATOM    560  CA  GLY    72      96.920  98.636  59.147  1.00 50.61           C  
ATOM    561  C   GLY    72      95.502  99.049  58.821  1.00 49.73           C  
ATOM    562  O   GLY    72      94.600  98.212  58.787  1.00 50.44           O  
ATOM    563  N   ILE    73      95.305 100.336  58.544  1.00 47.95           N  
ATOM    564  CA  ILE    73      93.970 100.851  58.265  1.00 46.95           C  
ATOM    565  C   ILE    73      93.289 100.350  56.984  1.00 48.19           C  
ATOM    566  O   ILE    73      92.067 100.307  56.913  1.00 48.72           O  
ATOM    567  CB  ILE    73      93.965 102.408  58.279  1.00 45.94           C  
ATOM    568  CG1 ILE    73      92.529 102.910  58.439  1.00 44.83           C  
ATOM    569  CG2 ILE    73      94.575 102.956  57.005  1.00 43.64           C  
ATOM    570  CD1 ILE    73      92.435 104.343  58.871  1.00 42.31           C  
ATOM    571  N   SER    74      94.062  99.969  55.977  1.00 49.42           N  
ATOM    572  CA  SER    74      93.464  99.487  54.733  1.00 50.51           C  
ATOM    573  C   SER    74      92.662  98.231  55.036  1.00 51.13           C  
ATOM    574  O   SER    74      91.685  97.907  54.367  1.00 51.71           O  
ATOM    575  CB  SER    74      94.549  99.127  53.714  1.00 51.19           C  
ATOM    576  OG  SER    74      95.090  97.841  53.993  1.00 52.05           O  
ATOM    577  N   THR    75      93.106  97.528  56.064  1.00 51.38           N  
ATOM    578  CA  THR    75      92.490  96.288  56.472  1.00 51.08           C  
ATOM    579  C   THR    75      91.080  96.514  57.000  1.00 50.36           C  
ATOM    580  O   THR    75      90.183  95.709  56.767  1.00 50.15           O  
ATOM    581  CB  THR    75      93.368  95.617  57.536  1.00 51.62           C  
ATOM    582  OG1 THR    75      93.303  94.202  57.378  1.00 56.50           O  
ATOM    583  CG2 THR    75      92.908  95.984  58.939  1.00 50.68           C  
ATOM    584  N   SER    76      90.890  97.620  57.707  1.00 49.57           N  
ATOM    585  CA  SER    76      89.591  97.951  58.269  1.00 50.05           C  
ATOM    586  C   SER    76      88.694  98.509  57.170  1.00 50.81           C  
ATOM    587  O   SER    76      87.514  98.147  57.047  1.00 51.77           O  
ATOM    588  CB  SER    76      89.766  98.980  59.379  1.00 49.11           C  
ATOM    589  OG  SER    76      90.621  98.472  60.377  1.00 47.99           O  
ATOM    590  N   LEU    77      89.285  99.391  56.369  1.00 51.13           N  
ATOM    591  CA  LEU    77      88.623 100.039  55.248  1.00 51.45           C  
ATOM    592  C   LEU    77      88.006  99.002  54.297  1.00 51.62           C  
ATOM    593  O   LEU    77      86.872  99.147  53.844  1.00 51.07           O  
ATOM    594  CB  LEU    77      89.648 100.869  54.485  1.00 50.84           C  
ATOM    595  CG  LEU    77      89.208 102.173  53.837  1.00 52.69           C  
ATOM    596  CD1 LEU    77      90.141 102.457  52.676  1.00 53.42           C  
ATOM    597  CD2 LEU    77      87.781 102.084  53.355  1.00 53.75           C  
ATOM    598  N   LYS    78      88.761  97.957  53.991  1.00 52.16           N  
ATOM    599  CA  LYS    78      88.273  96.937  53.086  1.00 53.11           C  
ATOM    600  C   LYS    78      87.217  96.080  53.748  1.00 54.20           C  
ATOM    601  O   LYS    78      86.285  95.608  53.099  1.00 55.45           O  
ATOM    602  CB  LYS    78      89.437  96.079  52.584  1.00 52.56           C  
ATOM    603  CG  LYS    78      90.489  96.915  51.878  1.00 55.09           C  
ATOM    604  CD  LYS    78      91.324  96.128  50.892  1.00 58.22           C  
ATOM    605  CE  LYS    78      92.303  95.206  51.568  1.00 61.29           C  
ATOM    606  NZ  LYS    78      93.063  94.473  50.536  1.00 63.27           N  
ATOM    607  N   LEU    79      87.353  95.893  55.050  1.00 54.20           N  
ATOM    608  CA  LEU    79      86.397  95.088  55.777  1.00 53.58           C  
ATOM    609  C   LEU    79      85.031  95.748  55.653  1.00 53.51           C  
ATOM    610  O   LEU    79      84.059  95.111  55.263  1.00 53.13           O  
ATOM    611  CB  LEU    79      86.831  94.994  57.237  1.00 54.15           C  
ATOM    612  CG  LEU    79      86.457  93.736  58.017  1.00 55.50           C  
ATOM    613  CD1 LEU    79      86.571  92.523  57.124  1.00 57.45           C  
ATOM    614  CD2 LEU    79      87.383  93.600  59.221  1.00 55.73           C  
ATOM    615  N   GLY    80      84.972  97.039  55.959  1.00 53.82           N  
ATOM    616  CA  GLY    80      83.714  97.756  55.872  1.00 55.07           C  
ATOM    617  C   GLY    80      83.179  97.908  54.458  1.00 56.82           C  
ATOM    618  O   GLY    80      81.963  97.893  54.230  1.00 57.02           O  
ATOM    619  N   LEU    81      84.079  98.054  53.492  1.00 57.52           N  
ATOM    620  CA  LEU    81      83.648  98.220  52.116  1.00 57.35           C  
ATOM    621  C   LEU    81      82.893  97.011  51.573  1.00 57.82           C  
ATOM    622  O   LEU    81      82.142  97.142  50.619  1.00 58.82           O  
ATOM    623  CB  LEU    81      84.837  98.521  51.216  1.00 57.13           C  
ATOM    624  CG  LEU    81      84.401  99.039  49.844  1.00 56.54           C  
ATOM    625  CD1 LEU    81      83.556 100.301  50.013  1.00 58.60           C  
ATOM    626  CD2 LEU    81      85.625  99.330  48.999  1.00 55.16           C  
ATOM    627  N   ARG    82      83.091  95.837  52.163  1.00 58.01           N  
ATOM    628  CA  ARG    82      82.385  94.651  51.696  1.00 59.28           C  
ATOM    629  C   ARG    82      80.888  94.822  51.944  1.00 60.19           C  
ATOM    630  O   ARG    82      80.047  94.463  51.117  1.00 61.66           O  
ATOM    631  CB  ARG    82      82.862  93.400  52.440  1.00 58.88           C  
ATOM    632  CG  ARG    82      84.253  92.902  52.084  1.00 60.07           C  
ATOM    633  CD  ARG    82      84.664  91.815  53.061  1.00 64.01           C  
ATOM    634  NE  ARG    82      84.689  90.481  52.475  1.00 69.56           N  
ATOM    635  CZ  ARG    82      84.530  89.352  53.168  1.00 74.97           C  
ATOM    636  NH1 ARG    82      84.322  89.382  54.488  1.00 78.67           N  
ATOM    637  NH2 ARG    82      84.583  88.183  52.542  1.00 78.06           N  
ATOM    638  N   PHE    83      80.570  95.383  53.098  1.00 60.58           N  
ATOM    639  CA  PHE    83      79.201  95.589  53.510  1.00 61.91           C  
ATOM    640  C   PHE    83      78.471  96.590  52.596  1.00 62.30           C  
ATOM    641  O   PHE    83      77.239  96.590  52.521  1.00 62.65           O  
ATOM    642  CB  PHE    83      79.230  96.029  54.984  1.00 62.22           C  
ATOM    643  CG  PHE    83      77.879  96.200  55.616  1.00 66.17           C  
ATOM    644  CD1 PHE    83      77.191  97.415  55.517  1.00 71.26           C  
ATOM    645  CD2 PHE    83      77.296  95.162  56.333  1.00 69.17           C  
ATOM    646  CE1 PHE    83      75.936  97.597  56.129  1.00 71.89           C  
ATOM    647  CE2 PHE    83      76.044  95.337  56.947  1.00 72.59           C  
ATOM    648  CZ  PHE    83      75.363  96.561  56.841  1.00 71.44           C  
ATOM    649  N   PHE    84      79.223  97.416  51.874  1.00 62.51           N  
ATOM    650  CA  PHE    84      78.621  98.413  50.979  1.00 63.10           C  
ATOM    651  C   PHE    84      79.188  98.342  49.562  1.00 64.76           C  
ATOM    652  O   PHE    84      79.058  99.302  48.800  1.00 63.81           O  
ATOM    653  CB  PHE    84      78.899  99.832  51.485  1.00 62.18           C  
ATOM    654  CG  PHE    84      78.275 100.157  52.801  1.00 60.99           C  
ATOM    655  CD1 PHE    84      76.904 100.276  52.926  1.00 61.57           C  
ATOM    656  CD2 PHE    84      79.068 100.405  53.910  1.00 60.88           C  
ATOM    657  CE1 PHE    84      76.322 100.643  54.144  1.00 63.23           C  
ATOM    658  CE2 PHE    84      78.501 100.772  55.133  1.00 62.44           C  
ATOM    659  CZ  PHE    84      77.126 100.895  55.250  1.00 62.62           C  
ATOM    660  N   LYS    85      79.813  97.226  49.197  1.00 66.95           N  
ATOM    661  CA  LYS    85      80.441  97.130  47.882  1.00 69.13           C  
ATOM    662  C   LYS    85      79.574  97.522  46.688  1.00 70.31           C  
ATOM    663  O   LYS    85      80.069  98.143  45.749  1.00 71.72           O  
ATOM    664  CB  LYS    85      81.027  95.731  47.663  1.00 69.33           C  
ATOM    665  CG  LYS    85      80.041  94.693  47.173  1.00 72.38           C  
ATOM    666  CD  LYS    85      80.705  93.313  47.006  1.00 77.93           C  
ATOM    667  CE  LYS    85      81.890  93.326  46.034  1.00 79.05           C  
ATOM    668  NZ  LYS    85      82.423  91.957  45.746  1.00 80.80           N  
ATOM    669  N   ASP    86      78.290  97.185  46.710  1.00 70.75           N  
ATOM    670  CA  ASP    86      77.429  97.530  45.584  1.00 70.88           C  
ATOM    671  C   ASP    86      76.709  98.877  45.741  1.00 68.94           C  
ATOM    672  O   ASP    86      75.839  99.211  44.940  1.00 70.04           O  
ATOM    673  CB  ASP    86      76.405  96.415  45.354  1.00 72.35           C  
ATOM    674  CG  ASP    86      75.363  96.347  46.458  1.00 79.03           C  
ATOM    675  OD1 ASP    86      75.761  96.439  47.652  1.00 84.31           O  
ATOM    676  OD2 ASP    86      74.155  96.201  46.130  1.00 84.74           O  
ATOM    677  N   TYR    87      77.053  99.644  46.772  1.00 66.71           N  
ATOM    678  CA  TYR    87      76.431 100.956  46.985  1.00 64.20           C  
ATOM    679  C   TYR    87      77.049 101.957  46.031  1.00 64.05           C  
ATOM    680  O   TYR    87      78.094 101.699  45.440  1.00 64.34           O  
ATOM    681  CB  TYR    87      76.652 101.450  48.414  1.00 63.13           C  
ATOM    682  CG  TYR    87      75.656 100.939  49.422  1.00 59.15           C  
ATOM    683  CD1 TYR    87      75.514  99.576  49.662  1.00 54.93           C  
ATOM    684  CD2 TYR    87      74.858 101.828  50.142  1.00 56.10           C  
ATOM    685  CE1 TYR    87      74.593  99.106  50.605  1.00 53.69           C  
ATOM    686  CE2 TYR    87      73.935 101.380  51.080  1.00 54.90           C  
ATOM    687  CZ  TYR    87      73.805 100.017  51.311  1.00 55.64           C  
ATOM    688  OH  TYR    87      72.897  99.568  52.243  1.00 54.58           O  
ATOM    689  N   ASP    88      76.425 103.114  45.893  1.00 63.66           N  
ATOM    690  CA  ASP    88      76.956 104.114  44.983  1.00 64.27           C  
ATOM    691  C   ASP    88      78.246 104.726  45.519  1.00 63.88           C  
ATOM    692  O   ASP    88      79.174 105.003  44.759  1.00 64.49           O  
ATOM    693  CB  ASP    88      75.912 105.211  44.723  1.00 64.96           C  
ATOM    694  CG  ASP    88      74.598 104.650  44.172  1.00 66.85           C  
ATOM    695  OD1 ASP    88      74.657 103.802  43.253  1.00 66.84           O  
ATOM    696  OD2 ASP    88      73.515 105.060  44.654  1.00 69.17           O  
ATOM    697  N   ALA    89      78.302 104.927  46.831  1.00 62.91           N  
ATOM    698  CA  ALA    89      79.478 105.506  47.459  1.00 61.92           C  
ATOM    699  C   ALA    89      79.477 105.253  48.964  1.00 61.48           C  
ATOM    700  O   ALA    89      78.452 104.891  49.550  1.00 61.97           O  
ATOM    701  CB  ALA    89      79.522 107.005  47.184  1.00 61.21           C  
ATOM    702  N   VAL    90      80.636 105.432  49.588  1.00 60.01           N  
ATOM    703  CA  VAL    90      80.749 105.259  51.029  1.00 58.30           C  
ATOM    704  C   VAL    90      81.391 106.492  51.638  1.00 57.14           C  
ATOM    705  O   VAL    90      82.330 107.057  51.076  1.00 56.86           O  
ATOM    706  CB  VAL    90      81.620 104.030  51.415  1.00 58.42           C  
ATOM    707  CG1 VAL    90      80.921 102.750  51.026  1.00 59.19           C  
ATOM    708  CG2 VAL    90      82.986 104.127  50.750  1.00 56.69           C  
ATOM    709  N   LEU    91      80.869 106.918  52.779  1.00 55.61           N  
ATOM    710  CA  LEU    91      81.426 108.057  53.489  1.00 54.63           C  
ATOM    711  C   LEU    91      82.460 107.429  54.438  1.00 54.65           C  
ATOM    712  O   LEU    91      82.096 106.625  55.294  1.00 55.06           O  
ATOM    713  CB  LEU    91      80.334 108.748  54.298  1.00 53.78           C  
ATOM    714  CG  LEU    91      80.245 110.265  54.188  1.00 54.59           C  
ATOM    715  CD1 LEU    91      79.453 110.846  55.380  1.00 51.75           C  
ATOM    716  CD2 LEU    91      81.658 110.832  54.143  1.00 58.18           C  
ATOM    717  N   VAL    92      83.739 107.763  54.279  1.00 53.62           N  
ATOM    718  CA  VAL    92      84.768 107.187  55.140  1.00 52.79           C  
ATOM    719  C   VAL    92      85.057 108.091  56.320  1.00 52.56           C  
ATOM    720  O   VAL    92      85.872 109.001  56.217  1.00 53.69           O  
ATOM    721  CB  VAL    92      86.077 106.949  54.369  1.00 52.25           C  
ATOM    722  CG1 VAL    92      87.152 106.424  55.314  1.00 51.94           C  
ATOM    723  CG2 VAL    92      85.837 105.951  53.246  1.00 54.42           C  
ATOM    724  N   ALA    93      84.405 107.823  57.447  1.00 51.95           N  
ATOM    725  CA  ALA    93      84.571 108.639  58.646  1.00 51.84           C  
ATOM    726  C   ALA    93      85.574 108.062  59.635  1.00 52.15           C  
ATOM    727  O   ALA    93      85.803 106.856  59.683  1.00 52.28           O  
ATOM    728  CB  ALA    93      83.204 108.855  59.344  1.00 50.81           C  
ATOM    729  N   LEU    94      86.164 108.954  60.425  1.00 52.06           N  
ATOM    730  CA  LEU    94      87.140 108.589  61.436  1.00 52.16           C  
ATOM    731  C   LEU    94      86.519 108.758  62.808  1.00 52.91           C  
ATOM    732  O   LEU    94      85.943 109.803  63.096  1.00 52.88           O  
ATOM    733  CB  LEU    94      88.367 109.480  61.305  1.00 52.24           C  
ATOM    734  CG  LEU    94      89.047 109.292  59.954  1.00 51.55           C  
ATOM    735  CD1 LEU    94      89.981 110.437  59.677  1.00 52.65           C  
ATOM    736  CD2 LEU    94      89.772 107.968  59.958  1.00 50.12           C  
ATOM    737  N   GLY    95      86.645 107.719  63.639  1.00 52.92           N  
ATOM    738  CA  GLY    95      86.084 107.727  64.978  1.00 52.70           C  
ATOM    739  C   GLY    95      86.536 108.894  65.817  1.00 53.74           C  
ATOM    740  O   GLY    95      85.732 109.539  66.479  1.00 54.62           O  
ATOM    741  N   ASP    96      87.828 109.186  65.784  1.00 54.69           N  
ATOM    742  CA  ASP    96      88.369 110.287  66.567  1.00 55.37           C  
ATOM    743  C   ASP    96      88.098 111.692  66.000  1.00 56.11           C  
ATOM    744  O   ASP    96      88.752 112.658  66.391  1.00 57.21           O  
ATOM    745  CB  ASP    96      89.872 110.088  66.759  1.00 54.95           C  
ATOM    746  CG  ASP    96      90.627 110.138  65.458  1.00 58.10           C  
ATOM    747  OD1 ASP    96      89.983 110.169  64.388  1.00 60.60           O  
ATOM    748  OD2 ASP    96      91.872 110.139  65.500  1.00 63.56           O  
ATOM    749  N   MET    97      87.150 111.821  65.079  1.00 56.89           N  
ATOM    750  CA  MET    97      86.831 113.139  64.534  1.00 57.64           C  
ATOM    751  C   MET    97      85.379 113.487  64.838  1.00 57.73           C  
ATOM    752  O   MET    97      84.516 113.390  63.973  1.00 58.84           O  
ATOM    753  CB  MET    97      87.064 113.174  63.031  1.00 57.82           C  
ATOM    754  CG  MET    97      88.514 113.141  62.638  1.00 63.08           C  
ATOM    755  SD  MET    97      88.775 113.529  60.755  1.00 81.64          SE  
ATOM    756  CE  MET    97      90.719 113.549  60.713  1.00 79.03           C  
ATOM    757  N   PRO    98      85.097 113.909  66.080  1.00 57.33           N  
ATOM    758  CA  PRO    98      83.743 114.262  66.494  1.00 57.02           C  
ATOM    759  C   PRO    98      83.397 115.741  66.335  1.00 57.95           C  
ATOM    760  O   PRO    98      82.394 116.214  66.887  1.00 57.74           O  
ATOM    761  CB  PRO    98      83.740 113.840  67.950  1.00 56.71           C  
ATOM    762  CG  PRO    98      85.092 114.320  68.391  1.00 56.30           C  
ATOM    763  CD  PRO    98      86.005 113.905  67.244  1.00 57.38           C  
ATOM    764  N   PHE    99      84.215 116.484  65.596  1.00 58.99           N  
ATOM    765  CA  PHE    99      83.935 117.908  65.444  1.00 59.96           C  
ATOM    766  C   PHE    99      83.334 118.255  64.096  1.00 60.17           C  
ATOM    767  O   PHE    99      82.845 119.361  63.902  1.00 59.52           O  
ATOM    768  CB  PHE    99      85.192 118.738  65.731  1.00 60.42           C  
ATOM    769  CG  PHE    99      85.781 118.474  67.093  1.00 61.47           C  
ATOM    770  CD1 PHE    99      85.007 118.635  68.241  1.00 61.18           C  
ATOM    771  CD2 PHE    99      87.086 117.994  67.223  1.00 60.65           C  
ATOM    772  CE1 PHE    99      85.520 118.317  69.497  1.00 60.89           C  
ATOM    773  CE2 PHE    99      87.604 117.675  68.471  1.00 61.94           C  
ATOM    774  CZ  PHE    99      86.820 117.834  69.613  1.00 60.01           C  
ATOM    775  N   VAL   100      83.376 117.315  63.158  1.00 60.42           N  
ATOM    776  CA  VAL   100      82.751 117.542  61.868  1.00 59.65           C  
ATOM    777  C   VAL   100      81.269 117.660  62.251  1.00 59.60           C  
ATOM    778  O   VAL   100      80.797 116.968  63.151  1.00 58.98           O  
ATOM    779  CB  VAL   100      82.999 116.351  60.924  1.00 59.22           C  
ATOM    780  CG1 VAL   100      83.000 115.083  61.705  1.00 59.86           C  
ATOM    781  CG2 VAL   100      81.933 116.284  59.864  1.00 59.54           C  
ATOM    782  N   THR   101      80.538 118.551  61.594  1.00 60.41           N  
ATOM    783  CA  THR   101      79.130 118.766  61.923  1.00 60.04           C  
ATOM    784  C   THR   101      78.182 118.093  60.952  1.00 61.20           C  
ATOM    785  O   THR   101      78.576 117.754  59.839  1.00 61.16           O  
ATOM    786  CB  THR   101      78.803 120.244  61.913  1.00 59.27           C  
ATOM    787  OG1 THR   101      78.981 120.739  60.584  1.00 57.79           O  
ATOM    788  CG2 THR   101      79.711 120.997  62.861  1.00 56.24           C  
ATOM    789  N   LYS   102      76.933 117.903  61.376  1.00 62.74           N  
ATOM    790  CA  LYS   102      75.934 117.286  60.509  1.00 64.81           C  
ATOM    791  C   LYS   102      75.879 118.093  59.232  1.00 65.39           C  
ATOM    792  O   LYS   102      75.819 117.541  58.136  1.00 64.62           O  
ATOM    793  CB  LYS   102      74.548 117.289  61.156  1.00 65.69           C  
ATOM    794  CG  LYS   102      74.235 116.061  61.996  1.00 69.63           C  
ATOM    795  CD  LYS   102      72.739 115.824  62.059  1.00 74.55           C  
ATOM    796  CE  LYS   102      72.405 114.639  62.937  1.00 77.99           C  
ATOM    797  NZ  LYS   102      72.889 114.863  64.326  1.00 81.50           N  
ATOM    798  N   GLU   103      75.902 119.412  59.391  1.00 66.62           N  
ATOM    799  CA  GLU   103      75.878 120.323  58.257  1.00 68.07           C  
ATOM    800  C   GLU   103      76.974 119.993  57.244  1.00 67.62           C  
ATOM    801  O   GLU   103      76.724 119.985  56.037  1.00 67.46           O  
ATOM    802  CB  GLU   103      76.039 121.763  58.744  1.00 69.67           C  
ATOM    803  CG  GLU   103      74.842 122.277  59.505  1.00 75.46           C  
ATOM    804  CD  GLU   103      73.535 122.020  58.757  1.00 83.50           C  
ATOM    805  OE1 GLU   103      73.498 122.265  57.528  1.00 86.84           O  
ATOM    806  OE2 GLU   103      72.549 121.576  59.396  1.00 86.31           O  
ATOM    807  N   ASP   104      78.185 119.731  57.736  1.00 67.07           N  
ATOM    808  CA  ASP   104      79.305 119.393  56.867  1.00 66.63           C  
ATOM    809  C   ASP   104      78.984 118.133  56.083  1.00 66.12           C  
ATOM    810  O   ASP   104      79.264 118.044  54.886  1.00 65.91           O  
ATOM    811  CB  ASP   104      80.577 119.143  57.679  1.00 66.99           C  
ATOM    812  CG  ASP   104      81.038 120.362  58.440  1.00 68.35           C  
ATOM    813  OD1 ASP   104      80.997 121.463  57.863  1.00 72.59           O  
ATOM    814  OD2 ASP   104      81.458 120.220  59.608  1.00 65.48           O  
ATOM    815  N   VAL   105      78.405 117.150  56.761  1.00 65.88           N  
ATOM    816  CA  VAL   105      78.070 115.899  56.099  1.00 66.65           C  
ATOM    817  C   VAL   105      76.964 116.093  55.070  1.00 67.88           C  
ATOM    818  O   VAL   105      76.948 115.429  54.025  1.00 68.40           O  
ATOM    819  CB  VAL   105      77.632 114.819  57.111  1.00 66.21           C  
ATOM    820  CG1 VAL   105      77.236 113.530  56.369  1.00 63.28           C  
ATOM    821  CG2 VAL   105      78.767 114.554  58.092  1.00 64.83           C  
ATOM    822  N   ASN   106      76.046 117.006  55.372  1.00 68.52           N  
ATOM    823  CA  ASN   106      74.945 117.299  54.475  1.00 69.21           C  
ATOM    824  C   ASN   106      75.521 117.899  53.192  1.00 69.46           C  
ATOM    825  O   ASN   106      75.156 117.491  52.084  1.00 69.79           O  
ATOM    826  CB  ASN   106      73.980 118.278  55.146  1.00 70.36           C  
ATOM    827  CG  ASN   106      72.590 118.252  54.523  1.00 73.18           C  
ATOM    828  OD1 ASN   106      71.923 117.213  54.511  1.00 75.38           O  
ATOM    829  ND2 ASN   106      72.146 119.399  54.003  1.00 78.25           N  
ATOM    830  N   LYS   107      76.434 118.859  53.346  1.00 69.38           N  
ATOM    831  CA  LYS   107      77.072 119.498  52.198  1.00 69.64           C  
ATOM    832  C   LYS   107      77.833 118.484  51.361  1.00 69.90           C  
ATOM    833  O   LYS   107      77.671 118.426  50.147  1.00 70.92           O  
ATOM    834  CB  LYS   107      78.064 120.569  52.643  1.00 69.73           C  
ATOM    835  CG  LYS   107      77.466 121.815  53.240  1.00 70.89           C  
ATOM    836  CD  LYS   107      78.581 122.754  53.661  1.00 72.41           C  
ATOM    837  CE  LYS   107      78.020 123.994  54.287  1.00 75.34           C  
ATOM    838  NZ  LYS   107      77.084 123.633  55.384  1.00 78.79           N  
ATOM    839  N   ILE   108      78.674 117.694  52.018  1.00 69.99           N  
ATOM    840  CA  ILE   108      79.475 116.690  51.326  1.00 70.00           C  
ATOM    841  C   ILE   108      78.630 115.750  50.488  1.00 70.52           C  
ATOM    842  O   ILE   108      78.946 115.489  49.322  1.00 69.75           O  
ATOM    843  CB  ILE   108      80.301 115.837  52.323  1.00 69.97           C  
ATOM    844  CG1 ILE   108      81.223 116.744  53.141  1.00 68.99           C  
ATOM    845  CG2 ILE   108      81.121 114.792  51.562  1.00 67.40           C  
ATOM    846  CD1 ILE   108      82.050 116.021  54.165  1.00 68.64           C  
ATOM    847  N   ILE   109      77.559 115.235  51.084  1.00 71.82           N  
ATOM    848  CA  ILE   109      76.694 114.312  50.372  1.00 73.40           C  
ATOM    849  C   ILE   109      75.963 115.030  49.244  1.00 74.95           C  
ATOM    850  O   ILE   109      75.712 114.444  48.188  1.00 74.87           O  
ATOM    851  CB  ILE   109      75.669 113.648  51.317  1.00 72.92           C  
ATOM    852  CG1 ILE   109      76.396 112.902  52.438  1.00 72.32           C  
ATOM    853  CG2 ILE   109      74.815 112.658  50.543  1.00 73.00           C  
ATOM    854  CD1 ILE   109      75.471 112.152  53.374  1.00 72.12           C  
ATOM    855  N   ASN   110      75.640 116.304  49.454  1.00 76.62           N  
ATOM    856  CA  ASN   110      74.943 117.074  48.427  1.00 77.75           C  
ATOM    857  C   ASN   110      75.827 117.519  47.265  1.00 77.54           C  
ATOM    858  O   ASN   110      75.317 117.937  46.227  1.00 78.41           O  
ATOM    859  CB  ASN   110      74.271 118.306  49.037  1.00 78.60           C  
ATOM    860  CG  ASN   110      73.054 117.952  49.879  1.00 81.57           C  
ATOM    861  OD1 ASN   110      72.228 117.114  49.494  1.00 82.58           O  
ATOM    862  ND2 ASN   110      72.930 118.603  51.031  1.00 85.45           N  
ATOM    863  N   THR   111      77.142 117.424  47.427  1.00 76.50           N  
ATOM    864  CA  THR   111      78.069 117.836  46.379  1.00 75.76           C  
ATOM    865  C   THR   111      78.380 116.689  45.426  1.00 76.37           C  
ATOM    866  O   THR   111      78.986 116.884  44.377  1.00 76.43           O  
ATOM    867  CB  THR   111      79.388 118.337  46.994  1.00 75.39           C  
ATOM    868  OG1 THR   111      79.100 119.332  47.978  1.00 74.42           O  
ATOM    869  CG2 THR   111      80.290 118.936  45.937  1.00 75.41           C  
ATOM    870  N   PHE   112      77.945 115.491  45.788  1.00 77.34           N  
ATOM    871  CA  PHE   112      78.210 114.306  44.982  1.00 78.11           C  
ATOM    872  C   PHE   112      77.405 114.191  43.689  1.00 80.28           C  
ATOM    873  O   PHE   112      76.184 114.050  43.716  1.00 80.80           O  
ATOM    874  CB  PHE   112      77.994 113.060  45.836  1.00 76.72           C  
ATOM    875  CG  PHE   112      78.192 111.781  45.096  1.00 73.51           C  
ATOM    876  CD1 PHE   112      79.335 111.578  44.333  1.00 70.01           C  
ATOM    877  CD2 PHE   112      77.249 110.763  45.182  1.00 71.66           C  
ATOM    878  CE1 PHE   112      79.540 110.378  43.663  1.00 69.79           C  
ATOM    879  CE2 PHE   112      77.443 109.558  44.517  1.00 69.27           C  
ATOM    880  CZ  PHE   112      78.596 109.366  43.755  1.00 69.71           C  
ATOM    881  N   LYS   113      78.103 114.242  42.557  1.00 82.83           N  
ATOM    882  CA  LYS   113      77.463 114.128  41.250  1.00 85.02           C  
ATOM    883  C   LYS   113      78.089 112.966  40.486  1.00 86.49           C  
ATOM    884  O   LYS   113      79.163 112.479  40.850  1.00 86.93           O  
ATOM    885  CB  LYS   113      77.649 115.415  40.446  1.00 84.96           C  
ATOM    886  CG  LYS   113      77.320 116.675  41.213  1.00 85.92           C  
ATOM    887  CD  LYS   113      75.900 116.661  41.722  1.00 88.01           C  
ATOM    888  CE  LYS   113      75.673 117.838  42.646  1.00 90.37           C  
ATOM    889  NZ  LYS   113      74.331 117.785  43.276  1.00 92.40           N  
ATOM    890  N   PRO   114      77.430 112.511  39.406  1.00 87.82           N  
ATOM    891  CA  PRO   114      77.936 111.395  38.593  1.00 88.26           C  
ATOM    892  C   PRO   114      79.341 111.625  38.020  1.00 88.54           C  
ATOM    893  O   PRO   114      80.075 110.672  37.744  1.00 88.72           O  
ATOM    894  CB  PRO   114      76.876 111.262  37.495  1.00 88.45           C  
ATOM    895  CG  PRO   114      75.612 111.728  38.184  1.00 88.65           C  
ATOM    896  CD  PRO   114      76.107 112.954  38.921  1.00 87.87           C  
ATOM    897  N   ASN   115      79.708 112.891  37.838  1.00 88.27           N  
ATOM    898  CA  ASN   115      81.017 113.234  37.299  1.00 87.89           C  
ATOM    899  C   ASN   115      82.099 113.053  38.355  1.00 87.58           C  
ATOM    900  O   ASN   115      83.263 112.827  38.024  1.00 88.00           O  
ATOM    901  CB  ASN   115      81.011 114.676  36.803  1.00 87.90           C  
ATOM    902  N   CYS   116      81.701 113.145  39.623  1.00 86.76           N  
ATOM    903  CA  CYS   116      82.625 113.026  40.747  1.00 86.00           C  
ATOM    904  C   CYS   116      83.114 111.618  41.050  1.00 84.42           C  
ATOM    905  O   CYS   116      82.317 110.697  41.241  1.00 84.56           O  
ATOM    906  CB  CYS   116      81.992 113.593  42.023  1.00 86.32           C  
ATOM    907  SG  CYS   116      81.339 115.287  41.872  1.00 90.88           S  
ATOM    908  N   LYS   117      84.436 111.473  41.101  1.00 82.59           N  
ATOM    909  CA  LYS   117      85.085 110.208  41.429  1.00 80.48           C  
ATOM    910  C   LYS   117      85.085 110.109  42.955  1.00 78.41           C  
ATOM    911  O   LYS   117      84.997 109.026  43.536  1.00 77.64           O  
ATOM    912  CB  LYS   117      86.527 110.211  40.926  1.00 81.04           C  
ATOM    913  CG  LYS   117      86.693 109.859  39.469  1.00 83.13           C  
ATOM    914  CD  LYS   117      86.463 108.377  39.259  1.00 87.67           C  
ATOM    915  CE  LYS   117      86.861 107.948  37.863  1.00 91.25           C  
ATOM    916  NZ  LYS   117      86.017 108.607  36.834  1.00 94.86           N  
ATOM    917  N   ALA   118      85.181 111.268  43.592  1.00 75.75           N  
ATOM    918  CA  ALA   118      85.192 111.348  45.036  1.00 73.60           C  
ATOM    919  C   ALA   118      84.942 112.785  45.442  1.00 72.38           C  
ATOM    920  O   ALA   118      85.389 113.704  44.772  1.00 73.59           O  
ATOM    921  CB  ALA   118      86.529 110.890  45.564  1.00 74.01           C  
ATOM    922  N   VAL   119      84.210 112.976  46.530  1.00 70.08           N  
ATOM    923  CA  VAL   119      83.930 114.309  47.032  1.00 68.06           C  
ATOM    924  C   VAL   119      84.834 114.478  48.231  1.00 67.27           C  
ATOM    925  O   VAL   119      84.939 113.568  49.052  1.00 67.93           O  
ATOM    926  CB  VAL   119      82.487 114.445  47.513  1.00 68.04           C  
ATOM    927  CG1 VAL   119      82.307 115.773  48.190  1.00 66.10           C  
ATOM    928  CG2 VAL   119      81.532 114.315  46.355  1.00 68.91           C  
ATOM    929  N   ILE   120      85.481 115.632  48.348  1.00 65.82           N  
ATOM    930  CA  ILE   120      86.382 115.866  49.468  1.00 64.51           C  
ATOM    931  C   ILE   120      86.098 117.157  50.210  1.00 65.04           C  
ATOM    932  O   ILE   120      86.161 118.246  49.639  1.00 64.40           O  
ATOM    933  CB  ILE   120      87.863 115.901  49.012  1.00 63.92           C  
ATOM    934  CG1 ILE   120      88.264 114.544  48.425  1.00 63.65           C  
ATOM    935  CG2 ILE   120      88.763 116.263  50.187  1.00 61.60           C  
ATOM    936  CD1 ILE   120      89.684 114.494  47.896  1.00 60.61           C  
ATOM    937  N   PRO   121      85.773 117.059  51.505  1.00 65.27           N  
ATOM    938  CA  PRO   121      85.510 118.305  52.230  1.00 65.83           C  
ATOM    939  C   PRO   121      86.783 119.147  52.290  1.00 66.58           C  
ATOM    940  O   PRO   121      87.901 118.618  52.304  1.00 65.85           O  
ATOM    941  CB  PRO   121      85.050 117.820  53.605  1.00 65.49           C  
ATOM    942  CG  PRO   121      85.761 116.510  53.754  1.00 64.49           C  
ATOM    943  CD  PRO   121      85.607 115.889  52.382  1.00 64.85           C  
ATOM    944  N   THR   122      86.595 120.461  52.312  1.00 67.79           N  
ATOM    945  CA  THR   122      87.704 121.402  52.356  1.00 69.21           C  
ATOM    946  C   THR   122      87.402 122.530  53.319  1.00 69.43           C  
ATOM    947  O   THR   122      86.245 122.846  53.592  1.00 69.17           O  
ATOM    948  CB  THR   122      87.962 122.032  50.975  1.00 69.52           C  
ATOM    949  OG1 THR   122      88.161 121.001  50.000  1.00 71.78           O  
ATOM    950  CG2 THR   122      89.194 122.902  51.018  1.00 70.92           C  
ATOM    951  N   HIS   123      88.457 123.134  53.839  1.00 70.60           N  
ATOM    952  CA  HIS   123      88.293 124.250  54.742  1.00 72.73           C  
ATOM    953  C   HIS   123      89.555 125.079  54.795  1.00 74.60           C  
ATOM    954  O   HIS   123      90.575 124.650  55.336  1.00 75.01           O  
ATOM    955  CB  HIS   123      87.915 123.777  56.132  1.00 72.08           C  
ATOM    956  CG  HIS   123      87.799 124.884  57.127  1.00 72.75           C  
ATOM    957  ND1 HIS   123      88.891 125.434  57.756  1.00 74.49           N  
ATOM    958  CD2 HIS   123      86.715 125.527  57.625  1.00 73.58           C  
ATOM    959  CE1 HIS   123      88.487 126.361  58.608  1.00 74.84           C  
ATOM    960  NE2 HIS   123      87.170 126.436  58.547  1.00 73.86           N  
ATOM    961  N   LYS   124      89.463 126.272  54.207  1.00 76.62           N  
ATOM    962  CA  LYS   124      90.561 127.221  54.151  1.00 78.11           C  
ATOM    963  C   LYS   124      91.809 126.634  53.499  1.00 78.93           C  
ATOM    964  O   LYS   124      92.879 126.549  54.113  1.00 79.34           O  
ATOM    965  CB  LYS   124      90.867 127.743  55.553  1.00 78.57           C  
ATOM    966  CG  LYS   124      89.752 128.605  56.124  1.00 80.40           C  
ATOM    967  CD  LYS   124      90.060 129.065  57.544  1.00 83.67           C  
ATOM    968  CE  LYS   124      88.898 129.847  58.140  1.00 84.87           C  
ATOM    969  NZ  LYS   124      89.052 130.018  59.615  1.00 87.62           N  
ATOM    970  N   GLY   125      91.643 126.212  52.248  1.00 79.59           N  
ATOM    971  CA  GLY   125      92.753 125.675  51.485  1.00 80.41           C  
ATOM    972  C   GLY   125      93.002 124.184  51.559  1.00 81.19           C  
ATOM    973  O   GLY   125      93.167 123.532  50.525  1.00 81.94           O  
ATOM    974  N   GLU   126      93.037 123.637  52.771  1.00 81.23           N  
ATOM    975  CA  GLU   126      93.299 122.208  52.949  1.00 80.96           C  
ATOM    976  C   GLU   126      92.057 121.321  52.975  1.00 79.32           C  
ATOM    977  O   GLU   126      90.977 121.743  53.408  1.00 79.79           O  
ATOM    978  CB  GLU   126      94.115 121.994  54.225  1.00 81.55           C  
ATOM    979  CG  GLU   126      93.533 122.678  55.439  1.00 84.47           C  
ATOM    980  CD  GLU   126      94.508 122.726  56.598  1.00 89.37           C  
ATOM    981  OE1 GLU   126      94.954 121.646  57.051  1.00 90.89           O  
ATOM    982  OE2 GLU   126      94.831 123.845  57.058  1.00 91.20           O  
ATOM    983  N   ARG   127      92.225 120.093  52.489  1.00 76.70           N  
ATOM    984  CA  ARG   127      91.141 119.121  52.467  1.00 74.71           C  
ATOM    985  C   ARG   127      91.155 118.253  53.731  1.00 72.90           C  
ATOM    986  O   ARG   127      92.216 117.877  54.233  1.00 72.41           O  
ATOM    987  CB  ARG   127      91.232 118.245  51.211  1.00 74.97           C  
ATOM    988  CG  ARG   127      92.639 117.903  50.754  1.00 75.13           C  
ATOM    989  CD  ARG   127      92.898 118.419  49.339  1.00 76.10           C  
ATOM    990  NE  ARG   127      93.050 117.355  48.344  1.00 77.77           N  
ATOM    991  CZ  ARG   127      93.366 117.569  47.065  1.00 79.80           C  
ATOM    992  NH1 ARG   127      93.561 118.811  46.627  1.00 80.34           N  
ATOM    993  NH2 ARG   127      93.501 116.548  46.220  1.00 78.44           N  
ATOM    994  N   GLY   128      89.963 117.955  54.246  1.00 70.72           N  
ATOM    995  CA  GLY   128      89.845 117.150  55.450  1.00 66.93           C  
ATOM    996  C   GLY   128      88.973 115.917  55.308  1.00 64.25           C  
ATOM    997  O   GLY   128      88.916 115.298  54.250  1.00 64.67           O  
ATOM    998  N   ASN   129      88.294 115.559  56.390  1.00 61.56           N  
ATOM    999  CA  ASN   129      87.428 114.384  56.402  1.00 58.87           C  
ATOM   1000  C   ASN   129      86.078 114.722  57.020  1.00 57.79           C  
ATOM   1001  O   ASN   129      85.945 115.703  57.753  1.00 57.31           O  
ATOM   1002  CB  ASN   129      88.093 113.260  57.189  1.00 58.60           C  
ATOM   1003  CG  ASN   129      89.402 112.817  56.574  1.00 57.95           C  
ATOM   1004  OD1 ASN   129      89.422 112.151  55.537  1.00 56.78           O  
ATOM   1005  ND2 ASN   129      90.508 113.198  57.202  1.00 56.02           N  
ATOM   1006  N   PRO   130      85.071 113.869  56.797  1.00 57.42           N  
ATOM   1007  CA  PRO   130      85.104 112.632  56.014  1.00 56.93           C  
ATOM   1008  C   PRO   130      85.084 112.800  54.507  1.00 57.84           C  
ATOM   1009  O   PRO   130      84.498 113.745  53.983  1.00 58.47           O  
ATOM   1010  CB  PRO   130      83.875 111.898  56.512  1.00 56.26           C  
ATOM   1011  CG  PRO   130      82.909 113.030  56.684  1.00 57.24           C  
ATOM   1012  CD  PRO   130      83.743 114.066  57.403  1.00 56.49           C  
ATOM   1013  N   VAL   131      85.714 111.852  53.822  1.00 58.00           N  
ATOM   1014  CA  VAL   131      85.790 111.834  52.371  1.00 57.97           C  
ATOM   1015  C   VAL   131      84.782 110.849  51.776  1.00 58.42           C  
ATOM   1016  O   VAL   131      84.677 109.704  52.234  1.00 58.77           O  
ATOM   1017  CB  VAL   131      87.204 111.441  51.917  1.00 57.59           C  
ATOM   1018  CG1 VAL   131      87.198 111.014  50.476  1.00 59.19           C  
ATOM   1019  CG2 VAL   131      88.124 112.611  52.088  1.00 58.16           C  
ATOM   1020  N   LEU   132      84.055 111.293  50.750  1.00 58.08           N  
ATOM   1021  CA  LEU   132      83.058 110.449  50.092  1.00 57.65           C  
ATOM   1022  C   LEU   132      83.647 109.779  48.851  1.00 57.67           C  
ATOM   1023  O   LEU   132      83.900 110.443  47.856  1.00 59.54           O  
ATOM   1024  CB  LEU   132      81.833 111.293  49.717  1.00 57.41           C  
ATOM   1025  CG  LEU   132      80.631 110.589  49.074  1.00 58.34           C  
ATOM   1026  CD1 LEU   132      80.298 109.336  49.842  1.00 61.60           C  
ATOM   1027  CD2 LEU   132      79.430 111.512  49.063  1.00 55.91           C  
ATOM   1028  N   ILE   133      83.867 108.468  48.909  1.00 56.74           N  
ATOM   1029  CA  ILE   133      84.448 107.730  47.786  1.00 55.35           C  
ATOM   1030  C   ILE   133      83.375 106.967  47.010  1.00 55.07           C  
ATOM   1031  O   ILE   133      82.522 106.298  47.612  1.00 56.48           O  
ATOM   1032  CB  ILE   133      85.510 106.710  48.265  1.00 55.20           C  
ATOM   1033  CG1 ILE   133      86.601 107.417  49.071  1.00 56.29           C  
ATOM   1034  CG2 ILE   133      86.114 105.996  47.063  1.00 55.79           C  
ATOM   1035  CD1 ILE   133      87.725 106.513  49.499  1.00 57.86           C  
ATOM   1036  N   SER   134      83.443 107.040  45.679  1.00 52.85           N  
ATOM   1037  CA  SER   134      82.458 106.394  44.805  1.00 51.80           C  
ATOM   1038  C   SER   134      82.815 104.995  44.295  1.00 52.90           C  
ATOM   1039  O   SER   134      83.985 104.657  44.136  1.00 53.54           O  
ATOM   1040  CB  SER   134      82.181 107.294  43.602  1.00 51.85           C  
ATOM   1041  OG  SER   134      83.293 107.298  42.722  1.00 47.09           O  
ATOM   1042  N   LYS   135      81.789 104.200  44.007  1.00 55.28           N  
ATOM   1043  CA  LYS   135      81.978 102.836  43.526  1.00 57.82           C  
ATOM   1044  C   LYS   135      83.063 102.729  42.459  1.00 59.79           C  
ATOM   1045  O   LYS   135      83.720 101.689  42.340  1.00 60.63           O  
ATOM   1046  CB  LYS   135      80.648 102.266  42.992  1.00 56.16           C  
ATOM   1047  N   SER   136      83.259 103.791  41.681  1.00 62.28           N  
ATOM   1048  CA  SER   136      84.284 103.751  40.639  1.00 63.96           C  
ATOM   1049  C   SER   136      85.636 103.438  41.283  1.00 64.38           C  
ATOM   1050  O   SER   136      86.423 102.647  40.741  1.00 65.17           O  
ATOM   1051  CB  SER   136      84.355 105.083  39.887  1.00 64.03           C  
ATOM   1052  OG  SER   136      84.767 106.133  40.741  1.00 67.09           O  
ATOM   1053  N   LEU   137      85.880 104.042  42.448  1.00 64.20           N  
ATOM   1054  CA  LEU   137      87.118 103.840  43.199  1.00 64.30           C  
ATOM   1055  C   LEU   137      87.153 102.611  44.128  1.00 63.64           C  
ATOM   1056  O   LEU   137      88.192 102.327  44.717  1.00 63.46           O  
ATOM   1057  CB  LEU   137      87.443 105.078  44.042  1.00 64.99           C  
ATOM   1058  CG  LEU   137      87.910 106.363  43.359  1.00 67.10           C  
ATOM   1059  CD1 LEU   137      89.022 106.027  42.382  1.00 68.80           C  
ATOM   1060  CD2 LEU   137      86.754 107.025  42.647  1.00 70.31           C  
ATOM   1061  N   PHE   138      86.051 101.882  44.282  1.00 62.43           N  
ATOM   1062  CA  PHE   138      86.104 100.728  45.172  1.00 62.24           C  
ATOM   1063  C   PHE   138      87.174  99.736  44.722  1.00 63.75           C  
ATOM   1064  O   PHE   138      87.849  99.132  45.552  1.00 65.01           O  
ATOM   1065  CB  PHE   138      84.746 100.011  45.275  1.00 60.61           C  
ATOM   1066  CG  PHE   138      83.649 100.842  45.899  1.00 55.89           C  
ATOM   1067  CD1 PHE   138      83.911 102.108  46.424  1.00 52.20           C  
ATOM   1068  CD2 PHE   138      82.341 100.363  45.939  1.00 54.02           C  
ATOM   1069  CE1 PHE   138      82.884 102.891  46.974  1.00 50.00           C  
ATOM   1070  CE2 PHE   138      81.306 101.135  46.485  1.00 53.26           C  
ATOM   1071  CZ  PHE   138      81.580 102.401  47.005  1.00 52.41           C  
ATOM   1072  N   ASN   139      87.350  99.558  43.418  1.00 65.81           N  
ATOM   1073  CA  ASN   139      88.372  98.615  42.955  1.00 67.56           C  
ATOM   1074  C   ASN   139      89.744  99.043  43.470  1.00 68.24           C  
ATOM   1075  O   ASN   139      90.535  98.219  43.918  1.00 68.02           O  
ATOM   1076  CB  ASN   139      88.384  98.539  41.433  1.00 67.28           C  
ATOM   1077  N   GLU   140      90.012 100.342  43.413  1.00 69.37           N  
ATOM   1078  CA  GLU   140      91.285 100.880  43.863  1.00 70.51           C  
ATOM   1079  C   GLU   140      91.556 100.634  45.329  1.00 70.69           C  
ATOM   1080  O   GLU   140      92.644 100.196  45.703  1.00 71.04           O  
ATOM   1081  CB  GLU   140      91.342 102.380  43.597  1.00 71.48           C  
ATOM   1082  CG  GLU   140      91.568 102.719  42.147  1.00 74.90           C  
ATOM   1083  CD  GLU   140      92.902 102.195  41.651  1.00 79.72           C  
ATOM   1084  OE1 GLU   140      93.952 102.688  42.138  1.00 80.78           O  
ATOM   1085  OE2 GLU   140      92.894 101.287  40.783  1.00 81.31           O  
ATOM   1086  N   ILE   141      90.568 100.928  46.166  1.00 71.01           N  
ATOM   1087  CA  ILE   141      90.736 100.754  47.598  1.00 70.87           C  
ATOM   1088  C   ILE   141      91.025  99.294  47.941  1.00 70.05           C  
ATOM   1089  O   ILE   141      91.832  99.015  48.828  1.00 70.27           O  
ATOM   1090  CB  ILE   141      89.507 101.342  48.385  1.00 71.02           C  
ATOM   1091  CG1 ILE   141      89.560 100.931  49.851  1.00 72.11           C  
ATOM   1092  CG2 ILE   141      88.219 100.909  47.761  1.00 71.02           C  
ATOM   1093  CD1 ILE   141      88.892  99.606  50.139  1.00 75.02           C  
ATOM   1094  N   GLU   142      90.410  98.365  47.217  1.00 69.37           N  
ATOM   1095  CA  GLU   142      90.659  96.947  47.467  1.00 69.15           C  
ATOM   1096  C   GLU   142      92.147  96.636  47.267  1.00 68.76           C  
ATOM   1097  O   GLU   142      92.722  95.818  47.981  1.00 68.80           O  
ATOM   1098  CB  GLU   142      89.813  96.086  46.535  1.00 68.61           C  
ATOM   1099  N   LYS   143      92.766  97.308  46.299  1.00 68.67           N  
ATOM   1100  CA  LYS   143      94.184  97.113  45.980  1.00 68.20           C  
ATOM   1101  C   LYS   143      95.122  97.568  47.105  1.00 67.70           C  
ATOM   1102  O   LYS   143      96.254  97.090  47.225  1.00 68.14           O  
ATOM   1103  CB  LYS   143      94.525  97.850  44.676  1.00 68.56           C  
ATOM   1104  N   LEU   144      94.645  98.499  47.921  1.00 66.67           N  
ATOM   1105  CA  LEU   144      95.408  99.020  49.049  1.00 65.38           C  
ATOM   1106  C   LEU   144      96.016  97.900  49.921  1.00 64.92           C  
ATOM   1107  O   LEU   144      95.476  96.787  49.994  1.00 64.21           O  
ATOM   1108  CB  LEU   144      94.483  99.898  49.897  1.00 65.48           C  
ATOM   1109  CG  LEU   144      94.824 101.371  50.106  1.00 66.58           C  
ATOM   1110  CD1 LEU   144      95.439 101.960  48.858  1.00 67.08           C  
ATOM   1111  CD2 LEU   144      93.557 102.119  50.485  1.00 66.22           C  
ATOM   1112  N   ARG   145      97.138  98.207  50.578  1.00 64.60           N  
ATOM   1113  CA  ARG   145      97.823  97.256  51.465  1.00 64.15           C  
ATOM   1114  C   ARG   145      98.183  97.860  52.819  1.00 63.00           C  
ATOM   1115  O   ARG   145      98.368  99.075  52.951  1.00 62.62           O  
ATOM   1116  CB  ARG   145      99.101  96.724  50.813  1.00 64.74           C  
ATOM   1117  CG  ARG   145      98.853  95.634  49.791  1.00 69.68           C  
ATOM   1118  CD  ARG   145      99.825  95.721  48.615  1.00 76.97           C  
ATOM   1119  NE  ARG   145     101.228  95.680  49.025  1.00 79.89           N  
ATOM   1120  CZ  ARG   145     101.807  94.649  49.633  1.00 80.04           C  
ATOM   1121  NH1 ARG   145     101.106  93.557  49.911  1.00 77.46           N  
ATOM   1122  NH2 ARG   145     103.091  94.713  49.966  1.00 80.64           N  
ATOM   1123  N   GLY   146      98.270  96.987  53.819  1.00 61.83           N  
ATOM   1124  CA  GLY   146      98.634  97.387  55.168  1.00 59.45           C  
ATOM   1125  C   GLY   146      97.976  98.610  55.772  1.00 58.65           C  
ATOM   1126  O   GLY   146      96.751  98.673  55.929  1.00 57.38           O  
ATOM   1127  N   ASP   147      98.812  99.585  56.120  1.00 57.90           N  
ATOM   1128  CA  ASP   147      98.349 100.817  56.742  1.00 57.47           C  
ATOM   1129  C   ASP   147      98.253 101.992  55.776  1.00 57.66           C  
ATOM   1130  O   ASP   147      98.311 103.150  56.189  1.00 58.10           O  
ATOM   1131  CB  ASP   147      99.268 101.203  57.894  1.00 56.82           C  
ATOM   1132  CG  ASP   147      98.572 102.069  58.919  1.00 58.56           C  
ATOM   1133  OD1 ASP   147      99.230 102.956  59.494  1.00 60.43           O  
ATOM   1134  OD2 ASP   147      97.365 101.852  59.160  1.00 61.44           O  
ATOM   1135  N   VAL   148      98.118 101.695  54.491  1.00 57.82           N  
ATOM   1136  CA  VAL   148      97.990 102.741  53.491  1.00 57.65           C  
ATOM   1137  C   VAL   148      96.523 103.100  53.383  1.00 58.26           C  
ATOM   1138  O   VAL   148      95.702 102.241  53.075  1.00 57.77           O  
ATOM   1139  CB  VAL   148      98.470 102.259  52.130  1.00 57.60           C  
ATOM   1140  CG1 VAL   148      98.224 103.321  51.090  1.00 55.84           C  
ATOM   1141  CG2 VAL   148      99.929 101.907  52.207  1.00 57.70           C  
ATOM   1142  N   GLY   149      96.205 104.367  53.632  1.00 59.53           N  
ATOM   1143  CA  GLY   149      94.829 104.826  53.570  1.00 61.31           C  
ATOM   1144  C   GLY   149      94.349 105.192  52.182  1.00 63.72           C  
ATOM   1145  O   GLY   149      95.051 104.994  51.189  1.00 64.43           O  
ATOM   1146  N   ALA   150      93.147 105.746  52.110  1.00 65.36           N  
ATOM   1147  CA  ALA   150      92.564 106.128  50.831  1.00 67.42           C  
ATOM   1148  C   ALA   150      93.150 107.416  50.231  1.00 68.74           C  
ATOM   1149  O   ALA   150      93.027 107.648  49.025  1.00 68.20           O  
ATOM   1150  CB  ALA   150      91.052 106.251  50.975  1.00 67.32           C  
ATOM   1151  N   ARG   151      93.794 108.241  51.058  1.00 71.18           N  
ATOM   1152  CA  ARG   151      94.378 109.491  50.570  1.00 74.01           C  
ATOM   1153  C   ARG   151      95.388 109.269  49.453  1.00 75.14           C  
ATOM   1154  O   ARG   151      95.635 110.154  48.635  1.00 75.26           O  
ATOM   1155  CB  ARG   151      95.047 110.262  51.702  1.00 74.25           C  
ATOM   1156  CG  ARG   151      95.632 111.606  51.257  1.00 77.89           C  
ATOM   1157  CD  ARG   151      95.776 112.564  52.437  1.00 84.37           C  
ATOM   1158  NE  ARG   151      96.526 111.945  53.525  1.00 89.32           N  
ATOM   1159  CZ  ARG   151      97.811 111.612  53.452  1.00 91.28           C  
ATOM   1160  NH1 ARG   151      98.501 111.848  52.338  1.00 90.83           N  
ATOM   1161  NH2 ARG   151      98.400 111.020  54.487  1.00 92.52           N  
ATOM   1162  N   VAL   152      95.969 108.080  49.420  1.00 76.27           N  
ATOM   1163  CA  VAL   152      96.933 107.758  48.390  1.00 77.39           C  
ATOM   1164  C   VAL   152      96.218 107.653  47.055  1.00 77.89           C  
ATOM   1165  O   VAL   152      96.724 108.117  46.035  1.00 77.93           O  
ATOM   1166  CB  VAL   152      97.636 106.434  48.695  1.00 77.65           C  
ATOM   1167  CG1 VAL   152      98.684 106.155  47.643  1.00 76.78           C  
ATOM   1168  CG2 VAL   152      98.274 106.505  50.072  1.00 80.17           C  
ATOM   1169  N   ILE   153      95.033 107.050  47.069  1.00 78.94           N  
ATOM   1170  CA  ILE   153      94.243 106.886  45.852  1.00 79.79           C  
ATOM   1171  C   ILE   153      93.630 108.209  45.401  1.00 80.54           C  
ATOM   1172  O   ILE   153      93.329 108.391  44.220  1.00 80.78           O  
ATOM   1173  CB  ILE   153      93.086 105.892  46.051  1.00 79.53           C  
ATOM   1174  CG1 ILE   153      93.615 104.580  46.613  1.00 79.70           C  
ATOM   1175  CG2 ILE   153      92.392 105.624  44.723  1.00 78.74           C  
ATOM   1176  CD1 ILE   153      92.523 103.590  46.929  1.00 81.12           C  
ATOM   1177  N   LEU   154      93.443 109.130  46.344  1.00 81.43           N  
ATOM   1178  CA  LEU   154      92.851 110.427  46.027  1.00 81.93           C  
ATOM   1179  C   LEU   154      93.848 111.409  45.398  1.00 83.02           C  
ATOM   1180  O   LEU   154      93.465 112.300  44.639  1.00 83.08           O  
ATOM   1181  CB  LEU   154      92.225 111.044  47.288  1.00 81.24           C  
ATOM   1182  CG  LEU   154      91.005 110.341  47.899  1.00 79.35           C  
ATOM   1183  CD1 LEU   154      90.423 111.199  49.010  1.00 76.84           C  
ATOM   1184  CD2 LEU   154      89.957 110.092  46.833  1.00 78.09           C  
ATOM   1185  N   ASN   155      95.129 111.239  45.700  1.00 84.48           N  
ATOM   1186  CA  ASN   155      96.142 112.132  45.157  1.00 85.67           C  
ATOM   1187  C   ASN   155      96.621 111.689  43.787  1.00 86.38           C  
ATOM   1188  O   ASN   155      97.555 112.265  43.236  1.00 87.30           O  
ATOM   1189  CB  ASN   155      97.325 112.227  46.121  1.00 85.40           C  
ATOM   1190  CG  ASN   155      96.916 112.754  47.478  1.00 86.53           C  
ATOM   1191  OD1 ASN   155      96.189 113.743  47.572  1.00 89.43           O  
ATOM   1192  ND2 ASN   155      97.381 112.102  48.538  1.00 88.56           N  
ATOM   1193  N   LYS   156      95.978 110.669  43.234  1.00 86.65           N  
ATOM   1194  CA  LYS   156      96.355 110.163  41.924  1.00 87.07           C  
ATOM   1195  C   LYS   156      95.167 110.174  40.964  1.00 88.18           C  
ATOM   1196  O   LYS   156      95.101 109.362  40.039  1.00 88.52           O  
ATOM   1197  CB  LYS   156      96.917 108.754  42.049  1.00 86.22           C  
ATOM   1198  N   ILE   157      94.216 111.076  41.192  1.00 89.25           N  
ATOM   1199  CA  ILE   157      93.061 111.177  40.306  1.00 90.64           C  
ATOM   1200  C   ILE   157      92.924 112.613  39.819  1.00 91.38           C  
ATOM   1201  O   ILE   157      93.121 113.564  40.587  1.00 91.57           O  
ATOM   1202  CB  ILE   157      91.731 110.739  40.989  1.00 90.77           C  
ATOM   1203  CG1 ILE   157      91.471 111.576  42.236  1.00 91.50           C  
ATOM   1204  CG2 ILE   157      91.781 109.258  41.332  1.00 90.73           C  
ATOM   1205  CD1 ILE   157      90.091 111.361  42.823  1.00 92.69           C  
ATOM   1206  N   LYS   158      92.593 112.748  38.535  1.00 91.96           N  
ATOM   1207  CA  LYS   158      92.438 114.037  37.862  1.00 92.43           C  
ATOM   1208  C   LYS   158      91.547 115.037  38.592  1.00 92.49           C  
ATOM   1209  O   LYS   158      90.382 114.753  38.871  1.00 92.57           O  
ATOM   1210  CB  LYS   158      91.908 113.810  36.451  1.00 92.67           C  
ATOM   1211  N   ILE   159      92.100 116.215  38.877  1.00 92.42           N  
ATOM   1212  CA  ILE   159      91.364 117.269  39.573  1.00 93.01           C  
ATOM   1213  C   ILE   159      90.042 117.573  38.853  1.00 93.01           C  
ATOM   1214  O   ILE   159      89.114 118.143  39.440  1.00 93.13           O  
ATOM   1215  CB  ILE   159      92.188 118.581  39.649  1.00 93.16           C  
ATOM   1216  CG1 ILE   159      93.679 118.262  39.744  1.00 93.98           C  
ATOM   1217  CG2 ILE   159      91.762 119.392  40.874  1.00 92.59           C  
ATOM   1218  CD1 ILE   159      94.577 119.483  39.653  1.00 94.92           C  
ATOM   1219  N   GLU   160      89.963 117.196  37.579  1.00 92.43           N  
ATOM   1220  CA  GLU   160      88.762 117.430  36.794  1.00 91.90           C  
ATOM   1221  C   GLU   160      87.733 116.371  37.149  1.00 91.72           C  
ATOM   1222  O   GLU   160      86.686 116.271  36.510  1.00 91.47           O  
ATOM   1223  CB  GLU   160      89.089 117.375  35.303  1.00 91.77           C  
ATOM   1224  N   GLU   161      88.037 115.586  38.180  1.00 91.67           N  
ATOM   1225  CA  GLU   161      87.147 114.517  38.625  1.00 91.68           C  
ATOM   1226  C   GLU   161      86.845 114.537  40.126  1.00 90.79           C  
ATOM   1227  O   GLU   161      85.991 113.785  40.602  1.00 90.51           O  
ATOM   1228  CB  GLU   161      87.730 113.160  38.217  1.00 92.12           C  
ATOM   1229  CG  GLU   161      87.775 112.968  36.707  1.00 93.63           C  
ATOM   1230  CD  GLU   161      88.567 111.747  36.282  1.00 96.44           C  
ATOM   1231  OE1 GLU   161      89.811 111.760  36.419  1.00 95.88           O  
ATOM   1232  OE2 GLU   161      87.940 110.775  35.811  1.00 98.07           O  
ATOM   1233  N   LEU   162      87.548 115.385  40.871  1.00 89.70           N  
ATOM   1234  CA  LEU   162      87.294 115.503  42.300  1.00 89.10           C  
ATOM   1235  C   LEU   162      86.207 116.551  42.486  1.00 88.72           C  
ATOM   1236  O   LEU   162      85.885 117.288  41.560  1.00 89.15           O  
ATOM   1237  CB  LEU   162      88.553 115.929  43.061  1.00 89.13           C  
ATOM   1238  CG  LEU   162      89.606 114.852  43.310  1.00 89.45           C  
ATOM   1239  CD1 LEU   162      90.307 114.543  42.011  1.00 91.38           C  
ATOM   1240  CD2 LEU   162      90.605 115.324  44.347  1.00 88.04           C  
ATOM   1241  N   CYS   163      85.637 116.614  43.681  1.00 88.09           N  
ATOM   1242  CA  CYS   163      84.587 117.580  43.968  1.00 87.74           C  
ATOM   1243  C   CYS   163      84.738 118.035  45.410  1.00 86.55           C  
ATOM   1244  O   CYS   163      84.544 117.260  46.342  1.00 87.43           O  
ATOM   1245  CB  CYS   163      83.212 116.942  43.719  1.00 87.82           C  
ATOM   1246  SG  CYS   163      82.989 116.485  41.964  1.00 91.64           S  
ATOM   1247  N   PHE   164      85.096 119.298  45.590  1.00 84.52           N  
ATOM   1248  CA  PHE   164      85.305 119.839  46.919  1.00 83.15           C  
ATOM   1249  C   PHE   164      84.154 120.712  47.388  1.00 83.06           C  
ATOM   1250  O   PHE   164      83.250 121.019  46.622  1.00 83.89           O  
ATOM   1251  CB  PHE   164      86.589 120.658  46.921  1.00 82.45           C  
ATOM   1252  CG  PHE   164      87.750 119.951  46.296  1.00 82.05           C  
ATOM   1253  CD1 PHE   164      88.496 119.028  47.023  1.00 82.19           C  
ATOM   1254  CD2 PHE   164      88.092 120.191  44.975  1.00 81.98           C  
ATOM   1255  CE1 PHE   164      89.567 118.349  46.436  1.00 80.81           C  
ATOM   1256  CE2 PHE   164      89.158 119.517  44.382  1.00 82.43           C  
ATOM   1257  CZ  PHE   164      89.899 118.596  45.116  1.00 80.76           C  
ATOM   1258  N   ILE   165      84.194 121.082  48.665  1.00 82.73           N  
ATOM   1259  CA  ILE   165      83.211 121.965  49.289  1.00 82.62           C  
ATOM   1260  C   ILE   165      83.750 122.403  50.634  1.00 82.13           C  
ATOM   1261  O   ILE   165      84.364 121.619  51.355  1.00 82.40           O  
ATOM   1262  CB  ILE   165      81.819 121.317  49.546  1.00 82.92           C  
ATOM   1263  CG1 ILE   165      81.972 119.925  50.151  1.00 84.16           C  
ATOM   1264  CG2 ILE   165      81.006 121.307  48.272  1.00 84.02           C  
ATOM   1265  CD1 ILE   165      82.258 118.853  49.132  1.00 85.27           C  
ATOM   1266  N   GLU   166      83.519 123.664  50.965  1.00 81.04           N  
ATOM   1267  CA  GLU   166      83.980 124.201  52.224  1.00 80.04           C  
ATOM   1268  C   GLU   166      83.012 123.838  53.317  1.00 78.84           C  
ATOM   1269  O   GLU   166      81.819 124.131  53.224  1.00 79.05           O  
ATOM   1270  CB  GLU   166      84.098 125.715  52.143  1.00 80.39           C  
ATOM   1271  CG  GLU   166      85.356 126.183  51.475  1.00 81.73           C  
ATOM   1272  CD  GLU   166      86.570 126.002  52.358  1.00 84.18           C  
ATOM   1273  OE1 GLU   166      86.607 126.634  53.445  1.00 81.27           O  
ATOM   1274  OE2 GLU   166      87.480 125.233  51.962  1.00 87.18           O  
ATOM   1275  N   CYS   167      83.534 123.188  54.350  1.00 77.43           N  
ATOM   1276  CA  CYS   167      82.735 122.793  55.498  1.00 75.91           C  
ATOM   1277  C   CYS   167      83.425 123.449  56.682  1.00 75.37           C  
ATOM   1278  O   CYS   167      84.381 124.194  56.486  1.00 75.36           O  
ATOM   1279  CB  CYS   167      82.721 121.273  55.624  1.00 75.12           C  
ATOM   1280  SG  CYS   167      82.137 120.444  54.115  1.00 74.97           S  
ATOM   1281  N   SER   168      82.950 123.196  57.896  1.00 74.67           N  
ATOM   1282  CA  SER   168      83.546 123.796  59.087  1.00 74.46           C  
ATOM   1283  C   SER   168      84.979 123.341  59.315  1.00 74.78           C  
ATOM   1284  O   SER   168      85.503 122.490  58.590  1.00 74.75           O  
ATOM   1285  CB  SER   168      82.711 123.466  60.324  1.00 74.60           C  
ATOM   1286  OG  SER   168      82.611 122.068  60.524  1.00 75.49           O  
ATOM   1287  N   GLU   169      85.621 123.909  60.328  1.00 74.91           N  
ATOM   1288  CA  GLU   169      86.993 123.531  60.624  1.00 75.60           C  
ATOM   1289  C   GLU   169      87.033 122.111  61.208  1.00 75.03           C  
ATOM   1290  O   GLU   169      88.088 121.463  61.235  1.00 74.81           O  
ATOM   1291  CB  GLU   169      87.621 124.531  61.599  1.00 75.85           C  
ATOM   1292  CG  GLU   169      86.996 124.527  62.974  1.00 78.98           C  
ATOM   1293  CD  GLU   169      87.788 125.349  63.971  1.00 84.36           C  
ATOM   1294  OE1 GLU   169      89.031 125.397  63.838  1.00 85.45           O  
ATOM   1295  OE2 GLU   169      87.173 125.926  64.895  1.00 86.32           O  
ATOM   1296  N   GLY   170      85.872 121.634  61.661  1.00 74.49           N  
ATOM   1297  CA  GLY   170      85.775 120.301  62.230  1.00 73.18           C  
ATOM   1298  C   GLY   170      86.207 119.243  61.235  1.00 72.55           C  
ATOM   1299  O   GLY   170      86.525 118.121  61.612  1.00 73.48           O  
ATOM   1300  N   VAL   171      86.216 119.606  59.961  1.00 71.29           N  
ATOM   1301  CA  VAL   171      86.618 118.706  58.894  1.00 70.37           C  
ATOM   1302  C   VAL   171      88.126 118.515  58.897  1.00 69.66           C  
ATOM   1303  O   VAL   171      88.662 117.689  58.156  1.00 68.11           O  
ATOM   1304  CB  VAL   171      86.207 119.282  57.534  1.00 71.15           C  
ATOM   1305  CG1 VAL   171      86.843 118.491  56.404  1.00 72.17           C  
ATOM   1306  CG2 VAL   171      84.702 119.258  57.411  1.00 71.59           C  
ATOM   1307  N   LEU   172      88.808 119.284  59.740  1.00 70.43           N  
ATOM   1308  CA  LEU   172      90.262 119.220  59.819  1.00 71.06           C  
ATOM   1309  C   LEU   172      90.784 118.808  61.188  1.00 71.89           C  
ATOM   1310  O   LEU   172      91.947 118.422  61.330  1.00 72.18           O  
ATOM   1311  CB  LEU   172      90.859 120.579  59.460  1.00 70.49           C  
ATOM   1312  CG  LEU   172      90.604 121.171  58.072  1.00 71.03           C  
ATOM   1313  CD1 LEU   172      91.313 122.497  57.991  1.00 69.40           C  
ATOM   1314  CD2 LEU   172      91.105 120.243  56.971  1.00 72.40           C  
ATOM   1315  N   ILE   173      89.920 118.877  62.191  1.00 72.89           N  
ATOM   1316  CA  ILE   173      90.302 118.553  63.556  1.00 74.89           C  
ATOM   1317  C   ILE   173      89.966 117.147  64.029  1.00 75.88           C  
ATOM   1318  O   ILE   173      88.888 116.631  63.764  1.00 77.01           O  
ATOM   1319  CB  ILE   173      89.634 119.534  64.529  1.00 74.91           C  
ATOM   1320  CG1 ILE   173      89.966 120.971  64.114  1.00 75.25           C  
ATOM   1321  CG2 ILE   173      90.062 119.233  65.966  1.00 75.63           C  
ATOM   1322  CD1 ILE   173      89.124 122.017  64.825  1.00 77.55           C  
ATOM   1323  N   ASP   174      90.900 116.536  64.742  1.00 77.31           N  
ATOM   1324  CA  ASP   174      90.693 115.212  65.312  1.00 78.94           C  
ATOM   1325  C   ASP   174      91.163 115.357  66.754  1.00 79.67           C  
ATOM   1326  O   ASP   174      91.927 116.269  67.053  1.00 79.46           O  
ATOM   1327  CB  ASP   174      91.515 114.159  64.575  1.00 79.22           C  
ATOM   1328  CG  ASP   174      92.986 114.352  64.757  1.00 80.14           C  
ATOM   1329  OD1 ASP   174      93.473 114.155  65.890  1.00 84.16           O  
ATOM   1330  OD2 ASP   174      93.654 114.714  63.769  1.00 82.30           O  
ATOM   1331  N   ILE   175      90.709 114.474  67.640  1.00 80.72           N  
ATOM   1332  CA  ILE   175      91.065 114.561  69.055  1.00 81.80           C  
ATOM   1333  C   ILE   175      92.454 115.112  69.310  1.00 83.81           C  
ATOM   1334  O   ILE   175      92.608 116.069  70.067  1.00 84.37           O  
ATOM   1335  CB  ILE   175      90.933 113.211  69.766  1.00 81.18           C  
ATOM   1336  CG1 ILE   175      89.501 112.710  69.642  1.00 80.88           C  
ATOM   1337  CG2 ILE   175      91.239 113.373  71.235  1.00 78.89           C  
ATOM   1338  CD1 ILE   175      88.482 113.718  70.110  1.00 80.65           C  
ATOM   1339  N   ASP   176      93.462 114.527  68.675  1.00 85.66           N  
ATOM   1340  CA  ASP   176      94.826 115.003  68.853  1.00 87.67           C  
ATOM   1341  C   ASP   176      94.997 116.454  68.411  1.00 88.57           C  
ATOM   1342  O   ASP   176      95.491 117.284  69.176  1.00 88.51           O  
ATOM   1343  CB  ASP   176      95.794 114.119  68.078  1.00 88.25           C  
ATOM   1344  CG  ASP   176      95.807 112.694  68.588  1.00 91.14           C  
ATOM   1345  OD1 ASP   176      96.135 112.497  69.785  1.00 94.37           O  
ATOM   1346  OD2 ASP   176      95.487 111.777  67.793  1.00 93.54           O  
ATOM   1347  N   LYS   177      94.579 116.758  67.182  1.00 89.58           N  
ATOM   1348  CA  LYS   177      94.696 118.112  66.627  1.00 90.14           C  
ATOM   1349  C   LYS   177      94.159 119.185  67.567  1.00 90.65           C  
ATOM   1350  O   LYS   177      94.568 120.342  67.494  1.00 91.35           O  
ATOM   1351  CB  LYS   177      93.983 118.193  65.279  1.00 89.55           C  
ATOM   1352  N   LYS   178      93.238 118.801  68.444  1.00 90.82           N  
ATOM   1353  CA  LYS   178      92.670 119.738  69.400  1.00 91.07           C  
ATOM   1354  C   LYS   178      93.395 119.565  70.731  1.00 91.59           C  
ATOM   1355  O   LYS   178      92.770 119.099  71.711  1.00 92.20           O  
ATOM   1356  CB  LYS   178      91.170 119.489  69.564  1.00 90.86           C  
END
