
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  970),  selected  126 , name 2dyy_D
# Molecule2: number of CA atoms  152 ( 1118),  selected  152 , name T0423.pdb
# PARAMETERS: 2dyy_D.T0423.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_D      M       1           -
LGA    K     2_D      S       2           -
LGA    E     3_D      D       3           -
LGA    V     4_D      V       4           -
LGA    I     5_D      I       5           -
LGA    F     6_D      E       6           -
LGA    T     7_D      G       7           -
LGA    E     8_D      R       8           -
LGA    -       -      L       9           -
LGA    -       -      K      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      G      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      L      16           -
LGA    N     9_D      P      17          3.076
LGA    A    10_D      V      18          4.971
LGA    P    11_D      -       -           -
LGA    K    12_D      -       -           -
LGA    P    13_D      -       -           -
LGA    I    14_D      A      23           #
LGA    G    15_D      A      24           #
LGA    P    16_D      N      25          3.005
LGA    Y    17_D      Y      26          1.386
LGA    S    18_D      V      27          0.985
LGA    Q    19_D      P      28          0.894
LGA    A    20_D      F      29          0.705
LGA    I    21_D      T      30          1.234
LGA    K    22_D      I      31          1.752
LGA    A    23_D      S      32          2.243
LGA    G    24_D      G      33          1.924
LGA    N    25_D      N      34          1.230
LGA    F    26_D      L      35          1.408
LGA    L    27_D      L      36          0.666
LGA    F    28_D      Y      37          0.814
LGA    I    29_D      V      38          0.366
LGA    A    30_D      S      39          0.452
LGA    G    31_D      G      40          0.560
LGA    Q    32_D      Q      41          0.492
LGA    I    33_D      L      42          0.758
LGA    P    34_D      P      43          0.948
LGA    I    35_D      M      44          1.558
LGA    D    36_D      E      45          1.693
LGA    P    37_D      -       -           -
LGA    K    38_D      -       -           -
LGA    T    39_D      S      46          2.314
LGA    G    40_D      G      47          1.538
LGA    E    41_D      K      48          0.829
LGA    I    42_D      I      49          0.819
LGA    V    43_D      A      50          0.724
LGA    K    44_D      V      51          3.628
LGA    -       -      T      52           -
LGA    -       -      G      53           -
LGA    -       -      L      54           -
LGA    -       -      V      55           -
LGA    -       -      G      56           -
LGA    -       -      R      57           -
LGA    -       -      D      58           -
LGA    G    45_D      V      59          5.252
LGA    -       -      D      60           -
LGA    -       -      V      61           -
LGA    -       -      A      62           -
LGA    D    46_D      S      63          1.954
LGA    I    47_D      A      64          0.414
LGA    K    48_D      Q      65          1.986
LGA    D    49_D      R      66          1.872
LGA    Q    50_D      A      67          0.887
LGA    T    51_D      A      68          0.944
LGA    R    52_D      E      69          1.149
LGA    Q    53_D      L      70          0.837
LGA    V    54_D      C      71          0.516
LGA    L    55_D      A      72          0.682
LGA    E    56_D      V      73          0.504
LGA    N    57_D      N      74          0.584
LGA    I    58_D      I      75          0.618
LGA    K    59_D      L      76          1.019
LGA    A    60_D      A      77          1.110
LGA    I    61_D      Q      78          1.034
LGA    L    62_D      V      79          1.208
LGA    E    63_D      K      80          1.531
LGA    A    64_D      A      81          1.780
LGA    A    65_D      A      82          1.746
LGA    G    66_D      L      83          1.973
LGA    -       -      N      84           -
LGA    -       -      G      85           -
LGA    -       -      D      86           -
LGA    -       -      L      87           -
LGA    -       -      S      88           -
LGA    Y    67_D      K      89          3.927
LGA    S    68_D      I      90          3.152
LGA    L    69_D      -       -           -
LGA    N    70_D      R      91          5.189
LGA    D    71_D      R      92          2.310
LGA    V    72_D      V      93          1.233
LGA    I    73_D      I      94          0.540
LGA    K    74_D      K      95          1.320
LGA    V    75_D      L      96          1.301
LGA    T    76_D      N      97          0.908
LGA    V    77_D      G      98          0.996
LGA    Y    78_D      F      99          0.919
LGA    L    79_D      V     100          1.207
LGA    K    80_D      A     101          1.398
LGA    D    81_D      S     102          2.085
LGA    -       -      V     103           -
LGA    -       -      P     104           -
LGA    -       -      E     105           -
LGA    M    82_D      F     106          4.089
LGA    N    83_D      V     107          3.411
LGA    D    84_D      E     108          3.831
LGA    F    85_D      Q     109          2.168
LGA    A    86_D      H     110          4.815
LGA    K    87_D      L     111          4.110
LGA    M    88_D      V     112          2.081
LGA    N    89_D      I     113          4.086
LGA    E    90_D      N     114          3.811
LGA    V    91_D      G     115          2.363
LGA    Y    92_D      A     116          2.756
LGA    -       -      S     117           -
LGA    A    93_D      N     118          1.634
LGA    E    94_D      L     119          2.711
LGA    Y    95_D      I     120          1.189
LGA    F    96_D      A     121          2.852
LGA    G    97_D      T     122           #
LGA    -       -      V     123           -
LGA    -       -      L     124           -
LGA    E    98_D      G     125          3.834
LGA    S    99_D      E     126          4.035
LGA    -       -      P     127           -
LGA    -       -      G     128           -
LGA    K   100_D      R     129          1.836
LGA    P   101_D      H     130          1.345
LGA    A   102_D      A     131          1.457
LGA    R   103_D      R     132          1.226
LGA    V   104_D      A     133          1.628
LGA    A   105_D      A     134          1.697
LGA    V   106_D      V     135          1.525
LGA    E   107_D      G     136          1.357
LGA    V   108_D      M     137          1.750
LGA    S   109_D      A     138          1.623
LGA    R   110_D      S     139          1.615
LGA    L   111_D      L     140          1.116
LGA    P   112_D      P     141          0.921
LGA    K   113_D      F     142          1.121
LGA    D   114_D      N     143          1.485
LGA    V   115_D      A     144          1.161
LGA    L   116_D      S     145          1.263
LGA    I   117_D      V     146          0.869
LGA    E   118_D      E     147          0.740
LGA    I   119_D      I     148          0.584
LGA    E   120_D      D     149          0.667
LGA    A   121_D      A     150          0.403
LGA    I   122_D      I     151          0.605
LGA    A   123_D      V     152          0.949
LGA    Y   124_D      E     153          1.216
LGA    K   125_D      I     154          2.091
LGA    E   126_D      D     155          4.660
LGA    -       -      V     156           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  152    5.0    109    2.11    24.77     56.535     4.937

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.419321 * X  +  -0.688721 * Y  +  -0.591467 * Z  +  89.796829
  Y_new =   0.266095 * X  +  -0.529655 * Y  +   0.805394 * Z  + -15.988329
  Z_new =  -0.867965 * X  +  -0.495105 * Y  +  -0.038830 * Z  +  79.429276 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.649065    1.492528  [ DEG:   -94.4844     85.5156 ]
  Theta =   1.051089    2.090503  [ DEG:    60.2230    119.7770 ]
  Phi   =   0.565463   -2.576130  [ DEG:    32.3986   -147.6014 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dyy_D                                        
REMARK     2: T0423.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dyy_D.T0423.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  152   5.0  109   2.11   24.77  56.535
REMARK  ---------------------------------------------------------- 
MOLECULE 2dyy_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   19-SEP-06   2DYY              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION INITIATION                  
TITLE    2 INHIBITOR PH0854 FROM PYROCOCCUS HORIKOSHII                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0076 PROTEIN PH0854;                                    
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J, K, L;                           
COMPND   4 SYNONYM: PUTATIVE TRANSLATION INITIATION INHIBITOR;                  
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21-CODONPLUS (DE3)-RIL;                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    PUTATIVE TRANSLATION INITIATION INHIBITOR, PYROCOCCUS                 
KEYWDS   2 HORIKOSHII, TRIMER, STRUCTURAL GENOMICS, NPPSFA, NATIONAL            
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,B.C.WANG,           
AUTHOR   2 M.SHIROUZU,Y.BESSHO,S.YOKOYAMA,RIKEN STRUCTURAL                      
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   04-SEP-07 2DYY    1       AUTHOR                                   
REVDAT   1   19-MAR-07 2DYY    0                                                
JRNL        AUTH   IHSANAWATI,S.KISHISHITA,K.MURAYAMA,L.CHEN,Z.J.LIU,           
JRNL        AUTH 2 B.C.WANG,M.SHIROUZU,Y.BESSHO,S.YOKOYAMA                      
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSLATION                    
JRNL        TITL 2 INITIATION INHIBITOR PH0854 FROM PYROCOCCUS                  
JRNL        TITL 3 HORIKOSHII                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  2DYY A    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY B    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY C    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY D    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY E    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY F    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY G    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY H    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY I    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY J    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY K    1   126  UNP    O58584   Y854_PYRHO       1    126             
DBREF  2DYY L    1   126  UNP    O58584   Y854_PYRHO       1    126             
SEQRES   1 A  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 A  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 A  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 A  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 A  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 A  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 A  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 A  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 A  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 A  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 B  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 B  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 B  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 B  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 B  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 B  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 B  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 B  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 B  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 B  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 C  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 C  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 C  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 C  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 C  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 C  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 C  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 C  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 C  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 C  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 D  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 D  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 D  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 D  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 D  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 D  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 D  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 D  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 D  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 D  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 E  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 E  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 E  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 E  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 E  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 E  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 E  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 E  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 E  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 E  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 F  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 F  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 F  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 F  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 F  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 F  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 F  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 F  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 F  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 F  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 G  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 G  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 G  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 G  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 G  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 G  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 G  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 G  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 G  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 G  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 H  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 H  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 H  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 H  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 H  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 H  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 H  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 H  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 H  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 H  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 I  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 I  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 I  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 I  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 I  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 I  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 I  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 I  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 I  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 I  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 J  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 J  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 J  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 J  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 J  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 J  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 J  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 J  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 J  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 J  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 K  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 K  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 K  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 K  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 K  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 K  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 K  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 K  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 K  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 K  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
SEQRES   1 L  126  MET LYS GLU VAL ILE PHE THR GLU ASN ALA PRO LYS PRO          
SEQRES   2 L  126  ILE GLY PRO TYR SER GLN ALA ILE LYS ALA GLY ASN PHE          
SEQRES   3 L  126  LEU PHE ILE ALA GLY GLN ILE PRO ILE ASP PRO LYS THR          
SEQRES   4 L  126  GLY GLU ILE VAL LYS GLY ASP ILE LYS ASP GLN THR ARG          
SEQRES   5 L  126  GLN VAL LEU GLU ASN ILE LYS ALA ILE LEU GLU ALA ALA          
SEQRES   6 L  126  GLY TYR SER LEU ASN ASP VAL ILE LYS VAL THR VAL TYR          
SEQRES   7 L  126  LEU LYS ASP MET ASN ASP PHE ALA LYS MET ASN GLU VAL          
SEQRES   8 L  126  TYR ALA GLU TYR PHE GLY GLU SER LYS PRO ALA ARG VAL          
SEQRES   9 L  126  ALA VAL GLU VAL SER ARG LEU PRO LYS ASP VAL LEU ILE          
SEQRES  10 L  126  GLU ILE GLU ALA ILE ALA TYR LYS GLU                          
FORMUL  13  HOH   *233(H2 O)                                                    
CRYST1   92.490   43.090  170.210  90.00  91.51  90.00 P 1 2 1      24          
ATOM   2818  N   MET D   1      56.625  40.789  29.833  1.00 54.09           N  
ATOM   2819  CA  MET D   1      56.297  41.501  31.102  1.00 55.51           C  
ATOM   2820  C   MET D   1      57.568  41.892  31.858  1.00 52.54           C  
ATOM   2821  O   MET D   1      58.667  41.475  31.490  1.00 51.40           O  
ATOM   2822  CB  MET D   1      55.401  40.616  31.981  1.00 59.41           C  
ATOM   2823  CG  MET D   1      55.028  41.223  33.339  1.00 65.00           C  
ATOM   2824  SD  MET D   1      54.338  42.909  33.267  1.00 71.83           S  
ATOM   2825  CE  MET D   1      54.744  43.536  34.944  1.00 69.78           C  
ATOM   2826  N   LYS D   2      57.410  42.689  32.914  1.00 49.71           N  
ATOM   2827  CA  LYS D   2      58.548  43.151  33.702  1.00 47.52           C  
ATOM   2828  C   LYS D   2      58.527  42.779  35.192  1.00 44.72           C  
ATOM   2829  O   LYS D   2      57.528  42.986  35.885  1.00 45.32           O  
ATOM   2830  CB  LYS D   2      58.671  44.668  33.573  1.00 48.31           C  
ATOM   2831  CG  LYS D   2      59.995  45.209  34.064  1.00 49.98           C  
ATOM   2832  CD  LYS D   2      59.999  46.727  34.158  1.00 50.51           C  
ATOM   2833  CE  LYS D   2      59.168  47.219  35.328  1.00 50.29           C  
ATOM   2834  NZ  LYS D   2      59.535  48.620  35.679  1.00 52.69           N  
ATOM   2835  N   GLU D   3      59.647  42.237  35.668  1.00 40.87           N  
ATOM   2836  CA  GLU D   3      59.820  41.851  37.068  1.00 36.93           C  
ATOM   2837  C   GLU D   3      61.095  42.490  37.631  1.00 33.60           C  
ATOM   2838  O   GLU D   3      62.136  42.516  36.971  1.00 31.08           O  
ATOM   2839  CB  GLU D   3      59.939  40.330  37.220  1.00 39.68           C  
ATOM   2840  CG  GLU D   3      58.701  39.515  36.887  1.00 45.30           C  
ATOM   2841  CD  GLU D   3      58.407  39.452  35.399  1.00 49.63           C  
ATOM   2842  OE1 GLU D   3      59.327  39.104  34.621  1.00 51.82           O  
ATOM   2843  OE2 GLU D   3      57.255  39.744  35.011  1.00 49.93           O  
ATOM   2844  N   VAL D   4      61.005  43.002  38.850  1.00 30.79           N  
ATOM   2845  CA  VAL D   4      62.144  43.613  39.527  1.00 29.38           C  
ATOM   2846  C   VAL D   4      62.725  42.540  40.451  1.00 28.47           C  
ATOM   2847  O   VAL D   4      62.056  42.078  41.366  1.00 28.17           O  
ATOM   2848  CB  VAL D   4      61.701  44.840  40.377  1.00 29.57           C  
ATOM   2849  CG1 VAL D   4      62.869  45.369  41.182  1.00 26.62           C  
ATOM   2850  CG2 VAL D   4      61.138  45.927  39.473  1.00 27.49           C  
ATOM   2851  N   ILE D   5      63.973  42.159  40.204  1.00 25.84           N  
ATOM   2852  CA  ILE D   5      64.646  41.125  40.973  1.00 24.96           C  
ATOM   2853  C   ILE D   5      65.374  41.622  42.235  1.00 26.46           C  
ATOM   2854  O   ILE D   5      65.962  42.706  42.255  1.00 27.57           O  
ATOM   2855  CB  ILE D   5      65.682  40.353  40.047  1.00 24.59           C  
ATOM   2856  CG1 ILE D   5      64.994  39.208  39.288  1.00 24.50           C  
ATOM   2857  CG2 ILE D   5      66.813  39.737  40.878  1.00 19.66           C  
ATOM   2858  CD1 ILE D   5      63.863  39.613  38.373  1.00 23.99           C  
ATOM   2859  N   PHE D   6      65.313  40.827  43.297  1.00 25.99           N  
ATOM   2860  CA  PHE D   6      66.029  41.156  44.527  1.00 26.09           C  
ATOM   2861  C   PHE D   6      66.430  39.901  45.268  1.00 25.51           C  
ATOM   2862  O   PHE D   6      65.574  39.103  45.671  1.00 25.68           O  
ATOM   2863  CB  PHE D   6      65.227  42.027  45.500  1.00 25.14           C  
ATOM   2864  CG  PHE D   6      66.013  42.380  46.728  1.00 25.14           C  
ATOM   2865  CD1 PHE D   6      67.030  43.328  46.664  1.00 27.90           C  
ATOM   2866  CD2 PHE D   6      65.859  41.647  47.901  1.00 26.62           C  
ATOM   2867  CE1 PHE D   6      67.898  43.530  47.752  1.00 28.84           C  
ATOM   2868  CE2 PHE D   6      66.711  41.834  48.987  1.00 25.56           C  
ATOM   2869  CZ  PHE D   6      67.738  42.777  48.913  1.00 27.30           C  
ATOM   2870  N   THR D   7      67.736  39.745  45.454  1.00 24.28           N  
ATOM   2871  CA  THR D   7      68.299  38.602  46.153  1.00 24.35           C  
ATOM   2872  C   THR D   7      69.254  39.076  47.249  1.00 25.64           C  
ATOM   2873  O   THR D   7      70.007  40.035  47.058  1.00 26.90           O  
ATOM   2874  CB  THR D   7      69.064  37.675  45.171  1.00 25.22           C  
ATOM   2875  OG1 THR D   7      69.727  36.638  45.902  1.00 26.51           O  
ATOM   2876  CG2 THR D   7      70.106  38.455  44.383  1.00 24.00           C  
ATOM   2877  N   GLU D   8      69.220  38.402  48.392  1.00 26.31           N  
ATOM   2878  CA  GLU D   8      70.094  38.735  49.514  1.00 27.62           C  
ATOM   2879  C   GLU D   8      71.499  38.183  49.245  1.00 27.65           C  
ATOM   2880  O   GLU D   8      72.426  38.411  50.022  1.00 26.83           O  
ATOM   2881  CB  GLU D   8      69.556  38.111  50.799  1.00 29.44           C  
ATOM   2882  CG  GLU D   8      69.745  38.961  52.030  1.00 35.07           C  
ATOM   2883  CD  GLU D   8      68.666  40.014  52.164  1.00 37.45           C  
ATOM   2884  OE1 GLU D   8      67.482  39.641  52.040  1.00 40.64           O  
ATOM   2885  OE2 GLU D   8      68.992  41.201  52.396  1.00 36.72           O  
ATOM   2886  N   ASN D   9      71.637  37.448  48.143  1.00 26.94           N  
ATOM   2887  CA  ASN D   9      72.906  36.851  47.760  1.00 25.92           C  
ATOM   2888  C   ASN D   9      73.800  37.835  47.019  1.00 26.94           C  
ATOM   2889  O   ASN D   9      74.935  37.517  46.699  1.00 28.86           O  
ATOM   2890  CB  ASN D   9      72.664  35.624  46.891  1.00 26.57           C  
ATOM   2891  CG  ASN D   9      71.910  34.534  47.622  1.00 27.96           C  
ATOM   2892  OD1 ASN D   9      72.292  34.147  48.715  1.00 31.59           O  
ATOM   2893  ND2 ASN D   9      70.840  34.031  47.018  1.00 27.40           N  
ATOM   2894  N   ALA D  10      73.284  39.021  46.727  1.00 26.57           N  
ATOM   2895  CA  ALA D  10      74.079  40.040  46.056  1.00 26.49           C  
ATOM   2896  C   ALA D  10      73.939  41.309  46.881  1.00 28.30           C  
ATOM   2897  O   ALA D  10      72.997  41.451  47.659  1.00 26.62           O  
ATOM   2898  CB  ALA D  10      73.585  40.270  44.637  1.00 25.03           C  
ATOM   2899  N   PRO D  11      74.872  42.257  46.713  1.00 30.01           N  
ATOM   2900  CA  PRO D  11      74.849  43.517  47.455  1.00 30.57           C  
ATOM   2901  C   PRO D  11      73.539  44.271  47.313  1.00 32.57           C  
ATOM   2902  O   PRO D  11      73.069  44.495  46.202  1.00 32.51           O  
ATOM   2903  CB  PRO D  11      76.018  44.293  46.852  1.00 29.79           C  
ATOM   2904  CG  PRO D  11      76.940  43.216  46.376  1.00 29.79           C  
ATOM   2905  CD  PRO D  11      75.985  42.242  45.752  1.00 29.09           C  
ATOM   2906  N   LYS D  12      72.960  44.659  48.444  1.00 35.75           N  
ATOM   2907  CA  LYS D  12      71.711  45.410  48.446  1.00 39.21           C  
ATOM   2908  C   LYS D  12      71.953  46.844  47.995  1.00 40.07           C  
ATOM   2909  O   LYS D  12      72.807  47.527  48.544  1.00 40.25           O  
ATOM   2910  CB  LYS D  12      71.105  45.422  49.850  1.00 40.93           C  
ATOM   2911  CG  LYS D  12      69.885  46.321  49.982  1.00 43.57           C  
ATOM   2912  CD  LYS D  12      69.315  46.274  51.393  1.00 48.72           C  
ATOM   2913  CE  LYS D  12      68.147  47.235  51.536  1.00 50.69           C  
ATOM   2914  NZ  LYS D  12      67.101  46.972  50.499  1.00 53.98           N  
ATOM   2915  N   PRO D  13      71.199  47.323  46.993  1.00 42.56           N  
ATOM   2916  CA  PRO D  13      71.392  48.697  46.522  1.00 45.86           C  
ATOM   2917  C   PRO D  13      70.930  49.740  47.546  1.00 49.65           C  
ATOM   2918  O   PRO D  13      69.752  49.789  47.908  1.00 50.22           O  
ATOM   2919  CB  PRO D  13      70.564  48.735  45.243  1.00 43.43           C  
ATOM   2920  CG  PRO D  13      69.424  47.838  45.580  1.00 41.31           C  
ATOM   2921  CD  PRO D  13      70.110  46.666  46.245  1.00 42.50           C  
ATOM   2922  N   ILE D  14      71.863  50.563  48.016  1.00 52.89           N  
ATOM   2923  CA  ILE D  14      71.542  51.611  48.984  1.00 56.92           C  
ATOM   2924  C   ILE D  14      70.806  52.762  48.293  1.00 58.73           C  
ATOM   2925  O   ILE D  14      70.101  53.542  48.938  1.00 59.39           O  
ATOM   2926  CB  ILE D  14      72.818  52.195  49.634  1.00 57.69           C  
ATOM   2927  CG1 ILE D  14      73.596  51.094  50.350  1.00 58.30           C  
ATOM   2928  CG2 ILE D  14      72.441  53.295  50.625  1.00 58.45           C  
ATOM   2929  CD1 ILE D  14      74.898  51.574  50.960  1.00 59.68           C  
ATOM   2930  N   GLY D  15      70.989  52.863  46.979  1.00 60.14           N  
ATOM   2931  CA  GLY D  15      70.355  53.921  46.214  1.00 59.64           C  
ATOM   2932  C   GLY D  15      68.948  53.588  45.763  1.00 59.89           C  
ATOM   2933  O   GLY D  15      68.333  52.632  46.260  1.00 61.27           O  
ATOM   2934  N   PRO D  16      68.402  54.374  44.821  1.00 57.87           N  
ATOM   2935  CA  PRO D  16      67.048  54.167  44.292  1.00 55.52           C  
ATOM   2936  C   PRO D  16      66.929  53.188  43.108  1.00 53.35           C  
ATOM   2937  O   PRO D  16      65.911  53.171  42.413  1.00 53.92           O  
ATOM   2938  CB  PRO D  16      66.616  55.581  43.920  1.00 56.16           C  
ATOM   2939  CG  PRO D  16      67.899  56.198  43.449  1.00 56.88           C  
ATOM   2940  CD  PRO D  16      68.913  55.714  44.462  1.00 56.65           C  
ATOM   2941  N   TYR D  17      67.951  52.370  42.882  1.00 49.33           N  
ATOM   2942  CA  TYR D  17      67.902  51.413  41.781  1.00 45.45           C  
ATOM   2943  C   TYR D  17      67.761  49.958  42.247  1.00 41.30           C  
ATOM   2944  O   TYR D  17      67.799  49.674  43.441  1.00 41.72           O  
ATOM   2945  CB  TYR D  17      69.150  51.564  40.907  1.00 46.80           C  
ATOM   2946  CG  TYR D  17      70.431  51.186  41.604  1.00 48.86           C  
ATOM   2947  CD1 TYR D  17      71.057  52.066  42.497  1.00 50.53           C  
ATOM   2948  CD2 TYR D  17      71.005  49.931  41.400  1.00 48.86           C  
ATOM   2949  CE1 TYR D  17      72.224  51.701  43.169  1.00 49.56           C  
ATOM   2950  CE2 TYR D  17      72.164  49.554  42.068  1.00 50.80           C  
ATOM   2951  CZ  TYR D  17      72.769  50.440  42.950  1.00 50.75           C  
ATOM   2952  OH  TYR D  17      73.909  50.049  43.616  1.00 51.62           O  
ATOM   2953  N   SER D  18      67.597  49.043  41.293  1.00 36.06           N  
ATOM   2954  CA  SER D  18      67.454  47.616  41.581  1.00 31.02           C  
ATOM   2955  C   SER D  18      68.697  46.843  41.127  1.00 28.49           C  
ATOM   2956  O   SER D  18      69.460  47.331  40.297  1.00 27.76           O  
ATOM   2957  CB  SER D  18      66.230  47.047  40.845  1.00 32.03           C  
ATOM   2958  OG  SER D  18      65.034  47.741  41.167  1.00 30.15           O  
ATOM   2959  N   GLN D  19      68.880  45.635  41.669  1.00 26.28           N  
ATOM   2960  CA  GLN D  19      70.002  44.752  41.318  1.00 21.19           C  
ATOM   2961  C   GLN D  19      69.868  44.301  39.875  1.00 20.86           C  
ATOM   2962  O   GLN D  19      70.879  44.131  39.183  1.00 19.56           O  
ATOM   2963  CB  GLN D  19      70.002  43.496  42.187  1.00 21.34           C  
ATOM   2964  CG  GLN D  19      70.160  43.733  43.673  1.00 25.19           C  
ATOM   2965  CD  GLN D  19      70.020  42.456  44.468  1.00 26.92           C  
ATOM   2966  OE1 GLN D  19      69.096  41.675  44.238  1.00 27.19           O  
ATOM   2967  NE2 GLN D  19      70.931  42.236  45.417  1.00 27.18           N  
ATOM   2968  N   ALA D  20      68.616  44.075  39.449  1.00 19.35           N  
ATOM   2969  CA  ALA D  20      68.295  43.637  38.085  1.00 19.62           C  
ATOM   2970  C   ALA D  20      66.803  43.695  37.750  1.00 18.76           C  
ATOM   2971  O   ALA D  20      65.961  43.500  38.622  1.00 20.16           O  
ATOM   2972  CB  ALA D  20      68.808  42.210  37.843  1.00 14.09           C  
ATOM   2973  N   ILE D  21      66.504  43.968  36.476  1.00 17.48           N  
ATOM   2974  CA  ILE D  21      65.137  44.033  35.952  1.00 17.97           C  
ATOM   2975  C   ILE D  21      64.972  43.054  34.784  1.00 18.87           C  
ATOM   2976  O   ILE D  21      65.770  43.043  33.854  1.00 19.04           O  
ATOM   2977  CB  ILE D  21      64.783  45.422  35.370  1.00 17.17           C  
ATOM   2978  CG1 ILE D  21      64.960  46.512  36.419  1.00 14.96           C  
ATOM   2979  CG2 ILE D  21      63.339  45.407  34.863  1.00 14.25           C  
ATOM   2980  CD1 ILE D  21      63.817  46.589  37.401  1.00 16.08           C  
ATOM   2981  N   LYS D  22      63.929  42.244  34.826  1.00 21.22           N  
ATOM   2982  CA  LYS D  22      63.681  41.310  33.746  1.00 22.45           C  
ATOM   2983  C   LYS D  22      62.581  41.878  32.878  1.00 23.33           C  
ATOM   2984  O   LYS D  22      61.493  42.158  33.356  1.00 24.12           O  
ATOM   2985  CB  LYS D  22      63.253  39.951  34.289  1.00 23.98           C  
ATOM   2986  CG  LYS D  22      63.020  38.921  33.195  1.00 25.75           C  
ATOM   2987  CD  LYS D  22      62.851  37.532  33.761  1.00 25.62           C  
ATOM   2988  CE  LYS D  22      62.640  36.513  32.661  1.00 27.56           C  
ATOM   2989  NZ  LYS D  22      61.345  36.719  31.968  1.00 30.07           N  
ATOM   2990  N   ALA D  23      62.879  42.064  31.599  1.00 26.32           N  
ATOM   2991  CA  ALA D  23      61.918  42.596  30.634  1.00 26.86           C  
ATOM   2992  C   ALA D  23      61.920  41.631  29.458  1.00 28.52           C  
ATOM   2993  O   ALA D  23      62.930  41.494  28.767  1.00 27.85           O  
ATOM   2994  CB  ALA D  23      62.348  43.975  30.176  1.00 26.64           C  
ATOM   2995  N   GLY D  24      60.792  40.963  29.231  1.00 29.30           N  
ATOM   2996  CA  GLY D  24      60.730  39.994  28.152  1.00 28.05           C  
ATOM   2997  C   GLY D  24      61.653  38.835  28.501  1.00 27.91           C  
ATOM   2998  O   GLY D  24      61.683  38.376  29.638  1.00 27.98           O  
ATOM   2999  N   ASN D  25      62.409  38.355  27.524  1.00 29.46           N  
ATOM   3000  CA  ASN D  25      63.343  37.260  27.754  1.00 29.94           C  
ATOM   3001  C   ASN D  25      64.696  37.822  28.187  1.00 28.19           C  
ATOM   3002  O   ASN D  25      65.650  37.069  28.401  1.00 28.46           O  
ATOM   3003  CB  ASN D  25      63.528  36.433  26.472  1.00 34.21           C  
ATOM   3004  CG  ASN D  25      62.343  35.510  26.170  1.00 39.50           C  
ATOM   3005  OD1 ASN D  25      62.302  34.871  25.114  1.00 45.02           O  
ATOM   3006  ND2 ASN D  25      61.389  35.426  27.093  1.00 41.83           N  
ATOM   3007  N   PHE D  26      64.773  39.145  28.315  1.00 24.11           N  
ATOM   3008  CA  PHE D  26      66.019  39.803  28.688  1.00 22.52           C  
ATOM   3009  C   PHE D  26      66.167  40.162  30.165  1.00 21.89           C  
ATOM   3010  O   PHE D  26      65.197  40.507  30.847  1.00 22.38           O  
ATOM   3011  CB  PHE D  26      66.208  41.056  27.830  1.00 21.41           C  
ATOM   3012  CG  PHE D  26      66.457  40.757  26.383  1.00 18.77           C  
ATOM   3013  CD1 PHE D  26      67.756  40.617  25.908  1.00 14.83           C  
ATOM   3014  CD2 PHE D  26      65.386  40.572  25.505  1.00 18.86           C  
ATOM   3015  CE1 PHE D  26      67.999  40.291  24.569  1.00 19.05           C  
ATOM   3016  CE2 PHE D  26      65.606  40.244  24.156  1.00 19.36           C  
ATOM   3017  CZ  PHE D  26      66.917  40.101  23.683  1.00 17.78           C  
ATOM   3018  N   LEU D  27      67.396  40.055  30.656  1.00 20.07           N  
ATOM   3019  CA  LEU D  27      67.707  40.375  32.044  1.00 20.40           C  
ATOM   3020  C   LEU D  27      68.766  41.457  32.044  1.00 20.08           C  
ATOM   3021  O   LEU D  27      69.817  41.299  31.410  1.00 19.25           O  
ATOM   3022  CB  LEU D  27      68.243  39.149  32.804  1.00 18.28           C  
ATOM   3023  CG  LEU D  27      68.600  39.508  34.251  1.00 19.19           C  
ATOM   3024  CD1 LEU D  27      67.340  39.923  34.974  1.00 19.81           C  
ATOM   3025  CD2 LEU D  27      69.269  38.361  34.958  1.00 17.21           C  
ATOM   3026  N   PHE D  28      68.485  42.546  32.756  1.00 20.04           N  
ATOM   3027  CA  PHE D  28      69.411  43.674  32.852  1.00 20.43           C  
ATOM   3028  C   PHE D  28      69.934  43.800  34.262  1.00 20.23           C  
ATOM   3029  O   PHE D  28      69.211  44.204  35.173  1.00 21.08           O  
ATOM   3030  CB  PHE D  28      68.722  44.981  32.447  1.00 18.54           C  
ATOM   3031  CG  PHE D  28      68.318  45.030  31.004  1.00 18.10           C  
ATOM   3032  CD1 PHE D  28      69.162  45.574  30.055  1.00 18.27           C  
ATOM   3033  CD2 PHE D  28      67.084  44.525  30.592  1.00 16.94           C  
ATOM   3034  CE1 PHE D  28      68.778  45.612  28.711  1.00 20.08           C  
ATOM   3035  CE2 PHE D  28      66.704  44.562  29.255  1.00 16.68           C  
ATOM   3036  CZ  PHE D  28      67.548  45.105  28.319  1.00 14.67           C  
ATOM   3037  N   ILE D  29      71.202  43.458  34.428  1.00 21.06           N  
ATOM   3038  CA  ILE D  29      71.848  43.514  35.730  1.00 21.67           C  
ATOM   3039  C   ILE D  29      72.530  44.853  35.953  1.00 22.51           C  
ATOM   3040  O   ILE D  29      73.295  45.322  35.107  1.00 24.52           O  
ATOM   3041  CB  ILE D  29      72.887  42.371  35.872  1.00 20.78           C  
ATOM   3042  CG1 ILE D  29      72.226  41.034  35.517  1.00 15.94           C  
ATOM   3043  CG2 ILE D  29      73.443  42.342  37.303  1.00 21.26           C  
ATOM   3044  CD1 ILE D  29      73.017  39.826  35.926  1.00 18.61           C  
ATOM   3045  N   ALA D  30      72.228  45.477  37.090  1.00 23.01           N  
ATOM   3046  CA  ALA D  30      72.816  46.765  37.449  1.00 21.49           C  
ATOM   3047  C   ALA D  30      74.318  46.590  37.645  1.00 22.51           C  
ATOM   3048  O   ALA D  30      74.774  45.482  37.922  1.00 23.95           O  
ATOM   3049  CB  ALA D  30      72.185  47.286  38.737  1.00 14.57           C  
ATOM   3050  N   GLY D  31      75.081  47.676  37.493  1.00 22.94           N  
ATOM   3051  CA  GLY D  31      76.518  47.601  37.690  1.00 23.36           C  
ATOM   3052  C   GLY D  31      76.824  47.047  39.074  1.00 27.43           C  
ATOM   3053  O   GLY D  31      76.297  47.528  40.076  1.00 28.14           O  
ATOM   3054  N   GLN D  32      77.666  46.023  39.134  1.00 29.34           N  
ATOM   3055  CA  GLN D  32      78.023  45.396  40.396  1.00 32.29           C  
ATOM   3056  C   GLN D  32      79.440  45.731  40.844  1.00 33.85           C  
ATOM   3057  O   GLN D  32      80.389  45.658  40.054  1.00 34.94           O  
ATOM   3058  CB  GLN D  32      77.874  43.877  40.277  1.00 33.08           C  
ATOM   3059  CG  GLN D  32      76.445  43.429  40.089  1.00 32.96           C  
ATOM   3060  CD  GLN D  32      75.578  43.761  41.289  1.00 34.97           C  
ATOM   3061  OE1 GLN D  32      74.551  44.430  41.156  1.00 36.03           O  
ATOM   3062  NE2 GLN D  32      75.984  43.292  42.470  1.00 29.80           N  
ATOM   3063  N   ILE D  33      79.574  46.097  42.116  1.00 34.33           N  
ATOM   3064  CA  ILE D  33      80.871  46.429  42.689  1.00 34.76           C  
ATOM   3065  C   ILE D  33      81.318  45.328  43.654  1.00 34.25           C  
ATOM   3066  O   ILE D  33      80.510  44.515  44.106  1.00 33.58           O  
ATOM   3067  CB  ILE D  33      80.835  47.801  43.399  1.00 35.94           C  
ATOM   3068  CG1 ILE D  33      79.588  47.916  44.275  1.00 36.14           C  
ATOM   3069  CG2 ILE D  33      80.893  48.911  42.367  1.00 34.59           C  
ATOM   3070  CD1 ILE D  33      79.456  49.266  44.961  1.00 38.37           C  
ATOM   3071  N   PRO D  34      82.617  45.299  43.986  1.00 34.12           N  
ATOM   3072  CA  PRO D  34      83.240  44.314  44.876  1.00 34.27           C  
ATOM   3073  C   PRO D  34      82.801  44.248  46.328  1.00 35.27           C  
ATOM   3074  O   PRO D  34      83.643  44.147  47.219  1.00 34.81           O  
ATOM   3075  CB  PRO D  34      84.723  44.643  44.746  1.00 34.89           C  
ATOM   3076  CG  PRO D  34      84.697  46.119  44.600  1.00 32.99           C  
ATOM   3077  CD  PRO D  34      83.593  46.333  43.602  1.00 32.04           C  
ATOM   3078  N   ILE D  35      81.494  44.292  46.573  1.00 36.22           N  
ATOM   3079  CA  ILE D  35      80.985  44.206  47.936  1.00 35.06           C  
ATOM   3080  C   ILE D  35      80.641  42.758  48.247  1.00 36.40           C  
ATOM   3081  O   ILE D  35      80.034  42.068  47.431  1.00 37.35           O  
ATOM   3082  CB  ILE D  35      79.709  45.065  48.144  1.00 35.33           C  
ATOM   3083  CG1 ILE D  35      80.055  46.555  48.037  1.00 35.12           C  
ATOM   3084  CG2 ILE D  35      79.078  44.760  49.517  1.00 35.08           C  
ATOM   3085  CD1 ILE D  35      78.893  47.499  48.348  1.00 31.40           C  
ATOM   3086  N   ASP D  36      81.046  42.297  49.425  1.00 37.82           N  
ATOM   3087  CA  ASP D  36      80.755  40.938  49.851  1.00 38.78           C  
ATOM   3088  C   ASP D  36      79.431  40.968  50.600  1.00 39.59           C  
ATOM   3089  O   ASP D  36      79.317  41.587  51.654  1.00 38.59           O  
ATOM   3090  CB  ASP D  36      81.855  40.420  50.771  1.00 41.48           C  
ATOM   3091  CG  ASP D  36      81.551  39.039  51.308  1.00 44.95           C  
ATOM   3092  OD1 ASP D  36      82.375  38.518  52.080  1.00 48.41           O  
ATOM   3093  OD2 ASP D  36      80.490  38.473  50.962  1.00 46.54           O  
ATOM   3094  N   PRO D  37      78.411  40.290  50.067  1.00 40.60           N  
ATOM   3095  CA  PRO D  37      77.098  40.271  50.713  1.00 41.44           C  
ATOM   3096  C   PRO D  37      77.067  39.713  52.136  1.00 43.68           C  
ATOM   3097  O   PRO D  37      76.340  40.222  52.982  1.00 45.30           O  
ATOM   3098  CB  PRO D  37      76.245  39.462  49.734  1.00 42.32           C  
ATOM   3099  CG  PRO D  37      77.232  38.525  49.124  1.00 41.15           C  
ATOM   3100  CD  PRO D  37      78.428  39.419  48.881  1.00 40.76           C  
ATOM   3101  N   LYS D  38      77.858  38.682  52.407  1.00 45.25           N  
ATOM   3102  CA  LYS D  38      77.886  38.080  53.736  1.00 47.28           C  
ATOM   3103  C   LYS D  38      78.414  39.020  54.821  1.00 48.16           C  
ATOM   3104  O   LYS D  38      77.954  38.975  55.962  1.00 48.22           O  
ATOM   3105  CB  LYS D  38      78.739  36.812  53.720  1.00 50.35           C  
ATOM   3106  CG  LYS D  38      78.441  35.888  52.547  1.00 55.54           C  
ATOM   3107  CD  LYS D  38      77.008  35.352  52.578  1.00 58.37           C  
ATOM   3108  CE  LYS D  38      76.932  34.007  53.271  1.00 58.98           C  
ATOM   3109  NZ  LYS D  38      77.761  32.995  52.546  1.00 60.72           N  
ATOM   3110  N   THR D  39      79.376  39.870  54.468  1.00 48.62           N  
ATOM   3111  CA  THR D  39      79.961  40.795  55.438  1.00 48.39           C  
ATOM   3112  C   THR D  39      79.420  42.226  55.350  1.00 47.39           C  
ATOM   3113  O   THR D  39      79.351  42.933  56.361  1.00 46.98           O  
ATOM   3114  CB  THR D  39      81.495  40.854  55.291  1.00 49.51           C  
ATOM   3115  OG1 THR D  39      82.039  41.669  56.336  1.00 55.08           O  
ATOM   3116  CG2 THR D  39      81.881  41.465  53.957  1.00 50.02           C  
ATOM   3117  N   GLY D  40      79.054  42.656  54.145  1.00 45.43           N  
ATOM   3118  CA  GLY D  40      78.525  43.999  53.964  1.00 42.08           C  
ATOM   3119  C   GLY D  40      79.581  45.028  53.609  1.00 40.98           C  
ATOM   3120  O   GLY D  40      79.281  46.212  53.465  1.00 36.12           O  
ATOM   3121  N   GLU D  41      80.821  44.577  53.445  1.00 42.95           N  
ATOM   3122  CA  GLU D  41      81.914  45.490  53.123  1.00 46.82           C  
ATOM   3123  C   GLU D  41      82.725  45.105  51.888  1.00 46.54           C  
ATOM   3124  O   GLU D  41      82.792  43.934  51.504  1.00 46.64           O  
ATOM   3125  CB  GLU D  41      82.853  45.613  54.335  1.00 50.55           C  
ATOM   3126  CG  GLU D  41      83.432  44.287  54.812  1.00 55.43           C  
ATOM   3127  CD  GLU D  41      83.885  44.322  56.264  1.00 59.15           C  
ATOM   3128  OE1 GLU D  41      83.033  44.595  57.139  1.00 59.66           O  
ATOM   3129  OE2 GLU D  41      85.087  44.077  56.529  1.00 60.28           O  
ATOM   3130  N   ILE D  42      83.332  46.114  51.268  1.00 46.32           N  
ATOM   3131  CA  ILE D  42      84.171  45.929  50.088  1.00 45.80           C  
ATOM   3132  C   ILE D  42      85.313  44.988  50.475  1.00 47.25           C  
ATOM   3133  O   ILE D  42      85.918  45.142  51.535  1.00 47.50           O  
ATOM   3134  CB  ILE D  42      84.730  47.303  49.614  1.00 44.98           C  
ATOM   3135  CG1 ILE D  42      83.568  48.177  49.127  1.00 45.46           C  
ATOM   3136  CG2 ILE D  42      85.786  47.122  48.536  1.00 43.78           C  
ATOM   3137  CD1 ILE D  42      83.944  49.609  48.823  1.00 44.86           C  
ATOM   3138  N   VAL D  43      85.600  44.005  49.629  1.00 50.05           N  
ATOM   3139  CA  VAL D  43      86.667  43.050  49.918  1.00 52.60           C  
ATOM   3140  C   VAL D  43      88.054  43.654  49.696  1.00 55.03           C  
ATOM   3141  O   VAL D  43      88.179  44.826  49.329  1.00 55.54           O  
ATOM   3142  CB  VAL D  43      86.522  41.774  49.054  1.00 51.56           C  
ATOM   3143  CG1 VAL D  43      85.149  41.173  49.260  1.00 49.39           C  
ATOM   3144  CG2 VAL D  43      86.757  42.100  47.583  1.00 51.45           C  
ATOM   3145  N   LYS D  44      89.088  42.847  49.933  1.00 57.27           N  
ATOM   3146  CA  LYS D  44      90.483  43.267  49.770  1.00 59.91           C  
ATOM   3147  C   LYS D  44      90.733  44.062  48.477  1.00 60.44           C  
ATOM   3148  O   LYS D  44      90.001  43.927  47.493  1.00 60.34           O  
ATOM   3149  CB  LYS D  44      91.395  42.035  49.803  1.00 60.57           C  
ATOM   3150  CG  LYS D  44      91.255  41.204  51.070  1.00 62.32           C  
ATOM   3151  CD  LYS D  44      90.997  39.729  50.761  1.00 64.95           C  
ATOM   3152  CE  LYS D  44      89.648  39.513  50.066  1.00 65.05           C  
ATOM   3153  NZ  LYS D  44      89.339  38.064  49.868  1.00 63.87           N  
ATOM   3154  N   GLY D  45      91.782  44.877  48.482  1.00 60.49           N  
ATOM   3155  CA  GLY D  45      92.099  45.689  47.317  1.00 60.38           C  
ATOM   3156  C   GLY D  45      92.817  45.018  46.155  1.00 60.42           C  
ATOM   3157  O   GLY D  45      93.310  45.707  45.262  1.00 60.73           O  
ATOM   3158  N   ASP D  46      92.891  43.689  46.152  1.00 60.46           N  
ATOM   3159  CA  ASP D  46      93.552  42.967  45.061  1.00 58.85           C  
ATOM   3160  C   ASP D  46      92.596  42.909  43.866  1.00 57.42           C  
ATOM   3161  O   ASP D  46      91.407  42.635  44.034  1.00 58.26           O  
ATOM   3162  CB  ASP D  46      93.909  41.545  45.506  1.00 59.69           C  
ATOM   3163  CG  ASP D  46      94.740  40.800  44.476  1.00 62.92           C  
ATOM   3164  OD1 ASP D  46      94.316  40.731  43.302  1.00 65.89           O  
ATOM   3165  OD2 ASP D  46      95.817  40.272  44.837  1.00 62.91           O  
ATOM   3166  N   ILE D  47      93.112  43.167  42.667  1.00 54.73           N  
ATOM   3167  CA  ILE D  47      92.292  43.146  41.457  1.00 52.41           C  
ATOM   3168  C   ILE D  47      91.640  41.783  41.242  1.00 49.94           C  
ATOM   3169  O   ILE D  47      90.513  41.698  40.771  1.00 48.79           O  
ATOM   3170  CB  ILE D  47      93.131  43.510  40.195  1.00 53.49           C  
ATOM   3171  CG1 ILE D  47      92.215  43.728  38.991  1.00 54.01           C  
ATOM   3172  CG2 ILE D  47      94.095  42.383  39.860  1.00 54.50           C  
ATOM   3173  CD1 ILE D  47      91.249  44.882  39.141  1.00 54.73           C  
ATOM   3174  N   LYS D  48      92.349  40.716  41.589  1.00 49.57           N  
ATOM   3175  CA  LYS D  48      91.818  39.369  41.425  1.00 49.41           C  
ATOM   3176  C   LYS D  48      90.703  39.086  42.420  1.00 48.10           C  
ATOM   3177  O   LYS D  48      89.713  38.451  42.076  1.00 48.07           O  
ATOM   3178  CB  LYS D  48      92.919  38.317  41.594  1.00 50.94           C  
ATOM   3179  CG  LYS D  48      92.449  36.904  41.250  1.00 54.39           C  
ATOM   3180  CD  LYS D  48      93.526  35.839  41.466  1.00 57.24           C  
ATOM   3181  CE  LYS D  48      93.767  35.553  42.953  1.00 57.28           C  
ATOM   3182  NZ  LYS D  48      94.805  34.492  43.136  1.00 57.11           N  
ATOM   3183  N   ASP D  49      90.867  39.547  43.655  1.00 47.58           N  
ATOM   3184  CA  ASP D  49      89.847  39.326  44.672  1.00 46.24           C  
ATOM   3185  C   ASP D  49      88.577  40.103  44.366  1.00 43.25           C  
ATOM   3186  O   ASP D  49      87.483  39.555  44.440  1.00 41.81           O  
ATOM   3187  CB  ASP D  49      90.369  39.702  46.061  1.00 49.89           C  
ATOM   3188  CG  ASP D  49      91.366  38.684  46.607  1.00 54.34           C  
ATOM   3189  OD1 ASP D  49      91.075  37.465  46.544  1.00 53.64           O  
ATOM   3190  OD2 ASP D  49      92.439  39.105  47.105  1.00 57.10           O  
ATOM   3191  N   GLN D  50      88.724  41.374  44.016  1.00 42.03           N  
ATOM   3192  CA  GLN D  50      87.570  42.206  43.685  1.00 41.60           C  
ATOM   3193  C   GLN D  50      86.842  41.700  42.438  1.00 40.28           C  
ATOM   3194  O   GLN D  50      85.613  41.669  42.403  1.00 41.04           O  
ATOM   3195  CB  GLN D  50      87.993  43.670  43.493  1.00 42.06           C  
ATOM   3196  CG  GLN D  50      88.034  44.477  44.792  1.00 43.82           C  
ATOM   3197  CD  GLN D  50      88.520  45.902  44.587  1.00 45.74           C  
ATOM   3198  OE1 GLN D  50      87.862  46.720  43.937  1.00 45.97           O  
ATOM   3199  NE2 GLN D  50      89.687  46.204  45.139  1.00 47.02           N  
ATOM   3200  N   THR D  51      87.595  41.298  41.421  1.00 38.33           N  
ATOM   3201  CA  THR D  51      86.996  40.784  40.199  1.00 37.02           C  
ATOM   3202  C   THR D  51      86.132  39.568  40.509  1.00 36.64           C  
ATOM   3203  O   THR D  51      85.015  39.442  40.004  1.00 37.86           O  
ATOM   3204  CB  THR D  51      88.073  40.366  39.167  1.00 38.02           C  
ATOM   3205  OG1 THR D  51      88.892  41.498  38.829  1.00 37.92           O  
ATOM   3206  CG2 THR D  51      87.414  39.827  37.902  1.00 36.59           C  
ATOM   3207  N   ARG D  52      86.649  38.679  41.350  1.00 35.70           N  
ATOM   3208  CA  ARG D  52      85.935  37.467  41.714  1.00 34.82           C  
ATOM   3209  C   ARG D  52      84.701  37.751  42.555  1.00 34.03           C  
ATOM   3210  O   ARG D  52      83.707  37.024  42.470  1.00 34.80           O  
ATOM   3211  CB  ARG D  52      86.871  36.502  42.456  1.00 36.03           C  
ATOM   3212  CG  ARG D  52      86.158  35.286  43.052  1.00 40.01           C  
ATOM   3213  CD  ARG D  52      87.122  34.300  43.704  1.00 40.51           C  
ATOM   3214  NE  ARG D  52      87.956  33.618  42.718  1.00 45.42           N  
ATOM   3215  CZ  ARG D  52      89.216  33.938  42.441  1.00 46.89           C  
ATOM   3216  NH1 ARG D  52      89.882  33.254  41.521  1.00 48.07           N  
ATOM   3217  NH2 ARG D  52      89.820  34.927  43.092  1.00 48.49           N  
ATOM   3218  N   GLN D  53      84.759  38.802  43.368  1.00 31.74           N  
ATOM   3219  CA  GLN D  53      83.629  39.162  44.218  1.00 29.51           C  
ATOM   3220  C   GLN D  53      82.509  39.703  43.345  1.00 28.39           C  
ATOM   3221  O   GLN D  53      81.346  39.337  43.506  1.00 28.46           O  
ATOM   3222  CB  GLN D  53      84.053  40.213  45.252  1.00 30.28           C  
ATOM   3223  CG  GLN D  53      82.975  40.585  46.273  1.00 31.83           C  
ATOM   3224  CD  GLN D  53      82.515  39.397  47.101  1.00 34.91           C  
ATOM   3225  OE1 GLN D  53      81.688  38.589  46.660  1.00 35.45           O  
ATOM   3226  NE2 GLN D  53      83.060  39.276  48.308  1.00 36.16           N  
ATOM   3227  N   VAL D  54      82.880  40.576  42.414  1.00 27.38           N  
ATOM   3228  CA  VAL D  54      81.937  41.178  41.472  1.00 27.16           C  
ATOM   3229  C   VAL D  54      81.253  40.106  40.608  1.00 27.08           C  
ATOM   3230  O   VAL D  54      80.085  40.232  40.261  1.00 27.59           O  
ATOM   3231  CB  VAL D  54      82.664  42.187  40.528  1.00 28.02           C  
ATOM   3232  CG1 VAL D  54      81.782  42.530  39.332  1.00 28.12           C  
ATOM   3233  CG2 VAL D  54      83.035  43.463  41.300  1.00 25.40           C  
ATOM   3234  N   LEU D  55      82.000  39.060  40.265  1.00 26.03           N  
ATOM   3235  CA  LEU D  55      81.501  37.972  39.436  1.00 24.39           C  
ATOM   3236  C   LEU D  55      80.601  37.003  40.211  1.00 25.47           C  
ATOM   3237  O   LEU D  55      79.677  36.399  39.643  1.00 22.22           O  
ATOM   3238  CB  LEU D  55      82.695  37.237  38.807  1.00 23.56           C  
ATOM   3239  CG  LEU D  55      82.964  37.388  37.299  1.00 25.30           C  
ATOM   3240  CD1 LEU D  55      82.379  38.689  36.767  1.00 24.23           C  
ATOM   3241  CD2 LEU D  55      84.467  37.311  37.024  1.00 21.93           C  
ATOM   3242  N   GLU D  56      80.872  36.844  41.503  1.00 27.46           N  
ATOM   3243  CA  GLU D  56      80.055  35.968  42.328  1.00 30.42           C  
ATOM   3244  C   GLU D  56      78.685  36.609  42.511  1.00 28.85           C  
ATOM   3245  O   GLU D  56      77.675  35.917  42.485  1.00 29.89           O  
ATOM   3246  CB  GLU D  56      80.729  35.713  43.680  1.00 35.76           C  
ATOM   3247  CG  GLU D  56      81.821  34.638  43.625  1.00 43.42           C  
ATOM   3248  CD  GLU D  56      82.657  34.545  44.903  1.00 49.46           C  
ATOM   3249  OE1 GLU D  56      83.273  35.567  45.297  1.00 52.30           O  
ATOM   3250  OE2 GLU D  56      82.706  33.447  45.510  1.00 52.11           O  
ATOM   3251  N   ASN D  57      78.655  37.934  42.666  1.00 29.88           N  
ATOM   3252  CA  ASN D  57      77.398  38.680  42.830  1.00 27.69           C  
ATOM   3253  C   ASN D  57      76.560  38.561  41.571  1.00 26.32           C  
ATOM   3254  O   ASN D  57      75.361  38.291  41.640  1.00 27.34           O  
ATOM   3255  CB  ASN D  57      77.648  40.172  43.082  1.00 26.58           C  
ATOM   3256  CG  ASN D  57      78.413  40.436  44.352  1.00 26.88           C  
ATOM   3257  OD1 ASN D  57      78.374  39.648  45.299  1.00 25.58           O  
ATOM   3258  ND2 ASN D  57      79.101  41.573  44.391  1.00 24.58           N  
ATOM   3259  N   ILE D  58      77.199  38.790  40.425  1.00 22.51           N  
ATOM   3260  CA  ILE D  58      76.525  38.703  39.139  1.00 20.40           C  
ATOM   3261  C   ILE D  58      75.950  37.301  39.014  1.00 20.53           C  
ATOM   3262  O   ILE D  58      74.830  37.117  38.546  1.00 20.85           O  
ATOM   3263  CB  ILE D  58      77.516  38.987  37.972  1.00 20.49           C  
ATOM   3264  CG1 ILE D  58      77.856  40.478  37.937  1.00 19.34           C  
ATOM   3265  CG2 ILE D  58      76.930  38.540  36.630  1.00 19.51           C  
ATOM   3266  CD1 ILE D  58      78.980  40.821  36.997  1.00 17.89           C  
ATOM   3267  N   LYS D  59      76.721  36.310  39.454  1.00 21.96           N  
ATOM   3268  CA  LYS D  59      76.279  34.925  39.397  1.00 22.37           C  
ATOM   3269  C   LYS D  59      75.032  34.741  40.258  1.00 21.90           C  
ATOM   3270  O   LYS D  59      74.059  34.124  39.825  1.00 20.48           O  
ATOM   3271  CB  LYS D  59      77.387  33.987  39.872  1.00 23.49           C  
ATOM   3272  CG  LYS D  59      77.037  32.523  39.684  1.00 25.67           C  
ATOM   3273  CD  LYS D  59      78.099  31.597  40.241  1.00 27.05           C  
ATOM   3274  CE  LYS D  59      77.692  30.151  40.018  1.00 30.94           C  
ATOM   3275  NZ  LYS D  59      78.419  29.193  40.904  1.00 36.06           N  
ATOM   3276  N   ALA D  60      75.057  35.293  41.469  1.00 21.40           N  
ATOM   3277  CA  ALA D  60      73.911  35.202  42.378  1.00 21.19           C  
ATOM   3278  C   ALA D  60      72.657  35.852  41.791  1.00 20.07           C  
ATOM   3279  O   ALA D  60      71.587  35.241  41.779  1.00 20.75           O  
ATOM   3280  CB  ALA D  60      74.249  35.844  43.722  1.00 22.40           C  
ATOM   3281  N   ILE D  61      72.779  37.085  41.308  1.00 18.33           N  
ATOM   3282  CA  ILE D  61      71.628  37.769  40.720  1.00 20.51           C  
ATOM   3283  C   ILE D  61      71.082  36.945  39.546  1.00 21.64           C  
ATOM   3284  O   ILE D  61      69.872  36.749  39.413  1.00 21.37           O  
ATOM   3285  CB  ILE D  61      71.999  39.195  40.238  1.00 19.99           C  
ATOM   3286  CG1 ILE D  61      72.316  40.086  41.448  1.00 20.18           C  
ATOM   3287  CG2 ILE D  61      70.850  39.790  39.435  1.00 19.38           C  
ATOM   3288  CD1 ILE D  61      73.266  41.264  41.158  1.00 16.23           C  
ATOM   3289  N   LEU D  62      71.987  36.460  38.705  1.00 22.55           N  
ATOM   3290  CA  LEU D  62      71.605  35.639  37.572  1.00 22.95           C  
ATOM   3291  C   LEU D  62      70.770  34.451  38.028  1.00 23.89           C  
ATOM   3292  O   LEU D  62      69.729  34.162  37.446  1.00 23.91           O  
ATOM   3293  CB  LEU D  62      72.848  35.124  36.861  1.00 22.10           C  
ATOM   3294  CG  LEU D  62      73.494  36.059  35.854  1.00 19.43           C  
ATOM   3295  CD1 LEU D  62      74.845  35.502  35.481  1.00 18.05           C  
ATOM   3296  CD2 LEU D  62      72.599  36.210  34.654  1.00 14.71           C  
ATOM   3297  N   GLU D  63      71.249  33.767  39.066  1.00 26.66           N  
ATOM   3298  CA  GLU D  63      70.574  32.599  39.629  1.00 27.23           C  
ATOM   3299  C   GLU D  63      69.204  32.946  40.196  1.00 26.04           C  
ATOM   3300  O   GLU D  63      68.261  32.180  40.043  1.00 27.81           O  
ATOM   3301  CB  GLU D  63      71.442  31.954  40.714  1.00 29.23           C  
ATOM   3302  CG  GLU D  63      72.632  31.168  40.152  1.00 38.82           C  
ATOM   3303  CD  GLU D  63      73.661  30.737  41.211  1.00 43.40           C  
ATOM   3304  OE1 GLU D  63      74.597  29.981  40.850  1.00 45.70           O  
ATOM   3305  OE2 GLU D  63      73.542  31.151  42.391  1.00 45.30           O  
ATOM   3306  N   ALA D  64      69.082  34.101  40.842  1.00 23.33           N  
ATOM   3307  CA  ALA D  64      67.793  34.500  41.391  1.00 21.00           C  
ATOM   3308  C   ALA D  64      66.819  34.825  40.266  1.00 21.77           C  
ATOM   3309  O   ALA D  64      65.612  34.651  40.414  1.00 23.16           O  
ATOM   3310  CB  ALA D  64      67.956  35.697  42.291  1.00 20.15           C  
ATOM   3311  N   ALA D  65      67.343  35.290  39.138  1.00 21.14           N  
ATOM   3312  CA  ALA D  65      66.507  35.639  37.993  1.00 21.72           C  
ATOM   3313  C   ALA D  65      66.112  34.449  37.111  1.00 22.97           C  
ATOM   3314  O   ALA D  65      65.319  34.600  36.188  1.00 22.90           O  
ATOM   3315  CB  ALA D  65      67.211  36.692  37.147  1.00 16.35           C  
ATOM   3316  N   GLY D  66      66.671  33.274  37.384  1.00 25.57           N  
ATOM   3317  CA  GLY D  66      66.352  32.105  36.581  1.00 27.28           C  
ATOM   3318  C   GLY D  66      67.244  31.961  35.354  1.00 28.89           C  
ATOM   3319  O   GLY D  66      66.864  31.321  34.370  1.00 31.44           O  
ATOM   3320  N   TYR D  67      68.431  32.555  35.404  1.00 27.01           N  
ATOM   3321  CA  TYR D  67      69.377  32.491  34.294  1.00 26.96           C  
ATOM   3322  C   TYR D  67      70.651  31.804  34.755  1.00 28.09           C  
ATOM   3323  O   TYR D  67      70.832  31.565  35.939  1.00 30.08           O  
ATOM   3324  CB  TYR D  67      69.733  33.900  33.796  1.00 22.99           C  
ATOM   3325  CG  TYR D  67      68.611  34.641  33.096  1.00 21.93           C  
ATOM   3326  CD1 TYR D  67      68.650  34.877  31.719  1.00 20.44           C  
ATOM   3327  CD2 TYR D  67      67.527  35.133  33.812  1.00 22.09           C  
ATOM   3328  CE1 TYR D  67      67.632  35.590  31.077  1.00 17.75           C  
ATOM   3329  CE2 TYR D  67      66.505  35.847  33.179  1.00 20.88           C  
ATOM   3330  CZ  TYR D  67      66.565  36.071  31.817  1.00 19.31           C  
ATOM   3331  OH  TYR D  67      65.556  36.781  31.216  1.00 18.58           O  
ATOM   3332  N   SER D  68      71.534  31.481  33.816  1.00 30.33           N  
ATOM   3333  CA  SER D  68      72.812  30.857  34.150  1.00 31.34           C  
ATOM   3334  C   SER D  68      73.928  31.729  33.567  1.00 31.37           C  
ATOM   3335  O   SER D  68      73.663  32.665  32.804  1.00 29.39           O  
ATOM   3336  CB  SER D  68      72.889  29.450  33.557  1.00 31.78           C  
ATOM   3337  OG  SER D  68      72.755  29.493  32.146  1.00 35.67           O  
ATOM   3338  N   LEU D  69      75.172  31.444  33.933  1.00 30.45           N  
ATOM   3339  CA  LEU D  69      76.281  32.219  33.398  1.00 31.93           C  
ATOM   3340  C   LEU D  69      76.314  32.076  31.869  1.00 32.30           C  
ATOM   3341  O   LEU D  69      76.818  32.944  31.164  1.00 30.29           O  
ATOM   3342  CB  LEU D  69      77.595  31.728  33.997  1.00 31.89           C  
ATOM   3343  CG  LEU D  69      77.796  32.057  35.474  1.00 32.71           C  
ATOM   3344  CD1 LEU D  69      78.984  31.285  36.021  1.00 32.45           C  
ATOM   3345  CD2 LEU D  69      78.014  33.556  35.620  1.00 32.35           C  
ATOM   3346  N   ASN D  70      75.744  30.978  31.378  1.00 33.57           N  
ATOM   3347  CA  ASN D  70      75.695  30.673  29.946  1.00 35.05           C  
ATOM   3348  C   ASN D  70      74.628  31.449  29.171  1.00 33.04           C  
ATOM   3349  O   ASN D  70      74.581  31.395  27.944  1.00 31.91           O  
ATOM   3350  CB  ASN D  70      75.488  29.165  29.763  1.00 38.37           C  
ATOM   3351  CG  ASN D  70      75.147  28.786  28.336  1.00 44.56           C  
ATOM   3352  OD1 ASN D  70      74.009  28.968  27.884  1.00 49.31           O  
ATOM   3353  ND2 ASN D  70      76.134  28.265  27.610  1.00 46.41           N  
ATOM   3354  N   ASP D  71      73.786  32.173  29.899  1.00 31.12           N  
ATOM   3355  CA  ASP D  71      72.712  32.963  29.307  1.00 28.24           C  
ATOM   3356  C   ASP D  71      73.149  34.393  29.086  1.00 25.42           C  
ATOM   3357  O   ASP D  71      72.405  35.182  28.510  1.00 24.32           O  
ATOM   3358  CB  ASP D  71      71.488  32.976  30.222  1.00 31.46           C  
ATOM   3359  CG  ASP D  71      70.814  31.633  30.313  1.00 33.73           C  
ATOM   3360  OD1 ASP D  71      70.362  31.282  31.424  1.00 36.73           O  
ATOM   3361  OD2 ASP D  71      70.721  30.937  29.280  1.00 35.59           O  
ATOM   3362  N   VAL D  72      74.349  34.726  29.558  1.00 23.56           N  
ATOM   3363  CA  VAL D  72      74.893  36.077  29.416  1.00 22.08           C  
ATOM   3364  C   VAL D  72      75.346  36.354  27.984  1.00 22.61           C  
ATOM   3365  O   VAL D  72      76.099  35.578  27.405  1.00 23.67           O  
ATOM   3366  CB  VAL D  72      76.068  36.296  30.403  1.00 20.38           C  
ATOM   3367  CG1 VAL D  72      76.729  37.642  30.161  1.00 19.40           C  
ATOM   3368  CG2 VAL D  72      75.541  36.238  31.832  1.00 19.76           C  
ATOM   3369  N   ILE D  73      74.882  37.471  27.421  1.00 21.63           N  
ATOM   3370  CA  ILE D  73      75.211  37.837  26.050  1.00 21.13           C  
ATOM   3371  C   ILE D  73      76.085  39.084  25.907  1.00 21.76           C  
ATOM   3372  O   ILE D  73      76.792  39.239  24.906  1.00 21.93           O  
ATOM   3373  CB  ILE D  73      73.935  38.051  25.223  1.00 20.16           C  
ATOM   3374  CG1 ILE D  73      73.115  39.186  25.840  1.00 20.26           C  
ATOM   3375  CG2 ILE D  73      73.140  36.760  25.152  1.00 18.70           C  
ATOM   3376  CD1 ILE D  73      71.836  39.466  25.147  1.00 18.96           C  
ATOM   3377  N   LYS D  74      76.036  39.971  26.893  1.00 20.62           N  
ATOM   3378  CA  LYS D  74      76.845  41.179  26.843  1.00 20.13           C  
ATOM   3379  C   LYS D  74      77.329  41.620  28.225  1.00 19.89           C  
ATOM   3380  O   LYS D  74      76.577  41.664  29.191  1.00 19.56           O  
ATOM   3381  CB  LYS D  74      76.059  42.322  26.188  1.00 22.78           C  
ATOM   3382  CG  LYS D  74      76.822  43.655  26.147  1.00 26.75           C  
ATOM   3383  CD  LYS D  74      75.953  44.771  25.590  1.00 32.42           C  
ATOM   3384  CE  LYS D  74      76.605  46.143  25.745  1.00 35.80           C  
ATOM   3385  NZ  LYS D  74      75.710  47.250  25.286  1.00 38.13           N  
ATOM   3386  N   VAL D  75      78.607  41.937  28.319  1.00 20.89           N  
ATOM   3387  CA  VAL D  75      79.160  42.384  29.573  1.00 21.30           C  
ATOM   3388  C   VAL D  75      79.979  43.636  29.333  1.00 20.85           C  
ATOM   3389  O   VAL D  75      80.640  43.781  28.309  1.00 21.72           O  
ATOM   3390  CB  VAL D  75      80.053  41.300  30.207  1.00 23.13           C  
ATOM   3391  CG1 VAL D  75      80.647  41.815  31.511  1.00 22.94           C  
ATOM   3392  CG2 VAL D  75      79.244  40.054  30.473  1.00 22.35           C  
ATOM   3393  N   THR D  76      79.906  44.564  30.269  1.00 22.46           N  
ATOM   3394  CA  THR D  76      80.678  45.787  30.162  1.00 24.51           C  
ATOM   3395  C   THR D  76      81.486  45.830  31.433  1.00 24.91           C  
ATOM   3396  O   THR D  76      80.947  45.670  32.528  1.00 24.02           O  
ATOM   3397  CB  THR D  76      79.796  47.032  30.090  1.00 26.57           C  
ATOM   3398  OG1 THR D  76      78.849  46.879  29.028  1.00 30.47           O  
ATOM   3399  CG2 THR D  76      80.656  48.279  29.820  1.00 29.28           C  
ATOM   3400  N   VAL D  77      82.789  46.003  31.277  1.00 26.56           N  
ATOM   3401  CA  VAL D  77      83.680  46.058  32.418  1.00 28.97           C  
ATOM   3402  C   VAL D  77      84.273  47.455  32.519  1.00 30.47           C  
ATOM   3403  O   VAL D  77      84.737  48.018  31.529  1.00 29.61           O  
ATOM   3404  CB  VAL D  77      84.816  45.017  32.285  1.00 28.63           C  
ATOM   3405  CG1 VAL D  77      85.751  45.102  33.492  1.00 29.39           C  
ATOM   3406  CG2 VAL D  77      84.221  43.611  32.157  1.00 25.68           C  
ATOM   3407  N   TYR D  78      84.220  48.017  33.720  1.00 32.02           N  
ATOM   3408  CA  TYR D  78      84.767  49.343  33.978  1.00 33.35           C  
ATOM   3409  C   TYR D  78      85.937  49.170  34.923  1.00 34.49           C  
ATOM   3410  O   TYR D  78      85.767  48.701  36.046  1.00 34.60           O  
ATOM   3411  CB  TYR D  78      83.709  50.237  34.627  1.00 32.96           C  
ATOM   3412  CG  TYR D  78      82.504  50.479  33.745  1.00 32.98           C  
ATOM   3413  CD1 TYR D  78      82.583  51.322  32.636  1.00 33.42           C  
ATOM   3414  CD2 TYR D  78      81.293  49.845  34.005  1.00 34.04           C  
ATOM   3415  CE1 TYR D  78      81.479  51.526  31.809  1.00 34.86           C  
ATOM   3416  CE2 TYR D  78      80.186  50.038  33.187  1.00 34.64           C  
ATOM   3417  CZ  TYR D  78      80.282  50.880  32.093  1.00 35.34           C  
ATOM   3418  OH  TYR D  78      79.176  51.085  31.299  1.00 36.60           O  
ATOM   3419  N   LEU D  79      87.131  49.520  34.462  1.00 36.85           N  
ATOM   3420  CA  LEU D  79      88.314  49.400  35.298  1.00 40.14           C  
ATOM   3421  C   LEU D  79      88.843  50.766  35.716  1.00 42.90           C  
ATOM   3422  O   LEU D  79      88.611  51.770  35.041  1.00 41.14           O  
ATOM   3423  CB  LEU D  79      89.409  48.623  34.563  1.00 39.55           C  
ATOM   3424  CG  LEU D  79      89.199  47.118  34.387  1.00 38.42           C  
ATOM   3425  CD1 LEU D  79      90.422  46.511  33.715  1.00 38.78           C  
ATOM   3426  CD2 LEU D  79      88.969  46.466  35.743  1.00 38.22           C  
ATOM   3427  N   LYS D  80      89.542  50.806  36.841  1.00 48.13           N  
ATOM   3428  CA  LYS D  80      90.111  52.061  37.308  1.00 55.05           C  
ATOM   3429  C   LYS D  80      91.551  52.150  36.802  1.00 58.28           C  
ATOM   3430  O   LYS D  80      92.095  53.242  36.638  1.00 59.08           O  
ATOM   3431  CB  LYS D  80      90.081  52.124  38.838  1.00 57.01           C  
ATOM   3432  CG  LYS D  80      90.520  53.462  39.417  1.00 58.86           C  
ATOM   3433  CD  LYS D  80      90.535  53.423  40.940  1.00 59.51           C  
ATOM   3434  CE  LYS D  80      91.106  54.704  41.521  1.00 59.28           C  
ATOM   3435  NZ  LYS D  80      92.545  54.861  41.176  1.00 61.23           N  
ATOM   3436  N   ASP D  81      92.146  50.987  36.538  1.00 63.11           N  
ATOM   3437  CA  ASP D  81      93.525  50.886  36.045  1.00 66.85           C  
ATOM   3438  C   ASP D  81      93.689  49.844  34.926  1.00 68.06           C  
ATOM   3439  O   ASP D  81      93.434  48.653  35.123  1.00 67.77           O  
ATOM   3440  CB  ASP D  81      94.466  50.527  37.198  1.00 69.26           C  
ATOM   3441  CG  ASP D  81      95.902  50.324  36.739  1.00 72.25           C  
ATOM   3442  OD1 ASP D  81      96.680  49.700  37.497  1.00 74.01           O  
ATOM   3443  OD2 ASP D  81      96.253  50.791  35.630  1.00 72.77           O  
ATOM   3444  N   MET D  82      94.142  50.308  33.764  1.00 70.23           N  
ATOM   3445  CA  MET D  82      94.357  49.459  32.593  1.00 71.39           C  
ATOM   3446  C   MET D  82      95.423  48.386  32.814  1.00 71.56           C  
ATOM   3447  O   MET D  82      95.384  47.328  32.185  1.00 72.05           O  
ATOM   3448  CB  MET D  82      94.731  50.327  31.385  1.00 72.12           C  
ATOM   3449  N   ASN D  83      96.380  48.659  33.698  1.00 71.92           N  
ATOM   3450  CA  ASN D  83      97.439  47.698  33.997  1.00 72.75           C  
ATOM   3451  C   ASN D  83      96.891  46.630  34.945  1.00 73.25           C  
ATOM   3452  O   ASN D  83      97.596  46.147  35.832  1.00 73.94           O  
ATOM   3453  CB  ASN D  83      98.637  48.410  34.634  1.00 71.85           C  
ATOM   3454  N   ASP D  84      95.627  46.269  34.749  1.00 73.27           N  
ATOM   3455  CA  ASP D  84      94.974  45.271  35.586  1.00 72.56           C  
ATOM   3456  C   ASP D  84      94.007  44.411  34.771  1.00 71.99           C  
ATOM   3457  O   ASP D  84      93.352  43.519  35.315  1.00 71.13           O  
ATOM   3458  CB  ASP D  84      94.231  45.966  36.732  1.00 72.82           C  
ATOM   3459  N   PHE D  85      93.930  44.679  33.468  1.00 70.73           N  
ATOM   3460  CA  PHE D  85      93.041  43.940  32.574  1.00 70.87           C  
ATOM   3461  C   PHE D  85      93.509  42.508  32.319  1.00 70.58           C  
ATOM   3462  O   PHE D  85      92.935  41.800  31.486  1.00 70.60           O  
ATOM   3463  CB  PHE D  85      92.904  44.682  31.242  1.00 69.86           C  
ATOM   3464  N   ALA D  86      94.540  42.079  33.044  1.00 69.92           N  
ATOM   3465  CA  ALA D  86      95.096  40.737  32.877  1.00 68.90           C  
ATOM   3466  C   ALA D  86      94.689  39.758  33.977  1.00 68.12           C  
ATOM   3467  O   ALA D  86      94.149  38.683  33.697  1.00 67.42           O  
ATOM   3468  CB  ALA D  86      96.613  40.820  32.792  1.00 68.74           C  
ATOM   3469  N   LYS D  87      94.972  40.119  35.226  1.00 67.42           N  
ATOM   3470  CA  LYS D  87      94.622  39.270  36.359  1.00 65.80           C  
ATOM   3471  C   LYS D  87      93.102  39.167  36.409  1.00 64.66           C  
ATOM   3472  O   LYS D  87      92.551  38.169  36.887  1.00 64.34           O  
ATOM   3473  CB  LYS D  87      95.161  39.874  37.652  1.00 66.23           C  
ATOM   3474  N   MET D  88      92.440  40.208  35.905  1.00 62.39           N  
ATOM   3475  CA  MET D  88      90.981  40.276  35.850  1.00 61.57           C  
ATOM   3476  C   MET D  88      90.469  39.260  34.825  1.00 60.42           C  
ATOM   3477  O   MET D  88      89.516  38.518  35.085  1.00 58.89           O  
ATOM   3478  CB  MET D  88      90.546  41.699  35.450  1.00 62.00           C  
ATOM   3479  CG  MET D  88      89.035  41.932  35.313  1.00 60.98           C  
ATOM   3480  SD  MET D  88      88.273  41.235  33.814  1.00 61.51           S  
ATOM   3481  CE  MET D  88      88.690  42.491  32.591  1.00 59.07           C  
ATOM   3482  N   ASN D  89      91.123  39.233  33.666  1.00 58.51           N  
ATOM   3483  CA  ASN D  89      90.761  38.321  32.586  1.00 56.89           C  
ATOM   3484  C   ASN D  89      91.061  36.869  32.970  1.00 55.69           C  
ATOM   3485  O   ASN D  89      90.628  35.933  32.300  1.00 56.93           O  
ATOM   3486  CB  ASN D  89      91.533  38.697  31.316  1.00 56.56           C  
ATOM   3487  CG  ASN D  89      90.860  38.197  30.057  1.00 54.78           C  
ATOM   3488  OD1 ASN D  89      89.772  38.651  29.703  1.00 54.89           O  
ATOM   3489  ND2 ASN D  89      91.501  37.258  29.372  1.00 53.28           N  
ATOM   3490  N   GLU D  90      91.804  36.689  34.055  1.00 54.04           N  
ATOM   3491  CA  GLU D  90      92.162  35.361  34.539  1.00 52.89           C  
ATOM   3492  C   GLU D  90      90.990  34.684  35.264  1.00 50.19           C  
ATOM   3493  O   GLU D  90      90.700  33.503  35.051  1.00 49.05           O  
ATOM   3494  CB  GLU D  90      93.353  35.476  35.493  1.00 56.61           C  
ATOM   3495  CG  GLU D  90      93.815  34.152  36.084  1.00 60.65           C  
ATOM   3496  CD  GLU D  90      94.633  33.337  35.107  1.00 63.36           C  
ATOM   3497  OE1 GLU D  90      95.790  33.728  34.836  1.00 64.38           O  
ATOM   3498  OE2 GLU D  90      94.117  32.312  34.611  1.00 65.67           O  
ATOM   3499  N   VAL D  91      90.329  35.443  36.131  1.00 47.47           N  
ATOM   3500  CA  VAL D  91      89.197  34.937  36.904  1.00 44.96           C  
ATOM   3501  C   VAL D  91      87.952  34.930  36.039  1.00 41.61           C  
ATOM   3502  O   VAL D  91      87.109  34.047  36.135  1.00 39.54           O  
ATOM   3503  CB  VAL D  91      88.933  35.824  38.134  1.00 45.37           C  
ATOM   3504  CG1 VAL D  91      87.788  35.251  38.965  1.00 46.11           C  
ATOM   3505  CG2 VAL D  91      90.198  35.937  38.959  1.00 44.65           C  
ATOM   3506  N   TYR D  92      87.864  35.942  35.192  1.00 40.18           N  
ATOM   3507  CA  TYR D  92      86.755  36.113  34.274  1.00 39.47           C  
ATOM   3508  C   TYR D  92      86.542  34.853  33.415  1.00 37.18           C  
ATOM   3509  O   TYR D  92      85.413  34.397  33.234  1.00 31.04           O  
ATOM   3510  CB  TYR D  92      87.044  37.344  33.407  1.00 42.16           C  
ATOM   3511  CG  TYR D  92      85.918  37.768  32.504  1.00 46.09           C  
ATOM   3512  CD1 TYR D  92      85.741  37.178  31.251  1.00 47.94           C  
ATOM   3513  CD2 TYR D  92      85.026  38.767  32.896  1.00 47.87           C  
ATOM   3514  CE1 TYR D  92      84.712  37.571  30.405  1.00 48.46           C  
ATOM   3515  CE2 TYR D  92      83.987  39.171  32.055  1.00 49.65           C  
ATOM   3516  CZ  TYR D  92      83.840  38.569  30.809  1.00 49.03           C  
ATOM   3517  OH  TYR D  92      82.838  38.977  29.961  1.00 48.77           O  
ATOM   3518  N   ALA D  93      87.639  34.291  32.908  1.00 37.00           N  
ATOM   3519  CA  ALA D  93      87.588  33.093  32.078  1.00 37.07           C  
ATOM   3520  C   ALA D  93      86.899  31.935  32.791  1.00 37.46           C  
ATOM   3521  O   ALA D  93      86.291  31.074  32.165  1.00 37.56           O  
ATOM   3522  CB  ALA D  93      88.993  32.693  31.675  1.00 37.70           C  
ATOM   3523  N   GLU D  94      86.998  31.924  34.111  1.00 39.33           N  
ATOM   3524  CA  GLU D  94      86.386  30.887  34.929  1.00 40.01           C  
ATOM   3525  C   GLU D  94      84.862  30.963  34.930  1.00 38.51           C  
ATOM   3526  O   GLU D  94      84.180  29.952  35.080  1.00 37.81           O  
ATOM   3527  CB  GLU D  94      86.915  31.000  36.356  1.00 43.78           C  
ATOM   3528  CG  GLU D  94      88.422  30.822  36.440  1.00 50.84           C  
ATOM   3529  CD  GLU D  94      88.995  31.240  37.777  1.00 55.47           C  
ATOM   3530  OE1 GLU D  94      88.468  30.791  38.816  1.00 58.49           O  
ATOM   3531  OE2 GLU D  94      89.979  32.016  37.784  1.00 59.29           O  
ATOM   3532  N   TYR D  95      84.324  32.164  34.762  1.00 37.26           N  
ATOM   3533  CA  TYR D  95      82.877  32.340  34.751  1.00 35.63           C  
ATOM   3534  C   TYR D  95      82.297  32.421  33.349  1.00 33.09           C  
ATOM   3535  O   TYR D  95      81.210  31.913  33.081  1.00 33.08           O  
ATOM   3536  CB  TYR D  95      82.484  33.614  35.510  1.00 37.16           C  
ATOM   3537  CG  TYR D  95      82.747  33.561  36.996  1.00 39.25           C  
ATOM   3538  CD1 TYR D  95      84.016  33.826  37.512  1.00 39.15           C  
ATOM   3539  CD2 TYR D  95      81.726  33.237  37.891  1.00 39.04           C  
ATOM   3540  CE1 TYR D  95      84.261  33.770  38.877  1.00 39.13           C  
ATOM   3541  CE2 TYR D  95      81.961  33.178  39.259  1.00 39.58           C  
ATOM   3542  CZ  TYR D  95      83.229  33.445  39.745  1.00 39.25           C  
ATOM   3543  OH  TYR D  95      83.465  33.381  41.100  1.00 40.94           O  
ATOM   3544  N   PHE D  96      83.027  33.054  32.444  1.00 31.83           N  
ATOM   3545  CA  PHE D  96      82.524  33.229  31.090  1.00 30.96           C  
ATOM   3546  C   PHE D  96      83.310  32.558  29.999  1.00 30.88           C  
ATOM   3547  O   PHE D  96      83.137  32.886  28.840  1.00 29.68           O  
ATOM   3548  CB  PHE D  96      82.394  34.719  30.777  1.00 27.90           C  
ATOM   3549  CG  PHE D  96      81.329  35.399  31.568  1.00 24.89           C  
ATOM   3550  CD1 PHE D  96      80.024  34.913  31.551  1.00 25.35           C  
ATOM   3551  CD2 PHE D  96      81.623  36.508  32.344  1.00 24.20           C  
ATOM   3552  CE1 PHE D  96      79.020  35.521  32.300  1.00 24.37           C  
ATOM   3553  CE2 PHE D  96      80.628  37.127  33.097  1.00 23.52           C  
ATOM   3554  CZ  PHE D  96      79.324  36.633  33.075  1.00 23.81           C  
ATOM   3555  N   GLY D  97      84.159  31.609  30.369  1.00 34.16           N  
ATOM   3556  CA  GLY D  97      84.962  30.915  29.378  1.00 35.29           C  
ATOM   3557  C   GLY D  97      84.160  29.969  28.502  1.00 35.65           C  
ATOM   3558  O   GLY D  97      84.637  29.547  27.453  1.00 36.04           O  
ATOM   3559  N   GLU D  98      82.943  29.634  28.913  1.00 34.95           N  
ATOM   3560  CA  GLU D  98      82.146  28.723  28.116  1.00 36.50           C  
ATOM   3561  C   GLU D  98      81.041  29.428  27.326  1.00 37.29           C  
ATOM   3562  O   GLU D  98      80.694  28.994  26.225  1.00 37.38           O  
ATOM   3563  CB  GLU D  98      81.573  27.609  29.007  1.00 38.23           C  
ATOM   3564  CG  GLU D  98      80.056  27.624  29.210  1.00 41.55           C  
ATOM   3565  CD  GLU D  98      79.602  28.553  30.318  1.00 41.59           C  
ATOM   3566  OE1 GLU D  98      78.417  28.458  30.701  1.00 39.55           O  
ATOM   3567  OE2 GLU D  98      80.421  29.371  30.804  1.00 43.87           O  
ATOM   3568  N   SER D  99      80.498  30.514  27.875  1.00 36.82           N  
ATOM   3569  CA  SER D  99      79.444  31.257  27.188  1.00 36.20           C  
ATOM   3570  C   SER D  99      80.013  32.349  26.276  1.00 35.26           C  
ATOM   3571  O   SER D  99      79.418  32.673  25.247  1.00 34.82           O  
ATOM   3572  CB  SER D  99      78.463  31.876  28.200  1.00 37.03           C  
ATOM   3573  OG  SER D  99      79.052  32.916  28.961  1.00 35.42           O  
ATOM   3574  N   LYS D 100      81.162  32.902  26.664  1.00 32.77           N  
ATOM   3575  CA  LYS D 100      81.858  33.947  25.906  1.00 32.64           C  
ATOM   3576  C   LYS D 100      80.945  35.035  25.358  1.00 31.04           C  
ATOM   3577  O   LYS D 100      80.755  35.148  24.148  1.00 30.82           O  
ATOM   3578  CB  LYS D 100      82.640  33.332  24.738  1.00 35.39           C  
ATOM   3579  CG  LYS D 100      83.641  32.254  25.126  1.00 37.63           C  
ATOM   3580  CD  LYS D 100      84.164  31.551  23.886  1.00 40.09           C  
ATOM   3581  CE  LYS D 100      85.038  30.360  24.239  1.00 42.85           C  
ATOM   3582  NZ  LYS D 100      85.526  29.664  23.006  1.00 46.39           N  
ATOM   3583  N   PRO D 101      80.396  35.874  26.245  1.00 29.33           N  
ATOM   3584  CA  PRO D 101      79.498  36.965  25.856  1.00 27.21           C  
ATOM   3585  C   PRO D 101      80.241  38.044  25.065  1.00 27.01           C  
ATOM   3586  O   PRO D 101      81.469  38.019  24.958  1.00 28.65           O  
ATOM   3587  CB  PRO D 101      79.018  37.524  27.195  1.00 27.26           C  
ATOM   3588  CG  PRO D 101      79.625  36.593  28.268  1.00 27.80           C  
ATOM   3589  CD  PRO D 101      80.833  36.027  27.641  1.00 27.86           C  
ATOM   3590  N   ALA D 102      79.498  38.988  24.501  1.00 25.83           N  
ATOM   3591  CA  ALA D 102      80.124  40.090  23.788  1.00 26.31           C  
ATOM   3592  C   ALA D 102      80.614  41.016  24.898  1.00 26.65           C  
ATOM   3593  O   ALA D 102      79.919  41.212  25.889  1.00 25.93           O  
ATOM   3594  CB  ALA D 102      79.107  40.807  22.918  1.00 26.63           C  
ATOM   3595  N   ARG D 103      81.801  41.589  24.746  1.00 29.29           N  
ATOM   3596  CA  ARG D 103      82.324  42.458  25.790  1.00 29.94           C  
ATOM   3597  C   ARG D 103      82.909  43.801  25.371  1.00 29.80           C  
ATOM   3598  O   ARG D 103      83.420  43.984  24.266  1.00 28.04           O  
ATOM   3599  CB  ARG D 103      83.376  41.707  26.601  1.00 32.73           C  
ATOM   3600  CG  ARG D 103      83.945  42.498  27.769  1.00 37.27           C  
ATOM   3601  CD  ARG D 103      85.068  41.738  28.442  1.00 40.54           C  
ATOM   3602  NE  ARG D 103      86.210  41.555  27.553  1.00 44.41           N  
ATOM   3603  CZ  ARG D 103      87.193  40.687  27.777  1.00 48.56           C  
ATOM   3604  NH1 ARG D 103      87.175  39.919  28.863  1.00 51.14           N  
ATOM   3605  NH2 ARG D 103      88.193  40.583  26.911  1.00 50.38           N  
ATOM   3606  N   VAL D 104      82.814  44.731  26.307  1.00 30.66           N  
ATOM   3607  CA  VAL D 104      83.333  46.083  26.187  1.00 30.58           C  
ATOM   3608  C   VAL D 104      84.156  46.252  27.457  1.00 31.81           C  
ATOM   3609  O   VAL D 104      83.664  46.011  28.553  1.00 31.58           O  
ATOM   3610  CB  VAL D 104      82.194  47.124  26.181  1.00 30.19           C  
ATOM   3611  CG1 VAL D 104      82.693  48.471  26.696  1.00 28.71           C  
ATOM   3612  CG2 VAL D 104      81.629  47.256  24.776  1.00 28.25           C  
ATOM   3613  N   ALA D 105      85.415  46.629  27.307  1.00 34.39           N  
ATOM   3614  CA  ALA D 105      86.285  46.826  28.457  1.00 35.87           C  
ATOM   3615  C   ALA D 105      86.884  48.214  28.316  1.00 37.50           C  
ATOM   3616  O   ALA D 105      87.500  48.531  27.298  1.00 38.43           O  
ATOM   3617  CB  ALA D 105      87.379  45.773  28.475  1.00 36.91           C  
ATOM   3618  N   VAL D 106      86.702  49.043  29.336  1.00 38.56           N  
ATOM   3619  CA  VAL D 106      87.205  50.404  29.283  1.00 40.51           C  
ATOM   3620  C   VAL D 106      87.734  50.892  30.622  1.00 41.63           C  
ATOM   3621  O   VAL D 106      87.325  50.409  31.673  1.00 41.40           O  
ATOM   3622  CB  VAL D 106      86.091  51.360  28.834  1.00 40.72           C  
ATOM   3623  CG1 VAL D 106      84.920  51.262  29.795  1.00 40.61           C  
ATOM   3624  CG2 VAL D 106      86.609  52.781  28.797  1.00 42.17           C  
ATOM   3625  N   GLU D 107      88.650  51.854  30.578  1.00 44.41           N  
ATOM   3626  CA  GLU D 107      89.197  52.422  31.802  1.00 46.13           C  
ATOM   3627  C   GLU D 107      88.513  53.759  32.044  1.00 45.76           C  
ATOM   3628  O   GLU D 107      88.470  54.621  31.161  1.00 46.02           O  
ATOM   3629  CB  GLU D 107      90.708  52.639  31.700  1.00 49.15           C  
ATOM   3630  CG  GLU D 107      91.338  52.996  33.048  1.00 53.66           C  
ATOM   3631  CD  GLU D 107      92.755  53.530  32.928  1.00 55.73           C  
ATOM   3632  OE1 GLU D 107      92.915  54.736  32.635  1.00 56.40           O  
ATOM   3633  OE2 GLU D 107      93.706  52.742  33.124  1.00 56.55           O  
ATOM   3634  N   VAL D 108      87.981  53.916  33.250  1.00 45.59           N  
ATOM   3635  CA  VAL D 108      87.271  55.124  33.646  1.00 44.61           C  
ATOM   3636  C   VAL D 108      88.030  55.903  34.717  1.00 44.82           C  
ATOM   3637  O   VAL D 108      88.972  55.391  35.319  1.00 46.37           O  
ATOM   3638  CB  VAL D 108      85.864  54.777  34.186  1.00 44.51           C  
ATOM   3639  CG1 VAL D 108      84.999  54.238  33.065  1.00 41.59           C  
ATOM   3640  CG2 VAL D 108      85.976  53.749  35.319  1.00 42.52           C  
ATOM   3641  N   SER D 109      87.608  57.143  34.952  1.00 44.41           N  
ATOM   3642  CA  SER D 109      88.246  57.998  35.945  1.00 44.59           C  
ATOM   3643  C   SER D 109      88.074  57.443  37.356  1.00 45.47           C  
ATOM   3644  O   SER D 109      89.056  57.186  38.059  1.00 44.09           O  
ATOM   3645  CB  SER D 109      87.664  59.406  35.864  1.00 42.51           C  
ATOM   3646  OG  SER D 109      87.962  59.982  34.610  1.00 41.03           O  
ATOM   3647  N   ARG D 110      86.824  57.267  37.770  1.00 45.92           N  
ATOM   3648  CA  ARG D 110      86.551  56.724  39.088  1.00 47.66           C  
ATOM   3649  C   ARG D 110      85.267  55.898  39.080  1.00 47.16           C  
ATOM   3650  O   ARG D 110      84.370  56.127  38.265  1.00 45.14           O  
ATOM   3651  CB  ARG D 110      86.467  57.855  40.120  1.00 50.12           C  
ATOM   3652  CG  ARG D 110      86.288  57.377  41.560  1.00 53.83           C  
ATOM   3653  CD  ARG D 110      86.590  58.481  42.573  1.00 57.36           C  
ATOM   3654  NE  ARG D 110      86.154  58.123  43.926  1.00 60.97           N  
ATOM   3655  CZ  ARG D 110      86.537  58.752  45.038  1.00 60.64           C  
ATOM   3656  NH1 ARG D 110      87.376  59.781  44.972  1.00 60.16           N  
ATOM   3657  NH2 ARG D 110      86.073  58.354  46.219  1.00 59.55           N  
ATOM   3658  N   LEU D 111      85.209  54.925  39.988  1.00 46.93           N  
ATOM   3659  CA  LEU D 111      84.068  54.028  40.139  1.00 46.22           C  
ATOM   3660  C   LEU D 111      83.470  54.209  41.528  1.00 48.24           C  
ATOM   3661  O   LEU D 111      84.156  54.647  42.450  1.00 48.10           O  
ATOM   3662  CB  LEU D 111      84.521  52.580  39.980  1.00 43.20           C  
ATOM   3663  CG  LEU D 111      85.099  52.214  38.618  1.00 42.43           C  
ATOM   3664  CD1 LEU D 111      85.905  50.936  38.723  1.00 40.13           C  
ATOM   3665  CD2 LEU D 111      83.960  52.080  37.616  1.00 41.56           C  
ATOM   3666  N   PRO D 112      82.182  53.863  41.700  1.00 50.05           N  
ATOM   3667  CA  PRO D 112      81.514  53.998  43.003  1.00 50.33           C  
ATOM   3668  C   PRO D 112      82.348  53.459  44.177  1.00 50.51           C  
ATOM   3669  O   PRO D 112      82.982  52.413  44.062  1.00 50.54           O  
ATOM   3670  CB  PRO D 112      80.216  53.224  42.793  1.00 50.00           C  
ATOM   3671  CG  PRO D 112      79.904  53.519  41.355  1.00 49.61           C  
ATOM   3672  CD  PRO D 112      81.248  53.338  40.685  1.00 49.34           C  
ATOM   3673  N   LYS D 113      82.343  54.189  45.295  1.00 50.96           N  
ATOM   3674  CA  LYS D 113      83.092  53.819  46.505  1.00 51.08           C  
ATOM   3675  C   LYS D 113      84.598  53.616  46.271  1.00 50.43           C  
ATOM   3676  O   LYS D 113      85.295  53.024  47.102  1.00 47.40           O  
ATOM   3677  CB  LYS D 113      82.499  52.556  47.141  1.00 51.61           C  
ATOM   3678  CG  LYS D 113      81.071  52.695  47.651  1.00 54.19           C  
ATOM   3679  CD  LYS D 113      80.056  52.725  46.509  1.00 57.16           C  
ATOM   3680  CE  LYS D 113      78.613  52.646  47.022  1.00 57.01           C  
ATOM   3681  NZ  LYS D 113      77.596  52.635  45.920  1.00 55.53           N  
ATOM   3682  N   ASP D 114      85.081  54.102  45.128  1.00 51.28           N  
ATOM   3683  CA  ASP D 114      86.495  54.017  44.736  1.00 52.16           C  
ATOM   3684  C   ASP D 114      86.999  52.598  44.452  1.00 50.00           C  
ATOM   3685  O   ASP D 114      88.203  52.347  44.488  1.00 51.30           O  
ATOM   3686  CB  ASP D 114      87.388  54.652  45.814  1.00 55.83           C  
ATOM   3687  CG  ASP D 114      88.782  55.007  45.297  1.00 58.73           C  
ATOM   3688  OD1 ASP D 114      89.739  54.998  46.105  1.00 58.61           O  
ATOM   3689  OD2 ASP D 114      88.916  55.310  44.088  1.00 60.86           O  
ATOM   3690  N   VAL D 115      86.095  51.670  44.167  1.00 46.24           N  
ATOM   3691  CA  VAL D 115      86.519  50.308  43.880  1.00 42.80           C  
ATOM   3692  C   VAL D 115      87.405  50.277  42.633  1.00 43.17           C  
ATOM   3693  O   VAL D 115      87.563  51.289  41.943  1.00 43.33           O  
ATOM   3694  CB  VAL D 115      85.311  49.393  43.674  1.00 40.62           C  
ATOM   3695  CG1 VAL D 115      84.359  49.543  44.849  1.00 38.17           C  
ATOM   3696  CG2 VAL D 115      84.625  49.717  42.364  1.00 36.41           C  
ATOM   3697  N   LEU D 116      87.982  49.116  42.342  1.00 41.33           N  
ATOM   3698  CA  LEU D 116      88.862  48.976  41.188  1.00 40.60           C  
ATOM   3699  C   LEU D 116      88.140  48.489  39.939  1.00 39.52           C  
ATOM   3700  O   LEU D 116      88.623  48.664  38.811  1.00 39.73           O  
ATOM   3701  CB  LEU D 116      89.989  47.990  41.508  1.00 42.32           C  
ATOM   3702  CG  LEU D 116      90.846  48.240  42.749  1.00 43.06           C  
ATOM   3703  CD1 LEU D 116      91.909  47.165  42.834  1.00 41.09           C  
ATOM   3704  CD2 LEU D 116      91.484  49.629  42.679  1.00 42.56           C  
ATOM   3705  N   ILE D 117      86.976  47.887  40.132  1.00 38.15           N  
ATOM   3706  CA  ILE D 117      86.251  47.344  39.003  1.00 37.29           C  
ATOM   3707  C   ILE D 117      84.746  47.281  39.212  1.00 36.76           C  
ATOM   3708  O   ILE D 117      84.275  46.999  40.311  1.00 35.94           O  
ATOM   3709  CB  ILE D 117      86.774  45.930  38.701  1.00 36.89           C  
ATOM   3710  CG1 ILE D 117      86.163  45.400  37.408  1.00 35.13           C  
ATOM   3711  CG2 ILE D 117      86.476  45.009  39.886  1.00 33.14           C  
ATOM   3712  CD1 ILE D 117      86.776  44.096  36.971  1.00 38.12           C  
ATOM   3713  N   GLU D 118      84.007  47.545  38.137  1.00 35.71           N  
ATOM   3714  CA  GLU D 118      82.551  47.503  38.141  1.00 36.24           C  
ATOM   3715  C   GLU D 118      82.136  46.780  36.865  1.00 33.86           C  
ATOM   3716  O   GLU D 118      82.652  47.060  35.780  1.00 33.16           O  
ATOM   3717  CB  GLU D 118      81.960  48.919  38.147  1.00 39.90           C  
ATOM   3718  CG  GLU D 118      80.457  48.965  38.389  1.00 43.03           C  
ATOM   3719  CD  GLU D 118      79.873  50.361  38.245  1.00 47.35           C  
ATOM   3720  OE1 GLU D 118      80.540  51.333  38.657  1.00 51.68           O  
ATOM   3721  OE2 GLU D 118      78.739  50.491  37.732  1.00 48.86           O  
ATOM   3722  N   ILE D 119      81.197  45.852  36.993  1.00 31.83           N  
ATOM   3723  CA  ILE D 119      80.752  45.086  35.843  1.00 28.65           C  
ATOM   3724  C   ILE D 119      79.240  45.033  35.698  1.00 26.68           C  
ATOM   3725  O   ILE D 119      78.534  44.715  36.650  1.00 25.46           O  
ATOM   3726  CB  ILE D 119      81.315  43.640  35.920  1.00 28.33           C  
ATOM   3727  CG1 ILE D 119      82.839  43.671  35.750  1.00 30.35           C  
ATOM   3728  CG2 ILE D 119      80.695  42.773  34.854  1.00 26.78           C  
ATOM   3729  CD1 ILE D 119      83.516  42.303  35.872  1.00 30.00           C  
ATOM   3730  N   GLU D 120      78.744  45.372  34.510  1.00 27.07           N  
ATOM   3731  CA  GLU D 120      77.307  45.294  34.238  1.00 28.63           C  
ATOM   3732  C   GLU D 120      77.141  44.185  33.190  1.00 26.48           C  
ATOM   3733  O   GLU D 120      78.064  43.922  32.411  1.00 26.31           O  
ATOM   3734  CB  GLU D 120      76.749  46.632  33.718  1.00 30.77           C  
ATOM   3735  CG  GLU D 120      77.116  47.000  32.284  1.00 38.99           C  
ATOM   3736  CD  GLU D 120      76.404  48.270  31.802  1.00 43.33           C  
ATOM   3737  OE1 GLU D 120      75.177  48.364  32.022  1.00 46.60           O  
ATOM   3738  OE2 GLU D 120      77.055  49.165  31.199  1.00 42.78           O  
ATOM   3739  N   ALA D 121      75.991  43.513  33.187  1.00 23.19           N  
ATOM   3740  CA  ALA D 121      75.760  42.433  32.228  1.00 20.66           C  
ATOM   3741  C   ALA D 121      74.314  42.289  31.766  1.00 20.08           C  
ATOM   3742  O   ALA D 121      73.367  42.648  32.466  1.00 18.74           O  
ATOM   3743  CB  ALA D 121      76.234  41.108  32.813  1.00 19.12           C  
ATOM   3744  N   ILE D 122      74.157  41.754  30.567  1.00 19.32           N  
ATOM   3745  CA  ILE D 122      72.841  41.524  30.014  1.00 19.61           C  
ATOM   3746  C   ILE D 122      72.744  40.050  29.674  1.00 19.28           C  
ATOM   3747  O   ILE D 122      73.684  39.474  29.115  1.00 20.29           O  
ATOM   3748  CB  ILE D 122      72.603  42.373  28.752  1.00 19.10           C  
ATOM   3749  CG1 ILE D 122      72.599  43.851  29.133  1.00 18.71           C  
ATOM   3750  CG2 ILE D 122      71.253  42.015  28.128  1.00 18.95           C  
ATOM   3751  CD1 ILE D 122      72.360  44.779  27.977  1.00 21.68           C  
ATOM   3752  N   ALA D 123      71.617  39.436  30.018  1.00 16.94           N  
ATOM   3753  CA  ALA D 123      71.421  38.020  29.739  1.00 16.59           C  
ATOM   3754  C   ALA D 123      70.132  37.818  28.952  1.00 18.50           C  
ATOM   3755  O   ALA D 123      69.237  38.649  28.985  1.00 19.34           O  
ATOM   3756  CB  ALA D 123      71.386  37.206  31.062  1.00 13.02           C  
ATOM   3757  N   TYR D 124      70.050  36.697  28.246  1.00 22.16           N  
ATOM   3758  CA  TYR D 124      68.892  36.372  27.430  1.00 24.21           C  
ATOM   3759  C   TYR D 124      68.542  34.918  27.651  1.00 26.33           C  
ATOM   3760  O   TYR D 124      69.414  34.070  27.716  1.00 26.46           O  
ATOM   3761  CB  TYR D 124      69.228  36.576  25.950  1.00 24.59           C  
ATOM   3762  CG  TYR D 124      68.167  36.099  24.979  1.00 25.28           C  
ATOM   3763  CD1 TYR D 124      67.009  36.847  24.762  1.00 26.03           C  
ATOM   3764  CD2 TYR D 124      68.336  34.919  24.250  1.00 25.33           C  
ATOM   3765  CE1 TYR D 124      66.048  36.447  23.846  1.00 26.46           C  
ATOM   3766  CE2 TYR D 124      67.367  34.501  23.325  1.00 27.79           C  
ATOM   3767  CZ  TYR D 124      66.230  35.284  23.129  1.00 28.59           C  
ATOM   3768  OH  TYR D 124      65.278  34.932  22.203  1.00 32.74           O  
ATOM   3769  N   LYS D 125      67.259  34.637  27.761  1.00 30.65           N  
ATOM   3770  CA  LYS D 125      66.794  33.274  27.947  1.00 34.56           C  
ATOM   3771  C   LYS D 125      65.792  33.070  26.818  1.00 36.59           C  
ATOM   3772  O   LYS D 125      64.875  33.866  26.648  1.00 36.98           O  
ATOM   3773  CB  LYS D 125      66.113  33.143  29.307  1.00 35.81           C  
ATOM   3774  CG  LYS D 125      66.108  31.755  29.895  1.00 37.72           C  
ATOM   3775  CD  LYS D 125      65.349  31.768  31.216  1.00 42.93           C  
ATOM   3776  CE  LYS D 125      65.355  30.404  31.887  1.00 46.38           C  
ATOM   3777  NZ  LYS D 125      64.453  30.360  33.078  1.00 47.82           N  
ATOM   3778  N   GLU D 126      65.982  32.023  26.030  1.00 40.35           N  
ATOM   3779  CA  GLU D 126      65.082  31.752  24.915  1.00 45.78           C  
ATOM   3780  C   GLU D 126      63.693  31.346  25.432  1.00 46.51           C  
ATOM   3781  O   GLU D 126      63.616  30.770  26.542  1.00 44.20           O  
ATOM   3782  CB  GLU D 126      65.669  30.639  24.034  1.00 48.72           C  
ATOM   3783  CG  GLU D 126      67.178  30.790  23.752  1.00 53.50           C  
ATOM   3784  CD  GLU D 126      68.061  30.601  24.998  1.00 55.05           C  
ATOM   3785  OE1 GLU D 126      69.287  30.845  24.905  1.00 56.08           O  
ATOM   3786  OE2 GLU D 126      67.540  30.202  26.067  1.00 53.93           O  
ATOM   3787  OXT GLU D 126      62.697  31.611  24.716  1.00 48.58           O  
TER    3788      GLU D 126                                                      
END
MOLECULE T0423.pdb
ATOM  12910  N   MET     1      70.981  21.031  37.362  1.00 36.76           N  
ATOM  12911  CA  MET     1      71.905  21.930  36.664  1.00 38.87           C  
ATOM  12912  C   MET     1      72.311  23.119  37.519  1.00 35.58           C  
ATOM  12913  O   MET     1      73.455  23.538  37.475  1.00 34.69           O  
ATOM  12914  CB  MET     1      71.283  22.461  35.383  1.00 39.21           C  
ATOM  12915  CG  MET     1      71.504  21.613  34.171  1.00 44.40           C  
ATOM  12916  SD  MET     1      70.806  22.501  32.558  1.00 57.84          SE  
ATOM  12917  CE  MET     1      71.792  24.214  32.666  1.00 53.65           C  
ATOM  12918  N   SER     2      71.368  23.671  38.275  1.00 34.19           N  
ATOM  12919  CA  SER     2      71.660  24.824  39.146  1.00 33.25           C  
ATOM  12920  C   SER     2      72.590  24.410  40.267  1.00 32.21           C  
ATOM  12921  O   SER     2      73.492  25.167  40.644  1.00 30.89           O  
ATOM  12922  CB  SER     2      70.389  25.426  39.738  1.00 32.90           C  
ATOM  12923  OG  SER     2      69.633  26.060  38.749  1.00 33.07           O  
ATOM  12924  N   ASP     3      72.374  23.203  40.811  1.00 30.62           N  
ATOM  12925  CA  ASP     3      73.242  22.687  41.862  1.00 30.33           C  
ATOM  12926  C   ASP     3      74.682  22.556  41.347  1.00 28.94           C  
ATOM  12927  O   ASP     3      75.638  22.825  42.091  1.00 29.92           O  
ATOM  12928  CB  ASP     3      72.774  21.291  42.370  1.00 30.67           C  
ATOM  12929  CG  ASP     3      71.492  21.328  43.198  1.00 32.38           C  
ATOM  12930  OD1 ASP     3      71.019  22.402  43.615  1.00 35.40           O  
ATOM  12931  OD2 ASP     3      70.942  20.230  43.448  1.00 35.26           O  
ATOM  12932  N   VAL     4      74.823  22.096  40.101  1.00 27.71           N  
ATOM  12933  CA  VAL     4      76.127  21.864  39.482  1.00 27.34           C  
ATOM  12934  C   VAL     4      76.846  23.203  39.304  1.00 26.70           C  
ATOM  12935  O   VAL     4      78.035  23.311  39.582  1.00 25.89           O  
ATOM  12936  CB  VAL     4      75.994  21.175  38.115  1.00 27.32           C  
ATOM  12937  CG1 VAL     4      77.261  21.282  37.304  1.00 28.31           C  
ATOM  12938  CG2 VAL     4      75.606  19.678  38.300  1.00 27.74           C  
ATOM  12939  N   ILE     5      76.114  24.200  38.836  1.00 26.35           N  
ATOM  12940  CA  ILE     5      76.694  25.575  38.675  1.00 26.66           C  
ATOM  12941  C   ILE     5      77.167  26.134  40.031  1.00 26.86           C  
ATOM  12942  O   ILE     5      78.302  26.546  40.179  1.00 27.38           O  
ATOM  12943  CB  ILE     5      75.680  26.562  37.999  1.00 26.48           C  
ATOM  12944  CG1 ILE     5      75.346  26.128  36.566  1.00 24.54           C  
ATOM  12945  CG2 ILE     5      76.257  28.001  37.934  1.00 26.07           C  
ATOM  12946  CD1 ILE     5      74.048  26.748  35.988  1.00 26.63           C  
ATOM  12947  N   GLU     6      76.308  26.117  41.034  1.00 27.87           N  
ATOM  12948  CA  GLU     6      76.688  26.606  42.353  1.00 28.66           C  
ATOM  12949  C   GLU     6      77.785  25.768  43.000  1.00 28.15           C  
ATOM  12950  O   GLU     6      78.644  26.303  43.709  1.00 27.19           O  
ATOM  12951  CB  GLU     6      75.481  26.702  43.272  1.00 29.19           C  
ATOM  12952  CG  GLU     6      74.484  27.740  42.832  1.00 31.30           C  
ATOM  12953  CD  GLU     6      73.485  28.113  43.911  1.00 31.61           C  
ATOM  12954  OE1 GLU     6      73.885  28.327  45.083  1.00 38.52           O  
ATOM  12955  OE2 GLU     6      72.296  28.217  43.572  1.00 35.07           O  
ATOM  12956  N   GLY     7      77.769  24.454  42.764  1.00 27.55           N  
ATOM  12957  CA  GLY     7      78.825  23.599  43.252  1.00 27.47           C  
ATOM  12958  C   GLY     7      80.172  23.924  42.647  1.00 27.46           C  
ATOM  12959  O   GLY     7      81.190  23.916  43.348  1.00 28.04           O  
ATOM  12960  N   ARG     8      80.193  24.198  41.351  1.00 27.39           N  
ATOM  12961  CA  ARG     8      81.428  24.591  40.683  1.00 28.18           C  
ATOM  12962  C   ARG     8      81.977  25.901  41.263  1.00 27.87           C  
ATOM  12963  O   ARG     8      83.187  26.055  41.439  1.00 28.10           O  
ATOM  12964  CB  ARG     8      81.219  24.776  39.185  1.00 27.91           C  
ATOM  12965  CG  ARG     8      81.010  23.509  38.405  1.00 28.72           C  
ATOM  12966  CD  ARG     8      80.440  23.881  37.071  1.00 31.46           C  
ATOM  12967  NE  ARG     8      80.192  22.738  36.217  1.00 33.09           N  
ATOM  12968  CZ  ARG     8      79.413  22.752  35.140  1.00 35.77           C  
ATOM  12969  NH1 ARG     8      78.767  23.854  34.762  1.00 36.28           N  
ATOM  12970  NH2 ARG     8      79.267  21.629  34.439  1.00 38.50           N  
ATOM  12971  N   LEU     9      81.077  26.830  41.554  1.00 28.09           N  
ATOM  12972  CA  LEU     9      81.479  28.113  42.139  1.00 28.34           C  
ATOM  12973  C   LEU     9      82.103  27.873  43.539  1.00 28.63           C  
ATOM  12974  O   LEU     9      83.145  28.457  43.874  1.00 27.85           O  
ATOM  12975  CB  LEU     9      80.271  29.044  42.209  1.00 28.43           C  
ATOM  12976  CG  LEU     9      80.543  30.479  42.669  1.00 28.95           C  
ATOM  12977  CD1 LEU     9      81.644  31.110  41.771  1.00 29.20           C  
ATOM  12978  CD2 LEU     9      79.251  31.302  42.651  1.00 29.10           C  
ATOM  12979  N   LYS    10      81.487  26.998  44.343  1.00 28.27           N  
ATOM  12980  CA  LYS    10      82.090  26.586  45.618  1.00 29.09           C  
ATOM  12981  C   LYS    10      83.477  25.946  45.467  1.00 29.33           C  
ATOM  12982  O   LYS    10      84.380  26.178  46.296  1.00 30.06           O  
ATOM  12983  CB  LYS    10      81.155  25.648  46.379  1.00 29.06           C  
ATOM  12984  CG  LYS    10      79.869  26.277  46.842  1.00 29.74           C  
ATOM  12985  CD  LYS    10      79.055  25.300  47.652  1.00 30.41           C  
ATOM  12986  CE  LYS    10      77.739  25.887  48.034  1.00 30.84           C  
ATOM  12987  NZ  LYS    10      76.878  24.856  48.677  1.00 32.89           N  
ATOM  12988  N   GLU    11      83.673  25.166  44.413  1.00 29.53           N  
ATOM  12989  CA  GLU    11      84.977  24.594  44.114  1.00 30.47           C  
ATOM  12990  C   GLU    11      86.011  25.667  43.795  1.00 30.79           C  
ATOM  12991  O   GLU    11      87.190  25.452  44.020  1.00 32.10           O  
ATOM  12992  CB  GLU    11      84.889  23.624  42.946  1.00 30.41           C  
ATOM  12993  CG  GLU    11      84.195  22.304  43.287  1.00 31.53           C  
ATOM  12994  CD  GLU    11      83.980  21.440  42.072  1.00 33.05           C  
ATOM  12995  OE1 GLU    11      83.483  21.935  41.044  1.00 37.69           O  
ATOM  12996  OE2 GLU    11      84.275  20.239  42.144  1.00 40.32           O  
ATOM  12997  N   LEU    12      85.573  26.810  43.266  1.00 30.96           N  
ATOM  12998  CA  LEU    12      86.458  27.982  43.080  1.00 30.36           C  
ATOM  12999  C   LEU    12      86.672  28.813  44.349  1.00 30.69           C  
ATOM  13000  O   LEU    12      87.510  29.730  44.358  1.00 31.30           O  
ATOM  13001  CB  LEU    12      85.912  28.883  41.982  1.00 29.65           C  
ATOM  13002  CG  LEU    12      85.889  28.253  40.603  1.00 29.14           C  
ATOM  13003  CD1 LEU    12      85.193  29.190  39.650  1.00 28.44           C  
ATOM  13004  CD2 LEU    12      87.318  27.916  40.123  1.00 30.62           C  
ATOM  13005  N   GLY    13      85.906  28.530  45.398  1.00 30.88           N  
ATOM  13006  CA  GLY    13      86.097  29.154  46.694  1.00 30.87           C  
ATOM  13007  C   GLY    13      85.047  30.177  47.062  1.00 30.89           C  
ATOM  13008  O   GLY    13      85.157  30.816  48.099  1.00 31.94           O  
ATOM  13009  N   PHE    14      84.004  30.303  46.254  1.00 30.40           N  
ATOM  13010  CA  PHE    14      82.959  31.278  46.509  1.00 30.42           C  
ATOM  13011  C   PHE    14      81.595  30.647  46.801  1.00 31.05           C  
ATOM  13012  O   PHE    14      81.170  29.691  46.147  1.00 30.75           O  
ATOM  13013  CB  PHE    14      82.829  32.227  45.312  1.00 29.97           C  
ATOM  13014  CG  PHE    14      84.106  32.886  44.930  1.00 28.80           C  
ATOM  13015  CD1 PHE    14      84.494  34.057  45.537  1.00 29.32           C  
ATOM  13016  CD2 PHE    14      84.924  32.336  43.954  1.00 28.91           C  
ATOM  13017  CE1 PHE    14      85.688  34.670  45.177  1.00 27.83           C  
ATOM  13018  CE2 PHE    14      86.114  32.938  43.594  1.00 28.84           C  
ATOM  13019  CZ  PHE    14      86.494  34.108  44.214  1.00 28.76           C  
ATOM  13020  N   THR    15      80.906  31.228  47.769  1.00 31.89           N  
ATOM  13021  CA  THR    15      79.480  31.011  47.934  1.00 33.07           C  
ATOM  13022  C   THR    15      78.738  32.270  47.471  1.00 33.07           C  
ATOM  13023  O   THR    15      79.306  33.390  47.471  1.00 32.98           O  
ATOM  13024  CB  THR    15      79.142  30.676  49.406  1.00 33.77           C  
ATOM  13025  OG1 THR    15      79.407  31.816  50.239  1.00 37.27           O  
ATOM  13026  CG2 THR    15      79.988  29.500  49.902  1.00 32.51           C  
ATOM  13027  N   LEU    16      77.488  32.100  47.043  1.00 32.88           N  
ATOM  13028  CA  LEU    16      76.696  33.230  46.573  1.00 32.59           C  
ATOM  13029  C   LEU    16      76.163  34.007  47.767  1.00 33.08           C  
ATOM  13030  O   LEU    16      75.580  33.413  48.678  1.00 32.54           O  
ATOM  13031  CB  LEU    16      75.513  32.781  45.706  1.00 32.47           C  
ATOM  13032  CG  LEU    16      75.834  32.190  44.332  1.00 31.50           C  
ATOM  13033  CD1 LEU    16      74.534  31.595  43.670  1.00 29.77           C  
ATOM  13034  CD2 LEU    16      76.521  33.215  43.434  1.00 28.44           C  
ATOM  13035  N   PRO    17      76.338  35.334  47.771  1.00 33.26           N  
ATOM  13036  CA  PRO    17      75.694  36.103  48.823  1.00 33.95           C  
ATOM  13037  C   PRO    17      74.202  36.176  48.577  1.00 35.74           C  
ATOM  13038  O   PRO    17      73.743  35.890  47.461  1.00 35.40           O  
ATOM  13039  CB  PRO    17      76.304  37.492  48.650  1.00 33.84           C  
ATOM  13040  CG  PRO    17      76.630  37.570  47.219  1.00 33.42           C  
ATOM  13041  CD  PRO    17      77.081  36.198  46.835  1.00 32.52           C  
ATOM  13042  N   VAL    18      73.449  36.584  49.596  1.00 37.90           N  
ATOM  13043  CA  VAL    18      72.045  36.963  49.389  1.00 39.41           C  
ATOM  13044  C   VAL    18      71.995  38.269  48.568  1.00 40.41           C  
ATOM  13045  O   VAL    18      71.230  38.389  47.586  1.00 42.23           O  
ATOM  13046  CB  VAL    18      71.308  37.200  50.710  1.00 39.67           C  
ATOM  13047  CG1 VAL    18      71.505  36.006  51.656  1.00 40.20           C  
ATOM  13048  CG2 VAL    18      71.762  38.513  51.345  1.00 39.98           C  
ATOM  13049  N   ALA    23      66.158  48.786  48.809  1.00 42.30           N  
ATOM  13050  CA  ALA    23      64.939  49.472  48.343  1.00 41.72           C  
ATOM  13051  C   ALA    23      65.286  50.838  47.711  1.00 41.82           C  
ATOM  13052  O   ALA    23      65.606  51.804  48.439  1.00 42.33           O  
ATOM  13053  CB  ALA    23      63.942  49.647  49.513  1.00 42.49           C  
ATOM  13054  N   ALA    24      65.243  50.926  46.370  1.00 40.52           N  
ATOM  13055  CA  ALA    24      65.678  52.154  45.678  1.00 38.94           C  
ATOM  13056  C   ALA    24      64.979  52.405  44.337  1.00 37.86           C  
ATOM  13057  O   ALA    24      64.258  51.549  43.818  1.00 37.65           O  
ATOM  13058  CB  ALA    24      67.220  52.130  45.485  1.00 39.16           C  
ATOM  13059  N   ASN    25      65.207  53.597  43.784  1.00 35.84           N  
ATOM  13060  CA  ASN    25      64.676  53.977  42.458  1.00 34.71           C  
ATOM  13061  C   ASN    25      65.420  53.350  41.277  1.00 32.01           C  
ATOM  13062  O   ASN    25      64.955  53.404  40.128  1.00 30.65           O  
ATOM  13063  CB  ASN    25      64.628  55.506  42.327  1.00 34.31           C  
ATOM  13064  CG  ASN    25      63.556  56.116  43.221  1.00 34.82           C  
ATOM  13065  OD1 ASN    25      63.757  57.167  43.838  1.00 36.03           O  
ATOM  13066  ND2 ASN    25      62.419  55.419  43.327  1.00 31.59           N  
ATOM  13067  N   TYR    26      66.570  52.763  41.572  1.00 30.18           N  
ATOM  13068  CA  TYR    26      67.208  51.824  40.653  1.00 28.61           C  
ATOM  13069  C   TYR    26      67.192  50.433  41.287  1.00 26.27           C  
ATOM  13070  O   TYR    26      67.222  50.261  42.514  1.00 25.81           O  
ATOM  13071  CB  TYR    26      68.625  52.246  40.221  1.00 28.83           C  
ATOM  13072  CG  TYR    26      69.621  52.398  41.339  1.00 30.60           C  
ATOM  13073  CD1 TYR    26      70.670  51.493  41.495  1.00 30.95           C  
ATOM  13074  CD2 TYR    26      69.522  53.456  42.230  1.00 30.60           C  
ATOM  13075  CE1 TYR    26      71.582  51.635  42.510  1.00 30.87           C  
ATOM  13076  CE2 TYR    26      70.411  53.597  43.267  1.00 32.36           C  
ATOM  13077  CZ  TYR    26      71.447  52.689  43.404  1.00 32.75           C  
ATOM  13078  OH  TYR    26      72.352  52.852  44.448  1.00 34.31           O  
ATOM  13079  N   VAL    27      67.135  49.446  40.418  1.00 24.17           N  
ATOM  13080  CA  VAL    27      67.030  48.071  40.817  1.00 22.92           C  
ATOM  13081  C   VAL    27      68.271  47.271  40.393  1.00 22.47           C  
ATOM  13082  O   VAL    27      68.985  47.662  39.463  1.00 20.80           O  
ATOM  13083  CB  VAL    27      65.757  47.458  40.209  1.00 22.53           C  
ATOM  13084  CG1 VAL    27      64.536  48.064  40.881  1.00 24.05           C  
ATOM  13085  CG2 VAL    27      65.709  47.685  38.675  1.00 20.19           C  
ATOM  13086  N   PRO    28      68.514  46.135  41.065  1.00 22.19           N  
ATOM  13087  CA  PRO    28      69.643  45.282  40.693  1.00 22.05           C  
ATOM  13088  C   PRO    28      69.576  44.646  39.313  1.00 21.32           C  
ATOM  13089  O   PRO    28      70.620  44.298  38.758  1.00 19.41           O  
ATOM  13090  CB  PRO    28      69.645  44.208  41.765  1.00 23.32           C  
ATOM  13091  CG  PRO    28      68.744  44.705  42.839  1.00 24.78           C  
ATOM  13092  CD  PRO    28      67.767  45.580  42.209  1.00 22.87           C  
ATOM  13093  N   PHE    29      68.366  44.511  38.760  1.00 20.74           N  
ATOM  13094  CA  PHE    29      68.186  43.931  37.454  1.00 21.35           C  
ATOM  13095  C   PHE    29      66.815  44.278  36.885  1.00 20.78           C  
ATOM  13096  O   PHE    29      65.876  44.597  37.615  1.00 20.82           O  
ATOM  13097  CB  PHE    29      68.410  42.392  37.475  1.00 21.85           C  
ATOM  13098  CG  PHE    29      67.437  41.650  38.360  1.00 22.44           C  
ATOM  13099  CD1 PHE    29      66.175  41.334  37.907  1.00 24.23           C  
ATOM  13100  CD2 PHE    29      67.776  41.337  39.664  1.00 24.23           C  
ATOM  13101  CE1 PHE    29      65.265  40.664  38.746  1.00 23.72           C  
ATOM  13102  CE2 PHE    29      66.883  40.698  40.489  1.00 26.07           C  
ATOM  13103  CZ  PHE    29      65.623  40.381  40.031  1.00 24.55           C  
ATOM  13104  N   THR    30      66.753  44.281  35.568  1.00 21.11           N  
ATOM  13105  CA  THR    30      65.491  44.370  34.819  1.00 22.00           C  
ATOM  13106  C   THR    30      65.480  43.293  33.752  1.00 22.35           C  
ATOM  13107  O   THR    30      66.525  42.798  33.356  1.00 21.01           O  
ATOM  13108  CB  THR    30      65.298  45.735  34.132  1.00 22.63           C  
ATOM  13109  OG1 THR    30      66.405  46.020  33.266  1.00 22.53           O  
ATOM  13110  CG2 THR    30      65.139  46.846  35.164  1.00 21.28           C  
ATOM  13111  N   ILE    31      64.276  42.943  33.280  1.00 23.19           N  
ATOM  13112  CA  ILE    31      64.104  41.993  32.189  1.00 23.67           C  
ATOM  13113  C   ILE    31      63.288  42.634  31.087  1.00 23.56           C  
ATOM  13114  O   ILE    31      62.269  43.294  31.331  1.00 24.21           O  
ATOM  13115  CB  ILE    31      63.424  40.684  32.664  1.00 23.86           C  
ATOM  13116  CG1 ILE    31      64.303  39.977  33.687  1.00 23.74           C  
ATOM  13117  CG2 ILE    31      63.169  39.723  31.486  1.00 24.39           C  
ATOM  13118  CD1 ILE    31      63.577  38.878  34.465  1.00 25.28           C  
ATOM  13119  N   SER    32      63.757  42.461  29.874  1.00 24.00           N  
ATOM  13120  CA  SER    32      63.011  42.846  28.692  1.00 25.73           C  
ATOM  13121  C   SER    32      63.058  41.677  27.730  1.00 25.64           C  
ATOM  13122  O   SER    32      64.122  41.331  27.246  1.00 25.50           O  
ATOM  13123  CB  SER    32      63.598  44.073  28.021  1.00 25.81           C  
ATOM  13124  OG  SER    32      62.809  44.432  26.913  1.00 27.19           O  
ATOM  13125  N   GLY    33      61.903  41.083  27.430  1.00 26.33           N  
ATOM  13126  CA  GLY    33      61.899  39.878  26.629  1.00 26.22           C  
ATOM  13127  C   GLY    33      62.655  38.771  27.314  1.00 25.36           C  
ATOM  13128  O   GLY    33      62.370  38.424  28.457  1.00 26.34           O  
ATOM  13129  N   ASN    34      63.633  38.209  26.622  1.00 24.98           N  
ATOM  13130  CA  ASN    34      64.458  37.178  27.241  1.00 25.51           C  
ATOM  13131  C   ASN    34      65.858  37.705  27.552  1.00 24.78           C  
ATOM  13132  O   ASN    34      66.804  36.930  27.584  1.00 24.18           O  
ATOM  13133  CB  ASN    34      64.528  35.934  26.371  1.00 27.08           C  
ATOM  13134  CG  ASN    34      65.282  36.158  25.091  1.00 30.55           C  
ATOM  13135  OD1 ASN    34      65.607  37.305  24.738  1.00 35.31           O  
ATOM  13136  ND2 ASN    34      65.586  35.057  24.371  1.00 35.76           N  
ATOM  13137  N   LEU    35      65.983  39.022  27.699  1.00 24.55           N  
ATOM  13138  CA  LEU    35      67.277  39.637  28.078  1.00 24.12           C  
ATOM  13139  C   LEU    35      67.189  40.157  29.496  1.00 23.03           C  
ATOM  13140  O   LEU    35      66.268  40.868  29.847  1.00 23.05           O  
ATOM  13141  CB  LEU    35      67.702  40.736  27.096  1.00 24.76           C  
ATOM  13142  CG  LEU    35      68.282  40.199  25.764  1.00 26.16           C  
ATOM  13143  CD1 LEU    35      68.633  41.334  24.793  1.00 28.97           C  
ATOM  13144  CD2 LEU    35      69.489  39.249  25.947  1.00 28.49           C  
ATOM  13145  N   LEU    36      68.148  39.763  30.315  1.00 21.64           N  
ATOM  13146  CA  LEU    36      68.250  40.214  31.693  1.00 20.97           C  
ATOM  13147  C   LEU    36      69.421  41.199  31.776  1.00 20.61           C  
ATOM  13148  O   LEU    36      70.562  40.854  31.376  1.00 21.20           O  
ATOM  13149  CB  LEU    36      68.532  39.046  32.613  1.00 21.41           C  
ATOM  13150  CG  LEU    36      68.789  39.264  34.102  1.00 21.35           C  
ATOM  13151  CD1 LEU    36      67.603  39.957  34.807  1.00 23.14           C  
ATOM  13152  CD2 LEU    36      69.179  37.943  34.804  1.00 22.93           C  
ATOM  13153  N   TYR    37      69.112  42.393  32.255  1.00 19.52           N  
ATOM  13154  CA  TYR    37      70.093  43.483  32.452  1.00 19.94           C  
ATOM  13155  C   TYR    37      70.430  43.581  33.906  1.00 19.30           C  
ATOM  13156  O   TYR    37      69.576  43.954  34.684  1.00 18.49           O  
ATOM  13157  CB  TYR    37      69.527  44.816  32.021  1.00 21.62           C  
ATOM  13158  CG  TYR    37      69.633  45.044  30.561  1.00 24.97           C  
ATOM  13159  CD1 TYR    37      70.608  45.901  30.041  1.00 26.99           C  
ATOM  13160  CD2 TYR    37      68.798  44.384  29.690  1.00 26.43           C  
ATOM  13161  CE1 TYR    37      70.711  46.099  28.690  1.00 28.18           C  
ATOM  13162  CE2 TYR    37      68.902  44.583  28.309  1.00 27.61           C  
ATOM  13163  CZ  TYR    37      69.839  45.424  27.829  1.00 26.70           C  
ATOM  13164  OH  TYR    37      69.928  45.651  26.474  1.00 28.34           O  
ATOM  13165  N   VAL    38      71.680  43.277  34.255  1.00 18.12           N  
ATOM  13166  CA  VAL    38      72.116  43.284  35.635  1.00 17.38           C  
ATOM  13167  C   VAL    38      72.897  44.591  35.852  1.00 17.03           C  
ATOM  13168  O   VAL    38      73.783  44.948  35.040  1.00 16.35           O  
ATOM  13169  CB  VAL    38      72.994  42.065  35.962  1.00 17.22           C  
ATOM  13170  CG1 VAL    38      73.488  42.113  37.378  1.00 16.68           C  
ATOM  13171  CG2 VAL    38      72.228  40.778  35.704  1.00 19.02           C  
ATOM  13172  N   SER    39      72.542  45.277  36.935  1.00 16.21           N  
ATOM  13173  CA  SER    39      73.190  46.537  37.340  1.00 16.77           C  
ATOM  13174  C   SER    39      74.675  46.307  37.694  1.00 16.42           C  
ATOM  13175  O   SER    39      75.066  45.194  38.084  1.00 16.79           O  
ATOM  13176  CB  SER    39      72.491  47.130  38.559  1.00 16.39           C  
ATOM  13177  OG  SER    39      71.232  47.673  38.217  1.00 16.94           O  
ATOM  13178  N   GLY    40      75.498  47.355  37.547  1.00 16.71           N  
ATOM  13179  CA  GLY    40      76.913  47.251  37.877  1.00 16.17           C  
ATOM  13180  C   GLY    40      77.093  46.701  39.267  1.00 16.82           C  
ATOM  13181  O   GLY    40      76.479  47.191  40.216  1.00 16.75           O  
ATOM  13182  N   GLN    41      77.848  45.617  39.375  1.00 16.68           N  
ATOM  13183  CA  GLN    41      78.114  44.996  40.668  1.00 17.30           C  
ATOM  13184  C   GLN    41      79.538  45.360  41.116  1.00 16.88           C  
ATOM  13185  O   GLN    41      80.451  45.399  40.295  1.00 17.16           O  
ATOM  13186  CB  GLN    41      77.943  43.460  40.588  1.00 17.03           C  
ATOM  13187  CG  GLN    41      76.522  42.993  40.194  1.00 18.15           C  
ATOM  13188  CD  GLN    41      75.491  43.430  41.175  1.00 18.41           C  
ATOM  13189  OE1 GLN    41      75.559  43.081  42.360  1.00 18.42           O  
ATOM  13190  NE2 GLN    41      74.513  44.191  40.705  1.00 18.08           N  
ATOM  13191  N   LEU    42      79.675  45.523  42.425  1.00 18.51           N  
ATOM  13192  CA  LEU    42      80.922  45.823  43.142  1.00 19.27           C  
ATOM  13193  C   LEU    42      81.505  44.544  43.800  1.00 20.59           C  
ATOM  13194  O   LEU    42      80.809  43.508  43.933  1.00 20.90           O  
ATOM  13195  CB  LEU    42      80.648  46.893  44.195  1.00 19.83           C  
ATOM  13196  CG  LEU    42      80.007  48.193  43.701  1.00 20.09           C  
ATOM  13197  CD1 LEU    42      79.893  49.256  44.830  1.00 24.19           C  
ATOM  13198  CD2 LEU    42      80.773  48.751  42.474  1.00 20.92           C  
ATOM  13199  N   PRO    43      82.784  44.590  44.204  1.00 20.99           N  
ATOM  13200  CA  PRO    43      83.390  43.388  44.739  1.00 22.23           C  
ATOM  13201  C   PRO    43      82.987  43.165  46.205  1.00 23.30           C  
ATOM  13202  O   PRO    43      83.833  43.267  47.123  1.00 23.87           O  
ATOM  13203  CB  PRO    43      84.886  43.654  44.574  1.00 22.24           C  
ATOM  13204  CG  PRO    43      85.021  45.107  44.597  1.00 22.74           C  
ATOM  13205  CD  PRO    43      83.747  45.711  44.125  1.00 20.90           C  
ATOM  13206  N   MET    44      81.695  42.863  46.396  1.00 24.94           N  
ATOM  13207  CA  MET    44      81.111  42.668  47.725  1.00 26.76           C  
ATOM  13208  C   MET    44      81.416  41.303  48.250  1.00 27.78           C  
ATOM  13209  O   MET    44      81.216  40.309  47.554  1.00 26.94           O  
ATOM  13210  CB  MET    44      79.606  42.768  47.701  1.00 28.72           C  
ATOM  13211  CG  MET    44      79.087  44.003  47.142  1.00 34.04           C  
ATOM  13212  SD  MET    44      79.675  45.517  48.177  1.00 52.29          SE  
ATOM  13213  CE  MET    44      78.069  46.599  47.655  1.00 42.80           C  
ATOM  13214  N   GLU    45      81.866  41.277  49.503  1.00 28.96           N  
ATOM  13215  CA  GLU    45      82.155  40.050  50.199  1.00 30.57           C  
ATOM  13216  C   GLU    45      81.806  40.268  51.663  1.00 30.94           C  
ATOM  13217  O   GLU    45      82.239  41.230  52.276  1.00 29.35           O  
ATOM  13218  CB  GLU    45      83.615  39.704  50.030  1.00 31.01           C  
ATOM  13219  CG  GLU    45      83.899  38.254  50.285  1.00 32.83           C  
ATOM  13220  CD  GLU    45      85.369  37.906  50.169  1.00 34.03           C  
ATOM  13221  OE1 GLU    45      86.236  38.800  50.290  1.00 40.50           O  
ATOM  13222  OE2 GLU    45      85.665  36.719  49.956  1.00 39.11           O  
ATOM  13223  N   SER    46      80.980  39.381  52.208  1.00 32.41           N  
ATOM  13224  CA  SER    46      80.473  39.546  53.558  1.00 33.11           C  
ATOM  13225  C   SER    46      79.902  40.921  53.829  1.00 32.96           C  
ATOM  13226  O   SER    46      80.092  41.474  54.907  1.00 33.73           O  
ATOM  13227  CB  SER    46      81.576  39.245  54.550  1.00 33.85           C  
ATOM  13228  OG  SER    46      82.071  37.929  54.341  1.00 36.10           O  
ATOM  13229  N   GLY    47      79.201  41.482  52.851  1.00 32.72           N  
ATOM  13230  CA  GLY    47      78.556  42.782  53.023  1.00 32.20           C  
ATOM  13231  C   GLY    47      79.457  44.008  52.954  1.00 31.89           C  
ATOM  13232  O   GLY    47      78.988  45.134  53.165  1.00 32.53           O  
ATOM  13233  N   LYS    48      80.735  43.805  52.632  1.00 31.36           N  
ATOM  13234  CA  LYS    48      81.710  44.889  52.589  1.00 31.00           C  
ATOM  13235  C   LYS    48      82.340  44.938  51.204  1.00 29.19           C  
ATOM  13236  O   LYS    48      82.428  43.919  50.525  1.00 27.85           O  
ATOM  13237  CB  LYS    48      82.812  44.643  53.628  1.00 32.10           C  
ATOM  13238  CG  LYS    48      82.320  44.278  55.056  1.00 33.77           C  
ATOM  13239  CD  LYS    48      83.517  44.073  55.997  1.00 34.85           C  
ATOM  13240  CE  LYS    48      83.212  43.172  57.223  1.00 38.54           C  
ATOM  13241  NZ  LYS    48      82.691  41.784  56.927  1.00 41.89           N  
ATOM  13242  N   ILE    49      82.793  46.114  50.786  1.00 27.46           N  
ATOM  13243  CA  ILE    49      83.609  46.197  49.556  1.00 27.51           C  
ATOM  13244  C   ILE    49      84.994  45.615  49.890  1.00 26.44           C  
ATOM  13245  O   ILE    49      85.717  46.162  50.719  1.00 27.76           O  
ATOM  13246  CB  ILE    49      83.727  47.641  48.999  1.00 27.35           C  
ATOM  13247  CG1 ILE    49      82.339  48.250  48.725  1.00 28.61           C  
ATOM  13248  CG2 ILE    49      84.568  47.654  47.687  1.00 25.90           C  
ATOM  13249  CD1 ILE    49      81.640  47.702  47.484  1.00 29.88           C  
ATOM  13250  N   ALA    50      85.329  44.473  49.299  1.00 24.66           N  
ATOM  13251  CA  ALA    50      86.524  43.716  49.675  1.00 23.88           C  
ATOM  13252  C   ALA    50      87.844  44.216  49.077  1.00 22.88           C  
ATOM  13253  O   ALA    50      88.926  43.916  49.616  1.00 23.36           O  
ATOM  13254  CB  ALA    50      86.342  42.241  49.306  1.00 24.42           C  
ATOM  13255  N   VAL    51      87.773  44.926  47.958  1.00 20.81           N  
ATOM  13256  CA  VAL    51      88.968  45.381  47.241  1.00 19.75           C  
ATOM  13257  C   VAL    51      88.716  46.833  46.772  1.00 19.50           C  
ATOM  13258  O   VAL    51      87.820  47.092  45.950  1.00 18.36           O  
ATOM  13259  CB  VAL    51      89.299  44.506  46.034  1.00 19.25           C  
ATOM  13260  CG1 VAL    51      90.619  44.969  45.369  1.00 17.95           C  
ATOM  13261  CG2 VAL    51      89.337  42.997  46.410  1.00 19.82           C  
ATOM  13262  N   THR    52      89.518  47.761  47.290  1.00 18.83           N  
ATOM  13263  CA  THR    52      89.331  49.192  47.048  1.00 18.76           C  
ATOM  13264  C   THR    52      90.623  49.886  46.577  1.00 17.15           C  
ATOM  13265  O   THR    52      91.752  49.426  46.833  1.00 18.57           O  
ATOM  13266  CB  THR    52      88.801  49.933  48.274  1.00 19.87           C  
ATOM  13267  OG1 THR    52      89.751  49.836  49.341  1.00 20.52           O  
ATOM  13268  CG2 THR    52      87.440  49.358  48.732  1.00 20.18           C  
ATOM  13269  N   GLY    53      90.427  50.980  45.853  1.00 16.63           N  
ATOM  13270  CA  GLY    53      91.523  51.794  45.378  1.00 15.81           C  
ATOM  13271  C   GLY    53      91.866  51.490  43.935  1.00 16.34           C  
ATOM  13272  O   GLY    53      91.220  50.657  43.238  1.00 16.41           O  
ATOM  13273  N   LEU    54      92.852  52.232  43.462  1.00 14.89           N  
ATOM  13274  CA  LEU    54      93.241  52.192  42.046  1.00 15.09           C  
ATOM  13275  C   LEU    54      94.198  51.052  41.691  1.00 14.82           C  
ATOM  13276  O   LEU    54      95.217  50.830  42.343  1.00 15.74           O  
ATOM  13277  CB  LEU    54      93.870  53.539  41.641  1.00 14.99           C  
ATOM  13278  CG  LEU    54      93.016  54.794  41.893  1.00 16.43           C  
ATOM  13279  CD1 LEU    54      93.853  56.129  41.629  1.00 14.43           C  
ATOM  13280  CD2 LEU    54      91.711  54.771  41.099  1.00 18.58           C  
ATOM  13281  N   VAL    55      93.881  50.333  40.618  1.00 15.10           N  
ATOM  13282  CA  VAL    55      94.798  49.303  40.117  1.00 15.22           C  
ATOM  13283  C   VAL    55      96.009  50.038  39.509  1.00 15.52           C  
ATOM  13284  O   VAL    55      95.867  51.023  38.743  1.00 15.49           O  
ATOM  13285  CB  VAL    55      94.147  48.295  39.122  1.00 15.34           C  
ATOM  13286  CG1 VAL    55      95.143  47.202  38.776  1.00 16.34           C  
ATOM  13287  CG2 VAL    55      92.798  47.747  39.668  1.00 14.16           C  
ATOM  13288  N   GLY    56      97.188  49.598  39.915  1.00 15.44           N  
ATOM  13289  CA  GLY    56      98.449  50.244  39.536  1.00 16.28           C  
ATOM  13290  C   GLY    56      98.942  51.219  40.587  1.00 16.32           C  
ATOM  13291  O   GLY    56     100.026  51.780  40.450  1.00 16.29           O  
ATOM  13292  N   ARG    57      98.166  51.390  41.665  1.00 16.32           N  
ATOM  13293  CA  ARG    57      98.571  52.249  42.778  1.00 16.70           C  
ATOM  13294  C   ARG    57      98.304  51.594  44.106  1.00 16.10           C  
ATOM  13295  O   ARG    57      99.218  51.357  44.886  1.00 17.03           O  
ATOM  13296  CB  ARG    57      97.873  53.603  42.715  1.00 15.72           C  
ATOM  13297  CG  ARG    57      98.244  54.497  43.885  1.00 16.84           C  
ATOM  13298  CD  ARG    57      97.659  55.894  43.877  1.00 15.89           C  
ATOM  13299  NE  ARG    57      98.101  56.563  45.097  1.00 15.63           N  
ATOM  13300  CZ  ARG    57      99.287  57.153  45.256  1.00 16.91           C  
ATOM  13301  NH1 ARG    57     100.160  57.249  44.259  1.00 13.83           N  
ATOM  13302  NH2 ARG    57      99.613  57.651  46.435  1.00 15.00           N  
ATOM  13303  N   ASP    58      97.051  51.278  44.341  1.00 16.23           N  
ATOM  13304  CA  ASP    58      96.620  50.693  45.608  1.00 16.54           C  
ATOM  13305  C   ASP    58      96.524  49.169  45.557  1.00 16.62           C  
ATOM  13306  O   ASP    58      96.664  48.506  46.600  1.00 16.58           O  
ATOM  13307  CB  ASP    58      95.275  51.259  45.998  1.00 16.42           C  
ATOM  13308  CG  ASP    58      95.312  52.769  46.142  1.00 17.20           C  
ATOM  13309  OD1 ASP    58      96.112  53.243  46.982  1.00 19.65           O  
ATOM  13310  OD2 ASP    58      94.531  53.456  45.451  1.00 18.16           O  
ATOM  13311  N   VAL    59      96.242  48.632  44.377  1.00 16.45           N  
ATOM  13312  CA  VAL    59      96.058  47.197  44.212  1.00 17.77           C  
ATOM  13313  C   VAL    59      96.785  46.737  42.956  1.00 17.83           C  
ATOM  13314  O   VAL    59      96.926  47.493  41.987  1.00 17.33           O  
ATOM  13315  CB  VAL    59      94.554  46.767  44.189  1.00 18.87           C  
ATOM  13316  CG1 VAL    59      93.778  47.334  45.449  1.00 21.82           C  
ATOM  13317  CG2 VAL    59      93.896  47.197  42.965  1.00 21.44           C  
ATOM  13318  N   ASP    60      97.285  45.515  43.025  1.00 18.74           N  
ATOM  13319  CA  ASP    60      97.964  44.879  41.909  1.00 19.34           C  
ATOM  13320  C   ASP    60      96.992  44.080  41.043  1.00 19.48           C  
ATOM  13321  O   ASP    60      95.805  44.037  41.332  1.00 19.40           O  
ATOM  13322  CB  ASP    60      99.147  44.040  42.405  1.00 20.89           C  
ATOM  13323  CG  ASP    60      98.757  42.848  43.254  1.00 21.21           C  
ATOM  13324  OD1 ASP    60      97.589  42.484  43.394  1.00 22.81           O  
ATOM  13325  OD2 ASP    60      99.713  42.231  43.792  1.00 30.25           O  
ATOM  13326  N   VAL    61      97.486  43.487  39.967  1.00 18.59           N  
ATOM  13327  CA  VAL    61      96.614  42.760  39.045  1.00 19.30           C  
ATOM  13328  C   VAL    61      95.938  41.568  39.757  1.00 18.76           C  
ATOM  13329  O   VAL    61      94.732  41.355  39.623  1.00 19.22           O  
ATOM  13330  CB  VAL    61      97.352  42.330  37.761  1.00 19.44           C  
ATOM  13331  CG1 VAL    61      96.504  41.337  36.953  1.00 20.46           C  
ATOM  13332  CG2 VAL    61      97.699  43.573  36.911  1.00 19.62           C  
ATOM  13333  N   ALA    62      96.695  40.801  40.523  1.00 18.89           N  
ATOM  13334  CA  ALA    62      96.120  39.649  41.215  1.00 19.10           C  
ATOM  13335  C   ALA    62      94.973  40.048  42.139  1.00 19.10           C  
ATOM  13336  O   ALA    62      93.905  39.417  42.132  1.00 18.61           O  
ATOM  13337  CB  ALA    62      97.209  38.899  42.012  1.00 19.82           C  
ATOM  13338  N   SER    63      95.178  41.088  42.960  1.00 18.52           N  
ATOM  13339  CA  SER    63      94.126  41.541  43.854  1.00 19.00           C  
ATOM  13340  C   SER    63      92.917  42.037  43.057  1.00 18.56           C  
ATOM  13341  O   SER    63      91.790  41.803  43.432  1.00 18.58           O  
ATOM  13342  CB  SER    63      94.622  42.645  44.745  1.00 19.24           C  
ATOM  13343  OG  SER    63      95.617  42.148  45.586  1.00 20.64           O  
ATOM  13344  N   ALA    64      93.164  42.778  41.983  1.00 18.32           N  
ATOM  13345  CA  ALA    64      92.088  43.282  41.124  1.00 18.22           C  
ATOM  13346  C   ALA    64      91.295  42.123  40.447  1.00 17.22           C  
ATOM  13347  O   ALA    64      90.093  42.203  40.247  1.00 15.74           O  
ATOM  13348  CB  ALA    64      92.667  44.231  40.071  1.00 18.00           C  
ATOM  13349  N   GLN    65      92.005  41.065  40.095  1.00 18.13           N  
ATOM  13350  CA  GLN    65      91.374  39.867  39.554  1.00 19.19           C  
ATOM  13351  C   GLN    65      90.392  39.274  40.566  1.00 19.55           C  
ATOM  13352  O   GLN    65      89.268  38.896  40.194  1.00 19.43           O  
ATOM  13353  CB  GLN    65      92.424  38.845  39.097  1.00 18.99           C  
ATOM  13354  CG  GLN    65      93.078  39.208  37.762  1.00 19.83           C  
ATOM  13355  CD  GLN    65      94.275  38.344  37.421  1.00 19.98           C  
ATOM  13356  OE1 GLN    65      94.942  37.792  38.312  1.00 23.49           O  
ATOM  13357  NE2 GLN    65      94.541  38.184  36.114  1.00 20.84           N  
ATOM  13358  N   ARG    66      90.789  39.194  41.835  1.00 20.27           N  
ATOM  13359  CA  ARG    66      89.877  38.774  42.884  1.00 19.80           C  
ATOM  13360  C   ARG    66      88.688  39.723  43.034  1.00 19.12           C  
ATOM  13361  O   ARG    66      87.559  39.289  43.213  1.00 18.72           O  
ATOM  13362  CB  ARG    66      90.597  38.676  44.215  1.00 21.46           C  
ATOM  13363  CG  ARG    66      89.674  38.205  45.361  1.00 25.65           C  
ATOM  13364  CD  ARG    66      89.298  36.727  45.200  1.00 36.25           C  
ATOM  13365  NE  ARG    66      90.392  35.890  45.691  1.00 41.73           N  
ATOM  13366  CZ  ARG    66      90.704  34.644  45.300  1.00 44.24           C  
ATOM  13367  NH1 ARG    66      90.018  33.988  44.357  1.00 45.76           N  
ATOM  13368  NH2 ARG    66      91.746  34.039  45.876  1.00 45.36           N  
ATOM  13369  N   ALA    67      88.915  41.023  42.911  1.00 18.19           N  
ATOM  13370  CA  ALA    67      87.776  41.975  42.854  1.00 17.76           C  
ATOM  13371  C   ALA    67      86.826  41.622  41.708  1.00 17.38           C  
ATOM  13372  O   ALA    67      85.599  41.617  41.892  1.00 17.68           O  
ATOM  13373  CB  ALA    67      88.270  43.434  42.700  1.00 18.27           C  
ATOM  13374  N   ALA    68      87.399  41.298  40.541  1.00 16.79           N  
ATOM  13375  CA  ALA    68      86.601  40.982  39.365  1.00 17.36           C  
ATOM  13376  C   ALA    68      85.816  39.681  39.613  1.00 17.31           C  
ATOM  13377  O   ALA    68      84.630  39.612  39.301  1.00 17.42           O  
ATOM  13378  CB  ALA    68      87.459  40.881  38.124  1.00 16.52           C  
ATOM  13379  N   GLU    69      86.469  38.683  40.196  1.00 17.93           N  
ATOM  13380  CA  GLU    69      85.784  37.441  40.576  1.00 18.71           C  
ATOM  13381  C   GLU    69      84.583  37.751  41.484  1.00 18.93           C  
ATOM  13382  O   GLU    69      83.471  37.242  41.241  1.00 18.31           O  
ATOM  13383  CB  GLU    69      86.757  36.477  41.251  1.00 19.08           C  
ATOM  13384  CG  GLU    69      87.806  35.902  40.322  1.00 21.15           C  
ATOM  13385  CD  GLU    69      88.858  35.066  41.051  1.00 22.14           C  
ATOM  13386  OE1 GLU    69      89.114  35.313  42.248  1.00 26.87           O  
ATOM  13387  OE2 GLU    69      89.424  34.144  40.439  1.00 27.07           O  
ATOM  13388  N   LEU    70      84.785  38.602  42.502  1.00 18.58           N  
ATOM  13389  CA  LEU    70      83.696  38.968  43.407  1.00 18.83           C  
ATOM  13390  C   LEU    70      82.568  39.708  42.680  1.00 19.23           C  
ATOM  13391  O   LEU    70      81.381  39.501  42.991  1.00 19.11           O  
ATOM  13392  CB  LEU    70      84.211  39.780  44.620  1.00 19.41           C  
ATOM  13393  CG  LEU    70      85.076  39.021  45.631  1.00 19.00           C  
ATOM  13394  CD1 LEU    70      85.801  39.978  46.576  1.00 19.47           C  
ATOM  13395  CD2 LEU    70      84.185  37.995  46.377  1.00 21.35           C  
ATOM  13396  N   CYS    71      82.915  40.595  41.740  1.00 18.39           N  
ATOM  13397  CA  CYS    71      81.884  41.296  40.973  1.00 18.21           C  
ATOM  13398  C   CYS    71      81.020  40.255  40.259  1.00 18.12           C  
ATOM  13399  O   CYS    71      79.783  40.380  40.219  1.00 18.48           O  
ATOM  13400  CB  CYS    71      82.523  42.263  39.959  1.00 18.28           C  
ATOM  13401  SG  CYS    71      83.354  43.707  40.748  1.00 17.98           S  
ATOM  13402  N   ALA    72      81.702  39.258  39.697  1.00 18.14           N  
ATOM  13403  CA  ALA    72      81.087  38.152  38.925  1.00 18.89           C  
ATOM  13404  C   ALA    72      80.191  37.309  39.820  1.00 19.05           C  
ATOM  13405  O   ALA    72      79.114  36.921  39.394  1.00 18.95           O  
ATOM  13406  CB  ALA    72      82.163  37.286  38.228  1.00 19.28           C  
ATOM  13407  N   VAL    73      80.632  37.045  41.048  1.00 19.61           N  
ATOM  13408  CA  VAL    73      79.815  36.298  42.031  1.00 20.01           C  
ATOM  13409  C   VAL    73      78.521  37.045  42.369  1.00 20.13           C  
ATOM  13410  O   VAL    73      77.428  36.449  42.460  1.00 20.48           O  
ATOM  13411  CB  VAL    73      80.633  36.004  43.330  1.00 20.82           C  
ATOM  13412  CG1 VAL    73      79.714  35.513  44.502  1.00 21.02           C  
ATOM  13413  CG2 VAL    73      81.772  35.052  43.029  1.00 19.80           C  
ATOM  13414  N   ASN    74      78.651  38.353  42.525  1.00 20.11           N  
ATOM  13415  CA  ASN    74      77.538  39.245  42.782  1.00 19.82           C  
ATOM  13416  C   ASN    74      76.578  39.319  41.600  1.00 19.58           C  
ATOM  13417  O   ASN    74      75.340  39.315  41.782  1.00 19.11           O  
ATOM  13418  CB  ASN    74      78.047  40.618  43.245  1.00 21.09           C  
ATOM  13419  CG  ASN    74      78.475  40.618  44.708  1.00 20.96           C  
ATOM  13420  OD1 ASN    74      79.667  40.497  45.044  1.00 25.84           O  
ATOM  13421  ND2 ASN    74      77.513  40.757  45.583  1.00 21.36           N  
ATOM  13422  N   ILE    75      77.117  39.332  40.385  1.00 19.22           N  
ATOM  13423  CA  ILE    75      76.266  39.262  39.188  1.00 19.73           C  
ATOM  13424  C   ILE    75      75.449  37.952  39.240  1.00 19.91           C  
ATOM  13425  O   ILE    75      74.232  37.959  39.042  1.00 21.28           O  
ATOM  13426  CB  ILE    75      77.082  39.318  37.856  1.00 20.26           C  
ATOM  13427  CG1 ILE    75      77.721  40.707  37.642  1.00 20.27           C  
ATOM  13428  CG2 ILE    75      76.193  38.957  36.665  1.00 18.77           C  
ATOM  13429  CD1 ILE    75      78.803  40.768  36.489  1.00 19.64           C  
ATOM  13430  N   LEU    76      76.126  36.852  39.510  1.00 20.16           N  
ATOM  13431  CA  LEU    76      75.459  35.515  39.533  1.00 20.33           C  
ATOM  13432  C   LEU    76      74.366  35.460  40.615  1.00 20.78           C  
ATOM  13433  O   LEU    76      73.297  34.907  40.379  1.00 21.42           O  
ATOM  13434  CB  LEU    76      76.486  34.394  39.689  1.00 20.53           C  
ATOM  13435  CG  LEU    76      77.372  34.118  38.484  1.00 20.87           C  
ATOM  13436  CD1 LEU    76      78.458  33.098  38.825  1.00 22.97           C  
ATOM  13437  CD2 LEU    76      76.544  33.679  37.260  1.00 23.02           C  
ATOM  13438  N   ALA    77      74.614  36.063  41.784  1.00 21.14           N  
ATOM  13439  CA  ALA    77      73.597  36.165  42.832  1.00 21.04           C  
ATOM  13440  C   ALA    77      72.361  36.891  42.300  1.00 21.95           C  
ATOM  13441  O   ALA    77      71.217  36.466  42.522  1.00 21.90           O  
ATOM  13442  CB  ALA    77      74.162  36.883  44.086  1.00 20.99           C  
ATOM  13443  N   GLN    78      72.587  37.993  41.581  1.00 21.45           N  
ATOM  13444  CA  GLN    78      71.473  38.745  41.023  1.00 22.10           C  
ATOM  13445  C   GLN    78      70.713  37.927  39.965  1.00 21.79           C  
ATOM  13446  O   GLN    78      69.486  37.929  39.936  1.00 22.55           O  
ATOM  13447  CB  GLN    78      71.950  40.077  40.422  1.00 22.09           C  
ATOM  13448  CG  GLN    78      72.508  41.105  41.436  1.00 24.22           C  
ATOM  13449  CD  GLN    78      71.567  41.457  42.585  1.00 27.40           C  
ATOM  13450  OE1 GLN    78      70.352  41.227  42.543  1.00 31.81           O  
ATOM  13451  NE2 GLN    78      72.141  42.054  43.621  1.00 33.24           N  
ATOM  13452  N   VAL    79      71.444  37.235  39.103  1.00 22.19           N  
ATOM  13453  CA  VAL    79      70.817  36.392  38.091  1.00 22.65           C  
ATOM  13454  C   VAL    79      69.980  35.285  38.732  1.00 23.28           C  
ATOM  13455  O   VAL    79      68.872  35.003  38.273  1.00 23.03           O  
ATOM  13456  CB  VAL    79      71.835  35.795  37.119  1.00 23.12           C  
ATOM  13457  CG1 VAL    79      71.136  34.895  36.134  1.00 23.37           C  
ATOM  13458  CG2 VAL    79      72.623  36.932  36.374  1.00 22.03           C  
ATOM  13459  N   LYS    80      70.507  34.673  39.779  1.00 23.69           N  
ATOM  13460  CA  LYS    80      69.799  33.611  40.478  1.00 24.34           C  
ATOM  13461  C   LYS    80      68.501  34.164  41.053  1.00 25.02           C  
ATOM  13462  O   LYS    80      67.442  33.517  40.935  1.00 25.88           O  
ATOM  13463  CB  LYS    80      70.672  33.018  41.576  1.00 24.54           C  
ATOM  13464  CG  LYS    80      69.980  31.893  42.358  1.00 24.65           C  
ATOM  13465  CD  LYS    80      70.809  31.421  43.510  1.00 25.01           C  
ATOM  13466  CE  LYS    80      69.995  30.487  44.426  1.00 26.39           C  
ATOM  13467  NZ  LYS    80      70.884  29.674  45.302  1.00 27.82           N  
ATOM  13468  N   ALA    81      68.564  35.351  41.664  1.00 25.16           N  
ATOM  13469  CA  ALA    81      67.346  36.048  42.148  1.00 25.31           C  
ATOM  13470  C   ALA    81      66.342  36.341  41.017  1.00 25.95           C  
ATOM  13471  O   ALA    81      65.141  36.042  41.158  1.00 25.62           O  
ATOM  13472  CB  ALA    81      67.697  37.329  42.899  1.00 25.25           C  
ATOM  13473  N   ALA    82      66.827  36.906  39.908  1.00 25.86           N  
ATOM  13474  CA  ALA    82      66.008  37.146  38.720  1.00 26.45           C  
ATOM  13475  C   ALA    82      65.358  35.846  38.201  1.00 26.96           C  
ATOM  13476  O   ALA    82      64.253  35.900  37.645  1.00 27.66           O  
ATOM  13477  CB  ALA    82      66.813  37.773  37.611  1.00 25.68           C  
ATOM  13478  N   LEU    83      66.034  34.712  38.370  1.00 27.25           N  
ATOM  13479  CA  LEU    83      65.568  33.458  37.785  1.00 28.53           C  
ATOM  13480  C   LEU    83      64.892  32.546  38.810  1.00 29.77           C  
ATOM  13481  O   LEU    83      64.768  31.322  38.610  1.00 29.23           O  
ATOM  13482  CB  LEU    83      66.721  32.761  37.070  1.00 28.68           C  
ATOM  13483  CG  LEU    83      67.336  33.509  35.875  1.00 27.34           C  
ATOM  13484  CD1 LEU    83      68.442  32.677  35.265  1.00 27.66           C  
ATOM  13485  CD2 LEU    83      66.303  33.910  34.809  1.00 26.22           C  
ATOM  13486  N   ASN    84      64.439  33.159  39.895  1.00 30.56           N  
ATOM  13487  CA  ASN    84      63.729  32.463  40.972  1.00 32.17           C  
ATOM  13488  C   ASN    84      64.473  31.244  41.527  1.00 32.90           C  
ATOM  13489  O   ASN    84      63.869  30.207  41.867  1.00 33.06           O  
ATOM  13490  CB  ASN    84      62.309  32.124  40.501  1.00 32.69           C  
ATOM  13491  CG  ASN    84      61.490  33.372  40.221  1.00 35.55           C  
ATOM  13492  OD1 ASN    84      60.912  33.525  39.134  1.00 41.64           O  
ATOM  13493  ND2 ASN    84      61.455  34.290  41.192  1.00 39.24           N  
ATOM  13494  N   GLY    85      65.789  31.382  41.634  1.00 33.09           N  
ATOM  13495  CA  GLY    85      66.645  30.371  42.227  1.00 33.47           C  
ATOM  13496  C   GLY    85      67.306  29.487  41.196  1.00 34.39           C  
ATOM  13497  O   GLY    85      68.029  28.555  41.537  1.00 35.05           O  
ATOM  13498  N   ASP    86      67.097  29.793  39.927  1.00 35.62           N  
ATOM  13499  CA  ASP    86      67.425  28.850  38.869  1.00 36.87           C  
ATOM  13500  C   ASP    86      68.531  29.305  37.873  1.00 36.44           C  
ATOM  13501  O   ASP    86      68.241  29.668  36.744  1.00 36.29           O  
ATOM  13502  CB  ASP    86      66.107  28.532  38.145  1.00 37.68           C  
ATOM  13503  CG  ASP    86      66.135  27.208  37.412  1.00 40.66           C  
ATOM  13504  OD1 ASP    86      67.157  26.494  37.471  1.00 44.08           O  
ATOM  13505  OD2 ASP    86      65.116  26.881  36.763  1.00 45.09           O  
ATOM  13506  N   LEU    87      69.796  29.225  38.285  1.00 36.56           N  
ATOM  13507  CA  LEU    87      70.940  29.570  37.412  1.00 36.56           C  
ATOM  13508  C   LEU    87      71.040  28.748  36.105  1.00 36.34           C  
ATOM  13509  O   LEU    87      71.796  29.096  35.196  1.00 35.79           O  
ATOM  13510  CB  LEU    87      72.272  29.500  38.182  1.00 36.86           C  
ATOM  13511  CG  LEU    87      72.623  30.693  39.091  1.00 36.88           C  
ATOM  13512  CD1 LEU    87      73.967  30.459  39.777  1.00 36.37           C  
ATOM  13513  CD2 LEU    87      72.640  32.048  38.326  1.00 36.15           C  
ATOM  13514  N   SER    88      70.275  27.665  36.024  1.00 36.37           N  
ATOM  13515  CA  SER    88      70.251  26.801  34.847  1.00 35.94           C  
ATOM  13516  C   SER    88      69.374  27.362  33.727  1.00 35.17           C  
ATOM  13517  O   SER    88      69.432  26.891  32.595  1.00 35.24           O  
ATOM  13518  CB  SER    88      69.754  25.418  35.260  1.00 36.16           C  
ATOM  13519  OG  SER    88      68.473  25.510  35.846  1.00 37.19           O  
ATOM  13520  N   LYS    89      68.583  28.382  34.056  1.00 34.43           N  
ATOM  13521  CA  LYS    89      67.792  29.109  33.080  1.00 33.77           C  
ATOM  13522  C   LYS    89      68.571  30.213  32.358  1.00 32.24           C  
ATOM  13523  O   LYS    89      67.994  30.935  31.545  1.00 32.12           O  
ATOM  13524  CB  LYS    89      66.543  29.690  33.739  1.00 34.20           C  
ATOM  13525  CG  LYS    89      65.489  28.606  34.078  1.00 35.37           C  
ATOM  13526  CD  LYS    89      64.197  29.224  34.590  1.00 36.03           C  
ATOM  13527  CE  LYS    89      63.040  28.177  34.705  1.00 37.98           C  
ATOM  13528  NZ  LYS    89      62.891  27.610  36.082  1.00 39.34           N  
ATOM  13529  N   ILE    90      69.865  30.341  32.642  1.00 30.91           N  
ATOM  13530  CA  ILE    90      70.740  31.151  31.793  1.00 30.51           C  
ATOM  13531  C   ILE    90      70.915  30.437  30.434  1.00 30.01           C  
ATOM  13532  O   ILE    90      71.329  29.275  30.387  1.00 31.25           O  
ATOM  13533  CB  ILE    90      72.141  31.392  32.445  1.00 30.19           C  
ATOM  13534  CG1 ILE    90      72.004  32.133  33.787  1.00 29.03           C  
ATOM  13535  CG2 ILE    90      73.086  32.137  31.461  1.00 29.03           C  
ATOM  13536  CD1 ILE    90      73.322  32.266  34.564  1.00 30.48           C  
ATOM  13537  N   ARG    91      70.602  31.114  29.336  1.00 28.51           N  
ATOM  13538  CA  ARG    91      70.882  30.563  28.010  1.00 29.50           C  
ATOM  13539  C   ARG    91      72.270  30.959  27.522  1.00 27.41           C  
ATOM  13540  O   ARG    91      73.007  30.149  26.963  1.00 25.76           O  
ATOM  13541  CB  ARG    91      69.802  30.984  27.021  1.00 29.42           C  
ATOM  13542  CG  ARG    91      68.469  30.319  27.356  1.00 33.12           C  
ATOM  13543  CD  ARG    91      67.261  30.999  26.705  1.00 35.92           C  
ATOM  13544  NE  ARG    91      67.355  31.013  25.251  1.00 43.12           N  
ATOM  13545  CZ  ARG    91      67.218  29.942  24.465  1.00 46.08           C  
ATOM  13546  NH1 ARG    91      66.945  28.734  24.973  1.00 47.97           N  
ATOM  13547  NH2 ARG    91      67.346  30.092  23.143  1.00 46.98           N  
ATOM  13548  N   ARG    92      72.634  32.203  27.780  1.00 25.79           N  
ATOM  13549  CA  ARG    92      73.916  32.748  27.347  1.00 25.72           C  
ATOM  13550  C   ARG    92      74.201  34.042  28.094  1.00 23.76           C  
ATOM  13551  O   ARG    92      73.289  34.873  28.245  1.00 22.58           O  
ATOM  13552  CB  ARG    92      73.835  33.054  25.862  1.00 26.82           C  
ATOM  13553  CG  ARG    92      74.885  33.989  25.316  1.00 31.69           C  
ATOM  13554  CD  ARG    92      75.607  33.399  24.154  1.00 37.13           C  
ATOM  13555  NE  ARG    92      76.890  32.858  24.594  1.00 40.03           N  
ATOM  13556  CZ  ARG    92      77.376  31.648  24.306  1.00 42.08           C  
ATOM  13557  NH1 ARG    92      76.702  30.777  23.546  1.00 43.85           N  
ATOM  13558  NH2 ARG    92      78.569  31.303  24.771  1.00 40.04           N  
ATOM  13559  N   VAL    93      75.433  34.184  28.586  1.00 21.68           N  
ATOM  13560  CA  VAL    93      75.905  35.473  29.055  1.00 20.41           C  
ATOM  13561  C   VAL    93      76.303  36.221  27.782  1.00 20.28           C  
ATOM  13562  O   VAL    93      77.259  35.856  27.069  1.00 21.18           O  
ATOM  13563  CB  VAL    93      77.080  35.374  30.075  1.00 20.10           C  
ATOM  13564  CG1 VAL    93      77.543  36.778  30.511  1.00 20.34           C  
ATOM  13565  CG2 VAL    93      76.685  34.513  31.307  1.00 20.35           C  
ATOM  13566  N   ILE    94      75.543  37.252  27.472  1.00 19.62           N  
ATOM  13567  CA  ILE    94      75.707  37.970  26.218  1.00 19.82           C  
ATOM  13568  C   ILE    94      76.892  38.962  26.232  1.00 19.77           C  
ATOM  13569  O   ILE    94      77.686  39.016  25.272  1.00 19.63           O  
ATOM  13570  CB  ILE    94      74.405  38.688  25.859  1.00 20.18           C  
ATOM  13571  CG1 ILE    94      73.341  37.638  25.511  1.00 21.26           C  
ATOM  13572  CG2 ILE    94      74.574  39.644  24.658  1.00 20.74           C  
ATOM  13573  CD1 ILE    94      73.669  36.882  24.212  1.00 25.02           C  
ATOM  13574  N   LYS    95      77.009  39.701  27.338  1.00 19.20           N  
ATOM  13575  CA  LYS    95      77.963  40.817  27.444  1.00 18.28           C  
ATOM  13576  C   LYS    95      78.268  41.140  28.913  1.00 18.11           C  
ATOM  13577  O   LYS    95      77.377  41.166  29.740  1.00 17.68           O  
ATOM  13578  CB  LYS    95      77.362  42.031  26.756  1.00 18.02           C  
ATOM  13579  CG  LYS    95      78.180  43.334  26.821  1.00 18.92           C  
ATOM  13580  CD  LYS    95      79.388  43.233  25.899  1.00 17.97           C  
ATOM  13581  CE  LYS    95      80.246  44.514  25.891  1.00 19.41           C  
ATOM  13582  NZ  LYS    95      79.470  45.692  25.394  1.00 20.19           N  
ATOM  13583  N   LEU    96      79.537  41.389  29.220  1.00 18.19           N  
ATOM  13584  CA  LEU    96      79.951  41.957  30.513  1.00 17.80           C  
ATOM  13585  C   LEU    96      80.658  43.271  30.202  1.00 17.10           C  
ATOM  13586  O   LEU    96      81.468  43.325  29.258  1.00 17.15           O  
ATOM  13587  CB  LEU    96      80.942  41.045  31.244  1.00 18.83           C  
ATOM  13588  CG  LEU    96      80.585  39.667  31.800  1.00 20.85           C  
ATOM  13589  CD1 LEU    96      81.711  39.277  32.729  1.00 22.50           C  
ATOM  13590  CD2 LEU    96      79.206  39.674  32.520  1.00 21.93           C  
ATOM  13591  N   ASN    97      80.329  44.321  30.946  1.00 16.61           N  
ATOM  13592  CA  ASN    97      81.130  45.529  30.906  1.00 16.14           C  
ATOM  13593  C   ASN    97      81.933  45.623  32.183  1.00 15.02           C  
ATOM  13594  O   ASN    97      81.375  45.796  33.268  1.00 14.66           O  
ATOM  13595  CB  ASN    97      80.289  46.767  30.662  1.00 16.88           C  
ATOM  13596  CG  ASN    97      79.486  46.689  29.385  1.00 18.53           C  
ATOM  13597  OD1 ASN    97      78.257  46.535  29.404  1.00 23.42           O  
ATOM  13598  ND2 ASN    97      80.171  46.786  28.273  1.00 15.75           N  
ATOM  13599  N   GLY    98      83.256  45.563  32.012  1.00 14.82           N  
ATOM  13600  CA  GLY    98      84.185  45.561  33.119  1.00 15.02           C  
ATOM  13601  C   GLY    98      84.852  46.915  33.285  1.00 15.44           C  
ATOM  13602  O   GLY    98      85.617  47.349  32.412  1.00 16.65           O  
ATOM  13603  N   PHE    99      84.542  47.593  34.386  1.00 15.14           N  
ATOM  13604  CA  PHE    99      85.102  48.870  34.692  1.00 14.44           C  
ATOM  13605  C   PHE    99      86.167  48.697  35.768  1.00 14.30           C  
ATOM  13606  O   PHE    99      85.866  48.199  36.872  1.00 14.95           O  
ATOM  13607  CB  PHE    99      83.973  49.765  35.171  1.00 15.41           C  
ATOM  13608  CG  PHE    99      82.790  49.765  34.262  1.00 16.64           C  
ATOM  13609  CD1 PHE    99      82.914  50.201  32.953  1.00 22.14           C  
ATOM  13610  CD2 PHE    99      81.554  49.354  34.715  1.00 19.51           C  
ATOM  13611  CE1 PHE    99      81.807  50.224  32.110  1.00 22.73           C  
ATOM  13612  CE2 PHE    99      80.456  49.391  33.888  1.00 20.40           C  
ATOM  13613  CZ  PHE    99      80.577  49.822  32.604  1.00 19.17           C  
ATOM  13614  N   VAL   100      87.401  49.093  35.463  1.00 12.97           N  
ATOM  13615  CA  VAL   100      88.533  48.945  36.395  1.00 13.47           C  
ATOM  13616  C   VAL   100      89.113  50.315  36.797  1.00 13.53           C  
ATOM  13617  O   VAL   100      89.639  51.033  35.962  1.00 13.48           O  
ATOM  13618  CB  VAL   100      89.674  48.129  35.768  1.00 12.63           C  
ATOM  13619  CG1 VAL   100      90.810  47.914  36.819  1.00 13.13           C  
ATOM  13620  CG2 VAL   100      89.172  46.827  35.121  1.00 14.55           C  
ATOM  13621  N   ALA   101      89.018  50.651  38.073  1.00 13.61           N  
ATOM  13622  CA  ALA   101      89.573  51.922  38.591  1.00 13.39           C  
ATOM  13623  C   ALA   101      91.080  51.820  38.411  1.00 13.93           C  
ATOM  13624  O   ALA   101      91.703  50.866  38.925  1.00 12.78           O  
ATOM  13625  CB  ALA   101      89.195  52.132  40.064  1.00 13.54           C  
ATOM  13626  N   SER   102      91.652  52.751  37.644  1.00 13.96           N  
ATOM  13627  CA  SER   102      93.014  52.597  37.122  1.00 13.76           C  
ATOM  13628  C   SER   102      93.783  53.879  37.237  1.00 13.85           C  
ATOM  13629  O   SER   102      93.239  54.942  37.020  1.00 13.85           O  
ATOM  13630  CB  SER   102      92.952  52.234  35.615  1.00 13.46           C  
ATOM  13631  OG  SER   102      92.318  50.995  35.346  1.00 15.64           O  
ATOM  13632  N   VAL   103      95.081  53.795  37.542  1.00 14.08           N  
ATOM  13633  CA  VAL   103      95.940  54.957  37.235  1.00 13.49           C  
ATOM  13634  C   VAL   103      96.211  54.943  35.728  1.00 14.32           C  
ATOM  13635  O   VAL   103      96.076  53.907  35.086  1.00 14.13           O  
ATOM  13636  CB  VAL   103      97.260  54.995  38.049  1.00 13.45           C  
ATOM  13637  CG1 VAL   103      96.964  55.212  39.528  1.00 13.30           C  
ATOM  13638  CG2 VAL   103      98.085  53.757  37.857  1.00 14.31           C  
ATOM  13639  N   PRO   104      96.528  56.120  35.158  1.00 14.49           N  
ATOM  13640  CA  PRO   104      96.705  56.218  33.710  1.00 15.18           C  
ATOM  13641  C   PRO   104      97.820  55.375  33.100  1.00 15.45           C  
ATOM  13642  O   PRO   104      97.786  55.109  31.890  1.00 17.16           O  
ATOM  13643  CB  PRO   104      96.935  57.712  33.487  1.00 15.35           C  
ATOM  13644  CG  PRO   104      96.279  58.366  34.685  1.00 16.48           C  
ATOM  13645  CD  PRO   104      96.631  57.440  35.786  1.00 15.15           C  
ATOM  13646  N   GLU   105      98.781  54.941  33.908  1.00 15.63           N  
ATOM  13647  CA  GLU   105      99.839  54.061  33.433  1.00 14.99           C  
ATOM  13648  C   GLU   105      99.426  52.591  33.472  1.00 15.57           C  
ATOM  13649  O   GLU   105     100.143  51.745  32.983  1.00 15.51           O  
ATOM  13650  CB  GLU   105     101.129  54.233  34.247  1.00 15.82           C  
ATOM  13651  CG  GLU   105     101.751  55.606  34.111  1.00 14.48           C  
ATOM  13652  CD  GLU   105     100.908  56.711  34.727  1.00 14.59           C  
ATOM  13653  OE1 GLU   105     100.406  56.563  35.871  1.00 15.16           O  
ATOM  13654  OE2 GLU   105     100.751  57.745  34.035  1.00 15.78           O  
ATOM  13655  N   PHE   106      98.296  52.297  34.120  1.00 15.66           N  
ATOM  13656  CA  PHE   106      97.815  50.921  34.211  1.00 15.19           C  
ATOM  13657  C   PHE   106      97.034  50.567  32.952  1.00 15.21           C  
ATOM  13658  O   PHE   106      96.053  51.238  32.616  1.00 15.33           O  
ATOM  13659  CB  PHE   106      96.970  50.643  35.451  1.00 15.12           C  
ATOM  13660  CG  PHE   106      96.527  49.222  35.524  1.00 14.69           C  
ATOM  13661  CD1 PHE   106      97.460  48.191  35.776  1.00 13.97           C  
ATOM  13662  CD2 PHE   106      95.195  48.878  35.251  1.00 14.24           C  
ATOM  13663  CE1 PHE   106      97.055  46.849  35.796  1.00 16.21           C  
ATOM  13664  CE2 PHE   106      94.808  47.554  35.251  1.00 16.36           C  
ATOM  13665  CZ  PHE   106      95.711  46.545  35.530  1.00 15.69           C  
ATOM  13666  N   VAL   107      97.492  49.515  32.274  1.00 15.49           N  
ATOM  13667  CA  VAL   107      96.959  49.139  30.942  1.00 15.51           C  
ATOM  13668  C   VAL   107      96.660  47.626  30.810  1.00 16.14           C  
ATOM  13669  O   VAL   107      96.676  47.065  29.678  1.00 17.46           O  
ATOM  13670  CB  VAL   107      97.875  49.636  29.813  1.00 15.35           C  
ATOM  13671  CG1 VAL   107      97.910  51.181  29.745  1.00 16.15           C  
ATOM  13672  CG2 VAL   107      99.308  49.001  29.940  1.00 17.34           C  
ATOM  13673  N   GLU   108      96.342  46.976  31.937  1.00 15.75           N  
ATOM  13674  CA  GLU   108      96.023  45.560  31.913  1.00 16.38           C  
ATOM  13675  C   GLU   108      94.628  45.285  32.422  1.00 15.43           C  
ATOM  13676  O   GLU   108      94.352  44.262  33.088  1.00 16.13           O  
ATOM  13677  CB  GLU   108      97.076  44.777  32.693  1.00 16.44           C  
ATOM  13678  CG  GLU   108      98.436  44.788  32.033  1.00 19.85           C  
ATOM  13679  CD  GLU   108      99.523  44.263  32.973  1.00 20.58           C  
ATOM  13680  OE1 GLU   108      99.742  44.801  34.079  1.00 29.71           O  
ATOM  13681  OE2 GLU   108     100.165  43.306  32.588  1.00 28.76           O  
ATOM  13682  N   GLN   109      93.705  46.167  32.065  1.00 15.62           N  
ATOM  13683  CA  GLN   109      92.320  45.982  32.468  1.00 15.33           C  
ATOM  13684  C   GLN   109      91.738  44.684  31.902  1.00 15.79           C  
ATOM  13685  O   GLN   109      90.865  44.105  32.513  1.00 16.28           O  
ATOM  13686  CB  GLN   109      91.473  47.148  32.024  1.00 15.81           C  
ATOM  13687  CG  GLN   109      91.813  48.476  32.661  1.00 14.14           C  
ATOM  13688  CD  GLN   109      92.960  49.238  31.952  1.00 15.09           C  
ATOM  13689  OE1 GLN   109      93.533  48.780  30.938  1.00 14.45           O  
ATOM  13690  NE2 GLN   109      93.277  50.409  32.470  1.00 14.52           N  
ATOM  13691  N   HIS   110      92.217  44.249  30.747  1.00 15.52           N  
ATOM  13692  CA  HIS   110      91.773  42.945  30.180  1.00 15.97           C  
ATOM  13693  C   HIS   110      92.129  41.795  31.114  1.00 15.78           C  
ATOM  13694  O   HIS   110      91.333  40.912  31.357  1.00 16.32           O  
ATOM  13695  CB  HIS   110      92.311  42.739  28.739  1.00 16.72           C  
ATOM  13696  CG  HIS   110      93.809  42.789  28.627  1.00 17.04           C  
ATOM  13697  ND1 HIS   110      94.550  43.909  28.945  1.00 19.60           N  
ATOM  13698  CD2 HIS   110      94.705  41.843  28.259  1.00 22.76           C  
ATOM  13699  CE1 HIS   110      95.839  43.643  28.780  1.00 20.17           C  
ATOM  13700  NE2 HIS   110      95.958  42.394  28.373  1.00 21.32           N  
ATOM  13701  N   LEU   111      93.330  41.821  31.669  1.00 16.38           N  
ATOM  13702  CA  LEU   111      93.763  40.836  32.657  1.00 16.96           C  
ATOM  13703  C   LEU   111      92.924  40.851  33.932  1.00 17.46           C  
ATOM  13704  O   LEU   111      92.575  39.786  34.492  1.00 19.02           O  
ATOM  13705  CB  LEU   111      95.239  41.050  32.982  1.00 17.06           C  
ATOM  13706  CG  LEU   111      96.187  40.875  31.779  1.00 17.72           C  
ATOM  13707  CD1 LEU   111      97.635  40.909  32.274  1.00 21.15           C  
ATOM  13708  CD2 LEU   111      95.918  39.613  30.974  1.00 21.14           C  
ATOM  13709  N   VAL   112      92.592  42.051  34.377  1.00 16.80           N  
ATOM  13710  CA  VAL   112      91.777  42.181  35.584  1.00 16.34           C  
ATOM  13711  C   VAL   112      90.397  41.535  35.335  1.00 16.45           C  
ATOM  13712  O   VAL   112      89.895  40.762  36.156  1.00 17.06           O  
ATOM  13713  CB  VAL   112      91.648  43.658  36.010  1.00 16.03           C  
ATOM  13714  CG1 VAL   112      90.570  43.824  37.097  1.00 14.54           C  
ATOM  13715  CG2 VAL   112      93.046  44.189  36.451  1.00 14.52           C  
ATOM  13716  N   ILE   113      89.783  41.862  34.211  1.00 16.33           N  
ATOM  13717  CA  ILE   113      88.418  41.383  33.939  1.00 16.57           C  
ATOM  13718  C   ILE   113      88.426  39.871  33.602  1.00 17.38           C  
ATOM  13719  O   ILE   113      87.418  39.207  33.835  1.00 17.79           O  
ATOM  13720  CB  ILE   113      87.684  42.255  32.877  1.00 16.97           C  
ATOM  13721  CG1 ILE   113      87.591  43.715  33.353  1.00 16.42           C  
ATOM  13722  CG2 ILE   113      86.275  41.686  32.506  1.00 16.23           C  
ATOM  13723  CD1 ILE   113      86.973  43.943  34.754  1.00 15.38           C  
ATOM  13724  N   ASN   114      89.573  39.326  33.152  1.00 17.62           N  
ATOM  13725  CA  ASN   114      89.721  37.861  33.017  1.00 18.16           C  
ATOM  13726  C   ASN   114      89.370  37.165  34.320  1.00 18.57           C  
ATOM  13727  O   ASN   114      88.867  36.056  34.301  1.00 19.99           O  
ATOM  13728  CB  ASN   114      91.130  37.469  32.547  1.00 18.52           C  
ATOM  13729  CG  ASN   114      91.406  37.829  31.083  1.00 20.10           C  
ATOM  13730  OD1 ASN   114      90.494  38.167  30.316  1.00 22.14           O  
ATOM  13731  ND2 ASN   114      92.665  37.744  30.689  1.00 20.05           N  
ATOM  13732  N   GLY   115      89.585  37.808  35.469  1.00 18.91           N  
ATOM  13733  CA  GLY   115      89.088  37.293  36.757  1.00 19.18           C  
ATOM  13734  C   GLY   115      87.609  36.931  36.679  1.00 19.79           C  
ATOM  13735  O   GLY   115      87.233  35.782  36.939  1.00 21.14           O  
ATOM  13736  N   ALA   116      86.771  37.891  36.267  1.00 19.18           N  
ATOM  13737  CA  ALA   116      85.331  37.638  36.074  1.00 18.73           C  
ATOM  13738  C   ALA   116      85.078  36.648  34.944  1.00 18.77           C  
ATOM  13739  O   ALA   116      84.318  35.704  35.117  1.00 18.13           O  
ATOM  13740  CB  ALA   116      84.563  38.940  35.818  1.00 17.60           C  
ATOM  13741  N   SER   117      85.690  36.872  33.792  1.00 19.29           N  
ATOM  13742  CA  SER   117      85.366  36.092  32.582  1.00 20.10           C  
ATOM  13743  C   SER   117      85.670  34.595  32.784  1.00 20.77           C  
ATOM  13744  O   SER   117      84.865  33.722  32.435  1.00 21.97           O  
ATOM  13745  CB  SER   117      86.103  36.640  31.358  1.00 19.41           C  
ATOM  13746  OG  SER   117      85.662  37.947  31.006  1.00 19.65           O  
ATOM  13747  N   ASN   118      86.810  34.313  33.389  1.00 21.80           N  
ATOM  13748  CA  ASN   118      87.247  32.938  33.669  1.00 21.92           C  
ATOM  13749  C   ASN   118      86.341  32.220  34.666  1.00 22.29           C  
ATOM  13750  O   ASN   118      86.014  31.026  34.477  1.00 23.85           O  
ATOM  13751  CB  ASN   118      88.672  32.936  34.193  1.00 22.14           C  
ATOM  13752  CG  ASN   118      89.692  33.319  33.143  1.00 23.36           C  
ATOM  13753  OD1 ASN   118      89.434  33.295  31.932  1.00 27.40           O  
ATOM  13754  ND2 ASN   118      90.877  33.671  33.606  1.00 27.49           N  
ATOM  13755  N   LEU   119      85.917  32.940  35.707  1.00 22.44           N  
ATOM  13756  CA  LEU   119      85.007  32.396  36.709  1.00 22.17           C  
ATOM  13757  C   LEU   119      83.654  32.058  36.071  1.00 22.24           C  
ATOM  13758  O   LEU   119      83.123  30.945  36.218  1.00 21.77           O  
ATOM  13759  CB  LEU   119      84.863  33.385  37.882  1.00 21.87           C  
ATOM  13760  CG  LEU   119      83.954  32.950  39.040  1.00 21.57           C  
ATOM  13761  CD1 LEU   119      84.343  33.550  40.394  1.00 22.43           C  
ATOM  13762  CD2 LEU   119      82.466  33.213  38.687  1.00 19.84           C  
ATOM  13763  N   ILE   120      83.100  33.014  35.340  1.00 22.68           N  
ATOM  13764  CA  ILE   120      81.797  32.834  34.691  1.00 23.03           C  
ATOM  13765  C   ILE   120      81.822  31.671  33.672  1.00 22.73           C  
ATOM  13766  O   ILE   120      80.921  30.827  33.672  1.00 22.74           O  
ATOM  13767  CB  ILE   120      81.304  34.189  34.057  1.00 22.50           C  
ATOM  13768  CG1 ILE   120      80.907  35.152  35.199  1.00 23.42           C  
ATOM  13769  CG2 ILE   120      80.119  33.969  33.092  1.00 23.23           C  
ATOM  13770  CD1 ILE   120      80.713  36.598  34.811  1.00 24.45           C  
ATOM  13771  N   ALA   121      82.859  31.598  32.846  1.00 22.93           N  
ATOM  13772  CA  ALA   121      82.995  30.525  31.867  1.00 23.71           C  
ATOM  13773  C   ALA   121      83.172  29.164  32.552  1.00 24.46           C  
ATOM  13774  O   ALA   121      82.589  28.167  32.118  1.00 24.40           O  
ATOM  13775  CB  ALA   121      84.153  30.806  30.923  1.00 24.16           C  
ATOM  13776  N   THR   122      83.934  29.146  33.646  1.00 25.07           N  
ATOM  13777  CA  THR   122      84.155  27.929  34.423  1.00 25.52           C  
ATOM  13778  C   THR   122      82.873  27.370  35.045  1.00 25.94           C  
ATOM  13779  O   THR   122      82.621  26.176  34.942  1.00 27.29           O  
ATOM  13780  CB  THR   122      85.229  28.151  35.493  1.00 25.67           C  
ATOM  13781  OG1 THR   122      86.465  28.470  34.828  1.00 25.67           O  
ATOM  13782  CG2 THR   122      85.404  26.905  36.403  1.00 25.84           C  
ATOM  13783  N   VAL   123      82.070  28.205  35.692  1.00 25.64           N  
ATOM  13784  CA  VAL   123      80.892  27.707  36.398  1.00 25.47           C  
ATOM  13785  C   VAL   123      79.727  27.416  35.437  1.00 25.14           C  
ATOM  13786  O   VAL   123      78.923  26.530  35.706  1.00 25.86           O  
ATOM  13787  CB  VAL   123      80.457  28.640  37.539  1.00 25.42           C  
ATOM  13788  CG1 VAL   123      81.594  28.801  38.558  1.00 25.65           C  
ATOM  13789  CG2 VAL   123      79.991  29.985  37.025  1.00 25.96           C  
ATOM  13790  N   LEU   124      79.648  28.132  34.316  1.00 25.53           N  
ATOM  13791  CA  LEU   124      78.543  27.974  33.358  1.00 25.86           C  
ATOM  13792  C   LEU   124      78.893  27.133  32.121  1.00 26.58           C  
ATOM  13793  O   LEU   124      77.992  26.702  31.399  1.00 27.85           O  
ATOM  13794  CB  LEU   124      78.016  29.354  32.906  1.00 25.67           C  
ATOM  13795  CG  LEU   124      77.392  30.242  34.005  1.00 25.75           C  
ATOM  13796  CD1 LEU   124      76.923  31.620  33.473  1.00 24.79           C  
ATOM  13797  CD2 LEU   124      76.239  29.529  34.730  1.00 24.67           C  
ATOM  13798  N   GLY   125      80.171  26.905  31.855  1.00 26.92           N  
ATOM  13799  CA  GLY   125      80.601  26.262  30.617  1.00 27.47           C  
ATOM  13800  C   GLY   125      80.400  27.153  29.401  1.00 28.59           C  
ATOM  13801  O   GLY   125      80.450  28.395  29.501  1.00 27.96           O  
ATOM  13802  N   GLU   126      80.145  26.533  28.247  1.00 29.57           N  
ATOM  13803  CA  GLU   126      80.046  27.272  26.987  1.00 29.15           C  
ATOM  13804  C   GLU   126      79.064  28.438  27.036  1.00 28.94           C  
ATOM  13805  O   GLU   126      79.378  29.497  26.491  1.00 29.44           O  
ATOM  13806  CB  GLU   126      79.695  26.340  25.813  1.00 31.00           C  
ATOM  13807  CG  GLU   126      79.198  27.036  24.521  1.00 32.78           C  
ATOM  13808  CD  GLU   126      80.275  27.849  23.846  1.00 39.95           C  
ATOM  13809  OE1 GLU   126      81.484  27.537  24.067  1.00 43.72           O  
ATOM  13810  OE2 GLU   126      79.914  28.797  23.096  1.00 44.33           O  
ATOM  13811  N   PRO   127      77.872  28.252  27.641  1.00 28.35           N  
ATOM  13812  CA  PRO   127      76.944  29.395  27.735  1.00 27.52           C  
ATOM  13813  C   PRO   127      77.493  30.606  28.480  1.00 26.17           C  
ATOM  13814  O   PRO   127      76.951  31.708  28.316  1.00 25.23           O  
ATOM  13815  CB  PRO   127      75.769  28.854  28.541  1.00 27.48           C  
ATOM  13816  CG  PRO   127      75.825  27.360  28.369  1.00 28.37           C  
ATOM  13817  CD  PRO   127      77.274  27.013  28.195  1.00 29.33           C  
ATOM  13818  N   GLY   128      78.509  30.381  29.316  1.00 24.90           N  
ATOM  13819  CA  GLY   128      79.160  31.456  30.029  1.00 24.87           C  
ATOM  13820  C   GLY   128      80.076  32.338  29.192  1.00 24.95           C  
ATOM  13821  O   GLY   128      80.490  33.405  29.683  1.00 25.60           O  
ATOM  13822  N   ARG   129      80.434  31.920  27.974  1.00 24.08           N  
ATOM  13823  CA  ARG   129      81.368  32.698  27.159  1.00 24.96           C  
ATOM  13824  C   ARG   129      80.614  33.880  26.582  1.00 23.19           C  
ATOM  13825  O   ARG   129      79.509  33.733  26.062  1.00 23.19           O  
ATOM  13826  CB  ARG   129      81.996  31.866  26.065  1.00 25.42           C  
ATOM  13827  CG  ARG   129      82.821  30.711  26.608  1.00 27.86           C  
ATOM  13828  CD  ARG   129      83.309  29.877  25.472  1.00 29.98           C  
ATOM  13829  NE  ARG   129      84.510  30.430  24.867  1.00 34.49           N  
ATOM  13830  CZ  ARG   129      84.825  30.292  23.581  1.00 36.05           C  
ATOM  13831  NH1 ARG   129      84.003  29.656  22.751  1.00 39.31           N  
ATOM  13832  NH2 ARG   129      85.952  30.809  23.108  1.00 35.44           N  
ATOM  13833  N   HIS   130      81.207  35.062  26.690  1.00 21.17           N  
ATOM  13834  CA  HIS   130      80.479  36.305  26.497  1.00 19.81           C  
ATOM  13835  C   HIS   130      81.292  37.340  25.734  1.00 18.95           C  
ATOM  13836  O   HIS   130      82.515  37.310  25.762  1.00 19.32           O  
ATOM  13837  CB  HIS   130      80.174  36.874  27.875  1.00 19.15           C  
ATOM  13838  CG  HIS   130      81.373  36.896  28.779  1.00 19.27           C  
ATOM  13839  ND1 HIS   130      81.715  35.823  29.575  1.00 18.83           N  
ATOM  13840  CD2 HIS   130      82.352  37.826  28.960  1.00 18.82           C  
ATOM  13841  CE1 HIS   130      82.841  36.093  30.215  1.00 19.50           C  
ATOM  13842  NE2 HIS   130      83.245  37.304  29.863  1.00 18.38           N  
ATOM  13843  N   ALA   131      80.591  38.238  25.056  1.00 18.23           N  
ATOM  13844  CA  ALA   131      81.198  39.483  24.562  1.00 17.93           C  
ATOM  13845  C   ALA   131      81.615  40.331  25.788  1.00 17.63           C  
ATOM  13846  O   ALA   131      81.145  40.128  26.900  1.00 18.26           O  
ATOM  13847  CB  ALA   131      80.243  40.256  23.664  1.00 17.85           C  
ATOM  13848  N   ARG   132      82.489  41.306  25.575  1.00 18.24           N  
ATOM  13849  CA  ARG   132      83.035  42.036  26.695  1.00 18.04           C  
ATOM  13850  C   ARG   132      83.617  43.385  26.284  1.00 17.43           C  
ATOM  13851  O   ARG   132      84.088  43.565  25.163  1.00 16.62           O  
ATOM  13852  CB  ARG   132      84.181  41.242  27.282  1.00 17.74           C  
ATOM  13853  CG  ARG   132      84.379  41.473  28.719  1.00 21.52           C  
ATOM  13854  CD  ARG   132      85.559  40.622  29.271  1.00 20.37           C  
ATOM  13855  NE  ARG   132      86.903  41.031  28.837  1.00 22.76           N  
ATOM  13856  CZ  ARG   132      88.019  40.471  29.328  1.00 21.32           C  
ATOM  13857  NH1 ARG   132      87.918  39.544  30.236  1.00 20.78           N  
ATOM  13858  NH2 ARG   132      89.223  40.856  28.939  1.00 22.78           N  
ATOM  13859  N   ALA   133      83.650  44.285  27.244  1.00 16.82           N  
ATOM  13860  CA  ALA   133      84.489  45.509  27.180  1.00 17.17           C  
ATOM  13861  C   ALA   133      85.251  45.582  28.508  1.00 16.48           C  
ATOM  13862  O   ALA   133      84.736  45.177  29.538  1.00 16.92           O  
ATOM  13863  CB  ALA   133      83.642  46.745  26.979  1.00 17.02           C  
ATOM  13864  N   ALA   134      86.494  46.049  28.468  1.00 16.84           N  
ATOM  13865  CA  ALA   134      87.303  46.207  29.665  1.00 16.59           C  
ATOM  13866  C   ALA   134      87.964  47.583  29.548  1.00 16.64           C  
ATOM  13867  O   ALA   134      88.695  47.845  28.578  1.00 17.05           O  
ATOM  13868  CB  ALA   134      88.348  45.119  29.805  1.00 17.16           C  
ATOM  13869  N   VAL   135      87.689  48.463  30.496  1.00 16.16           N  
ATOM  13870  CA  VAL   135      88.099  49.863  30.393  1.00 15.33           C  
ATOM  13871  C   VAL   135      88.602  50.422  31.715  1.00 15.04           C  
ATOM  13872  O   VAL   135      88.202  49.980  32.779  1.00 16.55           O  
ATOM  13873  CB  VAL   135      86.942  50.718  29.835  1.00 15.27           C  
ATOM  13874  CG1 VAL   135      86.621  50.279  28.369  1.00 15.28           C  
ATOM  13875  CG2 VAL   135      85.715  50.631  30.750  1.00 18.02           C  
ATOM  13876  N   GLY   136      89.451  51.440  31.644  1.00 14.42           N  
ATOM  13877  CA  GLY   136      90.007  52.072  32.833  1.00 14.05           C  
ATOM  13878  C   GLY   136      89.283  53.347  33.238  1.00 14.66           C  
ATOM  13879  O   GLY   136      89.192  54.307  32.461  1.00 16.32           O  
ATOM  13880  N   MET   137      88.838  53.366  34.492  1.00 15.74           N  
ATOM  13881  CA  MET   137      88.019  54.428  35.067  1.00 15.53           C  
ATOM  13882  C   MET   137      88.883  55.286  36.016  1.00 14.55           C  
ATOM  13883  O   MET   137      89.870  54.808  36.569  1.00 14.21           O  
ATOM  13884  CB  MET   137      86.856  53.860  35.881  1.00 17.67           C  
ATOM  13885  CG  MET   137      86.263  52.643  35.390  1.00 23.71           C  
ATOM  13886  SD  MET   137      85.665  52.752  33.523  1.00 32.58          SE  
ATOM  13887  CE  MET   137      84.716  54.461  33.938  1.00 19.25           C  
ATOM  13888  N   ALA   138      88.476  56.527  36.234  1.00 13.88           N  
ATOM  13889  CA  ALA   138      89.141  57.440  37.178  1.00 14.06           C  
ATOM  13890  C   ALA   138      88.955  56.936  38.616  1.00 14.04           C  
ATOM  13891  O   ALA   138      89.862  57.017  39.449  1.00 13.62           O  
ATOM  13892  CB  ALA   138      88.610  58.875  37.047  1.00 13.96           C  
ATOM  13893  N   SER   139      87.774  56.379  38.876  1.00 14.58           N  
ATOM  13894  CA  SER   139      87.388  55.917  40.210  1.00 15.14           C  
ATOM  13895  C   SER   139      85.992  55.291  40.117  1.00 14.88           C  
ATOM  13896  O   SER   139      85.324  55.457  39.108  1.00 14.48           O  
ATOM  13897  CB  SER   139      87.394  57.083  41.230  1.00 15.80           C  
ATOM  13898  OG  SER   139      86.720  58.247  40.755  1.00 16.73           O  
ATOM  13899  N   LEU   140      85.553  54.651  41.200  1.00 15.44           N  
ATOM  13900  CA  LEU   140      84.237  53.954  41.240  1.00 15.36           C  
ATOM  13901  C   LEU   140      83.547  54.180  42.597  1.00 15.58           C  
ATOM  13902  O   LEU   140      84.208  54.523  43.587  1.00 15.56           O  
ATOM  13903  CB  LEU   140      84.409  52.450  40.962  1.00 15.93           C  
ATOM  13904  CG  LEU   140      84.909  52.035  39.582  1.00 15.60           C  
ATOM  13905  CD1 LEU   140      85.286  50.549  39.605  1.00 15.22           C  
ATOM  13906  CD2 LEU   140      83.852  52.382  38.482  1.00 15.08           C  
ATOM  13907  N   PRO   141      82.211  54.021  42.644  1.00 15.44           N  
ATOM  13908  CA  PRO   141      81.453  54.136  43.911  1.00 16.14           C  
ATOM  13909  C   PRO   141      82.110  53.334  45.044  1.00 15.92           C  
ATOM  13910  O   PRO   141      82.581  52.199  44.826  1.00 16.30           O  
ATOM  13911  CB  PRO   141      80.075  53.575  43.548  1.00 15.94           C  
ATOM  13912  CG  PRO   141      79.935  53.831  42.101  1.00 15.45           C  
ATOM  13913  CD  PRO   141      81.316  53.727  41.508  1.00 15.64           C  
ATOM  13914  N   PHE   142      82.170  53.939  46.230  1.00 16.28           N  
ATOM  13915  CA  PHE   142      82.733  53.297  47.430  1.00 17.01           C  
ATOM  13916  C   PHE   142      84.216  52.930  47.312  1.00 17.24           C  
ATOM  13917  O   PHE   142      84.742  52.110  48.073  1.00 17.44           O  
ATOM  13918  CB  PHE   142      81.928  52.059  47.803  1.00 18.58           C  
ATOM  13919  CG  PHE   142      80.466  52.336  47.998  1.00 18.46           C  
ATOM  13920  CD1 PHE   142      80.015  52.864  49.180  1.00 21.60           C  
ATOM  13921  CD2 PHE   142      79.559  52.097  46.970  1.00 21.58           C  
ATOM  13922  CE1 PHE   142      78.682  53.137  49.358  1.00 21.61           C  
ATOM  13923  CE2 PHE   142      78.215  52.370  47.137  1.00 22.90           C  
ATOM  13924  CZ  PHE   142      77.776  52.887  48.332  1.00 22.64           C  
ATOM  13925  N   ASN   143      84.878  53.560  46.330  1.00 16.87           N  
ATOM  13926  CA  ASN   143      86.266  53.270  45.999  1.00 15.70           C  
ATOM  13927  C   ASN   143      86.510  51.824  45.587  1.00 15.55           C  
ATOM  13928  O   ASN   143      87.609  51.322  45.736  1.00 16.70           O  
ATOM  13929  CB  ASN   143      87.154  53.677  47.176  1.00 16.04           C  
ATOM  13930  CG  ASN   143      88.588  53.911  46.779  1.00 14.10           C  
ATOM  13931  OD1 ASN   143      88.914  54.151  45.608  1.00 17.82           O  
ATOM  13932  ND2 ASN   143      89.478  53.852  47.779  1.00 17.12           N  
ATOM  13933  N   ALA   144      85.488  51.161  45.023  1.00 15.75           N  
ATOM  13934  CA  ALA   144      85.636  49.826  44.460  1.00 15.29           C  
ATOM  13935  C   ALA   144      86.735  49.841  43.411  1.00 15.28           C  
ATOM  13936  O   ALA   144      86.847  50.796  42.624  1.00 14.89           O  
ATOM  13937  CB  ALA   144      84.350  49.361  43.831  1.00 15.92           C  
ATOM  13938  N   SER   145      87.538  48.785  43.403  1.00 15.49           N  
ATOM  13939  CA  SER   145      88.570  48.650  42.372  1.00 15.37           C  
ATOM  13940  C   SER   145      87.975  48.256  41.005  1.00 15.28           C  
ATOM  13941  O   SER   145      88.503  48.615  39.973  1.00 14.24           O  
ATOM  13942  CB  SER   145      89.687  47.688  42.825  1.00 16.67           C  
ATOM  13943  OG  SER   145      90.313  48.168  44.001  1.00 16.25           O  
ATOM  13944  N   VAL   146      86.877  47.516  41.017  1.00 14.87           N  
ATOM  13945  CA  VAL   146      86.230  47.021  39.809  1.00 15.23           C  
ATOM  13946  C   VAL   146      84.712  47.079  40.031  1.00 15.41           C  
ATOM  13947  O   VAL   146      84.210  46.874  41.153  1.00 15.54           O  
ATOM  13948  CB  VAL   146      86.670  45.536  39.456  1.00 15.05           C  
ATOM  13949  CG1 VAL   146      86.085  45.052  38.089  1.00 15.94           C  
ATOM  13950  CG2 VAL   146      88.232  45.354  39.571  1.00 14.96           C  
ATOM  13951  N   GLU   147      84.007  47.398  38.957  1.00 15.93           N  
ATOM  13952  CA  GLU   147      82.535  47.312  38.856  1.00 15.92           C  
ATOM  13953  C   GLU   147      82.252  46.607  37.524  1.00 15.93           C  
ATOM  13954  O   GLU   147      82.884  46.924  36.508  1.00 15.74           O  
ATOM  13955  CB  GLU   147      81.892  48.684  38.856  1.00 16.26           C  
ATOM  13956  CG  GLU   147      80.408  48.720  38.569  1.00 16.79           C  
ATOM  13957  CD  GLU   147      79.814  50.141  38.566  1.00 17.90           C  
ATOM  13958  OE1 GLU   147      80.472  51.032  39.106  1.00 16.37           O  
ATOM  13959  OE2 GLU   147      78.691  50.362  38.032  1.00 21.33           O  
ATOM  13960  N   ILE   148      81.306  45.667  37.535  1.00 16.14           N  
ATOM  13961  CA  ILE   148      80.988  44.895  36.342  1.00 15.98           C  
ATOM  13962  C   ILE   148      79.476  44.740  36.189  1.00 16.11           C  
ATOM  13963  O   ILE   148      78.794  44.315  37.129  1.00 16.86           O  
ATOM  13964  CB  ILE   148      81.601  43.456  36.330  1.00 16.86           C  
ATOM  13965  CG1 ILE   148      83.118  43.455  36.615  1.00 15.12           C  
ATOM  13966  CG2 ILE   148      81.313  42.831  34.929  1.00 17.11           C  
ATOM  13967  CD1 ILE   148      83.783  42.069  36.538  1.00 16.31           C  
ATOM  13968  N   ASP   149      78.974  45.086  35.011  1.00 15.24           N  
ATOM  13969  CA  ASP   149      77.541  44.879  34.705  1.00 16.84           C  
ATOM  13970  C   ASP   149      77.406  43.805  33.638  1.00 16.71           C  
ATOM  13971  O   ASP   149      78.409  43.329  33.087  1.00 19.31           O  
ATOM  13972  CB  ASP   149      76.857  46.181  34.332  1.00 17.25           C  
ATOM  13973  CG  ASP   149      77.178  46.666  32.924  1.00 18.92           C  
ATOM  13974  OD1 ASP   149      77.717  45.917  32.076  1.00 21.61           O  
ATOM  13975  OD2 ASP   149      76.901  47.857  32.671  1.00 23.19           O  
ATOM  13976  N   ALA   150      76.170  43.403  33.348  1.00 17.03           N  
ATOM  13977  CA  ALA   150      75.979  42.220  32.491  1.00 17.32           C  
ATOM  13978  C   ALA   150      74.653  42.251  31.760  1.00 17.32           C  
ATOM  13979  O   ALA   150      73.681  42.805  32.264  1.00 17.16           O  
ATOM  13980  CB  ALA   150      76.071  40.922  33.290  1.00 16.29           C  
ATOM  13981  N   ILE   151      74.636  41.600  30.597  1.00 17.86           N  
ATOM  13982  CA  ILE   151      73.385  41.298  29.877  1.00 18.64           C  
ATOM  13983  C   ILE   151      73.400  39.782  29.684  1.00 18.58           C  
ATOM  13984  O   ILE   151      74.408  39.216  29.252  1.00 16.46           O  
ATOM  13985  CB  ILE   151      73.295  41.986  28.517  1.00 18.12           C  
ATOM  13986  CG1 ILE   151      73.401  43.521  28.639  1.00 18.70           C  
ATOM  13987  CG2 ILE   151      72.005  41.638  27.832  1.00 18.34           C  
ATOM  13988  CD1 ILE   151      73.738  44.160  27.326  1.00 21.12           C  
ATOM  13989  N   VAL   152      72.296  39.127  30.014  1.00 19.65           N  
ATOM  13990  CA  VAL   152      72.245  37.677  30.062  1.00 20.85           C  
ATOM  13991  C   VAL   152      70.965  37.236  29.312  1.00 21.79           C  
ATOM  13992  O   VAL   152      69.875  37.732  29.595  1.00 23.25           O  
ATOM  13993  CB  VAL   152      72.234  37.157  31.530  1.00 20.51           C  
ATOM  13994  CG1 VAL   152      72.116  35.632  31.552  1.00 20.98           C  
ATOM  13995  CG2 VAL   152      73.472  37.627  32.314  1.00 19.78           C  
ATOM  13996  N   GLU   153      71.111  36.364  28.337  1.00 22.65           N  
ATOM  13997  CA  GLU   153      69.931  35.789  27.677  1.00 23.65           C  
ATOM  13998  C   GLU   153      69.416  34.643  28.566  1.00 23.87           C  
ATOM  13999  O   GLU   153      70.189  33.746  28.945  1.00 23.66           O  
ATOM  14000  CB  GLU   153      70.264  35.289  26.289  1.00 23.38           C  
ATOM  14001  CG  GLU   153      69.041  34.729  25.582  1.00 23.77           C  
ATOM  14002  CD  GLU   153      69.403  34.097  24.286  1.00 25.44           C  
ATOM  14003  OE1 GLU   153      69.856  34.818  23.377  1.00 28.66           O  
ATOM  14004  OE2 GLU   153      69.232  32.859  24.181  1.00 33.72           O  
ATOM  14005  N   ILE   154      68.116  34.683  28.885  1.00 25.68           N  
ATOM  14006  CA  ILE   154      67.500  33.757  29.854  1.00 26.78           C  
ATOM  14007  C   ILE   154      66.314  33.035  29.242  1.00 30.18           C  
ATOM  14008  O   ILE   154      65.740  33.496  28.257  1.00 29.70           O  
ATOM  14009  CB  ILE   154      67.039  34.458  31.150  1.00 26.75           C  
ATOM  14010  CG1 ILE   154      66.053  35.594  30.860  1.00 26.10           C  
ATOM  14011  CG2 ILE   154      68.259  34.960  31.966  1.00 25.49           C  
ATOM  14012  CD1 ILE   154      65.428  36.242  32.107  1.00 26.67           C  
ATOM  14013  N   ASP   155      65.987  31.894  29.838  1.00 34.08           N  
ATOM  14014  CA  ASP   155      64.750  31.169  29.526  1.00 38.39           C  
ATOM  14015  C   ASP   155      63.533  31.867  30.087  1.00 39.81           C  
ATOM  14016  O   ASP   155      63.331  31.884  31.303  1.00 41.42           O  
ATOM  14017  CB  ASP   155      64.825  29.774  30.112  1.00 38.89           C  
ATOM  14018  CG  ASP   155      65.674  28.876  29.280  1.00 42.84           C  
ATOM  14019  OD1 ASP   155      65.266  28.669  28.107  1.00 47.96           O  
ATOM  14020  OD2 ASP   155      66.738  28.398  29.774  1.00 48.12           O  
ATOM  14021  N   VAL   156      62.721  32.426  29.191  1.00 42.19           N  
ATOM  14022  CA  VAL   156      61.502  33.142  29.551  1.00 42.99           C  
ATOM  14023  C   VAL   156      60.299  32.349  29.037  1.00 44.31           C  
ATOM  14024  O   VAL   156      60.430  31.553  28.090  1.00 45.98           O  
ATOM  14025  CB  VAL   156      61.529  34.588  28.958  1.00 43.73           C  
ATOM  14026  CG1 VAL   156      60.139  35.038  28.439  1.00 44.09           C  
ATOM  14027  CG2 VAL   156      62.095  35.575  29.986  1.00 43.38           C  
END
