
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 (  681),  selected   84 , name 1t0r_C
# Molecule2: number of CA atoms   84 (  623),  selected   84 , name T0424_94_177.pdb
# PARAMETERS: 1t0r_C.T0424_94_177.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_C      -       -           -
LGA    T     3_C      -       -           -
LGA    F     4_C      -       -           -
LGA    P     5_C      -       -           -
LGA    I     6_C      -       -           -
LGA    M     7_C      -       -           -
LGA    S     8_C      -       -           -
LGA    N     9_C      -       -           -
LGA    F    10_C      -       -           -
LGA    E    11_C      L      94          4.777
LGA    R    12_C      A      95          2.499
LGA    -       -      G      96           -
LGA    D    13_C      F      97          0.647
LGA    -       -      L      98           -
LGA    -       -      V      99           -
LGA    F    14_C      D     100          2.539
LGA    V    15_C      C     101          1.472
LGA    I    16_C      S     102          2.961
LGA    Q    17_C      A     103          1.618
LGA    L    18_C      P     104          2.069
LGA    V    19_C      Q     105          3.702
LGA    P    20_C      L     106          0.560
LGA    V    21_C      N     107          2.999
LGA    D    22_C      V     108          3.267
LGA    T    23_C      K     109          0.739
LGA    E    24_C      G     110          1.170
LGA    D    25_C      M     111          0.306
LGA    T    26_C      T     112          0.449
LGA    M    27_C      V     113          0.390
LGA    D    28_C      L     114          0.512
LGA    Q    29_C      D     115          0.748
LGA    V    30_C      A     116          0.291
LGA    A    31_C      A     117          0.885
LGA    E    32_C      K     118          1.407
LGA    K    33_C      K     119          1.119
LGA    C    34_C      L     120          0.790
LGA    A    35_C      A     121          1.809
LGA    Y    36_C      A     122          1.825
LGA    H    37_C      P     123          2.420
LGA    S    38_C      W     124          2.622
LGA    I    39_C      P     125          2.563
LGA    N    40_C      -       -           -
LGA    R    41_C      -       -           -
LGA    R    42_C      -       -           -
LGA    V    43_C      -       -           -
LGA    H    44_C      Q     126          1.318
LGA    P    45_C      I     127          2.862
LGA    Q    46_C      K     128          3.676
LGA    P    47_C      A     129          4.445
LGA    E    48_C      -       -           -
LGA    K    49_C      -       -           -
LGA    I    50_C      V     130          3.828
LGA    L    51_C      V     131          3.758
LGA    R    52_C      L     132          4.962
LGA    V    53_C      -       -           -
LGA    R    54_C      -       -           -
LGA    R    55_C      -       -           -
LGA    H    56_C      -       -           -
LGA    E    57_C      -       -           -
LGA    D    58_C      -       -           -
LGA    G    59_C      -       -           -
LGA    T    60_C      -       -           -
LGA    L    61_C      -       -           -
LGA    F    62_C      -       -           -
LGA    P    63_C      K     133           #
LGA    R    64_C      A     134          5.120
LGA    -       -      E     135           -
LGA    -       -      N     136           -
LGA    G    65_C      N     137          0.774
LGA    M    66_C      P     138          1.404
LGA    I    67_C      A     139          1.615
LGA    V    68_C      L     140          1.517
LGA    S    69_C      G     141          1.187
LGA    D    70_C      -       -           -
LGA    A    71_C      -       -           -
LGA    G    72_C      K     142           #
LGA    L    73_C      I     143          3.757
LGA    R    74_C      -       -           -
LGA    P    75_C      D     144          0.598
LGA    T    76_C      I     145          0.784
LGA    E    77_C      E     146           #
LGA    -       -      P     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      T     150           -
LGA    -       -      V     151           -
LGA    -       -      W     152           -
LGA    T    78_C      Q     153          3.261
LGA    L    79_C      A     154          2.689
LGA    D    80_C      L     155          3.150
LGA    -       -      T     156           -
LGA    -       -      X     157           -
LGA    -       -      I     158           -
LGA    -       -      A     159           -
LGA    -       -      N     160           -
LGA    -       -      S     161           -
LGA    -       -      V     162           -
LGA    -       -      G     163           -
LGA    -       -      L     164           -
LGA    -       -      X     165           -
LGA    I    81_C      P     166          4.664
LGA    I    82_C      W     167          2.998
LGA    F    83_C      L     168          2.757
LGA    -       -      E     169           -
LGA    -       -      P     170           -
LGA    -       -      D     171           -
LGA    -       -      G     172           -
LGA    -       -      T     173           -
LGA    -       -      L     174           -
LGA    M    84_C      V     175          3.836
LGA    D    85_C      V     176           -
LGA    -       -      G     177           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   84    5.0     52    2.59     7.69     42.256     1.933

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.205541 * X  +   0.978647 * Y  +  -0.001756 * Z  + -161.442001
  Y_new =   0.954730 * X  +  -0.200912 * Y  +  -0.219372 * Z  +  -0.011717
  Z_new =  -0.215041 * X  +   0.043413 * Y  +  -0.975640 * Z  + 201.237061 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.097125   -0.044468  [ DEG:   177.4522     -2.5478 ]
  Theta =   0.216734    2.924859  [ DEG:    12.4179    167.5821 ]
  Phi   =   1.358746   -1.782847  [ DEG:    77.8504   -102.1496 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1t0r_C                                        
REMARK     2: T0424_94_177.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1t0r_C.T0424_94_177.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   84   5.0   52   2.59    7.69  42.256
REMARK  ---------------------------------------------------------- 
MOLECULE 1t0r_C
HEADER    OXIDOREDUCTASE                          12-APR-04   1T0R              
TITLE     CRYSTAL STRUCTURE OF THE TOLUENE/O-XYLENE MONOOXYGENASE               
TITLE    2 HYDROXUYLASE FROM PSEUDOMONAS STUTZERI-AZIDE BOUND                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TOLUENE, O-XYLENE MONOOXYGENASE OXYGENASE                  
COMPND   3 SUBUNIT;                                                             
COMPND   4 CHAIN: A;                                                            
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: ALPHA SUBUNIT;                                        
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: TOLUENE, O-XYLENE MONOOXYGENASE OXYGENASE                  
COMPND   9 SUBUNIT;                                                             
COMPND  10 CHAIN: B;                                                            
COMPND  11 ENGINEERED: YES;                                                     
COMPND  12 OTHER_DETAILS: BETA SUBUNIT;                                         
COMPND  13 MOL_ID: 3;                                                           
COMPND  14 MOLECULE: TOUB;                                                      
COMPND  15 CHAIN: C;                                                            
COMPND  16 ENGINEERED: YES;                                                     
COMPND  17 OTHER_DETAILS: GAMMA SUBUNIT                                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS STUTZERI;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TOUA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PET22A;                               
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET22BEA;                                 
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: PSEUDOMONAS STUTZERI;                           
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 GENE: TOUE;                                                          
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PET22;                                
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PET22BEA;                                 
SOURCE  19 MOL_ID: 3;                                                           
SOURCE  20 ORGANISM_SCIENTIFIC: PSEUDOMONAS STUTZERI;                           
SOURCE  21 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  22 GENE: TOUB;                                                          
SOURCE  23 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  24 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  25 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  26 EXPRESSION_SYSTEM_VECTOR_TYPE: PET22;                                
SOURCE  27 EXPRESSION_SYSTEM_PLASMID: PET22BEA                                  
KEYWDS    DIIRON, 4-HELIX BUNDLE, AZIDE, CARBOXYLATE BRIDGE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.H.SAZINSKY,J.BARD,A.DI DONATO,S.J.LIPPARD                           
REVDAT   1   27-JUL-04 1T0R    0                                                
JRNL        AUTH   M.H.SAZINSKY,J.BARD,A.DI DONATO,S.J.LIPPARD                  
JRNL        TITL   CRYSTAL STRUCTURE OF THE TOLUENE/O-XYLENE                    
JRNL        TITL 2 MONOOXYGENASE HYDROXYLASE FROM PSEUDOMONAS                   
JRNL        TITL 3 STUTZERI OX1: INSIGHT INTO THE SUBSTRATE                     
JRNL        TITL 4 SPECIFICITY, SUBSTRATE CHANNELING, AND ACTIVE SITE           
JRNL        TITL 5 TUNING OF MULTICOMPONENT MONOOXYGENASES.                     
JRNL        REF    J.BIOL.CHEM.                  V. 279 30600 2004              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1T0R A    1   498  UNP    O87798   O87798_PSEST     1    498             
DBREF  1T0R B    1   330  UNP    O87802   O87802_PSEST     1    330             
DBREF  1T0R C    1    86  UNP    O87799   O87799_PSEST     1     86             
SEQRES   1 A  498  MET SER MET LEU LYS ARG GLU ASP TRP TYR ASP LEU THR          
SEQRES   2 A  498  ARG THR THR ASN TRP THR PRO LYS TYR VAL THR GLU ASN          
SEQRES   3 A  498  GLU LEU PHE PRO GLU GLU MET SER GLY ALA ARG GLY ILE          
SEQRES   4 A  498  SER MET GLU ALA TRP GLU LYS TYR ASP GLU PRO TYR LYS          
SEQRES   5 A  498  ILE THR TYR PRO GLU TYR VAL SER ILE GLN ARG GLU LYS          
SEQRES   6 A  498  ASP SER GLY ALA TYR SER ILE LYS ALA ALA LEU GLU ARG          
SEQRES   7 A  498  ASP GLY PHE VAL ASP ARG ALA ASP PRO GLY TRP VAL SER          
SEQRES   8 A  498  THR MET GLN LEU HIS PHE GLY ALA ILE ALA LEU GLU GLU          
SEQRES   9 A  498  TYR ALA ALA SER THR ALA GLU ALA ARG MET ALA ARG PHE          
SEQRES  10 A  498  ALA LYS ALA PRO GLY ASN ARG ASN MET ALA THR PHE GLY          
SEQRES  11 A  498  MET MET ASP GLU ASN ARG HIS GLY GLN ILE GLN LEU TYR          
SEQRES  12 A  498  PHE PRO TYR ALA ASN VAL LYS ARG SER ARG LYS TRP ASP          
SEQRES  13 A  498  TRP ALA HIS LYS ALA ILE HIS THR ASN GLU TRP ALA ALA          
SEQRES  14 A  498  ILE ALA ALA ARG SER PHE PHE ASP ASP MET MET MET THR          
SEQRES  15 A  498  ARG ASP SER VAL ALA VAL SER ILE MET LEU THR PHE ALA          
SEQRES  16 A  498  PHE GLU THR GLY PHE THR ASN MET GLN PHE LEU GLY LEU          
SEQRES  17 A  498  ALA ALA ASP ALA ALA GLU ALA GLY ASP HIS THR PHE ALA          
SEQRES  18 A  498  SER LEU ILE SER SER ILE GLN THR ASP GLU SER ARG HIS          
SEQRES  19 A  498  ALA GLN GLN GLY GLY PRO SER LEU LYS ILE LEU VAL GLU          
SEQRES  20 A  498  ASN GLY LYS LYS ASP GLU ALA GLN GLN MET VAL ASP VAL          
SEQRES  21 A  498  ALA ILE TRP ARG SER TRP LYS LEU PHE SER VAL LEU THR          
SEQRES  22 A  498  GLY PRO ILE MET ASP TYR TYR THR PRO LEU GLU SER ARG          
SEQRES  23 A  498  ASN GLN SER PHE LYS GLU PHE MET LEU GLU TRP ILE VAL          
SEQRES  24 A  498  ALA GLN PHE GLU ARG GLN LEU LEU ASP LEU GLY LEU ASP          
SEQRES  25 A  498  LYS PRO TRP TYR TRP ASP GLN PHE MET GLN ASP LEU ASP          
SEQRES  26 A  498  GLU THR HIS HIS GLY MET HIS LEU GLY VAL TRP TYR TRP          
SEQRES  27 A  498  ARG PRO THR VAL TRP TRP ASP PRO ALA ALA GLY VAL SER          
SEQRES  28 A  498  PRO GLU GLU ARG GLU TRP LEU GLU GLU LYS TYR PRO GLY          
SEQRES  29 A  498  TRP ASN ASP THR TRP GLY GLN CYS TRP ASP VAL ILE THR          
SEQRES  30 A  498  ASP ASN LEU VAL ASN GLY LYS PRO GLU LEU THR VAL PRO          
SEQRES  31 A  498  GLU THR LEU PRO THR ILE CYS ASN MET CYS ASN LEU PRO          
SEQRES  32 A  498  ILE ALA HIS THR PRO GLY ASN LYS TRP ASN VAL LYS ASP          
SEQRES  33 A  498  TYR GLN LEU GLU TYR GLU GLY ARG LEU TYR HIS PHE GLY          
SEQRES  34 A  498  SER GLU ALA ASP ARG TRP CYS PHE GLN ILE ASP PRO GLU          
SEQRES  35 A  498  ARG TYR LYS ASN HIS THR ASN LEU VAL ASP ARG PHE LEU          
SEQRES  36 A  498  LYS GLY GLU ILE GLN PRO ALA ASP LEU ALA GLY ALA LEU          
SEQRES  37 A  498  MET TYR MET SER LEU GLU PRO GLY VAL MET GLY ASP ASP          
SEQRES  38 A  498  ALA HIS ASP TYR GLU TRP VAL LYS ALA TYR GLN LYS LYS          
SEQRES  39 A  498  THR ASN ALA ALA                                              
SEQRES   1 B  330  MET SER GLU GLN GLN PRO GLU ALA LEU LYS PRO LEU LYS          
SEQRES   2 B  330  THR TRP SER HIS LEU ALA GLY ASN ARG ARG ARG PRO SER          
SEQRES   3 B  330  GLU TYR GLU VAL VAL SER THR ASN LEU HIS TYR PHE THR          
SEQRES   4 B  330  ASP ASN PRO GLU ARG PRO TRP GLU LEU ASP SER ASN LEU          
SEQRES   5 B  330  PRO MET GLN THR TRP TYR LYS LYS TYR CYS PHE ASP SER          
SEQRES   6 B  330  PRO LEU LYS HIS ASP ASP TRP ASN ALA PHE ARG ASP PRO          
SEQRES   7 B  330  ASP GLN LEU VAL TYR ARG THR TYR ASN LEU LEU GLN ASP          
SEQRES   8 B  330  GLY GLN GLU SER TYR VAL GLN GLY LEU PHE ASP GLN LEU          
SEQRES   9 B  330  ASN ASP ARG GLY HIS ASP GLN MET LEU THR ARG GLU TRP          
SEQRES  10 B  330  VAL GLU THR LEU ALA ARG PHE TYR THR PRO ALA ARG TYR          
SEQRES  11 B  330  LEU PHE HIS ALA LEU GLN MET GLY SER VAL TYR ILE HIS          
SEQRES  12 B  330  GLN ILE ALA PRO ALA SER THR ILE THR ASN CYS ALA THR          
SEQRES  13 B  330  TYR GLU THR ALA ASP HIS LEU ARG TRP LEU THR HIS THR          
SEQRES  14 B  330  ALA TYR ARG THR ARG GLU LEU ALA ASN CYS TYR PRO ASP          
SEQRES  15 B  330  VAL GLY PHE GLY LYS ARG GLU ARG ASP VAL TRP GLU ASN          
SEQRES  16 B  330  ASP PRO ALA TRP GLN GLY PHE ARG GLU LEU ILE GLU LYS          
SEQRES  17 B  330  ALA LEU ILE ALA TRP ASP TRP GLY GLU ALA PHE THR ALA          
SEQRES  18 B  330  ILE ASN LEU VAL THR LYS PRO ALA VAL GLU GLU ALA LEU          
SEQRES  19 B  330  LEU GLN GLN LEU GLY SER LEU ALA GLN SER GLU GLY ASP          
SEQRES  20 B  330  THR LEU LEU GLY LEU LEU ALA GLN ALA GLN LYS ARG ASP          
SEQRES  21 B  330  ALA GLU ARG HIS ARG ARG TRP SER SER ALA LEU VAL LYS          
SEQRES  22 B  330  MET ALA LEU GLU LYS GLU GLY ASN ARG GLU VAL LEU GLN          
SEQRES  23 B  330  LYS TRP VAL ALA LYS TRP GLU PRO LEU ALA ASP LYS ALA          
SEQRES  24 B  330  ILE GLU ALA TYR CYS SER ALA LEU PRO ASP GLY GLU ASN          
SEQRES  25 B  330  ALA ILE VAL GLU ALA LYS SER ALA SER ARG TYR VAL ARG          
SEQRES  26 B  330  GLN MET MET GLY LEU                                          
SEQRES   1 C   86  MET ALA THR PHE PRO ILE MET SER ASN PHE GLU ARG ASP          
SEQRES   2 C   86  PHE VAL ILE GLN LEU VAL PRO VAL ASP THR GLU ASP THR          
SEQRES   3 C   86  MET ASP GLN VAL ALA GLU LYS CYS ALA TYR HIS SER ILE          
SEQRES   4 C   86  ASN ARG ARG VAL HIS PRO GLN PRO GLU LYS ILE LEU ARG          
SEQRES   5 C   86  VAL ARG ARG HIS GLU ASP GLY THR LEU PHE PRO ARG GLY          
SEQRES   6 C   86  MET ILE VAL SER ASP ALA GLY LEU ARG PRO THR GLU THR          
SEQRES   7 C   86  LEU ASP ILE ILE PHE MET ASP ASN                              
HET     FE    430       1                                                       
HET     FE    431       1                                                       
HET     OH    440       1                                                       
HET    AZI    450       3                                                       
HETNAM      FE FE (III) ION                                                     
HETNAM      OH HYDROXIDE ION                                                    
HETNAM     AZI AZIDE ION                                                        
FORMUL   4   FE    2(FE 3+)                                                     
FORMUL   6   OH    H O 1-                                                       
FORMUL   7  AZI    N3 1-                                                        
FORMUL   8  HOH   *345(H2 O)                                                    
CRYST1  182.705  182.705   67.784  90.00  90.00 120.00 P 31 2 1      6          
ATOM   6671  N   ALA C   2     -47.498  89.231 136.818  1.00 65.02           N  
ATOM   6672  CA  ALA C   2     -47.869  88.266 137.891  1.00 64.41           C  
ATOM   6673  C   ALA C   2     -47.366  86.874 137.538  1.00 64.03           C  
ATOM   6674  O   ALA C   2     -46.750  86.676 136.488  1.00 64.74           O  
ATOM   6675  CB  ALA C   2     -49.382  88.241 138.074  1.00 64.78           C  
ATOM   6676  N   THR C   3     -47.630  85.912 138.418  1.00 62.87           N  
ATOM   6677  CA  THR C   3     -47.199  84.541 138.188  1.00 60.38           C  
ATOM   6678  C   THR C   3     -48.078  83.898 137.134  1.00 58.46           C  
ATOM   6679  O   THR C   3     -49.256  84.220 136.997  1.00 58.98           O  
ATOM   6680  CB  THR C   3     -47.277  83.681 139.464  1.00 59.82           C  
ATOM   6681  OG1 THR C   3     -48.647  83.501 139.831  1.00 58.68           O  
ATOM   6682  CG2 THR C   3     -46.534  84.353 140.610  1.00 60.55           C  
ATOM   6683  N   PHE C   4     -47.485  82.981 136.392  1.00 55.60           N  
ATOM   6684  CA  PHE C   4     -48.174  82.267 135.338  1.00 53.07           C  
ATOM   6685  C   PHE C   4     -47.653  80.842 135.455  1.00 51.11           C  
ATOM   6686  O   PHE C   4     -46.443  80.625 135.569  1.00 50.28           O  
ATOM   6687  CB  PHE C   4     -47.789  82.862 133.982  1.00 52.59           C  
ATOM   6688  CG  PHE C   4     -48.519  82.258 132.810  1.00 52.23           C  
ATOM   6689  CD1 PHE C   4     -49.814  82.660 132.497  1.00 51.69           C  
ATOM   6690  CD2 PHE C   4     -47.889  81.326 131.987  1.00 51.79           C  
ATOM   6691  CE1 PHE C   4     -50.468  82.151 131.376  1.00 51.73           C  
ATOM   6692  CE2 PHE C   4     -48.536  80.808 130.862  1.00 52.03           C  
ATOM   6693  CZ  PHE C   4     -49.827  81.224 130.555  1.00 51.01           C  
ATOM   6694  N   PRO C   5     -48.555  79.854 135.462  1.00 49.46           N  
ATOM   6695  CA  PRO C   5     -48.097  78.470 135.571  1.00 48.35           C  
ATOM   6696  C   PRO C   5     -47.813  77.850 134.200  1.00 47.23           C  
ATOM   6697  O   PRO C   5     -48.481  78.174 133.211  1.00 47.23           O  
ATOM   6698  CB  PRO C   5     -49.268  77.798 136.261  1.00 48.64           C  
ATOM   6699  CG  PRO C   5     -50.431  78.471 135.592  1.00 46.70           C  
ATOM   6700  CD  PRO C   5     -50.018  79.931 135.639  1.00 48.68           C  
ATOM   6701  N   ILE C   6     -46.803  76.984 134.147  1.00 45.45           N  
ATOM   6702  CA  ILE C   6     -46.451  76.253 132.923  1.00 45.07           C  
ATOM   6703  C   ILE C   6     -45.873  74.915 133.352  1.00 44.98           C  
ATOM   6704  O   ILE C   6     -45.430  74.753 134.493  1.00 45.28           O  
ATOM   6705  CB  ILE C   6     -45.414  76.996 132.010  1.00 43.33           C  
ATOM   6706  CG1 ILE C   6     -44.094  77.228 132.742  1.00 42.19           C  
ATOM   6707  CG2 ILE C   6     -46.000  78.295 131.511  1.00 43.85           C  
ATOM   6708  CD1 ILE C   6     -43.115  76.105 132.584  1.00 39.47           C  
ATOM   6709  N   MET C   7     -45.902  73.944 132.449  1.00 44.59           N  
ATOM   6710  CA  MET C   7     -45.382  72.618 132.764  1.00 43.11           C  
ATOM   6711  C   MET C   7     -44.039  72.459 132.054  1.00 45.59           C  
ATOM   6712  O   MET C   7     -43.938  72.598 130.830  1.00 46.80           O  
ATOM   6713  CB  MET C   7     -46.405  71.556 132.348  1.00 38.28           C  
ATOM   6714  CG  MET C   7     -47.810  71.765 133.010  1.00 34.57           C  
ATOM   6715  SD  MET C   7     -47.808  71.707 134.882  1.00 24.44           S  
ATOM   6716  CE  MET C   7     -49.116  72.660 135.189  1.00 28.62           C  
ATOM   6717  N   SER C   8     -43.006  72.187 132.840  1.00 46.57           N  
ATOM   6718  CA  SER C   8     -41.664  72.052 132.313  1.00 46.27           C  
ATOM   6719  C   SER C   8     -41.270  70.633 131.927  1.00 47.18           C  
ATOM   6720  O   SER C   8     -41.204  69.746 132.772  1.00 46.96           O  
ATOM   6721  CB  SER C   8     -40.669  72.595 133.341  1.00 46.88           C  
ATOM   6722  OG  SER C   8     -39.327  72.306 132.971  1.00 48.58           O  
ATOM   6723  N   ASN C   9     -41.006  70.428 130.642  1.00 47.93           N  
ATOM   6724  CA  ASN C   9     -40.577  69.127 130.150  1.00 50.37           C  
ATOM   6725  C   ASN C   9     -39.091  69.311 129.839  1.00 52.48           C  
ATOM   6726  O   ASN C   9     -38.698  69.494 128.683  1.00 52.00           O  
ATOM   6727  CB  ASN C   9     -41.367  68.748 128.883  1.00 51.39           C  
ATOM   6728  CG  ASN C   9     -41.015  67.355 128.356  1.00 51.20           C  
ATOM   6729  OD1 ASN C   9     -40.680  66.452 129.123  1.00 51.76           O  
ATOM   6730  ND2 ASN C   9     -41.115  67.173 127.041  1.00 50.82           N  
ATOM   6731  N   PHE C  10     -38.268  69.287 130.884  1.00 53.81           N  
ATOM   6732  CA  PHE C  10     -36.834  69.475 130.710  1.00 54.95           C  
ATOM   6733  C   PHE C  10     -36.205  68.344 129.905  1.00 56.48           C  
ATOM   6734  O   PHE C  10     -36.549  67.167 130.086  1.00 56.95           O  
ATOM   6735  CB  PHE C  10     -36.133  69.592 132.062  1.00 53.40           C  
ATOM   6736  CG  PHE C  10     -35.083  70.665 132.104  1.00 53.62           C  
ATOM   6737  CD1 PHE C  10     -35.426  71.978 132.420  1.00 52.87           C  
ATOM   6738  CD2 PHE C  10     -33.749  70.367 131.830  1.00 53.70           C  
ATOM   6739  CE1 PHE C  10     -34.453  72.984 132.467  1.00 53.21           C  
ATOM   6740  CE2 PHE C  10     -32.768  71.362 131.871  1.00 53.71           C  
ATOM   6741  CZ  PHE C  10     -33.122  72.675 132.192  1.00 54.38           C  
ATOM   6742  N   GLU C  11     -35.282  68.703 129.015  1.00 56.94           N  
ATOM   6743  CA  GLU C  11     -34.622  67.704 128.191  1.00 57.73           C  
ATOM   6744  C   GLU C  11     -33.704  66.837 129.026  1.00 56.43           C  
ATOM   6745  O   GLU C  11     -32.971  67.330 129.884  1.00 55.25           O  
ATOM   6746  CB  GLU C  11     -33.819  68.358 127.063  1.00 60.26           C  
ATOM   6747  CG  GLU C  11     -32.839  67.410 126.386  1.00 62.38           C  
ATOM   6748  CD  GLU C  11     -32.240  67.985 125.118  1.00 64.71           C  
ATOM   6749  OE1 GLU C  11     -31.836  69.171 125.124  1.00 65.70           O  
ATOM   6750  OE2 GLU C  11     -32.169  67.247 124.115  1.00 66.11           O  
ATOM   6751  N   ARG C  12     -33.771  65.537 128.759  1.00 56.03           N  
ATOM   6752  CA  ARG C  12     -32.975  64.525 129.438  1.00 54.97           C  
ATOM   6753  C   ARG C  12     -33.508  64.148 130.819  1.00 54.10           C  
ATOM   6754  O   ARG C  12     -32.970  63.250 131.464  1.00 54.72           O  
ATOM   6755  CB  ARG C  12     -31.512  64.962 129.515  1.00 56.42           C  
ATOM   6756  CG  ARG C  12     -30.891  65.251 128.145  1.00 57.68           C  
ATOM   6757  CD  ARG C  12     -29.397  65.522 128.259  1.00 60.23           C  
ATOM   6758  NE  ARG C  12     -28.667  64.306 128.613  1.00 61.64           N  
ATOM   6759  CZ  ARG C  12     -28.282  63.385 127.736  1.00 62.42           C  
ATOM   6760  NH1 ARG C  12     -28.547  63.548 126.441  1.00 63.29           N  
ATOM   6761  NH2 ARG C  12     -27.659  62.288 128.158  1.00 60.00           N  
ATOM   6762  N   ASP C  13     -34.557  64.833 131.274  1.00 53.10           N  
ATOM   6763  CA  ASP C  13     -35.178  64.498 132.556  1.00 51.12           C  
ATOM   6764  C   ASP C  13     -36.265  63.486 132.167  1.00 51.26           C  
ATOM   6765  O   ASP C  13     -36.553  63.308 130.978  1.00 52.08           O  
ATOM   6766  CB  ASP C  13     -35.812  65.727 133.220  1.00 48.81           C  
ATOM   6767  CG  ASP C  13     -36.033  65.536 134.729  1.00 48.29           C  
ATOM   6768  OD1 ASP C  13     -36.248  64.397 135.174  1.00 46.71           O  
ATOM   6769  OD2 ASP C  13     -36.009  66.527 135.485  1.00 48.80           O  
ATOM   6770  N   PHE C  14     -36.869  62.831 133.155  1.00 51.10           N  
ATOM   6771  CA  PHE C  14     -37.896  61.819 132.900  1.00 49.88           C  
ATOM   6772  C   PHE C  14     -39.305  62.299 133.178  1.00 49.40           C  
ATOM   6773  O   PHE C  14     -40.255  61.551 132.972  1.00 49.80           O  
ATOM   6774  CB  PHE C  14     -37.661  60.601 133.788  1.00 50.19           C  
ATOM   6775  CG  PHE C  14     -38.183  60.771 135.199  1.00 50.85           C  
ATOM   6776  CD1 PHE C  14     -39.269  60.022 135.652  1.00 49.87           C  
ATOM   6777  CD2 PHE C  14     -37.599  61.690 136.071  1.00 49.87           C  
ATOM   6778  CE1 PHE C  14     -39.762  60.185 136.954  1.00 49.27           C  
ATOM   6779  CE2 PHE C  14     -38.089  61.860 137.376  1.00 49.97           C  
ATOM   6780  CZ  PHE C  14     -39.171  61.105 137.816  1.00 48.57           C  
ATOM   6781  N   VAL C  15     -39.458  63.533 133.641  1.00 48.61           N  
ATOM   6782  CA  VAL C  15     -40.788  64.000 133.987  1.00 47.12           C  
ATOM   6783  C   VAL C  15     -41.066  65.489 133.797  1.00 46.51           C  
ATOM   6784  O   VAL C  15     -40.161  66.322 133.864  1.00 45.26           O  
ATOM   6785  CB  VAL C  15     -41.076  63.638 135.461  1.00 46.94           C  
ATOM   6786  CG1 VAL C  15     -40.139  64.423 136.373  1.00 45.76           C  
ATOM   6787  CG2 VAL C  15     -42.527  63.906 135.805  1.00 46.40           C  
ATOM   6788  N   ILE C  16     -42.340  65.800 133.557  1.00 47.51           N  
ATOM   6789  CA  ILE C  16     -42.819  67.173 133.402  1.00 46.02           C  
ATOM   6790  C   ILE C  16     -43.062  67.642 134.835  1.00 46.79           C  
ATOM   6791  O   ILE C  16     -43.538  66.864 135.672  1.00 46.54           O  
ATOM   6792  CB  ILE C  16     -44.183  67.248 132.707  1.00 44.63           C  
ATOM   6793  CG1 ILE C  16     -44.252  66.271 131.535  1.00 44.66           C  
ATOM   6794  CG2 ILE C  16     -44.442  68.672 132.270  1.00 44.30           C  
ATOM   6795  CD1 ILE C  16     -43.398  66.630 130.376  1.00 44.24           C  
ATOM   6796  N   GLN C  17     -42.756  68.902 135.116  1.00 46.26           N  
ATOM   6797  CA  GLN C  17     -42.945  69.442 136.456  1.00 45.97           C  
ATOM   6798  C   GLN C  17     -43.656  70.779 136.391  1.00 46.78           C  
ATOM   6799  O   GLN C  17     -43.554  71.509 135.397  1.00 46.93           O  
ATOM   6800  CB  GLN C  17     -41.594  69.646 137.152  1.00 45.27           C  
ATOM   6801  CG  GLN C  17     -40.786  68.390 137.384  1.00 44.10           C  
ATOM   6802  CD  GLN C  17     -39.437  68.690 138.009  1.00 44.67           C  
ATOM   6803  OE1 GLN C  17     -38.519  69.161 137.338  1.00 45.40           O  
ATOM   6804  NE2 GLN C  17     -39.314  68.433 139.305  1.00 45.34           N  
ATOM   6805  N   LEU C  18     -44.381  71.095 137.456  1.00 48.43           N  
ATOM   6806  CA  LEU C  18     -45.081  72.368 137.547  1.00 48.40           C  
ATOM   6807  C   LEU C  18     -44.000  73.394 137.843  1.00 48.57           C  
ATOM   6808  O   LEU C  18     -43.189  73.187 138.742  1.00 48.84           O  
ATOM   6809  CB  LEU C  18     -46.083  72.351 138.702  1.00 49.07           C  
ATOM   6810  CG  LEU C  18     -46.740  73.701 139.013  1.00 48.56           C  
ATOM   6811  CD1 LEU C  18     -47.604  74.108 137.834  1.00 49.02           C  
ATOM   6812  CD2 LEU C  18     -47.574  73.612 140.289  1.00 46.20           C  
ATOM   6813  N   VAL C  19     -43.966  74.480 137.078  1.00 48.73           N  
ATOM   6814  CA  VAL C  19     -42.972  75.525 137.298  1.00 48.79           C  
ATOM   6815  C   VAL C  19     -43.574  76.904 137.075  1.00 49.13           C  
ATOM   6816  O   VAL C  19     -43.851  77.299 135.936  1.00 47.44           O  
ATOM   6817  CB  VAL C  19     -41.759  75.382 136.359  1.00 49.25           C  
ATOM   6818  CG1 VAL C  19     -40.749  76.490 136.657  1.00 48.03           C  
ATOM   6819  CG2 VAL C  19     -41.120  74.005 136.523  1.00 48.57           C  
ATOM   6820  N   PRO C  20     -43.800  77.653 138.167  1.00 49.50           N  
ATOM   6821  CA  PRO C  20     -44.374  78.996 138.055  1.00 49.48           C  
ATOM   6822  C   PRO C  20     -43.348  79.996 137.524  1.00 49.47           C  
ATOM   6823  O   PRO C  20     -42.192  79.998 137.943  1.00 49.77           O  
ATOM   6824  CB  PRO C  20     -44.811  79.299 139.486  1.00 49.09           C  
ATOM   6825  CG  PRO C  20     -43.779  78.576 140.304  1.00 49.03           C  
ATOM   6826  CD  PRO C  20     -43.647  77.258 139.582  1.00 49.31           C  
ATOM   6827  N   VAL C  21     -43.773  80.824 136.577  1.00 50.04           N  
ATOM   6828  CA  VAL C  21     -42.911  81.843 135.992  1.00 49.53           C  
ATOM   6829  C   VAL C  21     -43.626  83.167 136.182  1.00 50.47           C  
ATOM   6830  O   VAL C  21     -44.674  83.219 136.824  1.00 51.36           O  
ATOM   6831  CB  VAL C  21     -42.682  81.601 134.475  1.00 48.97           C  
ATOM   6832  CG1 VAL C  21     -42.180  80.194 134.246  1.00 46.91           C  
ATOM   6833  CG2 VAL C  21     -43.960  81.843 133.691  1.00 47.14           C  
ATOM   6834  N   ASP C  22     -43.064  84.238 135.641  1.00 51.86           N  
ATOM   6835  CA  ASP C  22     -43.693  85.549 135.752  1.00 53.63           C  
ATOM   6836  C   ASP C  22     -44.077  85.983 134.342  1.00 53.93           C  
ATOM   6837  O   ASP C  22     -43.354  85.704 133.389  1.00 52.87           O  
ATOM   6838  CB  ASP C  22     -42.720  86.565 136.356  1.00 54.81           C  
ATOM   6839  CG  ASP C  22     -43.427  87.789 136.904  1.00 55.46           C  
ATOM   6840  OD1 ASP C  22     -44.084  87.665 137.961  1.00 53.86           O  
ATOM   6841  OD2 ASP C  22     -43.332  88.866 136.274  1.00 56.34           O  
ATOM   6842  N   THR C  23     -45.211  86.658 134.202  1.00 55.67           N  
ATOM   6843  CA  THR C  23     -45.639  87.088 132.878  1.00 58.12           C  
ATOM   6844  C   THR C  23     -44.564  87.959 132.234  1.00 59.79           C  
ATOM   6845  O   THR C  23     -44.518  88.100 131.013  1.00 60.22           O  
ATOM   6846  CB  THR C  23     -46.974  87.868 132.940  1.00 58.30           C  
ATOM   6847  OG1 THR C  23     -46.781  89.114 133.620  1.00 58.02           O  
ATOM   6848  CG2 THR C  23     -48.027  87.050 133.683  1.00 57.59           C  
ATOM   6849  N   GLU C  24     -43.687  88.521 133.061  1.00 61.69           N  
ATOM   6850  CA  GLU C  24     -42.620  89.383 132.567  1.00 64.10           C  
ATOM   6851  C   GLU C  24     -41.313  88.659 132.262  1.00 64.88           C  
ATOM   6852  O   GLU C  24     -40.441  89.204 131.589  1.00 65.12           O  
ATOM   6853  CB  GLU C  24     -42.351  90.511 133.564  1.00 64.85           C  
ATOM   6854  CG  GLU C  24     -43.454  91.554 133.634  1.00 67.28           C  
ATOM   6855  CD  GLU C  24     -43.884  92.047 132.257  1.00 69.00           C  
ATOM   6856  OE1 GLU C  24     -44.724  91.373 131.622  1.00 70.96           O  
ATOM   6857  OE2 GLU C  24     -43.380  93.098 131.804  1.00 70.06           O  
ATOM   6858  N   ASP C  25     -41.176  87.437 132.754  1.00 65.37           N  
ATOM   6859  CA  ASP C  25     -39.965  86.668 132.512  1.00 66.29           C  
ATOM   6860  C   ASP C  25     -39.606  86.563 131.036  1.00 66.29           C  
ATOM   6861  O   ASP C  25     -40.463  86.665 130.161  1.00 66.28           O  
ATOM   6862  CB  ASP C  25     -40.106  85.261 133.090  1.00 67.57           C  
ATOM   6863  CG  ASP C  25     -39.903  85.225 134.589  1.00 68.72           C  
ATOM   6864  OD1 ASP C  25     -39.834  86.312 135.206  1.00 69.57           O  
ATOM   6865  OD2 ASP C  25     -39.815  84.109 135.147  1.00 68.57           O  
ATOM   6866  N   THR C  26     -38.322  86.364 130.773  1.00 66.11           N  
ATOM   6867  CA  THR C  26     -37.826  86.217 129.416  1.00 65.16           C  
ATOM   6868  C   THR C  26     -37.769  84.722 129.185  1.00 64.57           C  
ATOM   6869  O   THR C  26     -37.626  83.961 130.146  1.00 65.14           O  
ATOM   6870  CB  THR C  26     -36.411  86.750 129.297  1.00 65.25           C  
ATOM   6871  OG1 THR C  26     -36.327  88.014 129.955  1.00 67.81           O  
ATOM   6872  CG2 THR C  26     -36.033  86.917 127.848  1.00 65.80           C  
ATOM   6873  N   MET C  27     -37.873  84.289 127.932  1.00 61.82           N  
ATOM   6874  CA  MET C  27     -37.801  82.862 127.647  1.00 59.68           C  
ATOM   6875  C   MET C  27     -36.515  82.334 128.297  1.00 60.59           C  
ATOM   6876  O   MET C  27     -36.430  81.172 128.695  1.00 61.11           O  
ATOM   6877  CB  MET C  27     -37.814  82.628 126.132  1.00 55.76           C  
ATOM   6878  CG  MET C  27     -38.867  81.614 125.662  1.00 50.58           C  
ATOM   6879  SD  MET C  27     -40.469  81.709 126.495  1.00 39.23           S  
ATOM   6880  CE  MET C  27     -41.154  83.101 125.737  1.00 44.51           C  
ATOM   6881  N   ASP C  28     -35.531  83.225 128.425  1.00 61.57           N  
ATOM   6882  CA  ASP C  28     -34.244  82.924 129.051  1.00 61.35           C  
ATOM   6883  C   ASP C  28     -34.428  82.732 130.561  1.00 60.54           C  
ATOM   6884  O   ASP C  28     -33.879  81.807 131.156  1.00 59.66           O  
ATOM   6885  CB  ASP C  28     -33.266  84.087 128.826  1.00 64.21           C  
ATOM   6886  CG  ASP C  28     -32.445  83.936 127.558  1.00 66.36           C  
ATOM   6887  OD1 ASP C  28     -32.979  83.413 126.563  1.00 69.91           O  
ATOM   6888  OD2 ASP C  28     -31.263  84.353 127.549  1.00 66.52           O  
ATOM   6889  N   GLN C  29     -35.198  83.630 131.168  1.00 59.53           N  
ATOM   6890  CA  GLN C  29     -35.456  83.589 132.600  1.00 58.68           C  
ATOM   6891  C   GLN C  29     -36.401  82.447 132.958  1.00 57.85           C  
ATOM   6892  O   GLN C  29     -36.366  81.928 134.077  1.00 56.17           O  
ATOM   6893  CB  GLN C  29     -36.041  84.923 133.055  1.00 59.59           C  
ATOM   6894  CG  GLN C  29     -35.158  86.104 132.695  1.00 60.94           C  
ATOM   6895  CD  GLN C  29     -35.749  87.422 133.119  1.00 60.93           C  
ATOM   6896  OE1 GLN C  29     -36.833  87.800 132.676  1.00 61.05           O  
ATOM   6897  NE2 GLN C  29     -35.041  88.136 133.989  1.00 61.70           N  
ATOM   6898  N   VAL C  30     -37.250  82.066 132.007  1.00 56.24           N  
ATOM   6899  CA  VAL C  30     -38.175  80.956 132.221  1.00 54.56           C  
ATOM   6900  C   VAL C  30     -37.319  79.696 132.337  1.00 53.84           C  
ATOM   6901  O   VAL C  30     -37.425  78.942 133.304  1.00 51.74           O  
ATOM   6902  CB  VAL C  30     -39.179  80.808 131.031  1.00 53.36           C  
ATOM   6903  CG1 VAL C  30     -39.854  79.453 131.073  1.00 52.72           C  
ATOM   6904  CG2 VAL C  30     -40.237  81.897 131.096  1.00 51.32           C  
ATOM   6905  N   ALA C  31     -36.451  79.499 131.350  1.00 53.85           N  
ATOM   6906  CA  ALA C  31     -35.571  78.340 131.315  1.00 55.26           C  
ATOM   6907  C   ALA C  31     -34.722  78.210 132.578  1.00 55.69           C  
ATOM   6908  O   ALA C  31     -34.409  77.100 133.015  1.00 55.76           O  
ATOM   6909  CB  ALA C  31     -34.674  78.408 130.082  1.00 53.99           C  
ATOM   6910  N   GLU C  32     -34.344  79.339 133.166  1.00 57.00           N  
ATOM   6911  CA  GLU C  32     -33.524  79.308 134.373  1.00 57.99           C  
ATOM   6912  C   GLU C  32     -34.336  78.786 135.554  1.00 55.87           C  
ATOM   6913  O   GLU C  32     -33.835  78.012 136.372  1.00 54.81           O  
ATOM   6914  CB  GLU C  32     -32.984  80.703 134.693  1.00 61.71           C  
ATOM   6915  CG  GLU C  32     -31.482  80.730 134.959  1.00 68.96           C  
ATOM   6916  CD  GLU C  32     -30.646  80.604 133.684  1.00 73.60           C  
ATOM   6917  OE1 GLU C  32     -30.653  81.556 132.865  1.00 76.19           O  
ATOM   6918  OE2 GLU C  32     -29.980  79.554 133.500  1.00 75.15           O  
ATOM   6919  N   LYS C  33     -35.594  79.206 135.634  1.00 54.43           N  
ATOM   6920  CA  LYS C  33     -36.470  78.760 136.713  1.00 53.38           C  
ATOM   6921  C   LYS C  33     -36.821  77.280 136.578  1.00 52.40           C  
ATOM   6922  O   LYS C  33     -37.144  76.627 137.569  1.00 53.31           O  
ATOM   6923  CB  LYS C  33     -37.750  79.602 136.747  1.00 51.83           C  
ATOM   6924  CG  LYS C  33     -37.505  81.036 137.166  1.00 48.33           C  
ATOM   6925  CD  LYS C  33     -38.792  81.824 137.230  1.00 46.42           C  
ATOM   6926  CE  LYS C  33     -38.529  83.211 137.785  1.00 43.80           C  
ATOM   6927  NZ  LYS C  33     -39.771  84.014 137.854  1.00 42.42           N  
ATOM   6928  N   CYS C  34     -36.755  76.764 135.352  1.00 50.95           N  
ATOM   6929  CA  CYS C  34     -37.046  75.358 135.079  1.00 49.69           C  
ATOM   6930  C   CYS C  34     -35.825  74.498 135.415  1.00 49.52           C  
ATOM   6931  O   CYS C  34     -35.953  73.420 136.003  1.00 49.97           O  
ATOM   6932  CB  CYS C  34     -37.410  75.154 133.599  1.00 49.14           C  
ATOM   6933  SG  CYS C  34     -39.008  75.823 133.071  1.00 49.28           S  
ATOM   6934  N   ALA C  35     -34.648  74.984 135.021  1.00 48.57           N  
ATOM   6935  CA  ALA C  35     -33.389  74.288 135.257  1.00 48.25           C  
ATOM   6936  C   ALA C  35     -33.212  74.015 136.734  1.00 48.98           C  
ATOM   6937  O   ALA C  35     -32.681  72.978 137.124  1.00 50.12           O  
ATOM   6938  CB  ALA C  35     -32.225  75.126 134.743  1.00 48.57           C  
ATOM   6939  N   TYR C  36     -33.661  74.962 137.550  1.00 48.89           N  
ATOM   6940  CA  TYR C  36     -33.571  74.854 138.998  1.00 48.81           C  
ATOM   6941  C   TYR C  36     -34.056  73.489 139.500  1.00 49.79           C  
ATOM   6942  O   TYR C  36     -33.400  72.854 140.333  1.00 48.68           O  
ATOM   6943  CB  TYR C  36     -34.415  75.963 139.633  1.00 49.19           C  
ATOM   6944  CG  TYR C  36     -34.387  75.972 141.138  1.00 49.83           C  
ATOM   6945  CD1 TYR C  36     -33.313  76.520 141.836  1.00 51.09           C  
ATOM   6946  CD2 TYR C  36     -35.424  75.412 141.866  1.00 50.89           C  
ATOM   6947  CE1 TYR C  36     -33.277  76.509 143.231  1.00 51.73           C  
ATOM   6948  CE2 TYR C  36     -35.400  75.390 143.252  1.00 53.15           C  
ATOM   6949  CZ  TYR C  36     -34.325  75.938 143.929  1.00 53.11           C  
ATOM   6950  OH  TYR C  36     -34.317  75.898 145.304  1.00 54.72           O  
ATOM   6951  N   HIS C  37     -35.202  73.047 138.978  1.00 49.92           N  
ATOM   6952  CA  HIS C  37     -35.817  71.779 139.369  1.00 49.73           C  
ATOM   6953  C   HIS C  37     -35.317  70.548 138.618  1.00 50.19           C  
ATOM   6954  O   HIS C  37     -35.751  69.431 138.914  1.00 50.31           O  
ATOM   6955  CB  HIS C  37     -37.340  71.866 139.206  1.00 49.17           C  
ATOM   6956  CG  HIS C  37     -37.977  72.948 140.025  1.00 48.69           C  
ATOM   6957  ND1 HIS C  37     -37.971  72.943 141.404  1.00 46.85           N  
ATOM   6958  CD2 HIS C  37     -38.610  74.087 139.656  1.00 47.76           C  
ATOM   6959  CE1 HIS C  37     -38.567  74.034 141.849  1.00 47.40           C  
ATOM   6960  NE2 HIS C  37     -38.966  74.745 140.809  1.00 48.44           N  
ATOM   6961  N   SER C  38     -34.415  70.737 137.657  1.00 50.31           N  
ATOM   6962  CA  SER C  38     -33.888  69.611 136.881  1.00 50.69           C  
ATOM   6963  C   SER C  38     -32.363  69.497 136.905  1.00 50.96           C  
ATOM   6964  O   SER C  38     -31.818  68.457 137.287  1.00 50.96           O  
ATOM   6965  CB  SER C  38     -34.367  69.706 135.429  1.00 49.31           C  
ATOM   6966  OG  SER C  38     -35.775  69.578 135.354  1.00 50.05           O  
ATOM   6967  N   ILE C  39     -31.685  70.561 136.477  1.00 51.37           N  
ATOM   6968  CA  ILE C  39     -30.225  70.592 136.445  1.00 50.83           C  
ATOM   6969  C   ILE C  39     -29.681  70.373 137.855  1.00 51.02           C  
ATOM   6970  O   ILE C  39     -30.147  70.989 138.818  1.00 48.72           O  
ATOM   6971  CB  ILE C  39     -29.700  71.954 135.888  1.00 51.52           C  
ATOM   6972  CG1 ILE C  39     -30.190  72.161 134.446  1.00 50.24           C  
ATOM   6973  CG2 ILE C  39     -28.166  72.005 135.951  1.00 50.19           C  
ATOM   6974  CD1 ILE C  39     -29.704  71.125 133.451  1.00 47.28           C  
ATOM   6975  N   ASN C  40     -28.700  69.478 137.958  1.00 51.22           N  
ATOM   6976  CA  ASN C  40     -28.065  69.126 139.222  1.00 52.71           C  
ATOM   6977  C   ASN C  40     -28.967  68.293 140.134  1.00 52.82           C  
ATOM   6978  O   ASN C  40     -28.529  67.823 141.188  1.00 53.05           O  
ATOM   6979  CB  ASN C  40     -27.577  70.378 139.965  1.00 54.91           C  
ATOM   6980  CG  ASN C  40     -26.429  71.079 139.242  1.00 56.89           C  
ATOM   6981  OD1 ASN C  40     -25.445  70.439 138.839  1.00 58.48           O  
ATOM   6982  ND2 ASN C  40     -26.546  72.400 139.079  1.00 54.73           N  
ATOM   6983  N   ARG C  41     -30.225  68.112 139.736  1.00 51.70           N  
ATOM   6984  CA  ARG C  41     -31.144  67.289 140.514  1.00 51.23           C  
ATOM   6985  C   ARG C  41     -31.164  65.895 139.885  1.00 51.41           C  
ATOM   6986  O   ARG C  41     -31.022  64.892 140.592  1.00 51.38           O  
ATOM   6987  CB  ARG C  41     -32.537  67.921 140.555  1.00 50.60           C  
ATOM   6988  CG  ARG C  41     -32.617  69.082 141.539  1.00 49.43           C  
ATOM   6989  CD  ARG C  41     -34.020  69.651 141.651  1.00 51.04           C  
ATOM   6990  NE  ARG C  41     -34.087  70.799 142.553  1.00 51.55           N  
ATOM   6991  CZ  ARG C  41     -34.139  70.730 143.881  1.00 51.90           C  
ATOM   6992  NH1 ARG C  41     -34.133  69.559 144.502  1.00 50.91           N  
ATOM   6993  NH2 ARG C  41     -34.201  71.844 144.594  1.00 53.66           N  
ATOM   6994  N   ARG C  42     -31.342  65.829 138.563  1.00 50.92           N  
ATOM   6995  CA  ARG C  42     -31.290  64.536 137.867  1.00 49.75           C  
ATOM   6996  C   ARG C  42     -30.997  64.734 136.364  1.00 49.99           C  
ATOM   6997  O   ARG C  42     -31.387  63.923 135.516  1.00 51.08           O  
ATOM   6998  CB  ARG C  42     -32.565  63.712 138.108  1.00 47.23           C  
ATOM   6999  CG  ARG C  42     -33.792  64.214 137.400  1.00 46.87           C  
ATOM   7000  CD  ARG C  42     -35.121  63.782 138.092  1.00 44.01           C  
ATOM   7001  NE  ARG C  42     -36.045  64.883 137.803  1.00 42.38           N  
ATOM   7002  CZ  ARG C  42     -36.550  65.703 138.723  1.00 40.29           C  
ATOM   7003  NH1 ARG C  42     -37.347  66.692 138.340  1.00 38.56           N  
ATOM   7004  NH2 ARG C  42     -36.306  65.493 140.034  1.00 39.55           N  
ATOM   7005  N   VAL C  43     -30.286  65.822 136.066  1.00 51.37           N  
ATOM   7006  CA  VAL C  43     -29.867  66.155 134.705  1.00 51.92           C  
ATOM   7007  C   VAL C  43     -28.559  66.953 134.766  1.00 53.28           C  
ATOM   7008  O   VAL C  43     -28.489  67.995 135.429  1.00 54.02           O  
ATOM   7009  CB  VAL C  43     -30.920  66.988 133.969  1.00 50.87           C  
ATOM   7010  CG1 VAL C  43     -30.364  67.443 132.631  1.00 51.02           C  
ATOM   7011  CG2 VAL C  43     -32.175  66.160 133.756  1.00 50.63           C  
ATOM   7012  N   HIS C  44     -27.525  66.455 134.085  1.00 54.65           N  
ATOM   7013  CA  HIS C  44     -26.212  67.105 134.067  1.00 54.70           C  
ATOM   7014  C   HIS C  44     -26.204  68.426 133.323  1.00 56.13           C  
ATOM   7015  O   HIS C  44     -26.866  68.578 132.302  1.00 55.04           O  
ATOM   7016  CB  HIS C  44     -25.160  66.214 133.406  1.00 55.52           C  
ATOM   7017  CG  HIS C  44     -24.875  64.943 134.140  1.00 56.22           C  
ATOM   7018  ND1 HIS C  44     -25.428  63.734 133.776  1.00 56.55           N  
ATOM   7019  CD2 HIS C  44     -24.073  64.688 135.203  1.00 55.92           C  
ATOM   7020  CE1 HIS C  44     -24.976  62.788 134.581  1.00 56.97           C  
ATOM   7021  NE2 HIS C  44     -24.153  63.341 135.455  1.00 56.57           N  
ATOM   7022  N   PRO C  45     -25.434  69.399 133.825  1.00 58.99           N  
ATOM   7023  CA  PRO C  45     -25.313  70.730 133.218  1.00 60.90           C  
ATOM   7024  C   PRO C  45     -24.570  70.640 131.880  1.00 62.78           C  
ATOM   7025  O   PRO C  45     -23.917  69.638 131.595  1.00 61.69           O  
ATOM   7026  CB  PRO C  45     -24.507  71.510 134.258  1.00 60.55           C  
ATOM   7027  CG  PRO C  45     -24.817  70.800 135.555  1.00 60.86           C  
ATOM   7028  CD  PRO C  45     -24.767  69.360 135.140  1.00 59.84           C  
ATOM   7029  N   GLN C  46     -24.667  71.684 131.064  1.00 65.50           N  
ATOM   7030  CA  GLN C  46     -23.988  71.706 129.766  1.00 69.06           C  
ATOM   7031  C   GLN C  46     -23.572  73.129 129.371  1.00 71.40           C  
ATOM   7032  O   GLN C  46     -24.247  73.788 128.572  1.00 70.70           O  
ATOM   7033  CB  GLN C  46     -24.894  71.108 128.680  1.00 69.02           C  
ATOM   7034  CG  GLN C  46     -25.023  69.595 128.741  1.00 68.63           C  
ATOM   7035  CD  GLN C  46     -25.941  69.048 127.671  1.00 69.74           C  
ATOM   7036  OE1 GLN C  46     -25.824  69.401 126.498  1.00 70.87           O  
ATOM   7037  NE2 GLN C  46     -26.858  68.172 128.068  1.00 70.06           N  
ATOM   7038  N   PRO C  47     -22.442  73.614 129.926  1.00 73.59           N  
ATOM   7039  CA  PRO C  47     -21.882  74.950 129.682  1.00 74.61           C  
ATOM   7040  C   PRO C  47     -21.702  75.322 128.216  1.00 75.36           C  
ATOM   7041  O   PRO C  47     -21.958  76.459 127.825  1.00 75.91           O  
ATOM   7042  CB  PRO C  47     -20.556  74.905 130.433  1.00 74.58           C  
ATOM   7043  CG  PRO C  47     -20.873  74.012 131.589  1.00 74.98           C  
ATOM   7044  CD  PRO C  47     -21.614  72.886 130.903  1.00 74.29           C  
ATOM   7045  N   GLU C  48     -21.261  74.369 127.405  1.00 75.88           N  
ATOM   7046  CA  GLU C  48     -21.055  74.628 125.987  1.00 76.72           C  
ATOM   7047  C   GLU C  48     -22.405  74.865 125.301  1.00 75.16           C  
ATOM   7048  O   GLU C  48     -22.460  75.345 124.167  1.00 75.05           O  
ATOM   7049  CB  GLU C  48     -20.328  73.440 125.343  1.00 79.85           C  
ATOM   7050  CG  GLU C  48     -19.602  73.750 124.026  1.00 84.61           C  
ATOM   7051  CD  GLU C  48     -20.362  73.286 122.780  1.00 87.31           C  
ATOM   7052  OE1 GLU C  48     -21.406  73.893 122.438  1.00 87.40           O  
ATOM   7053  OE2 GLU C  48     -19.905  72.307 122.144  1.00 88.62           O  
ATOM   7054  N   LYS C  49     -23.489  74.550 126.008  1.00 73.06           N  
ATOM   7055  CA  LYS C  49     -24.841  74.703 125.473  1.00 70.50           C  
ATOM   7056  C   LYS C  49     -25.676  75.831 126.093  1.00 68.60           C  
ATOM   7057  O   LYS C  49     -25.360  76.353 127.163  1.00 67.44           O  
ATOM   7058  CB  LYS C  49     -25.596  73.380 125.625  1.00 70.82           C  
ATOM   7059  CG  LYS C  49     -25.023  72.228 124.814  1.00 70.94           C  
ATOM   7060  CD  LYS C  49     -25.181  72.480 123.322  1.00 71.66           C  
ATOM   7061  CE  LYS C  49     -24.603  71.337 122.503  1.00 72.68           C  
ATOM   7062  NZ  LYS C  49     -24.749  71.576 121.039  1.00 72.71           N  
ATOM   7063  N   ILE C  50     -26.746  76.203 125.398  1.00 66.53           N  
ATOM   7064  CA  ILE C  50     -27.662  77.242 125.864  1.00 64.67           C  
ATOM   7065  C   ILE C  50     -29.079  76.660 125.947  1.00 62.95           C  
ATOM   7066  O   ILE C  50     -29.488  75.873 125.089  1.00 61.68           O  
ATOM   7067  CB  ILE C  50     -27.659  78.475 124.910  1.00 64.76           C  
ATOM   7068  CG1 ILE C  50     -26.493  79.412 125.252  1.00 65.24           C  
ATOM   7069  CG2 ILE C  50     -28.960  79.245 125.037  1.00 63.43           C  
ATOM   7070  CD1 ILE C  50     -25.116  78.800 125.096  1.00 66.84           C  
ATOM   7071  N   LEU C  51     -29.815  77.047 126.987  1.00 61.31           N  
ATOM   7072  CA  LEU C  51     -31.182  76.572 127.198  1.00 60.38           C  
ATOM   7073  C   LEU C  51     -32.217  77.387 126.435  1.00 60.02           C  
ATOM   7074  O   LEU C  51     -32.327  78.605 126.611  1.00 59.97           O  
ATOM   7075  CB  LEU C  51     -31.536  76.615 128.683  1.00 60.14           C  
ATOM   7076  CG  LEU C  51     -30.663  75.812 129.636  1.00 59.64           C  
ATOM   7077  CD1 LEU C  51     -31.239  75.912 131.036  1.00 60.16           C  
ATOM   7078  CD2 LEU C  51     -30.606  74.362 129.187  1.00 61.38           C  
ATOM   7079  N   ARG C  52     -32.987  76.706 125.597  1.00 59.31           N  
ATOM   7080  CA  ARG C  52     -34.017  77.365 124.811  1.00 58.75           C  
ATOM   7081  C   ARG C  52     -35.391  76.880 125.237  1.00 58.54           C  
ATOM   7082  O   ARG C  52     -35.515  75.861 125.917  1.00 59.20           O  
ATOM   7083  CB  ARG C  52     -33.796  77.097 123.323  1.00 58.61           C  
ATOM   7084  CG  ARG C  52     -32.463  77.601 122.826  1.00 57.07           C  
ATOM   7085  CD  ARG C  52     -32.342  79.086 123.073  1.00 57.37           C  
ATOM   7086  NE  ARG C  52     -33.416  79.823 122.415  1.00 59.73           N  
ATOM   7087  CZ  ARG C  52     -33.630  79.816 121.102  1.00 60.34           C  
ATOM   7088  NH1 ARG C  52     -32.838  79.109 120.307  1.00 61.18           N  
ATOM   7089  NH2 ARG C  52     -34.628  80.520 120.583  1.00 61.02           N  
ATOM   7090  N   VAL C  53     -36.421  77.614 124.835  1.00 57.96           N  
ATOM   7091  CA  VAL C  53     -37.787  77.265 125.194  1.00 57.19           C  
ATOM   7092  C   VAL C  53     -38.675  77.121 123.961  1.00 58.04           C  
ATOM   7093  O   VAL C  53     -38.708  78.005 123.102  1.00 57.69           O  
ATOM   7094  CB  VAL C  53     -38.394  78.343 126.139  1.00 56.62           C  
ATOM   7095  CG1 VAL C  53     -39.841  78.010 126.466  1.00 56.56           C  
ATOM   7096  CG2 VAL C  53     -37.567  78.443 127.421  1.00 55.06           C  
ATOM   7097  N   ARG C  54     -39.386  75.999 123.873  1.00 58.49           N  
ATOM   7098  CA  ARG C  54     -40.294  75.756 122.757  1.00 59.76           C  
ATOM   7099  C   ARG C  54     -41.608  75.139 123.235  1.00 60.01           C  
ATOM   7100  O   ARG C  54     -41.603  74.242 124.081  1.00 61.48           O  
ATOM   7101  CB  ARG C  54     -39.645  74.833 121.723  1.00 59.84           C  
ATOM   7102  CG  ARG C  54     -39.433  73.422 122.190  1.00 61.97           C  
ATOM   7103  CD  ARG C  54     -39.116  72.523 121.015  1.00 65.45           C  
ATOM   7104  NE  ARG C  54     -38.753  71.181 121.457  1.00 69.12           N  
ATOM   7105  CZ  ARG C  54     -38.343  70.209 120.648  1.00 70.71           C  
ATOM   7106  NH1 ARG C  54     -38.244  70.428 119.343  1.00 71.69           N  
ATOM   7107  NH2 ARG C  54     -38.022  69.021 121.147  1.00 71.11           N  
ATOM   7108  N   ARG C  55     -42.732  75.625 122.706  1.00 58.95           N  
ATOM   7109  CA  ARG C  55     -44.038  75.101 123.081  1.00 58.17           C  
ATOM   7110  C   ARG C  55     -44.053  73.613 122.735  1.00 57.23           C  
ATOM   7111  O   ARG C  55     -43.818  73.238 121.591  1.00 57.23           O  
ATOM   7112  CB  ARG C  55     -45.145  75.837 122.325  1.00 59.17           C  
ATOM   7113  CG  ARG C  55     -46.541  75.322 122.634  1.00 63.16           C  
ATOM   7114  CD  ARG C  55     -47.598  75.987 121.774  1.00 64.55           C  
ATOM   7115  NE  ARG C  55     -47.763  77.390 122.129  1.00 68.91           N  
ATOM   7116  CZ  ARG C  55     -47.648  78.400 121.270  1.00 71.57           C  
ATOM   7117  NH1 ARG C  55     -47.365  78.163 119.992  1.00 71.76           N  
ATOM   7118  NH2 ARG C  55     -47.810  79.652 121.690  1.00 72.12           N  
ATOM   7119  N   HIS C  56     -44.330  72.773 123.726  1.00 56.08           N  
ATOM   7120  CA  HIS C  56     -44.336  71.325 123.539  1.00 56.77           C  
ATOM   7121  C   HIS C  56     -45.285  70.792 122.463  1.00 58.31           C  
ATOM   7122  O   HIS C  56     -44.921  69.906 121.684  1.00 58.10           O  
ATOM   7123  CB  HIS C  56     -44.632  70.635 124.880  1.00 55.02           C  
ATOM   7124  CG  HIS C  56     -44.568  69.139 124.817  1.00 53.00           C  
ATOM   7125  ND1 HIS C  56     -45.622  68.366 124.378  1.00 50.79           N  
ATOM   7126  CD2 HIS C  56     -43.555  68.279 125.079  1.00 51.47           C  
ATOM   7127  CE1 HIS C  56     -45.260  67.096 124.369  1.00 49.69           C  
ATOM   7128  NE2 HIS C  56     -44.010  67.017 124.787  1.00 49.97           N  
ATOM   7129  N   GLU C  57     -46.493  71.337 122.415  1.00 59.73           N  
ATOM   7130  CA  GLU C  57     -47.495  70.890 121.461  1.00 61.62           C  
ATOM   7131  C   GLU C  57     -47.098  70.939 119.981  1.00 61.79           C  
ATOM   7132  O   GLU C  57     -47.186  69.936 119.285  1.00 61.20           O  
ATOM   7133  CB  GLU C  57     -48.790  71.678 121.681  1.00 63.10           C  
ATOM   7134  CG  GLU C  57     -49.995  71.128 120.927  1.00 66.73           C  
ATOM   7135  CD  GLU C  57     -51.320  71.700 121.420  1.00 68.50           C  
ATOM   7136  OE1 GLU C  57     -51.510  72.935 121.348  1.00 68.92           O  
ATOM   7137  OE2 GLU C  57     -52.173  70.909 121.880  1.00 69.21           O  
ATOM   7138  N   ASP C  58     -46.655  72.095 119.498  1.00 63.72           N  
ATOM   7139  CA  ASP C  58     -46.300  72.224 118.085  1.00 65.51           C  
ATOM   7140  C   ASP C  58     -44.817  72.373 117.760  1.00 66.31           C  
ATOM   7141  O   ASP C  58     -44.460  72.515 116.590  1.00 67.71           O  
ATOM   7142  CB  ASP C  58     -47.060  73.399 117.465  1.00 65.81           C  
ATOM   7143  CG  ASP C  58     -46.858  74.684 118.234  1.00 67.12           C  
ATOM   7144  OD1 ASP C  58     -46.026  74.690 119.164  1.00 66.99           O  
ATOM   7145  OD2 ASP C  58     -47.526  75.686 117.910  1.00 68.15           O  
ATOM   7146  N   GLY C  59     -43.961  72.351 118.780  1.00 66.33           N  
ATOM   7147  CA  GLY C  59     -42.525  72.473 118.557  1.00 65.12           C  
ATOM   7148  C   GLY C  59     -42.023  73.876 118.254  1.00 65.45           C  
ATOM   7149  O   GLY C  59     -40.856  74.056 117.897  1.00 64.91           O  
ATOM   7150  N   THR C  60     -42.895  74.872 118.391  1.00 65.47           N  
ATOM   7151  CA  THR C  60     -42.526  76.261 118.131  1.00 65.01           C  
ATOM   7152  C   THR C  60     -41.401  76.698 119.055  1.00 64.66           C  
ATOM   7153  O   THR C  60     -41.465  76.492 120.264  1.00 63.56           O  
ATOM   7154  CB  THR C  60     -43.714  77.219 118.341  1.00 64.90           C  
ATOM   7155  OG1 THR C  60     -44.707  76.991 117.334  1.00 64.60           O  
ATOM   7156  CG2 THR C  60     -43.244  78.659 118.265  1.00 64.83           C  
ATOM   7157  N   LEU C  61     -40.382  77.323 118.475  1.00 65.04           N  
ATOM   7158  CA  LEU C  61     -39.222  77.788 119.228  1.00 64.87           C  
ATOM   7159  C   LEU C  61     -39.330  79.281 119.537  1.00 64.40           C  
ATOM   7160  O   LEU C  61     -39.480  80.101 118.631  1.00 63.97           O  
ATOM   7161  CB  LEU C  61     -37.954  77.493 118.421  1.00 65.16           C  
ATOM   7162  CG  LEU C  61     -36.596  77.721 119.077  1.00 66.16           C  
ATOM   7163  CD1 LEU C  61     -36.523  76.970 120.392  1.00 66.71           C  
ATOM   7164  CD2 LEU C  61     -35.501  77.252 118.129  1.00 66.86           C  
ATOM   7165  N   PHE C  62     -39.257  79.628 120.820  1.00 64.43           N  
ATOM   7166  CA  PHE C  62     -39.359  81.025 121.238  1.00 64.20           C  
ATOM   7167  C   PHE C  62     -38.006  81.711 121.363  1.00 64.35           C  
ATOM   7168  O   PHE C  62     -37.079  81.176 121.977  1.00 64.39           O  
ATOM   7169  CB  PHE C  62     -40.094  81.132 122.575  1.00 63.77           C  
ATOM   7170  CG  PHE C  62     -41.505  80.627 122.533  1.00 64.65           C  
ATOM   7171  CD1 PHE C  62     -42.394  81.088 121.567  1.00 64.45           C  
ATOM   7172  CD2 PHE C  62     -41.946  79.688 123.457  1.00 64.30           C  
ATOM   7173  CE1 PHE C  62     -43.705  80.619 121.520  1.00 63.07           C  
ATOM   7174  CE2 PHE C  62     -43.252  79.215 123.420  1.00 64.08           C  
ATOM   7175  CZ  PHE C  62     -44.134  79.683 122.446  1.00 64.11           C  
ATOM   7176  N   PRO C  63     -37.876  82.919 120.784  1.00 63.85           N  
ATOM   7177  CA  PRO C  63     -36.610  83.649 120.861  1.00 63.01           C  
ATOM   7178  C   PRO C  63     -36.160  83.751 122.316  1.00 62.47           C  
ATOM   7179  O   PRO C  63     -36.989  83.898 123.214  1.00 62.79           O  
ATOM   7180  CB  PRO C  63     -36.968  85.007 120.263  1.00 63.00           C  
ATOM   7181  CG  PRO C  63     -38.019  84.653 119.256  1.00 62.54           C  
ATOM   7182  CD  PRO C  63     -38.880  83.692 120.030  1.00 63.19           C  
ATOM   7183  N   ARG C  64     -34.855  83.665 122.548  1.00 61.45           N  
ATOM   7184  CA  ARG C  64     -34.323  83.754 123.902  1.00 59.50           C  
ATOM   7185  C   ARG C  64     -34.951  84.914 124.671  1.00 59.09           C  
ATOM   7186  O   ARG C  64     -35.115  84.850 125.891  1.00 57.69           O  
ATOM   7187  CB  ARG C  64     -32.805  83.895 123.854  1.00 58.21           C  
ATOM   7188  CG  ARG C  64     -32.134  82.642 123.350  1.00 59.01           C  
ATOM   7189  CD  ARG C  64     -30.631  82.755 123.397  1.00 60.54           C  
ATOM   7190  NE  ARG C  64     -30.149  83.036 124.744  1.00 61.83           N  
ATOM   7191  CZ  ARG C  64     -28.862  83.060 125.075  1.00 62.66           C  
ATOM   7192  NH1 ARG C  64     -27.936  82.820 124.153  1.00 62.39           N  
ATOM   7193  NH2 ARG C  64     -28.500  83.319 126.325  1.00 62.38           N  
ATOM   7194  N   GLY C  65     -35.294  85.977 123.952  1.00 59.18           N  
ATOM   7195  CA  GLY C  65     -35.940  87.106 124.585  1.00 59.65           C  
ATOM   7196  C   GLY C  65     -37.379  86.686 124.807  1.00 61.64           C  
ATOM   7197  O   GLY C  65     -37.650  85.670 125.447  1.00 64.54           O  
ATOM   7198  N   MET C  66     -38.305  87.459 124.254  1.00 59.96           N  
ATOM   7199  CA  MET C  66     -39.751  87.200 124.362  1.00 57.78           C  
ATOM   7200  C   MET C  66     -40.228  86.912 125.795  1.00 58.25           C  
ATOM   7201  O   MET C  66     -39.826  85.930 126.431  1.00 59.23           O  
ATOM   7202  CB  MET C  66     -40.165  86.034 123.436  1.00 53.68           C  
ATOM   7203  CG  MET C  66     -41.686  85.853 123.375  1.00 49.10           C  
ATOM   7204  SD  MET C  66     -42.159  84.498 122.270  1.00 43.52           S  
ATOM   7205  CE  MET C  66     -42.855  85.545 120.880  1.00 45.93           C  
ATOM   7206  N   ILE C  67     -41.092  87.782 126.296  1.00 59.43           N  
ATOM   7207  CA  ILE C  67     -41.596  87.594 127.636  1.00 60.49           C  
ATOM   7208  C   ILE C  67     -42.861  86.758 127.570  1.00 60.32           C  
ATOM   7209  O   ILE C  67     -43.631  86.865 126.617  1.00 59.71           O  
ATOM   7210  CB  ILE C  67     -41.880  88.940 128.336  1.00 61.01           C  
ATOM   7211  CG1 ILE C  67     -42.953  89.724 127.578  1.00 61.38           C  
ATOM   7212  CG2 ILE C  67     -40.588  89.735 128.428  1.00 60.47           C  
ATOM   7213  CD1 ILE C  67     -43.467  90.948 128.324  1.00 60.17           C  
ATOM   7214  N   VAL C  68     -43.042  85.909 128.579  1.00 59.52           N  
ATOM   7215  CA  VAL C  68     -44.201  85.030 128.690  1.00 59.16           C  
ATOM   7216  C   VAL C  68     -45.446  85.704 128.140  1.00 58.87           C  
ATOM   7217  O   VAL C  68     -46.222  85.109 127.392  1.00 57.56           O  
ATOM   7218  CB  VAL C  68     -44.466  84.676 130.165  1.00 59.30           C  
ATOM   7219  CG1 VAL C  68     -45.690  83.787 130.277  1.00 58.79           C  
ATOM   7220  CG2 VAL C  68     -43.244  84.007 130.761  1.00 59.48           C  
ATOM   7221  N   SER C  69     -45.619  86.954 128.542  1.00 59.02           N  
ATOM   7222  CA  SER C  69     -46.747  87.775 128.140  1.00 58.97           C  
ATOM   7223  C   SER C  69     -46.950  87.858 126.623  1.00 58.33           C  
ATOM   7224  O   SER C  69     -48.073  88.041 126.152  1.00 58.64           O  
ATOM   7225  CB  SER C  69     -46.559  89.176 128.722  1.00 59.74           C  
ATOM   7226  OG  SER C  69     -47.556  90.066 128.267  1.00 62.99           O  
ATOM   7227  N   ASP C  70     -45.873  87.712 125.860  1.00 57.17           N  
ATOM   7228  CA  ASP C  70     -45.960  87.806 124.408  1.00 56.63           C  
ATOM   7229  C   ASP C  70     -46.002  86.466 123.679  1.00 56.88           C  
ATOM   7230  O   ASP C  70     -46.214  86.423 122.462  1.00 56.42           O  
ATOM   7231  CB  ASP C  70     -44.782  88.614 123.870  1.00 57.39           C  
ATOM   7232  CG  ASP C  70     -44.709  90.010 124.460  1.00 58.25           C  
ATOM   7233  OD1 ASP C  70     -45.777  90.631 124.658  1.00 58.39           O  
ATOM   7234  OD2 ASP C  70     -43.578  90.489 124.711  1.00 58.86           O  
ATOM   7235  N   ALA C  71     -45.804  85.380 124.418  1.00 56.40           N  
ATOM   7236  CA  ALA C  71     -45.787  84.043 123.834  1.00 55.80           C  
ATOM   7237  C   ALA C  71     -47.163  83.448 123.545  1.00 56.30           C  
ATOM   7238  O   ALA C  71     -47.272  82.459 122.816  1.00 56.25           O  
ATOM   7239  CB  ALA C  71     -44.992  83.105 124.734  1.00 55.52           C  
ATOM   7240  N   GLY C  72     -48.208  84.047 124.112  1.00 56.78           N  
ATOM   7241  CA  GLY C  72     -49.557  83.552 123.890  1.00 57.24           C  
ATOM   7242  C   GLY C  72     -49.733  82.121 124.369  1.00 57.27           C  
ATOM   7243  O   GLY C  72     -50.214  81.249 123.637  1.00 57.08           O  
ATOM   7244  N   LEU C  73     -49.346  81.880 125.613  1.00 56.49           N  
ATOM   7245  CA  LEU C  73     -49.449  80.555 126.193  1.00 55.46           C  
ATOM   7246  C   LEU C  73     -50.716  80.387 127.013  1.00 54.29           C  
ATOM   7247  O   LEU C  73     -51.184  81.334 127.647  1.00 55.42           O  
ATOM   7248  CB  LEU C  73     -48.237  80.292 127.086  1.00 55.90           C  
ATOM   7249  CG  LEU C  73     -46.862  80.428 126.426  1.00 55.71           C  
ATOM   7250  CD1 LEU C  73     -45.798  80.302 127.490  1.00 56.46           C  
ATOM   7251  CD2 LEU C  73     -46.670  79.373 125.348  1.00 54.75           C  
ATOM   7252  N   ARG C  74     -51.276  79.181 126.986  1.00 52.78           N  
ATOM   7253  CA  ARG C  74     -52.463  78.866 127.774  1.00 51.55           C  
ATOM   7254  C   ARG C  74     -51.907  78.562 129.158  1.00 50.94           C  
ATOM   7255  O   ARG C  74     -50.926  77.831 129.281  1.00 51.44           O  
ATOM   7256  CB  ARG C  74     -53.160  77.629 127.207  1.00 50.39           C  
ATOM   7257  CG  ARG C  74     -53.706  77.843 125.810  1.00 52.07           C  
ATOM   7258  CD  ARG C  74     -54.193  76.555 125.161  1.00 51.11           C  
ATOM   7259  NE  ARG C  74     -53.107  75.610 124.908  1.00 51.26           N  
ATOM   7260  CZ  ARG C  74     -53.221  74.524 124.148  1.00 50.65           C  
ATOM   7261  NH1 ARG C  74     -54.379  74.249 123.557  1.00 50.17           N  
ATOM   7262  NH2 ARG C  74     -52.185  73.707 123.987  1.00 48.86           N  
ATOM   7263  N   PRO C  75     -52.501  79.131 130.218  1.00 50.11           N  
ATOM   7264  CA  PRO C  75     -51.950  78.829 131.542  1.00 50.53           C  
ATOM   7265  C   PRO C  75     -51.764  77.335 131.726  1.00 51.80           C  
ATOM   7266  O   PRO C  75     -52.592  76.533 131.276  1.00 53.87           O  
ATOM   7267  CB  PRO C  75     -52.991  79.412 132.499  1.00 50.03           C  
ATOM   7268  CG  PRO C  75     -54.255  79.398 131.692  1.00 49.60           C  
ATOM   7269  CD  PRO C  75     -53.784  79.838 130.334  1.00 49.71           C  
ATOM   7270  N   THR C  76     -50.654  76.960 132.351  1.00 51.20           N  
ATOM   7271  CA  THR C  76     -50.382  75.559 132.599  1.00 50.87           C  
ATOM   7272  C   THR C  76     -49.830  74.855 131.352  1.00 50.55           C  
ATOM   7273  O   THR C  76     -49.558  73.655 131.367  1.00 51.05           O  
ATOM   7274  CB  THR C  76     -51.675  74.877 133.128  1.00 51.39           C  
ATOM   7275  OG1 THR C  76     -51.384  74.217 134.363  1.00 51.36           O  
ATOM   7276  CG2 THR C  76     -52.259  73.894 132.107  1.00 49.34           C  
ATOM   7277  N   GLU C  77     -49.659  75.622 130.281  1.00 50.07           N  
ATOM   7278  CA  GLU C  77     -49.115  75.124 129.016  1.00 49.80           C  
ATOM   7279  C   GLU C  77     -47.804  74.368 129.235  1.00 49.92           C  
ATOM   7280  O   GLU C  77     -46.994  74.754 130.079  1.00 50.06           O  
ATOM   7281  CB  GLU C  77     -48.833  76.303 128.097  1.00 48.84           C  
ATOM   7282  CG  GLU C  77     -48.259  75.933 126.758  1.00 49.81           C  
ATOM   7283  CD  GLU C  77     -49.325  75.839 125.695  1.00 50.00           C  
ATOM   7284  OE1 GLU C  77     -50.105  76.810 125.566  1.00 50.16           O  
ATOM   7285  OE2 GLU C  77     -49.382  74.805 124.993  1.00 47.89           O  
ATOM   7286  N   THR C  78     -47.584  73.303 128.467  1.00 49.94           N  
ATOM   7287  CA  THR C  78     -46.352  72.516 128.588  1.00 48.72           C  
ATOM   7288  C   THR C  78     -45.290  73.052 127.633  1.00 48.90           C  
ATOM   7289  O   THR C  78     -45.560  73.290 126.454  1.00 48.47           O  
ATOM   7290  CB  THR C  78     -46.593  71.027 128.277  1.00 47.97           C  
ATOM   7291  OG1 THR C  78     -47.395  70.455 129.314  1.00 46.23           O  
ATOM   7292  CG2 THR C  78     -45.269  70.267 128.181  1.00 46.25           C  
ATOM   7293  N   LEU C  79     -44.079  73.229 128.145  1.00 48.60           N  
ATOM   7294  CA  LEU C  79     -42.992  73.768 127.346  1.00 48.68           C  
ATOM   7295  C   LEU C  79     -41.736  72.920 127.423  1.00 49.08           C  
ATOM   7296  O   LEU C  79     -41.360  72.441 128.496  1.00 48.92           O  
ATOM   7297  CB  LEU C  79     -42.661  75.184 127.822  1.00 47.72           C  
ATOM   7298  CG  LEU C  79     -43.799  76.208 127.800  1.00 48.46           C  
ATOM   7299  CD1 LEU C  79     -43.418  77.407 128.663  1.00 47.78           C  
ATOM   7300  CD2 LEU C  79     -44.098  76.626 126.360  1.00 45.68           C  
ATOM   7301  N   ASP C  80     -41.085  72.734 126.279  1.00 49.22           N  
ATOM   7302  CA  ASP C  80     -39.843  71.978 126.248  1.00 50.11           C  
ATOM   7303  C   ASP C  80     -38.693  72.916 126.608  1.00 49.66           C  
ATOM   7304  O   ASP C  80     -38.694  74.084 126.233  1.00 48.78           O  
ATOM   7305  CB  ASP C  80     -39.588  71.386 124.858  1.00 49.83           C  
ATOM   7306  CG  ASP C  80     -40.614  70.343 124.468  1.00 51.84           C  
ATOM   7307  OD1 ASP C  80     -40.965  69.504 125.323  1.00 53.41           O  
ATOM   7308  OD2 ASP C  80     -41.063  70.352 123.299  1.00 52.55           O  
ATOM   7309  N   ILE C  81     -37.731  72.414 127.369  1.00 50.04           N  
ATOM   7310  CA  ILE C  81     -36.566  73.209 127.720  1.00 51.90           C  
ATOM   7311  C   ILE C  81     -35.411  72.409 127.138  1.00 53.35           C  
ATOM   7312  O   ILE C  81     -34.937  71.443 127.744  1.00 54.36           O  
ATOM   7313  CB  ILE C  81     -36.369  73.354 129.250  1.00 50.84           C  
ATOM   7314  CG1 ILE C  81     -37.317  74.405 129.838  1.00 50.29           C  
ATOM   7315  CG2 ILE C  81     -34.961  73.804 129.527  1.00 51.93           C  
ATOM   7316  CD1 ILE C  81     -38.769  74.049 129.773  1.00 51.14           C  
ATOM   7317  N   ILE C  82     -34.961  72.810 125.954  1.00 55.17           N  
ATOM   7318  CA  ILE C  82     -33.890  72.091 125.287  1.00 56.99           C  
ATOM   7319  C   ILE C  82     -32.506  72.738 125.271  1.00 58.66           C  
ATOM   7320  O   ILE C  82     -32.342  73.952 125.479  1.00 57.11           O  
ATOM   7321  CB  ILE C  82     -34.302  71.748 123.833  1.00 56.53           C  
ATOM   7322  CG1 ILE C  82     -34.630  73.031 123.065  1.00 55.04           C  
ATOM   7323  CG2 ILE C  82     -35.514  70.815 123.849  1.00 54.69           C  
ATOM   7324  CD1 ILE C  82     -35.205  72.797 121.684  1.00 53.74           C  
ATOM   7325  N   PHE C  83     -31.514  71.883 125.033  1.00 61.19           N  
ATOM   7326  CA  PHE C  83     -30.108  72.262 124.948  1.00 63.51           C  
ATOM   7327  C   PHE C  83     -29.736  72.479 123.480  1.00 66.83           C  
ATOM   7328  O   PHE C  83     -29.885  71.574 122.657  1.00 66.94           O  
ATOM   7329  CB  PHE C  83     -29.225  71.136 125.493  1.00 60.93           C  
ATOM   7330  CG  PHE C  83     -29.268  70.984 126.985  1.00 59.49           C  
ATOM   7331  CD1 PHE C  83     -28.617  71.892 127.810  1.00 59.27           C  
ATOM   7332  CD2 PHE C  83     -29.912  69.899 127.564  1.00 57.67           C  
ATOM   7333  CE1 PHE C  83     -28.610  71.722 129.195  1.00 57.77           C  
ATOM   7334  CE2 PHE C  83     -29.910  69.721 128.941  1.00 57.27           C  
ATOM   7335  CZ  PHE C  83     -29.254  70.633 129.759  1.00 57.00           C  
ATOM   7336  N   MET C  84     -29.263  73.678 123.154  1.00 70.92           N  
ATOM   7337  CA  MET C  84     -28.827  73.981 121.799  1.00 74.46           C  
ATOM   7338  C   MET C  84     -27.906  75.205 121.799  1.00 77.32           C  
ATOM   7339  O   MET C  84     -27.226  75.459 122.797  1.00 77.45           O  
ATOM   7340  CB  MET C  84     -30.036  74.153 120.857  1.00 73.55           C  
ATOM   7341  CG  MET C  84     -31.032  75.236 121.219  1.00 72.55           C  
ATOM   7342  SD  MET C  84     -32.570  75.139 120.256  1.00 66.22           S  
ATOM   7343  CE  MET C  84     -32.003  74.440 118.756  1.00 72.83           C  
ATOM   7344  N   ASP C  85     -27.865  75.954 120.696  1.00 80.58           N  
ATOM   7345  CA  ASP C  85     -26.994  77.131 120.617  1.00 82.21           C  
ATOM   7346  C   ASP C  85     -27.727  78.409 120.189  1.00 83.19           C  
ATOM   7347  O   ASP C  85     -27.289  79.037 119.196  1.00 83.50           O  
ATOM   7348  CB  ASP C  85     -25.840  76.843 119.655  1.00 82.82           C  
ATOM   7349  CG  ASP C  85     -25.190  75.492 119.912  1.00 83.77           C  
ATOM   7350  OD1 ASP C  85     -24.669  75.273 121.030  1.00 85.27           O  
ATOM   7351  OD2 ASP C  85     -25.198  74.647 118.995  1.00 83.36           O  
TER    7352      ASP C  85                                                      
END
MOLECULE T0424_94_177.pdb
ATOM    631  N   LEU    94     -30.472  64.408 127.901  1.00 31.32          
ATOM    632  CA  LEU    94     -30.886  64.905 129.205  1.00 32.87          
ATOM    633  C   LEU    94     -32.322  65.427 129.206  1.00 33.92          
ATOM    634  O   LEU    94     -32.903  65.626 130.272  1.00 35.10          
ATOM    635  CB  LEU    94     -29.910  65.974 129.722  1.00 33.73          
ATOM    636  CG  LEU    94     -28.424  65.627 129.839  1.00 32.67          
ATOM    637  CD1 LEU    94     -27.614  66.889 130.295  1.00 35.22          
ATOM    638  CD2 LEU    94     -28.201  64.465 130.777  1.00 36.22          
ATOM    639  N   ALA    95     -32.898  65.651 128.017  1.00 34.10          
ATOM    640  CA  ALA    95     -34.322  65.969 127.907  1.00 33.68          
ATOM    641  C   ALA    95     -35.155  64.865 128.454  1.00 33.59          
ATOM    642  O   ALA    95     -36.242  65.114 128.802  1.00 34.14          
ATOM    643  CB  ALA    95     -34.719  66.234 126.452  1.00 33.56          
ATOM    644  N   GLY    96     -34.670  63.617 128.470  1.00 34.66          
ATOM    645  CA  GLY    96     -35.368  62.512 129.122  1.00 34.70          
ATOM    646  C   GLY    96     -35.872  62.796 130.538  1.00 35.90          
ATOM    647  O   GLY    96     -36.962  62.417 130.865  1.00 34.43          
ATOM    648  N   PHE    97     -35.065  63.447 131.378  1.00 36.84          
ATOM    649  CA  PHE    97     -35.525  63.962 132.659  1.00 38.40          
ATOM    650  C   PHE    97     -36.748  64.897 132.567  1.00 39.55          
ATOM    651  O   PHE    97     -37.732  64.733 133.280  1.00 39.69          
ATOM    652  CB  PHE    97     -34.412  64.763 133.346  1.00 39.36          
ATOM    653  CG  PHE    97     -33.257  63.921 133.826  1.00 40.36          
ATOM    654  CD1 PHE    97     -33.431  63.017 134.884  1.00 39.09          
ATOM    655  CD2 PHE    97     -31.987  64.059 133.235  1.00 40.34          
ATOM    656  CE1 PHE    97     -32.368  62.255 135.343  1.00 39.78          
ATOM    657  CE2 PHE    97     -30.914  63.298 133.678  1.00 40.54          
ATOM    658  CZ  PHE    97     -31.100  62.395 134.751  1.00 40.74          
ATOM    659  N   LEU    98     -36.672  65.894 131.694  1.00 40.37          
ATOM    660  CA  LEU    98     -37.772  66.857 131.533  1.00 40.15          
ATOM    661  C   LEU    98     -39.030  66.214 130.937  1.00 39.84          
ATOM    662  O   LEU    98     -40.129  66.541 131.332  1.00 39.74          
ATOM    663  CB  LEU    98     -37.295  68.022 130.673  1.00 40.91          
ATOM    664  CG  LEU    98     -35.984  68.692 131.136  1.00 43.39          
ATOM    665  CD1 LEU    98     -35.953  70.177 130.823  1.00 43.56          
ATOM    666  CD2 LEU    98     -35.758  68.472 132.615  1.00 42.31          
ATOM    667  N   VAL    99     -38.852  65.269 130.009  1.00 39.53          
ATOM    668  CA  VAL    99     -39.957  64.488 129.435  1.00 39.36          
ATOM    669  C   VAL    99     -40.648  63.600 130.446  1.00 40.07          
ATOM    670  O   VAL    99     -41.878  63.367 130.373  1.00 39.79          
ATOM    671  CB  VAL    99     -39.471  63.564 128.251  1.00 39.09          
ATOM    672  CG1 VAL    99     -40.508  62.518 127.940  1.00 36.51          
ATOM    673  CG2 VAL    99     -39.104  64.394 127.002  1.00 36.11          
ATOM    674  N   ASP   100     -39.857  63.064 131.370  1.00 40.79          
ATOM    675  CA  ASP   100     -40.359  62.121 132.363  1.00 41.66          
ATOM    676  C   ASP   100     -40.960  62.854 133.571  1.00 42.67          
ATOM    677  O   ASP   100     -41.981  62.449 134.085  1.00 41.73          
ATOM    678  CB  ASP   100     -39.246  61.232 132.919  1.00 41.09          
ATOM    679  CG  ASP   100     -38.685  60.220 131.916  1.00 41.20          
ATOM    680  OD1 ASP   100     -39.215  59.974 130.789  1.00 38.12          
ATOM    681  OD2 ASP   100     -37.632  59.673 132.300  1.00 41.45          
ATOM    682  N   CYS   101     -40.278  63.902 134.029  1.00 44.72          
ATOM    683  CA  CYS   101     -40.550  64.551 135.332  1.00 46.08          
ATOM    684  C   CYS   101     -41.570  65.680 135.232  1.00 46.69          
ATOM    685  O   CYS   101     -41.947  66.110 134.135  1.00 47.06          
ATOM    686  CB  CYS   101     -39.250  65.098 135.940  1.00 46.62          
ATOM    687  SG  CYS   101     -37.867  63.848 136.081  1.00 50.78          
ATOM    688  N   SER   102     -42.043  66.144 136.372  1.00 46.92          
ATOM    689  CA  SER   102     -43.159  67.124 136.343  1.00 48.06          
ATOM    690  C   SER   102     -42.742  68.584 136.408  1.00 48.09          
ATOM    691  O   SER   102     -41.796  68.941 137.112  1.00 47.53          
ATOM    692  CB  SER   102     -44.225  66.827 137.396  1.00 47.32          
ATOM    693  OG  SER   102     -45.338  66.314 136.694  1.00 49.89          
ATOM    694  N   ALA   103     -43.453  69.415 135.642  1.00 48.78          
ATOM    695  CA  ALA   103     -43.223  70.842 135.693  1.00 50.33          
ATOM    696  C   ALA   103     -43.653  71.293 137.097  1.00 50.76          
ATOM    697  O   ALA   103     -44.521  70.648 137.704  1.00 50.85          
ATOM    698  CB  ALA   103     -44.022  71.585 134.574  1.00 50.30          
ATOM    699  N   PRO   104     -42.977  72.317 137.648  1.00 52.08          
ATOM    700  CA  PRO   104     -43.571  73.101 138.756  1.00 52.25          
ATOM    701  C   PRO   104     -44.711  73.997 138.257  1.00 52.65          
ATOM    702  O   PRO   104     -44.948  74.092 137.031  1.00 51.65          
ATOM    703  CB  PRO   104     -42.397  73.979 139.259  1.00 52.72          
ATOM    704  CG  PRO   104     -41.134  73.462 138.542  1.00 52.36          
ATOM    705  CD  PRO   104     -41.623  72.800 137.286  1.00 52.44          
ATOM    706  N   GLN   105     -45.404  74.682 139.177  1.00 53.39          
ATOM    707  CA  GLN   105     -46.384  75.662 138.729  1.00 53.36          
ATOM    708  C   GLN   105     -45.828  77.097 138.835  1.00 53.55          
ATOM    709  O   GLN   105     -46.276  77.958 139.619  1.00 54.37          
ATOM    710  CB  GLN   105     -47.743  75.426 139.387  1.00 54.93          
ATOM    711  CG  GLN   105     -48.659  74.561 138.496  1.00 56.49          
ATOM    712  CD  GLN   105     -48.902  75.173 137.103  1.00 59.08          
ATOM    713  OE1 GLN   105     -48.718  76.391 136.890  1.00 61.74          
ATOM    714  NE2 GLN   105     -49.322  74.326 136.150  1.00 57.67          
ATOM    715  N   LEU   106     -44.809  77.298 138.010  1.00 52.41          
ATOM    716  CA  LEU   106     -44.190  78.576 137.734  1.00 51.29          
ATOM    717  C   LEU   106     -45.162  79.445 136.912  1.00 50.32          
ATOM    718  O   LEU   106     -45.873  78.933 136.044  1.00 50.83          
ATOM    719  CB  LEU   106     -42.886  78.300 136.954  1.00 51.27          
ATOM    720  CG  LEU   106     -41.997  79.408 136.379  1.00 52.24          
ATOM    721  CD1 LEU   106     -41.282  80.194 137.495  1.00 53.40          
ATOM    722  CD2 LEU   106     -40.970  78.808 135.358  1.00 50.96          
ATOM    723  N   ASN   107     -45.214  80.739 137.221  1.00 48.24          
ATOM    724  CA  ASN   107     -45.879  81.725 136.403  1.00 47.41          
ATOM    725  C   ASN   107     -44.772  82.501 135.657  1.00 46.64          
ATOM    726  O   ASN   107     -43.835  82.973 136.303  1.00 46.31          
ATOM    727  CB  ASN   107     -46.645  82.650 137.358  1.00 48.25          
ATOM    728  CG  ASN   107     -47.477  83.705 136.649  1.00 47.27          
ATOM    729  OD1 ASN   107     -47.103  84.183 135.586  1.00 50.28          
ATOM    730  ND2 ASN   107     -48.607  84.053 137.227  1.00 38.82          
ATOM    731  N   VAL   108     -44.863  82.670 134.334  1.00 45.26          
ATOM    732  CA  VAL   108     -43.685  83.142 133.544  1.00 45.06          
ATOM    733  C   VAL   108     -43.683  84.642 133.065  1.00 44.11          
ATOM    734  O   VAL   108     -42.734  85.179 132.496  1.00 43.95          
ATOM    735  CB  VAL   108     -43.426  82.114 132.377  1.00 45.46          
ATOM    736  CG1 VAL   108     -44.108  82.505 131.042  1.00 44.93          
ATOM    737  CG2 VAL   108     -41.952  81.773 132.261  1.00 45.52          
ATOM    738  N   LYS   109     -44.726  85.329 133.426  1.00 43.87          
ATOM    739  CA  LYS   109     -45.102  86.585 132.812  1.00 42.70          
ATOM    740  C   LYS   109     -44.436  87.708 133.590  1.00 43.86          
ATOM    741  O   LYS   109     -44.481  87.722 134.863  1.00 44.65          
ATOM    742  CB  LYS   109     -46.620  86.697 132.913  1.00 42.23          
ATOM    743  CG  LYS   109     -47.374  85.326 133.160  1.00 38.08          
ATOM    744  CD  LYS   109     -48.900  85.477 133.340  1.00 39.19          
ATOM    745  CE  LYS   109     -49.295  86.274 134.621  1.00 29.34          
ATOM    746  NZ  LYS   109     -50.691  86.169 134.931  1.00 18.04          
ATOM    747  N   GLY   110     -43.756  88.655 132.948  1.00 44.07          
ATOM    748  CA  GLY   110     -42.920  88.525 131.831  1.00 43.27          
ATOM    749  C   GLY   110     -41.511  88.520 132.435  1.00 43.32          
ATOM    750  O   GLY   110     -40.797  89.554 132.525  1.00 41.80          
ATOM    751  N   MET   111     -41.210  87.329 132.954  1.00 43.59          
ATOM    752  CA  MET   111     -39.920  86.671 132.815  1.00 43.57          
ATOM    753  C   MET   111     -39.646  86.503 131.313  1.00 42.73          
ATOM    754  O   MET   111     -40.509  86.070 130.556  1.00 41.71          
ATOM    755  CB  MET   111     -39.927  85.248 133.412  1.00 44.40          
ATOM    756  CG  MET   111     -40.241  85.083 134.939  1.00 45.70          
ATOM    757  SD  MET   111     -40.165  83.323 135.375  1.00 45.54          
ATOM    758  CE  MET   111     -38.430  83.087 135.002  1.00 48.04          
ATOM    759  N   THR   112     -38.459  86.936 130.921  1.00 41.67          
ATOM    760  CA  THR   112     -37.744  86.516 129.741  1.00 41.00          
ATOM    761  C   THR   112     -37.883  84.995 129.458  1.00 40.91          
ATOM    762  O   THR   112     -38.128  84.184 130.395  1.00 39.90          
ATOM    763  CB  THR   112     -36.287  87.018 129.973  1.00 41.99          
ATOM    764  OG1 THR   112     -36.238  88.466 129.743  1.00 42.94          
ATOM    765  CG2 THR   112     -35.313  86.350 129.194  1.00 39.55          
ATOM    766  N   VAL   113     -37.794  84.613 128.171  1.00 39.19          
ATOM    767  CA  VAL   113     -37.938  83.192 127.803  1.00 38.99          
ATOM    768  C   VAL   113     -36.696  82.465 128.351  1.00 37.74          
ATOM    769  O   VAL   113     -36.825  81.404 128.904  1.00 35.89          
ATOM    770  CB  VAL   113     -38.263  82.983 126.259  1.00 38.81          
ATOM    771  CG1 VAL   113     -37.023  83.105 125.436  1.00 40.05          
ATOM    772  CG2 VAL   113     -38.950  81.625 125.988  1.00 39.74          
ATOM    773  N   LEU   114     -35.522  83.107 128.305  1.00 37.73          
ATOM    774  CA  LEU   114     -34.285  82.497 128.772  1.00 37.80          
ATOM    775  C   LEU   114     -34.320  82.209 130.247  1.00 38.39          
ATOM    776  O   LEU   114     -33.726  81.240 130.660  1.00 37.46          
ATOM    777  CB  LEU   114     -33.065  83.369 128.446  1.00 37.76          
ATOM    778  CG  LEU   114     -31.664  82.862 128.828  1.00 38.09          
ATOM    779  CD1 LEU   114     -31.431  81.365 128.458  1.00 42.92          
ATOM    780  CD2 LEU   114     -30.550  83.742 128.229  1.00 39.46          
ATOM    781  N   ASP   115     -34.982  83.090 131.036  1.00 38.71          
ATOM    782  CA  ASP   115     -35.118  82.929 132.498  1.00 38.65          
ATOM    783  C   ASP   115     -36.194  81.944 132.901  1.00 37.85          
ATOM    784  O   ASP   115     -35.982  81.173 133.823  1.00 38.57          
ATOM    785  CB  ASP   115     -35.376  84.286 133.206  1.00 39.19          
ATOM    786  CG  ASP   115     -34.157  85.156 133.233  1.00 43.54          
ATOM    787  OD1 ASP   115     -33.033  84.688 132.846  1.00 46.56          
ATOM    788  OD2 ASP   115     -34.319  86.335 133.651  1.00 51.72          
ATOM    789  N   ALA   116     -37.332  81.925 132.230  1.00 37.36          
ATOM    790  CA  ALA   116     -38.301  80.835 132.454  1.00 38.07          
ATOM    791  C   ALA   116     -37.730  79.423 132.036  1.00 38.99          
ATOM    792  O   ALA   116     -38.122  78.383 132.623  1.00 38.98          
ATOM    793  CB  ALA   116     -39.587  81.122 131.734  1.00 37.10          
ATOM    794  N   ALA   117     -36.798  79.383 131.076  1.00 38.86          
ATOM    795  CA  ALA   117     -36.160  78.084 130.707  1.00 39.89          
ATOM    796  C   ALA   117     -35.150  77.668 131.782  1.00 40.38          
ATOM    797  O   ALA   117     -35.124  76.492 132.188  1.00 40.63          
ATOM    798  CB  ALA   117     -35.469  78.156 129.324  1.00 38.98          
ATOM    799  N   LYS   118     -34.321  78.639 132.208  1.00 41.01          
ATOM    800  CA  LYS   118     -33.322  78.457 133.271  1.00 42.11          
ATOM    801  C   LYS   118     -34.018  77.916 134.505  1.00 43.02          
ATOM    802  O   LYS   118     -33.518  76.974 135.151  1.00 43.96          
ATOM    803  CB  LYS   118     -32.580  79.785 133.617  1.00 42.13          
ATOM    804  CG  LYS   118     -31.428  80.134 132.659  1.00 41.02          
ATOM    805  CD  LYS   118     -30.839  81.500 132.877  1.00 42.50          
ATOM    806  CE  LYS   118     -29.590  81.723 131.995  1.00 43.19          
ATOM    807  NZ  LYS   118     -29.103  83.173 132.155  1.00 41.67          
ATOM    808  N   LYS   119     -35.181  78.480 134.803  1.00 43.80          
ATOM    809  CA  LYS   119     -35.934  78.090 135.995  1.00 44.10          
ATOM    810  C   LYS   119     -36.285  76.642 135.900  1.00 43.70          
ATOM    811  O   LYS   119     -35.894  75.869 136.747  1.00 43.50          
ATOM    812  CB  LYS   119     -37.205  78.943 136.201  1.00 45.44          
ATOM    813  CG  LYS   119     -38.055  78.533 137.433  1.00 46.50          
ATOM    814  CD  LYS   119     -37.393  79.020 138.778  1.00 52.06          
ATOM    815  CE  LYS   119     -37.514  77.994 139.967  1.00 52.67          
ATOM    816  NZ  LYS   119     -38.758  78.151 140.813  1.00 52.88          
ATOM    817  N   LEU   120     -36.977  76.276 134.837  1.00 44.23          
ATOM    818  CA  LEU   120     -37.508  74.896 134.634  1.00 43.33          
ATOM    819  C   LEU   120     -36.463  73.796 134.554  1.00 42.75          
ATOM    820  O   LEU   120     -36.755  72.643 134.856  1.00 43.41          
ATOM    821  CB  LEU   120     -38.373  74.844 133.382  1.00 43.67          
ATOM    822  CG  LEU   120     -39.670  75.648 133.318  1.00 44.94          
ATOM    823  CD1 LEU   120     -40.015  75.948 131.830  1.00 43.41          
ATOM    824  CD2 LEU   120     -40.793  74.895 134.015  1.00 45.47          
ATOM    825  N   ALA   121     -35.259  74.138 134.105  1.00 42.53          
ATOM    826  CA  ALA   121     -34.130  73.190 134.025  1.00 42.11          
ATOM    827  C   ALA   121     -33.273  73.156 135.319  1.00 41.97          
ATOM    828  O   ALA   121     -32.373  72.329 135.447  1.00 40.35          
ATOM    829  CB  ALA   121     -33.250  73.562 132.857  1.00 41.60          
ATOM    830  N   ALA   122     -33.510  74.120 136.217  1.00 40.98          
ATOM    831  CA  ALA   122     -32.759  74.256 137.477  1.00 41.87          
ATOM    832  C   ALA   122     -32.574  72.959 138.288  1.00 41.61          
ATOM    833  O   ALA   122     -31.434  72.664 138.670  1.00 41.78          
ATOM    834  CB  ALA   122     -33.387  75.391 138.400  1.00 40.34          
ATOM    835  N   PRO   123     -33.672  72.192 138.545  1.00 42.01          
ATOM    836  CA  PRO   123     -33.565  70.900 139.267  1.00 42.75          
ATOM    837  C   PRO   123     -32.626  69.842 138.666  1.00 43.38          
ATOM    838  O   PRO   123     -32.307  68.854 139.327  1.00 44.75          
ATOM    839  CB  PRO   123     -35.008  70.356 139.251  1.00 43.04          
ATOM    840  CG  PRO   123     -35.880  71.511 138.977  1.00 40.40          
ATOM    841  CD  PRO   123     -35.068  72.462 138.141  1.00 41.52          
ATOM    842  N   TRP   124     -32.187  70.020 137.422  1.00 43.74          
ATOM    843  CA  TRP   124     -31.322  69.083 136.794  1.00 43.10          
ATOM    844  C   TRP   124     -29.997  69.711 136.519  1.00 44.01          
ATOM    845  O   TRP   124     -29.716  70.114 135.393  1.00 42.99          
ATOM    846  CB  TRP   124     -31.978  68.471 135.551  1.00 42.86          
ATOM    847  CG  TRP   124     -33.145  67.675 135.984  1.00 40.78          
ATOM    848  CD1 TRP   124     -33.137  66.395 136.468  1.00 41.48          
ATOM    849  CD2 TRP   124     -34.483  68.110 136.021  1.00 39.28          
ATOM    850  NE1 TRP   124     -34.413  66.012 136.797  1.00 40.34          
ATOM    851  CE2 TRP   124     -35.260  67.047 136.517  1.00 39.98          
ATOM    852  CE3 TRP   124     -35.124  69.293 135.637  1.00 40.65          
ATOM    853  CZ2 TRP   124     -36.648  67.140 136.680  1.00 41.02          
ATOM    854  CZ3 TRP   124     -36.499  69.381 135.806  1.00 41.19          
ATOM    855  CH2 TRP   124     -37.244  68.307 136.313  1.00 40.55          
ATOM    856  N   PRO   125     -29.139  69.762 137.570  1.00 45.64          
ATOM    857  CA  PRO   125     -27.870  70.448 137.445  1.00 45.93          
ATOM    858  C   PRO   125     -26.997  69.785 136.445  1.00 46.37          
ATOM    859  O   PRO   125     -26.049  70.413 135.948  1.00 46.58          
ATOM    860  CB  PRO   125     -27.278  70.399 138.869  1.00 46.66          
ATOM    861  CG  PRO   125     -27.981  69.307 139.540  1.00 46.96          
ATOM    862  CD  PRO   125     -29.340  69.236 138.933  1.00 45.91          
ATOM    863  N   GLN   126     -27.334  68.521 136.160  1.00 47.12          
ATOM    864  CA  GLN   126     -26.809  67.771 135.035  1.00 47.00          
ATOM    865  C   GLN   126     -26.909  68.582 133.696  1.00 47.32          
ATOM    866  O   GLN   126     -26.002  68.547 132.840  1.00 46.71          
ATOM    867  CB  GLN   126     -27.448  66.327 135.010  1.00 47.77          
ATOM    868  CG  GLN   126     -28.985  66.168 135.505  1.00 48.57          
ATOM    869  CD  GLN   126     -29.302  65.663 137.009  1.00 44.32          
ATOM    870  OE1 GLN   126     -28.717  66.048 137.940  1.00 46.03          
ATOM    871  NE2 GLN   126     -30.297  64.872 137.148  1.00 44.90          
ATOM    872  N   ILE   127     -27.979  69.366 133.549  1.00 47.63          
ATOM    873  CA  ILE   127     -28.061  70.396 132.492  1.00 47.76          
ATOM    874  C   ILE   127     -27.288  71.635 133.009  1.00 48.07          
ATOM    875  O   ILE   127     -27.789  72.407 133.818  1.00 47.78          
ATOM    876  CB  ILE   127     -29.560  70.743 132.119  1.00 47.78          
ATOM    877  CG1 ILE   127     -30.325  69.480 131.695  1.00 47.09          
ATOM    878  CG2 ILE   127     -29.624  71.797 131.003  1.00 46.93          
ATOM    879  CD  ILE   127     -31.862  69.582 131.763  1.00 47.45          
ATOM    880  N   LYS   128     -26.065  71.812 132.521  1.00 48.75          
ATOM    881  CA  LYS   128     -25.120  72.760 133.100  1.00 48.87          
ATOM    882  C   LYS   128     -25.129  74.162 132.479  1.00 48.31          
ATOM    883  O   LYS   128     -24.464  75.052 133.012  1.00 49.33          
ATOM    884  CB  LYS   128     -23.703  72.199 133.023  1.00 50.03          
ATOM    885  CG  LYS   128     -23.388  71.080 133.994  1.00 51.17          
ATOM    886  CD  LYS   128     -22.050  70.447 133.658  1.00 51.13          
ATOM    887  CE  LYS   128     -21.696  69.316 134.648  1.00 53.76          
ATOM    888  NZ  LYS   128     -20.685  68.320 134.094  1.00 53.98          
ATOM    889  N   ALA   129     -25.850  74.367 131.371  1.00 47.27          
ATOM    890  CA  ALA   129     -26.104  75.716 130.840  1.00 46.07          
ATOM    891  C   ALA   129     -27.409  75.745 130.084  1.00 45.68          
ATOM    892  O   ALA   129     -27.808  74.742 129.469  1.00 43.86          
ATOM    893  CB  ALA   129     -24.981  76.192 129.933  1.00 46.37          
ATOM    894  N   VAL   130     -28.086  76.896 130.157  1.00 44.12          
ATOM    895  CA  VAL   130     -29.263  77.178 129.340  1.00 44.02          
ATOM    896  C   VAL   130     -28.959  78.423 128.478  1.00 44.72          
ATOM    897  O   VAL   130     -28.543  79.460 128.989  1.00 45.08          
ATOM    898  CB  VAL   130     -30.505  77.382 130.206  1.00 43.13          
ATOM    899  CG1 VAL   130     -31.764  77.440 129.356  1.00 39.96          
ATOM    900  CG2 VAL   130     -30.582  76.277 131.252  1.00 40.18          
ATOM    901  N   VAL   131     -29.192  78.306 127.183  1.00 44.93          
ATOM    902  CA  VAL   131     -28.793  79.298 126.205  1.00 45.42          
ATOM    903  C   VAL   131     -30.030  79.632 125.369  1.00 45.75          
ATOM    904  O   VAL   131     -30.989  78.822 125.278  1.00 44.30          
ATOM    905  CB  VAL   131     -27.585  78.752 125.369  1.00 46.08          
ATOM    906  CG1 VAL   131     -27.494  79.360 123.963  1.00 48.27          
ATOM    907  CG2 VAL   131     -26.264  78.982 126.129  1.00 45.62          
ATOM    908  N   LEU   132     -30.048  80.858 124.832  1.00 46.00          
ATOM    909  CA  LEU   132     -31.140  81.319 123.968  1.00 46.49          
ATOM    910  C   LEU   132     -30.516  81.350 122.590  1.00 47.11          
ATOM    911  O   LEU   132     -29.404  81.861 122.391  1.00 47.20          
ATOM    912  CB  LEU   132     -31.750  82.672 124.411  1.00 46.61          
ATOM    913  CG  LEU   132     -32.940  83.301 123.642  1.00 44.73          
ATOM    914  CD1 LEU   132     -34.275  82.678 123.969  1.00 39.44          
ATOM    915  CD2 LEU   132     -33.014  84.840 123.863  1.00 46.67          
ATOM    916  N   LYS   133     -31.198  80.708 121.652  1.00 47.95          
ATOM    917  CA  LYS   133     -30.695  80.612 120.283  1.00 48.56          
ATOM    918  C   LYS   133     -31.656  81.439 119.411  1.00 48.77          
ATOM    919  O   LYS   133     -32.410  80.929 118.563  1.00 48.35          
ATOM    920  CB  LYS   133     -30.589  79.130 119.885  1.00 48.79          
ATOM    921  CG  LYS   133     -29.248  78.707 119.355  1.00 49.90          
ATOM    922  CD  LYS   133     -28.164  78.764 120.403  1.00 51.28          
ATOM    923  CE  LYS   133     -26.824  78.442 119.797  1.00 52.13          
ATOM    924  NZ  LYS   133     -26.748  76.998 119.425  1.00 52.63          
ATOM    925  N   ALA   134     -31.628  82.749 119.668  1.00 49.39          
ATOM    926  CA  ALA   134     -32.589  83.690 119.085  1.00 49.87          
ATOM    927  C   ALA   134     -32.058  85.143 119.188  1.00 50.83          
ATOM    928  O   ALA   134     -31.184  85.445 120.015  1.00 50.97          
ATOM    929  CB  ALA   134     -33.952  83.531 119.758  1.00 48.85          
ATOM    930  N   GLU   135     -32.554  86.030 118.329  1.00 51.95          
ATOM    931  CA  GLU   135     -32.065  87.403 118.300  1.00 53.09          
ATOM    932  C   GLU   135     -32.486  88.131 119.583  1.00 53.81          
ATOM    933  O   GLU   135     -31.697  88.862 120.217  1.00 53.87          
ATOM    934  CB  GLU   135     -32.619  88.146 117.080  1.00 53.66          
ATOM    935  CG  GLU   135     -31.982  87.753 115.720  1.00 56.72          
ATOM    936  CD  GLU   135     -30.635  88.448 115.438  1.00 59.74          
ATOM    937  OE1 GLU   135     -30.557  89.681 115.664  1.00 61.44          
ATOM    938  OE2 GLU   135     -29.671  87.759 114.974  1.00 60.19          
ATOM    939  N   ASN   136     -33.745  87.905 119.944  1.00 54.10          
ATOM    940  CA  ASN   136     -34.395  88.606 121.006  1.00 54.11          
ATOM    941  C   ASN   136     -34.900  87.657 122.071  1.00 53.84          
ATOM    942  O   ASN   136     -35.187  86.495 121.820  1.00 54.30          
ATOM    943  CB  ASN   136     -35.506  89.429 120.393  1.00 54.65          
ATOM    944  CG  ASN   136     -34.957  90.464 119.392  1.00 57.00          
ATOM    945  OD1 ASN   136     -34.323  91.464 119.794  1.00 58.44          
ATOM    946  ND2 ASN   136     -35.164  90.210 118.089  1.00 57.01          
ATOM    947  N   ASN   137     -34.994  88.174 123.280  1.00 53.24          
ATOM    948  CA  ASN   137     -35.226  87.376 124.458  1.00 52.32          
ATOM    949  C   ASN   137     -36.498  87.872 125.119  1.00 52.82          
ATOM    950  O   ASN   137     -36.456  88.587 126.164  1.00 52.03          
ATOM    951  CB  ASN   137     -34.020  87.533 125.363  1.00 52.07          
ATOM    952  CG  ASN   137     -34.135  86.738 126.615  1.00 50.83          
ATOM    953  OD1 ASN   137     -35.141  86.039 126.849  1.00 47.05          
ATOM    954  ND2 ASN   137     -33.106  86.841 127.454  1.00 49.01          
ATOM    955  N   PRO   138     -37.642  87.534 124.497  1.00 52.42          
ATOM    956  CA  PRO   138     -38.893  88.211 124.821  1.00 52.30          
ATOM    957  C   PRO   138     -39.328  87.955 126.241  1.00 51.98          
ATOM    958  O   PRO   138     -39.159  86.836 126.744  1.00 51.56          
ATOM    959  CB  PRO   138     -39.903  87.561 123.863  1.00 52.52          
ATOM    960  CG  PRO   138     -39.343  86.244 123.610  1.00 52.20          
ATOM    961  CD  PRO   138     -37.863  86.505 123.478  1.00 52.66          
ATOM    962  N   ALA   139     -39.870  89.007 126.861  1.00 51.66          
ATOM    963  CA  ALA   139     -40.711  88.881 128.047  1.00 50.96          
ATOM    964  C   ALA   139     -41.902  88.036 127.631  1.00 50.06          
ATOM    965  O   ALA   139     -42.499  88.273 126.601  1.00 50.30          
ATOM    966  CB  ALA   139     -41.163  90.267 128.569  1.00 50.90          
ATOM    967  N   LEU   140     -42.207  87.026 128.424  1.00 49.66          
ATOM    968  CA  LEU   140     -43.278  86.094 128.128  1.00 49.15          
ATOM    969  C   LEU   140     -44.588  86.691 128.508  1.00 49.75          
ATOM    970  O   LEU   140     -44.653  87.538 129.423  1.00 49.81          
ATOM    971  CB  LEU   140     -43.097  84.804 128.937  1.00 48.86          
ATOM    972  CG  LEU   140     -42.199  83.637 128.448  1.00 46.34          
ATOM    973  CD1 LEU   140     -42.354  83.399 126.920  1.00 42.72          
ATOM    974  CD2 LEU   140     -40.747  83.767 128.864  1.00 41.96          
ATOM    975  N   GLY   141     -45.636  86.243 127.831  1.00 50.37          
ATOM    976  CA  GLY   141     -47.001  86.615 128.146  1.00 51.04          
ATOM    977  C   GLY   141     -47.554  85.726 129.236  1.00 51.33          
ATOM    978  O   GLY   141     -46.819  85.243 130.074  1.00 51.56          
ATOM    979  N   LYS   142     -48.859  85.513 129.219  1.00 52.49          
ATOM    980  CA  LYS   142     -49.526  84.634 130.170  1.00 53.66          
ATOM    981  C   LYS   142     -49.550  83.203 129.663  1.00 54.43          
ATOM    982  O   LYS   142     -50.239  82.904 128.697  1.00 55.46          
ATOM    983  CB  LYS   142     -50.961  85.133 130.408  1.00 53.71          
ATOM    984  CG  LYS   142     -51.928  84.155 131.108  1.00 53.61          
ATOM    985  CD  LYS   142     -53.238  84.909 131.445  1.00 54.28          
ATOM    986  CE  LYS   142     -54.079  84.236 132.548  1.00 55.34          
ATOM    987  NZ  LYS   142     -55.125  85.190 133.141  1.00 53.75          
ATOM    988  N   ILE   143     -48.808  82.312 130.304  1.00 55.53          
ATOM    989  CA  ILE   143     -48.804  80.903 129.878  1.00 56.18          
ATOM    990  C   ILE   143     -49.408  80.027 130.984  1.00 57.50          
ATOM    991  O   ILE   143     -48.841  79.899 132.076  1.00 58.04          
ATOM    992  CB  ILE   143     -47.410  80.408 129.456  1.00 56.47          
ATOM    993  CG1 ILE   143     -46.854  81.252 128.300  1.00 55.69          
ATOM    994  CG2 ILE   143     -47.477  78.950 128.992  1.00 54.86          
ATOM    995  CD  ILE   143     -47.407  80.885 126.971  1.00 56.04          
ATOM    996  N   ASP   144     -50.589  79.477 130.681  1.00 58.48          
ATOM    997  CA  ASP   144     -51.377  78.666 131.595  1.00 58.74          
ATOM    998  C   ASP   144     -51.047  77.219 131.288  1.00 59.75          
ATOM    999  O   ASP   144     -51.443  76.702 130.236  1.00 60.47          
ATOM   1000  CB  ASP   144     -52.886  78.902 131.368  1.00 58.87          
ATOM   1001  CG  ASP   144     -53.512  79.842 132.385  1.00 59.00          
ATOM   1002  OD1 ASP   144     -53.044  79.876 133.545  1.00 60.52          
ATOM   1003  OD2 ASP   144     -54.501  80.531 132.031  1.00 57.39          
ATOM   1004  N   ILE   145     -50.322  76.576 132.200  1.00 60.31          
ATOM   1005  CA  ILE   145     -49.944  75.166 132.080  1.00 60.43          
ATOM   1006  C   ILE   145     -50.761  74.286 133.054  1.00 60.93          
ATOM   1007  O   ILE   145     -51.069  74.715 134.175  1.00 61.93          
ATOM   1008  CB  ILE   145     -48.407  74.969 132.305  1.00 60.88          
ATOM   1009  CG1 ILE   145     -47.846  75.996 133.290  1.00 59.56          
ATOM   1010  CG2 ILE   145     -47.643  75.040 130.930  1.00 61.16          
ATOM   1011  CD  ILE   145     -46.384  75.809 133.636  1.00 59.89          
ATOM   1012  N   GLU   146     -51.122  73.072 132.641  1.00 60.81          
ATOM   1013  CA  GLU   146     -51.909  72.166 133.510  1.00 60.96          
ATOM   1014  C   GLU   146     -51.009  71.194 134.329  1.00 60.57          
ATOM   1015  O   GLU   146     -49.988  70.737 133.827  1.00 60.80          
ATOM   1016  CB  GLU   146     -53.006  71.441 132.716  1.00 61.11          
ATOM   1017  CG  GLU   146     -52.580  70.916 131.336  1.00 62.49          
ATOM   1018  CD  GLU   146     -53.711  70.205 130.578  1.00 63.25          
ATOM   1019  OE1 GLU   146     -53.412  69.211 129.852  1.00 65.14          
ATOM   1020  OE2 GLU   146     -54.889  70.656 130.699  1.00 65.30          
ATOM   1021  N   PRO   147     -51.401  70.865 135.587  1.00 60.04          
ATOM   1022  CA  PRO   147     -50.441  70.366 136.631  1.00 59.24          
ATOM   1023  C   PRO   147     -49.634  69.080 136.336  1.00 58.69          
ATOM   1024  O   PRO   147     -48.431  68.991 136.689  1.00 59.18          
ATOM   1025  CB  PRO   147     -51.328  70.185 137.880  1.00 59.35          
ATOM   1026  CG  PRO   147     -52.592  71.023 137.596  1.00 59.88          
ATOM   1027  CD  PRO   147     -52.788  70.926 136.105  1.00 59.93          
ATOM   1028  N   GLY   148     -50.256  68.095 135.692  1.00 57.37          
ATOM   1029  CA  GLY   148     -49.506  66.911 135.222  1.00 55.91          
ATOM   1030  C   GLY   148     -48.594  67.148 134.010  1.00 54.75          
ATOM   1031  O   GLY   148     -48.077  66.200 133.424  1.00 53.38          
ATOM   1032  N   GLU   149     -48.408  68.407 133.607  1.00 53.32          
ATOM   1033  CA  GLU   149     -47.500  68.703 132.489  1.00 52.60          
ATOM   1034  C   GLU   149     -46.070  68.408 132.907  1.00 49.31          
ATOM   1035  O   GLU   149     -45.677  68.566 134.111  1.00 49.20          
ATOM   1036  CB  GLU   149     -47.660  70.139 131.915  1.00 52.19          
ATOM   1037  CG  GLU   149     -48.786  70.201 130.852  1.00 54.72          
ATOM   1038  CD  GLU   149     -48.742  71.407 129.903  1.00 55.39          
ATOM   1039  OE1 GLU   149     -48.753  72.582 130.353  1.00 58.89          
ATOM   1040  OE2 GLU   149     -48.757  71.155 128.680  1.00 60.76          
ATOM   1041  N   THR   150     -45.321  67.958 131.902  1.00 45.19          
ATOM   1042  CA  THR   150     -43.992  67.565 132.084  1.00 42.07          
ATOM   1043  C   THR   150     -43.217  68.842 131.964  1.00 41.31          
ATOM   1044  O   THR   150     -43.680  69.807 131.390  1.00 39.74          
ATOM   1045  CB  THR   150     -43.559  66.539 130.959  1.00 42.90          
ATOM   1046  OG1 THR   150     -43.569  67.170 129.657  1.00 40.69          
ATOM   1047  CG2 THR   150     -44.472  65.290 130.952  1.00 39.70          
ATOM   1048  N   VAL   151     -42.010  68.854 132.475  1.00 40.18          
ATOM   1049  CA  VAL   151     -41.131  70.005 132.249  1.00 39.70          
ATOM   1050  C   VAL   151     -41.011  70.330 130.727  1.00 38.66          
ATOM   1051  O   VAL   151     -41.045  71.521 130.319  1.00 37.43          
ATOM   1052  CB  VAL   151     -39.750  69.784 132.910  1.00 39.49          
ATOM   1053  CG1 VAL   151     -38.908  71.052 132.844  1.00 40.08          
ATOM   1054  CG2 VAL   151     -39.912  69.333 134.369  1.00 40.15          
ATOM   1055  N   TRP   152     -40.861  69.265 129.917  1.00 37.91          
ATOM   1056  CA  TRP   152     -40.750  69.360 128.466  1.00 36.89          
ATOM   1057  C   TRP   152     -41.972  70.007 127.810  1.00 35.94          
ATOM   1058  O   TRP   152     -41.827  70.971 127.094  1.00 35.39          
ATOM   1059  CB  TRP   152     -40.441  68.006 127.787  1.00 34.74          
ATOM   1060  CG  TRP   152     -39.829  68.290 126.487  1.00 32.36          
ATOM   1061  CD1 TRP   152     -40.449  68.267 125.250  1.00 31.54          
ATOM   1062  CD2 TRP   152     -38.534  68.813 126.272  1.00 32.04          
ATOM   1063  NE1 TRP   152     -39.592  68.724 124.291  1.00 31.01          
ATOM   1064  CE2 TRP   152     -38.401  69.044 124.871  1.00 29.15          
ATOM   1065  CE3 TRP   152     -37.432  69.042 127.108  1.00 29.95          
ATOM   1066  CZ2 TRP   152     -37.226  69.496 124.298  1.00 31.01          
ATOM   1067  CZ3 TRP   152     -36.276  69.504 126.548  1.00 31.50          
ATOM   1068  CH2 TRP   152     -36.158  69.715 125.152  1.00 30.71          
ATOM   1069  N   GLN   153     -43.150  69.464 128.044  1.00 36.92          
ATOM   1070  CA  GLN   153     -44.406  70.094 127.600  1.00 38.21          
ATOM   1071  C   GLN   153     -44.504  71.549 127.954  1.00 38.85          
ATOM   1072  O   GLN   153     -44.873  72.368 127.106  1.00 39.73          
ATOM   1073  CB  GLN   153     -45.597  69.403 128.220  1.00 38.30          
ATOM   1074  CG  GLN   153     -45.938  68.131 127.540  1.00 38.80          
ATOM   1075  CD  GLN   153     -46.993  67.336 128.295  1.00 39.06          
ATOM   1076  OE1 GLN   153     -47.016  67.343 129.521  1.00 41.00          
ATOM   1077  NE2 GLN   153     -47.842  66.611 127.563  1.00 38.45          
ATOM   1078  N   ALA   154     -44.140  71.878 129.197  1.00 38.88          
ATOM   1079  CA  ALA   154     -44.220  73.226 129.675  1.00 38.65          
ATOM   1080  C   ALA   154     -43.212  74.091 128.955  1.00 38.64          
ATOM   1081  O   ALA   154     -43.469  75.255 128.619  1.00 37.52          
ATOM   1082  CB  ALA   154     -43.956  73.277 131.230  1.00 39.17          
ATOM   1083  N   LEU   155     -42.042  73.526 128.732  1.00 37.76          
ATOM   1084  CA  LEU   155     -41.000  74.261 128.085  1.00 38.20          
ATOM   1085  C   LEU   155     -41.363  74.537 126.589  1.00 37.62          
ATOM   1086  O   LEU   155     -41.023  75.599 126.038  1.00 35.67          
ATOM   1087  CB  LEU   155     -39.726  73.433 128.181  1.00 38.96          
ATOM   1088  CG  LEU   155     -38.340  74.005 128.050  1.00 38.74          
ATOM   1089  CD1 LEU   155     -38.154  75.179 128.954  1.00 38.22          
ATOM   1090  CD2 LEU   155     -37.448  72.854 128.455  1.00 38.79          
ATOM   1091  N   THR   156     -42.049  73.579 125.978  1.00 37.91          
ATOM   1092  CA  THR   156     -42.426  73.649 124.570  1.00 39.28          
ATOM   1093  C   THR   156     -43.489  74.754 124.396  1.00 39.91          
ATOM   1094  O   THR   156     -43.328  75.671 123.582  1.00 39.56          
ATOM   1095  CB  THR   156     -42.943  72.275 124.075  1.00 39.40          
ATOM   1096  OG1 THR   156     -41.913  71.276 124.222  1.00 40.32          
ATOM   1097  CG2 THR   156     -43.414  72.344 122.597  1.00 37.44          
ATOM   1098  N   HSD   157     -44.506  74.700 125.253  1.00 41.29          
ATOM   1099  CA  HSD   157     -45.563  75.742 125.389  1.00 40.52          
ATOM   1100  C   HSD   157     -44.960  77.148 125.489  1.00 40.40          
ATOM   1101  O   HSD   157     -45.144  78.009 124.630  1.00 40.47          
ATOM   1102  CB  HSD   157     -46.370  75.403 126.629  1.00 42.29          
ATOM   1103  CG  HSD   157     -47.824  75.773 126.555  1.00 46.21          
ATOM   1104  ND1 HSD   157     -48.795  74.896 126.108  1.00 49.77          
ATOM   1105  CD2 HSD   157     -48.474  76.912 126.900  1.00 46.73          
ATOM   1106  CE1 HSD   157     -49.978  75.493 126.168  1.00 51.70          
ATOM   1107  NE2 HSD   157     -49.812  76.717 126.654  1.00 48.91          
ATOM   1108  N   ILE   158     -44.174  77.364 126.520  1.00 39.54          
ATOM   1109  CA  ILE   158     -43.512  78.617 126.731  1.00 38.46          
ATOM   1110  C   ILE   158     -42.707  79.077 125.507  1.00 37.00          
ATOM   1111  O   ILE   158     -42.830  80.226 125.019  1.00 35.33          
ATOM   1112  CB  ILE   158     -42.575  78.495 127.969  1.00 38.55          
ATOM   1113  CG1 ILE   158     -43.399  78.372 129.259  1.00 39.19          
ATOM   1114  CG2 ILE   158     -41.672  79.670 128.051  1.00 39.72          
ATOM   1115  CD  ILE   158     -42.637  77.673 130.405  1.00 39.44          
ATOM   1116  N   ALA   159     -41.855  78.178 125.038  1.00 35.87          
ATOM   1117  CA  ALA   159     -40.969  78.441 123.908  1.00 36.02          
ATOM   1118  C   ALA   159     -41.790  78.802 122.666  1.00 34.45          
ATOM   1119  O   ALA   159     -41.479  79.781 121.981  1.00 33.92          
ATOM   1120  CB  ALA   159     -40.046  77.145 123.618  1.00 35.86          
ATOM   1121  N   ASN   160     -42.849  78.034 122.438  1.00 34.51          
ATOM   1122  CA  ASN   160     -43.613  78.102 121.219  1.00 35.17          
ATOM   1123  C   ASN   160     -44.446  79.389 121.199  1.00 36.44          
ATOM   1124  O   ASN   160     -44.602  80.017 120.125  1.00 35.86          
ATOM   1125  CB  ASN   160     -44.474  76.837 121.014  1.00 35.63          
ATOM   1126  CG  ASN   160     -43.655  75.604 120.495  1.00 36.13          
ATOM   1127  OD1 ASN   160     -42.459  75.699 120.157  1.00 39.58          
ATOM   1128  ND2 ASN   160     -44.304  74.453 120.455  1.00 33.50          
ATOM   1129  N   SER   161     -44.866  79.845 122.405  1.00 36.15          
ATOM   1130  CA  SER   161     -45.554  81.128 122.601  1.00 35.46          
ATOM   1131  C   SER   161     -44.818  82.297 121.978  1.00 36.28          
ATOM   1132  O   SER   161     -45.426  83.324 121.646  1.00 37.39          
ATOM   1133  CB  SER   161     -45.710  81.447 124.122  1.00 35.38          
ATOM   1134  OG  SER   161     -44.568  82.200 124.583  1.00 32.69          
ATOM   1135  N   VAL   162     -43.504  82.202 121.922  1.00 36.46          
ATOM   1136  CA  VAL   162     -42.673  83.279 121.406  1.00 36.60          
ATOM   1137  C   VAL   162     -42.010  82.827 120.125  1.00 36.85          
ATOM   1138  O   VAL   162     -40.958  83.366 119.759  1.00 38.04          
ATOM   1139  CB  VAL   162     -41.593  83.742 122.399  1.00 36.81          
ATOM   1140  CG1 VAL   162     -42.120  84.930 123.261  1.00 36.35          
ATOM   1141  CG2 VAL   162     -41.109  82.571 123.273  1.00 36.48          
ATOM   1142  N   GLY   163     -42.637  81.866 119.448  1.00 36.83          
ATOM   1143  CA  GLY   163     -42.131  81.340 118.161  1.00 37.06          
ATOM   1144  C   GLY   163     -40.766  80.660 118.283  1.00 37.55          
ATOM   1145  O   GLY   163     -39.929  80.738 117.358  1.00 39.28          
ATOM   1146  N   LEU   164     -40.529  80.019 119.428  1.00 36.30          
ATOM   1147  CA  LEU   164     -39.276  79.301 119.664  1.00 34.93          
ATOM   1148  C   LEU   164     -39.552  77.827 119.978  1.00 33.23          
ATOM   1149  O   LEU   164     -40.697  77.377 119.979  1.00 32.15          
ATOM   1150  CB  LEU   164     -38.430  80.004 120.741  1.00 35.47          
ATOM   1151  CG  LEU   164     -38.075  81.498 120.526  1.00 36.01          
ATOM   1152  CD1 LEU   164     -37.096  82.084 121.621  1.00 32.99          
ATOM   1153  CD2 LEU   164     -37.478  81.714 119.146  1.00 35.69          
ATOM   1154  N   HSD   165     -38.482  77.056 120.178  1.00 32.10          
ATOM   1155  CA  HSD   165     -38.619  75.656 120.526  1.00 31.62          
ATOM   1156  C   HSD   165     -37.429  75.231 121.376  1.00 30.28          
ATOM   1157  O   HSD   165     -36.324  75.719 121.153  1.00 29.79          
ATOM   1158  CB  HSD   165     -38.681  74.807 119.202  1.00 30.88          
ATOM   1159  CG  HSD   165     -39.192  73.426 119.405  1.00 30.41          
ATOM   1160  ND1 HSD   165     -40.535  73.131 119.449  1.00 29.82          
ATOM   1161  CD2 HSD   165     -38.545  72.250 119.587  1.00 31.56          
ATOM   1162  CE1 HSD   165     -40.701  71.845 119.687  1.00 29.33          
ATOM   1163  NE2 HSD   165     -39.505  71.281 119.757  1.00 30.96          
ATOM   1164  N   PRO   166     -37.625  74.280 122.312  1.00 30.00          
ATOM   1165  CA  PRO   166     -36.509  73.764 123.090  1.00 30.28          
ATOM   1166  C   PRO   166     -35.787  72.569 122.455  1.00 30.15          
ATOM   1167  O   PRO   166     -36.433  71.732 121.835  1.00 27.70          
ATOM   1168  CB  PRO   166     -37.182  73.285 124.373  1.00 29.87          
ATOM   1169  CG  PRO   166     -38.484  72.805 123.934  1.00 30.07          
ATOM   1170  CD  PRO   166     -38.887  73.653 122.728  1.00 30.73          
ATOM   1171  N   TRP   167     -34.466  72.493 122.639  1.00 30.72          
ATOM   1172  CA  TRP   167     -33.748  71.235 122.417  1.00 31.72          
ATOM   1173  C   TRP   167     -32.515  71.189 123.247  1.00 32.15          
ATOM   1174  O   TRP   167     -32.037  72.226 123.675  1.00 29.50          
ATOM   1175  CB  TRP   167     -33.379  71.044 120.941  1.00 31.26          
ATOM   1176  CG  TRP   167     -32.440  72.074 120.371  1.00 31.67          
ATOM   1177  CD1 TRP   167     -31.100  71.991 120.304  1.00 31.39          
ATOM   1178  CD2 TRP   167     -32.792  73.329 119.752  1.00 31.95          
ATOM   1179  NE1 TRP   167     -30.578  73.119 119.711  1.00 32.32          
ATOM   1180  CE2 TRP   167     -31.604  73.939 119.349  1.00 29.37          
ATOM   1181  CE3 TRP   167     -34.003  73.982 119.512  1.00 29.78          
ATOM   1182  CZ2 TRP   167     -31.585  75.138 118.684  1.00 32.42          
ATOM   1183  CZ3 TRP   167     -33.997  75.130 118.860  1.00 30.03          
ATOM   1184  CH2 TRP   167     -32.812  75.727 118.453  1.00 31.64          
ATOM   1185  N   LEU   168     -31.985  69.977 123.414  1.00 31.88          
ATOM   1186  CA  LEU   168     -30.630  69.763 123.909  1.00 32.07          
ATOM   1187  C   LEU   168     -29.591  69.720 122.814  1.00 32.16          
ATOM   1188  O   LEU   168     -29.769  69.077 121.778  1.00 31.77          
ATOM   1189  CB  LEU   168     -30.531  68.448 124.728  1.00 33.02          
ATOM   1190  CG  LEU   168     -31.072  68.455 126.145  1.00 32.11          
ATOM   1191  CD1 LEU   168     -30.187  69.333 127.075  1.00 31.71          
ATOM   1192  CD2 LEU   168     -32.495  68.955 126.096  1.00 33.18          
ATOM   1193  N   GLU   169     -28.480  70.392 123.095  1.00 33.09          
ATOM   1194  CA  GLU   169     -27.297  70.352 122.289  1.00 34.11          
ATOM   1195  C   GLU   169     -26.418  69.195 122.690  1.00 32.63          
ATOM   1196  O   GLU   169     -26.570  68.632 123.762  1.00 32.76          
ATOM   1197  CB  GLU   169     -26.506  71.654 122.435  1.00 35.73          
ATOM   1198  CG  GLU   169     -27.307  72.852 122.012  1.00 41.78          
ATOM   1199  CD  GLU   169     -26.585  73.743 121.024  1.00 49.95          
ATOM   1200  OE1 GLU   169     -25.838  74.666 121.452  1.00 53.88          
ATOM   1201  OE2 GLU   169     -26.810  73.547 119.807  1.00 57.45          
ATOM   1202  N   PRO   170     -25.519  68.817 121.810  1.00 31.65          
ATOM   1203  CA  PRO   170     -24.605  67.724 122.055  1.00 32.58          
ATOM   1204  C   PRO   170     -23.891  67.695 123.425  1.00 32.35          
ATOM   1205  O   PRO   170     -23.740  66.614 124.027  1.00 32.03          
ATOM   1206  CB  PRO   170     -23.635  67.841 120.881  1.00 31.62          
ATOM   1207  CG  PRO   170     -24.494  68.300 119.782  1.00 30.98          
ATOM   1208  CD  PRO   170     -25.387  69.323 120.426  1.00 32.12          
ATOM   1209  N   ASP   171     -23.421  68.837 123.894  1.00 32.06          
ATOM   1210  CA  ASP   171     -22.757  68.891 125.194  1.00 32.67          
ATOM   1211  C   ASP   171     -23.691  68.959 126.392  1.00 31.95          
ATOM   1212  O   ASP   171     -23.216  69.175 127.470  1.00 32.48          
ATOM   1213  CB  ASP   171     -21.724  70.048 125.276  1.00 34.02          
ATOM   1214  CG  ASP   171     -22.351  71.432 125.304  1.00 35.15          
ATOM   1215  OD1 ASP   171     -23.597  71.583 125.243  1.00 37.32          
ATOM   1216  OD2 ASP   171     -21.534  72.389 125.320  1.00 43.55          
ATOM   1217  N   GLY   172     -25.004  68.818 126.209  1.00 31.43          
ATOM   1218  CA  GLY   172     -25.924  68.798 127.335  1.00 31.63          
ATOM   1219  C   GLY   172     -26.556  70.158 127.700  1.00 31.89          
ATOM   1220  O   GLY   172     -27.315  70.227 128.662  1.00 30.08          
ATOM   1221  N   THR   173     -26.247  71.214 126.936  1.00 32.65          
ATOM   1222  CA  THR   173     -26.887  72.551 127.114  1.00 33.39          
ATOM   1223  C   THR   173     -28.309  72.510 126.579  1.00 33.70          
ATOM   1224  O   THR   173     -28.561  71.994 125.487  1.00 32.21          
ATOM   1225  CB  THR   173     -26.106  73.635 126.323  1.00 33.52          
ATOM   1226  OG1 THR   173     -24.736  73.609 126.693  1.00 36.35          
ATOM   1227  CG2 THR   173     -26.641  75.020 126.525  1.00 34.69          
ATOM   1228  N   LEU   174     -29.248  73.034 127.373  1.00 33.64          
ATOM   1229  CA  LEU   174     -30.600  73.225 126.936  1.00 34.20          
ATOM   1230  C   LEU   174     -30.659  74.558 126.120  1.00 35.02          
ATOM   1231  O   LEU   174     -30.139  75.597 126.570  1.00 34.35          
ATOM   1232  CB  LEU   174     -31.513  73.252 128.148  1.00 33.97          
ATOM   1233  CG  LEU   174     -32.999  73.531 127.922  1.00 35.80          
ATOM   1234  CD1 LEU   174     -33.683  72.475 127.025  1.00 32.98          
ATOM   1235  CD2 LEU   174     -33.686  73.668 129.299  1.00 33.70          
ATOM   1236  N   VAL   175     -31.250  74.505 124.924  1.00 34.48          
ATOM   1237  CA  VAL   175     -31.397  75.678 124.085  1.00 34.67          
ATOM   1238  C   VAL   175     -32.884  75.926 123.990  1.00 35.50          
ATOM   1239  O   VAL   175     -33.639  74.974 123.968  1.00 35.14          
ATOM   1240  CB  VAL   175     -30.773  75.497 122.729  1.00 33.55          
ATOM   1241  CG1 VAL   175     -31.181  76.628 121.773  1.00 33.55          
ATOM   1242  CG2 VAL   175     -29.270  75.425 122.841  1.00 33.74          
ATOM   1243  N   VAL   176     -33.312  77.197 124.100  1.00 37.14          
ATOM   1244  CA  VAL   176     -34.637  77.626 123.579  1.00 37.35          
ATOM   1245  C   VAL   176     -34.275  78.560 122.464  1.00 37.18          
ATOM   1246  O   VAL   176     -33.380  79.418 122.604  1.00 38.43          
ATOM   1247  CB  VAL   176     -35.612  78.244 124.598  1.00 38.40          
ATOM   1248  CG1 VAL   176     -36.820  78.818 123.876  1.00 40.93          
ATOM   1249  CG2 VAL   176     -36.132  77.184 125.554  1.00 39.70          
ATOM   1250  N   GLY   177     -34.885  78.329 121.311  1.00 36.41          
ATOM   1251  CA  GLY   177     -34.430  78.992 120.109  1.00 36.42          
ATOM   1252  C   GLY   177     -35.118  78.567 118.833  1.00 36.01          
ATOM   1253  O   GLY   177     -36.227  78.056 118.836  1.00 35.78          
END
