
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   78 (  666),  selected   78 , name 2f5k_F
# Molecule2: number of CA atoms   59 (  475),  selected   59 , name T0429_22_99.pdb
# PARAMETERS: 2f5k_F.T0429_22_99.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E      22           -
LGA    -       -      T      23           -
LGA    -       -      E      24           -
LGA    P     9_F      L      25          5.766
LGA    K    10_F      L      27          0.722
LGA    F    11_F      Y      28          0.641
LGA    Q    12_F      K      29          0.585
LGA    E    13_F      V      30          0.673
LGA    G    14_F      N      31          0.504
LGA    E    15_F      E      32          0.293
LGA    R    16_F      Y      33          0.380
LGA    V    17_F      V      34          0.322
LGA    L    18_F      D      35          0.480
LGA    C    19_F      A      36          0.605
LGA    F    20_F      R      37          0.444
LGA    H    21_F      D      38          0.629
LGA    G    22_F      T      39          3.395
LGA    -       -      N      40           -
LGA    -       -      M      41           -
LGA    P    23_F      G      42          1.418
LGA    L    24_F      A      43          0.656
LGA    L    25_F      W      44          0.576
LGA    Y    26_F      F      45          0.431
LGA    E    27_F      E      46          0.397
LGA    A    28_F      A      47          0.239
LGA    K    29_F      Q      48          0.131
LGA    C    30_F      V      49          0.295
LGA    V    31_F      V      50          0.491
LGA    K    32_F      R      51          0.503
LGA    V    33_F      V      52          0.779
LGA    A    34_F      T      53          1.171
LGA    I    35_F      R      54          1.125
LGA    K    36_F      E      73           -
LGA    D    37_F      -       -           -
LGA    K    38_F      -       -           -
LGA    Q    39_F      D      74          2.607
LGA    V    40_F      V      75          1.282
LGA    K    41_F      I      76          0.784
LGA    Y    42_F      Y      77          0.800
LGA    F    43_F      H      78          0.572
LGA    I    44_F      V      79          0.674
LGA    H    45_F      K      80          0.271
LGA    Y    46_F      Y      81          0.853
LGA    S    47_F      D      82          0.550
LGA    G    48_F      D      83          1.093
LGA    W    49_F      Y      84          0.254
LGA    N    50_F      P      85          1.646
LGA    K    51_F      E      86          4.281
LGA    N    52_F      N      87          3.656
LGA    W    53_F      G      88          3.659
LGA    D    54_F      V      89          2.138
LGA    E    55_F      V      90          0.854
LGA    W    56_F      Q      91          0.854
LGA    V    57_F      M      92          0.945
LGA    P    58_F      N      93          1.367
LGA    E    59_F      S      94          0.434
LGA    S    60_F      R      95          0.627
LGA    R    61_F      D      96          0.397
LGA    V    62_F      V      97          0.240
LGA    L    63_F      R      98          0.690
LGA    K    64_F      A      99          0.748
LGA    Y    65_F      -       -           -
LGA    V    66_F      -       -           -
LGA    D    67_F      -       -           -
LGA    T    68_F      -       -           -
LGA    N    69_F      -       -           -
LGA    L    70_F      -       -           -
LGA    Q    71_F      -       -           -
LGA    K    72_F      -       -           -
LGA    Q    73_F      -       -           -
LGA    R    74_F      -       -           -
LGA    E    75_F      -       -           -
LGA    L    76_F      -       -           -
LGA    Q    77_F      -       -           -
LGA    K    78_F      -       -           -
LGA    A    79_F      -       -           -
LGA    N    80_F      -       -           -
LGA    Q    81_F      -       -           -
LGA    E    82_F      -       -           -
LGA    Q    83_F      -       -           -
LGA    Y    84_F      -       -           -
LGA    A    85_F      -       -           -
LGA    E    86_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   78   59    5.0     53    1.55    20.75     86.062     3.221

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.635488 * X  +  -0.730740 * Y  +   0.249348 * Z  +  15.456467
  Y_new =  -0.767919 * X  +  -0.564568 * Y  +   0.302595 * Z  + -24.151834
  Z_new =  -0.080345 * X  +  -0.383774 * Y  +  -0.919925 * Z  +  29.108614 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.746364    0.395229  [ DEG:  -157.3551     22.6449 ]
  Theta =   0.080432    3.061161  [ DEG:     4.6084    175.3916 ]
  Phi   =  -0.879483    2.262109  [ DEG:   -50.3907    129.6093 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f5k_F                                        
REMARK     2: T0429_22_99.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f5k_F.T0429_22_99.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   78   59   5.0   53   1.55   20.75  86.062
REMARK  ---------------------------------------------------------- 
MOLECULE 2f5k_F
HEADER    GENE REGULATION                         26-NOV-05   2F5K              
TITLE     CRYSTAL STRUCTURE OF THE CHROMO DOMAIN OF HUMAN MRG15                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MORF-RELATED GENE 15 ISOFORM 1;                            
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: CHROMO DOMAIN;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-3E-HIS                                
KEYWDS    BETA BARREL, GENE REGULATION                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.ZHANG,J.DU,J.DING                                                   
REVDAT   2   25-DEC-07 2F5K    1       JRNL                                     
REVDAT   1   14-NOV-06 2F5K    0                                                
JRNL        AUTH   P.ZHANG,J.DU,B.SUN,X.DONG,G.XU,J.ZHOU,Q.HUANG,               
JRNL        AUTH 2 Q.LIU,Q.HAO,J.DING                                           
JRNL        TITL   STRUCTURE OF HUMAN MRG15 CHROMO DOMAIN AND ITS               
JRNL        TITL 2 BINDING TO LYS36-METHYLATED HISTONE H3.                      
JRNL        REF    NUCLEIC ACIDS RES.            V.  34  6621 2006              
JRNL        REFN   ASTM NARHAD  UK ISSN 0305-1048                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2F5K A    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K B    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K C    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K D    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K E    1    90  GB     5803102  NP_006782        1     90             
DBREF  2F5K F    1    90  GB     5803102  NP_006782        1     90             
SEQRES   1 A  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 A  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 A  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 A  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 A  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 A  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 A  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 A  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 B  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 B  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 B  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 B  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 B  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 B  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 B  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 B  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 C  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 C  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 C  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 C  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 C  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 C  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 C  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 C  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 D  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 D  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 D  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 D  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 D  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 D  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 D  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 D  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 E  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 E  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 E  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 E  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 E  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 E  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 E  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 E  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
SEQRES   1 F  102  MET HIS HIS HIS HIS HIS HIS ALA MET GLY ILE LEU MET          
SEQRES   2 F  102  ALA PRO LYS GLN ASP PRO LYS PRO LYS PHE GLN GLU GLY          
SEQRES   3 F  102  GLU ARG VAL LEU CYS PHE HIS GLY PRO LEU LEU TYR GLU          
SEQRES   4 F  102  ALA LYS CYS VAL LYS VAL ALA ILE LYS ASP LYS GLN VAL          
SEQRES   5 F  102  LYS TYR PHE ILE HIS TYR SER GLY TRP ASN LYS ASN TRP          
SEQRES   6 F  102  ASP GLU TRP VAL PRO GLU SER ARG VAL LEU LYS TYR VAL          
SEQRES   7 F  102  ASP THR ASN LEU GLN LYS GLN ARG GLU LEU GLN LYS ALA          
SEQRES   8 F  102  ASN GLN GLU GLN TYR ALA GLU GLY LYS MET ARG                  
FORMUL   7  HOH   *457(H2 O)                                                    
CRYST1  109.480   80.313   81.285  90.00 123.91  90.00 C 1 2 1      24          
ATOM   3454  N   PRO F   9      22.559  -5.084  22.091  1.00 58.70           N  
ATOM   3455  CA  PRO F   9      23.162  -5.129  20.725  1.00 57.96           C  
ATOM   3456  C   PRO F   9      23.917  -6.429  20.542  1.00 56.94           C  
ATOM   3457  O   PRO F   9      24.502  -6.928  21.490  1.00 56.33           O  
ATOM   3458  CB  PRO F   9      24.144  -3.954  20.762  1.00 58.28           C  
ATOM   3459  CG  PRO F   9      24.457  -3.811  22.225  1.00 58.63           C  
ATOM   3460  CD  PRO F   9      23.105  -3.957  22.875  1.00 59.03           C  
ATOM   3461  N   LYS F  10      23.927  -6.967  19.335  1.00 56.83           N  
ATOM   3462  CA  LYS F  10      24.635  -8.225  19.106  1.00 56.42           C  
ATOM   3463  C   LYS F  10      26.150  -8.047  19.162  1.00 55.69           C  
ATOM   3464  O   LYS F  10      26.889  -8.956  19.528  1.00 55.51           O  
ATOM   3465  CB  LYS F  10      24.221  -8.859  17.780  1.00 56.72           C  
ATOM   3466  CG  LYS F  10      24.864 -10.233  17.562  1.00 58.46           C  
ATOM   3467  CD  LYS F  10      24.601 -10.832  16.192  1.00 60.47           C  
ATOM   3468  CE  LYS F  10      23.166 -10.671  15.770  1.00 62.13           C  
ATOM   3469  NZ  LYS F  10      22.922 -11.538  14.583  1.00 63.74           N  
ATOM   3470  N   PHE F  11      26.626  -6.866  18.800  1.00 55.18           N  
ATOM   3471  CA  PHE F  11      28.066  -6.631  18.812  1.00 54.50           C  
ATOM   3472  C   PHE F  11      28.403  -5.460  19.728  1.00 55.31           C  
ATOM   3473  O   PHE F  11      27.551  -4.602  19.950  1.00 55.54           O  
ATOM   3474  CB  PHE F  11      28.544  -6.361  17.385  1.00 53.33           C  
ATOM   3475  CG  PHE F  11      28.236  -7.462  16.435  1.00 48.49           C  
ATOM   3476  CD1 PHE F  11      27.188  -7.367  15.567  1.00 46.63           C  
ATOM   3477  CD2 PHE F  11      28.999  -8.593  16.411  1.00 45.59           C  
ATOM   3478  CE1 PHE F  11      26.916  -8.400  14.681  1.00 44.67           C  
ATOM   3479  CE2 PHE F  11      28.746  -9.606  15.520  1.00 43.30           C  
ATOM   3480  CZ  PHE F  11      27.696  -9.511  14.666  1.00 42.79           C  
ATOM   3481  N   GLN F  12      29.625  -5.430  20.259  1.00 56.05           N  
ATOM   3482  CA  GLN F  12      30.051  -4.357  21.166  1.00 57.15           C  
ATOM   3483  C   GLN F  12      31.339  -3.629  20.743  1.00 56.92           C  
ATOM   3484  O   GLN F  12      32.207  -4.188  20.075  1.00 57.00           O  
ATOM   3485  CB  GLN F  12      30.226  -4.878  22.577  1.00 57.68           C  
ATOM   3486  CG  GLN F  12      31.380  -5.819  22.730  1.00 60.28           C  
ATOM   3487  CD  GLN F  12      31.455  -6.377  24.133  1.00 64.24           C  
ATOM   3488  OE1 GLN F  12      31.138  -5.675  25.095  1.00 66.35           O  
ATOM   3489  NE2 GLN F  12      31.874  -7.632  24.261  1.00 65.35           N  
ATOM   3490  N   GLU F  13      31.447  -2.366  21.153  1.00 56.61           N  
ATOM   3491  CA  GLU F  13      32.579  -1.521  20.788  1.00 55.74           C  
ATOM   3492  C   GLU F  13      33.912  -2.221  20.994  1.00 54.52           C  
ATOM   3493  O   GLU F  13      34.113  -2.934  21.974  1.00 54.58           O  
ATOM   3494  CB  GLU F  13      32.533  -0.206  21.559  1.00 56.42           C  
ATOM   3495  CG  GLU F  13      31.310   0.646  21.227  1.00 58.48           C  
ATOM   3496  CD  GLU F  13      31.519   2.117  21.549  1.00 61.37           C  
ATOM   3497  OE1 GLU F  13      32.276   2.405  22.503  1.00 63.19           O  
ATOM   3498  OE2 GLU F  13      30.928   2.989  20.866  1.00 62.17           O  
ATOM   3499  N   GLY F  14      34.814  -2.043  20.044  1.00 52.98           N  
ATOM   3500  CA  GLY F  14      36.118  -2.660  20.151  1.00 51.11           C  
ATOM   3501  C   GLY F  14      36.135  -4.098  19.707  1.00 49.69           C  
ATOM   3502  O   GLY F  14      37.189  -4.698  19.635  1.00 50.09           O  
ATOM   3503  N   GLU F  15      34.968  -4.657  19.399  1.00 48.37           N  
ATOM   3504  CA  GLU F  15      34.875  -6.070  19.012  1.00 46.85           C  
ATOM   3505  C   GLU F  15      35.424  -6.344  17.612  1.00 45.13           C  
ATOM   3506  O   GLU F  15      35.052  -5.671  16.683  1.00 44.84           O  
ATOM   3507  CB  GLU F  15      33.400  -6.527  19.071  1.00 46.92           C  
ATOM   3508  CG  GLU F  15      33.219  -8.042  19.055  1.00 46.23           C  
ATOM   3509  CD  GLU F  15      31.773  -8.473  19.043  1.00 44.76           C  
ATOM   3510  OE1 GLU F  15      30.891  -7.668  19.408  1.00 45.90           O  
ATOM   3511  OE2 GLU F  15      31.514  -9.617  18.639  1.00 43.44           O  
ATOM   3512  N   ARG F  16      36.339  -7.288  17.471  1.00 44.12           N  
ATOM   3513  CA  ARG F  16      36.801  -7.674  16.144  1.00 43.84           C  
ATOM   3514  C   ARG F  16      35.635  -8.420  15.508  1.00 43.27           C  
ATOM   3515  O   ARG F  16      35.112  -9.373  16.078  1.00 42.65           O  
ATOM   3516  CB  ARG F  16      38.005  -8.605  16.185  1.00 43.79           C  
ATOM   3517  CG  ARG F  16      38.340  -9.192  14.841  1.00 45.39           C  
ATOM   3518  CD  ARG F  16      39.747  -9.733  14.720  1.00 49.16           C  
ATOM   3519  NE  ARG F  16      40.003 -10.796  15.687  1.00 53.67           N  
ATOM   3520  CZ  ARG F  16      40.995 -11.670  15.570  1.00 56.30           C  
ATOM   3521  NH1 ARG F  16      41.803 -11.585  14.519  1.00 57.73           N  
ATOM   3522  NH2 ARG F  16      41.173 -12.633  16.476  1.00 57.17           N  
ATOM   3523  N   VAL F  17      35.268  -8.002  14.314  1.00 42.41           N  
ATOM   3524  CA  VAL F  17      34.106  -8.530  13.659  1.00 41.96           C  
ATOM   3525  C   VAL F  17      34.418  -8.894  12.195  1.00 41.81           C  
ATOM   3526  O   VAL F  17      35.514  -8.617  11.705  1.00 42.33           O  
ATOM   3527  CB  VAL F  17      33.051  -7.419  13.707  1.00 42.13           C  
ATOM   3528  CG1 VAL F  17      32.455  -7.156  12.350  1.00 42.45           C  
ATOM   3529  CG2 VAL F  17      32.034  -7.610  14.881  1.00 40.99           C  
ATOM   3530  N   LEU F  18      33.470  -9.538  11.512  1.00 40.16           N  
ATOM   3531  CA  LEU F  18      33.612  -9.799  10.097  1.00 39.07           C  
ATOM   3532  C   LEU F  18      32.514  -8.994   9.505  1.00 38.85           C  
ATOM   3533  O   LEU F  18      31.412  -8.991  10.048  1.00 38.38           O  
ATOM   3534  CB  LEU F  18      33.409 -11.254   9.768  1.00 38.80           C  
ATOM   3535  CG  LEU F  18      34.618 -12.174   9.945  1.00 38.68           C  
ATOM   3536  CD1 LEU F  18      34.205 -13.642   9.717  1.00 37.25           C  
ATOM   3537  CD2 LEU F  18      35.736 -11.759   8.991  1.00 37.28           C  
ATOM   3538  N   CYS F  19      32.795  -8.258   8.429  1.00 37.81           N  
ATOM   3539  CA  CYS F  19      31.749  -7.429   7.854  1.00 37.31           C  
ATOM   3540  C   CYS F  19      31.649  -7.596   6.368  1.00 37.12           C  
ATOM   3541  O   CYS F  19      32.669  -7.719   5.688  1.00 37.61           O  
ATOM   3542  CB  CYS F  19      31.965  -5.964   8.217  1.00 37.28           C  
ATOM   3543  SG  CYS F  19      30.605  -4.919   7.705  1.00 36.38           S  
ATOM   3544  N   PHE F  20      30.416  -7.650   5.871  1.00 36.56           N  
ATOM   3545  CA  PHE F  20      30.140  -7.832   4.455  1.00 35.96           C  
ATOM   3546  C   PHE F  20      30.381  -6.539   3.694  1.00 36.09           C  
ATOM   3547  O   PHE F  20      30.017  -5.434   4.146  1.00 34.85           O  
ATOM   3548  CB  PHE F  20      28.674  -8.241   4.222  1.00 36.14           C  
ATOM   3549  CG  PHE F  20      28.396  -9.712   4.426  1.00 37.32           C  
ATOM   3550  CD1 PHE F  20      27.819 -10.161   5.586  1.00 37.61           C  
ATOM   3551  CD2 PHE F  20      28.705 -10.634   3.441  1.00 38.31           C  
ATOM   3552  CE1 PHE F  20      27.555 -11.504   5.746  1.00 38.75           C  
ATOM   3553  CE2 PHE F  20      28.446 -11.969   3.621  1.00 37.47           C  
ATOM   3554  CZ  PHE F  20      27.895 -12.400   4.766  1.00 37.68           C  
ATOM   3555  N   HIS F  21      30.944  -6.680   2.506  1.00 36.37           N  
ATOM   3556  CA  HIS F  21      31.124  -5.521   1.651  1.00 37.41           C  
ATOM   3557  C   HIS F  21      30.956  -6.036   0.250  1.00 37.17           C  
ATOM   3558  O   HIS F  21      31.798  -6.779  -0.253  1.00 36.88           O  
ATOM   3559  CB  HIS F  21      32.467  -4.851   1.866  1.00 37.94           C  
ATOM   3560  CG  HIS F  21      32.465  -3.415   1.459  1.00 41.13           C  
ATOM   3561  ND1 HIS F  21      32.694  -3.015   0.159  1.00 42.75           N  
ATOM   3562  CD2 HIS F  21      32.217  -2.287   2.168  1.00 42.90           C  
ATOM   3563  CE1 HIS F  21      32.610  -1.698   0.094  1.00 43.84           C  
ATOM   3564  NE2 HIS F  21      32.319  -1.235   1.297  1.00 44.36           N  
ATOM   3565  N   GLY F  22      29.850  -5.690  -0.385  1.00 36.60           N  
ATOM   3566  CA  GLY F  22      29.590  -6.352  -1.638  1.00 37.41           C  
ATOM   3567  C   GLY F  22      29.391  -7.843  -1.313  1.00 37.33           C  
ATOM   3568  O   GLY F  22      28.739  -8.201  -0.325  1.00 38.39           O  
ATOM   3569  N   PRO F  23      29.930  -8.708  -2.144  1.00 36.14           N  
ATOM   3570  CA  PRO F  23      29.783 -10.144  -1.953  1.00 35.83           C  
ATOM   3571  C   PRO F  23      30.902 -10.812  -1.155  1.00 35.06           C  
ATOM   3572  O   PRO F  23      31.061 -12.024  -1.237  1.00 34.22           O  
ATOM   3573  CB  PRO F  23      29.782 -10.654  -3.396  1.00 35.57           C  
ATOM   3574  CG  PRO F  23      30.913  -9.789  -4.025  1.00 36.36           C  
ATOM   3575  CD  PRO F  23      30.683  -8.386  -3.372  1.00 36.39           C  
ATOM   3576  N   LEU F  24      31.626 -10.054  -0.345  1.00 34.82           N  
ATOM   3577  CA  LEU F  24      32.764 -10.645   0.371  1.00 34.62           C  
ATOM   3578  C   LEU F  24      32.771 -10.269   1.845  1.00 34.61           C  
ATOM   3579  O   LEU F  24      32.181  -9.273   2.241  1.00 34.08           O  
ATOM   3580  CB  LEU F  24      34.093 -10.223  -0.288  1.00 33.90           C  
ATOM   3581  CG  LEU F  24      34.352 -10.663  -1.746  1.00 34.58           C  
ATOM   3582  CD1 LEU F  24      35.571  -9.917  -2.416  1.00 34.91           C  
ATOM   3583  CD2 LEU F  24      34.482 -12.170  -1.888  1.00 33.70           C  
ATOM   3584  N   LEU F  25      33.457 -11.058   2.659  1.00 35.58           N  
ATOM   3585  CA  LEU F  25      33.523 -10.784   4.099  1.00 35.83           C  
ATOM   3586  C   LEU F  25      34.878 -10.254   4.511  1.00 35.58           C  
ATOM   3587  O   LEU F  25      35.890 -10.881   4.220  1.00 34.49           O  
ATOM   3588  CB  LEU F  25      33.219 -12.063   4.882  1.00 35.01           C  
ATOM   3589  CG  LEU F  25      31.730 -12.324   5.150  1.00 36.83           C  
ATOM   3590  CD1 LEU F  25      31.524 -13.782   5.648  1.00 35.42           C  
ATOM   3591  CD2 LEU F  25      31.174 -11.326   6.134  1.00 36.27           C  
ATOM   3592  N   TYR F  26      34.901  -9.130   5.227  1.00 36.85           N  
ATOM   3593  CA  TYR F  26      36.172  -8.542   5.637  1.00 38.40           C  
ATOM   3594  C   TYR F  26      36.317  -8.404   7.139  1.00 38.45           C  
ATOM   3595  O   TYR F  26      35.374  -8.021   7.837  1.00 36.45           O  
ATOM   3596  CB  TYR F  26      36.396  -7.165   5.003  1.00 38.94           C  
ATOM   3597  CG  TYR F  26      36.534  -7.203   3.494  1.00 42.57           C  
ATOM   3598  CD1 TYR F  26      35.427  -7.005   2.677  1.00 44.66           C  
ATOM   3599  CD2 TYR F  26      37.780  -7.426   2.879  1.00 44.92           C  
ATOM   3600  CE1 TYR F  26      35.543  -7.012   1.290  1.00 46.13           C  
ATOM   3601  CE2 TYR F  26      37.905  -7.446   1.473  1.00 45.91           C  
ATOM   3602  CZ  TYR F  26      36.771  -7.228   0.694  1.00 46.56           C  
ATOM   3603  OH  TYR F  26      36.841  -7.259  -0.680  1.00 46.99           O  
ATOM   3604  N   GLU F  27      37.520  -8.728   7.622  1.00 39.48           N  
ATOM   3605  CA  GLU F  27      37.854  -8.498   9.025  1.00 40.51           C  
ATOM   3606  C   GLU F  27      37.633  -7.019   9.267  1.00 41.32           C  
ATOM   3607  O   GLU F  27      37.889  -6.195   8.413  1.00 40.39           O  
ATOM   3608  CB  GLU F  27      39.285  -8.941   9.389  1.00 40.17           C  
ATOM   3609  CG  GLU F  27      39.618  -8.736  10.865  1.00 40.28           C  
ATOM   3610  CD  GLU F  27      41.068  -9.026  11.219  1.00 41.78           C  
ATOM   3611  OE1 GLU F  27      41.736  -9.821  10.535  1.00 42.31           O  
ATOM   3612  OE2 GLU F  27      41.556  -8.436  12.203  1.00 43.94           O  
ATOM   3613  N   ALA F  28      37.069  -6.691  10.414  1.00 43.48           N  
ATOM   3614  CA  ALA F  28      36.749  -5.315  10.689  1.00 45.66           C  
ATOM   3615  C   ALA F  28      36.599  -5.132  12.183  1.00 47.37           C  
ATOM   3616  O   ALA F  28      36.833  -6.065  12.941  1.00 47.74           O  
ATOM   3617  CB  ALA F  28      35.486  -4.913   9.960  1.00 45.18           C  
ATOM   3618  N   LYS F  29      36.219  -3.925  12.590  1.00 49.47           N  
ATOM   3619  CA  LYS F  29      36.113  -3.576  13.985  1.00 52.11           C  
ATOM   3620  C   LYS F  29      34.873  -2.751  14.170  1.00 53.72           C  
ATOM   3621  O   LYS F  29      34.554  -1.888  13.359  1.00 53.20           O  
ATOM   3622  CB  LYS F  29      37.341  -2.775  14.465  1.00 52.59           C  
ATOM   3623  CG  LYS F  29      38.379  -3.577  15.270  1.00 53.78           C  
ATOM   3624  CD  LYS F  29      39.055  -4.652  14.399  1.00 55.34           C  
ATOM   3625  CE  LYS F  29      40.178  -5.380  15.124  1.00 55.54           C  
ATOM   3626  NZ  LYS F  29      40.621  -6.588  14.353  1.00 55.62           N  
ATOM   3627  N   CYS F  30      34.161  -3.038  15.244  1.00 56.29           N  
ATOM   3628  CA  CYS F  30      32.978  -2.285  15.576  1.00 59.35           C  
ATOM   3629  C   CYS F  30      33.360  -1.122  16.478  1.00 61.68           C  
ATOM   3630  O   CYS F  30      33.484  -1.299  17.685  1.00 62.28           O  
ATOM   3631  CB  CYS F  30      32.001  -3.179  16.315  1.00 59.10           C  
ATOM   3632  SG  CYS F  30      30.453  -2.335  16.578  1.00 60.45           S  
ATOM   3633  N   VAL F  31      33.522   0.067  15.909  1.00 64.43           N  
ATOM   3634  CA  VAL F  31      33.992   1.200  16.703  1.00 67.35           C  
ATOM   3635  C   VAL F  31      32.911   1.849  17.548  1.00 69.71           C  
ATOM   3636  O   VAL F  31      33.127   2.122  18.721  1.00 69.52           O  
ATOM   3637  CB  VAL F  31      34.713   2.248  15.843  1.00 67.21           C  
ATOM   3638  CG1 VAL F  31      35.042   3.491  16.669  1.00 67.25           C  
ATOM   3639  CG2 VAL F  31      35.980   1.649  15.244  1.00 66.99           C  
ATOM   3640  N   LYS F  32      31.746   2.089  16.963  1.00 73.12           N  
ATOM   3641  CA  LYS F  32      30.674   2.729  17.712  1.00 76.78           C  
ATOM   3642  C   LYS F  32      29.268   2.192  17.444  1.00 79.36           C  
ATOM   3643  O   LYS F  32      28.852   2.043  16.298  1.00 79.57           O  
ATOM   3644  CB  LYS F  32      30.723   4.237  17.495  1.00 76.98           C  
ATOM   3645  CG  LYS F  32      31.991   4.870  18.044  1.00 77.88           C  
ATOM   3646  CD  LYS F  32      32.006   6.387  17.869  1.00 79.87           C  
ATOM   3647  CE  LYS F  32      33.301   6.999  18.421  1.00 80.90           C  
ATOM   3648  NZ  LYS F  32      33.298   8.498  18.346  1.00 82.14           N  
ATOM   3649  N   VAL F  33      28.531   1.927  18.518  1.00 82.53           N  
ATOM   3650  CA  VAL F  33      27.170   1.409  18.409  1.00 85.66           C  
ATOM   3651  C   VAL F  33      26.090   2.459  18.622  1.00 88.18           C  
ATOM   3652  O   VAL F  33      25.884   2.936  19.736  1.00 88.30           O  
ATOM   3653  CB  VAL F  33      26.909   0.306  19.443  1.00 85.48           C  
ATOM   3654  CG1 VAL F  33      25.540  -0.313  19.221  1.00 85.14           C  
ATOM   3655  CG2 VAL F  33      27.992  -0.729  19.384  1.00 85.50           C  
ATOM   3656  N   ALA F  34      25.382   2.795  17.553  1.00 91.38           N  
ATOM   3657  CA  ALA F  34      24.281   3.739  17.646  1.00 94.71           C  
ATOM   3658  C   ALA F  34      22.992   2.979  17.377  1.00 97.26           C  
ATOM   3659  O   ALA F  34      22.901   2.220  16.412  1.00 97.50           O  
ATOM   3660  CB  ALA F  34      24.455   4.876  16.651  1.00 94.64           C  
ATOM   3661  N   ILE F  35      21.998   3.174  18.234  1.00100.32           N  
ATOM   3662  CA  ILE F  35      20.736   2.456  18.092  1.00103.30           C  
ATOM   3663  C   ILE F  35      19.655   3.344  17.481  1.00105.04           C  
ATOM   3664  O   ILE F  35      18.856   3.982  18.166  1.00105.20           O  
ATOM   3665  CB  ILE F  35      20.332   1.813  19.421  1.00103.63           C  
ATOM   3666  CG1 ILE F  35      21.443   0.842  19.849  1.00104.42           C  
ATOM   3667  CG2 ILE F  35      18.995   1.096  19.280  1.00104.03           C  
ATOM   3668  CD1 ILE F  35      21.270   0.234  21.227  1.00105.25           C  
ATOM   3669  N   LYS F  36      19.651   3.310  16.154  1.00107.08           N  
ATOM   3670  CA  LYS F  36      18.901   4.203  15.285  1.00108.95           C  
ATOM   3671  C   LYS F  36      17.643   3.599  14.635  1.00109.64           C  
ATOM   3672  O   LYS F  36      17.639   2.455  14.167  1.00109.87           O  
ATOM   3673  CB  LYS F  36      19.915   4.682  14.236  1.00109.51           C  
ATOM   3674  CG  LYS F  36      19.435   5.313  12.955  1.00111.29           C  
ATOM   3675  CD  LYS F  36      20.662   5.420  12.037  1.00113.76           C  
ATOM   3676  CE  LYS F  36      20.381   6.075  10.692  1.00115.13           C  
ATOM   3677  NZ  LYS F  36      21.541   5.899   9.757  1.00115.79           N  
ATOM   3678  N   ASP F  37      16.568   4.383  14.644  1.00110.24           N  
ATOM   3679  CA  ASP F  37      15.304   4.014  14.009  1.00110.60           C  
ATOM   3680  C   ASP F  37      14.740   2.647  14.396  1.00110.06           C  
ATOM   3681  O   ASP F  37      14.232   1.924  13.540  1.00110.30           O  
ATOM   3682  CB  ASP F  37      15.444   4.094  12.489  1.00111.26           C  
ATOM   3683  CG  ASP F  37      16.087   5.384  12.034  1.00112.92           C  
ATOM   3684  OD1 ASP F  37      15.909   6.417  12.724  1.00114.24           O  
ATOM   3685  OD2 ASP F  37      16.792   5.459  11.002  1.00113.98           O  
ATOM   3686  N   LYS F  38      14.824   2.298  15.676  1.00109.14           N  
ATOM   3687  CA  LYS F  38      14.272   1.036  16.179  1.00108.11           C  
ATOM   3688  C   LYS F  38      15.158  -0.178  15.923  1.00106.33           C  
ATOM   3689  O   LYS F  38      14.791  -1.301  16.261  1.00106.53           O  
ATOM   3690  CB  LYS F  38      12.882   0.774  15.603  1.00108.89           C  
ATOM   3691  CG  LYS F  38      11.842   1.808  15.984  1.00110.83           C  
ATOM   3692  CD  LYS F  38      10.468   1.406  15.463  1.00113.40           C  
ATOM   3693  CE  LYS F  38       9.406   2.422  15.862  1.00114.81           C  
ATOM   3694  NZ  LYS F  38       8.040   2.013  15.426  1.00115.52           N  
ATOM   3695  N   GLN F  39      16.309   0.043  15.303  1.00103.87           N  
ATOM   3696  CA  GLN F  39      17.258  -1.036  15.055  1.00101.15           C  
ATOM   3697  C   GLN F  39      18.630  -0.607  15.579  1.00 97.90           C  
ATOM   3698  O   GLN F  39      18.824   0.549  15.953  1.00 97.90           O  
ATOM   3699  CB  GLN F  39      17.319  -1.370  13.565  1.00101.96           C  
ATOM   3700  CG  GLN F  39      15.985  -1.809  12.972  1.00104.22           C  
ATOM   3701  CD  GLN F  39      16.073  -2.087  11.481  1.00106.97           C  
ATOM   3702  OE1 GLN F  39      17.140  -1.940  10.881  1.00108.19           O  
ATOM   3703  NE2 GLN F  39      14.956  -2.487  10.880  1.00107.80           N  
ATOM   3704  N   VAL F  40      19.574  -1.531  15.648  1.00 93.58           N  
ATOM   3705  CA  VAL F  40      20.901  -1.148  16.083  1.00 89.22           C  
ATOM   3706  C   VAL F  40      21.737  -1.011  14.847  1.00 85.68           C  
ATOM   3707  O   VAL F  40      21.583  -1.775  13.899  1.00 85.53           O  
ATOM   3708  CB  VAL F  40      21.551  -2.187  16.998  1.00 89.37           C  
ATOM   3709  CG1 VAL F  40      22.973  -1.796  17.284  1.00 89.09           C  
ATOM   3710  CG2 VAL F  40      20.779  -2.309  18.290  1.00 89.74           C  
ATOM   3711  N   LYS F  41      22.598  -0.009  14.838  1.00 81.31           N  
ATOM   3712  CA  LYS F  41      23.526   0.166  13.739  1.00 76.79           C  
ATOM   3713  C   LYS F  41      24.920   0.227  14.309  1.00 73.33           C  
ATOM   3714  O   LYS F  41      25.103   0.547  15.484  1.00 72.75           O  
ATOM   3715  CB  LYS F  41      23.221   1.421  12.936  1.00 76.93           C  
ATOM   3716  CG  LYS F  41      22.144   1.239  11.883  1.00 76.68           C  
ATOM   3717  CD  LYS F  41      22.110   2.420  10.933  1.00 76.49           C  
ATOM   3718  CE  LYS F  41      21.090   2.218   9.818  1.00 76.66           C  
ATOM   3719  NZ  LYS F  41      21.517   1.207   8.809  1.00 76.27           N  
ATOM   3720  N   TYR F  42      25.899  -0.102  13.475  1.00 69.13           N  
ATOM   3721  CA  TYR F  42      27.284  -0.126  13.896  1.00 65.03           C  
ATOM   3722  C   TYR F  42      28.160   0.684  12.926  1.00 62.78           C  
ATOM   3723  O   TYR F  42      27.955   0.666  11.702  1.00 62.17           O  
ATOM   3724  CB  TYR F  42      27.774  -1.576  13.991  1.00 64.51           C  
ATOM   3725  CG  TYR F  42      26.847  -2.516  14.752  1.00 62.96           C  
ATOM   3726  CD1 TYR F  42      25.657  -2.966  14.188  1.00 61.90           C  
ATOM   3727  CD2 TYR F  42      27.160  -2.951  16.029  1.00 61.61           C  
ATOM   3728  CE1 TYR F  42      24.812  -3.804  14.883  1.00 60.28           C  
ATOM   3729  CE2 TYR F  42      26.317  -3.787  16.732  1.00 60.30           C  
ATOM   3730  CZ  TYR F  42      25.148  -4.210  16.154  1.00 59.46           C  
ATOM   3731  OH  TYR F  42      24.313  -5.050  16.846  1.00 58.47           O  
ATOM   3732  N   PHE F  43      29.119   1.423  13.472  1.00 59.84           N  
ATOM   3733  CA  PHE F  43      30.081   2.125  12.631  1.00 57.14           C  
ATOM   3734  C   PHE F  43      31.260   1.174  12.474  1.00 54.69           C  
ATOM   3735  O   PHE F  43      31.838   0.717  13.453  1.00 53.84           O  
ATOM   3736  CB  PHE F  43      30.483   3.477  13.242  1.00 57.45           C  
ATOM   3737  CG  PHE F  43      31.207   4.387  12.281  1.00 57.32           C  
ATOM   3738  CD1 PHE F  43      30.584   4.839  11.131  1.00 58.21           C  
ATOM   3739  CD2 PHE F  43      32.514   4.768  12.522  1.00 57.23           C  
ATOM   3740  CE1 PHE F  43      31.251   5.661  10.246  1.00 58.40           C  
ATOM   3741  CE2 PHE F  43      33.186   5.588  11.646  1.00 57.53           C  
ATOM   3742  CZ  PHE F  43      32.550   6.041  10.507  1.00 58.15           C  
ATOM   3743  N   ILE F  44      31.585   0.826  11.240  1.00 52.61           N  
ATOM   3744  CA  ILE F  44      32.615  -0.189  11.020  1.00 51.23           C  
ATOM   3745  C   ILE F  44      33.907   0.405  10.455  1.00 50.86           C  
ATOM   3746  O   ILE F  44      33.867   1.297   9.629  1.00 50.34           O  
ATOM   3747  CB  ILE F  44      32.061  -1.300  10.074  1.00 50.68           C  
ATOM   3748  CG1 ILE F  44      30.914  -2.067  10.750  1.00 49.81           C  
ATOM   3749  CG2 ILE F  44      33.166  -2.231   9.571  1.00 48.50           C  
ATOM   3750  CD1 ILE F  44      31.323  -2.902  11.915  1.00 48.43           C  
ATOM   3751  N   HIS F  45      35.049  -0.115  10.871  1.00 51.05           N  
ATOM   3752  CA  HIS F  45      36.287   0.414  10.340  1.00 52.07           C  
ATOM   3753  C   HIS F  45      36.977  -0.355   9.211  1.00 52.45           C  
ATOM   3754  O   HIS F  45      37.541   0.260   8.326  1.00 54.31           O  
ATOM   3755  CB  HIS F  45      37.310   0.662  11.430  1.00 51.76           C  
ATOM   3756  CG  HIS F  45      38.703   0.737  10.894  1.00 52.53           C  
ATOM   3757  ND1 HIS F  45      39.639  -0.248  11.116  1.00 52.58           N  
ATOM   3758  CD2 HIS F  45      39.295   1.645  10.079  1.00 52.82           C  
ATOM   3759  CE1 HIS F  45      40.759   0.065  10.489  1.00 53.17           C  
ATOM   3760  NE2 HIS F  45      40.579   1.211   9.857  1.00 52.82           N  
ATOM   3761  N   TYR F  46      36.965  -1.673   9.241  1.00 52.24           N  
ATOM   3762  CA  TYR F  46      37.659  -2.486   8.224  1.00 51.81           C  
ATOM   3763  C   TYR F  46      39.151  -2.441   8.431  1.00 52.75           C  
ATOM   3764  O   TYR F  46      39.805  -1.460   8.079  1.00 52.98           O  
ATOM   3765  CB  TYR F  46      37.358  -2.086   6.778  1.00 50.72           C  
ATOM   3766  CG  TYR F  46      35.931  -2.247   6.344  1.00 47.69           C  
ATOM   3767  CD1 TYR F  46      35.159  -1.135   6.032  1.00 43.89           C  
ATOM   3768  CD2 TYR F  46      35.354  -3.501   6.238  1.00 45.87           C  
ATOM   3769  CE1 TYR F  46      33.857  -1.247   5.654  1.00 43.29           C  
ATOM   3770  CE2 TYR F  46      34.029  -3.637   5.858  1.00 45.06           C  
ATOM   3771  CZ  TYR F  46      33.288  -2.501   5.560  1.00 44.04           C  
ATOM   3772  OH  TYR F  46      31.988  -2.604   5.183  1.00 42.72           O  
ATOM   3773  N   SER F  47      39.693  -3.513   8.989  1.00 53.49           N  
ATOM   3774  CA  SER F  47      41.105  -3.559   9.252  1.00 54.65           C  
ATOM   3775  C   SER F  47      41.947  -3.549   7.977  1.00 55.47           C  
ATOM   3776  O   SER F  47      41.684  -4.277   7.020  1.00 54.30           O  
ATOM   3777  CB  SER F  47      41.471  -4.714  10.176  1.00 54.63           C  
ATOM   3778  OG  SER F  47      40.552  -5.755  10.077  1.00 55.24           O  
ATOM   3779  N   GLY F  48      42.958  -2.684   7.983  1.00 57.10           N  
ATOM   3780  CA  GLY F  48      43.842  -2.535   6.839  1.00 59.17           C  
ATOM   3781  C   GLY F  48      43.351  -1.432   5.921  1.00 60.76           C  
ATOM   3782  O   GLY F  48      44.153  -0.665   5.393  1.00 61.22           O  
ATOM   3783  N   TRP F  49      42.035  -1.340   5.738  1.00 61.99           N  
ATOM   3784  CA  TRP F  49      41.456  -0.302   4.892  1.00 63.16           C  
ATOM   3785  C   TRP F  49      41.691   1.052   5.531  1.00 64.61           C  
ATOM   3786  O   TRP F  49      41.709   1.187   6.752  1.00 63.94           O  
ATOM   3787  CB  TRP F  49      39.942  -0.488   4.692  1.00 62.66           C  
ATOM   3788  CG  TRP F  49      39.523  -1.784   4.074  1.00 61.84           C  
ATOM   3789  CD1 TRP F  49      40.183  -2.977   4.139  1.00 61.29           C  
ATOM   3790  CD2 TRP F  49      38.331  -2.029   3.320  1.00 61.14           C  
ATOM   3791  NE1 TRP F  49      39.481  -3.942   3.460  1.00 61.28           N  
ATOM   3792  CE2 TRP F  49      38.338  -3.383   2.949  1.00 61.09           C  
ATOM   3793  CE3 TRP F  49      37.250  -1.234   2.918  1.00 61.09           C  
ATOM   3794  CZ2 TRP F  49      37.318  -3.956   2.201  1.00 61.02           C  
ATOM   3795  CZ3 TRP F  49      36.247  -1.805   2.178  1.00 60.58           C  
ATOM   3796  CH2 TRP F  49      36.284  -3.146   1.824  1.00 60.67           C  
ATOM   3797  N   ASN F  50      41.833   2.067   4.694  1.00 66.71           N  
ATOM   3798  CA  ASN F  50      42.004   3.404   5.214  1.00 69.01           C  
ATOM   3799  C   ASN F  50      40.717   3.979   5.828  1.00 70.18           C  
ATOM   3800  O   ASN F  50      39.594   3.546   5.526  1.00 70.30           O  
ATOM   3801  CB  ASN F  50      42.627   4.313   4.151  1.00 69.79           C  
ATOM   3802  CG  ASN F  50      44.074   3.907   3.801  1.00 71.27           C  
ATOM   3803  OD1 ASN F  50      44.909   3.675   4.688  1.00 72.21           O  
ATOM   3804  ND2 ASN F  50      44.365   3.819   2.509  1.00 72.67           N  
ATOM   3805  N   LYS F  51      40.909   4.961   6.694  1.00 71.19           N  
ATOM   3806  CA  LYS F  51      39.852   5.558   7.494  1.00 72.43           C  
ATOM   3807  C   LYS F  51      38.595   6.075   6.780  1.00 72.10           C  
ATOM   3808  O   LYS F  51      37.555   6.248   7.419  1.00 71.87           O  
ATOM   3809  CB  LYS F  51      40.441   6.690   8.349  1.00 73.62           C  
ATOM   3810  CG  LYS F  51      41.696   6.315   9.143  1.00 76.51           C  
ATOM   3811  CD  LYS F  51      42.219   7.493  10.004  1.00 80.07           C  
ATOM   3812  CE  LYS F  51      43.472   7.112  10.812  1.00 82.08           C  
ATOM   3813  NZ  LYS F  51      44.113   8.272  11.513  1.00 83.18           N  
ATOM   3814  N   ASN F  52      38.670   6.346   5.482  1.00 71.71           N  
ATOM   3815  CA  ASN F  52      37.493   6.908   4.812  1.00 71.42           C  
ATOM   3816  C   ASN F  52      36.561   5.876   4.206  1.00 70.17           C  
ATOM   3817  O   ASN F  52      35.690   6.213   3.415  1.00 70.21           O  
ATOM   3818  CB  ASN F  52      37.877   7.929   3.744  1.00 72.28           C  
ATOM   3819  CG  ASN F  52      38.762   9.029   4.278  1.00 74.26           C  
ATOM   3820  OD1 ASN F  52      39.445   8.867   5.293  1.00 76.35           O  
ATOM   3821  ND2 ASN F  52      38.775  10.156   3.580  1.00 75.40           N  
ATOM   3822  N   TRP F  53      36.772   4.615   4.543  1.00 68.62           N  
ATOM   3823  CA  TRP F  53      35.872   3.577   4.090  1.00 67.25           C  
ATOM   3824  C   TRP F  53      34.918   3.258   5.233  1.00 65.59           C  
ATOM   3825  O   TRP F  53      33.896   2.617   5.023  1.00 65.49           O  
ATOM   3826  CB  TRP F  53      36.641   2.337   3.664  1.00 67.76           C  
ATOM   3827  CG  TRP F  53      37.482   2.573   2.467  1.00 69.36           C  
ATOM   3828  CD1 TRP F  53      38.816   2.839   2.449  1.00 70.30           C  
ATOM   3829  CD2 TRP F  53      37.055   2.569   1.103  1.00 70.80           C  
ATOM   3830  NE1 TRP F  53      39.250   2.990   1.156  1.00 70.94           N  
ATOM   3831  CE2 TRP F  53      38.185   2.836   0.311  1.00 71.13           C  
ATOM   3832  CE3 TRP F  53      35.827   2.349   0.464  1.00 71.81           C  
ATOM   3833  CZ2 TRP F  53      38.129   2.903  -1.075  1.00 71.95           C  
ATOM   3834  CZ3 TRP F  53      35.773   2.418  -0.927  1.00 72.31           C  
ATOM   3835  CH2 TRP F  53      36.918   2.689  -1.676  1.00 71.99           C  
ATOM   3836  N   ASP F  54      35.271   3.714   6.434  1.00 63.26           N  
ATOM   3837  CA  ASP F  54      34.433   3.552   7.608  1.00 61.52           C  
ATOM   3838  C   ASP F  54      32.987   3.905   7.295  1.00 60.60           C  
ATOM   3839  O   ASP F  54      32.714   4.895   6.613  1.00 61.05           O  
ATOM   3840  CB  ASP F  54      34.915   4.457   8.725  1.00 61.12           C  
ATOM   3841  CG  ASP F  54      36.195   3.986   9.340  1.00 60.74           C  
ATOM   3842  OD1 ASP F  54      37.081   3.471   8.631  1.00 60.66           O  
ATOM   3843  OD2 ASP F  54      36.411   4.095  10.544  1.00 61.61           O  
ATOM   3844  N   GLU F  55      32.046   3.120   7.806  1.00 58.76           N  
ATOM   3845  CA  GLU F  55      30.645   3.382   7.486  1.00 56.62           C  
ATOM   3846  C   GLU F  55      29.670   2.890   8.539  1.00 55.66           C  
ATOM   3847  O   GLU F  55      30.011   2.084   9.396  1.00 55.12           O  
ATOM   3848  CB  GLU F  55      30.298   2.760   6.132  1.00 55.99           C  
ATOM   3849  CG  GLU F  55      30.740   1.316   5.973  1.00 54.14           C  
ATOM   3850  CD  GLU F  55      30.211   0.687   4.700  1.00 52.13           C  
ATOM   3851  OE1 GLU F  55      30.634  -0.420   4.331  1.00 51.08           O  
ATOM   3852  OE2 GLU F  55      29.364   1.305   4.060  1.00 51.67           O  
ATOM   3853  N   TRP F  56      28.452   3.410   8.472  1.00 55.21           N  
ATOM   3854  CA  TRP F  56      27.376   2.994   9.367  1.00 54.69           C  
ATOM   3855  C   TRP F  56      26.710   1.816   8.686  1.00 53.37           C  
ATOM   3856  O   TRP F  56      26.310   1.906   7.541  1.00 53.26           O  
ATOM   3857  CB  TRP F  56      26.365   4.122   9.574  1.00 55.14           C  
ATOM   3858  CG  TRP F  56      26.805   5.083  10.611  1.00 56.63           C  
ATOM   3859  CD1 TRP F  56      27.174   6.378  10.422  1.00 57.55           C  
ATOM   3860  CD2 TRP F  56      26.958   4.819  12.006  1.00 57.69           C  
ATOM   3861  NE1 TRP F  56      27.535   6.942  11.623  1.00 58.63           N  
ATOM   3862  CE2 TRP F  56      27.406   6.005  12.611  1.00 58.41           C  
ATOM   3863  CE3 TRP F  56      26.744   3.699  12.814  1.00 57.98           C  
ATOM   3864  CZ2 TRP F  56      27.651   6.100  13.974  1.00 58.65           C  
ATOM   3865  CZ3 TRP F  56      26.980   3.792  14.151  1.00 58.42           C  
ATOM   3866  CH2 TRP F  56      27.431   4.989  14.728  1.00 58.93           C  
ATOM   3867  N   VAL F  57      26.624   0.708   9.393  1.00 52.21           N  
ATOM   3868  CA  VAL F  57      26.056  -0.508   8.830  1.00 50.92           C  
ATOM   3869  C   VAL F  57      24.987  -1.113   9.735  1.00 49.43           C  
ATOM   3870  O   VAL F  57      25.095  -1.017  10.938  1.00 48.85           O  
ATOM   3871  CB  VAL F  57      27.198  -1.518   8.618  1.00 50.73           C  
ATOM   3872  CG1 VAL F  57      26.827  -2.876   9.059  1.00 50.30           C  
ATOM   3873  CG2 VAL F  57      27.640  -1.506   7.193  1.00 51.58           C  
ATOM   3874  N   PRO F  58      23.943  -1.697   9.156  1.00 48.63           N  
ATOM   3875  CA  PRO F  58      22.930  -2.422   9.938  1.00 48.00           C  
ATOM   3876  C   PRO F  58      23.461  -3.801  10.291  1.00 46.87           C  
ATOM   3877  O   PRO F  58      24.316  -4.276   9.537  1.00 46.10           O  
ATOM   3878  CB  PRO F  58      21.748  -2.543   8.973  1.00 48.11           C  
ATOM   3879  CG  PRO F  58      22.321  -2.374   7.595  1.00 48.98           C  
ATOM   3880  CD  PRO F  58      23.636  -1.667   7.717  1.00 48.84           C  
ATOM   3881  N   GLU F  59      22.971  -4.401  11.385  1.00 45.90           N  
ATOM   3882  CA  GLU F  59      23.411  -5.703  11.929  1.00 45.76           C  
ATOM   3883  C   GLU F  59      23.546  -6.846  10.922  1.00 44.22           C  
ATOM   3884  O   GLU F  59      24.353  -7.731  11.097  1.00 43.79           O  
ATOM   3885  CB  GLU F  59      22.456  -6.191  13.040  1.00 46.45           C  
ATOM   3886  CG  GLU F  59      22.494  -5.420  14.343  1.00 50.53           C  
ATOM   3887  CD  GLU F  59      22.123  -6.285  15.540  1.00 54.72           C  
ATOM   3888  OE1 GLU F  59      22.112  -5.793  16.693  1.00 56.71           O  
ATOM   3889  OE2 GLU F  59      21.812  -7.471  15.320  1.00 56.87           O  
ATOM   3890  N   SER F  60      22.676  -6.867   9.930  1.00 43.25           N  
ATOM   3891  CA  SER F  60      22.704  -7.880   8.905  1.00 42.77           C  
ATOM   3892  C   SER F  60      24.098  -8.001   8.264  1.00 42.48           C  
ATOM   3893  O   SER F  60      24.566  -9.100   7.967  1.00 42.60           O  
ATOM   3894  CB  SER F  60      21.689  -7.520   7.837  1.00 42.34           C  
ATOM   3895  OG  SER F  60      21.963  -6.201   7.401  1.00 42.77           O  
ATOM   3896  N   ARG F  61      24.773  -6.883   8.053  1.00 41.32           N  
ATOM   3897  CA  ARG F  61      26.087  -6.945   7.407  1.00 40.58           C  
ATOM   3898  C   ARG F  61      27.265  -7.357   8.284  1.00 39.01           C  
ATOM   3899  O   ARG F  61      28.386  -7.507   7.809  1.00 37.41           O  
ATOM   3900  CB  ARG F  61      26.377  -5.636   6.714  1.00 41.04           C  
ATOM   3901  CG  ARG F  61      25.639  -5.585   5.424  1.00 42.76           C  
ATOM   3902  CD  ARG F  61      25.844  -4.343   4.708  1.00 45.58           C  
ATOM   3903  NE  ARG F  61      27.258  -4.038   4.551  1.00 47.91           N  
ATOM   3904  CZ  ARG F  61      27.690  -2.844   4.193  1.00 47.52           C  
ATOM   3905  NH1 ARG F  61      26.816  -1.878   3.996  1.00 46.89           N  
ATOM   3906  NH2 ARG F  61      28.981  -2.618   4.032  1.00 47.98           N  
ATOM   3907  N   VAL F  62      26.986  -7.593   9.549  1.00 37.86           N  
ATOM   3908  CA  VAL F  62      28.021  -7.940  10.486  1.00 37.50           C  
ATOM   3909  C   VAL F  62      27.879  -9.374  10.961  1.00 38.47           C  
ATOM   3910  O   VAL F  62      26.749  -9.853  11.159  1.00 38.13           O  
ATOM   3911  CB  VAL F  62      27.957  -7.016  11.703  1.00 36.96           C  
ATOM   3912  CG1 VAL F  62      29.089  -7.312  12.648  1.00 35.78           C  
ATOM   3913  CG2 VAL F  62      27.984  -5.567  11.264  1.00 35.94           C  
ATOM   3914  N   LEU F  63      29.015 -10.050  11.164  1.00 38.25           N  
ATOM   3915  CA  LEU F  63      29.017 -11.416  11.646  1.00 38.98           C  
ATOM   3916  C   LEU F  63      30.036 -11.588  12.742  1.00 39.04           C  
ATOM   3917  O   LEU F  63      31.036 -10.865  12.775  1.00 39.15           O  
ATOM   3918  CB  LEU F  63      29.350 -12.405  10.518  1.00 39.13           C  
ATOM   3919  CG  LEU F  63      28.300 -12.544   9.415  1.00 41.20           C  
ATOM   3920  CD1 LEU F  63      28.703 -13.585   8.341  1.00 40.15           C  
ATOM   3921  CD2 LEU F  63      26.956 -12.916  10.014  1.00 41.07           C  
ATOM   3922  N   LYS F  64      29.823 -12.580  13.598  1.00 38.82           N  
ATOM   3923  CA  LYS F  64      30.758 -12.876  14.673  1.00 39.63           C  
ATOM   3924  C   LYS F  64      32.075 -13.450  14.178  1.00 39.37           C  
ATOM   3925  O   LYS F  64      32.122 -14.232  13.216  1.00 38.41           O  
ATOM   3926  CB  LYS F  64      30.149 -13.863  15.677  1.00 40.98           C  
ATOM   3927  CG  LYS F  64      30.397 -13.405  17.134  1.00 43.63           C  
ATOM   3928  CD  LYS F  64      29.408 -12.305  17.564  1.00 45.98           C  
ATOM   3929  CE  LYS F  64      29.663 -11.848  19.039  1.00 46.58           C  
ATOM   3930  NZ  LYS F  64      28.837 -10.655  19.458  1.00 46.10           N  
ATOM   3931  N   TYR F  65      33.153 -13.100  14.869  1.00 38.99           N  
ATOM   3932  CA  TYR F  65      34.461 -13.536  14.432  1.00 38.69           C  
ATOM   3933  C   TYR F  65      34.678 -14.947  14.936  1.00 38.24           C  
ATOM   3934  O   TYR F  65      35.435 -15.183  15.868  1.00 37.57           O  
ATOM   3935  CB  TYR F  65      35.585 -12.556  14.888  1.00 38.83           C  
ATOM   3936  CG  TYR F  65      36.858 -12.705  14.076  1.00 38.62           C  
ATOM   3937  CD1 TYR F  65      37.025 -12.025  12.880  1.00 39.37           C  
ATOM   3938  CD2 TYR F  65      37.885 -13.544  14.499  1.00 37.92           C  
ATOM   3939  CE1 TYR F  65      38.209 -12.173  12.120  1.00 39.96           C  
ATOM   3940  CE2 TYR F  65      39.045 -13.680  13.776  1.00 38.02           C  
ATOM   3941  CZ  TYR F  65      39.195 -13.004  12.588  1.00 40.46           C  
ATOM   3942  OH  TYR F  65      40.357 -13.162  11.869  1.00 44.73           O  
ATOM   3943  N   VAL F  66      34.024 -15.903  14.301  1.00 37.95           N  
ATOM   3944  CA  VAL F  66      34.152 -17.270  14.767  1.00 38.28           C  
ATOM   3945  C   VAL F  66      34.492 -18.204  13.634  1.00 38.22           C  
ATOM   3946  O   VAL F  66      34.300 -17.849  12.486  1.00 38.03           O  
ATOM   3947  CB  VAL F  66      32.868 -17.720  15.531  1.00 38.83           C  
ATOM   3948  CG1 VAL F  66      31.587 -17.627  14.645  1.00 35.91           C  
ATOM   3949  CG2 VAL F  66      33.047 -19.120  15.953  1.00 41.59           C  
ATOM   3950  N   ASP F  67      35.007 -19.395  13.926  1.00 38.47           N  
ATOM   3951  CA  ASP F  67      35.383 -20.310  12.850  1.00 39.42           C  
ATOM   3952  C   ASP F  67      34.300 -20.563  11.796  1.00 39.30           C  
ATOM   3953  O   ASP F  67      34.612 -20.796  10.606  1.00 39.68           O  
ATOM   3954  CB  ASP F  67      35.841 -21.657  13.408  1.00 40.47           C  
ATOM   3955  CG  ASP F  67      37.281 -21.626  13.946  1.00 42.99           C  
ATOM   3956  OD1 ASP F  67      37.906 -20.530  14.063  1.00 46.24           O  
ATOM   3957  OD2 ASP F  67      37.868 -22.662  14.286  1.00 43.08           O  
ATOM   3958  N   THR F  68      33.041 -20.586  12.214  1.00 37.96           N  
ATOM   3959  CA  THR F  68      31.973 -20.842  11.251  1.00 38.24           C  
ATOM   3960  C   THR F  68      31.957 -19.747  10.177  1.00 36.27           C  
ATOM   3961  O   THR F  68      31.839 -20.026   8.983  1.00 35.35           O  
ATOM   3962  CB  THR F  68      30.616 -20.912  11.959  1.00 38.52           C  
ATOM   3963  OG1 THR F  68      30.368 -22.268  12.313  1.00 40.50           O  
ATOM   3964  CG2 THR F  68      29.496 -20.631  10.977  1.00 39.70           C  
ATOM   3965  N   ASN F  69      32.063 -18.507  10.643  1.00 34.46           N  
ATOM   3966  CA  ASN F  69      32.041 -17.359   9.780  1.00 33.18           C  
ATOM   3967  C   ASN F  69      33.332 -17.211   8.998  1.00 32.98           C  
ATOM   3968  O   ASN F  69      33.313 -16.755   7.848  1.00 31.50           O  
ATOM   3969  CB  ASN F  69      31.681 -16.112  10.562  1.00 32.92           C  
ATOM   3970  CG  ASN F  69      30.232 -16.141  11.038  1.00 33.82           C  
ATOM   3971  OD1 ASN F  69      29.815 -15.389  11.909  1.00 34.92           O  
ATOM   3972  ND2 ASN F  69      29.459 -17.020  10.448  1.00 33.48           N  
ATOM   3973  N   LEU F  70      34.450 -17.613   9.598  1.00 33.15           N  
ATOM   3974  CA  LEU F  70      35.717 -17.567   8.869  1.00 34.36           C  
ATOM   3975  C   LEU F  70      35.690 -18.528   7.680  1.00 33.90           C  
ATOM   3976  O   LEU F  70      36.090 -18.183   6.578  1.00 32.99           O  
ATOM   3977  CB  LEU F  70      36.901 -17.885   9.780  1.00 34.76           C  
ATOM   3978  CG  LEU F  70      37.089 -16.833  10.873  1.00 34.79           C  
ATOM   3979  CD1 LEU F  70      37.915 -17.409  12.021  1.00 35.28           C  
ATOM   3980  CD2 LEU F  70      37.653 -15.504  10.325  1.00 33.32           C  
ATOM   3981  N   GLN F  71      35.225 -19.736   7.915  1.00 33.87           N  
ATOM   3982  CA  GLN F  71      35.086 -20.693   6.834  1.00 33.68           C  
ATOM   3983  C   GLN F  71      34.165 -20.129   5.758  1.00 33.38           C  
ATOM   3984  O   GLN F  71      34.424 -20.311   4.558  1.00 32.95           O  
ATOM   3985  CB  GLN F  71      34.503 -22.022   7.342  1.00 34.59           C  
ATOM   3986  CG  GLN F  71      34.086 -23.021   6.213  1.00 37.21           C  
ATOM   3987  CD  GLN F  71      35.290 -23.579   5.436  1.00 40.32           C  
ATOM   3988  OE1 GLN F  71      36.404 -23.520   5.933  1.00 42.93           O  
ATOM   3989  NE2 GLN F  71      35.065 -24.118   4.232  1.00 39.71           N  
ATOM   3990  N   LYS F  72      33.073 -19.479   6.165  1.00 32.39           N  
ATOM   3991  CA  LYS F  72      32.159 -18.908   5.181  1.00 32.64           C  
ATOM   3992  C   LYS F  72      32.938 -17.874   4.347  1.00 31.75           C  
ATOM   3993  O   LYS F  72      32.791 -17.783   3.115  1.00 30.15           O  
ATOM   3994  CB  LYS F  72      30.951 -18.212   5.874  1.00 32.77           C  
ATOM   3995  CG  LYS F  72      30.043 -17.489   4.940  1.00 34.82           C  
ATOM   3996  CD  LYS F  72      28.844 -16.857   5.658  1.00 38.20           C  
ATOM   3997  CE  LYS F  72      27.767 -17.871   5.854  1.00 40.32           C  
ATOM   3998  NZ  LYS F  72      26.501 -17.255   6.212  1.00 42.22           N  
ATOM   3999  N   GLN F  73      33.714 -17.065   5.046  1.00 32.28           N  
ATOM   4000  CA  GLN F  73      34.521 -16.032   4.406  1.00 34.92           C  
ATOM   4001  C   GLN F  73      35.365 -16.663   3.279  1.00 36.24           C  
ATOM   4002  O   GLN F  73      35.422 -16.163   2.172  1.00 35.27           O  
ATOM   4003  CB  GLN F  73      35.458 -15.359   5.414  1.00 34.89           C  
ATOM   4004  CG  GLN F  73      36.549 -14.456   4.748  1.00 36.61           C  
ATOM   4005  CD  GLN F  73      37.415 -13.726   5.756  1.00 36.81           C  
ATOM   4006  OE1 GLN F  73      37.993 -14.344   6.636  1.00 37.75           O  
ATOM   4007  NE2 GLN F  73      37.482 -12.420   5.646  1.00 35.62           N  
ATOM   4008  N   ARG F  74      36.001 -17.782   3.612  1.00 37.97           N  
ATOM   4009  CA  ARG F  74      36.873 -18.507   2.716  1.00 39.55           C  
ATOM   4010  C   ARG F  74      36.061 -18.919   1.498  1.00 39.66           C  
ATOM   4011  O   ARG F  74      36.426 -18.648   0.339  1.00 39.47           O  
ATOM   4012  CB  ARG F  74      37.418 -19.735   3.463  1.00 41.23           C  
ATOM   4013  CG  ARG F  74      38.720 -20.341   2.929  1.00 43.93           C  
ATOM   4014  CD  ARG F  74      39.461 -21.234   3.943  1.00 47.98           C  
ATOM   4015  NE  ARG F  74      39.422 -20.676   5.294  1.00 51.16           N  
ATOM   4016  CZ  ARG F  74      39.101 -21.362   6.399  1.00 51.70           C  
ATOM   4017  NH1 ARG F  74      38.812 -22.656   6.331  1.00 51.11           N  
ATOM   4018  NH2 ARG F  74      39.086 -20.743   7.579  1.00 51.90           N  
ATOM   4019  N   GLU F  75      34.926 -19.540   1.754  1.00 39.13           N  
ATOM   4020  CA  GLU F  75      34.080 -19.947   0.674  1.00 38.83           C  
ATOM   4021  C   GLU F  75      33.543 -18.790  -0.185  1.00 39.07           C  
ATOM   4022  O   GLU F  75      33.343 -18.976  -1.383  1.00 38.39           O  
ATOM   4023  CB  GLU F  75      32.947 -20.846   1.171  1.00 38.67           C  
ATOM   4024  CG  GLU F  75      33.436 -22.050   1.991  1.00 38.26           C  
ATOM   4025  CD  GLU F  75      32.342 -23.021   2.349  1.00 37.69           C  
ATOM   4026  OE1 GLU F  75      31.148 -22.642   2.368  1.00 37.98           O  
ATOM   4027  OE2 GLU F  75      32.672 -24.182   2.591  1.00 37.50           O  
ATOM   4028  N   LEU F  76      33.297 -17.618   0.398  1.00 39.14           N  
ATOM   4029  CA  LEU F  76      32.754 -16.558  -0.428  1.00 40.73           C  
ATOM   4030  C   LEU F  76      33.829 -16.040  -1.369  1.00 43.00           C  
ATOM   4031  O   LEU F  76      33.529 -15.461  -2.392  1.00 42.86           O  
ATOM   4032  CB  LEU F  76      32.133 -15.409   0.376  1.00 39.78           C  
ATOM   4033  CG  LEU F  76      30.831 -15.684   1.167  1.00 39.18           C  
ATOM   4034  CD1 LEU F  76      29.914 -14.488   1.235  1.00 36.37           C  
ATOM   4035  CD2 LEU F  76      30.070 -16.944   0.750  1.00 35.49           C  
ATOM   4036  N   GLN F  77      35.083 -16.236  -0.995  1.00 45.85           N  
ATOM   4037  CA  GLN F  77      36.200 -15.781  -1.803  1.00 48.91           C  
ATOM   4038  C   GLN F  77      36.419 -16.733  -2.961  1.00 49.85           C  
ATOM   4039  O   GLN F  77      36.641 -16.318  -4.090  1.00 49.68           O  
ATOM   4040  CB  GLN F  77      37.460 -15.659  -0.950  1.00 49.64           C  
ATOM   4041  CG  GLN F  77      37.213 -14.826   0.266  1.00 52.22           C  
ATOM   4042  CD  GLN F  77      38.466 -14.519   1.039  1.00 55.50           C  
ATOM   4043  OE1 GLN F  77      39.112 -15.416   1.577  1.00 56.60           O  
ATOM   4044  NE2 GLN F  77      38.805 -13.240   1.116  1.00 57.68           N  
ATOM   4045  N   LYS F  78      36.310 -18.010  -2.668  1.00 51.31           N  
ATOM   4046  CA  LYS F  78      36.445 -19.026  -3.677  1.00 53.60           C  
ATOM   4047  C   LYS F  78      35.301 -18.824  -4.657  1.00 54.77           C  
ATOM   4048  O   LYS F  78      35.486 -18.908  -5.858  1.00 53.94           O  
ATOM   4049  CB  LYS F  78      36.402 -20.403  -3.010  1.00 54.05           C  
ATOM   4050  CG  LYS F  78      36.184 -21.594  -3.927  1.00 56.60           C  
ATOM   4051  CD  LYS F  78      36.514 -22.900  -3.170  1.00 58.89           C  
ATOM   4052  CE  LYS F  78      35.722 -24.092  -3.705  1.00 59.83           C  
ATOM   4053  NZ  LYS F  78      36.390 -25.366  -3.293  1.00 60.14           N  
ATOM   4054  N   ALA F  79      34.121 -18.501  -4.139  1.00 56.56           N  
ATOM   4055  CA  ALA F  79      32.985 -18.244  -5.005  1.00 59.01           C  
ATOM   4056  C   ALA F  79      33.110 -16.957  -5.857  1.00 60.90           C  
ATOM   4057  O   ALA F  79      32.678 -16.921  -7.001  1.00 60.46           O  
ATOM   4058  CB  ALA F  79      31.690 -18.248  -4.201  1.00 58.45           C  
ATOM   4059  N   ASN F  80      33.681 -15.901  -5.300  1.00 63.84           N  
ATOM   4060  CA  ASN F  80      33.869 -14.699  -6.082  1.00 67.42           C  
ATOM   4061  C   ASN F  80      34.934 -14.995  -7.119  1.00 70.55           C  
ATOM   4062  O   ASN F  80      35.020 -14.330  -8.141  1.00 70.59           O  
ATOM   4063  CB  ASN F  80      34.309 -13.535  -5.201  1.00 66.92           C  
ATOM   4064  CG  ASN F  80      34.638 -12.292  -6.004  1.00 66.64           C  
ATOM   4065  OD1 ASN F  80      33.799 -11.784  -6.739  1.00 66.45           O  
ATOM   4066  ND2 ASN F  80      35.861 -11.798  -5.866  1.00 65.60           N  
ATOM   4067  N   GLN F  81      35.744 -16.011  -6.831  1.00 74.50           N  
ATOM   4068  CA  GLN F  81      36.824 -16.443  -7.708  1.00 78.48           C  
ATOM   4069  C   GLN F  81      36.186 -16.961  -8.978  1.00 81.04           C  
ATOM   4070  O   GLN F  81      36.518 -16.523 -10.075  1.00 81.12           O  
ATOM   4071  CB  GLN F  81      37.603 -17.575  -7.049  1.00 78.88           C  
ATOM   4072  CG  GLN F  81      39.104 -17.366  -6.912  1.00 80.22           C  
ATOM   4073  CD  GLN F  81      39.764 -18.503  -6.145  1.00 81.69           C  
ATOM   4074  OE1 GLN F  81      39.555 -19.681  -6.463  1.00 82.22           O  
ATOM   4075  NE2 GLN F  81      40.545 -18.160  -5.129  1.00 82.57           N  
ATOM   4076  N   GLU F  82      35.267 -17.906  -8.821  1.00 84.28           N  
ATOM   4077  CA  GLU F  82      34.534 -18.434  -9.956  1.00 87.62           C  
ATOM   4078  C   GLU F  82      33.836 -17.273 -10.655  1.00 89.74           C  
ATOM   4079  O   GLU F  82      33.468 -17.368 -11.820  1.00 90.10           O  
ATOM   4080  CB  GLU F  82      33.523 -19.494  -9.509  1.00 87.88           C  
ATOM   4081  CG  GLU F  82      32.541 -19.912 -10.596  1.00 89.41           C  
ATOM   4082  CD  GLU F  82      31.733 -21.143 -10.235  1.00 91.44           C  
ATOM   4083  OE1 GLU F  82      31.322 -21.278  -9.062  1.00 92.49           O  
ATOM   4084  OE2 GLU F  82      31.499 -21.984 -11.128  1.00 92.33           O  
ATOM   4085  N   GLN F  83      33.674 -16.169  -9.934  1.00 92.26           N  
ATOM   4086  CA  GLN F  83      33.040 -14.974 -10.473  1.00 94.64           C  
ATOM   4087  C   GLN F  83      34.002 -14.232 -11.406  1.00 95.80           C  
ATOM   4088  O   GLN F  83      33.872 -13.028 -11.633  1.00 96.00           O  
ATOM   4089  CB  GLN F  83      32.599 -14.064  -9.326  1.00 95.12           C  
ATOM   4090  CG  GLN F  83      31.746 -12.885  -9.742  1.00 96.85           C  
ATOM   4091  CD  GLN F  83      32.058 -11.634  -8.945  1.00 98.69           C  
ATOM   4092  OE1 GLN F  83      33.021 -10.931  -9.247  1.00 99.67           O  
ATOM   4093  NE2 GLN F  83      31.254 -11.355  -7.928  1.00 99.48           N  
ATOM   4094  N   TYR F  84      34.970 -14.965 -11.939  1.00 97.18           N  
ATOM   4095  CA  TYR F  84      35.962 -14.403 -12.844  1.00 98.54           C  
ATOM   4096  C   TYR F  84      36.085 -15.281 -14.073  1.00 98.72           C  
ATOM   4097  O   TYR F  84      35.991 -14.807 -15.205  1.00 98.99           O  
ATOM   4098  CB  TYR F  84      37.319 -14.320 -12.151  1.00 99.26           C  
ATOM   4099  CG  TYR F  84      37.570 -13.021 -11.425  1.00101.35           C  
ATOM   4100  CD1 TYR F  84      36.664 -12.532 -10.497  1.00102.85           C  
ATOM   4101  CD2 TYR F  84      38.718 -12.282 -11.670  1.00103.13           C  
ATOM   4102  CE1 TYR F  84      36.893 -11.336  -9.831  1.00103.99           C  
ATOM   4103  CE2 TYR F  84      38.960 -11.088 -11.009  1.00104.25           C  
ATOM   4104  CZ  TYR F  84      38.043 -10.622 -10.090  1.00104.66           C  
ATOM   4105  OH  TYR F  84      38.275  -9.437  -9.430  1.00105.45           O  
ATOM   4106  N   ALA F  85      36.282 -16.572 -13.831  1.00 98.87           N  
ATOM   4107  CA  ALA F  85      36.485 -17.558 -14.888  1.00 98.92           C  
ATOM   4108  C   ALA F  85      35.227 -17.893 -15.685  1.00 98.90           C  
ATOM   4109  O   ALA F  85      35.312 -18.436 -16.785  1.00 99.01           O  
ATOM   4110  CB  ALA F  85      37.082 -18.829 -14.296  1.00 99.04           C  
ATOM   4111  N   GLU F  86      34.061 -17.592 -15.132  1.00 98.78           N  
ATOM   4112  CA  GLU F  86      32.823 -17.881 -15.833  1.00 98.70           C  
ATOM   4113  C   GLU F  86      32.389 -16.729 -16.729  1.00 98.62           C  
ATOM   4114  O   GLU F  86      32.961 -15.637 -16.685  1.00 98.48           O  
ATOM   4115  CB  GLU F  86      31.714 -18.255 -14.855  1.00 98.78           C  
ATOM   4116  CG  GLU F  86      31.882 -19.639 -14.256  1.00 98.95           C  
ATOM   4117  CD  GLU F  86      30.585 -20.431 -14.226  1.00 99.16           C  
ATOM   4118  OE1 GLU F  86      29.571 -19.907 -13.719  1.00 99.43           O  
ATOM   4119  OE2 GLU F  86      30.580 -21.581 -14.716  1.00 98.91           O  
TER    4120      GLU F  86                                                      
END
MOLECULE T0429_22_99.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
END
