
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  135 ( 1056),  selected  135 , name 1khc_A
# Molecule2: number of CA atoms  135 ( 1110),  selected  135 , name T0429.pdb
# PARAMETERS: 1khc_A.T0429.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E   223_A      E      22           #
LGA    Y   224_A      T      23          4.269
LGA    Q   225_A      E      24          2.810
LGA    D   226_A      L      25          4.772
LGA    D   227_A      -       -           -
LGA    K   228_A      -       -           -
LGA    E   229_A      L      27          0.804
LGA    F   230_A      Y      28          0.710
LGA    G   231_A      K      29          1.279
LGA    I   232_A      V      30          1.687
LGA    G   233_A      N      31          1.806
LGA    D   234_A      E      32          1.431
LGA    L   235_A      Y      33          1.732
LGA    V   236_A      V      34          1.468
LGA    W   237_A      D      35          1.614
LGA    G   238_A      A      36          1.878
LGA    K   239_A      R      37          1.546
LGA    I   240_A      D      38          0.842
LGA    -       -      T      39           -
LGA    K   241_A      N      40          3.838
LGA    G   242_A      M      41          1.209
LGA    F   243_A      G      42          1.722
LGA    S   244_A      A      43          1.675
LGA    W   245_A      W      44          1.816
LGA    W   246_A      F      45          1.932
LGA    P   247_A      E      46          1.877
LGA    A   248_A      A      47          1.043
LGA    M   249_A      Q      48          1.097
LGA    V   250_A      V      49          0.862
LGA    V   251_A      V      50          1.351
LGA    S   252_A      R      51          3.581
LGA    W   253_A      -       -           -
LGA    K   254_A      -       -           -
LGA    A   255_A      -       -           -
LGA    T   256_A      -       -           -
LGA    S   257_A      -       -           -
LGA    K   258_A      -       -           -
LGA    R   259_A      -       -           -
LGA    Q   260_A      V      52           #
LGA    A   261_A      T      53          4.204
LGA    M   262_A      -       -           -
LGA    P   263_A      R      54          1.169
LGA    -       -      E      73           -
LGA    -       -      D      74           -
LGA    G   264_A      V      75          1.587
LGA    M   265_A      I      76          0.793
LGA    R   266_A      Y      77          1.021
LGA    W   267_A      H      78          0.789
LGA    V   268_A      V      79          0.936
LGA    Q   269_A      K      80          1.027
LGA    W   270_A      Y      81          1.702
LGA    F   271_A      D      82          2.516
LGA    G   272_A      D      83          1.780
LGA    D   273_A      Y      84          1.398
LGA    G   274_A      P      85          2.226
LGA    -       -      E      86           -
LGA    K   275_A      N      87          1.805
LGA    F   276_A      G      88          3.677
LGA    -       -      V      89           -
LGA    S   277_A      V      90          1.401
LGA    E   278_A      Q      91          0.399
LGA    I   279_A      M      92          0.730
LGA    S   280_A      N      93          2.308
LGA    A   281_A      S      94          2.488
LGA    D   282_A      R      95          3.517
LGA    K   283_A      D      96          2.889
LGA    L   284_A      V      97          1.296
LGA    V   285_A      R      98          0.989
LGA    A   286_A      A      99          0.371
LGA    L   287_A      R     100          0.345
LGA    G   288_A      A     101          3.912
LGA    L   289_A      R     102           #
LGA    F   290_A      T     103          5.028
LGA    S   291_A      I     104          4.425
LGA    -       -      I     105           -
LGA    -       -      K     106           -
LGA    -       -      W     107           -
LGA    -       -      Q     108           -
LGA    -       -      D     109           -
LGA    -       -      L     110           -
LGA    -       -      E     111           -
LGA    -       -      V     112           -
LGA    -       -      G     113           -
LGA    -       -      Q     114           -
LGA    Q   292_A      V     115           #
LGA    H   293_A      V     116          5.575
LGA    F   294_A      M     117          3.961
LGA    N   295_A      L     118          2.477
LGA    L   296_A      N     119          1.835
LGA    A   297_A      Y     120          1.865
LGA    T   298_A      N     121          4.303
LGA    F   299_A      P     122           -
LGA    -       -      D     123           -
LGA    -       -      N     124           -
LGA    -       -      P     125           -
LGA    -       -      K     126           -
LGA    N   300_A      E     127          4.886
LGA    K   301_A      R     128          2.709
LGA    L   302_A      G     129          3.817
LGA    V   303_A      -       -           -
LGA    S   304_A      -       -           -
LGA    Y   305_A      F     130          5.132
LGA    R   306_A      -       -           -
LGA    K   307_A      -       -           -
LGA    A   308_A      -       -           -
LGA    M   309_A      W     131           #
LGA    Y   310_A      Y     132           -
LGA    H   311_A      D     133           -
LGA    T   312_A      A     134           -
LGA    L   313_A      E     135           -
LGA    E   314_A      I     136           -
LGA    K   315_A      S     137           -
LGA    A   316_A      R     138           -
LGA    R   317_A      K     139           -
LGA    V   318_A      R     140           -
LGA    R   319_A      E     141           -
LGA    A   320_A      T     142           -
LGA    G   321_A      R     143           -
LGA    K   322_A      T     144           -
LGA    T   323_A      A     145           -
LGA    F   324_A      R     146           -
LGA    S   325_A      E     147           -
LGA    S   326_A      L     148           -
LGA    S   327_A      Y     149           -
LGA    P   328_A      A     150           -
LGA    G   329_A      N     151           -
LGA    E   330_A      V     152           -
LGA    S   331_A      V     153           -
LGA    L   332_A      L     154           -
LGA    E   333_A      D     156           -
LGA    D   334_A      D     157           -
LGA    Q   335_A      S     158           -
LGA    L   336_A      L     159           -
LGA    K   337_A      N     160           -
LGA    P   338_A      D     161           -
LGA    M   339_A      C     162           -
LGA    -       -      R     163           -
LGA    -       -      I     164           -
LGA    -       -      I     165           -
LGA    -       -      F     166           -
LGA    -       -      V     167           -
LGA    L   340_A      D     168           #
LGA    E   341_A      -       -           -
LGA    W   342_A      -       -           -
LGA    A   343_A      -       -           -
LGA    H   344_A      E     169           #
LGA    -       -      V     170           -
LGA    -       -      F     171           -
LGA    G   345_A      K     172           #
LGA    G   346_A      I     173           -
LGA    F   347_A      -       -           -
LGA    K   348_A      -       -           -
LGA    P   349_A      -       -           -
LGA    T   350_A      -       -           -
LGA    G   351_A      -       -           -
LGA    I   352_A      E     174           #
LGA    E   353_A      R     175           -
LGA    G   354_A      P     176           -
LGA    L   355_A      -       -           -
LGA    K   356_A      -       -           -
LGA    P   357_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  135  135    5.0     66    2.57    10.61     38.335     2.475

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.189165 * X  +  -0.491708 * Y  +  -0.849965 * Z  +  54.156303
  Y_new =  -0.290165 * X  +  -0.798947 * Y  +   0.526772 * Z  +  -1.839433
  Z_new =  -0.938094 * X  +   0.346276 * Y  +   0.008456 * Z  +  11.223001 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.546381   -1.595212  [ DEG:    88.6011    -91.3989 ]
  Theta =   1.217088    1.924505  [ DEG:    69.7340    110.2660 ]
  Phi   =  -2.148521    0.993071  [ DEG:  -123.1012     56.8988 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1khc_A                                        
REMARK     2: T0429.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1khc_A.T0429.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  135  135   5.0   66   2.57   10.61  38.335
REMARK  ---------------------------------------------------------- 
MOLECULE 1khc_A
HEADER    TRANSFERASE                             29-NOV-01   1KHC              
TITLE     CRYSTAL STRUCTURE OF THE PWWP DOMAIN OF MAMMALIAN DNA                 
TITLE    2 METHYLTRANSFERASE DNMT3B                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DNA CYTOSINE-5 METHYLTRANSFERASE 3B2;                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PWWP DOMAIN (RESIDUES 219-365);                            
COMPND   5 EC: 2.1.1.37;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: DNMT3B;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28                                     
KEYWDS    FIVE BETA-SHEETS BARREL FOLLOWED BY FIVE-HELIX BUNDLE                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.QIU,K.SAWADA,X.ZHANG,X.CHENG                                        
REVDAT   3   01-APR-03 1KHC    1       JRNL                                     
REVDAT   2   13-MAR-02 1KHC    1       HETNAM REMARK FORMUL HETATM              
REVDAT   1   27-FEB-02 1KHC    0                                                
JRNL        AUTH   C.QIU,K.SAWADA,X.ZHANG,X.CHENG                               
JRNL        TITL   THE PWWP DOMAIN OF MAMMALIAN DNA METHYLTRANSFERASE           
JRNL        TITL 2 DNMT3B DEFINES A NEW FAMILY OF DNA-BINDING FOLDS.            
JRNL        REF    NAT.STRUCT.BIOL.              V.   9   217 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1KHC A  219   365  UNP    O88509   DNM3B_MOUSE    219    365             
SEQRES   1 A  147  GLY ASP SER THR GLU TYR GLN ASP ASP LYS GLU PHE GLY          
SEQRES   2 A  147  ILE GLY ASP LEU VAL TRP GLY LYS ILE LYS GLY PHE SER          
SEQRES   3 A  147  TRP TRP PRO ALA MET VAL VAL SER TRP LYS ALA THR SER          
SEQRES   4 A  147  LYS ARG GLN ALA MET PRO GLY MET ARG TRP VAL GLN TRP          
SEQRES   5 A  147  PHE GLY ASP GLY LYS PHE SER GLU ILE SER ALA ASP LYS          
SEQRES   6 A  147  LEU VAL ALA LEU GLY LEU PHE SER GLN HIS PHE ASN LEU          
SEQRES   7 A  147  ALA THR PHE ASN LYS LEU VAL SER TYR ARG LYS ALA MET          
SEQRES   8 A  147  TYR HIS THR LEU GLU LYS ALA ARG VAL ARG ALA GLY LYS          
SEQRES   9 A  147  THR PHE SER SER SER PRO GLY GLU SER LEU GLU ASP GLN          
SEQRES  10 A  147  LEU LYS PRO MET LEU GLU TRP ALA HIS GLY GLY PHE LYS          
SEQRES  11 A  147  PRO THR GLY ILE GLU GLY LEU LYS PRO ASN LYS LYS GLN          
SEQRES  12 A  147  PRO GLU ASN LYS                                              
HET    UNX    163       1                                                       
HET    UNX    164       1                                                       
HET    UNX    165       1                                                       
HET    UNX    166       1                                                       
HET    UNX    167       1                                                       
HET    UNX    168       1                                                       
HET    UNX    169       1                                                       
HET    UNX    170       1                                                       
HET    UNX    171       1                                                       
HET    UNX    172       1                                                       
HET    UNX    173       1                                                       
HET    UNX    174       1                                                       
HET    UNX    175       1                                                       
HET    UNX    176       1                                                       
HET    UNX    177       1                                                       
HET    UNX    178       1                                                       
HET    UNX    179       1                                                       
HET    UNX    180       1                                                       
HET    UNX    181       1                                                       
HET    UNX    182       1                                                       
HET    UNX    183       1                                                       
HET    UNX    184       1                                                       
HETNAM     UNX UNKNOWN ATOM OR ION                                              
FORMUL   2  UNX    22(X1)                                                       
FORMUL  24  HOH   *162(H2 O)                                                    
CRYST1   52.750   52.750  186.860  90.00  90.00 120.00 P 65 2 2     12          
ATOM      1  C   THR A 222      26.336   4.240  24.538  1.00 23.10           C  
ATOM      2  N   GLU A 223      27.560   4.022  24.057  1.00 26.72           N  
ATOM      3  CA  GLU A 223      27.575   3.758  22.583  1.00 24.79           C  
ATOM      4  C   GLU A 223      27.213   2.297  22.311  1.00 24.46           C  
ATOM      5  O   GLU A 223      27.776   1.386  22.920  1.00 26.63           O  
ATOM      6  CB  GLU A 223      28.963   4.077  22.001  1.00 23.10           C  
ATOM      7  CG  GLU A 223      29.112   3.742  20.527  1.00 15.74           C  
ATOM      8  CD  GLU A 223      30.300   4.414  19.865  1.00 13.47           C  
ATOM      9  OE1 GLU A 223      31.248   4.821  20.568  1.00 13.05           O  
ATOM     10  OE2 GLU A 223      30.287   4.531  18.625  1.00 13.00           O  
ATOM     11  N   TYR A 224      26.272   2.082  21.397  1.00 22.47           N  
ATOM     12  CA  TYR A 224      25.823   0.737  21.041  1.00 23.70           C  
ATOM     13  C   TYR A 224      25.106   0.023  22.193  1.00 24.98           C  
ATOM     14  O   TYR A 224      25.094  -1.207  22.261  1.00 25.61           O  
ATOM     15  CB  TYR A 224      27.000  -0.133  20.565  1.00 19.41           C  
ATOM     16  CG  TYR A 224      27.805   0.441  19.418  1.00 15.07           C  
ATOM     17  CD1 TYR A 224      29.186   0.237  19.347  1.00 12.96           C  
ATOM     18  CD2 TYR A 224      27.196   1.194  18.410  1.00 12.24           C  
ATOM     19  CE1 TYR A 224      29.945   0.771  18.301  1.00 10.78           C  
ATOM     20  CE2 TYR A 224      27.945   1.730  17.359  1.00 10.97           C  
ATOM     21  CZ  TYR A 224      29.317   1.515  17.313  1.00  9.79           C  
ATOM     22  OH  TYR A 224      30.065   2.036  16.285  1.00  9.67           O  
ATOM     23  N   GLN A 225      24.527   0.789  23.109  1.00 27.14           N  
ATOM     24  CA  GLN A 225      23.792   0.178  24.203  1.00 28.50           C  
ATOM     25  C   GLN A 225      22.383   0.049  23.665  1.00 29.39           C  
ATOM     26  O   GLN A 225      21.560   0.939  23.864  1.00 32.46           O  
ATOM     27  N   ASP A 226      22.093  -1.051  22.977  1.00 28.88           N  
ATOM     28  CA  ASP A 226      20.774  -1.207  22.380  1.00 28.39           C  
ATOM     29  C   ASP A 226      20.225  -2.625  22.300  1.00 28.51           C  
ATOM     30  O   ASP A 226      19.325  -2.892  21.502  1.00 31.73           O  
ATOM     31  CB  ASP A 226      20.800  -0.615  20.973  1.00 27.53           C  
ATOM     32  CG  ASP A 226      21.893  -1.227  20.112  1.00 26.47           C  
ATOM     33  OD1 ASP A 226      22.306  -0.589  19.124  1.00 25.19           O  
ATOM     34  OD2 ASP A 226      22.340  -2.351  20.429  1.00 24.81           O  
ATOM     35  N   ASP A 227      20.752  -3.538  23.104  1.00 27.29           N  
ATOM     36  CA  ASP A 227      20.237  -4.896  23.062  1.00 27.99           C  
ATOM     37  C   ASP A 227      20.532  -5.641  21.770  1.00 27.87           C  
ATOM     38  O   ASP A 227      20.034  -6.747  21.566  1.00 29.47           O  
ATOM     39  N   LYS A 228      21.319  -5.033  20.885  1.00 25.68           N  
ATOM     40  CA  LYS A 228      21.702  -5.682  19.633  1.00 21.85           C  
ATOM     41  C   LYS A 228      23.121  -6.198  19.856  1.00 19.64           C  
ATOM     42  O   LYS A 228      23.804  -5.754  20.781  1.00 17.62           O  
ATOM     43  CB  LYS A 228      21.679  -4.688  18.470  1.00 24.47           C  
ATOM     44  CG  LYS A 228      20.285  -4.402  17.927  1.00 25.38           C  
ATOM     45  CD  LYS A 228      19.736  -5.602  17.179  1.00 28.70           C  
ATOM     46  N   GLU A 229      23.561  -7.130  19.016  1.00 16.95           N  
ATOM     47  CA  GLU A 229      24.895  -7.715  19.154  1.00 16.35           C  
ATOM     48  C   GLU A 229      26.062  -6.824  18.725  1.00 12.78           C  
ATOM     49  O   GLU A 229      25.881  -5.826  18.026  1.00 11.38           O  
ATOM     50  CB  GLU A 229      24.966  -9.032  18.375  1.00 20.53           C  
ATOM     51  CG  GLU A 229      23.946 -10.068  18.819  1.00 30.64           C  
ATOM     52  CD  GLU A 229      24.012 -10.347  20.315  1.00 37.11           C  
ATOM     53  OE1 GLU A 229      25.053 -10.869  20.770  1.00 42.55           O  
ATOM     54  OE2 GLU A 229      23.029 -10.048  21.034  1.00 38.42           O  
ATOM     55  N   PHE A 230      27.258  -7.208  19.169  1.00 11.48           N  
ATOM     56  CA  PHE A 230      28.509  -6.526  18.849  1.00 10.37           C  
ATOM     57  C   PHE A 230      28.805  -5.207  19.554  1.00 11.66           C  
ATOM     58  O   PHE A 230      27.968  -4.299  19.607  1.00 12.79           O  
ATOM     59  CB  PHE A 230      28.619  -6.331  17.339  1.00 12.49           C  
ATOM     60  CG  PHE A 230      28.428  -7.597  16.561  1.00 12.68           C  
ATOM     61  CD1 PHE A 230      27.349  -7.741  15.693  1.00 13.65           C  
ATOM     62  CD2 PHE A 230      29.312  -8.661  16.718  1.00 13.27           C  
ATOM     63  CE1 PHE A 230      27.148  -8.931  14.989  1.00 12.62           C  
ATOM     64  CE2 PHE A 230      29.123  -9.857  16.021  1.00 13.61           C  
ATOM     65  CZ  PHE A 230      28.035  -9.991  15.152  1.00 13.56           C  
ATOM     66  N   GLY A 231      30.021  -5.125  20.088  1.00 11.97           N  
ATOM     67  CA  GLY A 231      30.476  -3.936  20.782  1.00 11.25           C  
ATOM     68  C   GLY A 231      31.795  -3.480  20.191  1.00 11.24           C  
ATOM     69  O   GLY A 231      32.359  -4.152  19.330  1.00 10.14           O  
ATOM     70  N   ILE A 232      32.294  -2.340  20.653  1.00 10.76           N  
ATOM     71  CA  ILE A 232      33.548  -1.809  20.148  1.00  9.56           C  
ATOM     72  C   ILE A 232      34.664  -2.843  20.301  1.00  9.73           C  
ATOM     73  O   ILE A 232      34.781  -3.496  21.337  1.00 10.05           O  
ATOM     74  CB  ILE A 232      33.922  -0.498  20.883  1.00 10.19           C  
ATOM     75  CG1 ILE A 232      32.936   0.615  20.485  1.00 10.55           C  
ATOM     76  CG2 ILE A 232      35.353  -0.098  20.550  1.00 10.83           C  
ATOM     77  CD1 ILE A 232      33.091   1.899  21.275  1.00 10.65           C  
ATOM     78  N   GLY A 233      35.458  -3.004  19.246  1.00 10.18           N  
ATOM     79  CA  GLY A 233      36.554  -3.956  19.271  1.00  8.66           C  
ATOM     80  C   GLY A 233      36.225  -5.326  18.710  1.00  9.29           C  
ATOM     81  O   GLY A 233      37.132  -6.091  18.386  1.00 11.27           O  
ATOM     82  N   ASP A 234      34.941  -5.649  18.588  1.00  8.71           N  
ATOM     83  CA  ASP A 234      34.542  -6.956  18.069  1.00  8.52           C  
ATOM     84  C   ASP A 234      34.937  -7.158  16.610  1.00  9.24           C  
ATOM     85  O   ASP A 234      34.734  -6.279  15.770  1.00  8.63           O  
ATOM     86  CB  ASP A 234      33.032  -7.155  18.203  1.00  9.40           C  
ATOM     87  CG  ASP A 234      32.598  -7.398  19.631  1.00 10.37           C  
ATOM     88  OD1 ASP A 234      33.470  -7.555  20.514  1.00 12.85           O  
ATOM     89  OD2 ASP A 234      31.377  -7.427  19.873  1.00 12.66           O  
ATOM     90  N   LEU A 235      35.510  -8.324  16.326  1.00  8.18           N  
ATOM     91  CA  LEU A 235      35.918  -8.686  14.973  1.00  7.47           C  
ATOM     92  C   LEU A 235      34.692  -9.305  14.304  1.00  8.14           C  
ATOM     93  O   LEU A 235      34.029 -10.175  14.875  1.00  7.76           O  
ATOM     94  CB  LEU A 235      37.080  -9.686  15.021  1.00  6.74           C  
ATOM     95  CG  LEU A 235      38.282  -9.233  15.871  1.00  8.24           C  
ATOM     96  CD1 LEU A 235      39.426 -10.228  15.751  1.00  9.30           C  
ATOM     97  CD2 LEU A 235      38.745  -7.866  15.415  1.00  9.02           C  
ATOM     98  N   VAL A 236      34.397  -8.862  13.091  1.00  8.14           N  
ATOM     99  CA  VAL A 236      33.220  -9.335  12.392  1.00  8.28           C  
ATOM    100  C   VAL A 236      33.441  -9.448  10.895  1.00  7.89           C  
ATOM    101  O   VAL A 236      34.496  -9.086  10.388  1.00  8.41           O  
ATOM    102  CB  VAL A 236      32.055  -8.346  12.610  1.00  9.77           C  
ATOM    103  CG1 VAL A 236      31.742  -8.202  14.093  1.00  5.62           C  
ATOM    104  CG2 VAL A 236      32.431  -6.988  12.016  1.00  9.31           C  
ATOM    105  N   TRP A 237      32.429  -9.968  10.201  1.00  7.61           N  
ATOM    106  CA  TRP A 237      32.433 -10.065   8.745  1.00  7.43           C  
ATOM    107  C   TRP A 237      31.248  -9.188   8.335  1.00  8.43           C  
ATOM    108  O   TRP A 237      30.204  -9.193   9.003  1.00  8.01           O  
ATOM    109  CB  TRP A 237      32.132 -11.479   8.244  1.00  6.88           C  
ATOM    110  CG  TRP A 237      33.178 -12.515   8.487  1.00  7.92           C  
ATOM    111  CD1 TRP A 237      33.210 -13.412   9.513  1.00  7.90           C  
ATOM    112  CD2 TRP A 237      34.280 -12.841   7.631  1.00  6.84           C  
ATOM    113  NE1 TRP A 237      34.259 -14.282   9.348  1.00  7.87           N  
ATOM    114  CE2 TRP A 237      34.933 -13.956   8.200  1.00  8.35           C  
ATOM    115  CE3 TRP A 237      34.776 -12.303   6.436  1.00  6.74           C  
ATOM    116  CZ2 TRP A 237      36.064 -14.547   7.614  1.00  8.54           C  
ATOM    117  CZ3 TRP A 237      35.902 -12.889   5.850  1.00  9.04           C  
ATOM    118  CH2 TRP A 237      36.531 -14.000   6.443  1.00  9.88           C  
ATOM    119  N   GLY A 238      31.402  -8.448   7.242  1.00  7.59           N  
ATOM    120  CA  GLY A 238      30.316  -7.607   6.765  1.00  9.00           C  
ATOM    121  C   GLY A 238      30.278  -7.678   5.254  1.00 11.04           C  
ATOM    122  O   GLY A 238      31.297  -7.957   4.627  1.00 12.25           O  
ATOM    123  N   LYS A 239      29.116  -7.441   4.658  1.00 12.38           N  
ATOM    124  CA  LYS A 239      29.013  -7.488   3.207  1.00 16.90           C  
ATOM    125  C   LYS A 239      29.321  -6.120   2.592  1.00 19.78           C  
ATOM    126  O   LYS A 239      28.783  -5.095   3.013  1.00 18.65           O  
ATOM    127  CB  LYS A 239      27.620  -7.963   2.792  1.00 18.60           C  
ATOM    128  CG  LYS A 239      27.363  -9.434   3.098  1.00 21.72           C  
ATOM    129  CD  LYS A 239      26.103  -9.941   2.401  1.00 23.77           C  
ATOM    130  CE  LYS A 239      24.993 -10.247   3.398  1.00 24.46           C  
ATOM    131  NZ  LYS A 239      23.839 -10.970   2.769  1.00 28.19           N  
ATOM    132  N   ILE A 240      30.212  -6.125   1.605  1.00 23.81           N  
ATOM    133  CA  ILE A 240      30.639  -4.916   0.898  1.00 27.98           C  
ATOM    134  C   ILE A 240      31.429  -5.359  -0.335  1.00 31.50           C  
ATOM    135  O   ILE A 240      31.890  -6.501  -0.399  1.00 31.56           O  
ATOM    136  CB  ILE A 240      31.564  -4.032   1.779  1.00 27.63           C  
ATOM    137  CG1 ILE A 240      31.800  -2.675   1.100  1.00 27.23           C  
ATOM    138  CG2 ILE A 240      32.902  -4.733   2.005  1.00 24.99           C  
ATOM    139  CD1 ILE A 240      30.817  -1.586   1.511  1.00 26.87           C  
ATOM    140  N   LYS A 241      31.594  -4.457  -1.302  1.00 34.42           N  
ATOM    141  CA  LYS A 241      32.323  -4.774  -2.532  1.00 37.67           C  
ATOM    142  C   LYS A 241      31.595  -5.914  -3.239  1.00 40.80           C  
ATOM    143  O   LYS A 241      32.220  -6.853  -3.736  1.00 41.17           O  
ATOM    144  CB  LYS A 241      33.760  -5.205  -2.215  1.00 36.19           C  
ATOM    145  CG  LYS A 241      34.738  -4.062  -2.055  1.00 34.37           C  
ATOM    146  CD  LYS A 241      36.090  -4.577  -1.615  1.00 32.57           C  
ATOM    147  CE  LYS A 241      36.363  -4.199  -0.177  1.00 32.35           C  
ATOM    148  NZ  LYS A 241      37.818  -4.040   0.074  1.00 33.31           N  
ATOM    149  N   GLY A 242      30.266  -5.823  -3.269  1.00 43.47           N  
ATOM    150  CA  GLY A 242      29.457  -6.854  -3.896  1.00 45.58           C  
ATOM    151  C   GLY A 242      28.691  -7.668  -2.865  1.00 46.50           C  
ATOM    152  O   GLY A 242      28.101  -7.110  -1.933  1.00 47.81           O  
ATOM    153  N   PHE A 243      28.694  -8.988  -3.037  1.00 46.23           N  
ATOM    154  CA  PHE A 243      28.005  -9.866  -2.105  1.00 44.62           C  
ATOM    155  C   PHE A 243      29.020 -10.705  -1.350  1.00 42.60           C  
ATOM    156  O   PHE A 243      28.731 -11.815  -0.894  1.00 44.34           O  
ATOM    157  N   SER A 244      30.224 -10.161  -1.221  1.00 38.41           N  
ATOM    158  CA  SER A 244      31.300 -10.852  -0.535  1.00 33.29           C  
ATOM    159  C   SER A 244      31.417 -10.402   0.910  1.00 27.55           C  
ATOM    160  O   SER A 244      31.176  -9.238   1.238  1.00 27.19           O  
ATOM    161  CB  SER A 244      32.626 -10.598  -1.259  1.00 35.97           C  
ATOM    162  OG  SER A 244      32.592  -9.376  -1.979  1.00 37.51           O  
ATOM    163  N   TRP A 245      31.781 -11.338   1.773  1.00 20.71           N  
ATOM    164  CA  TRP A 245      31.961 -11.034   3.179  1.00 15.53           C  
ATOM    165  C   TRP A 245      33.406 -10.581   3.358  1.00 14.38           C  
ATOM    166  O   TRP A 245      34.341 -11.254   2.920  1.00 12.10           O  
ATOM    167  CB  TRP A 245      31.694 -12.273   4.026  1.00 13.63           C  
ATOM    168  CG  TRP A 245      30.239 -12.625   4.115  1.00 13.02           C  
ATOM    169  CD1 TRP A 245      29.578 -13.573   3.388  1.00 13.26           C  
ATOM    170  CD2 TRP A 245      29.262 -12.028   4.979  1.00 12.43           C  
ATOM    171  NE1 TRP A 245      28.250 -13.605   3.746  1.00 12.32           N  
ATOM    172  CE2 TRP A 245      28.030 -12.667   4.721  1.00 12.18           C  
ATOM    173  CE3 TRP A 245      29.310 -11.016   5.949  1.00 10.68           C  
ATOM    174  CZ2 TRP A 245      26.853 -12.328   5.394  1.00 12.02           C  
ATOM    175  CZ3 TRP A 245      28.135 -10.676   6.623  1.00 11.09           C  
ATOM    176  CH2 TRP A 245      26.925 -11.335   6.339  1.00 12.12           C  
ATOM    177  N   TRP A 246      33.582  -9.428   3.985  1.00 12.26           N  
ATOM    178  CA  TRP A 246      34.913  -8.903   4.221  1.00 12.53           C  
ATOM    179  C   TRP A 246      35.099  -8.703   5.716  1.00 10.66           C  
ATOM    180  O   TRP A 246      34.160  -8.342   6.427  1.00 10.55           O  
ATOM    181  CB  TRP A 246      35.114  -7.583   3.466  1.00 12.43           C  
ATOM    182  CG  TRP A 246      35.407  -7.795   2.006  1.00 16.18           C  
ATOM    183  CD1 TRP A 246      34.516  -8.167   1.037  1.00 15.82           C  
ATOM    184  CD2 TRP A 246      36.682  -7.679   1.356  1.00 14.29           C  
ATOM    185  NE1 TRP A 246      35.158  -8.289  -0.177  1.00 16.14           N  
ATOM    186  CE2 TRP A 246      36.487  -7.997  -0.008  1.00 14.18           C  
ATOM    187  CE3 TRP A 246      37.969  -7.339   1.794  1.00 13.75           C  
ATOM    188  CZ2 TRP A 246      37.532  -7.985  -0.940  1.00 15.41           C  
ATOM    189  CZ3 TRP A 246      39.010  -7.326   0.866  1.00 13.82           C  
ATOM    190  CH2 TRP A 246      38.781  -7.647  -0.484  1.00 14.48           C  
ATOM    191  N   PRO A 247      36.321  -8.939   6.212  1.00 10.91           N  
ATOM    192  CA  PRO A 247      36.627  -8.789   7.637  1.00  9.66           C  
ATOM    193  C   PRO A 247      36.706  -7.333   8.084  1.00 10.02           C  
ATOM    194  O   PRO A 247      37.178  -6.464   7.347  1.00  9.20           O  
ATOM    195  CB  PRO A 247      37.961  -9.509   7.789  1.00 10.83           C  
ATOM    196  CG  PRO A 247      38.617  -9.334   6.453  1.00  9.99           C  
ATOM    197  CD  PRO A 247      37.505  -9.360   5.436  1.00  9.59           C  
ATOM    198  N   ALA A 248      36.248  -7.079   9.304  1.00  9.05           N  
ATOM    199  CA  ALA A 248      36.246  -5.733   9.853  1.00  8.83           C  
ATOM    200  C   ALA A 248      36.208  -5.789  11.371  1.00  8.34           C  
ATOM    201  O   ALA A 248      36.091  -6.862  11.963  1.00  7.60           O  
ATOM    202  CB  ALA A 248      35.022  -4.956   9.331  1.00  8.88           C  
ATOM    203  N   MET A 249      36.323  -4.622  11.995  1.00  7.41           N  
ATOM    204  CA  MET A 249      36.263  -4.525  13.442  1.00  8.11           C  
ATOM    205  C   MET A 249      35.299  -3.407  13.796  1.00  6.96           C  
ATOM    206  O   MET A 249      35.306  -2.349  13.168  1.00  5.89           O  
ATOM    207  CB  MET A 249      37.637  -4.217  14.043  1.00  9.12           C  
ATOM    208  CG  MET A 249      37.606  -4.147  15.563  1.00  8.89           C  
ATOM    209  SD  MET A 249      39.213  -3.877  16.324  1.00 13.17           S  
ATOM    210  CE  MET A 249      39.553  -2.209  15.796  1.00 15.27           C  
ATOM    211  N   VAL A 250      34.455  -3.654  14.787  1.00  7.25           N  
ATOM    212  CA  VAL A 250      33.511  -2.638  15.212  1.00  8.08           C  
ATOM    213  C   VAL A 250      34.306  -1.548  15.918  1.00  8.50           C  
ATOM    214  O   VAL A 250      35.136  -1.830  16.782  1.00  8.37           O  
ATOM    215  CB  VAL A 250      32.452  -3.219  16.175  1.00 10.64           C  
ATOM    216  CG1 VAL A 250      31.539  -2.104  16.677  1.00  9.94           C  
ATOM    217  CG2 VAL A 250      31.626  -4.289  15.455  1.00  8.48           C  
ATOM    218  N   VAL A 251      34.071  -0.301  15.530  1.00  9.22           N  
ATOM    219  CA  VAL A 251      34.781   0.817  16.139  1.00  9.03           C  
ATOM    220  C   VAL A 251      33.815   1.865  16.652  1.00 10.73           C  
ATOM    221  O   VAL A 251      32.612   1.826  16.365  1.00  9.77           O  
ATOM    222  CB  VAL A 251      35.735   1.502  15.136  1.00  8.45           C  
ATOM    223  CG1 VAL A 251      36.806   0.516  14.681  1.00  9.80           C  
ATOM    224  CG2 VAL A 251      34.953   2.050  13.949  1.00  6.84           C  
ATOM    225  N   SER A 252      34.344   2.804  17.427  1.00 12.23           N  
ATOM    226  CA  SER A 252      33.522   3.880  17.948  1.00 12.31           C  
ATOM    227  C   SER A 252      33.336   4.881  16.819  1.00 13.46           C  
ATOM    228  O   SER A 252      34.215   5.042  15.964  1.00 12.40           O  
ATOM    229  CB  SER A 252      34.205   4.572  19.126  1.00 13.49           C  
ATOM    230  OG  SER A 252      33.567   5.808  19.409  1.00 12.65           O  
ATOM    231  N   TRP A 253      32.185   5.541  16.810  1.00 11.31           N  
ATOM    232  CA  TRP A 253      31.895   6.537  15.795  1.00 11.06           C  
ATOM    233  C   TRP A 253      32.976   7.612  15.804  1.00 11.60           C  
ATOM    234  O   TRP A 253      33.215   8.283  14.795  1.00 11.95           O  
ATOM    235  CB  TRP A 253      30.538   7.183  16.077  1.00 12.03           C  
ATOM    236  CG  TRP A 253      30.578   8.164  17.217  1.00 13.24           C  
ATOM    237  CD1 TRP A 253      30.472   7.880  18.548  1.00 12.96           C  
ATOM    238  CD2 TRP A 253      30.727   9.584  17.118  1.00 13.59           C  
ATOM    239  NE1 TRP A 253      30.543   9.040  19.286  1.00 13.98           N  
ATOM    240  CE2 TRP A 253      30.699  10.100  18.432  1.00 15.15           C  
ATOM    241  CE3 TRP A 253      30.879  10.472  16.047  1.00 13.91           C  
ATOM    242  CZ2 TRP A 253      30.817  11.467  18.704  1.00 16.42           C  
ATOM    243  CZ3 TRP A 253      30.996  11.831  16.316  1.00 15.93           C  
ATOM    244  CH2 TRP A 253      30.963  12.314  17.635  1.00 15.01           C  
ATOM    245  N   LYS A 254      33.625   7.772  16.952  1.00 13.22           N  
ATOM    246  CA  LYS A 254      34.663   8.781  17.105  1.00 15.64           C  
ATOM    247  C   LYS A 254      35.793   8.599  16.096  1.00 18.42           C  
ATOM    248  O   LYS A 254      36.444   9.564  15.697  1.00 19.71           O  
ATOM    249  CB  LYS A 254      35.218   8.742  18.533  1.00 16.45           C  
ATOM    250  CG  LYS A 254      34.406   9.557  19.536  1.00 14.78           C  
ATOM    251  CD  LYS A 254      34.512   8.981  20.937  1.00 17.24           C  
ATOM    252  N   ALA A 255      36.006   7.359  15.669  1.00 19.19           N  
ATOM    253  CA  ALA A 255      37.065   7.031  14.721  1.00 19.22           C  
ATOM    254  C   ALA A 255      36.715   7.322  13.268  1.00 19.19           C  
ATOM    255  O   ALA A 255      37.599   7.441  12.421  1.00 20.02           O  
ATOM    256  CB  ALA A 255      37.434   5.552  14.863  1.00 18.11           C  
ATOM    257  N   THR A 256      35.427   7.454  12.986  1.00 18.48           N  
ATOM    258  CA  THR A 256      34.952   7.654  11.623  1.00 18.53           C  
ATOM    259  C   THR A 256      34.940   9.063  11.059  1.00 20.83           C  
ATOM    260  O   THR A 256      34.995   9.234   9.842  1.00 21.72           O  
ATOM    261  CB  THR A 256      33.527   7.115  11.481  1.00 16.29           C  
ATOM    262  OG1 THR A 256      32.623   7.996  12.162  1.00 13.66           O  
ATOM    263  CG2 THR A 256      33.425   5.729  12.082  1.00 13.80           C  
ATOM    264  N   SER A 257      34.846  10.062  11.931  1.00 22.56           N  
ATOM    265  CA  SER A 257      34.778  11.453  11.502  1.00 25.18           C  
ATOM    266  C   SER A 257      33.385  11.726  10.951  1.00 25.85           C  
ATOM    267  O   SER A 257      33.188  12.642  10.153  1.00 26.78           O  
ATOM    268  CB  SER A 257      35.814  11.743  10.417  1.00 28.08           C  
ATOM    269  OG  SER A 257      37.128  11.669  10.942  1.00 34.60           O  
ATOM    270  N   LYS A 258      32.420  10.920  11.373  1.00 23.91           N  
ATOM    271  CA  LYS A 258      31.048  11.085  10.920  1.00 22.98           C  
ATOM    272  C   LYS A 258      30.155  11.469  12.100  1.00 22.04           C  
ATOM    273  O   LYS A 258      30.318  12.534  12.697  1.00 26.05           O  
ATOM    274  CB  LYS A 258      30.550   9.788  10.277  1.00 22.75           C  
ATOM    275  CG  LYS A 258      31.387   9.323   9.103  1.00 25.50           C  
ATOM    276  CD  LYS A 258      30.836   9.860   7.796  1.00 27.35           C  
ATOM    277  CE  LYS A 258      31.927  10.013   6.747  1.00 30.17           C  
ATOM    278  NZ  LYS A 258      31.340  10.295   5.410  1.00 30.75           N  
ATOM    279  N   ARG A 259      29.207  10.604  12.425  1.00 18.87           N  
ATOM    280  CA  ARG A 259      28.296  10.849  13.531  1.00 14.62           C  
ATOM    281  C   ARG A 259      28.056   9.517  14.216  1.00 12.74           C  
ATOM    282  O   ARG A 259      28.469   8.468  13.720  1.00 13.27           O  
ATOM    283  CB  ARG A 259      26.961  11.408  13.016  1.00 12.89           C  
ATOM    284  CG  ARG A 259      26.366  10.625  11.842  1.00 13.58           C  
ATOM    285  CD  ARG A 259      24.843  10.442  11.945  1.00 13.33           C  
ATOM    286  NE  ARG A 259      24.311   9.721  10.787  1.00 12.97           N  
ATOM    287  CZ  ARG A 259      24.256   8.395  10.689  1.00 13.96           C  
ATOM    288  NH1 ARG A 259      24.697   7.633  11.682  1.00 11.86           N  
ATOM    289  NH2 ARG A 259      23.779   7.824   9.586  1.00 12.49           N  
ATOM    290  N   GLN A 260      27.390   9.559  15.359  1.00 10.26           N  
ATOM    291  CA  GLN A 260      27.081   8.341  16.080  1.00 10.69           C  
ATOM    292  C   GLN A 260      26.224   7.479  15.155  1.00 10.30           C  
ATOM    293  O   GLN A 260      25.467   8.004  14.334  1.00  9.41           O  
ATOM    294  CB  GLN A 260      26.319   8.677  17.366  1.00 12.45           C  
ATOM    295  CG  GLN A 260      27.184   9.358  18.432  1.00 16.69           C  
ATOM    296  CD  GLN A 260      27.137  10.888  18.374  1.00 21.01           C  
ATOM    297  OE1 GLN A 260      27.176  11.503  17.293  1.00 16.65           O  
ATOM    298  NE2 GLN A 260      27.057  11.511  19.547  1.00 21.74           N  
ATOM    299  N   ALA A 261      26.357   6.161  15.270  1.00 10.33           N  
ATOM    300  CA  ALA A 261      25.580   5.254  14.434  1.00 11.61           C  
ATOM    301  C   ALA A 261      24.087   5.339  14.765  1.00 12.16           C  
ATOM    302  O   ALA A 261      23.699   5.640  15.902  1.00 11.99           O  
ATOM    303  CB  ALA A 261      26.074   3.824  14.620  1.00 10.09           C  
ATOM    304  N   MET A 262      23.251   5.082  13.767  1.00 12.35           N  
ATOM    305  CA  MET A 262      21.804   5.108  13.957  1.00 13.30           C  
ATOM    306  C   MET A 262      21.460   3.980  14.930  1.00 13.94           C  
ATOM    307  O   MET A 262      22.244   3.048  15.108  1.00 13.69           O  
ATOM    308  CB  MET A 262      21.093   4.882  12.618  1.00 13.38           C  
ATOM    309  CG  MET A 262      21.408   5.930  11.555  1.00 14.73           C  
ATOM    310  SD  MET A 262      20.839   7.567  12.048  1.00 18.37           S  
ATOM    311  CE  MET A 262      19.084   7.272  12.165  1.00 13.62           C  
ATOM    312  N   PRO A 263      20.293   4.056  15.590  1.00 14.97           N  
ATOM    313  CA  PRO A 263      19.959   2.974  16.521  1.00 14.55           C  
ATOM    314  C   PRO A 263      20.012   1.590  15.864  1.00 14.71           C  
ATOM    315  O   PRO A 263      19.513   1.393  14.755  1.00 14.06           O  
ATOM    316  CB  PRO A 263      18.558   3.340  17.010  1.00 15.18           C  
ATOM    317  CG  PRO A 263      18.472   4.818  16.810  1.00 14.86           C  
ATOM    318  CD  PRO A 263      19.255   5.102  15.565  1.00 13.65           C  
ATOM    319  N   GLY A 264      20.649   0.645  16.550  1.00 14.87           N  
ATOM    320  CA  GLY A 264      20.759  -0.710  16.036  1.00 14.56           C  
ATOM    321  C   GLY A 264      21.866  -0.930  15.020  1.00 13.23           C  
ATOM    322  O   GLY A 264      22.067  -2.054  14.553  1.00 11.81           O  
ATOM    323  N   MET A 265      22.583   0.136  14.675  1.00 10.92           N  
ATOM    324  CA  MET A 265      23.662   0.046  13.705  1.00  8.88           C  
ATOM    325  C   MET A 265      25.025   0.157  14.382  1.00  9.19           C  
ATOM    326  O   MET A 265      25.119   0.502  15.565  1.00  8.80           O  
ATOM    327  CB  MET A 265      23.504   1.139  12.646  1.00  8.90           C  
ATOM    328  CG  MET A 265      22.122   1.178  12.003  1.00 11.16           C  
ATOM    329  SD  MET A 265      22.137   2.044  10.421  1.00 13.84           S  
ATOM    330  CE  MET A 265      23.077   0.858   9.395  1.00 12.16           C  
ATOM    331  N   ARG A 266      26.075  -0.141  13.622  1.00  8.63           N  
ATOM    332  CA  ARG A 266      27.445  -0.104  14.127  1.00  9.33           C  
ATOM    333  C   ARG A 266      28.394   0.465  13.084  1.00  8.35           C  
ATOM    334  O   ARG A 266      28.150   0.353  11.885  1.00  9.14           O  
ATOM    335  CB  ARG A 266      27.938  -1.524  14.466  1.00  8.56           C  
ATOM    336  CG  ARG A 266      27.016  -2.352  15.340  1.00  7.61           C  
ATOM    337  CD  ARG A 266      27.138  -1.917  16.788  1.00  9.02           C  
ATOM    338  NE  ARG A 266      26.404  -2.765  17.727  1.00  8.96           N  
ATOM    339  CZ  ARG A 266      25.222  -2.456  18.250  1.00 10.00           C  
ATOM    340  NH1 ARG A 266      24.629  -1.316  17.923  1.00  9.87           N  
ATOM    341  NH2 ARG A 266      24.649  -3.267  19.132  1.00 10.64           N  
ATOM    342  N   TRP A 267      29.475   1.080  13.546  1.00  8.56           N  
ATOM    343  CA  TRP A 267      30.489   1.581  12.634  1.00  7.69           C  
ATOM    344  C   TRP A 267      31.539   0.484  12.641  1.00  8.56           C  
ATOM    345  O   TRP A 267      31.901  -0.031  13.703  1.00  7.94           O  
ATOM    346  CB  TRP A 267      31.118   2.879  13.143  1.00  7.13           C  
ATOM    347  CG  TRP A 267      30.308   4.085  12.842  1.00  7.71           C  
ATOM    348  CD1 TRP A 267      29.582   4.823  13.728  1.00  8.50           C  
ATOM    349  CD2 TRP A 267      30.110   4.689  11.555  1.00  8.78           C  
ATOM    350  NE1 TRP A 267      28.945   5.850  13.078  1.00  8.79           N  
ATOM    351  CE2 TRP A 267      29.251   5.792  11.743  1.00  6.44           C  
ATOM    352  CE3 TRP A 267      30.578   4.403  10.261  1.00  7.65           C  
ATOM    353  CZ2 TRP A 267      28.846   6.616  10.686  1.00  6.90           C  
ATOM    354  CZ3 TRP A 267      30.174   5.225   9.206  1.00 10.82           C  
ATOM    355  CH2 TRP A 267      29.315   6.320   9.430  1.00  8.15           C  
ATOM    356  N   VAL A 268      31.994   0.094  11.460  1.00  8.47           N  
ATOM    357  CA  VAL A 268      33.024  -0.925  11.361  1.00  8.60           C  
ATOM    358  C   VAL A 268      34.144  -0.405  10.480  1.00  8.08           C  
ATOM    359  O   VAL A 268      33.905   0.365   9.545  1.00  8.90           O  
ATOM    360  CB  VAL A 268      32.504  -2.255  10.731  1.00  8.40           C  
ATOM    361  CG1 VAL A 268      31.306  -2.789  11.517  1.00  9.00           C  
ATOM    362  CG2 VAL A 268      32.156  -2.044   9.268  1.00  8.59           C  
ATOM    363  N   GLN A 269      35.371  -0.801  10.795  1.00  6.91           N  
ATOM    364  CA  GLN A 269      36.503  -0.410   9.974  1.00  8.48           C  
ATOM    365  C   GLN A 269      36.999  -1.683   9.288  1.00  7.81           C  
ATOM    366  O   GLN A 269      37.386  -2.651   9.953  1.00  6.67           O  
ATOM    367  CB  GLN A 269      37.625   0.212  10.811  1.00  8.12           C  
ATOM    368  CG  GLN A 269      38.778   0.690   9.924  1.00 10.17           C  
ATOM    369  CD  GLN A 269      39.852   1.426  10.680  1.00 13.90           C  
ATOM    370  OE1 GLN A 269      40.519   2.319  10.128  1.00 14.60           O  
ATOM    371  NE2 GLN A 269      40.037   1.063  11.946  1.00 11.21           N  
ATOM    372  N   TRP A 270      36.952  -1.680   7.959  1.00  7.94           N  
ATOM    373  CA  TRP A 270      37.383  -2.829   7.162  1.00  7.08           C  
ATOM    374  C   TRP A 270      38.879  -3.068   7.274  1.00  8.10           C  
ATOM    375  O   TRP A 270      39.674  -2.128   7.173  1.00  7.33           O  
ATOM    376  CB  TRP A 270      37.045  -2.610   5.688  1.00  7.56           C  
ATOM    377  CG  TRP A 270      35.615  -2.304   5.454  1.00  8.81           C  
ATOM    378  CD1 TRP A 270      35.070  -1.081   5.181  1.00  6.95           C  
ATOM    379  CD2 TRP A 270      34.527  -3.230   5.506  1.00  9.40           C  
ATOM    380  NE1 TRP A 270      33.710  -1.188   5.063  1.00 10.21           N  
ATOM    381  CE2 TRP A 270      33.346  -2.496   5.258  1.00 10.67           C  
ATOM    382  CE3 TRP A 270      34.433  -4.612   5.740  1.00  8.56           C  
ATOM    383  CZ2 TRP A 270      32.081  -3.097   5.235  1.00  9.68           C  
ATOM    384  CZ3 TRP A 270      33.178  -5.211   5.718  1.00  6.68           C  
ATOM    385  CH2 TRP A 270      32.018  -4.450   5.467  1.00  9.07           C  
ATOM    386  N   PHE A 271      39.258  -4.324   7.484  1.00  8.33           N  
ATOM    387  CA  PHE A 271      40.669  -4.672   7.562  1.00  9.74           C  
ATOM    388  C   PHE A 271      41.191  -4.548   6.137  1.00 10.64           C  
ATOM    389  O   PHE A 271      40.461  -4.824   5.181  1.00 11.12           O  
ATOM    390  CB  PHE A 271      40.838  -6.102   8.086  1.00  9.04           C  
ATOM    391  CG  PHE A 271      40.761  -6.204   9.582  1.00  8.35           C  
ATOM    392  CD1 PHE A 271      39.621  -6.701  10.202  1.00  9.29           C  
ATOM    393  CD2 PHE A 271      41.817  -5.765  10.376  1.00 10.26           C  
ATOM    394  CE1 PHE A 271      39.530  -6.759  11.592  1.00  8.06           C  
ATOM    395  CE2 PHE A 271      41.738  -5.817  11.766  1.00  9.62           C  
ATOM    396  CZ  PHE A 271      40.591  -6.315  12.373  1.00  9.45           C  
ATOM    397  N   GLY A 272      42.437  -4.115   5.987  1.00 11.18           N  
ATOM    398  CA  GLY A 272      42.985  -3.953   4.657  1.00 13.08           C  
ATOM    399  C   GLY A 272      42.973  -2.496   4.242  1.00 15.47           C  
ATOM    400  O   GLY A 272      43.987  -1.814   4.382  1.00 17.65           O  
ATOM    401  N   ASP A 273      41.838  -2.001   3.747  1.00 14.78           N  
ATOM    402  CA  ASP A 273      41.761  -0.600   3.326  1.00 15.76           C  
ATOM    403  C   ASP A 273      41.464   0.401   4.449  1.00 15.12           C  
ATOM    404  O   ASP A 273      41.592   1.611   4.259  1.00 14.90           O  
ATOM    405  CB  ASP A 273      40.754  -0.427   2.173  1.00 18.28           C  
ATOM    406  CG  ASP A 273      39.305  -0.699   2.579  1.00 18.98           C  
ATOM    407  OD1 ASP A 273      38.952  -0.576   3.767  1.00 18.69           O  
ATOM    408  OD2 ASP A 273      38.506  -1.031   1.682  1.00 22.34           O  
ATOM    409  N   GLY A 274      41.075  -0.101   5.617  1.00 12.16           N  
ATOM    410  CA  GLY A 274      40.810   0.777   6.746  1.00 10.80           C  
ATOM    411  C   GLY A 274      39.674   1.774   6.603  1.00  9.71           C  
ATOM    412  O   GLY A 274      39.581   2.719   7.386  1.00 10.17           O  
ATOM    413  N   LYS A 275      38.810   1.571   5.614  1.00  9.29           N  
ATOM    414  CA  LYS A 275      37.670   2.459   5.404  1.00  9.88           C  
ATOM    415  C   LYS A 275      36.586   2.136   6.431  1.00  9.68           C  
ATOM    416  O   LYS A 275      36.633   1.091   7.082  1.00  8.29           O  
ATOM    417  CB  LYS A 275      37.116   2.279   3.992  1.00 11.97           C  
ATOM    418  CG  LYS A 275      38.042   2.802   2.908  1.00 14.96           C  
ATOM    419  CD  LYS A 275      37.279   3.080   1.625  1.00 20.14           C  
ATOM    420  CE  LYS A 275      38.085   3.973   0.699  1.00 24.54           C  
ATOM    421  NZ  LYS A 275      38.517   3.242  -0.524  1.00 29.18           N  
ATOM    422  N   PHE A 276      35.610   3.031   6.575  1.00  9.42           N  
ATOM    423  CA  PHE A 276      34.538   2.833   7.540  1.00  8.74           C  
ATOM    424  C   PHE A 276      33.173   2.696   6.893  1.00  9.56           C  
ATOM    425  O   PHE A 276      32.894   3.322   5.871  1.00  9.17           O  
ATOM    426  CB  PHE A 276      34.478   4.006   8.520  1.00  9.86           C  
ATOM    427  CG  PHE A 276      35.767   4.268   9.239  1.00  8.06           C  
ATOM    428  CD1 PHE A 276      36.634   5.265   8.796  1.00  9.19           C  
ATOM    429  CD2 PHE A 276      36.102   3.537  10.375  1.00  8.51           C  
ATOM    430  CE1 PHE A 276      37.823   5.532   9.479  1.00  7.80           C  
ATOM    431  CE2 PHE A 276      37.290   3.798  11.066  1.00  7.94           C  
ATOM    432  CZ  PHE A 276      38.149   4.801  10.611  1.00  7.38           C  
ATOM    433  N   SER A 277      32.318   1.891   7.518  1.00  8.15           N  
ATOM    434  CA  SER A 277      30.958   1.679   7.038  1.00  7.78           C  
ATOM    435  C   SER A 277      30.004   1.591   8.226  1.00  9.04           C  
ATOM    436  O   SER A 277      30.363   1.038   9.271  1.00  8.25           O  
ATOM    437  CB  SER A 277      30.856   0.368   6.246  1.00  7.33           C  
ATOM    438  OG  SER A 277      31.428   0.485   4.955  1.00  8.01           O  
ATOM    439  N   GLU A 278      28.801   2.146   8.069  1.00  8.80           N  
ATOM    440  CA  GLU A 278      27.777   2.053   9.109  1.00  7.79           C  
ATOM    441  C   GLU A 278      26.901   0.896   8.656  1.00  8.41           C  
ATOM    442  O   GLU A 278      26.321   0.944   7.570  1.00  8.38           O  
ATOM    443  CB  GLU A 278      26.928   3.316   9.186  1.00  7.69           C  
ATOM    444  CG  GLU A 278      25.876   3.245  10.284  1.00  7.74           C  
ATOM    445  CD  GLU A 278      24.992   4.470  10.318  1.00  7.39           C  
ATOM    446  OE1 GLU A 278      24.661   5.000   9.238  1.00  8.79           O  
ATOM    447  OE2 GLU A 278      24.628   4.906  11.426  1.00 10.10           O  
ATOM    448  N   ILE A 279      26.820  -0.144   9.478  1.00  8.85           N  
ATOM    449  CA  ILE A 279      26.046  -1.339   9.143  1.00  7.46           C  
ATOM    450  C   ILE A 279      25.188  -1.781  10.322  1.00  8.07           C  
ATOM    451  O   ILE A 279      25.608  -1.672  11.475  1.00  8.23           O  
ATOM    452  CB  ILE A 279      26.987  -2.523   8.766  1.00  7.95           C  
ATOM    453  CG1 ILE A 279      27.900  -2.122   7.601  1.00  9.63           C  
ATOM    454  CG2 ILE A 279      26.160  -3.763   8.416  1.00  6.33           C  
ATOM    455  CD1 ILE A 279      28.859  -3.224   7.148  1.00 11.11           C  
ATOM    456  N   SER A 280      23.995  -2.287  10.026  1.00  8.21           N  
ATOM    457  CA  SER A 280      23.083  -2.769  11.060  1.00  7.77           C  
ATOM    458  C   SER A 280      23.717  -3.965  11.770  1.00  6.91           C  
ATOM    459  O   SER A 280      24.370  -4.796  11.137  1.00  8.43           O  
ATOM    460  CB  SER A 280      21.748  -3.176  10.425  1.00  7.07           C  
ATOM    461  OG  SER A 280      20.926  -2.041  10.221  0.50  7.87           O  
ATOM    463  N   ALA A 281      23.543  -4.051  13.082  1.00  6.89           N  
ATOM    464  CA  ALA A 281      24.103  -5.172  13.830  1.00  9.25           C  
ATOM    465  C   ALA A 281      23.542  -6.482  13.276  1.00 10.30           C  
ATOM    466  O   ALA A 281      24.200  -7.524  13.323  1.00 10.48           O  
ATOM    467  CB  ALA A 281      23.762  -5.039  15.307  1.00  7.17           C  
ATOM    468  N   ASP A 282      22.323  -6.408  12.742  1.00 11.29           N  
ATOM    469  CA  ASP A 282      21.628  -7.562  12.175  1.00 12.17           C  
ATOM    470  C   ASP A 282      22.163  -7.991  10.806  1.00 12.85           C  
ATOM    471  O   ASP A 282      21.658  -8.948  10.210  1.00 10.73           O  
ATOM    472  CB  ASP A 282      20.131  -7.256  12.055  1.00 17.48           C  
ATOM    473  CG  ASP A 282      19.443  -7.162  13.407  1.00 23.01           C  
ATOM    474  OD1 ASP A 282      19.992  -7.682  14.403  1.00 25.77           O  
ATOM    475  OD2 ASP A 282      18.347  -6.567  13.475  1.00 28.48           O  
ATOM    476  N   LYS A 283      23.174  -7.285  10.305  1.00 12.27           N  
ATOM    477  CA  LYS A 283      23.766  -7.612   9.008  1.00 10.84           C  
ATOM    478  C   LYS A 283      25.234  -8.005   9.159  1.00 10.54           C  
ATOM    479  O   LYS A 283      25.935  -8.246   8.176  1.00  8.57           O  
ATOM    480  CB  LYS A 283      23.645  -6.423   8.052  1.00 12.16           C  
ATOM    481  CG  LYS A 283      22.208  -6.036   7.732  1.00 15.93           C  
ATOM    482  CD  LYS A 283      21.528  -7.101   6.893  1.00 19.06           C  
ATOM    483  CE  LYS A 283      21.104  -6.551   5.544  1.00 24.23           C  
ATOM    484  NZ  LYS A 283      20.237  -5.343   5.690  1.00 27.67           N  
ATOM    485  N   LEU A 284      25.691  -8.062  10.406  1.00  9.94           N  
ATOM    486  CA  LEU A 284      27.068  -8.431  10.694  1.00  9.57           C  
ATOM    487  C   LEU A 284      27.107  -9.800  11.348  1.00  8.62           C  
ATOM    488  O   LEU A 284      26.151 -10.209  12.014  1.00  8.44           O  
ATOM    489  CB  LEU A 284      27.715  -7.423  11.652  1.00  7.41           C  
ATOM    490  CG  LEU A 284      27.878  -5.963  11.227  1.00  6.79           C  
ATOM    491  CD1 LEU A 284      28.405  -5.178  12.412  1.00  9.52           C  
ATOM    492  CD2 LEU A 284      28.826  -5.841  10.046  1.00  8.33           C  
ATOM    493  N   VAL A 285      28.214 -10.507  11.151  1.00  8.80           N  
ATOM    494  CA  VAL A 285      28.394 -11.808  11.772  1.00  9.86           C  
ATOM    495  C   VAL A 285      29.746 -11.799  12.481  1.00  9.74           C  
ATOM    496  O   VAL A 285      30.663 -11.075  12.083  1.00  9.07           O  
ATOM    497  CB  VAL A 285      28.357 -12.958  10.730  1.00 10.54           C  
ATOM    498  CG1 VAL A 285      26.971 -13.028  10.090  1.00 10.17           C  
ATOM    499  CG2 VAL A 285      29.436 -12.752   9.674  1.00 10.42           C  
ATOM    500  N   ALA A 286      29.862 -12.589  13.542  1.00 10.24           N  
ATOM    501  CA  ALA A 286      31.107 -12.668  14.292  1.00  8.78           C  
ATOM    502  C   ALA A 286      32.199 -13.270  13.409  1.00  7.97           C  
ATOM    503  O   ALA A 286      31.935 -14.163  12.604  1.00  7.58           O  
ATOM    504  CB  ALA A 286      30.901 -13.530  15.532  1.00  9.78           C  
ATOM    505  N   LEU A 287      33.423 -12.776  13.542  1.00  7.50           N  
ATOM    506  CA  LEU A 287      34.524 -13.324  12.762  1.00  7.51           C  
ATOM    507  C   LEU A 287      34.688 -14.813  13.108  1.00  9.83           C  
ATOM    508  O   LEU A 287      35.144 -15.612  12.283  1.00  9.60           O  
ATOM    509  CB  LEU A 287      35.820 -12.584  13.076  1.00  9.10           C  
ATOM    510  CG  LEU A 287      36.993 -13.012  12.191  1.00  8.32           C  
ATOM    511  CD1 LEU A 287      36.911 -12.250  10.888  1.00 11.24           C  
ATOM    512  CD2 LEU A 287      38.313 -12.754  12.896  1.00  8.19           C  
ATOM    513  N   GLY A 288      34.307 -15.171  14.334  1.00  9.04           N  
ATOM    514  CA  GLY A 288      34.398 -16.546  14.794  1.00  9.76           C  
ATOM    515  C   GLY A 288      33.762 -17.561  13.862  1.00 10.21           C  
ATOM    516  O   GLY A 288      34.143 -18.732  13.877  1.00 10.22           O  
ATOM    517  N   LEU A 289      32.761 -17.140  13.090  1.00  8.68           N  
ATOM    518  CA  LEU A 289      32.135 -18.025  12.111  1.00  8.14           C  
ATOM    519  C   LEU A 289      33.066 -17.825  10.915  1.00  9.26           C  
ATOM    520  O   LEU A 289      32.693 -17.276   9.870  1.00  7.27           O  
ATOM    521  CB  LEU A 289      30.706 -17.562  11.797  1.00  7.29           C  
ATOM    522  CG  LEU A 289      29.781 -17.538  13.022  1.00  9.17           C  
ATOM    523  CD1 LEU A 289      28.400 -17.023  12.636  1.00  8.86           C  
ATOM    524  CD2 LEU A 289      29.686 -18.936  13.616  1.00 11.17           C  
ATOM    525  N   PHE A 290      34.303 -18.269  11.103  1.00  7.49           N  
ATOM    526  CA  PHE A 290      35.343 -18.094  10.113  1.00  7.72           C  
ATOM    527  C   PHE A 290      35.209 -18.847   8.805  1.00  8.27           C  
ATOM    528  O   PHE A 290      35.095 -18.230   7.740  1.00  6.43           O  
ATOM    529  CB  PHE A 290      36.709 -18.402  10.732  1.00  7.08           C  
ATOM    530  CG  PHE A 290      37.851 -17.901   9.908  1.00  8.64           C  
ATOM    531  CD1 PHE A 290      38.220 -16.559   9.954  1.00  8.29           C  
ATOM    532  CD2 PHE A 290      38.518 -18.753   9.032  1.00  7.45           C  
ATOM    533  CE1 PHE A 290      39.235 -16.074   9.128  1.00  8.79           C  
ATOM    534  CE2 PHE A 290      39.533 -18.275   8.204  1.00  7.73           C  
ATOM    535  CZ  PHE A 290      39.890 -16.935   8.251  1.00  7.08           C  
ATOM    536  N   SER A 291      35.249 -20.173   8.878  1.00  8.70           N  
ATOM    537  CA  SER A 291      35.151 -20.996   7.680  1.00 10.21           C  
ATOM    538  C   SER A 291      33.840 -20.749   6.923  1.00  9.28           C  
ATOM    539  O   SER A 291      33.781 -20.885   5.700  1.00 10.24           O  
ATOM    540  CB  SER A 291      35.302 -22.476   8.058  1.00  9.01           C  
ATOM    541  OG  SER A 291      36.555 -22.703   8.701  1.00 10.53           O  
ATOM    542  N   GLN A 292      32.799 -20.353   7.646  1.00  9.28           N  
ATOM    543  CA  GLN A 292      31.508 -20.095   7.021  1.00  9.31           C  
ATOM    544  C   GLN A 292      31.529 -18.896   6.082  1.00  9.83           C  
ATOM    545  O   GLN A 292      30.857 -18.901   5.051  1.00 11.02           O  
ATOM    546  CB  GLN A 292      30.431 -19.861   8.090  1.00 10.44           C  
ATOM    547  CG  GLN A 292      30.064 -21.092   8.898  1.00  8.91           C  
ATOM    548  CD  GLN A 292      30.816 -21.170  10.208  1.00  9.13           C  
ATOM    549  OE1 GLN A 292      31.920 -20.640  10.338  1.00  8.77           O  
ATOM    550  NE2 GLN A 292      30.224 -21.835  11.190  1.00 10.59           N  
ATOM    551  N   HIS A 293      32.307 -17.871   6.421  1.00  8.69           N  
ATOM    552  CA  HIS A 293      32.329 -16.663   5.606  1.00  9.13           C  
ATOM    553  C   HIS A 293      33.589 -16.383   4.800  1.00  9.10           C  
ATOM    554  O   HIS A 293      33.571 -15.556   3.890  1.00 10.42           O  
ATOM    555  CB  HIS A 293      31.970 -15.468   6.488  1.00  8.90           C  
ATOM    556  CG  HIS A 293      30.653 -15.627   7.179  1.00  8.62           C  
ATOM    557  ND1 HIS A 293      30.506 -16.142   8.449  1.00  9.14           N  
ATOM    558  CD2 HIS A 293      29.395 -15.413   6.721  1.00  8.74           C  
ATOM    559  CE1 HIS A 293      29.193 -16.227   8.715  1.00 10.75           C  
ATOM    560  NE2 HIS A 293      28.475 -15.797   7.696  1.00  7.61           N  
ATOM    561  N   PHE A 294      34.681 -17.060   5.130  1.00  9.78           N  
ATOM    562  CA  PHE A 294      35.918 -16.894   4.387  1.00  8.46           C  
ATOM    563  C   PHE A 294      35.583 -17.403   2.983  1.00  8.50           C  
ATOM    564  O   PHE A 294      34.808 -18.349   2.836  1.00 10.01           O  
ATOM    565  CB  PHE A 294      37.022 -17.746   5.036  1.00 10.02           C  
ATOM    566  CG  PHE A 294      38.303 -17.826   4.236  1.00  9.03           C  
ATOM    567  CD1 PHE A 294      39.297 -16.856   4.385  1.00  8.89           C  
ATOM    568  CD2 PHE A 294      38.530 -18.885   3.361  1.00  8.86           C  
ATOM    569  CE1 PHE A 294      40.496 -16.942   3.673  1.00  8.01           C  
ATOM    570  CE2 PHE A 294      39.727 -18.980   2.644  1.00  9.79           C  
ATOM    571  CZ  PHE A 294      40.708 -18.010   2.800  1.00  8.43           C  
ATOM    572  N   ASN A 295      36.142 -16.770   1.958  1.00  7.46           N  
ATOM    573  CA  ASN A 295      35.895 -17.183   0.584  1.00  8.72           C  
ATOM    574  C   ASN A 295      37.228 -17.506  -0.079  1.00  8.84           C  
ATOM    575  O   ASN A 295      37.977 -16.605  -0.452  1.00 10.63           O  
ATOM    576  CB  ASN A 295      35.186 -16.067  -0.184  1.00 11.76           C  
ATOM    577  CG  ASN A 295      34.694 -16.523  -1.544  1.00 14.92           C  
ATOM    578  OD1 ASN A 295      35.469 -17.016  -2.360  1.00 15.05           O  
ATOM    579  ND2 ASN A 295      33.398 -16.368  -1.791  1.00 16.86           N  
ATOM    580  N   LEU A 296      37.528 -18.791  -0.227  1.00  8.70           N  
ATOM    581  CA  LEU A 296      38.794 -19.204  -0.820  1.00  9.60           C  
ATOM    582  C   LEU A 296      38.991 -18.696  -2.241  1.00  9.28           C  
ATOM    583  O   LEU A 296      40.094 -18.299  -2.614  1.00  9.52           O  
ATOM    584  CB  LEU A 296      38.922 -20.729  -0.790  1.00 10.35           C  
ATOM    585  CG  LEU A 296      40.251 -21.294  -1.303  1.00 10.81           C  
ATOM    586  CD1 LEU A 296      41.403 -20.807  -0.443  1.00  8.80           C  
ATOM    587  CD2 LEU A 296      40.185 -22.813  -1.298  1.00 11.42           C  
ATOM    588  N   ALA A 297      37.928 -18.700  -3.038  1.00 11.98           N  
ATOM    589  CA  ALA A 297      38.036 -18.217  -4.415  1.00 12.32           C  
ATOM    590  C   ALA A 297      38.446 -16.742  -4.413  1.00 12.37           C  
ATOM    591  O   ALA A 297      39.346 -16.342  -5.152  1.00 12.04           O  
ATOM    592  CB  ALA A 297      36.710 -18.403  -5.149  1.00 10.82           C  
ATOM    593  N   THR A 298      37.799 -15.938  -3.571  1.00 11.21           N  
ATOM    594  CA  THR A 298      38.127 -14.516  -3.486  1.00 10.43           C  
ATOM    595  C   THR A 298      39.559 -14.340  -2.994  1.00 10.89           C  
ATOM    596  O   THR A 298      40.310 -13.522  -3.519  1.00 11.78           O  
ATOM    597  CB  THR A 298      37.169 -13.773  -2.532  1.00  9.75           C  
ATOM    598  OG1 THR A 298      35.816 -14.103  -2.866  1.00 10.88           O  
ATOM    599  CG2 THR A 298      37.361 -12.263  -2.654  1.00 10.28           C  
ATOM    600  N   PHE A 299      39.933 -15.121  -1.984  1.00 12.29           N  
ATOM    601  CA  PHE A 299      41.280 -15.071  -1.411  1.00 11.57           C  
ATOM    602  C   PHE A 299      42.343 -15.286  -2.492  1.00 11.71           C  
ATOM    603  O   PHE A 299      43.317 -14.541  -2.580  1.00 11.33           O  
ATOM    604  CB  PHE A 299      41.412 -16.146  -0.325  1.00  9.32           C  
ATOM    605  CG  PHE A 299      42.765 -16.191   0.335  1.00 10.10           C  
ATOM    606  CD1 PHE A 299      43.019 -15.435   1.475  1.00  9.49           C  
ATOM    607  CD2 PHE A 299      43.781 -17.004  -0.175  1.00  9.84           C  
ATOM    608  CE1 PHE A 299      44.270 -15.483   2.108  1.00 10.39           C  
ATOM    609  CE2 PHE A 299      45.034 -17.062   0.443  1.00  9.05           C  
ATOM    610  CZ  PHE A 299      45.281 -16.298   1.589  1.00 10.54           C  
ATOM    611  N   ASN A 300      42.143 -16.305  -3.319  1.00 12.78           N  
ATOM    612  CA  ASN A 300      43.098 -16.619  -4.377  1.00 14.80           C  
ATOM    613  C   ASN A 300      43.116 -15.594  -5.508  1.00 16.61           C  
ATOM    614  O   ASN A 300      44.145 -15.391  -6.158  1.00 17.01           O  
ATOM    615  CB  ASN A 300      42.802 -18.010  -4.948  1.00 15.02           C  
ATOM    616  CG  ASN A 300      43.167 -19.122  -3.984  1.00 14.42           C  
ATOM    617  OD1 ASN A 300      44.032 -18.953  -3.119  1.00 16.00           O  
ATOM    618  ND2 ASN A 300      42.509 -20.265  -4.123  1.00 13.02           N  
ATOM    619  N   LYS A 301      41.984 -14.935  -5.729  1.00 16.05           N  
ATOM    620  CA  LYS A 301      41.869 -13.952  -6.800  1.00 17.01           C  
ATOM    621  C   LYS A 301      42.358 -12.543  -6.467  1.00 17.09           C  
ATOM    622  O   LYS A 301      42.979 -11.890  -7.301  1.00 17.66           O  
ATOM    623  CB  LYS A 301      40.412 -13.874  -7.267  1.00 16.71           C  
ATOM    624  CG  LYS A 301      40.129 -12.747  -8.245  1.00 17.71           C  
ATOM    625  CD  LYS A 301      38.678 -12.760  -8.702  1.00 20.47           C  
ATOM    626  N   LEU A 302      42.095 -12.080  -5.250  1.00 16.36           N  
ATOM    627  CA  LEU A 302      42.466 -10.723  -4.870  1.00 15.70           C  
ATOM    628  C   LEU A 302      43.574 -10.551  -3.844  1.00 15.17           C  
ATOM    629  O   LEU A 302      43.535 -11.136  -2.763  1.00 14.37           O  
ATOM    630  CB  LEU A 302      41.226  -9.980  -4.365  1.00 12.99           C  
ATOM    631  CG  LEU A 302      39.985 -10.042  -5.253  1.00 15.58           C  
ATOM    632  CD1 LEU A 302      38.784  -9.469  -4.509  1.00 12.88           C  
ATOM    633  CD2 LEU A 302      40.248  -9.265  -6.534  1.00 14.38           C  
ATOM    634  N   VAL A 303      44.550  -9.719  -4.191  1.00 14.76           N  
ATOM    635  CA  VAL A 303      45.653  -9.406  -3.294  1.00 15.64           C  
ATOM    636  C   VAL A 303      45.080  -8.650  -2.102  1.00 13.53           C  
ATOM    637  O   VAL A 303      45.517  -8.834  -0.968  1.00 12.39           O  
ATOM    638  CB  VAL A 303      46.687  -8.488  -3.962  1.00 18.76           C  
ATOM    639  CG1 VAL A 303      48.075  -8.844  -3.477  1.00 21.95           C  
ATOM    640  CG2 VAL A 303      46.592  -8.604  -5.463  1.00 24.26           C  
ATOM    641  N   SER A 304      44.097  -7.793  -2.375  1.00 12.81           N  
ATOM    642  CA  SER A 304      43.460  -6.993  -1.333  1.00 11.67           C  
ATOM    643  C   SER A 304      42.764  -7.845  -0.268  1.00 10.47           C  
ATOM    644  O   SER A 304      42.777  -7.499   0.916  1.00  9.82           O  
ATOM    645  CB  SER A 304      42.456  -6.007  -1.952  1.00  9.53           C  
ATOM    646  OG  SER A 304      41.423  -6.675  -2.657  1.00 12.15           O  
ATOM    647  N   TYR A 305      42.151  -8.949  -0.687  1.00  8.86           N  
ATOM    648  CA  TYR A 305      41.468  -9.829   0.254  1.00  8.99           C  
ATOM    649  C   TYR A 305      42.512 -10.528   1.117  1.00  9.34           C  
ATOM    650  O   TYR A 305      42.323 -10.699   2.322  1.00  9.22           O  
ATOM    651  CB  TYR A 305      40.624 -10.867  -0.498  1.00  8.83           C  
ATOM    652  CG  TYR A 305      39.733 -11.728   0.389  1.00  9.59           C  
ATOM    653  CD1 TYR A 305      38.402 -11.373   0.639  1.00  9.53           C  
ATOM    654  CD2 TYR A 305      40.210 -12.917   0.945  1.00  9.53           C  
ATOM    655  CE1 TYR A 305      37.566 -12.187   1.417  1.00  8.91           C  
ATOM    656  CE2 TYR A 305      39.387 -13.738   1.722  1.00  9.74           C  
ATOM    657  CZ  TYR A 305      38.066 -13.369   1.950  1.00 10.63           C  
ATOM    658  OH  TYR A 305      37.256 -14.200   2.685  1.00  8.53           O  
ATOM    659  N   ARG A 306      43.619 -10.926   0.500  1.00  9.07           N  
ATOM    660  CA  ARG A 306      44.673 -11.601   1.240  1.00  9.40           C  
ATOM    661  C   ARG A 306      45.284 -10.642   2.259  1.00  9.53           C  
ATOM    662  O   ARG A 306      45.544 -11.027   3.399  1.00  8.82           O  
ATOM    663  CB  ARG A 306      45.731 -12.148   0.272  1.00  9.91           C  
ATOM    664  CG  ARG A 306      45.139 -13.154  -0.719  1.00  9.08           C  
ATOM    665  CD  ARG A 306      46.183 -14.037  -1.359  1.00  8.68           C  
ATOM    666  NE  ARG A 306      47.015 -13.300  -2.303  1.00 10.47           N  
ATOM    667  CZ  ARG A 306      46.713 -13.084  -3.581  1.00 11.90           C  
ATOM    668  NH1 ARG A 306      45.582 -13.545  -4.099  1.00 10.83           N  
ATOM    669  NH2 ARG A 306      47.559 -12.407  -4.350  1.00 14.64           N  
ATOM    670  N   LYS A 307      45.497  -9.393   1.853  1.00 10.37           N  
ATOM    671  CA  LYS A 307      46.058  -8.393   2.756  1.00 11.05           C  
ATOM    672  C   LYS A 307      45.078  -8.139   3.907  1.00  9.79           C  
ATOM    673  O   LYS A 307      45.481  -8.002   5.059  1.00  9.14           O  
ATOM    674  CB  LYS A 307      46.336  -7.092   1.995  1.00 13.29           C  
ATOM    675  CG  LYS A 307      46.359  -5.847   2.868  1.00 20.07           C  
ATOM    676  CD  LYS A 307      46.791  -4.627   2.066  1.00 25.45           C  
ATOM    677  CE  LYS A 307      47.371  -3.552   2.968  1.00 27.41           C  
ATOM    678  NZ  LYS A 307      46.432  -2.410   3.137  1.00 29.81           N  
ATOM    679  N   ALA A 308      43.788  -8.079   3.587  1.00  9.68           N  
ATOM    680  CA  ALA A 308      42.762  -7.868   4.605  1.00  9.66           C  
ATOM    681  C   ALA A 308      42.804  -9.011   5.618  1.00  8.49           C  
ATOM    682  O   ALA A 308      42.749  -8.787   6.827  1.00  9.02           O  
ATOM    683  CB  ALA A 308      41.380  -7.804   3.952  1.00  8.36           C  
ATOM    684  N   MET A 309      42.902 -10.236   5.105  1.00  9.34           N  
ATOM    685  CA  MET A 309      42.942 -11.442   5.932  1.00  9.58           C  
ATOM    686  C   MET A 309      44.144 -11.467   6.868  1.00  8.96           C  
ATOM    687  O   MET A 309      44.039 -11.895   8.015  1.00  7.44           O  
ATOM    688  CB  MET A 309      42.967 -12.687   5.040  1.00 11.13           C  
ATOM    689  CG  MET A 309      42.357 -13.929   5.690  1.00 17.21           C  
ATOM    690  SD  MET A 309      40.776 -13.592   6.523  1.00 20.27           S  
ATOM    691  CE  MET A 309      39.868 -12.889   5.197  1.00  2.44           C  
ATOM    692  N   TYR A 310      45.289 -11.018   6.364  1.00  9.73           N  
ATOM    693  CA  TYR A 310      46.500 -10.980   7.167  1.00 10.08           C  
ATOM    694  C   TYR A 310      46.329 -10.067   8.379  1.00 10.45           C  
ATOM    695  O   TYR A 310      46.605 -10.463   9.509  1.00 10.72           O  
ATOM    696  CB  TYR A 310      47.686 -10.481   6.343  1.00  9.10           C  
ATOM    697  CG  TYR A 310      48.930 -10.333   7.182  1.00 11.07           C  
ATOM    698  CD1 TYR A 310      49.679 -11.454   7.542  1.00 13.72           C  
ATOM    699  CD2 TYR A 310      49.340  -9.088   7.647  1.00 12.62           C  
ATOM    700  CE1 TYR A 310      50.806 -11.340   8.345  1.00 14.91           C  
ATOM    701  CE2 TYR A 310      50.470  -8.960   8.453  1.00 14.52           C  
ATOM    702  CZ  TYR A 310      51.194 -10.091   8.796  1.00 16.25           C  
ATOM    703  OH  TYR A 310      52.311  -9.982   9.592  1.00 21.25           O  
ATOM    704  N   HIS A 311      45.874  -8.841   8.137  1.00  9.19           N  
ATOM    705  CA  HIS A 311      45.685  -7.892   9.218  1.00  9.05           C  
ATOM    706  C   HIS A 311      44.607  -8.359  10.174  1.00  9.33           C  
ATOM    707  O   HIS A 311      44.699  -8.105  11.371  1.00  9.67           O  
ATOM    708  CB  HIS A 311      45.354  -6.516   8.646  1.00 12.66           C  
ATOM    709  CG  HIS A 311      46.506  -5.892   7.922  1.00 15.77           C  
ATOM    710  ND1 HIS A 311      47.720  -5.645   8.525  1.00 19.07           N  
ATOM    711  CD2 HIS A 311      46.596  -5.386   6.669  1.00 15.82           C  
ATOM    712  CE1 HIS A 311      48.508  -5.011   7.675  1.00 17.01           C  
ATOM    713  NE2 HIS A 311      47.850  -4.842   6.542  1.00 17.43           N  
ATOM    714  N   THR A 312      43.597  -9.048   9.645  1.00  6.96           N  
ATOM    715  CA  THR A 312      42.508  -9.568  10.470  1.00  7.17           C  
ATOM    716  C   THR A 312      43.028 -10.643  11.420  1.00  8.68           C  
ATOM    717  O   THR A 312      42.763 -10.610  12.623  1.00  8.25           O  
ATOM    718  CB  THR A 312      41.395 -10.218   9.615  1.00  6.68           C  
ATOM    719  OG1 THR A 312      40.852  -9.250   8.709  1.00  8.34           O  
ATOM    720  CG2 THR A 312      40.284 -10.764  10.513  1.00  5.66           C  
ATOM    721  N   LEU A 313      43.764 -11.603  10.867  1.00  9.01           N  
ATOM    722  CA  LEU A 313      44.295 -12.699  11.661  1.00  8.67           C  
ATOM    723  C   LEU A 313      45.463 -12.264  12.530  1.00  7.55           C  
ATOM    724  O   LEU A 313      45.782 -12.925  13.511  1.00  6.94           O  
ATOM    725  CB  LEU A 313      44.678 -13.868  10.748  1.00 10.32           C  
ATOM    726  CG  LEU A 313      43.448 -14.522  10.111  1.00 10.69           C  
ATOM    727  CD1 LEU A 313      43.856 -15.682   9.220  1.00  9.67           C  
ATOM    728  CD2 LEU A 313      42.502 -14.997  11.217  1.00 11.39           C  
ATOM    729  N   GLU A 314      46.094 -11.145  12.176  1.00  8.94           N  
ATOM    730  CA  GLU A 314      47.184 -10.608  12.981  1.00  9.51           C  
ATOM    731  C   GLU A 314      46.533 -10.080  14.258  1.00  9.80           C  
ATOM    732  O   GLU A 314      47.024 -10.306  15.363  1.00 10.66           O  
ATOM    733  CB  GLU A 314      47.886  -9.467  12.245  1.00 12.15           C  
ATOM    734  CG  GLU A 314      49.266  -9.822  11.739  1.00 14.35           C  
ATOM    735  CD  GLU A 314      50.203 -10.232  12.863  1.00 16.56           C  
ATOM    736  OE1 GLU A 314      50.480 -11.447  13.004  1.00 19.54           O  
ATOM    737  OE2 GLU A 314      50.656  -9.340  13.609  1.00 19.12           O  
ATOM    738  N   LYS A 315      45.411  -9.384  14.098  1.00  8.68           N  
ATOM    739  CA  LYS A 315      44.693  -8.857  15.246  1.00  8.97           C  
ATOM    740  C   LYS A 315      44.161 -10.024  16.076  1.00  8.73           C  
ATOM    741  O   LYS A 315      44.203  -9.995  17.306  1.00  9.11           O  
ATOM    742  CB  LYS A 315      43.528  -7.975  14.791  1.00 11.22           C  
ATOM    743  CG  LYS A 315      42.742  -7.360  15.933  1.00 14.08           C  
ATOM    744  CD  LYS A 315      42.669  -5.857  15.782  1.00 18.15           C  
ATOM    745  CE  LYS A 315      43.327  -5.164  16.950  1.00 23.34           C  
ATOM    746  NZ  LYS A 315      43.579  -3.730  16.648  1.00 23.53           N  
ATOM    747  N   ALA A 316      43.665 -11.053  15.394  1.00  7.26           N  
ATOM    748  CA  ALA A 316      43.126 -12.230  16.069  1.00  7.72           C  
ATOM    749  C   ALA A 316      44.181 -12.946  16.908  1.00  7.82           C  
ATOM    750  O   ALA A 316      43.944 -13.275  18.075  1.00  9.37           O  
ATOM    751  CB  ALA A 316      42.535 -13.193  15.051  1.00  5.72           C  
ATOM    752  N   ARG A 317      45.348 -13.192  16.324  1.00  7.94           N  
ATOM    753  CA  ARG A 317      46.382 -13.889  17.065  1.00  7.43           C  
ATOM    754  C   ARG A 317      46.909 -13.058  18.239  1.00  7.53           C  
ATOM    755  O   ARG A 317      47.303 -13.613  19.257  1.00  7.56           O  
ATOM    756  CB  ARG A 317      47.516 -14.335  16.122  1.00  7.20           C  
ATOM    757  CG  ARG A 317      48.396 -13.233  15.570  1.00  5.50           C  
ATOM    758  CD  ARG A 317      49.657 -13.077  16.406  1.00  5.69           C  
ATOM    759  NE  ARG A 317      50.491 -11.996  15.899  1.00  6.99           N  
ATOM    760  CZ  ARG A 317      51.310 -11.263  16.644  1.00  6.87           C  
ATOM    761  NH1 ARG A 317      52.023 -10.301  16.080  1.00  8.85           N  
ATOM    762  NH2 ARG A 317      51.425 -11.494  17.947  1.00  6.16           N  
ATOM    763  N   VAL A 318      46.909 -11.733  18.114  1.00  7.89           N  
ATOM    764  CA  VAL A 318      47.378 -10.905  19.223  1.00  9.82           C  
ATOM    765  C   VAL A 318      46.387 -11.055  20.377  1.00 10.77           C  
ATOM    766  O   VAL A 318      46.779 -11.190  21.533  1.00 12.21           O  
ATOM    767  CB  VAL A 318      47.484  -9.400  18.835  1.00  8.37           C  
ATOM    768  CG1 VAL A 318      47.610  -8.547  20.089  1.00 10.67           C  
ATOM    769  CG2 VAL A 318      48.695  -9.173  17.945  1.00  9.89           C  
ATOM    770  N   ARG A 319      45.098 -11.045  20.058  1.00 10.55           N  
ATOM    771  CA  ARG A 319      44.064 -11.178  21.079  1.00 12.68           C  
ATOM    772  C   ARG A 319      44.092 -12.526  21.799  1.00 12.85           C  
ATOM    773  O   ARG A 319      44.041 -12.588  23.033  1.00 13.04           O  
ATOM    774  CB  ARG A 319      42.683 -10.983  20.448  1.00 11.66           C  
ATOM    775  CG  ARG A 319      42.455  -9.593  19.909  1.00 15.39           C  
ATOM    776  CD  ARG A 319      41.166  -9.027  20.434  1.00 15.53           C  
ATOM    777  NE  ARG A 319      40.959  -7.658  19.981  1.00 15.76           N  
ATOM    778  CZ  ARG A 319      39.869  -7.245  19.348  1.00 12.50           C  
ATOM    779  NH1 ARG A 319      38.884  -8.099  19.095  1.00  9.28           N  
ATOM    780  NH2 ARG A 319      39.765  -5.981  18.975  1.00 11.38           N  
ATOM    781  N   ALA A 320      44.191 -13.598  21.017  1.00 12.23           N  
ATOM    782  CA  ALA A 320      44.171 -14.957  21.544  1.00 12.31           C  
ATOM    783  C   ALA A 320      45.480 -15.476  22.121  1.00 10.75           C  
ATOM    784  O   ALA A 320      45.506 -16.548  22.720  1.00 13.08           O  
ATOM    785  CB  ALA A 320      43.674 -15.917  20.455  1.00 10.51           C  
ATOM    786  N   GLY A 321      46.564 -14.733  21.943  1.00 11.26           N  
ATOM    787  CA  GLY A 321      47.844 -15.190  22.456  1.00 11.40           C  
ATOM    788  C   GLY A 321      48.419 -16.329  21.631  1.00 12.82           C  
ATOM    789  O   GLY A 321      49.206 -17.134  22.133  1.00 13.91           O  
ATOM    790  N   LYS A 322      48.025 -16.403  20.361  1.00 11.08           N  
ATOM    791  CA  LYS A 322      48.510 -17.449  19.459  1.00 10.53           C  
ATOM    792  C   LYS A 322      49.811 -16.965  18.829  1.00 10.37           C  
ATOM    793  O   LYS A 322      49.871 -15.876  18.255  1.00  8.78           O  
ATOM    794  CB  LYS A 322      47.469 -17.744  18.373  1.00  8.10           C  
ATOM    795  CG  LYS A 322      47.836 -18.897  17.460  1.00 11.34           C  
ATOM    796  CD  LYS A 322      47.824 -20.216  18.215  1.00 16.34           C  
ATOM    797  CE  LYS A 322      48.363 -21.358  17.369  1.00 20.23           C  
ATOM    798  NZ  LYS A 322      49.455 -20.932  16.464  1.00 24.53           N  
ATOM    799  N   THR A 323      50.855 -17.777  18.932  1.00 10.08           N  
ATOM    800  CA  THR A 323      52.155 -17.379  18.403  1.00  9.51           C  
ATOM    801  C   THR A 323      52.442 -17.883  16.993  1.00  8.38           C  
ATOM    802  O   THR A 323      52.163 -19.036  16.663  1.00  8.04           O  
ATOM    803  CB  THR A 323      53.294 -17.847  19.352  1.00  9.19           C  
ATOM    804  OG1 THR A 323      53.022 -17.381  20.679  1.00 10.97           O  
ATOM    805  CG2 THR A 323      54.658 -17.309  18.892  1.00  8.08           C  
ATOM    806  N   PHE A 324      52.980 -16.990  16.164  1.00  9.16           N  
ATOM    807  CA  PHE A 324      53.364 -17.322  14.798  1.00  9.23           C  
ATOM    808  C   PHE A 324      54.769 -16.767  14.627  1.00  9.64           C  
ATOM    809  O   PHE A 324      55.209 -15.946  15.424  1.00  9.22           O  
ATOM    810  CB  PHE A 324      52.411 -16.679  13.782  1.00 10.82           C  
ATOM    811  CG  PHE A 324      51.046 -17.307  13.761  1.00  9.60           C  
ATOM    812  CD1 PHE A 324      49.957 -16.663  14.348  1.00 11.93           C  
ATOM    813  CD2 PHE A 324      50.856 -18.568  13.204  1.00 10.32           C  
ATOM    814  CE1 PHE A 324      48.698 -17.276  14.385  1.00 11.75           C  
ATOM    815  CE2 PHE A 324      49.602 -19.185  13.238  1.00 10.28           C  
ATOM    816  CZ  PHE A 324      48.526 -18.540  13.830  1.00  8.87           C  
ATOM    817  N   SER A 325      55.483 -17.229  13.607  1.00 11.02           N  
ATOM    818  CA  SER A 325      56.837 -16.748  13.373  1.00 13.60           C  
ATOM    819  C   SER A 325      57.015 -16.410  11.905  1.00 15.66           C  
ATOM    820  O   SER A 325      56.355 -16.996  11.038  1.00 16.61           O  
ATOM    821  CB  SER A 325      57.864 -17.805  13.778  1.00 15.09           C  
ATOM    822  OG  SER A 325      57.930 -18.833  12.809  1.00 18.33           O  
ATOM    823  N   SER A 326      57.897 -15.458  11.628  1.00 14.39           N  
ATOM    824  CA  SER A 326      58.163 -15.057  10.259  1.00 14.72           C  
ATOM    825  C   SER A 326      59.538 -14.422  10.135  1.00 14.40           C  
ATOM    826  O   SER A 326      60.190 -14.115  11.131  1.00 12.82           O  
ATOM    827  CB  SER A 326      57.088 -14.074   9.770  1.00 12.16           C  
ATOM    828  OG  SER A 326      57.182 -12.830  10.435  0.50 14.60           O  
ATOM    829  N   SER A 327      59.983 -14.251   8.900  1.00 16.13           N  
ATOM    830  CA  SER A 327      61.270 -13.637   8.643  1.00 17.13           C  
ATOM    831  C   SER A 327      60.982 -12.357   7.876  1.00 19.38           C  
ATOM    832  O   SER A 327      59.979 -12.264   7.169  1.00 19.34           O  
ATOM    833  CB  SER A 327      62.135 -14.560   7.799  1.00 16.60           C  
ATOM    834  OG  SER A 327      61.521 -14.799   6.546  1.00 18.44           O  
ATOM    835  N   PRO A 328      61.851 -11.348   8.019  1.00 20.72           N  
ATOM    836  CA  PRO A 328      61.621 -10.095   7.300  1.00 22.72           C  
ATOM    837  C   PRO A 328      61.501 -10.415   5.817  1.00 24.82           C  
ATOM    838  O   PRO A 328      62.313 -11.162   5.278  1.00 27.69           O  
ATOM    839  CB  PRO A 328      62.867  -9.271   7.605  1.00 22.26           C  
ATOM    840  CG  PRO A 328      63.391  -9.840   8.874  1.00 20.56           C  
ATOM    841  CD  PRO A 328      63.077 -11.300   8.833  1.00 19.64           C  
ATOM    842  N   GLY A 329      60.477  -9.885   5.163  1.00 26.32           N  
ATOM    843  CA  GLY A 329      60.337 -10.153   3.745  1.00 29.79           C  
ATOM    844  C   GLY A 329      59.513 -11.370   3.374  1.00 31.52           C  
ATOM    845  O   GLY A 329      59.145 -11.524   2.207  1.00 34.50           O  
ATOM    846  N   GLU A 330      59.234 -12.249   4.339  1.00 29.33           N  
ATOM    847  CA  GLU A 330      58.421 -13.430   4.061  1.00 26.04           C  
ATOM    848  C   GLU A 330      57.116 -12.894   3.485  1.00 24.39           C  
ATOM    849  O   GLU A 330      56.566 -11.918   3.998  1.00 23.43           O  
ATOM    850  CB  GLU A 330      58.139 -14.216   5.346  1.00 23.76           C  
ATOM    851  CG  GLU A 330      57.449 -15.554   5.112  1.00 24.55           C  
ATOM    852  CD  GLU A 330      57.242 -16.350   6.396  1.00 25.89           C  
ATOM    853  OE1 GLU A 330      58.075 -16.234   7.317  1.00 26.86           O  
ATOM    854  OE2 GLU A 330      56.247 -17.095   6.486  1.00 24.40           O  
ATOM    855  N   SER A 331      56.631 -13.520   2.419  1.00 24.34           N  
ATOM    856  CA  SER A 331      55.403 -13.074   1.772  1.00 25.22           C  
ATOM    857  C   SER A 331      54.183 -13.188   2.674  1.00 24.67           C  
ATOM    858  O   SER A 331      54.142 -14.024   3.577  1.00 23.41           O  
ATOM    859  CB  SER A 331      55.175 -13.864   0.478  1.00 25.06           C  
ATOM    860  OG  SER A 331      54.887 -15.228   0.730  1.00 25.58           O  
ATOM    861  N   LEU A 332      53.195 -12.329   2.434  1.00 24.60           N  
ATOM    862  CA  LEU A 332      51.971 -12.347   3.226  1.00 23.14           C  
ATOM    863  C   LEU A 332      51.260 -13.686   3.056  1.00 21.80           C  
ATOM    864  O   LEU A 332      50.706 -14.228   4.009  1.00 20.61           O  
ATOM    865  CB  LEU A 332      51.039 -11.213   2.795  1.00 26.24           C  
ATOM    866  CG  LEU A 332      49.664 -11.173   3.467  1.00 24.63           C  
ATOM    867  N   GLU A 333      51.285 -14.219   1.841  1.00 20.36           N  
ATOM    868  CA  GLU A 333      50.645 -15.497   1.562  1.00 21.80           C  
ATOM    869  C   GLU A 333      51.296 -16.603   2.386  1.00 20.46           C  
ATOM    870  O   GLU A 333      50.611 -17.467   2.928  1.00 17.73           O  
ATOM    871  CB  GLU A 333      50.758 -15.833   0.071  1.00 27.70           C  
ATOM    872  CG  GLU A 333      49.891 -14.967  -0.841  1.00 34.64           C  
ATOM    873  CD  GLU A 333      50.446 -13.558  -1.025  1.00 39.67           C  
ATOM    874  OE1 GLU A 333      51.679 -13.381  -0.914  1.00 43.36           O  
ATOM    875  OE2 GLU A 333      49.649 -12.625  -1.279  1.00 41.21           O  
ATOM    876  N   ASP A 334      52.624 -16.572   2.471  1.00 18.94           N  
ATOM    877  CA  ASP A 334      53.378 -17.564   3.227  1.00 18.17           C  
ATOM    878  C   ASP A 334      53.061 -17.446   4.715  1.00 15.67           C  
ATOM    879  O   ASP A 334      52.855 -18.448   5.398  1.00 14.44           O  
ATOM    880  CB  ASP A 334      54.883 -17.365   3.007  1.00 22.15           C  
ATOM    881  CG  ASP A 334      55.404 -18.125   1.799  1.00 26.87           C  
ATOM    882  OD1 ASP A 334      54.590 -18.756   1.095  1.00 27.51           O  
ATOM    883  OD2 ASP A 334      56.629 -18.093   1.553  1.00 28.13           O  
ATOM    884  N   GLN A 335      53.022 -16.215   5.214  1.00 14.21           N  
ATOM    885  CA  GLN A 335      52.723 -15.977   6.624  1.00 14.06           C  
ATOM    886  C   GLN A 335      51.297 -16.396   6.948  1.00 13.29           C  
ATOM    887  O   GLN A 335      51.020 -16.898   8.033  1.00 11.42           O  
ATOM    888  CB  GLN A 335      52.887 -14.500   6.963  1.00 16.04           C  
ATOM    889  CG  GLN A 335      54.313 -13.994   6.931  1.00 17.27           C  
ATOM    890  CD  GLN A 335      54.415 -12.591   7.486  1.00 18.02           C  
ATOM    891  OE1 GLN A 335      54.154 -12.361   8.668  1.00 18.43           O  
ATOM    892  NE2 GLN A 335      54.783 -11.640   6.632  1.00 19.88           N  
ATOM    893  N   LEU A 336      50.400 -16.182   5.993  1.00 11.18           N  
ATOM    894  CA  LEU A 336      48.995 -16.520   6.172  1.00 10.40           C  
ATOM    895  C   LEU A 336      48.719 -18.015   6.260  1.00 11.08           C  
ATOM    896  O   LEU A 336      47.758 -18.425   6.910  1.00 10.07           O  
ATOM    897  CB  LEU A 336      48.165 -15.940   5.027  1.00  9.85           C  
ATOM    898  CG  LEU A 336      47.621 -14.528   5.222  1.00 10.28           C  
ATOM    899  CD1 LEU A 336      47.225 -13.965   3.878  1.00 10.35           C  
ATOM    900  CD2 LEU A 336      46.427 -14.554   6.157  1.00 12.56           C  
ATOM    901  N   LYS A 337      49.547 -18.833   5.611  1.00 10.89           N  
ATOM    902  CA  LYS A 337      49.311 -20.274   5.621  1.00 12.03           C  
ATOM    903  C   LYS A 337      49.012 -20.846   7.015  1.00 11.62           C  
ATOM    904  O   LYS A 337      47.945 -21.424   7.233  1.00 10.26           O  
ATOM    905  CB  LYS A 337      50.480 -21.029   4.973  1.00 13.21           C  
ATOM    906  CG  LYS A 337      50.228 -22.534   4.879  1.00 20.25           C  
ATOM    907  CD  LYS A 337      51.211 -23.244   3.950  1.00 26.39           C  
ATOM    908  CE  LYS A 337      50.965 -24.756   3.932  1.00 28.09           C  
ATOM    909  NZ  LYS A 337      49.978 -25.165   2.881  1.00 27.75           N  
ATOM    910  N   PRO A 338      49.951 -20.716   7.969  1.00 11.07           N  
ATOM    911  CA  PRO A 338      49.663 -21.258   9.303  1.00 11.00           C  
ATOM    912  C   PRO A 338      48.566 -20.496  10.058  1.00 10.19           C  
ATOM    913  O   PRO A 338      47.897 -21.055  10.922  1.00 10.51           O  
ATOM    914  CB  PRO A 338      51.007 -21.191  10.021  1.00 12.48           C  
ATOM    915  CG  PRO A 338      51.769 -20.109   9.306  1.00 12.32           C  
ATOM    916  CD  PRO A 338      51.301 -20.122   7.883  1.00 11.96           C  
ATOM    917  N   MET A 339      48.383 -19.221   9.728  1.00  9.75           N  
ATOM    918  CA  MET A 339      47.367 -18.408  10.383  1.00  9.63           C  
ATOM    919  C   MET A 339      45.972 -18.871   9.967  1.00  9.63           C  
ATOM    920  O   MET A 339      45.057 -18.914  10.785  1.00  8.50           O  
ATOM    921  CB  MET A 339      47.562 -16.932  10.020  1.00 10.59           C  
ATOM    922  CG  MET A 339      48.903 -16.357  10.479  1.00 12.46           C  
ATOM    923  SD  MET A 339      49.194 -14.669   9.886  1.00 16.93           S  
ATOM    924  CE  MET A 339      48.416 -13.733  11.160  1.00 10.91           C  
ATOM    925  N   LEU A 340      45.812 -19.220   8.693  1.00  9.98           N  
ATOM    926  CA  LEU A 340      44.525 -19.693   8.189  1.00  8.71           C  
ATOM    927  C   LEU A 340      44.230 -21.098   8.717  1.00  8.66           C  
ATOM    928  O   LEU A 340      43.079 -21.443   8.959  1.00  7.17           O  
ATOM    929  CB  LEU A 340      44.519 -19.694   6.656  1.00  7.73           C  
ATOM    930  CG  LEU A 340      44.424 -18.314   5.990  1.00  9.10           C  
ATOM    931  CD1 LEU A 340      44.754 -18.439   4.510  1.00  8.39           C  
ATOM    932  CD2 LEU A 340      43.021 -17.738   6.183  1.00  9.95           C  
ATOM    933  N   GLU A 341      45.272 -21.911   8.891  1.00  8.38           N  
ATOM    934  CA  GLU A 341      45.092 -23.263   9.415  1.00 10.23           C  
ATOM    935  C   GLU A 341      44.544 -23.148  10.832  1.00  9.53           C  
ATOM    936  O   GLU A 341      43.654 -23.902  11.234  1.00 10.04           O  
ATOM    937  CB  GLU A 341      46.422 -24.023   9.427  1.00 14.48           C  
ATOM    938  CG  GLU A 341      46.704 -24.796   8.140  1.00 22.42           C  
ATOM    939  CD  GLU A 341      48.182 -25.115   7.952  1.00 29.47           C  
ATOM    940  OE1 GLU A 341      48.542 -25.672   6.890  1.00 28.08           O  
ATOM    941  OE2 GLU A 341      48.985 -24.809   8.866  1.00 33.68           O  
ATOM    942  N   TRP A 342      45.084 -22.194  11.584  1.00  8.83           N  
ATOM    943  CA  TRP A 342      44.652 -21.937  12.955  1.00  8.58           C  
ATOM    944  C   TRP A 342      43.189 -21.460  12.954  1.00  8.86           C  
ATOM    945  O   TRP A 342      42.358 -21.949  13.719  1.00  9.15           O  
ATOM    946  CB  TRP A 342      45.563 -20.871  13.580  1.00  7.22           C  
ATOM    947  CG  TRP A 342      45.105 -20.365  14.904  1.00  7.39           C  
ATOM    948  CD1 TRP A 342      44.940 -21.088  16.046  1.00  8.82           C  
ATOM    949  CD2 TRP A 342      44.764 -19.011  15.233  1.00  8.82           C  
ATOM    950  NE1 TRP A 342      44.516 -20.273  17.070  1.00  8.82           N  
ATOM    951  CE2 TRP A 342      44.400 -18.993  16.601  1.00  9.25           C  
ATOM    952  CE3 TRP A 342      44.730 -17.809  14.506  1.00  8.32           C  
ATOM    953  CZ2 TRP A 342      44.004 -17.813  17.261  1.00  8.74           C  
ATOM    954  CZ3 TRP A 342      44.336 -16.634  15.167  1.00  7.94           C  
ATOM    955  CH2 TRP A 342      43.980 -16.652  16.531  1.00  7.61           C  
ATOM    956  N   ALA A 343      42.881 -20.511  12.075  1.00  9.01           N  
ATOM    957  CA  ALA A 343      41.531 -19.967  11.965  1.00  8.69           C  
ATOM    958  C   ALA A 343      40.508 -21.016  11.529  1.00  8.99           C  
ATOM    959  O   ALA A 343      39.473 -21.190  12.173  1.00 10.26           O  
ATOM    960  CB  ALA A 343      41.523 -18.807  10.992  1.00  8.33           C  
ATOM    961  N   HIS A 344      40.791 -21.706  10.431  1.00  7.70           N  
ATOM    962  CA  HIS A 344      39.880 -22.726   9.933  1.00  8.57           C  
ATOM    963  C   HIS A 344      39.729 -23.865  10.928  1.00 11.00           C  
ATOM    964  O   HIS A 344      38.699 -24.534  10.958  1.00 11.90           O  
ATOM    965  CB  HIS A 344      40.379 -23.282   8.598  1.00  8.75           C  
ATOM    966  CG  HIS A 344      40.124 -22.373   7.434  1.00  7.90           C  
ATOM    967  ND1 HIS A 344      38.886 -21.835   7.168  1.00  7.11           N  
ATOM    968  CD2 HIS A 344      40.953 -21.911   6.466  1.00  7.77           C  
ATOM    969  CE1 HIS A 344      38.960 -21.081   6.085  1.00  9.58           C  
ATOM    970  NE2 HIS A 344      40.202 -21.110   5.640  1.00  8.34           N  
ATOM    971  N   GLY A 345      40.758 -24.077  11.744  1.00 11.41           N  
ATOM    972  CA  GLY A 345      40.733 -25.146  12.731  1.00 10.76           C  
ATOM    973  C   GLY A 345      39.920 -24.810  13.960  1.00 12.22           C  
ATOM    974  O   GLY A 345      39.774 -25.637  14.863  1.00 12.54           O  
ATOM    975  N   GLY A 346      39.390 -23.589  13.998  1.00 11.14           N  
ATOM    976  CA  GLY A 346      38.583 -23.175  15.129  1.00 10.83           C  
ATOM    977  C   GLY A 346      39.309 -22.329  16.159  1.00 10.88           C  
ATOM    978  O   GLY A 346      38.855 -22.216  17.297  1.00 11.43           O  
ATOM    979  N   PHE A 347      40.436 -21.739  15.770  1.00  9.54           N  
ATOM    980  CA  PHE A 347      41.205 -20.886  16.675  1.00  9.97           C  
ATOM    981  C   PHE A 347      41.585 -21.584  17.983  1.00 11.29           C  
ATOM    982  O   PHE A 347      41.423 -21.014  19.063  1.00 11.00           O  
ATOM    983  CB  PHE A 347      40.418 -19.610  17.001  1.00  8.59           C  
ATOM    984  CG  PHE A 347      39.991 -18.823  15.787  1.00  9.03           C  
ATOM    985  CD1 PHE A 347      38.685 -18.907  15.311  1.00  8.48           C  
ATOM    986  CD2 PHE A 347      40.890 -17.981  15.136  1.00  8.22           C  
ATOM    987  CE1 PHE A 347      38.272 -18.166  14.209  1.00  9.96           C  
ATOM    988  CE2 PHE A 347      40.492 -17.230  14.030  1.00 10.20           C  
ATOM    989  CZ  PHE A 347      39.175 -17.323  13.566  1.00  9.90           C  
ATOM    990  N   LYS A 348      42.093 -22.812  17.880  1.00 12.40           N  
ATOM    991  CA  LYS A 348      42.503 -23.585  19.050  1.00 12.65           C  
ATOM    992  C   LYS A 348      43.845 -23.065  19.534  1.00 10.58           C  
ATOM    993  O   LYS A 348      44.665 -22.617  18.737  1.00  9.81           O  
ATOM    994  CB  LYS A 348      42.636 -25.070  18.695  1.00 15.41           C  
ATOM    995  CG  LYS A 348      41.415 -25.663  18.013  1.00 19.93           C  
ATOM    996  CD  LYS A 348      40.201 -25.608  18.921  1.00 24.96           C  
ATOM    997  CE  LYS A 348      39.000 -26.310  18.298  1.00 30.02           C  
ATOM    998  NZ  LYS A 348      37.815 -26.271  19.208  1.00 30.72           N  
ATOM    999  N   PRO A 349      44.116 -23.170  20.841  1.00 11.03           N  
ATOM   1000  CA  PRO A 349      43.277 -23.737  21.903  1.00 11.52           C  
ATOM   1001  C   PRO A 349      42.192 -22.846  22.510  1.00 11.44           C  
ATOM   1002  O   PRO A 349      41.287 -23.343  23.184  1.00 11.51           O  
ATOM   1003  CB  PRO A 349      44.296 -24.148  22.957  1.00 12.16           C  
ATOM   1004  CG  PRO A 349      45.363 -23.097  22.831  1.00 10.56           C  
ATOM   1005  CD  PRO A 349      45.420 -22.720  21.367  1.00 12.04           C  
ATOM   1006  N   THR A 350      42.273 -21.540  22.280  1.00 11.52           N  
ATOM   1007  CA  THR A 350      41.301 -20.619  22.860  1.00 10.86           C  
ATOM   1008  C   THR A 350      39.873 -20.712  22.318  1.00 12.32           C  
ATOM   1009  O   THR A 350      38.910 -20.454  23.046  1.00 12.43           O  
ATOM   1010  CB  THR A 350      41.747 -19.144  22.700  1.00 12.95           C  
ATOM   1011  OG1 THR A 350      41.736 -18.792  21.308  1.00 12.20           O  
ATOM   1012  CG2 THR A 350      43.142 -18.924  23.292  1.00  9.11           C  
ATOM   1013  N   GLY A 351      39.726 -21.085  21.054  1.00 10.24           N  
ATOM   1014  CA  GLY A 351      38.399 -21.113  20.480  1.00 12.54           C  
ATOM   1015  C   GLY A 351      38.061 -19.658  20.177  1.00 14.61           C  
ATOM   1016  O   GLY A 351      38.894 -18.764  20.387  1.00 13.47           O  
ATOM   1017  N   ILE A 352      36.849 -19.393  19.709  1.00 14.90           N  
ATOM   1018  CA  ILE A 352      36.471 -18.026  19.370  1.00 16.06           C  
ATOM   1019  C   ILE A 352      36.451 -17.068  20.564  1.00 16.21           C  
ATOM   1020  O   ILE A 352      36.374 -15.850  20.388  1.00 15.26           O  
ATOM   1021  CB  ILE A 352      35.104 -17.992  18.643  1.00 17.07           C  
ATOM   1022  CG1 ILE A 352      33.971 -18.290  19.626  1.00 17.87           C  
ATOM   1023  CG2 ILE A 352      35.103 -19.010  17.504  1.00 15.02           C  
ATOM   1024  CD1 ILE A 352      32.588 -18.107  19.021  1.00 22.80           C  
ATOM   1025  N   GLU A 353      36.534 -17.606  21.778  1.00 15.81           N  
ATOM   1026  CA  GLU A 353      36.543 -16.756  22.965  1.00 16.52           C  
ATOM   1027  C   GLU A 353      37.815 -15.912  22.974  1.00 15.31           C  
ATOM   1028  O   GLU A 353      37.826 -14.780  23.463  1.00 15.30           O  
ATOM   1029  CB  GLU A 353      36.484 -17.603  24.238  1.00 18.25           C  
ATOM   1030  CG  GLU A 353      36.144 -16.803  25.493  1.00 22.97           C  
ATOM   1031  N   GLY A 354      38.886 -16.469  22.423  1.00 12.71           N  
ATOM   1032  CA  GLY A 354      40.148 -15.755  22.386  1.00 13.29           C  
ATOM   1033  C   GLY A 354      40.158 -14.560  21.452  1.00 12.74           C  
ATOM   1034  O   GLY A 354      41.107 -13.782  21.458  1.00 11.88           O  
ATOM   1035  N   LEU A 355      39.101 -14.412  20.654  1.00 12.19           N  
ATOM   1036  CA  LEU A 355      38.986 -13.310  19.697  1.00 12.47           C  
ATOM   1037  C   LEU A 355      38.397 -12.042  20.316  1.00 14.06           C  
ATOM   1038  O   LEU A 355      38.476 -10.967  19.726  1.00 13.94           O  
ATOM   1039  CB  LEU A 355      38.106 -13.734  18.519  1.00 12.53           C  
ATOM   1040  CG  LEU A 355      38.728 -14.323  17.250  1.00 15.28           C  
ATOM   1041  CD1 LEU A 355      40.089 -14.895  17.548  1.00 13.26           C  
ATOM   1042  CD2 LEU A 355      37.798 -15.389  16.676  1.00 13.17           C  
ATOM   1043  N   LYS A 356      37.806 -12.171  21.502  1.00 14.53           N  
ATOM   1044  CA  LYS A 356      37.189 -11.031  22.181  1.00 15.69           C  
ATOM   1045  C   LYS A 356      38.171  -9.919  22.538  1.00 17.18           C  
ATOM   1046  O   LYS A 356      39.344 -10.176  22.822  1.00 17.81           O  
ATOM   1047  CB  LYS A 356      36.474 -11.503  23.447  1.00 14.37           C  
ATOM   1048  CG  LYS A 356      35.282 -12.397  23.170  1.00 14.86           C  
ATOM   1049  CD  LYS A 356      34.616 -12.847  24.468  1.00 20.68           C  
ATOM   1050  N   PRO A 357      37.695  -8.660  22.531  1.00 20.20           N  
ATOM   1051  CA  PRO A 357      38.524  -7.492  22.854  1.00 22.44           C  
ATOM   1052  C   PRO A 357      39.016  -7.516  24.301  1.00 25.53           C  
ATOM   1053  O   PRO A 357      38.211  -7.888  25.181  1.00 27.18           O  
ATOM   1054  CB  PRO A 357      37.602  -6.294  22.592  1.00 22.42           C  
ATOM   1055  CG  PRO A 357      36.410  -6.839  21.868  1.00 20.26           C  
ATOM   1056  CD  PRO A 357      36.304  -8.284  22.220  1.00 21.83           C  
ATOM   1057  N   ASN A 358      40.197  -7.164  24.536  1.00 28.84           N  
TER    1058      ASN A 358                                                      
END
MOLECULE T0429.pdb
ATOM      1  N   GLU    22      23.143   8.727  21.130  1.00172.90      A    N  
ATOM      2  CA  GLU    22      22.374   7.758  20.286  1.00169.34      A    C  
ATOM      3  CB  GLU    22      22.276   8.259  18.835  1.00168.54      A    C  
ATOM      4  CG  GLU    22      23.616   8.393  18.103  1.00158.10      A    C  
ATOM      5  CD  GLU    22      23.457   8.575  16.601  1.00157.25      A    C  
ATOM      6  OE1 GLU    22      24.348   8.113  15.852  1.00147.23      A    O  
ATOM      7  OE2 GLU    22      22.446   9.173  16.165  1.00167.76      A    O  
ATOM      8  C   GLU    22      22.931   6.322  20.338  1.00157.48      A    C  
ATOM      9  O   GLU    22      22.498   5.455  19.576  1.00152.96      A    O  
ATOM     10  N   THR    23      23.876   6.088  21.250  1.00154.10      A    N  
ATOM     11  CA  THR    23      24.505   4.776  21.452  1.00145.40      A    C  
ATOM     12  CB  THR    23      25.730   4.896  22.405  1.00143.94      A    C  
ATOM     13  OG1 THR    23      26.652   5.863  21.883  1.00141.32      A    O  
ATOM     14  CG2 THR    23      26.454   3.563  22.562  1.00136.43      A    C  
ATOM     15  C   THR    23      23.503   3.729  21.972  1.00150.21      A    C  
ATOM     16  O   THR    23      22.570   4.068  22.704  1.00162.36      A    O  
ATOM     17  N   GLU    24      23.706   2.466  21.590  1.00143.04      A    N  
ATOM     18  CA  GLU    24      22.756   1.383  21.886  1.00147.93      A    C  
ATOM     19  CB  GLU    24      22.210   0.789  20.580  1.00144.01      A    C  
ATOM     24  C   GLU    24      23.290   0.256  22.791  1.00146.91      A    C  
ATOM     25  O   GLU    24      22.482  -0.568  23.303  1.00154.53      A    O  
ATOM     26  N   LEU    25      24.636   0.215  22.968  1.00139.01      A    N  
ATOM     27  CA  LEU    25      25.295  -0.776  23.847  1.00138.87      A    C  
ATOM     28  CB  LEU    25      25.029  -0.457  25.346  1.00151.41      A    C  
ATOM     29  CG  LEU    25      26.098  -0.729  26.420  1.00153.60      A    C  
ATOM     30  CD1 LEU    25      25.557  -0.342  27.808  1.00166.65      A    C  
ATOM     31  CD2 LEU    25      26.620  -2.188  26.419  1.00150.16      A    C  
ATOM     32  C   LEU    25      24.901  -2.238  23.511  1.00137.26      A    C  
ATOM     33  O   LEU    25      24.248  -2.938  24.308  1.00144.91      A    O  
ATOM     34  N   LEU    27      24.229  -6.765  19.987  1.00124.47      A    N  
ATOM     35  CA  LEU    27      24.721  -8.135  19.817  1.00123.94      A    C  
ATOM     36  CB  LEU    27      24.018  -8.864  18.654  1.00124.12      A    C  
ATOM     37  CG  LEU    27      23.652  -8.221  17.310  1.00118.98      A    C  
ATOM     38  CD1 LEU    27      23.488  -9.322  16.264  1.00118.08      A    C  
ATOM     38  CD2 LEU    27      22.365  -7.397  17.414  1.00128.31      A    C  
ATOM     40  C   LEU    27      26.247  -8.245  19.696  1.00114.60      A    C  
ATOM     41  O   LEU    27      26.853  -9.156  20.263  1.00117.26      A    O  
ATOM     42  N   TYR    28      26.862  -7.335  18.947  1.00105.66      A    N  
ATOM     43  CA  TYR    28      28.319  -7.200  18.963  1.00 99.30      A    C  
ATOM     44  CB  TYR    28      28.923  -7.286  17.548  1.00 89.68      A    C  
ATOM     45  CG  TYR    28      28.406  -8.478  16.772  1.00 88.71      A    C  
ATOM     46  CD1 TYR    28      28.819  -9.774  17.087  1.00 90.89      A    C  
ATOM     47  CE1 TYR    28      28.325 -10.875  16.393  1.00 93.27      A    C  
ATOM     48  CZ  TYR    28      27.402 -10.683  15.376  1.00 92.44      A    C  
ATOM     49  OH  TYR    28      26.907 -11.765  14.685  1.00 96.36      A    O  
ATOM     50  CE2 TYR    28      26.974  -9.408  15.047  1.00 89.46      A    C  
ATOM     51  CD2 TYR    28      27.475  -8.315  15.748  1.00 87.20      A    C  
ATOM     52  C   TYR    28      28.651  -5.890  19.660  1.00100.94      A    C  
ATOM     53  O   TYR    28      28.114  -4.836  19.311  1.00100.23      A    O  
ATOM     54  N   LYS    29      29.505  -5.973  20.675  1.00104.98      A    N  
ATOM     55  CA  LYS    29      29.862  -4.813  21.481  1.00108.51      A    C  
ATOM     56  CB  LYS    29      30.333  -5.254  22.871  1.00116.86      A    C  
ATOM     61  C   LYS    29      30.923  -3.949  20.793  1.00102.56      A    C  
ATOM     62  O   LYS    29      31.688  -4.428  19.957  1.00 96.86      A    O  
ATOM     63  N   VAL    30      30.941  -2.667  21.147  1.00106.01      A    N  
ATOM     64  CA  VAL    30      31.946  -1.717  20.668  1.00103.19      A    C  
ATOM     65  CB  VAL    30      31.691  -0.300  21.261  1.00109.00      A    C  
ATOM     66  CG1 VAL    30      31.681  -0.327  22.793  1.00117.99      A    C  
ATOM     67  CG2 VAL    30      32.698   0.704  20.741  1.00108.94      A    C  
ATOM     68  C   VAL    30      33.374  -2.211  20.960  1.00103.89      A    C  
ATOM     69  O   VAL    30      33.667  -2.667  22.065  1.00110.81      A    O  
ATOM     70  N   ASN    31      34.238  -2.134  19.948  1.00 98.81      A    N  
ATOM     71  CA  ASN    31      35.638  -2.589  20.016  1.00 99.77      A    C  
ATOM     72  CB  ASN    31      36.312  -2.208  21.337  1.00108.53      A    C  
ATOM     73  CG  ASN    31      36.624  -0.747  21.416  1.00112.78      A    C  
ATOM     74  OD1 ASN    31      35.766   0.061  21.763  1.00116.34      A    O  
ATOM     75  ND2 ASN    31      37.861  -0.390  21.095  1.00116.64      A    N  
ATOM     76  C   ASN    31      35.858  -4.066  19.726  1.00 96.91      A    C  
ATOM     77  O   ASN    31      37.000  -4.499  19.568  1.00 98.59      A    O  
ATOM     78  N   GLU    32      34.779  -4.839  19.660  1.00 94.41      A    N  
ATOM     79  CA  GLU    32      34.889  -6.234  19.254  1.00 93.05      A    C  
ATOM     80  CB  GLU    32      33.592  -6.998  19.533  1.00 94.24      A    C  
ATOM     81  CG  GLU    32      33.730  -8.518  19.443  1.00 96.69      A    C  
ATOM     82  CD  GLU    32      32.437  -9.259  19.760  1.00101.02      A    C  
ATOM     83  OE1 GLU    32      31.677  -8.814  20.653  1.00104.59      A    O  
ATOM     84  OE2 GLU    32      32.191 -10.304  19.112  1.00101.68      A    O  
ATOM     85  C   GLU    32      35.248  -6.293  17.770  1.00 85.89      A    C  
ATOM     86  O   GLU    32      34.742  -5.503  16.970  1.00 81.52      A    O  
ATOM     87  N   TYR    33      36.146  -7.212  17.424  1.00 86.41      A    N  
ATOM     88  CA  TYR    33      36.514  -7.452  16.032  1.00 80.84      A    C  
ATOM     89  CB  TYR    33      37.902  -8.087  15.933  1.00 84.64      A    C  
ATOM     90  CG  TYR    33      39.026  -7.173  16.361  1.00 88.89      A    C  
ATOM     91  CD1 TYR    33      39.565  -6.233  15.478  1.00 87.72      A    C  
ATOM     92  CE1 TYR    33      40.604  -5.390  15.869  1.00 93.77      A    C  
ATOM     93  CZ  TYR    33      41.113  -5.488  17.158  1.00102.17      A    C  
ATOM     94  OH  TYR    33      42.137  -4.665  17.562  1.00109.70      A    O  
ATOM     95  CE2 TYR    33      40.595  -6.415  18.049  1.00103.06      A    C  
ATOM     96  CD2 TYR    33      39.558  -7.251  17.645  1.00 96.63      A    C  
ATOM     97  C   TYR    33      35.481  -8.343  15.365  1.00 77.13      A    C  
ATOM     98  O   TYR    33      34.999  -9.304  15.962  1.00 80.54      A    O  
ATOM     99  N   VAL    34      35.150  -8.015  14.121  1.00 71.92      A    N  
ATOM    100  CA  VAL    34      34.093  -8.702  13.387  1.00 68.82      A    C  
ATOM    101  CB  VAL    34      32.747  -7.920  13.464  1.00 68.44      A    C  
ATOM    102  CG1 VAL    34      32.177  -7.925  14.884  1.00 71.47      A    C  
ATOM    103  CG2 VAL    34      32.898  -6.493  12.926  1.00 64.40      A    C  
ATOM    104  C   VAL    34      34.460  -8.908  11.914  1.00 66.21      A    C  
ATOM    105  O   VAL    34      35.567  -8.577  11.481  1.00 66.29      A    O  
ATOM    106  N   ASP    35      33.522  -9.472  11.162  1.00 64.66      A    N  
ATOM    107  CA  ASP    35      33.597  -9.509   9.715  1.00 63.00      A    C  
ATOM    108  CB  ASP    35      33.407 -10.939   9.202  1.00 63.65      A    C  
ATOM    109  CG  ASP    35      34.686 -11.759   9.244  1.00 64.32      A    C  
ATOM    110  OD1 ASP    35      35.783 -11.188   9.069  1.00 62.56      A    O  
ATOM    111  OD2 ASP    35      34.591 -12.990   9.434  1.00 66.48      A    O  
ATOM    112  C   ASP    35      32.473  -8.627   9.199  1.00 63.11      A    C  
ATOM    113  O   ASP    35      31.344  -8.719   9.686  1.00 65.91      A    O  
ATOM    114  N   ALA    36      32.775  -7.773   8.221  1.00 62.20      A    N  
ATOM    115  CA  ALA    36      31.779  -6.853   7.670  1.00 62.48      A    C  
ATOM    116  CB  ALA    36      32.182  -5.415   7.934  1.00 63.64      A    C  
ATOM    117  C   ALA    36      31.607  -7.080   6.186  1.00 63.86      A    C  
ATOM    118  O   ALA    36      32.589  -7.191   5.452  1.00 65.27      A    O  
ATOM    119  N   ARG    37      30.358  -7.138   5.744  1.00 66.32      A    N  
ATOM    120  CA  ARG    37      30.057  -7.410   4.344  1.00 70.06      A    C  
ATOM    121  CB  ARG    37      28.720  -8.159   4.199  1.00 73.46      A    C  
ATOM    122  CG  ARG    37      28.518  -8.813   2.829  1.00 77.70      A    C  
ATOM    123  CD  ARG    37      27.182  -9.543   2.729  1.00 83.79      A    C  
ATOM    124  NE  ARG    37      26.063  -8.613   2.586  1.00 92.01      A    N  
ATOM    125  CZ  ARG    37      25.427  -8.344   1.445  1.00 99.69      A    C  
ATOM    126  NH1 ARG    37      25.775  -8.943   0.309  1.00101.62      A    N  
ATOM    127  NH2 ARG    37      24.425  -7.472   1.444  1.00105.62      A    N  
ATOM    128  C   ARG    37      30.043  -6.122   3.535  1.00 72.97      A    C  
ATOM    129  O   ARG    37      29.183  -5.267   3.734  1.00 76.28      A    O  
ATOM    130  N   ASP    38      31.015  -5.980   2.640  1.00 74.45      A    N  
ATOM    131  CA  ASP    38      30.995  -4.906   1.661  1.00 81.28      A    C  
ATOM    132  CB  ASP    38      32.279  -4.924   0.825  1.00 83.16      A    C  
ATOM    133  CG  ASP    38      32.369  -3.768  -0.157  1.00 91.41      A    C  
ATOM    134  OD1 ASP    38      31.439  -3.583  -0.965  1.00 98.91      A    O  
ATOM    135  OD2 ASP    38      33.394  -3.058  -0.145  1.00 93.84      A    O  
ATOM    136  C   ASP    38      29.768  -5.148   0.794  1.00 87.58      A    C  
ATOM    137  O   ASP    38      29.730  -6.094   0.011  1.00 90.08      A    O  
ATOM    138  N   THR    39      28.754  -4.307   0.961  1.00 92.61      A    N  
ATOM    139  CA  THR    39      27.483  -4.487   0.262  1.00101.09      A    C  
ATOM    140  CB  THR    39      26.377  -3.589   0.863  1.00105.79      A    C  
ATOM    141  OG1 THR    39      26.310  -3.809   2.276  1.00100.08      A    O  
ATOM    142  CG2 THR    39      25.014  -3.910   0.258  1.00115.77      A    C  
ATOM    143  C   THR    39      27.621  -4.263  -1.246  1.00109.30      A    C  
ATOM    144  O   THR    39      26.849  -4.811  -2.034  1.00116.02      A    O  
ATOM    145  N   ASN    40      28.617  -3.475  -1.640  1.00111.13      A    N  
ATOM    146  CA  ASN    40      28.866  -3.188  -3.050  1.00121.02      A    C  
ATOM    147  CB  ASN    40      29.891  -2.057  -3.191  1.00124.44      A    C  
ATOM    148  CG  ASN    40      30.409  -1.907  -4.609  1.00135.60      A    C  
ATOM    149  OD1 ASN    40      31.550  -2.269  -4.903  1.00135.88      A    O  
ATOM    150  ND2 ASN    40      29.567  -1.391  -5.502  1.00147.42      A    N  
ATOM    151  C   ASN    40      29.296  -4.418  -3.857  1.00120.57      A    C  
ATOM    152  O   ASN    40      28.922  -4.560  -5.022  1.00129.57      A    O  
ATOM    153  N   MET    41      30.064  -5.308  -3.234  1.00111.84      A    N  
ATOM    154  CA  MET    41      30.606  -6.478  -3.933  1.00112.47      A    C  
ATOM    155  CB  MET    41      32.122  -6.373  -4.048  1.00111.40      A    C  
ATOM    156  CG  MET    41      32.807  -6.077  -2.737  1.00103.73      A    C  
ATOM    157  SD  MET    41      34.733  -6.073  -2.908  1.00108.38      A   SE  
ATOM    158  CE  MET    41      34.947  -4.830  -4.410  1.00120.35      A    C  
ATOM    159  C   MET    41      30.224  -7.818  -3.307  1.00105.36      A    C  
ATOM    160  O   MET    41      30.327  -8.863  -3.955  1.00106.85      A    O  
ATOM    161  N   GLY    42      29.804  -7.780  -2.047  1.00 83.71      A    N  
ATOM    162  CA  GLY    42      29.269  -8.959  -1.367  1.00 83.07      A    C  
ATOM    163  C   GLY    42      30.262  -9.792  -0.578  1.00 77.08      A    C  
ATOM    164  O   GLY    42      29.914 -10.867  -0.090  1.00 77.31      A    O  
ATOM    165  N   ALA    43      31.490  -9.300  -0.446  1.00 72.89      A    N  
ATOM    166  CA  ALA    43      32.548 -10.041   0.234  1.00 69.07      A    C  
ATOM    167  CB  ALA    43      33.865  -9.848  -0.491  1.00 68.37      A    C  
ATOM    168  C   ALA    43      32.669  -9.636   1.703  1.00 65.34      A    C  
ATOM    169  O   ALA    43      32.300  -8.525   2.077  1.00 65.78      A    O  
ATOM    170  N   TRP    44      33.183 -10.537   2.535  1.00 64.28      A    N  
ATOM    171  CA  TRP    44      33.399 -10.241   3.953  1.00 61.58      A    C  
ATOM    172  CB  TRP    44      32.987 -11.425   4.830  1.00 63.28      A    C  
ATOM    173  CG  TRP    44      31.522 -11.742   4.770  1.00 66.96      A    C  
ATOM    174  CD1 TRP    44      30.893 -12.523   3.846  1.00 71.29      A    C  
ATOM    175  NE1 TRP    44      29.547 -12.583   4.112  1.00 75.54      A    N  
ATOM    176  CE2 TRP    44      29.278 -11.826   5.222  1.00 74.38      A    C  
ATOM    177  CD2 TRP    44      30.503 -11.280   5.667  1.00 69.18      A    C  
ATOM    178  CE3 TRP    44      30.505 -10.458   6.805  1.00 68.75      A    C  
ATOM    179  CZ3 TRP    44      29.298 -10.209   7.452  1.00 70.28      A    C  
ATOM    180  CH2 TRP    44      28.096 -10.769   6.986  1.00 75.60      A    C  
ATOM    181  CZ2 TRP    44      28.063 -11.578   5.876  1.00 76.96      A    C  
ATOM    182  C   TRP    44      34.850  -9.851   4.236  1.00 60.04      A    C  
ATOM    183  O   TRP    44      35.789 -10.497   3.740  1.00 59.62      A    O  
ATOM    184  N   PHE    45      35.017  -8.797   5.038  1.00 57.06      A    N  
ATOM    185  CA  PHE    45      36.331  -8.252   5.361  1.00 55.38      A    C  
ATOM    186  CB  PHE    45      36.541  -6.899   4.673  1.00 54.74      A    C  
ATOM    187  CG  PHE    45      36.523  -6.953   3.157  1.00 58.74      A    C  
ATOM    188  CD1 PHE    45      37.701  -7.144   2.439  1.00 58.08      A    C  
ATOM    189  CE1 PHE    45      37.695  -7.170   1.046  1.00 62.77      A    C  
ATOM    190  CZ  PHE    45      36.501  -7.000   0.344  1.00 63.52      A    C  
ATOM    191  CE2 PHE    45      35.321  -6.799   1.049  1.00 65.02      A    C  
ATOM    192  CD2 PHE    45      35.334  -6.773   2.448  1.00 58.18      A    C  
ATOM    193  C   PHE    45      36.481  -8.089   6.879  1.00 55.58      A    C  
ATOM    194  O   PHE    45      35.519  -7.741   7.578  1.00 55.09      A    O  
ATOM    195  N   GLU    46      37.686  -8.344   7.381  1.00 56.08      A    N  
ATOM    196  CA  GLU    46      37.969  -8.188   8.805  1.00 57.83      A    C  
ATOM    197  CB  GLU    46      39.401  -8.620   9.155  1.00 59.91      A    C  
ATOM    198  CG  GLU    46      39.750 -10.086   8.880  1.00 61.88      A    C  
ATOM    199  CD  GLU    46      40.313 -10.306   7.470  1.00 65.85      A    C  
ATOM    200  OE1 GLU    46      39.935  -9.574   6.516  1.00 60.16      A    O  
ATOM    201  OE2 GLU    46      41.147 -11.223   7.320  1.00 72.28      A    O  
ATOM    202  C   GLU    46      37.762  -6.724   9.155  1.00 57.63      A    C  
ATOM    203  O   GLU    46      38.320  -5.836   8.509  1.00 58.66      A    O  
ATOM    204  N   ALA    47      36.924  -6.478  10.150  1.00 57.65      A    N  
ATOM    205  CA  ALA    47      36.649  -5.120  10.594  1.00 58.18      A    C  
ATOM    206  CB  ALA    47      35.406  -4.582   9.895  1.00 56.70      A    C  
ATOM    207  C   ALA    47      36.505  -5.054  12.117  1.00 60.50      A    C  
ATOM    208  O   ALA    47      36.526  -6.082  12.792  1.00 61.81      A    O  
ATOM    209  N   GLN    48      36.390  -3.842  12.652  1.00 63.44      A    N  
ATOM    210  CA  GLN    48      36.171  -3.640  14.084  1.00 67.12      A    C  
ATOM    211  CB  GLN    48      37.456  -3.160  14.766  1.00 71.03      A    C  
ATOM    212  CG  GLN    48      37.367  -3.069  16.297  1.00 75.40      A    C  
ATOM    213  CD  GLN    48      38.641  -2.565  16.949  1.00 80.70      A    C  
ATOM    214  OE1 GLN    48      39.520  -2.019  16.287  1.00 80.17      A    O  
ATOM    215  NE2 GLN    48      38.742  -2.741  18.266  1.00 86.01      A    N  
ATOM    216  C   GLN    48      35.030  -2.652  14.331  1.00 69.25      A    C  
ATOM    217  O   GLN    48      34.873  -1.667  13.598  1.00 67.51      A    O  
ATOM    218  N   VAL    49      34.243  -2.927  15.369  1.00 72.79      A    N  
ATOM    219  CA  VAL    49      33.117  -2.082  15.740  1.00 76.25      A    C  
ATOM    220  CB  VAL    49      32.072  -2.853  16.579  1.00 80.46      A    C  
ATOM    221  CG1 VAL    49      30.933  -1.925  17.006  1.00 82.55      A    C  
ATOM    222  CG2 VAL    49      31.539  -4.055  15.802  1.00 75.52      A    C  
ATOM    223  C   VAL    49      33.586  -0.852  16.516  1.00 81.59      A    C  
ATOM    224  O   VAL    49      34.141  -0.962  17.614  1.00 86.04      A    O  
ATOM    225  N   VAL    50      33.342   0.318  15.936  1.00 81.58      A    N  
ATOM    226  CA  VAL    50      33.742   1.586  16.532  1.00 85.85      A    C  
ATOM    227  CB  VAL    50      34.190   2.582  15.439  1.00 82.87      A    C  
ATOM    228  CG1 VAL    50      34.390   3.946  16.021  1.00 90.16      A    C  
ATOM    229  CG2 VAL    50      35.466   2.109  14.799  1.00 79.12      A    C  
ATOM    230  C   VAL    50      32.618   2.185  17.389  1.00 91.85      A    C  
ATOM    231  O   VAL    50      32.866   2.721  18.476  1.00 97.97      A    O  
ATOM    232  N   ARG    51      31.391   2.106  16.883  1.00 91.35      A    N  
ATOM    233  CA  ARG    51      30.213   2.553  17.613  1.00 98.00      A    C  
ATOM    234  CB  ARG    51      29.917   4.032  17.340  1.00100.80      A    C  
ATOM    235  CG  ARG    51      30.506   4.983  18.377  1.00107.46      A    C  
ATOM    236  CD  ARG    51      30.332   6.443  17.985  1.00110.40      A    C  
ATOM    237  NE  ARG    51      28.942   6.883  18.103  1.00118.29      A    N  
ATOM    238  CZ  ARG    51      28.426   7.482  19.175  1.00129.05      A    C  
ATOM    239  NH1 ARG    51      29.181   7.730  20.240  1.00134.40      A    N  
ATOM    240  NH2 ARG    51      27.146   7.840  19.187  1.00134.91      A    N  
ATOM    241  C   ARG    51      29.012   1.691  17.255  1.00 97.71      A    C  
ATOM    242  O   ARG    51      28.957   1.107  16.169  1.00 92.82      A    O  
ATOM    243  N   VAL    52      28.066   1.598  18.186  1.00104.09      A    N  
ATOM    244  CA  VAL    52      26.811   0.891  17.951  1.00105.53      A    C  
ATOM    245  CB  VAL    52      26.746  -0.447  18.749  1.00107.07      A    C  
ATOM    246  CG1 VAL    52      26.856  -0.214  20.262  1.00116.59      A    C  
ATOM    247  CG2 VAL    52      25.491  -1.224  18.406  1.00109.24      A    C  
ATOM    248  C   VAL    52      25.618   1.825  18.217  1.00112.85      A    C  
ATOM    249  O   VAL    52      25.528   2.453  19.276  1.00118.62      A    O  
ATOM    250  N   THR    53      24.724   1.920  17.235  1.00113.10      A    N  
ATOM    251  CA  THR    53      23.602   2.862  17.269  1.00121.51      A    C  
ATOM    252  CB  THR    53      23.697   3.858  16.086  1.00119.01      A    C  
ATOM    253  OG1 THR    53      25.050   4.292  15.937  1.00114.19      A    O  
ATOM    254  CG2 THR    53      22.815   5.078  16.309  1.00129.22      A    C  
ATOM    255  C   THR    53      22.252   2.129  17.233  1.00126.92      A    C  
ATOM    256  O   THR    53      22.201   0.930  16.948  1.00124.34      A    O  
ATOM    257  N   ARG    54      21.171   2.851  17.529  1.00135.79      A    N  
ATOM    258  CA  ARG    54      19.816   2.299  17.465  1.00143.10      A    C  
ATOM    259  CB  ARG    54      19.136   2.367  18.841  1.00152.93      A    C  
ATOM    266  C   ARG    54      18.965   3.026  16.419  1.00146.96      A    C  
ATOM    267  O   ARG    54      18.946   2.629  15.229  1.00142.84      A    O  
ATOM    268  N   GLU    73      20.100  -6.332  15.059  1.00123.32      A    N  
ATOM    269  CA  GLU    73      18.671  -6.470  14.844  1.00132.67      A    C  
ATOM    270  CB  GLU    73      18.053  -7.343  15.943  1.00141.48      A    C  
ATOM    271  CG  GLU    73      18.457  -6.965  17.377  1.00145.34      A    C  
ATOM    272  CD  GLU    73      17.406  -7.360  18.407  1.00159.33      A    C  
ATOM    273  OE1 GLU    73      16.940  -8.524  18.379  1.00163.38      A    O  
ATOM    274  OE2 GLU    73      17.047  -6.503  19.249  1.00167.09      A    O  
ATOM    275  C   GLU    73      18.000  -5.098  14.802  1.00137.46      A    C  
ATOM    276  O   GLU    73      17.488  -4.614  15.820  1.00144.45      A    O  
ATOM    277  N   ASP    74      18.001  -4.475  13.621  1.00134.20      A    N  
ATOM    278  CA  ASP    74      17.565  -3.076  13.462  1.00137.77      A    C  
ATOM    279  CB  ASP    74      16.132  -2.870  13.992  1.00150.47      A    C  
ATOM    280  CG  ASP    74      15.447  -1.638  13.404  1.00157.01      A    C  
ATOM    281  OD1 ASP    74      16.084  -0.904  12.614  1.00151.95      A    O  
ATOM    282  OD2 ASP    74      14.261  -1.406  13.738  1.00166.48      A    O  
ATOM    283  C   ASP    74      18.571  -2.133  14.150  1.00132.38      A    C  
ATOM    284  O   ASP    74      18.362  -0.917  14.243  1.00135.67      A    O  
ATOM    285  N   VAL    75      19.658  -2.731  14.633  1.00124.52      A    N  
ATOM    286  CA  VAL    75      20.823  -2.029  15.155  1.00117.47      A    C  
ATOM    287  CB  VAL    75      21.627  -2.956  16.115  1.00114.64      A    C  
ATOM    288  CG1 VAL    75      23.095  -2.588  16.171  1.00105.73      A    C  
ATOM    289  CG2 VAL    75      21.012  -2.949  17.511  1.00123.12      A    C  
ATOM    290  C   VAL    75      21.679  -1.621  13.962  1.00108.96      A    C  
ATOM    291  O   VAL    75      21.740  -2.351  12.968  1.00104.98      A    O  
ATOM    292  N   ILE    76      22.315  -0.453  14.052  1.00106.20      A    N  
ATOM    293  CA  ILE    76      23.261  -0.013  13.023  1.00 99.14      A    C  
ATOM    294  CB  ILE    76      22.765   1.254  12.255  1.00102.73      A    C  
ATOM    295  CG1 ILE    76      23.853   1.796  11.319  1.00 96.23      A    C  
ATOM    296  CD1 ILE    76      23.310   2.429  10.045  1.00 99.72      A    C  
ATOM    297  CG2 ILE    76      22.252   2.323  13.216  1.00110.67      A    C  
ATOM    298  C   ILE    76      24.690   0.120  13.573  1.00 92.90      A    C  
ATOM    299  O   ILE    76      24.945   0.887  14.499  1.00 95.46      A    O  
ATOM    300  N   TYR    77      25.607  -0.649  12.990  1.00 93.66      A    N  
ATOM    301  CA  TYR    77      26.991  -0.728  13.458  1.00 88.85      A    C  
ATOM    302  CB  TYR    77      27.533  -2.147  13.273  1.00 85.70      A    C  
ATOM    303  CG  TYR    77      26.943  -3.158  14.228  1.00 89.17      A    C  
ATOM    304  CD1 TYR    77      27.333  -3.187  15.566  1.00 90.70      A    C  
ATOM    305  CE1 TYR    77      26.796  -4.113  16.452  1.00 95.37      A    C  
ATOM    306  CZ  TYR    77      25.860  -5.028  16.005  1.00 96.78      A    C  
ATOM    307  OH  TYR    77      25.339  -5.937  16.890  1.00100.18      A    O  
ATOM    308  CE2 TYR    77      25.456  -5.027  14.677  1.00 95.16      A    C  
ATOM    309  CD2 TYR    77      26.000  -4.091  13.797  1.00 90.70      A    C  
ATOM    310  C   TYR    77      27.916   0.258  12.760  1.00 85.38      A    C  
ATOM    311  O   TYR    77      27.856   0.421  11.542  1.00 84.45      A    O  
ATOM    312  N   HIS    78      28.773   0.910  13.541  1.00 83.71      A    N  
ATOM    313  CA  HIS    78      29.810   1.770  12.989  1.00 81.14      A    C  
ATOM    314  CB  HIS    78      29.910   3.077  13.762  1.00 83.22      A    C  
ATOM    315  CG  HIS    78      28.703   3.945  13.615  1.00 87.89      A    C  
ATOM    316  ND1 HIS    78      28.769   5.234  13.134  1.00 90.48      A    N  
ATOM    317  CE1 HIS    78      27.554   5.752  13.107  1.00 94.69      A    C  
ATOM    318  NE2 HIS    78      26.702   4.840  13.539  1.00 96.87      A    N  
ATOM    319  CD2 HIS    78      27.395   3.699  13.861  1.00 91.50      A    C  
ATOM    320  C   HIS    78      31.117   1.019  13.031  1.00 77.65      A    C  
ATOM    321  O   HIS    78      31.556   0.572  14.093  1.00 78.47      A    O  
ATOM    322  N   VAL    79      31.736   0.895  11.864  1.00 73.81      A    N  
ATOM    323  CA  VAL    79      32.790  -0.070  11.660  1.00 70.60      A    C  
ATOM    324  CB  VAL    79      32.193  -1.323  10.934  1.00 70.59      A    C  
ATOM    325  CG1 VAL    79      33.109  -1.881   9.858  1.00 64.14      A    C  
ATOM    326  CG2 VAL    79      31.785  -2.385  11.956  1.00 70.14      A    C  
ATOM    327  C   VAL    79      33.993   0.529  10.929  1.00 69.42      A    C  
ATOM    328  O   VAL    79      33.844   1.379  10.051  1.00 69.22      A    O  
ATOM    329  N   LYS    80      35.186   0.100  11.328  1.00 69.05      A    N  
ATOM    330  CA  LYS    80      36.402   0.409  10.586  1.00 69.09      A    C  
ATOM    331  CB  LYS    80      37.372   1.251  11.422  1.00 70.54      A    C  
ATOM    332  CG  LYS    80      38.019   0.522  12.589  1.00 71.11      A    C  
ATOM    333  CD  LYS    80      38.951   1.430  13.346  1.00 72.80      A    C  
ATOM    334  CE  LYS    80      39.612   0.680  14.484  1.00 77.21      A    C  
ATOM    335  NZ  LYS    80      40.206   1.598  15.499  1.00 80.41      A    N  
ATOM    336  C   LYS    80      37.069  -0.878  10.094  1.00 68.73      A    C  
ATOM    337  O   LYS    80      37.050  -1.904  10.783  1.00 67.58      A    O  
ATOM    338  N   TYR    81      37.642  -0.809   8.895  1.00 69.17      A    N  
ATOM    339  CA  TYR    81      38.314  -1.942   8.276  1.00 69.65      A    C  
ATOM    340  CB  TYR    81      38.192  -1.871   6.756  1.00 71.26      A    C  
ATOM    341  CG  TYR    81      36.782  -2.058   6.257  1.00 73.36      A    C  
ATOM    342  CD1 TYR    81      35.942  -0.962   6.046  1.00 76.49      A    C  
ATOM    343  CE1 TYR    81      34.632  -1.135   5.589  1.00 78.01      A    C  
ATOM    344  CZ  TYR    81      34.160  -2.417   5.342  1.00 77.56      A    C  
ATOM    345  OH  TYR    81      32.871  -2.611   4.885  1.00 80.19      A    O  
ATOM    346  CE2 TYR    81      34.981  -3.517   5.552  1.00 75.57      A    C  
ATOM    347  CD2 TYR    81      36.279  -3.333   6.010  1.00 72.40      A    C  
ATOM    348  C   TYR    81      39.777  -2.026   8.675  1.00 70.89      A    C  
ATOM    349  O   TYR    81      40.533  -1.050   8.563  1.00 71.51      A    O  
ATOM    350  N   ASP    82      40.164  -3.215   9.130  1.00 71.89      A    N  
ATOM    351  CA  ASP    82      41.516  -3.480   9.609  1.00 73.79      A    C  
ATOM    352  CB  ASP    82      41.648  -4.954  10.017  1.00 74.15      A    C  
ATOM    353  CG  ASP    82      40.868  -5.285  11.286  1.00 76.59      A    C  
ATOM    354  OD1 ASP    82      40.138  -4.405  11.803  1.00 78.41      A    O  
ATOM    355  OD2 ASP    82      40.989  -6.432  11.775  1.00 78.61      A    O  
ATOM    356  C   ASP    82      42.576  -3.103   8.576  1.00 74.38      A    C  
ATOM    357  O   ASP    82      43.536  -2.406   8.898  1.00 77.23      A    O  
ATOM    358  N   ASP    83      42.376  -3.540   7.336  1.00 72.34      A    N  
ATOM    359  CA  ASP    83      43.368  -3.352   6.288  1.00 72.89      A    C  
ATOM    360  CB  ASP    83      43.600  -4.675   5.546  1.00 73.65      A    C  
ATOM    361  CG  ASP    83      44.090  -5.780   6.467  1.00 75.64      A    C  
ATOM    362  OD1 ASP    83      45.026  -5.529   7.263  1.00 79.90      A    O  
ATOM    363  OD2 ASP    83      43.535  -6.899   6.399  1.00 75.47      A    O  
ATOM    364  C   ASP    83      43.012  -2.238   5.307  1.00 72.04      A    C  
ATOM    365  O   ASP    83      43.717  -2.037   4.311  1.00 73.88      A    O  
ATOM    366  N   TYR    84      41.927  -1.517   5.582  1.00 69.13      A    N  
ATOM    367  CA  TYR    84      41.477  -0.450   4.687  1.00 69.06      A    C  
ATOM    368  CB  TYR    84      40.293  -0.925   3.838  1.00 67.58      A    C  
ATOM    369  CG  TYR    84      40.560  -2.187   3.072  1.00 66.36      A    C  
ATOM    370  CD1 TYR    84      41.057  -2.140   1.773  1.00 68.00      A    C  
ATOM    371  CE1 TYR    84      41.312  -3.305   1.067  1.00 69.12      A    C  
ATOM    372  CZ  TYR    84      41.063  -4.533   1.656  1.00 66.52      A    C  
ATOM    373  OH  TYR    84      41.309  -5.690   0.957  1.00 68.36      A    O  
ATOM    374  CE2 TYR    84      40.569  -4.603   2.945  1.00 65.02      A    C  
ATOM    375  CD2 TYR    84      40.318  -3.433   3.644  1.00 63.68      A    C  
ATOM    376  C   TYR    84      41.094   0.836   5.421  1.00 69.64      A    C  
ATOM    377  O   TYR    84      39.916   1.207   5.433  1.00 69.47      A    O  
ATOM    378  N   PRO    85      42.084   1.534   6.020  1.00 70.58      A    N  
ATOM    379  CA  PRO    85      41.773   2.784   6.721  1.00 70.66      A    C  
ATOM    380  CB  PRO    85      43.114   3.175   7.348  1.00 72.50      A    C  
ATOM    381  CG  PRO    85      44.141   2.518   6.489  1.00 73.96      A    C  
ATOM    382  CD  PRO    85      43.525   1.219   6.080  1.00 72.47      A    C  
ATOM    383  C   PRO    85      41.266   3.886   5.780  1.00 71.62      A    C  
ATOM    384  O   PRO    85      40.622   4.830   6.230  1.00 71.33      A    O  
ATOM    385  N   GLU    86      41.546   3.751   4.485  1.00 73.37      A    N  
ATOM    386  CA  GLU    86      41.039   4.679   3.476  1.00 75.64      A    C  
ATOM    387  CB  GLU    86      41.735   4.463   2.122  1.00 78.50      A    C  
ATOM    388  CG  GLU    86      41.443   3.121   1.422  1.00 78.65      A    C  
ATOM    389  CD  GLU    86      42.359   1.979   1.859  1.00 76.94      A    C  
ATOM    390  OE1 GLU    86      42.547   1.037   1.060  1.00 77.72      A    O  
ATOM    391  OE2 GLU    86      42.890   2.012   2.992  1.00 76.80      A    O  
ATOM    392  C   GLU    86      39.514   4.604   3.332  1.00 75.93      A    C  
ATOM    393  O   GLU    86      38.896   5.510   2.775  1.00 79.57      A    O  
ATOM    394  N   ASN    87      38.915   3.529   3.843  1.00 74.12      A    N  
ATOM    395  CA  ASN    87      37.456   3.377   3.865  1.00 73.88      A    C  
ATOM    396  CB  ASN    87      37.066   1.910   4.057  1.00 72.05      A    C  
ATOM    397  CG  ASN    87      37.319   1.066   2.821  1.00 73.77      A    C  
ATOM    398  OD1 ASN    87      37.855   1.542   1.815  1.00 75.97      A    O  
ATOM    399  ND2 ASN    87      36.926  -0.201   2.891  1.00 74.00      A    N  
ATOM    400  C   ASN    87      36.762   4.227   4.928  1.00 73.27      A    C  
ATOM    401  O   ASN    87      35.550   4.423   4.874  1.00 75.05      A    O  
ATOM    402  N   GLY    88      37.531   4.721   5.894  1.00 71.73      A    N  
ATOM    403  CA  GLY    88      36.985   5.521   6.984  1.00 70.82      A    C  
ATOM    404  C   GLY    88      36.114   4.688   7.898  1.00 69.49      A    C  
ATOM    405  O   GLY    88      36.270   3.471   7.961  1.00 68.16      A    O  
ATOM    406  N   VAL    89      35.206   5.350   8.612  1.00 70.56      A    N  
ATOM    407  CA  VAL    89      34.196   4.670   9.414  1.00 71.17      A    C  
ATOM    408  CB  VAL    89      33.888   5.413  10.748  1.00 72.80      A    C  
ATOM    409  CG1 VAL    89      32.826   4.671  11.550  1.00 73.51      A    C  
ATOM    410  CG2 VAL    89      35.142   5.548  11.580  1.00 71.42      A    C  
ATOM    411  C   VAL    89      32.928   4.502   8.570  1.00 73.41      A    C  
ATOM    412  O   VAL    89      32.409   5.472   8.000  1.00 74.86      A    O  
ATOM    413  N   VAL    90      32.453   3.258   8.493  1.00 73.03      A    N  
ATOM    414  CA  VAL    90      31.321   2.886   7.650  1.00 75.55      A    C  
ATOM    415  CB  VAL    90      31.726   1.802   6.610  1.00 73.49      A    C  
ATOM    416  CG1 VAL    90      30.564   1.471   5.676  1.00 76.90      A    C  
ATOM    417  CG2 VAL    90      32.935   2.247   5.802  1.00 72.13      A    C  
ATOM    418  C   VAL    90      30.170   2.361   8.509  1.00 78.45      A    C  
ATOM    419  O   VAL    90      30.374   1.542   9.411  1.00 77.22      A    O  
ATOM    420  N   GLN    91      28.965   2.843   8.218  1.00 83.52      A    N  
ATOM    421  CA  GLN    91      27.755   2.390   8.897  1.00 87.88      A    C  
ATOM    422  CB  GLN    91      26.682   3.467   8.832  1.00 92.88      A    C  
ATOM    423  CG  GLN    91      27.037   4.717   9.618  1.00 93.91      A    C  
ATOM    424  CD  GLN    91      25.943   5.755   9.589  1.00 99.60      A    C  
ATOM    425  OE1 GLN    91      26.208   6.939   9.389  1.00101.46      A    O  
ATOM    426  NE2 GLN    91      24.703   5.322   9.788  1.00105.50      A    N  
ATOM    427  C   GLN    91      27.243   1.090   8.293  1.00 88.99      A    C  
ATOM    428  O   GLN    91      27.083   0.980   7.079  1.00 90.22      A    O  
ATOM    429  N   MET    92      26.981   0.113   9.156  1.00 90.02      A    N  
ATOM    430  CA  MET    92      26.645  -1.241   8.737  1.00 90.94      A    C  
ATOM    431  CB  MET    92      27.692  -2.221   9.268  1.00 88.07      A    C  
ATOM    432  CG  MET    92      29.111  -1.959   8.803  1.00 88.61      A    C  
ATOM    433  SD  MET    92      29.351  -2.318   6.905  1.00 98.62      A   SE  
ATOM    434  CE  MET    92      28.929  -4.197   6.883  1.00 91.66      A    C  
ATOM    435  C   MET    92      25.273  -1.687   9.236  1.00 95.56      A    C  
ATOM    436  O   MET    92      24.911  -1.435  10.385  1.00 97.05      A    O  
ATOM    437  N   ASN    93      24.522  -2.361   8.368  1.00 97.87      A    N  
ATOM    438  CA  ASN    93      23.301  -3.045   8.779  1.00102.77      A    C  
ATOM    439  CB  ASN    93      22.460  -3.441   7.563  1.00106.54      A    C  
ATOM    440  CG  ASN    93      21.019  -3.772   7.928  1.00114.89      A    C  
ATOM    441  OD1 ASN    93      20.744  -4.745   8.638  1.00116.51      A    O  
ATOM    442  ND2 ASN    93      20.090  -2.967   7.431  1.00121.11      A    N  
ATOM    443  C   ASN    93      23.673  -4.280   9.590  1.00100.09      A    C  
ATOM    444  O   ASN    93      24.659  -4.952   9.284  1.00 94.90      A    O  
ATOM    445  N   SER    94      22.877  -4.571  10.617  1.00103.84      A    N  
ATOM    446  CA  SER    94      23.168  -5.647  11.574  1.00102.37      A    C  
ATOM    447  CB  SER    94      22.088  -5.692  12.660  1.00109.16      A    C  
ATOM    448  OG  SER    94      22.463  -6.552  13.726  1.00109.46      A    O  
ATOM    449  C   SER    94      23.328  -7.033  10.943  1.00 99.33      A    C  
ATOM    450  O   SER    94      23.924  -7.923  11.548  1.00 96.67      A    O  
ATOM    451  N   ARG    95      22.787  -7.207   9.738  1.00100.12      A    N  
ATOM    452  CA  ARG    95      22.866  -8.476   9.012  1.00 98.31      A    C  
ATOM    453  CB  ARG    95      21.658  -8.642   8.083  1.00103.51      A    C  
ATOM    454  CG  ARG    95      21.541  -7.572   7.000  1.00105.74      A    C  
ATOM    455  CD  ARG    95      20.258  -7.724   6.207  1.00112.78      A    C  
ATOM    456  NE  ARG    95      20.009  -6.556   5.366  1.00118.15      A    N  
ATOM    460  C   ARG    95      24.162  -8.567   8.214  1.00 91.56      A    C  
ATOM    461  O   ARG    95      24.609  -9.665   7.850  1.00 88.39      A    O  
ATOM    462  N   ASP    96      24.750  -7.399   7.951  1.00 89.10      A    N  
ATOM    463  CA  ASP    96      25.999  -7.276   7.205  1.00 82.96      A    C  
ATOM    464  CB  ASP    96      25.998  -5.988   6.373  1.00 83.81      A    C  
ATOM    465  CG  ASP    96      25.193  -6.112   5.088  1.00 87.00      A    C  
ATOM    466  OD1 ASP    96      24.933  -7.246   4.636  1.00 87.12      A    O  
ATOM    467  OD2 ASP    96      24.829  -5.063   4.519  1.00 89.68      A    O  
ATOM    468  C   ASP    96      27.236  -7.329   8.109  1.00 78.81      A    C  
ATOM    469  O   ASP    96      28.366  -7.175   7.633  1.00 75.79      A    O  
ATOM    470  N   VAL    97      27.025  -7.546   9.406  1.00 79.24      A    N  
ATOM    471  CA  VAL    97      28.137  -7.792  10.337  1.00 76.33      A    C  
ATOM    472  CB  VAL    97      28.549  -6.514  11.163  1.00 76.33      A    C  
ATOM    473  CG1 VAL    97      27.457  -5.473  11.146  1.00 81.16      A    C  
ATOM    474  CG2 VAL    97      28.977  -6.853  12.599  1.00 76.18      A    C  
ATOM    475  C   VAL    97      27.883  -9.017  11.216  1.00 77.38      A    C  
ATOM    476  O   VAL    97      26.768  -9.236  11.698  1.00 81.25      A    O  
ATOM    477  N   ARG    98      28.926  -9.823  11.394  1.00 73.62      A    N  
ATOM    478  CA  ARG    98      28.844 -11.037  12.197  1.00 74.98      A    C  
ATOM    479  CB  ARG    98      28.402 -12.230  11.333  1.00 74.25      A    C  
ATOM    480  CG  ARG    98      29.415 -12.653  10.279  1.00 69.79      A    C  
ATOM    481  CD  ARG    98      28.820 -13.641   9.295  1.00 70.18      A    C  
ATOM    482  NE  ARG    98      29.792 -14.010   8.269  1.00 67.23      A    N  
ATOM    483  CZ  ARG    98      29.480 -14.503   7.072  1.00 66.25      A    C  
ATOM    484  NH1 ARG    98      28.214 -14.686   6.730  1.00 69.46      A    N  
ATOM    485  NH2 ARG    98      30.438 -14.808   6.209  1.00 62.39      A    N  
ATOM    486  C   ARG    98      30.189 -11.316  12.861  1.00 73.07      A    C  
ATOM    487  O   ARG    98      31.182 -10.655  12.555  1.00 70.00      A    O  
ATOM    488  N   ALA    99      30.215 -12.295  13.763  1.00 75.78      A    N  
ATOM    489  CA  ALA    99      31.446 -12.698  14.440  1.00 76.68      A    C  
ATOM    490  CB  ALA    99      31.164 -13.801  15.444  1.00 79.68      A    C  
ATOM    491  C   ALA    99      32.484 -13.157  13.423  1.00 73.07      A    C  
ATOM    492  O   ALA    99      32.138 -13.801  12.434  1.00 72.70      A    O  
ATOM    493  N   ARG   100      33.748 -12.822  13.671  1.00 72.44      A    N  
ATOM    494  CA  ARG   100      34.839 -13.184  12.777  1.00 71.01      A    C  
ATOM    495  CB  ARG   100      36.168 -12.642  13.305  1.00 71.60      A    C  
ATOM    496  CG  ARG   100      37.275 -12.682  12.273  1.00 71.40      A    C  
ATOM    497  CD  ARG   100      38.385 -11.712  12.580  1.00 73.85      A    C  
ATOM    498  NE  ARG   100      38.010 -10.331  12.296  1.00 73.41      A    N  
ATOM    499  CZ  ARG   100      38.795  -9.285  12.528  1.00 75.14      A    C  
ATOM    500  NH1 ARG   100      38.373  -8.063  12.255  1.00 75.99      A    N  
ATOM    501  NH2 ARG   100      40.004  -9.457  13.035  1.00 80.38      A    N  
ATOM    502  C   ARG   100      34.921 -14.695  12.550  1.00 71.83      A    C  
ATOM    503  O   ARG   100      34.724 -15.474  13.472  1.00 75.13      A    O  
ATOM    504  N   ALA   101      35.185 -15.103  11.312  1.00 71.01      A    N  
ATOM    505  CA  ALA   101      35.329 -16.525  10.994  1.00 72.17      A    C  
ATOM    506  CB  ALA   101      35.429 -16.722   9.503  1.00 68.85      A    C  
ATOM    507  C   ALA   101      36.552 -17.119  11.710  1.00 75.15      A    C  
ATOM    508  O   ALA   101      37.615 -16.494  11.754  1.00 76.06      A    O  
ATOM    509  N   ARG   102      36.393 -18.307  12.292  1.00 77.04      A    N  
ATOM    510  CA  ARG   102      37.495 -18.945  13.018  1.00 80.24      A    C  
ATOM    511  CB  ARG   102      37.422 -18.649  14.532  1.00 84.15      A    C  
ATOM    512  CG  ARG   102      36.203 -19.204  15.271  1.00 87.78      A    C  
ATOM    513  CD  ARG   102      36.375 -19.083  16.790  1.00 94.35      A    C  
ATOM    514  NE  ARG   102      35.293 -19.729  17.539  1.00100.75      A    N  
ATOM    515  CZ  ARG   102      35.301 -21.003  17.926  1.00102.53      A    C  
ATOM    518  C   ARG   102      37.656 -20.449  12.745  1.00 80.42      A    C  
ATOM    519  O   ARG   102      38.732 -21.007  12.968  1.00 82.56      A    O  
ATOM    520  N   THR   103      36.603 -21.092  12.243  1.00 78.34      A    N  
ATOM    521  CA  THR   103      36.599 -22.546  12.083  1.00 78.04      A    C  
ATOM    522  CB  THR   103      35.419 -23.186  12.852  1.00 80.45      A    C  
ATOM    523  OG1 THR   103      35.405 -22.698  14.199  1.00 83.17      A    O  
ATOM    524  CG2 THR   103      35.535 -24.702  12.867  1.00 81.05      A    C  
ATOM    525  C   THR   103      36.580 -22.993  10.620  1.00 74.75      A    C  
ATOM    526  O   THR   103      35.704 -22.597   9.843  1.00 72.85      A    O  
ATOM    527  N   ILE   104      37.563 -23.816  10.260  1.00 74.51      A    N  
ATOM    528  CA  ILE   104      37.632 -24.436   8.939  1.00 71.52      A    C  
ATOM    529  CB  ILE   104      39.104 -24.721   8.524  1.00 72.44      A    C  
ATOM    530  CG1 ILE   104      39.888 -23.415   8.327  1.00 72.05      A    C  
ATOM    531  CD1 ILE   104      39.530 -22.634   7.057  1.00 70.80      A    C  
ATOM    532  CG2 ILE   104      39.176 -25.610   7.273  1.00 71.84      A    C  
ATOM    533  C   ILE   104      36.840 -25.745   8.930  1.00 72.09      A    C  
ATOM    534  O   ILE   104      37.025 -26.603   9.804  1.00 75.02      A    O  
ATOM    535  N   ILE   105      35.952 -25.885   7.951  1.00 69.18      A    N  
ATOM    536  CA  ILE   105      35.303 -27.162   7.691  1.00 69.78      A    C  
ATOM    537  CB  ILE   105      33.883 -26.988   7.109  1.00 68.99      A    C  
ATOM    538  CG1 ILE   105      33.034 -26.087   8.021  1.00 70.06      A    C  
ATOM    539  CD1 ILE   105      31.766 -25.553   7.376  1.00 68.53      A    C  
ATOM    540  CG2 ILE   105      33.218 -28.359   6.902  1.00 69.89      A    C  
ATOM    541  C   ILE   105      36.177 -27.947   6.721  1.00 69.20      A    C  
ATOM    542  O   ILE   105      36.321 -27.559   5.557  1.00 67.81      A    O  
ATOM    543  N   LYS   106      36.768 -29.036   7.213  1.00 71.18      A    N  
ATOM    544  CA  LYS   106      37.645 -29.901   6.409  1.00 71.31      A    C  
ATOM    545  CB  LYS   106      38.240 -31.027   7.268  1.00 74.66      A    C  
ATOM    546  CG  LYS   106      39.235 -30.553   8.327  1.00 78.99      A    C  
ATOM    547  CD  LYS   106      39.729 -31.711   9.190  1.00 83.40      A    C  
ATOM    550  C   LYS   106      36.906 -30.487   5.204  1.00 68.56      A    C  
ATOM    551  O   LYS   106      35.686 -30.651   5.238  1.00 67.81      A    O  
ATOM    552  N   TRP   107      37.645 -30.803   4.143  1.00 67.47      A    N  
ATOM    553  CA  TRP   107      37.031 -31.309   2.911  1.00 66.13      A    C  
ATOM    554  CB  TRP   107      38.099 -31.666   1.875  1.00 65.53      A    C  
ATOM    555  CG  TRP   107      37.617 -32.592   0.793  1.00 64.63      A    C  
ATOM    556  CD1 TRP   107      37.749 -33.948   0.764  1.00 64.45      A    C  
ATOM    557  NE1 TRP   107      37.178 -34.455  -0.377  1.00 65.36      A    N  
ATOM    558  CE2 TRP   107      36.661 -33.425  -1.117  1.00 63.71      A    C  
ATOM    559  CD2 TRP   107      36.913 -32.231  -0.408  1.00 63.14      A    C  
ATOM    560  CE3 TRP   107      36.481 -31.017  -0.957  1.00 60.76      A    C  
ATOM    561  CZ3 TRP   107      35.822 -31.035  -2.188  1.00 63.26      A    C  
ATOM    562  CH2 TRP   107      35.583 -32.242  -2.864  1.00 62.56      A    C  
ATOM    563  CZ2 TRP   107      35.996 -33.441  -2.350  1.00 63.71      A    C  
ATOM    564  C   TRP   107      36.088 -32.487   3.158  1.00 68.02      A    C  
ATOM    565  O   TRP   107      35.038 -32.587   2.516  1.00 67.19      A    O  
ATOM    566  N   GLN   108      36.462 -33.367   4.090  1.00 81.54      A    N  
ATOM    567  CA  GLN   108      35.651 -34.544   4.428  1.00 86.61      A    C  
ATOM    568  CB  GLN   108      36.355 -35.444   5.453  1.00 94.14      A    C  
ATOM    569  CG  GLN   108      37.838 -35.684   5.202  1.00100.96      A    C  
ATOM    570  CD  GLN   108      38.722 -34.745   6.006  1.00102.76      A    C  
ATOM    571  OE1 GLN   108      39.223 -33.746   5.486  1.00 97.70      A    O  
ATOM    572  NE2 GLN   108      38.908 -35.060   7.288  1.00109.40      A    N  
ATOM    573  C   GLN   108      34.288 -34.148   4.977  1.00 84.65      A    C  
ATOM    574  O   GLN   108      33.279 -34.788   4.683  1.00 85.99      A    O  
ATOM    575  N   ASP   109      34.272 -33.087   5.776  1.00 83.07      A    N  
ATOM    576  CA  ASP   109      33.076 -32.667   6.485  1.00 82.93      A    C  
ATOM    577  CB  ASP   109      33.458 -32.054   7.837  1.00 85.14      A    C  
ATOM    578  CG  ASP   109      33.997 -33.091   8.823  1.00 92.55      A    C  
ATOM    579  OD1 ASP   109      33.546 -34.258   8.794  1.00 96.19      A    O  
ATOM    580  OD2 ASP   109      34.871 -32.738   9.637  1.00 95.06      A    O  
ATOM    581  C   ASP   109      32.200 -31.720   5.661  1.00 77.96      A    C  
ATOM    582  O   ASP   109      31.094 -31.376   6.079  1.00 78.84      A    O  
ATOM    583  N   LEU   110      32.685 -31.320   4.488  1.00 74.26      A    N  
ATOM    584  CA  LEU   110      31.899 -30.489   3.577  1.00 70.92      A    C  
ATOM    585  CB  LEU   110      32.768 -29.936   2.443  1.00 67.27      A    C  
ATOM    586  CG  LEU   110      33.781 -28.845   2.798  1.00 65.09      A    C  
ATOM    587  CD1 LEU   110      34.700 -28.569   1.631  1.00 63.20      A    C  
ATOM    588  CD2 LEU   110      33.085 -27.570   3.234  1.00 62.99      A    C  
ATOM    589  C   LEU   110      30.732 -31.285   3.010  1.00 73.58      A    C  
ATOM    590  O   LEU   110      30.908 -32.409   2.549  1.00 76.26      A    O  
ATOM    591  N   GLU   111      29.540 -30.700   3.062  1.00 74.24      A    N  
ATOM    592  CA  GLU   111      28.329 -31.373   2.607  1.00 78.02      A    C  
ATOM    593  CB  GLU   111      27.497 -31.848   3.800  1.00 82.71      A    C  
ATOM    594  CG  GLU   111      28.116 -33.011   4.560  1.00 90.53      A    C  
ATOM    595  CD  GLU   111      27.602 -33.126   5.988  1.00 98.41      A    C  
ATOM    596  OE1 GLU   111      26.455 -33.590   6.180  1.00102.57      A    O  
ATOM    597  OE2 GLU   111      28.355 -32.761   6.920  1.00100.99      A    O  
ATOM    598  C   GLU   111      27.490 -30.469   1.715  1.00 76.64      A    C  
ATOM    599  O   GLU   111      27.457 -29.251   1.901  1.00 75.67      A    O  
ATOM    600  N   VAL   112      26.813 -31.083   0.749  1.00 78.34      A    N  
ATOM    601  CA  VAL   112      25.915 -30.384  -0.168  1.00 77.86      A    C  
ATOM    602  CB  VAL   112      25.330 -31.365  -1.218  1.00 81.46      A    C  
ATOM    603  CG1 VAL   112      24.284 -30.689  -2.078  1.00 82.23      A    C  
ATOM    604  CG2 VAL   112      26.442 -31.937  -2.088  1.00 78.08      A    C  
ATOM    605  C   VAL   112      24.794 -29.655   0.586  1.00 80.43      A    C  
ATOM    606  O   VAL   112      24.029 -30.264   1.345  1.00 83.79      A    O  
ATOM    607  N   GLY   113      24.722 -28.342   0.386  1.00 79.05      A    N  
ATOM    608  CA  GLY   113      23.639 -27.542   0.943  1.00 82.32      A    C  
ATOM    609  C   GLY   113      24.029 -26.621   2.082  1.00 81.33      A    C  
ATOM    610  O   GLY   113      23.254 -25.742   2.463  1.00 84.67      A    O  
ATOM    611  N   GLN   114      25.226 -26.827   2.628  1.00 77.51      A    N  
ATOM    612  CA  GLN   114      25.771 -25.961   3.668  1.00 76.18      A    C  
ATOM    613  CB  GLN   114      27.088 -26.527   4.198  1.00 74.01      A    C  
ATOM    614  CG  GLN   114      26.983 -27.842   4.950  1.00 78.35      A    C  
ATOM    615  CD  GLN   114      28.343 -28.391   5.344  1.00 76.40      A    C  
ATOM    616  OE1 GLN   114      29.316 -28.243   4.614  1.00 73.16      A    O  
ATOM    617  NE2 GLN   114      28.412 -29.031   6.502  1.00 82.18      A    N  
ATOM    618  C   GLN   114      26.038 -24.559   3.130  1.00 73.65      A    C  
ATOM    619  O   GLN   114      26.486 -24.404   1.987  1.00 70.71      A    O  
ATOM    620  N   VAL   115      25.760 -23.544   3.949  1.00 75.05      A    N  
ATOM    621  CA  VAL   115      26.222 -22.194   3.640  1.00 72.83      A    C  
ATOM    622  CB  VAL   115      25.147 -21.100   3.813  1.00 76.99      A    C  
ATOM    623  CG1 VAL   115      23.943 -21.419   2.939  1.00 81.10      A    C  
ATOM    624  CG2 VAL   115      24.744 -20.935   5.272  1.00 83.11      A    C  
ATOM    625  C   VAL   115      27.496 -21.896   4.416  1.00 70.02      A    C  
ATOM    626  O   VAL   115      27.543 -21.972   5.652  1.00 71.87      A    O  
ATOM    627  N   VAL   116      28.535 -21.575   3.657  1.00 65.64      A    N  
ATOM    628  CA  VAL   116      29.880 -21.463   4.175  1.00 63.59      A    C  
ATOM    629  CB  VAL   116      30.730 -22.663   3.704  1.00 62.16      A    C  
ATOM    630  CG1 VAL   116      30.220 -23.965   4.306  1.00 63.67      A    C  
ATOM    631  CG2 VAL   116      30.729 -22.751   2.189  1.00 60.61      A    C  
ATOM    632  C   VAL   116      30.519 -20.168   3.671  1.00 62.26      A    C  
ATOM    633  O   VAL   116      29.996 -19.539   2.752  1.00 61.77      A    O  
ATOM    634  N   MET   117      31.639 -19.770   4.276  1.00 61.42      A    N  
ATOM    635  CA  MET   117      32.456 -18.698   3.712  1.00 60.96      A    C  
ATOM    636  CB  MET   117      32.820 -17.642   4.757  1.00 61.90      A    C  
ATOM    637  CG  MET   117      33.221 -16.318   4.116  1.00 62.48      A    C  
ATOM    638  SD  MET   117      33.916 -15.018   5.390  1.00 66.12      A   SE  
ATOM    639  CE  MET   117      35.602 -15.886   5.817  1.00 66.17      A    C  
ATOM    640  C   MET   117      33.716 -19.269   3.064  1.00 58.29      A    C  
ATOM    641  O   MET   117      34.464 -20.014   3.688  1.00 59.06      A    O  
ATOM    642  N   LEU   118      33.946 -18.901   1.812  1.00 57.12      A    N  
ATOM    643  CA  LEU   118      35.039 -19.463   1.034  1.00 56.29      A    C  
ATOM    644  CB  LEU   118      34.557 -20.698   0.265  1.00 56.76      A    C  
ATOM    645  CG  LEU   118      33.252 -20.615  -0.531  1.00 57.64      A    C  
ATOM    646  CD1 LEU   118      33.420 -19.891  -1.874  1.00 59.59      A    C  
ATOM    647  CD2 LEU   118      32.730 -22.021  -0.747  1.00 60.22      A    C  
ATOM    648  C   LEU   118      35.646 -18.452   0.064  1.00 56.96      A    C  
ATOM    649  O   LEU   118      35.047 -17.412  -0.233  1.00 57.12      A    O  
ATOM    650  N   ASN   119      36.832 -18.789  -0.438  1.00 56.86      A    N  
ATOM    651  CA  ASN   119      37.591 -17.907  -1.306  1.00 57.26      A    C  
ATOM    652  CB  ASN   119      39.094 -18.065  -1.047  1.00 58.13      A    C  
ATOM    653  CG  ASN   119      39.881 -16.825  -1.412  1.00 59.37      A    C  
ATOM    654  OD1 ASN   119      40.059 -16.510  -2.592  1.00 52.64      A    O  
ATOM    655  ND2 ASN   119      40.346 -16.097  -0.389  1.00 56.44      A    N  
ATOM    656  C   ASN   119      37.264 -18.177  -2.756  1.00 58.04      A    C  
ATOM    657  O   ASN   119      37.354 -19.312  -3.229  1.00 59.26      A    O  
ATOM    658  N   TYR   120      36.866 -17.127  -3.459  1.00 58.92      A    N  
ATOM    659  CA  TYR   120      36.514 -17.235  -4.856  1.00 58.75      A    C  
ATOM    660  CB  TYR   120      35.028 -17.595  -4.993  1.00 60.08      A    C  
ATOM    661  CG  TYR   120      34.561 -17.864  -6.416  1.00 63.34      A    C  
ATOM    662  CD1 TYR   120      35.007 -18.984  -7.126  1.00 65.99      A    C  
ATOM    663  CE1 TYR   120      34.575 -19.233  -8.437  1.00 67.83      A    C  
ATOM    664  CZ  TYR   120      33.681 -18.356  -9.046  1.00 74.16      A    C  
ATOM    665  OH  TYR   120      33.240 -18.592 -10.343  1.00 80.05      A    O  
ATOM    666  CE2 TYR   120      33.219 -17.243  -8.356  1.00 72.18      A    C  
ATOM    667  CD2 TYR   120      33.662 -17.003  -7.047  1.00 68.44      A    C  
ATOM    668  C   TYR   120      36.837 -15.934  -5.568  1.00 61.83      A    C  
ATOM    669  O   TYR   120      36.938 -14.887  -4.938  1.00 58.65      A    O  
ATOM    670  N   ASN   121      36.987 -16.005  -6.894  1.00 66.19      A    N  
ATOM    671  CA  ASN   121      37.288 -14.834  -7.695  1.00 69.65      A    C  
ATOM    672  CB  ASN   121      38.759 -14.832  -8.091  1.00 71.49      A    C  
ATOM    673  CG  ASN   121      39.213 -13.497  -8.646  1.00 78.45      A    C  
ATOM    674  OD1 ASN   121      38.577 -12.918  -9.538  1.00 85.52      A    O  
ATOM    675  ND2 ASN   121      40.341 -13.013  -8.144  1.00 77.55      A    N  
ATOM    676  C   ASN   121      36.384 -14.766  -8.924  1.00 77.49      A    C  
ATOM    677  O   ASN   121      36.703 -15.335  -9.972  1.00 78.65      A    O  
ATOM    678  N   PRO   122      35.246 -14.063  -8.791  1.00 80.08      A    N  
ATOM    679  CA  PRO   122      34.210 -13.957  -9.812  1.00 86.20      A    C  
ATOM    680  CB  PRO   122      33.292 -12.865  -9.259  1.00 86.42      A    C  
ATOM    681  CG  PRO   122      33.448 -12.974  -7.791  1.00 82.10      A    C  
ATOM    682  CD  PRO   122      34.890 -13.316  -7.567  1.00 76.62      A    C  
ATOM    683  C   PRO   122      34.740 -13.582 -11.205  1.00 95.34      A    C  
ATOM    684  O   PRO   122      34.304 -14.165 -12.200  1.00 98.08      A    O  
ATOM    685  N   ASP   123      35.680 -12.637 -11.255  1.00 98.70      A    N  
ATOM    686  CA  ASP   123      36.210 -12.096 -12.512  1.00107.79      A    C  
ATOM    687  CB  ASP   123      36.952 -10.783 -12.250  1.00110.01      A    C  
ATOM    688  CG  ASP   123      36.012  -9.599 -12.080  1.00113.62      A    C  
ATOM    689  OD1 ASP   123      35.072  -9.457 -12.894  1.00118.87      A    O  
ATOM    690  OD2 ASP   123      36.223  -8.800 -11.140  1.00109.85      A    O  
ATOM    691  C   ASP   123      37.124 -13.073 -13.247  1.00110.22      A    C  
ATOM    692  O   ASP   123      37.163 -13.092 -14.484  1.00119.05      A    O  
ATOM    693  N   ASN   124      37.868 -13.860 -12.472  1.00104.22      A    N  
ATOM    694  CA  ASN   124      38.691 -14.958 -12.984  1.00106.51      A    C  
ATOM    695  CB  ASN   124      40.090 -14.477 -13.400  1.00111.43      A    C  
ATOM    696  CG  ASN   124      40.625 -13.375 -12.508  1.00109.34      A    C  
ATOM    697  OD1 ASN   124      40.850 -12.255 -12.961  1.00114.42      A    O  
ATOM    698  ND2 ASN   124      40.823 -13.685 -11.229  1.00102.69      A    N  
ATOM    699  C   ASN   124      38.754 -16.096 -11.960  1.00 99.63      A    C  
ATOM    700  O   ASN   124      39.585 -16.073 -11.036  1.00 94.87      A    O  
ATOM    701  N   PRO   125      37.834 -17.072 -12.096  1.00 98.76      A    N  
ATOM    702  CA  PRO   125      37.609 -18.161 -11.135  1.00 93.07      A    C  
ATOM    703  CB  PRO   125      36.475 -18.965 -11.787  1.00 95.03      A    C  
ATOM    704  CG  PRO   125      35.763 -17.960 -12.623  1.00100.37      A    C  
ATOM    705  CD  PRO   125      36.874 -17.146 -13.209  1.00104.85      A    C  
ATOM    706  C   PRO   125      38.812 -19.059 -10.845  1.00 92.16      A    C  
ATOM    707  O   PRO   125      38.794 -19.805  -9.862  1.00 88.10      A    O  
ATOM    708  N   LYS   126      39.842 -18.980 -11.681  1.00 97.48      A    N  
ATOM    709  CA  LYS   126      41.031 -19.804 -11.512  1.00 97.83      A    C  
ATOM    710  CB  LYS   126      41.771 -19.925 -12.846  1.00106.86      A    C  
ATOM    711  CG  LYS   126      42.246 -21.332 -13.163  1.00110.33      A    C  
ATOM    712  CD  LYS   126      42.605 -21.471 -14.634  1.00120.99      A    C  
ATOM    715  C   LYS   126      41.958 -19.245 -10.424  1.00 93.86      A    C  
ATOM    716  O   LYS   126      42.812 -19.961  -9.895  1.00 93.82      A    O  
ATOM    717  N   GLU   127      41.772 -17.973 -10.080  1.00 90.96      A    N  
ATOM    718  CA  GLU   127      42.707 -17.271  -9.204  1.00 89.03      A    C  
ATOM    719  CB  GLU   127      43.092 -15.909  -9.803  1.00 93.54      A    C  
ATOM    720  CG  GLU   127      43.371 -15.901 -11.315  1.00103.30      A    C  
ATOM    721  CD  GLU   127      44.637 -16.650 -11.711  1.00110.07      A    C  
ATOM    722  OE1 GLU   127      45.603 -16.662 -10.911  1.00107.71      A    O  
ATOM    723  OE2 GLU   127      44.666 -17.215 -12.835  1.00117.64      A    O  
ATOM    724  C   GLU   127      42.157 -17.070  -7.795  1.00 81.22      A    C  
ATOM    725  O   GLU   127      40.973 -17.283  -7.540  1.00 77.05      A    O  
ATOM    726  N   ARG   128      43.042 -16.663  -6.890  1.00 79.99      A    N  
ATOM    727  CA  ARG   128      42.665 -16.219  -5.550  1.00 75.18      A    C  
ATOM    728  CB  ARG   128      43.931 -15.974  -4.728  1.00 76.60      A    C  
ATOM    729  CG  ARG   128      43.724 -15.886  -3.242  1.00 73.49      A    C  
ATOM    730  CD  ARG   128      44.193 -17.147  -2.542  1.00 75.64      A    C  
ATOM    731  NE  ARG   128      43.646 -17.232  -1.188  1.00 72.47      A    N  
ATOM    732  CZ  ARG   128      43.729 -18.300  -0.402  1.00 70.66      A    C  
ATOM    733  NH1 ARG   128      44.344 -19.402  -0.816  1.00 72.28      A    N  
ATOM    734  NH2 ARG   128      43.187 -18.265   0.806  1.00 68.19      A    N  
ATOM    735  C   ARG   128      41.853 -14.923  -5.645  1.00 73.74      A    C  
ATOM    736  O   ARG   128      42.171 -14.051  -6.458  1.00 78.40      A    O  
ATOM    737  N   GLY   129      40.801 -14.816  -4.832  1.00 68.65      A    N  
ATOM    738  CA  GLY   129      39.968 -13.607  -4.753  1.00 67.08      A    C  
ATOM    739  C   GLY   129      39.572 -13.235  -3.324  1.00 63.44      A    C  
ATOM    740  O   GLY   129      40.431 -13.034  -2.461  1.00 62.31      A    O  
ATOM    741  N   PHE   130      38.265 -13.163  -3.078  1.00 61.38      A    N  
ATOM    742  CA  PHE   130      37.728 -12.673  -1.812  1.00 59.66      A    C  
ATOM    743  CB  PHE   130      36.996 -11.352  -2.025  1.00 63.17      A    C  
ATOM    744  CG  PHE   130      37.902 -10.225  -2.408  1.00 68.02      A    C  
ATOM    745  CD1 PHE   130      38.714  -9.614  -1.451  1.00 66.81      A    C  
ATOM    746  CE1 PHE   130      39.567  -8.575  -1.803  1.00 70.40      A    C  
ATOM    747  CZ  PHE   130      39.615  -8.142  -3.122  1.00 73.35      A    C  
ATOM    748  CE2 PHE   130      38.814  -8.750  -4.085  1.00 74.05      A    C  
ATOM    749  CD2 PHE   130      37.966  -9.788  -3.726  1.00 69.66      A    C  
ATOM    750  C   PHE   130      36.801 -13.666  -1.143  1.00 57.34      A    C  
ATOM    751  O   PHE   130      36.334 -14.608  -1.796  1.00 55.77      A    O  
ATOM    752  N   TRP   131      36.561 -13.442   0.159  1.00 49.70      A    N  
ATOM    753  CA  TRP   131      35.706 -14.272   0.989  1.00 51.23      A    C  
ATOM    754  CB  TRP   131      36.162 -14.149   2.445  1.00 50.95      A    C  
ATOM    755  CG  TRP   131      37.572 -14.545   2.508  1.00 47.90      A    C  
ATOM    756  CD1 TRP   131      38.665 -13.738   2.335  1.00 46.38      A    C  
ATOM    757  NE1 TRP   131      39.818 -14.490   2.399  1.00 43.72      A    N  
ATOM    758  CE2 TRP   131      39.480 -15.811   2.579  1.00 43.47      A    C  
ATOM    759  CD2 TRP   131      38.070 -15.884   2.632  1.00 47.54      A    C  
ATOM    760  CE3 TRP   131      37.460 -17.139   2.809  1.00 50.34      A    C  
ATOM    761  CZ3 TRP   131      38.272 -18.267   2.948  1.00 49.31      A    C  
ATOM    762  CH2 TRP   131      39.676 -18.159   2.898  1.00 47.35      A    C  
ATOM    763  CZ2 TRP   131      40.296 -16.946   2.703  1.00 45.25      A    C  
ATOM    764  C   TRP   131      34.214 -13.976   0.855  1.00 56.74      A    C  
ATOM    765  O   TRP   131      33.694 -13.045   1.493  1.00 58.95      A    O  
ATOM    766  N   TYR   132      33.546 -14.787   0.027  1.00 57.70      A    N  
ATOM    767  CA  TYR   132      32.093 -14.756  -0.155  1.00 62.06      A    C  
ATOM    768  CB  TYR   132      31.738 -14.902  -1.640  1.00 64.36      A    C  
ATOM    769  CG  TYR   132      32.346 -13.845  -2.512  1.00 66.16      A    C  
ATOM    770  CD1 TYR   132      31.693 -12.636  -2.724  1.00 69.59      A    C  
ATOM    771  CE1 TYR   132      32.252 -11.656  -3.516  1.00 70.75      A    C  
ATOM    772  CZ  TYR   132      33.480 -11.880  -4.109  1.00 68.34      A    C  
ATOM    773  OH  TYR   132      34.038 -10.905  -4.903  1.00 72.83      A    O  
ATOM    774  CE2 TYR   132      34.149 -13.073  -3.917  1.00 64.55      A    C  
ATOM    775  CD2 TYR   132      33.579 -14.048  -3.122  1.00 64.03      A    C  
ATOM    776  C   TYR   132      31.413 -15.900   0.577  1.00 61.98      A    C  
ATOM    777  O   TYR   132      32.010 -16.959   0.773  1.00 60.18      A    O  
ATOM    778  N   ASP   133      30.155 -15.686   0.959  1.00 64.85      A    N  
ATOM    779  CA  ASP   133      29.273 -16.783   1.352  1.00 65.55      A    C  
ATOM    780  CB  ASP   133      28.057 -16.258   2.099  1.00 68.42      A    C  
ATOM    781  CG  ASP   133      28.402 -15.750   3.477  1.00 69.42      A    C  
ATOM    782  OD1 ASP   133      29.599 -15.713   3.823  1.00 64.53      A    O  
ATOM    783  OD2 ASP   133      27.468 -15.378   4.215  1.00 76.31      A    O  
ATOM    784  C   ASP   133      28.823 -17.591   0.136  1.00 66.63      A    C  
ATOM    785  O   ASP   133      28.615 -17.038  -0.950  1.00 67.26      A    O  
ATOM    786  N   ALA   134      28.668 -18.897   0.333  1.00 65.82      A    N  
ATOM    787  CA  ALA   134      28.311 -19.804  -0.745  1.00 67.57      A    C  
ATOM    788  CB  ALA   134      29.558 -20.239  -1.510  1.00 64.02      A    C  
ATOM    789  C   ALA   134      27.558 -21.022  -0.232  1.00 69.20      A    C  
ATOM    790  O   ALA   134      27.790 -21.492   0.884  1.00 68.34      A    O  
ATOM    791  N   GLU   135      26.655 -21.525  -1.066  1.00 72.04      A    N  
ATOM    792  CA  GLU   135      25.925 -22.744  -0.785  1.00 72.93      A    C  
ATOM    793  CB  GLU   135      24.484 -22.591  -1.263  1.00 77.11      A    C  
ATOM    794  CG  GLU   135      23.524 -23.682  -0.821  1.00 78.37      A    C  
ATOM    795  CD  GLU   135      22.088 -23.368  -1.212  1.00 84.76      A    C  
ATOM    796  OE1 GLU   135      21.844 -23.039  -2.399  1.00 85.93      A    O  
ATOM    797  OE2 GLU   135      21.203 -23.447  -0.328  1.00 88.15      A    O  
ATOM    798  C   GLU   135      26.616 -23.878  -1.529  1.00 71.76      A    C  
ATOM    799  O   GLU   135      26.707 -23.854  -2.758  1.00 73.06      A    O  
ATOM    800  N   ILE   136      27.121 -24.862  -0.792  1.00 69.88      A    N  
ATOM    801  CA  ILE   136      27.764 -26.015  -1.425  1.00 68.91      A    C  
ATOM    802  CB  ILE   136      28.472 -26.926  -0.400  1.00 67.43      A    C  
ATOM    803  CG1 ILE   136      29.694 -26.201   0.170  1.00 62.29      A    C  
ATOM    804  CD1 ILE   136      29.976 -26.548   1.601  1.00 63.43      A    C  
ATOM    805  CG2 ILE   136      28.913 -28.244  -1.043  1.00 67.94      A    C  
ATOM    806  C   ILE   136      26.741 -26.759  -2.275  1.00 72.33      A    C  
ATOM    807  O   ILE   136      25.671 -27.145  -1.795  1.00 74.69      A    O  
ATOM    808  N   SER   137      27.080 -26.921  -3.548  1.00 72.39      A    N  
ATOM    809  CA  SER   137      26.134 -27.344  -4.560  1.00 76.27      A    C  
ATOM    810  CB  SER   137      26.209 -26.382  -5.745  1.00 76.90      A    C  
ATOM    811  OG  SER   137      25.221 -26.684  -6.705  1.00 82.68      A    O  
ATOM    812  C   SER   137      26.401 -28.785  -5.001  1.00 77.57      A    C  
ATOM    813  O   SER   137      25.517 -29.638  -4.931  1.00 79.63      A    O  
ATOM    814  N   ARG   138      27.628 -29.038  -5.451  1.00 76.31      A    N  
ATOM    815  CA  ARG   138      28.067 -30.361  -5.869  1.00 77.35      A    C  
ATOM    816  CB  ARG   138      28.178 -30.448  -7.393  1.00 79.55      A    C  
ATOM    817  CG  ARG   138      26.877 -30.215  -8.119  1.00 85.11      A    C  
ATOM    818  CD  ARG   138      26.947 -30.659  -9.564  1.00 89.42      A    C  
ATOM    819  NE  ARG   138      27.580 -29.666 -10.429  1.00 89.97      A    N  
ATOM    820  CZ  ARG   138      28.649 -29.898 -11.183  1.00 89.04      A    C  
ATOM    821  NH1 ARG   138      29.145 -28.930 -11.941  1.00 88.78      A    N  
ATOM    822  NH2 ARG   138      29.218 -31.098 -11.191  1.00 89.11      A    N  
ATOM    823  C   ARG   138      29.419 -30.657  -5.251  1.00 74.79      A    C  
ATOM    824  O   ARG   138      30.264 -29.765  -5.126  1.00 71.88      A    O  
ATOM    825  N   LYS   139      29.613 -31.914  -4.866  1.00 75.98      A    N  
ATOM    826  CA  LYS   139      30.874 -32.372  -4.306  1.00 74.86      A    C  
ATOM    827  CB  LYS   139      30.779 -32.469  -2.782  1.00 73.48      A    C  
ATOM    828  CG  LYS   139      32.087 -32.834  -2.115  1.00 71.58      A    C  
ATOM    829  CD  LYS   139      31.904 -32.996  -0.626  1.00 72.19      A    C  
ATOM    830  CE  LYS   139      33.155 -33.579  -0.006  1.00 72.78      A    C  
ATOM    831  NZ  LYS   139      32.987 -33.821   1.453  1.00 73.28      A    N  
ATOM    832  C   LYS   139      31.272 -33.712  -4.933  1.00 77.81      A    C  
ATOM    833  O   LYS   139      30.529 -34.697  -4.856  1.00 79.78      A    O  
ATOM    834  N   ARG   140      32.446 -33.724  -5.561  1.00 77.81      A    N  
ATOM    835  CA  ARG   140      32.943 -34.878  -6.310  1.00 80.86      A    C  
ATOM    836  CB  ARG   140      32.831 -34.614  -7.815  1.00 83.30      A    C  
ATOM    837  CG  ARG   140      31.731 -35.391  -8.524  1.00 91.05      A    C  
ATOM    838  CD  ARG   140      32.212 -36.778  -8.943  1.00 96.65      A    C  
ATOM    839  NE  ARG   140      33.416 -36.699  -9.771  1.00 98.96      A    N  
ATOM    840  CZ  ARG   140      33.469 -36.995 -11.067  1.00103.38      A    C  
ATOM    841  NH1 ARG   140      32.384 -37.411 -11.709  1.00108.22      A    N  
ATOM    842  NH2 ARG   140      34.617 -36.887 -11.723  1.00103.90      A    N  
ATOM    843  C   ARG   140      34.393 -35.183  -5.967  1.00 79.17      A    C  
ATOM    844  O   ARG   140      35.221 -34.279  -5.877  1.00 76.53      A    O  
ATOM    845  N   GLU   141      34.702 -36.461  -5.784  1.00 80.97      A    N  
ATOM    846  CA  GLU   141      36.079 -36.872  -5.552  1.00 80.09      A    C  
ATOM    847  CB  GLU   141      36.318 -37.213  -4.081  1.00 78.65      A    C  
ATOM    848  CG  GLU   141      37.779 -37.137  -3.680  1.00 78.55      A    C  
ATOM    849  CD  GLU   141      38.015 -37.247  -2.182  1.00 77.93      A    C  
ATOM    850  OE1 GLU   141      37.038 -37.196  -1.405  1.00 78.44      A    O  
ATOM    851  OE2 GLU   141      39.194 -37.383  -1.781  1.00 77.29      A    O  
ATOM    852  C   GLU   141      36.508 -38.020  -6.465  1.00 83.79      A    C  
ATOM    853  O   GLU   141      35.761 -38.959  -6.720  1.00 86.12      A    O  
ATOM    854  N   THR   142      37.732 -37.899  -6.956  1.00 63.92      A    N  
ATOM    855  CA  THR   142      38.372 -38.851  -7.848  1.00 63.74      A    C  
ATOM    856  CB  THR   142      38.654 -38.156  -9.215  1.00 66.30      A    C  
ATOM    857  OG1 THR   142      37.666 -38.567 -10.168  1.00 66.73      A    O  
ATOM    858  CG2 THR   142      40.026 -38.473  -9.776  1.00 71.31      A    C  
ATOM    859  C   THR   142      39.630 -39.330  -7.117  1.00 63.29      A    C  
ATOM    860  O   THR   142      39.944 -38.823  -6.025  1.00 64.51      A    O  
ATOM    861  N   ARG   143      40.326 -40.317  -7.675  1.00 63.14      A    N  
ATOM    862  CA  ARG   143      41.597 -40.770  -7.109  1.00 63.64      A    C  
ATOM    863  CB  ARG   143      42.221 -41.858  -7.977  1.00 64.32      A    C  
ATOM    864  CG  ARG   143      41.596 -43.245  -7.869  1.00 64.07      A    C  
ATOM    865  CD  ARG   143      42.347 -44.211  -8.831  1.00 64.06      A    C  
ATOM    866  NE  ARG   143      41.787 -45.568  -8.930  1.00 62.34      A    N  
ATOM    867  CZ  ARG   143      41.671 -46.437  -7.915  1.00 62.98      A    C  
ATOM    868  NH1 ARG   143      42.045 -46.114  -6.669  1.00 52.94      A    N  
ATOM    869  NH2 ARG   143      41.163 -47.643  -8.148  1.00 61.64      A    N  
ATOM    870  C   ARG   143      42.601 -39.619  -6.916  1.00 65.93      A    C  
ATOM    871  O   ARG   143      43.346 -39.596  -5.929  1.00 67.55      A    O  
ATOM    872  N   THR   144      42.601 -38.666  -7.848  1.00 67.27      A    N  
ATOM    873  CA  THR   144      43.565 -37.562  -7.855  1.00 71.21      A    C  
ATOM    874  CB  THR   144      44.425 -37.591  -9.130  1.00 74.46      A    C  
ATOM    875  OG1 THR   144      43.566 -37.704 -10.270  1.00 74.50      A    O  
ATOM    876  CG2 THR   144      45.397 -38.767  -9.108  1.00 73.69      A    C  
ATOM    877  C   THR   144      42.938 -36.165  -7.756  1.00 73.03      A    C  
ATOM    878  O   THR   144      43.651 -35.186  -7.568  1.00 77.46      A    O  
ATOM    879  N   ALA   145      41.617 -36.073  -7.882  1.00 71.51      A    N  
ATOM    880  CA  ALA   145      40.935 -34.776  -7.947  1.00 73.21      A    C  
ATOM    881  CB  ALA   145      40.374 -34.544  -9.350  1.00 74.63      A    C  
ATOM    882  C   ALA   145      39.825 -34.619  -6.906  1.00 70.73      A    C  
ATOM    883  O   ALA   145      39.049 -35.544  -6.667  1.00 68.81      A    O  
ATOM    884  N   ARG   146      39.765 -33.441  -6.291  1.00 72.52      A    N  
ATOM    885  CA  ARG   146      38.660 -33.067  -5.401  1.00 71.12      A    C  
ATOM    886  CB  ARG   146      39.164 -32.716  -4.001  1.00 70.21      A    C  
ATOM    887  CG  ARG   146      39.659 -33.912  -3.215  1.00 70.44      A    C  
ATOM    888  CD  ARG   146      40.246 -33.502  -1.882  1.00 72.19      A    C  
ATOM    889  NE  ARG   146      41.331 -32.537  -2.043  1.00 76.34      A    N  
ATOM    890  CZ  ARG   146      41.717 -31.677  -1.105  1.00 79.37      A    C  
ATOM    891  NH1 ARG   146      41.109 -31.647   0.073  1.00 79.76      A    N  
ATOM    892  NH2 ARG   146      42.708 -30.834  -1.349  1.00 84.02      A    N  
ATOM    893  C   ARG   146      37.908 -31.892  -6.008  1.00 72.38      A    C  
ATOM    894  O   ARG   146      38.483 -30.830  -6.257  1.00 76.52      A    O  
ATOM    895  N   GLU   147      36.620 -32.088  -6.255  1.00 70.89      A    N  
ATOM    896  CA  GLU   147      35.828 -31.092  -6.962  1.00 72.27      A    C  
ATOM    897  CB  GLU   147      35.261 -31.688  -8.251  1.00 73.83      A    C  
ATOM    898  CG  GLU   147      36.336 -32.129  -9.238  1.00 78.97      A    C  
ATOM    899  CD  GLU   147      35.844 -33.164 -10.233  1.00 82.68      A    C  
ATOM    900  OE1 GLU   147      34.708 -33.023 -10.738  1.00 85.63      A    O  
ATOM    901  OE2 GLU   147      36.602 -34.121 -10.510  1.00 83.65      A    O  
ATOM    902  C   GLU   147      34.718 -30.537  -6.081  1.00 69.40      A    C  
ATOM    903  O   GLU   147      33.914 -31.289  -5.531  1.00 67.18      A    O  
ATOM    904  N   LEU   148      34.692 -29.215  -5.949  1.00 69.74      A    N  
ATOM    905  CA  LEU   148      33.662 -28.544  -5.175  1.00 67.30      A    C  
ATOM    906  CB  LEU   148      34.243 -27.963  -3.884  1.00 66.54      A    C  
ATOM    907  CG  LEU   148      33.276 -27.429  -2.823  1.00 64.58      A    C  
ATOM    908  CD1 LEU   148      32.415 -28.550  -2.267  1.00 59.27      A    C  
ATOM    909  CD2 LEU   148      34.048 -26.727  -1.710  1.00 63.81      A    C  
ATOM    910  C   LEU   148      32.982 -27.463  -6.002  1.00 70.05      A    C  
ATOM    911  O   LEU   148      33.641 -26.629  -6.631  1.00 72.97      A    O  
ATOM    912  N   TYR   149      31.654 -27.507  -6.004  1.00 69.71      A    N  
ATOM    913  CA  TYR   149      30.842 -26.527  -6.707  1.00 71.79      A    C  
ATOM    914  CB  TYR   149      30.053 -27.187  -7.847  1.00 74.98      A    C  
ATOM    915  CG  TYR   149      30.963 -27.719  -8.929  1.00 78.32      A    C  
ATOM    916  CD1 TYR   149      31.505 -29.004  -8.844  1.00 76.82      A    C  
ATOM    917  CE1 TYR   149      32.363 -29.492  -9.827  1.00 79.06      A    C  
ATOM    918  CZ  TYR   149      32.694 -28.685 -10.903  1.00 84.35      A    C  
ATOM    919  OH  TYR   149      33.544 -29.160 -11.878  1.00 88.75      A    O  
ATOM    920  CE2 TYR   149      32.173 -27.404 -11.008  1.00 86.90      A    C  
ATOM    921  CD2 TYR   149      31.317 -26.926 -10.020  1.00 83.14      A    C  
ATOM    922  C   TYR   149      29.935 -25.839  -5.704  1.00 69.60      A    C  
ATOM    923  O   TYR   149      29.459 -26.466  -4.757  1.00 67.80      A    O  
ATOM    924  N   ALA   150      29.723 -24.543  -5.896  1.00 70.24      A    N  
ATOM    925  CA  ALA   150      28.964 -23.765  -4.941  1.00 68.76      A    C  
ATOM    926  CB  ALA   150      29.885 -23.235  -3.834  1.00 67.20      A    C  
ATOM    927  C   ALA   150      28.202 -22.625  -5.596  1.00 72.22      A    C  
ATOM    928  O   ALA   150      28.631 -22.069  -6.612  1.00 74.74      A    O  
ATOM    929  N   ASN   151      27.055 -22.303  -5.003  1.00 72.44      A    N  
ATOM    930  CA  ASN   151      26.300 -21.119  -5.350  1.00 76.20      A    C  
ATOM    931  CB  ASN   151      24.810 -21.330  -5.072  1.00 76.85      A    C  
ATOM    932  CG  ASN   151      24.247 -22.554  -5.770  1.00 79.45      A    C  
ATOM    933  OD1 ASN   151      24.580 -22.845  -6.918  1.00 79.71      A    O  
ATOM    934  ND2 ASN   151      23.380 -23.276  -5.073  1.00 80.94      A    N  
ATOM    935  C   ASN   151      26.839 -19.979  -4.507  1.00 76.24      A    C  
ATOM    936  O   ASN   151      26.602 -19.927  -3.295  1.00 75.45      A    O  
ATOM    937  N   VAL   152      27.584 -19.081  -5.143  1.00 79.41      A    N  
ATOM    938  CA  VAL   152      28.259 -17.990  -4.444  1.00 79.50      A    C  
ATOM    939  CB  VAL   152      29.614 -17.661  -5.119  1.00 82.99      A    C  
ATOM    940  CG1 VAL   152      30.288 -16.454  -4.472  1.00 83.32      A    C  
ATOM    941  CG2 VAL   152      30.527 -18.868  -5.071  1.00 80.21      A    C  
ATOM    942  C   VAL   152      27.350 -16.759  -4.391  1.00 82.04      A    C  
ATOM    943  O   VAL   152      26.821 -16.325  -5.418  1.00 85.53      A    O  
ATOM    944  N   VAL   153      27.170 -16.213  -3.190  1.00 80.24      A    N  
ATOM    945  CA  VAL   153      26.318 -15.043  -2.970  1.00 81.79      A    C  
ATOM    946  CB  VAL   153      25.723 -15.040  -1.539  1.00 78.70      A    C  
ATOM    947  CG1 VAL   153      24.841 -13.821  -1.319  1.00 78.84      A    C  
ATOM    948  CG2 VAL   153      24.932 -16.323  -1.290  1.00 76.38      A    C  
ATOM    949  C   VAL   153      27.097 -13.751  -3.232  1.00 86.30      A    C  
ATOM    950  O   VAL   153      28.098 -13.467  -2.562  1.00 86.64      A    O  
ATOM    951  N   LEU   154      26.615 -12.970  -4.199  1.00 90.89      A    N  
ATOM    952  CA  LEU   154      27.335 -11.803  -4.699  1.00 96.61      A    C  
ATOM    953  CB  LEU   154      27.674 -12.010  -6.177  1.00102.18      A    C  
ATOM    954  CG  LEU   154      29.126 -11.829  -6.622  1.00107.79      A    C  
ATOM    955  CD1 LEU   154      29.946 -13.084  -6.325  1.00104.39      A    C  
ATOM    956  CD2 LEU   154      29.195 -11.476  -8.100  1.00115.33      A    C  
ATOM    957  C   LEU   154      26.523 -10.521  -4.528  1.00 98.73      A    C  
ATOM    958  O   LEU   154      26.057 -10.203  -3.430  1.00 95.85      A    O  
ATOM    959  N   ASP   156      20.327  -9.075  -2.880  1.00154.49      A    N  
ATOM    960  CA  ASP   156      21.569  -9.607  -3.441  1.00145.75      A    C  
ATOM    961  CB  ASP   156      22.488 -10.157  -2.331  1.00135.92      A    C  
ATOM    962  CG  ASP   156      21.872 -11.329  -1.568  1.00134.46      A    C  
ATOM    963  OD1 ASP   156      21.793 -12.447  -2.127  1.00132.68      A    O  
ATOM    964  OD2 ASP   156      21.490 -11.137  -0.394  1.00135.89      A    O  
ATOM    965  C   ASP   156      21.316 -10.670  -4.512  1.00145.37      A    C  
ATOM    966  O   ASP   156      20.268 -11.319  -4.518  1.00150.14      A    O  
ATOM    967  N   ASP   157      22.283 -10.837  -5.413  1.00140.52      A    N  
ATOM    968  CA  ASP   157      22.213 -11.861  -6.458  1.00139.58      A    C  
ATOM    969  CB  ASP   157      22.328 -11.238  -7.860  1.00145.97      A    C  
ATOM    970  CG  ASP   157      23.279 -10.046  -7.904  1.00145.70      A    C  
ATOM    971  OD1 ASP   157      22.852  -8.926  -7.545  1.00151.65      A    O  
ATOM    972  OD2 ASP   157      24.446 -10.224  -8.314  1.00140.51      A    O  
ATOM    973  C   ASP   157      23.284 -12.932  -6.249  1.00128.46      A    C  
ATOM    974  O   ASP   157      24.418 -12.619  -5.887  1.00122.38      A    O  
ATOM    975  N   SER   158      22.914 -14.192  -6.468  1.00126.34      A    N  
ATOM    976  CA  SER   158      23.850 -15.305  -6.310  1.00116.90      A    C  
ATOM    977  CB  SER   158      23.222 -16.443  -5.500  1.00115.95      A    C  
ATOM    978  OG  SER   158      22.159 -17.046  -6.211  1.00124.65      A    O  
ATOM    979  C   SER   158      24.386 -15.823  -7.647  1.00115.72      A    C  
ATOM    980  O   SER   158      23.766 -15.637  -8.693  1.00122.87      A    O  
ATOM    981  N   LEU   159      25.543 -16.475  -7.587  1.00107.30      A    N  
ATOM    982  CA  LEU   159      26.252 -16.962  -8.762  1.00105.78      A    C  
ATOM    983  CB  LEU   159      27.643 -16.324  -8.812  1.00100.96      A    C  
ATOM    984  CG  LEU   159      28.366 -16.132 -10.145  1.00104.00      A    C  
ATOM    985  CD2 LEU   159      27.532 -15.316 -11.129  1.00112.58      A    C  
ATOM    987  C   LEU   159      26.341 -18.490  -8.703  1.00102.25      A    C  
ATOM    988  O   LEU   159      27.136 -19.049  -7.948  1.00 95.25      A    O  
ATOM    989  N   ASN   160      25.514 -19.156  -9.504  1.00107.82      A    N  
ATOM    990  CA  ASN   160      25.321 -20.604  -9.394  1.00107.03      A    C  
ATOM    991  CB  ASN   160      23.945 -21.006  -9.941  1.00115.89      A    C  
ATOM    992  CG  ASN   160      22.789 -20.368  -9.174  1.00119.98      A    C  
ATOM    993  OD1 ASN   160      21.844 -19.859  -9.777  1.00128.07      A    O  
ATOM    994  ND2 ASN   160      22.859 -20.395  -7.844  1.00115.38      A    N  
ATOM    995  C   ASN   160      26.406 -21.460 -10.044  1.00103.95      A    C  
ATOM    996  O   ASN   160      26.986 -21.079 -11.064  1.00105.22      A    O  
ATOM    997  N   ASP   161      26.665 -22.614  -9.424  1.00100.72      A    N  
ATOM    998  CA  ASP   161      27.538 -23.670  -9.958  1.00 99.67      A    C  
ATOM    999  CB  ASP   161      26.903 -24.310 -11.206  1.00108.04      A    C  
ATOM   1000  CG  ASP   161      27.456 -25.693 -11.506  1.00109.23      A    C  
ATOM   1001  OD1 ASP   161      27.756 -26.442 -10.547  1.00105.93      A    O  
ATOM   1002  OD2 ASP   161      27.577 -26.033 -12.705  1.00114.11      A    O  
ATOM   1003  C   ASP   161      28.976 -23.220 -10.238  1.00 94.88      A    C  
ATOM   1004  O   ASP   161      29.499 -23.410 -11.340  1.00 97.52      A    O  
ATOM   1005  N   CYS   162      29.608 -22.634  -9.226  1.00 88.51      A    N  
ATOM   1006  CA  CYS   162      30.981 -22.149  -9.332  1.00 85.07      A    C  
ATOM   1007  CB  CYS   162      31.178 -20.924  -8.431  1.00 81.92      A    C  
ATOM   1008  SG  CYS   162      30.225 -19.464  -8.900  1.00 88.32      A    S  
ATOM   1009  C   CYS   162      31.993 -23.225  -8.942  1.00 81.26      A    C  
ATOM   1010  O   CYS   162      31.833 -23.883  -7.913  1.00 79.50      A    O  
ATOM   1011  N   ARG   163      33.041 -23.388  -9.748  1.00 80.96      A    N  
ATOM   1012  CA  ARG   163      34.135 -24.297  -9.403  1.00 78.45      A    C  
ATOM   1013  CB  ARG   163      34.936 -24.699 -10.649  1.00 82.87      A    C  
ATOM   1014  CG  ARG   163      36.139 -25.619 -10.389  1.00 83.57      A    C  
ATOM   1015  CD  ARG   163      35.735 -26.950  -9.752  1.00 86.25      A    C  
ATOM   1016  NE  ARG   163      36.895 -27.771  -9.402  1.00 86.46      A    N  
ATOM   1017  CZ  ARG   163      37.383 -28.758 -10.151  1.00 91.21      A    C  
ATOM   1018  NH1 ARG   163      36.813 -29.077 -11.312  1.00 95.37      A    N  
ATOM   1019  NH2 ARG   163      38.444 -29.439  -9.732  1.00 90.22      A    N  
ATOM   1020  C   ARG   163      35.044 -23.655  -8.359  1.00 73.09      A    C  
ATOM   1021  O   ARG   163      35.798 -22.727  -8.665  1.00 73.28      A    O  
ATOM   1022  N   ILE   164      34.963 -24.155  -7.129  1.00 68.86      A    N  
ATOM   1023  CA  ILE   164      35.743 -23.620  -6.011  1.00 63.46      A    C  
ATOM   1024  CB  ILE   164      34.998 -23.798  -4.656  1.00 61.55      A    C  
ATOM   1025  CG1 ILE   164      33.573 -23.218  -4.724  1.00 60.30      A    C  
ATOM   1026  CD1 ILE   164      33.499 -21.745  -5.097  1.00 60.78      A    C  
ATOM   1027  CG2 ILE   164      35.823 -23.220  -3.477  1.00 57.88      A    C  
ATOM   1028  C   ILE   164      37.130 -24.257  -5.942  1.00 63.17      A    C  
ATOM   1029  O   ILE   164      37.258 -25.473  -5.803  1.00 63.90      A    O  
ATOM   1030  N   ILE   165      38.160 -23.419  -6.033  1.00 63.23      A    N  
ATOM   1031  CA  ILE   165      39.553 -23.873  -6.071  1.00 64.54      A    C  
ATOM   1032  CB  ILE   165      40.486 -22.816  -6.735  1.00 65.87      A    C  
ATOM   1033  CG1 ILE   165      40.033 -22.474  -8.161  1.00 68.67      A    C  
ATOM   1034  CD1 ILE   165      39.820 -23.676  -9.066  1.00 70.55      A    C  
ATOM   1035  CG2 ILE   165      41.943 -23.279  -6.718  1.00 68.94      A    C  
ATOM   1036  C   ILE   165      40.090 -24.196  -4.681  1.00 63.36      A    C  
ATOM   1037  O   ILE   165      40.739 -25.220  -4.487  1.00 65.13      A    O  
ATOM   1038  N   PHE   166      39.808 -23.316  -3.724  1.00 60.96      A    N  
ATOM   1039  CA  PHE   166      40.423 -23.363  -2.391  1.00 61.51      A    C  
ATOM   1040  CB  PHE   166      40.778 -21.947  -1.921  1.00 59.92      A    C  
ATOM   1041  CG  PHE   166      41.515 -21.179  -2.976  1.00 63.59      A    C  
ATOM   1042  CD1 PHE   166      40.831 -20.338  -3.851  1.00 63.67      A    C  
ATOM   1043  CE1 PHE   166      41.500 -19.672  -4.874  1.00 65.74      A    C  
ATOM   1044  CZ  PHE   166      42.863 -19.866  -5.048  1.00 69.84      A    C  
ATOM   1045  CE2 PHE   166      43.555 -20.726  -4.199  1.00 71.18      A    C  
ATOM   1046  CD2 PHE   166      42.875 -21.391  -3.179  1.00 67.07      A    C  
ATOM   1047  C   PHE   166      39.555 -24.164  -1.448  1.00 60.34      A    C  
ATOM   1048  O   PHE   166      38.857 -23.654  -0.577  1.00 59.81      A    O  
ATOM   1049  N   VAL   167      39.639 -25.461  -1.683  1.00 61.90      A    N  
ATOM   1050  CA  VAL   167      38.760 -26.465  -1.138  1.00 62.51      A    C  
ATOM   1051  CB  VAL   167      38.817 -27.678  -2.085  1.00 66.35      A    C  
ATOM   1052  CG1 VAL   167      38.694 -29.004  -1.355  1.00 71.14      A    C  
ATOM   1053  CG2 VAL   167      37.789 -27.517  -3.209  1.00 67.21      A    C  
ATOM   1054  C   VAL   167      39.147 -26.822   0.296  1.00 62.61      A    C  
ATOM   1055  O   VAL   167      38.380 -27.472   1.015  1.00 61.76      A    O  
ATOM   1056  N   ASP   168      40.332 -26.369   0.706  1.00 63.36      A    N  
ATOM   1057  CA  ASP   168      40.879 -26.668   2.024  1.00 65.08      A    C  
ATOM   1058  CB  ASP   168      42.323 -27.177   1.907  1.00 68.67      A    C  
ATOM   1059  CG  ASP   168      42.404 -28.597   1.360  1.00 73.05      A    C  
ATOM   1060  OD1 ASP   168      41.677 -29.482   1.868  1.00 73.62      A    O  
ATOM   1061  OD2 ASP   168      43.199 -28.833   0.422  1.00 74.94      A    O  
ATOM   1062  C   ASP   168      40.810 -25.459   2.946  1.00 63.54      A    C  
ATOM   1063  O   ASP   168      41.340 -25.489   4.062  1.00 66.02      A    O  
ATOM   1064  N   GLU   169      40.141 -24.405   2.482  1.00 60.46      A    N  
ATOM   1065  CA  GLU   169      40.110 -23.134   3.207  1.00 59.46      A    C  
ATOM   1066  CB  GLU   169      40.988 -22.107   2.487  1.00 60.15      A    C  
ATOM   1067  CG  GLU   169      42.468 -22.435   2.516  1.00 60.33      A    C  
ATOM   1068  CD  GLU   169      43.285 -21.528   1.627  1.00 63.26      A    C  
ATOM   1069  OE1 GLU   169      43.919 -20.597   2.166  1.00 63.21      A    O  
ATOM   1070  OE2 GLU   169      43.296 -21.742   0.389  1.00 63.55      A    O  
ATOM   1071  C   GLU   169      38.691 -22.593   3.412  1.00 57.50      A    C  
ATOM   1072  O   GLU   169      38.475 -21.378   3.494  1.00 56.14      A    O  
ATOM   1073  N   VAL   170      37.735 -23.511   3.511  1.00 57.46      A    N  
ATOM   1074  CA  VAL   170      36.325 -23.175   3.636  1.00 56.44      A    C  
ATOM   1075  CB  VAL   170      35.449 -24.277   2.987  1.00 56.48      A    C  
ATOM   1076  CG1 VAL   170      33.980 -24.001   3.212  1.00 55.51      A    C  
ATOM   1077  CG2 VAL   170      35.751 -24.397   1.489  1.00 54.79      A    C  
ATOM   1078  C   VAL   170      35.952 -22.981   5.112  1.00 59.01      A    C  
ATOM   1079  O   VAL   170      36.236 -23.839   5.957  1.00 61.69      A    O  
ATOM   1080  N   PHE   171      35.312 -21.855   5.412  1.00 58.99      A    N  
ATOM   1081  CA  PHE   171      34.969 -21.499   6.783  1.00 61.65      A    C  
ATOM   1082  CB  PHE   171      35.233 -20.014   7.044  1.00 60.78      A    C  
ATOM   1083  CG  PHE   171      36.670 -19.678   7.281  1.00 60.82      A    C  
ATOM   1084  CD1 PHE   171      37.210 -19.739   8.562  1.00 60.71      A    C  
ATOM   1085  CE1 PHE   171      38.544 -19.413   8.789  1.00 60.33      A    C  
ATOM   1086  CZ  PHE   171      39.352 -19.009   7.736  1.00 61.60      A    C  
ATOM   1087  CE2 PHE   171      38.825 -18.946   6.441  1.00 61.24      A    C  
ATOM   1088  CD2 PHE   171      37.487 -19.275   6.224  1.00 60.28      A    C  
ATOM   1089  C   PHE   171      33.524 -21.794   7.147  1.00 64.12      A    C  
ATOM   1090  O   PHE   171      32.615 -21.693   6.314  1.00 64.50      A    O  
ATOM   1091  N   LYS   172      33.339 -22.152   8.413  1.00 77.04      A    N  
ATOM   1092  CA  LYS   172      32.037 -22.227   9.050  1.00 79.53      A    C  
ATOM   1093  CB  LYS   172      32.164 -23.050  10.337  1.00 88.91      A    C  
ATOM   1094  CG  LYS   172      30.940 -23.105  11.231  1.00 93.59      A    C  
ATOM   1095  CD  LYS   172      31.219 -24.011  12.426  1.00105.42      A    C  
ATOM   1096  CE  LYS   172      30.081 -24.008  13.435  1.00111.71      A    C  
ATOM   1097  NZ  LYS   172      30.086 -22.782  14.282  1.00110.49      A    N  
ATOM   1098  C   LYS   172      31.600 -20.804   9.366  1.00 77.33      A    C  
ATOM   1099  O   LYS   172      32.382 -20.015   9.907  1.00 79.81      A    O  
ATOM   1100  N   ILE   173      30.364 -20.468   9.018  1.00 76.02      A    N  
ATOM   1101  CA  ILE   173      29.820 -19.163   9.362  1.00 76.65      A    C  
ATOM   1102  CB  ILE   173      28.692 -18.719   8.397  1.00 76.78      A    C  
ATOM   1103  CG1 ILE   173      29.263 -18.449   7.002  1.00 70.61      A    C  
ATOM   1104  CD1 ILE   173      28.220 -18.403   5.902  1.00 71.51      A    C  
ATOM   1105  CG2 ILE   173      27.983 -17.471   8.924  1.00 81.49      A    C  
ATOM   1106  C   ILE   173      29.330 -19.219  10.805  1.00 83.32      A    C  
ATOM   1107  O   ILE   173      28.477 -20.038  11.153  1.00 87.13      A    O  
ATOM   1108  N   GLU   174      29.896 -18.353  11.639  1.00 86.51      A    N  
ATOM   1109  CA  GLU   174      29.536 -18.283  13.050  1.00 93.69      A    C  
ATOM   1110  CB  GLU   174      30.549 -17.437  13.835  1.00 97.60      A    C  
ATOM   1111  CG  GLU   174      32.024 -17.729  13.538  1.00 98.58      A    C  
ATOM   1112  CD  GLU   174      32.480 -19.103  14.005  1.00103.15      A    C  
ATOM   1113  OE1 GLU   174      32.267 -19.434  15.190  1.00110.24      A    O  
ATOM   1114  OE2 GLU   174      33.069 -19.847  13.186  1.00102.50      A    O  
ATOM   1115  C   GLU   174      28.128 -17.711  13.215  1.00 97.65      A    C  
ATOM   1116  O   GLU   174      27.849 -16.589  12.779  1.00 98.79      A    O  
ATOM   1117  N   ARG   175      27.250 -18.506  13.826  1.00102.48      A    N  
ATOM   1118  CA  ARG   175      25.891 -18.080  14.174  1.00109.50      A    C  
ATOM   1119  CB  ARG   175      24.881 -19.185  13.842  1.00114.39      A    C  
ATOM   1120  CG  ARG   175      24.124 -18.977  12.535  1.00116.97      A    C  
ATOM   1121  CD  ARG   175      24.920 -19.414  11.313  1.00109.78      A    C  
ATOM   1122  NE  ARG   175      24.355 -18.861  10.080  1.00112.40      A    N  
ATOM   1123  CZ  ARG   175      24.629 -19.298   8.851  1.00109.33      A    C  
ATOM   1124  NH1 ARG   175      25.462 -20.318   8.661  1.00103.11      A    N  
ATOM   1125  NH2 ARG   175      24.058 -18.714   7.803  1.00112.61      A    N  
ATOM   1126  C   ARG   175      25.781 -17.680  15.653  1.00114.90      A    C  
ATOM   1127  O   ARG   175      26.443 -18.279  16.504  1.00115.25      A    O  
ATOM   1128  N   PRO   176      24.947 -16.661  15.961  1.00121.13      A    N  
ATOM   1129  CA  PRO   176      24.769 -16.177  17.338  1.00127.15      A    C  
ATOM   1130  CB  PRO   176      23.739 -15.054  17.186  1.00135.40      A    C  
ATOM   1131  CG  PRO   176      23.825 -14.640  15.761  1.00132.78      A    C  
ATOM   1132  CD  PRO   176      24.125 -15.891  15.009  1.00124.80      A    C  
ATOM   1133  C   PRO   176      24.226 -17.248  18.281  1.00131.43      A    C  
ATOM   1134  O   PRO   176      24.738 -17.408  19.389  1.00133.23      A    O  
END
