
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  107 (  895),  selected  107 , name 1x0j_C
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 1x0j_C.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       1           -
LGA    -       -      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    -       -      E       5           -
LGA    -       -      D       6           -
LGA    T    76_C      T       7          2.926
LGA    -       -      F       8           -
LGA    -       -      R       9           -
LGA    N    77_C      E      10          3.392
LGA    Q    78_C      L      11          3.378
LGA    L    79_C      R      12          3.371
LGA    Q    80_C      I      13          2.626
LGA    Y    81_C      F      14          1.821
LGA    L    82_C      L      15          1.903
LGA    H    83_C      R      16          1.591
LGA    K    84_C      N      17          1.804
LGA    V    85_C      V      18          3.097
LGA    V    86_C      -       -           -
LGA    X    87_C      T      19          0.827
LGA    K    88_C      H      20          2.255
LGA    A    89_C      R      21          1.277
LGA    L    90_C      L      22          0.213
LGA    W    91_C      A      23          0.930
LGA    K    92_C      I      24          0.538
LGA    H    93_C      D      25          0.242
LGA    Q    94_C      K      26          0.361
LGA    F    95_C      R      27          1.251
LGA    A    96_C      F      28          1.690
LGA    W    97_C      R      29          1.122
LGA    P    98_C      V      30          0.884
LGA    F    99_C      F      31          0.919
LGA    R   100_C      T      32          0.962
LGA    Q   101_C      K      33          1.034
LGA    P   102_C      P      34          0.790
LGA    V   103_C      V      35          0.962
LGA    D   104_C      D      36          1.481
LGA    A   105_C      P      37          2.737
LGA    V   106_C      D      38          2.320
LGA    K   107_C      -       -           -
LGA    L   108_C      E      39          1.439
LGA    G   109_C      V      40          3.369
LGA    L   110_C      P      41          3.730
LGA    P   111_C      -       -           -
LGA    D   112_C      D      42          2.651
LGA    Y   113_C      Y      43          1.825
LGA    H   114_C      V      44          2.283
LGA    K   115_C      T      45          2.392
LGA    I   116_C      V      46          1.930
LGA    I   117_C      I      47          1.029
LGA    K   118_C      K      48          0.702
LGA    Q   119_C      Q      49          0.598
LGA    P   120_C      P      50          0.747
LGA    X   121_C      M      51          0.802
LGA    D   122_C      D      52          0.895
LGA    X   123_C      L      53          0.574
LGA    G   124_C      S      54          0.482
LGA    T   125_C      S      55          0.892
LGA    I   126_C      V      56          0.566
LGA    K   127_C      I      57          1.172
LGA    R   128_C      S      58          2.153
LGA    R   129_C      K      59          2.218
LGA    L   130_C      I      60          1.995
LGA    E   131_C      D      61          3.447
LGA    N   132_C      L      62          4.301
LGA    N   133_C      -       -           -
LGA    Y   134_C      H      63          2.071
LGA    Y   135_C      K      64          2.015
LGA    W   136_C      Y      65          4.124
LGA    A   137_C      L      66          1.183
LGA    A   138_C      T      67          2.232
LGA    -       -      V      68           -
LGA    S   139_C      K      69          2.116
LGA    E   140_C      D      70          1.779
LGA    C   141_C      Y      71          1.619
LGA    X   142_C      L      72          1.523
LGA    Q   143_C      R      73          1.098
LGA    D   144_C      D      74          1.191
LGA    F   145_C      I      75          1.253
LGA    N   146_C      D      76          1.152
LGA    T   147_C      L      77          0.924
LGA    X   148_C      I      78          1.245
LGA    F   149_C      C      79          1.119
LGA    T   150_C      S      80          0.712
LGA    N   151_C      N      81          0.416
LGA    C   152_C      A      82          0.491
LGA    Y   153_C      L      83          0.522
LGA    I   154_C      E      84          0.634
LGA    Y   155_C      Y      85          0.755
LGA    N   156_C      N      86          0.766
LGA    K   157_C      P      87          3.044
LGA    P   158_C      D      88          3.727
LGA    T   159_C      R      89          3.805
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    D   160_C      D      93          1.508
LGA    -       -      R      94           -
LGA    D   161_C      L      95          1.276
LGA    I   162_C      I      96          1.155
LGA    V   163_C      R      97          1.167
LGA    L   164_C      H      98          1.226
LGA    X   165_C      R      99          1.016
LGA    A   166_C      A     100          0.881
LGA    Q   167_C      C     101          1.307
LGA    T   168_C      A     102          1.370
LGA    L   169_C      L     103          1.314
LGA    E   170_C      R     104          1.154
LGA    K   171_C      D     105          1.018
LGA    I   172_C      T     106          0.454
LGA    F   173_C      A     107          0.772
LGA    L   174_C      Y     108          0.933
LGA    Q   175_C      A     109          0.507
LGA    K   176_C      I     110          1.242
LGA    V   177_C      I     111          1.975
LGA    A   178_C      K     112          1.364
LGA    S   179_C      E     113          2.536
LGA    -       -      E     114           -
LGA    X   180_C      L     115          1.344
LGA    P   181_C      D     116          1.984
LGA    Q   182_C      E     117          3.438
LGA    -       -      D     118           -
LGA    -       -      F     119           -
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    -       -      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  107  130    5.0    103    1.86    22.33     70.850     5.267

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.707408 * X  +   0.701165 * Y  +  -0.089113 * Z  + -81.132896
  Y_new =   0.267166 * X  +  -0.148535 * Y  +   0.952134 * Z  +  23.409672
  Z_new =   0.654367 * X  +  -0.697355 * Y  +  -0.292403 * Z  +  -2.729448 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.967831    1.173762  [ DEG:  -112.7484     67.2516 ]
  Theta =  -0.713345   -2.428247  [ DEG:   -40.8717   -139.1283 ]
  Phi   =   0.361108   -2.780484  [ DEG:    20.6900   -159.3100 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x0j_C                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x0j_C.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  107  130   5.0  103   1.86   22.33  70.850
REMARK  ---------------------------------------------------------- 
MOLECULE 1x0j_C
HEADER    TRANSCRIPTION                           23-MAR-05   1X0J              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF THE N-TERMINAL BROMODOMAIN OF           
TITLE    2 HUMAN BRD2                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 2;                          
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: N-TERMINAL BROMODOMAIN;                                    
COMPND   5 SYNONYM: BRD2, RING3 PROTEIN, O27.1.1;                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PCR2.1-TOPO VECTOR;                       
SOURCE   8 OTHER_DETAILS: EXPRESSED BY CELL-FREE EXPRESSION METHOD              
KEYWDS    ALPHA-HELICAL DOMAIN, BROMODOMAIN, BINDS TO ACETYLATED                
KEYWDS   2 HISTONES, STRUCTURAL GENOMICS, RIKEN STRUCTURAL                      
KEYWDS   3 GENOMICS/PROTEOMICS INITIATIVE, RSGI, NPPSFA, NATIONAL               
KEYWDS   4 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.NAKAMURA,T.UMEHARA,M.SHIROUZU,B.PADMANABHAN,S.YOKOYAMA,             
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   27-JUN-06 1X0J    0                                                
JRNL        AUTH   Y.NAKAMURA,T.UMEHARA,M.SHIROUZU,B.PADMANABHAN,               
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   STRUCTURAL BASIS FOR ACETYLATED HISTONE H4                   
JRNL        TITL 2 RECOGNITION BY THE HUMAN BRD2 BROMODOMAIN                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1X0J A   73   194  UNP    P25440   BRD2_HUMAN      73    194             
DBREF  1X0J B   73   194  UNP    P25440   BRD2_HUMAN      73    194             
DBREF  1X0J C   73   194  UNP    P25440   BRD2_HUMAN      73    194             
SEQRES   1 A  122  GLY ARG VAL THR ASN GLN LEU GLN TYR LEU HIS LYS VAL          
SEQRES   2 A  122  VAL MSE LYS ALA LEU TRP LYS HIS GLN PHE ALA TRP PRO          
SEQRES   3 A  122  PHE ARG GLN PRO VAL ASP ALA VAL LYS LEU GLY LEU PRO          
SEQRES   4 A  122  ASP TYR HIS LYS ILE ILE LYS GLN PRO MSE ASP MSE GLY          
SEQRES   5 A  122  THR ILE LYS ARG ARG LEU GLU ASN ASN TYR TYR TRP ALA          
SEQRES   6 A  122  ALA SER GLU CYS MSE GLN ASP PHE ASN THR MSE PHE THR          
SEQRES   7 A  122  ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL          
SEQRES   8 A  122  LEU MSE ALA GLN THR LEU GLU LYS ILE PHE LEU GLN LYS          
SEQRES   9 A  122  VAL ALA SER MSE PRO GLN GLU GLU GLN GLU LEU VAL VAL          
SEQRES  10 A  122  THR ILE PRO LYS ASN                                          
SEQRES   1 B  122  GLY ARG VAL THR ASN GLN LEU GLN TYR LEU HIS LYS VAL          
SEQRES   2 B  122  VAL MSE LYS ALA LEU TRP LYS HIS GLN PHE ALA TRP PRO          
SEQRES   3 B  122  PHE ARG GLN PRO VAL ASP ALA VAL LYS LEU GLY LEU PRO          
SEQRES   4 B  122  ASP TYR HIS LYS ILE ILE LYS GLN PRO MSE ASP MSE GLY          
SEQRES   5 B  122  THR ILE LYS ARG ARG LEU GLU ASN ASN TYR TYR TRP ALA          
SEQRES   6 B  122  ALA SER GLU CYS MSE GLN ASP PHE ASN THR MSE PHE THR          
SEQRES   7 B  122  ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL          
SEQRES   8 B  122  LEU MSE ALA GLN THR LEU GLU LYS ILE PHE LEU GLN LYS          
SEQRES   9 B  122  VAL ALA SER MSE PRO GLN GLU GLU GLN GLU LEU VAL VAL          
SEQRES  10 B  122  THR ILE PRO LYS ASN                                          
SEQRES   1 C  122  GLY ARG VAL THR ASN GLN LEU GLN TYR LEU HIS LYS VAL          
SEQRES   2 C  122  VAL MSE LYS ALA LEU TRP LYS HIS GLN PHE ALA TRP PRO          
SEQRES   3 C  122  PHE ARG GLN PRO VAL ASP ALA VAL LYS LEU GLY LEU PRO          
SEQRES   4 C  122  ASP TYR HIS LYS ILE ILE LYS GLN PRO MSE ASP MSE GLY          
SEQRES   5 C  122  THR ILE LYS ARG ARG LEU GLU ASN ASN TYR TYR TRP ALA          
SEQRES   6 C  122  ALA SER GLU CYS MSE GLN ASP PHE ASN THR MSE PHE THR          
SEQRES   7 C  122  ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL          
SEQRES   8 C  122  LEU MSE ALA GLN THR LEU GLU LYS ILE PHE LEU GLN LYS          
SEQRES   9 C  122  VAL ALA SER MSE PRO GLN GLU GLU GLN GLU LEU VAL VAL          
SEQRES  10 C  122  THR ILE PRO LYS ASN                                          
HET    MSE  A  87       8                                                       
HET    MSE  A 121       8                                                       
HET    MSE  A 123       8                                                       
HET    MSE  A 142       8                                                       
HET    MSE  A 148       8                                                       
HET    MSE  A 165       8                                                       
HET    MSE  A 180       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 121       8                                                       
HET    MSE  B 123       8                                                       
HET    MSE  B 142       8                                                       
HET    MSE  B 148       8                                                       
HET    MSE  B 165       8                                                       
HET    MSE  B 180       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  C 121       8                                                       
HET    MSE  C 123       8                                                       
HET    MSE  C 142       8                                                       
HET    MSE  C 148       8                                                       
HET    MSE  C 165       8                                                       
HET    MSE  C 180       8                                                       
HET    DTT   1301       8                                                       
HET    DTT   1302       8                                                       
HET    DTT   1303       8                                                       
HET    MES   1401      12                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     DTT 2,3-DIHYDROXY-1,4-DITHIOBUTANE                                   
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
HETSYN     DTT 1,4-DITHIOTHREITOL                                               
FORMUL   1  MSE    21(C5 H11 N O2 SE)                                           
FORMUL   4  DTT    3(C4 H10 O2 S2)                                              
FORMUL   7  MES    C6 H13 N O4 S                                                
FORMUL   8  HOH   *352(H2 O)                                                    
CRYST1  114.397   55.363   67.584  90.00  94.07  90.00 C 1 2 1      12          
ATOM   1891  N   THR C  76       1.606  43.281  -4.644  1.00 58.10           N  
ATOM   1892  CA  THR C  76       1.759  41.956  -5.332  1.00 56.46           C  
ATOM   1893  C   THR C  76       0.624  41.694  -6.311  1.00 54.99           C  
ATOM   1894  O   THR C  76      -0.348  42.440  -6.379  1.00 54.52           O  
ATOM   1895  CB  THR C  76       1.771  40.767  -4.304  1.00 57.89           C  
ATOM   1896  OG1 THR C  76       0.581  40.808  -3.499  1.00 55.52           O  
ATOM   1897  CG2 THR C  76       2.956  40.845  -3.286  1.00 60.26           C  
ATOM   1898  N   ASN C  77       0.763  40.586  -7.035  1.00 52.30           N  
ATOM   1899  CA  ASN C  77      -0.347  40.011  -7.754  1.00 50.82           C  
ATOM   1900  C   ASN C  77      -1.459  39.590  -6.765  1.00 47.04           C  
ATOM   1901  O   ASN C  77      -2.586  39.643  -7.130  1.00 44.38           O  
ATOM   1902  CB  ASN C  77       0.080  38.809  -8.613  1.00 51.59           C  
ATOM   1903  CG  ASN C  77      -0.454  38.890 -10.065  1.00 57.89           C  
ATOM   1904  OD1 ASN C  77      -0.399  39.973 -10.740  1.00 62.56           O  
ATOM   1905  ND2 ASN C  77      -0.962  37.737 -10.570  1.00 61.92           N  
ATOM   1906  N   GLN C  78      -1.131  39.191  -5.539  1.00 44.40           N  
ATOM   1907  CA  GLN C  78      -2.179  38.702  -4.606  1.00 42.78           C  
ATOM   1908  C   GLN C  78      -3.141  39.854  -4.207  1.00 40.75           C  
ATOM   1909  O   GLN C  78      -4.370  39.710  -4.262  1.00 39.22           O  
ATOM   1910  CB  GLN C  78      -1.578  38.072  -3.335  1.00 43.15           C  
ATOM   1911  CG  GLN C  78      -0.883  36.701  -3.564  1.00 42.00           C  
ATOM   1912  CD  GLN C  78      -0.716  35.911  -2.281  1.00 44.43           C  
ATOM   1913  OE1 GLN C  78      -0.935  34.694  -2.281  1.00 52.25           O  
ATOM   1914  NE2 GLN C  78      -0.290  36.568  -1.200  1.00 42.10           N  
ATOM   1915  N   LEU C  79      -2.564  40.993  -3.835  1.00 38.88           N  
ATOM   1916  CA  LEU C  79      -3.359  42.162  -3.412  1.00 38.49           C  
ATOM   1917  C   LEU C  79      -4.110  42.667  -4.627  1.00 38.41           C  
ATOM   1918  O   LEU C  79      -5.241  43.114  -4.511  1.00 38.11           O  
ATOM   1919  CB  LEU C  79      -2.479  43.221  -2.809  1.00 38.57           C  
ATOM   1920  CG  LEU C  79      -2.111  42.975  -1.346  1.00 39.38           C  
ATOM   1921  CD1 LEU C  79      -1.009  43.937  -0.957  1.00 43.17           C  
ATOM   1922  CD2 LEU C  79      -3.329  43.118  -0.454  1.00 40.93           C  
ATOM   1923  N   GLN C  80      -3.535  42.497  -5.820  1.00 38.27           N  
ATOM   1924  CA  GLN C  80      -4.247  42.958  -7.008  1.00 38.03           C  
ATOM   1925  C   GLN C  80      -5.412  42.071  -7.338  1.00 36.40           C  
ATOM   1926  O   GLN C  80      -6.457  42.532  -7.791  1.00 34.27           O  
ATOM   1927  CB  GLN C  80      -3.338  43.054  -8.201  1.00 40.00           C  
ATOM   1928  CG  GLN C  80      -2.310  44.087  -8.057  1.00 46.03           C  
ATOM   1929  CD  GLN C  80      -1.330  44.091  -9.258  1.00 55.12           C  
ATOM   1930  OE1 GLN C  80      -1.750  43.832 -10.406  1.00 60.71           O  
ATOM   1931  NE2 GLN C  80      -0.018  44.367  -8.986  1.00 58.97           N  
ATOM   1932  N   TYR C  81      -5.241  40.780  -7.118  1.00 34.16           N  
ATOM   1933  CA  TYR C  81      -6.331  39.833  -7.273  1.00 33.87           C  
ATOM   1934  C   TYR C  81      -7.424  40.120  -6.219  1.00 32.70           C  
ATOM   1935  O   TYR C  81      -8.610  40.162  -6.559  1.00 33.57           O  
ATOM   1936  CB  TYR C  81      -5.754  38.406  -7.181  1.00 34.48           C  
ATOM   1937  CG  TYR C  81      -6.764  37.284  -7.252  1.00 35.17           C  
ATOM   1938  CD1 TYR C  81      -7.193  36.785  -8.455  1.00 33.92           C  
ATOM   1939  CD2 TYR C  81      -7.291  36.737  -6.071  1.00 35.95           C  
ATOM   1940  CE1 TYR C  81      -8.142  35.827  -8.503  1.00 35.82           C  
ATOM   1941  CE2 TYR C  81      -8.208  35.758  -6.123  1.00 34.20           C  
ATOM   1942  CZ  TYR C  81      -8.620  35.279  -7.313  1.00 36.85           C  
ATOM   1943  OH  TYR C  81      -9.529  34.264  -7.322  1.00 36.39           O  
ATOM   1944  N   LEU C  82      -7.061  40.340  -4.978  1.00 31.78           N  
ATOM   1945  CA  LEU C  82      -8.079  40.692  -3.930  1.00 31.65           C  
ATOM   1946  C   LEU C  82      -8.902  41.955  -4.260  1.00 31.98           C  
ATOM   1947  O   LEU C  82     -10.081  42.045  -3.982  1.00 31.54           O  
ATOM   1948  CB  LEU C  82      -7.418  40.829  -2.547  1.00 31.34           C  
ATOM   1949  CG  LEU C  82      -7.025  39.524  -1.820  1.00 34.59           C  
ATOM   1950  CD1 LEU C  82      -6.145  39.768  -0.676  1.00 31.40           C  
ATOM   1951  CD2 LEU C  82      -8.156  38.775  -1.347  1.00 35.06           C  
ATOM   1952  N   HIS C  83      -8.268  42.900  -4.944  1.00 30.94           N  
ATOM   1953  CA  HIS C  83      -8.906  44.159  -5.289  1.00 32.98           C  
ATOM   1954  C   HIS C  83      -9.723  43.952  -6.559  1.00 33.91           C  
ATOM   1955  O   HIS C  83     -10.939  44.140  -6.555  1.00 32.64           O  
ATOM   1956  CB  HIS C  83      -7.817  45.212  -5.431  1.00 31.61           C  
ATOM   1957  CG  HIS C  83      -8.305  46.574  -5.780  1.00 34.66           C  
ATOM   1958  ND1 HIS C  83      -9.618  46.981  -5.641  1.00 41.19           N  
ATOM   1959  CD2 HIS C  83      -7.617  47.654  -6.172  1.00 34.50           C  
ATOM   1960  CE1 HIS C  83      -9.712  48.253  -5.991  1.00 39.86           C  
ATOM   1961  NE2 HIS C  83      -8.505  48.686  -6.299  1.00 39.46           N  
ATOM   1962  N   LYS C  84      -9.052  43.455  -7.595  1.00 35.32           N  
ATOM   1963  CA  LYS C  84      -9.590  43.440  -8.967  1.00 37.86           C  
ATOM   1964  C   LYS C  84     -10.525  42.303  -9.238  1.00 37.64           C  
ATOM   1965  O   LYS C  84     -11.303  42.344 -10.181  1.00 38.50           O  
ATOM   1966  CB  LYS C  84      -8.405  43.406  -9.980  1.00 38.53           C  
ATOM   1967  CG  LYS C  84      -8.068  44.750 -10.535  1.00 45.73           C  
ATOM   1968  CD  LYS C  84      -7.436  45.684  -9.557  1.00 49.65           C  
ATOM   1969  CE  LYS C  84      -7.213  47.063 -10.151  1.00 54.49           C  
ATOM   1970  NZ  LYS C  84      -8.498  47.798 -10.476  1.00 59.28           N  
ATOM   1971  N   VAL C  85     -10.494  41.268  -8.409  1.00 37.40           N  
ATOM   1972  CA  VAL C  85     -11.373  40.134  -8.628  1.00 36.39           C  
ATOM   1973  C   VAL C  85     -12.266  39.856  -7.388  1.00 34.87           C  
ATOM   1974  O   VAL C  85     -13.478  39.764  -7.502  1.00 34.69           O  
ATOM   1975  CB  VAL C  85     -10.571  38.875  -8.946  1.00 37.49           C  
ATOM   1976  CG1 VAL C  85     -11.503  37.686  -9.012  1.00 38.51           C  
ATOM   1977  CG2 VAL C  85      -9.790  39.054 -10.288  1.00 41.50           C  
ATOM   1978  N   VAL C  86     -11.673  39.686  -6.223  1.00 33.09           N  
ATOM   1979  CA  VAL C  86     -12.494  39.401  -5.042  1.00 31.79           C  
ATOM   1980  C   VAL C  86     -13.430  40.560  -4.670  1.00 30.94           C  
ATOM   1981  O   VAL C  86     -14.641  40.392  -4.615  1.00 30.15           O  
ATOM   1982  CB  VAL C  86     -11.654  38.994  -3.890  1.00 32.77           C  
ATOM   1983  CG1 VAL C  86     -12.551  38.604  -2.715  1.00 31.87           C  
ATOM   1984  CG2 VAL C  86     -10.772  37.826  -4.261  1.00 34.67           C  
HETATM 1985  N   MSE C  87     -12.860  41.703  -4.336  1.00 30.43           N  
HETATM 1986  CA  MSE C  87     -13.664  42.865  -3.891  1.00 32.19           C  
HETATM 1987  C   MSE C  87     -14.613  43.328  -4.991  1.00 31.91           C  
HETATM 1988  O   MSE C  87     -15.723  43.715  -4.712  1.00 30.66           O  
HETATM 1989  CB  MSE C  87     -12.786  44.046  -3.512  1.00 31.70           C  
HETATM 1990  CG  MSE C  87     -13.578  45.318  -3.066  1.00 35.78           C  
HETATM 1991 SE   MSE C  87     -14.849  44.864  -1.561  1.00 50.41          SE  
HETATM 1992  CE  MSE C  87     -13.539  45.145  -0.028  1.00 41.43           C  
ATOM   1993  N   LYS C  88     -14.155  43.241  -6.235  1.00 33.30           N  
ATOM   1994  CA  LYS C  88     -15.032  43.525  -7.389  1.00 35.84           C  
ATOM   1995  C   LYS C  88     -16.335  42.717  -7.391  1.00 34.64           C  
ATOM   1996  O   LYS C  88     -17.448  43.278  -7.392  1.00 34.37           O  
ATOM   1997  CB  LYS C  88     -14.246  43.364  -8.708  1.00 37.82           C  
ATOM   1998  CG  LYS C  88     -15.111  43.646  -9.972  1.00 43.87           C  
ATOM   1999  CD  LYS C  88     -14.254  43.872 -11.264  1.00 51.62           C  
ATOM   2000  CE  LYS C  88     -15.126  44.503 -12.403  1.00 56.60           C  
ATOM   2001  NZ  LYS C  88     -14.479  44.487 -13.790  1.00 60.62           N  
ATOM   2002  N   ALA C  89     -16.199  41.414  -7.227  1.00 34.73           N  
ATOM   2003  CA  ALA C  89     -17.351  40.561  -7.040  1.00 34.59           C  
ATOM   2004  C   ALA C  89     -18.131  40.811  -5.741  1.00 33.96           C  
ATOM   2005  O   ALA C  89     -19.376  40.883  -5.767  1.00 35.57           O  
ATOM   2006  CB  ALA C  89     -16.950  39.116  -7.102  1.00 35.89           C  
ATOM   2007  N   LEU C  90     -17.432  40.955  -4.600  1.00 32.32           N  
ATOM   2008  CA  LEU C  90     -18.163  41.120  -3.376  1.00 30.57           C  
ATOM   2009  C   LEU C  90     -18.925  42.444  -3.338  1.00 30.51           C  
ATOM   2010  O   LEU C  90     -20.048  42.470  -2.902  1.00 29.65           O  
ATOM   2011  CB  LEU C  90     -17.246  40.970  -2.157  1.00 31.49           C  
ATOM   2012  CG  LEU C  90     -16.616  39.562  -2.020  1.00 34.89           C  
ATOM   2013  CD1 LEU C  90     -15.690  39.490  -0.838  1.00 35.58           C  
ATOM   2014  CD2 LEU C  90     -17.629  38.493  -1.966  1.00 35.53           C  
ATOM   2015  N   TRP C  91     -18.284  43.529  -3.749  1.00 31.02           N  
ATOM   2016  CA  TRP C  91     -18.853  44.886  -3.567  1.00 31.56           C  
ATOM   2017  C   TRP C  91     -20.182  44.986  -4.268  1.00 32.29           C  
ATOM   2018  O   TRP C  91     -21.107  45.544  -3.698  1.00 31.22           O  
ATOM   2019  CB  TRP C  91     -17.898  45.925  -4.105  1.00 31.64           C  
ATOM   2020  CG  TRP C  91     -18.357  47.291  -3.913  1.00 31.40           C  
ATOM   2021  CD1 TRP C  91     -18.889  48.097  -4.882  1.00 36.79           C  
ATOM   2022  CD2 TRP C  91     -18.299  48.081  -2.718  1.00 31.64           C  
ATOM   2023  NE1 TRP C  91     -19.151  49.339  -4.372  1.00 33.44           N  
ATOM   2024  CE2 TRP C  91     -18.840  49.344  -3.027  1.00 35.83           C  
ATOM   2025  CE3 TRP C  91     -17.816  47.858  -1.418  1.00 32.01           C  
ATOM   2026  CZ2 TRP C  91     -18.958  50.366  -2.073  1.00 35.81           C  
ATOM   2027  CZ3 TRP C  91     -17.954  48.834  -0.478  1.00 30.25           C  
ATOM   2028  CH2 TRP C  91     -18.497  50.090  -0.801  1.00 35.31           C  
ATOM   2029  N   LYS C  92     -20.309  44.356  -5.442  1.00 32.62           N  
ATOM   2030  CA  LYS C  92     -21.561  44.456  -6.227  1.00 34.93           C  
ATOM   2031  C   LYS C  92     -22.622  43.411  -5.957  1.00 36.08           C  
ATOM   2032  O   LYS C  92     -23.753  43.513  -6.475  1.00 34.77           O  
ATOM   2033  CB  LYS C  92     -21.266  44.509  -7.735  1.00 37.34           C  
ATOM   2034  CG  LYS C  92     -20.702  43.262  -8.359  1.00 41.69           C  
ATOM   2035  CD  LYS C  92     -20.415  43.553  -9.835  1.00 49.09           C  
ATOM   2036  CE  LYS C  92     -19.631  42.457 -10.537  1.00 51.10           C  
ATOM   2037  NZ  LYS C  92     -19.992  42.445 -11.995  1.00 57.80           N  
ATOM   2038  N   HIS C  93     -22.308  42.438  -5.096  1.00 33.47           N  
ATOM   2039  CA  HIS C  93     -23.274  41.432  -4.760  1.00 32.85           C  
ATOM   2040  C   HIS C  93     -24.483  42.053  -4.061  1.00 32.92           C  
ATOM   2041  O   HIS C  93     -24.338  42.948  -3.266  1.00 31.48           O  
ATOM   2042  CB  HIS C  93     -22.587  40.372  -3.873  1.00 31.96           C  
ATOM   2043  CG  HIS C  93     -23.331  39.099  -3.815  1.00 29.91           C  
ATOM   2044  ND1 HIS C  93     -24.507  38.984  -3.121  1.00 28.27           N  
ATOM   2045  CD2 HIS C  93     -23.098  37.891  -4.383  1.00 31.77           C  
ATOM   2046  CE1 HIS C  93     -24.971  37.757  -3.246  1.00 33.38           C  
ATOM   2047  NE2 HIS C  93     -24.122  37.072  -3.996  1.00 32.99           N  
ATOM   2048  N   GLN C  94     -25.679  41.540  -4.298  1.00 33.00           N  
ATOM   2049  CA  GLN C  94     -26.894  42.117  -3.705  1.00 35.15           C  
ATOM   2050  C   GLN C  94     -26.940  42.000  -2.208  1.00 33.59           C  
ATOM   2051  O   GLN C  94     -27.568  42.803  -1.550  1.00 31.24           O  
ATOM   2052  CB  GLN C  94     -28.173  41.443  -4.273  1.00 37.95           C  
ATOM   2053  CG  GLN C  94     -28.272  39.945  -3.971  1.00 42.89           C  
ATOM   2054  CD  GLN C  94     -29.614  39.336  -4.336  1.00 49.55           C  
ATOM   2055  OE1 GLN C  94     -29.633  38.482  -5.194  1.00 53.58           O  
ATOM   2056  NE2 GLN C  94     -30.724  39.735  -3.654  1.00 51.76           N  
ATOM   2057  N   PHE C  95     -26.204  41.022  -1.642  1.00 33.31           N  
ATOM   2058  CA  PHE C  95     -26.154  40.848  -0.178  1.00 31.31           C  
ATOM   2059  C   PHE C  95     -25.090  41.694   0.508  1.00 31.07           C  
ATOM   2060  O   PHE C  95     -24.996  41.630   1.738  1.00 29.95           O  
ATOM   2061  CB  PHE C  95     -25.879  39.373   0.176  1.00 33.18           C  
ATOM   2062  CG  PHE C  95     -26.986  38.448  -0.146  1.00 34.52           C  
ATOM   2063  CD1 PHE C  95     -28.302  38.906  -0.311  1.00 42.49           C  
ATOM   2064  CD2 PHE C  95     -26.750  37.089  -0.228  1.00 41.87           C  
ATOM   2065  CE1 PHE C  95     -29.362  37.991  -0.588  1.00 45.40           C  
ATOM   2066  CE2 PHE C  95     -27.819  36.161  -0.517  1.00 42.78           C  
ATOM   2067  CZ  PHE C  95     -29.086  36.620  -0.707  1.00 44.86           C  
ATOM   2068  N   ALA C  96     -24.296  42.433  -0.261  1.00 29.43           N  
ATOM   2069  CA  ALA C  96     -23.230  43.303   0.275  1.00 30.00           C  
ATOM   2070  C   ALA C  96     -23.714  44.502   1.038  1.00 29.17           C  
ATOM   2071  O   ALA C  96     -22.967  45.079   1.819  1.00 26.96           O  
ATOM   2072  CB  ALA C  96     -22.335  43.786  -0.822  1.00 30.12           C  
ATOM   2073  N   TRP C  97     -24.968  44.893   0.842  1.00 28.59           N  
ATOM   2074  CA  TRP C  97     -25.416  46.189   1.348  1.00 28.10           C  
ATOM   2075  C   TRP C  97     -25.240  46.474   2.830  1.00 28.19           C  
ATOM   2076  O   TRP C  97     -24.904  47.613   3.164  1.00 27.53           O  
ATOM   2077  CB  TRP C  97     -26.879  46.520   0.816  1.00 29.28           C  
ATOM   2078  CG  TRP C  97     -27.889  45.735   1.388  1.00 25.95           C  
ATOM   2079  CD1 TRP C  97     -28.402  44.606   0.880  1.00 26.63           C  
ATOM   2080  CD2 TRP C  97     -28.512  45.957   2.632  1.00 26.79           C  
ATOM   2081  NE1 TRP C  97     -29.328  44.100   1.741  1.00 28.75           N  
ATOM   2082  CE2 TRP C  97     -29.409  44.912   2.834  1.00 28.60           C  
ATOM   2083  CE3 TRP C  97     -28.350  46.897   3.650  1.00 29.06           C  
ATOM   2084  CZ2 TRP C  97     -30.229  44.811   3.977  1.00 29.51           C  
ATOM   2085  CZ3 TRP C  97     -29.158  46.798   4.791  1.00 32.15           C  
ATOM   2086  CH2 TRP C  97     -30.081  45.755   4.939  1.00 33.03           C  
ATOM   2087  N   PRO C  98     -25.465  45.544   3.754  1.00 28.51           N  
ATOM   2088  CA  PRO C  98     -25.180  45.851   5.157  1.00 28.10           C  
ATOM   2089  C   PRO C  98     -23.692  46.074   5.478  1.00 27.72           C  
ATOM   2090  O   PRO C  98     -23.388  46.556   6.598  1.00 30.21           O  
ATOM   2091  CB  PRO C  98     -25.644  44.587   5.888  1.00 28.88           C  
ATOM   2092  CG  PRO C  98     -26.150  43.704   4.977  1.00 30.41           C  
ATOM   2093  CD  PRO C  98     -25.998  44.181   3.629  1.00 29.19           C  
ATOM   2094  N   PHE C  99     -22.824  45.699   4.553  1.00 25.60           N  
ATOM   2095  CA  PHE C  99     -21.386  45.634   4.766  1.00 25.79           C  
ATOM   2096  C   PHE C  99     -20.618  46.748   4.064  1.00 26.59           C  
ATOM   2097  O   PHE C  99     -19.442  46.898   4.340  1.00 26.68           O  
ATOM   2098  CB  PHE C  99     -20.842  44.285   4.366  1.00 25.14           C  
ATOM   2099  CG  PHE C  99     -21.586  43.192   5.011  1.00 24.90           C  
ATOM   2100  CD1 PHE C  99     -21.489  43.006   6.392  1.00 27.22           C  
ATOM   2101  CD2 PHE C  99     -22.479  42.420   4.282  1.00 27.16           C  
ATOM   2102  CE1 PHE C  99     -22.227  41.994   7.022  1.00 31.49           C  
ATOM   2103  CE2 PHE C  99     -23.221  41.413   4.908  1.00 26.01           C  
ATOM   2104  CZ  PHE C  99     -23.111  41.216   6.257  1.00 27.48           C  
ATOM   2105  N   ARG C 100     -21.278  47.542   3.232  1.00 26.49           N  
ATOM   2106  CA  ARG C 100     -20.567  48.535   2.418  1.00 27.91           C  
ATOM   2107  C   ARG C 100     -20.058  49.788   3.165  1.00 28.36           C  
ATOM   2108  O   ARG C 100     -19.179  50.509   2.660  1.00 31.07           O  
ATOM   2109  CB  ARG C 100     -21.396  48.963   1.210  1.00 26.72           C  
ATOM   2110  CG  ARG C 100     -21.520  47.962   0.142  1.00 29.65           C  
ATOM   2111  CD  ARG C 100     -22.341  48.508  -1.113  1.00 32.70           C  
ATOM   2112  NE  ARG C 100     -22.587  47.431  -2.028  1.00 33.50           N  
ATOM   2113  CZ  ARG C 100     -23.781  47.026  -2.388  1.00 37.30           C  
ATOM   2114  NH1 ARG C 100     -24.865  47.618  -1.921  1.00 38.96           N  
ATOM   2115  NH2 ARG C 100     -23.901  45.975  -3.169  1.00 41.62           N  
ATOM   2116  N   GLN C 101     -20.563  50.007   4.358  1.00 29.69           N  
ATOM   2117  CA  GLN C 101     -20.250  51.171   5.196  1.00 31.81           C  
ATOM   2118  C   GLN C 101     -20.199  50.732   6.674  1.00 30.65           C  
ATOM   2119  O   GLN C 101     -20.741  49.664   7.037  1.00 28.45           O  
ATOM   2120  CB  GLN C 101     -21.316  52.290   4.959  1.00 32.95           C  
ATOM   2121  CG  GLN C 101     -22.744  51.897   5.412  1.00 36.53           C  
ATOM   2122  CD  GLN C 101     -23.440  50.806   4.481  1.00 41.62           C  
ATOM   2123  OE1 GLN C 101     -23.836  49.662   4.920  1.00 34.63           O  
ATOM   2124  NE2 GLN C 101     -23.566  51.164   3.196  1.00 39.99           N  
ATOM   2125  N   PRO C 102     -19.476  51.491   7.496  1.00 32.05           N  
ATOM   2126  CA  PRO C 102     -19.376  51.181   8.916  1.00 32.20           C  
ATOM   2127  C   PRO C 102     -20.732  51.109   9.542  1.00 32.96           C  
ATOM   2128  O   PRO C 102     -21.653  51.875   9.191  1.00 31.39           O  
ATOM   2129  CB  PRO C 102     -18.591  52.349   9.514  1.00 33.60           C  
ATOM   2130  CG  PRO C 102     -17.958  53.069   8.289  1.00 34.28           C  
ATOM   2131  CD  PRO C 102     -18.711  52.704   7.100  1.00 33.40           C  
ATOM   2132  N   VAL C 103     -20.847  50.202  10.505  1.00 32.54           N  
ATOM   2133  CA  VAL C 103     -22.051  50.095  11.286  1.00 32.87           C  
ATOM   2134  C   VAL C 103     -22.225  51.395  12.100  1.00 34.74           C  
ATOM   2135  O   VAL C 103     -21.367  51.756  12.889  1.00 33.54           O  
ATOM   2136  CB  VAL C 103     -21.989  48.916  12.277  1.00 33.19           C  
ATOM   2137  CG1 VAL C 103     -23.143  48.940  13.149  1.00 32.88           C  
ATOM   2138  CG2 VAL C 103     -21.977  47.561  11.535  1.00 33.48           C  
ATOM   2139  N   ASP C 104     -23.312  52.111  11.859  1.00 36.46           N  
ATOM   2140  CA  ASP C 104     -23.603  53.321  12.646  1.00 36.56           C  
ATOM   2141  C   ASP C 104     -24.493  52.925  13.798  1.00 35.53           C  
ATOM   2142  O   ASP C 104     -25.705  52.845  13.671  1.00 34.84           O  
ATOM   2143  CB  ASP C 104     -24.285  54.389  11.819  1.00 38.47           C  
ATOM   2144  CG  ASP C 104     -24.339  55.751  12.559  1.00 41.35           C  
ATOM   2145  OD1 ASP C 104     -24.569  55.800  13.817  1.00 39.27           O  
ATOM   2146  OD2 ASP C 104     -24.210  56.824  11.913  1.00 49.04           O  
ATOM   2147  N   ALA C 105     -23.881  52.647  14.942  1.00 35.25           N  
ATOM   2148  CA  ALA C 105     -24.636  52.119  16.058  1.00 36.01           C  
ATOM   2149  C   ALA C 105     -25.719  53.122  16.575  1.00 37.16           C  
ATOM   2150  O   ALA C 105     -26.789  52.723  17.051  1.00 36.94           O  
ATOM   2151  CB  ALA C 105     -23.669  51.754  17.169  1.00 36.74           C  
ATOM   2152  N   VAL C 106     -25.451  54.419  16.509  1.00 37.18           N  
ATOM   2153  CA  VAL C 106     -26.421  55.391  17.003  1.00 38.67           C  
ATOM   2154  C   VAL C 106     -27.618  55.411  16.075  1.00 39.20           C  
ATOM   2155  O   VAL C 106     -28.737  55.284  16.538  1.00 39.61           O  
ATOM   2156  CB  VAL C 106     -25.766  56.794  17.114  1.00 39.73           C  
ATOM   2157  CG1 VAL C 106     -26.810  57.878  17.311  1.00 42.21           C  
ATOM   2158  CG2 VAL C 106     -24.732  56.777  18.295  1.00 41.10           C  
ATOM   2159  N   LYS C 107     -27.381  55.516  14.761  1.00 38.58           N  
ATOM   2160  CA  LYS C 107     -28.482  55.657  13.807  1.00 41.12           C  
ATOM   2161  C   LYS C 107     -29.301  54.378  13.737  1.00 40.35           C  
ATOM   2162  O   LYS C 107     -30.482  54.424  13.537  1.00 40.82           O  
ATOM   2163  CB  LYS C 107     -27.989  56.042  12.408  1.00 40.95           C  
ATOM   2164  CG  LYS C 107     -27.245  57.430  12.312  1.00 48.20           C  
ATOM   2165  CD  LYS C 107     -27.970  58.649  12.951  1.00 55.50           C  
ATOM   2166  CE  LYS C 107     -26.971  59.867  13.086  1.00 60.58           C  
ATOM   2167  NZ  LYS C 107     -27.520  61.026  13.917  1.00 62.05           N  
ATOM   2168  N   LEU C 108     -28.672  53.234  13.935  1.00 39.64           N  
ATOM   2169  CA  LEU C 108     -29.386  51.957  13.813  1.00 40.91           C  
ATOM   2170  C   LEU C 108     -29.884  51.583  15.177  1.00 41.06           C  
ATOM   2171  O   LEU C 108     -30.504  50.582  15.342  1.00 41.94           O  
ATOM   2172  CB  LEU C 108     -28.430  50.878  13.295  1.00 40.92           C  
ATOM   2173  CG  LEU C 108     -28.143  50.672  11.789  1.00 45.19           C  
ATOM   2174  CD1 LEU C 108     -28.180  51.892  10.828  1.00 51.20           C  
ATOM   2175  CD2 LEU C 108     -26.762  49.921  11.643  1.00 42.71           C  
ATOM   2176  N   GLY C 109     -29.584  52.382  16.198  1.00 42.27           N  
ATOM   2177  CA  GLY C 109     -30.134  52.111  17.516  1.00 42.94           C  
ATOM   2178  C   GLY C 109     -29.600  50.857  18.201  1.00 43.61           C  
ATOM   2179  O   GLY C 109     -30.380  50.133  18.828  1.00 44.63           O  
ATOM   2180  N   LEU C 110     -28.277  50.618  18.091  1.00 42.40           N  
ATOM   2181  CA  LEU C 110     -27.553  49.464  18.658  1.00 41.69           C  
ATOM   2182  C   LEU C 110     -26.561  49.954  19.724  1.00 41.39           C  
ATOM   2183  O   LEU C 110     -25.351  49.814  19.540  1.00 40.32           O  
ATOM   2184  CB  LEU C 110     -26.723  48.783  17.561  1.00 40.87           C  
ATOM   2185  CG  LEU C 110     -27.323  48.002  16.394  1.00 41.99           C  
ATOM   2186  CD1 LEU C 110     -28.763  48.170  16.242  1.00 45.33           C  
ATOM   2187  CD2 LEU C 110     -26.625  48.222  15.097  1.00 43.32           C  
ATOM   2188  N   PRO C 111     -27.054  50.458  20.863  1.00 41.94           N  
ATOM   2189  CA  PRO C 111     -26.178  50.968  21.954  1.00 40.78           C  
ATOM   2190  C   PRO C 111     -25.182  49.976  22.529  1.00 40.05           C  
ATOM   2191  O   PRO C 111     -24.206  50.429  23.173  1.00 40.68           O  
ATOM   2192  CB  PRO C 111     -27.167  51.334  23.073  1.00 41.13           C  
ATOM   2193  CG  PRO C 111     -28.395  50.548  22.763  1.00 42.39           C  
ATOM   2194  CD  PRO C 111     -28.479  50.495  21.260  1.00 42.54           C  
ATOM   2195  N   ASP C 112     -25.378  48.670  22.353  1.00 36.19           N  
ATOM   2196  CA  ASP C 112     -24.321  47.765  22.829  1.00 35.41           C  
ATOM   2197  C   ASP C 112     -23.292  47.312  21.771  1.00 32.54           C  
ATOM   2198  O   ASP C 112     -22.333  46.587  22.115  1.00 31.60           O  
ATOM   2199  CB  ASP C 112     -24.935  46.530  23.450  1.00 36.78           C  
ATOM   2200  CG  ASP C 112     -25.779  45.760  22.463  1.00 40.91           C  
ATOM   2201  OD1 ASP C 112     -26.288  46.365  21.451  1.00 40.34           O  
ATOM   2202  OD2 ASP C 112     -25.967  44.529  22.630  1.00 48.22           O  
ATOM   2203  N   TYR C 113     -23.486  47.728  20.516  1.00 29.12           N  
ATOM   2204  CA  TYR C 113     -22.632  47.280  19.388  1.00 27.52           C  
ATOM   2205  C   TYR C 113     -21.172  47.321  19.725  1.00 27.41           C  
ATOM   2206  O   TYR C 113     -20.480  46.340  19.648  1.00 25.22           O  
ATOM   2207  CB  TYR C 113     -22.919  48.047  18.093  1.00 27.88           C  
ATOM   2208  CG  TYR C 113     -22.174  47.410  16.917  1.00 26.66           C  
ATOM   2209  CD1 TYR C 113     -22.656  46.230  16.364  1.00 27.02           C  
ATOM   2210  CD2 TYR C 113     -20.929  47.906  16.453  1.00 26.10           C  
ATOM   2211  CE1 TYR C 113     -21.952  45.613  15.305  1.00 27.33           C  
ATOM   2212  CE2 TYR C 113     -20.270  47.328  15.434  1.00 25.79           C  
ATOM   2213  CZ  TYR C 113     -20.812  46.160  14.848  1.00 23.96           C  
ATOM   2214  OH  TYR C 113     -20.150  45.497  13.894  1.00 26.50           O  
ATOM   2215  N   HIS C 114     -20.693  48.507  20.135  1.00 26.90           N  
ATOM   2216  CA  HIS C 114     -19.289  48.742  20.353  1.00 26.51           C  
ATOM   2217  C   HIS C 114     -18.827  48.198  21.698  1.00 28.48           C  
ATOM   2218  O   HIS C 114     -17.658  48.109  21.941  1.00 28.30           O  
ATOM   2219  CB  HIS C 114     -19.120  50.253  20.243  1.00 29.15           C  
ATOM   2220  CG  HIS C 114     -19.250  50.749  18.833  1.00 23.84           C  
ATOM   2221  ND1 HIS C 114     -18.342  50.399  17.870  1.00 30.49           N  
ATOM   2222  CD2 HIS C 114     -20.195  51.487  18.212  1.00 28.43           C  
ATOM   2223  CE1 HIS C 114     -18.698  50.941  16.711  1.00 28.55           C  
ATOM   2224  NE2 HIS C 114     -19.840  51.579  16.887  1.00 27.94           N  
ATOM   2225  N   LYS C 115     -19.742  47.838  22.586  1.00 28.79           N  
ATOM   2226  CA  LYS C 115     -19.360  47.079  23.791  1.00 31.75           C  
ATOM   2227  C   LYS C 115     -19.039  45.600  23.416  1.00 31.16           C  
ATOM   2228  O   LYS C 115     -18.152  45.008  23.946  1.00 30.71           O  
ATOM   2229  CB  LYS C 115     -20.496  47.062  24.784  1.00 32.95           C  
ATOM   2230  CG  LYS C 115     -20.857  48.451  25.279  1.00 40.91           C  
ATOM   2231  CD  LYS C 115     -21.888  48.337  26.369  1.00 46.92           C  
ATOM   2232  CE  LYS C 115     -22.259  49.722  26.907  1.00 52.87           C  
ATOM   2233  NZ  LYS C 115     -23.556  49.618  27.650  1.00 55.07           N  
ATOM   2234  N   ILE C 116     -19.728  45.072  22.428  1.00 29.58           N  
ATOM   2235  CA  ILE C 116     -19.551  43.653  22.058  1.00 29.64           C  
ATOM   2236  C   ILE C 116     -18.503  43.512  20.995  1.00 29.17           C  
ATOM   2237  O   ILE C 116     -17.658  42.642  21.053  1.00 28.99           O  
ATOM   2238  CB  ILE C 116     -20.905  43.131  21.617  1.00 29.32           C  
ATOM   2239  CG1 ILE C 116     -21.823  42.980  22.821  1.00 32.13           C  
ATOM   2240  CG2 ILE C 116     -20.770  41.730  20.912  1.00 31.79           C  
ATOM   2241  CD1 ILE C 116     -23.228  42.614  22.411  1.00 38.34           C  
ATOM   2242  N   ILE C 117     -18.570  44.359  19.961  1.00 27.73           N  
ATOM   2243  CA  ILE C 117     -17.612  44.258  18.885  1.00 27.25           C  
ATOM   2244  C   ILE C 117     -16.479  45.273  19.131  1.00 28.31           C  
ATOM   2245  O   ILE C 117     -16.734  46.499  19.093  1.00 30.73           O  
ATOM   2246  CB  ILE C 117     -18.309  44.524  17.543  1.00 25.71           C  
ATOM   2247  CG1 ILE C 117     -19.395  43.492  17.261  1.00 27.39           C  
ATOM   2248  CG2 ILE C 117     -17.265  44.631  16.357  1.00 24.48           C  
ATOM   2249  CD1 ILE C 117     -18.818  42.039  17.331  1.00 25.36           C  
ATOM   2250  N   LYS C 118     -15.282  44.765  19.277  1.00 28.79           N  
ATOM   2251  CA  LYS C 118     -14.094  45.583  19.583  1.00 32.25           C  
ATOM   2252  C   LYS C 118     -13.331  46.115  18.396  1.00 30.39           C  
ATOM   2253  O   LYS C 118     -12.692  47.140  18.533  1.00 31.39           O  
ATOM   2254  CB  LYS C 118     -13.095  44.835  20.515  1.00 34.01           C  
ATOM   2255  CG  LYS C 118     -13.691  44.266  21.793  1.00 38.93           C  
ATOM   2256  CD  LYS C 118     -14.686  45.156  22.548  1.00 47.06           C  
ATOM   2257  CE  LYS C 118     -14.074  46.401  23.199  1.00 51.44           C  
ATOM   2258  NZ  LYS C 118     -15.180  47.465  23.618  1.00 51.83           N  
ATOM   2259  N   GLN C 119     -13.404  45.454  17.245  1.00 28.99           N  
ATOM   2260  CA  GLN C 119     -12.735  45.889  16.014  1.00 30.00           C  
ATOM   2261  C   GLN C 119     -13.755  45.967  14.852  1.00 28.40           C  
ATOM   2262  O   GLN C 119     -13.878  45.017  14.065  1.00 25.47           O  
ATOM   2263  CB  GLN C 119     -11.679  44.884  15.625  1.00 31.80           C  
ATOM   2264  CG  GLN C 119     -10.519  44.870  16.561  1.00 41.76           C  
ATOM   2265  CD  GLN C 119      -9.658  43.606  16.406  1.00 52.57           C  
ATOM   2266  OE1 GLN C 119      -8.988  43.378  15.362  1.00 57.32           O  
ATOM   2267  NE2 GLN C 119      -9.657  42.796  17.458  1.00 59.71           N  
ATOM   2268  N   PRO C 120     -14.466  47.062  14.740  1.00 26.89           N  
ATOM   2269  CA  PRO C 120     -15.360  47.225  13.582  1.00 27.30           C  
ATOM   2270  C   PRO C 120     -14.600  47.167  12.270  1.00 27.15           C  
ATOM   2271  O   PRO C 120     -13.459  47.567  12.177  1.00 24.92           O  
ATOM   2272  CB  PRO C 120     -15.958  48.586  13.807  1.00 27.80           C  
ATOM   2273  CG  PRO C 120     -15.919  48.726  15.293  1.00 28.49           C  
ATOM   2274  CD  PRO C 120     -14.512  48.255  15.611  1.00 27.78           C  
HETATM 2275  N   MSE C 121     -15.226  46.606  11.250  1.00 24.74           N  
HETATM 2276  CA  MSE C 121     -14.660  46.517   9.918  1.00 26.02           C  
HETATM 2277  C   MSE C 121     -15.779  46.428   8.900  1.00 25.32           C  
HETATM 2278  O   MSE C 121     -16.836  45.864   9.162  1.00 25.97           O  
HETATM 2279  CB  MSE C 121     -13.708  45.292   9.806  1.00 25.04           C  
HETATM 2280  CG  MSE C 121     -12.982  45.209   8.523  1.00 27.63           C  
HETATM 2281 SE   MSE C 121     -11.961  46.857   8.014  1.00 41.29          SE  
HETATM 2282  CE  MSE C 121     -10.936  47.049   9.720  1.00 35.87           C  
ATOM   2283  N   ASP C 122     -15.571  47.044   7.757  1.00 26.88           N  
ATOM   2284  CA  ASP C 122     -16.583  47.089   6.709  1.00 26.39           C  
ATOM   2285  C   ASP C 122     -15.879  47.070   5.348  1.00 26.14           C  
ATOM   2286  O   ASP C 122     -14.672  47.385   5.241  1.00 22.99           O  
ATOM   2287  CB  ASP C 122     -17.447  48.299   6.877  1.00 26.89           C  
ATOM   2288  CG  ASP C 122     -16.710  49.587   6.509  1.00 30.04           C  
ATOM   2289  OD1 ASP C 122     -15.877  50.066   7.360  1.00 33.71           O  
ATOM   2290  OD2 ASP C 122     -16.752  50.043   5.346  1.00 33.50           O  
HETATM 2291  N   MSE C 123     -16.616  46.717   4.301  1.00 25.60           N  
HETATM 2292  CA  MSE C 123     -16.032  46.674   2.944  1.00 27.64           C  
HETATM 2293  C   MSE C 123     -15.601  47.982   2.394  1.00 25.67           C  
HETATM 2294  O   MSE C 123     -14.712  47.981   1.575  1.00 27.46           O  
HETATM 2295  CB  MSE C 123     -17.023  46.083   1.916  1.00 27.47           C  
HETATM 2296  CG  MSE C 123     -17.291  44.749   2.100  1.00 36.19           C  
HETATM 2297 SE   MSE C 123     -18.401  44.147   0.469  1.00 54.11          SE  
HETATM 2298  CE  MSE C 123     -19.161  42.405   1.366  1.00 46.33           C  
ATOM   2299  N   GLY C 124     -16.276  49.053   2.767  1.00 25.39           N  
ATOM   2300  CA  GLY C 124     -15.884  50.411   2.376  1.00 26.99           C  
ATOM   2301  C   GLY C 124     -14.472  50.745   2.734  1.00 27.43           C  
ATOM   2302  O   GLY C 124     -13.662  51.155   1.916  1.00 27.93           O  
ATOM   2303  N   THR C 125     -14.141  50.414   3.973  1.00 26.40           N  
ATOM   2304  CA  THR C 125     -12.806  50.547   4.453  1.00 25.64           C  
ATOM   2305  C   THR C 125     -11.826  49.653   3.792  1.00 24.49           C  
ATOM   2306  O   THR C 125     -10.721  50.081   3.478  1.00 24.81           O  
ATOM   2307  CB  THR C 125     -12.802  50.243   5.933  1.00 24.03           C  
ATOM   2308  OG1 THR C 125     -13.663  51.181   6.605  1.00 26.39           O  
ATOM   2309  CG2 THR C 125     -11.435  50.428   6.492  1.00 27.70           C  
ATOM   2310  N   ILE C 126     -12.163  48.375   3.636  1.00 24.20           N  
ATOM   2311  CA  ILE C 126     -11.272  47.465   2.971  1.00 24.30           C  
ATOM   2312  C   ILE C 126     -10.992  47.941   1.533  1.00 26.62           C  
ATOM   2313  O   ILE C 126      -9.848  47.920   1.052  1.00 25.32           O  
ATOM   2314  CB  ILE C 126     -11.882  46.036   2.965  1.00 24.25           C  
ATOM   2315  CG1 ILE C 126     -12.001  45.497   4.390  1.00 25.09           C  
ATOM   2316  CG2 ILE C 126     -10.948  45.115   2.178  1.00 24.65           C  
ATOM   2317  CD1 ILE C 126     -12.700  44.082   4.499  1.00 25.67           C  
ATOM   2318  N   LYS C 127     -12.059  48.351   0.844  1.00 27.97           N  
ATOM   2319  CA  LYS C 127     -11.944  48.826  -0.538  1.00 28.50           C  
ATOM   2320  C   LYS C 127     -11.058  50.067  -0.674  1.00 27.95           C  
ATOM   2321  O   LYS C 127     -10.169  50.121  -1.537  1.00 29.05           O  
ATOM   2322  CB  LYS C 127     -13.323  49.057  -1.113  1.00 30.49           C  
ATOM   2323  CG  LYS C 127     -13.361  49.569  -2.584  1.00 33.16           C  
ATOM   2324  CD  LYS C 127     -14.750  49.273  -3.247  1.00 39.38           C  
ATOM   2325  CE  LYS C 127     -15.515  50.512  -3.359  1.00 44.38           C  
ATOM   2326  NZ  LYS C 127     -14.833  51.515  -4.264  1.00 49.04           N  
ATOM   2327  N   ARG C 128     -11.217  51.006   0.241  1.00 29.03           N  
ATOM   2328  CA  ARG C 128     -10.387  52.187   0.242  1.00 31.15           C  
ATOM   2329  C   ARG C 128      -8.953  51.838   0.570  1.00 30.63           C  
ATOM   2330  O   ARG C 128      -8.023  52.394  -0.038  1.00 31.66           O  
ATOM   2331  CB  ARG C 128     -10.983  53.231   1.145  1.00 31.92           C  
ATOM   2332  CG  ARG C 128     -10.205  54.478   1.349  1.00 39.89           C  
ATOM   2333  CD  ARG C 128     -10.835  55.394   2.451  1.00 45.56           C  
ATOM   2334  NE  ARG C 128     -10.161  55.048   3.701  1.00 51.85           N  
ATOM   2335  CZ  ARG C 128     -10.750  54.535   4.786  1.00 54.45           C  
ATOM   2336  NH1 ARG C 128     -12.068  54.350   4.821  1.00 53.63           N  
ATOM   2337  NH2 ARG C 128      -9.993  54.194   5.834  1.00 55.39           N  
ATOM   2338  N   ARG C 129      -8.728  50.865   1.464  1.00 28.02           N  
ATOM   2339  CA  ARG C 129      -7.372  50.392   1.763  1.00 26.11           C  
ATOM   2340  C   ARG C 129      -6.721  49.723   0.541  1.00 28.86           C  
ATOM   2341  O   ARG C 129      -5.530  49.867   0.299  1.00 28.23           O  
ATOM   2342  CB  ARG C 129      -7.374  49.463   3.014  1.00 25.21           C  
ATOM   2343  CG  ARG C 129      -7.651  50.169   4.262  1.00 26.19           C  
ATOM   2344  CD  ARG C 129      -7.859  49.234   5.457  1.00 29.91           C  
ATOM   2345  NE  ARG C 129      -7.838  49.969   6.685  1.00 28.46           N  
ATOM   2346  CZ  ARG C 129      -7.732  49.381   7.875  1.00 29.61           C  
ATOM   2347  NH1 ARG C 129      -7.687  48.038   7.992  1.00 30.16           N  
ATOM   2348  NH2 ARG C 129      -7.719  50.109   8.969  1.00 30.61           N  
ATOM   2349  N   LEU C 130      -7.484  48.941  -0.214  1.00 28.77           N  
ATOM   2350  CA  LEU C 130      -6.918  48.308  -1.399  1.00 29.65           C  
ATOM   2351  C   LEU C 130      -6.531  49.402  -2.418  1.00 29.99           C  
ATOM   2352  O   LEU C 130      -5.456  49.325  -3.026  1.00 31.61           O  
ATOM   2353  CB  LEU C 130      -7.913  47.353  -2.048  1.00 27.90           C  
ATOM   2354  CG  LEU C 130      -8.116  46.082  -1.148  1.00 28.51           C  
ATOM   2355  CD1 LEU C 130      -9.387  45.386  -1.514  1.00 29.78           C  
ATOM   2356  CD2 LEU C 130      -6.959  45.151  -1.314  1.00 29.27           C  
ATOM   2357  N   GLU C 131      -7.390  50.391  -2.552  1.00 30.46           N  
ATOM   2358  CA  GLU C 131      -7.192  51.519  -3.515  1.00 32.76           C  
ATOM   2359  C   GLU C 131      -5.978  52.353  -3.200  1.00 33.69           C  
ATOM   2360  O   GLU C 131      -5.372  52.923  -4.119  1.00 34.56           O  
ATOM   2361  CB  GLU C 131      -8.422  52.416  -3.565  1.00 32.61           C  
ATOM   2362  CG  GLU C 131      -9.625  51.704  -4.199  1.00 35.81           C  
ATOM   2363  CD  GLU C 131     -10.980  52.400  -4.004  1.00 41.23           C  
ATOM   2364  OE1 GLU C 131     -11.082  53.375  -3.201  1.00 46.99           O  
ATOM   2365  OE2 GLU C 131     -11.961  51.953  -4.654  1.00 42.64           O  
ATOM   2366  N   ASN C 132      -5.601  52.432  -1.929  1.00 32.68           N  
ATOM   2367  CA  ASN C 132      -4.515  53.299  -1.493  1.00 33.50           C  
ATOM   2368  C   ASN C 132      -3.282  52.574  -1.076  1.00 31.49           C  
ATOM   2369  O   ASN C 132      -2.412  53.126  -0.472  1.00 30.86           O  
ATOM   2370  CB  ASN C 132      -5.039  54.172  -0.387  1.00 34.15           C  
ATOM   2371  CG  ASN C 132      -5.951  55.229  -0.942  1.00 41.32           C  
ATOM   2372  OD1 ASN C 132      -5.447  56.195  -1.517  1.00 48.49           O  
ATOM   2373  ND2 ASN C 132      -7.288  55.023  -0.881  1.00 41.44           N  
ATOM   2374  N   ASN C 133      -3.231  51.294  -1.399  1.00 30.98           N  
ATOM   2375  CA  ASN C 133      -2.083  50.449  -1.144  1.00 32.53           C  
ATOM   2376  C   ASN C 133      -1.747  50.346   0.315  1.00 29.81           C  
ATOM   2377  O   ASN C 133      -0.608  50.168   0.687  1.00 31.63           O  
ATOM   2378  CB  ASN C 133      -0.799  50.866  -1.917  1.00 34.36           C  
ATOM   2379  CG  ASN C 133      -1.023  51.105  -3.371  1.00 40.34           C  
ATOM   2380  OD1 ASN C 133      -1.549  50.238  -4.067  1.00 42.93           O  
ATOM   2381  ND2 ASN C 133      -0.564  52.319  -3.878  1.00 43.32           N  
ATOM   2382  N   TYR C 134      -2.739  50.426   1.157  1.00 28.41           N  
ATOM   2383  CA  TYR C 134      -2.544  50.240   2.584  1.00 28.11           C  
ATOM   2384  C   TYR C 134      -1.937  48.909   2.984  1.00 27.60           C  
ATOM   2385  O   TYR C 134      -1.058  48.860   3.902  1.00 28.08           O  
ATOM   2386  CB  TYR C 134      -3.874  50.482   3.309  1.00 26.53           C  
ATOM   2387  CG  TYR C 134      -3.926  50.150   4.768  1.00 28.09           C  
ATOM   2388  CD1 TYR C 134      -3.649  51.123   5.715  1.00 31.96           C  
ATOM   2389  CD2 TYR C 134      -4.279  48.884   5.217  1.00 28.17           C  
ATOM   2390  CE1 TYR C 134      -3.653  50.828   7.057  1.00 34.40           C  
ATOM   2391  CE2 TYR C 134      -4.278  48.566   6.619  1.00 30.80           C  
ATOM   2392  CZ  TYR C 134      -3.966  49.538   7.518  1.00 32.47           C  
ATOM   2393  OH  TYR C 134      -3.947  49.296   8.897  1.00 32.82           O  
ATOM   2394  N   TYR C 135      -2.430  47.808   2.389  1.00 29.48           N  
ATOM   2395  CA  TYR C 135      -2.101  46.489   2.961  1.00 31.38           C  
ATOM   2396  C   TYR C 135      -0.641  46.133   2.712  1.00 35.40           C  
ATOM   2397  O   TYR C 135      -0.137  46.278   1.595  1.00 35.36           O  
ATOM   2398  CB  TYR C 135      -3.013  45.387   2.409  1.00 29.37           C  
ATOM   2399  CG  TYR C 135      -4.393  45.532   2.933  1.00 26.58           C  
ATOM   2400  CD1 TYR C 135      -4.667  45.347   4.321  1.00 30.51           C  
ATOM   2401  CD2 TYR C 135      -5.433  45.851   2.113  1.00 27.03           C  
ATOM   2402  CE1 TYR C 135      -5.901  45.495   4.810  1.00 30.24           C  
ATOM   2403  CE2 TYR C 135      -6.733  45.981   2.600  1.00 25.12           C  
ATOM   2404  CZ  TYR C 135      -6.965  45.809   3.942  1.00 28.40           C  
ATOM   2405  OH  TYR C 135      -8.237  45.974   4.424  1.00 29.93           O  
ATOM   2406  N   TRP C 136       0.013  45.691   3.770  1.00 37.93           N  
ATOM   2407  CA  TRP C 136       1.388  45.216   3.727  1.00 41.53           C  
ATOM   2408  C   TRP C 136       1.458  43.886   3.040  1.00 42.25           C  
ATOM   2409  O   TRP C 136       2.462  43.600   2.404  1.00 42.74           O  
ATOM   2410  CB  TRP C 136       1.874  45.063   5.179  1.00 42.79           C  
ATOM   2411  CG  TRP C 136       3.301  44.848   5.405  1.00 44.13           C  
ATOM   2412  CD1 TRP C 136       3.901  43.706   5.896  1.00 43.30           C  
ATOM   2413  CD2 TRP C 136       4.332  45.806   5.223  1.00 39.38           C  
ATOM   2414  NE1 TRP C 136       5.253  43.904   6.012  1.00 44.72           N  
ATOM   2415  CE2 TRP C 136       5.554  45.181   5.612  1.00 41.93           C  
ATOM   2416  CE3 TRP C 136       4.357  47.159   4.798  1.00 34.85           C  
ATOM   2417  CZ2 TRP C 136       6.774  45.855   5.587  1.00 37.10           C  
ATOM   2418  CZ3 TRP C 136       5.559  47.798   4.772  1.00 32.69           C  
ATOM   2419  CH2 TRP C 136       6.730  47.179   5.173  1.00 34.18           C  
ATOM   2420  N   ALA C 137       0.396  43.053   3.206  1.00 41.99           N  
ATOM   2421  CA  ALA C 137       0.327  41.700   2.629  1.00 40.63           C  
ATOM   2422  C   ALA C 137      -1.126  41.216   2.394  1.00 38.27           C  
ATOM   2423  O   ALA C 137      -2.044  41.769   2.946  1.00 37.00           O  
ATOM   2424  CB  ALA C 137       1.030  40.715   3.594  1.00 41.62           C  
ATOM   2425  N   ALA C 138      -1.317  40.203   1.557  1.00 37.35           N  
ATOM   2426  CA  ALA C 138      -2.630  39.677   1.226  1.00 35.59           C  
ATOM   2427  C   ALA C 138      -3.373  39.169   2.499  1.00 35.09           C  
ATOM   2428  O   ALA C 138      -4.581  39.385   2.636  1.00 33.30           O  
ATOM   2429  CB  ALA C 138      -2.521  38.597   0.205  1.00 35.82           C  
ATOM   2430  N   SER C 139      -2.629  38.568   3.418  1.00 34.03           N  
ATOM   2431  CA  SER C 139      -3.153  37.993   4.648  1.00 34.09           C  
ATOM   2432  C   SER C 139      -3.795  39.048   5.462  1.00 33.38           C  
ATOM   2433  O   SER C 139      -4.772  38.816   6.113  1.00 31.67           O  
ATOM   2434  CB  SER C 139      -2.030  37.300   5.467  1.00 36.33           C  
ATOM   2435  OG  SER C 139      -1.021  38.175   5.913  1.00 37.07           O  
ATOM   2436  N   GLU C 140      -3.247  40.263   5.435  1.00 32.41           N  
ATOM   2437  CA  GLU C 140      -3.841  41.335   6.200  1.00 31.65           C  
ATOM   2438  C   GLU C 140      -5.208  41.723   5.683  1.00 28.55           C  
ATOM   2439  O   GLU C 140      -6.062  42.055   6.481  1.00 27.78           O  
ATOM   2440  CB  GLU C 140      -3.019  42.645   6.125  1.00 33.24           C  
ATOM   2441  CG  GLU C 140      -2.014  42.782   7.256  1.00 41.22           C  
ATOM   2442  CD  GLU C 140      -1.088  43.976   7.050  1.00 49.69           C  
ATOM   2443  OE1 GLU C 140      -1.605  45.144   6.799  1.00 49.86           O  
ATOM   2444  OE2 GLU C 140       0.144  43.692   7.115  1.00 55.51           O  
ATOM   2445  N   CYS C 141      -5.369  41.723   4.366  1.00 27.66           N  
ATOM   2446  CA  CYS C 141      -6.645  42.006   3.734  1.00 27.51           C  
ATOM   2447  C   CYS C 141      -7.720  40.918   4.102  1.00 26.30           C  
ATOM   2448  O   CYS C 141      -8.888  41.180   4.448  1.00 26.36           O  
ATOM   2449  CB  CYS C 141      -6.454  42.154   2.238  1.00 26.18           C  
ATOM   2450  SG  CYS C 141      -7.982  42.507   1.374  1.00 29.30           S  
HETATM 2451  N   MSE C 142      -7.295  39.692   4.027  1.00 26.91           N  
HETATM 2452  CA  MSE C 142      -8.139  38.584   4.265  1.00 25.49           C  
HETATM 2453  C   MSE C 142      -8.589  38.605   5.696  1.00 25.01           C  
HETATM 2454  O   MSE C 142      -9.740  38.277   6.013  1.00 24.17           O  
HETATM 2455  CB  MSE C 142      -7.353  37.319   3.925  1.00 27.54           C  
HETATM 2456  CG  MSE C 142      -7.097  37.138   2.513  1.00 30.69           C  
HETATM 2457 SE   MSE C 142      -5.688  35.762   2.174  1.00 53.45          SE  
HETATM 2458  CE  MSE C 142      -6.324  34.299   3.248  1.00 40.87           C  
ATOM   2459  N   GLN C 143      -7.696  38.999   6.613  1.00 25.17           N  
ATOM   2460  CA  GLN C 143      -8.063  39.088   8.030  1.00 26.00           C  
ATOM   2461  C   GLN C 143      -9.105  40.152   8.230  1.00 25.32           C  
ATOM   2462  O   GLN C 143      -9.997  40.020   9.059  1.00 21.80           O  
ATOM   2463  CB  GLN C 143      -6.784  39.395   8.799  1.00 30.49           C  
ATOM   2464  CG  GLN C 143      -6.709  38.895  10.093  1.00 38.74           C  
ATOM   2465  CD  GLN C 143      -6.827  37.325  10.166  1.00 39.97           C  
ATOM   2466  OE1 GLN C 143      -7.870  36.895  10.626  1.00 44.71           O  
ATOM   2467  NE2 GLN C 143      -5.749  36.512   9.745  1.00 40.58           N  
ATOM   2468  N   ASP C 144      -9.038  41.259   7.460  1.00 23.49           N  
ATOM   2469  CA  ASP C 144     -10.077  42.274   7.582  1.00 22.86           C  
ATOM   2470  C   ASP C 144     -11.452  41.793   7.084  1.00 20.98           C  
ATOM   2471  O   ASP C 144     -12.465  42.054   7.733  1.00 20.72           O  
ATOM   2472  CB  ASP C 144      -9.655  43.566   6.844  1.00 24.53           C  
ATOM   2473  CG  ASP C 144      -8.739  44.456   7.628  1.00 29.61           C  
ATOM   2474  OD1 ASP C 144      -8.462  44.220   8.862  1.00 29.12           O  
ATOM   2475  OD2 ASP C 144      -8.220  45.424   7.001  1.00 31.34           O  
ATOM   2476  N   PHE C 145     -11.518  41.119   5.968  1.00 21.05           N  
ATOM   2477  CA  PHE C 145     -12.747  40.485   5.536  1.00 22.15           C  
ATOM   2478  C   PHE C 145     -13.240  39.544   6.630  1.00 21.81           C  
ATOM   2479  O   PHE C 145     -14.395  39.562   6.968  1.00 22.83           O  
ATOM   2480  CB  PHE C 145     -12.588  39.630   4.291  1.00 21.58           C  
ATOM   2481  CG  PHE C 145     -12.642  40.385   2.998  1.00 26.40           C  
ATOM   2482  CD1 PHE C 145     -13.879  40.803   2.480  1.00 31.34           C  
ATOM   2483  CD2 PHE C 145     -11.483  40.737   2.343  1.00 29.20           C  
ATOM   2484  CE1 PHE C 145     -13.911  41.529   1.316  1.00 33.26           C  
ATOM   2485  CE2 PHE C 145     -11.541  41.459   1.132  1.00 32.58           C  
ATOM   2486  CZ  PHE C 145     -12.719  41.842   0.646  1.00 30.25           C  
ATOM   2487  N   ASN C 146     -12.343  38.742   7.151  1.00 23.88           N  
ATOM   2488  CA  ASN C 146     -12.733  37.784   8.207  1.00 26.40           C  
ATOM   2489  C   ASN C 146     -13.330  38.455   9.409  1.00 25.26           C  
ATOM   2490  O   ASN C 146     -14.329  38.022   9.928  1.00 23.54           O  
ATOM   2491  CB  ASN C 146     -11.549  36.946   8.657  1.00 27.66           C  
ATOM   2492  CG  ASN C 146     -11.965  35.876   9.704  1.00 32.95           C  
ATOM   2493  OD1 ASN C 146     -12.725  34.954   9.403  1.00 36.75           O  
ATOM   2494  ND2 ASN C 146     -11.446  35.998  10.856  1.00 31.71           N  
ATOM   2495  N   THR C 147     -12.724  39.563   9.823  1.00 24.03           N  
ATOM   2496  CA  THR C 147     -13.203  40.313  10.953  1.00 23.39           C  
ATOM   2497  C   THR C 147     -14.583  40.860  10.712  1.00 23.12           C  
ATOM   2498  O   THR C 147     -15.440  40.865  11.590  1.00 22.30           O  
ATOM   2499  CB  THR C 147     -12.175  41.440  11.275  1.00 23.85           C  
ATOM   2500  OG1 THR C 147     -10.954  40.830  11.735  1.00 27.24           O  
ATOM   2501  CG2 THR C 147     -12.691  42.320  12.398  1.00 24.70           C  
HETATM 2502  N   MSE C 148     -14.811  41.356   9.517  1.00 21.95           N  
HETATM 2503  CA  MSE C 148     -16.108  41.925   9.197  1.00 21.81           C  
HETATM 2504  C   MSE C 148     -17.222  40.874   9.299  1.00 21.76           C  
HETATM 2505  O   MSE C 148     -18.227  41.109   9.944  1.00 22.18           O  
HETATM 2506  CB  MSE C 148     -16.072  42.442   7.764  1.00 22.71           C  
HETATM 2507  CG  MSE C 148     -17.348  42.867   7.254  1.00 27.64           C  
HETATM 2508 SE   MSE C 148     -17.134  43.482   5.386  1.00 47.35          SE  
HETATM 2509  CE  MSE C 148     -17.114  41.667   4.437  1.00 37.85           C  
ATOM   2510  N   PHE C 149     -17.028  39.739   8.663  1.00 20.46           N  
ATOM   2511  CA  PHE C 149     -18.012  38.675   8.802  1.00 21.79           C  
ATOM   2512  C   PHE C 149     -18.213  38.176  10.238  1.00 20.87           C  
ATOM   2513  O   PHE C 149     -19.339  37.941  10.685  1.00 21.70           O  
ATOM   2514  CB  PHE C 149     -17.612  37.486   7.910  1.00 22.12           C  
ATOM   2515  CG  PHE C 149     -17.565  37.808   6.437  1.00 24.33           C  
ATOM   2516  CD1 PHE C 149     -18.631  38.406   5.807  1.00 29.97           C  
ATOM   2517  CD2 PHE C 149     -16.459  37.450   5.671  1.00 24.54           C  
ATOM   2518  CE1 PHE C 149     -18.577  38.712   4.458  1.00 33.60           C  
ATOM   2519  CE2 PHE C 149     -16.409  37.750   4.281  1.00 30.32           C  
ATOM   2520  CZ  PHE C 149     -17.475  38.363   3.699  1.00 30.65           C  
ATOM   2521  N   THR C 150     -17.102  37.921  10.916  1.00 21.37           N  
ATOM   2522  CA  THR C 150     -17.178  37.473  12.316  1.00 22.28           C  
ATOM   2523  C   THR C 150     -17.969  38.411  13.221  1.00 21.48           C  
ATOM   2524  O   THR C 150     -18.722  38.014  14.106  1.00 20.16           O  
ATOM   2525  CB  THR C 150     -15.748  37.284  12.816  1.00 22.88           C  
ATOM   2526  OG1 THR C 150     -15.175  36.292  12.010  1.00 26.94           O  
ATOM   2527  CG2 THR C 150     -15.749  36.749  14.238  1.00 25.28           C  
ATOM   2528  N   ASN C 151     -17.754  39.713  13.050  1.00 20.84           N  
ATOM   2529  CA  ASN C 151     -18.528  40.704  13.801  1.00 23.04           C  
ATOM   2530  C   ASN C 151     -20.041  40.502  13.616  1.00 21.78           C  
ATOM   2531  O   ASN C 151     -20.815  40.456  14.587  1.00 22.08           O  
ATOM   2532  CB  ASN C 151     -18.163  42.108  13.374  1.00 22.50           C  
ATOM   2533  CG  ASN C 151     -16.753  42.513  13.782  1.00 26.59           C  
ATOM   2534  OD1 ASN C 151     -16.114  41.863  14.596  1.00 24.30           O  
ATOM   2535  ND2 ASN C 151     -16.258  43.615  13.217  1.00 27.34           N  
ATOM   2536  N   CYS C 152     -20.435  40.243  12.381  1.00 22.84           N  
ATOM   2537  CA  CYS C 152     -21.841  40.031  12.083  1.00 24.20           C  
ATOM   2538  C   CYS C 152     -22.357  38.783  12.833  1.00 22.57           C  
ATOM   2539  O   CYS C 152     -23.364  38.841  13.478  1.00 21.78           O  
ATOM   2540  CB  CYS C 152     -21.952  39.866  10.595  1.00 26.01           C  
ATOM   2541  SG  CYS C 152     -23.573  39.510  10.038  1.00 31.63           S  
ATOM   2542  N   TYR C 153     -21.591  37.685  12.788  1.00 23.54           N  
ATOM   2543  CA  TYR C 153     -21.996  36.437  13.385  1.00 22.46           C  
ATOM   2544  C   TYR C 153     -22.082  36.586  14.820  1.00 24.89           C  
ATOM   2545  O   TYR C 153     -22.990  36.002  15.479  1.00 26.82           O  
ATOM   2546  CB  TYR C 153     -21.007  35.305  13.035  1.00 23.13           C  
ATOM   2547  CG  TYR C 153     -20.811  35.014  11.553  1.00 21.07           C  
ATOM   2548  CD1 TYR C 153     -21.882  35.029  10.693  1.00 23.62           C  
ATOM   2549  CD2 TYR C 153     -19.598  34.696  11.038  1.00 23.14           C  
ATOM   2550  CE1 TYR C 153     -21.722  34.791   9.360  1.00 24.92           C  
ATOM   2551  CE2 TYR C 153     -19.402  34.456   9.679  1.00 24.91           C  
ATOM   2552  CZ  TYR C 153     -20.500  34.518   8.832  1.00 28.10           C  
ATOM   2553  OH  TYR C 153     -20.406  34.250   7.471  1.00 28.64           O  
ATOM   2554  N   ILE C 154     -21.148  37.329  15.410  1.00 24.25           N  
ATOM   2555  CA  ILE C 154     -21.123  37.404  16.839  1.00 26.10           C  
ATOM   2556  C   ILE C 154     -22.286  38.275  17.361  1.00 27.27           C  
ATOM   2557  O   ILE C 154     -22.986  37.923  18.357  1.00 26.16           O  
ATOM   2558  CB  ILE C 154     -19.753  37.949  17.355  1.00 26.22           C  
ATOM   2559  CG1 ILE C 154     -18.670  36.906  17.126  1.00 24.24           C  
ATOM   2560  CG2 ILE C 154     -19.902  38.471  18.793  1.00 28.92           C  
ATOM   2561  CD1 ILE C 154     -17.256  37.352  17.433  1.00 23.33           C  
ATOM   2562  N   TYR C 155     -22.431  39.459  16.748  1.00 26.69           N  
ATOM   2563  CA  TYR C 155     -23.359  40.427  17.224  1.00 26.96           C  
ATOM   2564  C   TYR C 155     -24.840  40.060  16.931  1.00 28.37           C  
ATOM   2565  O   TYR C 155     -25.696  40.170  17.807  1.00 29.67           O  
ATOM   2566  CB  TYR C 155     -23.062  41.832  16.648  1.00 26.55           C  
ATOM   2567  CG  TYR C 155     -24.025  42.871  17.252  1.00 24.94           C  
ATOM   2568  CD1 TYR C 155     -23.905  43.260  18.563  1.00 26.89           C  
ATOM   2569  CD2 TYR C 155     -25.128  43.310  16.519  1.00 29.88           C  
ATOM   2570  CE1 TYR C 155     -24.831  44.179  19.126  1.00 27.20           C  
ATOM   2571  CE2 TYR C 155     -26.035  44.190  17.048  1.00 30.30           C  
ATOM   2572  CZ  TYR C 155     -25.880  44.593  18.371  1.00 28.54           C  
ATOM   2573  OH  TYR C 155     -26.799  45.445  18.937  1.00 31.24           O  
ATOM   2574  N   ASN C 156     -25.126  39.656  15.710  1.00 28.15           N  
ATOM   2575  CA  ASN C 156     -26.489  39.495  15.257  1.00 30.22           C  
ATOM   2576  C   ASN C 156     -27.198  38.253  15.794  1.00 31.54           C  
ATOM   2577  O   ASN C 156     -26.565  37.312  16.257  1.00 30.75           O  
ATOM   2578  CB  ASN C 156     -26.489  39.506  13.761  1.00 28.93           C  
ATOM   2579  CG  ASN C 156     -26.209  40.910  13.251  1.00 34.66           C  
ATOM   2580  OD1 ASN C 156     -27.100  41.736  13.262  1.00 45.18           O  
ATOM   2581  ND2 ASN C 156     -24.993  41.195  12.946  1.00 32.12           N  
ATOM   2582  N   LYS C 157     -28.508  38.292  15.758  1.00 32.33           N  
ATOM   2583  CA  LYS C 157     -29.275  37.101  16.165  1.00 33.45           C  
ATOM   2584  C   LYS C 157     -29.075  36.005  15.117  1.00 30.62           C  
ATOM   2585  O   LYS C 157     -28.982  36.300  13.977  1.00 29.11           O  
ATOM   2586  CB  LYS C 157     -30.754  37.447  16.321  1.00 33.62           C  
ATOM   2587  CG  LYS C 157     -31.095  37.763  17.819  1.00 41.89           C  
ATOM   2588  CD  LYS C 157     -29.975  38.643  18.573  1.00 50.17           C  
ATOM   2589  CE  LYS C 157     -28.789  37.843  19.249  1.00 51.29           C  
ATOM   2590  NZ  LYS C 157     -28.117  38.601  20.377  1.00 50.99           N  
ATOM   2591  N   PRO C 158     -29.040  34.739  15.505  1.00 32.44           N  
ATOM   2592  CA  PRO C 158     -28.840  33.674  14.500  1.00 32.52           C  
ATOM   2593  C   PRO C 158     -29.838  33.694  13.336  1.00 35.42           C  
ATOM   2594  O   PRO C 158     -29.460  33.367  12.216  1.00 35.63           O  
ATOM   2595  CB  PRO C 158     -28.941  32.375  15.325  1.00 33.11           C  
ATOM   2596  CG  PRO C 158     -28.554  32.756  16.693  1.00 30.21           C  
ATOM   2597  CD  PRO C 158     -29.057  34.217  16.880  1.00 32.08           C  
ATOM   2598  N   THR C 159     -31.070  34.151  13.582  1.00 37.45           N  
ATOM   2599  CA  THR C 159     -32.119  34.208  12.556  1.00 40.31           C  
ATOM   2600  C   THR C 159     -32.227  35.430  11.640  1.00 40.48           C  
ATOM   2601  O   THR C 159     -32.966  35.383  10.643  1.00 38.89           O  
ATOM   2602  CB  THR C 159     -33.512  34.047  13.261  1.00 41.77           C  
ATOM   2603  OG1 THR C 159     -33.607  34.962  14.364  1.00 44.29           O  
ATOM   2604  CG2 THR C 159     -33.585  32.695  13.939  1.00 44.49           C  
ATOM   2605  N   ASP C 160     -31.513  36.515  11.954  1.00 40.66           N  
ATOM   2606  CA  ASP C 160     -31.422  37.685  11.061  1.00 40.25           C  
ATOM   2607  C   ASP C 160     -30.942  37.235   9.730  1.00 39.91           C  
ATOM   2608  O   ASP C 160     -29.976  36.459   9.632  1.00 37.97           O  
ATOM   2609  CB  ASP C 160     -30.432  38.730  11.644  1.00 41.04           C  
ATOM   2610  CG  ASP C 160     -30.522  40.214  10.964  1.00 44.99           C  
ATOM   2611  OD1 ASP C 160     -31.007  40.491   9.818  1.00 42.46           O  
ATOM   2612  OD2 ASP C 160     -30.035  41.195  11.596  1.00 51.05           O  
ATOM   2613  N   ASP C 161     -31.603  37.728   8.679  1.00 38.69           N  
ATOM   2614  CA  ASP C 161     -31.158  37.402   7.362  1.00 39.92           C  
ATOM   2615  C   ASP C 161     -29.770  37.966   7.060  1.00 37.40           C  
ATOM   2616  O   ASP C 161     -29.174  37.532   6.087  1.00 37.04           O  
ATOM   2617  CB  ASP C 161     -32.112  37.918   6.274  1.00 41.62           C  
ATOM   2618  CG  ASP C 161     -33.534  37.288   6.356  1.00 47.95           C  
ATOM   2619  OD1 ASP C 161     -33.707  36.052   6.614  1.00 56.58           O  
ATOM   2620  OD2 ASP C 161     -34.554  37.992   6.166  1.00 57.08           O  
ATOM   2621  N   ILE C 162     -29.294  38.975   7.803  1.00 34.76           N  
ATOM   2622  CA  ILE C 162     -27.941  39.464   7.589  1.00 32.68           C  
ATOM   2623  C   ILE C 162     -26.931  38.363   7.795  1.00 31.16           C  
ATOM   2624  O   ILE C 162     -25.933  38.344   7.117  1.00 30.59           O  
ATOM   2625  CB  ILE C 162     -27.606  40.663   8.454  1.00 34.51           C  
ATOM   2626  CG1 ILE C 162     -26.236  41.205   8.129  1.00 32.44           C  
ATOM   2627  CG2 ILE C 162     -27.503  40.345   9.921  1.00 37.85           C  
ATOM   2628  CD1 ILE C 162     -25.891  42.419   9.002  1.00 39.38           C  
ATOM   2629  N   VAL C 163     -27.189  37.485   8.746  1.00 30.46           N  
ATOM   2630  CA  VAL C 163     -26.301  36.339   9.055  1.00 30.51           C  
ATOM   2631  C   VAL C 163     -26.158  35.471   7.847  1.00 31.47           C  
ATOM   2632  O   VAL C 163     -25.049  35.129   7.422  1.00 31.91           O  
ATOM   2633  CB  VAL C 163     -26.764  35.582  10.357  1.00 29.94           C  
ATOM   2634  CG1 VAL C 163     -26.042  34.229  10.542  1.00 30.94           C  
ATOM   2635  CG2 VAL C 163     -26.470  36.455  11.567  1.00 30.93           C  
ATOM   2636  N   LEU C 164     -27.295  35.180   7.198  1.00 32.74           N  
ATOM   2637  CA  LEU C 164     -27.303  34.391   5.980  1.00 32.48           C  
ATOM   2638  C   LEU C 164     -26.572  35.074   4.872  1.00 30.18           C  
ATOM   2639  O   LEU C 164     -25.868  34.458   4.156  1.00 27.76           O  
ATOM   2640  CB  LEU C 164     -28.725  34.115   5.501  1.00 34.50           C  
ATOM   2641  CG  LEU C 164     -29.134  32.674   5.630  1.00 43.46           C  
ATOM   2642  CD1 LEU C 164     -29.119  32.248   7.125  1.00 48.99           C  
ATOM   2643  CD2 LEU C 164     -30.529  32.428   4.973  1.00 50.26           C  
HETATM 2644  N   MSE C 165     -26.700  36.396   4.776  1.00 29.78           N  
HETATM 2645  CA  MSE C 165     -26.007  37.138   3.755  1.00 29.95           C  
HETATM 2646  C   MSE C 165     -24.518  37.084   3.939  1.00 28.63           C  
HETATM 2647  O   MSE C 165     -23.800  36.969   2.980  1.00 28.36           O  
HETATM 2648  CB  MSE C 165     -26.441  38.616   3.744  1.00 31.41           C  
HETATM 2649  CG  MSE C 165     -27.837  38.733   3.325  1.00 38.06           C  
HETATM 2650 SE   MSE C 165     -28.315  40.722   3.339  1.00 57.56          SE  
HETATM 2651  CE  MSE C 165     -29.776  40.617   4.627  1.00 51.23           C  
ATOM   2652  N   ALA C 166     -24.082  37.206   5.193  1.00 28.00           N  
ATOM   2653  CA  ALA C 166     -22.665  37.115   5.536  1.00 28.17           C  
ATOM   2654  C   ALA C 166     -22.118  35.720   5.168  1.00 27.43           C  
ATOM   2655  O   ALA C 166     -21.066  35.638   4.569  1.00 28.74           O  
ATOM   2656  CB  ALA C 166     -22.513  37.387   7.008  1.00 26.74           C  
ATOM   2657  N   GLN C 167     -22.869  34.652   5.486  1.00 27.81           N  
ATOM   2658  CA  GLN C 167     -22.477  33.291   5.112  1.00 28.94           C  
ATOM   2659  C   GLN C 167     -22.321  33.122   3.598  1.00 28.71           C  
ATOM   2660  O   GLN C 167     -21.332  32.575   3.085  1.00 28.07           O  
ATOM   2661  CB  GLN C 167     -23.488  32.300   5.653  1.00 29.53           C  
ATOM   2662  CG  GLN C 167     -23.376  32.094   7.057  1.00 32.37           C  
ATOM   2663  CD  GLN C 167     -24.409  31.092   7.669  1.00 40.61           C  
ATOM   2664  OE1 GLN C 167     -24.028  30.009   8.101  1.00 43.03           O  
ATOM   2665  NE2 GLN C 167     -25.651  31.492   7.787  1.00 41.80           N  
ATOM   2666  N   THR C 168     -23.289  33.639   2.842  1.00 28.09           N  
ATOM   2667  CA  THR C 168     -23.174  33.626   1.414  1.00 28.90           C  
ATOM   2668  C   THR C 168     -21.966  34.334   0.886  1.00 27.92           C  
ATOM   2669  O   THR C 168     -21.235  33.813   0.068  1.00 29.04           O  
ATOM   2670  CB  THR C 168     -24.446  34.219   0.784  1.00 30.45           C  
ATOM   2671  OG1 THR C 168     -25.561  33.459   1.210  1.00 32.10           O  
ATOM   2672  CG2 THR C 168     -24.374  34.174  -0.713  1.00 33.41           C  
ATOM   2673  N   LEU C 169     -21.750  35.555   1.328  1.00 27.91           N  
ATOM   2674  CA  LEU C 169     -20.586  36.285   0.906  1.00 28.35           C  
ATOM   2675  C   LEU C 169     -19.260  35.681   1.284  1.00 27.94           C  
ATOM   2676  O   LEU C 169     -18.322  35.674   0.466  1.00 27.95           O  
ATOM   2677  CB  LEU C 169     -20.640  37.719   1.465  1.00 28.89           C  
ATOM   2678  CG  LEU C 169     -21.777  38.604   0.930  1.00 28.92           C  
ATOM   2679  CD1 LEU C 169     -21.800  39.827   1.759  1.00 30.06           C  
ATOM   2680  CD2 LEU C 169     -21.505  38.924  -0.561  1.00 32.16           C  
ATOM   2681  N   GLU C 170     -19.202  35.167   2.504  1.00 27.84           N  
ATOM   2682  CA  GLU C 170     -17.984  34.546   2.999  1.00 27.44           C  
ATOM   2683  C   GLU C 170     -17.600  33.304   2.251  1.00 26.06           C  
ATOM   2684  O   GLU C 170     -16.391  33.099   1.998  1.00 24.88           O  
ATOM   2685  CB  GLU C 170     -18.088  34.273   4.494  1.00 28.91           C  
ATOM   2686  CG  GLU C 170     -16.732  33.947   5.139  1.00 31.24           C  
ATOM   2687  CD  GLU C 170     -16.874  33.838   6.690  1.00 39.39           C  
ATOM   2688  OE1 GLU C 170     -17.977  33.401   7.131  1.00 44.55           O  
ATOM   2689  OE2 GLU C 170     -15.888  34.108   7.441  1.00 45.29           O  
ATOM   2690  N   LYS C 171     -18.583  32.525   1.820  1.00 26.84           N  
ATOM   2691  CA  LYS C 171     -18.324  31.364   1.003  1.00 28.23           C  
ATOM   2692  C   LYS C 171     -17.764  31.751  -0.348  1.00 29.97           C  
ATOM   2693  O   LYS C 171     -16.846  31.127  -0.876  1.00 28.94           O  
ATOM   2694  CB  LYS C 171     -19.613  30.550   0.866  1.00 28.66           C  
ATOM   2695  CG  LYS C 171     -19.917  29.770   2.132  1.00 34.92           C  
ATOM   2696  CD  LYS C 171     -21.233  28.980   2.092  1.00 40.41           C  
ATOM   2697  CE  LYS C 171     -21.228  27.813   3.139  1.00 44.87           C  
ATOM   2698  NZ  LYS C 171     -21.654  28.443   4.368  1.00 47.33           N  
ATOM   2699  N   ILE C 172     -18.280  32.824  -0.932  1.00 29.93           N  
ATOM   2700  CA  ILE C 172     -17.689  33.304  -2.201  1.00 31.39           C  
ATOM   2701  C   ILE C 172     -16.274  33.825  -1.980  1.00 30.41           C  
ATOM   2702  O   ILE C 172     -15.356  33.564  -2.760  1.00 31.21           O  
ATOM   2703  CB  ILE C 172     -18.555  34.408  -2.862  1.00 32.09           C  
ATOM   2704  CG1 ILE C 172     -19.922  33.855  -3.270  1.00 35.55           C  
ATOM   2705  CG2 ILE C 172     -17.721  35.073  -4.017  1.00 33.87           C  
ATOM   2706  CD1 ILE C 172     -21.063  34.912  -3.521  1.00 37.90           C  
ATOM   2707  N   PHE C 173     -16.082  34.558  -0.891  1.00 28.80           N  
ATOM   2708  CA  PHE C 173     -14.747  35.067  -0.600  1.00 27.84           C  
ATOM   2709  C   PHE C 173     -13.699  33.934  -0.560  1.00 26.99           C  
ATOM   2710  O   PHE C 173     -12.663  33.993  -1.167  1.00 28.49           O  
ATOM   2711  CB  PHE C 173     -14.847  35.872   0.722  1.00 26.79           C  
ATOM   2712  CG  PHE C 173     -13.558  36.178   1.350  1.00 29.55           C  
ATOM   2713  CD1 PHE C 173     -12.762  37.154   0.838  1.00 34.13           C  
ATOM   2714  CD2 PHE C 173     -13.133  35.453   2.439  1.00 34.31           C  
ATOM   2715  CE1 PHE C 173     -11.494  37.448   1.409  1.00 32.85           C  
ATOM   2716  CE2 PHE C 173     -11.892  35.730   3.020  1.00 39.47           C  
ATOM   2717  CZ  PHE C 173     -11.080  36.741   2.491  1.00 32.64           C  
ATOM   2718  N   LEU C 174     -14.007  32.879   0.174  1.00 27.34           N  
ATOM   2719  CA  LEU C 174     -13.098  31.760   0.323  1.00 29.47           C  
ATOM   2720  C   LEU C 174     -12.878  31.002  -0.957  1.00 29.67           C  
ATOM   2721  O   LEU C 174     -11.762  30.594  -1.232  1.00 31.20           O  
ATOM   2722  CB  LEU C 174     -13.597  30.815   1.400  1.00 29.76           C  
ATOM   2723  CG  LEU C 174     -13.472  31.375   2.824  1.00 31.00           C  
ATOM   2724  CD1 LEU C 174     -14.103  30.375   3.837  1.00 35.16           C  
ATOM   2725  CD2 LEU C 174     -12.036  31.611   3.206  1.00 34.22           C  
ATOM   2726  N   GLN C 175     -13.940  30.772  -1.712  1.00 31.15           N  
ATOM   2727  CA  GLN C 175     -13.809  30.205  -3.070  1.00 34.91           C  
ATOM   2728  C   GLN C 175     -12.814  31.011  -3.919  1.00 34.77           C  
ATOM   2729  O   GLN C 175     -11.901  30.466  -4.518  1.00 35.57           O  
ATOM   2730  CB  GLN C 175     -15.157  30.148  -3.761  1.00 36.37           C  
ATOM   2731  CG  GLN C 175     -15.262  29.154  -4.886  1.00 44.29           C  
ATOM   2732  CD  GLN C 175     -15.119  27.691  -4.452  1.00 50.38           C  
ATOM   2733  OE1 GLN C 175     -14.542  26.886  -5.200  1.00 57.61           O  
ATOM   2734  NE2 GLN C 175     -15.585  27.358  -3.235  1.00 54.38           N  
ATOM   2735  N   LYS C 176     -12.902  32.317  -3.895  1.00 35.31           N  
ATOM   2736  CA  LYS C 176     -11.985  33.104  -4.693  1.00 35.33           C  
ATOM   2737  C   LYS C 176     -10.605  33.077  -4.143  1.00 35.65           C  
ATOM   2738  O   LYS C 176      -9.632  33.050  -4.878  1.00 35.55           O  
ATOM   2739  CB  LYS C 176     -12.456  34.536  -4.770  1.00 36.47           C  
ATOM   2740  CG  LYS C 176     -13.810  34.714  -5.357  1.00 38.84           C  
ATOM   2741  CD  LYS C 176     -13.901  34.019  -6.667  1.00 44.14           C  
ATOM   2742  CE  LYS C 176     -14.908  34.748  -7.657  1.00 46.26           C  
ATOM   2743  NZ  LYS C 176     -15.414  35.984  -7.089  1.00 50.22           N  
ATOM   2744  N   VAL C 177     -10.495  33.123  -2.827  1.00 35.81           N  
ATOM   2745  CA  VAL C 177      -9.192  33.055  -2.174  1.00 35.97           C  
ATOM   2746  C   VAL C 177      -8.460  31.783  -2.574  1.00 36.26           C  
ATOM   2747  O   VAL C 177      -7.254  31.798  -2.720  1.00 35.64           O  
ATOM   2748  CB  VAL C 177      -9.318  33.069  -0.608  1.00 36.64           C  
ATOM   2749  CG1 VAL C 177      -8.055  32.589   0.020  1.00 39.41           C  
ATOM   2750  CG2 VAL C 177      -9.616  34.441  -0.128  1.00 37.70           C  
ATOM   2751  N   ALA C 178      -9.191  30.676  -2.731  1.00 37.63           N  
ATOM   2752  CA  ALA C 178      -8.583  29.416  -3.086  1.00 38.77           C  
ATOM   2753  C   ALA C 178      -7.913  29.479  -4.478  1.00 40.75           C  
ATOM   2754  O   ALA C 178      -6.921  28.744  -4.726  1.00 40.93           O  
ATOM   2755  CB  ALA C 178      -9.589  28.286  -3.056  1.00 38.34           C  
ATOM   2756  N   SER C 179      -8.462  30.285  -5.381  1.00 42.32           N  
ATOM   2757  CA  SER C 179      -7.799  30.515  -6.697  1.00 44.99           C  
ATOM   2758  C   SER C 179      -6.890  31.745  -6.807  1.00 46.85           C  
ATOM   2759  O   SER C 179      -6.654  32.208  -7.890  1.00 47.09           O  
ATOM   2760  CB  SER C 179      -8.834  30.663  -7.806  1.00 44.92           C  
ATOM   2761  OG  SER C 179      -9.762  29.591  -7.807  1.00 47.34           O  
HETATM 2762  N   MSE C 180      -6.408  32.280  -5.705  1.00 48.76           N  
HETATM 2763  CA  MSE C 180      -5.520  33.410  -5.705  1.00 51.61           C  
HETATM 2764  C   MSE C 180      -4.136  33.002  -6.264  1.00 54.19           C  
HETATM 2765  O   MSE C 180      -3.744  31.859  -6.103  1.00 52.46           O  
HETATM 2766  CB  MSE C 180      -5.403  33.893  -4.274  1.00 52.60           C  
HETATM 2767  CG  MSE C 180      -4.651  35.143  -4.052  1.00 54.48           C  
HETATM 2768 SE   MSE C 180      -4.920  35.792  -2.216  1.00 64.53          SE  
HETATM 2769  CE  MSE C 180      -4.427  34.112  -1.155  1.00 56.63           C  
ATOM   2770  N   PRO C 181      -3.397  33.914  -6.911  1.00 57.06           N  
ATOM   2771  CA  PRO C 181      -2.172  33.535  -7.645  1.00 59.72           C  
ATOM   2772  C   PRO C 181      -1.021  33.010  -6.791  1.00 62.11           C  
ATOM   2773  O   PRO C 181      -0.224  32.172  -7.308  1.00 63.49           O  
ATOM   2774  CB  PRO C 181      -1.723  34.853  -8.298  1.00 59.86           C  
ATOM   2775  CG  PRO C 181      -2.955  35.731  -8.267  1.00 58.90           C  
ATOM   2776  CD  PRO C 181      -3.637  35.363  -7.006  1.00 57.38           C  
ATOM   2777  N   GLN C 182      -0.907  33.486  -5.548  1.00 63.79           N  
ATOM   2778  CA  GLN C 182       0.258  33.149  -4.707  1.00 65.46           C  
ATOM   2779  C   GLN C 182       1.617  33.511  -5.322  1.00 65.48           C  
ATOM   2780  O   GLN C 182       2.261  32.667  -5.989  1.00 66.43           O  
ATOM   2781  CB  GLN C 182       0.274  31.666  -4.305  1.00 65.96           C  
ATOM   2782  CG  GLN C 182      -0.859  31.272  -3.345  1.00 67.37           C  
ATOM   2783  CD  GLN C 182      -0.608  31.621  -1.910  1.00 69.24           C  
ATOM   2784  OE1 GLN C 182       0.544  31.872  -1.519  1.00 68.44           O  
ATOM   2785  NE2 GLN C 182      -1.685  31.610  -1.097  1.00 69.48           N  
TER    2786      GLN C 182                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
