
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  131 ( 2074),  selected  131 , name 2dkw_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2dkw_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      S       1           #
LGA    G     4_A      M       2           #
LGA    S     5_A      Q       3          1.497
LGA    S     6_A      E       4          0.733
LGA    G     7_A      E       5          1.662
LGA    N     8_A      D       6          1.368
LGA    T     9_A      T       7          1.003
LGA    L    10_A      F       8          0.974
LGA    R    11_A      R       9          1.041
LGA    E    12_A      E      10          0.903
LGA    L    13_A      L      11          0.378
LGA    R    14_A      R      12          0.687
LGA    L    15_A      I      13          1.076
LGA    F    16_A      F      14          0.627
LGA    L    17_A      L      15          0.589
LGA    R    18_A      R      16          1.375
LGA    D    19_A      N      17          1.155
LGA    V    20_A      V      18          0.831
LGA    T    21_A      T      19          1.244
LGA    K    22_A      H      20          1.609
LGA    R    23_A      R      21          1.502
LGA    L    24_A      L      22          0.817
LGA    A    25_A      A      23          1.348
LGA    T    26_A      I      24          2.524
LGA    D    27_A      D      25          2.473
LGA    K    28_A      K      26          2.158
LGA    R    29_A      R      27          1.834
LGA    F    30_A      F      28          1.329
LGA    N    31_A      R      29          0.867
LGA    I    32_A      V      30          1.150
LGA    F    33_A      F      31          1.285
LGA    S    34_A      T      32          1.476
LGA    K    35_A      K      33          2.737
LGA    P    36_A      P      34          4.042
LGA    V    37_A      V      35          5.038
LGA    S    38_A      D      36           #
LGA    D    39_A      P      37           #
LGA    -       -      D      38           -
LGA    -       -      E      39           -
LGA    -       -      V      40           -
LGA    Y    40_A      P      41          2.161
LGA    -       -      D      42           -
LGA    L    41_A      Y      43          3.701
LGA    E    42_A      V      44          2.513
LGA    V    43_A      T      45          1.974
LGA    I    44_A      V      46          3.408
LGA    -       -      I      47           -
LGA    K    45_A      K      48          0.894
LGA    E    46_A      Q      49          1.172
LGA    P    47_A      P      50          0.664
LGA    M    48_A      M      51          0.941
LGA    D    49_A      D      52          0.920
LGA    L    50_A      L      53          0.997
LGA    S    51_A      S      54          1.229
LGA    T    52_A      S      55          0.825
LGA    V    53_A      V      56          0.818
LGA    I    54_A      I      57          0.590
LGA    T    55_A      S      58          0.551
LGA    K    56_A      K      59          0.600
LGA    I    57_A      I      60          0.314
LGA    D    58_A      D      61          0.312
LGA    K    59_A      L      62          0.412
LGA    H    60_A      H      63          0.937
LGA    N    61_A      K      64          0.975
LGA    Y    62_A      Y      65          0.674
LGA    L    63_A      L      66          0.746
LGA    T    64_A      T      67          0.639
LGA    A    65_A      V      68          0.744
LGA    K    66_A      K      69          0.498
LGA    D    67_A      D      70          0.537
LGA    F    68_A      Y      71          0.539
LGA    L    69_A      L      72          0.585
LGA    K    70_A      R      73          1.079
LGA    D    71_A      D      74          0.946
LGA    I    72_A      I      75          0.423
LGA    D    73_A      D      76          0.580
LGA    L    74_A      L      77          0.782
LGA    I    75_A      I      78          0.748
LGA    C    76_A      C      79          0.533
LGA    S    77_A      S      80          0.607
LGA    N    78_A      N      81          0.603
LGA    A    79_A      A      82          0.489
LGA    L    80_A      L      83          1.475
LGA    E    81_A      E      84          1.200
LGA    Y    82_A      Y      85          1.359
LGA    N    83_A      N      86          2.029
LGA    P    84_A      P      87           #
LGA    D    85_A      D      88          3.435
LGA    K    86_A      R      89           #
LGA    D    87_A      D      90          4.001
LGA    P    88_A      P      91          3.542
LGA    G    89_A      G      92          2.412
LGA    D    90_A      D      93          2.195
LGA    K    91_A      R      94          1.870
LGA    I    92_A      L      95          1.482
LGA    I    93_A      I      96          1.492
LGA    R    94_A      R      97          1.463
LGA    H    95_A      H      98          1.306
LGA    R    96_A      R      99          1.439
LGA    A    97_A      A     100          1.241
LGA    C    98_A      C     101          1.094
LGA    T    99_A      A     102          1.014
LGA    L   100_A      L     103          1.153
LGA    K   101_A      R     104          1.022
LGA    D   102_A      D     105          0.900
LGA    T   103_A      T     106          0.565
LGA    A   104_A      A     107          0.070
LGA    H   105_A      Y     108          0.426
LGA    A   106_A      A     109          0.563
LGA    I   107_A      I     110          0.684
LGA    I   108_A      I     111          0.724
LGA    A   109_A      K     112          1.326
LGA    A   110_A      E     113          1.143
LGA    E   111_A      E     114          0.907
LGA    L   112_A      L     115          0.959
LGA    D   113_A      D     116          0.850
LGA    P   114_A      E     117          1.305
LGA    E   115_A      D     118          0.789
LGA    F   116_A      F     119          0.614
LGA    N   117_A      E     120          0.743
LGA    K   118_A      Q     121          0.440
LGA    L   119_A      L     122          0.303
LGA    C   120_A      C     123          0.701
LGA    E   121_A      E     124          0.836
LGA    E   122_A      E     125          0.852
LGA    I   123_A      I     126          0.726
LGA    K   124_A      Q     127          0.576
LGA    E   125_A      E     128          2.736
LGA    S   126_A      S     129          3.379
LGA    G   127_A      R     130          4.622
LGA    P   128_A      -       -           -
LGA    S   129_A      -       -           -
LGA    S   130_A      -       -           -
LGA    G   131_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  131  130    5.0    119    1.59    68.07     86.853     7.062

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.000067 * X  +   0.980430 * Y  +  -0.196870 * Z  +  -9.437484
  Y_new =   0.995659 * X  +   0.018258 * Y  +   0.091266 * Z  +  44.743343
  Z_new =   0.093074 * X  +  -0.196021 * Y  +  -0.976173 * Z  +   2.901176 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.943422    0.198170  [ DEG:  -168.6457     11.3543 ]
  Theta =  -0.093209   -3.048384  [ DEG:    -5.3405   -174.6595 ]
  Phi   =   1.570729   -1.570864  [ DEG:    89.9961    -90.0039 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dkw_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dkw_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  131  130   5.0  119   1.59   68.07  86.853
REMARK  ---------------------------------------------------------- 
MOLECULE 2dkw_A
HEADER    GENE REGULATION                         14-APR-06   2DKW              
TITLE     SOLUTION STRUCTURE OF THE BROMODOMAIN OF HUMAN PROTEIN                
TITLE    2 KIAA1240                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN KIAA1240;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN;                                               
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KIAA1240;                                                      
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050627-27;                               
SOURCE   8 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    BROMODOMAIN-LIKE, FIVE-HELIX, STRUCTURAL GENOMICS, NPPSFA,            
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    R.SANO,F.HAYASHI,C.KUROSAKI,M.YOSHIDA,S.YOKOYAMA,RIKEN                
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   14-OCT-06 2DKW    0                                                
JRNL        AUTH   R.SANO,F.HAYASHI,C.KUROSAKI,M.YOSHIDA,S.YOKOYAMA             
JRNL        TITL   SOLUTION STRUCTURE OF THE BROMODOMAIN OF HUMAN               
JRNL        TITL 2 PROTEIN KIAA1240                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DKW A    8   125  UNP    Q9ULI0   K1240_HUMAN    238    355             
SEQRES   1 A  131  GLY SER SER GLY SER SER GLY ASN THR LEU ARG GLU LEU          
SEQRES   2 A  131  ARG LEU PHE LEU ARG ASP VAL THR LYS ARG LEU ALA THR          
SEQRES   3 A  131  ASP LYS ARG PHE ASN ILE PHE SER LYS PRO VAL SER ASP          
SEQRES   4 A  131  TYR LEU GLU VAL ILE LYS GLU PRO MET ASP LEU SER THR          
SEQRES   5 A  131  VAL ILE THR LYS ILE ASP LYS HIS ASN TYR LEU THR ALA          
SEQRES   6 A  131  LYS ASP PHE LEU LYS ASP ILE ASP LEU ILE CYS SER ASN          
SEQRES   7 A  131  ALA LEU GLU TYR ASN PRO ASP LYS ASP PRO GLY ASP LYS          
SEQRES   8 A  131  ILE ILE ARG HIS ARG ALA CYS THR LEU LYS ASP THR ALA          
SEQRES   9 A  131  HIS ALA ILE ILE ALA ALA GLU LEU ASP PRO GLU PHE ASN          
SEQRES  10 A  131  LYS LEU CYS GLU GLU ILE LYS GLU SER GLY PRO SER SER          
SEQRES  11 A  131  GLY                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      21.815  41.381 -10.597  1.00  0.00           N  
ATOM      2  CA  GLY A   1      20.676  40.887 -11.349  1.00  0.00           C  
ATOM      3  C   GLY A   1      19.690  40.133 -10.478  1.00  0.00           C  
ATOM      4  O   GLY A   1      19.731  38.904 -10.404  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      20.169  41.723 -11.806  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      21.031  40.225 -12.125  1.00  0.00           H  
ATOM      7  H1  GLY A   1      22.724  41.132 -10.869  1.00  0.00           H  
ATOM      8  N   SER A   2      18.804  40.868  -9.815  1.00  0.00           N  
ATOM      9  CA  SER A   2      17.807  40.262  -8.942  1.00  0.00           C  
ATOM     10  C   SER A   2      16.571  39.844  -9.733  1.00  0.00           C  
ATOM     11  O   SER A   2      15.851  40.686 -10.269  1.00  0.00           O  
ATOM     12  CB  SER A   2      17.410  41.237  -7.831  1.00  0.00           C  
ATOM     13  OG  SER A   2      18.474  41.429  -6.916  1.00  0.00           O  
ATOM     14  H   SER A   2      18.822  41.844  -9.916  1.00  0.00           H  
ATOM     15  HA  SER A   2      18.248  39.383  -8.495  1.00  0.00           H  
ATOM     16  HB2 SER A   2      17.151  42.190  -8.268  1.00  0.00           H  
ATOM     17  HB3 SER A   2      16.557  40.843  -7.297  1.00  0.00           H  
ATOM     18  HG  SER A   2      19.267  41.680  -7.395  1.00  0.00           H  
ATOM     19  N   SER A   3      16.334  38.539  -9.802  1.00  0.00           N  
ATOM     20  CA  SER A   3      15.188  38.008 -10.532  1.00  0.00           C  
ATOM     21  C   SER A   3      13.930  38.815 -10.229  1.00  0.00           C  
ATOM     22  O   SER A   3      13.389  38.753  -9.125  1.00  0.00           O  
ATOM     23  CB  SER A   3      14.964  36.538 -10.170  1.00  0.00           C  
ATOM     24  OG  SER A   3      14.091  35.913 -11.095  1.00  0.00           O  
ATOM     25  H   SER A   3      16.945  37.918  -9.354  1.00  0.00           H  
ATOM     26  HA  SER A   3      15.404  38.081 -11.587  1.00  0.00           H  
ATOM     27  HB2 SER A   3      15.911  36.019 -10.180  1.00  0.00           H  
ATOM     28  HB3 SER A   3      14.529  36.475  -9.184  1.00  0.00           H  
ATOM     29  HG  SER A   3      14.374  36.116 -11.990  1.00  0.00           H  
ATOM     30  N   GLY A   4      13.468  39.574 -11.219  1.00  0.00           N  
ATOM     31  CA  GLY A   4      12.277  40.384 -11.040  1.00  0.00           C  
ATOM     32  C   GLY A   4      12.447  41.433  -9.960  1.00  0.00           C  
ATOM     33  O   GLY A   4      13.530  41.992  -9.793  1.00  0.00           O  
ATOM     34  H   GLY A   4      13.941  39.584 -12.078  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      12.047  40.876 -11.973  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      11.453  39.738 -10.772  1.00  0.00           H  
ATOM     37  N   SER A   5      11.373  41.701  -9.223  1.00  0.00           N  
ATOM     38  CA  SER A   5      11.406  42.695  -8.157  1.00  0.00           C  
ATOM     39  C   SER A   5      10.208  42.533  -7.226  1.00  0.00           C  
ATOM     40  O   SER A   5       9.186  41.959  -7.605  1.00  0.00           O  
ATOM     41  CB  SER A   5      11.420  44.106  -8.747  1.00  0.00           C  
ATOM     42  OG  SER A   5      10.175  44.422  -9.344  1.00  0.00           O  
ATOM     43  H   SER A   5      10.537  41.221  -9.405  1.00  0.00           H  
ATOM     44  HA  SER A   5      12.311  42.542  -7.589  1.00  0.00           H  
ATOM     45  HB2 SER A   5      11.621  44.819  -7.961  1.00  0.00           H  
ATOM     46  HB3 SER A   5      12.194  44.171  -9.498  1.00  0.00           H  
ATOM     47  HG  SER A   5       9.745  45.118  -8.841  1.00  0.00           H  
ATOM     48  N   SER A   6      10.342  43.043  -6.006  1.00  0.00           N  
ATOM     49  CA  SER A   6       9.273  42.951  -5.019  1.00  0.00           C  
ATOM     50  C   SER A   6       8.320  44.137  -5.138  1.00  0.00           C  
ATOM     51  O   SER A   6       7.654  44.513  -4.173  1.00  0.00           O  
ATOM     52  CB  SER A   6       9.858  42.893  -3.607  1.00  0.00           C  
ATOM     53  OG  SER A   6      10.505  44.109  -3.271  1.00  0.00           O  
ATOM     54  H   SER A   6      11.180  43.488  -5.764  1.00  0.00           H  
ATOM     55  HA  SER A   6       8.723  42.042  -5.209  1.00  0.00           H  
ATOM     56  HB2 SER A   6       9.064  42.715  -2.897  1.00  0.00           H  
ATOM     57  HB3 SER A   6      10.578  42.089  -3.550  1.00  0.00           H  
ATOM     58  HG  SER A   6       9.848  44.763  -3.022  1.00  0.00           H  
ATOM     59  N   GLY A   7       8.262  44.723  -6.330  1.00  0.00           N  
ATOM     60  CA  GLY A   7       7.389  45.861  -6.555  1.00  0.00           C  
ATOM     61  C   GLY A   7       6.194  45.512  -7.420  1.00  0.00           C  
ATOM     62  O   GLY A   7       5.063  45.880  -7.105  1.00  0.00           O  
ATOM     63  H   GLY A   7       8.816  44.381  -7.062  1.00  0.00           H  
ATOM     64  HA2 GLY A   7       7.036  46.224  -5.601  1.00  0.00           H  
ATOM     65  HA3 GLY A   7       7.954  46.644  -7.040  1.00  0.00           H  
ATOM     66  N   ASN A   8       6.445  44.803  -8.515  1.00  0.00           N  
ATOM     67  CA  ASN A   8       5.381  44.407  -9.431  1.00  0.00           C  
ATOM     68  C   ASN A   8       4.437  43.409  -8.768  1.00  0.00           C  
ATOM     69  O   ASN A   8       3.222  43.469  -8.954  1.00  0.00           O  
ATOM     70  CB  ASN A   8       5.975  43.797 -10.703  1.00  0.00           C  
ATOM     71  CG  ASN A   8       6.845  44.779 -11.463  1.00  0.00           C  
ATOM     72  OD1 ASN A   8       6.350  45.752 -12.034  1.00  0.00           O  
ATOM     73  ND2 ASN A   8       8.149  44.529 -11.475  1.00  0.00           N  
ATOM     74  H   ASN A   8       7.368  44.539  -8.714  1.00  0.00           H  
ATOM     75  HA  ASN A   8       4.824  45.293  -9.693  1.00  0.00           H  
ATOM     76  HB2 ASN A   8       6.579  42.943 -10.436  1.00  0.00           H  
ATOM     77  HB3 ASN A   8       5.173  43.478 -11.350  1.00  0.00           H  
ATOM     78 HD21 ASN A   8       8.473  43.736 -10.999  1.00  0.00           H  
ATOM     79 HD22 ASN A   8       8.734  45.148 -11.958  1.00  0.00           H  
ATOM     80  N   THR A   9       5.005  42.491  -7.991  1.00  0.00           N  
ATOM     81  CA  THR A   9       4.215  41.480  -7.300  1.00  0.00           C  
ATOM     82  C   THR A   9       3.127  42.120  -6.447  1.00  0.00           C  
ATOM     83  O   THR A   9       1.981  41.668  -6.440  1.00  0.00           O  
ATOM     84  CB  THR A   9       5.099  40.592  -6.405  1.00  0.00           C  
ATOM     85  OG1 THR A   9       6.166  40.028  -7.175  1.00  0.00           O  
ATOM     86  CG2 THR A   9       4.280  39.478  -5.771  1.00  0.00           C  
ATOM     87  H   THR A   9       5.978  42.495  -7.883  1.00  0.00           H  
ATOM     88  HA  THR A   9       3.750  40.852  -8.048  1.00  0.00           H  
ATOM     89  HB  THR A   9       5.517  41.204  -5.618  1.00  0.00           H  
ATOM     90  HG1 THR A   9       6.839  40.695  -7.326  1.00  0.00           H  
ATOM     91 HG21 THR A   9       4.609  38.524  -6.157  1.00  0.00           H  
ATOM     92 HG22 THR A   9       3.236  39.619  -6.007  1.00  0.00           H  
ATOM     93 HG23 THR A   9       4.413  39.498  -4.699  1.00  0.00           H  
ATOM     94  N   LEU A  10       3.491  43.177  -5.729  1.00  0.00           N  
ATOM     95  CA  LEU A  10       2.544  43.881  -4.871  1.00  0.00           C  
ATOM     96  C   LEU A  10       1.434  44.522  -5.696  1.00  0.00           C  
ATOM     97  O   LEU A  10       0.251  44.262  -5.473  1.00  0.00           O  
ATOM     98  CB  LEU A  10       3.268  44.950  -4.050  1.00  0.00           C  
ATOM     99  CG  LEU A  10       3.841  44.493  -2.708  1.00  0.00           C  
ATOM    100  CD1 LEU A  10       2.735  44.354  -1.675  1.00  0.00           C  
ATOM    101  CD2 LEU A  10       4.594  43.181  -2.869  1.00  0.00           C  
ATOM    102  H   LEU A  10       4.418  43.492  -5.775  1.00  0.00           H  
ATOM    103  HA  LEU A  10       2.106  43.159  -4.198  1.00  0.00           H  
ATOM    104  HB2 LEU A  10       4.084  45.330  -4.647  1.00  0.00           H  
ATOM    105  HB3 LEU A  10       2.565  45.749  -3.856  1.00  0.00           H  
ATOM    106  HG  LEU A  10       4.540  45.238  -2.350  1.00  0.00           H  
ATOM    107 HD11 LEU A  10       2.133  43.489  -1.907  1.00  0.00           H  
ATOM    108 HD12 LEU A  10       2.115  45.238  -1.689  1.00  0.00           H  
ATOM    109 HD13 LEU A  10       3.172  44.237  -0.693  1.00  0.00           H  
ATOM    110 HD21 LEU A  10       4.077  42.556  -3.583  1.00  0.00           H  
ATOM    111 HD22 LEU A  10       4.641  42.674  -1.916  1.00  0.00           H  
ATOM    112 HD23 LEU A  10       5.594  43.379  -3.222  1.00  0.00           H  
ATOM    113  N   ARG A  11       1.822  45.359  -6.652  1.00  0.00           N  
ATOM    114  CA  ARG A  11       0.859  46.037  -7.512  1.00  0.00           C  
ATOM    115  C   ARG A  11      -0.322  45.124  -7.830  1.00  0.00           C  
ATOM    116  O   ARG A  11      -1.462  45.423  -7.475  1.00  0.00           O  
ATOM    117  CB  ARG A  11       1.532  46.490  -8.809  1.00  0.00           C  
ATOM    118  CG  ARG A  11       0.677  47.432  -9.642  1.00  0.00           C  
ATOM    119  CD  ARG A  11       1.326  47.732 -10.984  1.00  0.00           C  
ATOM    120  NE  ARG A  11       1.535  46.522 -11.774  1.00  0.00           N  
ATOM    121  CZ  ARG A  11       0.560  45.882 -12.409  1.00  0.00           C  
ATOM    122  NH1 ARG A  11      -0.685  46.333 -12.347  1.00  0.00           N  
ATOM    123  NH2 ARG A  11       0.829  44.786 -13.109  1.00  0.00           N  
ATOM    124  H   ARG A  11       2.779  45.527  -6.781  1.00  0.00           H  
ATOM    125  HA  ARG A  11       0.495  46.905  -6.983  1.00  0.00           H  
ATOM    126  HB2 ARG A  11       2.453  46.997  -8.565  1.00  0.00           H  
ATOM    127  HB3 ARG A  11       1.756  45.619  -9.407  1.00  0.00           H  
ATOM    128  HG2 ARG A  11      -0.285  46.972  -9.814  1.00  0.00           H  
ATOM    129  HG3 ARG A  11       0.544  48.356  -9.100  1.00  0.00           H  
ATOM    130  HD2 ARG A  11       0.685  48.404 -11.535  1.00  0.00           H  
ATOM    131  HD3 ARG A  11       2.280  48.207 -10.809  1.00  0.00           H  
ATOM    132  HE  ARG A  11       2.448  46.171 -11.833  1.00  0.00           H  
ATOM    133 HH11 ARG A  11      -0.890  47.159 -11.822  1.00  0.00           H  
ATOM    134 HH12 ARG A  11      -1.417  45.849 -12.827  1.00  0.00           H  
ATOM    135 HH21 ARG A  11       1.767  44.443 -13.158  1.00  0.00           H  
ATOM    136 HH22 ARG A  11       0.095  44.304 -13.585  1.00  0.00           H  
ATOM    137  N   GLU A  12      -0.039  44.013  -8.501  1.00  0.00           N  
ATOM    138  CA  GLU A  12      -1.078  43.058  -8.869  1.00  0.00           C  
ATOM    139  C   GLU A  12      -1.933  42.693  -7.659  1.00  0.00           C  
ATOM    140  O   GLU A  12      -3.146  42.506  -7.774  1.00  0.00           O  
ATOM    141  CB  GLU A  12      -0.454  41.795  -9.466  1.00  0.00           C  
ATOM    142  CG  GLU A  12       0.267  42.036 -10.781  1.00  0.00           C  
ATOM    143  CD  GLU A  12       0.279  40.810 -11.673  1.00  0.00           C  
ATOM    144  OE1 GLU A  12       1.213  39.992 -11.545  1.00  0.00           O  
ATOM    145  OE2 GLU A  12      -0.647  40.668 -12.499  1.00  0.00           O  
ATOM    146  H   GLU A  12       0.889  43.831  -8.757  1.00  0.00           H  
ATOM    147  HA  GLU A  12      -1.709  43.523  -9.612  1.00  0.00           H  
ATOM    148  HB2 GLU A  12       0.255  41.389  -8.760  1.00  0.00           H  
ATOM    149  HB3 GLU A  12      -1.235  41.069  -9.636  1.00  0.00           H  
ATOM    150  HG2 GLU A  12      -0.229  42.839 -11.307  1.00  0.00           H  
ATOM    151  HG3 GLU A  12       1.287  42.321 -10.571  1.00  0.00           H  
ATOM    152  N   LEU A  13      -1.293  42.591  -6.499  1.00  0.00           N  
ATOM    153  CA  LEU A  13      -1.994  42.247  -5.266  1.00  0.00           C  
ATOM    154  C   LEU A  13      -2.914  43.382  -4.828  1.00  0.00           C  
ATOM    155  O   LEU A  13      -4.122  43.193  -4.678  1.00  0.00           O  
ATOM    156  CB  LEU A  13      -0.989  41.933  -4.157  1.00  0.00           C  
ATOM    157  CG  LEU A  13      -1.575  41.367  -2.861  1.00  0.00           C  
ATOM    158  CD1 LEU A  13      -1.861  39.881  -3.010  1.00  0.00           C  
ATOM    159  CD2 LEU A  13      -0.629  41.616  -1.696  1.00  0.00           C  
ATOM    160  H   LEU A  13      -0.328  42.751  -6.469  1.00  0.00           H  
ATOM    161  HA  LEU A  13      -2.592  41.369  -5.459  1.00  0.00           H  
ATOM    162  HB2 LEU A  13      -0.285  41.213  -4.542  1.00  0.00           H  
ATOM    163  HB3 LEU A  13      -0.469  42.849  -3.913  1.00  0.00           H  
ATOM    164  HG  LEU A  13      -2.509  41.867  -2.648  1.00  0.00           H  
ATOM    165 HD11 LEU A  13      -1.342  39.336  -2.236  1.00  0.00           H  
ATOM    166 HD12 LEU A  13      -1.521  39.544  -3.978  1.00  0.00           H  
ATOM    167 HD13 LEU A  13      -2.924  39.709  -2.922  1.00  0.00           H  
ATOM    168 HD21 LEU A  13      -0.822  42.593  -1.279  1.00  0.00           H  
ATOM    169 HD22 LEU A  13       0.393  41.569  -2.044  1.00  0.00           H  
ATOM    170 HD23 LEU A  13      -0.787  40.864  -0.937  1.00  0.00           H  
ATOM    171  N   ARG A  14      -2.337  44.562  -4.627  1.00  0.00           N  
ATOM    172  CA  ARG A  14      -3.105  45.728  -4.207  1.00  0.00           C  
ATOM    173  C   ARG A  14      -4.379  45.866  -5.035  1.00  0.00           C  
ATOM    174  O   ARG A  14      -5.469  46.049  -4.492  1.00  0.00           O  
ATOM    175  CB  ARG A  14      -2.260  46.996  -4.337  1.00  0.00           C  
ATOM    176  CG  ARG A  14      -2.861  48.203  -3.636  1.00  0.00           C  
ATOM    177  CD  ARG A  14      -1.985  49.436  -3.799  1.00  0.00           C  
ATOM    178  NE  ARG A  14      -0.715  49.300  -3.092  1.00  0.00           N  
ATOM    179  CZ  ARG A  14       0.355  48.705  -3.609  1.00  0.00           C  
ATOM    180  NH1 ARG A  14       0.306  48.192  -4.830  1.00  0.00           N  
ATOM    181  NH2 ARG A  14       1.475  48.622  -2.904  1.00  0.00           N  
ATOM    182  H   ARG A  14      -1.370  44.651  -4.762  1.00  0.00           H  
ATOM    183  HA  ARG A  14      -3.377  45.591  -3.171  1.00  0.00           H  
ATOM    184  HB2 ARG A  14      -1.284  46.810  -3.912  1.00  0.00           H  
ATOM    185  HB3 ARG A  14      -2.147  47.233  -5.384  1.00  0.00           H  
ATOM    186  HG2 ARG A  14      -3.833  48.408  -4.063  1.00  0.00           H  
ATOM    187  HG3 ARG A  14      -2.966  47.983  -2.585  1.00  0.00           H  
ATOM    188  HD2 ARG A  14      -1.788  49.584  -4.850  1.00  0.00           H  
ATOM    189  HD3 ARG A  14      -2.515  50.291  -3.408  1.00  0.00           H  
ATOM    190  HE  ARG A  14      -0.657  49.672  -2.187  1.00  0.00           H  
ATOM    191 HH11 ARG A  14      -0.537  48.254  -5.365  1.00  0.00           H  
ATOM    192 HH12 ARG A  14       1.113  47.745  -5.218  1.00  0.00           H  
ATOM    193 HH21 ARG A  14       1.516  49.007  -1.981  1.00  0.00           H  
ATOM    194 HH22 ARG A  14       2.279  48.173  -3.293  1.00  0.00           H  
ATOM    195  N   LEU A  15      -4.235  45.777  -6.353  1.00  0.00           N  
ATOM    196  CA  LEU A  15      -5.373  45.893  -7.257  1.00  0.00           C  
ATOM    197  C   LEU A  15      -6.233  44.634  -7.213  1.00  0.00           C  
ATOM    198  O   LEU A  15      -7.463  44.709  -7.181  1.00  0.00           O  
ATOM    199  CB  LEU A  15      -4.891  46.145  -8.687  1.00  0.00           C  
ATOM    200  CG  LEU A  15      -4.131  47.451  -8.919  1.00  0.00           C  
ATOM    201  CD1 LEU A  15      -3.207  47.325 -10.119  1.00  0.00           C  
ATOM    202  CD2 LEU A  15      -5.104  48.606  -9.112  1.00  0.00           C  
ATOM    203  H   LEU A  15      -3.341  45.631  -6.727  1.00  0.00           H  
ATOM    204  HA  LEU A  15      -5.969  46.733  -6.933  1.00  0.00           H  
ATOM    205  HB2 LEU A  15      -4.239  45.330  -8.964  1.00  0.00           H  
ATOM    206  HB3 LEU A  15      -5.758  46.146  -9.332  1.00  0.00           H  
ATOM    207  HG  LEU A  15      -3.523  47.666  -8.050  1.00  0.00           H  
ATOM    208 HD11 LEU A  15      -3.770  47.485 -11.026  1.00  0.00           H  
ATOM    209 HD12 LEU A  15      -2.771  46.336 -10.136  1.00  0.00           H  
ATOM    210 HD13 LEU A  15      -2.421  48.062 -10.048  1.00  0.00           H  
ATOM    211 HD21 LEU A  15      -4.569  49.542  -9.037  1.00  0.00           H  
ATOM    212 HD22 LEU A  15      -5.866  48.566  -8.347  1.00  0.00           H  
ATOM    213 HD23 LEU A  15      -5.563  48.530 -10.085  1.00  0.00           H  
ATOM    214  N   PHE A  16      -5.581  43.477  -7.209  1.00  0.00           N  
ATOM    215  CA  PHE A  16      -6.286  42.201  -7.166  1.00  0.00           C  
ATOM    216  C   PHE A  16      -7.315  42.185  -6.040  1.00  0.00           C  
ATOM    217  O   PHE A  16      -8.521  42.227  -6.286  1.00  0.00           O  
ATOM    218  CB  PHE A  16      -5.293  41.052  -6.980  1.00  0.00           C  
ATOM    219  CG  PHE A  16      -5.941  39.759  -6.573  1.00  0.00           C  
ATOM    220  CD1 PHE A  16      -7.043  39.275  -7.260  1.00  0.00           C  
ATOM    221  CD2 PHE A  16      -5.449  39.029  -5.503  1.00  0.00           C  
ATOM    222  CE1 PHE A  16      -7.641  38.086  -6.886  1.00  0.00           C  
ATOM    223  CE2 PHE A  16      -6.043  37.840  -5.125  1.00  0.00           C  
ATOM    224  CZ  PHE A  16      -7.141  37.368  -5.819  1.00  0.00           C  
ATOM    225  H   PHE A  16      -4.601  43.481  -7.235  1.00  0.00           H  
ATOM    226  HA  PHE A  16      -6.797  42.075  -8.107  1.00  0.00           H  
ATOM    227  HB2 PHE A  16      -4.772  40.882  -7.910  1.00  0.00           H  
ATOM    228  HB3 PHE A  16      -4.579  41.322  -6.217  1.00  0.00           H  
ATOM    229  HD1 PHE A  16      -7.434  39.835  -8.096  1.00  0.00           H  
ATOM    230  HD2 PHE A  16      -4.590  39.399  -4.960  1.00  0.00           H  
ATOM    231  HE1 PHE A  16      -8.499  37.719  -7.431  1.00  0.00           H  
ATOM    232  HE2 PHE A  16      -5.650  37.281  -4.290  1.00  0.00           H  
ATOM    233  HZ  PHE A  16      -7.608  36.439  -5.525  1.00  0.00           H  
ATOM    234  N   LEU A  17      -6.831  42.124  -4.805  1.00  0.00           N  
ATOM    235  CA  LEU A  17      -7.707  42.103  -3.639  1.00  0.00           C  
ATOM    236  C   LEU A  17      -8.816  43.142  -3.772  1.00  0.00           C  
ATOM    237  O   LEU A  17     -10.000  42.804  -3.784  1.00  0.00           O  
ATOM    238  CB  LEU A  17      -6.902  42.360  -2.365  1.00  0.00           C  
ATOM    239  CG  LEU A  17      -5.636  41.520  -2.190  1.00  0.00           C  
ATOM    240  CD1 LEU A  17      -4.902  41.918  -0.920  1.00  0.00           C  
ATOM    241  CD2 LEU A  17      -5.979  40.037  -2.168  1.00  0.00           C  
ATOM    242  H   LEU A  17      -5.861  42.093  -4.672  1.00  0.00           H  
ATOM    243  HA  LEU A  17      -8.156  41.122  -3.580  1.00  0.00           H  
ATOM    244  HB2 LEU A  17      -6.611  43.399  -2.361  1.00  0.00           H  
ATOM    245  HB3 LEU A  17      -7.548  42.166  -1.520  1.00  0.00           H  
ATOM    246  HG  LEU A  17      -4.975  41.699  -3.027  1.00  0.00           H  
ATOM    247 HD11 LEU A  17      -4.392  41.059  -0.514  1.00  0.00           H  
ATOM    248 HD12 LEU A  17      -5.612  42.291  -0.196  1.00  0.00           H  
ATOM    249 HD13 LEU A  17      -4.183  42.692  -1.146  1.00  0.00           H  
ATOM    250 HD21 LEU A  17      -6.992  39.908  -1.817  1.00  0.00           H  
ATOM    251 HD22 LEU A  17      -5.300  39.521  -1.505  1.00  0.00           H  
ATOM    252 HD23 LEU A  17      -5.889  39.632  -3.164  1.00  0.00           H  
ATOM    253  N   ARG A  18      -8.423  44.408  -3.873  1.00  0.00           N  
ATOM    254  CA  ARG A  18      -9.383  45.498  -4.007  1.00  0.00           C  
ATOM    255  C   ARG A  18     -10.481  45.135  -5.003  1.00  0.00           C  
ATOM    256  O   ARG A  18     -11.633  45.543  -4.848  1.00  0.00           O  
ATOM    257  CB  ARG A  18      -8.676  46.777  -4.455  1.00  0.00           C  
ATOM    258  CG  ARG A  18      -9.354  48.050  -3.973  1.00  0.00           C  
ATOM    259  CD  ARG A  18      -8.975  49.244  -4.835  1.00  0.00           C  
ATOM    260  NE  ARG A  18      -7.575  49.620  -4.663  1.00  0.00           N  
ATOM    261  CZ  ARG A  18      -7.106  50.838  -4.913  1.00  0.00           C  
ATOM    262  NH1 ARG A  18      -7.920  51.790  -5.345  1.00  0.00           N  
ATOM    263  NH2 ARG A  18      -5.818  51.104  -4.732  1.00  0.00           N  
ATOM    264  H   ARG A  18      -7.465  44.615  -3.858  1.00  0.00           H  
ATOM    265  HA  ARG A  18      -9.833  45.665  -3.039  1.00  0.00           H  
ATOM    266  HB2 ARG A  18      -7.665  46.768  -4.075  1.00  0.00           H  
ATOM    267  HB3 ARG A  18      -8.646  46.798  -5.534  1.00  0.00           H  
ATOM    268  HG2 ARG A  18     -10.425  47.914  -4.017  1.00  0.00           H  
ATOM    269  HG3 ARG A  18      -9.054  48.242  -2.955  1.00  0.00           H  
ATOM    270  HD2 ARG A  18      -9.145  48.991  -5.872  1.00  0.00           H  
ATOM    271  HD3 ARG A  18      -9.600  50.080  -4.562  1.00  0.00           H  
ATOM    272  HE  ARG A  18      -6.956  48.932  -4.344  1.00  0.00           H  
ATOM    273 HH11 ARG A  18      -8.891  51.593  -5.481  1.00  0.00           H  
ATOM    274 HH12 ARG A  18      -7.564  52.707  -5.532  1.00  0.00           H  
ATOM    275 HH21 ARG A  18      -5.201  50.389  -4.406  1.00  0.00           H  
ATOM    276 HH22 ARG A  18      -5.466  52.021  -4.921  1.00  0.00           H  
ATOM    277  N   ASP A  19     -10.117  44.367  -6.024  1.00  0.00           N  
ATOM    278  CA  ASP A  19     -11.072  43.950  -7.045  1.00  0.00           C  
ATOM    279  C   ASP A  19     -12.081  42.959  -6.473  1.00  0.00           C  
ATOM    280  O   ASP A  19     -13.265  43.001  -6.805  1.00  0.00           O  
ATOM    281  CB  ASP A  19     -10.339  43.321  -8.231  1.00  0.00           C  
ATOM    282  CG  ASP A  19     -11.150  43.383  -9.511  1.00  0.00           C  
ATOM    283  OD1 ASP A  19     -11.465  44.504  -9.960  1.00  0.00           O  
ATOM    284  OD2 ASP A  19     -11.471  42.309 -10.063  1.00  0.00           O  
ATOM    285  H   ASP A  19      -9.185  44.073  -6.092  1.00  0.00           H  
ATOM    286  HA  ASP A  19     -11.600  44.827  -7.383  1.00  0.00           H  
ATOM    287  HB2 ASP A  19      -9.409  43.847  -8.391  1.00  0.00           H  
ATOM    288  HB3 ASP A  19     -10.129  42.285  -8.009  1.00  0.00           H  
ATOM    289  N   VAL A  20     -11.604  42.067  -5.609  1.00  0.00           N  
ATOM    290  CA  VAL A  20     -12.465  41.066  -4.991  1.00  0.00           C  
ATOM    291  C   VAL A  20     -13.474  41.714  -4.050  1.00  0.00           C  
ATOM    292  O   VAL A  20     -14.684  41.615  -4.255  1.00  0.00           O  
ATOM    293  CB  VAL A  20     -11.642  40.026  -4.206  1.00  0.00           C  
ATOM    294  CG1 VAL A  20     -12.547  39.193  -3.312  1.00  0.00           C  
ATOM    295  CG2 VAL A  20     -10.856  39.139  -5.159  1.00  0.00           C  
ATOM    296  H   VAL A  20     -10.651  42.083  -5.384  1.00  0.00           H  
ATOM    297  HA  VAL A  20     -12.998  40.552  -5.777  1.00  0.00           H  
ATOM    298  HB  VAL A  20     -10.939  40.554  -3.577  1.00  0.00           H  
ATOM    299 HG11 VAL A  20     -13.353  38.781  -3.901  1.00  0.00           H  
ATOM    300 HG12 VAL A  20     -11.976  38.390  -2.869  1.00  0.00           H  
ATOM    301 HG13 VAL A  20     -12.956  39.818  -2.532  1.00  0.00           H  
ATOM    302 HG21 VAL A  20     -11.500  38.818  -5.964  1.00  0.00           H  
ATOM    303 HG22 VAL A  20     -10.023  39.695  -5.565  1.00  0.00           H  
ATOM    304 HG23 VAL A  20     -10.486  38.276  -4.626  1.00  0.00           H  
ATOM    305  N   THR A  21     -12.968  42.380  -3.016  1.00  0.00           N  
ATOM    306  CA  THR A  21     -13.825  43.045  -2.043  1.00  0.00           C  
ATOM    307  C   THR A  21     -14.810  43.984  -2.728  1.00  0.00           C  
ATOM    308  O   THR A  21     -15.985  44.043  -2.364  1.00  0.00           O  
ATOM    309  CB  THR A  21     -12.997  43.846  -1.019  1.00  0.00           C  
ATOM    310  OG1 THR A  21     -12.159  42.961  -0.268  1.00  0.00           O  
ATOM    311  CG2 THR A  21     -13.905  44.618  -0.075  1.00  0.00           C  
ATOM    312  H   THR A  21     -11.996  42.423  -2.906  1.00  0.00           H  
ATOM    313  HA  THR A  21     -14.378  42.285  -1.511  1.00  0.00           H  
ATOM    314  HB  THR A  21     -12.376  44.550  -1.555  1.00  0.00           H  
ATOM    315  HG1 THR A  21     -12.680  42.528   0.413  1.00  0.00           H  
ATOM    316 HG21 THR A  21     -14.930  44.319  -0.235  1.00  0.00           H  
ATOM    317 HG22 THR A  21     -13.806  45.676  -0.265  1.00  0.00           H  
ATOM    318 HG23 THR A  21     -13.624  44.408   0.946  1.00  0.00           H  
ATOM    319  N   LYS A  22     -14.325  44.718  -3.725  1.00  0.00           N  
ATOM    320  CA  LYS A  22     -15.165  45.654  -4.464  1.00  0.00           C  
ATOM    321  C   LYS A  22     -16.398  44.953  -5.025  1.00  0.00           C  
ATOM    322  O   LYS A  22     -17.528  45.280  -4.660  1.00  0.00           O  
ATOM    323  CB  LYS A  22     -14.367  46.295  -5.602  1.00  0.00           C  
ATOM    324  CG  LYS A  22     -15.168  47.296  -6.417  1.00  0.00           C  
ATOM    325  CD  LYS A  22     -14.314  47.952  -7.489  1.00  0.00           C  
ATOM    326  CE  LYS A  22     -14.171  47.058  -8.711  1.00  0.00           C  
ATOM    327  NZ  LYS A  22     -13.157  47.582  -9.667  1.00  0.00           N  
ATOM    328  H   LYS A  22     -13.380  44.628  -3.969  1.00  0.00           H  
ATOM    329  HA  LYS A  22     -15.483  46.426  -3.780  1.00  0.00           H  
ATOM    330  HB2 LYS A  22     -13.512  46.805  -5.184  1.00  0.00           H  
ATOM    331  HB3 LYS A  22     -14.021  45.516  -6.266  1.00  0.00           H  
ATOM    332  HG2 LYS A  22     -15.992  46.784  -6.892  1.00  0.00           H  
ATOM    333  HG3 LYS A  22     -15.550  48.061  -5.756  1.00  0.00           H  
ATOM    334  HD2 LYS A  22     -14.778  48.880  -7.790  1.00  0.00           H  
ATOM    335  HD3 LYS A  22     -13.333  48.153  -7.084  1.00  0.00           H  
ATOM    336  HE2 LYS A  22     -13.871  46.072  -8.388  1.00  0.00           H  
ATOM    337  HE3 LYS A  22     -15.126  46.997  -9.212  1.00  0.00           H  
ATOM    338  HZ1 LYS A  22     -12.755  48.472  -9.308  1.00  0.00           H  
ATOM    339  HZ2 LYS A  22     -13.596  47.762 -10.592  1.00  0.00           H  
ATOM    340  HZ3 LYS A  22     -12.389  46.892  -9.788  1.00  0.00           H  
ATOM    341  N   ARG A  23     -16.173  43.990  -5.912  1.00  0.00           N  
ATOM    342  CA  ARG A  23     -17.267  43.243  -6.522  1.00  0.00           C  
ATOM    343  C   ARG A  23     -18.323  42.878  -5.483  1.00  0.00           C  
ATOM    344  O   ARG A  23     -19.517  43.092  -5.694  1.00  0.00           O  
ATOM    345  CB  ARG A  23     -16.736  41.974  -7.191  1.00  0.00           C  
ATOM    346  CG  ARG A  23     -17.717  41.343  -8.165  1.00  0.00           C  
ATOM    347  CD  ARG A  23     -17.104  40.146  -8.876  1.00  0.00           C  
ATOM    348  NE  ARG A  23     -15.975  40.529  -9.719  1.00  0.00           N  
ATOM    349  CZ  ARG A  23     -15.128  39.658 -10.253  1.00  0.00           C  
ATOM    350  NH1 ARG A  23     -15.280  38.359 -10.033  1.00  0.00           N  
ATOM    351  NH2 ARG A  23     -14.124  40.084 -11.010  1.00  0.00           N  
ATOM    352  H   ARG A  23     -15.250  43.775  -6.162  1.00  0.00           H  
ATOM    353  HA  ARG A  23     -17.720  43.873  -7.272  1.00  0.00           H  
ATOM    354  HB2 ARG A  23     -15.833  42.217  -7.732  1.00  0.00           H  
ATOM    355  HB3 ARG A  23     -16.503  41.249  -6.426  1.00  0.00           H  
ATOM    356  HG2 ARG A  23     -18.590  41.015  -7.620  1.00  0.00           H  
ATOM    357  HG3 ARG A  23     -18.004  42.080  -8.901  1.00  0.00           H  
ATOM    358  HD2 ARG A  23     -16.763  39.440  -8.135  1.00  0.00           H  
ATOM    359  HD3 ARG A  23     -17.861  39.684  -9.491  1.00  0.00           H  
ATOM    360  HE  ARG A  23     -15.844  41.485  -9.895  1.00  0.00           H  
ATOM    361 HH11 ARG A  23     -16.036  38.035  -9.463  1.00  0.00           H  
ATOM    362 HH12 ARG A  23     -14.640  37.705 -10.437  1.00  0.00           H  
ATOM    363 HH21 ARG A  23     -14.007  41.062 -11.179  1.00  0.00           H  
ATOM    364 HH22 ARG A  23     -13.486  39.428 -11.411  1.00  0.00           H  
ATOM    365  N   LEU A  24     -17.875  42.327  -4.359  1.00  0.00           N  
ATOM    366  CA  LEU A  24     -18.781  41.932  -3.287  1.00  0.00           C  
ATOM    367  C   LEU A  24     -19.573  43.130  -2.774  1.00  0.00           C  
ATOM    368  O   LEU A  24     -20.780  43.229  -2.991  1.00  0.00           O  
ATOM    369  CB  LEU A  24     -17.997  41.295  -2.139  1.00  0.00           C  
ATOM    370  CG  LEU A  24     -17.078  40.133  -2.517  1.00  0.00           C  
ATOM    371  CD1 LEU A  24     -16.142  39.795  -1.366  1.00  0.00           C  
ATOM    372  CD2 LEU A  24     -17.897  38.914  -2.916  1.00  0.00           C  
ATOM    373  H   LEU A  24     -16.912  42.182  -4.248  1.00  0.00           H  
ATOM    374  HA  LEU A  24     -19.472  41.205  -3.687  1.00  0.00           H  
ATOM    375  HB2 LEU A  24     -17.389  42.064  -1.687  1.00  0.00           H  
ATOM    376  HB3 LEU A  24     -18.710  40.931  -1.413  1.00  0.00           H  
ATOM    377  HG  LEU A  24     -16.472  40.422  -3.365  1.00  0.00           H  
ATOM    378 HD11 LEU A  24     -16.677  39.878  -0.432  1.00  0.00           H  
ATOM    379 HD12 LEU A  24     -15.309  40.483  -1.366  1.00  0.00           H  
ATOM    380 HD13 LEU A  24     -15.776  38.787  -1.485  1.00  0.00           H  
ATOM    381 HD21 LEU A  24     -17.359  38.016  -2.649  1.00  0.00           H  
ATOM    382 HD22 LEU A  24     -18.067  38.927  -3.983  1.00  0.00           H  
ATOM    383 HD23 LEU A  24     -18.845  38.932  -2.400  1.00  0.00           H  
ATOM    384  N   ALA A  25     -18.884  44.041  -2.093  1.00  0.00           N  
ATOM    385  CA  ALA A  25     -19.522  45.235  -1.553  1.00  0.00           C  
ATOM    386  C   ALA A  25     -20.455  45.870  -2.578  1.00  0.00           C  
ATOM    387  O   ALA A  25     -21.649  46.040  -2.326  1.00  0.00           O  
ATOM    388  CB  ALA A  25     -18.469  46.237  -1.102  1.00  0.00           C  
ATOM    389  H   ALA A  25     -17.924  43.907  -1.952  1.00  0.00           H  
ATOM    390  HA  ALA A  25     -20.099  44.943  -0.687  1.00  0.00           H  
ATOM    391  HB1 ALA A  25     -17.963  46.640  -1.967  1.00  0.00           H  
ATOM    392  HB2 ALA A  25     -18.946  47.039  -0.558  1.00  0.00           H  
ATOM    393  HB3 ALA A  25     -17.753  45.743  -0.463  1.00  0.00           H  
ATOM    394  N   THR A  26     -19.904  46.221  -3.736  1.00  0.00           N  
ATOM    395  CA  THR A  26     -20.687  46.839  -4.798  1.00  0.00           C  
ATOM    396  C   THR A  26     -22.004  46.102  -5.012  1.00  0.00           C  
ATOM    397  O   THR A  26     -23.074  46.711  -5.024  1.00  0.00           O  
ATOM    398  CB  THR A  26     -19.908  46.870  -6.127  1.00  0.00           C  
ATOM    399  OG1 THR A  26     -19.376  45.570  -6.412  1.00  0.00           O  
ATOM    400  CG2 THR A  26     -18.777  47.884  -6.067  1.00  0.00           C  
ATOM    401  H   THR A  26     -18.948  46.060  -3.878  1.00  0.00           H  
ATOM    402  HA  THR A  26     -20.900  47.858  -4.506  1.00  0.00           H  
ATOM    403  HB  THR A  26     -20.585  47.153  -6.918  1.00  0.00           H  
ATOM    404  HG1 THR A  26     -18.801  45.622  -7.179  1.00  0.00           H  
ATOM    405 HG21 THR A  26     -17.829  47.373  -6.143  1.00  0.00           H  
ATOM    406 HG22 THR A  26     -18.823  48.420  -5.130  1.00  0.00           H  
ATOM    407 HG23 THR A  26     -18.876  48.582  -6.886  1.00  0.00           H  
ATOM    408  N   ASP A  27     -21.919  44.786  -5.179  1.00  0.00           N  
ATOM    409  CA  ASP A  27     -23.105  43.965  -5.391  1.00  0.00           C  
ATOM    410  C   ASP A  27     -24.087  44.120  -4.234  1.00  0.00           C  
ATOM    411  O   ASP A  27     -23.709  44.018  -3.067  1.00  0.00           O  
ATOM    412  CB  ASP A  27     -22.711  42.495  -5.548  1.00  0.00           C  
ATOM    413  CG  ASP A  27     -23.680  41.727  -6.427  1.00  0.00           C  
ATOM    414  OD1 ASP A  27     -24.647  42.343  -6.922  1.00  0.00           O  
ATOM    415  OD2 ASP A  27     -23.469  40.511  -6.621  1.00  0.00           O  
ATOM    416  H   ASP A  27     -21.038  44.358  -5.159  1.00  0.00           H  
ATOM    417  HA  ASP A  27     -23.583  44.299  -6.299  1.00  0.00           H  
ATOM    418  HB2 ASP A  27     -21.728  42.438  -5.992  1.00  0.00           H  
ATOM    419  HB3 ASP A  27     -22.690  42.028  -4.575  1.00  0.00           H  
ATOM    420  N   LYS A  28     -25.350  44.368  -4.565  1.00  0.00           N  
ATOM    421  CA  LYS A  28     -26.387  44.536  -3.555  1.00  0.00           C  
ATOM    422  C   LYS A  28     -26.401  43.358  -2.586  1.00  0.00           C  
ATOM    423  O   LYS A  28     -26.245  43.535  -1.378  1.00  0.00           O  
ATOM    424  CB  LYS A  28     -27.758  44.679  -4.221  1.00  0.00           C  
ATOM    425  CG  LYS A  28     -28.895  44.887  -3.235  1.00  0.00           C  
ATOM    426  CD  LYS A  28     -30.244  44.611  -3.874  1.00  0.00           C  
ATOM    427  CE  LYS A  28     -30.680  45.755  -4.777  1.00  0.00           C  
ATOM    428  NZ  LYS A  28     -31.901  45.413  -5.556  1.00  0.00           N  
ATOM    429  H   LYS A  28     -25.589  44.437  -5.513  1.00  0.00           H  
ATOM    430  HA  LYS A  28     -26.169  45.439  -3.003  1.00  0.00           H  
ATOM    431  HB2 LYS A  28     -27.732  45.524  -4.893  1.00  0.00           H  
ATOM    432  HB3 LYS A  28     -27.962  43.784  -4.791  1.00  0.00           H  
ATOM    433  HG2 LYS A  28     -28.760  44.219  -2.398  1.00  0.00           H  
ATOM    434  HG3 LYS A  28     -28.874  45.911  -2.888  1.00  0.00           H  
ATOM    435  HD2 LYS A  28     -30.176  43.709  -4.464  1.00  0.00           H  
ATOM    436  HD3 LYS A  28     -30.982  44.478  -3.095  1.00  0.00           H  
ATOM    437  HE2 LYS A  28     -30.885  46.621  -4.165  1.00  0.00           H  
ATOM    438  HE3 LYS A  28     -29.877  45.981  -5.462  1.00  0.00           H  
ATOM    439  HZ1 LYS A  28     -32.625  45.010  -4.927  1.00  0.00           H  
ATOM    440  HZ2 LYS A  28     -31.672  44.716  -6.293  1.00  0.00           H  
ATOM    441  HZ3 LYS A  28     -32.288  46.266  -6.009  1.00  0.00           H  
ATOM    442  N   ARG A  29     -26.587  42.158  -3.125  1.00  0.00           N  
ATOM    443  CA  ARG A  29     -26.620  40.951  -2.307  1.00  0.00           C  
ATOM    444  C   ARG A  29     -25.561  41.007  -1.212  1.00  0.00           C  
ATOM    445  O   ARG A  29     -25.777  40.527  -0.098  1.00  0.00           O  
ATOM    446  CB  ARG A  29     -26.402  39.713  -3.179  1.00  0.00           C  
ATOM    447  CG  ARG A  29     -25.303  39.883  -4.216  1.00  0.00           C  
ATOM    448  CD  ARG A  29     -23.949  39.468  -3.663  1.00  0.00           C  
ATOM    449  NE  ARG A  29     -23.044  39.014  -4.716  1.00  0.00           N  
ATOM    450  CZ  ARG A  29     -23.276  37.949  -5.475  1.00  0.00           C  
ATOM    451  NH1 ARG A  29     -24.377  37.233  -5.299  1.00  0.00           N  
ATOM    452  NH2 ARG A  29     -22.405  37.599  -6.414  1.00  0.00           N  
ATOM    453  H   ARG A  29     -26.705  42.082  -4.095  1.00  0.00           H  
ATOM    454  HA  ARG A  29     -27.595  40.889  -1.847  1.00  0.00           H  
ATOM    455  HB2 ARG A  29     -26.142  38.880  -2.543  1.00  0.00           H  
ATOM    456  HB3 ARG A  29     -27.323  39.486  -3.697  1.00  0.00           H  
ATOM    457  HG2 ARG A  29     -25.533  39.270  -5.074  1.00  0.00           H  
ATOM    458  HG3 ARG A  29     -25.260  40.921  -4.512  1.00  0.00           H  
ATOM    459  HD2 ARG A  29     -23.504  40.314  -3.161  1.00  0.00           H  
ATOM    460  HD3 ARG A  29     -24.094  38.666  -2.956  1.00  0.00           H  
ATOM    461  HE  ARG A  29     -22.224  39.529  -4.864  1.00  0.00           H  
ATOM    462 HH11 ARG A  29     -25.036  37.495  -4.594  1.00  0.00           H  
ATOM    463 HH12 ARG A  29     -24.550  36.432  -5.873  1.00  0.00           H  
ATOM    464 HH21 ARG A  29     -21.574  38.137  -6.549  1.00  0.00           H  
ATOM    465 HH22 ARG A  29     -22.580  36.798  -6.984  1.00  0.00           H  
ATOM    466  N   PHE A  30     -24.413  41.596  -1.533  1.00  0.00           N  
ATOM    467  CA  PHE A  30     -23.320  41.714  -0.577  1.00  0.00           C  
ATOM    468  C   PHE A  30     -23.153  43.159  -0.116  1.00  0.00           C  
ATOM    469  O   PHE A  30     -22.037  43.670  -0.031  1.00  0.00           O  
ATOM    470  CB  PHE A  30     -22.015  41.211  -1.199  1.00  0.00           C  
ATOM    471  CG  PHE A  30     -21.856  39.720  -1.135  1.00  0.00           C  
ATOM    472  CD1 PHE A  30     -22.106  39.032   0.043  1.00  0.00           C  
ATOM    473  CD2 PHE A  30     -21.455  39.004  -2.251  1.00  0.00           C  
ATOM    474  CE1 PHE A  30     -21.961  37.660   0.105  1.00  0.00           C  
ATOM    475  CE2 PHE A  30     -21.308  37.631  -2.194  1.00  0.00           C  
ATOM    476  CZ  PHE A  30     -21.560  36.958  -1.015  1.00  0.00           C  
ATOM    477  H   PHE A  30     -24.301  41.960  -2.437  1.00  0.00           H  
ATOM    478  HA  PHE A  30     -23.561  41.102   0.278  1.00  0.00           H  
ATOM    479  HB2 PHE A  30     -21.983  41.503  -2.237  1.00  0.00           H  
ATOM    480  HB3 PHE A  30     -21.182  41.659  -0.678  1.00  0.00           H  
ATOM    481  HD1 PHE A  30     -22.420  39.581   0.920  1.00  0.00           H  
ATOM    482  HD2 PHE A  30     -21.255  39.529  -3.174  1.00  0.00           H  
ATOM    483  HE1 PHE A  30     -22.160  37.137   1.029  1.00  0.00           H  
ATOM    484  HE2 PHE A  30     -20.995  37.085  -3.072  1.00  0.00           H  
ATOM    485  HZ  PHE A  30     -21.447  35.885  -0.969  1.00  0.00           H  
ATOM    486  N   ASN A  31     -24.272  43.812   0.180  1.00  0.00           N  
ATOM    487  CA  ASN A  31     -24.251  45.199   0.632  1.00  0.00           C  
ATOM    488  C   ASN A  31     -24.570  45.290   2.121  1.00  0.00           C  
ATOM    489  O   ASN A  31     -24.255  46.287   2.773  1.00  0.00           O  
ATOM    490  CB  ASN A  31     -25.255  46.032  -0.168  1.00  0.00           C  
ATOM    491  CG  ASN A  31     -25.013  47.522  -0.026  1.00  0.00           C  
ATOM    492  OD1 ASN A  31     -24.598  47.996   1.032  1.00  0.00           O  
ATOM    493  ND2 ASN A  31     -25.272  48.268  -1.093  1.00  0.00           N  
ATOM    494  H   ASN A  31     -25.133  43.351   0.093  1.00  0.00           H  
ATOM    495  HA  ASN A  31     -23.259  45.587   0.463  1.00  0.00           H  
ATOM    496  HB2 ASN A  31     -25.177  45.773  -1.213  1.00  0.00           H  
ATOM    497  HB3 ASN A  31     -26.254  45.814   0.179  1.00  0.00           H  
ATOM    498 HD21 ASN A  31     -25.599  47.822  -1.902  1.00  0.00           H  
ATOM    499 HD22 ASN A  31     -25.123  49.235  -1.029  1.00  0.00           H  
ATOM    500  N   ILE A  32     -25.195  44.245   2.652  1.00  0.00           N  
ATOM    501  CA  ILE A  32     -25.554  44.208   4.065  1.00  0.00           C  
ATOM    502  C   ILE A  32     -24.311  44.174   4.947  1.00  0.00           C  
ATOM    503  O   ILE A  32     -24.356  44.558   6.116  1.00  0.00           O  
ATOM    504  CB  ILE A  32     -26.433  42.985   4.390  1.00  0.00           C  
ATOM    505  CG1 ILE A  32     -25.641  41.692   4.188  1.00  0.00           C  
ATOM    506  CG2 ILE A  32     -27.683  42.987   3.524  1.00  0.00           C  
ATOM    507  CD1 ILE A  32     -26.107  40.555   5.068  1.00  0.00           C  
ATOM    508  H   ILE A  32     -25.419  43.481   2.082  1.00  0.00           H  
ATOM    509  HA  ILE A  32     -26.117  45.102   4.289  1.00  0.00           H  
ATOM    510  HB  ILE A  32     -26.739  43.055   5.422  1.00  0.00           H  
ATOM    511 HG12 ILE A  32     -25.735  41.376   3.161  1.00  0.00           H  
ATOM    512 HG13 ILE A  32     -24.599  41.879   4.409  1.00  0.00           H  
ATOM    513 HG21 ILE A  32     -27.743  43.919   2.980  1.00  0.00           H  
ATOM    514 HG22 ILE A  32     -27.638  42.165   2.825  1.00  0.00           H  
ATOM    515 HG23 ILE A  32     -28.556  42.880   4.151  1.00  0.00           H  
ATOM    516 HD11 ILE A  32     -25.913  40.796   6.103  1.00  0.00           H  
ATOM    517 HD12 ILE A  32     -27.166  40.399   4.926  1.00  0.00           H  
ATOM    518 HD13 ILE A  32     -25.573  39.652   4.805  1.00  0.00           H  
ATOM    519  N   PHE A  33     -23.200  43.715   4.379  1.00  0.00           N  
ATOM    520  CA  PHE A  33     -21.943  43.632   5.114  1.00  0.00           C  
ATOM    521  C   PHE A  33     -21.091  44.875   4.873  1.00  0.00           C  
ATOM    522  O   PHE A  33     -20.100  45.105   5.567  1.00  0.00           O  
ATOM    523  CB  PHE A  33     -21.168  42.380   4.701  1.00  0.00           C  
ATOM    524  CG  PHE A  33     -21.899  41.100   4.987  1.00  0.00           C  
ATOM    525  CD1 PHE A  33     -21.894  40.552   6.259  1.00  0.00           C  
ATOM    526  CD2 PHE A  33     -22.593  40.444   3.983  1.00  0.00           C  
ATOM    527  CE1 PHE A  33     -22.566  39.375   6.526  1.00  0.00           C  
ATOM    528  CE2 PHE A  33     -23.268  39.266   4.243  1.00  0.00           C  
ATOM    529  CZ  PHE A  33     -23.253  38.731   5.517  1.00  0.00           C  
ATOM    530  H   PHE A  33     -23.228  43.423   3.444  1.00  0.00           H  
ATOM    531  HA  PHE A  33     -22.179  43.569   6.165  1.00  0.00           H  
ATOM    532  HB2 PHE A  33     -20.973  42.420   3.640  1.00  0.00           H  
ATOM    533  HB3 PHE A  33     -20.230  42.355   5.234  1.00  0.00           H  
ATOM    534  HD1 PHE A  33     -21.355  41.056   7.050  1.00  0.00           H  
ATOM    535  HD2 PHE A  33     -22.605  40.860   2.986  1.00  0.00           H  
ATOM    536  HE1 PHE A  33     -22.553  38.959   7.522  1.00  0.00           H  
ATOM    537  HE2 PHE A  33     -23.805  38.764   3.452  1.00  0.00           H  
ATOM    538  HZ  PHE A  33     -23.779  37.811   5.723  1.00  0.00           H  
ATOM    539  N   SER A  34     -21.484  45.674   3.886  1.00  0.00           N  
ATOM    540  CA  SER A  34     -20.755  46.891   3.552  1.00  0.00           C  
ATOM    541  C   SER A  34     -20.845  47.908   4.684  1.00  0.00           C  
ATOM    542  O   SER A  34     -20.018  48.814   4.790  1.00  0.00           O  
ATOM    543  CB  SER A  34     -21.302  47.499   2.259  1.00  0.00           C  
ATOM    544  OG  SER A  34     -20.424  48.488   1.748  1.00  0.00           O  
ATOM    545  H   SER A  34     -22.283  45.437   3.369  1.00  0.00           H  
ATOM    546  HA  SER A  34     -19.718  46.626   3.403  1.00  0.00           H  
ATOM    547  HB2 SER A  34     -21.419  46.722   1.520  1.00  0.00           H  
ATOM    548  HB3 SER A  34     -22.262  47.954   2.458  1.00  0.00           H  
ATOM    549  HG  SER A  34     -20.912  49.084   1.175  1.00  0.00           H  
ATOM    550  N   LYS A  35     -21.856  47.751   5.532  1.00  0.00           N  
ATOM    551  CA  LYS A  35     -22.057  48.654   6.659  1.00  0.00           C  
ATOM    552  C   LYS A  35     -22.222  47.873   7.959  1.00  0.00           C  
ATOM    553  O   LYS A  35     -22.581  46.695   7.962  1.00  0.00           O  
ATOM    554  CB  LYS A  35     -23.285  49.535   6.422  1.00  0.00           C  
ATOM    555  CG  LYS A  35     -24.437  48.806   5.751  1.00  0.00           C  
ATOM    556  CD  LYS A  35     -25.238  47.991   6.752  1.00  0.00           C  
ATOM    557  CE  LYS A  35     -26.610  47.629   6.204  1.00  0.00           C  
ATOM    558  NZ  LYS A  35     -27.411  48.838   5.869  1.00  0.00           N  
ATOM    559  H   LYS A  35     -22.483  47.010   5.396  1.00  0.00           H  
ATOM    560  HA  LYS A  35     -21.184  49.283   6.740  1.00  0.00           H  
ATOM    561  HB2 LYS A  35     -23.631  49.914   7.372  1.00  0.00           H  
ATOM    562  HB3 LYS A  35     -23.000  50.367   5.795  1.00  0.00           H  
ATOM    563  HG2 LYS A  35     -25.089  49.530   5.288  1.00  0.00           H  
ATOM    564  HG3 LYS A  35     -24.039  48.142   4.996  1.00  0.00           H  
ATOM    565  HD2 LYS A  35     -24.701  47.081   6.976  1.00  0.00           H  
ATOM    566  HD3 LYS A  35     -25.363  48.569   7.656  1.00  0.00           H  
ATOM    567  HE2 LYS A  35     -26.481  47.034   5.311  1.00  0.00           H  
ATOM    568  HE3 LYS A  35     -27.139  47.051   6.947  1.00  0.00           H  
ATOM    569  HZ1 LYS A  35     -27.179  49.613   6.524  1.00  0.00           H  
ATOM    570  HZ2 LYS A  35     -28.426  48.627   5.946  1.00  0.00           H  
ATOM    571  HZ3 LYS A  35     -27.205  49.146   4.897  1.00  0.00           H  
ATOM    572  N   PRO A  36     -21.957  48.542   9.091  1.00  0.00           N  
ATOM    573  CA  PRO A  36     -22.072  47.930  10.417  1.00  0.00           C  
ATOM    574  C   PRO A  36     -23.521  47.653  10.806  1.00  0.00           C  
ATOM    575  O   PRO A  36     -24.249  48.559  11.212  1.00  0.00           O  
ATOM    576  CB  PRO A  36     -21.461  48.981  11.347  1.00  0.00           C  
ATOM    577  CG  PRO A  36     -21.637  50.273  10.626  1.00  0.00           C  
ATOM    578  CD  PRO A  36     -21.525  49.948   9.162  1.00  0.00           C  
ATOM    579  HA  PRO A  36     -21.502  47.014  10.483  1.00  0.00           H  
ATOM    580  HB2 PRO A  36     -21.988  48.981  12.291  1.00  0.00           H  
ATOM    581  HB3 PRO A  36     -20.417  48.760  11.511  1.00  0.00           H  
ATOM    582  HG2 PRO A  36     -22.609  50.687  10.845  1.00  0.00           H  
ATOM    583  HG3 PRO A  36     -20.859  50.964  10.917  1.00  0.00           H  
ATOM    584  HD2 PRO A  36     -22.180  50.583   8.583  1.00  0.00           H  
ATOM    585  HD3 PRO A  36     -20.503  50.053   8.829  1.00  0.00           H  
ATOM    586  N   VAL A  37     -23.933  46.397  10.676  1.00  0.00           N  
ATOM    587  CA  VAL A  37     -25.295  46.001  11.014  1.00  0.00           C  
ATOM    588  C   VAL A  37     -25.481  45.908  12.524  1.00  0.00           C  
ATOM    589  O   VAL A  37     -25.695  44.824  13.068  1.00  0.00           O  
ATOM    590  CB  VAL A  37     -25.661  44.646  10.378  1.00  0.00           C  
ATOM    591  CG1 VAL A  37     -25.531  44.714   8.865  1.00  0.00           C  
ATOM    592  CG2 VAL A  37     -24.787  43.538  10.948  1.00  0.00           C  
ATOM    593  H   VAL A  37     -23.306  45.720  10.346  1.00  0.00           H  
ATOM    594  HA  VAL A  37     -25.968  46.750  10.624  1.00  0.00           H  
ATOM    595  HB  VAL A  37     -26.689  44.424  10.620  1.00  0.00           H  
ATOM    596 HG11 VAL A  37     -24.824  43.969   8.531  1.00  0.00           H  
ATOM    597 HG12 VAL A  37     -26.493  44.528   8.412  1.00  0.00           H  
ATOM    598 HG13 VAL A  37     -25.181  45.695   8.578  1.00  0.00           H  
ATOM    599 HG21 VAL A  37     -25.330  43.012  11.718  1.00  0.00           H  
ATOM    600 HG22 VAL A  37     -24.520  42.849  10.160  1.00  0.00           H  
ATOM    601 HG23 VAL A  37     -23.889  43.968  11.368  1.00  0.00           H  
ATOM    602  N   SER A  38     -25.400  47.051  13.197  1.00  0.00           N  
ATOM    603  CA  SER A  38     -25.556  47.099  14.646  1.00  0.00           C  
ATOM    604  C   SER A  38     -26.426  48.282  15.059  1.00  0.00           C  
ATOM    605  O   SER A  38     -26.557  49.258  14.322  1.00  0.00           O  
ATOM    606  CB  SER A  38     -24.188  47.196  15.325  1.00  0.00           C  
ATOM    607  OG  SER A  38     -24.291  46.955  16.717  1.00  0.00           O  
ATOM    608  H   SER A  38     -25.228  47.882  12.707  1.00  0.00           H  
ATOM    609  HA  SER A  38     -26.038  46.186  14.957  1.00  0.00           H  
ATOM    610  HB2 SER A  38     -23.523  46.464  14.894  1.00  0.00           H  
ATOM    611  HB3 SER A  38     -23.783  48.186  15.172  1.00  0.00           H  
ATOM    612  HG  SER A  38     -24.243  46.011  16.884  1.00  0.00           H  
ATOM    613  N   ASP A  39     -27.019  48.186  16.245  1.00  0.00           N  
ATOM    614  CA  ASP A  39     -27.877  49.246  16.759  1.00  0.00           C  
ATOM    615  C   ASP A  39     -27.045  50.364  17.381  1.00  0.00           C  
ATOM    616  O   ASP A  39     -27.529  51.481  17.569  1.00  0.00           O  
ATOM    617  CB  ASP A  39     -28.854  48.686  17.793  1.00  0.00           C  
ATOM    618  CG  ASP A  39     -30.070  49.572  17.981  1.00  0.00           C  
ATOM    619  OD1 ASP A  39     -29.932  50.806  17.844  1.00  0.00           O  
ATOM    620  OD2 ASP A  39     -31.159  49.032  18.264  1.00  0.00           O  
ATOM    621  H   ASP A  39     -26.876  47.382  16.787  1.00  0.00           H  
ATOM    622  HA  ASP A  39     -28.437  49.651  15.930  1.00  0.00           H  
ATOM    623  HB2 ASP A  39     -29.189  47.711  17.470  1.00  0.00           H  
ATOM    624  HB3 ASP A  39     -28.349  48.592  18.743  1.00  0.00           H  
ATOM    625  N   TYR A  40     -25.793  50.056  17.699  1.00  0.00           N  
ATOM    626  CA  TYR A  40     -24.895  51.033  18.302  1.00  0.00           C  
ATOM    627  C   TYR A  40     -23.453  50.787  17.871  1.00  0.00           C  
ATOM    628  O   TYR A  40     -22.890  49.720  18.120  1.00  0.00           O  
ATOM    629  CB  TYR A  40     -24.999  50.978  19.827  1.00  0.00           C  
ATOM    630  CG  TYR A  40     -24.735  52.306  20.500  1.00  0.00           C  
ATOM    631  CD1 TYR A  40     -24.013  53.302  19.856  1.00  0.00           C  
ATOM    632  CD2 TYR A  40     -25.208  52.564  21.782  1.00  0.00           C  
ATOM    633  CE1 TYR A  40     -23.768  54.517  20.467  1.00  0.00           C  
ATOM    634  CE2 TYR A  40     -24.969  53.777  22.400  1.00  0.00           C  
ATOM    635  CZ  TYR A  40     -24.250  54.750  21.738  1.00  0.00           C  
ATOM    636  OH  TYR A  40     -24.009  55.958  22.352  1.00  0.00           O  
ATOM    637  H   TYR A  40     -25.464  49.150  17.524  1.00  0.00           H  
ATOM    638  HA  TYR A  40     -25.198  52.014  17.965  1.00  0.00           H  
ATOM    639  HB2 TYR A  40     -25.993  50.659  20.102  1.00  0.00           H  
ATOM    640  HB3 TYR A  40     -24.280  50.266  20.205  1.00  0.00           H  
ATOM    641  HD1 TYR A  40     -23.637  53.117  18.859  1.00  0.00           H  
ATOM    642  HD2 TYR A  40     -25.771  51.800  22.296  1.00  0.00           H  
ATOM    643  HE1 TYR A  40     -23.204  55.279  19.949  1.00  0.00           H  
ATOM    644  HE2 TYR A  40     -25.346  53.958  23.395  1.00  0.00           H  
ATOM    645  HH  TYR A  40     -23.176  56.317  22.036  1.00  0.00           H  
ATOM    646  N   LEU A  41     -22.859  51.783  17.221  1.00  0.00           N  
ATOM    647  CA  LEU A  41     -21.480  51.677  16.754  1.00  0.00           C  
ATOM    648  C   LEU A  41     -20.512  51.604  17.930  1.00  0.00           C  
ATOM    649  O   LEU A  41     -19.361  51.196  17.772  1.00  0.00           O  
ATOM    650  CB  LEU A  41     -21.131  52.870  15.863  1.00  0.00           C  
ATOM    651  CG  LEU A  41     -20.606  54.114  16.581  1.00  0.00           C  
ATOM    652  CD1 LEU A  41     -19.102  54.017  16.786  1.00  0.00           C  
ATOM    653  CD2 LEU A  41     -20.960  55.371  15.800  1.00  0.00           C  
ATOM    654  H   LEU A  41     -23.358  52.608  17.052  1.00  0.00           H  
ATOM    655  HA  LEU A  41     -21.395  50.769  16.176  1.00  0.00           H  
ATOM    656  HB2 LEU A  41     -20.374  52.550  15.163  1.00  0.00           H  
ATOM    657  HB3 LEU A  41     -22.024  53.152  15.322  1.00  0.00           H  
ATOM    658  HG  LEU A  41     -21.071  54.182  17.555  1.00  0.00           H  
ATOM    659 HD11 LEU A  41     -18.649  53.568  15.916  1.00  0.00           H  
ATOM    660 HD12 LEU A  41     -18.896  53.408  17.655  1.00  0.00           H  
ATOM    661 HD13 LEU A  41     -18.695  55.006  16.936  1.00  0.00           H  
ATOM    662 HD21 LEU A  41     -20.173  55.587  15.093  1.00  0.00           H  
ATOM    663 HD22 LEU A  41     -21.069  56.201  16.482  1.00  0.00           H  
ATOM    664 HD23 LEU A  41     -21.887  55.215  15.270  1.00  0.00           H  
ATOM    665  N   GLU A  42     -20.985  52.000  19.106  1.00  0.00           N  
ATOM    666  CA  GLU A  42     -20.160  51.978  20.308  1.00  0.00           C  
ATOM    667  C   GLU A  42     -20.424  50.718  21.127  1.00  0.00           C  
ATOM    668  O   GLU A  42     -20.343  50.732  22.354  1.00  0.00           O  
ATOM    669  CB  GLU A  42     -20.430  53.219  21.162  1.00  0.00           C  
ATOM    670  CG  GLU A  42     -20.313  54.524  20.394  1.00  0.00           C  
ATOM    671  CD  GLU A  42     -19.878  55.682  21.272  1.00  0.00           C  
ATOM    672  OE1 GLU A  42     -20.607  56.002  22.234  1.00  0.00           O  
ATOM    673  OE2 GLU A  42     -18.810  56.268  20.996  1.00  0.00           O  
ATOM    674  H   GLU A  42     -21.911  52.316  19.168  1.00  0.00           H  
ATOM    675  HA  GLU A  42     -19.125  51.983  20.001  1.00  0.00           H  
ATOM    676  HB2 GLU A  42     -21.429  53.152  21.567  1.00  0.00           H  
ATOM    677  HB3 GLU A  42     -19.722  53.241  21.977  1.00  0.00           H  
ATOM    678  HG2 GLU A  42     -19.586  54.399  19.604  1.00  0.00           H  
ATOM    679  HG3 GLU A  42     -21.275  54.761  19.961  1.00  0.00           H  
ATOM    680  N   VAL A  43     -20.740  49.626  20.436  1.00  0.00           N  
ATOM    681  CA  VAL A  43     -21.016  48.356  21.096  1.00  0.00           C  
ATOM    682  C   VAL A  43     -20.137  47.244  20.536  1.00  0.00           C  
ATOM    683  O   VAL A  43     -20.030  46.167  21.125  1.00  0.00           O  
ATOM    684  CB  VAL A  43     -22.494  47.954  20.944  1.00  0.00           C  
ATOM    685  CG1 VAL A  43     -22.676  46.471  21.231  1.00  0.00           C  
ATOM    686  CG2 VAL A  43     -23.371  48.794  21.861  1.00  0.00           C  
ATOM    687  H   VAL A  43     -20.788  49.678  19.458  1.00  0.00           H  
ATOM    688  HA  VAL A  43     -20.802  48.475  22.149  1.00  0.00           H  
ATOM    689  HB  VAL A  43     -22.794  48.140  19.923  1.00  0.00           H  
ATOM    690 HG11 VAL A  43     -22.217  46.229  22.179  1.00  0.00           H  
ATOM    691 HG12 VAL A  43     -23.730  46.238  21.271  1.00  0.00           H  
ATOM    692 HG13 VAL A  43     -22.209  45.893  20.448  1.00  0.00           H  
ATOM    693 HG21 VAL A  43     -23.053  49.825  21.816  1.00  0.00           H  
ATOM    694 HG22 VAL A  43     -24.400  48.721  21.541  1.00  0.00           H  
ATOM    695 HG23 VAL A  43     -23.284  48.433  22.875  1.00  0.00           H  
ATOM    696  N   ILE A  44     -19.510  47.510  19.395  1.00  0.00           N  
ATOM    697  CA  ILE A  44     -18.639  46.531  18.756  1.00  0.00           C  
ATOM    698  C   ILE A  44     -17.189  46.718  19.191  1.00  0.00           C  
ATOM    699  O   ILE A  44     -16.707  47.843  19.317  1.00  0.00           O  
ATOM    700  CB  ILE A  44     -18.719  46.625  17.220  1.00  0.00           C  
ATOM    701  CG1 ILE A  44     -20.133  46.294  16.739  1.00  0.00           C  
ATOM    702  CG2 ILE A  44     -17.702  45.692  16.580  1.00  0.00           C  
ATOM    703  CD1 ILE A  44     -21.038  47.502  16.647  1.00  0.00           C  
ATOM    704  H   ILE A  44     -19.635  48.386  18.973  1.00  0.00           H  
ATOM    705  HA  ILE A  44     -18.970  45.547  19.053  1.00  0.00           H  
ATOM    706  HB  ILE A  44     -18.475  47.637  16.931  1.00  0.00           H  
ATOM    707 HG12 ILE A  44     -20.077  45.846  15.760  1.00  0.00           H  
ATOM    708 HG13 ILE A  44     -20.583  45.592  17.427  1.00  0.00           H  
ATOM    709 HG21 ILE A  44     -17.759  44.721  17.048  1.00  0.00           H  
ATOM    710 HG22 ILE A  44     -17.918  45.595  15.526  1.00  0.00           H  
ATOM    711 HG23 ILE A  44     -16.710  46.097  16.708  1.00  0.00           H  
ATOM    712 HD11 ILE A  44     -21.849  47.398  17.354  1.00  0.00           H  
ATOM    713 HD12 ILE A  44     -20.474  48.394  16.872  1.00  0.00           H  
ATOM    714 HD13 ILE A  44     -21.442  47.573  15.647  1.00  0.00           H  
ATOM    715  N   LYS A  45     -16.498  45.606  19.416  1.00  0.00           N  
ATOM    716  CA  LYS A  45     -15.101  45.645  19.835  1.00  0.00           C  
ATOM    717  C   LYS A  45     -14.176  45.763  18.629  1.00  0.00           C  
ATOM    718  O   LYS A  45     -13.212  46.529  18.647  1.00  0.00           O  
ATOM    719  CB  LYS A  45     -14.753  44.389  20.638  1.00  0.00           C  
ATOM    720  CG  LYS A  45     -15.161  44.469  22.098  1.00  0.00           C  
ATOM    721  CD  LYS A  45     -14.219  45.359  22.893  1.00  0.00           C  
ATOM    722  CE  LYS A  45     -12.940  44.625  23.263  1.00  0.00           C  
ATOM    723  NZ  LYS A  45     -11.900  45.553  23.786  1.00  0.00           N  
ATOM    724  H   LYS A  45     -16.938  44.738  19.299  1.00  0.00           H  
ATOM    725  HA  LYS A  45     -14.967  46.513  20.464  1.00  0.00           H  
ATOM    726  HB2 LYS A  45     -15.252  43.541  20.192  1.00  0.00           H  
ATOM    727  HB3 LYS A  45     -13.685  44.233  20.592  1.00  0.00           H  
ATOM    728  HG2 LYS A  45     -16.161  44.874  22.163  1.00  0.00           H  
ATOM    729  HG3 LYS A  45     -15.145  43.474  22.521  1.00  0.00           H  
ATOM    730  HD2 LYS A  45     -13.966  46.223  22.297  1.00  0.00           H  
ATOM    731  HD3 LYS A  45     -14.717  45.677  23.799  1.00  0.00           H  
ATOM    732  HE2 LYS A  45     -13.167  43.889  24.020  1.00  0.00           H  
ATOM    733  HE3 LYS A  45     -12.557  44.129  22.383  1.00  0.00           H  
ATOM    734  HZ1 LYS A  45     -11.951  46.465  23.288  1.00  0.00           H  
ATOM    735  HZ2 LYS A  45     -10.953  45.147  23.645  1.00  0.00           H  
ATOM    736  HZ3 LYS A  45     -12.046  45.717  24.803  1.00  0.00           H  
ATOM    737  N   GLU A  46     -14.475  45.001  17.581  1.00  0.00           N  
ATOM    738  CA  GLU A  46     -13.669  45.023  16.367  1.00  0.00           C  
ATOM    739  C   GLU A  46     -14.539  45.279  15.140  1.00  0.00           C  
ATOM    740  O   GLU A  46     -14.922  44.359  14.416  1.00  0.00           O  
ATOM    741  CB  GLU A  46     -12.916  43.700  16.205  1.00  0.00           C  
ATOM    742  CG  GLU A  46     -11.716  43.565  17.127  1.00  0.00           C  
ATOM    743  CD  GLU A  46     -11.303  42.122  17.340  1.00  0.00           C  
ATOM    744  OE1 GLU A  46     -11.301  41.355  16.354  1.00  0.00           O  
ATOM    745  OE2 GLU A  46     -10.981  41.760  18.490  1.00  0.00           O  
ATOM    746  H   GLU A  46     -15.256  44.411  17.627  1.00  0.00           H  
ATOM    747  HA  GLU A  46     -12.951  45.824  16.459  1.00  0.00           H  
ATOM    748  HB2 GLU A  46     -13.595  42.885  16.409  1.00  0.00           H  
ATOM    749  HB3 GLU A  46     -12.569  43.620  15.185  1.00  0.00           H  
ATOM    750  HG2 GLU A  46     -10.884  44.102  16.696  1.00  0.00           H  
ATOM    751  HG3 GLU A  46     -11.965  43.998  18.086  1.00  0.00           H  
ATOM    752  N   PRO A  47     -14.861  46.559  14.899  1.00  0.00           N  
ATOM    753  CA  PRO A  47     -15.690  46.967  13.762  1.00  0.00           C  
ATOM    754  C   PRO A  47     -14.969  46.795  12.428  1.00  0.00           C  
ATOM    755  O   PRO A  47     -14.041  47.539  12.114  1.00  0.00           O  
ATOM    756  CB  PRO A  47     -15.963  48.448  14.035  1.00  0.00           C  
ATOM    757  CG  PRO A  47     -14.821  48.894  14.881  1.00  0.00           C  
ATOM    758  CD  PRO A  47     -14.439  47.706  15.721  1.00  0.00           C  
ATOM    759  HA  PRO A  47     -16.624  46.425  13.737  1.00  0.00           H  
ATOM    760  HB2 PRO A  47     -15.997  48.988  13.099  1.00  0.00           H  
ATOM    761  HB3 PRO A  47     -16.904  48.554  14.554  1.00  0.00           H  
ATOM    762  HG2 PRO A  47     -13.994  49.192  14.255  1.00  0.00           H  
ATOM    763  HG3 PRO A  47     -15.132  49.714  15.512  1.00  0.00           H  
ATOM    764  HD2 PRO A  47     -13.373  47.690  15.887  1.00  0.00           H  
ATOM    765  HD3 PRO A  47     -14.970  47.722  16.661  1.00  0.00           H  
ATOM    766  N   MET A  48     -15.402  45.809  11.649  1.00  0.00           N  
ATOM    767  CA  MET A  48     -14.798  45.542  10.349  1.00  0.00           C  
ATOM    768  C   MET A  48     -15.861  45.487   9.257  1.00  0.00           C  
ATOM    769  O   MET A  48     -16.820  44.721   9.348  1.00  0.00           O  
ATOM    770  CB  MET A  48     -14.020  44.225  10.385  1.00  0.00           C  
ATOM    771  CG  MET A  48     -12.931  44.134   9.329  1.00  0.00           C  
ATOM    772  SD  MET A  48     -11.336  44.733   9.922  1.00  0.00           S  
ATOM    773  CE  MET A  48     -11.844  46.165  10.871  1.00  0.00           C  
ATOM    774  H   MET A  48     -16.145  45.249  11.955  1.00  0.00           H  
ATOM    775  HA  MET A  48     -14.114  46.348  10.130  1.00  0.00           H  
ATOM    776  HB2 MET A  48     -13.560  44.119  11.356  1.00  0.00           H  
ATOM    777  HB3 MET A  48     -14.710  43.409  10.231  1.00  0.00           H  
ATOM    778  HG2 MET A  48     -12.822  43.102   9.031  1.00  0.00           H  
ATOM    779  HG3 MET A  48     -13.227  44.725   8.475  1.00  0.00           H  
ATOM    780  HE1 MET A  48     -12.187  46.939  10.200  1.00  0.00           H  
ATOM    781  HE2 MET A  48     -12.647  45.888  11.538  1.00  0.00           H  
ATOM    782  HE3 MET A  48     -11.007  46.532  11.446  1.00  0.00           H  
ATOM    783  N   ASP A  49     -15.686  46.307   8.226  1.00  0.00           N  
ATOM    784  CA  ASP A  49     -16.630  46.351   7.115  1.00  0.00           C  
ATOM    785  C   ASP A  49     -15.896  46.419   5.779  1.00  0.00           C  
ATOM    786  O   ASP A  49     -14.789  46.953   5.694  1.00  0.00           O  
ATOM    787  CB  ASP A  49     -17.565  47.553   7.259  1.00  0.00           C  
ATOM    788  CG  ASP A  49     -16.903  48.718   7.969  1.00  0.00           C  
ATOM    789  OD1 ASP A  49     -15.741  49.036   7.635  1.00  0.00           O  
ATOM    790  OD2 ASP A  49     -17.546  49.313   8.858  1.00  0.00           O  
ATOM    791  H   ASP A  49     -14.901  46.895   8.210  1.00  0.00           H  
ATOM    792  HA  ASP A  49     -17.217  45.445   7.143  1.00  0.00           H  
ATOM    793  HB2 ASP A  49     -17.872  47.882   6.278  1.00  0.00           H  
ATOM    794  HB3 ASP A  49     -18.435  47.259   7.825  1.00  0.00           H  
ATOM    795  N   LEU A  50     -16.517  45.875   4.740  1.00  0.00           N  
ATOM    796  CA  LEU A  50     -15.923  45.873   3.408  1.00  0.00           C  
ATOM    797  C   LEU A  50     -15.468  47.273   3.013  1.00  0.00           C  
ATOM    798  O   LEU A  50     -14.653  47.439   2.105  1.00  0.00           O  
ATOM    799  CB  LEU A  50     -16.925  45.342   2.381  1.00  0.00           C  
ATOM    800  CG  LEU A  50     -17.231  43.846   2.454  1.00  0.00           C  
ATOM    801  CD1 LEU A  50     -18.477  43.515   1.646  1.00  0.00           C  
ATOM    802  CD2 LEU A  50     -16.043  43.033   1.961  1.00  0.00           C  
ATOM    803  H   LEU A  50     -17.398  45.464   4.870  1.00  0.00           H  
ATOM    804  HA  LEU A  50     -15.063  45.221   3.430  1.00  0.00           H  
ATOM    805  HB2 LEU A  50     -17.853  45.875   2.518  1.00  0.00           H  
ATOM    806  HB3 LEU A  50     -16.532  45.552   1.397  1.00  0.00           H  
ATOM    807  HG  LEU A  50     -17.419  43.573   3.484  1.00  0.00           H  
ATOM    808 HD11 LEU A  50     -18.499  42.456   1.436  1.00  0.00           H  
ATOM    809 HD12 LEU A  50     -18.460  44.066   0.718  1.00  0.00           H  
ATOM    810 HD13 LEU A  50     -19.355  43.789   2.211  1.00  0.00           H  
ATOM    811 HD21 LEU A  50     -15.130  43.460   2.348  1.00  0.00           H  
ATOM    812 HD22 LEU A  50     -16.018  43.052   0.880  1.00  0.00           H  
ATOM    813 HD23 LEU A  50     -16.137  42.013   2.302  1.00  0.00           H  
ATOM    814  N   SER A  51     -15.997  48.280   3.702  1.00  0.00           N  
ATOM    815  CA  SER A  51     -15.647  49.667   3.422  1.00  0.00           C  
ATOM    816  C   SER A  51     -14.245  49.986   3.934  1.00  0.00           C  
ATOM    817  O   SER A  51     -13.393  50.466   3.186  1.00  0.00           O  
ATOM    818  CB  SER A  51     -16.664  50.611   4.064  1.00  0.00           C  
ATOM    819  OG  SER A  51     -17.985  50.286   3.668  1.00  0.00           O  
ATOM    820  H   SER A  51     -16.642  48.082   4.414  1.00  0.00           H  
ATOM    821  HA  SER A  51     -15.667  49.804   2.351  1.00  0.00           H  
ATOM    822  HB2 SER A  51     -16.595  50.535   5.139  1.00  0.00           H  
ATOM    823  HB3 SER A  51     -16.450  51.627   3.761  1.00  0.00           H  
ATOM    824  HG  SER A  51     -18.083  49.330   3.636  1.00  0.00           H  
ATOM    825  N   THR A  52     -14.013  49.716   5.214  1.00  0.00           N  
ATOM    826  CA  THR A  52     -12.717  49.975   5.827  1.00  0.00           C  
ATOM    827  C   THR A  52     -11.623  49.137   5.176  1.00  0.00           C  
ATOM    828  O   THR A  52     -10.451  49.513   5.185  1.00  0.00           O  
ATOM    829  CB  THR A  52     -12.741  49.680   7.339  1.00  0.00           C  
ATOM    830  OG1 THR A  52     -11.742  50.459   8.006  1.00  0.00           O  
ATOM    831  CG2 THR A  52     -12.501  48.202   7.606  1.00  0.00           C  
ATOM    832  H   THR A  52     -14.733  49.334   5.759  1.00  0.00           H  
ATOM    833  HA  THR A  52     -12.486  51.021   5.690  1.00  0.00           H  
ATOM    834  HB  THR A  52     -13.714  49.947   7.727  1.00  0.00           H  
ATOM    835  HG1 THR A  52     -11.989  51.387   7.981  1.00  0.00           H  
ATOM    836 HG21 THR A  52     -12.811  47.625   6.746  1.00  0.00           H  
ATOM    837 HG22 THR A  52     -13.072  47.895   8.470  1.00  0.00           H  
ATOM    838 HG23 THR A  52     -11.451  48.036   7.789  1.00  0.00           H  
ATOM    839  N   VAL A  53     -12.014  48.001   4.607  1.00  0.00           N  
ATOM    840  CA  VAL A  53     -11.065  47.110   3.949  1.00  0.00           C  
ATOM    841  C   VAL A  53     -10.490  47.753   2.691  1.00  0.00           C  
ATOM    842  O   VAL A  53      -9.273  47.835   2.525  1.00  0.00           O  
ATOM    843  CB  VAL A  53     -11.725  45.770   3.571  1.00  0.00           C  
ATOM    844  CG1 VAL A  53     -10.751  44.897   2.793  1.00  0.00           C  
ATOM    845  CG2 VAL A  53     -12.219  45.051   4.817  1.00  0.00           C  
ATOM    846  H   VAL A  53     -12.962  47.756   4.632  1.00  0.00           H  
ATOM    847  HA  VAL A  53     -10.260  46.909   4.639  1.00  0.00           H  
ATOM    848  HB  VAL A  53     -12.575  45.974   2.938  1.00  0.00           H  
ATOM    849 HG11 VAL A  53     -10.634  45.292   1.794  1.00  0.00           H  
ATOM    850 HG12 VAL A  53      -9.794  44.889   3.294  1.00  0.00           H  
ATOM    851 HG13 VAL A  53     -11.137  43.889   2.737  1.00  0.00           H  
ATOM    852 HG21 VAL A  53     -11.430  45.022   5.553  1.00  0.00           H  
ATOM    853 HG22 VAL A  53     -13.071  45.577   5.223  1.00  0.00           H  
ATOM    854 HG23 VAL A  53     -12.509  44.042   4.560  1.00  0.00           H  
ATOM    855  N   ILE A  54     -11.374  48.207   1.808  1.00  0.00           N  
ATOM    856  CA  ILE A  54     -10.954  48.844   0.567  1.00  0.00           C  
ATOM    857  C   ILE A  54      -9.915  49.931   0.830  1.00  0.00           C  
ATOM    858  O   ILE A  54      -9.081  50.227  -0.024  1.00  0.00           O  
ATOM    859  CB  ILE A  54     -12.149  49.463  -0.181  1.00  0.00           C  
ATOM    860  CG1 ILE A  54     -13.022  48.364  -0.790  1.00  0.00           C  
ATOM    861  CG2 ILE A  54     -11.662  50.419  -1.260  1.00  0.00           C  
ATOM    862  CD1 ILE A  54     -14.335  48.873  -1.342  1.00  0.00           C  
ATOM    863  H   ILE A  54     -12.331  48.113   1.998  1.00  0.00           H  
ATOM    864  HA  ILE A  54     -10.514  48.086  -0.064  1.00  0.00           H  
ATOM    865  HB  ILE A  54     -12.736  50.027   0.528  1.00  0.00           H  
ATOM    866 HG12 ILE A  54     -12.484  47.892  -1.596  1.00  0.00           H  
ATOM    867 HG13 ILE A  54     -13.243  47.628  -0.030  1.00  0.00           H  
ATOM    868 HG21 ILE A  54     -12.493  50.711  -1.885  1.00  0.00           H  
ATOM    869 HG22 ILE A  54     -11.236  51.296  -0.797  1.00  0.00           H  
ATOM    870 HG23 ILE A  54     -10.913  49.929  -1.863  1.00  0.00           H  
ATOM    871 HD11 ILE A  54     -14.361  48.718  -2.411  1.00  0.00           H  
ATOM    872 HD12 ILE A  54     -15.151  48.336  -0.881  1.00  0.00           H  
ATOM    873 HD13 ILE A  54     -14.432  49.927  -1.129  1.00  0.00           H  
ATOM    874  N   THR A  55      -9.972  50.519   2.021  1.00  0.00           N  
ATOM    875  CA  THR A  55      -9.037  51.572   2.398  1.00  0.00           C  
ATOM    876  C   THR A  55      -7.654  51.001   2.686  1.00  0.00           C  
ATOM    877  O   THR A  55      -6.641  51.550   2.252  1.00  0.00           O  
ATOM    878  CB  THR A  55      -9.530  52.344   3.637  1.00  0.00           C  
ATOM    879  OG1 THR A  55     -10.660  53.153   3.292  1.00  0.00           O  
ATOM    880  CG2 THR A  55      -8.425  53.223   4.202  1.00  0.00           C  
ATOM    881  H   THR A  55     -10.660  50.239   2.660  1.00  0.00           H  
ATOM    882  HA  THR A  55      -8.965  52.266   1.572  1.00  0.00           H  
ATOM    883  HB  THR A  55      -9.824  51.630   4.392  1.00  0.00           H  
ATOM    884  HG1 THR A  55     -10.753  53.863   3.932  1.00  0.00           H  
ATOM    885 HG21 THR A  55      -8.088  52.818   5.144  1.00  0.00           H  
ATOM    886 HG22 THR A  55      -8.802  54.223   4.354  1.00  0.00           H  
ATOM    887 HG23 THR A  55      -7.598  53.253   3.507  1.00  0.00           H  
ATOM    888  N   LYS A  56      -7.617  49.894   3.420  1.00  0.00           N  
ATOM    889  CA  LYS A  56      -6.357  49.246   3.766  1.00  0.00           C  
ATOM    890  C   LYS A  56      -5.552  48.920   2.513  1.00  0.00           C  
ATOM    891  O   LYS A  56      -4.325  49.026   2.507  1.00  0.00           O  
ATOM    892  CB  LYS A  56      -6.620  47.967   4.564  1.00  0.00           C  
ATOM    893  CG  LYS A  56      -7.518  48.177   5.771  1.00  0.00           C  
ATOM    894  CD  LYS A  56      -6.829  49.006   6.842  1.00  0.00           C  
ATOM    895  CE  LYS A  56      -6.037  48.130   7.802  1.00  0.00           C  
ATOM    896  NZ  LYS A  56      -5.926  48.747   9.152  1.00  0.00           N  
ATOM    897  H   LYS A  56      -8.458  49.503   3.738  1.00  0.00           H  
ATOM    898  HA  LYS A  56      -5.789  49.931   4.376  1.00  0.00           H  
ATOM    899  HB2 LYS A  56      -7.088  47.242   3.915  1.00  0.00           H  
ATOM    900  HB3 LYS A  56      -5.675  47.573   4.909  1.00  0.00           H  
ATOM    901  HG2 LYS A  56      -8.415  48.690   5.457  1.00  0.00           H  
ATOM    902  HG3 LYS A  56      -7.778  47.213   6.186  1.00  0.00           H  
ATOM    903  HD2 LYS A  56      -6.152  49.701   6.367  1.00  0.00           H  
ATOM    904  HD3 LYS A  56      -7.576  49.551   7.400  1.00  0.00           H  
ATOM    905  HE2 LYS A  56      -6.534  47.175   7.890  1.00  0.00           H  
ATOM    906  HE3 LYS A  56      -5.046  47.982   7.399  1.00  0.00           H  
ATOM    907  HZ1 LYS A  56      -6.110  48.033   9.887  1.00  0.00           H  
ATOM    908  HZ2 LYS A  56      -6.618  49.516   9.251  1.00  0.00           H  
ATOM    909  HZ3 LYS A  56      -4.971  49.133   9.291  1.00  0.00           H  
ATOM    910  N   ILE A  57      -6.249  48.524   1.453  1.00  0.00           N  
ATOM    911  CA  ILE A  57      -5.598  48.185   0.194  1.00  0.00           C  
ATOM    912  C   ILE A  57      -5.026  49.427  -0.481  1.00  0.00           C  
ATOM    913  O   ILE A  57      -4.033  49.351  -1.205  1.00  0.00           O  
ATOM    914  CB  ILE A  57      -6.573  47.492  -0.775  1.00  0.00           C  
ATOM    915  CG1 ILE A  57      -7.316  46.360  -0.064  1.00  0.00           C  
ATOM    916  CG2 ILE A  57      -5.826  46.962  -1.990  1.00  0.00           C  
ATOM    917  CD1 ILE A  57      -8.704  46.110  -0.610  1.00  0.00           C  
ATOM    918  H   ILE A  57      -7.225  48.460   1.520  1.00  0.00           H  
ATOM    919  HA  ILE A  57      -4.790  47.501   0.411  1.00  0.00           H  
ATOM    920  HB  ILE A  57      -7.289  48.225  -1.116  1.00  0.00           H  
ATOM    921 HG12 ILE A  57      -6.751  45.447  -0.166  1.00  0.00           H  
ATOM    922 HG13 ILE A  57      -7.411  46.605   0.984  1.00  0.00           H  
ATOM    923 HG21 ILE A  57      -4.766  46.955  -1.785  1.00  0.00           H  
ATOM    924 HG22 ILE A  57      -6.157  45.958  -2.205  1.00  0.00           H  
ATOM    925 HG23 ILE A  57      -6.024  47.598  -2.840  1.00  0.00           H  
ATOM    926 HD11 ILE A  57      -9.430  46.226   0.181  1.00  0.00           H  
ATOM    927 HD12 ILE A  57      -8.914  46.817  -1.399  1.00  0.00           H  
ATOM    928 HD13 ILE A  57      -8.760  45.104  -1.003  1.00  0.00           H  
ATOM    929  N   ASP A  58      -5.656  50.570  -0.236  1.00  0.00           N  
ATOM    930  CA  ASP A  58      -5.207  51.831  -0.817  1.00  0.00           C  
ATOM    931  C   ASP A  58      -4.167  52.501   0.075  1.00  0.00           C  
ATOM    932  O   ASP A  58      -3.607  53.539  -0.278  1.00  0.00           O  
ATOM    933  CB  ASP A  58      -6.395  52.770  -1.031  1.00  0.00           C  
ATOM    934  CG  ASP A  58      -7.041  52.587  -2.390  1.00  0.00           C  
ATOM    935  OD1 ASP A  58      -6.553  53.195  -3.366  1.00  0.00           O  
ATOM    936  OD2 ASP A  58      -8.034  51.836  -2.478  1.00  0.00           O  
ATOM    937  H   ASP A  58      -6.441  50.567   0.350  1.00  0.00           H  
ATOM    938  HA  ASP A  58      -4.756  51.613  -1.773  1.00  0.00           H  
ATOM    939  HB2 ASP A  58      -7.139  52.577  -0.271  1.00  0.00           H  
ATOM    940  HB3 ASP A  58      -6.058  53.793  -0.947  1.00  0.00           H  
ATOM    941  N   LYS A  59      -3.914  51.901   1.233  1.00  0.00           N  
ATOM    942  CA  LYS A  59      -2.942  52.439   2.177  1.00  0.00           C  
ATOM    943  C   LYS A  59      -1.724  51.527   2.283  1.00  0.00           C  
ATOM    944  O   LYS A  59      -0.959  51.604   3.245  1.00  0.00           O  
ATOM    945  CB  LYS A  59      -3.582  52.614   3.556  1.00  0.00           C  
ATOM    946  CG  LYS A  59      -4.769  53.561   3.561  1.00  0.00           C  
ATOM    947  CD  LYS A  59      -4.324  55.013   3.501  1.00  0.00           C  
ATOM    948  CE  LYS A  59      -5.414  55.907   2.931  1.00  0.00           C  
ATOM    949  NZ  LYS A  59      -6.569  56.036   3.861  1.00  0.00           N  
ATOM    950  H   LYS A  59      -4.393  51.076   1.459  1.00  0.00           H  
ATOM    951  HA  LYS A  59      -2.624  53.404   1.813  1.00  0.00           H  
ATOM    952  HB2 LYS A  59      -3.916  51.650   3.910  1.00  0.00           H  
ATOM    953  HB3 LYS A  59      -2.838  53.000   4.239  1.00  0.00           H  
ATOM    954  HG2 LYS A  59      -5.388  53.351   2.702  1.00  0.00           H  
ATOM    955  HG3 LYS A  59      -5.339  53.406   4.465  1.00  0.00           H  
ATOM    956  HD2 LYS A  59      -4.085  55.348   4.499  1.00  0.00           H  
ATOM    957  HD3 LYS A  59      -3.446  55.086   2.875  1.00  0.00           H  
ATOM    958  HE2 LYS A  59      -5.000  56.886   2.747  1.00  0.00           H  
ATOM    959  HE3 LYS A  59      -5.759  55.483   1.999  1.00  0.00           H  
ATOM    960  HZ1 LYS A  59      -6.697  57.032   4.136  1.00  0.00           H  
ATOM    961  HZ2 LYS A  59      -6.403  55.471   4.718  1.00  0.00           H  
ATOM    962  HZ3 LYS A  59      -7.440  55.700   3.401  1.00  0.00           H  
ATOM    963  N   HIS A  60      -1.549  50.663   1.287  1.00  0.00           N  
ATOM    964  CA  HIS A  60      -0.423  49.737   1.267  1.00  0.00           C  
ATOM    965  C   HIS A  60      -0.304  48.997   2.596  1.00  0.00           C  
ATOM    966  O   HIS A  60       0.762  48.969   3.210  1.00  0.00           O  
ATOM    967  CB  HIS A  60       0.876  50.488   0.972  1.00  0.00           C  
ATOM    968  CG  HIS A  60       0.928  51.078  -0.404  1.00  0.00           C  
ATOM    969  ND1 HIS A  60       2.076  51.112  -1.166  1.00  0.00           N  
ATOM    970  CD2 HIS A  60      -0.038  51.658  -1.155  1.00  0.00           C  
ATOM    971  CE1 HIS A  60       1.815  51.689  -2.326  1.00  0.00           C  
ATOM    972  NE2 HIS A  60       0.540  52.029  -2.344  1.00  0.00           N  
ATOM    973  H   HIS A  60      -2.193  50.649   0.549  1.00  0.00           H  
ATOM    974  HA  HIS A  60      -0.599  49.017   0.483  1.00  0.00           H  
ATOM    975  HB2 HIS A  60       0.989  51.294   1.682  1.00  0.00           H  
ATOM    976  HB3 HIS A  60       1.710  49.807   1.072  1.00  0.00           H  
ATOM    977  HD1 HIS A  60       2.953  50.766  -0.897  1.00  0.00           H  
ATOM    978  HD2 HIS A  60      -1.071  51.804  -0.871  1.00  0.00           H  
ATOM    979  HE1 HIS A  60       2.524  51.854  -3.123  1.00  0.00           H  
ATOM    980  HE2 HIS A  60       0.105  52.550  -3.051  1.00  0.00           H  
ATOM    981  N   ASN A  61      -1.407  48.396   3.033  1.00  0.00           N  
ATOM    982  CA  ASN A  61      -1.428  47.656   4.289  1.00  0.00           C  
ATOM    983  C   ASN A  61      -1.415  46.151   4.034  1.00  0.00           C  
ATOM    984  O   ASN A  61      -0.839  45.385   4.807  1.00  0.00           O  
ATOM    985  CB  ASN A  61      -2.662  48.036   5.109  1.00  0.00           C  
ATOM    986  CG  ASN A  61      -2.536  47.632   6.565  1.00  0.00           C  
ATOM    987  OD1 ASN A  61      -2.744  46.472   6.920  1.00  0.00           O  
ATOM    988  ND2 ASN A  61      -2.193  48.591   7.418  1.00  0.00           N  
ATOM    989  H   ASN A  61      -2.226  48.452   2.498  1.00  0.00           H  
ATOM    990  HA  ASN A  61      -0.541  47.923   4.845  1.00  0.00           H  
ATOM    991  HB2 ASN A  61      -2.801  49.107   5.063  1.00  0.00           H  
ATOM    992  HB3 ASN A  61      -3.529  47.546   4.692  1.00  0.00           H  
ATOM    993 HD21 ASN A  61      -2.042  49.493   7.064  1.00  0.00           H  
ATOM    994 HD22 ASN A  61      -2.103  48.358   8.365  1.00  0.00           H  
ATOM    995  N   TYR A  62      -2.055  45.737   2.948  1.00  0.00           N  
ATOM    996  CA  TYR A  62      -2.119  44.324   2.591  1.00  0.00           C  
ATOM    997  C   TYR A  62      -0.978  43.946   1.652  1.00  0.00           C  
ATOM    998  O   TYR A  62      -1.028  44.221   0.453  1.00  0.00           O  
ATOM    999  CB  TYR A  62      -3.463  44.004   1.933  1.00  0.00           C  
ATOM   1000  CG  TYR A  62      -4.633  44.058   2.890  1.00  0.00           C  
ATOM   1001  CD1 TYR A  62      -4.584  43.411   4.118  1.00  0.00           C  
ATOM   1002  CD2 TYR A  62      -5.788  44.758   2.565  1.00  0.00           C  
ATOM   1003  CE1 TYR A  62      -5.651  43.458   4.994  1.00  0.00           C  
ATOM   1004  CE2 TYR A  62      -6.861  44.812   3.435  1.00  0.00           C  
ATOM   1005  CZ  TYR A  62      -6.786  44.160   4.649  1.00  0.00           C  
ATOM   1006  OH  TYR A  62      -7.851  44.210   5.518  1.00  0.00           O  
ATOM   1007  H   TYR A  62      -2.495  46.395   2.371  1.00  0.00           H  
ATOM   1008  HA  TYR A  62      -2.028  43.749   3.500  1.00  0.00           H  
ATOM   1009  HB2 TYR A  62      -3.648  44.714   1.143  1.00  0.00           H  
ATOM   1010  HB3 TYR A  62      -3.423  43.008   1.515  1.00  0.00           H  
ATOM   1011  HD1 TYR A  62      -3.692  42.863   4.386  1.00  0.00           H  
ATOM   1012  HD2 TYR A  62      -5.844  45.268   1.614  1.00  0.00           H  
ATOM   1013  HE1 TYR A  62      -5.593  42.948   5.945  1.00  0.00           H  
ATOM   1014  HE2 TYR A  62      -7.750  45.360   3.165  1.00  0.00           H  
ATOM   1015  HH  TYR A  62      -8.482  44.867   5.214  1.00  0.00           H  
ATOM   1016  N   LEU A  63       0.050  43.313   2.206  1.00  0.00           N  
ATOM   1017  CA  LEU A  63       1.205  42.895   1.420  1.00  0.00           C  
ATOM   1018  C   LEU A  63       1.083  41.433   1.007  1.00  0.00           C  
ATOM   1019  O   LEU A  63       1.805  40.960   0.128  1.00  0.00           O  
ATOM   1020  CB  LEU A  63       2.493  43.105   2.218  1.00  0.00           C  
ATOM   1021  CG  LEU A  63       2.949  41.928   3.079  1.00  0.00           C  
ATOM   1022  CD1 LEU A  63       3.838  40.990   2.276  1.00  0.00           C  
ATOM   1023  CD2 LEU A  63       3.678  42.424   4.319  1.00  0.00           C  
ATOM   1024  H   LEU A  63       0.033  43.122   3.167  1.00  0.00           H  
ATOM   1025  HA  LEU A  63       1.239  43.506   0.530  1.00  0.00           H  
ATOM   1026  HB2 LEU A  63       3.284  43.327   1.516  1.00  0.00           H  
ATOM   1027  HB3 LEU A  63       2.343  43.955   2.869  1.00  0.00           H  
ATOM   1028  HG  LEU A  63       2.081  41.368   3.402  1.00  0.00           H  
ATOM   1029 HD11 LEU A  63       3.722  41.199   1.223  1.00  0.00           H  
ATOM   1030 HD12 LEU A  63       3.554  39.968   2.473  1.00  0.00           H  
ATOM   1031 HD13 LEU A  63       4.869  41.140   2.563  1.00  0.00           H  
ATOM   1032 HD21 LEU A  63       3.481  41.755   5.145  1.00  0.00           H  
ATOM   1033 HD22 LEU A  63       3.328  43.415   4.570  1.00  0.00           H  
ATOM   1034 HD23 LEU A  63       4.739  42.454   4.126  1.00  0.00           H  
ATOM   1035  N   THR A  64       0.161  40.717   1.645  1.00  0.00           N  
ATOM   1036  CA  THR A  64      -0.058  39.308   1.344  1.00  0.00           C  
ATOM   1037  C   THR A  64      -1.536  39.020   1.108  1.00  0.00           C  
ATOM   1038  O   THR A  64      -2.373  39.919   1.183  1.00  0.00           O  
ATOM   1039  CB  THR A  64       0.455  38.404   2.481  1.00  0.00           C  
ATOM   1040  OG1 THR A  64       0.355  39.090   3.734  1.00  0.00           O  
ATOM   1041  CG2 THR A  64       1.900  37.994   2.235  1.00  0.00           C  
ATOM   1042  H   THR A  64      -0.383  41.150   2.336  1.00  0.00           H  
ATOM   1043  HA  THR A  64       0.493  39.070   0.446  1.00  0.00           H  
ATOM   1044  HB  THR A  64      -0.155  37.514   2.516  1.00  0.00           H  
ATOM   1045  HG1 THR A  64       0.437  38.457   4.453  1.00  0.00           H  
ATOM   1046 HG21 THR A  64       2.255  38.455   1.326  1.00  0.00           H  
ATOM   1047 HG22 THR A  64       1.958  36.920   2.143  1.00  0.00           H  
ATOM   1048 HG23 THR A  64       2.511  38.317   3.064  1.00  0.00           H  
ATOM   1049  N   ALA A  65      -1.850  37.760   0.825  1.00  0.00           N  
ATOM   1050  CA  ALA A  65      -3.228  37.353   0.581  1.00  0.00           C  
ATOM   1051  C   ALA A  65      -3.911  36.926   1.876  1.00  0.00           C  
ATOM   1052  O   ALA A  65      -5.089  37.214   2.093  1.00  0.00           O  
ATOM   1053  CB  ALA A  65      -3.273  36.223  -0.437  1.00  0.00           C  
ATOM   1054  H   ALA A  65      -1.138  37.088   0.780  1.00  0.00           H  
ATOM   1055  HA  ALA A  65      -3.758  38.198   0.167  1.00  0.00           H  
ATOM   1056  HB1 ALA A  65      -3.942  35.450  -0.087  1.00  0.00           H  
ATOM   1057  HB2 ALA A  65      -3.625  36.605  -1.383  1.00  0.00           H  
ATOM   1058  HB3 ALA A  65      -2.282  35.811  -0.561  1.00  0.00           H  
ATOM   1059  N   LYS A  66      -3.166  36.239   2.735  1.00  0.00           N  
ATOM   1060  CA  LYS A  66      -3.699  35.775   4.010  1.00  0.00           C  
ATOM   1061  C   LYS A  66      -4.145  36.949   4.875  1.00  0.00           C  
ATOM   1062  O   LYS A  66      -5.202  36.904   5.504  1.00  0.00           O  
ATOM   1063  CB  LYS A  66      -2.648  34.949   4.755  1.00  0.00           C  
ATOM   1064  CG  LYS A  66      -3.203  34.196   5.953  1.00  0.00           C  
ATOM   1065  CD  LYS A  66      -4.014  32.985   5.524  1.00  0.00           C  
ATOM   1066  CE  LYS A  66      -3.134  31.756   5.356  1.00  0.00           C  
ATOM   1067  NZ  LYS A  66      -3.769  30.734   4.478  1.00  0.00           N  
ATOM   1068  H   LYS A  66      -2.233  36.042   2.506  1.00  0.00           H  
ATOM   1069  HA  LYS A  66      -4.556  35.150   3.804  1.00  0.00           H  
ATOM   1070  HB2 LYS A  66      -2.222  34.229   4.071  1.00  0.00           H  
ATOM   1071  HB3 LYS A  66      -1.867  35.610   5.102  1.00  0.00           H  
ATOM   1072  HG2 LYS A  66      -2.380  33.865   6.570  1.00  0.00           H  
ATOM   1073  HG3 LYS A  66      -3.838  34.861   6.521  1.00  0.00           H  
ATOM   1074  HD2 LYS A  66      -4.761  32.779   6.276  1.00  0.00           H  
ATOM   1075  HD3 LYS A  66      -4.498  33.202   4.582  1.00  0.00           H  
ATOM   1076  HE2 LYS A  66      -2.194  32.059   4.921  1.00  0.00           H  
ATOM   1077  HE3 LYS A  66      -2.956  31.322   6.329  1.00  0.00           H  
ATOM   1078  HZ1 LYS A  66      -3.598  29.781   4.858  1.00  0.00           H  
ATOM   1079  HZ2 LYS A  66      -3.371  30.791   3.519  1.00  0.00           H  
ATOM   1080  HZ3 LYS A  66      -4.795  30.896   4.427  1.00  0.00           H  
ATOM   1081  N   ASP A  67      -3.332  37.999   4.901  1.00  0.00           N  
ATOM   1082  CA  ASP A  67      -3.643  39.187   5.688  1.00  0.00           C  
ATOM   1083  C   ASP A  67      -4.941  39.831   5.209  1.00  0.00           C  
ATOM   1084  O   ASP A  67      -5.573  40.596   5.938  1.00  0.00           O  
ATOM   1085  CB  ASP A  67      -2.498  40.198   5.602  1.00  0.00           C  
ATOM   1086  CG  ASP A  67      -2.547  41.225   6.715  1.00  0.00           C  
ATOM   1087  OD1 ASP A  67      -3.656  41.698   7.038  1.00  0.00           O  
ATOM   1088  OD2 ASP A  67      -1.475  41.556   7.265  1.00  0.00           O  
ATOM   1089  H   ASP A  67      -2.502  37.976   4.379  1.00  0.00           H  
ATOM   1090  HA  ASP A  67      -3.766  38.882   6.716  1.00  0.00           H  
ATOM   1091  HB2 ASP A  67      -1.557  39.671   5.665  1.00  0.00           H  
ATOM   1092  HB3 ASP A  67      -2.553  40.715   4.655  1.00  0.00           H  
ATOM   1093  N   PHE A  68      -5.333  39.516   3.979  1.00  0.00           N  
ATOM   1094  CA  PHE A  68      -6.556  40.064   3.402  1.00  0.00           C  
ATOM   1095  C   PHE A  68      -7.760  39.197   3.754  1.00  0.00           C  
ATOM   1096  O   PHE A  68      -8.805  39.703   4.167  1.00  0.00           O  
ATOM   1097  CB  PHE A  68      -6.421  40.177   1.882  1.00  0.00           C  
ATOM   1098  CG  PHE A  68      -7.729  40.402   1.180  1.00  0.00           C  
ATOM   1099  CD1 PHE A  68      -8.295  41.665   1.127  1.00  0.00           C  
ATOM   1100  CD2 PHE A  68      -8.393  39.349   0.572  1.00  0.00           C  
ATOM   1101  CE1 PHE A  68      -9.499  41.875   0.481  1.00  0.00           C  
ATOM   1102  CE2 PHE A  68      -9.597  39.552  -0.076  1.00  0.00           C  
ATOM   1103  CZ  PHE A  68     -10.151  40.817  -0.121  1.00  0.00           C  
ATOM   1104  H   PHE A  68      -4.788  38.900   3.447  1.00  0.00           H  
ATOM   1105  HA  PHE A  68      -6.703  41.050   3.817  1.00  0.00           H  
ATOM   1106  HB2 PHE A  68      -5.772  41.008   1.646  1.00  0.00           H  
ATOM   1107  HB3 PHE A  68      -5.988  39.267   1.498  1.00  0.00           H  
ATOM   1108  HD1 PHE A  68      -7.785  42.495   1.598  1.00  0.00           H  
ATOM   1109  HD2 PHE A  68      -7.963  38.359   0.608  1.00  0.00           H  
ATOM   1110  HE1 PHE A  68      -9.929  42.866   0.447  1.00  0.00           H  
ATOM   1111  HE2 PHE A  68     -10.105  38.723  -0.545  1.00  0.00           H  
ATOM   1112  HZ  PHE A  68     -11.091  40.978  -0.627  1.00  0.00           H  
ATOM   1113  N   LEU A  69      -7.608  37.888   3.587  1.00  0.00           N  
ATOM   1114  CA  LEU A  69      -8.683  36.949   3.886  1.00  0.00           C  
ATOM   1115  C   LEU A  69      -9.071  37.016   5.359  1.00  0.00           C  
ATOM   1116  O   LEU A  69     -10.252  37.091   5.700  1.00  0.00           O  
ATOM   1117  CB  LEU A  69      -8.258  35.524   3.523  1.00  0.00           C  
ATOM   1118  CG  LEU A  69      -8.544  35.084   2.087  1.00  0.00           C  
ATOM   1119  CD1 LEU A  69      -7.814  33.788   1.772  1.00  0.00           C  
ATOM   1120  CD2 LEU A  69     -10.041  34.921   1.868  1.00  0.00           C  
ATOM   1121  H   LEU A  69      -6.753  37.544   3.255  1.00  0.00           H  
ATOM   1122  HA  LEU A  69      -9.539  37.224   3.288  1.00  0.00           H  
ATOM   1123  HB2 LEU A  69      -7.195  35.445   3.688  1.00  0.00           H  
ATOM   1124  HB3 LEU A  69      -8.775  34.847   4.188  1.00  0.00           H  
ATOM   1125  HG  LEU A  69      -8.186  35.843   1.406  1.00  0.00           H  
ATOM   1126 HD11 LEU A  69      -6.757  33.917   1.952  1.00  0.00           H  
ATOM   1127 HD12 LEU A  69      -7.973  33.528   0.735  1.00  0.00           H  
ATOM   1128 HD13 LEU A  69      -8.193  32.997   2.402  1.00  0.00           H  
ATOM   1129 HD21 LEU A  69     -10.235  34.752   0.819  1.00  0.00           H  
ATOM   1130 HD22 LEU A  69     -10.551  35.819   2.188  1.00  0.00           H  
ATOM   1131 HD23 LEU A  69     -10.400  34.079   2.441  1.00  0.00           H  
ATOM   1132  N   LYS A  70      -8.068  36.991   6.231  1.00  0.00           N  
ATOM   1133  CA  LYS A  70      -8.303  37.053   7.670  1.00  0.00           C  
ATOM   1134  C   LYS A  70      -9.222  38.218   8.021  1.00  0.00           C  
ATOM   1135  O   LYS A  70      -9.994  38.145   8.977  1.00  0.00           O  
ATOM   1136  CB  LYS A  70      -6.975  37.193   8.418  1.00  0.00           C  
ATOM   1137  CG  LYS A  70      -6.496  38.629   8.541  1.00  0.00           C  
ATOM   1138  CD  LYS A  70      -5.231  38.724   9.379  1.00  0.00           C  
ATOM   1139  CE  LYS A  70      -4.931  40.163   9.773  1.00  0.00           C  
ATOM   1140  NZ  LYS A  70      -3.901  40.240  10.847  1.00  0.00           N  
ATOM   1141  H   LYS A  70      -7.148  36.930   5.900  1.00  0.00           H  
ATOM   1142  HA  LYS A  70      -8.779  36.131   7.968  1.00  0.00           H  
ATOM   1143  HB2 LYS A  70      -7.092  36.788   9.412  1.00  0.00           H  
ATOM   1144  HB3 LYS A  70      -6.219  36.626   7.894  1.00  0.00           H  
ATOM   1145  HG2 LYS A  70      -6.290  39.016   7.554  1.00  0.00           H  
ATOM   1146  HG3 LYS A  70      -7.271  39.220   9.008  1.00  0.00           H  
ATOM   1147  HD2 LYS A  70      -5.358  38.136  10.276  1.00  0.00           H  
ATOM   1148  HD3 LYS A  70      -4.400  38.336   8.806  1.00  0.00           H  
ATOM   1149  HE2 LYS A  70      -4.574  40.693   8.904  1.00  0.00           H  
ATOM   1150  HE3 LYS A  70      -5.843  40.623  10.126  1.00  0.00           H  
ATOM   1151  HZ1 LYS A  70      -3.441  41.172  10.833  1.00  0.00           H  
ATOM   1152  HZ2 LYS A  70      -3.178  39.507  10.701  1.00  0.00           H  
ATOM   1153  HZ3 LYS A  70      -4.343  40.096  11.777  1.00  0.00           H  
ATOM   1154  N   ASP A  71      -9.135  39.291   7.242  1.00  0.00           N  
ATOM   1155  CA  ASP A  71      -9.962  40.470   7.470  1.00  0.00           C  
ATOM   1156  C   ASP A  71     -11.408  40.208   7.061  1.00  0.00           C  
ATOM   1157  O   ASP A  71     -12.338  40.770   7.639  1.00  0.00           O  
ATOM   1158  CB  ASP A  71      -9.408  41.665   6.692  1.00  0.00           C  
ATOM   1159  CG  ASP A  71     -10.400  42.808   6.602  1.00  0.00           C  
ATOM   1160  OD1 ASP A  71     -11.460  42.625   5.966  1.00  0.00           O  
ATOM   1161  OD2 ASP A  71     -10.119  43.883   7.168  1.00  0.00           O  
ATOM   1162  H   ASP A  71      -8.501  39.288   6.495  1.00  0.00           H  
ATOM   1163  HA  ASP A  71      -9.935  40.695   8.526  1.00  0.00           H  
ATOM   1164  HB2 ASP A  71      -8.517  42.026   7.185  1.00  0.00           H  
ATOM   1165  HB3 ASP A  71      -9.157  41.349   5.691  1.00  0.00           H  
ATOM   1166  N   ILE A  72     -11.590  39.351   6.062  1.00  0.00           N  
ATOM   1167  CA  ILE A  72     -12.922  39.015   5.577  1.00  0.00           C  
ATOM   1168  C   ILE A  72     -13.638  38.078   6.543  1.00  0.00           C  
ATOM   1169  O   ILE A  72     -14.854  38.161   6.718  1.00  0.00           O  
ATOM   1170  CB  ILE A  72     -12.865  38.355   4.187  1.00  0.00           C  
ATOM   1171  CG1 ILE A  72     -12.312  39.338   3.154  1.00  0.00           C  
ATOM   1172  CG2 ILE A  72     -14.246  37.866   3.775  1.00  0.00           C  
ATOM   1173  CD1 ILE A  72     -13.212  40.529   2.909  1.00  0.00           C  
ATOM   1174  H   ILE A  72     -10.808  38.935   5.641  1.00  0.00           H  
ATOM   1175  HA  ILE A  72     -13.487  39.932   5.495  1.00  0.00           H  
ATOM   1176  HB  ILE A  72     -12.210  37.499   4.246  1.00  0.00           H  
ATOM   1177 HG12 ILE A  72     -11.357  39.709   3.493  1.00  0.00           H  
ATOM   1178 HG13 ILE A  72     -12.179  38.823   2.213  1.00  0.00           H  
ATOM   1179 HG21 ILE A  72     -14.998  38.512   4.203  1.00  0.00           H  
ATOM   1180 HG22 ILE A  72     -14.328  37.885   2.698  1.00  0.00           H  
ATOM   1181 HG23 ILE A  72     -14.393  36.858   4.130  1.00  0.00           H  
ATOM   1182 HD11 ILE A  72     -12.960  40.983   1.962  1.00  0.00           H  
ATOM   1183 HD12 ILE A  72     -14.241  40.205   2.892  1.00  0.00           H  
ATOM   1184 HD13 ILE A  72     -13.075  41.251   3.701  1.00  0.00           H  
ATOM   1185  N   ASP A  73     -12.877  37.188   7.171  1.00  0.00           N  
ATOM   1186  CA  ASP A  73     -13.438  36.237   8.122  1.00  0.00           C  
ATOM   1187  C   ASP A  73     -13.843  36.937   9.415  1.00  0.00           C  
ATOM   1188  O   ASP A  73     -14.567  36.374  10.238  1.00  0.00           O  
ATOM   1189  CB  ASP A  73     -12.429  35.128   8.423  1.00  0.00           C  
ATOM   1190  CG  ASP A  73     -13.087  33.883   8.985  1.00  0.00           C  
ATOM   1191  OD1 ASP A  73     -14.095  34.020   9.709  1.00  0.00           O  
ATOM   1192  OD2 ASP A  73     -12.593  32.773   8.702  1.00  0.00           O  
ATOM   1193  H   ASP A  73     -11.913  37.172   6.989  1.00  0.00           H  
ATOM   1194  HA  ASP A  73     -14.317  35.800   7.674  1.00  0.00           H  
ATOM   1195  HB2 ASP A  73     -11.916  34.861   7.511  1.00  0.00           H  
ATOM   1196  HB3 ASP A  73     -11.710  35.490   9.143  1.00  0.00           H  
ATOM   1197  N   LEU A  74     -13.372  38.168   9.589  1.00  0.00           N  
ATOM   1198  CA  LEU A  74     -13.685  38.945  10.783  1.00  0.00           C  
ATOM   1199  C   LEU A  74     -15.057  39.599  10.663  1.00  0.00           C  
ATOM   1200  O   LEU A  74     -15.761  39.775  11.658  1.00  0.00           O  
ATOM   1201  CB  LEU A  74     -12.615  40.014  11.013  1.00  0.00           C  
ATOM   1202  CG  LEU A  74     -12.673  40.743  12.356  1.00  0.00           C  
ATOM   1203  CD1 LEU A  74     -12.354  39.787  13.496  1.00  0.00           C  
ATOM   1204  CD2 LEU A  74     -11.714  41.923  12.364  1.00  0.00           C  
ATOM   1205  H   LEU A  74     -12.801  38.563   8.898  1.00  0.00           H  
ATOM   1206  HA  LEU A  74     -13.694  38.270  11.625  1.00  0.00           H  
ATOM   1207  HB2 LEU A  74     -11.650  39.538  10.937  1.00  0.00           H  
ATOM   1208  HB3 LEU A  74     -12.714  40.753  10.231  1.00  0.00           H  
ATOM   1209  HG  LEU A  74     -13.674  41.123  12.511  1.00  0.00           H  
ATOM   1210 HD11 LEU A  74     -11.452  40.109  13.993  1.00  0.00           H  
ATOM   1211 HD12 LEU A  74     -12.213  38.791  13.103  1.00  0.00           H  
ATOM   1212 HD13 LEU A  74     -13.173  39.782  14.201  1.00  0.00           H  
ATOM   1213 HD21 LEU A  74     -10.794  41.643  11.873  1.00  0.00           H  
ATOM   1214 HD22 LEU A  74     -11.504  42.210  13.385  1.00  0.00           H  
ATOM   1215 HD23 LEU A  74     -12.163  42.756  11.841  1.00  0.00           H  
ATOM   1216  N   ILE A  75     -15.432  39.956   9.439  1.00  0.00           N  
ATOM   1217  CA  ILE A  75     -16.721  40.589   9.189  1.00  0.00           C  
ATOM   1218  C   ILE A  75     -17.863  39.594   9.365  1.00  0.00           C  
ATOM   1219  O   ILE A  75     -18.969  39.967   9.760  1.00  0.00           O  
ATOM   1220  CB  ILE A  75     -16.790  41.186   7.771  1.00  0.00           C  
ATOM   1221  CG1 ILE A  75     -15.565  42.064   7.505  1.00  0.00           C  
ATOM   1222  CG2 ILE A  75     -18.071  41.988   7.596  1.00  0.00           C  
ATOM   1223  CD1 ILE A  75     -15.331  42.344   6.036  1.00  0.00           C  
ATOM   1224  H   ILE A  75     -14.826  39.791   8.687  1.00  0.00           H  
ATOM   1225  HA  ILE A  75     -16.843  41.391   9.903  1.00  0.00           H  
ATOM   1226  HB  ILE A  75     -16.802  40.373   7.062  1.00  0.00           H  
ATOM   1227 HG12 ILE A  75     -15.692  43.010   8.006  1.00  0.00           H  
ATOM   1228 HG13 ILE A  75     -14.686  41.569   7.894  1.00  0.00           H  
ATOM   1229 HG21 ILE A  75     -17.825  43.029   7.442  1.00  0.00           H  
ATOM   1230 HG22 ILE A  75     -18.613  41.616   6.740  1.00  0.00           H  
ATOM   1231 HG23 ILE A  75     -18.682  41.888   8.480  1.00  0.00           H  
ATOM   1232 HD11 ILE A  75     -14.271  42.316   5.829  1.00  0.00           H  
ATOM   1233 HD12 ILE A  75     -15.834  41.597   5.442  1.00  0.00           H  
ATOM   1234 HD13 ILE A  75     -15.719  43.322   5.790  1.00  0.00           H  
ATOM   1235  N   CYS A  76     -17.589  38.329   9.073  1.00  0.00           N  
ATOM   1236  CA  CYS A  76     -18.594  37.278   9.199  1.00  0.00           C  
ATOM   1237  C   CYS A  76     -18.863  36.958  10.665  1.00  0.00           C  
ATOM   1238  O   CYS A  76     -20.010  36.762  11.069  1.00  0.00           O  
ATOM   1239  CB  CYS A  76     -18.140  36.017   8.464  1.00  0.00           C  
ATOM   1240  SG  CYS A  76     -17.822  36.264   6.701  1.00  0.00           S  
ATOM   1241  H   CYS A  76     -16.690  38.092   8.763  1.00  0.00           H  
ATOM   1242  HA  CYS A  76     -19.506  37.639   8.749  1.00  0.00           H  
ATOM   1243  HB2 CYS A  76     -17.227  35.656   8.914  1.00  0.00           H  
ATOM   1244  HB3 CYS A  76     -18.904  35.260   8.558  1.00  0.00           H  
ATOM   1245  HG  CYS A  76     -18.545  35.382   6.027  1.00  0.00           H  
ATOM   1246  N   SER A  77     -17.798  36.904  11.460  1.00  0.00           N  
ATOM   1247  CA  SER A  77     -17.918  36.602  12.880  1.00  0.00           C  
ATOM   1248  C   SER A  77     -18.688  37.700  13.607  1.00  0.00           C  
ATOM   1249  O   SER A  77     -19.696  37.438  14.262  1.00  0.00           O  
ATOM   1250  CB  SER A  77     -16.533  36.435  13.507  1.00  0.00           C  
ATOM   1251  OG  SER A  77     -16.585  35.593  14.645  1.00  0.00           O  
ATOM   1252  H   SER A  77     -16.910  37.070  11.079  1.00  0.00           H  
ATOM   1253  HA  SER A  77     -18.461  35.674  12.977  1.00  0.00           H  
ATOM   1254  HB2 SER A  77     -15.863  35.997  12.782  1.00  0.00           H  
ATOM   1255  HB3 SER A  77     -16.157  37.403  13.806  1.00  0.00           H  
ATOM   1256  HG  SER A  77     -15.698  35.303  14.871  1.00  0.00           H  
ATOM   1257  N   ASN A  78     -18.204  38.933  13.485  1.00  0.00           N  
ATOM   1258  CA  ASN A  78     -18.846  40.073  14.131  1.00  0.00           C  
ATOM   1259  C   ASN A  78     -20.341  40.098  13.828  1.00  0.00           C  
ATOM   1260  O   ASN A  78     -21.168  40.147  14.738  1.00  0.00           O  
ATOM   1261  CB  ASN A  78     -18.198  41.378  13.666  1.00  0.00           C  
ATOM   1262  CG  ASN A  78     -16.725  41.451  14.020  1.00  0.00           C  
ATOM   1263  OD1 ASN A  78     -16.226  40.653  14.814  1.00  0.00           O  
ATOM   1264  ND2 ASN A  78     -16.022  42.412  13.431  1.00  0.00           N  
ATOM   1265  H   ASN A  78     -17.397  39.079  12.950  1.00  0.00           H  
ATOM   1266  HA  ASN A  78     -18.708  39.971  15.197  1.00  0.00           H  
ATOM   1267  HB2 ASN A  78     -18.294  41.460  12.593  1.00  0.00           H  
ATOM   1268  HB3 ASN A  78     -18.704  42.211  14.133  1.00  0.00           H  
ATOM   1269 HD21 ASN A  78     -16.486  43.011  12.811  1.00  0.00           H  
ATOM   1270 HD22 ASN A  78     -15.067  42.481  13.642  1.00  0.00           H  
ATOM   1271  N   ALA A  79     -20.680  40.063  12.544  1.00  0.00           N  
ATOM   1272  CA  ALA A  79     -22.075  40.080  12.121  1.00  0.00           C  
ATOM   1273  C   ALA A  79     -22.936  39.210  13.033  1.00  0.00           C  
ATOM   1274  O   ALA A  79     -24.124  39.473  13.217  1.00  0.00           O  
ATOM   1275  CB  ALA A  79     -22.195  39.613  10.678  1.00  0.00           C  
ATOM   1276  H   ALA A  79     -19.976  40.023  11.865  1.00  0.00           H  
ATOM   1277  HA  ALA A  79     -22.428  41.099  12.175  1.00  0.00           H  
ATOM   1278  HB1 ALA A  79     -23.152  39.918  10.281  1.00  0.00           H  
ATOM   1279  HB2 ALA A  79     -21.404  40.054  10.090  1.00  0.00           H  
ATOM   1280  HB3 ALA A  79     -22.116  38.537  10.640  1.00  0.00           H  
ATOM   1281  N   LEU A  80     -22.327  38.175  13.601  1.00  0.00           N  
ATOM   1282  CA  LEU A  80     -23.038  37.266  14.493  1.00  0.00           C  
ATOM   1283  C   LEU A  80     -22.933  37.733  15.942  1.00  0.00           C  
ATOM   1284  O   LEU A  80     -23.894  37.639  16.705  1.00  0.00           O  
ATOM   1285  CB  LEU A  80     -22.479  35.849  14.362  1.00  0.00           C  
ATOM   1286  CG  LEU A  80     -22.655  35.182  12.997  1.00  0.00           C  
ATOM   1287  CD1 LEU A  80     -21.895  33.865  12.944  1.00  0.00           C  
ATOM   1288  CD2 LEU A  80     -24.130  34.961  12.697  1.00  0.00           C  
ATOM   1289  H   LEU A  80     -21.378  38.016  13.417  1.00  0.00           H  
ATOM   1290  HA  LEU A  80     -24.078  37.263  14.204  1.00  0.00           H  
ATOM   1291  HB2 LEU A  80     -21.422  35.889  14.576  1.00  0.00           H  
ATOM   1292  HB3 LEU A  80     -22.971  35.230  15.099  1.00  0.00           H  
ATOM   1293  HG  LEU A  80     -22.251  35.831  12.232  1.00  0.00           H  
ATOM   1294 HD11 LEU A  80     -21.226  33.802  13.789  1.00  0.00           H  
ATOM   1295 HD12 LEU A  80     -21.326  33.815  12.028  1.00  0.00           H  
ATOM   1296 HD13 LEU A  80     -22.597  33.045  12.976  1.00  0.00           H  
ATOM   1297 HD21 LEU A  80     -24.232  34.460  11.746  1.00  0.00           H  
ATOM   1298 HD22 LEU A  80     -24.636  35.915  12.658  1.00  0.00           H  
ATOM   1299 HD23 LEU A  80     -24.568  34.352  13.475  1.00  0.00           H  
ATOM   1300  N   GLU A  81     -21.761  38.240  16.312  1.00  0.00           N  
ATOM   1301  CA  GLU A  81     -21.533  38.723  17.669  1.00  0.00           C  
ATOM   1302  C   GLU A  81     -22.711  39.563  18.153  1.00  0.00           C  
ATOM   1303  O   GLU A  81     -23.369  39.221  19.136  1.00  0.00           O  
ATOM   1304  CB  GLU A  81     -20.245  39.547  17.730  1.00  0.00           C  
ATOM   1305  CG  GLU A  81     -18.995  38.709  17.935  1.00  0.00           C  
ATOM   1306  CD  GLU A  81     -18.897  38.140  19.337  1.00  0.00           C  
ATOM   1307  OE1 GLU A  81     -19.949  38.007  19.997  1.00  0.00           O  
ATOM   1308  OE2 GLU A  81     -17.770  37.827  19.774  1.00  0.00           O  
ATOM   1309  H   GLU A  81     -21.034  38.289  15.658  1.00  0.00           H  
ATOM   1310  HA  GLU A  81     -21.430  37.864  18.315  1.00  0.00           H  
ATOM   1311  HB2 GLU A  81     -20.139  40.096  16.806  1.00  0.00           H  
ATOM   1312  HB3 GLU A  81     -20.320  40.248  18.548  1.00  0.00           H  
ATOM   1313  HG2 GLU A  81     -19.007  37.890  17.231  1.00  0.00           H  
ATOM   1314  HG3 GLU A  81     -18.129  39.327  17.752  1.00  0.00           H  
ATOM   1315  N   TYR A  82     -22.971  40.663  17.455  1.00  0.00           N  
ATOM   1316  CA  TYR A  82     -24.068  41.554  17.815  1.00  0.00           C  
ATOM   1317  C   TYR A  82     -25.133  41.576  16.722  1.00  0.00           C  
ATOM   1318  O   TYR A  82     -25.014  42.305  15.739  1.00  0.00           O  
ATOM   1319  CB  TYR A  82     -23.543  42.971  18.059  1.00  0.00           C  
ATOM   1320  CG  TYR A  82     -22.263  43.012  18.863  1.00  0.00           C  
ATOM   1321  CD1 TYR A  82     -21.066  42.558  18.324  1.00  0.00           C  
ATOM   1322  CD2 TYR A  82     -22.251  43.503  20.162  1.00  0.00           C  
ATOM   1323  CE1 TYR A  82     -19.894  42.593  19.055  1.00  0.00           C  
ATOM   1324  CE2 TYR A  82     -21.084  43.544  20.900  1.00  0.00           C  
ATOM   1325  CZ  TYR A  82     -19.908  43.088  20.342  1.00  0.00           C  
ATOM   1326  OH  TYR A  82     -18.745  43.124  21.075  1.00  0.00           O  
ATOM   1327  H   TYR A  82     -22.412  40.883  16.681  1.00  0.00           H  
ATOM   1328  HA  TYR A  82     -24.511  41.184  18.727  1.00  0.00           H  
ATOM   1329  HB2 TYR A  82     -23.352  43.445  17.109  1.00  0.00           H  
ATOM   1330  HB3 TYR A  82     -24.291  43.536  18.595  1.00  0.00           H  
ATOM   1331  HD1 TYR A  82     -21.058  42.171  17.315  1.00  0.00           H  
ATOM   1332  HD2 TYR A  82     -23.175  43.860  20.597  1.00  0.00           H  
ATOM   1333  HE1 TYR A  82     -18.973  42.235  18.618  1.00  0.00           H  
ATOM   1334  HE2 TYR A  82     -21.096  43.930  21.909  1.00  0.00           H  
ATOM   1335  HH  TYR A  82     -18.939  43.407  21.971  1.00  0.00           H  
ATOM   1336  N   ASN A  83     -26.174  40.771  16.905  1.00  0.00           N  
ATOM   1337  CA  ASN A  83     -27.261  40.696  15.935  1.00  0.00           C  
ATOM   1338  C   ASN A  83     -28.584  40.375  16.626  1.00  0.00           C  
ATOM   1339  O   ASN A  83     -28.652  39.557  17.542  1.00  0.00           O  
ATOM   1340  CB  ASN A  83     -26.956  39.636  14.876  1.00  0.00           C  
ATOM   1341  CG  ASN A  83     -27.619  39.940  13.546  1.00  0.00           C  
ATOM   1342  OD1 ASN A  83     -28.798  39.646  13.346  1.00  0.00           O  
ATOM   1343  ND2 ASN A  83     -26.863  40.531  12.629  1.00  0.00           N  
ATOM   1344  H   ASN A  83     -26.212  40.213  17.710  1.00  0.00           H  
ATOM   1345  HA  ASN A  83     -27.344  41.660  15.455  1.00  0.00           H  
ATOM   1346  HB2 ASN A  83     -25.888  39.588  14.721  1.00  0.00           H  
ATOM   1347  HB3 ASN A  83     -27.309  38.676  15.222  1.00  0.00           H  
ATOM   1348 HD21 ASN A  83     -25.931  40.735  12.859  1.00  0.00           H  
ATOM   1349 HD22 ASN A  83     -27.266  40.739  11.761  1.00  0.00           H  
ATOM   1350  N   PRO A  84     -29.662  41.035  16.175  1.00  0.00           N  
ATOM   1351  CA  PRO A  84     -31.003  40.836  16.734  1.00  0.00           C  
ATOM   1352  C   PRO A  84     -31.576  39.466  16.390  1.00  0.00           C  
ATOM   1353  O   PRO A  84     -31.381  38.960  15.285  1.00  0.00           O  
ATOM   1354  CB  PRO A  84     -31.829  41.943  16.074  1.00  0.00           C  
ATOM   1355  CG  PRO A  84     -31.114  42.241  14.801  1.00  0.00           C  
ATOM   1356  CD  PRO A  84     -29.654  42.025  15.084  1.00  0.00           C  
ATOM   1357  HA  PRO A  84     -31.009  40.970  17.806  1.00  0.00           H  
ATOM   1358  HB2 PRO A  84     -32.833  41.585  15.890  1.00  0.00           H  
ATOM   1359  HB3 PRO A  84     -31.861  42.807  16.720  1.00  0.00           H  
ATOM   1360  HG2 PRO A  84     -31.450  41.570  14.025  1.00  0.00           H  
ATOM   1361  HG3 PRO A  84     -31.292  43.267  14.513  1.00  0.00           H  
ATOM   1362  HD2 PRO A  84     -29.154  41.633  14.211  1.00  0.00           H  
ATOM   1363  HD3 PRO A  84     -29.191  42.947  15.405  1.00  0.00           H  
ATOM   1364  N   ASP A  85     -32.284  38.871  17.344  1.00  0.00           N  
ATOM   1365  CA  ASP A  85     -32.888  37.558  17.141  1.00  0.00           C  
ATOM   1366  C   ASP A  85     -34.399  37.619  17.339  1.00  0.00           C  
ATOM   1367  O   ASP A  85     -34.925  38.581  17.901  1.00  0.00           O  
ATOM   1368  CB  ASP A  85     -32.276  36.538  18.103  1.00  0.00           C  
ATOM   1369  CG  ASP A  85     -32.228  37.045  19.531  1.00  0.00           C  
ATOM   1370  OD1 ASP A  85     -33.306  37.193  20.144  1.00  0.00           O  
ATOM   1371  OD2 ASP A  85     -31.113  37.294  20.036  1.00  0.00           O  
ATOM   1372  H   ASP A  85     -32.404  39.325  18.204  1.00  0.00           H  
ATOM   1373  HA  ASP A  85     -32.682  37.252  16.127  1.00  0.00           H  
ATOM   1374  HB2 ASP A  85     -32.866  35.634  18.081  1.00  0.00           H  
ATOM   1375  HB3 ASP A  85     -31.268  36.314  17.785  1.00  0.00           H  
ATOM   1376  N   LYS A  86     -35.094  36.587  16.874  1.00  0.00           N  
ATOM   1377  CA  LYS A  86     -36.546  36.522  16.999  1.00  0.00           C  
ATOM   1378  C   LYS A  86     -37.215  37.557  16.101  1.00  0.00           C  
ATOM   1379  O   LYS A  86     -38.295  38.058  16.415  1.00  0.00           O  
ATOM   1380  CB  LYS A  86     -36.963  36.746  18.454  1.00  0.00           C  
ATOM   1381  CG  LYS A  86     -38.321  36.157  18.794  1.00  0.00           C  
ATOM   1382  CD  LYS A  86     -38.307  34.639  18.717  1.00  0.00           C  
ATOM   1383  CE  LYS A  86     -39.351  34.025  19.636  1.00  0.00           C  
ATOM   1384  NZ  LYS A  86     -39.192  32.548  19.748  1.00  0.00           N  
ATOM   1385  H   LYS A  86     -34.618  35.850  16.435  1.00  0.00           H  
ATOM   1386  HA  LYS A  86     -36.860  35.537  16.689  1.00  0.00           H  
ATOM   1387  HB2 LYS A  86     -36.225  36.294  19.101  1.00  0.00           H  
ATOM   1388  HB3 LYS A  86     -36.996  37.809  18.647  1.00  0.00           H  
ATOM   1389  HG2 LYS A  86     -38.591  36.454  19.797  1.00  0.00           H  
ATOM   1390  HG3 LYS A  86     -39.053  36.537  18.096  1.00  0.00           H  
ATOM   1391  HD2 LYS A  86     -38.513  34.337  17.702  1.00  0.00           H  
ATOM   1392  HD3 LYS A  86     -37.329  34.283  19.009  1.00  0.00           H  
ATOM   1393  HE2 LYS A  86     -39.254  34.465  20.616  1.00  0.00           H  
ATOM   1394  HE3 LYS A  86     -40.333  34.243  19.240  1.00  0.00           H  
ATOM   1395  HZ1 LYS A  86     -38.247  32.265  19.416  1.00  0.00           H  
ATOM   1396  HZ2 LYS A  86     -39.909  32.066  19.171  1.00  0.00           H  
ATOM   1397  HZ3 LYS A  86     -39.302  32.252  20.739  1.00  0.00           H  
ATOM   1398  N   ASP A  87     -36.569  37.872  14.984  1.00  0.00           N  
ATOM   1399  CA  ASP A  87     -37.105  38.846  14.040  1.00  0.00           C  
ATOM   1400  C   ASP A  87     -36.953  38.352  12.605  1.00  0.00           C  
ATOM   1401  O   ASP A  87     -35.980  37.685  12.251  1.00  0.00           O  
ATOM   1402  CB  ASP A  87     -36.398  40.192  14.207  1.00  0.00           C  
ATOM   1403  CG  ASP A  87     -36.268  40.601  15.660  1.00  0.00           C  
ATOM   1404  OD1 ASP A  87     -37.287  40.563  16.382  1.00  0.00           O  
ATOM   1405  OD2 ASP A  87     -35.147  40.958  16.078  1.00  0.00           O  
ATOM   1406  H   ASP A  87     -35.712  37.438  14.789  1.00  0.00           H  
ATOM   1407  HA  ASP A  87     -38.156  38.973  14.254  1.00  0.00           H  
ATOM   1408  HB2 ASP A  87     -35.408  40.126  13.781  1.00  0.00           H  
ATOM   1409  HB3 ASP A  87     -36.960  40.953  13.686  1.00  0.00           H  
ATOM   1410  N   PRO A  88     -37.938  38.685  11.757  1.00  0.00           N  
ATOM   1411  CA  PRO A  88     -37.936  38.284  10.347  1.00  0.00           C  
ATOM   1412  C   PRO A  88     -36.863  39.008   9.539  1.00  0.00           C  
ATOM   1413  O   PRO A  88     -36.963  40.210   9.294  1.00  0.00           O  
ATOM   1414  CB  PRO A  88     -39.331  38.686   9.862  1.00  0.00           C  
ATOM   1415  CG  PRO A  88     -39.746  39.788  10.774  1.00  0.00           C  
ATOM   1416  CD  PRO A  88     -39.127  39.476  12.109  1.00  0.00           C  
ATOM   1417  HA  PRO A  88     -37.808  37.217  10.236  1.00  0.00           H  
ATOM   1418  HB2 PRO A  88     -39.277  39.020   8.836  1.00  0.00           H  
ATOM   1419  HB3 PRO A  88     -39.999  37.841   9.937  1.00  0.00           H  
ATOM   1420  HG2 PRO A  88     -39.377  40.732  10.401  1.00  0.00           H  
ATOM   1421  HG3 PRO A  88     -40.822  39.812  10.856  1.00  0.00           H  
ATOM   1422  HD2 PRO A  88     -38.848  40.387  12.617  1.00  0.00           H  
ATOM   1423  HD3 PRO A  88     -39.809  38.899  12.715  1.00  0.00           H  
ATOM   1424  N   GLY A  89     -35.838  38.268   9.129  1.00  0.00           N  
ATOM   1425  CA  GLY A  89     -34.762  38.857   8.353  1.00  0.00           C  
ATOM   1426  C   GLY A  89     -33.392  38.484   8.885  1.00  0.00           C  
ATOM   1427  O   GLY A  89     -32.379  38.714   8.226  1.00  0.00           O  
ATOM   1428  H   GLY A  89     -35.812  37.314   9.354  1.00  0.00           H  
ATOM   1429  HA2 GLY A  89     -34.844  38.521   7.331  1.00  0.00           H  
ATOM   1430  HA3 GLY A  89     -34.863  39.933   8.377  1.00  0.00           H  
ATOM   1431  N   ASP A  90     -33.361  37.907  10.081  1.00  0.00           N  
ATOM   1432  CA  ASP A  90     -32.106  37.501  10.703  1.00  0.00           C  
ATOM   1433  C   ASP A  90     -31.680  36.120  10.216  1.00  0.00           C  
ATOM   1434  O   ASP A  90     -30.510  35.889   9.913  1.00  0.00           O  
ATOM   1435  CB  ASP A  90     -32.243  37.501  12.226  1.00  0.00           C  
ATOM   1436  CG  ASP A  90     -30.926  37.226  12.925  1.00  0.00           C  
ATOM   1437  OD1 ASP A  90     -29.870  37.589  12.365  1.00  0.00           O  
ATOM   1438  OD2 ASP A  90     -30.950  36.649  14.033  1.00  0.00           O  
ATOM   1439  H   ASP A  90     -34.204  37.750  10.558  1.00  0.00           H  
ATOM   1440  HA  ASP A  90     -31.349  38.218  10.420  1.00  0.00           H  
ATOM   1441  HB2 ASP A  90     -32.606  38.465  12.549  1.00  0.00           H  
ATOM   1442  HB3 ASP A  90     -32.950  36.737  12.516  1.00  0.00           H  
ATOM   1443  N   LYS A  91     -32.639  35.202  10.146  1.00  0.00           N  
ATOM   1444  CA  LYS A  91     -32.365  33.842   9.696  1.00  0.00           C  
ATOM   1445  C   LYS A  91     -31.573  33.848   8.393  1.00  0.00           C  
ATOM   1446  O   LYS A  91     -30.801  32.929   8.121  1.00  0.00           O  
ATOM   1447  CB  LYS A  91     -33.675  33.074   9.506  1.00  0.00           C  
ATOM   1448  CG  LYS A  91     -34.585  33.674   8.449  1.00  0.00           C  
ATOM   1449  CD  LYS A  91     -35.763  32.764   8.145  1.00  0.00           C  
ATOM   1450  CE  LYS A  91     -36.949  33.068   9.046  1.00  0.00           C  
ATOM   1451  NZ  LYS A  91     -37.719  34.250   8.570  1.00  0.00           N  
ATOM   1452  H   LYS A  91     -33.554  35.447  10.401  1.00  0.00           H  
ATOM   1453  HA  LYS A  91     -31.778  33.353  10.458  1.00  0.00           H  
ATOM   1454  HB2 LYS A  91     -33.444  32.058   9.217  1.00  0.00           H  
ATOM   1455  HB3 LYS A  91     -34.209  33.058  10.444  1.00  0.00           H  
ATOM   1456  HG2 LYS A  91     -34.959  34.623   8.806  1.00  0.00           H  
ATOM   1457  HG3 LYS A  91     -34.016  33.828   7.542  1.00  0.00           H  
ATOM   1458  HD2 LYS A  91     -36.061  32.906   7.116  1.00  0.00           H  
ATOM   1459  HD3 LYS A  91     -35.461  31.737   8.294  1.00  0.00           H  
ATOM   1460  HE2 LYS A  91     -37.601  32.208   9.063  1.00  0.00           H  
ATOM   1461  HE3 LYS A  91     -36.585  33.264  10.044  1.00  0.00           H  
ATOM   1462  HZ1 LYS A  91     -38.416  33.958   7.856  1.00  0.00           H  
ATOM   1463  HZ2 LYS A  91     -37.076  34.948   8.146  1.00  0.00           H  
ATOM   1464  HZ3 LYS A  91     -38.220  34.695   9.367  1.00  0.00           H  
ATOM   1465  N   ILE A  92     -31.768  34.891   7.593  1.00  0.00           N  
ATOM   1466  CA  ILE A  92     -31.069  35.017   6.320  1.00  0.00           C  
ATOM   1467  C   ILE A  92     -29.615  35.428   6.529  1.00  0.00           C  
ATOM   1468  O   ILE A  92     -28.695  34.673   6.213  1.00  0.00           O  
ATOM   1469  CB  ILE A  92     -31.754  36.046   5.402  1.00  0.00           C  
ATOM   1470  CG1 ILE A  92     -33.261  35.789   5.344  1.00  0.00           C  
ATOM   1471  CG2 ILE A  92     -31.149  35.997   4.006  1.00  0.00           C  
ATOM   1472  CD1 ILE A  92     -33.623  34.446   4.749  1.00  0.00           C  
ATOM   1473  H   ILE A  92     -32.396  35.592   7.865  1.00  0.00           H  
ATOM   1474  HA  ILE A  92     -31.093  34.055   5.829  1.00  0.00           H  
ATOM   1475  HB  ILE A  92     -31.579  37.031   5.808  1.00  0.00           H  
ATOM   1476 HG12 ILE A  92     -33.665  35.827   6.343  1.00  0.00           H  
ATOM   1477 HG13 ILE A  92     -33.727  36.556   4.743  1.00  0.00           H  
ATOM   1478 HG21 ILE A  92     -30.095  35.773   4.078  1.00  0.00           H  
ATOM   1479 HG22 ILE A  92     -31.641  35.227   3.428  1.00  0.00           H  
ATOM   1480 HG23 ILE A  92     -31.282  36.952   3.521  1.00  0.00           H  
ATOM   1481 HD11 ILE A  92     -32.753  33.805   4.750  1.00  0.00           H  
ATOM   1482 HD12 ILE A  92     -34.406  33.991   5.334  1.00  0.00           H  
ATOM   1483 HD13 ILE A  92     -33.965  34.583   3.733  1.00  0.00           H  
ATOM   1484  N   ILE A  93     -29.416  36.627   7.065  1.00  0.00           N  
ATOM   1485  CA  ILE A  93     -28.074  37.136   7.319  1.00  0.00           C  
ATOM   1486  C   ILE A  93     -27.148  36.026   7.803  1.00  0.00           C  
ATOM   1487  O   ILE A  93     -26.111  35.760   7.196  1.00  0.00           O  
ATOM   1488  CB  ILE A  93     -28.090  38.268   8.362  1.00  0.00           C  
ATOM   1489  CG1 ILE A  93     -29.013  39.400   7.906  1.00  0.00           C  
ATOM   1490  CG2 ILE A  93     -26.680  38.790   8.599  1.00  0.00           C  
ATOM   1491  CD1 ILE A  93     -29.014  40.592   8.837  1.00  0.00           C  
ATOM   1492  H   ILE A  93     -30.189  37.183   7.294  1.00  0.00           H  
ATOM   1493  HA  ILE A  93     -27.688  37.533   6.391  1.00  0.00           H  
ATOM   1494  HB  ILE A  93     -28.459  37.865   9.293  1.00  0.00           H  
ATOM   1495 HG12 ILE A  93     -28.699  39.741   6.932  1.00  0.00           H  
ATOM   1496 HG13 ILE A  93     -30.024  39.026   7.843  1.00  0.00           H  
ATOM   1497 HG21 ILE A  93     -25.968  38.002   8.406  1.00  0.00           H  
ATOM   1498 HG22 ILE A  93     -26.488  39.620   7.935  1.00  0.00           H  
ATOM   1499 HG23 ILE A  93     -26.586  39.118   9.623  1.00  0.00           H  
ATOM   1500 HD11 ILE A  93     -29.663  41.359   8.440  1.00  0.00           H  
ATOM   1501 HD12 ILE A  93     -29.369  40.288   9.810  1.00  0.00           H  
ATOM   1502 HD13 ILE A  93     -28.011  40.981   8.925  1.00  0.00           H  
ATOM   1503  N   ARG A  94     -27.531  35.381   8.901  1.00  0.00           N  
ATOM   1504  CA  ARG A  94     -26.734  34.298   9.467  1.00  0.00           C  
ATOM   1505  C   ARG A  94     -26.175  33.402   8.365  1.00  0.00           C  
ATOM   1506  O   ARG A  94     -24.990  33.067   8.365  1.00  0.00           O  
ATOM   1507  CB  ARG A  94     -27.579  33.468  10.435  1.00  0.00           C  
ATOM   1508  CG  ARG A  94     -27.543  33.978  11.866  1.00  0.00           C  
ATOM   1509  CD  ARG A  94     -28.619  35.025  12.111  1.00  0.00           C  
ATOM   1510  NE  ARG A  94     -29.952  34.433  12.184  1.00  0.00           N  
ATOM   1511  CZ  ARG A  94     -30.374  33.697  13.206  1.00  0.00           C  
ATOM   1512  NH1 ARG A  94     -29.572  33.464  14.236  1.00  0.00           N  
ATOM   1513  NH2 ARG A  94     -31.602  33.192  13.200  1.00  0.00           N  
ATOM   1514  H   ARG A  94     -28.368  35.638   9.339  1.00  0.00           H  
ATOM   1515  HA  ARG A  94     -25.911  34.740  10.008  1.00  0.00           H  
ATOM   1516  HB2 ARG A  94     -28.606  33.478  10.099  1.00  0.00           H  
ATOM   1517  HB3 ARG A  94     -27.216  32.452  10.429  1.00  0.00           H  
ATOM   1518  HG2 ARG A  94     -27.704  33.149  12.539  1.00  0.00           H  
ATOM   1519  HG3 ARG A  94     -26.576  34.418  12.057  1.00  0.00           H  
ATOM   1520  HD2 ARG A  94     -28.407  35.528  13.043  1.00  0.00           H  
ATOM   1521  HD3 ARG A  94     -28.596  35.742  11.304  1.00  0.00           H  
ATOM   1522  HE  ARG A  94     -30.561  34.593  11.435  1.00  0.00           H  
ATOM   1523 HH11 ARG A  94     -28.646  33.844  14.243  1.00  0.00           H  
ATOM   1524 HH12 ARG A  94     -29.892  32.910  15.004  1.00  0.00           H  
ATOM   1525 HH21 ARG A  94     -32.209  33.367  12.426  1.00  0.00           H  
ATOM   1526 HH22 ARG A  94     -31.918  32.638  13.969  1.00  0.00           H  
ATOM   1527  N   HIS A  95     -27.036  33.015   7.429  1.00  0.00           N  
ATOM   1528  CA  HIS A  95     -26.627  32.157   6.323  1.00  0.00           C  
ATOM   1529  C   HIS A  95     -25.739  32.919   5.343  1.00  0.00           C  
ATOM   1530  O   HIS A  95     -24.757  32.380   4.833  1.00  0.00           O  
ATOM   1531  CB  HIS A  95     -27.855  31.609   5.595  1.00  0.00           C  
ATOM   1532  CG  HIS A  95     -27.519  30.697   4.456  1.00  0.00           C  
ATOM   1533  ND1 HIS A  95     -28.126  30.779   3.220  1.00  0.00           N  
ATOM   1534  CD2 HIS A  95     -26.631  29.678   4.369  1.00  0.00           C  
ATOM   1535  CE1 HIS A  95     -27.627  29.851   2.424  1.00  0.00           C  
ATOM   1536  NE2 HIS A  95     -26.717  29.170   3.097  1.00  0.00           N  
ATOM   1537  H   HIS A  95     -27.967  33.314   7.484  1.00  0.00           H  
ATOM   1538  HA  HIS A  95     -26.065  31.332   6.733  1.00  0.00           H  
ATOM   1539  HB2 HIS A  95     -28.463  31.054   6.295  1.00  0.00           H  
ATOM   1540  HB3 HIS A  95     -28.431  32.434   5.201  1.00  0.00           H  
ATOM   1541  HD1 HIS A  95     -28.820  31.423   2.966  1.00  0.00           H  
ATOM   1542  HD2 HIS A  95     -25.976  29.330   5.155  1.00  0.00           H  
ATOM   1543  HE1 HIS A  95     -27.913  29.678   1.398  1.00  0.00           H  
ATOM   1544  HE2 HIS A  95     -26.254  28.371   2.770  1.00  0.00           H  
ATOM   1545  N   ARG A  96     -26.091  34.174   5.086  1.00  0.00           N  
ATOM   1546  CA  ARG A  96     -25.328  35.009   4.167  1.00  0.00           C  
ATOM   1547  C   ARG A  96     -23.872  35.120   4.616  1.00  0.00           C  
ATOM   1548  O   ARG A  96     -22.952  34.903   3.828  1.00  0.00           O  
ATOM   1549  CB  ARG A  96     -25.951  36.402   4.072  1.00  0.00           C  
ATOM   1550  CG  ARG A  96     -27.429  36.386   3.721  1.00  0.00           C  
ATOM   1551  CD  ARG A  96     -27.648  36.110   2.242  1.00  0.00           C  
ATOM   1552  NE  ARG A  96     -27.455  37.307   1.429  1.00  0.00           N  
ATOM   1553  CZ  ARG A  96     -28.360  38.274   1.316  1.00  0.00           C  
ATOM   1554  NH1 ARG A  96     -29.515  38.184   1.963  1.00  0.00           N  
ATOM   1555  NH2 ARG A  96     -28.112  39.332   0.556  1.00  0.00           N  
ATOM   1556  H   ARG A  96     -26.884  34.548   5.525  1.00  0.00           H  
ATOM   1557  HA  ARG A  96     -25.357  34.544   3.193  1.00  0.00           H  
ATOM   1558  HB2 ARG A  96     -25.834  36.902   5.022  1.00  0.00           H  
ATOM   1559  HB3 ARG A  96     -25.429  36.965   3.312  1.00  0.00           H  
ATOM   1560  HG2 ARG A  96     -27.917  35.612   4.296  1.00  0.00           H  
ATOM   1561  HG3 ARG A  96     -27.859  37.345   3.968  1.00  0.00           H  
ATOM   1562  HD2 ARG A  96     -26.947  35.354   1.923  1.00  0.00           H  
ATOM   1563  HD3 ARG A  96     -28.656  35.749   2.102  1.00  0.00           H  
ATOM   1564  HE  ARG A  96     -26.609  37.395   0.942  1.00  0.00           H  
ATOM   1565 HH11 ARG A  96     -29.704  37.387   2.536  1.00  0.00           H  
ATOM   1566 HH12 ARG A  96     -30.194  38.913   1.877  1.00  0.00           H  
ATOM   1567 HH21 ARG A  96     -27.243  39.404   0.068  1.00  0.00           H  
ATOM   1568 HH22 ARG A  96     -28.794  40.058   0.472  1.00  0.00           H  
ATOM   1569  N   ALA A  97     -23.674  35.460   5.885  1.00  0.00           N  
ATOM   1570  CA  ALA A  97     -22.333  35.599   6.438  1.00  0.00           C  
ATOM   1571  C   ALA A  97     -21.419  34.481   5.948  1.00  0.00           C  
ATOM   1572  O   ALA A  97     -20.331  34.737   5.430  1.00  0.00           O  
ATOM   1573  CB  ALA A  97     -22.387  35.611   7.959  1.00  0.00           C  
ATOM   1574  H   ALA A  97     -24.448  35.620   6.464  1.00  0.00           H  
ATOM   1575  HA  ALA A  97     -21.933  36.547   6.108  1.00  0.00           H  
ATOM   1576  HB1 ALA A  97     -22.003  34.676   8.339  1.00  0.00           H  
ATOM   1577  HB2 ALA A  97     -21.788  36.428   8.333  1.00  0.00           H  
ATOM   1578  HB3 ALA A  97     -23.410  35.739   8.280  1.00  0.00           H  
ATOM   1579  N   CYS A  98     -21.867  33.241   6.116  1.00  0.00           N  
ATOM   1580  CA  CYS A  98     -21.087  32.083   5.693  1.00  0.00           C  
ATOM   1581  C   CYS A  98     -20.837  32.117   4.189  1.00  0.00           C  
ATOM   1582  O   CYS A  98     -19.726  31.853   3.727  1.00  0.00           O  
ATOM   1583  CB  CYS A  98     -21.810  30.789   6.072  1.00  0.00           C  
ATOM   1584  SG  CYS A  98     -20.739  29.335   6.129  1.00  0.00           S  
ATOM   1585  H   CYS A  98     -22.741  33.101   6.535  1.00  0.00           H  
ATOM   1586  HA  CYS A  98     -20.138  32.119   6.204  1.00  0.00           H  
ATOM   1587  HB2 CYS A  98     -22.254  30.908   7.049  1.00  0.00           H  
ATOM   1588  HB3 CYS A  98     -22.590  30.598   5.351  1.00  0.00           H  
ATOM   1589  HG  CYS A  98     -21.245  28.489   7.012  1.00  0.00           H  
ATOM   1590  N   THR A  99     -21.877  32.443   3.427  1.00  0.00           N  
ATOM   1591  CA  THR A  99     -21.771  32.508   1.976  1.00  0.00           C  
ATOM   1592  C   THR A  99     -20.623  33.415   1.548  1.00  0.00           C  
ATOM   1593  O   THR A  99     -19.858  33.081   0.642  1.00  0.00           O  
ATOM   1594  CB  THR A  99     -23.078  33.020   1.339  1.00  0.00           C  
ATOM   1595  OG1 THR A  99     -24.157  32.133   1.655  1.00  0.00           O  
ATOM   1596  CG2 THR A  99     -22.935  33.136  -0.171  1.00  0.00           C  
ATOM   1597  H   THR A  99     -22.737  32.642   3.855  1.00  0.00           H  
ATOM   1598  HA  THR A  99     -21.584  31.509   1.609  1.00  0.00           H  
ATOM   1599  HB  THR A  99     -23.297  33.999   1.741  1.00  0.00           H  
ATOM   1600  HG1 THR A  99     -24.113  31.360   1.085  1.00  0.00           H  
ATOM   1601 HG21 THR A  99     -22.538  32.213  -0.567  1.00  0.00           H  
ATOM   1602 HG22 THR A  99     -22.264  33.948  -0.408  1.00  0.00           H  
ATOM   1603 HG23 THR A  99     -23.902  33.329  -0.610  1.00  0.00           H  
ATOM   1604  N   LEU A 100     -20.505  34.562   2.207  1.00  0.00           N  
ATOM   1605  CA  LEU A 100     -19.448  35.519   1.896  1.00  0.00           C  
ATOM   1606  C   LEU A 100     -18.074  34.864   2.001  1.00  0.00           C  
ATOM   1607  O   LEU A 100     -17.326  34.804   1.024  1.00  0.00           O  
ATOM   1608  CB  LEU A 100     -19.526  36.720   2.838  1.00  0.00           C  
ATOM   1609  CG  LEU A 100     -18.383  37.731   2.734  1.00  0.00           C  
ATOM   1610  CD1 LEU A 100     -18.561  38.613   1.509  1.00  0.00           C  
ATOM   1611  CD2 LEU A 100     -18.303  38.577   3.996  1.00  0.00           C  
ATOM   1612  H   LEU A 100     -21.143  34.773   2.919  1.00  0.00           H  
ATOM   1613  HA  LEU A 100     -19.595  35.857   0.881  1.00  0.00           H  
ATOM   1614  HB2 LEU A 100     -20.447  37.241   2.634  1.00  0.00           H  
ATOM   1615  HB3 LEU A 100     -19.545  36.344   3.852  1.00  0.00           H  
ATOM   1616  HG  LEU A 100     -17.448  37.198   2.628  1.00  0.00           H  
ATOM   1617 HD11 LEU A 100     -19.593  38.585   1.192  1.00  0.00           H  
ATOM   1618 HD12 LEU A 100     -17.930  38.253   0.710  1.00  0.00           H  
ATOM   1619 HD13 LEU A 100     -18.286  39.629   1.753  1.00  0.00           H  
ATOM   1620 HD21 LEU A 100     -17.947  39.565   3.744  1.00  0.00           H  
ATOM   1621 HD22 LEU A 100     -17.620  38.117   4.696  1.00  0.00           H  
ATOM   1622 HD23 LEU A 100     -19.282  38.650   4.444  1.00  0.00           H  
ATOM   1623  N   LYS A 101     -17.748  34.371   3.191  1.00  0.00           N  
ATOM   1624  CA  LYS A 101     -16.466  33.717   3.425  1.00  0.00           C  
ATOM   1625  C   LYS A 101     -16.141  32.741   2.299  1.00  0.00           C  
ATOM   1626  O   LYS A 101     -15.067  32.806   1.698  1.00  0.00           O  
ATOM   1627  CB  LYS A 101     -16.483  32.979   4.765  1.00  0.00           C  
ATOM   1628  CG  LYS A 101     -15.100  32.739   5.346  1.00  0.00           C  
ATOM   1629  CD  LYS A 101     -15.177  32.196   6.762  1.00  0.00           C  
ATOM   1630  CE  LYS A 101     -15.225  30.676   6.774  1.00  0.00           C  
ATOM   1631  NZ  LYS A 101     -13.863  30.078   6.697  1.00  0.00           N  
ATOM   1632  H   LYS A 101     -18.387  34.449   3.931  1.00  0.00           H  
ATOM   1633  HA  LYS A 101     -15.704  34.481   3.454  1.00  0.00           H  
ATOM   1634  HB2 LYS A 101     -17.054  33.560   5.475  1.00  0.00           H  
ATOM   1635  HB3 LYS A 101     -16.965  32.021   4.628  1.00  0.00           H  
ATOM   1636  HG2 LYS A 101     -14.578  32.026   4.725  1.00  0.00           H  
ATOM   1637  HG3 LYS A 101     -14.558  33.674   5.357  1.00  0.00           H  
ATOM   1638  HD2 LYS A 101     -14.305  32.521   7.311  1.00  0.00           H  
ATOM   1639  HD3 LYS A 101     -16.068  32.579   7.238  1.00  0.00           H  
ATOM   1640  HE2 LYS A 101     -15.700  30.351   7.687  1.00  0.00           H  
ATOM   1641  HE3 LYS A 101     -15.804  30.341   5.927  1.00  0.00           H  
ATOM   1642  HZ1 LYS A 101     -13.857  29.290   6.018  1.00  0.00           H  
ATOM   1643  HZ2 LYS A 101     -13.578  29.717   7.631  1.00  0.00           H  
ATOM   1644  HZ3 LYS A 101     -13.174  30.793   6.389  1.00  0.00           H  
ATOM   1645  N   ASP A 102     -17.074  31.838   2.017  1.00  0.00           N  
ATOM   1646  CA  ASP A 102     -16.887  30.850   0.961  1.00  0.00           C  
ATOM   1647  C   ASP A 102     -16.542  31.527  -0.362  1.00  0.00           C  
ATOM   1648  O   ASP A 102     -15.535  31.204  -0.994  1.00  0.00           O  
ATOM   1649  CB  ASP A 102     -18.148  30.000   0.799  1.00  0.00           C  
ATOM   1650  CG  ASP A 102     -18.440  29.158   2.026  1.00  0.00           C  
ATOM   1651  OD1 ASP A 102     -17.482  28.614   2.614  1.00  0.00           O  
ATOM   1652  OD2 ASP A 102     -19.626  29.046   2.398  1.00  0.00           O  
ATOM   1653  H   ASP A 102     -17.908  31.837   2.530  1.00  0.00           H  
ATOM   1654  HA  ASP A 102     -16.066  30.210   1.247  1.00  0.00           H  
ATOM   1655  HB2 ASP A 102     -18.993  30.650   0.623  1.00  0.00           H  
ATOM   1656  HB3 ASP A 102     -18.023  29.340  -0.047  1.00  0.00           H  
ATOM   1657  N   THR A 103     -17.384  32.468  -0.777  1.00  0.00           N  
ATOM   1658  CA  THR A 103     -17.171  33.188  -2.025  1.00  0.00           C  
ATOM   1659  C   THR A 103     -15.786  33.826  -2.063  1.00  0.00           C  
ATOM   1660  O   THR A 103     -14.937  33.442  -2.866  1.00  0.00           O  
ATOM   1661  CB  THR A 103     -18.233  34.284  -2.231  1.00  0.00           C  
ATOM   1662  OG1 THR A 103     -19.545  33.714  -2.159  1.00  0.00           O  
ATOM   1663  CG2 THR A 103     -18.048  34.973  -3.575  1.00  0.00           C  
ATOM   1664  H   THR A 103     -18.169  32.681  -0.229  1.00  0.00           H  
ATOM   1665  HA  THR A 103     -17.251  32.481  -2.837  1.00  0.00           H  
ATOM   1666  HB  THR A 103     -18.125  35.020  -1.447  1.00  0.00           H  
ATOM   1667  HG1 THR A 103     -19.835  33.693  -1.243  1.00  0.00           H  
ATOM   1668 HG21 THR A 103     -17.004  34.948  -3.851  1.00  0.00           H  
ATOM   1669 HG22 THR A 103     -18.376  36.000  -3.501  1.00  0.00           H  
ATOM   1670 HG23 THR A 103     -18.631  34.462  -4.324  1.00  0.00           H  
ATOM   1671  N   ALA A 104     -15.565  34.800  -1.185  1.00  0.00           N  
ATOM   1672  CA  ALA A 104     -14.282  35.489  -1.116  1.00  0.00           C  
ATOM   1673  C   ALA A 104     -13.125  34.496  -1.125  1.00  0.00           C  
ATOM   1674  O   ALA A 104     -12.184  34.630  -1.909  1.00  0.00           O  
ATOM   1675  CB  ALA A 104     -14.220  36.365   0.127  1.00  0.00           C  
ATOM   1676  H   ALA A 104     -16.281  35.061  -0.571  1.00  0.00           H  
ATOM   1677  HA  ALA A 104     -14.200  36.130  -1.983  1.00  0.00           H  
ATOM   1678  HB1 ALA A 104     -14.976  36.046   0.828  1.00  0.00           H  
ATOM   1679  HB2 ALA A 104     -13.245  36.275   0.582  1.00  0.00           H  
ATOM   1680  HB3 ALA A 104     -14.395  37.394  -0.149  1.00  0.00           H  
ATOM   1681  N   HIS A 105     -13.200  33.499  -0.249  1.00  0.00           N  
ATOM   1682  CA  HIS A 105     -12.157  32.483  -0.156  1.00  0.00           C  
ATOM   1683  C   HIS A 105     -12.044  31.700  -1.461  1.00  0.00           C  
ATOM   1684  O   HIS A 105     -10.961  31.255  -1.837  1.00  0.00           O  
ATOM   1685  CB  HIS A 105     -12.448  31.529   1.003  1.00  0.00           C  
ATOM   1686  CG  HIS A 105     -11.982  32.039   2.331  1.00  0.00           C  
ATOM   1687  ND1 HIS A 105     -10.827  31.601   2.942  1.00  0.00           N  
ATOM   1688  CD2 HIS A 105     -12.522  32.959   3.165  1.00  0.00           C  
ATOM   1689  CE1 HIS A 105     -10.676  32.226   4.096  1.00  0.00           C  
ATOM   1690  NE2 HIS A 105     -11.692  33.057   4.255  1.00  0.00           N  
ATOM   1691  H   HIS A 105     -13.974  33.446   0.348  1.00  0.00           H  
ATOM   1692  HA  HIS A 105     -11.221  32.986   0.030  1.00  0.00           H  
ATOM   1693  HB2 HIS A 105     -13.514  31.364   1.066  1.00  0.00           H  
ATOM   1694  HB3 HIS A 105     -11.954  30.586   0.816  1.00  0.00           H  
ATOM   1695  HD1 HIS A 105     -10.209  30.929   2.585  1.00  0.00           H  
ATOM   1696  HD2 HIS A 105     -13.435  33.512   3.005  1.00  0.00           H  
ATOM   1697  HE1 HIS A 105      -9.863  32.085   4.791  1.00  0.00           H  
ATOM   1698  HE2 HIS A 105     -11.871  33.580   5.063  1.00  0.00           H  
ATOM   1699  N   ALA A 106     -13.172  31.535  -2.145  1.00  0.00           N  
ATOM   1700  CA  ALA A 106     -13.198  30.806  -3.408  1.00  0.00           C  
ATOM   1701  C   ALA A 106     -12.474  31.580  -4.504  1.00  0.00           C  
ATOM   1702  O   ALA A 106     -11.752  30.997  -5.314  1.00  0.00           O  
ATOM   1703  CB  ALA A 106     -14.634  30.522  -3.822  1.00  0.00           C  
ATOM   1704  H   ALA A 106     -14.004  31.913  -1.794  1.00  0.00           H  
ATOM   1705  HA  ALA A 106     -12.699  29.860  -3.258  1.00  0.00           H  
ATOM   1706  HB1 ALA A 106     -14.642  30.053  -4.795  1.00  0.00           H  
ATOM   1707  HB2 ALA A 106     -15.093  29.861  -3.101  1.00  0.00           H  
ATOM   1708  HB3 ALA A 106     -15.187  31.448  -3.864  1.00  0.00           H  
ATOM   1709  N   ILE A 107     -12.670  32.894  -4.523  1.00  0.00           N  
ATOM   1710  CA  ILE A 107     -12.034  33.746  -5.519  1.00  0.00           C  
ATOM   1711  C   ILE A 107     -10.525  33.808  -5.307  1.00  0.00           C  
ATOM   1712  O   ILE A 107      -9.757  33.888  -6.266  1.00  0.00           O  
ATOM   1713  CB  ILE A 107     -12.605  35.176  -5.484  1.00  0.00           C  
ATOM   1714  CG1 ILE A 107     -14.096  35.161  -5.826  1.00  0.00           C  
ATOM   1715  CG2 ILE A 107     -11.844  36.075  -6.447  1.00  0.00           C  
ATOM   1716  CD1 ILE A 107     -14.862  36.328  -5.241  1.00  0.00           C  
ATOM   1717  H   ILE A 107     -13.256  33.299  -3.850  1.00  0.00           H  
ATOM   1718  HA  ILE A 107     -12.232  33.324  -6.494  1.00  0.00           H  
ATOM   1719  HB  ILE A 107     -12.475  35.567  -4.486  1.00  0.00           H  
ATOM   1720 HG12 ILE A 107     -14.214  35.192  -6.898  1.00  0.00           H  
ATOM   1721 HG13 ILE A 107     -14.536  34.251  -5.446  1.00  0.00           H  
ATOM   1722 HG21 ILE A 107     -10.913  36.382  -5.993  1.00  0.00           H  
ATOM   1723 HG22 ILE A 107     -11.637  35.532  -7.358  1.00  0.00           H  
ATOM   1724 HG23 ILE A 107     -12.439  36.946  -6.675  1.00  0.00           H  
ATOM   1725 HD11 ILE A 107     -15.061  36.141  -4.196  1.00  0.00           H  
ATOM   1726 HD12 ILE A 107     -14.278  37.230  -5.341  1.00  0.00           H  
ATOM   1727 HD13 ILE A 107     -15.798  36.446  -5.769  1.00  0.00           H  
ATOM   1728  N   ILE A 108     -10.108  33.768  -4.046  1.00  0.00           N  
ATOM   1729  CA  ILE A 108      -8.691  33.817  -3.708  1.00  0.00           C  
ATOM   1730  C   ILE A 108      -8.014  32.479  -3.983  1.00  0.00           C  
ATOM   1731  O   ILE A 108      -7.040  32.406  -4.732  1.00  0.00           O  
ATOM   1732  CB  ILE A 108      -8.477  34.194  -2.231  1.00  0.00           C  
ATOM   1733  CG1 ILE A 108      -9.153  35.531  -1.921  1.00  0.00           C  
ATOM   1734  CG2 ILE A 108      -6.990  34.259  -1.911  1.00  0.00           C  
ATOM   1735  CD1 ILE A 108      -8.388  36.730  -2.435  1.00  0.00           C  
ATOM   1736  H   ILE A 108     -10.770  33.704  -3.326  1.00  0.00           H  
ATOM   1737  HA  ILE A 108      -8.228  34.576  -4.324  1.00  0.00           H  
ATOM   1738  HB  ILE A 108      -8.920  33.424  -1.619  1.00  0.00           H  
ATOM   1739 HG12 ILE A 108     -10.132  35.545  -2.370  1.00  0.00           H  
ATOM   1740 HG13 ILE A 108      -9.253  35.635  -0.849  1.00  0.00           H  
ATOM   1741 HG21 ILE A 108      -6.565  33.268  -1.974  1.00  0.00           H  
ATOM   1742 HG22 ILE A 108      -6.498  34.906  -2.621  1.00  0.00           H  
ATOM   1743 HG23 ILE A 108      -6.854  34.647  -0.913  1.00  0.00           H  
ATOM   1744 HD11 ILE A 108      -9.008  37.611  -2.365  1.00  0.00           H  
ATOM   1745 HD12 ILE A 108      -7.495  36.869  -1.844  1.00  0.00           H  
ATOM   1746 HD13 ILE A 108      -8.114  36.566  -3.468  1.00  0.00           H  
ATOM   1747  N   ALA A 109      -8.539  31.421  -3.374  1.00  0.00           N  
ATOM   1748  CA  ALA A 109      -7.988  30.084  -3.556  1.00  0.00           C  
ATOM   1749  C   ALA A 109      -8.035  29.665  -5.022  1.00  0.00           C  
ATOM   1750  O   ALA A 109      -7.250  28.826  -5.462  1.00  0.00           O  
ATOM   1751  CB  ALA A 109      -8.742  29.080  -2.695  1.00  0.00           C  
ATOM   1752  H   ALA A 109      -9.316  31.543  -2.789  1.00  0.00           H  
ATOM   1753  HA  ALA A 109      -6.958  30.099  -3.229  1.00  0.00           H  
ATOM   1754  HB1 ALA A 109      -8.643  28.094  -3.123  1.00  0.00           H  
ATOM   1755  HB2 ALA A 109      -8.330  29.083  -1.697  1.00  0.00           H  
ATOM   1756  HB3 ALA A 109      -9.785  29.354  -2.655  1.00  0.00           H  
ATOM   1757  N   ALA A 110      -8.959  30.256  -5.772  1.00  0.00           N  
ATOM   1758  CA  ALA A 110      -9.107  29.945  -7.188  1.00  0.00           C  
ATOM   1759  C   ALA A 110      -8.129  30.755  -8.033  1.00  0.00           C  
ATOM   1760  O   ALA A 110      -7.364  30.197  -8.819  1.00  0.00           O  
ATOM   1761  CB  ALA A 110     -10.537  30.204  -7.639  1.00  0.00           C  
ATOM   1762  H   ALA A 110      -9.555  30.918  -5.363  1.00  0.00           H  
ATOM   1763  HA  ALA A 110      -8.898  28.894  -7.322  1.00  0.00           H  
ATOM   1764  HB1 ALA A 110     -10.651  29.890  -8.666  1.00  0.00           H  
ATOM   1765  HB2 ALA A 110     -11.217  29.647  -7.014  1.00  0.00           H  
ATOM   1766  HB3 ALA A 110     -10.753  31.258  -7.559  1.00  0.00           H  
ATOM   1767  N   GLU A 111      -8.159  32.073  -7.864  1.00  0.00           N  
ATOM   1768  CA  GLU A 111      -7.276  32.960  -8.613  1.00  0.00           C  
ATOM   1769  C   GLU A 111      -5.855  32.905  -8.061  1.00  0.00           C  
ATOM   1770  O   GLU A 111      -4.933  32.437  -8.730  1.00  0.00           O  
ATOM   1771  CB  GLU A 111      -7.799  34.397  -8.567  1.00  0.00           C  
ATOM   1772  CG  GLU A 111      -9.119  34.588  -9.294  1.00  0.00           C  
ATOM   1773  CD  GLU A 111      -9.331  36.018  -9.752  1.00  0.00           C  
ATOM   1774  OE1 GLU A 111      -8.446  36.556 -10.448  1.00  0.00           O  
ATOM   1775  OE2 GLU A 111     -10.384  36.598  -9.413  1.00  0.00           O  
ATOM   1776  H   GLU A 111      -8.791  32.459  -7.222  1.00  0.00           H  
ATOM   1777  HA  GLU A 111      -7.263  32.625  -9.640  1.00  0.00           H  
ATOM   1778  HB2 GLU A 111      -7.935  34.684  -7.534  1.00  0.00           H  
ATOM   1779  HB3 GLU A 111      -7.066  35.049  -9.019  1.00  0.00           H  
ATOM   1780  HG2 GLU A 111      -9.135  33.943 -10.159  1.00  0.00           H  
ATOM   1781  HG3 GLU A 111      -9.925  34.315  -8.628  1.00  0.00           H  
ATOM   1782  N   LEU A 112      -5.685  33.388  -6.834  1.00  0.00           N  
ATOM   1783  CA  LEU A 112      -4.376  33.395  -6.190  1.00  0.00           C  
ATOM   1784  C   LEU A 112      -3.659  32.065  -6.398  1.00  0.00           C  
ATOM   1785  O   LEU A 112      -3.987  31.065  -5.760  1.00  0.00           O  
ATOM   1786  CB  LEU A 112      -4.525  33.679  -4.694  1.00  0.00           C  
ATOM   1787  CG  LEU A 112      -3.250  34.097  -3.960  1.00  0.00           C  
ATOM   1788  CD1 LEU A 112      -2.760  35.445  -4.467  1.00  0.00           C  
ATOM   1789  CD2 LEU A 112      -3.490  34.146  -2.459  1.00  0.00           C  
ATOM   1790  H   LEU A 112      -6.457  33.746  -6.350  1.00  0.00           H  
ATOM   1791  HA  LEU A 112      -3.790  34.182  -6.640  1.00  0.00           H  
ATOM   1792  HB2 LEU A 112      -5.249  34.471  -4.577  1.00  0.00           H  
ATOM   1793  HB3 LEU A 112      -4.899  32.780  -4.223  1.00  0.00           H  
ATOM   1794  HG  LEU A 112      -2.475  33.368  -4.153  1.00  0.00           H  
ATOM   1795 HD11 LEU A 112      -3.477  36.210  -4.207  1.00  0.00           H  
ATOM   1796 HD12 LEU A 112      -2.649  35.406  -5.541  1.00  0.00           H  
ATOM   1797 HD13 LEU A 112      -1.808  35.675  -4.014  1.00  0.00           H  
ATOM   1798 HD21 LEU A 112      -4.228  34.904  -2.237  1.00  0.00           H  
ATOM   1799 HD22 LEU A 112      -2.566  34.386  -1.954  1.00  0.00           H  
ATOM   1800 HD23 LEU A 112      -3.848  33.185  -2.120  1.00  0.00           H  
ATOM   1801  N   ASP A 113      -2.678  32.064  -7.294  1.00  0.00           N  
ATOM   1802  CA  ASP A 113      -1.910  30.857  -7.584  1.00  0.00           C  
ATOM   1803  C   ASP A 113      -1.063  30.451  -6.383  1.00  0.00           C  
ATOM   1804  O   ASP A 113      -0.714  31.269  -5.532  1.00  0.00           O  
ATOM   1805  CB  ASP A 113      -1.016  31.079  -8.805  1.00  0.00           C  
ATOM   1806  CG  ASP A 113      -1.767  30.913 -10.111  1.00  0.00           C  
ATOM   1807  OD1 ASP A 113      -1.899  29.761 -10.577  1.00  0.00           O  
ATOM   1808  OD2 ASP A 113      -2.223  31.934 -10.666  1.00  0.00           O  
ATOM   1809  H   ASP A 113      -2.463  32.893  -7.770  1.00  0.00           H  
ATOM   1810  HA  ASP A 113      -2.610  30.064  -7.801  1.00  0.00           H  
ATOM   1811  HB2 ASP A 113      -0.610  32.079  -8.770  1.00  0.00           H  
ATOM   1812  HB3 ASP A 113      -0.206  30.365  -8.783  1.00  0.00           H  
ATOM   1813  N   PRO A 114      -0.723  29.154  -6.310  1.00  0.00           N  
ATOM   1814  CA  PRO A 114       0.088  28.609  -5.217  1.00  0.00           C  
ATOM   1815  C   PRO A 114       1.535  29.087  -5.275  1.00  0.00           C  
ATOM   1816  O   PRO A 114       2.288  28.929  -4.315  1.00  0.00           O  
ATOM   1817  CB  PRO A 114       0.014  27.097  -5.442  1.00  0.00           C  
ATOM   1818  CG  PRO A 114      -0.258  26.943  -6.898  1.00  0.00           C  
ATOM   1819  CD  PRO A 114      -1.103  28.123  -7.289  1.00  0.00           C  
ATOM   1820  HA  PRO A 114      -0.332  28.853  -4.252  1.00  0.00           H  
ATOM   1821  HB2 PRO A 114       0.954  26.643  -5.164  1.00  0.00           H  
ATOM   1822  HB3 PRO A 114      -0.784  26.679  -4.846  1.00  0.00           H  
ATOM   1823  HG2 PRO A 114       0.672  26.950  -7.448  1.00  0.00           H  
ATOM   1824  HG3 PRO A 114      -0.793  26.022  -7.076  1.00  0.00           H  
ATOM   1825  HD2 PRO A 114      -0.869  28.439  -8.295  1.00  0.00           H  
ATOM   1826  HD3 PRO A 114      -2.153  27.880  -7.204  1.00  0.00           H  
ATOM   1827  N   GLU A 115       1.916  29.671  -6.407  1.00  0.00           N  
ATOM   1828  CA  GLU A 115       3.274  30.169  -6.589  1.00  0.00           C  
ATOM   1829  C   GLU A 115       3.340  31.672  -6.333  1.00  0.00           C  
ATOM   1830  O   GLU A 115       4.351  32.189  -5.857  1.00  0.00           O  
ATOM   1831  CB  GLU A 115       3.770  29.859  -8.002  1.00  0.00           C  
ATOM   1832  CG  GLU A 115       2.834  30.344  -9.096  1.00  0.00           C  
ATOM   1833  CD  GLU A 115       3.354  30.037 -10.487  1.00  0.00           C  
ATOM   1834  OE1 GLU A 115       3.190  28.885 -10.940  1.00  0.00           O  
ATOM   1835  OE2 GLU A 115       3.925  30.948 -11.123  1.00  0.00           O  
ATOM   1836  H   GLU A 115       1.270  29.767  -7.137  1.00  0.00           H  
ATOM   1837  HA  GLU A 115       3.910  29.668  -5.875  1.00  0.00           H  
ATOM   1838  HB2 GLU A 115       4.732  30.330  -8.144  1.00  0.00           H  
ATOM   1839  HB3 GLU A 115       3.885  28.790  -8.103  1.00  0.00           H  
ATOM   1840  HG2 GLU A 115       1.876  29.861  -8.972  1.00  0.00           H  
ATOM   1841  HG3 GLU A 115       2.713  31.412  -9.001  1.00  0.00           H  
ATOM   1842  N   PHE A 116       2.254  32.369  -6.654  1.00  0.00           N  
ATOM   1843  CA  PHE A 116       2.188  33.814  -6.461  1.00  0.00           C  
ATOM   1844  C   PHE A 116       1.992  34.157  -4.987  1.00  0.00           C  
ATOM   1845  O   PHE A 116       2.522  35.152  -4.496  1.00  0.00           O  
ATOM   1846  CB  PHE A 116       1.048  34.407  -7.291  1.00  0.00           C  
ATOM   1847  CG  PHE A 116       0.961  35.905  -7.203  1.00  0.00           C  
ATOM   1848  CD1 PHE A 116       0.397  36.515  -6.094  1.00  0.00           C  
ATOM   1849  CD2 PHE A 116       1.443  36.702  -8.229  1.00  0.00           C  
ATOM   1850  CE1 PHE A 116       0.314  37.891  -6.011  1.00  0.00           C  
ATOM   1851  CE2 PHE A 116       1.363  38.079  -8.152  1.00  0.00           C  
ATOM   1852  CZ  PHE A 116       0.799  38.676  -7.040  1.00  0.00           C  
ATOM   1853  H   PHE A 116       1.479  31.900  -7.030  1.00  0.00           H  
ATOM   1854  HA  PHE A 116       3.123  34.234  -6.796  1.00  0.00           H  
ATOM   1855  HB2 PHE A 116       1.193  34.145  -8.328  1.00  0.00           H  
ATOM   1856  HB3 PHE A 116       0.111  33.999  -6.947  1.00  0.00           H  
ATOM   1857  HD1 PHE A 116       0.018  35.904  -5.288  1.00  0.00           H  
ATOM   1858  HD2 PHE A 116       1.884  36.237  -9.099  1.00  0.00           H  
ATOM   1859  HE1 PHE A 116      -0.127  38.356  -5.141  1.00  0.00           H  
ATOM   1860  HE2 PHE A 116       1.743  38.689  -8.958  1.00  0.00           H  
ATOM   1861  HZ  PHE A 116       0.735  39.751  -6.978  1.00  0.00           H  
ATOM   1862  N   ASN A 117       1.226  33.325  -4.289  1.00  0.00           N  
ATOM   1863  CA  ASN A 117       0.959  33.540  -2.872  1.00  0.00           C  
ATOM   1864  C   ASN A 117       2.241  33.425  -2.052  1.00  0.00           C  
ATOM   1865  O   ASN A 117       2.497  34.236  -1.162  1.00  0.00           O  
ATOM   1866  CB  ASN A 117      -0.075  32.531  -2.367  1.00  0.00           C  
ATOM   1867  CG  ASN A 117      -0.242  32.579  -0.861  1.00  0.00           C  
ATOM   1868  OD1 ASN A 117      -1.158  33.222  -0.347  1.00  0.00           O  
ATOM   1869  ND2 ASN A 117       0.645  31.897  -0.145  1.00  0.00           N  
ATOM   1870  H   ASN A 117       0.832  32.548  -4.737  1.00  0.00           H  
ATOM   1871  HA  ASN A 117       0.561  34.538  -2.758  1.00  0.00           H  
ATOM   1872  HB2 ASN A 117      -1.031  32.746  -2.822  1.00  0.00           H  
ATOM   1873  HB3 ASN A 117       0.237  31.536  -2.645  1.00  0.00           H  
ATOM   1874 HD21 ASN A 117       1.347  31.409  -0.622  1.00  0.00           H  
ATOM   1875 HD22 ASN A 117       0.560  31.911   0.832  1.00  0.00           H  
ATOM   1876  N   LYS A 118       3.044  32.412  -2.360  1.00  0.00           N  
ATOM   1877  CA  LYS A 118       4.301  32.190  -1.655  1.00  0.00           C  
ATOM   1878  C   LYS A 118       5.250  33.367  -1.852  1.00  0.00           C  
ATOM   1879  O   LYS A 118       6.175  33.571  -1.064  1.00  0.00           O  
ATOM   1880  CB  LYS A 118       4.962  30.900  -2.143  1.00  0.00           C  
ATOM   1881  CG  LYS A 118       4.061  29.681  -2.048  1.00  0.00           C  
ATOM   1882  CD  LYS A 118       4.659  28.487  -2.774  1.00  0.00           C  
ATOM   1883  CE  LYS A 118       4.098  27.175  -2.247  1.00  0.00           C  
ATOM   1884  NZ  LYS A 118       4.831  26.706  -1.038  1.00  0.00           N  
ATOM   1885  H   LYS A 118       2.785  31.799  -3.080  1.00  0.00           H  
ATOM   1886  HA  LYS A 118       4.078  32.095  -0.603  1.00  0.00           H  
ATOM   1887  HB2 LYS A 118       5.253  31.026  -3.176  1.00  0.00           H  
ATOM   1888  HB3 LYS A 118       5.845  30.715  -1.549  1.00  0.00           H  
ATOM   1889  HG2 LYS A 118       3.925  29.424  -1.008  1.00  0.00           H  
ATOM   1890  HG3 LYS A 118       3.103  29.917  -2.489  1.00  0.00           H  
ATOM   1891  HD2 LYS A 118       4.429  28.565  -3.827  1.00  0.00           H  
ATOM   1892  HD3 LYS A 118       5.731  28.492  -2.636  1.00  0.00           H  
ATOM   1893  HE2 LYS A 118       3.059  27.318  -1.994  1.00  0.00           H  
ATOM   1894  HE3 LYS A 118       4.181  26.427  -3.021  1.00  0.00           H  
ATOM   1895  HZ1 LYS A 118       5.799  26.423  -1.294  1.00  0.00           H  
ATOM   1896  HZ2 LYS A 118       4.343  25.888  -0.620  1.00  0.00           H  
ATOM   1897  HZ3 LYS A 118       4.880  27.466  -0.331  1.00  0.00           H  
ATOM   1898  N   LEU A 119       5.017  34.140  -2.906  1.00  0.00           N  
ATOM   1899  CA  LEU A 119       5.851  35.298  -3.207  1.00  0.00           C  
ATOM   1900  C   LEU A 119       5.436  36.501  -2.365  1.00  0.00           C  
ATOM   1901  O   LEU A 119       6.234  37.036  -1.595  1.00  0.00           O  
ATOM   1902  CB  LEU A 119       5.759  35.646  -4.694  1.00  0.00           C  
ATOM   1903  CG  LEU A 119       6.286  34.587  -5.664  1.00  0.00           C  
ATOM   1904  CD1 LEU A 119       5.747  34.834  -7.065  1.00  0.00           C  
ATOM   1905  CD2 LEU A 119       7.807  34.579  -5.670  1.00  0.00           C  
ATOM   1906  H   LEU A 119       4.265  33.927  -3.498  1.00  0.00           H  
ATOM   1907  HA  LEU A 119       6.872  35.041  -2.968  1.00  0.00           H  
ATOM   1908  HB2 LEU A 119       4.721  35.822  -4.929  1.00  0.00           H  
ATOM   1909  HB3 LEU A 119       6.322  36.554  -4.856  1.00  0.00           H  
ATOM   1910  HG  LEU A 119       5.945  33.613  -5.343  1.00  0.00           H  
ATOM   1911 HD11 LEU A 119       4.944  35.553  -7.021  1.00  0.00           H  
ATOM   1912 HD12 LEU A 119       5.378  33.906  -7.477  1.00  0.00           H  
ATOM   1913 HD13 LEU A 119       6.539  35.216  -7.693  1.00  0.00           H  
ATOM   1914 HD21 LEU A 119       8.169  34.433  -4.662  1.00  0.00           H  
ATOM   1915 HD22 LEU A 119       8.171  35.522  -6.050  1.00  0.00           H  
ATOM   1916 HD23 LEU A 119       8.160  33.775  -6.298  1.00  0.00           H  
ATOM   1917  N   CYS A 120       4.184  36.919  -2.517  1.00  0.00           N  
ATOM   1918  CA  CYS A 120       3.662  38.057  -1.769  1.00  0.00           C  
ATOM   1919  C   CYS A 120       4.104  37.998  -0.311  1.00  0.00           C  
ATOM   1920  O   CYS A 120       4.314  39.030   0.326  1.00  0.00           O  
ATOM   1921  CB  CYS A 120       2.136  38.092  -1.852  1.00  0.00           C  
ATOM   1922  SG  CYS A 120       1.314  36.816  -0.869  1.00  0.00           S  
ATOM   1923  H   CYS A 120       3.597  36.451  -3.146  1.00  0.00           H  
ATOM   1924  HA  CYS A 120       4.059  38.956  -2.216  1.00  0.00           H  
ATOM   1925  HB2 CYS A 120       1.785  39.052  -1.502  1.00  0.00           H  
ATOM   1926  HB3 CYS A 120       1.836  37.960  -2.881  1.00  0.00           H  
ATOM   1927  HG  CYS A 120       2.155  36.423   0.075  1.00  0.00           H  
ATOM   1928  N   GLU A 121       4.240  36.784   0.213  1.00  0.00           N  
ATOM   1929  CA  GLU A 121       4.654  36.591   1.598  1.00  0.00           C  
ATOM   1930  C   GLU A 121       6.173  36.652   1.725  1.00  0.00           C  
ATOM   1931  O   GLU A 121       6.703  37.241   2.666  1.00  0.00           O  
ATOM   1932  CB  GLU A 121       4.139  35.250   2.125  1.00  0.00           C  
ATOM   1933  CG  GLU A 121       4.669  34.051   1.358  1.00  0.00           C  
ATOM   1934  CD  GLU A 121       4.379  32.736   2.056  1.00  0.00           C  
ATOM   1935  OE1 GLU A 121       5.170  32.347   2.941  1.00  0.00           O  
ATOM   1936  OE2 GLU A 121       3.361  32.098   1.717  1.00  0.00           O  
ATOM   1937  H   GLU A 121       4.057  36.000  -0.345  1.00  0.00           H  
ATOM   1938  HA  GLU A 121       4.223  37.387   2.186  1.00  0.00           H  
ATOM   1939  HB2 GLU A 121       4.431  35.148   3.160  1.00  0.00           H  
ATOM   1940  HB3 GLU A 121       3.061  35.242   2.062  1.00  0.00           H  
ATOM   1941  HG2 GLU A 121       4.208  34.031   0.382  1.00  0.00           H  
ATOM   1942  HG3 GLU A 121       5.739  34.154   1.248  1.00  0.00           H  
ATOM   1943  N   GLU A 122       6.866  36.037   0.771  1.00  0.00           N  
ATOM   1944  CA  GLU A 122       8.324  36.020   0.778  1.00  0.00           C  
ATOM   1945  C   GLU A 122       8.885  37.438   0.787  1.00  0.00           C  
ATOM   1946  O   GLU A 122      10.036  37.660   1.164  1.00  0.00           O  
ATOM   1947  CB  GLU A 122       8.853  35.258  -0.440  1.00  0.00           C  
ATOM   1948  CG  GLU A 122      10.243  34.680  -0.239  1.00  0.00           C  
ATOM   1949  CD  GLU A 122      10.218  33.313   0.416  1.00  0.00           C  
ATOM   1950  OE1 GLU A 122       9.350  33.087   1.285  1.00  0.00           O  
ATOM   1951  OE2 GLU A 122      11.066  32.469   0.060  1.00  0.00           O  
ATOM   1952  H   GLU A 122       6.385  35.584   0.047  1.00  0.00           H  
ATOM   1953  HA  GLU A 122       8.646  35.512   1.675  1.00  0.00           H  
ATOM   1954  HB2 GLU A 122       8.176  34.446  -0.663  1.00  0.00           H  
ATOM   1955  HB3 GLU A 122       8.884  35.931  -1.284  1.00  0.00           H  
ATOM   1956  HG2 GLU A 122      10.724  34.592  -1.201  1.00  0.00           H  
ATOM   1957  HG3 GLU A 122      10.812  35.352   0.387  1.00  0.00           H  
ATOM   1958  N   ILE A 123       8.064  38.396   0.369  1.00  0.00           N  
ATOM   1959  CA  ILE A 123       8.476  39.793   0.329  1.00  0.00           C  
ATOM   1960  C   ILE A 123       8.260  40.468   1.680  1.00  0.00           C  
ATOM   1961  O   ILE A 123       9.008  41.371   2.062  1.00  0.00           O  
ATOM   1962  CB  ILE A 123       7.710  40.576  -0.752  1.00  0.00           C  
ATOM   1963  CG1 ILE A 123       8.023  40.012  -2.139  1.00  0.00           C  
ATOM   1964  CG2 ILE A 123       8.061  42.055  -0.685  1.00  0.00           C  
ATOM   1965  CD1 ILE A 123       6.944  40.292  -3.163  1.00  0.00           C  
ATOM   1966  H   ILE A 123       7.158  38.157   0.082  1.00  0.00           H  
ATOM   1967  HA  ILE A 123       9.529  39.822   0.089  1.00  0.00           H  
ATOM   1968  HB  ILE A 123       6.653  40.473  -0.559  1.00  0.00           H  
ATOM   1969 HG12 ILE A 123       8.941  40.447  -2.499  1.00  0.00           H  
ATOM   1970 HG13 ILE A 123       8.141  38.940  -2.065  1.00  0.00           H  
ATOM   1971 HG21 ILE A 123       9.135  42.172  -0.715  1.00  0.00           H  
ATOM   1972 HG22 ILE A 123       7.620  42.569  -1.525  1.00  0.00           H  
ATOM   1973 HG23 ILE A 123       7.679  42.475   0.235  1.00  0.00           H  
ATOM   1974 HD11 ILE A 123       6.117  39.614  -3.010  1.00  0.00           H  
ATOM   1975 HD12 ILE A 123       6.601  41.310  -3.056  1.00  0.00           H  
ATOM   1976 HD13 ILE A 123       7.345  40.150  -4.156  1.00  0.00           H  
ATOM   1977  N   LYS A 124       7.236  40.025   2.400  1.00  0.00           N  
ATOM   1978  CA  LYS A 124       6.922  40.584   3.710  1.00  0.00           C  
ATOM   1979  C   LYS A 124       8.141  40.541   4.625  1.00  0.00           C  
ATOM   1980  O   LYS A 124       8.199  41.251   5.629  1.00  0.00           O  
ATOM   1981  CB  LYS A 124       5.764  39.816   4.350  1.00  0.00           C  
ATOM   1982  CG  LYS A 124       6.213  38.694   5.272  1.00  0.00           C  
ATOM   1983  CD  LYS A 124       5.028  37.929   5.836  1.00  0.00           C  
ATOM   1984  CE  LYS A 124       4.589  36.812   4.902  1.00  0.00           C  
ATOM   1985  NZ  LYS A 124       3.892  35.719   5.634  1.00  0.00           N  
ATOM   1986  H   LYS A 124       6.677  39.304   2.042  1.00  0.00           H  
ATOM   1987  HA  LYS A 124       6.627  41.612   3.570  1.00  0.00           H  
ATOM   1988  HB2 LYS A 124       5.163  40.506   4.924  1.00  0.00           H  
ATOM   1989  HB3 LYS A 124       5.154  39.388   3.567  1.00  0.00           H  
ATOM   1990  HG2 LYS A 124       6.836  38.011   4.714  1.00  0.00           H  
ATOM   1991  HG3 LYS A 124       6.779  39.117   6.088  1.00  0.00           H  
ATOM   1992  HD2 LYS A 124       5.308  37.498   6.787  1.00  0.00           H  
ATOM   1993  HD3 LYS A 124       4.204  38.612   5.978  1.00  0.00           H  
ATOM   1994  HE2 LYS A 124       3.920  37.222   4.161  1.00  0.00           H  
ATOM   1995  HE3 LYS A 124       5.463  36.405   4.413  1.00  0.00           H  
ATOM   1996  HZ1 LYS A 124       3.900  35.912   6.656  1.00  0.00           H  
ATOM   1997  HZ2 LYS A 124       4.369  34.811   5.460  1.00  0.00           H  
ATOM   1998  HZ3 LYS A 124       2.905  35.647   5.313  1.00  0.00           H  
ATOM   1999  N   GLU A 125       9.114  39.707   4.271  1.00  0.00           N  
ATOM   2000  CA  GLU A 125      10.332  39.574   5.062  1.00  0.00           C  
ATOM   2001  C   GLU A 125      11.239  40.786   4.871  1.00  0.00           C  
ATOM   2002  O   GLU A 125      11.802  41.311   5.832  1.00  0.00           O  
ATOM   2003  CB  GLU A 125      11.080  38.297   4.675  1.00  0.00           C  
ATOM   2004  CG  GLU A 125      10.579  37.056   5.393  1.00  0.00           C  
ATOM   2005  CD  GLU A 125      11.252  35.788   4.905  1.00  0.00           C  
ATOM   2006  OE1 GLU A 125      12.403  35.532   5.314  1.00  0.00           O  
ATOM   2007  OE2 GLU A 125      10.626  35.051   4.114  1.00  0.00           O  
ATOM   2008  H   GLU A 125       9.009  39.167   3.460  1.00  0.00           H  
ATOM   2009  HA  GLU A 125      10.048  39.513   6.101  1.00  0.00           H  
ATOM   2010  HB2 GLU A 125      10.976  38.140   3.612  1.00  0.00           H  
ATOM   2011  HB3 GLU A 125      12.127  38.424   4.909  1.00  0.00           H  
ATOM   2012  HG2 GLU A 125      10.773  37.164   6.450  1.00  0.00           H  
ATOM   2013  HG3 GLU A 125       9.515  36.967   5.231  1.00  0.00           H  
ATOM   2014  N   SER A 126      11.376  41.225   3.624  1.00  0.00           N  
ATOM   2015  CA  SER A 126      12.217  42.373   3.306  1.00  0.00           C  
ATOM   2016  C   SER A 126      11.387  43.652   3.230  1.00  0.00           C  
ATOM   2017  O   SER A 126      11.701  44.647   3.879  1.00  0.00           O  
ATOM   2018  CB  SER A 126      12.947  42.145   1.980  1.00  0.00           C  
ATOM   2019  OG  SER A 126      13.687  43.292   1.602  1.00  0.00           O  
ATOM   2020  H   SER A 126      10.900  40.766   2.901  1.00  0.00           H  
ATOM   2021  HA  SER A 126      12.947  42.478   4.095  1.00  0.00           H  
ATOM   2022  HB2 SER A 126      13.624  41.312   2.083  1.00  0.00           H  
ATOM   2023  HB3 SER A 126      12.223  41.928   1.208  1.00  0.00           H  
ATOM   2024  HG  SER A 126      14.101  43.677   2.379  1.00  0.00           H  
ATOM   2025  N   GLY A 127      10.326  43.613   2.430  1.00  0.00           N  
ATOM   2026  CA  GLY A 127       9.466  44.774   2.284  1.00  0.00           C  
ATOM   2027  C   GLY A 127       9.323  45.557   3.573  1.00  0.00           C  
ATOM   2028  O   GLY A 127       9.264  44.990   4.665  1.00  0.00           O  
ATOM   2029  H   GLY A 127      10.124  42.791   1.937  1.00  0.00           H  
ATOM   2030  HA2 GLY A 127       9.880  45.421   1.525  1.00  0.00           H  
ATOM   2031  HA3 GLY A 127       8.487  44.444   1.966  1.00  0.00           H  
ATOM   2032  N   PRO A 128       9.266  46.892   3.456  1.00  0.00           N  
ATOM   2033  CA  PRO A 128       9.130  47.782   4.613  1.00  0.00           C  
ATOM   2034  C   PRO A 128       7.754  47.683   5.262  1.00  0.00           C  
ATOM   2035  O   PRO A 128       7.602  47.928   6.458  1.00  0.00           O  
ATOM   2036  CB  PRO A 128       9.339  49.176   4.014  1.00  0.00           C  
ATOM   2037  CG  PRO A 128       8.951  49.034   2.582  1.00  0.00           C  
ATOM   2038  CD  PRO A 128       9.330  47.634   2.186  1.00  0.00           C  
ATOM   2039  HA  PRO A 128       9.892  47.589   5.354  1.00  0.00           H  
ATOM   2040  HB2 PRO A 128       8.708  49.888   4.526  1.00  0.00           H  
ATOM   2041  HB3 PRO A 128      10.374  49.463   4.116  1.00  0.00           H  
ATOM   2042  HG2 PRO A 128       7.887  49.180   2.474  1.00  0.00           H  
ATOM   2043  HG3 PRO A 128       9.493  49.752   1.984  1.00  0.00           H  
ATOM   2044  HD2 PRO A 128       8.623  47.239   1.472  1.00  0.00           H  
ATOM   2045  HD3 PRO A 128      10.331  47.615   1.780  1.00  0.00           H  
ATOM   2046  N   SER A 129       6.753  47.321   4.465  1.00  0.00           N  
ATOM   2047  CA  SER A 129       5.388  47.192   4.962  1.00  0.00           C  
ATOM   2048  C   SER A 129       5.378  46.651   6.389  1.00  0.00           C  
ATOM   2049  O   SER A 129       6.113  45.719   6.717  1.00  0.00           O  
ATOM   2050  CB  SER A 129       4.576  46.270   4.050  1.00  0.00           C  
ATOM   2051  OG  SER A 129       4.968  44.918   4.211  1.00  0.00           O  
ATOM   2052  H   SER A 129       6.938  47.138   3.520  1.00  0.00           H  
ATOM   2053  HA  SER A 129       4.941  48.174   4.959  1.00  0.00           H  
ATOM   2054  HB2 SER A 129       3.529  46.360   4.293  1.00  0.00           H  
ATOM   2055  HB3 SER A 129       4.733  46.558   3.021  1.00  0.00           H  
ATOM   2056  HG  SER A 129       5.919  44.846   4.106  1.00  0.00           H  
ATOM   2057  N   SER A 130       4.542  47.245   7.234  1.00  0.00           N  
ATOM   2058  CA  SER A 130       4.437  46.827   8.627  1.00  0.00           C  
ATOM   2059  C   SER A 130       3.197  45.966   8.845  1.00  0.00           C  
ATOM   2060  O   SER A 130       2.462  45.666   7.905  1.00  0.00           O  
ATOM   2061  CB  SER A 130       4.392  48.048   9.546  1.00  0.00           C  
ATOM   2062  OG  SER A 130       3.163  48.742   9.414  1.00  0.00           O  
ATOM   2063  H   SER A 130       3.982  47.983   6.912  1.00  0.00           H  
ATOM   2064  HA  SER A 130       5.314  46.241   8.864  1.00  0.00           H  
ATOM   2065  HB2 SER A 130       4.502  47.729  10.571  1.00  0.00           H  
ATOM   2066  HB3 SER A 130       5.199  48.719   9.289  1.00  0.00           H  
ATOM   2067  HG  SER A 130       2.437  48.145   9.610  1.00  0.00           H  
ATOM   2068  N   GLY A 131       2.970  45.572  10.094  1.00  0.00           N  
ATOM   2069  CA  GLY A 131       1.818  44.749  10.415  1.00  0.00           C  
ATOM   2070  C   GLY A 131       1.345  44.944  11.842  1.00  0.00           C  
ATOM   2071  O   GLY A 131       2.149  45.194  12.740  1.00  0.00           O  
ATOM   2072  H   GLY A 131       3.590  45.842  10.804  1.00  0.00           H  
ATOM   2073  HA2 GLY A 131       1.011  45.000   9.742  1.00  0.00           H  
ATOM   2074  HA3 GLY A 131       2.081  43.711  10.274  1.00  0.00           H  
TER    2075      GLY A 131                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
