
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  117 ( 1947),  selected  117 , name 2i7k_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2i7k_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     0_A      S       1          1.986
LGA    E     1_A      M       2          2.896
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    E     2_A      E       5          1.817
LGA    V     3_A      D       6          2.836
LGA    E     4_A      T       7          2.702
LGA    Q     5_A      F       8          1.894
LGA    T     6_A      R       9          1.553
LGA    P     7_A      E      10          1.615
LGA    L     8_A      L      11          1.316
LGA    Q     9_A      R      12          0.628
LGA    E    10_A      I      13          0.721
LGA    A    11_A      F      14          0.477
LGA    L    12_A      L      15          0.551
LGA    N    13_A      R      16          0.614
LGA    Q    14_A      N      17          0.956
LGA    L    15_A      V      18          0.891
LGA    M    16_A      T      19          0.647
LGA    R    17_A      H      20          0.792
LGA    Q    18_A      R      21          0.858
LGA    L    19_A      L      22          1.491
LGA    Q    20_A      A      23          1.724
LGA    R    21_A      I      24          1.913
LGA    K    22_A      D      25          1.973
LGA    D    23_A      K      26          2.015
LGA    P    24_A      R      27          2.643
LGA    S    25_A      F      28          1.940
LGA    A    26_A      R      29          0.935
LGA    F    27_A      V      30          1.401
LGA    F    28_A      F      31          1.495
LGA    S    29_A      T      32          0.534
LGA    F    30_A      K      33          0.916
LGA    P    31_A      P      34          1.647
LGA    V    32_A      V      35          1.775
LGA    T    33_A      D      36          2.927
LGA    D    34_A      P      37          1.539
LGA    F    35_A      D      38          3.435
LGA    I    36_A      E      39          5.106
LGA    A    37_A      V      40          4.074
LGA    P    38_A      P      41          5.943
LGA    G    39_A      D      42          2.957
LGA    Y    40_A      Y      43          2.480
LGA    S    41_A      V      44          1.055
LGA    M    42_A      T      45          1.157
LGA    I    43_A      V      46          0.591
LGA    I    44_A      I      47          0.636
LGA    K    45_A      K      48          0.923
LGA    H    46_A      Q      49          0.456
LGA    P    47_A      P      50          2.161
LGA    M    48_A      M      51          1.325
LGA    D    49_A      D      52          1.241
LGA    F    50_A      L      53          1.311
LGA    S    51_A      S      54          1.164
LGA    T    52_A      S      55          0.847
LGA    M    53_A      V      56          1.399
LGA    K    54_A      I      57          1.509
LGA    E    55_A      S      58          0.939
LGA    K    56_A      K      59          0.478
LGA    I    57_A      I      60          0.745
LGA    K    58_A      D      61          1.543
LGA    N    59_A      L      62          1.804
LGA    N    60_A      H      63          1.635
LGA    D    61_A      K      64          1.210
LGA    Y    62_A      Y      65          1.971
LGA    Q    63_A      L      66          3.259
LGA    S    64_A      T      67          1.285
LGA    I    65_A      V      68          1.727
LGA    E    66_A      K      69          1.354
LGA    E    67_A      D      70          0.593
LGA    L    68_A      Y      71          1.113
LGA    K    69_A      L      72          1.504
LGA    D    70_A      R      73          1.264
LGA    N    71_A      D      74          1.403
LGA    F    72_A      I      75          1.272
LGA    K    73_A      D      76          0.719
LGA    L    74_A      L      77          1.343
LGA    M    75_A      I      78          1.769
LGA    C    76_A      C      79          0.618
LGA    T    77_A      S      80          0.662
LGA    N    78_A      N      81          1.324
LGA    A    79_A      A      82          1.042
LGA    M    80_A      L      83          0.673
LGA    I    81_A      E      84          0.821
LGA    Y    82_A      Y      85          0.597
LGA    N    83_A      N      86          0.677
LGA    K    84_A      P      87          2.746
LGA    -       -      D      88           -
LGA    P    85_A      R      89          4.301
LGA    E    86_A      D      90          3.267
LGA    T    87_A      P      91          2.959
LGA    -       -      G      92           -
LGA    -       -      D      93           -
LGA    -       -      R      94           -
LGA    I    88_A      L      95          1.789
LGA    Y    89_A      I      96          1.386
LGA    Y    90_A      R      97          1.819
LGA    K    91_A      H      98          1.347
LGA    A    92_A      R      99          1.346
LGA    A    93_A      A     100          0.948
LGA    K    94_A      C     101          1.478
LGA    K    95_A      A     102          1.490
LGA    L    96_A      L     103          1.155
LGA    L    97_A      R     104          1.264
LGA    H    98_A      D     105          1.043
LGA    S    99_A      T     106          0.987
LGA    G   100_A      A     107          1.472
LGA    M   101_A      Y     108          1.249
LGA    K   102_A      A     109          0.808
LGA    I   103_A      I     110          1.547
LGA    L   104_A      I     111          2.268
LGA    S   105_A      K     112          1.916
LGA    Q   106_A      E     113          3.716
LGA    E   107_A      E     114          4.097
LGA    R   108_A      L     115          1.795
LGA    L   109_A      D     116          2.479
LGA    E   110_A      E     117          3.974
LGA    H   111_A      D     118           -
LGA    H   112_A      F     119           -
LGA    H   113_A      E     120           -
LGA    H   114_A      Q     121           -
LGA    H   115_A      L     122           -
LGA    H   116_A      C     123           -
LGA    -       -      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  117  130    5.0    111    1.93    26.13     76.235     5.466

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.076758 * X  +  -0.850826 * Y  +  -0.519811 * Z  + -14.008513
  Y_new =  -0.974616 * X  +   0.173999 * Y  +  -0.140885 * Z  +  40.868816
  Z_new =   0.210315 * X  +   0.495802 * Y  +  -0.842584 * Z  +   3.473283 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.609724   -0.531869  [ DEG:   149.5262    -30.4738 ]
  Theta =  -0.211898   -2.929695  [ DEG:   -12.1408   -167.8592 ]
  Phi   =  -1.649391    1.492201  [ DEG:   -94.5032     85.4968 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i7k_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i7k_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  117  130   5.0  111   1.93   26.13  76.235
REMARK  ---------------------------------------------------------- 
MOLECULE 2i7k_A
HEADER    TRANSCRIPTION                           31-AUG-06   2I7K              
TITLE     SOLUTION STRUCTURE OF THE BROMODOMAIN OF HUMAN BRD7 PROTEIN           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 7;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: BROMODOMAIN;                                               
COMPND   5 SYNONYM: 75 KDA BROMODOMAIN PROTEIN, PROTEIN CELTIX-1;               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 STRAIN: BRAIN;                                                       
SOURCE   5 GENE: BRD7;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET22B                                    
KEYWDS    HELIX, LEFT-HANDED FOUR-HELIX BUNDLE                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.SUN,J.LIU,J.ZHANG,H.HUANG,J.WU,Y.SHI                                
REVDAT   1   10-JUL-07 2I7K    0                                                
JRNL        AUTH   H.SUN,J.LIU,J.ZHANG,W.SHEN,H.HUANG,C.XU,H.DAI,J.WU,          
JRNL        AUTH 2 Y.SHI                                                        
JRNL        TITL   SOLUTION STRUCTURE OF BRD7 BROMODOMAIN AND ITS               
JRNL        TITL 2 INTERACTION WITH ACETYLATED PEPTIDES FROM HISTONE            
JRNL        TITL 3 H3 AND H4                                                    
JRNL        REF    BIOCHEM.BIOPHYS.RES.COMMUN.   V. 358   435 2007              
JRNL        REFN   ASTM BBRCA9  US ISSN 0006-291X                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2I7K A    1   108  UNP    Q9NPI1   BRD7_HUMAN     129    236             
SEQRES   1 A  117  MET GLU GLU VAL GLU GLN THR PRO LEU GLN GLU ALA LEU          
SEQRES   2 A  117  ASN GLN LEU MET ARG GLN LEU GLN ARG LYS ASP PRO SER          
SEQRES   3 A  117  ALA PHE PHE SER PHE PRO VAL THR ASP PHE ILE ALA PRO          
SEQRES   4 A  117  GLY TYR SER MET ILE ILE LYS HIS PRO MET ASP PHE SER          
SEQRES   5 A  117  THR MET LYS GLU LYS ILE LYS ASN ASN ASP TYR GLN SER          
SEQRES   6 A  117  ILE GLU GLU LEU LYS ASP ASN PHE LYS LEU MET CYS THR          
SEQRES   7 A  117  ASN ALA MET ILE TYR ASN LYS PRO GLU THR ILE TYR TYR          
SEQRES   8 A  117  LYS ALA ALA LYS LYS LEU LEU HIS SER GLY MET LYS ILE          
SEQRES   9 A  117  LEU SER GLN GLU ARG LEU GLU HIS HIS HIS HIS HIS HIS          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   0      14.958  48.443  -5.052  1.00  0.00           N  
ATOM      2  CA  MET A   0      14.398  47.276  -5.788  1.00  0.00           C  
ATOM      3  C   MET A   0      13.108  46.780  -5.137  1.00  0.00           C  
ATOM      4  O   MET A   0      12.951  46.867  -3.919  1.00  0.00           O  
ATOM      5  CB  MET A   0      15.446  46.156  -5.812  1.00  0.00           C  
ATOM      6  CG  MET A   0      16.170  46.028  -7.143  1.00  0.00           C  
ATOM      7  SD  MET A   0      15.691  44.548  -8.056  1.00  0.00           S  
ATOM      8  CE  MET A   0      17.276  43.734  -8.241  1.00  0.00           C  
ATOM      9  H2  MET A   0      14.948  48.213  -4.038  1.00  0.00           H  
ATOM     10  HA  MET A   0      14.184  47.581  -6.801  1.00  0.00           H  
ATOM     11  HB2 MET A   0      16.182  46.350  -5.045  1.00  0.00           H  
ATOM     12  HB3 MET A   0      14.960  45.215  -5.599  1.00  0.00           H  
ATOM     13  HG2 MET A   0      15.943  46.893  -7.748  1.00  0.00           H  
ATOM     14  HG3 MET A   0      17.233  45.989  -6.956  1.00  0.00           H  
ATOM     15  HE1 MET A   0      17.246  42.771  -7.755  1.00  0.00           H  
ATOM     16  HE2 MET A   0      18.047  44.340  -7.791  1.00  0.00           H  
ATOM     17  HE3 MET A   0      17.490  43.601  -9.290  1.00  0.00           H  
ATOM     18  H1  MET A   0      15.928  48.602  -5.392  1.00  0.00           H  
ATOM     19  H3  MET A   0      14.354  49.263  -5.257  1.00  0.00           H  
ATOM     20  N   GLU A   1      12.196  46.261  -5.967  1.00  0.00           N  
ATOM     21  CA  GLU A   1      10.909  45.739  -5.502  1.00  0.00           C  
ATOM     22  C   GLU A   1      10.027  46.847  -4.930  1.00  0.00           C  
ATOM     23  O   GLU A   1      10.289  47.376  -3.848  1.00  0.00           O  
ATOM     24  CB  GLU A   1      11.113  44.633  -4.464  1.00  0.00           C  
ATOM     25  CG  GLU A   1      11.164  43.241  -5.073  1.00  0.00           C  
ATOM     26  CD  GLU A   1      10.672  42.167  -4.124  1.00  0.00           C  
ATOM     27  OE1 GLU A   1       9.440  42.012  -3.990  1.00  0.00           O  
ATOM     28  OE2 GLU A   1      11.521  41.482  -3.516  1.00  0.00           O  
ATOM     29  H   GLU A   1      12.396  46.224  -6.924  1.00  0.00           H  
ATOM     30  HA  GLU A   1      10.405  45.316  -6.357  1.00  0.00           H  
ATOM     31  HB2 GLU A   1      12.040  44.811  -3.942  1.00  0.00           H  
ATOM     32  HB3 GLU A   1      10.298  44.666  -3.755  1.00  0.00           H  
ATOM     33  HG2 GLU A   1      10.546  43.227  -5.959  1.00  0.00           H  
ATOM     34  HG3 GLU A   1      12.187  43.021  -5.344  1.00  0.00           H  
ATOM     35  N   GLU A   2       8.976  47.185  -5.674  1.00  0.00           N  
ATOM     36  CA  GLU A   2       8.030  48.226  -5.267  1.00  0.00           C  
ATOM     37  C   GLU A   2       6.801  48.232  -6.178  1.00  0.00           C  
ATOM     38  O   GLU A   2       5.664  48.284  -5.704  1.00  0.00           O  
ATOM     39  CB  GLU A   2       8.695  49.604  -5.292  1.00  0.00           C  
ATOM     40  CG  GLU A   2       8.182  50.546  -4.214  1.00  0.00           C  
ATOM     41  CD  GLU A   2       9.224  50.845  -3.153  1.00  0.00           C  
ATOM     42  OE1 GLU A   2       9.614  49.911  -2.421  1.00  0.00           O  
ATOM     43  OE2 GLU A   2       9.649  52.015  -3.051  1.00  0.00           O  
ATOM     44  H   GLU A   2       8.828  46.717  -6.522  1.00  0.00           H  
ATOM     45  HA  GLU A   2       7.714  48.008  -4.257  1.00  0.00           H  
ATOM     46  HB2 GLU A   2       9.760  49.481  -5.157  1.00  0.00           H  
ATOM     47  HB3 GLU A   2       8.516  50.063  -6.253  1.00  0.00           H  
ATOM     48  HG2 GLU A   2       7.887  51.475  -4.676  1.00  0.00           H  
ATOM     49  HG3 GLU A   2       7.325  50.094  -3.738  1.00  0.00           H  
ATOM     50  N   VAL A   3       7.042  48.179  -7.491  1.00  0.00           N  
ATOM     51  CA  VAL A   3       5.961  48.179  -8.480  1.00  0.00           C  
ATOM     52  C   VAL A   3       5.150  46.880  -8.453  1.00  0.00           C  
ATOM     53  O   VAL A   3       4.043  46.837  -8.978  1.00  0.00           O  
ATOM     54  CB  VAL A   3       6.497  48.395  -9.910  1.00  0.00           C  
ATOM     55  CG1 VAL A   3       6.982  49.825 -10.085  1.00  0.00           C  
ATOM     56  CG2 VAL A   3       7.604  47.397 -10.239  1.00  0.00           C  
ATOM     57  H   VAL A   3       7.970  48.141  -7.803  1.00  0.00           H  
ATOM     58  HA  VAL A   3       5.303  49.000  -8.242  1.00  0.00           H  
ATOM     59  HB  VAL A   3       5.682  48.233 -10.600  1.00  0.00           H  
ATOM     60 HG11 VAL A   3       7.606  49.891 -10.964  1.00  0.00           H  
ATOM     61 HG12 VAL A   3       7.553  50.123  -9.217  1.00  0.00           H  
ATOM     62 HG13 VAL A   3       6.131  50.483 -10.197  1.00  0.00           H  
ATOM     63 HG21 VAL A   3       7.512  46.532  -9.599  1.00  0.00           H  
ATOM     64 HG22 VAL A   3       8.566  47.861 -10.086  1.00  0.00           H  
ATOM     65 HG23 VAL A   3       7.513  47.090 -11.271  1.00  0.00           H  
ATOM     66  N   GLU A   4       5.701  45.827  -7.846  1.00  0.00           N  
ATOM     67  CA  GLU A   4       5.006  44.542  -7.768  1.00  0.00           C  
ATOM     68  C   GLU A   4       3.839  44.584  -6.773  1.00  0.00           C  
ATOM     69  O   GLU A   4       3.004  43.678  -6.756  1.00  0.00           O  
ATOM     70  CB  GLU A   4       5.978  43.424  -7.381  1.00  0.00           C  
ATOM     71  CG  GLU A   4       6.640  42.754  -8.575  1.00  0.00           C  
ATOM     72  CD  GLU A   4       5.772  41.675  -9.198  1.00  0.00           C  
ATOM     73  OE1 GLU A   4       4.620  41.980  -9.573  1.00  0.00           O  
ATOM     74  OE2 GLU A   4       6.246  40.526  -9.310  1.00  0.00           O  
ATOM     75  H   GLU A   4       6.592  45.913  -7.445  1.00  0.00           H  
ATOM     76  HA  GLU A   4       4.608  44.331  -8.750  1.00  0.00           H  
ATOM     77  HB2 GLU A   4       6.751  43.834  -6.749  1.00  0.00           H  
ATOM     78  HB3 GLU A   4       5.435  42.670  -6.829  1.00  0.00           H  
ATOM     79  HG2 GLU A   4       6.847  43.503  -9.323  1.00  0.00           H  
ATOM     80  HG3 GLU A   4       7.568  42.307  -8.248  1.00  0.00           H  
ATOM     81  N   GLN A   5       3.782  45.632  -5.948  1.00  0.00           N  
ATOM     82  CA  GLN A   5       2.713  45.771  -4.962  1.00  0.00           C  
ATOM     83  C   GLN A   5       1.419  46.274  -5.604  1.00  0.00           C  
ATOM     84  O   GLN A   5       0.323  45.908  -5.176  1.00  0.00           O  
ATOM     85  CB  GLN A   5       3.144  46.726  -3.849  1.00  0.00           C  
ATOM     86  CG  GLN A   5       4.104  46.099  -2.854  1.00  0.00           C  
ATOM     87  CD  GLN A   5       5.532  46.577  -3.035  1.00  0.00           C  
ATOM     88  OE1 GLN A   5       5.890  47.674  -2.610  1.00  0.00           O  
ATOM     89  NE2 GLN A   5       6.357  45.753  -3.674  1.00  0.00           N  
ATOM     90  H   GLN A   5       4.470  46.326  -6.003  1.00  0.00           H  
ATOM     91  HA  GLN A   5       2.530  44.797  -4.536  1.00  0.00           H  
ATOM     92  HB2 GLN A   5       3.626  47.585  -4.293  1.00  0.00           H  
ATOM     93  HB3 GLN A   5       2.267  47.053  -3.313  1.00  0.00           H  
ATOM     94  HG2 GLN A   5       3.781  46.347  -1.854  1.00  0.00           H  
ATOM     95  HG3 GLN A   5       4.082  45.025  -2.982  1.00  0.00           H  
ATOM     96 HE21 GLN A   5       6.003  44.894  -3.989  1.00  0.00           H  
ATOM     97 HE22 GLN A   5       7.285  46.036  -3.799  1.00  0.00           H  
ATOM     98  N   THR A   6       1.551  47.119  -6.626  1.00  0.00           N  
ATOM     99  CA  THR A   6       0.390  47.678  -7.319  1.00  0.00           C  
ATOM    100  C   THR A   6      -0.490  46.576  -7.924  1.00  0.00           C  
ATOM    101  O   THR A   6      -1.689  46.519  -7.645  1.00  0.00           O  
ATOM    102  CB  THR A   6       0.825  48.664  -8.415  1.00  0.00           C  
ATOM    103  OG1 THR A   6       2.233  48.862  -8.403  1.00  0.00           O  
ATOM    104  CG2 THR A   6       0.166  50.023  -8.288  1.00  0.00           C  
ATOM    105  H   THR A   6       2.451  47.377  -6.919  1.00  0.00           H  
ATOM    106  HA  THR A   6      -0.194  48.213  -6.586  1.00  0.00           H  
ATOM    107  HB  THR A   6       0.551  48.256  -9.376  1.00  0.00           H  
ATOM    108  HG1 THR A   6       2.479  49.418  -7.659  1.00  0.00           H  
ATOM    109 HG21 THR A   6      -0.290  50.289  -9.228  1.00  0.00           H  
ATOM    110 HG22 THR A   6       0.910  50.760  -8.025  1.00  0.00           H  
ATOM    111 HG23 THR A   6      -0.590  49.986  -7.518  1.00  0.00           H  
ATOM    112  N   PRO A   7       0.089  45.683  -8.758  1.00  0.00           N  
ATOM    113  CA  PRO A   7      -0.658  44.586  -9.392  1.00  0.00           C  
ATOM    114  C   PRO A   7      -1.454  43.760  -8.381  1.00  0.00           C  
ATOM    115  O   PRO A   7      -2.612  43.418  -8.629  1.00  0.00           O  
ATOM    116  CB  PRO A   7       0.438  43.731 -10.035  1.00  0.00           C  
ATOM    117  CG  PRO A   7       1.566  44.673 -10.268  1.00  0.00           C  
ATOM    118  CD  PRO A   7       1.512  45.671  -9.147  1.00  0.00           C  
ATOM    119  HA  PRO A   7      -1.323  44.956 -10.157  1.00  0.00           H  
ATOM    120  HB2 PRO A   7       0.719  42.935  -9.360  1.00  0.00           H  
ATOM    121  HB3 PRO A   7       0.075  43.314 -10.962  1.00  0.00           H  
ATOM    122  HG2 PRO A   7       2.501  44.133 -10.246  1.00  0.00           H  
ATOM    123  HG3 PRO A   7       1.440  45.169 -11.219  1.00  0.00           H  
ATOM    124  HD3 PRO A   7       2.133  45.346  -8.324  1.00  0.00           H  
ATOM    125  HD2 PRO A   7       1.822  46.645  -9.495  1.00  0.00           H  
ATOM    126  N   LEU A   8      -0.828  43.453  -7.242  1.00  0.00           N  
ATOM    127  CA  LEU A   8      -1.483  42.677  -6.187  1.00  0.00           C  
ATOM    128  C   LEU A   8      -2.746  43.389  -5.697  1.00  0.00           C  
ATOM    129  O   LEU A   8      -3.781  42.753  -5.487  1.00  0.00           O  
ATOM    130  CB  LEU A   8      -0.521  42.446  -5.013  1.00  0.00           C  
ATOM    131  CG  LEU A   8      -0.314  40.980  -4.613  1.00  0.00           C  
ATOM    132  CD1 LEU A   8      -1.634  40.338  -4.213  1.00  0.00           C  
ATOM    133  CD2 LEU A   8       0.341  40.203  -5.747  1.00  0.00           C  
ATOM    134  H   LEU A   8       0.092  43.761  -7.104  1.00  0.00           H  
ATOM    135  HA  LEU A   8      -1.763  41.723  -6.606  1.00  0.00           H  
ATOM    136  HB2 LEU A   8       0.441  42.865  -5.275  1.00  0.00           H  
ATOM    137  HB3 LEU A   8      -0.902  42.978  -4.154  1.00  0.00           H  
ATOM    138  HG  LEU A   8       0.346  40.941  -3.759  1.00  0.00           H  
ATOM    139 HD11 LEU A   8      -1.828  40.536  -3.170  1.00  0.00           H  
ATOM    140 HD12 LEU A   8      -1.577  39.271  -4.371  1.00  0.00           H  
ATOM    141 HD13 LEU A   8      -2.433  40.749  -4.812  1.00  0.00           H  
ATOM    142 HD21 LEU A   8      -0.420  39.718  -6.340  1.00  0.00           H  
ATOM    143 HD22 LEU A   8       1.006  39.459  -5.335  1.00  0.00           H  
ATOM    144 HD23 LEU A   8       0.905  40.882  -6.371  1.00  0.00           H  
ATOM    145  N   GLN A   9      -2.654  44.710  -5.530  1.00  0.00           N  
ATOM    146  CA  GLN A   9      -3.790  45.513  -5.077  1.00  0.00           C  
ATOM    147  C   GLN A   9      -4.964  45.403  -6.052  1.00  0.00           C  
ATOM    148  O   GLN A   9      -6.123  45.357  -5.636  1.00  0.00           O  
ATOM    149  CB  GLN A   9      -3.380  46.980  -4.923  1.00  0.00           C  
ATOM    150  CG  GLN A   9      -4.338  47.792  -4.068  1.00  0.00           C  
ATOM    151  CD  GLN A   9      -4.208  49.287  -4.295  1.00  0.00           C  
ATOM    152  OE1 GLN A   9      -4.987  49.883  -5.039  1.00  0.00           O  
ATOM    153  NE2 GLN A   9      -3.222  49.901  -3.651  1.00  0.00           N  
ATOM    154  H   GLN A   9      -1.804  45.158  -5.724  1.00  0.00           H  
ATOM    155  HA  GLN A   9      -4.101  45.133  -4.116  1.00  0.00           H  
ATOM    156  HB2 GLN A   9      -2.402  47.023  -4.469  1.00  0.00           H  
ATOM    157  HB3 GLN A   9      -3.332  47.434  -5.903  1.00  0.00           H  
ATOM    158  HG2 GLN A   9      -5.351  47.496  -4.304  1.00  0.00           H  
ATOM    159  HG3 GLN A   9      -4.136  47.582  -3.029  1.00  0.00           H  
ATOM    160 HE21 GLN A   9      -2.641  49.364  -3.072  1.00  0.00           H  
ATOM    161 HE22 GLN A   9      -3.117  50.865  -3.779  1.00  0.00           H  
ATOM    162  N   GLU A  10      -4.654  45.359  -7.350  1.00  0.00           N  
ATOM    163  CA  GLU A  10      -5.679  45.250  -8.384  1.00  0.00           C  
ATOM    164  C   GLU A  10      -6.475  43.954  -8.229  1.00  0.00           C  
ATOM    165  O   GLU A  10      -7.708  43.964  -8.279  1.00  0.00           O  
ATOM    166  CB  GLU A  10      -5.042  45.309  -9.776  1.00  0.00           C  
ATOM    167  CG  GLU A  10      -6.047  45.501 -10.899  1.00  0.00           C  
ATOM    168  CD  GLU A  10      -5.575  44.916 -12.215  1.00  0.00           C  
ATOM    169  OE1 GLU A  10      -4.638  45.484 -12.817  1.00  0.00           O  
ATOM    170  OE2 GLU A  10      -6.141  43.888 -12.644  1.00  0.00           O  
ATOM    171  H   GLU A  10      -3.711  45.397  -7.617  1.00  0.00           H  
ATOM    172  HA  GLU A  10      -6.352  46.086  -8.272  1.00  0.00           H  
ATOM    173  HB2 GLU A  10      -4.342  46.131  -9.804  1.00  0.00           H  
ATOM    174  HB3 GLU A  10      -4.506  44.387  -9.954  1.00  0.00           H  
ATOM    175  HG2 GLU A  10      -6.974  45.020 -10.622  1.00  0.00           H  
ATOM    176  HG3 GLU A  10      -6.219  46.558 -11.033  1.00  0.00           H  
ATOM    177  N   ALA A  11      -5.765  42.840  -8.033  1.00  0.00           N  
ATOM    178  CA  ALA A  11      -6.404  41.536  -7.864  1.00  0.00           C  
ATOM    179  C   ALA A  11      -7.310  41.529  -6.636  1.00  0.00           C  
ATOM    180  O   ALA A  11      -8.458  41.091  -6.707  1.00  0.00           O  
ATOM    181  CB  ALA A  11      -5.357  40.435  -7.758  1.00  0.00           C  
ATOM    182  H   ALA A  11      -4.786  42.899  -8.000  1.00  0.00           H  
ATOM    183  HA  ALA A  11      -7.007  41.344  -8.740  1.00  0.00           H  
ATOM    184  HB1 ALA A  11      -5.151  40.038  -8.742  1.00  0.00           H  
ATOM    185  HB2 ALA A  11      -5.728  39.644  -7.122  1.00  0.00           H  
ATOM    186  HB3 ALA A  11      -4.448  40.837  -7.335  1.00  0.00           H  
ATOM    187  N   LEU A  12      -6.788  42.030  -5.515  1.00  0.00           N  
ATOM    188  CA  LEU A  12      -7.553  42.090  -4.273  1.00  0.00           C  
ATOM    189  C   LEU A  12      -8.800  42.960  -4.439  1.00  0.00           C  
ATOM    190  O   LEU A  12      -9.879  42.601  -3.967  1.00  0.00           O  
ATOM    191  CB  LEU A  12      -6.686  42.630  -3.133  1.00  0.00           C  
ATOM    192  CG  LEU A  12      -6.030  41.559  -2.258  1.00  0.00           C  
ATOM    193  CD1 LEU A  12      -4.855  40.919  -2.983  1.00  0.00           C  
ATOM    194  CD2 LEU A  12      -5.581  42.154  -0.931  1.00  0.00           C  
ATOM    195  H   LEU A  12      -5.868  42.371  -5.528  1.00  0.00           H  
ATOM    196  HA  LEU A  12      -7.863  41.086  -4.030  1.00  0.00           H  
ATOM    197  HB2 LEU A  12      -5.907  43.246  -3.560  1.00  0.00           H  
ATOM    198  HB3 LEU A  12      -7.305  43.249  -2.500  1.00  0.00           H  
ATOM    199  HG  LEU A  12      -6.754  40.783  -2.050  1.00  0.00           H  
ATOM    200 HD11 LEU A  12      -4.206  40.440  -2.266  1.00  0.00           H  
ATOM    201 HD12 LEU A  12      -4.304  41.676  -3.517  1.00  0.00           H  
ATOM    202 HD13 LEU A  12      -5.223  40.183  -3.682  1.00  0.00           H  
ATOM    203 HD21 LEU A  12      -5.894  43.186  -0.875  1.00  0.00           H  
ATOM    204 HD22 LEU A  12      -4.506  42.098  -0.857  1.00  0.00           H  
ATOM    205 HD23 LEU A  12      -6.025  41.599  -0.118  1.00  0.00           H  
ATOM    206  N   ASN A  13      -8.645  44.097  -5.126  1.00  0.00           N  
ATOM    207  CA  ASN A  13      -9.765  45.005  -5.367  1.00  0.00           C  
ATOM    208  C   ASN A  13     -10.878  44.291  -6.132  1.00  0.00           C  
ATOM    209  O   ASN A  13     -12.062  44.530  -5.887  1.00  0.00           O  
ATOM    210  CB  ASN A  13      -9.300  46.239  -6.147  1.00  0.00           C  
ATOM    211  CG  ASN A  13      -8.948  47.404  -5.238  1.00  0.00           C  
ATOM    212  OD1 ASN A  13      -9.634  47.665  -4.250  1.00  0.00           O  
ATOM    213  ND2 ASN A  13      -7.875  48.116  -5.572  1.00  0.00           N  
ATOM    214  H   ASN A  13      -7.761  44.323  -5.485  1.00  0.00           H  
ATOM    215  HA  ASN A  13     -10.148  45.318  -4.408  1.00  0.00           H  
ATOM    216  HB2 ASN A  13      -8.426  45.983  -6.727  1.00  0.00           H  
ATOM    217  HB3 ASN A  13     -10.090  46.552  -6.816  1.00  0.00           H  
ATOM    218 HD21 ASN A  13      -7.375  47.857  -6.375  1.00  0.00           H  
ATOM    219 HD22 ASN A  13      -7.627  48.871  -5.000  1.00  0.00           H  
ATOM    220  N   GLN A  14     -10.487  43.405  -7.050  1.00  0.00           N  
ATOM    221  CA  GLN A  14     -11.447  42.645  -7.844  1.00  0.00           C  
ATOM    222  C   GLN A  14     -12.265  41.712  -6.952  1.00  0.00           C  
ATOM    223  O   GLN A  14     -13.483  41.618  -7.095  1.00  0.00           O  
ATOM    224  CB  GLN A  14     -10.723  41.830  -8.921  1.00  0.00           C  
ATOM    225  CG  GLN A  14     -11.025  42.288 -10.338  1.00  0.00           C  
ATOM    226  CD  GLN A  14      -9.813  42.203 -11.248  1.00  0.00           C  
ATOM    227  OE1 GLN A  14      -9.278  41.120 -11.487  1.00  0.00           O  
ATOM    228  NE2 GLN A  14      -9.371  43.346 -11.758  1.00  0.00           N  
ATOM    229  H   GLN A  14      -9.529  43.254  -7.192  1.00  0.00           H  
ATOM    230  HA  GLN A  14     -12.116  43.346  -8.319  1.00  0.00           H  
ATOM    231  HB2 GLN A  14      -9.659  41.910  -8.760  1.00  0.00           H  
ATOM    232  HB3 GLN A  14     -11.015  40.796  -8.830  1.00  0.00           H  
ATOM    233  HG2 GLN A  14     -11.808  41.663 -10.747  1.00  0.00           H  
ATOM    234  HG3 GLN A  14     -11.364  43.313 -10.308  1.00  0.00           H  
ATOM    235 HE21 GLN A  14      -9.846  44.173 -11.525  1.00  0.00           H  
ATOM    236 HE22 GLN A  14      -8.587  43.319 -12.347  1.00  0.00           H  
ATOM    237  N   LEU A  15     -11.583  41.030  -6.028  1.00  0.00           N  
ATOM    238  CA  LEU A  15     -12.248  40.108  -5.104  1.00  0.00           C  
ATOM    239  C   LEU A  15     -13.287  40.847  -4.262  1.00  0.00           C  
ATOM    240  O   LEU A  15     -14.409  40.373  -4.096  1.00  0.00           O  
ATOM    241  CB  LEU A  15     -11.228  39.422  -4.184  1.00  0.00           C  
ATOM    242  CG  LEU A  15      -9.958  38.901  -4.863  1.00  0.00           C  
ATOM    243  CD1 LEU A  15      -9.103  38.131  -3.868  1.00  0.00           C  
ATOM    244  CD2 LEU A  15     -10.301  38.025  -6.062  1.00  0.00           C  
ATOM    245  H   LEU A  15     -10.613  41.155  -5.961  1.00  0.00           H  
ATOM    246  HA  LEU A  15     -12.752  39.357  -5.691  1.00  0.00           H  
ATOM    247  HB2 LEU A  15     -10.935  40.131  -3.420  1.00  0.00           H  
ATOM    248  HB3 LEU A  15     -11.720  38.590  -3.704  1.00  0.00           H  
ATOM    249  HG  LEU A  15      -9.376  39.740  -5.216  1.00  0.00           H  
ATOM    250 HD11 LEU A  15      -9.295  37.073  -3.971  1.00  0.00           H  
ATOM    251 HD12 LEU A  15      -9.347  38.445  -2.865  1.00  0.00           H  
ATOM    252 HD13 LEU A  15      -8.060  38.328  -4.063  1.00  0.00           H  
ATOM    253 HD21 LEU A  15      -9.433  37.928  -6.698  1.00  0.00           H  
ATOM    254 HD22 LEU A  15     -11.107  38.477  -6.622  1.00  0.00           H  
ATOM    255 HD23 LEU A  15     -10.605  37.048  -5.719  1.00  0.00           H  
ATOM    256  N   MET A  16     -12.902  42.014  -3.739  1.00  0.00           N  
ATOM    257  CA  MET A  16     -13.802  42.823  -2.917  1.00  0.00           C  
ATOM    258  C   MET A  16     -14.971  43.357  -3.744  1.00  0.00           C  
ATOM    259  O   MET A  16     -16.113  43.348  -3.286  1.00  0.00           O  
ATOM    260  CB  MET A  16     -13.043  43.989  -2.274  1.00  0.00           C  
ATOM    261  CG  MET A  16     -12.805  43.813  -0.782  1.00  0.00           C  
ATOM    262  SD  MET A  16     -11.648  42.478  -0.415  1.00  0.00           S  
ATOM    263  CE  MET A  16     -12.779  41.141  -0.037  1.00  0.00           C  
ATOM    264  H   MET A  16     -11.993  42.339  -3.913  1.00  0.00           H  
ATOM    265  HA  MET A  16     -14.195  42.188  -2.137  1.00  0.00           H  
ATOM    266  HB2 MET A  16     -12.086  44.092  -2.761  1.00  0.00           H  
ATOM    267  HB3 MET A  16     -13.612  44.896  -2.420  1.00  0.00           H  
ATOM    268  HG2 MET A  16     -12.404  44.733  -0.386  1.00  0.00           H  
ATOM    269  HG3 MET A  16     -13.747  43.595  -0.303  1.00  0.00           H  
ATOM    270  HE1 MET A  16     -13.118  40.686  -0.956  1.00  0.00           H  
ATOM    271  HE2 MET A  16     -13.627  41.532   0.508  1.00  0.00           H  
ATOM    272  HE3 MET A  16     -12.274  40.401   0.566  1.00  0.00           H  
ATOM    273  N   ARG A  17     -14.681  43.818  -4.963  1.00  0.00           N  
ATOM    274  CA  ARG A  17     -15.716  44.353  -5.849  1.00  0.00           C  
ATOM    275  C   ARG A  17     -16.721  43.268  -6.234  1.00  0.00           C  
ATOM    276  O   ARG A  17     -17.931  43.488  -6.179  1.00  0.00           O  
ATOM    277  CB  ARG A  17     -15.085  44.952  -7.109  1.00  0.00           C  
ATOM    278  CG  ARG A  17     -14.652  46.400  -6.946  1.00  0.00           C  
ATOM    279  CD  ARG A  17     -15.095  47.254  -8.125  1.00  0.00           C  
ATOM    280  NE  ARG A  17     -13.971  47.652  -8.971  1.00  0.00           N  
ATOM    281  CZ  ARG A  17     -13.118  48.636  -8.668  1.00  0.00           C  
ATOM    282  NH1 ARG A  17     -13.248  49.319  -7.531  1.00  0.00           N  
ATOM    283  NH2 ARG A  17     -12.126  48.934  -9.502  1.00  0.00           N  
ATOM    284  H   ARG A  17     -13.750  43.797  -5.273  1.00  0.00           H  
ATOM    285  HA  ARG A  17     -16.237  45.132  -5.313  1.00  0.00           H  
ATOM    286  HB2 ARG A  17     -14.217  44.367  -7.375  1.00  0.00           H  
ATOM    287  HB3 ARG A  17     -15.803  44.900  -7.916  1.00  0.00           H  
ATOM    288  HG2 ARG A  17     -15.093  46.798  -6.043  1.00  0.00           H  
ATOM    289  HG3 ARG A  17     -13.576  46.438  -6.870  1.00  0.00           H  
ATOM    290  HD2 ARG A  17     -15.797  46.688  -8.722  1.00  0.00           H  
ATOM    291  HD3 ARG A  17     -15.583  48.140  -7.748  1.00  0.00           H  
ATOM    292  HE  ARG A  17     -13.847  47.166  -9.812  1.00  0.00           H  
ATOM    293 HH11 ARG A  17     -13.988  49.098  -6.896  1.00  0.00           H  
ATOM    294 HH12 ARG A  17     -12.606  50.053  -7.313  1.00  0.00           H  
ATOM    295 HH21 ARG A  17     -12.022  48.425 -10.356  1.00  0.00           H  
ATOM    296 HH22 ARG A  17     -11.489  49.672  -9.279  1.00  0.00           H  
ATOM    297  N   GLN A  18     -16.211  42.096  -6.612  1.00  0.00           N  
ATOM    298  CA  GLN A  18     -17.066  40.976  -6.995  1.00  0.00           C  
ATOM    299  C   GLN A  18     -17.830  40.447  -5.783  1.00  0.00           C  
ATOM    300  O   GLN A  18     -19.012  40.115  -5.879  1.00  0.00           O  
ATOM    301  CB  GLN A  18     -16.233  39.854  -7.616  1.00  0.00           C  
ATOM    302  CG  GLN A  18     -16.895  39.191  -8.816  1.00  0.00           C  
ATOM    303  CD  GLN A  18     -16.452  37.753  -9.009  1.00  0.00           C  
ATOM    304  OE1 GLN A  18     -17.278  36.861  -9.204  1.00  0.00           O  
ATOM    305  NE2 GLN A  18     -15.145  37.518  -8.960  1.00  0.00           N  
ATOM    306  H   GLN A  18     -15.236  41.980  -6.628  1.00  0.00           H  
ATOM    307  HA  GLN A  18     -17.776  41.335  -7.725  1.00  0.00           H  
ATOM    308  HB2 GLN A  18     -15.284  40.259  -7.936  1.00  0.00           H  
ATOM    309  HB3 GLN A  18     -16.055  39.095  -6.869  1.00  0.00           H  
ATOM    310  HG2 GLN A  18     -17.964  39.207  -8.673  1.00  0.00           H  
ATOM    311  HG3 GLN A  18     -16.643  39.753  -9.704  1.00  0.00           H  
ATOM    312 HE21 GLN A  18     -14.542  38.275  -8.803  1.00  0.00           H  
ATOM    313 HE22 GLN A  18     -14.839  36.597  -9.080  1.00  0.00           H  
ATOM    314  N   LEU A  19     -17.142  40.379  -4.644  1.00  0.00           N  
ATOM    315  CA  LEU A  19     -17.742  39.899  -3.403  1.00  0.00           C  
ATOM    316  C   LEU A  19     -18.838  40.851  -2.921  1.00  0.00           C  
ATOM    317  O   LEU A  19     -19.912  40.412  -2.504  1.00  0.00           O  
ATOM    318  CB  LEU A  19     -16.660  39.732  -2.328  1.00  0.00           C  
ATOM    319  CG  LEU A  19     -17.153  39.743  -0.878  1.00  0.00           C  
ATOM    320  CD1 LEU A  19     -16.395  38.715  -0.049  1.00  0.00           C  
ATOM    321  CD2 LEU A  19     -17.003  41.134  -0.280  1.00  0.00           C  
ATOM    322  H   LEU A  19     -16.201  40.662  -4.636  1.00  0.00           H  
ATOM    323  HA  LEU A  19     -18.185  38.934  -3.604  1.00  0.00           H  
ATOM    324  HB2 LEU A  19     -16.153  38.796  -2.504  1.00  0.00           H  
ATOM    325  HB3 LEU A  19     -15.943  40.532  -2.444  1.00  0.00           H  
ATOM    326  HG  LEU A  19     -18.199  39.478  -0.858  1.00  0.00           H  
ATOM    327 HD11 LEU A  19     -16.896  37.762  -0.114  1.00  0.00           H  
ATOM    328 HD12 LEU A  19     -16.363  39.036   0.982  1.00  0.00           H  
ATOM    329 HD13 LEU A  19     -15.387  38.619  -0.427  1.00  0.00           H  
ATOM    330 HD21 LEU A  19     -16.716  41.831  -1.052  1.00  0.00           H  
ATOM    331 HD22 LEU A  19     -16.245  41.116   0.490  1.00  0.00           H  
ATOM    332 HD23 LEU A  19     -17.944  41.442   0.151  1.00  0.00           H  
ATOM    333  N   GLN A  20     -18.567  42.155  -2.989  1.00  0.00           N  
ATOM    334  CA  GLN A  20     -19.533  43.168  -2.567  1.00  0.00           C  
ATOM    335  C   GLN A  20     -20.756  43.176  -3.493  1.00  0.00           C  
ATOM    336  O   GLN A  20     -21.884  43.382  -3.044  1.00  0.00           O  
ATOM    337  CB  GLN A  20     -18.884  44.558  -2.542  1.00  0.00           C  
ATOM    338  CG  GLN A  20     -18.418  44.991  -1.160  1.00  0.00           C  
ATOM    339  CD  GLN A  20     -17.523  46.215  -1.195  1.00  0.00           C  
ATOM    340  OE1 GLN A  20     -17.995  47.339  -1.378  1.00  0.00           O  
ATOM    341  NE2 GLN A  20     -16.223  46.007  -1.019  1.00  0.00           N  
ATOM    342  H   GLN A  20     -17.696  42.443  -3.336  1.00  0.00           H  
ATOM    343  HA  GLN A  20     -19.857  42.914  -1.567  1.00  0.00           H  
ATOM    344  HB2 GLN A  20     -18.030  44.555  -3.201  1.00  0.00           H  
ATOM    345  HB3 GLN A  20     -19.600  45.283  -2.899  1.00  0.00           H  
ATOM    346  HG2 GLN A  20     -19.284  45.218  -0.557  1.00  0.00           H  
ATOM    347  HG3 GLN A  20     -17.871  44.176  -0.708  1.00  0.00           H  
ATOM    348 HE21 GLN A  20     -15.916  45.087  -0.876  1.00  0.00           H  
ATOM    349 HE22 GLN A  20     -15.622  46.779  -1.038  1.00  0.00           H  
ATOM    350  N   ARG A  21     -20.512  42.952  -4.789  1.00  0.00           N  
ATOM    351  CA  ARG A  21     -21.578  42.930  -5.795  1.00  0.00           C  
ATOM    352  C   ARG A  21     -22.588  41.801  -5.548  1.00  0.00           C  
ATOM    353  O   ARG A  21     -23.684  41.822  -6.108  1.00  0.00           O  
ATOM    354  CB  ARG A  21     -20.977  42.781  -7.196  1.00  0.00           C  
ATOM    355  CG  ARG A  21     -20.995  44.064  -8.016  1.00  0.00           C  
ATOM    356  CD  ARG A  21     -22.148  44.080  -9.010  1.00  0.00           C  
ATOM    357  NE  ARG A  21     -21.747  44.614 -10.313  1.00  0.00           N  
ATOM    358  CZ  ARG A  21     -21.060  43.922 -11.228  1.00  0.00           C  
ATOM    359  NH1 ARG A  21     -20.679  42.669 -10.984  1.00  0.00           N  
ATOM    360  NH2 ARG A  21     -20.750  44.487 -12.390  1.00  0.00           N  
ATOM    361  H   ARG A  21     -19.588  42.796  -5.078  1.00  0.00           H  
ATOM    362  HA  ARG A  21     -22.098  43.874  -5.740  1.00  0.00           H  
ATOM    363  HB2 ARG A  21     -19.949  42.458  -7.101  1.00  0.00           H  
ATOM    364  HB3 ARG A  21     -21.530  42.027  -7.733  1.00  0.00           H  
ATOM    365  HG2 ARG A  21     -21.097  44.905  -7.348  1.00  0.00           H  
ATOM    366  HG3 ARG A  21     -20.064  44.143  -8.557  1.00  0.00           H  
ATOM    367  HD2 ARG A  21     -22.511  43.072  -9.144  1.00  0.00           H  
ATOM    368  HD3 ARG A  21     -22.943  44.694  -8.611  1.00  0.00           H  
ATOM    369  HE  ARG A  21     -22.009  45.536 -10.520  1.00  0.00           H  
ATOM    370 HH11 ARG A  21     -20.905  42.237 -10.111  1.00  0.00           H  
ATOM    371 HH12 ARG A  21     -20.166  42.158 -11.674  1.00  0.00           H  
ATOM    372 HH21 ARG A  21     -21.030  45.427 -12.581  1.00  0.00           H  
ATOM    373 HH22 ARG A  21     -20.236  43.971 -13.077  1.00  0.00           H  
ATOM    374  N   LYS A  22     -22.210  40.815  -4.725  1.00  0.00           N  
ATOM    375  CA  LYS A  22     -23.086  39.680  -4.422  1.00  0.00           C  
ATOM    376  C   LYS A  22     -24.502  40.143  -4.061  1.00  0.00           C  
ATOM    377  O   LYS A  22     -25.427  39.973  -4.856  1.00  0.00           O  
ATOM    378  CB  LYS A  22     -22.490  38.845  -3.282  1.00  0.00           C  
ATOM    379  CG  LYS A  22     -22.775  37.355  -3.395  1.00  0.00           C  
ATOM    380  CD  LYS A  22     -24.034  36.967  -2.636  1.00  0.00           C  
ATOM    381  CE  LYS A  22     -24.842  35.920  -3.389  1.00  0.00           C  
ATOM    382  NZ  LYS A  22     -26.305  36.076  -3.159  1.00  0.00           N  
ATOM    383  H   LYS A  22     -21.319  40.847  -4.320  1.00  0.00           H  
ATOM    384  HA  LYS A  22     -23.142  39.068  -5.310  1.00  0.00           H  
ATOM    385  HB2 LYS A  22     -21.418  38.979  -3.274  1.00  0.00           H  
ATOM    386  HB3 LYS A  22     -22.892  39.196  -2.344  1.00  0.00           H  
ATOM    387  HG2 LYS A  22     -22.899  37.099  -4.436  1.00  0.00           H  
ATOM    388  HG3 LYS A  22     -21.939  36.809  -2.986  1.00  0.00           H  
ATOM    389  HD2 LYS A  22     -23.753  36.565  -1.676  1.00  0.00           H  
ATOM    390  HD3 LYS A  22     -24.644  37.847  -2.496  1.00  0.00           H  
ATOM    391  HE2 LYS A  22     -24.641  36.021  -4.448  1.00  0.00           H  
ATOM    392  HE3 LYS A  22     -24.534  34.941  -3.057  1.00  0.00           H  
ATOM    393  HZ1 LYS A  22     -26.824  35.303  -3.623  1.00  0.00           H  
ATOM    394  HZ2 LYS A  22     -26.636  36.982  -3.552  1.00  0.00           H  
ATOM    395  HZ3 LYS A  22     -26.512  36.058  -2.141  1.00  0.00           H  
ATOM    396  N   ASP A  23     -24.662  40.727  -2.863  1.00  0.00           N  
ATOM    397  CA  ASP A  23     -25.966  41.219  -2.397  1.00  0.00           C  
ATOM    398  C   ASP A  23     -25.942  41.561  -0.909  1.00  0.00           C  
ATOM    399  O   ASP A  23     -26.257  42.685  -0.513  1.00  0.00           O  
ATOM    400  CB  ASP A  23     -27.079  40.199  -2.670  1.00  0.00           C  
ATOM    401  CG  ASP A  23     -28.189  40.771  -3.529  1.00  0.00           C  
ATOM    402  OD1 ASP A  23     -28.964  41.604  -3.020  1.00  0.00           O  
ATOM    403  OD2 ASP A  23     -28.288  40.380  -4.710  1.00  0.00           O  
ATOM    404  H   ASP A  23     -23.880  40.836  -2.281  1.00  0.00           H  
ATOM    405  HA  ASP A  23     -26.177  42.112  -2.938  1.00  0.00           H  
ATOM    406  HB2 ASP A  23     -26.661  39.344  -3.178  1.00  0.00           H  
ATOM    407  HB3 ASP A  23     -27.505  39.881  -1.730  1.00  0.00           H  
ATOM    408  N   PRO A  24     -25.563  40.587  -0.068  1.00  0.00           N  
ATOM    409  CA  PRO A  24     -25.491  40.763   1.389  1.00  0.00           C  
ATOM    410  C   PRO A  24     -24.520  41.869   1.799  1.00  0.00           C  
ATOM    411  O   PRO A  24     -24.762  42.591   2.768  1.00  0.00           O  
ATOM    412  CB  PRO A  24     -24.989  39.405   1.891  1.00  0.00           C  
ATOM    413  CG  PRO A  24     -25.287  38.452   0.785  1.00  0.00           C  
ATOM    414  CD  PRO A  24     -25.169  39.239  -0.480  1.00  0.00           C  
ATOM    415  HA  PRO A  24     -26.465  40.968   1.810  1.00  0.00           H  
ATOM    416  HB2 PRO A  24     -23.929  39.462   2.087  1.00  0.00           H  
ATOM    417  HB3 PRO A  24     -25.513  39.137   2.793  1.00  0.00           H  
ATOM    418  HG2 PRO A  24     -24.574  37.646   0.790  1.00  0.00           H  
ATOM    419  HG3 PRO A  24     -26.291  38.073   0.889  1.00  0.00           H  
ATOM    420  HD3 PRO A  24     -24.154  39.233  -0.845  1.00  0.00           H  
ATOM    421  HD2 PRO A  24     -25.843  38.852  -1.228  1.00  0.00           H  
ATOM    422  N   SER A  25     -23.421  41.996   1.048  1.00  0.00           N  
ATOM    423  CA  SER A  25     -22.409  43.015   1.327  1.00  0.00           C  
ATOM    424  C   SER A  25     -22.967  44.428   1.141  1.00  0.00           C  
ATOM    425  O   SER A  25     -22.429  45.382   1.704  1.00  0.00           O  
ATOM    426  CB  SER A  25     -21.185  42.816   0.433  1.00  0.00           C  
ATOM    427  OG  SER A  25     -20.099  43.607   0.878  1.00  0.00           O  
ATOM    428  H   SER A  25     -23.290  41.392   0.289  1.00  0.00           H  
ATOM    429  HA  SER A  25     -22.108  42.898   2.358  1.00  0.00           H  
ATOM    430  HB2 SER A  25     -20.892  41.777   0.452  1.00  0.00           H  
ATOM    431  HB3 SER A  25     -21.432  43.100  -0.579  1.00  0.00           H  
ATOM    432  HG  SER A  25     -19.308  43.069   0.922  1.00  0.00           H  
ATOM    433  N   ALA A  26     -24.042  44.563   0.360  1.00  0.00           N  
ATOM    434  CA  ALA A  26     -24.661  45.867   0.124  1.00  0.00           C  
ATOM    435  C   ALA A  26     -25.004  46.562   1.442  1.00  0.00           C  
ATOM    436  O   ALA A  26     -24.949  47.788   1.540  1.00  0.00           O  
ATOM    437  CB  ALA A  26     -25.908  45.718  -0.731  1.00  0.00           C  
ATOM    438  H   ALA A  26     -24.432  43.767  -0.061  1.00  0.00           H  
ATOM    439  HA  ALA A  26     -23.953  46.478  -0.417  1.00  0.00           H  
ATOM    440  HB1 ALA A  26     -26.018  46.588  -1.362  1.00  0.00           H  
ATOM    441  HB2 ALA A  26     -26.775  45.627  -0.090  1.00  0.00           H  
ATOM    442  HB3 ALA A  26     -25.824  44.835  -1.347  1.00  0.00           H  
ATOM    443  N   PHE A  27     -25.356  45.766   2.456  1.00  0.00           N  
ATOM    444  CA  PHE A  27     -25.703  46.300   3.770  1.00  0.00           C  
ATOM    445  C   PHE A  27     -24.452  46.587   4.601  1.00  0.00           C  
ATOM    446  O   PHE A  27     -24.440  47.517   5.409  1.00  0.00           O  
ATOM    447  CB  PHE A  27     -26.612  45.323   4.517  1.00  0.00           C  
ATOM    448  CG  PHE A  27     -27.914  45.053   3.814  1.00  0.00           C  
ATOM    449  CD1 PHE A  27     -28.682  46.098   3.322  1.00  0.00           C  
ATOM    450  CD2 PHE A  27     -28.367  43.755   3.644  1.00  0.00           C  
ATOM    451  CE1 PHE A  27     -29.878  45.852   2.677  1.00  0.00           C  
ATOM    452  CE2 PHE A  27     -29.562  43.504   2.999  1.00  0.00           C  
ATOM    453  CZ  PHE A  27     -30.319  44.553   2.515  1.00  0.00           C  
ATOM    454  H   PHE A  27     -25.378  44.796   2.316  1.00  0.00           H  
ATOM    455  HA  PHE A  27     -26.236  47.226   3.617  1.00  0.00           H  
ATOM    456  HB2 PHE A  27     -26.096  44.382   4.636  1.00  0.00           H  
ATOM    457  HB3 PHE A  27     -26.837  45.729   5.491  1.00  0.00           H  
ATOM    458  HD1 PHE A  27     -28.336  47.113   3.448  1.00  0.00           H  
ATOM    459  HD2 PHE A  27     -27.777  42.935   4.023  1.00  0.00           H  
ATOM    460  HE1 PHE A  27     -30.466  46.674   2.298  1.00  0.00           H  
ATOM    461  HE2 PHE A  27     -29.904  42.488   2.872  1.00  0.00           H  
ATOM    462  HZ  PHE A  27     -31.253  44.358   2.010  1.00  0.00           H  
ATOM    463  N   PHE A  28     -23.401  45.789   4.399  1.00  0.00           N  
ATOM    464  CA  PHE A  28     -22.149  45.972   5.133  1.00  0.00           C  
ATOM    465  C   PHE A  28     -21.086  46.647   4.255  1.00  0.00           C  
ATOM    466  O   PHE A  28     -19.886  46.480   4.481  1.00  0.00           O  
ATOM    467  CB  PHE A  28     -21.626  44.624   5.640  1.00  0.00           C  
ATOM    468  CG  PHE A  28     -22.632  43.848   6.446  1.00  0.00           C  
ATOM    469  CD1 PHE A  28     -23.261  44.426   7.537  1.00  0.00           C  
ATOM    470  CD2 PHE A  28     -22.949  42.541   6.109  1.00  0.00           C  
ATOM    471  CE1 PHE A  28     -24.185  43.715   8.278  1.00  0.00           C  
ATOM    472  CE2 PHE A  28     -23.872  41.826   6.847  1.00  0.00           C  
ATOM    473  CZ  PHE A  28     -24.493  42.413   7.932  1.00  0.00           C  
ATOM    474  H   PHE A  28     -23.465  45.067   3.742  1.00  0.00           H  
ATOM    475  HA  PHE A  28     -22.353  46.611   5.982  1.00  0.00           H  
ATOM    476  HB2 PHE A  28     -21.339  44.017   4.794  1.00  0.00           H  
ATOM    477  HB3 PHE A  28     -20.761  44.794   6.262  1.00  0.00           H  
ATOM    478  HD1 PHE A  28     -23.023  45.444   7.809  1.00  0.00           H  
ATOM    479  HD2 PHE A  28     -22.465  42.080   5.260  1.00  0.00           H  
ATOM    480  HE1 PHE A  28     -24.668  44.177   9.126  1.00  0.00           H  
ATOM    481  HE2 PHE A  28     -24.111  40.809   6.573  1.00  0.00           H  
ATOM    482  HZ  PHE A  28     -25.214  41.856   8.510  1.00  0.00           H  
ATOM    483  N   SER A  29     -21.534  47.417   3.260  1.00  0.00           N  
ATOM    484  CA  SER A  29     -20.621  48.114   2.358  1.00  0.00           C  
ATOM    485  C   SER A  29     -20.257  49.508   2.891  1.00  0.00           C  
ATOM    486  O   SER A  29     -19.765  50.356   2.144  1.00  0.00           O  
ATOM    487  CB  SER A  29     -21.248  48.225   0.963  1.00  0.00           C  
ATOM    488  OG  SER A  29     -20.345  48.804   0.034  1.00  0.00           O  
ATOM    489  H   SER A  29     -22.497  47.520   3.132  1.00  0.00           H  
ATOM    490  HA  SER A  29     -19.717  47.525   2.287  1.00  0.00           H  
ATOM    491  HB2 SER A  29     -21.517  47.239   0.616  1.00  0.00           H  
ATOM    492  HB3 SER A  29     -22.134  48.841   1.018  1.00  0.00           H  
ATOM    493  HG  SER A  29     -19.934  48.113  -0.490  1.00  0.00           H  
ATOM    494  N   PHE A  30     -20.499  49.740   4.184  1.00  0.00           N  
ATOM    495  CA  PHE A  30     -20.195  51.018   4.813  1.00  0.00           C  
ATOM    496  C   PHE A  30     -19.848  50.809   6.288  1.00  0.00           C  
ATOM    497  O   PHE A  30     -20.369  49.891   6.925  1.00  0.00           O  
ATOM    498  CB  PHE A  30     -21.391  51.968   4.687  1.00  0.00           C  
ATOM    499  CG  PHE A  30     -21.135  53.159   3.803  1.00  0.00           C  
ATOM    500  CD1 PHE A  30     -21.151  53.029   2.423  1.00  0.00           C  
ATOM    501  CD2 PHE A  30     -20.883  54.406   4.350  1.00  0.00           C  
ATOM    502  CE1 PHE A  30     -20.923  54.121   1.606  1.00  0.00           C  
ATOM    503  CE2 PHE A  30     -20.651  55.501   3.540  1.00  0.00           C  
ATOM    504  CZ  PHE A  30     -20.672  55.358   2.167  1.00  0.00           C  
ATOM    505  H   PHE A  30     -20.888  49.030   4.732  1.00  0.00           H  
ATOM    506  HA  PHE A  30     -19.344  51.446   4.308  1.00  0.00           H  
ATOM    507  HB2 PHE A  30     -22.230  51.426   4.276  1.00  0.00           H  
ATOM    508  HB3 PHE A  30     -21.654  52.332   5.668  1.00  0.00           H  
ATOM    509  HD1 PHE A  30     -21.346  52.061   1.983  1.00  0.00           H  
ATOM    510  HD2 PHE A  30     -20.866  54.518   5.425  1.00  0.00           H  
ATOM    511  HE1 PHE A  30     -20.937  54.007   0.532  1.00  0.00           H  
ATOM    512  HE2 PHE A  30     -20.457  56.468   3.982  1.00  0.00           H  
ATOM    513  HZ  PHE A  30     -20.494  56.214   1.532  1.00  0.00           H  
ATOM    514  N   PRO A  31     -18.965  51.658   6.851  1.00  0.00           N  
ATOM    515  CA  PRO A  31     -18.555  51.561   8.258  1.00  0.00           C  
ATOM    516  C   PRO A  31     -19.753  51.610   9.205  1.00  0.00           C  
ATOM    517  O   PRO A  31     -20.434  52.633   9.303  1.00  0.00           O  
ATOM    518  CB  PRO A  31     -17.647  52.785   8.465  1.00  0.00           C  
ATOM    519  CG  PRO A  31     -17.919  53.682   7.304  1.00  0.00           C  
ATOM    520  CD  PRO A  31     -18.302  52.780   6.168  1.00  0.00           C  
ATOM    521  HA  PRO A  31     -17.990  50.658   8.441  1.00  0.00           H  
ATOM    522  HB2 PRO A  31     -17.894  53.267   9.399  1.00  0.00           H  
ATOM    523  HB3 PRO A  31     -16.612  52.470   8.482  1.00  0.00           H  
ATOM    524  HG2 PRO A  31     -18.732  54.353   7.541  1.00  0.00           H  
ATOM    525  HG3 PRO A  31     -17.030  54.242   7.054  1.00  0.00           H  
ATOM    526  HD3 PRO A  31     -18.982  53.285   5.498  1.00  0.00           H  
ATOM    527  HD2 PRO A  31     -17.424  52.445   5.639  1.00  0.00           H  
ATOM    528  N   VAL A  32     -20.010  50.493   9.893  1.00  0.00           N  
ATOM    529  CA  VAL A  32     -21.139  50.409  10.821  1.00  0.00           C  
ATOM    530  C   VAL A  32     -21.075  51.497  11.886  1.00  0.00           C  
ATOM    531  O   VAL A  32     -19.993  51.912  12.305  1.00  0.00           O  
ATOM    532  CB  VAL A  32     -21.239  49.038  11.518  1.00  0.00           C  
ATOM    533  CG1 VAL A  32     -21.960  48.039  10.628  1.00  0.00           C  
ATOM    534  CG2 VAL A  32     -19.865  48.533  11.911  1.00  0.00           C  
ATOM    535  H   VAL A  32     -19.437  49.710   9.762  1.00  0.00           H  
ATOM    536  HA  VAL A  32     -22.034  50.548  10.245  1.00  0.00           H  
ATOM    537  HB  VAL A  32     -21.820  49.160  12.420  1.00  0.00           H  
ATOM    538 HG11 VAL A  32     -21.536  48.071   9.633  1.00  0.00           H  
ATOM    539 HG12 VAL A  32     -23.008  48.295  10.580  1.00  0.00           H  
ATOM    540 HG13 VAL A  32     -21.848  47.046  11.035  1.00  0.00           H  
ATOM    541 HG21 VAL A  32     -19.140  49.311  11.731  1.00  0.00           H  
ATOM    542 HG22 VAL A  32     -19.619  47.666  11.317  1.00  0.00           H  
ATOM    543 HG23 VAL A  32     -19.863  48.271  12.955  1.00  0.00           H  
ATOM    544  N   THR A  33     -22.248  51.956  12.314  1.00  0.00           N  
ATOM    545  CA  THR A  33     -22.349  52.999  13.327  1.00  0.00           C  
ATOM    546  C   THR A  33     -23.504  52.709  14.281  1.00  0.00           C  
ATOM    547  O   THR A  33     -24.062  51.612  14.275  1.00  0.00           O  
ATOM    548  CB  THR A  33     -22.544  54.366  12.656  1.00  0.00           C  
ATOM    549  OG1 THR A  33     -23.666  54.349  11.786  1.00  0.00           O  
ATOM    550  CG2 THR A  33     -21.342  54.817  11.853  1.00  0.00           C  
ATOM    551  H   THR A  33     -23.071  51.580  11.936  1.00  0.00           H  
ATOM    552  HA  THR A  33     -21.427  53.009  13.886  1.00  0.00           H  
ATOM    553  HB  THR A  33     -22.723  55.108  13.420  1.00  0.00           H  
ATOM    554  HG1 THR A  33     -23.440  53.884  10.978  1.00  0.00           H  
ATOM    555 HG21 THR A  33     -21.454  54.503  10.827  1.00  0.00           H  
ATOM    556 HG22 THR A  33     -20.447  54.375  12.269  1.00  0.00           H  
ATOM    557 HG23 THR A  33     -21.264  55.893  11.893  1.00  0.00           H  
ATOM    558  N   ASP A  34     -23.868  53.707  15.090  1.00  0.00           N  
ATOM    559  CA  ASP A  34     -24.968  53.565  16.039  1.00  0.00           C  
ATOM    560  C   ASP A  34     -26.327  53.513  15.333  1.00  0.00           C  
ATOM    561  O   ASP A  34     -27.353  53.275  15.970  1.00  0.00           O  
ATOM    562  CB  ASP A  34     -24.956  54.727  17.036  1.00  0.00           C  
ATOM    563  CG  ASP A  34     -25.347  54.311  18.446  1.00  0.00           C  
ATOM    564  OD1 ASP A  34     -25.837  53.173  18.628  1.00  0.00           O  
ATOM    565  OD2 ASP A  34     -25.167  55.130  19.372  1.00  0.00           O  
ATOM    566  H   ASP A  34     -23.389  54.560  15.041  1.00  0.00           H  
ATOM    567  HA  ASP A  34     -24.819  52.640  16.577  1.00  0.00           H  
ATOM    568  HB2 ASP A  34     -23.964  55.152  17.069  1.00  0.00           H  
ATOM    569  HB3 ASP A  34     -25.651  55.484  16.701  1.00  0.00           H  
ATOM    570  N   PHE A  35     -26.331  53.741  14.017  1.00  0.00           N  
ATOM    571  CA  PHE A  35     -27.564  53.725  13.235  1.00  0.00           C  
ATOM    572  C   PHE A  35     -27.505  52.622  12.190  1.00  0.00           C  
ATOM    573  O   PHE A  35     -28.454  51.856  12.026  1.00  0.00           O  
ATOM    574  CB  PHE A  35     -27.785  55.081  12.557  1.00  0.00           C  
ATOM    575  CG  PHE A  35     -27.655  56.252  13.493  1.00  0.00           C  
ATOM    576  CD1 PHE A  35     -26.432  56.568  14.064  1.00  0.00           C  
ATOM    577  CD2 PHE A  35     -28.757  57.029  13.805  1.00  0.00           C  
ATOM    578  CE1 PHE A  35     -26.310  57.637  14.929  1.00  0.00           C  
ATOM    579  CE2 PHE A  35     -28.642  58.102  14.669  1.00  0.00           C  
ATOM    580  CZ  PHE A  35     -27.417  58.404  15.233  1.00  0.00           C  
ATOM    581  H   PHE A  35     -25.486  53.928  13.557  1.00  0.00           H  
ATOM    582  HA  PHE A  35     -28.384  53.527  13.909  1.00  0.00           H  
ATOM    583  HB2 PHE A  35     -27.059  55.202  11.769  1.00  0.00           H  
ATOM    584  HB3 PHE A  35     -28.778  55.100  12.132  1.00  0.00           H  
ATOM    585  HD1 PHE A  35     -25.565  55.965  13.826  1.00  0.00           H  
ATOM    586  HD2 PHE A  35     -29.715  56.793  13.367  1.00  0.00           H  
ATOM    587  HE1 PHE A  35     -25.352  57.871  15.368  1.00  0.00           H  
ATOM    588  HE2 PHE A  35     -29.509  58.700  14.905  1.00  0.00           H  
ATOM    589  HZ  PHE A  35     -27.326  59.242  15.910  1.00  0.00           H  
ATOM    590  N   ILE A  36     -26.368  52.536  11.502  1.00  0.00           N  
ATOM    591  CA  ILE A  36     -26.159  51.515  10.489  1.00  0.00           C  
ATOM    592  C   ILE A  36     -26.070  50.131  11.140  1.00  0.00           C  
ATOM    593  O   ILE A  36     -26.448  49.125  10.535  1.00  0.00           O  
ATOM    594  CB  ILE A  36     -24.872  51.802   9.680  1.00  0.00           C  
ATOM    595  CG1 ILE A  36     -25.133  52.891   8.637  1.00  0.00           C  
ATOM    596  CG2 ILE A  36     -24.355  50.539   9.015  1.00  0.00           C  
ATOM    597  CD1 ILE A  36     -23.874  53.547   8.117  1.00  0.00           C  
ATOM    598  H   ILE A  36     -25.643  53.166  11.695  1.00  0.00           H  
ATOM    599  HA  ILE A  36     -27.000  51.535   9.813  1.00  0.00           H  
ATOM    600  HB  ILE A  36     -24.117  52.150  10.365  1.00  0.00           H  
ATOM    601 HG12 ILE A  36     -25.653  52.457   7.796  1.00  0.00           H  
ATOM    602 HG13 ILE A  36     -25.752  53.661   9.077  1.00  0.00           H  
ATOM    603 HG21 ILE A  36     -23.945  49.884   9.768  1.00  0.00           H  
ATOM    604 HG22 ILE A  36     -23.587  50.797   8.302  1.00  0.00           H  
ATOM    605 HG23 ILE A  36     -25.168  50.042   8.508  1.00  0.00           H  
ATOM    606 HD11 ILE A  36     -23.440  54.159   8.893  1.00  0.00           H  
ATOM    607 HD12 ILE A  36     -24.114  54.162   7.263  1.00  0.00           H  
ATOM    608 HD13 ILE A  36     -23.167  52.785   7.822  1.00  0.00           H  
ATOM    609  N   ALA A  37     -25.577  50.093  12.380  1.00  0.00           N  
ATOM    610  CA  ALA A  37     -25.447  48.844  13.123  1.00  0.00           C  
ATOM    611  C   ALA A  37     -26.180  48.922  14.461  1.00  0.00           C  
ATOM    612  O   ALA A  37     -26.413  50.013  14.985  1.00  0.00           O  
ATOM    613  CB  ALA A  37     -23.979  48.514  13.344  1.00  0.00           C  
ATOM    614  H   ALA A  37     -25.301  50.932  12.812  1.00  0.00           H  
ATOM    615  HA  ALA A  37     -25.884  48.053  12.530  1.00  0.00           H  
ATOM    616  HB1 ALA A  37     -23.610  47.931  12.513  1.00  0.00           H  
ATOM    617  HB2 ALA A  37     -23.873  47.945  14.254  1.00  0.00           H  
ATOM    618  HB3 ALA A  37     -23.412  49.429  13.422  1.00  0.00           H  
ATOM    619  N   PRO A  38     -26.553  47.763  15.038  1.00  0.00           N  
ATOM    620  CA  PRO A  38     -27.262  47.711  16.327  1.00  0.00           C  
ATOM    621  C   PRO A  38     -26.384  48.026  17.533  1.00  0.00           C  
ATOM    622  O   PRO A  38     -26.844  48.012  18.677  1.00  0.00           O  
ATOM    623  CB  PRO A  38     -27.754  46.272  16.404  1.00  0.00           C  
ATOM    624  CG  PRO A  38     -26.797  45.489  15.569  1.00  0.00           C  
ATOM    625  CD  PRO A  38     -26.324  46.415  14.481  1.00  0.00           C  
ATOM    626  HA  PRO A  38     -28.083  48.380  16.327  1.00  0.00           H  
ATOM    627  HB2 PRO A  38     -27.731  45.948  17.431  1.00  0.00           H  
ATOM    628  HB3 PRO A  38     -28.757  46.209  16.019  1.00  0.00           H  
ATOM    629  HG2 PRO A  38     -25.961  45.166  16.173  1.00  0.00           H  
ATOM    630  HG3 PRO A  38     -27.300  44.635  15.140  1.00  0.00           H  
ATOM    631  HD3 PRO A  38     -25.275  46.255  14.281  1.00  0.00           H  
ATOM    632  HD2 PRO A  38     -26.904  46.269  13.583  1.00  0.00           H  
ATOM    633  N   GLY A  39     -25.134  48.306  17.259  1.00  0.00           N  
ATOM    634  CA  GLY A  39     -24.174  48.625  18.301  1.00  0.00           C  
ATOM    635  C   GLY A  39     -22.839  47.932  18.094  1.00  0.00           C  
ATOM    636  O   GLY A  39     -22.184  47.542  19.062  1.00  0.00           O  
ATOM    637  H   GLY A  39     -24.861  48.292  16.332  1.00  0.00           H  
ATOM    638  HA2 GLY A  39     -24.013  49.694  18.309  1.00  0.00           H  
ATOM    639  HA3 GLY A  39     -24.581  48.325  19.255  1.00  0.00           H  
ATOM    640  N   TYR A  40     -22.435  47.777  16.830  1.00  0.00           N  
ATOM    641  CA  TYR A  40     -21.168  47.127  16.498  1.00  0.00           C  
ATOM    642  C   TYR A  40     -20.006  47.798  17.226  1.00  0.00           C  
ATOM    643  O   TYR A  40     -19.185  47.127  17.833  1.00  0.00           O  
ATOM    644  CB  TYR A  40     -20.914  47.165  14.986  1.00  0.00           C  
ATOM    645  CG  TYR A  40     -21.549  46.018  14.225  1.00  0.00           C  
ATOM    646  CD1 TYR A  40     -22.871  45.656  14.452  1.00  0.00           C  
ATOM    647  CD2 TYR A  40     -20.826  45.299  13.276  1.00  0.00           C  
ATOM    648  CE1 TYR A  40     -23.457  44.614  13.760  1.00  0.00           C  
ATOM    649  CE2 TYR A  40     -21.407  44.257  12.578  1.00  0.00           C  
ATOM    650  CZ  TYR A  40     -22.723  43.919  12.824  1.00  0.00           C  
ATOM    651  OH  TYR A  40     -23.306  42.882  12.132  1.00  0.00           O  
ATOM    652  H   TYR A  40     -23.006  48.109  16.103  1.00  0.00           H  
ATOM    653  HA  TYR A  40     -21.228  46.095  16.819  1.00  0.00           H  
ATOM    654  HB2 TYR A  40     -21.311  48.087  14.586  1.00  0.00           H  
ATOM    655  HB3 TYR A  40     -19.849  47.132  14.808  1.00  0.00           H  
ATOM    656  HD1 TYR A  40     -23.448  46.202  15.184  1.00  0.00           H  
ATOM    657  HD2 TYR A  40     -19.796  45.560  13.083  1.00  0.00           H  
ATOM    658  HE1 TYR A  40     -24.484  44.349  13.952  1.00  0.00           H  
ATOM    659  HE2 TYR A  40     -20.832  43.715  11.846  1.00  0.00           H  
ATOM    660  HH  TYR A  40     -22.697  42.549  11.469  1.00  0.00           H  
ATOM    661  N   SER A  41     -19.949  49.124  17.163  1.00  0.00           N  
ATOM    662  CA  SER A  41     -18.883  49.883  17.824  1.00  0.00           C  
ATOM    663  C   SER A  41     -18.893  49.688  19.345  1.00  0.00           C  
ATOM    664  O   SER A  41     -17.861  49.850  19.999  1.00  0.00           O  
ATOM    665  CB  SER A  41     -19.004  51.373  17.492  1.00  0.00           C  
ATOM    666  OG  SER A  41     -18.511  51.648  16.191  1.00  0.00           O  
ATOM    667  H   SER A  41     -20.641  49.609  16.665  1.00  0.00           H  
ATOM    668  HA  SER A  41     -17.941  49.519  17.442  1.00  0.00           H  
ATOM    669  HB2 SER A  41     -20.041  51.668  17.539  1.00  0.00           H  
ATOM    670  HB3 SER A  41     -18.432  51.946  18.209  1.00  0.00           H  
ATOM    671  HG  SER A  41     -18.015  52.469  16.204  1.00  0.00           H  
ATOM    672  N   MET A  42     -20.058  49.358  19.907  1.00  0.00           N  
ATOM    673  CA  MET A  42     -20.187  49.166  21.350  1.00  0.00           C  
ATOM    674  C   MET A  42     -19.781  47.756  21.790  1.00  0.00           C  
ATOM    675  O   MET A  42     -19.176  47.587  22.850  1.00  0.00           O  
ATOM    676  CB  MET A  42     -21.627  49.449  21.791  1.00  0.00           C  
ATOM    677  CG  MET A  42     -21.978  50.927  21.845  1.00  0.00           C  
ATOM    678  SD  MET A  42     -23.732  51.232  21.560  1.00  0.00           S  
ATOM    679  CE  MET A  42     -23.700  52.922  20.966  1.00  0.00           C  
ATOM    680  H   MET A  42     -20.852  49.250  19.341  1.00  0.00           H  
ATOM    681  HA  MET A  42     -19.535  49.877  21.832  1.00  0.00           H  
ATOM    682  HB2 MET A  42     -22.302  48.968  21.098  1.00  0.00           H  
ATOM    683  HB3 MET A  42     -21.777  49.030  22.774  1.00  0.00           H  
ATOM    684  HG2 MET A  42     -21.712  51.311  22.819  1.00  0.00           H  
ATOM    685  HG3 MET A  42     -21.409  51.447  21.087  1.00  0.00           H  
ATOM    686  HE1 MET A  42     -22.934  53.472  21.487  1.00  0.00           H  
ATOM    687  HE2 MET A  42     -24.661  53.384  21.145  1.00  0.00           H  
ATOM    688  HE3 MET A  42     -23.493  52.926  19.906  1.00  0.00           H  
ATOM    689  N   ILE A  43     -20.137  46.745  20.994  1.00  0.00           N  
ATOM    690  CA  ILE A  43     -19.824  45.353  21.334  1.00  0.00           C  
ATOM    691  C   ILE A  43     -18.657  44.796  20.515  1.00  0.00           C  
ATOM    692  O   ILE A  43     -17.739  44.190  21.067  1.00  0.00           O  
ATOM    693  CB  ILE A  43     -21.064  44.449  21.155  1.00  0.00           C  
ATOM    694  CG1 ILE A  43     -20.814  43.067  21.767  1.00  0.00           C  
ATOM    695  CG2 ILE A  43     -21.448  44.329  19.687  1.00  0.00           C  
ATOM    696  CD1 ILE A  43     -21.953  42.574  22.629  1.00  0.00           C  
ATOM    697  H   ILE A  43     -20.638  46.936  20.172  1.00  0.00           H  
ATOM    698  HA  ILE A  43     -19.549  45.329  22.379  1.00  0.00           H  
ATOM    699  HB  ILE A  43     -21.888  44.917  21.669  1.00  0.00           H  
ATOM    700 HG12 ILE A  43     -20.666  42.350  20.973  1.00  0.00           H  
ATOM    701 HG13 ILE A  43     -19.925  43.107  22.379  1.00  0.00           H  
ATOM    702 HG21 ILE A  43     -20.771  43.651  19.191  1.00  0.00           H  
ATOM    703 HG22 ILE A  43     -21.393  45.300  19.219  1.00  0.00           H  
ATOM    704 HG23 ILE A  43     -22.454  43.952  19.614  1.00  0.00           H  
ATOM    705 HD11 ILE A  43     -22.662  42.037  22.016  1.00  0.00           H  
ATOM    706 HD12 ILE A  43     -22.445  43.416  23.092  1.00  0.00           H  
ATOM    707 HD13 ILE A  43     -21.570  41.915  23.394  1.00  0.00           H  
ATOM    708  N   ILE A  44     -18.698  45.006  19.203  1.00  0.00           N  
ATOM    709  CA  ILE A  44     -17.648  44.529  18.315  1.00  0.00           C  
ATOM    710  C   ILE A  44     -16.651  45.659  18.030  1.00  0.00           C  
ATOM    711  O   ILE A  44     -16.837  46.462  17.114  1.00  0.00           O  
ATOM    712  CB  ILE A  44     -18.251  43.969  16.999  1.00  0.00           C  
ATOM    713  CG1 ILE A  44     -18.827  42.567  17.242  1.00  0.00           C  
ATOM    714  CG2 ILE A  44     -17.216  43.936  15.880  1.00  0.00           C  
ATOM    715  CD1 ILE A  44     -17.799  41.548  17.690  1.00  0.00           C  
ATOM    716  H   ILE A  44     -19.451  45.502  18.821  1.00  0.00           H  
ATOM    717  HA  ILE A  44     -17.129  43.726  18.820  1.00  0.00           H  
ATOM    718  HB  ILE A  44     -19.056  44.618  16.689  1.00  0.00           H  
ATOM    719 HG12 ILE A  44     -19.583  42.627  18.010  1.00  0.00           H  
ATOM    720 HG13 ILE A  44     -19.277  42.208  16.329  1.00  0.00           H  
ATOM    721 HG21 ILE A  44     -16.889  44.941  15.664  1.00  0.00           H  
ATOM    722 HG22 ILE A  44     -17.654  43.507  14.994  1.00  0.00           H  
ATOM    723 HG23 ILE A  44     -16.370  43.343  16.190  1.00  0.00           H  
ATOM    724 HD11 ILE A  44     -18.039  40.586  17.265  1.00  0.00           H  
ATOM    725 HD12 ILE A  44     -17.807  41.478  18.766  1.00  0.00           H  
ATOM    726 HD13 ILE A  44     -16.819  41.854  17.356  1.00  0.00           H  
ATOM    727  N   LYS A  45     -15.604  45.719  18.848  1.00  0.00           N  
ATOM    728  CA  LYS A  45     -14.574  46.752  18.729  1.00  0.00           C  
ATOM    729  C   LYS A  45     -13.943  46.787  17.337  1.00  0.00           C  
ATOM    730  O   LYS A  45     -13.806  47.857  16.741  1.00  0.00           O  
ATOM    731  CB  LYS A  45     -13.485  46.532  19.782  1.00  0.00           C  
ATOM    732  CG  LYS A  45     -13.194  47.768  20.624  1.00  0.00           C  
ATOM    733  CD  LYS A  45     -12.093  47.513  21.644  1.00  0.00           C  
ATOM    734  CE  LYS A  45     -10.730  47.960  21.128  1.00  0.00           C  
ATOM    735  NZ  LYS A  45      -9.683  46.921  21.340  1.00  0.00           N  
ATOM    736  H   LYS A  45     -15.530  45.059  19.569  1.00  0.00           H  
ATOM    737  HA  LYS A  45     -15.046  47.706  18.914  1.00  0.00           H  
ATOM    738  HB2 LYS A  45     -13.797  45.738  20.441  1.00  0.00           H  
ATOM    739  HB3 LYS A  45     -12.574  46.238  19.283  1.00  0.00           H  
ATOM    740  HG2 LYS A  45     -12.888  48.572  19.970  1.00  0.00           H  
ATOM    741  HG3 LYS A  45     -14.096  48.053  21.147  1.00  0.00           H  
ATOM    742  HD2 LYS A  45     -12.320  48.061  22.547  1.00  0.00           H  
ATOM    743  HD3 LYS A  45     -12.056  46.455  21.864  1.00  0.00           H  
ATOM    744  HE2 LYS A  45     -10.809  48.169  20.073  1.00  0.00           H  
ATOM    745  HE3 LYS A  45     -10.443  48.862  21.651  1.00  0.00           H  
ATOM    746  HZ1 LYS A  45      -9.388  46.906  22.339  1.00  0.00           H  
ATOM    747  HZ2 LYS A  45      -8.852  47.128  20.751  1.00  0.00           H  
ATOM    748  HZ3 LYS A  45     -10.050  45.982  21.084  1.00  0.00           H  
ATOM    749  N   HIS A  46     -13.546  45.620  16.827  1.00  0.00           N  
ATOM    750  CA  HIS A  46     -12.913  45.538  15.514  1.00  0.00           C  
ATOM    751  C   HIS A  46     -13.783  44.769  14.516  1.00  0.00           C  
ATOM    752  O   HIS A  46     -13.499  43.614  14.191  1.00  0.00           O  
ATOM    753  CB  HIS A  46     -11.536  44.875  15.636  1.00  0.00           C  
ATOM    754  CG  HIS A  46     -10.399  45.753  15.209  1.00  0.00           C  
ATOM    755  ND1 HIS A  46     -10.494  46.674  14.185  1.00  0.00           N  
ATOM    756  CD2 HIS A  46      -9.130  45.844  15.674  1.00  0.00           C  
ATOM    757  CE1 HIS A  46      -9.335  47.289  14.039  1.00  0.00           C  
ATOM    758  NE2 HIS A  46      -8.492  46.805  14.930  1.00  0.00           N  
ATOM    759  H   HIS A  46     -13.670  44.801  17.352  1.00  0.00           H  
ATOM    760  HA  HIS A  46     -12.783  46.546  15.149  1.00  0.00           H  
ATOM    761  HB2 HIS A  46     -11.370  44.598  16.666  1.00  0.00           H  
ATOM    762  HB3 HIS A  46     -11.517  43.985  15.024  1.00  0.00           H  
ATOM    763  HD1 HIS A  46     -11.294  46.848  13.644  1.00  0.00           H  
ATOM    764  HD2 HIS A  46      -8.698  45.266  16.480  1.00  0.00           H  
ATOM    765  HE1 HIS A  46      -9.115  48.060  13.314  1.00  0.00           H  
ATOM    766  HE2 HIS A  46      -7.587  47.146  15.094  1.00  0.00           H  
ATOM    767  N   PRO A  47     -14.853  45.407  13.997  1.00  0.00           N  
ATOM    768  CA  PRO A  47     -15.749  44.781  13.024  1.00  0.00           C  
ATOM    769  C   PRO A  47     -15.131  44.717  11.630  1.00  0.00           C  
ATOM    770  O   PRO A  47     -15.269  43.717  10.930  1.00  0.00           O  
ATOM    771  CB  PRO A  47     -16.973  45.700  13.029  1.00  0.00           C  
ATOM    772  CG  PRO A  47     -16.452  47.038  13.427  1.00  0.00           C  
ATOM    773  CD  PRO A  47     -15.259  46.791  14.317  1.00  0.00           C  
ATOM    774  HA  PRO A  47     -16.038  43.788  13.333  1.00  0.00           H  
ATOM    775  HB2 PRO A  47     -17.410  45.723  12.041  1.00  0.00           H  
ATOM    776  HB3 PRO A  47     -17.699  45.334  13.740  1.00  0.00           H  
ATOM    777  HG2 PRO A  47     -16.155  47.592  12.549  1.00  0.00           H  
ATOM    778  HG3 PRO A  47     -17.215  47.579  13.969  1.00  0.00           H  
ATOM    779  HD3 PRO A  47     -14.467  47.487  14.086  1.00  0.00           H  
ATOM    780  HD2 PRO A  47     -15.544  46.877  15.353  1.00  0.00           H  
ATOM    781  N   MET A  48     -14.445  45.795  11.243  1.00  0.00           N  
ATOM    782  CA  MET A  48     -13.794  45.887   9.937  1.00  0.00           C  
ATOM    783  C   MET A  48     -14.770  45.577   8.804  1.00  0.00           C  
ATOM    784  O   MET A  48     -14.733  44.497   8.210  1.00  0.00           O  
ATOM    785  CB  MET A  48     -12.587  44.948   9.874  1.00  0.00           C  
ATOM    786  CG  MET A  48     -11.269  45.641  10.168  1.00  0.00           C  
ATOM    787  SD  MET A  48     -10.575  46.439   8.708  1.00  0.00           S  
ATOM    788  CE  MET A  48      -9.645  47.772   9.458  1.00  0.00           C  
ATOM    789  H   MET A  48     -14.370  46.549  11.860  1.00  0.00           H  
ATOM    790  HA  MET A  48     -13.449  46.905   9.819  1.00  0.00           H  
ATOM    791  HB2 MET A  48     -12.722  44.154  10.595  1.00  0.00           H  
ATOM    792  HB3 MET A  48     -12.532  44.518   8.884  1.00  0.00           H  
ATOM    793  HG2 MET A  48     -11.434  46.391  10.926  1.00  0.00           H  
ATOM    794  HG3 MET A  48     -10.565  44.910  10.532  1.00  0.00           H  
ATOM    795  HE1 MET A  48      -8.591  47.550   9.397  1.00  0.00           H  
ATOM    796  HE2 MET A  48      -9.932  47.873  10.494  1.00  0.00           H  
ATOM    797  HE3 MET A  48      -9.851  48.693   8.933  1.00  0.00           H  
ATOM    798  N   ASP A  49     -15.644  46.539   8.510  1.00  0.00           N  
ATOM    799  CA  ASP A  49     -16.637  46.384   7.448  1.00  0.00           C  
ATOM    800  C   ASP A  49     -15.970  46.274   6.083  1.00  0.00           C  
ATOM    801  O   ASP A  49     -14.766  46.509   5.944  1.00  0.00           O  
ATOM    802  CB  ASP A  49     -17.607  47.568   7.446  1.00  0.00           C  
ATOM    803  CG  ASP A  49     -18.363  47.699   8.750  1.00  0.00           C  
ATOM    804  OD1 ASP A  49     -17.852  48.383   9.663  1.00  0.00           O  
ATOM    805  OD2 ASP A  49     -19.464  47.121   8.862  1.00  0.00           O  
ATOM    806  H   ASP A  49     -15.619  47.374   9.021  1.00  0.00           H  
ATOM    807  HA  ASP A  49     -17.189  45.476   7.640  1.00  0.00           H  
ATOM    808  HB2 ASP A  49     -17.054  48.477   7.280  1.00  0.00           H  
ATOM    809  HB3 ASP A  49     -18.324  47.433   6.648  1.00  0.00           H  
ATOM    810  N   PHE A  50     -16.762  45.929   5.072  1.00  0.00           N  
ATOM    811  CA  PHE A  50     -16.256  45.799   3.708  1.00  0.00           C  
ATOM    812  C   PHE A  50     -15.731  47.140   3.190  1.00  0.00           C  
ATOM    813  O   PHE A  50     -14.799  47.176   2.386  1.00  0.00           O  
ATOM    814  CB  PHE A  50     -17.343  45.259   2.779  1.00  0.00           C  
ATOM    815  CG  PHE A  50     -17.773  43.861   3.123  1.00  0.00           C  
ATOM    816  CD1 PHE A  50     -18.720  43.634   4.110  1.00  0.00           C  
ATOM    817  CD2 PHE A  50     -17.227  42.773   2.465  1.00  0.00           C  
ATOM    818  CE1 PHE A  50     -19.114  42.352   4.431  1.00  0.00           C  
ATOM    819  CE2 PHE A  50     -17.617  41.488   2.782  1.00  0.00           C  
ATOM    820  CZ  PHE A  50     -18.562  41.276   3.767  1.00  0.00           C  
ATOM    821  H   PHE A  50     -17.715  45.768   5.246  1.00  0.00           H  
ATOM    822  HA  PHE A  50     -15.437  45.095   3.731  1.00  0.00           H  
ATOM    823  HB2 PHE A  50     -18.211  45.900   2.837  1.00  0.00           H  
ATOM    824  HB3 PHE A  50     -16.971  45.254   1.766  1.00  0.00           H  
ATOM    825  HD1 PHE A  50     -19.154  44.473   4.631  1.00  0.00           H  
ATOM    826  HD2 PHE A  50     -16.485  42.937   1.697  1.00  0.00           H  
ATOM    827  HE1 PHE A  50     -19.854  42.190   5.202  1.00  0.00           H  
ATOM    828  HE2 PHE A  50     -17.185  40.649   2.259  1.00  0.00           H  
ATOM    829  HZ  PHE A  50     -18.868  40.272   4.017  1.00  0.00           H  
ATOM    830  N   SER A  51     -16.328  48.239   3.663  1.00  0.00           N  
ATOM    831  CA  SER A  51     -15.911  49.581   3.253  1.00  0.00           C  
ATOM    832  C   SER A  51     -14.568  49.955   3.879  1.00  0.00           C  
ATOM    833  O   SER A  51     -13.711  50.548   3.220  1.00  0.00           O  
ATOM    834  CB  SER A  51     -16.972  50.613   3.649  1.00  0.00           C  
ATOM    835  OG  SER A  51     -16.484  51.938   3.507  1.00  0.00           O  
ATOM    836  H   SER A  51     -17.062  48.145   4.306  1.00  0.00           H  
ATOM    837  HA  SER A  51     -15.806  49.580   2.180  1.00  0.00           H  
ATOM    838  HB2 SER A  51     -17.835  50.493   3.013  1.00  0.00           H  
ATOM    839  HB3 SER A  51     -17.260  50.455   4.677  1.00  0.00           H  
ATOM    840  HG  SER A  51     -15.971  52.177   4.283  1.00  0.00           H  
ATOM    841  N   THR A  52     -14.389  49.611   5.154  1.00  0.00           N  
ATOM    842  CA  THR A  52     -13.148  49.916   5.859  1.00  0.00           C  
ATOM    843  C   THR A  52     -11.990  49.087   5.307  1.00  0.00           C  
ATOM    844  O   THR A  52     -10.899  49.611   5.070  1.00  0.00           O  
ATOM    845  CB  THR A  52     -13.304  49.668   7.365  1.00  0.00           C  
ATOM    846  OG1 THR A  52     -14.646  49.869   7.779  1.00  0.00           O  
ATOM    847  CG2 THR A  52     -12.425  50.566   8.210  1.00  0.00           C  
ATOM    848  H   THR A  52     -15.107  49.141   5.634  1.00  0.00           H  
ATOM    849  HA  THR A  52     -12.930  50.964   5.700  1.00  0.00           H  
ATOM    850  HB  THR A  52     -13.033  48.643   7.578  1.00  0.00           H  
ATOM    851  HG1 THR A  52     -14.799  49.415   8.612  1.00  0.00           H  
ATOM    852 HG21 THR A  52     -12.630  50.391   9.256  1.00  0.00           H  
ATOM    853 HG22 THR A  52     -12.629  51.599   7.969  1.00  0.00           H  
ATOM    854 HG23 THR A  52     -11.387  50.346   8.006  1.00  0.00           H  
ATOM    855  N   MET A  53     -12.232  47.789   5.105  1.00  0.00           N  
ATOM    856  CA  MET A  53     -11.203  46.895   4.582  1.00  0.00           C  
ATOM    857  C   MET A  53     -10.777  47.297   3.166  1.00  0.00           C  
ATOM    858  O   MET A  53      -9.585  47.361   2.875  1.00  0.00           O  
ATOM    859  CB  MET A  53     -11.677  45.433   4.609  1.00  0.00           C  
ATOM    860  CG  MET A  53     -12.779  45.111   3.611  1.00  0.00           C  
ATOM    861  SD  MET A  53     -13.358  43.408   3.745  1.00  0.00           S  
ATOM    862  CE  MET A  53     -11.879  42.510   3.281  1.00  0.00           C  
ATOM    863  H   MET A  53     -13.120  47.428   5.316  1.00  0.00           H  
ATOM    864  HA  MET A  53     -10.343  46.987   5.228  1.00  0.00           H  
ATOM    865  HB2 MET A  53     -10.835  44.794   4.395  1.00  0.00           H  
ATOM    866  HB3 MET A  53     -12.043  45.207   5.600  1.00  0.00           H  
ATOM    867  HG2 MET A  53     -13.612  45.772   3.789  1.00  0.00           H  
ATOM    868  HG3 MET A  53     -12.399  45.269   2.611  1.00  0.00           H  
ATOM    869  HE1 MET A  53     -12.120  41.466   3.140  1.00  0.00           H  
ATOM    870  HE2 MET A  53     -11.138  42.607   4.061  1.00  0.00           H  
ATOM    871  HE3 MET A  53     -11.485  42.916   2.359  1.00  0.00           H  
ATOM    872  N   LYS A  54     -11.752  47.572   2.289  1.00  0.00           N  
ATOM    873  CA  LYS A  54     -11.453  47.967   0.906  1.00  0.00           C  
ATOM    874  C   LYS A  54     -10.597  49.235   0.859  1.00  0.00           C  
ATOM    875  O   LYS A  54      -9.672  49.342   0.046  1.00  0.00           O  
ATOM    876  CB  LYS A  54     -12.744  48.171   0.103  1.00  0.00           C  
ATOM    877  CG  LYS A  54     -13.610  49.322   0.598  1.00  0.00           C  
ATOM    878  CD  LYS A  54     -14.733  49.634  -0.375  1.00  0.00           C  
ATOM    879  CE  LYS A  54     -14.472  50.925  -1.133  1.00  0.00           C  
ATOM    880  NZ  LYS A  54     -14.645  50.752  -2.602  1.00  0.00           N  
ATOM    881  H   LYS A  54     -12.688  47.509   2.576  1.00  0.00           H  
ATOM    882  HA  LYS A  54     -10.892  47.163   0.455  1.00  0.00           H  
ATOM    883  HB2 LYS A  54     -12.483  48.367  -0.927  1.00  0.00           H  
ATOM    884  HB3 LYS A  54     -13.329  47.265   0.150  1.00  0.00           H  
ATOM    885  HG2 LYS A  54     -14.036  49.053   1.550  1.00  0.00           H  
ATOM    886  HG3 LYS A  54     -12.992  50.201   0.715  1.00  0.00           H  
ATOM    887  HD2 LYS A  54     -14.821  48.823  -1.082  1.00  0.00           H  
ATOM    888  HD3 LYS A  54     -15.656  49.732   0.178  1.00  0.00           H  
ATOM    889  HE2 LYS A  54     -15.162  51.679  -0.785  1.00  0.00           H  
ATOM    890  HE3 LYS A  54     -13.459  51.247  -0.933  1.00  0.00           H  
ATOM    891  HZ1 LYS A  54     -14.248  51.569  -3.107  1.00  0.00           H  
ATOM    892  HZ2 LYS A  54     -15.655  50.671  -2.835  1.00  0.00           H  
ATOM    893  HZ3 LYS A  54     -14.158  49.889  -2.920  1.00  0.00           H  
ATOM    894  N   GLU A  55     -10.898  50.186   1.745  1.00  0.00           N  
ATOM    895  CA  GLU A  55     -10.144  51.434   1.808  1.00  0.00           C  
ATOM    896  C   GLU A  55      -8.691  51.147   2.166  1.00  0.00           C  
ATOM    897  O   GLU A  55      -7.772  51.772   1.633  1.00  0.00           O  
ATOM    898  CB  GLU A  55     -10.761  52.384   2.837  1.00  0.00           C  
ATOM    899  CG  GLU A  55     -10.810  53.831   2.379  1.00  0.00           C  
ATOM    900  CD  GLU A  55     -10.953  54.804   3.533  1.00  0.00           C  
ATOM    901  OE1 GLU A  55      -9.944  55.056   4.226  1.00  0.00           O  
ATOM    902  OE2 GLU A  55     -12.073  55.312   3.745  1.00  0.00           O  
ATOM    903  H   GLU A  55     -11.635  50.041   2.377  1.00  0.00           H  
ATOM    904  HA  GLU A  55     -10.179  51.896   0.831  1.00  0.00           H  
ATOM    905  HB2 GLU A  55     -11.770  52.062   3.048  1.00  0.00           H  
ATOM    906  HB3 GLU A  55     -10.180  52.336   3.748  1.00  0.00           H  
ATOM    907  HG2 GLU A  55      -9.899  54.060   1.846  1.00  0.00           H  
ATOM    908  HG3 GLU A  55     -11.654  53.957   1.716  1.00  0.00           H  
ATOM    909  N   LYS A  56      -8.492  50.178   3.060  1.00  0.00           N  
ATOM    910  CA  LYS A  56      -7.153  49.781   3.477  1.00  0.00           C  
ATOM    911  C   LYS A  56      -6.403  49.114   2.322  1.00  0.00           C  
ATOM    912  O   LYS A  56      -5.196  49.299   2.174  1.00  0.00           O  
ATOM    913  CB  LYS A  56      -7.227  48.832   4.676  1.00  0.00           C  
ATOM    914  CG  LYS A  56      -6.547  49.369   5.924  1.00  0.00           C  
ATOM    915  CD  LYS A  56      -7.555  49.937   6.909  1.00  0.00           C  
ATOM    916  CE  LYS A  56      -7.023  49.904   8.333  1.00  0.00           C  
ATOM    917  NZ  LYS A  56      -7.637  50.963   9.183  1.00  0.00           N  
ATOM    918  H   LYS A  56      -9.267  49.707   3.437  1.00  0.00           H  
ATOM    919  HA  LYS A  56      -6.620  50.673   3.767  1.00  0.00           H  
ATOM    920  HB2 LYS A  56      -8.265  48.647   4.910  1.00  0.00           H  
ATOM    921  HB3 LYS A  56      -6.756  47.900   4.410  1.00  0.00           H  
ATOM    922  HG2 LYS A  56      -6.011  48.563   6.403  1.00  0.00           H  
ATOM    923  HG3 LYS A  56      -5.854  50.147   5.641  1.00  0.00           H  
ATOM    924  HD2 LYS A  56      -7.768  50.961   6.639  1.00  0.00           H  
ATOM    925  HD3 LYS A  56      -8.463  49.352   6.858  1.00  0.00           H  
ATOM    926  HE2 LYS A  56      -7.242  48.938   8.762  1.00  0.00           H  
ATOM    927  HE3 LYS A  56      -5.952  50.049   8.306  1.00  0.00           H  
ATOM    928  HZ1 LYS A  56      -8.450  50.577   9.703  1.00  0.00           H  
ATOM    929  HZ2 LYS A  56      -7.962  51.756   8.593  1.00  0.00           H  
ATOM    930  HZ3 LYS A  56      -6.938  51.320   9.867  1.00  0.00           H  
ATOM    931  N   ILE A  57      -7.126  48.351   1.492  1.00  0.00           N  
ATOM    932  CA  ILE A  57      -6.509  47.677   0.347  1.00  0.00           C  
ATOM    933  C   ILE A  57      -5.875  48.699  -0.593  1.00  0.00           C  
ATOM    934  O   ILE A  57      -4.769  48.493  -1.089  1.00  0.00           O  
ATOM    935  CB  ILE A  57      -7.513  46.822  -0.463  1.00  0.00           C  
ATOM    936  CG1 ILE A  57      -8.453  46.043   0.461  1.00  0.00           C  
ATOM    937  CG2 ILE A  57      -6.762  45.870  -1.383  1.00  0.00           C  
ATOM    938  CD1 ILE A  57      -9.337  45.049  -0.262  1.00  0.00           C  
ATOM    939  H   ILE A  57      -8.087  48.247   1.650  1.00  0.00           H  
ATOM    940  HA  ILE A  57      -5.734  47.027   0.724  1.00  0.00           H  
ATOM    941  HB  ILE A  57      -8.098  47.488  -1.081  1.00  0.00           H  
ATOM    942 HG12 ILE A  57      -7.868  45.500   1.185  1.00  0.00           H  
ATOM    943 HG13 ILE A  57      -9.094  46.741   0.974  1.00  0.00           H  
ATOM    944 HG21 ILE A  57      -6.115  45.237  -0.794  1.00  0.00           H  
ATOM    945 HG22 ILE A  57      -6.170  46.438  -2.086  1.00  0.00           H  
ATOM    946 HG23 ILE A  57      -7.471  45.258  -1.923  1.00  0.00           H  
ATOM    947 HD11 ILE A  57      -9.550  45.411  -1.257  1.00  0.00           H  
ATOM    948 HD12 ILE A  57     -10.263  44.928   0.282  1.00  0.00           H  
ATOM    949 HD13 ILE A  57      -8.832  44.098  -0.325  1.00  0.00           H  
ATOM    950  N   LYS A  58      -6.583  49.807  -0.824  1.00  0.00           N  
ATOM    951  CA  LYS A  58      -6.085  50.868  -1.701  1.00  0.00           C  
ATOM    952  C   LYS A  58      -4.761  51.454  -1.185  1.00  0.00           C  
ATOM    953  O   LYS A  58      -4.007  52.056  -1.953  1.00  0.00           O  
ATOM    954  CB  LYS A  58      -7.125  51.982  -1.834  1.00  0.00           C  
ATOM    955  CG  LYS A  58      -8.399  51.548  -2.541  1.00  0.00           C  
ATOM    956  CD  LYS A  58      -8.825  52.557  -3.597  1.00  0.00           C  
ATOM    957  CE  LYS A  58     -10.338  52.626  -3.730  1.00  0.00           C  
ATOM    958  NZ  LYS A  58     -10.926  51.313  -4.118  1.00  0.00           N  
ATOM    959  H   LYS A  58      -7.461  49.915  -0.393  1.00  0.00           H  
ATOM    960  HA  LYS A  58      -5.914  50.436  -2.676  1.00  0.00           H  
ATOM    961  HB2 LYS A  58      -7.390  52.331  -0.846  1.00  0.00           H  
ATOM    962  HB3 LYS A  58      -6.690  52.800  -2.391  1.00  0.00           H  
ATOM    963  HG2 LYS A  58      -8.228  50.594  -3.020  1.00  0.00           H  
ATOM    964  HG3 LYS A  58      -9.189  51.448  -1.810  1.00  0.00           H  
ATOM    965  HD2 LYS A  58      -8.454  53.533  -3.319  1.00  0.00           H  
ATOM    966  HD3 LYS A  58      -8.400  52.269  -4.548  1.00  0.00           H  
ATOM    967  HE2 LYS A  58     -10.756  52.933  -2.783  1.00  0.00           H  
ATOM    968  HE3 LYS A  58     -10.586  53.358  -4.485  1.00  0.00           H  
ATOM    969  HZ1 LYS A  58     -11.190  50.774  -3.268  1.00  0.00           H  
ATOM    970  HZ2 LYS A  58     -10.238  50.756  -4.665  1.00  0.00           H  
ATOM    971  HZ3 LYS A  58     -11.775  51.458  -4.699  1.00  0.00           H  
ATOM    972  N   ASN A  59      -4.484  51.278   0.110  1.00  0.00           N  
ATOM    973  CA  ASN A  59      -3.253  51.786   0.715  1.00  0.00           C  
ATOM    974  C   ASN A  59      -2.230  50.666   0.941  1.00  0.00           C  
ATOM    975  O   ASN A  59      -1.341  50.792   1.782  1.00  0.00           O  
ATOM    976  CB  ASN A  59      -3.573  52.468   2.048  1.00  0.00           C  
ATOM    977  CG  ASN A  59      -3.908  53.938   1.886  1.00  0.00           C  
ATOM    978  OD1 ASN A  59      -3.162  54.808   2.333  1.00  0.00           O  
ATOM    979  ND2 ASN A  59      -5.038  54.227   1.243  1.00  0.00           N  
ATOM    980  H   ASN A  59      -5.119  50.793   0.676  1.00  0.00           H  
ATOM    981  HA  ASN A  59      -2.828  52.514   0.042  1.00  0.00           H  
ATOM    982  HB2 ASN A  59      -4.419  51.971   2.501  1.00  0.00           H  
ATOM    983  HB3 ASN A  59      -2.719  52.381   2.701  1.00  0.00           H  
ATOM    984 HD21 ASN A  59      -5.587  53.486   0.914  1.00  0.00           H  
ATOM    985 HD22 ASN A  59      -5.271  55.172   1.123  1.00  0.00           H  
ATOM    986  N   ASN A  60      -2.368  49.566   0.191  1.00  0.00           N  
ATOM    987  CA  ASN A  60      -1.466  48.417   0.310  1.00  0.00           C  
ATOM    988  C   ASN A  60      -1.531  47.785   1.701  1.00  0.00           C  
ATOM    989  O   ASN A  60      -0.644  47.020   2.083  1.00  0.00           O  
ATOM    990  CB  ASN A  60      -0.030  48.819  -0.027  1.00  0.00           C  
ATOM    991  CG  ASN A  60       0.491  48.098  -1.255  1.00  0.00           C  
ATOM    992  OD1 ASN A  60       1.276  47.156  -1.149  1.00  0.00           O  
ATOM    993  ND2 ASN A  60       0.051  48.535  -2.428  1.00  0.00           N  
ATOM    994  H   ASN A  60      -3.098  49.521  -0.459  1.00  0.00           H  
ATOM    995  HA  ASN A  60      -1.796  47.673  -0.398  1.00  0.00           H  
ATOM    996  HB2 ASN A  60       0.007  49.881  -0.214  1.00  0.00           H  
ATOM    997  HB3 ASN A  60       0.609  48.581   0.808  1.00  0.00           H  
ATOM    998 HD21 ASN A  60      -0.574  49.290  -2.438  1.00  0.00           H  
ATOM    999 HD22 ASN A  60       0.368  48.084  -3.239  1.00  0.00           H  
ATOM   1000  N   ASP A  61      -2.600  48.072   2.438  1.00  0.00           N  
ATOM   1001  CA  ASP A  61      -2.788  47.489   3.759  1.00  0.00           C  
ATOM   1002  C   ASP A  61      -3.158  46.015   3.613  1.00  0.00           C  
ATOM   1003  O   ASP A  61      -2.823  45.189   4.463  1.00  0.00           O  
ATOM   1004  CB  ASP A  61      -3.876  48.235   4.531  1.00  0.00           C  
ATOM   1005  CG  ASP A  61      -3.537  48.393   6.000  1.00  0.00           C  
ATOM   1006  OD1 ASP A  61      -3.893  47.496   6.792  1.00  0.00           O  
ATOM   1007  OD2 ASP A  61      -2.922  49.419   6.360  1.00  0.00           O  
ATOM   1008  H   ASP A  61      -3.295  48.662   2.072  1.00  0.00           H  
ATOM   1009  HA  ASP A  61      -1.853  47.565   4.293  1.00  0.00           H  
ATOM   1010  HB2 ASP A  61      -4.002  49.219   4.105  1.00  0.00           H  
ATOM   1011  HB3 ASP A  61      -4.807  47.692   4.449  1.00  0.00           H  
ATOM   1012  N   TYR A  62      -3.835  45.698   2.505  1.00  0.00           N  
ATOM   1013  CA  TYR A  62      -4.241  44.335   2.206  1.00  0.00           C  
ATOM   1014  C   TYR A  62      -3.527  43.838   0.954  1.00  0.00           C  
ATOM   1015  O   TYR A  62      -3.861  44.237  -0.162  1.00  0.00           O  
ATOM   1016  CB  TYR A  62      -5.753  44.254   2.001  1.00  0.00           C  
ATOM   1017  CG  TYR A  62      -6.555  44.423   3.272  1.00  0.00           C  
ATOM   1018  CD1 TYR A  62      -6.667  43.387   4.191  1.00  0.00           C  
ATOM   1019  CD2 TYR A  62      -7.205  45.616   3.547  1.00  0.00           C  
ATOM   1020  CE1 TYR A  62      -7.407  43.539   5.348  1.00  0.00           C  
ATOM   1021  CE2 TYR A  62      -7.944  45.775   4.701  1.00  0.00           C  
ATOM   1022  CZ  TYR A  62      -8.043  44.736   5.596  1.00  0.00           C  
ATOM   1023  OH  TYR A  62      -8.785  44.899   6.742  1.00  0.00           O  
ATOM   1024  H   TYR A  62      -4.057  46.404   1.864  1.00  0.00           H  
ATOM   1025  HA  TYR A  62      -3.963  43.710   3.043  1.00  0.00           H  
ATOM   1026  HB2 TYR A  62      -6.055  45.031   1.316  1.00  0.00           H  
ATOM   1027  HB3 TYR A  62      -6.000  43.292   1.578  1.00  0.00           H  
ATOM   1028  HD1 TYR A  62      -6.164  42.451   3.994  1.00  0.00           H  
ATOM   1029  HD2 TYR A  62      -7.126  46.429   2.843  1.00  0.00           H  
ATOM   1030  HE1 TYR A  62      -7.481  42.722   6.050  1.00  0.00           H  
ATOM   1031  HE2 TYR A  62      -8.443  46.710   4.896  1.00  0.00           H  
ATOM   1032  HH  TYR A  62      -8.238  45.291   7.426  1.00  0.00           H  
ATOM   1033  N   GLN A  63      -2.550  42.961   1.151  1.00  0.00           N  
ATOM   1034  CA  GLN A  63      -1.788  42.384   0.046  1.00  0.00           C  
ATOM   1035  C   GLN A  63      -1.358  40.960   0.394  1.00  0.00           C  
ATOM   1036  O   GLN A  63      -0.388  40.434  -0.161  1.00  0.00           O  
ATOM   1037  CB  GLN A  63      -0.562  43.247  -0.271  1.00  0.00           C  
ATOM   1038  CG  GLN A  63      -0.129  43.172  -1.725  1.00  0.00           C  
ATOM   1039  CD  GLN A  63       1.374  43.253  -1.893  1.00  0.00           C  
ATOM   1040  OE1 GLN A  63       1.950  44.338  -1.908  1.00  0.00           O  
ATOM   1041  NE2 GLN A  63       2.023  42.100  -2.021  1.00  0.00           N  
ATOM   1042  H   GLN A  63      -2.339  42.684   2.065  1.00  0.00           H  
ATOM   1043  HA  GLN A  63      -2.432  42.352  -0.820  1.00  0.00           H  
ATOM   1044  HB2 GLN A  63      -0.789  44.276  -0.037  1.00  0.00           H  
ATOM   1045  HB3 GLN A  63       0.263  42.920   0.346  1.00  0.00           H  
ATOM   1046  HG2 GLN A  63      -0.472  42.235  -2.141  1.00  0.00           H  
ATOM   1047  HG3 GLN A  63      -0.582  43.990  -2.266  1.00  0.00           H  
ATOM   1048 HE21 GLN A  63       1.504  41.270  -2.002  1.00  0.00           H  
ATOM   1049 HE22 GLN A  63       2.997  42.127  -2.131  1.00  0.00           H  
ATOM   1050  N   SER A  64      -2.098  40.337   1.316  1.00  0.00           N  
ATOM   1051  CA  SER A  64      -1.818  38.985   1.748  1.00  0.00           C  
ATOM   1052  C   SER A  64      -3.112  38.265   2.088  1.00  0.00           C  
ATOM   1053  O   SER A  64      -4.022  38.839   2.691  1.00  0.00           O  
ATOM   1054  CB  SER A  64      -0.884  38.984   2.961  1.00  0.00           C  
ATOM   1055  OG  SER A  64      -0.631  37.660   3.409  1.00  0.00           O  
ATOM   1056  H   SER A  64      -2.862  40.808   1.714  1.00  0.00           H  
ATOM   1057  HA  SER A  64      -1.336  38.470   0.933  1.00  0.00           H  
ATOM   1058  HB2 SER A  64       0.054  39.442   2.689  1.00  0.00           H  
ATOM   1059  HB3 SER A  64      -1.339  39.543   3.766  1.00  0.00           H  
ATOM   1060  HG  SER A  64       0.144  37.311   2.962  1.00  0.00           H  
ATOM   1061  N   ILE A  65      -3.175  37.005   1.695  1.00  0.00           N  
ATOM   1062  CA  ILE A  65      -4.341  36.165   1.940  1.00  0.00           C  
ATOM   1063  C   ILE A  65      -4.672  36.086   3.433  1.00  0.00           C  
ATOM   1064  O   ILE A  65      -5.843  36.044   3.813  1.00  0.00           O  
ATOM   1065  CB  ILE A  65      -4.135  34.737   1.387  1.00  0.00           C  
ATOM   1066  CG1 ILE A  65      -2.751  34.193   1.767  1.00  0.00           C  
ATOM   1067  CG2 ILE A  65      -4.313  34.723  -0.124  1.00  0.00           C  
ATOM   1068  CD1 ILE A  65      -2.626  32.694   1.600  1.00  0.00           C  
ATOM   1069  H   ILE A  65      -2.412  36.627   1.226  1.00  0.00           H  
ATOM   1070  HA  ILE A  65      -5.179  36.607   1.424  1.00  0.00           H  
ATOM   1071  HB  ILE A  65      -4.887  34.105   1.816  1.00  0.00           H  
ATOM   1072 HG12 ILE A  65      -2.004  34.656   1.140  1.00  0.00           H  
ATOM   1073 HG13 ILE A  65      -2.545  34.431   2.801  1.00  0.00           H  
ATOM   1074 HG21 ILE A  65      -4.972  35.526  -0.417  1.00  0.00           H  
ATOM   1075 HG22 ILE A  65      -4.739  33.779  -0.426  1.00  0.00           H  
ATOM   1076 HG23 ILE A  65      -3.353  34.854  -0.599  1.00  0.00           H  
ATOM   1077 HD11 ILE A  65      -3.400  32.339   0.936  1.00  0.00           H  
ATOM   1078 HD12 ILE A  65      -2.730  32.214   2.563  1.00  0.00           H  
ATOM   1079 HD13 ILE A  65      -1.657  32.458   1.183  1.00  0.00           H  
ATOM   1080  N   GLU A  66      -3.634  36.073   4.271  1.00  0.00           N  
ATOM   1081  CA  GLU A  66      -3.805  36.011   5.721  1.00  0.00           C  
ATOM   1082  C   GLU A  66      -4.390  37.318   6.259  1.00  0.00           C  
ATOM   1083  O   GLU A  66      -5.246  37.304   7.142  1.00  0.00           O  
ATOM   1084  CB  GLU A  66      -2.460  35.723   6.394  1.00  0.00           C  
ATOM   1085  CG  GLU A  66      -2.560  35.506   7.894  1.00  0.00           C  
ATOM   1086  CD  GLU A  66      -1.203  35.493   8.572  1.00  0.00           C  
ATOM   1087  OE1 GLU A  66      -0.600  34.404   8.673  1.00  0.00           O  
ATOM   1088  OE2 GLU A  66      -0.741  36.574   8.995  1.00  0.00           O  
ATOM   1089  H   GLU A  66      -2.725  36.116   3.904  1.00  0.00           H  
ATOM   1090  HA  GLU A  66      -4.490  35.205   5.941  1.00  0.00           H  
ATOM   1091  HB2 GLU A  66      -2.033  34.836   5.952  1.00  0.00           H  
ATOM   1092  HB3 GLU A  66      -1.796  36.558   6.217  1.00  0.00           H  
ATOM   1093  HG2 GLU A  66      -3.152  36.301   8.324  1.00  0.00           H  
ATOM   1094  HG3 GLU A  66      -3.047  34.559   8.077  1.00  0.00           H  
ATOM   1095  N   GLU A  67      -3.923  38.440   5.715  1.00  0.00           N  
ATOM   1096  CA  GLU A  67      -4.399  39.756   6.133  1.00  0.00           C  
ATOM   1097  C   GLU A  67      -5.871  39.938   5.768  1.00  0.00           C  
ATOM   1098  O   GLU A  67      -6.677  40.366   6.596  1.00  0.00           O  
ATOM   1099  CB  GLU A  67      -3.548  40.851   5.478  1.00  0.00           C  
ATOM   1100  CG  GLU A  67      -3.938  42.262   5.892  1.00  0.00           C  
ATOM   1101  CD  GLU A  67      -3.295  42.689   7.197  1.00  0.00           C  
ATOM   1102  OE1 GLU A  67      -2.053  42.825   7.233  1.00  0.00           O  
ATOM   1103  OE2 GLU A  67      -4.033  42.886   8.185  1.00  0.00           O  
ATOM   1104  H   GLU A  67      -3.247  38.382   5.008  1.00  0.00           H  
ATOM   1105  HA  GLU A  67      -4.295  39.823   7.206  1.00  0.00           H  
ATOM   1106  HB2 GLU A  67      -2.514  40.693   5.748  1.00  0.00           H  
ATOM   1107  HB3 GLU A  67      -3.646  40.772   4.405  1.00  0.00           H  
ATOM   1108  HG2 GLU A  67      -3.629  42.949   5.117  1.00  0.00           H  
ATOM   1109  HG3 GLU A  67      -5.010  42.308   6.004  1.00  0.00           H  
ATOM   1110  N   LEU A  68      -6.210  39.605   4.524  1.00  0.00           N  
ATOM   1111  CA  LEU A  68      -7.581  39.725   4.040  1.00  0.00           C  
ATOM   1112  C   LEU A  68      -8.523  38.803   4.812  1.00  0.00           C  
ATOM   1113  O   LEU A  68      -9.595  39.224   5.245  1.00  0.00           O  
ATOM   1114  CB  LEU A  68      -7.650  39.401   2.545  1.00  0.00           C  
ATOM   1115  CG  LEU A  68      -7.703  40.617   1.615  1.00  0.00           C  
ATOM   1116  CD1 LEU A  68      -7.971  40.179   0.182  1.00  0.00           C  
ATOM   1117  CD2 LEU A  68      -8.768  41.600   2.082  1.00  0.00           C  
ATOM   1118  H   LEU A  68      -5.516  39.267   3.915  1.00  0.00           H  
ATOM   1119  HA  LEU A  68      -7.894  40.746   4.193  1.00  0.00           H  
ATOM   1120  HB2 LEU A  68      -6.781  38.814   2.285  1.00  0.00           H  
ATOM   1121  HB3 LEU A  68      -8.532  38.803   2.368  1.00  0.00           H  
ATOM   1122  HG  LEU A  68      -6.748  41.120   1.638  1.00  0.00           H  
ATOM   1123 HD11 LEU A  68      -7.048  39.849  -0.272  1.00  0.00           H  
ATOM   1124 HD12 LEU A  68      -8.371  41.008  -0.379  1.00  0.00           H  
ATOM   1125 HD13 LEU A  68      -8.683  39.366   0.180  1.00  0.00           H  
ATOM   1126 HD21 LEU A  68      -8.324  42.314   2.758  1.00  0.00           H  
ATOM   1127 HD22 LEU A  68      -9.555  41.063   2.593  1.00  0.00           H  
ATOM   1128 HD23 LEU A  68      -9.180  42.117   1.230  1.00  0.00           H  
ATOM   1129  N   LYS A  69      -8.121  37.542   4.973  1.00  0.00           N  
ATOM   1130  CA  LYS A  69      -8.936  36.557   5.682  1.00  0.00           C  
ATOM   1131  C   LYS A  69      -9.142  36.936   7.147  1.00  0.00           C  
ATOM   1132  O   LYS A  69     -10.253  36.842   7.659  1.00  0.00           O  
ATOM   1133  CB  LYS A  69      -8.302  35.168   5.592  1.00  0.00           C  
ATOM   1134  CG  LYS A  69      -8.959  34.270   4.554  1.00  0.00           C  
ATOM   1135  CD  LYS A  69      -7.985  33.239   4.005  1.00  0.00           C  
ATOM   1136  CE  LYS A  69      -7.864  32.035   4.928  1.00  0.00           C  
ATOM   1137  NZ  LYS A  69      -6.490  31.457   4.920  1.00  0.00           N  
ATOM   1138  H   LYS A  69      -7.258  37.264   4.596  1.00  0.00           H  
ATOM   1139  HA  LYS A  69      -9.902  36.528   5.199  1.00  0.00           H  
ATOM   1140  HB2 LYS A  69      -7.257  35.278   5.337  1.00  0.00           H  
ATOM   1141  HB3 LYS A  69      -8.379  34.686   6.555  1.00  0.00           H  
ATOM   1142  HG2 LYS A  69      -9.789  33.756   5.014  1.00  0.00           H  
ATOM   1143  HG3 LYS A  69      -9.316  34.881   3.740  1.00  0.00           H  
ATOM   1144  HD2 LYS A  69      -8.339  32.904   3.041  1.00  0.00           H  
ATOM   1145  HD3 LYS A  69      -7.013  33.696   3.895  1.00  0.00           H  
ATOM   1146  HE2 LYS A  69      -8.107  32.343   5.934  1.00  0.00           H  
ATOM   1147  HE3 LYS A  69      -8.565  31.279   4.606  1.00  0.00           H  
ATOM   1148  HZ1 LYS A  69      -5.788  32.199   4.723  1.00  0.00           H  
ATOM   1149  HZ2 LYS A  69      -6.415  30.723   4.188  1.00  0.00           H  
ATOM   1150  HZ3 LYS A  69      -6.276  31.030   5.844  1.00  0.00           H  
ATOM   1151  N   ASP A  70      -8.070  37.350   7.820  1.00  0.00           N  
ATOM   1152  CA  ASP A  70      -8.153  37.721   9.234  1.00  0.00           C  
ATOM   1153  C   ASP A  70      -9.156  38.853   9.467  1.00  0.00           C  
ATOM   1154  O   ASP A  70      -9.977  38.779  10.381  1.00  0.00           O  
ATOM   1155  CB  ASP A  70      -6.773  38.135   9.760  1.00  0.00           C  
ATOM   1156  CG  ASP A  70      -6.024  36.980  10.400  1.00  0.00           C  
ATOM   1157  OD1 ASP A  70      -5.789  35.967   9.710  1.00  0.00           O  
ATOM   1158  OD2 ASP A  70      -5.674  37.090  11.591  1.00  0.00           O  
ATOM   1159  H   ASP A  70      -7.201  37.396   7.362  1.00  0.00           H  
ATOM   1160  HA  ASP A  70      -8.483  36.851   9.780  1.00  0.00           H  
ATOM   1161  HB2 ASP A  70      -6.181  38.512   8.939  1.00  0.00           H  
ATOM   1162  HB3 ASP A  70      -6.895  38.915  10.496  1.00  0.00           H  
ATOM   1163  N   ASN A  71      -9.086  39.897   8.640  1.00  0.00           N  
ATOM   1164  CA  ASN A  71      -9.991  41.038   8.772  1.00  0.00           C  
ATOM   1165  C   ASN A  71     -11.394  40.701   8.265  1.00  0.00           C  
ATOM   1166  O   ASN A  71     -12.386  40.974   8.944  1.00  0.00           O  
ATOM   1167  CB  ASN A  71      -9.430  42.257   8.037  1.00  0.00           C  
ATOM   1168  CG  ASN A  71      -8.331  42.946   8.828  1.00  0.00           C  
ATOM   1169  OD1 ASN A  71      -7.197  43.060   8.365  1.00  0.00           O  
ATOM   1170  ND2 ASN A  71      -8.662  43.413  10.030  1.00  0.00           N  
ATOM   1171  H   ASN A  71      -8.410  39.901   7.928  1.00  0.00           H  
ATOM   1172  HA  ASN A  71     -10.059  41.272   9.824  1.00  0.00           H  
ATOM   1173  HB2 ASN A  71      -9.023  41.943   7.087  1.00  0.00           H  
ATOM   1174  HB3 ASN A  71     -10.225  42.966   7.866  1.00  0.00           H  
ATOM   1175 HD21 ASN A  71      -9.584  43.289  10.338  1.00  0.00           H  
ATOM   1176 HD22 ASN A  71      -7.970  43.862  10.557  1.00  0.00           H  
ATOM   1177  N   PHE A  72     -11.474  40.097   7.077  1.00  0.00           N  
ATOM   1178  CA  PHE A  72     -12.762  39.713   6.497  1.00  0.00           C  
ATOM   1179  C   PHE A  72     -13.494  38.749   7.429  1.00  0.00           C  
ATOM   1180  O   PHE A  72     -14.700  38.878   7.653  1.00  0.00           O  
ATOM   1181  CB  PHE A  72     -12.561  39.072   5.116  1.00  0.00           C  
ATOM   1182  CG  PHE A  72     -13.816  38.501   4.507  1.00  0.00           C  
ATOM   1183  CD1 PHE A  72     -14.997  39.229   4.496  1.00  0.00           C  
ATOM   1184  CD2 PHE A  72     -13.810  37.235   3.943  1.00  0.00           C  
ATOM   1185  CE1 PHE A  72     -16.145  38.703   3.937  1.00  0.00           C  
ATOM   1186  CE2 PHE A  72     -14.957  36.706   3.381  1.00  0.00           C  
ATOM   1187  CZ  PHE A  72     -16.125  37.441   3.380  1.00  0.00           C  
ATOM   1188  H   PHE A  72     -10.650  39.895   6.584  1.00  0.00           H  
ATOM   1189  HA  PHE A  72     -13.356  40.608   6.387  1.00  0.00           H  
ATOM   1190  HB2 PHE A  72     -12.176  39.817   4.438  1.00  0.00           H  
ATOM   1191  HB3 PHE A  72     -11.840  38.270   5.204  1.00  0.00           H  
ATOM   1192  HD1 PHE A  72     -15.015  40.218   4.932  1.00  0.00           H  
ATOM   1193  HD2 PHE A  72     -12.898  36.659   3.944  1.00  0.00           H  
ATOM   1194  HE1 PHE A  72     -17.058  39.279   3.936  1.00  0.00           H  
ATOM   1195  HE2 PHE A  72     -14.937  35.719   2.944  1.00  0.00           H  
ATOM   1196  HZ  PHE A  72     -17.020  37.030   2.940  1.00  0.00           H  
ATOM   1197  N   LYS A  73     -12.747  37.794   7.985  1.00  0.00           N  
ATOM   1198  CA  LYS A  73     -13.306  36.815   8.910  1.00  0.00           C  
ATOM   1199  C   LYS A  73     -13.786  37.495  10.192  1.00  0.00           C  
ATOM   1200  O   LYS A  73     -14.790  37.086  10.775  1.00  0.00           O  
ATOM   1201  CB  LYS A  73     -12.273  35.733   9.244  1.00  0.00           C  
ATOM   1202  CG  LYS A  73     -12.836  34.577  10.059  1.00  0.00           C  
ATOM   1203  CD  LYS A  73     -12.456  33.232   9.459  1.00  0.00           C  
ATOM   1204  CE  LYS A  73     -13.630  32.594   8.731  1.00  0.00           C  
ATOM   1205  NZ  LYS A  73     -13.298  31.232   8.227  1.00  0.00           N  
ATOM   1206  H   LYS A  73     -11.790  37.755   7.775  1.00  0.00           H  
ATOM   1207  HA  LYS A  73     -14.154  36.354   8.426  1.00  0.00           H  
ATOM   1208  HB2 LYS A  73     -11.877  35.337   8.323  1.00  0.00           H  
ATOM   1209  HB3 LYS A  73     -11.468  36.183   9.808  1.00  0.00           H  
ATOM   1210  HG2 LYS A  73     -12.446  34.634  11.063  1.00  0.00           H  
ATOM   1211  HG3 LYS A  73     -13.913  34.658  10.085  1.00  0.00           H  
ATOM   1212  HD2 LYS A  73     -11.646  33.376   8.759  1.00  0.00           H  
ATOM   1213  HD3 LYS A  73     -12.136  32.573  10.253  1.00  0.00           H  
ATOM   1214  HE2 LYS A  73     -14.463  32.521   9.414  1.00  0.00           H  
ATOM   1215  HE3 LYS A  73     -13.903  33.223   7.895  1.00  0.00           H  
ATOM   1216  HZ1 LYS A  73     -12.389  31.249   7.722  1.00  0.00           H  
ATOM   1217  HZ2 LYS A  73     -14.036  30.903   7.574  1.00  0.00           H  
ATOM   1218  HZ3 LYS A  73     -13.228  30.564   9.020  1.00  0.00           H  
ATOM   1219  N   LEU A  74     -13.063  38.531  10.628  1.00  0.00           N  
ATOM   1220  CA  LEU A  74     -13.429  39.257  11.843  1.00  0.00           C  
ATOM   1221  C   LEU A  74     -14.824  39.863  11.713  1.00  0.00           C  
ATOM   1222  O   LEU A  74     -15.634  39.747  12.625  1.00  0.00           O  
ATOM   1223  CB  LEU A  74     -12.406  40.358  12.147  1.00  0.00           C  
ATOM   1224  CG  LEU A  74     -11.277  39.949  13.099  1.00  0.00           C  
ATOM   1225  CD1 LEU A  74     -10.024  40.773  12.835  1.00  0.00           C  
ATOM   1226  CD2 LEU A  74     -11.721  40.098  14.548  1.00  0.00           C  
ATOM   1227  H   LEU A  74     -12.269  38.812  10.124  1.00  0.00           H  
ATOM   1228  HA  LEU A  74     -13.434  38.550  12.658  1.00  0.00           H  
ATOM   1229  HB2 LEU A  74     -11.965  40.680  11.215  1.00  0.00           H  
ATOM   1230  HB3 LEU A  74     -12.930  41.195  12.587  1.00  0.00           H  
ATOM   1231  HG  LEU A  74     -11.032  38.909  12.930  1.00  0.00           H  
ATOM   1232 HD11 LEU A  74     -10.300  41.725  12.406  1.00  0.00           H  
ATOM   1233 HD12 LEU A  74      -9.384  40.242  12.147  1.00  0.00           H  
ATOM   1234 HD13 LEU A  74      -9.496  40.935  13.763  1.00  0.00           H  
ATOM   1235 HD21 LEU A  74     -12.097  41.097  14.711  1.00  0.00           H  
ATOM   1236 HD22 LEU A  74     -10.882  39.918  15.203  1.00  0.00           H  
ATOM   1237 HD23 LEU A  74     -12.502  39.381  14.761  1.00  0.00           H  
ATOM   1238  N   MET A  75     -15.112  40.494  10.570  1.00  0.00           N  
ATOM   1239  CA  MET A  75     -16.429  41.092  10.348  1.00  0.00           C  
ATOM   1240  C   MET A  75     -17.507  40.016  10.272  1.00  0.00           C  
ATOM   1241  O   MET A  75     -18.586  40.178  10.832  1.00  0.00           O  
ATOM   1242  CB  MET A  75     -16.454  41.939   9.073  1.00  0.00           C  
ATOM   1243  CG  MET A  75     -17.443  43.099   9.134  1.00  0.00           C  
ATOM   1244  SD  MET A  75     -18.579  43.121   7.734  1.00  0.00           S  
ATOM   1245  CE  MET A  75     -19.775  41.887   8.242  1.00  0.00           C  
ATOM   1246  H   MET A  75     -14.432  40.548   9.862  1.00  0.00           H  
ATOM   1247  HA  MET A  75     -16.642  41.730  11.193  1.00  0.00           H  
ATOM   1248  HB2 MET A  75     -15.466  42.343   8.903  1.00  0.00           H  
ATOM   1249  HB3 MET A  75     -16.723  41.308   8.240  1.00  0.00           H  
ATOM   1250  HG2 MET A  75     -18.019  43.023  10.048  1.00  0.00           H  
ATOM   1251  HG3 MET A  75     -16.888  44.025   9.143  1.00  0.00           H  
ATOM   1252  HE1 MET A  75     -19.562  41.576   9.253  1.00  0.00           H  
ATOM   1253  HE2 MET A  75     -19.714  41.034   7.583  1.00  0.00           H  
ATOM   1254  HE3 MET A  75     -20.767  42.308   8.195  1.00  0.00           H  
ATOM   1255  N   CYS A  76     -17.204  38.914   9.581  1.00  0.00           N  
ATOM   1256  CA  CYS A  76     -18.153  37.808   9.442  1.00  0.00           C  
ATOM   1257  C   CYS A  76     -18.470  37.196  10.806  1.00  0.00           C  
ATOM   1258  O   CYS A  76     -19.635  36.993  11.149  1.00  0.00           O  
ATOM   1259  CB  CYS A  76     -17.591  36.734   8.505  1.00  0.00           C  
ATOM   1260  SG  CYS A  76     -18.031  36.967   6.766  1.00  0.00           S  
ATOM   1261  H   CYS A  76     -16.322  38.843   9.159  1.00  0.00           H  
ATOM   1262  HA  CYS A  76     -19.064  38.203   9.019  1.00  0.00           H  
ATOM   1263  HB2 CYS A  76     -16.513  36.735   8.573  1.00  0.00           H  
ATOM   1264  HB3 CYS A  76     -17.965  35.768   8.813  1.00  0.00           H  
ATOM   1265  HG  CYS A  76     -18.902  36.585   6.628  1.00  0.00           H  
ATOM   1266  N   THR A  77     -17.423  36.916  11.583  1.00  0.00           N  
ATOM   1267  CA  THR A  77     -17.581  36.336  12.915  1.00  0.00           C  
ATOM   1268  C   THR A  77     -18.230  37.338  13.873  1.00  0.00           C  
ATOM   1269  O   THR A  77     -19.108  36.975  14.659  1.00  0.00           O  
ATOM   1270  CB  THR A  77     -16.225  35.888  13.470  1.00  0.00           C  
ATOM   1271  OG1 THR A  77     -15.529  35.091  12.524  1.00  0.00           O  
ATOM   1272  CG2 THR A  77     -16.337  35.084  14.749  1.00  0.00           C  
ATOM   1273  H   THR A  77     -16.518  37.110  11.254  1.00  0.00           H  
ATOM   1274  HA  THR A  77     -18.224  35.474  12.826  1.00  0.00           H  
ATOM   1275  HB  THR A  77     -15.626  36.763  13.683  1.00  0.00           H  
ATOM   1276  HG1 THR A  77     -15.026  35.662  11.933  1.00  0.00           H  
ATOM   1277 HG21 THR A  77     -16.671  34.082  14.515  1.00  0.00           H  
ATOM   1278 HG22 THR A  77     -17.053  35.555  15.407  1.00  0.00           H  
ATOM   1279 HG23 THR A  77     -15.376  35.040  15.233  1.00  0.00           H  
ATOM   1280  N   ASN A  78     -17.794  38.595  13.800  1.00  0.00           N  
ATOM   1281  CA  ASN A  78     -18.332  39.648  14.653  1.00  0.00           C  
ATOM   1282  C   ASN A  78     -19.771  39.994  14.263  1.00  0.00           C  
ATOM   1283  O   ASN A  78     -20.584  40.353  15.116  1.00  0.00           O  
ATOM   1284  CB  ASN A  78     -17.457  40.899  14.564  1.00  0.00           C  
ATOM   1285  CG  ASN A  78     -16.072  40.706  15.168  1.00  0.00           C  
ATOM   1286  OD1 ASN A  78     -15.772  39.665  15.752  1.00  0.00           O  
ATOM   1287  ND2 ASN A  78     -15.219  41.719  15.031  1.00  0.00           N  
ATOM   1288  H   ASN A  78     -17.095  38.825  13.154  1.00  0.00           H  
ATOM   1289  HA  ASN A  78     -18.323  39.286  15.670  1.00  0.00           H  
ATOM   1290  HB2 ASN A  78     -17.341  41.175  13.528  1.00  0.00           H  
ATOM   1291  HB3 ASN A  78     -17.947  41.697  15.088  1.00  0.00           H  
ATOM   1292 HD21 ASN A  78     -15.523  42.522  14.562  1.00  0.00           H  
ATOM   1293 HD22 ASN A  78     -14.318  41.619  15.395  1.00  0.00           H  
ATOM   1294  N   ALA A  79     -20.076  39.887  12.970  1.00  0.00           N  
ATOM   1295  CA  ALA A  79     -21.414  40.185  12.471  1.00  0.00           C  
ATOM   1296  C   ALA A  79     -22.412  39.113  12.893  1.00  0.00           C  
ATOM   1297  O   ALA A  79     -23.558  39.421  13.211  1.00  0.00           O  
ATOM   1298  CB  ALA A  79     -21.402  40.322  10.954  1.00  0.00           C  
ATOM   1299  H   ALA A  79     -19.384  39.599  12.337  1.00  0.00           H  
ATOM   1300  HA  ALA A  79     -21.720  41.134  12.890  1.00  0.00           H  
ATOM   1301  HB1 ALA A  79     -20.865  39.491  10.521  1.00  0.00           H  
ATOM   1302  HB2 ALA A  79     -20.918  41.246  10.678  1.00  0.00           H  
ATOM   1303  HB3 ALA A  79     -22.418  40.323  10.586  1.00  0.00           H  
ATOM   1304  N   MET A  80     -21.975  37.852  12.893  1.00  0.00           N  
ATOM   1305  CA  MET A  80     -22.846  36.743  13.279  1.00  0.00           C  
ATOM   1306  C   MET A  80     -23.072  36.706  14.792  1.00  0.00           C  
ATOM   1307  O   MET A  80     -24.157  36.342  15.249  1.00  0.00           O  
ATOM   1308  CB  MET A  80     -22.277  35.404  12.789  1.00  0.00           C  
ATOM   1309  CG  MET A  80     -20.922  35.044  13.384  1.00  0.00           C  
ATOM   1310  SD  MET A  80     -20.659  33.263  13.489  1.00  0.00           S  
ATOM   1311  CE  MET A  80     -21.012  32.973  15.220  1.00  0.00           C  
ATOM   1312  H   MET A  80     -21.049  37.663  12.628  1.00  0.00           H  
ATOM   1313  HA  MET A  80     -23.803  36.906  12.799  1.00  0.00           H  
ATOM   1314  HB2 MET A  80     -22.974  34.618  13.044  1.00  0.00           H  
ATOM   1315  HB3 MET A  80     -22.174  35.443  11.716  1.00  0.00           H  
ATOM   1316  HG2 MET A  80     -20.150  35.469  12.763  1.00  0.00           H  
ATOM   1317  HG3 MET A  80     -20.854  35.462  14.376  1.00  0.00           H  
ATOM   1318  HE1 MET A  80     -20.086  32.827  15.758  1.00  0.00           H  
ATOM   1319  HE2 MET A  80     -21.627  32.091  15.319  1.00  0.00           H  
ATOM   1320  HE3 MET A  80     -21.535  33.824  15.629  1.00  0.00           H  
ATOM   1321  N   ILE A  81     -22.052  37.084  15.570  1.00  0.00           N  
ATOM   1322  CA  ILE A  81     -22.176  37.085  17.026  1.00  0.00           C  
ATOM   1323  C   ILE A  81     -23.144  38.177  17.492  1.00  0.00           C  
ATOM   1324  O   ILE A  81     -23.990  37.928  18.350  1.00  0.00           O  
ATOM   1325  CB  ILE A  81     -20.809  37.250  17.736  1.00  0.00           C  
ATOM   1326  CG1 ILE A  81     -20.981  37.121  19.254  1.00  0.00           C  
ATOM   1327  CG2 ILE A  81     -20.159  38.580  17.382  1.00  0.00           C  
ATOM   1328  CD1 ILE A  81     -20.484  35.804  19.813  1.00  0.00           C  
ATOM   1329  H   ILE A  81     -21.209  37.368  15.157  1.00  0.00           H  
ATOM   1330  HA  ILE A  81     -22.585  36.127  17.313  1.00  0.00           H  
ATOM   1331  HB  ILE A  81     -20.158  36.462  17.391  1.00  0.00           H  
ATOM   1332 HG12 ILE A  81     -20.432  37.913  19.743  1.00  0.00           H  
ATOM   1333 HG13 ILE A  81     -22.028  37.211  19.503  1.00  0.00           H  
ATOM   1334 HG21 ILE A  81     -19.209  38.662  17.891  1.00  0.00           H  
ATOM   1335 HG22 ILE A  81     -20.802  39.391  17.690  1.00  0.00           H  
ATOM   1336 HG23 ILE A  81     -20.001  38.627  16.318  1.00  0.00           H  
ATOM   1337 HD11 ILE A  81     -19.754  35.379  19.139  1.00  0.00           H  
ATOM   1338 HD12 ILE A  81     -21.315  35.121  19.919  1.00  0.00           H  
ATOM   1339 HD13 ILE A  81     -20.031  35.970  20.778  1.00  0.00           H  
ATOM   1340  N   TYR A  82     -23.029  39.381  16.917  1.00  0.00           N  
ATOM   1341  CA  TYR A  82     -23.918  40.481  17.286  1.00  0.00           C  
ATOM   1342  C   TYR A  82     -25.109  40.585  16.325  1.00  0.00           C  
ATOM   1343  O   TYR A  82     -25.590  41.685  16.036  1.00  0.00           O  
ATOM   1344  CB  TYR A  82     -23.152  41.806  17.322  1.00  0.00           C  
ATOM   1345  CG  TYR A  82     -23.862  42.894  18.102  1.00  0.00           C  
ATOM   1346  CD1 TYR A  82     -24.469  42.622  19.325  1.00  0.00           C  
ATOM   1347  CD2 TYR A  82     -23.923  44.194  17.616  1.00  0.00           C  
ATOM   1348  CE1 TYR A  82     -25.114  43.612  20.036  1.00  0.00           C  
ATOM   1349  CE2 TYR A  82     -24.565  45.189  18.325  1.00  0.00           C  
ATOM   1350  CZ  TYR A  82     -25.159  44.895  19.533  1.00  0.00           C  
ATOM   1351  OH  TYR A  82     -25.798  45.885  20.243  1.00  0.00           O  
ATOM   1352  H   TYR A  82     -22.341  39.530  16.231  1.00  0.00           H  
ATOM   1353  HA  TYR A  82     -24.297  40.273  18.276  1.00  0.00           H  
ATOM   1354  HB2 TYR A  82     -22.189  41.647  17.781  1.00  0.00           H  
ATOM   1355  HB3 TYR A  82     -23.011  42.159  16.310  1.00  0.00           H  
ATOM   1356  HD1 TYR A  82     -24.432  41.616  19.716  1.00  0.00           H  
ATOM   1357  HD2 TYR A  82     -23.458  44.424  16.669  1.00  0.00           H  
ATOM   1358  HE1 TYR A  82     -25.579  43.382  20.983  1.00  0.00           H  
ATOM   1359  HE2 TYR A  82     -24.602  46.192  17.931  1.00  0.00           H  
ATOM   1360  HH  TYR A  82     -26.727  45.660  20.345  1.00  0.00           H  
ATOM   1361  N   ASN A  83     -25.590  39.437  15.845  1.00  0.00           N  
ATOM   1362  CA  ASN A  83     -26.730  39.404  14.934  1.00  0.00           C  
ATOM   1363  C   ASN A  83     -27.321  38.000  14.858  1.00  0.00           C  
ATOM   1364  O   ASN A  83     -26.853  37.158  14.091  1.00  0.00           O  
ATOM   1365  CB  ASN A  83     -26.331  39.880  13.533  1.00  0.00           C  
ATOM   1366  CG  ASN A  83     -27.425  40.698  12.867  1.00  0.00           C  
ATOM   1367  OD1 ASN A  83     -27.195  41.828  12.439  1.00  0.00           O  
ATOM   1368  ND2 ASN A  83     -28.627  40.129  12.775  1.00  0.00           N  
ATOM   1369  H   ASN A  83     -25.177  38.591  16.116  1.00  0.00           H  
ATOM   1370  HA  ASN A  83     -27.482  40.072  15.328  1.00  0.00           H  
ATOM   1371  HB2 ASN A  83     -25.445  40.494  13.605  1.00  0.00           H  
ATOM   1372  HB3 ASN A  83     -26.117  39.022  12.913  1.00  0.00           H  
ATOM   1373 HD21 ASN A  83     -28.745  39.225  13.135  1.00  0.00           H  
ATOM   1374 HD22 ASN A  83     -29.347  40.640  12.351  1.00  0.00           H  
ATOM   1375  N   LYS A  84     -28.361  37.763  15.655  1.00  0.00           N  
ATOM   1376  CA  LYS A  84     -29.031  36.467  15.678  1.00  0.00           C  
ATOM   1377  C   LYS A  84     -29.820  36.258  14.387  1.00  0.00           C  
ATOM   1378  O   LYS A  84     -30.143  37.225  13.696  1.00  0.00           O  
ATOM   1379  CB  LYS A  84     -29.969  36.370  16.886  1.00  0.00           C  
ATOM   1380  CG  LYS A  84     -29.262  36.507  18.226  1.00  0.00           C  
ATOM   1381  CD  LYS A  84     -30.124  35.984  19.364  1.00  0.00           C  
ATOM   1382  CE  LYS A  84     -30.077  36.907  20.572  1.00  0.00           C  
ATOM   1383  NZ  LYS A  84     -31.057  36.502  21.619  1.00  0.00           N  
ATOM   1384  H   LYS A  84     -28.691  38.480  16.235  1.00  0.00           H  
ATOM   1385  HA  LYS A  84     -28.274  35.700  15.754  1.00  0.00           H  
ATOM   1386  HB2 LYS A  84     -30.709  37.152  16.815  1.00  0.00           H  
ATOM   1387  HB3 LYS A  84     -30.468  35.413  16.864  1.00  0.00           H  
ATOM   1388  HG2 LYS A  84     -28.340  35.942  18.197  1.00  0.00           H  
ATOM   1389  HG3 LYS A  84     -29.041  37.550  18.401  1.00  0.00           H  
ATOM   1390  HD2 LYS A  84     -31.146  35.908  19.022  1.00  0.00           H  
ATOM   1391  HD3 LYS A  84     -29.765  35.007  19.652  1.00  0.00           H  
ATOM   1392  HE2 LYS A  84     -29.083  36.879  20.992  1.00  0.00           H  
ATOM   1393  HE3 LYS A  84     -30.303  37.912  20.249  1.00  0.00           H  
ATOM   1394  HZ1 LYS A  84     -31.135  37.247  22.341  1.00  0.00           H  
ATOM   1395  HZ2 LYS A  84     -30.748  35.621  22.077  1.00  0.00           H  
ATOM   1396  HZ3 LYS A  84     -31.994  36.348  21.192  1.00  0.00           H  
ATOM   1397  N   PRO A  85     -30.135  34.992  14.039  1.00  0.00           N  
ATOM   1398  CA  PRO A  85     -30.892  34.666  12.819  1.00  0.00           C  
ATOM   1399  C   PRO A  85     -32.285  35.293  12.828  1.00  0.00           C  
ATOM   1400  O   PRO A  85     -33.282  34.629  13.110  1.00  0.00           O  
ATOM   1401  CB  PRO A  85     -30.978  33.134  12.840  1.00  0.00           C  
ATOM   1402  CG  PRO A  85     -30.721  32.749  14.257  1.00  0.00           C  
ATOM   1403  CD  PRO A  85     -29.778  33.783  14.801  1.00  0.00           C  
ATOM   1404  HA  PRO A  85     -30.362  34.987  11.936  1.00  0.00           H  
ATOM   1405  HB2 PRO A  85     -31.962  32.823  12.518  1.00  0.00           H  
ATOM   1406  HB3 PRO A  85     -30.230  32.721  12.178  1.00  0.00           H  
ATOM   1407  HG2 PRO A  85     -31.647  32.757  14.811  1.00  0.00           H  
ATOM   1408  HG3 PRO A  85     -30.266  31.771  14.296  1.00  0.00           H  
ATOM   1409  HD3 PRO A  85     -29.945  33.928  15.858  1.00  0.00           H  
ATOM   1410  HD2 PRO A  85     -28.754  33.501  14.613  1.00  0.00           H  
ATOM   1411  N   GLU A  86     -32.328  36.589  12.529  1.00  0.00           N  
ATOM   1412  CA  GLU A  86     -33.575  37.345  12.506  1.00  0.00           C  
ATOM   1413  C   GLU A  86     -34.280  37.211  11.161  1.00  0.00           C  
ATOM   1414  O   GLU A  86     -35.414  36.734  11.090  1.00  0.00           O  
ATOM   1415  CB  GLU A  86     -33.293  38.824  12.799  1.00  0.00           C  
ATOM   1416  CG  GLU A  86     -33.824  39.298  14.143  1.00  0.00           C  
ATOM   1417  CD  GLU A  86     -32.892  40.283  14.824  1.00  0.00           C  
ATOM   1418  OE1 GLU A  86     -32.794  41.434  14.353  1.00  0.00           O  
ATOM   1419  OE2 GLU A  86     -32.252  39.897  15.827  1.00  0.00           O  
ATOM   1420  H   GLU A  86     -31.484  37.053  12.331  1.00  0.00           H  
ATOM   1421  HA  GLU A  86     -34.218  36.951  13.279  1.00  0.00           H  
ATOM   1422  HB2 GLU A  86     -32.224  38.986  12.784  1.00  0.00           H  
ATOM   1423  HB3 GLU A  86     -33.747  39.426  12.024  1.00  0.00           H  
ATOM   1424  HG2 GLU A  86     -34.779  39.779  13.990  1.00  0.00           H  
ATOM   1425  HG3 GLU A  86     -33.955  38.442  14.787  1.00  0.00           H  
ATOM   1426  N   THR A  87     -33.605  37.639  10.097  1.00  0.00           N  
ATOM   1427  CA  THR A  87     -34.169  37.577   8.751  1.00  0.00           C  
ATOM   1428  C   THR A  87     -33.117  37.114   7.738  1.00  0.00           C  
ATOM   1429  O   THR A  87     -33.045  35.928   7.409  1.00  0.00           O  
ATOM   1430  CB  THR A  87     -34.740  38.948   8.350  1.00  0.00           C  
ATOM   1431  OG1 THR A  87     -34.166  39.991   9.128  1.00  0.00           O  
ATOM   1432  CG2 THR A  87     -36.244  39.037   8.506  1.00  0.00           C  
ATOM   1433  H   THR A  87     -32.705  38.013  10.220  1.00  0.00           H  
ATOM   1434  HA  THR A  87     -34.972  36.856   8.764  1.00  0.00           H  
ATOM   1435  HB  THR A  87     -34.504  39.134   7.314  1.00  0.00           H  
ATOM   1436  HG1 THR A  87     -33.207  39.931   9.095  1.00  0.00           H  
ATOM   1437 HG21 THR A  87     -36.515  40.026   8.842  1.00  0.00           H  
ATOM   1438 HG22 THR A  87     -36.575  38.308   9.230  1.00  0.00           H  
ATOM   1439 HG23 THR A  87     -36.716  38.840   7.555  1.00  0.00           H  
ATOM   1440  N   ILE A  88     -32.302  38.052   7.250  1.00  0.00           N  
ATOM   1441  CA  ILE A  88     -31.256  37.735   6.282  1.00  0.00           C  
ATOM   1442  C   ILE A  88     -29.881  38.226   6.759  1.00  0.00           C  
ATOM   1443  O   ILE A  88     -28.887  38.055   6.059  1.00  0.00           O  
ATOM   1444  CB  ILE A  88     -31.564  38.349   4.893  1.00  0.00           C  
ATOM   1445  CG1 ILE A  88     -33.015  38.065   4.485  1.00  0.00           C  
ATOM   1446  CG2 ILE A  88     -30.604  37.804   3.841  1.00  0.00           C  
ATOM   1447  CD1 ILE A  88     -33.962  39.217   4.750  1.00  0.00           C  
ATOM   1448  H   ILE A  88     -32.406  38.978   7.546  1.00  0.00           H  
ATOM   1449  HA  ILE A  88     -31.218  36.660   6.174  1.00  0.00           H  
ATOM   1450  HB  ILE A  88     -31.418  39.418   4.959  1.00  0.00           H  
ATOM   1451 HG12 ILE A  88     -33.048  37.850   3.427  1.00  0.00           H  
ATOM   1452 HG13 ILE A  88     -33.375  37.207   5.031  1.00  0.00           H  
ATOM   1453 HG21 ILE A  88     -30.395  36.767   4.049  1.00  0.00           H  
ATOM   1454 HG22 ILE A  88     -29.683  38.370   3.868  1.00  0.00           H  
ATOM   1455 HG23 ILE A  88     -31.052  37.894   2.864  1.00  0.00           H  
ATOM   1456 HD11 ILE A  88     -34.270  39.652   3.811  1.00  0.00           H  
ATOM   1457 HD12 ILE A  88     -33.464  39.964   5.349  1.00  0.00           H  
ATOM   1458 HD13 ILE A  88     -34.830  38.852   5.279  1.00  0.00           H  
ATOM   1459  N   TYR A  89     -29.825  38.830   7.955  1.00  0.00           N  
ATOM   1460  CA  TYR A  89     -28.562  39.329   8.499  1.00  0.00           C  
ATOM   1461  C   TYR A  89     -27.609  38.177   8.813  1.00  0.00           C  
ATOM   1462  O   TYR A  89     -26.434  38.220   8.449  1.00  0.00           O  
ATOM   1463  CB  TYR A  89     -28.810  40.144   9.772  1.00  0.00           C  
ATOM   1464  CG  TYR A  89     -29.412  41.510   9.522  1.00  0.00           C  
ATOM   1465  CD1 TYR A  89     -30.789  41.684   9.473  1.00  0.00           C  
ATOM   1466  CD2 TYR A  89     -28.601  42.623   9.346  1.00  0.00           C  
ATOM   1467  CE1 TYR A  89     -31.340  42.930   9.249  1.00  0.00           C  
ATOM   1468  CE2 TYR A  89     -29.146  43.873   9.127  1.00  0.00           C  
ATOM   1469  CZ  TYR A  89     -30.515  44.021   9.079  1.00  0.00           C  
ATOM   1470  OH  TYR A  89     -31.063  45.263   8.861  1.00  0.00           O  
ATOM   1471  H   TYR A  89     -30.643  38.935   8.480  1.00  0.00           H  
ATOM   1472  HA  TYR A  89     -28.109  39.967   7.757  1.00  0.00           H  
ATOM   1473  HB2 TYR A  89     -29.484  39.600  10.414  1.00  0.00           H  
ATOM   1474  HB3 TYR A  89     -27.870  40.286  10.285  1.00  0.00           H  
ATOM   1475  HD1 TYR A  89     -31.431  40.828   9.608  1.00  0.00           H  
ATOM   1476  HD2 TYR A  89     -27.529  42.504   9.384  1.00  0.00           H  
ATOM   1477  HE1 TYR A  89     -32.414  43.046   9.212  1.00  0.00           H  
ATOM   1478  HE2 TYR A  89     -28.500  44.727   8.992  1.00  0.00           H  
ATOM   1479  HH  TYR A  89     -31.173  45.716   9.700  1.00  0.00           H  
ATOM   1480  N   TYR A  90     -28.128  37.145   9.483  1.00  0.00           N  
ATOM   1481  CA  TYR A  90     -27.322  35.978   9.839  1.00  0.00           C  
ATOM   1482  C   TYR A  90     -26.873  35.232   8.584  1.00  0.00           C  
ATOM   1483  O   TYR A  90     -25.692  34.914   8.428  1.00  0.00           O  
ATOM   1484  CB  TYR A  90     -28.109  35.038  10.760  1.00  0.00           C  
ATOM   1485  CG  TYR A  90     -27.294  33.870  11.280  1.00  0.00           C  
ATOM   1486  CD1 TYR A  90     -26.139  34.081  12.024  1.00  0.00           C  
ATOM   1487  CD2 TYR A  90     -27.678  32.559  11.025  1.00  0.00           C  
ATOM   1488  CE1 TYR A  90     -25.392  33.021  12.498  1.00  0.00           C  
ATOM   1489  CE2 TYR A  90     -26.937  31.493  11.498  1.00  0.00           C  
ATOM   1490  CZ  TYR A  90     -25.796  31.730  12.232  1.00  0.00           C  
ATOM   1491  OH  TYR A  90     -25.053  30.668  12.701  1.00  0.00           O  
ATOM   1492  H   TYR A  90     -29.075  37.170   9.742  1.00  0.00           H  
ATOM   1493  HA  TYR A  90     -26.446  36.329  10.363  1.00  0.00           H  
ATOM   1494  HB2 TYR A  90     -28.466  35.598  11.612  1.00  0.00           H  
ATOM   1495  HB3 TYR A  90     -28.955  34.640  10.219  1.00  0.00           H  
ATOM   1496  HD1 TYR A  90     -25.826  35.094  12.231  1.00  0.00           H  
ATOM   1497  HD2 TYR A  90     -28.573  32.377  10.448  1.00  0.00           H  
ATOM   1498  HE1 TYR A  90     -24.498  33.207  13.075  1.00  0.00           H  
ATOM   1499  HE2 TYR A  90     -27.254  30.483  11.289  1.00  0.00           H  
ATOM   1500  HH  TYR A  90     -24.907  30.770  13.645  1.00  0.00           H  
ATOM   1501  N   LYS A  91     -27.821  34.969   7.683  1.00  0.00           N  
ATOM   1502  CA  LYS A  91     -27.523  34.270   6.436  1.00  0.00           C  
ATOM   1503  C   LYS A  91     -26.599  35.109   5.552  1.00  0.00           C  
ATOM   1504  O   LYS A  91     -25.750  34.565   4.847  1.00  0.00           O  
ATOM   1505  CB  LYS A  91     -28.811  33.935   5.681  1.00  0.00           C  
ATOM   1506  CG  LYS A  91     -29.324  32.529   5.946  1.00  0.00           C  
ATOM   1507  CD  LYS A  91     -29.987  31.933   4.712  1.00  0.00           C  
ATOM   1508  CE  LYS A  91     -29.447  30.544   4.405  1.00  0.00           C  
ATOM   1509  NZ  LYS A  91     -30.303  29.471   4.984  1.00  0.00           N  
ATOM   1510  H   LYS A  91     -28.742  35.255   7.862  1.00  0.00           H  
ATOM   1511  HA  LYS A  91     -27.016  33.352   6.689  1.00  0.00           H  
ATOM   1512  HB2 LYS A  91     -29.581  34.636   5.972  1.00  0.00           H  
ATOM   1513  HB3 LYS A  91     -28.630  34.035   4.621  1.00  0.00           H  
ATOM   1514  HG2 LYS A  91     -28.494  31.902   6.232  1.00  0.00           H  
ATOM   1515  HG3 LYS A  91     -30.045  32.564   6.749  1.00  0.00           H  
ATOM   1516  HD2 LYS A  91     -31.051  31.864   4.884  1.00  0.00           H  
ATOM   1517  HD3 LYS A  91     -29.800  32.578   3.867  1.00  0.00           H  
ATOM   1518  HE2 LYS A  91     -29.403  30.418   3.334  1.00  0.00           H  
ATOM   1519  HE3 LYS A  91     -28.451  30.461   4.816  1.00  0.00           H  
ATOM   1520  HZ1 LYS A  91     -29.847  28.542   4.859  1.00  0.00           H  
ATOM   1521  HZ2 LYS A  91     -31.228  29.455   4.510  1.00  0.00           H  
ATOM   1522  HZ3 LYS A  91     -30.451  29.638   6.002  1.00  0.00           H  
ATOM   1523  N   ALA A  92     -26.767  36.434   5.595  1.00  0.00           N  
ATOM   1524  CA  ALA A  92     -25.942  37.341   4.799  1.00  0.00           C  
ATOM   1525  C   ALA A  92     -24.465  37.188   5.154  1.00  0.00           C  
ATOM   1526  O   ALA A  92     -23.618  37.084   4.267  1.00  0.00           O  
ATOM   1527  CB  ALA A  92     -26.383  38.784   5.005  1.00  0.00           C  
ATOM   1528  H   ALA A  92     -27.461  36.809   6.179  1.00  0.00           H  
ATOM   1529  HA  ALA A  92     -26.081  37.090   3.758  1.00  0.00           H  
ATOM   1530  HB1 ALA A  92     -25.561  39.447   4.779  1.00  0.00           H  
ATOM   1531  HB2 ALA A  92     -26.685  38.925   6.032  1.00  0.00           H  
ATOM   1532  HB3 ALA A  92     -27.213  39.003   4.352  1.00  0.00           H  
ATOM   1533  N   ALA A  93     -24.167  37.171   6.454  1.00  0.00           N  
ATOM   1534  CA  ALA A  93     -22.789  37.025   6.924  1.00  0.00           C  
ATOM   1535  C   ALA A  93     -22.208  35.674   6.515  1.00  0.00           C  
ATOM   1536  O   ALA A  93     -21.075  35.598   6.037  1.00  0.00           O  
ATOM   1537  CB  ALA A  93     -22.720  37.199   8.437  1.00  0.00           C  
ATOM   1538  H   ALA A  93     -24.889  37.255   7.112  1.00  0.00           H  
ATOM   1539  HA  ALA A  93     -22.201  37.809   6.471  1.00  0.00           H  
ATOM   1540  HB1 ALA A  93     -22.582  38.246   8.673  1.00  0.00           H  
ATOM   1541  HB2 ALA A  93     -21.886  36.633   8.828  1.00  0.00           H  
ATOM   1542  HB3 ALA A  93     -23.636  36.847   8.885  1.00  0.00           H  
ATOM   1543  N   LYS A  94     -22.993  34.611   6.702  1.00  0.00           N  
ATOM   1544  CA  LYS A  94     -22.555  33.261   6.345  1.00  0.00           C  
ATOM   1545  C   LYS A  94     -22.325  33.140   4.837  1.00  0.00           C  
ATOM   1546  O   LYS A  94     -21.291  32.630   4.397  1.00  0.00           O  
ATOM   1547  CB  LYS A  94     -23.582  32.223   6.807  1.00  0.00           C  
ATOM   1548  CG  LYS A  94     -22.966  30.888   7.196  1.00  0.00           C  
ATOM   1549  CD  LYS A  94     -24.022  29.906   7.678  1.00  0.00           C  
ATOM   1550  CE  LYS A  94     -23.397  28.606   8.156  1.00  0.00           C  
ATOM   1551  NZ  LYS A  94     -24.123  28.037   9.326  1.00  0.00           N  
ATOM   1552  H   LYS A  94     -23.887  34.736   7.084  1.00  0.00           H  
ATOM   1553  HA  LYS A  94     -21.619  33.077   6.852  1.00  0.00           H  
ATOM   1554  HB2 LYS A  94     -24.111  32.614   7.663  1.00  0.00           H  
ATOM   1555  HB3 LYS A  94     -24.288  32.050   6.007  1.00  0.00           H  
ATOM   1556  HG2 LYS A  94     -22.466  30.469   6.335  1.00  0.00           H  
ATOM   1557  HG3 LYS A  94     -22.249  31.052   7.987  1.00  0.00           H  
ATOM   1558  HD2 LYS A  94     -24.567  30.355   8.496  1.00  0.00           H  
ATOM   1559  HD3 LYS A  94     -24.701  29.692   6.866  1.00  0.00           H  
ATOM   1560  HE2 LYS A  94     -23.420  27.890   7.347  1.00  0.00           H  
ATOM   1561  HE3 LYS A  94     -22.371  28.795   8.438  1.00  0.00           H  
ATOM   1562  HZ1 LYS A  94     -23.577  27.256   9.741  1.00  0.00           H  
ATOM   1563  HZ2 LYS A  94     -25.051  27.675   9.029  1.00  0.00           H  
ATOM   1564  HZ3 LYS A  94     -24.266  28.770  10.051  1.00  0.00           H  
ATOM   1565  N   LYS A  95     -23.294  33.615   4.051  1.00  0.00           N  
ATOM   1566  CA  LYS A  95     -23.201  33.566   2.592  1.00  0.00           C  
ATOM   1567  C   LYS A  95     -21.996  34.362   2.092  1.00  0.00           C  
ATOM   1568  O   LYS A  95     -21.284  33.922   1.188  1.00  0.00           O  
ATOM   1569  CB  LYS A  95     -24.485  34.107   1.957  1.00  0.00           C  
ATOM   1570  CG  LYS A  95     -24.800  33.507   0.596  1.00  0.00           C  
ATOM   1571  CD  LYS A  95     -26.109  34.046   0.039  1.00  0.00           C  
ATOM   1572  CE  LYS A  95     -26.695  33.119  -1.016  1.00  0.00           C  
ATOM   1573  NZ  LYS A  95     -27.431  31.970  -0.410  1.00  0.00           N  
ATOM   1574  H   LYS A  95     -24.091  34.013   4.463  1.00  0.00           H  
ATOM   1575  HA  LYS A  95     -23.076  32.532   2.303  1.00  0.00           H  
ATOM   1576  HB2 LYS A  95     -25.313  33.899   2.617  1.00  0.00           H  
ATOM   1577  HB3 LYS A  95     -24.390  35.178   1.840  1.00  0.00           H  
ATOM   1578  HG2 LYS A  95     -24.002  33.750  -0.088  1.00  0.00           H  
ATOM   1579  HG3 LYS A  95     -24.875  32.434   0.696  1.00  0.00           H  
ATOM   1580  HD2 LYS A  95     -26.818  34.147   0.849  1.00  0.00           H  
ATOM   1581  HD3 LYS A  95     -25.927  35.014  -0.404  1.00  0.00           H  
ATOM   1582  HE2 LYS A  95     -27.378  33.685  -1.634  1.00  0.00           H  
ATOM   1583  HE3 LYS A  95     -25.891  32.738  -1.628  1.00  0.00           H  
ATOM   1584  HZ1 LYS A  95     -26.768  31.200  -0.187  1.00  0.00           H  
ATOM   1585  HZ2 LYS A  95     -28.147  31.614  -1.076  1.00  0.00           H  
ATOM   1586  HZ3 LYS A  95     -27.905  32.270   0.465  1.00  0.00           H  
ATOM   1587  N   LEU A  96     -21.775  35.538   2.689  1.00  0.00           N  
ATOM   1588  CA  LEU A  96     -20.657  36.397   2.308  1.00  0.00           C  
ATOM   1589  C   LEU A  96     -19.322  35.713   2.592  1.00  0.00           C  
ATOM   1590  O   LEU A  96     -18.406  35.770   1.772  1.00  0.00           O  
ATOM   1591  CB  LEU A  96     -20.729  37.741   3.047  1.00  0.00           C  
ATOM   1592  CG  LEU A  96     -20.682  38.978   2.149  1.00  0.00           C  
ATOM   1593  CD1 LEU A  96     -19.303  39.134   1.529  1.00  0.00           C  
ATOM   1594  CD2 LEU A  96     -21.747  38.902   1.066  1.00  0.00           C  
ATOM   1595  H   LEU A  96     -22.381  35.831   3.403  1.00  0.00           H  
ATOM   1596  HA  LEU A  96     -20.729  36.579   1.247  1.00  0.00           H  
ATOM   1597  HB2 LEU A  96     -21.647  37.768   3.614  1.00  0.00           H  
ATOM   1598  HB3 LEU A  96     -19.900  37.792   3.738  1.00  0.00           H  
ATOM   1599  HG  LEU A  96     -20.875  39.857   2.748  1.00  0.00           H  
ATOM   1600 HD11 LEU A  96     -19.192  38.432   0.716  1.00  0.00           H  
ATOM   1601 HD12 LEU A  96     -18.548  38.943   2.277  1.00  0.00           H  
ATOM   1602 HD13 LEU A  96     -19.190  40.141   1.153  1.00  0.00           H  
ATOM   1603 HD21 LEU A  96     -22.167  39.883   0.905  1.00  0.00           H  
ATOM   1604 HD22 LEU A  96     -22.526  38.222   1.375  1.00  0.00           H  
ATOM   1605 HD23 LEU A  96     -21.303  38.545   0.148  1.00  0.00           H  
ATOM   1606  N   LEU A  97     -19.220  35.063   3.754  1.00  0.00           N  
ATOM   1607  CA  LEU A  97     -17.995  34.362   4.140  1.00  0.00           C  
ATOM   1608  C   LEU A  97     -17.611  33.316   3.093  1.00  0.00           C  
ATOM   1609  O   LEU A  97     -16.449  33.224   2.696  1.00  0.00           O  
ATOM   1610  CB  LEU A  97     -18.166  33.690   5.507  1.00  0.00           C  
ATOM   1611  CG  LEU A  97     -16.863  33.431   6.272  1.00  0.00           C  
ATOM   1612  CD1 LEU A  97     -17.128  33.341   7.767  1.00  0.00           C  
ATOM   1613  CD2 LEU A  97     -16.191  32.160   5.770  1.00  0.00           C  
ATOM   1614  H   LEU A  97     -19.988  35.051   4.363  1.00  0.00           H  
ATOM   1615  HA  LEU A  97     -17.203  35.092   4.205  1.00  0.00           H  
ATOM   1616  HB2 LEU A  97     -18.797  34.320   6.117  1.00  0.00           H  
ATOM   1617  HB3 LEU A  97     -18.665  32.745   5.360  1.00  0.00           H  
ATOM   1618  HG  LEU A  97     -16.185  34.257   6.103  1.00  0.00           H  
ATOM   1619 HD11 LEU A  97     -18.036  33.873   8.005  1.00  0.00           H  
ATOM   1620 HD12 LEU A  97     -16.302  33.780   8.307  1.00  0.00           H  
ATOM   1621 HD13 LEU A  97     -17.233  32.305   8.054  1.00  0.00           H  
ATOM   1622 HD21 LEU A  97     -15.362  31.913   6.414  1.00  0.00           H  
ATOM   1623 HD22 LEU A  97     -15.831  32.314   4.764  1.00  0.00           H  
ATOM   1624 HD23 LEU A  97     -16.903  31.348   5.774  1.00  0.00           H  
ATOM   1625  N   HIS A  98     -18.598  32.537   2.648  1.00  0.00           N  
ATOM   1626  CA  HIS A  98     -18.366  31.501   1.642  1.00  0.00           C  
ATOM   1627  C   HIS A  98     -17.951  32.119   0.305  1.00  0.00           C  
ATOM   1628  O   HIS A  98     -17.075  31.592  -0.384  1.00  0.00           O  
ATOM   1629  CB  HIS A  98     -19.621  30.643   1.457  1.00  0.00           C  
ATOM   1630  CG  HIS A  98     -19.562  29.333   2.181  1.00  0.00           C  
ATOM   1631  ND1 HIS A  98     -19.822  28.122   1.571  1.00  0.00           N  
ATOM   1632  CD2 HIS A  98     -19.264  29.046   3.470  1.00  0.00           C  
ATOM   1633  CE1 HIS A  98     -19.687  27.149   2.456  1.00  0.00           C  
ATOM   1634  NE2 HIS A  98     -19.349  27.683   3.615  1.00  0.00           N  
ATOM   1635  H   HIS A  98     -19.505  32.663   3.002  1.00  0.00           H  
ATOM   1636  HA  HIS A  98     -17.563  30.874   1.998  1.00  0.00           H  
ATOM   1637  HB2 HIS A  98     -20.477  31.187   1.826  1.00  0.00           H  
ATOM   1638  HB3 HIS A  98     -19.757  30.439   0.406  1.00  0.00           H  
ATOM   1639  HD1 HIS A  98     -20.070  27.995   0.631  1.00  0.00           H  
ATOM   1640  HD2 HIS A  98     -19.006  29.758   4.242  1.00  0.00           H  
ATOM   1641  HE1 HIS A  98     -19.828  26.095   2.263  1.00  0.00           H  
ATOM   1642  HE2 HIS A  98     -19.208  27.187   4.447  1.00  0.00           H  
ATOM   1643  N   SER A  99     -18.585  33.239  -0.052  1.00  0.00           N  
ATOM   1644  CA  SER A  99     -18.283  33.936  -1.302  1.00  0.00           C  
ATOM   1645  C   SER A  99     -16.877  34.534  -1.271  1.00  0.00           C  
ATOM   1646  O   SER A  99     -16.121  34.404  -2.231  1.00  0.00           O  
ATOM   1647  CB  SER A  99     -19.308  35.045  -1.561  1.00  0.00           C  
ATOM   1648  OG  SER A  99     -20.396  34.568  -2.335  1.00  0.00           O  
ATOM   1649  H   SER A  99     -19.271  33.608   0.545  1.00  0.00           H  
ATOM   1650  HA  SER A  99     -18.335  33.214  -2.103  1.00  0.00           H  
ATOM   1651  HB2 SER A  99     -19.685  35.411  -0.618  1.00  0.00           H  
ATOM   1652  HB3 SER A  99     -18.830  35.854  -2.094  1.00  0.00           H  
ATOM   1653  HG  SER A  99     -20.767  33.783  -1.923  1.00  0.00           H  
ATOM   1654  N   GLY A 100     -16.534  35.188  -0.162  1.00  0.00           N  
ATOM   1655  CA  GLY A 100     -15.220  35.791  -0.034  1.00  0.00           C  
ATOM   1656  C   GLY A 100     -14.100  34.766  -0.054  1.00  0.00           C  
ATOM   1657  O   GLY A 100     -13.037  35.020  -0.620  1.00  0.00           O  
ATOM   1658  H   GLY A 100     -17.178  35.258   0.575  1.00  0.00           H  
ATOM   1659  HA2 GLY A 100     -15.074  36.483  -0.850  1.00  0.00           H  
ATOM   1660  HA3 GLY A 100     -15.175  36.337   0.898  1.00  0.00           H  
ATOM   1661  N   MET A 101     -14.343  33.609   0.560  1.00  0.00           N  
ATOM   1662  CA  MET A 101     -13.345  32.540   0.610  1.00  0.00           C  
ATOM   1663  C   MET A 101     -13.070  31.966  -0.780  1.00  0.00           C  
ATOM   1664  O   MET A 101     -11.912  31.815  -1.173  1.00  0.00           O  
ATOM   1665  CB  MET A 101     -13.807  31.424   1.551  1.00  0.00           C  
ATOM   1666  CG  MET A 101     -13.264  31.552   2.966  1.00  0.00           C  
ATOM   1667  SD  MET A 101     -12.550  30.013   3.573  1.00  0.00           S  
ATOM   1668  CE  MET A 101     -11.870  30.549   5.141  1.00  0.00           C  
ATOM   1669  H   MET A 101     -15.213  33.468   0.991  1.00  0.00           H  
ATOM   1670  HA  MET A 101     -12.431  32.965   0.995  1.00  0.00           H  
ATOM   1671  HB2 MET A 101     -14.886  31.431   1.600  1.00  0.00           H  
ATOM   1672  HB3 MET A 101     -13.481  30.474   1.150  1.00  0.00           H  
ATOM   1673  HG2 MET A 101     -12.502  32.318   2.976  1.00  0.00           H  
ATOM   1674  HG3 MET A 101     -14.073  31.844   3.620  1.00  0.00           H  
ATOM   1675  HE1 MET A 101     -10.813  30.735   5.031  1.00  0.00           H  
ATOM   1676  HE2 MET A 101     -12.026  29.778   5.883  1.00  0.00           H  
ATOM   1677  HE3 MET A 101     -12.365  31.456   5.457  1.00  0.00           H  
ATOM   1678  N   LYS A 102     -14.135  31.647  -1.520  1.00  0.00           N  
ATOM   1679  CA  LYS A 102     -13.995  31.085  -2.866  1.00  0.00           C  
ATOM   1680  C   LYS A 102     -13.278  32.062  -3.798  1.00  0.00           C  
ATOM   1681  O   LYS A 102     -12.390  31.665  -4.553  1.00  0.00           O  
ATOM   1682  CB  LYS A 102     -15.363  30.702  -3.444  1.00  0.00           C  
ATOM   1683  CG  LYS A 102     -16.358  31.852  -3.511  1.00  0.00           C  
ATOM   1684  CD  LYS A 102     -17.752  31.372  -3.878  1.00  0.00           C  
ATOM   1685  CE  LYS A 102     -17.783  30.754  -5.267  1.00  0.00           C  
ATOM   1686  NZ  LYS A 102     -17.773  29.264  -5.216  1.00  0.00           N  
ATOM   1687  H   LYS A 102     -15.033  31.791  -1.152  1.00  0.00           H  
ATOM   1688  HA  LYS A 102     -13.393  30.194  -2.781  1.00  0.00           H  
ATOM   1689  HB2 LYS A 102     -15.222  30.322  -4.446  1.00  0.00           H  
ATOM   1690  HB3 LYS A 102     -15.791  29.921  -2.831  1.00  0.00           H  
ATOM   1691  HG2 LYS A 102     -16.400  32.329  -2.545  1.00  0.00           H  
ATOM   1692  HG3 LYS A 102     -16.023  32.564  -4.252  1.00  0.00           H  
ATOM   1693  HD2 LYS A 102     -18.068  30.634  -3.157  1.00  0.00           H  
ATOM   1694  HD3 LYS A 102     -18.426  32.216  -3.852  1.00  0.00           H  
ATOM   1695  HE2 LYS A 102     -18.679  31.079  -5.772  1.00  0.00           H  
ATOM   1696  HE3 LYS A 102     -16.918  31.092  -5.817  1.00  0.00           H  
ATOM   1697  HZ1 LYS A 102     -17.746  28.873  -6.179  1.00  0.00           H  
ATOM   1698  HZ2 LYS A 102     -18.627  28.915  -4.736  1.00  0.00           H  
ATOM   1699  HZ3 LYS A 102     -16.937  28.928  -4.694  1.00  0.00           H  
ATOM   1700  N   ILE A 103     -13.661  33.338  -3.739  1.00  0.00           N  
ATOM   1701  CA  ILE A 103     -13.040  34.362  -4.579  1.00  0.00           C  
ATOM   1702  C   ILE A 103     -11.576  34.580  -4.183  1.00  0.00           C  
ATOM   1703  O   ILE A 103     -10.729  34.836  -5.040  1.00  0.00           O  
ATOM   1704  CB  ILE A 103     -13.795  35.709  -4.514  1.00  0.00           C  
ATOM   1705  CG1 ILE A 103     -15.281  35.508  -4.825  1.00  0.00           C  
ATOM   1706  CG2 ILE A 103     -13.183  36.706  -5.486  1.00  0.00           C  
ATOM   1707  CD1 ILE A 103     -16.179  36.571  -4.223  1.00  0.00           C  
ATOM   1708  H   ILE A 103     -14.372  33.598  -3.113  1.00  0.00           H  
ATOM   1709  HA  ILE A 103     -13.069  34.007  -5.601  1.00  0.00           H  
ATOM   1710  HB  ILE A 103     -13.692  36.110  -3.517  1.00  0.00           H  
ATOM   1711 HG12 ILE A 103     -15.424  35.526  -5.895  1.00  0.00           H  
ATOM   1712 HG13 ILE A 103     -15.598  34.551  -4.441  1.00  0.00           H  
ATOM   1713 HG21 ILE A 103     -13.964  37.316  -5.917  1.00  0.00           H  
ATOM   1714 HG22 ILE A 103     -12.667  36.175  -6.273  1.00  0.00           H  
ATOM   1715 HG23 ILE A 103     -12.483  37.338  -4.959  1.00  0.00           H  
ATOM   1716 HD11 ILE A 103     -16.465  37.277  -4.988  1.00  0.00           H  
ATOM   1717 HD12 ILE A 103     -15.649  37.086  -3.434  1.00  0.00           H  
ATOM   1718 HD13 ILE A 103     -17.064  36.104  -3.814  1.00  0.00           H  
ATOM   1719  N   LEU A 104     -11.283  34.470  -2.884  1.00  0.00           N  
ATOM   1720  CA  LEU A 104      -9.917  34.649  -2.385  1.00  0.00           C  
ATOM   1721  C   LEU A 104      -8.947  33.652  -3.029  1.00  0.00           C  
ATOM   1722  O   LEU A 104      -7.747  33.916  -3.115  1.00  0.00           O  
ATOM   1723  CB  LEU A 104      -9.874  34.495  -0.862  1.00  0.00           C  
ATOM   1724  CG  LEU A 104      -9.344  35.714  -0.102  1.00  0.00           C  
ATOM   1725  CD1 LEU A 104     -10.237  36.031   1.091  1.00  0.00           C  
ATOM   1726  CD2 LEU A 104      -7.908  35.482   0.347  1.00  0.00           C  
ATOM   1727  H   LEU A 104     -11.999  34.261  -2.247  1.00  0.00           H  
ATOM   1728  HA  LEU A 104      -9.603  35.649  -2.642  1.00  0.00           H  
ATOM   1729  HB2 LEU A 104     -10.875  34.283  -0.516  1.00  0.00           H  
ATOM   1730  HB3 LEU A 104      -9.245  33.650  -0.626  1.00  0.00           H  
ATOM   1731  HG  LEU A 104      -9.355  36.571  -0.760  1.00  0.00           H  
ATOM   1732 HD11 LEU A 104     -10.249  37.099   1.255  1.00  0.00           H  
ATOM   1733 HD12 LEU A 104      -9.853  35.536   1.970  1.00  0.00           H  
ATOM   1734 HD13 LEU A 104     -11.239  35.687   0.891  1.00  0.00           H  
ATOM   1735 HD21 LEU A 104      -7.360  34.986  -0.441  1.00  0.00           H  
ATOM   1736 HD22 LEU A 104      -7.902  34.865   1.233  1.00  0.00           H  
ATOM   1737 HD23 LEU A 104      -7.442  36.430   0.567  1.00  0.00           H  
ATOM   1738  N   SER A 105      -9.471  32.507  -3.487  1.00  0.00           N  
ATOM   1739  CA  SER A 105      -8.642  31.485  -4.124  1.00  0.00           C  
ATOM   1740  C   SER A 105      -8.566  31.682  -5.645  1.00  0.00           C  
ATOM   1741  O   SER A 105      -8.282  30.740  -6.385  1.00  0.00           O  
ATOM   1742  CB  SER A 105      -9.184  30.088  -3.805  1.00  0.00           C  
ATOM   1743  OG  SER A 105      -8.127  29.159  -3.625  1.00  0.00           O  
ATOM   1744  H   SER A 105     -10.434  32.349  -3.395  1.00  0.00           H  
ATOM   1745  HA  SER A 105      -7.647  31.572  -3.719  1.00  0.00           H  
ATOM   1746  HB2 SER A 105      -9.770  30.128  -2.899  1.00  0.00           H  
ATOM   1747  HB3 SER A 105      -9.807  29.751  -4.622  1.00  0.00           H  
ATOM   1748  HG  SER A 105      -7.546  29.464  -2.923  1.00  0.00           H  
ATOM   1749  N   GLN A 106      -8.810  32.912  -6.102  1.00  0.00           N  
ATOM   1750  CA  GLN A 106      -8.756  33.228  -7.525  1.00  0.00           C  
ATOM   1751  C   GLN A 106      -7.525  34.074  -7.845  1.00  0.00           C  
ATOM   1752  O   GLN A 106      -6.864  33.858  -8.863  1.00  0.00           O  
ATOM   1753  CB  GLN A 106     -10.025  33.965  -7.952  1.00  0.00           C  
ATOM   1754  CG  GLN A 106     -10.625  33.440  -9.246  1.00  0.00           C  
ATOM   1755  CD  GLN A 106     -12.076  33.838  -9.422  1.00  0.00           C  
ATOM   1756  OE1 GLN A 106     -12.964  32.985  -9.466  1.00  0.00           O  
ATOM   1757  NE2 GLN A 106     -12.328  35.138  -9.524  1.00  0.00           N  
ATOM   1758  H   GLN A 106      -9.024  33.626  -5.467  1.00  0.00           H  
ATOM   1759  HA  GLN A 106      -8.691  32.297  -8.068  1.00  0.00           H  
ATOM   1760  HB2 GLN A 106     -10.766  33.867  -7.172  1.00  0.00           H  
ATOM   1761  HB3 GLN A 106      -9.792  35.010  -8.087  1.00  0.00           H  
ATOM   1762  HG2 GLN A 106     -10.057  33.835 -10.077  1.00  0.00           H  
ATOM   1763  HG3 GLN A 106     -10.558  32.362  -9.250  1.00  0.00           H  
ATOM   1764 HE21 GLN A 106     -11.575  35.762  -9.479  1.00  0.00           H  
ATOM   1765 HE22 GLN A 106     -13.259  35.419  -9.641  1.00  0.00           H  
ATOM   1766  N   GLU A 107      -7.223  35.033  -6.967  1.00  0.00           N  
ATOM   1767  CA  GLU A 107      -6.067  35.914  -7.146  1.00  0.00           C  
ATOM   1768  C   GLU A 107      -4.751  35.143  -6.999  1.00  0.00           C  
ATOM   1769  O   GLU A 107      -3.771  35.441  -7.683  1.00  0.00           O  
ATOM   1770  CB  GLU A 107      -6.110  37.066  -6.134  1.00  0.00           C  
ATOM   1771  CG  GLU A 107      -6.190  36.609  -4.680  1.00  0.00           C  
ATOM   1772  CD  GLU A 107      -5.446  37.529  -3.726  1.00  0.00           C  
ATOM   1773  OE1 GLU A 107      -4.248  37.789  -3.962  1.00  0.00           O  
ATOM   1774  OE2 GLU A 107      -6.064  37.982  -2.740  1.00  0.00           O  
ATOM   1775  H   GLU A 107      -7.788  35.150  -6.176  1.00  0.00           H  
ATOM   1776  HA  GLU A 107      -6.116  36.325  -8.144  1.00  0.00           H  
ATOM   1777  HB2 GLU A 107      -5.219  37.665  -6.251  1.00  0.00           H  
ATOM   1778  HB3 GLU A 107      -6.974  37.680  -6.342  1.00  0.00           H  
ATOM   1779  HG2 GLU A 107      -7.227  36.578  -4.385  1.00  0.00           H  
ATOM   1780  HG3 GLU A 107      -5.769  35.621  -4.603  1.00  0.00           H  
ATOM   1781  N   ARG A 108      -4.736  34.159  -6.097  1.00  0.00           N  
ATOM   1782  CA  ARG A 108      -3.543  33.353  -5.853  1.00  0.00           C  
ATOM   1783  C   ARG A 108      -3.776  31.898  -6.259  1.00  0.00           C  
ATOM   1784  O   ARG A 108      -3.907  31.015  -5.407  1.00  0.00           O  
ATOM   1785  CB  ARG A 108      -3.144  33.437  -4.375  1.00  0.00           C  
ATOM   1786  CG  ARG A 108      -2.761  34.838  -3.924  1.00  0.00           C  
ATOM   1787  CD  ARG A 108      -1.269  34.947  -3.649  1.00  0.00           C  
ATOM   1788  NE  ARG A 108      -0.984  35.736  -2.449  1.00  0.00           N  
ATOM   1789  CZ  ARG A 108       0.240  35.907  -1.941  1.00  0.00           C  
ATOM   1790  NH1 ARG A 108       1.299  35.350  -2.526  1.00  0.00           N  
ATOM   1791  NH2 ARG A 108       0.406  36.637  -0.844  1.00  0.00           N  
ATOM   1792  H   ARG A 108      -5.548  33.974  -5.578  1.00  0.00           H  
ATOM   1793  HA  ARG A 108      -2.743  33.758  -6.455  1.00  0.00           H  
ATOM   1794  HB2 ARG A 108      -3.977  33.103  -3.773  1.00  0.00           H  
ATOM   1795  HB3 ARG A 108      -2.304  32.782  -4.205  1.00  0.00           H  
ATOM   1796  HG2 ARG A 108      -3.026  35.542  -4.699  1.00  0.00           H  
ATOM   1797  HG3 ARG A 108      -3.304  35.074  -3.020  1.00  0.00           H  
ATOM   1798  HD2 ARG A 108      -0.866  33.954  -3.517  1.00  0.00           H  
ATOM   1799  HD3 ARG A 108      -0.795  35.418  -4.498  1.00  0.00           H  
ATOM   1800  HE  ARG A 108      -1.743  36.161  -1.997  1.00  0.00           H  
ATOM   1801 HH11 ARG A 108       1.186  34.800  -3.352  1.00  0.00           H  
ATOM   1802 HH12 ARG A 108       2.212  35.483  -2.139  1.00  0.00           H  
ATOM   1803 HH21 ARG A 108      -0.384  37.060  -0.400  1.00  0.00           H  
ATOM   1804 HH22 ARG A 108       1.321  36.766  -0.461  1.00  0.00           H  
ATOM   1805  N   LEU A 109      -3.828  31.655  -7.569  1.00  0.00           N  
ATOM   1806  CA  LEU A 109      -4.047  30.310  -8.093  1.00  0.00           C  
ATOM   1807  C   LEU A 109      -2.813  29.805  -8.840  1.00  0.00           C  
ATOM   1808  O   LEU A 109      -2.613  30.120 -10.015  1.00  0.00           O  
ATOM   1809  CB  LEU A 109      -5.270  30.296  -9.014  1.00  0.00           C  
ATOM   1810  CG  LEU A 109      -6.037  28.973  -9.055  1.00  0.00           C  
ATOM   1811  CD1 LEU A 109      -7.532  29.223  -9.166  1.00  0.00           C  
ATOM   1812  CD2 LEU A 109      -5.551  28.110 -10.212  1.00  0.00           C  
ATOM   1813  H   LEU A 109      -3.716  32.399  -8.199  1.00  0.00           H  
ATOM   1814  HA  LEU A 109      -4.234  29.656  -7.254  1.00  0.00           H  
ATOM   1815  HB2 LEU A 109      -5.947  31.072  -8.687  1.00  0.00           H  
ATOM   1816  HB3 LEU A 109      -4.943  30.529 -10.017  1.00  0.00           H  
ATOM   1817  HG  LEU A 109      -5.856  28.431  -8.138  1.00  0.00           H  
ATOM   1818 HD11 LEU A 109      -7.987  28.434  -9.747  1.00  0.00           H  
ATOM   1819 HD12 LEU A 109      -7.705  30.171  -9.651  1.00  0.00           H  
ATOM   1820 HD13 LEU A 109      -7.968  29.238  -8.178  1.00  0.00           H  
ATOM   1821 HD21 LEU A 109      -5.969  27.117 -10.117  1.00  0.00           H  
ATOM   1822 HD22 LEU A 109      -4.474  28.050 -10.190  1.00  0.00           H  
ATOM   1823 HD23 LEU A 109      -5.869  28.547 -11.146  1.00  0.00           H  
ATOM   1824  N   GLU A 110      -1.993  29.014  -8.148  1.00  0.00           N  
ATOM   1825  CA  GLU A 110      -0.777  28.454  -8.740  1.00  0.00           C  
ATOM   1826  C   GLU A 110      -1.119  27.488  -9.877  1.00  0.00           C  
ATOM   1827  O   GLU A 110      -0.455  27.478 -10.916  1.00  0.00           O  
ATOM   1828  CB  GLU A 110       0.052  27.741  -7.666  1.00  0.00           C  
ATOM   1829  CG  GLU A 110       1.440  27.331  -8.134  1.00  0.00           C  
ATOM   1830  CD  GLU A 110       2.489  28.386  -7.842  1.00  0.00           C  
ATOM   1831  OE1 GLU A 110       2.965  28.448  -6.689  1.00  0.00           O  
ATOM   1832  OE2 GLU A 110       2.835  29.151  -8.767  1.00  0.00           O  
ATOM   1833  H   GLU A 110      -2.212  28.798  -7.218  1.00  0.00           H  
ATOM   1834  HA  GLU A 110      -0.200  29.272  -9.144  1.00  0.00           H  
ATOM   1835  HB2 GLU A 110       0.162  28.401  -6.818  1.00  0.00           H  
ATOM   1836  HB3 GLU A 110      -0.476  26.853  -7.352  1.00  0.00           H  
ATOM   1837  HG2 GLU A 110       1.721  26.419  -7.630  1.00  0.00           H  
ATOM   1838  HG3 GLU A 110       1.410  27.158  -9.199  1.00  0.00           H  
ATOM   1839  N   HIS A 111      -2.161  26.677  -9.674  1.00  0.00           N  
ATOM   1840  CA  HIS A 111      -2.596  25.712 -10.683  1.00  0.00           C  
ATOM   1841  C   HIS A 111      -4.020  25.234 -10.403  1.00  0.00           C  
ATOM   1842  O   HIS A 111      -4.903  25.362 -11.251  1.00  0.00           O  
ATOM   1843  CB  HIS A 111      -1.638  24.517 -10.731  1.00  0.00           C  
ATOM   1844  CG  HIS A 111      -1.895  23.586 -11.880  1.00  0.00           C  
ATOM   1845  ND1 HIS A 111      -3.037  22.817 -11.986  1.00  0.00           N  
ATOM   1846  CD2 HIS A 111      -1.151  23.306 -12.975  1.00  0.00           C  
ATOM   1847  CE1 HIS A 111      -2.983  22.105 -13.096  1.00  0.00           C  
ATOM   1848  NE2 HIS A 111      -1.850  22.382 -13.715  1.00  0.00           N  
ATOM   1849  H   HIS A 111      -2.653  26.736  -8.828  1.00  0.00           H  
ATOM   1850  HA  HIS A 111      -2.583  26.211 -11.640  1.00  0.00           H  
ATOM   1851  HB2 HIS A 111      -0.624  24.880 -10.822  1.00  0.00           H  
ATOM   1852  HB3 HIS A 111      -1.731  23.952  -9.815  1.00  0.00           H  
ATOM   1853  HD1 HIS A 111      -3.776  22.796 -11.344  1.00  0.00           H  
ATOM   1854  HD2 HIS A 111      -0.187  23.729 -13.220  1.00  0.00           H  
ATOM   1855  HE1 HIS A 111      -3.738  21.414 -13.441  1.00  0.00           H  
ATOM   1856  HE2 HIS A 111      -1.512  21.920 -14.509  1.00  0.00           H  
ATOM   1857  N   HIS A 112      -4.235  24.681  -9.207  1.00  0.00           N  
ATOM   1858  CA  HIS A 112      -5.551  24.183  -8.809  1.00  0.00           C  
ATOM   1859  C   HIS A 112      -5.733  24.277  -7.291  1.00  0.00           C  
ATOM   1860  O   HIS A 112      -6.492  25.114  -6.803  1.00  0.00           O  
ATOM   1861  CB  HIS A 112      -5.738  22.732  -9.269  1.00  0.00           C  
ATOM   1862  CG  HIS A 112      -6.417  22.590 -10.600  1.00  0.00           C  
ATOM   1863  ND1 HIS A 112      -6.370  21.431 -11.345  1.00  0.00           N  
ATOM   1864  CD2 HIS A 112      -7.163  23.464 -11.318  1.00  0.00           C  
ATOM   1865  CE1 HIS A 112      -7.056  21.597 -12.461  1.00  0.00           C  
ATOM   1866  NE2 HIS A 112      -7.548  22.822 -12.469  1.00  0.00           N  
ATOM   1867  H   HIS A 112      -3.487  24.607  -8.575  1.00  0.00           H  
ATOM   1868  HA  HIS A 112      -6.295  24.803  -9.286  1.00  0.00           H  
ATOM   1869  HB2 HIS A 112      -4.773  22.259  -9.340  1.00  0.00           H  
ATOM   1870  HB3 HIS A 112      -6.335  22.208  -8.536  1.00  0.00           H  
ATOM   1871  HD1 HIS A 112      -5.904  20.606 -11.091  1.00  0.00           H  
ATOM   1872  HD2 HIS A 112      -7.408  24.479 -11.039  1.00  0.00           H  
ATOM   1873  HE1 HIS A 112      -7.195  20.855 -13.234  1.00  0.00           H  
ATOM   1874  HE2 HIS A 112      -8.003  23.242 -13.228  1.00  0.00           H  
ATOM   1875  N   HIS A 113      -5.027  23.416  -6.555  1.00  0.00           N  
ATOM   1876  CA  HIS A 113      -5.107  23.398  -5.094  1.00  0.00           C  
ATOM   1877  C   HIS A 113      -3.742  23.694  -4.470  1.00  0.00           C  
ATOM   1878  O   HIS A 113      -2.788  24.039  -5.175  1.00  0.00           O  
ATOM   1879  CB  HIS A 113      -5.621  22.038  -4.613  1.00  0.00           C  
ATOM   1880  CG  HIS A 113      -6.922  22.110  -3.875  1.00  0.00           C  
ATOM   1881  ND1 HIS A 113      -7.019  22.450  -2.542  1.00  0.00           N  
ATOM   1882  CD2 HIS A 113      -8.189  21.883  -4.297  1.00  0.00           C  
ATOM   1883  CE1 HIS A 113      -8.287  22.424  -2.174  1.00  0.00           C  
ATOM   1884  NE2 HIS A 113      -9.017  22.085  -3.220  1.00  0.00           N  
ATOM   1885  H   HIS A 113      -4.437  22.775  -7.004  1.00  0.00           H  
ATOM   1886  HA  HIS A 113      -5.801  24.167  -4.790  1.00  0.00           H  
ATOM   1887  HB2 HIS A 113      -5.759  21.391  -5.465  1.00  0.00           H  
ATOM   1888  HB3 HIS A 113      -4.889  21.597  -3.950  1.00  0.00           H  
ATOM   1889  HD1 HIS A 113      -6.271  22.671  -1.951  1.00  0.00           H  
ATOM   1890  HD2 HIS A 113      -8.491  21.594  -5.293  1.00  0.00           H  
ATOM   1891  HE1 HIS A 113      -8.663  22.645  -1.185  1.00  0.00           H  
ATOM   1892  HE2 HIS A 113      -9.995  22.051  -3.241  1.00  0.00           H  
ATOM   1893  N   HIS A 114      -3.648  23.554  -3.146  1.00  0.00           N  
ATOM   1894  CA  HIS A 114      -2.396  23.803  -2.438  1.00  0.00           C  
ATOM   1895  C   HIS A 114      -2.012  22.607  -1.568  1.00  0.00           C  
ATOM   1896  O   HIS A 114      -0.977  21.976  -1.794  1.00  0.00           O  
ATOM   1897  CB  HIS A 114      -2.505  25.066  -1.583  1.00  0.00           C  
ATOM   1898  CG  HIS A 114      -2.659  26.322  -2.385  1.00  0.00           C  
ATOM   1899  ND1 HIS A 114      -3.850  27.012  -2.489  1.00  0.00           N  
ATOM   1900  CD2 HIS A 114      -1.760  27.019  -3.120  1.00  0.00           C  
ATOM   1901  CE1 HIS A 114      -3.675  28.077  -3.253  1.00  0.00           C  
ATOM   1902  NE2 HIS A 114      -2.416  28.104  -3.648  1.00  0.00           N  
ATOM   1903  H   HIS A 114      -4.436  23.276  -2.636  1.00  0.00           H  
ATOM   1904  HA  HIS A 114      -1.624  23.949  -3.179  1.00  0.00           H  
ATOM   1905  HB2 HIS A 114      -3.361  24.980  -0.930  1.00  0.00           H  
ATOM   1906  HB3 HIS A 114      -1.611  25.162  -0.983  1.00  0.00           H  
ATOM   1907  HD1 HIS A 114      -4.699  26.758  -2.069  1.00  0.00           H  
ATOM   1908  HD2 HIS A 114      -0.718  26.768  -3.267  1.00  0.00           H  
ATOM   1909  HE1 HIS A 114      -4.434  28.805  -3.508  1.00  0.00           H  
ATOM   1910  HE2 HIS A 114      -2.001  28.829  -4.161  1.00  0.00           H  
ATOM   1911  N   HIS A 115      -2.848  22.297  -0.575  1.00  0.00           N  
ATOM   1912  CA  HIS A 115      -2.593  21.176   0.329  1.00  0.00           C  
ATOM   1913  C   HIS A 115      -3.755  20.988   1.301  1.00  0.00           C  
ATOM   1914  O   HIS A 115      -4.274  21.961   1.850  1.00  0.00           O  
ATOM   1915  CB  HIS A 115      -1.289  21.393   1.106  1.00  0.00           C  
ATOM   1916  CG  HIS A 115      -1.225  22.700   1.834  1.00  0.00           C  
ATOM   1917  ND1 HIS A 115      -0.521  23.788   1.366  1.00  0.00           N  
ATOM   1918  CD2 HIS A 115      -1.784  23.089   3.004  1.00  0.00           C  
ATOM   1919  CE1 HIS A 115      -0.646  24.790   2.218  1.00  0.00           C  
ATOM   1920  NE2 HIS A 115      -1.409  24.392   3.221  1.00  0.00           N  
ATOM   1921  H   HIS A 115      -3.656  22.836  -0.443  1.00  0.00           H  
ATOM   1922  HA  HIS A 115      -2.500  20.286  -0.273  1.00  0.00           H  
ATOM   1923  HB2 HIS A 115      -1.175  20.603   1.831  1.00  0.00           H  
ATOM   1924  HB3 HIS A 115      -0.461  21.359   0.412  1.00  0.00           H  
ATOM   1925  HD1 HIS A 115      -0.008  23.822   0.533  1.00  0.00           H  
ATOM   1926  HD2 HIS A 115      -2.409  22.487   3.648  1.00  0.00           H  
ATOM   1927  HE1 HIS A 115      -0.198  25.767   2.114  1.00  0.00           H  
ATOM   1928  HE2 HIS A 115      -1.802  24.986   3.894  1.00  0.00           H  
ATOM   1929  N   HIS A 116      -4.155  19.728   1.504  1.00  0.00           N  
ATOM   1930  CA  HIS A 116      -5.256  19.391   2.406  1.00  0.00           C  
ATOM   1931  C   HIS A 116      -6.579  19.977   1.897  1.00  0.00           C  
ATOM   1932  O   HIS A 116      -7.330  19.234   1.236  1.00  0.00           O  
ATOM   1933  CB  HIS A 116      -4.951  19.876   3.830  1.00  0.00           C  
ATOM   1934  CG  HIS A 116      -4.234  18.861   4.669  1.00  0.00           C  
ATOM   1935  ND1 HIS A 116      -4.850  18.137   5.664  1.00  0.00           N  
ATOM   1936  CD2 HIS A 116      -2.942  18.451   4.654  1.00  0.00           C  
ATOM   1937  CE1 HIS A 116      -3.973  17.324   6.226  1.00  0.00           C  
ATOM   1938  NE2 HIS A 116      -2.807  17.492   5.631  1.00  0.00           N  
ATOM   1939  OXT HIS A 116      -6.847  21.170   2.154  1.00  0.00           O  
ATOM   1940  H   HIS A 116      -3.694  19.002   1.031  1.00  0.00           H  
ATOM   1941  HA  HIS A 116      -5.346  18.314   2.419  1.00  0.00           H  
ATOM   1942  HB2 HIS A 116      -4.336  20.759   3.779  1.00  0.00           H  
ATOM   1943  HB3 HIS A 116      -5.880  20.121   4.327  1.00  0.00           H  
ATOM   1944  HD1 HIS A 116      -5.796  18.204   5.921  1.00  0.00           H  
ATOM   1945  HD2 HIS A 116      -2.162  18.807   3.994  1.00  0.00           H  
ATOM   1946  HE1 HIS A 116      -4.179  16.632   7.030  1.00  0.00           H  
ATOM   1947  HE2 HIS A 116      -2.018  16.929   5.767  1.00  0.00           H  
TER    1948      HIS A 116                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
