
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 2229),  selected  138 , name 2yw5_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 2yw5_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    18_A      S       1           -
LGA    S    19_A      M       2           -
LGA    S    20_A      Q       3           -
LGA    G    21_A      E       4           -
LGA    S    22_A      -       -           -
LGA    S    23_A      -       -           -
LGA    G    24_A      -       -           -
LGA    E    25_A      -       -           -
LGA    V    26_A      -       -           -
LGA    S    27_A      -       -           -
LGA    N    28_A      -       -           -
LGA    P    29_A      -       -           -
LGA    S    30_A      -       -           -
LGA    K    31_A      -       -           -
LGA    P    32_A      -       -           -
LGA    G    33_A      -       -           -
LGA    R    34_A      E       5          5.261
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    K    35_A      F       8          3.478
LGA    T    36_A      R       9          3.158
LGA    N    37_A      E      10          2.548
LGA    Q    38_A      L      11          2.787
LGA    L    39_A      R      12          2.935
LGA    Q    40_A      I      13          2.248
LGA    Y    41_A      F      14          1.798
LGA    M    42_A      L      15          1.808
LGA    Q    43_A      R      16          1.266
LGA    N    44_A      N      17          1.337
LGA    V    45_A      V      18          2.856
LGA    V    46_A      -       -           -
LGA    V    47_A      T      19          0.990
LGA    K    48_A      H      20          2.312
LGA    T    49_A      R      21          1.738
LGA    L    50_A      L      22          0.878
LGA    W    51_A      A      23          1.463
LGA    K    52_A      I      24          2.136
LGA    H    53_A      D      25          0.951
LGA    Q    54_A      K      26          1.592
LGA    F    55_A      R      27          1.540
LGA    A    56_A      F      28          2.355
LGA    W    57_A      R      29          1.638
LGA    P    58_A      V      30          1.495
LGA    F    59_A      F      31          1.613
LGA    Y    60_A      T      32          1.760
LGA    Q    61_A      K      33          1.248
LGA    P    62_A      P      34          0.864
LGA    V    63_A      V      35          0.965
LGA    D    64_A      D      36          1.874
LGA    A    65_A      P      37          1.819
LGA    I    66_A      D      38          2.221
LGA    K    67_A      -       -           -
LGA    L    68_A      E      39          1.307
LGA    N    69_A      V      40          3.478
LGA    L    70_A      P      41          2.356
LGA    P    71_A      -       -           -
LGA    D    72_A      D      42          2.519
LGA    Y    73_A      Y      43          1.809
LGA    H    74_A      V      44          2.960
LGA    K    75_A      T      45          3.072
LGA    I    76_A      V      46          2.125
LGA    I    77_A      I      47          1.080
LGA    K    78_A      K      48          2.387
LGA    N    79_A      Q      49          1.368
LGA    P    80_A      P      50          0.876
LGA    M    81_A      M      51          0.580
LGA    D    82_A      D      52          0.654
LGA    M    83_A      L      53          0.800
LGA    G    84_A      S      54          0.977
LGA    T    85_A      S      55          0.513
LGA    I    86_A      V      56          0.423
LGA    K    87_A      I      57          1.055
LGA    K    88_A      S      58          1.324
LGA    R    89_A      K      59          1.484
LGA    L    90_A      I      60          1.417
LGA    E    91_A      D      61          2.674
LGA    N    92_A      L      62          3.307
LGA    N    93_A      H      63          2.109
LGA    Y    94_A      K      64          2.584
LGA    Y    95_A      Y      65          3.279
LGA    W    96_A      L      66          2.079
LGA    S    97_A      T      67          1.851
LGA    A    98_A      V      68          2.157
LGA    S    99_A      K      69          1.453
LGA    E   100_A      D      70          1.002
LGA    C   101_A      Y      71          1.057
LGA    M   102_A      L      72          0.817
LGA    Q   103_A      R      73          0.419
LGA    D   104_A      D      74          0.489
LGA    F   105_A      I      75          0.409
LGA    N   106_A      D      76          0.363
LGA    T   107_A      L      77          0.515
LGA    M   108_A      I      78          0.627
LGA    F   109_A      C      79          0.516
LGA    T   110_A      S      80          0.319
LGA    N   111_A      N      81          0.612
LGA    C   112_A      A      82          0.660
LGA    Y   113_A      L      83          0.273
LGA    I   114_A      E      84          0.304
LGA    Y   115_A      Y      85          0.722
LGA    N   116_A      N      86          0.364
LGA    K   117_A      P      87          2.714
LGA    -       -      D      88           -
LGA    P   118_A      R      89          5.547
LGA    T   119_A      D      90          5.146
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    -       -      D      93           -
LGA    D   120_A      R      94          3.079
LGA    D   121_A      L      95          2.255
LGA    I   122_A      I      96          1.679
LGA    V   123_A      R      97          1.464
LGA    L   124_A      H      98          1.786
LGA    M   125_A      R      99          1.512
LGA    A   126_A      A     100          1.037
LGA    Q   127_A      C     101          1.842
LGA    A   128_A      A     102          2.030
LGA    L   129_A      L     103          1.622
LGA    E   130_A      R     104          1.674
LGA    K   131_A      D     105          1.773
LGA    I   132_A      T     106          1.034
LGA    F   133_A      A     107          1.128
LGA    L   134_A      Y     108          1.507
LGA    Q   135_A      A     109          0.786
LGA    K   136_A      I     110          0.771
LGA    V   137_A      I     111          1.442
LGA    A   138_A      K     112          1.036
LGA    Q   139_A      E     113          1.740
LGA    M   140_A      E     114          3.686
LGA    P   141_A      L     115          2.883
LGA    -       -      D     116           -
LGA    Q   142_A      E     117          1.841
LGA    E   143_A      D     118          2.346
LGA    E   144_A      F     119          2.858
LGA    V   145_A      E     120           -
LGA    E   146_A      Q     121           -
LGA    L   147_A      L     122           -
LGA    L   148_A      C     123           -
LGA    P   149_A      E     124           -
LGA    P   150_A      E     125           -
LGA    A   151_A      I     126           -
LGA    P   152_A      Q     127           -
LGA    K   153_A      E     128           -
LGA    G   154_A      S     129           -
LGA    K   155_A      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  130    5.0    108    2.02    21.30     72.751     5.104

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.359583 * X  +   0.748483 * Y  +   0.557201 * Z  + -10.023287
  Y_new =  -0.706072 * X  +   0.608653 * Y  +  -0.361943 * Z  +  45.187653
  Z_new =  -0.610051 * X  +  -0.263276 * Y  +   0.747345 * Z  +   0.199778 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.338706    2.802886  [ DEG:   -19.4064    160.5936 ]
  Theta =   0.656125    2.485468  [ DEG:    37.5932    142.4068 ]
  Phi   =  -1.099759    2.041834  [ DEG:   -63.0115    116.9885 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2yw5_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2yw5_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  130   5.0  108   2.02   21.30  72.751
REMARK  ---------------------------------------------------------- 
MOLECULE 2yw5_A
HEADER    SIGNALING PROTEIN                       19-APR-07   2YW5              
TITLE     SOLUTION STRUCTURE OF THE BROMODOMAIN FROM HUMAN                      
TITLE    2 BROMODOMAIN CONTAINING PROTEIN 3                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 3;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: UNP RESIDUES 25-155, BROMODOMAIN;                          
COMPND   5 SYNONYM: RING3-LIKE PROTEIN;                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: BRD3, KIAA0043, RING3L;                                        
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060731-10;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    BROMODOMAIN, STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT            
KEYWDS   2 ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN                 
KEYWDS   3 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, SIGNALING           
KEYWDS   4 PROTEIN                                                              
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.FURUE,S.SUZUKI,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,                    
AUTHOR   2 M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   22-APR-08 2YW5    0                                                
JRNL        AUTH   M.FURUE,S.SUZUKI,Y.MUTO,M.INOUE,T.KIGAWA,T.TERADA,           
JRNL        AUTH 2 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   SOLUTION STRUCTURE OF THE BROMODOMAIN FROM HUMAN             
JRNL        TITL 2 BROMODOMAIN CONTAINING PROTEIN 3                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YW5 A   25   155  UNP    Q15059   BRD3_HUMAN      25    155             
SEQRES   1 A  138  GLY SER SER GLY SER SER GLY GLU VAL SER ASN PRO SER          
SEQRES   2 A  138  LYS PRO GLY ARG LYS THR ASN GLN LEU GLN TYR MET GLN          
SEQRES   3 A  138  ASN VAL VAL VAL LYS THR LEU TRP LYS HIS GLN PHE ALA          
SEQRES   4 A  138  TRP PRO PHE TYR GLN PRO VAL ASP ALA ILE LYS LEU ASN          
SEQRES   5 A  138  LEU PRO ASP TYR HIS LYS ILE ILE LYS ASN PRO MET ASP          
SEQRES   6 A  138  MET GLY THR ILE LYS LYS ARG LEU GLU ASN ASN TYR TYR          
SEQRES   7 A  138  TRP SER ALA SER GLU CYS MET GLN ASP PHE ASN THR MET          
SEQRES   8 A  138  PHE THR ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP          
SEQRES   9 A  138  ILE VAL LEU MET ALA GLN ALA LEU GLU LYS ILE PHE LEU          
SEQRES  10 A  138  GLN LYS VAL ALA GLN MET PRO GLN GLU GLU VAL GLU LEU          
SEQRES  11 A  138  LEU PRO PRO ALA PRO LYS GLY LYS                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  18      -4.486  50.793  24.859  1.00  0.00           N  
ATOM      2  CA  GLY A  18      -5.388  51.648  24.061  1.00  0.00           C  
ATOM      3  C   GLY A  18      -6.808  51.112  24.084  1.00  0.00           C  
ATOM      4  O   GLY A  18      -7.051  49.982  23.653  1.00  0.00           O  
ATOM      5  H1  GLY A  18      -4.780  50.777  25.822  1.00  0.00           H  
ATOM      6  H2  GLY A  18      -4.495  49.851  24.500  1.00  0.00           H  
ATOM      7  H3  GLY A  18      -3.543  51.148  24.813  1.00  0.00           H  
ATOM      8  HA2 GLY A  18      -5.377  52.663  24.458  1.00  0.00           H  
ATOM      9  HA3 GLY A  18      -5.046  51.669  23.026  1.00  0.00           H  
ATOM     10  N   SER A  19      -7.756  51.900  24.599  1.00  0.00           N  
ATOM     11  CA  SER A  19      -9.191  51.564  24.642  1.00  0.00           C  
ATOM     12  C   SER A  19      -9.856  51.538  23.251  1.00  0.00           C  
ATOM     13  O   SER A  19      -9.394  52.183  22.303  1.00  0.00           O  
ATOM     14  CB  SER A  19      -9.928  52.552  25.561  1.00  0.00           C  
ATOM     15  OG  SER A  19      -9.695  53.898  25.173  1.00  0.00           O  
ATOM     16  H   SER A  19      -7.501  52.829  24.907  1.00  0.00           H  
ATOM     17  HA  SER A  19      -9.301  50.570  25.077  1.00  0.00           H  
ATOM     18  HB2 SER A  19     -10.999  52.343  25.538  1.00  0.00           H  
ATOM     19  HB3 SER A  19      -9.572  52.410  26.582  1.00  0.00           H  
ATOM     20  HG  SER A  19     -10.179  54.474  25.785  1.00  0.00           H  
ATOM     21  N   SER A  20     -10.962  50.796  23.126  1.00  0.00           N  
ATOM     22  CA  SER A  20     -11.767  50.705  21.896  1.00  0.00           C  
ATOM     23  C   SER A  20     -12.481  52.028  21.571  1.00  0.00           C  
ATOM     24  O   SER A  20     -13.104  52.639  22.444  1.00  0.00           O  
ATOM     25  CB  SER A  20     -12.818  49.594  22.029  1.00  0.00           C  
ATOM     26  OG  SER A  20     -12.195  48.346  22.290  1.00  0.00           O  
ATOM     27  H   SER A  20     -11.275  50.263  23.925  1.00  0.00           H  
ATOM     28  HA  SER A  20     -11.110  50.449  21.064  1.00  0.00           H  
ATOM     29  HB2 SER A  20     -13.504  49.835  22.843  1.00  0.00           H  
ATOM     30  HB3 SER A  20     -13.387  49.526  21.100  1.00  0.00           H  
ATOM     31  HG  SER A  20     -12.887  47.668  22.329  1.00  0.00           H  
ATOM     32  N   GLY A  21     -12.425  52.453  20.306  1.00  0.00           N  
ATOM     33  CA  GLY A  21     -13.063  53.690  19.824  1.00  0.00           C  
ATOM     34  C   GLY A  21     -12.791  54.027  18.350  1.00  0.00           C  
ATOM     35  O   GLY A  21     -12.779  55.206  17.986  1.00  0.00           O  
ATOM     36  H   GLY A  21     -11.851  51.928  19.660  1.00  0.00           H  
ATOM     37  HA2 GLY A  21     -14.143  53.594  19.948  1.00  0.00           H  
ATOM     38  HA3 GLY A  21     -12.722  54.528  20.433  1.00  0.00           H  
ATOM     39  N   SER A  22     -12.541  53.011  17.514  1.00  0.00           N  
ATOM     40  CA  SER A  22     -12.055  53.143  16.127  1.00  0.00           C  
ATOM     41  C   SER A  22     -12.629  52.049  15.210  1.00  0.00           C  
ATOM     42  O   SER A  22     -13.216  51.073  15.684  1.00  0.00           O  
ATOM     43  CB  SER A  22     -10.517  53.052  16.103  1.00  0.00           C  
ATOM     44  OG  SER A  22      -9.914  54.070  16.886  1.00  0.00           O  
ATOM     45  H   SER A  22     -12.670  52.073  17.861  1.00  0.00           H  
ATOM     46  HA  SER A  22     -12.350  54.111  15.719  1.00  0.00           H  
ATOM     47  HB2 SER A  22     -10.210  52.076  16.484  1.00  0.00           H  
ATOM     48  HB3 SER A  22     -10.163  53.147  15.075  1.00  0.00           H  
ATOM     49  HG  SER A  22      -8.954  53.959  16.837  1.00  0.00           H  
ATOM     50  N   SER A  23     -12.421  52.190  13.893  1.00  0.00           N  
ATOM     51  CA  SER A  23     -12.858  51.240  12.845  1.00  0.00           C  
ATOM     52  C   SER A  23     -11.704  50.808  11.916  1.00  0.00           C  
ATOM     53  O   SER A  23     -11.927  50.395  10.774  1.00  0.00           O  
ATOM     54  CB  SER A  23     -14.022  51.839  12.037  1.00  0.00           C  
ATOM     55  OG  SER A  23     -15.126  52.147  12.874  1.00  0.00           O  
ATOM     56  H   SER A  23     -11.949  53.030  13.584  1.00  0.00           H  
ATOM     57  HA  SER A  23     -13.220  50.327  13.315  1.00  0.00           H  
ATOM     58  HB2 SER A  23     -13.684  52.744  11.529  1.00  0.00           H  
ATOM     59  HB3 SER A  23     -14.348  51.118  11.285  1.00  0.00           H  
ATOM     60  HG  SER A  23     -14.842  52.828  13.498  1.00  0.00           H  
ATOM     61  N   GLY A  24     -10.458  50.928  12.387  1.00  0.00           N  
ATOM     62  CA  GLY A  24      -9.236  50.680  11.609  1.00  0.00           C  
ATOM     63  C   GLY A  24      -8.795  51.885  10.766  1.00  0.00           C  
ATOM     64  O   GLY A  24      -9.344  52.983  10.886  1.00  0.00           O  
ATOM     65  H   GLY A  24     -10.347  51.264  13.331  1.00  0.00           H  
ATOM     66  HA2 GLY A  24      -8.423  50.426  12.290  1.00  0.00           H  
ATOM     67  HA3 GLY A  24      -9.391  49.827  10.949  1.00  0.00           H  
ATOM     68  N   GLU A  25      -7.792  51.681   9.906  1.00  0.00           N  
ATOM     69  CA  GLU A  25      -7.181  52.723   9.064  1.00  0.00           C  
ATOM     70  C   GLU A  25      -7.156  52.324   7.577  1.00  0.00           C  
ATOM     71  O   GLU A  25      -7.552  51.211   7.209  1.00  0.00           O  
ATOM     72  CB  GLU A  25      -5.755  53.051   9.554  1.00  0.00           C  
ATOM     73  CG  GLU A  25      -5.614  53.162  11.076  1.00  0.00           C  
ATOM     74  CD  GLU A  25      -4.307  53.860  11.502  1.00  0.00           C  
ATOM     75  OE1 GLU A  25      -4.223  55.109  11.403  1.00  0.00           O  
ATOM     76  OE2 GLU A  25      -3.365  53.169  11.964  1.00  0.00           O  
ATOM     77  H   GLU A  25      -7.358  50.771   9.878  1.00  0.00           H  
ATOM     78  HA  GLU A  25      -7.768  53.640   9.136  1.00  0.00           H  
ATOM     79  HB2 GLU A  25      -5.073  52.282   9.204  1.00  0.00           H  
ATOM     80  HB3 GLU A  25      -5.457  53.992   9.100  1.00  0.00           H  
ATOM     81  HG2 GLU A  25      -6.462  53.722  11.473  1.00  0.00           H  
ATOM     82  HG3 GLU A  25      -5.638  52.150  11.484  1.00  0.00           H  
ATOM     83  N   VAL A  26      -6.687  53.236   6.717  1.00  0.00           N  
ATOM     84  CA  VAL A  26      -6.729  53.099   5.243  1.00  0.00           C  
ATOM     85  C   VAL A  26      -5.360  53.215   4.573  1.00  0.00           C  
ATOM     86  O   VAL A  26      -5.188  52.810   3.429  1.00  0.00           O  
ATOM     87  CB  VAL A  26      -7.710  54.107   4.616  1.00  0.00           C  
ATOM     88  CG1 VAL A  26      -9.094  53.936   5.245  1.00  0.00           C  
ATOM     89  CG2 VAL A  26      -7.285  55.574   4.786  1.00  0.00           C  
ATOM     90  H   VAL A  26      -6.427  54.137   7.095  1.00  0.00           H  
ATOM     91  HA  VAL A  26      -7.093  52.106   5.001  1.00  0.00           H  
ATOM     92  HB  VAL A  26      -7.794  53.894   3.550  1.00  0.00           H  
ATOM     93 HG11 VAL A  26      -9.422  52.904   5.113  1.00  0.00           H  
ATOM     94 HG12 VAL A  26      -9.052  54.175   6.306  1.00  0.00           H  
ATOM     95 HG13 VAL A  26      -9.799  54.612   4.771  1.00  0.00           H  
ATOM     96 HG21 VAL A  26      -7.204  55.830   5.841  1.00  0.00           H  
ATOM     97 HG22 VAL A  26      -6.326  55.753   4.298  1.00  0.00           H  
ATOM     98 HG23 VAL A  26      -8.027  56.224   4.323  1.00  0.00           H  
ATOM     99  N   SER A  27      -4.374  53.727   5.299  1.00  0.00           N  
ATOM    100  CA  SER A  27      -2.950  53.729   4.936  1.00  0.00           C  
ATOM    101  C   SER A  27      -2.104  53.713   6.216  1.00  0.00           C  
ATOM    102  O   SER A  27      -2.612  54.020   7.300  1.00  0.00           O  
ATOM    103  CB  SER A  27      -2.628  54.953   4.073  1.00  0.00           C  
ATOM    104  OG  SER A  27      -1.337  54.816   3.504  1.00  0.00           O  
ATOM    105  H   SER A  27      -4.616  54.049   6.226  1.00  0.00           H  
ATOM    106  HA  SER A  27      -2.723  52.831   4.361  1.00  0.00           H  
ATOM    107  HB2 SER A  27      -3.360  55.029   3.269  1.00  0.00           H  
ATOM    108  HB3 SER A  27      -2.679  55.859   4.682  1.00  0.00           H  
ATOM    109  HG  SER A  27      -1.167  55.597   2.956  1.00  0.00           H  
ATOM    110  N   ASN A  28      -0.832  53.316   6.125  1.00  0.00           N  
ATOM    111  CA  ASN A  28       0.055  53.194   7.286  1.00  0.00           C  
ATOM    112  C   ASN A  28       1.543  53.319   6.884  1.00  0.00           C  
ATOM    113  O   ASN A  28       2.012  52.527   6.062  1.00  0.00           O  
ATOM    114  CB  ASN A  28      -0.245  51.857   8.003  1.00  0.00           C  
ATOM    115  CG  ASN A  28      -0.588  52.050   9.467  1.00  0.00           C  
ATOM    116  OD1 ASN A  28       0.125  51.623  10.365  1.00  0.00           O  
ATOM    117  ND2 ASN A  28      -1.687  52.718   9.728  1.00  0.00           N  
ATOM    118  H   ASN A  28      -0.455  53.115   5.208  1.00  0.00           H  
ATOM    119  HA  ASN A  28      -0.192  54.008   7.968  1.00  0.00           H  
ATOM    120  HB2 ASN A  28      -1.095  51.373   7.536  1.00  0.00           H  
ATOM    121  HB3 ASN A  28       0.585  51.162   7.921  1.00  0.00           H  
ATOM    122 HD21 ASN A  28      -2.206  53.129   8.961  1.00  0.00           H  
ATOM    123 HD22 ASN A  28      -2.014  52.820  10.688  1.00  0.00           H  
ATOM    124  N   PRO A  29       2.295  54.291   7.439  1.00  0.00           N  
ATOM    125  CA  PRO A  29       3.711  54.496   7.121  1.00  0.00           C  
ATOM    126  C   PRO A  29       4.656  53.556   7.896  1.00  0.00           C  
ATOM    127  O   PRO A  29       5.742  53.239   7.406  1.00  0.00           O  
ATOM    128  CB  PRO A  29       3.976  55.961   7.487  1.00  0.00           C  
ATOM    129  CG  PRO A  29       3.025  56.215   8.656  1.00  0.00           C  
ATOM    130  CD  PRO A  29       1.811  55.355   8.310  1.00  0.00           C  
ATOM    131  HA  PRO A  29       3.886  54.358   6.052  1.00  0.00           H  
ATOM    132  HB2 PRO A  29       5.017  56.140   7.764  1.00  0.00           H  
ATOM    133  HB3 PRO A  29       3.696  56.599   6.647  1.00  0.00           H  
ATOM    134  HG2 PRO A  29       3.472  55.862   9.585  1.00  0.00           H  
ATOM    135  HG3 PRO A  29       2.757  57.269   8.737  1.00  0.00           H  
ATOM    136  HD2 PRO A  29       1.365  54.944   9.216  1.00  0.00           H  
ATOM    137  HD3 PRO A  29       1.078  55.954   7.770  1.00  0.00           H  
ATOM    138  N   SER A  30       4.265  53.114   9.099  1.00  0.00           N  
ATOM    139  CA  SER A  30       5.088  52.261   9.972  1.00  0.00           C  
ATOM    140  C   SER A  30       5.092  50.793   9.516  1.00  0.00           C  
ATOM    141  O   SER A  30       6.152  50.165   9.425  1.00  0.00           O  
ATOM    142  CB  SER A  30       4.571  52.367  11.413  1.00  0.00           C  
ATOM    143  OG  SER A  30       5.430  51.683  12.310  1.00  0.00           O  
ATOM    144  H   SER A  30       3.368  53.428   9.444  1.00  0.00           H  
ATOM    145  HA  SER A  30       6.116  52.623   9.955  1.00  0.00           H  
ATOM    146  HB2 SER A  30       4.529  53.420  11.698  1.00  0.00           H  
ATOM    147  HB3 SER A  30       3.565  51.949  11.476  1.00  0.00           H  
ATOM    148  HG  SER A  30       5.085  51.804  13.207  1.00  0.00           H  
ATOM    149  N   LYS A  31       3.912  50.252   9.176  1.00  0.00           N  
ATOM    150  CA  LYS A  31       3.744  48.901   8.615  1.00  0.00           C  
ATOM    151  C   LYS A  31       4.235  48.861   7.154  1.00  0.00           C  
ATOM    152  O   LYS A  31       3.878  49.761   6.386  1.00  0.00           O  
ATOM    153  CB  LYS A  31       2.257  48.516   8.714  1.00  0.00           C  
ATOM    154  CG  LYS A  31       2.022  47.004   8.580  1.00  0.00           C  
ATOM    155  CD  LYS A  31       0.522  46.688   8.687  1.00  0.00           C  
ATOM    156  CE  LYS A  31       0.236  45.199   8.922  1.00  0.00           C  
ATOM    157  NZ  LYS A  31       0.703  44.336   7.810  1.00  0.00           N  
ATOM    158  H   LYS A  31       3.093  50.838   9.257  1.00  0.00           H  
ATOM    159  HA  LYS A  31       4.328  48.210   9.221  1.00  0.00           H  
ATOM    160  HB2 LYS A  31       1.881  48.827   9.689  1.00  0.00           H  
ATOM    161  HB3 LYS A  31       1.693  49.038   7.942  1.00  0.00           H  
ATOM    162  HG2 LYS A  31       2.397  46.654   7.618  1.00  0.00           H  
ATOM    163  HG3 LYS A  31       2.558  46.493   9.381  1.00  0.00           H  
ATOM    164  HD2 LYS A  31       0.103  47.237   9.531  1.00  0.00           H  
ATOM    165  HD3 LYS A  31       0.013  47.022   7.782  1.00  0.00           H  
ATOM    166  HE2 LYS A  31       0.713  44.887   9.857  1.00  0.00           H  
ATOM    167  HE3 LYS A  31      -0.842  45.073   9.046  1.00  0.00           H  
ATOM    168  HZ1 LYS A  31       0.363  44.668   6.921  1.00  0.00           H  
ATOM    169  HZ2 LYS A  31       1.712  44.285   7.774  1.00  0.00           H  
ATOM    170  HZ3 LYS A  31       0.341  43.389   7.942  1.00  0.00           H  
ATOM    171  N   PRO A  32       5.030  47.857   6.734  1.00  0.00           N  
ATOM    172  CA  PRO A  32       5.484  47.754   5.349  1.00  0.00           C  
ATOM    173  C   PRO A  32       4.341  47.367   4.400  1.00  0.00           C  
ATOM    174  O   PRO A  32       3.438  46.603   4.753  1.00  0.00           O  
ATOM    175  CB  PRO A  32       6.598  46.705   5.356  1.00  0.00           C  
ATOM    176  CG  PRO A  32       6.265  45.824   6.561  1.00  0.00           C  
ATOM    177  CD  PRO A  32       5.585  46.781   7.540  1.00  0.00           C  
ATOM    178  HA  PRO A  32       5.903  48.708   5.025  1.00  0.00           H  
ATOM    179  HB2 PRO A  32       6.634  46.126   4.432  1.00  0.00           H  
ATOM    180  HB3 PRO A  32       7.549  47.212   5.513  1.00  0.00           H  
ATOM    181  HG2 PRO A  32       5.556  45.050   6.260  1.00  0.00           H  
ATOM    182  HG3 PRO A  32       7.160  45.374   6.991  1.00  0.00           H  
ATOM    183  HD2 PRO A  32       4.809  46.254   8.096  1.00  0.00           H  
ATOM    184  HD3 PRO A  32       6.321  47.196   8.231  1.00  0.00           H  
ATOM    185  N   GLY A  33       4.411  47.868   3.167  1.00  0.00           N  
ATOM    186  CA  GLY A  33       3.426  47.575   2.124  1.00  0.00           C  
ATOM    187  C   GLY A  33       3.680  48.276   0.790  1.00  0.00           C  
ATOM    188  O   GLY A  33       4.246  49.373   0.745  1.00  0.00           O  
ATOM    189  H   GLY A  33       5.189  48.474   2.942  1.00  0.00           H  
ATOM    190  HA2 GLY A  33       3.412  46.502   1.951  1.00  0.00           H  
ATOM    191  HA3 GLY A  33       2.438  47.877   2.475  1.00  0.00           H  
ATOM    192  N   ARG A  34       3.247  47.628  -0.298  1.00  0.00           N  
ATOM    193  CA  ARG A  34       3.282  48.113  -1.688  1.00  0.00           C  
ATOM    194  C   ARG A  34       2.304  47.316  -2.565  1.00  0.00           C  
ATOM    195  O   ARG A  34       1.829  46.254  -2.159  1.00  0.00           O  
ATOM    196  CB  ARG A  34       4.721  48.031  -2.229  1.00  0.00           C  
ATOM    197  CG  ARG A  34       5.241  46.595  -2.386  1.00  0.00           C  
ATOM    198  CD  ARG A  34       6.737  46.624  -2.702  1.00  0.00           C  
ATOM    199  NE  ARG A  34       7.122  45.451  -3.487  1.00  0.00           N  
ATOM    200  CZ  ARG A  34       8.333  45.012  -3.758  1.00  0.00           C  
ATOM    201  NH1 ARG A  34       9.410  45.513  -3.220  1.00  0.00           N  
ATOM    202  NH2 ARG A  34       8.464  44.046  -4.615  1.00  0.00           N  
ATOM    203  H   ARG A  34       2.808  46.726  -0.161  1.00  0.00           H  
ATOM    204  HA  ARG A  34       2.967  49.156  -1.710  1.00  0.00           H  
ATOM    205  HB2 ARG A  34       4.761  48.525  -3.202  1.00  0.00           H  
ATOM    206  HB3 ARG A  34       5.384  48.580  -1.559  1.00  0.00           H  
ATOM    207  HG2 ARG A  34       5.084  46.023  -1.472  1.00  0.00           H  
ATOM    208  HG3 ARG A  34       4.697  46.110  -3.199  1.00  0.00           H  
ATOM    209  HD2 ARG A  34       6.961  47.511  -3.294  1.00  0.00           H  
ATOM    210  HD3 ARG A  34       7.292  46.663  -1.765  1.00  0.00           H  
ATOM    211  HE  ARG A  34       6.388  45.040  -4.059  1.00  0.00           H  
ATOM    212 HH11 ARG A  34       9.321  46.264  -2.558  1.00  0.00           H  
ATOM    213 HH12 ARG A  34      10.318  45.155  -3.466  1.00  0.00           H  
ATOM    214 HH21 ARG A  34       7.622  43.760  -5.106  1.00  0.00           H  
ATOM    215 HH22 ARG A  34       9.370  43.687  -4.865  1.00  0.00           H  
ATOM    216  N   LYS A  35       2.016  47.807  -3.772  1.00  0.00           N  
ATOM    217  CA  LYS A  35       1.065  47.225  -4.717  1.00  0.00           C  
ATOM    218  C   LYS A  35       1.595  45.917  -5.333  1.00  0.00           C  
ATOM    219  O   LYS A  35       2.586  45.927  -6.065  1.00  0.00           O  
ATOM    220  CB  LYS A  35       0.803  48.304  -5.781  1.00  0.00           C  
ATOM    221  CG  LYS A  35      -0.408  48.016  -6.666  1.00  0.00           C  
ATOM    222  CD  LYS A  35      -1.769  48.467  -6.120  1.00  0.00           C  
ATOM    223  CE  LYS A  35      -2.442  47.453  -5.188  1.00  0.00           C  
ATOM    224  NZ  LYS A  35      -2.819  46.202  -5.890  1.00  0.00           N  
ATOM    225  H   LYS A  35       2.439  48.676  -4.056  1.00  0.00           H  
ATOM    226  HA  LYS A  35       0.142  47.011  -4.182  1.00  0.00           H  
ATOM    227  HB2 LYS A  35       0.668  49.277  -5.308  1.00  0.00           H  
ATOM    228  HB3 LYS A  35       1.682  48.369  -6.426  1.00  0.00           H  
ATOM    229  HG2 LYS A  35      -0.239  48.544  -7.602  1.00  0.00           H  
ATOM    230  HG3 LYS A  35      -0.433  46.952  -6.857  1.00  0.00           H  
ATOM    231  HD2 LYS A  35      -1.656  49.416  -5.595  1.00  0.00           H  
ATOM    232  HD3 LYS A  35      -2.438  48.644  -6.966  1.00  0.00           H  
ATOM    233  HE2 LYS A  35      -1.791  47.235  -4.342  1.00  0.00           H  
ATOM    234  HE3 LYS A  35      -3.349  47.920  -4.797  1.00  0.00           H  
ATOM    235  HZ1 LYS A  35      -3.193  46.400  -6.817  1.00  0.00           H  
ATOM    236  HZ2 LYS A  35      -2.052  45.552  -5.987  1.00  0.00           H  
ATOM    237  HZ3 LYS A  35      -3.588  45.764  -5.391  1.00  0.00           H  
ATOM    238  N   THR A  36       0.903  44.804  -5.084  1.00  0.00           N  
ATOM    239  CA  THR A  36       1.269  43.458  -5.576  1.00  0.00           C  
ATOM    240  C   THR A  36       0.115  42.784  -6.309  1.00  0.00           C  
ATOM    241  O   THR A  36      -1.046  43.177  -6.175  1.00  0.00           O  
ATOM    242  CB  THR A  36       1.727  42.541  -4.427  1.00  0.00           C  
ATOM    243  OG1 THR A  36       0.691  42.410  -3.469  1.00  0.00           O  
ATOM    244  CG2 THR A  36       3.011  43.063  -3.785  1.00  0.00           C  
ATOM    245  H   THR A  36       0.136  44.856  -4.432  1.00  0.00           H  
ATOM    246  HA  THR A  36       2.093  43.534  -6.284  1.00  0.00           H  
ATOM    247  HB  THR A  36       1.944  41.554  -4.833  1.00  0.00           H  
ATOM    248  HG1 THR A  36       1.070  42.084  -2.637  1.00  0.00           H  
ATOM    249 HG21 THR A  36       3.745  43.266  -4.571  1.00  0.00           H  
ATOM    250 HG22 THR A  36       2.825  43.985  -3.233  1.00  0.00           H  
ATOM    251 HG23 THR A  36       3.413  42.310  -3.108  1.00  0.00           H  
ATOM    252  N   ASN A  37       0.439  41.741  -7.078  1.00  0.00           N  
ATOM    253  CA  ASN A  37      -0.514  40.877  -7.779  1.00  0.00           C  
ATOM    254  C   ASN A  37      -1.554  40.225  -6.850  1.00  0.00           C  
ATOM    255  O   ASN A  37      -2.716  40.080  -7.226  1.00  0.00           O  
ATOM    256  CB  ASN A  37       0.349  39.827  -8.489  1.00  0.00           C  
ATOM    257  CG  ASN A  37      -0.395  38.661  -9.116  1.00  0.00           C  
ATOM    258  OD1 ASN A  37      -1.161  38.803 -10.058  1.00  0.00           O  
ATOM    259  ND2 ASN A  37      -0.122  37.461  -8.646  1.00  0.00           N  
ATOM    260  H   ASN A  37       1.426  41.500  -7.175  1.00  0.00           H  
ATOM    261  HA  ASN A  37      -1.062  41.469  -8.514  1.00  0.00           H  
ATOM    262  HB2 ASN A  37       0.922  40.318  -9.274  1.00  0.00           H  
ATOM    263  HB3 ASN A  37       1.052  39.423  -7.762  1.00  0.00           H  
ATOM    264 HD21 ASN A  37       0.492  37.348  -7.856  1.00  0.00           H  
ATOM    265 HD22 ASN A  37      -0.391  36.653  -9.178  1.00  0.00           H  
ATOM    266  N   GLN A  38      -1.151  39.869  -5.625  1.00  0.00           N  
ATOM    267  CA  GLN A  38      -2.054  39.285  -4.631  1.00  0.00           C  
ATOM    268  C   GLN A  38      -3.104  40.306  -4.164  1.00  0.00           C  
ATOM    269  O   GLN A  38      -4.302  40.024  -4.234  1.00  0.00           O  
ATOM    270  CB  GLN A  38      -1.235  38.719  -3.456  1.00  0.00           C  
ATOM    271  CG  GLN A  38      -0.305  37.554  -3.833  1.00  0.00           C  
ATOM    272  CD  GLN A  38      -1.052  36.267  -4.187  1.00  0.00           C  
ATOM    273  OE1 GLN A  38      -1.723  36.166  -5.205  1.00  0.00           O  
ATOM    274  NE2 GLN A  38      -0.964  35.238  -3.371  1.00  0.00           N  
ATOM    275  H   GLN A  38      -0.189  40.032  -5.368  1.00  0.00           H  
ATOM    276  HA  GLN A  38      -2.605  38.467  -5.095  1.00  0.00           H  
ATOM    277  HB2 GLN A  38      -0.637  39.521  -3.021  1.00  0.00           H  
ATOM    278  HB3 GLN A  38      -1.918  38.355  -2.694  1.00  0.00           H  
ATOM    279  HG2 GLN A  38       0.327  37.839  -4.673  1.00  0.00           H  
ATOM    280  HG3 GLN A  38       0.345  37.355  -2.981  1.00  0.00           H  
ATOM    281 HE21 GLN A  38      -0.373  35.258  -2.556  1.00  0.00           H  
ATOM    282 HE22 GLN A  38      -1.431  34.382  -3.654  1.00  0.00           H  
ATOM    283  N   LEU A  39      -2.693  41.520  -3.766  1.00  0.00           N  
ATOM    284  CA  LEU A  39      -3.629  42.607  -3.444  1.00  0.00           C  
ATOM    285  C   LEU A  39      -4.483  43.016  -4.655  1.00  0.00           C  
ATOM    286  O   LEU A  39      -5.671  43.303  -4.496  1.00  0.00           O  
ATOM    287  CB  LEU A  39      -2.852  43.817  -2.888  1.00  0.00           C  
ATOM    288  CG  LEU A  39      -2.122  43.560  -1.555  1.00  0.00           C  
ATOM    289  CD1 LEU A  39      -1.382  44.822  -1.112  1.00  0.00           C  
ATOM    290  CD2 LEU A  39      -3.081  43.146  -0.445  1.00  0.00           C  
ATOM    291  H   LEU A  39      -1.700  41.722  -3.731  1.00  0.00           H  
ATOM    292  HA  LEU A  39      -4.336  42.254  -2.690  1.00  0.00           H  
ATOM    293  HB2 LEU A  39      -2.121  44.134  -3.632  1.00  0.00           H  
ATOM    294  HB3 LEU A  39      -3.557  44.638  -2.739  1.00  0.00           H  
ATOM    295  HG  LEU A  39      -1.389  42.766  -1.688  1.00  0.00           H  
ATOM    296 HD11 LEU A  39      -0.670  45.108  -1.883  1.00  0.00           H  
ATOM    297 HD12 LEU A  39      -2.075  45.646  -0.932  1.00  0.00           H  
ATOM    298 HD13 LEU A  39      -0.833  44.612  -0.197  1.00  0.00           H  
ATOM    299 HD21 LEU A  39      -3.880  43.877  -0.348  1.00  0.00           H  
ATOM    300 HD22 LEU A  39      -3.511  42.177  -0.678  1.00  0.00           H  
ATOM    301 HD23 LEU A  39      -2.546  43.073   0.501  1.00  0.00           H  
ATOM    302  N   GLN A  40      -3.912  42.989  -5.868  1.00  0.00           N  
ATOM    303  CA  GLN A  40      -4.665  43.230  -7.101  1.00  0.00           C  
ATOM    304  C   GLN A  40      -5.809  42.224  -7.257  1.00  0.00           C  
ATOM    305  O   GLN A  40      -6.943  42.641  -7.459  1.00  0.00           O  
ATOM    306  CB  GLN A  40      -3.743  43.210  -8.333  1.00  0.00           C  
ATOM    307  CG  GLN A  40      -4.337  43.943  -9.551  1.00  0.00           C  
ATOM    308  CD  GLN A  40      -4.450  45.462  -9.393  1.00  0.00           C  
ATOM    309  OE1 GLN A  40      -4.009  46.069  -8.426  1.00  0.00           O  
ATOM    310  NE2 GLN A  40      -5.055  46.141 -10.343  1.00  0.00           N  
ATOM    311  H   GLN A  40      -2.925  42.766  -5.935  1.00  0.00           H  
ATOM    312  HA  GLN A  40      -5.110  44.220  -7.019  1.00  0.00           H  
ATOM    313  HB2 GLN A  40      -2.790  43.670  -8.083  1.00  0.00           H  
ATOM    314  HB3 GLN A  40      -3.558  42.178  -8.629  1.00  0.00           H  
ATOM    315  HG2 GLN A  40      -3.699  43.745 -10.413  1.00  0.00           H  
ATOM    316  HG3 GLN A  40      -5.322  43.535  -9.772  1.00  0.00           H  
ATOM    317 HE21 GLN A  40      -5.418  45.671 -11.160  1.00  0.00           H  
ATOM    318 HE22 GLN A  40      -5.120  47.143 -10.246  1.00  0.00           H  
ATOM    319  N   TYR A  41      -5.562  40.920  -7.102  1.00  0.00           N  
ATOM    320  CA  TYR A  41      -6.623  39.910  -7.189  1.00  0.00           C  
ATOM    321  C   TYR A  41      -7.747  40.149  -6.163  1.00  0.00           C  
ATOM    322  O   TYR A  41      -8.928  40.103  -6.523  1.00  0.00           O  
ATOM    323  CB  TYR A  41      -6.020  38.509  -7.047  1.00  0.00           C  
ATOM    324  CG  TYR A  41      -7.023  37.415  -7.348  1.00  0.00           C  
ATOM    325  CD1 TYR A  41      -7.238  37.009  -8.679  1.00  0.00           C  
ATOM    326  CD2 TYR A  41      -7.776  36.841  -6.307  1.00  0.00           C  
ATOM    327  CE1 TYR A  41      -8.210  36.033  -8.973  1.00  0.00           C  
ATOM    328  CE2 TYR A  41      -8.752  35.871  -6.597  1.00  0.00           C  
ATOM    329  CZ  TYR A  41      -8.977  35.467  -7.931  1.00  0.00           C  
ATOM    330  OH  TYR A  41      -9.934  34.544  -8.217  1.00  0.00           O  
ATOM    331  H   TYR A  41      -4.609  40.613  -6.941  1.00  0.00           H  
ATOM    332  HA  TYR A  41      -7.074  39.978  -8.180  1.00  0.00           H  
ATOM    333  HB2 TYR A  41      -5.178  38.411  -7.736  1.00  0.00           H  
ATOM    334  HB3 TYR A  41      -5.636  38.388  -6.036  1.00  0.00           H  
ATOM    335  HD1 TYR A  41      -6.662  37.454  -9.480  1.00  0.00           H  
ATOM    336  HD2 TYR A  41      -7.603  37.143  -5.280  1.00  0.00           H  
ATOM    337  HE1 TYR A  41      -8.376  35.726  -9.996  1.00  0.00           H  
ATOM    338  HE2 TYR A  41      -9.324  35.426  -5.798  1.00  0.00           H  
ATOM    339  HH  TYR A  41      -9.983  34.364  -9.162  1.00  0.00           H  
ATOM    340  N   MET A  42      -7.397  40.497  -4.916  1.00  0.00           N  
ATOM    341  CA  MET A  42      -8.371  40.881  -3.886  1.00  0.00           C  
ATOM    342  C   MET A  42      -9.265  42.043  -4.340  1.00  0.00           C  
ATOM    343  O   MET A  42     -10.486  41.919  -4.295  1.00  0.00           O  
ATOM    344  CB  MET A  42      -7.683  41.222  -2.553  1.00  0.00           C  
ATOM    345  CG  MET A  42      -6.912  40.054  -1.930  1.00  0.00           C  
ATOM    346  SD  MET A  42      -7.809  38.492  -1.688  1.00  0.00           S  
ATOM    347  CE  MET A  42      -8.994  38.953  -0.406  1.00  0.00           C  
ATOM    348  H   MET A  42      -6.413  40.498  -4.673  1.00  0.00           H  
ATOM    349  HA  MET A  42      -9.023  40.029  -3.711  1.00  0.00           H  
ATOM    350  HB2 MET A  42      -6.994  42.053  -2.697  1.00  0.00           H  
ATOM    351  HB3 MET A  42      -8.440  41.550  -1.843  1.00  0.00           H  
ATOM    352  HG2 MET A  42      -6.060  39.837  -2.566  1.00  0.00           H  
ATOM    353  HG3 MET A  42      -6.521  40.379  -0.967  1.00  0.00           H  
ATOM    354  HE1 MET A  42      -8.462  39.292   0.484  1.00  0.00           H  
ATOM    355  HE2 MET A  42      -9.647  39.743  -0.774  1.00  0.00           H  
ATOM    356  HE3 MET A  42      -9.588  38.077  -0.151  1.00  0.00           H  
ATOM    357  N   GLN A  43      -8.699  43.152  -4.825  1.00  0.00           N  
ATOM    358  CA  GLN A  43      -9.488  44.343  -5.189  1.00  0.00           C  
ATOM    359  C   GLN A  43     -10.116  44.303  -6.594  1.00  0.00           C  
ATOM    360  O   GLN A  43     -10.990  45.115  -6.899  1.00  0.00           O  
ATOM    361  CB  GLN A  43      -8.642  45.602  -4.961  1.00  0.00           C  
ATOM    362  CG  GLN A  43      -7.577  45.896  -6.017  1.00  0.00           C  
ATOM    363  CD  GLN A  43      -6.492  46.786  -5.421  1.00  0.00           C  
ATOM    364  OE1 GLN A  43      -5.434  46.327  -5.018  1.00  0.00           O  
ATOM    365  NE2 GLN A  43      -6.720  48.074  -5.288  1.00  0.00           N  
ATOM    366  H   GLN A  43      -7.686  43.205  -4.861  1.00  0.00           H  
ATOM    367  HA  GLN A  43     -10.317  44.410  -4.486  1.00  0.00           H  
ATOM    368  HB2 GLN A  43      -9.303  46.467  -4.877  1.00  0.00           H  
ATOM    369  HB3 GLN A  43      -8.130  45.482  -4.013  1.00  0.00           H  
ATOM    370  HG2 GLN A  43      -7.120  44.969  -6.350  1.00  0.00           H  
ATOM    371  HG3 GLN A  43      -8.045  46.389  -6.863  1.00  0.00           H  
ATOM    372 HE21 GLN A  43      -7.592  48.477  -5.596  1.00  0.00           H  
ATOM    373 HE22 GLN A  43      -6.061  48.599  -4.727  1.00  0.00           H  
ATOM    374  N   ASN A  44      -9.701  43.359  -7.446  1.00  0.00           N  
ATOM    375  CA  ASN A  44     -10.094  43.283  -8.861  1.00  0.00           C  
ATOM    376  C   ASN A  44     -11.074  42.138  -9.146  1.00  0.00           C  
ATOM    377  O   ASN A  44     -11.821  42.215 -10.124  1.00  0.00           O  
ATOM    378  CB  ASN A  44      -8.824  43.096  -9.703  1.00  0.00           C  
ATOM    379  CG  ASN A  44      -8.983  43.376 -11.186  1.00  0.00           C  
ATOM    380  OD1 ASN A  44      -9.867  44.097 -11.633  1.00  0.00           O  
ATOM    381  ND2 ASN A  44      -8.097  42.842 -11.995  1.00  0.00           N  
ATOM    382  H   ASN A  44      -8.960  42.741  -7.132  1.00  0.00           H  
ATOM    383  HA  ASN A  44     -10.574  44.217  -9.153  1.00  0.00           H  
ATOM    384  HB2 ASN A  44      -8.052  43.773  -9.346  1.00  0.00           H  
ATOM    385  HB3 ASN A  44      -8.499  42.061  -9.572  1.00  0.00           H  
ATOM    386 HD21 ASN A  44      -7.340  42.282 -11.623  1.00  0.00           H  
ATOM    387 HD22 ASN A  44      -8.173  43.027 -12.984  1.00  0.00           H  
ATOM    388  N   VAL A  45     -11.100  41.106  -8.290  1.00  0.00           N  
ATOM    389  CA  VAL A  45     -11.977  39.940  -8.459  1.00  0.00           C  
ATOM    390  C   VAL A  45     -12.763  39.622  -7.184  1.00  0.00           C  
ATOM    391  O   VAL A  45     -13.984  39.475  -7.260  1.00  0.00           O  
ATOM    392  CB  VAL A  45     -11.206  38.683  -8.921  1.00  0.00           C  
ATOM    393  CG1 VAL A  45     -12.201  37.590  -9.341  1.00  0.00           C  
ATOM    394  CG2 VAL A  45     -10.281  38.959 -10.116  1.00  0.00           C  
ATOM    395  H   VAL A  45     -10.417  41.089  -7.541  1.00  0.00           H  
ATOM    396  HA  VAL A  45     -12.687  40.177  -9.242  1.00  0.00           H  
ATOM    397  HB  VAL A  45     -10.597  38.306  -8.099  1.00  0.00           H  
ATOM    398 HG11 VAL A  45     -12.885  37.356  -8.526  1.00  0.00           H  
ATOM    399 HG12 VAL A  45     -12.790  37.927 -10.195  1.00  0.00           H  
ATOM    400 HG13 VAL A  45     -11.661  36.682  -9.610  1.00  0.00           H  
ATOM    401 HG21 VAL A  45     -10.845  39.417 -10.929  1.00  0.00           H  
ATOM    402 HG22 VAL A  45      -9.471  39.624  -9.814  1.00  0.00           H  
ATOM    403 HG23 VAL A  45      -9.840  38.027 -10.466  1.00  0.00           H  
ATOM    404  N   VAL A  46     -12.100  39.539  -6.024  1.00  0.00           N  
ATOM    405  CA  VAL A  46     -12.736  39.112  -4.760  1.00  0.00           C  
ATOM    406  C   VAL A  46     -13.720  40.176  -4.265  1.00  0.00           C  
ATOM    407  O   VAL A  46     -14.930  39.949  -4.286  1.00  0.00           O  
ATOM    408  CB  VAL A  46     -11.693  38.770  -3.672  1.00  0.00           C  
ATOM    409  CG1 VAL A  46     -12.353  38.141  -2.442  1.00  0.00           C  
ATOM    410  CG2 VAL A  46     -10.625  37.799  -4.185  1.00  0.00           C  
ATOM    411  H   VAL A  46     -11.098  39.693  -6.030  1.00  0.00           H  
ATOM    412  HA  VAL A  46     -13.312  38.208  -4.958  1.00  0.00           H  
ATOM    413  HB  VAL A  46     -11.191  39.676  -3.345  1.00  0.00           H  
ATOM    414 HG11 VAL A  46     -13.014  38.867  -1.970  1.00  0.00           H  
ATOM    415 HG12 VAL A  46     -12.921  37.256  -2.727  1.00  0.00           H  
ATOM    416 HG13 VAL A  46     -11.588  37.861  -1.719  1.00  0.00           H  
ATOM    417 HG21 VAL A  46     -11.091  36.883  -4.534  1.00  0.00           H  
ATOM    418 HG22 VAL A  46     -10.058  38.256  -4.997  1.00  0.00           H  
ATOM    419 HG23 VAL A  46      -9.932  37.553  -3.383  1.00  0.00           H  
ATOM    420  N   VAL A  47     -13.225  41.370  -3.921  1.00  0.00           N  
ATOM    421  CA  VAL A  47     -14.039  42.547  -3.573  1.00  0.00           C  
ATOM    422  C   VAL A  47     -14.986  42.889  -4.714  1.00  0.00           C  
ATOM    423  O   VAL A  47     -16.167  43.105  -4.473  1.00  0.00           O  
ATOM    424  CB  VAL A  47     -13.152  43.771  -3.265  1.00  0.00           C  
ATOM    425  CG1 VAL A  47     -13.953  45.061  -3.041  1.00  0.00           C  
ATOM    426  CG2 VAL A  47     -12.302  43.561  -2.012  1.00  0.00           C  
ATOM    427  H   VAL A  47     -12.218  41.496  -3.963  1.00  0.00           H  
ATOM    428  HA  VAL A  47     -14.639  42.317  -2.690  1.00  0.00           H  
ATOM    429  HB  VAL A  47     -12.487  43.935  -4.112  1.00  0.00           H  
ATOM    430 HG11 VAL A  47     -14.495  45.342  -3.944  1.00  0.00           H  
ATOM    431 HG12 VAL A  47     -14.660  44.928  -2.220  1.00  0.00           H  
ATOM    432 HG13 VAL A  47     -13.268  45.874  -2.804  1.00  0.00           H  
ATOM    433 HG21 VAL A  47     -12.933  43.528  -1.128  1.00  0.00           H  
ATOM    434 HG22 VAL A  47     -11.719  42.644  -2.084  1.00  0.00           H  
ATOM    435 HG23 VAL A  47     -11.621  44.399  -1.908  1.00  0.00           H  
ATOM    436  N   LYS A  48     -14.495  42.890  -5.962  1.00  0.00           N  
ATOM    437  CA  LYS A  48     -15.286  43.212  -7.162  1.00  0.00           C  
ATOM    438  C   LYS A  48     -16.558  42.368  -7.255  1.00  0.00           C  
ATOM    439  O   LYS A  48     -17.640  42.908  -7.475  1.00  0.00           O  
ATOM    440  CB  LYS A  48     -14.392  43.020  -8.399  1.00  0.00           C  
ATOM    441  CG  LYS A  48     -14.987  43.580  -9.704  1.00  0.00           C  
ATOM    442  CD  LYS A  48     -14.733  45.084  -9.916  1.00  0.00           C  
ATOM    443  CE  LYS A  48     -13.252  45.458 -10.110  1.00  0.00           C  
ATOM    444  NZ  LYS A  48     -12.644  44.757 -11.272  1.00  0.00           N  
ATOM    445  H   LYS A  48     -13.511  42.686  -6.072  1.00  0.00           H  
ATOM    446  HA  LYS A  48     -15.604  44.254  -7.102  1.00  0.00           H  
ATOM    447  HB2 LYS A  48     -13.424  43.487  -8.215  1.00  0.00           H  
ATOM    448  HB3 LYS A  48     -14.220  41.954  -8.538  1.00  0.00           H  
ATOM    449  HG2 LYS A  48     -14.565  43.027 -10.543  1.00  0.00           H  
ATOM    450  HG3 LYS A  48     -16.060  43.402  -9.723  1.00  0.00           H  
ATOM    451  HD2 LYS A  48     -15.290  45.405 -10.798  1.00  0.00           H  
ATOM    452  HD3 LYS A  48     -15.125  45.635  -9.060  1.00  0.00           H  
ATOM    453  HE2 LYS A  48     -13.188  46.539 -10.262  1.00  0.00           H  
ATOM    454  HE3 LYS A  48     -12.698  45.222  -9.198  1.00  0.00           H  
ATOM    455  HZ1 LYS A  48     -12.621  43.753 -11.122  1.00  0.00           H  
ATOM    456  HZ2 LYS A  48     -13.149  44.945 -12.128  1.00  0.00           H  
ATOM    457  HZ3 LYS A  48     -11.676  45.032 -11.416  1.00  0.00           H  
ATOM    458  N   THR A  49     -16.447  41.055  -7.057  1.00  0.00           N  
ATOM    459  CA  THR A  49     -17.596  40.143  -7.134  1.00  0.00           C  
ATOM    460  C   THR A  49     -18.479  40.220  -5.885  1.00  0.00           C  
ATOM    461  O   THR A  49     -19.705  40.260  -6.009  1.00  0.00           O  
ATOM    462  CB  THR A  49     -17.154  38.694  -7.394  1.00  0.00           C  
ATOM    463  OG1 THR A  49     -16.320  38.628  -8.532  1.00  0.00           O  
ATOM    464  CG2 THR A  49     -18.380  37.820  -7.664  1.00  0.00           C  
ATOM    465  H   THR A  49     -15.525  40.673  -6.870  1.00  0.00           H  
ATOM    466  HA  THR A  49     -18.214  40.445  -7.978  1.00  0.00           H  
ATOM    467  HB  THR A  49     -16.582  38.300  -6.551  1.00  0.00           H  
ATOM    468  HG1 THR A  49     -15.444  38.932  -8.236  1.00  0.00           H  
ATOM    469 HG21 THR A  49     -18.919  37.649  -6.732  1.00  0.00           H  
ATOM    470 HG22 THR A  49     -19.046  38.326  -8.366  1.00  0.00           H  
ATOM    471 HG23 THR A  49     -18.085  36.862  -8.083  1.00  0.00           H  
ATOM    472  N   LEU A  50     -17.888  40.310  -4.689  1.00  0.00           N  
ATOM    473  CA  LEU A  50     -18.632  40.469  -3.431  1.00  0.00           C  
ATOM    474  C   LEU A  50     -19.423  41.792  -3.380  1.00  0.00           C  
ATOM    475  O   LEU A  50     -20.524  41.814  -2.843  1.00  0.00           O  
ATOM    476  CB  LEU A  50     -17.663  40.353  -2.241  1.00  0.00           C  
ATOM    477  CG  LEU A  50     -17.041  38.951  -2.071  1.00  0.00           C  
ATOM    478  CD1 LEU A  50     -15.834  39.021  -1.141  1.00  0.00           C  
ATOM    479  CD2 LEU A  50     -18.021  37.936  -1.484  1.00  0.00           C  
ATOM    480  H   LEU A  50     -16.874  40.287  -4.642  1.00  0.00           H  
ATOM    481  HA  LEU A  50     -19.367  39.667  -3.357  1.00  0.00           H  
ATOM    482  HB2 LEU A  50     -16.869  41.088  -2.380  1.00  0.00           H  
ATOM    483  HB3 LEU A  50     -18.192  40.609  -1.322  1.00  0.00           H  
ATOM    484  HG  LEU A  50     -16.704  38.576  -3.035  1.00  0.00           H  
ATOM    485 HD11 LEU A  50     -15.158  39.808  -1.470  1.00  0.00           H  
ATOM    486 HD12 LEU A  50     -16.156  39.228  -0.122  1.00  0.00           H  
ATOM    487 HD13 LEU A  50     -15.301  38.075  -1.173  1.00  0.00           H  
ATOM    488 HD21 LEU A  50     -18.347  38.254  -0.494  1.00  0.00           H  
ATOM    489 HD22 LEU A  50     -18.886  37.818  -2.134  1.00  0.00           H  
ATOM    490 HD23 LEU A  50     -17.527  36.972  -1.382  1.00  0.00           H  
ATOM    491  N   TRP A  51     -18.913  42.870  -3.988  1.00  0.00           N  
ATOM    492  CA  TRP A  51     -19.582  44.169  -4.126  1.00  0.00           C  
ATOM    493  C   TRP A  51     -20.727  44.157  -5.154  1.00  0.00           C  
ATOM    494  O   TRP A  51     -21.714  44.872  -4.979  1.00  0.00           O  
ATOM    495  CB  TRP A  51     -18.539  45.232  -4.502  1.00  0.00           C  
ATOM    496  CG  TRP A  51     -18.929  46.654  -4.233  1.00  0.00           C  
ATOM    497  CD1 TRP A  51     -19.596  47.482  -5.069  1.00  0.00           C  
ATOM    498  CD2 TRP A  51     -18.670  47.434  -3.028  1.00  0.00           C  
ATOM    499  NE1 TRP A  51     -19.769  48.713  -4.462  1.00  0.00           N  
ATOM    500  CE2 TRP A  51     -19.215  48.740  -3.198  1.00  0.00           C  
ATOM    501  CE3 TRP A  51     -18.034  47.153  -1.799  1.00  0.00           C  
ATOM    502  CZ2 TRP A  51     -19.128  49.724  -2.198  1.00  0.00           C  
ATOM    503  CZ3 TRP A  51     -17.962  48.121  -0.782  1.00  0.00           C  
ATOM    504  CH2 TRP A  51     -18.487  49.410  -0.987  1.00  0.00           C  
ATOM    505  H   TRP A  51     -17.966  42.804  -4.339  1.00  0.00           H  
ATOM    506  HA  TRP A  51     -20.005  44.442  -3.160  1.00  0.00           H  
ATOM    507  HB2 TRP A  51     -17.641  45.055  -3.908  1.00  0.00           H  
ATOM    508  HB3 TRP A  51     -18.266  45.122  -5.551  1.00  0.00           H  
ATOM    509  HD1 TRP A  51     -19.950  47.214  -6.061  1.00  0.00           H  
ATOM    510  HE1 TRP A  51     -20.257  49.488  -4.900  1.00  0.00           H  
ATOM    511  HE3 TRP A  51     -17.606  46.174  -1.648  1.00  0.00           H  
ATOM    512  HZ2 TRP A  51     -19.575  50.698  -2.344  1.00  0.00           H  
ATOM    513  HZ3 TRP A  51     -17.491  47.869   0.158  1.00  0.00           H  
ATOM    514  HH2 TRP A  51     -18.416  50.156  -0.206  1.00  0.00           H  
ATOM    515  N   LYS A  52     -20.635  43.331  -6.210  1.00  0.00           N  
ATOM    516  CA  LYS A  52     -21.717  43.142  -7.201  1.00  0.00           C  
ATOM    517  C   LYS A  52     -22.857  42.233  -6.705  1.00  0.00           C  
ATOM    518  O   LYS A  52     -23.891  42.135  -7.372  1.00  0.00           O  
ATOM    519  CB  LYS A  52     -21.128  42.615  -8.522  1.00  0.00           C  
ATOM    520  CG  LYS A  52     -20.382  43.723  -9.289  1.00  0.00           C  
ATOM    521  CD  LYS A  52     -19.842  43.256 -10.649  1.00  0.00           C  
ATOM    522  CE  LYS A  52     -18.813  42.127 -10.518  1.00  0.00           C  
ATOM    523  NZ  LYS A  52     -18.254  41.744 -11.840  1.00  0.00           N  
ATOM    524  H   LYS A  52     -19.791  42.775  -6.314  1.00  0.00           H  
ATOM    525  HA  LYS A  52     -22.186  44.108  -7.399  1.00  0.00           H  
ATOM    526  HB2 LYS A  52     -20.460  41.778  -8.312  1.00  0.00           H  
ATOM    527  HB3 LYS A  52     -21.937  42.255  -9.160  1.00  0.00           H  
ATOM    528  HG2 LYS A  52     -21.073  44.549  -9.465  1.00  0.00           H  
ATOM    529  HG3 LYS A  52     -19.559  44.104  -8.688  1.00  0.00           H  
ATOM    530  HD2 LYS A  52     -20.677  42.916 -11.266  1.00  0.00           H  
ATOM    531  HD3 LYS A  52     -19.375  44.110 -11.142  1.00  0.00           H  
ATOM    532  HE2 LYS A  52     -18.011  42.462  -9.856  1.00  0.00           H  
ATOM    533  HE3 LYS A  52     -19.292  41.259 -10.058  1.00  0.00           H  
ATOM    534  HZ1 LYS A  52     -18.981  41.416 -12.463  1.00  0.00           H  
ATOM    535  HZ2 LYS A  52     -17.794  42.526 -12.288  1.00  0.00           H  
ATOM    536  HZ3 LYS A  52     -17.575  40.997 -11.750  1.00  0.00           H  
ATOM    537  N   HIS A  53     -22.684  41.565  -5.563  1.00  0.00           N  
ATOM    538  CA  HIS A  53     -23.667  40.649  -4.972  1.00  0.00           C  
ATOM    539  C   HIS A  53     -24.982  41.345  -4.573  1.00  0.00           C  
ATOM    540  O   HIS A  53     -24.990  42.509  -4.161  1.00  0.00           O  
ATOM    541  CB  HIS A  53     -23.030  39.964  -3.757  1.00  0.00           C  
ATOM    542  CG  HIS A  53     -23.759  38.719  -3.324  1.00  0.00           C  
ATOM    543  ND1 HIS A  53     -24.881  38.669  -2.495  1.00  0.00           N  
ATOM    544  CD2 HIS A  53     -23.439  37.454  -3.710  1.00  0.00           C  
ATOM    545  CE1 HIS A  53     -25.204  37.367  -2.396  1.00  0.00           C  
ATOM    546  NE2 HIS A  53     -24.355  36.616  -3.116  1.00  0.00           N  
ATOM    547  H   HIS A  53     -21.805  41.689  -5.082  1.00  0.00           H  
ATOM    548  HA  HIS A  53     -23.903  39.880  -5.711  1.00  0.00           H  
ATOM    549  HB2 HIS A  53     -22.004  39.681  -3.998  1.00  0.00           H  
ATOM    550  HB3 HIS A  53     -22.999  40.667  -2.926  1.00  0.00           H  
ATOM    551  HD2 HIS A  53     -22.617  37.176  -4.356  1.00  0.00           H  
ATOM    552  HE1 HIS A  53     -26.042  36.974  -1.836  1.00  0.00           H  
ATOM    553  HE2 HIS A  53     -24.395  35.606  -3.200  1.00  0.00           H  
ATOM    554  N   GLN A  54     -26.097  40.609  -4.634  1.00  0.00           N  
ATOM    555  CA  GLN A  54     -27.439  41.063  -4.228  1.00  0.00           C  
ATOM    556  C   GLN A  54     -27.580  41.458  -2.739  1.00  0.00           C  
ATOM    557  O   GLN A  54     -28.575  42.085  -2.368  1.00  0.00           O  
ATOM    558  CB  GLN A  54     -28.481  40.001  -4.624  1.00  0.00           C  
ATOM    559  CG  GLN A  54     -28.290  38.642  -3.927  1.00  0.00           C  
ATOM    560  CD  GLN A  54     -29.385  37.646  -4.306  1.00  0.00           C  
ATOM    561  OE1 GLN A  54     -29.626  37.348  -5.469  1.00  0.00           O  
ATOM    562  NE2 GLN A  54     -30.092  37.089  -3.346  1.00  0.00           N  
ATOM    563  H   GLN A  54     -26.006  39.652  -4.945  1.00  0.00           H  
ATOM    564  HA  GLN A  54     -27.663  41.964  -4.802  1.00  0.00           H  
ATOM    565  HB2 GLN A  54     -29.475  40.380  -4.385  1.00  0.00           H  
ATOM    566  HB3 GLN A  54     -28.431  39.854  -5.705  1.00  0.00           H  
ATOM    567  HG2 GLN A  54     -27.332  38.209  -4.209  1.00  0.00           H  
ATOM    568  HG3 GLN A  54     -28.293  38.786  -2.847  1.00  0.00           H  
ATOM    569 HE21 GLN A  54     -29.907  37.326  -2.380  1.00  0.00           H  
ATOM    570 HE22 GLN A  54     -30.816  36.433  -3.597  1.00  0.00           H  
ATOM    571  N   PHE A  55     -26.595  41.128  -1.896  1.00  0.00           N  
ATOM    572  CA  PHE A  55     -26.564  41.408  -0.454  1.00  0.00           C  
ATOM    573  C   PHE A  55     -25.316  42.198  -0.003  1.00  0.00           C  
ATOM    574  O   PHE A  55     -24.993  42.224   1.183  1.00  0.00           O  
ATOM    575  CB  PHE A  55     -26.651  40.089   0.326  1.00  0.00           C  
ATOM    576  CG  PHE A  55     -27.833  39.165   0.081  1.00  0.00           C  
ATOM    577  CD1 PHE A  55     -29.136  39.667  -0.111  1.00  0.00           C  
ATOM    578  CD2 PHE A  55     -27.635  37.772   0.163  1.00  0.00           C  
ATOM    579  CE1 PHE A  55     -30.224  38.784  -0.232  1.00  0.00           C  
ATOM    580  CE2 PHE A  55     -28.723  36.890   0.044  1.00  0.00           C  
ATOM    581  CZ  PHE A  55     -30.020  37.396  -0.145  1.00  0.00           C  
ATOM    582  H   PHE A  55     -25.858  40.537  -2.262  1.00  0.00           H  
ATOM    583  HA  PHE A  55     -27.422  42.022  -0.184  1.00  0.00           H  
ATOM    584  HB2 PHE A  55     -25.732  39.535   0.154  1.00  0.00           H  
ATOM    585  HB3 PHE A  55     -26.657  40.345   1.379  1.00  0.00           H  
ATOM    586  HD1 PHE A  55     -29.312  40.732  -0.151  1.00  0.00           H  
ATOM    587  HD2 PHE A  55     -26.643  37.381   0.340  1.00  0.00           H  
ATOM    588  HE1 PHE A  55     -31.224  39.176  -0.372  1.00  0.00           H  
ATOM    589  HE2 PHE A  55     -28.564  35.821   0.118  1.00  0.00           H  
ATOM    590  HZ  PHE A  55     -30.862  36.718  -0.218  1.00  0.00           H  
ATOM    591  N   ALA A  56     -24.595  42.839  -0.925  1.00  0.00           N  
ATOM    592  CA  ALA A  56     -23.430  43.678  -0.618  1.00  0.00           C  
ATOM    593  C   ALA A  56     -23.774  44.997   0.110  1.00  0.00           C  
ATOM    594  O   ALA A  56     -22.960  45.531   0.865  1.00  0.00           O  
ATOM    595  CB  ALA A  56     -22.764  43.991  -1.955  1.00  0.00           C  
ATOM    596  H   ALA A  56     -24.874  42.758  -1.895  1.00  0.00           H  
ATOM    597  HA  ALA A  56     -22.719  43.126   0.004  1.00  0.00           H  
ATOM    598  HB1 ALA A  56     -22.613  43.073  -2.518  1.00  0.00           H  
ATOM    599  HB2 ALA A  56     -23.395  44.657  -2.544  1.00  0.00           H  
ATOM    600  HB3 ALA A  56     -21.802  44.464  -1.775  1.00  0.00           H  
ATOM    601  N   TRP A  57     -24.986  45.524  -0.106  1.00  0.00           N  
ATOM    602  CA  TRP A  57     -25.413  46.863   0.316  1.00  0.00           C  
ATOM    603  C   TRP A  57     -25.312  47.221   1.817  1.00  0.00           C  
ATOM    604  O   TRP A  57     -24.907  48.356   2.094  1.00  0.00           O  
ATOM    605  CB  TRP A  57     -26.795  47.181  -0.281  1.00  0.00           C  
ATOM    606  CG  TRP A  57     -27.874  46.148  -0.120  1.00  0.00           C  
ATOM    607  CD1 TRP A  57     -28.058  45.077  -0.926  1.00  0.00           C  
ATOM    608  CD2 TRP A  57     -28.944  46.078   0.876  1.00  0.00           C  
ATOM    609  NE1 TRP A  57     -29.140  44.342  -0.491  1.00  0.00           N  
ATOM    610  CE2 TRP A  57     -29.734  44.916   0.612  1.00  0.00           C  
ATOM    611  CE3 TRP A  57     -29.316  46.867   1.988  1.00  0.00           C  
ATOM    612  CZ2 TRP A  57     -30.842  44.565   1.396  1.00  0.00           C  
ATOM    613  CZ3 TRP A  57     -30.421  46.516   2.790  1.00  0.00           C  
ATOM    614  CH2 TRP A  57     -31.185  45.372   2.495  1.00  0.00           C  
ATOM    615  H   TRP A  57     -25.617  45.001  -0.691  1.00  0.00           H  
ATOM    616  HA  TRP A  57     -24.724  47.554  -0.161  1.00  0.00           H  
ATOM    617  HB2 TRP A  57     -27.150  48.124   0.138  1.00  0.00           H  
ATOM    618  HB3 TRP A  57     -26.661  47.346  -1.350  1.00  0.00           H  
ATOM    619  HD1 TRP A  57     -27.451  44.831  -1.790  1.00  0.00           H  
ATOM    620  HE1 TRP A  57     -29.443  43.488  -0.958  1.00  0.00           H  
ATOM    621  HE3 TRP A  57     -28.736  47.747   2.227  1.00  0.00           H  
ATOM    622  HZ2 TRP A  57     -31.418  43.681   1.162  1.00  0.00           H  
ATOM    623  HZ3 TRP A  57     -30.686  47.132   3.641  1.00  0.00           H  
ATOM    624  HH2 TRP A  57     -32.036  45.115   3.114  1.00  0.00           H  
ATOM    625  N   PRO A  58     -25.580  46.341   2.810  1.00  0.00           N  
ATOM    626  CA  PRO A  58     -25.370  46.671   4.223  1.00  0.00           C  
ATOM    627  C   PRO A  58     -23.885  46.662   4.647  1.00  0.00           C  
ATOM    628  O   PRO A  58     -23.576  47.066   5.769  1.00  0.00           O  
ATOM    629  CB  PRO A  58     -26.205  45.657   5.005  1.00  0.00           C  
ATOM    630  CG  PRO A  58     -26.169  44.422   4.116  1.00  0.00           C  
ATOM    631  CD  PRO A  58     -26.118  44.992   2.701  1.00  0.00           C  
ATOM    632  HA  PRO A  58     -25.767  47.662   4.436  1.00  0.00           H  
ATOM    633  HB2 PRO A  58     -25.801  45.458   5.998  1.00  0.00           H  
ATOM    634  HB3 PRO A  58     -27.230  46.016   5.078  1.00  0.00           H  
ATOM    635  HG2 PRO A  58     -25.263  43.855   4.319  1.00  0.00           H  
ATOM    636  HG3 PRO A  58     -27.052  43.802   4.264  1.00  0.00           H  
ATOM    637  HD2 PRO A  58     -25.476  44.367   2.095  1.00  0.00           H  
ATOM    638  HD3 PRO A  58     -27.122  45.016   2.289  1.00  0.00           H  
ATOM    639  N   PHE A  59     -22.964  46.253   3.763  1.00  0.00           N  
ATOM    640  CA  PHE A  59     -21.514  46.214   4.000  1.00  0.00           C  
ATOM    641  C   PHE A  59     -20.753  47.330   3.249  1.00  0.00           C  
ATOM    642  O   PHE A  59     -19.551  47.497   3.463  1.00  0.00           O  
ATOM    643  CB  PHE A  59     -20.968  44.829   3.610  1.00  0.00           C  
ATOM    644  CG  PHE A  59     -21.660  43.637   4.255  1.00  0.00           C  
ATOM    645  CD1 PHE A  59     -21.234  43.150   5.505  1.00  0.00           C  
ATOM    646  CD2 PHE A  59     -22.721  42.994   3.590  1.00  0.00           C  
ATOM    647  CE1 PHE A  59     -21.872  42.039   6.089  1.00  0.00           C  
ATOM    648  CE2 PHE A  59     -23.367  41.892   4.178  1.00  0.00           C  
ATOM    649  CZ  PHE A  59     -22.945  41.414   5.431  1.00  0.00           C  
ATOM    650  H   PHE A  59     -23.282  45.917   2.861  1.00  0.00           H  
ATOM    651  HA  PHE A  59     -21.316  46.358   5.064  1.00  0.00           H  
ATOM    652  HB2 PHE A  59     -21.044  44.722   2.528  1.00  0.00           H  
ATOM    653  HB3 PHE A  59     -19.909  44.788   3.860  1.00  0.00           H  
ATOM    654  HD1 PHE A  59     -20.406  43.620   6.015  1.00  0.00           H  
ATOM    655  HD2 PHE A  59     -23.047  43.349   2.623  1.00  0.00           H  
ATOM    656  HE1 PHE A  59     -21.536  41.666   7.046  1.00  0.00           H  
ATOM    657  HE2 PHE A  59     -24.186  41.413   3.663  1.00  0.00           H  
ATOM    658  HZ  PHE A  59     -23.443  40.567   5.883  1.00  0.00           H  
ATOM    659  N   TYR A  60     -21.424  48.123   2.397  1.00  0.00           N  
ATOM    660  CA  TYR A  60     -20.815  49.242   1.654  1.00  0.00           C  
ATOM    661  C   TYR A  60     -20.229  50.356   2.547  1.00  0.00           C  
ATOM    662  O   TYR A  60     -19.437  51.173   2.072  1.00  0.00           O  
ATOM    663  CB  TYR A  60     -21.837  49.896   0.704  1.00  0.00           C  
ATOM    664  CG  TYR A  60     -22.380  49.125  -0.490  1.00  0.00           C  
ATOM    665  CD1 TYR A  60     -21.732  47.990  -1.021  1.00  0.00           C  
ATOM    666  CD2 TYR A  60     -23.518  49.643  -1.144  1.00  0.00           C  
ATOM    667  CE1 TYR A  60     -22.215  47.389  -2.201  1.00  0.00           C  
ATOM    668  CE2 TYR A  60     -24.018  49.030  -2.307  1.00  0.00           C  
ATOM    669  CZ  TYR A  60     -23.364  47.899  -2.840  1.00  0.00           C  
ATOM    670  OH  TYR A  60     -23.837  47.313  -3.972  1.00  0.00           O  
ATOM    671  H   TYR A  60     -22.404  47.930   2.237  1.00  0.00           H  
ATOM    672  HA  TYR A  60     -19.988  48.847   1.069  1.00  0.00           H  
ATOM    673  HB2 TYR A  60     -22.681  50.238   1.300  1.00  0.00           H  
ATOM    674  HB3 TYR A  60     -21.373  50.791   0.287  1.00  0.00           H  
ATOM    675  HD1 TYR A  60     -20.842  47.593  -0.554  1.00  0.00           H  
ATOM    676  HD2 TYR A  60     -24.008  50.526  -0.751  1.00  0.00           H  
ATOM    677  HE1 TYR A  60     -21.690  46.553  -2.643  1.00  0.00           H  
ATOM    678  HE2 TYR A  60     -24.894  49.432  -2.798  1.00  0.00           H  
ATOM    679  HH  TYR A  60     -24.617  47.766  -4.310  1.00  0.00           H  
ATOM    680  N   GLN A  61     -20.624  50.421   3.823  1.00  0.00           N  
ATOM    681  CA  GLN A  61     -20.243  51.459   4.790  1.00  0.00           C  
ATOM    682  C   GLN A  61     -20.061  50.852   6.198  1.00  0.00           C  
ATOM    683  O   GLN A  61     -20.672  49.817   6.493  1.00  0.00           O  
ATOM    684  CB  GLN A  61     -21.345  52.538   4.839  1.00  0.00           C  
ATOM    685  CG  GLN A  61     -21.500  53.327   3.527  1.00  0.00           C  
ATOM    686  CD  GLN A  61     -22.531  54.445   3.662  1.00  0.00           C  
ATOM    687  OE1 GLN A  61     -22.225  55.573   4.030  1.00  0.00           O  
ATOM    688  NE2 GLN A  61     -23.791  54.184   3.374  1.00  0.00           N  
ATOM    689  H   GLN A  61     -21.251  49.700   4.152  1.00  0.00           H  
ATOM    690  HA  GLN A  61     -19.303  51.917   4.482  1.00  0.00           H  
ATOM    691  HB2 GLN A  61     -22.298  52.065   5.083  1.00  0.00           H  
ATOM    692  HB3 GLN A  61     -21.115  53.246   5.634  1.00  0.00           H  
ATOM    693  HG2 GLN A  61     -20.540  53.764   3.255  1.00  0.00           H  
ATOM    694  HG3 GLN A  61     -21.813  52.658   2.726  1.00  0.00           H  
ATOM    695 HE21 GLN A  61     -24.065  53.261   3.071  1.00  0.00           H  
ATOM    696 HE22 GLN A  61     -24.470  54.926   3.464  1.00  0.00           H  
ATOM    697  N   PRO A  62     -19.271  51.481   7.092  1.00  0.00           N  
ATOM    698  CA  PRO A  62     -19.185  51.077   8.495  1.00  0.00           C  
ATOM    699  C   PRO A  62     -20.514  51.294   9.238  1.00  0.00           C  
ATOM    700  O   PRO A  62     -21.290  52.195   8.903  1.00  0.00           O  
ATOM    701  CB  PRO A  62     -18.047  51.909   9.093  1.00  0.00           C  
ATOM    702  CG  PRO A  62     -18.035  53.171   8.231  1.00  0.00           C  
ATOM    703  CD  PRO A  62     -18.438  52.652   6.849  1.00  0.00           C  
ATOM    704  HA  PRO A  62     -18.918  50.025   8.558  1.00  0.00           H  
ATOM    705  HB2 PRO A  62     -18.209  52.142  10.147  1.00  0.00           H  
ATOM    706  HB3 PRO A  62     -17.103  51.377   8.965  1.00  0.00           H  
ATOM    707  HG2 PRO A  62     -18.791  53.869   8.592  1.00  0.00           H  
ATOM    708  HG3 PRO A  62     -17.053  53.643   8.214  1.00  0.00           H  
ATOM    709  HD2 PRO A  62     -18.973  53.430   6.304  1.00  0.00           H  
ATOM    710  HD3 PRO A  62     -17.546  52.351   6.297  1.00  0.00           H  
ATOM    711  N   VAL A  63     -20.776  50.481  10.267  1.00  0.00           N  
ATOM    712  CA  VAL A  63     -21.964  50.603  11.133  1.00  0.00           C  
ATOM    713  C   VAL A  63     -21.907  51.896  11.957  1.00  0.00           C  
ATOM    714  O   VAL A  63     -21.163  51.998  12.934  1.00  0.00           O  
ATOM    715  CB  VAL A  63     -22.130  49.374  12.055  1.00  0.00           C  
ATOM    716  CG1 VAL A  63     -23.385  49.488  12.936  1.00  0.00           C  
ATOM    717  CG2 VAL A  63     -22.270  48.080  11.242  1.00  0.00           C  
ATOM    718  H   VAL A  63     -20.116  49.739  10.463  1.00  0.00           H  
ATOM    719  HA  VAL A  63     -22.849  50.650  10.497  1.00  0.00           H  
ATOM    720  HB  VAL A  63     -21.254  49.287  12.696  1.00  0.00           H  
ATOM    721 HG11 VAL A  63     -23.301  50.335  13.617  1.00  0.00           H  
ATOM    722 HG12 VAL A  63     -24.272  49.609  12.314  1.00  0.00           H  
ATOM    723 HG13 VAL A  63     -23.497  48.587  13.541  1.00  0.00           H  
ATOM    724 HG21 VAL A  63     -23.120  48.150  10.566  1.00  0.00           H  
ATOM    725 HG22 VAL A  63     -21.365  47.900  10.662  1.00  0.00           H  
ATOM    726 HG23 VAL A  63     -22.414  47.233  11.914  1.00  0.00           H  
ATOM    727  N   ASP A  64     -22.704  52.894  11.569  1.00  0.00           N  
ATOM    728  CA  ASP A  64     -22.946  54.110  12.356  1.00  0.00           C  
ATOM    729  C   ASP A  64     -23.884  53.799  13.535  1.00  0.00           C  
ATOM    730  O   ASP A  64     -25.100  53.964  13.434  1.00  0.00           O  
ATOM    731  CB  ASP A  64     -23.520  55.229  11.466  1.00  0.00           C  
ATOM    732  CG  ASP A  64     -22.480  55.877  10.537  1.00  0.00           C  
ATOM    733  OD1 ASP A  64     -21.359  56.198  10.998  1.00  0.00           O  
ATOM    734  OD2 ASP A  64     -22.815  56.144   9.357  1.00  0.00           O  
ATOM    735  H   ASP A  64     -23.241  52.767  10.723  1.00  0.00           H  
ATOM    736  HA  ASP A  64     -22.001  54.461  12.776  1.00  0.00           H  
ATOM    737  HB2 ASP A  64     -24.347  54.830  10.878  1.00  0.00           H  
ATOM    738  HB3 ASP A  64     -23.916  56.017  12.111  1.00  0.00           H  
ATOM    739  N   ALA A  65     -23.333  53.334  14.660  1.00  0.00           N  
ATOM    740  CA  ALA A  65     -24.087  52.986  15.874  1.00  0.00           C  
ATOM    741  C   ALA A  65     -25.038  54.103  16.369  1.00  0.00           C  
ATOM    742  O   ALA A  65     -26.062  53.811  16.987  1.00  0.00           O  
ATOM    743  CB  ALA A  65     -23.082  52.576  16.959  1.00  0.00           C  
ATOM    744  H   ALA A  65     -22.337  53.157  14.660  1.00  0.00           H  
ATOM    745  HA  ALA A  65     -24.711  52.118  15.648  1.00  0.00           H  
ATOM    746  HB1 ALA A  65     -22.473  51.742  16.608  1.00  0.00           H  
ATOM    747  HB2 ALA A  65     -22.434  53.417  17.208  1.00  0.00           H  
ATOM    748  HB3 ALA A  65     -23.617  52.266  17.856  1.00  0.00           H  
ATOM    749  N   ILE A  66     -24.742  55.371  16.055  1.00  0.00           N  
ATOM    750  CA  ILE A  66     -25.612  56.536  16.283  1.00  0.00           C  
ATOM    751  C   ILE A  66     -26.909  56.443  15.453  1.00  0.00           C  
ATOM    752  O   ILE A  66     -28.006  56.597  15.992  1.00  0.00           O  
ATOM    753  CB  ILE A  66     -24.833  57.833  15.942  1.00  0.00           C  
ATOM    754  CG1 ILE A  66     -23.567  57.966  16.823  1.00  0.00           C  
ATOM    755  CG2 ILE A  66     -25.727  59.079  16.093  1.00  0.00           C  
ATOM    756  CD1 ILE A  66     -22.599  59.061  16.358  1.00  0.00           C  
ATOM    757  H   ILE A  66     -23.863  55.535  15.584  1.00  0.00           H  
ATOM    758  HA  ILE A  66     -25.892  56.567  17.337  1.00  0.00           H  
ATOM    759  HB  ILE A  66     -24.516  57.773  14.898  1.00  0.00           H  
ATOM    760 HG12 ILE A  66     -23.858  58.157  17.856  1.00  0.00           H  
ATOM    761 HG13 ILE A  66     -23.005  57.034  16.803  1.00  0.00           H  
ATOM    762 HG21 ILE A  66     -26.579  59.025  15.417  1.00  0.00           H  
ATOM    763 HG22 ILE A  66     -26.087  59.160  17.121  1.00  0.00           H  
ATOM    764 HG23 ILE A  66     -25.174  59.981  15.837  1.00  0.00           H  
ATOM    765 HD11 ILE A  66     -22.346  58.902  15.309  1.00  0.00           H  
ATOM    766 HD12 ILE A  66     -23.039  60.048  16.486  1.00  0.00           H  
ATOM    767 HD13 ILE A  66     -21.687  59.006  16.952  1.00  0.00           H  
ATOM    768  N   LYS A  67     -26.794  56.174  14.145  1.00  0.00           N  
ATOM    769  CA  LYS A  67     -27.921  56.069  13.193  1.00  0.00           C  
ATOM    770  C   LYS A  67     -28.725  54.777  13.364  1.00  0.00           C  
ATOM    771  O   LYS A  67     -29.955  54.803  13.312  1.00  0.00           O  
ATOM    772  CB  LYS A  67     -27.396  56.147  11.750  1.00  0.00           C  
ATOM    773  CG  LYS A  67     -26.857  57.541  11.408  1.00  0.00           C  
ATOM    774  CD  LYS A  67     -26.487  57.627   9.920  1.00  0.00           C  
ATOM    775  CE  LYS A  67     -26.094  59.052   9.517  1.00  0.00           C  
ATOM    776  NZ  LYS A  67     -24.768  59.448  10.058  1.00  0.00           N  
ATOM    777  H   LYS A  67     -25.862  55.979  13.800  1.00  0.00           H  
ATOM    778  HA  LYS A  67     -28.610  56.899  13.352  1.00  0.00           H  
ATOM    779  HB2 LYS A  67     -26.616  55.401  11.595  1.00  0.00           H  
ATOM    780  HB3 LYS A  67     -28.222  55.915  11.073  1.00  0.00           H  
ATOM    781  HG2 LYS A  67     -27.627  58.283  11.625  1.00  0.00           H  
ATOM    782  HG3 LYS A  67     -25.978  57.753  12.018  1.00  0.00           H  
ATOM    783  HD2 LYS A  67     -25.675  56.935   9.693  1.00  0.00           H  
ATOM    784  HD3 LYS A  67     -27.357  57.340   9.325  1.00  0.00           H  
ATOM    785  HE2 LYS A  67     -26.071  59.106   8.425  1.00  0.00           H  
ATOM    786  HE3 LYS A  67     -26.869  59.738   9.873  1.00  0.00           H  
ATOM    787  HZ1 LYS A  67     -24.768  59.450  11.069  1.00  0.00           H  
ATOM    788  HZ2 LYS A  67     -24.043  58.820   9.739  1.00  0.00           H  
ATOM    789  HZ3 LYS A  67     -24.521  60.381   9.752  1.00  0.00           H  
ATOM    790  N   LEU A  68     -28.035  53.658  13.598  1.00  0.00           N  
ATOM    791  CA  LEU A  68     -28.631  52.350  13.893  1.00  0.00           C  
ATOM    792  C   LEU A  68     -29.208  52.254  15.320  1.00  0.00           C  
ATOM    793  O   LEU A  68     -29.931  51.305  15.626  1.00  0.00           O  
ATOM    794  CB  LEU A  68     -27.602  51.241  13.641  1.00  0.00           C  
ATOM    795  CG  LEU A  68     -27.342  50.880  12.171  1.00  0.00           C  
ATOM    796  CD1 LEU A  68     -28.600  50.705  11.316  1.00  0.00           C  
ATOM    797  CD2 LEU A  68     -26.380  51.813  11.438  1.00  0.00           C  
ATOM    798  H   LEU A  68     -27.024  53.729  13.591  1.00  0.00           H  
ATOM    799  HA  LEU A  68     -29.455  52.165  13.212  1.00  0.00           H  
ATOM    800  HB2 LEU A  68     -26.660  51.483  14.136  1.00  0.00           H  
ATOM    801  HB3 LEU A  68     -27.987  50.331  14.100  1.00  0.00           H  
ATOM    802  HG  LEU A  68     -26.873  49.916  12.229  1.00  0.00           H  
ATOM    803 HD11 LEU A  68     -29.313  50.066  11.837  1.00  0.00           H  
ATOM    804 HD12 LEU A  68     -29.056  51.672  11.105  1.00  0.00           H  
ATOM    805 HD13 LEU A  68     -28.333  50.233  10.371  1.00  0.00           H  
ATOM    806 HD21 LEU A  68     -26.806  52.812  11.352  1.00  0.00           H  
ATOM    807 HD22 LEU A  68     -25.441  51.860  11.985  1.00  0.00           H  
ATOM    808 HD23 LEU A  68     -26.179  51.423  10.441  1.00  0.00           H  
ATOM    809  N   ASN A  69     -28.915  53.244  16.172  1.00  0.00           N  
ATOM    810  CA  ASN A  69     -29.344  53.346  17.573  1.00  0.00           C  
ATOM    811  C   ASN A  69     -28.931  52.114  18.409  1.00  0.00           C  
ATOM    812  O   ASN A  69     -29.766  51.442  19.021  1.00  0.00           O  
ATOM    813  CB  ASN A  69     -30.848  53.696  17.628  1.00  0.00           C  
ATOM    814  CG  ASN A  69     -31.150  55.150  17.348  1.00  0.00           C  
ATOM    815  OD1 ASN A  69     -30.566  56.064  17.917  1.00  0.00           O  
ATOM    816  ND2 ASN A  69     -32.138  55.415  16.529  1.00  0.00           N  
ATOM    817  H   ASN A  69     -28.255  53.927  15.835  1.00  0.00           H  
ATOM    818  HA  ASN A  69     -28.798  54.178  18.018  1.00  0.00           H  
ATOM    819  HB2 ASN A  69     -31.392  53.062  16.932  1.00  0.00           H  
ATOM    820  HB3 ASN A  69     -31.251  53.529  18.620  1.00  0.00           H  
ATOM    821 HD21 ASN A  69     -32.643  54.669  16.074  1.00  0.00           H  
ATOM    822 HD22 ASN A  69     -32.415  56.373  16.440  1.00  0.00           H  
ATOM    823  N   LEU A  70     -27.623  51.826  18.423  1.00  0.00           N  
ATOM    824  CA  LEU A  70     -26.989  50.686  19.102  1.00  0.00           C  
ATOM    825  C   LEU A  70     -26.049  51.182  20.223  1.00  0.00           C  
ATOM    826  O   LEU A  70     -24.833  51.262  20.025  1.00  0.00           O  
ATOM    827  CB  LEU A  70     -26.265  49.775  18.086  1.00  0.00           C  
ATOM    828  CG  LEU A  70     -27.093  49.331  16.871  1.00  0.00           C  
ATOM    829  CD1 LEU A  70     -26.247  48.438  15.963  1.00  0.00           C  
ATOM    830  CD2 LEU A  70     -28.364  48.575  17.257  1.00  0.00           C  
ATOM    831  H   LEU A  70     -27.014  52.454  17.907  1.00  0.00           H  
ATOM    832  HA  LEU A  70     -27.759  50.077  19.578  1.00  0.00           H  
ATOM    833  HB2 LEU A  70     -25.383  50.294  17.711  1.00  0.00           H  
ATOM    834  HB3 LEU A  70     -25.917  48.887  18.616  1.00  0.00           H  
ATOM    835  HG  LEU A  70     -27.375  50.215  16.303  1.00  0.00           H  
ATOM    836 HD11 LEU A  70     -25.357  48.979  15.642  1.00  0.00           H  
ATOM    837 HD12 LEU A  70     -25.944  47.537  16.497  1.00  0.00           H  
ATOM    838 HD13 LEU A  70     -26.822  48.157  15.080  1.00  0.00           H  
ATOM    839 HD21 LEU A  70     -28.117  47.682  17.824  1.00  0.00           H  
ATOM    840 HD22 LEU A  70     -29.007  49.214  17.861  1.00  0.00           H  
ATOM    841 HD23 LEU A  70     -28.910  48.296  16.356  1.00  0.00           H  
ATOM    842  N   PRO A  71     -26.587  51.535  21.408  1.00  0.00           N  
ATOM    843  CA  PRO A  71     -25.824  52.136  22.510  1.00  0.00           C  
ATOM    844  C   PRO A  71     -24.801  51.187  23.167  1.00  0.00           C  
ATOM    845  O   PRO A  71     -23.999  51.621  23.994  1.00  0.00           O  
ATOM    846  CB  PRO A  71     -26.882  52.624  23.506  1.00  0.00           C  
ATOM    847  CG  PRO A  71     -28.053  51.672  23.279  1.00  0.00           C  
ATOM    848  CD  PRO A  71     -27.985  51.383  21.784  1.00  0.00           C  
ATOM    849  HA  PRO A  71     -25.273  53.000  22.135  1.00  0.00           H  
ATOM    850  HB2 PRO A  71     -26.532  52.594  24.540  1.00  0.00           H  
ATOM    851  HB3 PRO A  71     -27.185  53.638  23.243  1.00  0.00           H  
ATOM    852  HG2 PRO A  71     -27.886  50.743  23.824  1.00  0.00           H  
ATOM    853  HG3 PRO A  71     -29.007  52.120  23.557  1.00  0.00           H  
ATOM    854  HD2 PRO A  71     -28.345  50.369  21.597  1.00  0.00           H  
ATOM    855  HD3 PRO A  71     -28.594  52.101  21.235  1.00  0.00           H  
ATOM    856  N   ASP A  72     -24.791  49.907  22.779  1.00  0.00           N  
ATOM    857  CA  ASP A  72     -23.876  48.864  23.263  1.00  0.00           C  
ATOM    858  C   ASP A  72     -23.067  48.208  22.121  1.00  0.00           C  
ATOM    859  O   ASP A  72     -22.431  47.179  22.341  1.00  0.00           O  
ATOM    860  CB  ASP A  72     -24.677  47.815  24.058  1.00  0.00           C  
ATOM    861  CG  ASP A  72     -25.371  48.404  25.296  1.00  0.00           C  
ATOM    862  OD1 ASP A  72     -24.679  48.683  26.305  1.00  0.00           O  
ATOM    863  OD2 ASP A  72     -26.616  48.558  25.280  1.00  0.00           O  
ATOM    864  H   ASP A  72     -25.503  49.621  22.124  1.00  0.00           H  
ATOM    865  HA  ASP A  72     -23.151  49.310  23.947  1.00  0.00           H  
ATOM    866  HB2 ASP A  72     -25.414  47.354  23.398  1.00  0.00           H  
ATOM    867  HB3 ASP A  72     -24.001  47.026  24.394  1.00  0.00           H  
ATOM    868  N   TYR A  73     -23.061  48.776  20.903  1.00  0.00           N  
ATOM    869  CA  TYR A  73     -22.408  48.182  19.720  1.00  0.00           C  
ATOM    870  C   TYR A  73     -20.964  47.713  19.992  1.00  0.00           C  
ATOM    871  O   TYR A  73     -20.637  46.534  19.834  1.00  0.00           O  
ATOM    872  CB  TYR A  73     -22.443  49.178  18.553  1.00  0.00           C  
ATOM    873  CG  TYR A  73     -21.789  48.657  17.285  1.00  0.00           C  
ATOM    874  CD1 TYR A  73     -22.404  47.631  16.542  1.00  0.00           C  
ATOM    875  CD2 TYR A  73     -20.546  49.174  16.871  1.00  0.00           C  
ATOM    876  CE1 TYR A  73     -21.773  47.112  15.393  1.00  0.00           C  
ATOM    877  CE2 TYR A  73     -19.913  48.662  15.724  1.00  0.00           C  
ATOM    878  CZ  TYR A  73     -20.519  47.621  14.988  1.00  0.00           C  
ATOM    879  OH  TYR A  73     -19.881  47.102  13.903  1.00  0.00           O  
ATOM    880  H   TYR A  73     -23.582  49.635  20.774  1.00  0.00           H  
ATOM    881  HA  TYR A  73     -22.997  47.323  19.407  1.00  0.00           H  
ATOM    882  HB2 TYR A  73     -23.479  49.408  18.327  1.00  0.00           H  
ATOM    883  HB3 TYR A  73     -21.959  50.108  18.856  1.00  0.00           H  
ATOM    884  HD1 TYR A  73     -23.359  47.228  16.859  1.00  0.00           H  
ATOM    885  HD2 TYR A  73     -20.070  49.960  17.441  1.00  0.00           H  
ATOM    886  HE1 TYR A  73     -22.242  46.316  14.832  1.00  0.00           H  
ATOM    887  HE2 TYR A  73     -18.958  49.054  15.408  1.00  0.00           H  
ATOM    888  HH  TYR A  73     -20.381  46.381  13.506  1.00  0.00           H  
ATOM    889  N   HIS A  74     -20.113  48.623  20.482  1.00  0.00           N  
ATOM    890  CA  HIS A  74     -18.699  48.366  20.801  1.00  0.00           C  
ATOM    891  C   HIS A  74     -18.477  47.535  22.081  1.00  0.00           C  
ATOM    892  O   HIS A  74     -17.360  47.076  22.325  1.00  0.00           O  
ATOM    893  CB  HIS A  74     -17.960  49.710  20.901  1.00  0.00           C  
ATOM    894  CG  HIS A  74     -17.851  50.445  19.585  1.00  0.00           C  
ATOM    895  ND1 HIS A  74     -17.023  50.083  18.518  1.00  0.00           N  
ATOM    896  CD2 HIS A  74     -18.523  51.587  19.254  1.00  0.00           C  
ATOM    897  CE1 HIS A  74     -17.215  51.015  17.568  1.00  0.00           C  
ATOM    898  NE2 HIS A  74     -18.109  51.929  17.984  1.00  0.00           N  
ATOM    899  H   HIS A  74     -20.462  49.565  20.596  1.00  0.00           H  
ATOM    900  HA  HIS A  74     -18.250  47.795  19.986  1.00  0.00           H  
ATOM    901  HB2 HIS A  74     -18.474  50.350  21.620  1.00  0.00           H  
ATOM    902  HB3 HIS A  74     -16.947  49.537  21.265  1.00  0.00           H  
ATOM    903  HD2 HIS A  74     -19.229  52.122  19.878  1.00  0.00           H  
ATOM    904  HE1 HIS A  74     -16.720  51.033  16.604  1.00  0.00           H  
ATOM    905  HE2 HIS A  74     -18.413  52.736  17.446  1.00  0.00           H  
ATOM    906  N   LYS A  75     -19.509  47.329  22.916  1.00  0.00           N  
ATOM    907  CA  LYS A  75     -19.451  46.451  24.100  1.00  0.00           C  
ATOM    908  C   LYS A  75     -19.428  44.967  23.708  1.00  0.00           C  
ATOM    909  O   LYS A  75     -18.752  44.173  24.365  1.00  0.00           O  
ATOM    910  CB  LYS A  75     -20.642  46.729  25.035  1.00  0.00           C  
ATOM    911  CG  LYS A  75     -20.884  48.205  25.399  1.00  0.00           C  
ATOM    912  CD  LYS A  75     -19.747  48.857  26.196  1.00  0.00           C  
ATOM    913  CE  LYS A  75     -18.653  49.522  25.348  1.00  0.00           C  
ATOM    914  NZ  LYS A  75     -19.107  50.815  24.768  1.00  0.00           N  
ATOM    915  H   LYS A  75     -20.407  47.735  22.684  1.00  0.00           H  
ATOM    916  HA  LYS A  75     -18.526  46.642  24.646  1.00  0.00           H  
ATOM    917  HB2 LYS A  75     -21.552  46.352  24.577  1.00  0.00           H  
ATOM    918  HB3 LYS A  75     -20.496  46.162  25.957  1.00  0.00           H  
ATOM    919  HG2 LYS A  75     -21.086  48.786  24.501  1.00  0.00           H  
ATOM    920  HG3 LYS A  75     -21.782  48.236  26.018  1.00  0.00           H  
ATOM    921  HD2 LYS A  75     -20.188  49.613  26.844  1.00  0.00           H  
ATOM    922  HD3 LYS A  75     -19.288  48.096  26.825  1.00  0.00           H  
ATOM    923  HE2 LYS A  75     -17.788  49.705  25.992  1.00  0.00           H  
ATOM    924  HE3 LYS A  75     -18.337  48.837  24.558  1.00  0.00           H  
ATOM    925  HZ1 LYS A  75     -19.907  50.696  24.163  1.00  0.00           H  
ATOM    926  HZ2 LYS A  75     -19.369  51.465  25.499  1.00  0.00           H  
ATOM    927  HZ3 LYS A  75     -18.368  51.253  24.234  1.00  0.00           H  
ATOM    928  N   ILE A  76     -20.130  44.600  22.627  1.00  0.00           N  
ATOM    929  CA  ILE A  76     -20.129  43.247  22.047  1.00  0.00           C  
ATOM    930  C   ILE A  76     -19.060  43.121  20.951  1.00  0.00           C  
ATOM    931  O   ILE A  76     -18.301  42.152  20.947  1.00  0.00           O  
ATOM    932  CB  ILE A  76     -21.529  42.888  21.494  1.00  0.00           C  
ATOM    933  CG1 ILE A  76     -22.600  42.752  22.601  1.00  0.00           C  
ATOM    934  CG2 ILE A  76     -21.499  41.554  20.722  1.00  0.00           C  
ATOM    935  CD1 ILE A  76     -23.316  44.061  22.927  1.00  0.00           C  
ATOM    936  H   ILE A  76     -20.698  45.311  22.185  1.00  0.00           H  
ATOM    937  HA  ILE A  76     -19.886  42.521  22.825  1.00  0.00           H  
ATOM    938  HB  ILE A  76     -21.833  43.670  20.800  1.00  0.00           H  
ATOM    939 HG12 ILE A  76     -23.374  42.057  22.274  1.00  0.00           H  
ATOM    940 HG13 ILE A  76     -22.148  42.347  23.505  1.00  0.00           H  
ATOM    941 HG21 ILE A  76     -20.866  41.631  19.839  1.00  0.00           H  
ATOM    942 HG22 ILE A  76     -21.126  40.757  21.367  1.00  0.00           H  
ATOM    943 HG23 ILE A  76     -22.501  41.294  20.378  1.00  0.00           H  
ATOM    944 HD11 ILE A  76     -22.631  44.752  23.408  1.00  0.00           H  
ATOM    945 HD12 ILE A  76     -23.704  44.500  22.007  1.00  0.00           H  
ATOM    946 HD13 ILE A  76     -24.145  43.862  23.606  1.00  0.00           H  
ATOM    947  N   ILE A  77     -18.985  44.081  20.023  1.00  0.00           N  
ATOM    948  CA  ILE A  77     -18.035  44.052  18.900  1.00  0.00           C  
ATOM    949  C   ILE A  77     -16.619  44.437  19.356  1.00  0.00           C  
ATOM    950  O   ILE A  77     -16.339  45.597  19.667  1.00  0.00           O  
ATOM    951  CB  ILE A  77     -18.516  44.947  17.735  1.00  0.00           C  
ATOM    952  CG1 ILE A  77     -19.884  44.511  17.167  1.00  0.00           C  
ATOM    953  CG2 ILE A  77     -17.474  44.958  16.602  1.00  0.00           C  
ATOM    954  CD1 ILE A  77     -19.973  43.044  16.737  1.00  0.00           C  
ATOM    955  H   ILE A  77     -19.640  44.855  20.073  1.00  0.00           H  
ATOM    956  HA  ILE A  77     -17.987  43.028  18.526  1.00  0.00           H  
ATOM    957  HB  ILE A  77     -18.618  45.972  18.094  1.00  0.00           H  
ATOM    958 HG12 ILE A  77     -20.666  44.701  17.903  1.00  0.00           H  
ATOM    959 HG13 ILE A  77     -20.106  45.129  16.300  1.00  0.00           H  
ATOM    960 HG21 ILE A  77     -16.607  45.537  16.909  1.00  0.00           H  
ATOM    961 HG22 ILE A  77     -17.152  43.947  16.354  1.00  0.00           H  
ATOM    962 HG23 ILE A  77     -17.896  45.426  15.713  1.00  0.00           H  
ATOM    963 HD11 ILE A  77     -19.052  42.721  16.268  1.00  0.00           H  
ATOM    964 HD12 ILE A  77     -20.168  42.409  17.602  1.00  0.00           H  
ATOM    965 HD13 ILE A  77     -20.776  42.937  16.009  1.00  0.00           H  
ATOM    966  N   LYS A  78     -15.708  43.454  19.356  1.00  0.00           N  
ATOM    967  CA  LYS A  78     -14.274  43.634  19.650  1.00  0.00           C  
ATOM    968  C   LYS A  78     -13.524  44.373  18.531  1.00  0.00           C  
ATOM    969  O   LYS A  78     -12.601  45.139  18.809  1.00  0.00           O  
ATOM    970  CB  LYS A  78     -13.610  42.257  19.866  1.00  0.00           C  
ATOM    971  CG  LYS A  78     -13.806  41.633  21.260  1.00  0.00           C  
ATOM    972  CD  LYS A  78     -15.267  41.357  21.648  1.00  0.00           C  
ATOM    973  CE  LYS A  78     -15.402  40.601  22.976  1.00  0.00           C  
ATOM    974  NZ  LYS A  78     -14.953  39.187  22.874  1.00  0.00           N  
ATOM    975  H   LYS A  78     -16.037  42.524  19.132  1.00  0.00           H  
ATOM    976  HA  LYS A  78     -14.154  44.233  20.555  1.00  0.00           H  
ATOM    977  HB2 LYS A  78     -13.959  41.563  19.099  1.00  0.00           H  
ATOM    978  HB3 LYS A  78     -12.533  42.368  19.727  1.00  0.00           H  
ATOM    979  HG2 LYS A  78     -13.252  40.693  21.275  1.00  0.00           H  
ATOM    980  HG3 LYS A  78     -13.365  42.295  22.006  1.00  0.00           H  
ATOM    981  HD2 LYS A  78     -15.777  42.312  21.767  1.00  0.00           H  
ATOM    982  HD3 LYS A  78     -15.762  40.792  20.856  1.00  0.00           H  
ATOM    983  HE2 LYS A  78     -14.823  41.125  23.743  1.00  0.00           H  
ATOM    984  HE3 LYS A  78     -16.452  40.624  23.278  1.00  0.00           H  
ATOM    985  HZ1 LYS A  78     -15.486  38.683  22.176  1.00  0.00           H  
ATOM    986  HZ2 LYS A  78     -13.974  39.124  22.628  1.00  0.00           H  
ATOM    987  HZ3 LYS A  78     -15.076  38.704  23.755  1.00  0.00           H  
ATOM    988  N   ASN A  79     -13.904  44.124  17.276  1.00  0.00           N  
ATOM    989  CA  ASN A  79     -13.185  44.538  16.072  1.00  0.00           C  
ATOM    990  C   ASN A  79     -14.153  44.835  14.900  1.00  0.00           C  
ATOM    991  O   ASN A  79     -14.405  43.971  14.055  1.00  0.00           O  
ATOM    992  CB  ASN A  79     -12.109  43.477  15.743  1.00  0.00           C  
ATOM    993  CG  ASN A  79     -12.555  42.013  15.796  1.00  0.00           C  
ATOM    994  OD1 ASN A  79     -13.723  41.651  15.833  1.00  0.00           O  
ATOM    995  ND2 ASN A  79     -11.608  41.106  15.852  1.00  0.00           N  
ATOM    996  H   ASN A  79     -14.630  43.435  17.143  1.00  0.00           H  
ATOM    997  HA  ASN A  79     -12.667  45.478  16.280  1.00  0.00           H  
ATOM    998  HB2 ASN A  79     -11.693  43.676  14.756  1.00  0.00           H  
ATOM    999  HB3 ASN A  79     -11.299  43.595  16.462  1.00  0.00           H  
ATOM   1000 HD21 ASN A  79     -10.637  41.381  15.848  1.00  0.00           H  
ATOM   1001 HD22 ASN A  79     -11.876  40.135  15.898  1.00  0.00           H  
ATOM   1002  N   PRO A  80     -14.729  46.051  14.851  1.00  0.00           N  
ATOM   1003  CA  PRO A  80     -15.696  46.444  13.828  1.00  0.00           C  
ATOM   1004  C   PRO A  80     -15.019  46.578  12.456  1.00  0.00           C  
ATOM   1005  O   PRO A  80     -13.960  47.198  12.320  1.00  0.00           O  
ATOM   1006  CB  PRO A  80     -16.290  47.767  14.325  1.00  0.00           C  
ATOM   1007  CG  PRO A  80     -15.165  48.369  15.167  1.00  0.00           C  
ATOM   1008  CD  PRO A  80     -14.447  47.163  15.748  1.00  0.00           C  
ATOM   1009  HA  PRO A  80     -16.487  45.695  13.757  1.00  0.00           H  
ATOM   1010  HB2 PRO A  80     -16.581  48.425  13.505  1.00  0.00           H  
ATOM   1011  HB3 PRO A  80     -17.145  47.561  14.967  1.00  0.00           H  
ATOM   1012  HG2 PRO A  80     -14.484  48.922  14.522  1.00  0.00           H  
ATOM   1013  HG3 PRO A  80     -15.531  48.992  15.974  1.00  0.00           H  
ATOM   1014  HD2 PRO A  80     -13.379  47.379  15.799  1.00  0.00           H  
ATOM   1015  HD3 PRO A  80     -14.833  46.947  16.745  1.00  0.00           H  
ATOM   1016  N   MET A  81     -15.628  45.971  11.436  1.00  0.00           N  
ATOM   1017  CA  MET A  81     -15.056  45.798  10.096  1.00  0.00           C  
ATOM   1018  C   MET A  81     -16.176  45.612   9.059  1.00  0.00           C  
ATOM   1019  O   MET A  81     -17.091  44.816   9.281  1.00  0.00           O  
ATOM   1020  CB  MET A  81     -14.145  44.558  10.139  1.00  0.00           C  
ATOM   1021  CG  MET A  81     -13.322  44.294   8.875  1.00  0.00           C  
ATOM   1022  SD  MET A  81     -11.834  45.312   8.660  1.00  0.00           S  
ATOM   1023  CE  MET A  81     -12.480  46.686   7.680  1.00  0.00           C  
ATOM   1024  H   MET A  81     -16.507  45.507  11.620  1.00  0.00           H  
ATOM   1025  HA  MET A  81     -14.465  46.677   9.840  1.00  0.00           H  
ATOM   1026  HB2 MET A  81     -13.448  44.650  10.974  1.00  0.00           H  
ATOM   1027  HB3 MET A  81     -14.765  43.681  10.329  1.00  0.00           H  
ATOM   1028  HG2 MET A  81     -12.976  43.268   8.956  1.00  0.00           H  
ATOM   1029  HG3 MET A  81     -13.951  44.357   7.988  1.00  0.00           H  
ATOM   1030  HE1 MET A  81     -13.093  46.300   6.868  1.00  0.00           H  
ATOM   1031  HE2 MET A  81     -13.074  47.347   8.309  1.00  0.00           H  
ATOM   1032  HE3 MET A  81     -11.647  47.250   7.260  1.00  0.00           H  
ATOM   1033  N   ASP A  82     -16.091  46.319   7.928  1.00  0.00           N  
ATOM   1034  CA  ASP A  82     -17.091  46.333   6.847  1.00  0.00           C  
ATOM   1035  C   ASP A  82     -16.421  46.511   5.468  1.00  0.00           C  
ATOM   1036  O   ASP A  82     -15.363  47.140   5.366  1.00  0.00           O  
ATOM   1037  CB  ASP A  82     -18.102  47.466   7.087  1.00  0.00           C  
ATOM   1038  CG  ASP A  82     -19.043  47.167   8.265  1.00  0.00           C  
ATOM   1039  OD1 ASP A  82     -20.013  46.396   8.070  1.00  0.00           O  
ATOM   1040  OD2 ASP A  82     -18.825  47.719   9.371  1.00  0.00           O  
ATOM   1041  H   ASP A  82     -15.290  46.922   7.800  1.00  0.00           H  
ATOM   1042  HA  ASP A  82     -17.637  45.390   6.843  1.00  0.00           H  
ATOM   1043  HB2 ASP A  82     -17.566  48.403   7.256  1.00  0.00           H  
ATOM   1044  HB3 ASP A  82     -18.707  47.594   6.187  1.00  0.00           H  
ATOM   1045  N   MET A  83     -17.033  45.978   4.401  1.00  0.00           N  
ATOM   1046  CA  MET A  83     -16.455  45.869   3.049  1.00  0.00           C  
ATOM   1047  C   MET A  83     -15.999  47.218   2.473  1.00  0.00           C  
ATOM   1048  O   MET A  83     -14.951  47.297   1.828  1.00  0.00           O  
ATOM   1049  CB  MET A  83     -17.468  45.189   2.102  1.00  0.00           C  
ATOM   1050  CG  MET A  83     -16.771  44.633   0.856  1.00  0.00           C  
ATOM   1051  SD  MET A  83     -17.687  43.379  -0.093  1.00  0.00           S  
ATOM   1052  CE  MET A  83     -19.362  44.077  -0.169  1.00  0.00           C  
ATOM   1053  H   MET A  83     -17.905  45.493   4.559  1.00  0.00           H  
ATOM   1054  HA  MET A  83     -15.581  45.222   3.118  1.00  0.00           H  
ATOM   1055  HB2 MET A  83     -17.965  44.361   2.604  1.00  0.00           H  
ATOM   1056  HB3 MET A  83     -18.234  45.903   1.799  1.00  0.00           H  
ATOM   1057  HG2 MET A  83     -16.513  45.462   0.199  1.00  0.00           H  
ATOM   1058  HG3 MET A  83     -15.842  44.165   1.180  1.00  0.00           H  
ATOM   1059  HE1 MET A  83     -19.775  44.158   0.835  1.00  0.00           H  
ATOM   1060  HE2 MET A  83     -19.346  45.061  -0.631  1.00  0.00           H  
ATOM   1061  HE3 MET A  83     -19.999  43.414  -0.754  1.00  0.00           H  
ATOM   1062  N   GLY A  84     -16.750  48.288   2.759  1.00  0.00           N  
ATOM   1063  CA  GLY A  84     -16.418  49.672   2.399  1.00  0.00           C  
ATOM   1064  C   GLY A  84     -15.087  50.181   2.964  1.00  0.00           C  
ATOM   1065  O   GLY A  84     -14.460  51.054   2.361  1.00  0.00           O  
ATOM   1066  H   GLY A  84     -17.618  48.120   3.258  1.00  0.00           H  
ATOM   1067  HA2 GLY A  84     -16.393  49.768   1.313  1.00  0.00           H  
ATOM   1068  HA3 GLY A  84     -17.199  50.323   2.786  1.00  0.00           H  
ATOM   1069  N   THR A  85     -14.624  49.617   4.084  1.00  0.00           N  
ATOM   1070  CA  THR A  85     -13.319  49.920   4.693  1.00  0.00           C  
ATOM   1071  C   THR A  85     -12.230  48.953   4.211  1.00  0.00           C  
ATOM   1072  O   THR A  85     -11.095  49.387   4.012  1.00  0.00           O  
ATOM   1073  CB  THR A  85     -13.420  49.893   6.229  1.00  0.00           C  
ATOM   1074  OG1 THR A  85     -14.451  50.756   6.666  1.00  0.00           O  
ATOM   1075  CG2 THR A  85     -12.141  50.362   6.924  1.00  0.00           C  
ATOM   1076  H   THR A  85     -15.194  48.907   4.530  1.00  0.00           H  
ATOM   1077  HA  THR A  85     -13.012  50.927   4.408  1.00  0.00           H  
ATOM   1078  HB  THR A  85     -13.655  48.880   6.554  1.00  0.00           H  
ATOM   1079  HG1 THR A  85     -14.470  50.713   7.630  1.00  0.00           H  
ATOM   1080 HG21 THR A  85     -11.321  49.682   6.700  1.00  0.00           H  
ATOM   1081 HG22 THR A  85     -11.877  51.365   6.585  1.00  0.00           H  
ATOM   1082 HG23 THR A  85     -12.289  50.373   8.004  1.00  0.00           H  
ATOM   1083  N   ILE A  86     -12.559  47.678   3.940  1.00  0.00           N  
ATOM   1084  CA  ILE A  86     -11.615  46.695   3.359  1.00  0.00           C  
ATOM   1085  C   ILE A  86     -11.051  47.212   2.026  1.00  0.00           C  
ATOM   1086  O   ILE A  86      -9.832  47.280   1.843  1.00  0.00           O  
ATOM   1087  CB  ILE A  86     -12.255  45.294   3.165  1.00  0.00           C  
ATOM   1088  CG1 ILE A  86     -12.880  44.757   4.472  1.00  0.00           C  
ATOM   1089  CG2 ILE A  86     -11.194  44.307   2.637  1.00  0.00           C  
ATOM   1090  CD1 ILE A  86     -13.521  43.373   4.360  1.00  0.00           C  
ATOM   1091  H   ILE A  86     -13.513  47.385   4.117  1.00  0.00           H  
ATOM   1092  HA  ILE A  86     -10.776  46.581   4.048  1.00  0.00           H  
ATOM   1093  HB  ILE A  86     -13.047  45.370   2.418  1.00  0.00           H  
ATOM   1094 HG12 ILE A  86     -12.123  44.734   5.254  1.00  0.00           H  
ATOM   1095 HG13 ILE A  86     -13.667  45.434   4.786  1.00  0.00           H  
ATOM   1096 HG21 ILE A  86     -10.759  44.658   1.702  1.00  0.00           H  
ATOM   1097 HG22 ILE A  86     -10.401  44.175   3.373  1.00  0.00           H  
ATOM   1098 HG23 ILE A  86     -11.644  43.340   2.424  1.00  0.00           H  
ATOM   1099 HD11 ILE A  86     -14.205  43.351   3.512  1.00  0.00           H  
ATOM   1100 HD12 ILE A  86     -12.753  42.612   4.231  1.00  0.00           H  
ATOM   1101 HD13 ILE A  86     -14.074  43.157   5.274  1.00  0.00           H  
ATOM   1102  N   LYS A  87     -11.927  47.645   1.106  1.00  0.00           N  
ATOM   1103  CA  LYS A  87     -11.507  48.220  -0.184  1.00  0.00           C  
ATOM   1104  C   LYS A  87     -10.678  49.502  -0.042  1.00  0.00           C  
ATOM   1105  O   LYS A  87      -9.757  49.724  -0.823  1.00  0.00           O  
ATOM   1106  CB  LYS A  87     -12.717  48.403  -1.113  1.00  0.00           C  
ATOM   1107  CG  LYS A  87     -13.678  49.526  -0.693  1.00  0.00           C  
ATOM   1108  CD  LYS A  87     -14.946  49.550  -1.554  1.00  0.00           C  
ATOM   1109  CE  LYS A  87     -14.715  49.844  -3.043  1.00  0.00           C  
ATOM   1110  NZ  LYS A  87     -14.208  51.219  -3.279  1.00  0.00           N  
ATOM   1111  H   LYS A  87     -12.919  47.538   1.303  1.00  0.00           H  
ATOM   1112  HA  LYS A  87     -10.849  47.498  -0.664  1.00  0.00           H  
ATOM   1113  HB2 LYS A  87     -12.345  48.611  -2.117  1.00  0.00           H  
ATOM   1114  HB3 LYS A  87     -13.268  47.463  -1.144  1.00  0.00           H  
ATOM   1115  HG2 LYS A  87     -13.976  49.362   0.341  1.00  0.00           H  
ATOM   1116  HG3 LYS A  87     -13.179  50.493  -0.757  1.00  0.00           H  
ATOM   1117  HD2 LYS A  87     -15.419  48.571  -1.477  1.00  0.00           H  
ATOM   1118  HD3 LYS A  87     -15.637  50.288  -1.147  1.00  0.00           H  
ATOM   1119  HE2 LYS A  87     -14.015  49.110  -3.451  1.00  0.00           H  
ATOM   1120  HE3 LYS A  87     -15.669  49.716  -3.565  1.00  0.00           H  
ATOM   1121  HZ1 LYS A  87     -14.816  51.914  -2.870  1.00  0.00           H  
ATOM   1122  HZ2 LYS A  87     -13.269  51.354  -2.895  1.00  0.00           H  
ATOM   1123  HZ3 LYS A  87     -14.141  51.414  -4.269  1.00  0.00           H  
ATOM   1124  N   LYS A  88     -10.948  50.323   0.980  1.00  0.00           N  
ATOM   1125  CA  LYS A  88     -10.278  51.618   1.187  1.00  0.00           C  
ATOM   1126  C   LYS A  88      -8.791  51.489   1.541  1.00  0.00           C  
ATOM   1127  O   LYS A  88      -8.009  52.365   1.168  1.00  0.00           O  
ATOM   1128  CB  LYS A  88     -11.086  52.441   2.212  1.00  0.00           C  
ATOM   1129  CG  LYS A  88     -10.912  53.971   2.132  1.00  0.00           C  
ATOM   1130  CD  LYS A  88     -11.739  54.692   1.051  1.00  0.00           C  
ATOM   1131  CE  LYS A  88     -11.329  54.315  -0.374  1.00  0.00           C  
ATOM   1132  NZ  LYS A  88     -11.977  55.159  -1.407  1.00  0.00           N  
ATOM   1133  H   LYS A  88     -11.695  50.056   1.607  1.00  0.00           H  
ATOM   1134  HA  LYS A  88     -10.287  52.126   0.228  1.00  0.00           H  
ATOM   1135  HB2 LYS A  88     -12.148  52.229   2.090  1.00  0.00           H  
ATOM   1136  HB3 LYS A  88     -10.805  52.111   3.214  1.00  0.00           H  
ATOM   1137  HG2 LYS A  88     -11.244  54.378   3.086  1.00  0.00           H  
ATOM   1138  HG3 LYS A  88      -9.858  54.218   2.013  1.00  0.00           H  
ATOM   1139  HD2 LYS A  88     -12.798  54.466   1.196  1.00  0.00           H  
ATOM   1140  HD3 LYS A  88     -11.599  55.766   1.183  1.00  0.00           H  
ATOM   1141  HE2 LYS A  88     -10.242  54.402  -0.462  1.00  0.00           H  
ATOM   1142  HE3 LYS A  88     -11.606  53.273  -0.553  1.00  0.00           H  
ATOM   1143  HZ1 LYS A  88     -12.983  55.089  -1.369  1.00  0.00           H  
ATOM   1144  HZ2 LYS A  88     -11.716  56.131  -1.312  1.00  0.00           H  
ATOM   1145  HZ3 LYS A  88     -11.673  54.839  -2.327  1.00  0.00           H  
ATOM   1146  N   ARG A  89      -8.370  50.380   2.166  1.00  0.00           N  
ATOM   1147  CA  ARG A  89      -6.943  50.042   2.359  1.00  0.00           C  
ATOM   1148  C   ARG A  89      -6.302  49.335   1.151  1.00  0.00           C  
ATOM   1149  O   ARG A  89      -5.133  49.597   0.872  1.00  0.00           O  
ATOM   1150  CB  ARG A  89      -6.706  49.322   3.695  1.00  0.00           C  
ATOM   1151  CG  ARG A  89      -7.641  48.144   3.974  1.00  0.00           C  
ATOM   1152  CD  ARG A  89      -7.323  47.498   5.321  1.00  0.00           C  
ATOM   1153  NE  ARG A  89      -7.753  48.357   6.441  1.00  0.00           N  
ATOM   1154  CZ  ARG A  89      -8.498  48.011   7.471  1.00  0.00           C  
ATOM   1155  NH1 ARG A  89      -8.826  46.782   7.734  1.00  0.00           N  
ATOM   1156  NH2 ARG A  89      -8.943  48.939   8.264  1.00  0.00           N  
ATOM   1157  H   ARG A  89      -9.075  49.724   2.479  1.00  0.00           H  
ATOM   1158  HA  ARG A  89      -6.392  50.979   2.443  1.00  0.00           H  
ATOM   1159  HB2 ARG A  89      -5.677  48.965   3.721  1.00  0.00           H  
ATOM   1160  HB3 ARG A  89      -6.823  50.047   4.496  1.00  0.00           H  
ATOM   1161  HG2 ARG A  89      -8.677  48.476   3.987  1.00  0.00           H  
ATOM   1162  HG3 ARG A  89      -7.524  47.408   3.186  1.00  0.00           H  
ATOM   1163  HD2 ARG A  89      -7.848  46.546   5.352  1.00  0.00           H  
ATOM   1164  HD3 ARG A  89      -6.251  47.308   5.388  1.00  0.00           H  
ATOM   1165  HE  ARG A  89      -7.520  49.341   6.394  1.00  0.00           H  
ATOM   1166 HH11 ARG A  89      -8.440  46.025   7.167  1.00  0.00           H  
ATOM   1167 HH12 ARG A  89      -9.382  46.554   8.536  1.00  0.00           H  
ATOM   1168 HH21 ARG A  89      -8.696  49.900   8.052  1.00  0.00           H  
ATOM   1169 HH22 ARG A  89      -9.565  48.712   9.020  1.00  0.00           H  
ATOM   1170  N   LEU A  90      -7.050  48.531   0.384  1.00  0.00           N  
ATOM   1171  CA  LEU A  90      -6.605  48.013  -0.931  1.00  0.00           C  
ATOM   1172  C   LEU A  90      -6.343  49.126  -1.970  1.00  0.00           C  
ATOM   1173  O   LEU A  90      -5.443  49.008  -2.801  1.00  0.00           O  
ATOM   1174  CB  LEU A  90      -7.650  47.053  -1.526  1.00  0.00           C  
ATOM   1175  CG  LEU A  90      -7.825  45.707  -0.808  1.00  0.00           C  
ATOM   1176  CD1 LEU A  90      -9.050  44.969  -1.340  1.00  0.00           C  
ATOM   1177  CD2 LEU A  90      -6.607  44.800  -1.003  1.00  0.00           C  
ATOM   1178  H   LEU A  90      -7.943  48.234   0.751  1.00  0.00           H  
ATOM   1179  HA  LEU A  90      -5.663  47.481  -0.799  1.00  0.00           H  
ATOM   1180  HB2 LEU A  90      -8.608  47.567  -1.561  1.00  0.00           H  
ATOM   1181  HB3 LEU A  90      -7.355  46.850  -2.553  1.00  0.00           H  
ATOM   1182  HG  LEU A  90      -7.994  45.897   0.248  1.00  0.00           H  
ATOM   1183 HD11 LEU A  90      -9.868  45.671  -1.478  1.00  0.00           H  
ATOM   1184 HD12 LEU A  90      -8.836  44.483  -2.288  1.00  0.00           H  
ATOM   1185 HD13 LEU A  90      -9.362  44.213  -0.623  1.00  0.00           H  
ATOM   1186 HD21 LEU A  90      -6.461  44.580  -2.061  1.00  0.00           H  
ATOM   1187 HD22 LEU A  90      -5.717  45.296  -0.627  1.00  0.00           H  
ATOM   1188 HD23 LEU A  90      -6.740  43.875  -0.450  1.00  0.00           H  
ATOM   1189  N   GLU A  91      -7.110  50.221  -1.926  1.00  0.00           N  
ATOM   1190  CA  GLU A  91      -6.907  51.447  -2.729  1.00  0.00           C  
ATOM   1191  C   GLU A  91      -5.629  52.238  -2.352  1.00  0.00           C  
ATOM   1192  O   GLU A  91      -5.339  53.291  -2.928  1.00  0.00           O  
ATOM   1193  CB  GLU A  91      -8.164  52.332  -2.611  1.00  0.00           C  
ATOM   1194  CG  GLU A  91      -9.325  51.771  -3.447  1.00  0.00           C  
ATOM   1195  CD  GLU A  91     -10.634  52.541  -3.190  1.00  0.00           C  
ATOM   1196  OE1 GLU A  91     -10.713  53.752  -3.508  1.00  0.00           O  
ATOM   1197  OE2 GLU A  91     -11.604  51.946  -2.663  1.00  0.00           O  
ATOM   1198  H   GLU A  91      -7.915  50.195  -1.309  1.00  0.00           H  
ATOM   1199  HA  GLU A  91      -6.787  51.163  -3.776  1.00  0.00           H  
ATOM   1200  HB2 GLU A  91      -8.465  52.402  -1.566  1.00  0.00           H  
ATOM   1201  HB3 GLU A  91      -7.945  53.337  -2.973  1.00  0.00           H  
ATOM   1202  HG2 GLU A  91      -9.060  51.841  -4.504  1.00  0.00           H  
ATOM   1203  HG3 GLU A  91      -9.463  50.715  -3.217  1.00  0.00           H  
ATOM   1204  N   ASN A  92      -4.853  51.720  -1.400  1.00  0.00           N  
ATOM   1205  CA  ASN A  92      -3.633  52.276  -0.818  1.00  0.00           C  
ATOM   1206  C   ASN A  92      -2.557  51.173  -0.645  1.00  0.00           C  
ATOM   1207  O   ASN A  92      -2.695  50.054  -1.148  1.00  0.00           O  
ATOM   1208  CB  ASN A  92      -4.049  52.933   0.511  1.00  0.00           C  
ATOM   1209  CG  ASN A  92      -4.742  54.270   0.311  1.00  0.00           C  
ATOM   1210  OD1 ASN A  92      -4.114  55.264  -0.029  1.00  0.00           O  
ATOM   1211  ND2 ASN A  92      -6.036  54.361   0.515  1.00  0.00           N  
ATOM   1212  H   ASN A  92      -5.153  50.839  -1.008  1.00  0.00           H  
ATOM   1213  HA  ASN A  92      -3.212  53.040  -1.473  1.00  0.00           H  
ATOM   1214  HB2 ASN A  92      -4.702  52.253   1.055  1.00  0.00           H  
ATOM   1215  HB3 ASN A  92      -3.181  53.120   1.133  1.00  0.00           H  
ATOM   1216 HD21 ASN A  92      -6.575  53.551   0.808  1.00  0.00           H  
ATOM   1217 HD22 ASN A  92      -6.482  55.252   0.373  1.00  0.00           H  
ATOM   1218  N   ASN A  93      -1.466  51.483   0.065  1.00  0.00           N  
ATOM   1219  CA  ASN A  93      -0.325  50.588   0.315  1.00  0.00           C  
ATOM   1220  C   ASN A  93      -0.222  50.224   1.813  1.00  0.00           C  
ATOM   1221  O   ASN A  93       0.854  50.287   2.411  1.00  0.00           O  
ATOM   1222  CB  ASN A  93       0.947  51.250  -0.252  1.00  0.00           C  
ATOM   1223  CG  ASN A  93       0.909  51.400  -1.763  1.00  0.00           C  
ATOM   1224  OD1 ASN A  93       0.817  50.433  -2.506  1.00  0.00           O  
ATOM   1225  ND2 ASN A  93       0.990  52.609  -2.273  1.00  0.00           N  
ATOM   1226  H   ASN A  93      -1.410  52.416   0.448  1.00  0.00           H  
ATOM   1227  HA  ASN A  93      -0.472  49.646  -0.214  1.00  0.00           H  
ATOM   1228  HB2 ASN A  93       1.093  52.222   0.218  1.00  0.00           H  
ATOM   1229  HB3 ASN A  93       1.813  50.634  -0.013  1.00  0.00           H  
ATOM   1230 HD21 ASN A  93       1.079  53.414  -1.673  1.00  0.00           H  
ATOM   1231 HD22 ASN A  93       0.977  52.706  -3.278  1.00  0.00           H  
ATOM   1232  N   TYR A  94      -1.362  49.899   2.444  1.00  0.00           N  
ATOM   1233  CA  TYR A  94      -1.442  49.617   3.890  1.00  0.00           C  
ATOM   1234  C   TYR A  94      -0.636  48.359   4.277  1.00  0.00           C  
ATOM   1235  O   TYR A  94      -0.001  48.307   5.332  1.00  0.00           O  
ATOM   1236  CB  TYR A  94      -2.922  49.480   4.297  1.00  0.00           C  
ATOM   1237  CG  TYR A  94      -3.151  49.205   5.775  1.00  0.00           C  
ATOM   1238  CD1 TYR A  94      -3.056  47.886   6.259  1.00  0.00           C  
ATOM   1239  CD2 TYR A  94      -3.413  50.252   6.681  1.00  0.00           C  
ATOM   1240  CE1 TYR A  94      -3.179  47.608   7.633  1.00  0.00           C  
ATOM   1241  CE2 TYR A  94      -3.487  49.987   8.060  1.00  0.00           C  
ATOM   1242  CZ  TYR A  94      -3.379  48.668   8.543  1.00  0.00           C  
ATOM   1243  OH  TYR A  94      -3.463  48.423   9.877  1.00  0.00           O  
ATOM   1244  H   TYR A  94      -2.186  49.752   1.872  1.00  0.00           H  
ATOM   1245  HA  TYR A  94      -1.016  50.461   4.437  1.00  0.00           H  
ATOM   1246  HB2 TYR A  94      -3.448  50.398   4.025  1.00  0.00           H  
ATOM   1247  HB3 TYR A  94      -3.364  48.665   3.721  1.00  0.00           H  
ATOM   1248  HD1 TYR A  94      -2.860  47.082   5.569  1.00  0.00           H  
ATOM   1249  HD2 TYR A  94      -3.535  51.270   6.340  1.00  0.00           H  
ATOM   1250  HE1 TYR A  94      -3.097  46.593   7.992  1.00  0.00           H  
ATOM   1251  HE2 TYR A  94      -3.602  50.798   8.758  1.00  0.00           H  
ATOM   1252  HH  TYR A  94      -3.384  47.481  10.072  1.00  0.00           H  
ATOM   1253  N   TYR A  95      -0.639  47.364   3.388  1.00  0.00           N  
ATOM   1254  CA  TYR A  95       0.011  46.057   3.522  1.00  0.00           C  
ATOM   1255  C   TYR A  95       0.709  45.627   2.215  1.00  0.00           C  
ATOM   1256  O   TYR A  95       0.646  46.322   1.197  1.00  0.00           O  
ATOM   1257  CB  TYR A  95      -1.034  45.023   3.998  1.00  0.00           C  
ATOM   1258  CG  TYR A  95      -2.463  45.175   3.487  1.00  0.00           C  
ATOM   1259  CD1 TYR A  95      -2.726  45.569   2.161  1.00  0.00           C  
ATOM   1260  CD2 TYR A  95      -3.541  44.933   4.363  1.00  0.00           C  
ATOM   1261  CE1 TYR A  95      -4.048  45.720   1.717  1.00  0.00           C  
ATOM   1262  CE2 TYR A  95      -4.869  45.045   3.910  1.00  0.00           C  
ATOM   1263  CZ  TYR A  95      -5.120  45.416   2.577  1.00  0.00           C  
ATOM   1264  OH  TYR A  95      -6.394  45.468   2.129  1.00  0.00           O  
ATOM   1265  H   TYR A  95      -1.235  47.476   2.579  1.00  0.00           H  
ATOM   1266  HA  TYR A  95       0.793  46.117   4.280  1.00  0.00           H  
ATOM   1267  HB2 TYR A  95      -0.701  44.016   3.741  1.00  0.00           H  
ATOM   1268  HB3 TYR A  95      -1.065  45.081   5.086  1.00  0.00           H  
ATOM   1269  HD1 TYR A  95      -1.916  45.770   1.477  1.00  0.00           H  
ATOM   1270  HD2 TYR A  95      -3.344  44.671   5.391  1.00  0.00           H  
ATOM   1271  HE1 TYR A  95      -4.240  46.049   0.710  1.00  0.00           H  
ATOM   1272  HE2 TYR A  95      -5.703  44.859   4.571  1.00  0.00           H  
ATOM   1273  HH  TYR A  95      -7.024  45.201   2.805  1.00  0.00           H  
ATOM   1274  N   TRP A  96       1.397  44.481   2.248  1.00  0.00           N  
ATOM   1275  CA  TRP A  96       2.165  43.902   1.132  1.00  0.00           C  
ATOM   1276  C   TRP A  96       1.490  42.642   0.548  1.00  0.00           C  
ATOM   1277  O   TRP A  96       1.666  42.325  -0.632  1.00  0.00           O  
ATOM   1278  CB  TRP A  96       3.560  43.564   1.690  1.00  0.00           C  
ATOM   1279  CG  TRP A  96       4.702  43.416   0.728  1.00  0.00           C  
ATOM   1280  CD1 TRP A  96       4.823  42.465  -0.227  1.00  0.00           C  
ATOM   1281  CD2 TRP A  96       5.954  44.172   0.689  1.00  0.00           C  
ATOM   1282  NE1 TRP A  96       6.049  42.581  -0.851  1.00  0.00           N  
ATOM   1283  CE2 TRP A  96       6.808  43.586  -0.293  1.00  0.00           C  
ATOM   1284  CE3 TRP A  96       6.474  45.265   1.416  1.00  0.00           C  
ATOM   1285  CZ2 TRP A  96       8.119  44.032  -0.511  1.00  0.00           C  
ATOM   1286  CZ3 TRP A  96       7.782  45.739   1.187  1.00  0.00           C  
ATOM   1287  CH2 TRP A  96       8.608  45.118   0.234  1.00  0.00           C  
ATOM   1288  H   TRP A  96       1.454  44.004   3.137  1.00  0.00           H  
ATOM   1289  HA  TRP A  96       2.275  44.628   0.324  1.00  0.00           H  
ATOM   1290  HB2 TRP A  96       3.850  44.343   2.394  1.00  0.00           H  
ATOM   1291  HB3 TRP A  96       3.488  42.642   2.271  1.00  0.00           H  
ATOM   1292  HD1 TRP A  96       4.085  41.698  -0.440  1.00  0.00           H  
ATOM   1293  HE1 TRP A  96       6.360  41.953  -1.586  1.00  0.00           H  
ATOM   1294  HE3 TRP A  96       5.861  45.730   2.172  1.00  0.00           H  
ATOM   1295  HZ2 TRP A  96       8.745  43.540  -1.244  1.00  0.00           H  
ATOM   1296  HZ3 TRP A  96       8.161  46.576   1.761  1.00  0.00           H  
ATOM   1297  HH2 TRP A  96       9.619  45.475   0.077  1.00  0.00           H  
ATOM   1298  N   SER A  97       0.681  41.948   1.358  1.00  0.00           N  
ATOM   1299  CA  SER A  97       0.137  40.614   1.073  1.00  0.00           C  
ATOM   1300  C   SER A  97      -1.364  40.491   1.347  1.00  0.00           C  
ATOM   1301  O   SER A  97      -1.919  41.083   2.277  1.00  0.00           O  
ATOM   1302  CB  SER A  97       0.894  39.559   1.895  1.00  0.00           C  
ATOM   1303  OG  SER A  97       0.879  39.864   3.282  1.00  0.00           O  
ATOM   1304  H   SER A  97       0.546  42.287   2.299  1.00  0.00           H  
ATOM   1305  HA  SER A  97       0.295  40.383   0.020  1.00  0.00           H  
ATOM   1306  HB2 SER A  97       0.429  38.584   1.738  1.00  0.00           H  
ATOM   1307  HB3 SER A  97       1.929  39.518   1.550  1.00  0.00           H  
ATOM   1308  HG  SER A  97       1.412  39.197   3.739  1.00  0.00           H  
ATOM   1309  N   ALA A  98      -2.027  39.683   0.520  1.00  0.00           N  
ATOM   1310  CA  ALA A  98      -3.478  39.487   0.526  1.00  0.00           C  
ATOM   1311  C   ALA A  98      -4.031  38.727   1.741  1.00  0.00           C  
ATOM   1312  O   ALA A  98      -5.211  38.873   2.056  1.00  0.00           O  
ATOM   1313  CB  ALA A  98      -3.833  38.790  -0.783  1.00  0.00           C  
ATOM   1314  H   ALA A  98      -1.501  39.220  -0.209  1.00  0.00           H  
ATOM   1315  HA  ALA A  98      -3.964  40.462   0.534  1.00  0.00           H  
ATOM   1316  HB1 ALA A  98      -3.572  39.450  -1.610  1.00  0.00           H  
ATOM   1317  HB2 ALA A  98      -3.284  37.852  -0.870  1.00  0.00           H  
ATOM   1318  HB3 ALA A  98      -4.899  38.574  -0.809  1.00  0.00           H  
ATOM   1319  N   SER A  99      -3.198  37.972   2.467  1.00  0.00           N  
ATOM   1320  CA  SER A  99      -3.586  37.291   3.713  1.00  0.00           C  
ATOM   1321  C   SER A  99      -4.151  38.250   4.773  1.00  0.00           C  
ATOM   1322  O   SER A  99      -5.003  37.865   5.572  1.00  0.00           O  
ATOM   1323  CB  SER A  99      -2.385  36.543   4.305  1.00  0.00           C  
ATOM   1324  OG  SER A  99      -1.794  35.680   3.344  1.00  0.00           O  
ATOM   1325  H   SER A  99      -2.247  37.859   2.145  1.00  0.00           H  
ATOM   1326  HA  SER A  99      -4.363  36.562   3.483  1.00  0.00           H  
ATOM   1327  HB2 SER A  99      -1.639  37.268   4.635  1.00  0.00           H  
ATOM   1328  HB3 SER A  99      -2.710  35.962   5.169  1.00  0.00           H  
ATOM   1329  HG  SER A  99      -2.431  34.984   3.132  1.00  0.00           H  
ATOM   1330  N   GLU A 100      -3.722  39.515   4.762  1.00  0.00           N  
ATOM   1331  CA  GLU A 100      -4.262  40.562   5.640  1.00  0.00           C  
ATOM   1332  C   GLU A 100      -5.684  40.994   5.230  1.00  0.00           C  
ATOM   1333  O   GLU A 100      -6.577  41.094   6.070  1.00  0.00           O  
ATOM   1334  CB  GLU A 100      -3.332  41.784   5.604  1.00  0.00           C  
ATOM   1335  CG  GLU A 100      -1.892  41.526   6.078  1.00  0.00           C  
ATOM   1336  CD  GLU A 100      -1.753  41.442   7.608  1.00  0.00           C  
ATOM   1337  OE1 GLU A 100      -2.619  40.834   8.283  1.00  0.00           O  
ATOM   1338  OE2 GLU A 100      -0.756  41.987   8.140  1.00  0.00           O  
ATOM   1339  H   GLU A 100      -3.006  39.773   4.092  1.00  0.00           H  
ATOM   1340  HA  GLU A 100      -4.321  40.176   6.658  1.00  0.00           H  
ATOM   1341  HB2 GLU A 100      -3.285  42.138   4.572  1.00  0.00           H  
ATOM   1342  HB3 GLU A 100      -3.768  42.575   6.209  1.00  0.00           H  
ATOM   1343  HG2 GLU A 100      -1.501  40.614   5.623  1.00  0.00           H  
ATOM   1344  HG3 GLU A 100      -1.275  42.355   5.715  1.00  0.00           H  
ATOM   1345  N   CYS A 101      -5.922  41.187   3.929  1.00  0.00           N  
ATOM   1346  CA  CYS A 101      -7.256  41.439   3.375  1.00  0.00           C  
ATOM   1347  C   CYS A 101      -8.218  40.261   3.640  1.00  0.00           C  
ATOM   1348  O   CYS A 101      -9.378  40.465   4.003  1.00  0.00           O  
ATOM   1349  CB  CYS A 101      -7.097  41.744   1.878  1.00  0.00           C  
ATOM   1350  SG  CYS A 101      -8.710  42.183   1.178  1.00  0.00           S  
ATOM   1351  H   CYS A 101      -5.151  41.074   3.288  1.00  0.00           H  
ATOM   1352  HA  CYS A 101      -7.679  42.318   3.861  1.00  0.00           H  
ATOM   1353  HB2 CYS A 101      -6.409  42.581   1.753  1.00  0.00           H  
ATOM   1354  HB3 CYS A 101      -6.697  40.873   1.357  1.00  0.00           H  
ATOM   1355  HG  CYS A 101      -8.273  42.533  -0.037  1.00  0.00           H  
ATOM   1356  N   MET A 102      -7.725  39.022   3.542  1.00  0.00           N  
ATOM   1357  CA  MET A 102      -8.479  37.818   3.911  1.00  0.00           C  
ATOM   1358  C   MET A 102      -8.874  37.806   5.395  1.00  0.00           C  
ATOM   1359  O   MET A 102     -10.019  37.486   5.718  1.00  0.00           O  
ATOM   1360  CB  MET A 102      -7.669  36.556   3.582  1.00  0.00           C  
ATOM   1361  CG  MET A 102      -7.476  36.378   2.076  1.00  0.00           C  
ATOM   1362  SD  MET A 102      -6.360  35.031   1.584  1.00  0.00           S  
ATOM   1363  CE  MET A 102      -7.165  33.614   2.383  1.00  0.00           C  
ATOM   1364  H   MET A 102      -6.773  38.916   3.210  1.00  0.00           H  
ATOM   1365  HA  MET A 102      -9.406  37.799   3.334  1.00  0.00           H  
ATOM   1366  HB2 MET A 102      -6.693  36.607   4.063  1.00  0.00           H  
ATOM   1367  HB3 MET A 102      -8.197  35.687   3.973  1.00  0.00           H  
ATOM   1368  HG2 MET A 102      -8.452  36.211   1.625  1.00  0.00           H  
ATOM   1369  HG3 MET A 102      -7.080  37.305   1.669  1.00  0.00           H  
ATOM   1370  HE1 MET A 102      -7.041  33.679   3.463  1.00  0.00           H  
ATOM   1371  HE2 MET A 102      -8.228  33.612   2.142  1.00  0.00           H  
ATOM   1372  HE3 MET A 102      -6.712  32.687   2.029  1.00  0.00           H  
ATOM   1373  N   GLN A 103      -7.961  38.184   6.299  1.00  0.00           N  
ATOM   1374  CA  GLN A 103      -8.290  38.287   7.729  1.00  0.00           C  
ATOM   1375  C   GLN A 103      -9.285  39.423   8.046  1.00  0.00           C  
ATOM   1376  O   GLN A 103     -10.104  39.285   8.959  1.00  0.00           O  
ATOM   1377  CB  GLN A 103      -7.036  38.248   8.628  1.00  0.00           C  
ATOM   1378  CG  GLN A 103      -6.474  39.590   9.117  1.00  0.00           C  
ATOM   1379  CD  GLN A 103      -5.558  39.413  10.333  1.00  0.00           C  
ATOM   1380  OE1 GLN A 103      -5.981  38.977  11.398  1.00  0.00           O  
ATOM   1381  NE2 GLN A 103      -4.285  39.741  10.265  1.00  0.00           N  
ATOM   1382  H   GLN A 103      -7.016  38.375   5.982  1.00  0.00           H  
ATOM   1383  HA  GLN A 103      -8.823  37.378   7.981  1.00  0.00           H  
ATOM   1384  HB2 GLN A 103      -7.314  37.667   9.508  1.00  0.00           H  
ATOM   1385  HB3 GLN A 103      -6.239  37.701   8.119  1.00  0.00           H  
ATOM   1386  HG2 GLN A 103      -5.933  40.069   8.307  1.00  0.00           H  
ATOM   1387  HG3 GLN A 103      -7.295  40.236   9.421  1.00  0.00           H  
ATOM   1388 HE21 GLN A 103      -3.862  40.127   9.417  1.00  0.00           H  
ATOM   1389 HE22 GLN A 103      -3.715  39.608  11.086  1.00  0.00           H  
ATOM   1390  N   ASP A 104      -9.280  40.512   7.275  1.00  0.00           N  
ATOM   1391  CA  ASP A 104     -10.297  41.570   7.355  1.00  0.00           C  
ATOM   1392  C   ASP A 104     -11.676  41.080   6.873  1.00  0.00           C  
ATOM   1393  O   ASP A 104     -12.675  41.308   7.558  1.00  0.00           O  
ATOM   1394  CB  ASP A 104      -9.852  42.807   6.561  1.00  0.00           C  
ATOM   1395  CG  ASP A 104      -8.676  43.572   7.192  1.00  0.00           C  
ATOM   1396  OD1 ASP A 104      -8.411  43.444   8.411  1.00  0.00           O  
ATOM   1397  OD2 ASP A 104      -8.063  44.393   6.468  1.00  0.00           O  
ATOM   1398  H   ASP A 104      -8.543  40.601   6.584  1.00  0.00           H  
ATOM   1399  HA  ASP A 104     -10.421  41.879   8.393  1.00  0.00           H  
ATOM   1400  HB2 ASP A 104      -9.598  42.519   5.543  1.00  0.00           H  
ATOM   1401  HB3 ASP A 104     -10.697  43.489   6.507  1.00  0.00           H  
ATOM   1402  N   PHE A 105     -11.752  40.338   5.761  1.00  0.00           N  
ATOM   1403  CA  PHE A 105     -13.000  39.693   5.323  1.00  0.00           C  
ATOM   1404  C   PHE A 105     -13.548  38.714   6.370  1.00  0.00           C  
ATOM   1405  O   PHE A 105     -14.732  38.777   6.708  1.00  0.00           O  
ATOM   1406  CB  PHE A 105     -12.807  38.997   3.965  1.00  0.00           C  
ATOM   1407  CG  PHE A 105     -13.202  39.869   2.792  1.00  0.00           C  
ATOM   1408  CD1 PHE A 105     -14.559  40.207   2.618  1.00  0.00           C  
ATOM   1409  CD2 PHE A 105     -12.239  40.358   1.889  1.00  0.00           C  
ATOM   1410  CE1 PHE A 105     -14.947  41.056   1.570  1.00  0.00           C  
ATOM   1411  CE2 PHE A 105     -12.635  41.176   0.816  1.00  0.00           C  
ATOM   1412  CZ  PHE A 105     -13.988  41.528   0.661  1.00  0.00           C  
ATOM   1413  H   PHE A 105     -10.913  40.201   5.208  1.00  0.00           H  
ATOM   1414  HA  PHE A 105     -13.761  40.466   5.208  1.00  0.00           H  
ATOM   1415  HB2 PHE A 105     -11.773  38.667   3.859  1.00  0.00           H  
ATOM   1416  HB3 PHE A 105     -13.434  38.105   3.931  1.00  0.00           H  
ATOM   1417  HD1 PHE A 105     -15.300  39.821   3.303  1.00  0.00           H  
ATOM   1418  HD2 PHE A 105     -11.196  40.107   2.020  1.00  0.00           H  
ATOM   1419  HE1 PHE A 105     -15.985  41.341   1.453  1.00  0.00           H  
ATOM   1420  HE2 PHE A 105     -11.894  41.546   0.122  1.00  0.00           H  
ATOM   1421  HZ  PHE A 105     -14.304  42.158  -0.158  1.00  0.00           H  
ATOM   1422  N   ASN A 106     -12.689  37.867   6.947  1.00  0.00           N  
ATOM   1423  CA  ASN A 106     -13.058  37.000   8.067  1.00  0.00           C  
ATOM   1424  C   ASN A 106     -13.602  37.810   9.260  1.00  0.00           C  
ATOM   1425  O   ASN A 106     -14.670  37.497   9.785  1.00  0.00           O  
ATOM   1426  CB  ASN A 106     -11.836  36.150   8.453  1.00  0.00           C  
ATOM   1427  CG  ASN A 106     -12.147  35.192   9.591  1.00  0.00           C  
ATOM   1428  OD1 ASN A 106     -12.753  34.147   9.406  1.00  0.00           O  
ATOM   1429  ND2 ASN A 106     -11.737  35.509  10.800  1.00  0.00           N  
ATOM   1430  H   ASN A 106     -11.736  37.839   6.601  1.00  0.00           H  
ATOM   1431  HA  ASN A 106     -13.855  36.329   7.738  1.00  0.00           H  
ATOM   1432  HB2 ASN A 106     -11.515  35.563   7.592  1.00  0.00           H  
ATOM   1433  HB3 ASN A 106     -11.012  36.798   8.745  1.00  0.00           H  
ATOM   1434 HD21 ASN A 106     -11.225  36.362  10.963  1.00  0.00           H  
ATOM   1435 HD22 ASN A 106     -11.967  34.886  11.559  1.00  0.00           H  
ATOM   1436  N   THR A 107     -12.913  38.889   9.652  1.00  0.00           N  
ATOM   1437  CA  THR A 107     -13.325  39.771  10.762  1.00  0.00           C  
ATOM   1438  C   THR A 107     -14.686  40.431  10.513  1.00  0.00           C  
ATOM   1439  O   THR A 107     -15.486  40.538  11.445  1.00  0.00           O  
ATOM   1440  CB  THR A 107     -12.260  40.845  11.056  1.00  0.00           C  
ATOM   1441  OG1 THR A 107     -11.017  40.235  11.344  1.00  0.00           O  
ATOM   1442  CG2 THR A 107     -12.601  41.700  12.280  1.00  0.00           C  
ATOM   1443  H   THR A 107     -12.048  39.098   9.165  1.00  0.00           H  
ATOM   1444  HA  THR A 107     -13.429  39.160  11.659  1.00  0.00           H  
ATOM   1445  HB  THR A 107     -12.142  41.496  10.190  1.00  0.00           H  
ATOM   1446  HG1 THR A 107     -10.665  39.884  10.505  1.00  0.00           H  
ATOM   1447 HG21 THR A 107     -13.479  42.314  12.083  1.00  0.00           H  
ATOM   1448 HG22 THR A 107     -12.806  41.059  13.137  1.00  0.00           H  
ATOM   1449 HG23 THR A 107     -11.767  42.361  12.515  1.00  0.00           H  
ATOM   1450  N   MET A 108     -14.997  40.835   9.274  1.00  0.00           N  
ATOM   1451  CA  MET A 108     -16.321  41.350   8.905  1.00  0.00           C  
ATOM   1452  C   MET A 108     -17.429  40.316   9.151  1.00  0.00           C  
ATOM   1453  O   MET A 108     -18.379  40.592   9.889  1.00  0.00           O  
ATOM   1454  CB  MET A 108     -16.310  41.831   7.451  1.00  0.00           C  
ATOM   1455  CG  MET A 108     -17.702  42.288   7.001  1.00  0.00           C  
ATOM   1456  SD  MET A 108     -17.752  43.101   5.388  1.00  0.00           S  
ATOM   1457  CE  MET A 108     -17.130  41.783   4.335  1.00  0.00           C  
ATOM   1458  H   MET A 108     -14.294  40.753   8.545  1.00  0.00           H  
ATOM   1459  HA  MET A 108     -16.544  42.217   9.520  1.00  0.00           H  
ATOM   1460  HB2 MET A 108     -15.613  42.666   7.360  1.00  0.00           H  
ATOM   1461  HB3 MET A 108     -15.973  41.026   6.800  1.00  0.00           H  
ATOM   1462  HG2 MET A 108     -18.369  41.425   6.962  1.00  0.00           H  
ATOM   1463  HG3 MET A 108     -18.099  42.985   7.739  1.00  0.00           H  
ATOM   1464  HE1 MET A 108     -16.085  41.593   4.579  1.00  0.00           H  
ATOM   1465  HE2 MET A 108     -17.722  40.887   4.503  1.00  0.00           H  
ATOM   1466  HE3 MET A 108     -17.213  42.087   3.293  1.00  0.00           H  
ATOM   1467  N   PHE A 109     -17.311  39.121   8.566  1.00  0.00           N  
ATOM   1468  CA  PHE A 109     -18.334  38.078   8.689  1.00  0.00           C  
ATOM   1469  C   PHE A 109     -18.483  37.577  10.136  1.00  0.00           C  
ATOM   1470  O   PHE A 109     -19.602  37.448  10.634  1.00  0.00           O  
ATOM   1471  CB  PHE A 109     -18.014  36.922   7.727  1.00  0.00           C  
ATOM   1472  CG  PHE A 109     -17.884  37.296   6.255  1.00  0.00           C  
ATOM   1473  CD1 PHE A 109     -18.857  38.098   5.626  1.00  0.00           C  
ATOM   1474  CD2 PHE A 109     -16.790  36.824   5.501  1.00  0.00           C  
ATOM   1475  CE1 PHE A 109     -18.735  38.428   4.265  1.00  0.00           C  
ATOM   1476  CE2 PHE A 109     -16.663  37.159   4.140  1.00  0.00           C  
ATOM   1477  CZ  PHE A 109     -17.639  37.959   3.520  1.00  0.00           C  
ATOM   1478  H   PHE A 109     -16.504  38.942   7.977  1.00  0.00           H  
ATOM   1479  HA  PHE A 109     -19.300  38.503   8.408  1.00  0.00           H  
ATOM   1480  HB2 PHE A 109     -17.087  36.450   8.056  1.00  0.00           H  
ATOM   1481  HB3 PHE A 109     -18.805  36.177   7.811  1.00  0.00           H  
ATOM   1482  HD1 PHE A 109     -19.703  38.471   6.184  1.00  0.00           H  
ATOM   1483  HD2 PHE A 109     -16.038  36.204   5.970  1.00  0.00           H  
ATOM   1484  HE1 PHE A 109     -19.484  39.050   3.796  1.00  0.00           H  
ATOM   1485  HE2 PHE A 109     -15.816  36.801   3.572  1.00  0.00           H  
ATOM   1486  HZ  PHE A 109     -17.541  38.217   2.473  1.00  0.00           H  
ATOM   1487  N   THR A 110     -17.374  37.367  10.851  1.00  0.00           N  
ATOM   1488  CA  THR A 110     -17.379  36.907  12.249  1.00  0.00           C  
ATOM   1489  C   THR A 110     -18.015  37.927  13.194  1.00  0.00           C  
ATOM   1490  O   THR A 110     -18.874  37.544  13.986  1.00  0.00           O  
ATOM   1491  CB  THR A 110     -15.965  36.533  12.729  1.00  0.00           C  
ATOM   1492  OG1 THR A 110     -15.447  35.468  11.957  1.00  0.00           O  
ATOM   1493  CG2 THR A 110     -15.928  36.048  14.179  1.00  0.00           C  
ATOM   1494  H   THR A 110     -16.480  37.491  10.388  1.00  0.00           H  
ATOM   1495  HA  THR A 110     -17.993  36.009  12.306  1.00  0.00           H  
ATOM   1496  HB  THR A 110     -15.307  37.398  12.628  1.00  0.00           H  
ATOM   1497  HG1 THR A 110     -16.005  34.696  12.108  1.00  0.00           H  
ATOM   1498 HG21 THR A 110     -16.158  36.873  14.851  1.00  0.00           H  
ATOM   1499 HG22 THR A 110     -16.655  35.248  14.328  1.00  0.00           H  
ATOM   1500 HG23 THR A 110     -14.930  35.681  14.420  1.00  0.00           H  
ATOM   1501  N   ASN A 111     -17.667  39.220  13.115  1.00  0.00           N  
ATOM   1502  CA  ASN A 111     -18.273  40.225  14.001  1.00  0.00           C  
ATOM   1503  C   ASN A 111     -19.795  40.366  13.767  1.00  0.00           C  
ATOM   1504  O   ASN A 111     -20.556  40.534  14.725  1.00  0.00           O  
ATOM   1505  CB  ASN A 111     -17.472  41.545  13.960  1.00  0.00           C  
ATOM   1506  CG  ASN A 111     -17.969  42.589  12.969  1.00  0.00           C  
ATOM   1507  OD1 ASN A 111     -19.003  43.215  13.145  1.00  0.00           O  
ATOM   1508  ND2 ASN A 111     -17.229  42.832  11.918  1.00  0.00           N  
ATOM   1509  H   ASN A 111     -16.970  39.516  12.440  1.00  0.00           H  
ATOM   1510  HA  ASN A 111     -18.173  39.840  15.017  1.00  0.00           H  
ATOM   1511  HB2 ASN A 111     -17.509  41.999  14.944  1.00  0.00           H  
ATOM   1512  HB3 ASN A 111     -16.418  41.333  13.778  1.00  0.00           H  
ATOM   1513 HD21 ASN A 111     -16.409  42.259  11.766  1.00  0.00           H  
ATOM   1514 HD22 ASN A 111     -17.577  43.462  11.210  1.00  0.00           H  
ATOM   1515  N   CYS A 112     -20.252  40.172  12.524  1.00  0.00           N  
ATOM   1516  CA  CYS A 112     -21.675  40.074  12.184  1.00  0.00           C  
ATOM   1517  C   CYS A 112     -22.374  38.878  12.865  1.00  0.00           C  
ATOM   1518  O   CYS A 112     -23.473  39.045  13.400  1.00  0.00           O  
ATOM   1519  CB  CYS A 112     -21.820  40.003  10.656  1.00  0.00           C  
ATOM   1520  SG  CYS A 112     -21.390  41.607   9.924  1.00  0.00           S  
ATOM   1521  H   CYS A 112     -19.578  40.043  11.781  1.00  0.00           H  
ATOM   1522  HA  CYS A 112     -22.182  40.974  12.533  1.00  0.00           H  
ATOM   1523  HB2 CYS A 112     -21.165  39.229  10.248  1.00  0.00           H  
ATOM   1524  HB3 CYS A 112     -22.852  39.758  10.399  1.00  0.00           H  
ATOM   1525  HG  CYS A 112     -20.063  41.496  10.110  1.00  0.00           H  
ATOM   1526  N   TYR A 113     -21.748  37.694  12.886  1.00  0.00           N  
ATOM   1527  CA  TYR A 113     -22.292  36.490  13.537  1.00  0.00           C  
ATOM   1528  C   TYR A 113     -22.370  36.592  15.069  1.00  0.00           C  
ATOM   1529  O   TYR A 113     -23.274  36.012  15.674  1.00  0.00           O  
ATOM   1530  CB  TYR A 113     -21.452  35.254  13.177  1.00  0.00           C  
ATOM   1531  CG  TYR A 113     -21.272  34.938  11.701  1.00  0.00           C  
ATOM   1532  CD1 TYR A 113     -22.299  35.199  10.772  1.00  0.00           C  
ATOM   1533  CD2 TYR A 113     -20.070  34.348  11.264  1.00  0.00           C  
ATOM   1534  CE1 TYR A 113     -22.118  34.896   9.410  1.00  0.00           C  
ATOM   1535  CE2 TYR A 113     -19.879  34.053   9.900  1.00  0.00           C  
ATOM   1536  CZ  TYR A 113     -20.902  34.330   8.969  1.00  0.00           C  
ATOM   1537  OH  TYR A 113     -20.722  34.045   7.653  1.00  0.00           O  
ATOM   1538  H   TYR A 113     -20.868  37.609  12.389  1.00  0.00           H  
ATOM   1539  HA  TYR A 113     -23.312  36.334  13.183  1.00  0.00           H  
ATOM   1540  HB2 TYR A 113     -20.465  35.370  13.627  1.00  0.00           H  
ATOM   1541  HB3 TYR A 113     -21.912  34.381  13.641  1.00  0.00           H  
ATOM   1542  HD1 TYR A 113     -23.228  35.638  11.107  1.00  0.00           H  
ATOM   1543  HD2 TYR A 113     -19.288  34.137  11.983  1.00  0.00           H  
ATOM   1544  HE1 TYR A 113     -22.910  35.095   8.704  1.00  0.00           H  
ATOM   1545  HE2 TYR A 113     -18.951  33.615   9.559  1.00  0.00           H  
ATOM   1546  HH  TYR A 113     -21.487  34.289   7.127  1.00  0.00           H  
ATOM   1547  N   ILE A 114     -21.437  37.308  15.708  1.00  0.00           N  
ATOM   1548  CA  ILE A 114     -21.440  37.529  17.170  1.00  0.00           C  
ATOM   1549  C   ILE A 114     -22.663  38.360  17.595  1.00  0.00           C  
ATOM   1550  O   ILE A 114     -23.437  37.933  18.456  1.00  0.00           O  
ATOM   1551  CB  ILE A 114     -20.130  38.207  17.637  1.00  0.00           C  
ATOM   1552  CG1 ILE A 114     -18.906  37.303  17.381  1.00  0.00           C  
ATOM   1553  CG2 ILE A 114     -20.181  38.557  19.139  1.00  0.00           C  
ATOM   1554  CD1 ILE A 114     -17.585  38.066  17.515  1.00  0.00           C  
ATOM   1555  H   ILE A 114     -20.672  37.673  15.149  1.00  0.00           H  
ATOM   1556  HA  ILE A 114     -21.511  36.561  17.669  1.00  0.00           H  
ATOM   1557  HB  ILE A 114     -20.008  39.133  17.074  1.00  0.00           H  
ATOM   1558 HG12 ILE A 114     -18.909  36.464  18.075  1.00  0.00           H  
ATOM   1559 HG13 ILE A 114     -18.949  36.891  16.377  1.00  0.00           H  
ATOM   1560 HG21 ILE A 114     -21.025  39.205  19.358  1.00  0.00           H  
ATOM   1561 HG22 ILE A 114     -20.273  37.648  19.736  1.00  0.00           H  
ATOM   1562 HG23 ILE A 114     -19.283  39.094  19.439  1.00  0.00           H  
ATOM   1563 HD11 ILE A 114     -17.645  38.992  16.943  1.00  0.00           H  
ATOM   1564 HD12 ILE A 114     -17.388  38.302  18.560  1.00  0.00           H  
ATOM   1565 HD13 ILE A 114     -16.769  37.452  17.137  1.00  0.00           H  
ATOM   1566  N   TYR A 115     -22.828  39.553  17.013  1.00  0.00           N  
ATOM   1567  CA  TYR A 115     -23.856  40.517  17.438  1.00  0.00           C  
ATOM   1568  C   TYR A 115     -25.299  40.084  17.127  1.00  0.00           C  
ATOM   1569  O   TYR A 115     -26.210  40.336  17.921  1.00  0.00           O  
ATOM   1570  CB  TYR A 115     -23.566  41.872  16.782  1.00  0.00           C  
ATOM   1571  CG  TYR A 115     -24.299  43.045  17.406  1.00  0.00           C  
ATOM   1572  CD1 TYR A 115     -23.711  43.731  18.486  1.00  0.00           C  
ATOM   1573  CD2 TYR A 115     -25.561  43.449  16.924  1.00  0.00           C  
ATOM   1574  CE1 TYR A 115     -24.382  44.806  19.095  1.00  0.00           C  
ATOM   1575  CE2 TYR A 115     -26.243  44.518  17.539  1.00  0.00           C  
ATOM   1576  CZ  TYR A 115     -25.655  45.193  18.633  1.00  0.00           C  
ATOM   1577  OH  TYR A 115     -26.314  46.203  19.259  1.00  0.00           O  
ATOM   1578  H   TYR A 115     -22.113  39.858  16.360  1.00  0.00           H  
ATOM   1579  HA  TYR A 115     -23.779  40.643  18.518  1.00  0.00           H  
ATOM   1580  HB2 TYR A 115     -22.505  42.060  16.889  1.00  0.00           H  
ATOM   1581  HB3 TYR A 115     -23.786  41.822  15.716  1.00  0.00           H  
ATOM   1582  HD1 TYR A 115     -22.743  43.427  18.853  1.00  0.00           H  
ATOM   1583  HD2 TYR A 115     -26.013  42.927  16.090  1.00  0.00           H  
ATOM   1584  HE1 TYR A 115     -23.935  45.330  19.926  1.00  0.00           H  
ATOM   1585  HE2 TYR A 115     -27.217  44.816  17.178  1.00  0.00           H  
ATOM   1586  HH  TYR A 115     -27.191  46.334  18.886  1.00  0.00           H  
ATOM   1587  N   ASN A 116     -25.517  39.436  15.979  1.00  0.00           N  
ATOM   1588  CA  ASN A 116     -26.854  39.136  15.450  1.00  0.00           C  
ATOM   1589  C   ASN A 116     -27.285  37.680  15.710  1.00  0.00           C  
ATOM   1590  O   ASN A 116     -26.455  36.791  15.923  1.00  0.00           O  
ATOM   1591  CB  ASN A 116     -26.866  39.463  13.947  1.00  0.00           C  
ATOM   1592  CG  ASN A 116     -26.570  40.928  13.675  1.00  0.00           C  
ATOM   1593  OD1 ASN A 116     -27.406  41.801  13.854  1.00  0.00           O  
ATOM   1594  ND2 ASN A 116     -25.367  41.241  13.252  1.00  0.00           N  
ATOM   1595  H   ASN A 116     -24.715  39.227  15.399  1.00  0.00           H  
ATOM   1596  HA  ASN A 116     -27.590  39.782  15.935  1.00  0.00           H  
ATOM   1597  HB2 ASN A 116     -26.131  38.842  13.437  1.00  0.00           H  
ATOM   1598  HB3 ASN A 116     -27.847  39.236  13.528  1.00  0.00           H  
ATOM   1599 HD21 ASN A 116     -24.671  40.508  13.159  1.00  0.00           H  
ATOM   1600 HD22 ASN A 116     -25.153  42.207  13.065  1.00  0.00           H  
ATOM   1601  N   LYS A 117     -28.598  37.424  15.664  1.00  0.00           N  
ATOM   1602  CA  LYS A 117     -29.173  36.066  15.738  1.00  0.00           C  
ATOM   1603  C   LYS A 117     -28.795  35.249  14.488  1.00  0.00           C  
ATOM   1604  O   LYS A 117     -28.761  35.821  13.396  1.00  0.00           O  
ATOM   1605  CB  LYS A 117     -30.706  36.148  15.883  1.00  0.00           C  
ATOM   1606  CG  LYS A 117     -31.189  36.795  17.193  1.00  0.00           C  
ATOM   1607  CD  LYS A 117     -30.779  36.002  18.445  1.00  0.00           C  
ATOM   1608  CE  LYS A 117     -31.426  36.550  19.723  1.00  0.00           C  
ATOM   1609  NZ  LYS A 117     -30.898  37.890  20.096  1.00  0.00           N  
ATOM   1610  H   LYS A 117     -29.219  38.190  15.442  1.00  0.00           H  
ATOM   1611  HA  LYS A 117     -28.748  35.560  16.604  1.00  0.00           H  
ATOM   1612  HB2 LYS A 117     -31.112  36.719  15.045  1.00  0.00           H  
ATOM   1613  HB3 LYS A 117     -31.125  35.143  15.825  1.00  0.00           H  
ATOM   1614  HG2 LYS A 117     -30.801  37.812  17.260  1.00  0.00           H  
ATOM   1615  HG3 LYS A 117     -32.278  36.852  17.159  1.00  0.00           H  
ATOM   1616  HD2 LYS A 117     -31.099  34.966  18.322  1.00  0.00           H  
ATOM   1617  HD3 LYS A 117     -29.694  36.013  18.562  1.00  0.00           H  
ATOM   1618  HE2 LYS A 117     -32.509  36.602  19.578  1.00  0.00           H  
ATOM   1619  HE3 LYS A 117     -31.232  35.847  20.537  1.00  0.00           H  
ATOM   1620  HZ1 LYS A 117     -29.899  37.863  20.244  1.00  0.00           H  
ATOM   1621  HZ2 LYS A 117     -31.093  38.578  19.381  1.00  0.00           H  
ATOM   1622  HZ3 LYS A 117     -31.322  38.218  20.955  1.00  0.00           H  
ATOM   1623  N   PRO A 118     -28.585  33.921  14.594  1.00  0.00           N  
ATOM   1624  CA  PRO A 118     -28.126  33.078  13.480  1.00  0.00           C  
ATOM   1625  C   PRO A 118     -29.133  32.942  12.320  1.00  0.00           C  
ATOM   1626  O   PRO A 118     -28.797  32.393  11.268  1.00  0.00           O  
ATOM   1627  CB  PRO A 118     -27.792  31.721  14.112  1.00  0.00           C  
ATOM   1628  CG  PRO A 118     -28.693  31.666  15.345  1.00  0.00           C  
ATOM   1629  CD  PRO A 118     -28.728  33.121  15.805  1.00  0.00           C  
ATOM   1630  HA  PRO A 118     -27.210  33.503  13.074  1.00  0.00           H  
ATOM   1631  HB2 PRO A 118     -27.982  30.884  13.438  1.00  0.00           H  
ATOM   1632  HB3 PRO A 118     -26.747  31.718  14.428  1.00  0.00           H  
ATOM   1633  HG2 PRO A 118     -29.694  31.348  15.053  1.00  0.00           H  
ATOM   1634  HG3 PRO A 118     -28.289  31.008  16.115  1.00  0.00           H  
ATOM   1635  HD2 PRO A 118     -29.670  33.327  16.316  1.00  0.00           H  
ATOM   1636  HD3 PRO A 118     -27.887  33.317  16.469  1.00  0.00           H  
ATOM   1637  N   THR A 119     -30.356  33.453  12.493  1.00  0.00           N  
ATOM   1638  CA  THR A 119     -31.458  33.444  11.516  1.00  0.00           C  
ATOM   1639  C   THR A 119     -31.834  34.844  11.013  1.00  0.00           C  
ATOM   1640  O   THR A 119     -32.728  34.973  10.173  1.00  0.00           O  
ATOM   1641  CB  THR A 119     -32.700  32.776  12.133  1.00  0.00           C  
ATOM   1642  OG1 THR A 119     -33.059  33.424  13.339  1.00  0.00           O  
ATOM   1643  CG2 THR A 119     -32.441  31.309  12.470  1.00  0.00           C  
ATOM   1644  H   THR A 119     -30.577  33.829  13.403  1.00  0.00           H  
ATOM   1645  HA  THR A 119     -31.167  32.865  10.640  1.00  0.00           H  
ATOM   1646  HB  THR A 119     -33.530  32.829  11.429  1.00  0.00           H  
ATOM   1647  HG1 THR A 119     -33.872  33.005  13.653  1.00  0.00           H  
ATOM   1648 HG21 THR A 119     -32.103  30.786  11.576  1.00  0.00           H  
ATOM   1649 HG22 THR A 119     -31.674  31.230  13.242  1.00  0.00           H  
ATOM   1650 HG23 THR A 119     -33.361  30.846  12.826  1.00  0.00           H  
ATOM   1651  N   ASP A 120     -31.166  35.901  11.494  1.00  0.00           N  
ATOM   1652  CA  ASP A 120     -31.349  37.267  10.980  1.00  0.00           C  
ATOM   1653  C   ASP A 120     -30.859  37.379   9.524  1.00  0.00           C  
ATOM   1654  O   ASP A 120     -29.889  36.721   9.135  1.00  0.00           O  
ATOM   1655  CB  ASP A 120     -30.611  38.280  11.875  1.00  0.00           C  
ATOM   1656  CG  ASP A 120     -31.219  39.685  11.735  1.00  0.00           C  
ATOM   1657  OD1 ASP A 120     -30.881  40.404  10.767  1.00  0.00           O  
ATOM   1658  OD2 ASP A 120     -32.055  40.064  12.588  1.00  0.00           O  
ATOM   1659  H   ASP A 120     -30.400  35.731  12.135  1.00  0.00           H  
ATOM   1660  HA  ASP A 120     -32.414  37.502  11.006  1.00  0.00           H  
ATOM   1661  HB2 ASP A 120     -30.689  37.967  12.917  1.00  0.00           H  
ATOM   1662  HB3 ASP A 120     -29.552  38.306  11.608  1.00  0.00           H  
ATOM   1663  N   ASP A 121     -31.499  38.229   8.717  1.00  0.00           N  
ATOM   1664  CA  ASP A 121     -31.140  38.439   7.309  1.00  0.00           C  
ATOM   1665  C   ASP A 121     -29.646  38.749   7.127  1.00  0.00           C  
ATOM   1666  O   ASP A 121     -28.985  38.090   6.329  1.00  0.00           O  
ATOM   1667  CB  ASP A 121     -31.996  39.559   6.706  1.00  0.00           C  
ATOM   1668  CG  ASP A 121     -33.476  39.164   6.610  1.00  0.00           C  
ATOM   1669  OD1 ASP A 121     -33.858  38.475   5.632  1.00  0.00           O  
ATOM   1670  OD2 ASP A 121     -34.268  39.548   7.506  1.00  0.00           O  
ATOM   1671  H   ASP A 121     -32.261  38.776   9.096  1.00  0.00           H  
ATOM   1672  HA  ASP A 121     -31.346  37.520   6.756  1.00  0.00           H  
ATOM   1673  HB2 ASP A 121     -31.885  40.463   7.308  1.00  0.00           H  
ATOM   1674  HB3 ASP A 121     -31.625  39.783   5.704  1.00  0.00           H  
ATOM   1675  N   ILE A 122     -29.089  39.684   7.906  1.00  0.00           N  
ATOM   1676  CA  ILE A 122     -27.672  40.085   7.836  1.00  0.00           C  
ATOM   1677  C   ILE A 122     -26.679  38.923   8.038  1.00  0.00           C  
ATOM   1678  O   ILE A 122     -25.593  38.929   7.454  1.00  0.00           O  
ATOM   1679  CB  ILE A 122     -27.402  41.233   8.837  1.00  0.00           C  
ATOM   1680  CG1 ILE A 122     -26.087  42.001   8.575  1.00  0.00           C  
ATOM   1681  CG2 ILE A 122     -27.399  40.735  10.293  1.00  0.00           C  
ATOM   1682  CD1 ILE A 122     -26.007  42.675   7.199  1.00  0.00           C  
ATOM   1683  H   ILE A 122     -29.694  40.178   8.548  1.00  0.00           H  
ATOM   1684  HA  ILE A 122     -27.519  40.467   6.826  1.00  0.00           H  
ATOM   1685  HB  ILE A 122     -28.224  41.945   8.746  1.00  0.00           H  
ATOM   1686 HG12 ILE A 122     -25.991  42.783   9.331  1.00  0.00           H  
ATOM   1687 HG13 ILE A 122     -25.235  41.329   8.687  1.00  0.00           H  
ATOM   1688 HG21 ILE A 122     -28.278  40.120  10.487  1.00  0.00           H  
ATOM   1689 HG22 ILE A 122     -26.506  40.145  10.501  1.00  0.00           H  
ATOM   1690 HG23 ILE A 122     -27.421  41.592  10.966  1.00  0.00           H  
ATOM   1691 HD11 ILE A 122     -25.942  41.927   6.409  1.00  0.00           H  
ATOM   1692 HD12 ILE A 122     -26.884  43.303   7.037  1.00  0.00           H  
ATOM   1693 HD13 ILE A 122     -25.116  43.300   7.153  1.00  0.00           H  
ATOM   1694  N   VAL A 123     -27.043  37.907   8.829  1.00  0.00           N  
ATOM   1695  CA  VAL A 123     -26.233  36.691   8.996  1.00  0.00           C  
ATOM   1696  C   VAL A 123     -26.307  35.828   7.742  1.00  0.00           C  
ATOM   1697  O   VAL A 123     -25.267  35.430   7.228  1.00  0.00           O  
ATOM   1698  CB  VAL A 123     -26.646  35.894  10.249  1.00  0.00           C  
ATOM   1699  CG1 VAL A 123     -26.004  34.500  10.283  1.00  0.00           C  
ATOM   1700  CG2 VAL A 123     -26.239  36.679  11.502  1.00  0.00           C  
ATOM   1701  H   VAL A 123     -27.971  37.925   9.232  1.00  0.00           H  
ATOM   1702  HA  VAL A 123     -25.188  36.979   9.116  1.00  0.00           H  
ATOM   1703  HB  VAL A 123     -27.728  35.770  10.265  1.00  0.00           H  
ATOM   1704 HG11 VAL A 123     -26.483  33.853   9.549  1.00  0.00           H  
ATOM   1705 HG12 VAL A 123     -24.942  34.557  10.053  1.00  0.00           H  
ATOM   1706 HG13 VAL A 123     -26.132  34.046  11.262  1.00  0.00           H  
ATOM   1707 HG21 VAL A 123     -25.183  36.945  11.462  1.00  0.00           H  
ATOM   1708 HG22 VAL A 123     -26.840  37.585  11.570  1.00  0.00           H  
ATOM   1709 HG23 VAL A 123     -26.421  36.082  12.395  1.00  0.00           H  
ATOM   1710  N   LEU A 124     -27.500  35.581   7.197  1.00  0.00           N  
ATOM   1711  CA  LEU A 124     -27.667  34.816   5.953  1.00  0.00           C  
ATOM   1712  C   LEU A 124     -26.961  35.498   4.762  1.00  0.00           C  
ATOM   1713  O   LEU A 124     -26.346  34.821   3.936  1.00  0.00           O  
ATOM   1714  CB  LEU A 124     -29.166  34.629   5.656  1.00  0.00           C  
ATOM   1715  CG  LEU A 124     -29.980  33.950   6.774  1.00  0.00           C  
ATOM   1716  CD1 LEU A 124     -31.457  33.929   6.386  1.00  0.00           C  
ATOM   1717  CD2 LEU A 124     -29.526  32.513   7.045  1.00  0.00           C  
ATOM   1718  H   LEU A 124     -28.320  35.986   7.634  1.00  0.00           H  
ATOM   1719  HA  LEU A 124     -27.197  33.838   6.083  1.00  0.00           H  
ATOM   1720  HB2 LEU A 124     -29.604  35.609   5.461  1.00  0.00           H  
ATOM   1721  HB3 LEU A 124     -29.265  34.038   4.744  1.00  0.00           H  
ATOM   1722  HG  LEU A 124     -29.884  34.520   7.696  1.00  0.00           H  
ATOM   1723 HD11 LEU A 124     -31.801  34.952   6.221  1.00  0.00           H  
ATOM   1724 HD12 LEU A 124     -31.599  33.349   5.474  1.00  0.00           H  
ATOM   1725 HD13 LEU A 124     -32.044  33.490   7.191  1.00  0.00           H  
ATOM   1726 HD21 LEU A 124     -29.578  31.925   6.128  1.00  0.00           H  
ATOM   1727 HD22 LEU A 124     -28.503  32.514   7.417  1.00  0.00           H  
ATOM   1728 HD23 LEU A 124     -30.165  32.062   7.802  1.00  0.00           H  
ATOM   1729  N   MET A 125     -26.981  36.833   4.714  1.00  0.00           N  
ATOM   1730  CA  MET A 125     -26.194  37.650   3.784  1.00  0.00           C  
ATOM   1731  C   MET A 125     -24.688  37.405   3.937  1.00  0.00           C  
ATOM   1732  O   MET A 125     -24.017  37.078   2.959  1.00  0.00           O  
ATOM   1733  CB  MET A 125     -26.481  39.133   4.031  1.00  0.00           C  
ATOM   1734  CG  MET A 125     -27.916  39.545   3.717  1.00  0.00           C  
ATOM   1735  SD  MET A 125     -28.266  41.223   4.287  1.00  0.00           S  
ATOM   1736  CE  MET A 125     -29.231  41.784   2.878  1.00  0.00           C  
ATOM   1737  H   MET A 125     -27.575  37.312   5.385  1.00  0.00           H  
ATOM   1738  HA  MET A 125     -26.473  37.401   2.760  1.00  0.00           H  
ATOM   1739  HB2 MET A 125     -26.272  39.372   5.070  1.00  0.00           H  
ATOM   1740  HB3 MET A 125     -25.808  39.730   3.416  1.00  0.00           H  
ATOM   1741  HG2 MET A 125     -28.083  39.475   2.648  1.00  0.00           H  
ATOM   1742  HG3 MET A 125     -28.623  38.862   4.173  1.00  0.00           H  
ATOM   1743  HE1 MET A 125     -28.607  41.748   1.982  1.00  0.00           H  
ATOM   1744  HE2 MET A 125     -30.091  41.127   2.762  1.00  0.00           H  
ATOM   1745  HE3 MET A 125     -29.561  42.803   3.064  1.00  0.00           H  
ATOM   1746  N   ALA A 126     -24.154  37.512   5.159  1.00  0.00           N  
ATOM   1747  CA  ALA A 126     -22.747  37.235   5.447  1.00  0.00           C  
ATOM   1748  C   ALA A 126     -22.348  35.787   5.105  1.00  0.00           C  
ATOM   1749  O   ALA A 126     -21.279  35.568   4.547  1.00  0.00           O  
ATOM   1750  CB  ALA A 126     -22.469  37.561   6.918  1.00  0.00           C  
ATOM   1751  H   ALA A 126     -24.750  37.794   5.929  1.00  0.00           H  
ATOM   1752  HA  ALA A 126     -22.130  37.894   4.833  1.00  0.00           H  
ATOM   1753  HB1 ALA A 126     -22.571  38.633   7.086  1.00  0.00           H  
ATOM   1754  HB2 ALA A 126     -23.176  37.035   7.556  1.00  0.00           H  
ATOM   1755  HB3 ALA A 126     -21.456  37.252   7.178  1.00  0.00           H  
ATOM   1756  N   GLN A 127     -23.206  34.797   5.382  1.00  0.00           N  
ATOM   1757  CA  GLN A 127     -22.994  33.395   4.992  1.00  0.00           C  
ATOM   1758  C   GLN A 127     -22.935  33.202   3.464  1.00  0.00           C  
ATOM   1759  O   GLN A 127     -22.146  32.388   2.976  1.00  0.00           O  
ATOM   1760  CB  GLN A 127     -24.109  32.506   5.577  1.00  0.00           C  
ATOM   1761  CG  GLN A 127     -24.075  32.370   7.109  1.00  0.00           C  
ATOM   1762  CD  GLN A 127     -25.212  31.514   7.671  1.00  0.00           C  
ATOM   1763  OE1 GLN A 127     -26.085  31.014   6.973  1.00  0.00           O  
ATOM   1764  NE2 GLN A 127     -25.239  31.297   8.970  1.00  0.00           N  
ATOM   1765  H   GLN A 127     -24.063  35.034   5.873  1.00  0.00           H  
ATOM   1766  HA  GLN A 127     -22.038  33.062   5.395  1.00  0.00           H  
ATOM   1767  HB2 GLN A 127     -25.078  32.905   5.275  1.00  0.00           H  
ATOM   1768  HB3 GLN A 127     -24.010  31.507   5.150  1.00  0.00           H  
ATOM   1769  HG2 GLN A 127     -23.132  31.928   7.410  1.00  0.00           H  
ATOM   1770  HG3 GLN A 127     -24.120  33.345   7.579  1.00  0.00           H  
ATOM   1771 HE21 GLN A 127     -24.534  31.698   9.569  1.00  0.00           H  
ATOM   1772 HE22 GLN A 127     -25.994  30.745   9.349  1.00  0.00           H  
ATOM   1773  N   ALA A 128     -23.762  33.921   2.694  1.00  0.00           N  
ATOM   1774  CA  ALA A 128     -23.781  33.866   1.229  1.00  0.00           C  
ATOM   1775  C   ALA A 128     -22.601  34.614   0.577  1.00  0.00           C  
ATOM   1776  O   ALA A 128     -22.071  34.160  -0.439  1.00  0.00           O  
ATOM   1777  CB  ALA A 128     -25.121  34.433   0.742  1.00  0.00           C  
ATOM   1778  H   ALA A 128     -24.433  34.528   3.150  1.00  0.00           H  
ATOM   1779  HA  ALA A 128     -23.711  32.822   0.915  1.00  0.00           H  
ATOM   1780  HB1 ALA A 128     -25.943  33.861   1.172  1.00  0.00           H  
ATOM   1781  HB2 ALA A 128     -25.216  35.477   1.041  1.00  0.00           H  
ATOM   1782  HB3 ALA A 128     -25.174  34.367  -0.345  1.00  0.00           H  
ATOM   1783  N   LEU A 129     -22.150  35.723   1.170  1.00  0.00           N  
ATOM   1784  CA  LEU A 129     -20.916  36.403   0.768  1.00  0.00           C  
ATOM   1785  C   LEU A 129     -19.674  35.562   1.114  1.00  0.00           C  
ATOM   1786  O   LEU A 129     -18.801  35.389   0.268  1.00  0.00           O  
ATOM   1787  CB  LEU A 129     -20.843  37.783   1.446  1.00  0.00           C  
ATOM   1788  CG  LEU A 129     -21.858  38.825   0.939  1.00  0.00           C  
ATOM   1789  CD1 LEU A 129     -21.681  40.130   1.718  1.00  0.00           C  
ATOM   1790  CD2 LEU A 129     -21.693  39.152  -0.544  1.00  0.00           C  
ATOM   1791  H   LEU A 129     -22.669  36.088   1.962  1.00  0.00           H  
ATOM   1792  HA  LEU A 129     -20.915  36.534  -0.314  1.00  0.00           H  
ATOM   1793  HB2 LEU A 129     -20.987  37.649   2.518  1.00  0.00           H  
ATOM   1794  HB3 LEU A 129     -19.841  38.187   1.298  1.00  0.00           H  
ATOM   1795  HG  LEU A 129     -22.872  38.463   1.098  1.00  0.00           H  
ATOM   1796 HD11 LEU A 129     -21.814  39.939   2.782  1.00  0.00           H  
ATOM   1797 HD12 LEU A 129     -20.686  40.541   1.547  1.00  0.00           H  
ATOM   1798 HD13 LEU A 129     -22.428  40.853   1.396  1.00  0.00           H  
ATOM   1799 HD21 LEU A 129     -20.676  39.482  -0.752  1.00  0.00           H  
ATOM   1800 HD22 LEU A 129     -21.929  38.277  -1.146  1.00  0.00           H  
ATOM   1801 HD23 LEU A 129     -22.390  39.945  -0.812  1.00  0.00           H  
ATOM   1802  N   GLU A 130     -19.594  34.993   2.322  1.00  0.00           N  
ATOM   1803  CA  GLU A 130     -18.412  34.251   2.778  1.00  0.00           C  
ATOM   1804  C   GLU A 130     -18.120  33.005   1.926  1.00  0.00           C  
ATOM   1805  O   GLU A 130     -16.957  32.738   1.612  1.00  0.00           O  
ATOM   1806  CB  GLU A 130     -18.555  33.864   4.263  1.00  0.00           C  
ATOM   1807  CG  GLU A 130     -17.287  33.198   4.821  1.00  0.00           C  
ATOM   1808  CD  GLU A 130     -17.454  32.784   6.295  1.00  0.00           C  
ATOM   1809  OE1 GLU A 130     -18.082  31.729   6.558  1.00  0.00           O  
ATOM   1810  OE2 GLU A 130     -16.905  33.472   7.188  1.00  0.00           O  
ATOM   1811  H   GLU A 130     -20.318  35.195   3.002  1.00  0.00           H  
ATOM   1812  HA  GLU A 130     -17.559  34.923   2.675  1.00  0.00           H  
ATOM   1813  HB2 GLU A 130     -18.756  34.760   4.848  1.00  0.00           H  
ATOM   1814  HB3 GLU A 130     -19.399  33.181   4.375  1.00  0.00           H  
ATOM   1815  HG2 GLU A 130     -17.054  32.304   4.240  1.00  0.00           H  
ATOM   1816  HG3 GLU A 130     -16.447  33.888   4.714  1.00  0.00           H  
ATOM   1817  N   LYS A 131     -19.147  32.250   1.508  1.00  0.00           N  
ATOM   1818  CA  LYS A 131     -18.943  31.082   0.633  1.00  0.00           C  
ATOM   1819  C   LYS A 131     -18.312  31.462  -0.709  1.00  0.00           C  
ATOM   1820  O   LYS A 131     -17.371  30.803  -1.151  1.00  0.00           O  
ATOM   1821  CB  LYS A 131     -20.231  30.256   0.479  1.00  0.00           C  
ATOM   1822  CG  LYS A 131     -21.439  30.964  -0.148  1.00  0.00           C  
ATOM   1823  CD  LYS A 131     -22.637  30.026  -0.379  1.00  0.00           C  
ATOM   1824  CE  LYS A 131     -23.066  29.196   0.843  1.00  0.00           C  
ATOM   1825  NZ  LYS A 131     -23.563  30.036   1.965  1.00  0.00           N  
ATOM   1826  H   LYS A 131     -20.085  32.500   1.803  1.00  0.00           H  
ATOM   1827  HA  LYS A 131     -18.213  30.433   1.119  1.00  0.00           H  
ATOM   1828  HB2 LYS A 131     -19.996  29.386  -0.131  1.00  0.00           H  
ATOM   1829  HB3 LYS A 131     -20.521  29.922   1.475  1.00  0.00           H  
ATOM   1830  HG2 LYS A 131     -21.743  31.776   0.505  1.00  0.00           H  
ATOM   1831  HG3 LYS A 131     -21.158  31.381  -1.113  1.00  0.00           H  
ATOM   1832  HD2 LYS A 131     -23.485  30.615  -0.729  1.00  0.00           H  
ATOM   1833  HD3 LYS A 131     -22.373  29.330  -1.177  1.00  0.00           H  
ATOM   1834  HE2 LYS A 131     -23.855  28.505   0.532  1.00  0.00           H  
ATOM   1835  HE3 LYS A 131     -22.218  28.590   1.176  1.00  0.00           H  
ATOM   1836  HZ1 LYS A 131     -22.860  30.707   2.267  1.00  0.00           H  
ATOM   1837  HZ2 LYS A 131     -24.398  30.539   1.698  1.00  0.00           H  
ATOM   1838  HZ3 LYS A 131     -23.799  29.459   2.762  1.00  0.00           H  
ATOM   1839  N   ILE A 132     -18.763  32.558  -1.318  1.00  0.00           N  
ATOM   1840  CA  ILE A 132     -18.175  33.112  -2.545  1.00  0.00           C  
ATOM   1841  C   ILE A 132     -16.756  33.625  -2.280  1.00  0.00           C  
ATOM   1842  O   ILE A 132     -15.854  33.281  -3.035  1.00  0.00           O  
ATOM   1843  CB  ILE A 132     -19.069  34.212  -3.156  1.00  0.00           C  
ATOM   1844  CG1 ILE A 132     -20.452  33.627  -3.525  1.00  0.00           C  
ATOM   1845  CG2 ILE A 132     -18.394  34.803  -4.411  1.00  0.00           C  
ATOM   1846  CD1 ILE A 132     -21.492  34.687  -3.891  1.00  0.00           C  
ATOM   1847  H   ILE A 132     -19.544  33.035  -0.893  1.00  0.00           H  
ATOM   1848  HA  ILE A 132     -18.092  32.307  -3.278  1.00  0.00           H  
ATOM   1849  HB  ILE A 132     -19.194  35.008  -2.420  1.00  0.00           H  
ATOM   1850 HG12 ILE A 132     -20.345  32.926  -4.354  1.00  0.00           H  
ATOM   1851 HG13 ILE A 132     -20.858  33.077  -2.677  1.00  0.00           H  
ATOM   1852 HG21 ILE A 132     -17.465  35.303  -4.143  1.00  0.00           H  
ATOM   1853 HG22 ILE A 132     -18.181  34.006  -5.124  1.00  0.00           H  
ATOM   1854 HG23 ILE A 132     -19.035  35.548  -4.880  1.00  0.00           H  
ATOM   1855 HD11 ILE A 132     -21.551  35.422  -3.088  1.00  0.00           H  
ATOM   1856 HD12 ILE A 132     -21.230  35.178  -4.827  1.00  0.00           H  
ATOM   1857 HD13 ILE A 132     -22.464  34.209  -4.009  1.00  0.00           H  
ATOM   1858  N   PHE A 133     -16.529  34.380  -1.200  1.00  0.00           N  
ATOM   1859  CA  PHE A 133     -15.192  34.827  -0.787  1.00  0.00           C  
ATOM   1860  C   PHE A 133     -14.201  33.650  -0.741  1.00  0.00           C  
ATOM   1861  O   PHE A 133     -13.151  33.710  -1.380  1.00  0.00           O  
ATOM   1862  CB  PHE A 133     -15.283  35.549   0.571  1.00  0.00           C  
ATOM   1863  CG  PHE A 133     -13.964  35.679   1.308  1.00  0.00           C  
ATOM   1864  CD1 PHE A 133     -13.024  36.651   0.924  1.00  0.00           C  
ATOM   1865  CD2 PHE A 133     -13.654  34.784   2.352  1.00  0.00           C  
ATOM   1866  CE1 PHE A 133     -11.770  36.705   1.558  1.00  0.00           C  
ATOM   1867  CE2 PHE A 133     -12.399  34.838   2.984  1.00  0.00           C  
ATOM   1868  CZ  PHE A 133     -11.455  35.795   2.579  1.00  0.00           C  
ATOM   1869  H   PHE A 133     -17.319  34.635  -0.617  1.00  0.00           H  
ATOM   1870  HA  PHE A 133     -14.811  35.534  -1.531  1.00  0.00           H  
ATOM   1871  HB2 PHE A 133     -15.716  36.538   0.430  1.00  0.00           H  
ATOM   1872  HB3 PHE A 133     -15.965  35.003   1.212  1.00  0.00           H  
ATOM   1873  HD1 PHE A 133     -13.255  37.350   0.134  1.00  0.00           H  
ATOM   1874  HD2 PHE A 133     -14.375  34.039   2.659  1.00  0.00           H  
ATOM   1875  HE1 PHE A 133     -11.041  37.438   1.252  1.00  0.00           H  
ATOM   1876  HE2 PHE A 133     -12.155  34.136   3.771  1.00  0.00           H  
ATOM   1877  HZ  PHE A 133     -10.484  35.828   3.048  1.00  0.00           H  
ATOM   1878  N   LEU A 134     -14.556  32.546  -0.076  1.00  0.00           N  
ATOM   1879  CA  LEU A 134     -13.704  31.357  -0.004  1.00  0.00           C  
ATOM   1880  C   LEU A 134     -13.457  30.713  -1.381  1.00  0.00           C  
ATOM   1881  O   LEU A 134     -12.314  30.372  -1.684  1.00  0.00           O  
ATOM   1882  CB  LEU A 134     -14.307  30.343   0.985  1.00  0.00           C  
ATOM   1883  CG  LEU A 134     -14.282  30.793   2.460  1.00  0.00           C  
ATOM   1884  CD1 LEU A 134     -15.073  29.805   3.315  1.00  0.00           C  
ATOM   1885  CD2 LEU A 134     -12.860  30.883   3.022  1.00  0.00           C  
ATOM   1886  H   LEU A 134     -15.437  32.548   0.431  1.00  0.00           H  
ATOM   1887  HA  LEU A 134     -12.727  31.677   0.361  1.00  0.00           H  
ATOM   1888  HB2 LEU A 134     -15.339  30.146   0.692  1.00  0.00           H  
ATOM   1889  HB3 LEU A 134     -13.756  29.405   0.904  1.00  0.00           H  
ATOM   1890  HG  LEU A 134     -14.750  31.770   2.557  1.00  0.00           H  
ATOM   1891 HD11 LEU A 134     -16.103  29.764   2.960  1.00  0.00           H  
ATOM   1892 HD12 LEU A 134     -14.628  28.811   3.252  1.00  0.00           H  
ATOM   1893 HD13 LEU A 134     -15.077  30.135   4.353  1.00  0.00           H  
ATOM   1894 HD21 LEU A 134     -12.350  29.927   2.908  1.00  0.00           H  
ATOM   1895 HD22 LEU A 134     -12.299  31.658   2.501  1.00  0.00           H  
ATOM   1896 HD23 LEU A 134     -12.898  31.147   4.079  1.00  0.00           H  
ATOM   1897  N   GLN A 135     -14.473  30.597  -2.246  1.00  0.00           N  
ATOM   1898  CA  GLN A 135     -14.309  30.110  -3.629  1.00  0.00           C  
ATOM   1899  C   GLN A 135     -13.392  31.008  -4.477  1.00  0.00           C  
ATOM   1900  O   GLN A 135     -12.654  30.518  -5.334  1.00  0.00           O  
ATOM   1901  CB  GLN A 135     -15.674  30.015  -4.329  1.00  0.00           C  
ATOM   1902  CG  GLN A 135     -16.594  28.921  -3.780  1.00  0.00           C  
ATOM   1903  CD  GLN A 135     -16.123  27.513  -4.146  1.00  0.00           C  
ATOM   1904  OE1 GLN A 135     -15.348  26.879  -3.439  1.00  0.00           O  
ATOM   1905  NE2 GLN A 135     -16.561  26.968  -5.262  1.00  0.00           N  
ATOM   1906  H   GLN A 135     -15.397  30.883  -1.940  1.00  0.00           H  
ATOM   1907  HA  GLN A 135     -13.852  29.119  -3.604  1.00  0.00           H  
ATOM   1908  HB2 GLN A 135     -16.187  30.974  -4.242  1.00  0.00           H  
ATOM   1909  HB3 GLN A 135     -15.518  29.824  -5.393  1.00  0.00           H  
ATOM   1910  HG2 GLN A 135     -16.664  28.998  -2.699  1.00  0.00           H  
ATOM   1911  HG3 GLN A 135     -17.587  29.089  -4.188  1.00  0.00           H  
ATOM   1912 HE21 GLN A 135     -17.203  27.471  -5.859  1.00  0.00           H  
ATOM   1913 HE22 GLN A 135     -16.249  26.038  -5.499  1.00  0.00           H  
ATOM   1914  N   LYS A 136     -13.443  32.324  -4.254  1.00  0.00           N  
ATOM   1915  CA  LYS A 136     -12.633  33.328  -4.961  1.00  0.00           C  
ATOM   1916  C   LYS A 136     -11.170  33.288  -4.514  1.00  0.00           C  
ATOM   1917  O   LYS A 136     -10.294  33.121  -5.357  1.00  0.00           O  
ATOM   1918  CB  LYS A 136     -13.242  34.726  -4.766  1.00  0.00           C  
ATOM   1919  CG  LYS A 136     -14.615  34.898  -5.434  1.00  0.00           C  
ATOM   1920  CD  LYS A 136     -14.512  35.200  -6.932  1.00  0.00           C  
ATOM   1921  CE  LYS A 136     -15.909  35.243  -7.560  1.00  0.00           C  
ATOM   1922  NZ  LYS A 136     -16.452  33.884  -7.823  1.00  0.00           N  
ATOM   1923  H   LYS A 136     -14.132  32.640  -3.577  1.00  0.00           H  
ATOM   1924  HA  LYS A 136     -12.630  33.100  -6.028  1.00  0.00           H  
ATOM   1925  HB2 LYS A 136     -13.342  34.930  -3.700  1.00  0.00           H  
ATOM   1926  HB3 LYS A 136     -12.567  35.467  -5.190  1.00  0.00           H  
ATOM   1927  HG2 LYS A 136     -15.211  33.999  -5.299  1.00  0.00           H  
ATOM   1928  HG3 LYS A 136     -15.130  35.729  -4.952  1.00  0.00           H  
ATOM   1929  HD2 LYS A 136     -14.048  36.178  -7.045  1.00  0.00           H  
ATOM   1930  HD3 LYS A 136     -13.893  34.458  -7.440  1.00  0.00           H  
ATOM   1931  HE2 LYS A 136     -16.573  35.793  -6.888  1.00  0.00           H  
ATOM   1932  HE3 LYS A 136     -15.859  35.800  -8.497  1.00  0.00           H  
ATOM   1933  HZ1 LYS A 136     -15.871  33.380  -8.481  1.00  0.00           H  
ATOM   1934  HZ2 LYS A 136     -16.514  33.336  -6.975  1.00  0.00           H  
ATOM   1935  HZ3 LYS A 136     -17.381  33.937  -8.225  1.00  0.00           H  
ATOM   1936  N   VAL A 137     -10.872  33.359  -3.212  1.00  0.00           N  
ATOM   1937  CA  VAL A 137      -9.479  33.290  -2.722  1.00  0.00           C  
ATOM   1938  C   VAL A 137      -8.851  31.912  -2.936  1.00  0.00           C  
ATOM   1939  O   VAL A 137      -7.636  31.806  -3.073  1.00  0.00           O  
ATOM   1940  CB  VAL A 137      -9.325  33.700  -1.248  1.00  0.00           C  
ATOM   1941  CG1 VAL A 137     -10.022  35.018  -0.941  1.00  0.00           C  
ATOM   1942  CG2 VAL A 137      -9.811  32.618  -0.291  1.00  0.00           C  
ATOM   1943  H   VAL A 137     -11.621  33.452  -2.535  1.00  0.00           H  
ATOM   1944  HA  VAL A 137      -8.894  34.001  -3.302  1.00  0.00           H  
ATOM   1945  HB  VAL A 137      -8.270  33.858  -1.055  1.00  0.00           H  
ATOM   1946 HG11 VAL A 137      -9.729  35.765  -1.676  1.00  0.00           H  
ATOM   1947 HG12 VAL A 137     -11.096  34.877  -0.955  1.00  0.00           H  
ATOM   1948 HG13 VAL A 137      -9.730  35.346   0.050  1.00  0.00           H  
ATOM   1949 HG21 VAL A 137     -10.807  32.299  -0.584  1.00  0.00           H  
ATOM   1950 HG22 VAL A 137      -9.123  31.773  -0.342  1.00  0.00           H  
ATOM   1951 HG23 VAL A 137      -9.833  32.998   0.727  1.00  0.00           H  
ATOM   1952  N   ALA A 138      -9.660  30.849  -3.017  1.00  0.00           N  
ATOM   1953  CA  ALA A 138      -9.185  29.527  -3.411  1.00  0.00           C  
ATOM   1954  C   ALA A 138      -8.604  29.507  -4.837  1.00  0.00           C  
ATOM   1955  O   ALA A 138      -7.695  28.725  -5.132  1.00  0.00           O  
ATOM   1956  CB  ALA A 138     -10.343  28.535  -3.321  1.00  0.00           C  
ATOM   1957  H   ALA A 138     -10.641  30.964  -2.797  1.00  0.00           H  
ATOM   1958  HA  ALA A 138      -8.403  29.243  -2.707  1.00  0.00           H  
ATOM   1959  HB1 ALA A 138     -10.681  28.447  -2.290  1.00  0.00           H  
ATOM   1960  HB2 ALA A 138     -11.164  28.881  -3.950  1.00  0.00           H  
ATOM   1961  HB3 ALA A 138     -10.013  27.560  -3.680  1.00  0.00           H  
ATOM   1962  N   GLN A 139      -9.123  30.374  -5.712  1.00  0.00           N  
ATOM   1963  CA  GLN A 139      -8.641  30.568  -7.079  1.00  0.00           C  
ATOM   1964  C   GLN A 139      -7.548  31.654  -7.177  1.00  0.00           C  
ATOM   1965  O   GLN A 139      -6.904  31.774  -8.223  1.00  0.00           O  
ATOM   1966  CB  GLN A 139      -9.833  30.891  -7.997  1.00  0.00           C  
ATOM   1967  CG  GLN A 139     -10.769  29.684  -8.162  1.00  0.00           C  
ATOM   1968  CD  GLN A 139     -12.045  30.060  -8.908  1.00  0.00           C  
ATOM   1969  OE1 GLN A 139     -12.123  30.035 -10.131  1.00  0.00           O  
ATOM   1970  NE2 GLN A 139     -13.094  30.423  -8.200  1.00  0.00           N  
ATOM   1971  H   GLN A 139      -9.875  30.975  -5.397  1.00  0.00           H  
ATOM   1972  HA  GLN A 139      -8.205  29.627  -7.413  1.00  0.00           H  
ATOM   1973  HB2 GLN A 139     -10.393  31.731  -7.587  1.00  0.00           H  
ATOM   1974  HB3 GLN A 139      -9.464  31.174  -8.984  1.00  0.00           H  
ATOM   1975  HG2 GLN A 139     -10.251  28.899  -8.716  1.00  0.00           H  
ATOM   1976  HG3 GLN A 139     -11.042  29.281  -7.185  1.00  0.00           H  
ATOM   1977 HE21 GLN A 139     -13.019  30.447  -7.185  1.00  0.00           H  
ATOM   1978 HE22 GLN A 139     -13.951  30.652  -8.681  1.00  0.00           H  
ATOM   1979  N   MET A 140      -7.294  32.419  -6.104  1.00  0.00           N  
ATOM   1980  CA  MET A 140      -6.129  33.311  -6.015  1.00  0.00           C  
ATOM   1981  C   MET A 140      -4.826  32.477  -6.020  1.00  0.00           C  
ATOM   1982  O   MET A 140      -4.801  31.404  -5.400  1.00  0.00           O  
ATOM   1983  CB  MET A 140      -6.224  34.163  -4.734  1.00  0.00           C  
ATOM   1984  CG  MET A 140      -5.189  35.295  -4.721  1.00  0.00           C  
ATOM   1985  SD  MET A 140      -5.359  36.520  -3.393  1.00  0.00           S  
ATOM   1986  CE  MET A 140      -5.253  35.459  -1.927  1.00  0.00           C  
ATOM   1987  H   MET A 140      -7.838  32.267  -5.263  1.00  0.00           H  
ATOM   1988  HA  MET A 140      -6.152  33.981  -6.874  1.00  0.00           H  
ATOM   1989  HB2 MET A 140      -7.220  34.596  -4.657  1.00  0.00           H  
ATOM   1990  HB3 MET A 140      -6.071  33.533  -3.858  1.00  0.00           H  
ATOM   1991  HG2 MET A 140      -4.194  34.860  -4.651  1.00  0.00           H  
ATOM   1992  HG3 MET A 140      -5.250  35.830  -5.667  1.00  0.00           H  
ATOM   1993  HE1 MET A 140      -6.107  34.783  -1.900  1.00  0.00           H  
ATOM   1994  HE2 MET A 140      -4.329  34.880  -1.955  1.00  0.00           H  
ATOM   1995  HE3 MET A 140      -5.265  36.078  -1.031  1.00  0.00           H  
ATOM   1996  N   PRO A 141      -3.738  32.919  -6.686  1.00  0.00           N  
ATOM   1997  CA  PRO A 141      -2.420  32.288  -6.568  1.00  0.00           C  
ATOM   1998  C   PRO A 141      -1.952  32.115  -5.112  1.00  0.00           C  
ATOM   1999  O   PRO A 141      -2.292  32.916  -4.238  1.00  0.00           O  
ATOM   2000  CB  PRO A 141      -1.461  33.192  -7.354  1.00  0.00           C  
ATOM   2001  CG  PRO A 141      -2.365  33.884  -8.369  1.00  0.00           C  
ATOM   2002  CD  PRO A 141      -3.675  34.050  -7.603  1.00  0.00           C  
ATOM   2003  HA  PRO A 141      -2.462  31.310  -7.051  1.00  0.00           H  
ATOM   2004  HB2 PRO A 141      -1.027  33.945  -6.695  1.00  0.00           H  
ATOM   2005  HB3 PRO A 141      -0.674  32.621  -7.849  1.00  0.00           H  
ATOM   2006  HG2 PRO A 141      -1.957  34.844  -8.687  1.00  0.00           H  
ATOM   2007  HG3 PRO A 141      -2.521  33.228  -9.225  1.00  0.00           H  
ATOM   2008  HD2 PRO A 141      -3.647  34.983  -7.041  1.00  0.00           H  
ATOM   2009  HD3 PRO A 141      -4.512  34.052  -8.303  1.00  0.00           H  
ATOM   2010  N   GLN A 142      -1.124  31.100  -4.852  1.00  0.00           N  
ATOM   2011  CA  GLN A 142      -0.462  30.906  -3.549  1.00  0.00           C  
ATOM   2012  C   GLN A 142       0.911  31.598  -3.474  1.00  0.00           C  
ATOM   2013  O   GLN A 142       1.401  31.887  -2.381  1.00  0.00           O  
ATOM   2014  CB  GLN A 142      -0.309  29.400  -3.278  1.00  0.00           C  
ATOM   2015  CG  GLN A 142      -1.647  28.675  -3.039  1.00  0.00           C  
ATOM   2016  CD  GLN A 142      -2.319  29.095  -1.733  1.00  0.00           C  
ATOM   2017  OE1 GLN A 142      -3.193  29.952  -1.693  1.00  0.00           O  
ATOM   2018  NE2 GLN A 142      -1.940  28.517  -0.612  1.00  0.00           N  
ATOM   2019  H   GLN A 142      -0.913  30.449  -5.596  1.00  0.00           H  
ATOM   2020  HA  GLN A 142      -1.071  31.351  -2.759  1.00  0.00           H  
ATOM   2021  HB2 GLN A 142       0.195  28.936  -4.127  1.00  0.00           H  
ATOM   2022  HB3 GLN A 142       0.323  29.260  -2.401  1.00  0.00           H  
ATOM   2023  HG2 GLN A 142      -2.325  28.865  -3.871  1.00  0.00           H  
ATOM   2024  HG3 GLN A 142      -1.457  27.602  -3.005  1.00  0.00           H  
ATOM   2025 HE21 GLN A 142      -1.218  27.810  -0.619  1.00  0.00           H  
ATOM   2026 HE22 GLN A 142      -2.386  28.796   0.249  1.00  0.00           H  
ATOM   2027  N   GLU A 143       1.525  31.889  -4.624  1.00  0.00           N  
ATOM   2028  CA  GLU A 143       2.761  32.659  -4.760  1.00  0.00           C  
ATOM   2029  C   GLU A 143       2.460  34.149  -5.013  1.00  0.00           C  
ATOM   2030  O   GLU A 143       1.377  34.520  -5.467  1.00  0.00           O  
ATOM   2031  CB  GLU A 143       3.574  32.032  -5.904  1.00  0.00           C  
ATOM   2032  CG  GLU A 143       5.018  32.531  -5.977  1.00  0.00           C  
ATOM   2033  CD  GLU A 143       5.849  31.692  -6.965  1.00  0.00           C  
ATOM   2034  OE1 GLU A 143       5.811  31.971  -8.190  1.00  0.00           O  
ATOM   2035  OE2 GLU A 143       6.550  30.747  -6.526  1.00  0.00           O  
ATOM   2036  H   GLU A 143       1.063  31.635  -5.479  1.00  0.00           H  
ATOM   2037  HA  GLU A 143       3.334  32.584  -3.837  1.00  0.00           H  
ATOM   2038  HB2 GLU A 143       3.604  30.952  -5.754  1.00  0.00           H  
ATOM   2039  HB3 GLU A 143       3.079  32.240  -6.853  1.00  0.00           H  
ATOM   2040  HG2 GLU A 143       5.016  33.574  -6.295  1.00  0.00           H  
ATOM   2041  HG3 GLU A 143       5.453  32.474  -4.977  1.00  0.00           H  
ATOM   2042  N   GLU A 144       3.436  35.012  -4.740  1.00  0.00           N  
ATOM   2043  CA  GLU A 144       3.293  36.473  -4.734  1.00  0.00           C  
ATOM   2044  C   GLU A 144       4.324  37.139  -5.658  1.00  0.00           C  
ATOM   2045  O   GLU A 144       5.489  36.734  -5.709  1.00  0.00           O  
ATOM   2046  CB  GLU A 144       3.414  36.956  -3.280  1.00  0.00           C  
ATOM   2047  CG  GLU A 144       3.248  38.470  -3.093  1.00  0.00           C  
ATOM   2048  CD  GLU A 144       3.106  38.790  -1.595  1.00  0.00           C  
ATOM   2049  OE1 GLU A 144       1.972  38.698  -1.068  1.00  0.00           O  
ATOM   2050  OE2 GLU A 144       4.130  39.098  -0.939  1.00  0.00           O  
ATOM   2051  H   GLU A 144       4.334  34.630  -4.477  1.00  0.00           H  
ATOM   2052  HA  GLU A 144       2.303  36.744  -5.097  1.00  0.00           H  
ATOM   2053  HB2 GLU A 144       2.648  36.449  -2.693  1.00  0.00           H  
ATOM   2054  HB3 GLU A 144       4.388  36.662  -2.883  1.00  0.00           H  
ATOM   2055  HG2 GLU A 144       4.119  38.985  -3.508  1.00  0.00           H  
ATOM   2056  HG3 GLU A 144       2.366  38.822  -3.632  1.00  0.00           H  
ATOM   2057  N   VAL A 145       3.882  38.164  -6.396  1.00  0.00           N  
ATOM   2058  CA  VAL A 145       4.690  38.873  -7.400  1.00  0.00           C  
ATOM   2059  C   VAL A 145       4.329  40.361  -7.461  1.00  0.00           C  
ATOM   2060  O   VAL A 145       3.198  40.766  -7.178  1.00  0.00           O  
ATOM   2061  CB  VAL A 145       4.560  38.169  -8.774  1.00  0.00           C  
ATOM   2062  CG1 VAL A 145       3.211  38.341  -9.464  1.00  0.00           C  
ATOM   2063  CG2 VAL A 145       5.642  38.636  -9.747  1.00  0.00           C  
ATOM   2064  H   VAL A 145       2.921  38.457  -6.292  1.00  0.00           H  
ATOM   2065  HA  VAL A 145       5.737  38.821  -7.102  1.00  0.00           H  
ATOM   2066  HB  VAL A 145       4.670  37.094  -8.621  1.00  0.00           H  
ATOM   2067 HG11 VAL A 145       2.443  37.926  -8.820  1.00  0.00           H  
ATOM   2068 HG12 VAL A 145       3.017  39.391  -9.674  1.00  0.00           H  
ATOM   2069 HG13 VAL A 145       3.204  37.785 -10.402  1.00  0.00           H  
ATOM   2070 HG21 VAL A 145       5.454  39.673 -10.027  1.00  0.00           H  
ATOM   2071 HG22 VAL A 145       6.623  38.550  -9.283  1.00  0.00           H  
ATOM   2072 HG23 VAL A 145       5.617  38.020 -10.645  1.00  0.00           H  
ATOM   2073  N   GLU A 146       5.305  41.189  -7.826  1.00  0.00           N  
ATOM   2074  CA  GLU A 146       5.110  42.613  -8.111  1.00  0.00           C  
ATOM   2075  C   GLU A 146       4.307  42.830  -9.408  1.00  0.00           C  
ATOM   2076  O   GLU A 146       4.432  42.070 -10.374  1.00  0.00           O  
ATOM   2077  CB  GLU A 146       6.495  43.273  -8.227  1.00  0.00           C  
ATOM   2078  CG  GLU A 146       6.448  44.807  -8.124  1.00  0.00           C  
ATOM   2079  CD  GLU A 146       6.124  45.323  -6.708  1.00  0.00           C  
ATOM   2080  OE1 GLU A 146       5.910  44.501  -5.783  1.00  0.00           O  
ATOM   2081  OE2 GLU A 146       6.135  46.561  -6.510  1.00  0.00           O  
ATOM   2082  H   GLU A 146       6.212  40.795  -8.025  1.00  0.00           H  
ATOM   2083  HA  GLU A 146       4.561  43.059  -7.283  1.00  0.00           H  
ATOM   2084  HB2 GLU A 146       7.152  42.893  -7.443  1.00  0.00           H  
ATOM   2085  HB3 GLU A 146       6.937  42.986  -9.180  1.00  0.00           H  
ATOM   2086  HG2 GLU A 146       7.424  45.190  -8.421  1.00  0.00           H  
ATOM   2087  HG3 GLU A 146       5.723  45.205  -8.833  1.00  0.00           H  
ATOM   2088  N   LEU A 147       3.497  43.893  -9.453  1.00  0.00           N  
ATOM   2089  CA  LEU A 147       2.782  44.291 -10.678  1.00  0.00           C  
ATOM   2090  C   LEU A 147       3.683  44.978 -11.723  1.00  0.00           C  
ATOM   2091  O   LEU A 147       4.709  45.582 -11.397  1.00  0.00           O  
ATOM   2092  CB  LEU A 147       1.618  45.229 -10.317  1.00  0.00           C  
ATOM   2093  CG  LEU A 147       0.491  44.548  -9.530  1.00  0.00           C  
ATOM   2094  CD1 LEU A 147      -0.577  45.572  -9.177  1.00  0.00           C  
ATOM   2095  CD2 LEU A 147      -0.182  43.426 -10.324  1.00  0.00           C  
ATOM   2096  H   LEU A 147       3.462  44.497  -8.641  1.00  0.00           H  
ATOM   2097  HA  LEU A 147       2.378  43.398 -11.155  1.00  0.00           H  
ATOM   2098  HB2 LEU A 147       2.013  46.064  -9.735  1.00  0.00           H  
ATOM   2099  HB3 LEU A 147       1.191  45.638 -11.233  1.00  0.00           H  
ATOM   2100  HG  LEU A 147       0.897  44.152  -8.599  1.00  0.00           H  
ATOM   2101 HD11 LEU A 147      -0.096  46.503  -8.890  1.00  0.00           H  
ATOM   2102 HD12 LEU A 147      -1.225  45.764 -10.032  1.00  0.00           H  
ATOM   2103 HD13 LEU A 147      -1.165  45.192  -8.342  1.00  0.00           H  
ATOM   2104 HD21 LEU A 147      -0.409  43.767 -11.333  1.00  0.00           H  
ATOM   2105 HD22 LEU A 147       0.475  42.558 -10.374  1.00  0.00           H  
ATOM   2106 HD23 LEU A 147      -1.113  43.138  -9.842  1.00  0.00           H  
ATOM   2107  N   LEU A 148       3.251  44.927 -12.985  1.00  0.00           N  
ATOM   2108  CA  LEU A 148       3.819  45.714 -14.088  1.00  0.00           C  
ATOM   2109  C   LEU A 148       3.495  47.219 -13.912  1.00  0.00           C  
ATOM   2110  O   LEU A 148       2.491  47.556 -13.270  1.00  0.00           O  
ATOM   2111  CB  LEU A 148       3.252  45.196 -15.425  1.00  0.00           C  
ATOM   2112  CG  LEU A 148       3.632  43.746 -15.786  1.00  0.00           C  
ATOM   2113  CD1 LEU A 148       2.948  43.350 -17.094  1.00  0.00           C  
ATOM   2114  CD2 LEU A 148       5.141  43.565 -15.965  1.00  0.00           C  
ATOM   2115  H   LEU A 148       2.395  44.422 -13.167  1.00  0.00           H  
ATOM   2116  HA  LEU A 148       4.904  45.599 -14.082  1.00  0.00           H  
ATOM   2117  HB2 LEU A 148       2.163  45.274 -15.389  1.00  0.00           H  
ATOM   2118  HB3 LEU A 148       3.598  45.848 -16.226  1.00  0.00           H  
ATOM   2119  HG  LEU A 148       3.287  43.071 -15.003  1.00  0.00           H  
ATOM   2120 HD11 LEU A 148       1.867  43.442 -16.986  1.00  0.00           H  
ATOM   2121 HD12 LEU A 148       3.284  43.998 -17.906  1.00  0.00           H  
ATOM   2122 HD13 LEU A 148       3.187  42.315 -17.337  1.00  0.00           H  
ATOM   2123 HD21 LEU A 148       5.518  44.269 -16.708  1.00  0.00           H  
ATOM   2124 HD22 LEU A 148       5.653  43.728 -15.017  1.00  0.00           H  
ATOM   2125 HD23 LEU A 148       5.353  42.547 -16.294  1.00  0.00           H  
ATOM   2126  N   PRO A 149       4.297  48.141 -14.482  1.00  0.00           N  
ATOM   2127  CA  PRO A 149       4.065  49.579 -14.343  1.00  0.00           C  
ATOM   2128  C   PRO A 149       2.812  50.043 -15.123  1.00  0.00           C  
ATOM   2129  O   PRO A 149       2.512  49.489 -16.190  1.00  0.00           O  
ATOM   2130  CB  PRO A 149       5.345  50.246 -14.858  1.00  0.00           C  
ATOM   2131  CG  PRO A 149       5.903  49.239 -15.862  1.00  0.00           C  
ATOM   2132  CD  PRO A 149       5.489  47.886 -15.281  1.00  0.00           C  
ATOM   2133  HA  PRO A 149       3.948  49.814 -13.286  1.00  0.00           H  
ATOM   2134  HB2 PRO A 149       5.150  51.215 -15.322  1.00  0.00           H  
ATOM   2135  HB3 PRO A 149       6.050  50.359 -14.033  1.00  0.00           H  
ATOM   2136  HG2 PRO A 149       5.419  49.381 -16.829  1.00  0.00           H  
ATOM   2137  HG3 PRO A 149       6.985  49.321 -15.960  1.00  0.00           H  
ATOM   2138  HD2 PRO A 149       5.294  47.187 -16.093  1.00  0.00           H  
ATOM   2139  HD3 PRO A 149       6.276  47.493 -14.640  1.00  0.00           H  
ATOM   2140  N   PRO A 150       2.078  51.060 -14.632  1.00  0.00           N  
ATOM   2141  CA  PRO A 150       0.885  51.591 -15.296  1.00  0.00           C  
ATOM   2142  C   PRO A 150       1.229  52.434 -16.538  1.00  0.00           C  
ATOM   2143  O   PRO A 150       2.343  52.944 -16.686  1.00  0.00           O  
ATOM   2144  CB  PRO A 150       0.185  52.437 -14.226  1.00  0.00           C  
ATOM   2145  CG  PRO A 150       1.341  52.949 -13.371  1.00  0.00           C  
ATOM   2146  CD  PRO A 150       2.322  51.778 -13.386  1.00  0.00           C  
ATOM   2147  HA  PRO A 150       0.227  50.775 -15.595  1.00  0.00           H  
ATOM   2148  HB2 PRO A 150      -0.397  53.256 -14.653  1.00  0.00           H  
ATOM   2149  HB3 PRO A 150      -0.458  51.796 -13.620  1.00  0.00           H  
ATOM   2150  HG2 PRO A 150       1.798  53.817 -13.850  1.00  0.00           H  
ATOM   2151  HG3 PRO A 150       1.019  53.195 -12.358  1.00  0.00           H  
ATOM   2152  HD2 PRO A 150       3.348  52.149 -13.333  1.00  0.00           H  
ATOM   2153  HD3 PRO A 150       2.117  51.118 -12.542  1.00  0.00           H  
ATOM   2154  N   ALA A 151       0.243  52.620 -17.421  1.00  0.00           N  
ATOM   2155  CA  ALA A 151       0.326  53.559 -18.542  1.00  0.00           C  
ATOM   2156  C   ALA A 151       0.406  55.032 -18.057  1.00  0.00           C  
ATOM   2157  O   ALA A 151      -0.161  55.362 -17.006  1.00  0.00           O  
ATOM   2158  CB  ALA A 151      -0.897  53.335 -19.441  1.00  0.00           C  
ATOM   2159  H   ALA A 151      -0.647  52.179 -17.242  1.00  0.00           H  
ATOM   2160  HA  ALA A 151       1.223  53.324 -19.116  1.00  0.00           H  
ATOM   2161  HB1 ALA A 151      -0.916  52.302 -19.792  1.00  0.00           H  
ATOM   2162  HB2 ALA A 151      -1.813  53.545 -18.886  1.00  0.00           H  
ATOM   2163  HB3 ALA A 151      -0.848  53.998 -20.306  1.00  0.00           H  
ATOM   2164  N   PRO A 152       1.068  55.938 -18.806  1.00  0.00           N  
ATOM   2165  CA  PRO A 152       1.161  57.356 -18.450  1.00  0.00           C  
ATOM   2166  C   PRO A 152      -0.175  58.097 -18.641  1.00  0.00           C  
ATOM   2167  O   PRO A 152      -1.010  57.719 -19.472  1.00  0.00           O  
ATOM   2168  CB  PRO A 152       2.255  57.923 -19.360  1.00  0.00           C  
ATOM   2169  CG  PRO A 152       2.171  57.045 -20.608  1.00  0.00           C  
ATOM   2170  CD  PRO A 152       1.790  55.677 -20.045  1.00  0.00           C  
ATOM   2171  HA  PRO A 152       1.475  57.457 -17.411  1.00  0.00           H  
ATOM   2172  HB2 PRO A 152       2.098  58.978 -19.597  1.00  0.00           H  
ATOM   2173  HB3 PRO A 152       3.228  57.783 -18.888  1.00  0.00           H  
ATOM   2174  HG2 PRO A 152       1.374  57.407 -21.260  1.00  0.00           H  
ATOM   2175  HG3 PRO A 152       3.119  57.011 -21.146  1.00  0.00           H  
ATOM   2176  HD2 PRO A 152       1.172  55.136 -20.764  1.00  0.00           H  
ATOM   2177  HD3 PRO A 152       2.692  55.105 -19.824  1.00  0.00           H  
ATOM   2178  N   LYS A 153      -0.364  59.188 -17.885  1.00  0.00           N  
ATOM   2179  CA  LYS A 153      -1.494  60.126 -18.043  1.00  0.00           C  
ATOM   2180  C   LYS A 153      -1.467  60.881 -19.384  1.00  0.00           C  
ATOM   2181  O   LYS A 153      -0.423  60.974 -20.035  1.00  0.00           O  
ATOM   2182  CB  LYS A 153      -1.586  61.084 -16.832  1.00  0.00           C  
ATOM   2183  CG  LYS A 153      -0.595  62.270 -16.786  1.00  0.00           C  
ATOM   2184  CD  LYS A 153       0.886  61.929 -16.562  1.00  0.00           C  
ATOM   2185  CE  LYS A 153       1.122  61.261 -15.199  1.00  0.00           C  
ATOM   2186  NZ  LYS A 153       2.568  61.040 -14.940  1.00  0.00           N  
ATOM   2187  H   LYS A 153       0.359  59.419 -17.220  1.00  0.00           H  
ATOM   2188  HA  LYS A 153      -2.410  59.530 -18.046  1.00  0.00           H  
ATOM   2189  HB2 LYS A 153      -2.589  61.516 -16.836  1.00  0.00           H  
ATOM   2190  HB3 LYS A 153      -1.506  60.507 -15.911  1.00  0.00           H  
ATOM   2191  HG2 LYS A 153      -0.682  62.843 -17.710  1.00  0.00           H  
ATOM   2192  HG3 LYS A 153      -0.908  62.931 -15.977  1.00  0.00           H  
ATOM   2193  HD2 LYS A 153       1.250  61.290 -17.367  1.00  0.00           H  
ATOM   2194  HD3 LYS A 153       1.452  62.860 -16.597  1.00  0.00           H  
ATOM   2195  HE2 LYS A 153       0.705  61.906 -14.420  1.00  0.00           H  
ATOM   2196  HE3 LYS A 153       0.587  60.308 -15.163  1.00  0.00           H  
ATOM   2197  HZ1 LYS A 153       2.988  60.442 -15.638  1.00  0.00           H  
ATOM   2198  HZ2 LYS A 153       3.076  61.914 -14.935  1.00  0.00           H  
ATOM   2199  HZ3 LYS A 153       2.712  60.605 -14.037  1.00  0.00           H  
ATOM   2200  N   GLY A 154      -2.607  61.464 -19.763  1.00  0.00           N  
ATOM   2201  CA  GLY A 154      -2.775  62.227 -21.013  1.00  0.00           C  
ATOM   2202  C   GLY A 154      -3.759  63.408 -20.951  1.00  0.00           C  
ATOM   2203  O   GLY A 154      -4.045  64.008 -21.992  1.00  0.00           O  
ATOM   2204  H   GLY A 154      -3.423  61.288 -19.196  1.00  0.00           H  
ATOM   2205  HA2 GLY A 154      -1.811  62.632 -21.326  1.00  0.00           H  
ATOM   2206  HA3 GLY A 154      -3.122  61.544 -21.791  1.00  0.00           H  
ATOM   2207  N   LYS A 155      -4.281  63.748 -19.763  1.00  0.00           N  
ATOM   2208  CA  LYS A 155      -5.134  64.929 -19.516  1.00  0.00           C  
ATOM   2209  C   LYS A 155      -4.321  66.235 -19.550  1.00  0.00           C  
ATOM   2210  O   LYS A 155      -4.729  67.169 -20.278  1.00  0.00           O  
ATOM   2211  CB  LYS A 155      -5.889  64.735 -18.188  1.00  0.00           C  
ATOM   2212  CG  LYS A 155      -6.885  65.878 -17.914  1.00  0.00           C  
ATOM   2213  CD  LYS A 155      -7.738  65.647 -16.655  1.00  0.00           C  
ATOM   2214  CE  LYS A 155      -8.712  64.462 -16.756  1.00  0.00           C  
ATOM   2215  NZ  LYS A 155      -9.778  64.690 -17.768  1.00  0.00           N  
ATOM   2216  OXT LYS A 155      -3.285  66.322 -18.852  1.00  0.00           O  
ATOM   2217  H   LYS A 155      -3.964  63.232 -18.956  1.00  0.00           H  
ATOM   2218  HA  LYS A 155      -5.869  65.000 -20.318  1.00  0.00           H  
ATOM   2219  HB2 LYS A 155      -6.434  63.791 -18.239  1.00  0.00           H  
ATOM   2220  HB3 LYS A 155      -5.176  64.678 -17.364  1.00  0.00           H  
ATOM   2221  HG2 LYS A 155      -6.326  66.804 -17.773  1.00  0.00           H  
ATOM   2222  HG3 LYS A 155      -7.537  66.007 -18.778  1.00  0.00           H  
ATOM   2223  HD2 LYS A 155      -7.069  65.473 -15.810  1.00  0.00           H  
ATOM   2224  HD3 LYS A 155      -8.306  66.554 -16.444  1.00  0.00           H  
ATOM   2225  HE2 LYS A 155      -8.151  63.555 -16.998  1.00  0.00           H  
ATOM   2226  HE3 LYS A 155      -9.173  64.314 -15.776  1.00  0.00           H  
ATOM   2227  HZ1 LYS A 155     -10.313  65.521 -17.553  1.00  0.00           H  
ATOM   2228  HZ2 LYS A 155      -9.392  64.796 -18.696  1.00  0.00           H  
ATOM   2229  HZ3 LYS A 155     -10.423  63.911 -17.794  1.00  0.00           H  
TER    2230      LYS A 155                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
