
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  114 (  953),  selected  114 , name 1x0j_A
# Molecule2: number of CA atoms  130 ( 1064),  selected  130 , name T0432.pdb
# PARAMETERS: 1x0j_A.T0432.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    73_A      S       1           -
LGA    -       -      M       2           -
LGA    -       -      Q       3           -
LGA    -       -      E       4           -
LGA    R    74_A      E       5           #
LGA    -       -      D       6           -
LGA    -       -      T       7           -
LGA    V    75_A      F       8          2.276
LGA    T    76_A      R       9          4.525
LGA    N    77_A      E      10          3.433
LGA    Q    78_A      L      11          3.622
LGA    L    79_A      R      12          3.629
LGA    Q    80_A      I      13          2.564
LGA    Y    81_A      F      14          1.868
LGA    L    82_A      L      15          2.153
LGA    H    83_A      R      16          1.651
LGA    K    84_A      N      17          1.194
LGA    V    85_A      V      18          2.972
LGA    V    86_A      -       -           -
LGA    X    87_A      T      19          0.925
LGA    K    88_A      H      20          1.668
LGA    A    89_A      R      21          1.226
LGA    L    90_A      L      22          0.494
LGA    W    91_A      A      23          0.597
LGA    K    92_A      I      24          0.537
LGA    H    93_A      D      25          0.380
LGA    Q    94_A      K      26          0.663
LGA    F    95_A      R      27          1.243
LGA    A    96_A      F      28          1.748
LGA    W    97_A      R      29          1.404
LGA    P    98_A      V      30          1.076
LGA    F    99_A      F      31          0.987
LGA    R   100_A      T      32          1.006
LGA    Q   101_A      K      33          1.306
LGA    P   102_A      P      34          0.847
LGA    V   103_A      V      35          1.057
LGA    D   104_A      D      36          1.285
LGA    A   105_A      P      37          2.936
LGA    V   106_A      D      38          1.681
LGA    K   107_A      E      39          2.009
LGA    L   108_A      V      40          3.628
LGA    G   109_A      -       -           -
LGA    L   110_A      -       -           -
LGA    P   111_A      P      41          3.135
LGA    D   112_A      D      42          2.469
LGA    Y   113_A      Y      43          1.761
LGA    H   114_A      V      44          2.178
LGA    K   115_A      T      45          2.275
LGA    I   116_A      V      46          1.766
LGA    I   117_A      I      47          0.884
LGA    K   118_A      K      48          0.526
LGA    Q   119_A      Q      49          0.475
LGA    P   120_A      P      50          0.600
LGA    X   121_A      M      51          0.616
LGA    D   122_A      D      52          0.764
LGA    X   123_A      L      53          0.523
LGA    G   124_A      S      54          0.325
LGA    T   125_A      S      55          0.542
LGA    I   126_A      V      56          0.363
LGA    K   127_A      I      57          0.687
LGA    R   128_A      S      58          1.306
LGA    R   129_A      K      59          1.322
LGA    L   130_A      I      60          1.158
LGA    E   131_A      D      61          2.310
LGA    N   132_A      L      62          2.956
LGA    N   133_A      H      63          2.103
LGA    Y   134_A      K      64          2.560
LGA    Y   135_A      Y      65          2.001
LGA    W   136_A      L      66          2.110
LGA    A   137_A      T      67          2.014
LGA    A   138_A      V      68          2.035
LGA    S   139_A      K      69          1.343
LGA    E   140_A      D      70          1.068
LGA    C   141_A      Y      71          1.224
LGA    X   142_A      L      72          1.081
LGA    Q   143_A      R      73          0.606
LGA    D   144_A      D      74          0.863
LGA    F   145_A      I      75          0.976
LGA    N   146_A      D      76          0.776
LGA    T   147_A      L      77          0.740
LGA    X   148_A      I      78          1.015
LGA    F   149_A      C      79          0.822
LGA    T   150_A      S      80          0.416
LGA    N   151_A      N      81          0.245
LGA    C   152_A      A      82          0.332
LGA    Y   153_A      L      83          0.364
LGA    I   154_A      E      84          0.691
LGA    Y   155_A      Y      85          0.913
LGA    N   156_A      N      86          0.622
LGA    K   157_A      P      87          2.613
LGA    P   158_A      D      88          3.653
LGA    T   159_A      R      89          3.213
LGA    -       -      D      90           -
LGA    -       -      P      91           -
LGA    -       -      G      92           -
LGA    D   160_A      D      93          0.912
LGA    -       -      R      94           -
LGA    D   161_A      L      95          1.917
LGA    I   162_A      I      96          1.195
LGA    V   163_A      R      97          1.202
LGA    L   164_A      H      98          1.575
LGA    X   165_A      R      99          1.418
LGA    A   166_A      A     100          1.067
LGA    Q   167_A      C     101          1.589
LGA    T   168_A      A     102          1.818
LGA    L   169_A      L     103          1.546
LGA    E   170_A      R     104          1.548
LGA    K   171_A      D     105          1.587
LGA    I   172_A      T     106          0.683
LGA    F   173_A      A     107          1.054
LGA    L   174_A      Y     108          1.469
LGA    Q   175_A      A     109          0.852
LGA    K   176_A      I     110          0.997
LGA    V   177_A      I     111          1.949
LGA    A   178_A      K     112          1.049
LGA    S   179_A      E     113          1.835
LGA    X   180_A      E     114          3.719
LGA    P   181_A      L     115          2.430
LGA    -       -      D     116           -
LGA    Q   182_A      E     117          2.284
LGA    E   183_A      D     118          3.121
LGA    E   184_A      F     119          2.915
LGA    -       -      E     120           -
LGA    -       -      Q     121           -
LGA    -       -      L     122           -
LGA    Q   185_A      C     123          4.587
LGA    E   186_A      E     124           -
LGA    -       -      E     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      E     128           -
LGA    -       -      S     129           -
LGA    -       -      R     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  114  130    5.0    108    1.85    22.22     74.626     5.527

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.467899 * X  +   0.717425 * Y  +  -0.516113 * Z  + -32.899746
  Y_new =  -0.883454 * X  +   0.395590 * Y  +  -0.251032 * Z  +  54.718929
  Z_new =   0.024072 * X  +   0.573420 * Y  +   0.818908 * Z  + -30.420124 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.610877   -2.530715  [ DEG:    35.0007   -144.9993 ]
  Theta =  -0.024075   -3.117518  [ DEG:    -1.3794   -178.6206 ]
  Phi   =  -1.083731    2.057862  [ DEG:   -62.0932    117.9068 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x0j_A                                        
REMARK     2: T0432.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x0j_A.T0432.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  114  130   5.0  108   1.85   22.22  74.626
REMARK  ---------------------------------------------------------- 
MOLECULE 1x0j_A
HEADER    TRANSCRIPTION                           23-MAR-05   1X0J              
TITLE     CRYSTAL STRUCTURE ANALYSIS OF THE N-TERMINAL BROMODOMAIN OF           
TITLE    2 HUMAN BRD2                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BROMODOMAIN-CONTAINING PROTEIN 2;                          
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: N-TERMINAL BROMODOMAIN;                                    
COMPND   5 SYNONYM: BRD2, RING3 PROTEIN, O27.1.1;                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PCR2.1-TOPO VECTOR;                       
SOURCE   8 OTHER_DETAILS: EXPRESSED BY CELL-FREE EXPRESSION METHOD              
KEYWDS    ALPHA-HELICAL DOMAIN, BROMODOMAIN, BINDS TO ACETYLATED                
KEYWDS   2 HISTONES, STRUCTURAL GENOMICS, RIKEN STRUCTURAL                      
KEYWDS   3 GENOMICS/PROTEOMICS INITIATIVE, RSGI, NPPSFA, NATIONAL               
KEYWDS   4 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.NAKAMURA,T.UMEHARA,M.SHIROUZU,B.PADMANABHAN,S.YOKOYAMA,             
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   27-JUN-06 1X0J    0                                                
JRNL        AUTH   Y.NAKAMURA,T.UMEHARA,M.SHIROUZU,B.PADMANABHAN,               
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   STRUCTURAL BASIS FOR ACETYLATED HISTONE H4                   
JRNL        TITL 2 RECOGNITION BY THE HUMAN BRD2 BROMODOMAIN                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1X0J A   73   194  UNP    P25440   BRD2_HUMAN      73    194             
DBREF  1X0J B   73   194  UNP    P25440   BRD2_HUMAN      73    194             
DBREF  1X0J C   73   194  UNP    P25440   BRD2_HUMAN      73    194             
SEQRES   1 A  122  GLY ARG VAL THR ASN GLN LEU GLN TYR LEU HIS LYS VAL          
SEQRES   2 A  122  VAL MSE LYS ALA LEU TRP LYS HIS GLN PHE ALA TRP PRO          
SEQRES   3 A  122  PHE ARG GLN PRO VAL ASP ALA VAL LYS LEU GLY LEU PRO          
SEQRES   4 A  122  ASP TYR HIS LYS ILE ILE LYS GLN PRO MSE ASP MSE GLY          
SEQRES   5 A  122  THR ILE LYS ARG ARG LEU GLU ASN ASN TYR TYR TRP ALA          
SEQRES   6 A  122  ALA SER GLU CYS MSE GLN ASP PHE ASN THR MSE PHE THR          
SEQRES   7 A  122  ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL          
SEQRES   8 A  122  LEU MSE ALA GLN THR LEU GLU LYS ILE PHE LEU GLN LYS          
SEQRES   9 A  122  VAL ALA SER MSE PRO GLN GLU GLU GLN GLU LEU VAL VAL          
SEQRES  10 A  122  THR ILE PRO LYS ASN                                          
SEQRES   1 B  122  GLY ARG VAL THR ASN GLN LEU GLN TYR LEU HIS LYS VAL          
SEQRES   2 B  122  VAL MSE LYS ALA LEU TRP LYS HIS GLN PHE ALA TRP PRO          
SEQRES   3 B  122  PHE ARG GLN PRO VAL ASP ALA VAL LYS LEU GLY LEU PRO          
SEQRES   4 B  122  ASP TYR HIS LYS ILE ILE LYS GLN PRO MSE ASP MSE GLY          
SEQRES   5 B  122  THR ILE LYS ARG ARG LEU GLU ASN ASN TYR TYR TRP ALA          
SEQRES   6 B  122  ALA SER GLU CYS MSE GLN ASP PHE ASN THR MSE PHE THR          
SEQRES   7 B  122  ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL          
SEQRES   8 B  122  LEU MSE ALA GLN THR LEU GLU LYS ILE PHE LEU GLN LYS          
SEQRES   9 B  122  VAL ALA SER MSE PRO GLN GLU GLU GLN GLU LEU VAL VAL          
SEQRES  10 B  122  THR ILE PRO LYS ASN                                          
SEQRES   1 C  122  GLY ARG VAL THR ASN GLN LEU GLN TYR LEU HIS LYS VAL          
SEQRES   2 C  122  VAL MSE LYS ALA LEU TRP LYS HIS GLN PHE ALA TRP PRO          
SEQRES   3 C  122  PHE ARG GLN PRO VAL ASP ALA VAL LYS LEU GLY LEU PRO          
SEQRES   4 C  122  ASP TYR HIS LYS ILE ILE LYS GLN PRO MSE ASP MSE GLY          
SEQRES   5 C  122  THR ILE LYS ARG ARG LEU GLU ASN ASN TYR TYR TRP ALA          
SEQRES   6 C  122  ALA SER GLU CYS MSE GLN ASP PHE ASN THR MSE PHE THR          
SEQRES   7 C  122  ASN CYS TYR ILE TYR ASN LYS PRO THR ASP ASP ILE VAL          
SEQRES   8 C  122  LEU MSE ALA GLN THR LEU GLU LYS ILE PHE LEU GLN LYS          
SEQRES   9 C  122  VAL ALA SER MSE PRO GLN GLU GLU GLN GLU LEU VAL VAL          
SEQRES  10 C  122  THR ILE PRO LYS ASN                                          
HET    MSE  A  87       8                                                       
HET    MSE  A 121       8                                                       
HET    MSE  A 123       8                                                       
HET    MSE  A 142       8                                                       
HET    MSE  A 148       8                                                       
HET    MSE  A 165       8                                                       
HET    MSE  A 180       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 121       8                                                       
HET    MSE  B 123       8                                                       
HET    MSE  B 142       8                                                       
HET    MSE  B 148       8                                                       
HET    MSE  B 165       8                                                       
HET    MSE  B 180       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  C 121       8                                                       
HET    MSE  C 123       8                                                       
HET    MSE  C 142       8                                                       
HET    MSE  C 148       8                                                       
HET    MSE  C 165       8                                                       
HET    MSE  C 180       8                                                       
HET    DTT   1301       8                                                       
HET    DTT   1302       8                                                       
HET    DTT   1303       8                                                       
HET    MES   1401      12                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     DTT 2,3-DIHYDROXY-1,4-DITHIOBUTANE                                   
HETNAM     MES 2-(N-MORPHOLINO)-ETHANESULFONIC ACID                             
HETSYN     DTT 1,4-DITHIOTHREITOL                                               
FORMUL   1  MSE    21(C5 H11 N O2 SE)                                           
FORMUL   4  DTT    3(C4 H10 O2 S2)                                              
FORMUL   7  MES    C6 H13 N O4 S                                                
FORMUL   8  HOH   *352(H2 O)                                                    
CRYST1  114.397   55.363   67.584  90.00  94.07  90.00 C 1 2 1      12          
ATOM      1  N   GLY A  73       3.679  48.595   3.598  1.00 62.81           N  
ATOM      2  CA  GLY A  73       2.917  49.042   2.392  1.00 62.68           C  
ATOM      3  C   GLY A  73       3.409  48.360   1.130  1.00 62.27           C  
ATOM      4  O   GLY A  73       4.602  48.391   0.839  1.00 63.26           O  
ATOM      5  N   ARG A  74       2.495  47.742   0.386  1.00 61.86           N  
ATOM      6  CA  ARG A  74       2.848  46.912  -0.783  1.00 60.94           C  
ATOM      7  C   ARG A  74       1.706  46.657  -1.795  1.00 58.92           C  
ATOM      8  O   ARG A  74       0.532  46.570  -1.423  1.00 58.73           O  
ATOM      9  CB  ARG A  74       3.308  45.572  -0.241  1.00 61.90           C  
ATOM     10  CG  ARG A  74       4.495  44.928  -0.881  1.00 62.95           C  
ATOM     11  CD  ARG A  74       5.007  43.829   0.018  1.00 63.98           C  
ATOM     12  NE  ARG A  74       5.735  42.770  -0.652  1.00 65.39           N  
ATOM     13  CZ  ARG A  74       5.536  41.454  -0.486  1.00 67.70           C  
ATOM     14  NH1 ARG A  74       4.584  40.973   0.313  1.00 66.67           N  
ATOM     15  NH2 ARG A  74       6.310  40.591  -1.147  1.00 68.78           N  
ATOM     16  N   VAL A  75       2.077  46.514  -3.072  1.00 56.77           N  
ATOM     17  CA  VAL A  75       1.192  45.992  -4.130  1.00 54.28           C  
ATOM     18  C   VAL A  75       1.698  44.617  -4.593  1.00 50.44           C  
ATOM     19  O   VAL A  75       2.828  44.511  -5.070  1.00 49.97           O  
ATOM     20  CB  VAL A  75       1.204  46.909  -5.364  1.00 55.63           C  
ATOM     21  CG1 VAL A  75      -0.032  46.655  -6.241  1.00 57.46           C  
ATOM     22  CG2 VAL A  75       1.301  48.368  -4.964  1.00 57.09           C  
ATOM     23  N   THR A  76       0.882  43.572  -4.462  1.00 45.88           N  
ATOM     24  CA  THR A  76       1.249  42.219  -4.960  1.00 42.19           C  
ATOM     25  C   THR A  76       0.208  41.716  -5.979  1.00 39.44           C  
ATOM     26  O   THR A  76      -0.861  42.286  -6.135  1.00 38.62           O  
ATOM     27  CB  THR A  76       1.369  41.196  -3.800  1.00 42.75           C  
ATOM     28  OG1 THR A  76       0.074  40.957  -3.219  1.00 38.21           O  
ATOM     29  CG2 THR A  76       2.236  41.723  -2.648  1.00 42.28           C  
ATOM     30  N   ASN A  77       0.508  40.633  -6.655  1.00 36.60           N  
ATOM     31  CA  ASN A  77      -0.455  40.029  -7.505  1.00 35.28           C  
ATOM     32  C   ASN A  77      -1.720  39.539  -6.727  1.00 33.02           C  
ATOM     33  O   ASN A  77      -2.792  39.568  -7.269  1.00 32.92           O  
ATOM     34  CB  ASN A  77       0.171  38.869  -8.285  1.00 36.19           C  
ATOM     35  CG  ASN A  77       0.745  37.759  -7.401  1.00 37.37           C  
ATOM     36  OD1 ASN A  77       0.850  36.615  -7.875  1.00 46.61           O  
ATOM     37  ND2 ASN A  77       1.133  38.060  -6.142  1.00 41.98           N  
ATOM     38  N   GLN A  78      -1.559  39.061  -5.507  1.00 31.17           N  
ATOM     39  CA  GLN A  78      -2.690  38.536  -4.755  1.00 31.07           C  
ATOM     40  C   GLN A  78      -3.541  39.678  -4.210  1.00 31.11           C  
ATOM     41  O   GLN A  78      -4.757  39.605  -4.193  1.00 31.11           O  
ATOM     42  CB  GLN A  78      -2.207  37.648  -3.629  1.00 32.66           C  
ATOM     43  CG  GLN A  78      -1.517  36.416  -4.122  1.00 36.94           C  
ATOM     44  CD  GLN A  78      -1.046  35.510  -3.007  1.00 39.96           C  
ATOM     45  OE1 GLN A  78      -0.980  34.299  -3.189  1.00 44.69           O  
ATOM     46  NE2 GLN A  78      -0.741  36.077  -1.856  1.00 36.90           N  
ATOM     47  N   LEU A  79      -2.909  40.742  -3.780  1.00 29.88           N  
ATOM     48  CA  LEU A  79      -3.648  41.911  -3.325  1.00 30.40           C  
ATOM     49  C   LEU A  79      -4.487  42.594  -4.439  1.00 30.40           C  
ATOM     50  O   LEU A  79      -5.646  42.979  -4.225  1.00 28.89           O  
ATOM     51  CB  LEU A  79      -2.722  42.907  -2.638  1.00 30.94           C  
ATOM     52  CG  LEU A  79      -2.271  42.498  -1.214  1.00 29.66           C  
ATOM     53  CD1 LEU A  79      -1.148  43.341  -0.740  1.00 28.43           C  
ATOM     54  CD2 LEU A  79      -3.400  42.639  -0.263  1.00 30.73           C  
ATOM     55  N   GLN A  80      -3.884  42.731  -5.622  1.00 32.19           N  
ATOM     56  CA  GLN A  80      -4.600  43.018  -6.834  1.00 32.64           C  
ATOM     57  C   GLN A  80      -5.757  42.090  -7.172  1.00 31.50           C  
ATOM     58  O   GLN A  80      -6.807  42.578  -7.534  1.00 31.39           O  
ATOM     59  CB  GLN A  80      -3.636  43.002  -8.036  1.00 36.37           C  
ATOM     60  CG  GLN A  80      -4.188  43.707  -9.276  1.00 41.60           C  
ATOM     61  CD  GLN A  80      -3.147  43.842 -10.406  1.00 50.90           C  
ATOM     62  OE1 GLN A  80      -2.784  42.845 -11.069  1.00 56.84           O  
ATOM     63  NE2 GLN A  80      -2.643  45.058 -10.595  1.00 55.59           N  
ATOM     64  N   TYR A  81      -5.580  40.773  -7.058  1.00 30.35           N  
ATOM     65  CA  TYR A  81      -6.695  39.857  -7.175  1.00 29.84           C  
ATOM     66  C   TYR A  81      -7.833  40.067  -6.122  1.00 28.48           C  
ATOM     67  O   TYR A  81      -9.025  40.084  -6.452  1.00 30.01           O  
ATOM     68  CB  TYR A  81      -6.173  38.451  -7.080  1.00 29.90           C  
ATOM     69  CG  TYR A  81      -7.193  37.355  -7.154  1.00 29.37           C  
ATOM     70  CD1 TYR A  81      -7.622  36.858  -8.374  1.00 32.71           C  
ATOM     71  CD2 TYR A  81      -7.710  36.743  -5.965  1.00 28.27           C  
ATOM     72  CE1 TYR A  81      -8.571  35.856  -8.452  1.00 31.91           C  
ATOM     73  CE2 TYR A  81      -8.643  35.745  -6.050  1.00 28.97           C  
ATOM     74  CZ  TYR A  81      -9.087  35.303  -7.287  1.00 31.00           C  
ATOM     75  OH  TYR A  81      -9.986  34.227  -7.324  1.00 31.24           O  
ATOM     76  N   LEU A  82      -7.451  40.215  -4.889  1.00 26.81           N  
ATOM     77  CA  LEU A  82      -8.415  40.536  -3.795  1.00 28.08           C  
ATOM     78  C   LEU A  82      -9.193  41.826  -4.061  1.00 27.38           C  
ATOM     79  O   LEU A  82     -10.395  41.941  -3.782  1.00 28.10           O  
ATOM     80  CB  LEU A  82      -7.644  40.609  -2.495  1.00 25.89           C  
ATOM     81  CG  LEU A  82      -7.199  39.284  -1.917  1.00 30.81           C  
ATOM     82  CD1 LEU A  82      -6.517  39.509  -0.635  1.00 31.81           C  
ATOM     83  CD2 LEU A  82      -8.384  38.365  -1.769  1.00 35.74           C  
ATOM     84  N   HIS A  83      -8.537  42.803  -4.653  1.00 27.32           N  
ATOM     85  CA  HIS A  83      -9.164  44.051  -4.956  1.00 29.52           C  
ATOM     86  C   HIS A  83     -10.027  43.985  -6.225  1.00 30.63           C  
ATOM     87  O   HIS A  83     -11.190  44.338  -6.222  1.00 29.82           O  
ATOM     88  CB  HIS A  83      -8.033  45.120  -5.129  1.00 30.23           C  
ATOM     89  CG  HIS A  83      -8.500  46.508  -5.256  1.00 32.73           C  
ATOM     90  ND1 HIS A  83      -9.805  46.894  -5.092  1.00 38.38           N  
ATOM     91  CD2 HIS A  83      -7.806  47.659  -5.481  1.00 43.22           C  
ATOM     92  CE1 HIS A  83      -9.913  48.202  -5.235  1.00 36.92           C  
ATOM     93  NE2 HIS A  83      -8.719  48.690  -5.489  1.00 41.09           N  
ATOM     94  N   LYS A  84      -9.447  43.518  -7.319  1.00 32.12           N  
ATOM     95  CA  LYS A  84     -10.102  43.637  -8.621  1.00 33.99           C  
ATOM     96  C   LYS A  84     -11.043  42.510  -8.952  1.00 34.25           C  
ATOM     97  O   LYS A  84     -11.936  42.695  -9.751  1.00 33.47           O  
ATOM     98  CB  LYS A  84      -9.072  43.747  -9.691  1.00 35.08           C  
ATOM     99  CG  LYS A  84      -8.644  45.201  -9.923  1.00 43.01           C  
ATOM    100  CD  LYS A  84      -8.351  46.031  -8.735  1.00 49.61           C  
ATOM    101  CE  LYS A  84      -7.593  47.309  -9.123  1.00 55.22           C  
ATOM    102  NZ  LYS A  84      -8.408  48.124 -10.081  1.00 57.72           N  
ATOM    103  N   VAL A  85     -10.885  41.364  -8.316  1.00 33.80           N  
ATOM    104  CA  VAL A  85     -11.723  40.190  -8.599  1.00 35.26           C  
ATOM    105  C   VAL A  85     -12.648  39.866  -7.410  1.00 34.33           C  
ATOM    106  O   VAL A  85     -13.883  39.712  -7.612  1.00 37.06           O  
ATOM    107  CB  VAL A  85     -10.875  38.927  -8.994  1.00 34.17           C  
ATOM    108  CG1 VAL A  85     -11.709  37.655  -8.978  1.00 38.09           C  
ATOM    109  CG2 VAL A  85     -10.146  39.117 -10.379  1.00 37.92           C  
ATOM    110  N   VAL A  86     -12.098  39.777  -6.207  1.00 32.09           N  
ATOM    111  CA  VAL A  86     -12.864  39.297  -5.045  1.00 31.00           C  
ATOM    112  C   VAL A  86     -13.757  40.418  -4.544  1.00 30.18           C  
ATOM    113  O   VAL A  86     -14.951  40.308  -4.523  1.00 28.27           O  
ATOM    114  CB  VAL A  86     -11.955  38.702  -3.937  1.00 31.79           C  
ATOM    115  CG1 VAL A  86     -12.786  38.147  -2.710  1.00 32.09           C  
ATOM    116  CG2 VAL A  86     -11.084  37.618  -4.507  1.00 32.34           C  
HETATM  117  N   MSE A  87     -13.190  41.539  -4.194  1.00 28.91           N  
HETATM  118  CA  MSE A  87     -13.962  42.612  -3.628  1.00 29.05           C  
HETATM  119  C   MSE A  87     -14.912  43.177  -4.655  1.00 28.92           C  
HETATM  120  O   MSE A  87     -16.006  43.613  -4.310  1.00 28.88           O  
HETATM  121  CB  MSE A  87     -13.038  43.693  -3.130  1.00 28.60           C  
HETATM  122  CG  MSE A  87     -13.686  44.852  -2.539  1.00 35.85           C  
HETATM  123 SE   MSE A  87     -14.892  44.390  -0.948  1.00 50.68          SE  
HETATM  124  CE  MSE A  87     -13.350  44.615   0.525  1.00 43.77           C  
ATOM    125  N   LYS A  88     -14.502  43.236  -5.928  1.00 29.51           N  
ATOM    126  CA  LYS A  88     -15.422  43.797  -6.899  1.00 31.27           C  
ATOM    127  C   LYS A  88     -16.720  42.954  -6.981  1.00 30.48           C  
ATOM    128  O   LYS A  88     -17.862  43.515  -7.101  1.00 30.80           O  
ATOM    129  CB  LYS A  88     -14.731  43.918  -8.260  1.00 34.11           C  
ATOM    130  CG  LYS A  88     -15.578  44.718  -9.266  1.00 39.90           C  
ATOM    131  CD  LYS A  88     -14.730  44.974 -10.524  1.00 49.96           C  
ATOM    132  CE  LYS A  88     -15.470  45.702 -11.647  1.00 54.76           C  
ATOM    133  NZ  LYS A  88     -14.397  46.095 -12.639  1.00 59.29           N  
ATOM    134  N   ALA A  89     -16.556  41.634  -6.911  1.00 30.81           N  
ATOM    135  CA  ALA A  89     -17.649  40.696  -6.931  1.00 31.08           C  
ATOM    136  C   ALA A  89     -18.517  40.796  -5.653  1.00 30.70           C  
ATOM    137  O   ALA A  89     -19.742  40.870  -5.722  1.00 28.25           O  
ATOM    138  CB  ALA A  89     -17.167  39.326  -7.109  1.00 31.60           C  
ATOM    139  N   LEU A  90     -17.878  40.793  -4.494  1.00 28.00           N  
ATOM    140  CA  LEU A  90     -18.628  40.943  -3.252  1.00 28.03           C  
ATOM    141  C   LEU A  90     -19.361  42.249  -3.145  1.00 26.27           C  
ATOM    142  O   LEU A  90     -20.507  42.285  -2.763  1.00 26.87           O  
ATOM    143  CB  LEU A  90     -17.714  40.770  -2.047  1.00 26.97           C  
ATOM    144  CG  LEU A  90     -17.050  39.416  -1.949  1.00 32.41           C  
ATOM    145  CD1 LEU A  90     -16.165  39.395  -0.773  1.00 35.60           C  
ATOM    146  CD2 LEU A  90     -18.040  38.301  -1.764  1.00 36.82           C  
ATOM    147  N   TRP A  91     -18.715  43.351  -3.535  1.00 24.74           N  
ATOM    148  CA  TRP A  91     -19.272  44.670  -3.385  1.00 24.69           C  
ATOM    149  C   TRP A  91     -20.632  44.806  -4.112  1.00 22.41           C  
ATOM    150  O   TRP A  91     -21.547  45.390  -3.568  1.00 26.63           O  
ATOM    151  CB  TRP A  91     -18.264  45.735  -3.954  1.00 22.58           C  
ATOM    152  CG  TRP A  91     -18.642  47.099  -3.652  1.00 25.87           C  
ATOM    153  CD1 TRP A  91     -19.445  47.879  -4.369  1.00 26.27           C  
ATOM    154  CD2 TRP A  91     -18.159  47.906  -2.570  1.00 25.00           C  
ATOM    155  NE1 TRP A  91     -19.564  49.100  -3.787  1.00 27.96           N  
ATOM    156  CE2 TRP A  91     -18.750  49.148  -2.685  1.00 23.79           C  
ATOM    157  CE3 TRP A  91     -17.254  47.694  -1.531  1.00 25.09           C  
ATOM    158  CZ2 TRP A  91     -18.505  50.165  -1.800  1.00 30.83           C  
ATOM    159  CZ3 TRP A  91     -17.007  48.721  -0.625  1.00 27.50           C  
ATOM    160  CH2 TRP A  91     -17.617  49.924  -0.748  1.00 29.21           C  
ATOM    161  N   LYS A  92     -20.703  44.306  -5.346  1.00 24.47           N  
ATOM    162  CA  LYS A  92     -21.883  44.411  -6.202  1.00 28.27           C  
ATOM    163  C   LYS A  92     -22.977  43.373  -5.853  1.00 26.37           C  
ATOM    164  O   LYS A  92     -24.088  43.419  -6.373  1.00 24.95           O  
ATOM    165  CB  LYS A  92     -21.482  44.151  -7.684  1.00 30.02           C  
ATOM    166  CG  LYS A  92     -20.410  45.130  -8.219  1.00 43.15           C  
ATOM    167  CD  LYS A  92     -19.934  44.766  -9.698  1.00 50.12           C  
ATOM    168  CE  LYS A  92     -19.222  45.979 -10.454  1.00 55.86           C  
ATOM    169  NZ  LYS A  92     -19.422  47.299  -9.696  1.00 63.06           N  
ATOM    170  N   HIS A  93     -22.674  42.446  -4.968  1.00 23.54           N  
ATOM    171  CA  HIS A  93     -23.612  41.396  -4.596  1.00 22.54           C  
ATOM    172  C   HIS A  93     -24.877  41.957  -3.988  1.00 22.38           C  
ATOM    173  O   HIS A  93     -24.840  42.882  -3.273  1.00 21.58           O  
ATOM    174  CB  HIS A  93     -22.881  40.348  -3.682  1.00 22.91           C  
ATOM    175  CG  HIS A  93     -23.649  39.067  -3.524  1.00 24.05           C  
ATOM    176  ND1 HIS A  93     -24.832  38.999  -2.819  1.00 23.37           N  
ATOM    177  CD2 HIS A  93     -23.429  37.836  -4.020  1.00 21.31           C  
ATOM    178  CE1 HIS A  93     -25.307  37.776  -2.923  1.00 23.12           C  
ATOM    179  NE2 HIS A  93     -24.462  37.041  -3.603  1.00 22.71           N  
ATOM    180  N   GLN A  94     -26.041  41.331  -4.250  1.00 21.99           N  
ATOM    181  CA  GLN A  94     -27.287  41.897  -3.776  1.00 22.07           C  
ATOM    182  C   GLN A  94     -27.426  41.832  -2.287  1.00 23.40           C  
ATOM    183  O   GLN A  94     -28.283  42.529  -1.740  1.00 24.47           O  
ATOM    184  CB  GLN A  94     -28.472  41.144  -4.379  1.00 23.75           C  
ATOM    185  CG  GLN A  94     -28.482  39.627  -4.063  1.00 24.48           C  
ATOM    186  CD  GLN A  94     -29.671  38.870  -4.655  1.00 31.27           C  
ATOM    187  OE1 GLN A  94     -29.511  37.742  -5.192  1.00 35.11           O  
ATOM    188  NE2 GLN A  94     -30.832  39.456  -4.558  1.00 30.25           N  
ATOM    189  N   PHE A  95     -26.618  41.019  -1.620  1.00 22.24           N  
ATOM    190  CA  PHE A  95     -26.623  40.996  -0.193  1.00 23.01           C  
ATOM    191  C   PHE A  95     -25.521  41.836   0.450  1.00 23.66           C  
ATOM    192  O   PHE A  95     -25.398  41.836   1.671  1.00 25.68           O  
ATOM    193  CB  PHE A  95     -26.492  39.583   0.357  1.00 22.24           C  
ATOM    194  CG  PHE A  95     -27.583  38.672   0.008  1.00 26.29           C  
ATOM    195  CD1 PHE A  95     -28.864  39.111  -0.271  1.00 25.67           C  
ATOM    196  CD2 PHE A  95     -27.339  37.313   0.032  1.00 26.56           C  
ATOM    197  CE1 PHE A  95     -29.847  38.172  -0.591  1.00 25.56           C  
ATOM    198  CE2 PHE A  95     -28.343  36.396  -0.249  1.00 31.82           C  
ATOM    199  CZ  PHE A  95     -29.600  36.873  -0.588  1.00 27.05           C  
ATOM    200  N   ALA A  96     -24.814  42.652  -0.323  1.00 23.07           N  
ATOM    201  CA  ALA A  96     -23.675  43.417   0.195  1.00 23.86           C  
ATOM    202  C   ALA A  96     -23.970  44.689   0.861  1.00 22.28           C  
ATOM    203  O   ALA A  96     -23.138  45.151   1.596  1.00 23.51           O  
ATOM    204  CB  ALA A  96     -22.612  43.670  -0.928  1.00 26.39           C  
ATOM    205  N   TRP A  97     -25.136  45.290   0.622  1.00 24.10           N  
ATOM    206  CA  TRP A  97     -25.375  46.647   1.055  1.00 25.25           C  
ATOM    207  C   TRP A  97     -25.176  46.925   2.576  1.00 25.43           C  
ATOM    208  O   TRP A  97     -24.736  47.997   2.911  1.00 24.53           O  
ATOM    209  CB  TRP A  97     -26.709  47.191   0.593  1.00 24.95           C  
ATOM    210  CG  TRP A  97     -27.883  46.438   1.080  1.00 25.45           C  
ATOM    211  CD1 TRP A  97     -28.468  45.332   0.504  1.00 24.77           C  
ATOM    212  CD2 TRP A  97     -28.634  46.720   2.278  1.00 23.51           C  
ATOM    213  NE1 TRP A  97     -29.498  44.898   1.315  1.00 27.15           N  
ATOM    214  CE2 TRP A  97     -29.627  45.725   2.393  1.00 25.55           C  
ATOM    215  CE3 TRP A  97     -28.511  47.661   3.318  1.00 27.71           C  
ATOM    216  CZ2 TRP A  97     -30.515  45.677   3.475  1.00 30.55           C  
ATOM    217  CZ3 TRP A  97     -29.419  47.625   4.362  1.00 30.34           C  
ATOM    218  CH2 TRP A  97     -30.422  46.653   4.409  1.00 29.84           C  
ATOM    219  N   PRO A  98     -25.474  45.976   3.472  1.00 24.77           N  
ATOM    220  CA  PRO A  98     -25.226  46.235   4.890  1.00 24.91           C  
ATOM    221  C   PRO A  98     -23.747  46.366   5.241  1.00 23.63           C  
ATOM    222  O   PRO A  98     -23.441  46.821   6.341  1.00 25.04           O  
ATOM    223  CB  PRO A  98     -25.814  44.990   5.602  1.00 25.81           C  
ATOM    224  CG  PRO A  98     -26.738  44.330   4.567  1.00 24.96           C  
ATOM    225  CD  PRO A  98     -26.070  44.655   3.279  1.00 24.81           C  
ATOM    226  N   PHE A  99     -22.887  45.848   4.381  1.00 23.84           N  
ATOM    227  CA  PHE A  99     -21.467  45.717   4.669  1.00 23.23           C  
ATOM    228  C   PHE A  99     -20.549  46.718   3.956  1.00 24.02           C  
ATOM    229  O   PHE A  99     -19.384  46.657   4.155  1.00 24.21           O  
ATOM    230  CB  PHE A  99     -21.044  44.366   4.284  1.00 22.44           C  
ATOM    231  CG  PHE A  99     -21.863  43.262   4.949  1.00 24.51           C  
ATOM    232  CD1 PHE A  99     -22.880  42.581   4.252  1.00 19.28           C  
ATOM    233  CD2 PHE A  99     -21.651  42.942   6.274  1.00 29.04           C  
ATOM    234  CE1 PHE A  99     -23.619  41.558   4.867  1.00 23.04           C  
ATOM    235  CE2 PHE A  99     -22.429  41.964   6.902  1.00 31.50           C  
ATOM    236  CZ  PHE A  99     -23.390  41.266   6.181  1.00 25.22           C  
ATOM    237  N   ARG A 100     -21.081  47.575   3.105  1.00 23.23           N  
ATOM    238  CA  ARG A 100     -20.236  48.494   2.313  1.00 24.39           C  
ATOM    239  C   ARG A 100     -19.680  49.706   3.106  1.00 26.09           C  
ATOM    240  O   ARG A 100     -18.837  50.435   2.597  1.00 28.24           O  
ATOM    241  CB  ARG A 100     -21.063  49.075   1.182  1.00 25.64           C  
ATOM    242  CG  ARG A 100     -21.421  48.024   0.124  1.00 25.38           C  
ATOM    243  CD  ARG A 100     -22.197  48.663  -1.054  1.00 26.81           C  
ATOM    244  NE  ARG A 100     -22.674  47.668  -1.956  1.00 26.09           N  
ATOM    245  CZ  ARG A 100     -23.923  47.524  -2.427  1.00 22.24           C  
ATOM    246  NH1 ARG A 100     -24.843  48.368  -2.139  1.00 23.38           N  
ATOM    247  NH2 ARG A 100     -24.195  46.516  -3.211  1.00 27.59           N  
ATOM    248  N   GLN A 101     -20.224  50.004   4.253  1.00 26.35           N  
ATOM    249  CA  GLN A 101     -19.772  51.113   5.080  1.00 27.93           C  
ATOM    250  C   GLN A 101     -19.768  50.624   6.533  1.00 28.55           C  
ATOM    251  O   GLN A 101     -20.462  49.662   6.871  1.00 24.89           O  
ATOM    252  CB  GLN A 101     -20.775  52.285   4.963  1.00 29.90           C  
ATOM    253  CG  GLN A 101     -22.202  51.942   5.262  1.00 33.87           C  
ATOM    254  CD  GLN A 101     -22.865  50.923   4.279  1.00 36.41           C  
ATOM    255  OE1 GLN A 101     -23.385  49.817   4.726  1.00 31.28           O  
ATOM    256  NE2 GLN A 101     -22.916  51.299   2.992  1.00 32.82           N  
ATOM    257  N   PRO A 102     -19.112  51.339   7.445  1.00 30.77           N  
ATOM    258  CA  PRO A 102     -19.228  50.966   8.852  1.00 30.34           C  
ATOM    259  C   PRO A 102     -20.656  50.839   9.324  1.00 31.32           C  
ATOM    260  O   PRO A 102     -21.552  51.513   8.873  1.00 32.36           O  
ATOM    261  CB  PRO A 102     -18.468  52.117   9.593  1.00 32.07           C  
ATOM    262  CG  PRO A 102     -17.538  52.593   8.612  1.00 31.41           C  
ATOM    263  CD  PRO A 102     -18.187  52.462   7.241  1.00 30.89           C  
ATOM    264  N   VAL A 103     -20.865  49.930  10.264  1.00 32.06           N  
ATOM    265  CA  VAL A 103     -22.087  49.766  10.986  1.00 33.02           C  
ATOM    266  C   VAL A 103     -22.302  51.066  11.744  1.00 35.67           C  
ATOM    267  O   VAL A 103     -21.399  51.507  12.401  1.00 34.36           O  
ATOM    268  CB  VAL A 103     -21.963  48.596  11.998  1.00 33.45           C  
ATOM    269  CG1 VAL A 103     -23.153  48.567  12.965  1.00 33.02           C  
ATOM    270  CG2 VAL A 103     -21.879  47.281  11.226  1.00 32.01           C  
ATOM    271  N   ASP A 104     -23.474  51.687  11.586  1.00 38.85           N  
ATOM    272  CA  ASP A 104     -23.785  52.991  12.237  1.00 41.64           C  
ATOM    273  C   ASP A 104     -24.792  52.675  13.328  1.00 41.86           C  
ATOM    274  O   ASP A 104     -25.984  52.527  13.069  1.00 39.79           O  
ATOM    275  CB  ASP A 104     -24.382  53.941  11.213  1.00 43.90           C  
ATOM    276  CG  ASP A 104     -24.609  55.354  11.755  1.00 49.18           C  
ATOM    277  OD1 ASP A 104     -24.951  55.552  12.949  1.00 52.49           O  
ATOM    278  OD2 ASP A 104     -24.471  56.343  10.999  1.00 58.22           O  
ATOM    279  N   ALA A 105     -24.267  52.481  14.537  1.00 42.25           N  
ATOM    280  CA  ALA A 105     -25.023  51.936  15.639  1.00 43.67           C  
ATOM    281  C   ALA A 105     -26.122  52.910  16.108  1.00 45.69           C  
ATOM    282  O   ALA A 105     -27.168  52.474  16.564  1.00 44.99           O  
ATOM    283  CB  ALA A 105     -24.081  51.655  16.774  1.00 44.08           C  
ATOM    284  N   VAL A 106     -25.872  54.211  15.998  1.00 48.32           N  
ATOM    285  CA  VAL A 106     -26.921  55.251  16.269  1.00 50.96           C  
ATOM    286  C   VAL A 106     -28.123  55.115  15.304  1.00 52.17           C  
ATOM    287  O   VAL A 106     -29.229  54.807  15.724  1.00 52.57           O  
ATOM    288  CB  VAL A 106     -26.324  56.698  16.183  1.00 50.90           C  
ATOM    289  CG1 VAL A 106     -27.418  57.790  16.413  1.00 51.88           C  
ATOM    290  CG2 VAL A 106     -25.190  56.872  17.208  1.00 51.37           C  
ATOM    291  N   LYS A 107     -27.892  55.324  14.011  1.00 54.30           N  
ATOM    292  CA  LYS A 107     -28.917  55.092  13.003  1.00 55.99           C  
ATOM    293  C   LYS A 107     -29.724  53.818  13.258  1.00 56.74           C  
ATOM    294  O   LYS A 107     -30.966  53.858  13.358  1.00 58.39           O  
ATOM    295  CB  LYS A 107     -28.270  54.945  11.638  1.00 56.64           C  
ATOM    296  CG  LYS A 107     -28.184  56.200  10.788  1.00 59.39           C  
ATOM    297  CD  LYS A 107     -29.161  56.161   9.578  1.00 62.04           C  
ATOM    298  CE  LYS A 107     -28.873  55.053   8.551  1.00 63.26           C  
ATOM    299  NZ  LYS A 107     -30.065  54.715   7.711  1.00 64.60           N  
ATOM    300  N   LEU A 108     -29.030  52.682  13.379  1.00 56.32           N  
ATOM    301  CA  LEU A 108     -29.693  51.377  13.343  1.00 55.80           C  
ATOM    302  C   LEU A 108     -30.341  51.066  14.654  1.00 55.02           C  
ATOM    303  O   LEU A 108     -31.108  50.121  14.760  1.00 55.95           O  
ATOM    304  CB  LEU A 108     -28.713  50.269  13.003  1.00 56.58           C  
ATOM    305  CG  LEU A 108     -28.352  50.075  11.527  1.00 59.31           C  
ATOM    306  CD1 LEU A 108     -29.618  49.707  10.694  1.00 61.55           C  
ATOM    307  CD2 LEU A 108     -27.683  51.304  10.953  1.00 62.47           C  
ATOM    308  N   GLY A 109     -30.033  51.863  15.659  1.00 54.58           N  
ATOM    309  CA  GLY A 109     -30.585  51.677  16.982  1.00 54.56           C  
ATOM    310  C   GLY A 109     -29.998  50.504  17.741  1.00 54.39           C  
ATOM    311  O   GLY A 109     -30.747  49.656  18.243  1.00 55.34           O  
ATOM    312  N   LEU A 110     -28.665  50.486  17.877  1.00 53.45           N  
ATOM    313  CA  LEU A 110     -27.919  49.326  18.381  1.00 52.68           C  
ATOM    314  C   LEU A 110     -26.937  49.858  19.406  1.00 51.55           C  
ATOM    315  O   LEU A 110     -25.774  50.027  19.118  1.00 50.53           O  
ATOM    316  CB  LEU A 110     -27.144  48.658  17.216  1.00 52.82           C  
ATOM    317  CG  LEU A 110     -27.748  47.575  16.303  1.00 53.07           C  
ATOM    318  CD1 LEU A 110     -29.194  47.687  16.189  1.00 55.04           C  
ATOM    319  CD2 LEU A 110     -27.109  47.557  14.913  1.00 51.88           C  
ATOM    320  N   PRO A 111     -27.427  50.239  20.578  1.00 51.84           N  
ATOM    321  CA  PRO A 111     -26.562  50.912  21.565  1.00 49.99           C  
ATOM    322  C   PRO A 111     -25.547  49.994  22.240  1.00 47.45           C  
ATOM    323  O   PRO A 111     -24.620  50.442  22.886  1.00 48.21           O  
ATOM    324  CB  PRO A 111     -27.568  51.477  22.587  1.00 51.26           C  
ATOM    325  CG  PRO A 111     -28.859  50.606  22.407  1.00 52.30           C  
ATOM    326  CD  PRO A 111     -28.843  50.131  21.019  1.00 51.98           C  
ATOM    327  N   ASP A 112     -25.716  48.692  22.098  1.00 43.46           N  
ATOM    328  CA  ASP A 112     -24.729  47.777  22.608  1.00 40.72           C  
ATOM    329  C   ASP A 112     -23.711  47.293  21.539  1.00 37.37           C  
ATOM    330  O   ASP A 112     -22.869  46.513  21.863  1.00 34.82           O  
ATOM    331  CB  ASP A 112     -25.444  46.586  23.147  1.00 41.50           C  
ATOM    332  CG  ASP A 112     -26.261  45.878  22.085  1.00 41.90           C  
ATOM    333  OD1 ASP A 112     -26.602  46.482  21.015  1.00 42.94           O  
ATOM    334  OD2 ASP A 112     -26.574  44.699  22.244  1.00 46.20           O  
ATOM    335  N   TYR A 113     -23.821  47.755  20.299  1.00 35.09           N  
ATOM    336  CA  TYR A 113     -23.014  47.193  19.198  1.00 33.63           C  
ATOM    337  C   TYR A 113     -21.510  47.321  19.542  1.00 32.21           C  
ATOM    338  O   TYR A 113     -20.779  46.342  19.528  1.00 28.49           O  
ATOM    339  CB  TYR A 113     -23.307  47.872  17.836  1.00 32.60           C  
ATOM    340  CG  TYR A 113     -22.503  47.220  16.746  1.00 30.03           C  
ATOM    341  CD1 TYR A 113     -22.913  46.008  16.225  1.00 30.29           C  
ATOM    342  CD2 TYR A 113     -21.268  47.762  16.284  1.00 26.31           C  
ATOM    343  CE1 TYR A 113     -22.203  45.398  15.259  1.00 29.53           C  
ATOM    344  CE2 TYR A 113     -20.516  47.126  15.263  1.00 25.40           C  
ATOM    345  CZ  TYR A 113     -21.006  45.938  14.759  1.00 25.95           C  
ATOM    346  OH  TYR A 113     -20.308  45.208  13.793  1.00 25.10           O  
ATOM    347  N   HIS A 114     -21.077  48.532  19.879  1.00 31.15           N  
ATOM    348  CA  HIS A 114     -19.691  48.758  20.216  1.00 31.58           C  
ATOM    349  C   HIS A 114     -19.247  48.263  21.589  1.00 31.75           C  
ATOM    350  O   HIS A 114     -18.094  48.257  21.873  1.00 31.32           O  
ATOM    351  CB  HIS A 114     -19.337  50.216  20.063  1.00 35.22           C  
ATOM    352  CG  HIS A 114     -19.453  50.694  18.649  1.00 34.81           C  
ATOM    353  ND1 HIS A 114     -18.440  50.526  17.734  1.00 40.98           N  
ATOM    354  CD2 HIS A 114     -20.473  51.281  17.986  1.00 35.99           C  
ATOM    355  CE1 HIS A 114     -18.825  51.012  16.570  1.00 39.21           C  
ATOM    356  NE2 HIS A 114     -20.042  51.498  16.703  1.00 35.33           N  
ATOM    357  N   LYS A 115     -20.140  47.745  22.389  1.00 31.86           N  
ATOM    358  CA  LYS A 115     -19.753  47.106  23.628  1.00 32.58           C  
ATOM    359  C   LYS A 115     -19.445  45.655  23.378  1.00 32.21           C  
ATOM    360  O   LYS A 115     -18.742  45.081  24.168  1.00 32.41           O  
ATOM    361  CB  LYS A 115     -20.885  47.100  24.621  1.00 33.65           C  
ATOM    362  CG  LYS A 115     -21.637  48.422  24.691  1.00 41.49           C  
ATOM    363  CD  LYS A 115     -21.257  49.199  25.840  1.00 46.26           C  
ATOM    364  CE  LYS A 115     -22.294  50.294  26.181  1.00 48.05           C  
ATOM    365  NZ  LYS A 115     -21.572  51.490  26.606  1.00 48.66           N  
ATOM    366  N   ILE A 116     -20.019  45.088  22.304  1.00 28.38           N  
ATOM    367  CA  ILE A 116     -19.823  43.682  21.958  1.00 28.27           C  
ATOM    368  C   ILE A 116     -18.739  43.481  20.880  1.00 25.72           C  
ATOM    369  O   ILE A 116     -17.948  42.608  20.998  1.00 26.34           O  
ATOM    370  CB  ILE A 116     -21.213  43.065  21.522  1.00 28.19           C  
ATOM    371  CG1 ILE A 116     -22.152  43.061  22.735  1.00 32.44           C  
ATOM    372  CG2 ILE A 116     -20.969  41.653  20.959  1.00 26.98           C  
ATOM    373  CD1 ILE A 116     -23.582  42.913  22.406  1.00 37.03           C  
ATOM    374  N   ILE A 117     -18.711  44.346  19.875  1.00 23.37           N  
ATOM    375  CA  ILE A 117     -17.801  44.253  18.752  1.00 24.56           C  
ATOM    376  C   ILE A 117     -16.714  45.270  19.004  1.00 26.24           C  
ATOM    377  O   ILE A 117     -16.970  46.431  18.931  1.00 28.64           O  
ATOM    378  CB  ILE A 117     -18.541  44.541  17.461  1.00 23.09           C  
ATOM    379  CG1 ILE A 117     -19.592  43.442  17.210  1.00 22.72           C  
ATOM    380  CG2 ILE A 117     -17.646  44.571  16.246  1.00 25.16           C  
ATOM    381  CD1 ILE A 117     -19.095  42.036  17.304  1.00 23.29           C  
ATOM    382  N   LYS A 118     -15.497  44.789  19.208  1.00 27.47           N  
ATOM    383  CA  LYS A 118     -14.371  45.656  19.595  1.00 29.89           C  
ATOM    384  C   LYS A 118     -13.508  46.091  18.436  1.00 28.72           C  
ATOM    385  O   LYS A 118     -12.764  47.058  18.538  1.00 28.67           O  
ATOM    386  CB  LYS A 118     -13.531  44.923  20.668  1.00 31.20           C  
ATOM    387  CG  LYS A 118     -14.327  44.682  22.027  1.00 34.76           C  
ATOM    388  CD  LYS A 118     -15.123  46.007  22.370  1.00 38.46           C  
ATOM    389  CE  LYS A 118     -15.382  46.320  23.808  1.00 40.28           C  
ATOM    390  NZ  LYS A 118     -15.882  47.740  23.890  1.00 39.04           N  
ATOM    391  N   GLN A 119     -13.655  45.389  17.307  1.00 28.26           N  
ATOM    392  CA  GLN A 119     -12.999  45.729  16.068  1.00 27.29           C  
ATOM    393  C   GLN A 119     -14.005  45.784  14.912  1.00 25.86           C  
ATOM    394  O   GLN A 119     -14.076  44.838  14.094  1.00 23.58           O  
ATOM    395  CB  GLN A 119     -11.929  44.691  15.800  1.00 27.95           C  
ATOM    396  CG  GLN A 119     -10.961  45.180  14.762  1.00 34.08           C  
ATOM    397  CD  GLN A 119      -9.991  44.016  14.247  1.00 37.42           C  
ATOM    398  OE1 GLN A 119      -9.324  44.192  13.240  1.00 38.55           O  
ATOM    399  NE2 GLN A 119      -9.919  42.905  14.989  1.00 40.12           N  
ATOM    400  N   PRO A 120     -14.694  46.899  14.784  1.00 25.76           N  
ATOM    401  CA  PRO A 120     -15.614  47.060  13.651  1.00 25.36           C  
ATOM    402  C   PRO A 120     -14.819  46.896  12.346  1.00 25.49           C  
ATOM    403  O   PRO A 120     -13.665  47.306  12.231  1.00 22.12           O  
ATOM    404  CB  PRO A 120     -16.170  48.481  13.828  1.00 26.45           C  
ATOM    405  CG  PRO A 120     -15.897  48.833  15.288  1.00 26.93           C  
ATOM    406  CD  PRO A 120     -14.624  48.120  15.634  1.00 27.20           C  
HETATM  407  N   MSE A 121     -15.442  46.318  11.310  1.00 24.14           N  
HETATM  408  CA  MSE A 121     -14.805  46.197  10.032  1.00 23.71           C  
HETATM  409  C   MSE A 121     -15.898  46.167   8.932  1.00 24.14           C  
HETATM  410  O   MSE A 121     -16.938  45.602   9.159  1.00 23.50           O  
HETATM  411  CB  MSE A 121     -14.014  44.930   9.927  1.00 24.43           C  
HETATM  412  CG  MSE A 121     -13.082  44.784   8.769  1.00 27.03           C  
HETATM  413 SE   MSE A 121     -11.916  46.378   8.239  1.00 46.97          SE  
HETATM  414  CE  MSE A 121     -10.773  46.522   9.975  1.00 38.40           C  
ATOM    415  N   ASP A 122     -15.613  46.813   7.801  1.00 22.09           N  
ATOM    416  CA  ASP A 122     -16.527  46.871   6.710  1.00 22.31           C  
ATOM    417  C   ASP A 122     -15.806  46.863   5.359  1.00 23.87           C  
ATOM    418  O   ASP A 122     -14.581  47.113   5.246  1.00 23.24           O  
ATOM    419  CB  ASP A 122     -17.385  48.069   6.865  1.00 23.51           C  
ATOM    420  CG  ASP A 122     -16.625  49.344   6.608  1.00 28.15           C  
ATOM    421  OD1 ASP A 122     -15.832  49.769   7.542  1.00 32.24           O  
ATOM    422  OD2 ASP A 122     -16.672  49.933   5.486  1.00 28.40           O  
HETATM  423  N   MSE A 123     -16.537  46.571   4.283  1.00 23.53           N  
HETATM  424  CA  MSE A 123     -15.892  46.498   2.971  1.00 24.57           C  
HETATM  425  C   MSE A 123     -15.331  47.818   2.484  1.00 23.35           C  
HETATM  426  O   MSE A 123     -14.364  47.786   1.753  1.00 23.32           O  
HETATM  427  CB  MSE A 123     -16.832  45.985   1.865  1.00 25.30           C  
HETATM  428  CG  MSE A 123     -17.359  44.633   2.134  1.00 28.54           C  
HETATM  429 SE   MSE A 123     -18.690  44.176   0.592  1.00 51.88          SE  
HETATM  430  CE  MSE A 123     -19.062  42.263   1.230  1.00 39.26           C  
ATOM    431  N   GLY A 124     -15.941  48.906   2.906  1.00 24.01           N  
ATOM    432  CA  GLY A 124     -15.476  50.246   2.548  1.00 27.64           C  
ATOM    433  C   GLY A 124     -14.020  50.452   3.005  1.00 26.77           C  
ATOM    434  O   GLY A 124     -13.121  50.939   2.277  1.00 27.47           O  
ATOM    435  N   THR A 125     -13.807  50.079   4.263  1.00 25.24           N  
ATOM    436  CA  THR A 125     -12.528  50.208   4.895  1.00 25.76           C  
ATOM    437  C   THR A 125     -11.493  49.324   4.206  1.00 25.61           C  
ATOM    438  O   THR A 125     -10.381  49.769   3.956  1.00 24.90           O  
ATOM    439  CB  THR A 125     -12.678  49.896   6.366  1.00 25.24           C  
ATOM    440  OG1 THR A 125     -13.541  50.901   7.000  1.00 26.82           O  
ATOM    441  CG2 THR A 125     -11.344  49.895   7.124  1.00 28.17           C  
ATOM    442  N   ILE A 126     -11.870  48.075   3.919  1.00 23.39           N  
ATOM    443  CA  ILE A 126     -11.019  47.133   3.271  1.00 23.93           C  
ATOM    444  C   ILE A 126     -10.655  47.618   1.860  1.00 24.94           C  
ATOM    445  O   ILE A 126      -9.478  47.591   1.437  1.00 23.86           O  
ATOM    446  CB  ILE A 126     -11.680  45.738   3.212  1.00 23.80           C  
ATOM    447  CG1 ILE A 126     -11.801  45.159   4.640  1.00 23.86           C  
ATOM    448  CG2 ILE A 126     -10.865  44.838   2.394  1.00 23.59           C  
ATOM    449  CD1 ILE A 126     -12.507  43.843   4.681  1.00 27.78           C  
ATOM    450  N   LYS A 127     -11.634  48.028   1.141  1.00 24.61           N  
ATOM    451  CA  LYS A 127     -11.371  48.611  -0.228  1.00 27.13           C  
ATOM    452  C   LYS A 127     -10.414  49.811  -0.215  1.00 27.75           C  
ATOM    453  O   LYS A 127      -9.425  49.885  -0.973  1.00 26.97           O  
ATOM    454  CB  LYS A 127     -12.680  49.020  -0.855  1.00 26.36           C  
ATOM    455  CG  LYS A 127     -12.520  49.429  -2.321  1.00 29.96           C  
ATOM    456  CD  LYS A 127     -13.844  49.395  -3.044  1.00 37.16           C  
ATOM    457  CE  LYS A 127     -14.688  50.547  -2.701  1.00 40.05           C  
ATOM    458  NZ  LYS A 127     -14.204  51.666  -3.571  1.00 47.24           N  
ATOM    459  N   ARG A 128     -10.646  50.705   0.722  1.00 28.76           N  
ATOM    460  CA  ARG A 128      -9.739  51.815   0.872  1.00 30.71           C  
ATOM    461  C   ARG A 128      -8.336  51.407   1.245  1.00 30.13           C  
ATOM    462  O   ARG A 128      -7.368  51.963   0.727  1.00 28.66           O  
ATOM    463  CB  ARG A 128     -10.313  52.799   1.846  1.00 32.90           C  
ATOM    464  CG  ARG A 128      -9.475  54.000   2.153  1.00 42.04           C  
ATOM    465  CD  ARG A 128     -10.319  55.036   3.000  1.00 49.74           C  
ATOM    466  NE  ARG A 128     -10.666  54.512   4.347  1.00 55.99           N  
ATOM    467  CZ  ARG A 128     -11.907  54.194   4.781  1.00 59.31           C  
ATOM    468  NH1 ARG A 128     -12.988  54.315   4.003  1.00 59.93           N  
ATOM    469  NH2 ARG A 128     -12.060  53.747   6.030  1.00 62.72           N  
ATOM    470  N   ARG A 129      -8.181  50.439   2.152  1.00 29.41           N  
ATOM    471  CA  ARG A 129      -6.874  49.879   2.468  1.00 29.09           C  
ATOM    472  C   ARG A 129      -6.166  49.295   1.257  1.00 29.94           C  
ATOM    473  O   ARG A 129      -4.971  49.475   1.071  1.00 30.50           O  
ATOM    474  CB  ARG A 129      -6.937  48.874   3.650  1.00 26.59           C  
ATOM    475  CG  ARG A 129      -7.216  49.575   4.953  1.00 29.08           C  
ATOM    476  CD  ARG A 129      -7.526  48.609   6.093  1.00 31.75           C  
ATOM    477  NE  ARG A 129      -7.593  49.310   7.352  1.00 32.01           N  
ATOM    478  CZ  ARG A 129      -7.576  48.679   8.539  1.00 36.26           C  
ATOM    479  NH1 ARG A 129      -7.521  47.378   8.621  1.00 32.70           N  
ATOM    480  NH2 ARG A 129      -7.587  49.362   9.655  1.00 40.41           N  
ATOM    481  N   LEU A 130      -6.900  48.565   0.439  1.00 29.92           N  
ATOM    482  CA  LEU A 130      -6.348  48.030  -0.775  1.00 30.17           C  
ATOM    483  C   LEU A 130      -5.905  49.181  -1.764  1.00 31.95           C  
ATOM    484  O   LEU A 130      -4.892  49.040  -2.423  1.00 33.35           O  
ATOM    485  CB  LEU A 130      -7.365  47.103  -1.491  1.00 29.76           C  
ATOM    486  CG  LEU A 130      -7.594  45.761  -0.769  1.00 27.42           C  
ATOM    487  CD1 LEU A 130      -8.946  45.070  -1.176  1.00 29.35           C  
ATOM    488  CD2 LEU A 130      -6.448  44.872  -0.984  1.00 27.84           C  
ATOM    489  N   GLU A 131      -6.643  50.283  -1.830  1.00 33.58           N  
ATOM    490  CA  GLU A 131      -6.301  51.386  -2.752  1.00 35.08           C  
ATOM    491  C   GLU A 131      -5.089  52.214  -2.263  1.00 37.87           C  
ATOM    492  O   GLU A 131      -4.431  52.927  -3.053  1.00 37.88           O  
ATOM    493  CB  GLU A 131      -7.495  52.328  -2.923  1.00 34.08           C  
ATOM    494  CG  GLU A 131      -8.704  51.642  -3.493  1.00 37.51           C  
ATOM    495  CD  GLU A 131     -10.001  52.411  -3.503  1.00 38.37           C  
ATOM    496  OE1 GLU A 131     -10.251  53.389  -2.744  1.00 45.33           O  
ATOM    497  OE2 GLU A 131     -10.866  51.941  -4.263  1.00 49.01           O  
ATOM    498  N   ASN A 132      -4.785  52.139  -0.968  1.00 38.84           N  
ATOM    499  CA  ASN A 132      -3.716  52.941  -0.365  1.00 38.99           C  
ATOM    500  C   ASN A 132      -2.491  52.128  -0.006  1.00 39.12           C  
ATOM    501  O   ASN A 132      -1.628  52.584   0.711  1.00 39.55           O  
ATOM    502  CB  ASN A 132      -4.255  53.615   0.862  1.00 39.96           C  
ATOM    503  CG  ASN A 132      -5.268  54.675   0.536  1.00 45.25           C  
ATOM    504  OD1 ASN A 132      -5.234  55.256  -0.530  1.00 53.43           O  
ATOM    505  ND2 ASN A 132      -6.151  54.979   1.490  1.00 52.98           N  
ATOM    506  N   ASN A 133      -2.412  50.908  -0.493  1.00 38.71           N  
ATOM    507  CA  ASN A 133      -1.305  50.067  -0.176  1.00 40.09           C  
ATOM    508  C   ASN A 133      -1.067  49.905   1.307  1.00 39.43           C  
ATOM    509  O   ASN A 133       0.081  49.824   1.733  1.00 40.54           O  
ATOM    510  CB  ASN A 133      -0.031  50.530  -0.951  1.00 42.26           C  
ATOM    511  CG  ASN A 133      -0.280  50.555  -2.453  1.00 46.31           C  
ATOM    512  OD1 ASN A 133      -0.893  49.634  -3.005  1.00 54.43           O  
ATOM    513  ND2 ASN A 133       0.078  51.656  -3.100  1.00 53.69           N  
ATOM    514  N   TYR A 134      -2.160  49.789   2.087  1.00 36.46           N  
ATOM    515  CA  TYR A 134      -2.061  49.518   3.497  1.00 34.93           C  
ATOM    516  C   TYR A 134      -1.588  48.141   3.805  1.00 33.95           C  
ATOM    517  O   TYR A 134      -0.831  47.983   4.740  1.00 34.11           O  
ATOM    518  CB  TYR A 134      -3.379  49.714   4.157  1.00 36.31           C  
ATOM    519  CG  TYR A 134      -3.496  49.270   5.603  1.00 37.87           C  
ATOM    520  CD1 TYR A 134      -3.123  50.111   6.669  1.00 38.89           C  
ATOM    521  CD2 TYR A 134      -3.963  48.006   5.907  1.00 34.40           C  
ATOM    522  CE1 TYR A 134      -3.295  49.662   8.035  1.00 39.70           C  
ATOM    523  CE2 TYR A 134      -4.111  47.562   7.246  1.00 35.26           C  
ATOM    524  CZ  TYR A 134      -3.809  48.410   8.290  1.00 40.12           C  
ATOM    525  OH  TYR A 134      -4.034  47.946   9.585  1.00 43.26           O  
ATOM    526  N   TYR A 135      -2.024  47.133   3.050  1.00 32.27           N  
ATOM    527  CA  TYR A 135      -1.620  45.775   3.296  1.00 31.43           C  
ATOM    528  C   TYR A 135      -0.280  45.420   2.708  1.00 34.34           C  
ATOM    529  O   TYR A 135       0.074  45.862   1.596  1.00 33.16           O  
ATOM    530  CB  TYR A 135      -2.658  44.838   2.748  1.00 32.07           C  
ATOM    531  CG  TYR A 135      -4.019  45.052   3.301  1.00 27.45           C  
ATOM    532  CD1 TYR A 135      -4.315  44.701   4.610  1.00 27.77           C  
ATOM    533  CD2 TYR A 135      -5.070  45.436   2.467  1.00 25.44           C  
ATOM    534  CE1 TYR A 135      -5.610  44.841   5.109  1.00 27.56           C  
ATOM    535  CE2 TYR A 135      -6.350  45.452   2.924  1.00 27.58           C  
ATOM    536  CZ  TYR A 135      -6.622  45.206   4.277  1.00 27.34           C  
ATOM    537  OH  TYR A 135      -7.919  45.339   4.760  1.00 28.50           O  
ATOM    538  N   TRP A 136       0.467  44.613   3.463  1.00 35.49           N  
ATOM    539  CA  TRP A 136       1.768  44.085   3.038  1.00 38.21           C  
ATOM    540  C   TRP A 136       1.601  42.729   2.367  1.00 37.57           C  
ATOM    541  O   TRP A 136       2.350  42.400   1.405  1.00 36.47           O  
ATOM    542  CB  TRP A 136       2.758  44.003   4.216  1.00 38.97           C  
ATOM    543  CG  TRP A 136       4.048  43.292   3.851  1.00 48.96           C  
ATOM    544  CD1 TRP A 136       4.322  41.940   3.945  1.00 53.61           C  
ATOM    545  CD2 TRP A 136       5.240  43.904   3.340  1.00 56.09           C  
ATOM    546  NE1 TRP A 136       5.606  41.684   3.514  1.00 58.20           N  
ATOM    547  CE2 TRP A 136       6.193  42.864   3.132  1.00 59.80           C  
ATOM    548  CE3 TRP A 136       5.602  45.222   3.042  1.00 58.11           C  
ATOM    549  CZ2 TRP A 136       7.477  43.104   2.622  1.00 63.24           C  
ATOM    550  CZ3 TRP A 136       6.884  45.465   2.543  1.00 62.82           C  
ATOM    551  CH2 TRP A 136       7.811  44.401   2.339  1.00 62.86           C  
ATOM    552  N   ALA A 137       0.598  41.963   2.825  1.00 35.61           N  
ATOM    553  CA  ALA A 137       0.371  40.619   2.302  1.00 35.78           C  
ATOM    554  C   ALA A 137      -1.117  40.366   2.147  1.00 34.22           C  
ATOM    555  O   ALA A 137      -1.917  40.941   2.855  1.00 33.85           O  
ATOM    556  CB  ALA A 137       0.962  39.586   3.231  1.00 36.34           C  
ATOM    557  N   ALA A 138      -1.466  39.432   1.295  1.00 34.23           N  
ATOM    558  CA  ALA A 138      -2.891  39.123   1.062  1.00 33.86           C  
ATOM    559  C   ALA A 138      -3.531  38.584   2.358  1.00 31.79           C  
ATOM    560  O   ALA A 138      -4.687  38.841   2.621  1.00 28.86           O  
ATOM    561  CB  ALA A 138      -3.032  38.121  -0.042  1.00 34.53           C  
ATOM    562  N   SER A 139      -2.791  37.813   3.138  1.00 30.22           N  
ATOM    563  CA  SER A 139      -3.324  37.244   4.369  1.00 31.20           C  
ATOM    564  C   SER A 139      -3.886  38.331   5.312  1.00 30.69           C  
ATOM    565  O   SER A 139      -4.846  38.113   6.050  1.00 28.89           O  
ATOM    566  CB  SER A 139      -2.228  36.413   5.119  1.00 32.84           C  
ATOM    567  OG  SER A 139      -1.156  37.265   5.526  1.00 35.95           O  
ATOM    568  N   GLU A 140      -3.276  39.518   5.303  1.00 29.59           N  
ATOM    569  CA  GLU A 140      -3.716  40.581   6.146  1.00 29.09           C  
ATOM    570  C   GLU A 140      -5.104  41.123   5.734  1.00 29.85           C  
ATOM    571  O   GLU A 140      -5.953  41.535   6.564  1.00 27.64           O  
ATOM    572  CB  GLU A 140      -2.676  41.702   6.135  1.00 31.02           C  
ATOM    573  CG  GLU A 140      -1.254  41.284   6.495  1.00 34.13           C  
ATOM    574  CD  GLU A 140      -0.257  42.457   6.402  1.00 40.21           C  
ATOM    575  OE1 GLU A 140      -0.564  43.462   5.731  1.00 35.94           O  
ATOM    576  OE2 GLU A 140       0.841  42.372   7.069  1.00 46.97           O  
ATOM    577  N   CYS A 141      -5.336  41.120   4.432  1.00 27.95           N  
ATOM    578  CA  CYS A 141      -6.589  41.528   3.894  1.00 29.39           C  
ATOM    579  C   CYS A 141      -7.659  40.472   4.156  1.00 26.93           C  
ATOM    580  O   CYS A 141      -8.742  40.807   4.579  1.00 25.89           O  
ATOM    581  CB  CYS A 141      -6.421  41.797   2.398  1.00 30.82           C  
ATOM    582  SG  CYS A 141      -7.898  42.182   1.557  1.00 31.56           S  
HETATM  583  N   MSE A 142      -7.316  39.208   3.926  1.00 26.17           N  
HETATM  584  CA  MSE A 142      -8.203  38.091   4.233  1.00 25.24           C  
HETATM  585  C   MSE A 142      -8.633  38.071   5.677  1.00 24.38           C  
HETATM  586  O   MSE A 142      -9.782  37.826   5.962  1.00 23.95           O  
HETATM  587  CB  MSE A 142      -7.570  36.781   3.845  1.00 26.18           C  
HETATM  588  CG  MSE A 142      -7.412  36.699   2.331  1.00 31.24           C  
HETATM  589 SE   MSE A 142      -6.153  35.237   1.897  1.00 50.11          SE  
HETATM  590  CE  MSE A 142      -7.112  33.827   2.835  1.00 38.11           C  
ATOM    591  N   GLN A 143      -7.742  38.431   6.578  1.00 23.66           N  
ATOM    592  CA  GLN A 143      -8.082  38.546   8.004  1.00 25.34           C  
ATOM    593  C   GLN A 143      -9.094  39.669   8.309  1.00 24.11           C  
ATOM    594  O   GLN A 143      -9.998  39.460   9.069  1.00 21.56           O  
ATOM    595  CB  GLN A 143      -6.799  38.772   8.788  1.00 28.28           C  
ATOM    596  CG  GLN A 143      -6.465  37.894   9.910  1.00 39.29           C  
ATOM    597  CD  GLN A 143      -6.634  36.351   9.714  1.00 36.82           C  
ATOM    598  OE1 GLN A 143      -7.680  35.875  10.058  1.00 43.60           O  
ATOM    599  NE2 GLN A 143      -5.567  35.599   9.313  1.00 42.14           N  
ATOM    600  N   ASP A 144      -9.026  40.825   7.644  1.00 23.33           N  
ATOM    601  CA  ASP A 144     -10.045  41.828   7.755  1.00 23.91           C  
ATOM    602  C   ASP A 144     -11.419  41.372   7.241  1.00 21.30           C  
ATOM    603  O   ASP A 144     -12.496  41.657   7.844  1.00 20.24           O  
ATOM    604  CB  ASP A 144      -9.600  43.135   7.040  1.00 24.53           C  
ATOM    605  CG  ASP A 144      -8.517  43.908   7.787  1.00 30.32           C  
ATOM    606  OD1 ASP A 144      -8.182  43.582   8.984  1.00 27.80           O  
ATOM    607  OD2 ASP A 144      -7.975  44.905   7.245  1.00 29.65           O  
ATOM    608  N   PHE A 145     -11.452  40.662   6.143  1.00 21.55           N  
ATOM    609  CA  PHE A 145     -12.746  40.155   5.642  1.00 20.97           C  
ATOM    610  C   PHE A 145     -13.277  39.207   6.705  1.00 21.16           C  
ATOM    611  O   PHE A 145     -14.415  39.209   7.000  1.00 21.14           O  
ATOM    612  CB  PHE A 145     -12.557  39.349   4.365  1.00 21.31           C  
ATOM    613  CG  PHE A 145     -12.558  40.147   3.097  1.00 24.58           C  
ATOM    614  CD1 PHE A 145     -13.783  40.484   2.535  1.00 29.07           C  
ATOM    615  CD2 PHE A 145     -11.373  40.431   2.401  1.00 28.38           C  
ATOM    616  CE1 PHE A 145     -13.836  41.169   1.290  1.00 30.61           C  
ATOM    617  CE2 PHE A 145     -11.420  41.107   1.165  1.00 29.87           C  
ATOM    618  CZ  PHE A 145     -12.677  41.449   0.621  1.00 27.52           C  
ATOM    619  N   ASN A 146     -12.422  38.349   7.244  1.00 20.92           N  
ATOM    620  CA  ASN A 146     -12.897  37.438   8.276  1.00 22.23           C  
ATOM    621  C   ASN A 146     -13.510  38.184   9.488  1.00 21.50           C  
ATOM    622  O   ASN A 146     -14.562  37.796  10.019  1.00 21.91           O  
ATOM    623  CB  ASN A 146     -11.792  36.522   8.694  1.00 24.70           C  
ATOM    624  CG  ASN A 146     -12.253  35.481   9.694  1.00 26.40           C  
ATOM    625  OD1 ASN A 146     -12.979  34.553   9.320  1.00 30.97           O  
ATOM    626  ND2 ASN A 146     -11.805  35.595  10.928  1.00 27.81           N  
ATOM    627  N   THR A 147     -12.801  39.205   9.966  1.00 22.89           N  
ATOM    628  CA  THR A 147     -13.317  40.024  11.075  1.00 22.52           C  
ATOM    629  C   THR A 147     -14.708  40.585  10.783  1.00 22.09           C  
ATOM    630  O   THR A 147     -15.563  40.529  11.663  1.00 20.59           O  
ATOM    631  CB  THR A 147     -12.350  41.130  11.428  1.00 22.59           C  
ATOM    632  OG1 THR A 147     -11.145  40.542  11.873  1.00 23.89           O  
ATOM    633  CG2 THR A 147     -12.833  41.917  12.599  1.00 25.33           C  
HETATM  634  N   MSE A 148     -14.932  41.086   9.562  1.00 20.20           N  
HETATM  635  CA  MSE A 148     -16.194  41.655   9.180  1.00 21.19           C  
HETATM  636  C   MSE A 148     -17.318  40.621   9.247  1.00 18.89           C  
HETATM  637  O   MSE A 148     -18.334  40.873   9.804  1.00 20.67           O  
HETATM  638  CB  MSE A 148     -16.119  42.193   7.764  1.00 21.74           C  
HETATM  639  CG  MSE A 148     -17.454  42.691   7.310  1.00 26.87           C  
HETATM  640 SE   MSE A 148     -17.250  43.343   5.426  1.00 41.51          SE  
HETATM  641  CE  MSE A 148     -16.731  41.729   4.567  1.00 39.24           C  
ATOM    642  N   PHE A 149     -17.062  39.423   8.768  1.00 21.50           N  
ATOM    643  CA  PHE A 149     -18.082  38.382   8.773  1.00 21.46           C  
ATOM    644  C   PHE A 149     -18.300  37.900  10.188  1.00 21.16           C  
ATOM    645  O   PHE A 149     -19.423  37.732  10.612  1.00 22.64           O  
ATOM    646  CB  PHE A 149     -17.645  37.203   7.903  1.00 22.20           C  
ATOM    647  CG  PHE A 149     -17.559  37.526   6.426  1.00 23.58           C  
ATOM    648  CD1 PHE A 149     -18.594  38.162   5.777  1.00 28.18           C  
ATOM    649  CD2 PHE A 149     -16.441  37.165   5.716  1.00 24.51           C  
ATOM    650  CE1 PHE A 149     -18.506  38.426   4.421  1.00 30.51           C  
ATOM    651  CE2 PHE A 149     -16.362  37.472   4.388  1.00 30.70           C  
ATOM    652  CZ  PHE A 149     -17.393  38.084   3.766  1.00 27.60           C  
ATOM    653  N   THR A 150     -17.220  37.657  10.905  1.00 19.82           N  
ATOM    654  CA  THR A 150     -17.325  37.168  12.300  1.00 21.44           C  
ATOM    655  C   THR A 150     -18.056  38.130  13.233  1.00 21.95           C  
ATOM    656  O   THR A 150     -18.888  37.707  14.068  1.00 21.76           O  
ATOM    657  CB  THR A 150     -15.889  36.808  12.779  1.00 23.68           C  
ATOM    658  OG1 THR A 150     -15.476  35.675  11.981  1.00 30.60           O  
ATOM    659  CG2 THR A 150     -15.911  36.215  14.116  1.00 30.24           C  
ATOM    660  N   ASN A 151     -17.813  39.444  13.079  1.00 20.85           N  
ATOM    661  CA  ASN A 151     -18.575  40.463  13.800  1.00 21.33           C  
ATOM    662  C   ASN A 151     -20.071  40.236  13.668  1.00 21.99           C  
ATOM    663  O   ASN A 151     -20.817  40.353  14.651  1.00 21.73           O  
ATOM    664  CB  ASN A 151     -18.206  41.874  13.350  1.00 17.22           C  
ATOM    665  CG  ASN A 151     -16.795  42.301  13.821  1.00 23.03           C  
ATOM    666  OD1 ASN A 151     -16.222  41.687  14.712  1.00 20.95           O  
ATOM    667  ND2 ASN A 151     -16.292  43.389  13.246  1.00 21.52           N  
ATOM    668  N   CYS A 152     -20.484  39.928  12.440  1.00 21.93           N  
ATOM    669  CA  CYS A 152     -21.893  39.724  12.130  1.00 23.00           C  
ATOM    670  C   CYS A 152     -22.442  38.496  12.857  1.00 22.93           C  
ATOM    671  O   CYS A 152     -23.383  38.579  13.598  1.00 23.64           O  
ATOM    672  CB  CYS A 152     -22.049  39.672  10.607  1.00 25.25           C  
ATOM    673  SG  CYS A 152     -23.720  39.398  10.137  1.00 32.76           S  
ATOM    674  N   TYR A 153     -21.717  37.397  12.805  1.00 22.48           N  
ATOM    675  CA  TYR A 153     -22.135  36.152  13.452  1.00 22.60           C  
ATOM    676  C   TYR A 153     -22.134  36.279  14.965  1.00 24.23           C  
ATOM    677  O   TYR A 153     -23.072  35.832  15.610  1.00 24.10           O  
ATOM    678  CB  TYR A 153     -21.219  34.997  13.076  1.00 21.84           C  
ATOM    679  CG  TYR A 153     -21.056  34.764  11.626  1.00 21.23           C  
ATOM    680  CD1 TYR A 153     -22.144  34.883  10.726  1.00 22.98           C  
ATOM    681  CD2 TYR A 153     -19.814  34.410  11.106  1.00 21.68           C  
ATOM    682  CE1 TYR A 153     -21.938  34.700   9.366  1.00 23.14           C  
ATOM    683  CE2 TYR A 153     -19.619  34.217   9.788  1.00 24.80           C  
ATOM    684  CZ  TYR A 153     -20.706  34.374   8.896  1.00 23.14           C  
ATOM    685  OH  TYR A 153     -20.472  34.130   7.562  1.00 25.73           O  
ATOM    686  N   ILE A 154     -21.187  37.025  15.537  1.00 22.89           N  
ATOM    687  CA  ILE A 154     -21.148  37.231  16.985  1.00 22.69           C  
ATOM    688  C   ILE A 154     -22.187  38.186  17.531  1.00 23.03           C  
ATOM    689  O   ILE A 154     -22.850  37.910  18.529  1.00 23.47           O  
ATOM    690  CB  ILE A 154     -19.694  37.699  17.405  1.00 22.80           C  
ATOM    691  CG1 ILE A 154     -18.765  36.570  17.138  1.00 24.63           C  
ATOM    692  CG2 ILE A 154     -19.677  38.207  18.833  1.00 22.16           C  
ATOM    693  CD1 ILE A 154     -17.246  36.993  17.092  1.00 29.10           C  
ATOM    694  N   TYR A 155     -22.358  39.317  16.894  1.00 23.23           N  
ATOM    695  CA  TYR A 155     -23.322  40.339  17.372  1.00 24.39           C  
ATOM    696  C   TYR A 155     -24.789  39.896  17.147  1.00 25.57           C  
ATOM    697  O   TYR A 155     -25.638  40.069  18.025  1.00 23.38           O  
ATOM    698  CB  TYR A 155     -23.081  41.709  16.695  1.00 25.42           C  
ATOM    699  CG  TYR A 155     -24.116  42.727  17.174  1.00 26.01           C  
ATOM    700  CD1 TYR A 155     -24.063  43.249  18.482  1.00 28.37           C  
ATOM    701  CD2 TYR A 155     -25.235  43.050  16.372  1.00 29.09           C  
ATOM    702  CE1 TYR A 155     -25.023  44.093  18.955  1.00 29.83           C  
ATOM    703  CE2 TYR A 155     -26.229  43.884  16.842  1.00 31.11           C  
ATOM    704  CZ  TYR A 155     -26.127  44.396  18.141  1.00 32.94           C  
ATOM    705  OH  TYR A 155     -27.087  45.223  18.604  1.00 36.74           O  
ATOM    706  N   ASN A 156     -25.080  39.362  15.960  1.00 25.46           N  
ATOM    707  CA  ASN A 156     -26.472  39.211  15.559  1.00 26.41           C  
ATOM    708  C   ASN A 156     -27.089  37.930  16.137  1.00 26.85           C  
ATOM    709  O   ASN A 156     -26.403  37.063  16.571  1.00 25.09           O  
ATOM    710  CB  ASN A 156     -26.660  39.325  14.062  1.00 25.00           C  
ATOM    711  CG  ASN A 156     -26.484  40.708  13.569  1.00 28.59           C  
ATOM    712  OD1 ASN A 156     -27.402  41.585  13.646  1.00 31.53           O  
ATOM    713  ND2 ASN A 156     -25.334  40.963  13.050  1.00 23.06           N  
ATOM    714  N   LYS A 157     -28.415  37.885  16.220  1.00 28.84           N  
ATOM    715  CA  LYS A 157     -29.138  36.677  16.639  1.00 30.39           C  
ATOM    716  C   LYS A 157     -29.007  35.677  15.499  1.00 29.02           C  
ATOM    717  O   LYS A 157     -28.945  36.095  14.339  1.00 28.63           O  
ATOM    718  CB  LYS A 157     -30.637  37.009  16.892  1.00 32.22           C  
ATOM    719  CG  LYS A 157     -30.906  37.962  18.034  1.00 36.25           C  
ATOM    720  CD  LYS A 157     -32.404  38.224  18.158  1.00 44.84           C  
ATOM    721  CE  LYS A 157     -32.745  39.316  19.172  1.00 50.90           C  
ATOM    722  NZ  LYS A 157     -32.722  40.709  18.603  1.00 55.15           N  
ATOM    723  N   PRO A 158     -28.976  34.376  15.789  1.00 28.68           N  
ATOM    724  CA  PRO A 158     -28.867  33.311  14.771  1.00 28.33           C  
ATOM    725  C   PRO A 158     -29.928  33.437  13.688  1.00 28.51           C  
ATOM    726  O   PRO A 158     -29.619  33.152  12.536  1.00 29.67           O  
ATOM    727  CB  PRO A 158     -29.071  32.029  15.569  1.00 27.81           C  
ATOM    728  CG  PRO A 158     -28.614  32.434  16.951  1.00 29.81           C  
ATOM    729  CD  PRO A 158     -29.116  33.823  17.174  1.00 29.76           C  
ATOM    730  N   THR A 159     -31.101  33.959  14.057  1.00 28.77           N  
ATOM    731  CA  THR A 159     -32.250  34.024  13.113  1.00 32.53           C  
ATOM    732  C   THR A 159     -32.294  35.285  12.293  1.00 32.31           C  
ATOM    733  O   THR A 159     -33.158  35.410  11.439  1.00 33.87           O  
ATOM    734  CB  THR A 159     -33.549  33.932  13.873  1.00 31.89           C  
ATOM    735  OG1 THR A 159     -33.518  34.825  14.985  1.00 35.92           O  
ATOM    736  CG2 THR A 159     -33.698  32.509  14.466  1.00 36.59           C  
ATOM    737  N   ASP A 160     -31.349  36.203  12.497  1.00 30.93           N  
ATOM    738  CA  ASP A 160     -31.355  37.490  11.764  1.00 29.81           C  
ATOM    739  C   ASP A 160     -31.003  37.260  10.301  1.00 29.16           C  
ATOM    740  O   ASP A 160     -30.086  36.479   9.982  1.00 27.27           O  
ATOM    741  CB  ASP A 160     -30.327  38.464  12.375  1.00 30.85           C  
ATOM    742  CG  ASP A 160     -30.780  39.138  13.653  1.00 33.74           C  
ATOM    743  OD1 ASP A 160     -31.993  39.196  13.991  1.00 36.53           O  
ATOM    744  OD2 ASP A 160     -29.939  39.730  14.375  1.00 40.29           O  
ATOM    745  N   ASP A 161     -31.713  37.911   9.375  1.00 26.91           N  
ATOM    746  CA  ASP A 161     -31.409  37.815   7.930  1.00 27.29           C  
ATOM    747  C   ASP A 161     -29.965  38.160   7.619  1.00 24.40           C  
ATOM    748  O   ASP A 161     -29.413  37.669   6.680  1.00 23.52           O  
ATOM    749  CB  ASP A 161     -32.280  38.779   7.096  1.00 27.99           C  
ATOM    750  CG  ASP A 161     -33.717  38.350   7.030  1.00 31.64           C  
ATOM    751  OD1 ASP A 161     -34.088  37.235   7.526  1.00 29.78           O  
ATOM    752  OD2 ASP A 161     -34.564  39.110   6.495  1.00 34.18           O  
ATOM    753  N   ILE A 162     -29.414  39.097   8.361  1.00 23.60           N  
ATOM    754  CA  ILE A 162     -28.058  39.534   8.092  1.00 24.06           C  
ATOM    755  C   ILE A 162     -27.059  38.412   8.213  1.00 21.27           C  
ATOM    756  O   ILE A 162     -26.086  38.374   7.503  1.00 21.11           O  
ATOM    757  CB  ILE A 162     -27.697  40.742   8.875  1.00 25.12           C  
ATOM    758  CG1 ILE A 162     -26.382  41.311   8.283  1.00 27.77           C  
ATOM    759  CG2 ILE A 162     -27.551  40.459  10.368  1.00 28.17           C  
ATOM    760  CD1 ILE A 162     -26.354  42.706   8.334  1.00 34.07           C  
ATOM    761  N   VAL A 163     -27.326  37.427   9.072  1.00 21.34           N  
ATOM    762  CA  VAL A 163     -26.427  36.317   9.249  1.00 21.91           C  
ATOM    763  C   VAL A 163     -26.398  35.503   7.950  1.00 22.46           C  
ATOM    764  O   VAL A 163     -25.356  35.027   7.524  1.00 21.49           O  
ATOM    765  CB  VAL A 163     -26.825  35.437  10.460  1.00 22.12           C  
ATOM    766  CG1 VAL A 163     -26.065  34.127  10.464  1.00 22.89           C  
ATOM    767  CG2 VAL A 163     -26.584  36.198  11.740  1.00 26.62           C  
ATOM    768  N   LEU A 164     -27.566  35.268   7.351  1.00 21.94           N  
ATOM    769  CA  LEU A 164     -27.651  34.548   6.106  1.00 24.98           C  
ATOM    770  C   LEU A 164     -26.935  35.252   4.980  1.00 21.52           C  
ATOM    771  O   LEU A 164     -26.348  34.655   4.156  1.00 21.17           O  
ATOM    772  CB  LEU A 164     -29.170  34.462   5.698  1.00 25.57           C  
ATOM    773  CG  LEU A 164     -29.994  33.283   6.108  1.00 36.41           C  
ATOM    774  CD1 LEU A 164     -29.560  32.463   7.313  1.00 43.22           C  
ATOM    775  CD2 LEU A 164     -31.477  33.713   6.108  1.00 41.31           C  
HETATM  776  N   MSE A 165     -27.044  36.554   4.945  1.00 23.06           N  
HETATM  777  CA  MSE A 165     -26.380  37.374   3.932  1.00 24.34           C  
HETATM  778  C   MSE A 165     -24.834  37.289   4.052  1.00 21.45           C  
HETATM  779  O   MSE A 165     -24.121  37.024   3.057  1.00 20.50           O  
HETATM  780  CB  MSE A 165     -26.890  38.775   4.104  1.00 25.14           C  
HETATM  781  CG  MSE A 165     -28.408  38.885   3.868  1.00 29.31           C  
HETATM  782 SE   MSE A 165     -29.264  40.650   4.333  1.00 44.43          SE  
HETATM  783  CE  MSE A 165     -28.479  41.610   3.099  1.00 23.40           C  
ATOM    784  N   ALA A 166     -24.335  37.417   5.269  1.00 19.59           N  
ATOM    785  CA  ALA A 166     -22.923  37.230   5.558  1.00 19.79           C  
ATOM    786  C   ALA A 166     -22.432  35.863   5.183  1.00 21.40           C  
ATOM    787  O   ALA A 166     -21.391  35.706   4.575  1.00 21.11           O  
ATOM    788  CB  ALA A 166     -22.626  37.512   6.985  1.00 21.93           C  
ATOM    789  N   GLN A 167     -23.173  34.801   5.505  1.00 23.55           N  
ATOM    790  CA  GLN A 167     -22.755  33.450   5.106  1.00 23.16           C  
ATOM    791  C   GLN A 167     -22.665  33.273   3.593  1.00 24.56           C  
ATOM    792  O   GLN A 167     -21.730  32.658   3.095  1.00 24.43           O  
ATOM    793  CB  GLN A 167     -23.697  32.388   5.652  1.00 23.66           C  
ATOM    794  CG  GLN A 167     -23.692  32.240   7.133  1.00 27.05           C  
ATOM    795  CD  GLN A 167     -24.752  31.263   7.659  1.00 32.14           C  
ATOM    796  OE1 GLN A 167     -24.413  30.302   8.326  1.00 35.55           O  
ATOM    797  NE2 GLN A 167     -26.042  31.548   7.399  1.00 27.14           N  
ATOM    798  N   THR A 168     -23.610  33.847   2.860  1.00 22.90           N  
ATOM    799  CA  THR A 168     -23.642  33.698   1.429  1.00 23.52           C  
ATOM    800  C   THR A 168     -22.390  34.456   0.880  1.00 23.62           C  
ATOM    801  O   THR A 168     -21.709  33.973  -0.015  1.00 22.23           O  
ATOM    802  CB  THR A 168     -24.890  34.359   0.913  1.00 23.65           C  
ATOM    803  OG1 THR A 168     -26.041  33.635   1.345  1.00 28.35           O  
ATOM    804  CG2 THR A 168     -24.976  34.402  -0.587  1.00 24.24           C  
ATOM    805  N   LEU A 169     -22.088  35.611   1.416  1.00 21.40           N  
ATOM    806  CA  LEU A 169     -20.938  36.417   0.923  1.00 22.77           C  
ATOM    807  C   LEU A 169     -19.629  35.742   1.289  1.00 23.72           C  
ATOM    808  O   LEU A 169     -18.697  35.694   0.479  1.00 22.73           O  
ATOM    809  CB  LEU A 169     -20.998  37.848   1.449  1.00 23.21           C  
ATOM    810  CG  LEU A 169     -22.224  38.673   1.023  1.00 26.04           C  
ATOM    811  CD1 LEU A 169     -22.466  39.824   1.933  1.00 27.80           C  
ATOM    812  CD2 LEU A 169     -22.019  39.196  -0.380  1.00 32.07           C  
ATOM    813  N   GLU A 170     -19.599  35.119   2.476  1.00 22.94           N  
ATOM    814  CA  GLU A 170     -18.379  34.470   2.933  1.00 24.36           C  
ATOM    815  C   GLU A 170     -18.056  33.276   2.106  1.00 22.90           C  
ATOM    816  O   GLU A 170     -16.900  33.016   1.861  1.00 23.65           O  
ATOM    817  CB  GLU A 170     -18.438  34.186   4.444  1.00 25.07           C  
ATOM    818  CG  GLU A 170     -17.154  33.610   4.995  1.00 28.51           C  
ATOM    819  CD  GLU A 170     -17.166  33.565   6.508  1.00 35.81           C  
ATOM    820  OE1 GLU A 170     -18.280  33.394   7.086  1.00 37.72           O  
ATOM    821  OE2 GLU A 170     -16.049  33.679   7.084  1.00 41.61           O  
ATOM    822  N   LYS A 171     -19.062  32.515   1.665  1.00 24.87           N  
ATOM    823  CA  LYS A 171     -18.841  31.397   0.739  1.00 26.30           C  
ATOM    824  C   LYS A 171     -18.227  31.819  -0.575  1.00 25.30           C  
ATOM    825  O   LYS A 171     -17.344  31.169  -1.050  1.00 26.91           O  
ATOM    826  CB  LYS A 171     -20.097  30.587   0.439  1.00 28.73           C  
ATOM    827  CG  LYS A 171     -20.803  30.055   1.671  1.00 36.79           C  
ATOM    828  CD  LYS A 171     -22.102  29.229   1.225  1.00 44.41           C  
ATOM    829  CE  LYS A 171     -22.794  28.513   2.437  1.00 48.73           C  
ATOM    830  NZ  LYS A 171     -22.333  28.890   3.803  1.00 48.98           N  
ATOM    831  N   ILE A 172     -18.656  32.903  -1.157  1.00 24.87           N  
ATOM    832  CA  ILE A 172     -18.022  33.452  -2.340  1.00 26.13           C  
ATOM    833  C   ILE A 172     -16.568  33.844  -2.085  1.00 25.60           C  
ATOM    834  O   ILE A 172     -15.610  33.540  -2.868  1.00 26.07           O  
ATOM    835  CB  ILE A 172     -18.808  34.704  -2.823  1.00 25.73           C  
ATOM    836  CG1 ILE A 172     -20.203  34.285  -3.347  1.00 32.18           C  
ATOM    837  CG2 ILE A 172     -18.143  35.402  -3.906  1.00 27.93           C  
ATOM    838  CD1 ILE A 172     -21.126  35.468  -3.510  1.00 34.02           C  
ATOM    839  N   PHE A 173     -16.376  34.508  -0.976  1.00 23.44           N  
ATOM    840  CA  PHE A 173     -15.048  34.914  -0.584  1.00 23.43           C  
ATOM    841  C   PHE A 173     -14.109  33.705  -0.529  1.00 24.72           C  
ATOM    842  O   PHE A 173     -13.022  33.692  -1.155  1.00 24.47           O  
ATOM    843  CB  PHE A 173     -15.132  35.657   0.769  1.00 22.93           C  
ATOM    844  CG  PHE A 173     -13.766  35.845   1.441  1.00 26.03           C  
ATOM    845  CD1 PHE A 173     -12.853  36.734   0.927  1.00 28.41           C  
ATOM    846  CD2 PHE A 173     -13.417  35.092   2.546  1.00 26.91           C  
ATOM    847  CE1 PHE A 173     -11.554  36.871   1.507  1.00 27.97           C  
ATOM    848  CE2 PHE A 173     -12.123  35.247   3.135  1.00 31.09           C  
ATOM    849  CZ  PHE A 173     -11.207  36.113   2.552  1.00 28.54           C  
ATOM    850  N   LEU A 174     -14.544  32.594   0.113  1.00 24.72           N  
ATOM    851  CA  LEU A 174     -13.656  31.430   0.194  1.00 25.79           C  
ATOM    852  C   LEU A 174     -13.450  30.735  -1.127  1.00 27.41           C  
ATOM    853  O   LEU A 174     -12.335  30.256  -1.415  1.00 25.78           O  
ATOM    854  CB  LEU A 174     -14.164  30.415   1.181  1.00 27.15           C  
ATOM    855  CG  LEU A 174     -14.164  30.860   2.601  1.00 26.71           C  
ATOM    856  CD1 LEU A 174     -14.935  29.810   3.425  1.00 30.66           C  
ATOM    857  CD2 LEU A 174     -12.753  30.958   3.066  1.00 30.68           C  
ATOM    858  N   GLN A 175     -14.503  30.717  -1.956  1.00 28.35           N  
ATOM    859  CA  GLN A 175     -14.432  30.136  -3.290  1.00 28.10           C  
ATOM    860  C   GLN A 175     -13.413  30.924  -4.110  1.00 28.82           C  
ATOM    861  O   GLN A 175     -12.528  30.343  -4.768  1.00 27.58           O  
ATOM    862  CB  GLN A 175     -15.812  30.137  -4.004  1.00 28.75           C  
ATOM    863  CG  GLN A 175     -16.650  29.013  -3.673  1.00 36.84           C  
ATOM    864  CD  GLN A 175     -18.164  29.145  -4.043  1.00 43.08           C  
ATOM    865  OE1 GLN A 175     -18.932  28.203  -3.754  1.00 46.11           O  
ATOM    866  NE2 GLN A 175     -18.590  30.287  -4.619  1.00 43.60           N  
ATOM    867  N   LYS A 176     -13.469  32.228  -4.043  1.00 26.88           N  
ATOM    868  CA  LYS A 176     -12.523  33.063  -4.797  1.00 28.13           C  
ATOM    869  C   LYS A 176     -11.085  33.009  -4.243  1.00 28.74           C  
ATOM    870  O   LYS A 176     -10.145  32.997  -4.995  1.00 29.79           O  
ATOM    871  CB  LYS A 176     -12.957  34.537  -4.870  1.00 29.27           C  
ATOM    872  CG  LYS A 176     -14.245  34.756  -5.526  1.00 34.65           C  
ATOM    873  CD  LYS A 176     -14.263  34.493  -6.951  1.00 43.43           C  
ATOM    874  CE  LYS A 176     -15.427  35.217  -7.625  1.00 47.97           C  
ATOM    875  NZ  LYS A 176     -15.282  35.002  -9.083  1.00 51.54           N  
ATOM    876  N   VAL A 177     -10.903  32.879  -2.933  1.00 28.39           N  
ATOM    877  CA  VAL A 177      -9.575  32.675  -2.366  1.00 29.73           C  
ATOM    878  C   VAL A 177      -8.968  31.377  -2.836  1.00 30.78           C  
ATOM    879  O   VAL A 177      -7.746  31.302  -3.040  1.00 30.16           O  
ATOM    880  CB  VAL A 177      -9.610  32.753  -0.810  1.00 31.11           C  
ATOM    881  CG1 VAL A 177      -8.314  32.215  -0.187  1.00 35.76           C  
ATOM    882  CG2 VAL A 177      -9.833  34.201  -0.448  1.00 30.00           C  
ATOM    883  N   ALA A 178      -9.773  30.356  -3.028  1.00 29.72           N  
ATOM    884  CA  ALA A 178      -9.232  29.102  -3.546  1.00 31.90           C  
ATOM    885  C   ALA A 178      -8.665  29.181  -4.989  1.00 32.76           C  
ATOM    886  O   ALA A 178      -8.012  28.245  -5.421  1.00 32.32           O  
ATOM    887  CB  ALA A 178     -10.247  28.029  -3.478  1.00 32.19           C  
ATOM    888  N   SER A 179      -8.948  30.254  -5.713  1.00 34.57           N  
ATOM    889  CA  SER A 179      -8.434  30.487  -7.092  1.00 35.46           C  
ATOM    890  C   SER A 179      -7.455  31.625  -7.186  1.00 35.90           C  
ATOM    891  O   SER A 179      -7.134  32.087  -8.295  1.00 35.05           O  
ATOM    892  CB  SER A 179      -9.573  30.836  -8.066  1.00 36.72           C  
ATOM    893  OG  SER A 179     -10.595  29.886  -8.003  1.00 40.39           O  
HETATM  894  N   MSE A 180      -6.933  32.063  -6.045  1.00 35.78           N  
HETATM  895  CA  MSE A 180      -6.068  33.185  -6.000  1.00 37.13           C  
HETATM  896  C   MSE A 180      -4.746  32.756  -6.579  1.00 39.05           C  
HETATM  897  O   MSE A 180      -4.240  31.677  -6.212  1.00 37.44           O  
HETATM  898  CB  MSE A 180      -5.826  33.571  -4.535  1.00 37.62           C  
HETATM  899  CG  MSE A 180      -5.049  34.797  -4.389  1.00 39.74           C  
HETATM  900 SE   MSE A 180      -5.308  35.584  -2.605  1.00 55.17          SE  
HETATM  901  CE  MSE A 180      -4.683  34.029  -1.526  1.00 46.11           C  
ATOM    902  N   PRO A 181      -4.130  33.614  -7.390  1.00 42.12           N  
ATOM    903  CA  PRO A 181      -2.801  33.272  -7.969  1.00 45.03           C  
ATOM    904  C   PRO A 181      -1.771  33.094  -6.910  1.00 47.21           C  
ATOM    905  O   PRO A 181      -1.799  33.791  -5.918  1.00 44.76           O  
ATOM    906  CB  PRO A 181      -2.431  34.498  -8.796  1.00 45.22           C  
ATOM    907  CG  PRO A 181      -3.214  35.625  -8.172  1.00 44.90           C  
ATOM    908  CD  PRO A 181      -4.561  34.977  -7.773  1.00 41.88           C  
ATOM    909  N   GLN A 182      -0.894  32.122  -7.101  1.00 52.44           N  
ATOM    910  CA  GLN A 182       0.046  31.769  -6.059  1.00 56.70           C  
ATOM    911  C   GLN A 182       1.445  32.065  -6.469  1.00 62.38           C  
ATOM    912  O   GLN A 182       2.337  31.218  -6.471  1.00 63.71           O  
ATOM    913  CB  GLN A 182      -0.107  30.336  -5.615  1.00 56.31           C  
ATOM    914  CG  GLN A 182      -1.268  30.183  -4.692  1.00 54.50           C  
ATOM    915  CD  GLN A 182      -1.201  31.087  -3.440  1.00 51.68           C  
ATOM    916  OE1 GLN A 182      -0.104  31.457  -2.933  1.00 48.69           O  
ATOM    917  NE2 GLN A 182      -2.375  31.432  -2.936  1.00 50.67           N  
ATOM    918  N   GLU A 183       1.656  33.324  -6.787  1.00 67.69           N  
ATOM    919  CA  GLU A 183       3.001  33.730  -7.019  1.00 71.63           C  
ATOM    920  C   GLU A 183       3.249  34.877  -6.051  1.00 73.27           C  
ATOM    921  O   GLU A 183       3.929  35.820  -6.452  1.00 74.56           O  
ATOM    922  CB  GLU A 183       3.193  34.103  -8.519  1.00 72.47           C  
ATOM    923  CG  GLU A 183       2.239  33.392  -9.512  1.00 76.33           C  
ATOM    924  CD  GLU A 183       2.416  31.857  -9.578  1.00 81.49           C  
ATOM    925  OE1 GLU A 183       3.501  31.396 -10.047  1.00 82.61           O  
ATOM    926  OE2 GLU A 183       1.470  31.103  -9.171  1.00 82.64           O  
ATOM    927  N   GLU A 184       2.745  34.815  -4.797  1.00 74.56           N  
ATOM    928  CA  GLU A 184       2.666  36.058  -3.980  1.00 76.27           C  
ATOM    929  C   GLU A 184       3.908  36.933  -4.185  1.00 76.65           C  
ATOM    930  O   GLU A 184       4.915  36.758  -3.499  1.00 76.08           O  
ATOM    931  CB  GLU A 184       2.414  35.821  -2.474  1.00 76.52           C  
ATOM    932  CG  GLU A 184       2.443  37.084  -1.544  1.00 78.90           C  
ATOM    933  CD  GLU A 184       1.285  38.136  -1.680  1.00 80.68           C  
ATOM    934  OE1 GLU A 184       0.769  38.662  -0.647  1.00 73.83           O  
ATOM    935  OE2 GLU A 184       0.906  38.484  -2.824  1.00 84.33           O  
ATOM    936  N   GLN A 185       3.805  37.882  -5.120  1.00 77.63           N  
ATOM    937  CA  GLN A 185       4.962  38.623  -5.603  1.00 78.45           C  
ATOM    938  C   GLN A 185       4.696  40.083  -5.913  1.00 78.46           C  
ATOM    939  O   GLN A 185       3.591  40.458  -6.269  1.00 76.74           O  
ATOM    940  CB  GLN A 185       5.575  37.951  -6.862  1.00 79.14           C  
ATOM    941  CG  GLN A 185       4.744  38.047  -8.171  1.00 81.18           C  
ATOM    942  CD  GLN A 185       5.412  37.331  -9.365  1.00 84.40           C  
ATOM    943  OE1 GLN A 185       6.552  37.653  -9.730  1.00 84.32           O  
ATOM    944  NE2 GLN A 185       4.696  36.382  -9.979  1.00 85.97           N  
ATOM    945  N   GLU A 186       5.810  40.821  -5.835  1.00 79.60           N  
ATOM    946  CA  GLU A 186       6.028  42.258  -6.081  1.00 80.33           C  
ATOM    947  C   GLU A 186       6.369  42.877  -4.742  1.00 80.38           C  
ATOM    948  O   GLU A 186       7.134  43.840  -4.643  1.00 80.19           O  
ATOM    949  CB  GLU A 186       4.863  42.975  -6.748  1.00 80.51           C  
ATOM    950  CG  GLU A 186       4.760  42.706  -8.227  1.00 81.04           C  
ATOM    951  CD  GLU A 186       3.584  43.433  -8.831  1.00 82.34           C  
ATOM    952  OE1 GLU A 186       3.715  44.638  -9.117  1.00 81.29           O  
ATOM    953  OE2 GLU A 186       2.525  42.805  -8.996  1.00 83.60           O  
TER     954      GLU A 186                                                      
END
MOLECULE T0432.pdb
ATOM      1  N   SER     1      12.703  45.910  -3.320  1.00 50.93           N
ATOM      2  CA  SER     1      13.109  46.216  -4.712  1.00 47.13           C
ATOM      4  CB  SER     1      13.709  44.967  -5.358  1.00 53.53           C
ATOM      7  OG  SER     1      12.759  43.911  -5.430  1.00 42.48           O
ATOM      9  C   SER     1      11.931  46.715  -5.566  1.00 52.43           C
ATOM     10  O   SER     1      10.768  46.719  -5.114  1.00 45.72           O
ATOM     14  N   MET     2      12.255  47.142  -6.791  1.00 48.01           N
ATOM     15  CA  MET     2      11.257  47.418  -7.836  1.00 53.09           C
ATOM     17  CB  MET     2      11.927  47.928  -9.120  1.00 51.71           C
ATOM     23  C   MET     2      10.424  46.169  -8.153  1.00 49.18           C
ATOM     24  O   MET     2       9.206  46.267  -8.286  1.00 51.00           O
ATOM     26  N   GLN     3      11.078  45.011  -8.268  1.00 44.90           N
ATOM     27  CA  GLN     3      10.368  43.738  -8.433  1.00 49.87           C
ATOM     29  CB  GLN     3      11.334  42.538  -8.524  1.00 49.44           C
ATOM     32  CG  GLN     3      11.990  42.326  -9.886  1.00 56.96           C
ATOM     38  C   GLN     3       9.361  43.512  -7.283  1.00 43.65           C
ATOM     39  O   GLN     3       8.242  43.071  -7.521  1.00 37.83           O
ATOM     41  N   GLU     4       9.764  43.812  -6.049  1.00 34.49           N
ATOM     42  CA  GLU     4       8.896  43.571  -4.909  1.00 28.57           C
ATOM     44  CB  GLU     4       9.695  43.588  -3.619  1.00 30.35           C
ATOM     47  CG  GLU     4      10.564  42.317  -3.478  1.00 32.03           C
ATOM     50  CD  GLU     4      11.497  42.362  -2.284  1.00 34.53           C
ATOM     51  OE1 GLU     4      11.564  43.415  -1.624  1.00 39.92           O
ATOM     52  OE2 GLU     4      12.167  41.335  -2.002  1.00 35.71           O
ATOM     53  C   GLU     4       7.708  44.529  -4.871  1.00 25.78           C
ATOM     54  O   GLU     4       6.586  44.106  -4.548  1.00 21.89           O
ATOM     56  N   GLU     5       7.958  45.807  -5.172  1.00 27.67           N
ATOM     57  CA  GLU     5       6.900  46.803  -5.275  1.00 29.37           C
ATOM     59  CB  GLU     5       7.492  48.200  -5.504  1.00 32.93           C
ATOM     62  CG  GLU     5       8.329  48.698  -4.321  1.00 36.17           C
ATOM     68  C   GLU     5       5.841  46.464  -6.357  1.00 26.28           C
ATOM     69  O   GLU     5       4.652  46.729  -6.168  1.00 24.25           O
ATOM     71  N   ASP     6       6.276  45.882  -7.472  1.00 23.77           N
ATOM     72  CA  ASP     6       5.354  45.408  -8.499  1.00 26.67           C
ATOM     74  CB  ASP     6       6.099  44.978  -9.756  1.00 25.76           C
ATOM     77  CG  ASP     6       6.749  46.165 -10.526  1.00 24.96           C
ATOM     78  OD1 ASP     6       6.374  47.338 -10.325  1.00 41.80           O
ATOM     79  OD2 ASP     6       7.653  45.870 -11.317  1.00 39.42           O
ATOM     80  C   ASP     6       4.501  44.208  -7.998  1.00 20.23           C
ATOM     81  O   ASP     6       3.358  44.093  -8.388  1.00 20.47           O
ATOM     83  N   THR     7       5.093  43.319  -7.201  1.00 22.25           N
ATOM     84  CA  THR     7       4.384  42.184  -6.606  1.00 22.70           C
ATOM     86  CB  THR     7       5.332  41.245  -5.780  1.00 22.94           C
ATOM     88  OG1 THR     7       6.367  40.712  -6.630  1.00 26.30           O
ATOM     90  CG2 THR     7       4.556  40.047  -5.132  1.00 16.87           C
ATOM     94  C   THR     7       3.250  42.693  -5.726  1.00 21.27           C
ATOM     95  O   THR     7       2.114  42.227  -5.839  1.00 18.76           O
ATOM     97  N   PHE     8       3.574  43.615  -4.823  1.00 19.23           N
ATOM     98  CA  PHE     8       2.558  44.181  -3.944  1.00 19.60           C
ATOM    100  CB  PHE     8       3.176  45.001  -2.822  1.00 22.71           C
ATOM    103  CG  PHE     8       3.951  44.177  -1.823  1.00 23.51           C
ATOM    104  CD1 PHE     8       3.439  42.949  -1.346  1.00 28.77           C
ATOM    106  CE1 PHE     8       4.152  42.173  -0.434  1.00 28.06           C
ATOM    108  CZ  PHE     8       5.373  42.635   0.031  1.00 28.78           C
ATOM    110  CE2 PHE     8       5.884  43.835  -0.423  1.00 30.30           C
ATOM    112  CD2 PHE     8       5.169  44.616  -1.353  1.00 28.10           C
ATOM    114  C   PHE     8       1.496  44.993  -4.689  1.00 22.06           C
ATOM    115  O   PHE     8       0.320  44.959  -4.316  1.00 17.45           O
ATOM    117  N   ARG     9       1.904  45.735  -5.712  1.00 20.32           N
ATOM    118  CA  ARG     9       0.939  46.442  -6.556  1.00 18.47           C
ATOM    120  CB  ARG     9       1.639  47.343  -7.542  1.00 20.96           C
ATOM    123  CG  ARG     9       0.718  48.210  -8.324  1.00 30.12           C
ATOM    126  CD  ARG     9       1.462  49.336  -8.973  1.00 33.72           C
ATOM    129  NE  ARG     9       0.560  50.358  -9.495  1.00 49.38           N
ATOM    131  CZ  ARG     9      -0.009  50.371 -10.710  1.00 50.88           C
ATOM    132  NH1 ARG     9       0.198  49.411 -11.626  1.00 36.54           N
ATOM    135  NH2 ARG     9      -0.779  51.400 -11.024  1.00 35.58           N
ATOM    138  C   ARG     9      -0.005  45.464  -7.267  1.00 18.25           C
ATOM    139  O   ARG     9      -1.217  45.710  -7.282  1.00 15.91           O
ATOM    141  N   GLU    10       0.522  44.363  -7.832  1.00 15.31           N
ATOM    142  CA  GLU    10      -0.351  43.339  -8.413  1.00 19.50           C
ATOM    144  CB  GLU    10       0.439  42.219  -9.076  1.00 21.24           C
ATOM    147  CG  GLU    10      -0.467  41.097  -9.566  1.00 23.10           C
ATOM    150  CD  GLU    10       0.189  40.117 -10.508  1.00 33.77           C
ATOM    151  OE1 GLU    10      -0.487  39.118 -10.845  1.00 26.89           O
ATOM    152  OE2 GLU    10       1.358  40.328 -10.890  1.00 26.18           O
ATOM    153  C   GLU    10      -1.355  42.768  -7.382  1.00 23.48           C
ATOM    154  O   GLU    10      -2.548  42.617  -7.692  1.00 16.96           O
ATOM    156  N   LEU    11      -0.871  42.447  -6.176  1.00 22.33           N
ATOM    157  CA  LEU    11      -1.756  42.020  -5.079  1.00 17.97           C
ATOM    159  CB  LEU    11      -0.969  41.736  -3.779  1.00 21.21           C
ATOM    162  CG  LEU    11      -1.851  41.320  -2.564  1.00 18.71           C
ATOM    164  CD1 LEU    11      -2.569  39.975  -2.827  1.00 16.49           C
ATOM    168  CD2 LEU    11      -1.052  41.296  -1.292  1.00 17.23           C
ATOM    172  C   LEU    11      -2.872  43.029  -4.826  1.00 18.50           C
ATOM    173  O   LEU    11      -4.018  42.652  -4.757  1.00 17.18           O
ATOM    175  N   ARG    12      -2.554  44.316  -4.710  1.00 16.81           N
ATOM    176  CA  ARG    12      -3.587  45.342  -4.508  1.00 18.76           C
ATOM    178  CB  ARG    12      -2.975  46.756  -4.299  1.00 15.68           C
ATOM    181  CG  ARG    12      -2.092  46.846  -3.060  1.00 20.36           C
ATOM    184  CD  ARG    12      -1.799  48.294  -2.715  1.00 24.48           C
ATOM    187  NE  ARG    12      -0.943  48.950  -3.696  1.00 19.83           N
ATOM    189  CZ  ARG    12       0.393  48.875  -3.740  1.00 17.58           C
ATOM    190  NH1 ARG    12       1.084  48.164  -2.878  1.00 25.76           N
ATOM    193  NH2 ARG    12       1.034  49.530  -4.686  1.00 24.92           N
ATOM    196  C   ARG    12      -4.628  45.388  -5.624  1.00 16.66           C
ATOM    197  O   ARG    12      -5.828  45.475  -5.353  1.00 16.08           O
ATOM    199  N   ILE    13      -4.164  45.301  -6.864  1.00 19.21           N
ATOM    200  CA  ILE    13      -5.044  45.236  -8.043  1.00 17.95           C
ATOM    202  CB  ILE    13      -4.224  45.209  -9.367  1.00 17.89           C
ATOM    204  CG1 ILE    13      -3.478  46.541  -9.577  1.00 23.66           C
ATOM    207  CD1 ILE    13      -2.498  46.500 -10.707  1.00 27.76           C
ATOM    211  CG2 ILE    13      -5.101  44.894 -10.587  1.00 24.21           C
ATOM    215  C   ILE    13      -5.997  44.011  -7.963  1.00 14.86           C
ATOM    216  O   ILE    13      -7.218  44.155  -8.154  1.00 16.18           O
ATOM    218  N   PHE    14      -5.438  42.857  -7.652  1.00 16.54           N
ATOM    219  CA  PHE    14      -6.211  41.642  -7.441  1.00 15.48           C
ATOM    221  CB  PHE    14      -5.313  40.456  -7.134  1.00 18.04           C
ATOM    224  CG  PHE    14      -6.074  39.237  -6.793  1.00 18.02           C
ATOM    225  CD1 PHE    14      -6.678  38.465  -7.790  1.00 26.02           C
ATOM    227  CE1 PHE    14      -7.424  37.332  -7.462  1.00 20.26           C
ATOM    229  CZ  PHE    14      -7.559  36.973  -6.149  1.00 20.14           C
ATOM    231  CE2 PHE    14      -6.970  37.746  -5.142  1.00 23.20           C
ATOM    233  CD2 PHE    14      -6.239  38.861  -5.465  1.00 22.05           C
ATOM    235  C   PHE    14      -7.252  41.824  -6.314  1.00 17.60           C
ATOM    236  O   PHE    14      -8.431  41.558  -6.507  1.00 16.66           O
ATOM    238  N   LEU    15      -6.807  42.332  -5.166  1.00 15.25           N
ATOM    239  CA  LEU    15      -7.701  42.555  -4.016  1.00 15.48           C
ATOM    241  CB  LEU    15      -6.921  42.915  -2.741  1.00 17.25           C
ATOM    244  CG  LEU    15      -5.972  41.845  -2.195  1.00 20.45           C
ATOM    246  CD1 LEU    15      -5.225  42.342  -0.920  1.00 15.28           C
ATOM    250  CD2 LEU    15      -6.687  40.491  -1.929  1.00 17.37           C
ATOM    254  C   LEU    15      -8.826  43.550  -4.269  1.00 16.03           C
ATOM    255  O   LEU    15      -9.961  43.320  -3.815  1.00 15.92           O
ATOM    257  N   ARG    16      -8.542  44.625  -4.980  1.00 16.38           N
ATOM    258  CA  ARG    16      -9.590  45.593  -5.363  1.00 13.95           C
ATOM    260  CB  ARG    16      -9.022  46.796  -6.096  1.00 16.47           C
ATOM    263  CG  ARG    16      -8.327  47.808  -5.243  1.00 20.20           C
ATOM    266  CD  ARG    16      -7.975  49.054  -6.021  1.00 26.38           C
ATOM    269  NE  ARG    16      -6.868  49.676  -5.338  1.00 24.76           N
ATOM    271  CZ  ARG    16      -5.583  49.547  -5.650  1.00 23.18           C
ATOM    272  NH1 ARG    16      -5.178  48.910  -6.742  1.00 24.86           N
ATOM    275  NH2 ARG    16      -4.686  50.121  -4.856  1.00 30.66           N
ATOM    278  C   ARG    16     -10.679  44.968  -6.259  1.00 13.93           C
ATOM    279  O   ARG    16     -11.864  45.248  -6.112  1.00 14.07           O
ATOM    281  N   ASN    17     -10.257  44.175  -7.218  1.00 16.80           N
ATOM    282  CA  ASN    17     -11.176  43.522  -8.112  1.00 18.78           C
ATOM    284  CB  ASN    17     -10.401  42.870  -9.247  1.00 21.01           C
ATOM    287  CG  ASN    17     -11.295  42.036 -10.170  1.00 28.67           C
ATOM    288  OD1 ASN    17     -11.469  40.838  -9.941  1.00 21.42           O
ATOM    289  ND2 ASN    17     -11.827  42.664 -11.250  1.00 28.09           N
ATOM    292  C   ASN    17     -12.089  42.535  -7.382  1.00 16.00           C
ATOM    293  O   ASN    17     -13.302  42.574  -7.591  1.00 17.86           O
ATOM    295  N   VAL    18     -11.520  41.689  -6.521  1.00 18.79           N
ATOM    296  CA  VAL    18     -12.301  40.735  -5.735  1.00 17.67           C
ATOM    298  CB  VAL    18     -11.407  39.847  -4.834  1.00 19.56           C
ATOM    300  CG1 VAL    18     -12.271  39.004  -3.891  1.00 20.84           C
ATOM    304  CG2 VAL    18     -10.450  38.989  -5.687  1.00 14.57           C
ATOM    308  C   VAL    18     -13.266  41.501  -4.810  1.00 17.37           C
ATOM    309  O   VAL    18     -14.450  41.176  -4.721  1.00 19.43           O
ATOM    311  N   THR    19     -12.747  42.526  -4.146  1.00 16.37           N
ATOM    312  CA  THR    19     -13.563  43.341  -3.222  1.00 17.39           C
ATOM    314  CB  THR    19     -12.716  44.371  -2.443  1.00 16.96           C
ATOM    316  OG1 THR    19     -11.617  43.710  -1.816  1.00 17.66           O
ATOM    318  CG2 THR    19     -13.564  45.076  -1.343  1.00 20.05           C
ATOM    322  C   THR    19     -14.744  44.026  -3.933  1.00 17.65           C
ATOM    323  O   THR    19     -15.852  44.020  -3.417  1.00 19.09           O
ATOM    325  N   HIS    20     -14.508  44.595  -5.101  1.00 19.93           N
ATOM    326  CA  HIS    20     -15.611  45.135  -5.920  1.00 19.72           C
ATOM    328  CB  HIS    20     -15.059  45.947  -7.086  0.50 21.68           C
ATOM    334  CG  HIS    20     -14.484  47.263  -6.651  0.50 31.09           C
ATOM    336  ND1 HIS    20     -15.103  48.066  -5.710  0.50 15.30           N
ATOM    340  CE1 HIS    20     -14.376  49.152  -5.520  0.50 31.02           C
ATOM    344  NE2 HIS    20     -13.308  49.082  -6.295  0.50 28.85           N
ATOM    348  CD2 HIS    20     -13.355  47.914  -7.019  0.50 25.42           C
ATOM    352  C   HIS    20     -16.660  44.095  -6.319  1.00 17.96           C
ATOM    353  O   HIS    20     -17.853  44.378  -6.303  1.00 20.97           O
ATOM    355  N   ARG    21     -16.230  42.894  -6.686  1.00 17.03           N
ATOM    356  CA  ARG    21     -17.180  41.826  -7.010  1.00 18.99           C
ATOM    358  CB  ARG    21     -16.435  40.624  -7.602  1.00 14.36           C
ATOM    361  CG  ARG    21     -15.970  40.922  -9.011  1.00 20.10           C
ATOM    364  CD  ARG    21     -14.704  40.187  -9.358  1.00 26.48           C
ATOM    367  NE  ARG    21     -14.976  38.798  -9.527  1.00 23.70           N
ATOM    369  CZ  ARG    21     -14.059  37.850  -9.652  1.00 24.65           C
ATOM    370  NH1 ARG    21     -12.773  38.120  -9.628  1.00 21.13           N
ATOM    373  NH2 ARG    21     -14.461  36.619  -9.815  1.00 21.77           N
ATOM    376  C   ARG    21     -18.083  41.435  -5.822  1.00 19.61           C
ATOM    377  O   ARG    21     -19.285  41.157  -5.992  1.00 23.33           O
ATOM    379  N   LEU    22     -17.522  41.469  -4.622  1.00 19.80           N
ATOM    380  CA  LEU    22     -18.300  41.281  -3.399  1.00 18.25           C
ATOM    382  CB  LEU    22     -17.378  41.023  -2.193  1.00 19.98           C
ATOM    385  CG  LEU    22     -16.345  39.907  -2.263  1.00 18.93           C
ATOM    387  CD1 LEU    22     -15.396  39.999  -1.040  1.00 20.62           C
ATOM    391  CD2 LEU    22     -17.018  38.495  -2.365  1.00 20.07           C
ATOM    395  C   LEU    22     -19.228  42.459  -3.101  1.00 20.64           C
ATOM    396  O   LEU    22     -20.415  42.251  -2.807  1.00 21.92           O
ATOM    398  N   ALA    23     -18.701  43.679  -3.190  1.00 17.45           N
ATOM    399  CA  ALA    23     -19.441  44.866  -2.847  1.00 17.66           C
ATOM    401  CB  ALA    23     -18.527  46.122  -2.822  1.00 21.62           C
ATOM    405  C   ALA    23     -20.644  45.119  -3.776  1.00 26.04           C
ATOM    406  O   ALA    23     -21.590  45.756  -3.360  1.00 22.48           O
ATOM    408  N   ILE    24     -20.612  44.639  -5.014  1.00 25.86           N
ATOM    409  CA  ILE    24     -21.755  44.832  -5.895  1.00 27.15           C
ATOM    411  CB  ILE    24     -21.344  45.044  -7.374  1.00 28.18           C
ATOM    413  CG1 ILE    24     -20.761  43.768  -7.966  1.00 23.99           C
ATOM    416  CD1 ILE    24     -20.472  43.872  -9.443  1.00 35.51           C
ATOM    420  CG2 ILE    24     -20.408  46.213  -7.489  1.00 34.25           C
ATOM    424  C   ILE    24     -22.790  43.706  -5.793  1.00 28.62           C
ATOM    425  O   ILE    24     -23.850  43.801  -6.384  1.00 26.67           O
ATOM    427  N   ASP    25     -22.498  42.646  -5.046  1.00 25.41           N
ATOM    428  CA  ASP    25     -23.433  41.566  -4.884  1.00 26.94           C
ATOM    430  CB  ASP    25     -22.726  40.350  -4.319  1.00 26.56           C
ATOM    433  CG  ASP    25     -23.578  39.107  -4.362  1.00 23.90           C
ATOM    434  OD1 ASP    25     -24.730  39.106  -3.846  1.00 26.48           O
ATOM    435  OD2 ASP    25     -23.072  38.101  -4.865  1.00 25.65           O
ATOM    436  C   ASP    25     -24.552  42.053  -3.944  1.00 28.65           C
ATOM    437  O   ASP    25     -24.284  42.520  -2.852  1.00 22.14           O
ATOM    439  N   LYS    26     -25.805  41.969  -4.394  1.00 30.84           N
ATOM    440  CA  LYS    26     -26.972  42.460  -3.624  1.00 30.71           C
ATOM    442  CB  LYS    26     -28.269  42.264  -4.436  1.00 33.89           C
ATOM    445  CG  LYS    26     -28.511  43.357  -5.458  1.00 44.49           C
ATOM    451  C   LYS    26     -27.110  41.822  -2.229  1.00 20.07           C
ATOM    452  O   LYS    26     -27.539  42.461  -1.284  1.00 26.43           O
ATOM    454  N   ARG    27     -26.680  40.589  -2.087  1.00 21.15           N
ATOM    455  CA  ARG    27     -26.707  39.913  -0.798  1.00 22.60           C
ATOM    457  CB  ARG    27     -26.242  38.480  -0.963  1.00 25.57           C
ATOM    460  CG  ARG    27     -27.146  37.636  -1.841  1.00 27.66           C
ATOM    463  CD  ARG    27     -26.556  36.286  -2.013  1.00 23.29           C
ATOM    466  NE  ARG    27     -25.338  36.340  -2.817  1.00 26.58           N
ATOM    468  CZ  ARG    27     -24.476  35.332  -2.941  1.00 23.01           C
ATOM    469  NH1 ARG    27     -24.685  34.189  -2.338  1.00 28.51           N
ATOM    472  NH2 ARG    27     -23.403  35.463  -3.696  1.00 28.09           N
ATOM    475  C   ARG    27     -25.817  40.557   0.265  1.00 24.98           C
ATOM    476  O   ARG    27     -26.053  40.397   1.473  1.00 25.35           O
ATOM    478  N   PHE    28     -24.801  41.282  -0.186  1.00 21.49           N
ATOM    479  CA  PHE    28     -23.726  41.741   0.688  1.00 23.72           C
ATOM    481  CB  PHE    28     -22.367  41.350   0.071  1.00 18.92           C
ATOM    484  CG  PHE    28     -22.222  39.873  -0.238  1.00 22.49           C
ATOM    485  CD1 PHE    28     -22.890  38.896   0.509  1.00 18.05           C
ATOM    487  CE1 PHE    28     -22.755  37.560   0.217  1.00 23.57           C
ATOM    489  CZ  PHE    28     -21.918  37.162  -0.818  1.00 19.66           C
ATOM    491  CE2 PHE    28     -21.237  38.120  -1.551  1.00 19.19           C
ATOM    493  CD2 PHE    28     -21.387  39.456  -1.252  1.00 20.61           C
ATOM    495  C   PHE    28     -23.809  43.225   0.963  1.00 20.64           C
ATOM    496  O   PHE    28     -22.922  43.802   1.621  1.00 21.40           O
ATOM    498  N   ARG    29     -24.903  43.860   0.528  1.00 25.62           N
ATOM    499  CA  ARG    29     -25.106  45.308   0.727  1.00 25.06           C
ATOM    501  CB  ARG    29     -26.492  45.749   0.199  1.00 28.09           C
ATOM    504  CG  ARG    29     -26.750  47.252   0.234  1.00 35.00           C
ATOM    507  CD  ARG    29     -28.236  47.617   0.028  1.00 56.20           C
ATOM    510  NE  ARG    29     -29.158  46.670   0.671  1.00 80.68           N
ATOM    512  CZ  ARG    29     -29.425  46.591   1.982  1.00 79.44           C
ATOM    513  NH1 ARG    29     -28.846  47.409   2.863  1.00 66.15           N
ATOM    516  NH2 ARG    29     -30.277  45.662   2.420  1.00 79.04           N
ATOM    519  C   ARG    29     -24.931  45.753   2.180  1.00 20.06           C
ATOM    520  O   ARG    29     -24.355  46.816   2.424  1.00 26.41           O
ATOM    522  N   VAL    30     -25.391  44.932   3.117  1.00 27.21           N
ATOM    523  CA  VAL    30     -25.289  45.215   4.553  1.00 33.63           C
ATOM    525  CB  VAL    30     -26.019  44.115   5.436  1.00 38.16           C
ATOM    527  CG1 VAL    30     -25.513  42.687   5.162  1.00 30.77           C
ATOM    531  CG2 VAL    30     -25.887  44.414   6.918  1.00 51.45           C
ATOM    535  C   VAL    30     -23.825  45.365   5.002  1.00 33.95           C
ATOM    536  O   VAL    30     -23.536  46.052   5.976  1.00 28.60           O
ATOM    538  N   PHE    31     -22.908  44.747   4.262  1.00 27.31           N
ATOM    539  CA  PHE    31     -21.483  44.731   4.632  1.00 23.37           C
ATOM    541  CB  PHE    31     -20.917  43.326   4.423  1.00 24.67           C
ATOM    544  CG  PHE    31     -21.743  42.236   5.027  1.00 23.53           C
ATOM    545  CD1 PHE    31     -21.987  42.193   6.401  1.00 24.92           C
ATOM    547  CE1 PHE    31     -22.759  41.189   6.950  1.00 34.33           C
ATOM    549  CZ  PHE    31     -23.268  40.181   6.142  1.00 26.48           C
ATOM    551  CE2 PHE    31     -23.027  40.198   4.778  1.00 23.80           C
ATOM    553  CD2 PHE    31     -22.274  41.225   4.222  1.00 23.54           C
ATOM    555  C   PHE    31     -20.667  45.756   3.856  1.00 25.64           C
ATOM    556  O   PHE    31     -19.440  45.777   3.960  1.00 24.17           O
ATOM    558  N   THR    32     -21.344  46.619   3.093  1.00 24.94           N
ATOM    559  CA  THR    32     -20.680  47.593   2.255  1.00 23.72           C
ATOM    561  CB  THR    32     -21.469  47.932   0.964  1.00 31.83           C
ATOM    563  OG1 THR    32     -22.742  48.526   1.288  1.00 32.27           O
ATOM    565  CG2 THR    32     -21.633  46.678   0.069  1.00 22.27           C
ATOM    569  C   THR    32     -20.378  48.901   3.005  1.00 29.48           C
ATOM    570  O   THR    32     -19.567  49.691   2.546  1.00 30.50           O
ATOM    572  N   LYS    33     -21.018  49.116   4.153  1.00 29.86           N
ATOM    573  CA  LYS    33     -20.827  50.362   4.910  1.00 35.76           C
ATOM    575  CB  LYS    33     -22.004  51.342   4.691  1.00 36.32           C
ATOM    578  CG  LYS    33     -22.005  52.062   3.342  1.00 51.13           C
ATOM    581  CD  LYS    33     -23.340  52.779   3.070  1.00 45.23           C
ATOM    586  C   LYS    33     -20.703  50.066   6.387  1.00 30.75           C
ATOM    587  O   LYS    33     -21.211  49.038   6.877  1.00 34.04           O
ATOM    589  N   PRO    34     -20.022  50.975   7.124  1.00 40.34           N
ATOM    590  CA  PRO    34     -20.024  50.887   8.573  1.00 43.78           C
ATOM    592  CB  PRO    34     -19.289  52.160   9.007  1.00 44.37           C
ATOM    595  CG  PRO    34     -18.458  52.547   7.868  1.00 40.69           C
ATOM    598  CD  PRO    34     -19.251  52.142   6.652  1.00 39.52           C
ATOM    601  C   PRO    34     -21.445  50.906   9.117  1.00 46.49           C
ATOM    602  O   PRO    34     -22.348  51.411   8.462  1.00 46.86           O
ATOM    603  N   VAL    35     -21.629  50.357  10.306  1.00 52.73           N
ATOM    604  CA  VAL    35     -22.905  50.435  11.002  1.00 56.02           C
ATOM    606  CB  VAL    35     -22.963  49.408  12.141  1.00 52.91           C
ATOM    608  CG1 VAL    35     -22.966  47.996  11.569  1.00 47.77           C
ATOM    612  CG2 VAL    35     -24.191  49.658  13.016  1.00 45.00           C
ATOM    616  C   VAL    35     -23.139  51.853  11.562  1.00 63.10           C
ATOM    617  O   VAL    35     -22.258  52.435  12.205  1.00 67.79           O
ATOM    619  N   ASP    36     -24.333  52.394  11.320  1.00 66.89           N
ATOM    620  CA  ASP    36     -24.676  53.763  11.725  1.00 68.61           C
ATOM    622  CB  ASP    36     -25.929  54.218  10.964  1.00 70.39           C
ATOM    625  CG  ASP    36     -26.175  55.714  11.064  1.00 77.61           C
ATOM    626  OD1 ASP    36     -25.201  56.485  11.219  1.00 70.69           O
ATOM    627  OD2 ASP    36     -27.355  56.117  10.971  1.00 90.64           O
ATOM    628  C   ASP    36     -24.898  53.861  13.254  1.00 67.11           C
ATOM    629  O   ASP    36     -25.795  53.199  13.800  1.00 56.69           O
ATOM    631  N   PRO    37     -24.081  54.685  13.951  1.00 70.78           N
ATOM    632  CA  PRO    37     -24.197  54.744  15.420  1.00 75.96           C
ATOM    634  CB  PRO    37     -23.059  55.691  15.834  1.00 75.72           C
ATOM    637  CG  PRO    37     -22.765  56.499  14.625  1.00 71.83           C
ATOM    640  CD  PRO    37     -23.059  55.621  13.443  1.00 67.24           C
ATOM    643  C   PRO    37     -25.552  55.273  15.901  1.00 80.35           C
ATOM    644  O   PRO    37     -25.932  55.035  17.050  1.00 83.21           O
ATOM    645  N   ASP    38     -26.266  55.976  15.023  1.00 83.08           N
ATOM    646  CA  ASP    38     -27.612  56.454  15.320  1.00 85.90           C
ATOM    648  CB  ASP    38     -28.032  57.549  14.332  1.00 86.22           C
ATOM    651  CG  ASP    38     -26.946  58.600  14.122  1.00 91.26           C
ATOM    652  OD1 ASP    38     -26.291  59.000  15.112  1.00 80.39           O
ATOM    653  OD2 ASP    38     -26.747  59.019  12.960  1.00 95.27           O
ATOM    654  C   ASP    38     -28.582  55.275  15.258  1.00 86.84           C
ATOM    655  O   ASP    38     -29.307  55.008  16.220  1.00 87.15           O
ATOM    657  N   GLU    39     -28.574  54.568  14.127  1.00 85.88           N
ATOM    658  CA  GLU    39     -29.421  53.389  13.941  1.00 84.58           C
ATOM    660  CB  GLU    39     -29.302  52.861  12.505  1.00 83.92           C
ATOM    667  C   GLU    39     -29.085  52.284  14.956  1.00 84.18           C
ATOM    668  O   GLU    39     -29.990  51.719  15.580  1.00 83.93           O
ATOM    670  N   VAL    40     -27.791  51.994  15.127  1.00 82.97           N
ATOM    671  CA  VAL    40     -27.326  50.952  16.059  1.00 79.76           C
ATOM    673  CB  VAL    40     -26.710  49.752  15.311  1.00 77.63           C
ATOM    675  CG1 VAL    40     -26.842  48.498  16.145  1.00 78.57           C
ATOM    679  CG2 VAL    40     -27.387  49.554  13.963  1.00 78.81           C
ATOM    683  C   VAL    40     -26.291  51.535  17.035  1.00 78.94           C
ATOM    684  O   VAL    40     -25.088  51.526  16.748  1.00 74.58           O
ATOM    686  N   PRO    41     -26.760  52.045  18.194  1.00 78.72           N
ATOM    687  CA  PRO    41     -25.885  52.767  19.130  1.00 75.46           C
ATOM    689  CB  PRO    41     -26.876  53.520  20.018  1.00 76.25           C
ATOM    692  CG  PRO    41     -28.089  52.638  20.045  1.00 80.48           C
ATOM    695  CD  PRO    41     -28.127  51.890  18.730  1.00 78.09           C
ATOM    698  C   PRO    41     -24.988  51.852  19.962  1.00 69.89           C
ATOM    699  O   PRO    41     -23.862  52.235  20.284  1.00 71.29           O
ATOM    700  N   ASP    42     -25.477  50.655  20.285  1.00 64.93           N
ATOM    701  CA  ASP    42     -24.691  49.667  21.019  1.00 63.01           C
ATOM    703  CB  ASP    42     -25.616  48.712  21.801  1.00 65.05           C
ATOM    706  CG  ASP    42     -26.381  47.740  20.897  1.00 71.38           C
ATOM    707  OD1 ASP    42     -26.382  46.515  21.186  1.00 60.91           O
ATOM    708  OD2 ASP    42     -26.976  48.203  19.898  1.00 69.09           O
ATOM    709  C   ASP    42     -23.718  48.855  20.136  1.00 59.52           C
ATOM    710  O   ASP    42     -23.081  47.928  20.638  1.00 59.30           O
ATOM    712  N   TYR    43     -23.594  49.186  18.846  1.00 56.70           N
ATOM    713  CA  TYR    43     -22.720  48.402  17.952  1.00 54.71           C
ATOM    715  CB  TYR    43     -22.915  48.743  16.459  1.00 55.68           C
ATOM    718  CG  TYR    43     -22.255  47.707  15.545  1.00 45.79           C
ATOM    719  CD1 TYR    43     -22.908  46.519  15.245  1.00 50.75           C
ATOM    721  CE1 TYR    43     -22.322  45.546  14.436  1.00 42.58           C
ATOM    723  CZ  TYR    43     -21.059  45.744  13.920  1.00 34.68           C
ATOM    724  OH  TYR    43     -20.527  44.734  13.135  1.00 39.12           O
ATOM    726  CE2 TYR    43     -20.356  46.913  14.209  1.00 37.57           C
ATOM    728  CD2 TYR    43     -20.960  47.892  15.032  1.00 43.68           C
ATOM    730  C   TYR    43     -21.254  48.600  18.320  1.00 54.18           C
ATOM    731  O   TYR    43     -20.523  47.623  18.531  1.00 48.20           O
ATOM    733  N   VAL    44     -20.847  49.871  18.391  1.00 52.45           N
ATOM    734  CA  VAL    44     -19.454  50.239  18.637  1.00 55.94           C
ATOM    736  CB  VAL    44     -19.192  51.763  18.333  1.00 58.13           C
ATOM    738  CG1 VAL    44     -18.220  52.399  19.327  1.00 58.75           C
ATOM    742  CG2 VAL    44     -18.684  51.920  16.908  1.00 47.76           C
ATOM    746  C   VAL    44     -18.945  49.796  20.025  1.00 50.89           C
ATOM    747  O   VAL    44     -17.731  49.688  20.217  1.00 47.72           O
ATOM    749  N   THR    45     -19.866  49.487  20.947  1.00 49.61           N
ATOM    750  CA  THR    45     -19.520  48.909  22.259  1.00 48.11           C
ATOM    752  CB  THR    45     -20.445  49.461  23.395  1.00 52.57           C
ATOM    754  OG1 THR    45     -21.668  48.713  23.469  1.00 60.63           O
ATOM    756  CG2 THR    45     -20.767  50.929  23.165  1.00 43.51           C
ATOM    760  C   THR    45     -19.511  47.359  22.271  1.00 46.13           C
ATOM    761  O   THR    45     -18.704  46.746  22.995  1.00 44.43           O
ATOM    763  N   VAL    46     -20.385  46.723  21.480  1.00 42.70           N
ATOM    764  CA  VAL    46     -20.404  45.243  21.371  1.00 40.23           C
ATOM    766  CB  VAL    46     -21.778  44.712  20.870  1.00 44.94           C
ATOM    768  CG1 VAL    46     -21.747  43.180  20.691  1.00 46.94           C
ATOM    772  CG2 VAL    46     -22.893  45.133  21.829  1.00 44.05           C
ATOM    776  C   VAL    46     -19.287  44.702  20.453  1.00 36.60           C
ATOM    777  O   VAL    46     -18.654  43.673  20.744  1.00 38.38           O
ATOM    779  N   ILE    47     -19.065  45.396  19.341  1.00 30.45           N
ATOM    780  CA  ILE    47     -18.111  44.965  18.328  1.00 32.39           C
ATOM    782  CB  ILE    47     -18.734  44.983  16.890  1.00 35.54           C
ATOM    784  CG1 ILE    47     -19.956  44.028  16.779  1.00 27.28           C
ATOM    787  CD1 ILE    47     -19.707  42.525  17.097  1.00 23.48           C
ATOM    791  CG2 ILE    47     -17.682  44.619  15.842  1.00 25.81           C
ATOM    795  C   ILE    47     -16.864  45.865  18.401  1.00 33.66           C
ATOM    796  O   ILE    47     -16.883  47.050  18.031  1.00 36.10           O
ATOM    798  N   LYS    48     -15.798  45.270  18.901  1.00 33.32           N
ATOM    799  CA  LYS    48     -14.550  45.963  19.207  1.00 31.72           C
ATOM    801  CB  LYS    48     -13.689  45.068  20.118  1.00 31.65           C
ATOM    804  CG  LYS    48     -14.387  44.729  21.453  1.00 39.44           C
ATOM    807  CD  LYS    48     -14.892  46.002  22.158  1.00 43.13           C
ATOM    810  CE  LYS    48     -15.676  45.714  23.404  1.00 47.78           C
ATOM    813  NZ  LYS    48     -16.182  47.011  23.956  1.00 44.33           N
ATOM    817  C   LYS    48     -13.751  46.353  17.977  1.00 33.20           C
ATOM    818  O   LYS    48     -13.014  47.339  18.022  1.00 27.97           O
ATOM    820  N   GLN    49     -13.914  45.583  16.895  1.00 30.48           N
ATOM    821  CA  GLN    49     -13.217  45.843  15.662  1.00 32.30           C
ATOM    823  CB  GLN    49     -12.049  44.864  15.505  1.00 29.28           C
ATOM    826  CG  GLN    49     -11.013  45.463  14.632  1.00 39.19           C
ATOM    829  CD  GLN    49      -9.769  44.633  14.478  1.00 36.19           C
ATOM    830  OE1 GLN    49      -8.860  45.072  13.783  1.00 40.56           O
ATOM    831  NE2 GLN    49      -9.711  43.427  15.107  1.00 33.13           N
ATOM    834  C   GLN    49     -14.181  45.755  14.477  1.00 28.07           C
ATOM    835  O   GLN    49     -14.234  44.724  13.793  1.00 28.15           O
ATOM    837  N   PRO    50     -14.949  46.835  14.245  1.00 29.22           N
ATOM    838  CA  PRO    50     -15.875  46.936  13.125  1.00 27.66           C
ATOM    840  CB  PRO    50     -16.369  48.378  13.211  1.00 30.49           C
ATOM    843  CG  PRO    50     -16.195  48.758  14.591  1.00 36.52           C
ATOM    846  CD  PRO    50     -15.042  48.013  15.122  1.00 26.98           C
ATOM    849  C   PRO    50     -15.126  46.763  11.815  1.00 31.26           C
ATOM    850  O   PRO    50     -14.027  47.278  11.679  1.00 23.71           O
ATOM    851  N   MET    51     -15.696  46.044  10.861  1.00 21.15           N
ATOM    852  CA  MET    51     -15.055  45.935   9.533  1.00 22.60           C
ATOM    854  CB  MET    51     -14.158  44.700   9.485  1.00 21.22           C
ATOM    857  CG  MET    51     -13.218  44.584   8.232  1.00 20.96           C
ATOM    860  SD  MET    51     -12.243  46.051   7.847  1.00 26.36           S
ATOM    861  CE  MET    51     -11.246  46.176   9.359  1.00 22.19           C
ATOM    865  C   MET    51     -16.166  45.867   8.493  1.00 23.15           C
ATOM    866  O   MET    51     -17.221  45.344   8.772  1.00 23.61           O
ATOM    868  N   ASP    52     -15.924  46.436   7.328  1.00 24.76           N
ATOM    869  CA  ASP    52     -16.879  46.392   6.231  1.00 27.19           C
ATOM    871  CB  ASP    52     -17.922  47.511   6.360  1.00 26.13           C
ATOM    874  CG  ASP    52     -17.330  48.890   6.169  1.00 29.38           C
ATOM    875  OD1 ASP    52     -16.775  49.471   7.125  1.00 45.75           O
ATOM    876  OD2 ASP    52     -17.407  49.400   5.059  1.00 31.49           O
ATOM    877  C   ASP    52     -16.084  46.513   4.949  1.00 24.29           C
ATOM    878  O   ASP    52     -14.881  46.799   4.992  1.00 20.17           O
ATOM    880  N   LEU    53     -16.745  46.316   3.812  1.00 19.93           N
ATOM    881  CA  LEU    53     -16.042  46.295   2.513  1.00 22.93           C
ATOM    883  CB  LEU    53     -16.947  45.717   1.416  1.00 23.99           C
ATOM    886  CG  LEU    53     -17.426  44.279   1.629  1.00 25.34           C
ATOM    888  CD1 LEU    53     -18.492  43.886   0.568  1.00 17.36           C
ATOM    892  CD2 LEU    53     -16.274  43.274   1.667  1.00 17.56           C
ATOM    896  C   LEU    53     -15.496  47.665   2.091  1.00 25.54           C
ATOM    897  O   LEU    53     -14.483  47.745   1.360  1.00 19.91           O
ATOM    899  N   SER    54     -16.118  48.753   2.553  1.00 28.29           N
ATOM    900  CA  SER    54     -15.543  50.087   2.272  1.00 25.79           C
ATOM    902  CB  SER    54     -16.504  51.211   2.684  0.50 23.77           C
ATOM    908  OG  SER    54     -16.659  51.265   4.097  0.50 28.65           O
ATOM    912  C   SER    54     -14.227  50.281   3.014  1.00 20.81           C
ATOM    913  O   SER    54     -13.287  50.890   2.484  1.00 25.29           O
ATOM    915  N   SER    55     -14.176  49.791   4.241  1.00 23.85           N
ATOM    916  CA  SER    55     -12.940  49.887   5.038  1.00 28.64           C
ATOM    918  CB  SER    55     -13.218  49.548   6.498  1.00 26.98           C
ATOM    921  OG  SER    55     -14.248  50.389   7.006  1.00 35.24           O
ATOM    923  C   SER    55     -11.851  48.986   4.446  1.00 24.61           C
ATOM    924  O   SER    55     -10.673  49.347   4.432  1.00 22.37           O
ATOM    926  N   VAL    56     -12.257  47.833   3.912  1.00 22.80           N
ATOM    927  CA  VAL    56     -11.319  46.945   3.189  1.00 18.59           C
ATOM    929  CB  VAL    56     -11.984  45.581   2.798  1.00 17.04           C
ATOM    931  CG1 VAL    56     -11.131  44.796   1.802  1.00 18.98           C
ATOM    935  CG2 VAL    56     -12.279  44.718   4.064  1.00 19.48           C
ATOM    939  C   VAL    56     -10.697  47.650   1.997  1.00 17.03           C
ATOM    940  O   VAL    56      -9.478  47.572   1.825  1.00 19.42           O
ATOM    942  N   ILE    57     -11.496  48.352   1.177  1.00 17.41           N
ATOM    943  CA  ILE    57     -10.955  49.092   0.032  1.00 20.50           C
ATOM    945  CB  ILE    57     -12.062  49.736  -0.876  1.00 23.10           C
ATOM    947  CG1 ILE    57     -12.835  48.672  -1.676  1.00 22.23           C
ATOM    950  CD1 ILE    57     -12.019  48.001  -2.756  1.00 28.19           C
ATOM    954  CG2 ILE    57     -11.454  50.774  -1.819  1.00 25.28           C
ATOM    958  C   ILE    57      -9.960  50.162   0.503  1.00 19.54           C
ATOM    959  O   ILE    57      -8.878  50.288  -0.056  1.00 17.87           O
ATOM    961  N   SER    58     -10.317  50.912   1.539  1.00 23.61           N
ATOM    962  CA  SER    58      -9.392  51.897   2.129  1.00 21.37           C
ATOM    964  CB  SER    58     -10.054  52.624   3.304  1.00 26.17           C
ATOM    967  OG  SER    58     -11.054  53.483   2.846  1.00 29.50           O
ATOM    969  C   SER    58      -8.045  51.272   2.584  1.00 18.72           C
ATOM    970  O   SER    58      -6.973  51.822   2.297  1.00 21.54           O
ATOM    972  N   LYS    59      -8.108  50.123   3.249  1.00 20.54           N
ATOM    973  CA  LYS    59      -6.924  49.433   3.712  1.00 16.63           C
ATOM    975  CB  LYS    59      -7.293  48.329   4.700  1.00 17.74           C
ATOM    978  CG  LYS    59      -7.723  48.901   6.077  1.00 21.37           C
ATOM    981  CD  LYS    59      -8.114  47.798   7.067  1.00 19.34           C
ATOM    984  CE  LYS    59      -6.893  47.119   7.670  1.00 20.09           C
ATOM    987  NZ  LYS    59      -7.200  46.047   8.619  1.00 19.43           N
ATOM    991  C   LYS    59      -6.034  48.918   2.559  1.00 15.54           C
ATOM    992  O   LYS    59      -4.816  48.973   2.659  1.00 16.76           O
ATOM    994  N   ILE    60      -6.643  48.453   1.467  1.00 17.14           N
ATOM    995  CA  ILE    60      -5.871  48.056   0.280  1.00 17.12           C
ATOM    997  CB  ILE    60      -6.783  47.630  -0.911  1.00 18.90           C
ATOM    999  CG1 ILE    60      -7.619  46.371  -0.546  1.00 20.67           C
ATOM   1002  CD1 ILE    60      -8.756  46.014  -1.549  1.00 16.51           C
ATOM   1006  CG2 ILE    60      -5.914  47.410  -2.191  1.00 15.27           C
ATOM   1010  C   ILE    60      -4.983  49.238  -0.173  1.00 16.88           C
ATOM   1011  O   ILE    60      -3.762  49.112  -0.345  1.00 18.43           O
ATOM   1013  N   ASP    61      -5.640  50.373  -0.349  1.00 18.18           N
ATOM   1014  CA  ASP    61      -5.022  51.581  -0.838  1.00 21.27           C
ATOM   1016  CB  ASP    61      -6.111  52.614  -1.131  1.00 20.70           C
ATOM   1019  CG  ASP    61      -6.998  52.220  -2.305  1.00 32.84           C
ATOM   1020  OD1 ASP    61      -6.667  51.259  -3.026  1.00 27.00           O
ATOM   1021  OD2 ASP    61      -8.033  52.884  -2.509  1.00 25.46           O
ATOM   1022  C   ASP    61      -3.976  52.136   0.138  1.00 24.20           C
ATOM   1023  O   ASP    61      -2.950  52.691  -0.290  1.00 21.34           O
ATOM   1025  N   LEU    62      -4.190  51.924   1.436  1.00 22.90           N
ATOM   1026  CA  LEU    62      -3.176  52.248   2.457  1.00 23.80           C
ATOM   1028  CB  LEU    62      -3.850  52.442   3.827  1.00 18.19           C
ATOM   1031  CG  LEU    62      -4.757  53.639   4.064  1.00 23.24           C
ATOM   1033  CD1 LEU    62      -5.442  53.427   5.439  1.00 20.00           C
ATOM   1037  CD2 LEU    62      -3.927  54.941   4.004  1.00 20.71           C
ATOM   1041  C   LEU    62      -2.071  51.194   2.585  1.00 24.78           C
ATOM   1042  O   LEU    62      -1.231  51.288   3.456  1.00 23.89           O
ATOM   1044  N   HIS    63      -2.050  50.185   1.712  1.00 21.03           N
ATOM   1045  CA  HIS    63      -1.018  49.156   1.698  1.00 18.83           C
ATOM   1047  CB  HIS    63       0.395  49.728   1.399  1.00 22.34           C
ATOM   1050  CG  HIS    63       0.488  50.497   0.129  1.00 22.10           C
ATOM   1051  ND1 HIS    63       1.698  50.841  -0.426  1.00 25.42           N
ATOM   1053  CE1 HIS    63       1.486  51.534  -1.530  1.00 20.87           C
ATOM   1055  NE2 HIS    63       0.184  51.589  -1.748  1.00 27.01           N
ATOM   1057  CD2 HIS    63      -0.462  50.954  -0.722  1.00 27.64           C
ATOM   1059  C   HIS    63      -0.971  48.336   2.982  1.00 21.67           C
ATOM   1060  O   HIS    63       0.070  47.885   3.388  1.00 22.07           O
ATOM   1062  N   LYS    64      -2.122  48.098   3.586  1.00 22.14           N
ATOM   1063  CA  LYS    64      -2.188  47.316   4.796  1.00 21.91           C
ATOM   1065  CB  LYS    64      -3.440  47.663   5.583  1.00 19.04           C
ATOM   1068  CG  LYS    64      -3.536  49.112   5.934  1.00 24.59           C
ATOM   1071  CD  LYS    64      -2.562  49.504   6.961  1.00 30.67           C
ATOM   1074  CE  LYS    64      -2.888  50.916   7.485  1.00 48.26           C
ATOM   1077  NZ  LYS    64      -2.018  51.276   8.627  1.00 47.20           N
ATOM   1081  C   LYS    64      -2.194  45.831   4.565  1.00 23.75           C
ATOM   1082  O   LYS    64      -1.981  45.077   5.507  1.00 18.75           O
ATOM   1084  N   TYR    65      -2.463  45.407   3.337  1.00 21.37           N
ATOM   1085  CA  TYR    65      -2.490  43.990   3.044  1.00 17.52           C
ATOM   1087  CB  TYR    65      -3.788  43.577   2.327  1.00 15.32           C
ATOM   1090  CG  TYR    65      -5.083  43.992   3.050  1.00 16.36           C
ATOM   1091  CD1 TYR    65      -5.359  43.565   4.331  1.00 19.84           C
ATOM   1093  CE1 TYR    65      -6.552  43.924   4.968  1.00 19.40           C
ATOM   1095  CZ  TYR    65      -7.501  44.701   4.296  1.00 15.48           C
ATOM   1096  OH  TYR    65      -8.679  45.058   4.902  1.00 18.10           O
ATOM   1098  CE2 TYR    65      -7.266  45.119   3.033  1.00 17.29           C
ATOM   1100  CD2 TYR    65      -6.057  44.751   2.395  1.00 16.43           C
ATOM   1102  C   TYR    65      -1.301  43.672   2.162  1.00 21.48           C
ATOM   1103  O   TYR    65      -1.258  44.066   1.007  1.00 22.79           O
ATOM   1105  N   LEU    66      -0.346  42.935   2.713  1.00 19.79           N
ATOM   1106  CA  LEU    66       0.847  42.523   1.958  1.00 23.12           C
ATOM   1108  CB  LEU    66       2.089  42.712   2.836  1.00 25.01           C
ATOM   1111  CG  LEU    66       2.439  44.137   3.294  1.00 32.61           C
ATOM   1113  CD1 LEU    66       3.862  44.119   3.908  1.00 37.41           C
ATOM   1117  CD2 LEU    66       2.368  45.115   2.195  1.00 30.09           C
ATOM   1121  C   LEU    66       0.743  41.062   1.481  1.00 22.04           C
ATOM   1122  O   LEU    66       1.557  40.601   0.688  1.00 21.03           O
ATOM   1124  N   THR    67      -0.256  40.344   1.990  1.00 20.44           N
ATOM   1125  CA  THR    67      -0.543  38.972   1.589  1.00 19.04           C
ATOM   1127  CB  THR    67       0.039  37.928   2.563  1.00 18.54           C
ATOM   1129  OG1 THR    67      -0.742  37.899   3.757  1.00 21.70           O
ATOM   1131  CG2 THR    67       1.506  38.214   2.937  1.00 20.92           C
ATOM   1135  C   THR    67      -2.077  38.771   1.534  1.00 20.22           C
ATOM   1136  O   THR    67      -2.848  39.552   2.115  1.00 18.31           O
ATOM   1138  N   VAL    68      -2.518  37.724   0.835  1.00 16.57           N
ATOM   1139  CA  VAL    68      -3.937  37.398   0.800  1.00 19.83           C
ATOM   1141  CB  VAL    68      -4.303  36.338  -0.283  1.00 19.37           C
ATOM   1143  CG1 VAL    68      -5.768  36.553  -0.786  1.00 24.52           C
ATOM   1147  CG2 VAL    68      -4.149  34.918   0.242  1.00 25.02           C
ATOM   1151  C   VAL    68      -4.424  36.961   2.180  1.00 22.55           C
ATOM   1152  O   VAL    68      -5.586  37.163   2.527  1.00 18.78           O
ATOM   1154  N   LYS    69      -3.550  36.353   2.984  1.00 22.17           N
ATOM   1155  CA  LYS    69      -3.917  36.039   4.372  1.00 26.13           C
ATOM   1157  CB  LYS    69      -2.773  35.296   5.084  1.00 33.70           C
ATOM   1160  CG  LYS    69      -2.648  33.854   4.646  1.00 34.43           C
ATOM   1163  CD  LYS    69      -1.703  33.079   5.573  1.00 45.50           C
ATOM   1168  C   LYS    69      -4.365  37.232   5.216  1.00 21.88           C
ATOM   1169  O   LYS    69      -5.357  37.131   5.952  1.00 23.88           O
ATOM   1171  N   ASP    70      -3.647  38.346   5.089  1.00 19.84           N
ATOM   1172  CA  ASP    70      -3.959  39.615   5.762  1.00 24.88           C
ATOM   1174  CB  ASP    70      -2.992  40.738   5.326  1.00 26.51           C
ATOM   1177  CG  ASP    70      -1.541  40.593   5.828  1.00 34.56           C
ATOM   1178  OD1 ASP    70      -1.244  39.787   6.721  1.00 27.92           O
ATOM   1179  OD2 ASP    70      -0.694  41.379   5.313  1.00 34.87           O
ATOM   1180  C   ASP    70      -5.381  40.087   5.352  1.00 27.16           C
ATOM   1181  O   ASP    70      -6.205  40.493   6.187  1.00 20.43           O
ATOM   1183  N   TYR    71      -5.625  40.070   4.045  1.00 23.04           N
ATOM   1184  CA  TYR    71      -6.940  40.435   3.471  1.00 17.48           C
ATOM   1186  CB  TYR    71      -6.849  40.328   1.955  1.00 19.62           C
ATOM   1189  CG  TYR    71      -8.147  40.516   1.226  1.00 15.66           C
ATOM   1190  CD1 TYR    71      -8.624  41.803   0.949  1.00 15.77           C
ATOM   1192  CE1 TYR    71      -9.795  41.991   0.265  1.00 17.42           C
ATOM   1194  CZ  TYR    71     -10.536  40.878  -0.163  1.00 18.81           C
ATOM   1195  OH  TYR    71     -11.681  41.085  -0.870  1.00 16.07           O
ATOM   1197  CE2 TYR    71     -10.079  39.593   0.061  1.00 15.40           C
ATOM   1199  CD2 TYR    71      -8.886  39.406   0.764  1.00 17.77           C
ATOM   1201  C   TYR    71      -8.074  39.536   3.979  1.00 17.40           C
ATOM   1202  O   TYR    71      -9.115  40.032   4.445  1.00 18.24           O
ATOM   1204  N   LEU    72      -7.871  38.226   3.892  1.00 18.72           N
ATOM   1205  CA  LEU    72      -8.874  37.252   4.349  1.00 21.15           C
ATOM   1207  CB  LEU    72      -8.512  35.826   3.932  1.00 16.77           C
ATOM   1210  CG  LEU    72      -8.718  35.566   2.443  1.00 25.64           C
ATOM   1212  CD1 LEU    72      -8.040  34.297   2.112  1.00 19.37           C
ATOM   1216  CD2 LEU    72     -10.215  35.535   2.012  1.00 25.53           C
ATOM   1220  C   LEU    72      -9.182  37.340   5.843  1.00 26.45           C
ATOM   1221  O   LEU    72     -10.302  37.066   6.250  1.00 23.04           O
ATOM   1223  N   ARG    73      -8.219  37.790   6.636  1.00 22.93           N
ATOM   1224  CA  ARG    73      -8.434  38.055   8.047  1.00 28.03           C
ATOM   1226  CB  ARG    73      -7.122  38.490   8.726  1.00 31.55           C
ATOM   1229  CG  ARG    73      -7.105  38.285  10.212  1.00 38.49           C
ATOM   1232  CD  ARG    73      -5.699  38.518  10.812  1.00 49.01           C
ATOM   1235  NE  ARG    73      -4.676  37.784  10.065  1.00 44.82           N
ATOM   1237  CZ  ARG    73      -3.669  38.325   9.374  1.00 55.88           C
ATOM   1238  NH1 ARG    73      -3.476  39.648   9.322  1.00 40.38           N
ATOM   1241  NH2 ARG    73      -2.831  37.518   8.726  1.00 56.97           N
ATOM   1244  C   ARG    73      -9.524  39.098   8.278  1.00 18.44           C
ATOM   1245  O   ARG    73     -10.365  38.890   9.124  1.00 19.51           O
ATOM   1247  N   ASP    74      -9.523  40.171   7.494  1.00 18.76           N
ATOM   1248  CA  ASP    74     -10.571  41.193   7.504  1.00 16.55           C
ATOM   1250  CB  ASP    74     -10.082  42.492   6.874  1.00 19.52           C
ATOM   1253  CG  ASP    74      -9.294  43.326   7.848  1.00 24.75           C
ATOM   1254  OD1 ASP    74      -9.271  42.928   9.020  1.00 20.14           O
ATOM   1255  OD2 ASP    74      -8.719  44.344   7.449  1.00 22.36           O
ATOM   1256  C   ASP    74     -11.916  40.769   6.894  1.00 21.92           C
ATOM   1257  O   ASP    74     -12.975  41.148   7.406  1.00 18.70           O
ATOM   1259  N   ILE    75     -11.886  39.980   5.830  1.00 21.18           N
ATOM   1260  CA  ILE    75     -13.126  39.305   5.348  1.00 20.67           C
ATOM   1262  CB  ILE    75     -12.861  38.455   4.056  1.00 24.95           C
ATOM   1264  CG1 ILE    75     -12.392  39.357   2.884  1.00 19.84           C
ATOM   1267  CD1 ILE    75     -13.271  40.588   2.564  1.00 17.92           C
ATOM   1271  CG2 ILE    75     -14.123  37.542   3.678  1.00 17.77           C
ATOM   1275  C   ILE    75     -13.756  38.436   6.459  1.00 20.07           C
ATOM   1276  O   ILE    75     -14.957  38.520   6.766  1.00 21.18           O
ATOM   1278  N   ASP    76     -12.930  37.612   7.072  1.00 17.12           N
ATOM   1279  CA  ASP    76     -13.336  36.803   8.192  1.00 18.83           C
ATOM   1281  CB  ASP    76     -12.186  35.905   8.657  1.00 22.83           C
ATOM   1284  CG  ASP    76     -12.043  34.652   7.827  1.00 27.23           C
ATOM   1285  OD1 ASP    76     -13.057  34.078   7.372  1.00 31.01           O
ATOM   1286  OD2 ASP    76     -10.909  34.191   7.693  1.00 27.95           O
ATOM   1287  C   ASP    76     -13.899  37.617   9.377  1.00 23.19           C
ATOM   1288  O   ASP    76     -14.831  37.168  10.037  1.00 22.31           O
ATOM   1290  N   LEU    77     -13.351  38.804   9.612  1.00 18.46           N
ATOM   1291  CA  LEU    77     -13.819  39.701  10.637  1.00 21.75           C
ATOM   1293  CB  LEU    77     -12.778  40.796  10.830  1.00 25.24           C
ATOM   1296  CG  LEU    77     -12.948  41.754  12.004  1.00 29.92           C
ATOM   1298  CD1 LEU    77     -13.038  40.979  13.351  1.00 25.12           C
ATOM   1302  CD2 LEU    77     -11.808  42.828  11.972  1.00 29.35           C
ATOM   1306  C   LEU    77     -15.234  40.301  10.317  1.00 28.76           C
ATOM   1307  O   LEU    77     -16.106  40.401  11.187  1.00 24.23           O
ATOM   1309  N   ILE    78     -15.463  40.677   9.065  1.00 25.00           N
ATOM   1310  CA  ILE    78     -16.801  41.067   8.619  1.00 24.14           C
ATOM   1312  CB  ILE    78     -16.846  41.357   7.106  1.00 22.57           C
ATOM   1314  CG1 ILE    78     -15.939  42.551   6.759  1.00 18.05           C
ATOM   1317  CD1 ILE    78     -15.865  42.959   5.251  1.00 17.41           C
ATOM   1321  CG2 ILE    78     -18.325  41.594   6.622  1.00 22.52           C
ATOM   1325  C   ILE    78     -17.788  39.956   8.967  1.00 21.73           C
ATOM   1326  O   ILE    78     -18.855  40.200   9.585  1.00 21.65           O
ATOM   1328  N   CYS    79     -17.439  38.728   8.613  1.00 20.07           N
ATOM   1329  CA  CYS    79     -18.311  37.600   8.882  1.00 23.10           C
ATOM   1331  CB  CYS    79     -17.826  36.354   8.142  1.00 20.26           C
ATOM   1334  SG  CYS    79     -18.872  34.951   8.328  1.00 27.18           S
ATOM   1336  C   CYS    79     -18.495  37.325  10.382  1.00 30.41           C
ATOM   1337  O   CYS    79     -19.635  37.266  10.875  1.00 22.37           O
ATOM   1339  N   SER    80     -17.393  37.181  11.121  1.00 21.91           N
ATOM   1340  CA  SER    80     -17.494  36.878  12.545  1.00 24.30           C
ATOM   1342  CB  SER    80     -16.095  36.547  13.140  1.00 24.35           C
ATOM   1345  OG  SER    80     -15.237  37.672  13.063  1.00 25.08           O
ATOM   1347  C   SER    80     -18.235  37.984  13.349  1.00 18.40           C
ATOM   1348  O   SER    80     -18.966  37.663  14.285  1.00 23.97           O
ATOM   1350  N   ASN    81     -18.040  39.257  13.002  1.00 20.76           N
ATOM   1351  CA  ASN    81     -18.731  40.384  13.628  1.00 23.40           C
ATOM   1353  CB  ASN    81     -18.272  41.726  13.033  1.00 18.65           C
ATOM   1356  CG  ASN    81     -16.891  42.213  13.553  1.00 23.49           C
ATOM   1357  OD1 ASN    81     -16.312  41.626  14.419  1.00 22.48           O
ATOM   1358  ND2 ASN    81     -16.394  43.279  12.976  1.00 20.38           N
ATOM   1361  C   ASN    81     -20.283  40.263  13.424  1.00 31.33           C
ATOM   1362  O   ASN    81     -21.087  40.528  14.334  1.00 26.82           O
ATOM   1364  N   ALA    82     -20.677  39.859  12.217  1.00 25.71           N
ATOM   1365  CA  ALA    82     -22.082  39.664  11.864  1.00 25.53           C
ATOM   1367  CB  ALA    82     -22.259  39.508  10.281  1.00 21.68           C
ATOM   1371  C   ALA    82     -22.675  38.493  12.648  1.00 19.47           C
ATOM   1372  O   ALA    82     -23.782  38.620  13.195  1.00 28.46           O
ATOM   1374  N   LEU    83     -21.945  37.393  12.806  1.00 22.22           N
ATOM   1375  CA  LEU    83     -22.458  36.275  13.567  1.00 23.51           C
ATOM   1377  CB  LEU    83     -21.630  34.996  13.381  1.00 25.32           C
ATOM   1380  CG  LEU    83     -21.284  34.549  11.947  1.00 34.57           C
ATOM   1382  CD1 LEU    83     -20.593  33.216  11.961  1.00 35.58           C
ATOM   1386  CD2 LEU    83     -22.467  34.549  11.013  1.00 26.17           C
ATOM   1390  C   LEU    83     -22.621  36.565  15.064  1.00 29.52           C
ATOM   1391  O   LEU    83     -23.595  36.103  15.672  1.00 26.06           O
ATOM   1393  N   GLU    84     -21.666  37.318  15.619  1.00 32.26           N
ATOM   1394  CA  GLU    84     -21.643  37.710  17.035  1.00 32.94           C
ATOM   1396  CB  GLU    84     -20.292  38.372  17.403  1.00 28.31           C
ATOM   1399  CG  GLU    84     -20.112  38.708  18.919  1.00 46.52           C
ATOM   1402  CD  GLU    84     -19.012  39.774  19.248  1.00 64.97           C
ATOM   1403  OE1 GLU    84     -19.027  40.289  20.394  1.00 62.98           O
ATOM   1404  OE2 GLU    84     -18.146  40.107  18.397  1.00 54.59           O
ATOM   1405  C   GLU    84     -22.775  38.669  17.351  1.00 24.93           C
ATOM   1406  O   GLU    84     -23.505  38.480  18.326  1.00 31.68           O
ATOM   1408  N   TYR    85     -22.917  39.687  16.517  1.00 25.04           N
ATOM   1409  CA  TYR    85     -23.859  40.737  16.750  1.00 31.73           C
ATOM   1411  CB  TYR    85     -23.552  41.964  15.894  1.00 27.37           C
ATOM   1414  CG  TYR    85     -24.285  43.193  16.424  1.00 43.81           C
ATOM   1415  CD1 TYR    85     -23.935  43.754  17.660  1.00 43.60           C
ATOM   1417  CE1 TYR    85     -24.609  44.867  18.169  1.00 51.06           C
ATOM   1419  CZ  TYR    85     -25.656  45.414  17.451  1.00 53.75           C
ATOM   1420  OH  TYR    85     -26.323  46.502  17.953  1.00 59.40           O
ATOM   1422  CE2 TYR    85     -26.032  44.869  16.232  1.00 45.06           C
ATOM   1424  CD2 TYR    85     -25.355  43.757  15.730  1.00 46.35           C
ATOM   1426  C   TYR    85     -25.312  40.326  16.468  1.00 32.29           C
ATOM   1427  O   TYR    85     -26.218  41.016  16.913  1.00 28.58           O
ATOM   1429  N   ASN    86     -25.511  39.244  15.713  1.00 32.89           N
ATOM   1430  CA  ASN    86     -26.859  38.825  15.262  1.00 31.75           C
ATOM   1432  CB  ASN    86     -27.062  39.151  13.773  1.00 32.32           C
ATOM   1435  CG  ASN    86     -26.831  40.612  13.440  1.00 31.15           C
ATOM   1436  OD1 ASN    86     -27.673  41.450  13.688  1.00 30.56           O
ATOM   1437  ND2 ASN    86     -25.687  40.919  12.835  1.00 33.47           N
ATOM   1440  C   ASN    86     -27.014  37.350  15.457  1.00 27.49           C
ATOM   1441  O   ASN    86     -27.161  36.616  14.483  1.00 31.91           O
ATOM   1443  N   PRO    87     -26.979  36.884  16.722  1.00 26.55           N
ATOM   1444  CA  PRO    87     -26.859  35.458  17.020  1.00 26.12           C
ATOM   1446  CB  PRO    87     -26.139  35.465  18.366  1.00 32.64           C
ATOM   1449  CG  PRO    87     -26.617  36.704  19.004  1.00 27.94           C
ATOM   1452  CD  PRO    87     -26.987  37.682  17.965  1.00 31.83           C
ATOM   1455  C   PRO    87     -28.190  34.720  17.191  1.00 23.77           C
ATOM   1456  O   PRO    87     -28.184  33.511  17.376  1.00 31.41           O
ATOM   1457  N   ASP    88     -29.295  35.454  17.077  1.00 29.51           N
ATOM   1458  CA  ASP    88     -30.628  34.995  17.492  1.00 30.57           C
ATOM   1460  CB  ASP    88     -31.499  36.214  17.808  1.00 33.78           C
ATOM   1463  CG  ASP    88     -31.018  36.990  19.037  1.00 44.32           C
ATOM   1464  OD1 ASP    88     -30.049  36.557  19.695  1.00 30.51           O
ATOM   1465  OD2 ASP    88     -31.618  38.042  19.343  1.00 45.37           O
ATOM   1466  C   ASP    88     -31.314  34.154  16.417  1.00 35.10           C
ATOM   1467  O   ASP    88     -30.874  34.159  15.254  1.00 27.40           O
ATOM   1469  N   ARG    89     -32.377  33.435  16.798  1.00 30.45           N
ATOM   1470  CA  ARG    89     -33.120  32.566  15.840  1.00 28.72           C
ATOM   1472  CB  ARG    89     -33.869  31.411  16.551  0.50 33.38           C
ATOM   1478  CG  ARG    89     -35.167  31.777  17.355  0.50 37.37           C
ATOM   1484  CD  ARG    89     -36.517  31.729  16.550  0.50 23.22           C
ATOM   1490  NE  ARG    89     -36.709  30.558  15.702  0.50 14.53           N
ATOM   1494  CZ  ARG    89     -37.431  30.582  14.566  0.50 21.38           C
ATOM   1496  NH1 ARG    89     -37.964  31.725  14.152  0.50 19.03           N
ATOM   1502  NH2 ARG    89     -37.589  29.485  13.816  0.50 13.40           N
ATOM   1508  C   ARG    89     -34.104  33.315  14.959  1.00 26.11           C
ATOM   1509  O   ARG    89     -34.687  32.742  14.036  1.00 29.81           O
ATOM   1511  N   ASP    90     -34.292  34.590  15.208  1.00 23.54           N
ATOM   1512  CA  ASP    90     -35.264  35.315  14.430  1.00 29.60           C
ATOM   1514  CB  ASP    90     -35.570  36.660  15.055  1.00 30.13           C
ATOM   1517  CG  ASP    90     -34.416  37.592  15.029  1.00 38.59           C
ATOM   1518  OD1 ASP    90     -34.440  38.541  14.205  1.00 51.79           O
ATOM   1519  OD2 ASP    90     -33.495  37.374  15.835  1.00 59.04           O
ATOM   1520  C   ASP    90     -34.818  35.489  12.968  1.00 31.35           C
ATOM   1521  O   ASP    90     -33.608  35.485  12.679  1.00 27.12           O
ATOM   1523  N   PRO    91     -35.796  35.658  12.057  1.00 30.02           N
ATOM   1524  CA  PRO    91     -35.509  35.719  10.624  1.00 27.31           C
ATOM   1526  CB  PRO    91     -36.888  35.982   9.996  1.00 31.62           C
ATOM   1529  CG  PRO    91     -37.870  35.529  10.995  1.00 30.59           C
ATOM   1532  CD  PRO    91     -37.249  35.720  12.332  1.00 29.64           C
ATOM   1535  C   PRO    91     -34.517  36.811  10.209  1.00 22.34           C
ATOM   1536  O   PRO    91     -33.705  36.580   9.308  1.00 20.72           O
ATOM   1537  N   GLY    92     -34.594  37.996  10.814  1.00 21.91           N
ATOM   1538  CA  GLY    92     -33.644  39.081  10.479  1.00 27.46           C
ATOM   1541  C   GLY    92     -32.189  38.688  10.774  1.00 28.37           C
ATOM   1542  O   GLY    92     -31.291  38.926   9.959  1.00 26.07           O
ATOM   1544  N   ASP    93     -31.988  38.036  11.921  1.00 29.00           N
ATOM   1545  CA  ASP    93     -30.671  37.565  12.363  1.00 28.59           C
ATOM   1547  CB  ASP    93     -30.706  37.160  13.839  1.00 27.55           C
ATOM   1550  CG  ASP    93     -30.501  38.352  14.797  1.00 29.39           C
ATOM   1551  OD1 ASP    93     -30.830  39.510  14.444  1.00 34.06           O
ATOM   1552  OD2 ASP    93     -29.975  38.111  15.906  1.00 30.80           O
ATOM   1553  C   ASP    93     -30.200  36.391  11.496  1.00 27.19           C
ATOM   1554  O   ASP    93     -29.054  36.350  11.035  1.00 22.18           O
ATOM   1556  N   ARG    94     -31.084  35.433  11.257  1.00 23.21           N
ATOM   1557  CA  ARG    94     -30.707  34.307  10.424  1.00 23.79           C
ATOM   1559  CB  ARG    94     -31.766  33.209  10.471  1.00 25.48           C
ATOM   1562  CG  ARG    94     -31.737  32.427  11.740  1.00 27.61           C
ATOM   1565  CD  ARG    94     -32.760  31.383  11.762  1.00 30.35           C
ATOM   1568  NE  ARG    94     -32.587  30.462  12.881  1.00 29.92           N
ATOM   1570  CZ  ARG    94     -33.515  29.601  13.303  1.00 44.64           C
ATOM   1571  NH1 ARG    94     -34.696  29.524  12.707  1.00 49.89           N
ATOM   1574  NH2 ARG    94     -33.253  28.800  14.329  1.00 50.28           N
ATOM   1577  C   ARG    94     -30.353  34.733   8.984  1.00 20.18           C
ATOM   1578  O   ARG    94     -29.450  34.143   8.402  1.00 24.67           O
ATOM   1580  N   LEU    95     -31.024  35.742   8.429  1.00 22.52           N
ATOM   1581  CA  LEU    95     -30.721  36.233   7.093  1.00 22.83           C
ATOM   1583  CB  LEU    95     -31.778  37.231   6.586  1.00 17.27           C
ATOM   1586  CG  LEU    95     -31.622  37.872   5.193  1.00 13.78           C
ATOM   1588  CD1 LEU    95     -31.591  36.803   4.083  1.00 17.27           C
ATOM   1592  CD2 LEU    95     -32.741  38.938   4.931  1.00 18.04           C
ATOM   1596  C   LEU    95     -29.303  36.857   7.025  1.00 27.03           C
ATOM   1597  O   LEU    95     -28.513  36.509   6.145  1.00 18.85           O
ATOM   1599  N   ILE    96     -29.003  37.775   7.935  1.00 24.56           N
ATOM   1600  CA  ILE    96     -27.664  38.412   7.975  1.00 25.27           C
ATOM   1602  CB  ILE    96     -27.557  39.557   9.048  1.00 24.78           C
ATOM   1604  CG1 ILE    96     -26.213  40.323   8.878  1.00 26.50           C
ATOM   1607  CD1 ILE    96     -26.245  41.771   9.362  1.00 33.12           C
ATOM   1611  CG2 ILE    96     -27.670  38.996  10.451  1.00 39.55           C
ATOM   1615  C   ILE    96     -26.548  37.377   8.152  1.00 19.60           C
ATOM   1616  O   ILE    96     -25.527  37.461   7.468  1.00 21.18           O
ATOM   1618  N   ARG    97     -26.758  36.383   9.014  1.00 22.09           N
ATOM   1619  CA  ARG    97     -25.730  35.337   9.236  1.00 23.22           C
ATOM   1621  CB  ARG    97     -26.055  34.442  10.418  1.00 23.31           C
ATOM   1624  CG  ARG    97     -26.059  35.147  11.791  1.00 18.24           C
ATOM   1627  CD  ARG    97     -25.825  34.149  12.895  1.00 24.44           C
ATOM   1630  NE  ARG    97     -26.714  32.993  12.966  1.00 28.83           N
ATOM   1632  CZ  ARG    97     -27.954  32.988  13.471  1.00 27.43           C
ATOM   1633  NH1 ARG    97     -28.502  34.084  13.952  1.00 30.54           N
ATOM   1636  NH2 ARG    97     -28.636  31.867  13.506  1.00 34.39           N
ATOM   1639  C   ARG    97     -25.531  34.480   8.000  1.00 23.61           C
ATOM   1640  O   ARG    97     -24.405  34.077   7.685  1.00 19.92           O
ATOM   1642  N   HIS    98     -26.632  34.171   7.313  1.00 21.18           N
ATOM   1643  CA  HIS    98     -26.543  33.431   6.046  1.00 22.64           C
ATOM   1645  CB  HIS    98     -27.941  33.050   5.530  1.00 21.77           C
ATOM   1648  CG  HIS    98     -27.908  32.137   4.350  1.00 26.85           C
ATOM   1649  ND1 HIS    98     -27.908  32.597   3.046  1.00 26.01           N
ATOM   1651  CE1 HIS    98     -27.851  31.562   2.226  1.00 24.25           C
ATOM   1653  NE2 HIS    98     -27.801  30.456   2.946  1.00 24.82           N
ATOM   1655  CD2 HIS    98     -27.832  30.790   4.278  1.00 20.83           C
ATOM   1657  C   HIS    98     -25.762  34.212   4.969  1.00 17.30           C
ATOM   1658  O   HIS    98     -24.933  33.631   4.248  1.00 18.06           O
ATOM   1660  N   ARG    99     -26.027  35.506   4.899  1.00 19.10           N
ATOM   1661  CA  ARG    99     -25.316  36.441   4.018  1.00 20.88           C
ATOM   1663  CB  ARG    99     -26.027  37.773   3.997  1.00 20.64           C
ATOM   1666  CG  ARG    99     -27.387  37.732   3.223  1.00 20.88           C
ATOM   1669  CD  ARG    99     -28.174  38.962   3.458  1.00 21.51           C
ATOM   1672  NE  ARG    99     -29.294  39.078   2.521  1.00 23.06           N
ATOM   1674  CZ  ARG    99     -30.191  40.058   2.555  1.00 20.30           C
ATOM   1675  NH1 ARG    99     -30.091  41.023   3.440  1.00 21.05           N
ATOM   1678  NH2 ARG    99     -31.181  40.093   1.678  1.00 21.17           N
ATOM   1681  C   ARG    99     -23.838  36.630   4.382  1.00 20.58           C
ATOM   1682  O   ARG    99     -22.988  36.706   3.488  1.00 17.96           O
ATOM   1684  N   ALA   100     -23.558  36.732   5.683  1.00 19.17           N
ATOM   1685  CA  ALA   100     -22.195  36.813   6.217  1.00 21.85           C
ATOM   1687  CB  ALA   100     -22.225  36.938   7.764  1.00 16.22           C
ATOM   1691  C   ALA   100     -21.351  35.615   5.791  1.00 20.05           C
ATOM   1692  O   ALA   100     -20.221  35.796   5.311  1.00 23.60           O
ATOM   1694  N   CYS   101     -21.907  34.415   5.973  1.00 21.28           N
ATOM   1695  CA  CYS   101     -21.276  33.158   5.610  1.00 21.52           C
ATOM   1697  CB  CYS   101     -22.079  31.960   6.126  1.00 28.07           C
ATOM   1700  SG  CYS   101     -21.972  31.797   7.936  1.00 31.25           S
ATOM   1702  C   CYS   101     -21.051  33.023   4.124  1.00 25.37           C
ATOM   1703  O   CYS   101     -19.999  32.501   3.714  1.00 19.19           O
ATOM   1705  N   ALA   102     -22.016  33.503   3.337  1.00 21.90           N
ATOM   1706  CA  ALA   102     -21.892  33.511   1.882  1.00 22.12           C
ATOM   1708  CB  ALA   102     -23.235  33.849   1.188  1.00 15.78           C
ATOM   1712  C   ALA   102     -20.790  34.486   1.442  1.00 20.27           C
ATOM   1713  O   ALA   102     -20.054  34.187   0.513  1.00 19.10           O
ATOM   1715  N   LEU   103     -20.716  35.655   2.073  1.00 16.83           N
ATOM   1716  CA  LEU   103     -19.665  36.644   1.771  1.00 18.39           C
ATOM   1718  CB  LEU   103     -19.805  37.899   2.654  1.00 23.15           C
ATOM   1721  CG  LEU   103     -18.663  38.922   2.545  1.00 30.05           C
ATOM   1723  CD1 LEU   103     -18.835  39.688   1.281  1.00 28.54           C
ATOM   1727  CD2 LEU   103     -18.626  39.860   3.741  1.00 37.11           C
ATOM   1731  C   LEU   103     -18.284  35.999   1.972  1.00 22.05           C
ATOM   1732  O   LEU   103     -17.399  36.073   1.096  1.00 16.43           O
ATOM   1734  N   ARG   104     -18.145  35.347   3.118  1.00 20.87           N
ATOM   1735  CA  ARG   104     -16.942  34.619   3.490  1.00 19.58           C
ATOM   1737  CB  ARG   104     -17.073  34.081   4.903  1.00 21.66           C
ATOM   1740  CG  ARG   104     -15.809  33.343   5.449  1.00 26.94           C
ATOM   1743  CD  ARG   104     -16.189  32.403   6.579  1.00 37.02           C
ATOM   1746  NE  ARG   104     -17.176  31.418   6.120  1.00 39.15           N
ATOM   1748  CZ  ARG   104     -18.107  30.830   6.873  1.00 47.77           C
ATOM   1749  NH1 ARG   104     -18.226  31.107   8.170  1.00 40.34           N
ATOM   1752  NH2 ARG   104     -18.941  29.960   6.318  1.00 32.08           N
ATOM   1755  C   ARG   104     -16.608  33.498   2.514  1.00 21.51           C
ATOM   1756  O   ARG   104     -15.502  33.451   1.985  1.00 19.81           O
ATOM   1758  N   ASP   105     -17.569  32.614   2.252  1.00 19.85           N
ATOM   1759  CA  ASP   105     -17.371  31.514   1.328  1.00 18.95           C
ATOM   1761  CB  ASP   105     -18.589  30.579   1.310  1.00 19.94           C
ATOM   1764  CG  ASP   105     -18.786  29.817   2.617  1.00 29.87           C
ATOM   1765  OD1 ASP   105     -17.890  29.804   3.497  1.00 25.79           O
ATOM   1766  OD2 ASP   105     -19.875  29.240   2.759  1.00 32.06           O
ATOM   1767  C   ASP   105     -17.071  31.980  -0.091  1.00 18.74           C
ATOM   1768  O   ASP   105     -16.165  31.416  -0.760  1.00 18.41           O
ATOM   1770  N   THR   106     -17.805  32.999  -0.550  1.00 16.32           N
ATOM   1771  CA  THR   106     -17.554  33.568  -1.857  1.00 17.31           C
ATOM   1773  CB  THR   106     -18.592  34.671  -2.215  1.00 19.60           C
ATOM   1775  OG1 THR   106     -19.910  34.091  -2.200  1.00 21.70           O
ATOM   1777  CG2 THR   106     -18.293  35.280  -3.582  1.00 21.15           C
ATOM   1781  C   THR   106     -16.110  34.103  -2.046  1.00 18.99           C
ATOM   1782  O   THR   106     -15.477  33.831  -3.076  1.00 17.74           O
ATOM   1784  N   ALA   107     -15.637  34.895  -1.094  1.00 15.61           N
ATOM   1785  CA  ALA   107     -14.289  35.420  -1.112  1.00 21.64           C
ATOM   1787  CB  ALA   107     -14.046  36.389   0.104  1.00 18.61           C
ATOM   1791  C   ALA   107     -13.247  34.298  -1.143  1.00 18.51           C
ATOM   1792  O   ALA   107     -12.335  34.325  -1.983  1.00 17.14           O
ATOM   1794  N   TYR   108     -13.401  33.301  -0.262  1.00 19.06           N
ATOM   1795  CA  TYR   108     -12.468  32.196  -0.209  1.00 20.55           C
ATOM   1797  CB  TYR   108     -12.759  31.244   0.955  1.00 19.96           C
ATOM   1800  CG  TYR   108     -12.056  31.638   2.231  1.00 25.99           C
ATOM   1801  CD1 TYR   108     -12.606  32.576   3.103  1.00 24.70           C
ATOM   1803  CE1 TYR   108     -11.952  32.927   4.290  1.00 20.39           C
ATOM   1805  CZ  TYR   108     -10.747  32.334   4.587  1.00 20.84           C
ATOM   1806  OH  TYR   108     -10.069  32.659   5.731  1.00 24.88           O
ATOM   1808  CE2 TYR   108     -10.178  31.414   3.723  1.00 24.61           C
ATOM   1810  CD2 TYR   108     -10.817  31.077   2.565  1.00 25.48           C
ATOM   1812  C   TYR   108     -12.408  31.452  -1.529  1.00 20.31           C
ATOM   1813  O   TYR   108     -11.310  31.099  -1.995  1.00 17.23           O
ATOM   1815  N   ALA   109     -13.574  31.289  -2.149  1.00 19.03           N
ATOM   1816  CA  ALA   109     -13.706  30.564  -3.412  1.00 23.11           C
ATOM   1818  CB  ALA   109     -15.176  30.300  -3.685  1.00 18.89           C
ATOM   1822  C   ALA   109     -13.061  31.284  -4.604  1.00 20.50           C
ATOM   1823  O   ALA   109     -12.427  30.638  -5.470  1.00 18.55           O
ATOM   1825  N   ILE   110     -13.267  32.605  -4.688  1.00 19.36           N
ATOM   1826  CA  ILE   110     -12.599  33.421  -5.725  1.00 21.96           C
ATOM   1828  CB  ILE   110     -13.063  34.925  -5.709  1.00 18.58           C
ATOM   1830  CG1 ILE   110     -14.535  35.027  -6.122  1.00 22.18           C
ATOM   1833  CD1 ILE   110     -15.215  36.373  -5.838  1.00 14.78           C
ATOM   1837  CG2 ILE   110     -12.170  35.812  -6.630  1.00 14.29           C
ATOM   1841  C   ILE   110     -11.071  33.311  -5.607  1.00 19.10           C
ATOM   1842  O   ILE   110     -10.372  33.040  -6.591  1.00 17.26           O
ATOM   1844  N   ILE   111     -10.561  33.544  -4.408  1.00 19.19           N
ATOM   1845  CA  ILE   111      -9.131  33.411  -4.116  1.00 25.44           C
ATOM   1847  CB  ILE   111      -8.800  33.800  -2.614  1.00 22.02           C
ATOM   1849  CG1 ILE   111      -8.927  35.319  -2.466  0.50 24.12           C
ATOM   1855  CD1 ILE   111      -8.975  35.821  -1.034  0.50 24.28           C
ATOM   1863  CG2 ILE   111      -7.377  33.351  -2.186  0.50 20.27           C
ATOM   1871  C   ILE   111      -8.594  32.012  -4.480  1.00 23.43           C
ATOM   1872  O   ILE   111      -7.521  31.889  -5.076  1.00 21.51           O
ATOM   1874  N   LYS   112      -9.331  30.970  -4.113  1.00 20.95           N
ATOM   1875  CA  LYS   112      -8.891  29.605  -4.401  1.00 25.13           C
ATOM   1877  CB  LYS   112      -9.815  28.569  -3.758  1.00 24.23           C
ATOM   1880  CG  LYS   112      -9.267  27.139  -3.851  1.00 34.87           C
ATOM   1883  CD  LYS   112     -10.337  26.124  -3.532  1.00 39.00           C
ATOM   1886  CE  LYS   112      -9.719  24.728  -3.388  1.00 41.73           C
ATOM   1889  NZ  LYS   112     -10.780  23.712  -3.284  1.00 50.37           N
ATOM   1893  C   LYS   112      -8.788  29.353  -5.898  1.00 22.73           C
ATOM   1894  O   LYS   112      -7.847  28.719  -6.353  1.00 23.80           O
ATOM   1896  N   GLU   113      -9.746  29.853  -6.661  1.00 20.61           N
ATOM   1897  CA  GLU   113      -9.742  29.692  -8.104  1.00 21.10           C
ATOM   1899  CB  GLU   113     -11.151  29.903  -8.655  1.00 24.85           C
ATOM   1902  CG  GLU   113     -11.376  29.291 -10.028  1.00 42.67           C
ATOM   1905  CD  GLU   113     -12.830  28.871 -10.218  1.00 63.40           C
ATOM   1906  OE1 GLU   113     -13.664  29.740 -10.555  1.00 53.37           O
ATOM   1907  OE2 GLU   113     -13.141  27.678 -10.014  1.00 73.30           O
ATOM   1908  C   GLU   113      -8.761  30.627  -8.834  1.00 22.80           C
ATOM   1909  O   GLU   113      -8.143  30.225  -9.814  1.00 22.99           O
ATOM   1911  N   GLU   114      -8.624  31.869  -8.371  1.00 18.16           N
ATOM   1912  CA  GLU   114      -7.987  32.916  -9.174  1.00 20.66           C
ATOM   1914  CB  GLU   114      -8.942  34.104  -9.351  1.00 17.76           C
ATOM   1917  CG  GLU   114     -10.303  33.700 -10.004  1.00 20.51           C
ATOM   1920  CD  GLU   114     -11.257  34.857 -10.154  1.00 22.62           C
ATOM   1921  OE1 GLU   114     -10.785  36.015 -10.211  1.00 23.24           O
ATOM   1922  OE2 GLU   114     -12.497  34.622 -10.190  1.00 20.23           O
ATOM   1923  C   GLU   114      -6.638  33.436  -8.660  1.00 17.59           C
ATOM   1924  O   GLU   114      -5.978  34.135  -9.388  1.00 22.00           O
ATOM   1926  N   LEU   115      -6.264  33.152  -7.424  1.00 17.35           N
ATOM   1927  CA  LEU   115      -4.969  33.587  -6.918  1.00 22.63           C
ATOM   1929  CB  LEU   115      -5.031  34.089  -5.488  1.00 25.32           C
ATOM   1932  CG  LEU   115      -3.736  34.808  -5.019  1.00 27.81           C
ATOM   1934  CD1 LEU   115      -3.541  36.132  -5.784  1.00 29.99           C
ATOM   1938  CD2 LEU   115      -3.802  35.013  -3.544  1.00 34.72           C
ATOM   1942  C   LEU   115      -3.995  32.413  -7.027  1.00 22.59           C
ATOM   1943  O   LEU   115      -4.200  31.351  -6.437  1.00 25.27           O
ATOM   1945  N   ASP   116      -2.956  32.608  -7.823  1.00 26.87           N
ATOM   1946  CA  ASP   116      -1.931  31.598  -8.001  1.00 21.26           C
ATOM   1948  CB  ASP   116      -0.940  32.039  -9.085  1.00 24.60           C
ATOM   1951  CG  ASP   116      -0.014  30.945  -9.463  1.00 32.72           C
ATOM   1952  OD1 ASP   116       0.802  30.520  -8.621  1.00 35.85           O
ATOM   1953  OD2 ASP   116      -0.116  30.482 -10.603  1.00 30.51           O
ATOM   1954  C   ASP   116      -1.217  31.405  -6.686  1.00 19.88           C
ATOM   1955  O   ASP   116      -0.797  32.367  -6.070  1.00 17.18           O
ATOM   1957  N   GLU   117      -1.072  30.153  -6.273  1.00 19.70           N
ATOM   1958  CA  GLU   117      -0.423  29.793  -5.015  1.00 21.71           C
ATOM   1960  CB  GLU   117      -0.505  28.281  -4.806  1.00 24.97           C
ATOM   1963  CG  GLU   117      -1.873  27.805  -4.351  1.00 47.68           C
ATOM   1966  CD  GLU   117      -1.993  26.281  -4.377  1.00 62.52           C
ATOM   1967  OE1 GLU   117      -1.051  25.592  -3.917  1.00 68.27           O
ATOM   1968  OE2 GLU   117      -3.025  25.781  -4.872  1.00 64.53           O
ATOM   1969  C   GLU   117       1.034  30.252  -4.904  1.00 19.02           C
ATOM   1970  O   GLU   117       1.505  30.575  -3.804  1.00 21.23           O
ATOM   1972  N   ASP   118       1.726  30.300  -6.037  1.00 21.76           N
ATOM   1973  CA  ASP   118       3.114  30.755  -6.084  1.00 23.35           C
ATOM   1975  CB  ASP   118       3.807  30.259  -7.362  1.00 23.22           C
ATOM   1978  CG  ASP   118       4.031  28.759  -7.344  1.00 23.95           C
ATOM   1979  OD1 ASP   118       4.153  28.174  -6.239  1.00 27.42           O
ATOM   1980  OD2 ASP   118       4.053  28.181  -8.419  1.00 34.51           O
ATOM   1981  C   ASP   118       3.216  32.252  -5.989  1.00 19.61           C
ATOM   1982  O   ASP   118       4.183  32.772  -5.444  1.00 21.35           O
ATOM   1984  N   PHE   119       2.205  32.953  -6.489  1.00 20.03           N
ATOM   1985  CA  PHE   119       2.117  34.407  -6.319  1.00 18.31           C
ATOM   1987  CB  PHE   119       0.999  35.022  -7.194  1.00 21.75           C
ATOM   1990  CG  PHE   119       0.877  36.501  -7.019  1.00 18.23           C
ATOM   1991  CD1 PHE   119       1.697  37.368  -7.744  1.00 20.63           C
ATOM   1993  CE1 PHE   119       1.645  38.724  -7.536  1.00 20.18           C
ATOM   1995  CZ  PHE   119       0.778  39.242  -6.595  1.00 20.66           C
ATOM   1997  CE2 PHE   119      -0.028  38.399  -5.840  1.00 21.25           C
ATOM   1999  CD2 PHE   119       0.034  37.039  -6.034  1.00 23.39           C
ATOM   2001  C   PHE   119       1.943  34.760  -4.820  1.00 20.04           C
ATOM   2002  O   PHE   119       2.636  35.652  -4.300  1.00 19.24           O
ATOM   2004  N   GLU   120       1.019  34.061  -4.149  1.00 19.65           N
ATOM   2005  CA  GLU   120       0.771  34.243  -2.721  1.00 20.07           C
ATOM   2007  CB  GLU   120      -0.452  33.418  -2.270  1.00 19.67           C
ATOM   2010  CG  GLU   120      -0.776  33.431  -0.751  1.00 18.22           C
ATOM   2013  CD  GLU   120      -0.842  34.838  -0.076  1.00 24.26           C
ATOM   2014  OE1 GLU   120      -0.993  35.867  -0.749  1.00 22.01           O
ATOM   2015  OE2 GLU   120      -0.748  34.920   1.166  1.00 31.38           O
ATOM   2016  C   GLU   120       2.011  33.896  -1.906  1.00 20.48           C
ATOM   2017  O   GLU   120       2.382  34.653  -1.004  1.00 18.84           O
ATOM   2019  N   GLN   121       2.694  32.812  -2.281  1.00 23.00           N
ATOM   2020  CA  GLN   121       3.915  32.389  -1.584  1.00 25.45           C
ATOM   2022  CB  GLN   121       4.429  31.033  -2.118  1.00 27.28           C
ATOM   2025  CG  GLN   121       5.608  30.447  -1.317  1.00 21.66           C
ATOM   2028  CD  GLN   121       5.278  30.213   0.151  1.00 33.37           C
ATOM   2029  OE1 GLN   121       4.152  29.870   0.483  1.00 32.16           O
ATOM   2030  NE2 GLN   121       6.259  30.418   1.037  1.00 26.32           N
ATOM   2033  C   GLN   121       5.004  33.462  -1.667  1.00 23.94           C
ATOM   2034  O   GLN   121       5.652  33.769  -0.654  1.00 23.54           O
ATOM   2036  N   LEU   122       5.194  34.028  -2.859  1.00 20.47           N
ATOM   2037  CA  LEU   122       6.070  35.185  -3.031  1.00 18.08           C
ATOM   2039  CB  LEU   122       6.086  35.684  -4.483  1.00 19.06           C
ATOM   2042  CG  LEU   122       7.034  36.853  -4.806  1.00 21.41           C
ATOM   2044  CD1 LEU   122       8.500  36.550  -4.318  1.00 21.01           C
ATOM   2048  CD2 LEU   122       6.981  37.263  -6.284  1.00 19.35           C
ATOM   2052  C   LEU   122       5.717  36.346  -2.102  1.00 25.99           C
ATOM   2053  O   LEU   122       6.595  36.878  -1.426  1.00 22.53           O
ATOM   2055  N   CYS   123       4.442  36.746  -2.073  1.00 24.30           N
ATOM   2056  CA  CYS   123       3.986  37.824  -1.193  1.00 22.03           C
ATOM   2058  CB  CYS   123       2.462  38.013  -1.273  1.00 19.81           C
ATOM   2061  SG  CYS   123       1.949  38.719  -2.788  1.00 20.51           S
ATOM   2063  C   CYS   123       4.406  37.543   0.250  1.00 19.76           C
ATOM   2064  O   CYS   123       4.923  38.429   0.925  1.00 23.30           O
ATOM   2066  N   GLU   124       4.219  36.302   0.677  1.00 21.51           N
ATOM   2067  CA  GLU   124       4.498  35.894   2.033  1.00 23.50           C
ATOM   2069  CB  GLU   124       3.904  34.522   2.316  1.00 25.91           C
ATOM   2072  CG  GLU   124       2.354  34.523   2.426  1.00 34.93           C
ATOM   2075  CD  GLU   124       1.753  33.122   2.570  1.00 39.26           C
ATOM   2076  OE1 GLU   124       2.507  32.196   2.922  1.00 44.00           O
ATOM   2077  OE2 GLU   124       0.531  32.934   2.324  1.00 32.86           O
ATOM   2078  C   GLU   124       6.000  35.937   2.305  1.00 27.58           C
ATOM   2079  O   GLU   124       6.425  36.363   3.373  1.00 23.27           O
ATOM   2081  N   GLU   125       6.808  35.559   1.319  1.00 28.86           N
ATOM   2082  CA  GLU   125       8.266  35.568   1.498  1.00 28.47           C
ATOM   2084  CB  GLU   125       8.964  34.623   0.483  1.00 24.02           C
ATOM   2087  CG  GLU   125       8.640  33.169   0.845  1.00 24.03           C
ATOM   2090  CD  GLU   125       9.254  32.079  -0.028  1.00 24.11           C
ATOM   2091  OE1 GLU   125      10.097  32.389  -0.885  1.00 26.14           O
ATOM   2092  OE2 GLU   125       8.870  30.893   0.175  1.00 25.13           O
ATOM   2093  C   GLU   125       8.844  36.986   1.557  1.00 25.14           C
ATOM   2094  O   GLU   125       9.702  37.240   2.379  1.00 32.10           O
ATOM   2096  N   ILE   126       8.343  37.910   0.744  1.00 18.67           N
ATOM   2097  CA  ILE   126       8.744  39.303   0.794  1.00 28.52           C
ATOM   2099  CB  ILE   126       8.101  40.129  -0.336  1.00 27.83           C
ATOM   2101  CG1 ILE   126       8.493  39.568  -1.715  1.00 26.91           C
ATOM   2104  CD1 ILE   126       7.773  40.251  -2.894  1.00 26.67           C
ATOM   2108  CG2 ILE   126       8.485  41.616  -0.217  1.00 22.12           C
ATOM   2112  C   ILE   126       8.337  39.875   2.154  1.00 36.40           C
ATOM   2113  O   ILE   126       9.156  40.463   2.873  1.00 35.06           O
ATOM   2115  N   GLN   127       7.079  39.649   2.529  1.00 35.08           N
ATOM   2116  CA  GLN   127       6.566  40.142   3.807  1.00 38.66           C
ATOM   2118  CB  GLN   127       5.108  39.735   3.995  1.00 38.13           C
ATOM   2121  CG  GLN   127       4.372  40.616   4.976  1.00 46.73           C
ATOM   2124  CD  GLN   127       3.704  39.812   6.038  1.00 64.51           C
ATOM   2125  OE1 GLN   127       4.390  39.181   6.848  1.00 56.16           O
ATOM   2126  NE2 GLN   127       2.356  39.812   6.052  1.00 51.91           N
ATOM   2129  C   GLN   127       7.425  39.636   4.995  1.00 34.69           C
ATOM   2130  O   GLN   127       7.851  40.424   5.838  1.00 33.60           O
ATOM   2132  N   GLU   128       7.683  38.335   5.043  1.00 35.26           N
ATOM   2133  CA  GLU   128       8.563  37.745   6.067  1.00 40.39           C
ATOM   2135  CB  GLU   128       8.623  36.223   5.892  1.00 41.49           C
ATOM   2138  CG  GLU   128       7.485  35.491   6.573  1.00 47.02           C
ATOM   2141  CD  GLU   128       6.930  34.334   5.760  1.00 63.09           C
ATOM   2142  OE1 GLU   128       7.704  33.634   5.067  1.00 51.55           O
ATOM   2143  OE2 GLU   128       5.699  34.126   5.826  1.00 65.34           O
ATOM   2144  C   GLU   128      10.001  38.324   6.084  1.00 45.71           C
ATOM   2145  O   GLU   128      10.679  38.302   7.119  1.00 48.40           O
ATOM   2147  N   SER   129      10.462  38.833   4.946  1.00 43.84           N
ATOM   2148  CA  SER   129      11.809  39.391   4.843  1.00 48.65           C
ATOM   2150  CB  SER   129      12.296  39.375   3.386  1.00 43.37           C
ATOM   2153  OG  SER   129      11.800  40.487   2.656  1.00 42.87           O
ATOM   2155  C   SER   129      11.874  40.812   5.408  1.00 52.03           C
ATOM   2156  O   SER   129      12.965  41.358   5.592  1.00 53.77           O
ATOM   2158  N   ARG   130      10.711  41.410   5.661  1.00 53.93           N
ATOM   2159  CA  ARG   130      10.633  42.740   6.267  1.00 59.45           C
ATOM   2161  CB  ARG   130       9.391  43.497   5.759  1.00 54.21           C
ATOM   2164  CG  ARG   130       9.681  44.307   4.492  1.00 68.78           C
ATOM   2167  CD  ARG   130       8.593  44.234   3.428  1.00 58.27           C
ATOM   2170  NE  ARG   130       9.175  44.426   2.091  1.00 71.54           N
ATOM   2172  CZ  ARG   130       8.794  45.337   1.189  1.00 79.48           C
ATOM   2173  NH1 ARG   130       9.414  45.386   0.007  1.00 73.01           N
ATOM   2176  NH2 ARG   130       7.790  46.185   1.432  1.00 82.81           N
ATOM   2179  C   ARG   130      10.653  42.648   7.793  1.00 61.53           C
ATOM   2180  O   ARG   130       9.981  41.818   8.419  1.00 64.77           O
ATOM   2182  OXT ARG   130      11.374  43.409   8.435  1.00 67.56           O
END
