
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  247 ( 1861),  selected  247 , name 2ewm_B
# Molecule2: number of CA atoms  199 ( 1473),  selected  199 , name T0433.pdb
# PARAMETERS: 2ewm_B.T0433.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q     3_B      -       -           -
LGA    R     4_B      -       -           -
LGA    L     5_B      -       -           -
LGA    K     6_B      -       -           -
LGA    D     7_B      -       -           -
LGA    K     8_B      M       1          1.280
LGA    L     9_B      K       2          1.208
LGA    A    10_B      I       3          0.999
LGA    V    11_B      L       4          1.317
LGA    I    12_B      L       5          1.631
LGA    T    13_B      I       6          1.713
LGA    G    14_B      G       7          1.613
LGA    G    15_B      A       8          1.555
LGA    A    16_B      S       9          0.726
LGA    N    17_B      G      10          1.717
LGA    G    18_B      T      11          0.894
LGA    I    19_B      L      12          0.927
LGA    G    20_B      G      13          1.207
LGA    R    21_B      S      14          1.545
LGA    A    22_B      A      15          1.144
LGA    I    23_B      V      16          0.766
LGA    A    24_B      K      17          1.764
LGA    E    25_B      E      18          2.182
LGA    R    26_B      R      19          1.192
LGA    F    27_B      L      20          0.864
LGA    A    28_B      E      21          0.973
LGA    V    29_B      K      22          0.858
LGA    E    30_B      K      23          1.571
LGA    G    31_B      A      24          2.781
LGA    A    32_B      -       -           -
LGA    D    33_B      E      25          1.601
LGA    I    34_B      V      26          1.933
LGA    A    35_B      I      27          2.224
LGA    I    36_B      T      28          2.224
LGA    A    37_B      A      29          2.231
LGA    D    38_B      G      30          1.612
LGA    L    39_B      R      31          2.128
LGA    V    40_B      H      32          3.366
LGA    P    41_B      S      33          2.791
LGA    A    42_B      -       -           -
LGA    P    43_B      -       -           -
LGA    E    44_B      -       -           -
LGA    A    45_B      -       -           -
LGA    E    46_B      -       -           -
LGA    A    47_B      -       -           -
LGA    A    48_B      -       -           -
LGA    I    49_B      -       -           -
LGA    R    50_B      -       -           -
LGA    N    51_B      -       -           -
LGA    L    52_B      -       -           -
LGA    G    53_B      -       -           -
LGA    R    54_B      -       -           -
LGA    R    55_B      -       -           -
LGA    V    56_B      -       -           -
LGA    L    57_B      G      34          4.892
LGA    T    58_B      D      35          2.533
LGA    V    59_B      V      36          2.793
LGA    K    60_B      T      37          3.129
LGA    C    61_B      V      38          1.988
LGA    D    62_B      D      39          1.359
LGA    V    63_B      I      40          1.035
LGA    S    64_B      T      41          1.370
LGA    Q    65_B      N      42          0.630
LGA    P    66_B      I      43          0.652
LGA    G    67_B      D      44          1.442
LGA    D    68_B      S      45          0.990
LGA    V    69_B      I      46          0.736
LGA    E    70_B      K      47          1.144
LGA    A    71_B      K      48          1.231
LGA    F    72_B      M      49          0.984
LGA    G    73_B      Y      50          1.039
LGA    K    74_B      E      51          1.410
LGA    Q    75_B      Q      52          1.450
LGA    V    76_B      V      53          0.924
LGA    I    77_B      G      54          1.590
LGA    S    78_B      -       -           -
LGA    T    79_B      -       -           -
LGA    F    80_B      -       -           -
LGA    G    81_B      -       -           -
LGA    R    82_B      K      55          1.322
LGA    C    83_B      V      56          1.390
LGA    D    84_B      D      57          0.957
LGA    I    85_B      A      58          0.540
LGA    L    86_B      I      59          0.973
LGA    V    87_B      V      60          1.054
LGA    N    88_B      S      61          1.813
LGA    N    89_B      A      62          1.741
LGA    A    90_B      T      63          0.920
LGA    G    91_B      G      64          1.890
LGA    I    92_B      S      65          1.907
LGA    Y    93_B      A      66          3.638
LGA    P    94_B      T      67          3.949
LGA    L    95_B      F      68          2.366
LGA    I    96_B      S      69          0.363
LGA    P    97_B      P      70          0.931
LGA    F    98_B      L      71          1.380
LGA    D    99_B      T      72          1.391
LGA    E   100_B      E      73          0.844
LGA    L   101_B      L      74          1.068
LGA    T   102_B      T      75          1.554
LGA    F   103_B      P      76          1.296
LGA    E   104_B      E      77          1.353
LGA    Q   105_B      K      78          1.206
LGA    W   106_B      N      79          0.421
LGA    K   107_B      A      80          0.742
LGA    K   108_B      V      81          1.142
LGA    T   109_B      T      82          0.647
LGA    F   110_B      I      83          0.847
LGA    E   111_B      S      84          0.681
LGA    I   112_B      S      85          0.460
LGA    N   113_B      K      86          0.775
LGA    V   114_B      L      87          1.643
LGA    D   115_B      G      88          1.687
LGA    S   116_B      G      89          1.530
LGA    G   117_B      Q      90          1.954
LGA    F   118_B      I      91          2.499
LGA    L   119_B      N      92          2.115
LGA    M   120_B      L      93          1.342
LGA    A   121_B      V      94          1.611
LGA    K   122_B      L      95          2.849
LGA    A   123_B      L      96          3.084
LGA    F   124_B      G      97          2.408
LGA    V   125_B      I      98          1.031
LGA    P   126_B      D      99          1.330
LGA    G   127_B      S     100          3.327
LGA    M   128_B      L     101          2.305
LGA    K   129_B      -       -           -
LGA    R   130_B      -       -           -
LGA    N   131_B      N     102          3.756
LGA    G   132_B      D     103          1.959
LGA    W   133_B      K     104          1.556
LGA    G   134_B      G     105          0.614
LGA    R   135_B      S     106          0.881
LGA    I   136_B      F     107          0.791
LGA    I   137_B      T     108          0.794
LGA    N   138_B      L     109          1.299
LGA    L   139_B      T     110          0.905
LGA    T   140_B      T     111          0.727
LGA    S   141_B      G     112          0.790
LGA    T   142_B      I     113          1.333
LGA    T   143_B      M     114          1.427
LGA    Y   144_B      M     115          1.211
LGA    W   145_B      E     116          1.278
LGA    L   146_B      D     117          1.221
LGA    K   147_B      P     118          3.254
LGA    I   148_B      I     119          1.652
LGA    E   149_B      V     120          1.847
LGA    A   150_B      Q     121          1.587
LGA    Y   151_B      G     122          1.600
LGA    T   152_B      A     123          1.465
LGA    H   153_B      S     124          1.012
LGA    Y   154_B      A     125          0.944
LGA    I   155_B      A     126          0.513
LGA    S   156_B      M     127          0.452
LGA    T   157_B      A     128          0.650
LGA    K   158_B      N     129          0.637
LGA    A   159_B      G     130          0.313
LGA    A   160_B      A     131          0.367
LGA    N   161_B      V     132          0.773
LGA    I   162_B      T     133          0.355
LGA    G   163_B      A     134          1.192
LGA    F   164_B      F     135          1.308
LGA    T   165_B      A     136          0.834
LGA    R   166_B      K     137          0.880
LGA    A   167_B      S     138          1.662
LGA    L   168_B      A     139          1.231
LGA    A   169_B      A     140          0.463
LGA    S   170_B      I     141          1.242
LGA    D   171_B      E     142          1.130
LGA    L   172_B      M     143          0.594
LGA    G   173_B      -       -           -
LGA    K   174_B      P     144          5.114
LGA    D   175_B      R     145          2.157
LGA    G   176_B      G     146          1.093
LGA    I   177_B      I     147          1.043
LGA    T   178_B      R     148          1.018
LGA    V   179_B      I     149          0.886
LGA    N   180_B      N     150          0.856
LGA    A   181_B      T     151          0.990
LGA    I   182_B      V     152          0.964
LGA    A   183_B      S     153          0.936
LGA    P   184_B      P     154          0.991
LGA    S   185_B      N     155          1.039
LGA    L   186_B      V     156          1.318
LGA    V   187_B      L     157          0.757
LGA    R   188_B      E     158          2.496
LGA    T   189_B      E     159          3.201
LGA    A   190_B      -       -           -
LGA    T   191_B      S     160          5.309
LGA    T   192_B      W     161          5.195
LGA    E   193_B      D     162          3.248
LGA    A   194_B      K     163          2.870
LGA    S   195_B      -       -           -
LGA    A   196_B      L     164          4.042
LGA    L   197_B      E     165          3.032
LGA    S   198_B      P     166          5.107
LGA    A   199_B      F     167           #
LGA    M   200_B      F     168          4.257
LGA    F   201_B      E     169           #
LGA    D   202_B      -       -           -
LGA    V   203_B      G     170          3.281
LGA    L   204_B      F     171          1.930
LGA    P   205_B      L     172          1.858
LGA    N   206_B      -       -           -
LGA    M   207_B      -       -           -
LGA    L   208_B      -       -           -
LGA    Q   209_B      -       -           -
LGA    A   210_B      -       -           -
LGA    I   211_B      -       -           -
LGA    P   212_B      -       -           -
LGA    R   213_B      -       -           -
LGA    L   214_B      P     173          3.666
LGA    Q   215_B      V     174          1.339
LGA    V   216_B      P     175          1.487
LGA    P   217_B      A     176          1.044
LGA    L   218_B      A     177          0.579
LGA    D   219_B      K     178          0.606
LGA    L   220_B      V     179          1.435
LGA    T   221_B      A     180          1.877
LGA    G   222_B      R     181          1.727
LGA    A   223_B      A     182          1.845
LGA    A   224_B      F     183          1.505
LGA    A   225_B      E     184          1.219
LGA    F   226_B      K     185          1.862
LGA    L   227_B      S     186          1.762
LGA    A   228_B      V     187          0.850
LGA    S   229_B      F     188          1.289
LGA    D   230_B      -       -           -
LGA    D   231_B      -       -           -
LGA    A   232_B      G     189          2.755
LGA    S   233_B      A     190          1.675
LGA    F   234_B      -       -           -
LGA    I   235_B      Q     191          1.785
LGA    T   236_B      T     192          1.043
LGA    G   237_B      G     193          0.764
LGA    Q   238_B      E     194          0.979
LGA    T   239_B      S     195          0.635
LGA    L   240_B      Y     196          1.201
LGA    A   241_B      Q     197          0.687
LGA    V   242_B      V     198          1.117
LGA    D   243_B      Y     199          1.382
LGA    G   244_B      -       -           -
LGA    G   245_B      -       -           -
LGA    M   246_B      -       -           -
LGA    V   247_B      -       -           -
LGA    R   248_B      -       -           -
LGA    H   249_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  247  199    5.0    197    1.85    17.26     88.892    10.093

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.049268 * X  +   0.996951 * Y  +  -0.060511 * Z  + 106.688179
  Y_new =   0.208695 * X  +  -0.048972 * Y  +  -0.976754 * Z  + -61.755386
  Z_new =  -0.976739 * X  +  -0.060751 * Y  +  -0.205646 * Z  + 193.712814 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.854345    0.287247  [ DEG:  -163.5419     16.4581 ]
  Theta =   1.354686    1.786907  [ DEG:    77.6178    102.3822 ]
  Phi   =   1.802629   -1.338963  [ DEG:   103.2831    -76.7169 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ewm_B                                        
REMARK     2: T0433.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ewm_B.T0433.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  247  199   5.0  197   1.85   17.26  88.892
REMARK  ---------------------------------------------------------- 
MOLECULE 2ewm_B
HEADER    TRANSFERASE                             04-NOV-05   2EWM              
TITLE     CRYSTAL STRUCTURE OF THE (S)-SPECIFIC 1-PHENYLETHANOL                 
TITLE    2 DEHYDROGENASE OF THE DENITRIFYING BACTERIUM STRAIN EBN1              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: (S)-1-PHENYLETHANOL DEHYDROGENASE;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AZOARCUS;                                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: TG1;                                       
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR: PJOE2702                                   
KEYWDS    DEHYDROGENASE                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.W.HOEFFKEN                                                          
REVDAT   1   14-MAR-06 2EWM    0                                                
JRNL        AUTH   H.W.HOEFFKEN,M.DUONG,T.FRIEDRICH,M.BREUER,B.HAUER,           
JRNL        AUTH 2 R.REINHARDT,R.RABUS,J.HEIDER                                 
JRNL        TITL   CRYSTAL STRUCTURE AND ENZYME KINETICS OF THE                 
JRNL        TITL 2 (S)-SPECIFIC 1-PHENYLETHANOL DEHYDROGENASE OF THE            
JRNL        TITL 3 DENITRIFYING BACTERIUM STRAIN EBN1                           
JRNL        REF    BIOCHEMISTRY                  V.  45    82 2006              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2EWM A    1   249  GB     56476740 YP_158329        1    249             
DBREF  2EWM B    1   249  GB     56476740 YP_158329        1    249             
SEQRES   1 A  249  MET THR GLN ARG LEU LYS ASP LYS LEU ALA VAL ILE THR          
SEQRES   2 A  249  GLY GLY ALA ASN GLY ILE GLY ARG ALA ILE ALA GLU ARG          
SEQRES   3 A  249  PHE ALA VAL GLU GLY ALA ASP ILE ALA ILE ALA ASP LEU          
SEQRES   4 A  249  VAL PRO ALA PRO GLU ALA GLU ALA ALA ILE ARG ASN LEU          
SEQRES   5 A  249  GLY ARG ARG VAL LEU THR VAL LYS CYS ASP VAL SER GLN          
SEQRES   6 A  249  PRO GLY ASP VAL GLU ALA PHE GLY LYS GLN VAL ILE SER          
SEQRES   7 A  249  THR PHE GLY ARG CYS ASP ILE LEU VAL ASN ASN ALA GLY          
SEQRES   8 A  249  ILE TYR PRO LEU ILE PRO PHE ASP GLU LEU THR PHE GLU          
SEQRES   9 A  249  GLN TRP LYS LYS THR PHE GLU ILE ASN VAL ASP SER GLY          
SEQRES  10 A  249  PHE LEU MET ALA LYS ALA PHE VAL PRO GLY MET LYS ARG          
SEQRES  11 A  249  ASN GLY TRP GLY ARG ILE ILE ASN LEU THR SER THR THR          
SEQRES  12 A  249  TYR TRP LEU LYS ILE GLU ALA TYR THR HIS TYR ILE SER          
SEQRES  13 A  249  THR LYS ALA ALA ASN ILE GLY PHE THR ARG ALA LEU ALA          
SEQRES  14 A  249  SER ASP LEU GLY LYS ASP GLY ILE THR VAL ASN ALA ILE          
SEQRES  15 A  249  ALA PRO SER LEU VAL ARG THR ALA THR THR GLU ALA SER          
SEQRES  16 A  249  ALA LEU SER ALA MET PHE ASP VAL LEU PRO ASN MET LEU          
SEQRES  17 A  249  GLN ALA ILE PRO ARG LEU GLN VAL PRO LEU ASP LEU THR          
SEQRES  18 A  249  GLY ALA ALA ALA PHE LEU ALA SER ASP ASP ALA SER PHE          
SEQRES  19 A  249  ILE THR GLY GLN THR LEU ALA VAL ASP GLY GLY MET VAL          
SEQRES  20 A  249  ARG HIS                                                      
SEQRES   1 B  249  MET THR GLN ARG LEU LYS ASP LYS LEU ALA VAL ILE THR          
SEQRES   2 B  249  GLY GLY ALA ASN GLY ILE GLY ARG ALA ILE ALA GLU ARG          
SEQRES   3 B  249  PHE ALA VAL GLU GLY ALA ASP ILE ALA ILE ALA ASP LEU          
SEQRES   4 B  249  VAL PRO ALA PRO GLU ALA GLU ALA ALA ILE ARG ASN LEU          
SEQRES   5 B  249  GLY ARG ARG VAL LEU THR VAL LYS CYS ASP VAL SER GLN          
SEQRES   6 B  249  PRO GLY ASP VAL GLU ALA PHE GLY LYS GLN VAL ILE SER          
SEQRES   7 B  249  THR PHE GLY ARG CYS ASP ILE LEU VAL ASN ASN ALA GLY          
SEQRES   8 B  249  ILE TYR PRO LEU ILE PRO PHE ASP GLU LEU THR PHE GLU          
SEQRES   9 B  249  GLN TRP LYS LYS THR PHE GLU ILE ASN VAL ASP SER GLY          
SEQRES  10 B  249  PHE LEU MET ALA LYS ALA PHE VAL PRO GLY MET LYS ARG          
SEQRES  11 B  249  ASN GLY TRP GLY ARG ILE ILE ASN LEU THR SER THR THR          
SEQRES  12 B  249  TYR TRP LEU LYS ILE GLU ALA TYR THR HIS TYR ILE SER          
SEQRES  13 B  249  THR LYS ALA ALA ASN ILE GLY PHE THR ARG ALA LEU ALA          
SEQRES  14 B  249  SER ASP LEU GLY LYS ASP GLY ILE THR VAL ASN ALA ILE          
SEQRES  15 B  249  ALA PRO SER LEU VAL ARG THR ALA THR THR GLU ALA SER          
SEQRES  16 B  249  ALA LEU SER ALA MET PHE ASP VAL LEU PRO ASN MET LEU          
SEQRES  17 B  249  GLN ALA ILE PRO ARG LEU GLN VAL PRO LEU ASP LEU THR          
SEQRES  18 B  249  GLY ALA ALA ALA PHE LEU ALA SER ASP ASP ALA SER PHE          
SEQRES  19 B  249  ILE THR GLY GLN THR LEU ALA VAL ASP GLY GLY MET VAL          
SEQRES  20 B  249  ARG HIS                                                      
HET    SO4    701       5                                                       
HET    SO4    702       5                                                       
HET    NAD    256      44                                                       
HET    NAD    257      44                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     NAD NICOTINAMIDE-ADENINE-DINUCLEOTIDE                                
FORMUL   3  SO4    2(O4 S 2-)                                                   
FORMUL   5  NAD    2(C21 H27 N7 O14 P2)                                         
FORMUL   7  HOH   *167(H2 O)                                                    
CRYST1   58.400   58.400  236.200  90.00  90.00  90.00 P 43 21 2    16          
ATOM   1761  N   GLN B   3      57.474 103.239 167.643  1.00 56.34           N  
ATOM   1762  CA  GLN B   3      58.415 102.731 166.596  1.00 56.35           C  
ATOM   1763  C   GLN B   3      59.182 101.526 167.130  1.00 55.55           C  
ATOM   1764  O   GLN B   3      60.380 101.609 167.403  1.00 54.77           O  
ATOM   1765  CB  GLN B   3      59.403 103.825 166.199  1.00 58.54           C  
ATOM   1766  CG  GLN B   3      58.754 105.154 165.858  1.00 62.41           C  
ATOM   1767  CD  GLN B   3      57.944 105.111 164.577  1.00 64.26           C  
ATOM   1768  OE1 GLN B   3      58.502 105.085 163.477  1.00 65.42           O  
ATOM   1769  NE2 GLN B   3      56.622 105.093 164.711  1.00 64.75           N  
ATOM   1770  N   ARG B   4      58.484 100.404 167.275  1.00 54.48           N  
ATOM   1771  CA  ARG B   4      59.100  99.187 167.786  1.00 53.34           C  
ATOM   1772  C   ARG B   4      60.333  98.779 166.983  1.00 52.69           C  
ATOM   1773  O   ARG B   4      61.173  98.035 167.481  1.00 54.03           O  
ATOM   1774  CB  ARG B   4      58.081  98.050 167.779  1.00 53.79           C  
ATOM   1775  CG  ARG B   4      56.790  98.382 168.509  1.00 55.33           C  
ATOM   1776  CD  ARG B   4      55.627  97.574 167.957  1.00 55.22           C  
ATOM   1777  NE  ARG B   4      55.538  96.234 168.526  1.00 55.09           N  
ATOM   1778  CZ  ARG B   4      54.838  95.243 167.984  1.00 54.58           C  
ATOM   1779  NH1 ARG B   4      54.173  95.437 166.849  1.00 52.12           N  
ATOM   1780  NH2 ARG B   4      54.775  94.066 168.594  1.00 54.98           N  
ATOM   1781  N   LEU B   5      60.442  99.273 165.751  1.00 50.27           N  
ATOM   1782  CA  LEU B   5      61.574  98.943 164.894  1.00 47.70           C  
ATOM   1783  C   LEU B   5      62.363 100.191 164.500  1.00 46.95           C  
ATOM   1784  O   LEU B   5      62.951 100.246 163.421  1.00 44.93           O  
ATOM   1785  CB  LEU B   5      61.089  98.221 163.631  1.00 47.59           C  
ATOM   1786  CG  LEU B   5      60.263  96.949 163.833  1.00 47.33           C  
ATOM   1787  CD1 LEU B   5      59.896  96.346 162.492  1.00 46.50           C  
ATOM   1788  CD2 LEU B   5      61.056  95.952 164.656  1.00 48.44           C  
ATOM   1789  N   LYS B   6      62.371 101.190 165.376  1.00 47.41           N  
ATOM   1790  CA  LYS B   6      63.095 102.433 165.121  1.00 48.06           C  
ATOM   1791  C   LYS B   6      64.600 102.153 165.114  1.00 46.18           C  
ATOM   1792  O   LYS B   6      65.094 101.345 165.901  1.00 45.23           O  
ATOM   1793  CB  LYS B   6      62.754 103.470 166.204  1.00 50.26           C  
ATOM   1794  CG  LYS B   6      63.279 104.894 165.962  1.00 53.40           C  
ATOM   1795  CD  LYS B   6      62.482 105.657 164.905  1.00 56.81           C  
ATOM   1796  CE  LYS B   6      62.872 105.261 163.485  1.00 58.50           C  
ATOM   1797  NZ  LYS B   6      64.252 105.709 163.136  1.00 61.27           N  
ATOM   1798  N   ASP B   7      65.316 102.818 164.211  1.00 45.16           N  
ATOM   1799  CA  ASP B   7      66.763 102.667 164.077  1.00 44.68           C  
ATOM   1800  C   ASP B   7      67.220 101.264 163.687  1.00 43.68           C  
ATOM   1801  O   ASP B   7      68.317 100.841 164.047  1.00 43.83           O  
ATOM   1802  CB  ASP B   7      67.474 103.083 165.370  1.00 46.29           C  
ATOM   1803  CG  ASP B   7      67.369 104.572 165.645  1.00 47.41           C  
ATOM   1804  OD1 ASP B   7      66.326 105.013 166.172  1.00 48.04           O  
ATOM   1805  OD2 ASP B   7      68.327 105.304 165.323  1.00 48.80           O  
ATOM   1806  N   LYS B   8      66.385 100.545 162.949  1.00 40.87           N  
ATOM   1807  CA  LYS B   8      66.746  99.204 162.521  1.00 38.63           C  
ATOM   1808  C   LYS B   8      66.713  99.035 161.007  1.00 36.14           C  
ATOM   1809  O   LYS B   8      65.974  99.731 160.308  1.00 35.22           O  
ATOM   1810  CB  LYS B   8      65.841  98.170 163.203  1.00 38.95           C  
ATOM   1811  CG  LYS B   8      66.316  97.848 164.608  1.00 37.93           C  
ATOM   1812  CD  LYS B   8      65.364  96.973 165.382  1.00 36.57           C  
ATOM   1813  CE  LYS B   8      65.928  96.713 166.766  1.00 35.47           C  
ATOM   1814  NZ  LYS B   8      64.934  96.094 167.679  1.00 39.36           N  
ATOM   1815  N   LEU B   9      67.543  98.126 160.507  1.00 32.59           N  
ATOM   1816  CA  LEU B   9      67.607  97.858 159.079  1.00 31.20           C  
ATOM   1817  C   LEU B   9      67.082  96.449 158.803  1.00 30.98           C  
ATOM   1818  O   LEU B   9      67.546  95.473 159.394  1.00 30.18           O  
ATOM   1819  CB  LEU B   9      69.045  98.005 158.578  1.00 28.80           C  
ATOM   1820  CG  LEU B   9      69.261  97.898 157.065  1.00 30.40           C  
ATOM   1821  CD1 LEU B   9      69.275  96.444 156.620  1.00 29.95           C  
ATOM   1822  CD2 LEU B   9      68.164  98.674 156.351  1.00 29.55           C  
ATOM   1823  N   ALA B  10      66.108  96.351 157.904  1.00 30.52           N  
ATOM   1824  CA  ALA B  10      65.516  95.065 157.563  1.00 28.16           C  
ATOM   1825  C   ALA B  10      65.649  94.742 156.083  1.00 26.87           C  
ATOM   1826  O   ALA B  10      65.387  95.587 155.231  1.00 26.16           O  
ATOM   1827  CB  ALA B  10      64.041  95.049 157.966  1.00 26.37           C  
ATOM   1828  N   VAL B  11      66.072  93.513 155.795  1.00 25.55           N  
ATOM   1829  CA  VAL B  11      66.212  93.033 154.429  1.00 24.83           C  
ATOM   1830  C   VAL B  11      64.976  92.193 154.121  1.00 25.46           C  
ATOM   1831  O   VAL B  11      64.584  91.352 154.928  1.00 23.19           O  
ATOM   1832  CB  VAL B  11      67.442  92.117 154.262  1.00 25.88           C  
ATOM   1833  CG1 VAL B  11      67.400  91.433 152.895  1.00 23.49           C  
ATOM   1834  CG2 VAL B  11      68.717  92.920 154.427  1.00 27.61           C  
ATOM   1835  N   ILE B  12      64.369  92.416 152.959  1.00 25.06           N  
ATOM   1836  CA  ILE B  12      63.185  91.663 152.569  1.00 23.53           C  
ATOM   1837  C   ILE B  12      63.341  91.141 151.145  1.00 23.57           C  
ATOM   1838  O   ILE B  12      63.277  91.914 150.193  1.00 22.48           O  
ATOM   1839  CB  ILE B  12      61.915  92.541 152.599  1.00 24.82           C  
ATOM   1840  CG1 ILE B  12      61.884  93.401 153.867  1.00 25.88           C  
ATOM   1841  CG2 ILE B  12      60.688  91.661 152.527  1.00 20.67           C  
ATOM   1842  CD1 ILE B  12      61.731  92.622 155.124  1.00 28.72           C  
ATOM   1843  N   THR B  13      63.544  89.834 150.998  1.00 22.86           N  
ATOM   1844  CA  THR B  13      63.681  89.238 149.674  1.00 22.76           C  
ATOM   1845  C   THR B  13      62.280  89.055 149.096  1.00 23.16           C  
ATOM   1846  O   THR B  13      61.345  88.747 149.830  1.00 23.45           O  
ATOM   1847  CB  THR B  13      64.381  87.869 149.743  1.00 24.30           C  
ATOM   1848  OG1 THR B  13      63.539  86.930 150.431  1.00 22.88           O  
ATOM   1849  CG2 THR B  13      65.725  87.998 150.477  1.00 22.30           C  
ATOM   1850  N   GLY B  14      62.140  89.252 147.787  1.00 24.26           N  
ATOM   1851  CA  GLY B  14      60.845  89.124 147.141  1.00 23.34           C  
ATOM   1852  C   GLY B  14      59.891  90.198 147.631  1.00 25.84           C  
ATOM   1853  O   GLY B  14      58.667  90.011 147.646  1.00 24.79           O  
ATOM   1854  N   GLY B  15      60.460  91.340 148.017  1.00 26.74           N  
ATOM   1855  CA  GLY B  15      59.665  92.433 148.543  1.00 27.31           C  
ATOM   1856  C   GLY B  15      59.008  93.411 147.589  1.00 28.62           C  
ATOM   1857  O   GLY B  15      58.394  94.381 148.040  1.00 29.78           O  
ATOM   1858  N   ALA B  16      59.109  93.179 146.285  1.00 28.49           N  
ATOM   1859  CA  ALA B  16      58.497  94.096 145.324  1.00 28.09           C  
ATOM   1860  C   ALA B  16      56.971  94.051 145.335  1.00 28.16           C  
ATOM   1861  O   ALA B  16      56.307  95.088 145.253  1.00 30.45           O  
ATOM   1862  CB  ALA B  16      59.012  93.809 143.916  1.00 27.58           C  
ATOM   1863  N   ASN B  17      56.409  92.856 145.457  1.00 28.53           N  
ATOM   1864  CA  ASN B  17      54.960  92.708 145.440  1.00 28.21           C  
ATOM   1865  C   ASN B  17      54.424  91.804 146.542  1.00 27.51           C  
ATOM   1866  O   ASN B  17      55.179  91.264 147.351  1.00 26.86           O  
ATOM   1867  CB  ASN B  17      54.525  92.134 144.091  1.00 30.57           C  
ATOM   1868  CG  ASN B  17      55.203  92.808 142.924  1.00 33.19           C  
ATOM   1869  OD1 ASN B  17      55.688  92.141 142.011  1.00 34.48           O  
ATOM   1870  ND2 ASN B  17      55.238  94.140 142.940  1.00 36.43           N  
ATOM   1871  N   GLY B  18      53.103  91.649 146.541  1.00 25.82           N  
ATOM   1872  CA  GLY B  18      52.414  90.800 147.496  1.00 24.64           C  
ATOM   1873  C   GLY B  18      52.795  90.879 148.962  1.00 24.74           C  
ATOM   1874  O   GLY B  18      52.913  91.962 149.538  1.00 23.16           O  
ATOM   1875  N   ILE B  19      52.974  89.705 149.568  1.00 25.32           N  
ATOM   1876  CA  ILE B  19      53.320  89.599 150.984  1.00 24.76           C  
ATOM   1877  C   ILE B  19      54.616  90.310 151.363  1.00 23.21           C  
ATOM   1878  O   ILE B  19      54.649  91.065 152.335  1.00 21.47           O  
ATOM   1879  CB  ILE B  19      53.417  88.117 151.409  1.00 26.06           C  
ATOM   1880  CG1 ILE B  19      52.042  87.459 151.284  1.00 26.31           C  
ATOM   1881  CG2 ILE B  19      53.932  88.005 152.842  1.00 26.03           C  
ATOM   1882  CD1 ILE B  19      52.026  86.010 151.700  1.00 28.44           C  
ATOM   1883  N   GLY B  20      55.676  90.063 150.598  1.00 22.68           N  
ATOM   1884  CA  GLY B  20      56.958  90.686 150.878  1.00 23.61           C  
ATOM   1885  C   GLY B  20      56.850  92.193 150.935  1.00 24.65           C  
ATOM   1886  O   GLY B  20      57.343  92.831 151.868  1.00 25.94           O  
ATOM   1887  N   ARG B  21      56.192  92.764 149.932  1.00 24.59           N  
ATOM   1888  CA  ARG B  21      56.002  94.201 149.860  1.00 24.40           C  
ATOM   1889  C   ARG B  21      55.176  94.718 151.036  1.00 24.18           C  
ATOM   1890  O   ARG B  21      55.511  95.745 151.638  1.00 24.86           O  
ATOM   1891  CB  ARG B  21      55.314  94.579 148.554  1.00 25.83           C  
ATOM   1892  CG  ARG B  21      54.843  96.015 148.542  1.00 29.08           C  
ATOM   1893  CD  ARG B  21      54.159  96.404 147.241  1.00 30.62           C  
ATOM   1894  NE  ARG B  21      53.598  97.744 147.368  1.00 34.62           N  
ATOM   1895  CZ  ARG B  21      52.893  98.360 146.428  1.00 37.45           C  
ATOM   1896  NH1 ARG B  21      52.655  97.756 145.269  1.00 40.67           N  
ATOM   1897  NH2 ARG B  21      52.424  99.581 146.650  1.00 37.44           N  
ATOM   1898  N   ALA B  22      54.094  94.018 151.362  1.00 22.00           N  
ATOM   1899  CA  ALA B  22      53.255  94.438 152.472  1.00 21.28           C  
ATOM   1900  C   ALA B  22      54.071  94.420 153.761  1.00 21.00           C  
ATOM   1901  O   ALA B  22      53.958  95.326 154.585  1.00 21.98           O  
ATOM   1902  CB  ALA B  22      52.031  93.523 152.599  1.00 19.96           C  
ATOM   1903  N   ILE B  23      54.895  93.392 153.938  1.00 21.01           N  
ATOM   1904  CA  ILE B  23      55.718  93.307 155.147  1.00 21.09           C  
ATOM   1905  C   ILE B  23      56.756  94.428 155.185  1.00 21.78           C  
ATOM   1906  O   ILE B  23      57.027  94.992 156.246  1.00 22.07           O  
ATOM   1907  CB  ILE B  23      56.433  91.931 155.264  1.00 19.34           C  
ATOM   1908  CG1 ILE B  23      55.402  90.834 155.556  1.00 15.13           C  
ATOM   1909  CG2 ILE B  23      57.485  91.978 156.372  1.00 18.72           C  
ATOM   1910  CD1 ILE B  23      55.972  89.437 155.577  1.00 13.57           C  
ATOM   1911  N   ALA B  24      57.328  94.752 154.026  1.00 22.25           N  
ATOM   1912  CA  ALA B  24      58.323  95.819 153.938  1.00 20.95           C  
ATOM   1913  C   ALA B  24      57.685  97.121 154.396  1.00 21.40           C  
ATOM   1914  O   ALA B  24      58.224  97.829 155.249  1.00 24.44           O  
ATOM   1915  CB  ALA B  24      58.823  95.961 152.511  1.00 18.49           C  
ATOM   1916  N   GLU B  25      56.522  97.424 153.834  1.00 21.13           N  
ATOM   1917  CA  GLU B  25      55.801  98.641 154.176  1.00 22.03           C  
ATOM   1918  C   GLU B  25      55.454  98.740 155.658  1.00 22.47           C  
ATOM   1919  O   GLU B  25      55.603  99.802 156.259  1.00 24.15           O  
ATOM   1920  CB  GLU B  25      54.547  98.765 153.300  1.00 21.67           C  
ATOM   1921  CG  GLU B  25      54.898  99.234 151.891  1.00 23.38           C  
ATOM   1922  CD  GLU B  25      53.709  99.339 150.951  1.00 27.24           C  
ATOM   1923  OE1 GLU B  25      52.600  99.704 151.404  1.00 27.51           O  
ATOM   1924  OE2 GLU B  25      53.897  99.073 149.741  1.00 26.77           O  
ATOM   1925  N   ARG B  26      55.007  97.640 156.259  1.00 22.70           N  
ATOM   1926  CA  ARG B  26      54.675  97.650 157.680  1.00 22.00           C  
ATOM   1927  C   ARG B  26      55.920  97.877 158.546  1.00 22.65           C  
ATOM   1928  O   ARG B  26      55.866  98.577 159.552  1.00 23.79           O  
ATOM   1929  CB  ARG B  26      54.001  96.332 158.077  1.00 20.99           C  
ATOM   1930  CG  ARG B  26      53.835  96.122 159.586  1.00 19.47           C  
ATOM   1931  CD  ARG B  26      53.054  97.250 160.242  1.00 19.22           C  
ATOM   1932  NE  ARG B  26      52.704  96.965 161.638  1.00 20.08           N  
ATOM   1933  CZ  ARG B  26      51.673  96.212 162.021  1.00 19.17           C  
ATOM   1934  NH1 ARG B  26      50.872  95.655 161.119  1.00 16.46           N  
ATOM   1935  NH2 ARG B  26      51.442  96.016 163.312  1.00 18.78           N  
ATOM   1936  N   PHE B  27      57.045  97.289 158.159  1.00 23.96           N  
ATOM   1937  CA  PHE B  27      58.262  97.462 158.941  1.00 24.63           C  
ATOM   1938  C   PHE B  27      58.706  98.921 158.940  1.00 25.68           C  
ATOM   1939  O   PHE B  27      59.216  99.421 159.944  1.00 24.68           O  
ATOM   1940  CB  PHE B  27      59.382  96.561 158.405  1.00 23.54           C  
ATOM   1941  CG  PHE B  27      59.286  95.135 158.871  1.00 25.05           C  
ATOM   1942  CD1 PHE B  27      60.295  94.228 158.589  1.00 24.70           C  
ATOM   1943  CD2 PHE B  27      58.188  94.701 159.602  1.00 24.62           C  
ATOM   1944  CE1 PHE B  27      60.208  92.916 159.025  1.00 23.92           C  
ATOM   1945  CE2 PHE B  27      58.100  93.392 160.039  1.00 22.11           C  
ATOM   1946  CZ  PHE B  27      59.112  92.500 159.748  1.00 22.13           C  
ATOM   1947  N   ALA B  28      58.503  99.597 157.813  1.00 25.55           N  
ATOM   1948  CA  ALA B  28      58.864 101.002 157.693  1.00 27.52           C  
ATOM   1949  C   ALA B  28      57.981 101.817 158.625  1.00 29.13           C  
ATOM   1950  O   ALA B  28      58.463 102.685 159.349  1.00 29.13           O  
ATOM   1951  CB  ALA B  28      58.679 101.477 156.256  1.00 25.10           C  
ATOM   1952  N   VAL B  29      56.681 101.533 158.601  1.00 31.03           N  
ATOM   1953  CA  VAL B  29      55.733 102.245 159.447  1.00 32.51           C  
ATOM   1954  C   VAL B  29      56.154 102.158 160.906  1.00 32.04           C  
ATOM   1955  O   VAL B  29      55.903 103.073 161.689  1.00 31.84           O  
ATOM   1956  CB  VAL B  29      54.314 101.656 159.336  1.00 34.43           C  
ATOM   1957  CG1 VAL B  29      53.371 102.436 160.221  1.00 34.68           C  
ATOM   1958  CG2 VAL B  29      53.838 101.689 157.895  1.00 36.17           C  
ATOM   1959  N   GLU B  30      56.798 101.050 161.262  1.00 32.11           N  
ATOM   1960  CA  GLU B  30      57.251 100.822 162.633  1.00 31.89           C  
ATOM   1961  C   GLU B  30      58.621 101.438 162.889  1.00 31.62           C  
ATOM   1962  O   GLU B  30      59.249 101.164 163.912  1.00 32.10           O  
ATOM   1963  CB  GLU B  30      57.287  99.319 162.932  1.00 32.22           C  
ATOM   1964  CG  GLU B  30      55.951  98.615 162.697  1.00 32.78           C  
ATOM   1965  CD  GLU B  30      55.269  98.169 163.977  1.00 32.09           C  
ATOM   1966  OE1 GLU B  30      54.108  97.716 163.905  1.00 32.19           O  
ATOM   1967  OE2 GLU B  30      55.890  98.258 165.054  1.00 34.48           O  
ATOM   1968  N   GLY B  31      59.083 102.255 161.945  1.00 31.05           N  
ATOM   1969  CA  GLY B  31      60.360 102.933 162.094  1.00 31.17           C  
ATOM   1970  C   GLY B  31      61.611 102.265 161.551  1.00 31.82           C  
ATOM   1971  O   GLY B  31      62.717 102.595 161.981  1.00 33.82           O  
ATOM   1972  N   ALA B  32      61.464 101.351 160.598  1.00 30.55           N  
ATOM   1973  CA  ALA B  32      62.626 100.661 160.047  1.00 28.49           C  
ATOM   1974  C   ALA B  32      62.951 101.034 158.609  1.00 28.02           C  
ATOM   1975  O   ALA B  32      62.059 101.321 157.813  1.00 27.98           O  
ATOM   1976  CB  ALA B  32      62.424  99.148 160.144  1.00 28.02           C  
ATOM   1977  N   ASP B  33      64.242 101.037 158.288  1.00 28.09           N  
ATOM   1978  CA  ASP B  33      64.706 101.312 156.930  1.00 27.84           C  
ATOM   1979  C   ASP B  33      64.640  99.976 156.176  1.00 26.02           C  
ATOM   1980  O   ASP B  33      64.696  98.907 156.789  1.00 23.46           O  
ATOM   1981  CB  ASP B  33      66.131 101.874 156.956  1.00 28.58           C  
ATOM   1982  CG  ASP B  33      66.169 103.327 157.397  1.00 30.02           C  
ATOM   1983  OD1 ASP B  33      67.188 103.757 157.979  1.00 29.84           O  
ATOM   1984  OD2 ASP B  33      65.175 104.044 157.151  1.00 28.77           O  
ATOM   1985  N   ILE B  34      64.535 100.037 154.853  1.00 25.63           N  
ATOM   1986  CA  ILE B  34      64.379  98.827 154.060  1.00 24.14           C  
ATOM   1987  C   ILE B  34      65.360  98.586 152.919  1.00 25.58           C  
ATOM   1988  O   ILE B  34      65.720  99.499 152.181  1.00 25.47           O  
ATOM   1989  CB  ILE B  34      62.962  98.783 153.442  1.00 23.13           C  
ATOM   1990  CG1 ILE B  34      61.900  99.074 154.511  1.00 22.65           C  
ATOM   1991  CG2 ILE B  34      62.723  97.432 152.803  1.00 22.99           C  
ATOM   1992  CD1 ILE B  34      61.774  98.002 155.584  1.00 23.48           C  
ATOM   1993  N   ALA B  35      65.761  97.326 152.775  1.00 27.06           N  
ATOM   1994  CA  ALA B  35      66.650  96.887 151.709  1.00 27.10           C  
ATOM   1995  C   ALA B  35      65.941  95.703 151.048  1.00 28.32           C  
ATOM   1996  O   ALA B  35      65.876  94.603 151.602  1.00 28.43           O  
ATOM   1997  CB  ALA B  35      67.996  96.451 152.270  1.00 26.79           C  
ATOM   1998  N   ILE B  36      65.407  95.942 149.857  1.00 27.28           N  
ATOM   1999  CA  ILE B  36      64.687  94.926 149.122  1.00 25.23           C  
ATOM   2000  C   ILE B  36      65.544  94.254 148.073  1.00 26.69           C  
ATOM   2001  O   ILE B  36      66.260  94.920 147.325  1.00 28.73           O  
ATOM   2002  CB  ILE B  36      63.452  95.537 148.436  1.00 24.96           C  
ATOM   2003  CG1 ILE B  36      62.444  95.983 149.495  1.00 24.96           C  
ATOM   2004  CG2 ILE B  36      62.842  94.543 147.477  1.00 24.47           C  
ATOM   2005  CD1 ILE B  36      61.247  96.711 148.939  1.00 25.82           C  
ATOM   2006  N   ALA B  37      65.480  92.926 148.032  1.00 25.49           N  
ATOM   2007  CA  ALA B  37      66.222  92.149 147.047  1.00 26.14           C  
ATOM   2008  C   ALA B  37      65.143  91.460 146.220  1.00 26.24           C  
ATOM   2009  O   ALA B  37      64.264  90.802 146.778  1.00 26.96           O  
ATOM   2010  CB  ALA B  37      67.114  91.126 147.736  1.00 24.14           C  
ATOM   2011  N   ASP B  38      65.190  91.620 144.900  1.00 25.98           N  
ATOM   2012  CA  ASP B  38      64.163  91.029 144.048  1.00 29.65           C  
ATOM   2013  C   ASP B  38      64.571  90.984 142.571  1.00 32.23           C  
ATOM   2014  O   ASP B  38      65.418  91.757 142.125  1.00 32.91           O  
ATOM   2015  CB  ASP B  38      62.867  91.837 144.200  1.00 28.33           C  
ATOM   2016  CG  ASP B  38      61.634  91.071 143.756  1.00 29.53           C  
ATOM   2017  OD1 ASP B  38      61.596  90.606 142.595  1.00 30.33           O  
ATOM   2018  OD2 ASP B  38      60.691  90.943 144.571  1.00 27.15           O  
ATOM   2019  N   LEU B  39      63.961  90.078 141.814  1.00 34.89           N  
ATOM   2020  CA  LEU B  39      64.259  89.960 140.389  1.00 38.63           C  
ATOM   2021  C   LEU B  39      63.673  91.122 139.596  1.00 40.13           C  
ATOM   2022  O   LEU B  39      64.251  91.554 138.597  1.00 41.87           O  
ATOM   2023  CB  LEU B  39      63.706  88.648 139.829  1.00 40.24           C  
ATOM   2024  CG  LEU B  39      64.475  87.370 140.172  1.00 42.02           C  
ATOM   2025  CD1 LEU B  39      63.744  86.166 139.597  1.00 42.18           C  
ATOM   2026  CD2 LEU B  39      65.897  87.460 139.620  1.00 41.59           C  
ATOM   2027  N   VAL B  40      62.527  91.628 140.042  1.00 40.27           N  
ATOM   2028  CA  VAL B  40      61.866  92.732 139.357  1.00 40.47           C  
ATOM   2029  C   VAL B  40      61.978  94.025 140.142  1.00 42.04           C  
ATOM   2030  O   VAL B  40      62.282  94.015 141.333  1.00 42.89           O  
ATOM   2031  CB  VAL B  40      60.362  92.441 139.139  1.00 39.88           C  
ATOM   2032  CG1 VAL B  40      60.188  91.135 138.373  1.00 38.51           C  
ATOM   2033  CG2 VAL B  40      59.646  92.388 140.479  1.00 35.76           C  
ATOM   2034  N   PRO B  41      61.739  95.163 139.476  1.00 43.92           N  
ATOM   2035  CA  PRO B  41      61.805  96.485 140.106  1.00 44.24           C  
ATOM   2036  C   PRO B  41      60.677  96.691 141.118  1.00 43.86           C  
ATOM   2037  O   PRO B  41      59.561  96.203 140.930  1.00 44.46           O  
ATOM   2038  CB  PRO B  41      61.711  97.440 138.914  1.00 44.14           C  
ATOM   2039  CG  PRO B  41      60.896  96.664 137.926  1.00 45.57           C  
ATOM   2040  CD  PRO B  41      61.503  95.287 138.027  1.00 44.77           C  
ATOM   2041  N   ALA B  42      60.977  97.423 142.188  1.00 43.02           N  
ATOM   2042  CA  ALA B  42      60.003  97.684 143.240  1.00 42.45           C  
ATOM   2043  C   ALA B  42      59.679  99.166 143.373  1.00 41.40           C  
ATOM   2044  O   ALA B  42      59.772  99.732 144.456  1.00 40.45           O  
ATOM   2045  CB  ALA B  42      60.527  97.147 144.570  1.00 43.32           C  
ATOM   2046  N   PRO B  43      59.270  99.809 142.271  1.00 42.78           N  
ATOM   2047  CA  PRO B  43      58.937 101.237 142.299  1.00 42.02           C  
ATOM   2048  C   PRO B  43      57.800 101.610 143.247  1.00 41.89           C  
ATOM   2049  O   PRO B  43      57.864 102.636 143.917  1.00 41.81           O  
ATOM   2050  CB  PRO B  43      58.602 101.535 140.840  1.00 42.65           C  
ATOM   2051  CG  PRO B  43      58.007 100.233 140.365  1.00 41.26           C  
ATOM   2052  CD  PRO B  43      58.966  99.225 140.951  1.00 42.17           C  
ATOM   2053  N   GLU B  44      56.761 100.780 143.306  1.00 42.62           N  
ATOM   2054  CA  GLU B  44      55.626 101.062 144.182  1.00 42.92           C  
ATOM   2055  C   GLU B  44      55.999 100.891 145.653  1.00 43.07           C  
ATOM   2056  O   GLU B  44      55.514 101.623 146.515  1.00 42.99           O  
ATOM   2057  CB  GLU B  44      54.442 100.147 143.847  1.00 45.49           C  
ATOM   2058  CG  GLU B  44      54.103 100.064 142.368  1.00 47.68           C  
ATOM   2059  CD  GLU B  44      54.745  98.864 141.692  1.00 50.76           C  
ATOM   2060  OE1 GLU B  44      55.973  98.675 141.838  1.00 50.92           O  
ATOM   2061  OE2 GLU B  44      54.019  98.108 141.014  1.00 52.25           O  
ATOM   2062  N   ALA B  45      56.860  99.920 145.938  1.00 42.52           N  
ATOM   2063  CA  ALA B  45      57.293  99.667 147.308  1.00 40.99           C  
ATOM   2064  C   ALA B  45      58.157 100.819 147.822  1.00 40.30           C  
ATOM   2065  O   ALA B  45      57.944 101.325 148.927  1.00 38.84           O  
ATOM   2066  CB  ALA B  45      58.069  98.349 147.378  1.00 39.36           C  
ATOM   2067  N   GLU B  46      59.131 101.232 147.014  1.00 39.67           N  
ATOM   2068  CA  GLU B  46      60.026 102.324 147.399  1.00 39.09           C  
ATOM   2069  C   GLU B  46      59.258 103.583 147.741  1.00 36.65           C  
ATOM   2070  O   GLU B  46      59.384 104.124 148.835  1.00 36.97           O  
ATOM   2071  CB  GLU B  46      60.999 102.653 146.274  1.00 38.25           C  
ATOM   2072  CG  GLU B  46      62.004 101.581 145.976  1.00 41.41           C  
ATOM   2073  CD  GLU B  46      63.035 102.054 144.983  1.00 44.89           C  
ATOM   2074  OE1 GLU B  46      62.637 102.445 143.866  1.00 46.61           O  
ATOM   2075  OE2 GLU B  46      64.239 102.045 145.319  1.00 47.10           O  
ATOM   2076  N   ALA B  47      58.466 104.053 146.786  1.00 35.50           N  
ATOM   2077  CA  ALA B  47      57.685 105.263 146.989  1.00 34.35           C  
ATOM   2078  C   ALA B  47      56.944 105.207 148.318  1.00 33.38           C  
ATOM   2079  O   ALA B  47      57.086 106.099 149.147  1.00 34.86           O  
ATOM   2080  CB  ALA B  47      56.703 105.454 145.835  1.00 32.50           C  
ATOM   2081  N   ALA B  48      56.161 104.154 148.523  1.00 32.66           N  
ATOM   2082  CA  ALA B  48      55.404 104.006 149.758  1.00 32.01           C  
ATOM   2083  C   ALA B  48      56.307 104.165 150.973  1.00 31.29           C  
ATOM   2084  O   ALA B  48      55.979 104.872 151.921  1.00 30.79           O  
ATOM   2085  CB  ALA B  48      54.717 102.643 149.792  1.00 32.89           C  
ATOM   2086  N   ILE B  49      57.456 103.505 150.931  1.00 32.84           N  
ATOM   2087  CA  ILE B  49      58.399 103.562 152.036  1.00 33.77           C  
ATOM   2088  C   ILE B  49      59.009 104.949 152.210  1.00 35.27           C  
ATOM   2089  O   ILE B  49      59.127 105.443 153.334  1.00 35.90           O  
ATOM   2090  CB  ILE B  49      59.502 102.501 151.852  1.00 32.40           C  
ATOM   2091  CG1 ILE B  49      58.855 101.111 151.815  1.00 31.81           C  
ATOM   2092  CG2 ILE B  49      60.517 102.584 152.988  1.00 30.37           C  
ATOM   2093  CD1 ILE B  49      59.808  99.984 151.481  1.00 29.56           C  
ATOM   2094  N   ARG B  50      59.394 105.587 151.108  1.00 36.44           N  
ATOM   2095  CA  ARG B  50      59.974 106.924 151.199  1.00 37.00           C  
ATOM   2096  C   ARG B  50      58.881 107.860 151.710  1.00 37.57           C  
ATOM   2097  O   ARG B  50      59.133 108.747 152.528  1.00 38.01           O  
ATOM   2098  CB  ARG B  50      60.466 107.415 149.831  1.00 35.61           C  
ATOM   2099  CG  ARG B  50      61.527 106.550 149.135  1.00 37.08           C  
ATOM   2100  CD  ARG B  50      61.947 107.224 147.827  1.00 38.24           C  
ATOM   2101  NE  ARG B  50      62.481 106.311 146.819  1.00 39.14           N  
ATOM   2102  CZ  ARG B  50      63.700 105.776 146.851  1.00 42.53           C  
ATOM   2103  NH1 ARG B  50      64.535 106.055 147.848  1.00 43.18           N  
ATOM   2104  NH2 ARG B  50      64.089 104.964 145.875  1.00 40.81           N  
ATOM   2105  N   ASN B  51      57.660 107.640 151.231  1.00 38.78           N  
ATOM   2106  CA  ASN B  51      56.524 108.460 151.630  1.00 39.73           C  
ATOM   2107  C   ASN B  51      56.108 108.211 153.078  1.00 39.69           C  
ATOM   2108  O   ASN B  51      55.120 108.766 153.554  1.00 40.32           O  
ATOM   2109  CB  ASN B  51      55.344 108.224 150.680  1.00 41.96           C  
ATOM   2110  CG  ASN B  51      55.637 108.685 149.251  1.00 44.13           C  
ATOM   2111  OD1 ASN B  51      56.176 109.772 149.033  1.00 46.46           O  
ATOM   2112  ND2 ASN B  51      55.270 107.866 148.274  1.00 45.08           N  
ATOM   2113  N   LEU B  52      56.865 107.371 153.774  1.00 39.57           N  
ATOM   2114  CA  LEU B  52      56.595 107.075 155.178  1.00 39.23           C  
ATOM   2115  C   LEU B  52      57.730 107.655 156.017  1.00 39.10           C  
ATOM   2116  O   LEU B  52      57.797 107.443 157.224  1.00 38.85           O  
ATOM   2117  CB  LEU B  52      56.485 105.562 155.409  1.00 40.10           C  
ATOM   2118  CG  LEU B  52      55.238 104.829 154.882  1.00 41.41           C  
ATOM   2119  CD1 LEU B  52      55.524 103.340 154.776  1.00 42.51           C  
ATOM   2120  CD2 LEU B  52      54.051 105.072 155.797  1.00 40.56           C  
ATOM   2121  N   GLY B  53      58.625 108.387 155.357  1.00 39.11           N  
ATOM   2122  CA  GLY B  53      59.739 109.015 156.045  1.00 38.31           C  
ATOM   2123  C   GLY B  53      60.927 108.127 156.361  1.00 38.06           C  
ATOM   2124  O   GLY B  53      61.758 108.478 157.200  1.00 38.33           O  
ATOM   2125  N   ARG B  54      61.020 106.983 155.694  1.00 37.63           N  
ATOM   2126  CA  ARG B  54      62.125 106.060 155.925  1.00 38.43           C  
ATOM   2127  C   ARG B  54      62.950 105.895 154.651  1.00 38.45           C  
ATOM   2128  O   ARG B  54      62.507 106.267 153.564  1.00 38.60           O  
ATOM   2129  CB  ARG B  54      61.583 104.702 156.379  1.00 39.26           C  
ATOM   2130  CG  ARG B  54      60.847 104.724 157.712  1.00 40.35           C  
ATOM   2131  CD  ARG B  54      61.758 104.319 158.869  1.00 45.02           C  
ATOM   2132  NE  ARG B  54      62.787 105.313 159.144  1.00 48.95           N  
ATOM   2133  CZ  ARG B  54      62.559 106.471 159.756  1.00 51.97           C  
ATOM   2134  NH1 ARG B  54      61.335 106.775 160.163  1.00 52.26           N  
ATOM   2135  NH2 ARG B  54      63.550 107.334 159.942  1.00 53.78           N  
ATOM   2136  N   ARG B  55      64.151 105.340 154.789  1.00 38.74           N  
ATOM   2137  CA  ARG B  55      65.030 105.128 153.644  1.00 38.87           C  
ATOM   2138  C   ARG B  55      64.863 103.728 153.066  1.00 37.49           C  
ATOM   2139  O   ARG B  55      64.626 102.766 153.795  1.00 37.25           O  
ATOM   2140  CB  ARG B  55      66.495 105.344 154.045  1.00 42.34           C  
ATOM   2141  CG  ARG B  55      66.760 106.684 154.718  1.00 48.20           C  
ATOM   2142  CD  ARG B  55      68.245 107.031 154.750  1.00 53.86           C  
ATOM   2143  NE  ARG B  55      69.070 105.988 155.359  1.00 56.98           N  
ATOM   2144  CZ  ARG B  55      70.371 106.123 155.606  1.00 59.96           C  
ATOM   2145  NH1 ARG B  55      71.058 105.131 156.160  1.00 60.12           N  
ATOM   2146  NH2 ARG B  55      70.986 107.263 155.307  1.00 60.75           N  
ATOM   2147  N   VAL B  56      64.997 103.614 151.751  1.00 36.39           N  
ATOM   2148  CA  VAL B  56      64.855 102.324 151.096  1.00 35.56           C  
ATOM   2149  C   VAL B  56      65.892 102.074 150.008  1.00 35.29           C  
ATOM   2150  O   VAL B  56      66.359 102.997 149.344  1.00 34.70           O  
ATOM   2151  CB  VAL B  56      63.454 102.173 150.470  1.00 34.56           C  
ATOM   2152  CG1 VAL B  56      63.204 103.299 149.485  1.00 33.13           C  
ATOM   2153  CG2 VAL B  56      63.340 100.823 149.780  1.00 31.85           C  
ATOM   2154  N   LEU B  57      66.241 100.806 149.839  1.00 34.66           N  
ATOM   2155  CA  LEU B  57      67.201 100.386 148.831  1.00 33.90           C  
ATOM   2156  C   LEU B  57      66.634  99.162 148.133  1.00 33.37           C  
ATOM   2157  O   LEU B  57      66.300  98.171 148.776  1.00 31.21           O  
ATOM   2158  CB  LEU B  57      68.543 100.031 149.479  1.00 35.24           C  
ATOM   2159  CG  LEU B  57      69.566  99.299 148.609  1.00 35.92           C  
ATOM   2160  CD1 LEU B  57      69.904 100.132 147.384  1.00 35.78           C  
ATOM   2161  CD2 LEU B  57      70.816  99.019 149.429  1.00 38.29           C  
ATOM   2162  N   THR B  58      66.521  99.244 146.815  1.00 33.65           N  
ATOM   2163  CA  THR B  58      66.007  98.139 146.024  1.00 35.05           C  
ATOM   2164  C   THR B  58      67.089  97.659 145.073  1.00 35.74           C  
ATOM   2165  O   THR B  58      67.702  98.456 144.366  1.00 37.18           O  
ATOM   2166  CB  THR B  58      64.778  98.566 145.211  1.00 35.58           C  
ATOM   2167  OG1 THR B  58      63.658  98.722 146.091  1.00 34.99           O  
ATOM   2168  CG2 THR B  58      64.460  97.530 144.149  1.00 36.34           C  
ATOM   2169  N   VAL B  59      67.321  96.353 145.061  1.00 36.75           N  
ATOM   2170  CA  VAL B  59      68.339  95.773 144.201  1.00 37.93           C  
ATOM   2171  C   VAL B  59      67.815  94.615 143.352  1.00 39.74           C  
ATOM   2172  O   VAL B  59      67.111  93.731 143.852  1.00 38.73           O  
ATOM   2173  CB  VAL B  59      69.528  95.259 145.040  1.00 38.19           C  
ATOM   2174  CG1 VAL B  59      70.582  94.645 144.132  1.00 36.88           C  
ATOM   2175  CG2 VAL B  59      70.111  96.397 145.858  1.00 38.28           C  
ATOM   2176  N   LYS B  60      68.150  94.638 142.064  1.00 41.49           N  
ATOM   2177  CA  LYS B  60      67.760  93.569 141.147  1.00 43.60           C  
ATOM   2178  C   LYS B  60      68.714  92.432 141.471  1.00 43.80           C  
ATOM   2179  O   LYS B  60      69.870  92.447 141.047  1.00 45.73           O  
ATOM   2180  CB  LYS B  60      67.961  93.994 139.695  1.00 45.18           C  
ATOM   2181  CG  LYS B  60      67.900  92.837 138.709  1.00 48.74           C  
ATOM   2182  CD  LYS B  60      68.249  93.290 137.298  1.00 52.44           C  
ATOM   2183  CE  LYS B  60      68.260  92.125 136.317  1.00 52.67           C  
ATOM   2184  NZ  LYS B  60      68.538  92.582 134.921  1.00 55.35           N  
ATOM   2185  N   CYS B  61      68.235  91.449 142.221  1.00 42.70           N  
ATOM   2186  CA  CYS B  61      69.089  90.343 142.628  1.00 41.59           C  
ATOM   2187  C   CYS B  61      68.403  88.979 142.580  1.00 39.69           C  
ATOM   2188  O   CYS B  61      67.223  88.860 142.896  1.00 38.81           O  
ATOM   2189  CB  CYS B  61      69.597  90.623 144.047  1.00 40.68           C  
ATOM   2190  SG  CYS B  61      70.541  89.301 144.813  1.00 47.57           S  
ATOM   2191  N   ASP B  62      69.152  87.958 142.169  1.00 37.87           N  
ATOM   2192  CA  ASP B  62      68.637  86.593 142.111  1.00 36.83           C  
ATOM   2193  C   ASP B  62      69.125  85.944 143.396  1.00 34.48           C  
ATOM   2194  O   ASP B  62      70.246  85.447 143.462  1.00 34.42           O  
ATOM   2195  CB  ASP B  62      69.208  85.839 140.903  1.00 36.78           C  
ATOM   2196  CG  ASP B  62      68.621  84.433 140.752  1.00 37.82           C  
ATOM   2197  OD1 ASP B  62      67.963  83.939 141.696  1.00 37.26           O  
ATOM   2198  OD2 ASP B  62      68.828  83.812 139.688  1.00 37.34           O  
ATOM   2199  N   VAL B  63      68.277  85.962 144.419  1.00 33.51           N  
ATOM   2200  CA  VAL B  63      68.622  85.408 145.723  1.00 31.88           C  
ATOM   2201  C   VAL B  63      69.130  83.967 145.728  1.00 30.85           C  
ATOM   2202  O   VAL B  63      69.651  83.495 146.740  1.00 30.65           O  
ATOM   2203  CB  VAL B  63      67.427  85.512 146.686  1.00 32.77           C  
ATOM   2204  CG1 VAL B  63      67.124  86.974 146.971  1.00 32.05           C  
ATOM   2205  CG2 VAL B  63      66.209  84.821 146.080  1.00 31.91           C  
ATOM   2206  N   SER B  64      68.984  83.267 144.609  1.00 29.23           N  
ATOM   2207  CA  SER B  64      69.446  81.884 144.523  1.00 28.64           C  
ATOM   2208  C   SER B  64      70.924  81.808 144.148  1.00 28.66           C  
ATOM   2209  O   SER B  64      71.552  80.764 144.298  1.00 29.02           O  
ATOM   2210  CB  SER B  64      68.639  81.114 143.476  1.00 28.52           C  
ATOM   2211  OG  SER B  64      68.999  81.510 142.161  1.00 26.89           O  
ATOM   2212  N   GLN B  65      71.475  82.917 143.665  1.00 29.67           N  
ATOM   2213  CA  GLN B  65      72.872  82.953 143.242  1.00 31.13           C  
ATOM   2214  C   GLN B  65      73.820  83.548 144.277  1.00 31.33           C  
ATOM   2215  O   GLN B  65      73.700  84.718 144.659  1.00 31.84           O  
ATOM   2216  CB  GLN B  65      72.989  83.720 141.924  1.00 31.11           C  
ATOM   2217  CG  GLN B  65      72.084  83.172 140.826  1.00 33.50           C  
ATOM   2218  CD  GLN B  65      72.385  81.719 140.483  1.00 36.35           C  
ATOM   2219  OE1 GLN B  65      73.455  81.399 139.962  1.00 40.96           O  
ATOM   2220  NE2 GLN B  65      71.441  80.832 140.779  1.00 37.65           N  
ATOM   2221  N   PRO B  66      74.778  82.734 144.749  1.00 30.22           N  
ATOM   2222  CA  PRO B  66      75.788  83.108 145.745  1.00 29.42           C  
ATOM   2223  C   PRO B  66      76.430  84.461 145.426  1.00 29.33           C  
ATOM   2224  O   PRO B  66      76.560  85.317 146.299  1.00 29.08           O  
ATOM   2225  CB  PRO B  66      76.790  81.958 145.663  1.00 29.40           C  
ATOM   2226  CG  PRO B  66      75.915  80.785 145.346  1.00 30.15           C  
ATOM   2227  CD  PRO B  66      74.964  81.339 144.304  1.00 29.93           C  
ATOM   2228  N   GLY B  67      76.820  84.642 144.166  1.00 29.33           N  
ATOM   2229  CA  GLY B  67      77.441  85.887 143.749  1.00 28.58           C  
ATOM   2230  C   GLY B  67      76.548  87.092 143.974  1.00 29.37           C  
ATOM   2231  O   GLY B  67      76.972  88.088 144.561  1.00 30.91           O  
ATOM   2232  N   ASP B  68      75.305  87.010 143.512  1.00 29.76           N  
ATOM   2233  CA  ASP B  68      74.372  88.114 143.684  1.00 30.71           C  
ATOM   2234  C   ASP B  68      74.121  88.441 145.144  1.00 30.40           C  
ATOM   2235  O   ASP B  68      74.163  89.602 145.532  1.00 32.79           O  
ATOM   2236  CB  ASP B  68      73.041  87.814 143.004  1.00 33.53           C  
ATOM   2237  CG  ASP B  68      73.157  87.764 141.501  1.00 35.35           C  
ATOM   2238  OD1 ASP B  68      72.135  87.990 140.816  1.00 36.69           O  
ATOM   2239  OD2 ASP B  68      74.274  87.493 141.011  1.00 37.44           O  
ATOM   2240  N   VAL B  69      73.857  87.425 145.959  1.00 30.25           N  
ATOM   2241  CA  VAL B  69      73.608  87.669 147.376  1.00 28.61           C  
ATOM   2242  C   VAL B  69      74.807  88.356 148.024  1.00 29.63           C  
ATOM   2243  O   VAL B  69      74.644  89.270 148.826  1.00 26.68           O  
ATOM   2244  CB  VAL B  69      73.308  86.366 148.132  1.00 26.11           C  
ATOM   2245  CG1 VAL B  69      73.047  86.667 149.605  1.00 23.62           C  
ATOM   2246  CG2 VAL B  69      72.098  85.684 147.510  1.00 25.54           C  
ATOM   2247  N   GLU B  70      76.011  87.925 147.666  1.00 32.57           N  
ATOM   2248  CA  GLU B  70      77.216  88.524 148.225  1.00 34.07           C  
ATOM   2249  C   GLU B  70      77.315  90.001 147.833  1.00 32.74           C  
ATOM   2250  O   GLU B  70      77.591  90.856 148.671  1.00 31.23           O  
ATOM   2251  CB  GLU B  70      78.451  87.751 147.751  1.00 37.97           C  
ATOM   2252  CG  GLU B  70      79.762  88.254 148.331  1.00 44.79           C  
ATOM   2253  CD  GLU B  70      80.782  87.142 148.534  1.00 49.60           C  
ATOM   2254  OE1 GLU B  70      81.963  87.457 148.800  1.00 51.41           O  
ATOM   2255  OE2 GLU B  70      80.404  85.952 148.439  1.00 53.92           O  
ATOM   2256  N   ALA B  71      77.080  90.302 146.559  1.00 31.86           N  
ATOM   2257  CA  ALA B  71      77.133  91.683 146.097  1.00 30.78           C  
ATOM   2258  C   ALA B  71      76.062  92.470 146.845  1.00 31.70           C  
ATOM   2259  O   ALA B  71      76.309  93.583 147.319  1.00 33.70           O  
ATOM   2260  CB  ALA B  71      76.888  91.749 144.592  1.00 29.79           C  
ATOM   2261  N   PHE B  72      74.873  91.882 146.957  1.00 30.07           N  
ATOM   2262  CA  PHE B  72      73.768  92.521 147.661  1.00 27.66           C  
ATOM   2263  C   PHE B  72      74.149  92.809 149.107  1.00 27.65           C  
ATOM   2264  O   PHE B  72      73.829  93.869 149.639  1.00 29.74           O  
ATOM   2265  CB  PHE B  72      72.530  91.626 147.648  1.00 25.72           C  
ATOM   2266  CG  PHE B  72      71.386  92.166 148.458  1.00 25.39           C  
ATOM   2267  CD1 PHE B  72      70.603  93.206 147.975  1.00 25.58           C  
ATOM   2268  CD2 PHE B  72      71.086  91.632 149.703  1.00 24.93           C  
ATOM   2269  CE1 PHE B  72      69.539  93.698 148.718  1.00 26.87           C  
ATOM   2270  CE2 PHE B  72      70.024  92.120 150.451  1.00 23.85           C  
ATOM   2271  CZ  PHE B  72      69.249  93.152 149.959  1.00 25.94           C  
ATOM   2272  N   GLY B  73      74.824  91.855 149.743  1.00 25.48           N  
ATOM   2273  CA  GLY B  73      75.231  92.028 151.127  1.00 26.50           C  
ATOM   2274  C   GLY B  73      76.123  93.242 151.320  1.00 29.34           C  
ATOM   2275  O   GLY B  73      75.942  94.015 152.261  1.00 28.00           O  
ATOM   2276  N   LYS B  74      77.090  93.412 150.420  1.00 32.04           N  
ATOM   2277  CA  LYS B  74      78.012  94.540 150.479  1.00 34.37           C  
ATOM   2278  C   LYS B  74      77.310  95.878 150.236  1.00 34.53           C  
ATOM   2279  O   LYS B  74      77.565  96.863 150.937  1.00 34.83           O  
ATOM   2280  CB  LYS B  74      79.132  94.347 149.455  1.00 35.46           C  
ATOM   2281  CG  LYS B  74      79.991  93.123 149.726  1.00 39.83           C  
ATOM   2282  CD  LYS B  74      81.158  93.015 148.755  1.00 42.62           C  
ATOM   2283  CE  LYS B  74      82.056  91.838 149.121  1.00 46.91           C  
ATOM   2284  NZ  LYS B  74      83.192  91.652 148.172  1.00 47.12           N  
ATOM   2285  N   GLN B  75      76.425  95.916 149.248  1.00 33.84           N  
ATOM   2286  CA  GLN B  75      75.708  97.144 148.941  1.00 33.27           C  
ATOM   2287  C   GLN B  75      74.872  97.586 150.138  1.00 32.81           C  
ATOM   2288  O   GLN B  75      74.726  98.782 150.397  1.00 34.23           O  
ATOM   2289  CB  GLN B  75      74.812  96.945 147.715  1.00 35.90           C  
ATOM   2290  CG  GLN B  75      74.323  98.245 147.094  1.00 40.35           C  
ATOM   2291  CD  GLN B  75      73.592  98.030 145.783  1.00 43.77           C  
ATOM   2292  OE1 GLN B  75      74.057  97.285 144.917  1.00 46.58           O  
ATOM   2293  NE2 GLN B  75      72.450  98.692 145.622  1.00 43.99           N  
ATOM   2294  N   VAL B  76      74.330  96.624 150.876  1.00 30.89           N  
ATOM   2295  CA  VAL B  76      73.521  96.943 152.041  1.00 31.45           C  
ATOM   2296  C   VAL B  76      74.368  97.515 153.178  1.00 32.28           C  
ATOM   2297  O   VAL B  76      73.988  98.490 153.821  1.00 31.66           O  
ATOM   2298  CB  VAL B  76      72.766  95.696 152.559  1.00 30.67           C  
ATOM   2299  CG1 VAL B  76      72.162  95.981 153.929  1.00 28.42           C  
ATOM   2300  CG2 VAL B  76      71.673  95.308 151.569  1.00 30.96           C  
ATOM   2301  N   ILE B  77      75.524  96.909 153.412  1.00 33.84           N  
ATOM   2302  CA  ILE B  77      76.412  97.350 154.475  1.00 35.53           C  
ATOM   2303  C   ILE B  77      76.991  98.749 154.264  1.00 37.08           C  
ATOM   2304  O   ILE B  77      77.079  99.536 155.208  1.00 37.92           O  
ATOM   2305  CB  ILE B  77      77.567  96.347 154.671  1.00 36.61           C  
ATOM   2306  CG1 ILE B  77      77.001  95.003 155.141  1.00 38.38           C  
ATOM   2307  CG2 ILE B  77      78.564  96.883 155.684  1.00 37.37           C  
ATOM   2308  CD1 ILE B  77      78.058  93.965 155.485  1.00 39.01           C  
ATOM   2309  N   SER B  78      77.383  99.074 153.036  1.00 37.07           N  
ATOM   2310  CA  SER B  78      77.953 100.392 152.782  1.00 37.94           C  
ATOM   2311  C   SER B  78      76.888 101.469 152.596  1.00 37.92           C  
ATOM   2312  O   SER B  78      77.205 102.639 152.409  1.00 40.04           O  
ATOM   2313  CB  SER B  78      78.887 100.352 151.563  1.00 36.89           C  
ATOM   2314  OG  SER B  78      78.222  99.888 150.406  1.00 37.82           O  
ATOM   2315  N   THR B  79      75.621 101.077 152.659  1.00 38.25           N  
ATOM   2316  CA  THR B  79      74.531 102.033 152.503  1.00 36.56           C  
ATOM   2317  C   THR B  79      73.819 102.290 153.825  1.00 36.69           C  
ATOM   2318  O   THR B  79      73.543 103.434 154.175  1.00 36.97           O  
ATOM   2319  CB  THR B  79      73.487 101.539 151.495  1.00 36.62           C  
ATOM   2320  OG1 THR B  79      74.070 101.481 150.188  1.00 35.74           O  
ATOM   2321  CG2 THR B  79      72.293 102.473 151.478  1.00 33.84           C  
ATOM   2322  N   PHE B  80      73.531 101.220 154.558  1.00 35.93           N  
ATOM   2323  CA  PHE B  80      72.843 101.336 155.836  1.00 35.46           C  
ATOM   2324  C   PHE B  80      73.722 100.950 157.013  1.00 35.77           C  
ATOM   2325  O   PHE B  80      73.494 101.392 158.139  1.00 34.54           O  
ATOM   2326  CB  PHE B  80      71.582 100.475 155.835  1.00 33.69           C  
ATOM   2327  CG  PHE B  80      70.588 100.872 154.791  1.00 32.36           C  
ATOM   2328  CD1 PHE B  80      70.548 100.220 153.571  1.00 31.05           C  
ATOM   2329  CD2 PHE B  80      69.710 101.915 155.020  1.00 31.28           C  
ATOM   2330  CE1 PHE B  80      69.651 100.598 152.600  1.00 32.54           C  
ATOM   2331  CE2 PHE B  80      68.807 102.303 154.052  1.00 33.57           C  
ATOM   2332  CZ  PHE B  80      68.776 101.644 152.838  1.00 33.83           C  
ATOM   2333  N   GLY B  81      74.725 100.120 156.750  1.00 36.16           N  
ATOM   2334  CA  GLY B  81      75.619  99.707 157.810  1.00 39.12           C  
ATOM   2335  C   GLY B  81      75.504  98.244 158.189  1.00 39.95           C  
ATOM   2336  O   GLY B  81      76.425  97.470 157.929  1.00 42.91           O  
ATOM   2337  N   ARG B  82      74.388  97.862 158.803  1.00 38.36           N  
ATOM   2338  CA  ARG B  82      74.188  96.477 159.221  1.00 37.98           C  
ATOM   2339  C   ARG B  82      72.723  96.068 159.251  1.00 35.44           C  
ATOM   2340  O   ARG B  82      71.852  96.872 159.568  1.00 38.16           O  
ATOM   2341  CB  ARG B  82      74.807  96.261 160.601  1.00 40.31           C  
ATOM   2342  CG  ARG B  82      74.481  94.926 161.248  1.00 42.47           C  
ATOM   2343  CD  ARG B  82      75.196  94.829 162.579  1.00 45.65           C  
ATOM   2344  NE  ARG B  82      74.879  95.973 163.429  1.00 47.80           N  
ATOM   2345  CZ  ARG B  82      73.763  96.080 164.140  1.00 47.55           C  
ATOM   2346  NH1 ARG B  82      72.872  95.102 164.098  1.00 48.02           N  
ATOM   2347  NH2 ARG B  82      73.532  97.160 164.874  1.00 46.41           N  
ATOM   2348  N   CYS B  83      72.465  94.806 158.931  1.00 33.30           N  
ATOM   2349  CA  CYS B  83      71.110  94.268 158.907  1.00 30.98           C  
ATOM   2350  C   CYS B  83      70.693  93.660 160.244  1.00 29.80           C  
ATOM   2351  O   CYS B  83      71.387  92.803 160.786  1.00 30.11           O  
ATOM   2352  CB  CYS B  83      70.996  93.206 157.816  1.00 30.59           C  
ATOM   2353  SG  CYS B  83      69.450  92.293 157.856  1.00 31.73           S  
ATOM   2354  N   ASP B  84      69.550  94.102 160.760  1.00 27.45           N  
ATOM   2355  CA  ASP B  84      69.026  93.612 162.033  1.00 24.43           C  
ATOM   2356  C   ASP B  84      67.915  92.575 161.837  1.00 22.63           C  
ATOM   2357  O   ASP B  84      67.774  91.639 162.622  1.00 19.71           O  
ATOM   2358  CB  ASP B  84      68.466  94.780 162.850  1.00 25.09           C  
ATOM   2359  CG  ASP B  84      69.464  95.907 163.015  1.00 25.86           C  
ATOM   2360  OD1 ASP B  84      69.202  97.032 162.537  1.00 26.92           O  
ATOM   2361  OD2 ASP B  84      70.518  95.664 163.620  1.00 24.60           O  
ATOM   2362  N   ILE B  85      67.140  92.749 160.772  1.00 20.43           N  
ATOM   2363  CA  ILE B  85      66.019  91.873 160.483  1.00 18.09           C  
ATOM   2364  C   ILE B  85      66.057  91.319 159.061  1.00 19.46           C  
ATOM   2365  O   ILE B  85      66.115  92.076 158.088  1.00 20.80           O  
ATOM   2366  CB  ILE B  85      64.690  92.646 160.696  1.00 17.42           C  
ATOM   2367  CG1 ILE B  85      64.661  93.220 162.117  1.00 14.20           C  
ATOM   2368  CG2 ILE B  85      63.479  91.731 160.440  1.00 11.72           C  
ATOM   2369  CD1 ILE B  85      63.620  94.313 162.324  1.00 11.87           C  
ATOM   2370  N   LEU B  86      66.026  89.994 158.951  1.00 17.61           N  
ATOM   2371  CA  LEU B  86      66.035  89.329 157.654  1.00 19.76           C  
ATOM   2372  C   LEU B  86      64.725  88.579 157.409  1.00 21.14           C  
ATOM   2373  O   LEU B  86      64.338  87.712 158.196  1.00 22.65           O  
ATOM   2374  CB  LEU B  86      67.205  88.341 157.560  1.00 18.40           C  
ATOM   2375  CG  LEU B  86      67.112  87.372 156.375  1.00 19.24           C  
ATOM   2376  CD1 LEU B  86      66.953  88.169 155.076  1.00 18.28           C  
ATOM   2377  CD2 LEU B  86      68.347  86.475 156.314  1.00 17.67           C  
ATOM   2378  N   VAL B  87      64.042  88.925 156.320  1.00 19.81           N  
ATOM   2379  CA  VAL B  87      62.793  88.273 155.961  1.00 17.76           C  
ATOM   2380  C   VAL B  87      63.024  87.531 154.657  1.00 18.71           C  
ATOM   2381  O   VAL B  87      63.227  88.146 153.615  1.00 19.05           O  
ATOM   2382  CB  VAL B  87      61.628  89.291 155.768  1.00 18.19           C  
ATOM   2383  CG1 VAL B  87      60.347  88.554 155.357  1.00 13.68           C  
ATOM   2384  CG2 VAL B  87      61.372  90.063 157.071  1.00 18.27           C  
ATOM   2385  N   ASN B  88      63.032  86.204 154.732  1.00 19.42           N  
ATOM   2386  CA  ASN B  88      63.228  85.362 153.558  1.00 19.73           C  
ATOM   2387  C   ASN B  88      61.840  85.067 153.011  1.00 22.15           C  
ATOM   2388  O   ASN B  88      61.149  84.149 153.466  1.00 21.91           O  
ATOM   2389  CB  ASN B  88      63.953  84.069 153.943  1.00 18.48           C  
ATOM   2390  CG  ASN B  88      65.425  84.297 154.247  1.00 20.78           C  
ATOM   2391  OD1 ASN B  88      66.153  84.877 153.435  1.00 19.11           O  
ATOM   2392  ND2 ASN B  88      65.875  83.838 155.417  1.00 17.46           N  
ATOM   2393  N   ASN B  89      61.439  85.861 152.027  1.00 21.92           N  
ATOM   2394  CA  ASN B  89      60.119  85.741 151.440  1.00 22.97           C  
ATOM   2395  C   ASN B  89      60.115  85.307 149.974  1.00 24.12           C  
ATOM   2396  O   ASN B  89      59.083  84.920 149.453  1.00 27.54           O  
ATOM   2397  CB  ASN B  89      59.406  87.084 151.602  1.00 24.33           C  
ATOM   2398  CG  ASN B  89      58.130  87.168 150.806  1.00 26.01           C  
ATOM   2399  OD1 ASN B  89      57.095  86.645 151.212  1.00 26.34           O  
ATOM   2400  ND2 ASN B  89      58.197  87.826 149.654  1.00 24.88           N  
ATOM   2401  N   ALA B  90      61.260  85.366 149.308  1.00 24.48           N  
ATOM   2402  CA  ALA B  90      61.322  84.973 147.904  1.00 25.48           C  
ATOM   2403  C   ALA B  90      61.007  83.487 147.725  1.00 26.51           C  
ATOM   2404  O   ALA B  90      61.451  82.655 148.509  1.00 28.14           O  
ATOM   2405  CB  ALA B  90      62.703  85.283 147.336  1.00 24.94           C  
ATOM   2406  N   GLY B  91      60.238  83.164 146.692  1.00 26.45           N  
ATOM   2407  CA  GLY B  91      59.887  81.782 146.428  1.00 27.21           C  
ATOM   2408  C   GLY B  91      58.879  81.640 145.297  1.00 29.21           C  
ATOM   2409  O   GLY B  91      58.032  82.510 145.107  1.00 30.71           O  
ATOM   2410  N   ILE B  92      58.980  80.550 144.541  1.00 28.83           N  
ATOM   2411  CA  ILE B  92      58.072  80.275 143.428  1.00 28.90           C  
ATOM   2412  C   ILE B  92      57.260  79.024 143.739  1.00 30.04           C  
ATOM   2413  O   ILE B  92      57.648  78.215 144.584  1.00 30.67           O  
ATOM   2414  CB  ILE B  92      58.830  80.011 142.101  1.00 27.77           C  
ATOM   2415  CG1 ILE B  92      59.828  78.861 142.291  1.00 26.56           C  
ATOM   2416  CG2 ILE B  92      59.520  81.277 141.632  1.00 26.96           C  
ATOM   2417  CD1 ILE B  92      60.517  78.419 141.017  1.00 24.51           C  
ATOM   2418  N   TYR B  93      56.146  78.855 143.036  1.00 30.13           N  
ATOM   2419  CA  TYR B  93      55.290  77.699 143.254  1.00 29.16           C  
ATOM   2420  C   TYR B  93      54.485  77.301 142.026  1.00 27.71           C  
ATOM   2421  O   TYR B  93      53.259  77.299 142.044  1.00 26.57           O  
ATOM   2422  CB  TYR B  93      54.355  77.966 144.439  1.00 30.72           C  
ATOM   2423  CG  TYR B  93      53.772  79.360 144.450  1.00 32.00           C  
ATOM   2424  CD1 TYR B  93      52.636  79.669 143.710  1.00 32.94           C  
ATOM   2425  CD2 TYR B  93      54.375  80.375 145.181  1.00 34.95           C  
ATOM   2426  CE1 TYR B  93      52.116  80.953 143.701  1.00 35.11           C  
ATOM   2427  CE2 TYR B  93      53.866  81.665 145.177  1.00 36.01           C  
ATOM   2428  CZ  TYR B  93      52.736  81.948 144.436  1.00 37.19           C  
ATOM   2429  OH  TYR B  93      52.226  83.229 144.429  1.00 38.94           O  
ATOM   2430  N   PRO B  94      55.173  76.960 140.932  1.00 27.61           N  
ATOM   2431  CA  PRO B  94      54.446  76.558 139.728  1.00 27.02           C  
ATOM   2432  C   PRO B  94      53.833  75.173 139.963  1.00 27.23           C  
ATOM   2433  O   PRO B  94      54.352  74.383 140.747  1.00 25.24           O  
ATOM   2434  CB  PRO B  94      55.536  76.553 138.660  1.00 26.54           C  
ATOM   2435  CG  PRO B  94      56.750  76.120 139.434  1.00 28.31           C  
ATOM   2436  CD  PRO B  94      56.631  76.924 140.714  1.00 28.36           C  
ATOM   2437  N   LEU B  95      52.729  74.891 139.284  1.00 28.15           N  
ATOM   2438  CA  LEU B  95      52.036  73.619 139.417  1.00 27.14           C  
ATOM   2439  C   LEU B  95      52.681  72.601 138.469  1.00 28.01           C  
ATOM   2440  O   LEU B  95      52.774  72.845 137.263  1.00 26.29           O  
ATOM   2441  CB  LEU B  95      50.566  73.824 139.054  1.00 28.64           C  
ATOM   2442  CG  LEU B  95      49.495  72.889 139.609  1.00 31.18           C  
ATOM   2443  CD1 LEU B  95      49.399  73.048 141.122  1.00 30.65           C  
ATOM   2444  CD2 LEU B  95      48.165  73.231 138.962  1.00 32.51           C  
ATOM   2445  N   ILE B  96      53.136  71.467 139.002  1.00 26.65           N  
ATOM   2446  CA  ILE B  96      53.767  70.465 138.150  1.00 27.85           C  
ATOM   2447  C   ILE B  96      53.501  69.030 138.587  1.00 28.07           C  
ATOM   2448  O   ILE B  96      53.800  68.651 139.716  1.00 30.13           O  
ATOM   2449  CB  ILE B  96      55.303  70.635 138.091  1.00 27.83           C  
ATOM   2450  CG1 ILE B  96      55.687  72.107 137.926  1.00 29.32           C  
ATOM   2451  CG2 ILE B  96      55.857  69.837 136.915  1.00 28.52           C  
ATOM   2452  CD1 ILE B  96      57.196  72.336 137.890  1.00 27.48           C  
ATOM   2453  N   PRO B  97      52.932  68.210 137.690  1.00 26.97           N  
ATOM   2454  CA  PRO B  97      52.630  66.805 137.983  1.00 25.56           C  
ATOM   2455  C   PRO B  97      53.933  66.040 138.199  1.00 25.27           C  
ATOM   2456  O   PRO B  97      54.906  66.241 137.474  1.00 24.35           O  
ATOM   2457  CB  PRO B  97      51.898  66.340 136.726  1.00 26.27           C  
ATOM   2458  CG  PRO B  97      51.223  67.596 136.243  1.00 27.32           C  
ATOM   2459  CD  PRO B  97      52.316  68.627 136.418  1.00 26.33           C  
ATOM   2460  N   PHE B  98      53.962  65.153 139.182  1.00 24.79           N  
ATOM   2461  CA  PHE B  98      55.185  64.409 139.438  1.00 25.64           C  
ATOM   2462  C   PHE B  98      55.733  63.705 138.195  1.00 27.62           C  
ATOM   2463  O   PHE B  98      56.944  63.693 137.969  1.00 26.63           O  
ATOM   2464  CB  PHE B  98      54.969  63.384 140.551  1.00 22.52           C  
ATOM   2465  CG  PHE B  98      56.204  62.611 140.891  1.00 21.47           C  
ATOM   2466  CD1 PHE B  98      57.285  63.241 141.482  1.00 23.39           C  
ATOM   2467  CD2 PHE B  98      56.299  61.263 140.591  1.00 21.59           C  
ATOM   2468  CE1 PHE B  98      58.440  62.543 141.768  1.00 21.06           C  
ATOM   2469  CE2 PHE B  98      57.453  60.557 140.875  1.00 21.71           C  
ATOM   2470  CZ  PHE B  98      58.525  61.201 141.464  1.00 21.71           C  
ATOM   2471  N   ASP B  99      54.851  63.128 137.383  1.00 29.66           N  
ATOM   2472  CA  ASP B  99      55.299  62.418 136.190  1.00 33.76           C  
ATOM   2473  C   ASP B  99      55.939  63.349 135.166  1.00 34.09           C  
ATOM   2474  O   ASP B  99      56.656  62.898 134.274  1.00 35.07           O  
ATOM   2475  CB  ASP B  99      54.145  61.623 135.558  1.00 36.05           C  
ATOM   2476  CG  ASP B  99      53.050  62.509 135.014  1.00 41.10           C  
ATOM   2477  OD1 ASP B  99      52.547  63.361 135.773  1.00 45.70           O  
ATOM   2478  OD2 ASP B  99      52.684  62.349 133.829  1.00 44.52           O  
ATOM   2479  N   GLU B 100      55.699  64.646 135.307  1.00 34.40           N  
ATOM   2480  CA  GLU B 100      56.280  65.630 134.399  1.00 34.80           C  
ATOM   2481  C   GLU B 100      57.477  66.322 135.040  1.00 33.05           C  
ATOM   2482  O   GLU B 100      58.398  66.767 134.355  1.00 33.80           O  
ATOM   2483  CB  GLU B 100      55.241  66.682 134.022  1.00 37.58           C  
ATOM   2484  CG  GLU B 100      54.242  66.224 132.973  1.00 42.18           C  
ATOM   2485  CD  GLU B 100      53.156  67.252 132.740  1.00 44.53           C  
ATOM   2486  OE1 GLU B 100      53.495  68.444 132.557  1.00 46.37           O  
ATOM   2487  OE2 GLU B 100      51.967  66.866 132.740  1.00 45.08           O  
ATOM   2488  N   LEU B 101      57.451  66.409 136.362  1.00 30.97           N  
ATOM   2489  CA  LEU B 101      58.511  67.058 137.115  1.00 27.68           C  
ATOM   2490  C   LEU B 101      59.886  66.473 136.772  1.00 28.01           C  
ATOM   2491  O   LEU B 101      60.153  65.296 137.015  1.00 26.84           O  
ATOM   2492  CB  LEU B 101      58.217  66.920 138.611  1.00 25.01           C  
ATOM   2493  CG  LEU B 101      59.143  67.600 139.619  1.00 22.83           C  
ATOM   2494  CD1 LEU B 101      59.229  69.087 139.318  1.00 19.44           C  
ATOM   2495  CD2 LEU B 101      58.609  67.361 141.035  1.00 22.21           C  
ATOM   2496  N   THR B 102      60.750  67.306 136.196  1.00 27.87           N  
ATOM   2497  CA  THR B 102      62.098  66.881 135.820  1.00 26.35           C  
ATOM   2498  C   THR B 102      63.064  67.277 136.911  1.00 24.12           C  
ATOM   2499  O   THR B 102      62.781  68.174 137.693  1.00 25.31           O  
ATOM   2500  CB  THR B 102      62.576  67.553 134.517  1.00 25.97           C  
ATOM   2501  OG1 THR B 102      62.754  68.959 134.743  1.00 26.83           O  
ATOM   2502  CG2 THR B 102      61.559  67.347 133.407  1.00 27.00           C  
ATOM   2503  N   PHE B 103      64.213  66.614 136.952  1.00 24.22           N  
ATOM   2504  CA  PHE B 103      65.224  66.906 137.955  1.00 23.42           C  
ATOM   2505  C   PHE B 103      65.614  68.381 137.894  1.00 24.65           C  
ATOM   2506  O   PHE B 103      65.873  69.005 138.920  1.00 24.52           O  
ATOM   2507  CB  PHE B 103      66.452  66.025 137.717  1.00 23.03           C  
ATOM   2508  CG  PHE B 103      67.570  66.250 138.705  1.00 22.92           C  
ATOM   2509  CD1 PHE B 103      67.352  66.103 140.066  1.00 20.64           C  
ATOM   2510  CD2 PHE B 103      68.841  66.577 138.265  1.00 19.55           C  
ATOM   2511  CE1 PHE B 103      68.384  66.278 140.972  1.00 20.72           C  
ATOM   2512  CE2 PHE B 103      69.878  66.754 139.163  1.00 20.57           C  
ATOM   2513  CZ  PHE B 103      69.653  66.605 140.519  1.00 20.71           C  
ATOM   2514  N   GLU B 104      65.640  68.939 136.687  1.00 24.59           N  
ATOM   2515  CA  GLU B 104      66.004  70.339 136.504  1.00 26.20           C  
ATOM   2516  C   GLU B 104      65.035  71.314 137.178  1.00 24.67           C  
ATOM   2517  O   GLU B 104      65.458  72.300 137.782  1.00 21.53           O  
ATOM   2518  CB  GLU B 104      66.119  70.664 135.009  1.00 29.55           C  
ATOM   2519  CG  GLU B 104      67.360  70.075 134.349  1.00 34.65           C  
ATOM   2520  CD  GLU B 104      67.313  68.555 134.221  1.00 38.88           C  
ATOM   2521  OE1 GLU B 104      68.403  67.930 134.217  1.00 38.15           O  
ATOM   2522  OE2 GLU B 104      66.198  67.988 134.112  1.00 36.47           O  
ATOM   2523  N   GLN B 105      63.741  71.047 137.067  1.00 23.81           N  
ATOM   2524  CA  GLN B 105      62.739  71.912 137.685  1.00 25.64           C  
ATOM   2525  C   GLN B 105      62.804  71.742 139.196  1.00 26.13           C  
ATOM   2526  O   GLN B 105      62.728  72.710 139.956  1.00 27.21           O  
ATOM   2527  CB  GLN B 105      61.343  71.540 137.184  1.00 25.48           C  
ATOM   2528  CG  GLN B 105      61.140  71.773 135.690  1.00 25.96           C  
ATOM   2529  CD  GLN B 105      59.903  71.069 135.166  1.00 26.11           C  
ATOM   2530  OE1 GLN B 105      59.771  69.852 135.292  1.00 28.55           O  
ATOM   2531  NE2 GLN B 105      58.990  71.829 134.580  1.00 26.09           N  
ATOM   2532  N   TRP B 106      62.942  70.488 139.613  1.00 25.52           N  
ATOM   2533  CA  TRP B 106      63.032  70.122 141.016  1.00 24.82           C  
ATOM   2534  C   TRP B 106      64.145  70.905 141.679  1.00 26.88           C  
ATOM   2535  O   TRP B 106      63.938  71.580 142.695  1.00 27.07           O  
ATOM   2536  CB  TRP B 106      63.305  68.622 141.117  1.00 21.89           C  
ATOM   2537  CG  TRP B 106      63.862  68.147 142.418  1.00 18.06           C  
ATOM   2538  CD1 TRP B 106      65.174  67.904 142.707  1.00 17.54           C  
ATOM   2539  CD2 TRP B 106      63.119  67.766 143.581  1.00 17.32           C  
ATOM   2540  NE1 TRP B 106      65.293  67.384 143.974  1.00 15.70           N  
ATOM   2541  CE2 TRP B 106      64.046  67.290 144.533  1.00 16.89           C  
ATOM   2542  CE3 TRP B 106      61.760  67.780 143.911  1.00 18.14           C  
ATOM   2543  CZ2 TRP B 106      63.657  66.826 145.792  1.00 18.38           C  
ATOM   2544  CZ3 TRP B 106      61.374  67.322 145.164  1.00 19.22           C  
ATOM   2545  CH2 TRP B 106      62.320  66.851 146.087  1.00 18.98           C  
ATOM   2546  N   LYS B 107      65.325  70.817 141.075  1.00 27.13           N  
ATOM   2547  CA  LYS B 107      66.522  71.482 141.559  1.00 27.40           C  
ATOM   2548  C   LYS B 107      66.388  73.009 141.557  1.00 27.58           C  
ATOM   2549  O   LYS B 107      66.790  73.684 142.508  1.00 27.97           O  
ATOM   2550  CB  LYS B 107      67.707  71.054 140.694  1.00 29.09           C  
ATOM   2551  CG  LYS B 107      69.034  71.132 141.399  1.00 35.13           C  
ATOM   2552  CD  LYS B 107      69.054  70.234 142.634  1.00 33.89           C  
ATOM   2553  CE  LYS B 107      70.340  70.444 143.411  1.00 34.05           C  
ATOM   2554  NZ  LYS B 107      70.446  69.578 144.606  1.00 33.58           N  
ATOM   2555  N   LYS B 108      65.815  73.555 140.495  1.00 26.82           N  
ATOM   2556  CA  LYS B 108      65.653  74.996 140.409  1.00 27.75           C  
ATOM   2557  C   LYS B 108      64.686  75.514 141.465  1.00 25.50           C  
ATOM   2558  O   LYS B 108      64.828  76.634 141.939  1.00 25.71           O  
ATOM   2559  CB  LYS B 108      65.172  75.404 139.011  1.00 30.80           C  
ATOM   2560  CG  LYS B 108      65.041  76.900 138.845  1.00 37.12           C  
ATOM   2561  CD  LYS B 108      64.902  77.304 137.387  1.00 43.72           C  
ATOM   2562  CE  LYS B 108      64.884  78.829 137.250  1.00 46.64           C  
ATOM   2563  NZ  LYS B 108      64.878  79.280 135.828  1.00 48.22           N  
ATOM   2564  N   THR B 109      63.697  74.708 141.833  1.00 24.04           N  
ATOM   2565  CA  THR B 109      62.749  75.135 142.856  1.00 20.62           C  
ATOM   2566  C   THR B 109      63.466  75.222 144.213  1.00 20.81           C  
ATOM   2567  O   THR B 109      63.148  76.081 145.042  1.00 19.84           O  
ATOM   2568  CB  THR B 109      61.559  74.163 142.945  1.00 21.48           C  
ATOM   2569  OG1 THR B 109      61.019  73.954 141.633  1.00 22.07           O  
ATOM   2570  CG2 THR B 109      60.463  74.738 143.837  1.00 19.18           C  
ATOM   2571  N   PHE B 110      64.444  74.344 144.437  1.00 19.61           N  
ATOM   2572  CA  PHE B 110      65.205  74.370 145.687  1.00 20.13           C  
ATOM   2573  C   PHE B 110      66.181  75.553 145.743  1.00 21.76           C  
ATOM   2574  O   PHE B 110      66.411  76.127 146.808  1.00 21.30           O  
ATOM   2575  CB  PHE B 110      65.990  73.064 145.886  1.00 18.16           C  
ATOM   2576  CG  PHE B 110      65.191  71.969 146.543  1.00 18.57           C  
ATOM   2577  CD1 PHE B 110      64.320  71.182 145.805  1.00 17.57           C  
ATOM   2578  CD2 PHE B 110      65.283  71.757 147.910  1.00 16.40           C  
ATOM   2579  CE1 PHE B 110      63.553  70.203 146.425  1.00 22.59           C  
ATOM   2580  CE2 PHE B 110      64.524  70.787 148.535  1.00 18.61           C  
ATOM   2581  CZ  PHE B 110      63.656  70.007 147.797  1.00 19.89           C  
ATOM   2582  N   GLU B 111      66.752  75.918 144.600  1.00 22.73           N  
ATOM   2583  CA  GLU B 111      67.699  77.026 144.556  1.00 24.31           C  
ATOM   2584  C   GLU B 111      67.031  78.341 144.932  1.00 24.78           C  
ATOM   2585  O   GLU B 111      67.590  79.137 145.680  1.00 26.46           O  
ATOM   2586  CB  GLU B 111      68.321  77.135 143.161  1.00 24.21           C  
ATOM   2587  CG  GLU B 111      68.951  75.840 142.703  1.00 28.31           C  
ATOM   2588  CD  GLU B 111      69.658  75.956 141.374  1.00 31.11           C  
ATOM   2589  OE1 GLU B 111      69.115  76.610 140.463  1.00 33.53           O  
ATOM   2590  OE2 GLU B 111      70.755  75.378 141.237  1.00 35.32           O  
ATOM   2591  N   ILE B 112      65.826  78.553 144.417  1.00 24.09           N  
ATOM   2592  CA  ILE B 112      65.077  79.766 144.693  1.00 23.26           C  
ATOM   2593  C   ILE B 112      64.375  79.764 146.049  1.00 23.56           C  
ATOM   2594  O   ILE B 112      64.401  80.764 146.767  1.00 22.85           O  
ATOM   2595  CB  ILE B 112      64.021  80.008 143.601  1.00 24.12           C  
ATOM   2596  CG1 ILE B 112      64.713  80.216 142.253  1.00 26.83           C  
ATOM   2597  CG2 ILE B 112      63.190  81.226 143.937  1.00 23.56           C  
ATOM   2598  CD1 ILE B 112      63.752  80.405 141.104  1.00 26.65           C  
ATOM   2599  N   ASN B 113      63.761  78.639 146.408  1.00 23.22           N  
ATOM   2600  CA  ASN B 113      63.023  78.538 147.669  1.00 20.92           C  
ATOM   2601  C   ASN B 113      63.806  78.200 148.929  1.00 20.03           C  
ATOM   2602  O   ASN B 113      63.371  78.547 150.024  1.00 20.52           O  
ATOM   2603  CB  ASN B 113      61.893  77.512 147.531  1.00 19.84           C  
ATOM   2604  CG  ASN B 113      60.815  77.953 146.572  1.00 17.16           C  
ATOM   2605  OD1 ASN B 113      60.940  78.982 145.911  1.00 17.43           O  
ATOM   2606  ND2 ASN B 113      59.746  77.171 146.486  1.00 17.15           N  
ATOM   2607  N   VAL B 114      64.947  77.533 148.790  1.00 20.17           N  
ATOM   2608  CA  VAL B 114      65.724  77.124 149.967  1.00 20.42           C  
ATOM   2609  C   VAL B 114      67.145  77.680 150.070  1.00 22.20           C  
ATOM   2610  O   VAL B 114      67.562  78.111 151.143  1.00 21.80           O  
ATOM   2611  CB  VAL B 114      65.816  75.583 150.042  1.00 20.57           C  
ATOM   2612  CG1 VAL B 114      66.390  75.163 151.384  1.00 20.63           C  
ATOM   2613  CG2 VAL B 114      64.434  74.963 149.805  1.00 19.61           C  
ATOM   2614  N   ASP B 115      67.894  77.643 148.970  1.00 22.30           N  
ATOM   2615  CA  ASP B 115      69.259  78.149 148.971  1.00 23.74           C  
ATOM   2616  C   ASP B 115      69.300  79.638 149.261  1.00 24.47           C  
ATOM   2617  O   ASP B 115      70.250  80.141 149.863  1.00 24.78           O  
ATOM   2618  CB  ASP B 115      69.933  77.902 147.624  1.00 24.73           C  
ATOM   2619  CG  ASP B 115      70.088  76.436 147.308  1.00 26.15           C  
ATOM   2620  OD1 ASP B 115      70.169  75.613 148.252  1.00 24.03           O  
ATOM   2621  OD2 ASP B 115      70.146  76.115 146.105  1.00 27.23           O  
ATOM   2622  N   SER B 116      68.271  80.342 148.808  1.00 23.81           N  
ATOM   2623  CA  SER B 116      68.179  81.775 149.013  1.00 23.50           C  
ATOM   2624  C   SER B 116      68.245  82.103 150.504  1.00 22.52           C  
ATOM   2625  O   SER B 116      69.000  82.980 150.921  1.00 22.26           O  
ATOM   2626  CB  SER B 116      66.871  82.294 148.421  1.00 23.47           C  
ATOM   2627  OG  SER B 116      65.768  81.638 149.020  1.00 25.23           O  
ATOM   2628  N   GLY B 117      67.457  81.387 151.301  1.00 19.96           N  
ATOM   2629  CA  GLY B 117      67.438  81.628 152.735  1.00 20.48           C  
ATOM   2630  C   GLY B 117      68.777  81.386 153.404  1.00 20.74           C  
ATOM   2631  O   GLY B 117      69.198  82.154 154.272  1.00 20.07           O  
ATOM   2632  N   PHE B 118      69.438  80.304 153.001  1.00 20.55           N  
ATOM   2633  CA  PHE B 118      70.741  79.943 153.539  1.00 20.66           C  
ATOM   2634  C   PHE B 118      71.752  81.023 153.169  1.00 20.52           C  
ATOM   2635  O   PHE B 118      72.391  81.599 154.035  1.00 22.19           O  
ATOM   2636  CB  PHE B 118      71.195  78.603 152.958  1.00 19.71           C  
ATOM   2637  CG  PHE B 118      72.609  78.233 153.315  1.00 20.33           C  
ATOM   2638  CD1 PHE B 118      72.904  77.655 154.544  1.00 19.07           C  
ATOM   2639  CD2 PHE B 118      73.646  78.468 152.422  1.00 19.60           C  
ATOM   2640  CE1 PHE B 118      74.204  77.316 154.875  1.00 18.31           C  
ATOM   2641  CE2 PHE B 118      74.955  78.134 152.749  1.00 19.31           C  
ATOM   2642  CZ  PHE B 118      75.232  77.557 153.973  1.00 19.88           C  
ATOM   2643  N   LEU B 119      71.887  81.290 151.875  1.00 21.12           N  
ATOM   2644  CA  LEU B 119      72.816  82.304 151.383  1.00 22.16           C  
ATOM   2645  C   LEU B 119      72.622  83.642 152.082  1.00 22.56           C  
ATOM   2646  O   LEU B 119      73.584  84.314 152.465  1.00 23.74           O  
ATOM   2647  CB  LEU B 119      72.616  82.508 149.883  1.00 21.54           C  
ATOM   2648  CG  LEU B 119      73.506  81.752 148.901  1.00 21.50           C  
ATOM   2649  CD1 LEU B 119      74.238  80.627 149.597  1.00 18.77           C  
ATOM   2650  CD2 LEU B 119      72.645  81.255 147.744  1.00 18.81           C  
ATOM   2651  N   MET B 120      71.362  84.021 152.238  1.00 21.81           N  
ATOM   2652  CA  MET B 120      70.998  85.281 152.865  1.00 20.56           C  
ATOM   2653  C   MET B 120      71.373  85.293 154.348  1.00 22.14           C  
ATOM   2654  O   MET B 120      71.802  86.318 154.883  1.00 20.98           O  
ATOM   2655  CB  MET B 120      69.498  85.503 152.689  1.00 22.51           C  
ATOM   2656  CG  MET B 120      69.111  86.909 152.326  1.00 27.56           C  
ATOM   2657  SD  MET B 120      69.709  87.447 150.706  1.00 30.61           S  
ATOM   2658  CE  MET B 120      69.288  89.079 150.771  1.00 23.29           C  
ATOM   2659  N   ALA B 121      71.220  84.152 155.016  1.00 21.56           N  
ATOM   2660  CA  ALA B 121      71.560  84.074 156.429  1.00 21.11           C  
ATOM   2661  C   ALA B 121      73.076  84.143 156.604  1.00 22.73           C  
ATOM   2662  O   ALA B 121      73.576  84.790 157.531  1.00 22.10           O  
ATOM   2663  CB  ALA B 121      71.010  82.780 157.037  1.00 19.74           C  
ATOM   2664  N   LYS B 122      73.809  83.490 155.705  1.00 22.73           N  
ATOM   2665  CA  LYS B 122      75.265  83.492 155.785  1.00 24.43           C  
ATOM   2666  C   LYS B 122      75.792  84.918 155.707  1.00 25.00           C  
ATOM   2667  O   LYS B 122      76.701  85.296 156.440  1.00 26.21           O  
ATOM   2668  CB  LYS B 122      75.877  82.660 154.652  1.00 22.92           C  
ATOM   2669  CG  LYS B 122      75.647  81.165 154.771  1.00 23.86           C  
ATOM   2670  CD  LYS B 122      76.380  80.581 155.965  1.00 24.29           C  
ATOM   2671  CE  LYS B 122      77.892  80.674 155.795  1.00 23.75           C  
ATOM   2672  NZ  LYS B 122      78.618  80.047 156.945  1.00 18.85           N  
ATOM   2673  N   ALA B 123      75.198  85.714 154.828  1.00 25.31           N  
ATOM   2674  CA  ALA B 123      75.624  87.091 154.638  1.00 23.92           C  
ATOM   2675  C   ALA B 123      75.253  88.061 155.759  1.00 24.11           C  
ATOM   2676  O   ALA B 123      75.979  89.022 156.011  1.00 22.00           O  
ATOM   2677  CB  ALA B 123      75.079  87.611 153.322  1.00 23.95           C  
ATOM   2678  N   PHE B 124      74.141  87.818 156.445  1.00 24.39           N  
ATOM   2679  CA  PHE B 124      73.726  88.755 157.482  1.00 22.71           C  
ATOM   2680  C   PHE B 124      73.791  88.313 158.934  1.00 23.63           C  
ATOM   2681  O   PHE B 124      73.732  89.154 159.832  1.00 24.91           O  
ATOM   2682  CB  PHE B 124      72.326  89.273 157.156  1.00 20.76           C  
ATOM   2683  CG  PHE B 124      72.265  90.062 155.880  1.00 21.88           C  
ATOM   2684  CD1 PHE B 124      72.950  91.258 155.758  1.00 22.29           C  
ATOM   2685  CD2 PHE B 124      71.553  89.595 154.794  1.00 23.60           C  
ATOM   2686  CE1 PHE B 124      72.926  91.969 154.579  1.00 21.79           C  
ATOM   2687  CE2 PHE B 124      71.526  90.306 153.607  1.00 23.54           C  
ATOM   2688  CZ  PHE B 124      72.213  91.491 153.502  1.00 22.56           C  
ATOM   2689  N   VAL B 125      73.914  87.015 159.190  1.00 24.27           N  
ATOM   2690  CA  VAL B 125      73.983  86.564 160.577  1.00 24.16           C  
ATOM   2691  C   VAL B 125      75.224  87.086 161.322  1.00 25.82           C  
ATOM   2692  O   VAL B 125      75.134  87.465 162.492  1.00 25.60           O  
ATOM   2693  CB  VAL B 125      73.924  85.021 160.675  1.00 24.09           C  
ATOM   2694  CG1 VAL B 125      74.332  84.563 162.074  1.00 23.17           C  
ATOM   2695  CG2 VAL B 125      72.506  84.546 160.379  1.00 22.91           C  
ATOM   2696  N   PRO B 126      76.390  87.126 160.653  1.00 24.40           N  
ATOM   2697  CA  PRO B 126      77.613  87.617 161.309  1.00 24.43           C  
ATOM   2698  C   PRO B 126      77.455  89.000 161.952  1.00 25.10           C  
ATOM   2699  O   PRO B 126      77.913  89.233 163.072  1.00 24.26           O  
ATOM   2700  CB  PRO B 126      78.634  87.605 160.175  1.00 23.90           C  
ATOM   2701  CG  PRO B 126      78.198  86.394 159.370  1.00 23.80           C  
ATOM   2702  CD  PRO B 126      76.691  86.588 159.313  1.00 23.40           C  
ATOM   2703  N   GLY B 127      76.812  89.919 161.240  1.00 26.62           N  
ATOM   2704  CA  GLY B 127      76.586  91.248 161.782  1.00 25.70           C  
ATOM   2705  C   GLY B 127      75.593  91.220 162.934  1.00 26.28           C  
ATOM   2706  O   GLY B 127      75.752  91.947 163.911  1.00 26.82           O  
ATOM   2707  N   MET B 128      74.562  90.383 162.817  1.00 26.18           N  
ATOM   2708  CA  MET B 128      73.548  90.244 163.864  1.00 27.34           C  
ATOM   2709  C   MET B 128      74.184  89.675 165.127  1.00 28.96           C  
ATOM   2710  O   MET B 128      73.846  90.065 166.246  1.00 28.77           O  
ATOM   2711  CB  MET B 128      72.437  89.284 163.422  1.00 25.58           C  
ATOM   2712  CG  MET B 128      71.472  89.820 162.377  1.00 23.73           C  
ATOM   2713  SD  MET B 128      70.283  88.521 161.895  1.00 25.82           S  
ATOM   2714  CE  MET B 128      69.541  89.266 160.417  1.00 17.69           C  
ATOM   2715  N   LYS B 129      75.106  88.741 164.928  1.00 30.43           N  
ATOM   2716  CA  LYS B 129      75.795  88.081 166.021  1.00 33.83           C  
ATOM   2717  C   LYS B 129      76.774  89.021 166.732  1.00 35.50           C  
ATOM   2718  O   LYS B 129      76.796  89.089 167.963  1.00 36.19           O  
ATOM   2719  CB  LYS B 129      76.529  86.846 165.481  1.00 36.15           C  
ATOM   2720  CG  LYS B 129      77.089  85.919 166.547  1.00 40.52           C  
ATOM   2721  CD  LYS B 129      77.795  84.710 165.933  1.00 43.29           C  
ATOM   2722  CE  LYS B 129      78.418  83.825 167.014  1.00 45.05           C  
ATOM   2723  NZ  LYS B 129      79.029  82.578 166.465  1.00 44.78           N  
ATOM   2724  N   ARG B 130      77.572  89.755 165.965  1.00 35.89           N  
ATOM   2725  CA  ARG B 130      78.541  90.670 166.560  1.00 38.00           C  
ATOM   2726  C   ARG B 130      77.851  91.759 167.373  1.00 36.73           C  
ATOM   2727  O   ARG B 130      78.446  92.334 168.283  1.00 35.81           O  
ATOM   2728  CB  ARG B 130      79.418  91.323 165.485  1.00 38.96           C  
ATOM   2729  CG  ARG B 130      80.224  90.342 164.652  1.00 45.97           C  
ATOM   2730  CD  ARG B 130      81.457  90.982 164.016  1.00 47.84           C  
ATOM   2731  NE  ARG B 130      82.446  91.387 165.017  1.00 51.18           N  
ATOM   2732  CZ  ARG B 130      82.406  92.530 165.700  1.00 52.40           C  
ATOM   2733  NH1 ARG B 130      83.349  92.808 166.596  1.00 50.84           N  
ATOM   2734  NH2 ARG B 130      81.434  93.405 165.477  1.00 53.18           N  
ATOM   2735  N   ASN B 131      76.596  92.042 167.039  1.00 34.98           N  
ATOM   2736  CA  ASN B 131      75.847  93.070 167.747  1.00 32.75           C  
ATOM   2737  C   ASN B 131      74.887  92.493 168.787  1.00 32.21           C  
ATOM   2738  O   ASN B 131      74.169  93.233 169.453  1.00 32.39           O  
ATOM   2739  CB  ASN B 131      75.074  93.930 166.753  1.00 32.24           C  
ATOM   2740  CG  ASN B 131      74.521  95.187 167.388  1.00 32.76           C  
ATOM   2741  OD1 ASN B 131      75.263  95.969 167.987  1.00 33.87           O  
ATOM   2742  ND2 ASN B 131      73.215  95.393 167.259  1.00 30.91           N  
ATOM   2743  N   GLY B 132      74.876  91.168 168.914  1.00 31.15           N  
ATOM   2744  CA  GLY B 132      74.013  90.516 169.884  1.00 30.93           C  
ATOM   2745  C   GLY B 132      72.508  90.659 169.715  1.00 30.12           C  
ATOM   2746  O   GLY B 132      71.775  90.574 170.698  1.00 30.80           O  
ATOM   2747  N   TRP B 133      72.033  90.860 168.488  1.00 28.95           N  
ATOM   2748  CA  TRP B 133      70.598  91.003 168.255  1.00 26.30           C  
ATOM   2749  C   TRP B 133      70.202  90.827 166.791  1.00 26.60           C  
ATOM   2750  O   TRP B 133      70.851  91.359 165.891  1.00 26.00           O  
ATOM   2751  CB  TRP B 133      70.114  92.382 168.714  1.00 24.91           C  
ATOM   2752  CG  TRP B 133      68.636  92.429 168.908  1.00 21.02           C  
ATOM   2753  CD1 TRP B 133      67.954  92.185 170.069  1.00 20.07           C  
ATOM   2754  CD2 TRP B 133      67.647  92.674 167.905  1.00 19.59           C  
ATOM   2755  NE1 TRP B 133      66.602  92.265 169.847  1.00 21.82           N  
ATOM   2756  CE2 TRP B 133      66.385  92.563 168.527  1.00 20.42           C  
ATOM   2757  CE3 TRP B 133      67.703  92.977 166.538  1.00 20.33           C  
ATOM   2758  CZ2 TRP B 133      65.188  92.744 167.830  1.00 19.18           C  
ATOM   2759  CZ3 TRP B 133      66.513  93.157 165.847  1.00 19.78           C  
ATOM   2760  CH2 TRP B 133      65.272  93.039 166.496  1.00 17.10           C  
ATOM   2761  N   GLY B 134      69.118  90.094 166.557  1.00 25.58           N  
ATOM   2762  CA  GLY B 134      68.668  89.895 165.196  1.00 24.87           C  
ATOM   2763  C   GLY B 134      67.360  89.145 165.059  1.00 24.91           C  
ATOM   2764  O   GLY B 134      66.878  88.517 166.000  1.00 26.33           O  
ATOM   2765  N   ARG B 135      66.777  89.218 163.871  1.00 23.77           N  
ATOM   2766  CA  ARG B 135      65.530  88.523 163.593  1.00 23.62           C  
ATOM   2767  C   ARG B 135      65.574  87.930 162.193  1.00 23.21           C  
ATOM   2768  O   ARG B 135      65.967  88.596 161.235  1.00 23.02           O  
ATOM   2769  CB  ARG B 135      64.336  89.476 163.714  1.00 19.62           C  
ATOM   2770  CG  ARG B 135      64.044  89.930 165.130  1.00 18.20           C  
ATOM   2771  CD  ARG B 135      63.453  88.815 165.964  1.00 15.89           C  
ATOM   2772  NE  ARG B 135      63.035  89.281 167.280  1.00 17.98           N  
ATOM   2773  CZ  ARG B 135      63.823  89.329 168.351  1.00 22.62           C  
ATOM   2774  NH1 ARG B 135      65.087  88.932 168.274  1.00 22.88           N  
ATOM   2775  NH2 ARG B 135      63.348  89.785 169.508  1.00 21.89           N  
ATOM   2776  N   ILE B 136      65.199  86.660 162.092  1.00 23.06           N  
ATOM   2777  CA  ILE B 136      65.158  85.972 160.816  1.00 20.75           C  
ATOM   2778  C   ILE B 136      63.767  85.367 160.727  1.00 20.97           C  
ATOM   2779  O   ILE B 136      63.383  84.539 161.564  1.00 19.49           O  
ATOM   2780  CB  ILE B 136      66.204  84.847 160.730  1.00 22.75           C  
ATOM   2781  CG1 ILE B 136      67.616  85.438 160.810  1.00 23.61           C  
ATOM   2782  CG2 ILE B 136      66.027  84.074 159.423  1.00 20.68           C  
ATOM   2783  CD1 ILE B 136      68.732  84.407 160.684  1.00 24.67           C  
ATOM   2784  N   ILE B 137      63.011  85.803 159.724  1.00 19.57           N  
ATOM   2785  CA  ILE B 137      61.655  85.324 159.515  1.00 20.10           C  
ATOM   2786  C   ILE B 137      61.552  84.626 158.166  1.00 21.71           C  
ATOM   2787  O   ILE B 137      61.823  85.227 157.127  1.00 23.57           O  
ATOM   2788  CB  ILE B 137      60.650  86.492 159.563  1.00 19.98           C  
ATOM   2789  CG1 ILE B 137      60.752  87.190 160.920  1.00 19.10           C  
ATOM   2790  CG2 ILE B 137      59.226  85.979 159.339  1.00 21.19           C  
ATOM   2791  CD1 ILE B 137      59.944  88.441 161.026  1.00 15.60           C  
ATOM   2792  N   ASN B 138      61.161  83.356 158.189  1.00 21.67           N  
ATOM   2793  CA  ASN B 138      61.028  82.578 156.964  1.00 20.83           C  
ATOM   2794  C   ASN B 138      59.569  82.358 156.562  1.00 21.21           C  
ATOM   2795  O   ASN B 138      58.722  82.026 157.394  1.00 22.17           O  
ATOM   2796  CB  ASN B 138      61.719  81.220 157.127  1.00 19.39           C  
ATOM   2797  CG  ASN B 138      63.216  81.351 157.399  1.00 20.65           C  
ATOM   2798  OD1 ASN B 138      63.938  82.034 156.668  1.00 21.30           O  
ATOM   2799  ND2 ASN B 138      63.684  80.694 158.452  1.00 16.48           N  
ATOM   2800  N   LEU B 139      59.281  82.553 155.280  1.00 20.94           N  
ATOM   2801  CA  LEU B 139      57.937  82.341 154.769  1.00 20.01           C  
ATOM   2802  C   LEU B 139      57.814  80.908 154.264  1.00 20.40           C  
ATOM   2803  O   LEU B 139      58.608  80.460 153.434  1.00 20.67           O  
ATOM   2804  CB  LEU B 139      57.619  83.316 153.634  1.00 17.54           C  
ATOM   2805  CG  LEU B 139      56.914  84.617 154.027  1.00 21.18           C  
ATOM   2806  CD1 LEU B 139      55.601  84.291 154.757  1.00 19.36           C  
ATOM   2807  CD2 LEU B 139      57.822  85.453 154.917  1.00 20.77           C  
ATOM   2808  N   THR B 140      56.836  80.184 154.798  1.00 20.72           N  
ATOM   2809  CA  THR B 140      56.592  78.807 154.386  1.00 21.31           C  
ATOM   2810  C   THR B 140      55.145  78.732 153.917  1.00 21.70           C  
ATOM   2811  O   THR B 140      54.553  79.757 153.609  1.00 23.83           O  
ATOM   2812  CB  THR B 140      56.838  77.795 155.539  1.00 20.14           C  
ATOM   2813  OG1 THR B 140      56.647  76.461 155.045  1.00 20.20           O  
ATOM   2814  CG2 THR B 140      55.894  78.053 156.702  1.00 15.98           C  
ATOM   2815  N   SER B 141      54.560  77.541 153.881  1.00 22.80           N  
ATOM   2816  CA  SER B 141      53.195  77.421 153.385  1.00 21.00           C  
ATOM   2817  C   SER B 141      52.343  76.417 154.141  1.00 20.63           C  
ATOM   2818  O   SER B 141      52.850  75.399 154.612  1.00 19.98           O  
ATOM   2819  CB  SER B 141      53.239  77.036 151.902  1.00 21.28           C  
ATOM   2820  OG  SER B 141      51.947  76.728 151.403  1.00 21.62           O  
ATOM   2821  N   THR B 142      51.046  76.701 154.245  1.00 17.60           N  
ATOM   2822  CA  THR B 142      50.136  75.793 154.935  1.00 20.04           C  
ATOM   2823  C   THR B 142      49.923  74.529 154.105  1.00 19.47           C  
ATOM   2824  O   THR B 142      49.369  73.550 154.604  1.00 20.31           O  
ATOM   2825  CB  THR B 142      48.750  76.436 155.204  1.00 19.37           C  
ATOM   2826  OG1 THR B 142      48.176  76.879 153.967  1.00 24.93           O  
ATOM   2827  CG2 THR B 142      48.876  77.613 156.151  1.00 19.21           C  
ATOM   2828  N   THR B 143      50.350  74.548 152.842  1.00 17.53           N  
ATOM   2829  CA  THR B 143      50.205  73.364 151.994  1.00 16.89           C  
ATOM   2830  C   THR B 143      51.006  72.215 152.605  1.00 17.63           C  
ATOM   2831  O   THR B 143      50.806  71.051 152.270  1.00 15.65           O  
ATOM   2832  CB  THR B 143      50.711  73.609 150.548  1.00 17.43           C  
ATOM   2833  OG1 THR B 143      52.042  74.145 150.583  1.00 14.00           O  
ATOM   2834  CG2 THR B 143      49.780  74.568 149.805  1.00 14.23           C  
ATOM   2835  N   TYR B 144      51.923  72.559 153.503  1.00 19.33           N  
ATOM   2836  CA  TYR B 144      52.751  71.574 154.188  1.00 20.36           C  
ATOM   2837  C   TYR B 144      51.870  70.565 154.933  1.00 20.68           C  
ATOM   2838  O   TYR B 144      52.198  69.381 155.001  1.00 23.23           O  
ATOM   2839  CB  TYR B 144      53.690  72.289 155.166  1.00 21.23           C  
ATOM   2840  CG  TYR B 144      54.560  71.383 156.001  1.00 22.72           C  
ATOM   2841  CD1 TYR B 144      55.494  70.535 155.414  1.00 25.06           C  
ATOM   2842  CD2 TYR B 144      54.479  71.405 157.384  1.00 24.63           C  
ATOM   2843  CE1 TYR B 144      56.324  69.738 156.187  1.00 24.18           C  
ATOM   2844  CE2 TYR B 144      55.302  70.616 158.163  1.00 24.63           C  
ATOM   2845  CZ  TYR B 144      56.224  69.788 157.562  1.00 26.43           C  
ATOM   2846  OH  TYR B 144      57.055  69.021 158.348  1.00 28.49           O  
ATOM   2847  N   TRP B 145      50.745  71.025 155.475  1.00 19.45           N  
ATOM   2848  CA  TRP B 145      49.831  70.139 156.199  1.00 20.88           C  
ATOM   2849  C   TRP B 145      48.564  69.790 155.409  1.00 21.41           C  
ATOM   2850  O   TRP B 145      47.610  69.265 155.982  1.00 21.74           O  
ATOM   2851  CB  TRP B 145      49.395  70.785 157.512  1.00 20.01           C  
ATOM   2852  CG  TRP B 145      50.499  71.068 158.466  1.00 20.56           C  
ATOM   2853  CD1 TRP B 145      51.054  70.200 159.359  1.00 21.30           C  
ATOM   2854  CD2 TRP B 145      51.178  72.314 158.639  1.00 20.69           C  
ATOM   2855  NE1 TRP B 145      52.035  70.833 160.085  1.00 22.68           N  
ATOM   2856  CE2 TRP B 145      52.130  72.132 159.662  1.00 21.71           C  
ATOM   2857  CE3 TRP B 145      51.071  73.569 158.031  1.00 21.89           C  
ATOM   2858  CZ2 TRP B 145      52.971  73.156 160.090  1.00 23.13           C  
ATOM   2859  CZ3 TRP B 145      51.909  74.587 158.461  1.00 22.17           C  
ATOM   2860  CH2 TRP B 145      52.845  74.374 159.479  1.00 20.70           C  
ATOM   2861  N   LEU B 146      48.547  70.076 154.109  1.00 20.95           N  
ATOM   2862  CA  LEU B 146      47.357  69.807 153.297  1.00 21.07           C  
ATOM   2863  C   LEU B 146      47.567  68.862 152.128  1.00 22.02           C  
ATOM   2864  O   LEU B 146      48.669  68.739 151.578  1.00 20.84           O  
ATOM   2865  CB  LEU B 146      46.772  71.116 152.744  1.00 21.34           C  
ATOM   2866  CG  LEU B 146      46.309  72.214 153.716  1.00 22.31           C  
ATOM   2867  CD1 LEU B 146      45.902  73.457 152.939  1.00 19.73           C  
ATOM   2868  CD2 LEU B 146      45.156  71.705 154.558  1.00 21.00           C  
ATOM   2869  N   LYS B 147      46.484  68.196 151.748  1.00 21.84           N  
ATOM   2870  CA  LYS B 147      46.518  67.286 150.621  1.00 22.78           C  
ATOM   2871  C   LYS B 147      46.269  68.100 149.362  1.00 22.48           C  
ATOM   2872  O   LYS B 147      45.182  68.643 149.169  1.00 22.36           O  
ATOM   2873  CB  LYS B 147      45.430  66.222 150.748  1.00 23.91           C  
ATOM   2874  CG  LYS B 147      45.513  65.168 149.670  1.00 25.56           C  
ATOM   2875  CD  LYS B 147      44.133  64.779 149.176  1.00 28.87           C  
ATOM   2876  CE  LYS B 147      43.547  65.822 148.247  1.00 29.61           C  
ATOM   2877  NZ  LYS B 147      44.291  65.862 146.963  1.00 33.93           N  
ATOM   2878  N   ILE B 148      47.285  68.195 148.517  1.00 22.37           N  
ATOM   2879  CA  ILE B 148      47.184  68.922 147.268  1.00 22.59           C  
ATOM   2880  C   ILE B 148      48.220  68.337 146.308  1.00 24.97           C  
ATOM   2881  O   ILE B 148      49.384  68.131 146.669  1.00 22.99           O  
ATOM   2882  CB  ILE B 148      47.400  70.449 147.477  1.00 25.57           C  
ATOM   2883  CG1 ILE B 148      47.078  71.207 146.185  1.00 24.95           C  
ATOM   2884  CG2 ILE B 148      48.825  70.734 147.907  1.00 26.06           C  
ATOM   2885  CD1 ILE B 148      46.938  72.709 146.387  1.00 27.44           C  
ATOM   2886  N   GLU B 149      47.780  68.057 145.085  1.00 25.17           N  
ATOM   2887  CA  GLU B 149      48.642  67.455 144.076  1.00 26.75           C  
ATOM   2888  C   GLU B 149      49.484  68.438 143.281  1.00 26.15           C  
ATOM   2889  O   GLU B 149      49.304  69.649 143.376  1.00 25.18           O  
ATOM   2890  CB  GLU B 149      47.793  66.636 143.108  1.00 25.91           C  
ATOM   2891  CG  GLU B 149      46.978  65.560 143.790  1.00 32.90           C  
ATOM   2892  CD  GLU B 149      46.059  64.833 142.834  1.00 35.26           C  
ATOM   2893  OE1 GLU B 149      46.567  64.275 141.839  1.00 36.12           O  
ATOM   2894  OE2 GLU B 149      44.830  64.822 143.081  1.00 37.48           O  
ATOM   2895  N   ALA B 150      50.401  67.880 142.495  1.00 26.47           N  
ATOM   2896  CA  ALA B 150      51.292  68.642 141.620  1.00 26.99           C  
ATOM   2897  C   ALA B 150      52.183  69.654 142.331  1.00 25.37           C  
ATOM   2898  O   ALA B 150      52.502  70.698 141.762  1.00 26.34           O  
ATOM   2899  CB  ALA B 150      50.468  69.344 140.527  1.00 25.27           C  
ATOM   2900  N   TYR B 151      52.592  69.344 143.556  1.00 23.86           N  
ATOM   2901  CA  TYR B 151      53.448  70.245 144.329  1.00 22.96           C  
ATOM   2902  C   TYR B 151      54.519  69.541 145.152  1.00 21.28           C  
ATOM   2903  O   TYR B 151      54.967  70.082 146.161  1.00 20.85           O  
ATOM   2904  CB  TYR B 151      52.602  71.088 145.276  1.00 24.72           C  
ATOM   2905  CG  TYR B 151      52.097  72.377 144.695  1.00 30.49           C  
ATOM   2906  CD1 TYR B 151      50.807  72.817 144.965  1.00 33.86           C  
ATOM   2907  CD2 TYR B 151      52.916  73.184 143.911  1.00 32.83           C  
ATOM   2908  CE1 TYR B 151      50.347  74.022 144.471  1.00 37.90           C  
ATOM   2909  CE2 TYR B 151      52.462  74.394 143.411  1.00 34.26           C  
ATOM   2910  CZ  TYR B 151      51.180  74.806 143.697  1.00 36.92           C  
ATOM   2911  OH  TYR B 151      50.714  75.999 143.205  1.00 41.82           O  
ATOM   2912  N   THR B 152      54.935  68.348 144.742  1.00 19.77           N  
ATOM   2913  CA  THR B 152      55.944  67.631 145.508  1.00 20.30           C  
ATOM   2914  C   THR B 152      57.241  68.434 145.632  1.00 19.74           C  
ATOM   2915  O   THR B 152      57.943  68.337 146.638  1.00 21.80           O  
ATOM   2916  CB  THR B 152      56.242  66.225 144.908  1.00 18.96           C  
ATOM   2917  OG1 THR B 152      56.929  66.356 143.658  1.00 26.60           O  
ATOM   2918  CG2 THR B 152      54.948  65.468 144.683  1.00 14.36           C  
ATOM   2919  N   HIS B 153      57.547  69.237 144.620  1.00 19.93           N  
ATOM   2920  CA  HIS B 153      58.748  70.067 144.635  1.00 19.78           C  
ATOM   2921  C   HIS B 153      58.558  71.277 145.543  1.00 20.03           C  
ATOM   2922  O   HIS B 153      59.435  71.633 146.333  1.00 20.90           O  
ATOM   2923  CB  HIS B 153      59.061  70.556 143.228  1.00 18.54           C  
ATOM   2924  CG  HIS B 153      57.886  71.170 142.535  1.00 19.29           C  
ATOM   2925  ND1 HIS B 153      57.926  72.430 141.976  1.00 19.05           N  
ATOM   2926  CD2 HIS B 153      56.639  70.695 142.306  1.00 17.22           C  
ATOM   2927  CE1 HIS B 153      56.753  72.704 141.432  1.00 20.23           C  
ATOM   2928  NE2 HIS B 153      55.954  71.668 141.619  1.00 20.89           N  
ATOM   2929  N   TYR B 154      57.401  71.914 145.420  1.00 20.09           N  
ATOM   2930  CA  TYR B 154      57.099  73.094 146.211  1.00 18.95           C  
ATOM   2931  C   TYR B 154      57.015  72.757 147.687  1.00 18.01           C  
ATOM   2932  O   TYR B 154      57.697  73.356 148.515  1.00 19.49           O  
ATOM   2933  CB  TYR B 154      55.778  73.705 145.754  1.00 18.70           C  
ATOM   2934  CG  TYR B 154      55.387  74.932 146.539  1.00 19.73           C  
ATOM   2935  CD1 TYR B 154      54.138  75.015 147.154  1.00 17.80           C  
ATOM   2936  CD2 TYR B 154      56.265  76.008 146.672  1.00 17.50           C  
ATOM   2937  CE1 TYR B 154      53.774  76.129 147.880  1.00 17.21           C  
ATOM   2938  CE2 TYR B 154      55.908  77.139 147.400  1.00 18.88           C  
ATOM   2939  CZ  TYR B 154      54.657  77.188 148.002  1.00 19.07           C  
ATOM   2940  OH  TYR B 154      54.283  78.288 148.738  1.00 17.30           O  
ATOM   2941  N   ILE B 155      56.169  71.794 148.010  1.00 17.52           N  
ATOM   2942  CA  ILE B 155      55.980  71.379 149.389  1.00 18.04           C  
ATOM   2943  C   ILE B 155      57.253  70.840 150.061  1.00 18.35           C  
ATOM   2944  O   ILE B 155      57.433  70.997 151.271  1.00 18.39           O  
ATOM   2945  CB  ILE B 155      54.840  70.351 149.466  1.00 16.71           C  
ATOM   2946  CG1 ILE B 155      53.520  71.058 149.123  1.00 16.09           C  
ATOM   2947  CG2 ILE B 155      54.789  69.715 150.850  1.00 14.66           C  
ATOM   2948  CD1 ILE B 155      52.306  70.137 149.047  1.00 14.37           C  
ATOM   2949  N   SER B 156      58.140  70.221 149.287  1.00 17.84           N  
ATOM   2950  CA  SER B 156      59.383  69.709 149.857  1.00 16.78           C  
ATOM   2951  C   SER B 156      60.265  70.882 150.262  1.00 17.23           C  
ATOM   2952  O   SER B 156      60.995  70.805 151.252  1.00 19.41           O  
ATOM   2953  CB  SER B 156      60.132  68.830 148.854  1.00 16.91           C  
ATOM   2954  OG  SER B 156      59.445  67.614 148.612  1.00 20.13           O  
ATOM   2955  N   THR B 157      60.201  71.974 149.504  1.00 16.04           N  
ATOM   2956  CA  THR B 157      61.010  73.140 149.836  1.00 16.00           C  
ATOM   2957  C   THR B 157      60.388  73.891 151.017  1.00 15.84           C  
ATOM   2958  O   THR B 157      61.093  74.441 151.862  1.00 14.87           O  
ATOM   2959  CB  THR B 157      61.156  74.115 148.627  1.00 15.19           C  
ATOM   2960  OG1 THR B 157      59.886  74.704 148.312  1.00 13.64           O  
ATOM   2961  CG2 THR B 157      61.693  73.380 147.405  1.00 13.55           C  
ATOM   2962  N   LYS B 158      59.061  73.910 151.071  1.00 15.75           N  
ATOM   2963  CA  LYS B 158      58.380  74.603 152.148  1.00 16.06           C  
ATOM   2964  C   LYS B 158      58.673  73.901 153.469  1.00 16.27           C  
ATOM   2965  O   LYS B 158      58.813  74.547 154.509  1.00 16.34           O  
ATOM   2966  CB  LYS B 158      56.881  74.646 151.876  1.00 15.59           C  
ATOM   2967  CG  LYS B 158      56.498  75.612 150.758  1.00 16.41           C  
ATOM   2968  CD  LYS B 158      56.913  77.051 151.104  1.00 17.31           C  
ATOM   2969  CE  LYS B 158      58.011  77.566 150.160  1.00 14.97           C  
ATOM   2970  NZ  LYS B 158      58.508  78.923 150.529  1.00 13.17           N  
ATOM   2971  N   ALA B 159      58.766  72.577 153.416  1.00 16.86           N  
ATOM   2972  CA  ALA B 159      59.072  71.783 154.598  1.00 18.21           C  
ATOM   2973  C   ALA B 159      60.533  72.068 154.981  1.00 20.03           C  
ATOM   2974  O   ALA B 159      60.872  72.175 156.164  1.00 19.48           O  
ATOM   2975  CB  ALA B 159      58.877  70.308 154.298  1.00 17.59           C  
ATOM   2976  N   ALA B 160      61.394  72.199 153.973  1.00 19.63           N  
ATOM   2977  CA  ALA B 160      62.796  72.499 154.228  1.00 20.76           C  
ATOM   2978  C   ALA B 160      62.883  73.858 154.917  1.00 21.35           C  
ATOM   2979  O   ALA B 160      63.700  74.048 155.821  1.00 22.56           O  
ATOM   2980  CB  ALA B 160      63.586  72.521 152.925  1.00 17.79           C  
ATOM   2981  N   ASN B 161      62.044  74.800 154.487  1.00 19.84           N  
ATOM   2982  CA  ASN B 161      62.031  76.129 155.087  1.00 20.17           C  
ATOM   2983  C   ASN B 161      61.818  75.987 156.592  1.00 20.24           C  
ATOM   2984  O   ASN B 161      62.479  76.645 157.389  1.00 21.69           O  
ATOM   2985  CB  ASN B 161      60.899  76.985 154.508  1.00 19.72           C  
ATOM   2986  CG  ASN B 161      61.165  77.442 153.075  1.00 21.59           C  
ATOM   2987  OD1 ASN B 161      60.240  77.830 152.369  1.00 24.01           O  
ATOM   2988  ND2 ASN B 161      62.424  77.411 152.651  1.00 20.68           N  
ATOM   2989  N   ILE B 162      60.887  75.123 156.975  1.00 19.69           N  
ATOM   2990  CA  ILE B 162      60.597  74.910 158.380  1.00 17.86           C  
ATOM   2991  C   ILE B 162      61.781  74.247 159.081  1.00 19.16           C  
ATOM   2992  O   ILE B 162      62.164  74.652 160.180  1.00 20.97           O  
ATOM   2993  CB  ILE B 162      59.334  74.057 158.547  1.00 16.00           C  
ATOM   2994  CG1 ILE B 162      58.132  74.830 158.004  1.00 14.51           C  
ATOM   2995  CG2 ILE B 162      59.125  73.696 160.018  1.00 12.38           C  
ATOM   2996  CD1 ILE B 162      56.803  74.082 158.138  1.00 14.41           C  
ATOM   2997  N   GLY B 163      62.370  73.244 158.440  1.00 19.69           N  
ATOM   2998  CA  GLY B 163      63.514  72.575 159.031  1.00 18.38           C  
ATOM   2999  C   GLY B 163      64.639  73.570 159.230  1.00 18.90           C  
ATOM   3000  O   GLY B 163      65.339  73.553 160.250  1.00 16.81           O  
ATOM   3001  N   PHE B 164      64.806  74.455 158.252  1.00 18.27           N  
ATOM   3002  CA  PHE B 164      65.847  75.476 158.310  1.00 18.24           C  
ATOM   3003  C   PHE B 164      65.563  76.417 159.481  1.00 18.22           C  
ATOM   3004  O   PHE B 164      66.465  76.802 160.222  1.00 16.16           O  
ATOM   3005  CB  PHE B 164      65.876  76.247 156.992  1.00 19.35           C  
ATOM   3006  CG  PHE B 164      66.926  77.313 156.929  1.00 21.83           C  
ATOM   3007  CD1 PHE B 164      68.270  76.987 156.982  1.00 22.26           C  
ATOM   3008  CD2 PHE B 164      66.567  78.644 156.793  1.00 21.18           C  
ATOM   3009  CE1 PHE B 164      69.235  77.966 156.899  1.00 21.19           C  
ATOM   3010  CE2 PHE B 164      67.529  79.629 156.709  1.00 23.36           C  
ATOM   3011  CZ  PHE B 164      68.864  79.290 156.761  1.00 22.73           C  
ATOM   3012  N   THR B 165      64.292  76.774 159.643  1.00 18.54           N  
ATOM   3013  CA  THR B 165      63.867  77.647 160.730  1.00 19.28           C  
ATOM   3014  C   THR B 165      64.240  77.029 162.086  1.00 18.77           C  
ATOM   3015  O   THR B 165      64.913  77.654 162.900  1.00 20.44           O  
ATOM   3016  CB  THR B 165      62.330  77.874 160.678  1.00 21.05           C  
ATOM   3017  OG1 THR B 165      61.990  78.557 159.463  1.00 20.01           O  
ATOM   3018  CG2 THR B 165      61.853  78.691 161.877  1.00 16.27           C  
ATOM   3019  N   ARG B 166      63.817  75.792 162.310  1.00 17.11           N  
ATOM   3020  CA  ARG B 166      64.084  75.094 163.569  1.00 17.93           C  
ATOM   3021  C   ARG B 166      65.552  74.890 163.929  1.00 18.30           C  
ATOM   3022  O   ARG B 166      65.934  75.078 165.081  1.00 21.13           O  
ATOM   3023  CB  ARG B 166      63.385  73.728 163.566  1.00 15.84           C  
ATOM   3024  CG  ARG B 166      61.882  73.815 163.476  1.00 15.45           C  
ATOM   3025  CD  ARG B 166      61.251  72.444 163.442  1.00 16.38           C  
ATOM   3026  NE  ARG B 166      59.796  72.534 163.340  1.00 15.62           N  
ATOM   3027  CZ  ARG B 166      58.980  71.485 163.352  1.00 16.71           C  
ATOM   3028  NH1 ARG B 166      59.475  70.258 163.459  1.00 11.30           N  
ATOM   3029  NH2 ARG B 166      57.666  71.668 163.261  1.00 16.81           N  
ATOM   3030  N   ALA B 167      66.366  74.500 162.951  1.00 17.34           N  
ATOM   3031  CA  ALA B 167      67.793  74.249 163.175  1.00 17.81           C  
ATOM   3032  C   ALA B 167      68.613  75.503 163.405  1.00 15.78           C  
ATOM   3033  O   ALA B 167      69.465  75.540 164.287  1.00 17.81           O  
ATOM   3034  CB  ALA B 167      68.377  73.469 162.001  1.00 15.91           C  
ATOM   3035  N   LEU B 168      68.373  76.526 162.599  1.00 17.03           N  
ATOM   3036  CA  LEU B 168      69.106  77.773 162.749  1.00 18.47           C  
ATOM   3037  C   LEU B 168      68.740  78.422 164.096  1.00 18.94           C  
ATOM   3038  O   LEU B 168      69.567  79.079 164.727  1.00 21.35           O  
ATOM   3039  CB  LEU B 168      68.793  78.714 161.580  1.00 16.05           C  
ATOM   3040  CG  LEU B 168      69.719  79.924 161.429  1.00 16.36           C  
ATOM   3041  CD1 LEU B 168      71.159  79.451 161.214  1.00 15.38           C  
ATOM   3042  CD2 LEU B 168      69.259  80.779 160.263  1.00 10.30           C  
ATOM   3043  N   ALA B 169      67.505  78.225 164.542  1.00 18.41           N  
ATOM   3044  CA  ALA B 169      67.082  78.775 165.822  1.00 19.53           C  
ATOM   3045  C   ALA B 169      67.982  78.194 166.909  1.00 21.14           C  
ATOM   3046  O   ALA B 169      68.444  78.906 167.796  1.00 21.67           O  
ATOM   3047  CB  ALA B 169      65.635  78.412 166.100  1.00 18.15           C  
ATOM   3048  N   SER B 170      68.230  76.890 166.840  1.00 21.17           N  
ATOM   3049  CA  SER B 170      69.085  76.245 167.825  1.00 21.12           C  
ATOM   3050  C   SER B 170      70.519  76.764 167.744  1.00 22.14           C  
ATOM   3051  O   SER B 170      71.165  76.975 168.769  1.00 22.98           O  
ATOM   3052  CB  SER B 170      69.078  74.733 167.619  1.00 20.03           C  
ATOM   3053  OG  SER B 170      67.780  74.210 167.811  1.00 20.42           O  
ATOM   3054  N   ASP B 171      71.011  76.977 166.526  1.00 21.81           N  
ATOM   3055  CA  ASP B 171      72.375  77.462 166.340  1.00 21.77           C  
ATOM   3056  C   ASP B 171      72.582  78.904 166.781  1.00 21.75           C  
ATOM   3057  O   ASP B 171      73.670  79.271 167.218  1.00 23.07           O  
ATOM   3058  CB  ASP B 171      72.794  77.338 164.872  1.00 23.54           C  
ATOM   3059  CG  ASP B 171      73.319  75.958 164.524  1.00 25.06           C  
ATOM   3060  OD1 ASP B 171      73.323  75.078 165.411  1.00 26.31           O  
ATOM   3061  OD2 ASP B 171      73.731  75.756 163.361  1.00 24.88           O  
ATOM   3062  N   LEU B 172      71.542  79.721 166.669  1.00 19.88           N  
ATOM   3063  CA  LEU B 172      71.656  81.130 167.026  1.00 18.85           C  
ATOM   3064  C   LEU B 172      71.006  81.519 168.350  1.00 19.33           C  
ATOM   3065  O   LEU B 172      71.002  82.691 168.703  1.00 20.42           O  
ATOM   3066  CB  LEU B 172      71.063  81.985 165.902  1.00 17.60           C  
ATOM   3067  CG  LEU B 172      71.563  81.606 164.502  1.00 15.34           C  
ATOM   3068  CD1 LEU B 172      70.986  82.553 163.468  1.00 13.22           C  
ATOM   3069  CD2 LEU B 172      73.076  81.647 164.471  1.00 13.59           C  
ATOM   3070  N   GLY B 173      70.475  80.537 169.075  1.00 19.84           N  
ATOM   3071  CA  GLY B 173      69.805  80.801 170.337  1.00 22.97           C  
ATOM   3072  C   GLY B 173      70.551  81.635 171.367  1.00 25.81           C  
ATOM   3073  O   GLY B 173      69.970  82.518 172.005  1.00 23.91           O  
ATOM   3074  N   LYS B 174      71.839  81.359 171.529  1.00 27.06           N  
ATOM   3075  CA  LYS B 174      72.654  82.078 172.495  1.00 29.91           C  
ATOM   3076  C   LYS B 174      73.190  83.407 171.970  1.00 29.62           C  
ATOM   3077  O   LYS B 174      73.944  84.083 172.663  1.00 30.03           O  
ATOM   3078  CB  LYS B 174      73.832  81.200 172.919  1.00 33.18           C  
ATOM   3079  CG  LYS B 174      73.426  79.903 173.599  1.00 38.13           C  
ATOM   3080  CD  LYS B 174      74.633  79.006 173.835  1.00 40.86           C  
ATOM   3081  CE  LYS B 174      74.215  77.642 174.362  1.00 43.18           C  
ATOM   3082  NZ  LYS B 174      75.353  76.669 174.353  1.00 47.86           N  
ATOM   3083  N   ASP B 175      72.790  83.797 170.763  1.00 28.71           N  
ATOM   3084  CA  ASP B 175      73.295  85.031 170.175  1.00 27.70           C  
ATOM   3085  C   ASP B 175      72.327  86.201 170.091  1.00 26.74           C  
ATOM   3086  O   ASP B 175      72.565  87.149 169.337  1.00 26.61           O  
ATOM   3087  CB  ASP B 175      73.847  84.735 168.785  1.00 29.51           C  
ATOM   3088  CG  ASP B 175      74.881  83.640 168.805  1.00 32.72           C  
ATOM   3089  OD1 ASP B 175      75.846  83.766 169.590  1.00 35.51           O  
ATOM   3090  OD2 ASP B 175      74.734  82.659 168.044  1.00 34.37           O  
ATOM   3091  N   GLY B 176      71.249  86.145 170.864  1.00 24.78           N  
ATOM   3092  CA  GLY B 176      70.275  87.221 170.846  1.00 21.96           C  
ATOM   3093  C   GLY B 176      69.514  87.289 169.534  1.00 21.45           C  
ATOM   3094  O   GLY B 176      68.923  88.320 169.198  1.00 19.61           O  
ATOM   3095  N   ILE B 177      69.529  86.187 168.788  1.00 19.75           N  
ATOM   3096  CA  ILE B 177      68.839  86.121 167.503  1.00 19.55           C  
ATOM   3097  C   ILE B 177      67.768  85.049 167.548  1.00 20.77           C  
ATOM   3098  O   ILE B 177      68.023  83.952 168.046  1.00 20.41           O  
ATOM   3099  CB  ILE B 177      69.802  85.737 166.362  1.00 19.44           C  
ATOM   3100  CG1 ILE B 177      70.956  86.737 166.285  1.00 19.25           C  
ATOM   3101  CG2 ILE B 177      69.038  85.654 165.050  1.00 16.78           C  
ATOM   3102  CD1 ILE B 177      72.116  86.266 165.440  1.00 21.32           C  
ATOM   3103  N   THR B 178      66.572  85.361 167.050  1.00 21.28           N  
ATOM   3104  CA  THR B 178      65.507  84.364 167.017  1.00 21.12           C  
ATOM   3105  C   THR B 178      65.213  84.038 165.567  1.00 21.88           C  
ATOM   3106  O   THR B 178      65.360  84.890 164.687  1.00 24.17           O  
ATOM   3107  CB  THR B 178      64.191  84.843 167.699  1.00 22.40           C  
ATOM   3108  OG1 THR B 178      63.596  85.898 166.933  1.00 21.46           O  
ATOM   3109  CG2 THR B 178      64.464  85.317 169.124  1.00 19.59           C  
ATOM   3110  N   VAL B 179      64.818  82.795 165.314  1.00 20.56           N  
ATOM   3111  CA  VAL B 179      64.492  82.361 163.960  1.00 18.94           C  
ATOM   3112  C   VAL B 179      63.097  81.735 163.986  1.00 19.00           C  
ATOM   3113  O   VAL B 179      62.854  80.771 164.710  1.00 16.52           O  
ATOM   3114  CB  VAL B 179      65.531  81.332 163.432  1.00 19.04           C  
ATOM   3115  CG1 VAL B 179      65.266  81.023 161.967  1.00 16.47           C  
ATOM   3116  CG2 VAL B 179      66.956  81.887 163.604  1.00 16.75           C  
ATOM   3117  N   ASN B 180      62.182  82.299 163.203  1.00 19.56           N  
ATOM   3118  CA  ASN B 180      60.806  81.801 163.154  1.00 19.28           C  
ATOM   3119  C   ASN B 180      60.251  81.782 161.728  1.00 18.68           C  
ATOM   3120  O   ASN B 180      60.869  82.315 160.805  1.00 19.74           O  
ATOM   3121  CB  ASN B 180      59.906  82.667 164.042  1.00 18.38           C  
ATOM   3122  CG  ASN B 180      60.260  82.565 165.516  1.00 19.52           C  
ATOM   3123  OD1 ASN B 180      60.164  81.494 166.120  1.00 18.11           O  
ATOM   3124  ND2 ASN B 180      60.666  83.684 166.106  1.00 18.92           N  
ATOM   3125  N   ALA B 181      59.081  81.170 161.555  1.00 16.87           N  
ATOM   3126  CA  ALA B 181      58.458  81.090 160.244  1.00 15.97           C  
ATOM   3127  C   ALA B 181      56.982  81.422 160.291  1.00 16.20           C  
ATOM   3128  O   ALA B 181      56.319  81.201 161.299  1.00 16.47           O  
ATOM   3129  CB  ALA B 181      58.645  79.682 159.655  1.00 17.63           C  
ATOM   3130  N   ILE B 182      56.477  81.955 159.184  1.00 16.53           N  
ATOM   3131  CA  ILE B 182      55.064  82.292 159.051  1.00 16.53           C  
ATOM   3132  C   ILE B 182      54.489  81.441 157.914  1.00 18.62           C  
ATOM   3133  O   ILE B 182      55.096  81.341 156.840  1.00 19.27           O  
ATOM   3134  CB  ILE B 182      54.865  83.772 158.688  1.00 16.37           C  
ATOM   3135  CG1 ILE B 182      55.262  84.667 159.865  1.00 16.68           C  
ATOM   3136  CG2 ILE B 182      53.420  84.010 158.295  1.00 15.22           C  
ATOM   3137  CD1 ILE B 182      55.222  86.163 159.543  1.00 13.16           C  
ATOM   3138  N   ALA B 183      53.335  80.819 158.153  1.00 18.22           N  
ATOM   3139  CA  ALA B 183      52.688  79.981 157.140  1.00 19.52           C  
ATOM   3140  C   ALA B 183      51.350  80.587 156.721  1.00 20.88           C  
ATOM   3141  O   ALA B 183      50.347  80.486 157.434  1.00 20.50           O  
ATOM   3142  CB  ALA B 183      52.474  78.549 157.683  1.00 16.26           C  
ATOM   3143  N   PRO B 184      51.315  81.242 155.559  1.00 22.88           N  
ATOM   3144  CA  PRO B 184      50.025  81.817 155.169  1.00 24.88           C  
ATOM   3145  C   PRO B 184      49.118  80.832 154.428  1.00 27.61           C  
ATOM   3146  O   PRO B 184      49.573  79.791 153.951  1.00 28.49           O  
ATOM   3147  CB  PRO B 184      50.429  83.017 154.318  1.00 23.73           C  
ATOM   3148  CG  PRO B 184      51.697  82.541 153.652  1.00 23.95           C  
ATOM   3149  CD  PRO B 184      52.423  81.774 154.746  1.00 21.86           C  
ATOM   3150  N   SER B 185      47.827  81.155 154.371  1.00 30.45           N  
ATOM   3151  CA  SER B 185      46.839  80.334 153.675  1.00 31.79           C  
ATOM   3152  C   SER B 185      46.989  80.722 152.217  1.00 33.40           C  
ATOM   3153  O   SER B 185      48.082  81.068 151.777  1.00 31.35           O  
ATOM   3154  CB  SER B 185      45.420  80.686 154.157  1.00 33.28           C  
ATOM   3155  OG  SER B 185      44.420  79.868 153.566  1.00 32.02           O  
ATOM   3156  N   LEU B 186      45.897  80.660 151.466  1.00 37.96           N  
ATOM   3157  CA  LEU B 186      45.930  81.065 150.066  1.00 41.28           C  
ATOM   3158  C   LEU B 186      45.698  82.577 150.122  1.00 43.99           C  
ATOM   3159  O   LEU B 186      44.602  83.032 150.436  1.00 45.05           O  
ATOM   3160  CB  LEU B 186      44.806  80.394 149.276  1.00 39.86           C  
ATOM   3161  CG  LEU B 186      44.881  80.478 147.746  1.00 39.36           C  
ATOM   3162  CD1 LEU B 186      43.567  79.978 147.173  1.00 37.05           C  
ATOM   3163  CD2 LEU B 186      45.144  81.910 147.286  1.00 38.63           C  
ATOM   3164  N   VAL B 187      46.740  83.345 149.829  1.00 47.90           N  
ATOM   3165  CA  VAL B 187      46.665  84.800 149.870  1.00 50.89           C  
ATOM   3166  C   VAL B 187      46.422  85.446 148.508  1.00 53.16           C  
ATOM   3167  O   VAL B 187      46.933  84.981 147.487  1.00 52.59           O  
ATOM   3168  CB  VAL B 187      47.956  85.384 150.463  1.00 50.74           C  
ATOM   3169  CG1 VAL B 187      47.882  86.904 150.485  1.00 49.66           C  
ATOM   3170  CG2 VAL B 187      48.176  84.818 151.862  1.00 49.48           C  
ATOM   3171  N   ARG B 188      45.645  86.526 148.506  1.00 55.44           N  
ATOM   3172  CA  ARG B 188      45.332  87.250 147.280  1.00 58.61           C  
ATOM   3173  C   ARG B 188      46.454  88.194 146.850  1.00 59.75           C  
ATOM   3174  O   ARG B 188      46.707  89.213 147.497  1.00 59.52           O  
ATOM   3175  CB  ARG B 188      44.043  88.059 147.447  1.00 59.79           C  
ATOM   3176  CG  ARG B 188      43.879  89.139 146.380  1.00 62.57           C  
ATOM   3177  CD  ARG B 188      42.654  90.018 146.614  1.00 63.82           C  
ATOM   3178  NE  ARG B 188      41.400  89.320 146.344  1.00 64.78           N  
ATOM   3179  CZ  ARG B 188      41.065  88.811 145.162  1.00 65.35           C  
ATOM   3180  NH1 ARG B 188      41.893  88.916 144.131  1.00 64.73           N  
ATOM   3181  NH2 ARG B 188      39.894  88.206 145.007  1.00 65.72           N  
ATOM   3182  N   THR B 189      47.123  87.848 145.755  1.00 60.26           N  
ATOM   3183  CA  THR B 189      48.203  88.666 145.222  1.00 60.81           C  
ATOM   3184  C   THR B 189      48.177  88.598 143.697  1.00 62.28           C  
ATOM   3185  O   THR B 189      47.535  87.723 143.116  1.00 61.11           O  
ATOM   3186  CB  THR B 189      49.586  88.193 145.722  1.00 60.22           C  
ATOM   3187  OG1 THR B 189      49.844  86.868 145.244  1.00 59.78           O  
ATOM   3188  CG2 THR B 189      49.636  88.201 147.242  1.00 59.26           C  
ATOM   3189  N   ALA B 190      48.879  89.526 143.058  1.00 64.53           N  
ATOM   3190  CA  ALA B 190      48.934  89.592 141.604  1.00 66.17           C  
ATOM   3191  C   ALA B 190      49.265  88.249 140.957  1.00 67.53           C  
ATOM   3192  O   ALA B 190      48.661  87.876 139.950  1.00 68.08           O  
ATOM   3193  CB  ALA B 190      49.952  90.644 141.175  1.00 66.93           C  
ATOM   3194  N   THR B 191      50.220  87.525 141.531  1.00 68.97           N  
ATOM   3195  CA  THR B 191      50.617  86.230 140.986  1.00 70.11           C  
ATOM   3196  C   THR B 191      49.527  85.167 141.144  1.00 71.27           C  
ATOM   3197  O   THR B 191      49.206  84.462 140.188  1.00 71.24           O  
ATOM   3198  CB  THR B 191      51.923  85.711 141.640  1.00 69.94           C  
ATOM   3199  OG1 THR B 191      51.711  85.489 143.040  1.00 70.27           O  
ATOM   3200  CG2 THR B 191      53.049  86.721 141.457  1.00 69.32           C  
ATOM   3201  N   THR B 192      48.960  85.054 142.343  1.00 72.20           N  
ATOM   3202  CA  THR B 192      47.911  84.064 142.589  1.00 72.98           C  
ATOM   3203  C   THR B 192      46.655  84.398 141.796  1.00 74.40           C  
ATOM   3204  O   THR B 192      45.975  83.503 141.294  1.00 75.12           O  
ATOM   3205  CB  THR B 192      47.529  83.979 144.087  1.00 71.91           C  
ATOM   3206  OG1 THR B 192      47.023  85.243 144.530  1.00 71.08           O  
ATOM   3207  CG2 THR B 192      48.735  83.585 144.925  1.00 70.74           C  
ATOM   3208  N   GLU B 193      46.348  85.688 141.689  1.00 75.69           N  
ATOM   3209  CA  GLU B 193      45.174  86.132 140.949  1.00 77.46           C  
ATOM   3210  C   GLU B 193      45.296  85.737 139.481  1.00 78.90           C  
ATOM   3211  O   GLU B 193      44.295  85.500 138.804  1.00 79.30           O  
ATOM   3212  CB  GLU B 193      45.011  87.650 141.068  1.00 76.58           C  
ATOM   3213  CG  GLU B 193      44.624  88.121 142.461  1.00 77.68           C  
ATOM   3214  CD  GLU B 193      44.506  89.633 142.560  1.00 78.52           C  
ATOM   3215  OE1 GLU B 193      44.147  90.133 143.647  1.00 78.87           O  
ATOM   3216  OE2 GLU B 193      44.773  90.323 141.553  1.00 78.48           O  
ATOM   3217  N   ALA B 194      46.532  85.661 138.997  1.00 80.38           N  
ATOM   3218  CA  ALA B 194      46.793  85.286 137.613  1.00 82.04           C  
ATOM   3219  C   ALA B 194      47.332  83.859 137.546  1.00 82.97           C  
ATOM   3220  O   ALA B 194      48.000  83.477 136.582  1.00 82.76           O  
ATOM   3221  CB  ALA B 194      47.793  86.255 136.992  1.00 82.24           C  
ATOM   3222  N   SER B 195      47.033  83.075 138.578  1.00 83.81           N  
ATOM   3223  CA  SER B 195      47.485  81.692 138.651  1.00 84.60           C  
ATOM   3224  C   SER B 195      46.297  80.737 138.651  1.00 85.30           C  
ATOM   3225  O   SER B 195      45.142  81.169 138.670  1.00 85.14           O  
ATOM   3226  CB  SER B 195      48.320  81.481 139.917  1.00 84.93           C  
ATOM   3227  OG  SER B 195      48.809  80.154 139.997  1.00 84.68           O  
ATOM   3228  N   ALA B 196      46.591  79.439 138.630  1.00 85.88           N  
ATOM   3229  CA  ALA B 196      45.559  78.406 138.624  1.00 85.82           C  
ATOM   3230  C   ALA B 196      44.876  78.289 139.979  1.00 86.26           C  
ATOM   3231  O   ALA B 196      43.848  77.624 140.108  1.00 87.05           O  
ATOM   3232  CB  ALA B 196      46.169  77.067 138.236  1.00 85.52           C  
ATOM   3233  N   LEU B 197      45.452  78.931 140.989  1.00 86.21           N  
ATOM   3234  CA  LEU B 197      44.894  78.896 142.336  1.00 85.60           C  
ATOM   3235  C   LEU B 197      43.688  79.823 142.447  1.00 85.44           C  
ATOM   3236  O   LEU B 197      42.851  79.664 143.335  1.00 85.13           O  
ATOM   3237  CB  LEU B 197      45.959  79.306 143.357  1.00 85.31           C  
ATOM   3238  CG  LEU B 197      47.177  78.387 143.482  1.00 84.73           C  
ATOM   3239  CD1 LEU B 197      48.165  78.974 144.477  1.00 84.12           C  
ATOM   3240  CD2 LEU B 197      46.730  77.003 143.929  1.00 84.85           C  
ATOM   3241  N   SER B 198      43.607  80.782 141.530  1.00 85.46           N  
ATOM   3242  CA  SER B 198      42.520  81.759 141.501  1.00 85.36           C  
ATOM   3243  C   SER B 198      41.129  81.123 141.594  1.00 85.40           C  
ATOM   3244  O   SER B 198      40.153  81.794 141.938  1.00 84.82           O  
ATOM   3245  CB  SER B 198      42.623  82.598 140.220  1.00 84.95           C  
ATOM   3246  OG  SER B 198      41.647  83.622 140.187  1.00 84.80           O  
ATOM   3247  N   ALA B 199      41.043  79.830 141.294  1.00 85.42           N  
ATOM   3248  CA  ALA B 199      39.772  79.112 141.339  1.00 85.15           C  
ATOM   3249  C   ALA B 199      39.284  78.879 142.766  1.00 84.97           C  
ATOM   3250  O   ALA B 199      38.080  78.907 143.031  1.00 85.09           O  
ATOM   3251  CB  ALA B 199      39.903  77.779 140.609  1.00 84.88           C  
ATOM   3252  N   MET B 200      40.221  78.651 143.682  1.00 84.78           N  
ATOM   3253  CA  MET B 200      39.890  78.402 145.084  1.00 84.21           C  
ATOM   3254  C   MET B 200      39.573  79.686 145.849  1.00 83.08           C  
ATOM   3255  O   MET B 200      39.094  79.636 146.983  1.00 83.44           O  
ATOM   3256  CB  MET B 200      41.051  77.679 145.773  1.00 85.09           C  
ATOM   3257  CG  MET B 200      41.454  76.372 145.114  1.00 85.58           C  
ATOM   3258  SD  MET B 200      42.950  75.686 145.850  1.00 86.97           S  
ATOM   3259  CE  MET B 200      42.255  74.502 147.010  1.00 87.24           C  
ATOM   3260  N   PHE B 201      39.846  80.827 145.224  1.00 81.53           N  
ATOM   3261  CA  PHE B 201      39.600  82.136 145.828  1.00 80.28           C  
ATOM   3262  C   PHE B 201      38.237  82.254 146.507  1.00 79.61           C  
ATOM   3263  O   PHE B 201      38.065  83.038 147.441  1.00 79.14           O  
ATOM   3264  CB  PHE B 201      39.729  83.229 144.762  1.00 79.57           C  
ATOM   3265  CG  PHE B 201      41.112  83.808 144.646  1.00 79.60           C  
ATOM   3266  CD1 PHE B 201      42.231  82.999 144.753  1.00 79.69           C  
ATOM   3267  CD2 PHE B 201      41.291  85.163 144.418  1.00 79.32           C  
ATOM   3268  CE1 PHE B 201      43.505  83.534 144.638  1.00 79.30           C  
ATOM   3269  CE2 PHE B 201      42.560  85.702 144.302  1.00 79.02           C  
ATOM   3270  CZ  PHE B 201      43.668  84.886 144.412  1.00 78.84           C  
ATOM   3271  N   ASP B 202      37.273  81.469 146.039  1.00 79.28           N  
ATOM   3272  CA  ASP B 202      35.923  81.503 146.585  1.00 78.89           C  
ATOM   3273  C   ASP B 202      35.496  80.198 147.256  1.00 77.66           C  
ATOM   3274  O   ASP B 202      34.445  80.133 147.894  1.00 77.58           O  
ATOM   3275  CB  ASP B 202      34.944  81.862 145.466  1.00 80.63           C  
ATOM   3276  CG  ASP B 202      35.350  81.269 144.127  1.00 82.08           C  
ATOM   3277  OD1 ASP B 202      35.484  80.029 144.036  1.00 82.96           O  
ATOM   3278  OD2 ASP B 202      35.542  82.043 143.163  1.00 82.29           O  
ATOM   3279  N   VAL B 203      36.315  79.162 147.116  1.00 76.14           N  
ATOM   3280  CA  VAL B 203      36.005  77.866 147.706  1.00 74.74           C  
ATOM   3281  C   VAL B 203      36.640  77.696 149.084  1.00 72.78           C  
ATOM   3282  O   VAL B 203      35.957  77.744 150.107  1.00 72.31           O  
ATOM   3283  CB  VAL B 203      36.495  76.713 146.800  1.00 75.55           C  
ATOM   3284  CG1 VAL B 203      36.202  75.372 147.456  1.00 75.47           C  
ATOM   3285  CG2 VAL B 203      35.826  76.803 145.439  1.00 75.19           C  
ATOM   3286  N   LEU B 204      37.953  77.502 149.089  1.00 70.66           N  
ATOM   3287  CA  LEU B 204      38.721  77.297 150.311  1.00 68.97           C  
ATOM   3288  C   LEU B 204      38.344  78.215 151.478  1.00 67.00           C  
ATOM   3289  O   LEU B 204      38.063  77.740 152.578  1.00 66.63           O  
ATOM   3290  CB  LEU B 204      40.218  77.431 149.996  1.00 68.97           C  
ATOM   3291  CG  LEU B 204      41.251  76.995 151.040  1.00 69.89           C  
ATOM   3292  CD1 LEU B 204      42.625  77.011 150.392  1.00 70.98           C  
ATOM   3293  CD2 LEU B 204      41.227  77.909 152.257  1.00 70.49           C  
ATOM   3294  N   PRO B 205      38.338  79.539 151.255  1.00 65.29           N  
ATOM   3295  CA  PRO B 205      37.994  80.494 152.315  1.00 64.60           C  
ATOM   3296  C   PRO B 205      36.721  80.188 153.102  1.00 63.74           C  
ATOM   3297  O   PRO B 205      36.783  79.851 154.282  1.00 63.77           O  
ATOM   3298  CB  PRO B 205      37.916  81.819 151.563  1.00 64.10           C  
ATOM   3299  CG  PRO B 205      38.989  81.657 150.535  1.00 63.89           C  
ATOM   3300  CD  PRO B 205      38.724  80.252 150.025  1.00 64.96           C  
ATOM   3301  N   ASN B 206      35.567  80.303 152.457  1.00 63.41           N  
ATOM   3302  CA  ASN B 206      34.308  80.047 153.145  1.00 63.23           C  
ATOM   3303  C   ASN B 206      33.944  78.566 153.171  1.00 61.55           C  
ATOM   3304  O   ASN B 206      32.768  78.205 153.131  1.00 61.51           O  
ATOM   3305  CB  ASN B 206      33.176  80.861 152.501  1.00 65.26           C  
ATOM   3306  CG  ASN B 206      32.932  80.488 151.048  1.00 67.44           C  
ATOM   3307  OD1 ASN B 206      32.458  79.390 150.744  1.00 68.79           O  
ATOM   3308  ND2 ASN B 206      33.260  81.402 150.141  1.00 67.20           N  
ATOM   3309  N   MET B 207      34.955  77.706 153.248  1.00 59.48           N  
ATOM   3310  CA  MET B 207      34.703  76.274 153.285  1.00 56.92           C  
ATOM   3311  C   MET B 207      35.653  75.550 154.231  1.00 53.22           C  
ATOM   3312  O   MET B 207      35.212  74.894 155.174  1.00 53.20           O  
ATOM   3313  CB  MET B 207      34.810  75.684 151.877  1.00 60.07           C  
ATOM   3314  CG  MET B 207      34.142  74.326 151.719  1.00 63.59           C  
ATOM   3315  SD  MET B 207      33.725  73.958 149.992  1.00 69.66           S  
ATOM   3316  CE  MET B 207      32.164  74.871 149.828  1.00 66.50           C  
ATOM   3317  N   LEU B 208      36.954  75.676 153.990  1.00 48.32           N  
ATOM   3318  CA  LEU B 208      37.937  75.015 154.836  1.00 43.16           C  
ATOM   3319  C   LEU B 208      38.543  75.928 155.899  1.00 38.87           C  
ATOM   3320  O   LEU B 208      39.376  75.494 156.692  1.00 38.11           O  
ATOM   3321  CB  LEU B 208      39.047  74.401 153.979  1.00 44.65           C  
ATOM   3322  CG  LEU B 208      38.665  73.154 153.170  1.00 45.00           C  
ATOM   3323  CD1 LEU B 208      37.603  73.510 152.138  1.00 45.16           C  
ATOM   3324  CD2 LEU B 208      39.901  72.589 152.488  1.00 45.09           C  
ATOM   3325  N   GLN B 209      38.123  77.190 155.918  1.00 35.21           N  
ATOM   3326  CA  GLN B 209      38.629  78.135 156.911  1.00 31.49           C  
ATOM   3327  C   GLN B 209      37.604  78.351 158.012  1.00 28.75           C  
ATOM   3328  O   GLN B 209      36.408  78.163 157.806  1.00 28.52           O  
ATOM   3329  CB  GLN B 209      38.956  79.492 156.272  1.00 31.01           C  
ATOM   3330  CG  GLN B 209      40.191  79.509 155.386  1.00 30.94           C  
ATOM   3331  CD  GLN B 209      40.485  80.889 154.808  1.00 31.37           C  
ATOM   3332  OE1 GLN B 209      41.410  81.059 154.013  1.00 32.50           O  
ATOM   3333  NE2 GLN B 209      39.698  81.878 155.204  1.00 29.74           N  
ATOM   3334  N   ALA B 210      38.081  78.734 159.189  1.00 27.88           N  
ATOM   3335  CA  ALA B 210      37.191  79.016 160.305  1.00 27.17           C  
ATOM   3336  C   ALA B 210      36.611  80.401 160.034  1.00 27.17           C  
ATOM   3337  O   ALA B 210      35.445  80.674 160.314  1.00 28.70           O  
ATOM   3338  CB  ALA B 210      37.965  79.013 161.614  1.00 25.54           C  
ATOM   3339  N   ILE B 211      37.449  81.272 159.481  1.00 27.29           N  
ATOM   3340  CA  ILE B 211      37.067  82.637 159.149  1.00 27.55           C  
ATOM   3341  C   ILE B 211      36.819  82.691 157.647  1.00 29.31           C  
ATOM   3342  O   ILE B 211      37.755  82.636 156.852  1.00 28.43           O  
ATOM   3343  CB  ILE B 211      38.190  83.617 159.550  1.00 27.30           C  
ATOM   3344  CG1 ILE B 211      38.394  83.564 161.066  1.00 24.10           C  
ATOM   3345  CG2 ILE B 211      37.846  85.035 159.102  1.00 27.84           C  
ATOM   3346  CD1 ILE B 211      39.598  84.326 161.546  1.00 24.80           C  
ATOM   3347  N   PRO B 212      35.540  82.793 157.243  1.00 31.07           N  
ATOM   3348  CA  PRO B 212      35.063  82.851 155.855  1.00 33.46           C  
ATOM   3349  C   PRO B 212      35.440  84.139 155.141  1.00 35.45           C  
ATOM   3350  O   PRO B 212      34.580  84.973 154.851  1.00 37.61           O  
ATOM   3351  CB  PRO B 212      33.558  82.708 156.013  1.00 33.52           C  
ATOM   3352  CG  PRO B 212      33.311  83.513 157.251  1.00 32.78           C  
ATOM   3353  CD  PRO B 212      34.425  83.025 158.179  1.00 31.03           C  
ATOM   3354  N   ARG B 213      36.724  84.298 154.851  1.00 35.69           N  
ATOM   3355  CA  ARG B 213      37.200  85.503 154.187  1.00 35.32           C  
ATOM   3356  C   ARG B 213      38.510  85.194 153.494  1.00 34.78           C  
ATOM   3357  O   ARG B 213      39.380  84.546 154.072  1.00 34.05           O  
ATOM   3358  CB  ARG B 213      37.426  86.601 155.224  1.00 37.33           C  
ATOM   3359  CG  ARG B 213      37.659  87.976 154.646  1.00 41.44           C  
ATOM   3360  CD  ARG B 213      38.452  88.828 155.615  1.00 44.91           C  
ATOM   3361  NE  ARG B 213      37.900  88.815 156.962  1.00 48.02           N  
ATOM   3362  CZ  ARG B 213      38.605  89.105 158.050  1.00 51.59           C  
ATOM   3363  NH1 ARG B 213      39.891  89.426 157.943  1.00 51.50           N  
ATOM   3364  NH2 ARG B 213      38.028  89.078 159.246  1.00 54.07           N  
ATOM   3365  N   LEU B 214      38.649  85.644 152.252  1.00 34.07           N  
ATOM   3366  CA  LEU B 214      39.877  85.412 151.510  1.00 33.87           C  
ATOM   3367  C   LEU B 214      40.968  86.250 152.163  1.00 33.98           C  
ATOM   3368  O   LEU B 214      40.750  87.408 152.523  1.00 34.51           O  
ATOM   3369  CB  LEU B 214      39.707  85.817 150.041  1.00 35.21           C  
ATOM   3370  CG  LEU B 214      40.893  85.565 149.102  1.00 36.89           C  
ATOM   3371  CD1 LEU B 214      41.242  84.076 149.065  1.00 34.85           C  
ATOM   3372  CD2 LEU B 214      40.543  86.061 147.709  1.00 38.15           C  
ATOM   3373  N   GLN B 215      42.140  85.654 152.325  1.00 33.45           N  
ATOM   3374  CA  GLN B 215      43.255  86.349 152.944  1.00 33.30           C  
ATOM   3375  C   GLN B 215      43.921  87.360 152.013  1.00 31.90           C  
ATOM   3376  O   GLN B 215      44.018  87.135 150.807  1.00 30.59           O  
ATOM   3377  CB  GLN B 215      44.297  85.334 153.414  1.00 34.56           C  
ATOM   3378  CG  GLN B 215      45.457  85.961 154.149  1.00 37.70           C  
ATOM   3379  CD  GLN B 215      46.346  84.936 154.816  1.00 41.61           C  
ATOM   3380  OE1 GLN B 215      47.167  85.275 155.671  1.00 43.11           O  
ATOM   3381  NE2 GLN B 215      46.194  83.674 154.429  1.00 43.20           N  
ATOM   3382  N   VAL B 216      44.369  88.474 152.588  1.00 30.17           N  
ATOM   3383  CA  VAL B 216      45.069  89.515 151.841  1.00 27.60           C  
ATOM   3384  C   VAL B 216      46.350  89.829 152.614  1.00 26.75           C  
ATOM   3385  O   VAL B 216      46.412  89.636 153.824  1.00 25.12           O  
ATOM   3386  CB  VAL B 216      44.219  90.806 151.702  1.00 27.01           C  
ATOM   3387  CG1 VAL B 216      42.978  90.523 150.869  1.00 23.59           C  
ATOM   3388  CG2 VAL B 216      43.841  91.336 153.078  1.00 25.03           C  
ATOM   3389  N   PRO B 217      47.383  90.330 151.920  1.00 28.21           N  
ATOM   3390  CA  PRO B 217      48.685  90.675 152.510  1.00 27.11           C  
ATOM   3391  C   PRO B 217      48.648  91.301 153.899  1.00 27.16           C  
ATOM   3392  O   PRO B 217      49.374  90.875 154.790  1.00 28.70           O  
ATOM   3393  CB  PRO B 217      49.293  91.602 151.464  1.00 26.41           C  
ATOM   3394  CG  PRO B 217      48.795  90.989 150.183  1.00 27.44           C  
ATOM   3395  CD  PRO B 217      47.329  90.747 150.505  1.00 27.26           C  
ATOM   3396  N   LEU B 218      47.802  92.304 154.090  1.00 27.40           N  
ATOM   3397  CA  LEU B 218      47.707  92.960 155.384  1.00 27.05           C  
ATOM   3398  C   LEU B 218      47.354  92.026 156.540  1.00 26.31           C  
ATOM   3399  O   LEU B 218      47.537  92.387 157.701  1.00 26.53           O  
ATOM   3400  CB  LEU B 218      46.697  94.112 155.327  1.00 27.60           C  
ATOM   3401  CG  LEU B 218      47.205  95.434 154.746  1.00 29.34           C  
ATOM   3402  CD1 LEU B 218      46.062  96.444 154.733  1.00 30.32           C  
ATOM   3403  CD2 LEU B 218      48.374  95.966 155.573  1.00 26.47           C  
ATOM   3404  N   ASP B 219      46.853  90.832 156.241  1.00 24.95           N  
ATOM   3405  CA  ASP B 219      46.524  89.895 157.316  1.00 25.96           C  
ATOM   3406  C   ASP B 219      47.787  89.299 157.956  1.00 25.71           C  
ATOM   3407  O   ASP B 219      47.769  88.889 159.119  1.00 23.96           O  
ATOM   3408  CB  ASP B 219      45.624  88.766 156.800  1.00 25.18           C  
ATOM   3409  CG  ASP B 219      44.214  89.241 156.486  1.00 26.46           C  
ATOM   3410  OD1 ASP B 219      43.631  89.960 157.330  1.00 24.89           O  
ATOM   3411  OD2 ASP B 219      43.683  88.889 155.408  1.00 26.40           O  
ATOM   3412  N   LEU B 220      48.883  89.281 157.201  1.00 26.83           N  
ATOM   3413  CA  LEU B 220      50.148  88.723 157.679  1.00 27.89           C  
ATOM   3414  C   LEU B 220      51.081  89.708 158.366  1.00 27.56           C  
ATOM   3415  O   LEU B 220      51.881  89.319 159.214  1.00 28.92           O  
ATOM   3416  CB  LEU B 220      50.932  88.097 156.522  1.00 29.10           C  
ATOM   3417  CG  LEU B 220      50.380  86.880 155.787  1.00 31.55           C  
ATOM   3418  CD1 LEU B 220      50.095  85.776 156.793  1.00 31.44           C  
ATOM   3419  CD2 LEU B 220      49.126  87.272 155.018  1.00 31.58           C  
ATOM   3420  N   THR B 221      50.993  90.978 157.993  1.00 26.21           N  
ATOM   3421  CA  THR B 221      51.895  91.983 158.544  1.00 23.15           C  
ATOM   3422  C   THR B 221      51.923  92.088 160.062  1.00 22.10           C  
ATOM   3423  O   THR B 221      52.966  92.374 160.643  1.00 23.29           O  
ATOM   3424  CB  THR B 221      51.603  93.367 157.939  1.00 22.80           C  
ATOM   3425  OG1 THR B 221      50.268  93.765 158.268  1.00 20.42           O  
ATOM   3426  CG2 THR B 221      51.748  93.310 156.416  1.00 23.61           C  
ATOM   3427  N   GLY B 222      50.786  91.856 160.707  1.00 20.97           N  
ATOM   3428  CA  GLY B 222      50.750  91.933 162.156  1.00 18.52           C  
ATOM   3429  C   GLY B 222      51.670  90.908 162.796  1.00 18.55           C  
ATOM   3430  O   GLY B 222      52.440  91.231 163.700  1.00 19.55           O  
ATOM   3431  N   ALA B 223      51.595  89.668 162.317  1.00 17.80           N  
ATOM   3432  CA  ALA B 223      52.408  88.582 162.844  1.00 16.94           C  
ATOM   3433  C   ALA B 223      53.897  88.821 162.616  1.00 17.83           C  
ATOM   3434  O   ALA B 223      54.725  88.496 163.471  1.00 17.64           O  
ATOM   3435  CB  ALA B 223      51.984  87.269 162.204  1.00 15.56           C  
ATOM   3436  N   ALA B 224      54.243  89.389 161.467  1.00 16.79           N  
ATOM   3437  CA  ALA B 224      55.645  89.654 161.162  1.00 17.73           C  
ATOM   3438  C   ALA B 224      56.199  90.738 162.077  1.00 19.03           C  
ATOM   3439  O   ALA B 224      57.287  90.592 162.631  1.00 20.25           O  
ATOM   3440  CB  ALA B 224      55.804  90.059 159.705  1.00 15.56           C  
ATOM   3441  N   ALA B 225      55.451  91.825 162.241  1.00 20.46           N  
ATOM   3442  CA  ALA B 225      55.892  92.914 163.110  1.00 21.33           C  
ATOM   3443  C   ALA B 225      56.121  92.395 164.532  1.00 22.32           C  
ATOM   3444  O   ALA B 225      57.087  92.781 165.197  1.00 23.34           O  
ATOM   3445  CB  ALA B 225      54.852  94.030 163.121  1.00 18.15           C  
ATOM   3446  N   PHE B 226      55.227  91.513 164.980  1.00 22.40           N  
ATOM   3447  CA  PHE B 226      55.300  90.916 166.310  1.00 21.45           C  
ATOM   3448  C   PHE B 226      56.581  90.102 166.486  1.00 21.19           C  
ATOM   3449  O   PHE B 226      57.346  90.319 167.426  1.00 21.56           O  
ATOM   3450  CB  PHE B 226      54.072  90.021 166.542  1.00 22.29           C  
ATOM   3451  CG  PHE B 226      54.212  89.077 167.709  1.00 23.44           C  
ATOM   3452  CD1 PHE B 226      54.409  89.555 168.993  1.00 24.01           C  
ATOM   3453  CD2 PHE B 226      54.159  87.705 167.516  1.00 24.42           C  
ATOM   3454  CE1 PHE B 226      54.554  88.683 170.064  1.00 23.81           C  
ATOM   3455  CE2 PHE B 226      54.304  86.833 168.582  1.00 24.11           C  
ATOM   3456  CZ  PHE B 226      54.501  87.323 169.856  1.00 22.24           C  
ATOM   3457  N   LEU B 227      56.820  89.165 165.580  1.00 19.65           N  
ATOM   3458  CA  LEU B 227      58.010  88.332 165.670  1.00 20.31           C  
ATOM   3459  C   LEU B 227      59.297  89.151 165.586  1.00 20.90           C  
ATOM   3460  O   LEU B 227      60.295  88.813 166.217  1.00 22.50           O  
ATOM   3461  CB  LEU B 227      57.990  87.264 164.571  1.00 17.17           C  
ATOM   3462  CG  LEU B 227      56.837  86.256 164.658  1.00 17.29           C  
ATOM   3463  CD1 LEU B 227      56.762  85.415 163.390  1.00 12.56           C  
ATOM   3464  CD2 LEU B 227      57.030  85.372 165.879  1.00 15.79           C  
ATOM   3465  N   ALA B 228      59.277  90.235 164.822  1.00 21.93           N  
ATOM   3466  CA  ALA B 228      60.470  91.062 164.676  1.00 22.84           C  
ATOM   3467  C   ALA B 228      60.742  91.974 165.872  1.00 23.72           C  
ATOM   3468  O   ALA B 228      61.767  92.649 165.908  1.00 24.41           O  
ATOM   3469  CB  ALA B 228      60.368  91.903 163.393  1.00 21.49           C  
ATOM   3470  N   SER B 229      59.842  91.979 166.852  1.00 24.33           N  
ATOM   3471  CA  SER B 229      59.985  92.842 168.021  1.00 24.27           C  
ATOM   3472  C   SER B 229      60.407  92.148 169.316  1.00 25.79           C  
ATOM   3473  O   SER B 229      60.576  90.927 169.365  1.00 26.33           O  
ATOM   3474  CB  SER B 229      58.673  93.594 168.270  1.00 25.12           C  
ATOM   3475  OG  SER B 229      57.652  92.705 168.697  1.00 24.11           O  
ATOM   3476  N   ASP B 230      60.559  92.951 170.367  1.00 24.75           N  
ATOM   3477  CA  ASP B 230      60.962  92.473 171.684  1.00 25.90           C  
ATOM   3478  C   ASP B 230      59.893  91.629 172.361  1.00 26.45           C  
ATOM   3479  O   ASP B 230      60.215  90.818 173.231  1.00 28.33           O  
ATOM   3480  CB  ASP B 230      61.312  93.657 172.588  1.00 31.21           C  
ATOM   3481  CG  ASP B 230      62.510  94.446 172.086  1.00 35.78           C  
ATOM   3482  OD1 ASP B 230      62.694  95.598 172.540  1.00 39.67           O  
ATOM   3483  OD2 ASP B 230      63.276  93.916 171.251  1.00 39.21           O  
ATOM   3484  N   ASP B 231      58.626  91.819 171.991  1.00 25.26           N  
ATOM   3485  CA  ASP B 231      57.556  91.025 172.592  1.00 24.33           C  
ATOM   3486  C   ASP B 231      57.712  89.547 172.225  1.00 23.71           C  
ATOM   3487  O   ASP B 231      57.064  88.684 172.818  1.00 23.60           O  
ATOM   3488  CB  ASP B 231      56.172  91.486 172.119  1.00 27.44           C  
ATOM   3489  CG  ASP B 231      55.689  92.744 172.822  1.00 29.29           C  
ATOM   3490  OD1 ASP B 231      56.037  92.962 174.002  1.00 29.79           O  
ATOM   3491  OD2 ASP B 231      54.930  93.508 172.189  1.00 32.28           O  
ATOM   3492  N   ALA B 232      58.566  89.257 171.247  1.00 21.77           N  
ATOM   3493  CA  ALA B 232      58.773  87.883 170.813  1.00 20.19           C  
ATOM   3494  C   ALA B 232      60.220  87.414 170.956  1.00 20.42           C  
ATOM   3495  O   ALA B 232      60.645  86.476 170.282  1.00 19.76           O  
ATOM   3496  CB  ALA B 232      58.316  87.735 169.364  1.00 19.21           C  
ATOM   3497  N   SER B 233      60.983  88.052 171.836  1.00 20.59           N  
ATOM   3498  CA  SER B 233      62.376  87.656 172.005  1.00 22.25           C  
ATOM   3499  C   SER B 233      62.575  86.253 172.605  1.00 22.41           C  
ATOM   3500  O   SER B 233      63.650  85.668 172.458  1.00 22.33           O  
ATOM   3501  CB  SER B 233      63.129  88.702 172.840  1.00 21.67           C  
ATOM   3502  OG  SER B 233      62.528  88.885 174.104  1.00 26.44           O  
ATOM   3503  N   PHE B 234      61.553  85.712 173.272  1.00 21.82           N  
ATOM   3504  CA  PHE B 234      61.657  84.370 173.860  1.00 22.25           C  
ATOM   3505  C   PHE B 234      60.941  83.320 172.996  1.00 20.36           C  
ATOM   3506  O   PHE B 234      60.712  82.190 173.422  1.00 21.23           O  
ATOM   3507  CB  PHE B 234      61.075  84.348 175.282  1.00 22.08           C  
ATOM   3508  CG  PHE B 234      61.588  83.209 176.134  1.00 22.66           C  
ATOM   3509  CD1 PHE B 234      62.947  83.062 176.374  1.00 21.90           C  
ATOM   3510  CD2 PHE B 234      60.712  82.294 176.704  1.00 21.91           C  
ATOM   3511  CE1 PHE B 234      63.422  82.024 177.168  1.00 22.60           C  
ATOM   3512  CE2 PHE B 234      61.178  81.252 177.498  1.00 20.55           C  
ATOM   3513  CZ  PHE B 234      62.532  81.117 177.731  1.00 21.82           C  
ATOM   3514  N   ILE B 235      60.594  83.704 171.777  1.00 18.50           N  
ATOM   3515  CA  ILE B 235      59.925  82.808 170.849  1.00 17.34           C  
ATOM   3516  C   ILE B 235      60.862  82.554 169.674  1.00 17.32           C  
ATOM   3517  O   ILE B 235      61.164  83.469 168.906  1.00 15.79           O  
ATOM   3518  CB  ILE B 235      58.624  83.435 170.287  1.00 16.35           C  
ATOM   3519  CG1 ILE B 235      57.656  83.752 171.421  1.00 13.99           C  
ATOM   3520  CG2 ILE B 235      57.965  82.478 169.297  1.00 14.55           C  
ATOM   3521  CD1 ILE B 235      56.361  84.386 170.933  1.00 14.46           C  
ATOM   3522  N   THR B 236      61.332  81.321 169.535  1.00 18.33           N  
ATOM   3523  CA  THR B 236      62.220  81.000 168.427  1.00 19.49           C  
ATOM   3524  C   THR B 236      62.029  79.553 167.990  1.00 19.82           C  
ATOM   3525  O   THR B 236      61.625  78.702 168.784  1.00 22.78           O  
ATOM   3526  CB  THR B 236      63.700  81.258 168.800  1.00 18.48           C  
ATOM   3527  OG1 THR B 236      64.517  81.114 167.634  1.00 21.35           O  
ATOM   3528  CG2 THR B 236      64.171  80.284 169.864  1.00 18.14           C  
ATOM   3529  N   GLY B 237      62.310  79.283 166.721  1.00 20.09           N  
ATOM   3530  CA  GLY B 237      62.155  77.944 166.187  1.00 17.71           C  
ATOM   3531  C   GLY B 237      60.706  77.602 165.877  1.00 19.14           C  
ATOM   3532  O   GLY B 237      60.404  76.470 165.493  1.00 20.60           O  
ATOM   3533  N   GLN B 238      59.807  78.574 166.011  1.00 17.39           N  
ATOM   3534  CA  GLN B 238      58.382  78.329 165.765  1.00 17.49           C  
ATOM   3535  C   GLN B 238      57.861  78.654 164.370  1.00 17.98           C  
ATOM   3536  O   GLN B 238      58.459  79.428 163.621  1.00 19.61           O  
ATOM   3537  CB  GLN B 238      57.538  79.085 166.792  1.00 14.93           C  
ATOM   3538  CG  GLN B 238      57.926  78.790 168.232  1.00 13.30           C  
ATOM   3539  CD  GLN B 238      58.032  77.308 168.502  1.00 15.85           C  
ATOM   3540  OE1 GLN B 238      57.055  76.564 168.372  1.00 16.68           O  
ATOM   3541  NE2 GLN B 238      59.227  76.863 168.869  1.00 15.99           N  
ATOM   3542  N   THR B 239      56.736  78.032 164.030  1.00 19.48           N  
ATOM   3543  CA  THR B 239      56.074  78.242 162.750  1.00 20.95           C  
ATOM   3544  C   THR B 239      54.662  78.716 163.093  1.00 21.96           C  
ATOM   3545  O   THR B 239      53.889  77.992 163.718  1.00 20.86           O  
ATOM   3546  CB  THR B 239      55.994  76.936 161.907  1.00 21.26           C  
ATOM   3547  OG1 THR B 239      57.312  76.463 161.611  1.00 21.18           O  
ATOM   3548  CG2 THR B 239      55.277  77.190 160.592  1.00 21.77           C  
ATOM   3549  N   LEU B 240      54.349  79.946 162.699  1.00 23.42           N  
ATOM   3550  CA  LEU B 240      53.048  80.535 162.975  1.00 23.47           C  
ATOM   3551  C   LEU B 240      52.159  80.541 161.742  1.00 23.63           C  
ATOM   3552  O   LEU B 240      52.445  81.233 160.762  1.00 24.43           O  
ATOM   3553  CB  LEU B 240      53.218  81.972 163.483  1.00 23.71           C  
ATOM   3554  CG  LEU B 240      51.923  82.748 163.788  1.00 25.86           C  
ATOM   3555  CD1 LEU B 240      51.119  82.016 164.865  1.00 21.62           C  
ATOM   3556  CD2 LEU B 240      52.259  84.168 164.248  1.00 24.21           C  
ATOM   3557  N   ALA B 241      51.081  79.767 161.794  1.00 21.79           N  
ATOM   3558  CA  ALA B 241      50.151  79.711 160.679  1.00 21.79           C  
ATOM   3559  C   ALA B 241      49.113  80.831 160.803  1.00 23.07           C  
ATOM   3560  O   ALA B 241      48.372  80.902 161.788  1.00 20.31           O  
ATOM   3561  CB  ALA B 241      49.451  78.353 160.642  1.00 20.91           C  
ATOM   3562  N   VAL B 242      49.084  81.709 159.803  1.00 21.47           N  
ATOM   3563  CA  VAL B 242      48.136  82.818 159.745  1.00 19.72           C  
ATOM   3564  C   VAL B 242      47.300  82.472 158.521  1.00 21.31           C  
ATOM   3565  O   VAL B 242      47.612  82.891 157.403  1.00 19.69           O  
ATOM   3566  CB  VAL B 242      48.865  84.160 159.513  1.00 19.31           C  
ATOM   3567  CG1 VAL B 242      47.903  85.322 159.680  1.00 17.20           C  
ATOM   3568  CG2 VAL B 242      50.015  84.284 160.469  1.00 18.00           C  
ATOM   3569  N   ASP B 243      46.241  81.695 158.727  1.00 21.82           N  
ATOM   3570  CA  ASP B 243      45.425  81.252 157.608  1.00 19.99           C  
ATOM   3571  C   ASP B 243      43.924  81.214 157.867  1.00 21.26           C  
ATOM   3572  O   ASP B 243      43.192  80.504 157.178  1.00 18.07           O  
ATOM   3573  CB  ASP B 243      45.906  79.870 157.178  1.00 21.57           C  
ATOM   3574  CG  ASP B 243      45.622  78.800 158.221  1.00 21.67           C  
ATOM   3575  OD1 ASP B 243      45.396  79.150 159.400  1.00 18.57           O  
ATOM   3576  OD2 ASP B 243      45.631  77.604 157.856  1.00 23.50           O  
ATOM   3577  N   GLY B 244      43.469  81.977 158.856  1.00 22.11           N  
ATOM   3578  CA  GLY B 244      42.052  82.013 159.160  1.00 24.07           C  
ATOM   3579  C   GLY B 244      41.522  80.752 159.820  1.00 25.28           C  
ATOM   3580  O   GLY B 244      40.328  80.454 159.731  1.00 22.93           O  
ATOM   3581  N   GLY B 245      42.416  80.000 160.457  1.00 24.05           N  
ATOM   3582  CA  GLY B 245      42.010  78.792 161.150  1.00 23.63           C  
ATOM   3583  C   GLY B 245      41.793  77.545 160.313  1.00 25.52           C  
ATOM   3584  O   GLY B 245      40.963  76.701 160.667  1.00 24.16           O  
ATOM   3585  N   MET B 246      42.522  77.408 159.209  1.00 24.19           N  
ATOM   3586  CA  MET B 246      42.362  76.215 158.390  1.00 25.22           C  
ATOM   3587  C   MET B 246      43.138  75.057 159.008  1.00 24.20           C  
ATOM   3588  O   MET B 246      42.546  74.061 159.420  1.00 25.61           O  
ATOM   3589  CB  MET B 246      42.833  76.458 156.950  1.00 25.82           C  
ATOM   3590  CG  MET B 246      42.684  75.234 156.051  1.00 28.83           C  
ATOM   3591  SD  MET B 246      42.914  75.562 154.289  1.00 28.97           S  
ATOM   3592  CE  MET B 246      44.542  76.339 154.332  1.00 33.02           C  
ATOM   3593  N   VAL B 247      44.457  75.189 159.087  1.00 23.80           N  
ATOM   3594  CA  VAL B 247      45.279  74.132 159.663  1.00 23.28           C  
ATOM   3595  C   VAL B 247      45.444  74.275 161.177  1.00 23.81           C  
ATOM   3596  O   VAL B 247      45.362  75.375 161.730  1.00 23.27           O  
ATOM   3597  CB  VAL B 247      46.696  74.089 159.033  1.00 23.01           C  
ATOM   3598  CG1 VAL B 247      46.602  74.103 157.520  1.00 21.00           C  
ATOM   3599  CG2 VAL B 247      47.523  75.244 159.530  1.00 25.18           C  
ATOM   3600  N   ARG B 248      45.661  73.142 161.838  1.00 23.86           N  
ATOM   3601  CA  ARG B 248      45.875  73.100 163.280  1.00 23.89           C  
ATOM   3602  C   ARG B 248      47.065  72.170 163.512  1.00 25.29           C  
ATOM   3603  O   ARG B 248      47.013  70.993 163.165  1.00 26.05           O  
ATOM   3604  CB  ARG B 248      44.629  72.568 164.005  1.00 23.44           C  
ATOM   3605  CG  ARG B 248      43.376  73.461 163.890  1.00 23.41           C  
ATOM   3606  CD  ARG B 248      42.620  73.282 162.559  1.00 22.86           C  
ATOM   3607  NE  ARG B 248      41.616  74.328 162.348  1.00 22.31           N  
ATOM   3608  CZ  ARG B 248      40.533  74.510 163.105  1.00 20.19           C  
ATOM   3609  NH1 ARG B 248      40.281  73.714 164.136  1.00 18.03           N  
ATOM   3610  NH2 ARG B 248      39.708  75.513 162.846  1.00 18.33           N  
ATOM   3611  N   HIS B 249      48.144  72.708 164.077  1.00 26.08           N  
ATOM   3612  CA  HIS B 249      49.353  71.928 164.344  1.00 25.12           C  
ATOM   3613  C   HIS B 249      49.934  72.306 165.695  1.00 26.77           C  
ATOM   3614  O   HIS B 249      49.410  73.259 166.315  1.00 25.66           O  
ATOM   3615  CB  HIS B 249      50.406  72.203 163.269  1.00 25.46           C  
ATOM   3616  CG  HIS B 249      50.935  73.602 163.298  1.00 25.04           C  
ATOM   3617  ND1 HIS B 249      52.212  73.906 163.716  1.00 26.82           N  
ATOM   3618  CD2 HIS B 249      50.340  74.785 163.016  1.00 25.24           C  
ATOM   3619  CE1 HIS B 249      52.382  75.217 163.694  1.00 25.35           C  
ATOM   3620  NE2 HIS B 249      51.259  75.774 163.273  1.00 26.01           N  
ATOM   3621  OXT HIS B 249      50.924  71.656 166.103  1.00 27.34           O  
TER    3622      HIS B 249                                                      
END
MOLECULE T0433.pdb
ATOM     20  N   MET     1      66.006 100.902 164.016  1.00 30.54           N  
ATOM     21  CA  MET     1      66.034  99.529 163.534  1.00 31.40           C  
ATOM     22  C   MET     1      66.182  99.479 162.021  1.00 29.91           C  
ATOM     23  O   MET     1      65.465 100.179 161.296  1.00 29.44           O  
ATOM     24  CB  MET     1      64.765  98.773 163.923  1.00 31.12           C  
ATOM     25  CG  MET     1      64.859  97.281 163.566  1.00 33.22           C  
ATOM     26  SD  MET     1      63.341  96.179 164.096  0.60 38.15          SE  
ATOM     27  CE  MET     1      63.492  96.512 165.999  1.00 34.50           C  
ATOM     28  N   LYS     2      67.106  98.634 161.558  1.00 29.48           N  
ATOM     29  CA  LYS     2      67.339  98.409 160.121  1.00 28.09           C  
ATOM     30  C   LYS     2      66.846  97.026 159.675  1.00 27.23           C  
ATOM     31  O   LYS     2      67.326  96.009 160.189  1.00 27.45           O  
ATOM     32  CB  LYS     2      68.816  98.523 159.822  1.00 27.77           C  
ATOM     33  CG  LYS     2      69.356  99.917 159.951  1.00 28.85           C  
ATOM     34  CD  LYS     2      70.835  99.967 159.595  1.00 29.12           C  
ATOM     35  CE  LYS     2      71.363 101.430 159.579  1.00 27.44           C  
ATOM     36  NZ  LYS     2      70.977 102.131 158.307  1.00 28.69           N  
ATOM     37  N   ILE     3      65.910  96.999 158.723  1.00 25.89           N  
ATOM     38  CA  ILE     3      65.296  95.750 158.256  1.00 25.76           C  
ATOM     39  C   ILE     3      65.605  95.566 156.788  1.00 25.88           C  
ATOM     40  O   ILE     3      65.255  96.405 156.002  1.00 27.10           O  
ATOM     41  CB  ILE     3      63.753  95.745 158.441  1.00 25.79           C  
ATOM     42  CG1 ILE     3      63.394  95.872 159.921  1.00 25.30           C  
ATOM     43  CG2 ILE     3      63.126  94.472 157.901  1.00 24.82           C  
ATOM     44  CD1 ILE     3      61.903  95.840 160.165  1.00 25.00           C  
ATOM     45  N   LEU     4      66.306  94.498 156.431  1.00 25.66           N  
ATOM     46  CA  LEU     4      66.484  94.169 155.036  1.00 26.82           C  
ATOM     47  C   LEU     4      65.292  93.313 154.574  1.00 26.72           C  
ATOM     48  O   LEU     4      65.126  92.175 155.019  1.00 27.97           O  
ATOM     49  CB  LEU     4      67.817  93.439 154.807  1.00 26.60           C  
ATOM     50  CG  LEU     4      68.076  92.994 153.362  1.00 25.81           C  
ATOM     51  CD1 LEU     4      68.199  94.183 152.401  1.00 23.22           C  
ATOM     52  CD2 LEU     4      69.319  92.113 153.294  1.00 27.38           C  
ATOM     53  N   LEU     5      64.458  93.886 153.709  1.00 27.66           N  
ATOM     54  CA  LEU     5      63.302  93.194 153.117  1.00 27.99           C  
ATOM     55  C   LEU     5      63.556  92.704 151.672  1.00 28.42           C  
ATOM     56  O   LEU     5      63.510  93.478 150.710  1.00 28.87           O  
ATOM     57  CB  LEU     5      62.084  94.121 153.146  1.00 28.06           C  
ATOM     58  CG  LEU     5      60.723  93.525 152.740  1.00 27.67           C  
ATOM     59  CD1 LEU     5      60.434  92.306 153.565  1.00 25.96           C  
ATOM     60  CD2 LEU     5      59.625  94.532 152.942  1.00 27.45           C  
ATOM     61  N   ILE     6      63.793  91.412 151.521  1.00 29.13           N  
ATOM     62  CA  ILE     6      64.044  90.827 150.202  1.00 29.17           C  
ATOM     63  C   ILE     6      62.724  90.345 149.605  1.00 29.51           C  
ATOM     64  O   ILE     6      62.002  89.601 150.241  1.00 29.55           O  
ATOM     65  CB  ILE     6      65.099  89.709 150.282  1.00 29.51           C  
ATOM     66  CG1 ILE     6      66.315  90.194 151.102  1.00 29.55           C  
ATOM     67  CG2 ILE     6      65.525  89.244 148.891  1.00 29.32           C  
ATOM     68  CD1 ILE     6      66.874  89.125 151.998  1.00 29.14           C  
ATOM     69  N   GLY     7      62.399  90.856 148.415  1.00 30.23           N  
ATOM     70  CA  GLY     7      61.140  90.591 147.744  1.00 31.22           C  
ATOM     71  C   GLY     7      60.100  91.656 148.035  1.00 32.04           C  
ATOM     72  O   GLY     7      58.896  91.406 147.908  1.00 32.57           O  
ATOM     73  N   ALA     8      60.569  92.846 148.411  1.00 32.09           N  
ATOM     74  CA  ALA     8      59.720  93.956 148.854  1.00 31.87           C  
ATOM     75  C   ALA     8      58.684  94.452 147.836  1.00 32.25           C  
ATOM     76  O   ALA     8      57.696  95.101 148.208  1.00 31.65           O  
ATOM     77  CB  ALA     8      60.595  95.095 149.276  1.00 31.67           C  
ATOM     78  N   SER     9      58.926  94.173 146.558  1.00 32.33           N  
ATOM     79  CA  SER     9      58.029  94.616 145.519  1.00 33.35           C  
ATOM     80  C   SER     9      57.001  93.558 145.126  1.00 33.22           C  
ATOM     81  O   SER     9      56.157  93.825 144.301  1.00 33.62           O  
ATOM     82  CB  SER     9      58.813  95.157 144.311  1.00 34.03           C  
ATOM     83  OG  SER     9      59.392  94.098 143.571  1.00 36.88           O  
ATOM     84  N   GLY    10      57.043  92.378 145.748  1.00 33.16           N  
ATOM     85  CA  GLY    10      56.023  91.363 145.524  1.00 33.46           C  
ATOM     86  C   GLY    10      54.745  91.676 146.287  1.00 33.31           C  
ATOM     87  O   GLY    10      54.741  92.545 147.160  1.00 32.91           O  
ATOM     88  N   THR    11      53.663  90.967 145.961  1.00 33.48           N  
ATOM     89  CA  THR    11      52.366  91.118 146.662  1.00 33.27           C  
ATOM     90  C   THR    11      52.492  91.023 148.180  1.00 32.36           C  
ATOM     91  O   THR    11      51.963  91.860 148.902  1.00 32.98           O  
ATOM     92  CB  THR    11      51.328  90.066 146.159  1.00 34.07           C  
ATOM     93  OG1 THR    11      51.277  90.113 144.734  1.00 34.95           O  
ATOM     94  CG2 THR    11      49.928  90.350 146.725  1.00 34.27           C  
ATOM     95  N   LEU    12      53.212  90.008 148.654  1.00 31.60           N  
ATOM     96  CA  LEU    12      53.394  89.769 150.076  1.00 30.72           C  
ATOM     97  C   LEU    12      54.449  90.702 150.655  1.00 30.82           C  
ATOM     98  O   LEU    12      54.247  91.293 151.726  1.00 30.91           O  
ATOM     99  CB  LEU    12      53.771  88.298 150.347  1.00 31.02           C  
ATOM    100  CG  LEU    12      54.141  87.988 151.805  1.00 30.39           C  
ATOM    101  CD1 LEU    12      52.931  88.264 152.698  1.00 29.48           C  
ATOM    102  CD2 LEU    12      54.697  86.563 152.015  1.00 30.19           C  
ATOM    103  N   GLY    13      55.572  90.834 149.952  1.00 30.22           N  
ATOM    104  CA  GLY    13      56.627  91.740 150.392  1.00 30.16           C  
ATOM    105  C   GLY    13      56.081  93.139 150.577  1.00 29.55           C  
ATOM    106  O   GLY    13      56.441  93.836 151.523  1.00 29.43           O  
ATOM    107  N   SER    14      55.166  93.524 149.695  1.00 29.09           N  
ATOM    108  CA  SER    14      54.622  94.875 149.693  1.00 29.34           C  
ATOM    109  C   SER    14      53.779  95.149 150.937  1.00 28.73           C  
ATOM    110  O   SER    14      53.922  96.194 151.573  1.00 29.08           O  
ATOM    111  CB  SER    14      53.818  95.119 148.400  1.00 30.09           C  
ATOM    112  OG  SER    14      53.418  96.478 148.322  1.00 33.26           O  
ATOM    113  N   ALA    15      52.906  94.203 151.285  1.00 28.08           N  
ATOM    114  CA  ALA    15      52.120  94.297 152.515  1.00 26.86           C  
ATOM    115  C   ALA    15      53.006  94.274 153.751  1.00 26.45           C  
ATOM    116  O   ALA    15      52.717  94.945 154.719  1.00 26.48           O  
ATOM    117  CB  ALA    15      51.114  93.188 152.580  1.00 26.72           C  
ATOM    118  N   VAL    16      54.069  93.478 153.727  1.00 26.38           N  
ATOM    119  CA  VAL    16      55.050  93.487 154.816  1.00 26.86           C  
ATOM    120  C   VAL    16      55.751  94.850 154.960  1.00 27.51           C  
ATOM    121  O   VAL    16      55.927  95.342 156.073  1.00 28.52           O  
ATOM    122  CB  VAL    16      56.087  92.335 154.646  1.00 26.98           C  
ATOM    123  CG1 VAL    16      57.167  92.382 155.752  1.00 24.98           C  
ATOM    124  CG2 VAL    16      55.353  90.983 154.654  1.00 25.96           C  
ATOM    125  N   LYS    17      56.156  95.452 153.845  1.00 27.51           N  
ATOM    126  CA  LYS    17      56.826  96.750 153.881  1.00 28.86           C  
ATOM    127  C   LYS    17      55.901  97.808 154.506  1.00 28.85           C  
ATOM    128  O   LYS    17      56.310  98.571 155.375  1.00 28.00           O  
ATOM    129  CB  LYS    17      57.250  97.176 152.473  1.00 28.12           C  
ATOM    130  CG  LYS    17      58.136  98.424 152.420  1.00 28.98           C  
ATOM    131  CD  LYS    17      58.199  99.019 151.016  1.00 30.35           C  
ATOM    132  CE  LYS    17      59.040 100.287 151.006  1.00 36.34           C  
ATOM    133  NZ  LYS    17      58.269 101.477 150.476  1.00 39.61           N  
ATOM    134  N   GLU    18      54.647  97.814 154.079  1.00 29.40           N  
ATOM    135  CA  GLU    18      53.669  98.723 154.635  1.00 31.13           C  
ATOM    136  C   GLU    18      53.607  98.684 156.180  1.00 30.02           C  
ATOM    137  O   GLU    18      53.508  99.723 156.820  1.00 30.06           O  
ATOM    138  CB  GLU    18      52.296  98.450 154.025  1.00 31.24           C  
ATOM    139  CG  GLU    18      51.297  99.584 154.201  1.00 33.76           C  
ATOM    140  CD  GLU    18      50.037  99.390 153.365  1.00 36.05           C  
ATOM    141  OE1 GLU    18      50.053  98.555 152.420  1.00 42.91           O  
ATOM    142  OE2 GLU    18      49.021 100.082 153.641  1.00 43.15           O  
ATOM    143  N   ARG    19      53.685  97.509 156.785  1.00 29.53           N  
ATOM    144  CA  ARG    19      53.645  97.464 158.252  1.00 29.61           C  
ATOM    145  C   ARG    19      54.988  97.830 158.865  1.00 29.47           C  
ATOM    146  O   ARG    19      55.037  98.579 159.803  1.00 28.55           O  
ATOM    147  CB  ARG    19      53.228  96.100 158.771  1.00 28.97           C  
ATOM    148  CG  ARG    19      51.860  95.659 158.312  1.00 29.53           C  
ATOM    149  CD  ARG    19      51.364  94.561 159.240  1.00 31.28           C  
ATOM    150  NE  ARG    19      51.271  95.028 160.621  1.00 31.95           N  
ATOM    151  CZ  ARG    19      50.165  95.513 161.180  1.00 32.20           C  
ATOM    152  NH1 ARG    19      49.029  95.619 160.487  1.00 30.24           N  
ATOM    153  NH2 ARG    19      50.205  95.917 162.436  1.00 31.68           N  
ATOM    154  N   LEU    20      56.069  97.282 158.326  1.00 30.11           N  
ATOM    155  CA  LEU    20      57.398  97.467 158.932  1.00 30.83           C  
ATOM    156  C   LEU    20      57.906  98.916 158.888  1.00 30.81           C  
ATOM    157  O   LEU    20      58.534  99.418 159.824  1.00 30.95           O  
ATOM    158  CB  LEU    20      58.395  96.490 158.301  1.00 30.17           C  
ATOM    159  CG  LEU    20      58.128  95.001 158.562  1.00 32.14           C  
ATOM    160  CD1 LEU    20      59.241  94.109 157.934  1.00 32.94           C  
ATOM    161  CD2 LEU    20      57.908  94.629 160.038  1.00 30.05           C  
ATOM    162  N   GLU    21      57.599  99.558 157.771  1.00 31.32           N  
ATOM    163  CA  GLU    21      57.940 100.918 157.400  1.00 31.24           C  
ATOM    164  C   GLU    21      57.522 101.953 158.455  1.00 31.01           C  
ATOM    165  O   GLU    21      58.148 103.001 158.582  1.00 31.01           O  
ATOM    166  CB  GLU    21      57.152 101.149 156.123  1.00 31.39           C  
ATOM    167  CG  GLU    21      57.388 102.338 155.355  1.00 35.19           C  
ATOM    168  CD  GLU    21      56.609 102.275 154.070  1.00 38.08           C  
ATOM    169  OE1 GLU    21      57.232 102.044 153.021  1.00 40.66           O  
ATOM    170  OE2 GLU    21      55.372 102.421 154.110  1.00 40.60           O  
ATOM    171  N   LYS    22      56.455 101.658 159.197  1.00 31.04           N  
ATOM    172  CA  LYS    22      55.924 102.564 160.221  1.00 30.94           C  
ATOM    173  C   LYS    22      56.811 102.630 161.465  1.00 30.52           C  
ATOM    174  O   LYS    22      56.681 103.547 162.270  1.00 30.90           O  
ATOM    175  CB  LYS    22      54.511 102.139 160.628  1.00 31.54           C  
ATOM    176  CG  LYS    22      53.556 101.944 159.460  1.00 32.93           C  
ATOM    177  CD  LYS    22      52.289 101.284 159.920  1.00 36.32           C  
ATOM    178  CE  LYS    22      51.331 101.128 158.754  1.00 40.34           C  
ATOM    179  NZ  LYS    22      51.088 102.441 158.083  1.00 39.09           N  
ATOM    180  N   LYS    23      57.728 101.684 161.619  1.00 29.61           N  
ATOM    181  CA  LYS    23      58.566 101.657 162.835  1.00 29.72           C  
ATOM    182  C   LYS    23      60.012 101.231 162.686  1.00 28.69           C  
ATOM    183  O   LYS    23      60.709 101.091 163.674  1.00 29.01           O  
ATOM    184  CB  LYS    23      57.921 100.821 163.935  1.00 29.86           C  
ATOM    185  CG  LYS    23      56.832  99.941 163.461  1.00 32.38           C  
ATOM    186  CD  LYS    23      55.808  99.771 164.568  1.00 37.27           C  
ATOM    187  CE  LYS    23      55.798  98.363 165.087  1.00 36.51           C  
ATOM    188  NZ  LYS    23      54.492  98.134 165.729  1.00 38.60           N  
ATOM    189  N   ALA    24      60.461 101.009 161.461  1.00 28.04           N  
ATOM    190  CA  ALA    24      61.866 100.760 161.229  1.00 27.63           C  
ATOM    191  C   ALA    24      62.245 101.307 159.865  1.00 27.25           C  
ATOM    192  O   ALA    24      61.366 101.642 159.060  1.00 26.73           O  
ATOM    193  CB  ALA    24      62.169  99.289 161.329  1.00 27.37           C  
ATOM    194  N   GLU    25      63.551 101.433 159.638  1.00 27.27           N  
ATOM    195  CA  GLU    25      64.081 101.772 158.330  1.00 27.27           C  
ATOM    196  C   GLU    25      64.102 100.507 157.472  1.00 26.92           C  
ATOM    197  O   GLU    25      64.846  99.565 157.768  1.00 26.87           O  
ATOM    198  CB  GLU    25      65.496 102.383 158.422  1.00 26.99           C  
ATOM    199  CG  GLU    25      66.170 102.460 157.029  1.00 26.98           C  
ATOM    200  CD  GLU    25      67.656 102.799 157.053  1.00 28.27           C  
ATOM    201  OE1 GLU    25      68.276 102.751 158.132  1.00 28.17           O  
ATOM    202  OE2 GLU    25      68.201 103.151 155.975  1.00 28.59           O  
ATOM    203  N   VAL    26      63.305 100.491 156.401  1.00 26.81           N  
ATOM    204  CA  VAL    26      63.250  99.314 155.551  1.00 26.96           C  
ATOM    205  C   VAL    26      64.162  99.482 154.333  1.00 27.22           C  
ATOM    206  O   VAL    26      63.985 100.391 153.533  1.00 27.46           O  
ATOM    207  CB  VAL    26      61.793  98.920 155.140  1.00 26.65           C  
ATOM    208  CG1 VAL    26      61.803  97.693 154.228  1.00 25.56           C  
ATOM    209  CG2 VAL    26      60.922  98.621 156.364  1.00 27.09           C  
ATOM    210  N   ILE    27      65.152  98.605 154.217  1.00 27.33           N  
ATOM    211  CA  ILE    27      66.029  98.558 153.039  1.00 27.69           C  
ATOM    212  C   ILE    27      65.476  97.465 152.133  1.00 27.86           C  
ATOM    213  O   ILE    27      65.402  96.301 152.508  1.00 27.58           O  
ATOM    214  CB  ILE    27      67.489  98.245 153.447  1.00 26.97           C  
ATOM    215  CG1 ILE    27      67.937  99.270 154.470  1.00 28.56           C  
ATOM    216  CG2 ILE    27      68.435  98.229 152.224  1.00 27.55           C  
ATOM    217  CD1 ILE    27      68.847  98.698 155.600  1.00 29.58           C  
ATOM    218  N   THR    28      65.029  97.863 150.954  1.00 28.51           N  
ATOM    219  CA  THR    28      64.392  96.927 150.047  1.00 28.43           C  
ATOM    220  C   THR    28      65.405  96.255 149.115  1.00 28.83           C  
ATOM    221  O   THR    28      66.370  96.876 148.662  1.00 28.93           O  
ATOM    222  CB  THR    28      63.295  97.615 149.229  1.00 28.34           C  
ATOM    223  OG1 THR    28      63.894  98.645 148.433  1.00 28.18           O  
ATOM    224  CG2 THR    28      62.241  98.245 150.179  1.00 28.07           C  
ATOM    225  N   ALA    29      65.157  94.979 148.841  1.00 29.69           N  
ATOM    226  CA  ALA    29      65.945  94.185 147.916  1.00 30.05           C  
ATOM    227  C   ALA    29      64.978  93.373 147.062  1.00 30.59           C  
ATOM    228  O   ALA    29      63.919  92.962 147.533  1.00 30.68           O  
ATOM    229  CB  ALA    29      66.860  93.273 148.665  1.00 29.79           C  
ATOM    230  N   GLY    30      65.329  93.178 145.799  1.00 30.69           N  
ATOM    231  CA  GLY    30      64.541  92.346 144.898  1.00 31.31           C  
ATOM    232  C   GLY    30      65.432  91.992 143.732  1.00 31.66           C  
ATOM    233  O   GLY    30      66.581  92.450 143.660  1.00 30.63           O  
ATOM    234  N   ARG    31      64.918  91.189 142.811  1.00 33.00           N  
ATOM    235  CA  ARG    31      65.729  90.819 141.665  1.00 33.89           C  
ATOM    236  C   ARG    31      65.957  91.991 140.738  1.00 34.88           C  
ATOM    237  O   ARG    31      67.078  92.171 140.268  1.00 34.83           O  
ATOM    238  CB  ARG    31      65.204  89.598 140.898  1.00 34.45           C  
ATOM    239  CG  ARG    31      66.369  88.613 140.619  1.00 34.99           C  
ATOM    240  CD  ARG    31      66.404  88.239 139.212  1.00 33.69           C  
ATOM    241  NE  ARG    31      67.719  87.953 138.626  1.00 32.87           N  
ATOM    242  CZ  ARG    31      68.771  88.779 138.582  1.00 33.03           C  
ATOM    243  NH1 ARG    31      69.856  88.388 137.936  1.00 33.24           N  
ATOM    244  NH2 ARG    31      68.784  89.960 139.209  1.00 30.66           N  
ATOM    245  N   HIS    32      64.925  92.805 140.516  1.00 35.93           N  
ATOM    246  CA  HIS    32      65.015  93.907 139.530  1.00 37.44           C  
ATOM    247  C   HIS    32      64.922  95.323 140.066  1.00 38.17           C  
ATOM    248  O   HIS    32      65.514  96.238 139.478  1.00 39.14           O  
ATOM    249  CB  HIS    32      63.972  93.724 138.434  1.00 37.91           C  
ATOM    250  CG  HIS    32      64.083  92.411 137.742  1.00 38.14           C  
ATOM    251  ND1 HIS    32      65.207  92.046 137.032  1.00 38.54           N  
ATOM    252  CD2 HIS    32      63.239  91.354 137.694  1.00 38.48           C  
ATOM    253  CE1 HIS    32      65.036  90.824 136.555  1.00 39.45           C  
ATOM    254  NE2 HIS    32      63.844  90.391 136.927  1.00 37.38           N  
ATOM    255  N   SER    33      64.176  95.491 141.157  1.00 38.58           N  
ATOM    256  CA  SER    33      63.980  96.777 141.831  1.00 39.46           C  
ATOM    257  C   SER    33      64.320  96.670 143.307  1.00 38.87           C  
ATOM    258  O   SER    33      64.323  95.584 143.871  1.00 38.68           O  
ATOM    259  CB  SER    33      62.518  97.216 141.729  1.00 39.72           C  
ATOM    260  OG  SER    33      62.332  98.018 140.580  1.00 42.93           O  
ATOM    261  N   GLY    34      64.579  97.814 143.926  1.00 38.45           N  
ATOM    262  CA  GLY    34      64.831  97.882 145.360  1.00 38.14           C  
ATOM    263  C   GLY    34      66.042  98.756 145.591  1.00 37.85           C  
ATOM    264  O   GLY    34      66.692  99.180 144.632  1.00 37.39           O  
ATOM    265  N   ASP    35      66.326  99.040 146.858  1.00 37.48           N  
ATOM    266  CA  ASP    35      67.518  99.773 147.235  1.00 37.26           C  
ATOM    267  C   ASP    35      68.748  98.949 146.807  1.00 37.19           C  
ATOM    268  O   ASP    35      69.730  99.506 146.326  1.00 37.10           O  
ATOM    269  CB  ASP    35      67.542 100.052 148.750  1.00 37.63           C  
ATOM    270  CG  ASP    35      66.417 100.997 149.216  1.00 38.42           C  
ATOM    271  OD1 ASP    35      66.225 102.081 148.612  1.00 40.32           O  
ATOM    272  OD2 ASP    35      65.729 100.673 150.217  1.00 39.20           O  
ATOM    273  N   VAL    36      68.683  97.624 146.980  1.00 36.53           N  
ATOM    274  CA  VAL    36      69.713  96.702 146.448  1.00 35.63           C  
ATOM    275  C   VAL    36      69.098  95.563 145.633  1.00 34.64           C  
ATOM    276  O   VAL    36      67.989  95.111 145.904  1.00 34.27           O  
ATOM    277  CB  VAL    36      70.649  96.101 147.556  1.00 35.05           C  
ATOM    278  CG1 VAL    36      71.406  97.188 148.271  1.00 36.74           C  
ATOM    279  CG2 VAL    36      69.870  95.272 148.559  1.00 35.22           C  
ATOM    280  N   THR    37      69.823  95.092 144.631  1.00 34.22           N  
ATOM    281  CA  THR    37      69.319  93.988 143.828  1.00 33.79           C  
ATOM    282  C   THR    37      70.066  92.688 144.146  1.00 32.97           C  
ATOM    283  O   THR    37      71.248  92.697 144.509  1.00 32.63           O  
ATOM    284  CB  THR    37      69.267  94.309 142.320  1.00 33.76           C  
ATOM    285  OG1 THR    37      70.584  94.587 141.828  1.00 35.76           O  
ATOM    286  CG2 THR    37      68.369  95.514 142.077  1.00 34.81           C  
ATOM    287  N   VAL    38      69.341  91.578 144.062  1.00 32.25           N  
ATOM    288  CA  VAL    38      69.899  90.289 144.443  1.00 31.31           C  
ATOM    289  C   VAL    38      69.334  89.132 143.634  1.00 31.41           C  
ATOM    290  O   VAL    38      68.132  89.093 143.354  1.00 31.72           O  
ATOM    291  CB  VAL    38      69.757  90.018 145.965  1.00 30.70           C  
ATOM    292  CG1 VAL    38      68.293  89.876 146.395  1.00 28.51           C  
ATOM    293  CG2 VAL    38      70.534  88.791 146.321  1.00 31.36           C  
ATOM    294  N   ASP    39      70.221  88.211 143.249  1.00 30.53           N  
ATOM    295  CA  ASP    39      69.826  86.923 142.681  1.00 30.50           C  
ATOM    296  C   ASP    39      70.025  85.799 143.726  1.00 29.76           C  
ATOM    297  O   ASP    39      71.139  85.248 143.868  1.00 29.33           O  
ATOM    298  CB  ASP    39      70.633  86.625 141.395  1.00 30.79           C  
ATOM    299  CG  ASP    39      70.195  85.334 140.716  1.00 32.20           C  
ATOM    300  OD1 ASP    39      69.159  84.760 141.128  1.00 33.16           O  
ATOM    301  OD2 ASP    39      70.886  84.901 139.753  1.00 36.58           O  
ATOM    302  N   ILE    40      68.955  85.473 144.460  1.00 29.38           N  
ATOM    303  CA  ILE    40      69.036  84.476 145.548  1.00 28.94           C  
ATOM    304  C   ILE    40      69.465  83.069 145.123  1.00 28.58           C  
ATOM    305  O   ILE    40      69.821  82.266 145.989  1.00 28.65           O  
ATOM    306  CB  ILE    40      67.759  84.392 146.405  1.00 28.74           C  
ATOM    307  CG1 ILE    40      66.595  83.795 145.595  1.00 30.50           C  
ATOM    308  CG2 ILE    40      67.430  85.767 147.045  1.00 28.60           C  
ATOM    309  CD1 ILE    40      65.492  83.172 146.464  1.00 29.39           C  
ATOM    310  N   THR    41      69.441  82.774 143.813  1.00 27.92           N  
ATOM    311  CA  THR    41      69.923  81.477 143.305  1.00 26.91           C  
ATOM    312  C   THR    41      71.449  81.479 143.140  1.00 27.43           C  
ATOM    313  O   THR    41      72.046  80.455 142.797  1.00 26.35           O  
ATOM    314  CB  THR    41      69.296  81.096 141.933  1.00 27.63           C  
ATOM    315  OG1 THR    41      69.809  81.944 140.883  1.00 26.03           O  
ATOM    316  CG2 THR    41      67.723  81.111 141.968  1.00 28.15           C  
ATOM    317  N   ASN    42      72.064  82.650 143.350  1.00 27.04           N  
ATOM    318  CA  ASN    42      73.477  82.841 143.110  1.00 27.38           C  
ATOM    319  C   ASN    42      74.171  83.352 144.377  1.00 27.71           C  
ATOM    320  O   ASN    42      73.952  84.491 144.798  1.00 27.18           O  
ATOM    321  CB  ASN    42      73.656  83.833 141.975  1.00 27.56           C  
ATOM    322  CG  ASN    42      75.078  83.923 141.505  1.00 28.64           C  
ATOM    323  OD1 ASN    42      75.955  84.414 142.227  1.00 30.86           O  
ATOM    324  ND2 ASN    42      75.317  83.498 140.266  1.00 27.24           N  
ATOM    325  N   ILE    43      74.979  82.510 145.012  1.00 27.57           N  
ATOM    326  CA  ILE    43      75.523  82.916 146.309  1.00 28.51           C  
ATOM    327  C   ILE    43      76.486  84.094 146.218  1.00 28.08           C  
ATOM    328  O   ILE    43      76.567  84.874 147.167  1.00 27.91           O  
ATOM    329  CB  ILE    43      76.103  81.730 147.170  1.00 28.59           C  
ATOM    330  CG1 ILE    43      77.521  81.310 146.740  1.00 30.31           C  
ATOM    331  CG2 ILE    43      75.080  80.578 147.279  1.00 30.61           C  
ATOM    332  CD1 ILE    43      77.572  80.470 145.499  1.00 31.38           C  
ATOM    333  N   ASP    44      77.191  84.263 145.093  1.00 27.91           N  
ATOM    334  CA  ASP    44      78.040  85.466 144.991  1.00 29.17           C  
ATOM    335  C   ASP    44      77.154  86.727 144.899  1.00 27.92           C  
ATOM    336  O   ASP    44      77.510  87.768 145.420  1.00 26.84           O  
ATOM    337  CB  ASP    44      79.098  85.401 143.875  1.00 30.14           C  
ATOM    338  CG  ASP    44      80.095  86.589 143.934  1.00 35.50           C  
ATOM    339  OD1 ASP    44      80.582  86.952 145.053  1.00 40.68           O  
ATOM    340  OD2 ASP    44      80.397  87.167 142.855  1.00 41.54           O  
ATOM    341  N   SER    45      75.963  86.599 144.320  1.00 27.03           N  
ATOM    342  CA  SER    45      75.034  87.722 144.307  1.00 26.97           C  
ATOM    343  C   SER    45      74.516  88.028 145.718  1.00 26.48           C  
ATOM    344  O   SER    45      74.399  89.182 146.095  1.00 26.21           O  
ATOM    345  CB  SER    45      73.890  87.495 143.333  1.00 26.64           C  
ATOM    346  OG  SER    45      72.957  88.558 143.445  1.00 28.69           O  
ATOM    347  N   ILE    46      74.224  86.996 146.494  1.00 25.96           N  
ATOM    348  CA  ILE    46      73.833  87.201 147.897  1.00 26.95           C  
ATOM    349  C   ILE    46      74.968  87.862 148.692  1.00 27.59           C  
ATOM    350  O   ILE    46      74.747  88.814 149.427  1.00 27.43           O  
ATOM    351  CB  ILE    46      73.394  85.893 148.581  1.00 26.24           C  
ATOM    352  CG1 ILE    46      72.147  85.345 147.878  1.00 26.54           C  
ATOM    353  CG2 ILE    46      73.116  86.133 150.097  1.00 26.47           C  
ATOM    354  CD1 ILE    46      71.788  83.933 148.305  1.00 24.99           C  
ATOM    355  N   LYS    47      76.178  87.343 148.525  1.00 28.50           N  
ATOM    356  CA  LYS    47      77.356  87.895 149.171  1.00 29.72           C  
ATOM    357  C   LYS    47      77.564  89.393 148.848  1.00 30.13           C  
ATOM    358  O   LYS    47      77.805  90.203 149.751  1.00 29.54           O  
ATOM    359  CB  LYS    47      78.578  87.064 148.767  1.00 30.30           C  
ATOM    360  CG  LYS    47      78.673  85.716 149.477  1.00 32.50           C  
ATOM    361  CD  LYS    47      79.887  84.944 148.971  1.00 36.21           C  
ATOM    362  CE  LYS    47      80.083  83.653 149.768  1.00 37.75           C  
ATOM    363  NZ  LYS    47      81.284  82.869 149.334  1.00 38.21           N  
ATOM    364  N   LYS    48      77.468  89.741 147.559  1.00 30.44           N  
ATOM    365  CA  LYS    48      77.582  91.122 147.096  1.00 31.51           C  
ATOM    366  C   LYS    48      76.504  92.002 147.731  1.00 31.18           C  
ATOM    367  O   LYS    48      76.784  93.135 148.130  1.00 30.84           O  
ATOM    368  CB  LYS    48      77.493  91.185 145.566  1.00 31.62           C  
ATOM    369  CG  LYS    48      78.736  90.634 144.841  1.00 33.07           C  
ATOM    370  CD  LYS    48      78.630  90.787 143.303  1.00 33.79           C  
ATOM    371  CE  LYS    48      78.160  89.476 142.644  1.00 37.12           C  
ATOM    372  NZ  LYS    48      77.685  89.583 141.225  1.00 36.87           N  
ATOM    373  N   MET    49      75.283  91.471 147.837  1.00 30.83           N  
ATOM    374  CA  MET    49      74.181  92.190 148.491  1.00 31.77           C  
ATOM    375  C   MET    49      74.504  92.558 149.934  1.00 30.97           C  
ATOM    376  O   MET    49      74.351  93.702 150.324  1.00 30.22           O  
ATOM    377  CB  MET    49      72.872  91.393 148.461  1.00 31.29           C  
ATOM    378  CG  MET    49      71.749  92.116 149.184  1.00 32.56           C  
ATOM    379  SD  MET    49      70.139  91.076 149.565  0.70 34.45          SE  
ATOM    380  CE  MET    49      70.849  89.754 150.815  1.00 34.11           C  
ATOM    381  N   TYR    50      74.922  91.577 150.728  1.00 30.70           N  
ATOM    382  CA  TYR    50      75.252  91.834 152.147  1.00 31.24           C  
ATOM    383  C   TYR    50      76.454  92.804 152.321  1.00 32.06           C  
ATOM    384  O   TYR    50      76.481  93.637 153.238  1.00 32.05           O  
ATOM    385  CB  TYR    50      75.513  90.516 152.861  1.00 29.92           C  
ATOM    386  CG  TYR    50      74.266  89.723 153.203  1.00 29.82           C  
ATOM    387  CD1 TYR    50      73.207  90.306 153.916  1.00 27.46           C  
ATOM    388  CD2 TYR    50      74.153  88.375 152.844  1.00 27.81           C  
ATOM    389  CE1 TYR    50      72.071  89.567 154.236  1.00 28.82           C  
ATOM    390  CE2 TYR    50      73.019  87.629 153.170  1.00 27.43           C  
ATOM    391  CZ  TYR    50      71.980  88.227 153.878  1.00 27.56           C  
ATOM    392  OH  TYR    50      70.857  87.480 154.231  1.00 28.16           O  
ATOM    393  N   GLU    51      77.428  92.682 151.418  1.00 33.53           N  
ATOM    394  CA  GLU    51      78.585  93.579 151.337  1.00 35.20           C  
ATOM    395  C   GLU    51      78.158  95.036 151.106  1.00 35.05           C  
ATOM    396  O   GLU    51      78.655  95.949 151.784  1.00 35.18           O  
ATOM    397  CB  GLU    51      79.495  93.115 150.212  1.00 35.29           C  
ATOM    398  CG  GLU    51      80.946  93.479 150.349  1.00 40.27           C  
ATOM    399  CD  GLU    51      81.719  93.192 149.059  1.00 46.04           C  
ATOM    400  OE1 GLU    51      82.614  93.999 148.696  1.00 48.04           O  
ATOM    401  OE2 GLU    51      81.412  92.169 148.395  1.00 48.24           O  
ATOM    402  N   GLN    52      77.231  95.239 150.168  1.00 35.03           N  
ATOM    403  CA  GLN    52      76.595  96.549 149.922  1.00 35.53           C  
ATOM    404  C   GLN    52      75.787  97.080 151.117  1.00 34.17           C  
ATOM    405  O   GLN    52      75.843  98.253 151.428  1.00 33.89           O  
ATOM    406  CB  GLN    52      75.610  96.444 148.753  1.00 35.67           C  
ATOM    407  CG  GLN    52      76.161  96.623 147.348  1.00 38.30           C  
ATOM    408  CD  GLN    52      75.059  96.444 146.286  1.00 38.67           C  
ATOM    409  OE1 GLN    52      74.758  97.377 145.545  1.00 42.38           O  
ATOM    410  NE2 GLN    52      74.427  95.250 146.245  1.00 40.22           N  
ATOM    411  N   VAL    53      74.982  96.221 151.738  1.00 33.02           N  
ATOM    412  CA  VAL    53      74.032  96.657 152.756  1.00 31.77           C  
ATOM    413  C   VAL    53      74.734  96.975 154.079  1.00 31.61           C  
ATOM    414  O   VAL    53      74.300  97.863 154.814  1.00 31.13           O  
ATOM    415  CB  VAL    53      72.917  95.592 152.966  1.00 32.14           C  
ATOM    416  CG1 VAL    53      72.124  95.847 154.210  1.00 31.65           C  
ATOM    417  CG2 VAL    53      71.977  95.593 151.792  1.00 31.28           C  
ATOM    418  N   GLY    54      75.808  96.243 154.371  1.00 30.90           N  
ATOM    419  CA  GLY    54      76.457  96.317 155.683  1.00 31.39           C  
ATOM    420  C   GLY    54      75.587  95.602 156.690  1.00 31.14           C  
ATOM    421  O   GLY    54      74.890  94.655 156.324  1.00 32.58           O  
ATOM    422  N   LYS    55      75.583  96.063 157.935  1.00 30.24           N  
ATOM    423  CA  LYS    55      74.870  95.363 159.016  1.00 30.12           C  
ATOM    424  C   LYS    55      73.449  95.876 159.255  1.00 29.19           C  
ATOM    425  O   LYS    55      73.196  97.062 159.150  1.00 28.55           O  
ATOM    426  CB  LYS    55      75.681  95.401 160.335  1.00 30.87           C  
ATOM    427  CG  LYS    55      77.011  94.668 160.203  1.00 32.75           C  
ATOM    428  CD  LYS    55      77.630  94.306 161.510  1.00 38.98           C  
ATOM    429  CE  LYS    55      79.014  93.684 161.267  1.00 42.47           C  
ATOM    430  NZ  LYS    55      79.386  92.731 162.356  1.00 45.84           N  
ATOM    431  N   VAL    56      72.537  94.953 159.574  1.00 28.65           N  
ATOM    432  CA  VAL    56      71.131  95.280 159.860  1.00 27.78           C  
ATOM    433  C   VAL    56      70.663  94.563 161.118  1.00 27.25           C  
ATOM    434  O   VAL    56      71.383  93.736 161.658  1.00 26.65           O  
ATOM    435  CB  VAL    56      70.186  94.930 158.674  1.00 26.85           C  
ATOM    436  CG1 VAL    56      70.496  95.801 157.470  1.00 26.81           C  
ATOM    437  CG2 VAL    56      70.271  93.453 158.301  1.00 27.49           C  
ATOM    438  N   ASP    57      69.451  94.887 161.568  1.00 27.80           N  
ATOM    439  CA  ASP    57      68.850  94.240 162.733  1.00 27.89           C  
ATOM    440  C   ASP    57      67.907  93.094 162.380  1.00 28.18           C  
ATOM    441  O   ASP    57      67.706  92.209 163.204  1.00 28.86           O  
ATOM    442  CB  ASP    57      68.083  95.260 163.551  1.00 28.40           C  
ATOM    443  CG  ASP    57      68.963  96.391 163.998  1.00 31.59           C  
ATOM    444  OD1 ASP    57      68.652  97.551 163.631  1.00 36.21           O  
ATOM    445  OD2 ASP    57      69.999  96.108 164.654  1.00 32.98           O  
ATOM    446  N   ALA    58      67.310  93.117 161.190  1.00 27.40           N  
ATOM    447  CA  ALA    58      66.459  91.995 160.772  1.00 27.62           C  
ATOM    448  C   ALA    58      66.603  91.758 159.272  1.00 27.39           C  
ATOM    449  O   ALA    58      66.736  92.695 158.499  1.00 27.58           O  
ATOM    450  CB  ALA    58      64.995  92.232 161.156  1.00 26.95           C  
ATOM    451  N   ILE    59      66.623  90.492 158.885  1.00 27.49           N  
ATOM    452  CA  ILE    59      66.607  90.095 157.472  1.00 27.11           C  
ATOM    453  C   ILE    59      65.295  89.344 157.267  1.00 27.57           C  
ATOM    454  O   ILE    59      64.981  88.409 158.008  1.00 27.71           O  
ATOM    455  CB  ILE    59      67.840  89.222 157.126  1.00 27.27           C  
ATOM    456  CG1 ILE    59      69.127  90.078 157.261  1.00 26.57           C  
ATOM    457  CG2 ILE    59      67.715  88.626 155.703  1.00 24.63           C  
ATOM    458  CD1 ILE    59      70.394  89.295 157.412  1.00 26.03           C  
ATOM    459  N   VAL    60      64.493  89.826 156.326  1.00 28.08           N  
ATOM    460  CA  VAL    60      63.169  89.251 156.072  1.00 27.73           C  
ATOM    461  C   VAL    60      63.071  88.781 154.618  1.00 28.57           C  
ATOM    462  O   VAL    60      63.349  89.533 153.693  1.00 28.21           O  
ATOM    463  CB  VAL    60      62.067  90.264 156.378  1.00 27.44           C  
ATOM    464  CG1 VAL    60      60.679  89.721 155.932  1.00 27.80           C  
ATOM    465  CG2 VAL    60      62.092  90.646 157.886  1.00 26.89           C  
ATOM    466  N   SER    61      62.671  87.530 154.421  1.00 29.95           N  
ATOM    467  CA  SER    61      62.568  86.978 153.068  1.00 30.37           C  
ATOM    468  C   SER    61      61.116  86.686 152.779  1.00 31.23           C  
ATOM    469  O   SER    61      60.509  85.805 153.389  1.00 31.34           O  
ATOM    470  CB  SER    61      63.416  85.717 152.948  1.00 29.63           C  
ATOM    471  OG  SER    61      63.170  85.050 151.737  1.00 30.77           O  
ATOM    472  N   ALA    62      60.558  87.497 151.899  1.00 32.52           N  
ATOM    473  CA  ALA    62      59.273  87.253 151.277  1.00 33.81           C  
ATOM    474  C   ALA    62      59.503  86.978 149.782  1.00 34.83           C  
ATOM    475  O   ALA    62      58.849  87.562 148.909  1.00 35.84           O  
ATOM    476  CB  ALA    62      58.354  88.468 151.486  1.00 33.75           C  
ATOM    477  N   THR    63      60.475  86.117 149.494  1.00 35.60           N  
ATOM    478  CA  THR    63      60.778  85.681 148.124  1.00 37.14           C  
ATOM    479  C   THR    63      61.004  84.190 148.079  1.00 36.99           C  
ATOM    480  O   THR    63      60.865  83.493 149.086  1.00 37.39           O  
ATOM    481  CB  THR    63      62.093  86.266 147.543  1.00 37.08           C  
ATOM    482  OG1 THR    63      62.952  86.718 148.605  1.00 39.36           O  
ATOM    483  CG2 THR    63      61.825  87.333 146.527  1.00 37.63           C  
ATOM    484  N   GLY    64      61.408  83.735 146.897  1.00 37.22           N  
ATOM    485  CA  GLY    64      61.683  82.331 146.643  1.00 36.82           C  
ATOM    486  C   GLY    64      60.583  81.837 145.742  1.00 35.98           C  
ATOM    487  O   GLY    64      59.418  82.145 145.962  1.00 36.07           O  
ATOM    488  N   SER    65      60.939  81.100 144.707  1.00 35.86           N  
ATOM    489  CA  SER    65      59.905  80.462 143.920  1.00 35.87           C  
ATOM    490  C   SER    65      60.063  78.947 143.811  1.00 35.53           C  
ATOM    491  O   SER    65      61.174  78.383 143.968  1.00 34.12           O  
ATOM    492  CB  SER    65      59.684  81.168 142.565  1.00 36.59           C  
ATOM    493  OG  SER    65      60.868  81.261 141.797  1.00 39.05           O  
ATOM    494  N   ALA    66      58.916  78.301 143.633  1.00 35.28           N  
ATOM    495  CA  ALA    66      58.827  76.860 143.396  1.00 36.00           C  
ATOM    496  C   ALA    66      58.163  76.570 142.050  1.00 36.09           C  
ATOM    497  O   ALA    66      57.241  77.278 141.642  1.00 36.27           O  
ATOM    498  CB  ALA    66      58.027  76.190 144.525  1.00 36.26           C  
ATOM    499  N   THR    67      58.658  75.537 141.366  1.00 36.15           N  
ATOM    500  CA  THR    67      58.007  74.924 140.217  1.00 35.80           C  
ATOM    501  C   THR    67      56.640  74.362 140.623  1.00 35.12           C  
ATOM    502  O   THR    67      56.534  73.695 141.632  1.00 33.77           O  
ATOM    503  CB  THR    67      58.855  73.723 139.720  1.00 35.97           C  
ATOM    504  OG1 THR    67      60.120  74.176 139.214  1.00 37.36           O  
ATOM    505  CG2 THR    67      58.142  72.977 138.614  1.00 37.64           C  
ATOM    506  N   PHE    68      55.599  74.641 139.838  1.00 35.09           N  
ATOM    507  CA  PHE    68      54.312  73.933 139.978  1.00 34.98           C  
ATOM    508  C   PHE    68      54.224  72.974 138.822  1.00 33.96           C  
ATOM    509  O   PHE    68      54.343  73.385 137.669  1.00 33.07           O  
ATOM    510  CB  PHE    68      53.132  74.902 139.924  1.00 36.51           C  
ATOM    511  CG  PHE    68      52.751  75.477 141.250  1.00 40.26           C  
ATOM    512  CD1 PHE    68      53.709  75.705 142.245  1.00 43.38           C  
ATOM    513  CD2 PHE    68      51.424  75.816 141.505  1.00 44.04           C  
ATOM    514  CE1 PHE    68      53.346  76.253 143.487  1.00 45.21           C  
ATOM    515  CE2 PHE    68      51.047  76.360 142.725  1.00 43.90           C  
ATOM    516  CZ  PHE    68      52.009  76.580 143.724  1.00 43.50           C  
ATOM    517  N   SER    69      54.054  71.691 139.121  1.00 32.62           N  
ATOM    518  CA  SER    69      54.065  70.663 138.087  1.00 31.53           C  
ATOM    519  C   SER    69      53.362  69.406 138.586  1.00 30.99           C  
ATOM    520  O   SER    69      53.619  68.991 139.713  1.00 30.87           O  
ATOM    521  CB  SER    69      55.518  70.330 137.748  1.00 31.58           C  
ATOM    522  OG  SER    69      55.631  69.135 137.004  1.00 33.02           O  
ATOM    523  N   PRO    70      52.533  68.755 137.734  1.00 30.90           N  
ATOM    524  CA  PRO    70      51.981  67.455 138.136  1.00 30.68           C  
ATOM    525  C   PRO    70      53.160  66.574 138.537  1.00 30.72           C  
ATOM    526  O   PRO    70      54.210  66.631 137.880  1.00 30.60           O  
ATOM    527  CB  PRO    70      51.361  66.918 136.839  1.00 30.70           C  
ATOM    528  CG  PRO    70      51.105  68.137 135.992  1.00 30.49           C  
ATOM    529  CD  PRO    70      52.158  69.121 136.349  1.00 30.41           C  
ATOM    530  N   LEU    71      53.015  65.798 139.606  1.00 30.90           N  
ATOM    531  CA  LEU    71      54.097  64.924 140.113  1.00 31.49           C  
ATOM    532  C   LEU    71      54.744  64.086 139.017  1.00 31.74           C  
ATOM    533  O   LEU    71      55.959  63.940 138.922  1.00 32.18           O  
ATOM    534  CB  LEU    71      53.545  63.993 141.186  1.00 30.66           C  
ATOM    535  CG  LEU    71      54.503  62.961 141.788  1.00 31.94           C  
ATOM    536  CD1 LEU    71      55.565  63.600 142.665  1.00 30.84           C  
ATOM    537  CD2 LEU    71      53.683  61.964 142.612  1.00 32.08           C  
ATOM    538  N   THR    72      53.887  63.553 138.173  1.00 32.64           N  
ATOM    539  CA  THR    72      54.258  62.726 137.060  1.00 33.06           C  
ATOM    540  C   THR    72      55.042  63.486 135.965  1.00 32.56           C  
ATOM    541  O   THR    72      55.696  62.858 135.127  1.00 32.65           O  
ATOM    542  CB  THR    72      52.957  62.015 136.616  1.00 33.40           C  
ATOM    543  OG1 THR    72      52.720  60.934 137.547  1.00 36.49           O  
ATOM    544  CG2 THR    72      53.013  61.504 135.252  1.00 34.96           C  
ATOM    545  N   GLU    73      55.021  64.826 136.015  1.00 31.73           N  
ATOM    546  CA  GLU    73      55.843  65.673 135.120  1.00 31.59           C  
ATOM    547  C   GLU    73      56.975  66.381 135.861  1.00 29.95           C  
ATOM    548  O   GLU    73      57.780  67.069 135.254  1.00 30.07           O  
ATOM    549  CB  GLU    73      54.987  66.697 134.383  1.00 31.08           C  
ATOM    550  CG  GLU    73      53.937  66.051 133.505  1.00 35.57           C  
ATOM    551  CD  GLU    73      53.010  67.061 132.838  1.00 41.39           C  
ATOM    552  OE1 GLU    73      51.892  66.651 132.444  1.00 44.05           O  
ATOM    553  OE2 GLU    73      53.390  68.255 132.707  1.00 43.21           O  
ATOM    554  N   LEU    74      57.016  66.198 137.174  1.00 28.83           N  
ATOM    555  CA  LEU    74      58.048  66.789 138.039  1.00 27.67           C  
ATOM    556  C   LEU    74      59.365  66.013 137.915  1.00 27.27           C  
ATOM    557  O   LEU    74      59.589  65.029 138.629  1.00 26.82           O  
ATOM    558  CB  LEU    74      57.563  66.810 139.505  1.00 26.60           C  
ATOM    559  CG  LEU    74      58.449  67.428 140.613  1.00 27.55           C  
ATOM    560  CD1 LEU    74      58.978  68.823 140.266  1.00 24.85           C  
ATOM    561  CD2 LEU    74      57.707  67.474 141.970  1.00 26.28           C  
ATOM    562  N   THR    75      60.223  66.450 137.000  1.00 26.79           N  
ATOM    563  CA  THR    75      61.547  65.835 136.829  1.00 26.48           C  
ATOM    564  C   THR    75      62.536  66.357 137.851  1.00 26.20           C  
ATOM    565  O   THR    75      62.317  67.418 138.433  1.00 26.47           O  
ATOM    566  CB  THR    75      62.153  66.120 135.444  1.00 26.52           C  
ATOM    567  OG1 THR    75      62.149  67.524 135.223  1.00 24.43           O  
ATOM    568  CG2 THR    75      61.344  65.450 134.358  1.00 26.42           C  
ATOM    569  N   PRO    76      63.640  65.611 138.079  1.00 26.32           N  
ATOM    570  CA  PRO    76      64.732  66.158 138.892  1.00 26.02           C  
ATOM    571  C   PRO    76      65.150  67.551 138.406  1.00 25.77           C  
ATOM    572  O   PRO    76      65.433  68.419 139.235  1.00 25.48           O  
ATOM    573  CB  PRO    76      65.873  65.155 138.684  1.00 26.18           C  
ATOM    574  CG  PRO    76      65.168  63.840 138.414  1.00 26.15           C  
ATOM    575  CD  PRO    76      63.933  64.241 137.599  1.00 26.60           C  
ATOM    576  N   GLU    77      65.167  67.769 137.088  1.00 24.97           N  
ATOM    577  CA  GLU    77      65.473  69.095 136.543  1.00 25.17           C  
ATOM    578  C   GLU    77      64.515  70.192 137.009  1.00 25.61           C  
ATOM    579  O   GLU    77      64.957  71.254 137.446  1.00 24.80           O  
ATOM    580  CB  GLU    77      65.573  69.074 135.022  1.00 24.98           C  
ATOM    581  CG  GLU    77      66.775  68.319 134.524  1.00 25.56           C  
ATOM    582  CD  GLU    77      66.472  66.868 134.177  1.00 28.15           C  
ATOM    583  OE1 GLU    77      65.548  66.240 134.766  1.00 26.20           O  
ATOM    584  OE2 GLU    77      67.191  66.348 133.297  1.00 31.05           O  
ATOM    585  N   LYS    78      63.217  69.926 136.928  1.00 26.16           N  
ATOM    586  CA  LYS    78      62.196  70.873 137.404  1.00 27.26           C  
ATOM    587  C   LYS    78      62.325  71.088 138.896  1.00 26.94           C  
ATOM    588  O   LYS    78      62.309  72.231 139.351  1.00 26.88           O  
ATOM    589  CB  LYS    78      60.777  70.383 137.083  1.00 27.15           C  
ATOM    590  CG  LYS    78      60.290  70.681 135.659  1.00 30.35           C  
ATOM    591  CD  LYS    78      58.816  70.209 135.530  1.00 29.14           C  
ATOM    592  CE  LYS    78      57.998  70.960 134.498  1.00 34.52           C  
ATOM    593  NZ  LYS    78      56.547  70.486 134.496  1.00 34.23           N  
ATOM    594  N   ASN    79      62.452  69.996 139.660  1.00 27.20           N  
ATOM    595  CA  ASN    79      62.626  70.085 141.123  1.00 26.73           C  
ATOM    596  C   ASN    79      63.874  70.869 141.548  1.00 26.65           C  
ATOM    597  O   ASN    79      63.895  71.491 142.613  1.00 26.71           O  
ATOM    598  CB  ASN    79      62.610  68.682 141.738  1.00 27.21           C  
ATOM    599  CG  ASN    79      62.160  68.676 143.178  1.00 28.62           C  
ATOM    600  OD1 ASN    79      62.779  68.024 144.018  1.00 33.29           O  
ATOM    601  ND2 ASN    79      61.090  69.383 143.475  1.00 26.18           N  
ATOM    602  N   ALA    80      64.903  70.878 140.694  1.00 26.39           N  
ATOM    603  CA  ALA    80      66.127  71.656 140.955  1.00 25.89           C  
ATOM    604  C   ALA    80      65.910  73.174 140.911  1.00 25.82           C  
ATOM    605  O   ALA    80      66.600  73.918 141.590  1.00 25.69           O  
ATOM    606  CB  ALA    80      67.297  71.226 140.000  1.00 25.06           C  
ATOM    607  N   VAL    81      64.923  73.623 140.151  1.00 25.68           N  
ATOM    608  CA  VAL    81      64.539  75.035 140.159  1.00 25.94           C  
ATOM    609  C   VAL    81      64.059  75.469 141.558  1.00 25.91           C  
ATOM    610  O   VAL    81      64.607  76.405 142.135  1.00 26.06           O  
ATOM    611  CB  VAL    81      63.479  75.350 139.066  1.00 26.11           C  
ATOM    612  CG1 VAL    81      63.002  76.785 139.182  1.00 26.25           C  
ATOM    613  CG2 VAL    81      64.054  75.092 137.656  1.00 26.72           C  
ATOM    614  N   THR    82      63.066  74.778 142.110  1.00 25.85           N  
ATOM    615  CA  THR    82      62.599  75.042 143.478  1.00 26.11           C  
ATOM    616  C   THR    82      63.733  75.033 144.503  1.00 26.87           C  
ATOM    617  O   THR    82      63.779  75.891 145.402  1.00 28.39           O  
ATOM    618  CB  THR    82      61.551  73.991 143.906  1.00 26.20           C  
ATOM    619  OG1 THR    82      60.541  73.893 142.889  1.00 26.44           O  
ATOM    620  CG2 THR    82      60.895  74.359 145.221  1.00 23.76           C  
ATOM    621  N   ILE    83      64.611  74.038 144.385  1.00 26.79           N  
ATOM    622  CA  ILE    83      65.729  73.837 145.289  1.00 27.08           C  
ATOM    623  C   ILE    83      66.688  75.029 145.286  1.00 27.28           C  
ATOM    624  O   ILE    83      67.136  75.493 146.357  1.00 27.62           O  
ATOM    625  CB  ILE    83      66.471  72.481 144.992  1.00 27.10           C  
ATOM    626  CG1 ILE    83      65.593  71.310 145.480  1.00 26.85           C  
ATOM    627  CG2 ILE    83      67.847  72.444 145.690  1.00 26.25           C  
ATOM    628  CD1 ILE    83      66.019  69.878 144.998  1.00 28.20           C  
ATOM    629  N   SER    84      66.936  75.567 144.100  1.00 27.43           N  
ATOM    630  CA  SER    84      67.817  76.732 143.953  1.00 27.65           C  
ATOM    631  C   SER    84      67.198  78.043 144.460  1.00 27.57           C  
ATOM    632  O   SER    84      67.926  79.009 144.737  1.00 28.54           O  
ATOM    633  CB  SER    84      68.244  76.883 142.486  1.00 27.23           C  
ATOM    634  OG  SER    84      67.200  77.441 141.728  1.00 27.53           O  
ATOM    635  N   SER    85      65.873  78.094 144.574  1.00 27.44           N  
ATOM    636  CA  SER    85      65.181  79.354 144.869  1.00 27.45           C  
ATOM    637  C   SER    85      64.446  79.349 146.211  1.00 27.88           C  
ATOM    638  O   SER    85      65.037  79.680 147.229  1.00 28.39           O  
ATOM    639  CB  SER    85      64.247  79.767 143.720  1.00 27.61           C  
ATOM    640  OG  SER    85      63.509  80.937 144.072  1.00 26.70           O  
ATOM    641  N   LYS    86      63.172  78.968 146.219  1.00 27.88           N  
ATOM    642  CA  LYS    86      62.366  78.895 147.467  1.00 28.51           C  
ATOM    643  C   LYS    86      63.087  78.216 148.624  1.00 28.64           C  
ATOM    644  O   LYS    86      62.995  78.643 149.788  1.00 28.02           O  
ATOM    645  CB  LYS    86      61.045  78.147 147.211  1.00 29.14           C  
ATOM    646  CG  LYS    86      60.010  78.236 148.382  1.00 30.48           C  
ATOM    647  CD  LYS    86      59.167  79.482 148.254  1.00 34.46           C  
ATOM    648  CE  LYS    86      58.569  79.951 149.569  1.00 34.96           C  
ATOM    649  NZ  LYS    86      57.220  79.357 149.728  1.00 31.88           N  
ATOM    650  N   LEU    87      63.776  77.129 148.302  1.00 29.57           N  
ATOM    651  CA  LEU    87      64.456  76.314 149.306  1.00 29.64           C  
ATOM    652  C   LEU    87      65.875  76.830 149.556  1.00 30.00           C  
ATOM    653  O   LEU    87      66.131  77.502 150.566  1.00 30.14           O  
ATOM    654  CB  LEU    87      64.463  74.841 148.877  1.00 29.27           C  
ATOM    655  CG  LEU    87      64.831  73.748 149.902  1.00 30.59           C  
ATOM    656  CD1 LEU    87      64.349  72.366 149.404  1.00 32.32           C  
ATOM    657  CD2 LEU    87      66.311  73.696 150.247  1.00 32.75           C  
ATOM    658  N   GLY    88      66.780  76.532 148.624  1.00 30.59           N  
ATOM    659  CA  GLY    88      68.199  76.853 148.761  1.00 31.07           C  
ATOM    660  C   GLY    88      68.492  78.326 148.872  1.00 31.31           C  
ATOM    661  O   GLY    88      69.367  78.713 149.633  1.00 32.61           O  
ATOM    662  N   GLY    89      67.767  79.137 148.103  1.00 31.02           N  
ATOM    663  CA  GLY    89      67.925  80.580 148.092  1.00 29.84           C  
ATOM    664  C   GLY    89      67.605  81.191 149.436  1.00 30.31           C  
ATOM    665  O   GLY    89      68.421  81.922 149.978  1.00 30.30           O  
ATOM    666  N   GLN    90      66.437  80.866 149.992  1.00 29.06           N  
ATOM    667  CA  GLN    90      66.097  81.319 151.347  1.00 29.14           C  
ATOM    668  C   GLN    90      67.073  80.842 152.433  1.00 28.89           C  
ATOM    669  O   GLN    90      67.494  81.635 153.287  1.00 29.66           O  
ATOM    670  CB  GLN    90      64.652  80.933 151.700  1.00 28.34           C  
ATOM    671  CG  GLN    90      63.610  81.768 150.939  1.00 28.39           C  
ATOM    672  CD  GLN    90      62.258  81.727 151.609  1.00 29.55           C  
ATOM    673  OE1 GLN    90      61.856  82.694 152.264  1.00 30.50           O  
ATOM    674  NE2 GLN    90      61.548  80.597 151.470  1.00 26.71           N  
ATOM    675  N   ILE    91      67.427  79.558 152.416  1.00 28.75           N  
ATOM    676  CA  ILE    91      68.419  79.035 153.371  1.00 28.76           C  
ATOM    677  C   ILE    91      69.764  79.763 153.227  1.00 28.01           C  
ATOM    678  O   ILE    91      70.419  80.073 154.235  1.00 28.41           O  
ATOM    679  CB  ILE    91      68.664  77.501 153.248  1.00 29.14           C  
ATOM    680  CG1 ILE    91      67.356  76.678 153.259  1.00 31.79           C  
ATOM    681  CG2 ILE    91      69.675  77.016 154.299  1.00 28.95           C  
ATOM    682  CD1 ILE    91      66.668  76.636 154.480  1.00 29.78           C  
ATOM    683  N   ASN    92      70.181  80.042 151.988  1.00 27.06           N  
ATOM    684  CA  ASN    92      71.444  80.743 151.772  1.00 27.02           C  
ATOM    685  C   ASN    92      71.465  82.161 152.266  1.00 26.98           C  
ATOM    686  O   ASN    92      72.519  82.643 152.684  1.00 27.44           O  
ATOM    687  CB  ASN    92      71.914  80.662 150.315  1.00 26.86           C  
ATOM    688  CG  ASN    92      72.399  79.283 149.961  1.00 26.96           C  
ATOM    689  OD1 ASN    92      72.732  78.520 150.851  1.00 27.06           O  
ATOM    690  ND2 ASN    92      72.416  78.940 148.663  1.00 25.66           N  
ATOM    691  N   LEU    93      70.324  82.845 152.219  1.00 26.76           N  
ATOM    692  CA  LEU    93      70.257  84.163 152.830  1.00 26.77           C  
ATOM    693  C   LEU    93      70.639  84.071 154.305  1.00 27.03           C  
ATOM    694  O   LEU    93      71.293  84.979 154.819  1.00 27.41           O  
ATOM    695  CB  LEU    93      68.875  84.789 152.669  1.00 27.04           C  
ATOM    696  CG  LEU    93      68.462  85.196 151.250  1.00 25.94           C  
ATOM    697  CD1 LEU    93      67.011  85.533 151.231  1.00 25.95           C  
ATOM    698  CD2 LEU    93      69.290  86.389 150.729  1.00 25.48           C  
ATOM    699  N   VAL    94      70.288  82.962 154.959  1.00 26.50           N  
ATOM    700  CA  VAL    94      70.625  82.762 156.389  1.00 26.28           C  
ATOM    701  C   VAL    94      72.090  82.396 156.583  1.00 26.41           C  
ATOM    702  O   VAL    94      72.800  83.051 157.352  1.00 27.38           O  
ATOM    703  CB  VAL    94      69.722  81.714 157.090  1.00 26.49           C  
ATOM    704  CG1 VAL    94      70.141  81.549 158.592  1.00 26.24           C  
ATOM    705  CG2 VAL    94      68.236  82.109 156.983  1.00 26.22           C  
ATOM    706  N   LEU    95      72.568  81.381 155.869  1.00 26.02           N  
ATOM    707  CA  LEU    95      73.964  80.967 156.006  1.00 26.29           C  
ATOM    708  C   LEU    95      74.968  82.068 155.582  1.00 26.53           C  
ATOM    709  O   LEU    95      76.086  82.108 156.090  1.00 26.46           O  
ATOM    710  CB  LEU    95      74.259  79.694 155.204  1.00 25.49           C  
ATOM    711  CG  LEU    95      73.319  78.503 155.339  1.00 25.72           C  
ATOM    712  CD1 LEU    95      73.702  77.432 154.329  1.00 24.65           C  
ATOM    713  CD2 LEU    95      73.328  77.962 156.828  1.00 26.36           C  
ATOM    714  N   LEU    96      74.567  82.949 154.661  1.00 26.05           N  
ATOM    715  CA  LEU    96      75.457  84.036 154.254  1.00 25.87           C  
ATOM    716  C   LEU    96      75.225  85.338 155.022  1.00 26.07           C  
ATOM    717  O   LEU    96      75.962  86.310 154.847  1.00 25.26           O  
ATOM    718  CB  LEU    96      75.373  84.260 152.743  1.00 24.41           C  
ATOM    719  CG  LEU    96      75.816  83.071 151.886  1.00 25.07           C  
ATOM    720  CD1 LEU    96      75.501  83.358 150.389  1.00 25.66           C  
ATOM    721  CD2 LEU    96      77.307  82.737 152.077  1.00 26.31           C  
ATOM    722  N   GLY    97      74.202  85.348 155.870  1.00 26.63           N  
ATOM    723  CA  GLY    97      73.707  86.574 156.460  1.00 27.76           C  
ATOM    724  C   GLY    97      73.912  86.744 157.953  1.00 29.04           C  
ATOM    725  O   GLY    97      73.792  87.853 158.453  1.00 29.23           O  
ATOM    726  N   ILE    98      74.214  85.663 158.671  1.00 30.03           N  
ATOM    727  CA  ILE    98      74.404  85.732 160.136  1.00 30.69           C  
ATOM    728  C   ILE    98      75.422  86.841 160.506  1.00 31.11           C  
ATOM    729  O   ILE    98      75.172  87.668 161.401  1.00 31.16           O  
ATOM    730  CB  ILE    98      74.832  84.352 160.720  1.00 30.38           C  
ATOM    731  CG1 ILE    98      73.669  83.339 160.651  1.00 32.15           C  
ATOM    732  CG2 ILE    98      75.336  84.480 162.173  1.00 32.07           C  
ATOM    733  CD1 ILE    98      74.129  81.852 160.633  1.00 30.74           C  
ATOM    734  N   ASP    99      76.553  86.851 159.804  1.00 31.56           N  
ATOM    735  CA  ASP    99      77.611  87.856 160.001  1.00 32.42           C  
ATOM    736  C   ASP    99      77.161  89.290 159.705  1.00 31.42           C  
ATOM    737  O   ASP    99      77.771  90.244 160.178  1.00 31.67           O  
ATOM    738  CB  ASP    99      78.826  87.516 159.132  1.00 33.58           C  
ATOM    739  CG  ASP    99      79.685  86.382 159.717  1.00 37.44           C  
ATOM    740  OD1 ASP    99      79.584  86.099 160.944  1.00 39.04           O  
ATOM    741  OD2 ASP    99      80.472  85.786 158.927  1.00 41.53           O  
ATOM    742  N   SER   100      76.083  89.434 158.943  1.00 30.23           N  
ATOM    743  CA  SER   100      75.492  90.737 158.682  1.00 29.66           C  
ATOM    744  C   SER   100      74.395  91.160 159.674  1.00 29.81           C  
ATOM    745  O   SER   100      73.822  92.222 159.511  1.00 31.57           O  
ATOM    746  CB  SER   100      74.931  90.788 157.253  1.00 29.18           C  
ATOM    747  OG  SER   100      75.976  90.695 156.306  1.00 28.62           O  
ATOM    748  N   LEU   101      74.086  90.354 160.681  1.00 28.76           N  
ATOM    749  CA  LEU   101      73.079  90.746 161.664  1.00 28.40           C  
ATOM    750  C   LEU   101      73.696  91.267 162.957  1.00 28.66           C  
ATOM    751  O   LEU   101      74.635  90.651 163.500  1.00 27.21           O  
ATOM    752  CB  LEU   101      72.163  89.572 162.015  1.00 28.12           C  
ATOM    753  CG  LEU   101      70.907  89.290 161.195  1.00 27.99           C  
ATOM    754  CD1 LEU   101      70.125  88.202 161.924  1.00 27.76           C  
ATOM    755  CD2 LEU   101      70.047  90.522 161.030  1.00 28.00           C  
ATOM    756  N   ASN   102      73.156  92.379 163.463  1.00 28.81           N  
ATOM    757  CA  ASN   102      73.526  92.854 164.801  1.00 29.36           C  
ATOM    758  C   ASN   102      73.030  91.901 165.893  1.00 29.27           C  
ATOM    759  O   ASN   102      72.095  91.126 165.672  1.00 28.85           O  
ATOM    760  CB  ASN   102      72.944  94.240 165.069  1.00 30.11           C  
ATOM    761  CG  ASN   102      73.452  95.300 164.094  1.00 32.51           C  
ATOM    762  OD1 ASN   102      74.610  95.259 163.637  1.00 34.10           O  
ATOM    763  ND2 ASN   102      72.593  96.276 163.793  1.00 30.65           N  
ATOM    764  N   ASP   103      73.643  91.984 167.072  1.00 29.21           N  
ATOM    765  CA  ASP   103      73.211  91.216 168.239  1.00 29.76           C  
ATOM    766  C   ASP   103      71.707  91.332 168.435  1.00 29.57           C  
ATOM    767  O   ASP   103      71.155  92.410 168.269  1.00 29.00           O  
ATOM    768  CB  ASP   103      73.897  91.757 169.505  1.00 29.66           C  
ATOM    769  CG  ASP   103      75.411  91.637 169.453  1.00 31.57           C  
ATOM    770  OD1 ASP   103      76.080  91.996 170.460  1.00 36.18           O  
ATOM    771  OD2 ASP   103      75.934  91.162 168.426  1.00 30.89           O  
ATOM    772  N   LYS   104      71.074  90.231 168.850  1.00 30.49           N  
ATOM    773  CA  LYS   104      69.618  90.156 169.117  1.00 30.56           C  
ATOM    774  C   LYS   104      68.788  90.410 167.845  1.00 29.55           C  
ATOM    775  O   LYS   104      67.591  90.683 167.922  1.00 28.41           O  
ATOM    776  CB  LYS   104      69.181  91.093 170.277  1.00 32.09           C  
ATOM    777  CG  LYS   104      69.681  90.720 171.720  1.00 34.10           C  
ATOM    778  CD  LYS   104      68.699  89.710 172.415  1.00 39.98           C  
ATOM    779  CE  LYS   104      69.035  89.366 173.903  1.00 41.01           C  
ATOM    780  NZ  LYS   104      70.146  88.351 174.163  1.00 45.27           N  
ATOM    781  N   GLY   105      69.441  90.307 166.684  1.00 29.04           N  
ATOM    782  CA  GLY   105      68.789  90.467 165.385  1.00 28.30           C  
ATOM    783  C   GLY   105      67.854  89.312 165.094  1.00 28.17           C  
ATOM    784  O   GLY   105      67.672  88.410 165.939  1.00 28.00           O  
ATOM    785  N   SER   106      67.245  89.325 163.911  1.00 27.25           N  
ATOM    786  CA  SER   106      66.358  88.232 163.520  1.00 26.99           C  
ATOM    787  C   SER   106      66.375  87.930 162.012  1.00 27.04           C  
ATOM    788  O   SER   106      66.676  88.809 161.188  1.00 27.12           O  
ATOM    789  CB  SER   106      64.929  88.520 163.975  1.00 27.32           C  
ATOM    790  OG  SER   106      64.314  89.454 163.114  1.00 25.57           O  
ATOM    791  N   PHE   107      66.101  86.668 161.678  1.00 26.57           N  
ATOM    792  CA  PHE   107      65.713  86.245 160.324  1.00 25.77           C  
ATOM    793  C   PHE   107      64.216  85.882 160.327  1.00 25.99           C  
ATOM    794  O   PHE   107      63.696  85.319 161.316  1.00 25.67           O  
ATOM    795  CB  PHE   107      66.463  84.980 159.888  1.00 25.17           C  
ATOM    796  CG  PHE   107      67.943  85.148 159.704  1.00 24.98           C  
ATOM    797  CD1 PHE   107      68.455  85.707 158.532  1.00 26.78           C  
ATOM    798  CD2 PHE   107      68.836  84.699 160.700  1.00 24.95           C  
ATOM    799  CE1 PHE   107      69.850  85.859 158.350  1.00 26.97           C  
ATOM    800  CE2 PHE   107      70.224  84.857 160.554  1.00 27.03           C  
ATOM    801  CZ  PHE   107      70.736  85.433 159.357  1.00 26.65           C  
ATOM    802  N   THR   108      63.527  86.170 159.221  1.00 25.06           N  
ATOM    803  CA  THR   108      62.152  85.716 159.035  1.00 25.07           C  
ATOM    804  C   THR   108      62.024  85.236 157.613  1.00 25.47           C  
ATOM    805  O   THR   108      62.214  86.005 156.681  1.00 27.31           O  
ATOM    806  CB  THR   108      61.134  86.836 159.278  1.00 24.34           C  
ATOM    807  OG1 THR   108      61.396  87.412 160.564  1.00 25.14           O  
ATOM    808  CG2 THR   108      59.674  86.280 159.281  1.00 22.40           C  
ATOM    809  N   LEU   109      61.666  83.979 157.444  1.00 27.11           N  
ATOM    810  CA  LEU   109      61.626  83.354 156.112  1.00 28.52           C  
ATOM    811  C   LEU   109      60.178  83.004 155.785  1.00 28.63           C  
ATOM    812  O   LEU   109      59.371  82.881 156.700  1.00 29.01           O  
ATOM    813  CB  LEU   109      62.494  82.091 156.133  1.00 29.08           C  
ATOM    814  CG  LEU   109      64.000  82.057 155.795  1.00 30.85           C  
ATOM    815  CD1 LEU   109      64.689  83.338 156.038  1.00 30.71           C  
ATOM    816  CD2 LEU   109      64.744  80.907 156.480  1.00 29.65           C  
ATOM    817  N   THR   110      59.853  82.827 154.499  1.00 28.09           N  
ATOM    818  CA  THR   110      58.492  82.482 154.068  1.00 28.41           C  
ATOM    819  C   THR   110      58.332  81.000 153.665  1.00 28.40           C  
ATOM    820  O   THR   110      59.138  80.471 152.891  1.00 28.54           O  
ATOM    821  CB  THR   110      58.048  83.366 152.861  1.00 28.39           C  
ATOM    822  OG1 THR   110      58.126  84.735 153.251  1.00 30.95           O  
ATOM    823  CG2 THR   110      56.624  83.067 152.455  1.00 27.86           C  
ATOM    824  N   THR   111      57.293  80.336 154.185  1.00 28.30           N  
ATOM    825  CA  THR   111      57.019  78.948 153.815  1.00 27.25           C  
ATOM    826  C   THR   111      55.667  78.887 153.103  1.00 27.90           C  
ATOM    827  O   THR   111      55.539  79.433 152.004  1.00 27.18           O  
ATOM    828  CB  THR   111      57.142  77.948 155.011  1.00 27.87           C  
ATOM    829  OG1 THR   111      56.303  78.347 156.095  1.00 27.34           O  
ATOM    830  CG2 THR   111      58.595  77.874 155.522  1.00 27.01           C  
ATOM    831  N   GLY   112      54.660  78.250 153.704  1.00 27.83           N  
ATOM    832  CA  GLY   112      53.378  78.088 153.002  1.00 28.14           C  
ATOM    833  C   GLY   112      52.584  76.853 153.361  1.00 27.55           C  
ATOM    834  O   GLY   112      53.152  75.810 153.713  1.00 28.59           O  
ATOM    835  N   ILE   113      51.261  76.999 153.276  1.00 27.70           N  
ATOM    836  CA  ILE   113      50.273  75.982 153.622  1.00 28.07           C  
ATOM    837  C   ILE   113      50.415  74.626 152.894  1.00 28.92           C  
ATOM    838  O   ILE   113      50.069  73.603 153.449  1.00 29.77           O  
ATOM    839  CB  ILE   113      48.812  76.535 153.438  1.00 27.86           C  
ATOM    840  CG1 ILE   113      47.809  75.673 154.245  1.00 27.79           C  
ATOM    841  CG2 ILE   113      48.448  76.666 151.929  1.00 25.50           C  
ATOM    842  CD1 ILE   113      46.405  76.294 154.400  1.00 27.83           C  
ATOM    843  N   MET   114      50.947  74.622 151.680  1.00 29.93           N  
ATOM    844  CA  MET   114      51.113  73.383 150.894  1.00 32.78           C  
ATOM    845  C   MET   114      51.845  72.241 151.580  1.00 32.46           C  
ATOM    846  O   MET   114      51.562  71.068 151.319  1.00 33.47           O  
ATOM    847  CB  MET   114      51.745  73.691 149.542  1.00 32.06           C  
ATOM    848  CG  MET   114      50.756  74.361 148.626  1.00 33.19           C  
ATOM    849  SD  MET   114      51.529  74.649 146.886  0.60 39.28          SE  
ATOM    850  CE  MET   114      52.049  76.420 147.086  1.00 26.65           C  
ATOM    851  N   MET   115      52.763  72.565 152.477  1.00 32.63           N  
ATOM    852  CA  MET   115      53.460  71.544 153.207  1.00 34.07           C  
ATOM    853  C   MET   115      52.487  70.799 154.130  1.00 34.16           C  
ATOM    854  O   MET   115      52.763  69.661 154.538  1.00 34.36           O  
ATOM    855  CB  MET   115      54.597  72.163 154.029  1.00 33.63           C  
ATOM    856  CG  MET   115      54.129  72.973 155.206  1.00 33.93           C  
ATOM    857  SD  MET   115      55.632  73.646 156.231  0.70 37.96          SE  
ATOM    858  CE  MET   115      54.615  74.982 157.229  1.00 33.39           C  
ATOM    859  N   GLU   116      51.368  71.465 154.448  1.00 34.23           N  
ATOM    860  CA  GLU   116      50.374  71.017 155.446  1.00 34.85           C  
ATOM    861  C   GLU   116      49.034  70.565 154.824  1.00 33.35           C  
ATOM    862  O   GLU   116      48.345  69.685 155.347  1.00 33.07           O  
ATOM    863  CB  GLU   116      50.092  72.192 156.397  1.00 35.66           C  
ATOM    864  CG  GLU   116      49.267  71.846 157.592  1.00 43.32           C  
ATOM    865  CD  GLU   116      50.134  71.435 158.769  1.00 52.53           C  
ATOM    866  OE1 GLU   116      49.796  71.837 159.913  1.00 55.85           O  
ATOM    867  OE2 GLU   116      51.173  70.747 158.543  1.00 55.65           O  
ATOM    868  N   ASP   117      48.649  71.211 153.728  1.00 31.58           N  
ATOM    869  CA  ASP   117      47.341  71.016 153.122  1.00 29.98           C  
ATOM    870  C   ASP   117      47.644  70.899 151.625  1.00 30.10           C  
ATOM    871  O   ASP   117      47.528  71.900 150.882  1.00 29.37           O  
ATOM    872  CB  ASP   117      46.499  72.252 153.449  1.00 30.25           C  
ATOM    873  CG  ASP   117      45.029  72.065 153.194  1.00 30.32           C  
ATOM    874  OD1 ASP   117      44.657  71.195 152.386  1.00 32.67           O  
ATOM    875  OD2 ASP   117      44.237  72.818 153.797  1.00 31.54           O  
ATOM    876  N   PRO   118      48.128  69.711 151.191  1.00 29.23           N  
ATOM    877  CA  PRO   118      48.691  69.577 149.835  1.00 29.07           C  
ATOM    878  C   PRO   118      47.689  69.646 148.678  1.00 28.01           C  
ATOM    879  O   PRO   118      46.520  69.288 148.835  1.00 27.34           O  
ATOM    880  CB  PRO   118      49.389  68.206 149.868  1.00 29.33           C  
ATOM    881  CG  PRO   118      48.718  67.448 150.938  1.00 29.37           C  
ATOM    882  CD  PRO   118      48.186  68.436 151.943  1.00 29.96           C  
ATOM    883  N   ILE   119      48.173  70.111 147.528  1.00 28.08           N  
ATOM    884  CA  ILE   119      47.369  70.257 146.313  1.00 26.60           C  
ATOM    885  C   ILE   119      48.086  69.559 145.161  1.00 27.24           C  
ATOM    886  O   ILE   119      49.309  69.308 145.217  1.00 26.94           O  
ATOM    887  CB  ILE   119      47.125  71.776 145.950  1.00 27.72           C  
ATOM    888  CG1 ILE   119      48.452  72.559 145.871  1.00 27.60           C  
ATOM    889  CG2 ILE   119      46.230  72.439 146.978  1.00 26.14           C  
ATOM    890  CD1 ILE   119      48.447  73.728 144.818  1.00 25.37           C  
ATOM    891  N   VAL   120      47.337  69.227 144.116  1.00 26.98           N  
ATOM    892  CA  VAL   120      47.945  68.699 142.901  1.00 27.63           C  
ATOM    893  C   VAL   120      48.863  69.782 142.296  1.00 27.90           C  
ATOM    894  O   VAL   120      48.525  70.965 142.309  1.00 27.91           O  
ATOM    895  CB  VAL   120      46.881  68.252 141.883  1.00 27.36           C  
ATOM    896  CG1 VAL   120      47.531  67.905 140.545  1.00 28.60           C  
ATOM    897  CG2 VAL   120      46.073  67.076 142.436  1.00 27.22           C  
ATOM    898  N   GLN   121      50.027  69.343 141.804  1.00 28.10           N  
ATOM    899  CA  GLN   121      51.118  70.183 141.283  1.00 27.54           C  
ATOM    900  C   GLN   121      51.988  70.789 142.378  1.00 27.92           C  
ATOM    901  O   GLN   121      52.966  71.491 142.067  1.00 27.38           O  
ATOM    902  CB  GLN   121      50.633  71.265 140.314  1.00 27.15           C  
ATOM    903  CG  GLN   121      49.855  70.715 139.107  1.00 28.14           C  
ATOM    904  CD  GLN   121      49.955  71.620 137.895  1.00 28.34           C  
ATOM    905  OE1 GLN   121      50.863  72.455 137.800  1.00 31.14           O  
ATOM    906  NE2 GLN   121      49.015  71.481 136.974  1.00 27.72           N  
ATOM    907  N   GLY   122      51.665  70.500 143.644  1.00 27.70           N  
ATOM    908  CA  GLY   122      52.272  71.237 144.768  1.00 28.38           C  
ATOM    909  C   GLY   122      53.429  70.558 145.469  1.00 28.72           C  
ATOM    910  O   GLY   122      53.937  71.080 146.456  1.00 30.58           O  
ATOM    911  N   ALA   123      53.871  69.400 144.977  1.00 28.79           N  
ATOM    912  CA  ALA   123      54.842  68.570 145.732  1.00 28.32           C  
ATOM    913  C   ALA   123      56.237  69.214 145.942  1.00 28.38           C  
ATOM    914  O   ALA   123      56.876  69.046 146.996  1.00 28.17           O  
ATOM    915  CB  ALA   123      54.982  67.187 145.083  1.00 26.61           C  
ATOM    916  N   SER   124      56.704  69.917 144.914  1.00 28.00           N  
ATOM    917  CA  SER   124      57.985  70.650 144.955  1.00 28.18           C  
ATOM    918  C   SER   124      57.897  71.822 145.923  1.00 27.47           C  
ATOM    919  O   SER   124      58.744  71.990 146.798  1.00 28.38           O  
ATOM    920  CB  SER   124      58.354  71.128 143.540  1.00 26.89           C  
ATOM    921  OG  SER   124      59.713  71.537 143.451  1.00 26.74           O  
ATOM    922  N   ALA   125      56.839  72.612 145.792  1.00 27.16           N  
ATOM    923  CA  ALA   125      56.578  73.691 146.724  1.00 27.52           C  
ATOM    924  C   ALA   125      56.492  73.207 148.187  1.00 26.85           C  
ATOM    925  O   ALA   125      57.084  73.804 149.083  1.00 26.79           O  
ATOM    926  CB  ALA   125      55.298  74.434 146.313  1.00 27.11           C  
ATOM    927  N   ALA   126      55.755  72.122 148.401  1.00 27.19           N  
ATOM    928  CA  ALA   126      55.613  71.490 149.730  1.00 27.11           C  
ATOM    929  C   ALA   126      56.963  71.063 150.299  1.00 26.96           C  
ATOM    930  O   ALA   126      57.259  71.338 151.466  1.00 26.27           O  
ATOM    931  CB  ALA   126      54.656  70.287 149.665  1.00 26.52           C  
ATOM    932  N   MET   127      57.801  70.445 149.468  1.00 27.45           N  
ATOM    933  CA  MET   127      59.170  70.106 149.894  1.00 29.26           C  
ATOM    934  C   MET   127      59.977  71.336 150.386  1.00 28.56           C  
ATOM    935  O   MET   127      60.629  71.280 151.444  1.00 28.62           O  
ATOM    936  CB  MET   127      59.934  69.373 148.770  1.00 29.08           C  
ATOM    937  CG  MET   127      61.465  69.358 148.936  1.00 28.64           C  
ATOM    938  SD  MET   127      62.403  69.154 147.208  0.75 36.16          SE  
ATOM    939  CE  MET   127      62.175  70.994 146.489  1.00 32.20           C  
ATOM    940  N   ALA   128      59.950  72.427 149.611  1.00 28.02           N  
ATOM    941  CA  ALA   128      60.661  73.668 149.983  1.00 26.96           C  
ATOM    942  C   ALA   128      60.188  74.226 151.344  1.00 27.32           C  
ATOM    943  O   ALA   128      61.007  74.612 152.202  1.00 26.50           O  
ATOM    944  CB  ALA   128      60.517  74.724 148.880  1.00 27.40           C  
ATOM    945  N   ASN   129      58.874  74.211 151.553  1.00 26.64           N  
ATOM    946  CA  ASN   129      58.270  74.760 152.756  1.00 27.07           C  
ATOM    947  C   ASN   129      58.595  73.912 153.982  1.00 26.72           C  
ATOM    948  O   ASN   129      58.838  74.452 155.060  1.00 27.53           O  
ATOM    949  CB  ASN   129      56.752  74.930 152.581  1.00 26.67           C  
ATOM    950  CG  ASN   129      56.398  75.968 151.517  1.00 29.08           C  
ATOM    951  OD1 ASN   129      57.255  76.771 151.089  1.00 33.20           O  
ATOM    952  ND2 ASN   129      55.154  75.931 151.046  1.00 28.50           N  
ATOM    953  N   GLY   130      58.567  72.592 153.833  1.00 25.78           N  
ATOM    954  CA  GLY   130      59.005  71.700 154.892  1.00 25.32           C  
ATOM    955  C   GLY   130      60.479  71.899 155.216  1.00 25.16           C  
ATOM    956  O   GLY   130      60.862  72.001 156.370  1.00 25.37           O  
ATOM    957  N   ALA   131      61.308  71.957 154.184  1.00 25.57           N  
ATOM    958  CA  ALA   131      62.755  72.155 154.348  1.00 26.33           C  
ATOM    959  C   ALA   131      63.084  73.432 155.136  1.00 26.35           C  
ATOM    960  O   ALA   131      63.914  73.430 156.048  1.00 26.68           O  
ATOM    961  CB  ALA   131      63.431  72.234 152.959  1.00 25.86           C  
ATOM    962  N   VAL   132      62.436  74.525 154.741  1.00 26.94           N  
ATOM    963  CA  VAL   132      62.687  75.813 155.345  1.00 26.56           C  
ATOM    964  C   VAL   132      62.150  75.857 156.793  1.00 26.67           C  
ATOM    965  O   VAL   132      62.825  76.404 157.709  1.00 26.53           O  
ATOM    966  CB  VAL   132      62.141  76.905 154.439  1.00 26.44           C  
ATOM    967  CG1 VAL   132      62.171  78.299 155.128  1.00 27.72           C  
ATOM    968  CG2 VAL   132      62.961  76.916 153.110  1.00 26.29           C  
ATOM    969  N   THR   133      60.965  75.275 157.010  1.00 25.76           N  
ATOM    970  CA  THR   133      60.386  75.195 158.372  1.00 25.92           C  
ATOM    971  C   THR   133      61.319  74.450 159.317  1.00 26.25           C  
ATOM    972  O   THR   133      61.600  74.923 160.415  1.00 27.21           O  
ATOM    973  CB  THR   133      59.022  74.443 158.362  1.00 25.31           C  
ATOM    974  OG1 THR   133      58.095  75.124 157.491  1.00 24.22           O  
ATOM    975  CG2 THR   133      58.452  74.314 159.773  1.00 25.19           C  
ATOM    976  N   ALA   134      61.756  73.253 158.910  1.00 27.08           N  
ATOM    977  CA  ALA   134      62.595  72.416 159.773  1.00 26.79           C  
ATOM    978  C   ALA   134      63.962  73.037 159.938  1.00 26.88           C  
ATOM    979  O   ALA   134      64.556  72.949 161.028  1.00 26.43           O  
ATOM    980  CB  ALA   134      62.719  71.011 159.235  1.00 27.14           C  
ATOM    981  N   PHE   135      64.462  73.686 158.876  1.00 27.35           N  
ATOM    982  CA  PHE   135      65.766  74.357 158.984  1.00 27.59           C  
ATOM    983  C   PHE   135      65.788  75.443 160.066  1.00 27.62           C  
ATOM    984  O   PHE   135      66.691  75.518 160.868  1.00 27.62           O  
ATOM    985  CB  PHE   135      66.213  74.978 157.670  1.00 26.50           C  
ATOM    986  CG  PHE   135      67.410  75.855 157.833  1.00 27.59           C  
ATOM    987  CD1 PHE   135      68.685  75.289 157.965  1.00 28.36           C  
ATOM    988  CD2 PHE   135      67.275  77.239 157.900  1.00 27.24           C  
ATOM    989  CE1 PHE   135      69.808  76.097 158.139  1.00 25.71           C  
ATOM    990  CE2 PHE   135      68.372  78.056 158.073  1.00 28.16           C  
ATOM    991  CZ  PHE   135      69.649  77.490 158.206  1.00 27.41           C  
ATOM    992  N   ALA   136      64.766  76.279 160.049  1.00 28.28           N  
ATOM    993  CA  ALA   136      64.626  77.387 160.957  1.00 28.31           C  
ATOM    994  C   ALA   136      64.379  76.948 162.404  1.00 28.70           C  
ATOM    995  O   ALA   136      64.932  77.529 163.345  1.00 29.30           O  
ATOM    996  CB  ALA   136      63.510  78.284 160.467  1.00 28.08           C  
ATOM    997  N   LYS   137      63.556  75.930 162.579  1.00 29.20           N  
ATOM    998  CA  LYS   137      63.317  75.368 163.903  1.00 29.09           C  
ATOM    999  C   LYS   137      64.621  74.955 164.580  1.00 28.56           C  
ATOM   1000  O   LYS   137      64.826  75.189 165.761  1.00 28.36           O  
ATOM   1001  CB  LYS   137      62.383  74.157 163.810  1.00 29.36           C  
ATOM   1002  CG  LYS   137      62.116  73.474 165.159  1.00 30.78           C  
ATOM   1003  CD  LYS   137      60.879  72.605 165.071  1.00 36.89           C  
ATOM   1004  CE  LYS   137      59.956  72.794 166.271  1.00 39.40           C  
ATOM   1005  NZ  LYS   137      60.437  72.106 167.469  1.00 40.74           N  
ATOM   1006  N   SER   138      65.485  74.304 163.814  1.00 28.80           N  
ATOM   1007  CA  SER   138      66.711  73.746 164.332  1.00 28.52           C  
ATOM   1008  C   SER   138      67.809  74.792 164.434  1.00 28.59           C  
ATOM   1009  O   SER   138      68.573  74.804 165.407  1.00 29.88           O  
ATOM   1010  CB  SER   138      67.151  72.607 163.433  1.00 28.20           C  
ATOM   1011  OG  SER   138      68.342  72.052 163.936  1.00 28.95           O  
ATOM   1012  N   ALA   139      67.902  75.663 163.427  1.00 28.55           N  
ATOM   1013  CA  ALA   139      68.878  76.773 163.429  1.00 27.42           C  
ATOM   1014  C   ALA   139      68.718  77.669 164.665  1.00 27.45           C  
ATOM   1015  O   ALA   139      69.698  78.220 165.183  1.00 26.17           O  
ATOM   1016  CB  ALA   139      68.758  77.587 162.177  1.00 26.12           C  
ATOM   1017  N   ALA   140      67.474  77.793 165.131  1.00 27.58           N  
ATOM   1018  CA  ALA   140      67.130  78.660 166.268  1.00 27.35           C  
ATOM   1019  C   ALA   140      67.930  78.354 167.532  1.00 27.90           C  
ATOM   1020  O   ALA   140      68.181  79.256 168.334  1.00 27.91           O  
ATOM   1021  CB  ALA   140      65.643  78.555 166.571  1.00 27.07           C  
ATOM   1022  N   ILE   141      68.308  77.093 167.724  1.00 28.66           N  
ATOM   1023  CA  ILE   141      68.983  76.683 168.983  1.00 29.50           C  
ATOM   1024  C   ILE   141      70.491  76.907 168.868  1.00 30.14           C  
ATOM   1025  O   ILE   141      71.226  76.822 169.843  1.00 29.75           O  
ATOM   1026  CB  ILE   141      68.650  75.208 169.401  1.00 30.14           C  
ATOM   1027  CG1 ILE   141      69.224  74.219 168.372  1.00 31.29           C  
ATOM   1028  CG2 ILE   141      67.112  75.029 169.636  1.00 28.75           C  
ATOM   1029  CD1 ILE   141      69.251  72.771 168.789  1.00 28.37           C  
ATOM   1030  N   GLU   142      70.943  77.228 167.667  1.00 30.33           N  
ATOM   1031  CA  GLU   142      72.349  77.492 167.469  1.00 31.64           C  
ATOM   1032  C   GLU   142      72.666  78.930 167.094  1.00 31.42           C  
ATOM   1033  O   GLU   142      73.814  79.188 166.788  1.00 31.46           O  
ATOM   1034  CB  GLU   142      72.903  76.621 166.333  1.00 32.65           C  
ATOM   1035  CG  GLU   142      73.004  75.106 166.585  1.00 33.02           C  
ATOM   1036  CD  GLU   142      73.808  74.423 165.486  1.00 32.54           C  
ATOM   1037  OE1 GLU   142      73.225  73.637 164.718  1.00 34.31           O  
ATOM   1038  OE2 GLU   142      75.019  74.714 165.372  1.00 32.66           O  
ATOM   1039  N   MET   143      71.698  79.851 167.041  1.00 30.57           N  
ATOM   1040  CA  MET   143      72.053  81.220 166.592  1.00 30.15           C  
ATOM   1041  C   MET   143      73.014  81.862 167.597  1.00 29.13           C  
ATOM   1042  O   MET   143      72.848  81.679 168.792  1.00 29.60           O  
ATOM   1043  CB  MET   143      70.829  82.120 166.390  1.00 29.98           C  
ATOM   1044  CG  MET   143      70.030  81.815 165.150  1.00 30.12           C  
ATOM   1045  SD  MET   143      71.034  82.276 163.536  0.75 36.60          SE  
ATOM   1046  CE  MET   143      69.785  81.604 162.229  1.00 31.00           C  
ATOM   1047  N   PRO   144      74.041  82.584 167.113  1.00 28.48           N  
ATOM   1048  CA  PRO   144      74.903  83.295 168.067  1.00 27.86           C  
ATOM   1049  C   PRO   144      74.323  84.651 168.412  1.00 27.84           C  
ATOM   1050  O   PRO   144      73.400  85.108 167.740  1.00 27.64           O  
ATOM   1051  CB  PRO   144      76.182  83.497 167.280  1.00 28.14           C  
ATOM   1052  CG  PRO   144      75.703  83.695 165.861  1.00 27.72           C  
ATOM   1053  CD  PRO   144      74.468  82.795 165.720  1.00 27.56           C  
ATOM   1054  N   ARG   145      74.849  85.282 169.458  1.00 27.88           N  
ATOM   1055  CA  ARG   145      74.591  86.699 169.739  1.00 27.88           C  
ATOM   1056  C   ARG   145      73.115  87.075 169.963  1.00 27.79           C  
ATOM   1057  O   ARG   145      72.728  88.233 169.794  1.00 27.11           O  
ATOM   1058  CB  ARG   145      75.254  87.579 168.654  1.00 28.24           C  
ATOM   1059  CG  ARG   145      76.797  87.485 168.691  1.00 27.24           C  
ATOM   1060  CD  ARG   145      77.477  88.351 167.620  1.00 28.22           C  
ATOM   1061  NE  ARG   145      77.182  87.989 166.226  1.00 27.87           N  
ATOM   1062  CZ  ARG   145      76.338  88.643 165.432  1.00 28.14           C  
ATOM   1063  NH1 ARG   145      76.166  88.257 164.175  1.00 30.10           N  
ATOM   1064  NH2 ARG   145      75.660  89.688 165.876  1.00 30.67           N  
ATOM   1065  N   GLY   146      72.312  86.102 170.405  1.00 27.44           N  
ATOM   1066  CA  GLY   146      70.907  86.341 170.705  1.00 26.93           C  
ATOM   1067  C   GLY   146      70.045  86.511 169.457  1.00 26.30           C  
ATOM   1068  O   GLY   146      68.929  87.050 169.522  1.00 26.44           O  
ATOM   1069  N   ILE   147      70.555  86.050 168.325  1.00 25.53           N  
ATOM   1070  CA  ILE   147      69.789  86.110 167.071  1.00 24.86           C  
ATOM   1071  C   ILE   147      68.634  85.097 167.089  1.00 24.78           C  
ATOM   1072  O   ILE   147      68.768  83.999 167.624  1.00 24.13           O  
ATOM   1073  CB  ILE   147      70.702  86.007 165.818  1.00 24.02           C  
ATOM   1074  CG1 ILE   147      71.513  87.294 165.674  1.00 23.86           C  
ATOM   1075  CG2 ILE   147      69.861  85.796 164.550  1.00 24.99           C  
ATOM   1076  CD1 ILE   147      72.889  87.135 164.966  1.00 24.20           C  
ATOM   1077  N   ARG   148      67.488  85.518 166.549  1.00 24.82           N  
ATOM   1078  CA  ARG   148      66.280  84.731 166.467  1.00 25.56           C  
ATOM   1079  C   ARG   148      65.967  84.422 165.005  1.00 26.45           C  
ATOM   1080  O   ARG   148      66.387  85.161 164.091  1.00 26.05           O  
ATOM   1081  CB  ARG   148      65.116  85.532 167.051  1.00 26.11           C  
ATOM   1082  CG  ARG   148      65.262  85.839 168.574  1.00 25.10           C  
ATOM   1083  CD  ARG   148      64.062  86.610 169.080  1.00 25.56           C  
ATOM   1084  NE  ARG   148      63.920  87.885 168.367  1.00 23.44           N  
ATOM   1085  CZ  ARG   148      62.976  88.172 167.463  1.00 24.37           C  
ATOM   1086  NH1 ARG   148      62.022  87.295 167.137  1.00 21.29           N  
ATOM   1087  NH2 ARG   148      62.992  89.364 166.870  1.00 22.75           N  
ATOM   1088  N   ILE   149      65.239  83.335 164.780  1.00 26.28           N  
ATOM   1089  CA  ILE   149      64.811  82.988 163.422  1.00 26.18           C  
ATOM   1090  C   ILE   149      63.420  82.357 163.457  1.00 26.80           C  
ATOM   1091  O   ILE   149      63.188  81.427 164.221  1.00 26.28           O  
ATOM   1092  CB  ILE   149      65.829  82.045 162.706  1.00 26.44           C  
ATOM   1093  CG1 ILE   149      65.273  81.545 161.363  1.00 26.18           C  
ATOM   1094  CG2 ILE   149      66.283  80.834 163.594  1.00 24.22           C  
ATOM   1095  CD1 ILE   149      66.388  81.090 160.447  1.00 27.20           C  
ATOM   1096  N   ASN   150      62.492  82.882 162.655  1.00 26.81           N  
ATOM   1097  CA  ASN   150      61.161  82.300 162.556  1.00 26.44           C  
ATOM   1098  C   ASN   150      60.768  82.167 161.098  1.00 26.61           C  
ATOM   1099  O   ASN   150      61.460  82.660 160.202  1.00 26.32           O  
ATOM   1100  CB  ASN   150      60.107  83.126 163.299  1.00 26.04           C  
ATOM   1101  CG  ASN   150      60.434  83.313 164.789  1.00 26.58           C  
ATOM   1102  OD1 ASN   150      60.370  82.370 165.593  1.00 28.88           O  
ATOM   1103  ND2 ASN   150      60.740  84.551 165.164  1.00 23.47           N  
ATOM   1104  N   THR   151      59.687  81.433 160.862  1.00 26.73           N  
ATOM   1105  CA  THR   151      59.098  81.354 159.536  1.00 26.71           C  
ATOM   1106  C   THR   151      57.626  81.763 159.652  1.00 26.39           C  
ATOM   1107  O   THR   151      57.017  81.672 160.742  1.00 25.33           O  
ATOM   1108  CB  THR   151      59.242  79.948 158.882  1.00 26.38           C  
ATOM   1109  OG1 THR   151      58.574  78.969 159.668  1.00 29.57           O  
ATOM   1110  CG2 THR   151      60.717  79.529 158.731  1.00 26.96           C  
ATOM   1111  N   VAL   152      57.091  82.229 158.528  1.00 25.84           N  
ATOM   1112  CA  VAL   152      55.674  82.582 158.363  1.00 25.85           C  
ATOM   1113  C   VAL   152      55.125  81.721 157.255  1.00 26.18           C  
ATOM   1114  O   VAL   152      55.683  81.683 156.145  1.00 26.66           O  
ATOM   1115  CB  VAL   152      55.499  84.066 157.989  1.00 25.76           C  
ATOM   1116  CG1 VAL   152      54.014  84.436 157.827  1.00 24.94           C  
ATOM   1117  CG2 VAL   152      56.119  84.922 159.061  1.00 26.52           C  
ATOM   1118  N   SER   153      54.032  81.023 157.546  1.00 26.57           N  
ATOM   1119  CA  SER   153      53.426  80.126 156.584  1.00 26.81           C  
ATOM   1120  C   SER   153      52.070  80.679 156.164  1.00 27.47           C  
ATOM   1121  O   SER   153      51.086  80.555 156.910  1.00 28.54           O  
ATOM   1122  CB  SER   153      53.253  78.731 157.186  1.00 26.92           C  
ATOM   1123  OG  SER   153      52.866  77.808 156.183  1.00 27.39           O  
ATOM   1124  N   PRO   154      52.009  81.324 154.984  1.00 27.74           N  
ATOM   1125  CA  PRO   154      50.736  81.842 154.479  1.00 27.92           C  
ATOM   1126  C   PRO   154      49.852  80.820 153.751  1.00 27.65           C  
ATOM   1127  O   PRO   154      50.357  79.934 153.051  1.00 26.86           O  
ATOM   1128  CB  PRO   154      51.168  82.892 153.457  1.00 28.70           C  
ATOM   1129  CG  PRO   154      52.540  82.446 152.990  1.00 28.72           C  
ATOM   1130  CD  PRO   154      53.158  81.650 154.108  1.00 27.17           C  
ATOM   1131  N   ASN   155      48.541  80.972 153.899  1.00 27.35           N  
ATOM   1132  CA  ASN   155      47.584  80.379 152.952  1.00 27.86           C  
ATOM   1133  C   ASN   155      47.739  81.147 151.625  1.00 27.91           C  
ATOM   1134  O   ASN   155      48.511  82.126 151.548  1.00 27.74           O  
ATOM   1135  CB  ASN   155      46.136  80.479 153.488  1.00 27.07           C  
ATOM   1136  CG  ASN   155      45.206  79.361 152.935  1.00 27.68           C  
ATOM   1137  OD1 ASN   155      45.385  78.870 151.824  1.00 28.19           O  
ATOM   1138  ND2 ASN   155      44.228  78.955 153.739  1.00 26.74           N  
ATOM   1139  N   VAL   156      47.038  80.701 150.583  1.00 27.77           N  
ATOM   1140  CA  VAL   156      46.952  81.467 149.337  1.00 28.36           C  
ATOM   1141  C   VAL   156      46.368  82.853 149.706  1.00 28.20           C  
ATOM   1142  O   VAL   156      45.542  82.944 150.629  1.00 27.43           O  
ATOM   1143  CB  VAL   156      46.090  80.698 148.271  1.00 28.36           C  
ATOM   1144  CG1 VAL   156      44.675  80.460 148.761  1.00 28.71           C  
ATOM   1145  CG2 VAL   156      46.055  81.426 146.958  1.00 28.96           C  
ATOM   1146  N   LEU   157      46.859  83.915 149.054  1.00 28.00           N  
ATOM   1147  CA  LEU   157      46.436  85.293 149.343  1.00 27.99           C  
ATOM   1148  C   LEU   157      45.222  85.683 148.531  1.00 28.36           C  
ATOM   1149  O   LEU   157      45.129  85.336 147.349  1.00 28.03           O  
ATOM   1150  CB  LEU   157      47.575  86.315 149.065  1.00 28.06           C  
ATOM   1151  CG  LEU   157      48.947  86.088 149.699  1.00 28.76           C  
ATOM   1152  CD1 LEU   157      49.990  87.111 149.180  1.00 28.28           C  
ATOM   1153  CD2 LEU   157      48.841  86.082 151.234  1.00 25.28           C  
ATOM   1154  N   GLU   158      44.292  86.395 149.173  1.00 28.88           N  
ATOM   1155  CA  GLU   158      43.162  87.051 148.497  1.00 29.77           C  
ATOM   1156  C   GLU   158      43.593  87.826 147.253  1.00 29.98           C  
ATOM   1157  O   GLU   158      42.920  87.802 146.214  1.00 29.81           O  
ATOM   1158  CB  GLU   158      42.459  88.009 149.444  1.00 29.09           C  
ATOM   1159  CG  GLU   158      41.609  87.320 150.501  1.00 31.90           C  
ATOM   1160  CD  GLU   158      40.891  88.296 151.422  1.00 32.37           C  
ATOM   1161  OE1 GLU   158      41.096  89.530 151.280  1.00 34.89           O  
ATOM   1162  OE2 GLU   158      40.110  87.823 152.287  1.00 35.84           O  
ATOM   1163  N   GLU   159      44.722  88.508 147.363  1.00 30.68           N  
ATOM   1164  CA  GLU   159      45.248  89.313 146.267  1.00 31.78           C  
ATOM   1165  C   GLU   159      45.688  88.475 145.058  1.00 32.45           C  
ATOM   1166  O   GLU   159      45.776  88.989 143.951  1.00 33.02           O  
ATOM   1167  CB  GLU   159      46.407  90.201 146.766  1.00 31.26           C  
ATOM   1168  CG  GLU   159      45.959  91.324 147.679  1.00 31.64           C  
ATOM   1169  CD  GLU   159      45.696  90.902 149.145  1.00 32.05           C  
ATOM   1170  OE1 GLU   159      45.914  89.725 149.527  1.00 30.32           O  
ATOM   1171  OE2 GLU   159      45.267  91.784 149.924  1.00 31.99           O  
ATOM   1172  N   SER   160      45.971  87.193 145.273  1.00 33.26           N  
ATOM   1173  CA  SER   160      46.399  86.302 144.208  1.00 34.06           C  
ATOM   1174  C   SER   160      45.300  85.328 143.800  1.00 34.70           C  
ATOM   1175  O   SER   160      45.506  84.512 142.899  1.00 34.77           O  
ATOM   1176  CB  SER   160      47.642  85.525 144.635  1.00 33.78           C  
ATOM   1177  OG  SER   160      48.610  86.394 145.190  1.00 35.39           O  
ATOM   1178  N   TRP   161      44.140  85.426 144.457  1.00 35.05           N  
ATOM   1179  CA  TRP   161      43.020  84.479 144.289  1.00 35.64           C  
ATOM   1180  C   TRP   161      42.526  84.405 142.858  1.00 37.08           C  
ATOM   1181  O   TRP   161      42.155  83.328 142.365  1.00 36.84           O  
ATOM   1182  CB  TRP   161      41.861  84.862 145.207  1.00 34.35           C  
ATOM   1183  CG  TRP   161      40.734  83.857 145.335  1.00 33.76           C  
ATOM   1184  CD1 TRP   161      39.401  84.097 145.132  1.00 32.45           C  
ATOM   1185  CD2 TRP   161      40.835  82.475 145.730  1.00 31.53           C  
ATOM   1186  NE1 TRP   161      38.670  82.950 145.363  1.00 32.32           N  
ATOM   1187  CE2 TRP   161      39.520  81.942 145.734  1.00 32.64           C  
ATOM   1188  CE3 TRP   161      41.904  81.636 146.073  1.00 31.94           C  
ATOM   1189  CZ2 TRP   161      39.245  80.604 146.081  1.00 33.12           C  
ATOM   1190  CZ3 TRP   161      41.631  80.296 146.428  1.00 32.94           C  
ATOM   1191  CH2 TRP   161      40.313  79.795 146.413  1.00 32.40           C  
ATOM   1192  N   ASP   162      42.518  85.549 142.183  1.00 38.75           N  
ATOM   1193  CA  ASP   162      41.972  85.605 140.828  1.00 40.57           C  
ATOM   1194  C   ASP   162      42.903  84.968 139.793  1.00 40.25           C  
ATOM   1195  O   ASP   162      42.520  84.792 138.654  1.00 41.45           O  
ATOM   1196  CB  ASP   162      41.541  87.038 140.440  1.00 41.67           C  
ATOM   1197  CG  ASP   162      40.012  87.251 140.538  1.00 45.20           C  
ATOM   1198  OD1 ASP   162      39.358  86.634 141.427  1.00 48.00           O  
ATOM   1199  OD2 ASP   162      39.457  88.040 139.715  1.00 48.43           O  
ATOM   1200  N   LYS   163      44.119  84.627 140.201  1.00 39.98           N  
ATOM   1201  CA  LYS   163      45.042  83.847 139.373  1.00 39.57           C  
ATOM   1202  C   LYS   163      45.200  82.380 139.851  1.00 37.72           C  
ATOM   1203  O   LYS   163      45.343  81.470 139.037  1.00 37.60           O  
ATOM   1204  CB  LYS   163      46.397  84.563 139.300  1.00 39.50           C  
ATOM   1205  CG  LYS   163      47.585  83.647 139.029  1.00 41.83           C  
ATOM   1206  CD  LYS   163      48.862  84.449 138.837  1.00 42.81           C  
ATOM   1207  CE  LYS   163      49.983  83.943 139.737  1.00 47.93           C  
ATOM   1208  NZ  LYS   163      49.698  84.227 141.188  1.00 50.55           N  
ATOM   1209  N   LEU   164      45.124  82.166 141.165  1.00 35.65           N  
ATOM   1210  CA  LEU   164      45.529  80.910 141.796  1.00 34.47           C  
ATOM   1211  C   LEU   164      44.398  79.973 142.200  1.00 33.80           C  
ATOM   1212  O   LEU   164      44.645  78.821 142.548  1.00 33.95           O  
ATOM   1213  CB  LEU   164      46.411  81.205 143.037  1.00 34.28           C  
ATOM   1214  CG  LEU   164      47.788  81.795 142.746  1.00 33.69           C  
ATOM   1215  CD1 LEU   164      48.581  81.862 144.038  1.00 34.51           C  
ATOM   1216  CD2 LEU   164      48.545  80.963 141.690  1.00 32.19           C  
ATOM   1217  N   GLU   165      43.166  80.472 142.171  1.00 33.60           N  
ATOM   1218  CA  GLU   165      41.977  79.693 142.566  1.00 33.10           C  
ATOM   1219  C   GLU   165      41.940  78.302 141.920  1.00 32.44           C  
ATOM   1220  O   GLU   165      41.680  77.316 142.613  1.00 31.34           O  
ATOM   1221  CB  GLU   165      40.690  80.476 142.261  1.00 33.45           C  
ATOM   1222  CG  GLU   165      39.396  79.811 142.709  1.00 35.66           C  
ATOM   1223  CD  GLU   165      38.824  78.793 141.716  1.00 41.20           C  
ATOM   1224  OE1 GLU   165      38.061  77.908 142.178  1.00 42.85           O  
ATOM   1225  OE2 GLU   165      39.103  78.872 140.486  1.00 41.94           O  
ATOM   1226  N   PRO   166      42.212  78.213 140.598  1.00 31.78           N  
ATOM   1227  CA  PRO   166      42.118  76.905 139.964  1.00 31.86           C  
ATOM   1228  C   PRO   166      43.047  75.854 140.585  1.00 31.31           C  
ATOM   1229  O   PRO   166      42.779  74.680 140.430  1.00 31.11           O  
ATOM   1230  CB  PRO   166      42.540  77.193 138.515  1.00 31.85           C  
ATOM   1231  CG  PRO   166      42.182  78.614 138.300  1.00 31.97           C  
ATOM   1232  CD  PRO   166      42.605  79.235 139.614  1.00 32.37           C  
ATOM   1233  N   PHE   167      44.103  76.283 141.281  1.00 30.34           N  
ATOM   1234  CA  PHE   167      45.022  75.376 141.953  1.00 30.80           C  
ATOM   1235  C   PHE   167      44.562  75.099 143.378  1.00 29.84           C  
ATOM   1236  O   PHE   167      45.033  74.139 143.998  1.00 29.14           O  
ATOM   1237  CB  PHE   167      46.445  75.972 142.042  1.00 31.12           C  
ATOM   1238  CG  PHE   167      47.173  76.042 140.714  1.00 34.05           C  
ATOM   1239  CD1 PHE   167      48.020  75.003 140.310  1.00 35.62           C  
ATOM   1240  CD2 PHE   167      47.028  77.156 139.878  1.00 35.05           C  
ATOM   1241  CE1 PHE   167      48.703  75.048 139.069  1.00 36.61           C  
ATOM   1242  CE2 PHE   167      47.701  77.212 138.620  1.00 37.84           C  
ATOM   1243  CZ  PHE   167      48.543  76.158 138.225  1.00 36.35           C  
ATOM   1244  N   PHE   168      43.668  75.942 143.900  1.00 28.91           N  
ATOM   1245  CA  PHE   168      43.342  75.925 145.345  1.00 28.98           C  
ATOM   1246  C   PHE   168      41.839  75.842 145.566  1.00 28.68           C  
ATOM   1247  O   PHE   168      41.280  76.529 146.425  1.00 29.25           O  
ATOM   1248  CB  PHE   168      43.929  77.151 146.062  1.00 28.60           C  
ATOM   1249  CG  PHE   168      45.426  77.088 146.271  1.00 30.43           C  
ATOM   1250  CD1 PHE   168      45.969  76.533 147.449  1.00 30.16           C  
ATOM   1251  CD2 PHE   168      46.305  77.591 145.301  1.00 29.81           C  
ATOM   1252  CE1 PHE   168      47.389  76.475 147.632  1.00 30.62           C  
ATOM   1253  CE2 PHE   168      47.705  77.535 145.482  1.00 27.69           C  
ATOM   1254  CZ  PHE   168      48.242  76.979 146.646  1.00 29.23           C  
ATOM   1255  N   GLU   169      41.185  74.982 144.797  1.00 28.27           N  
ATOM   1256  CA  GLU   169      39.730  74.900 144.822  1.00 28.70           C  
ATOM   1257  C   GLU   169      39.211  74.522 146.205  1.00 27.93           C  
ATOM   1258  O   GLU   169      39.628  73.503 146.760  1.00 28.49           O  
ATOM   1259  CB  GLU   169      39.223  73.951 143.747  1.00 27.95           C  
ATOM   1260  CG  GLU   169      39.253  74.617 142.390  1.00 30.84           C  
ATOM   1261  CD  GLU   169      39.099  73.651 141.252  1.00 33.19           C  
ATOM   1262  OE1 GLU   169      39.925  72.719 141.171  1.00 34.96           O  
ATOM   1263  OE2 GLU   169      38.167  73.839 140.421  1.00 35.33           O  
ATOM   1264  N   GLY   170      38.336  75.365 146.761  1.00 27.46           N  
ATOM   1265  CA  GLY   170      37.771  75.127 148.088  1.00 26.08           C  
ATOM   1266  C   GLY   170      38.629  75.610 149.253  1.00 26.14           C  
ATOM   1267  O   GLY   170      38.229  75.458 150.421  1.00 26.25           O  
ATOM   1268  N   PHE   171      39.801  76.186 148.973  1.00 26.13           N  
ATOM   1269  CA  PHE   171      40.579  76.853 150.040  1.00 26.26           C  
ATOM   1270  C   PHE   171      39.887  78.187 150.311  1.00 26.70           C  
ATOM   1271  O   PHE   171      39.094  78.661 149.486  1.00 26.33           O  
ATOM   1272  CB  PHE   171      42.021  77.153 149.608  1.00 26.10           C  
ATOM   1273  CG  PHE   171      42.957  75.978 149.674  1.00 26.33           C  
ATOM   1274  CD1 PHE   171      44.059  76.011 150.526  1.00 26.64           C  
ATOM   1275  CD2 PHE   171      42.761  74.855 148.859  1.00 25.07           C  
ATOM   1276  CE1 PHE   171      44.942  74.949 150.583  1.00 25.73           C  
ATOM   1277  CE2 PHE   171      43.623  73.786 148.909  1.00 26.13           C  
ATOM   1278  CZ  PHE   171      44.721  73.823 149.766  1.00 26.48           C  
ATOM   1279  N   LEU   172      40.178  78.779 151.460  1.00 26.77           N  
ATOM   1280  CA  LEU   172      39.725  80.120 151.754  1.00 27.65           C  
ATOM   1281  C   LEU   172      40.930  81.031 151.893  1.00 27.07           C  
ATOM   1282  O   LEU   172      41.660  80.921 152.882  1.00 27.75           O  
ATOM   1283  CB  LEU   172      38.846  80.139 153.013  1.00 27.73           C  
ATOM   1284  CG  LEU   172      38.101  81.435 153.369  1.00 28.21           C  
ATOM   1285  CD1 LEU   172      37.032  81.777 152.389  1.00 31.69           C  
ATOM   1286  CD2 LEU   172      37.516  81.350 154.786  1.00 29.69           C  
ATOM   1287  N   PRO   173      41.143  81.944 150.913  1.00 26.72           N  
ATOM   1288  CA  PRO   173      42.366  82.784 150.930  1.00 26.42           C  
ATOM   1289  C   PRO   173      42.373  83.777 152.091  1.00 26.62           C  
ATOM   1290  O   PRO   173      41.319  84.069 152.660  1.00 26.99           O  
ATOM   1291  CB  PRO   173      42.299  83.546 149.597  1.00 26.22           C  
ATOM   1292  CG  PRO   173      40.850  83.537 149.203  1.00 25.68           C  
ATOM   1293  CD  PRO   173      40.252  82.271 149.775  1.00 26.21           C  
ATOM   1294  N   VAL   174      43.550  84.289 152.428  1.00 27.21           N  
ATOM   1295  CA  VAL   174      43.722  85.240 153.533  1.00 26.74           C  
ATOM   1296  C   VAL   174      44.233  86.544 152.953  1.00 27.30           C  
ATOM   1297  O   VAL   174      44.909  86.530 151.921  1.00 27.96           O  
ATOM   1298  CB  VAL   174      44.727  84.690 154.607  1.00 26.89           C  
ATOM   1299  CG1 VAL   174      44.141  83.403 155.312  1.00 27.71           C  
ATOM   1300  CG2 VAL   174      46.112  84.436 154.007  1.00 25.68           C  
ATOM   1301  N   PRO   175      43.900  87.688 153.586  1.00 27.97           N  
ATOM   1302  CA  PRO   175      44.459  88.933 153.066  1.00 27.37           C  
ATOM   1303  C   PRO   175      45.971  88.991 153.330  1.00 27.29           C  
ATOM   1304  O   PRO   175      46.423  88.590 154.416  1.00 27.52           O  
ATOM   1305  CB  PRO   175      43.718  90.018 153.860  1.00 27.66           C  
ATOM   1306  CG  PRO   175      42.593  89.318 154.603  1.00 27.78           C  
ATOM   1307  CD  PRO   175      43.030  87.904 154.763  1.00 27.90           C  
ATOM   1308  N   ALA   176      46.739  89.475 152.346  1.00 26.80           N  
ATOM   1309  CA  ALA   176      48.171  89.767 152.531  1.00 26.82           C  
ATOM   1310  C   ALA   176      48.460  90.584 153.795  1.00 26.95           C  
ATOM   1311  O   ALA   176      49.473  90.359 154.471  1.00 26.85           O  
ATOM   1312  CB  ALA   176      48.775  90.477 151.262  1.00 26.26           C  
ATOM   1313  N   ALA   177      47.585  91.539 154.112  1.00 27.41           N  
ATOM   1314  CA  ALA   177      47.798  92.396 155.295  1.00 27.90           C  
ATOM   1315  C   ALA   177      47.721  91.605 156.595  1.00 27.75           C  
ATOM   1316  O   ALA   177      48.385  91.951 157.583  1.00 27.36           O  
ATOM   1317  CB  ALA   177      46.809  93.566 155.319  1.00 28.76           C  
ATOM   1318  N   LYS   178      46.915  90.539 156.599  1.00 27.25           N  
ATOM   1319  CA  LYS   178      46.855  89.644 157.758  1.00 27.46           C  
ATOM   1320  C   LYS   178      48.164  88.826 157.915  1.00 25.78           C  
ATOM   1321  O   LYS   178      48.661  88.674 159.017  1.00 24.76           O  
ATOM   1322  CB  LYS   178      45.605  88.765 157.682  1.00 27.38           C  
ATOM   1323  CG  LYS   178      45.332  87.917 158.914  1.00 29.99           C  
ATOM   1324  CD  LYS   178      44.134  86.987 158.637  1.00 30.78           C  
ATOM   1325  CE  LYS   178      43.800  86.094 159.835  1.00 35.73           C  
ATOM   1326  NZ  LYS   178      42.937  84.941 159.393  1.00 38.66           N  
ATOM   1327  N   VAL   179      48.714  88.338 156.800  1.00 25.07           N  
ATOM   1328  CA  VAL   179      49.996  87.630 156.762  1.00 25.31           C  
ATOM   1329  C   VAL   179      51.124  88.551 157.215  1.00 25.93           C  
ATOM   1330  O   VAL   179      51.997  88.134 157.989  1.00 26.07           O  
ATOM   1331  CB  VAL   179      50.308  87.035 155.319  1.00 25.33           C  
ATOM   1332  CG1 VAL   179      51.571  86.189 155.301  1.00 24.52           C  
ATOM   1333  CG2 VAL   179      49.155  86.179 154.846  1.00 25.95           C  
ATOM   1334  N   ALA   180      51.084  89.808 156.745  1.00 25.40           N  
ATOM   1335  CA  ALA   180      52.097  90.817 157.087  1.00 25.14           C  
ATOM   1336  C   ALA   180      52.262  91.000 158.607  1.00 25.03           C  
ATOM   1337  O   ALA   180      53.349  91.328 159.071  1.00 25.04           O  
ATOM   1338  CB  ALA   180      51.751  92.140 156.426  1.00 23.84           C  
ATOM   1339  N   ARG   181      51.180  90.807 159.366  1.00 25.41           N  
ATOM   1340  CA  ARG   181      51.222  90.921 160.838  1.00 26.72           C  
ATOM   1341  C   ARG   181      52.166  89.880 161.453  1.00 26.60           C  
ATOM   1342  O   ARG   181      52.815  90.134 162.479  1.00 27.10           O  
ATOM   1343  CB  ARG   181      49.819  90.737 161.451  1.00 26.71           C  
ATOM   1344  CG  ARG   181      48.830  91.862 161.131  1.00 28.71           C  
ATOM   1345  CD  ARG   181      47.529  91.744 161.945  1.00 28.49           C  
ATOM   1346  NE  ARG   181      46.600  92.813 161.560  1.00 30.42           N  
ATOM   1347  CZ  ARG   181      46.406  93.933 162.253  1.00 33.48           C  
ATOM   1348  NH1 ARG   181      47.047  94.132 163.403  1.00 33.02           N  
ATOM   1349  NH2 ARG   181      45.546  94.851 161.805  1.00 33.70           N  
ATOM   1350  N   ALA   182      52.224  88.704 160.841  1.00 26.25           N  
ATOM   1351  CA  ALA   182      53.003  87.602 161.398  1.00 26.81           C  
ATOM   1352  C   ALA   182      54.493  87.880 161.195  1.00 26.67           C  
ATOM   1353  O   ALA   182      55.305  87.517 162.036  1.00 26.13           O  
ATOM   1354  CB  ALA   182      52.579  86.240 160.795  1.00 25.55           C  
ATOM   1355  N   PHE   183      54.828  88.530 160.079  1.00 26.73           N  
ATOM   1356  CA  PHE   183      56.174  89.066 159.882  1.00 26.74           C  
ATOM   1357  C   PHE   183      56.520  90.105 160.950  1.00 27.20           C  
ATOM   1358  O   PHE   183      57.593  90.024 161.560  1.00 27.83           O  
ATOM   1359  CB  PHE   183      56.323  89.639 158.467  1.00 26.75           C  
ATOM   1360  CG  PHE   183      56.432  88.569 157.377  1.00 26.73           C  
ATOM   1361  CD1 PHE   183      57.674  88.070 156.999  1.00 26.99           C  
ATOM   1362  CD2 PHE   183      55.285  88.045 156.766  1.00 25.26           C  
ATOM   1363  CE1 PHE   183      57.774  87.081 156.001  1.00 29.07           C  
ATOM   1364  CE2 PHE   183      55.373  87.078 155.770  1.00 24.89           C  
ATOM   1365  CZ  PHE   183      56.626  86.588 155.391  1.00 27.08           C  
ATOM   1366  N   GLU   184      55.612  91.048 161.212  1.00 26.75           N  
ATOM   1367  CA  GLU   184      55.826  92.022 162.283  1.00 28.06           C  
ATOM   1368  C   GLU   184      56.041  91.344 163.656  1.00 27.14           C  
ATOM   1369  O   GLU   184      56.925  91.744 164.407  1.00 26.79           O  
ATOM   1370  CB  GLU   184      54.716  93.083 162.325  1.00 26.61           C  
ATOM   1371  CG  GLU   184      55.013  94.210 163.289  1.00 30.67           C  
ATOM   1372  CD  GLU   184      53.800  95.099 163.623  1.00 31.00           C  
ATOM   1373  OE1 GLU   184      52.749  94.980 162.982  1.00 35.43           O  
ATOM   1374  OE2 GLU   184      53.897  95.925 164.553  1.00 33.69           O  
ATOM   1375  N   LYS   185      55.244  90.312 163.956  1.00 27.04           N  
ATOM   1376  CA  LYS   185      55.409  89.476 165.136  1.00 27.01           C  
ATOM   1377  C   LYS   185      56.817  88.874 165.233  1.00 28.06           C  
ATOM   1378  O   LYS   185      57.440  88.873 166.323  1.00 28.16           O  
ATOM   1379  CB  LYS   185      54.402  88.330 165.109  1.00 27.15           C  
ATOM   1380  CG  LYS   185      54.185  87.647 166.456  1.00 27.26           C  
ATOM   1381  CD  LYS   185      53.266  86.469 166.251  1.00 26.34           C  
ATOM   1382  CE  LYS   185      52.707  85.946 167.541  1.00 31.80           C  
ATOM   1383  NZ  LYS   185      53.650  85.548 168.561  1.00 28.33           N  
ATOM   1384  N   SER   186      57.322  88.353 164.112  1.00 26.77           N  
ATOM   1385  CA  SER   186      58.678  87.808 164.126  1.00 27.37           C  
ATOM   1386  C   SER   186      59.719  88.912 164.371  1.00 26.57           C  
ATOM   1387  O   SER   186      60.652  88.730 165.170  1.00 25.36           O  
ATOM   1388  CB  SER   186      58.990  87.029 162.840  1.00 27.27           C  
ATOM   1389  OG  SER   186      60.324  86.537 162.884  1.00 28.67           O  
ATOM   1390  N   VAL   187      59.545  90.065 163.712  1.00 25.81           N  
ATOM   1391  CA  VAL   187      60.538  91.149 163.833  1.00 25.39           C  
ATOM   1392  C   VAL   187      60.571  91.841 165.199  1.00 25.69           C  
ATOM   1393  O   VAL   187      61.661  92.019 165.768  1.00 25.48           O  
ATOM   1394  CB  VAL   187      60.449  92.177 162.658  1.00 25.68           C  
ATOM   1395  CG1 VAL   187      61.470  93.280 162.816  1.00 25.75           C  
ATOM   1396  CG2 VAL   187      60.658  91.454 161.314  1.00 25.10           C  
ATOM   1397  N   PHE   188      59.400  92.208 165.732  1.00 25.07           N  
ATOM   1398  CA  PHE   188      59.310  93.034 166.940  1.00 25.59           C  
ATOM   1399  C   PHE   188      59.056  92.250 168.210  1.00 25.80           C  
ATOM   1400  O   PHE   188      59.178  92.791 169.326  1.00 25.49           O  
ATOM   1401  CB  PHE   188      58.272  94.172 166.757  1.00 25.70           C  
ATOM   1402  CG  PHE   188      58.709  95.190 165.743  1.00 28.12           C  
ATOM   1403  CD1 PHE   188      59.617  96.172 166.087  1.00 29.21           C  
ATOM   1404  CD2 PHE   188      58.312  95.089 164.414  1.00 28.34           C  
ATOM   1405  CE1 PHE   188      60.069  97.098 165.131  1.00 30.52           C  
ATOM   1406  CE2 PHE   188      58.770  96.009 163.443  1.00 27.97           C  
ATOM   1407  CZ  PHE   188      59.644  97.000 163.805  1.00 28.57           C  
ATOM   1408  N   GLY   189      58.702  90.975 168.039  1.00 25.53           N  
ATOM   1409  CA  GLY   189      58.512  90.078 169.169  1.00 25.82           C  
ATOM   1410  C   GLY   189      59.839  89.501 169.620  1.00 25.64           C  
ATOM   1411  O   GLY   189      60.902  89.923 169.143  1.00 26.52           O  
ATOM   1412  N   ALA   190      59.783  88.531 170.528  1.00 25.06           N  
ATOM   1413  CA  ALA   190      60.993  87.938 171.102  1.00 25.22           C  
ATOM   1414  C   ALA   190      61.068  86.398 170.955  1.00 25.59           C  
ATOM   1415  O   ALA   190      61.878  85.735 171.637  1.00 24.73           O  
ATOM   1416  CB  ALA   190      61.127  88.348 172.583  1.00 25.07           C  
ATOM   1417  N   GLN   191      60.239  85.826 170.080  1.00 25.26           N  
ATOM   1418  CA  GLN   191      60.155  84.364 170.004  1.00 26.40           C  
ATOM   1419  C   GLN   191      61.125  83.848 168.963  1.00 26.95           C  
ATOM   1420  O   GLN   191      61.536  84.599 168.073  1.00 28.17           O  
ATOM   1421  CB  GLN   191      58.735  83.895 169.671  1.00 25.78           C  
ATOM   1422  CG  GLN   191      57.707  84.184 170.732  1.00 26.54           C  
ATOM   1423  CD  GLN   191      56.273  83.896 170.300  1.00 27.80           C  
ATOM   1424  OE1 GLN   191      55.995  83.381 169.184  1.00 28.88           O  
ATOM   1425  NE2 GLN   191      55.344  84.259 171.171  1.00 27.31           N  
ATOM   1426  N   THR   192      61.474  82.569 169.049  1.00 26.92           N  
ATOM   1427  CA  THR   192      62.391  81.971 168.086  1.00 26.53           C  
ATOM   1428  C   THR   192      62.063  80.504 167.753  1.00 26.55           C  
ATOM   1429  O   THR   192      61.501  79.774 168.578  1.00 25.66           O  
ATOM   1430  CB  THR   192      63.885  82.150 168.526  1.00 26.29           C  
ATOM   1431  OG1 THR   192      64.751  81.913 167.406  1.00 26.86           O  
ATOM   1432  CG2 THR   192      64.255  81.247 169.691  1.00 25.27           C  
ATOM   1433  N   GLY   193      62.417  80.079 166.545  1.00 25.43           N  
ATOM   1434  CA  GLY   193      62.176  78.706 166.131  1.00 26.08           C  
ATOM   1435  C   GLY   193      60.713  78.389 165.860  1.00 26.87           C  
ATOM   1436  O   GLY   193      60.334  77.209 165.724  1.00 27.01           O  
ATOM   1437  N   GLU   194      59.893  79.432 165.761  1.00 27.25           N  
ATOM   1438  CA  GLU   194      58.459  79.268 165.499  1.00 27.78           C  
ATOM   1439  C   GLU   194      58.100  79.291 164.018  1.00 27.44           C  
ATOM   1440  O   GLU   194      58.802  79.886 163.191  1.00 27.24           O  
ATOM   1441  CB  GLU   194      57.651  80.359 166.190  1.00 28.49           C  
ATOM   1442  CG  GLU   194      57.958  80.530 167.692  1.00 31.75           C  
ATOM   1443  CD  GLU   194      57.503  79.344 168.521  1.00 36.75           C  
ATOM   1444  OE1 GLU   194      56.539  78.665 168.120  1.00 36.63           O  
ATOM   1445  OE2 GLU   194      58.106  79.088 169.581  1.00 41.39           O  
ATOM   1446  N   SER   195      56.963  78.673 163.724  1.00 27.04           N  
ATOM   1447  CA  SER   195      56.339  78.722 162.430  1.00 28.18           C  
ATOM   1448  C   SER   195      54.971  79.407 162.644  1.00 27.83           C  
ATOM   1449  O   SER   195      54.056  78.839 163.249  1.00 26.88           O  
ATOM   1450  CB  SER   195      56.153  77.281 161.917  1.00 28.75           C  
ATOM   1451  OG  SER   195      55.373  77.254 160.725  1.00 29.89           O  
ATOM   1452  N   TYR   196      54.834  80.619 162.138  1.00 26.76           N  
ATOM   1453  CA  TYR   196      53.598  81.359 162.296  1.00 27.55           C  
ATOM   1454  C   TYR   196      52.660  81.063 161.117  1.00 28.47           C  
ATOM   1455  O   TYR   196      52.894  81.537 160.010  1.00 28.15           O  
ATOM   1456  CB  TYR   196      53.934  82.838 162.366  1.00 27.66           C  
ATOM   1457  CG  TYR   196      54.767  83.226 163.571  1.00 27.83           C  
ATOM   1458  CD1 TYR   196      54.441  82.756 164.861  1.00 28.25           C  
ATOM   1459  CD2 TYR   196      55.859  84.075 163.429  1.00 27.61           C  
ATOM   1460  CE1 TYR   196      55.193  83.131 165.976  1.00 26.08           C  
ATOM   1461  CE2 TYR   196      56.631  84.460 164.531  1.00 28.24           C  
ATOM   1462  CZ  TYR   196      56.279  83.989 165.803  1.00 28.36           C  
ATOM   1463  OH  TYR   196      57.026  84.404 166.892  1.00 30.86           O  
ATOM   1464  N   GLN   197      51.629  80.256 161.350  1.00 28.97           N  
ATOM   1465  CA  GLN   197      50.691  79.903 160.300  1.00 30.42           C  
ATOM   1466  C   GLN   197      49.650  80.995 160.186  1.00 30.12           C  
ATOM   1467  O   GLN   197      49.078  81.422 161.207  1.00 29.90           O  
ATOM   1468  CB  GLN   197      49.981  78.571 160.605  1.00 30.06           C  
ATOM   1469  CG  GLN   197      50.909  77.415 160.925  1.00 32.19           C  
ATOM   1470  CD  GLN   197      50.195  76.275 161.692  1.00 35.31           C  
ATOM   1471  OE1 GLN   197      49.368  76.524 162.578  1.00 41.81           O  
ATOM   1472  NE2 GLN   197      50.525  75.026 161.356  1.00 36.84           N  
ATOM   1473  N   VAL   198      49.392  81.450 158.959  1.00 28.33           N  
ATOM   1474  CA  VAL   198      48.281  82.354 158.739  1.00 29.20           C  
ATOM   1475  C   VAL   198      47.370  81.698 157.703  1.00 29.40           C  
ATOM   1476  O   VAL   198      47.506  81.923 156.510  1.00 29.57           O  
ATOM   1477  CB  VAL   198      48.723  83.792 158.307  1.00 29.44           C  
ATOM   1478  CG1 VAL   198      47.512  84.711 158.258  1.00 28.69           C  
ATOM   1479  CG2 VAL   198      49.780  84.385 159.302  1.00 29.55           C  
ATOM   1480  N   TYR   199      46.465  80.860 158.188  1.00 30.45           N  
ATOM   1481  CA  TYR   199      45.725  79.931 157.336  1.00 31.50           C  
ATOM   1482  C   TYR   199      44.236  80.245 157.291  1.00 32.19           C  
ATOM   1483  O   TYR   199      43.690  80.826 158.258  1.00 32.13           O  
ATOM   1484  CB  TYR   199      45.893  78.481 157.823  1.00 31.61           C  
ATOM   1485  CG  TYR   199      47.281  77.875 157.663  1.00 31.88           C  
ATOM   1486  CD1 TYR   199      48.251  78.447 156.810  1.00 29.09           C  
ATOM   1487  CD2 TYR   199      47.603  76.695 158.327  1.00 29.78           C  
ATOM   1488  CE1 TYR   199      49.497  77.860 156.658  1.00 31.97           C  
ATOM   1489  CE2 TYR   199      48.857  76.102 158.183  1.00 30.54           C  
ATOM   1490  CZ  TYR   199      49.801  76.681 157.356  1.00 32.26           C  
ATOM   1491  OH  TYR   199      51.049  76.072 157.238  1.00 33.82           O  
ATOM   1492  OXT TYR   199      43.567  79.870 156.297  1.00 32.08           O  
END
