
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  160 ( 1278),  selected  160 , name 1zkk_A
# Molecule2: number of CA atoms  157 ( 1301),  selected  157 , name T0434_28_195.pdb
# PARAMETERS: 1zkk_A.T0434_28_195.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K   193_A      M      28           -
LGA    S   194_A      T      29           -
LGA    K   195_A      L      30           -
LGA    A   196_A      W      31           -
LGA    E   197_A      T      32           -
LGA    -       -      E      33           -
LGA    -       -      A      34           -
LGA    -       -      E      35           -
LGA    -       -      F      36           -
LGA    L   198_A      E      37           #
LGA    Q   199_A      E      38          3.755
LGA    S   200_A      K      39           -
LGA    E   201_A      -       -           -
LGA    E   202_A      C      40           #
LGA    R   203_A      T      41           -
LGA    K   204_A      Y      42           -
LGA    R   205_A      I      43          4.900
LGA    I   206_A      V      44           #
LGA    D   207_A      -       -           -
LGA    E   208_A      -       -           -
LGA    L   209_A      N      45          2.970
LGA    I   210_A      -       -           -
LGA    E   211_A      -       -           -
LGA    S   212_A      D      46           #
LGA    G   213_A      X      47          5.527
LGA    K   214_A      P      48          5.050
LGA    -       -      W      49           -
LGA    -       -      D      50           -
LGA    -       -      V      59           -
LGA    -       -      Q      60           -
LGA    -       -      A      61           -
LGA    -       -      E      62           -
LGA    -       -      A      63           -
LGA    -       -      S      64           -
LGA    E   215_A      L      65          3.668
LGA    E   216_A      P      66          1.862
LGA    -       -      R      67           -
LGA    G   217_A      N      68          1.042
LGA    M   218_A      L      69          1.144
LGA    K   219_A      L      70          1.502
LGA    I   220_A      F      71          1.243
LGA    D   221_A      K      72          0.877
LGA    L   222_A      Y      73          2.698
LGA    -       -      A      74           -
LGA    I   223_A      T      75           #
LGA    D   224_A      N      76           -
LGA    G   225_A      S      77           -
LGA    K   226_A      E      78           -
LGA    -       -      E      79           -
LGA    G   227_A      V      80           #
LGA    R   228_A      I      81          0.482
LGA    G   229_A      G      82          0.310
LGA    V   230_A      V      83          0.471
LGA    I   231_A      M      84          0.529
LGA    A   232_A      S      85          0.683
LGA    T   233_A      K      86          0.528
LGA    K   234_A      E      87          1.436
LGA    Q   235_A      Y      88          1.242
LGA    F   236_A      I      89          1.101
LGA    S   237_A      P      90          0.959
LGA    R   238_A      K      91          0.966
LGA    G   239_A      G      92          0.859
LGA    D   240_A      T      93          0.570
LGA    F   241_A      R      94          1.126
LGA    V   242_A      F      95          2.654
LGA    V   243_A      G      96          3.357
LGA    E   244_A      P      97          2.805
LGA    Y   245_A      L      98          2.339
LGA    H   246_A      I      99          1.690
LGA    G   247_A      G     100          0.589
LGA    D   248_A      E     101          1.517
LGA    L   249_A      I     102          2.639
LGA    I   250_A      Y     103          2.773
LGA    E   251_A      T     104          2.352
LGA    I   252_A      N     105          2.762
LGA    T   253_A      D     106          2.362
LGA    D   254_A      T     107          2.306
LGA    A   255_A      V     108          3.463
LGA    K   256_A      -       -           -
LGA    K   257_A      -       -           -
LGA    R   258_A      P     109          2.510
LGA    E   259_A      -       -           -
LGA    A   260_A      -       -           -
LGA    L   261_A      -       -           -
LGA    Y   262_A      N     113          3.280
LGA    A   263_A      R     114           -
LGA    Q   264_A      -       -           -
LGA    D   265_A      -       -           -
LGA    P   266_A      -       -           -
LGA    S   267_A      -       -           -
LGA    T   268_A      -       -           -
LGA    G   269_A      -       -           -
LGA    C   270_A      K     115          1.113
LGA    Y   271_A      Y     116          0.622
LGA    M   272_A      F     117          0.760
LGA    Y   273_A      W     118          0.975
LGA    Y   274_A      R     119          1.543
LGA    F   275_A      I     120          3.269
LGA    Q   276_A      Y     121          1.785
LGA    Y   277_A      S     122          2.218
LGA    L   278_A      R     123          2.716
LGA    S   279_A      G     124          3.466
LGA    K   280_A      E     125          3.129
LGA    T   281_A      L     126          1.409
LGA    Y   282_A      X     127          3.579
LGA    -       -      X     128           -
LGA    C   283_A      F     129          1.160
LGA    V   284_A      I     130          0.865
LGA    D   285_A      D     131          0.802
LGA    A   286_A      G     132          0.907
LGA    T   287_A      F     133          1.143
LGA    R   288_A      N     134          0.554
LGA    E   289_A      E     135          1.592
LGA    T   290_A      E     136          3.166
LGA    N   291_A      K     137           -
LGA    -       -      S     138           -
LGA    R   292_A      N     139          1.962
LGA    L   293_A      W     140          1.039
LGA    G   294_A      M     141          0.331
LGA    R   295_A      R     142          0.302
LGA    L   296_A      Y     143          0.492
LGA    I   297_A      V     144          0.400
LGA    N   298_A      N     145          0.362
LGA    H   299_A      P     146          0.857
LGA    S   300_A      A     147          0.927
LGA    -       -      X     148           -
LGA    K   301_A      S     149          3.435
LGA    C   302_A      P     150          2.414
LGA    -       -      R     151           -
LGA    G   303_A      E     152          3.742
LGA    -       -      Q     153           -
LGA    N   304_A      N     154          0.351
LGA    C   305_A      L     155          0.292
LGA    Q   306_A      A     156          0.529
LGA    T   307_A      A     157          0.691
LGA    K   308_A      C     158          1.221
LGA    L   309_A      Q     159          1.128
LGA    H   310_A      N     160          1.894
LGA    D   311_A      G     161          1.683
LGA    I   312_A      -       -           -
LGA    D   313_A      -       -           -
LGA    G   314_A      -       -           -
LGA    V   315_A      -       -           -
LGA    P   316_A      M     162          0.743
LGA    H   317_A      N     163          0.794
LGA    L   318_A      I     164          0.525
LGA    I   319_A      Y     165          0.547
LGA    L   320_A      F     166          0.493
LGA    I   321_A      Y     167          0.624
LGA    A   322_A      T     168          0.458
LGA    S   323_A      I     169          0.834
LGA    R   324_A      K     170          0.635
LGA    D   325_A      P     171          0.584
LGA    I   326_A      I     172          0.719
LGA    A   327_A      P     173          0.900
LGA    A   328_A      A     174          0.856
LGA    G   329_A      N     175          0.333
LGA    E   330_A      Q     176          0.476
LGA    E   331_A      E     177          0.439
LGA    L   332_A      L     178          0.398
LGA    L   333_A      L     179          0.493
LGA    Y   334_A      V     180          0.817
LGA    D   335_A      W     181          1.754
LGA    Y   336_A      Y     182           #
LGA    -       -      C     183           -
LGA    -       -      R     184           -
LGA    -       -      D     185           -
LGA    -       -      F     186           -
LGA    G   337_A      A     187          5.291
LGA    -       -      E     188           -
LGA    -       -      R     189           -
LGA    -       -      L     190           -
LGA    D   338_A      X     191           #
LGA    R   339_A      Y     192          4.748
LGA    S   340_A      -       -           -
LGA    K   341_A      -       -           -
LGA    A   342_A      -       -           -
LGA    S   343_A      -       -           -
LGA    I   344_A      -       -           -
LGA    E   345_A      -       -           -
LGA    A   346_A      -       -           -
LGA    H   347_A      -       -           -
LGA    P   348_A      -       -           -
LGA    W   349_A      -       -           -
LGA    L   350_A      -       -           -
LGA    K   351_A      P     193           #
LGA    H   352_A      Y     194           -
LGA    -       -      P     195           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  160  157    5.0    106    2.05    14.15     58.441     4.927

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.277684 * X  +  -0.957017 * Y  +  -0.083733 * Z  +   6.348358
  Y_new =   0.672101 * X  +  -0.131254 * Y  +  -0.728734 * Z  +   0.396437
  Z_new =   0.686420 * X  +  -0.258634 * Y  +   0.679659 * Z  +  15.101945 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.363615    2.777978  [ DEG:   -20.8336    159.1664 ]
  Theta =  -0.756554   -2.385038  [ DEG:   -43.3474   -136.6526 ]
  Phi   =   1.962594   -1.178999  [ DEG:   112.4483    -67.5517 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zkk_A                                        
REMARK     2: T0434_28_195.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zkk_A.T0434_28_195.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  160  157   5.0  106   2.05   14.15  58.441
REMARK  ---------------------------------------------------------- 
MOLECULE 1zkk_A
HEADER    TRANSFERASE                             03-MAY-05   1ZKK              
TITLE     CRYSTAL STRUCTURE OF HSET8 IN TERNARY COMPLEX WITH H4                 
TITLE    2 PEPTIDE (16-24) AND ADOHCY                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE-LYSINE N-METHYLTRANSFERASE, H4 LYSINE-20           
COMPND   3 SPECIFIC;                                                            
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 FRAGMENT: SEQUENCE DATABASE RESIDUES 231-393;                        
COMPND   6 SYNONYM: HISTONE H4-K20 METHYLTRANSFERASE, H4-K20-HMTASE,            
COMPND   7 SET DOMAIN-CONTAINING PROTEIN 8, PR/SET DOMAIN-CONTAINING            
COMPND   8 PROTEIN 07, PR/SET07, PR-SET7, SET8;                                 
COMPND   9 EC: 2.1.1.43;                                                        
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MOL_ID: 2;                                                           
COMPND  12 MOLECULE: PEPTIDE CORRESPONDING TO RESIDUES 15-24 OF                 
COMPND  13 HISTONE H4;                                                          
COMPND  14 CHAIN: E, F, G, H;                                                   
COMPND  15 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SET8, PRSET7, SET07;                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21-DE3PLYSS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PHIS2;                                    
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 SYNTHETIC: YES;                                                      
SOURCE  12 OTHER_DETAILS: CHAIN E, F, G, H ARE SYNTHETIC PEPTIDE FROM           
SOURCE  13 NEW ENGLAND PEPTIDE CORRESPONDING TO RESIDUE 15-24 OF THE            
SOURCE  14 HISTONE H4                                                           
KEYWDS    PSEUDO-KNOT, HISTONE H4, BETA-SHEET                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.-F.COUTURE,E.COLLAZO,J.S.BRUNZELLE,R.C.TRIEVEL                      
REVDAT   2   05-JUL-05 1ZKK    1       JRNL                                     
REVDAT   1   07-JUN-05 1ZKK    0                                                
JRNL        AUTH   J.-F.COUTURE,E.COLLAZO,J.S.BRUNZELLE,R.C.TRIEVEL             
JRNL        TITL   STRUCTURAL AND FUNCTIONAL ANALYSIS OF SET8, A                
JRNL        TITL 2 HISTONE H4 LYS-20 METHYLTRANSFERASE                          
JRNL        REF    GENES DEV.                    V.  19  1455 2005              
JRNL        REFN   ASTM GEDEEP  US ISSN 0890-9369                               
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  1ZKK A  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
DBREF  1ZKK B  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
DBREF  1ZKK C  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
DBREF  1ZKK D  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
SEQRES   1 A  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 A  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 A  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 A  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 A  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 A  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 A  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 A  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 A  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 A  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 A  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 A  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 A  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 B  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 B  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 B  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 B  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 B  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 B  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 B  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 B  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 B  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 B  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 B  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 B  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 B  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 C  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 C  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 C  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 C  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 C  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 C  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 C  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 C  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 C  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 C  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 C  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 C  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 C  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 D  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 D  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 D  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 D  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 D  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 D  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 D  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 D  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 D  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 D  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 D  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 D  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 D  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 E   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
SEQRES   1 F   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
SEQRES   1 G   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
SEQRES   1 H   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
HET    SAH   2800      26                                                       
HET    SAH   2801      26                                                       
HET    SAH   2802      26                                                       
HET    SAH   2803      26                                                       
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
FORMUL   9  SAH    4(C14 H20 N6 O5 S)                                           
FORMUL  13  HOH   *1007(H2 O)                                                   
CRYST1   43.960   45.775   94.435  89.22  87.07  90.72 P 1           4          
ATOM      1  N   LYS A 193      23.236  30.647  30.846  1.00 21.01           N  
ATOM      2  CA  LYS A 193      21.925  30.086  31.273  1.00 20.74           C  
ATOM      3  C   LYS A 193      22.070  28.634  31.719  1.00 20.91           C  
ATOM      4  O   LYS A 193      22.911  27.896  31.198  1.00 20.80           O  
ATOM      5  CB  LYS A 193      20.903  30.194  30.136  1.00 20.61           C  
ATOM      6  CG  LYS A 193      20.552  31.627  29.752  1.00 20.91           C  
ATOM      7  CD  LYS A 193      19.802  31.684  28.432  1.00 21.70           C  
ATOM      8  CE  LYS A 193      19.396  33.117  28.114  1.00 23.24           C  
ATOM      9  NZ  LYS A 193      18.962  33.256  26.698  1.00 24.58           N  
ATOM     10  N   SER A 194      21.238  28.230  32.675  1.00 21.14           N  
ATOM     11  CA  SER A 194      21.178  26.832  33.119  1.00 21.44           C  
ATOM     12  C   SER A 194      20.481  25.977  32.060  1.00 21.44           C  
ATOM     13  O   SER A 194      19.853  26.516  31.143  1.00 21.01           O  
ATOM     14  CB  SER A 194      20.414  26.736  34.437  1.00 21.61           C  
ATOM     15  OG  SER A 194      19.035  27.005  34.235  1.00 22.03           O  
ATOM     16  N   LYS A 195      20.590  24.654  32.179  1.00 21.48           N  
ATOM     17  CA  LYS A 195      19.871  23.744  31.275  1.00 21.57           C  
ATOM     18  C   LYS A 195      18.363  23.981  31.359  1.00 21.46           C  
ATOM     19  O   LYS A 195      17.687  24.087  30.331  1.00 21.41           O  
ATOM     20  CB  LYS A 195      20.204  22.278  31.585  1.00 21.54           C  
ATOM     21  CG  LYS A 195      19.527  21.273  30.657  1.00 21.94           C  
ATOM     22  CD  LYS A 195      19.929  19.842  31.000  1.00 22.23           C  
ATOM     23  CE  LYS A 195      19.267  18.853  30.053  1.00 23.72           C  
ATOM     24  NZ  LYS A 195      19.854  17.485  30.158  1.00 24.45           N  
ATOM     25  N   ALA A 196      17.855  24.100  32.584  1.00 21.16           N  
ATOM     26  CA  ALA A 196      16.437  24.365  32.826  1.00 20.99           C  
ATOM     27  C   ALA A 196      15.971  25.657  32.155  1.00 20.80           C  
ATOM     28  O   ALA A 196      14.882  25.703  31.576  1.00 20.88           O  
ATOM     29  CB  ALA A 196      16.153  24.404  34.318  1.00 21.09           C  
ATOM     30  N   GLU A 197      16.801  26.697  32.232  1.00 20.48           N  
ATOM     31  CA  GLU A 197      16.489  27.991  31.621  1.00 20.39           C  
ATOM     32  C   GLU A 197      16.436  27.907  30.107  1.00 19.60           C  
ATOM     33  O   GLU A 197      15.528  28.453  29.478  1.00 19.40           O  
ATOM     34  CB  GLU A 197      17.493  29.057  32.055  1.00 20.74           C  
ATOM     35  CG  GLU A 197      17.214  29.600  33.447  1.00 21.27           C  
ATOM     36  CD  GLU A 197      18.296  30.541  33.965  1.00 21.23           C  
ATOM     37  OE1 GLU A 197      18.009  31.288  34.923  1.00 21.88           O  
ATOM     38  OE2 GLU A 197      19.423  30.540  33.428  1.00 21.43           O  
ATOM     39  N   LEU A 198      17.411  27.213  29.527  1.00 18.89           N  
ATOM     40  CA  LEU A 198      17.441  26.992  28.086  1.00 18.30           C  
ATOM     41  C   LEU A 198      16.260  26.133  27.632  1.00 18.30           C  
ATOM     42  O   LEU A 198      15.666  26.406  26.589  1.00 17.68           O  
ATOM     43  CB  LEU A 198      18.775  26.370  27.655  1.00 18.05           C  
ATOM     44  CG  LEU A 198      20.000  27.277  27.831  1.00 17.58           C  
ATOM     45  CD1 LEU A 198      21.263  26.446  27.949  1.00 17.55           C  
ATOM     46  CD2 LEU A 198      20.104  28.299  26.695  1.00 17.03           C  
ATOM     47  N   GLN A 199      15.913  25.114  28.424  1.00 18.47           N  
ATOM     48  CA  GLN A 199      14.735  24.270  28.141  1.00 18.82           C  
ATOM     49  C   GLN A 199      13.415  25.056  28.192  1.00 18.52           C  
ATOM     50  O   GLN A 199      12.550  24.892  27.323  1.00 18.18           O  
ATOM     51  CB  GLN A 199      14.686  23.060  29.083  1.00 19.24           C  
ATOM     52  CG  GLN A 199      15.778  22.029  28.811  1.00 19.59           C  
ATOM     53  CD  GLN A 199      15.773  20.870  29.790  1.00 20.41           C  
ATOM     54  OE1 GLN A 199      15.589  21.051  30.995  1.00 22.80           O  
ATOM     55  NE2 GLN A 199      15.990  19.667  29.272  1.00 22.95           N  
ATOM     56  N   SER A 200      13.269  25.918  29.195  1.00 17.78           N  
ATOM     57  CA  SER A 200      12.072  26.754  29.311  1.00 17.77           C  
ATOM     58  C   SER A 200      11.958  27.725  28.132  1.00 17.25           C  
ATOM     59  O   SER A 200      10.869  27.927  27.588  1.00 17.13           O  
ATOM     60  CB  SER A 200      12.038  27.501  30.653  1.00 18.09           C  
ATOM     61  OG  SER A 200      13.243  28.212  30.873  0.50 19.35           O  
ATOM     63  N   GLU A 201      13.084  28.311  27.725  1.00 16.56           N  
ATOM     64  CA  GLU A 201      13.074  29.242  26.603  1.00 16.12           C  
ATOM     65  C   GLU A 201      12.720  28.521  25.305  1.00 16.22           C  
ATOM     66  O   GLU A 201      11.968  29.056  24.484  1.00 16.21           O  
ATOM     67  CB  GLU A 201      14.400  29.994  26.481  1.00 16.12           C  
ATOM     68  CG  GLU A 201      14.637  30.952  27.648  1.00 15.86           C  
ATOM     69  CD  GLU A 201      15.918  31.766  27.545  1.00 15.90           C  
ATOM     70  OE1 GLU A 201      16.602  31.729  26.500  1.00 15.08           O  
ATOM     71  OE2 GLU A 201      16.230  32.470  28.530  1.00 17.27           O  
ATOM     72  N   GLU A 202      13.249  27.312  25.129  1.00 16.22           N  
ATOM     73  CA  GLU A 202      12.919  26.524  23.945  1.00 16.55           C  
ATOM     74  C   GLU A 202      11.442  26.138  23.947  1.00 16.73           C  
ATOM     75  O   GLU A 202      10.758  26.256  22.924  1.00 16.38           O  
ATOM     76  CB  GLU A 202      13.791  25.277  23.845  1.00 16.63           C  
ATOM     77  CG  GLU A 202      13.682  24.640  22.457  1.00 17.48           C  
ATOM     78  CD  GLU A 202      14.118  23.197  22.416  1.00 19.68           C  
ATOM     79  OE1 GLU A 202      14.223  22.563  23.495  1.00 21.15           O  
ATOM     80  OE2 GLU A 202      14.323  22.694  21.285  1.00 20.32           O  
ATOM     81  N   ARG A 203      10.955  25.680  25.097  1.00 16.92           N  
ATOM     82  CA  ARG A 203       9.541  25.329  25.224  1.00 17.51           C  
ATOM     83  C   ARG A 203       8.651  26.519  24.858  1.00 17.74           C  
ATOM     84  O   ARG A 203       7.651  26.370  24.147  1.00 17.83           O  
ATOM     85  CB  ARG A 203       9.219  24.805  26.630  1.00 17.58           C  
ATOM     86  CG  ARG A 203       7.751  24.461  26.849  1.00 19.27           C  
ATOM     87  CD  ARG A 203       7.553  23.629  28.113  1.00 21.26           C  
ATOM     88  NE  ARG A 203       8.048  22.264  27.938  1.00 23.69           N  
ATOM     89  CZ  ARG A 203       7.360  21.267  27.375  1.00 24.62           C  
ATOM     90  NH1 ARG A 203       6.122  21.454  26.936  1.00 24.43           N  
ATOM     91  NH2 ARG A 203       7.915  20.070  27.260  1.00 26.22           N  
ATOM     92  N   LYS A 204       9.024  27.706  25.332  1.00 17.80           N  
ATOM     93  CA  LYS A 204       8.252  28.904  25.029  1.00 17.99           C  
ATOM     94  C   LYS A 204       8.246  29.251  23.531  1.00 17.26           C  
ATOM     95  O   LYS A 204       7.192  29.606  22.981  1.00 17.82           O  
ATOM     96  CB  LYS A 204       8.731  30.072  25.899  1.00 18.35           C  
ATOM     97  CG  LYS A 204       7.810  31.273  25.925  1.00 20.88           C  
ATOM     98  CD  LYS A 204       8.374  32.389  25.058  1.00 24.31           C  
ATOM     99  CE  LYS A 204       8.272  33.747  25.750  1.00 25.84           C  
ATOM    100  NZ  LYS A 204       6.894  34.028  26.230  1.00 26.31           N  
ATOM    101  N   ARG A 205       9.398  29.145  22.865  1.00 16.44           N  
ATOM    102  CA  ARG A 205       9.452  29.374  21.416  1.00 15.88           C  
ATOM    103  C   ARG A 205       8.552  28.377  20.700  1.00 15.27           C  
ATOM    104  O   ARG A 205       7.799  28.749  19.798  1.00 15.60           O  
ATOM    105  CB  ARG A 205      10.872  29.231  20.840  1.00 15.75           C  
ATOM    106  CG  ARG A 205      11.820  30.378  21.134  1.00 15.87           C  
ATOM    107  CD  ARG A 205      13.109  30.239  20.339  1.00 15.97           C  
ATOM    108  NE  ARG A 205      13.858  29.031  20.683  1.00 16.10           N  
ATOM    109  CZ  ARG A 205      14.759  28.944  21.663  1.00 15.75           C  
ATOM    110  NH1 ARG A 205      15.035  29.994  22.434  1.00 15.69           N  
ATOM    111  NH2 ARG A 205      15.389  27.796  21.874  1.00 15.66           N  
ATOM    112  N   ILE A 206       8.647  27.114  21.110  1.00 14.48           N  
ATOM    113  CA  ILE A 206       7.887  26.045  20.475  1.00 13.75           C  
ATOM    114  C   ILE A 206       6.389  26.229  20.692  1.00 14.43           C  
ATOM    115  O   ILE A 206       5.608  26.138  19.748  1.00 14.96           O  
ATOM    116  CB  ILE A 206       8.342  24.651  20.948  1.00 13.39           C  
ATOM    117  CG1 ILE A 206       9.745  24.324  20.413  1.00 13.36           C  
ATOM    118  CG2 ILE A 206       7.358  23.581  20.455  1.00 13.08           C  
ATOM    119  CD1 ILE A 206      10.355  23.052  20.998  1.00 13.59           C  
ATOM    120  N   ASP A 207       5.987  26.520  21.927  1.00 14.81           N  
ATOM    121  CA  ASP A 207       4.577  26.795  22.202  1.00 15.44           C  
ATOM    122  C   ASP A 207       4.032  27.940  21.344  1.00 15.24           C  
ATOM    123  O   ASP A 207       2.920  27.841  20.805  1.00 15.43           O  
ATOM    124  CB  ASP A 207       4.377  27.122  23.678  1.00 15.51           C  
ATOM    125  CG  ASP A 207       4.554  25.911  24.595  1.00 17.29           C  
ATOM    126  OD1 ASP A 207       4.910  24.804  24.108  1.00 20.16           O  
ATOM    127  OD2 ASP A 207       4.332  26.073  25.823  1.00 19.41           O  
ATOM    128  N   GLU A 208       4.799  29.032  21.218  1.00 15.44           N  
ATOM    129  CA  GLU A 208       4.371  30.165  20.388  1.00 16.50           C  
ATOM    130  C   GLU A 208       4.166  29.756  18.933  1.00 15.33           C  
ATOM    131  O   GLU A 208       3.225  30.215  18.280  1.00 15.21           O  
ATOM    132  CB  GLU A 208       5.374  31.324  20.427  1.00 17.12           C  
ATOM    133  CG  GLU A 208       5.398  32.128  21.701  1.00 19.00           C  
ATOM    134  CD  GLU A 208       6.671  32.971  21.845  1.00 19.57           C  
ATOM    135  OE1 GLU A 208       6.686  33.837  22.732  1.00 23.13           O  
ATOM    136  OE2 GLU A 208       7.658  32.752  21.090  1.00 22.94           O  
ATOM    137  N   LEU A 209       5.059  28.913  18.412  1.00 14.48           N  
ATOM    138  CA  LEU A 209       4.978  28.508  17.015  1.00 14.23           C  
ATOM    139  C   LEU A 209       3.826  27.540  16.800  1.00 14.00           C  
ATOM    140  O   LEU A 209       3.140  27.601  15.776  1.00 13.67           O  
ATOM    141  CB  LEU A 209       6.309  27.913  16.552  1.00 14.46           C  
ATOM    142  CG  LEU A 209       7.354  28.993  16.245  1.00 15.18           C  
ATOM    143  CD1 LEU A 209       8.766  28.431  16.368  1.00 14.93           C  
ATOM    144  CD2 LEU A 209       7.124  29.593  14.866  1.00 17.21           C  
ATOM    145  N   ILE A 210       3.598  26.658  17.767  1.00 13.35           N  
ATOM    146  CA  ILE A 210       2.428  25.781  17.703  1.00 13.89           C  
ATOM    147  C   ILE A 210       1.128  26.614  17.698  1.00 14.27           C  
ATOM    148  O   ILE A 210       0.194  26.342  16.928  1.00 14.31           O  
ATOM    149  CB  ILE A 210       2.461  24.719  18.833  1.00 13.30           C  
ATOM    150  CG1 ILE A 210       3.547  23.667  18.546  1.00 12.93           C  
ATOM    151  CG2 ILE A 210       1.086  24.059  19.030  1.00 14.60           C  
ATOM    152  CD1 ILE A 210       3.789  22.728  19.705  1.00 13.71           C  
ATOM    153  N   GLU A 211       1.093  27.651  18.536  1.00 14.89           N  
ATOM    154  CA  GLU A 211      -0.063  28.555  18.608  1.00 16.09           C  
ATOM    155  C   GLU A 211      -0.330  29.282  17.298  1.00 15.97           C  
ATOM    156  O   GLU A 211      -1.462  29.271  16.787  1.00 16.80           O  
ATOM    157  CB  GLU A 211       0.118  29.579  19.739  1.00 16.24           C  
ATOM    158  CG  GLU A 211      -0.876  30.753  19.710  1.00 18.09           C  
ATOM    159  CD  GLU A 211      -2.239  30.403  20.263  1.00 21.79           C  
ATOM    160  OE1 GLU A 211      -2.948  31.342  20.674  1.00 19.25           O  
ATOM    161  OE2 GLU A 211      -2.608  29.206  20.304  1.00 23.17           O  
ATOM    162  N   SER A 212       0.699  29.940  16.765  1.00 15.80           N  
ATOM    163  CA  SER A 212       0.558  30.763  15.573  1.00 16.45           C  
ATOM    164  C   SER A 212       0.319  29.942  14.310  1.00 16.40           C  
ATOM    165  O   SER A 212      -0.283  30.428  13.352  1.00 16.79           O  
ATOM    166  CB  SER A 212       1.791  31.652  15.381  1.00 16.29           C  
ATOM    167  OG  SER A 212       2.921  30.864  15.047  1.00 16.29           O  
ATOM    168  N   GLY A 213       0.808  28.704  14.311  1.00 16.46           N  
ATOM    169  CA  GLY A 213       0.775  27.858  13.117  1.00 16.38           C  
ATOM    170  C   GLY A 213       1.597  28.446  11.984  1.00 16.62           C  
ATOM    171  O   GLY A 213       1.403  28.099  10.821  1.00 16.44           O  
ATOM    172  N   LYS A 214       2.525  29.336  12.333  1.00 17.11           N  
ATOM    173  CA  LYS A 214       3.359  30.001  11.354  1.00 17.62           C  
ATOM    174  C   LYS A 214       4.336  28.988  10.762  1.00 16.95           C  
ATOM    175  O   LYS A 214       4.999  28.250  11.493  1.00 17.02           O  
ATOM    176  CB  LYS A 214       4.119  31.151  12.003  1.00 18.75           C  
ATOM    177  CG  LYS A 214       4.441  32.263  11.050  1.00 22.02           C  
ATOM    178  CD  LYS A 214       4.585  33.593  11.779  1.00 24.93           C  
ATOM    179  CE  LYS A 214       5.867  33.625  12.598  1.00 27.23           C  
ATOM    180  NZ  LYS A 214       5.951  34.845  13.445  1.00 28.52           N  
ATOM    181  N   GLU A 215       4.389  28.947   9.437  1.00 16.58           N  
ATOM    182  CA  GLU A 215       5.183  27.959   8.710  1.00 16.47           C  
ATOM    183  C   GLU A 215       6.099  28.653   7.709  1.00 16.87           C  
ATOM    184  O   GLU A 215       6.031  28.424   6.499  1.00 18.18           O  
ATOM    185  CB  GLU A 215       4.262  26.924   8.059  1.00 16.35           C  
ATOM    186  CG  GLU A 215       3.458  26.179   9.114  1.00 14.44           C  
ATOM    187  CD  GLU A 215       2.680  24.988   8.615  1.00 13.85           C  
ATOM    188  OE1 GLU A 215       2.492  24.833   7.382  1.00 13.73           O  
ATOM    189  OE2 GLU A 215       2.248  24.208   9.498  1.00 12.43           O  
ATOM    190  N   GLU A 216       6.978  29.497   8.241  1.00 16.98           N  
ATOM    191  CA  GLU A 216       7.846  30.325   7.421  1.00 17.90           C  
ATOM    192  C   GLU A 216       9.086  29.564   6.991  1.00 16.43           C  
ATOM    193  O   GLU A 216       9.491  28.590   7.640  1.00 17.19           O  
ATOM    194  CB  GLU A 216       8.239  31.598   8.174  1.00 17.98           C  
ATOM    195  CG  GLU A 216       7.022  32.467   8.497  1.00 20.37           C  
ATOM    196  CD  GLU A 216       7.346  33.860   9.024  1.00 21.33           C  
ATOM    197  OE1 GLU A 216       8.529  34.165   9.306  1.00 26.63           O  
ATOM    198  OE2 GLU A 216       6.392  34.653   9.153  1.00 25.99           O  
ATOM    199  N   GLY A 217       9.678  30.019   5.892  1.00 15.55           N  
ATOM    200  CA  GLY A 217      10.950  29.466   5.420  1.00 14.16           C  
ATOM    201  C   GLY A 217      10.826  28.161   4.651  1.00 13.63           C  
ATOM    202  O   GLY A 217      11.801  27.445   4.506  1.00 13.40           O  
ATOM    203  N   MET A 218       9.625  27.873   4.150  1.00 13.28           N  
ATOM    204  CA  MET A 218       9.319  26.634   3.444  1.00 13.77           C  
ATOM    205  C   MET A 218       8.408  26.916   2.265  1.00 12.43           C  
ATOM    206  O   MET A 218       7.595  27.840   2.315  1.00 13.10           O  
ATOM    207  CB  MET A 218       8.561  25.680   4.380  1.00 14.63           C  
ATOM    208  CG  MET A 218       9.347  25.091   5.515  1.00 15.85           C  
ATOM    209  SD  MET A 218       8.178  24.194   6.551  1.00 17.63           S  
ATOM    210  CE  MET A 218       7.578  25.522   7.558  1.00 18.52           C  
ATOM    211  N   LYS A 219       8.513  26.095   1.227  1.00 11.21           N  
ATOM    212  CA  LYS A 219       7.529  26.113   0.152  1.00 11.26           C  
ATOM    213  C   LYS A 219       7.361  24.714  -0.440  1.00 10.35           C  
ATOM    214  O   LYS A 219       8.218  23.836  -0.270  1.00 10.90           O  
ATOM    215  CB  LYS A 219       7.929  27.118  -0.927  1.00 11.53           C  
ATOM    216  CG  LYS A 219       9.071  26.662  -1.782  1.00 12.84           C  
ATOM    217  CD  LYS A 219       9.409  27.726  -2.794  1.00 15.77           C  
ATOM    218  CE  LYS A 219      10.620  27.337  -3.589  1.00 18.96           C  
ATOM    219  NZ  LYS A 219      11.043  28.438  -4.526  1.00 22.00           N  
ATOM    220  N   ILE A 220       6.241  24.507  -1.113  1.00 10.41           N  
ATOM    221  CA  ILE A 220       5.966  23.255  -1.798  1.00 10.81           C  
ATOM    222  C   ILE A 220       6.638  23.263  -3.162  1.00 11.56           C  
ATOM    223  O   ILE A 220       6.653  24.288  -3.859  1.00 13.43           O  
ATOM    224  CB  ILE A 220       4.441  23.068  -1.991  1.00 10.86           C  
ATOM    225  CG1 ILE A 220       3.724  23.110  -0.643  1.00 11.76           C  
ATOM    226  CG2 ILE A 220       4.136  21.772  -2.729  1.00 12.91           C  
ATOM    227  CD1 ILE A 220       2.220  23.198  -0.779  1.00 13.46           C  
ATOM    228  N   ASP A 221       7.200  22.116  -3.533  1.00 12.34           N  
ATOM    229  CA  ASP A 221       7.799  21.923  -4.857  1.00 13.25           C  
ATOM    230  C   ASP A 221       7.445  20.519  -5.305  1.00 12.74           C  
ATOM    231  O   ASP A 221       7.141  19.661  -4.475  1.00 13.03           O  
ATOM    232  CB  ASP A 221       9.337  22.082  -4.784  1.00 14.63           C  
ATOM    233  CG  ASP A 221       9.981  22.418  -6.131  1.00 17.19           C  
ATOM    234  OD1 ASP A 221       9.256  22.630  -7.132  1.00 20.14           O  
ATOM    235  OD2 ASP A 221      11.238  22.466  -6.179  1.00 18.54           O  
ATOM    236  N   LEU A 222       7.461  20.272  -6.611  1.00 12.07           N  
ATOM    237  CA  LEU A 222       7.337  18.904  -7.093  1.00 11.69           C  
ATOM    238  C   LEU A 222       8.720  18.271  -7.076  1.00 10.95           C  
ATOM    239  O   LEU A 222       9.684  18.831  -7.604  1.00 11.30           O  
ATOM    240  CB  LEU A 222       6.729  18.866  -8.506  1.00 12.45           C  
ATOM    241  CG  LEU A 222       5.250  19.276  -8.631  1.00 14.34           C  
ATOM    242  CD1 LEU A 222       4.828  19.192 -10.101  1.00 16.50           C  
ATOM    243  CD2 LEU A 222       4.352  18.412  -7.742  1.00 15.97           C  
ATOM    244  N   ILE A 223       8.821  17.122  -6.417  1.00  9.74           N  
ATOM    245  CA  ILE A 223      10.092  16.410  -6.319  1.00  9.55           C  
ATOM    246  C   ILE A 223       9.978  15.113  -7.111  1.00  9.07           C  
ATOM    247  O   ILE A 223       9.058  14.325  -6.876  1.00  8.86           O  
ATOM    248  CB  ILE A 223      10.476  16.134  -4.844  1.00  9.97           C  
ATOM    249  CG1 ILE A 223      10.590  17.451  -4.052  1.00 11.58           C  
ATOM    250  CG2 ILE A 223      11.778  15.322  -4.763  1.00 10.35           C  
ATOM    251  CD1 ILE A 223      11.798  18.313  -4.390  1.00 14.42           C  
ATOM    252  N   ASP A 224      10.914  14.906  -8.039  1.00  8.73           N  
ATOM    253  CA  ASP A 224      10.886  13.771  -8.968  1.00  8.19           C  
ATOM    254  C   ASP A 224      10.688  12.467  -8.203  1.00  8.83           C  
ATOM    255  O   ASP A 224      11.499  12.118  -7.329  1.00  9.92           O  
ATOM    256  CB  ASP A 224      12.205  13.749  -9.771  1.00  8.65           C  
ATOM    257  CG  ASP A 224      12.195  12.791 -10.937  1.00  8.42           C  
ATOM    258  OD1 ASP A 224      11.118  12.303 -11.317  1.00  9.61           O  
ATOM    259  OD2 ASP A 224      13.291  12.562 -11.505  1.00 11.33           O  
ATOM    260  N   GLY A 225       9.597  11.763  -8.517  1.00  8.69           N  
ATOM    261  CA  GLY A 225       9.340  10.455  -7.928  1.00  9.64           C  
ATOM    262  C   GLY A 225       8.657  10.454  -6.572  1.00  9.96           C  
ATOM    263  O   GLY A 225       8.400   9.386  -6.009  1.00 11.87           O  
ATOM    264  N   LYS A 226       8.347  11.634  -6.040  1.00  9.35           N  
ATOM    265  CA  LYS A 226       7.774  11.723  -4.691  1.00  9.61           C  
ATOM    266  C   LYS A 226       6.443  12.440  -4.617  1.00 10.00           C  
ATOM    267  O   LYS A 226       5.832  12.466  -3.559  1.00 11.13           O  
ATOM    268  CB  LYS A 226       8.756  12.397  -3.719  1.00  9.45           C  
ATOM    269  CG  LYS A 226      10.136  11.780  -3.699  1.00 10.20           C  
ATOM    270  CD  LYS A 226      10.970  12.353  -2.560  1.00 10.15           C  
ATOM    271  CE  LYS A 226      12.449  12.067  -2.804  1.00  9.57           C  
ATOM    272  NZ  LYS A 226      13.322  12.746  -1.794  1.00  9.50           N  
ATOM    273  N   GLY A 227       5.984  13.013  -5.721  1.00  9.31           N  
ATOM    274  CA  GLY A 227       4.820  13.893  -5.660  1.00  9.66           C  
ATOM    275  C   GLY A 227       5.235  15.278  -5.190  1.00  9.37           C  
ATOM    276  O   GLY A 227       6.239  15.826  -5.662  1.00 10.15           O  
ATOM    277  N   ARG A 228       4.471  15.864  -4.275  1.00  8.85           N  
ATOM    278  CA  ARG A 228       4.888  17.114  -3.657  1.00  9.39           C  
ATOM    279  C   ARG A 228       5.891  16.824  -2.566  1.00  9.21           C  
ATOM    280  O   ARG A 228       5.839  15.775  -1.905  1.00  9.92           O  
ATOM    281  CB  ARG A 228       3.705  17.842  -3.012  1.00  9.34           C  
ATOM    282  CG  ARG A 228       2.615  18.232  -3.995  1.00  9.50           C  
ATOM    283  CD  ARG A 228       1.332  18.591  -3.256  1.00 10.17           C  
ATOM    284  NE  ARG A 228       0.719  17.442  -2.593  1.00  9.41           N  
ATOM    285  CZ  ARG A 228      -0.466  17.485  -1.972  1.00 10.46           C  
ATOM    286  NH1 ARG A 228      -1.152  18.627  -1.912  1.00 12.25           N  
ATOM    287  NH2 ARG A 228      -0.963  16.394  -1.397  1.00 11.77           N  
ATOM    288  N   GLY A 229       6.793  17.778  -2.368  1.00  9.33           N  
ATOM    289  CA  GLY A 229       7.605  17.842  -1.161  1.00  9.29           C  
ATOM    290  C   GLY A 229       7.688  19.268  -0.673  1.00  9.34           C  
ATOM    291  O   GLY A 229       7.138  20.178  -1.293  1.00  9.56           O  
ATOM    292  N   VAL A 230       8.376  19.459   0.446  1.00  8.99           N  
ATOM    293  CA  VAL A 230       8.538  20.782   1.024  1.00  9.77           C  
ATOM    294  C   VAL A 230      10.013  21.097   1.045  1.00  9.91           C  
ATOM    295  O   VAL A 230      10.810  20.280   1.528  1.00 10.01           O  
ATOM    296  CB  VAL A 230       7.943  20.868   2.449  1.00  9.75           C  
ATOM    297  CG1 VAL A 230       8.025  22.296   2.990  1.00 11.48           C  
ATOM    298  CG2 VAL A 230       6.483  20.391   2.442  1.00 10.76           C  
ATOM    299  N   ILE A 231      10.370  22.272   0.527  1.00 10.41           N  
ATOM    300  CA  ILE A 231      11.769  22.663   0.478  1.00 10.88           C  
ATOM    301  C   ILE A 231      12.011  23.909   1.309  1.00 10.22           C  
ATOM    302  O   ILE A 231      11.130  24.747   1.453  1.00 10.29           O  
ATOM    303  CB  ILE A 231      12.309  22.801  -0.978  1.00 12.12           C  
ATOM    304  CG1 ILE A 231      11.818  24.080  -1.621  1.00 13.97           C  
ATOM    305  CG2 ILE A 231      11.959  21.543  -1.833  1.00 13.93           C  
ATOM    306  CD1 ILE A 231      12.445  24.325  -2.975  1.00 14.72           C  
ATOM    307  N   ALA A 232      13.197  23.984   1.898  1.00  9.83           N  
ATOM    308  CA  ALA A 232      13.576  25.143   2.669  1.00 10.14           C  
ATOM    309  C   ALA A 232      13.780  26.336   1.731  1.00 10.55           C  
ATOM    310  O   ALA A 232      14.357  26.193   0.643  1.00 10.16           O  
ATOM    311  CB  ALA A 232      14.841  24.852   3.443  1.00  9.91           C  
ATOM    312  N   THR A 233      13.297  27.503   2.138  1.00 10.70           N  
ATOM    313  CA  THR A 233      13.571  28.734   1.384  1.00 11.63           C  
ATOM    314  C   THR A 233      14.529  29.653   2.142  1.00 11.94           C  
ATOM    315  O   THR A 233      14.870  30.741   1.678  1.00 12.85           O  
ATOM    316  CB  THR A 233      12.280  29.508   1.070  1.00 12.15           C  
ATOM    317  OG1 THR A 233      11.673  29.897   2.305  1.00 13.99           O  
ATOM    318  CG2 THR A 233      11.311  28.634   0.269  1.00 13.52           C  
ATOM    319  N   LYS A 234      14.927  29.212   3.325  1.00 11.92           N  
ATOM    320  CA  LYS A 234      15.941  29.885   4.131  1.00 12.18           C  
ATOM    321  C   LYS A 234      16.750  28.775   4.768  1.00 11.58           C  
ATOM    322  O   LYS A 234      16.319  27.608   4.777  1.00 11.51           O  
ATOM    323  CB  LYS A 234      15.296  30.757   5.226  1.00 12.38           C  
ATOM    324  CG  LYS A 234      14.588  29.946   6.284  1.00 14.73           C  
ATOM    325  CD  LYS A 234      14.076  30.793   7.434  1.00 16.58           C  
ATOM    326  CE  LYS A 234      13.394  29.919   8.478  1.00 19.69           C  
ATOM    327  NZ  LYS A 234      12.888  30.713   9.638  1.00 22.98           N  
ATOM    328  N   GLN A 235      17.902  29.124   5.329  1.00 10.70           N  
ATOM    329  CA  GLN A 235      18.654  28.149   6.107  1.00 10.38           C  
ATOM    330  C   GLN A 235      17.997  27.943   7.469  1.00 10.88           C  
ATOM    331  O   GLN A 235      17.579  28.913   8.124  1.00 12.19           O  
ATOM    332  CB  GLN A 235      20.113  28.593   6.270  1.00 10.52           C  
ATOM    333  CG  GLN A 235      20.987  27.551   6.964  1.00 10.71           C  
ATOM    334  CD  GLN A 235      22.443  27.704   6.631  1.00 10.53           C  
ATOM    335  OE1 GLN A 235      22.807  27.950   5.471  1.00 11.84           O  
ATOM    336  NE2 GLN A 235      23.292  27.554   7.637  1.00  9.96           N  
ATOM    337  N   PHE A 236      17.873  26.684   7.872  1.00 10.50           N  
ATOM    338  CA  PHE A 236      17.486  26.341   9.244  1.00 10.25           C  
ATOM    339  C   PHE A 236      18.718  25.866   9.979  1.00 10.51           C  
ATOM    340  O   PHE A 236      19.578  25.207   9.398  1.00 10.19           O  
ATOM    341  CB  PHE A 236      16.439  25.217   9.282  1.00 10.46           C  
ATOM    342  CG  PHE A 236      15.075  25.635   8.816  1.00 10.40           C  
ATOM    343  CD1 PHE A 236      14.086  25.898   9.743  1.00 11.58           C  
ATOM    344  CD2 PHE A 236      14.769  25.724   7.460  1.00 12.49           C  
ATOM    345  CE1 PHE A 236      12.799  26.275   9.335  1.00 12.91           C  
ATOM    346  CE2 PHE A 236      13.500  26.102   7.040  1.00 13.17           C  
ATOM    347  CZ  PHE A 236      12.513  26.377   7.977  1.00 13.21           C  
ATOM    348  N   SER A 237      18.793  26.170  11.268  1.00 10.29           N  
ATOM    349  CA  SER A 237      19.909  25.695  12.084  1.00 10.21           C  
ATOM    350  C   SER A 237      19.540  24.431  12.839  1.00 10.26           C  
ATOM    351  O   SER A 237      18.394  24.246  13.227  1.00  9.72           O  
ATOM    352  CB  SER A 237      20.361  26.770  13.077  1.00 10.57           C  
ATOM    353  OG  SER A 237      20.876  27.897  12.396  1.00 11.88           O  
ATOM    354  N   ARG A 238      20.519  23.558  13.052  1.00 10.03           N  
ATOM    355  CA  ARG A 238      20.313  22.382  13.886  1.00 10.80           C  
ATOM    356  C   ARG A 238      19.589  22.775  15.179  1.00 10.13           C  
ATOM    357  O   ARG A 238      20.006  23.712  15.886  1.00  9.63           O  
ATOM    358  CB  ARG A 238      21.663  21.735  14.225  1.00 11.17           C  
ATOM    359  CG  ARG A 238      21.526  20.465  15.027  1.00 12.09           C  
ATOM    360  CD  ARG A 238      22.868  19.757  15.297  1.00 14.97           C  
ATOM    361  NE  ARG A 238      22.633  18.643  16.218  1.00 23.50           N  
ATOM    362  CZ  ARG A 238      23.507  17.694  16.531  1.00 26.66           C  
ATOM    363  NH1 ARG A 238      24.719  17.678  15.990  1.00 28.35           N  
ATOM    364  NH2 ARG A 238      23.156  16.743  17.385  1.00 28.05           N  
ATOM    365  N   GLY A 239      18.519  22.044  15.480  1.00  9.31           N  
ATOM    366  CA  GLY A 239      17.751  22.264  16.703  1.00  9.78           C  
ATOM    367  C   GLY A 239      16.532  23.139  16.533  1.00 10.53           C  
ATOM    368  O   GLY A 239      15.681  23.180  17.423  1.00 10.90           O  
ATOM    369  N   ASP A 240      16.442  23.844  15.403  1.00 10.29           N  
ATOM    370  CA  ASP A 240      15.308  24.757  15.175  1.00 10.41           C  
ATOM    371  C   ASP A 240      14.004  24.000  15.031  1.00 10.30           C  
ATOM    372  O   ASP A 240      13.962  22.931  14.421  1.00 11.02           O  
ATOM    373  CB  ASP A 240      15.500  25.534  13.874  1.00 11.41           C  
ATOM    374  CG  ASP A 240      16.503  26.654  13.970  1.00 11.61           C  
ATOM    375  OD1 ASP A 240      16.763  27.258  12.905  1.00 12.05           O  
ATOM    376  OD2 ASP A 240      17.011  26.958  15.071  1.00 12.85           O  
ATOM    377  N   PHE A 241      12.922  24.585  15.541  1.00 10.70           N  
ATOM    378  CA  PHE A 241      11.583  24.159  15.157  1.00 10.47           C  
ATOM    379  C   PHE A 241      11.422  24.371  13.658  1.00 10.96           C  
ATOM    380  O   PHE A 241      11.764  25.440  13.139  1.00 11.59           O  
ATOM    381  CB  PHE A 241      10.555  25.025  15.899  1.00 10.72           C  
ATOM    382  CG  PHE A 241       9.115  24.719  15.556  1.00 11.59           C  
ATOM    383  CD1 PHE A 241       8.372  23.846  16.341  1.00 12.28           C  
ATOM    384  CD2 PHE A 241       8.494  25.335  14.475  1.00 11.48           C  
ATOM    385  CE1 PHE A 241       7.038  23.577  16.032  1.00 13.01           C  
ATOM    386  CE2 PHE A 241       7.149  25.085  14.177  1.00 11.96           C  
ATOM    387  CZ  PHE A 241       6.431  24.197  14.950  1.00 12.10           C  
ATOM    388  N   VAL A 242      10.882  23.364  12.974  1.00 10.47           N  
ATOM    389  CA  VAL A 242      10.626  23.471  11.538  1.00 10.62           C  
ATOM    390  C   VAL A 242       9.123  23.602  11.298  1.00 10.02           C  
ATOM    391  O   VAL A 242       8.669  24.615  10.764  1.00 10.44           O  
ATOM    392  CB  VAL A 242      11.222  22.258  10.781  1.00 10.85           C  
ATOM    393  CG1 VAL A 242      10.857  22.292   9.295  1.00 11.60           C  
ATOM    394  CG2 VAL A 242      12.746  22.258  10.925  1.00 11.26           C  
ATOM    395  N   VAL A 243       8.348  22.608  11.729  1.00 10.35           N  
ATOM    396  CA  VAL A 243       6.908  22.616  11.484  1.00 10.90           C  
ATOM    397  C   VAL A 243       6.222  21.642  12.442  1.00 10.88           C  
ATOM    398  O   VAL A 243       6.864  20.710  12.929  1.00 11.21           O  
ATOM    399  CB  VAL A 243       6.626  22.248   9.985  1.00 11.70           C  
ATOM    400  CG1 VAL A 243       6.839  20.780   9.735  1.00 12.06           C  
ATOM    401  CG2 VAL A 243       5.248  22.681   9.538  1.00 13.80           C  
ATOM    402  N   GLU A 244       4.940  21.864  12.729  1.00 10.70           N  
ATOM    403  CA  GLU A 244       4.131  20.845  13.415  1.00 10.67           C  
ATOM    404  C   GLU A 244       3.599  19.866  12.367  1.00 10.37           C  
ATOM    405  O   GLU A 244       3.280  20.280  11.249  1.00 11.10           O  
ATOM    406  CB  GLU A 244       2.947  21.486  14.163  1.00 10.69           C  
ATOM    407  CG  GLU A 244       2.057  20.443  14.872  1.00 11.26           C  
ATOM    408  CD  GLU A 244       1.024  20.996  15.833  1.00 11.47           C  
ATOM    409  OE1 GLU A 244       0.831  22.227  15.894  1.00 13.41           O  
ATOM    410  OE2 GLU A 244       0.398  20.167  16.522  1.00 12.06           O  
ATOM    411  N   TYR A 245       3.513  18.579  12.721  1.00 10.74           N  
ATOM    412  CA  TYR A 245       2.774  17.635  11.890  1.00 10.27           C  
ATOM    413  C   TYR A 245       1.327  17.830  12.323  1.00 10.64           C  
ATOM    414  O   TYR A 245       0.902  17.289  13.353  1.00 11.58           O  
ATOM    415  CB  TYR A 245       3.226  16.170  12.055  1.00 10.59           C  
ATOM    416  CG  TYR A 245       2.623  15.311  10.966  1.00  8.73           C  
ATOM    417  CD1 TYR A 245       3.291  15.119   9.773  1.00  9.44           C  
ATOM    418  CD2 TYR A 245       1.349  14.740  11.111  1.00 10.28           C  
ATOM    419  CE1 TYR A 245       2.718  14.357   8.753  1.00  9.82           C  
ATOM    420  CE2 TYR A 245       0.769  13.978  10.095  1.00  9.32           C  
ATOM    421  CZ  TYR A 245       1.462  13.804   8.911  1.00  9.66           C  
ATOM    422  OH  TYR A 245       0.906  13.055   7.891  1.00  9.96           O  
ATOM    423  N   HIS A 246       0.594  18.634  11.547  1.00 10.66           N  
ATOM    424  CA  HIS A 246      -0.707  19.139  11.963  1.00 11.20           C  
ATOM    425  C   HIS A 246      -1.824  18.471  11.178  1.00 11.42           C  
ATOM    426  O   HIS A 246      -1.738  18.336   9.955  1.00 11.68           O  
ATOM    427  CB  HIS A 246      -0.766  20.653  11.784  1.00 11.42           C  
ATOM    428  CG  HIS A 246      -1.938  21.280  12.468  1.00 12.18           C  
ATOM    429  ND1 HIS A 246      -3.167  21.426  11.858  1.00 13.40           N  
ATOM    430  CD2 HIS A 246      -2.072  21.778  13.720  1.00 13.11           C  
ATOM    431  CE1 HIS A 246      -4.008  21.990  12.710  1.00 13.76           C  
ATOM    432  NE2 HIS A 246      -3.369  22.215  13.846  1.00 14.59           N  
ATOM    433  N   GLY A 247      -2.862  18.050  11.895  1.00 12.00           N  
ATOM    434  CA  GLY A 247      -4.010  17.364  11.308  1.00 12.68           C  
ATOM    435  C   GLY A 247      -5.042  17.109  12.396  1.00 13.54           C  
ATOM    436  O   GLY A 247      -5.084  17.837  13.394  1.00 14.43           O  
ATOM    437  N   ASP A 248      -5.852  16.069  12.204  1.00 13.91           N  
ATOM    438  CA  ASP A 248      -6.887  15.680  13.167  1.00 14.97           C  
ATOM    439  C   ASP A 248      -6.281  14.768  14.225  1.00 14.48           C  
ATOM    440  O   ASP A 248      -5.880  13.655  13.905  1.00 15.14           O  
ATOM    441  CB  ASP A 248      -8.002  14.899  12.468  1.00 16.01           C  
ATOM    442  CG  ASP A 248      -8.801  15.722  11.494  1.00 19.12           C  
ATOM    443  OD1 ASP A 248      -8.796  16.974  11.569  1.00 23.23           O  
ATOM    444  OD2 ASP A 248      -9.464  15.087  10.645  1.00 22.51           O  
ATOM    445  N   LEU A 249      -6.220  15.222  15.473  1.00 14.19           N  
ATOM    446  CA  LEU A 249      -5.738  14.352  16.551  1.00 13.82           C  
ATOM    447  C   LEU A 249      -6.850  13.421  16.998  1.00 13.91           C  
ATOM    448  O   LEU A 249      -7.897  13.876  17.471  1.00 13.88           O  
ATOM    449  CB  LEU A 249      -5.194  15.160  17.733  1.00 13.78           C  
ATOM    450  CG  LEU A 249      -4.716  14.344  18.950  1.00 13.66           C  
ATOM    451  CD1 LEU A 249      -3.486  13.510  18.586  1.00 14.74           C  
ATOM    452  CD2 LEU A 249      -4.457  15.244  20.146  1.00 14.90           C  
ATOM    453  N   ILE A 250      -6.604  12.122  16.850  1.00 13.74           N  
ATOM    454  CA  ILE A 250      -7.595  11.094  17.171  1.00 13.44           C  
ATOM    455  C   ILE A 250      -7.000   9.951  17.983  1.00 13.01           C  
ATOM    456  O   ILE A 250      -5.778   9.772  18.021  1.00 13.31           O  
ATOM    457  CB  ILE A 250      -8.282  10.541  15.887  1.00 13.25           C  
ATOM    458  CG1 ILE A 250      -7.277   9.823  14.975  1.00 13.66           C  
ATOM    459  CG2 ILE A 250      -8.991  11.670  15.116  1.00 13.84           C  
ATOM    460  CD1 ILE A 250      -7.889   9.334  13.668  1.00 13.80           C  
ATOM    461  N   GLU A 251      -7.870   9.192  18.642  1.00 12.89           N  
ATOM    462  CA  GLU A 251      -7.454   7.998  19.374  1.00 13.50           C  
ATOM    463  C   GLU A 251      -7.613   6.740  18.519  1.00 12.90           C  
ATOM    464  O   GLU A 251      -7.989   6.820  17.346  1.00 12.65           O  
ATOM    465  CB  GLU A 251      -8.230   7.876  20.696  1.00 13.91           C  
ATOM    466  CG  GLU A 251      -9.764   7.989  20.615  1.00 17.38           C  
ATOM    467  CD  GLU A 251     -10.452   6.759  20.009  1.00 19.93           C  
ATOM    468  OE1 GLU A 251     -11.088   6.914  18.943  1.00 20.03           O  
ATOM    469  OE2 GLU A 251     -10.368   5.652  20.605  1.00 21.22           O  
ATOM    470  N   ILE A 252      -7.345   5.574  19.115  1.00 12.89           N  
ATOM    471  CA  ILE A 252      -7.147   4.364  18.308  1.00 13.48           C  
ATOM    472  C   ILE A 252      -8.400   3.810  17.621  1.00 13.45           C  
ATOM    473  O   ILE A 252      -8.328   3.314  16.494  1.00 13.08           O  
ATOM    474  CB  ILE A 252      -6.429   3.244  19.110  1.00 13.68           C  
ATOM    475  CG1 ILE A 252      -5.943   2.147  18.154  1.00 14.43           C  
ATOM    476  CG2 ILE A 252      -7.325   2.701  20.216  1.00 13.75           C  
ATOM    477  CD1 ILE A 252      -5.108   1.065  18.800  1.00 14.00           C  
ATOM    478  N   THR A 253      -9.541   3.887  18.298  1.00 13.58           N  
ATOM    479  CA  THR A 253     -10.762   3.360  17.720  1.00 14.42           C  
ATOM    480  C   THR A 253     -11.116   4.113  16.433  1.00 14.29           C  
ATOM    481  O   THR A 253     -11.405   3.498  15.400  1.00 14.31           O  
ATOM    482  CB  THR A 253     -11.920   3.410  18.726  1.00 14.30           C  
ATOM    483  OG1 THR A 253     -11.537   2.686  19.905  1.00 15.49           O  
ATOM    484  CG2 THR A 253     -13.169   2.791  18.129  1.00 16.24           C  
ATOM    485  N   ASP A 254     -11.061   5.439  16.495  1.00 14.66           N  
ATOM    486  CA  ASP A 254     -11.325   6.256  15.320  1.00 15.48           C  
ATOM    487  C   ASP A 254     -10.226   6.073  14.266  1.00 15.47           C  
ATOM    488  O   ASP A 254     -10.505   6.044  13.072  1.00 15.40           O  
ATOM    489  CB  ASP A 254     -11.468   7.725  15.711  1.00 16.02           C  
ATOM    490  CG  ASP A 254     -12.149   8.561  14.631  1.00 19.83           C  
ATOM    491  OD1 ASP A 254     -12.817   7.988  13.735  1.00 22.98           O  
ATOM    492  OD2 ASP A 254     -12.027   9.803  14.693  1.00 22.18           O  
ATOM    493  N   ALA A 255      -8.978   5.937  14.702  1.00 15.44           N  
ATOM    494  CA  ALA A 255      -7.886   5.733  13.742  1.00 15.61           C  
ATOM    495  C   ALA A 255      -8.071   4.440  12.945  1.00 16.28           C  
ATOM    496  O   ALA A 255      -7.899   4.425  11.734  1.00 16.22           O  
ATOM    497  CB  ALA A 255      -6.524   5.766  14.439  1.00 15.62           C  
ATOM    498  N   LYS A 256      -8.465   3.367  13.630  1.00 16.92           N  
ATOM    499  CA  LYS A 256      -8.693   2.086  12.965  1.00 18.15           C  
ATOM    500  C   LYS A 256      -9.903   2.147  12.037  1.00 18.57           C  
ATOM    501  O   LYS A 256      -9.872   1.592  10.938  1.00 19.00           O  
ATOM    502  CB  LYS A 256      -8.892   0.971  13.983  1.00 18.18           C  
ATOM    503  CG  LYS A 256      -7.641   0.514  14.695  1.00 19.81           C  
ATOM    504  CD  LYS A 256      -7.899  -0.869  15.254  1.00 21.30           C  
ATOM    505  CE  LYS A 256      -7.015  -1.160  16.420  1.00 21.48           C  
ATOM    506  NZ  LYS A 256      -7.265  -2.523  16.936  1.00 21.54           N  
ATOM    507  N   LYS A 257     -10.959   2.823  12.490  1.00 19.37           N  
ATOM    508  CA  LYS A 257     -12.150   3.041  11.676  1.00 20.27           C  
ATOM    509  C   LYS A 257     -11.773   3.735  10.366  1.00 20.26           C  
ATOM    510  O   LYS A 257     -12.133   3.266   9.281  1.00 20.09           O  
ATOM    511  CB  LYS A 257     -13.185   3.852  12.467  1.00 20.58           C  
ATOM    512  CG  LYS A 257     -14.478   4.152  11.729  1.00 21.82           C  
ATOM    513  CD  LYS A 257     -15.545   4.619  12.704  1.00 23.94           C  
ATOM    514  CE  LYS A 257     -16.853   4.951  12.005  1.00 26.21           C  
ATOM    515  NZ  LYS A 257     -16.837   6.306  11.386  1.00 26.77           N  
ATOM    516  N   ARG A 258     -11.012   4.827  10.479  1.00 20.46           N  
ATOM    517  CA  ARG A 258     -10.577   5.613   9.323  1.00 21.12           C  
ATOM    518  C   ARG A 258      -9.634   4.835   8.400  1.00 21.48           C  
ATOM    519  O   ARG A 258      -9.777   4.898   7.182  1.00 21.80           O  
ATOM    520  CB  ARG A 258      -9.937   6.929   9.774  1.00 21.07           C  
ATOM    521  CG  ARG A 258     -10.896   7.885  10.482  1.00 20.58           C  
ATOM    522  CD  ARG A 258     -10.241   9.230  10.722  1.00 20.54           C  
ATOM    523  NE  ARG A 258     -11.066  10.125  11.533  1.00 20.09           N  
ATOM    524  CZ  ARG A 258     -10.854  11.433  11.658  1.00 20.30           C  
ATOM    525  NH1 ARG A 258      -9.842  12.015  11.016  1.00 19.92           N  
ATOM    526  NH2 ARG A 258     -11.658  12.162  12.417  1.00 20.85           N  
ATOM    527  N   GLU A 259      -8.684   4.096   8.977  1.00 22.33           N  
ATOM    528  CA  GLU A 259      -7.799   3.223   8.190  1.00 23.57           C  
ATOM    529  C   GLU A 259      -8.591   2.295   7.287  1.00 23.93           C  
ATOM    530  O   GLU A 259      -8.313   2.198   6.092  1.00 24.17           O  
ATOM    531  CB  GLU A 259      -6.883   2.385   9.084  1.00 24.03           C  
ATOM    532  CG  GLU A 259      -5.665   3.139   9.575  1.00 25.18           C  
ATOM    533  CD  GLU A 259      -4.428   2.270   9.792  1.00 26.70           C  
ATOM    534  OE1 GLU A 259      -4.536   1.025   9.908  1.00 27.03           O  
ATOM    535  OE2 GLU A 259      -3.327   2.858   9.850  1.00 27.96           O  
ATOM    536  N   ALA A 260      -9.581   1.623   7.872  1.00 24.36           N  
ATOM    537  CA  ALA A 260     -10.389   0.650   7.148  1.00 24.77           C  
ATOM    538  C   ALA A 260     -11.131   1.301   5.977  1.00 24.91           C  
ATOM    539  O   ALA A 260     -11.289   0.686   4.919  1.00 25.40           O  
ATOM    540  CB  ALA A 260     -11.355  -0.056   8.094  1.00 24.69           C  
ATOM    541  N   LEU A 261     -11.556   2.550   6.167  1.00 24.86           N  
ATOM    542  CA  LEU A 261     -12.232   3.317   5.123  1.00 24.86           C  
ATOM    543  C   LEU A 261     -11.262   3.808   4.050  1.00 24.93           C  
ATOM    544  O   LEU A 261     -11.556   3.729   2.852  1.00 25.21           O  
ATOM    545  CB  LEU A 261     -12.994   4.504   5.723  1.00 25.11           C  
ATOM    546  CG  LEU A 261     -14.215   4.197   6.598  1.00 25.43           C  
ATOM    547  CD1 LEU A 261     -14.657   5.457   7.320  1.00 25.18           C  
ATOM    548  CD2 LEU A 261     -15.366   3.601   5.784  1.00 25.79           C  
ATOM    549  N   TYR A 262     -10.108   4.312   4.480  1.00 24.59           N  
ATOM    550  CA  TYR A 262      -9.090   4.782   3.545  1.00 24.60           C  
ATOM    551  C   TYR A 262      -8.588   3.653   2.640  1.00 25.27           C  
ATOM    552  O   TYR A 262      -8.374   3.858   1.442  1.00 25.44           O  
ATOM    553  CB  TYR A 262      -7.913   5.423   4.292  1.00 23.78           C  
ATOM    554  CG  TYR A 262      -8.233   6.696   5.061  1.00 22.91           C  
ATOM    555  CD1 TYR A 262      -9.283   7.538   4.678  1.00 22.35           C  
ATOM    556  CD2 TYR A 262      -7.466   7.070   6.161  1.00 21.16           C  
ATOM    557  CE1 TYR A 262      -9.563   8.706   5.378  1.00 22.21           C  
ATOM    558  CE2 TYR A 262      -7.738   8.239   6.871  1.00 21.37           C  
ATOM    559  CZ  TYR A 262      -8.784   9.051   6.477  1.00 22.32           C  
ATOM    560  OH  TYR A 262      -9.055  10.209   7.172  1.00 22.14           O  
ATOM    561  N   ALA A 263      -8.426   2.464   3.222  1.00 26.19           N  
ATOM    562  CA  ALA A 263      -7.950   1.272   2.509  1.00 27.16           C  
ATOM    563  C   ALA A 263      -8.833   0.872   1.321  1.00 28.00           C  
ATOM    564  O   ALA A 263      -8.358   0.222   0.383  1.00 28.21           O  
ATOM    565  CB  ALA A 263      -7.799   0.106   3.474  1.00 27.20           C  
ATOM    566  N   GLN A 264     -10.106   1.271   1.370  1.00 28.71           N  
ATOM    567  CA  GLN A 264     -11.085   0.967   0.322  1.00 29.60           C  
ATOM    568  C   GLN A 264     -11.004   1.933  -0.859  1.00 30.09           C  
ATOM    569  O   GLN A 264     -11.595   1.688  -1.915  1.00 30.21           O  
ATOM    570  CB  GLN A 264     -12.506   0.967   0.899  1.00 29.55           C  
ATOM    571  CG  GLN A 264     -12.724  -0.047   2.013  1.00 30.10           C  
ATOM    572  CD  GLN A 264     -14.111   0.038   2.621  1.00 30.11           C  
ATOM    573  OE1 GLN A 264     -15.064  -0.554   2.111  1.00 31.76           O  
ATOM    574  NE2 GLN A 264     -14.229   0.763   3.726  1.00 30.09           N  
ATOM    575  N   ASP A 265     -10.267   3.027  -0.680  1.00 30.66           N  
ATOM    576  CA  ASP A 265     -10.098   4.031  -1.728  1.00 31.29           C  
ATOM    577  C   ASP A 265      -8.612   4.234  -2.051  1.00 31.46           C  
ATOM    578  O   ASP A 265      -7.891   4.869  -1.277  1.00 31.44           O  
ATOM    579  CB  ASP A 265     -10.763   5.350  -1.318  1.00 31.55           C  
ATOM    580  CG  ASP A 265     -10.679   6.423  -2.402  1.00 32.37           C  
ATOM    581  OD1 ASP A 265     -10.137   6.157  -3.498  1.00 33.90           O  
ATOM    582  OD2 ASP A 265     -11.167   7.544  -2.155  1.00 33.53           O  
ATOM    583  N   PRO A 266      -8.157   3.701  -3.206  1.00 31.67           N  
ATOM    584  CA  PRO A 266      -6.741   3.729  -3.609  1.00 31.62           C  
ATOM    585  C   PRO A 266      -6.225   5.133  -3.921  1.00 31.19           C  
ATOM    586  O   PRO A 266      -5.009   5.351  -3.948  1.00 31.31           O  
ATOM    587  CB  PRO A 266      -6.722   2.869  -4.878  1.00 31.74           C  
ATOM    588  CG  PRO A 266      -8.110   2.979  -5.427  1.00 31.86           C  
ATOM    589  CD  PRO A 266      -9.000   3.038  -4.220  1.00 31.81           C  
ATOM    590  N   SER A 267      -7.143   6.066  -4.162  1.00 30.79           N  
ATOM    591  CA  SER A 267      -6.791   7.455  -4.457  1.00 30.13           C  
ATOM    592  C   SER A 267      -6.388   8.222  -3.199  1.00 29.12           C  
ATOM    593  O   SER A 267      -5.759   9.281  -3.284  1.00 29.60           O  
ATOM    594  CB  SER A 267      -7.955   8.167  -5.152  1.00 30.40           C  
ATOM    595  OG  SER A 267      -9.011   8.432  -4.242  1.00 31.49           O  
ATOM    596  N   THR A 268      -6.766   7.689  -2.040  1.00 27.67           N  
ATOM    597  CA  THR A 268      -6.451   8.299  -0.755  1.00 26.03           C  
ATOM    598  C   THR A 268      -5.002   7.994  -0.395  1.00 24.47           C  
ATOM    599  O   THR A 268      -4.557   6.840  -0.454  1.00 24.68           O  
ATOM    600  CB  THR A 268      -7.388   7.788   0.361  1.00 26.25           C  
ATOM    601  OG1 THR A 268      -8.755   7.971  -0.036  1.00 27.06           O  
ATOM    602  CG2 THR A 268      -7.141   8.533   1.664  1.00 26.06           C  
ATOM    603  N   GLY A 269      -4.271   9.039  -0.032  1.00 22.47           N  
ATOM    604  CA  GLY A 269      -2.864   8.899   0.333  1.00 19.62           C  
ATOM    605  C   GLY A 269      -2.662   8.472   1.774  1.00 18.04           C  
ATOM    606  O   GLY A 269      -3.632   8.187   2.495  1.00 17.75           O  
ATOM    607  N   CYS A 270      -1.396   8.435   2.188  1.00 15.84           N  
ATOM    608  CA  CYS A 270      -1.025   7.982   3.528  1.00 14.73           C  
ATOM    609  C   CYS A 270      -0.466   9.121   4.377  1.00 14.47           C  
ATOM    610  O   CYS A 270       0.685   9.538   4.203  1.00 13.96           O  
ATOM    611  CB  CYS A 270      -0.026   6.835   3.432  1.00 14.50           C  
ATOM    612  SG  CYS A 270      -0.660   5.385   2.556  1.00 14.94           S  
ATOM    613  N   TYR A 271      -1.303   9.618   5.288  1.00 13.93           N  
ATOM    614  CA  TYR A 271      -1.010  10.821   6.077  1.00 13.85           C  
ATOM    615  C   TYR A 271      -1.240  10.608   7.571  1.00 13.57           C  
ATOM    616  O   TYR A 271      -1.264  11.570   8.347  1.00 13.58           O  
ATOM    617  CB  TYR A 271      -1.873  11.992   5.600  1.00 14.04           C  
ATOM    618  CG  TYR A 271      -1.674  12.359   4.152  1.00 13.31           C  
ATOM    619  CD1 TYR A 271      -0.668  13.245   3.777  1.00 12.76           C  
ATOM    620  CD2 TYR A 271      -2.495  11.827   3.153  1.00 13.86           C  
ATOM    621  CE1 TYR A 271      -0.468  13.583   2.428  1.00 13.56           C  
ATOM    622  CE2 TYR A 271      -2.318  12.181   1.804  1.00 13.11           C  
ATOM    623  CZ  TYR A 271      -1.295  13.040   1.447  1.00 13.92           C  
ATOM    624  OH  TYR A 271      -1.118  13.351   0.118  1.00 14.56           O  
ATOM    625  N   MET A 272      -1.396   9.352   7.976  1.00 13.94           N  
ATOM    626  CA  MET A 272      -1.734   9.037   9.361  1.00 13.97           C  
ATOM    627  C   MET A 272      -0.461   8.819  10.152  1.00 13.04           C  
ATOM    628  O   MET A 272       0.341   7.937   9.813  1.00 14.17           O  
ATOM    629  CB  MET A 272      -2.624   7.795   9.432  1.00 13.30           C  
ATOM    630  CG  MET A 272      -3.917   7.964   8.680  1.00 14.36           C  
ATOM    631  SD  MET A 272      -5.079   6.603   8.925  1.00 16.44           S  
ATOM    632  CE  MET A 272      -5.843   7.045  10.499  1.00 14.44           C  
ATOM    633  N   TYR A 273      -0.272   9.628  11.197  1.00 11.75           N  
ATOM    634  CA  TYR A 273       0.967   9.584  11.979  1.00 11.30           C  
ATOM    635  C   TYR A 273       0.674   9.108  13.405  1.00 11.41           C  
ATOM    636  O   TYR A 273       0.113   9.856  14.212  1.00 11.56           O  
ATOM    637  CB  TYR A 273       1.611  10.977  12.014  1.00 10.83           C  
ATOM    638  CG  TYR A 273       3.127  11.005  12.157  1.00 10.59           C  
ATOM    639  CD1 TYR A 273       3.815  10.094  12.960  1.00 10.31           C  
ATOM    640  CD2 TYR A 273       3.868  11.978  11.503  1.00 10.30           C  
ATOM    641  CE1 TYR A 273       5.212  10.142  13.075  1.00 10.22           C  
ATOM    642  CE2 TYR A 273       5.237  12.064  11.621  1.00 10.37           C  
ATOM    643  CZ  TYR A 273       5.918  11.137  12.396  1.00  9.72           C  
ATOM    644  OH  TYR A 273       7.298  11.207  12.498  1.00 11.34           O  
ATOM    645  N   TYR A 274       1.094   7.881  13.704  1.00 10.94           N  
ATOM    646  CA  TYR A 274       0.799   7.202  14.990  1.00 11.47           C  
ATOM    647  C   TYR A 274       1.888   7.437  16.020  1.00 11.92           C  
ATOM    648  O   TYR A 274       3.074   7.513  15.677  1.00 12.11           O  
ATOM    649  CB  TYR A 274       0.671   5.685  14.784  1.00 11.83           C  
ATOM    650  CG  TYR A 274      -0.566   5.299  14.034  1.00 12.66           C  
ATOM    651  CD1 TYR A 274      -1.742   4.963  14.720  1.00 12.80           C  
ATOM    652  CD2 TYR A 274      -0.587   5.305  12.638  1.00 13.40           C  
ATOM    653  CE1 TYR A 274      -2.891   4.627  14.039  1.00 14.11           C  
ATOM    654  CE2 TYR A 274      -1.745   4.972  11.944  1.00 13.62           C  
ATOM    655  CZ  TYR A 274      -2.888   4.629  12.657  1.00 14.35           C  
ATOM    656  OH  TYR A 274      -4.024   4.296  11.974  1.00 17.02           O  
ATOM    657  N   PHE A 275       1.498   7.513  17.291  1.00 12.02           N  
ATOM    658  CA  PHE A 275       2.471   7.683  18.362  1.00 12.16           C  
ATOM    659  C   PHE A 275       1.849   7.241  19.677  1.00 13.04           C  
ATOM    660  O   PHE A 275       0.639   7.083  19.758  1.00 12.90           O  
ATOM    661  CB  PHE A 275       2.952   9.145  18.447  1.00 12.70           C  
ATOM    662  CG  PHE A 275       1.876  10.138  18.824  1.00 11.57           C  
ATOM    663  CD1 PHE A 275       1.764  10.605  20.132  1.00 12.26           C  
ATOM    664  CD2 PHE A 275       1.001  10.646  17.854  1.00 11.69           C  
ATOM    665  CE1 PHE A 275       0.778  11.536  20.481  1.00 12.63           C  
ATOM    666  CE2 PHE A 275       0.018  11.589  18.195  1.00 12.18           C  
ATOM    667  CZ  PHE A 275      -0.085  12.034  19.512  1.00 12.27           C  
ATOM    668  N   GLN A 276       2.702   7.032  20.680  1.00 13.70           N  
ATOM    669  CA  GLN A 276       2.279   6.635  22.023  1.00 14.88           C  
ATOM    670  C   GLN A 276       2.290   7.839  22.940  1.00 15.14           C  
ATOM    671  O   GLN A 276       3.262   8.595  22.968  1.00 15.54           O  
ATOM    672  CB  GLN A 276       3.269   5.623  22.598  1.00 15.23           C  
ATOM    673  CG  GLN A 276       3.070   4.156  22.239  1.00 18.62           C  
ATOM    674  CD  GLN A 276       2.440   3.903  20.899  1.00 20.84           C  
ATOM    675  OE1 GLN A 276       1.392   3.253  20.800  1.00 25.91           O  
ATOM    676  NE2 GLN A 276       3.051   4.446  19.852  1.00 16.97           N  
ATOM    677  N   TYR A 277       1.234   7.985  23.736  1.00 15.02           N  
ATOM    678  CA  TYR A 277       1.158   9.071  24.692  1.00 15.72           C  
ATOM    679  C   TYR A 277       0.323   8.598  25.861  1.00 15.45           C  
ATOM    680  O   TYR A 277      -0.789   8.106  25.674  1.00 14.56           O  
ATOM    681  CB  TYR A 277       0.562  10.322  24.043  1.00 16.36           C  
ATOM    682  CG  TYR A 277       0.411  11.517  24.962  1.00 16.41           C  
ATOM    683  CD1 TYR A 277       1.529  12.160  25.499  1.00 16.69           C  
ATOM    684  CD2 TYR A 277      -0.850  12.016  25.276  1.00 16.40           C  
ATOM    685  CE1 TYR A 277       1.388  13.266  26.338  1.00 17.00           C  
ATOM    686  CE2 TYR A 277      -0.999  13.112  26.106  1.00 17.29           C  
ATOM    687  CZ  TYR A 277       0.121  13.735  26.630  1.00 17.45           C  
ATOM    688  OH  TYR A 277      -0.021  14.822  27.459  1.00 18.74           O  
ATOM    689  N   LEU A 278       0.887   8.716  27.060  1.00 15.92           N  
ATOM    690  CA  LEU A 278       0.217   8.289  28.295  1.00 16.20           C  
ATOM    691  C   LEU A 278      -0.414   6.892  28.194  1.00 15.49           C  
ATOM    692  O   LEU A 278      -1.579   6.692  28.550  1.00 15.69           O  
ATOM    693  CB  LEU A 278      -0.818   9.334  28.729  1.00 17.01           C  
ATOM    694  CG  LEU A 278      -0.371  10.799  28.862  1.00 19.10           C  
ATOM    695  CD1 LEU A 278      -1.540  11.663  29.320  1.00 20.41           C  
ATOM    696  CD2 LEU A 278       0.817  10.954  29.814  1.00 21.31           C  
ATOM    697  N   SER A 279       0.370   5.935  27.696  1.00 15.01           N  
ATOM    698  CA  SER A 279      -0.021   4.510  27.586  1.00 14.74           C  
ATOM    699  C   SER A 279      -1.143   4.211  26.601  1.00 13.56           C  
ATOM    700  O   SER A 279      -1.787   3.162  26.683  1.00 13.76           O  
ATOM    701  CB  SER A 279      -0.357   3.903  28.957  1.00 15.07           C  
ATOM    702  OG  SER A 279       0.685   4.131  29.882  1.00 18.15           O  
ATOM    703  N   LYS A 280      -1.374   5.133  25.664  1.00 12.40           N  
ATOM    704  CA  LYS A 280      -2.413   4.972  24.661  1.00 12.43           C  
ATOM    705  C   LYS A 280      -1.852   5.314  23.289  1.00 11.36           C  
ATOM    706  O   LYS A 280      -0.896   6.080  23.175  1.00 10.82           O  
ATOM    707  CB  LYS A 280      -3.588   5.903  24.954  1.00 12.56           C  
ATOM    708  CG  LYS A 280      -4.525   5.403  26.040  1.00 14.05           C  
ATOM    709  CD  LYS A 280      -5.720   6.347  26.224  1.00 15.17           C  
ATOM    710  CE  LYS A 280      -6.713   6.271  25.055  1.00 18.79           C  
ATOM    711  NZ  LYS A 280      -7.363   4.922  24.956  1.00 20.88           N  
ATOM    712  N   THR A 281      -2.478   4.749  22.259  1.00 10.66           N  
ATOM    713  CA  THR A 281      -2.134   5.062  20.887  1.00 10.61           C  
ATOM    714  C   THR A 281      -2.929   6.261  20.398  1.00 10.99           C  
ATOM    715  O   THR A 281      -4.160   6.292  20.499  1.00 11.66           O  
ATOM    716  CB  THR A 281      -2.394   3.878  19.967  1.00 10.59           C  
ATOM    717  OG1 THR A 281      -1.604   2.779  20.423  1.00 10.04           O  
ATOM    718  CG2 THR A 281      -1.965   4.214  18.534  1.00 10.66           C  
ATOM    719  N   TYR A 282      -2.204   7.252  19.894  1.00 10.96           N  
ATOM    720  CA  TYR A 282      -2.828   8.393  19.240  1.00 11.56           C  
ATOM    721  C   TYR A 282      -2.400   8.477  17.793  1.00 11.58           C  
ATOM    722  O   TYR A 282      -1.449   7.818  17.364  1.00 10.70           O  
ATOM    723  CB  TYR A 282      -2.496   9.689  19.977  1.00 13.22           C  
ATOM    724  CG  TYR A 282      -3.167   9.755  21.323  1.00 14.54           C  
ATOM    725  CD1 TYR A 282      -4.469  10.238  21.457  1.00 16.61           C  
ATOM    726  CD2 TYR A 282      -2.513   9.297  22.457  1.00 14.93           C  
ATOM    727  CE1 TYR A 282      -5.089  10.282  22.692  1.00 17.14           C  
ATOM    728  CE2 TYR A 282      -3.115   9.341  23.693  1.00 15.62           C  
ATOM    729  CZ  TYR A 282      -4.408   9.826  23.808  1.00 15.96           C  
ATOM    730  OH  TYR A 282      -5.026   9.878  25.031  1.00 19.30           O  
ATOM    731  N   CYS A 283      -3.104   9.302  17.038  1.00 11.74           N  
ATOM    732  CA  CYS A 283      -2.765   9.467  15.641  1.00 12.23           C  
ATOM    733  C   CYS A 283      -3.070  10.890  15.222  1.00 12.03           C  
ATOM    734  O   CYS A 283      -4.158  11.408  15.496  1.00 12.99           O  
ATOM    735  CB  CYS A 283      -3.584   8.481  14.798  1.00 12.77           C  
ATOM    736  SG  CYS A 283      -3.298   8.582  13.016  1.00 13.29           S  
ATOM    737  N   VAL A 284      -2.113  11.527  14.553  1.00 11.82           N  
ATOM    738  CA  VAL A 284      -2.434  12.758  13.846  1.00 12.17           C  
ATOM    739  C   VAL A 284      -2.809  12.360  12.428  1.00 12.35           C  
ATOM    740  O   VAL A 284      -1.963  11.954  11.632  1.00 13.19           O  
ATOM    741  CB  VAL A 284      -1.299  13.790  13.838  1.00 11.74           C  
ATOM    742  CG1 VAL A 284      -1.759  15.059  13.113  1.00 12.18           C  
ATOM    743  CG2 VAL A 284      -0.860  14.138  15.235  1.00 12.84           C  
ATOM    744  N   ASP A 285      -4.098  12.445  12.129  1.00 13.05           N  
ATOM    745  CA  ASP A 285      -4.568  12.069  10.813  1.00 13.62           C  
ATOM    746  C   ASP A 285      -4.608  13.318   9.936  1.00 13.39           C  
ATOM    747  O   ASP A 285      -5.509  14.149  10.054  1.00 13.29           O  
ATOM    748  CB  ASP A 285      -5.945  11.405  10.906  1.00 14.35           C  
ATOM    749  CG  ASP A 285      -6.503  11.034   9.555  1.00 16.02           C  
ATOM    750  OD1 ASP A 285      -7.702  10.708   9.486  1.00 17.26           O  
ATOM    751  OD2 ASP A 285      -5.755  11.101   8.547  1.00 18.16           O  
ATOM    752  N   ALA A 286      -3.613  13.451   9.061  1.00 13.04           N  
ATOM    753  CA  ALA A 286      -3.565  14.605   8.173  1.00 13.46           C  
ATOM    754  C   ALA A 286      -4.021  14.290   6.742  1.00 13.97           C  
ATOM    755  O   ALA A 286      -3.531  14.885   5.780  1.00 14.16           O  
ATOM    756  CB  ALA A 286      -2.163  15.204   8.174  1.00 12.78           C  
ATOM    757  N   THR A 287      -4.968  13.368   6.604  1.00 15.23           N  
ATOM    758  CA  THR A 287      -5.452  12.959   5.285  1.00 16.38           C  
ATOM    759  C   THR A 287      -6.162  14.090   4.535  1.00 17.22           C  
ATOM    760  O   THR A 287      -5.939  14.273   3.335  1.00 17.60           O  
ATOM    761  CB  THR A 287      -6.352  11.710   5.391  1.00 16.55           C  
ATOM    762  OG1 THR A 287      -5.609  10.663   6.012  1.00 16.49           O  
ATOM    763  CG2 THR A 287      -6.811  11.238   4.012  1.00 16.43           C  
ATOM    764  N   ARG A 288      -7.009  14.843   5.237  1.00 18.28           N  
ATOM    765  CA  ARG A 288      -7.711  15.970   4.620  1.00 19.28           C  
ATOM    766  C   ARG A 288      -6.726  17.006   4.077  1.00 18.41           C  
ATOM    767  O   ARG A 288      -5.756  17.364   4.750  1.00 17.77           O  
ATOM    768  CB  ARG A 288      -8.680  16.628   5.609  1.00 19.63           C  
ATOM    769  CG  ARG A 288      -9.577  17.705   4.988  1.00 20.89           C  
ATOM    770  CD  ARG A 288     -10.637  18.198   5.967  1.00 21.49           C  
ATOM    771  NE  ARG A 288     -10.058  18.951   7.081  1.00 24.76           N  
ATOM    772  CZ  ARG A 288      -9.805  20.258   7.058  1.00 26.47           C  
ATOM    773  NH1 ARG A 288     -10.071  20.977   5.973  1.00 27.12           N  
ATOM    774  NH2 ARG A 288      -9.277  20.849   8.125  1.00 27.93           N  
ATOM    775  N   GLU A 289      -6.975  17.467   2.854  1.00 17.76           N  
ATOM    776  CA  GLU A 289      -6.138  18.484   2.240  1.00 17.10           C  
ATOM    777  C   GLU A 289      -6.353  19.831   2.923  1.00 16.75           C  
ATOM    778  O   GLU A 289      -7.479  20.332   2.995  1.00 17.89           O  
ATOM    779  CB  GLU A 289      -6.372  18.564   0.718  1.00 16.99           C  
ATOM    780  CG  GLU A 289      -5.777  17.377  -0.076  1.00 17.63           C  
ATOM    781  CD  GLU A 289      -4.226  17.375  -0.170  1.00 17.13           C  
ATOM    782  OE1 GLU A 289      -3.603  18.471  -0.273  1.00 14.62           O  
ATOM    783  OE2 GLU A 289      -3.631  16.262  -0.154  1.00 17.20           O  
ATOM    784  N   THR A 290      -5.267  20.377   3.461  1.00 16.03           N  
ATOM    785  CA  THR A 290      -5.238  21.685   4.127  1.00 14.75           C  
ATOM    786  C   THR A 290      -4.026  22.453   3.599  1.00 14.59           C  
ATOM    787  O   THR A 290      -3.300  21.947   2.743  1.00 14.33           O  
ATOM    788  CB  THR A 290      -5.067  21.540   5.651  1.00 14.98           C  
ATOM    789  OG1 THR A 290      -3.750  21.030   5.898  1.00 14.98           O  
ATOM    790  CG2 THR A 290      -6.115  20.590   6.245  1.00 14.68           C  
ATOM    791  N   ASN A 291      -3.806  23.670   4.093  1.00 13.93           N  
ATOM    792  CA  ASN A 291      -2.616  24.445   3.713  1.00 14.10           C  
ATOM    793  C   ASN A 291      -1.399  24.193   4.599  1.00 13.28           C  
ATOM    794  O   ASN A 291      -0.349  24.810   4.410  1.00 13.51           O  
ATOM    795  CB  ASN A 291      -2.924  25.945   3.671  1.00 14.80           C  
ATOM    796  CG  ASN A 291      -3.902  26.314   2.568  1.00 17.14           C  
ATOM    797  OD1 ASN A 291      -4.597  27.328   2.658  1.00 19.42           O  
ATOM    798  ND2 ASN A 291      -3.968  25.489   1.524  1.00 19.57           N  
ATOM    799  N   ARG A 292      -1.536  23.282   5.560  1.00 12.49           N  
ATOM    800  CA  ARG A 292      -0.449  22.985   6.483  1.00 12.14           C  
ATOM    801  C   ARG A 292       0.595  22.099   5.814  1.00 11.59           C  
ATOM    802  O   ARG A 292       0.253  21.177   5.055  1.00 11.69           O  
ATOM    803  CB  ARG A 292      -0.994  22.321   7.749  1.00 12.55           C  
ATOM    804  CG  ARG A 292      -2.041  23.143   8.497  1.00 13.00           C  
ATOM    805  CD  ARG A 292      -1.499  24.497   8.957  1.00 15.14           C  
ATOM    806  NE  ARG A 292      -0.474  24.377   9.991  1.00 15.88           N  
ATOM    807  CZ  ARG A 292      -0.695  24.543  11.300  1.00 15.07           C  
ATOM    808  NH1 ARG A 292      -1.908  24.838  11.746  1.00 15.60           N  
ATOM    809  NH2 ARG A 292       0.299  24.426  12.159  1.00 14.89           N  
ATOM    810  N   LEU A 293       1.866  22.362   6.109  1.00 10.71           N  
ATOM    811  CA  LEU A 293       2.940  21.774   5.320  1.00 10.93           C  
ATOM    812  C   LEU A 293       3.568  20.492   5.862  1.00 10.19           C  
ATOM    813  O   LEU A 293       4.160  19.741   5.085  1.00  9.76           O  
ATOM    814  CB  LEU A 293       4.040  22.803   5.050  1.00 11.32           C  
ATOM    815  CG  LEU A 293       3.621  24.006   4.196  1.00 12.49           C  
ATOM    816  CD1 LEU A 293       4.811  24.940   3.994  1.00 13.95           C  
ATOM    817  CD2 LEU A 293       3.019  23.577   2.853  1.00 14.16           C  
ATOM    818  N   GLY A 294       3.439  20.225   7.161  1.00 10.17           N  
ATOM    819  CA  GLY A 294       4.109  19.057   7.734  1.00  9.65           C  
ATOM    820  C   GLY A 294       3.679  17.774   7.042  1.00  9.26           C  
ATOM    821  O   GLY A 294       4.501  16.870   6.807  1.00  9.84           O  
ATOM    822  N   ARG A 295       2.385  17.704   6.712  1.00  9.60           N  
ATOM    823  CA  ARG A 295       1.795  16.545   6.045  1.00  9.68           C  
ATOM    824  C   ARG A 295       2.401  16.242   4.671  1.00  9.57           C  
ATOM    825  O   ARG A 295       2.237  15.132   4.157  1.00 10.12           O  
ATOM    826  CB  ARG A 295       0.282  16.735   5.935  1.00  9.62           C  
ATOM    827  CG  ARG A 295      -0.137  17.944   5.089  1.00  9.85           C  
ATOM    828  CD  ARG A 295      -1.652  18.196   5.165  1.00 10.51           C  
ATOM    829  NE  ARG A 295      -2.407  17.107   4.539  1.00 11.65           N  
ATOM    830  CZ  ARG A 295      -2.658  17.035   3.229  1.00 11.94           C  
ATOM    831  NH1 ARG A 295      -2.230  17.991   2.409  1.00 12.29           N  
ATOM    832  NH2 ARG A 295      -3.340  16.001   2.742  1.00 12.89           N  
ATOM    833  N   LEU A 296       3.085  17.231   4.084  1.00  9.93           N  
ATOM    834  CA  LEU A 296       3.650  17.112   2.739  1.00  9.52           C  
ATOM    835  C   LEU A 296       5.134  16.774   2.706  1.00  9.35           C  
ATOM    836  O   LEU A 296       5.716  16.618   1.625  1.00  9.00           O  
ATOM    837  CB  LEU A 296       3.401  18.390   1.931  1.00  9.50           C  
ATOM    838  CG  LEU A 296       1.937  18.758   1.672  1.00 10.68           C  
ATOM    839  CD1 LEU A 296       1.912  19.942   0.725  1.00 10.61           C  
ATOM    840  CD2 LEU A 296       1.165  17.586   1.066  1.00 11.35           C  
ATOM    841  N   ILE A 297       5.741  16.656   3.885  1.00  9.21           N  
ATOM    842  CA  ILE A 297       7.173  16.373   3.963  1.00  9.59           C  
ATOM    843  C   ILE A 297       7.419  14.880   3.698  1.00  9.01           C  
ATOM    844  O   ILE A 297       6.716  13.997   4.235  1.00  9.21           O  
ATOM    845  CB  ILE A 297       7.766  16.855   5.310  1.00  9.44           C  
ATOM    846  CG1 ILE A 297       7.677  18.385   5.406  1.00 10.13           C  
ATOM    847  CG2 ILE A 297       9.212  16.427   5.439  1.00 10.54           C  
ATOM    848  CD1 ILE A 297       8.086  18.987   6.732  1.00 11.04           C  
ATOM    849  N   ASN A 298       8.389  14.609   2.825  1.00  8.84           N  
ATOM    850  CA  ASN A 298       8.696  13.255   2.406  1.00  8.26           C  
ATOM    851  C   ASN A 298       9.657  12.529   3.344  1.00  8.85           C  
ATOM    852  O   ASN A 298      10.155  13.114   4.315  1.00  8.85           O  
ATOM    853  CB  ASN A 298       9.160  13.260   0.946  1.00  8.87           C  
ATOM    854  CG  ASN A 298       8.037  13.632   0.013  1.00  8.21           C  
ATOM    855  OD1 ASN A 298       6.928  13.127   0.163  1.00  8.86           O  
ATOM    856  ND2 ASN A 298       8.304  14.529  -0.937  1.00  9.28           N  
ATOM    857  N   HIS A 299       9.892  11.257   3.033  1.00  8.80           N  
ATOM    858  CA  HIS A 299      10.634  10.330   3.901  1.00  9.22           C  
ATOM    859  C   HIS A 299      12.091  10.166   3.487  1.00  9.54           C  
ATOM    860  O   HIS A 299      12.404  10.044   2.300  1.00  9.96           O  
ATOM    861  CB  HIS A 299       9.977   8.951   3.815  1.00 10.12           C  
ATOM    862  CG  HIS A 299      10.837   7.837   4.324  1.00  9.41           C  
ATOM    863  ND1 HIS A 299      10.908   7.492   5.659  1.00  9.40           N  
ATOM    864  CD2 HIS A 299      11.667   6.985   3.671  1.00  8.60           C  
ATOM    865  CE1 HIS A 299      11.770   6.500   5.808  1.00 10.61           C  
ATOM    866  NE2 HIS A 299      12.230   6.161   4.616  1.00 10.24           N  
ATOM    867  N   SER A 300      12.965  10.099   4.483  1.00  9.67           N  
ATOM    868  CA  SER A 300      14.279   9.482   4.322  1.00 10.46           C  
ATOM    869  C   SER A 300      14.727   8.966   5.678  1.00 11.00           C  
ATOM    870  O   SER A 300      14.418   9.571   6.687  1.00 11.39           O  
ATOM    871  CB  SER A 300      15.309  10.488   3.810  1.00 10.79           C  
ATOM    872  OG  SER A 300      16.602   9.890   3.761  1.00 11.75           O  
ATOM    873  N   LYS A 301      15.471   7.864   5.685  1.00 12.69           N  
ATOM    874  CA  LYS A 301      16.110   7.395   6.904  1.00 13.74           C  
ATOM    875  C   LYS A 301      17.333   8.241   7.261  1.00 14.43           C  
ATOM    876  O   LYS A 301      17.853   8.145   8.387  1.00 15.58           O  
ATOM    877  CB  LYS A 301      16.567   5.956   6.751  1.00 14.72           C  
ATOM    878  CG  LYS A 301      15.464   4.943   6.766  1.00 16.13           C  
ATOM    879  CD  LYS A 301      16.089   3.574   6.523  1.00 18.92           C  
ATOM    880  CE  LYS A 301      15.055   2.520   6.583  1.00 22.50           C  
ATOM    881  NZ  LYS A 301      14.809   2.232   8.011  1.00 25.21           N  
ATOM    882  N   CYS A 302      17.820   9.026   6.298  1.00 14.19           N  
ATOM    883  CA  CYS A 302      18.941   9.936   6.543  1.00 15.07           C  
ATOM    884  C   CYS A 302      18.556  11.333   6.108  1.00 14.51           C  
ATOM    885  O   CYS A 302      19.190  11.930   5.238  1.00 14.84           O  
ATOM    886  CB  CYS A 302      20.205   9.491   5.805  1.00 16.19           C  
ATOM    887  SG  CYS A 302      20.586   7.743   5.848  0.50 19.77           S  
ATOM    889  N   GLY A 303      17.507  11.842   6.732  1.00 13.66           N  
ATOM    890  CA  GLY A 303      16.993  13.160   6.383  1.00 12.65           C  
ATOM    891  C   GLY A 303      17.598  14.273   7.207  1.00 12.48           C  
ATOM    892  O   GLY A 303      18.752  14.190   7.648  1.00 13.27           O  
ATOM    893  N   ASN A 304      16.810  15.330   7.396  1.00 10.23           N  
ATOM    894  CA  ASN A 304      17.308  16.515   8.077  1.00  9.42           C  
ATOM    895  C   ASN A 304      16.372  17.027   9.172  1.00  9.55           C  
ATOM    896  O   ASN A 304      16.658  18.069   9.771  1.00  9.94           O  
ATOM    897  CB  ASN A 304      17.615  17.630   7.067  1.00  9.71           C  
ATOM    898  CG  ASN A 304      16.468  17.862   6.082  1.00  8.93           C  
ATOM    899  OD1 ASN A 304      15.295  17.742   6.446  1.00  9.74           O  
ATOM    900  ND2 ASN A 304      16.803  18.204   4.831  1.00  9.81           N  
ATOM    901  N   CYS A 305      15.279  16.291   9.429  1.00  9.44           N  
ATOM    902  CA  CYS A 305      14.341  16.615  10.495  1.00 10.55           C  
ATOM    903  C   CYS A 305      14.090  15.382  11.340  1.00 10.30           C  
ATOM    904  O   CYS A 305      14.166  14.240  10.845  1.00 10.58           O  
ATOM    905  CB  CYS A 305      12.995  17.104   9.941  1.00 10.77           C  
ATOM    906  SG  CYS A 305      13.083  18.683   9.070  1.00 11.89           S  
ATOM    907  N   GLN A 306      13.762  15.626  12.604  1.00 11.77           N  
ATOM    908  CA  GLN A 306      13.392  14.568  13.538  1.00 12.40           C  
ATOM    909  C   GLN A 306      12.079  14.945  14.210  1.00 11.98           C  
ATOM    910  O   GLN A 306      11.924  16.059  14.699  1.00 12.22           O  
ATOM    911  CB  GLN A 306      14.499  14.351  14.588  1.00 14.08           C  
ATOM    912  CG  GLN A 306      14.130  13.444  15.777  1.00 18.72           C  
ATOM    913  CD  GLN A 306      13.810  12.006  15.380  1.00 24.39           C  
ATOM    914  OE1 GLN A 306      14.655  11.308  14.809  1.00 27.09           O  
ATOM    915  NE2 GLN A 306      12.591  11.547  15.709  1.00 25.96           N  
ATOM    916  N   THR A 307      11.147  13.999  14.244  1.00 11.78           N  
ATOM    917  CA  THR A 307       9.879  14.235  14.906  1.00 11.60           C  
ATOM    918  C   THR A 307       9.997  13.974  16.414  1.00 12.04           C  
ATOM    919  O   THR A 307      10.632  13.003  16.839  1.00 12.72           O  
ATOM    920  CB  THR A 307       8.765  13.357  14.298  1.00 11.80           C  
ATOM    921  OG1 THR A 307       8.745  13.517  12.872  1.00 13.56           O  
ATOM    922  CG2 THR A 307       7.373  13.740  14.881  1.00 12.05           C  
ATOM    923  N   LYS A 308       9.393  14.873  17.195  1.00 11.82           N  
ATOM    924  CA  LYS A 308       9.363  14.805  18.659  1.00 12.82           C  
ATOM    925  C   LYS A 308       7.920  14.958  19.104  1.00 12.18           C  
ATOM    926  O   LYS A 308       7.133  15.674  18.478  1.00 12.24           O  
ATOM    927  CB  LYS A 308      10.159  15.963  19.309  1.00 13.64           C  
ATOM    928  CG  LYS A 308      11.572  16.191  18.769  1.00 18.69           C  
ATOM    929  CD  LYS A 308      12.547  15.177  19.317  1.00 23.70           C  
ATOM    930  CE  LYS A 308      13.986  15.528  18.949  1.00 27.06           C  
ATOM    931  NZ  LYS A 308      14.937  14.532  19.519  1.00 29.90           N  
ATOM    932  N   LEU A 309       7.590  14.303  20.212  1.00 11.98           N  
ATOM    933  CA  LEU A 309       6.329  14.553  20.910  1.00 12.64           C  
ATOM    934  C   LEU A 309       6.512  15.779  21.824  1.00 12.56           C  
ATOM    935  O   LEU A 309       7.446  15.834  22.623  1.00 13.79           O  
ATOM    936  CB  LEU A 309       5.928  13.310  21.722  1.00 13.87           C  
ATOM    937  CG  LEU A 309       4.609  13.303  22.513  1.00 16.92           C  
ATOM    938  CD1 LEU A 309       4.610  14.264  23.691  1.00 19.64           C  
ATOM    939  CD2 LEU A 309       3.445  13.581  21.624  1.00 18.78           C  
ATOM    940  N   HIS A 310       5.613  16.750  21.708  1.00 12.66           N  
ATOM    941  CA  HIS A 310       5.671  17.958  22.530  1.00 13.01           C  
ATOM    942  C   HIS A 310       4.322  18.151  23.188  1.00 13.20           C  
ATOM    943  O   HIS A 310       3.319  18.350  22.508  1.00 13.84           O  
ATOM    944  CB  HIS A 310       6.014  19.172  21.665  1.00 12.99           C  
ATOM    945  CG  HIS A 310       6.203  20.437  22.440  1.00 13.33           C  
ATOM    946  ND1 HIS A 310       7.398  20.762  23.046  1.00 14.39           N  
ATOM    947  CD2 HIS A 310       5.356  21.466  22.691  1.00 14.28           C  
ATOM    948  CE1 HIS A 310       7.273  21.931  23.653  1.00 14.52           C  
ATOM    949  NE2 HIS A 310       6.047  22.382  23.451  1.00 13.34           N  
ATOM    950  N   ASP A 311       4.320  18.097  24.517  1.00 13.71           N  
ATOM    951  CA  ASP A 311       3.110  18.143  25.324  1.00 14.50           C  
ATOM    952  C   ASP A 311       2.872  19.578  25.786  1.00 14.15           C  
ATOM    953  O   ASP A 311       3.760  20.187  26.377  1.00 15.13           O  
ATOM    954  CB  ASP A 311       3.353  17.209  26.524  1.00 15.39           C  
ATOM    955  CG  ASP A 311       2.221  17.195  27.538  1.00 17.59           C  
ATOM    956  OD1 ASP A 311       2.106  16.160  28.230  1.00 20.15           O  
ATOM    957  OD2 ASP A 311       1.476  18.188  27.681  1.00 19.44           O  
ATOM    958  N   ILE A 312       1.693  20.125  25.505  1.00 13.30           N  
ATOM    959  CA  ILE A 312       1.300  21.414  26.100  1.00 13.63           C  
ATOM    960  C   ILE A 312       0.104  21.207  27.019  1.00 14.34           C  
ATOM    961  O   ILE A 312      -1.020  21.024  26.556  1.00 14.11           O  
ATOM    962  CB  ILE A 312       0.978  22.512  25.058  1.00 13.33           C  
ATOM    963  CG1 ILE A 312       2.076  22.591  23.992  1.00 13.49           C  
ATOM    964  CG2 ILE A 312       0.768  23.883  25.768  1.00 13.54           C  
ATOM    965  CD1 ILE A 312       1.774  23.556  22.859  1.00 13.78           C  
ATOM    966  N   ASP A 313       0.384  21.202  28.326  1.00 14.68           N  
ATOM    967  CA  ASP A 313      -0.644  21.092  29.370  1.00 16.40           C  
ATOM    968  C   ASP A 313      -1.598  19.927  29.109  1.00 16.37           C  
ATOM    969  O   ASP A 313      -2.814  20.043  29.270  1.00 17.45           O  
ATOM    970  CB  ASP A 313      -1.402  22.423  29.523  1.00 17.24           C  
ATOM    971  CG  ASP A 313      -0.517  23.535  30.077  1.00 19.40           C  
ATOM    972  OD1 ASP A 313      -0.387  24.583  29.404  1.00 20.86           O  
ATOM    973  OD2 ASP A 313       0.076  23.344  31.159  1.00 21.35           O  
ATOM    974  N   GLY A 314      -1.025  18.803  28.689  1.00 16.21           N  
ATOM    975  CA  GLY A 314      -1.782  17.580  28.493  1.00 16.52           C  
ATOM    976  C   GLY A 314      -2.268  17.314  27.082  1.00 16.43           C  
ATOM    977  O   GLY A 314      -2.870  16.268  26.836  1.00 17.49           O  
ATOM    978  N   VAL A 315      -2.014  18.245  26.155  1.00 15.59           N  
ATOM    979  CA  VAL A 315      -2.348  18.030  24.745  1.00 15.21           C  
ATOM    980  C   VAL A 315      -1.063  17.697  23.974  1.00 14.35           C  
ATOM    981  O   VAL A 315      -0.120  18.485  23.970  1.00 14.68           O  
ATOM    982  CB  VAL A 315      -3.064  19.249  24.111  1.00 15.09           C  
ATOM    983  CG1 VAL A 315      -3.499  18.922  22.691  1.00 15.95           C  
ATOM    984  CG2 VAL A 315      -4.303  19.638  24.942  1.00 16.07           C  
ATOM    985  N   PRO A 316      -1.015  16.513  23.348  1.00 14.24           N  
ATOM    986  CA  PRO A 316       0.184  16.124  22.587  1.00 13.48           C  
ATOM    987  C   PRO A 316       0.236  16.749  21.196  1.00 13.34           C  
ATOM    988  O   PRO A 316      -0.790  16.886  20.531  1.00 13.64           O  
ATOM    989  CB  PRO A 316       0.028  14.612  22.453  1.00 14.35           C  
ATOM    990  CG  PRO A 316      -1.456  14.410  22.419  1.00 14.89           C  
ATOM    991  CD  PRO A 316      -2.046  15.461  23.326  1.00 14.25           C  
ATOM    992  N   HIS A 317       1.448  17.105  20.775  1.00 11.69           N  
ATOM    993  CA  HIS A 317       1.673  17.610  19.419  1.00 11.95           C  
ATOM    994  C   HIS A 317       2.883  16.881  18.855  1.00 11.73           C  
ATOM    995  O   HIS A 317       3.819  16.587  19.594  1.00 12.62           O  
ATOM    996  CB  HIS A 317       1.953  19.113  19.438  1.00 12.38           C  
ATOM    997  CG  HIS A 317       0.806  19.939  19.927  1.00 12.04           C  
ATOM    998  ND1 HIS A 317      -0.063  20.589  19.077  1.00 12.44           N  
ATOM    999  CD2 HIS A 317       0.379  20.218  21.184  1.00 12.93           C  
ATOM   1000  CE1 HIS A 317      -0.977  21.230  19.787  1.00 13.64           C  
ATOM   1001  NE2 HIS A 317      -0.730  21.021  21.068  1.00 13.53           N  
ATOM   1002  N   LEU A 318       2.854  16.579  17.558  1.00 11.46           N  
ATOM   1003  CA  LEU A 318       4.044  16.072  16.868  1.00 10.97           C  
ATOM   1004  C   LEU A 318       4.707  17.231  16.169  1.00 11.19           C  
ATOM   1005  O   LEU A 318       4.074  17.922  15.376  1.00 11.00           O  
ATOM   1006  CB  LEU A 318       3.648  15.022  15.827  1.00 10.70           C  
ATOM   1007  CG  LEU A 318       3.047  13.736  16.394  1.00 12.03           C  
ATOM   1008  CD1 LEU A 318       2.741  12.785  15.240  1.00 12.34           C  
ATOM   1009  CD2 LEU A 318       3.991  13.074  17.406  1.00 12.14           C  
ATOM   1010  N   ILE A 319       5.982  17.457  16.479  1.00 10.68           N  
ATOM   1011  CA  ILE A 319       6.716  18.560  15.876  1.00 11.57           C  
ATOM   1012  C   ILE A 319       7.975  18.041  15.205  1.00 10.81           C  
ATOM   1013  O   ILE A 319       8.551  17.029  15.632  1.00 11.33           O  
ATOM   1014  CB  ILE A 319       7.058  19.672  16.901  1.00 11.51           C  
ATOM   1015  CG1 ILE A 319       8.004  19.151  17.986  1.00 12.06           C  
ATOM   1016  CG2 ILE A 319       5.760  20.250  17.519  1.00 12.34           C  
ATOM   1017  CD1 ILE A 319       8.489  20.222  18.979  1.00 13.64           C  
ATOM   1018  N   LEU A 320       8.382  18.733  14.146  1.00  9.91           N  
ATOM   1019  CA  LEU A 320       9.636  18.427  13.455  1.00 10.22           C  
ATOM   1020  C   LEU A 320      10.703  19.442  13.829  1.00 10.49           C  
ATOM   1021  O   LEU A 320      10.476  20.642  13.746  1.00 11.07           O  
ATOM   1022  CB  LEU A 320       9.425  18.381  11.947  1.00 10.99           C  
ATOM   1023  CG  LEU A 320       8.828  17.092  11.381  1.00 11.89           C  
ATOM   1024  CD1 LEU A 320       7.378  16.850  11.845  1.00 14.01           C  
ATOM   1025  CD2 LEU A 320       8.914  17.159   9.862  1.00 13.94           C  
ATOM   1026  N   ILE A 321      11.842  18.921  14.270  1.00 10.96           N  
ATOM   1027  CA  ILE A 321      13.017  19.706  14.659  1.00 12.48           C  
ATOM   1028  C   ILE A 321      14.137  19.411  13.664  1.00 11.57           C  
ATOM   1029  O   ILE A 321      14.318  18.257  13.248  1.00 12.01           O  
ATOM   1030  CB  ILE A 321      13.455  19.283  16.091  1.00 12.92           C  
ATOM   1031  CG1 ILE A 321      12.287  19.497  17.073  1.00 14.60           C  
ATOM   1032  CG2 ILE A 321      14.713  20.007  16.578  1.00 14.69           C  
ATOM   1033  CD1 ILE A 321      11.795  20.938  17.176  1.00 16.10           C  
ATOM   1034  N   ALA A 322      14.887  20.438  13.276  1.00 10.80           N  
ATOM   1035  CA  ALA A 322      16.034  20.216  12.376  1.00 10.15           C  
ATOM   1036  C   ALA A 322      17.093  19.389  13.082  1.00 10.17           C  
ATOM   1037  O   ALA A 322      17.514  19.730  14.196  1.00 10.37           O  
ATOM   1038  CB  ALA A 322      16.625  21.542  11.907  1.00 10.49           C  
ATOM   1039  N   SER A 323      17.509  18.295  12.448  1.00  9.62           N  
ATOM   1040  CA  SER A 323      18.516  17.418  13.048  1.00 10.74           C  
ATOM   1041  C   SER A 323      19.926  17.823  12.637  1.00 10.46           C  
ATOM   1042  O   SER A 323      20.908  17.292  13.141  1.00 11.68           O  
ATOM   1043  CB  SER A 323      18.249  15.977  12.634  1.00 11.67           C  
ATOM   1044  OG  SER A 323      18.358  15.848  11.226  1.00 13.31           O  
ATOM   1045  N   ARG A 324      20.013  18.758  11.693  1.00  9.82           N  
ATOM   1046  CA  ARG A 324      21.275  19.330  11.251  1.00  9.71           C  
ATOM   1047  C   ARG A 324      20.925  20.668  10.597  1.00  9.28           C  
ATOM   1048  O   ARG A 324      19.742  20.929  10.359  1.00  9.71           O  
ATOM   1049  CB  ARG A 324      21.965  18.416  10.218  1.00  9.60           C  
ATOM   1050  CG  ARG A 324      21.123  18.094   8.973  1.00 10.27           C  
ATOM   1051  CD  ARG A 324      22.030  17.524   7.888  1.00 11.13           C  
ATOM   1052  NE  ARG A 324      21.328  17.009   6.717  1.00 11.09           N  
ATOM   1053  CZ  ARG A 324      20.877  17.748   5.708  1.00 10.22           C  
ATOM   1054  NH1 ARG A 324      20.958  19.088   5.732  1.00 10.71           N  
ATOM   1055  NH2 ARG A 324      20.314  17.139   4.676  1.00 10.62           N  
ATOM   1056  N   ASP A 325      21.935  21.490  10.280  1.00  9.37           N  
ATOM   1057  CA  ASP A 325      21.681  22.683   9.483  1.00  9.31           C  
ATOM   1058  C   ASP A 325      21.084  22.256   8.145  1.00  9.38           C  
ATOM   1059  O   ASP A 325      21.538  21.282   7.526  1.00 10.09           O  
ATOM   1060  CB  ASP A 325      22.971  23.467   9.250  1.00  8.70           C  
ATOM   1061  CG  ASP A 325      23.473  24.185  10.504  1.00  9.46           C  
ATOM   1062  OD1 ASP A 325      22.821  24.131  11.573  1.00 10.56           O  
ATOM   1063  OD2 ASP A 325      24.537  24.828  10.410  1.00 11.70           O  
ATOM   1064  N   ILE A 326      20.067  22.994   7.712  1.00  9.29           N  
ATOM   1065  CA  ILE A 326      19.346  22.705   6.486  1.00  9.22           C  
ATOM   1066  C   ILE A 326      19.576  23.854   5.509  1.00  9.07           C  
ATOM   1067  O   ILE A 326      19.320  25.011   5.832  1.00  9.86           O  
ATOM   1068  CB  ILE A 326      17.842  22.538   6.744  1.00  9.20           C  
ATOM   1069  CG1 ILE A 326      17.590  21.459   7.805  1.00  9.77           C  
ATOM   1070  CG2 ILE A 326      17.122  22.215   5.448  1.00  9.96           C  
ATOM   1071  CD1 ILE A 326      16.130  21.249   8.119  1.00 10.38           C  
ATOM   1072  N   ALA A 327      20.071  23.528   4.317  1.00  8.76           N  
ATOM   1073  CA  ALA A 327      20.385  24.535   3.312  1.00  8.74           C  
ATOM   1074  C   ALA A 327      19.150  25.068   2.638  1.00  9.17           C  
ATOM   1075  O   ALA A 327      18.224  24.322   2.351  1.00  9.22           O  
ATOM   1076  CB  ALA A 327      21.283  23.944   2.262  1.00  8.83           C  
ATOM   1077  N   ALA A 328      19.173  26.353   2.292  1.00  9.41           N  
ATOM   1078  CA  ALA A 328      18.145  26.884   1.434  1.00  9.09           C  
ATOM   1079  C   ALA A 328      18.093  26.039   0.162  1.00  8.94           C  
ATOM   1080  O   ALA A 328      19.149  25.666  -0.406  1.00  9.21           O  
ATOM   1081  CB  ALA A 328      18.457  28.338   1.093  1.00  9.29           C  
ATOM   1082  N   GLY A 329      16.873  25.722  -0.277  1.00  8.30           N  
ATOM   1083  CA  GLY A 329      16.683  24.996  -1.518  1.00  8.96           C  
ATOM   1084  C   GLY A 329      16.643  23.488  -1.378  1.00  8.60           C  
ATOM   1085  O   GLY A 329      16.270  22.808  -2.321  1.00  9.80           O  
ATOM   1086  N   GLU A 330      17.024  22.951  -0.216  1.00  7.92           N  
ATOM   1087  CA  GLU A 330      16.982  21.493  -0.058  1.00  8.93           C  
ATOM   1088  C   GLU A 330      15.663  21.024   0.514  1.00  8.67           C  
ATOM   1089  O   GLU A 330      14.973  21.752   1.231  1.00  9.09           O  
ATOM   1090  CB  GLU A 330      18.178  20.949   0.731  1.00 10.52           C  
ATOM   1091  CG  GLU A 330      18.088  21.013   2.227  1.00 10.80           C  
ATOM   1092  CD  GLU A 330      19.200  20.181   2.891  1.00  9.98           C  
ATOM   1093  OE1 GLU A 330      19.165  18.927   2.819  1.00  9.75           O  
ATOM   1094  OE2 GLU A 330      20.096  20.785   3.500  1.00  9.57           O  
ATOM   1095  N   GLU A 331      15.325  19.787   0.177  1.00  8.15           N  
ATOM   1096  CA  GLU A 331      14.075  19.200   0.599  1.00  8.22           C  
ATOM   1097  C   GLU A 331      14.113  18.830   2.078  1.00  8.16           C  
ATOM   1098  O   GLU A 331      15.080  18.223   2.556  1.00  8.70           O  
ATOM   1099  CB  GLU A 331      13.796  17.950  -0.241  1.00  8.17           C  
ATOM   1100  CG  GLU A 331      12.401  17.392  -0.005  1.00  8.44           C  
ATOM   1101  CD  GLU A 331      12.096  16.115  -0.761  1.00  8.68           C  
ATOM   1102  OE1 GLU A 331      13.028  15.484  -1.363  1.00  8.97           O  
ATOM   1103  OE2 GLU A 331      10.894  15.728  -0.672  1.00  9.15           O  
ATOM   1104  N   LEU A 332      13.041  19.155   2.789  1.00  8.34           N  
ATOM   1105  CA  LEU A 332      12.864  18.668   4.156  1.00  8.01           C  
ATOM   1106  C   LEU A 332      12.511  17.197   4.115  1.00  7.94           C  
ATOM   1107  O   LEU A 332      11.685  16.792   3.309  1.00  7.70           O  
ATOM   1108  CB  LEU A 332      11.745  19.441   4.850  1.00  8.57           C  
ATOM   1109  CG  LEU A 332      11.931  20.957   4.939  1.00  9.76           C  
ATOM   1110  CD1 LEU A 332      10.728  21.553   5.641  1.00 10.83           C  
ATOM   1111  CD2 LEU A 332      13.225  21.324   5.669  1.00 11.20           C  
ATOM   1112  N   LEU A 333      13.132  16.401   4.994  1.00  8.44           N  
ATOM   1113  CA  LEU A 333      12.922  14.948   5.013  1.00  8.86           C  
ATOM   1114  C   LEU A 333      13.070  14.429   6.419  1.00  8.82           C  
ATOM   1115  O   LEU A 333      13.928  14.894   7.161  1.00  9.25           O  
ATOM   1116  CB  LEU A 333      13.951  14.234   4.131  1.00  9.52           C  
ATOM   1117  CG  LEU A 333      13.907  14.543   2.627  1.00  9.53           C  
ATOM   1118  CD1 LEU A 333      15.162  14.037   1.918  1.00 10.13           C  
ATOM   1119  CD2 LEU A 333      12.662  13.951   1.992  1.00 10.78           C  
ATOM   1120  N   TYR A 334      12.221  13.472   6.786  1.00  8.90           N  
ATOM   1121  CA  TYR A 334      12.374  12.802   8.078  1.00  8.76           C  
ATOM   1122  C   TYR A 334      12.052  11.315   7.922  1.00  8.94           C  
ATOM   1123  O   TYR A 334      11.523  10.889   6.897  1.00  9.28           O  
ATOM   1124  CB  TYR A 334      11.483  13.444   9.165  1.00  9.32           C  
ATOM   1125  CG  TYR A 334       9.998  13.243   8.936  1.00  9.24           C  
ATOM   1126  CD1 TYR A 334       9.292  12.227   9.582  1.00  9.68           C  
ATOM   1127  CD2 TYR A 334       9.294  14.079   8.067  1.00  9.44           C  
ATOM   1128  CE1 TYR A 334       7.931  12.038   9.357  1.00  9.20           C  
ATOM   1129  CE2 TYR A 334       7.945  13.905   7.842  1.00 10.03           C  
ATOM   1130  CZ  TYR A 334       7.260  12.891   8.485  1.00  9.84           C  
ATOM   1131  OH  TYR A 334       5.905  12.740   8.246  1.00 10.25           O  
ATOM   1132  N   ASP A 335      12.378  10.525   8.946  1.00  9.28           N  
ATOM   1133  CA  ASP A 335      12.148   9.086   8.890  1.00  9.54           C  
ATOM   1134  C   ASP A 335      10.702   8.806   9.264  1.00  9.94           C  
ATOM   1135  O   ASP A 335      10.297   9.040  10.415  1.00 10.38           O  
ATOM   1136  CB  ASP A 335      13.081   8.393   9.879  1.00  9.96           C  
ATOM   1137  CG  ASP A 335      12.947   6.879   9.872  1.00 11.36           C  
ATOM   1138  OD1 ASP A 335      12.164   6.320   9.083  1.00 11.67           O  
ATOM   1139  OD2 ASP A 335      13.637   6.254  10.708  1.00 15.59           O  
ATOM   1140  N   TYR A 336       9.923   8.325   8.292  1.00 10.01           N  
ATOM   1141  CA  TYR A 336       8.518   7.952   8.547  1.00 10.28           C  
ATOM   1142  C   TYR A 336       8.378   6.845   9.584  1.00 10.39           C  
ATOM   1143  O   TYR A 336       7.319   6.713  10.199  1.00 10.90           O  
ATOM   1144  CB  TYR A 336       7.845   7.497   7.261  1.00  9.94           C  
ATOM   1145  CG  TYR A 336       7.407   8.591   6.309  1.00  9.66           C  
ATOM   1146  CD1 TYR A 336       7.778   9.918   6.504  1.00  9.52           C  
ATOM   1147  CD2 TYR A 336       6.620   8.275   5.193  1.00 10.15           C  
ATOM   1148  CE1 TYR A 336       7.357  10.917   5.604  1.00  8.68           C  
ATOM   1149  CE2 TYR A 336       6.199   9.254   4.301  1.00  9.99           C  
ATOM   1150  CZ  TYR A 336       6.555  10.570   4.525  1.00  8.64           C  
ATOM   1151  OH  TYR A 336       6.115  11.509   3.626  1.00  9.10           O  
ATOM   1152  N   GLY A 337       9.415   6.024   9.742  1.00 10.16           N  
ATOM   1153  CA  GLY A 337       9.425   5.023  10.826  1.00 11.03           C  
ATOM   1154  C   GLY A 337       8.687   3.720  10.582  1.00 11.21           C  
ATOM   1155  O   GLY A 337       8.722   2.838  11.432  1.00 11.15           O  
ATOM   1156  N   ASP A 338       8.004   3.603   9.443  1.00 11.32           N  
ATOM   1157  CA  ASP A 338       7.354   2.352   9.078  1.00 11.19           C  
ATOM   1158  C   ASP A 338       8.388   1.480   8.371  1.00 11.09           C  
ATOM   1159  O   ASP A 338       8.777   1.762   7.222  1.00 11.17           O  
ATOM   1160  CB  ASP A 338       6.150   2.615   8.170  1.00 11.76           C  
ATOM   1161  CG  ASP A 338       5.308   1.366   7.924  1.00 11.72           C  
ATOM   1162  OD1 ASP A 338       5.762   0.236   8.246  1.00 12.21           O  
ATOM   1163  OD2 ASP A 338       4.201   1.523   7.371  1.00 12.40           O  
ATOM   1164  N   ARG A 339       8.853   0.444   9.074  1.00 11.21           N  
ATOM   1165  CA  ARG A 339       9.891  -0.441   8.563  1.00 11.92           C  
ATOM   1166  C   ARG A 339       9.313  -1.811   8.249  1.00 12.10           C  
ATOM   1167  O   ARG A 339      10.045  -2.710   7.853  1.00 12.59           O  
ATOM   1168  CB  ARG A 339      11.029  -0.562   9.587  1.00 12.22           C  
ATOM   1169  CG  ARG A 339      11.669   0.760   9.863  1.00 13.09           C  
ATOM   1170  CD  ARG A 339      12.797   0.737  10.843  1.00 13.61           C  
ATOM   1171  NE  ARG A 339      13.217   2.119  11.055  1.00 13.68           N  
ATOM   1172  CZ  ARG A 339      14.040   2.533  12.008  1.00 14.93           C  
ATOM   1173  NH1 ARG A 339      14.571   1.661  12.866  1.00 16.40           N  
ATOM   1174  NH2 ARG A 339      14.333   3.827  12.097  1.00 16.95           N  
ATOM   1175  N   SER A 340       7.995  -1.937   8.388  1.00 11.62           N  
ATOM   1176  CA  SER A 340       7.313  -3.226   8.222  1.00 11.65           C  
ATOM   1177  C   SER A 340       7.506  -3.799   6.825  1.00 11.74           C  
ATOM   1178  O   SER A 340       7.518  -3.076   5.821  1.00 11.48           O  
ATOM   1179  CB  SER A 340       5.811  -3.119   8.546  1.00 11.61           C  
ATOM   1180  OG  SER A 340       5.107  -2.360   7.573  1.00 11.82           O  
ATOM   1181  N   LYS A 341       7.632  -5.120   6.766  1.00 12.62           N  
ATOM   1182  CA  LYS A 341       7.814  -5.818   5.506  1.00 13.70           C  
ATOM   1183  C   LYS A 341       6.645  -5.508   4.579  1.00 13.74           C  
ATOM   1184  O   LYS A 341       6.841  -5.213   3.396  1.00 13.67           O  
ATOM   1185  CB  LYS A 341       7.948  -7.327   5.768  1.00 14.18           C  
ATOM   1186  CG  LYS A 341       8.236  -8.163   4.534  1.00 16.69           C  
ATOM   1187  CD  LYS A 341       9.724  -8.142   4.154  1.00 20.88           C  
ATOM   1188  CE  LYS A 341       9.925  -8.475   2.676  1.00 23.34           C  
ATOM   1189  NZ  LYS A 341       9.237  -9.726   2.230  1.00 23.88           N  
ATOM   1190  N   ALA A 342       5.434  -5.526   5.139  1.00 14.40           N  
ATOM   1191  CA  ALA A 342       4.225  -5.287   4.364  1.00 14.83           C  
ATOM   1192  C   ALA A 342       4.239  -3.913   3.693  1.00 14.96           C  
ATOM   1193  O   ALA A 342       3.792  -3.778   2.558  1.00 16.17           O  
ATOM   1194  CB  ALA A 342       2.996  -5.458   5.230  1.00 15.23           C  
ATOM   1195  N   SER A 343       4.769  -2.904   4.385  1.00 14.50           N  
ATOM   1196  CA  SER A 343       4.879  -1.566   3.799  1.00 13.87           C  
ATOM   1197  C   SER A 343       6.020  -1.416   2.804  1.00 14.53           C  
ATOM   1198  O   SER A 343       5.825  -0.792   1.752  1.00 14.54           O  
ATOM   1199  CB  SER A 343       4.987  -0.507   4.887  1.00 13.04           C  
ATOM   1200  OG  SER A 343       3.780  -0.452   5.620  1.00 12.83           O  
ATOM   1201  N   ILE A 344       7.195  -1.969   3.115  1.00 14.73           N  
ATOM   1202  CA  ILE A 344       8.360  -1.802   2.227  1.00 15.64           C  
ATOM   1203  C   ILE A 344       8.189  -2.550   0.906  1.00 16.12           C  
ATOM   1204  O   ILE A 344       8.683  -2.083  -0.127  1.00 16.03           O  
ATOM   1205  CB  ILE A 344       9.750  -2.127   2.890  1.00 15.95           C  
ATOM   1206  CG1 ILE A 344       9.909  -3.622   3.180  1.00 17.09           C  
ATOM   1207  CG2 ILE A 344       9.992  -1.256   4.118  1.00 15.73           C  
ATOM   1208  CD1 ILE A 344      11.208  -3.987   3.890  1.00 17.14           C  
ATOM   1209  N   GLU A 345       7.471  -3.676   0.932  1.00 16.42           N  
ATOM   1210  CA  GLU A 345       7.162  -4.425  -0.295  1.00 17.75           C  
ATOM   1211  C   GLU A 345       6.427  -3.533  -1.298  1.00 16.87           C  
ATOM   1212  O   GLU A 345       6.733  -3.551  -2.494  1.00 17.73           O  
ATOM   1213  CB  GLU A 345       6.314  -5.672   0.006  1.00 17.87           C  
ATOM   1214  CG  GLU A 345       7.064  -6.862   0.623  1.00 20.10           C  
ATOM   1215  CD  GLU A 345       6.138  -7.900   1.265  1.00 20.08           C  
ATOM   1216  OE1 GLU A 345       4.893  -7.749   1.212  1.00 22.57           O  
ATOM   1217  OE2 GLU A 345       6.657  -8.871   1.867  1.00 23.42           O  
ATOM   1218  N   ALA A 346       5.460  -2.764  -0.799  1.00 16.40           N  
ATOM   1219  CA  ALA A 346       4.619  -1.885  -1.621  1.00 16.04           C  
ATOM   1220  C   ALA A 346       5.198  -0.481  -1.816  1.00 15.72           C  
ATOM   1221  O   ALA A 346       4.836   0.225  -2.771  1.00 16.14           O  
ATOM   1222  CB  ALA A 346       3.233  -1.797  -1.004  1.00 16.43           C  
ATOM   1223  N   HIS A 347       6.083  -0.076  -0.907  1.00 15.11           N  
ATOM   1224  CA  HIS A 347       6.678   1.260  -0.915  1.00 14.25           C  
ATOM   1225  C   HIS A 347       8.180   1.152  -0.653  1.00 14.36           C  
ATOM   1226  O   HIS A 347       8.650   1.487   0.429  1.00 14.14           O  
ATOM   1227  CB  HIS A 347       6.011   2.163   0.136  1.00 14.47           C  
ATOM   1228  CG  HIS A 347       4.517   2.199   0.045  1.00 14.80           C  
ATOM   1229  ND1 HIS A 347       3.841   3.061  -0.793  1.00 16.81           N  
ATOM   1230  CD2 HIS A 347       3.570   1.469   0.678  1.00 15.65           C  
ATOM   1231  CE1 HIS A 347       2.542   2.869  -0.659  1.00 16.35           C  
ATOM   1232  NE2 HIS A 347       2.352   1.898   0.216  1.00 17.09           N  
ATOM   1233  N   PRO A 348       8.945   0.674  -1.651  1.00 13.90           N  
ATOM   1234  CA  PRO A 348      10.373   0.394  -1.422  1.00 13.85           C  
ATOM   1235  C   PRO A 348      11.235   1.598  -1.033  1.00 13.56           C  
ATOM   1236  O   PRO A 348      12.314   1.420  -0.457  1.00 13.83           O  
ATOM   1237  CB  PRO A 348      10.851  -0.179  -2.757  1.00 14.15           C  
ATOM   1238  CG  PRO A 348       9.641  -0.389  -3.589  1.00 14.90           C  
ATOM   1239  CD  PRO A 348       8.498   0.338  -3.016  1.00 14.33           C  
ATOM   1240  N   TRP A 349      10.768   2.805  -1.347  1.00 13.09           N  
ATOM   1241  CA  TRP A 349      11.467   4.027  -0.941  1.00 12.21           C  
ATOM   1242  C   TRP A 349      11.542   4.167   0.602  1.00 12.43           C  
ATOM   1243  O   TRP A 349      12.331   4.951   1.135  1.00 12.80           O  
ATOM   1244  CB  TRP A 349      10.812   5.263  -1.591  1.00 12.26           C  
ATOM   1245  CG  TRP A 349       9.332   5.291  -1.404  1.00 11.66           C  
ATOM   1246  CD1 TRP A 349       8.389   4.855  -2.288  1.00 12.02           C  
ATOM   1247  CD2 TRP A 349       8.621   5.729  -0.245  1.00 11.64           C  
ATOM   1248  NE1 TRP A 349       7.130   5.004  -1.760  1.00 13.21           N  
ATOM   1249  CE2 TRP A 349       7.243   5.536  -0.500  1.00 11.79           C  
ATOM   1250  CE3 TRP A 349       9.009   6.284   0.981  1.00 10.97           C  
ATOM   1251  CZ2 TRP A 349       6.253   5.877   0.429  1.00 11.89           C  
ATOM   1252  CZ3 TRP A 349       8.019   6.621   1.906  1.00 11.40           C  
ATOM   1253  CH2 TRP A 349       6.660   6.402   1.628  1.00 11.50           C  
ATOM   1254  N   LEU A 350      10.730   3.398   1.319  1.00 12.25           N  
ATOM   1255  CA  LEU A 350      10.801   3.381   2.782  1.00 12.26           C  
ATOM   1256  C   LEU A 350      12.129   2.802   3.277  1.00 13.57           C  
ATOM   1257  O   LEU A 350      12.547   3.067   4.410  1.00 13.57           O  
ATOM   1258  CB  LEU A 350       9.624   2.591   3.365  1.00 11.55           C  
ATOM   1259  CG  LEU A 350       8.305   3.352   3.520  1.00 11.19           C  
ATOM   1260  CD1 LEU A 350       7.156   2.390   3.879  1.00 10.78           C  
ATOM   1261  CD2 LEU A 350       8.432   4.421   4.598  1.00 11.00           C  
ATOM   1262  N   LYS A 351      12.798   2.032   2.418  1.00 15.06           N  
ATOM   1263  CA  LYS A 351      13.995   1.285   2.832  1.00 17.30           C  
ATOM   1264  C   LYS A 351      15.244   2.127   2.996  1.00 18.85           C  
ATOM   1265  O   LYS A 351      16.227   1.671   3.598  1.00 19.86           O  
ATOM   1266  CB  LYS A 351      14.296   0.164   1.837  1.00 17.07           C  
ATOM   1267  CG  LYS A 351      13.288  -0.951   1.914  1.00 18.40           C  
ATOM   1268  CD  LYS A 351      13.778  -2.188   1.224  1.00 19.73           C  
ATOM   1269  CE  LYS A 351      13.669  -2.012  -0.261  1.00 18.32           C  
ATOM   1270  NZ  LYS A 351      14.080  -3.238  -1.011  1.00 17.65           N  
ATOM   1271  N   HIS A 352      15.218   3.337   2.458  1.00 19.93           N  
ATOM   1272  CA  HIS A 352      16.413   4.164   2.396  1.00 21.31           C  
ATOM   1273  C   HIS A 352      16.282   5.420   3.253  1.00 21.17           C  
ATOM   1274  O   HIS A 352      17.227   6.187   3.413  1.00 21.16           O  
ATOM   1275  CB  HIS A 352      16.698   4.516   0.939  1.00 21.96           C  
ATOM   1276  CG  HIS A 352      16.695   3.326   0.028  1.00 23.47           C  
ATOM   1277  ND1 HIS A 352      17.674   2.357   0.074  1.00 24.72           N  
ATOM   1278  CD2 HIS A 352      15.822   2.935  -0.930  1.00 24.35           C  
ATOM   1279  CE1 HIS A 352      17.413   1.427  -0.829  1.00 24.90           C  
ATOM   1280  NE2 HIS A 352      16.294   1.753  -1.450  1.00 24.95           N  
TER    1281      HIS A 352                                                      
END
MOLECULE T0434_28_195.pdb
ATOM     82  N   MET    28      22.710  14.827  17.394  1.00 19.78          
ATOM     83  CA  MET    28      21.299  14.682  17.865  1.00 18.24          
ATOM     84  CB  MET    28      20.424  15.805  17.271  1.00 16.44          
ATOM     85  CG  MET    28      20.912  17.218  17.730  1.00 16.65          
ATOM     86  SD  MET    28      20.167  18.502  16.727  1.00 17.98          
ATOM     87  CE  MET    28      18.476  18.620  17.315  1.00 23.33          
ATOM     88  C   MET    28      20.680  13.319  17.548  1.00 18.32          
ATOM     89  O   MET    28      19.531  13.041  17.912  1.00 17.04          
ATOM     90  N   THR    29      21.473  12.445  16.928  1.00 17.78          
ATOM     91  CA  THR    29      20.960  11.192  16.376  1.00 17.80          
ATOM     92  CB  THR    29      22.121  10.335  15.802  1.00 17.70          
ATOM     93  OG1 THR    29      22.780  11.076  14.749  1.00 21.06          
ATOM     94  CG2 THR    29      21.604   9.062  15.244  1.00 18.71          
ATOM     95  C   THR    29      20.227  10.375  17.432  1.00 17.25          
ATOM     96  O   THR    29      19.121   9.873  17.171  1.00 17.28          
ATOM     97  N   LEU    30      20.834  10.278  18.620  1.00 17.23          
ATOM     98  CA  LEU    30      20.275   9.453  19.702  1.00 17.85          
ATOM     99  CB  LEU    30      21.339   8.503  20.281  1.00 19.13          
ATOM    100  CG  LEU    30      21.953   7.574  19.231  1.00 20.87          
ATOM    101  CD1 LEU    30      22.994   6.665  19.872  1.00 23.53          
ATOM    102  CD2 LEU    30      20.859   6.766  18.518  1.00 22.15          
ATOM    103  C   LEU    30      19.612  10.240  20.832  1.00 17.63          
ATOM    104  O   LEU    30      19.372   9.666  21.906  1.00 17.70          
ATOM    105  N   TRP    31      19.326  11.531  20.602  1.00 15.78          
ATOM    106  CA  TRP    31      18.640  12.350  21.609  1.00 14.55          
ATOM    107  CB  TRP    31      18.424  13.793  21.146  1.00 16.42          
ATOM    108  CG  TRP    31      19.650  14.661  21.321  1.00 17.59          
ATOM    109  CD1 TRP    31      20.947  14.240  21.580  1.00 19.60          
ATOM    110  NE1 TRP    31      21.802  15.347  21.630  1.00 19.04          
ATOM    111  CE2 TRP    31      21.058  16.486  21.418  1.00 19.29          
ATOM    112  CD2 TRP    31      19.698  16.091  21.193  1.00 14.71          
ATOM    113  CE3 TRP    31      18.726  17.073  20.945  1.00 14.58          
ATOM    114  CZ3 TRP    31      19.140  18.405  20.880  1.00 16.67          
ATOM    115  CH2 TRP    31      20.516  18.761  21.088  1.00 18.25          
ATOM    116  CZ2 TRP    31      21.474  17.813  21.348  1.00 19.58          
ATOM    117  C   TRP    31      17.269  11.732  21.915  1.00 14.34          
ATOM    118  O   TRP    31      16.587  11.198  21.021  1.00 14.50          
ATOM    119  N   THR    32      16.877  11.821  23.176  1.00 14.65          
ATOM    120  CA  THR    32      15.503  11.539  23.586  1.00 15.36          
ATOM    121  CB  THR    32      15.364  11.361  25.108  1.00 16.65          
ATOM    122  OG1 THR    32      15.591  12.639  25.717  1.00 17.36          
ATOM    123  CG2 THR    32      16.382  10.322  25.647  1.00 17.30          
ATOM    124  C   THR    32      14.573  12.716  23.190  1.00 15.38          
ATOM    125  O   THR    32      15.050  13.855  22.940  1.00 14.06          
ATOM    126  N   GLU    33      13.258  12.450  23.183  1.00 14.24          
ATOM    127  CA  GLU    33      12.260  13.520  22.883  1.00 14.48          
ATOM    128  CB  GLU    33      10.818  12.945  22.826  1.00 14.49          
ATOM    129  CG  GLU    33      10.758  11.947  21.647  1.00 15.08          
ATOM    130  CD  GLU    33       9.589  11.017  21.658  1.00 20.43          
ATOM    131  OE1 GLU    33       9.465  10.195  22.610  1.00 18.09          
ATOM    132  OE2 GLU    33       8.822  11.067  20.664  1.00 15.52          
ATOM    133  C   GLU    33      12.368  14.686  23.855  1.00 13.92          
ATOM    134  O   GLU    33      12.319  15.860  23.477  1.00 15.48          
ATOM    135  N   ALA    34      12.634  14.358  25.124  1.00 15.71          
ATOM    136  CA  ALA    34      12.869  15.384  26.117  1.00 15.79          
ATOM    137  CB  ALA    34      13.024  14.704  27.493  1.00 16.80          
ATOM    138  C   ALA    34      14.082  16.251  25.812  1.00 16.09          
ATOM    139  O   ALA    34      14.020  17.481  25.973  1.00 16.84          
ATOM    140  N   GLU    35      15.178  15.620  25.374  1.00 14.28          
ATOM    141  CA  GLU    35      16.379  16.349  24.952  1.00 15.26          
ATOM    142  CB  GLU    35      17.493  15.423  24.540  1.00 16.06          
ATOM    143  CG  GLU    35      18.161  14.737  25.719  1.00 19.35          
ATOM    144  CD  GLU    35      19.350  13.919  25.263  1.00 23.91          
ATOM    145  OE1 GLU    35      20.495  14.486  25.253  1.00 26.50          
ATOM    146  OE2 GLU    35      19.123  12.746  24.865  1.00 18.96          
ATOM    147  C   GLU    35      16.089  17.304  23.795  1.00 14.99          
ATOM    148  O   GLU    35      16.563  18.426  23.788  1.00 16.05          
ATOM    149  N   PHE    36      15.356  16.846  22.780  1.00 14.36          
ATOM    150  CA  PHE    36      15.046  17.765  21.676  1.00 13.81          
ATOM    151  CB  PHE    36      14.157  17.062  20.646  1.00 13.87          
ATOM    152  CG  PHE    36      14.928  16.221  19.650  1.00 11.78          
ATOM    153  CD1 PHE    36      15.593  16.838  18.564  1.00 13.60          
ATOM    154  CE1 PHE    36      16.268  16.088  17.608  1.00 16.46          
ATOM    155  CZ  PHE    36      16.350  14.712  17.747  1.00 14.30          
ATOM    156  CE2 PHE    36      15.697  14.062  18.831  1.00 15.44          
ATOM    157  CD2 PHE    36      15.009  14.824  19.796  1.00 13.05          
ATOM    158  C   PHE    36      14.316  19.023  22.181  1.00 14.40          
ATOM    159  O   PHE    36      14.615  20.160  21.769  1.00 15.15          
ATOM    160  N   GLU    37      13.337  18.821  23.064  1.00 14.68          
ATOM    161  CA  GLU    37      12.519  19.938  23.539  1.00 16.98          
ATOM    162  CB  GLU    37      11.369  19.348  24.342  1.00 18.01          
ATOM    163  CG  GLU    37      10.554  20.275  25.186  1.00 23.72          
ATOM    164  CD  GLU    37       9.511  19.432  25.930  1.00 27.47          
ATOM    165  OE1 GLU    37       9.875  18.505  26.715  1.00 34.28          
ATOM    166  OE2 GLU    37       8.326  19.637  25.686  1.00 32.11          
ATOM    167  C   GLU    37      13.353  20.882  24.395  1.00 17.73          
ATOM    168  O   GLU    37      13.221  22.110  24.278  1.00 19.16          
ATOM    169  N   GLU    38      14.215  20.304  25.227  0.50 17.40          
ATOM    171  CA  GLU    38      15.017  21.091  26.162  0.50 18.23          
ATOM    173  CB  GLU    38      15.565  20.157  27.248  0.50 18.48          
ATOM    175  CG  GLU    38      14.397  19.465  27.945  0.50 19.51          
ATOM    177  CD  GLU    38      14.752  18.347  28.922  0.50 20.95          
ATOM    179  OE1 GLU    38      15.740  17.588  28.722  0.50 24.54          
ATOM    181  OE2 GLU    38      13.977  18.203  29.886  0.50 24.22          
ATOM    183  C   GLU    38      16.106  21.866  25.431  0.50 17.92          
ATOM    185  O   GLU    38      16.274  23.060  25.684  0.50 16.84          
ATOM    187  N   LYS    39      16.757  21.207  24.470  1.00 17.28          
ATOM    188  CA  LYS    39      17.989  21.691  23.846  1.00 17.97          
ATOM    189  CB  LYS    39      19.040  20.570  23.774  1.00 16.75          
ATOM    190  CG  LYS    39      19.539  20.174  25.181  1.00 21.18          
ATOM    191  CD  LYS    39      20.699  19.225  25.121  1.00 22.98          
ATOM    192  CE  LYS    39      20.254  17.826  24.989  1.00 28.16          
ATOM    193  NZ  LYS    39      21.361  16.889  25.421  1.00 30.17          
ATOM    194  C   LYS    39      17.814  22.320  22.470  1.00 18.83          
ATOM    195  O   LYS    39      18.809  22.770  21.898  1.00 20.38          
ATOM    196  N   CYS    40      16.586  22.387  21.953  1.00 19.36          
ATOM    197  CA  CYS    40      16.462  23.043  20.644  1.00 19.86          
ATOM    198  CB  CYS    40      15.131  22.798  19.977  1.00 22.27          
ATOM    199  SG  CYS    40      13.792  23.444  20.865  1.00 29.03          
ATOM    200  C   CYS    40      16.798  24.524  20.816  1.00 18.70          
ATOM    201  O   CYS    40      16.694  25.103  21.950  1.00 17.61          
ATOM    202  N   THR    41      17.254  25.112  19.720  1.00 16.83          
ATOM    203  CA  THR    41      17.712  26.515  19.746  1.00 17.06          
ATOM    204  CB  THR    41      19.047  26.718  18.979  1.00 18.27          
ATOM    205  OG1 THR    41      20.018  25.803  19.487  1.00 22.63          
ATOM    206  CG2 THR    41      19.593  28.145  19.188  1.00 19.10          
ATOM    207  C   THR    41      16.686  27.496  19.198  1.00 16.66          
ATOM    208  O   THR    41      16.436  28.548  19.839  1.00 16.75          
ATOM    209  N   TYR    42      16.088  27.162  18.045  1.00 12.87          
ATOM    210  CA  TYR    42      15.170  28.080  17.361  1.00 12.67          
ATOM    211  CB  TYR    42      15.607  28.309  15.890  1.00 13.10          
ATOM    212  CG  TYR    42      17.027  28.872  15.767  1.00 12.88          
ATOM    213  CD1 TYR    42      17.247  30.257  15.694  1.00 14.19          
ATOM    214  CE1 TYR    42      18.550  30.777  15.581  1.00 13.82          
ATOM    215  CZ  TYR    42      19.641  29.908  15.530  1.00 16.69          
ATOM    216  OH  TYR    42      20.930  30.424  15.398  1.00 18.81          
ATOM    217  CE2 TYR    42      19.442  28.543  15.597  1.00 15.36          
ATOM    218  CD2 TYR    42      18.128  28.017  15.730  1.00 15.71          
ATOM    219  C   TYR    42      13.798  27.427  17.295  1.00 13.11          
ATOM    220  O   TYR    42      13.751  26.216  17.068  1.00 14.24          
ATOM    221  N   ILE    43      12.752  28.223  17.469  1.00 11.01          
ATOM    222  CA  ILE    43      11.384  27.815  17.191  1.00 11.94          
ATOM    223  CB  ILE    43      10.519  27.980  18.452  1.00 12.47          
ATOM    224  CG1 ILE    43      11.012  27.001  19.532  1.00 15.69          
ATOM    225  CD  ILE    43      10.390  27.287  20.858  1.00 21.75          
ATOM    226  CG2 ILE    43       9.044  27.819  18.150  1.00 14.63          
ATOM    227  C   ILE    43      10.821  28.595  16.015  1.00 12.25          
ATOM    228  O   ILE    43      10.865  29.838  15.995  1.00 12.23          
ATOM    229  N   VAL    44      10.220  27.858  15.060  1.00 11.93          
ATOM    230  CA  VAL    44       9.515  28.443  13.933  1.00 13.56          
ATOM    231  CB  VAL    44      10.079  27.937  12.591  1.00 13.50          
ATOM    232  CG1 VAL    44       9.210  28.513  11.420  1.00 15.92          
ATOM    233  CG2 VAL    44      11.565  28.372  12.467  1.00 15.51          
ATOM    234  C   VAL    44       8.029  28.046  14.037  1.00 12.98          
ATOM    235  O   VAL    44       7.691  26.862  13.991  1.00 13.38          
ATOM    236  N   ASN    45       7.172  29.050  14.195  1.00 14.08          
ATOM    237  CA  ASN    45       5.726  28.822  14.157  1.00 15.60          
ATOM    238  CB  ASN    45       4.994  29.909  14.979  1.00 17.66          
ATOM    239  CG  ASN    45       5.453  29.940  16.430  1.00 21.37          
ATOM    240  OD1 ASN    45       5.853  30.988  16.960  1.00 29.92          
ATOM    241  ND2 ASN    45       5.385  28.826  17.067  1.00 20.39          
ATOM    242  C   ASN    45       5.206  28.826  12.726  1.00 15.77          
ATOM    243  O   ASN    45       5.837  29.398  11.821  1.00 16.24          
ATOM    244  N   ASP    46       4.033  28.202  12.527  1.00 15.84          
ATOM    245  CA  ASP    46       3.355  28.262  11.235  1.00 16.26          
ATOM    246  CB  ASP    46       2.035  27.483  11.295  1.00 15.83          
ATOM    247  CG  ASP    46       2.239  25.960  11.339  1.00 18.14          
ATOM    248  OD1 ASP    46       3.421  25.457  11.333  1.00 14.65          
ATOM    249  OD2 ASP    46       1.177  25.267  11.376  1.00 19.23          
ATOM    250  C   ASP    46       3.036  29.699  10.860  1.00 18.28          
ATOM    251  O   ASP    46       2.896  30.583  11.732  1.00 17.17          
ATOM    252  N   HSD    47       2.938  29.925   9.556  1.00 19.20          
ATOM    253  CA  HSD    47       2.459  31.198   9.048  1.00 23.44          
ATOM    254  CB  HSD    47       2.523  31.192   7.519  1.00 22.82          
ATOM    255  CG  HSD    47       2.537  32.564   6.912  1.00 28.42          
ATOM    256  ND1 HSD    47       1.427  33.379   6.906  1.00 31.75          
ATOM    257  CE1 HSD    47       1.728  34.525   6.316  1.00 33.30          
ATOM    258  NE2 HSD    47       2.994  34.482   5.943  1.00 32.97          
ATOM    259  CD2 HSD    47       3.524  33.266   6.300  1.00 31.82          
ATOM    260  C   HSD    47       1.022  31.409   9.524  1.00 26.19          
ATOM    261  O   HSD    47       0.193  30.500   9.450  1.00 26.23          
ATOM    262  N   PRO    48       0.719  32.609  10.049  1.00 31.08          
ATOM    263  CA  PRO    48      -0.696  32.829  10.326  1.00 34.22          
ATOM    264  CB  PRO    48      -0.700  34.003  11.315  1.00 34.52          
ATOM    265  CG  PRO    48       0.675  34.633  11.239  1.00 33.47          
ATOM    266  CD  PRO    48       1.581  33.744  10.418  1.00 31.00          
ATOM    267  C   PRO    48      -1.420  33.194   9.018  1.00 37.08          
ATOM    268  O   PRO    48      -0.911  34.043   8.278  1.00 38.33          
ATOM    269  N   TRP    49      -2.518  32.508   8.677  1.00 40.00          
ATOM    270  CA  TRP    49      -2.912  31.232   9.308  1.00 42.35          
ATOM    271  CB  TRP    49      -3.776  31.469  10.562  1.00 42.82          
ATOM    281  C   TRP    49      -3.609  30.226   8.352  1.00 43.56          
ATOM    282  O   TRP    49      -3.391  29.001   8.449  1.00 44.42          
ATOM    283  N   ASP    50      -4.416  30.755   7.432  1.00 44.30          
ATOM    284  CA  ASP    50      -5.542  30.026   6.803  1.00 44.39          
ATOM    285  CB  ASP    50      -5.526  30.158   5.276  1.00 44.42          
ATOM    289  C   ASP    50      -5.769  28.573   7.240  1.00 44.61          
ATOM    290  O   ASP    50      -6.798  27.968   6.900  1.00 44.49          
ATOM    291  N   VAL    59      -5.927  27.135   1.045  1.00 26.15          
ATOM    292  CA  VAL    59      -6.207  26.019   1.934  1.00 25.10          
ATOM    293  CB  VAL    59      -6.274  24.693   1.139  1.00 26.39          
ATOM    294  CG1 VAL    59      -4.953  24.311   0.581  1.00 27.69          
ATOM    295  CG2 VAL    59      -6.803  23.602   1.990  1.00 29.51          
ATOM    296  C   VAL    59      -5.174  25.938   3.082  1.00 23.55          
ATOM    297  O   VAL    59      -4.000  26.283   2.865  1.00 21.72          
ATOM    298  N   GLN    60      -5.614  25.476   4.257  1.00 21.01          
ATOM    299  CA  GLN    60      -4.779  25.460   5.454  1.00 20.78          
ATOM    300  CB  GLN    60      -5.455  24.766   6.634  1.00 20.80          
ATOM    301  CG  GLN    60      -4.588  24.842   7.884  1.00 23.84          
ATOM    302  CD  GLN    60      -5.248  24.287   9.135  1.00 28.68          
ATOM    303  OE1 GLN    60      -6.307  23.636   9.087  1.00 29.66          
ATOM    304  NE2 GLN    60      -4.607  24.517  10.257  1.00 30.78          
ATOM    305  C   GLN    60      -3.430  24.813   5.229  1.00 19.39          
ATOM    306  O   GLN    60      -2.402  25.369   5.684  1.00 19.88          
ATOM    307  N   ALA    61      -3.391  23.638   4.583  1.00 17.44          
ATOM    308  CA  ALA    61      -2.100  22.951   4.428  1.00 18.20          
ATOM    309  CB  ALA    61      -2.275  21.589   3.799  1.00 17.98          
ATOM    310  C   ALA    61      -1.043  23.780   3.661  1.00 17.28          
ATOM    311  O   ALA    61       0.166  23.668   3.919  1.00 17.04          
ATOM    312  N   GLU    62      -1.494  24.569   2.686  1.00 17.87          
ATOM    313  CA  GLU    62      -0.578  25.436   1.963  1.00 18.97          
ATOM    314  CB  GLU    62      -1.120  25.732   0.588  1.00 19.00          
ATOM    315  CG  GLU    62      -0.985  24.572  -0.319  1.00 24.17          
ATOM    316  CD  GLU    62      -1.560  24.881  -1.682  1.00 33.12          
ATOM    317  OE1 GLU    62      -2.285  25.919  -1.834  1.00 36.40          
ATOM    318  OE2 GLU    62      -1.270  24.076  -2.586  1.00 35.12          
ATOM    319  C   GLU    62      -0.321  26.765   2.668  1.00 18.29          
ATOM    320  O   GLU    62       0.851  27.193   2.742  1.00 19.29          
ATOM    321  N   ALA    63      -1.390  27.420   3.135  1.00 18.06          
ATOM    322  CA  ALA    63      -1.314  28.751   3.751  1.00 18.44          
ATOM    323  CB  ALA    63      -2.721  29.311   4.025  1.00 19.44          
ATOM    324  C   ALA    63      -0.468  28.808   5.023  1.00 17.52          
ATOM    325  O   ALA    63       0.049  29.876   5.396  1.00 18.37          
ATOM    326  N   SER    64      -0.361  27.660   5.696  1.00 15.71          
ATOM    327  CA  SER    64       0.334  27.577   6.993  1.00 15.68          
ATOM    328  CB  SER    64      -0.180  26.369   7.778  1.00 14.33          
ATOM    329  OG  SER    64       0.087  25.144   7.095  1.00 14.10          
ATOM    330  C   SER    64       1.843  27.496   6.857  1.00 14.57          
ATOM    331  O   SER    64       2.543  27.568   7.861  1.00 13.79          
ATOM    332  N   LEU    65       2.364  27.346   5.631  1.00 14.87          
ATOM    333  CA  LEU    65       3.786  27.096   5.430  1.00 15.15          
ATOM    334  CB  LEU    65       4.104  26.936   3.932  1.00 14.80          
ATOM    335  CG  LEU    65       5.575  26.586   3.636  1.00 15.36          
ATOM    336  CD1 LEU    65       5.848  25.132   4.056  1.00 13.77          
ATOM    337  CD2 LEU    65       5.877  26.755   2.136  1.00 17.23          
ATOM    338  C   LEU    65       4.590  28.303   5.943  1.00 15.05          
ATOM    339  O   LEU    65       4.340  29.452   5.495  1.00 15.23          
ATOM    340  N   PRO    66       5.552  28.081   6.854  1.00 15.76          
ATOM    341  CA  PRO    66       6.399  29.154   7.410  1.00 17.02          
ATOM    342  CB  PRO    66       7.371  28.408   8.342  1.00 17.30          
ATOM    343  CG  PRO    66       6.800  27.128   8.570  1.00 17.27          
ATOM    344  CD  PRO    66       5.793  26.788   7.514  1.00 15.70          
ATOM    345  C   PRO    66       7.187  29.915   6.323  1.00 17.35          
ATOM    346  O   PRO    66       7.545  29.332   5.280  1.00 17.10          
ATOM    347  N   ARG    67       7.430  31.207   6.582  1.00 18.77          
ATOM    348  CA  ARG    67       8.086  32.079   5.572  1.00 20.15          
ATOM    349  CB  ARG    67       8.061  33.570   6.003  1.00 21.02          
ATOM    350  CG  ARG    67       8.787  33.825   7.286  1.00 22.69          
ATOM    351  CD  ARG    67       8.447  35.209   7.927  1.00 26.34          
ATOM    352  NE  ARG    67       8.029  36.247   6.979  1.00 36.41          
ATOM    353  CZ  ARG    67       8.633  37.432   6.795  1.00 41.68          
ATOM    354  NH1 ARG    67       9.708  37.786   7.506  1.00 44.31          
ATOM    355  NH2 ARG    67       8.144  38.291   5.905  1.00 42.68          
ATOM    356  C   ARG    67       9.517  31.670   5.173  1.00 18.74          
ATOM    357  O   ARG    67      10.043  32.182   4.173  1.00 19.89          
ATOM    358  N   ASN    68      10.163  30.800   5.940  1.00 15.37          
ATOM    359  CA  ASN    68      11.514  30.325   5.590  1.00 14.50          
ATOM    360  CB  ASN    68      12.399  30.122   6.833  1.00 15.41          
ATOM    361  CG  ASN    68      11.789  29.172   7.860  1.00 14.32          
ATOM    362  OD1 ASN    68      10.602  28.850   7.813  1.00 16.59          
ATOM    363  ND2 ASN    68      12.619  28.727   8.811  1.00 18.03          
ATOM    364  C   ASN    68      11.526  29.048   4.707  1.00 14.25          
ATOM    365  O   ASN    68      12.583  28.491   4.429  1.00 13.94          
ATOM    366  N   LEU    69      10.337  28.629   4.295  1.00 14.61          
ATOM    367  CA  LEU    69      10.167  27.403   3.458  1.00 13.42          
ATOM    368  CB  LEU    69       9.382  26.315   4.247  1.00 14.11          
ATOM    369  CG  LEU    69      10.015  25.935   5.609  1.00 11.97          
ATOM    370  CD1 LEU    69       9.077  24.914   6.305  1.00 13.08          
ATOM    371  CD2 LEU    69      11.416  25.379   5.473  1.00 13.82          
ATOM    372  C   LEU    69       9.413  27.720   2.164  1.00 14.14          
ATOM    373  O   LEU    69       8.700  28.745   2.048  1.00 14.04          
ATOM    374  N   LEU    70       9.554  26.806   1.199  1.00 13.81          
ATOM    375  CA  LEU    70       8.808  26.870  -0.065  1.00 16.55          
ATOM    376  CB  LEU    70       9.755  27.326  -1.193  1.00 17.65          
ATOM    377  CG  LEU    70      10.059  28.801  -1.268  1.00 24.52          
ATOM    378  CD1 LEU    70      11.290  28.953  -2.195  1.00 28.31          
ATOM    379  CD2 LEU    70       8.833  29.622  -1.755  1.00 28.72          
ATOM    380  C   LEU    70       8.382  25.468  -0.384  1.00 15.79          
ATOM    381  O   LEU    70       9.022  24.503   0.058  1.00 15.09          
ATOM    382  N   PHE    71       7.353  25.348  -1.202  1.00 14.97          
ATOM    383  CA  PHE    71       6.945  24.014  -1.698  1.00 14.95          
ATOM    384  CB  PHE    71       5.450  23.996  -2.033  1.00 16.13          
ATOM    385  CG  PHE    71       4.576  24.033  -0.806  1.00 16.21          
ATOM    386  CD1 PHE    71       4.756  23.058   0.186  1.00 17.25          
ATOM    387  CE1 PHE    71       3.958  23.057   1.353  1.00 14.53          
ATOM    388  CZ  PHE    71       2.975  24.023   1.523  1.00 16.25          
ATOM    389  CE2 PHE    71       2.787  25.043   0.541  1.00 17.53          
ATOM    390  CD2 PHE    71       3.611  25.039  -0.622  1.00 16.03          
ATOM    391  C   PHE    71       7.751  23.598  -2.904  1.00 16.05          
ATOM    392  O   PHE    71       8.185  24.461  -3.686  1.00 16.42          
ATOM    393  N   LYS    72       7.947  22.295  -3.058  0.50 15.73          
ATOM    395  CA  LYS    72       8.436  21.711  -4.293  0.50 16.54          
ATOM    397  CB  LYS    72       9.409  20.564  -3.990  0.50 16.75          
ATOM    399  CG  LYS    72       9.779  19.733  -5.217  0.50 17.42          
ATOM    401  CD  LYS    72      10.834  18.671  -4.952  0.50 18.55          
ATOM    403  CE  LYS    72      10.335  17.507  -4.133  0.50 24.08          
ATOM    405  NZ  LYS    72      11.177  16.300  -4.423  0.50 25.83          
ATOM    407  C   LYS    72       7.219  21.179  -5.042  0.50 15.93          
ATOM    409  O   LYS    72       6.388  20.461  -4.463  0.50 14.18          
ATOM    411  N   TYR    73       7.141  21.516  -6.333  1.00 16.47          
ATOM    412  CA  TYR    73       5.971  21.229  -7.167  1.00 16.86          
ATOM    413  CB  TYR    73       5.430  22.499  -7.835  1.00 17.70          
ATOM    414  CG  TYR    73       4.954  23.552  -6.873  1.00 16.61          
ATOM    415  CD1 TYR    73       3.645  23.533  -6.369  1.00 17.63          
ATOM    416  CE1 TYR    73       3.221  24.484  -5.462  1.00 19.28          
ATOM    417  CZ  TYR    73       4.136  25.473  -5.051  1.00 19.77          
ATOM    418  OH  TYR    73       3.770  26.440  -4.153  1.00 21.63          
ATOM    419  CE2 TYR    73       5.438  25.479  -5.515  1.00 19.30          
ATOM    420  CD2 TYR    73       5.836  24.521  -6.418  1.00 19.07          
ATOM    421  C   TYR    73       6.315  20.212  -8.233  1.00 17.00          
ATOM    422  O   TYR    73       7.439  20.195  -8.727  1.00 17.19          
ATOM    423  N   ALA    74       5.334  19.393  -8.596  1.00 16.13          
ATOM    424  CA  ALA    74       5.465  18.515  -9.747  1.00 16.27          
ATOM    425  CB  ALA    74       4.254  17.604  -9.866  1.00 17.32          
ATOM    426  C   ALA    74       5.662  19.380 -10.999  1.00 15.25          
ATOM    427  O   ALA    74       5.206  20.523 -11.077  1.00 16.03          
ATOM    428  N   THR    75       6.435  18.841 -11.922  1.00 16.05          
ATOM    429  CA  THR    75       6.798  19.592 -13.124  1.00 16.60          
ATOM    430  CB  THR    75       7.687  18.708 -14.018  1.00 16.95          
ATOM    431  OG1 THR    75       8.863  18.346 -13.269  1.00 19.26          
ATOM    432  CG2 THR    75       8.133  19.490 -15.279  1.00 17.73          
ATOM    433  C   THR    75       5.545  20.047 -13.893  1.00 16.42          
ATOM    434  O   THR    75       4.630  19.241 -14.115  1.00 17.08          
ATOM    435  N   ASN    76       5.554  21.315 -14.306  1.00 16.48          
ATOM    436  CA  ASN    76       4.437  21.942 -15.048  1.00 17.36          
ATOM    437  CB  ASN    76       4.255  21.262 -16.406  1.00 18.02          
ATOM    438  CG  ASN    76       5.499  21.311 -17.258  1.00 16.87          
ATOM    439  OD1 ASN    76       6.321  22.211 -17.100  1.00 19.69          
ATOM    440  ND2 ASN    76       5.648  20.322 -18.140  1.00 17.68          
ATOM    441  C   ASN    76       3.102  21.855 -14.287  1.00 18.91          
ATOM    442  O   ASN    76       2.031  21.749 -14.900  1.00 19.80          
ATOM    443  N   SER    77       3.148  21.880 -12.958  1.00 18.81          
ATOM    444  CA  SER    77       1.935  21.544 -12.188  1.00 20.90          
ATOM    445  CB  SER    77       2.005  20.067 -11.784  1.00 21.55          
ATOM    446  OG  SER    77       0.913  19.637 -10.986  1.00 25.81          
ATOM    447  C   SER    77       1.924  22.410 -10.945  1.00 21.23          
ATOM    448  O   SER    77       2.944  22.991 -10.576  1.00 21.33          
ATOM    449  N   GLU    78       0.748  22.497 -10.319  1.00 20.85          
ATOM    450  CA  GLU    78       0.602  23.249  -9.053  1.00 22.23          
ATOM    451  CB  GLU    78      -0.607  24.211  -9.127  1.00 23.52          
ATOM    452  CG  GLU    78      -0.308  25.500  -9.926  1.00 25.99          
ATOM    456  C   GLU    78       0.501  22.232  -7.908  1.00 22.37          
ATOM    457  O   GLU    78       0.320  22.606  -6.732  1.00 23.29          
ATOM    458  N   GLU    79       0.687  20.962  -8.248  1.00 20.86          
ATOM    459  CA  GLU    79       0.692  19.890  -7.258  1.00 21.19          
ATOM    460  CB  GLU    79       0.560  18.521  -7.930  1.00 20.46          
ATOM    461  CG  GLU    79       0.421  17.349  -6.918  1.00 25.17          
ATOM    462  CD  GLU    79       0.689  15.928  -7.497  1.00 27.51          
ATOM    463  OE1 GLU    79       1.138  15.780  -8.672  1.00 34.41          
ATOM    464  OE2 GLU    79       0.452  14.937  -6.748  1.00 33.89          
ATOM    465  C   GLU    79       1.963  19.957  -6.383  1.00 19.67          
ATOM    466  O   GLU    79       3.086  19.914  -6.875  1.00 18.93          
ATOM    467  N   VAL    80       1.762  20.048  -5.066  1.00 18.30          
ATOM    468  CA  VAL    80       2.881  19.990  -4.117  1.00 17.49          
ATOM    469  CB  VAL    80       2.451  20.578  -2.737  1.00 17.83          
ATOM    470  CG1 VAL    80       3.622  20.422  -1.736  1.00 18.43          
ATOM    471  CG2 VAL    80       1.980  22.023  -2.898  1.00 17.44          
ATOM    472  C   VAL    80       3.404  18.572  -3.906  1.00 17.20          
ATOM    473  O   VAL    80       2.594  17.623  -3.645  1.00 17.99          
ATOM    474  N   ILE    81       4.719  18.404  -4.016  1.00 16.20          
ATOM    475  CA  ILE    81       5.324  17.100  -3.862  1.00 17.33          
ATOM    476  CB  ILE    81       5.787  16.501  -5.201  1.00 17.88          
ATOM    477  CG1 ILE    81       6.922  17.342  -5.785  1.00 20.06          
ATOM    478  CD  ILE    81       7.566  16.740  -7.048  1.00 19.02          
ATOM    479  CG2 ILE    81       4.560  16.348  -6.155  1.00 18.54          
ATOM    480  C   ILE    81       6.430  16.999  -2.799  1.00 16.82          
ATOM    481  O   ILE    81       7.078  15.991  -2.705  1.00 19.47          
ATOM    482  N   GLY    82       6.649  18.081  -2.042  1.00 15.25          
ATOM    483  CA  GLY    82       7.653  18.096  -0.990  1.00 14.34          
ATOM    484  C   GLY    82       7.784  19.520  -0.475  1.00 13.70          
ATOM    485  O   GLY    82       7.075  20.464  -0.907  1.00 14.62          
ATOM    486  N   VAL    83       8.687  19.656   0.509  1.00 12.84          
ATOM    487  CA  VAL    83       8.967  20.955   1.112  1.00 12.53          
ATOM    488  CB  VAL    83       8.491  21.028   2.587  1.00 12.20          
ATOM    489  CG1 VAL    83       8.692  22.495   3.092  1.00 13.29          
ATOM    490  CG2 VAL    83       7.003  20.630   2.708  1.00 12.24          
ATOM    491  C   VAL    83      10.467  21.239   1.059  1.00 12.63          
ATOM    492  O   VAL    83      11.277  20.333   1.358  1.00 12.49          
ATOM    493  N   MET    84      10.833  22.478   0.686  1.00 14.04          
ATOM    494  CA  MET    84      12.234  22.904   0.554  1.00 14.40          
ATOM    495  CB  MET    84      12.531  23.401  -0.890  1.00 16.25          
ATOM    496  CG  MET    84      11.858  22.618  -1.952  1.00 21.35          
ATOM    497  SD  MET    84      12.742  21.089  -2.146  1.00 27.24          
ATOM    498  CE  MET    84      14.342  21.548  -2.854  1.00 27.88          
ATOM    499  C   MET    84      12.499  24.087   1.459  1.00 13.20          
ATOM    500  O   MET    84      11.574  24.847   1.818  1.00 14.32          
ATOM    501  N   SER    85      13.763  24.287   1.809  1.00 14.02          
ATOM    502  CA  SER    85      14.136  25.507   2.522  1.00 14.15          
ATOM    503  CB  SER    85      15.511  25.346   3.167  1.00 15.63          
ATOM    504  OG  SER    85      16.420  24.974   2.151  1.00 17.63          
ATOM    505  C   SER    85      14.163  26.702   1.524  1.00 15.94          
ATOM    506  O   SER    85      14.564  26.520   0.371  1.00 16.77          
ATOM    507  N   LYS    86      13.701  27.872   1.953  1.00 16.35          
ATOM    508  CA  LYS    86      13.855  29.132   1.185  1.00 17.71          
ATOM    509  CB  LYS    86      12.744  30.092   1.568  1.00 17.93          
ATOM    510  CG  LYS    86      12.433  31.201   0.557  1.00 23.49          
ATOM    511  CD  LYS    86      10.951  31.515   0.645  1.00 29.93          
ATOM    512  CE  LYS    86      10.662  32.888   1.106  1.00 35.77          
ATOM    513  NZ  LYS    86      10.117  33.624  -0.084  1.00 39.08          
ATOM    514  C   LYS    86      15.196  29.818   1.461  1.00 18.54          
ATOM    515  O   LYS    86      15.670  30.657   0.651  1.00 20.66          
ATOM    516  N   GLU    87      15.803  29.463   2.588  1.00 17.63          
ATOM    517  CA  GLU    87      16.966  30.131   3.156  1.00 18.40          
ATOM    518  CB  GLU    87      16.474  31.306   4.021  1.00 18.33          
ATOM    519  CG  GLU    87      15.611  30.855   5.216  1.00 19.93          
ATOM    520  CD  GLU    87      15.027  32.041   5.985  1.00 21.76          
ATOM    521  OE1 GLU    87      15.405  32.168   7.179  1.00 24.58          
ATOM    522  OE2 GLU    87      14.236  32.832   5.400  1.00 24.56          
ATOM    523  C   GLU    87      17.686  29.100   4.029  1.00 17.31          
ATOM    524  O   GLU    87      17.171  27.981   4.236  1.00 17.58          
ATOM    525  N   TYR    88      18.859  29.444   4.547  1.00 16.95          
ATOM    526  CA  TYR    88      19.611  28.553   5.426  1.00 16.85          
ATOM    527  CB  TYR    88      20.938  29.217   5.769  1.00 18.31          
ATOM    528  CG  TYR    88      21.820  28.437   6.700  1.00 18.55          
ATOM    529  CD1 TYR    88      22.704  27.469   6.220  1.00 20.39          
ATOM    530  CE1 TYR    88      23.528  26.747   7.098  1.00 19.51          
ATOM    531  CZ  TYR    88      23.461  27.020   8.463  1.00 21.32          
ATOM    532  OH  TYR    88      24.251  26.354   9.381  1.00 22.99          
ATOM    533  CE2 TYR    88      22.598  27.961   8.951  1.00 21.74          
ATOM    534  CD2 TYR    88      21.780  28.677   8.064  1.00 21.32          
ATOM    535  C   TYR    88      18.800  28.352   6.715  1.00 16.15          
ATOM    536  O   TYR    88      18.456  29.334   7.390  1.00 17.34          
ATOM    537  N   ILE    89      18.505  27.098   7.040  0.50 15.14          
ATOM    539  CA  ILE    89      17.796  26.794   8.289  0.50 14.38          
ATOM    541  CB  ILE    89      16.600  25.853   8.086  0.50 13.69          
ATOM    543  CG1 ILE    89      15.698  26.346   6.941  0.50 14.60          
ATOM    545  CD  ILE    89      14.570  25.428   6.652  0.50 15.43          
ATOM    547  CG2 ILE    89      15.840  25.722   9.429  0.50 13.55          
ATOM    549  C   ILE    89      18.785  26.177   9.266  0.50 13.94          
ATOM    551  O   ILE    89      19.391  25.127   8.985  0.50 14.27          
ATOM    553  N   PRO    90      18.991  26.835  10.417  1.00 14.31          
ATOM    554  CA  PRO    90      19.989  26.315  11.356  1.00 14.56          
ATOM    555  CB  PRO    90      19.937  27.324  12.523  1.00 16.05          
ATOM    556  CG  PRO    90      19.348  28.545  11.927  1.00 14.96          
ATOM    557  CD  PRO    90      18.373  28.088  10.894  1.00 14.78          
ATOM    558  C   PRO    90      19.661  24.927  11.917  1.00 14.71          
ATOM    559  O   PRO    90      18.469  24.543  12.018  1.00 14.88          
ATOM    560  N   LYS    91      20.705  24.187  12.312  1.00 14.72          
ATOM    561  CA  LYS    91      20.500  22.969  13.141  1.00 14.58          
ATOM    562  CB  LYS    91      21.870  22.407  13.522  1.00 15.71          
ATOM    563  CG  LYS    91      21.877  21.118  14.283  1.00 15.58          
ATOM    564  CD  LYS    91      23.349  20.651  14.409  1.00 17.28          
ATOM    565  CE  LYS    91      23.484  19.497  15.377  1.00 22.55          
ATOM    566  NZ  LYS    91      24.851  18.916  15.283  1.00 22.53          
ATOM    567  C   LYS    91      19.785  23.346  14.434  1.00 15.49          
ATOM    568  O   LYS    91      19.988  24.445  14.965  1.00 16.19          
ATOM    569  N   GLY    92      18.949  22.438  14.946  1.00 13.05          
ATOM    570  CA  GLY    92      18.282  22.730  16.214  1.00 12.66          
ATOM    571  C   GLY    92      17.103  23.683  16.080  1.00 13.78          
ATOM    572  O   GLY    92      16.811  24.436  17.014  1.00 15.12          
ATOM    573  N   THR    93      16.387  23.614  14.948  1.00 11.99          
ATOM    574  CA  THR    93      15.207  24.438  14.714  1.00 11.70          
ATOM    575  CB  THR    93      15.250  25.063  13.296  1.00 11.96          
ATOM    576  OG1 THR    93      16.375  25.929  13.175  1.00 12.00          
ATOM    577  CG2 THR    93      13.947  25.794  12.962  1.00 12.31          
ATOM    578  C   THR    93      13.962  23.531  14.826  1.00 12.95          
ATOM    579  O   THR    93      13.924  22.481  14.202  1.00 13.33          
ATOM    580  N   ARG    94      12.978  23.975  15.577  1.00 11.99          
ATOM    581  CA  ARG    94      11.729  23.209  15.744  1.00 11.16          
ATOM    582  CB  ARG    94      11.239  23.291  17.191  1.00 11.03          
ATOM    583  CG  ARG    94      10.093  22.337  17.452  1.00 12.73          
ATOM    584  CD  ARG    94       9.397  22.718  18.775  1.00 12.62          
ATOM    585  NE  ARG    94       8.467  23.823  18.575  1.00 12.88          
ATOM    586  CZ  ARG    94       7.756  24.398  19.546  1.00 15.88          
ATOM    587  NH1 ARG    94       7.935  23.990  20.822  1.00 17.05          
ATOM    588  NH2 ARG    94       6.892  25.355  19.255  1.00 16.72          
ATOM    589  C   ARG    94      10.623  23.786  14.846  1.00 11.67          
ATOM    590  O   ARG    94      10.381  25.005  14.820  1.00 12.02          
ATOM    591  N   PHE    95       9.953  22.899  14.109  1.00  9.96          
ATOM    592  CA  PHE    95       8.726  23.188  13.368  1.00 11.29          
ATOM    593  CB  PHE    95       8.875  22.662  11.927  1.00 10.89          
ATOM    594  CG  PHE    95       9.935  23.438  11.148  1.00 11.90          
ATOM    595  CD1 PHE    95       9.612  24.672  10.566  1.00 10.68          
ATOM    596  CE1 PHE    95      10.604  25.398   9.852  1.00 12.46          
ATOM    597  CZ  PHE    95      11.882  24.881   9.704  1.00 12.83          
ATOM    598  CE2 PHE    95      12.236  23.660  10.299  1.00 16.34          
ATOM    599  CD2 PHE    95      11.221  22.928  11.016  1.00 13.85          
ATOM    600  C   PHE    95       7.558  22.442  14.004  1.00 11.18          
ATOM    601  O   PHE    95       7.742  21.305  14.558  1.00 10.62          
ATOM    602  N   GLY    96       6.376  23.039  13.887  1.00 11.84          
ATOM    603  CA  GLY    96       5.212  22.365  14.370  1.00 12.80          
ATOM    604  C   GLY    96       4.491  23.215  15.385  1.00 13.65          
ATOM    605  O   GLY    96       4.883  24.378  15.627  1.00 13.94          
ATOM    606  N   PRO    97       3.454  22.638  16.013  1.00 13.15          
ATOM    607  CA  PRO    97       3.098  21.231  15.993  1.00 12.40          
ATOM    608  CB  PRO    97       2.095  21.087  17.179  1.00 13.91          
ATOM    609  CG  PRO    97       1.437  22.477  17.240  1.00 15.24          
ATOM    610  CD  PRO    97       2.583  23.464  16.879  1.00 12.75          
ATOM    611  C   PRO    97       2.372  20.813  14.686  1.00 12.60          
ATOM    612  O   PRO    97       1.772  21.653  13.985  1.00 12.07          
ATOM    613  N   LEU    98       2.395  19.525  14.401  0.50 11.70          
ATOM    615  CA  LEU    98       1.549  18.973  13.367  0.50 11.62          
ATOM    617  CB  LEU    98       1.704  17.459  13.340  0.50 10.71          
ATOM    619  CG  LEU    98       0.899  16.722  12.260  0.50 10.41          
ATOM    621  CD1 LEU    98       0.922  15.218  12.501  0.50 11.83          
ATOM    623  CD2 LEU    98       1.503  17.052  10.925  0.50  7.02          
ATOM    625  C   LEU    98       0.078  19.334  13.653  0.50 11.39          
ATOM    627  O   LEU    98      -0.371  19.333  14.809  0.50 10.54          
ATOM    629  N   ILE    99      -0.659  19.627  12.592  0.50 12.83          
ATOM    631  CA  ILE    99      -2.111  19.755  12.674  0.50 13.21          
ATOM    633  CB  ILE    99      -2.592  21.183  12.386  0.50 13.27          
ATOM    635  CG1 ILE    99      -1.934  22.215  13.318  0.50 14.94          
ATOM    637  CD  ILE    99      -2.230  23.645  12.943  0.50 12.88          
ATOM    639  CG2 ILE    99      -4.120  21.271  12.483  0.50 14.70          
ATOM    641  C   ILE    99      -2.746  18.786  11.647  0.50 14.16          
ATOM    643  O   ILE    99      -2.300  18.712  10.478  0.50 12.98          
ATOM    645  N   GLY   100      -3.754  18.041  12.109  1.00 15.37          
ATOM    646  CA  GLY   100      -4.553  17.138  11.280  1.00 15.82          
ATOM    647  C   GLY   100      -5.812  16.699  12.029  1.00 17.98          
ATOM    648  O   GLY   100      -6.031  17.056  13.189  1.00 17.57          
ATOM    649  N   GLU   101      -6.638  15.952  11.340  1.00 19.46          
ATOM    650  CA  GLU   101      -7.813  15.344  12.013  1.00 19.71          
ATOM    651  CB  GLU   101      -8.753  14.735  10.983  1.00 20.68          
ATOM    652  CG  GLU   101      -9.311  15.782  10.083  1.00 25.97          
ATOM    653  CD  GLU   101     -10.287  15.171   9.132  1.00 35.44          
ATOM    654  OE1 GLU   101      -9.834  14.602   8.106  1.00 36.71          
ATOM    655  OE2 GLU   101     -11.508  15.243   9.438  1.00 39.39          
ATOM    656  C   GLU   101      -7.369  14.291  12.973  1.00 20.04          
ATOM    657  O   GLU   101      -6.392  13.576  12.714  1.00 20.89          
ATOM    658  N   ILE   102      -8.059  14.171  14.107  0.50 19.71          
ATOM    660  CA  ILE   102      -7.649  13.208  15.135  0.50 20.08          
ATOM    662  CB  ILE   102      -7.413  13.880  16.513  0.50 20.37          
ATOM    664  CG1 ILE   102      -6.132  14.717  16.498  0.50 19.29          
ATOM    666  CD  ILE   102      -5.988  15.628  17.727  0.50 19.88          
ATOM    668  CG2 ILE   102      -7.296  12.824  17.619  0.50 19.99          
ATOM    670  C   ILE   102      -8.670  12.088  15.298  0.50 20.97          
ATOM    672  O   ILE   102      -9.860  12.362  15.505  0.50 19.82          
ATOM    674  N   TYR   103      -8.179  10.853  15.195  1.00 21.95          
ATOM    675  CA  TYR   103      -8.993   9.624  15.280  1.00 24.99          
ATOM    676  CB  TYR   103      -8.947   8.863  13.963  1.00 25.47          
ATOM    677  CG  TYR   103      -9.443   9.641  12.769  1.00 27.85          
ATOM    678  CD1 TYR   103     -10.756  10.119  12.729  1.00 28.34          
ATOM    679  CE1 TYR   103     -11.241  10.842  11.621  1.00 30.15          
ATOM    680  CZ  TYR   103     -10.413  11.104  10.550  1.00 30.42          
ATOM    681  OH  TYR   103     -10.928  11.826   9.474  1.00 31.71          
ATOM    682  CE2 TYR   103      -9.087  10.642  10.554  1.00 28.30          
ATOM    683  CD2 TYR   103      -8.611   9.901  11.669  1.00 25.95          
ATOM    684  C   TYR   103      -8.504   8.738  16.413  1.00 27.26          
ATOM    685  O   TYR   103      -7.316   8.699  16.718  1.00 25.00          
ATOM    686  N   THR   104      -9.428   8.038  17.078  1.00 30.44          
ATOM    687  CA  THR   104      -9.015   6.942  17.967  1.00 33.84          
ATOM    688  CB  THR   104      -9.678   6.957  19.395  1.00 34.84          
ATOM    689  OG1 THR   104     -11.098   7.106  19.282  1.00 36.75          
ATOM    690  CG2 THR   104      -9.126   8.072  20.265  1.00 34.23          
ATOM    691  C   THR   104      -9.338   5.671  17.199  1.00 36.05          
ATOM    692  O   THR   104      -9.898   5.745  16.097  1.00 36.90          
ATOM    693  N   ASN   105      -8.959   4.511  17.735  1.00 38.27          
ATOM    694  CA  ASN   105      -9.385   3.246  17.138  1.00 40.33          
ATOM    695  CB  ASN   105      -8.815   2.062  17.918  1.00 40.37          
ATOM    696  CG  ASN   105      -7.322   1.879  17.683  1.00 42.21          
ATOM    697  OD1 ASN   105      -6.874   1.689  16.541  1.00 41.64          
ATOM    698  ND2 ASN   105      -6.541   1.939  18.767  1.00 44.10          
ATOM    699  C   ASN   105     -10.912   3.191  17.067  1.00 41.03          
ATOM    700  O   ASN   105     -11.471   2.744  16.070  1.00 41.90          
ATOM    701  N   ASP   106     -11.566   3.706  18.114  1.00 42.59          
ATOM    702  CA  ASP   106     -13.036   3.777  18.206  1.00 43.41          
ATOM    703  CB  ASP   106     -13.463   4.107  19.654  1.00 44.41          
ATOM    704  CG  ASP   106     -13.584   2.866  20.540  1.00 46.20          
ATOM    705  OD1 ASP   106     -13.138   1.766  20.136  1.00 48.97          
ATOM    706  OD2 ASP   106     -14.138   2.999  21.646  1.00 47.28          
ATOM    707  C   ASP   106     -13.736   4.765  17.261  1.00 43.26          
ATOM    708  O   ASP   106     -14.971   4.726  17.160  1.00 44.00          
ATOM    709  N   THR   107     -12.976   5.653  16.599  1.00 42.62          
ATOM    710  CA  THR   107     -13.557   6.684  15.707  1.00 41.71          
ATOM    711  CB  THR   107     -13.594   8.147  16.355  1.00 41.49          
ATOM    712  OG1 THR   107     -12.287   8.738  16.354  1.00 38.77          
ATOM    713  CG2 THR   107     -14.144   8.155  17.812  1.00 38.97          
ATOM    714  C   THR   107     -12.937   6.749  14.295  1.00 42.42          
ATOM    715  O   THR   107     -13.446   7.490  13.460  1.00 42.86          
ATOM    716  N   VAL   108     -11.865   5.989  14.021  1.00 43.28          
ATOM    717  CA  VAL   108     -11.174   6.041  12.700  1.00 44.00          
ATOM    718  CB  VAL   108      -9.907   5.118  12.604  1.00 44.13          
ATOM    719  CG1 VAL   108      -9.248   5.251  11.231  1.00 43.39          
ATOM    720  CG2 VAL   108      -8.882   5.428  13.665  1.00 44.83          
ATOM    721  C   VAL   108     -12.081   5.574  11.571  1.00 44.91          
ATOM    722  O   VAL   108     -12.608   4.473  11.646  1.00 45.54          
ATOM    723  N   PRO   109     -12.240   6.384  10.506  1.00 45.75          
ATOM    724  CA  PRO   109     -13.064   5.951   9.356  1.00 46.26          
ATOM    725  CB  PRO   109     -13.326   7.252   8.571  1.00 46.12          
ATOM    726  CG  PRO   109     -12.426   8.300   9.157  1.00 46.50          
ATOM    727  CD  PRO   109     -11.660   7.727  10.315  1.00 46.18          
ATOM    728  C   PRO   109     -12.376   4.910   8.461  1.00 46.55          
ATOM    729  O   PRO   109     -11.754   3.963   8.965  1.00 46.67          
ATOM    730  N   ASN   113      -7.285   5.397   4.340  1.00 33.54          
ATOM    731  CA  ASN   113      -5.963   5.736   3.806  1.00 33.41          
ATOM    732  CB  ASN   113      -6.044   6.751   2.644  1.00 33.72          
ATOM    733  CG  ASN   113      -4.654   7.087   2.042  1.00 37.46          
ATOM    734  OD1 ASN   113      -3.627   6.526   2.444  1.00 39.44          
ATOM    735  ND2 ASN   113      -4.626   8.015   1.084  1.00 40.80          
ATOM    736  C   ASN   113      -5.083   6.309   4.924  1.00 32.22          
ATOM    737  O   ASN   113      -5.308   7.443   5.347  1.00 32.25          
ATOM    738  N   ARG   114      -4.092   5.525   5.359  1.00 30.44          
ATOM    739  CA  ARG   114      -3.235   5.856   6.515  1.00 29.06          
ATOM    740  CB  ARG   114      -3.024   4.604   7.390  1.00 28.57          
ATOM    741  CG  ARG   114      -4.322   4.087   8.066  1.00 30.87          
ATOM    742  CD  ARG   114      -4.068   3.153   9.262  1.00 31.31          
ATOM    743  NE  ARG   114      -5.346   2.805   9.903  1.00 37.47          
ATOM    744  CZ  ARG   114      -5.530   2.534  11.195  1.00 39.66          
ATOM    745  NH1 ARG   114      -4.520   2.530  12.062  1.00 41.65          
ATOM    746  NH2 ARG   114      -6.754   2.256  11.627  1.00 41.34          
ATOM    747  C   ARG   114      -1.889   6.483   6.125  1.00 27.36          
ATOM    748  O   ARG   114      -0.972   6.554   6.956  1.00 26.00          
ATOM    749  N   LYS   115      -1.760   6.931   4.869  1.00 25.69          
ATOM    750  CA  LYS   115      -0.501   7.488   4.377  1.00 24.69          
ATOM    751  CB  LYS   115      -0.622   7.929   2.916  1.00 26.01          
ATOM    752  CG  LYS   115       0.660   8.562   2.418  1.00 28.72          
ATOM    753  CD  LYS   115       0.682   8.735   0.914  1.00 32.80          
ATOM    754  CE  LYS   115       1.756   9.720   0.551  1.00 34.57          
ATOM    755  NZ  LYS   115       1.782   9.961  -0.892  1.00 34.10          
ATOM    756  C   LYS   115       0.006   8.678   5.236  1.00 23.52          
ATOM    757  O   LYS   115       1.218   8.884   5.407  1.00 23.21          
ATOM    758  N   TYR   116      -0.929   9.451   5.767  1.00 21.43          
ATOM    759  CA  TYR   116      -0.551  10.662   6.466  1.00 20.14          
ATOM    760  CB  TYR   116      -1.302  11.863   5.876  1.00 22.07          
ATOM    761  CG  TYR   116      -0.977  12.132   4.413  1.00 20.56          
ATOM    762  CD1 TYR   116       0.088  12.942   4.054  1.00 23.84          
ATOM    763  CE1 TYR   116       0.383  13.192   2.723  1.00 24.84          
ATOM    764  CZ  TYR   116      -0.417  12.601   1.727  1.00 26.66          
ATOM    765  OH  TYR   116      -0.113  12.859   0.396  1.00 27.73          
ATOM    766  CE2 TYR   116      -1.494  11.799   2.065  1.00 24.33          
ATOM    767  CD2 TYR   116      -1.777  11.574   3.402  1.00 23.92          
ATOM    768  C   TYR   116      -0.846  10.561   7.956  1.00 18.86          
ATOM    769  O   TYR   116      -1.078  11.577   8.598  1.00 17.24          
ATOM    770  N   PHE   117      -0.918   9.333   8.469  1.00 18.18          
ATOM    771  CA  PHE   117      -1.179   9.085   9.877  1.00 18.44          
ATOM    772  CB  PHE   117      -1.736   7.666  10.099  1.00 18.96          
ATOM    773  CG  PHE   117      -3.271   7.557  10.044  1.00 20.21          
ATOM    774  CD1 PHE   117      -4.020   8.251   9.096  1.00 21.37          
ATOM    775  CE1 PHE   117      -5.446   8.129   9.030  1.00 21.26          
ATOM    776  CZ  PHE   117      -6.106   7.300   9.928  1.00 21.40          
ATOM    777  CE2 PHE   117      -5.366   6.583  10.886  1.00 24.40          
ATOM    778  CD2 PHE   117      -3.943   6.722  10.941  1.00 23.57          
ATOM    779  C   PHE   117       0.090   9.162  10.729  1.00 18.09          
ATOM    780  O   PHE   117       1.146   8.584  10.390  1.00 17.52          
ATOM    781  N   TRP   118      -0.072   9.832  11.865  1.00 16.97          
ATOM    782  CA  TRP   118       0.946   9.866  12.912  1.00 15.96          
ATOM    783  CB  TRP   118       1.406  11.303  13.088  1.00 16.71          
ATOM    784  CG  TRP   118       2.157  11.805  11.887  1.00 16.60          
ATOM    785  CD1 TRP   118       1.622  12.304  10.734  1.00 16.44          
ATOM    786  NE1 TRP   118       2.642  12.671   9.844  1.00 16.03          
ATOM    787  CE2 TRP   118       3.856  12.411  10.456  1.00 16.20          
ATOM    788  CD2 TRP   118       3.582  11.857  11.741  1.00 15.80          
ATOM    789  CE3 TRP   118       4.664  11.497  12.576  1.00 15.82          
ATOM    790  CZ3 TRP   118       5.985  11.695  12.093  1.00 16.54          
ATOM    791  CH2 TRP   118       6.211  12.260  10.811  1.00 15.08          
ATOM    792  CZ2 TRP   118       5.170  12.603   9.980  1.00 17.59          
ATOM    793  C   TRP   118       0.319   9.377  14.223  1.00 16.58          
ATOM    794  O   TRP   118      -0.822   9.772  14.548  1.00 17.84          
ATOM    795  N   ARG   119       1.085   8.619  14.986  1.00 15.64          
ATOM    796  CA  ARG   119       0.581   8.046  16.263  1.00 16.03          
ATOM    797  CB  ARG   119       1.099   6.627  16.453  1.00 16.24          
ATOM    798  CG  ARG   119       0.554   5.699  15.389  1.00 18.29          
ATOM    799  CD  ARG   119       1.145   4.351  15.561  1.00 25.76          
ATOM    800  NE  ARG   119       0.464   3.425  14.674  1.00 26.51          
ATOM    801  CZ  ARG   119       0.383   2.119  14.898  1.00 34.05          
ATOM    802  NH1 ARG   119       0.996   1.588  15.958  1.00 35.57          
ATOM    803  NH2 ARG   119      -0.294   1.347  14.049  1.00 37.33          
ATOM    804  C   ARG   119       0.991   8.914  17.438  1.00 16.44          
ATOM    805  O   ARG   119       2.138   9.369  17.517  1.00 16.14          
ATOM    806  N   ILE   120       0.035   9.098  18.366  1.00 14.93          
ATOM    807  CA  ILE   120       0.285   9.760  19.624  1.00 15.69          
ATOM    808  CB  ILE   120      -0.705  10.948  19.797  1.00 15.26          
ATOM    809  CG1 ILE   120      -0.385  12.048  18.766  1.00 18.08          
ATOM    810  CD  ILE   120       0.951  12.738  19.029  1.00 20.70          
ATOM    811  CG2 ILE   120      -0.652  11.487  21.209  1.00 16.51          
ATOM    812  C   ILE   120       0.049   8.718  20.745  1.00 15.61          
ATOM    813  O   ILE   120      -0.991   8.033  20.741  1.00 16.56          
ATOM    814  N   TYR   121       1.024   8.601  21.646  1.00 16.03          
ATOM    815  CA  TYR   121       0.991   7.632  22.754  1.00 16.18          
ATOM    816  CB  TYR   121       2.287   6.819  22.824  1.00 17.91          
ATOM    817  CG  TYR   121       2.435   5.849  21.675  1.00 18.30          
ATOM    818  CD1 TYR   121       2.225   4.499  21.865  1.00 21.24          
ATOM    819  CE1 TYR   121       2.326   3.595  20.831  1.00 22.45          
ATOM    820  CZ  TYR   121       2.656   4.044  19.549  1.00 24.78          
ATOM    821  OH  TYR   121       2.760   3.107  18.522  1.00 27.03          
ATOM    822  CE2 TYR   121       2.892   5.383  19.325  1.00 21.35          
ATOM    823  CD2 TYR   121       2.782   6.291  20.392  1.00 21.36          
ATOM    824  C   TYR   121       0.799   8.361  24.085  1.00 17.86          
ATOM    825  O   TYR   121       1.211   9.519  24.254  1.00 17.07          
ATOM    826  N   SER   122       0.213   7.640  25.043  1.00 17.18          
ATOM    827  CA  SER   122       0.042   8.161  26.379  1.00 19.34          
ATOM    828  CB  SER   122      -1.398   8.619  26.602  1.00 20.41          
ATOM    829  OG  SER   122      -1.487   9.124  27.916  1.00 22.58          
ATOM    830  C   SER   122       0.320   7.008  27.338  1.00 20.90          
ATOM    831  O   SER   122      -0.305   5.964  27.213  1.00 20.94          
ATOM    832  N   ARG   123       1.280   7.219  28.239  1.00 23.74          
ATOM    833  CA  ARG   123       1.672   6.186  29.210  1.00 27.07          
ATOM    834  CB  ARG   123       0.569   6.048  30.245  1.00 27.56          
ATOM    835  CG  ARG   123       0.412   7.340  31.029  1.00 28.23          
ATOM    836  CD  ARG   123      -0.801   7.347  31.908  1.00 29.69          
ATOM    837  NE  ARG   123      -0.867   8.597  32.670  1.00 32.43          
ATOM    838  CZ  ARG   123      -1.698   8.811  33.690  1.00 31.18          
ATOM    839  NH1 ARG   123      -2.524   7.858  34.076  1.00 33.38          
ATOM    840  NH2 ARG   123      -1.702   9.978  34.311  1.00 29.88          
ATOM    841  C   ARG   123       1.983   4.846  28.529  1.00 28.50          
ATOM    842  O   ARG   123       1.458   3.791  28.910  1.00 30.40          
ATOM    843  N   GLY   124       2.826   4.909  27.498  1.00 29.06          
ATOM    844  CA  GLY   124       3.253   3.713  26.776  1.00 28.70          
ATOM    845  C   GLY   124       2.205   3.017  25.928  1.00 28.47          
ATOM    846  O   GLY   124       2.480   1.947  25.398  1.00 29.99          
ATOM    847  N   GLU   125       1.010   3.591  25.793  1.00 26.15          
ATOM    848  CA  GLU   125      -0.032   2.970  24.996  1.00 25.07          
ATOM    849  CB  GLU   125      -1.211   2.518  25.884  1.00 27.16          
ATOM    850  CG  GLU   125      -0.813   1.671  27.106  1.00 32.50          
ATOM    851  CD  GLU   125      -0.345   0.256  26.741  1.00 40.85          
ATOM    852  OE1 GLU   125      -0.677  -0.221  25.634  1.00 44.47          
ATOM    853  OE2 GLU   125       0.360  -0.387  27.563  1.00 45.71          
ATOM    854  C   GLU   125      -0.521   3.926  23.902  1.00 22.47          
ATOM    855  O   GLU   125      -0.595   5.137  24.126  1.00 21.62          
ATOM    856  N   LEU   126      -0.821   3.384  22.730  1.00 20.69          
ATOM    857  CA  LEU   126      -1.342   4.174  21.642  1.00 20.74          
ATOM    858  CB  LEU   126      -1.638   3.298  20.423  1.00 21.39          
ATOM    859  CG  LEU   126      -2.267   3.912  19.191  1.00 22.79          
ATOM    860  CD1 LEU   126      -1.319   4.982  18.661  1.00 20.56          
ATOM    861  CD2 LEU   126      -2.479   2.817  18.133  1.00 22.80          
ATOM    862  C   LEU   126      -2.615   4.853  22.117  1.00 21.50          
ATOM    863  O   LEU   126      -3.505   4.178  22.660  1.00 23.10          
ATOM    864  N   HSD   127      -2.720   6.165  21.901  1.00 19.38          
ATOM    865  CA  HSD   127      -3.885   6.912  22.322  1.00 18.68          
ATOM    866  CB  HSD   127      -3.522   8.110  23.199  1.00 18.89          
ATOM    867  CG  HSD   127      -4.720   8.717  23.853  1.00 22.08          
ATOM    868  ND1 HSD   127      -5.449   9.735  23.269  1.00 22.59          
ATOM    869  CE1 HSD   127      -6.491  10.022  24.039  1.00 25.16          
ATOM    870  NE2 HSD   127      -6.473   9.208  25.087  1.00 22.59          
ATOM    871  CD2 HSD   127      -5.385   8.377  24.992  1.00 21.86          
ATOM    872  C   HSD   127      -4.729   7.353  21.134  1.00 18.95          
ATOM    873  O   HSD   127      -5.911   7.072  21.069  1.00 20.21          
ATOM    874  N   HSD   128      -4.120   8.016  20.146  1.00 16.18          
ATOM    875  CA  HSD   128      -4.879   8.459  18.997  1.00 17.78          
ATOM    876  CB  HSD   128      -5.701   9.713  19.314  1.00 18.30          
ATOM    877  CG  HSD   128      -4.888  10.918  19.676  1.00 18.44          
ATOM    878  ND1 HSD   128      -4.619  11.280  20.985  1.00 22.60          
ATOM    879  CE1 HSD   128      -3.933  12.409  20.995  1.00 21.61          
ATOM    880  NE2 HSD   128      -3.778  12.815  19.743  1.00 17.62          
ATOM    881  CD2 HSD   128      -4.395  11.916  18.905  1.00 17.77          
ATOM    882  C   HSD   128      -3.955   8.694  17.802  1.00 17.96          
ATOM    883  O   HSD   128      -2.708   8.564  17.934  1.00 20.02          
ATOM    884  N   PHE   129      -4.582   8.968  16.659  1.00 18.35          
ATOM    885  CA  PHE   129      -3.878   9.233  15.410  1.00 18.79          
ATOM    886  CB  PHE   129      -4.374   8.339  14.249  1.00 20.17          
ATOM    887  CG  PHE   129      -4.349   6.890  14.540  1.00 21.77          
ATOM    888  CD1 PHE   129      -3.154   6.152  14.404  1.00 23.89          
ATOM    889  CE1 PHE   129      -3.137   4.787  14.653  1.00 26.02          
ATOM    890  CZ  PHE   129      -4.309   4.143  15.051  1.00 23.75          
ATOM    891  CE2 PHE   129      -5.510   4.853  15.177  1.00 24.48          
ATOM    892  CD2 PHE   129      -5.523   6.234  14.917  1.00 25.40          
ATOM    893  C   PHE   129      -4.137  10.665  14.989  1.00 18.55          
ATOM    894  O   PHE   129      -5.268  11.170  15.109  1.00 18.71          
ATOM    895  N   ILE   130      -3.099  11.327  14.481  1.00 15.32          
ATOM    896  CA  ILE   130      -3.283  12.600  13.793  1.00 16.50          
ATOM    897  CB  ILE   130      -2.184  13.667  14.180  1.00 16.96          
ATOM    898  CG1 ILE   130      -2.168  13.950  15.680  1.00 18.42          
ATOM    899  CD  ILE   130      -0.852  14.595  16.129  1.00 16.78          
ATOM    900  CG2 ILE   130      -2.476  14.985  13.486  1.00 18.18          
ATOM    901  C   ILE   130      -3.164  12.285  12.298  1.00 17.03          
ATOM    902  O   ILE   130      -2.173  11.690  11.861  1.00 17.65          
ATOM    903  N   ASP   131      -4.170  12.667  11.523  1.00 16.88          
ATOM    904  CA  ASP   131      -4.219  12.297  10.128  1.00 18.19          
ATOM    905  CB  ASP   131      -5.530  11.532   9.831  1.00 18.28          
ATOM    906  CG  ASP   131      -5.731  11.266   8.313  1.00 21.31          
ATOM    907  OD1 ASP   131      -4.742  11.291   7.533  1.00 20.30          
ATOM    908  OD2 ASP   131      -6.886  10.985   7.904  1.00 26.77          
ATOM    909  C   ASP   131      -4.143  13.555   9.260  1.00 18.74          
ATOM    910  O   ASP   131      -5.015  14.423   9.319  1.00 18.14          
ATOM    911  N   GLY   132      -3.072  13.660   8.481  1.00 18.82          
ATOM    912  CA  GLY   132      -2.862  14.849   7.655  1.00 19.66          
ATOM    913  C   GLY   132      -3.449  14.775   6.238  1.00 20.30          
ATOM    914  O   GLY   132      -3.160  15.642   5.421  1.00 20.48          
ATOM    915  N   PHE   133      -4.298  13.785   5.963  1.00 20.65          
ATOM    916  CA  PHE   133      -4.778  13.586   4.607  1.00 21.14          
ATOM    917  CB  PHE   133      -5.641  12.333   4.520  1.00 22.09          
ATOM    918  CG  PHE   133      -6.177  12.110   3.150  1.00 26.42          
ATOM    919  CD1 PHE   133      -5.323  11.728   2.125  1.00 29.51          
ATOM    920  CE1 PHE   133      -5.814  11.550   0.819  1.00 31.16          
ATOM    921  CZ  PHE   133      -7.166  11.790   0.558  1.00 28.94          
ATOM    922  CE2 PHE   133      -8.019  12.195   1.573  1.00 31.34          
ATOM    923  CD2 PHE   133      -7.518  12.368   2.870  1.00 28.75          
ATOM    924  C   PHE   133      -5.582  14.787   4.087  1.00 20.52          
ATOM    925  O   PHE   133      -5.377  15.251   2.950  1.00 20.59          
ATOM    926  N   ASN   134      -6.487  15.300   4.894  1.00 19.13          
ATOM    927  CA  ASN   134      -7.381  16.369   4.422  1.00 19.27          
ATOM    928  CB  ASN   134      -8.636  16.436   5.307  1.00 19.60          
ATOM    929  CG  ASN   134      -9.654  17.488   4.830  1.00 22.47          
ATOM    930  OD1 ASN   134      -9.341  18.379   4.019  1.00 22.03          
ATOM    931  ND2 ASN   134     -10.904  17.368   5.327  1.00 23.92          
ATOM    932  C   ASN   134      -6.658  17.717   4.450  1.00 19.56          
ATOM    933  O   ASN   134      -6.376  18.253   5.547  1.00 19.38          
ATOM    934  N   GLU   135      -6.365  18.297   3.272  1.00 19.05          
ATOM    935  CA  GLU   135      -5.549  19.554   3.261  1.00 20.29          
ATOM    936  CB  GLU   135      -5.070  19.874   1.837  1.00 21.08          
ATOM    937  CG  GLU   135      -4.132  18.807   1.315  1.00 25.54          
ATOM    938  CD  GLU   135      -4.063  18.723  -0.201  1.00 31.54          
ATOM    939  OE1 GLU   135      -5.024  18.207  -0.819  1.00 35.44          
ATOM    940  OE2 GLU   135      -3.024  19.127  -0.766  1.00 31.55          
ATOM    941  C   GLU   135      -6.258  20.762   3.863  1.00 20.42          
ATOM    942  O   GLU   135      -5.602  21.736   4.208  1.00 20.60          
ATOM    943  N   GLU   136      -7.592  20.705   3.971  1.00 20.06          
ATOM    944  CA  GLU   136      -8.370  21.789   4.581  1.00 21.63          
ATOM    945  CB  GLU   136      -9.855  21.726   4.155  1.00 22.35          
ATOM    946  CG  GLU   136     -10.076  22.064   2.682  1.00 25.16          
ATOM    947  CD  GLU   136     -11.547  21.934   2.236  1.00 28.51          
ATOM    948  OE1 GLU   136     -12.399  21.441   3.036  1.00 33.67          
ATOM    949  OE2 GLU   136     -11.843  22.341   1.071  1.00 33.91          
ATOM    950  C   GLU   136      -8.263  21.753   6.115  1.00 20.55          
ATOM    951  O   GLU   136      -8.529  22.754   6.771  1.00 22.07          
ATOM    952  N   LYS   137      -7.899  20.587   6.658  1.00 19.21          
ATOM    953  CA  LYS   137      -7.852  20.384   8.127  1.00 19.50          
ATOM    954  CB  LYS   137      -8.837  19.315   8.547  1.00 20.11          
ATOM    955  CG  LYS   137     -10.273  19.715   8.259  1.00 25.41          
ATOM    956  CD  LYS   137     -11.211  18.507   8.444  1.00 33.74          
ATOM    957  CE  LYS   137     -12.696  18.906   8.349  1.00 38.10          
ATOM    958  NZ  LYS   137     -13.005  19.913   9.413  1.00 42.73          
ATOM    959  C   LYS   137      -6.466  20.020   8.656  1.00 18.18          
ATOM    960  O   LYS   137      -6.342  19.535   9.801  1.00 19.14          
ATOM    961  N   SER   138      -5.434  20.233   7.842  0.50 17.09          
ATOM    963  CA  SER   138      -4.064  19.835   8.223  0.50 16.24          
ATOM    965  CB  SER   138      -3.691  18.501   7.579  0.50 17.33          
ATOM    967  OG  SER   138      -3.689  18.576   6.162  0.50 17.83          
ATOM    969  C   SER   138      -3.082  20.919   7.802  0.50 15.27          
ATOM    971  O   SER   138      -3.356  21.664   6.862  0.50 14.76          
ATOM    973  N   ASN   139      -1.947  21.026   8.500  1.00 13.56          
ATOM    974  CA  ASN   139      -0.958  22.032   8.120  1.00 12.90          
ATOM    975  CB  ASN   139      -0.308  22.750   9.316  1.00 12.49          
ATOM    976  CG  ASN   139       0.584  21.840  10.119  1.00 13.20          
ATOM    977  OD1 ASN   139       0.558  20.609   9.966  1.00 13.18          
ATOM    978  ND2 ASN   139       1.418  22.447  11.001  1.00 16.33          
ATOM    979  C   ASN   139       0.072  21.457   7.141  1.00 12.91          
ATOM    980  O   ASN   139      -0.003  20.272   6.676  1.00 13.91          
ATOM    981  N   TRP   140       1.051  22.314   6.811  1.00 11.84          
ATOM    982  CA  TRP   140       2.029  22.042   5.742  1.00 13.53          
ATOM    983  CB  TRP   140       2.905  23.275   5.600  1.00 13.50          
ATOM    984  CG  TRP   140       3.670  23.555   6.904  1.00 13.44          
ATOM    985  CD1 TRP   140       3.242  24.273   8.002  1.00 13.70          
ATOM    986  NE1 TRP   140       4.219  24.258   8.986  1.00 14.04          
ATOM    987  CE2 TRP   140       5.311  23.567   8.522  1.00 12.59          
ATOM    988  CD2 TRP   140       4.989  23.100   7.205  1.00 12.97          
ATOM    989  CE3 TRP   140       5.931  22.319   6.509  1.00 12.80          
ATOM    990  CZ3 TRP   140       7.181  22.030   7.141  1.00 12.23          
ATOM    991  CH2 TRP   140       7.472  22.519   8.463  1.00 12.90          
ATOM    992  CZ2 TRP   140       6.549  23.272   9.156  1.00 12.87          
ATOM    993  C   TRP   140       2.920  20.827   6.019  1.00 13.00          
ATOM    994  O   TRP   140       3.532  20.280   5.114  1.00 14.00          
ATOM    995  N   MET   141       3.010  20.403   7.288  1.00 12.12          
ATOM    996  CA  MET   141       3.900  19.296   7.638  1.00 13.30          
ATOM    997  CB  MET   141       3.978  19.157   9.160  1.00 13.33          
ATOM    998  CG  MET   141       4.778  20.291   9.743  1.00 16.01          
ATOM    999  SD  MET   141       4.518  20.460  11.553  1.00 15.33          
ATOM   1000  CE  MET   141       5.617  19.188  12.159  1.00 18.68          
ATOM   1001  C   MET   141       3.501  17.982   6.963  1.00 12.78          
ATOM   1002  O   MET   141       4.359  17.120   6.746  1.00 13.48          
ATOM   1003  N   ARG   142       2.228  17.871   6.546  1.00 12.55          
ATOM   1004  CA  ARG   142       1.807  16.682   5.777  1.00 15.54          
ATOM   1005  CB  ARG   142       0.296  16.793   5.430  1.00 15.04          
ATOM   1006  CG  ARG   142       0.041  17.813   4.363  1.00 15.71          
ATOM   1007  CD  ARG   142      -1.338  17.918   3.736  1.00 21.55          
ATOM   1008  NE  ARG   142      -2.034  16.722   3.222  1.00 20.55          
ATOM   1009  CZ  ARG   142      -1.924  16.125   2.022  1.00 22.64          
ATOM   1010  NH1 ARG   142      -0.974  16.435   1.130  1.00 24.73          
ATOM   1011  NH2 ARG   142      -2.766  15.130   1.723  1.00 20.62          
ATOM   1012  C   ARG   142       2.609  16.499   4.454  1.00 14.19          
ATOM   1013  O   ARG   142       2.640  15.368   3.901  1.00 15.05          
ATOM   1014  N   TYR   143       3.158  17.600   3.916  1.00 13.72          
ATOM   1015  CA  TYR   143       3.891  17.528   2.635  1.00 14.43          
ATOM   1016  CB  TYR   143       3.808  18.851   1.898  1.00 14.54          
ATOM   1017  CG  TYR   143       2.440  19.264   1.467  1.00 15.31          
ATOM   1018  CD1 TYR   143       1.734  18.569   0.455  1.00 16.62          
ATOM   1019  CE1 TYR   143       0.416  19.043   0.059  1.00 17.38          
ATOM   1020  CZ  TYR   143      -0.087  20.175   0.684  1.00 17.38          
ATOM   1021  OH  TYR   143      -1.319  20.734   0.416  1.00 20.88          
ATOM   1022  CE2 TYR   143       0.615  20.845   1.665  1.00 16.29          
ATOM   1023  CD2 TYR   143       1.878  20.379   2.036  1.00 14.85          
ATOM   1024  C   TYR   143       5.354  17.147   2.755  1.00 13.95          
ATOM   1025  O   TYR   143       6.034  16.919   1.760  1.00 15.66          
ATOM   1026  N   VAL   144       5.868  17.102   3.970  1.00 12.85          
ATOM   1027  CA  VAL   144       7.253  16.715   4.154  1.00 12.20          
ATOM   1028  CB  VAL   144       7.767  17.097   5.563  1.00 11.94          
ATOM   1029  CG1 VAL   144       9.216  16.706   5.738  1.00 12.60          
ATOM   1030  CG2 VAL   144       7.622  18.587   5.783  1.00 12.24          
ATOM   1031  C   VAL   144       7.445  15.216   3.908  1.00 13.42          
ATOM   1032  O   VAL   144       6.810  14.365   4.576  1.00 13.83          
ATOM   1033  N   ASN   145       8.333  14.907   2.977  1.00 13.63          
ATOM   1034  CA  ASN   145       8.655  13.526   2.643  1.00 14.79          
ATOM   1035  CB  ASN   145       9.263  13.467   1.222  1.00 15.38          
ATOM   1036  CG  ASN   145       8.243  13.869   0.168  1.00 18.77          
ATOM   1037  OD1 ASN   145       7.128  13.384   0.184  1.00 18.28          
ATOM   1038  ND2 ASN   145       8.629  14.757  -0.734  1.00 18.59          
ATOM   1039  C   ASN   145       9.622  12.853   3.623  1.00 14.88          
ATOM   1040  O   ASN   145      10.416  13.535   4.308  1.00 14.14          
ATOM   1041  N   PRO   146       9.559  11.512   3.706  1.00 15.45          
ATOM   1042  CA  PRO   146      10.446  10.779   4.607  1.00 15.12          
ATOM   1043  CB  PRO   146       9.787   9.391   4.702  1.00 16.65          
ATOM   1044  CG  PRO   146       9.159   9.201   3.374  1.00 16.74          
ATOM   1045  CD  PRO   146       8.625  10.595   2.999  1.00 16.00          
ATOM   1046  C   PRO   146      11.843  10.634   4.010  1.00 14.88          
ATOM   1047  O   PRO   146      12.010  10.539   2.752  1.00 16.95          
ATOM   1048  N   ALA   147      12.851  10.620   4.876  1.00 14.99          
ATOM   1049  CA  ALA   147      14.235  10.400   4.443  1.00 15.24          
ATOM   1050  CB  ALA   147      15.191  10.627   5.617  1.00 15.91          
ATOM   1051  C   ALA   147      14.327   8.928   4.038  1.00 16.99          
ATOM   1052  O   ALA   147      13.773   8.085   4.714  1.00 17.23          
ATOM   1053  N   HSD   148      15.103   8.643   2.983  1.00 18.26          
ATOM   1054  CA  HSD   148      15.358   7.236   2.603  1.00 20.61          
ATOM   1055  CB  HSD   148      15.582   7.150   1.098  1.00 21.44          
ATOM   1056  CG  HSD   148      14.405   7.589   0.276  1.00 27.91          
ATOM   1057  ND1 HSD   148      13.100   7.401   0.676  1.00 36.01          
ATOM   1058  CE1 HSD   148      12.276   7.865  -0.248  1.00 35.50          
ATOM   1059  NE2 HSD   148      13.001   8.348  -1.239  1.00 37.23          
ATOM   1060  CD2 HSD   148      14.338   8.186  -0.938  1.00 34.46          
ATOM   1061  C   HSD   148      16.512   6.554   3.319  1.00 20.48          
ATOM   1062  O   HSD   148      16.636   5.298   3.274  1.00 21.80          
ATOM   1063  N   SER   149      17.370   7.359   3.953  1.00 20.16          
ATOM   1064  CA  SER   149      18.590   6.896   4.581  1.00 20.68          
ATOM   1065  CB  SER   149      19.712   6.788   3.534  1.00 22.00          
ATOM   1066  OG  SER   149      20.173   8.088   3.136  1.00 23.66          
ATOM   1067  C   SER   149      19.012   7.876   5.686  1.00 20.14          
ATOM   1068  O   SER   149      18.616   9.066   5.655  1.00 19.10          
ATOM   1069  N   PRO   150      19.831   7.405   6.637  1.00 20.10          
ATOM   1070  CA  PRO   150      20.385   8.324   7.614  1.00 19.83          
ATOM   1071  CB  PRO   150      21.417   7.479   8.360  1.00 20.23          
ATOM   1072  CG  PRO   150      20.898   6.136   8.303  1.00 19.79          
ATOM   1073  CD  PRO   150      20.239   6.011   6.926  1.00 20.94          
ATOM   1074  C   PRO   150      21.053   9.520   6.979  1.00 20.30          
ATOM   1075  O   PRO   150      20.912  10.617   7.480  1.00 19.49          
ATOM   1076  N   ARG   151      21.723   9.324   5.839  1.00 19.18          
ATOM   1077  CA  ARG   151      22.510  10.394   5.235  1.00 19.36          
ATOM   1078  CB  ARG   151      23.353   9.840   4.048  1.00 19.17          
ATOM   1085  C   ARG   151      21.559  11.501   4.747  1.00 19.56          
ATOM   1086  O   ARG   151      21.908  12.675   4.797  1.00 20.48          
ATOM   1087  N   GLU   152      20.369  11.118   4.283  1.00 17.79          
ATOM   1088  CA  GLU   152      19.404  12.080   3.733  1.00 19.36          
ATOM   1089  CB  GLU   152      18.358  11.354   2.897  1.00 19.47          
ATOM   1090  CG  GLU   152      18.856  10.841   1.552  1.00 23.10          
ATOM   1091  CD  GLU   152      17.708  10.387   0.649  1.00 25.12          
ATOM   1092  OE1 GLU   152      16.484  10.413   1.040  1.00 26.26          
ATOM   1093  OE2 GLU   152      18.048   9.999  -0.494  1.00 30.27          
ATOM   1094  C   GLU   152      18.593  12.844   4.803  1.00 18.22          
ATOM   1095  O   GLU   152      18.003  13.899   4.517  1.00 17.60          
ATOM   1096  N   GLN   153      18.468  12.235   5.969  1.00 16.61          
ATOM   1097  CA  GLN   153      17.603  12.847   7.009  1.00 14.79          
ATOM   1098  CB  GLN   153      17.515  11.909   8.219  1.00 15.56          
ATOM   1099  CG  GLN   153      16.662  12.490   9.384  1.00 13.80          
ATOM   1100  CD  GLN   153      16.876  11.728  10.690  1.00 14.16          
ATOM   1101  OE1 GLN   153      17.945  11.105  10.894  1.00 16.41          
ATOM   1102  NE2 GLN   153      15.881  11.790  11.602  1.00 12.43          
ATOM   1103  C   GLN   153      18.141  14.187   7.463  1.00 13.96          
ATOM   1104  O   GLN   153      19.329  14.302   7.801  1.00 14.14          
ATOM   1105  N   ASN   154      17.269  15.186   7.499  1.00 12.50          
ATOM   1106  CA  ASN   154      17.640  16.441   8.163  1.00 12.12          
ATOM   1107  CB  ASN   154      17.978  17.562   7.152  1.00 13.53          
ATOM   1108  CG  ASN   154      16.884  17.810   6.145  1.00 14.09          
ATOM   1109  OD1 ASN   154      15.695  17.567   6.407  1.00 13.67          
ATOM   1110  ND2 ASN   154      17.289  18.277   4.928  1.00 15.46          
ATOM   1111  C   ASN   154      16.611  16.904   9.226  1.00 12.37          
ATOM   1112  O   ASN   154      16.850  17.920   9.876  1.00 13.72          
ATOM   1113  N   LEU   155      15.527  16.136   9.411  1.00 11.73          
ATOM   1114  CA  LEU   155      14.562  16.425  10.484  1.00 11.16          
ATOM   1115  CB  LEU   155      13.211  16.848   9.898  1.00 12.87          
ATOM   1116  CG  LEU   155      13.169  18.129   9.073  1.00 11.67          
ATOM   1117  CD1 LEU   155      11.835  18.125   8.243  1.00 10.98          
ATOM   1118  CD2 LEU   155      13.250  19.403   9.998  1.00 14.43          
ATOM   1119  C   LEU   155      14.296  15.140  11.285  1.00 12.43          
ATOM   1120  O   LEU   155      14.174  14.067  10.669  1.00 11.73          
ATOM   1121  N   ALA   156      14.166  15.271  12.619  1.00 11.18          
ATOM   1122  CA  ALA   156      13.731  14.166  13.479  1.00 10.62          
ATOM   1123  CB  ALA   156      14.621  14.054  14.692  1.00 12.04          
ATOM   1124  C   ALA   156      12.297  14.559  13.936  1.00 11.15          
ATOM   1125  O   ALA   156      12.096  15.659  14.389  1.00 12.08          
ATOM   1126  N   ALA   157      11.355  13.617  13.881  1.00 10.85          
ATOM   1127  CA  ALA   157       9.985  13.792  14.387  1.00 10.61          
ATOM   1128  CB  ALA   157       8.961  12.978  13.500  1.00 12.20          
ATOM   1129  C   ALA   157       9.942  13.232  15.811  1.00 11.92          
ATOM   1130  O   ALA   157      10.324  12.047  16.033  1.00 12.06          
ATOM   1131  N   CYS   158       9.355  14.027  16.716  1.00 12.86          
ATOM   1132  CA  CYS   158       9.229  13.704  18.149  1.00 13.07          
ATOM   1133  CB  CYS   158      10.121  14.666  18.968  1.00 14.01          
ATOM   1134  SG  CYS   158      11.885  14.443  18.619  1.00 19.62          
ATOM   1135  C   CYS   158       7.839  13.971  18.618  1.00 12.72          
ATOM   1136  O   CYS   158       7.208  14.903  18.149  1.00 12.21          
ATOM   1137  N   GLN   159       7.391  13.196  19.619  1.00 11.32          
ATOM   1138  CA  GLN   159       6.204  13.570  20.372  1.00 11.16          
ATOM   1139  CB  GLN   159       5.398  12.325  20.782  1.00 12.99          
ATOM   1140  CG  GLN   159       4.092  12.762  21.488  1.00 12.62          
ATOM   1141  CD  GLN   159       3.265  11.598  21.993  1.00 16.38          
ATOM   1142  OE1 GLN   159       3.271  10.497  21.414  1.00 15.21          
ATOM   1143  NE2 GLN   159       2.543  11.839  23.104  1.00 15.30          
ATOM   1144  C   GLN   159       6.645  14.297  21.632  1.00 12.95          
ATOM   1145  O   GLN   159       7.412  13.708  22.449  1.00 14.98          
ATOM   1146  N   ASN   160       6.230  15.560  21.781  1.00 11.75          
ATOM   1147  CA  ASN   160       6.480  16.318  23.023  1.00 13.68          
ATOM   1148  CB  ASN   160       7.324  17.560  22.726  1.00 14.53          
ATOM   1149  CG  ASN   160       8.687  17.216  22.151  1.00 17.94          
ATOM   1150  OD1 ASN   160       9.000  17.619  21.032  1.00 24.10          
ATOM   1151  ND2 ASN   160       9.502  16.471  22.905  1.00 19.50          
ATOM   1152  C   ASN   160       5.097  16.699  23.569  1.00 13.57          
ATOM   1153  O   ASN   160       4.289  17.331  22.856  1.00 14.25          
ATOM   1154  N   GLY   161       4.812  16.283  24.812  1.00 15.22          
ATOM   1155  CA  GLY   161       3.454  16.495  25.322  1.00 15.36          
ATOM   1156  C   GLY   161       2.484  15.667  24.496  1.00 15.45          
ATOM   1157  O   GLY   161       2.721  14.457  24.282  1.00 17.14          
ATOM   1158  N   MET   162       1.447  16.336  24.003  1.00 15.13          
ATOM   1159  CA  MET   162       0.389  15.733  23.185  1.00 16.13          
ATOM   1160  CB  MET   162      -1.003  16.191  23.658  1.00 17.63          
ATOM   1161  CG  MET   162      -1.280  15.854  25.092  1.00 19.29          
ATOM   1162  SD  MET   162      -3.004  16.190  25.476  1.00 22.56          
ATOM   1163  CE  MET   162      -3.014  15.796  27.248  1.00 21.55          
ATOM   1164  C   MET   162       0.574  16.018  21.684  1.00 15.70          
ATOM   1165  O   MET   162      -0.317  15.708  20.904  1.00 16.35          
ATOM   1166  N   ASN   163       1.716  16.621  21.313  1.00 14.18          
ATOM   1167  CA  ASN   163       1.943  17.067  19.930  1.00 12.45          
ATOM   1168  CB  ASN   163       2.216  18.573  19.954  1.00 13.53          
ATOM   1169  CG  ASN   163       0.967  19.383  20.257  1.00 15.76          
ATOM   1170  OD1 ASN   163      -0.144  18.974  19.926  1.00 18.83          
ATOM   1171  ND2 ASN   163       1.149  20.544  20.858  1.00 19.58          
ATOM   1172  C   ASN   163       3.146  16.403  19.273  1.00 12.87          
ATOM   1173  O   ASN   163       4.015  15.867  19.960  1.00 12.52          
ATOM   1174  N   ILE   164       3.214  16.487  17.951  0.50 11.38          
ATOM   1176  CA  ILE   164       4.407  16.040  17.246  0.50 10.78          
ATOM   1178  CB  ILE   164       4.080  14.990  16.210  0.50 10.12          
ATOM   1180  CG1 ILE   164       3.699  13.688  16.924  0.50 10.59          
ATOM   1182  CD  ILE   164       2.931  12.778  16.044  0.50 11.40          
ATOM   1184  CG2 ILE   164       5.275  14.795  15.223  0.50 10.16          
ATOM   1186  C   ILE   164       5.040  17.261  16.584  0.50 10.78          
ATOM   1188  O   ILE   164       4.344  18.068  15.946  0.50 11.05          
ATOM   1190  N   TYR   165       6.355  17.361  16.751  1.00 10.65          
ATOM   1191  CA  TYR   165       7.157  18.446  16.178  1.00 10.17          
ATOM   1192  CB  TYR   165       7.830  19.324  17.248  1.00 11.23          
ATOM   1193  CG  TYR   165       6.862  19.971  18.187  1.00 10.50          
ATOM   1194  CD1 TYR   165       6.390  21.252  17.941  1.00 13.89          
ATOM   1195  CE1 TYR   165       5.498  21.890  18.804  1.00 13.72          
ATOM   1196  CZ  TYR   165       5.063  21.198  19.908  1.00 14.69          
ATOM   1197  OH  TYR   165       4.168  21.823  20.791  1.00 17.17          
ATOM   1198  CE2 TYR   165       5.540  19.943  20.187  1.00 13.40          
ATOM   1199  CD2 TYR   165       6.453  19.328  19.341  1.00 13.56          
ATOM   1200  C   TYR   165       8.262  17.811  15.334  1.00 10.13          
ATOM   1201  O   TYR   165       8.610  16.638  15.547  1.00 10.99          
ATOM   1202  N   PHE   166       8.798  18.594  14.390  1.00  9.25          
ATOM   1203  CA  PHE   166      10.001  18.141  13.624  1.00  9.96          
ATOM   1204  CB  PHE   166       9.816  18.358  12.103  1.00 10.86          
ATOM   1205  CG  PHE   166       8.698  17.532  11.467  1.00  9.97          
ATOM   1206  CD1 PHE   166       8.114  16.450  12.123  1.00 12.34          
ATOM   1207  CE1 PHE   166       7.074  15.672  11.479  1.00 12.05          
ATOM   1208  CZ  PHE   166       6.678  15.987  10.191  1.00 11.17          
ATOM   1209  CE2 PHE   166       7.251  17.096   9.536  1.00 10.65          
ATOM   1210  CD2 PHE   166       8.286  17.847  10.163  1.00 10.87          
ATOM   1211  C   PHE   166      11.152  19.065  14.032  1.00 10.96          
ATOM   1212  O   PHE   166      10.945  20.305  14.024  1.00 13.14          
ATOM   1213  N   TYR   167      12.327  18.498  14.310  1.00 11.06          
ATOM   1214  CA  TYR   167      13.493  19.305  14.704  1.00 10.48          
ATOM   1215  CB  TYR   167      14.021  18.788  16.045  1.00 13.28          
ATOM   1216  CG  TYR   167      13.074  19.036  17.203  1.00 12.23          
ATOM   1217  CD1 TYR   167      13.233  20.176  18.020  1.00 14.25          
ATOM   1218  CE1 TYR   167      12.336  20.388  19.101  1.00 12.11          
ATOM   1219  CZ  TYR   167      11.332  19.430  19.355  1.00 12.48          
ATOM   1220  OH  TYR   167      10.482  19.641  20.460  1.00 16.14          
ATOM   1221  CE2 TYR   167      11.156  18.290  18.571  1.00 12.23          
ATOM   1222  CD2 TYR   167      12.045  18.090  17.492  1.00 13.63          
ATOM   1223  C   TYR   167      14.598  19.102  13.676  1.00 11.90          
ATOM   1224  O   TYR   167      14.891  17.946  13.323  1.00 11.19          
ATOM   1225  N   THR   168      15.269  20.172  13.225  1.00 11.16          
ATOM   1226  CA  THR   168      16.394  19.941  12.305  1.00 11.64          
ATOM   1227  CB  THR   168      16.885  21.214  11.598  1.00 11.88          
ATOM   1228  OG1 THR   168      17.234  22.180  12.611  1.00 14.05          
ATOM   1229  CG2 THR   168      15.753  21.791  10.672  1.00 13.31          
ATOM   1230  C   THR   168      17.573  19.344  13.117  1.00 12.97          
ATOM   1231  O   THR   168      17.935  19.830  14.203  1.00 14.14          
ATOM   1232  N   ILE   169      18.172  18.299  12.569  1.00 12.38          
ATOM   1233  CA  ILE   169      19.307  17.626  13.211  1.00 14.36          
ATOM   1234  CB  ILE   169      19.088  16.097  13.268  1.00 13.93          
ATOM   1235  CG1 ILE   169      18.904  15.543  11.850  1.00 16.39          
ATOM   1236  CD  ILE   169      19.070  14.043  11.773  1.00 25.60          
ATOM   1237  CG2 ILE   169      17.887  15.766  14.186  1.00 15.50          
ATOM   1238  C   ILE   169      20.624  17.982  12.520  1.00 15.57          
ATOM   1239  O   ILE   169      21.737  17.556  12.939  1.00 15.55          
ATOM   1240  N   LYS   170      20.500  18.746  11.446  0.50 15.63          
ATOM   1242  CA  LYS   170      21.665  19.307  10.750  0.50 16.54          
ATOM   1244  CB  LYS   170      22.301  18.255   9.809  0.50 17.35          
ATOM   1246  CG  LYS   170      21.329  17.498   8.908  0.50 17.11          
ATOM   1248  CD  LYS   170      21.993  16.358   8.072  0.50 17.66          
ATOM   1250  CE  LYS   170      22.088  15.015   8.834  0.50 18.51          
ATOM   1252  NZ  LYS   170      21.970  13.710   7.995  0.50 15.40          
ATOM   1254  C   LYS   170      21.203  20.565  10.006  0.50 16.46          
ATOM   1256  O   LYS   170      20.015  20.673   9.697  0.50 15.73          
ATOM   1258  N   PRO   171      22.136  21.499   9.673  1.00 16.68          
ATOM   1259  CA  PRO   171      21.682  22.684   8.899  1.00 16.85          
ATOM   1260  CB  PRO   171      22.987  23.494   8.663  1.00 17.80          
ATOM   1261  CG  PRO   171      23.932  22.973   9.672  1.00 17.86          
ATOM   1262  CD  PRO   171      23.588  21.504   9.873  1.00 17.46          
ATOM   1263  C   PRO   171      21.080  22.279   7.578  1.00 16.97          
ATOM   1264  O   PRO   171      21.465  21.242   6.994  1.00 18.12          
ATOM   1265  N   ILE   172      20.121  23.057   7.107  1.00 15.23          
ATOM   1266  CA  ILE   172      19.512  22.816   5.795  1.00 15.22          
ATOM   1267  CB  ILE   172      17.983  22.624   5.856  1.00 15.16          
ATOM   1268  CG1 ILE   172      17.660  21.554   6.914  1.00 16.42          
ATOM   1269  CD  ILE   172      16.184  21.144   6.904  1.00 15.79          
ATOM   1270  CG2 ILE   172      17.428  22.274   4.477  1.00 16.27          
ATOM   1271  C   ILE   172      19.848  24.067   4.973  1.00 15.75          
ATOM   1272  O   ILE   172      19.258  25.137   5.142  1.00 16.17          
ATOM   1273  N   PRO   173      20.831  23.947   4.082  1.00 17.91          
ATOM   1274  CA  PRO   173      21.091  25.082   3.202  1.00 17.94          
ATOM   1275  CB  PRO   173      22.229  24.560   2.311  1.00 18.66          
ATOM   1276  CG  PRO   173      22.918  23.544   3.141  1.00 19.79          
ATOM   1277  CD  PRO   173      21.766  22.839   3.852  1.00 18.99          
ATOM   1278  C   PRO   173      19.892  25.469   2.347  1.00 17.72          
ATOM   1279  O   PRO   173      18.985  24.667   2.109  1.00 17.35          
ATOM   1280  N   ALA   174      19.887  26.703   1.860  1.00 17.71          
ATOM   1281  CA  ALA   174      18.820  27.187   1.003  1.00 19.28          
ATOM   1282  CB  ALA   174      19.165  28.584   0.463  1.00 20.29          
ATOM   1283  C   ALA   174      18.548  26.235  -0.178  1.00 19.72          
ATOM   1284  O   ALA   174      19.495  25.674  -0.767  1.00 19.42          
ATOM   1285  N   ASN   175      17.269  26.044  -0.491  1.00 20.27          
ATOM   1286  CA  ASN   175      16.802  25.278  -1.651  1.00 22.29          
ATOM   1287  CB  ASN   175      17.250  25.964  -2.978  1.00 24.17          
ATOM   1288  CG  ASN   175      16.773  27.436  -3.049  1.00 27.08          
ATOM   1289  OD1 ASN   175      17.579  28.360  -3.218  1.00 34.64          
ATOM   1290  ND2 ASN   175      15.468  27.651  -2.847  1.00 32.33          
ATOM   1291  C   ASN   175      17.124  23.782  -1.579  1.00 22.33          
ATOM   1292  O   ASN   175      17.356  23.127  -2.607  1.00 25.13          
ATOM   1293  N   GLN   176      17.111  23.233  -0.361  1.00 19.28          
ATOM   1294  CA  GLN   176      17.339  21.803  -0.113  1.00 18.46          
ATOM   1295  CB  GLN   176      18.547  21.548   0.804  1.00 19.10          
ATOM   1296  CG  GLN   176      19.872  22.108   0.205  1.00 21.54          
ATOM   1297  CD  GLN   176      20.153  21.571  -1.194  1.00 28.85          
ATOM   1298  OE1 GLN   176      20.197  20.363  -1.406  1.00 30.96          
ATOM   1299  NE2 GLN   176      20.336  22.469  -2.144  1.00 31.98          
ATOM   1300  C   GLN   176      16.050  21.211   0.488  1.00 18.13          
ATOM   1301  O   GLN   176      15.309  21.918   1.192  1.00 16.14          
ATOM   1302  N   GLU   177      15.738  19.966   0.136  1.00 17.61          
ATOM   1303  CA  GLU   177      14.478  19.376   0.587  1.00 16.48          
ATOM   1304  CB  GLU   177      14.155  18.135  -0.217  1.00 16.46          
ATOM   1305  CG  GLU   177      12.754  17.638   0.081  1.00 16.38          
ATOM   1306  CD  GLU   177      12.222  16.603  -0.900  1.00 19.15          
ATOM   1307  OE1 GLU   177      12.958  16.167  -1.836  1.00 21.44          
ATOM   1308  OE2 GLU   177      11.052  16.206  -0.719  1.00 19.76          
ATOM   1309  C   GLU   177      14.529  19.010   2.077  1.00 14.88          
ATOM   1310  O   GLU   177      15.556  18.529   2.563  1.00 15.38          
ATOM   1311  N   LEU   178      13.399  19.228   2.772  1.00 15.17          
ATOM   1312  CA  LEU   178      13.253  18.753   4.155  1.00 13.61          
ATOM   1313  CB  LEU   178      12.113  19.531   4.856  1.00 13.92          
ATOM   1314  CG  LEU   178      12.475  20.887   5.472  1.00 15.48          
ATOM   1315  CD1 LEU   178      13.115  21.900   4.487  1.00 13.85          
ATOM   1316  CD2 LEU   178      11.229  21.479   6.147  1.00 15.08          
ATOM   1317  C   LEU   178      12.875  17.281   4.120  1.00 13.25          
ATOM   1318  O   LEU   178      11.913  16.929   3.433  1.00 12.73          
ATOM   1319  N   LEU   179      13.622  16.438   4.860  1.00 11.69          
ATOM   1320  CA  LEU   179      13.373  14.995   4.819  1.00 12.26          
ATOM   1321  CB  LEU   179      14.454  14.296   3.953  1.00 13.90          
ATOM   1322  CG  LEU   179      14.383  14.741   2.481  1.00 13.72          
ATOM   1323  CD1 LEU   179      15.637  14.136   1.827  1.00 19.33          
ATOM   1324  CD2 LEU   179      13.119  14.238   1.798  1.00 12.85          
ATOM   1325  C   LEU   179      13.402  14.461   6.256  1.00 12.47          
ATOM   1326  O   LEU   179      14.416  14.601   6.967  1.00 13.52          
ATOM   1327  N   VAL   180      12.270  13.883   6.641  1.00 12.52          
ATOM   1328  CA  VAL   180      12.051  13.552   8.064  1.00 12.37          
ATOM   1329  CB  VAL   180      10.659  14.081   8.518  1.00 11.10          
ATOM   1330  CG1 VAL   180       9.484  13.340   7.852  1.00 12.11          
ATOM   1331  CG2 VAL   180      10.509  14.040  10.033  1.00 12.89          
ATOM   1332  C   VAL   180      12.158  12.057   8.334  1.00 12.01          
ATOM   1333  O   VAL   180      11.830  11.192   7.473  1.00 12.32          
ATOM   1334  N   TRP   181      12.605  11.732   9.540  1.00 11.76          
ATOM   1335  CA  TRP   181      12.424  10.366  10.057  1.00 12.35          
ATOM   1336  CB  TRP   181      13.645   9.465   9.812  1.00 12.62          
ATOM   1337  CG  TRP   181      13.318   7.983  10.022  1.00 13.27          
ATOM   1338  CD1 TRP   181      13.602   7.222  11.107  1.00 13.48          
ATOM   1339  NE1 TRP   181      13.111   5.923  10.929  1.00 15.11          
ATOM   1340  CE2 TRP   181      12.471   5.871   9.713  1.00 13.59          
ATOM   1341  CD2 TRP   181      12.597   7.162   9.113  1.00 13.01          
ATOM   1342  CE3 TRP   181      12.032   7.387   7.849  1.00 16.97          
ATOM   1343  CZ3 TRP   181      11.366   6.302   7.201  1.00 18.37          
ATOM   1344  CH2 TRP   181      11.276   5.042   7.841  1.00 18.49          
ATOM   1345  CZ2 TRP   181      11.831   4.815   9.083  1.00 16.42          
ATOM   1346  C   TRP   181      12.159  10.481  11.578  1.00 13.01          
ATOM   1347  O   TRP   181      12.525  11.490  12.221  1.00 12.24          
ATOM   1348  N   TYR   182      11.524   9.455  12.130  1.00 12.62          
ATOM   1349  CA  TYR   182      11.257   9.383  13.563  1.00 12.41          
ATOM   1350  CB  TYR   182      10.559   8.031  13.882  1.00 13.88          
ATOM   1351  CG  TYR   182       9.396   7.801  12.985  1.00 13.53          
ATOM   1352  CD1 TYR   182       8.199   8.468  13.197  1.00 15.77          
ATOM   1353  CE1 TYR   182       7.108   8.281  12.303  1.00 16.10          
ATOM   1354  CZ  TYR   182       7.255   7.412  11.228  1.00 19.41          
ATOM   1355  OH  TYR   182       6.201   7.228  10.341  1.00 21.24          
ATOM   1356  CE2 TYR   182       8.446   6.764  10.988  1.00 17.81          
ATOM   1357  CD2 TYR   182       9.521   6.952  11.880  1.00 16.55          
ATOM   1358  C   TYR   182      12.559   9.484  14.370  1.00 12.43          
ATOM   1359  O   TYR   182      13.589   8.946  13.980  1.00 12.78          
ATOM   1360  N   CYS   183      12.507  10.138  15.528  1.00 12.40          
ATOM   1361  CA  CYS   183      13.605  10.058  16.477  1.00 13.48          
ATOM   1362  CB  CYS   183      13.386  11.080  17.597  1.00 14.04          
ATOM   1363  SG  CYS   183      12.010  10.667  18.715  1.00 17.39          
ATOM   1364  C   CYS   183      13.672   8.620  17.046  1.00 13.27          
ATOM   1365  O   CYS   183      12.750   7.799  16.809  1.00 13.56          
ATOM   1366  N   ARG   184      14.735   8.294  17.778  1.00 14.16          
ATOM   1367  CA  ARG   184      14.922   6.905  18.228  1.00 14.62          
ATOM   1368  CB  ARG   184      16.208   6.732  19.061  1.00 16.37          
ATOM   1369  CG  ARG   184      16.219   5.370  19.761  1.00 17.38          
ATOM   1370  CD  ARG   184      17.595   4.962  20.293  1.00 23.67          
ATOM   1371  NE  ARG   184      18.003   5.887  21.324  1.00 26.32          
ATOM   1372  CZ  ARG   184      19.095   5.728  22.073  1.00 30.34          
ATOM   1373  NH1 ARG   184      19.893   4.668  21.889  1.00 30.39          
ATOM   1374  NH2 ARG   184      19.391   6.647  22.989  1.00 32.65          
ATOM   1375  C   ARG   184      13.724   6.385  19.028  1.00 14.23          
ATOM   1376  O   ARG   184      13.211   5.287  18.751  1.00 15.00          
ATOM   1377  N   ASP   185      13.258   7.168  19.991  1.00 14.37          
ATOM   1378  CA  ASP   185      12.202   6.659  20.881  1.00 15.64          
ATOM   1379  CB  ASP   185      12.026   7.529  22.110  1.00 16.39          
ATOM   1380  CG  ASP   185      13.241   7.426  23.092  1.00 22.81          
ATOM   1381  OD1 ASP   185      14.022   6.448  23.036  1.00 28.74          
ATOM   1382  OD2 ASP   185      13.369   8.327  23.928  1.00 31.55          
ATOM   1383  C   ASP   185      10.881   6.469  20.133  1.00 14.57          
ATOM   1384  O   ASP   185      10.145   5.472  20.356  1.00 15.97          
ATOM   1385  N   PHE   186      10.589   7.390  19.199  1.00 14.32          
ATOM   1386  CA  PHE   186       9.349   7.297  18.405  1.00 13.77          
ATOM   1387  CB  PHE   186       9.189   8.606  17.639  1.00 14.89          
ATOM   1388  CG  PHE   186       7.829   8.835  17.034  1.00 12.68          
ATOM   1389  CD1 PHE   186       7.495  10.127  16.505  1.00 12.50          
ATOM   1390  CE1 PHE   186       6.238  10.406  15.968  1.00 15.36          
ATOM   1391  CZ  PHE   186       5.260   9.412  15.911  1.00 15.41          
ATOM   1392  CE2 PHE   186       5.538   8.150  16.418  1.00 13.52          
ATOM   1393  CD2 PHE   186       6.844   7.846  16.996  1.00 13.10          
ATOM   1394  C   PHE   186       9.471   6.083  17.476  1.00 13.73          
ATOM   1395  O   PHE   186       8.557   5.245  17.420  1.00 14.66          
ATOM   1396  N   ALA   187      10.605   5.945  16.775  1.00 12.95          
ATOM   1397  CA  ALA   187      10.835   4.763  15.919  1.00 13.52          
ATOM   1398  CB  ALA   187      12.195   4.815  15.311  1.00 14.41          
ATOM   1399  C   ALA   187      10.656   3.445  16.720  1.00 15.17          
ATOM   1400  O   ALA   187      10.018   2.510  16.246  1.00 16.00          
ATOM   1401  N   GLU   188      11.140   3.428  17.955  1.00 14.73          
ATOM   1402  CA  GLU   188      11.031   2.210  18.793  1.00 16.62          
ATOM   1403  CB  GLU   188      11.935   2.326  20.015  1.00 17.03          
ATOM   1404  CG  GLU   188      13.365   2.051  19.620  1.00 20.37          
ATOM   1405  CD  GLU   188      14.305   1.915  20.788  1.00 29.43          
ATOM   1406  OE1 GLU   188      13.906   2.238  21.920  1.00 33.14          
ATOM   1407  OE2 GLU   188      15.467   1.504  20.552  1.00 33.89          
ATOM   1408  C   GLU   188       9.570   1.929  19.170  1.00 17.20          
ATOM   1409  O   GLU   188       9.162   0.781  19.173  1.00 18.74          
ATOM   1410  N   ARG   189       8.770   2.963  19.423  1.00 17.20          
ATOM   1411  CA  ARG   189       7.334   2.729  19.658  1.00 17.74          
ATOM   1412  CB  ARG   189       6.586   4.007  20.014  1.00 15.81          
ATOM   1413  CG  ARG   189       7.045   4.653  21.339  1.00 16.40          
ATOM   1414  CD  ARG   189       6.101   5.707  21.793  1.00 18.68          
ATOM   1415  NE  ARG   189       6.129   6.936  20.978  1.00 18.77          
ATOM   1416  CZ  ARG   189       6.994   7.936  21.150  1.00 17.68          
ATOM   1417  NH1 ARG   189       7.944   7.883  22.086  1.00 18.36          
ATOM   1418  NH2 ARG   189       6.915   9.003  20.355  1.00 14.81          
ATOM   1419  C   ARG   189       6.672   2.059  18.459  1.00 17.30          
ATOM   1420  O   ARG   189       5.728   1.290  18.628  1.00 19.10          
ATOM   1421  N   LEU   190       7.130   2.386  17.248  1.00 15.86          
ATOM   1422  CA  LEU   190       6.572   1.877  15.989  1.00 17.58          
ATOM   1423  CB  LEU   190       6.771   2.934  14.894  1.00 17.31          
ATOM   1424  CG  LEU   190       6.171   4.310  15.085  1.00 20.54          
ATOM   1425  CD1 LEU   190       6.435   5.230  13.884  1.00 18.58          
ATOM   1426  CD2 LEU   190       4.685   4.245  15.320  1.00 20.99          
ATOM   1427  C   LEU   190       7.238   0.577  15.518  1.00 18.20          
ATOM   1428  O   LEU   190       6.847   0.011  14.452  1.00 20.33          
ATOM   1429  N   HSD   191       8.223   0.092  16.287  1.00 18.24          
ATOM   1430  CA  HSD   191       9.076  -1.041  15.855  1.00 19.88          
ATOM   1431  CB  HSD   191       8.316  -2.385  15.937  1.00 21.68          
ATOM   1432  CG  HSD   191       7.851  -2.693  17.312  1.00 23.50          
ATOM   1433  ND1 HSD   191       8.678  -3.249  18.268  1.00 27.79          
ATOM   1434  CE1 HSD   191       8.012  -3.359  19.406  1.00 29.95          
ATOM   1435  NE2 HSD   191       6.793  -2.877  19.224  1.00 30.60          
ATOM   1436  CD2 HSD   191       6.671  -2.445  17.927  1.00 28.25          
ATOM   1437  C   HSD   191       9.639  -0.785  14.466  1.00 19.39          
ATOM   1438  O   HSD   191       9.695  -1.682  13.599  1.00 20.57          
ATOM   1439  N   TYR   192      10.062   0.462  14.261  1.00 18.10          
ATOM   1440  CA  TYR   192      10.781   0.887  13.034  1.00 19.13          
ATOM   1441  CB  TYR   192      10.237   2.244  12.565  1.00 21.41          
ATOM   1442  CG  TYR   192       9.025   2.180  11.683  1.00 23.50          
ATOM   1443  CD1 TYR   192       8.276   1.001  11.557  1.00 25.87          
ATOM   1444  CE1 TYR   192       7.148   0.953  10.759  1.00 29.21          
ATOM   1445  CZ  TYR   192       6.757   2.093  10.080  1.00 29.83          
ATOM   1446  OH  TYR   192       5.646   2.042   9.266  1.00 31.25          
ATOM   1447  CE2 TYR   192       7.469   3.267  10.199  1.00 29.65          
ATOM   1448  CD2 TYR   192       8.606   3.299  10.999  1.00 27.97          
ATOM   1449  C   TYR   192      12.310   1.009  13.257  1.00 18.84          
ATOM   1450  O   TYR   192      12.773   1.253  14.389  1.00 18.35          
ATOM   1451  N   PRO   193      13.096   0.883  12.166  1.00 18.14          
ATOM   1452  CA  PRO   193      14.542   1.126  12.215  1.00 18.36          
ATOM   1453  CB  PRO   193      15.016   0.688  10.819  1.00 18.99          
ATOM   1454  CG  PRO   193      13.827   0.957   9.928  1.00 20.21          
ATOM   1455  CD  PRO   193      12.635   0.551  10.799  1.00 19.24          
ATOM   1456  C   PRO   193      14.727   2.639  12.336  1.00 17.58          
ATOM   1457  O   PRO   193      13.765   3.413  12.107  1.00 17.22          
ATOM   1458  N   TYR   194      15.937   3.036  12.680  1.00 18.57          
ATOM   1459  CA  TYR   194      16.259   4.464  12.842  1.00 18.20          
ATOM   1460  CB  TYR   194      15.782   4.974  14.221  1.00 19.10          
ATOM   1461  CG  TYR   194      16.283   4.154  15.391  1.00 18.80          
ATOM   1462  CD1 TYR   194      17.480   4.484  16.052  1.00 20.15          
ATOM   1463  CE1 TYR   194      17.939   3.704  17.131  1.00 21.36          
ATOM   1464  CZ  TYR   194      17.193   2.600  17.540  1.00 21.29          
ATOM   1465  OH  TYR   194      17.633   1.811  18.594  1.00 23.89          
ATOM   1466  CE2 TYR   194      16.017   2.261  16.885  1.00 19.66          
ATOM   1467  CD2 TYR   194      15.571   3.029  15.835  1.00 20.06          
ATOM   1468  C   TYR   194      17.753   4.708  12.678  1.00 18.24          
ATOM   1469  O   TYR   194      18.579   3.818  12.950  1.00 17.51          
ATOM   1470  N   PRO   195      18.126   5.933  12.251  1.00 17.99          
ATOM   1471  CA  PRO   195      19.548   6.248  12.181  1.00 18.36          
ATOM   1472  CB  PRO   195      19.575   7.741  11.734  1.00 17.90          
ATOM   1473  CG  PRO   195      18.279   7.937  11.038  1.00 17.98          
ATOM   1474  CD  PRO   195      17.288   7.051  11.793  1.00 18.19          
ATOM   1475  C   PRO   195      20.245   6.033  13.538  1.00 18.55          
ATOM   1476  O   PRO   195      19.716   6.414  14.594  1.00 18.18          
END
