
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  161 ( 1283),  selected  161 , name 1zkk_D
# Molecule2: number of CA atoms  157 ( 1301),  selected  157 , name T0434_28_195.pdb
# PARAMETERS: 1zkk_D.T0434_28_195.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R   192_D      M      28           -
LGA    K   193_D      T      29           -
LGA    S   194_D      L      30           -
LGA    K   195_D      W      31           -
LGA    A   196_D      T      32           -
LGA    E   197_D      E      33           -
LGA    L   198_D      A      34           -
LGA    -       -      E      35           -
LGA    -       -      F      36           -
LGA    -       -      E      37           -
LGA    Q   199_D      E      38          4.371
LGA    S   200_D      -       -           -
LGA    E   201_D      -       -           -
LGA    E   202_D      K      39          6.035
LGA    R   203_D      C      40           #
LGA    K   204_D      T      41           -
LGA    R   205_D      Y      42          5.392
LGA    I   206_D      I      43          4.037
LGA    D   207_D      -       -           -
LGA    E   208_D      -       -           -
LGA    L   209_D      V      44          4.227
LGA    I   210_D      N      45          4.844
LGA    E   211_D      -       -           -
LGA    S   212_D      D      46          5.315
LGA    G   213_D      X      47          5.011
LGA    K   214_D      P      48          4.363
LGA    -       -      W      49           -
LGA    -       -      D      50           -
LGA    -       -      V      59           -
LGA    -       -      Q      60           -
LGA    -       -      A      61           -
LGA    -       -      E      62           -
LGA    -       -      A      63           -
LGA    -       -      S      64           -
LGA    E   215_D      L      65          3.916
LGA    E   216_D      P      66          2.000
LGA    -       -      R      67           -
LGA    G   217_D      N      68          0.953
LGA    M   218_D      L      69          0.999
LGA    K   219_D      L      70          1.367
LGA    I   220_D      F      71          1.248
LGA    D   221_D      K      72          1.682
LGA    L   222_D      Y      73          1.727
LGA    -       -      A      74           -
LGA    I   223_D      T      75           #
LGA    D   224_D      N      76           -
LGA    G   225_D      S      77           -
LGA    K   226_D      E      78           -
LGA    -       -      E      79           -
LGA    G   227_D      V      80          5.751
LGA    R   228_D      I      81          1.281
LGA    G   229_D      G      82          0.682
LGA    V   230_D      V      83          0.606
LGA    I   231_D      M      84          0.824
LGA    A   232_D      S      85          0.742
LGA    T   233_D      K      86          0.570
LGA    K   234_D      E      87          1.696
LGA    Q   235_D      Y      88          1.475
LGA    F   236_D      I      89          1.505
LGA    S   237_D      P      90          1.598
LGA    R   238_D      K      91          1.551
LGA    G   239_D      G      92          1.493
LGA    D   240_D      T      93          0.857
LGA    F   241_D      R      94          0.896
LGA    V   242_D      F      95          3.154
LGA    V   243_D      G      96          3.776
LGA    E   244_D      P      97          3.262
LGA    Y   245_D      L      98          2.613
LGA    H   246_D      I      99          1.904
LGA    G   247_D      G     100          0.941
LGA    D   248_D      E     101          1.917
LGA    L   249_D      I     102          3.005
LGA    I   250_D      Y     103          3.040
LGA    E   251_D      T     104          2.560
LGA    I   252_D      N     105          2.924
LGA    T   253_D      D     106          2.303
LGA    D   254_D      T     107          2.138
LGA    A   255_D      V     108          3.202
LGA    K   256_D      -       -           -
LGA    K   257_D      -       -           -
LGA    R   258_D      P     109          2.140
LGA    E   259_D      -       -           -
LGA    A   260_D      -       -           -
LGA    L   261_D      -       -           -
LGA    Y   262_D      N     113          3.915
LGA    A   263_D      R     114           -
LGA    Q   264_D      -       -           -
LGA    D   265_D      -       -           -
LGA    P   266_D      -       -           -
LGA    S   267_D      -       -           -
LGA    T   268_D      -       -           -
LGA    G   269_D      -       -           -
LGA    C   270_D      K     115          1.681
LGA    Y   271_D      Y     116          1.132
LGA    M   272_D      F     117          1.119
LGA    Y   273_D      W     118          1.258
LGA    Y   274_D      R     119          1.820
LGA    F   275_D      I     120          3.520
LGA    Q   276_D      Y     121          2.176
LGA    Y   277_D      S     122          2.738
LGA    L   278_D      R     123          2.346
LGA    S   279_D      G     124          2.838
LGA    K   280_D      E     125          2.938
LGA    T   281_D      L     126          1.542
LGA    Y   282_D      X     127          3.813
LGA    -       -      X     128           -
LGA    C   283_D      F     129          1.182
LGA    V   284_D      I     130          0.997
LGA    D   285_D      D     131          0.816
LGA    A   286_D      G     132          0.949
LGA    T   287_D      F     133          1.217
LGA    R   288_D      N     134          0.684
LGA    E   289_D      E     135          1.197
LGA    T   290_D      E     136          3.193
LGA    N   291_D      K     137           -
LGA    -       -      S     138           -
LGA    R   292_D      N     139          2.226
LGA    L   293_D      W     140          1.264
LGA    G   294_D      M     141          0.304
LGA    R   295_D      R     142          0.172
LGA    L   296_D      Y     143          0.459
LGA    I   297_D      V     144          0.653
LGA    N   298_D      N     145          0.857
LGA    H   299_D      P     146          1.521
LGA    S   300_D      A     147          1.412
LGA    K   301_D      X     148          3.235
LGA    C   302_D      S     149          2.980
LGA    -       -      P     150           -
LGA    -       -      R     151           -
LGA    G   303_D      E     152          3.366
LGA    -       -      Q     153           -
LGA    N   304_D      N     154          0.878
LGA    C   305_D      L     155          0.634
LGA    Q   306_D      A     156          0.718
LGA    T   307_D      A     157          0.162
LGA    K   308_D      C     158          0.714
LGA    L   309_D      Q     159          0.740
LGA    H   310_D      N     160          1.237
LGA    D   311_D      G     161          1.545
LGA    I   312_D      -       -           -
LGA    D   313_D      -       -           -
LGA    G   314_D      -       -           -
LGA    V   315_D      -       -           -
LGA    P   316_D      M     162          0.867
LGA    H   317_D      N     163          0.819
LGA    L   318_D      I     164          0.720
LGA    I   319_D      Y     165          0.690
LGA    L   320_D      F     166          0.718
LGA    I   321_D      Y     167          0.571
LGA    A   322_D      T     168          0.414
LGA    S   323_D      I     169          1.309
LGA    R   324_D      K     170          0.603
LGA    D   325_D      P     171          0.829
LGA    I   326_D      I     172          0.733
LGA    A   327_D      P     173          0.650
LGA    A   328_D      A     174          0.988
LGA    G   329_D      N     175          0.517
LGA    E   330_D      Q     176          0.607
LGA    E   331_D      E     177          0.758
LGA    L   332_D      L     178          0.650
LGA    L   333_D      L     179          0.765
LGA    Y   334_D      V     180          1.202
LGA    D   335_D      W     181          2.542
LGA    Y   336_D      Y     182           #
LGA    -       -      C     183           -
LGA    -       -      R     184           -
LGA    -       -      D     185           -
LGA    -       -      F     186           -
LGA    -       -      A     187           -
LGA    -       -      E     188           -
LGA    -       -      R     189           -
LGA    G   337_D      L     190           #
LGA    D   338_D      X     191           -
LGA    R   339_D      Y     192           #
LGA    S   340_D      P     193           -
LGA    K   341_D      Y     194           -
LGA    A   342_D      P     195           -
LGA    S   343_D      -       -           -
LGA    I   344_D      -       -           -
LGA    E   345_D      -       -           -
LGA    A   346_D      -       -           -
LGA    H   347_D      -       -           -
LGA    P   348_D      -       -           -
LGA    W   349_D      -       -           -
LGA    L   350_D      -       -           -
LGA    K   351_D      -       -           -
LGA    H   352_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  161  157    5.0    109    2.31    14.68     57.871     4.525

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.092094 * X  +  -0.989115 * Y  +  -0.114761 * Z  +  22.410892
  Y_new =   0.652409 * X  +   0.027130 * Y  +  -0.757381 * Z  + -33.884445
  Z_new =   0.752250 * X  +  -0.144621 * Y  +   0.642810 * Z  +  50.566017 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.221298    2.920295  [ DEG:   -12.6794    167.3206 ]
  Theta =  -0.851471   -2.290122  [ DEG:   -48.7857   -131.2143 ]
  Phi   =   1.711029   -1.430563  [ DEG:    98.0348    -81.9652 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1zkk_D                                        
REMARK     2: T0434_28_195.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1zkk_D.T0434_28_195.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  161  157   5.0  109   2.31   14.68  57.871
REMARK  ---------------------------------------------------------- 
MOLECULE 1zkk_D
HEADER    TRANSFERASE                             03-MAY-05   1ZKK              
TITLE     CRYSTAL STRUCTURE OF HSET8 IN TERNARY COMPLEX WITH H4                 
TITLE    2 PEPTIDE (16-24) AND ADOHCY                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HISTONE-LYSINE N-METHYLTRANSFERASE, H4 LYSINE-20           
COMPND   3 SPECIFIC;                                                            
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 FRAGMENT: SEQUENCE DATABASE RESIDUES 231-393;                        
COMPND   6 SYNONYM: HISTONE H4-K20 METHYLTRANSFERASE, H4-K20-HMTASE,            
COMPND   7 SET DOMAIN-CONTAINING PROTEIN 8, PR/SET DOMAIN-CONTAINING            
COMPND   8 PROTEIN 07, PR/SET07, PR-SET7, SET8;                                 
COMPND   9 EC: 2.1.1.43;                                                        
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MOL_ID: 2;                                                           
COMPND  12 MOLECULE: PEPTIDE CORRESPONDING TO RESIDUES 15-24 OF                 
COMPND  13 HISTONE H4;                                                          
COMPND  14 CHAIN: E, F, G, H;                                                   
COMPND  15 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SET8, PRSET7, SET07;                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21-DE3PLYSS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PHIS2;                                    
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 SYNTHETIC: YES;                                                      
SOURCE  12 OTHER_DETAILS: CHAIN E, F, G, H ARE SYNTHETIC PEPTIDE FROM           
SOURCE  13 NEW ENGLAND PEPTIDE CORRESPONDING TO RESIDUE 15-24 OF THE            
SOURCE  14 HISTONE H4                                                           
KEYWDS    PSEUDO-KNOT, HISTONE H4, BETA-SHEET                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.-F.COUTURE,E.COLLAZO,J.S.BRUNZELLE,R.C.TRIEVEL                      
REVDAT   2   05-JUL-05 1ZKK    1       JRNL                                     
REVDAT   1   07-JUN-05 1ZKK    0                                                
JRNL        AUTH   J.-F.COUTURE,E.COLLAZO,J.S.BRUNZELLE,R.C.TRIEVEL             
JRNL        TITL   STRUCTURAL AND FUNCTIONAL ANALYSIS OF SET8, A                
JRNL        TITL 2 HISTONE H4 LYS-20 METHYLTRANSFERASE                          
JRNL        REF    GENES DEV.                    V.  19  1455 2005              
JRNL        REFN   ASTM GEDEEP  US ISSN 0890-9369                               
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  1ZKK A  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
DBREF  1ZKK B  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
DBREF  1ZKK C  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
DBREF  1ZKK D  190   352  UNP    Q9NQR1   SET07_HUMAN    231    393             
SEQRES   1 A  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 A  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 A  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 A  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 A  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 A  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 A  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 A  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 A  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 A  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 A  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 A  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 A  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 B  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 B  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 B  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 B  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 B  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 B  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 B  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 B  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 B  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 B  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 B  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 B  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 B  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 C  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 C  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 C  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 C  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 C  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 C  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 C  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 C  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 C  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 C  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 C  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 C  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 C  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 D  167  GLY ALA MET GLY SER SER ARG LYS SER LYS ALA GLU LEU          
SEQRES   2 D  167  GLN SER GLU GLU ARG LYS ARG ILE ASP GLU LEU ILE GLU          
SEQRES   3 D  167  SER GLY LYS GLU GLU GLY MET LYS ILE ASP LEU ILE ASP          
SEQRES   4 D  167  GLY LYS GLY ARG GLY VAL ILE ALA THR LYS GLN PHE SER          
SEQRES   5 D  167  ARG GLY ASP PHE VAL VAL GLU TYR HIS GLY ASP LEU ILE          
SEQRES   6 D  167  GLU ILE THR ASP ALA LYS LYS ARG GLU ALA LEU TYR ALA          
SEQRES   7 D  167  GLN ASP PRO SER THR GLY CYS TYR MET TYR TYR PHE GLN          
SEQRES   8 D  167  TYR LEU SER LYS THR TYR CYS VAL ASP ALA THR ARG GLU          
SEQRES   9 D  167  THR ASN ARG LEU GLY ARG LEU ILE ASN HIS SER LYS CYS          
SEQRES  10 D  167  GLY ASN CYS GLN THR LYS LEU HIS ASP ILE ASP GLY VAL          
SEQRES  11 D  167  PRO HIS LEU ILE LEU ILE ALA SER ARG ASP ILE ALA ALA          
SEQRES  12 D  167  GLY GLU GLU LEU LEU TYR ASP TYR GLY ASP ARG SER LYS          
SEQRES  13 D  167  ALA SER ILE GLU ALA HIS PRO TRP LEU LYS HIS                  
SEQRES   1 E   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
SEQRES   1 F   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
SEQRES   1 G   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
SEQRES   1 H   10  ALA LYS ARG HIS ARG LYS VAL LEU ARG ASP                      
HET    SAH   2800      26                                                       
HET    SAH   2801      26                                                       
HET    SAH   2802      26                                                       
HET    SAH   2803      26                                                       
HETNAM     SAH S-ADENOSYL-L-HOMOCYSTEINE                                        
FORMUL   9  SAH    4(C14 H20 N6 O5 S)                                           
FORMUL  13  HOH   *1007(H2 O)                                                   
CRYST1   43.960   45.775   94.435  89.22  87.07  90.72 P 1           4          
ATOM   3846  N   ARG D 192      26.418  33.536  31.887  1.00 28.55           N  
ATOM   3847  CA  ARG D 192      25.857  32.410  31.084  1.00 28.06           C  
ATOM   3848  C   ARG D 192      24.399  32.134  31.444  1.00 27.79           C  
ATOM   3849  O   ARG D 192      23.951  32.400  32.563  1.00 27.72           O  
ATOM   3850  CB  ARG D 192      26.705  31.145  31.265  1.00 28.35           C  
ATOM   3851  N   LYS D 193      23.656  31.598  30.482  1.00 27.32           N  
ATOM   3852  CA  LYS D 193      22.286  31.175  30.736  1.00 26.61           C  
ATOM   3853  C   LYS D 193      22.296  29.870  31.526  1.00 26.34           C  
ATOM   3854  O   LYS D 193      23.138  29.000  31.294  1.00 26.28           O  
ATOM   3855  CB  LYS D 193      21.501  31.041  29.429  1.00 26.48           C  
ATOM   3856  CG  LYS D 193      21.001  32.383  28.886  1.00 25.43           C  
ATOM   3857  CD  LYS D 193      20.279  32.224  27.568  1.00 24.56           C  
ATOM   3858  CE  LYS D 193      20.087  33.565  26.867  1.00 22.65           C  
ATOM   3859  NZ  LYS D 193      19.061  34.449  27.525  1.00 21.38           N  
ATOM   3860  N   SER D 194      21.383  29.760  32.487  1.00 25.78           N  
ATOM   3861  CA  SER D 194      21.235  28.534  33.279  1.00 25.72           C  
ATOM   3862  C   SER D 194      20.556  27.454  32.445  1.00 25.78           C  
ATOM   3863  O   SER D 194      19.912  27.755  31.440  1.00 24.79           O  
ATOM   3864  CB  SER D 194      20.398  28.807  34.530  1.00 25.74           C  
ATOM   3865  OG  SER D 194      19.021  28.958  34.199  1.00 26.48           O  
ATOM   3866  N   LYS D 195      20.706  26.199  32.869  1.00 26.01           N  
ATOM   3867  CA  LYS D 195      20.006  25.074  32.251  1.00 26.67           C  
ATOM   3868  C   LYS D 195      18.497  25.351  32.187  1.00 25.84           C  
ATOM   3869  O   LYS D 195      17.876  25.153  31.143  1.00 25.43           O  
ATOM   3870  CB  LYS D 195      20.313  23.777  33.018  1.00 27.00           C  
ATOM   3871  CG  LYS D 195      19.634  22.520  32.488  1.00 28.38           C  
ATOM   3872  CD  LYS D 195      19.924  21.321  33.402  1.00 28.42           C  
ATOM   3873  CE  LYS D 195      19.191  20.059  32.946  1.00 31.16           C  
ATOM   3874  NZ  LYS D 195      19.570  19.630  31.562  1.00 32.40           N  
ATOM   3875  N   ALA D 196      17.924  25.838  33.289  1.00 25.35           N  
ATOM   3876  CA  ALA D 196      16.491  26.158  33.341  1.00 24.58           C  
ATOM   3877  C   ALA D 196      16.108  27.220  32.319  1.00 23.97           C  
ATOM   3878  O   ALA D 196      15.090  27.078  31.634  1.00 23.62           O  
ATOM   3879  CB  ALA D 196      16.079  26.595  34.742  1.00 24.90           C  
ATOM   3880  N   GLU D 197      16.913  28.277  32.225  1.00 22.97           N  
ATOM   3881  CA  GLU D 197      16.701  29.325  31.230  1.00 22.53           C  
ATOM   3882  C   GLU D 197      16.786  28.730  29.830  1.00 21.63           C  
ATOM   3883  O   GLU D 197      15.931  29.004  29.001  1.00 21.02           O  
ATOM   3884  CB  GLU D 197      17.730  30.454  31.369  1.00 22.95           C  
ATOM   3885  CG  GLU D 197      17.478  31.437  32.501  1.00 25.58           C  
ATOM   3886  CD  GLU D 197      18.762  31.832  33.202  1.00 28.90           C  
ATOM   3887  OE1 GLU D 197      18.824  31.674  34.441  1.00 31.26           O  
ATOM   3888  OE2 GLU D 197      19.719  32.265  32.519  1.00 29.55           O  
ATOM   3889  N   LEU D 198      17.824  27.932  29.579  1.00 20.59           N  
ATOM   3890  CA  LEU D 198      18.004  27.289  28.276  1.00 19.70           C  
ATOM   3891  C   LEU D 198      16.830  26.397  27.893  1.00 19.25           C  
ATOM   3892  O   LEU D 198      16.375  26.449  26.755  1.00 17.77           O  
ATOM   3893  CB  LEU D 198      19.302  26.489  28.227  1.00 20.02           C  
ATOM   3894  CG  LEU D 198      20.601  27.308  28.113  1.00 19.79           C  
ATOM   3895  CD1 LEU D 198      21.778  26.373  28.289  1.00 21.07           C  
ATOM   3896  CD2 LEU D 198      20.723  28.098  26.797  1.00 19.49           C  
ATOM   3897  N   GLN D 199      16.347  25.593  28.839  1.00 19.06           N  
ATOM   3898  CA  GLN D 199      15.189  24.723  28.588  1.00 18.90           C  
ATOM   3899  C   GLN D 199      13.939  25.548  28.349  1.00 18.37           C  
ATOM   3900  O   GLN D 199      13.173  25.264  27.421  1.00 17.30           O  
ATOM   3901  CB  GLN D 199      14.946  23.735  29.734  1.00 19.55           C  
ATOM   3902  CG  GLN D 199      15.936  22.584  29.794  1.00 21.59           C  
ATOM   3903  CD  GLN D 199      15.691  21.474  28.758  1.00 24.13           C  
ATOM   3904  OE1 GLN D 199      16.413  20.469  28.732  1.00 26.95           O  
ATOM   3905  NE2 GLN D 199      14.683  21.652  27.905  1.00 24.81           N  
ATOM   3906  N   SER D 200      13.714  26.560  29.179  1.00 17.90           N  
ATOM   3907  CA  SER D 200      12.512  27.377  29.012  1.00 18.45           C  
ATOM   3908  C   SER D 200      12.555  28.205  27.713  1.00 18.45           C  
ATOM   3909  O   SER D 200      11.533  28.374  27.054  1.00 17.99           O  
ATOM   3910  CB  SER D 200      12.172  28.215  30.268  1.00 19.27           C  
ATOM   3911  OG  SER D 200      13.011  29.335  30.438  1.00 22.43           O  
ATOM   3912  N   GLU D 201      13.747  28.687  27.351  1.00 18.23           N  
ATOM   3913  CA  GLU D 201      13.943  29.429  26.104  1.00 18.10           C  
ATOM   3914  C   GLU D 201      13.756  28.520  24.889  1.00 16.92           C  
ATOM   3915  O   GLU D 201      13.202  28.954  23.888  1.00 17.12           O  
ATOM   3916  CB  GLU D 201      15.327  30.081  26.072  1.00 19.05           C  
ATOM   3917  CG  GLU D 201      15.393  31.356  26.886  1.00 20.96           C  
ATOM   3918  CD  GLU D 201      16.753  32.027  26.848  1.00 23.66           C  
ATOM   3919  OE1 GLU D 201      17.535  31.798  25.898  1.00 26.03           O  
ATOM   3920  OE2 GLU D 201      17.046  32.777  27.796  1.00 25.97           O  
ATOM   3921  N   GLU D 202      14.210  27.273  25.000  1.00 16.20           N  
ATOM   3922  CA  GLU D 202      14.044  26.257  23.948  1.00 15.83           C  
ATOM   3923  C   GLU D 202      12.561  25.965  23.728  1.00 15.54           C  
ATOM   3924  O   GLU D 202      12.061  26.009  22.597  1.00 15.21           O  
ATOM   3925  CB  GLU D 202      14.811  24.977  24.313  1.00 16.38           C  
ATOM   3926  CG  GLU D 202      14.441  23.704  23.535  1.00 17.83           C  
ATOM   3927  CD  GLU D 202      15.024  23.634  22.132  1.00 19.52           C  
ATOM   3928  OE1 GLU D 202      15.734  24.570  21.711  1.00 21.06           O  
ATOM   3929  OE2 GLU D 202      14.767  22.619  21.453  1.00 20.73           O  
ATOM   3930  N   ARG D 203      11.853  25.699  24.819  1.00 14.90           N  
ATOM   3931  CA  ARG D 203      10.411  25.463  24.745  1.00 14.64           C  
ATOM   3932  C   ARG D 203       9.638  26.675  24.222  1.00 14.26           C  
ATOM   3933  O   ARG D 203       8.646  26.526  23.501  1.00 13.86           O  
ATOM   3934  CB  ARG D 203       9.875  25.016  26.109  1.00 14.64           C  
ATOM   3935  CG  ARG D 203       8.375  24.873  26.160  1.00 15.59           C  
ATOM   3936  CD  ARG D 203       7.885  24.272  27.472  1.00 14.96           C  
ATOM   3937  NE  ARG D 203       8.129  22.831  27.547  1.00 15.64           N  
ATOM   3938  CZ  ARG D 203       7.354  21.920  26.957  1.00 15.55           C  
ATOM   3939  NH1 ARG D 203       6.294  22.300  26.261  1.00 16.45           N  
ATOM   3940  NH2 ARG D 203       7.636  20.629  27.062  1.00 18.41           N  
ATOM   3941  N   LYS D 204      10.084  27.873  24.599  1.00 14.65           N  
ATOM   3942  CA  LYS D 204       9.481  29.102  24.124  1.00 15.33           C  
ATOM   3943  C   LYS D 204       9.581  29.205  22.596  1.00 15.11           C  
ATOM   3944  O   LYS D 204       8.595  29.528  21.943  1.00 15.31           O  
ATOM   3945  CB  LYS D 204      10.168  30.290  24.793  1.00 16.33           C  
ATOM   3946  CG  LYS D 204       9.499  31.613  24.548  1.00 18.46           C  
ATOM   3947  CD  LYS D 204      10.193  32.718  25.345  1.00 19.68           C  
ATOM   3948  CE  LYS D 204       9.697  34.089  24.920  1.00 21.88           C  
ATOM   3949  NZ  LYS D 204       8.253  34.280  25.207  1.00 23.07           N  
ATOM   3950  N   ARG D 205      10.758  28.907  22.034  1.00 14.69           N  
ATOM   3951  CA  ARG D 205      10.926  28.956  20.570  1.00 14.72           C  
ATOM   3952  C   ARG D 205       9.948  27.997  19.901  1.00 13.93           C  
ATOM   3953  O   ARG D 205       9.205  28.378  18.995  1.00 14.56           O  
ATOM   3954  CB  ARG D 205      12.362  28.625  20.141  1.00 14.84           C  
ATOM   3955  CG  ARG D 205      13.382  29.762  20.374  1.00 15.82           C  
ATOM   3956  CD  ARG D 205      14.767  29.434  19.772  1.00 15.94           C  
ATOM   3957  NE  ARG D 205      15.446  28.331  20.444  1.00 17.37           N  
ATOM   3958  CZ  ARG D 205      16.176  28.457  21.546  1.00 17.42           C  
ATOM   3959  NH1 ARG D 205      16.345  29.648  22.099  1.00 19.49           N  
ATOM   3960  NH2 ARG D 205      16.738  27.391  22.087  1.00 18.03           N  
ATOM   3961  N   ILE D 206       9.951  26.753  20.375  1.00 13.44           N  
ATOM   3962  CA  ILE D 206       9.137  25.695  19.791  1.00 13.10           C  
ATOM   3963  C   ILE D 206       7.647  25.985  19.934  1.00 13.04           C  
ATOM   3964  O   ILE D 206       6.891  25.976  18.956  1.00 12.78           O  
ATOM   3965  CB  ILE D 206       9.423  24.340  20.461  1.00 13.33           C  
ATOM   3966  CG1 ILE D 206      10.848  23.876  20.165  1.00 14.69           C  
ATOM   3967  CG2 ILE D 206       8.416  23.294  20.005  1.00 14.32           C  
ATOM   3968  CD1 ILE D 206      11.292  22.711  21.055  1.00 16.15           C  
ATOM   3969  N   ASP D 207       7.220  26.261  21.165  1.00 13.65           N  
ATOM   3970  CA  ASP D 207       5.793  26.358  21.441  1.00 14.27           C  
ATOM   3971  C   ASP D 207       5.180  27.584  20.763  1.00 14.14           C  
ATOM   3972  O   ASP D 207       4.036  27.545  20.303  1.00 15.05           O  
ATOM   3973  CB  ASP D 207       5.506  26.283  22.952  1.00 15.01           C  
ATOM   3974  CG  ASP D 207       5.858  24.915  23.546  1.00 15.24           C  
ATOM   3975  OD1 ASP D 207       6.331  24.016  22.807  1.00 17.39           O  
ATOM   3976  OD2 ASP D 207       5.682  24.720  24.773  1.00 17.97           O  
ATOM   3977  N   GLU D 208       5.963  28.651  20.626  1.00 14.76           N  
ATOM   3978  CA  GLU D 208       5.463  29.826  19.927  1.00 14.97           C  
ATOM   3979  C   GLU D 208       5.324  29.630  18.402  1.00 14.59           C  
ATOM   3980  O   GLU D 208       4.386  30.133  17.783  1.00 15.11           O  
ATOM   3981  CB  GLU D 208       6.248  31.074  20.338  1.00 15.57           C  
ATOM   3982  CG  GLU D 208       5.987  31.389  21.826  1.00 16.45           C  
ATOM   3983  CD  GLU D 208       6.761  32.576  22.372  1.00 16.98           C  
ATOM   3984  OE1 GLU D 208       7.416  33.288  21.589  1.00 19.43           O  
ATOM   3985  OE2 GLU D 208       6.685  32.809  23.606  1.00 19.35           O  
ATOM   3986  N   LEU D 209       6.223  28.836  17.812  1.00 13.39           N  
ATOM   3987  CA  LEU D 209       6.085  28.427  16.404  1.00 12.72           C  
ATOM   3988  C   LEU D 209       4.922  27.449  16.188  1.00 12.21           C  
ATOM   3989  O   LEU D 209       4.201  27.549  15.186  1.00 12.50           O  
ATOM   3990  CB  LEU D 209       7.395  27.831  15.877  1.00 12.50           C  
ATOM   3991  CG  LEU D 209       8.514  28.858  15.660  1.00 13.01           C  
ATOM   3992  CD1 LEU D 209       9.862  28.187  15.564  1.00 13.19           C  
ATOM   3993  CD2 LEU D 209       8.277  29.710  14.408  1.00 15.42           C  
ATOM   3994  N   ILE D 210       4.740  26.510  17.119  1.00 12.11           N  
ATOM   3995  CA  ILE D 210       3.578  25.614  17.083  1.00 12.53           C  
ATOM   3996  C   ILE D 210       2.276  26.400  17.117  1.00 13.15           C  
ATOM   3997  O   ILE D 210       1.387  26.194  16.276  1.00 13.92           O  
ATOM   3998  CB  ILE D 210       3.594  24.587  18.242  1.00 11.73           C  
ATOM   3999  CG1 ILE D 210       4.698  23.550  18.022  1.00 11.88           C  
ATOM   4000  CG2 ILE D 210       2.224  23.887  18.383  1.00 12.77           C  
ATOM   4001  CD1 ILE D 210       4.885  22.597  19.195  1.00 12.90           C  
ATOM   4002  N   GLU D 211       2.165  27.301  18.093  1.00 13.81           N  
ATOM   4003  CA  GLU D 211       0.918  28.020  18.295  1.00 15.28           C  
ATOM   4004  C   GLU D 211       0.585  28.999  17.178  1.00 14.79           C  
ATOM   4005  O   GLU D 211      -0.580  29.104  16.786  1.00 14.98           O  
ATOM   4006  CB  GLU D 211       0.919  28.734  19.640  1.00 16.17           C  
ATOM   4007  CG  GLU D 211       0.159  27.989  20.700  1.00 21.74           C  
ATOM   4008  CD  GLU D 211      -0.256  28.901  21.837  1.00 26.53           C  
ATOM   4009  OE1 GLU D 211       0.547  29.791  22.182  1.00 28.95           O  
ATOM   4010  OE2 GLU D 211      -1.376  28.740  22.383  1.00 29.21           O  
ATOM   4011  N   SER D 212       1.601  29.684  16.653  1.00 14.46           N  
ATOM   4012  CA  SER D 212       1.383  30.634  15.563  1.00 15.11           C  
ATOM   4013  C   SER D 212       1.072  29.928  14.250  1.00 14.94           C  
ATOM   4014  O   SER D 212       0.251  30.392  13.465  1.00 15.58           O  
ATOM   4015  CB  SER D 212       2.581  31.566  15.402  1.00 15.35           C  
ATOM   4016  OG  SER D 212       3.689  30.867  14.873  1.00 17.27           O  
ATOM   4017  N   GLY D 213       1.742  28.800  14.017  1.00 14.51           N  
ATOM   4018  CA  GLY D 213       1.520  28.015  12.802  1.00 14.43           C  
ATOM   4019  C   GLY D 213       1.805  28.721  11.488  1.00 14.15           C  
ATOM   4020  O   GLY D 213       1.252  28.341  10.467  1.00 15.02           O  
ATOM   4021  N   LYS D 214       2.683  29.727  11.501  1.00 14.68           N  
ATOM   4022  CA  LYS D 214       2.989  30.493  10.278  1.00 14.79           C  
ATOM   4023  C   LYS D 214       3.846  29.737   9.262  1.00 14.09           C  
ATOM   4024  O   LYS D 214       3.803  30.012   8.056  1.00 14.86           O  
ATOM   4025  CB  LYS D 214       3.622  31.843  10.617  1.00 15.73           C  
ATOM   4026  CG  LYS D 214       2.742  32.743  11.503  1.00 17.95           C  
ATOM   4027  CD  LYS D 214       1.286  32.831  11.025  1.00 23.36           C  
ATOM   4028  CE  LYS D 214       1.097  33.829   9.902  1.00 25.96           C  
ATOM   4029  NZ  LYS D 214      -0.352  34.025   9.596  1.00 27.80           N  
ATOM   4030  N   GLU D 215       4.646  28.801   9.761  1.00 12.44           N  
ATOM   4031  CA  GLU D 215       5.432  27.903   8.890  1.00 12.17           C  
ATOM   4032  C   GLU D 215       6.271  28.670   7.867  1.00 12.96           C  
ATOM   4033  O   GLU D 215       6.276  28.365   6.671  1.00 13.09           O  
ATOM   4034  CB  GLU D 215       4.510  26.865   8.230  1.00 11.66           C  
ATOM   4035  CG  GLU D 215       3.649  26.194   9.290  1.00 10.81           C  
ATOM   4036  CD  GLU D 215       2.890  24.966   8.838  1.00 10.64           C  
ATOM   4037  OE1 GLU D 215       2.669  24.794   7.622  1.00 11.04           O  
ATOM   4038  OE2 GLU D 215       2.494  24.187   9.736  1.00  9.99           O  
ATOM   4039  N   GLU D 216       6.985  29.672   8.373  1.00 13.90           N  
ATOM   4040  CA  GLU D 216       7.855  30.516   7.560  1.00 15.53           C  
ATOM   4041  C   GLU D 216       9.134  29.778   7.186  1.00 13.81           C  
ATOM   4042  O   GLU D 216       9.599  28.921   7.938  1.00 14.53           O  
ATOM   4043  CB  GLU D 216       8.186  31.810   8.324  1.00 15.77           C  
ATOM   4044  CG  GLU D 216       6.991  32.725   8.539  1.00 19.40           C  
ATOM   4045  CD  GLU D 216       7.380  34.157   8.876  1.00 20.87           C  
ATOM   4046  OE1 GLU D 216       7.991  34.378   9.945  1.00 26.24           O  
ATOM   4047  OE2 GLU D 216       7.062  35.070   8.073  1.00 27.12           O  
ATOM   4048  N   GLY D 217       9.686  30.101   6.020  1.00 12.92           N  
ATOM   4049  CA  GLY D 217      10.969  29.543   5.593  1.00 12.14           C  
ATOM   4050  C   GLY D 217      10.853  28.262   4.781  1.00 11.74           C  
ATOM   4051  O   GLY D 217      11.835  27.538   4.589  1.00 11.77           O  
ATOM   4052  N   MET D 218       9.644  28.005   4.270  1.00 11.20           N  
ATOM   4053  CA  MET D 218       9.362  26.811   3.481  1.00 11.60           C  
ATOM   4054  C   MET D 218       8.411  27.157   2.357  1.00 11.18           C  
ATOM   4055  O   MET D 218       7.617  28.080   2.493  1.00 11.82           O  
ATOM   4056  CB  MET D 218       8.679  25.770   4.365  1.00 11.32           C  
ATOM   4057  CG  MET D 218       9.585  25.158   5.425  1.00 12.03           C  
ATOM   4058  SD  MET D 218       8.614  24.189   6.606  1.00 13.28           S  
ATOM   4059  CE  MET D 218       8.090  25.476   7.731  1.00 15.34           C  
ATOM   4060  N   LYS D 219       8.488  26.397   1.268  1.00 10.87           N  
ATOM   4061  CA  LYS D 219       7.514  26.506   0.182  1.00 11.53           C  
ATOM   4062  C   LYS D 219       7.205  25.139  -0.399  1.00 11.06           C  
ATOM   4063  O   LYS D 219       7.969  24.194  -0.245  1.00 10.60           O  
ATOM   4064  CB  LYS D 219       8.036  27.429  -0.924  1.00 12.45           C  
ATOM   4065  CG  LYS D 219       9.171  26.811  -1.725  1.00 13.40           C  
ATOM   4066  CD  LYS D 219       9.670  27.741  -2.829  1.00 14.12           C  
ATOM   4067  CE  LYS D 219      10.796  27.075  -3.609  1.00 18.71           C  
ATOM   4068  NZ  LYS D 219      11.391  28.008  -4.616  1.00 21.90           N  
ATOM   4069  N   ILE D 220       6.069  25.046  -1.067  1.00 11.05           N  
ATOM   4070  CA  ILE D 220       5.712  23.858  -1.806  1.00 11.49           C  
ATOM   4071  C   ILE D 220       6.384  23.872  -3.169  1.00 12.41           C  
ATOM   4072  O   ILE D 220       6.476  24.923  -3.813  1.00 13.16           O  
ATOM   4073  CB  ILE D 220       4.182  23.796  -2.028  1.00 10.89           C  
ATOM   4074  CG1 ILE D 220       3.458  23.768  -0.674  1.00 10.37           C  
ATOM   4075  CG2 ILE D 220       3.814  22.601  -2.937  1.00 11.33           C  
ATOM   4076  CD1 ILE D 220       1.953  23.837  -0.774  1.00 10.22           C  
ATOM   4077  N   ASP D 221       6.858  22.706  -3.596  1.00 12.89           N  
ATOM   4078  CA  ASP D 221       7.136  22.502  -5.009  1.00 14.15           C  
ATOM   4079  C   ASP D 221       6.718  21.106  -5.428  1.00 12.86           C  
ATOM   4080  O   ASP D 221       6.329  20.269  -4.597  1.00 11.87           O  
ATOM   4081  CB  ASP D 221       8.599  22.752  -5.364  1.00 16.38           C  
ATOM   4082  CG  ASP D 221       8.786  23.226  -6.817  1.00 18.82           C  
ATOM   4083  OD1 ASP D 221       7.805  23.263  -7.619  1.00 18.53           O  
ATOM   4084  OD2 ASP D 221       9.935  23.593  -7.144  1.00 24.82           O  
ATOM   4085  N   LEU D 222       6.781  20.879  -6.731  1.00 12.26           N  
ATOM   4086  CA  LEU D 222       6.483  19.584  -7.294  1.00 11.33           C  
ATOM   4087  C   LEU D 222       7.784  18.840  -7.477  1.00 11.15           C  
ATOM   4088  O   LEU D 222       8.726  19.324  -8.116  1.00 12.35           O  
ATOM   4089  CB  LEU D 222       5.695  19.722  -8.600  1.00 12.15           C  
ATOM   4090  CG  LEU D 222       4.412  20.542  -8.376  1.00 13.64           C  
ATOM   4091  CD1 LEU D 222       3.686  20.770  -9.685  1.00 16.09           C  
ATOM   4092  CD2 LEU D 222       3.493  19.872  -7.364  1.00 14.91           C  
ATOM   4093  N   ILE D 223       7.851  17.667  -6.871  1.00 10.50           N  
ATOM   4094  CA  ILE D 223       9.056  16.874  -6.869  1.00  9.95           C  
ATOM   4095  C   ILE D 223       8.793  15.638  -7.719  1.00  9.89           C  
ATOM   4096  O   ILE D 223       7.849  14.878  -7.453  1.00  9.62           O  
ATOM   4097  CB  ILE D 223       9.421  16.442  -5.427  1.00 10.00           C  
ATOM   4098  CG1 ILE D 223       9.443  17.653  -4.467  1.00 11.10           C  
ATOM   4099  CG2 ILE D 223      10.772  15.650  -5.409  1.00  9.82           C  
ATOM   4100  CD1 ILE D 223      10.477  18.738  -4.783  1.00 13.69           C  
ATOM   4101  N   ASP D 224       9.613  15.442  -8.746  1.00 10.62           N  
ATOM   4102  CA  ASP D 224       9.413  14.362  -9.705  1.00 10.19           C  
ATOM   4103  C   ASP D 224       9.259  13.015  -8.995  1.00 10.49           C  
ATOM   4104  O   ASP D 224      10.135  12.595  -8.229  1.00 11.33           O  
ATOM   4105  CB  ASP D 224      10.565  14.332 -10.718  1.00 10.73           C  
ATOM   4106  CG  ASP D 224      10.274  13.440 -11.924  1.00 12.02           C  
ATOM   4107  OD1 ASP D 224       9.101  13.090 -12.182  1.00 12.10           O  
ATOM   4108  OD2 ASP D 224      11.245  13.110 -12.642  1.00 16.36           O  
ATOM   4109  N   GLY D 225       8.115  12.369  -9.229  1.00 10.39           N  
ATOM   4110  CA  GLY D 225       7.859  11.049  -8.658  1.00 10.35           C  
ATOM   4111  C   GLY D 225       7.436  11.017  -7.204  1.00 10.45           C  
ATOM   4112  O   GLY D 225       7.239   9.928  -6.643  1.00 11.19           O  
ATOM   4113  N   LYS D 226       7.268  12.190  -6.592  1.00  9.37           N  
ATOM   4114  CA  LYS D 226       6.825  12.233  -5.186  1.00  9.12           C  
ATOM   4115  C   LYS D 226       5.498  12.936  -4.992  1.00  9.08           C  
ATOM   4116  O   LYS D 226       4.889  12.788  -3.936  1.00 10.11           O  
ATOM   4117  CB  LYS D 226       7.864  12.909  -4.283  1.00  8.68           C  
ATOM   4118  CG  LYS D 226       9.253  12.296  -4.368  1.00  8.95           C  
ATOM   4119  CD  LYS D 226      10.154  12.809  -3.234  1.00  9.62           C  
ATOM   4120  CE  LYS D 226      11.624  12.502  -3.504  1.00 11.34           C  
ATOM   4121  NZ  LYS D 226      12.526  13.130  -2.494  1.00 11.12           N  
ATOM   4122  N   GLY D 227       5.042  13.699  -5.986  1.00  8.84           N  
ATOM   4123  CA  GLY D 227       3.905  14.579  -5.776  1.00  8.77           C  
ATOM   4124  C   GLY D 227       4.380  15.955  -5.362  1.00  8.42           C  
ATOM   4125  O   GLY D 227       5.327  16.499  -5.942  1.00  9.82           O  
ATOM   4126  N   ARG D 228       3.738  16.521  -4.351  1.00  7.89           N  
ATOM   4127  CA  ARG D 228       4.230  17.755  -3.742  1.00  8.12           C  
ATOM   4128  C   ARG D 228       5.318  17.400  -2.746  1.00  7.88           C  
ATOM   4129  O   ARG D 228       5.329  16.296  -2.189  1.00  8.49           O  
ATOM   4130  CB  ARG D 228       3.088  18.485  -3.029  1.00  8.49           C  
ATOM   4131  CG  ARG D 228       1.979  18.891  -3.986  1.00  8.64           C  
ATOM   4132  CD  ARG D 228       0.747  19.306  -3.252  1.00  8.94           C  
ATOM   4133  NE  ARG D 228       0.125  18.181  -2.553  1.00  8.05           N  
ATOM   4134  CZ  ARG D 228      -1.027  18.257  -1.894  1.00  8.17           C  
ATOM   4135  NH1 ARG D 228      -1.675  19.416  -1.809  1.00  9.29           N  
ATOM   4136  NH2 ARG D 228      -1.514  17.175  -1.286  1.00  9.81           N  
ATOM   4137  N   GLY D 229       6.196  18.366  -2.500  1.00  7.77           N  
ATOM   4138  CA  GLY D 229       7.174  18.287  -1.437  1.00  8.10           C  
ATOM   4139  C   GLY D 229       7.381  19.678  -0.889  1.00  8.17           C  
ATOM   4140  O   GLY D 229       6.793  20.644  -1.392  1.00  9.50           O  
ATOM   4141  N   VAL D 230       8.223  19.777   0.139  1.00  7.75           N  
ATOM   4142  CA  VAL D 230       8.472  21.061   0.779  1.00  8.07           C  
ATOM   4143  C   VAL D 230       9.965  21.383   0.678  1.00  7.91           C  
ATOM   4144  O   VAL D 230      10.809  20.547   1.015  1.00  8.29           O  
ATOM   4145  CB  VAL D 230       7.985  21.067   2.246  1.00  8.55           C  
ATOM   4146  CG1 VAL D 230       8.176  22.454   2.895  1.00  9.45           C  
ATOM   4147  CG2 VAL D 230       6.508  20.640   2.314  1.00  9.07           C  
ATOM   4148  N   ILE D 231      10.259  22.582   0.179  1.00  8.39           N  
ATOM   4149  CA  ILE D 231      11.631  23.079   0.020  1.00  9.15           C  
ATOM   4150  C   ILE D 231      11.922  24.147   1.068  1.00  9.79           C  
ATOM   4151  O   ILE D 231      11.115  25.059   1.280  1.00 10.37           O  
ATOM   4152  CB  ILE D 231      11.825  23.678  -1.389  1.00  9.19           C  
ATOM   4153  CG1 ILE D 231      11.503  22.636  -2.471  1.00 10.56           C  
ATOM   4154  CG2 ILE D 231      13.224  24.303  -1.547  1.00 11.62           C  
ATOM   4155  CD1 ILE D 231      12.438  21.455  -2.574  1.00 11.59           C  
ATOM   4156  N   ALA D 232      13.075  24.036   1.721  1.00  9.69           N  
ATOM   4157  CA  ALA D 232      13.537  25.083   2.631  1.00 10.54           C  
ATOM   4158  C   ALA D 232      13.874  26.345   1.832  1.00 11.35           C  
ATOM   4159  O   ALA D 232      14.609  26.272   0.843  1.00 12.19           O  
ATOM   4160  CB  ALA D 232      14.768  24.591   3.401  1.00 10.48           C  
ATOM   4161  N   THR D 233      13.341  27.494   2.249  1.00 11.13           N  
ATOM   4162  CA  THR D 233      13.679  28.768   1.586  1.00 12.26           C  
ATOM   4163  C   THR D 233      14.627  29.608   2.444  1.00 12.45           C  
ATOM   4164  O   THR D 233      15.009  30.716   2.066  1.00 14.57           O  
ATOM   4165  CB  THR D 233      12.423  29.593   1.239  1.00 12.08           C  
ATOM   4166  OG1 THR D 233      11.721  29.928   2.438  1.00 13.27           O  
ATOM   4167  CG2 THR D 233      11.501  28.805   0.320  1.00 12.96           C  
ATOM   4168  N   LYS D 234      14.998  29.065   3.601  1.00 12.69           N  
ATOM   4169  CA  LYS D 234      16.009  29.665   4.477  1.00 13.05           C  
ATOM   4170  C   LYS D 234      16.831  28.546   5.083  1.00 13.27           C  
ATOM   4171  O   LYS D 234      16.442  27.381   5.012  1.00 12.79           O  
ATOM   4172  CB  LYS D 234      15.351  30.485   5.594  1.00 12.98           C  
ATOM   4173  CG  LYS D 234      14.650  29.652   6.672  1.00 12.91           C  
ATOM   4174  CD  LYS D 234      14.074  30.524   7.770  1.00 14.08           C  
ATOM   4175  CE  LYS D 234      13.463  29.688   8.875  1.00 15.83           C  
ATOM   4176  NZ  LYS D 234      13.053  30.525  10.026  1.00 17.21           N  
ATOM   4177  N   GLN D 235      17.961  28.904   5.683  1.00 13.90           N  
ATOM   4178  CA  GLN D 235      18.740  27.944   6.448  1.00 14.55           C  
ATOM   4179  C   GLN D 235      18.019  27.597   7.740  1.00 13.88           C  
ATOM   4180  O   GLN D 235      17.376  28.447   8.355  1.00 14.30           O  
ATOM   4181  CB  GLN D 235      20.095  28.536   6.828  1.00 16.14           C  
ATOM   4182  CG  GLN D 235      21.038  28.745   5.695  1.00 19.86           C  
ATOM   4183  CD  GLN D 235      22.376  29.248   6.180  1.00 24.52           C  
ATOM   4184  OE1 GLN D 235      23.059  28.576   6.970  1.00 26.84           O  
ATOM   4185  NE2 GLN D 235      22.762  30.443   5.726  1.00 26.22           N  
ATOM   4186  N   PHE D 236      18.159  26.346   8.159  1.00 13.24           N  
ATOM   4187  CA  PHE D 236      17.786  25.917   9.512  1.00 12.87           C  
ATOM   4188  C   PHE D 236      19.045  25.338  10.142  1.00 13.06           C  
ATOM   4189  O   PHE D 236      19.834  24.690   9.467  1.00 13.59           O  
ATOM   4190  CB  PHE D 236      16.683  24.847   9.508  1.00 12.91           C  
ATOM   4191  CG  PHE D 236      15.341  25.341   9.043  1.00 12.50           C  
ATOM   4192  CD1 PHE D 236      14.343  25.647   9.964  1.00 12.37           C  
ATOM   4193  CD2 PHE D 236      15.060  25.466   7.683  1.00 12.21           C  
ATOM   4194  CE1 PHE D 236      13.084  26.083   9.546  1.00 12.48           C  
ATOM   4195  CE2 PHE D 236      13.798  25.908   7.249  1.00 12.63           C  
ATOM   4196  CZ  PHE D 236      12.813  26.217   8.183  1.00 12.68           C  
ATOM   4197  N   SER D 237      19.224  25.569  11.433  1.00 12.80           N  
ATOM   4198  CA  SER D 237      20.335  24.972  12.150  1.00 12.82           C  
ATOM   4199  C   SER D 237      19.940  23.676  12.845  1.00 12.12           C  
ATOM   4200  O   SER D 237      18.767  23.473  13.207  1.00 12.29           O  
ATOM   4201  CB  SER D 237      20.869  25.972  13.179  1.00 12.85           C  
ATOM   4202  OG  SER D 237      21.314  27.140  12.520  1.00 15.27           O  
ATOM   4203  N   ARG D 238      20.924  22.810  13.065  1.00 12.50           N  
ATOM   4204  CA  ARG D 238      20.700  21.571  13.781  1.00 12.55           C  
ATOM   4205  C   ARG D 238      19.944  21.864  15.079  1.00 12.61           C  
ATOM   4206  O   ARG D 238      20.332  22.750  15.851  1.00 12.93           O  
ATOM   4207  CB  ARG D 238      22.043  20.910  14.095  1.00 12.93           C  
ATOM   4208  CG  ARG D 238      21.940  19.594  14.836  1.00 15.76           C  
ATOM   4209  CD  ARG D 238      23.328  19.040  15.156  1.00 21.54           C  
ATOM   4210  NE  ARG D 238      24.172  18.909  13.967  1.00 26.28           N  
ATOM   4211  CZ  ARG D 238      24.369  17.771  13.302  1.00 28.97           C  
ATOM   4212  NH1 ARG D 238      23.784  16.645  13.697  1.00 30.11           N  
ATOM   4213  NH2 ARG D 238      25.155  17.755  12.234  1.00 30.35           N  
ATOM   4214  N   GLY D 239      18.854  21.136  15.304  1.00 11.96           N  
ATOM   4215  CA  GLY D 239      18.089  21.284  16.530  1.00 12.42           C  
ATOM   4216  C   GLY D 239      16.919  22.230  16.397  1.00 12.33           C  
ATOM   4217  O   GLY D 239      16.036  22.229  17.255  1.00 13.50           O  
ATOM   4218  N   ASP D 240      16.904  23.035  15.331  1.00 12.18           N  
ATOM   4219  CA  ASP D 240      15.826  24.005  15.118  1.00 12.37           C  
ATOM   4220  C   ASP D 240      14.489  23.327  14.848  1.00 11.47           C  
ATOM   4221  O   ASP D 240      14.419  22.322  14.134  1.00 11.88           O  
ATOM   4222  CB  ASP D 240      16.107  24.887  13.898  1.00 12.57           C  
ATOM   4223  CG  ASP D 240      17.109  25.991  14.160  1.00 14.94           C  
ATOM   4224  OD1 ASP D 240      17.616  26.115  15.296  1.00 15.68           O  
ATOM   4225  OD2 ASP D 240      17.363  26.740  13.196  1.00 16.21           O  
ATOM   4226  N   PHE D 241      13.424  23.904  15.396  1.00 11.61           N  
ATOM   4227  CA  PHE D 241      12.071  23.552  14.991  1.00 10.96           C  
ATOM   4228  C   PHE D 241      11.924  23.864  13.507  1.00 11.07           C  
ATOM   4229  O   PHE D 241      12.288  24.958  13.056  1.00 11.59           O  
ATOM   4230  CB  PHE D 241      11.071  24.379  15.802  1.00 11.30           C  
ATOM   4231  CG  PHE D 241       9.630  24.119  15.446  1.00 11.71           C  
ATOM   4232  CD1 PHE D 241       8.892  23.151  16.118  1.00 12.57           C  
ATOM   4233  CD2 PHE D 241       9.000  24.872  14.457  1.00 11.12           C  
ATOM   4234  CE1 PHE D 241       7.543  22.914  15.789  1.00 12.57           C  
ATOM   4235  CE2 PHE D 241       7.659  24.645  14.129  1.00 11.88           C  
ATOM   4236  CZ  PHE D 241       6.934  23.682  14.805  1.00 11.51           C  
ATOM   4237  N   VAL D 242      11.395  22.906  12.753  1.00 10.31           N  
ATOM   4238  CA  VAL D 242      11.138  23.135  11.336  1.00  9.61           C  
ATOM   4239  C   VAL D 242       9.638  23.365  11.119  1.00  9.67           C  
ATOM   4240  O   VAL D 242       9.232  24.431  10.639  1.00  9.86           O  
ATOM   4241  CB  VAL D 242      11.684  21.982  10.453  1.00  9.35           C  
ATOM   4242  CG1 VAL D 242      11.308  22.207   9.005  1.00  9.60           C  
ATOM   4243  CG2 VAL D 242      13.203  21.882  10.592  1.00 10.07           C  
ATOM   4244  N   VAL D 243       8.818  22.392  11.515  1.00  9.29           N  
ATOM   4245  CA  VAL D 243       7.376  22.490  11.279  1.00  9.34           C  
ATOM   4246  C   VAL D 243       6.646  21.444  12.114  1.00  9.14           C  
ATOM   4247  O   VAL D 243       7.208  20.387  12.423  1.00  9.36           O  
ATOM   4248  CB  VAL D 243       7.044  22.333   9.766  1.00  9.37           C  
ATOM   4249  CG1 VAL D 243       7.198  20.874   9.315  1.00 10.32           C  
ATOM   4250  CG2 VAL D 243       5.649  22.881   9.444  1.00 10.36           C  
ATOM   4251  N   GLU D 244       5.399  21.734  12.488  1.00  9.22           N  
ATOM   4252  CA  GLU D 244       4.574  20.723  13.129  1.00  9.31           C  
ATOM   4253  C   GLU D 244       3.993  19.762  12.090  1.00  8.76           C  
ATOM   4254  O   GLU D 244       3.683  20.168  10.970  1.00  8.98           O  
ATOM   4255  CB  GLU D 244       3.449  21.372  13.944  1.00  9.73           C  
ATOM   4256  CG  GLU D 244       2.612  20.354  14.726  1.00  9.45           C  
ATOM   4257  CD  GLU D 244       1.550  20.953  15.616  1.00 10.22           C  
ATOM   4258  OE1 GLU D 244       1.301  22.178  15.548  1.00 11.59           O  
ATOM   4259  OE2 GLU D 244       0.958  20.166  16.369  1.00 10.71           O  
ATOM   4260  N   TYR D 245       3.852  18.490  12.455  1.00  9.24           N  
ATOM   4261  CA  TYR D 245       2.994  17.611  11.669  1.00  8.46           C  
ATOM   4262  C   TYR D 245       1.574  17.881  12.178  1.00  9.27           C  
ATOM   4263  O   TYR D 245       1.146  17.315  13.196  1.00  9.32           O  
ATOM   4264  CB  TYR D 245       3.378  16.124  11.787  1.00  8.39           C  
ATOM   4265  CG  TYR D 245       2.676  15.332  10.707  1.00  6.91           C  
ATOM   4266  CD1 TYR D 245       3.277  15.159   9.457  1.00  6.57           C  
ATOM   4267  CD2 TYR D 245       1.384  14.827  10.894  1.00  7.72           C  
ATOM   4268  CE1 TYR D 245       2.636  14.463   8.453  1.00  6.82           C  
ATOM   4269  CE2 TYR D 245       0.721  14.140   9.876  1.00  7.30           C  
ATOM   4270  CZ  TYR D 245       1.369  13.952   8.649  1.00  6.52           C  
ATOM   4271  OH  TYR D 245       0.737  13.291   7.625  1.00  7.85           O  
ATOM   4272  N   HIS D 246       0.866  18.760  11.470  1.00  9.11           N  
ATOM   4273  CA  HIS D 246      -0.405  19.324  11.947  1.00  9.51           C  
ATOM   4274  C   HIS D 246      -1.587  18.735  11.186  1.00  9.47           C  
ATOM   4275  O   HIS D 246      -1.575  18.690   9.954  1.00  9.69           O  
ATOM   4276  CB  HIS D 246      -0.389  20.844  11.772  1.00  9.49           C  
ATOM   4277  CG  HIS D 246      -1.483  21.547  12.511  1.00 10.72           C  
ATOM   4278  ND1 HIS D 246      -2.745  21.726  11.985  1.00 11.76           N  
ATOM   4279  CD2 HIS D 246      -1.502  22.104  13.747  1.00 12.49           C  
ATOM   4280  CE1 HIS D 246      -3.494  22.370  12.866  1.00 11.90           C  
ATOM   4281  NE2 HIS D 246      -2.766  22.602  13.945  1.00 12.95           N  
ATOM   4282  N   GLY D 247      -2.602  18.309  11.937  1.00  9.59           N  
ATOM   4283  CA  GLY D 247      -3.824  17.725  11.383  1.00 10.71           C  
ATOM   4284  C   GLY D 247      -4.788  17.439  12.526  1.00 11.42           C  
ATOM   4285  O   GLY D 247      -4.740  18.103  13.580  1.00 13.20           O  
ATOM   4286  N   ASP D 248      -5.667  16.462  12.326  1.00 11.93           N  
ATOM   4287  CA  ASP D 248      -6.673  16.122  13.343  1.00 12.82           C  
ATOM   4288  C   ASP D 248      -6.067  15.133  14.331  1.00 12.62           C  
ATOM   4289  O   ASP D 248      -5.730  14.015  13.944  1.00 12.53           O  
ATOM   4290  CB  ASP D 248      -7.879  15.450  12.704  1.00 14.21           C  
ATOM   4291  CG  ASP D 248      -8.633  16.338  11.762  1.00 18.12           C  
ATOM   4292  OD1 ASP D 248      -8.530  17.575  11.869  1.00 21.26           O  
ATOM   4293  OD2 ASP D 248      -9.358  15.775  10.911  1.00 23.14           O  
ATOM   4294  N   LEU D 249      -5.925  15.529  15.589  1.00 12.35           N  
ATOM   4295  CA  LEU D 249      -5.457  14.625  16.623  1.00 12.58           C  
ATOM   4296  C   LEU D 249      -6.605  13.737  17.084  1.00 12.53           C  
ATOM   4297  O   LEU D 249      -7.614  14.235  17.604  1.00 12.55           O  
ATOM   4298  CB  LEU D 249      -4.853  15.400  17.797  1.00 13.19           C  
ATOM   4299  CG  LEU D 249      -4.334  14.546  18.959  1.00 12.37           C  
ATOM   4300  CD1 LEU D 249      -3.127  13.709  18.532  1.00 12.84           C  
ATOM   4301  CD2 LEU D 249      -3.991  15.405  20.165  1.00 13.89           C  
ATOM   4302  N   ILE D 250      -6.438  12.428  16.899  1.00 12.16           N  
ATOM   4303  CA  ILE D 250      -7.477  11.445  17.185  1.00 12.17           C  
ATOM   4304  C   ILE D 250      -6.905  10.261  17.969  1.00 12.44           C  
ATOM   4305  O   ILE D 250      -5.685  10.047  17.994  1.00 11.83           O  
ATOM   4306  CB  ILE D 250      -8.215  10.978  15.891  1.00 12.16           C  
ATOM   4307  CG1 ILE D 250      -7.265  10.214  14.946  1.00 12.47           C  
ATOM   4308  CG2 ILE D 250      -8.915  12.173  15.209  1.00 13.21           C  
ATOM   4309  CD1 ILE D 250      -7.886   9.797  13.635  1.00 12.84           C  
ATOM   4310  N   GLU D 251      -7.794   9.532  18.639  1.00 12.39           N  
ATOM   4311  CA  GLU D 251      -7.400   8.338  19.380  1.00 13.14           C  
ATOM   4312  C   GLU D 251      -7.597   7.094  18.520  1.00 13.10           C  
ATOM   4313  O   GLU D 251      -8.024   7.182  17.372  1.00 12.86           O  
ATOM   4314  CB  GLU D 251      -8.091   8.232  20.759  1.00 13.39           C  
ATOM   4315  CG  GLU D 251      -9.615   8.316  20.770  1.00 17.10           C  
ATOM   4316  CD  GLU D 251     -10.308   7.145  20.096  1.00 20.71           C  
ATOM   4317  OE1 GLU D 251     -10.185   5.986  20.589  1.00 23.23           O  
ATOM   4318  OE2 GLU D 251     -10.985   7.391  19.078  1.00 21.73           O  
ATOM   4319  N   ILE D 252      -7.281   5.932  19.079  1.00 13.38           N  
ATOM   4320  CA  ILE D 252      -7.137   4.740  18.264  1.00 14.07           C  
ATOM   4321  C   ILE D 252      -8.431   4.246  17.613  1.00 14.26           C  
ATOM   4322  O   ILE D 252      -8.410   3.774  16.481  1.00 14.05           O  
ATOM   4323  CB  ILE D 252      -6.422   3.596  19.033  1.00 14.01           C  
ATOM   4324  CG1 ILE D 252      -5.971   2.503  18.057  1.00 14.95           C  
ATOM   4325  CG2 ILE D 252      -7.312   3.045  20.154  1.00 15.69           C  
ATOM   4326  CD1 ILE D 252      -5.205   1.371  18.687  1.00 14.68           C  
ATOM   4327  N   THR D 253      -9.552   4.334  18.320  1.00 14.84           N  
ATOM   4328  CA  THR D 253     -10.776   3.778  17.762  1.00 15.99           C  
ATOM   4329  C   THR D 253     -11.190   4.571  16.522  1.00 15.59           C  
ATOM   4330  O   THR D 253     -11.530   3.984  15.496  1.00 15.90           O  
ATOM   4331  CB  THR D 253     -11.923   3.681  18.788  1.00 16.72           C  
ATOM   4332  OG1 THR D 253     -12.415   4.980  19.088  1.00 19.96           O  
ATOM   4333  CG2 THR D 253     -11.459   3.014  20.072  1.00 16.43           C  
ATOM   4334  N   ASP D 254     -11.117   5.899  16.610  1.00 15.45           N  
ATOM   4335  CA  ASP D 254     -11.434   6.728  15.457  1.00 15.84           C  
ATOM   4336  C   ASP D 254     -10.419   6.542  14.336  1.00 14.83           C  
ATOM   4337  O   ASP D 254     -10.790   6.495  13.168  1.00 14.58           O  
ATOM   4338  CB  ASP D 254     -11.534   8.200  15.828  1.00 16.99           C  
ATOM   4339  CG  ASP D 254     -12.254   9.009  14.768  1.00 20.78           C  
ATOM   4340  OD1 ASP D 254     -13.240   8.490  14.190  1.00 24.27           O  
ATOM   4341  OD2 ASP D 254     -11.838  10.163  14.513  1.00 24.75           O  
ATOM   4342  N   ALA D 255      -9.144   6.405  14.691  1.00 14.04           N  
ATOM   4343  CA  ALA D 255      -8.121   6.172  13.655  1.00 14.03           C  
ATOM   4344  C   ALA D 255      -8.412   4.908  12.845  1.00 14.20           C  
ATOM   4345  O   ALA D 255      -8.338   4.916  11.615  1.00 14.48           O  
ATOM   4346  CB  ALA D 255      -6.740   6.121  14.272  1.00 13.60           C  
ATOM   4347  N   LYS D 256      -8.766   3.823  13.532  1.00 14.35           N  
ATOM   4348  CA  LYS D 256      -9.081   2.570  12.866  1.00 15.39           C  
ATOM   4349  C   LYS D 256     -10.301   2.703  11.976  1.00 15.71           C  
ATOM   4350  O   LYS D 256     -10.328   2.169  10.863  1.00 15.46           O  
ATOM   4351  CB  LYS D 256      -9.284   1.467  13.905  1.00 15.80           C  
ATOM   4352  CG  LYS D 256      -7.991   1.159  14.635  1.00 18.02           C  
ATOM   4353  CD  LYS D 256      -8.181   0.324  15.883  1.00 21.09           C  
ATOM   4354  CE  LYS D 256      -7.959  -1.124  15.608  1.00 21.60           C  
ATOM   4355  NZ  LYS D 256      -7.819  -1.847  16.893  1.00 19.76           N  
ATOM   4356  N   LYS D 257     -11.301   3.426  12.473  1.00 16.34           N  
ATOM   4357  CA  LYS D 257     -12.499   3.712  11.692  1.00 17.57           C  
ATOM   4358  C   LYS D 257     -12.153   4.457  10.409  1.00 17.16           C  
ATOM   4359  O   LYS D 257     -12.574   4.071   9.314  1.00 17.25           O  
ATOM   4360  CB  LYS D 257     -13.496   4.522  12.522  1.00 18.30           C  
ATOM   4361  CG  LYS D 257     -14.332   3.701  13.476  1.00 21.94           C  
ATOM   4362  CD  LYS D 257     -15.372   2.866  12.737  1.00 26.13           C  
ATOM   4363  CE  LYS D 257     -14.831   1.485  12.391  1.00 28.60           C  
ATOM   4364  NZ  LYS D 257     -15.359   1.007  11.094  1.00 30.03           N  
ATOM   4365  N   ARG D 258     -11.371   5.522  10.558  1.00 17.08           N  
ATOM   4366  CA  ARG D 258     -10.961   6.341   9.414  1.00 16.80           C  
ATOM   4367  C   ARG D 258     -10.116   5.567   8.410  1.00 16.97           C  
ATOM   4368  O   ARG D 258     -10.317   5.690   7.207  1.00 16.94           O  
ATOM   4369  CB  ARG D 258     -10.218   7.578   9.898  1.00 17.03           C  
ATOM   4370  CG  ARG D 258     -11.124   8.562  10.618  1.00 16.29           C  
ATOM   4371  CD  ARG D 258     -10.411   9.866  10.869  1.00 17.11           C  
ATOM   4372  NE  ARG D 258     -11.154  10.791  11.729  1.00 16.97           N  
ATOM   4373  CZ  ARG D 258     -10.837  12.074  11.902  1.00 17.84           C  
ATOM   4374  NH1 ARG D 258      -9.805  12.603  11.257  1.00 17.98           N  
ATOM   4375  NH2 ARG D 258     -11.562  12.847  12.711  1.00 18.97           N  
ATOM   4376  N   GLU D 259      -9.184   4.754   8.902  1.00 16.59           N  
ATOM   4377  CA  GLU D 259      -8.380   3.899   8.026  1.00 17.20           C  
ATOM   4378  C   GLU D 259      -9.235   3.046   7.111  1.00 17.17           C  
ATOM   4379  O   GLU D 259      -8.970   2.927   5.916  1.00 16.96           O  
ATOM   4380  CB  GLU D 259      -7.484   2.963   8.839  1.00 18.20           C  
ATOM   4381  CG  GLU D 259      -6.314   3.659   9.493  1.00 19.55           C  
ATOM   4382  CD  GLU D 259      -5.068   2.807   9.572  1.00 22.32           C  
ATOM   4383  OE1 GLU D 259      -5.172   1.555   9.683  1.00 24.27           O  
ATOM   4384  OE2 GLU D 259      -3.965   3.409   9.496  1.00 22.89           O  
ATOM   4385  N   ALA D 260     -10.254   2.418   7.695  1.00 16.81           N  
ATOM   4386  CA  ALA D 260     -11.099   1.503   6.949  1.00 17.07           C  
ATOM   4387  C   ALA D 260     -11.930   2.255   5.911  1.00 16.85           C  
ATOM   4388  O   ALA D 260     -12.197   1.725   4.836  1.00 17.41           O  
ATOM   4389  CB  ALA D 260     -11.979   0.718   7.885  1.00 17.53           C  
ATOM   4390  N   LEU D 261     -12.316   3.489   6.223  1.00 16.43           N  
ATOM   4391  CA  LEU D 261     -12.969   4.350   5.229  1.00 16.72           C  
ATOM   4392  C   LEU D 261     -12.020   4.802   4.106  1.00 16.20           C  
ATOM   4393  O   LEU D 261     -12.349   4.691   2.918  1.00 15.94           O  
ATOM   4394  CB  LEU D 261     -13.640   5.551   5.895  1.00 17.64           C  
ATOM   4395  CG  LEU D 261     -14.802   5.217   6.837  1.00 19.58           C  
ATOM   4396  CD1 LEU D 261     -15.239   6.450   7.599  1.00 20.76           C  
ATOM   4397  CD2 LEU D 261     -15.974   4.614   6.068  1.00 20.93           C  
ATOM   4398  N   TYR D 262     -10.835   5.287   4.483  1.00 15.72           N  
ATOM   4399  CA  TYR D 262      -9.865   5.758   3.495  1.00 15.48           C  
ATOM   4400  C   TYR D 262      -9.453   4.639   2.546  1.00 16.10           C  
ATOM   4401  O   TYR D 262      -9.240   4.868   1.353  1.00 16.39           O  
ATOM   4402  CB  TYR D 262      -8.613   6.310   4.179  1.00 14.24           C  
ATOM   4403  CG  TYR D 262      -8.832   7.527   5.053  1.00 13.65           C  
ATOM   4404  CD1 TYR D 262      -9.842   8.452   4.781  1.00 13.75           C  
ATOM   4405  CD2 TYR D 262      -8.009   7.767   6.142  1.00 13.15           C  
ATOM   4406  CE1 TYR D 262     -10.039   9.569   5.595  1.00 12.98           C  
ATOM   4407  CE2 TYR D 262      -8.195   8.877   6.950  1.00 11.77           C  
ATOM   4408  CZ  TYR D 262      -9.198   9.777   6.668  1.00 13.08           C  
ATOM   4409  OH  TYR D 262      -9.361  10.870   7.491  1.00 14.19           O  
ATOM   4410  N   ALA D 263      -9.334   3.425   3.085  1.00 16.93           N  
ATOM   4411  CA  ALA D 263      -8.915   2.268   2.299  1.00 18.06           C  
ATOM   4412  C   ALA D 263      -9.847   1.970   1.122  1.00 18.93           C  
ATOM   4413  O   ALA D 263      -9.444   1.307   0.157  1.00 19.63           O  
ATOM   4414  CB  ALA D 263      -8.767   1.043   3.190  1.00 18.18           C  
ATOM   4415  N   GLN D 264     -11.078   2.468   1.204  1.00 19.42           N  
ATOM   4416  CA  GLN D 264     -12.060   2.259   0.139  1.00 20.92           C  
ATOM   4417  C   GLN D 264     -11.856   3.194  -1.057  1.00 20.97           C  
ATOM   4418  O   GLN D 264     -12.433   2.969  -2.122  1.00 21.28           O  
ATOM   4419  CB  GLN D 264     -13.481   2.401   0.688  1.00 20.82           C  
ATOM   4420  CG  GLN D 264     -13.879   1.284   1.655  1.00 21.66           C  
ATOM   4421  CD  GLN D 264     -15.189   1.566   2.387  1.00 22.67           C  
ATOM   4422  OE1 GLN D 264     -16.227   1.794   1.760  1.00 26.11           O  
ATOM   4423  NE2 GLN D 264     -15.146   1.539   3.719  1.00 23.18           N  
ATOM   4424  N   ASP D 265     -11.030   4.225  -0.881  1.00 21.04           N  
ATOM   4425  CA  ASP D 265     -10.789   5.247  -1.910  1.00 21.08           C  
ATOM   4426  C   ASP D 265      -9.279   5.460  -2.124  1.00 21.37           C  
ATOM   4427  O   ASP D 265      -8.622   6.072  -1.282  1.00 20.64           O  
ATOM   4428  CB  ASP D 265     -11.446   6.563  -1.484  1.00 21.20           C  
ATOM   4429  CG  ASP D 265     -11.276   7.683  -2.505  1.00 21.66           C  
ATOM   4430  OD1 ASP D 265     -10.588   7.492  -3.530  1.00 21.55           O  
ATOM   4431  OD2 ASP D 265     -11.850   8.765  -2.263  1.00 24.95           O  
ATOM   4432  N   PRO D 266      -8.739   4.998  -3.271  1.00 21.91           N  
ATOM   4433  CA  PRO D 266      -7.301   5.095  -3.590  1.00 22.19           C  
ATOM   4434  C   PRO D 266      -6.796   6.531  -3.725  1.00 22.32           C  
ATOM   4435  O   PRO D 266      -5.591   6.777  -3.596  1.00 22.48           O  
ATOM   4436  CB  PRO D 266      -7.189   4.372  -4.939  1.00 22.66           C  
ATOM   4437  CG  PRO D 266      -8.551   4.454  -5.529  1.00 22.77           C  
ATOM   4438  CD  PRO D 266      -9.497   4.367  -4.371  1.00 22.42           C  
ATOM   4439  N   SER D 267      -7.701   7.478  -3.949  1.00 22.06           N  
ATOM   4440  CA  SER D 267      -7.298   8.880  -4.107  1.00 21.84           C  
ATOM   4441  C   SER D 267      -6.943   9.559  -2.782  1.00 20.79           C  
ATOM   4442  O   SER D 267      -6.351  10.644  -2.764  1.00 21.28           O  
ATOM   4443  CB  SER D 267      -8.374   9.672  -4.854  1.00 22.27           C  
ATOM   4444  OG  SER D 267      -9.458  10.000  -4.003  1.00 23.39           O  
ATOM   4445  N   THR D 268      -7.286   8.907  -1.674  1.00 18.72           N  
ATOM   4446  CA  THR D 268      -7.119   9.496  -0.362  1.00 17.06           C  
ATOM   4447  C   THR D 268      -5.646   9.839  -0.066  1.00 15.75           C  
ATOM   4448  O   THR D 268      -5.326  10.940   0.394  1.00 16.10           O  
ATOM   4449  CB  THR D 268      -7.655   8.551   0.732  1.00 17.03           C  
ATOM   4450  OG1 THR D 268      -8.983   8.116   0.384  1.00 19.93           O  
ATOM   4451  CG2 THR D 268      -7.706   9.281   2.016  1.00 16.49           C  
ATOM   4452  N   GLY D 269      -4.762   8.877  -0.291  1.00 13.90           N  
ATOM   4453  CA  GLY D 269      -3.364   9.048   0.097  1.00 12.39           C  
ATOM   4454  C   GLY D 269      -3.187   8.796   1.581  1.00 11.03           C  
ATOM   4455  O   GLY D 269      -4.174   8.612   2.321  1.00 10.60           O  
ATOM   4456  N   CYS D 270      -1.924   8.795   2.011  1.00  9.38           N  
ATOM   4457  CA  CYS D 270      -1.530   8.312   3.335  1.00  9.22           C  
ATOM   4458  C   CYS D 270      -0.915   9.437   4.156  1.00  8.81           C  
ATOM   4459  O   CYS D 270       0.245   9.809   3.958  1.00  8.68           O  
ATOM   4460  CB  CYS D 270      -0.576   7.137   3.194  1.00  9.50           C  
ATOM   4461  SG  CYS D 270      -1.346   5.713   2.394  1.00 10.60           S  
ATOM   4462  N   TYR D 271      -1.724   9.973   5.069  1.00  8.71           N  
ATOM   4463  CA  TYR D 271      -1.369  11.163   5.866  1.00  9.01           C  
ATOM   4464  C   TYR D 271      -1.539  10.941   7.365  1.00  9.30           C  
ATOM   4465  O   TYR D 271      -1.468  11.891   8.148  1.00 10.26           O  
ATOM   4466  CB  TYR D 271      -2.232  12.370   5.428  1.00  8.94           C  
ATOM   4467  CG  TYR D 271      -2.036  12.725   3.984  1.00  8.41           C  
ATOM   4468  CD1 TYR D 271      -1.060  13.646   3.607  1.00  9.32           C  
ATOM   4469  CD2 TYR D 271      -2.790  12.107   2.984  1.00  8.17           C  
ATOM   4470  CE1 TYR D 271      -0.837  13.942   2.279  1.00  8.60           C  
ATOM   4471  CE2 TYR D 271      -2.577  12.413   1.626  1.00  9.40           C  
ATOM   4472  CZ  TYR D 271      -1.594  13.327   1.292  1.00  9.70           C  
ATOM   4473  OH  TYR D 271      -1.366  13.600  -0.041  1.00 10.50           O  
ATOM   4474  N   MET D 272      -1.746   9.689   7.766  1.00  9.36           N  
ATOM   4475  CA  MET D 272      -2.001   9.368   9.173  1.00  9.24           C  
ATOM   4476  C   MET D 272      -0.696   9.063   9.874  1.00  9.05           C  
ATOM   4477  O   MET D 272       0.061   8.188   9.420  1.00  9.54           O  
ATOM   4478  CB  MET D 272      -2.951   8.175   9.270  1.00  9.25           C  
ATOM   4479  CG  MET D 272      -4.289   8.441   8.605  1.00  9.56           C  
ATOM   4480  SD  MET D 272      -5.484   7.111   8.825  1.00 11.48           S  
ATOM   4481  CE  MET D 272      -6.088   7.506  10.478  1.00 11.40           C  
ATOM   4482  N   TYR D 273      -0.434   9.768  10.979  1.00  8.92           N  
ATOM   4483  CA  TYR D 273       0.830   9.665  11.675  1.00  7.84           C  
ATOM   4484  C   TYR D 273       0.571   9.193  13.106  1.00  8.22           C  
ATOM   4485  O   TYR D 273       0.096   9.962  13.960  1.00  8.72           O  
ATOM   4486  CB  TYR D 273       1.544  11.028  11.676  1.00  7.93           C  
ATOM   4487  CG  TYR D 273       3.059  10.996  11.761  1.00  7.76           C  
ATOM   4488  CD1 TYR D 273       3.737  10.022  12.500  1.00  8.94           C  
ATOM   4489  CD2 TYR D 273       3.821  11.942  11.080  1.00  7.96           C  
ATOM   4490  CE1 TYR D 273       5.138  10.011  12.559  1.00  7.05           C  
ATOM   4491  CE2 TYR D 273       5.202  11.937  11.139  1.00  7.92           C  
ATOM   4492  CZ  TYR D 273       5.863  10.972  11.866  1.00  7.96           C  
ATOM   4493  OH  TYR D 273       7.251  10.984  11.877  1.00  9.63           O  
ATOM   4494  N   TYR D 274       0.915   7.929  13.347  1.00  8.09           N  
ATOM   4495  CA  TYR D 274       0.660   7.260  14.623  1.00  8.81           C  
ATOM   4496  C   TYR D 274       1.800   7.436  15.601  1.00  9.23           C  
ATOM   4497  O   TYR D 274       2.963   7.472  15.219  1.00 10.11           O  
ATOM   4498  CB  TYR D 274       0.451   5.769  14.380  1.00  9.26           C  
ATOM   4499  CG  TYR D 274      -0.827   5.485  13.662  1.00  9.76           C  
ATOM   4500  CD1 TYR D 274      -2.001   5.223  14.382  1.00 10.02           C  
ATOM   4501  CD2 TYR D 274      -0.879   5.462  12.264  1.00  9.89           C  
ATOM   4502  CE1 TYR D 274      -3.182   4.949  13.736  1.00 11.56           C  
ATOM   4503  CE2 TYR D 274      -2.069   5.192  11.595  1.00 11.23           C  
ATOM   4504  CZ  TYR D 274      -3.217   4.939  12.334  1.00 11.46           C  
ATOM   4505  OH  TYR D 274      -4.372   4.672  11.660  1.00 14.21           O  
ATOM   4506  N   PHE D 275       1.469   7.512  16.885  1.00  9.87           N  
ATOM   4507  CA  PHE D 275       2.494   7.613  17.921  1.00 10.76           C  
ATOM   4508  C   PHE D 275       1.926   7.146  19.249  1.00 11.86           C  
ATOM   4509  O   PHE D 275       0.709   7.065  19.403  1.00 12.04           O  
ATOM   4510  CB  PHE D 275       3.033   9.046  18.036  1.00 11.06           C  
ATOM   4511  CG  PHE D 275       2.004  10.077  18.467  1.00 10.42           C  
ATOM   4512  CD1 PHE D 275       1.972  10.515  19.792  1.00 11.19           C  
ATOM   4513  CD2 PHE D 275       1.105  10.637  17.554  1.00  9.83           C  
ATOM   4514  CE1 PHE D 275       1.056  11.490  20.206  1.00 11.51           C  
ATOM   4515  CE2 PHE D 275       0.175  11.609  17.962  1.00  9.54           C  
ATOM   4516  CZ  PHE D 275       0.156  12.031  19.297  1.00 11.25           C  
ATOM   4517  N   GLN D 276       2.808   6.818  20.189  1.00 12.81           N  
ATOM   4518  CA  GLN D 276       2.355   6.457  21.531  1.00 14.51           C  
ATOM   4519  C   GLN D 276       2.592   7.628  22.491  1.00 14.57           C  
ATOM   4520  O   GLN D 276       3.608   8.342  22.419  1.00 14.69           O  
ATOM   4521  CB  GLN D 276       3.015   5.168  22.051  1.00 15.67           C  
ATOM   4522  CG  GLN D 276       3.090   3.937  21.087  1.00 17.39           C  
ATOM   4523  CD  GLN D 276       1.797   3.557  20.325  1.00 19.37           C  
ATOM   4524  OE1 GLN D 276       0.789   3.176  20.934  1.00 24.54           O  
ATOM   4525  NE2 GLN D 276       1.818   3.678  19.031  1.00 22.09           N  
ATOM   4526  N   TYR D 277       1.617   7.843  23.371  1.00 14.69           N  
ATOM   4527  CA  TYR D 277       1.680   8.941  24.329  1.00 15.17           C  
ATOM   4528  C   TYR D 277       0.932   8.500  25.570  1.00 15.16           C  
ATOM   4529  O   TYR D 277      -0.233   8.109  25.493  1.00 13.96           O  
ATOM   4530  CB  TYR D 277       1.063  10.214  23.748  1.00 15.74           C  
ATOM   4531  CG  TYR D 277       0.955  11.378  24.715  1.00 16.97           C  
ATOM   4532  CD1 TYR D 277       2.090  12.054  25.173  1.00 16.43           C  
ATOM   4533  CD2 TYR D 277      -0.295  11.829  25.136  1.00 16.53           C  
ATOM   4534  CE1 TYR D 277       1.980  13.142  26.058  1.00 18.00           C  
ATOM   4535  CE2 TYR D 277      -0.417  12.907  26.006  1.00 17.85           C  
ATOM   4536  CZ  TYR D 277       0.722  13.558  26.462  1.00 17.83           C  
ATOM   4537  OH  TYR D 277       0.585  14.634  27.326  1.00 20.21           O  
ATOM   4538  N   LEU D 278       1.635   8.528  26.701  1.00 15.94           N  
ATOM   4539  CA  LEU D 278       1.072   8.098  27.990  1.00 17.18           C  
ATOM   4540  C   LEU D 278       0.337   6.742  27.907  1.00 16.71           C  
ATOM   4541  O   LEU D 278      -0.807   6.598  28.337  1.00 17.02           O  
ATOM   4542  CB  LEU D 278       0.222   9.207  28.632  1.00 17.84           C  
ATOM   4543  CG  LEU D 278       0.846  10.597  28.834  1.00 19.88           C  
ATOM   4544  CD1 LEU D 278      -0.201  11.528  29.416  1.00 22.42           C  
ATOM   4545  CD2 LEU D 278       2.077  10.564  29.731  1.00 21.96           C  
ATOM   4546  N   SER D 279       1.017   5.763  27.304  1.00 16.39           N  
ATOM   4547  CA  SER D 279       0.527   4.380  27.196  1.00 15.98           C  
ATOM   4548  C   SER D 279      -0.695   4.174  26.315  1.00 15.29           C  
ATOM   4549  O   SER D 279      -1.354   3.137  26.412  1.00 15.49           O  
ATOM   4550  CB  SER D 279       0.294   3.742  28.579  1.00 16.89           C  
ATOM   4551  OG  SER D 279       1.471   3.811  29.343  1.00 19.94           O  
ATOM   4552  N   LYS D 280      -0.983   5.137  25.435  1.00 14.13           N  
ATOM   4553  CA  LYS D 280      -2.095   5.002  24.499  1.00 14.30           C  
ATOM   4554  C   LYS D 280      -1.627   5.384  23.106  1.00 12.85           C  
ATOM   4555  O   LYS D 280      -0.657   6.125  22.957  1.00 12.82           O  
ATOM   4556  CB  LYS D 280      -3.255   5.920  24.870  1.00 14.81           C  
ATOM   4557  CG  LYS D 280      -4.088   5.499  26.067  1.00 16.08           C  
ATOM   4558  CD  LYS D 280      -5.261   6.480  26.267  1.00 17.68           C  
ATOM   4559  CE  LYS D 280      -6.338   6.355  25.183  1.00 21.47           C  
ATOM   4560  NZ  LYS D 280      -7.042   5.030  25.204  1.00 23.37           N  
ATOM   4561  N   THR D 281      -2.338   4.888  22.097  1.00 11.82           N  
ATOM   4562  CA  THR D 281      -2.002   5.209  20.709  1.00 11.31           C  
ATOM   4563  C   THR D 281      -2.810   6.407  20.244  1.00 11.14           C  
ATOM   4564  O   THR D 281      -4.029   6.435  20.372  1.00 12.15           O  
ATOM   4565  CB  THR D 281      -2.307   4.029  19.788  1.00 11.10           C  
ATOM   4566  OG1 THR D 281      -1.575   2.885  20.221  1.00 11.39           O  
ATOM   4567  CG2 THR D 281      -1.926   4.343  18.349  1.00 12.93           C  
ATOM   4568  N   TYR D 282      -2.114   7.396  19.689  1.00 10.50           N  
ATOM   4569  CA  TYR D 282      -2.774   8.521  19.048  1.00 11.09           C  
ATOM   4570  C   TYR D 282      -2.369   8.619  17.590  1.00 10.32           C  
ATOM   4571  O   TYR D 282      -1.453   7.928  17.127  1.00 10.16           O  
ATOM   4572  CB  TYR D 282      -2.462   9.830  19.791  1.00 12.77           C  
ATOM   4573  CG  TYR D 282      -3.037   9.831  21.187  1.00 13.49           C  
ATOM   4574  CD1 TYR D 282      -4.365  10.186  21.421  1.00 16.60           C  
ATOM   4575  CD2 TYR D 282      -2.262   9.437  22.265  1.00 13.73           C  
ATOM   4576  CE1 TYR D 282      -4.893  10.156  22.710  1.00 18.18           C  
ATOM   4577  CE2 TYR D 282      -2.767   9.417  23.550  1.00 16.11           C  
ATOM   4578  CZ  TYR D 282      -4.078   9.768  23.767  1.00 16.84           C  
ATOM   4579  OH  TYR D 282      -4.562   9.729  25.060  1.00 19.52           O  
ATOM   4580  N   CYS D 283      -3.053   9.497  16.872  1.00  9.81           N  
ATOM   4581  CA  CYS D 283      -2.776   9.656  15.466  1.00  9.48           C  
ATOM   4582  C   CYS D 283      -3.035  11.091  15.070  1.00  9.07           C  
ATOM   4583  O   CYS D 283      -4.081  11.650  15.423  1.00  9.83           O  
ATOM   4584  CB  CYS D 283      -3.675   8.730  14.662  1.00  9.76           C  
ATOM   4585  SG  CYS D 283      -3.425   8.861  12.859  1.00 10.73           S  
ATOM   4586  N   VAL D 284      -2.083  11.702  14.369  1.00  8.61           N  
ATOM   4587  CA  VAL D 284      -2.362  12.975  13.729  1.00  8.81           C  
ATOM   4588  C   VAL D 284      -2.816  12.641  12.319  1.00  8.92           C  
ATOM   4589  O   VAL D 284      -2.018  12.229  11.464  1.00  9.53           O  
ATOM   4590  CB  VAL D 284      -1.152  13.939  13.689  1.00  8.77           C  
ATOM   4591  CG1 VAL D 284      -1.571  15.259  13.004  1.00  9.74           C  
ATOM   4592  CG2 VAL D 284      -0.617  14.219  15.094  1.00 10.47           C  
ATOM   4593  N   ASP D 285      -4.116  12.758  12.092  1.00  9.73           N  
ATOM   4594  CA  ASP D 285      -4.673  12.427  10.794  1.00  9.44           C  
ATOM   4595  C   ASP D 285      -4.706  13.690   9.932  1.00 10.12           C  
ATOM   4596  O   ASP D 285      -5.593  14.528  10.096  1.00 10.28           O  
ATOM   4597  CB  ASP D 285      -6.065  11.810  10.944  1.00 10.00           C  
ATOM   4598  CG  ASP D 285      -6.709  11.509   9.609  1.00 11.06           C  
ATOM   4599  OD1 ASP D 285      -6.016  11.615   8.569  1.00 11.64           O  
ATOM   4600  OD2 ASP D 285      -7.909  11.178   9.585  1.00 13.04           O  
ATOM   4601  N   ALA D 286      -3.713  13.834   9.044  1.00  9.84           N  
ATOM   4602  CA  ALA D 286      -3.653  15.001   8.156  1.00  9.57           C  
ATOM   4603  C   ALA D 286      -4.200  14.704   6.757  1.00  9.56           C  
ATOM   4604  O   ALA D 286      -3.780  15.311   5.770  1.00  9.60           O  
ATOM   4605  CB  ALA D 286      -2.229  15.600   8.099  1.00  9.13           C  
ATOM   4606  N   THR D 287      -5.181  13.808   6.668  1.00 10.05           N  
ATOM   4607  CA  THR D 287      -5.724  13.436   5.358  1.00 10.55           C  
ATOM   4608  C   THR D 287      -6.421  14.598   4.648  1.00 10.73           C  
ATOM   4609  O   THR D 287      -6.257  14.778   3.448  1.00 11.21           O  
ATOM   4610  CB  THR D 287      -6.662  12.213   5.475  1.00 10.34           C  
ATOM   4611  OG1 THR D 287      -5.919  11.142   6.055  1.00 11.42           O  
ATOM   4612  CG2 THR D 287      -7.204  11.793   4.113  1.00 11.16           C  
ATOM   4613  N   ARG D 288      -7.207  15.366   5.396  1.00 11.24           N  
ATOM   4614  CA  ARG D 288      -7.893  16.531   4.845  1.00 12.16           C  
ATOM   4615  C   ARG D 288      -6.897  17.554   4.316  1.00 11.68           C  
ATOM   4616  O   ARG D 288      -5.941  17.932   5.002  1.00 11.09           O  
ATOM   4617  CB  ARG D 288      -8.791  17.183   5.896  1.00 13.23           C  
ATOM   4618  CG  ARG D 288      -9.631  18.336   5.353  1.00 15.92           C  
ATOM   4619  CD  ARG D 288     -10.629  18.841   6.377  1.00 19.63           C  
ATOM   4620  NE  ARG D 288      -9.981  19.436   7.546  1.00 22.46           N  
ATOM   4621  CZ  ARG D 288      -9.574  20.701   7.622  1.00 23.62           C  
ATOM   4622  NH1 ARG D 288      -9.738  21.521   6.591  1.00 24.80           N  
ATOM   4623  NH2 ARG D 288      -9.001  21.147   8.731  1.00 25.10           N  
ATOM   4624  N   GLU D 289      -7.174  18.043   3.109  1.00 11.40           N  
ATOM   4625  CA  GLU D 289      -6.338  19.063   2.506  1.00 11.34           C  
ATOM   4626  C   GLU D 289      -6.463  20.352   3.285  1.00 11.46           C  
ATOM   4627  O   GLU D 289      -7.578  20.801   3.588  1.00 13.05           O  
ATOM   4628  CB  GLU D 289      -6.729  19.283   1.052  1.00 11.45           C  
ATOM   4629  CG  GLU D 289      -6.250  18.178   0.159  1.00 11.53           C  
ATOM   4630  CD  GLU D 289      -4.759  18.279  -0.093  1.00 11.20           C  
ATOM   4631  OE1 GLU D 289      -4.278  19.363  -0.501  1.00 11.73           O  
ATOM   4632  OE2 GLU D 289      -4.066  17.275   0.133  1.00 10.34           O  
ATOM   4633  N   THR D 290      -5.317  20.926   3.621  1.00 10.98           N  
ATOM   4634  CA  THR D 290      -5.219  22.220   4.291  1.00 10.62           C  
ATOM   4635  C   THR D 290      -4.025  22.937   3.666  1.00 10.92           C  
ATOM   4636  O   THR D 290      -3.433  22.420   2.720  1.00 10.72           O  
ATOM   4637  CB  THR D 290      -4.946  22.064   5.790  1.00 10.48           C  
ATOM   4638  OG1 THR D 290      -3.617  21.522   5.961  1.00 10.57           O  
ATOM   4639  CG2 THR D 290      -6.005  21.149   6.465  1.00 10.62           C  
ATOM   4640  N   ASN D 291      -3.672  24.105   4.204  1.00 10.78           N  
ATOM   4641  CA  ASN D 291      -2.482  24.829   3.764  1.00 10.91           C  
ATOM   4642  C   ASN D 291      -1.230  24.493   4.573  1.00 10.62           C  
ATOM   4643  O   ASN D 291      -0.190  25.136   4.391  1.00 10.86           O  
ATOM   4644  CB  ASN D 291      -2.727  26.347   3.751  1.00 12.16           C  
ATOM   4645  CG  ASN D 291      -2.876  26.941   5.152  0.50 13.64           C  
ATOM   4647  OD1 ASN D 291      -2.745  26.249   6.161  0.50 15.53           O  
ATOM   4649  ND2 ASN D 291      -3.162  28.242   5.211  0.50 15.96           N  
ATOM   4651  N   ARG D 292      -1.335  23.511   5.467  1.00 10.00           N  
ATOM   4652  CA  ARG D 292      -0.223  23.162   6.349  1.00  9.92           C  
ATOM   4653  C   ARG D 292       0.817  22.319   5.634  1.00  9.23           C  
ATOM   4654  O   ARG D 292       0.475  21.502   4.765  1.00  9.17           O  
ATOM   4655  CB  ARG D 292      -0.744  22.416   7.572  1.00  9.78           C  
ATOM   4656  CG  ARG D 292      -1.610  23.262   8.507  1.00 11.73           C  
ATOM   4657  CD  ARG D 292      -0.870  24.486   9.009  1.00 14.42           C  
ATOM   4658  NE  ARG D 292      -1.527  25.044  10.186  1.00 15.23           N  
ATOM   4659  CZ  ARG D 292      -0.996  25.055  11.406  1.00 13.03           C  
ATOM   4660  NH1 ARG D 292       0.235  24.572  11.627  1.00 11.88           N  
ATOM   4661  NH2 ARG D 292      -1.697  25.562  12.407  1.00 13.26           N  
ATOM   4662  N   LEU D 293       2.084  22.524   5.994  1.00  8.82           N  
ATOM   4663  CA  LEU D 293       3.175  21.954   5.216  1.00  8.37           C  
ATOM   4664  C   LEU D 293       3.737  20.650   5.731  1.00  7.29           C  
ATOM   4665  O   LEU D 293       4.333  19.899   4.960  1.00  7.82           O  
ATOM   4666  CB  LEU D 293       4.311  22.971   5.049  1.00  8.85           C  
ATOM   4667  CG  LEU D 293       3.854  24.218   4.277  1.00 10.04           C  
ATOM   4668  CD1 LEU D 293       4.981  25.235   4.226  1.00 11.25           C  
ATOM   4669  CD2 LEU D 293       3.398  23.857   2.869  1.00 11.68           C  
ATOM   4670  N   GLY D 294       3.590  20.387   7.027  1.00  7.47           N  
ATOM   4671  CA  GLY D 294       4.168  19.161   7.588  1.00  7.14           C  
ATOM   4672  C   GLY D 294       3.676  17.918   6.859  1.00  6.78           C  
ATOM   4673  O   GLY D 294       4.451  16.975   6.581  1.00  7.05           O  
ATOM   4674  N   ARG D 295       2.372  17.903   6.573  1.00  6.84           N  
ATOM   4675  CA  ARG D 295       1.722  16.791   5.880  1.00  7.35           C  
ATOM   4676  C   ARG D 295       2.248  16.581   4.452  1.00  7.45           C  
ATOM   4677  O   ARG D 295       2.040  15.506   3.865  1.00  8.85           O  
ATOM   4678  CB  ARG D 295       0.208  17.030   5.854  1.00  7.37           C  
ATOM   4679  CG  ARG D 295      -0.190  18.274   5.052  1.00  8.24           C  
ATOM   4680  CD  ARG D 295      -1.695  18.596   5.208  1.00  8.90           C  
ATOM   4681  NE  ARG D 295      -2.558  17.552   4.644  1.00  8.82           N  
ATOM   4682  CZ  ARG D 295      -2.890  17.452   3.358  1.00  9.41           C  
ATOM   4683  NH1 ARG D 295      -2.487  18.364   2.481  1.00  9.79           N  
ATOM   4684  NH2 ARG D 295      -3.662  16.453   2.949  1.00  9.21           N  
ATOM   4685  N   LEU D 296       2.922  17.605   3.897  1.00  7.37           N  
ATOM   4686  CA  LEU D 296       3.444  17.534   2.532  1.00  6.92           C  
ATOM   4687  C   LEU D 296       4.904  17.105   2.442  1.00  6.91           C  
ATOM   4688  O   LEU D 296       5.426  16.934   1.334  1.00  7.45           O  
ATOM   4689  CB  LEU D 296       3.247  18.863   1.794  1.00  8.03           C  
ATOM   4690  CG  LEU D 296       1.811  19.319   1.653  1.00  7.47           C  
ATOM   4691  CD1 LEU D 296       1.790  20.586   0.819  1.00  9.32           C  
ATOM   4692  CD2 LEU D 296       0.962  18.209   1.026  1.00  8.50           C  
ATOM   4693  N   ILE D 297       5.560  16.915   3.590  1.00  6.97           N  
ATOM   4694  CA  ILE D 297       6.979  16.574   3.578  1.00  6.75           C  
ATOM   4695  C   ILE D 297       7.165  15.095   3.245  1.00  6.73           C  
ATOM   4696  O   ILE D 297       6.487  14.217   3.794  1.00  6.76           O  
ATOM   4697  CB  ILE D 297       7.655  16.944   4.904  1.00  7.21           C  
ATOM   4698  CG1 ILE D 297       7.706  18.470   5.012  1.00  7.41           C  
ATOM   4699  CG2 ILE D 297       9.075  16.364   4.986  1.00  7.66           C  
ATOM   4700  CD1 ILE D 297       8.123  19.022   6.325  1.00  7.72           C  
ATOM   4701  N   ASN D 298       8.098  14.840   2.335  1.00  6.80           N  
ATOM   4702  CA  ASN D 298       8.345  13.493   1.845  1.00  6.26           C  
ATOM   4703  C   ASN D 298       9.326  12.674   2.704  1.00  6.73           C  
ATOM   4704  O   ASN D 298       9.911  13.194   3.653  1.00  7.36           O  
ATOM   4705  CB  ASN D 298       8.723  13.548   0.349  1.00  7.09           C  
ATOM   4706  CG  ASN D 298       7.552  13.976  -0.503  1.00  7.20           C  
ATOM   4707  OD1 ASN D 298       6.433  13.472  -0.321  1.00  7.74           O  
ATOM   4708  ND2 ASN D 298       7.777  14.938  -1.412  1.00  8.15           N  
ATOM   4709  N   HIS D 299       9.441  11.393   2.371  1.00  6.89           N  
ATOM   4710  CA  HIS D 299      10.184  10.418   3.153  1.00  6.84           C  
ATOM   4711  C   HIS D 299      11.607  10.252   2.675  1.00  8.05           C  
ATOM   4712  O   HIS D 299      11.855  10.181   1.477  1.00  8.16           O  
ATOM   4713  CB  HIS D 299       9.496   9.042   3.044  1.00  7.09           C  
ATOM   4714  CG  HIS D 299      10.359   7.913   3.508  1.00  7.36           C  
ATOM   4715  ND1 HIS D 299      10.478   7.551   4.835  1.00  8.25           N  
ATOM   4716  CD2 HIS D 299      11.167   7.078   2.813  1.00  7.82           C  
ATOM   4717  CE1 HIS D 299      11.332   6.546   4.937  1.00  8.11           C  
ATOM   4718  NE2 HIS D 299      11.756   6.233   3.724  1.00  8.75           N  
ATOM   4719  N   SER D 300      12.520  10.103   3.624  1.00  8.47           N  
ATOM   4720  CA  SER D 300      13.864   9.598   3.342  1.00 10.32           C  
ATOM   4721  C   SER D 300      14.381   9.019   4.637  1.00 11.37           C  
ATOM   4722  O   SER D 300      14.243   9.656   5.676  1.00 12.35           O  
ATOM   4723  CB  SER D 300      14.769  10.744   2.906  1.00 11.35           C  
ATOM   4724  OG  SER D 300      16.050  10.263   2.537  1.00 16.62           O  
ATOM   4725  N   LYS D 301      15.002   7.845   4.594  1.00 12.02           N  
ATOM   4726  CA  LYS D 301      15.614   7.314   5.826  1.00 13.18           C  
ATOM   4727  C   LYS D 301      16.756   8.199   6.314  1.00 14.56           C  
ATOM   4728  O   LYS D 301      16.973   8.309   7.523  1.00 16.89           O  
ATOM   4729  CB  LYS D 301      16.122   5.888   5.645  1.00 14.23           C  
ATOM   4730  CG  LYS D 301      15.021   4.849   5.597  1.00 13.77           C  
ATOM   4731  CD  LYS D 301      15.595   3.500   5.189  1.00 17.07           C  
ATOM   4732  CE  LYS D 301      14.500   2.464   5.116  1.00 18.92           C  
ATOM   4733  NZ  LYS D 301      15.007   1.123   4.696  1.00 22.41           N  
ATOM   4734  N   CYS D 302      17.454   8.837   5.374  1.00 14.54           N  
ATOM   4735  CA  CYS D 302      18.627   9.668   5.673  1.00 15.67           C  
ATOM   4736  C   CYS D 302      18.337  11.128   5.378  1.00 14.77           C  
ATOM   4737  O   CYS D 302      19.119  11.825   4.744  1.00 16.21           O  
ATOM   4738  CB  CYS D 302      19.822   9.181   4.862  1.00 16.75           C  
ATOM   4739  SG  CYS D 302      20.218   7.478   5.216  1.00 23.70           S  
ATOM   4740  N   GLY D 303      17.191  11.575   5.862  1.00 13.39           N  
ATOM   4741  CA  GLY D 303      16.747  12.938   5.613  1.00 12.15           C  
ATOM   4742  C   GLY D 303      17.409  13.958   6.517  1.00 11.77           C  
ATOM   4743  O   GLY D 303      18.468  13.720   7.101  1.00 14.15           O  
ATOM   4744  N   ASN D 304      16.777  15.116   6.613  1.00  9.25           N  
ATOM   4745  CA  ASN D 304      17.327  16.237   7.369  1.00  9.02           C  
ATOM   4746  C   ASN D 304      16.461  16.667   8.553  1.00  9.12           C  
ATOM   4747  O   ASN D 304      16.807  17.605   9.258  1.00  9.56           O  
ATOM   4748  CB  ASN D 304      17.619  17.434   6.447  1.00  9.12           C  
ATOM   4749  CG  ASN D 304      16.430  17.802   5.562  1.00  7.79           C  
ATOM   4750  OD1 ASN D 304      15.274  17.482   5.888  1.00  8.28           O  
ATOM   4751  ND2 ASN D 304      16.701  18.469   4.426  1.00  9.74           N  
ATOM   4752  N   CYS D 305      15.335  15.982   8.751  1.00  9.21           N  
ATOM   4753  CA  CYS D 305      14.457  16.238   9.887  1.00  9.70           C  
ATOM   4754  C   CYS D 305      14.201  14.956  10.656  1.00  9.44           C  
ATOM   4755  O   CYS D 305      14.233  13.850  10.088  1.00 10.01           O  
ATOM   4756  CB  CYS D 305      13.111  16.790   9.423  1.00 10.20           C  
ATOM   4757  SG  CYS D 305      13.199  18.402   8.614  1.00 11.06           S  
ATOM   4758  N   GLN D 306      13.936  15.116  11.953  1.00 10.91           N  
ATOM   4759  CA  GLN D 306      13.539  13.997  12.808  1.00 12.16           C  
ATOM   4760  C   GLN D 306      12.250  14.411  13.518  1.00 11.58           C  
ATOM   4761  O   GLN D 306      12.152  15.514  14.042  1.00 11.45           O  
ATOM   4762  CB  GLN D 306      14.634  13.660  13.830  1.00 13.78           C  
ATOM   4763  CG  GLN D 306      14.231  12.726  14.991  0.50 15.69           C  
ATOM   4765  CD  GLN D 306      14.691  11.277  14.805  0.50 19.03           C  
ATOM   4767  OE1 GLN D 306      15.467  10.969  13.908  0.50 20.31           O  
ATOM   4769  NE2 GLN D 306      14.213  10.387  15.668  0.50 20.91           N  
ATOM   4771  N   THR D 307      11.264  13.530  13.520  1.00 11.13           N  
ATOM   4772  CA  THR D 307      10.018  13.807  14.229  1.00 11.44           C  
ATOM   4773  C   THR D 307      10.186  13.497  15.708  1.00 11.95           C  
ATOM   4774  O   THR D 307      10.770  12.474  16.074  1.00 12.82           O  
ATOM   4775  CB  THR D 307       8.883  12.983  13.644  1.00 11.75           C  
ATOM   4776  OG1 THR D 307       8.851  13.220  12.240  1.00 11.72           O  
ATOM   4777  CG2 THR D 307       7.528  13.377  14.255  1.00 11.74           C  
ATOM   4778  N   LYS D 308       9.652  14.383  16.541  1.00 11.52           N  
ATOM   4779  CA  LYS D 308       9.707  14.210  17.992  1.00 13.18           C  
ATOM   4780  C   LYS D 308       8.334  14.431  18.574  1.00 13.37           C  
ATOM   4781  O   LYS D 308       7.553  15.243  18.067  1.00 12.15           O  
ATOM   4782  CB  LYS D 308      10.670  15.232  18.609  1.00 14.08           C  
ATOM   4783  CG  LYS D 308      12.077  15.272  18.014  1.00 17.82           C  
ATOM   4784  CD  LYS D 308      12.992  14.234  18.620  1.00 22.14           C  
ATOM   4785  CE  LYS D 308      14.443  14.490  18.204  1.00 24.48           C  
ATOM   4786  NZ  LYS D 308      14.932  15.845  18.597  1.00 27.78           N  
ATOM   4787  N   LEU D 309       8.052  13.691  19.639  1.00 14.06           N  
ATOM   4788  CA  LEU D 309       6.862  13.900  20.445  1.00 15.40           C  
ATOM   4789  C   LEU D 309       7.125  15.050  21.403  1.00 15.74           C  
ATOM   4790  O   LEU D 309       8.119  15.030  22.132  1.00 16.52           O  
ATOM   4791  CB  LEU D 309       6.550  12.623  21.238  1.00 15.70           C  
ATOM   4792  CG  LEU D 309       5.394  12.684  22.250  1.00 17.25           C  
ATOM   4793  CD1 LEU D 309       4.075  13.105  21.608  1.00 17.83           C  
ATOM   4794  CD2 LEU D 309       5.253  11.356  22.979  1.00 16.80           C  
ATOM   4795  N   HIS D 310       6.222  16.024  21.403  1.00 15.32           N  
ATOM   4796  CA  HIS D 310       6.354  17.234  22.201  1.00 16.19           C  
ATOM   4797  C   HIS D 310       5.044  17.611  22.884  1.00 16.62           C  
ATOM   4798  O   HIS D 310       4.021  17.833  22.220  1.00 18.20           O  
ATOM   4799  CB  HIS D 310       6.789  18.375  21.306  1.00 15.96           C  
ATOM   4800  CG  HIS D 310       7.056  19.643  22.039  1.00 16.09           C  
ATOM   4801  ND1 HIS D 310       8.200  19.846  22.781  1.00 17.10           N  
ATOM   4802  CD2 HIS D 310       6.333  20.781  22.139  1.00 14.06           C  
ATOM   4803  CE1 HIS D 310       8.174  21.062  23.294  1.00 16.89           C  
ATOM   4804  NE2 HIS D 310       7.052  21.649  22.926  1.00 15.75           N  
ATOM   4805  N   ASP D 311       5.100  17.725  24.208  1.00 16.01           N  
ATOM   4806  CA  ASP D 311       3.924  17.941  25.047  1.00 16.45           C  
ATOM   4807  C   ASP D 311       3.817  19.421  25.408  1.00 16.00           C  
ATOM   4808  O   ASP D 311       4.788  20.003  25.890  1.00 16.52           O  
ATOM   4809  CB  ASP D 311       4.103  17.092  26.318  1.00 17.08           C  
ATOM   4810  CG  ASP D 311       2.913  17.139  27.262  1.00 19.86           C  
ATOM   4811  OD1 ASP D 311       2.627  16.079  27.865  1.00 22.36           O  
ATOM   4812  OD2 ASP D 311       2.290  18.209  27.426  1.00 22.37           O  
ATOM   4813  N   ILE D 312       2.659  20.035  25.159  1.00 14.95           N  
ATOM   4814  CA  ILE D 312       2.366  21.368  25.717  1.00 14.95           C  
ATOM   4815  C   ILE D 312       1.145  21.280  26.603  1.00 14.69           C  
ATOM   4816  O   ILE D 312       0.039  21.034  26.112  1.00 14.66           O  
ATOM   4817  CB  ILE D 312       2.079  22.418  24.633  1.00 14.61           C  
ATOM   4818  CG1 ILE D 312       3.164  22.384  23.556  1.00 15.50           C  
ATOM   4819  CG2 ILE D 312       1.941  23.825  25.254  1.00 16.25           C  
ATOM   4820  CD1 ILE D 312       2.891  23.314  22.423  1.00 15.85           C  
ATOM   4821  N   ASP D 313       1.347  21.503  27.905  1.00 14.97           N  
ATOM   4822  CA  ASP D 313       0.234  21.523  28.866  1.00 15.28           C  
ATOM   4823  C   ASP D 313      -0.689  20.315  28.690  1.00 15.11           C  
ATOM   4824  O   ASP D 313      -1.917  20.448  28.677  1.00 15.45           O  
ATOM   4825  CB  ASP D 313      -0.548  22.838  28.728  1.00 15.48           C  
ATOM   4826  CG  ASP D 313      -1.437  23.152  29.940  1.00 16.29           C  
ATOM   4827  OD1 ASP D 313      -1.244  22.569  31.027  1.00 15.67           O  
ATOM   4828  OD2 ASP D 313      -2.333  24.004  29.769  1.00 17.49           O  
ATOM   4829  N   GLY D 314      -0.081  19.140  28.543  1.00 14.63           N  
ATOM   4830  CA  GLY D 314      -0.833  17.884  28.464  1.00 15.02           C  
ATOM   4831  C   GLY D 314      -1.444  17.540  27.107  1.00 15.08           C  
ATOM   4832  O   GLY D 314      -2.222  16.578  27.006  1.00 16.27           O  
ATOM   4833  N   VAL D 315      -1.110  18.321  26.075  1.00 13.88           N  
ATOM   4834  CA  VAL D 315      -1.543  18.031  24.712  1.00 13.15           C  
ATOM   4835  C   VAL D 315      -0.307  17.626  23.903  1.00 12.25           C  
ATOM   4836  O   VAL D 315       0.659  18.379  23.846  1.00 11.85           O  
ATOM   4837  CB  VAL D 315      -2.228  19.247  24.066  1.00 13.13           C  
ATOM   4838  CG1 VAL D 315      -2.658  18.940  22.627  1.00 13.84           C  
ATOM   4839  CG2 VAL D 315      -3.425  19.713  24.910  1.00 13.94           C  
ATOM   4840  N   PRO D 316      -0.328  16.429  23.289  1.00 11.97           N  
ATOM   4841  CA  PRO D 316       0.818  16.011  22.484  1.00 11.81           C  
ATOM   4842  C   PRO D 316       0.823  16.641  21.102  1.00 11.68           C  
ATOM   4843  O   PRO D 316      -0.237  16.850  20.504  1.00 12.51           O  
ATOM   4844  CB  PRO D 316       0.605  14.502  22.343  1.00 12.47           C  
ATOM   4845  CG  PRO D 316      -0.905  14.359  22.346  1.00 12.76           C  
ATOM   4846  CD  PRO D 316      -1.394  15.406  23.319  1.00 11.72           C  
ATOM   4847  N   HIS D 317       2.027  16.897  20.607  1.00 11.00           N  
ATOM   4848  CA  HIS D 317       2.247  17.410  19.251  1.00 11.16           C  
ATOM   4849  C   HIS D 317       3.392  16.645  18.633  1.00 11.02           C  
ATOM   4850  O   HIS D 317       4.363  16.310  19.326  1.00 12.66           O  
ATOM   4851  CB  HIS D 317       2.639  18.883  19.276  1.00 11.07           C  
ATOM   4852  CG  HIS D 317       1.580  19.771  19.852  1.00 11.52           C  
ATOM   4853  ND1 HIS D 317       0.700  20.483  19.068  1.00 11.44           N  
ATOM   4854  CD2 HIS D 317       1.240  20.039  21.137  1.00 12.71           C  
ATOM   4855  CE1 HIS D 317      -0.136  21.154  19.844  1.00 12.77           C  
ATOM   4856  NE2 HIS D 317       0.175  20.906  21.103  1.00 12.74           N  
ATOM   4857  N   LEU D 318       3.270  16.375  17.336  1.00 10.10           N  
ATOM   4858  CA  LEU D 318       4.375  15.836  16.556  1.00  9.84           C  
ATOM   4859  C   LEU D 318       5.072  16.963  15.847  1.00  9.78           C  
ATOM   4860  O   LEU D 318       4.446  17.709  15.085  1.00  9.72           O  
ATOM   4861  CB  LEU D 318       3.879  14.833  15.509  1.00  9.38           C  
ATOM   4862  CG  LEU D 318       3.291  13.535  16.060  1.00 10.46           C  
ATOM   4863  CD1 LEU D 318       2.863  12.628  14.922  1.00 11.89           C  
ATOM   4864  CD2 LEU D 318       4.271  12.820  16.995  1.00 12.83           C  
ATOM   4865  N   ILE D 319       6.359  17.127  16.131  1.00  9.61           N  
ATOM   4866  CA  ILE D 319       7.126  18.213  15.529  1.00 10.60           C  
ATOM   4867  C   ILE D 319       8.373  17.686  14.814  1.00  9.74           C  
ATOM   4868  O   ILE D 319       9.000  16.721  15.261  1.00 10.21           O  
ATOM   4869  CB  ILE D 319       7.485  19.313  16.573  1.00 11.18           C  
ATOM   4870  CG1 ILE D 319       8.434  18.757  17.642  1.00 11.56           C  
ATOM   4871  CG2 ILE D 319       6.211  19.864  17.211  1.00 11.42           C  
ATOM   4872  CD1 ILE D 319       8.953  19.800  18.628  1.00 12.17           C  
ATOM   4873  N   LEU D 320       8.701  18.323  13.695  1.00  9.65           N  
ATOM   4874  CA  LEU D 320       9.895  18.011  12.926  1.00 10.31           C  
ATOM   4875  C   LEU D 320      10.989  18.986  13.316  1.00 10.93           C  
ATOM   4876  O   LEU D 320      10.781  20.203  13.285  1.00 11.21           O  
ATOM   4877  CB  LEU D 320       9.615  18.107  11.430  1.00 10.23           C  
ATOM   4878  CG  LEU D 320       8.953  16.881  10.798  1.00 11.26           C  
ATOM   4879  CD1 LEU D 320       7.560  16.606  11.331  1.00 12.90           C  
ATOM   4880  CD2 LEU D 320       8.943  17.070   9.297  1.00 14.11           C  
ATOM   4881  N   ILE D 321      12.124  18.422  13.716  1.00 11.68           N  
ATOM   4882  CA  ILE D 321      13.306  19.141  14.190  1.00 12.52           C  
ATOM   4883  C   ILE D 321      14.433  18.871  13.188  1.00 12.00           C  
ATOM   4884  O   ILE D 321      14.572  17.739  12.719  1.00 11.95           O  
ATOM   4885  CB  ILE D 321      13.718  18.587  15.603  1.00 13.41           C  
ATOM   4886  CG1 ILE D 321      12.576  18.763  16.622  1.00 14.39           C  
ATOM   4887  CG2 ILE D 321      15.018  19.186  16.117  1.00 15.95           C  
ATOM   4888  CD1 ILE D 321      12.054  20.158  16.726  1.00 16.91           C  
ATOM   4889  N   ALA D 322      15.227  19.891  12.854  1.00 11.16           N  
ATOM   4890  CA  ALA D 322      16.369  19.703  11.967  1.00 10.94           C  
ATOM   4891  C   ALA D 322      17.383  18.764  12.617  1.00 11.32           C  
ATOM   4892  O   ALA D 322      17.830  19.006  13.754  1.00 11.78           O  
ATOM   4893  CB  ALA D 322      17.009  21.045  11.649  1.00 10.60           C  
ATOM   4894  N   SER D 323      17.766  17.705  11.901  1.00 11.99           N  
ATOM   4895  CA  SER D 323      18.708  16.737  12.460  1.00 12.66           C  
ATOM   4896  C   SER D 323      20.149  17.142  12.199  1.00 12.64           C  
ATOM   4897  O   SER D 323      21.076  16.517  12.715  1.00 13.87           O  
ATOM   4898  CB  SER D 323      18.441  15.354  11.890  1.00 13.71           C  
ATOM   4899  OG  SER D 323      18.665  15.376  10.496  1.00 14.48           O  
ATOM   4900  N   ARG D 324      20.312  18.177  11.381  1.00 12.30           N  
ATOM   4901  CA  ARG D 324      21.597  18.762  10.998  1.00 11.96           C  
ATOM   4902  C   ARG D 324      21.280  20.145  10.434  1.00 12.05           C  
ATOM   4903  O   ARG D 324      20.102  20.494  10.240  1.00 12.10           O  
ATOM   4904  CB  ARG D 324      22.276  17.900   9.924  1.00 12.12           C  
ATOM   4905  CG  ARG D 324      21.425  17.711   8.658  1.00 11.65           C  
ATOM   4906  CD  ARG D 324      22.284  17.114   7.559  1.00 12.00           C  
ATOM   4907  NE  ARG D 324      21.521  16.693   6.380  1.00 11.47           N  
ATOM   4908  CZ  ARG D 324      21.091  17.511   5.426  1.00 10.19           C  
ATOM   4909  NH1 ARG D 324      21.290  18.827   5.509  1.00 10.58           N  
ATOM   4910  NH2 ARG D 324      20.448  17.004   4.384  1.00  9.87           N  
ATOM   4911  N   ASP D 325      22.304  20.947  10.155  1.00 12.06           N  
ATOM   4912  CA  ASP D 325      22.081  22.187   9.428  1.00 12.79           C  
ATOM   4913  C   ASP D 325      21.478  21.872   8.057  1.00 11.88           C  
ATOM   4914  O   ASP D 325      21.914  20.935   7.375  1.00 12.23           O  
ATOM   4915  CB  ASP D 325      23.398  22.946   9.236  1.00 13.17           C  
ATOM   4916  CG  ASP D 325      23.966  23.506  10.541  1.00 15.23           C  
ATOM   4917  OD1 ASP D 325      23.302  23.423  11.596  1.00 15.60           O  
ATOM   4918  OD2 ASP D 325      25.104  24.040  10.500  1.00 18.14           O  
ATOM   4919  N   ILE D 326      20.461  22.646   7.681  1.00 11.36           N  
ATOM   4920  CA  ILE D 326      19.771  22.494   6.400  1.00 11.39           C  
ATOM   4921  C   ILE D 326      19.999  23.735   5.565  1.00 12.00           C  
ATOM   4922  O   ILE D 326      19.797  24.860   6.037  1.00 12.17           O  
ATOM   4923  CB  ILE D 326      18.258  22.317   6.620  1.00 10.97           C  
ATOM   4924  CG1 ILE D 326      17.985  21.101   7.512  1.00 10.62           C  
ATOM   4925  CG2 ILE D 326      17.534  22.164   5.277  1.00 11.78           C  
ATOM   4926  CD1 ILE D 326      16.507  20.871   7.867  1.00 10.75           C  
ATOM   4927  N   ALA D 327      20.431  23.532   4.328  1.00 12.05           N  
ATOM   4928  CA  ALA D 327      20.669  24.650   3.441  1.00 12.23           C  
ATOM   4929  C   ALA D 327      19.389  25.037   2.712  1.00 12.02           C  
ATOM   4930  O   ALA D 327      18.566  24.170   2.368  1.00 11.83           O  
ATOM   4931  CB  ALA D 327      21.771  24.311   2.447  1.00 12.49           C  
ATOM   4932  N   ALA D 328      19.218  26.331   2.454  1.00 11.94           N  
ATOM   4933  CA  ALA D 328      18.140  26.770   1.586  1.00 12.05           C  
ATOM   4934  C   ALA D 328      18.227  26.012   0.263  1.00 11.83           C  
ATOM   4935  O   ALA D 328      19.316  25.779  -0.284  1.00 11.62           O  
ATOM   4936  CB  ALA D 328      18.198  28.278   1.365  1.00 12.65           C  
ATOM   4937  N   GLY D 329      17.066  25.606  -0.242  1.00 10.98           N  
ATOM   4938  CA  GLY D 329      17.004  24.834  -1.480  1.00 10.64           C  
ATOM   4939  C   GLY D 329      16.843  23.331  -1.294  1.00  9.81           C  
ATOM   4940  O   GLY D 329      16.458  22.624  -2.225  1.00 10.18           O  
ATOM   4941  N   GLU D 330      17.166  22.837  -0.101  1.00  9.00           N  
ATOM   4942  CA  GLU D 330      16.979  21.427   0.201  1.00  8.91           C  
ATOM   4943  C   GLU D 330      15.499  21.065   0.246  1.00  8.15           C  
ATOM   4944  O   GLU D 330      14.683  21.832   0.756  1.00  9.44           O  
ATOM   4945  CB  GLU D 330      17.580  21.049   1.555  1.00  8.78           C  
ATOM   4946  CG  GLU D 330      19.090  21.031   1.590  1.00  9.73           C  
ATOM   4947  CD  GLU D 330      19.617  20.200   2.750  1.00  9.82           C  
ATOM   4948  OE1 GLU D 330      20.486  20.705   3.485  1.00 10.90           O  
ATOM   4949  OE2 GLU D 330      19.166  19.044   2.925  1.00 10.80           O  
ATOM   4950  N   GLU D 331      15.172  19.872  -0.251  1.00  7.85           N  
ATOM   4951  CA  GLU D 331      13.896  19.286   0.109  1.00  7.52           C  
ATOM   4952  C   GLU D 331      13.959  18.847   1.581  1.00  7.06           C  
ATOM   4953  O   GLU D 331      14.921  18.202   2.015  1.00  8.24           O  
ATOM   4954  CB  GLU D 331      13.544  18.099  -0.779  1.00  7.05           C  
ATOM   4955  CG  GLU D 331      12.104  17.647  -0.544  1.00  7.28           C  
ATOM   4956  CD  GLU D 331      11.621  16.472  -1.358  1.00  7.86           C  
ATOM   4957  OE1 GLU D 331      12.367  15.884  -2.172  1.00  8.25           O  
ATOM   4958  OE2 GLU D 331      10.438  16.143  -1.163  1.00  7.97           O  
ATOM   4959  N   LEU D 332      12.935  19.193   2.349  1.00  7.12           N  
ATOM   4960  CA  LEU D 332      12.790  18.659   3.708  1.00  7.75           C  
ATOM   4961  C   LEU D 332      12.347  17.205   3.628  1.00  7.75           C  
ATOM   4962  O   LEU D 332      11.451  16.864   2.840  1.00  7.70           O  
ATOM   4963  CB  LEU D 332      11.780  19.473   4.523  1.00  8.71           C  
ATOM   4964  CG  LEU D 332      12.139  20.950   4.715  1.00  9.35           C  
ATOM   4965  CD1 LEU D 332      10.993  21.648   5.423  1.00 10.28           C  
ATOM   4966  CD2 LEU D 332      13.418  21.101   5.529  1.00  9.62           C  
ATOM   4967  N   LEU D 333      12.951  16.359   4.464  1.00  7.97           N  
ATOM   4968  CA  LEU D 333      12.748  14.921   4.385  1.00  7.71           C  
ATOM   4969  C   LEU D 333      12.925  14.303   5.758  1.00  7.78           C  
ATOM   4970  O   LEU D 333      13.815  14.709   6.492  1.00  8.01           O  
ATOM   4971  CB  LEU D 333      13.781  14.286   3.443  1.00  8.55           C  
ATOM   4972  CG  LEU D 333      13.723  14.692   1.964  1.00  9.29           C  
ATOM   4973  CD1 LEU D 333      14.977  14.236   1.212  1.00 10.75           C  
ATOM   4974  CD2 LEU D 333      12.459  14.153   1.290  1.00 10.41           C  
ATOM   4975  N   TYR D 334      12.064  13.350   6.116  1.00  7.64           N  
ATOM   4976  CA  TYR D 334      12.258  12.595   7.366  1.00  7.52           C  
ATOM   4977  C   TYR D 334      11.869  11.143   7.176  1.00  7.39           C  
ATOM   4978  O   TYR D 334      11.237  10.779   6.187  1.00  8.01           O  
ATOM   4979  CB  TYR D 334      11.425  13.187   8.524  1.00  8.05           C  
ATOM   4980  CG  TYR D 334       9.926  13.074   8.334  1.00  7.95           C  
ATOM   4981  CD1 TYR D 334       9.189  12.073   8.970  1.00  7.76           C  
ATOM   4982  CD2 TYR D 334       9.249  13.965   7.521  1.00  7.95           C  
ATOM   4983  CE1 TYR D 334       7.818  11.956   8.781  1.00  8.40           C  
ATOM   4984  CE2 TYR D 334       7.867  13.863   7.340  1.00  7.16           C  
ATOM   4985  CZ  TYR D 334       7.163  12.868   7.982  1.00  7.56           C  
ATOM   4986  OH  TYR D 334       5.799  12.740   7.817  1.00  8.52           O  
ATOM   4987  N   ASP D 335      12.223  10.303   8.144  1.00  7.33           N  
ATOM   4988  CA  ASP D 335      11.915   8.883   8.057  1.00  7.78           C  
ATOM   4989  C   ASP D 335      10.469   8.644   8.487  1.00  7.77           C  
ATOM   4990  O   ASP D 335      10.132   8.875   9.647  1.00  8.42           O  
ATOM   4991  CB  ASP D 335      12.887   8.116   8.960  1.00  8.22           C  
ATOM   4992  CG  ASP D 335      12.692   6.623   8.927  1.00 10.02           C  
ATOM   4993  OD1 ASP D 335      11.850   6.109   8.170  1.00  9.56           O  
ATOM   4994  OD2 ASP D 335      13.425   5.942   9.695  1.00 15.06           O  
ATOM   4995  N   TYR D 336       9.622   8.213   7.544  1.00  7.27           N  
ATOM   4996  CA  TYR D 336       8.230   7.909   7.857  1.00  7.37           C  
ATOM   4997  C   TYR D 336       8.084   6.783   8.892  1.00  7.86           C  
ATOM   4998  O   TYR D 336       7.039   6.673   9.551  1.00  8.38           O  
ATOM   4999  CB  TYR D 336       7.486   7.505   6.593  1.00  6.62           C  
ATOM   5000  CG  TYR D 336       7.048   8.636   5.694  1.00  7.51           C  
ATOM   5001  CD1 TYR D 336       7.489   9.949   5.887  1.00  6.36           C  
ATOM   5002  CD2 TYR D 336       6.178   8.376   4.642  1.00  7.32           C  
ATOM   5003  CE1 TYR D 336       7.062  10.982   5.051  1.00  6.48           C  
ATOM   5004  CE2 TYR D 336       5.759   9.394   3.785  1.00  6.79           C  
ATOM   5005  CZ  TYR D 336       6.187  10.691   4.009  1.00  6.11           C  
ATOM   5006  OH  TYR D 336       5.742  11.680   3.162  1.00  6.81           O  
ATOM   5007  N   GLY D 337       9.091   5.918   8.991  1.00  7.93           N  
ATOM   5008  CA  GLY D 337       9.105   4.898  10.063  1.00  8.17           C  
ATOM   5009  C   GLY D 337       8.324   3.617   9.801  1.00  8.39           C  
ATOM   5010  O   GLY D 337       8.373   2.671  10.600  1.00  9.01           O  
ATOM   5011  N   ASP D 338       7.607   3.561   8.684  1.00  8.11           N  
ATOM   5012  CA  ASP D 338       6.882   2.339   8.319  1.00  7.97           C  
ATOM   5013  C   ASP D 338       7.835   1.441   7.551  1.00  8.30           C  
ATOM   5014  O   ASP D 338       8.193   1.726   6.411  1.00  8.48           O  
ATOM   5015  CB  ASP D 338       5.641   2.662   7.480  1.00  8.01           C  
ATOM   5016  CG  ASP D 338       4.746   1.453   7.245  1.00  8.77           C  
ATOM   5017  OD1 ASP D 338       5.164   0.297   7.524  1.00  9.44           O  
ATOM   5018  OD2 ASP D 338       3.627   1.672   6.745  1.00  8.84           O  
ATOM   5019  N   ARG D 339       8.281   0.381   8.221  1.00  8.37           N  
ATOM   5020  CA  ARG D 339       9.220  -0.597   7.669  1.00  8.61           C  
ATOM   5021  C   ARG D 339       8.526  -1.915   7.337  1.00  9.22           C  
ATOM   5022  O   ARG D 339       9.188  -2.883   6.959  1.00  9.34           O  
ATOM   5023  CB  ARG D 339      10.367  -0.832   8.659  1.00  9.23           C  
ATOM   5024  CG  ARG D 339      11.119   0.438   8.935  1.00 10.72           C  
ATOM   5025  CD  ARG D 339      12.222   0.374   9.952  1.00 12.28           C  
ATOM   5026  NE  ARG D 339      12.726   1.741  10.101  1.00 12.31           N  
ATOM   5027  CZ  ARG D 339      13.476   2.189  11.103  1.00 14.81           C  
ATOM   5028  NH1 ARG D 339      13.884   1.369  12.075  1.00 16.13           N  
ATOM   5029  NH2 ARG D 339      13.839   3.465  11.119  1.00 15.69           N  
ATOM   5030  N   SER D 340       7.204  -1.971   7.491  1.00  9.02           N  
ATOM   5031  CA  SER D 340       6.509  -3.252   7.324  1.00  9.93           C  
ATOM   5032  C   SER D 340       6.668  -3.794   5.908  1.00 10.54           C  
ATOM   5033  O   SER D 340       6.709  -3.024   4.947  1.00 10.33           O  
ATOM   5034  CB  SER D 340       5.037  -3.118   7.693  1.00  9.81           C  
ATOM   5035  OG  SER D 340       4.341  -2.308   6.753  1.00 10.84           O  
ATOM   5036  N   LYS D 341       6.765  -5.114   5.773  1.00 11.44           N  
ATOM   5037  CA  LYS D 341       6.923  -5.728   4.470  1.00 13.03           C  
ATOM   5038  C   LYS D 341       5.816  -5.302   3.508  1.00 11.56           C  
ATOM   5039  O   LYS D 341       6.082  -4.972   2.351  1.00 11.66           O  
ATOM   5040  CB  LYS D 341       6.933  -7.255   4.592  1.00 13.03           C  
ATOM   5041  CG  LYS D 341       7.212  -7.943   3.251  1.00 16.09           C  
ATOM   5042  CD  LYS D 341       7.371  -9.446   3.374  1.00 16.59           C  
ATOM   5043  CE  LYS D 341       7.599 -10.087   2.000  1.00 22.94           C  
ATOM   5044  NZ  LYS D 341       6.359 -10.019   1.169  1.00 26.30           N  
ATOM   5045  N   ALA D 342       4.569  -5.320   3.974  1.00 11.76           N  
ATOM   5046  CA  ALA D 342       3.460  -4.994   3.092  1.00 11.65           C  
ATOM   5047  C   ALA D 342       3.562  -3.554   2.612  1.00 11.56           C  
ATOM   5048  O   ALA D 342       3.325  -3.266   1.439  1.00 12.26           O  
ATOM   5049  CB  ALA D 342       2.138  -5.248   3.779  1.00 12.32           C  
ATOM   5050  N   SER D 343       3.958  -2.647   3.498  1.00 10.25           N  
ATOM   5051  CA  SER D 343       4.094  -1.251   3.073  1.00  9.84           C  
ATOM   5052  C   SER D 343       5.246  -1.045   2.096  1.00  9.61           C  
ATOM   5053  O   SER D 343       5.074  -0.344   1.087  1.00 10.05           O  
ATOM   5054  CB  SER D 343       4.273  -0.322   4.265  1.00  9.33           C  
ATOM   5055  OG  SER D 343       3.076  -0.303   5.024  1.00  9.65           O  
ATOM   5056  N   ILE D 344       6.409  -1.623   2.399  1.00  9.77           N  
ATOM   5057  CA  ILE D 344       7.600  -1.367   1.577  1.00 11.19           C  
ATOM   5058  C   ILE D 344       7.487  -2.036   0.213  1.00 11.21           C  
ATOM   5059  O   ILE D 344       8.079  -1.557  -0.760  1.00 11.72           O  
ATOM   5060  CB  ILE D 344       8.938  -1.731   2.275  1.00 11.46           C  
ATOM   5061  CG1 ILE D 344       9.067  -3.245   2.479  1.00 12.05           C  
ATOM   5062  CG2 ILE D 344       9.085  -0.954   3.592  1.00 11.44           C  
ATOM   5063  CD1 ILE D 344      10.325  -3.688   3.205  1.00 14.31           C  
ATOM   5064  N   GLU D 345       6.716  -3.116   0.116  1.00 10.84           N  
ATOM   5065  CA  GLU D 345       6.530  -3.759  -1.196  1.00 11.26           C  
ATOM   5066  C   GLU D 345       5.531  -3.016  -2.090  1.00 11.03           C  
ATOM   5067  O   GLU D 345       5.663  -3.022  -3.320  1.00 11.15           O  
ATOM   5068  CB  GLU D 345       6.194  -5.229  -1.019  1.00 12.03           C  
ATOM   5069  CG  GLU D 345       7.380  -5.945  -0.384  1.00 13.94           C  
ATOM   5070  CD  GLU D 345       7.432  -7.411  -0.660  1.00 18.72           C  
ATOM   5071  OE1 GLU D 345       8.532  -7.984  -0.468  1.00 20.91           O  
ATOM   5072  OE2 GLU D 345       6.396  -7.977  -1.054  1.00 22.24           O  
ATOM   5073  N   ALA D 346       4.556  -2.363  -1.462  1.00 10.77           N  
ATOM   5074  CA  ALA D 346       3.577  -1.537  -2.171  1.00 10.89           C  
ATOM   5075  C   ALA D 346       4.071  -0.112  -2.421  1.00 11.10           C  
ATOM   5076  O   ALA D 346       3.580   0.568  -3.337  1.00 11.84           O  
ATOM   5077  CB  ALA D 346       2.265  -1.509  -1.410  1.00 11.70           C  
ATOM   5078  N   HIS D 347       5.028   0.337  -1.606  1.00 10.58           N  
ATOM   5079  CA  HIS D 347       5.543   1.708  -1.663  1.00 10.05           C  
ATOM   5080  C   HIS D 347       7.050   1.642  -1.535  1.00  9.62           C  
ATOM   5081  O   HIS D 347       7.607   1.928  -0.474  1.00  9.69           O  
ATOM   5082  CB  HIS D 347       4.939   2.548  -0.534  1.00 10.12           C  
ATOM   5083  CG  HIS D 347       3.447   2.533  -0.535  1.00 10.25           C  
ATOM   5084  ND1 HIS D 347       2.698   3.393  -1.310  1.00 12.87           N  
ATOM   5085  CD2 HIS D 347       2.559   1.751   0.126  1.00 10.61           C  
ATOM   5086  CE1 HIS D 347       1.416   3.134  -1.136  1.00 13.64           C  
ATOM   5087  NE2 HIS D 347       1.303   2.138  -0.276  1.00 12.76           N  
ATOM   5088  N   PRO D 348       7.727   1.219  -2.614  1.00 10.39           N  
ATOM   5089  CA  PRO D 348       9.144   0.863  -2.495  1.00  9.78           C  
ATOM   5090  C   PRO D 348      10.085   1.991  -2.092  1.00  9.77           C  
ATOM   5091  O   PRO D 348      11.180   1.727  -1.596  1.00  9.65           O  
ATOM   5092  CB  PRO D 348       9.504   0.330  -3.902  1.00 10.81           C  
ATOM   5093  CG  PRO D 348       8.203  -0.014  -4.522  1.00 13.58           C  
ATOM   5094  CD  PRO D 348       7.195   0.953  -3.970  1.00 11.23           C  
ATOM   5095  N   TRP D 349       9.662   3.229  -2.324  1.00  8.63           N  
ATOM   5096  CA  TRP D 349      10.426   4.404  -1.907  1.00  8.66           C  
ATOM   5097  C   TRP D 349      10.631   4.453  -0.382  1.00  8.54           C  
ATOM   5098  O   TRP D 349      11.528   5.134   0.088  1.00  8.97           O  
ATOM   5099  CB  TRP D 349       9.765   5.688  -2.459  1.00  8.59           C  
ATOM   5100  CG  TRP D 349       8.294   5.733  -2.182  1.00  9.24           C  
ATOM   5101  CD1 TRP D 349       7.282   5.391  -3.031  1.00  8.73           C  
ATOM   5102  CD2 TRP D 349       7.670   6.102  -0.941  1.00  7.66           C  
ATOM   5103  NE1 TRP D 349       6.072   5.531  -2.400  1.00  9.47           N  
ATOM   5104  CE2 TRP D 349       6.283   5.967  -1.116  1.00  8.04           C  
ATOM   5105  CE3 TRP D 349       8.158   6.555   0.289  1.00  7.06           C  
ATOM   5106  CZ2 TRP D 349       5.373   6.246  -0.095  1.00  8.53           C  
ATOM   5107  CZ3 TRP D 349       7.260   6.833   1.299  1.00  7.52           C  
ATOM   5108  CH2 TRP D 349       5.885   6.671   1.106  1.00  7.76           C  
ATOM   5109  N   LEU D 350       9.820   3.696   0.369  1.00  8.31           N  
ATOM   5110  CA  LEU D 350       9.998   3.576   1.827  1.00  8.31           C  
ATOM   5111  C   LEU D 350      11.328   2.921   2.201  1.00  9.48           C  
ATOM   5112  O   LEU D 350      11.789   3.063   3.329  1.00  9.72           O  
ATOM   5113  CB  LEU D 350       8.852   2.782   2.474  1.00  8.10           C  
ATOM   5114  CG  LEU D 350       7.568   3.556   2.748  1.00  7.73           C  
ATOM   5115  CD1 LEU D 350       6.465   2.573   3.110  1.00  7.92           C  
ATOM   5116  CD2 LEU D 350       7.774   4.558   3.877  1.00  8.55           C  
ATOM   5117  N   LYS D 351      11.945   2.211   1.248  1.00 10.33           N  
ATOM   5118  CA  LYS D 351      13.225   1.533   1.506  1.00 12.53           C  
ATOM   5119  C   LYS D 351      14.406   2.501   1.454  1.00 13.02           C  
ATOM   5120  O   LYS D 351      15.523   2.159   1.847  1.00 14.88           O  
ATOM   5121  CB  LYS D 351      13.453   0.388   0.508  1.00 11.95           C  
ATOM   5122  CG  LYS D 351      12.372  -0.697   0.529  1.00 13.41           C  
ATOM   5123  CD  LYS D 351      12.678  -1.766  -0.521  1.00 14.72           C  
ATOM   5124  CE  LYS D 351      12.707  -1.172  -1.922  1.00 19.29           C  
ATOM   5125  NZ  LYS D 351      12.823  -2.213  -2.963  1.00 20.54           N  
ATOM   5126  N   HIS D 352      14.156   3.705   0.953  1.00 13.62           N  
ATOM   5127  CA  HIS D 352      15.206   4.665   0.709  1.00 14.60           C  
ATOM   5128  C   HIS D 352      15.412   5.618   1.889  1.00 15.63           C  
ATOM   5129  O   HIS D 352      16.560   5.960   2.201  1.00 15.69           O  
ATOM   5130  CB  HIS D 352      14.902   5.436  -0.572  1.00 15.55           C  
ATOM   5131  CG  HIS D 352      15.859   6.549  -0.845  1.00 17.51           C  
ATOM   5132  ND1 HIS D 352      17.109   6.334  -1.388  1.00 18.33           N  
ATOM   5133  CD2 HIS D 352      15.751   7.885  -0.654  1.00 18.49           C  
ATOM   5134  CE1 HIS D 352      17.729   7.496  -1.523  1.00 19.66           C  
ATOM   5135  NE2 HIS D 352      16.927   8.450  -1.087  1.00 19.29           N  
TER    5136      HIS D 352                                                      
END
MOLECULE T0434_28_195.pdb
ATOM     82  N   MET    28      22.710  14.827  17.394  1.00 19.78          
ATOM     83  CA  MET    28      21.299  14.682  17.865  1.00 18.24          
ATOM     84  CB  MET    28      20.424  15.805  17.271  1.00 16.44          
ATOM     85  CG  MET    28      20.912  17.218  17.730  1.00 16.65          
ATOM     86  SD  MET    28      20.167  18.502  16.727  1.00 17.98          
ATOM     87  CE  MET    28      18.476  18.620  17.315  1.00 23.33          
ATOM     88  C   MET    28      20.680  13.319  17.548  1.00 18.32          
ATOM     89  O   MET    28      19.531  13.041  17.912  1.00 17.04          
ATOM     90  N   THR    29      21.473  12.445  16.928  1.00 17.78          
ATOM     91  CA  THR    29      20.960  11.192  16.376  1.00 17.80          
ATOM     92  CB  THR    29      22.121  10.335  15.802  1.00 17.70          
ATOM     93  OG1 THR    29      22.780  11.076  14.749  1.00 21.06          
ATOM     94  CG2 THR    29      21.604   9.062  15.244  1.00 18.71          
ATOM     95  C   THR    29      20.227  10.375  17.432  1.00 17.25          
ATOM     96  O   THR    29      19.121   9.873  17.171  1.00 17.28          
ATOM     97  N   LEU    30      20.834  10.278  18.620  1.00 17.23          
ATOM     98  CA  LEU    30      20.275   9.453  19.702  1.00 17.85          
ATOM     99  CB  LEU    30      21.339   8.503  20.281  1.00 19.13          
ATOM    100  CG  LEU    30      21.953   7.574  19.231  1.00 20.87          
ATOM    101  CD1 LEU    30      22.994   6.665  19.872  1.00 23.53          
ATOM    102  CD2 LEU    30      20.859   6.766  18.518  1.00 22.15          
ATOM    103  C   LEU    30      19.612  10.240  20.832  1.00 17.63          
ATOM    104  O   LEU    30      19.372   9.666  21.906  1.00 17.70          
ATOM    105  N   TRP    31      19.326  11.531  20.602  1.00 15.78          
ATOM    106  CA  TRP    31      18.640  12.350  21.609  1.00 14.55          
ATOM    107  CB  TRP    31      18.424  13.793  21.146  1.00 16.42          
ATOM    108  CG  TRP    31      19.650  14.661  21.321  1.00 17.59          
ATOM    109  CD1 TRP    31      20.947  14.240  21.580  1.00 19.60          
ATOM    110  NE1 TRP    31      21.802  15.347  21.630  1.00 19.04          
ATOM    111  CE2 TRP    31      21.058  16.486  21.418  1.00 19.29          
ATOM    112  CD2 TRP    31      19.698  16.091  21.193  1.00 14.71          
ATOM    113  CE3 TRP    31      18.726  17.073  20.945  1.00 14.58          
ATOM    114  CZ3 TRP    31      19.140  18.405  20.880  1.00 16.67          
ATOM    115  CH2 TRP    31      20.516  18.761  21.088  1.00 18.25          
ATOM    116  CZ2 TRP    31      21.474  17.813  21.348  1.00 19.58          
ATOM    117  C   TRP    31      17.269  11.732  21.915  1.00 14.34          
ATOM    118  O   TRP    31      16.587  11.198  21.021  1.00 14.50          
ATOM    119  N   THR    32      16.877  11.821  23.176  1.00 14.65          
ATOM    120  CA  THR    32      15.503  11.539  23.586  1.00 15.36          
ATOM    121  CB  THR    32      15.364  11.361  25.108  1.00 16.65          
ATOM    122  OG1 THR    32      15.591  12.639  25.717  1.00 17.36          
ATOM    123  CG2 THR    32      16.382  10.322  25.647  1.00 17.30          
ATOM    124  C   THR    32      14.573  12.716  23.190  1.00 15.38          
ATOM    125  O   THR    32      15.050  13.855  22.940  1.00 14.06          
ATOM    126  N   GLU    33      13.258  12.450  23.183  1.00 14.24          
ATOM    127  CA  GLU    33      12.260  13.520  22.883  1.00 14.48          
ATOM    128  CB  GLU    33      10.818  12.945  22.826  1.00 14.49          
ATOM    129  CG  GLU    33      10.758  11.947  21.647  1.00 15.08          
ATOM    130  CD  GLU    33       9.589  11.017  21.658  1.00 20.43          
ATOM    131  OE1 GLU    33       9.465  10.195  22.610  1.00 18.09          
ATOM    132  OE2 GLU    33       8.822  11.067  20.664  1.00 15.52          
ATOM    133  C   GLU    33      12.368  14.686  23.855  1.00 13.92          
ATOM    134  O   GLU    33      12.319  15.860  23.477  1.00 15.48          
ATOM    135  N   ALA    34      12.634  14.358  25.124  1.00 15.71          
ATOM    136  CA  ALA    34      12.869  15.384  26.117  1.00 15.79          
ATOM    137  CB  ALA    34      13.024  14.704  27.493  1.00 16.80          
ATOM    138  C   ALA    34      14.082  16.251  25.812  1.00 16.09          
ATOM    139  O   ALA    34      14.020  17.481  25.973  1.00 16.84          
ATOM    140  N   GLU    35      15.178  15.620  25.374  1.00 14.28          
ATOM    141  CA  GLU    35      16.379  16.349  24.952  1.00 15.26          
ATOM    142  CB  GLU    35      17.493  15.423  24.540  1.00 16.06          
ATOM    143  CG  GLU    35      18.161  14.737  25.719  1.00 19.35          
ATOM    144  CD  GLU    35      19.350  13.919  25.263  1.00 23.91          
ATOM    145  OE1 GLU    35      20.495  14.486  25.253  1.00 26.50          
ATOM    146  OE2 GLU    35      19.123  12.746  24.865  1.00 18.96          
ATOM    147  C   GLU    35      16.089  17.304  23.795  1.00 14.99          
ATOM    148  O   GLU    35      16.563  18.426  23.788  1.00 16.05          
ATOM    149  N   PHE    36      15.356  16.846  22.780  1.00 14.36          
ATOM    150  CA  PHE    36      15.046  17.765  21.676  1.00 13.81          
ATOM    151  CB  PHE    36      14.157  17.062  20.646  1.00 13.87          
ATOM    152  CG  PHE    36      14.928  16.221  19.650  1.00 11.78          
ATOM    153  CD1 PHE    36      15.593  16.838  18.564  1.00 13.60          
ATOM    154  CE1 PHE    36      16.268  16.088  17.608  1.00 16.46          
ATOM    155  CZ  PHE    36      16.350  14.712  17.747  1.00 14.30          
ATOM    156  CE2 PHE    36      15.697  14.062  18.831  1.00 15.44          
ATOM    157  CD2 PHE    36      15.009  14.824  19.796  1.00 13.05          
ATOM    158  C   PHE    36      14.316  19.023  22.181  1.00 14.40          
ATOM    159  O   PHE    36      14.615  20.160  21.769  1.00 15.15          
ATOM    160  N   GLU    37      13.337  18.821  23.064  1.00 14.68          
ATOM    161  CA  GLU    37      12.519  19.938  23.539  1.00 16.98          
ATOM    162  CB  GLU    37      11.369  19.348  24.342  1.00 18.01          
ATOM    163  CG  GLU    37      10.554  20.275  25.186  1.00 23.72          
ATOM    164  CD  GLU    37       9.511  19.432  25.930  1.00 27.47          
ATOM    165  OE1 GLU    37       9.875  18.505  26.715  1.00 34.28          
ATOM    166  OE2 GLU    37       8.326  19.637  25.686  1.00 32.11          
ATOM    167  C   GLU    37      13.353  20.882  24.395  1.00 17.73          
ATOM    168  O   GLU    37      13.221  22.110  24.278  1.00 19.16          
ATOM    169  N   GLU    38      14.215  20.304  25.227  0.50 17.40          
ATOM    171  CA  GLU    38      15.017  21.091  26.162  0.50 18.23          
ATOM    173  CB  GLU    38      15.565  20.157  27.248  0.50 18.48          
ATOM    175  CG  GLU    38      14.397  19.465  27.945  0.50 19.51          
ATOM    177  CD  GLU    38      14.752  18.347  28.922  0.50 20.95          
ATOM    179  OE1 GLU    38      15.740  17.588  28.722  0.50 24.54          
ATOM    181  OE2 GLU    38      13.977  18.203  29.886  0.50 24.22          
ATOM    183  C   GLU    38      16.106  21.866  25.431  0.50 17.92          
ATOM    185  O   GLU    38      16.274  23.060  25.684  0.50 16.84          
ATOM    187  N   LYS    39      16.757  21.207  24.470  1.00 17.28          
ATOM    188  CA  LYS    39      17.989  21.691  23.846  1.00 17.97          
ATOM    189  CB  LYS    39      19.040  20.570  23.774  1.00 16.75          
ATOM    190  CG  LYS    39      19.539  20.174  25.181  1.00 21.18          
ATOM    191  CD  LYS    39      20.699  19.225  25.121  1.00 22.98          
ATOM    192  CE  LYS    39      20.254  17.826  24.989  1.00 28.16          
ATOM    193  NZ  LYS    39      21.361  16.889  25.421  1.00 30.17          
ATOM    194  C   LYS    39      17.814  22.320  22.470  1.00 18.83          
ATOM    195  O   LYS    39      18.809  22.770  21.898  1.00 20.38          
ATOM    196  N   CYS    40      16.586  22.387  21.953  1.00 19.36          
ATOM    197  CA  CYS    40      16.462  23.043  20.644  1.00 19.86          
ATOM    198  CB  CYS    40      15.131  22.798  19.977  1.00 22.27          
ATOM    199  SG  CYS    40      13.792  23.444  20.865  1.00 29.03          
ATOM    200  C   CYS    40      16.798  24.524  20.816  1.00 18.70          
ATOM    201  O   CYS    40      16.694  25.103  21.950  1.00 17.61          
ATOM    202  N   THR    41      17.254  25.112  19.720  1.00 16.83          
ATOM    203  CA  THR    41      17.712  26.515  19.746  1.00 17.06          
ATOM    204  CB  THR    41      19.047  26.718  18.979  1.00 18.27          
ATOM    205  OG1 THR    41      20.018  25.803  19.487  1.00 22.63          
ATOM    206  CG2 THR    41      19.593  28.145  19.188  1.00 19.10          
ATOM    207  C   THR    41      16.686  27.496  19.198  1.00 16.66          
ATOM    208  O   THR    41      16.436  28.548  19.839  1.00 16.75          
ATOM    209  N   TYR    42      16.088  27.162  18.045  1.00 12.87          
ATOM    210  CA  TYR    42      15.170  28.080  17.361  1.00 12.67          
ATOM    211  CB  TYR    42      15.607  28.309  15.890  1.00 13.10          
ATOM    212  CG  TYR    42      17.027  28.872  15.767  1.00 12.88          
ATOM    213  CD1 TYR    42      17.247  30.257  15.694  1.00 14.19          
ATOM    214  CE1 TYR    42      18.550  30.777  15.581  1.00 13.82          
ATOM    215  CZ  TYR    42      19.641  29.908  15.530  1.00 16.69          
ATOM    216  OH  TYR    42      20.930  30.424  15.398  1.00 18.81          
ATOM    217  CE2 TYR    42      19.442  28.543  15.597  1.00 15.36          
ATOM    218  CD2 TYR    42      18.128  28.017  15.730  1.00 15.71          
ATOM    219  C   TYR    42      13.798  27.427  17.295  1.00 13.11          
ATOM    220  O   TYR    42      13.751  26.216  17.068  1.00 14.24          
ATOM    221  N   ILE    43      12.752  28.223  17.469  1.00 11.01          
ATOM    222  CA  ILE    43      11.384  27.815  17.191  1.00 11.94          
ATOM    223  CB  ILE    43      10.519  27.980  18.452  1.00 12.47          
ATOM    224  CG1 ILE    43      11.012  27.001  19.532  1.00 15.69          
ATOM    225  CD  ILE    43      10.390  27.287  20.858  1.00 21.75          
ATOM    226  CG2 ILE    43       9.044  27.819  18.150  1.00 14.63          
ATOM    227  C   ILE    43      10.821  28.595  16.015  1.00 12.25          
ATOM    228  O   ILE    43      10.865  29.838  15.995  1.00 12.23          
ATOM    229  N   VAL    44      10.220  27.858  15.060  1.00 11.93          
ATOM    230  CA  VAL    44       9.515  28.443  13.933  1.00 13.56          
ATOM    231  CB  VAL    44      10.079  27.937  12.591  1.00 13.50          
ATOM    232  CG1 VAL    44       9.210  28.513  11.420  1.00 15.92          
ATOM    233  CG2 VAL    44      11.565  28.372  12.467  1.00 15.51          
ATOM    234  C   VAL    44       8.029  28.046  14.037  1.00 12.98          
ATOM    235  O   VAL    44       7.691  26.862  13.991  1.00 13.38          
ATOM    236  N   ASN    45       7.172  29.050  14.195  1.00 14.08          
ATOM    237  CA  ASN    45       5.726  28.822  14.157  1.00 15.60          
ATOM    238  CB  ASN    45       4.994  29.909  14.979  1.00 17.66          
ATOM    239  CG  ASN    45       5.453  29.940  16.430  1.00 21.37          
ATOM    240  OD1 ASN    45       5.853  30.988  16.960  1.00 29.92          
ATOM    241  ND2 ASN    45       5.385  28.826  17.067  1.00 20.39          
ATOM    242  C   ASN    45       5.206  28.826  12.726  1.00 15.77          
ATOM    243  O   ASN    45       5.837  29.398  11.821  1.00 16.24          
ATOM    244  N   ASP    46       4.033  28.202  12.527  1.00 15.84          
ATOM    245  CA  ASP    46       3.355  28.262  11.235  1.00 16.26          
ATOM    246  CB  ASP    46       2.035  27.483  11.295  1.00 15.83          
ATOM    247  CG  ASP    46       2.239  25.960  11.339  1.00 18.14          
ATOM    248  OD1 ASP    46       3.421  25.457  11.333  1.00 14.65          
ATOM    249  OD2 ASP    46       1.177  25.267  11.376  1.00 19.23          
ATOM    250  C   ASP    46       3.036  29.699  10.860  1.00 18.28          
ATOM    251  O   ASP    46       2.896  30.583  11.732  1.00 17.17          
ATOM    252  N   HSD    47       2.938  29.925   9.556  1.00 19.20          
ATOM    253  CA  HSD    47       2.459  31.198   9.048  1.00 23.44          
ATOM    254  CB  HSD    47       2.523  31.192   7.519  1.00 22.82          
ATOM    255  CG  HSD    47       2.537  32.564   6.912  1.00 28.42          
ATOM    256  ND1 HSD    47       1.427  33.379   6.906  1.00 31.75          
ATOM    257  CE1 HSD    47       1.728  34.525   6.316  1.00 33.30          
ATOM    258  NE2 HSD    47       2.994  34.482   5.943  1.00 32.97          
ATOM    259  CD2 HSD    47       3.524  33.266   6.300  1.00 31.82          
ATOM    260  C   HSD    47       1.022  31.409   9.524  1.00 26.19          
ATOM    261  O   HSD    47       0.193  30.500   9.450  1.00 26.23          
ATOM    262  N   PRO    48       0.719  32.609  10.049  1.00 31.08          
ATOM    263  CA  PRO    48      -0.696  32.829  10.326  1.00 34.22          
ATOM    264  CB  PRO    48      -0.700  34.003  11.315  1.00 34.52          
ATOM    265  CG  PRO    48       0.675  34.633  11.239  1.00 33.47          
ATOM    266  CD  PRO    48       1.581  33.744  10.418  1.00 31.00          
ATOM    267  C   PRO    48      -1.420  33.194   9.018  1.00 37.08          
ATOM    268  O   PRO    48      -0.911  34.043   8.278  1.00 38.33          
ATOM    269  N   TRP    49      -2.518  32.508   8.677  1.00 40.00          
ATOM    270  CA  TRP    49      -2.912  31.232   9.308  1.00 42.35          
ATOM    271  CB  TRP    49      -3.776  31.469  10.562  1.00 42.82          
ATOM    281  C   TRP    49      -3.609  30.226   8.352  1.00 43.56          
ATOM    282  O   TRP    49      -3.391  29.001   8.449  1.00 44.42          
ATOM    283  N   ASP    50      -4.416  30.755   7.432  1.00 44.30          
ATOM    284  CA  ASP    50      -5.542  30.026   6.803  1.00 44.39          
ATOM    285  CB  ASP    50      -5.526  30.158   5.276  1.00 44.42          
ATOM    289  C   ASP    50      -5.769  28.573   7.240  1.00 44.61          
ATOM    290  O   ASP    50      -6.798  27.968   6.900  1.00 44.49          
ATOM    291  N   VAL    59      -5.927  27.135   1.045  1.00 26.15          
ATOM    292  CA  VAL    59      -6.207  26.019   1.934  1.00 25.10          
ATOM    293  CB  VAL    59      -6.274  24.693   1.139  1.00 26.39          
ATOM    294  CG1 VAL    59      -4.953  24.311   0.581  1.00 27.69          
ATOM    295  CG2 VAL    59      -6.803  23.602   1.990  1.00 29.51          
ATOM    296  C   VAL    59      -5.174  25.938   3.082  1.00 23.55          
ATOM    297  O   VAL    59      -4.000  26.283   2.865  1.00 21.72          
ATOM    298  N   GLN    60      -5.614  25.476   4.257  1.00 21.01          
ATOM    299  CA  GLN    60      -4.779  25.460   5.454  1.00 20.78          
ATOM    300  CB  GLN    60      -5.455  24.766   6.634  1.00 20.80          
ATOM    301  CG  GLN    60      -4.588  24.842   7.884  1.00 23.84          
ATOM    302  CD  GLN    60      -5.248  24.287   9.135  1.00 28.68          
ATOM    303  OE1 GLN    60      -6.307  23.636   9.087  1.00 29.66          
ATOM    304  NE2 GLN    60      -4.607  24.517  10.257  1.00 30.78          
ATOM    305  C   GLN    60      -3.430  24.813   5.229  1.00 19.39          
ATOM    306  O   GLN    60      -2.402  25.369   5.684  1.00 19.88          
ATOM    307  N   ALA    61      -3.391  23.638   4.583  1.00 17.44          
ATOM    308  CA  ALA    61      -2.100  22.951   4.428  1.00 18.20          
ATOM    309  CB  ALA    61      -2.275  21.589   3.799  1.00 17.98          
ATOM    310  C   ALA    61      -1.043  23.780   3.661  1.00 17.28          
ATOM    311  O   ALA    61       0.166  23.668   3.919  1.00 17.04          
ATOM    312  N   GLU    62      -1.494  24.569   2.686  1.00 17.87          
ATOM    313  CA  GLU    62      -0.578  25.436   1.963  1.00 18.97          
ATOM    314  CB  GLU    62      -1.120  25.732   0.588  1.00 19.00          
ATOM    315  CG  GLU    62      -0.985  24.572  -0.319  1.00 24.17          
ATOM    316  CD  GLU    62      -1.560  24.881  -1.682  1.00 33.12          
ATOM    317  OE1 GLU    62      -2.285  25.919  -1.834  1.00 36.40          
ATOM    318  OE2 GLU    62      -1.270  24.076  -2.586  1.00 35.12          
ATOM    319  C   GLU    62      -0.321  26.765   2.668  1.00 18.29          
ATOM    320  O   GLU    62       0.851  27.193   2.742  1.00 19.29          
ATOM    321  N   ALA    63      -1.390  27.420   3.135  1.00 18.06          
ATOM    322  CA  ALA    63      -1.314  28.751   3.751  1.00 18.44          
ATOM    323  CB  ALA    63      -2.721  29.311   4.025  1.00 19.44          
ATOM    324  C   ALA    63      -0.468  28.808   5.023  1.00 17.52          
ATOM    325  O   ALA    63       0.049  29.876   5.396  1.00 18.37          
ATOM    326  N   SER    64      -0.361  27.660   5.696  1.00 15.71          
ATOM    327  CA  SER    64       0.334  27.577   6.993  1.00 15.68          
ATOM    328  CB  SER    64      -0.180  26.369   7.778  1.00 14.33          
ATOM    329  OG  SER    64       0.087  25.144   7.095  1.00 14.10          
ATOM    330  C   SER    64       1.843  27.496   6.857  1.00 14.57          
ATOM    331  O   SER    64       2.543  27.568   7.861  1.00 13.79          
ATOM    332  N   LEU    65       2.364  27.346   5.631  1.00 14.87          
ATOM    333  CA  LEU    65       3.786  27.096   5.430  1.00 15.15          
ATOM    334  CB  LEU    65       4.104  26.936   3.932  1.00 14.80          
ATOM    335  CG  LEU    65       5.575  26.586   3.636  1.00 15.36          
ATOM    336  CD1 LEU    65       5.848  25.132   4.056  1.00 13.77          
ATOM    337  CD2 LEU    65       5.877  26.755   2.136  1.00 17.23          
ATOM    338  C   LEU    65       4.590  28.303   5.943  1.00 15.05          
ATOM    339  O   LEU    65       4.340  29.452   5.495  1.00 15.23          
ATOM    340  N   PRO    66       5.552  28.081   6.854  1.00 15.76          
ATOM    341  CA  PRO    66       6.399  29.154   7.410  1.00 17.02          
ATOM    342  CB  PRO    66       7.371  28.408   8.342  1.00 17.30          
ATOM    343  CG  PRO    66       6.800  27.128   8.570  1.00 17.27          
ATOM    344  CD  PRO    66       5.793  26.788   7.514  1.00 15.70          
ATOM    345  C   PRO    66       7.187  29.915   6.323  1.00 17.35          
ATOM    346  O   PRO    66       7.545  29.332   5.280  1.00 17.10          
ATOM    347  N   ARG    67       7.430  31.207   6.582  1.00 18.77          
ATOM    348  CA  ARG    67       8.086  32.079   5.572  1.00 20.15          
ATOM    349  CB  ARG    67       8.061  33.570   6.003  1.00 21.02          
ATOM    350  CG  ARG    67       8.787  33.825   7.286  1.00 22.69          
ATOM    351  CD  ARG    67       8.447  35.209   7.927  1.00 26.34          
ATOM    352  NE  ARG    67       8.029  36.247   6.979  1.00 36.41          
ATOM    353  CZ  ARG    67       8.633  37.432   6.795  1.00 41.68          
ATOM    354  NH1 ARG    67       9.708  37.786   7.506  1.00 44.31          
ATOM    355  NH2 ARG    67       8.144  38.291   5.905  1.00 42.68          
ATOM    356  C   ARG    67       9.517  31.670   5.173  1.00 18.74          
ATOM    357  O   ARG    67      10.043  32.182   4.173  1.00 19.89          
ATOM    358  N   ASN    68      10.163  30.800   5.940  1.00 15.37          
ATOM    359  CA  ASN    68      11.514  30.325   5.590  1.00 14.50          
ATOM    360  CB  ASN    68      12.399  30.122   6.833  1.00 15.41          
ATOM    361  CG  ASN    68      11.789  29.172   7.860  1.00 14.32          
ATOM    362  OD1 ASN    68      10.602  28.850   7.813  1.00 16.59          
ATOM    363  ND2 ASN    68      12.619  28.727   8.811  1.00 18.03          
ATOM    364  C   ASN    68      11.526  29.048   4.707  1.00 14.25          
ATOM    365  O   ASN    68      12.583  28.491   4.429  1.00 13.94          
ATOM    366  N   LEU    69      10.337  28.629   4.295  1.00 14.61          
ATOM    367  CA  LEU    69      10.167  27.403   3.458  1.00 13.42          
ATOM    368  CB  LEU    69       9.382  26.315   4.247  1.00 14.11          
ATOM    369  CG  LEU    69      10.015  25.935   5.609  1.00 11.97          
ATOM    370  CD1 LEU    69       9.077  24.914   6.305  1.00 13.08          
ATOM    371  CD2 LEU    69      11.416  25.379   5.473  1.00 13.82          
ATOM    372  C   LEU    69       9.413  27.720   2.164  1.00 14.14          
ATOM    373  O   LEU    69       8.700  28.745   2.048  1.00 14.04          
ATOM    374  N   LEU    70       9.554  26.806   1.199  1.00 13.81          
ATOM    375  CA  LEU    70       8.808  26.870  -0.065  1.00 16.55          
ATOM    376  CB  LEU    70       9.755  27.326  -1.193  1.00 17.65          
ATOM    377  CG  LEU    70      10.059  28.801  -1.268  1.00 24.52          
ATOM    378  CD1 LEU    70      11.290  28.953  -2.195  1.00 28.31          
ATOM    379  CD2 LEU    70       8.833  29.622  -1.755  1.00 28.72          
ATOM    380  C   LEU    70       8.382  25.468  -0.384  1.00 15.79          
ATOM    381  O   LEU    70       9.022  24.503   0.058  1.00 15.09          
ATOM    382  N   PHE    71       7.353  25.348  -1.202  1.00 14.97          
ATOM    383  CA  PHE    71       6.945  24.014  -1.698  1.00 14.95          
ATOM    384  CB  PHE    71       5.450  23.996  -2.033  1.00 16.13          
ATOM    385  CG  PHE    71       4.576  24.033  -0.806  1.00 16.21          
ATOM    386  CD1 PHE    71       4.756  23.058   0.186  1.00 17.25          
ATOM    387  CE1 PHE    71       3.958  23.057   1.353  1.00 14.53          
ATOM    388  CZ  PHE    71       2.975  24.023   1.523  1.00 16.25          
ATOM    389  CE2 PHE    71       2.787  25.043   0.541  1.00 17.53          
ATOM    390  CD2 PHE    71       3.611  25.039  -0.622  1.00 16.03          
ATOM    391  C   PHE    71       7.751  23.598  -2.904  1.00 16.05          
ATOM    392  O   PHE    71       8.185  24.461  -3.686  1.00 16.42          
ATOM    393  N   LYS    72       7.947  22.295  -3.058  0.50 15.73          
ATOM    395  CA  LYS    72       8.436  21.711  -4.293  0.50 16.54          
ATOM    397  CB  LYS    72       9.409  20.564  -3.990  0.50 16.75          
ATOM    399  CG  LYS    72       9.779  19.733  -5.217  0.50 17.42          
ATOM    401  CD  LYS    72      10.834  18.671  -4.952  0.50 18.55          
ATOM    403  CE  LYS    72      10.335  17.507  -4.133  0.50 24.08          
ATOM    405  NZ  LYS    72      11.177  16.300  -4.423  0.50 25.83          
ATOM    407  C   LYS    72       7.219  21.179  -5.042  0.50 15.93          
ATOM    409  O   LYS    72       6.388  20.461  -4.463  0.50 14.18          
ATOM    411  N   TYR    73       7.141  21.516  -6.333  1.00 16.47          
ATOM    412  CA  TYR    73       5.971  21.229  -7.167  1.00 16.86          
ATOM    413  CB  TYR    73       5.430  22.499  -7.835  1.00 17.70          
ATOM    414  CG  TYR    73       4.954  23.552  -6.873  1.00 16.61          
ATOM    415  CD1 TYR    73       3.645  23.533  -6.369  1.00 17.63          
ATOM    416  CE1 TYR    73       3.221  24.484  -5.462  1.00 19.28          
ATOM    417  CZ  TYR    73       4.136  25.473  -5.051  1.00 19.77          
ATOM    418  OH  TYR    73       3.770  26.440  -4.153  1.00 21.63          
ATOM    419  CE2 TYR    73       5.438  25.479  -5.515  1.00 19.30          
ATOM    420  CD2 TYR    73       5.836  24.521  -6.418  1.00 19.07          
ATOM    421  C   TYR    73       6.315  20.212  -8.233  1.00 17.00          
ATOM    422  O   TYR    73       7.439  20.195  -8.727  1.00 17.19          
ATOM    423  N   ALA    74       5.334  19.393  -8.596  1.00 16.13          
ATOM    424  CA  ALA    74       5.465  18.515  -9.747  1.00 16.27          
ATOM    425  CB  ALA    74       4.254  17.604  -9.866  1.00 17.32          
ATOM    426  C   ALA    74       5.662  19.380 -10.999  1.00 15.25          
ATOM    427  O   ALA    74       5.206  20.523 -11.077  1.00 16.03          
ATOM    428  N   THR    75       6.435  18.841 -11.922  1.00 16.05          
ATOM    429  CA  THR    75       6.798  19.592 -13.124  1.00 16.60          
ATOM    430  CB  THR    75       7.687  18.708 -14.018  1.00 16.95          
ATOM    431  OG1 THR    75       8.863  18.346 -13.269  1.00 19.26          
ATOM    432  CG2 THR    75       8.133  19.490 -15.279  1.00 17.73          
ATOM    433  C   THR    75       5.545  20.047 -13.893  1.00 16.42          
ATOM    434  O   THR    75       4.630  19.241 -14.115  1.00 17.08          
ATOM    435  N   ASN    76       5.554  21.315 -14.306  1.00 16.48          
ATOM    436  CA  ASN    76       4.437  21.942 -15.048  1.00 17.36          
ATOM    437  CB  ASN    76       4.255  21.262 -16.406  1.00 18.02          
ATOM    438  CG  ASN    76       5.499  21.311 -17.258  1.00 16.87          
ATOM    439  OD1 ASN    76       6.321  22.211 -17.100  1.00 19.69          
ATOM    440  ND2 ASN    76       5.648  20.322 -18.140  1.00 17.68          
ATOM    441  C   ASN    76       3.102  21.855 -14.287  1.00 18.91          
ATOM    442  O   ASN    76       2.031  21.749 -14.900  1.00 19.80          
ATOM    443  N   SER    77       3.148  21.880 -12.958  1.00 18.81          
ATOM    444  CA  SER    77       1.935  21.544 -12.188  1.00 20.90          
ATOM    445  CB  SER    77       2.005  20.067 -11.784  1.00 21.55          
ATOM    446  OG  SER    77       0.913  19.637 -10.986  1.00 25.81          
ATOM    447  C   SER    77       1.924  22.410 -10.945  1.00 21.23          
ATOM    448  O   SER    77       2.944  22.991 -10.576  1.00 21.33          
ATOM    449  N   GLU    78       0.748  22.497 -10.319  1.00 20.85          
ATOM    450  CA  GLU    78       0.602  23.249  -9.053  1.00 22.23          
ATOM    451  CB  GLU    78      -0.607  24.211  -9.127  1.00 23.52          
ATOM    452  CG  GLU    78      -0.308  25.500  -9.926  1.00 25.99          
ATOM    456  C   GLU    78       0.501  22.232  -7.908  1.00 22.37          
ATOM    457  O   GLU    78       0.320  22.606  -6.732  1.00 23.29          
ATOM    458  N   GLU    79       0.687  20.962  -8.248  1.00 20.86          
ATOM    459  CA  GLU    79       0.692  19.890  -7.258  1.00 21.19          
ATOM    460  CB  GLU    79       0.560  18.521  -7.930  1.00 20.46          
ATOM    461  CG  GLU    79       0.421  17.349  -6.918  1.00 25.17          
ATOM    462  CD  GLU    79       0.689  15.928  -7.497  1.00 27.51          
ATOM    463  OE1 GLU    79       1.138  15.780  -8.672  1.00 34.41          
ATOM    464  OE2 GLU    79       0.452  14.937  -6.748  1.00 33.89          
ATOM    465  C   GLU    79       1.963  19.957  -6.383  1.00 19.67          
ATOM    466  O   GLU    79       3.086  19.914  -6.875  1.00 18.93          
ATOM    467  N   VAL    80       1.762  20.048  -5.066  1.00 18.30          
ATOM    468  CA  VAL    80       2.881  19.990  -4.117  1.00 17.49          
ATOM    469  CB  VAL    80       2.451  20.578  -2.737  1.00 17.83          
ATOM    470  CG1 VAL    80       3.622  20.422  -1.736  1.00 18.43          
ATOM    471  CG2 VAL    80       1.980  22.023  -2.898  1.00 17.44          
ATOM    472  C   VAL    80       3.404  18.572  -3.906  1.00 17.20          
ATOM    473  O   VAL    80       2.594  17.623  -3.645  1.00 17.99          
ATOM    474  N   ILE    81       4.719  18.404  -4.016  1.00 16.20          
ATOM    475  CA  ILE    81       5.324  17.100  -3.862  1.00 17.33          
ATOM    476  CB  ILE    81       5.787  16.501  -5.201  1.00 17.88          
ATOM    477  CG1 ILE    81       6.922  17.342  -5.785  1.00 20.06          
ATOM    478  CD  ILE    81       7.566  16.740  -7.048  1.00 19.02          
ATOM    479  CG2 ILE    81       4.560  16.348  -6.155  1.00 18.54          
ATOM    480  C   ILE    81       6.430  16.999  -2.799  1.00 16.82          
ATOM    481  O   ILE    81       7.078  15.991  -2.705  1.00 19.47          
ATOM    482  N   GLY    82       6.649  18.081  -2.042  1.00 15.25          
ATOM    483  CA  GLY    82       7.653  18.096  -0.990  1.00 14.34          
ATOM    484  C   GLY    82       7.784  19.520  -0.475  1.00 13.70          
ATOM    485  O   GLY    82       7.075  20.464  -0.907  1.00 14.62          
ATOM    486  N   VAL    83       8.687  19.656   0.509  1.00 12.84          
ATOM    487  CA  VAL    83       8.967  20.955   1.112  1.00 12.53          
ATOM    488  CB  VAL    83       8.491  21.028   2.587  1.00 12.20          
ATOM    489  CG1 VAL    83       8.692  22.495   3.092  1.00 13.29          
ATOM    490  CG2 VAL    83       7.003  20.630   2.708  1.00 12.24          
ATOM    491  C   VAL    83      10.467  21.239   1.059  1.00 12.63          
ATOM    492  O   VAL    83      11.277  20.333   1.358  1.00 12.49          
ATOM    493  N   MET    84      10.833  22.478   0.686  1.00 14.04          
ATOM    494  CA  MET    84      12.234  22.904   0.554  1.00 14.40          
ATOM    495  CB  MET    84      12.531  23.401  -0.890  1.00 16.25          
ATOM    496  CG  MET    84      11.858  22.618  -1.952  1.00 21.35          
ATOM    497  SD  MET    84      12.742  21.089  -2.146  1.00 27.24          
ATOM    498  CE  MET    84      14.342  21.548  -2.854  1.00 27.88          
ATOM    499  C   MET    84      12.499  24.087   1.459  1.00 13.20          
ATOM    500  O   MET    84      11.574  24.847   1.818  1.00 14.32          
ATOM    501  N   SER    85      13.763  24.287   1.809  1.00 14.02          
ATOM    502  CA  SER    85      14.136  25.507   2.522  1.00 14.15          
ATOM    503  CB  SER    85      15.511  25.346   3.167  1.00 15.63          
ATOM    504  OG  SER    85      16.420  24.974   2.151  1.00 17.63          
ATOM    505  C   SER    85      14.163  26.702   1.524  1.00 15.94          
ATOM    506  O   SER    85      14.564  26.520   0.371  1.00 16.77          
ATOM    507  N   LYS    86      13.701  27.872   1.953  1.00 16.35          
ATOM    508  CA  LYS    86      13.855  29.132   1.185  1.00 17.71          
ATOM    509  CB  LYS    86      12.744  30.092   1.568  1.00 17.93          
ATOM    510  CG  LYS    86      12.433  31.201   0.557  1.00 23.49          
ATOM    511  CD  LYS    86      10.951  31.515   0.645  1.00 29.93          
ATOM    512  CE  LYS    86      10.662  32.888   1.106  1.00 35.77          
ATOM    513  NZ  LYS    86      10.117  33.624  -0.084  1.00 39.08          
ATOM    514  C   LYS    86      15.196  29.818   1.461  1.00 18.54          
ATOM    515  O   LYS    86      15.670  30.657   0.651  1.00 20.66          
ATOM    516  N   GLU    87      15.803  29.463   2.588  1.00 17.63          
ATOM    517  CA  GLU    87      16.966  30.131   3.156  1.00 18.40          
ATOM    518  CB  GLU    87      16.474  31.306   4.021  1.00 18.33          
ATOM    519  CG  GLU    87      15.611  30.855   5.216  1.00 19.93          
ATOM    520  CD  GLU    87      15.027  32.041   5.985  1.00 21.76          
ATOM    521  OE1 GLU    87      15.405  32.168   7.179  1.00 24.58          
ATOM    522  OE2 GLU    87      14.236  32.832   5.400  1.00 24.56          
ATOM    523  C   GLU    87      17.686  29.100   4.029  1.00 17.31          
ATOM    524  O   GLU    87      17.171  27.981   4.236  1.00 17.58          
ATOM    525  N   TYR    88      18.859  29.444   4.547  1.00 16.95          
ATOM    526  CA  TYR    88      19.611  28.553   5.426  1.00 16.85          
ATOM    527  CB  TYR    88      20.938  29.217   5.769  1.00 18.31          
ATOM    528  CG  TYR    88      21.820  28.437   6.700  1.00 18.55          
ATOM    529  CD1 TYR    88      22.704  27.469   6.220  1.00 20.39          
ATOM    530  CE1 TYR    88      23.528  26.747   7.098  1.00 19.51          
ATOM    531  CZ  TYR    88      23.461  27.020   8.463  1.00 21.32          
ATOM    532  OH  TYR    88      24.251  26.354   9.381  1.00 22.99          
ATOM    533  CE2 TYR    88      22.598  27.961   8.951  1.00 21.74          
ATOM    534  CD2 TYR    88      21.780  28.677   8.064  1.00 21.32          
ATOM    535  C   TYR    88      18.800  28.352   6.715  1.00 16.15          
ATOM    536  O   TYR    88      18.456  29.334   7.390  1.00 17.34          
ATOM    537  N   ILE    89      18.505  27.098   7.040  0.50 15.14          
ATOM    539  CA  ILE    89      17.796  26.794   8.289  0.50 14.38          
ATOM    541  CB  ILE    89      16.600  25.853   8.086  0.50 13.69          
ATOM    543  CG1 ILE    89      15.698  26.346   6.941  0.50 14.60          
ATOM    545  CD  ILE    89      14.570  25.428   6.652  0.50 15.43          
ATOM    547  CG2 ILE    89      15.840  25.722   9.429  0.50 13.55          
ATOM    549  C   ILE    89      18.785  26.177   9.266  0.50 13.94          
ATOM    551  O   ILE    89      19.391  25.127   8.985  0.50 14.27          
ATOM    553  N   PRO    90      18.991  26.835  10.417  1.00 14.31          
ATOM    554  CA  PRO    90      19.989  26.315  11.356  1.00 14.56          
ATOM    555  CB  PRO    90      19.937  27.324  12.523  1.00 16.05          
ATOM    556  CG  PRO    90      19.348  28.545  11.927  1.00 14.96          
ATOM    557  CD  PRO    90      18.373  28.088  10.894  1.00 14.78          
ATOM    558  C   PRO    90      19.661  24.927  11.917  1.00 14.71          
ATOM    559  O   PRO    90      18.469  24.543  12.018  1.00 14.88          
ATOM    560  N   LYS    91      20.705  24.187  12.312  1.00 14.72          
ATOM    561  CA  LYS    91      20.500  22.969  13.141  1.00 14.58          
ATOM    562  CB  LYS    91      21.870  22.407  13.522  1.00 15.71          
ATOM    563  CG  LYS    91      21.877  21.118  14.283  1.00 15.58          
ATOM    564  CD  LYS    91      23.349  20.651  14.409  1.00 17.28          
ATOM    565  CE  LYS    91      23.484  19.497  15.377  1.00 22.55          
ATOM    566  NZ  LYS    91      24.851  18.916  15.283  1.00 22.53          
ATOM    567  C   LYS    91      19.785  23.346  14.434  1.00 15.49          
ATOM    568  O   LYS    91      19.988  24.445  14.965  1.00 16.19          
ATOM    569  N   GLY    92      18.949  22.438  14.946  1.00 13.05          
ATOM    570  CA  GLY    92      18.282  22.730  16.214  1.00 12.66          
ATOM    571  C   GLY    92      17.103  23.683  16.080  1.00 13.78          
ATOM    572  O   GLY    92      16.811  24.436  17.014  1.00 15.12          
ATOM    573  N   THR    93      16.387  23.614  14.948  1.00 11.99          
ATOM    574  CA  THR    93      15.207  24.438  14.714  1.00 11.70          
ATOM    575  CB  THR    93      15.250  25.063  13.296  1.00 11.96          
ATOM    576  OG1 THR    93      16.375  25.929  13.175  1.00 12.00          
ATOM    577  CG2 THR    93      13.947  25.794  12.962  1.00 12.31          
ATOM    578  C   THR    93      13.962  23.531  14.826  1.00 12.95          
ATOM    579  O   THR    93      13.924  22.481  14.202  1.00 13.33          
ATOM    580  N   ARG    94      12.978  23.975  15.577  1.00 11.99          
ATOM    581  CA  ARG    94      11.729  23.209  15.744  1.00 11.16          
ATOM    582  CB  ARG    94      11.239  23.291  17.191  1.00 11.03          
ATOM    583  CG  ARG    94      10.093  22.337  17.452  1.00 12.73          
ATOM    584  CD  ARG    94       9.397  22.718  18.775  1.00 12.62          
ATOM    585  NE  ARG    94       8.467  23.823  18.575  1.00 12.88          
ATOM    586  CZ  ARG    94       7.756  24.398  19.546  1.00 15.88          
ATOM    587  NH1 ARG    94       7.935  23.990  20.822  1.00 17.05          
ATOM    588  NH2 ARG    94       6.892  25.355  19.255  1.00 16.72          
ATOM    589  C   ARG    94      10.623  23.786  14.846  1.00 11.67          
ATOM    590  O   ARG    94      10.381  25.005  14.820  1.00 12.02          
ATOM    591  N   PHE    95       9.953  22.899  14.109  1.00  9.96          
ATOM    592  CA  PHE    95       8.726  23.188  13.368  1.00 11.29          
ATOM    593  CB  PHE    95       8.875  22.662  11.927  1.00 10.89          
ATOM    594  CG  PHE    95       9.935  23.438  11.148  1.00 11.90          
ATOM    595  CD1 PHE    95       9.612  24.672  10.566  1.00 10.68          
ATOM    596  CE1 PHE    95      10.604  25.398   9.852  1.00 12.46          
ATOM    597  CZ  PHE    95      11.882  24.881   9.704  1.00 12.83          
ATOM    598  CE2 PHE    95      12.236  23.660  10.299  1.00 16.34          
ATOM    599  CD2 PHE    95      11.221  22.928  11.016  1.00 13.85          
ATOM    600  C   PHE    95       7.558  22.442  14.004  1.00 11.18          
ATOM    601  O   PHE    95       7.742  21.305  14.558  1.00 10.62          
ATOM    602  N   GLY    96       6.376  23.039  13.887  1.00 11.84          
ATOM    603  CA  GLY    96       5.212  22.365  14.370  1.00 12.80          
ATOM    604  C   GLY    96       4.491  23.215  15.385  1.00 13.65          
ATOM    605  O   GLY    96       4.883  24.378  15.627  1.00 13.94          
ATOM    606  N   PRO    97       3.454  22.638  16.013  1.00 13.15          
ATOM    607  CA  PRO    97       3.098  21.231  15.993  1.00 12.40          
ATOM    608  CB  PRO    97       2.095  21.087  17.179  1.00 13.91          
ATOM    609  CG  PRO    97       1.437  22.477  17.240  1.00 15.24          
ATOM    610  CD  PRO    97       2.583  23.464  16.879  1.00 12.75          
ATOM    611  C   PRO    97       2.372  20.813  14.686  1.00 12.60          
ATOM    612  O   PRO    97       1.772  21.653  13.985  1.00 12.07          
ATOM    613  N   LEU    98       2.395  19.525  14.401  0.50 11.70          
ATOM    615  CA  LEU    98       1.549  18.973  13.367  0.50 11.62          
ATOM    617  CB  LEU    98       1.704  17.459  13.340  0.50 10.71          
ATOM    619  CG  LEU    98       0.899  16.722  12.260  0.50 10.41          
ATOM    621  CD1 LEU    98       0.922  15.218  12.501  0.50 11.83          
ATOM    623  CD2 LEU    98       1.503  17.052  10.925  0.50  7.02          
ATOM    625  C   LEU    98       0.078  19.334  13.653  0.50 11.39          
ATOM    627  O   LEU    98      -0.371  19.333  14.809  0.50 10.54          
ATOM    629  N   ILE    99      -0.659  19.627  12.592  0.50 12.83          
ATOM    631  CA  ILE    99      -2.111  19.755  12.674  0.50 13.21          
ATOM    633  CB  ILE    99      -2.592  21.183  12.386  0.50 13.27          
ATOM    635  CG1 ILE    99      -1.934  22.215  13.318  0.50 14.94          
ATOM    637  CD  ILE    99      -2.230  23.645  12.943  0.50 12.88          
ATOM    639  CG2 ILE    99      -4.120  21.271  12.483  0.50 14.70          
ATOM    641  C   ILE    99      -2.746  18.786  11.647  0.50 14.16          
ATOM    643  O   ILE    99      -2.300  18.712  10.478  0.50 12.98          
ATOM    645  N   GLY   100      -3.754  18.041  12.109  1.00 15.37          
ATOM    646  CA  GLY   100      -4.553  17.138  11.280  1.00 15.82          
ATOM    647  C   GLY   100      -5.812  16.699  12.029  1.00 17.98          
ATOM    648  O   GLY   100      -6.031  17.056  13.189  1.00 17.57          
ATOM    649  N   GLU   101      -6.638  15.952  11.340  1.00 19.46          
ATOM    650  CA  GLU   101      -7.813  15.344  12.013  1.00 19.71          
ATOM    651  CB  GLU   101      -8.753  14.735  10.983  1.00 20.68          
ATOM    652  CG  GLU   101      -9.311  15.782  10.083  1.00 25.97          
ATOM    653  CD  GLU   101     -10.287  15.171   9.132  1.00 35.44          
ATOM    654  OE1 GLU   101      -9.834  14.602   8.106  1.00 36.71          
ATOM    655  OE2 GLU   101     -11.508  15.243   9.438  1.00 39.39          
ATOM    656  C   GLU   101      -7.369  14.291  12.973  1.00 20.04          
ATOM    657  O   GLU   101      -6.392  13.576  12.714  1.00 20.89          
ATOM    658  N   ILE   102      -8.059  14.171  14.107  0.50 19.71          
ATOM    660  CA  ILE   102      -7.649  13.208  15.135  0.50 20.08          
ATOM    662  CB  ILE   102      -7.413  13.880  16.513  0.50 20.37          
ATOM    664  CG1 ILE   102      -6.132  14.717  16.498  0.50 19.29          
ATOM    666  CD  ILE   102      -5.988  15.628  17.727  0.50 19.88          
ATOM    668  CG2 ILE   102      -7.296  12.824  17.619  0.50 19.99          
ATOM    670  C   ILE   102      -8.670  12.088  15.298  0.50 20.97          
ATOM    672  O   ILE   102      -9.860  12.362  15.505  0.50 19.82          
ATOM    674  N   TYR   103      -8.179  10.853  15.195  1.00 21.95          
ATOM    675  CA  TYR   103      -8.993   9.624  15.280  1.00 24.99          
ATOM    676  CB  TYR   103      -8.947   8.863  13.963  1.00 25.47          
ATOM    677  CG  TYR   103      -9.443   9.641  12.769  1.00 27.85          
ATOM    678  CD1 TYR   103     -10.756  10.119  12.729  1.00 28.34          
ATOM    679  CE1 TYR   103     -11.241  10.842  11.621  1.00 30.15          
ATOM    680  CZ  TYR   103     -10.413  11.104  10.550  1.00 30.42          
ATOM    681  OH  TYR   103     -10.928  11.826   9.474  1.00 31.71          
ATOM    682  CE2 TYR   103      -9.087  10.642  10.554  1.00 28.30          
ATOM    683  CD2 TYR   103      -8.611   9.901  11.669  1.00 25.95          
ATOM    684  C   TYR   103      -8.504   8.738  16.413  1.00 27.26          
ATOM    685  O   TYR   103      -7.316   8.699  16.718  1.00 25.00          
ATOM    686  N   THR   104      -9.428   8.038  17.078  1.00 30.44          
ATOM    687  CA  THR   104      -9.015   6.942  17.967  1.00 33.84          
ATOM    688  CB  THR   104      -9.678   6.957  19.395  1.00 34.84          
ATOM    689  OG1 THR   104     -11.098   7.106  19.282  1.00 36.75          
ATOM    690  CG2 THR   104      -9.126   8.072  20.265  1.00 34.23          
ATOM    691  C   THR   104      -9.338   5.671  17.199  1.00 36.05          
ATOM    692  O   THR   104      -9.898   5.745  16.097  1.00 36.90          
ATOM    693  N   ASN   105      -8.959   4.511  17.735  1.00 38.27          
ATOM    694  CA  ASN   105      -9.385   3.246  17.138  1.00 40.33          
ATOM    695  CB  ASN   105      -8.815   2.062  17.918  1.00 40.37          
ATOM    696  CG  ASN   105      -7.322   1.879  17.683  1.00 42.21          
ATOM    697  OD1 ASN   105      -6.874   1.689  16.541  1.00 41.64          
ATOM    698  ND2 ASN   105      -6.541   1.939  18.767  1.00 44.10          
ATOM    699  C   ASN   105     -10.912   3.191  17.067  1.00 41.03          
ATOM    700  O   ASN   105     -11.471   2.744  16.070  1.00 41.90          
ATOM    701  N   ASP   106     -11.566   3.706  18.114  1.00 42.59          
ATOM    702  CA  ASP   106     -13.036   3.777  18.206  1.00 43.41          
ATOM    703  CB  ASP   106     -13.463   4.107  19.654  1.00 44.41          
ATOM    704  CG  ASP   106     -13.584   2.866  20.540  1.00 46.20          
ATOM    705  OD1 ASP   106     -13.138   1.766  20.136  1.00 48.97          
ATOM    706  OD2 ASP   106     -14.138   2.999  21.646  1.00 47.28          
ATOM    707  C   ASP   106     -13.736   4.765  17.261  1.00 43.26          
ATOM    708  O   ASP   106     -14.971   4.726  17.160  1.00 44.00          
ATOM    709  N   THR   107     -12.976   5.653  16.599  1.00 42.62          
ATOM    710  CA  THR   107     -13.557   6.684  15.707  1.00 41.71          
ATOM    711  CB  THR   107     -13.594   8.147  16.355  1.00 41.49          
ATOM    712  OG1 THR   107     -12.287   8.738  16.354  1.00 38.77          
ATOM    713  CG2 THR   107     -14.144   8.155  17.812  1.00 38.97          
ATOM    714  C   THR   107     -12.937   6.749  14.295  1.00 42.42          
ATOM    715  O   THR   107     -13.446   7.490  13.460  1.00 42.86          
ATOM    716  N   VAL   108     -11.865   5.989  14.021  1.00 43.28          
ATOM    717  CA  VAL   108     -11.174   6.041  12.700  1.00 44.00          
ATOM    718  CB  VAL   108      -9.907   5.118  12.604  1.00 44.13          
ATOM    719  CG1 VAL   108      -9.248   5.251  11.231  1.00 43.39          
ATOM    720  CG2 VAL   108      -8.882   5.428  13.665  1.00 44.83          
ATOM    721  C   VAL   108     -12.081   5.574  11.571  1.00 44.91          
ATOM    722  O   VAL   108     -12.608   4.473  11.646  1.00 45.54          
ATOM    723  N   PRO   109     -12.240   6.384  10.506  1.00 45.75          
ATOM    724  CA  PRO   109     -13.064   5.951   9.356  1.00 46.26          
ATOM    725  CB  PRO   109     -13.326   7.252   8.571  1.00 46.12          
ATOM    726  CG  PRO   109     -12.426   8.300   9.157  1.00 46.50          
ATOM    727  CD  PRO   109     -11.660   7.727  10.315  1.00 46.18          
ATOM    728  C   PRO   109     -12.376   4.910   8.461  1.00 46.55          
ATOM    729  O   PRO   109     -11.754   3.963   8.965  1.00 46.67          
ATOM    730  N   ASN   113      -7.285   5.397   4.340  1.00 33.54          
ATOM    731  CA  ASN   113      -5.963   5.736   3.806  1.00 33.41          
ATOM    732  CB  ASN   113      -6.044   6.751   2.644  1.00 33.72          
ATOM    733  CG  ASN   113      -4.654   7.087   2.042  1.00 37.46          
ATOM    734  OD1 ASN   113      -3.627   6.526   2.444  1.00 39.44          
ATOM    735  ND2 ASN   113      -4.626   8.015   1.084  1.00 40.80          
ATOM    736  C   ASN   113      -5.083   6.309   4.924  1.00 32.22          
ATOM    737  O   ASN   113      -5.308   7.443   5.347  1.00 32.25          
ATOM    738  N   ARG   114      -4.092   5.525   5.359  1.00 30.44          
ATOM    739  CA  ARG   114      -3.235   5.856   6.515  1.00 29.06          
ATOM    740  CB  ARG   114      -3.024   4.604   7.390  1.00 28.57          
ATOM    741  CG  ARG   114      -4.322   4.087   8.066  1.00 30.87          
ATOM    742  CD  ARG   114      -4.068   3.153   9.262  1.00 31.31          
ATOM    743  NE  ARG   114      -5.346   2.805   9.903  1.00 37.47          
ATOM    744  CZ  ARG   114      -5.530   2.534  11.195  1.00 39.66          
ATOM    745  NH1 ARG   114      -4.520   2.530  12.062  1.00 41.65          
ATOM    746  NH2 ARG   114      -6.754   2.256  11.627  1.00 41.34          
ATOM    747  C   ARG   114      -1.889   6.483   6.125  1.00 27.36          
ATOM    748  O   ARG   114      -0.972   6.554   6.956  1.00 26.00          
ATOM    749  N   LYS   115      -1.760   6.931   4.869  1.00 25.69          
ATOM    750  CA  LYS   115      -0.501   7.488   4.377  1.00 24.69          
ATOM    751  CB  LYS   115      -0.622   7.929   2.916  1.00 26.01          
ATOM    752  CG  LYS   115       0.660   8.562   2.418  1.00 28.72          
ATOM    753  CD  LYS   115       0.682   8.735   0.914  1.00 32.80          
ATOM    754  CE  LYS   115       1.756   9.720   0.551  1.00 34.57          
ATOM    755  NZ  LYS   115       1.782   9.961  -0.892  1.00 34.10          
ATOM    756  C   LYS   115       0.006   8.678   5.236  1.00 23.52          
ATOM    757  O   LYS   115       1.218   8.884   5.407  1.00 23.21          
ATOM    758  N   TYR   116      -0.929   9.451   5.767  1.00 21.43          
ATOM    759  CA  TYR   116      -0.551  10.662   6.466  1.00 20.14          
ATOM    760  CB  TYR   116      -1.302  11.863   5.876  1.00 22.07          
ATOM    761  CG  TYR   116      -0.977  12.132   4.413  1.00 20.56          
ATOM    762  CD1 TYR   116       0.088  12.942   4.054  1.00 23.84          
ATOM    763  CE1 TYR   116       0.383  13.192   2.723  1.00 24.84          
ATOM    764  CZ  TYR   116      -0.417  12.601   1.727  1.00 26.66          
ATOM    765  OH  TYR   116      -0.113  12.859   0.396  1.00 27.73          
ATOM    766  CE2 TYR   116      -1.494  11.799   2.065  1.00 24.33          
ATOM    767  CD2 TYR   116      -1.777  11.574   3.402  1.00 23.92          
ATOM    768  C   TYR   116      -0.846  10.561   7.956  1.00 18.86          
ATOM    769  O   TYR   116      -1.078  11.577   8.598  1.00 17.24          
ATOM    770  N   PHE   117      -0.918   9.333   8.469  1.00 18.18          
ATOM    771  CA  PHE   117      -1.179   9.085   9.877  1.00 18.44          
ATOM    772  CB  PHE   117      -1.736   7.666  10.099  1.00 18.96          
ATOM    773  CG  PHE   117      -3.271   7.557  10.044  1.00 20.21          
ATOM    774  CD1 PHE   117      -4.020   8.251   9.096  1.00 21.37          
ATOM    775  CE1 PHE   117      -5.446   8.129   9.030  1.00 21.26          
ATOM    776  CZ  PHE   117      -6.106   7.300   9.928  1.00 21.40          
ATOM    777  CE2 PHE   117      -5.366   6.583  10.886  1.00 24.40          
ATOM    778  CD2 PHE   117      -3.943   6.722  10.941  1.00 23.57          
ATOM    779  C   PHE   117       0.090   9.162  10.729  1.00 18.09          
ATOM    780  O   PHE   117       1.146   8.584  10.390  1.00 17.52          
ATOM    781  N   TRP   118      -0.072   9.832  11.865  1.00 16.97          
ATOM    782  CA  TRP   118       0.946   9.866  12.912  1.00 15.96          
ATOM    783  CB  TRP   118       1.406  11.303  13.088  1.00 16.71          
ATOM    784  CG  TRP   118       2.157  11.805  11.887  1.00 16.60          
ATOM    785  CD1 TRP   118       1.622  12.304  10.734  1.00 16.44          
ATOM    786  NE1 TRP   118       2.642  12.671   9.844  1.00 16.03          
ATOM    787  CE2 TRP   118       3.856  12.411  10.456  1.00 16.20          
ATOM    788  CD2 TRP   118       3.582  11.857  11.741  1.00 15.80          
ATOM    789  CE3 TRP   118       4.664  11.497  12.576  1.00 15.82          
ATOM    790  CZ3 TRP   118       5.985  11.695  12.093  1.00 16.54          
ATOM    791  CH2 TRP   118       6.211  12.260  10.811  1.00 15.08          
ATOM    792  CZ2 TRP   118       5.170  12.603   9.980  1.00 17.59          
ATOM    793  C   TRP   118       0.319   9.377  14.223  1.00 16.58          
ATOM    794  O   TRP   118      -0.822   9.772  14.548  1.00 17.84          
ATOM    795  N   ARG   119       1.085   8.619  14.986  1.00 15.64          
ATOM    796  CA  ARG   119       0.581   8.046  16.263  1.00 16.03          
ATOM    797  CB  ARG   119       1.099   6.627  16.453  1.00 16.24          
ATOM    798  CG  ARG   119       0.554   5.699  15.389  1.00 18.29          
ATOM    799  CD  ARG   119       1.145   4.351  15.561  1.00 25.76          
ATOM    800  NE  ARG   119       0.464   3.425  14.674  1.00 26.51          
ATOM    801  CZ  ARG   119       0.383   2.119  14.898  1.00 34.05          
ATOM    802  NH1 ARG   119       0.996   1.588  15.958  1.00 35.57          
ATOM    803  NH2 ARG   119      -0.294   1.347  14.049  1.00 37.33          
ATOM    804  C   ARG   119       0.991   8.914  17.438  1.00 16.44          
ATOM    805  O   ARG   119       2.138   9.369  17.517  1.00 16.14          
ATOM    806  N   ILE   120       0.035   9.098  18.366  1.00 14.93          
ATOM    807  CA  ILE   120       0.285   9.760  19.624  1.00 15.69          
ATOM    808  CB  ILE   120      -0.705  10.948  19.797  1.00 15.26          
ATOM    809  CG1 ILE   120      -0.385  12.048  18.766  1.00 18.08          
ATOM    810  CD  ILE   120       0.951  12.738  19.029  1.00 20.70          
ATOM    811  CG2 ILE   120      -0.652  11.487  21.209  1.00 16.51          
ATOM    812  C   ILE   120       0.049   8.718  20.745  1.00 15.61          
ATOM    813  O   ILE   120      -0.991   8.033  20.741  1.00 16.56          
ATOM    814  N   TYR   121       1.024   8.601  21.646  1.00 16.03          
ATOM    815  CA  TYR   121       0.991   7.632  22.754  1.00 16.18          
ATOM    816  CB  TYR   121       2.287   6.819  22.824  1.00 17.91          
ATOM    817  CG  TYR   121       2.435   5.849  21.675  1.00 18.30          
ATOM    818  CD1 TYR   121       2.225   4.499  21.865  1.00 21.24          
ATOM    819  CE1 TYR   121       2.326   3.595  20.831  1.00 22.45          
ATOM    820  CZ  TYR   121       2.656   4.044  19.549  1.00 24.78          
ATOM    821  OH  TYR   121       2.760   3.107  18.522  1.00 27.03          
ATOM    822  CE2 TYR   121       2.892   5.383  19.325  1.00 21.35          
ATOM    823  CD2 TYR   121       2.782   6.291  20.392  1.00 21.36          
ATOM    824  C   TYR   121       0.799   8.361  24.085  1.00 17.86          
ATOM    825  O   TYR   121       1.211   9.519  24.254  1.00 17.07          
ATOM    826  N   SER   122       0.213   7.640  25.043  1.00 17.18          
ATOM    827  CA  SER   122       0.042   8.161  26.379  1.00 19.34          
ATOM    828  CB  SER   122      -1.398   8.619  26.602  1.00 20.41          
ATOM    829  OG  SER   122      -1.487   9.124  27.916  1.00 22.58          
ATOM    830  C   SER   122       0.320   7.008  27.338  1.00 20.90          
ATOM    831  O   SER   122      -0.305   5.964  27.213  1.00 20.94          
ATOM    832  N   ARG   123       1.280   7.219  28.239  1.00 23.74          
ATOM    833  CA  ARG   123       1.672   6.186  29.210  1.00 27.07          
ATOM    834  CB  ARG   123       0.569   6.048  30.245  1.00 27.56          
ATOM    835  CG  ARG   123       0.412   7.340  31.029  1.00 28.23          
ATOM    836  CD  ARG   123      -0.801   7.347  31.908  1.00 29.69          
ATOM    837  NE  ARG   123      -0.867   8.597  32.670  1.00 32.43          
ATOM    838  CZ  ARG   123      -1.698   8.811  33.690  1.00 31.18          
ATOM    839  NH1 ARG   123      -2.524   7.858  34.076  1.00 33.38          
ATOM    840  NH2 ARG   123      -1.702   9.978  34.311  1.00 29.88          
ATOM    841  C   ARG   123       1.983   4.846  28.529  1.00 28.50          
ATOM    842  O   ARG   123       1.458   3.791  28.910  1.00 30.40          
ATOM    843  N   GLY   124       2.826   4.909  27.498  1.00 29.06          
ATOM    844  CA  GLY   124       3.253   3.713  26.776  1.00 28.70          
ATOM    845  C   GLY   124       2.205   3.017  25.928  1.00 28.47          
ATOM    846  O   GLY   124       2.480   1.947  25.398  1.00 29.99          
ATOM    847  N   GLU   125       1.010   3.591  25.793  1.00 26.15          
ATOM    848  CA  GLU   125      -0.032   2.970  24.996  1.00 25.07          
ATOM    849  CB  GLU   125      -1.211   2.518  25.884  1.00 27.16          
ATOM    850  CG  GLU   125      -0.813   1.671  27.106  1.00 32.50          
ATOM    851  CD  GLU   125      -0.345   0.256  26.741  1.00 40.85          
ATOM    852  OE1 GLU   125      -0.677  -0.221  25.634  1.00 44.47          
ATOM    853  OE2 GLU   125       0.360  -0.387  27.563  1.00 45.71          
ATOM    854  C   GLU   125      -0.521   3.926  23.902  1.00 22.47          
ATOM    855  O   GLU   125      -0.595   5.137  24.126  1.00 21.62          
ATOM    856  N   LEU   126      -0.821   3.384  22.730  1.00 20.69          
ATOM    857  CA  LEU   126      -1.342   4.174  21.642  1.00 20.74          
ATOM    858  CB  LEU   126      -1.638   3.298  20.423  1.00 21.39          
ATOM    859  CG  LEU   126      -2.267   3.912  19.191  1.00 22.79          
ATOM    860  CD1 LEU   126      -1.319   4.982  18.661  1.00 20.56          
ATOM    861  CD2 LEU   126      -2.479   2.817  18.133  1.00 22.80          
ATOM    862  C   LEU   126      -2.615   4.853  22.117  1.00 21.50          
ATOM    863  O   LEU   126      -3.505   4.178  22.660  1.00 23.10          
ATOM    864  N   HSD   127      -2.720   6.165  21.901  1.00 19.38          
ATOM    865  CA  HSD   127      -3.885   6.912  22.322  1.00 18.68          
ATOM    866  CB  HSD   127      -3.522   8.110  23.199  1.00 18.89          
ATOM    867  CG  HSD   127      -4.720   8.717  23.853  1.00 22.08          
ATOM    868  ND1 HSD   127      -5.449   9.735  23.269  1.00 22.59          
ATOM    869  CE1 HSD   127      -6.491  10.022  24.039  1.00 25.16          
ATOM    870  NE2 HSD   127      -6.473   9.208  25.087  1.00 22.59          
ATOM    871  CD2 HSD   127      -5.385   8.377  24.992  1.00 21.86          
ATOM    872  C   HSD   127      -4.729   7.353  21.134  1.00 18.95          
ATOM    873  O   HSD   127      -5.911   7.072  21.069  1.00 20.21          
ATOM    874  N   HSD   128      -4.120   8.016  20.146  1.00 16.18          
ATOM    875  CA  HSD   128      -4.879   8.459  18.997  1.00 17.78          
ATOM    876  CB  HSD   128      -5.701   9.713  19.314  1.00 18.30          
ATOM    877  CG  HSD   128      -4.888  10.918  19.676  1.00 18.44          
ATOM    878  ND1 HSD   128      -4.619  11.280  20.985  1.00 22.60          
ATOM    879  CE1 HSD   128      -3.933  12.409  20.995  1.00 21.61          
ATOM    880  NE2 HSD   128      -3.778  12.815  19.743  1.00 17.62          
ATOM    881  CD2 HSD   128      -4.395  11.916  18.905  1.00 17.77          
ATOM    882  C   HSD   128      -3.955   8.694  17.802  1.00 17.96          
ATOM    883  O   HSD   128      -2.708   8.564  17.934  1.00 20.02          
ATOM    884  N   PHE   129      -4.582   8.968  16.659  1.00 18.35          
ATOM    885  CA  PHE   129      -3.878   9.233  15.410  1.00 18.79          
ATOM    886  CB  PHE   129      -4.374   8.339  14.249  1.00 20.17          
ATOM    887  CG  PHE   129      -4.349   6.890  14.540  1.00 21.77          
ATOM    888  CD1 PHE   129      -3.154   6.152  14.404  1.00 23.89          
ATOM    889  CE1 PHE   129      -3.137   4.787  14.653  1.00 26.02          
ATOM    890  CZ  PHE   129      -4.309   4.143  15.051  1.00 23.75          
ATOM    891  CE2 PHE   129      -5.510   4.853  15.177  1.00 24.48          
ATOM    892  CD2 PHE   129      -5.523   6.234  14.917  1.00 25.40          
ATOM    893  C   PHE   129      -4.137  10.665  14.989  1.00 18.55          
ATOM    894  O   PHE   129      -5.268  11.170  15.109  1.00 18.71          
ATOM    895  N   ILE   130      -3.099  11.327  14.481  1.00 15.32          
ATOM    896  CA  ILE   130      -3.283  12.600  13.793  1.00 16.50          
ATOM    897  CB  ILE   130      -2.184  13.667  14.180  1.00 16.96          
ATOM    898  CG1 ILE   130      -2.168  13.950  15.680  1.00 18.42          
ATOM    899  CD  ILE   130      -0.852  14.595  16.129  1.00 16.78          
ATOM    900  CG2 ILE   130      -2.476  14.985  13.486  1.00 18.18          
ATOM    901  C   ILE   130      -3.164  12.285  12.298  1.00 17.03          
ATOM    902  O   ILE   130      -2.173  11.690  11.861  1.00 17.65          
ATOM    903  N   ASP   131      -4.170  12.667  11.523  1.00 16.88          
ATOM    904  CA  ASP   131      -4.219  12.297  10.128  1.00 18.19          
ATOM    905  CB  ASP   131      -5.530  11.532   9.831  1.00 18.28          
ATOM    906  CG  ASP   131      -5.731  11.266   8.313  1.00 21.31          
ATOM    907  OD1 ASP   131      -4.742  11.291   7.533  1.00 20.30          
ATOM    908  OD2 ASP   131      -6.886  10.985   7.904  1.00 26.77          
ATOM    909  C   ASP   131      -4.143  13.555   9.260  1.00 18.74          
ATOM    910  O   ASP   131      -5.015  14.423   9.319  1.00 18.14          
ATOM    911  N   GLY   132      -3.072  13.660   8.481  1.00 18.82          
ATOM    912  CA  GLY   132      -2.862  14.849   7.655  1.00 19.66          
ATOM    913  C   GLY   132      -3.449  14.775   6.238  1.00 20.30          
ATOM    914  O   GLY   132      -3.160  15.642   5.421  1.00 20.48          
ATOM    915  N   PHE   133      -4.298  13.785   5.963  1.00 20.65          
ATOM    916  CA  PHE   133      -4.778  13.586   4.607  1.00 21.14          
ATOM    917  CB  PHE   133      -5.641  12.333   4.520  1.00 22.09          
ATOM    918  CG  PHE   133      -6.177  12.110   3.150  1.00 26.42          
ATOM    919  CD1 PHE   133      -5.323  11.728   2.125  1.00 29.51          
ATOM    920  CE1 PHE   133      -5.814  11.550   0.819  1.00 31.16          
ATOM    921  CZ  PHE   133      -7.166  11.790   0.558  1.00 28.94          
ATOM    922  CE2 PHE   133      -8.019  12.195   1.573  1.00 31.34          
ATOM    923  CD2 PHE   133      -7.518  12.368   2.870  1.00 28.75          
ATOM    924  C   PHE   133      -5.582  14.787   4.087  1.00 20.52          
ATOM    925  O   PHE   133      -5.377  15.251   2.950  1.00 20.59          
ATOM    926  N   ASN   134      -6.487  15.300   4.894  1.00 19.13          
ATOM    927  CA  ASN   134      -7.381  16.369   4.422  1.00 19.27          
ATOM    928  CB  ASN   134      -8.636  16.436   5.307  1.00 19.60          
ATOM    929  CG  ASN   134      -9.654  17.488   4.830  1.00 22.47          
ATOM    930  OD1 ASN   134      -9.341  18.379   4.019  1.00 22.03          
ATOM    931  ND2 ASN   134     -10.904  17.368   5.327  1.00 23.92          
ATOM    932  C   ASN   134      -6.658  17.717   4.450  1.00 19.56          
ATOM    933  O   ASN   134      -6.376  18.253   5.547  1.00 19.38          
ATOM    934  N   GLU   135      -6.365  18.297   3.272  1.00 19.05          
ATOM    935  CA  GLU   135      -5.549  19.554   3.261  1.00 20.29          
ATOM    936  CB  GLU   135      -5.070  19.874   1.837  1.00 21.08          
ATOM    937  CG  GLU   135      -4.132  18.807   1.315  1.00 25.54          
ATOM    938  CD  GLU   135      -4.063  18.723  -0.201  1.00 31.54          
ATOM    939  OE1 GLU   135      -5.024  18.207  -0.819  1.00 35.44          
ATOM    940  OE2 GLU   135      -3.024  19.127  -0.766  1.00 31.55          
ATOM    941  C   GLU   135      -6.258  20.762   3.863  1.00 20.42          
ATOM    942  O   GLU   135      -5.602  21.736   4.208  1.00 20.60          
ATOM    943  N   GLU   136      -7.592  20.705   3.971  1.00 20.06          
ATOM    944  CA  GLU   136      -8.370  21.789   4.581  1.00 21.63          
ATOM    945  CB  GLU   136      -9.855  21.726   4.155  1.00 22.35          
ATOM    946  CG  GLU   136     -10.076  22.064   2.682  1.00 25.16          
ATOM    947  CD  GLU   136     -11.547  21.934   2.236  1.00 28.51          
ATOM    948  OE1 GLU   136     -12.399  21.441   3.036  1.00 33.67          
ATOM    949  OE2 GLU   136     -11.843  22.341   1.071  1.00 33.91          
ATOM    950  C   GLU   136      -8.263  21.753   6.115  1.00 20.55          
ATOM    951  O   GLU   136      -8.529  22.754   6.771  1.00 22.07          
ATOM    952  N   LYS   137      -7.899  20.587   6.658  1.00 19.21          
ATOM    953  CA  LYS   137      -7.852  20.384   8.127  1.00 19.50          
ATOM    954  CB  LYS   137      -8.837  19.315   8.547  1.00 20.11          
ATOM    955  CG  LYS   137     -10.273  19.715   8.259  1.00 25.41          
ATOM    956  CD  LYS   137     -11.211  18.507   8.444  1.00 33.74          
ATOM    957  CE  LYS   137     -12.696  18.906   8.349  1.00 38.10          
ATOM    958  NZ  LYS   137     -13.005  19.913   9.413  1.00 42.73          
ATOM    959  C   LYS   137      -6.466  20.020   8.656  1.00 18.18          
ATOM    960  O   LYS   137      -6.342  19.535   9.801  1.00 19.14          
ATOM    961  N   SER   138      -5.434  20.233   7.842  0.50 17.09          
ATOM    963  CA  SER   138      -4.064  19.835   8.223  0.50 16.24          
ATOM    965  CB  SER   138      -3.691  18.501   7.579  0.50 17.33          
ATOM    967  OG  SER   138      -3.689  18.576   6.162  0.50 17.83          
ATOM    969  C   SER   138      -3.082  20.919   7.802  0.50 15.27          
ATOM    971  O   SER   138      -3.356  21.664   6.862  0.50 14.76          
ATOM    973  N   ASN   139      -1.947  21.026   8.500  1.00 13.56          
ATOM    974  CA  ASN   139      -0.958  22.032   8.120  1.00 12.90          
ATOM    975  CB  ASN   139      -0.308  22.750   9.316  1.00 12.49          
ATOM    976  CG  ASN   139       0.584  21.840  10.119  1.00 13.20          
ATOM    977  OD1 ASN   139       0.558  20.609   9.966  1.00 13.18          
ATOM    978  ND2 ASN   139       1.418  22.447  11.001  1.00 16.33          
ATOM    979  C   ASN   139       0.072  21.457   7.141  1.00 12.91          
ATOM    980  O   ASN   139      -0.003  20.272   6.676  1.00 13.91          
ATOM    981  N   TRP   140       1.051  22.314   6.811  1.00 11.84          
ATOM    982  CA  TRP   140       2.029  22.042   5.742  1.00 13.53          
ATOM    983  CB  TRP   140       2.905  23.275   5.600  1.00 13.50          
ATOM    984  CG  TRP   140       3.670  23.555   6.904  1.00 13.44          
ATOM    985  CD1 TRP   140       3.242  24.273   8.002  1.00 13.70          
ATOM    986  NE1 TRP   140       4.219  24.258   8.986  1.00 14.04          
ATOM    987  CE2 TRP   140       5.311  23.567   8.522  1.00 12.59          
ATOM    988  CD2 TRP   140       4.989  23.100   7.205  1.00 12.97          
ATOM    989  CE3 TRP   140       5.931  22.319   6.509  1.00 12.80          
ATOM    990  CZ3 TRP   140       7.181  22.030   7.141  1.00 12.23          
ATOM    991  CH2 TRP   140       7.472  22.519   8.463  1.00 12.90          
ATOM    992  CZ2 TRP   140       6.549  23.272   9.156  1.00 12.87          
ATOM    993  C   TRP   140       2.920  20.827   6.019  1.00 13.00          
ATOM    994  O   TRP   140       3.532  20.280   5.114  1.00 14.00          
ATOM    995  N   MET   141       3.010  20.403   7.288  1.00 12.12          
ATOM    996  CA  MET   141       3.900  19.296   7.638  1.00 13.30          
ATOM    997  CB  MET   141       3.978  19.157   9.160  1.00 13.33          
ATOM    998  CG  MET   141       4.778  20.291   9.743  1.00 16.01          
ATOM    999  SD  MET   141       4.518  20.460  11.553  1.00 15.33          
ATOM   1000  CE  MET   141       5.617  19.188  12.159  1.00 18.68          
ATOM   1001  C   MET   141       3.501  17.982   6.963  1.00 12.78          
ATOM   1002  O   MET   141       4.359  17.120   6.746  1.00 13.48          
ATOM   1003  N   ARG   142       2.228  17.871   6.546  1.00 12.55          
ATOM   1004  CA  ARG   142       1.807  16.682   5.777  1.00 15.54          
ATOM   1005  CB  ARG   142       0.296  16.793   5.430  1.00 15.04          
ATOM   1006  CG  ARG   142       0.041  17.813   4.363  1.00 15.71          
ATOM   1007  CD  ARG   142      -1.338  17.918   3.736  1.00 21.55          
ATOM   1008  NE  ARG   142      -2.034  16.722   3.222  1.00 20.55          
ATOM   1009  CZ  ARG   142      -1.924  16.125   2.022  1.00 22.64          
ATOM   1010  NH1 ARG   142      -0.974  16.435   1.130  1.00 24.73          
ATOM   1011  NH2 ARG   142      -2.766  15.130   1.723  1.00 20.62          
ATOM   1012  C   ARG   142       2.609  16.499   4.454  1.00 14.19          
ATOM   1013  O   ARG   142       2.640  15.368   3.901  1.00 15.05          
ATOM   1014  N   TYR   143       3.158  17.600   3.916  1.00 13.72          
ATOM   1015  CA  TYR   143       3.891  17.528   2.635  1.00 14.43          
ATOM   1016  CB  TYR   143       3.808  18.851   1.898  1.00 14.54          
ATOM   1017  CG  TYR   143       2.440  19.264   1.467  1.00 15.31          
ATOM   1018  CD1 TYR   143       1.734  18.569   0.455  1.00 16.62          
ATOM   1019  CE1 TYR   143       0.416  19.043   0.059  1.00 17.38          
ATOM   1020  CZ  TYR   143      -0.087  20.175   0.684  1.00 17.38          
ATOM   1021  OH  TYR   143      -1.319  20.734   0.416  1.00 20.88          
ATOM   1022  CE2 TYR   143       0.615  20.845   1.665  1.00 16.29          
ATOM   1023  CD2 TYR   143       1.878  20.379   2.036  1.00 14.85          
ATOM   1024  C   TYR   143       5.354  17.147   2.755  1.00 13.95          
ATOM   1025  O   TYR   143       6.034  16.919   1.760  1.00 15.66          
ATOM   1026  N   VAL   144       5.868  17.102   3.970  1.00 12.85          
ATOM   1027  CA  VAL   144       7.253  16.715   4.154  1.00 12.20          
ATOM   1028  CB  VAL   144       7.767  17.097   5.563  1.00 11.94          
ATOM   1029  CG1 VAL   144       9.216  16.706   5.738  1.00 12.60          
ATOM   1030  CG2 VAL   144       7.622  18.587   5.783  1.00 12.24          
ATOM   1031  C   VAL   144       7.445  15.216   3.908  1.00 13.42          
ATOM   1032  O   VAL   144       6.810  14.365   4.576  1.00 13.83          
ATOM   1033  N   ASN   145       8.333  14.907   2.977  1.00 13.63          
ATOM   1034  CA  ASN   145       8.655  13.526   2.643  1.00 14.79          
ATOM   1035  CB  ASN   145       9.263  13.467   1.222  1.00 15.38          
ATOM   1036  CG  ASN   145       8.243  13.869   0.168  1.00 18.77          
ATOM   1037  OD1 ASN   145       7.128  13.384   0.184  1.00 18.28          
ATOM   1038  ND2 ASN   145       8.629  14.757  -0.734  1.00 18.59          
ATOM   1039  C   ASN   145       9.622  12.853   3.623  1.00 14.88          
ATOM   1040  O   ASN   145      10.416  13.535   4.308  1.00 14.14          
ATOM   1041  N   PRO   146       9.559  11.512   3.706  1.00 15.45          
ATOM   1042  CA  PRO   146      10.446  10.779   4.607  1.00 15.12          
ATOM   1043  CB  PRO   146       9.787   9.391   4.702  1.00 16.65          
ATOM   1044  CG  PRO   146       9.159   9.201   3.374  1.00 16.74          
ATOM   1045  CD  PRO   146       8.625  10.595   2.999  1.00 16.00          
ATOM   1046  C   PRO   146      11.843  10.634   4.010  1.00 14.88          
ATOM   1047  O   PRO   146      12.010  10.539   2.752  1.00 16.95          
ATOM   1048  N   ALA   147      12.851  10.620   4.876  1.00 14.99          
ATOM   1049  CA  ALA   147      14.235  10.400   4.443  1.00 15.24          
ATOM   1050  CB  ALA   147      15.191  10.627   5.617  1.00 15.91          
ATOM   1051  C   ALA   147      14.327   8.928   4.038  1.00 16.99          
ATOM   1052  O   ALA   147      13.773   8.085   4.714  1.00 17.23          
ATOM   1053  N   HSD   148      15.103   8.643   2.983  1.00 18.26          
ATOM   1054  CA  HSD   148      15.358   7.236   2.603  1.00 20.61          
ATOM   1055  CB  HSD   148      15.582   7.150   1.098  1.00 21.44          
ATOM   1056  CG  HSD   148      14.405   7.589   0.276  1.00 27.91          
ATOM   1057  ND1 HSD   148      13.100   7.401   0.676  1.00 36.01          
ATOM   1058  CE1 HSD   148      12.276   7.865  -0.248  1.00 35.50          
ATOM   1059  NE2 HSD   148      13.001   8.348  -1.239  1.00 37.23          
ATOM   1060  CD2 HSD   148      14.338   8.186  -0.938  1.00 34.46          
ATOM   1061  C   HSD   148      16.512   6.554   3.319  1.00 20.48          
ATOM   1062  O   HSD   148      16.636   5.298   3.274  1.00 21.80          
ATOM   1063  N   SER   149      17.370   7.359   3.953  1.00 20.16          
ATOM   1064  CA  SER   149      18.590   6.896   4.581  1.00 20.68          
ATOM   1065  CB  SER   149      19.712   6.788   3.534  1.00 22.00          
ATOM   1066  OG  SER   149      20.173   8.088   3.136  1.00 23.66          
ATOM   1067  C   SER   149      19.012   7.876   5.686  1.00 20.14          
ATOM   1068  O   SER   149      18.616   9.066   5.655  1.00 19.10          
ATOM   1069  N   PRO   150      19.831   7.405   6.637  1.00 20.10          
ATOM   1070  CA  PRO   150      20.385   8.324   7.614  1.00 19.83          
ATOM   1071  CB  PRO   150      21.417   7.479   8.360  1.00 20.23          
ATOM   1072  CG  PRO   150      20.898   6.136   8.303  1.00 19.79          
ATOM   1073  CD  PRO   150      20.239   6.011   6.926  1.00 20.94          
ATOM   1074  C   PRO   150      21.053   9.520   6.979  1.00 20.30          
ATOM   1075  O   PRO   150      20.912  10.617   7.480  1.00 19.49          
ATOM   1076  N   ARG   151      21.723   9.324   5.839  1.00 19.18          
ATOM   1077  CA  ARG   151      22.510  10.394   5.235  1.00 19.36          
ATOM   1078  CB  ARG   151      23.353   9.840   4.048  1.00 19.17          
ATOM   1085  C   ARG   151      21.559  11.501   4.747  1.00 19.56          
ATOM   1086  O   ARG   151      21.908  12.675   4.797  1.00 20.48          
ATOM   1087  N   GLU   152      20.369  11.118   4.283  1.00 17.79          
ATOM   1088  CA  GLU   152      19.404  12.080   3.733  1.00 19.36          
ATOM   1089  CB  GLU   152      18.358  11.354   2.897  1.00 19.47          
ATOM   1090  CG  GLU   152      18.856  10.841   1.552  1.00 23.10          
ATOM   1091  CD  GLU   152      17.708  10.387   0.649  1.00 25.12          
ATOM   1092  OE1 GLU   152      16.484  10.413   1.040  1.00 26.26          
ATOM   1093  OE2 GLU   152      18.048   9.999  -0.494  1.00 30.27          
ATOM   1094  C   GLU   152      18.593  12.844   4.803  1.00 18.22          
ATOM   1095  O   GLU   152      18.003  13.899   4.517  1.00 17.60          
ATOM   1096  N   GLN   153      18.468  12.235   5.969  1.00 16.61          
ATOM   1097  CA  GLN   153      17.603  12.847   7.009  1.00 14.79          
ATOM   1098  CB  GLN   153      17.515  11.909   8.219  1.00 15.56          
ATOM   1099  CG  GLN   153      16.662  12.490   9.384  1.00 13.80          
ATOM   1100  CD  GLN   153      16.876  11.728  10.690  1.00 14.16          
ATOM   1101  OE1 GLN   153      17.945  11.105  10.894  1.00 16.41          
ATOM   1102  NE2 GLN   153      15.881  11.790  11.602  1.00 12.43          
ATOM   1103  C   GLN   153      18.141  14.187   7.463  1.00 13.96          
ATOM   1104  O   GLN   153      19.329  14.302   7.801  1.00 14.14          
ATOM   1105  N   ASN   154      17.269  15.186   7.499  1.00 12.50          
ATOM   1106  CA  ASN   154      17.640  16.441   8.163  1.00 12.12          
ATOM   1107  CB  ASN   154      17.978  17.562   7.152  1.00 13.53          
ATOM   1108  CG  ASN   154      16.884  17.810   6.145  1.00 14.09          
ATOM   1109  OD1 ASN   154      15.695  17.567   6.407  1.00 13.67          
ATOM   1110  ND2 ASN   154      17.289  18.277   4.928  1.00 15.46          
ATOM   1111  C   ASN   154      16.611  16.904   9.226  1.00 12.37          
ATOM   1112  O   ASN   154      16.850  17.920   9.876  1.00 13.72          
ATOM   1113  N   LEU   155      15.527  16.136   9.411  1.00 11.73          
ATOM   1114  CA  LEU   155      14.562  16.425  10.484  1.00 11.16          
ATOM   1115  CB  LEU   155      13.211  16.848   9.898  1.00 12.87          
ATOM   1116  CG  LEU   155      13.169  18.129   9.073  1.00 11.67          
ATOM   1117  CD1 LEU   155      11.835  18.125   8.243  1.00 10.98          
ATOM   1118  CD2 LEU   155      13.250  19.403   9.998  1.00 14.43          
ATOM   1119  C   LEU   155      14.296  15.140  11.285  1.00 12.43          
ATOM   1120  O   LEU   155      14.174  14.067  10.669  1.00 11.73          
ATOM   1121  N   ALA   156      14.166  15.271  12.619  1.00 11.18          
ATOM   1122  CA  ALA   156      13.731  14.166  13.479  1.00 10.62          
ATOM   1123  CB  ALA   156      14.621  14.054  14.692  1.00 12.04          
ATOM   1124  C   ALA   156      12.297  14.559  13.936  1.00 11.15          
ATOM   1125  O   ALA   156      12.096  15.659  14.389  1.00 12.08          
ATOM   1126  N   ALA   157      11.355  13.617  13.881  1.00 10.85          
ATOM   1127  CA  ALA   157       9.985  13.792  14.387  1.00 10.61          
ATOM   1128  CB  ALA   157       8.961  12.978  13.500  1.00 12.20          
ATOM   1129  C   ALA   157       9.942  13.232  15.811  1.00 11.92          
ATOM   1130  O   ALA   157      10.324  12.047  16.033  1.00 12.06          
ATOM   1131  N   CYS   158       9.355  14.027  16.716  1.00 12.86          
ATOM   1132  CA  CYS   158       9.229  13.704  18.149  1.00 13.07          
ATOM   1133  CB  CYS   158      10.121  14.666  18.968  1.00 14.01          
ATOM   1134  SG  CYS   158      11.885  14.443  18.619  1.00 19.62          
ATOM   1135  C   CYS   158       7.839  13.971  18.618  1.00 12.72          
ATOM   1136  O   CYS   158       7.208  14.903  18.149  1.00 12.21          
ATOM   1137  N   GLN   159       7.391  13.196  19.619  1.00 11.32          
ATOM   1138  CA  GLN   159       6.204  13.570  20.372  1.00 11.16          
ATOM   1139  CB  GLN   159       5.398  12.325  20.782  1.00 12.99          
ATOM   1140  CG  GLN   159       4.092  12.762  21.488  1.00 12.62          
ATOM   1141  CD  GLN   159       3.265  11.598  21.993  1.00 16.38          
ATOM   1142  OE1 GLN   159       3.271  10.497  21.414  1.00 15.21          
ATOM   1143  NE2 GLN   159       2.543  11.839  23.104  1.00 15.30          
ATOM   1144  C   GLN   159       6.645  14.297  21.632  1.00 12.95          
ATOM   1145  O   GLN   159       7.412  13.708  22.449  1.00 14.98          
ATOM   1146  N   ASN   160       6.230  15.560  21.781  1.00 11.75          
ATOM   1147  CA  ASN   160       6.480  16.318  23.023  1.00 13.68          
ATOM   1148  CB  ASN   160       7.324  17.560  22.726  1.00 14.53          
ATOM   1149  CG  ASN   160       8.687  17.216  22.151  1.00 17.94          
ATOM   1150  OD1 ASN   160       9.000  17.619  21.032  1.00 24.10          
ATOM   1151  ND2 ASN   160       9.502  16.471  22.905  1.00 19.50          
ATOM   1152  C   ASN   160       5.097  16.699  23.569  1.00 13.57          
ATOM   1153  O   ASN   160       4.289  17.331  22.856  1.00 14.25          
ATOM   1154  N   GLY   161       4.812  16.283  24.812  1.00 15.22          
ATOM   1155  CA  GLY   161       3.454  16.495  25.322  1.00 15.36          
ATOM   1156  C   GLY   161       2.484  15.667  24.496  1.00 15.45          
ATOM   1157  O   GLY   161       2.721  14.457  24.282  1.00 17.14          
ATOM   1158  N   MET   162       1.447  16.336  24.003  1.00 15.13          
ATOM   1159  CA  MET   162       0.389  15.733  23.185  1.00 16.13          
ATOM   1160  CB  MET   162      -1.003  16.191  23.658  1.00 17.63          
ATOM   1161  CG  MET   162      -1.280  15.854  25.092  1.00 19.29          
ATOM   1162  SD  MET   162      -3.004  16.190  25.476  1.00 22.56          
ATOM   1163  CE  MET   162      -3.014  15.796  27.248  1.00 21.55          
ATOM   1164  C   MET   162       0.574  16.018  21.684  1.00 15.70          
ATOM   1165  O   MET   162      -0.317  15.708  20.904  1.00 16.35          
ATOM   1166  N   ASN   163       1.716  16.621  21.313  1.00 14.18          
ATOM   1167  CA  ASN   163       1.943  17.067  19.930  1.00 12.45          
ATOM   1168  CB  ASN   163       2.216  18.573  19.954  1.00 13.53          
ATOM   1169  CG  ASN   163       0.967  19.383  20.257  1.00 15.76          
ATOM   1170  OD1 ASN   163      -0.144  18.974  19.926  1.00 18.83          
ATOM   1171  ND2 ASN   163       1.149  20.544  20.858  1.00 19.58          
ATOM   1172  C   ASN   163       3.146  16.403  19.273  1.00 12.87          
ATOM   1173  O   ASN   163       4.015  15.867  19.960  1.00 12.52          
ATOM   1174  N   ILE   164       3.214  16.487  17.951  0.50 11.38          
ATOM   1176  CA  ILE   164       4.407  16.040  17.246  0.50 10.78          
ATOM   1178  CB  ILE   164       4.080  14.990  16.210  0.50 10.12          
ATOM   1180  CG1 ILE   164       3.699  13.688  16.924  0.50 10.59          
ATOM   1182  CD  ILE   164       2.931  12.778  16.044  0.50 11.40          
ATOM   1184  CG2 ILE   164       5.275  14.795  15.223  0.50 10.16          
ATOM   1186  C   ILE   164       5.040  17.261  16.584  0.50 10.78          
ATOM   1188  O   ILE   164       4.344  18.068  15.946  0.50 11.05          
ATOM   1190  N   TYR   165       6.355  17.361  16.751  1.00 10.65          
ATOM   1191  CA  TYR   165       7.157  18.446  16.178  1.00 10.17          
ATOM   1192  CB  TYR   165       7.830  19.324  17.248  1.00 11.23          
ATOM   1193  CG  TYR   165       6.862  19.971  18.187  1.00 10.50          
ATOM   1194  CD1 TYR   165       6.390  21.252  17.941  1.00 13.89          
ATOM   1195  CE1 TYR   165       5.498  21.890  18.804  1.00 13.72          
ATOM   1196  CZ  TYR   165       5.063  21.198  19.908  1.00 14.69          
ATOM   1197  OH  TYR   165       4.168  21.823  20.791  1.00 17.17          
ATOM   1198  CE2 TYR   165       5.540  19.943  20.187  1.00 13.40          
ATOM   1199  CD2 TYR   165       6.453  19.328  19.341  1.00 13.56          
ATOM   1200  C   TYR   165       8.262  17.811  15.334  1.00 10.13          
ATOM   1201  O   TYR   165       8.610  16.638  15.547  1.00 10.99          
ATOM   1202  N   PHE   166       8.798  18.594  14.390  1.00  9.25          
ATOM   1203  CA  PHE   166      10.001  18.141  13.624  1.00  9.96          
ATOM   1204  CB  PHE   166       9.816  18.358  12.103  1.00 10.86          
ATOM   1205  CG  PHE   166       8.698  17.532  11.467  1.00  9.97          
ATOM   1206  CD1 PHE   166       8.114  16.450  12.123  1.00 12.34          
ATOM   1207  CE1 PHE   166       7.074  15.672  11.479  1.00 12.05          
ATOM   1208  CZ  PHE   166       6.678  15.987  10.191  1.00 11.17          
ATOM   1209  CE2 PHE   166       7.251  17.096   9.536  1.00 10.65          
ATOM   1210  CD2 PHE   166       8.286  17.847  10.163  1.00 10.87          
ATOM   1211  C   PHE   166      11.152  19.065  14.032  1.00 10.96          
ATOM   1212  O   PHE   166      10.945  20.305  14.024  1.00 13.14          
ATOM   1213  N   TYR   167      12.327  18.498  14.310  1.00 11.06          
ATOM   1214  CA  TYR   167      13.493  19.305  14.704  1.00 10.48          
ATOM   1215  CB  TYR   167      14.021  18.788  16.045  1.00 13.28          
ATOM   1216  CG  TYR   167      13.074  19.036  17.203  1.00 12.23          
ATOM   1217  CD1 TYR   167      13.233  20.176  18.020  1.00 14.25          
ATOM   1218  CE1 TYR   167      12.336  20.388  19.101  1.00 12.11          
ATOM   1219  CZ  TYR   167      11.332  19.430  19.355  1.00 12.48          
ATOM   1220  OH  TYR   167      10.482  19.641  20.460  1.00 16.14          
ATOM   1221  CE2 TYR   167      11.156  18.290  18.571  1.00 12.23          
ATOM   1222  CD2 TYR   167      12.045  18.090  17.492  1.00 13.63          
ATOM   1223  C   TYR   167      14.598  19.102  13.676  1.00 11.90          
ATOM   1224  O   TYR   167      14.891  17.946  13.323  1.00 11.19          
ATOM   1225  N   THR   168      15.269  20.172  13.225  1.00 11.16          
ATOM   1226  CA  THR   168      16.394  19.941  12.305  1.00 11.64          
ATOM   1227  CB  THR   168      16.885  21.214  11.598  1.00 11.88          
ATOM   1228  OG1 THR   168      17.234  22.180  12.611  1.00 14.05          
ATOM   1229  CG2 THR   168      15.753  21.791  10.672  1.00 13.31          
ATOM   1230  C   THR   168      17.573  19.344  13.117  1.00 12.97          
ATOM   1231  O   THR   168      17.935  19.830  14.203  1.00 14.14          
ATOM   1232  N   ILE   169      18.172  18.299  12.569  1.00 12.38          
ATOM   1233  CA  ILE   169      19.307  17.626  13.211  1.00 14.36          
ATOM   1234  CB  ILE   169      19.088  16.097  13.268  1.00 13.93          
ATOM   1235  CG1 ILE   169      18.904  15.543  11.850  1.00 16.39          
ATOM   1236  CD  ILE   169      19.070  14.043  11.773  1.00 25.60          
ATOM   1237  CG2 ILE   169      17.887  15.766  14.186  1.00 15.50          
ATOM   1238  C   ILE   169      20.624  17.982  12.520  1.00 15.57          
ATOM   1239  O   ILE   169      21.737  17.556  12.939  1.00 15.55          
ATOM   1240  N   LYS   170      20.500  18.746  11.446  0.50 15.63          
ATOM   1242  CA  LYS   170      21.665  19.307  10.750  0.50 16.54          
ATOM   1244  CB  LYS   170      22.301  18.255   9.809  0.50 17.35          
ATOM   1246  CG  LYS   170      21.329  17.498   8.908  0.50 17.11          
ATOM   1248  CD  LYS   170      21.993  16.358   8.072  0.50 17.66          
ATOM   1250  CE  LYS   170      22.088  15.015   8.834  0.50 18.51          
ATOM   1252  NZ  LYS   170      21.970  13.710   7.995  0.50 15.40          
ATOM   1254  C   LYS   170      21.203  20.565  10.006  0.50 16.46          
ATOM   1256  O   LYS   170      20.015  20.673   9.697  0.50 15.73          
ATOM   1258  N   PRO   171      22.136  21.499   9.673  1.00 16.68          
ATOM   1259  CA  PRO   171      21.682  22.684   8.899  1.00 16.85          
ATOM   1260  CB  PRO   171      22.987  23.494   8.663  1.00 17.80          
ATOM   1261  CG  PRO   171      23.932  22.973   9.672  1.00 17.86          
ATOM   1262  CD  PRO   171      23.588  21.504   9.873  1.00 17.46          
ATOM   1263  C   PRO   171      21.080  22.279   7.578  1.00 16.97          
ATOM   1264  O   PRO   171      21.465  21.242   6.994  1.00 18.12          
ATOM   1265  N   ILE   172      20.121  23.057   7.107  1.00 15.23          
ATOM   1266  CA  ILE   172      19.512  22.816   5.795  1.00 15.22          
ATOM   1267  CB  ILE   172      17.983  22.624   5.856  1.00 15.16          
ATOM   1268  CG1 ILE   172      17.660  21.554   6.914  1.00 16.42          
ATOM   1269  CD  ILE   172      16.184  21.144   6.904  1.00 15.79          
ATOM   1270  CG2 ILE   172      17.428  22.274   4.477  1.00 16.27          
ATOM   1271  C   ILE   172      19.848  24.067   4.973  1.00 15.75          
ATOM   1272  O   ILE   172      19.258  25.137   5.142  1.00 16.17          
ATOM   1273  N   PRO   173      20.831  23.947   4.082  1.00 17.91          
ATOM   1274  CA  PRO   173      21.091  25.082   3.202  1.00 17.94          
ATOM   1275  CB  PRO   173      22.229  24.560   2.311  1.00 18.66          
ATOM   1276  CG  PRO   173      22.918  23.544   3.141  1.00 19.79          
ATOM   1277  CD  PRO   173      21.766  22.839   3.852  1.00 18.99          
ATOM   1278  C   PRO   173      19.892  25.469   2.347  1.00 17.72          
ATOM   1279  O   PRO   173      18.985  24.667   2.109  1.00 17.35          
ATOM   1280  N   ALA   174      19.887  26.703   1.860  1.00 17.71          
ATOM   1281  CA  ALA   174      18.820  27.187   1.003  1.00 19.28          
ATOM   1282  CB  ALA   174      19.165  28.584   0.463  1.00 20.29          
ATOM   1283  C   ALA   174      18.548  26.235  -0.178  1.00 19.72          
ATOM   1284  O   ALA   174      19.495  25.674  -0.767  1.00 19.42          
ATOM   1285  N   ASN   175      17.269  26.044  -0.491  1.00 20.27          
ATOM   1286  CA  ASN   175      16.802  25.278  -1.651  1.00 22.29          
ATOM   1287  CB  ASN   175      17.250  25.964  -2.978  1.00 24.17          
ATOM   1288  CG  ASN   175      16.773  27.436  -3.049  1.00 27.08          
ATOM   1289  OD1 ASN   175      17.579  28.360  -3.218  1.00 34.64          
ATOM   1290  ND2 ASN   175      15.468  27.651  -2.847  1.00 32.33          
ATOM   1291  C   ASN   175      17.124  23.782  -1.579  1.00 22.33          
ATOM   1292  O   ASN   175      17.356  23.127  -2.607  1.00 25.13          
ATOM   1293  N   GLN   176      17.111  23.233  -0.361  1.00 19.28          
ATOM   1294  CA  GLN   176      17.339  21.803  -0.113  1.00 18.46          
ATOM   1295  CB  GLN   176      18.547  21.548   0.804  1.00 19.10          
ATOM   1296  CG  GLN   176      19.872  22.108   0.205  1.00 21.54          
ATOM   1297  CD  GLN   176      20.153  21.571  -1.194  1.00 28.85          
ATOM   1298  OE1 GLN   176      20.197  20.363  -1.406  1.00 30.96          
ATOM   1299  NE2 GLN   176      20.336  22.469  -2.144  1.00 31.98          
ATOM   1300  C   GLN   176      16.050  21.211   0.488  1.00 18.13          
ATOM   1301  O   GLN   176      15.309  21.918   1.192  1.00 16.14          
ATOM   1302  N   GLU   177      15.738  19.966   0.136  1.00 17.61          
ATOM   1303  CA  GLU   177      14.478  19.376   0.587  1.00 16.48          
ATOM   1304  CB  GLU   177      14.155  18.135  -0.217  1.00 16.46          
ATOM   1305  CG  GLU   177      12.754  17.638   0.081  1.00 16.38          
ATOM   1306  CD  GLU   177      12.222  16.603  -0.900  1.00 19.15          
ATOM   1307  OE1 GLU   177      12.958  16.167  -1.836  1.00 21.44          
ATOM   1308  OE2 GLU   177      11.052  16.206  -0.719  1.00 19.76          
ATOM   1309  C   GLU   177      14.529  19.010   2.077  1.00 14.88          
ATOM   1310  O   GLU   177      15.556  18.529   2.563  1.00 15.38          
ATOM   1311  N   LEU   178      13.399  19.228   2.772  1.00 15.17          
ATOM   1312  CA  LEU   178      13.253  18.753   4.155  1.00 13.61          
ATOM   1313  CB  LEU   178      12.113  19.531   4.856  1.00 13.92          
ATOM   1314  CG  LEU   178      12.475  20.887   5.472  1.00 15.48          
ATOM   1315  CD1 LEU   178      13.115  21.900   4.487  1.00 13.85          
ATOM   1316  CD2 LEU   178      11.229  21.479   6.147  1.00 15.08          
ATOM   1317  C   LEU   178      12.875  17.281   4.120  1.00 13.25          
ATOM   1318  O   LEU   178      11.913  16.929   3.433  1.00 12.73          
ATOM   1319  N   LEU   179      13.622  16.438   4.860  1.00 11.69          
ATOM   1320  CA  LEU   179      13.373  14.995   4.819  1.00 12.26          
ATOM   1321  CB  LEU   179      14.454  14.296   3.953  1.00 13.90          
ATOM   1322  CG  LEU   179      14.383  14.741   2.481  1.00 13.72          
ATOM   1323  CD1 LEU   179      15.637  14.136   1.827  1.00 19.33          
ATOM   1324  CD2 LEU   179      13.119  14.238   1.798  1.00 12.85          
ATOM   1325  C   LEU   179      13.402  14.461   6.256  1.00 12.47          
ATOM   1326  O   LEU   179      14.416  14.601   6.967  1.00 13.52          
ATOM   1327  N   VAL   180      12.270  13.883   6.641  1.00 12.52          
ATOM   1328  CA  VAL   180      12.051  13.552   8.064  1.00 12.37          
ATOM   1329  CB  VAL   180      10.659  14.081   8.518  1.00 11.10          
ATOM   1330  CG1 VAL   180       9.484  13.340   7.852  1.00 12.11          
ATOM   1331  CG2 VAL   180      10.509  14.040  10.033  1.00 12.89          
ATOM   1332  C   VAL   180      12.158  12.057   8.334  1.00 12.01          
ATOM   1333  O   VAL   180      11.830  11.192   7.473  1.00 12.32          
ATOM   1334  N   TRP   181      12.605  11.732   9.540  1.00 11.76          
ATOM   1335  CA  TRP   181      12.424  10.366  10.057  1.00 12.35          
ATOM   1336  CB  TRP   181      13.645   9.465   9.812  1.00 12.62          
ATOM   1337  CG  TRP   181      13.318   7.983  10.022  1.00 13.27          
ATOM   1338  CD1 TRP   181      13.602   7.222  11.107  1.00 13.48          
ATOM   1339  NE1 TRP   181      13.111   5.923  10.929  1.00 15.11          
ATOM   1340  CE2 TRP   181      12.471   5.871   9.713  1.00 13.59          
ATOM   1341  CD2 TRP   181      12.597   7.162   9.113  1.00 13.01          
ATOM   1342  CE3 TRP   181      12.032   7.387   7.849  1.00 16.97          
ATOM   1343  CZ3 TRP   181      11.366   6.302   7.201  1.00 18.37          
ATOM   1344  CH2 TRP   181      11.276   5.042   7.841  1.00 18.49          
ATOM   1345  CZ2 TRP   181      11.831   4.815   9.083  1.00 16.42          
ATOM   1346  C   TRP   181      12.159  10.481  11.578  1.00 13.01          
ATOM   1347  O   TRP   181      12.525  11.490  12.221  1.00 12.24          
ATOM   1348  N   TYR   182      11.524   9.455  12.130  1.00 12.62          
ATOM   1349  CA  TYR   182      11.257   9.383  13.563  1.00 12.41          
ATOM   1350  CB  TYR   182      10.559   8.031  13.882  1.00 13.88          
ATOM   1351  CG  TYR   182       9.396   7.801  12.985  1.00 13.53          
ATOM   1352  CD1 TYR   182       8.199   8.468  13.197  1.00 15.77          
ATOM   1353  CE1 TYR   182       7.108   8.281  12.303  1.00 16.10          
ATOM   1354  CZ  TYR   182       7.255   7.412  11.228  1.00 19.41          
ATOM   1355  OH  TYR   182       6.201   7.228  10.341  1.00 21.24          
ATOM   1356  CE2 TYR   182       8.446   6.764  10.988  1.00 17.81          
ATOM   1357  CD2 TYR   182       9.521   6.952  11.880  1.00 16.55          
ATOM   1358  C   TYR   182      12.559   9.484  14.370  1.00 12.43          
ATOM   1359  O   TYR   182      13.589   8.946  13.980  1.00 12.78          
ATOM   1360  N   CYS   183      12.507  10.138  15.528  1.00 12.40          
ATOM   1361  CA  CYS   183      13.605  10.058  16.477  1.00 13.48          
ATOM   1362  CB  CYS   183      13.386  11.080  17.597  1.00 14.04          
ATOM   1363  SG  CYS   183      12.010  10.667  18.715  1.00 17.39          
ATOM   1364  C   CYS   183      13.672   8.620  17.046  1.00 13.27          
ATOM   1365  O   CYS   183      12.750   7.799  16.809  1.00 13.56          
ATOM   1366  N   ARG   184      14.735   8.294  17.778  1.00 14.16          
ATOM   1367  CA  ARG   184      14.922   6.905  18.228  1.00 14.62          
ATOM   1368  CB  ARG   184      16.208   6.732  19.061  1.00 16.37          
ATOM   1369  CG  ARG   184      16.219   5.370  19.761  1.00 17.38          
ATOM   1370  CD  ARG   184      17.595   4.962  20.293  1.00 23.67          
ATOM   1371  NE  ARG   184      18.003   5.887  21.324  1.00 26.32          
ATOM   1372  CZ  ARG   184      19.095   5.728  22.073  1.00 30.34          
ATOM   1373  NH1 ARG   184      19.893   4.668  21.889  1.00 30.39          
ATOM   1374  NH2 ARG   184      19.391   6.647  22.989  1.00 32.65          
ATOM   1375  C   ARG   184      13.724   6.385  19.028  1.00 14.23          
ATOM   1376  O   ARG   184      13.211   5.287  18.751  1.00 15.00          
ATOM   1377  N   ASP   185      13.258   7.168  19.991  1.00 14.37          
ATOM   1378  CA  ASP   185      12.202   6.659  20.881  1.00 15.64          
ATOM   1379  CB  ASP   185      12.026   7.529  22.110  1.00 16.39          
ATOM   1380  CG  ASP   185      13.241   7.426  23.092  1.00 22.81          
ATOM   1381  OD1 ASP   185      14.022   6.448  23.036  1.00 28.74          
ATOM   1382  OD2 ASP   185      13.369   8.327  23.928  1.00 31.55          
ATOM   1383  C   ASP   185      10.881   6.469  20.133  1.00 14.57          
ATOM   1384  O   ASP   185      10.145   5.472  20.356  1.00 15.97          
ATOM   1385  N   PHE   186      10.589   7.390  19.199  1.00 14.32          
ATOM   1386  CA  PHE   186       9.349   7.297  18.405  1.00 13.77          
ATOM   1387  CB  PHE   186       9.189   8.606  17.639  1.00 14.89          
ATOM   1388  CG  PHE   186       7.829   8.835  17.034  1.00 12.68          
ATOM   1389  CD1 PHE   186       7.495  10.127  16.505  1.00 12.50          
ATOM   1390  CE1 PHE   186       6.238  10.406  15.968  1.00 15.36          
ATOM   1391  CZ  PHE   186       5.260   9.412  15.911  1.00 15.41          
ATOM   1392  CE2 PHE   186       5.538   8.150  16.418  1.00 13.52          
ATOM   1393  CD2 PHE   186       6.844   7.846  16.996  1.00 13.10          
ATOM   1394  C   PHE   186       9.471   6.083  17.476  1.00 13.73          
ATOM   1395  O   PHE   186       8.557   5.245  17.420  1.00 14.66          
ATOM   1396  N   ALA   187      10.605   5.945  16.775  1.00 12.95          
ATOM   1397  CA  ALA   187      10.835   4.763  15.919  1.00 13.52          
ATOM   1398  CB  ALA   187      12.195   4.815  15.311  1.00 14.41          
ATOM   1399  C   ALA   187      10.656   3.445  16.720  1.00 15.17          
ATOM   1400  O   ALA   187      10.018   2.510  16.246  1.00 16.00          
ATOM   1401  N   GLU   188      11.140   3.428  17.955  1.00 14.73          
ATOM   1402  CA  GLU   188      11.031   2.210  18.793  1.00 16.62          
ATOM   1403  CB  GLU   188      11.935   2.326  20.015  1.00 17.03          
ATOM   1404  CG  GLU   188      13.365   2.051  19.620  1.00 20.37          
ATOM   1405  CD  GLU   188      14.305   1.915  20.788  1.00 29.43          
ATOM   1406  OE1 GLU   188      13.906   2.238  21.920  1.00 33.14          
ATOM   1407  OE2 GLU   188      15.467   1.504  20.552  1.00 33.89          
ATOM   1408  C   GLU   188       9.570   1.929  19.170  1.00 17.20          
ATOM   1409  O   GLU   188       9.162   0.781  19.173  1.00 18.74          
ATOM   1410  N   ARG   189       8.770   2.963  19.423  1.00 17.20          
ATOM   1411  CA  ARG   189       7.334   2.729  19.658  1.00 17.74          
ATOM   1412  CB  ARG   189       6.586   4.007  20.014  1.00 15.81          
ATOM   1413  CG  ARG   189       7.045   4.653  21.339  1.00 16.40          
ATOM   1414  CD  ARG   189       6.101   5.707  21.793  1.00 18.68          
ATOM   1415  NE  ARG   189       6.129   6.936  20.978  1.00 18.77          
ATOM   1416  CZ  ARG   189       6.994   7.936  21.150  1.00 17.68          
ATOM   1417  NH1 ARG   189       7.944   7.883  22.086  1.00 18.36          
ATOM   1418  NH2 ARG   189       6.915   9.003  20.355  1.00 14.81          
ATOM   1419  C   ARG   189       6.672   2.059  18.459  1.00 17.30          
ATOM   1420  O   ARG   189       5.728   1.290  18.628  1.00 19.10          
ATOM   1421  N   LEU   190       7.130   2.386  17.248  1.00 15.86          
ATOM   1422  CA  LEU   190       6.572   1.877  15.989  1.00 17.58          
ATOM   1423  CB  LEU   190       6.771   2.934  14.894  1.00 17.31          
ATOM   1424  CG  LEU   190       6.171   4.310  15.085  1.00 20.54          
ATOM   1425  CD1 LEU   190       6.435   5.230  13.884  1.00 18.58          
ATOM   1426  CD2 LEU   190       4.685   4.245  15.320  1.00 20.99          
ATOM   1427  C   LEU   190       7.238   0.577  15.518  1.00 18.20          
ATOM   1428  O   LEU   190       6.847   0.011  14.452  1.00 20.33          
ATOM   1429  N   HSD   191       8.223   0.092  16.287  1.00 18.24          
ATOM   1430  CA  HSD   191       9.076  -1.041  15.855  1.00 19.88          
ATOM   1431  CB  HSD   191       8.316  -2.385  15.937  1.00 21.68          
ATOM   1432  CG  HSD   191       7.851  -2.693  17.312  1.00 23.50          
ATOM   1433  ND1 HSD   191       8.678  -3.249  18.268  1.00 27.79          
ATOM   1434  CE1 HSD   191       8.012  -3.359  19.406  1.00 29.95          
ATOM   1435  NE2 HSD   191       6.793  -2.877  19.224  1.00 30.60          
ATOM   1436  CD2 HSD   191       6.671  -2.445  17.927  1.00 28.25          
ATOM   1437  C   HSD   191       9.639  -0.785  14.466  1.00 19.39          
ATOM   1438  O   HSD   191       9.695  -1.682  13.599  1.00 20.57          
ATOM   1439  N   TYR   192      10.062   0.462  14.261  1.00 18.10          
ATOM   1440  CA  TYR   192      10.781   0.887  13.034  1.00 19.13          
ATOM   1441  CB  TYR   192      10.237   2.244  12.565  1.00 21.41          
ATOM   1442  CG  TYR   192       9.025   2.180  11.683  1.00 23.50          
ATOM   1443  CD1 TYR   192       8.276   1.001  11.557  1.00 25.87          
ATOM   1444  CE1 TYR   192       7.148   0.953  10.759  1.00 29.21          
ATOM   1445  CZ  TYR   192       6.757   2.093  10.080  1.00 29.83          
ATOM   1446  OH  TYR   192       5.646   2.042   9.266  1.00 31.25          
ATOM   1447  CE2 TYR   192       7.469   3.267  10.199  1.00 29.65          
ATOM   1448  CD2 TYR   192       8.606   3.299  10.999  1.00 27.97          
ATOM   1449  C   TYR   192      12.310   1.009  13.257  1.00 18.84          
ATOM   1450  O   TYR   192      12.773   1.253  14.389  1.00 18.35          
ATOM   1451  N   PRO   193      13.096   0.883  12.166  1.00 18.14          
ATOM   1452  CA  PRO   193      14.542   1.126  12.215  1.00 18.36          
ATOM   1453  CB  PRO   193      15.016   0.688  10.819  1.00 18.99          
ATOM   1454  CG  PRO   193      13.827   0.957   9.928  1.00 20.21          
ATOM   1455  CD  PRO   193      12.635   0.551  10.799  1.00 19.24          
ATOM   1456  C   PRO   193      14.727   2.639  12.336  1.00 17.58          
ATOM   1457  O   PRO   193      13.765   3.413  12.107  1.00 17.22          
ATOM   1458  N   TYR   194      15.937   3.036  12.680  1.00 18.57          
ATOM   1459  CA  TYR   194      16.259   4.464  12.842  1.00 18.20          
ATOM   1460  CB  TYR   194      15.782   4.974  14.221  1.00 19.10          
ATOM   1461  CG  TYR   194      16.283   4.154  15.391  1.00 18.80          
ATOM   1462  CD1 TYR   194      17.480   4.484  16.052  1.00 20.15          
ATOM   1463  CE1 TYR   194      17.939   3.704  17.131  1.00 21.36          
ATOM   1464  CZ  TYR   194      17.193   2.600  17.540  1.00 21.29          
ATOM   1465  OH  TYR   194      17.633   1.811  18.594  1.00 23.89          
ATOM   1466  CE2 TYR   194      16.017   2.261  16.885  1.00 19.66          
ATOM   1467  CD2 TYR   194      15.571   3.029  15.835  1.00 20.06          
ATOM   1468  C   TYR   194      17.753   4.708  12.678  1.00 18.24          
ATOM   1469  O   TYR   194      18.579   3.818  12.950  1.00 17.51          
ATOM   1470  N   PRO   195      18.126   5.933  12.251  1.00 17.99          
ATOM   1471  CA  PRO   195      19.548   6.248  12.181  1.00 18.36          
ATOM   1472  CB  PRO   195      19.575   7.741  11.734  1.00 17.90          
ATOM   1473  CG  PRO   195      18.279   7.937  11.038  1.00 17.98          
ATOM   1474  CD  PRO   195      17.288   7.051  11.793  1.00 18.19          
ATOM   1475  C   PRO   195      20.245   6.033  13.538  1.00 18.55          
ATOM   1476  O   PRO   195      19.716   6.414  14.594  1.00 18.18          
END
