
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1603),  selected  104 , name 1wey_A
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 1wey_A.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      D      24           #
LGA    -       -      N      25           -
LGA    S     6_A      C      26          1.185
LGA    G     7_A      T      27          0.629
LGA    L     8_A      S      28          0.293
LGA    I     9_A      K      29          0.682
LGA    A    10_A      F      30          0.538
LGA    C    11_A      S      31          1.120
LGA    V    12_A      R      32          2.007
LGA    A    13_A      F      33          2.475
LGA    N    14_A      F      34          3.340
LGA    -       -      A      35           -
LGA    -       -      T      36           -
LGA    D    15_A      R      37          3.734
LGA    D    16_A      E      38          2.662
LGA    V    17_A      E      39          4.581
LGA    F    18_A      A      40          3.386
LGA    S    19_A      E      41          2.988
LGA    E    20_A      -       -           -
LGA    S    21_A      -       -           -
LGA    E    22_A      S      42          5.106
LGA    T    23_A      F      43          4.367
LGA    R    24_A      M      44          2.515
LGA    A    25_A      T      45          1.753
LGA    K    26_A      K      46          1.397
LGA    F    27_A      L      47          1.870
LGA    E    28_A      K      48          1.423
LGA    S    29_A      E      49          0.950
LGA    L    30_A      L      50          1.214
LGA    F    31_A      A      51          2.023
LGA    R    32_A      A      52          2.052
LGA    T    33_A      A      53          1.397
LGA    Y    34_A      A      54          1.549
LGA    D    35_A      S      55          0.569
LGA    K    36_A      S      56          2.808
LGA    D    37_A      A      57          3.772
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    -       -      G      60           -
LGA    T    38_A      A      61          0.527
LGA    T    39_A      S      62          1.228
LGA    F    40_A      V      63          1.289
LGA    Q    41_A      A      64          1.207
LGA    Y    42_A      Y      65          1.027
LGA    F    43_A      K      66          0.735
LGA    K    44_A      I      67          1.291
LGA    S    45_A      K      68          1.042
LGA    -       -      D      69           -
LGA    -       -      L      70           -
LGA    -       -      E      71           -
LGA    -       -      G      72           -
LGA    -       -      Q      73           -
LGA    -       -      V      74           -
LGA    F    46_A      E      75          4.349
LGA    K    47_A      L      76          2.746
LGA    R    48_A      D      77          1.176
LGA    V    49_A      A      78          0.977
LGA    R    50_A      A      79          0.517
LGA    I    51_A      F      80          0.791
LGA    N    52_A      T      81          0.856
LGA    F    53_A      F      82          0.755
LGA    S    54_A      S      83          1.548
LGA    N    55_A      C      84          1.164
LGA    P    56_A      Q      85          1.247
LGA    L    57_A      A      86          0.994
LGA    S    58_A      E      87          0.531
LGA    A    59_A      M      88          0.314
LGA    A    60_A      I      89          1.020
LGA    D    61_A      I      90          0.515
LGA    A    62_A      F      91          0.650
LGA    R    63_A      E      92          1.154
LGA    L    64_A      L      93          1.182
LGA    R    65_A      S      94          1.144
LGA    L    66_A      L      95          1.060
LGA    H    67_A      R      96          3.323
LGA    K    68_A      S      97           #
LGA    T    69_A      L      98          4.915
LGA    E    70_A      A      99          3.567
LGA    F    71_A      -       -           -
LGA    L    72_A      -       -           -
LGA    G    73_A      -       -           -
LGA    K    74_A      -       -           -
LGA    E    75_A      -       -           -
LGA    M    76_A      -       -           -
LGA    K    77_A      -       -           -
LGA    L    78_A      -       -           -
LGA    Y    79_A      -       -           -
LGA    F    80_A      -       -           -
LGA    A    81_A      -       -           -
LGA    Q    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    L    84_A      -       -           -
LGA    H    85_A      -       -           -
LGA    I    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    S    88_A      -       -           -
LGA    S    89_A      -       -           -
LGA    H    90_A      -       -           -
LGA    L    91_A      -       -           -
LGA    A    92_A      -       -           -
LGA    P    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    N    95_A      -       -           -
LGA    P    96_A      -       -           -
LGA    D    97_A      -       -           -
LGA    K    98_A      -       -           -
LGA    S    99_A      -       -           -
LGA    G   100_A      -       -           -
LGA    P   101_A      -       -           -
LGA    S   102_A      -       -           -
LGA    S   103_A      -       -           -
LGA    G   104_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104   76    5.0     62    2.16    11.29     70.925     2.745

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.864501 * X  +  -0.370769 * Y  +  -0.339364 * Z  +  -4.604105
  Y_new =  -0.062128 * X  +  -0.591174 * Y  +   0.804147 * Z  +  -5.528479
  Z_new =  -0.498776 * X  +   0.716270 * Y  +   0.488036 * Z  +   1.609540 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.972692   -2.168900  [ DEG:    55.7312   -124.2688 ]
  Theta =   0.522186    2.619406  [ DEG:    29.9191    150.0809 ]
  Phi   =  -3.069851    0.071742  [ DEG:  -175.8895      4.1105 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wey_A                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wey_A.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104   76   5.0   62   2.16   11.29  70.925
REMARK  ---------------------------------------------------------- 
MOLECULE 1wey_A
HEADER    RNA BINDING PROTEIN                     25-MAY-04   1WEY              
TITLE     SOLUTION STRUCTURE OF RRM DOMAIN IN CALCIPRESSIN 1                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CALCIPRESSIN 1;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RRM DOMAIN;                                                
COMPND   5 SYNONYM: DOWN SYNDROME CRITICAL REGION PROTEIN 1, MYOCYTE-           
COMPND   6 ENRICHED CALCINEURIN INTERACTIN PROTEIN 1, CALCINEURIN               
COMPND   7 INHIBITOR;                                                           
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: RIKEN CDNA 5033405J21;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040113-35;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, STRUCTURAL GENOMICS, RRM DOMAIN, CALCIPRESSIN 1, RIKEN           
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    F.HE,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,S.YOKOYAMA,          
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   25-NOV-04 1WEY    0                                                
JRNL        AUTH   F.HE,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,            
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF RRM DOMAIN IN CALCIPRESSIN 1           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1WEY A    8    98  UNP    Q9JHG6   CCP1_MOUSE      13    103             
SEQRES   1 A  104  GLY SER SER GLY SER SER GLY LEU ILE ALA CYS VAL ALA          
SEQRES   2 A  104  ASN ASP ASP VAL PHE SER GLU SER GLU THR ARG ALA LYS          
SEQRES   3 A  104  PHE GLU SER LEU PHE ARG THR TYR ASP LYS ASP THR THR          
SEQRES   4 A  104  PHE GLN TYR PHE LYS SER PHE LYS ARG VAL ARG ILE ASN          
SEQRES   5 A  104  PHE SER ASN PRO LEU SER ALA ALA ASP ALA ARG LEU ARG          
SEQRES   6 A  104  LEU HIS LYS THR GLU PHE LEU GLY LYS GLU MET LYS LEU          
SEQRES   7 A  104  TYR PHE ALA GLN THR LEU HIS ILE GLY SER SER HIS LEU          
SEQRES   8 A  104  ALA PRO PRO ASN PRO ASP LYS SER GLY PRO SER SER GLY          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1       2.551 -17.673  14.479  1.00  0.00           N  
ATOM      2  CA  GLY A   1       1.287 -16.971  14.349  1.00  0.00           C  
ATOM      3  C   GLY A   1       0.369 -17.613  13.327  1.00  0.00           C  
ATOM      4  O   GLY A   1       0.180 -17.082  12.234  1.00  0.00           O  
ATOM      5  HA2 GLY A   1       0.790 -16.963  15.309  1.00  0.00           H  
ATOM      6  HA3 GLY A   1       1.484 -15.952  14.049  1.00  0.00           H  
ATOM      7  H1  GLY A   1       2.613 -18.616  14.220  1.00  0.00           H  
ATOM      8  N   SER A   2      -0.199 -18.760  13.683  1.00  0.00           N  
ATOM      9  CA  SER A   2      -1.098 -19.479  12.787  1.00  0.00           C  
ATOM     10  C   SER A   2      -2.049 -18.514  12.083  1.00  0.00           C  
ATOM     11  O   SER A   2      -2.101 -18.461  10.855  1.00  0.00           O  
ATOM     12  CB  SER A   2      -1.898 -20.525  13.563  1.00  0.00           C  
ATOM     13  OG  SER A   2      -2.317 -21.579  12.714  1.00  0.00           O  
ATOM     14  H   SER A   2      -0.010 -19.133  14.570  1.00  0.00           H  
ATOM     15  HA  SER A   2      -0.496 -19.977  12.043  1.00  0.00           H  
ATOM     16  HB2 SER A   2      -1.282 -20.935  14.349  1.00  0.00           H  
ATOM     17  HB3 SER A   2      -2.771 -20.060  13.996  1.00  0.00           H  
ATOM     18  HG  SER A   2      -3.107 -21.987  13.074  1.00  0.00           H  
ATOM     19  N   SER A   3      -2.800 -17.752  12.873  1.00  0.00           N  
ATOM     20  CA  SER A   3      -3.753 -16.792  12.327  1.00  0.00           C  
ATOM     21  C   SER A   3      -3.234 -15.367  12.482  1.00  0.00           C  
ATOM     22  O   SER A   3      -3.423 -14.735  13.520  1.00  0.00           O  
ATOM     23  CB  SER A   3      -5.107 -16.934  13.024  1.00  0.00           C  
ATOM     24  OG  SER A   3      -6.056 -17.556  12.176  1.00  0.00           O  
ATOM     25  H   SER A   3      -2.714 -17.841  13.845  1.00  0.00           H  
ATOM     26  HA  SER A   3      -3.875 -17.007  11.276  1.00  0.00           H  
ATOM     27  HB2 SER A   3      -4.990 -17.533  13.914  1.00  0.00           H  
ATOM     28  HB3 SER A   3      -5.473 -15.954  13.296  1.00  0.00           H  
ATOM     29  HG  SER A   3      -6.923 -17.522  12.584  1.00  0.00           H  
ATOM     30  N   GLY A   4      -2.581 -14.865  11.439  1.00  0.00           N  
ATOM     31  CA  GLY A   4      -2.044 -13.516  11.478  1.00  0.00           C  
ATOM     32  C   GLY A   4      -2.780 -12.572  10.548  1.00  0.00           C  
ATOM     33  O   GLY A   4      -3.342 -12.999   9.538  1.00  0.00           O  
ATOM     34  H   GLY A   4      -2.459 -15.414  10.637  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      -2.118 -13.140  12.487  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      -1.003 -13.546  11.190  1.00  0.00           H  
ATOM     37  N   SER A   5      -2.779 -11.288  10.888  1.00  0.00           N  
ATOM     38  CA  SER A   5      -3.456 -10.283  10.077  1.00  0.00           C  
ATOM     39  C   SER A   5      -2.478  -9.600   9.126  1.00  0.00           C  
ATOM     40  O   SER A   5      -1.440  -9.089   9.547  1.00  0.00           O  
ATOM     41  CB  SER A   5      -4.122  -9.238  10.976  1.00  0.00           C  
ATOM     42  OG  SER A   5      -5.006  -8.415  10.233  1.00  0.00           O  
ATOM     43  H   SER A   5      -2.313 -11.010  11.704  1.00  0.00           H  
ATOM     44  HA  SER A   5      -4.217 -10.781   9.495  1.00  0.00           H  
ATOM     45  HB2 SER A   5      -4.684  -9.738  11.751  1.00  0.00           H  
ATOM     46  HB3 SER A   5      -3.362  -8.616  11.426  1.00  0.00           H  
ATOM     47  HG  SER A   5      -5.630  -7.994  10.830  1.00  0.00           H  
ATOM     48  N   SER A   6      -2.815  -9.598   7.841  1.00  0.00           N  
ATOM     49  CA  SER A   6      -1.966  -8.983   6.828  1.00  0.00           C  
ATOM     50  C   SER A   6      -2.807  -8.359   5.718  1.00  0.00           C  
ATOM     51  O   SER A   6      -2.672  -8.713   4.548  1.00  0.00           O  
ATOM     52  CB  SER A   6      -1.009 -10.021   6.236  1.00  0.00           C  
ATOM     53  OG  SER A   6      -1.706 -11.194   5.853  1.00  0.00           O  
ATOM     54  H   SER A   6      -3.656 -10.021   7.567  1.00  0.00           H  
ATOM     55  HA  SER A   6      -1.389  -8.206   7.307  1.00  0.00           H  
ATOM     56  HB2 SER A   6      -0.525  -9.604   5.368  1.00  0.00           H  
ATOM     57  HB3 SER A   6      -0.266 -10.283   6.975  1.00  0.00           H  
ATOM     58  HG  SER A   6      -2.041 -11.639   6.634  1.00  0.00           H  
ATOM     59  N   GLY A   7      -3.676  -7.427   6.098  1.00  0.00           N  
ATOM     60  CA  GLY A   7      -4.528  -6.769   5.124  1.00  0.00           C  
ATOM     61  C   GLY A   7      -4.281  -5.275   5.055  1.00  0.00           C  
ATOM     62  O   GLY A   7      -3.531  -4.724   5.863  1.00  0.00           O  
ATOM     63  H   GLY A   7      -3.740  -7.186   7.045  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      -4.343  -7.198   4.150  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      -5.560  -6.939   5.391  1.00  0.00           H  
ATOM     66  N   LEU A   8      -4.911  -4.615   4.089  1.00  0.00           N  
ATOM     67  CA  LEU A   8      -4.754  -3.175   3.916  1.00  0.00           C  
ATOM     68  C   LEU A   8      -5.979  -2.573   3.235  1.00  0.00           C  
ATOM     69  O   LEU A   8      -6.442  -3.075   2.211  1.00  0.00           O  
ATOM     70  CB  LEU A   8      -3.499  -2.873   3.097  1.00  0.00           C  
ATOM     71  CG  LEU A   8      -2.177  -2.883   3.864  1.00  0.00           C  
ATOM     72  CD1 LEU A   8      -1.001  -2.852   2.902  1.00  0.00           C  
ATOM     73  CD2 LEU A   8      -2.112  -1.708   4.827  1.00  0.00           C  
ATOM     74  H   LEU A   8      -5.496  -5.109   3.476  1.00  0.00           H  
ATOM     75  HA  LEU A   8      -4.650  -2.735   4.896  1.00  0.00           H  
ATOM     76  HB2 LEU A   8      -3.431  -3.612   2.312  1.00  0.00           H  
ATOM     77  HB3 LEU A   8      -3.620  -1.893   2.656  1.00  0.00           H  
ATOM     78  HG  LEU A   8      -2.111  -3.794   4.442  1.00  0.00           H  
ATOM     79 HD11 LEU A   8      -0.383  -1.992   3.115  1.00  0.00           H  
ATOM     80 HD12 LEU A   8      -1.366  -2.790   1.887  1.00  0.00           H  
ATOM     81 HD13 LEU A   8      -0.417  -3.753   3.018  1.00  0.00           H  
ATOM     82 HD21 LEU A   8      -3.112  -1.439   5.138  1.00  0.00           H  
ATOM     83 HD22 LEU A   8      -1.649  -0.863   4.335  1.00  0.00           H  
ATOM     84 HD23 LEU A   8      -1.529  -1.983   5.694  1.00  0.00           H  
ATOM     85  N   ILE A   9      -6.497  -1.491   3.808  1.00  0.00           N  
ATOM     86  CA  ILE A   9      -7.665  -0.820   3.254  1.00  0.00           C  
ATOM     87  C   ILE A   9      -7.258   0.390   2.419  1.00  0.00           C  
ATOM     88  O   ILE A   9      -7.021   1.474   2.952  1.00  0.00           O  
ATOM     89  CB  ILE A   9      -8.630  -0.361   4.363  1.00  0.00           C  
ATOM     90  CG1 ILE A   9      -8.871  -1.497   5.360  1.00  0.00           C  
ATOM     91  CG2 ILE A   9      -9.945   0.109   3.760  1.00  0.00           C  
ATOM     92  CD1 ILE A   9      -9.824  -2.555   4.851  1.00  0.00           C  
ATOM     93  H   ILE A   9      -6.083  -1.137   4.623  1.00  0.00           H  
ATOM     94  HA  ILE A   9      -8.184  -1.522   2.619  1.00  0.00           H  
ATOM     95  HB  ILE A   9      -8.181   0.472   4.879  1.00  0.00           H  
ATOM     96 HG12 ILE A   9      -7.931  -1.977   5.583  1.00  0.00           H  
ATOM     97 HG13 ILE A   9      -9.285  -1.086   6.269  1.00  0.00           H  
ATOM     98 HG21 ILE A   9     -10.267  -0.596   3.006  1.00  0.00           H  
ATOM     99 HG22 ILE A   9     -10.695   0.172   4.534  1.00  0.00           H  
ATOM    100 HG23 ILE A   9      -9.810   1.080   3.309  1.00  0.00           H  
ATOM    101 HD11 ILE A   9     -10.067  -3.238   5.652  1.00  0.00           H  
ATOM    102 HD12 ILE A   9     -10.727  -2.086   4.491  1.00  0.00           H  
ATOM    103 HD13 ILE A   9      -9.358  -3.103   4.044  1.00  0.00           H  
ATOM    104  N   ALA A  10      -7.179   0.199   1.107  1.00  0.00           N  
ATOM    105  CA  ALA A  10      -6.806   1.274   0.197  1.00  0.00           C  
ATOM    106  C   ALA A  10      -8.021   2.105  -0.202  1.00  0.00           C  
ATOM    107  O   ALA A  10      -9.014   1.571  -0.698  1.00  0.00           O  
ATOM    108  CB  ALA A  10      -6.124   0.708  -1.039  1.00  0.00           C  
ATOM    109  H   ALA A  10      -7.381  -0.689   0.741  1.00  0.00           H  
ATOM    110  HA  ALA A  10      -6.098   1.912   0.708  1.00  0.00           H  
ATOM    111  HB1 ALA A  10      -6.785   0.800  -1.888  1.00  0.00           H  
ATOM    112  HB2 ALA A  10      -5.212   1.254  -1.230  1.00  0.00           H  
ATOM    113  HB3 ALA A  10      -5.891  -0.334  -0.876  1.00  0.00           H  
ATOM    114  N   CYS A  11      -7.938   3.411   0.021  1.00  0.00           N  
ATOM    115  CA  CYS A  11      -9.032   4.316  -0.314  1.00  0.00           C  
ATOM    116  C   CYS A  11      -8.765   5.026  -1.637  1.00  0.00           C  
ATOM    117  O   CYS A  11      -7.882   5.877  -1.729  1.00  0.00           O  
ATOM    118  CB  CYS A  11      -9.231   5.344   0.800  1.00  0.00           C  
ATOM    119  SG  CYS A  11     -10.905   5.382   1.480  1.00  0.00           S  
ATOM    120  H   CYS A  11      -7.120   3.777   0.419  1.00  0.00           H  
ATOM    121  HA  CYS A  11      -9.930   3.725  -0.411  1.00  0.00           H  
ATOM    122  HB2 CYS A  11      -8.553   5.120   1.611  1.00  0.00           H  
ATOM    123  HB3 CYS A  11      -9.007   6.328   0.416  1.00  0.00           H  
ATOM    124  HG  CYS A  11     -10.964   6.364   2.367  1.00  0.00           H  
ATOM    125  N   VAL A  12      -9.534   4.667  -2.660  1.00  0.00           N  
ATOM    126  CA  VAL A  12      -9.381   5.271  -3.979  1.00  0.00           C  
ATOM    127  C   VAL A  12     -10.483   6.288  -4.250  1.00  0.00           C  
ATOM    128  O   VAL A  12     -11.645   6.064  -3.912  1.00  0.00           O  
ATOM    129  CB  VAL A  12      -9.399   4.203  -5.090  1.00  0.00           C  
ATOM    130  CG1 VAL A  12      -8.543   4.644  -6.269  1.00  0.00           C  
ATOM    131  CG2 VAL A  12      -8.923   2.863  -4.548  1.00  0.00           C  
ATOM    132  H   VAL A  12     -10.222   3.982  -2.525  1.00  0.00           H  
ATOM    133  HA  VAL A  12      -8.425   5.773  -4.009  1.00  0.00           H  
ATOM    134  HB  VAL A  12     -10.417   4.087  -5.435  1.00  0.00           H  
ATOM    135 HG11 VAL A  12      -7.553   4.895  -5.920  1.00  0.00           H  
ATOM    136 HG12 VAL A  12      -8.482   3.841  -6.989  1.00  0.00           H  
ATOM    137 HG13 VAL A  12      -8.991   5.511  -6.733  1.00  0.00           H  
ATOM    138 HG21 VAL A  12      -8.744   2.187  -5.370  1.00  0.00           H  
ATOM    139 HG22 VAL A  12      -8.007   3.003  -3.992  1.00  0.00           H  
ATOM    140 HG23 VAL A  12      -9.679   2.450  -3.898  1.00  0.00           H  
ATOM    141  N   ALA A  13     -10.111   7.407  -4.863  1.00  0.00           N  
ATOM    142  CA  ALA A  13     -11.068   8.459  -5.182  1.00  0.00           C  
ATOM    143  C   ALA A  13     -11.574   8.325  -6.613  1.00  0.00           C  
ATOM    144  O   ALA A  13     -12.611   8.883  -6.971  1.00  0.00           O  
ATOM    145  CB  ALA A  13     -10.438   9.828  -4.967  1.00  0.00           C  
ATOM    146  H   ALA A  13      -9.169   7.528  -5.106  1.00  0.00           H  
ATOM    147  HA  ALA A  13     -11.905   8.364  -4.504  1.00  0.00           H  
ATOM    148  HB1 ALA A  13      -9.365   9.748  -5.057  1.00  0.00           H  
ATOM    149  HB2 ALA A  13     -10.812  10.515  -5.712  1.00  0.00           H  
ATOM    150  HB3 ALA A  13     -10.692  10.190  -3.982  1.00  0.00           H  
ATOM    151  N   ASN A  14     -10.834   7.581  -7.430  1.00  0.00           N  
ATOM    152  CA  ASN A  14     -11.208   7.376  -8.825  1.00  0.00           C  
ATOM    153  C   ASN A  14     -12.359   6.380  -8.938  1.00  0.00           C  
ATOM    154  O   ASN A  14     -12.155   5.169  -8.855  1.00  0.00           O  
ATOM    155  CB  ASN A  14     -10.006   6.876  -9.628  1.00  0.00           C  
ATOM    156  CG  ASN A  14      -8.746   7.671  -9.339  1.00  0.00           C  
ATOM    157  OD1 ASN A  14      -8.556   8.171  -8.231  1.00  0.00           O  
ATOM    158  ND2 ASN A  14      -7.881   7.792 -10.339  1.00  0.00           N  
ATOM    159  H   ASN A  14     -10.018   7.162  -7.088  1.00  0.00           H  
ATOM    160  HA  ASN A  14     -11.528   8.325  -9.226  1.00  0.00           H  
ATOM    161  HB2 ASN A  14      -9.819   5.841  -9.381  1.00  0.00           H  
ATOM    162  HB3 ASN A  14     -10.226   6.956 -10.682  1.00  0.00           H  
ATOM    163 HD21 ASN A  14      -8.100   7.368 -11.196  1.00  0.00           H  
ATOM    164 HD22 ASN A  14      -7.059   8.300 -10.179  1.00  0.00           H  
ATOM    165  N   ASP A  15     -13.566   6.900  -9.130  1.00  0.00           N  
ATOM    166  CA  ASP A  15     -14.750   6.057  -9.256  1.00  0.00           C  
ATOM    167  C   ASP A  15     -14.587   5.061 -10.400  1.00  0.00           C  
ATOM    168  O   ASP A  15     -15.267   4.034 -10.444  1.00  0.00           O  
ATOM    169  CB  ASP A  15     -15.992   6.918  -9.486  1.00  0.00           C  
ATOM    170  CG  ASP A  15     -15.818   7.893 -10.634  1.00  0.00           C  
ATOM    171  OD1 ASP A  15     -14.947   8.783 -10.529  1.00  0.00           O  
ATOM    172  OD2 ASP A  15     -16.551   7.766 -11.637  1.00  0.00           O  
ATOM    173  H   ASP A  15     -13.665   7.873  -9.186  1.00  0.00           H  
ATOM    174  HA  ASP A  15     -14.869   5.510  -8.333  1.00  0.00           H  
ATOM    175  HB2 ASP A  15     -16.832   6.275  -9.709  1.00  0.00           H  
ATOM    176  HB3 ASP A  15     -16.204   7.481  -8.588  1.00  0.00           H  
ATOM    177  N   ASP A  16     -13.685   5.370 -11.324  1.00  0.00           N  
ATOM    178  CA  ASP A  16     -13.433   4.503 -12.468  1.00  0.00           C  
ATOM    179  C   ASP A  16     -12.800   3.188 -12.024  1.00  0.00           C  
ATOM    180  O   ASP A  16     -13.209   2.111 -12.461  1.00  0.00           O  
ATOM    181  CB  ASP A  16     -12.523   5.205 -13.477  1.00  0.00           C  
ATOM    182  CG  ASP A  16     -13.149   6.465 -14.041  1.00  0.00           C  
ATOM    183  OD1 ASP A  16     -13.607   7.308 -13.242  1.00  0.00           O  
ATOM    184  OD2 ASP A  16     -13.182   6.608 -15.281  1.00  0.00           O  
ATOM    185  H   ASP A  16     -13.175   6.203 -11.233  1.00  0.00           H  
ATOM    186  HA  ASP A  16     -14.381   4.292 -12.938  1.00  0.00           H  
ATOM    187  HB2 ASP A  16     -11.596   5.472 -12.992  1.00  0.00           H  
ATOM    188  HB3 ASP A  16     -12.316   4.530 -14.295  1.00  0.00           H  
ATOM    189  N   VAL A  17     -11.801   3.280 -11.152  1.00  0.00           N  
ATOM    190  CA  VAL A  17     -11.113   2.099 -10.649  1.00  0.00           C  
ATOM    191  C   VAL A  17     -12.104   1.004 -10.273  1.00  0.00           C  
ATOM    192  O   VAL A  17     -11.756  -0.176 -10.230  1.00  0.00           O  
ATOM    193  CB  VAL A  17     -10.246   2.435  -9.420  1.00  0.00           C  
ATOM    194  CG1 VAL A  17      -9.885   1.169  -8.658  1.00  0.00           C  
ATOM    195  CG2 VAL A  17      -8.993   3.189  -9.843  1.00  0.00           C  
ATOM    196  H   VAL A  17     -11.521   4.167 -10.840  1.00  0.00           H  
ATOM    197  HA  VAL A  17     -10.463   1.732 -11.430  1.00  0.00           H  
ATOM    198  HB  VAL A  17     -10.820   3.072  -8.763  1.00  0.00           H  
ATOM    199 HG11 VAL A  17     -10.733   0.847  -8.073  1.00  0.00           H  
ATOM    200 HG12 VAL A  17      -9.613   0.392  -9.359  1.00  0.00           H  
ATOM    201 HG13 VAL A  17      -9.050   1.370  -8.002  1.00  0.00           H  
ATOM    202 HG21 VAL A  17      -8.441   3.488  -8.964  1.00  0.00           H  
ATOM    203 HG22 VAL A  17      -8.377   2.548 -10.456  1.00  0.00           H  
ATOM    204 HG23 VAL A  17      -9.274   4.066 -10.408  1.00  0.00           H  
ATOM    205  N   PHE A  18     -13.343   1.402 -10.000  1.00  0.00           N  
ATOM    206  CA  PHE A  18     -14.386   0.455  -9.628  1.00  0.00           C  
ATOM    207  C   PHE A  18     -15.098  -0.085 -10.865  1.00  0.00           C  
ATOM    208  O   PHE A  18     -16.322  -0.222 -10.878  1.00  0.00           O  
ATOM    209  CB  PHE A  18     -15.397   1.119  -8.691  1.00  0.00           C  
ATOM    210  CG  PHE A  18     -14.809   1.541  -7.375  1.00  0.00           C  
ATOM    211  CD1 PHE A  18     -13.971   2.641  -7.296  1.00  0.00           C  
ATOM    212  CD2 PHE A  18     -15.093   0.836  -6.217  1.00  0.00           C  
ATOM    213  CE1 PHE A  18     -13.428   3.031  -6.087  1.00  0.00           C  
ATOM    214  CE2 PHE A  18     -14.553   1.221  -5.004  1.00  0.00           C  
ATOM    215  CZ  PHE A  18     -13.719   2.320  -4.939  1.00  0.00           C  
ATOM    216  H   PHE A  18     -13.559   2.356 -10.051  1.00  0.00           H  
ATOM    217  HA  PHE A  18     -13.916  -0.368  -9.111  1.00  0.00           H  
ATOM    218  HB2 PHE A  18     -15.797   1.999  -9.171  1.00  0.00           H  
ATOM    219  HB3 PHE A  18     -16.201   0.426  -8.490  1.00  0.00           H  
ATOM    220  HD1 PHE A  18     -13.743   3.198  -8.193  1.00  0.00           H  
ATOM    221  HD2 PHE A  18     -15.746  -0.024  -6.266  1.00  0.00           H  
ATOM    222  HE1 PHE A  18     -12.776   3.890  -6.040  1.00  0.00           H  
ATOM    223  HE2 PHE A  18     -14.783   0.663  -4.108  1.00  0.00           H  
ATOM    224  HZ  PHE A  18     -13.296   2.623  -3.993  1.00  0.00           H  
ATOM    225  N   SER A  19     -14.325  -0.387 -11.902  1.00  0.00           N  
ATOM    226  CA  SER A  19     -14.882  -0.906 -13.145  1.00  0.00           C  
ATOM    227  C   SER A  19     -14.002  -2.018 -13.712  1.00  0.00           C  
ATOM    228  O   SER A  19     -12.812  -2.098 -13.408  1.00  0.00           O  
ATOM    229  CB  SER A  19     -15.027   0.218 -14.172  1.00  0.00           C  
ATOM    230  OG  SER A  19     -15.987  -0.115 -15.160  1.00  0.00           O  
ATOM    231  H   SER A  19     -13.355  -0.256 -11.829  1.00  0.00           H  
ATOM    232  HA  SER A  19     -15.857  -1.312 -12.927  1.00  0.00           H  
ATOM    233  HB2 SER A  19     -15.341   1.121 -13.671  1.00  0.00           H  
ATOM    234  HB3 SER A  19     -14.075   0.385 -14.654  1.00  0.00           H  
ATOM    235  HG  SER A  19     -15.880   0.464 -15.918  1.00  0.00           H  
ATOM    236  N   GLU A  20     -14.598  -2.874 -14.536  1.00  0.00           N  
ATOM    237  CA  GLU A  20     -13.870  -3.982 -15.144  1.00  0.00           C  
ATOM    238  C   GLU A  20     -13.144  -3.527 -16.407  1.00  0.00           C  
ATOM    239  O   GLU A  20     -12.410  -4.297 -17.025  1.00  0.00           O  
ATOM    240  CB  GLU A  20     -14.827  -5.128 -15.475  1.00  0.00           C  
ATOM    241  CG  GLU A  20     -15.951  -4.730 -16.417  1.00  0.00           C  
ATOM    242  CD  GLU A  20     -15.914  -5.495 -17.726  1.00  0.00           C  
ATOM    243  OE1 GLU A  20     -16.304  -6.681 -17.731  1.00  0.00           O  
ATOM    244  OE2 GLU A  20     -15.496  -4.907 -18.746  1.00  0.00           O  
ATOM    245  H   GLU A  20     -15.550  -2.758 -14.739  1.00  0.00           H  
ATOM    246  HA  GLU A  20     -13.139  -4.328 -14.429  1.00  0.00           H  
ATOM    247  HB2 GLU A  20     -14.263  -5.927 -15.937  1.00  0.00           H  
ATOM    248  HB3 GLU A  20     -15.265  -5.491 -14.559  1.00  0.00           H  
ATOM    249  HG2 GLU A  20     -16.895  -4.924 -15.931  1.00  0.00           H  
ATOM    250  HG3 GLU A  20     -15.868  -3.675 -16.630  1.00  0.00           H  
ATOM    251  N   SER A  21     -13.359  -2.270 -16.785  1.00  0.00           N  
ATOM    252  CA  SER A  21     -12.730  -1.714 -17.977  1.00  0.00           C  
ATOM    253  C   SER A  21     -11.241  -2.049 -18.013  1.00  0.00           C  
ATOM    254  O   SER A  21     -10.803  -2.882 -18.805  1.00  0.00           O  
ATOM    255  CB  SER A  21     -12.923  -0.196 -18.021  1.00  0.00           C  
ATOM    256  OG  SER A  21     -13.850   0.172 -19.027  1.00  0.00           O  
ATOM    257  H   SER A  21     -13.955  -1.706 -16.251  1.00  0.00           H  
ATOM    258  HA  SER A  21     -13.207  -2.154 -18.840  1.00  0.00           H  
ATOM    259  HB2 SER A  21     -13.294   0.144 -17.066  1.00  0.00           H  
ATOM    260  HB3 SER A  21     -11.975   0.278 -18.230  1.00  0.00           H  
ATOM    261  HG  SER A  21     -13.825   1.122 -19.155  1.00  0.00           H  
ATOM    262  N   GLU A  22     -10.472  -1.393 -17.151  1.00  0.00           N  
ATOM    263  CA  GLU A  22      -9.034  -1.621 -17.084  1.00  0.00           C  
ATOM    264  C   GLU A  22      -8.410  -0.832 -15.937  1.00  0.00           C  
ATOM    265  O   GLU A  22      -7.544  -1.335 -15.219  1.00  0.00           O  
ATOM    266  CB  GLU A  22      -8.371  -1.230 -18.406  1.00  0.00           C  
ATOM    267  CG  GLU A  22      -7.654  -2.380 -19.093  1.00  0.00           C  
ATOM    268  CD  GLU A  22      -7.915  -2.423 -20.587  1.00  0.00           C  
ATOM    269  OE1 GLU A  22      -7.867  -1.351 -21.227  1.00  0.00           O  
ATOM    270  OE2 GLU A  22      -8.165  -3.526 -21.114  1.00  0.00           O  
ATOM    271  H   GLU A  22     -10.882  -0.740 -16.544  1.00  0.00           H  
ATOM    272  HA  GLU A  22      -8.873  -2.674 -16.909  1.00  0.00           H  
ATOM    273  HB2 GLU A  22      -9.129  -0.853 -19.078  1.00  0.00           H  
ATOM    274  HB3 GLU A  22      -7.651  -0.447 -18.216  1.00  0.00           H  
ATOM    275  HG2 GLU A  22      -6.592  -2.272 -18.932  1.00  0.00           H  
ATOM    276  HG3 GLU A  22      -7.992  -3.309 -18.656  1.00  0.00           H  
ATOM    277  N   THR A  23      -8.855   0.410 -15.770  1.00  0.00           N  
ATOM    278  CA  THR A  23      -8.341   1.270 -14.713  1.00  0.00           C  
ATOM    279  C   THR A  23      -8.104   0.482 -13.429  1.00  0.00           C  
ATOM    280  O   THR A  23      -7.191   0.788 -12.661  1.00  0.00           O  
ATOM    281  CB  THR A  23      -9.305   2.434 -14.417  1.00  0.00           C  
ATOM    282  OG1 THR A  23      -9.868   2.928 -15.638  1.00  0.00           O  
ATOM    283  CG2 THR A  23      -8.586   3.562 -13.693  1.00  0.00           C  
ATOM    284  H   THR A  23      -9.545   0.754 -16.374  1.00  0.00           H  
ATOM    285  HA  THR A  23      -7.401   1.684 -15.048  1.00  0.00           H  
ATOM    286  HB  THR A  23     -10.101   2.070 -13.782  1.00  0.00           H  
ATOM    287  HG1 THR A  23     -10.404   3.702 -15.453  1.00  0.00           H  
ATOM    288 HG21 THR A  23      -9.188   3.901 -12.863  1.00  0.00           H  
ATOM    289 HG22 THR A  23      -8.422   4.381 -14.376  1.00  0.00           H  
ATOM    290 HG23 THR A  23      -7.636   3.205 -13.324  1.00  0.00           H  
ATOM    291  N   ARG A  24      -8.931  -0.534 -13.203  1.00  0.00           N  
ATOM    292  CA  ARG A  24      -8.811  -1.364 -12.011  1.00  0.00           C  
ATOM    293  C   ARG A  24      -7.449  -2.053 -11.962  1.00  0.00           C  
ATOM    294  O   ARG A  24      -6.685  -1.872 -11.016  1.00  0.00           O  
ATOM    295  CB  ARG A  24      -9.926  -2.412 -11.980  1.00  0.00           C  
ATOM    296  CG  ARG A  24      -9.921  -3.268 -10.724  1.00  0.00           C  
ATOM    297  CD  ARG A  24     -11.282  -3.902 -10.478  1.00  0.00           C  
ATOM    298  NE  ARG A  24     -11.416  -5.189 -11.155  1.00  0.00           N  
ATOM    299  CZ  ARG A  24     -12.572  -5.828 -11.296  1.00  0.00           C  
ATOM    300  NH1 ARG A  24     -13.688  -5.302 -10.811  1.00  0.00           N  
ATOM    301  NH2 ARG A  24     -12.614  -6.996 -11.925  1.00  0.00           N  
ATOM    302  H   ARG A  24      -9.639  -0.727 -13.852  1.00  0.00           H  
ATOM    303  HA  ARG A  24      -8.908  -0.723 -11.148  1.00  0.00           H  
ATOM    304  HB2 ARG A  24     -10.879  -1.908 -12.042  1.00  0.00           H  
ATOM    305  HB3 ARG A  24      -9.816  -3.062 -12.834  1.00  0.00           H  
ATOM    306  HG2 ARG A  24      -9.187  -4.052 -10.836  1.00  0.00           H  
ATOM    307  HG3 ARG A  24      -9.664  -2.648  -9.878  1.00  0.00           H  
ATOM    308  HD2 ARG A  24     -11.409  -4.050  -9.416  1.00  0.00           H  
ATOM    309  HD3 ARG A  24     -12.047  -3.232 -10.841  1.00  0.00           H  
ATOM    310  HE  ARG A  24     -10.604  -5.596 -11.522  1.00  0.00           H  
ATOM    311 HH11 ARG A  24     -13.659  -4.421 -10.337  1.00  0.00           H  
ATOM    312 HH12 ARG A  24     -14.557  -5.784 -10.918  1.00  0.00           H  
ATOM    313 HH21 ARG A  24     -11.776  -7.395 -12.293  1.00  0.00           H  
ATOM    314 HH22 ARG A  24     -13.485  -7.475 -12.030  1.00  0.00           H  
ATOM    315  N   ALA A  25      -7.156  -2.842 -12.991  1.00  0.00           N  
ATOM    316  CA  ALA A  25      -5.886  -3.556 -13.067  1.00  0.00           C  
ATOM    317  C   ALA A  25      -4.749  -2.717 -12.494  1.00  0.00           C  
ATOM    318  O   ALA A  25      -4.138  -3.083 -11.490  1.00  0.00           O  
ATOM    319  CB  ALA A  25      -5.585  -3.946 -14.506  1.00  0.00           C  
ATOM    320  H   ALA A  25      -7.807  -2.946 -13.716  1.00  0.00           H  
ATOM    321  HA  ALA A  25      -5.979  -4.463 -12.485  1.00  0.00           H  
ATOM    322  HB1 ALA A  25      -4.994  -3.171 -14.971  1.00  0.00           H  
ATOM    323  HB2 ALA A  25      -5.038  -4.876 -14.520  1.00  0.00           H  
ATOM    324  HB3 ALA A  25      -6.511  -4.065 -15.047  1.00  0.00           H  
ATOM    325  N   LYS A  26      -4.470  -1.590 -13.139  1.00  0.00           N  
ATOM    326  CA  LYS A  26      -3.406  -0.697 -12.695  1.00  0.00           C  
ATOM    327  C   LYS A  26      -3.319  -0.670 -11.172  1.00  0.00           C  
ATOM    328  O   LYS A  26      -2.243  -0.842 -10.599  1.00  0.00           O  
ATOM    329  CB  LYS A  26      -3.643   0.718 -13.228  1.00  0.00           C  
ATOM    330  CG  LYS A  26      -3.633   0.806 -14.745  1.00  0.00           C  
ATOM    331  CD  LYS A  26      -5.026   1.050 -15.298  1.00  0.00           C  
ATOM    332  CE  LYS A  26      -5.159   0.529 -16.721  1.00  0.00           C  
ATOM    333  NZ  LYS A  26      -3.995   0.917 -17.566  1.00  0.00           N  
ATOM    334  H   LYS A  26      -4.993  -1.351 -13.935  1.00  0.00           H  
ATOM    335  HA  LYS A  26      -2.474  -1.069 -13.090  1.00  0.00           H  
ATOM    336  HB2 LYS A  26      -4.602   1.067 -12.875  1.00  0.00           H  
ATOM    337  HB3 LYS A  26      -2.870   1.369 -12.845  1.00  0.00           H  
ATOM    338  HG2 LYS A  26      -2.990   1.621 -15.044  1.00  0.00           H  
ATOM    339  HG3 LYS A  26      -3.252  -0.122 -15.147  1.00  0.00           H  
ATOM    340  HD2 LYS A  26      -5.747   0.544 -14.673  1.00  0.00           H  
ATOM    341  HD3 LYS A  26      -5.226   2.112 -15.294  1.00  0.00           H  
ATOM    342  HE2 LYS A  26      -5.228  -0.547 -16.691  1.00  0.00           H  
ATOM    343  HE3 LYS A  26      -6.060   0.935 -17.157  1.00  0.00           H  
ATOM    344  HZ1 LYS A  26      -4.025   1.937 -17.765  1.00  0.00           H  
ATOM    345  HZ2 LYS A  26      -4.019   0.397 -18.466  1.00  0.00           H  
ATOM    346  HZ3 LYS A  26      -3.107   0.696 -17.072  1.00  0.00           H  
ATOM    347  N   PHE A  27      -4.457  -0.454 -10.522  1.00  0.00           N  
ATOM    348  CA  PHE A  27      -4.510  -0.405  -9.066  1.00  0.00           C  
ATOM    349  C   PHE A  27      -4.034  -1.722  -8.461  1.00  0.00           C  
ATOM    350  O   PHE A  27      -3.243  -1.732  -7.517  1.00  0.00           O  
ATOM    351  CB  PHE A  27      -5.933  -0.100  -8.596  1.00  0.00           C  
ATOM    352  CG  PHE A  27      -6.146  -0.348  -7.130  1.00  0.00           C  
ATOM    353  CD1 PHE A  27      -6.418  -1.625  -6.662  1.00  0.00           C  
ATOM    354  CD2 PHE A  27      -6.074   0.693  -6.218  1.00  0.00           C  
ATOM    355  CE1 PHE A  27      -6.614  -1.857  -5.313  1.00  0.00           C  
ATOM    356  CE2 PHE A  27      -6.270   0.468  -4.870  1.00  0.00           C  
ATOM    357  CZ  PHE A  27      -6.540  -0.809  -4.416  1.00  0.00           C  
ATOM    358  H   PHE A  27      -5.283  -0.323 -11.036  1.00  0.00           H  
ATOM    359  HA  PHE A  27      -3.854   0.388  -8.738  1.00  0.00           H  
ATOM    360  HB2 PHE A  27      -6.154   0.939  -8.790  1.00  0.00           H  
ATOM    361  HB3 PHE A  27      -6.627  -0.721  -9.143  1.00  0.00           H  
ATOM    362  HD1 PHE A  27      -6.477  -2.445  -7.364  1.00  0.00           H  
ATOM    363  HD2 PHE A  27      -5.863   1.693  -6.573  1.00  0.00           H  
ATOM    364  HE1 PHE A  27      -6.826  -2.855  -4.963  1.00  0.00           H  
ATOM    365  HE2 PHE A  27      -6.212   1.287  -4.170  1.00  0.00           H  
ATOM    366  HZ  PHE A  27      -6.692  -0.988  -3.363  1.00  0.00           H  
ATOM    367  N   GLU A  28      -4.520  -2.829  -9.011  1.00  0.00           N  
ATOM    368  CA  GLU A  28      -4.144  -4.152  -8.523  1.00  0.00           C  
ATOM    369  C   GLU A  28      -2.650  -4.397  -8.709  1.00  0.00           C  
ATOM    370  O   GLU A  28      -1.930  -4.663  -7.747  1.00  0.00           O  
ATOM    371  CB  GLU A  28      -4.943  -5.234  -9.253  1.00  0.00           C  
ATOM    372  CG  GLU A  28      -6.127  -5.758  -8.456  1.00  0.00           C  
ATOM    373  CD  GLU A  28      -7.141  -6.479  -9.325  1.00  0.00           C  
ATOM    374  OE1 GLU A  28      -8.060  -5.812  -9.842  1.00  0.00           O  
ATOM    375  OE2 GLU A  28      -7.013  -7.711  -9.486  1.00  0.00           O  
ATOM    376  H   GLU A  28      -5.145  -2.757  -9.761  1.00  0.00           H  
ATOM    377  HA  GLU A  28      -4.376  -4.195  -7.471  1.00  0.00           H  
ATOM    378  HB2 GLU A  28      -5.313  -4.828 -10.183  1.00  0.00           H  
ATOM    379  HB3 GLU A  28      -4.286  -6.064  -9.470  1.00  0.00           H  
ATOM    380  HG2 GLU A  28      -5.765  -6.444  -7.707  1.00  0.00           H  
ATOM    381  HG3 GLU A  28      -6.616  -4.924  -7.974  1.00  0.00           H  
ATOM    382  N   SER A  29      -2.190  -4.302  -9.953  1.00  0.00           N  
ATOM    383  CA  SER A  29      -0.782  -4.518 -10.266  1.00  0.00           C  
ATOM    384  C   SER A  29       0.112  -3.930  -9.179  1.00  0.00           C  
ATOM    385  O   SER A  29       1.104  -4.539  -8.778  1.00  0.00           O  
ATOM    386  CB  SER A  29      -0.438  -3.893 -11.619  1.00  0.00           C  
ATOM    387  OG  SER A  29       0.928  -4.090 -11.940  1.00  0.00           O  
ATOM    388  H   SER A  29      -2.814  -4.087 -10.678  1.00  0.00           H  
ATOM    389  HA  SER A  29      -0.613  -5.583 -10.318  1.00  0.00           H  
ATOM    390  HB2 SER A  29      -1.044  -4.348 -12.388  1.00  0.00           H  
ATOM    391  HB3 SER A  29      -0.639  -2.831 -11.584  1.00  0.00           H  
ATOM    392  HG  SER A  29       1.010  -4.824 -12.552  1.00  0.00           H  
ATOM    393  N   LEU A  30      -0.246  -2.740  -8.708  1.00  0.00           N  
ATOM    394  CA  LEU A  30       0.523  -2.068  -7.666  1.00  0.00           C  
ATOM    395  C   LEU A  30       0.840  -3.023  -6.519  1.00  0.00           C  
ATOM    396  O   LEU A  30       1.981  -3.110  -6.068  1.00  0.00           O  
ATOM    397  CB  LEU A  30      -0.247  -0.856  -7.138  1.00  0.00           C  
ATOM    398  CG  LEU A  30      -0.459   0.289  -8.130  1.00  0.00           C  
ATOM    399  CD1 LEU A  30      -1.456   1.296  -7.578  1.00  0.00           C  
ATOM    400  CD2 LEU A  30       0.865   0.967  -8.452  1.00  0.00           C  
ATOM    401  H   LEU A  30      -1.046  -2.304  -9.066  1.00  0.00           H  
ATOM    402  HA  LEU A  30       1.451  -1.731  -8.105  1.00  0.00           H  
ATOM    403  HB2 LEU A  30      -1.218  -1.197  -6.814  1.00  0.00           H  
ATOM    404  HB3 LEU A  30       0.296  -0.464  -6.290  1.00  0.00           H  
ATOM    405  HG  LEU A  30      -0.864  -0.110  -9.049  1.00  0.00           H  
ATOM    406 HD11 LEU A  30      -0.947   2.223  -7.359  1.00  0.00           H  
ATOM    407 HD12 LEU A  30      -1.898   0.905  -6.673  1.00  0.00           H  
ATOM    408 HD13 LEU A  30      -2.231   1.473  -8.308  1.00  0.00           H  
ATOM    409 HD21 LEU A  30       1.666   0.248  -8.372  1.00  0.00           H  
ATOM    410 HD22 LEU A  30       1.035   1.774  -7.754  1.00  0.00           H  
ATOM    411 HD23 LEU A  30       0.831   1.361  -9.458  1.00  0.00           H  
ATOM    412  N   PHE A  31      -0.179  -3.738  -6.054  1.00  0.00           N  
ATOM    413  CA  PHE A  31      -0.009  -4.688  -4.961  1.00  0.00           C  
ATOM    414  C   PHE A  31       0.385  -6.063  -5.492  1.00  0.00           C  
ATOM    415  O   PHE A  31       1.395  -6.633  -5.077  1.00  0.00           O  
ATOM    416  CB  PHE A  31      -1.300  -4.796  -4.146  1.00  0.00           C  
ATOM    417  CG  PHE A  31      -1.928  -3.466  -3.840  1.00  0.00           C  
ATOM    418  CD1 PHE A  31      -2.689  -2.809  -4.795  1.00  0.00           C  
ATOM    419  CD2 PHE A  31      -1.759  -2.873  -2.599  1.00  0.00           C  
ATOM    420  CE1 PHE A  31      -3.270  -1.585  -4.517  1.00  0.00           C  
ATOM    421  CE2 PHE A  31      -2.337  -1.650  -2.316  1.00  0.00           C  
ATOM    422  CZ  PHE A  31      -3.093  -1.004  -3.276  1.00  0.00           C  
ATOM    423  H   PHE A  31      -1.067  -3.623  -6.455  1.00  0.00           H  
ATOM    424  HA  PHE A  31       0.780  -4.320  -4.323  1.00  0.00           H  
ATOM    425  HB2 PHE A  31      -2.019  -5.382  -4.698  1.00  0.00           H  
ATOM    426  HB3 PHE A  31      -1.086  -5.286  -3.209  1.00  0.00           H  
ATOM    427  HD1 PHE A  31      -2.828  -3.262  -5.766  1.00  0.00           H  
ATOM    428  HD2 PHE A  31      -1.169  -3.376  -1.848  1.00  0.00           H  
ATOM    429  HE1 PHE A  31      -3.859  -1.084  -5.270  1.00  0.00           H  
ATOM    430  HE2 PHE A  31      -2.197  -1.198  -1.346  1.00  0.00           H  
ATOM    431  HZ  PHE A  31      -3.545  -0.050  -3.057  1.00  0.00           H  
ATOM    432  N   ARG A  32      -0.418  -6.589  -6.411  1.00  0.00           N  
ATOM    433  CA  ARG A  32      -0.153  -7.898  -6.997  1.00  0.00           C  
ATOM    434  C   ARG A  32       1.331  -8.061  -7.315  1.00  0.00           C  
ATOM    435  O   ARG A  32       1.930  -9.096  -7.022  1.00  0.00           O  
ATOM    436  CB  ARG A  32      -0.983  -8.087  -8.268  1.00  0.00           C  
ATOM    437  CG  ARG A  32      -1.559  -9.487  -8.416  1.00  0.00           C  
ATOM    438  CD  ARG A  32      -0.578 -10.422  -9.103  1.00  0.00           C  
ATOM    439  NE  ARG A  32      -1.249 -11.577  -9.698  1.00  0.00           N  
ATOM    440  CZ  ARG A  32      -1.840 -11.550 -10.887  1.00  0.00           C  
ATOM    441  NH1 ARG A  32      -1.844 -10.436 -11.605  1.00  0.00           N  
ATOM    442  NH2 ARG A  32      -2.429 -12.641 -11.361  1.00  0.00           N  
ATOM    443  H   ARG A  32      -1.207  -6.086  -6.701  1.00  0.00           H  
ATOM    444  HA  ARG A  32      -0.439  -8.648  -6.275  1.00  0.00           H  
ATOM    445  HB2 ARG A  32      -1.803  -7.384  -8.257  1.00  0.00           H  
ATOM    446  HB3 ARG A  32      -0.357  -7.887  -9.125  1.00  0.00           H  
ATOM    447  HG2 ARG A  32      -1.787  -9.878  -7.435  1.00  0.00           H  
ATOM    448  HG3 ARG A  32      -2.464  -9.432  -9.001  1.00  0.00           H  
ATOM    449  HD2 ARG A  32      -0.065  -9.878  -9.881  1.00  0.00           H  
ATOM    450  HD3 ARG A  32       0.138 -10.770  -8.375  1.00  0.00           H  
ATOM    451  HE  ARG A  32      -1.257 -12.411  -9.185  1.00  0.00           H  
ATOM    452 HH11 ARG A  32      -1.401  -9.613 -11.251  1.00  0.00           H  
ATOM    453 HH12 ARG A  32      -2.290 -10.418 -12.501  1.00  0.00           H  
ATOM    454 HH21 ARG A  32      -2.427 -13.483 -10.822  1.00  0.00           H  
ATOM    455 HH22 ARG A  32      -2.874 -12.621 -12.256  1.00  0.00           H  
ATOM    456  N   THR A  33       1.917  -7.032  -7.919  1.00  0.00           N  
ATOM    457  CA  THR A  33       3.329  -7.061  -8.279  1.00  0.00           C  
ATOM    458  C   THR A  33       4.173  -7.638  -7.148  1.00  0.00           C  
ATOM    459  O   THR A  33       5.108  -8.404  -7.385  1.00  0.00           O  
ATOM    460  CB  THR A  33       3.850  -5.654  -8.626  1.00  0.00           C  
ATOM    461  OG1 THR A  33       5.145  -5.746  -9.230  1.00  0.00           O  
ATOM    462  CG2 THR A  33       3.925  -4.782  -7.382  1.00  0.00           C  
ATOM    463  H   THR A  33       1.387  -6.234  -8.126  1.00  0.00           H  
ATOM    464  HA  THR A  33       3.437  -7.688  -9.152  1.00  0.00           H  
ATOM    465  HB  THR A  33       3.165  -5.197  -9.328  1.00  0.00           H  
ATOM    466  HG1 THR A  33       5.745  -6.199  -8.633  1.00  0.00           H  
ATOM    467 HG21 THR A  33       4.838  -4.999  -6.846  1.00  0.00           H  
ATOM    468 HG22 THR A  33       3.076  -4.987  -6.747  1.00  0.00           H  
ATOM    469 HG23 THR A  33       3.916  -3.742  -7.671  1.00  0.00           H  
ATOM    470  N   TYR A  34       3.840  -7.267  -5.918  1.00  0.00           N  
ATOM    471  CA  TYR A  34       4.568  -7.746  -4.749  1.00  0.00           C  
ATOM    472  C   TYR A  34       4.241  -9.208  -4.466  1.00  0.00           C  
ATOM    473  O   TYR A  34       5.077 -10.092  -4.656  1.00  0.00           O  
ATOM    474  CB  TYR A  34       4.233  -6.889  -3.527  1.00  0.00           C  
ATOM    475  CG  TYR A  34       4.131  -5.412  -3.831  1.00  0.00           C  
ATOM    476  CD1 TYR A  34       5.141  -4.753  -4.520  1.00  0.00           C  
ATOM    477  CD2 TYR A  34       3.022  -4.676  -3.431  1.00  0.00           C  
ATOM    478  CE1 TYR A  34       5.052  -3.403  -4.799  1.00  0.00           C  
ATOM    479  CE2 TYR A  34       2.924  -3.325  -3.707  1.00  0.00           C  
ATOM    480  CZ  TYR A  34       3.942  -2.694  -4.390  1.00  0.00           C  
ATOM    481  OH  TYR A  34       3.849  -1.349  -4.669  1.00  0.00           O  
ATOM    482  H   TYR A  34       3.085  -6.653  -5.791  1.00  0.00           H  
ATOM    483  HA  TYR A  34       5.623  -7.658  -4.959  1.00  0.00           H  
ATOM    484  HB2 TYR A  34       3.286  -7.210  -3.120  1.00  0.00           H  
ATOM    485  HB3 TYR A  34       5.002  -7.023  -2.781  1.00  0.00           H  
ATOM    486  HD1 TYR A  34       6.009  -5.312  -4.838  1.00  0.00           H  
ATOM    487  HD2 TYR A  34       2.226  -5.173  -2.895  1.00  0.00           H  
ATOM    488  HE1 TYR A  34       5.849  -2.908  -5.335  1.00  0.00           H  
ATOM    489  HE2 TYR A  34       2.055  -2.769  -3.388  1.00  0.00           H  
ATOM    490  HH  TYR A  34       4.348  -1.153  -5.465  1.00  0.00           H  
ATOM    491  N   ASP A  35       3.018  -9.457  -4.010  1.00  0.00           N  
ATOM    492  CA  ASP A  35       2.577 -10.812  -3.701  1.00  0.00           C  
ATOM    493  C   ASP A  35       1.602 -11.321  -4.759  1.00  0.00           C  
ATOM    494  O   ASP A  35       0.838 -10.549  -5.337  1.00  0.00           O  
ATOM    495  CB  ASP A  35       1.920 -10.856  -2.321  1.00  0.00           C  
ATOM    496  CG  ASP A  35       2.857 -11.382  -1.250  1.00  0.00           C  
ATOM    497  OD1 ASP A  35       3.756 -12.179  -1.589  1.00  0.00           O  
ATOM    498  OD2 ASP A  35       2.688 -10.998  -0.073  1.00  0.00           O  
ATOM    499  H   ASP A  35       2.397  -8.710  -3.879  1.00  0.00           H  
ATOM    500  HA  ASP A  35       3.447 -11.450  -3.695  1.00  0.00           H  
ATOM    501  HB2 ASP A  35       1.613  -9.857  -2.044  1.00  0.00           H  
ATOM    502  HB3 ASP A  35       1.052 -11.496  -2.362  1.00  0.00           H  
ATOM    503  N   LYS A  36       1.637 -12.625  -5.007  1.00  0.00           N  
ATOM    504  CA  LYS A  36       0.758 -13.239  -5.996  1.00  0.00           C  
ATOM    505  C   LYS A  36      -0.497 -13.801  -5.333  1.00  0.00           C  
ATOM    506  O   LYS A  36      -1.545 -13.921  -5.968  1.00  0.00           O  
ATOM    507  CB  LYS A  36       1.494 -14.353  -6.743  1.00  0.00           C  
ATOM    508  CG  LYS A  36       2.812 -13.907  -7.352  1.00  0.00           C  
ATOM    509  CD  LYS A  36       2.872 -14.216  -8.839  1.00  0.00           C  
ATOM    510  CE  LYS A  36       2.084 -13.199  -9.650  1.00  0.00           C  
ATOM    511  NZ  LYS A  36       2.954 -12.450 -10.599  1.00  0.00           N  
ATOM    512  H   LYS A  36       2.269 -13.190  -4.515  1.00  0.00           H  
ATOM    513  HA  LYS A  36       0.466 -12.476  -6.700  1.00  0.00           H  
ATOM    514  HB2 LYS A  36       1.694 -15.160  -6.055  1.00  0.00           H  
ATOM    515  HB3 LYS A  36       0.859 -14.717  -7.537  1.00  0.00           H  
ATOM    516  HG2 LYS A  36       2.923 -12.843  -7.211  1.00  0.00           H  
ATOM    517  HG3 LYS A  36       3.621 -14.424  -6.854  1.00  0.00           H  
ATOM    518  HD2 LYS A  36       3.902 -14.196  -9.161  1.00  0.00           H  
ATOM    519  HD3 LYS A  36       2.458 -15.199  -9.011  1.00  0.00           H  
ATOM    520  HE2 LYS A  36       1.320 -13.717 -10.209  1.00  0.00           H  
ATOM    521  HE3 LYS A  36       1.620 -12.498  -8.970  1.00  0.00           H  
ATOM    522  HZ1 LYS A  36       3.832 -12.157 -10.122  1.00  0.00           H  
ATOM    523  HZ2 LYS A  36       2.462 -11.603 -10.943  1.00  0.00           H  
ATOM    524  HZ3 LYS A  36       3.199 -13.053 -11.411  1.00  0.00           H  
ATOM    525  N   ASP A  37      -0.382 -14.140  -4.054  1.00  0.00           N  
ATOM    526  CA  ASP A  37      -1.508 -14.687  -3.305  1.00  0.00           C  
ATOM    527  C   ASP A  37      -2.342 -13.569  -2.685  1.00  0.00           C  
ATOM    528  O   ASP A  37      -3.242 -13.822  -1.883  1.00  0.00           O  
ATOM    529  CB  ASP A  37      -1.009 -15.635  -2.212  1.00  0.00           C  
ATOM    530  CG  ASP A  37      -1.946 -16.806  -1.990  1.00  0.00           C  
ATOM    531  OD1 ASP A  37      -3.169 -16.577  -1.884  1.00  0.00           O  
ATOM    532  OD2 ASP A  37      -1.455 -17.953  -1.926  1.00  0.00           O  
ATOM    533  H   ASP A  37       0.480 -14.021  -3.603  1.00  0.00           H  
ATOM    534  HA  ASP A  37      -2.127 -15.242  -3.993  1.00  0.00           H  
ATOM    535  HB2 ASP A  37      -0.041 -16.020  -2.493  1.00  0.00           H  
ATOM    536  HB3 ASP A  37      -0.919 -15.089  -1.285  1.00  0.00           H  
ATOM    537  N   THR A  38      -2.035 -12.331  -3.059  1.00  0.00           N  
ATOM    538  CA  THR A  38      -2.753 -11.176  -2.539  1.00  0.00           C  
ATOM    539  C   THR A  38      -4.165 -11.103  -3.109  1.00  0.00           C  
ATOM    540  O   THR A  38      -4.361 -11.165  -4.323  1.00  0.00           O  
ATOM    541  CB  THR A  38      -2.015  -9.863  -2.861  1.00  0.00           C  
ATOM    542  OG1 THR A  38      -1.236 -10.019  -4.052  1.00  0.00           O  
ATOM    543  CG2 THR A  38      -1.110  -9.453  -1.708  1.00  0.00           C  
ATOM    544  H   THR A  38      -1.308 -12.193  -3.701  1.00  0.00           H  
ATOM    545  HA  THR A  38      -2.814 -11.275  -1.465  1.00  0.00           H  
ATOM    546  HB  THR A  38      -2.748  -9.084  -3.019  1.00  0.00           H  
ATOM    547  HG1 THR A  38      -0.364 -10.351  -3.824  1.00  0.00           H  
ATOM    548 HG21 THR A  38      -0.314  -8.827  -2.081  1.00  0.00           H  
ATOM    549 HG22 THR A  38      -0.690 -10.336  -1.250  1.00  0.00           H  
ATOM    550 HG23 THR A  38      -1.686  -8.907  -0.976  1.00  0.00           H  
ATOM    551  N   THR A  39      -5.149 -10.970  -2.224  1.00  0.00           N  
ATOM    552  CA  THR A  39      -6.543 -10.891  -2.639  1.00  0.00           C  
ATOM    553  C   THR A  39      -7.049  -9.454  -2.593  1.00  0.00           C  
ATOM    554  O   THR A  39      -6.679  -8.683  -1.707  1.00  0.00           O  
ATOM    555  CB  THR A  39      -7.446 -11.769  -1.751  1.00  0.00           C  
ATOM    556  OG1 THR A  39      -7.815 -11.053  -0.567  1.00  0.00           O  
ATOM    557  CG2 THR A  39      -6.736 -13.060  -1.368  1.00  0.00           C  
ATOM    558  H   THR A  39      -4.931 -10.927  -1.270  1.00  0.00           H  
ATOM    559  HA  THR A  39      -6.611 -11.254  -3.655  1.00  0.00           H  
ATOM    560  HB  THR A  39      -8.338 -12.017  -2.305  1.00  0.00           H  
ATOM    561  HG1 THR A  39      -8.680 -10.655  -0.691  1.00  0.00           H  
ATOM    562 HG21 THR A  39      -6.191 -12.911  -0.448  1.00  0.00           H  
ATOM    563 HG22 THR A  39      -6.050 -13.339  -2.154  1.00  0.00           H  
ATOM    564 HG23 THR A  39      -7.467 -13.843  -1.231  1.00  0.00           H  
ATOM    565  N   PHE A  40      -7.899  -9.099  -3.552  1.00  0.00           N  
ATOM    566  CA  PHE A  40      -8.456  -7.753  -3.621  1.00  0.00           C  
ATOM    567  C   PHE A  40      -9.975  -7.785  -3.480  1.00  0.00           C  
ATOM    568  O   PHE A  40     -10.650  -8.584  -4.129  1.00  0.00           O  
ATOM    569  CB  PHE A  40      -8.069  -7.085  -4.941  1.00  0.00           C  
ATOM    570  CG  PHE A  40      -6.586  -7.040  -5.177  1.00  0.00           C  
ATOM    571  CD1 PHE A  40      -5.865  -8.207  -5.370  1.00  0.00           C  
ATOM    572  CD2 PHE A  40      -5.911  -5.828  -5.204  1.00  0.00           C  
ATOM    573  CE1 PHE A  40      -4.501  -8.169  -5.588  1.00  0.00           C  
ATOM    574  CE2 PHE A  40      -4.548  -5.785  -5.422  1.00  0.00           C  
ATOM    575  CZ  PHE A  40      -3.841  -6.956  -5.613  1.00  0.00           C  
ATOM    576  H   PHE A  40      -8.157  -9.759  -4.230  1.00  0.00           H  
ATOM    577  HA  PHE A  40      -8.044  -7.183  -2.802  1.00  0.00           H  
ATOM    578  HB2 PHE A  40      -8.516  -7.629  -5.757  1.00  0.00           H  
ATOM    579  HB3 PHE A  40      -8.437  -6.070  -4.944  1.00  0.00           H  
ATOM    580  HD1 PHE A  40      -6.381  -9.158  -5.350  1.00  0.00           H  
ATOM    581  HD2 PHE A  40      -6.462  -4.912  -5.055  1.00  0.00           H  
ATOM    582  HE1 PHE A  40      -3.952  -9.087  -5.736  1.00  0.00           H  
ATOM    583  HE2 PHE A  40      -4.033  -4.835  -5.441  1.00  0.00           H  
ATOM    584  HZ  PHE A  40      -2.775  -6.924  -5.783  1.00  0.00           H  
ATOM    585  N   GLN A  41     -10.504  -6.911  -2.630  1.00  0.00           N  
ATOM    586  CA  GLN A  41     -11.942  -6.840  -2.403  1.00  0.00           C  
ATOM    587  C   GLN A  41     -12.445  -5.407  -2.545  1.00  0.00           C  
ATOM    588  O   GLN A  41     -12.213  -4.568  -1.674  1.00  0.00           O  
ATOM    589  CB  GLN A  41     -12.289  -7.382  -1.015  1.00  0.00           C  
ATOM    590  CG  GLN A  41     -13.364  -8.455  -1.032  1.00  0.00           C  
ATOM    591  CD  GLN A  41     -13.468  -9.197   0.286  1.00  0.00           C  
ATOM    592  OE1 GLN A  41     -14.398  -8.977   1.064  1.00  0.00           O  
ATOM    593  NE2 GLN A  41     -12.513 -10.082   0.544  1.00  0.00           N  
ATOM    594  H   GLN A  41      -9.913  -6.301  -2.143  1.00  0.00           H  
ATOM    595  HA  GLN A  41     -12.426  -7.453  -3.150  1.00  0.00           H  
ATOM    596  HB2 GLN A  41     -11.399  -7.799  -0.572  1.00  0.00           H  
ATOM    597  HB3 GLN A  41     -12.637  -6.564  -0.402  1.00  0.00           H  
ATOM    598  HG2 GLN A  41     -14.316  -7.991  -1.241  1.00  0.00           H  
ATOM    599  HG3 GLN A  41     -13.132  -9.166  -1.812  1.00  0.00           H  
ATOM    600 HE21 GLN A  41     -11.804 -10.205  -0.122  1.00  0.00           H  
ATOM    601 HE22 GLN A  41     -12.554 -10.576   1.388  1.00  0.00           H  
ATOM    602  N   TYR A  42     -13.135  -5.134  -3.647  1.00  0.00           N  
ATOM    603  CA  TYR A  42     -13.669  -3.802  -3.904  1.00  0.00           C  
ATOM    604  C   TYR A  42     -15.067  -3.652  -3.313  1.00  0.00           C  
ATOM    605  O   TYR A  42     -15.927  -4.513  -3.499  1.00  0.00           O  
ATOM    606  CB  TYR A  42     -13.706  -3.525  -5.408  1.00  0.00           C  
ATOM    607  CG  TYR A  42     -12.341  -3.534  -6.059  1.00  0.00           C  
ATOM    608  CD1 TYR A  42     -11.781  -4.716  -6.528  1.00  0.00           C  
ATOM    609  CD2 TYR A  42     -11.610  -2.361  -6.204  1.00  0.00           C  
ATOM    610  CE1 TYR A  42     -10.536  -4.730  -7.123  1.00  0.00           C  
ATOM    611  CE2 TYR A  42     -10.363  -2.365  -6.799  1.00  0.00           C  
ATOM    612  CZ  TYR A  42      -9.830  -3.552  -7.257  1.00  0.00           C  
ATOM    613  OH  TYR A  42      -8.588  -3.561  -7.849  1.00  0.00           O  
ATOM    614  H   TYR A  42     -13.287  -5.844  -4.304  1.00  0.00           H  
ATOM    615  HA  TYR A  42     -13.013  -3.085  -3.432  1.00  0.00           H  
ATOM    616  HB2 TYR A  42     -14.307  -4.278  -5.891  1.00  0.00           H  
ATOM    617  HB3 TYR A  42     -14.148  -2.555  -5.577  1.00  0.00           H  
ATOM    618  HD1 TYR A  42     -12.337  -5.636  -6.423  1.00  0.00           H  
ATOM    619  HD2 TYR A  42     -12.032  -1.433  -5.845  1.00  0.00           H  
ATOM    620  HE1 TYR A  42     -10.117  -5.659  -7.482  1.00  0.00           H  
ATOM    621  HE2 TYR A  42      -9.811  -1.443  -6.903  1.00  0.00           H  
ATOM    622  HH  TYR A  42      -8.553  -4.259  -8.506  1.00  0.00           H  
ATOM    623  N   PHE A  43     -15.287  -2.552  -2.601  1.00  0.00           N  
ATOM    624  CA  PHE A  43     -16.582  -2.287  -1.983  1.00  0.00           C  
ATOM    625  C   PHE A  43     -17.244  -1.064  -2.610  1.00  0.00           C  
ATOM    626  O   PHE A  43     -16.952   0.074  -2.240  1.00  0.00           O  
ATOM    627  CB  PHE A  43     -16.417  -2.077  -0.477  1.00  0.00           C  
ATOM    628  CG  PHE A  43     -15.763  -3.233   0.223  1.00  0.00           C  
ATOM    629  CD1 PHE A  43     -16.508  -4.334   0.615  1.00  0.00           C  
ATOM    630  CD2 PHE A  43     -14.403  -3.220   0.488  1.00  0.00           C  
ATOM    631  CE1 PHE A  43     -15.909  -5.400   1.258  1.00  0.00           C  
ATOM    632  CE2 PHE A  43     -13.799  -4.285   1.131  1.00  0.00           C  
ATOM    633  CZ  PHE A  43     -14.553  -5.375   1.518  1.00  0.00           C  
ATOM    634  H   PHE A  43     -14.562  -1.902  -2.490  1.00  0.00           H  
ATOM    635  HA  PHE A  43     -17.210  -3.148  -2.151  1.00  0.00           H  
ATOM    636  HB2 PHE A  43     -15.809  -1.200  -0.308  1.00  0.00           H  
ATOM    637  HB3 PHE A  43     -17.389  -1.925  -0.034  1.00  0.00           H  
ATOM    638  HD1 PHE A  43     -17.569  -4.354   0.413  1.00  0.00           H  
ATOM    639  HD2 PHE A  43     -13.813  -2.367   0.187  1.00  0.00           H  
ATOM    640  HE1 PHE A  43     -16.503  -6.252   1.560  1.00  0.00           H  
ATOM    641  HE2 PHE A  43     -12.739  -4.262   1.333  1.00  0.00           H  
ATOM    642  HZ  PHE A  43     -14.083  -6.208   2.020  1.00  0.00           H  
ATOM    643  N   LYS A  44     -18.139  -1.306  -3.562  1.00  0.00           N  
ATOM    644  CA  LYS A  44     -18.844  -0.227  -4.242  1.00  0.00           C  
ATOM    645  C   LYS A  44     -19.593   0.649  -3.241  1.00  0.00           C  
ATOM    646  O   LYS A  44     -20.117   0.158  -2.243  1.00  0.00           O  
ATOM    647  CB  LYS A  44     -19.826  -0.798  -5.268  1.00  0.00           C  
ATOM    648  CG  LYS A  44     -20.165   0.168  -6.390  1.00  0.00           C  
ATOM    649  CD  LYS A  44     -20.324  -0.553  -7.718  1.00  0.00           C  
ATOM    650  CE  LYS A  44     -21.787  -0.690  -8.106  1.00  0.00           C  
ATOM    651  NZ  LYS A  44     -22.013  -1.846  -9.017  1.00  0.00           N  
ATOM    652  H   LYS A  44     -18.330  -2.234  -3.814  1.00  0.00           H  
ATOM    653  HA  LYS A  44     -18.112   0.378  -4.754  1.00  0.00           H  
ATOM    654  HB2 LYS A  44     -19.395  -1.686  -5.704  1.00  0.00           H  
ATOM    655  HB3 LYS A  44     -20.743  -1.065  -4.762  1.00  0.00           H  
ATOM    656  HG2 LYS A  44     -21.089   0.672  -6.153  1.00  0.00           H  
ATOM    657  HG3 LYS A  44     -19.369   0.896  -6.478  1.00  0.00           H  
ATOM    658  HD2 LYS A  44     -19.810   0.008  -8.486  1.00  0.00           H  
ATOM    659  HD3 LYS A  44     -19.887  -1.538  -7.637  1.00  0.00           H  
ATOM    660  HE2 LYS A  44     -22.372  -0.830  -7.210  1.00  0.00           H  
ATOM    661  HE3 LYS A  44     -22.101   0.216  -8.603  1.00  0.00           H  
ATOM    662  HZ1 LYS A  44     -22.051  -1.521 -10.004  1.00  0.00           H  
ATOM    663  HZ2 LYS A  44     -22.913  -2.314  -8.784  1.00  0.00           H  
ATOM    664  HZ3 LYS A  44     -21.241  -2.535  -8.919  1.00  0.00           H  
ATOM    665  N   SER A  45     -19.638   1.949  -3.517  1.00  0.00           N  
ATOM    666  CA  SER A  45     -20.320   2.893  -2.639  1.00  0.00           C  
ATOM    667  C   SER A  45     -19.435   3.267  -1.454  1.00  0.00           C  
ATOM    668  O   SER A  45     -19.334   4.438  -1.086  1.00  0.00           O  
ATOM    669  CB  SER A  45     -21.637   2.298  -2.140  1.00  0.00           C  
ATOM    670  OG  SER A  45     -22.597   3.313  -1.899  1.00  0.00           O  
ATOM    671  H   SER A  45     -19.200   2.281  -4.329  1.00  0.00           H  
ATOM    672  HA  SER A  45     -20.531   3.785  -3.212  1.00  0.00           H  
ATOM    673  HB2 SER A  45     -22.027   1.619  -2.883  1.00  0.00           H  
ATOM    674  HB3 SER A  45     -21.460   1.760  -1.219  1.00  0.00           H  
ATOM    675  HG  SER A  45     -23.074   3.116  -1.090  1.00  0.00           H  
ATOM    676  N   PHE A  46     -18.795   2.265  -0.861  1.00  0.00           N  
ATOM    677  CA  PHE A  46     -17.920   2.487   0.285  1.00  0.00           C  
ATOM    678  C   PHE A  46     -16.557   3.007  -0.166  1.00  0.00           C  
ATOM    679  O   PHE A  46     -15.697   3.320   0.657  1.00  0.00           O  
ATOM    680  CB  PHE A  46     -17.746   1.192   1.080  1.00  0.00           C  
ATOM    681  CG  PHE A  46     -19.000   0.743   1.774  1.00  0.00           C  
ATOM    682  CD1 PHE A  46     -19.330   1.235   3.026  1.00  0.00           C  
ATOM    683  CD2 PHE A  46     -19.850  -0.172   1.175  1.00  0.00           C  
ATOM    684  CE1 PHE A  46     -20.482   0.824   3.668  1.00  0.00           C  
ATOM    685  CE2 PHE A  46     -21.005  -0.589   1.811  1.00  0.00           C  
ATOM    686  CZ  PHE A  46     -21.322  -0.088   3.058  1.00  0.00           C  
ATOM    687  H   PHE A  46     -18.916   1.354  -1.201  1.00  0.00           H  
ATOM    688  HA  PHE A  46     -18.384   3.229   0.916  1.00  0.00           H  
ATOM    689  HB2 PHE A  46     -17.440   0.404   0.409  1.00  0.00           H  
ATOM    690  HB3 PHE A  46     -16.985   1.339   1.831  1.00  0.00           H  
ATOM    691  HD1 PHE A  46     -18.675   1.951   3.503  1.00  0.00           H  
ATOM    692  HD2 PHE A  46     -19.604  -0.564   0.197  1.00  0.00           H  
ATOM    693  HE1 PHE A  46     -20.729   1.216   4.643  1.00  0.00           H  
ATOM    694  HE2 PHE A  46     -21.659  -1.301   1.331  1.00  0.00           H  
ATOM    695  HZ  PHE A  46     -22.222  -0.412   3.558  1.00  0.00           H  
ATOM    696  N   LYS A  47     -16.368   3.097  -1.478  1.00  0.00           N  
ATOM    697  CA  LYS A  47     -15.114   3.579  -2.039  1.00  0.00           C  
ATOM    698  C   LYS A  47     -13.922   3.029  -1.262  1.00  0.00           C  
ATOM    699  O   LYS A  47     -12.985   3.761  -0.942  1.00  0.00           O  
ATOM    700  CB  LYS A  47     -15.080   5.109  -2.028  1.00  0.00           C  
ATOM    701  CG  LYS A  47     -16.303   5.749  -2.662  1.00  0.00           C  
ATOM    702  CD  LYS A  47     -16.103   5.981  -4.150  1.00  0.00           C  
ATOM    703  CE  LYS A  47     -17.423   6.256  -4.855  1.00  0.00           C  
ATOM    704  NZ  LYS A  47     -17.711   5.243  -5.908  1.00  0.00           N  
ATOM    705  H   LYS A  47     -17.094   2.833  -2.084  1.00  0.00           H  
ATOM    706  HA  LYS A  47     -15.052   3.234  -3.060  1.00  0.00           H  
ATOM    707  HB2 LYS A  47     -15.011   5.448  -1.006  1.00  0.00           H  
ATOM    708  HB3 LYS A  47     -14.206   5.442  -2.569  1.00  0.00           H  
ATOM    709  HG2 LYS A  47     -17.153   5.097  -2.522  1.00  0.00           H  
ATOM    710  HG3 LYS A  47     -16.492   6.698  -2.181  1.00  0.00           H  
ATOM    711  HD2 LYS A  47     -15.453   6.832  -4.288  1.00  0.00           H  
ATOM    712  HD3 LYS A  47     -15.648   5.103  -4.586  1.00  0.00           H  
ATOM    713  HE2 LYS A  47     -18.216   6.237  -4.123  1.00  0.00           H  
ATOM    714  HE3 LYS A  47     -17.378   7.234  -5.309  1.00  0.00           H  
ATOM    715  HZ1 LYS A  47     -18.733   5.053  -5.951  1.00  0.00           H  
ATOM    716  HZ2 LYS A  47     -17.213   4.355  -5.695  1.00  0.00           H  
ATOM    717  HZ3 LYS A  47     -17.394   5.592  -6.834  1.00  0.00           H  
ATOM    718  N   ARG A  48     -13.964   1.735  -0.961  1.00  0.00           N  
ATOM    719  CA  ARG A  48     -12.889   1.088  -0.220  1.00  0.00           C  
ATOM    720  C   ARG A  48     -12.401  -0.161  -0.951  1.00  0.00           C  
ATOM    721  O   ARG A  48     -13.143  -0.773  -1.720  1.00  0.00           O  
ATOM    722  CB  ARG A  48     -13.360   0.716   1.186  1.00  0.00           C  
ATOM    723  CG  ARG A  48     -13.249   1.854   2.187  1.00  0.00           C  
ATOM    724  CD  ARG A  48     -13.297   1.344   3.618  1.00  0.00           C  
ATOM    725  NE  ARG A  48     -12.494   2.167   4.519  1.00  0.00           N  
ATOM    726  CZ  ARG A  48     -12.593   2.117   5.844  1.00  0.00           C  
ATOM    727  NH1 ARG A  48     -13.454   1.288   6.418  1.00  0.00           N  
ATOM    728  NH2 ARG A  48     -11.828   2.898   6.597  1.00  0.00           N  
ATOM    729  H   ARG A  48     -14.738   1.204  -1.243  1.00  0.00           H  
ATOM    730  HA  ARG A  48     -12.071   1.788  -0.143  1.00  0.00           H  
ATOM    731  HB2 ARG A  48     -14.395   0.409   1.137  1.00  0.00           H  
ATOM    732  HB3 ARG A  48     -12.766  -0.110   1.546  1.00  0.00           H  
ATOM    733  HG2 ARG A  48     -12.311   2.368   2.031  1.00  0.00           H  
ATOM    734  HG3 ARG A  48     -14.069   2.539   2.030  1.00  0.00           H  
ATOM    735  HD2 ARG A  48     -14.323   1.354   3.956  1.00  0.00           H  
ATOM    736  HD3 ARG A  48     -12.922   0.332   3.639  1.00  0.00           H  
ATOM    737  HE  ARG A  48     -11.851   2.786   4.116  1.00  0.00           H  
ATOM    738 HH11 ARG A  48     -14.031   0.698   5.853  1.00  0.00           H  
ATOM    739 HH12 ARG A  48     -13.526   1.251   7.415  1.00  0.00           H  
ATOM    740 HH21 ARG A  48     -11.177   3.523   6.168  1.00  0.00           H  
ATOM    741 HH22 ARG A  48     -11.903   2.859   7.592  1.00  0.00           H  
ATOM    742  N   VAL A  49     -11.148  -0.531  -0.707  1.00  0.00           N  
ATOM    743  CA  VAL A  49     -10.560  -1.705  -1.341  1.00  0.00           C  
ATOM    744  C   VAL A  49      -9.691  -2.483  -0.358  1.00  0.00           C  
ATOM    745  O   VAL A  49      -8.574  -2.071  -0.044  1.00  0.00           O  
ATOM    746  CB  VAL A  49      -9.711  -1.316  -2.565  1.00  0.00           C  
ATOM    747  CG1 VAL A  49      -9.505  -2.518  -3.476  1.00  0.00           C  
ATOM    748  CG2 VAL A  49     -10.363  -0.170  -3.323  1.00  0.00           C  
ATOM    749  H   VAL A  49     -10.606  -0.002  -0.084  1.00  0.00           H  
ATOM    750  HA  VAL A  49     -11.366  -2.342  -1.675  1.00  0.00           H  
ATOM    751  HB  VAL A  49      -8.744  -0.986  -2.217  1.00  0.00           H  
ATOM    752 HG11 VAL A  49      -9.640  -3.427  -2.907  1.00  0.00           H  
ATOM    753 HG12 VAL A  49     -10.221  -2.486  -4.283  1.00  0.00           H  
ATOM    754 HG13 VAL A  49      -8.504  -2.494  -3.880  1.00  0.00           H  
ATOM    755 HG21 VAL A  49     -10.707   0.575  -2.620  1.00  0.00           H  
ATOM    756 HG22 VAL A  49      -9.644   0.273  -3.996  1.00  0.00           H  
ATOM    757 HG23 VAL A  49     -11.203  -0.543  -3.890  1.00  0.00           H  
ATOM    758  N   ARG A  50     -10.210  -3.609   0.120  1.00  0.00           N  
ATOM    759  CA  ARG A  50      -9.481  -4.443   1.067  1.00  0.00           C  
ATOM    760  C   ARG A  50      -8.522  -5.380   0.339  1.00  0.00           C  
ATOM    761  O   ARG A  50      -8.947  -6.268  -0.401  1.00  0.00           O  
ATOM    762  CB  ARG A  50     -10.456  -5.257   1.919  1.00  0.00           C  
ATOM    763  CG  ARG A  50      -9.773  -6.184   2.911  1.00  0.00           C  
ATOM    764  CD  ARG A  50     -10.469  -6.164   4.263  1.00  0.00           C  
ATOM    765  NE  ARG A  50     -10.066  -7.290   5.102  1.00  0.00           N  
ATOM    766  CZ  ARG A  50     -10.441  -7.433   6.369  1.00  0.00           C  
ATOM    767  NH1 ARG A  50     -11.224  -6.527   6.938  1.00  0.00           N  
ATOM    768  NH2 ARG A  50     -10.033  -8.484   7.068  1.00  0.00           N  
ATOM    769  H   ARG A  50     -11.105  -3.884  -0.169  1.00  0.00           H  
ATOM    770  HA  ARG A  50      -8.910  -3.793   1.712  1.00  0.00           H  
ATOM    771  HB2 ARG A  50     -11.087  -4.576   2.473  1.00  0.00           H  
ATOM    772  HB3 ARG A  50     -11.073  -5.855   1.266  1.00  0.00           H  
ATOM    773  HG2 ARG A  50      -9.796  -7.192   2.523  1.00  0.00           H  
ATOM    774  HG3 ARG A  50      -8.749  -5.867   3.038  1.00  0.00           H  
ATOM    775  HD2 ARG A  50     -10.218  -5.242   4.768  1.00  0.00           H  
ATOM    776  HD3 ARG A  50     -11.535  -6.208   4.104  1.00  0.00           H  
ATOM    777  HE  ARG A  50      -9.487  -7.970   4.702  1.00  0.00           H  
ATOM    778 HH11 ARG A  50     -11.534  -5.734   6.414  1.00  0.00           H  
ATOM    779 HH12 ARG A  50     -11.506  -6.637   7.892  1.00  0.00           H  
ATOM    780 HH21 ARG A  50      -9.443  -9.169   6.642  1.00  0.00           H  
ATOM    781 HH22 ARG A  50     -10.316  -8.590   8.020  1.00  0.00           H  
ATOM    782  N   ILE A  51      -7.226  -5.176   0.554  1.00  0.00           N  
ATOM    783  CA  ILE A  51      -6.207  -6.002  -0.080  1.00  0.00           C  
ATOM    784  C   ILE A  51      -5.497  -6.883   0.942  1.00  0.00           C  
ATOM    785  O   ILE A  51      -4.704  -6.400   1.749  1.00  0.00           O  
ATOM    786  CB  ILE A  51      -5.162  -5.143  -0.814  1.00  0.00           C  
ATOM    787  CG1 ILE A  51      -5.845  -4.232  -1.837  1.00  0.00           C  
ATOM    788  CG2 ILE A  51      -4.128  -6.029  -1.492  1.00  0.00           C  
ATOM    789  CD1 ILE A  51      -5.357  -2.801  -1.792  1.00  0.00           C  
ATOM    790  H   ILE A  51      -6.949  -4.453   1.156  1.00  0.00           H  
ATOM    791  HA  ILE A  51      -6.697  -6.636  -0.806  1.00  0.00           H  
ATOM    792  HB  ILE A  51      -4.653  -4.532  -0.082  1.00  0.00           H  
ATOM    793 HG12 ILE A  51      -5.660  -4.614  -2.828  1.00  0.00           H  
ATOM    794 HG13 ILE A  51      -6.908  -4.228  -1.648  1.00  0.00           H  
ATOM    795 HG21 ILE A  51      -4.478  -7.051  -1.497  1.00  0.00           H  
ATOM    796 HG22 ILE A  51      -3.980  -5.697  -2.509  1.00  0.00           H  
ATOM    797 HG23 ILE A  51      -3.194  -5.971  -0.955  1.00  0.00           H  
ATOM    798 HD11 ILE A  51      -6.205  -2.134  -1.731  1.00  0.00           H  
ATOM    799 HD12 ILE A  51      -4.724  -2.662  -0.929  1.00  0.00           H  
ATOM    800 HD13 ILE A  51      -4.793  -2.585  -2.689  1.00  0.00           H  
ATOM    801  N   ASN A  52      -5.787  -8.180   0.902  1.00  0.00           N  
ATOM    802  CA  ASN A  52      -5.176  -9.129   1.825  1.00  0.00           C  
ATOM    803  C   ASN A  52      -3.903  -9.723   1.230  1.00  0.00           C  
ATOM    804  O   ASN A  52      -3.855 -10.057   0.046  1.00  0.00           O  
ATOM    805  CB  ASN A  52      -6.162 -10.247   2.167  1.00  0.00           C  
ATOM    806  CG  ASN A  52      -7.380  -9.736   2.913  1.00  0.00           C  
ATOM    807  OD1 ASN A  52      -7.266  -9.201   4.015  1.00  0.00           O  
ATOM    808  ND2 ASN A  52      -8.553  -9.899   2.312  1.00  0.00           N  
ATOM    809  H   ASN A  52      -6.428  -8.505   0.236  1.00  0.00           H  
ATOM    810  HA  ASN A  52      -4.921  -8.596   2.728  1.00  0.00           H  
ATOM    811  HB2 ASN A  52      -6.495 -10.716   1.253  1.00  0.00           H  
ATOM    812  HB3 ASN A  52      -5.666 -10.981   2.784  1.00  0.00           H  
ATOM    813 HD21 ASN A  52      -8.568 -10.335   1.433  1.00  0.00           H  
ATOM    814 HD22 ASN A  52      -9.356  -9.577   2.772  1.00  0.00           H  
ATOM    815  N   PHE A  53      -2.873  -9.852   2.059  1.00  0.00           N  
ATOM    816  CA  PHE A  53      -1.598 -10.405   1.615  1.00  0.00           C  
ATOM    817  C   PHE A  53      -1.334 -11.757   2.272  1.00  0.00           C  
ATOM    818  O   PHE A  53      -2.092 -12.197   3.136  1.00  0.00           O  
ATOM    819  CB  PHE A  53      -0.458  -9.437   1.938  1.00  0.00           C  
ATOM    820  CG  PHE A  53      -0.636  -8.076   1.329  1.00  0.00           C  
ATOM    821  CD1 PHE A  53      -1.623  -7.220   1.790  1.00  0.00           C  
ATOM    822  CD2 PHE A  53       0.182  -7.653   0.294  1.00  0.00           C  
ATOM    823  CE1 PHE A  53      -1.790  -5.967   1.233  1.00  0.00           C  
ATOM    824  CE2 PHE A  53       0.019  -6.401  -0.269  1.00  0.00           C  
ATOM    825  CZ  PHE A  53      -0.967  -5.558   0.201  1.00  0.00           C  
ATOM    826  H   PHE A  53      -2.972  -9.566   2.992  1.00  0.00           H  
ATOM    827  HA  PHE A  53      -1.652 -10.542   0.547  1.00  0.00           H  
ATOM    828  HB2 PHE A  53      -0.391  -9.315   3.008  1.00  0.00           H  
ATOM    829  HB3 PHE A  53       0.469  -9.849   1.569  1.00  0.00           H  
ATOM    830  HD1 PHE A  53      -2.266  -7.539   2.598  1.00  0.00           H  
ATOM    831  HD2 PHE A  53       0.954  -8.312  -0.075  1.00  0.00           H  
ATOM    832  HE1 PHE A  53      -2.562  -5.309   1.602  1.00  0.00           H  
ATOM    833  HE2 PHE A  53       0.664  -6.083  -1.075  1.00  0.00           H  
ATOM    834  HZ  PHE A  53      -1.096  -4.578  -0.237  1.00  0.00           H  
ATOM    835  N   SER A  54      -0.255 -12.410   1.855  1.00  0.00           N  
ATOM    836  CA  SER A  54       0.108 -13.714   2.399  1.00  0.00           C  
ATOM    837  C   SER A  54       1.098 -13.566   3.551  1.00  0.00           C  
ATOM    838  O   SER A  54       1.310 -14.497   4.325  1.00  0.00           O  
ATOM    839  CB  SER A  54       0.711 -14.597   1.304  1.00  0.00           C  
ATOM    840  OG  SER A  54       2.110 -14.736   1.474  1.00  0.00           O  
ATOM    841  H   SER A  54       0.310 -12.006   1.164  1.00  0.00           H  
ATOM    842  HA  SER A  54      -0.791 -14.179   2.771  1.00  0.00           H  
ATOM    843  HB2 SER A  54       0.256 -15.575   1.344  1.00  0.00           H  
ATOM    844  HB3 SER A  54       0.519 -14.149   0.339  1.00  0.00           H  
ATOM    845  HG  SER A  54       2.560 -14.002   1.049  1.00  0.00           H  
ATOM    846  N   ASN A  55       1.702 -12.386   3.656  1.00  0.00           N  
ATOM    847  CA  ASN A  55       2.669 -12.115   4.712  1.00  0.00           C  
ATOM    848  C   ASN A  55       2.586 -10.661   5.167  1.00  0.00           C  
ATOM    849  O   ASN A  55       2.271  -9.758   4.391  1.00  0.00           O  
ATOM    850  CB  ASN A  55       4.087 -12.427   4.226  1.00  0.00           C  
ATOM    851  CG  ASN A  55       4.421 -11.723   2.925  1.00  0.00           C  
ATOM    852  OD1 ASN A  55       3.920 -10.632   2.652  1.00  0.00           O  
ATOM    853  ND2 ASN A  55       5.270 -12.346   2.118  1.00  0.00           N  
ATOM    854  H   ASN A  55       1.492 -11.682   3.008  1.00  0.00           H  
ATOM    855  HA  ASN A  55       2.436 -12.756   5.549  1.00  0.00           H  
ATOM    856  HB2 ASN A  55       4.796 -12.111   4.977  1.00  0.00           H  
ATOM    857  HB3 ASN A  55       4.182 -13.492   4.074  1.00  0.00           H  
ATOM    858 HD21 ASN A  55       5.629 -13.213   2.400  1.00  0.00           H  
ATOM    859 HD22 ASN A  55       5.503 -11.912   1.270  1.00  0.00           H  
ATOM    860  N   PRO A  56       2.874 -10.426   6.456  1.00  0.00           N  
ATOM    861  CA  PRO A  56       2.839  -9.084   7.044  1.00  0.00           C  
ATOM    862  C   PRO A  56       3.967  -8.196   6.528  1.00  0.00           C  
ATOM    863  O   PRO A  56       4.080  -7.032   6.915  1.00  0.00           O  
ATOM    864  CB  PRO A  56       3.008  -9.348   8.542  1.00  0.00           C  
ATOM    865  CG  PRO A  56       3.729 -10.650   8.618  1.00  0.00           C  
ATOM    866  CD  PRO A  56       3.257 -11.454   7.439  1.00  0.00           C  
ATOM    867  HA  PRO A  56       1.890  -8.599   6.867  1.00  0.00           H  
ATOM    868  HB2 PRO A  56       3.584  -8.550   8.987  1.00  0.00           H  
ATOM    869  HB3 PRO A  56       2.038  -9.406   9.013  1.00  0.00           H  
ATOM    870  HG2 PRO A  56       4.793 -10.484   8.556  1.00  0.00           H  
ATOM    871  HG3 PRO A  56       3.480 -11.154   9.539  1.00  0.00           H  
ATOM    872  HD2 PRO A  56       4.057 -12.072   7.059  1.00  0.00           H  
ATOM    873  HD3 PRO A  56       2.406 -12.061   7.712  1.00  0.00           H  
ATOM    874  N   LEU A  57       4.797  -8.751   5.654  1.00  0.00           N  
ATOM    875  CA  LEU A  57       5.917  -8.010   5.084  1.00  0.00           C  
ATOM    876  C   LEU A  57       5.454  -7.126   3.929  1.00  0.00           C  
ATOM    877  O   LEU A  57       5.466  -5.900   4.030  1.00  0.00           O  
ATOM    878  CB  LEU A  57       7.001  -8.973   4.600  1.00  0.00           C  
ATOM    879  CG  LEU A  57       7.664  -9.834   5.677  1.00  0.00           C  
ATOM    880  CD1 LEU A  57       7.274 -11.294   5.511  1.00  0.00           C  
ATOM    881  CD2 LEU A  57       9.177  -9.675   5.629  1.00  0.00           C  
ATOM    882  H   LEU A  57       4.656  -9.683   5.382  1.00  0.00           H  
ATOM    883  HA  LEU A  57       6.327  -7.380   5.861  1.00  0.00           H  
ATOM    884  HB2 LEU A  57       6.553  -9.639   3.877  1.00  0.00           H  
ATOM    885  HB3 LEU A  57       7.773  -8.389   4.120  1.00  0.00           H  
ATOM    886  HG  LEU A  57       7.323  -9.506   6.650  1.00  0.00           H  
ATOM    887 HD11 LEU A  57       6.362 -11.485   6.055  1.00  0.00           H  
ATOM    888 HD12 LEU A  57       8.062 -11.923   5.897  1.00  0.00           H  
ATOM    889 HD13 LEU A  57       7.122 -11.508   4.464  1.00  0.00           H  
ATOM    890 HD21 LEU A  57       9.602  -9.988   6.572  1.00  0.00           H  
ATOM    891 HD22 LEU A  57       9.426  -8.638   5.450  1.00  0.00           H  
ATOM    892 HD23 LEU A  57       9.577 -10.283   4.833  1.00  0.00           H  
ATOM    893  N   SER A  58       5.042  -7.760   2.835  1.00  0.00           N  
ATOM    894  CA  SER A  58       4.577  -7.031   1.661  1.00  0.00           C  
ATOM    895  C   SER A  58       3.607  -5.923   2.058  1.00  0.00           C  
ATOM    896  O   SER A  58       3.778  -4.765   1.675  1.00  0.00           O  
ATOM    897  CB  SER A  58       3.900  -7.988   0.677  1.00  0.00           C  
ATOM    898  OG  SER A  58       4.478  -7.885  -0.614  1.00  0.00           O  
ATOM    899  H   SER A  58       5.056  -8.740   2.817  1.00  0.00           H  
ATOM    900  HA  SER A  58       5.437  -6.587   1.183  1.00  0.00           H  
ATOM    901  HB2 SER A  58       4.015  -9.002   1.029  1.00  0.00           H  
ATOM    902  HB3 SER A  58       2.849  -7.746   0.609  1.00  0.00           H  
ATOM    903  HG  SER A  58       3.803  -8.041  -1.279  1.00  0.00           H  
ATOM    904  N   ALA A  59       2.586  -6.286   2.828  1.00  0.00           N  
ATOM    905  CA  ALA A  59       1.590  -5.324   3.280  1.00  0.00           C  
ATOM    906  C   ALA A  59       2.234  -3.984   3.617  1.00  0.00           C  
ATOM    907  O   ALA A  59       1.660  -2.926   3.359  1.00  0.00           O  
ATOM    908  CB  ALA A  59       0.838  -5.868   4.486  1.00  0.00           C  
ATOM    909  H   ALA A  59       2.504  -7.223   3.101  1.00  0.00           H  
ATOM    910  HA  ALA A  59       0.879  -5.178   2.480  1.00  0.00           H  
ATOM    911  HB1 ALA A  59      -0.077  -5.311   4.620  1.00  0.00           H  
ATOM    912  HB2 ALA A  59       0.606  -6.910   4.324  1.00  0.00           H  
ATOM    913  HB3 ALA A  59       1.453  -5.770   5.368  1.00  0.00           H  
ATOM    914  N   ALA A  60       3.429  -4.035   4.197  1.00  0.00           N  
ATOM    915  CA  ALA A  60       4.152  -2.825   4.567  1.00  0.00           C  
ATOM    916  C   ALA A  60       4.633  -2.073   3.332  1.00  0.00           C  
ATOM    917  O   ALA A  60       4.253  -0.923   3.106  1.00  0.00           O  
ATOM    918  CB  ALA A  60       5.327  -3.169   5.470  1.00  0.00           C  
ATOM    919  H   ALA A  60       3.836  -4.908   4.377  1.00  0.00           H  
ATOM    920  HA  ALA A  60       3.477  -2.190   5.123  1.00  0.00           H  
ATOM    921  HB1 ALA A  60       5.421  -4.243   5.546  1.00  0.00           H  
ATOM    922  HB2 ALA A  60       6.234  -2.757   5.052  1.00  0.00           H  
ATOM    923  HB3 ALA A  60       5.162  -2.752   6.452  1.00  0.00           H  
ATOM    924  N   ASP A  61       5.472  -2.726   2.536  1.00  0.00           N  
ATOM    925  CA  ASP A  61       6.005  -2.118   1.322  1.00  0.00           C  
ATOM    926  C   ASP A  61       4.881  -1.569   0.450  1.00  0.00           C  
ATOM    927  O   ASP A  61       5.031  -0.532  -0.194  1.00  0.00           O  
ATOM    928  CB  ASP A  61       6.827  -3.139   0.533  1.00  0.00           C  
ATOM    929  CG  ASP A  61       8.295  -2.766   0.456  1.00  0.00           C  
ATOM    930  OD1 ASP A  61       9.038  -3.075   1.412  1.00  0.00           O  
ATOM    931  OD2 ASP A  61       8.700  -2.165  -0.560  1.00  0.00           O  
ATOM    932  H   ASP A  61       5.738  -3.640   2.770  1.00  0.00           H  
ATOM    933  HA  ASP A  61       6.648  -1.302   1.615  1.00  0.00           H  
ATOM    934  HB2 ASP A  61       6.745  -4.105   1.013  1.00  0.00           H  
ATOM    935  HB3 ASP A  61       6.437  -3.205  -0.472  1.00  0.00           H  
ATOM    936  N   ALA A  62       3.753  -2.273   0.434  1.00  0.00           N  
ATOM    937  CA  ALA A  62       2.603  -1.855  -0.358  1.00  0.00           C  
ATOM    938  C   ALA A  62       2.154  -0.451   0.027  1.00  0.00           C  
ATOM    939  O   ALA A  62       1.566   0.267  -0.783  1.00  0.00           O  
ATOM    940  CB  ALA A  62       1.459  -2.844  -0.188  1.00  0.00           C  
ATOM    941  H   ALA A  62       3.694  -3.092   0.969  1.00  0.00           H  
ATOM    942  HA  ALA A  62       2.896  -1.858  -1.398  1.00  0.00           H  
ATOM    943  HB1 ALA A  62       1.324  -3.059   0.862  1.00  0.00           H  
ATOM    944  HB2 ALA A  62       0.551  -2.415  -0.587  1.00  0.00           H  
ATOM    945  HB3 ALA A  62       1.691  -3.756  -0.716  1.00  0.00           H  
ATOM    946  N   ARG A  63       2.430  -0.064   1.267  1.00  0.00           N  
ATOM    947  CA  ARG A  63       2.053   1.255   1.759  1.00  0.00           C  
ATOM    948  C   ARG A  63       3.021   2.322   1.257  1.00  0.00           C  
ATOM    949  O   ARG A  63       2.610   3.319   0.663  1.00  0.00           O  
ATOM    950  CB  ARG A  63       2.017   1.262   3.289  1.00  0.00           C  
ATOM    951  CG  ARG A  63       1.768   2.637   3.887  1.00  0.00           C  
ATOM    952  CD  ARG A  63       1.819   2.602   5.405  1.00  0.00           C  
ATOM    953  NE  ARG A  63       1.620   3.925   5.991  1.00  0.00           N  
ATOM    954  CZ  ARG A  63       1.944   4.233   7.242  1.00  0.00           C  
ATOM    955  NH1 ARG A  63       2.481   3.315   8.035  1.00  0.00           N  
ATOM    956  NH2 ARG A  63       1.733   5.458   7.702  1.00  0.00           N  
ATOM    957  H   ARG A  63       2.902  -0.680   1.866  1.00  0.00           H  
ATOM    958  HA  ARG A  63       1.064   1.478   1.384  1.00  0.00           H  
ATOM    959  HB2 ARG A  63       1.231   0.602   3.623  1.00  0.00           H  
ATOM    960  HB3 ARG A  63       2.964   0.898   3.659  1.00  0.00           H  
ATOM    961  HG2 ARG A  63       2.527   3.318   3.528  1.00  0.00           H  
ATOM    962  HG3 ARG A  63       0.794   2.984   3.575  1.00  0.00           H  
ATOM    963  HD2 ARG A  63       1.044   1.941   5.763  1.00  0.00           H  
ATOM    964  HD3 ARG A  63       2.782   2.225   5.711  1.00  0.00           H  
ATOM    965  HE  ARG A  63       1.224   4.618   5.423  1.00  0.00           H  
ATOM    966 HH11 ARG A  63       2.643   2.390   7.690  1.00  0.00           H  
ATOM    967 HH12 ARG A  63       2.726   3.548   8.976  1.00  0.00           H  
ATOM    968 HH21 ARG A  63       1.328   6.152   7.107  1.00  0.00           H  
ATOM    969 HH22 ARG A  63       1.977   5.688   8.643  1.00  0.00           H  
ATOM    970  N   LEU A  64       4.308   2.105   1.501  1.00  0.00           N  
ATOM    971  CA  LEU A  64       5.338   3.048   1.073  1.00  0.00           C  
ATOM    972  C   LEU A  64       5.320   3.222  -0.442  1.00  0.00           C  
ATOM    973  O   LEU A  64       5.489   4.331  -0.951  1.00  0.00           O  
ATOM    974  CB  LEU A  64       6.716   2.568   1.528  1.00  0.00           C  
ATOM    975  CG  LEU A  64       7.518   1.762   0.505  1.00  0.00           C  
ATOM    976  CD1 LEU A  64       8.255   2.691  -0.447  1.00  0.00           C  
ATOM    977  CD2 LEU A  64       8.495   0.830   1.207  1.00  0.00           C  
ATOM    978  H   LEU A  64       4.576   1.293   1.978  1.00  0.00           H  
ATOM    979  HA  LEU A  64       5.126   4.001   1.536  1.00  0.00           H  
ATOM    980  HB2 LEU A  64       7.299   3.438   1.792  1.00  0.00           H  
ATOM    981  HB3 LEU A  64       6.580   1.949   2.403  1.00  0.00           H  
ATOM    982  HG  LEU A  64       6.838   1.157  -0.080  1.00  0.00           H  
ATOM    983 HD11 LEU A  64       8.226   2.281  -1.445  1.00  0.00           H  
ATOM    984 HD12 LEU A  64       9.282   2.791  -0.129  1.00  0.00           H  
ATOM    985 HD13 LEU A  64       7.781   3.661  -0.441  1.00  0.00           H  
ATOM    986 HD21 LEU A  64       8.155   0.646   2.215  1.00  0.00           H  
ATOM    987 HD22 LEU A  64       9.473   1.288   1.234  1.00  0.00           H  
ATOM    988 HD23 LEU A  64       8.550  -0.105   0.669  1.00  0.00           H  
ATOM    989  N   ARG A  65       5.113   2.122  -1.157  1.00  0.00           N  
ATOM    990  CA  ARG A  65       5.073   2.153  -2.613  1.00  0.00           C  
ATOM    991  C   ARG A  65       3.750   2.729  -3.109  1.00  0.00           C  
ATOM    992  O   ARG A  65       3.561   2.940  -4.307  1.00  0.00           O  
ATOM    993  CB  ARG A  65       5.274   0.747  -3.181  1.00  0.00           C  
ATOM    994  CG  ARG A  65       6.731   0.387  -3.415  1.00  0.00           C  
ATOM    995  CD  ARG A  65       6.964  -0.107  -4.835  1.00  0.00           C  
ATOM    996  NE  ARG A  65       8.357  -0.480  -5.063  1.00  0.00           N  
ATOM    997  CZ  ARG A  65       8.874  -0.680  -6.271  1.00  0.00           C  
ATOM    998  NH1 ARG A  65       8.117  -0.545  -7.351  1.00  0.00           N  
ATOM    999  NH2 ARG A  65      10.151  -1.016  -6.398  1.00  0.00           N  
ATOM   1000  H   ARG A  65       4.986   1.267  -0.694  1.00  0.00           H  
ATOM   1001  HA  ARG A  65       5.879   2.788  -2.954  1.00  0.00           H  
ATOM   1002  HB2 ARG A  65       4.856   0.030  -2.492  1.00  0.00           H  
ATOM   1003  HB3 ARG A  65       4.753   0.675  -4.124  1.00  0.00           H  
ATOM   1004  HG2 ARG A  65       7.342   1.263  -3.247  1.00  0.00           H  
ATOM   1005  HG3 ARG A  65       7.017  -0.389  -2.721  1.00  0.00           H  
ATOM   1006  HD2 ARG A  65       6.337  -0.970  -5.009  1.00  0.00           H  
ATOM   1007  HD3 ARG A  65       6.692   0.679  -5.524  1.00  0.00           H  
ATOM   1008  HE  ARG A  65       8.933  -0.584  -4.280  1.00  0.00           H  
ATOM   1009 HH11 ARG A  65       7.156  -0.290  -7.258  1.00  0.00           H  
ATOM   1010 HH12 ARG A  65       8.510  -0.695  -8.259  1.00  0.00           H  
ATOM   1011 HH21 ARG A  65      10.724  -1.120  -5.587  1.00  0.00           H  
ATOM   1012 HH22 ARG A  65      10.539  -1.167  -7.307  1.00  0.00           H  
ATOM   1013  N   LEU A  66       2.835   2.983  -2.178  1.00  0.00           N  
ATOM   1014  CA  LEU A  66       1.528   3.534  -2.520  1.00  0.00           C  
ATOM   1015  C   LEU A  66       1.133   4.638  -1.544  1.00  0.00           C  
ATOM   1016  O   LEU A  66       1.986   5.358  -1.026  1.00  0.00           O  
ATOM   1017  CB  LEU A  66       0.471   2.430  -2.516  1.00  0.00           C  
ATOM   1018  CG  LEU A  66       0.866   1.118  -3.195  1.00  0.00           C  
ATOM   1019  CD1 LEU A  66      -0.075  -0.003  -2.783  1.00  0.00           C  
ATOM   1020  CD2 LEU A  66       0.872   1.282  -4.707  1.00  0.00           C  
ATOM   1021  H   LEU A  66       3.044   2.794  -1.239  1.00  0.00           H  
ATOM   1022  HA  LEU A  66       1.596   3.953  -3.513  1.00  0.00           H  
ATOM   1023  HB2 LEU A  66       0.228   2.208  -1.488  1.00  0.00           H  
ATOM   1024  HB3 LEU A  66      -0.407   2.812  -3.017  1.00  0.00           H  
ATOM   1025  HG  LEU A  66       1.866   0.845  -2.884  1.00  0.00           H  
ATOM   1026 HD11 LEU A  66      -0.601   0.282  -1.883  1.00  0.00           H  
ATOM   1027 HD12 LEU A  66       0.494  -0.901  -2.599  1.00  0.00           H  
ATOM   1028 HD13 LEU A  66      -0.787  -0.183  -3.574  1.00  0.00           H  
ATOM   1029 HD21 LEU A  66      -0.119   1.095  -5.093  1.00  0.00           H  
ATOM   1030 HD22 LEU A  66       1.567   0.578  -5.144  1.00  0.00           H  
ATOM   1031 HD23 LEU A  66       1.175   2.289  -4.959  1.00  0.00           H  
ATOM   1032  N   HIS A  67      -0.168   4.764  -1.298  1.00  0.00           N  
ATOM   1033  CA  HIS A  67      -0.678   5.778  -0.383  1.00  0.00           C  
ATOM   1034  C   HIS A  67      -0.834   7.119  -1.091  1.00  0.00           C  
ATOM   1035  O   HIS A  67      -1.173   7.174  -2.274  1.00  0.00           O  
ATOM   1036  CB  HIS A  67       0.257   5.928   0.817  1.00  0.00           C  
ATOM   1037  CG  HIS A  67      -0.439   6.370   2.068  1.00  0.00           C  
ATOM   1038  ND1 HIS A  67      -1.809   6.329   2.220  1.00  0.00           N  
ATOM   1039  CD2 HIS A  67       0.052   6.860   3.230  1.00  0.00           C  
ATOM   1040  CE1 HIS A  67      -2.130   6.779   3.421  1.00  0.00           C  
ATOM   1041  NE2 HIS A  67      -1.017   7.106   4.054  1.00  0.00           N  
ATOM   1042  H   HIS A  67      -0.799   4.159  -1.743  1.00  0.00           H  
ATOM   1043  HA  HIS A  67      -1.647   5.453  -0.034  1.00  0.00           H  
ATOM   1044  HB2 HIS A  67       0.729   4.978   1.020  1.00  0.00           H  
ATOM   1045  HB3 HIS A  67       1.017   6.661   0.585  1.00  0.00           H  
ATOM   1046  HD1 HIS A  67      -2.450   6.020   1.549  1.00  0.00           H  
ATOM   1047  HD2 HIS A  67       1.094   7.028   3.465  1.00  0.00           H  
ATOM   1048  HE1 HIS A  67      -3.130   6.861   3.818  1.00  0.00           H  
ATOM   1049  N   LYS A  68      -0.585   8.202  -0.362  1.00  0.00           N  
ATOM   1050  CA  LYS A  68      -0.698   9.545  -0.919  1.00  0.00           C  
ATOM   1051  C   LYS A  68      -0.268   9.564  -2.382  1.00  0.00           C  
ATOM   1052  O   LYS A  68      -0.784  10.346  -3.182  1.00  0.00           O  
ATOM   1053  CB  LYS A  68       0.154  10.526  -0.113  1.00  0.00           C  
ATOM   1054  CG  LYS A  68      -0.484  10.954   1.197  1.00  0.00           C  
ATOM   1055  CD  LYS A  68       0.553  11.465   2.183  1.00  0.00           C  
ATOM   1056  CE  LYS A  68       0.806  10.459   3.296  1.00  0.00           C  
ATOM   1057  NZ  LYS A  68       0.346  10.967   4.618  1.00  0.00           N  
ATOM   1058  H   LYS A  68      -0.318   8.095   0.576  1.00  0.00           H  
ATOM   1059  HA  LYS A  68      -1.733   9.844  -0.857  1.00  0.00           H  
ATOM   1060  HB2 LYS A  68       1.105  10.063   0.109  1.00  0.00           H  
ATOM   1061  HB3 LYS A  68       0.327  11.411  -0.710  1.00  0.00           H  
ATOM   1062  HG2 LYS A  68      -1.195  11.743   1.000  1.00  0.00           H  
ATOM   1063  HG3 LYS A  68      -0.996  10.107   1.632  1.00  0.00           H  
ATOM   1064  HD2 LYS A  68       1.479  11.643   1.658  1.00  0.00           H  
ATOM   1065  HD3 LYS A  68       0.199  12.390   2.618  1.00  0.00           H  
ATOM   1066  HE2 LYS A  68       0.275   9.547   3.068  1.00  0.00           H  
ATOM   1067  HE3 LYS A  68       1.866  10.256   3.345  1.00  0.00           H  
ATOM   1068  HZ1 LYS A  68      -0.407  11.672   4.488  1.00  0.00           H  
ATOM   1069  HZ2 LYS A  68       1.139  11.414   5.124  1.00  0.00           H  
ATOM   1070  HZ3 LYS A  68      -0.021  10.184   5.195  1.00  0.00           H  
ATOM   1071  N   THR A  69       0.679   8.697  -2.727  1.00  0.00           N  
ATOM   1072  CA  THR A  69       1.178   8.614  -4.094  1.00  0.00           C  
ATOM   1073  C   THR A  69       0.076   8.924  -5.102  1.00  0.00           C  
ATOM   1074  O   THR A  69      -1.004   8.337  -5.052  1.00  0.00           O  
ATOM   1075  CB  THR A  69       1.758   7.220  -4.397  1.00  0.00           C  
ATOM   1076  OG1 THR A  69       0.796   6.209  -4.077  1.00  0.00           O  
ATOM   1077  CG2 THR A  69       3.035   6.981  -3.605  1.00  0.00           C  
ATOM   1078  H   THR A  69       1.051   8.101  -2.046  1.00  0.00           H  
ATOM   1079  HA  THR A  69       1.969   9.342  -4.205  1.00  0.00           H  
ATOM   1080  HB  THR A  69       1.990   7.164  -5.452  1.00  0.00           H  
ATOM   1081  HG1 THR A  69      -0.091   6.566  -4.181  1.00  0.00           H  
ATOM   1082 HG21 THR A  69       3.809   6.628  -4.268  1.00  0.00           H  
ATOM   1083 HG22 THR A  69       2.850   6.242  -2.840  1.00  0.00           H  
ATOM   1084 HG23 THR A  69       3.349   7.905  -3.145  1.00  0.00           H  
ATOM   1085  N   GLU A  70       0.357   9.847  -6.015  1.00  0.00           N  
ATOM   1086  CA  GLU A  70      -0.612  10.233  -7.034  1.00  0.00           C  
ATOM   1087  C   GLU A  70      -0.928   9.061  -7.956  1.00  0.00           C  
ATOM   1088  O   GLU A  70      -0.232   8.828  -8.945  1.00  0.00           O  
ATOM   1089  CB  GLU A  70      -0.082  11.411  -7.853  1.00  0.00           C  
ATOM   1090  CG  GLU A  70      -0.662  12.752  -7.438  1.00  0.00           C  
ATOM   1091  CD  GLU A  70       0.050  13.924  -8.087  1.00  0.00           C  
ATOM   1092  OE1 GLU A  70       0.142  13.944  -9.333  1.00  0.00           O  
ATOM   1093  OE2 GLU A  70       0.515  14.819  -7.351  1.00  0.00           O  
ATOM   1094  H   GLU A  70       1.236  10.280  -6.003  1.00  0.00           H  
ATOM   1095  HA  GLU A  70      -1.519  10.536  -6.531  1.00  0.00           H  
ATOM   1096  HB2 GLU A  70       0.992  11.457  -7.744  1.00  0.00           H  
ATOM   1097  HB3 GLU A  70      -0.320  11.248  -8.893  1.00  0.00           H  
ATOM   1098  HG2 GLU A  70      -1.704  12.784  -7.721  1.00  0.00           H  
ATOM   1099  HG3 GLU A  70      -0.579  12.850  -6.365  1.00  0.00           H  
ATOM   1100  N   PHE A  71      -1.984   8.322  -7.625  1.00  0.00           N  
ATOM   1101  CA  PHE A  71      -2.392   7.173  -8.422  1.00  0.00           C  
ATOM   1102  C   PHE A  71      -3.106   7.618  -9.694  1.00  0.00           C  
ATOM   1103  O   PHE A  71      -4.277   8.001  -9.662  1.00  0.00           O  
ATOM   1104  CB  PHE A  71      -3.307   6.258  -7.604  1.00  0.00           C  
ATOM   1105  CG  PHE A  71      -3.994   5.206  -8.427  1.00  0.00           C  
ATOM   1106  CD1 PHE A  71      -3.346   4.025  -8.749  1.00  0.00           C  
ATOM   1107  CD2 PHE A  71      -5.290   5.399  -8.878  1.00  0.00           C  
ATOM   1108  CE1 PHE A  71      -3.976   3.057  -9.506  1.00  0.00           C  
ATOM   1109  CE2 PHE A  71      -5.926   4.434  -9.636  1.00  0.00           C  
ATOM   1110  CZ  PHE A  71      -5.269   3.261  -9.950  1.00  0.00           C  
ATOM   1111  H   PHE A  71      -2.498   8.558  -6.824  1.00  0.00           H  
ATOM   1112  HA  PHE A  71      -1.503   6.626  -8.695  1.00  0.00           H  
ATOM   1113  HB2 PHE A  71      -2.719   5.756  -6.848  1.00  0.00           H  
ATOM   1114  HB3 PHE A  71      -4.067   6.856  -7.124  1.00  0.00           H  
ATOM   1115  HD1 PHE A  71      -2.336   3.864  -8.402  1.00  0.00           H  
ATOM   1116  HD2 PHE A  71      -5.806   6.316  -8.633  1.00  0.00           H  
ATOM   1117  HE1 PHE A  71      -3.461   2.140  -9.750  1.00  0.00           H  
ATOM   1118  HE2 PHE A  71      -6.937   4.597  -9.981  1.00  0.00           H  
ATOM   1119  HZ  PHE A  71      -5.763   2.505 -10.543  1.00  0.00           H  
ATOM   1120  N   LEU A  72      -2.395   7.565 -10.814  1.00  0.00           N  
ATOM   1121  CA  LEU A  72      -2.959   7.963 -12.099  1.00  0.00           C  
ATOM   1122  C   LEU A  72      -3.357   9.436 -12.086  1.00  0.00           C  
ATOM   1123  O   LEU A  72      -4.157   9.881 -12.907  1.00  0.00           O  
ATOM   1124  CB  LEU A  72      -4.175   7.098 -12.435  1.00  0.00           C  
ATOM   1125  CG  LEU A  72      -3.885   5.791 -13.172  1.00  0.00           C  
ATOM   1126  CD1 LEU A  72      -4.298   4.597 -12.326  1.00  0.00           C  
ATOM   1127  CD2 LEU A  72      -4.600   5.767 -14.516  1.00  0.00           C  
ATOM   1128  H   LEU A  72      -1.467   7.251 -10.778  1.00  0.00           H  
ATOM   1129  HA  LEU A  72      -2.201   7.814 -12.854  1.00  0.00           H  
ATOM   1130  HB2 LEU A  72      -4.672   6.852 -11.508  1.00  0.00           H  
ATOM   1131  HB3 LEU A  72      -4.838   7.687 -13.051  1.00  0.00           H  
ATOM   1132  HG  LEU A  72      -2.822   5.717 -13.357  1.00  0.00           H  
ATOM   1133 HD11 LEU A  72      -5.360   4.432 -12.430  1.00  0.00           H  
ATOM   1134 HD12 LEU A  72      -4.063   4.792 -11.289  1.00  0.00           H  
ATOM   1135 HD13 LEU A  72      -3.762   3.719 -12.655  1.00  0.00           H  
ATOM   1136 HD21 LEU A  72      -5.542   5.247 -14.412  1.00  0.00           H  
ATOM   1137 HD22 LEU A  72      -3.984   5.256 -15.241  1.00  0.00           H  
ATOM   1138 HD23 LEU A  72      -4.781   6.780 -14.846  1.00  0.00           H  
ATOM   1139  N   GLY A  73      -2.788  10.190 -11.149  1.00  0.00           N  
ATOM   1140  CA  GLY A  73      -3.094  11.604 -11.047  1.00  0.00           C  
ATOM   1141  C   GLY A  73      -3.907  11.935  -9.813  1.00  0.00           C  
ATOM   1142  O   GLY A  73      -3.891  13.069  -9.333  1.00  0.00           O  
ATOM   1143  H   GLY A  73      -2.156   9.780 -10.522  1.00  0.00           H  
ATOM   1144  HA2 GLY A  73      -2.169  12.160 -11.016  1.00  0.00           H  
ATOM   1145  HA3 GLY A  73      -3.651  11.903 -11.923  1.00  0.00           H  
ATOM   1146  N   LYS A  74      -4.625  10.943  -9.296  1.00  0.00           N  
ATOM   1147  CA  LYS A  74      -5.450  11.131  -8.109  1.00  0.00           C  
ATOM   1148  C   LYS A  74      -4.781  10.529  -6.879  1.00  0.00           C  
ATOM   1149  O   LYS A  74      -4.474   9.337  -6.851  1.00  0.00           O  
ATOM   1150  CB  LYS A  74      -6.829  10.501  -8.315  1.00  0.00           C  
ATOM   1151  CG  LYS A  74      -7.614  11.114  -9.462  1.00  0.00           C  
ATOM   1152  CD  LYS A  74      -8.670  12.083  -8.960  1.00  0.00           C  
ATOM   1153  CE  LYS A  74      -9.670  12.432 -10.052  1.00  0.00           C  
ATOM   1154  NZ  LYS A  74     -10.765  13.305  -9.542  1.00  0.00           N  
ATOM   1155  H   LYS A  74      -4.598  10.060  -9.724  1.00  0.00           H  
ATOM   1156  HA  LYS A  74      -5.570  12.194  -7.954  1.00  0.00           H  
ATOM   1157  HB2 LYS A  74      -6.702   9.447  -8.515  1.00  0.00           H  
ATOM   1158  HB3 LYS A  74      -7.405  10.620  -7.408  1.00  0.00           H  
ATOM   1159  HG2 LYS A  74      -6.932  11.644 -10.110  1.00  0.00           H  
ATOM   1160  HG3 LYS A  74      -8.098  10.322 -10.017  1.00  0.00           H  
ATOM   1161  HD2 LYS A  74      -9.198  11.631  -8.134  1.00  0.00           H  
ATOM   1162  HD3 LYS A  74      -8.183  12.989  -8.626  1.00  0.00           H  
ATOM   1163  HE2 LYS A  74      -9.152  12.946 -10.846  1.00  0.00           H  
ATOM   1164  HE3 LYS A  74     -10.098  11.517 -10.433  1.00  0.00           H  
ATOM   1165  HZ1 LYS A  74     -11.193  13.834 -10.327  1.00  0.00           H  
ATOM   1166  HZ2 LYS A  74     -10.388  13.981  -8.847  1.00  0.00           H  
ATOM   1167  HZ3 LYS A  74     -11.499  12.727  -9.086  1.00  0.00           H  
ATOM   1168  N   GLU A  75      -4.560  11.357  -5.863  1.00  0.00           N  
ATOM   1169  CA  GLU A  75      -3.928  10.903  -4.631  1.00  0.00           C  
ATOM   1170  C   GLU A  75      -4.800   9.870  -3.921  1.00  0.00           C  
ATOM   1171  O   GLU A  75      -5.975  10.117  -3.648  1.00  0.00           O  
ATOM   1172  CB  GLU A  75      -3.663  12.089  -3.700  1.00  0.00           C  
ATOM   1173  CG  GLU A  75      -3.207  11.680  -2.309  1.00  0.00           C  
ATOM   1174  CD  GLU A  75      -3.979  12.386  -1.212  1.00  0.00           C  
ATOM   1175  OE1 GLU A  75      -5.226  12.307  -1.219  1.00  0.00           O  
ATOM   1176  OE2 GLU A  75      -3.338  13.017  -0.346  1.00  0.00           O  
ATOM   1177  H   GLU A  75      -4.829  12.297  -5.946  1.00  0.00           H  
ATOM   1178  HA  GLU A  75      -2.987  10.443  -4.891  1.00  0.00           H  
ATOM   1179  HB2 GLU A  75      -2.898  12.711  -4.139  1.00  0.00           H  
ATOM   1180  HB3 GLU A  75      -4.570  12.664  -3.604  1.00  0.00           H  
ATOM   1181  HG2 GLU A  75      -3.344  10.615  -2.196  1.00  0.00           H  
ATOM   1182  HG3 GLU A  75      -2.158  11.921  -2.203  1.00  0.00           H  
ATOM   1183  N   MET A  76      -4.215   8.714  -3.624  1.00  0.00           N  
ATOM   1184  CA  MET A  76      -4.937   7.645  -2.946  1.00  0.00           C  
ATOM   1185  C   MET A  76      -4.447   7.482  -1.511  1.00  0.00           C  
ATOM   1186  O   MET A  76      -3.351   7.922  -1.166  1.00  0.00           O  
ATOM   1187  CB  MET A  76      -4.773   6.327  -3.705  1.00  0.00           C  
ATOM   1188  CG  MET A  76      -4.897   5.096  -2.821  1.00  0.00           C  
ATOM   1189  SD  MET A  76      -4.725   3.558  -3.746  1.00  0.00           S  
ATOM   1190  CE  MET A  76      -2.995   3.628  -4.203  1.00  0.00           C  
ATOM   1191  H   MET A  76      -3.275   8.577  -3.867  1.00  0.00           H  
ATOM   1192  HA  MET A  76      -5.985   7.912  -2.928  1.00  0.00           H  
ATOM   1193  HB2 MET A  76      -5.531   6.271  -4.472  1.00  0.00           H  
ATOM   1194  HB3 MET A  76      -3.800   6.313  -4.171  1.00  0.00           H  
ATOM   1195  HG2 MET A  76      -4.127   5.133  -2.065  1.00  0.00           H  
ATOM   1196  HG3 MET A  76      -5.866   5.109  -2.346  1.00  0.00           H  
ATOM   1197  HE1 MET A  76      -2.470   4.281  -3.522  1.00  0.00           H  
ATOM   1198  HE2 MET A  76      -2.570   2.638  -4.155  1.00  0.00           H  
ATOM   1199  HE3 MET A  76      -2.905   4.011  -5.210  1.00  0.00           H  
ATOM   1200  N   LYS A  77      -5.267   6.850  -0.677  1.00  0.00           N  
ATOM   1201  CA  LYS A  77      -4.917   6.628   0.720  1.00  0.00           C  
ATOM   1202  C   LYS A  77      -4.883   5.137   1.043  1.00  0.00           C  
ATOM   1203  O   LYS A  77      -5.405   4.318   0.288  1.00  0.00           O  
ATOM   1204  CB  LYS A  77      -5.917   7.337   1.636  1.00  0.00           C  
ATOM   1205  CG  LYS A  77      -5.559   8.785   1.922  1.00  0.00           C  
ATOM   1206  CD  LYS A  77      -6.712   9.524   2.582  1.00  0.00           C  
ATOM   1207  CE  LYS A  77      -7.468  10.383   1.581  1.00  0.00           C  
ATOM   1208  NZ  LYS A  77      -8.944  10.259   1.748  1.00  0.00           N  
ATOM   1209  H   LYS A  77      -6.129   6.524  -1.012  1.00  0.00           H  
ATOM   1210  HA  LYS A  77      -3.933   7.043   0.886  1.00  0.00           H  
ATOM   1211  HB2 LYS A  77      -6.891   7.314   1.172  1.00  0.00           H  
ATOM   1212  HB3 LYS A  77      -5.963   6.807   2.577  1.00  0.00           H  
ATOM   1213  HG2 LYS A  77      -4.704   8.812   2.582  1.00  0.00           H  
ATOM   1214  HG3 LYS A  77      -5.313   9.277   0.992  1.00  0.00           H  
ATOM   1215  HD2 LYS A  77      -7.393   8.804   3.010  1.00  0.00           H  
ATOM   1216  HD3 LYS A  77      -6.319  10.160   3.364  1.00  0.00           H  
ATOM   1217  HE2 LYS A  77      -7.184  11.414   1.721  1.00  0.00           H  
ATOM   1218  HE3 LYS A  77      -7.201  10.069   0.583  1.00  0.00           H  
ATOM   1219  HZ1 LYS A  77      -9.229   9.261   1.682  1.00  0.00           H  
ATOM   1220  HZ2 LYS A  77      -9.434  10.799   1.006  1.00  0.00           H  
ATOM   1221  HZ3 LYS A  77      -9.230  10.630   2.676  1.00  0.00           H  
ATOM   1222  N   LEU A  78      -4.266   4.795   2.169  1.00  0.00           N  
ATOM   1223  CA  LEU A  78      -4.165   3.403   2.593  1.00  0.00           C  
ATOM   1224  C   LEU A  78      -4.112   3.300   4.113  1.00  0.00           C  
ATOM   1225  O   LEU A  78      -3.279   3.936   4.760  1.00  0.00           O  
ATOM   1226  CB  LEU A  78      -2.924   2.751   1.981  1.00  0.00           C  
ATOM   1227  CG  LEU A  78      -3.086   2.201   0.563  1.00  0.00           C  
ATOM   1228  CD1 LEU A  78      -1.826   2.450  -0.252  1.00  0.00           C  
ATOM   1229  CD2 LEU A  78      -3.413   0.715   0.601  1.00  0.00           C  
ATOM   1230  H   LEU A  78      -3.868   5.494   2.729  1.00  0.00           H  
ATOM   1231  HA  LEU A  78      -5.046   2.885   2.239  1.00  0.00           H  
ATOM   1232  HB2 LEU A  78      -2.139   3.491   1.961  1.00  0.00           H  
ATOM   1233  HB3 LEU A  78      -2.631   1.932   2.624  1.00  0.00           H  
ATOM   1234  HG  LEU A  78      -3.904   2.713   0.076  1.00  0.00           H  
ATOM   1235 HD11 LEU A  78      -1.140   1.628  -0.114  1.00  0.00           H  
ATOM   1236 HD12 LEU A  78      -1.361   3.368   0.076  1.00  0.00           H  
ATOM   1237 HD13 LEU A  78      -2.084   2.532  -1.298  1.00  0.00           H  
ATOM   1238 HD21 LEU A  78      -2.586   0.176   1.039  1.00  0.00           H  
ATOM   1239 HD22 LEU A  78      -3.583   0.359  -0.404  1.00  0.00           H  
ATOM   1240 HD23 LEU A  78      -4.300   0.558   1.196  1.00  0.00           H  
ATOM   1241  N   TYR A  79      -5.002   2.492   4.678  1.00  0.00           N  
ATOM   1242  CA  TYR A  79      -5.055   2.305   6.123  1.00  0.00           C  
ATOM   1243  C   TYR A  79      -4.804   0.846   6.493  1.00  0.00           C  
ATOM   1244  O   TYR A  79      -5.208  -0.067   5.774  1.00  0.00           O  
ATOM   1245  CB  TYR A  79      -6.413   2.754   6.667  1.00  0.00           C  
ATOM   1246  CG  TYR A  79      -6.661   4.238   6.524  1.00  0.00           C  
ATOM   1247  CD1 TYR A  79      -7.049   4.785   5.307  1.00  0.00           C  
ATOM   1248  CD2 TYR A  79      -6.509   5.095   7.608  1.00  0.00           C  
ATOM   1249  CE1 TYR A  79      -7.276   6.141   5.172  1.00  0.00           C  
ATOM   1250  CE2 TYR A  79      -6.736   6.451   7.483  1.00  0.00           C  
ATOM   1251  CZ  TYR A  79      -7.119   6.970   6.263  1.00  0.00           C  
ATOM   1252  OH  TYR A  79      -7.346   8.320   6.134  1.00  0.00           O  
ATOM   1253  H   TYR A  79      -5.640   2.012   4.109  1.00  0.00           H  
ATOM   1254  HA  TYR A  79      -4.282   2.916   6.566  1.00  0.00           H  
ATOM   1255  HB2 TYR A  79      -7.196   2.235   6.135  1.00  0.00           H  
ATOM   1256  HB3 TYR A  79      -6.473   2.506   7.716  1.00  0.00           H  
ATOM   1257  HD1 TYR A  79      -7.172   4.131   4.456  1.00  0.00           H  
ATOM   1258  HD2 TYR A  79      -6.210   4.686   8.561  1.00  0.00           H  
ATOM   1259  HE1 TYR A  79      -7.577   6.546   4.217  1.00  0.00           H  
ATOM   1260  HE2 TYR A  79      -6.613   7.103   8.336  1.00  0.00           H  
ATOM   1261  HH  TYR A  79      -8.280   8.502   6.267  1.00  0.00           H  
ATOM   1262  N   PHE A  80      -4.134   0.637   7.621  1.00  0.00           N  
ATOM   1263  CA  PHE A  80      -3.827  -0.711   8.089  1.00  0.00           C  
ATOM   1264  C   PHE A  80      -5.055  -1.359   8.722  1.00  0.00           C  
ATOM   1265  O   PHE A  80      -5.438  -1.025   9.843  1.00  0.00           O  
ATOM   1266  CB  PHE A  80      -2.678  -0.674   9.098  1.00  0.00           C  
ATOM   1267  CG  PHE A  80      -1.429  -1.350   8.610  1.00  0.00           C  
ATOM   1268  CD1 PHE A  80      -1.220  -2.700   8.844  1.00  0.00           C  
ATOM   1269  CD2 PHE A  80      -0.464  -0.638   7.917  1.00  0.00           C  
ATOM   1270  CE1 PHE A  80      -0.072  -3.326   8.397  1.00  0.00           C  
ATOM   1271  CE2 PHE A  80       0.686  -1.257   7.467  1.00  0.00           C  
ATOM   1272  CZ  PHE A  80       0.883  -2.604   7.706  1.00  0.00           C  
ATOM   1273  H   PHE A  80      -3.839   1.406   8.152  1.00  0.00           H  
ATOM   1274  HA  PHE A  80      -3.526  -1.296   7.235  1.00  0.00           H  
ATOM   1275  HB2 PHE A  80      -2.433   0.355   9.316  1.00  0.00           H  
ATOM   1276  HB3 PHE A  80      -2.991  -1.165  10.006  1.00  0.00           H  
ATOM   1277  HD1 PHE A  80      -1.966  -3.266   9.384  1.00  0.00           H  
ATOM   1278  HD2 PHE A  80      -0.618   0.415   7.728  1.00  0.00           H  
ATOM   1279  HE1 PHE A  80       0.078  -4.377   8.585  1.00  0.00           H  
ATOM   1280  HE2 PHE A  80       1.429  -0.689   6.927  1.00  0.00           H  
ATOM   1281  HZ  PHE A  80       1.780  -3.089   7.356  1.00  0.00           H  
ATOM   1282  N   ALA A  81      -5.666  -2.289   7.996  1.00  0.00           N  
ATOM   1283  CA  ALA A  81      -6.849  -2.986   8.487  1.00  0.00           C  
ATOM   1284  C   ALA A  81      -6.664  -3.431   9.933  1.00  0.00           C  
ATOM   1285  O   ALA A  81      -5.848  -4.304  10.223  1.00  0.00           O  
ATOM   1286  CB  ALA A  81      -7.162  -4.182   7.600  1.00  0.00           C  
ATOM   1287  H   ALA A  81      -5.313  -2.512   7.109  1.00  0.00           H  
ATOM   1288  HA  ALA A  81      -7.685  -2.303   8.434  1.00  0.00           H  
ATOM   1289  HB1 ALA A  81      -6.419  -4.254   6.818  1.00  0.00           H  
ATOM   1290  HB2 ALA A  81      -7.147  -5.083   8.195  1.00  0.00           H  
ATOM   1291  HB3 ALA A  81      -8.139  -4.058   7.158  1.00  0.00           H  
ATOM   1292  N   GLN A  82      -7.426  -2.823  10.835  1.00  0.00           N  
ATOM   1293  CA  GLN A  82      -7.344  -3.156  12.253  1.00  0.00           C  
ATOM   1294  C   GLN A  82      -7.835  -4.578  12.508  1.00  0.00           C  
ATOM   1295  O   GLN A  82      -9.029  -4.861  12.410  1.00  0.00           O  
ATOM   1296  CB  GLN A  82      -8.166  -2.165  13.080  1.00  0.00           C  
ATOM   1297  CG  GLN A  82      -7.452  -1.679  14.331  1.00  0.00           C  
ATOM   1298  CD  GLN A  82      -8.324  -1.757  15.569  1.00  0.00           C  
ATOM   1299  OE1 GLN A  82      -9.438  -1.233  15.592  1.00  0.00           O  
ATOM   1300  NE2 GLN A  82      -7.820  -2.415  16.606  1.00  0.00           N  
ATOM   1301  H   GLN A  82      -8.058  -2.134  10.544  1.00  0.00           H  
ATOM   1302  HA  GLN A  82      -6.309  -3.086  12.550  1.00  0.00           H  
ATOM   1303  HB2 GLN A  82      -8.398  -1.308  12.467  1.00  0.00           H  
ATOM   1304  HB3 GLN A  82      -9.087  -2.643  13.381  1.00  0.00           H  
ATOM   1305  HG2 GLN A  82      -6.574  -2.286  14.490  1.00  0.00           H  
ATOM   1306  HG3 GLN A  82      -7.155  -0.650  14.182  1.00  0.00           H  
ATOM   1307 HE21 GLN A  82      -6.926  -2.806  16.516  1.00  0.00           H  
ATOM   1308 HE22 GLN A  82      -8.362  -2.481  17.420  1.00  0.00           H  
ATOM   1309  N   THR A  83      -6.903  -5.469  12.834  1.00  0.00           N  
ATOM   1310  CA  THR A  83      -7.239  -6.863  13.100  1.00  0.00           C  
ATOM   1311  C   THR A  83      -8.139  -7.429  12.007  1.00  0.00           C  
ATOM   1312  O   THR A  83      -8.380  -6.781  10.989  1.00  0.00           O  
ATOM   1313  CB  THR A  83      -7.941  -7.020  14.462  1.00  0.00           C  
ATOM   1314  OG1 THR A  83      -9.198  -6.334  14.448  1.00  0.00           O  
ATOM   1315  CG2 THR A  83      -7.072  -6.475  15.585  1.00  0.00           C  
ATOM   1316  H   THR A  83      -5.968  -5.183  12.896  1.00  0.00           H  
ATOM   1317  HA  THR A  83      -6.319  -7.429  13.125  1.00  0.00           H  
ATOM   1318  HB  THR A  83      -8.117  -8.071  14.640  1.00  0.00           H  
ATOM   1319  HG1 THR A  83      -9.583  -6.387  13.569  1.00  0.00           H  
ATOM   1320 HG21 THR A  83      -7.655  -6.412  16.493  1.00  0.00           H  
ATOM   1321 HG22 THR A  83      -6.714  -5.492  15.319  1.00  0.00           H  
ATOM   1322 HG23 THR A  83      -6.233  -7.134  15.742  1.00  0.00           H  
ATOM   1323  N   LEU A  84      -8.635  -8.642  12.228  1.00  0.00           N  
ATOM   1324  CA  LEU A  84      -9.511  -9.297  11.261  1.00  0.00           C  
ATOM   1325  C   LEU A  84     -10.974  -9.155  11.670  1.00  0.00           C  
ATOM   1326  O   LEU A  84     -11.779  -8.575  10.942  1.00  0.00           O  
ATOM   1327  CB  LEU A  84      -9.145 -10.776  11.134  1.00  0.00           C  
ATOM   1328  CG  LEU A  84      -7.768 -11.079  10.543  1.00  0.00           C  
ATOM   1329  CD1 LEU A  84      -7.256 -12.421  11.042  1.00  0.00           C  
ATOM   1330  CD2 LEU A  84      -7.824 -11.060   9.022  1.00  0.00           C  
ATOM   1331  H   LEU A  84      -8.407  -9.109  13.058  1.00  0.00           H  
ATOM   1332  HA  LEU A  84      -9.369  -8.815  10.305  1.00  0.00           H  
ATOM   1333  HB2 LEU A  84      -9.186 -11.214  12.120  1.00  0.00           H  
ATOM   1334  HB3 LEU A  84      -9.887 -11.246  10.504  1.00  0.00           H  
ATOM   1335  HG  LEU A  84      -7.071 -10.316  10.862  1.00  0.00           H  
ATOM   1336 HD11 LEU A  84      -6.945 -13.024  10.201  1.00  0.00           H  
ATOM   1337 HD12 LEU A  84      -8.044 -12.929  11.579  1.00  0.00           H  
ATOM   1338 HD13 LEU A  84      -6.415 -12.262  11.702  1.00  0.00           H  
ATOM   1339 HD21 LEU A  84      -6.823 -10.966   8.626  1.00  0.00           H  
ATOM   1340 HD22 LEU A  84      -8.420 -10.220   8.694  1.00  0.00           H  
ATOM   1341 HD23 LEU A  84      -8.267 -11.977   8.666  1.00  0.00           H  
ATOM   1342  N   HIS A  85     -11.311  -9.692  12.838  1.00  0.00           N  
ATOM   1343  CA  HIS A  85     -12.677  -9.623  13.344  1.00  0.00           C  
ATOM   1344  C   HIS A  85     -12.686  -9.376  14.851  1.00  0.00           C  
ATOM   1345  O   HIS A  85     -11.661  -9.514  15.518  1.00  0.00           O  
ATOM   1346  CB  HIS A  85     -13.427 -10.916  13.024  1.00  0.00           C  
ATOM   1347  CG  HIS A  85     -12.727 -12.150  13.502  1.00  0.00           C  
ATOM   1348  ND1 HIS A  85     -12.638 -13.303  12.753  1.00  0.00           N  
ATOM   1349  CD2 HIS A  85     -12.077 -12.405  14.663  1.00  0.00           C  
ATOM   1350  CE1 HIS A  85     -11.966 -14.216  13.431  1.00  0.00           C  
ATOM   1351  NE2 HIS A  85     -11.614 -13.697  14.594  1.00  0.00           N  
ATOM   1352  H   HIS A  85     -10.625 -10.142  13.373  1.00  0.00           H  
ATOM   1353  HA  HIS A  85     -13.172  -8.798  12.854  1.00  0.00           H  
ATOM   1354  HB2 HIS A  85     -14.401 -10.884  13.493  1.00  0.00           H  
ATOM   1355  HB3 HIS A  85     -13.551 -10.997  11.954  1.00  0.00           H  
ATOM   1356  HD1 HIS A  85     -13.014 -13.434  11.857  1.00  0.00           H  
ATOM   1357  HD2 HIS A  85     -11.948 -11.722  15.490  1.00  0.00           H  
ATOM   1358  HE1 HIS A  85     -11.742 -15.217  13.094  1.00  0.00           H  
ATOM   1359  N   ILE A  86     -13.849  -9.008  15.378  1.00  0.00           N  
ATOM   1360  CA  ILE A  86     -13.991  -8.743  16.804  1.00  0.00           C  
ATOM   1361  C   ILE A  86     -13.299  -9.817  17.635  1.00  0.00           C  
ATOM   1362  O   ILE A  86     -13.436 -11.010  17.366  1.00  0.00           O  
ATOM   1363  CB  ILE A  86     -15.472  -8.665  17.219  1.00  0.00           C  
ATOM   1364  CG1 ILE A  86     -15.593  -8.275  18.693  1.00  0.00           C  
ATOM   1365  CG2 ILE A  86     -16.166  -9.993  16.958  1.00  0.00           C  
ATOM   1366  CD1 ILE A  86     -15.665  -6.780  18.920  1.00  0.00           C  
ATOM   1367  H   ILE A  86     -14.631  -8.915  14.795  1.00  0.00           H  
ATOM   1368  HA  ILE A  86     -13.528  -7.788  17.012  1.00  0.00           H  
ATOM   1369  HB  ILE A  86     -15.953  -7.909  16.613  1.00  0.00           H  
ATOM   1370 HG12 ILE A  86     -16.487  -8.716  19.103  1.00  0.00           H  
ATOM   1371 HG13 ILE A  86     -14.733  -8.652  19.227  1.00  0.00           H  
ATOM   1372 HG21 ILE A  86     -17.237  -9.853  16.992  1.00  0.00           H  
ATOM   1373 HG22 ILE A  86     -15.884 -10.360  15.982  1.00  0.00           H  
ATOM   1374 HG23 ILE A  86     -15.871 -10.707  17.711  1.00  0.00           H  
ATOM   1375 HD11 ILE A  86     -15.872  -6.284  17.982  1.00  0.00           H  
ATOM   1376 HD12 ILE A  86     -16.451  -6.561  19.626  1.00  0.00           H  
ATOM   1377 HD13 ILE A  86     -14.720  -6.430  19.310  1.00  0.00           H  
ATOM   1378  N   GLY A  87     -12.555  -9.386  18.650  1.00  0.00           N  
ATOM   1379  CA  GLY A  87     -11.853 -10.324  19.507  1.00  0.00           C  
ATOM   1380  C   GLY A  87     -12.443 -10.389  20.902  1.00  0.00           C  
ATOM   1381  O   GLY A  87     -13.613 -10.732  21.073  1.00  0.00           O  
ATOM   1382  H   GLY A  87     -12.482  -8.424  18.818  1.00  0.00           H  
ATOM   1383  HA2 GLY A  87     -11.902 -11.307  19.061  1.00  0.00           H  
ATOM   1384  HA3 GLY A  87     -10.818 -10.022  19.580  1.00  0.00           H  
ATOM   1385  N   SER A  88     -11.632 -10.059  21.901  1.00  0.00           N  
ATOM   1386  CA  SER A  88     -12.078 -10.086  23.289  1.00  0.00           C  
ATOM   1387  C   SER A  88     -12.413 -11.509  23.725  1.00  0.00           C  
ATOM   1388  O   SER A  88     -12.987 -12.284  22.961  1.00  0.00           O  
ATOM   1389  CB  SER A  88     -13.300  -9.184  23.471  1.00  0.00           C  
ATOM   1390  OG  SER A  88     -13.593  -8.993  24.845  1.00  0.00           O  
ATOM   1391  H   SER A  88     -10.709  -9.793  21.700  1.00  0.00           H  
ATOM   1392  HA  SER A  88     -11.272  -9.714  23.903  1.00  0.00           H  
ATOM   1393  HB2 SER A  88     -13.106  -8.223  23.019  1.00  0.00           H  
ATOM   1394  HB3 SER A  88     -14.155  -9.640  22.993  1.00  0.00           H  
ATOM   1395  HG  SER A  88     -12.774  -8.914  25.339  1.00  0.00           H  
ATOM   1396  N   SER A  89     -12.049 -11.845  24.958  1.00  0.00           N  
ATOM   1397  CA  SER A  89     -12.307 -13.175  25.495  1.00  0.00           C  
ATOM   1398  C   SER A  89     -13.795 -13.372  25.768  1.00  0.00           C  
ATOM   1399  O   SER A  89     -14.433 -12.546  26.423  1.00  0.00           O  
ATOM   1400  CB  SER A  89     -11.507 -13.393  26.782  1.00  0.00           C  
ATOM   1401  OG  SER A  89     -10.168 -13.755  26.495  1.00  0.00           O  
ATOM   1402  H   SER A  89     -11.595 -11.182  25.519  1.00  0.00           H  
ATOM   1403  HA  SER A  89     -11.989 -13.898  24.759  1.00  0.00           H  
ATOM   1404  HB2 SER A  89     -11.504 -12.481  27.359  1.00  0.00           H  
ATOM   1405  HB3 SER A  89     -11.967 -14.182  27.358  1.00  0.00           H  
ATOM   1406  HG  SER A  89      -9.839 -14.334  27.187  1.00  0.00           H  
ATOM   1407  N   HIS A  90     -14.342 -14.473  25.262  1.00  0.00           N  
ATOM   1408  CA  HIS A  90     -15.756 -14.781  25.452  1.00  0.00           C  
ATOM   1409  C   HIS A  90     -15.937 -16.205  25.965  1.00  0.00           C  
ATOM   1410  O   HIS A  90     -14.963 -16.905  26.246  1.00  0.00           O  
ATOM   1411  CB  HIS A  90     -16.519 -14.598  24.138  1.00  0.00           C  
ATOM   1412  CG  HIS A  90     -16.977 -13.191  23.903  1.00  0.00           C  
ATOM   1413  ND1 HIS A  90     -18.305 -12.821  23.901  1.00  0.00           N  
ATOM   1414  CD2 HIS A  90     -16.273 -12.060  23.662  1.00  0.00           C  
ATOM   1415  CE1 HIS A  90     -18.400 -11.526  23.667  1.00  0.00           C  
ATOM   1416  NE2 HIS A  90     -17.180 -11.039  23.519  1.00  0.00           N  
ATOM   1417  H   HIS A  90     -13.782 -15.093  24.750  1.00  0.00           H  
ATOM   1418  HA  HIS A  90     -16.150 -14.093  26.184  1.00  0.00           H  
ATOM   1419  HB2 HIS A  90     -15.879 -14.881  23.316  1.00  0.00           H  
ATOM   1420  HB3 HIS A  90     -17.391 -15.236  24.146  1.00  0.00           H  
ATOM   1421  HD1 HIS A  90     -19.065 -13.423  24.047  1.00  0.00           H  
ATOM   1422  HD2 HIS A  90     -15.197 -11.975  23.594  1.00  0.00           H  
ATOM   1423  HE1 HIS A  90     -19.316 -10.959  23.608  1.00  0.00           H  
ATOM   1424  N   LEU A  91     -17.191 -16.630  26.085  1.00  0.00           N  
ATOM   1425  CA  LEU A  91     -17.502 -17.971  26.567  1.00  0.00           C  
ATOM   1426  C   LEU A  91     -16.587 -19.007  25.919  1.00  0.00           C  
ATOM   1427  O   LEU A  91     -16.657 -19.243  24.713  1.00  0.00           O  
ATOM   1428  CB  LEU A  91     -18.963 -18.313  26.278  1.00  0.00           C  
ATOM   1429  CG  LEU A  91     -19.585 -19.403  27.152  1.00  0.00           C  
ATOM   1430  CD1 LEU A  91     -20.287 -18.787  28.352  1.00  0.00           C  
ATOM   1431  CD2 LEU A  91     -20.554 -20.250  26.341  1.00  0.00           C  
ATOM   1432  H   LEU A  91     -17.925 -16.028  25.846  1.00  0.00           H  
ATOM   1433  HA  LEU A  91     -17.341 -17.986  27.635  1.00  0.00           H  
ATOM   1434  HB2 LEU A  91     -19.546 -17.414  26.407  1.00  0.00           H  
ATOM   1435  HB3 LEU A  91     -19.029 -18.637  25.247  1.00  0.00           H  
ATOM   1436  HG  LEU A  91     -18.800 -20.051  27.521  1.00  0.00           H  
ATOM   1437 HD11 LEU A  91     -20.383 -19.528  29.132  1.00  0.00           H  
ATOM   1438 HD12 LEU A  91     -21.268 -18.445  28.058  1.00  0.00           H  
ATOM   1439 HD13 LEU A  91     -19.709 -17.952  28.718  1.00  0.00           H  
ATOM   1440 HD21 LEU A  91     -20.270 -20.223  25.299  1.00  0.00           H  
ATOM   1441 HD22 LEU A  91     -21.554 -19.858  26.451  1.00  0.00           H  
ATOM   1442 HD23 LEU A  91     -20.525 -21.270  26.697  1.00  0.00           H  
ATOM   1443  N   ALA A  92     -15.732 -19.624  26.729  1.00  0.00           N  
ATOM   1444  CA  ALA A  92     -14.808 -20.637  26.236  1.00  0.00           C  
ATOM   1445  C   ALA A  92     -15.539 -21.694  25.414  1.00  0.00           C  
ATOM   1446  O   ALA A  92     -16.675 -22.067  25.708  1.00  0.00           O  
ATOM   1447  CB  ALA A  92     -14.069 -21.286  27.396  1.00  0.00           C  
ATOM   1448  H   ALA A  92     -15.724 -19.392  27.681  1.00  0.00           H  
ATOM   1449  HA  ALA A  92     -14.079 -20.146  25.607  1.00  0.00           H  
ATOM   1450  HB1 ALA A  92     -13.029 -21.417  27.131  1.00  0.00           H  
ATOM   1451  HB2 ALA A  92     -14.142 -20.655  28.269  1.00  0.00           H  
ATOM   1452  HB3 ALA A  92     -14.510 -22.249  27.609  1.00  0.00           H  
ATOM   1453  N   PRO A  93     -14.875 -22.187  24.359  1.00  0.00           N  
ATOM   1454  CA  PRO A  93     -15.443 -23.208  23.472  1.00  0.00           C  
ATOM   1455  C   PRO A  93     -15.565 -24.566  24.155  1.00  0.00           C  
ATOM   1456  O   PRO A  93     -14.908 -24.844  25.159  1.00  0.00           O  
ATOM   1457  CB  PRO A  93     -14.436 -23.278  22.321  1.00  0.00           C  
ATOM   1458  CG  PRO A  93     -13.150 -22.814  22.914  1.00  0.00           C  
ATOM   1459  CD  PRO A  93     -13.517 -21.789  23.950  1.00  0.00           C  
ATOM   1460  HA  PRO A  93     -16.407 -22.909  23.091  1.00  0.00           H  
ATOM   1461  HB2 PRO A  93     -14.364 -24.295  21.964  1.00  0.00           H  
ATOM   1462  HB3 PRO A  93     -14.756 -22.630  21.518  1.00  0.00           H  
ATOM   1463  HG2 PRO A  93     -12.637 -23.646  23.372  1.00  0.00           H  
ATOM   1464  HG3 PRO A  93     -12.533 -22.369  22.147  1.00  0.00           H  
ATOM   1465  HD2 PRO A  93     -12.833 -21.835  24.785  1.00  0.00           H  
ATOM   1466  HD3 PRO A  93     -13.520 -20.800  23.517  1.00  0.00           H  
ATOM   1467  N   PRO A  94     -16.425 -25.433  23.601  1.00  0.00           N  
ATOM   1468  CA  PRO A  94     -16.652 -26.776  24.140  1.00  0.00           C  
ATOM   1469  C   PRO A  94     -15.450 -27.693  23.941  1.00  0.00           C  
ATOM   1470  O   PRO A  94     -14.568 -27.407  23.133  1.00  0.00           O  
ATOM   1471  CB  PRO A  94     -17.851 -27.284  23.334  1.00  0.00           C  
ATOM   1472  CG  PRO A  94     -17.797 -26.520  22.055  1.00  0.00           C  
ATOM   1473  CD  PRO A  94     -17.241 -25.168  22.404  1.00  0.00           C  
ATOM   1474  HA  PRO A  94     -16.911 -26.744  25.188  1.00  0.00           H  
ATOM   1475  HB2 PRO A  94     -17.749 -28.347  23.164  1.00  0.00           H  
ATOM   1476  HB3 PRO A  94     -18.763 -27.085  23.874  1.00  0.00           H  
ATOM   1477  HG2 PRO A  94     -17.149 -27.023  21.353  1.00  0.00           H  
ATOM   1478  HG3 PRO A  94     -18.792 -26.422  21.645  1.00  0.00           H  
ATOM   1479  HD2 PRO A  94     -16.631 -24.791  21.597  1.00  0.00           H  
ATOM   1480  HD3 PRO A  94     -18.041 -24.477  22.628  1.00  0.00           H  
ATOM   1481  N   ASN A  95     -15.421 -28.794  24.685  1.00  0.00           N  
ATOM   1482  CA  ASN A  95     -14.327 -29.751  24.590  1.00  0.00           C  
ATOM   1483  C   ASN A  95     -13.828 -29.867  23.153  1.00  0.00           C  
ATOM   1484  O   ASN A  95     -14.598 -29.800  22.194  1.00  0.00           O  
ATOM   1485  CB  ASN A  95     -14.776 -31.123  25.098  1.00  0.00           C  
ATOM   1486  CG  ASN A  95     -15.915 -31.699  24.279  1.00  0.00           C  
ATOM   1487  OD1 ASN A  95     -17.034 -31.187  24.306  1.00  0.00           O  
ATOM   1488  ND2 ASN A  95     -15.634 -32.769  23.545  1.00  0.00           N  
ATOM   1489  H   ASN A  95     -16.154 -28.966  25.312  1.00  0.00           H  
ATOM   1490  HA  ASN A  95     -13.519 -29.395  25.210  1.00  0.00           H  
ATOM   1491  HB2 ASN A  95     -13.942 -31.809  25.050  1.00  0.00           H  
ATOM   1492  HB3 ASN A  95     -15.103 -31.033  26.123  1.00  0.00           H  
ATOM   1493 HD21 ASN A  95     -14.721 -33.123  23.572  1.00  0.00           H  
ATOM   1494 HD22 ASN A  95     -16.352 -33.161  23.006  1.00  0.00           H  
ATOM   1495  N   PRO A  96     -12.509 -30.047  22.997  1.00  0.00           N  
ATOM   1496  CA  PRO A  96     -11.877 -30.177  21.680  1.00  0.00           C  
ATOM   1497  C   PRO A  96     -12.235 -31.491  20.993  1.00  0.00           C  
ATOM   1498  O   PRO A  96     -13.092 -32.236  21.467  1.00  0.00           O  
ATOM   1499  CB  PRO A  96     -10.380 -30.132  21.998  1.00  0.00           C  
ATOM   1500  CG  PRO A  96     -10.277 -30.607  23.406  1.00  0.00           C  
ATOM   1501  CD  PRO A  96     -11.531 -30.137  24.094  1.00  0.00           C  
ATOM   1502  HA  PRO A  96     -12.134 -29.351  21.033  1.00  0.00           H  
ATOM   1503  HB2 PRO A  96      -9.845 -30.783  21.321  1.00  0.00           H  
ATOM   1504  HB3 PRO A  96     -10.016 -29.120  21.896  1.00  0.00           H  
ATOM   1505  HG2 PRO A  96     -10.219 -31.685  23.427  1.00  0.00           H  
ATOM   1506  HG3 PRO A  96      -9.408 -30.173  23.878  1.00  0.00           H  
ATOM   1507  HD2 PRO A  96     -11.847 -30.857  24.834  1.00  0.00           H  
ATOM   1508  HD3 PRO A  96     -11.372 -29.170  24.549  1.00  0.00           H  
ATOM   1509  N   ASP A  97     -11.574 -31.767  19.874  1.00  0.00           N  
ATOM   1510  CA  ASP A  97     -11.823 -32.991  19.122  1.00  0.00           C  
ATOM   1511  C   ASP A  97     -10.525 -33.545  18.541  1.00  0.00           C  
ATOM   1512  O   ASP A  97      -9.551 -32.813  18.362  1.00  0.00           O  
ATOM   1513  CB  ASP A  97     -12.829 -32.730  18.000  1.00  0.00           C  
ATOM   1514  CG  ASP A  97     -12.312 -31.733  16.980  1.00  0.00           C  
ATOM   1515  OD1 ASP A  97     -11.376 -30.978  17.311  1.00  0.00           O  
ATOM   1516  OD2 ASP A  97     -12.847 -31.708  15.852  1.00  0.00           O  
ATOM   1517  H   ASP A  97     -10.902 -31.132  19.546  1.00  0.00           H  
ATOM   1518  HA  ASP A  97     -12.237 -33.720  19.802  1.00  0.00           H  
ATOM   1519  HB2 ASP A  97     -13.039 -33.660  17.490  1.00  0.00           H  
ATOM   1520  HB3 ASP A  97     -13.741 -32.342  18.427  1.00  0.00           H  
ATOM   1521  N   LYS A  98     -10.518 -34.840  18.250  1.00  0.00           N  
ATOM   1522  CA  LYS A  98      -9.342 -35.495  17.689  1.00  0.00           C  
ATOM   1523  C   LYS A  98      -8.766 -34.679  16.535  1.00  0.00           C  
ATOM   1524  O   LYS A  98      -9.506 -34.130  15.719  1.00  0.00           O  
ATOM   1525  CB  LYS A  98      -9.696 -36.902  17.204  1.00  0.00           C  
ATOM   1526  CG  LYS A  98      -8.798 -37.985  17.775  1.00  0.00           C  
ATOM   1527  CD  LYS A  98      -7.552 -38.180  16.926  1.00  0.00           C  
ATOM   1528  CE  LYS A  98      -7.392 -39.629  16.496  1.00  0.00           C  
ATOM   1529  NZ  LYS A  98      -6.860 -39.742  15.108  1.00  0.00           N  
ATOM   1530  H   LYS A  98     -11.327 -35.372  18.416  1.00  0.00           H  
ATOM   1531  HA  LYS A  98      -8.600 -35.566  18.469  1.00  0.00           H  
ATOM   1532  HB2 LYS A  98     -10.714 -37.122  17.491  1.00  0.00           H  
ATOM   1533  HB3 LYS A  98      -9.619 -36.930  16.128  1.00  0.00           H  
ATOM   1534  HG2 LYS A  98      -8.498 -37.704  18.773  1.00  0.00           H  
ATOM   1535  HG3 LYS A  98      -9.347 -38.915  17.811  1.00  0.00           H  
ATOM   1536  HD2 LYS A  98      -7.628 -37.562  16.043  1.00  0.00           H  
ATOM   1537  HD3 LYS A  98      -6.685 -37.886  17.499  1.00  0.00           H  
ATOM   1538  HE2 LYS A  98      -6.711 -40.120  17.173  1.00  0.00           H  
ATOM   1539  HE3 LYS A  98      -8.357 -40.114  16.542  1.00  0.00           H  
ATOM   1540  HZ1 LYS A  98      -7.197 -40.621  14.667  1.00  0.00           H  
ATOM   1541  HZ2 LYS A  98      -5.821 -39.752  15.125  1.00  0.00           H  
ATOM   1542  HZ3 LYS A  98      -7.180 -38.934  14.536  1.00  0.00           H  
ATOM   1543  N   SER A  99      -7.440 -34.605  16.473  1.00  0.00           N  
ATOM   1544  CA  SER A  99      -6.763 -33.855  15.420  1.00  0.00           C  
ATOM   1545  C   SER A  99      -5.264 -34.130  15.436  1.00  0.00           C  
ATOM   1546  O   SER A  99      -4.715 -34.590  16.436  1.00  0.00           O  
ATOM   1547  CB  SER A  99      -7.022 -32.357  15.586  1.00  0.00           C  
ATOM   1548  OG  SER A  99      -6.588 -31.903  16.858  1.00  0.00           O  
ATOM   1549  H   SER A  99      -6.903 -35.065  17.153  1.00  0.00           H  
ATOM   1550  HA  SER A  99      -7.167 -34.178  14.473  1.00  0.00           H  
ATOM   1551  HB2 SER A  99      -6.487 -31.815  14.822  1.00  0.00           H  
ATOM   1552  HB3 SER A  99      -8.081 -32.164  15.491  1.00  0.00           H  
ATOM   1553  HG  SER A  99      -7.348 -31.617  17.371  1.00  0.00           H  
ATOM   1554  N   GLY A 100      -4.604 -33.843  14.317  1.00  0.00           N  
ATOM   1555  CA  GLY A 100      -3.174 -34.064  14.222  1.00  0.00           C  
ATOM   1556  C   GLY A 100      -2.448 -32.903  13.571  1.00  0.00           C  
ATOM   1557  O   GLY A 100      -2.273 -32.858  12.353  1.00  0.00           O  
ATOM   1558  H   GLY A 100      -5.094 -33.478  13.550  1.00  0.00           H  
ATOM   1559  HA2 GLY A 100      -2.776 -34.213  15.215  1.00  0.00           H  
ATOM   1560  HA3 GLY A 100      -2.996 -34.956  13.637  1.00  0.00           H  
ATOM   1561  N   PRO A 101      -2.016 -31.936  14.393  1.00  0.00           N  
ATOM   1562  CA  PRO A 101      -1.301 -30.750  13.912  1.00  0.00           C  
ATOM   1563  C   PRO A 101       0.099 -31.083  13.408  1.00  0.00           C  
ATOM   1564  O   PRO A 101       0.790 -31.927  13.977  1.00  0.00           O  
ATOM   1565  CB  PRO A 101      -1.223 -29.856  15.152  1.00  0.00           C  
ATOM   1566  CG  PRO A 101      -1.304 -30.796  16.304  1.00  0.00           C  
ATOM   1567  CD  PRO A 101      -2.191 -31.925  15.856  1.00  0.00           C  
ATOM   1568  HA  PRO A 101      -1.851 -30.243  13.133  1.00  0.00           H  
ATOM   1569  HB2 PRO A 101      -0.289 -29.312  15.149  1.00  0.00           H  
ATOM   1570  HB3 PRO A 101      -2.049 -29.161  15.150  1.00  0.00           H  
ATOM   1571  HG2 PRO A 101      -0.320 -31.166  16.546  1.00  0.00           H  
ATOM   1572  HG3 PRO A 101      -1.738 -30.295  17.157  1.00  0.00           H  
ATOM   1573  HD2 PRO A 101      -1.863 -32.858  16.290  1.00  0.00           H  
ATOM   1574  HD3 PRO A 101      -3.219 -31.723  16.118  1.00  0.00           H  
ATOM   1575  N   SER A 102       0.511 -30.413  12.335  1.00  0.00           N  
ATOM   1576  CA  SER A 102       1.828 -30.640  11.751  1.00  0.00           C  
ATOM   1577  C   SER A 102       2.838 -29.623  12.275  1.00  0.00           C  
ATOM   1578  O   SER A 102       2.507 -28.774  13.102  1.00  0.00           O  
ATOM   1579  CB  SER A 102       1.754 -30.564  10.225  1.00  0.00           C  
ATOM   1580  OG  SER A 102       1.498 -31.839   9.663  1.00  0.00           O  
ATOM   1581  H   SER A 102      -0.085 -29.752  11.926  1.00  0.00           H  
ATOM   1582  HA  SER A 102       2.151 -31.631  12.038  1.00  0.00           H  
ATOM   1583  HB2 SER A 102       0.959 -29.892   9.940  1.00  0.00           H  
ATOM   1584  HB3 SER A 102       2.693 -30.195   9.840  1.00  0.00           H  
ATOM   1585  HG  SER A 102       2.174 -32.457   9.948  1.00  0.00           H  
ATOM   1586  N   SER A 103       4.070 -29.715  11.786  1.00  0.00           N  
ATOM   1587  CA  SER A 103       5.129 -28.806  12.205  1.00  0.00           C  
ATOM   1588  C   SER A 103       5.034 -27.478  11.457  1.00  0.00           C  
ATOM   1589  O   SER A 103       4.316 -27.361  10.465  1.00  0.00           O  
ATOM   1590  CB  SER A 103       6.501 -29.441  11.966  1.00  0.00           C  
ATOM   1591  OG  SER A 103       6.830 -29.441  10.588  1.00  0.00           O  
ATOM   1592  H   SER A 103       4.271 -30.413  11.127  1.00  0.00           H  
ATOM   1593  HA  SER A 103       5.007 -28.620  13.261  1.00  0.00           H  
ATOM   1594  HB2 SER A 103       7.251 -28.883  12.503  1.00  0.00           H  
ATOM   1595  HB3 SER A 103       6.487 -30.461  12.321  1.00  0.00           H  
ATOM   1596  HG  SER A 103       7.722 -29.107  10.471  1.00  0.00           H  
ATOM   1597  N   GLY A 104       5.766 -26.480  11.942  1.00  0.00           N  
ATOM   1598  CA  GLY A 104       5.751 -25.175  11.309  1.00  0.00           C  
ATOM   1599  C   GLY A 104       7.066 -24.438  11.466  1.00  0.00           C  
ATOM   1600  O   GLY A 104       7.202 -23.575  12.334  1.00  0.00           O  
ATOM   1601  H   GLY A 104       6.321 -26.632  12.735  1.00  0.00           H  
ATOM   1602  HA2 GLY A 104       5.543 -25.299  10.256  1.00  0.00           H  
ATOM   1603  HA3 GLY A 104       4.964 -24.582  11.752  1.00  0.00           H  
TER    1604      GLY A 104                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
