
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   89 (  703),  selected   89 , name 1o51_A
# Molecule2: number of CA atoms   76 ( 1151),  selected   76 , name T0437.pdb
# PARAMETERS: 1o51_A.T0437.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -1_A      -       -           -
LGA    H     0_A      -       -           -
LGA    X     1_A      D      24           #
LGA    K     2_A      N      25          2.356
LGA    -       -      C      26           -
LGA    L     3_A      T      27          1.996
LGA    L     4_A      S      28          0.688
LGA    K     5_A      K      29          0.617
LGA    I     6_A      F      30          0.748
LGA    Y     7_A      S      31          0.615
LGA    L     8_A      R      32          0.890
LGA    G     9_A      F      33          2.475
LGA    E    10_A      F      34          3.947
LGA    -       -      A      35           -
LGA    -       -      T      36           -
LGA    -       -      R      37           -
LGA    -       -      E      38           -
LGA    K    11_A      E      39          2.804
LGA    D    12_A      A      40          6.265
LGA    K    13_A      -       -           -
LGA    H    14_A      -       -           -
LGA    S    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    K    17_A      -       -           -
LGA    P    18_A      E      41          5.716
LGA    -       -      S      42           -
LGA    L    19_A      F      43          1.851
LGA    F    20_A      M      44          2.209
LGA    E    21_A      T      45          1.709
LGA    Y    22_A      K      46          0.789
LGA    L    23_A      L      47          0.757
LGA    V    24_A      K      48          2.187
LGA    K    25_A      E      49          2.481
LGA    R    26_A      L      50          1.410
LGA    A    27_A      A      51          0.694
LGA    Y    28_A      A      52          2.601
LGA    E    29_A      A      53          3.532
LGA    L    30_A      A      54          2.776
LGA    G    31_A      S      55          2.139
LGA    -       -      S      56           -
LGA    -       -      A      57           -
LGA    -       -      D      58           -
LGA    -       -      E      59           -
LGA    X    32_A      G      60          3.970
LGA    K    33_A      A      61          2.316
LGA    G    34_A      S      62          1.402
LGA    V    35_A      V      63          0.995
LGA    T    36_A      A      64          1.353
LGA    V    37_A      Y      65          1.312
LGA    Y    38_A      K      66          1.599
LGA    R    39_A      I      67          0.544
LGA    G    40_A      K      68          1.036
LGA    I    41_A      D      69          3.004
LGA    X    42_A      L      70          3.021
LGA    G    43_A      E      71           -
LGA    F    44_A      -       -           -
LGA    G    45_A      -       -           -
LGA    H    46_A      -       -           -
LGA    P    60_A      G      72          3.892
LGA    D    61_A      Q      73          2.499
LGA    L    62_A      V      74          0.928
LGA    P    63_A      E      75          0.738
LGA    I    64_A      L      76          0.960
LGA    V    65_A      D      77          0.937
LGA    L    66_A      A      78          0.225
LGA    E    67_A      A      79          0.234
LGA    I    68_A      F      80          1.055
LGA    V    69_A      T      81          1.590
LGA    D    70_A      F      82          1.588
LGA    E    71_A      S      83          3.451
LGA    -       -      C      84           -
LGA    E    72_A      Q      85          0.595
LGA    E    73_A      A      86          0.777
LGA    R    74_A      E      87          0.866
LGA    I    75_A      M      88          0.300
LGA    N    76_A      I      89          1.210
LGA    L    77_A      I      90          1.585
LGA    F    78_A      F      91          0.530
LGA    L    79_A      E      92          1.250
LGA    K    80_A      L      93          1.600
LGA    E    81_A      S      94          0.578
LGA    I    82_A      L      95          0.458
LGA    D    83_A      R      96          1.137
LGA    N    84_A      S      97          1.194
LGA    I    85_A      L      98          3.306
LGA    D    86_A      A      99          4.426
LGA    F    87_A      -       -           -
LGA    D    88_A      -       -           -
LGA    G    89_A      -       -           -
LGA    L    90_A      -       -           -
LGA    V    91_A      -       -           -
LGA    F    92_A      -       -           -
LGA    T    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    D    95_A      -       -           -
LGA    V    96_A      -       -           -
LGA    N    97_A      -       -           -
LGA    V    98_A      -       -           -
LGA    V    99_A      -       -           -
LGA    K   100_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   89   76    5.0     63    2.21     7.94     66.246     2.729

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.559802 * X  +   0.329550 * Y  +   0.760275 * Z  + -40.889561
  Y_new =  -0.786625 * X  +  -0.077054 * Y  +   0.612604 * Z  +  34.947151
  Z_new =   0.260466 * X  +  -0.940988 * Y  +   0.216098 * Z  +  -3.353885 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.345061    1.796532  [ DEG:   -77.0663    102.9337 ]
  Theta =  -0.263505   -2.878088  [ DEG:   -15.0977   -164.9023 ]
  Phi   =  -0.952294    2.189299  [ DEG:   -54.5624    125.4376 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1o51_A                                        
REMARK     2: T0437.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1o51_A.T0437.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   89   76   5.0   63   2.21    7.94  66.246
REMARK  ---------------------------------------------------------- 
MOLECULE 1o51_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   01-AUG-03   1O51              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE PII-LIKE SIGNALING PROTEIN            
TITLE    2 (TM0021) FROM THERMOTOGA MARITIMA AT 2.50 A RESOLUTION               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TM0021;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TM0021;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    TM0021, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS, JCSG,              
KEYWDS   2 PSI, PROTEIN STRUCTURE INITIATIVE, JOINT CENTER FOR                  
KEYWDS   3 STRUCTURAL GENOMICS                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   5   24-OCT-06 1O51    1       KEYWDS REMARK                            
REVDAT   4   20-SEP-05 1O51    1       JRNL                                     
REVDAT   3   23-MAR-04 1O51    1       JRNL   SEQADV DBREF                      
REVDAT   2   26-AUG-03 1O51    1       REMARK MASTER                            
REVDAT   1   19-AUG-03 1O51    0                                                
JRNL        AUTH   R.SCHWARZENBACHER,F.VON DELFT,P.ABDUBEK,E.AMBING,            
JRNL        AUTH 2 T.BIORAC,L.S.BRINEN,J.M.CANAVES,J.CAMBELL,H.J.CHIU,          
JRNL        AUTH 3 X.DAI,A.M.DEACON,M.DIDONATO,M.A.ELSLIGER,S.ESHAGI,           
JRNL        AUTH 4 R.FLOYD,A.GODZIK,C.GRITTINI,S.K.GRZECHNIK,                   
JRNL        AUTH 5 E.HAMPTON,L.JAROSZEWSKI,C.KARLAK,H.E.KLOCK,                  
JRNL        AUTH 6 E.KOESEMA,J.S.KOVARIK,A.KREUSCH,P.KUHN,S.A.LESLEY,           
JRNL        AUTH 7 I.LEVIN,D.MCMULLAN,T.M.MCPHILLIPS,M.D.MILLER,                
JRNL        AUTH 8 A.MORSE,K.MOY,J.OUYANG,R.PAGE,K.QUIJANO,A.ROBB,              
JRNL        AUTH 9 G.SPRAGGON,R.C.STEVENS,H.VAN DEN BEDEM,J.VELASQUEZ,          
JRNL        AUTH10 J.VINCENT,X.WANG,B.WEST,G.WOLF,Q.XU,K.O.HODGSON,             
JRNL        AUTH11 J.WOOLEY,I.A.WILSON                                          
JRNL        TITL   CRYSTAL STRUCTURE OF A PUTATIVE PII-LIKE SIGNALING           
JRNL        TITL 2 PROTEIN (TM0021) FROM THERMOTOGA MARITIMA AT 2.5 A           
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    PROTEINS                      V.  54   810 2004              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1O51 A    1   102  UNP    Q9WXM9   Y021_THEMA       1    102             
SEQRES   1 A  114  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 A  114  LYS LEU LEU LYS ILE TYR LEU GLY GLU LYS ASP LYS HIS          
SEQRES   3 A  114  SER GLY LYS PRO LEU PHE GLU TYR LEU VAL LYS ARG ALA          
SEQRES   4 A  114  TYR GLU LEU GLY MSE LYS GLY VAL THR VAL TYR ARG GLY          
SEQRES   5 A  114  ILE MSE GLY PHE GLY HIS LYS ARG HIS MET HIS ARG SER          
SEQRES   6 A  114  ASP PHE PHE SER LEU SER PRO ASP LEU PRO ILE VAL LEU          
SEQRES   7 A  114  GLU ILE VAL ASP GLU GLU GLU ARG ILE ASN LEU PHE LEU          
SEQRES   8 A  114  LYS GLU ILE ASP ASN ILE ASP PHE ASP GLY LEU VAL PHE          
SEQRES   9 A  114  THR ALA ASP VAL ASN VAL VAL LYS MET GLY                      
HET    MSE  A   1       8                                                       
HET    MSE  A  32       5                                                       
HET    MSE  A  42       8                                                       
HET    SO4    301       5                                                       
HET    SO4    302       5                                                       
HET    ADP    200      27                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     ADP ADENOSINE-5'-DIPHOSPHATE                                         
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  SO4    2(O4 S 2-)                                                   
FORMUL   4  ADP    C10 H15 N5 O10 P2                                            
FORMUL   5  HOH   *39(H2 O)                                                     
CRYST1  100.110  100.110  100.110  90.00  90.00  90.00 P 43 3 2     24          
ATOM      1  N   HIS A  -1      -3.480 -17.482  13.470  1.00 43.90           N  
ATOM      2  CA  HIS A  -1      -2.501 -16.952  12.453  1.00 43.23           C  
ATOM      3  C   HIS A  -1      -2.725 -15.480  12.106  1.00 40.92           C  
ATOM      4  O   HIS A  -1      -3.601 -15.132  11.335  1.00 37.93           O  
ATOM      5  CB  HIS A  -1      -2.513 -17.834  11.215  1.00 43.91           C  
ATOM      6  CG  HIS A  -1      -2.125 -19.249  11.514  1.00 48.40           C  
ATOM      7  ND1 HIS A  -1      -1.139 -19.565  12.434  1.00 52.90           N  
ATOM      8  CD2 HIS A  -1      -2.594 -20.431  11.044  1.00 50.03           C  
ATOM      9  CE1 HIS A  -1      -1.013 -20.880  12.507  1.00 52.24           C  
ATOM     10  NE2 HIS A  -1      -1.885 -21.426  11.675  1.00 50.80           N  
ATOM     11  N   HIS A   0      -1.863 -14.646  12.695  1.00 40.42           N  
ATOM     12  CA  HIS A   0      -1.943 -13.190  12.602  1.00 40.59           C  
ATOM     13  C   HIS A   0      -1.726 -12.711  11.208  1.00 39.14           C  
ATOM     14  O   HIS A   0      -0.835 -13.192  10.535  1.00 40.12           O  
ATOM     15  CB  HIS A   0      -0.910 -12.477  13.480  1.00 40.36           C  
ATOM     16  CG  HIS A   0      -0.911 -10.986  13.287  1.00 45.97           C  
ATOM     17  ND1 HIS A   0       0.159 -10.294  12.734  1.00 52.41           N  
ATOM     18  CD2 HIS A   0      -1.887 -10.062  13.501  1.00 47.93           C  
ATOM     19  CE1 HIS A   0      -0.150  -9.005  12.667  1.00 53.16           C  
ATOM     20  NE2 HIS A   0      -1.387  -8.842  13.115  1.00 50.34           N  
HETATM   21  N   MSE A   1      -2.546 -11.760  10.785  1.00 37.46           N  
HETATM   22  CA  MSE A   1      -2.368 -11.080   9.533  1.00 36.86           C  
HETATM   23  C   MSE A   1      -2.786  -9.624   9.692  1.00 36.09           C  
HETATM   24  O   MSE A   1      -3.296  -9.222  10.734  1.00 36.84           O  
HETATM   25  CB  MSE A   1      -3.238 -11.729   8.444  1.00 37.14           C  
HETATM   26  CG  MSE A   1      -2.947 -13.195   8.194  1.00 37.89           C  
HETATM   27 SE   MSE A   1      -1.266 -13.586   7.244  0.50 33.73          SE  
HETATM   28  CE  MSE A   1      -0.964 -15.306   8.048  1.00 36.76           C  
ATOM     29  N   LYS A   2      -2.554  -8.845   8.642  1.00 35.12           N  
ATOM     30  CA  LYS A   2      -3.065  -7.511   8.534  1.00 34.55           C  
ATOM     31  C   LYS A   2      -4.091  -7.468   7.432  1.00 33.95           C  
ATOM     32  O   LYS A   2      -3.932  -8.093   6.370  1.00 32.86           O  
ATOM     33  CB  LYS A   2      -1.966  -6.511   8.163  1.00 34.43           C  
ATOM     34  CG  LYS A   2      -0.911  -6.325   9.180  1.00 36.07           C  
ATOM     35  CD  LYS A   2      -1.434  -5.643  10.404  1.00 37.82           C  
ATOM     36  CE  LYS A   2      -0.296  -5.050  11.220  1.00 38.08           C  
ATOM     37  NZ  LYS A   2      -0.799  -4.436  12.451  1.00 35.97           N  
ATOM     38  N   LEU A   3      -5.120  -6.685   7.709  1.00 33.94           N  
ATOM     39  CA  LEU A   3      -6.065  -6.235   6.730  1.00 33.88           C  
ATOM     40  C   LEU A   3      -5.609  -4.858   6.334  1.00 33.57           C  
ATOM     41  O   LEU A   3      -5.292  -4.039   7.183  1.00 34.75           O  
ATOM     42  CB  LEU A   3      -7.473  -6.166   7.347  1.00 33.91           C  
ATOM     43  CG  LEU A   3      -8.497  -5.386   6.540  1.00 33.64           C  
ATOM     44  CD1 LEU A   3      -8.844  -6.210   5.360  1.00 38.14           C  
ATOM     45  CD2 LEU A   3      -9.711  -5.147   7.282  1.00 36.47           C  
ATOM     46  N   LEU A   4      -5.505  -4.635   5.043  1.00 33.64           N  
ATOM     47  CA  LEU A   4      -5.232  -3.323   4.492  1.00 33.12           C  
ATOM     48  C   LEU A   4      -6.483  -2.913   3.735  1.00 33.43           C  
ATOM     49  O   LEU A   4      -7.017  -3.674   2.916  1.00 31.12           O  
ATOM     50  CB  LEU A   4      -4.078  -3.364   3.523  1.00 33.33           C  
ATOM     51  CG  LEU A   4      -3.868  -2.168   2.571  1.00 33.73           C  
ATOM     52  CD1 LEU A   4      -3.471  -1.001   3.411  1.00 36.58           C  
ATOM     53  CD2 LEU A   4      -2.747  -2.451   1.558  1.00 35.37           C  
ATOM     54  N   LYS A   5      -6.954  -1.703   4.026  1.00 34.20           N  
ATOM     55  CA  LYS A   5      -8.167  -1.211   3.414  1.00 35.05           C  
ATOM     56  C   LYS A   5      -7.826   0.116   2.745  1.00 34.63           C  
ATOM     57  O   LYS A   5      -7.219   1.002   3.346  1.00 33.76           O  
ATOM     58  CB  LYS A   5      -9.244  -1.084   4.481  1.00 35.62           C  
ATOM     59  CG  LYS A   5     -10.626  -1.181   3.924  1.00 40.53           C  
ATOM     60  CD  LYS A   5     -11.583  -1.767   4.873  1.00 42.69           C  
ATOM     61  CE  LYS A   5     -12.872  -2.015   4.196  1.00 45.42           C  
ATOM     62  NZ  LYS A   5     -13.911  -2.296   5.280  1.00 45.58           N  
ATOM     63  N   ILE A   6      -8.174   0.214   1.473  1.00 34.83           N  
ATOM     64  CA  ILE A   6      -7.917   1.407   0.679  1.00 34.39           C  
ATOM     65  C   ILE A   6      -9.220   1.932   0.124  1.00 34.10           C  
ATOM     66  O   ILE A   6      -9.932   1.185  -0.549  1.00 33.61           O  
ATOM     67  CB  ILE A   6      -7.002   1.070  -0.505  1.00 34.51           C  
ATOM     68  CG1 ILE A   6      -5.631   0.594  -0.028  1.00 34.51           C  
ATOM     69  CG2 ILE A   6      -6.724   2.314  -1.338  1.00 36.61           C  
ATOM     70  CD1 ILE A   6      -4.895  -0.202  -1.039  1.00 32.24           C  
ATOM     71  N   TYR A   7      -9.506   3.215   0.376  1.00 33.58           N  
ATOM     72  CA  TYR A   7     -10.661   3.885  -0.170  1.00 33.43           C  
ATOM     73  C   TYR A   7     -10.233   4.944  -1.162  1.00 33.26           C  
ATOM     74  O   TYR A   7      -9.394   5.775  -0.870  1.00 32.40           O  
ATOM     75  CB  TYR A   7     -11.422   4.594   0.902  1.00 33.75           C  
ATOM     76  CG  TYR A   7     -11.940   3.762   2.010  1.00 38.10           C  
ATOM     77  CD1 TYR A   7     -11.086   3.261   2.976  1.00 41.52           C  
ATOM     78  CD2 TYR A   7     -13.300   3.538   2.156  1.00 40.26           C  
ATOM     79  CE1 TYR A   7     -11.547   2.510   4.015  1.00 42.71           C  
ATOM     80  CE2 TYR A   7     -13.783   2.807   3.216  1.00 42.71           C  
ATOM     81  CZ  TYR A   7     -12.898   2.284   4.151  1.00 44.49           C  
ATOM     82  OH  TYR A   7     -13.357   1.555   5.239  1.00 46.13           O  
ATOM     83  N   LEU A   8     -10.841   4.943  -2.333  1.00 33.19           N  
ATOM     84  CA  LEU A   8     -10.526   5.935  -3.325  1.00 33.08           C  
ATOM     85  C   LEU A   8     -11.790   6.218  -4.155  1.00 32.90           C  
ATOM     86  O   LEU A   8     -12.799   5.585  -3.938  1.00 33.21           O  
ATOM     87  CB  LEU A   8      -9.332   5.441  -4.153  1.00 33.15           C  
ATOM     88  CG  LEU A   8      -9.439   4.246  -5.108  1.00 35.66           C  
ATOM     89  CD1 LEU A   8      -8.299   4.298  -6.069  1.00 39.33           C  
ATOM     90  CD2 LEU A   8      -9.348   2.958  -4.439  1.00 38.18           C  
ATOM     91  N   GLY A   9     -11.774   7.196  -5.049  1.00 32.66           N  
ATOM     92  CA  GLY A   9     -12.889   7.390  -5.967  1.00 33.13           C  
ATOM     93  C   GLY A   9     -12.763   6.586  -7.263  1.00 34.10           C  
ATOM     94  O   GLY A   9     -11.652   6.367  -7.811  1.00 34.17           O  
ATOM     95  N   GLU A  10     -13.899   6.180  -7.803  1.00 34.65           N  
ATOM     96  CA  GLU A  10     -13.900   5.521  -9.095  1.00 35.99           C  
ATOM     97  C   GLU A  10     -13.285   6.383 -10.214  1.00 36.69           C  
ATOM     98  O   GLU A  10     -12.600   5.848 -11.058  1.00 37.31           O  
ATOM     99  CB  GLU A  10     -15.309   5.112  -9.449  1.00 36.44           C  
ATOM    100  CG  GLU A  10     -15.417   4.201 -10.648  1.00 38.64           C  
ATOM    101  CD  GLU A  10     -16.779   3.500 -10.736  1.00 42.24           C  
ATOM    102  OE1 GLU A  10     -17.738   3.902 -10.022  1.00 42.02           O  
ATOM    103  OE2 GLU A  10     -16.885   2.539 -11.527  1.00 44.13           O  
ATOM    104  N   LYS A  11     -13.514   7.698 -10.209  1.00 37.38           N  
ATOM    105  CA  LYS A  11     -12.949   8.596 -11.224  1.00 38.38           C  
ATOM    106  C   LYS A  11     -11.440   8.915 -11.066  1.00 39.00           C  
ATOM    107  O   LYS A  11     -10.858   9.542 -11.954  1.00 39.47           O  
ATOM    108  CB  LYS A  11     -13.778   9.905 -11.340  1.00 38.25           C  
ATOM    109  CG  LYS A  11     -15.176   9.679 -12.000  1.00 39.59           C  
ATOM    110  CD  LYS A  11     -15.796  10.931 -12.678  1.00 38.38           C  
ATOM    111  N   ASP A  12     -10.807   8.472  -9.980  1.00 39.67           N  
ATOM    112  CA  ASP A  12      -9.360   8.611  -9.811  1.00 40.28           C  
ATOM    113  C   ASP A  12      -8.608   7.850 -10.900  1.00 40.82           C  
ATOM    114  O   ASP A  12      -8.991   6.750 -11.268  1.00 39.94           O  
ATOM    115  CB  ASP A  12      -8.914   8.117  -8.422  1.00 40.88           C  
ATOM    116  CG  ASP A  12      -9.277   9.088  -7.294  1.00 41.97           C  
ATOM    117  OD1 ASP A  12      -9.292  10.286  -7.572  1.00 47.37           O  
ATOM    118  OD2 ASP A  12      -9.512   8.778  -6.100  1.00 43.07           O  
ATOM    119  N   LYS A  13      -7.548   8.464 -11.426  1.00 42.41           N  
ATOM    120  CA  LYS A  13      -6.828   7.949 -12.595  1.00 43.48           C  
ATOM    121  C   LYS A  13      -5.351   7.785 -12.281  1.00 43.92           C  
ATOM    122  O   LYS A  13      -4.796   8.549 -11.505  1.00 43.67           O  
ATOM    123  CB  LYS A  13      -6.945   8.913 -13.786  1.00 43.94           C  
ATOM    124  CG  LYS A  13      -8.360   9.402 -14.169  1.00 45.85           C  
ATOM    125  CD  LYS A  13      -9.348   8.251 -14.531  1.00 47.68           C  
ATOM    126  CE  LYS A  13     -10.456   8.752 -15.486  1.00 47.94           C  
ATOM    127  NZ  LYS A  13     -11.636   7.828 -15.571  1.00 48.05           N  
ATOM    128  N   HIS A  14      -4.727   6.771 -12.868  1.00 44.81           N  
ATOM    129  CA  HIS A  14      -3.280   6.682 -12.912  1.00 45.83           C  
ATOM    130  C   HIS A  14      -2.917   6.471 -14.361  1.00 46.40           C  
ATOM    131  O   HIS A  14      -3.274   5.431 -14.929  1.00 46.83           O  
ATOM    132  CB  HIS A  14      -2.721   5.532 -12.072  1.00 46.10           C  
ATOM    133  CG  HIS A  14      -1.218   5.501 -12.025  1.00 48.15           C  
ATOM    134  ND1 HIS A  14      -0.477   6.326 -11.199  1.00 49.39           N  
ATOM    135  CD2 HIS A  14      -0.316   4.771 -12.727  1.00 49.92           C  
ATOM    136  CE1 HIS A  14       0.811   6.095 -11.384  1.00 49.79           C  
ATOM    137  NE2 HIS A  14       0.936   5.157 -12.305  1.00 50.81           N  
ATOM    138  N   SER A  15      -2.231   7.467 -14.937  1.00 46.73           N  
ATOM    139  CA  SER A  15      -1.861   7.494 -16.348  1.00 47.12           C  
ATOM    140  C   SER A  15      -3.108   7.435 -17.226  1.00 46.92           C  
ATOM    141  O   SER A  15      -3.208   6.592 -18.115  1.00 46.88           O  
ATOM    142  CB  SER A  15      -0.903   6.343 -16.677  1.00 47.28           C  
ATOM    143  OG  SER A  15       0.104   6.238 -15.684  1.00 48.64           O  
ATOM    144  N   GLY A  16      -4.067   8.315 -16.945  1.00 46.59           N  
ATOM    145  CA  GLY A  16      -5.339   8.316 -17.656  1.00 46.57           C  
ATOM    146  C   GLY A  16      -6.270   7.128 -17.407  1.00 46.59           C  
ATOM    147  O   GLY A  16      -7.452   7.215 -17.748  1.00 47.34           O  
ATOM    148  N   LYS A  17      -5.762   6.041 -16.800  1.00 46.11           N  
ATOM    149  CA  LYS A  17      -6.499   4.760 -16.615  1.00 45.07           C  
ATOM    150  C   LYS A  17      -6.965   4.604 -15.161  1.00 43.89           C  
ATOM    151  O   LYS A  17      -6.394   5.227 -14.271  1.00 43.52           O  
ATOM    152  CB  LYS A  17      -5.602   3.557 -16.996  1.00 45.36           C  
ATOM    153  CG  LYS A  17      -4.994   3.576 -18.430  1.00 45.66           C  
ATOM    154  CD  LYS A  17      -4.030   2.391 -18.586  1.00 46.34           C  
ATOM    155  CE  LYS A  17      -3.336   2.345 -19.947  1.00 45.93           C  
ATOM    156  N   PRO A  18      -7.974   3.763 -14.905  1.00 42.58           N  
ATOM    157  CA  PRO A  18      -8.618   3.745 -13.584  1.00 41.79           C  
ATOM    158  C   PRO A  18      -7.654   3.279 -12.497  1.00 40.47           C  
ATOM    159  O   PRO A  18      -7.022   2.254 -12.643  1.00 40.16           O  
ATOM    160  CB  PRO A  18      -9.792   2.768 -13.764  1.00 41.83           C  
ATOM    161  CG  PRO A  18      -9.946   2.625 -15.235  1.00 41.82           C  
ATOM    162  CD  PRO A  18      -8.565   2.754 -15.801  1.00 42.33           C  
ATOM    163  N   LEU A  19      -7.526   4.069 -11.440  1.00 39.40           N  
ATOM    164  CA  LEU A  19      -6.549   3.803 -10.386  1.00 38.25           C  
ATOM    165  C   LEU A  19      -6.829   2.514  -9.645  1.00 36.95           C  
ATOM    166  O   LEU A  19      -5.912   1.786  -9.293  1.00 35.32           O  
ATOM    167  CB  LEU A  19      -6.515   4.943  -9.374  1.00 38.12           C  
ATOM    168  CG  LEU A  19      -5.496   4.822  -8.246  1.00 38.11           C  
ATOM    169  CD1 LEU A  19      -4.097   4.548  -8.780  1.00 38.59           C  
ATOM    170  CD2 LEU A  19      -5.478   6.099  -7.448  1.00 37.98           C  
ATOM    171  N   PHE A  20      -8.096   2.237  -9.392  1.00 36.58           N  
ATOM    172  CA  PHE A  20      -8.408   1.025  -8.652  1.00 36.27           C  
ATOM    173  C   PHE A  20      -7.985  -0.223  -9.402  1.00 36.39           C  
ATOM    174  O   PHE A  20      -7.510  -1.162  -8.772  1.00 37.53           O  
ATOM    175  CB  PHE A  20      -9.870   0.965  -8.215  1.00 36.75           C  
ATOM    176  CG  PHE A  20     -10.856   0.628  -9.300  1.00 34.84           C  
ATOM    177  CD1 PHE A  20     -11.416   1.634 -10.083  1.00 36.72           C  
ATOM    178  CD2 PHE A  20     -11.314  -0.674  -9.452  1.00 35.11           C  
ATOM    179  CE1 PHE A  20     -12.395   1.346 -11.075  1.00 36.69           C  
ATOM    180  CE2 PHE A  20     -12.297  -0.982 -10.433  1.00 37.86           C  
ATOM    181  CZ  PHE A  20     -12.827   0.039 -11.249  1.00 36.14           C  
ATOM    182  N   GLU A  21      -8.138  -0.223 -10.726  1.00 35.69           N  
ATOM    183  CA  GLU A  21      -7.668  -1.315 -11.574  1.00 35.82           C  
ATOM    184  C   GLU A  21      -6.162  -1.416 -11.556  1.00 34.01           C  
ATOM    185  O   GLU A  21      -5.611  -2.511 -11.545  1.00 34.16           O  
ATOM    186  CB  GLU A  21      -8.131  -1.145 -13.033  1.00 36.37           C  
ATOM    187  CG  GLU A  21      -9.582  -1.578 -13.257  1.00 40.42           C  
ATOM    188  CD  GLU A  21     -10.084  -1.225 -14.643  1.00 43.14           C  
ATOM    189  OE1 GLU A  21      -9.263  -1.061 -15.567  1.00 45.24           O  
ATOM    190  OE2 GLU A  21     -11.317  -1.104 -14.805  1.00 49.02           O  
ATOM    191  N   TYR A  22      -5.499  -0.272 -11.577  1.00 32.28           N  
ATOM    192  CA  TYR A  22      -4.054  -0.254 -11.429  1.00 31.68           C  
ATOM    193  C   TYR A  22      -3.592  -0.805 -10.063  1.00 31.17           C  
ATOM    194  O   TYR A  22      -2.658  -1.564 -10.011  1.00 30.42           O  
ATOM    195  CB  TYR A  22      -3.502   1.145 -11.676  1.00 31.58           C  
ATOM    196  CG  TYR A  22      -2.020   1.221 -11.469  1.00 31.22           C  
ATOM    197  CD1 TYR A  22      -1.136   0.939 -12.506  1.00 31.83           C  
ATOM    198  CD2 TYR A  22      -1.505   1.547 -10.213  1.00 30.95           C  
ATOM    199  CE1 TYR A  22       0.232   1.002 -12.303  1.00 33.14           C  
ATOM    200  CE2 TYR A  22      -0.173   1.602  -9.990  1.00 31.32           C  
ATOM    201  CZ  TYR A  22       0.700   1.333 -11.028  1.00 35.02           C  
ATOM    202  OH  TYR A  22       2.038   1.419 -10.775  1.00 38.61           O  
ATOM    203  N   LEU A  23      -4.277  -0.448  -8.979  1.00 31.05           N  
ATOM    204  CA  LEU A  23      -3.965  -1.013  -7.665  1.00 31.40           C  
ATOM    205  C   LEU A  23      -4.130  -2.520  -7.599  1.00 32.36           C  
ATOM    206  O   LEU A  23      -3.278  -3.202  -7.069  1.00 33.50           O  
ATOM    207  CB  LEU A  23      -4.781  -0.341  -6.560  1.00 30.34           C  
ATOM    208  CG  LEU A  23      -4.324   1.103  -6.299  1.00 29.15           C  
ATOM    209  CD1 LEU A  23      -5.147   1.758  -5.230  1.00 30.14           C  
ATOM    210  CD2 LEU A  23      -2.835   1.158  -5.973  1.00 26.32           C  
ATOM    211  N   VAL A  24      -5.214  -3.038  -8.147  1.00 33.38           N  
ATOM    212  CA  VAL A  24      -5.474  -4.455  -8.115  1.00 33.65           C  
ATOM    213  C   VAL A  24      -4.397  -5.180  -8.904  1.00 34.32           C  
ATOM    214  O   VAL A  24      -4.009  -6.309  -8.594  1.00 35.30           O  
ATOM    215  CB  VAL A  24      -6.836  -4.758  -8.754  1.00 33.66           C  
ATOM    216  CG1 VAL A  24      -6.960  -6.253  -9.099  1.00 33.51           C  
ATOM    217  CG2 VAL A  24      -7.943  -4.337  -7.841  1.00 34.10           C  
ATOM    218  N   LYS A  25      -3.943  -4.535  -9.964  1.00 34.57           N  
ATOM    219  CA  LYS A  25      -2.957  -5.129 -10.836  1.00 34.25           C  
ATOM    220  C   LYS A  25      -1.572  -5.133 -10.164  1.00 33.73           C  
ATOM    221  O   LYS A  25      -0.837  -6.109 -10.301  1.00 34.09           O  
ATOM    222  CB  LYS A  25      -2.957  -4.411 -12.191  1.00 33.92           C  
ATOM    223  CG  LYS A  25      -2.024  -5.010 -13.207  1.00 34.94           C  
ATOM    224  CD  LYS A  25      -1.842  -4.103 -14.476  1.00 36.08           C  
ATOM    225  N   ARG A  26      -1.204  -4.060  -9.463  1.00 33.48           N  
ATOM    226  CA  ARG A  26       0.040  -4.076  -8.685  1.00 33.94           C  
ATOM    227  C   ARG A  26      -0.072  -5.124  -7.599  1.00 33.52           C  
ATOM    228  O   ARG A  26       0.837  -5.926  -7.438  1.00 33.41           O  
ATOM    229  CB  ARG A  26       0.392  -2.727  -8.056  1.00 33.96           C  
ATOM    230  CG  ARG A  26       0.743  -1.654  -9.029  1.00 37.04           C  
ATOM    231  CD  ARG A  26       1.872  -2.016 -10.003  1.00 40.78           C  
ATOM    232  NE  ARG A  26       3.128  -2.340  -9.313  1.00 43.21           N  
ATOM    233  CZ  ARG A  26       4.035  -3.204  -9.772  1.00 46.89           C  
ATOM    234  NH1 ARG A  26       3.860  -3.838 -10.921  1.00 47.85           N  
ATOM    235  NH2 ARG A  26       5.152  -3.423  -9.093  1.00 49.53           N  
ATOM    236  N   ALA A  27      -1.201  -5.171  -6.903  1.00 33.29           N  
ATOM    237  CA  ALA A  27      -1.366  -6.200  -5.882  1.00 33.83           C  
ATOM    238  C   ALA A  27      -1.027  -7.579  -6.461  1.00 33.59           C  
ATOM    239  O   ALA A  27      -0.280  -8.353  -5.862  1.00 33.73           O  
ATOM    240  CB  ALA A  27      -2.753  -6.187  -5.289  1.00 33.30           C  
ATOM    241  N   TYR A  28      -1.540  -7.863  -7.647  1.00 33.77           N  
ATOM    242  CA  TYR A  28      -1.344  -9.158  -8.228  1.00 34.22           C  
ATOM    243  C   TYR A  28       0.125  -9.338  -8.609  1.00 34.79           C  
ATOM    244  O   TYR A  28       0.696 -10.393  -8.393  1.00 35.77           O  
ATOM    245  CB  TYR A  28      -2.263  -9.309  -9.447  1.00 34.76           C  
ATOM    246  CG  TYR A  28      -2.117 -10.625 -10.138  1.00 34.06           C  
ATOM    247  CD1 TYR A  28      -2.922 -11.695  -9.802  1.00 35.76           C  
ATOM    248  CD2 TYR A  28      -1.139 -10.815 -11.091  1.00 37.06           C  
ATOM    249  CE1 TYR A  28      -2.777 -12.926 -10.419  1.00 36.96           C  
ATOM    250  CE2 TYR A  28      -0.984 -12.042 -11.724  1.00 37.63           C  
ATOM    251  CZ  TYR A  28      -1.809 -13.090 -11.373  1.00 38.08           C  
ATOM    252  OH  TYR A  28      -1.671 -14.300 -11.995  1.00 42.25           O  
ATOM    253  N   GLU A  29       0.744  -8.321  -9.195  1.00 35.25           N  
ATOM    254  CA  GLU A  29       2.146  -8.448  -9.623  1.00 35.68           C  
ATOM    255  C   GLU A  29       3.112  -8.664  -8.454  1.00 35.60           C  
ATOM    256  O   GLU A  29       4.055  -9.410  -8.578  1.00 35.67           O  
ATOM    257  CB  GLU A  29       2.555  -7.265 -10.514  1.00 36.03           C  
ATOM    258  CG  GLU A  29       2.018  -7.404 -11.955  1.00 38.45           C  
ATOM    259  CD  GLU A  29       2.093  -6.122 -12.791  1.00 41.06           C  
ATOM    260  OE1 GLU A  29       2.147  -6.217 -14.036  1.00 43.40           O  
ATOM    261  OE2 GLU A  29       2.081  -5.010 -12.220  1.00 42.73           O  
ATOM    262  N   LEU A  30       2.832  -8.055  -7.312  1.00 35.89           N  
ATOM    263  CA  LEU A  30       3.623  -8.246  -6.088  1.00 36.51           C  
ATOM    264  C   LEU A  30       3.462  -9.581  -5.366  1.00 36.28           C  
ATOM    265  O   LEU A  30       4.148  -9.803  -4.378  1.00 37.28           O  
ATOM    266  CB  LEU A  30       3.270  -7.164  -5.052  1.00 36.55           C  
ATOM    267  CG  LEU A  30       3.583  -5.736  -5.514  1.00 39.23           C  
ATOM    268  CD1 LEU A  30       3.261  -4.775  -4.406  1.00 42.56           C  
ATOM    269  CD2 LEU A  30       5.021  -5.532  -5.981  1.00 39.88           C  
ATOM    270  N   GLY A  31       2.557 -10.448  -5.809  1.00 35.48           N  
ATOM    271  CA  GLY A  31       2.343 -11.707  -5.132  1.00 34.85           C  
ATOM    272  C   GLY A  31       1.482 -11.615  -3.877  1.00 35.24           C  
ATOM    273  O   GLY A  31       1.595 -12.493  -3.023  1.00 35.55           O  
HETATM  274  N   MSE A  32       0.595 -10.613  -3.758  1.00 34.75           N  
HETATM  275  CA  MSE A  32      -0.388 -10.619  -2.663  1.00 34.67           C  
HETATM  276  C   MSE A  32      -1.275 -11.836  -2.672  1.00 34.10           C  
HETATM  277  O   MSE A  32      -1.580 -12.388  -3.716  1.00 34.86           O  
HETATM  278  CB  MSE A  32      -1.292  -9.357  -2.633  1.00 35.63           C  
ATOM    279  N   LYS A  33      -1.726 -12.229  -1.490  1.00 33.91           N  
ATOM    280  CA  LYS A  33      -2.510 -13.439  -1.338  1.00 34.01           C  
ATOM    281  C   LYS A  33      -3.871 -13.268  -1.969  1.00 34.19           C  
ATOM    282  O   LYS A  33      -4.494 -14.235  -2.368  1.00 34.01           O  
ATOM    283  CB  LYS A  33      -2.673 -13.771   0.134  1.00 34.37           C  
ATOM    284  CG  LYS A  33      -1.502 -14.548   0.738  1.00 36.97           C  
ATOM    285  CD  LYS A  33      -1.637 -14.667   2.279  1.00 38.08           C  
ATOM    286  CE  LYS A  33      -0.778 -15.772   2.842  1.00 38.72           C  
ATOM    287  NZ  LYS A  33      -0.174 -15.321   4.117  1.00 41.25           N  
ATOM    288  N   GLY A  34      -4.349 -12.024  -2.025  1.00 34.32           N  
ATOM    289  CA  GLY A  34      -5.611 -11.756  -2.627  1.00 33.99           C  
ATOM    290  C   GLY A  34      -6.035 -10.339  -2.473  1.00 33.91           C  
ATOM    291  O   GLY A  34      -5.409  -9.564  -1.754  1.00 33.57           O  
ATOM    292  N   VAL A  35      -7.144 -10.035  -3.149  1.00 33.66           N  
ATOM    293  CA  VAL A  35      -7.808  -8.769  -3.031  1.00 33.70           C  
ATOM    294  C   VAL A  35      -9.281  -8.886  -3.281  1.00 32.29           C  
ATOM    295  O   VAL A  35      -9.736  -9.674  -4.104  1.00 31.85           O  
ATOM    296  CB  VAL A  35      -7.161  -7.683  -3.991  1.00 34.68           C  
ATOM    297  CG1 VAL A  35      -7.253  -8.135  -5.370  1.00 38.15           C  
ATOM    298  CG2 VAL A  35      -7.858  -6.292  -3.872  1.00 34.03           C  
ATOM    299  N   THR A  36     -10.041  -8.066  -2.573  1.00 31.74           N  
ATOM    300  CA  THR A  36     -11.448  -7.955  -2.839  1.00 31.49           C  
ATOM    301  C   THR A  36     -11.815  -6.507  -3.051  1.00 31.78           C  
ATOM    302  O   THR A  36     -11.413  -5.634  -2.285  1.00 32.51           O  
ATOM    303  CB  THR A  36     -12.244  -8.545  -1.674  1.00 32.27           C  
ATOM    304  OG1 THR A  36     -12.036  -9.960  -1.585  1.00 27.87           O  
ATOM    305  CG2 THR A  36     -13.743  -8.401  -1.933  1.00 33.29           C  
ATOM    306  N   VAL A  37     -12.571  -6.238  -4.106  1.00 31.53           N  
ATOM    307  CA  VAL A  37     -12.925  -4.854  -4.476  1.00 30.92           C  
ATOM    308  C   VAL A  37     -14.433  -4.626  -4.374  1.00 29.87           C  
ATOM    309  O   VAL A  37     -15.237  -5.420  -4.855  1.00 26.56           O  
ATOM    310  CB  VAL A  37     -12.482  -4.489  -5.936  1.00 31.56           C  
ATOM    311  CG1 VAL A  37     -12.671  -3.009  -6.188  1.00 32.00           C  
ATOM    312  CG2 VAL A  37     -11.045  -4.818  -6.177  1.00 31.70           C  
ATOM    313  N   TYR A  38     -14.806  -3.527  -3.726  1.00 30.89           N  
ATOM    314  CA  TYR A  38     -16.216  -3.168  -3.558  1.00 31.61           C  
ATOM    315  C   TYR A  38     -16.492  -1.803  -4.152  1.00 31.72           C  
ATOM    316  O   TYR A  38     -15.598  -0.948  -4.215  1.00 32.04           O  
ATOM    317  CB  TYR A  38     -16.540  -3.011  -2.118  1.00 32.75           C  
ATOM    318  CG  TYR A  38     -16.170  -4.150  -1.195  1.00 36.98           C  
ATOM    319  CD1 TYR A  38     -14.883  -4.292  -0.706  1.00 38.70           C  
ATOM    320  CD2 TYR A  38     -17.132  -5.030  -0.745  1.00 38.68           C  
ATOM    321  CE1 TYR A  38     -14.574  -5.294   0.175  1.00 39.37           C  
ATOM    322  CE2 TYR A  38     -16.825  -6.009   0.130  1.00 40.59           C  
ATOM    323  CZ  TYR A  38     -15.547  -6.152   0.594  1.00 38.69           C  
ATOM    324  OH  TYR A  38     -15.268  -7.166   1.491  1.00 40.47           O  
ATOM    325  N   ARG A  39     -17.738  -1.591  -4.547  1.00 30.81           N  
ATOM    326  CA  ARG A  39     -18.197  -0.313  -4.959  1.00 30.40           C  
ATOM    327  C   ARG A  39     -19.305   0.164  -4.049  1.00 30.47           C  
ATOM    328  O   ARG A  39     -20.265  -0.516  -3.837  1.00 32.10           O  
ATOM    329  CB  ARG A  39     -18.659  -0.358  -6.393  1.00 30.10           C  
ATOM    330  CG  ARG A  39     -19.126   0.990  -6.873  1.00 30.67           C  
ATOM    331  CD  ARG A  39     -19.769   0.978  -8.232  1.00 30.64           C  
ATOM    332  NE  ARG A  39     -18.774   0.835  -9.298  1.00 32.28           N  
ATOM    333  CZ  ARG A  39     -18.623  -0.220 -10.083  1.00 31.47           C  
ATOM    334  NH1 ARG A  39     -19.398  -1.288  -9.970  1.00 30.81           N  
ATOM    335  NH2 ARG A  39     -17.686  -0.200 -11.018  1.00 33.67           N  
ATOM    336  N   GLY A  40     -19.143   1.336  -3.464  1.00 30.93           N  
ATOM    337  CA  GLY A  40     -20.163   1.938  -2.599  1.00 29.78           C  
ATOM    338  C   GLY A  40     -21.225   2.690  -3.371  1.00 29.39           C  
ATOM    339  O   GLY A  40     -21.124   2.913  -4.571  1.00 30.07           O  
ATOM    340  N   ILE A  41     -22.238   3.111  -2.656  1.00 28.46           N  
ATOM    341  CA  ILE A  41     -23.312   3.834  -3.217  1.00 28.40           C  
ATOM    342  C   ILE A  41     -23.268   5.306  -2.867  1.00 28.80           C  
ATOM    343  O   ILE A  41     -24.065   6.066  -3.378  1.00 28.47           O  
ATOM    344  CB  ILE A  41     -24.655   3.213  -2.747  1.00 28.88           C  
ATOM    345  CG1 ILE A  41     -24.800   3.256  -1.205  1.00 28.81           C  
ATOM    346  CG2 ILE A  41     -24.750   1.762  -3.285  1.00 28.03           C  
ATOM    347  CD1 ILE A  41     -26.265   3.221  -0.706  1.00 28.88           C  
HETATM  348  N   MSE A  42     -22.366   5.703  -1.980  1.00 30.16           N  
HETATM  349  CA  MSE A  42     -22.307   7.085  -1.473  1.00 31.68           C  
HETATM  350  C   MSE A  42     -21.038   7.218  -0.652  1.00 31.28           C  
HETATM  351  O   MSE A  42     -20.567   6.248  -0.066  1.00 31.81           O  
HETATM  352  CB  MSE A  42     -23.515   7.392  -0.587  1.00 32.89           C  
HETATM  353  CG  MSE A  42     -23.879   8.800  -0.511  1.00 39.76           C  
HETATM  354 SE   MSE A  42     -25.534   8.960   0.493  0.50 56.50          SE  
HETATM  355  CE  MSE A  42     -26.341  10.654  -0.173  1.00 55.02           C  
ATOM    356  N   GLY A  43     -20.480   8.414  -0.602  1.00 30.74           N  
ATOM    357  CA  GLY A  43     -19.283   8.663   0.211  1.00 30.58           C  
ATOM    358  C   GLY A  43     -18.809  10.104   0.182  1.00 29.31           C  
ATOM    359  O   GLY A  43     -19.187  10.836  -0.687  1.00 29.21           O  
ATOM    360  N   PHE A  44     -18.028  10.505   1.159  1.00 28.91           N  
ATOM    361  CA  PHE A  44     -17.230  11.721   1.062  1.00 29.57           C  
ATOM    362  C   PHE A  44     -15.942  11.574   1.902  1.00 30.96           C  
ATOM    363  O   PHE A  44     -15.853  10.725   2.808  1.00 30.59           O  
ATOM    364  CB  PHE A  44     -18.030  12.935   1.469  1.00 28.28           C  
ATOM    365  CG  PHE A  44     -18.358  12.995   2.939  1.00 30.26           C  
ATOM    366  CD1 PHE A  44     -17.422  13.492   3.866  1.00 29.75           C  
ATOM    367  CD2 PHE A  44     -19.620  12.616   3.407  1.00 29.80           C  
ATOM    368  CE1 PHE A  44     -17.740  13.592   5.224  1.00 28.79           C  
ATOM    369  CE2 PHE A  44     -19.938  12.718   4.752  1.00 28.65           C  
ATOM    370  CZ  PHE A  44     -18.997  13.185   5.663  1.00 28.59           C  
ATOM    371  N   GLY A  45     -14.946  12.379   1.581  1.00 32.53           N  
ATOM    372  CA  GLY A  45     -13.663  12.335   2.265  1.00 34.53           C  
ATOM    373  C   GLY A  45     -13.183  13.716   2.683  1.00 36.45           C  
ATOM    374  O   GLY A  45     -13.978  14.591   2.916  1.00 35.29           O  
ATOM    375  N   HIS A  46     -11.859  13.846   2.789  1.00 40.03           N  
ATOM    376  CA  HIS A  46     -11.068  15.117   2.908  1.00 43.14           C  
ATOM    377  C   HIS A  46     -10.113  15.038   4.113  1.00 44.65           C  
ATOM    378  O   HIS A  46      -9.071  14.371   4.028  1.00 46.81           O  
ATOM    379  CB  HIS A  46     -11.891  16.417   2.939  1.00 43.22           C  
ATOM    380  CG  HIS A  46     -12.399  16.841   1.593  1.00 46.43           C  
ATOM    381  ND1 HIS A  46     -12.907  15.939   0.670  1.00 48.72           N  
ATOM    382  CD2 HIS A  46     -12.502  18.071   1.024  1.00 47.96           C  
ATOM    383  CE1 HIS A  46     -13.284  16.596  -0.416  1.00 49.74           C  
ATOM    384  NE2 HIS A  46     -13.050  17.890  -0.226  1.00 49.83           N  
ATOM    385  N   PRO A  60     -21.112  10.683 -11.714  1.00 44.02           N  
ATOM    386  CA  PRO A  60     -21.192  10.115 -10.353  1.00 43.85           C  
ATOM    387  C   PRO A  60     -19.870   9.474  -9.994  1.00 43.14           C  
ATOM    388  O   PRO A  60     -19.386   8.637 -10.752  1.00 44.31           O  
ATOM    389  CB  PRO A  60     -22.306   9.050 -10.463  1.00 43.89           C  
ATOM    390  CG  PRO A  60     -22.698   9.015 -11.944  1.00 44.15           C  
ATOM    391  CD  PRO A  60     -21.598   9.732 -12.722  1.00 44.54           C  
ATOM    392  N   ASP A  61     -19.268   9.876  -8.882  1.00 41.80           N  
ATOM    393  CA  ASP A  61     -17.955   9.339  -8.490  1.00 41.08           C  
ATOM    394  C   ASP A  61     -18.156   8.585  -7.192  1.00 39.00           C  
ATOM    395  O   ASP A  61     -18.257   9.171  -6.128  1.00 40.02           O  
ATOM    396  CB  ASP A  61     -16.943  10.467  -8.300  1.00 41.70           C  
ATOM    397  CG  ASP A  61     -15.512   9.969  -8.053  1.00 44.64           C  
ATOM    398  OD1 ASP A  61     -15.188   8.775  -8.254  1.00 44.83           O  
ATOM    399  OD2 ASP A  61     -14.609  10.756  -7.672  1.00 51.67           O  
ATOM    400  N   LEU A  62     -18.269   7.278  -7.318  1.00 36.56           N  
ATOM    401  CA  LEU A  62     -18.652   6.411  -6.253  1.00 33.91           C  
ATOM    402  C   LEU A  62     -17.386   5.907  -5.581  1.00 33.60           C  
ATOM    403  O   LEU A  62     -16.332   5.793  -6.209  1.00 33.25           O  
ATOM    404  CB  LEU A  62     -19.465   5.256  -6.825  1.00 32.92           C  
ATOM    405  CG  LEU A  62     -20.798   5.651  -7.460  1.00 33.08           C  
ATOM    406  CD1 LEU A  62     -21.468   4.460  -8.134  1.00 30.94           C  
ATOM    407  CD2 LEU A  62     -21.747   6.271  -6.427  1.00 34.53           C  
ATOM    408  N   PRO A  63     -17.479   5.576  -4.306  1.00 33.08           N  
ATOM    409  CA  PRO A  63     -16.344   5.020  -3.593  1.00 33.03           C  
ATOM    410  C   PRO A  63     -15.936   3.699  -4.228  1.00 32.75           C  
ATOM    411  O   PRO A  63     -16.821   2.928  -4.602  1.00 32.38           O  
ATOM    412  CB  PRO A  63     -16.916   4.742  -2.196  1.00 32.78           C  
ATOM    413  CG  PRO A  63     -18.076   5.563  -2.097  1.00 33.50           C  
ATOM    414  CD  PRO A  63     -18.671   5.648  -3.460  1.00 32.89           C  
ATOM    415  N   ILE A  64     -14.637   3.440  -4.332  1.00 32.85           N  
ATOM    416  CA  ILE A  64     -14.125   2.089  -4.539  1.00 33.16           C  
ATOM    417  C   ILE A  64     -13.297   1.722  -3.319  1.00 34.37           C  
ATOM    418  O   ILE A  64     -12.523   2.533  -2.832  1.00 34.20           O  
ATOM    419  CB  ILE A  64     -13.286   2.016  -5.781  1.00 33.39           C  
ATOM    420  CG1 ILE A  64     -14.102   2.384  -7.028  1.00 31.08           C  
ATOM    421  CG2 ILE A  64     -12.631   0.617  -5.927  1.00 35.30           C  
ATOM    422  CD1 ILE A  64     -15.114   1.409  -7.378  1.00 30.85           C  
ATOM    423  N   VAL A  65     -13.512   0.524  -2.777  1.00 35.66           N  
ATOM    424  CA  VAL A  65     -12.765   0.047  -1.614  1.00 36.39           C  
ATOM    425  C   VAL A  65     -12.059  -1.277  -1.942  1.00 36.60           C  
ATOM    426  O   VAL A  65     -12.661  -2.193  -2.475  1.00 36.19           O  
ATOM    427  CB  VAL A  65     -13.706  -0.125  -0.428  1.00 36.50           C  
ATOM    428  CG1 VAL A  65     -12.983  -0.642   0.783  1.00 36.54           C  
ATOM    429  CG2 VAL A  65     -14.338   1.193  -0.141  1.00 40.90           C  
ATOM    430  N   LEU A  66     -10.771  -1.346  -1.651  1.00 37.62           N  
ATOM    431  CA  LEU A  66     -10.010  -2.581  -1.781  1.00 38.66           C  
ATOM    432  C   LEU A  66      -9.700  -3.094  -0.417  1.00 38.00           C  
ATOM    433  O   LEU A  66      -9.279  -2.320   0.447  1.00 39.08           O  
ATOM    434  CB  LEU A  66      -8.679  -2.339  -2.466  1.00 38.92           C  
ATOM    435  CG  LEU A  66      -8.638  -2.260  -3.982  1.00 41.47           C  
ATOM    436  CD1 LEU A  66      -9.211  -0.962  -4.451  1.00 43.79           C  
ATOM    437  CD2 LEU A  66      -7.197  -2.362  -4.431  1.00 43.22           C  
ATOM    438  N   GLU A  67      -9.873  -4.391  -0.236  1.00 37.04           N  
ATOM    439  CA  GLU A  67      -9.404  -5.089   0.952  1.00 36.51           C  
ATOM    440  C   GLU A  67      -8.400  -6.167   0.533  1.00 35.27           C  
ATOM    441  O   GLU A  67      -8.645  -6.932  -0.394  1.00 34.25           O  
ATOM    442  CB  GLU A  67     -10.548  -5.770   1.674  1.00 36.94           C  
ATOM    443  CG  GLU A  67     -11.487  -4.890   2.417  1.00 39.78           C  
ATOM    444  CD  GLU A  67     -12.639  -5.656   3.104  1.00 44.60           C  
ATOM    445  OE1 GLU A  67     -13.148  -5.120   4.099  1.00 47.69           O  
ATOM    446  OE2 GLU A  67     -13.063  -6.761   2.669  1.00 44.14           O  
ATOM    447  N   ILE A  68      -7.261  -6.158   1.210  1.00 34.85           N  
ATOM    448  CA  ILE A  68      -6.192  -7.138   1.112  1.00 34.32           C  
ATOM    449  C   ILE A  68      -5.907  -7.703   2.512  1.00 34.61           C  
ATOM    450  O   ILE A  68      -5.667  -6.919   3.456  1.00 33.85           O  
ATOM    451  CB  ILE A  68      -4.961  -6.433   0.575  1.00 34.50           C  
ATOM    452  CG1 ILE A  68      -5.234  -5.876  -0.846  1.00 36.48           C  
ATOM    453  CG2 ILE A  68      -3.767  -7.350   0.568  1.00 33.21           C  
ATOM    454  CD1 ILE A  68      -4.027  -5.162  -1.482  1.00 36.79           C  
ATOM    455  N   VAL A  69      -5.978  -9.034   2.665  1.00 34.27           N  
ATOM    456  CA  VAL A  69      -5.501  -9.677   3.874  1.00 34.77           C  
ATOM    457  C   VAL A  69      -4.234 -10.450   3.601  1.00 34.24           C  
ATOM    458  O   VAL A  69      -4.198 -11.350   2.784  1.00 34.94           O  
ATOM    459  CB  VAL A  69      -6.602 -10.530   4.543  1.00 35.97           C  
ATOM    460  CG1 VAL A  69      -6.071 -11.194   5.799  1.00 36.58           C  
ATOM    461  CG2 VAL A  69      -7.820  -9.601   4.930  1.00 37.22           C  
ATOM    462  N   ASP A  70      -3.149 -10.047   4.248  1.00 34.61           N  
ATOM    463  CA  ASP A  70      -1.827 -10.613   3.935  1.00 34.66           C  
ATOM    464  C   ASP A  70      -0.904 -10.489   5.097  1.00 34.15           C  
ATOM    465  O   ASP A  70      -1.243  -9.870   6.095  1.00 34.71           O  
ATOM    466  CB  ASP A  70      -1.205  -9.922   2.722  1.00 34.68           C  
ATOM    467  CG  ASP A  70      -0.516 -10.909   1.784  1.00 38.75           C  
ATOM    468  OD1 ASP A  70       0.269 -11.762   2.282  1.00 40.66           O  
ATOM    469  OD2 ASP A  70      -0.705 -10.911   0.548  1.00 41.95           O  
ATOM    470  N   GLU A  71       0.267 -11.084   4.964  1.00 34.50           N  
ATOM    471  CA  GLU A  71       1.333 -10.919   5.933  1.00 34.98           C  
ATOM    472  C   GLU A  71       1.690  -9.439   6.031  1.00 35.29           C  
ATOM    473  O   GLU A  71       1.660  -8.714   5.040  1.00 34.94           O  
ATOM    474  CB  GLU A  71       2.565 -11.707   5.509  1.00 35.28           C  
ATOM    475  CG  GLU A  71       2.337 -13.185   5.218  1.00 37.52           C  
ATOM    476  CD  GLU A  71       2.285 -14.062   6.443  1.00 41.29           C  
ATOM    477  OE1 GLU A  71       2.025 -15.303   6.296  1.00 46.08           O  
ATOM    478  OE2 GLU A  71       2.496 -13.517   7.533  1.00 40.78           O  
ATOM    479  N   GLU A  72       2.011  -8.990   7.236  1.00 35.67           N  
ATOM    480  CA  GLU A  72       2.440  -7.615   7.440  1.00 36.69           C  
ATOM    481  C   GLU A  72       3.561  -7.152   6.475  1.00 35.80           C  
ATOM    482  O   GLU A  72       3.551  -6.015   6.001  1.00 35.73           O  
ATOM    483  CB  GLU A  72       2.950  -7.415   8.879  1.00 37.25           C  
ATOM    484  CG  GLU A  72       2.864  -5.950   9.274  1.00 42.60           C  
ATOM    485  CD  GLU A  72       3.433  -5.627  10.650  1.00 48.40           C  
ATOM    486  OE1 GLU A  72       3.843  -6.580  11.361  1.00 53.22           O  
ATOM    487  OE2 GLU A  72       3.456  -4.411  11.005  1.00 50.81           O  
ATOM    488  N   GLU A  73       4.546  -8.014   6.220  1.00 34.96           N  
ATOM    489  CA  GLU A  73       5.656  -7.677   5.360  0.50 34.19           C  
ATOM    491  C   GLU A  73       5.130  -7.343   3.975  1.00 34.39           C  
ATOM    492  O   GLU A  73       5.559  -6.388   3.340  1.00 33.96           O  
ATOM    493  CB  GLU A  73       6.635  -8.836   5.301  0.50 33.76           C  
ATOM    495  CG  GLU A  73       7.386  -9.055   6.597  0.50 32.93           C  
ATOM    497  CD  GLU A  73       6.781 -10.107   7.532  0.50 32.91           C  
ATOM    499  OE1 GLU A  73       5.556 -10.421   7.470  0.50 23.90           O  
ATOM    501  OE2 GLU A  73       7.588 -10.621   8.363  0.50 36.26           O  
ATOM    503  N   ARG A  74       4.167  -8.129   3.514  1.00 34.79           N  
ATOM    504  CA  ARG A  74       3.612  -7.885   2.175  1.00 35.69           C  
ATOM    505  C   ARG A  74       2.802  -6.582   2.093  1.00 35.58           C  
ATOM    506  O   ARG A  74       2.958  -5.802   1.142  1.00 35.84           O  
ATOM    507  CB  ARG A  74       2.794  -9.059   1.656  1.00 35.80           C  
ATOM    508  CG  ARG A  74       3.391  -9.697   0.456  1.00 36.58           C  
ATOM    509  CD  ARG A  74       2.557 -10.774  -0.178  1.00 37.72           C  
ATOM    510  NE  ARG A  74       3.333 -11.980  -0.403  1.00 39.28           N  
ATOM    511  CZ  ARG A  74       3.147 -13.155   0.216  1.00 43.20           C  
ATOM    512  NH1 ARG A  74       2.210 -13.325   1.154  1.00 43.75           N  
ATOM    513  NH2 ARG A  74       3.939 -14.185  -0.103  1.00 43.33           N  
ATOM    514  N   ILE A  75       1.981  -6.334   3.092  1.00 35.51           N  
ATOM    515  CA  ILE A  75       1.186  -5.106   3.150  1.00 35.98           C  
ATOM    516  C   ILE A  75       2.165  -3.947   3.157  1.00 35.70           C  
ATOM    517  O   ILE A  75       2.014  -2.995   2.421  1.00 35.05           O  
ATOM    518  CB  ILE A  75       0.255  -5.110   4.403  1.00 36.27           C  
ATOM    519  CG1 ILE A  75      -1.160  -5.546   4.058  1.00 38.58           C  
ATOM    520  CG2 ILE A  75       0.036  -3.742   4.943  1.00 36.90           C  
ATOM    521  CD1 ILE A  75      -1.314  -6.862   3.716  1.00 40.46           C  
ATOM    522  N   ASN A  76       3.213  -4.047   3.961  1.00 36.40           N  
ATOM    523  CA  ASN A  76       4.216  -2.997   3.986  1.00 36.85           C  
ATOM    524  C   ASN A  76       4.861  -2.716   2.654  1.00 36.66           C  
ATOM    525  O   ASN A  76       5.134  -1.571   2.340  1.00 36.20           O  
ATOM    526  CB  ASN A  76       5.289  -3.314   5.008  1.00 37.11           C  
ATOM    527  CG  ASN A  76       4.827  -3.039   6.404  1.00 39.29           C  
ATOM    528  OD1 ASN A  76       3.786  -2.377   6.624  1.00 42.52           O  
ATOM    529  ND2 ASN A  76       5.591  -3.520   7.372  1.00 41.28           N  
ATOM    530  N   LEU A  77       5.105  -3.765   1.883  1.00 36.99           N  
ATOM    531  CA  LEU A  77       5.751  -3.627   0.589  1.00 37.71           C  
ATOM    532  C   LEU A  77       4.830  -2.903  -0.380  1.00 38.02           C  
ATOM    533  O   LEU A  77       5.246  -1.998  -1.103  1.00 37.09           O  
ATOM    534  CB  LEU A  77       6.092  -5.009   0.045  1.00 38.26           C  
ATOM    535  CG  LEU A  77       6.901  -5.128  -1.231  1.00 38.45           C  
ATOM    536  CD1 LEU A  77       8.004  -4.051  -1.356  1.00 39.38           C  
ATOM    537  CD2 LEU A  77       7.487  -6.526  -1.254  1.00 39.83           C  
ATOM    538  N   PHE A  78       3.565  -3.312  -0.359  1.00 38.80           N  
ATOM    539  CA  PHE A  78       2.523  -2.626  -1.100  1.00 39.65           C  
ATOM    540  C   PHE A  78       2.414  -1.173  -0.661  1.00 39.52           C  
ATOM    541  O   PHE A  78       2.302  -0.315  -1.519  1.00 40.08           O  
ATOM    542  CB  PHE A  78       1.166  -3.316  -0.906  1.00 40.53           C  
ATOM    543  CG  PHE A  78       0.175  -3.010  -1.984  1.00 42.56           C  
ATOM    544  CD1 PHE A  78       0.493  -3.223  -3.303  1.00 45.71           C  
ATOM    545  CD2 PHE A  78      -1.073  -2.540  -1.687  1.00 45.36           C  
ATOM    546  CE1 PHE A  78      -0.417  -2.977  -4.308  1.00 46.12           C  
ATOM    547  CE2 PHE A  78      -1.987  -2.289  -2.699  1.00 45.44           C  
ATOM    548  CZ  PHE A  78      -1.650  -2.515  -4.003  1.00 45.18           C  
ATOM    549  N   LEU A  79       2.467  -0.886   0.644  1.00 39.04           N  
ATOM    550  CA  LEU A  79       2.389   0.503   1.095  1.00 39.17           C  
ATOM    551  C   LEU A  79       3.471   1.313   0.424  1.00 39.56           C  
ATOM    552  O   LEU A  79       3.189   2.409  -0.031  1.00 38.75           O  
ATOM    553  CB  LEU A  79       2.409   0.666   2.624  1.00 38.32           C  
ATOM    554  CG  LEU A  79       1.095   0.149   3.241  1.00 39.63           C  
ATOM    555  CD1 LEU A  79       1.125   0.057   4.736  1.00 39.82           C  
ATOM    556  CD2 LEU A  79      -0.107   0.969   2.821  1.00 40.98           C  
ATOM    557  N   LYS A  80       4.672   0.758   0.289  1.00 41.37           N  
ATOM    558  CA  LYS A  80       5.793   1.511  -0.302  1.00 43.23           C  
ATOM    559  C   LYS A  80       5.545   1.922  -1.769  1.00 44.94           C  
ATOM    560  O   LYS A  80       5.971   2.981  -2.183  1.00 44.77           O  
ATOM    561  CB  LYS A  80       7.116   0.750  -0.164  1.00 43.24           C  
ATOM    562  CG  LYS A  80       8.009   1.247   0.971  1.00 44.55           C  
ATOM    563  N   GLU A  81       4.830   1.096  -2.531  1.00 47.59           N  
ATOM    564  CA  GLU A  81       4.306   1.475  -3.855  1.00 49.52           C  
ATOM    565  C   GLU A  81       3.195   2.515  -3.833  1.00 50.50           C  
ATOM    566  O   GLU A  81       3.253   3.528  -4.491  1.00 51.64           O  
ATOM    567  CB  GLU A  81       3.770   0.250  -4.546  1.00 50.06           C  
ATOM    568  CG  GLU A  81       4.891  -0.643  -5.043  1.00 52.26           C  
ATOM    569  CD  GLU A  81       4.651  -1.091  -6.465  1.00 55.35           C  
ATOM    570  OE1 GLU A  81       5.578  -1.004  -7.296  1.00 58.48           O  
ATOM    571  OE2 GLU A  81       3.524  -1.518  -6.760  1.00 59.48           O  
ATOM    572  N   ILE A  82       2.175   2.280  -3.055  1.00 52.11           N  
ATOM    573  CA  ILE A  82       1.131   3.280  -2.900  1.00 53.06           C  
ATOM    574  C   ILE A  82       1.665   4.686  -2.583  1.00 53.10           C  
ATOM    575  O   ILE A  82       1.000   5.664  -2.866  1.00 53.18           O  
ATOM    576  CB  ILE A  82       0.193   2.813  -1.797  1.00 53.36           C  
ATOM    577  CG1 ILE A  82      -0.614   1.641  -2.287  1.00 53.95           C  
ATOM    578  CG2 ILE A  82      -0.778   3.932  -1.302  1.00 54.91           C  
ATOM    579  CD1 ILE A  82      -1.234   0.879  -1.099  1.00 57.39           C  
ATOM    580  N   ASP A  83       2.840   4.781  -1.973  1.00 53.68           N  
ATOM    581  CA  ASP A  83       3.383   6.068  -1.520  1.00 54.28           C  
ATOM    582  C   ASP A  83       3.707   6.994  -2.712  1.00 53.70           C  
ATOM    583  O   ASP A  83       3.394   8.184  -2.673  1.00 53.58           O  
ATOM    584  CB  ASP A  83       4.631   5.850  -0.634  1.00 54.78           C  
ATOM    585  CG  ASP A  83       5.010   7.096   0.185  1.00 57.48           C  
ATOM    586  OD1 ASP A  83       4.097   7.748   0.741  1.00 61.70           O  
ATOM    587  OD2 ASP A  83       6.194   7.494   0.337  1.00 60.50           O  
ATOM    588  N   ASN A  84       4.293   6.438  -3.770  1.00 52.90           N  
ATOM    589  CA  ASN A  84       4.564   7.200  -4.973  1.00 52.70           C  
ATOM    590  C   ASN A  84       3.311   7.669  -5.737  1.00 52.44           C  
ATOM    591  O   ASN A  84       3.432   8.448  -6.656  1.00 52.74           O  
ATOM    592  CB  ASN A  84       5.485   6.405  -5.898  1.00 52.72           C  
ATOM    593  N   ILE A  85       2.120   7.224  -5.359  1.00 52.41           N  
ATOM    594  CA  ILE A  85       0.881   7.662  -6.017  1.00 52.60           C  
ATOM    595  C   ILE A  85       0.123   8.758  -5.252  1.00 52.25           C  
ATOM    596  O   ILE A  85      -0.254   8.568  -4.090  1.00 52.51           O  
ATOM    597  CB  ILE A  85      -0.107   6.481  -6.181  1.00 52.98           C  
ATOM    598  CG1 ILE A  85       0.480   5.353  -7.024  1.00 53.77           C  
ATOM    599  CG2 ILE A  85      -1.427   6.948  -6.832  1.00 53.16           C  
ATOM    600  CD1 ILE A  85      -0.324   4.065  -6.854  1.00 55.14           C  
ATOM    601  N   ASP A  86      -0.163   9.860  -5.945  1.00 51.77           N  
ATOM    602  CA  ASP A  86      -1.060  10.901  -5.443  1.00 51.26           C  
ATOM    603  C   ASP A  86      -2.533  10.530  -5.724  1.00 50.73           C  
ATOM    604  O   ASP A  86      -2.991  10.576  -6.859  1.00 51.27           O  
ATOM    605  CB  ASP A  86      -0.714  12.261  -6.079  1.00 50.93           C  
ATOM    606  N   PHE A  87      -3.253  10.118  -4.688  1.00 49.81           N  
ATOM    607  CA  PHE A  87      -4.729  10.139  -4.688  1.00 48.96           C  
ATOM    608  C   PHE A  87      -5.113  10.562  -3.273  1.00 48.63           C  
ATOM    609  O   PHE A  87      -4.259  10.529  -2.387  1.00 49.01           O  
ATOM    610  CB  PHE A  87      -5.344   8.772  -5.054  1.00 48.60           C  
ATOM    611  CG  PHE A  87      -5.077   7.679  -4.038  1.00 46.52           C  
ATOM    612  CD1 PHE A  87      -6.091   7.221  -3.203  1.00 45.09           C  
ATOM    613  CD2 PHE A  87      -3.814   7.123  -3.906  1.00 45.44           C  
ATOM    614  CE1 PHE A  87      -5.847   6.224  -2.267  1.00 43.23           C  
ATOM    615  CE2 PHE A  87      -3.573   6.120  -2.976  1.00 44.30           C  
ATOM    616  CZ  PHE A  87      -4.585   5.680  -2.160  1.00 43.57           C  
ATOM    617  N   ASP A  88      -6.361  10.959  -3.045  1.00 48.04           N  
ATOM    618  CA  ASP A  88      -6.774  11.334  -1.679  1.00 48.03           C  
ATOM    619  C   ASP A  88      -7.271  10.116  -0.888  1.00 47.13           C  
ATOM    620  O   ASP A  88      -6.456   9.315  -0.391  1.00 48.02           O  
ATOM    621  CB  ASP A  88      -7.808  12.472  -1.696  1.00 48.83           C  
ATOM    622  N   GLY A  89      -8.589   9.939  -0.782  1.00 44.79           N  
ATOM    623  CA  GLY A  89      -9.120   8.745  -0.119  1.00 42.67           C  
ATOM    624  C   GLY A  89      -8.555   8.442   1.248  1.00 40.31           C  
ATOM    625  O   GLY A  89      -8.349   9.329   2.041  1.00 40.63           O  
ATOM    626  N   LEU A  90      -8.351   7.174   1.550  1.00 38.64           N  
ATOM    627  CA  LEU A  90      -7.940   6.756   2.893  1.00 36.47           C  
ATOM    628  C   LEU A  90      -7.310   5.391   2.840  1.00 33.68           C  
ATOM    629  O   LEU A  90      -7.772   4.593   2.107  1.00 32.77           O  
ATOM    630  CB  LEU A  90      -9.152   6.687   3.807  1.00 36.97           C  
ATOM    631  CG  LEU A  90      -8.846   6.336   5.274  1.00 38.27           C  
ATOM    632  CD1 LEU A  90      -8.603   7.565   6.027  1.00 39.67           C  
ATOM    633  CD2 LEU A  90      -9.957   5.601   5.850  1.00 39.94           C  
ATOM    634  N   VAL A  91      -6.259   5.157   3.627  1.00 31.83           N  
ATOM    635  CA  VAL A  91      -5.631   3.849   3.800  1.00 31.11           C  
ATOM    636  C   VAL A  91      -5.504   3.497   5.266  1.00 30.95           C  
ATOM    637  O   VAL A  91      -5.017   4.302   6.076  1.00 31.03           O  
ATOM    638  CB  VAL A  91      -4.236   3.805   3.152  1.00 31.55           C  
ATOM    639  CG1 VAL A  91      -3.662   2.396   3.161  1.00 30.60           C  
ATOM    640  CG2 VAL A  91      -4.314   4.324   1.703  1.00 31.00           C  
ATOM    641  N   PHE A  92      -5.974   2.313   5.649  1.00 31.02           N  
ATOM    642  CA  PHE A  92      -5.707   1.865   6.984  1.00 31.14           C  
ATOM    643  C   PHE A  92      -5.376   0.396   7.044  1.00 31.13           C  
ATOM    644  O   PHE A  92      -5.635  -0.334   6.112  1.00 32.08           O  
ATOM    645  CB  PHE A  92      -6.838   2.269   7.946  1.00 32.01           C  
ATOM    646  CG  PHE A  92      -8.110   1.435   7.845  1.00 33.44           C  
ATOM    647  CD1 PHE A  92      -8.177   0.167   8.410  1.00 34.68           C  
ATOM    648  CD2 PHE A  92      -9.246   1.947   7.229  1.00 35.08           C  
ATOM    649  CE1 PHE A  92      -9.320  -0.580   8.356  1.00 33.81           C  
ATOM    650  CE2 PHE A  92     -10.413   1.203   7.180  1.00 35.95           C  
ATOM    651  CZ  PHE A  92     -10.452  -0.055   7.754  1.00 36.06           C  
ATOM    652  N   THR A  93      -4.722  -0.002   8.120  1.00 31.16           N  
ATOM    653  CA  THR A  93      -4.519  -1.384   8.423  1.00 31.69           C  
ATOM    654  C   THR A  93      -5.121  -1.726   9.795  1.00 31.93           C  
ATOM    655  O   THR A  93      -5.371  -0.860  10.629  1.00 32.37           O  
ATOM    656  CB  THR A  93      -3.041  -1.754   8.492  1.00 31.51           C  
ATOM    657  OG1 THR A  93      -2.433  -1.017   9.562  1.00 31.04           O  
ATOM    658  CG2 THR A  93      -2.274  -1.375   7.249  1.00 31.61           C  
ATOM    659  N   ALA A  94      -5.280  -3.023  10.009  1.00 31.72           N  
ATOM    660  CA  ALA A  94      -5.861  -3.574  11.230  1.00 31.68           C  
ATOM    661  C   ALA A  94      -5.373  -5.034  11.361  1.00 31.35           C  
ATOM    662  O   ALA A  94      -5.072  -5.725  10.369  1.00 31.05           O  
ATOM    663  CB  ALA A  94      -7.382  -3.503  11.134  1.00 31.43           C  
ATOM    664  N   ASP A  95      -5.285  -5.491  12.579  1.00 31.26           N  
ATOM    665  CA  ASP A  95      -4.862  -6.848  12.850  1.00 32.29           C  
ATOM    666  C   ASP A  95      -6.064  -7.765  12.712  1.00 32.33           C  
ATOM    667  O   ASP A  95      -7.154  -7.462  13.197  1.00 32.37           O  
ATOM    668  CB  ASP A  95      -4.345  -6.953  14.265  1.00 31.82           C  
ATOM    669  CG  ASP A  95      -3.036  -6.225  14.447  1.00 35.40           C  
ATOM    670  OD1 ASP A  95      -2.110  -6.368  13.600  1.00 37.39           O  
ATOM    671  OD2 ASP A  95      -2.847  -5.453  15.412  1.00 41.43           O  
ATOM    672  N   VAL A  96      -5.863  -8.896  12.059  1.00 32.17           N  
ATOM    673  CA  VAL A  96      -6.902  -9.894  12.015  1.00 31.82           C  
ATOM    674  C   VAL A  96      -6.286 -11.238  12.239  1.00 31.68           C  
ATOM    675  O   VAL A  96      -5.072 -11.415  12.169  1.00 31.61           O  
ATOM    676  CB  VAL A  96      -7.690  -9.875  10.670  1.00 31.55           C  
ATOM    677  CG1 VAL A  96      -8.267  -8.520  10.393  1.00 30.18           C  
ATOM    678  CG2 VAL A  96      -6.805 -10.319   9.522  1.00 32.34           C  
ATOM    679  N   ASN A  97      -7.145 -12.192  12.549  1.00 31.99           N  
ATOM    680  CA  ASN A  97      -6.746 -13.558  12.700  1.00 32.13           C  
ATOM    681  C   ASN A  97      -7.389 -14.397  11.610  1.00 31.43           C  
ATOM    682  O   ASN A  97      -8.602 -14.566  11.572  1.00 30.40           O  
ATOM    683  CB  ASN A  97      -7.198 -14.048  14.047  1.00 33.18           C  
ATOM    684  CG  ASN A  97      -6.148 -14.778  14.725  1.00 39.70           C  
ATOM    685  OD1 ASN A  97      -5.133 -14.154  15.129  1.00 50.10           O  
ATOM    686  ND2 ASN A  97      -6.294 -16.120  14.826  1.00 43.30           N  
ATOM    687  N   VAL A  98      -6.564 -14.921  10.727  1.00 31.09           N  
ATOM    688  CA  VAL A  98      -7.032 -15.761   9.662  1.00 31.88           C  
ATOM    689  C   VAL A  98      -7.218 -17.175  10.171  1.00 32.47           C  
ATOM    690  O   VAL A  98      -6.360 -17.683  10.830  1.00 32.19           O  
ATOM    691  CB  VAL A  98      -6.040 -15.725   8.481  1.00 31.66           C  
ATOM    692  CG1 VAL A  98      -6.301 -16.827   7.483  1.00 32.87           C  
ATOM    693  CG2 VAL A  98      -6.120 -14.383   7.828  1.00 31.70           C  
ATOM    694  N   VAL A  99      -8.340 -17.807   9.846  1.00 34.08           N  
ATOM    695  CA  VAL A  99      -8.557 -19.204  10.211  1.00 35.92           C  
ATOM    696  C   VAL A  99      -8.318 -20.098   8.984  1.00 37.32           C  
ATOM    697  O   VAL A  99      -8.792 -19.783   7.891  1.00 37.51           O  
ATOM    698  CB  VAL A  99      -9.997 -19.395  10.756  1.00 36.33           C  
ATOM    699  CG1 VAL A  99     -10.259 -20.884  11.120  1.00 36.22           C  
ATOM    700  CG2 VAL A  99     -10.230 -18.467  11.957  1.00 36.35           C  
ATOM    701  N   LYS A 100      -7.573 -21.191   9.165  1.00 39.40           N  
ATOM    702  CA  LYS A 100      -7.198 -22.129   8.048  1.00 41.07           C  
ATOM    703  C   LYS A 100      -8.203 -23.235   7.696  1.00 40.62           C  
ATOM    704  O   LYS A 100      -8.539 -24.061   8.526  1.00 40.30           O  
ATOM    705  CB  LYS A 100      -5.830 -22.771   8.326  1.00 41.69           C  
ATOM    706  CG  LYS A 100      -4.705 -21.727   8.404  1.00 44.88           C  
ATOM    707  CD  LYS A 100      -4.776 -20.695   7.228  1.00 48.43           C  
ATOM    708  CE  LYS A 100      -3.380 -20.148   6.842  1.00 49.78           C  
ATOM    709  NZ  LYS A 100      -2.498 -21.310   6.389  1.00 49.53           N  
TER     710      LYS A 100                                                      
END
MOLECULE T0437.pdb
ATOM    365  N   ASP    24      -1.217  -3.430  12.771  1.00 32.15           N  
ATOM    366  CA  ASP    24      -2.558  -3.784  13.227  1.00 11.24           C  
ATOM    367  C   ASP    24      -3.077  -4.985  12.447  1.00  3.52           C  
ATOM    368  O   ASP    24      -3.558  -5.955  13.031  1.00 72.30           O  
ATOM    369  CB  ASP    24      -3.550  -2.622  13.081  1.00 55.51           C  
ATOM    370  CG  ASP    24      -4.808  -2.840  13.907  1.00 50.34           C  
ATOM    371  OD1 ASP    24      -4.721  -2.781  15.153  1.00 45.42           O  
ATOM    372  OD2 ASP    24      -5.894  -3.051  13.323  1.00 64.32           O  
ATOM    373  H   ASP    24      -0.799  -3.973  12.068  1.00 54.01           H  
ATOM    374  HA  ASP    24      -2.484  -4.056  14.271  1.00 33.12           H  
ATOM    375  HB2 ASP    24      -3.078  -1.707  13.409  1.00 36.92           H  
ATOM    376  HB3 ASP    24      -3.834  -2.526  12.043  1.00 36.92           H  
ATOM    377  N   ASN    25      -2.962  -4.924  11.121  1.00 30.54           N  
ATOM    378  CA  ASN    25      -3.508  -5.964  10.256  1.00 13.41           C  
ATOM    379  C   ASN    25      -2.460  -6.507   9.295  1.00 63.53           C  
ATOM    380  O   ASN    25      -1.296  -6.099   9.311  1.00 14.31           O  
ATOM    381  CB  ASN    25      -4.679  -5.420   9.426  1.00 24.42           C  
ATOM    382  CG  ASN    25      -5.829  -4.927  10.269  1.00 32.35           C  
ATOM    383  OD1 ASN    25      -6.706  -5.697  10.646  1.00 43.01           O  
ATOM    384  ND2 ASN    25      -5.853  -3.633  10.534  1.00 44.23           N  
ATOM    385  H   ASN    25      -2.501  -4.158  10.709  1.00 41.11           H  
ATOM    386  HA  ASN    25      -3.864  -6.769  10.879  1.00 52.21           H  
ATOM    387  HB2 ASN    25      -4.327  -4.598   8.822  1.00 36.92           H  
ATOM    388  HB3 ASN    25      -5.043  -6.204   8.776  1.00 36.92           H  
ATOM    389 HD21 ASN    25      -5.133  -3.072  10.171  1.00 36.92           H  
ATOM    390 HD22 ASN    25      -6.577  -3.287  11.100  1.00 36.92           H  
ATOM    391  N   CYS    26      -2.899  -7.447   8.473  1.00 31.24           N  
ATOM    392  CA  CYS    26      -2.129  -7.926   7.338  1.00 12.34           C  
ATOM    393  C   CYS    26      -2.935  -7.685   6.063  1.00 73.22           C  
ATOM    394  O   CYS    26      -2.415  -7.757   4.950  1.00 24.23           O  
ATOM    395  CB  CYS    26      -1.796  -9.411   7.499  1.00 72.14           C  
ATOM    396  SG  CYS    26      -3.233 -10.466   7.786  1.00  1.02           S  
ATOM    397  H   CYS    26      -3.780  -7.844   8.643  1.00 23.14           H  
ATOM    398  HA  CYS    26      -1.212  -7.355   7.290  1.00 54.15           H  
ATOM    399  HB2 CYS    26      -1.310  -9.763   6.603  1.00 36.92           H  
ATOM    400  HB3 CYS    26      -1.127  -9.535   8.338  1.00 36.92           H  
ATOM    401  HG  CYS    26      -2.885 -11.712   7.486  1.00 33.31           H  
ATOM    402  N   THR    27      -4.221  -7.404   6.252  1.00  2.42           N  
ATOM    403  CA  THR    27      -5.103  -7.020   5.167  1.00 14.14           C  
ATOM    404  C   THR    27      -5.241  -5.501   5.133  1.00 42.33           C  
ATOM    405  O   THR    27      -5.709  -4.893   6.102  1.00 22.32           O  
ATOM    406  CB  THR    27      -6.496  -7.663   5.341  1.00 43.41           C  
ATOM    407  OG1 THR    27      -6.380  -9.092   5.329  1.00  1.24           O  
ATOM    408  CG2 THR    27      -7.455  -7.221   4.244  1.00  1.25           C  
ATOM    409  H   THR    27      -4.589  -7.460   7.160  1.00 62.31           H  
ATOM    410  HA  THR    27      -4.674  -7.363   4.237  1.00 23.45           H  
ATOM    411  HB  THR    27      -6.899  -7.353   6.294  1.00 23.25           H  
ATOM    412  HG1 THR    27      -6.285  -9.415   6.235  1.00 70.53           H  
ATOM    413 HG21 THR    27      -8.407  -7.714   4.375  1.00 36.92           H  
ATOM    414 HG22 THR    27      -7.044  -7.482   3.280  1.00 36.92           H  
ATOM    415 HG23 THR    27      -7.593  -6.151   4.298  1.00 36.92           H  
ATOM    416  N   SER    28      -4.839  -4.888   4.027  1.00 33.44           N  
ATOM    417  CA  SER    28      -4.883  -3.439   3.911  1.00 41.41           C  
ATOM    418  C   SER    28      -6.138  -3.018   3.169  1.00  3.25           C  
ATOM    419  O   SER    28      -6.628  -3.746   2.308  1.00  4.43           O  
ATOM    420  CB  SER    28      -3.645  -2.908   3.181  1.00 70.44           C  
ATOM    421  OG  SER    28      -3.551  -1.502   3.323  1.00  3.01           O  
ATOM    422  H   SER    28      -4.524  -5.424   3.263  1.00 11.31           H  
ATOM    423  HA  SER    28      -4.911  -3.026   4.909  1.00 33.32           H  
ATOM    424  HB2 SER    28      -2.757  -3.363   3.593  1.00 36.92           H  
ATOM    425  HB3 SER    28      -3.718  -3.149   2.130  1.00 36.92           H  
ATOM    426  HG  SER    28      -2.992  -1.130   2.615  1.00  3.41           H  
ATOM    427  N   LYS    29      -6.662  -1.853   3.509  1.00 34.41           N  
ATOM    428  CA  LYS    29      -7.877  -1.356   2.890  1.00 11.21           C  
ATOM    429  C   LYS    29      -7.593  -0.009   2.265  1.00 12.41           C  
ATOM    430  O   LYS    29      -7.319   0.971   2.962  1.00 14.44           O  
ATOM    431  CB  LYS    29      -9.024  -1.202   3.893  1.00 31.01           C  
ATOM    432  CG  LYS    29      -9.044  -2.231   5.007  1.00 24.44           C  
ATOM    433  CD  LYS    29      -8.016  -1.879   6.067  1.00 42.42           C  
ATOM    434  CE  LYS    29      -8.275  -2.586   7.387  1.00 72.54           C  
ATOM    435  NZ  LYS    29      -8.114  -4.060   7.277  1.00 24.34           N  
ATOM    436  H   LYS    29      -6.209  -1.302   4.180  1.00  5.13           H  
ATOM    437  HA  LYS    29      -8.168  -2.052   2.115  1.00 14.03           H  
ATOM    438  HB2 LYS    29      -8.955  -0.226   4.347  1.00 36.92           H  
ATOM    439  HB3 LYS    29      -9.961  -1.269   3.359  1.00 36.92           H  
ATOM    440  HG2 LYS    29     -10.025  -2.248   5.451  1.00 36.92           H  
ATOM    441  HG3 LYS    29      -8.811  -3.204   4.597  1.00 36.92           H  
ATOM    442  HD2 LYS    29      -7.038  -2.166   5.706  1.00 36.92           H  
ATOM    443  HD3 LYS    29      -8.040  -0.811   6.215  1.00 36.92           H  
ATOM    444  HE2 LYS    29      -7.580  -2.212   8.123  1.00 36.92           H  
ATOM    445  HE3 LYS    29      -9.284  -2.365   7.704  1.00 36.92           H  
ATOM    446  HZ1 LYS    29      -7.150  -4.297   6.962  1.00 36.92           H  
ATOM    447  HZ2 LYS    29      -8.798  -4.448   6.588  1.00 36.92           H  
ATOM    448  HZ3 LYS    29      -8.288  -4.508   8.205  1.00 36.92           H  
ATOM    449  N   PHE    30      -7.655   0.034   0.964  1.00 52.14           N  
ATOM    450  CA  PHE    30      -7.342   1.246   0.228  1.00 74.42           C  
ATOM    451  C   PHE    30      -8.617   1.916  -0.259  1.00 75.21           C  
ATOM    452  O   PHE    30      -9.343   1.360  -1.081  1.00  2.21           O  
ATOM    453  CB  PHE    30      -6.425   0.925  -0.957  1.00 63.54           C  
ATOM    454  CG  PHE    30      -6.093   2.118  -1.810  1.00 64.50           C  
ATOM    455  CD1 PHE    30      -5.122   3.024  -1.413  1.00 43.31           C  
ATOM    456  CD2 PHE    30      -6.755   2.335  -3.009  1.00 42.02           C  
ATOM    457  CE1 PHE    30      -4.818   4.122  -2.194  1.00 25.13           C  
ATOM    458  CE2 PHE    30      -6.455   3.432  -3.794  1.00 72.40           C  
ATOM    459  CZ  PHE    30      -5.485   4.326  -3.386  1.00 61.32           C  
ATOM    460  H   PHE    30      -7.942  -0.770   0.485  1.00 44.02           H  
ATOM    461  HA  PHE    30      -6.829   1.918   0.898  1.00 62.01           H  
ATOM    462  HB2 PHE    30      -5.497   0.518  -0.584  1.00 36.92           H  
ATOM    463  HB3 PHE    30      -6.907   0.189  -1.585  1.00 36.92           H  
ATOM    464  HD1 PHE    30      -4.599   2.867  -0.481  1.00 63.41           H  
ATOM    465  HD2 PHE    30      -7.516   1.637  -3.329  1.00  2.43           H  
ATOM    466  HE1 PHE    30      -4.059   4.820  -1.873  1.00 51.40           H  
ATOM    467  HE2 PHE    30      -6.977   3.588  -4.726  1.00  0.03           H  
ATOM    468  HZ  PHE    30      -5.250   5.185  -3.999  1.00 35.04           H  
ATOM    469  N   SER    31      -8.867   3.118   0.237  1.00 74.32           N  
ATOM    470  CA  SER    31     -10.047   3.876  -0.141  1.00 73.15           C  
ATOM    471  C   SER    31      -9.680   5.137  -0.908  1.00 74.03           C  
ATOM    472  O   SER    31      -8.747   5.860  -0.543  1.00  5.31           O  
ATOM    473  CB  SER    31     -10.858   4.239   1.103  1.00  0.34           C  
ATOM    474  OG  SER    31     -10.003   4.439   2.220  1.00 44.25           O  
ATOM    475  H   SER    31      -8.253   3.498   0.892  1.00 63.34           H  
ATOM    476  HA  SER    31     -10.652   3.249  -0.778  1.00 42.22           H  
ATOM    477  HB2 SER    31     -11.401   5.154   0.916  1.00 36.92           H  
ATOM    478  HB3 SER    31     -11.556   3.446   1.328  1.00 36.92           H  
ATOM    479  HG  SER    31     -10.076   3.677   2.815  1.00 62.22           H  
ATOM    480  N   ARG    32     -10.409   5.372  -1.982  1.00 34.33           N  
ATOM    481  CA  ARG    32     -10.290   6.587  -2.767  1.00 13.22           C  
ATOM    482  C   ARG    32     -11.656   6.967  -3.312  1.00 30.12           C  
ATOM    483  O   ARG    32     -12.485   6.098  -3.590  1.00  1.53           O  
ATOM    484  CB  ARG    32      -9.293   6.400  -3.914  1.00 72.21           C  
ATOM    485  CG  ARG    32      -7.900   6.946  -3.627  1.00 15.03           C  
ATOM    486  CD  ARG    32      -7.783   8.424  -3.980  1.00 21.11           C  
ATOM    487  NE  ARG    32      -8.659   9.273  -3.169  1.00 34.31           N  
ATOM    488  CZ  ARG    32      -9.089  10.477  -3.550  1.00 74.52           C  
ATOM    489  NH1 ARG    32      -8.702  10.996  -4.708  1.00 22.20           N  
ATOM    490  NH2 ARG    32      -9.890  11.175  -2.752  1.00 10.25           N  
ATOM    491  H   ARG    32     -11.061   4.688  -2.268  1.00 61.53           H  
ATOM    492  HA  ARG    32      -9.940   7.373  -2.115  1.00 13.20           H  
ATOM    493  HB2 ARG    32      -9.204   5.346  -4.123  1.00 36.92           H  
ATOM    494  HB3 ARG    32      -9.677   6.898  -4.791  1.00 36.92           H  
ATOM    495  HG2 ARG    32      -7.683   6.821  -2.577  1.00 36.92           H  
ATOM    496  HG3 ARG    32      -7.182   6.390  -4.211  1.00 36.92           H  
ATOM    497  HD2 ARG    32      -6.759   8.734  -3.827  1.00 36.92           H  
ATOM    498  HD3 ARG    32      -8.040   8.550  -5.021  1.00 36.92           H  
ATOM    499  HE  ARG    32      -8.933   8.926  -2.287  1.00 22.31           H  
ATOM    500 HH11 ARG    32      -8.075  10.485  -5.314  1.00 36.92           H  
ATOM    501 HH12 ARG    32      -9.017  11.913  -4.987  1.00 36.92           H  
ATOM    502 HH21 ARG    32     -10.166  10.801  -1.861  1.00 36.92           H  
ATOM    503 HH22 ARG    32     -10.226  12.085  -3.037  1.00 36.92           H  
ATOM    504  N   PHE    33     -11.893   8.257  -3.446  1.00 12.54           N  
ATOM    505  CA  PHE    33     -13.175   8.746  -3.916  1.00 11.05           C  
ATOM    506  C   PHE    33     -13.030   9.297  -5.322  1.00 55.33           C  
ATOM    507  O   PHE    33     -12.193  10.165  -5.578  1.00 62.12           O  
ATOM    508  CB  PHE    33     -13.716   9.827  -2.977  1.00  2.45           C  
ATOM    509  CG  PHE    33     -13.665   9.442  -1.522  1.00  1.40           C  
ATOM    510  CD1 PHE    33     -14.492   8.449  -1.023  1.00  3.52           C  
ATOM    511  CD2 PHE    33     -12.783  10.069  -0.656  1.00 73.01           C  
ATOM    512  CE1 PHE    33     -14.440   8.090   0.312  1.00 11.30           C  
ATOM    513  CE2 PHE    33     -12.728   9.714   0.678  1.00 34.42           C  
ATOM    514  CZ  PHE    33     -13.558   8.724   1.163  1.00 42.15           C  
ATOM    515  H   PHE    33     -11.185   8.898  -3.238  1.00 14.11           H  
ATOM    516  HA  PHE    33     -13.864   7.914  -3.934  1.00 32.42           H  
ATOM    517  HB2 PHE    33     -13.137  10.726  -3.104  1.00 36.92           H  
ATOM    518  HB3 PHE    33     -14.747  10.029  -3.231  1.00 36.92           H  
ATOM    519  HD1 PHE    33     -15.183   7.953  -1.687  1.00 41.41           H  
ATOM    520  HD2 PHE    33     -12.132  10.845  -1.031  1.00 72.44           H  
ATOM    521  HE1 PHE    33     -15.091   7.314   0.688  1.00 12.34           H  
ATOM    522  HE2 PHE    33     -12.035  10.211   1.343  1.00 62.42           H  
ATOM    523  HZ  PHE    33     -13.517   8.446   2.206  1.00  5.22           H  
ATOM    524  N   PHE    34     -13.832   8.783  -6.232  1.00 32.11           N  
ATOM    525  CA  PHE    34     -13.750   9.181  -7.627  1.00  1.22           C  
ATOM    526  C   PHE    34     -15.068   9.782  -8.075  1.00 23.44           C  
ATOM    527  O   PHE    34     -16.074   9.649  -7.383  1.00 51.45           O  
ATOM    528  CB  PHE    34     -13.392   7.981  -8.498  1.00 31.22           C  
ATOM    529  CG  PHE    34     -12.063   7.371  -8.150  1.00 51.33           C  
ATOM    530  CD1 PHE    34     -10.884   7.944  -8.604  1.00 14.42           C  
ATOM    531  CD2 PHE    34     -11.993   6.229  -7.369  1.00 64.14           C  
ATOM    532  CE1 PHE    34      -9.662   7.387  -8.285  1.00  2.41           C  
ATOM    533  CE2 PHE    34     -10.772   5.669  -7.048  1.00 51.32           C  
ATOM    534  CZ  PHE    34      -9.606   6.249  -7.506  1.00 32.24           C  
ATOM    535  H   PHE    34     -14.509   8.124  -5.958  1.00  3.15           H  
ATOM    536  HA  PHE    34     -12.975   9.926  -7.719  1.00 13.43           H  
ATOM    537  HB2 PHE    34     -14.152   7.221  -8.382  1.00 36.92           H  
ATOM    538  HB3 PHE    34     -13.356   8.293  -9.532  1.00 36.92           H  
ATOM    539  HD1 PHE    34     -10.927   8.836  -9.212  1.00 23.34           H  
ATOM    540  HD2 PHE    34     -12.904   5.776  -7.008  1.00 55.40           H  
ATOM    541  HE1 PHE    34      -8.750   7.841  -8.645  1.00  4.21           H  
ATOM    542  HE2 PHE    34     -10.728   4.778  -6.438  1.00 43.52           H  
ATOM    543  HZ  PHE    34      -8.651   5.811  -7.258  1.00 60.55           H  
ATOM    544  N   ALA    35     -15.059  10.445  -9.223  1.00 41.43           N  
ATOM    545  CA  ALA    35     -16.262  11.091  -9.739  1.00 35.44           C  
ATOM    546  C   ALA    35     -17.209  10.081 -10.376  1.00 12.23           C  
ATOM    547  O   ALA    35     -18.426  10.269 -10.368  1.00  3.53           O  
ATOM    548  CB  ALA    35     -15.895  12.179 -10.734  1.00 10.24           C  
ATOM    549  H   ALA    35     -14.222  10.509  -9.734  1.00 32.10           H  
ATOM    550  HA  ALA    35     -16.766  11.557  -8.907  1.00 65.13           H  
ATOM    551  HB1 ALA    35     -16.787  12.711 -11.032  1.00 36.92           H  
ATOM    552  HB2 ALA    35     -15.435  11.733 -11.604  1.00 36.92           H  
ATOM    553  HB3 ALA    35     -15.203  12.867 -10.274  1.00 36.92           H  
ATOM    554  N   THR    36     -16.655   9.015 -10.931  1.00 23.34           N  
ATOM    555  CA  THR    36     -17.470   7.980 -11.544  1.00 51.01           C  
ATOM    556  C   THR    36     -17.045   6.607 -11.049  1.00 43.30           C  
ATOM    557  O   THR    36     -15.901   6.418 -10.624  1.00  5.14           O  
ATOM    558  CB  THR    36     -17.358   7.997 -13.082  1.00 13.34           C  
ATOM    559  OG1 THR    36     -15.991   7.818 -13.472  1.00 31.33           O  
ATOM    560  CG2 THR    36     -17.895   9.295 -13.669  1.00 12.13           C  
ATOM    561  H   THR    36     -15.680   8.919 -10.930  1.00 11.05           H  
ATOM    562  HA  THR    36     -18.500   8.153 -11.272  1.00 24.33           H  
ATOM    563  HB  THR    36     -17.942   7.177 -13.475  1.00 62.24           H  
ATOM    564  HG1 THR    36     -15.774   8.439 -14.184  1.00 51.32           H  
ATOM    565 HG21 THR    36     -17.783   9.276 -14.743  1.00 36.92           H  
ATOM    566 HG22 THR    36     -17.341  10.129 -13.264  1.00 36.92           H  
ATOM    567 HG23 THR    36     -18.940   9.401 -13.417  1.00 36.92           H  
ATOM    568  N   ARG    37     -17.964   5.653 -11.105  1.00  3.51           N  
ATOM    569  CA  ARG    37     -17.648   4.269 -10.789  1.00 24.40           C  
ATOM    570  C   ARG    37     -16.613   3.737 -11.780  1.00 72.31           C  
ATOM    571  O   ARG    37     -15.833   2.837 -11.462  1.00 55.35           O  
ATOM    572  CB  ARG    37     -18.924   3.422 -10.804  1.00  2.52           C  
ATOM    573  CG  ARG    37     -18.675   1.925 -10.730  1.00 45.12           C  
ATOM    574  CD  ARG    37     -19.979   1.152 -10.685  1.00 43.11           C  
ATOM    575  NE  ARG    37     -19.758  -0.288 -10.589  1.00 74.04           N  
ATOM    576  CZ  ARG    37     -20.451  -1.088  -9.782  1.00 42.35           C  
ATOM    577  NH1 ARG    37     -21.353  -0.577  -8.950  1.00 25.52           N  
ATOM    578  NH2 ARG    37     -20.229  -2.397  -9.786  1.00 54.14           N  
ATOM    579  H   ARG    37     -18.888   5.891 -11.359  1.00 10.41           H  
ATOM    580  HA  ARG    37     -17.221   4.246  -9.796  1.00 21.43           H  
ATOM    581  HB2 ARG    37     -19.530   3.702  -9.955  1.00 36.92           H  
ATOM    582  HB3 ARG    37     -19.475   3.632 -11.707  1.00 36.92           H  
ATOM    583  HG2 ARG    37     -18.115   1.618 -11.601  1.00 36.92           H  
ATOM    584  HG3 ARG    37     -18.105   1.708  -9.837  1.00 36.92           H  
ATOM    585  HD2 ARG    37     -20.547   1.477  -9.825  1.00 36.92           H  
ATOM    586  HD3 ARG    37     -20.539   1.362 -11.585  1.00 36.92           H  
ATOM    587  HE  ARG    37     -19.061  -0.678 -11.172  1.00 14.05           H  
ATOM    588 HH11 ARG    37     -21.521   0.418  -8.927  1.00 36.92           H  
ATOM    589 HH12 ARG    37     -21.866  -1.180  -8.329  1.00 36.92           H  
ATOM    590 HH21 ARG    37     -19.533  -2.794 -10.399  1.00 36.92           H  
ATOM    591 HH22 ARG    37     -20.769  -3.002  -9.183  1.00 36.92           H  
ATOM    592  N   GLU    38     -16.602   4.325 -12.973  1.00 14.40           N  
ATOM    593  CA  GLU    38     -15.581   4.032 -13.969  1.00 15.45           C  
ATOM    594  C   GLU    38     -14.200   4.347 -13.421  1.00  3.11           C  
ATOM    595  O   GLU    38     -13.309   3.502 -13.439  1.00 72.21           O  
ATOM    596  CB  GLU    38     -15.814   4.858 -15.223  1.00 64.21           C  
ATOM    597  CG  GLU    38     -17.079   4.500 -15.969  1.00 62.14           C  
ATOM    598  CD  GLU    38     -17.275   5.367 -17.191  1.00  2.33           C  
ATOM    599  OE1 GLU    38     -16.436   5.296 -18.114  1.00 74.31           O  
ATOM    600  OE2 GLU    38     -18.261   6.124 -17.232  1.00  2.14           O  
ATOM    601  H   GLU    38     -17.302   4.974 -13.190  1.00 42.23           H  
ATOM    602  HA  GLU    38     -15.637   2.983 -14.216  1.00 33.10           H  
ATOM    603  HB2 GLU    38     -15.869   5.901 -14.947  1.00 36.92           H  
ATOM    604  HB3 GLU    38     -14.977   4.716 -15.886  1.00 36.92           H  
ATOM    605  HG2 GLU    38     -17.018   3.468 -16.277  1.00 36.92           H  
ATOM    606  HG3 GLU    38     -17.923   4.632 -15.308  1.00 36.92           H  
ATOM    607  N   GLU    39     -14.041   5.573 -12.934  1.00 32.12           N  
ATOM    608  CA  GLU    39     -12.795   6.019 -12.318  1.00 42.12           C  
ATOM    609  C   GLU    39     -12.352   5.058 -11.220  1.00 31.43           C  
ATOM    610  O   GLU    39     -11.159   4.832 -11.022  1.00  2.11           O  
ATOM    611  CB  GLU    39     -12.987   7.417 -11.730  1.00 35.53           C  
ATOM    612  CG  GLU    39     -13.006   8.527 -12.761  1.00  1.50           C  
ATOM    613  CD  GLU    39     -11.630   8.822 -13.316  1.00 55.23           C  
ATOM    614  OE1 GLU    39     -10.892   9.612 -12.684  1.00 51.31           O  
ATOM    615  OE2 GLU    39     -11.276   8.263 -14.372  1.00 14.10           O  
ATOM    616  H   GLU    39     -14.791   6.208 -13.000  1.00 33.31           H  
ATOM    617  HA  GLU    39     -12.034   6.056 -13.082  1.00 32.33           H  
ATOM    618  HB2 GLU    39     -13.926   7.438 -11.199  1.00 36.92           H  
ATOM    619  HB3 GLU    39     -12.187   7.615 -11.033  1.00 36.92           H  
ATOM    620  HG2 GLU    39     -13.654   8.234 -13.574  1.00 36.92           H  
ATOM    621  HG3 GLU    39     -13.394   9.422 -12.299  1.00 36.92           H  
ATOM    622  N   ALA    40     -13.324   4.482 -10.528  1.00 15.32           N  
ATOM    623  CA  ALA    40     -13.043   3.557  -9.439  1.00 54.43           C  
ATOM    624  C   ALA    40     -12.469   2.248  -9.972  1.00 33.33           C  
ATOM    625  O   ALA    40     -11.409   1.798  -9.538  1.00 20.01           O  
ATOM    626  CB  ALA    40     -14.303   3.297  -8.623  1.00 33.21           C  
ATOM    627  H   ALA    40     -14.257   4.677 -10.764  1.00 53.43           H  
ATOM    628  HA  ALA    40     -12.314   4.019  -8.790  1.00 31.22           H  
ATOM    629  HB1 ALA    40     -14.059   2.683  -7.769  1.00 36.92           H  
ATOM    630  HB2 ALA    40     -15.028   2.785  -9.238  1.00 36.92           H  
ATOM    631  HB3 ALA    40     -14.717   4.237  -8.286  1.00 36.92           H  
ATOM    632  N   GLU    41     -13.162   1.653 -10.936  1.00  4.00           N  
ATOM    633  CA  GLU    41     -12.741   0.377 -11.503  1.00 73.11           C  
ATOM    634  C   GLU    41     -11.495   0.533 -12.376  1.00 44.42           C  
ATOM    635  O   GLU    41     -10.745  -0.423 -12.575  1.00 62.40           O  
ATOM    636  CB  GLU    41     -13.883  -0.252 -12.302  1.00 43.42           C  
ATOM    637  CG  GLU    41     -15.061  -0.668 -11.435  1.00 63.32           C  
ATOM    638  CD  GLU    41     -16.138  -1.406 -12.204  1.00 13.55           C  
ATOM    639  OE1 GLU    41     -15.808  -2.379 -12.914  1.00 13.40           O  
ATOM    640  OE2 GLU    41     -17.327  -1.038 -12.081  1.00 14.30           O  
ATOM    641  H   GLU    41     -13.981   2.081 -11.273  1.00 13.32           H  
ATOM    642  HA  GLU    41     -12.497  -0.277 -10.678  1.00 33.21           H  
ATOM    643  HB2 GLU    41     -14.232   0.465 -13.032  1.00 36.92           H  
ATOM    644  HB3 GLU    41     -13.512  -1.126 -12.816  1.00 36.92           H  
ATOM    645  HG2 GLU    41     -14.699  -1.315 -10.649  1.00 36.92           H  
ATOM    646  HG3 GLU    41     -15.497   0.217 -10.995  1.00 36.92           H  
ATOM    647  N   SER    42     -11.275   1.736 -12.892  1.00 34.34           N  
ATOM    648  CA  SER    42     -10.074   2.024 -13.663  1.00 34.54           C  
ATOM    649  C   SER    42      -8.859   2.061 -12.751  1.00 64.54           C  
ATOM    650  O   SER    42      -7.767   1.645 -13.137  1.00 33.55           O  
ATOM    651  CB  SER    42     -10.219   3.357 -14.404  1.00 12.41           C  
ATOM    652  OG  SER    42     -11.356   3.351 -15.251  1.00 45.13           O  
ATOM    653  H   SER    42     -11.942   2.446 -12.757  1.00 63.32           H  
ATOM    654  HA  SER    42      -9.937   1.231 -14.382  1.00 60.43           H  
ATOM    655  HB2 SER    42     -10.328   4.156 -13.684  1.00 36.92           H  
ATOM    656  HB3 SER    42      -9.337   3.532 -15.003  1.00 36.92           H  
ATOM    657  HG  SER    42     -12.155   3.246 -14.716  1.00 51.21           H  
ATOM    658  N   PHE    43      -9.057   2.529 -11.527  1.00 72.54           N  
ATOM    659  CA  PHE    43      -7.965   2.627 -10.579  1.00  3.13           C  
ATOM    660  C   PHE    43      -7.646   1.244 -10.019  1.00 34.22           C  
ATOM    661  O   PHE    43      -6.511   0.960  -9.641  1.00 30.41           O  
ATOM    662  CB  PHE    43      -8.327   3.597  -9.455  1.00 41.13           C  
ATOM    663  CG  PHE    43      -7.139   4.284  -8.845  1.00 43.32           C  
ATOM    664  CD1 PHE    43      -6.541   5.354  -9.492  1.00 15.11           C  
ATOM    665  CD2 PHE    43      -6.620   3.867  -7.632  1.00 40.35           C  
ATOM    666  CE1 PHE    43      -5.449   5.993  -8.941  1.00 43.32           C  
ATOM    667  CE2 PHE    43      -5.527   4.502  -7.075  1.00 52.15           C  
ATOM    668  CZ  PHE    43      -4.941   5.567  -7.731  1.00 35.31           C  
ATOM    669  H   PHE    43      -9.959   2.816 -11.256  1.00 63.33           H  
ATOM    670  HA  PHE    43      -7.100   3.000 -11.108  1.00 64.25           H  
ATOM    671  HB2 PHE    43      -8.987   4.357  -9.845  1.00 36.92           H  
ATOM    672  HB3 PHE    43      -8.834   3.052  -8.673  1.00 36.92           H  
ATOM    673  HD1 PHE    43      -6.940   5.687 -10.439  1.00 53.12           H  
ATOM    674  HD2 PHE    43      -7.077   3.034  -7.119  1.00 22.22           H  
ATOM    675  HE1 PHE    43      -4.993   6.827  -9.456  1.00  1.35           H  
ATOM    676  HE2 PHE    43      -5.132   4.169  -6.128  1.00 43.32           H  
ATOM    677  HZ  PHE    43      -4.086   6.065  -7.297  1.00 63.25           H  
ATOM    678  N   MET    44      -8.658   0.381 -10.000  1.00 62.50           N  
ATOM    679  CA  MET    44      -8.496  -0.995  -9.543  1.00 13.32           C  
ATOM    680  C   MET    44      -7.478  -1.733 -10.408  1.00 73.33           C  
ATOM    681  O   MET    44      -6.744  -2.594  -9.923  1.00 61.20           O  
ATOM    682  CB  MET    44      -9.843  -1.727  -9.572  1.00  3.31           C  
ATOM    683  CG  MET    44      -9.766  -3.179  -9.123  1.00 73.12           C  
ATOM    684  SD  MET    44      -9.170  -3.356  -7.431  1.00 23.22           S  
ATOM    685  CE  MET    44     -10.369  -2.359  -6.551  1.00 71.13           C  
ATOM    686  H   MET    44      -9.542   0.682 -10.297  1.00 71.24           H  
ATOM    687  HA  MET    44      -8.133  -0.967  -8.526  1.00 13.31           H  
ATOM    688  HB2 MET    44     -10.533  -1.209  -8.923  1.00 36.92           H  
ATOM    689  HB3 MET    44     -10.228  -1.706 -10.581  1.00 36.92           H  
ATOM    690  HG2 MET    44     -10.752  -3.616  -9.187  1.00 36.92           H  
ATOM    691  HG3 MET    44      -9.096  -3.709  -9.783  1.00 36.92           H  
ATOM    692  HE1 MET    44     -11.361  -2.737  -6.749  1.00 36.92           H  
ATOM    693  HE2 MET    44     -10.300  -1.334  -6.884  1.00 36.92           H  
ATOM    694  HE3 MET    44     -10.170  -2.407  -5.490  1.00 36.92           H  
ATOM    695  N   THR    45      -7.432  -1.375 -11.688  1.00 65.23           N  
ATOM    696  CA  THR    45      -6.485  -1.970 -12.619  1.00 31.31           C  
ATOM    697  C   THR    45      -5.052  -1.838 -12.108  1.00 32.21           C  
ATOM    698  O   THR    45      -4.336  -2.832 -11.983  1.00 30.05           O  
ATOM    699  CB  THR    45      -6.586  -1.312 -14.008  1.00 73.30           C  
ATOM    700  OG1 THR    45      -7.941  -1.362 -14.475  1.00 22.51           O  
ATOM    701  CG2 THR    45      -5.673  -2.011 -15.006  1.00 62.31           C  
ATOM    702  H   THR    45      -8.058  -0.697 -12.017  1.00 71.11           H  
ATOM    703  HA  THR    45      -6.728  -3.019 -12.720  1.00 45.11           H  
ATOM    704  HB  THR    45      -6.279  -0.279 -13.922  1.00 71.42           H  
ATOM    705  HG1 THR    45      -8.215  -0.480 -14.749  1.00 14.35           H  
ATOM    706 HG21 THR    45      -4.653  -1.955 -14.659  1.00 36.92           H  
ATOM    707 HG22 THR    45      -5.752  -1.528 -15.970  1.00 36.92           H  
ATOM    708 HG23 THR    45      -5.966  -3.046 -15.098  1.00 36.92           H  
ATOM    709  N   LYS    46      -4.647  -0.613 -11.785  1.00 43.41           N  
ATOM    710  CA  LYS    46      -3.278  -0.371 -11.342  1.00 13.22           C  
ATOM    711  C   LYS    46      -3.031  -0.946  -9.949  1.00 74.13           C  
ATOM    712  O   LYS    46      -1.901  -1.290  -9.606  1.00 74.50           O  
ATOM    713  CB  LYS    46      -2.906   1.110 -11.431  1.00 20.52           C  
ATOM    714  CG  LYS    46      -3.828   2.057 -10.694  1.00 45.41           C  
ATOM    715  CD  LYS    46      -3.570   3.491 -11.125  1.00 65.20           C  
ATOM    716  CE  LYS    46      -2.105   3.875 -10.961  1.00 50.24           C  
ATOM    717  NZ  LYS    46      -1.766   5.128 -11.692  1.00 65.40           N  
ATOM    718  H   LYS    46      -5.281   0.136 -11.841  1.00 25.43           H  
ATOM    719  HA  LYS    46      -2.641  -0.905 -12.026  1.00 53.31           H  
ATOM    720  HB2 LYS    46      -1.913   1.236 -11.029  1.00 36.92           H  
ATOM    721  HB3 LYS    46      -2.896   1.396 -12.473  1.00 36.92           H  
ATOM    722  HG2 LYS    46      -4.854   1.800 -10.918  1.00 36.92           H  
ATOM    723  HG3 LYS    46      -3.653   1.970  -9.633  1.00 36.92           H  
ATOM    724  HD2 LYS    46      -3.848   3.603 -12.162  1.00 36.92           H  
ATOM    725  HD3 LYS    46      -4.172   4.140 -10.519  1.00 36.92           H  
ATOM    726  HE2 LYS    46      -1.899   4.017  -9.911  1.00 36.92           H  
ATOM    727  HE3 LYS    46      -1.494   3.072 -11.341  1.00 36.92           H  
ATOM    728  HZ1 LYS    46      -2.261   5.946 -11.272  1.00 36.92           H  
ATOM    729  HZ2 LYS    46      -2.047   5.046 -12.693  1.00 36.92           H  
ATOM    730  HZ3 LYS    46      -0.738   5.300 -11.654  1.00 36.92           H  
ATOM    731  N   LEU    47      -4.086  -1.053  -9.150  1.00 74.23           N  
ATOM    732  CA  LEU    47      -3.993  -1.742  -7.866  1.00 35.22           C  
ATOM    733  C   LEU    47      -3.630  -3.211  -8.078  1.00 13.01           C  
ATOM    734  O   LEU    47      -2.806  -3.759  -7.352  1.00 61.51           O  
ATOM    735  CB  LEU    47      -5.308  -1.629  -7.083  1.00 13.51           C  
ATOM    736  CG  LEU    47      -5.396  -0.462  -6.092  1.00 71.30           C  
ATOM    737  CD1 LEU    47      -4.392  -0.640  -4.966  1.00 55.22           C  
ATOM    738  CD2 LEU    47      -5.172   0.867  -6.790  1.00 60.32           C  
ATOM    739  H   LEU    47      -4.943  -0.663  -9.429  1.00 33.42           H  
ATOM    740  HA  LEU    47      -3.200  -1.273  -7.296  1.00 34.23           H  
ATOM    741  HB2 LEU    47      -6.114  -1.528  -7.795  1.00 36.92           H  
ATOM    742  HB3 LEU    47      -5.453  -2.547  -6.533  1.00 36.92           H  
ATOM    743  HG  LEU    47      -6.383  -0.447  -5.655  1.00  4.10           H  
ATOM    744 HD11 LEU    47      -3.390  -0.614  -5.369  1.00 36.92           H  
ATOM    745 HD12 LEU    47      -4.560  -1.592  -4.483  1.00 36.92           H  
ATOM    746 HD13 LEU    47      -4.515   0.156  -4.247  1.00 36.92           H  
ATOM    747 HD21 LEU    47      -5.256   1.670  -6.072  1.00 36.92           H  
ATOM    748 HD22 LEU    47      -5.917   0.995  -7.562  1.00 36.92           H  
ATOM    749 HD23 LEU    47      -4.188   0.881  -7.232  1.00 36.92           H  
ATOM    750  N   LYS    48      -4.243  -3.840  -9.078  1.00 73.20           N  
ATOM    751  CA  LYS    48      -3.909  -5.213  -9.441  1.00 75.42           C  
ATOM    752  C   LYS    48      -2.463  -5.317  -9.916  1.00 51.41           C  
ATOM    753  O   LYS    48      -1.756  -6.266  -9.571  1.00 33.44           O  
ATOM    754  CB  LYS    48      -4.852  -5.730 -10.530  1.00 33.13           C  
ATOM    755  CG  LYS    48      -6.310  -5.777 -10.105  1.00 42.44           C  
ATOM    756  CD  LYS    48      -6.452  -6.375  -8.717  1.00 64.23           C  
ATOM    757  CE  LYS    48      -7.872  -6.839  -8.440  1.00 25.11           C  
ATOM    758  NZ  LYS    48      -8.293  -7.930  -9.360  1.00 44.22           N  
ATOM    759  H   LYS    48      -4.956  -3.380  -9.571  1.00 54.34           H  
ATOM    760  HA  LYS    48      -4.027  -5.823  -8.558  1.00 12.33           H  
ATOM    761  HB2 LYS    48      -4.773  -5.085 -11.392  1.00 36.92           H  
ATOM    762  HB3 LYS    48      -4.549  -6.728 -10.810  1.00 36.92           H  
ATOM    763  HG2 LYS    48      -6.709  -4.773 -10.099  1.00 36.92           H  
ATOM    764  HG3 LYS    48      -6.861  -6.384 -10.806  1.00 36.92           H  
ATOM    765  HD2 LYS    48      -5.782  -7.212  -8.632  1.00 36.92           H  
ATOM    766  HD3 LYS    48      -6.181  -5.624  -7.988  1.00 36.92           H  
ATOM    767  HE2 LYS    48      -7.929  -7.197  -7.423  1.00 36.92           H  
ATOM    768  HE3 LYS    48      -8.540  -6.000  -8.563  1.00 36.92           H  
ATOM    769  HZ1 LYS    48      -7.595  -8.708  -9.341  1.00 36.92           H  
ATOM    770  HZ2 LYS    48      -8.371  -7.570 -10.336  1.00 36.92           H  
ATOM    771  HZ3 LYS    48      -9.220  -8.306  -9.067  1.00 36.92           H  
ATOM    772  N   GLU    49      -2.027  -4.338 -10.704  1.00 11.24           N  
ATOM    773  CA  GLU    49      -0.648  -4.291 -11.179  1.00 21.22           C  
ATOM    774  C   GLU    49       0.310  -4.242  -9.994  1.00 71.10           C  
ATOM    775  O   GLU    49       1.316  -4.953  -9.958  1.00 65.13           O  
ATOM    776  CB  GLU    49      -0.431  -3.066 -12.074  1.00 24.45           C  
ATOM    777  CG  GLU    49      -1.391  -2.986 -13.250  1.00 22.30           C  
ATOM    778  CD  GLU    49      -1.150  -1.768 -14.124  1.00 71.11           C  
ATOM    779  OE1 GLU    49      -1.441  -0.639 -13.680  1.00  3.41           O  
ATOM    780  OE2 GLU    49      -0.676  -1.931 -15.267  1.00 13.53           O  
ATOM    781  H   GLU    49      -2.651  -3.632 -10.981  1.00 54.14           H  
ATOM    782  HA  GLU    49      -0.457  -5.188 -11.750  1.00 30.44           H  
ATOM    783  HB2 GLU    49      -0.553  -2.175 -11.477  1.00 36.92           H  
ATOM    784  HB3 GLU    49       0.576  -3.092 -12.463  1.00 36.92           H  
ATOM    785  HG2 GLU    49      -1.273  -3.873 -13.852  1.00 36.92           H  
ATOM    786  HG3 GLU    49      -2.401  -2.943 -12.869  1.00 36.92           H  
ATOM    787  N   LEU    50      -0.027  -3.407  -9.023  1.00 32.24           N  
ATOM    788  CA  LEU    50       0.779  -3.245  -7.819  1.00 54.34           C  
ATOM    789  C   LEU    50       0.700  -4.475  -6.919  1.00 62.31           C  
ATOM    790  O   LEU    50       1.695  -4.870  -6.308  1.00 33.53           O  
ATOM    791  CB  LEU    50       0.328  -1.999  -7.058  1.00 74.11           C  
ATOM    792  CG  LEU    50       0.742  -0.676  -7.701  1.00 64.13           C  
ATOM    793  CD1 LEU    50       0.149   0.499  -6.940  1.00  1.12           C  
ATOM    794  CD2 LEU    50       2.259  -0.572  -7.746  1.00 55.13           C  
ATOM    795  H   LEU    50      -0.846  -2.872  -9.121  1.00  0.32           H  
ATOM    796  HA  LEU    50       1.804  -3.110  -8.128  1.00 33.13           H  
ATOM    797  HB2 LEU    50      -0.750  -2.019  -6.985  1.00 36.92           H  
ATOM    798  HB3 LEU    50       0.738  -2.036  -6.063  1.00 36.92           H  
ATOM    799  HG  LEU    50       0.371  -0.642  -8.715  1.00 33.34           H  
ATOM    800 HD11 LEU    50       0.499   0.481  -5.919  1.00 36.92           H  
ATOM    801 HD12 LEU    50      -0.929   0.428  -6.952  1.00 36.92           H  
ATOM    802 HD13 LEU    50       0.454   1.422  -7.409  1.00 36.92           H  
ATOM    803 HD21 LEU    50       2.650  -0.596  -6.740  1.00 36.92           H  
ATOM    804 HD22 LEU    50       2.542   0.355  -8.222  1.00 36.92           H  
ATOM    805 HD23 LEU    50       2.660  -1.403  -8.308  1.00 36.92           H  
ATOM    806  N   ALA    51      -0.481  -5.079  -6.846  1.00 41.11           N  
ATOM    807  CA  ALA    51      -0.690  -6.268  -6.026  1.00 11.41           C  
ATOM    808  C   ALA    51       0.201  -7.417  -6.487  1.00 11.52           C  
ATOM    809  O   ALA    51       0.742  -8.157  -5.667  1.00 40.12           O  
ATOM    810  CB  ALA    51      -2.151  -6.690  -6.057  1.00 40.43           C  
ATOM    811  H   ALA    51      -1.241  -4.704  -7.346  1.00 73.44           H  
ATOM    812  HA  ALA    51      -0.434  -6.017  -5.007  1.00 62.11           H  
ATOM    813  HB1 ALA    51      -2.770  -5.869  -5.728  1.00 36.92           H  
ATOM    814  HB2 ALA    51      -2.297  -7.536  -5.400  1.00 36.92           H  
ATOM    815  HB3 ALA    51      -2.425  -6.967  -7.064  1.00 36.92           H  
ATOM    816  N   ALA    52       0.359  -7.550  -7.802  1.00 30.53           N  
ATOM    817  CA  ALA    52       1.192  -8.601  -8.378  1.00 50.04           C  
ATOM    818  C   ALA    52       2.662  -8.413  -8.011  1.00 23.14           C  
ATOM    819  O   ALA    52       3.413  -9.382  -7.903  1.00 21.42           O  
ATOM    820  CB  ALA    52       1.031  -8.637  -9.891  1.00 23.14           C  
ATOM    821  H   ALA    52      -0.110  -6.929  -8.402  1.00 65.21           H  
ATOM    822  HA  ALA    52       0.853  -9.547  -7.982  1.00 63.03           H  
ATOM    823  HB1 ALA    52       1.603  -9.461 -10.293  1.00 36.92           H  
ATOM    824  HB2 ALA    52       1.390  -7.711 -10.313  1.00 36.92           H  
ATOM    825  HB3 ALA    52      -0.012  -8.768 -10.141  1.00 36.92           H  
ATOM    826  N   ALA    53       3.069  -7.163  -7.831  1.00 15.05           N  
ATOM    827  CA  ALA    53       4.444  -6.860  -7.461  1.00 25.53           C  
ATOM    828  C   ALA    53       4.680  -7.140  -5.981  1.00 14.01           C  
ATOM    829  O   ALA    53       5.673  -7.767  -5.613  1.00 21.34           O  
ATOM    830  CB  ALA    53       4.775  -5.411  -7.788  1.00 44.34           C  
ATOM    831  H   ALA    53       2.430  -6.430  -7.947  1.00 13.42           H  
ATOM    832  HA  ALA    53       5.094  -7.494  -8.046  1.00 13.21           H  
ATOM    833  HB1 ALA    53       4.145  -4.759  -7.203  1.00 36.92           H  
ATOM    834  HB2 ALA    53       4.604  -5.231  -8.839  1.00 36.92           H  
ATOM    835  HB3 ALA    53       5.812  -5.217  -7.554  1.00 36.92           H  
ATOM    836  N   ALA    54       3.753  -6.681  -5.144  1.00 63.51           N  
ATOM    837  CA  ALA    54       3.859  -6.855  -3.698  1.00 50.11           C  
ATOM    838  C   ALA    54       3.695  -8.321  -3.301  1.00 31.12           C  
ATOM    839  O   ALA    54       4.514  -8.878  -2.567  1.00 55.23           O  
ATOM    840  CB  ALA    54       2.816  -5.999  -2.993  1.00 43.23           C  
ATOM    841  H   ALA    54       2.975  -6.206  -5.510  1.00 62.02           H  
ATOM    842  HA  ALA    54       4.836  -6.516  -3.391  1.00  3.24           H  
ATOM    843  HB1 ALA    54       2.917  -4.971  -3.311  1.00 36.92           H  
ATOM    844  HB2 ALA    54       2.961  -6.061  -1.925  1.00 36.92           H  
ATOM    845  HB3 ALA    54       1.828  -6.357  -3.243  1.00 36.92           H  
ATOM    846  N   SER    55       2.634  -8.937  -3.792  1.00 63.11           N  
ATOM    847  CA  SER    55       2.357 -10.328  -3.496  1.00 53.42           C  
ATOM    848  C   SER    55       2.462 -11.162  -4.763  1.00 52.22           C  
ATOM    849  O   SER    55       1.758 -10.909  -5.740  1.00  1.23           O  
ATOM    850  CB  SER    55       0.966 -10.466  -2.874  1.00 41.12           C  
ATOM    851  OG  SER    55      -0.024  -9.848  -3.684  1.00 43.44           O  
ATOM    852  H   SER    55       2.023  -8.444  -4.381  1.00 22.04           H  
ATOM    853  HA  SER    55       3.097 -10.674  -2.789  1.00 21.41           H  
ATOM    854  HB2 SER    55       0.725 -11.515  -2.767  1.00 36.92           H  
ATOM    855  HB3 SER    55       0.962  -9.994  -1.904  1.00 36.92           H  
ATOM    856  HG  SER    55       0.393  -9.486  -4.478  1.00  0.33           H  
ATOM    857  N   SER    56       3.356 -12.139  -4.752  1.00 71.22           N  
ATOM    858  CA  SER    56       3.554 -12.997  -5.907  1.00  2.45           C  
ATOM    859  C   SER    56       2.365 -13.942  -6.077  1.00 50.23           C  
ATOM    860  O   SER    56       1.435 -13.646  -6.832  1.00 52.53           O  
ATOM    861  CB  SER    56       4.852 -13.788  -5.752  1.00 10.03           C  
ATOM    862  OG  SER    56       5.923 -12.940  -5.373  1.00 72.14           O  
ATOM    863  H   SER    56       3.899 -12.284  -3.947  1.00  1.32           H  
ATOM    864  HA  SER    56       3.625 -12.366  -6.780  1.00  4.24           H  
ATOM    865  HB2 SER    56       4.722 -14.545  -4.993  1.00 36.92           H  
ATOM    866  HB3 SER    56       5.099 -14.260  -6.693  1.00 36.92           H  
ATOM    867  HG  SER    56       5.861 -12.107  -5.866  1.00  4.34           H  
ATOM    868  N   ALA    57       2.396 -15.065  -5.353  1.00 12.51           N  
ATOM    869  CA  ALA    57       1.335 -16.047  -5.377  1.00 33.14           C  
ATOM    870  C   ALA    57       1.033 -16.502  -6.796  1.00 23.43           C  
ATOM    871  O   ALA    57       1.818 -16.299  -7.729  1.00 10.43           O  
ATOM    872  CB  ALA    57       0.083 -15.483  -4.713  1.00 62.00           C  
ATOM    873  H   ALA    57       3.159 -15.242  -4.789  1.00 31.43           H  
ATOM    874  HA  ALA    57       1.662 -16.901  -4.801  1.00 43.33           H  
ATOM    875  HB1 ALA    57      -0.252 -14.613  -5.258  1.00 36.92           H  
ATOM    876  HB2 ALA    57       0.309 -15.204  -3.694  1.00 36.92           H  
ATOM    877  HB3 ALA    57      -0.695 -16.232  -4.716  1.00 36.92           H  
ATOM    878  N   ASP    58      -0.098 -17.142  -6.935  1.00 51.44           N  
ATOM    879  CA  ASP    58      -0.593 -17.557  -8.241  1.00 60.15           C  
ATOM    880  C   ASP    58      -1.215 -16.372  -8.962  1.00 21.53           C  
ATOM    881  O   ASP    58      -0.896 -16.094 -10.118  1.00 41.32           O  
ATOM    882  CB  ASP    58      -1.630 -18.676  -8.110  1.00 52.14           C  
ATOM    883  CG  ASP    58      -1.017 -20.002  -7.713  1.00 11.33           C  
ATOM    884  OD1 ASP    58      -0.813 -20.238  -6.500  1.00 22.34           O  
ATOM    885  OD2 ASP    58      -0.735 -20.819  -8.612  1.00 61.34           O  
ATOM    886  H   ASP    58      -0.616 -17.340  -6.127  1.00 45.34           H  
ATOM    887  HA  ASP    58       0.247 -17.917  -8.816  1.00 63.12           H  
ATOM    888  HB2 ASP    58      -2.356 -18.399  -7.361  1.00 36.92           H  
ATOM    889  HB3 ASP    58      -2.131 -18.802  -9.060  1.00 36.92           H  
ATOM    890  N   GLU    59      -2.106 -15.675  -8.268  1.00  5.43           N  
ATOM    891  CA  GLU    59      -2.817 -14.540  -8.838  1.00 65.12           C  
ATOM    892  C   GLU    59      -2.734 -13.331  -7.912  1.00 42.44           C  
ATOM    893  O   GLU    59      -3.513 -12.381  -8.038  1.00 62.23           O  
ATOM    894  CB  GLU    59      -4.278 -14.922  -9.073  1.00 24.01           C  
ATOM    895  CG  GLU    59      -4.443 -16.070 -10.051  1.00 21.50           C  
ATOM    896  CD  GLU    59      -5.859 -16.586 -10.113  1.00 22.43           C  
ATOM    897  OE1 GLU    59      -6.689 -15.976 -10.815  1.00 73.42           O  
ATOM    898  OE2 GLU    59      -6.144 -17.611  -9.459  1.00 70.12           O  
ATOM    899  H   GLU    59      -2.307 -15.947  -7.341  1.00 73.32           H  
ATOM    900  HA  GLU    59      -2.358 -14.294  -9.783  1.00 21.01           H  
ATOM    901  HB2 GLU    59      -4.718 -15.214  -8.130  1.00 36.92           H  
ATOM    902  HB3 GLU    59      -4.808 -14.064  -9.460  1.00 36.92           H  
ATOM    903  HG2 GLU    59      -4.156 -15.734 -11.036  1.00 36.92           H  
ATOM    904  HG3 GLU    59      -3.796 -16.879  -9.746  1.00 36.92           H  
ATOM    905  N   GLY    60      -1.785 -13.372  -6.989  1.00 65.33           N  
ATOM    906  CA  GLY    60      -1.613 -12.283  -6.052  1.00 60.33           C  
ATOM    907  C   GLY    60      -2.392 -12.506  -4.771  1.00  3.34           C  
ATOM    908  O   GLY    60      -3.015 -13.554  -4.590  1.00 14.40           O  
ATOM    909  H   GLY    60      -1.195 -14.152  -6.939  1.00 72.33           H  
ATOM    910  HA2 GLY    60      -0.562 -12.188  -5.815  1.00 36.92           H  
ATOM    911  HA3 GLY    60      -1.954 -11.369  -6.514  1.00 36.92           H  
ATOM    912  N   ALA    61      -2.346 -11.526  -3.880  1.00 72.42           N  
ATOM    913  CA  ALA    61      -3.069 -11.591  -2.616  1.00 51.33           C  
ATOM    914  C   ALA    61      -4.578 -11.542  -2.840  1.00 33.41           C  
ATOM    915  O   ALA    61      -5.045 -11.232  -3.938  1.00 22.40           O  
ATOM    916  CB  ALA    61      -2.636 -10.451  -1.708  1.00 75.35           C  
ATOM    917  H   ALA    61      -1.799 -10.733  -4.074  1.00 11.03           H  
ATOM    918  HA  ALA    61      -2.817 -12.522  -2.131  1.00 14.23           H  
ATOM    919  HB1 ALA    61      -3.144 -10.536  -0.758  1.00 36.92           H  
ATOM    920  HB2 ALA    61      -2.892  -9.508  -2.169  1.00 36.92           H  
ATOM    921  HB3 ALA    61      -1.569 -10.498  -1.553  1.00 36.92           H  
ATOM    922  N   SER    62      -5.334 -11.843  -1.793  1.00 73.03           N  
ATOM    923  CA  SER    62      -6.787 -11.813  -1.866  1.00 13.25           C  
ATOM    924  C   SER    62      -7.280 -10.372  -1.920  1.00 31.33           C  
ATOM    925  O   SER    62      -6.742  -9.502  -1.239  1.00 73.22           O  
ATOM    926  CB  SER    62      -7.375 -12.533  -0.656  1.00 54.03           C  
ATOM    927  OG  SER    62      -6.856 -13.851  -0.560  1.00 72.43           O  
ATOM    928  H   SER    62      -4.903 -12.076  -0.942  1.00 71.44           H  
ATOM    929  HA  SER    62      -7.090 -12.325  -2.766  1.00 52.21           H  
ATOM    930  HB2 SER    62      -7.120 -11.994   0.245  1.00 36.92           H  
ATOM    931  HB3 SER    62      -8.448 -12.581  -0.755  1.00 36.92           H  
ATOM    932  HG  SER    62      -6.398 -14.071  -1.381  1.00 64.34           H  
ATOM    933  N   VAL    63      -8.296 -10.121  -2.728  1.00 44.14           N  
ATOM    934  CA  VAL    63      -8.796  -8.773  -2.909  1.00  5.32           C  
ATOM    935  C   VAL    63     -10.323  -8.737  -2.879  1.00 64.30           C  
ATOM    936  O   VAL    63     -10.999  -9.339  -3.715  1.00 54.23           O  
ATOM    937  CB  VAL    63      -8.267  -8.150  -4.225  1.00 12.20           C  
ATOM    938  CG1 VAL    63      -8.564  -9.045  -5.422  1.00 44.21           C  
ATOM    939  CG2 VAL    63      -8.845  -6.758  -4.438  1.00  3.44           C  
ATOM    940  H   VAL    63      -8.730 -10.863  -3.205  1.00 41.21           H  
ATOM    941  HA  VAL    63      -8.424  -8.176  -2.088  1.00 34.10           H  
ATOM    942  HB  VAL    63      -7.194  -8.057  -4.141  1.00 44.33           H  
ATOM    943 HG11 VAL    63      -9.633  -9.167  -5.524  1.00 36.92           H  
ATOM    944 HG12 VAL    63      -8.104 -10.010  -5.273  1.00 36.92           H  
ATOM    945 HG13 VAL    63      -8.166  -8.591  -6.318  1.00 36.92           H  
ATOM    946 HG21 VAL    63      -8.434  -6.330  -5.341  1.00 36.92           H  
ATOM    947 HG22 VAL    63      -8.594  -6.131  -3.595  1.00 36.92           H  
ATOM    948 HG23 VAL    63      -9.919  -6.825  -4.530  1.00 36.92           H  
ATOM    949  N   ALA    64     -10.856  -8.047  -1.887  1.00  0.14           N  
ATOM    950  CA  ALA    64     -12.288  -7.819  -1.788  1.00 21.41           C  
ATOM    951  C   ALA    64     -12.562  -6.327  -1.880  1.00 35.15           C  
ATOM    952  O   ALA    64     -12.278  -5.578  -0.946  1.00 43.34           O  
ATOM    953  CB  ALA    64     -12.834  -8.391  -0.489  1.00 63.04           C  
ATOM    954  H   ALA    64     -10.264  -7.673  -1.193  1.00 52.24           H  
ATOM    955  HA  ALA    64     -12.769  -8.322  -2.616  1.00 14.12           H  
ATOM    956  HB1 ALA    64     -12.364  -7.896   0.348  1.00 36.92           H  
ATOM    957  HB2 ALA    64     -12.625  -9.449  -0.445  1.00 36.92           H  
ATOM    958  HB3 ALA    64     -13.902  -8.233  -0.447  1.00 36.92           H  
ATOM    959  N   TYR    65     -13.097  -5.890  -3.004  1.00 54.34           N  
ATOM    960  CA  TYR    65     -13.224  -4.466  -3.259  1.00 14.20           C  
ATOM    961  C   TYR    65     -14.639  -3.974  -3.005  1.00 50.43           C  
ATOM    962  O   TYR    65     -15.609  -4.709  -3.185  1.00 43.51           O  
ATOM    963  CB  TYR    65     -12.788  -4.132  -4.693  1.00  1.20           C  
ATOM    964  CG  TYR    65     -13.635  -4.762  -5.787  1.00  2.44           C  
ATOM    965  CD1 TYR    65     -14.810  -4.154  -6.216  1.00  0.31           C  
ATOM    966  CD2 TYR    65     -13.252  -5.950  -6.401  1.00 62.40           C  
ATOM    967  CE1 TYR    65     -15.579  -4.712  -7.217  1.00 73.44           C  
ATOM    968  CE2 TYR    65     -14.017  -6.511  -7.408  1.00 12.11           C  
ATOM    969  CZ  TYR    65     -15.179  -5.887  -7.809  1.00  0.44           C  
ATOM    970  OH  TYR    65     -15.944  -6.433  -8.815  1.00 35.31           O  
ATOM    971  H   TYR    65     -13.431  -6.535  -3.668  1.00 31.52           H  
ATOM    972  HA  TYR    65     -12.560  -3.956  -2.575  1.00 43.25           H  
ATOM    973  HB2 TYR    65     -12.825  -3.062  -4.826  1.00 36.92           H  
ATOM    974  HB3 TYR    65     -11.770  -4.467  -4.830  1.00 36.92           H  
ATOM    975  HD1 TYR    65     -15.122  -3.233  -5.751  1.00 71.15           H  
ATOM    976  HD2 TYR    65     -12.342  -6.438  -6.083  1.00 51.12           H  
ATOM    977  HE1 TYR    65     -16.490  -4.225  -7.533  1.00 12.11           H  
ATOM    978  HE2 TYR    65     -13.706  -7.435  -7.874  1.00 43.35           H  
ATOM    979  HH  TYR    65     -16.005  -7.390  -8.696  1.00 23.11           H  
ATOM    980  N   LYS    66     -14.740  -2.736  -2.558  1.00 23.34           N  
ATOM    981  CA  LYS    66     -16.020  -2.076  -2.406  1.00 52.14           C  
ATOM    982  C   LYS    66     -16.198  -1.043  -3.489  1.00 45.51           C  
ATOM    983  O   LYS    66     -15.264  -0.320  -3.838  1.00 42.11           O  
ATOM    984  CB  LYS    66     -16.127  -1.366  -1.064  1.00 20.13           C  
ATOM    985  CG  LYS    66     -16.056  -2.280   0.131  1.00 13.54           C  
ATOM    986  CD  LYS    66     -15.737  -1.473   1.373  1.00 52.40           C  
ATOM    987  CE  LYS    66     -15.406  -2.345   2.568  1.00 75.44           C  
ATOM    988  NZ  LYS    66     -14.811  -1.538   3.664  1.00  1.23           N  
ATOM    989  H   LYS    66     -13.923  -2.248  -2.307  1.00 52.21           H  
ATOM    990  HA  LYS    66     -16.799  -2.817  -2.485  1.00 74.25           H  
ATOM    991  HB2 LYS    66     -15.321  -0.652  -0.985  1.00 36.92           H  
ATOM    992  HB3 LYS    66     -17.067  -0.836  -1.025  1.00 36.92           H  
ATOM    993  HG2 LYS    66     -17.011  -2.769   0.259  1.00 36.92           H  
ATOM    994  HG3 LYS    66     -15.287  -3.011  -0.035  1.00 36.92           H  
ATOM    995  HD2 LYS    66     -14.890  -0.837   1.165  1.00 36.92           H  
ATOM    996  HD3 LYS    66     -16.593  -0.859   1.616  1.00 36.92           H  
ATOM    997  HE2 LYS    66     -16.313  -2.811   2.923  1.00 36.92           H  
ATOM    998  HE3 LYS    66     -14.701  -3.103   2.264  1.00 36.92           H  
ATOM    999  HZ1 LYS    66     -15.471  -0.782   3.954  1.00 36.92           H  
ATOM   1000  HZ2 LYS    66     -13.921  -1.095   3.334  1.00 36.92           H  
ATOM   1001  HZ3 LYS    66     -14.602  -2.135   4.488  1.00 36.92           H  
ATOM   1002  N   ILE    67     -17.398  -0.991  -4.009  1.00 45.32           N  
ATOM   1003  CA  ILE    67     -17.793   0.051  -4.939  1.00 72.14           C  
ATOM   1004  C   ILE    67     -19.163   0.573  -4.544  1.00 63.23           C  
ATOM   1005  O   ILE    67     -20.180  -0.090  -4.764  1.00 32.20           O  
ATOM   1006  CB  ILE    67     -17.842  -0.437  -6.404  1.00 21.51           C  
ATOM   1007  CG1 ILE    67     -16.476  -0.963  -6.847  1.00 22.50           C  
ATOM   1008  CG2 ILE    67     -18.293   0.700  -7.315  1.00 22.44           C  
ATOM   1009  CD1 ILE    67     -16.452  -1.466  -8.275  1.00  1.44           C  
ATOM   1010  H   ILE    67     -18.049  -1.670  -3.740  1.00  2.22           H  
ATOM   1011  HA  ILE    67     -17.073   0.855  -4.866  1.00 75.03           H  
ATOM   1012  HB  ILE    67     -18.568  -1.233  -6.474  1.00 11.44           H  
ATOM   1013 HG12 ILE    67     -15.750  -0.169  -6.763  1.00 36.92           H  
ATOM   1014 HG13 ILE    67     -16.185  -1.779  -6.201  1.00 36.92           H  
ATOM   1015 HG21 ILE    67     -19.276   1.032  -7.018  1.00 36.92           H  
ATOM   1016 HG22 ILE    67     -18.323   0.353  -8.338  1.00 36.92           H  
ATOM   1017 HG23 ILE    67     -17.596   1.520  -7.235  1.00 36.92           H  
ATOM   1018 HD11 ILE    67     -17.154  -2.280  -8.381  1.00 36.92           H  
ATOM   1019 HD12 ILE    67     -15.459  -1.812  -8.518  1.00 36.92           H  
ATOM   1020 HD13 ILE    67     -16.726  -0.663  -8.943  1.00 36.92           H  
ATOM   1021  N   LYS    68     -19.186   1.740  -3.934  1.00 34.32           N  
ATOM   1022  CA  LYS    68     -20.437   2.340  -3.514  1.00 25.45           C  
ATOM   1023  C   LYS    68     -20.806   3.478  -4.442  1.00 45.23           C  
ATOM   1024  O   LYS    68     -20.070   4.459  -4.571  1.00 71.53           O  
ATOM   1025  CB  LYS    68     -20.345   2.827  -2.072  1.00 71.40           C  
ATOM   1026  CG  LYS    68     -21.651   3.377  -1.517  1.00 52.33           C  
ATOM   1027  CD  LYS    68     -21.542   3.652  -0.026  1.00 33.42           C  
ATOM   1028  CE  LYS    68     -22.825   4.245   0.538  1.00 50.52           C  
ATOM   1029  NZ  LYS    68     -23.997   3.355   0.327  1.00 72.10           N  
ATOM   1030  H   LYS    68     -18.341   2.211  -3.764  1.00 40.12           H  
ATOM   1031  HA  LYS    68     -21.205   1.582  -3.579  1.00 54.24           H  
ATOM   1032  HB2 LYS    68     -20.038   2.003  -1.451  1.00 36.92           H  
ATOM   1033  HB3 LYS    68     -19.602   3.607  -2.018  1.00 36.92           H  
ATOM   1034  HG2 LYS    68     -21.887   4.300  -2.025  1.00 36.92           H  
ATOM   1035  HG3 LYS    68     -22.438   2.657  -1.685  1.00 36.92           H  
ATOM   1036  HD2 LYS    68     -21.333   2.724   0.486  1.00 36.92           H  
ATOM   1037  HD3 LYS    68     -20.731   4.346   0.141  1.00 36.92           H  
ATOM   1038  HE2 LYS    68     -22.696   4.409   1.598  1.00 36.92           H  
ATOM   1039  HE3 LYS    68     -23.010   5.193   0.051  1.00 36.92           H  
ATOM   1040  HZ1 LYS    68     -23.818   2.416   0.742  1.00 36.92           H  
ATOM   1041  HZ2 LYS    68     -24.187   3.246  -0.691  1.00 36.92           H  
ATOM   1042  HZ3 LYS    68     -24.843   3.766   0.780  1.00 36.92           H  
ATOM   1043  N   ASP    69     -21.948   3.326  -5.082  1.00 60.11           N  
ATOM   1044  CA  ASP    69     -22.432   4.284  -6.053  1.00 21.41           C  
ATOM   1045  C   ASP    69     -23.101   5.447  -5.324  1.00 34.11           C  
ATOM   1046  O   ASP    69     -24.267   5.355  -4.939  1.00 44.23           O  
ATOM   1047  CB  ASP    69     -23.443   3.619  -6.996  1.00 24.45           C  
ATOM   1048  CG  ASP    69     -23.033   2.222  -7.437  1.00 63.23           C  
ATOM   1049  OD1 ASP    69     -22.338   2.087  -8.468  1.00 23.43           O  
ATOM   1050  OD2 ASP    69     -23.432   1.246  -6.762  1.00 74.32           O  
ATOM   1051  H   ASP    69     -22.499   2.539  -4.881  1.00 51.42           H  
ATOM   1052  HA  ASP    69     -21.589   4.649  -6.628  1.00 41.14           H  
ATOM   1053  HB2 ASP    69     -24.397   3.548  -6.495  1.00 36.92           H  
ATOM   1054  HB3 ASP    69     -23.553   4.231  -7.872  1.00 36.92           H  
ATOM   1055  N   LEU    70     -22.358   6.520  -5.106  1.00 53.24           N  
ATOM   1056  CA  LEU    70     -22.879   7.671  -4.381  1.00 44.32           C  
ATOM   1057  C   LEU    70     -23.393   8.734  -5.341  1.00 73.41           C  
ATOM   1058  O   LEU    70     -23.405   8.542  -6.559  1.00 72.32           O  
ATOM   1059  CB  LEU    70     -21.796   8.270  -3.478  1.00 24.22           C  
ATOM   1060  CG  LEU    70     -21.334   7.376  -2.330  1.00 55.12           C  
ATOM   1061  CD1 LEU    70     -20.155   8.007  -1.604  1.00 61.32           C  
ATOM   1062  CD2 LEU    70     -22.483   7.129  -1.367  1.00 75.23           C  
ATOM   1063  H   LEU    70     -21.438   6.548  -5.446  1.00 74.20           H  
ATOM   1064  HA  LEU    70     -23.700   7.332  -3.766  1.00 60.34           H  
ATOM   1065  HB2 LEU    70     -20.938   8.504  -4.092  1.00 36.92           H  
ATOM   1066  HB3 LEU    70     -22.177   9.189  -3.058  1.00 36.92           H  
ATOM   1067  HG  LEU    70     -21.015   6.424  -2.727  1.00 20.33           H  
ATOM   1068 HD11 LEU    70     -19.847   7.366  -0.790  1.00 36.92           H  
ATOM   1069 HD12 LEU    70     -20.445   8.971  -1.213  1.00 36.92           H  
ATOM   1070 HD13 LEU    70     -19.334   8.131  -2.294  1.00 36.92           H  
ATOM   1071 HD21 LEU    70     -22.155   6.473  -0.576  1.00 36.92           H  
ATOM   1072 HD22 LEU    70     -23.305   6.671  -1.898  1.00 36.92           H  
ATOM   1073 HD23 LEU    70     -22.807   8.069  -0.945  1.00 36.92           H  
ATOM   1074  N   GLU    71     -23.814   9.857  -4.785  1.00 23.43           N  
ATOM   1075  CA  GLU    71     -24.349  10.951  -5.573  1.00  1.01           C  
ATOM   1076  C   GLU    71     -23.249  11.955  -5.905  1.00 60.04           C  
ATOM   1077  O   GLU    71     -22.900  12.807  -5.086  1.00  1.51           O  
ATOM   1078  CB  GLU    71     -25.472  11.637  -4.801  1.00 70.31           C  
ATOM   1079  CG  GLU    71     -26.265  12.635  -5.619  1.00 62.41           C  
ATOM   1080  CD  GLU    71     -27.254  13.402  -4.774  1.00 30.54           C  
ATOM   1081  OE1 GLU    71     -28.047  12.768  -4.047  1.00 32.54           O  
ATOM   1082  OE2 GLU    71     -27.228  14.651  -4.815  1.00 74.10           O  
ATOM   1083  H   GLU    71     -23.765   9.954  -3.807  1.00 15.23           H  
ATOM   1084  HA  GLU    71     -24.744  10.545  -6.491  1.00 14.31           H  
ATOM   1085  HB2 GLU    71     -26.154  10.884  -4.436  1.00 36.92           H  
ATOM   1086  HB3 GLU    71     -25.043  12.158  -3.957  1.00 36.92           H  
ATOM   1087  HG2 GLU    71     -25.580  13.336  -6.072  1.00 36.92           H  
ATOM   1088  HG3 GLU    71     -26.805  12.107  -6.393  1.00 36.92           H  
ATOM   1089  N   GLY    72     -22.685  11.829  -7.094  1.00 12.40           N  
ATOM   1090  CA  GLY    72     -21.642  12.744  -7.518  1.00 54.51           C  
ATOM   1091  C   GLY    72     -20.257  12.149  -7.384  1.00 60.22           C  
ATOM   1092  O   GLY    72     -19.296  12.660  -7.960  1.00 71.13           O  
ATOM   1093  H   GLY    72     -22.982  11.111  -7.693  1.00 72.14           H  
ATOM   1094  HA2 GLY    72     -21.811  13.008  -8.553  1.00 36.92           H  
ATOM   1095  HA3 GLY    72     -21.696  13.638  -6.916  1.00 36.92           H  
ATOM   1096  N   GLN    73     -20.152  11.070  -6.626  1.00 12.51           N  
ATOM   1097  CA  GLN    73     -18.878  10.398  -6.423  1.00 65.04           C  
ATOM   1098  C   GLN    73     -19.103   8.924  -6.129  1.00 53.02           C  
ATOM   1099  O   GLN    73     -20.239   8.469  -6.037  1.00  4.34           O  
ATOM   1100  CB  GLN    73     -18.098  11.043  -5.271  1.00 73.13           C  
ATOM   1101  CG  GLN    73     -18.834  11.021  -3.939  1.00 20.53           C  
ATOM   1102  CD  GLN    73     -17.944  11.413  -2.774  1.00 32.52           C  
ATOM   1103  OE1 GLN    73     -17.817  12.589  -2.437  1.00 12.33           O  
ATOM   1104  NE2 GLN    73     -17.331  10.424  -2.142  1.00 64.02           N  
ATOM   1105  H   GLN    73     -20.955  10.705  -6.197  1.00  2.45           H  
ATOM   1106  HA  GLN    73     -18.304  10.489  -7.334  1.00 14.12           H  
ATOM   1107  HB2 GLN    73     -17.164  10.517  -5.148  1.00 36.92           H  
ATOM   1108  HB3 GLN    73     -17.890  12.072  -5.526  1.00 36.92           H  
ATOM   1109  HG2 GLN    73     -19.662  11.712  -3.987  1.00 36.92           H  
ATOM   1110  HG3 GLN    73     -19.208  10.023  -3.766  1.00 36.92           H  
ATOM   1111 HE21 GLN    73     -17.484   9.510  -2.455  1.00 36.92           H  
ATOM   1112 HE22 GLN    73     -16.755  10.646  -1.380  1.00 36.92           H  
ATOM   1113  N   VAL    74     -18.016   8.182  -6.000  1.00 44.24           N  
ATOM   1114  CA  VAL    74     -18.083   6.779  -5.618  1.00 51.30           C  
ATOM   1115  C   VAL    74     -16.989   6.451  -4.614  1.00 24.33           C  
ATOM   1116  O   VAL    74     -15.954   7.121  -4.569  1.00  0.32           O  
ATOM   1117  CB  VAL    74     -17.938   5.837  -6.832  1.00 13.50           C  
ATOM   1118  CG1 VAL    74     -19.130   5.966  -7.767  1.00 50.33           C  
ATOM   1119  CG2 VAL    74     -16.641   6.115  -7.573  1.00 32.50           C  
ATOM   1120  H   VAL    74     -17.138   8.591  -6.170  1.00 31.51           H  
ATOM   1121  HA  VAL    74     -19.046   6.601  -5.161  1.00 15.53           H  
ATOM   1122  HB  VAL    74     -17.903   4.822  -6.468  1.00  4.20           H  
ATOM   1123 HG11 VAL    74     -19.014   5.283  -8.595  1.00 36.92           H  
ATOM   1124 HG12 VAL    74     -19.188   6.978  -8.139  1.00 36.92           H  
ATOM   1125 HG13 VAL    74     -20.035   5.728  -7.228  1.00 36.92           H  
ATOM   1126 HG21 VAL    74     -16.557   5.445  -8.416  1.00 36.92           H  
ATOM   1127 HG22 VAL    74     -15.806   5.962  -6.906  1.00 36.92           H  
ATOM   1128 HG23 VAL    74     -16.639   7.137  -7.924  1.00 36.92           H  
ATOM   1129  N   GLU    75     -17.224   5.429  -3.807  1.00 25.23           N  
ATOM   1130  CA  GLU    75     -16.222   4.954  -2.868  1.00 61.11           C  
ATOM   1131  C   GLU    75     -15.567   3.690  -3.386  1.00 54.30           C  
ATOM   1132  O   GLU    75     -16.224   2.657  -3.540  1.00 60.22           O  
ATOM   1133  CB  GLU    75     -16.831   4.678  -1.495  1.00 44.30           C  
ATOM   1134  CG  GLU    75     -17.083   5.925  -0.679  1.00  2.41           C  
ATOM   1135  CD  GLU    75     -17.741   5.628   0.651  1.00 51.44           C  
ATOM   1136  OE1 GLU    75     -18.290   4.516   0.815  1.00 33.35           O  
ATOM   1137  OE2 GLU    75     -17.693   6.496   1.546  1.00 15.14           O  
ATOM   1138  H   GLU    75     -18.095   4.978  -3.847  1.00 52.23           H  
ATOM   1139  HA  GLU    75     -15.467   5.724  -2.770  1.00 22.00           H  
ATOM   1140  HB2 GLU    75     -17.774   4.168  -1.627  1.00 36.92           H  
ATOM   1141  HB3 GLU    75     -16.162   4.040  -0.938  1.00 36.92           H  
ATOM   1142  HG2 GLU    75     -16.137   6.411  -0.491  1.00 36.92           H  
ATOM   1143  HG3 GLU    75     -17.715   6.584  -1.244  1.00 36.92           H  
ATOM   1144  N   LEU    76     -14.285   3.786  -3.670  1.00 12.03           N  
ATOM   1145  CA  LEU    76     -13.500   2.625  -4.045  1.00 73.45           C  
ATOM   1146  C   LEU    76     -12.639   2.229  -2.859  1.00 13.34           C  
ATOM   1147  O   LEU    76     -11.725   2.958  -2.479  1.00 71.02           O  
ATOM   1148  CB  LEU    76     -12.638   2.929  -5.283  1.00 30.32           C  
ATOM   1149  CG  LEU    76     -11.966   1.718  -5.963  1.00 24.24           C  
ATOM   1150  CD1 LEU    76     -10.748   1.240  -5.183  1.00 52.21           C  
ATOM   1151  CD2 LEU    76     -12.963   0.581  -6.137  1.00 40.14           C  
ATOM   1152  H   LEU    76     -13.849   4.665  -3.617  1.00  2.51           H  
ATOM   1153  HA  LEU    76     -14.180   1.817  -4.271  1.00 12.21           H  
ATOM   1154  HB2 LEU    76     -13.265   3.416  -6.015  1.00 36.92           H  
ATOM   1155  HB3 LEU    76     -11.862   3.620  -4.989  1.00 36.92           H  
ATOM   1156  HG  LEU    76     -11.631   2.013  -6.943  1.00  3.32           H  
ATOM   1157 HD11 LEU    76     -10.305   0.395  -5.689  1.00 36.92           H  
ATOM   1158 HD12 LEU    76     -11.049   0.949  -4.189  1.00 36.92           H  
ATOM   1159 HD13 LEU    76     -10.024   2.040  -5.120  1.00 36.92           H  
ATOM   1160 HD21 LEU    76     -13.782   0.909  -6.759  1.00 36.92           H  
ATOM   1161 HD22 LEU    76     -13.343   0.282  -5.170  1.00 36.92           H  
ATOM   1162 HD23 LEU    76     -12.471  -0.259  -6.604  1.00 36.92           H  
ATOM   1163  N   ASP    77     -12.956   1.092  -2.270  1.00 44.04           N  
ATOM   1164  CA  ASP    77     -12.244   0.619  -1.085  1.00 71.33           C  
ATOM   1165  C   ASP    77     -11.896  -0.850  -1.246  1.00 21.25           C  
ATOM   1166  O   ASP    77     -12.757  -1.719  -1.129  1.00  5.21           O  
ATOM   1167  CB  ASP    77     -13.078   0.839   0.186  1.00 30.32           C  
ATOM   1168  CG  ASP    77     -12.360   0.396   1.454  1.00 43.10           C  
ATOM   1169  OD1 ASP    77     -11.302   0.975   1.778  1.00 52.23           O  
ATOM   1170  OD2 ASP    77     -12.863  -0.523   2.140  1.00 61.53           O  
ATOM   1171  H   ASP    77     -13.676   0.543  -2.655  1.00 11.34           H  
ATOM   1172  HA  ASP    77     -11.327   1.184  -1.006  1.00 53.23           H  
ATOM   1173  HB2 ASP    77     -13.308   1.891   0.279  1.00 36.92           H  
ATOM   1174  HB3 ASP    77     -14.001   0.283   0.105  1.00 36.92           H  
ATOM   1175  N   ALA    78     -10.642  -1.121  -1.553  1.00 23.23           N  
ATOM   1176  CA  ALA    78     -10.206  -2.479  -1.820  1.00 62.42           C  
ATOM   1177  C   ALA    78      -9.454  -3.060  -0.634  1.00 62.32           C  
ATOM   1178  O   ALA    78      -8.474  -2.483  -0.161  1.00  3.13           O  
ATOM   1179  CB  ALA    78      -9.338  -2.511  -3.067  1.00 32.42           C  
ATOM   1180  H   ALA    78      -9.988  -0.385  -1.591  1.00 35.04           H  
ATOM   1181  HA  ALA    78     -11.084  -3.079  -2.006  1.00 25.14           H  
ATOM   1182  HB1 ALA    78      -9.042  -3.529  -3.273  1.00 36.92           H  
ATOM   1183  HB2 ALA    78      -8.459  -1.906  -2.907  1.00 36.92           H  
ATOM   1184  HB3 ALA    78      -9.897  -2.122  -3.905  1.00 36.92           H  
ATOM   1185  N   ALA    79      -9.925  -4.201  -0.156  1.00 14.34           N  
ATOM   1186  CA  ALA    79      -9.272  -4.897   0.935  1.00 74.43           C  
ATOM   1187  C   ALA    79      -8.351  -5.982   0.396  1.00 62.11           C  
ATOM   1188  O   ALA    79      -8.807  -6.953  -0.212  1.00 60.22           O  
ATOM   1189  CB  ALA    79     -10.306  -5.489   1.880  1.00 15.01           C  
ATOM   1190  H   ALA    79     -10.743  -4.584  -0.546  1.00 24.21           H  
ATOM   1191  HA  ALA    79      -8.683  -4.177   1.484  1.00 62.25           H  
ATOM   1192  HB1 ALA    79     -10.983  -4.712   2.204  1.00 36.92           H  
ATOM   1193  HB2 ALA    79      -9.808  -5.914   2.739  1.00 36.92           H  
ATOM   1194  HB3 ALA    79     -10.861  -6.260   1.366  1.00 36.92           H  
ATOM   1195  N   PHE    80      -7.057  -5.796   0.603  1.00 44.11           N  
ATOM   1196  CA  PHE    80      -6.057  -6.747   0.142  1.00 65.22           C  
ATOM   1197  C   PHE    80      -5.550  -7.596   1.296  1.00 14.33           C  
ATOM   1198  O   PHE    80      -4.884  -7.094   2.201  1.00 43.53           O  
ATOM   1199  CB  PHE    80      -4.882  -6.015  -0.511  1.00 62.23           C  
ATOM   1200  CG  PHE    80      -5.197  -5.424  -1.857  1.00 12.12           C  
ATOM   1201  CD1 PHE    80      -5.026  -6.170  -3.012  1.00 64.12           C  
ATOM   1202  CD2 PHE    80      -5.660  -4.122  -1.965  1.00  1.25           C  
ATOM   1203  CE1 PHE    80      -5.311  -5.628  -4.251  1.00 23.20           C  
ATOM   1204  CE2 PHE    80      -5.946  -3.576  -3.201  1.00  1.44           C  
ATOM   1205  CZ  PHE    80      -5.771  -4.330  -4.345  1.00  4.21           C  
ATOM   1206  H   PHE    80      -6.763  -4.991   1.089  1.00 31.51           H  
ATOM   1207  HA  PHE    80      -6.522  -7.392  -0.587  1.00 30.54           H  
ATOM   1208  HB2 PHE    80      -4.570  -5.208   0.137  1.00 36.92           H  
ATOM   1209  HB3 PHE    80      -4.060  -6.704  -0.630  1.00 36.92           H  
ATOM   1210  HD1 PHE    80      -4.665  -7.186  -2.938  1.00 24.45           H  
ATOM   1211  HD2 PHE    80      -5.796  -3.530  -1.071  1.00 14.34           H  
ATOM   1212  HE1 PHE    80      -5.173  -6.219  -5.144  1.00 34.43           H  
ATOM   1213  HE2 PHE    80      -6.304  -2.561  -3.272  1.00 24.03           H  
ATOM   1214  HZ  PHE    80      -5.994  -3.904  -5.312  1.00 75.03           H  
ATOM   1215  N   THR    81      -5.864  -8.881   1.257  1.00 11.34           N  
ATOM   1216  CA  THR    81      -5.431  -9.800   2.291  1.00 63.13           C  
ATOM   1217  C   THR    81      -4.085 -10.406   1.929  1.00 62.21           C  
ATOM   1218  O   THR    81      -3.996 -11.274   1.055  1.00  1.30           O  
ATOM   1219  CB  THR    81      -6.464 -10.927   2.510  1.00 55.42           C  
ATOM   1220  OG1 THR    81      -7.730 -10.360   2.875  1.00 23.22           O  
ATOM   1221  CG2 THR    81      -6.002 -11.887   3.599  1.00 51.14           C  
ATOM   1222  H   THR    81      -6.388  -9.224   0.497  1.00 23.55           H  
ATOM   1223  HA  THR    81      -5.332  -9.244   3.212  1.00 12.00           H  
ATOM   1224  HB  THR    81      -6.579 -11.477   1.588  1.00 64.32           H  
ATOM   1225  HG1 THR    81      -7.582  -9.605   3.458  1.00 42.21           H  
ATOM   1226 HG21 THR    81      -5.911 -11.354   4.534  1.00 36.92           H  
ATOM   1227 HG22 THR    81      -5.043 -12.302   3.327  1.00 36.92           H  
ATOM   1228 HG23 THR    81      -6.722 -12.686   3.706  1.00 36.92           H  
ATOM   1229  N   PHE    82      -3.041  -9.929   2.585  1.00 30.33           N  
ATOM   1230  CA  PHE    82      -1.705 -10.441   2.361  1.00 25.52           C  
ATOM   1231  C   PHE    82      -1.409 -11.577   3.328  1.00 12.33           C  
ATOM   1232  O   PHE    82      -2.144 -11.791   4.296  1.00 63.14           O  
ATOM   1233  CB  PHE    82      -0.672  -9.324   2.523  1.00 61.22           C  
ATOM   1234  CG  PHE    82      -0.754  -8.263   1.458  1.00 34.50           C  
ATOM   1235  CD1 PHE    82      -0.074  -8.414   0.261  1.00  4.42           C  
ATOM   1236  CD2 PHE    82      -1.509  -7.119   1.654  1.00  5.35           C  
ATOM   1237  CE1 PHE    82      -0.145  -7.445  -0.720  1.00  1.34           C  
ATOM   1238  CE2 PHE    82      -1.584  -6.144   0.676  1.00 14.24           C  
ATOM   1239  CZ  PHE    82      -0.901  -6.309  -0.512  1.00 62.53           C  
ATOM   1240  H   PHE    82      -3.173  -9.213   3.242  1.00 62.12           H  
ATOM   1241  HA  PHE    82      -1.660 -10.821   1.350  1.00 14.25           H  
ATOM   1242  HB2 PHE    82      -0.819  -8.846   3.479  1.00 36.92           H  
ATOM   1243  HB3 PHE    82       0.320  -9.754   2.491  1.00 36.92           H  
ATOM   1244  HD1 PHE    82       0.517  -9.302   0.095  1.00  5.41           H  
ATOM   1245  HD2 PHE    82      -2.044  -6.991   2.584  1.00 23.51           H  
ATOM   1246  HE1 PHE    82       0.391  -7.574  -1.648  1.00 60.10           H  
ATOM   1247  HE2 PHE    82      -2.177  -5.255   0.840  1.00 64.21           H  
ATOM   1248  HZ  PHE    82      -0.959  -5.549  -1.279  1.00  4.14           H  
ATOM   1249  N   SER    83      -0.337 -12.299   3.069  1.00 75.03           N  
ATOM   1250  CA  SER    83       0.052 -13.409   3.916  1.00 22.32           C  
ATOM   1251  C   SER    83       1.024 -12.920   4.983  1.00 34.44           C  
ATOM   1252  O   SER    83       1.085 -13.455   6.088  1.00 72.02           O  
ATOM   1253  CB  SER    83       0.691 -14.510   3.071  1.00 42.15           C  
ATOM   1254  OG  SER    83      -0.133 -14.842   1.963  1.00 71.23           O  
ATOM   1255  H   SER    83       0.229 -12.062   2.292  1.00 64.54           H  
ATOM   1256  HA  SER    83      -0.834 -13.794   4.396  1.00 51.32           H  
ATOM   1257  HB2 SER    83       1.648 -14.171   2.703  1.00 36.92           H  
ATOM   1258  HB3 SER    83       0.830 -15.392   3.677  1.00 36.92           H  
ATOM   1259  HG  SER    83      -0.148 -14.102   1.347  1.00 63.13           H  
ATOM   1260  N   CYS    84       1.768 -11.880   4.646  1.00 14.33           N  
ATOM   1261  CA  CYS    84       2.748 -11.314   5.552  1.00  3.35           C  
ATOM   1262  C   CYS    84       2.442  -9.840   5.777  1.00 24.12           C  
ATOM   1263  O   CYS    84       1.700  -9.231   5.006  1.00 12.23           O  
ATOM   1264  CB  CYS    84       4.150 -11.465   4.959  1.00 32.54           C  
ATOM   1265  SG  CYS    84       4.440 -13.051   4.143  1.00 64.32           S  
ATOM   1266  H   CYS    84       1.647 -11.474   3.759  1.00 21.02           H  
ATOM   1267  HA  CYS    84       2.692 -11.842   6.493  1.00 43.40           H  
ATOM   1268  HB2 CYS    84       4.306 -10.687   4.228  1.00 36.92           H  
ATOM   1269  HB3 CYS    84       4.878 -11.362   5.750  1.00 36.92           H  
ATOM   1270  HG  CYS    84       4.291 -12.861   2.833  1.00  5.21           H  
ATOM   1271  N   GLN    85       3.009  -9.260   6.820  1.00 12.02           N  
ATOM   1272  CA  GLN    85       2.841  -7.837   7.060  1.00 45.42           C  
ATOM   1273  C   GLN    85       3.818  -7.049   6.206  1.00 45.23           C  
ATOM   1274  O   GLN    85       3.514  -5.945   5.759  1.00 72.34           O  
ATOM   1275  CB  GLN    85       3.032  -7.499   8.537  1.00 24.10           C  
ATOM   1276  CG  GLN    85       2.939  -6.011   8.832  1.00  4.41           C  
ATOM   1277  CD  GLN    85       2.667  -5.733  10.293  1.00 20.40           C  
ATOM   1278  OE1 GLN    85       3.589  -5.561  11.091  1.00  4.15           O  
ATOM   1279  NE2 GLN    85       1.395  -5.704  10.653  1.00  4.11           N  
ATOM   1280  H   GLN    85       3.551  -9.800   7.444  1.00 33.03           H  
ATOM   1281  HA  GLN    85       1.835  -7.572   6.768  1.00 11.14           H  
ATOM   1282  HB2 GLN    85       2.272  -8.005   9.112  1.00 36.92           H  
ATOM   1283  HB3 GLN    85       4.005  -7.848   8.852  1.00 36.92           H  
ATOM   1284  HG2 GLN    85       3.874  -5.544   8.559  1.00 36.92           H  
ATOM   1285  HG3 GLN    85       2.143  -5.586   8.240  1.00 36.92           H  
ATOM   1286 HE21 GLN    85       0.712  -5.861   9.963  1.00 36.92           H  
ATOM   1287 HE22 GLN    85       1.182  -5.534  11.599  1.00 36.92           H  
ATOM   1288  N   ALA    86       4.986  -7.639   5.971  1.00 43.40           N  
ATOM   1289  CA  ALA    86       6.013  -7.022   5.140  1.00  1.11           C  
ATOM   1290  C   ALA    86       5.460  -6.660   3.767  1.00 11.02           C  
ATOM   1291  O   ALA    86       5.602  -5.530   3.312  1.00 13.21           O  
ATOM   1292  CB  ALA    86       7.207  -7.954   5.003  1.00 60.14           C  
ATOM   1293  H   ALA    86       5.170  -8.508   6.384  1.00 20.34           H  
ATOM   1294  HA  ALA    86       6.343  -6.120   5.635  1.00 44.00           H  
ATOM   1295  HB1 ALA    86       6.904  -8.855   4.491  1.00 36.92           H  
ATOM   1296  HB2 ALA    86       7.582  -8.205   5.984  1.00 36.92           H  
ATOM   1297  HB3 ALA    86       7.982  -7.461   4.437  1.00 36.92           H  
ATOM   1298  N   GLU    87       4.804  -7.620   3.128  1.00 34.24           N  
ATOM   1299  CA  GLU    87       4.230  -7.407   1.802  1.00 53.14           C  
ATOM   1300  C   GLU    87       3.065  -6.412   1.851  1.00  2.12           C  
ATOM   1301  O   GLU    87       2.774  -5.740   0.863  1.00  2.04           O  
ATOM   1302  CB  GLU    87       3.792  -8.742   1.188  1.00 73.41           C  
ATOM   1303  CG  GLU    87       3.017  -9.630   2.144  1.00 12.24           C  
ATOM   1304  CD  GLU    87       2.751 -11.017   1.585  1.00 31.21           C  
ATOM   1305  OE1 GLU    87       3.725 -11.734   1.274  1.00 33.21           O  
ATOM   1306  OE2 GLU    87       1.570 -11.395   1.471  1.00 44.22           O  
ATOM   1307  H   GLU    87       4.705  -8.495   3.554  1.00 34.13           H  
ATOM   1308  HA  GLU    87       5.008  -6.984   1.182  1.00 52.24           H  
ATOM   1309  HB2 GLU    87       3.165  -8.540   0.332  1.00 36.92           H  
ATOM   1310  HB3 GLU    87       4.670  -9.279   0.861  1.00 36.92           H  
ATOM   1311  HG2 GLU    87       3.582  -9.732   3.058  1.00 36.92           H  
ATOM   1312  HG3 GLU    87       2.069  -9.159   2.359  1.00 36.92           H  
ATOM   1313  N   MET    88       2.413  -6.310   3.006  1.00 52.33           N  
ATOM   1314  CA  MET    88       1.300  -5.382   3.176  1.00 24.23           C  
ATOM   1315  C   MET    88       1.807  -3.942   3.255  1.00 14.41           C  
ATOM   1316  O   MET    88       1.372  -3.077   2.493  1.00  0.21           O  
ATOM   1317  CB  MET    88       0.490  -5.743   4.433  1.00 34.40           C  
ATOM   1318  CG  MET    88      -0.783  -4.924   4.616  1.00 60.15           C  
ATOM   1319  SD  MET    88      -0.493  -3.301   5.350  1.00  0.12           S  
ATOM   1320  CE  MET    88       0.031  -3.759   7.002  1.00 21.04           C  
ATOM   1321  H   MET    88       2.688  -6.870   3.759  1.00 35.21           H  
ATOM   1322  HA  MET    88       0.660  -5.473   2.309  1.00 72.13           H  
ATOM   1323  HB2 MET    88       0.211  -6.785   4.378  1.00 36.92           H  
ATOM   1324  HB3 MET    88       1.114  -5.594   5.303  1.00 36.92           H  
ATOM   1325  HG2 MET    88      -1.245  -4.783   3.649  1.00 36.92           H  
ATOM   1326  HG3 MET    88      -1.457  -5.476   5.254  1.00 36.92           H  
ATOM   1327  HE1 MET    88       0.905  -4.392   6.940  1.00 36.92           H  
ATOM   1328  HE2 MET    88      -0.767  -4.293   7.497  1.00 36.92           H  
ATOM   1329  HE3 MET    88       0.270  -2.868   7.564  1.00 36.92           H  
ATOM   1330  N   ILE    89       2.745  -3.695   4.163  1.00 35.42           N  
ATOM   1331  CA  ILE    89       3.269  -2.353   4.375  1.00 43.20           C  
ATOM   1332  C   ILE    89       3.995  -1.816   3.142  1.00 61.45           C  
ATOM   1333  O   ILE    89       3.833  -0.649   2.794  1.00 55.34           O  
ATOM   1334  CB  ILE    89       4.210  -2.290   5.596  1.00 34.31           C  
ATOM   1335  CG1 ILE    89       5.259  -3.401   5.532  1.00 51.41           C  
ATOM   1336  CG2 ILE    89       3.407  -2.386   6.884  1.00 41.33           C  
ATOM   1337  CD1 ILE    89       6.361  -3.268   6.558  1.00  5.14           C  
ATOM   1338  H   ILE    89       3.084  -4.429   4.713  1.00 34.24           H  
ATOM   1339  HA  ILE    89       2.425  -1.709   4.579  1.00  1.23           H  
ATOM   1340  HB  ILE    89       4.707  -1.335   5.584  1.00 43.22           H  
ATOM   1341 HG12 ILE    89       4.773  -4.350   5.696  1.00 36.92           H  
ATOM   1342 HG13 ILE    89       5.712  -3.401   4.555  1.00 36.92           H  
ATOM   1343 HG21 ILE    89       4.077  -2.342   7.730  1.00 36.92           H  
ATOM   1344 HG22 ILE    89       2.866  -3.320   6.900  1.00 36.92           H  
ATOM   1345 HG23 ILE    89       2.709  -1.564   6.934  1.00 36.92           H  
ATOM   1346 HD11 ILE    89       6.888  -2.337   6.402  1.00 36.92           H  
ATOM   1347 HD12 ILE    89       7.050  -4.093   6.455  1.00 36.92           H  
ATOM   1348 HD13 ILE    89       5.933  -3.276   7.549  1.00 36.92           H  
ATOM   1349  N   ILE    90       4.778  -2.659   2.470  1.00 32.24           N  
ATOM   1350  CA  ILE    90       5.503  -2.224   1.282  1.00 31.31           C  
ATOM   1351  C   ILE    90       4.533  -1.885   0.152  1.00 73.11           C  
ATOM   1352  O   ILE    90       4.821  -1.042  -0.700  1.00  4.12           O  
ATOM   1353  CB  ILE    90       6.558  -3.259   0.815  1.00 23.53           C  
ATOM   1354  CG1 ILE    90       5.924  -4.601   0.429  1.00 33.53           C  
ATOM   1355  CG2 ILE    90       7.607  -3.464   1.899  1.00 34.14           C  
ATOM   1356  CD1 ILE    90       5.578  -4.718  -1.040  1.00 53.43           C  
ATOM   1357  H   ILE    90       4.876  -3.585   2.779  1.00 55.43           H  
ATOM   1358  HA  ILE    90       6.030  -1.316   1.548  1.00 52.21           H  
ATOM   1359  HB  ILE    90       7.054  -2.849  -0.047  1.00 40.41           H  
ATOM   1360 HG12 ILE    90       6.612  -5.397   0.668  1.00 36.92           H  
ATOM   1361 HG13 ILE    90       5.014  -4.737   0.996  1.00 36.92           H  
ATOM   1362 HG21 ILE    90       8.068  -2.517   2.141  1.00 36.92           H  
ATOM   1363 HG22 ILE    90       8.361  -4.150   1.545  1.00 36.92           H  
ATOM   1364 HG23 ILE    90       7.137  -3.871   2.782  1.00 36.92           H  
ATOM   1365 HD11 ILE    90       5.115  -5.676  -1.223  1.00 36.92           H  
ATOM   1366 HD12 ILE    90       6.479  -4.634  -1.631  1.00 36.92           H  
ATOM   1367 HD13 ILE    90       4.893  -3.929  -1.311  1.00 36.92           H  
ATOM   1368  N   PHE    91       3.384  -2.548   0.152  1.00 12.44           N  
ATOM   1369  CA  PHE    91       2.319  -2.246  -0.793  1.00  4.12           C  
ATOM   1370  C   PHE    91       1.830  -0.816  -0.570  1.00 34.42           C  
ATOM   1371  O   PHE    91       1.723  -0.035  -1.515  1.00 51.31           O  
ATOM   1372  CB  PHE    91       1.172  -3.249  -0.628  1.00  3.51           C  
ATOM   1373  CG  PHE    91       0.042  -3.069  -1.600  1.00 12.43           C  
ATOM   1374  CD1 PHE    91       0.213  -3.358  -2.942  1.00 64.41           C  
ATOM   1375  CD2 PHE    91      -1.193  -2.620  -1.168  1.00  2.12           C  
ATOM   1376  CE1 PHE    91      -0.827  -3.202  -3.837  1.00  1.12           C  
ATOM   1377  CE2 PHE    91      -2.238  -2.463  -2.057  1.00 51.23           C  
ATOM   1378  CZ  PHE    91      -2.054  -2.754  -3.393  1.00 33.21           C  
ATOM   1379  H   PHE    91       3.248  -3.261   0.810  1.00 34.24           H  
ATOM   1380  HA  PHE    91       2.723  -2.328  -1.791  1.00 22.42           H  
ATOM   1381  HB2 PHE    91       1.560  -4.248  -0.757  1.00 36.92           H  
ATOM   1382  HB3 PHE    91       0.769  -3.155   0.370  1.00 36.92           H  
ATOM   1383  HD1 PHE    91       1.172  -3.709  -3.289  1.00 41.40           H  
ATOM   1384  HD2 PHE    91      -1.335  -2.391  -0.122  1.00 71.30           H  
ATOM   1385  HE1 PHE    91      -0.679  -3.430  -4.882  1.00 71.31           H  
ATOM   1386  HE2 PHE    91      -3.198  -2.112  -1.706  1.00 41.33           H  
ATOM   1387  HZ  PHE    91      -2.869  -2.633  -4.092  1.00 14.52           H  
ATOM   1388  N   GLU    92       1.566  -0.479   0.693  1.00 60.31           N  
ATOM   1389  CA  GLU    92       1.198   0.884   1.079  1.00 10.41           C  
ATOM   1390  C   GLU    92       2.265   1.883   0.648  1.00 35.53           C  
ATOM   1391  O   GLU    92       1.952   2.971   0.162  1.00 73.23           O  
ATOM   1392  CB  GLU    92       0.999   0.976   2.593  1.00 11.32           C  
ATOM   1393  CG  GLU    92      -0.192   0.187   3.105  1.00 64.52           C  
ATOM   1394  CD  GLU    92      -1.510   0.842   2.735  1.00 54.45           C  
ATOM   1395  OE1 GLU    92      -1.816   1.931   3.280  1.00 62.31           O  
ATOM   1396  OE2 GLU    92      -2.236   0.284   1.889  1.00 51.03           O  
ATOM   1397  H   GLU    92       1.610  -1.172   1.387  1.00 65.03           H  
ATOM   1398  HA  GLU    92       0.270   1.131   0.588  1.00 64.10           H  
ATOM   1399  HB2 GLU    92       1.887   0.604   3.083  1.00 36.92           H  
ATOM   1400  HB3 GLU    92       0.860   2.015   2.862  1.00 36.92           H  
ATOM   1401  HG2 GLU    92      -0.164  -0.803   2.672  1.00 36.92           H  
ATOM   1402  HG3 GLU    92      -0.125   0.109   4.181  1.00 36.92           H  
ATOM   1403  N   LEU    93       3.524   1.505   0.827  1.00 14.44           N  
ATOM   1404  CA  LEU    93       4.640   2.349   0.424  1.00 24.34           C  
ATOM   1405  C   LEU    93       4.606   2.583  -1.085  1.00 52.55           C  
ATOM   1406  O   LEU    93       4.647   3.724  -1.550  1.00 74.11           O  
ATOM   1407  CB  LEU    93       5.964   1.700   0.832  1.00  3.13           C  
ATOM   1408  CG  LEU    93       6.067   1.306   2.306  1.00 35.43           C  
ATOM   1409  CD1 LEU    93       7.460   0.789   2.622  1.00 62.01           C  
ATOM   1410  CD2 LEU    93       5.712   2.481   3.203  1.00 24.35           C  
ATOM   1411  H   LEU    93       3.706   0.635   1.248  1.00 15.41           H  
ATOM   1412  HA  LEU    93       4.539   3.298   0.929  1.00 74.31           H  
ATOM   1413  HB2 LEU    93       6.102   0.811   0.235  1.00 36.92           H  
ATOM   1414  HB3 LEU    93       6.764   2.391   0.610  1.00 36.92           H  
ATOM   1415  HG  LEU    93       5.364   0.510   2.507  1.00 55.25           H  
ATOM   1416 HD11 LEU    93       8.183   1.571   2.441  1.00 36.92           H  
ATOM   1417 HD12 LEU    93       7.681  -0.058   1.991  1.00 36.92           H  
ATOM   1418 HD13 LEU    93       7.506   0.487   3.659  1.00 36.92           H  
ATOM   1419 HD21 LEU    93       5.766   2.175   4.236  1.00 36.92           H  
ATOM   1420 HD22 LEU    93       4.710   2.818   2.978  1.00 36.92           H  
ATOM   1421 HD23 LEU    93       6.409   3.289   3.031  1.00 36.92           H  
ATOM   1422  N   SER    94       4.526   1.491  -1.834  1.00  0.42           N  
ATOM   1423  CA  SER    94       4.378   1.541  -3.285  1.00 43.13           C  
ATOM   1424  C   SER    94       3.182   2.409  -3.695  1.00 14.02           C  
ATOM   1425  O   SER    94       3.272   3.188  -4.643  1.00  4.35           O  
ATOM   1426  CB  SER    94       4.212   0.120  -3.833  1.00  2.31           C  
ATOM   1427  OG  SER    94       5.285  -0.711  -3.419  1.00 23.35           O  
ATOM   1428  H   SER    94       4.600   0.614  -1.398  1.00 60.22           H  
ATOM   1429  HA  SER    94       5.278   1.972  -3.695  1.00  1.32           H  
ATOM   1430  HB2 SER    94       3.288  -0.299  -3.467  1.00 36.92           H  
ATOM   1431  HB3 SER    94       4.192   0.151  -4.913  1.00 36.92           H  
ATOM   1432  HG  SER    94       5.171  -0.947  -2.492  1.00 41.11           H  
ATOM   1433  N   LEU    95       2.070   2.281  -2.972  1.00 65.10           N  
ATOM   1434  CA  LEU    95       0.882   3.091  -3.234  1.00 21.12           C  
ATOM   1435  C   LEU    95       1.207   4.574  -3.106  1.00 64.05           C  
ATOM   1436  O   LEU    95       0.848   5.375  -3.964  1.00  4.22           O  
ATOM   1437  CB  LEU    95      -0.252   2.736  -2.267  1.00 12.15           C  
ATOM   1438  CG  LEU    95      -0.826   1.327  -2.408  1.00 65.30           C  
ATOM   1439  CD1 LEU    95      -1.894   1.083  -1.355  1.00 40.24           C  
ATOM   1440  CD2 LEU    95      -1.397   1.125  -3.799  1.00 22.31           C  
ATOM   1441  H   LEU    95       2.047   1.617  -2.244  1.00 33.15           H  
ATOM   1442  HA  LEU    95       0.561   2.888  -4.246  1.00 51.10           H  
ATOM   1443  HB2 LEU    95       0.116   2.849  -1.258  1.00 36.92           H  
ATOM   1444  HB3 LEU    95      -1.056   3.442  -2.417  1.00 36.92           H  
ATOM   1445  HG  LEU    95      -0.036   0.604  -2.257  1.00 24.45           H  
ATOM   1446 HD11 LEU    95      -2.701   1.789  -1.489  1.00 36.92           H  
ATOM   1447 HD12 LEU    95      -1.466   1.210  -0.372  1.00 36.92           H  
ATOM   1448 HD13 LEU    95      -2.277   0.078  -1.454  1.00 36.92           H  
ATOM   1449 HD21 LEU    95      -2.186   1.842  -3.972  1.00 36.92           H  
ATOM   1450 HD22 LEU    95      -1.793   0.124  -3.886  1.00 36.92           H  
ATOM   1451 HD23 LEU    95      -0.616   1.267  -4.530  1.00 36.92           H  
ATOM   1452  N   ARG    96       1.900   4.920  -2.030  1.00 52.23           N  
ATOM   1453  CA  ARG    96       2.298   6.299  -1.768  1.00 74.33           C  
ATOM   1454  C   ARG    96       3.264   6.810  -2.829  1.00 44.22           C  
ATOM   1455  O   ARG    96       3.304   8.001  -3.123  1.00 53.24           O  
ATOM   1456  CB  ARG    96       2.932   6.407  -0.385  1.00 63.10           C  
ATOM   1457  CG  ARG    96       1.926   6.265   0.735  1.00 54.05           C  
ATOM   1458  CD  ARG    96       2.605   6.167   2.084  1.00 63.12           C  
ATOM   1459  NE  ARG    96       3.512   7.289   2.341  1.00 62.44           N  
ATOM   1460  CZ  ARG    96       4.058   7.550   3.530  1.00 22.01           C  
ATOM   1461  NH1 ARG    96       3.766   6.797   4.586  1.00  1.44           N  
ATOM   1462  NH2 ARG    96       4.889   8.573   3.660  1.00 42.11           N  
ATOM   1463  H   ARG    96       2.154   4.221  -1.385  1.00 51.31           H  
ATOM   1464  HA  ARG    96       1.407   6.904  -1.783  1.00 74.33           H  
ATOM   1465  HB2 ARG    96       3.676   5.630  -0.276  1.00 36.92           H  
ATOM   1466  HB3 ARG    96       3.411   7.371  -0.292  1.00 36.92           H  
ATOM   1467  HG2 ARG    96       1.272   7.125   0.731  1.00 36.92           H  
ATOM   1468  HG3 ARG    96       1.345   5.370   0.569  1.00 36.92           H  
ATOM   1469  HD2 ARG    96       1.843   6.152   2.842  1.00 36.92           H  
ATOM   1470  HD3 ARG    96       3.167   5.247   2.120  1.00 36.92           H  
ATOM   1471  HE  ARG    96       3.735   7.874   1.582  1.00 72.43           H  
ATOM   1472 HH11 ARG    96       3.136   6.026   4.496  1.00 36.92           H  
ATOM   1473 HH12 ARG    96       4.172   7.001   5.487  1.00 36.92           H  
ATOM   1474 HH21 ARG    96       5.105   9.149   2.864  1.00 36.92           H  
ATOM   1475 HH22 ARG    96       5.317   8.773   4.556  1.00 36.92           H  
ATOM   1476  N   SER    97       4.043   5.903  -3.390  1.00 72.43           N  
ATOM   1477  CA  SER    97       5.027   6.261  -4.398  1.00 45.52           C  
ATOM   1478  C   SER    97       4.378   6.420  -5.779  1.00 73.23           C  
ATOM   1479  O   SER    97       4.681   7.365  -6.510  1.00 53.10           O  
ATOM   1480  CB  SER    97       6.126   5.194  -4.444  1.00 74.24           C  
ATOM   1481  OG  SER    97       7.168   5.554  -5.335  1.00 11.23           O  
ATOM   1482  H   SER    97       3.963   4.965  -3.112  1.00  1.44           H  
ATOM   1483  HA  SER    97       5.467   7.203  -4.109  1.00 55.10           H  
ATOM   1484  HB2 SER    97       6.544   5.070  -3.457  1.00 36.92           H  
ATOM   1485  HB3 SER    97       5.697   4.259  -4.770  1.00 36.92           H  
ATOM   1486  HG  SER    97       7.251   6.522  -5.360  1.00 50.13           H  
ATOM   1487  N   LEU    98       3.481   5.505  -6.130  1.00 34.54           N  
ATOM   1488  CA  LEU    98       2.902   5.485  -7.469  1.00 34.41           C  
ATOM   1489  C   LEU    98       1.629   6.318  -7.543  1.00  1.11           C  
ATOM   1490  O   LEU    98       1.524   7.239  -8.354  1.00 72.25           O  
ATOM   1491  CB  LEU    98       2.597   4.050  -7.893  1.00 12.30           C  
ATOM   1492  CG  LEU    98       2.422   3.854  -9.401  1.00 10.13           C  
ATOM   1493  CD1 LEU    98       3.708   4.199 -10.134  1.00 33.50           C  
ATOM   1494  CD2 LEU    98       1.994   2.431  -9.713  1.00 62.21           C  
ATOM   1495  H   LEU    98       3.208   4.822  -5.477  1.00 62.32           H  
ATOM   1496  HA  LEU    98       3.630   5.901  -8.150  1.00 63.01           H  
ATOM   1497  HB2 LEU    98       3.398   3.419  -7.549  1.00 36.92           H  
ATOM   1498  HB3 LEU    98       1.685   3.740  -7.406  1.00 36.92           H  
ATOM   1499  HG  LEU    98       1.649   4.521  -9.756  1.00 15.40           H  
ATOM   1500 HD11 LEU    98       3.963   5.231  -9.946  1.00 36.92           H  
ATOM   1501 HD12 LEU    98       3.570   4.049 -11.194  1.00 36.92           H  
ATOM   1502 HD13 LEU    98       4.506   3.562  -9.781  1.00 36.92           H  
ATOM   1503 HD21 LEU    98       1.892   2.312 -10.782  1.00 36.92           H  
ATOM   1504 HD22 LEU    98       1.046   2.229  -9.237  1.00 36.92           H  
ATOM   1505 HD23 LEU    98       2.738   1.741  -9.344  1.00 36.92           H  
ATOM   1506  N   ALA    99       0.664   5.990  -6.698  1.00 63.54           N  
ATOM   1507  CA  ALA    99      -0.616   6.682  -6.705  1.00 23.02           C  
ATOM   1508  C   ALA    99      -0.475   8.024  -6.008  1.00  2.43           C  
ATOM   1509  O   ALA    99      -1.050   9.024  -6.441  1.00 53.01           O  
ATOM   1510  CB  ALA    99      -1.689   5.832  -6.036  1.00 72.13           C  
ATOM   1511  H   ALA    99       0.825   5.286  -6.033  1.00 42.21           H  
ATOM   1512  HA  ALA    99      -0.902   6.846  -7.734  1.00 51.33           H  
ATOM   1513  HB1 ALA    99      -1.413   5.645  -5.008  1.00 36.92           H  
ATOM   1514  HB2 ALA    99      -1.784   4.893  -6.560  1.00 36.92           H  
ATOM   1515  HB3 ALA    99      -2.634   6.356  -6.064  1.00 36.92           H  
END
