
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  225 ( 1733),  selected  225 , name 2pjm_A
# Molecule2: number of CA atoms  165 ( 1302),  selected  165 , name T0438_2_186.pdb
# PARAMETERS: 2pjm_A.T0438_2_186.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      Q       2           -
LGA    N     3_A      W       3           -
LGA    E     4_A      Q       4           -
LGA    D     5_A      E       5           -
LGA    L     6_A      L       6           -
LGA    K     7_A      Y       7           -
LGA    L     8_A      R       8           -
LGA    -       -      Q       9           -
LGA    -       -      R      10           -
LGA    -       -      V      11           -
LGA    K     9_A      C      12           #
LGA    V    10_A      S      13          3.104
LGA    A    11_A      A      14          1.825
LGA    K    12_A      D      15          2.243
LGA    E    13_A      E      16          2.766
LGA    A    14_A      A      17          1.825
LGA    V    15_A      V      18          1.258
LGA    K    16_A      V      19          2.174
LGA    L    17_A      D      20          1.863
LGA    V    18_A      S      21          2.452
LGA    -       -      L      22           -
LGA    K    19_A      K      23          1.389
LGA    D    20_A      P      24          1.365
LGA    G    21_A      G      25          1.714
LGA    M    22_A      T      26          1.138
LGA    V    23_A      K      27          1.137
LGA    I    24_A      V      28          1.664
LGA    G    25_A      V      29          2.141
LGA    L    26_A      F      30          1.843
LGA    G    27_A      G      31          3.193
LGA    -       -      X      32           -
LGA    -       -      A      33           -
LGA    -       -      A      34           -
LGA    T    28_A      A      35          3.110
LGA    G    29_A      A      36          3.691
LGA    S    30_A      -       -           -
LGA    T    31_A      -       -           -
LGA    A    32_A      P      37          1.469
LGA    A    33_A      V      38          0.172
LGA    L    34_A      R      39          1.524
LGA    F    35_A      F      40          0.565
LGA    I    36_A      S      41          0.979
LGA    R    37_A      Q      42          2.109
LGA    E    38_A      A      43          1.419
LGA    L    39_A      M      44          1.469
LGA    G    40_A      Y      45          3.574
LGA    N    41_A      R      46          3.667
LGA    R    42_A      Q      47          2.374
LGA    I    43_A      R      48          3.305
LGA    R    44_A      -       -           -
LGA    E    45_A      E      49          1.126
LGA    E    46_A      K      50          2.357
LGA    E    47_A      L      51          5.069
LGA    L    48_A      E      52          0.908
LGA    T    49_A      N      53          1.122
LGA    V    50_A      I      54          1.156
LGA    F    51_A      T      55          1.116
LGA    G    52_A      V      56          1.268
LGA    I    53_A      F      57          1.918
LGA    P    54_A      X      58          1.844
LGA    T    55_A      -       -           -
LGA    S    56_A      M      59          3.694
LGA    F    57_A      L      60          1.088
LGA    E    58_A      Y      61          0.274
LGA    A    59_A      F      62           #
LGA    K    60_A      G      63           -
LGA    M    61_A      D      64           #
LGA    L    62_A      A      65          3.788
LGA    -       -      P      66           -
LGA    A    63_A      X      67          3.330
LGA    M    64_A      L      68          2.486
LGA    Q    65_A      A      69          3.742
LGA    Y    66_A      P      70           #
LGA    -       -      E      71           -
LGA    E    67_A      M      72          3.494
LGA    -       -      R      73           -
LGA    -       -      S      74           -
LGA    -       -      X      75           -
LGA    I    68_A      V      76          2.878
LGA    P    69_A      X      77          1.067
LGA    L    70_A      P      78          2.117
LGA    V    71_A      T      79          2.990
LGA    T    72_A      L      80           #
LGA    -       -      C     101           -
LGA    -       -      X     102           -
LGA    -       -      F     103           -
LGA    -       -      X     104           -
LGA    -       -      E     105           -
LGA    -       -      V     106           -
LGA    -       -      P     107           -
LGA    -       -      E     108           -
LGA    L    73_A      L     109          4.218
LGA    D    74_A      F     110          5.551
LGA    -       -      R     111           -
LGA    -       -      Q     112           -
LGA    -       -      G     113           -
LGA    E    75_A      F     114          2.664
LGA    Y    76_A      F     115          2.409
LGA    D    77_A      P     116          1.774
LGA    V    78_A      L     117          1.640
LGA    D    79_A      D     118          1.497
LGA    I    80_A      V     119          1.572
LGA    A    81_A      A     120          1.286
LGA    F    82_A      V     121          1.758
LGA    D    83_A      V     122          1.330
LGA    G    84_A      Q     123          1.237
LGA    A    85_A      V     124          1.211
LGA    D    86_A      S     125          2.670
LGA    E    87_A      T     126          2.968
LGA    V    88_A      P     127          1.799
LGA    E    89_A      N     128          2.066
LGA    E    90_A      E     129          4.862
LGA    T    91_A      E     130          3.359
LGA    T    92_A      G     131          2.285
LGA    L    93_A      -       -           -
LGA    F    94_A      Y     132          1.540
LGA    L    95_A      C     133          1.615
LGA    I    96_A      S     134          1.734
LGA    K    97_A      F     135          1.927
LGA    G    98_A      G     136          3.213
LGA    G    99_A      V     137          2.756
LGA    G   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    C   102_A      S     138          2.984
LGA    H   103_A      C     139          2.046
LGA    T   104_A      D     140          0.767
LGA    Q   105_A      Y     141          1.849
LGA    E   106_A      T     142          1.214
LGA    K   107_A      K     143          0.988
LGA    I   108_A      A     144          2.286
LGA    V   109_A      A     145          1.523
LGA    D   110_A      A     146          1.408
LGA    Y   111_A      E     147          1.489
LGA    N   112_A      C     148          1.392
LGA    A   113_A      A     149          1.045
LGA    N   114_A      P     150          1.380
LGA    E   115_A      V     151          1.750
LGA    F   116_A      V     152          1.746
LGA    V   117_A      V     153          2.441
LGA    V   118_A      A     154          1.463
LGA    L   119_A      E     155          1.562
LGA    V   120_A      V     156          1.688
LGA    D   121_A      N     157          5.004
LGA    E   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    K   124_A      K     158          2.881
LGA    L   125_A      Q     159           -
LGA    V   126_A      M     160           -
LGA    K   127_A      P     161           -
LGA    K   128_A      -       -           -
LGA    L   129_A      -       -           -
LGA    G   130_A      -       -           -
LGA    E   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    F   133_A      -       -           -
LGA    P   134_A      F     162           #
LGA    I   135_A      I     163          2.108
LGA    P   136_A      G     164           #
LGA    V   137_A      -       -           -
LGA    E   138_A      -       -           -
LGA    V   139_A      -       -           -
LGA    I   140_A      -       -           -
LGA    P   141_A      -       -           -
LGA    S   142_A      -       -           -
LGA    A   143_A      -       -           -
LGA    Y   144_A      -       -           -
LGA    R   145_A      -       -           -
LGA    V   146_A      -       -           -
LGA    V   147_A      -       -           -
LGA    I   148_A      -       -           -
LGA    R   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    S   152_A      -       -           -
LGA    E   153_A      -       -           -
LGA    M   154_A      -       -           -
LGA    G   155_A      -       -           -
LGA    G   156_A      -       -           -
LGA    E   157_A      -       -           -
LGA    A   158_A      -       -           -
LGA    V   159_A      -       -           -
LGA    I   160_A      -       -           -
LGA    R   161_A      -       -           -
LGA    L   162_A      -       -           -
LGA    G   163_A      -       -           -
LGA    D   164_A      -       -           -
LGA    R   165_A      -       -           -
LGA    K   166_A      -       -           -
LGA    R   167_A      -       -           -
LGA    G   168_A      -       -           -
LGA    P   169_A      -       -           -
LGA    V   170_A      -       -           -
LGA    I   171_A      -       -           -
LGA    T   172_A      -       -           -
LGA    D   173_A      -       -           -
LGA    N   174_A      -       -           -
LGA    G   175_A      -       -           -
LGA    N   176_A      -       -           -
LGA    M   177_A      -       -           -
LGA    I   178_A      -       -           -
LGA    I   179_A      -       -           -
LGA    D   180_A      -       -           -
LGA    V   181_A      -       -           -
LGA    F   182_A      -       -           -
LGA    M   183_A      -       -           -
LGA    N   184_A      -       -           -
LGA    I   185_A      -       -           -
LGA    D   186_A      -       -           -
LGA    D   187_A      -       -           -
LGA    A   188_A      -       -           -
LGA    I   189_A      -       -           -
LGA    E   190_A      -       -           -
LGA    L   191_A      G     165           #
LGA    E   192_A      E     166          2.639
LGA    K   193_A      -       -           -
LGA    E   194_A      -       -           -
LGA    I   195_A      -       -           -
LGA    N   196_A      -       -           -
LGA    N   197_A      -       -           -
LGA    I   198_A      -       -           -
LGA    P   199_A      -       -           -
LGA    G   200_A      -       -           -
LGA    V   201_A      -       -           -
LGA    V   202_A      -       -           -
LGA    E   203_A      -       -           -
LGA    N   204_A      -       -           -
LGA    G   205_A      -       -           -
LGA    I   206_A      N     167          1.858
LGA    F   207_A      L     168          1.627
LGA    T   208_A      I     169          3.015
LGA    K   209_A      X     170          4.784
LGA    V   210_A      I     171          5.388
LGA    D   211_A      S     172          4.650
LGA    -       -      K     173           -
LGA    -       -      L     174           -
LGA    K   212_A      T     175          3.555
LGA    V   213_A      X     176           #
LGA    L   214_A      I     177          1.405
LGA    -       -      I     178           -
LGA    V   215_A      E     179          2.946
LGA    G   216_A      V     180          5.134
LGA    T   217_A      D     181           -
LGA    K   218_A      E     182           -
LGA    K   219_A      P     183           -
LGA    G   220_A      I     184           -
LGA    V   221_A      A     185           -
LGA    K   222_A      E     186           -
LGA    T   223_A      -       -           -
LGA    L   224_A      -       -           -
LGA    K   225_A      -       -           -
LGA    K   226_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  225  165    5.0    113    2.51    18.58     45.624     4.333

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.892995 * X  +   0.432159 * Y  +   0.125691 * Z  +  31.365181
  Y_new =   0.435349 * X  +   0.758594 * Y  +   0.484774 * Z  +  -5.542585
  Z_new =   0.114151 * X  +   0.487620 * Y  +  -0.865561 * Z  +  36.258121 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.628552   -0.513040  [ DEG:   150.6049    -29.3950 ]
  Theta =  -0.114400   -3.027193  [ DEG:    -6.5546   -173.4454 ]
  Phi   =   2.687982   -0.453611  [ DEG:   154.0100    -25.9900 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pjm_A                                        
REMARK     2: T0438_2_186.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pjm_A.T0438_2_186.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  225  165   5.0  113   2.51   18.58  45.624
REMARK  ---------------------------------------------------------- 
MOLECULE 2pjm_A
HEADER    ISOMERASE                               16-APR-07   2PJM              
TITLE     STRUCTURE OF RIBOSE 5-PHOSPHATE ISOMERASE A FROM                      
TITLE    2 METHANOCALDOCOCCUS JANNASCHII                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBOSE-5-PHOSPHATE ISOMERASE A;                            
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PHOSPHORIBOISOMERASE A, PRI;                                
COMPND   5 EC: 5.3.1.6;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOCALDOCOCCUS JANNASCHII;                  
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: DSM2661, JAL-1, JCM 10045, NBRC 100440;                      
SOURCE   5 ATCC: 43067;                                                         
SOURCE   6 GENE: RPIA, MJ1603;                                                  
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: ROSETTA(DE3);                              
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET-21A                                   
KEYWDS    3D-STRUCTURE, STRUCTURAL GENOMICS, ISOMERASE, PENTOSE                 
KEYWDS   2 PHOSPHATE PATHWAY, CARBON FIXATION, NPPSFA, NATIONAL                 
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.V.ANTONYUK,M.J.ELLIS,R.W.STRANGE,S.S.HASNAIN,Y.BESSHO,              
AUTHOR   2 S.KURAMITSU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS          
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   16-OCT-07 2PJM    0                                                
JRNL        AUTH   S.V.ANTONYUK,M.J.ELLIS,R.W.STRANGE,S.S.HASNAIN,              
JRNL        AUTH 2 Y.BESSHO,S.KURAMITSU,S.YOKOYAMA                              
JRNL        TITL   STRUCTURE OF RIBOSE 5-PHOSPHATE ISOMERASE A FROM             
JRNL        TITL 2 METHANOCALDOCOCCUS JANNASCHII.                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.78 ANGSTROMS.                                          
DBREF  2PJM A    1   226  UNP    Q58998   RPIA_METJA       1    226             
DBREF  2PJM B    1   226  UNP    Q58998   RPIA_METJA       1    226             
DBREF  2PJM C    1   226  UNP    Q58998   RPIA_METJA       1    226             
DBREF  2PJM D    1   226  UNP    Q58998   RPIA_METJA       1    226             
SEQRES   1 A  226  MET SER ASN GLU ASP LEU LYS LEU LYS VAL ALA LYS GLU          
SEQRES   2 A  226  ALA VAL LYS LEU VAL LYS ASP GLY MET VAL ILE GLY LEU          
SEQRES   3 A  226  GLY THR GLY SER THR ALA ALA LEU PHE ILE ARG GLU LEU          
SEQRES   4 A  226  GLY ASN ARG ILE ARG GLU GLU GLU LEU THR VAL PHE GLY          
SEQRES   5 A  226  ILE PRO THR SER PHE GLU ALA LYS MET LEU ALA MET GLN          
SEQRES   6 A  226  TYR GLU ILE PRO LEU VAL THR LEU ASP GLU TYR ASP VAL          
SEQRES   7 A  226  ASP ILE ALA PHE ASP GLY ALA ASP GLU VAL GLU GLU THR          
SEQRES   8 A  226  THR LEU PHE LEU ILE LYS GLY GLY GLY GLY CYS HIS THR          
SEQRES   9 A  226  GLN GLU LYS ILE VAL ASP TYR ASN ALA ASN GLU PHE VAL          
SEQRES  10 A  226  VAL LEU VAL ASP GLU SER LYS LEU VAL LYS LYS LEU GLY          
SEQRES  11 A  226  GLU LYS PHE PRO ILE PRO VAL GLU VAL ILE PRO SER ALA          
SEQRES  12 A  226  TYR ARG VAL VAL ILE ARG ALA LEU SER GLU MET GLY GLY          
SEQRES  13 A  226  GLU ALA VAL ILE ARG LEU GLY ASP ARG LYS ARG GLY PRO          
SEQRES  14 A  226  VAL ILE THR ASP ASN GLY ASN MET ILE ILE ASP VAL PHE          
SEQRES  15 A  226  MET ASN ILE ASP ASP ALA ILE GLU LEU GLU LYS GLU ILE          
SEQRES  16 A  226  ASN ASN ILE PRO GLY VAL VAL GLU ASN GLY ILE PHE THR          
SEQRES  17 A  226  LYS VAL ASP LYS VAL LEU VAL GLY THR LYS LYS GLY VAL          
SEQRES  18 A  226  LYS THR LEU LYS LYS                                          
SEQRES   1 B  226  MET SER ASN GLU ASP LEU LYS LEU LYS VAL ALA LYS GLU          
SEQRES   2 B  226  ALA VAL LYS LEU VAL LYS ASP GLY MET VAL ILE GLY LEU          
SEQRES   3 B  226  GLY THR GLY SER THR ALA ALA LEU PHE ILE ARG GLU LEU          
SEQRES   4 B  226  GLY ASN ARG ILE ARG GLU GLU GLU LEU THR VAL PHE GLY          
SEQRES   5 B  226  ILE PRO THR SER PHE GLU ALA LYS MET LEU ALA MET GLN          
SEQRES   6 B  226  TYR GLU ILE PRO LEU VAL THR LEU ASP GLU TYR ASP VAL          
SEQRES   7 B  226  ASP ILE ALA PHE ASP GLY ALA ASP GLU VAL GLU GLU THR          
SEQRES   8 B  226  THR LEU PHE LEU ILE LYS GLY GLY GLY GLY CYS HIS THR          
SEQRES   9 B  226  GLN GLU LYS ILE VAL ASP TYR ASN ALA ASN GLU PHE VAL          
SEQRES  10 B  226  VAL LEU VAL ASP GLU SER LYS LEU VAL LYS LYS LEU GLY          
SEQRES  11 B  226  GLU LYS PHE PRO ILE PRO VAL GLU VAL ILE PRO SER ALA          
SEQRES  12 B  226  TYR ARG VAL VAL ILE ARG ALA LEU SER GLU MET GLY GLY          
SEQRES  13 B  226  GLU ALA VAL ILE ARG LEU GLY ASP ARG LYS ARG GLY PRO          
SEQRES  14 B  226  VAL ILE THR ASP ASN GLY ASN MET ILE ILE ASP VAL PHE          
SEQRES  15 B  226  MET ASN ILE ASP ASP ALA ILE GLU LEU GLU LYS GLU ILE          
SEQRES  16 B  226  ASN ASN ILE PRO GLY VAL VAL GLU ASN GLY ILE PHE THR          
SEQRES  17 B  226  LYS VAL ASP LYS VAL LEU VAL GLY THR LYS LYS GLY VAL          
SEQRES  18 B  226  LYS THR LEU LYS LYS                                          
SEQRES   1 C  226  MET SER ASN GLU ASP LEU LYS LEU LYS VAL ALA LYS GLU          
SEQRES   2 C  226  ALA VAL LYS LEU VAL LYS ASP GLY MET VAL ILE GLY LEU          
SEQRES   3 C  226  GLY THR GLY SER THR ALA ALA LEU PHE ILE ARG GLU LEU          
SEQRES   4 C  226  GLY ASN ARG ILE ARG GLU GLU GLU LEU THR VAL PHE GLY          
SEQRES   5 C  226  ILE PRO THR SER PHE GLU ALA LYS MET LEU ALA MET GLN          
SEQRES   6 C  226  TYR GLU ILE PRO LEU VAL THR LEU ASP GLU TYR ASP VAL          
SEQRES   7 C  226  ASP ILE ALA PHE ASP GLY ALA ASP GLU VAL GLU GLU THR          
SEQRES   8 C  226  THR LEU PHE LEU ILE LYS GLY GLY GLY GLY CYS HIS THR          
SEQRES   9 C  226  GLN GLU LYS ILE VAL ASP TYR ASN ALA ASN GLU PHE VAL          
SEQRES  10 C  226  VAL LEU VAL ASP GLU SER LYS LEU VAL LYS LYS LEU GLY          
SEQRES  11 C  226  GLU LYS PHE PRO ILE PRO VAL GLU VAL ILE PRO SER ALA          
SEQRES  12 C  226  TYR ARG VAL VAL ILE ARG ALA LEU SER GLU MET GLY GLY          
SEQRES  13 C  226  GLU ALA VAL ILE ARG LEU GLY ASP ARG LYS ARG GLY PRO          
SEQRES  14 C  226  VAL ILE THR ASP ASN GLY ASN MET ILE ILE ASP VAL PHE          
SEQRES  15 C  226  MET ASN ILE ASP ASP ALA ILE GLU LEU GLU LYS GLU ILE          
SEQRES  16 C  226  ASN ASN ILE PRO GLY VAL VAL GLU ASN GLY ILE PHE THR          
SEQRES  17 C  226  LYS VAL ASP LYS VAL LEU VAL GLY THR LYS LYS GLY VAL          
SEQRES  18 C  226  LYS THR LEU LYS LYS                                          
SEQRES   1 D  226  MET SER ASN GLU ASP LEU LYS LEU LYS VAL ALA LYS GLU          
SEQRES   2 D  226  ALA VAL LYS LEU VAL LYS ASP GLY MET VAL ILE GLY LEU          
SEQRES   3 D  226  GLY THR GLY SER THR ALA ALA LEU PHE ILE ARG GLU LEU          
SEQRES   4 D  226  GLY ASN ARG ILE ARG GLU GLU GLU LEU THR VAL PHE GLY          
SEQRES   5 D  226  ILE PRO THR SER PHE GLU ALA LYS MET LEU ALA MET GLN          
SEQRES   6 D  226  TYR GLU ILE PRO LEU VAL THR LEU ASP GLU TYR ASP VAL          
SEQRES   7 D  226  ASP ILE ALA PHE ASP GLY ALA ASP GLU VAL GLU GLU THR          
SEQRES   8 D  226  THR LEU PHE LEU ILE LYS GLY GLY GLY GLY CYS HIS THR          
SEQRES   9 D  226  GLN GLU LYS ILE VAL ASP TYR ASN ALA ASN GLU PHE VAL          
SEQRES  10 D  226  VAL LEU VAL ASP GLU SER LYS LEU VAL LYS LYS LEU GLY          
SEQRES  11 D  226  GLU LYS PHE PRO ILE PRO VAL GLU VAL ILE PRO SER ALA          
SEQRES  12 D  226  TYR ARG VAL VAL ILE ARG ALA LEU SER GLU MET GLY GLY          
SEQRES  13 D  226  GLU ALA VAL ILE ARG LEU GLY ASP ARG LYS ARG GLY PRO          
SEQRES  14 D  226  VAL ILE THR ASP ASN GLY ASN MET ILE ILE ASP VAL PHE          
SEQRES  15 D  226  MET ASN ILE ASP ASP ALA ILE GLU LEU GLU LYS GLU ILE          
SEQRES  16 D  226  ASN ASN ILE PRO GLY VAL VAL GLU ASN GLY ILE PHE THR          
SEQRES  17 D  226  LYS VAL ASP LYS VAL LEU VAL GLY THR LYS LYS GLY VAL          
SEQRES  18 D  226  LYS THR LEU LYS LYS                                          
HET     CL  A 231       1                                                       
HET     CL  B 231       1                                                       
HET     CL  C 231       1                                                       
HET     CL  D 231       1                                                       
HET    PGO  A 234       5                                                       
HET    PGO  A 236       5                                                       
HET    PGO  B 335       5                                                       
HET    PGO  D 234       5                                                       
HET    PGO  C 235       5                                                       
HET    PGO  D 235       5                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     PGO 1,2-PROPANEDIOL                                                  
FORMUL   5   CL    4(CL 1-)                                                     
FORMUL   9  PGO    6(C3 H8 O2)                                                  
FORMUL  15  HOH   *957(H2 O)                                                    
CRYST1   54.856  100.273   80.465  90.00  92.54  90.00 P 1 21 1      8          
ATOM      1  N   SER A   2      -3.056  26.211  13.807  1.00 30.24           N  
ATOM      2  CA  SER A   2      -1.609  25.951  14.008  1.00 28.10           C  
ATOM      3  C   SER A   2      -0.766  26.733  13.004  1.00 27.31           C  
ATOM      4  O   SER A   2       0.169  26.200  12.410  1.00 27.02           O  
ATOM      5  CB  SER A   2      -1.349  24.459  13.922  1.00 28.97           C  
ATOM      6  OG  SER A   2      -2.073  23.895  12.866  1.00 32.17           O  
ATOM      7  N   ASN A   3      -1.118  28.009  12.834  1.00 25.52           N  
ATOM      8  CA  ASN A   3      -0.288  28.977  12.116  1.00 24.45           C  
ATOM      9  C   ASN A   3       0.046  28.546  10.708  1.00 22.46           C  
ATOM     10  O   ASN A   3       1.160  28.740  10.255  1.00 20.63           O  
ATOM     11  CB  ASN A   3       1.001  29.218  12.902  1.00 24.66           C  
ATOM     12  CG  ASN A   3       0.727  29.652  14.327  1.00 25.95           C  
ATOM     13  OD1 ASN A   3       0.977  28.904  15.286  1.00 28.80           O  
ATOM     14  ND2 ASN A   3       0.175  30.839  14.477  1.00 25.01           N  
ATOM     15  N   GLU A   4      -0.921  27.928  10.025  1.00 21.02           N  
ATOM     16  CA  GLU A   4      -0.664  27.359   8.711  1.00 20.97           C  
ATOM     17  C   GLU A   4      -0.235  28.397   7.728  1.00 19.50           C  
ATOM     18  O   GLU A   4       0.570  28.108   6.844  1.00 18.36           O  
ATOM     19  CB  GLU A   4      -1.909  26.670   8.130  1.00 22.70           C  
ATOM     20  CG  GLU A   4      -2.030  25.236   8.533  1.00 25.51           C  
ATOM     21  CD  GLU A   4      -2.085  25.077  10.016  1.00 28.69           C  
ATOM     22  OE1 GLU A   4      -2.742  25.912  10.688  1.00 30.84           O  
ATOM     23  OE2 GLU A   4      -1.467  24.121  10.517  1.00 33.07           O  
ATOM     24  N   ASP A   5      -0.811  29.597   7.854  1.00 18.45           N  
ATOM     25  CA  ASP A   5      -0.488  30.677   6.937  0.70 18.86           C  
ATOM     27  C   ASP A   5       0.982  31.078   7.088  1.00 17.21           C  
ATOM     28  O   ASP A   5       1.670  31.291   6.097  1.00 16.80           O  
ATOM     29  CB  ASP A   5      -1.417  31.882   7.151  0.70 20.20           C  
ATOM     31  CG  ASP A   5      -2.895  31.540   6.948  0.70 24.59           C  
ATOM     33  OD1 ASP A   5      -3.232  30.776   6.002  0.70 30.74           O  
ATOM     35  OD2 ASP A   5      -3.729  32.050   7.736  0.70 31.21           O  
ATOM     37  N   LEU A   6       1.460  31.148   8.335  1.00 16.11           N  
ATOM     38  CA  LEU A   6       2.851  31.525   8.607  1.00 15.62           C  
ATOM     39  C   LEU A   6       3.818  30.431   8.142  1.00 14.39           C  
ATOM     40  O   LEU A   6       4.917  30.715   7.637  1.00 13.88           O  
ATOM     41  CB  LEU A   6       3.045  31.833  10.096  1.00 15.46           C  
ATOM     42  CG  LEU A   6       2.174  32.996  10.613  1.00 14.83           C  
ATOM     43  CD1 LEU A   6       2.482  33.371  12.044  1.00 15.41           C  
ATOM     44  CD2 LEU A   6       2.274  34.221   9.673  1.00 16.51           C  
ATOM     45  N   LYS A   7       3.408  29.176   8.309  1.00 13.20           N  
ATOM     46  CA  LYS A   7       4.219  28.061   7.858  1.00 14.17           C  
ATOM     47  C   LYS A   7       4.361  28.037   6.354  1.00 13.46           C  
ATOM     48  O   LYS A   7       5.438  27.799   5.827  1.00 12.89           O  
ATOM     49  CB  LYS A   7       3.627  26.742   8.346  1.00 13.31           C  
ATOM     50  CG  LYS A   7       3.713  26.538   9.814  1.00 14.05           C  
ATOM     51  CD  LYS A   7       2.935  25.260  10.164  1.00 16.04           C  
ATOM     52  CE  LYS A   7       2.946  24.931  11.602  1.00 17.29           C  
ATOM     53  NZ  LYS A   7       2.065  23.769  11.865  1.00 16.60           N  
ATOM     54  N   LEU A   8       3.264  28.289   5.652  1.00 15.44           N  
ATOM     55  CA  LEU A   8       3.308  28.340   4.205  1.00 15.18           C  
ATOM     56  C   LEU A   8       4.200  29.483   3.706  1.00 15.21           C  
ATOM     57  O   LEU A   8       4.937  29.336   2.733  1.00 14.58           O  
ATOM     58  CB  LEU A   8       1.889  28.481   3.647  1.00 16.20           C  
ATOM     59  CG  LEU A   8       1.746  28.452   2.122  1.00 16.37           C  
ATOM     60  CD1 LEU A   8       2.249  27.118   1.577  1.00 17.35           C  
ATOM     61  CD2 LEU A   8       0.293  28.717   1.723  1.00 16.55           C  
ATOM     62  N   LYS A   9       4.083  30.640   4.359  1.00 15.93           N  
ATOM     63  CA  LYS A   9       4.882  31.814   4.018  0.50 15.58           C  
ATOM     65  C   LYS A   9       6.378  31.507   4.120  1.00 15.05           C  
ATOM     66  O   LYS A   9       7.153  31.847   3.220  1.00 14.95           O  
ATOM     67  CB  LYS A   9       4.544  33.015   4.937  0.50 16.39           C  
ATOM     69  CG  LYS A   9       3.198  33.679   4.657  0.50 16.55           C  
ATOM     71  CD  LYS A   9       3.217  35.198   4.875  0.50 18.05           C  
ATOM     73  CE  LYS A   9       3.420  35.555   6.311  0.50 18.29           C  
ATOM     75  NZ  LYS A   9       2.964  36.953   6.583  0.50 17.54           N  
ATOM     77  N   VAL A  10       6.799  30.872   5.213  1.00 14.77           N  
ATOM     78  CA  VAL A  10       8.217  30.574   5.392  0.50 14.50           C  
ATOM     80  C   VAL A  10       8.701  29.560   4.348  1.00 14.52           C  
ATOM     81  O   VAL A  10       9.797  29.686   3.837  1.00 13.97           O  
ATOM     82  CB  VAL A  10       8.550  30.079   6.809  0.50 14.64           C  
ATOM     84  CG1 VAL A  10      10.032  30.324   7.130  0.50 12.80           C  
ATOM     86  CG2 VAL A  10       7.733  30.795   7.796  0.50 13.99           C  
ATOM     88  N   ALA A  11       7.873  28.564   4.051  1.00 14.57           N  
ATOM     89  CA  ALA A  11       8.208  27.552   3.039  1.00 15.03           C  
ATOM     90  C   ALA A  11       8.418  28.186   1.660  1.00 15.44           C  
ATOM     91  O   ALA A  11       9.373  27.868   0.948  1.00 13.83           O  
ATOM     92  CB  ALA A  11       7.103  26.519   2.968  1.00 13.54           C  
ATOM     93  N   LYS A  12       7.502  29.081   1.282  1.00 15.73           N  
ATOM     94  CA  LYS A  12       7.588  29.759   0.008  1.00 17.83           C  
ATOM     95  C   LYS A  12       8.835  30.635  -0.089  1.00 17.88           C  
ATOM     96  O   LYS A  12       9.448  30.741  -1.147  1.00 18.55           O  
ATOM     97  CB  LYS A  12       6.323  30.574  -0.257  1.00 18.15           C  
ATOM     98  CG  LYS A  12       5.115  29.713  -0.487  1.00 20.15           C  
ATOM     99  CD  LYS A  12       3.881  30.505  -0.907  1.00 21.77           C  
ATOM    100  CE  LYS A  12       2.731  29.567  -1.248  1.00 24.02           C  
ATOM    101  NZ  LYS A  12       2.916  28.889  -2.583  1.00 29.52           N  
ATOM    102  N   GLU A  13       9.222  31.261   1.013  1.00 18.01           N  
ATOM    103  CA  GLU A  13      10.404  32.109   1.006  1.00 17.56           C  
ATOM    104  C   GLU A  13      11.650  31.237   1.002  1.00 16.46           C  
ATOM    105  O   GLU A  13      12.606  31.482   0.247  1.00 16.29           O  
ATOM    106  CB  GLU A  13      10.360  33.065   2.210  1.00 18.09           C  
ATOM    107  CG  GLU A  13      11.422  34.103   2.240  1.00 21.06           C  
ATOM    108  CD  GLU A  13      11.365  35.056   1.034  1.00 24.78           C  
ATOM    109  OE1 GLU A  13      10.288  35.220   0.381  1.00 27.36           O  
ATOM    110  OE2 GLU A  13      12.442  35.585   0.731  1.00 28.37           O  
ATOM    111  N   ALA A  14      11.646  30.196   1.825  1.00 15.37           N  
ATOM    112  CA  ALA A  14      12.805  29.317   1.887  1.00 15.52           C  
ATOM    113  C   ALA A  14      13.190  28.714   0.542  1.00 14.36           C  
ATOM    114  O   ALA A  14      14.358  28.568   0.259  1.00 15.42           O  
ATOM    115  CB  ALA A  14      12.541  28.173   2.899  1.00 14.66           C  
ATOM    116  N   VAL A  15      12.205  28.309  -0.252  1.00 15.19           N  
ATOM    117  CA  VAL A  15      12.462  27.586  -1.525  1.00 15.54           C  
ATOM    118  C   VAL A  15      13.260  28.436  -2.527  1.00 15.86           C  
ATOM    119  O   VAL A  15      13.936  27.914  -3.404  1.00 14.48           O  
ATOM    120  CB  VAL A  15      11.147  27.036  -2.141  1.00 15.03           C  
ATOM    121  CG1 VAL A  15      10.341  28.155  -2.830  1.00 16.45           C  
ATOM    122  CG2 VAL A  15      11.435  25.849  -3.089  1.00 15.66           C  
ATOM    123  N   LYS A  16      13.209  29.747  -2.338  1.00 16.46           N  
ATOM    124  CA  LYS A  16      13.926  30.685  -3.180  1.00 17.29           C  
ATOM    125  C   LYS A  16      15.433  30.579  -2.969  1.00 16.99           C  
ATOM    126  O   LYS A  16      16.197  30.991  -3.814  1.00 17.96           O  
ATOM    127  CB  LYS A  16      13.456  32.131  -2.883  1.00 17.48           C  
ATOM    128  CG  LYS A  16      11.959  32.405  -3.064  1.00 19.08           C  
ATOM    129  CD  LYS A  16      11.621  33.855  -2.726  1.00 20.80           C  
ATOM    130  CE  LYS A  16      10.139  34.148  -2.879  1.00 22.94           C  
ATOM    131  NZ  LYS A  16       9.847  35.558  -2.449  1.00 27.03           N  
ATOM    132  N   LEU A  17      15.873  30.053  -1.829  1.00 16.18           N  
ATOM    133  CA  LEU A  17      17.291  29.886  -1.557  1.00 16.27           C  
ATOM    134  C   LEU A  17      17.944  28.735  -2.340  1.00 16.53           C  
ATOM    135  O   LEU A  17      19.184  28.677  -2.454  1.00 17.71           O  
ATOM    136  CB  LEU A  17      17.532  29.711  -0.050  1.00 16.21           C  
ATOM    137  CG  LEU A  17      17.007  30.779   0.919  1.00 17.41           C  
ATOM    138  CD1 LEU A  17      17.160  30.273   2.388  1.00 15.40           C  
ATOM    139  CD2 LEU A  17      17.739  32.090   0.734  1.00 19.18           C  
ATOM    140  N   VAL A  18      17.131  27.815  -2.855  1.00 15.86           N  
ATOM    141  CA  VAL A  18      17.643  26.658  -3.555  1.00 16.22           C  
ATOM    142  C   VAL A  18      18.165  27.089  -4.898  1.00 17.21           C  
ATOM    143  O   VAL A  18      17.512  27.873  -5.578  1.00 17.87           O  
ATOM    144  CB  VAL A  18      16.563  25.610  -3.751  1.00 16.35           C  
ATOM    145  CG1 VAL A  18      17.061  24.450  -4.658  1.00 14.84           C  
ATOM    146  CG2 VAL A  18      16.054  25.137  -2.359  1.00 15.93           C  
ATOM    147  N   LYS A  19      19.349  26.602  -5.237  1.00 18.14           N  
ATOM    148  CA  LYS A  19      19.966  26.843  -6.556  1.00 19.16           C  
ATOM    149  C   LYS A  19      20.056  25.546  -7.336  1.00 19.44           C  
ATOM    150  O   LYS A  19      20.245  24.445  -6.768  1.00 19.29           O  
ATOM    151  CB  LYS A  19      21.381  27.393  -6.389  1.00 19.73           C  
ATOM    152  CG  LYS A  19      21.474  28.596  -5.458  1.00 21.97           C  
ATOM    153  CD  LYS A  19      20.672  29.793  -5.977  1.00 23.87           C  
ATOM    154  CE  LYS A  19      21.116  31.077  -5.297  1.00 25.44           C  
ATOM    155  NZ  LYS A  19      20.095  32.158  -5.515  1.00 27.41           N  
ATOM    156  N   ASP A  20      19.973  25.672  -8.656  1.00 20.02           N  
ATOM    157  CA  ASP A  20      20.141  24.536  -9.543  1.00 19.93           C  
ATOM    158  C   ASP A  20      21.441  23.805  -9.260  1.00 18.89           C  
ATOM    159  O   ASP A  20      22.460  24.438  -9.035  1.00 20.17           O  
ATOM    160  CB  ASP A  20      20.114  25.018 -11.003  1.00 20.84           C  
ATOM    161  CG  ASP A  20      19.887  23.890 -11.986  1.00 23.25           C  
ATOM    162  OD1 ASP A  20      19.575  22.735 -11.582  1.00 28.90           O  
ATOM    163  OD2 ASP A  20      20.025  24.169 -13.193  1.00 29.73           O  
ATOM    164  N   GLY A  21      21.387  22.473  -9.212  1.00 17.86           N  
ATOM    165  CA  GLY A  21      22.575  21.643  -8.966  1.00 17.27           C  
ATOM    166  C   GLY A  21      22.808  21.263  -7.512  1.00 16.66           C  
ATOM    167  O   GLY A  21      23.695  20.466  -7.205  1.00 17.48           O  
ATOM    168  N   MET A  22      22.024  21.845  -6.618  1.00 15.99           N  
ATOM    169  CA  MET A  22      22.170  21.578  -5.175  1.00 14.97           C  
ATOM    170  C   MET A  22      21.584  20.230  -4.757  1.00 14.19           C  
ATOM    171  O   MET A  22      20.661  19.678  -5.419  1.00 13.04           O  
ATOM    172  CB  MET A  22      21.514  22.672  -4.333  1.00 14.87           C  
ATOM    173  CG  MET A  22      22.344  23.910  -4.136  1.00 15.71           C  
ATOM    174  SD  MET A  22      21.545  25.123  -3.073  1.00 16.05           S  
ATOM    175  CE  MET A  22      22.843  26.369  -3.037  1.00 15.32           C  
ATOM    176  N   VAL A  23      22.152  19.718  -3.658  1.00 12.43           N  
ATOM    177  CA  VAL A  23      21.611  18.606  -2.885  1.00 12.03           C  
ATOM    178  C   VAL A  23      21.028  19.245  -1.620  1.00 11.63           C  
ATOM    179  O   VAL A  23      21.729  19.933  -0.868  1.00 11.44           O  
ATOM    180  CB  VAL A  23      22.687  17.563  -2.502  1.00 12.22           C  
ATOM    181  CG1 VAL A  23      22.082  16.433  -1.652  1.00 10.59           C  
ATOM    182  CG2 VAL A  23      23.322  16.953  -3.781  1.00 13.30           C  
ATOM    183  N   ILE A  24      19.732  19.028  -1.419  1.00 10.97           N  
ATOM    184  CA  ILE A  24      18.993  19.682  -0.372  1.00 10.33           C  
ATOM    185  C   ILE A  24      18.540  18.657   0.689  1.00 10.33           C  
ATOM    186  O   ILE A  24      17.957  17.610   0.368  1.00 10.29           O  
ATOM    187  CB  ILE A  24      17.783  20.384  -0.916  1.00 10.96           C  
ATOM    188  CG1 ILE A  24      18.183  21.413  -2.000  1.00 11.72           C  
ATOM    189  CG2 ILE A  24      16.988  21.020   0.240  1.00  9.81           C  
ATOM    190  CD1 ILE A  24      19.090  22.484  -1.524  1.00 10.32           C  
ATOM    191  N   GLY A  25      18.834  18.965   1.941  1.00  9.07           N  
ATOM    192  CA  GLY A  25      18.389  18.174   3.071  1.00  9.50           C  
ATOM    193  C   GLY A  25      16.916  18.437   3.342  1.00  9.63           C  
ATOM    194  O   GLY A  25      16.498  19.591   3.484  1.00  9.29           O  
ATOM    195  N   LEU A  26      16.115  17.374   3.396  1.00  9.07           N  
ATOM    196  CA  LEU A  26      14.662  17.497   3.531  1.00  8.84           C  
ATOM    197  C   LEU A  26      14.214  17.154   4.928  1.00  9.74           C  
ATOM    198  O   LEU A  26      14.257  15.987   5.351  1.00  9.72           O  
ATOM    199  CB  LEU A  26      13.920  16.593   2.518  1.00  9.44           C  
ATOM    200  CG  LEU A  26      14.372  16.728   1.072  1.00  9.28           C  
ATOM    201  CD1 LEU A  26      13.536  15.749   0.162  1.00 12.14           C  
ATOM    202  CD2 LEU A  26      14.323  18.182   0.541  1.00 10.20           C  
ATOM    203  N   GLY A  27      13.753  18.187   5.632  1.00  8.78           N  
ATOM    204  CA  GLY A  27      13.377  18.069   7.018  1.00  9.30           C  
ATOM    205  C   GLY A  27      12.054  17.349   7.238  1.00  8.74           C  
ATOM    206  O   GLY A  27      11.407  16.884   6.299  1.00  9.60           O  
ATOM    207  N   THR A  28      11.658  17.279   8.494  1.00  9.78           N  
ATOM    208  CA  THR A  28      10.480  16.540   8.942  1.00  9.36           C  
ATOM    209  C   THR A  28       9.576  17.466   9.730  1.00  9.19           C  
ATOM    210  O   THR A  28      10.050  18.425  10.366  1.00  9.07           O  
ATOM    211  CB  THR A  28      10.972  15.333   9.807  1.00  9.24           C  
ATOM    212  OG1 THR A  28      11.810  14.503   8.986  1.00 10.90           O  
ATOM    213  CG2 THR A  28       9.802  14.464  10.416  1.00  9.72           C  
ATOM    214  N   GLY A  29       8.281  17.180   9.694  1.00  9.12           N  
ATOM    215  CA  GLY A  29       7.276  17.982  10.400  1.00 10.02           C  
ATOM    216  C   GLY A  29       6.469  18.813   9.437  1.00  9.90           C  
ATOM    217  O   GLY A  29       6.747  18.856   8.231  1.00 10.41           O  
ATOM    218  N   SER A  30       5.435  19.449   9.969  1.00 10.35           N  
ATOM    219  CA  SER A  30       4.453  20.148   9.152  1.00 11.22           C  
ATOM    220  C   SER A  30       5.061  21.270   8.305  1.00 11.42           C  
ATOM    221  O   SER A  30       4.713  21.412   7.137  1.00 10.94           O  
ATOM    222  CB  SER A  30       3.266  20.644   9.989  1.00 11.35           C  
ATOM    223  OG  SER A  30       3.648  21.674  10.862  1.00 15.91           O  
ATOM    224  N   THR A  31       5.975  22.052   8.886  1.00 11.54           N  
ATOM    225  CA  THR A  31       6.576  23.180   8.152  1.00 10.94           C  
ATOM    226  C   THR A  31       7.521  22.676   7.053  1.00 10.94           C  
ATOM    227  O   THR A  31       7.474  23.138   5.905  1.00 10.94           O  
ATOM    228  CB  THR A  31       7.294  24.161   9.092  1.00 10.83           C  
ATOM    229  OG1 THR A  31       6.428  24.495  10.181  1.00 11.01           O  
ATOM    230  CG2 THR A  31       7.789  25.438   8.297  1.00 10.98           C  
ATOM    231  N   ALA A  32       8.366  21.698   7.391  1.00 11.17           N  
ATOM    232  CA  ALA A  32       9.242  21.088   6.408  1.00 10.52           C  
ATOM    233  C   ALA A  32       8.432  20.428   5.288  1.00 11.04           C  
ATOM    234  O   ALA A  32       8.832  20.517   4.115  1.00  9.85           O  
ATOM    235  CB  ALA A  32      10.202  20.098   7.061  1.00 10.95           C  
ATOM    236  N   ALA A  33       7.281  19.812   5.637  1.00 10.58           N  
ATOM    237  CA  ALA A  33       6.409  19.199   4.628  1.00 11.38           C  
ATOM    238  C   ALA A  33       5.965  20.208   3.550  1.00 11.11           C  
ATOM    239  O   ALA A  33       5.985  19.911   2.341  1.00 11.24           O  
ATOM    240  CB  ALA A  33       5.199  18.546   5.289  1.00 11.04           C  
ATOM    241  N   LEU A  34       5.535  21.380   3.993  1.00 11.43           N  
ATOM    242  CA  LEU A  34       5.157  22.472   3.067  1.00 11.72           C  
ATOM    243  C   LEU A  34       6.334  22.895   2.201  1.00 12.02           C  
ATOM    244  O   LEU A  34       6.177  23.157   0.989  1.00 12.70           O  
ATOM    245  CB  LEU A  34       4.583  23.654   3.850  1.00 12.32           C  
ATOM    246  CG  LEU A  34       3.256  23.421   4.563  1.00 13.64           C  
ATOM    247  CD1 LEU A  34       2.896  24.670   5.379  1.00 17.62           C  
ATOM    248  CD2 LEU A  34       2.123  23.034   3.621  1.00 16.01           C  
ATOM    249  N   PHE A  35       7.530  22.924   2.795  1.00 11.09           N  
ATOM    250  CA  PHE A  35       8.724  23.204   2.050  1.00 11.68           C  
ATOM    251  C   PHE A  35       8.976  22.152   0.972  1.00 11.32           C  
ATOM    252  O   PHE A  35       9.355  22.474  -0.176  1.00 11.23           O  
ATOM    253  CB  PHE A  35       9.976  23.308   2.963  1.00 11.41           C  
ATOM    254  CG  PHE A  35      11.258  23.405   2.179  1.00 11.83           C  
ATOM    255  CD1 PHE A  35      11.687  24.618   1.646  1.00  9.96           C  
ATOM    256  CD2 PHE A  35      12.001  22.281   1.905  1.00 11.59           C  
ATOM    257  CE1 PHE A  35      12.848  24.682   0.876  1.00 12.07           C  
ATOM    258  CE2 PHE A  35      13.156  22.339   1.138  1.00 11.03           C  
ATOM    259  CZ  PHE A  35      13.580  23.554   0.610  1.00 12.31           C  
ATOM    260  N   ILE A  36       8.790  20.884   1.333  1.00 10.90           N  
ATOM    261  CA  ILE A  36       9.048  19.807   0.347  1.00 11.40           C  
ATOM    262  C   ILE A  36       8.103  19.996  -0.858  1.00 11.67           C  
ATOM    263  O   ILE A  36       8.538  19.895  -2.025  1.00 12.27           O  
ATOM    264  CB  ILE A  36       8.968  18.384   1.005  1.00 11.42           C  
ATOM    265  CG1 ILE A  36      10.066  18.226   2.071  1.00  9.49           C  
ATOM    266  CG2 ILE A  36       9.087  17.268  -0.091  1.00  8.94           C  
ATOM    267  CD1 ILE A  36       9.981  16.871   2.836  1.00 10.84           C  
ATOM    268  N   ARG A  37       6.833  20.320  -0.592  1.00 12.19           N  
ATOM    269  CA  ARG A  37       5.864  20.572  -1.662  1.00 13.98           C  
ATOM    270  C   ARG A  37       6.359  21.713  -2.552  1.00 14.32           C  
ATOM    271  O   ARG A  37       6.429  21.575  -3.780  1.00 13.23           O  
ATOM    272  CB  ARG A  37       4.486  20.891  -1.092  1.00 13.48           C  
ATOM    273  CG  ARG A  37       3.456  21.092  -2.179  1.00 14.52           C  
ATOM    274  CD  ARG A  37       2.066  21.091  -1.657  1.00 17.31           C  
ATOM    275  NE  ARG A  37       1.850  22.245  -0.824  1.00 20.67           N  
ATOM    276  CZ  ARG A  37       0.723  22.509  -0.181  1.00 23.24           C  
ATOM    277  NH1 ARG A  37      -0.327  21.697  -0.286  1.00 24.29           N  
ATOM    278  NH2 ARG A  37       0.647  23.601   0.569  1.00 20.67           N  
ATOM    279  N   GLU A  38       6.771  22.817  -1.931  1.00 14.98           N  
ATOM    280  CA  GLU A  38       7.262  23.978  -2.696  1.00 15.76           C  
ATOM    281  C   GLU A  38       8.468  23.619  -3.532  1.00 15.50           C  
ATOM    282  O   GLU A  38       8.546  24.006  -4.687  1.00 14.74           O  
ATOM    283  CB  GLU A  38       7.625  25.171  -1.796  1.00 16.37           C  
ATOM    284  CG  GLU A  38       6.472  25.791  -1.041  1.00 18.57           C  
ATOM    285  CD  GLU A  38       5.375  26.309  -1.951  1.00 20.73           C  
ATOM    286  OE1 GLU A  38       5.691  26.730  -3.092  1.00 23.03           O  
ATOM    287  OE2 GLU A  38       4.206  26.254  -1.508  1.00 20.82           O  
ATOM    288  N   LEU A  39       9.408  22.870  -2.952  1.00 15.21           N  
ATOM    289  CA  LEU A  39      10.597  22.467  -3.660  1.00 15.48           C  
ATOM    290  C   LEU A  39      10.270  21.581  -4.877  1.00 15.36           C  
ATOM    291  O   LEU A  39      10.820  21.791  -5.971  1.00 15.22           O  
ATOM    292  CB  LEU A  39      11.578  21.731  -2.736  1.00 14.60           C  
ATOM    293  CG  LEU A  39      12.860  21.240  -3.410  1.00 15.34           C  
ATOM    294  CD1 LEU A  39      13.523  22.383  -4.245  1.00 14.13           C  
ATOM    295  CD2 LEU A  39      13.840  20.658  -2.390  1.00 15.92           C  
ATOM    296  N   GLY A  40       9.396  20.599  -4.677  1.00 16.11           N  
ATOM    297  CA  GLY A  40       8.982  19.729  -5.783  1.00 18.27           C  
ATOM    298  C   GLY A  40       8.342  20.541  -6.898  1.00 19.58           C  
ATOM    299  O   GLY A  40       8.642  20.332  -8.086  1.00 18.98           O  
ATOM    300  N   ASN A  41       7.483  21.486  -6.511  1.00 20.72           N  
ATOM    301  CA  ASN A  41       6.805  22.321  -7.494  0.80 21.55           C  
ATOM    303  C   ASN A  41       7.816  23.186  -8.265  1.00 21.16           C  
ATOM    304  O   ASN A  41       7.733  23.279  -9.497  1.00 21.54           O  
ATOM    305  CB  ASN A  41       5.679  23.118  -6.845  0.80 22.06           C  
ATOM    307  CG  ASN A  41       4.573  22.204  -6.211  0.80 24.03           C  
ATOM    309  OD1 ASN A  41       4.663  20.953  -6.210  0.80 29.65           O  
ATOM    311  ND2 ASN A  41       3.549  22.841  -5.640  0.80 24.61           N  
ATOM    313  N   ARG A  42       8.783  23.767  -7.565  1.00 21.28           N  
ATOM    314  CA  ARG A  42       9.836  24.544  -8.220  1.00 22.04           C  
ATOM    315  C   ARG A  42      10.712  23.701  -9.159  1.00 22.43           C  
ATOM    316  O   ARG A  42      11.041  24.113 -10.283  1.00 21.67           O  
ATOM    317  CB  ARG A  42      10.699  25.251  -7.175  1.00 22.76           C  
ATOM    318  CG  ARG A  42      11.393  26.416  -7.742  1.00 23.06           C  
ATOM    319  CD  ARG A  42      12.141  27.241  -6.744  1.00 23.04           C  
ATOM    320  NE  ARG A  42      13.082  27.959  -7.565  1.00 22.27           N  
ATOM    321  CZ  ARG A  42      14.321  28.263  -7.247  1.00 23.21           C  
ATOM    322  NH1 ARG A  42      14.802  28.011  -6.046  1.00 22.33           N  
ATOM    323  NH2 ARG A  42      15.069  28.854  -8.167  1.00 23.95           N  
ATOM    324  N   ILE A  43      11.078  22.497  -8.716  1.00 22.54           N  
ATOM    325  CA  ILE A  43      11.884  21.621  -9.558  1.00 23.37           C  
ATOM    326  C   ILE A  43      11.133  21.321 -10.861  1.00 24.13           C  
ATOM    327  O   ILE A  43      11.747  21.283 -11.918  1.00 24.22           O  
ATOM    328  CB  ILE A  43      12.262  20.305  -8.850  1.00 23.00           C  
ATOM    329  CG1 ILE A  43      13.243  20.594  -7.704  1.00 23.04           C  
ATOM    330  CG2 ILE A  43      12.881  19.287  -9.857  1.00 21.98           C  
ATOM    331  CD1 ILE A  43      13.640  19.351  -6.914  1.00 22.11           C  
ATOM    332  N   ARG A  44       9.818  21.119 -10.758  1.00 25.51           N  
ATOM    333  CA  ARG A  44       8.988  20.774 -11.903  1.00 27.11           C  
ATOM    334  C   ARG A  44       8.846  21.983 -12.837  1.00 27.91           C  
ATOM    335  O   ARG A  44       9.149  21.897 -14.030  1.00 28.74           O  
ATOM    336  CB  ARG A  44       7.611  20.303 -11.434  1.00 27.09           C  
ATOM    337  CG  ARG A  44       6.731  19.660 -12.525  1.00 27.92           C  
ATOM    338  CD  ARG A  44       5.786  18.640 -11.906  1.00 29.62           C  
ATOM    339  NE  ARG A  44       5.186  17.718 -12.876  0.50 30.58           N  
ATOM    340  CZ  ARG A  44       5.798  16.668 -13.427  0.50 31.55           C  
ATOM    341  NH1 ARG A  44       7.067  16.379 -13.139  0.50 31.84           N  
ATOM    342  NH2 ARG A  44       5.137  15.908 -14.288  0.50 31.15           N  
ATOM    343  N   GLU A  45       8.452  23.110 -12.257  1.00 28.93           N  
ATOM    344  CA  GLU A  45       8.115  24.327 -13.008  1.00 28.81           C  
ATOM    345  C   GLU A  45       9.323  24.987 -13.685  1.00 28.87           C  
ATOM    346  O   GLU A  45       9.168  25.618 -14.727  1.00 29.76           O  
ATOM    347  CB  GLU A  45       7.397  25.326 -12.083  1.00 29.34           C  
ATOM    348  CG  GLU A  45       6.389  26.235 -12.775  1.00 30.98           C  
ATOM    349  CD  GLU A  45       5.239  25.470 -13.401  0.50 32.16           C  
ATOM    350  OE1 GLU A  45       4.600  24.661 -12.694  0.50 33.08           O  
ATOM    351  OE2 GLU A  45       4.976  25.685 -14.599  0.50 33.96           O  
ATOM    352  N   GLU A  46      10.516  24.813 -13.120  1.00 28.00           N  
ATOM    353  CA  GLU A  46      11.744  25.403 -13.659  1.00 27.48           C  
ATOM    354  C   GLU A  46      12.729  24.386 -14.240  1.00 26.90           C  
ATOM    355  O   GLU A  46      13.804  24.765 -14.689  1.00 26.62           O  
ATOM    356  CB  GLU A  46      12.441  26.202 -12.567  1.00 27.38           C  
ATOM    357  CG  GLU A  46      11.507  27.168 -11.847  1.00 27.70           C  
ATOM    358  CD  GLU A  46      12.220  28.066 -10.853  1.00 27.70           C  
ATOM    359  OE1 GLU A  46      13.470  28.084 -10.826  1.00 27.51           O  
ATOM    360  OE2 GLU A  46      11.514  28.772 -10.111  1.00 28.01           O  
ATOM    361  N   GLU A  47      12.361  23.105 -14.218  1.00 26.31           N  
ATOM    362  CA  GLU A  47      13.223  22.008 -14.676  1.00 26.61           C  
ATOM    363  C   GLU A  47      14.627  22.058 -14.064  1.00 25.73           C  
ATOM    364  O   GLU A  47      15.635  22.034 -14.763  1.00 25.86           O  
ATOM    365  CB  GLU A  47      13.244  21.970 -16.217  1.00 26.85           C  
ATOM    366  CG  GLU A  47      11.820  21.791 -16.776  1.00 27.84           C  
ATOM    367  CD  GLU A  47      11.782  21.462 -18.273  1.00 29.83           C  
ATOM    368  OE1 GLU A  47      12.693  21.920 -19.012  1.00 32.76           O  
ATOM    369  OE2 GLU A  47      10.831  20.756 -18.696  1.00 32.70           O  
ATOM    370  N   LEU A  48      14.677  22.131 -12.735  1.00 24.79           N  
ATOM    371  CA  LEU A  48      15.957  22.149 -12.020  1.00 23.81           C  
ATOM    372  C   LEU A  48      16.502  20.751 -11.853  1.00 22.59           C  
ATOM    373  O   LEU A  48      15.744  19.775 -11.732  1.00 23.69           O  
ATOM    374  CB  LEU A  48      15.798  22.740 -10.626  1.00 23.56           C  
ATOM    375  CG  LEU A  48      15.147  24.104 -10.465  1.00 23.21           C  
ATOM    376  CD1 LEU A  48      15.253  24.497  -8.986  1.00 23.40           C  
ATOM    377  CD2 LEU A  48      15.789  25.162 -11.363  1.00 23.79           C  
ATOM    378  N   THR A  49      17.823  20.663 -11.816  1.00 20.81           N  
ATOM    379  CA  THR A  49      18.504  19.440 -11.469  1.00 19.40           C  
ATOM    380  C   THR A  49      18.899  19.604 -10.003  1.00 18.35           C  
ATOM    381  O   THR A  49      19.915  20.191  -9.704  1.00 17.99           O  
ATOM    382  CB  THR A  49      19.685  19.212 -12.368  1.00 20.61           C  
ATOM    383  OG1 THR A  49      19.205  19.162 -13.710  1.00 21.91           O  
ATOM    384  CG2 THR A  49      20.355  17.879 -12.047  1.00 20.85           C  
ATOM    385  N   VAL A  50      18.012  19.143  -9.119  1.00 16.58           N  
ATOM    386  CA  VAL A  50      18.194  19.246  -7.663  1.00 15.49           C  
ATOM    387  C   VAL A  50      17.840  17.884  -7.073  1.00 14.63           C  
ATOM    388  O   VAL A  50      16.863  17.247  -7.485  1.00 14.39           O  
ATOM    389  CB  VAL A  50      17.279  20.310  -7.050  1.00 16.15           C  
ATOM    390  CG1 VAL A  50      17.218  20.206  -5.483  1.00 15.75           C  
ATOM    391  CG2 VAL A  50      17.706  21.724  -7.510  1.00 17.01           C  
ATOM    392  N   PHE A  51      18.674  17.432  -6.154  1.00 13.12           N  
ATOM    393  CA  PHE A  51      18.461  16.169  -5.445  0.70 13.50           C  
ATOM    395  C   PHE A  51      18.168  16.454  -3.989  1.00 13.37           C  
ATOM    396  O   PHE A  51      18.538  17.521  -3.477  1.00 13.33           O  
ATOM    397  CB  PHE A  51      19.696  15.275  -5.470  0.70 14.30           C  
ATOM    399  CG  PHE A  51      20.127  14.813  -6.836  0.70 15.44           C  
ATOM    401  CD1 PHE A  51      19.267  14.826  -7.923  0.70 16.49           C  
ATOM    403  CD2 PHE A  51      21.416  14.327  -7.009  0.70 16.97           C  
ATOM    405  CE1 PHE A  51      19.681  14.378  -9.166  0.70 16.13           C  
ATOM    407  CE2 PHE A  51      21.844  13.874  -8.247  0.70 18.22           C  
ATOM    409  CZ  PHE A  51      20.968  13.906  -9.333  0.70 16.89           C  
ATOM    411  N   GLY A  52      17.523  15.497  -3.337  1.00 12.02           N  
ATOM    412  CA  GLY A  52      17.252  15.597  -1.910  1.00 12.33           C  
ATOM    413  C   GLY A  52      17.874  14.455  -1.107  1.00 11.45           C  
ATOM    414  O   GLY A  52      18.165  13.365  -1.641  1.00 11.10           O  
ATOM    415  N   ILE A  53      18.113  14.724   0.176  1.00 10.93           N  
ATOM    416  CA  ILE A  53      18.516  13.694   1.152  1.00 10.71           C  
ATOM    417  C   ILE A  53      17.510  13.837   2.306  1.00 10.39           C  
ATOM    418  O   ILE A  53      17.345  14.915   2.873  1.00 10.55           O  
ATOM    419  CB  ILE A  53      19.956  13.876   1.664  1.00 10.50           C  
ATOM    420  CG1 ILE A  53      20.955  13.591   0.524  1.00  9.99           C  
ATOM    421  CG2 ILE A  53      20.209  13.033   2.937  1.00 10.80           C  
ATOM    422  CD1 ILE A  53      22.416  13.840   0.864  1.00 10.22           C  
ATOM    423  N   PRO A  54      16.804  12.755   2.632  1.00 10.63           N  
ATOM    424  CA  PRO A  54      15.721  12.782   3.624  1.00  9.76           C  
ATOM    425  C   PRO A  54      16.227  12.664   5.059  1.00  9.12           C  
ATOM    426  O   PRO A  54      17.221  11.983   5.278  1.00  8.97           O  
ATOM    427  CB  PRO A  54      14.936  11.522   3.274  1.00 10.16           C  
ATOM    428  CG  PRO A  54      15.973  10.604   2.800  1.00 10.48           C  
ATOM    429  CD  PRO A  54      16.977  11.408   2.057  1.00 11.54           C  
ATOM    430  N   THR A  55      15.511  13.257   6.012  1.00  8.44           N  
ATOM    431  CA  THR A  55      15.782  13.130   7.441  1.00  8.62           C  
ATOM    432  C   THR A  55      14.865  12.114   8.122  1.00  8.95           C  
ATOM    433  O   THR A  55      14.924  11.934   9.322  1.00  8.24           O  
ATOM    434  CB  THR A  55      15.597  14.492   8.166  1.00  8.40           C  
ATOM    435  OG1 THR A  55      14.285  14.984   7.918  1.00  7.62           O  
ATOM    436  CG2 THR A  55      16.631  15.540   7.676  1.00 10.55           C  
ATOM    437  N   SER A  56      13.977  11.504   7.352  1.00  9.12           N  
ATOM    438  CA  SER A  56      12.946  10.603   7.888  1.00  9.11           C  
ATOM    439  C   SER A  56      12.257   9.835   6.803  1.00  8.66           C  
ATOM    440  O   SER A  56      12.286  10.247   5.628  1.00  7.58           O  
ATOM    441  CB  SER A  56      11.854  11.399   8.648  1.00  8.96           C  
ATOM    442  OG  SER A  56      11.165  12.327   7.759  1.00  8.53           O  
ATOM    443  N   PHE A  57      11.536   8.781   7.187  1.00  8.93           N  
ATOM    444  CA  PHE A  57      10.630   8.154   6.210  1.00  9.55           C  
ATOM    445  C   PHE A  57       9.511   9.094   5.737  1.00  9.37           C  
ATOM    446  O   PHE A  57       9.071   8.998   4.602  1.00 10.69           O  
ATOM    447  CB  PHE A  57      10.032   6.861   6.744  1.00 10.74           C  
ATOM    448  CG  PHE A  57      11.021   5.777   6.871  1.00 10.82           C  
ATOM    449  CD1 PHE A  57      11.719   5.346   5.766  1.00 13.93           C  
ATOM    450  CD2 PHE A  57      11.224   5.146   8.089  1.00 10.47           C  
ATOM    451  CE1 PHE A  57      12.655   4.315   5.883  1.00 14.83           C  
ATOM    452  CE2 PHE A  57      12.141   4.113   8.200  1.00 15.04           C  
ATOM    453  CZ  PHE A  57      12.866   3.721   7.104  1.00 11.76           C  
ATOM    454  N   GLU A  58       9.075  10.017   6.593  1.00  9.64           N  
ATOM    455  CA  GLU A  58       8.116  11.044   6.159  1.00 10.25           C  
ATOM    456  C   GLU A  58       8.707  11.814   4.983  1.00  9.82           C  
ATOM    457  O   GLU A  58       8.046  11.983   3.973  1.00 10.28           O  
ATOM    458  CB  GLU A  58       7.772  12.036   7.277  1.00  9.89           C  
ATOM    459  CG  GLU A  58       7.107  13.325   6.748  1.00 11.50           C  
ATOM    460  CD  GLU A  58       6.590  14.217   7.819  1.00 14.02           C  
ATOM    461  OE1 GLU A  58       5.524  13.942   8.353  1.00 22.46           O  
ATOM    462  OE2 GLU A  58       7.242  15.209   8.126  1.00 18.74           O  
ATOM    463  N   ALA A  59       9.929  12.310   5.139  1.00  9.95           N  
ATOM    464  CA  ALA A  59      10.591  13.104   4.095  1.00 10.83           C  
ATOM    465  C   ALA A  59      10.780  12.302   2.835  1.00 10.50           C  
ATOM    466  O   ALA A  59      10.625  12.818   1.751  1.00 10.25           O  
ATOM    467  CB  ALA A  59      11.942  13.675   4.583  1.00  9.86           C  
ATOM    468  N   LYS A  60      11.096  11.012   2.981  1.00 11.42           N  
ATOM    469  CA  LYS A  60      11.249  10.148   1.820  1.00 12.23           C  
ATOM    470  C   LYS A  60       9.928  10.011   1.054  1.00 12.02           C  
ATOM    471  O   LYS A  60       9.899  10.142  -0.171  1.00 12.10           O  
ATOM    472  CB  LYS A  60      11.761   8.790   2.315  1.00 12.63           C  
ATOM    473  CG  LYS A  60      12.042   7.784   1.268  1.00 15.07           C  
ATOM    474  CD  LYS A  60      12.675   6.523   1.881  0.50 14.17           C  
ATOM    475  CE  LYS A  60      12.372   5.297   1.050  0.50 14.57           C  
ATOM    476  NZ  LYS A  60      13.581   4.426   0.779  0.50 18.29           N  
ATOM    477  N   MET A  61       8.840   9.770   1.777  1.00 11.67           N  
ATOM    478  CA  MET A  61       7.518   9.641   1.169  1.00 13.47           C  
ATOM    479  C   MET A  61       7.020  10.923   0.494  1.00 12.73           C  
ATOM    480  O   MET A  61       6.462  10.903  -0.616  1.00 12.61           O  
ATOM    481  CB  MET A  61       6.506   9.145   2.192  1.00 13.01           C  
ATOM    482  CG  MET A  61       6.735   7.705   2.523  1.00 15.24           C  
ATOM    483  SD  MET A  61       5.594   7.072   3.741  1.00 20.65           S  
ATOM    484  CE  MET A  61       4.040   7.797   3.230  1.00 22.72           C  
ATOM    485  N   LEU A  62       7.217  12.054   1.147  1.00 13.09           N  
ATOM    486  CA  LEU A  62       6.854  13.335   0.534  1.00 13.24           C  
ATOM    487  C   LEU A  62       7.700  13.671  -0.693  1.00 12.94           C  
ATOM    488  O   LEU A  62       7.166  14.164  -1.688  1.00 13.40           O  
ATOM    489  CB  LEU A  62       6.956  14.451   1.563  1.00 13.28           C  
ATOM    490  CG  LEU A  62       5.914  14.391   2.667  1.00 15.57           C  
ATOM    491  CD1 LEU A  62       6.210  15.419   3.769  1.00 18.38           C  
ATOM    492  CD2 LEU A  62       4.517  14.620   2.079  1.00 18.84           C  
ATOM    493  N   ALA A  63       9.001  13.382  -0.656  1.00 12.90           N  
ATOM    494  CA  ALA A  63       9.864  13.538  -1.843  1.00 14.47           C  
ATOM    495  C   ALA A  63       9.378  12.688  -3.025  1.00 15.10           C  
ATOM    496  O   ALA A  63       9.392  13.134  -4.177  1.00 13.95           O  
ATOM    497  CB  ALA A  63      11.341  13.180  -1.511  1.00 14.81           C  
ATOM    498  N   MET A  64       8.984  11.450  -2.740  1.00 16.11           N  
ATOM    499  CA  MET A  64       8.370  10.589  -3.759  0.70 17.78           C  
ATOM    501  C   MET A  64       7.146  11.299  -4.348  1.00 17.14           C  
ATOM    502  O   MET A  64       7.004  11.434  -5.571  1.00 17.14           O  
ATOM    503  CB  MET A  64       7.952   9.238  -3.140  0.70 17.81           C  
ATOM    505  CG  MET A  64       9.094   8.269  -2.824  0.70 21.04           C  
ATOM    507  SD  MET A  64       8.723   6.975  -1.582  0.70 24.73           S  
ATOM    509  CE  MET A  64       7.446   6.070  -2.486  0.70 23.64           C  
ATOM    511  N   GLN A  65       6.270  11.753  -3.464  1.00 16.90           N  
ATOM    512  CA  GLN A  65       4.998  12.345  -3.833  1.00 17.75           C  
ATOM    513  C   GLN A  65       5.199  13.591  -4.714  1.00 17.66           C  
ATOM    514  O   GLN A  65       4.476  13.783  -5.716  1.00 17.25           O  
ATOM    515  CB  GLN A  65       4.201  12.686  -2.568  1.00 18.20           C  
ATOM    516  CG  GLN A  65       2.868  13.393  -2.861  1.00 18.57           C  
ATOM    517  CD  GLN A  65       2.038  13.669  -1.621  1.00 20.32           C  
ATOM    518  OE1 GLN A  65       2.356  13.217  -0.529  1.00 22.57           O  
ATOM    519  NE2 GLN A  65       0.938  14.396  -1.805  1.00 22.87           N  
ATOM    520  N   TYR A  66       6.210  14.393  -4.380  1.00 16.74           N  
ATOM    521  CA  TYR A  66       6.481  15.632  -5.118  1.00 17.09           C  
ATOM    522  C   TYR A  66       7.643  15.532  -6.105  1.00 17.08           C  
ATOM    523  O   TYR A  66       8.134  16.532  -6.575  1.00 18.21           O  
ATOM    524  CB  TYR A  66       6.631  16.798  -4.139  1.00 17.60           C  
ATOM    525  CG  TYR A  66       5.373  17.029  -3.328  1.00 17.58           C  
ATOM    526  CD1 TYR A  66       4.215  17.523  -3.934  1.00 18.89           C  
ATOM    527  CD2 TYR A  66       5.332  16.780  -1.981  1.00 17.89           C  
ATOM    528  CE1 TYR A  66       3.064  17.710  -3.232  1.00 18.60           C  
ATOM    529  CE2 TYR A  66       4.151  16.981  -1.249  1.00 18.81           C  
ATOM    530  CZ  TYR A  66       3.026  17.453  -1.900  1.00 19.31           C  
ATOM    531  OH  TYR A  66       1.829  17.672  -1.235  1.00 22.19           O  
ATOM    532  N   GLU A  67       8.055  14.305  -6.410  1.00 17.52           N  
ATOM    533  CA  GLU A  67       8.995  13.965  -7.479  1.00 17.73           C  
ATOM    534  C   GLU A  67      10.354  14.632  -7.327  1.00 17.34           C  
ATOM    535  O   GLU A  67      10.907  15.175  -8.287  1.00 19.17           O  
ATOM    536  CB  GLU A  67       8.366  14.257  -8.850  1.00 19.34           C  
ATOM    537  CG  GLU A  67       7.018  13.583  -9.017  1.00 21.10           C  
ATOM    538  CD  GLU A  67       6.488  13.656 -10.444  1.00 22.95           C  
ATOM    539  OE1 GLU A  67       6.364  14.770 -10.985  1.00 28.90           O  
ATOM    540  OE2 GLU A  67       6.177  12.578 -10.996  1.00 32.75           O  
ATOM    541  N   ILE A  68      10.893  14.586  -6.110  1.00 15.37           N  
ATOM    542  CA  ILE A  68      12.240  15.063  -5.831  1.00 14.49           C  
ATOM    543  C   ILE A  68      13.150  13.835  -5.792  1.00 13.34           C  
ATOM    544  O   ILE A  68      12.960  12.965  -4.949  1.00 11.88           O  
ATOM    545  CB  ILE A  68      12.311  15.750  -4.467  1.00 14.36           C  
ATOM    546  CG1 ILE A  68      11.313  16.916  -4.417  1.00 13.70           C  
ATOM    547  CG2 ILE A  68      13.761  16.162  -4.166  1.00 13.64           C  
ATOM    548  CD1 ILE A  68      11.227  17.596  -3.066  1.00 15.54           C  
ATOM    549  N   PRO A  69      14.121  13.751  -6.693  1.00 13.48           N  
ATOM    550  CA  PRO A  69      15.031  12.597  -6.693  1.00 14.00           C  
ATOM    551  C   PRO A  69      15.850  12.542  -5.416  1.00 13.23           C  
ATOM    552  O   PRO A  69      16.470  13.554  -5.059  1.00 14.09           O  
ATOM    553  CB  PRO A  69      15.947  12.879  -7.888  1.00 14.13           C  
ATOM    554  CG  PRO A  69      15.302  13.900  -8.666  1.00 16.10           C  
ATOM    555  CD  PRO A  69      14.486  14.718  -7.749  1.00 14.88           C  
ATOM    556  N   LEU A  70      15.875  11.382  -4.750  1.00 12.70           N  
ATOM    557  CA  LEU A  70      16.609  11.212  -3.500  1.00 12.80           C  
ATOM    558  C   LEU A  70      17.940  10.465  -3.653  1.00 12.29           C  
ATOM    559  O   LEU A  70      18.018   9.394  -4.279  1.00 11.31           O  
ATOM    560  CB  LEU A  70      15.774  10.465  -2.470  1.00 12.74           C  
ATOM    561  CG  LEU A  70      14.484  11.145  -2.041  1.00 13.02           C  
ATOM    562  CD1 LEU A  70      13.806  10.348  -0.960  1.00 15.23           C  
ATOM    563  CD2 LEU A  70      14.798  12.571  -1.541  1.00 14.84           C  
ATOM    564  N   VAL A  71      18.965  11.045  -3.052  1.00 11.49           N  
ATOM    565  CA  VAL A  71      20.273  10.421  -2.966  1.00 12.32           C  
ATOM    566  C   VAL A  71      20.593  10.210  -1.483  1.00 12.07           C  
ATOM    567  O   VAL A  71      19.728  10.419  -0.625  1.00 12.84           O  
ATOM    568  CB  VAL A  71      21.330  11.258  -3.708  1.00 12.46           C  
ATOM    569  CG1 VAL A  71      21.043  11.272  -5.230  1.00 11.89           C  
ATOM    570  CG2 VAL A  71      21.387  12.685  -3.139  1.00 11.82           C  
ATOM    571  N   THR A  72      21.817   9.792  -1.192  1.00 12.30           N  
ATOM    572  CA  THR A  72      22.211   9.388   0.166  1.00 13.21           C  
ATOM    573  C   THR A  72      23.359  10.238   0.685  1.00 12.36           C  
ATOM    574  O   THR A  72      24.260  10.592  -0.052  1.00 14.01           O  
ATOM    575  CB  THR A  72      22.610   7.869   0.230  1.00 13.18           C  
ATOM    576  OG1 THR A  72      23.761   7.605  -0.577  1.00 16.34           O  
ATOM    577  CG2 THR A  72      21.445   6.985  -0.252  1.00 15.17           C  
ATOM    578  N   LEU A  73      23.331  10.501   1.980  1.00 12.46           N  
ATOM    579  CA  LEU A  73      24.377  11.272   2.639  1.00 13.30           C  
ATOM    580  C   LEU A  73      25.697  10.505   2.577  1.00 14.82           C  
ATOM    581  O   LEU A  73      26.760  11.105   2.541  1.00 15.47           O  
ATOM    582  CB  LEU A  73      23.972  11.569   4.092  1.00 13.07           C  
ATOM    583  CG  LEU A  73      24.861  12.564   4.855  1.00 11.62           C  
ATOM    584  CD1 LEU A  73      24.745  13.973   4.260  1.00 14.00           C  
ATOM    585  CD2 LEU A  73      24.447  12.578   6.335  1.00 11.55           C  
ATOM    586  N   ASP A  74      25.622   9.177   2.514  1.00 16.92           N  
ATOM    587  CA  ASP A  74      26.828   8.355   2.385  1.00 17.86           C  
ATOM    588  C   ASP A  74      27.609   8.619   1.066  1.00 19.35           C  
ATOM    589  O   ASP A  74      28.823   8.337   0.971  1.00 22.02           O  
ATOM    590  CB  ASP A  74      26.466   6.879   2.609  1.00 19.11           C  
ATOM    591  CG  ASP A  74      26.266   6.518   4.119  1.00 22.92           C  
ATOM    592  OD1 ASP A  74      27.004   7.092   4.976  1.00 25.90           O  
ATOM    593  OD2 ASP A  74      25.383   5.668   4.452  1.00 26.59           O  
ATOM    594  N   GLU A  75      26.941   9.176   0.048  1.00 18.16           N  
ATOM    595  CA  GLU A  75      27.568   9.590  -1.199  1.00 17.38           C  
ATOM    596  C   GLU A  75      27.682  11.084  -1.472  1.00 17.55           C  
ATOM    597  O   GLU A  75      28.552  11.481  -2.242  1.00 18.98           O  
ATOM    598  CB  GLU A  75      26.808   8.975  -2.400  1.00 17.33           C  
ATOM    599  CG  GLU A  75      27.407   7.733  -2.930  1.00 18.67           C  
ATOM    600  CD  GLU A  75      26.786   7.293  -4.261  1.00 18.24           C  
ATOM    601  OE1 GLU A  75      25.635   7.681  -4.550  1.00 14.98           O  
ATOM    602  OE2 GLU A  75      27.462   6.521  -4.972  1.00 17.47           O  
ATOM    603  N   TYR A  76      26.781  11.910  -0.928  1.00 16.14           N  
ATOM    604  CA  TYR A  76      26.720  13.328  -1.241  1.00 15.24           C  
ATOM    605  C   TYR A  76      26.656  14.171   0.029  1.00 14.37           C  
ATOM    606  O   TYR A  76      25.961  13.834   0.961  1.00 13.67           O  
ATOM    607  CB  TYR A  76      25.481  13.694  -2.075  1.00 16.01           C  
ATOM    608  CG  TYR A  76      25.483  13.092  -3.457  1.00 15.86           C  
ATOM    609  CD1 TYR A  76      26.011  13.798  -4.535  1.00 19.40           C  
ATOM    610  CD2 TYR A  76      24.968  11.839  -3.686  1.00 15.58           C  
ATOM    611  CE1 TYR A  76      26.028  13.249  -5.842  1.00 20.46           C  
ATOM    612  CE2 TYR A  76      24.986  11.266  -4.983  1.00 17.29           C  
ATOM    613  CZ  TYR A  76      25.528  11.982  -6.048  1.00 19.60           C  
ATOM    614  OH  TYR A  76      25.551  11.436  -7.324  1.00 21.24           O  
ATOM    615  N   ASP A  77      27.374  15.278   0.021  1.00 14.10           N  
ATOM    616  CA  ASP A  77      27.171  16.312   1.040  1.00 13.95           C  
ATOM    617  C   ASP A  77      25.944  17.135   0.683  1.00 12.77           C  
ATOM    618  O   ASP A  77      25.506  17.193  -0.474  1.00 12.63           O  
ATOM    619  CB  ASP A  77      28.372  17.224   1.185  1.00 13.97           C  
ATOM    620  CG  ASP A  77      29.482  16.598   1.979  1.00 16.71           C  
ATOM    621  OD1 ASP A  77      29.196  16.014   3.060  1.00 16.49           O  
ATOM    622  OD2 ASP A  77      30.647  16.681   1.522  1.00 16.96           O  
ATOM    623  N   VAL A  78      25.386  17.752   1.708  1.00 11.98           N  
ATOM    624  CA  VAL A  78      24.219  18.580   1.581  1.00 11.55           C  
ATOM    625  C   VAL A  78      24.642  20.038   1.473  1.00 10.91           C  
ATOM    626  O   VAL A  78      25.371  20.554   2.318  1.00 11.55           O  
ATOM    627  CB  VAL A  78      23.258  18.370   2.801  1.00 10.85           C  
ATOM    628  CG1 VAL A  78      22.180  19.444   2.867  1.00 10.35           C  
ATOM    629  CG2 VAL A  78      22.653  16.929   2.766  1.00 11.07           C  
ATOM    630  N   ASP A  79      24.147  20.702   0.428  1.00 10.63           N  
ATOM    631  CA  ASP A  79      24.369  22.128   0.250  1.00 10.76           C  
ATOM    632  C   ASP A  79      23.584  22.928   1.291  1.00 10.58           C  
ATOM    633  O   ASP A  79      24.155  23.753   2.013  1.00 11.59           O  
ATOM    634  CB  ASP A  79      23.992  22.522  -1.171  1.00 11.80           C  
ATOM    635  CG  ASP A  79      24.958  21.975  -2.189  1.00 15.28           C  
ATOM    636  OD1 ASP A  79      26.120  22.437  -2.180  1.00 20.71           O  
ATOM    637  OD2 ASP A  79      24.587  21.087  -2.967  1.00 12.86           O  
ATOM    638  N   ILE A  80      22.271  22.719   1.332  1.00 10.02           N  
ATOM    639  CA  ILE A  80      21.409  23.384   2.306  1.00  9.83           C  
ATOM    640  C   ILE A  80      20.466  22.345   2.861  1.00  9.07           C  
ATOM    641  O   ILE A  80      19.805  21.652   2.098  1.00  8.95           O  
ATOM    642  CB  ILE A  80      20.578  24.563   1.726  1.00 10.08           C  
ATOM    643  CG1 ILE A  80      21.447  25.526   0.894  1.00 11.15           C  
ATOM    644  CG2 ILE A  80      19.883  25.339   2.894  1.00  9.64           C  
ATOM    645  CD1 ILE A  80      20.606  26.648   0.213  1.00 11.12           C  
ATOM    646  N   ALA A  81      20.399  22.244   4.190  1.00  9.04           N  
ATOM    647  CA  ALA A  81      19.377  21.442   4.869  1.00  9.06           C  
ATOM    648  C   ALA A  81      18.302  22.381   5.395  1.00  9.58           C  
ATOM    649  O   ALA A  81      18.620  23.335   6.101  1.00  9.75           O  
ATOM    650  CB  ALA A  81      19.978  20.619   6.026  1.00  8.65           C  
ATOM    651  N   PHE A  82      17.047  22.071   5.071  1.00  8.89           N  
ATOM    652  CA  PHE A  82      15.896  22.796   5.615  1.00  9.06           C  
ATOM    653  C   PHE A  82      15.144  21.899   6.598  1.00  9.37           C  
ATOM    654  O   PHE A  82      14.834  20.727   6.280  1.00  9.76           O  
ATOM    655  CB  PHE A  82      14.958  23.176   4.503  1.00  9.94           C  
ATOM    656  CG  PHE A  82      15.556  24.172   3.505  1.00 10.28           C  
ATOM    657  CD1 PHE A  82      15.426  25.543   3.689  1.00 13.13           C  
ATOM    658  CD2 PHE A  82      16.235  23.723   2.398  1.00 11.02           C  
ATOM    659  CE1 PHE A  82      15.980  26.443   2.758  1.00 12.59           C  
ATOM    660  CE2 PHE A  82      16.781  24.622   1.469  1.00 13.35           C  
ATOM    661  CZ  PHE A  82      16.636  25.970   1.652  1.00 10.89           C  
ATOM    662  N   ASP A  83      14.831  22.418   7.778  1.00  8.14           N  
ATOM    663  CA  ASP A  83      14.128  21.593   8.762  1.00  8.52           C  
ATOM    664  C   ASP A  83      13.350  22.471   9.728  1.00  9.23           C  
ATOM    665  O   ASP A  83      13.636  23.672   9.880  1.00  9.82           O  
ATOM    666  CB  ASP A  83      15.149  20.725   9.501  1.00  8.39           C  
ATOM    667  CG  ASP A  83      14.584  19.407  10.052  1.00  8.04           C  
ATOM    668  OD1 ASP A  83      13.353  19.175  10.105  1.00  8.41           O  
ATOM    669  OD2 ASP A  83      15.416  18.613  10.558  1.00  8.99           O  
ATOM    670  N   GLY A  84      12.363  21.877  10.383  1.00  9.38           N  
ATOM    671  CA  GLY A  84      11.564  22.596  11.395  1.00  8.96           C  
ATOM    672  C   GLY A  84      12.154  22.490  12.779  1.00  8.49           C  
ATOM    673  O   GLY A  84      13.249  21.919  12.986  1.00  8.82           O  
ATOM    674  N   ALA A  85      11.457  23.074  13.753  1.00  8.67           N  
ATOM    675  CA  ALA A  85      11.841  22.931  15.162  1.00  8.77           C  
ATOM    676  C   ALA A  85      10.626  23.083  16.073  1.00  9.31           C  
ATOM    677  O   ALA A  85       9.678  23.796  15.735  1.00  9.35           O  
ATOM    678  CB  ALA A  85      12.946  23.975  15.566  1.00  8.53           C  
ATOM    679  N   ASP A  86      10.681  22.429  17.236  1.00  8.77           N  
ATOM    680  CA  ASP A  86       9.627  22.528  18.250  1.00  9.56           C  
ATOM    681  C   ASP A  86       9.762  23.850  19.042  1.00  9.90           C  
ATOM    682  O   ASP A  86       8.761  24.443  19.480  1.00  9.59           O  
ATOM    683  CB  ASP A  86       9.727  21.360  19.202  1.00 10.81           C  
ATOM    684  CG  ASP A  86       9.505  20.024  18.499  1.00 13.50           C  
ATOM    685  OD1 ASP A  86       8.468  19.905  17.828  1.00 14.04           O  
ATOM    686  OD2 ASP A  86      10.394  19.143  18.577  1.00 18.80           O  
ATOM    687  N   GLU A  87      11.006  24.257  19.234  1.00  9.66           N  
ATOM    688  CA  GLU A  87      11.355  25.501  19.918  1.00 10.38           C  
ATOM    689  C   GLU A  87      12.633  26.079  19.332  1.00 10.91           C  
ATOM    690  O   GLU A  87      13.569  25.331  19.005  1.00  9.30           O  
ATOM    691  CB  GLU A  87      11.638  25.290  21.414  1.00 11.30           C  
ATOM    692  CG  GLU A  87      10.514  24.884  22.301  1.00 12.10           C  
ATOM    693  CD  GLU A  87      10.854  25.081  23.775  1.00 13.42           C  
ATOM    694  OE1 GLU A  87      12.059  25.065  24.174  1.00 14.56           O  
ATOM    695  OE2 GLU A  87       9.897  25.258  24.556  1.00 16.46           O  
ATOM    696  N   VAL A  88      12.679  27.408  19.223  1.00 10.63           N  
ATOM    697  CA  VAL A  88      13.897  28.152  18.864  1.00 10.80           C  
ATOM    698  C   VAL A  88      14.123  29.167  19.993  1.00 11.50           C  
ATOM    699  O   VAL A  88      13.245  30.015  20.216  1.00 11.19           O  
ATOM    700  CB  VAL A  88      13.758  28.909  17.525  1.00 10.69           C  
ATOM    701  CG1 VAL A  88      15.071  29.655  17.187  1.00 12.04           C  
ATOM    702  CG2 VAL A  88      13.319  27.980  16.361  1.00 10.93           C  
ATOM    703  N   GLU A  89      15.228  29.065  20.738  1.00 12.05           N  
ATOM    704  CA  GLU A  89      15.513  30.025  21.794  1.00 13.35           C  
ATOM    705  C   GLU A  89      15.986  31.353  21.172  1.00 13.65           C  
ATOM    706  O   GLU A  89      16.934  31.369  20.382  1.00 13.13           O  
ATOM    707  CB  GLU A  89      16.591  29.492  22.720  1.00 11.75           C  
ATOM    708  CG  GLU A  89      16.921  30.405  23.900  1.00 13.20           C  
ATOM    709  CD  GLU A  89      17.773  29.713  24.941  1.00 14.33           C  
ATOM    710  OE1 GLU A  89      18.927  29.323  24.611  1.00 16.39           O  
ATOM    711  OE2 GLU A  89      17.277  29.521  26.076  1.00 15.92           O  
ATOM    712  N   GLU A  90      15.323  32.450  21.526  1.00 15.31           N  
ATOM    713  CA  GLU A  90      15.550  33.748  20.864  1.00 18.21           C  
ATOM    714  C   GLU A  90      16.994  34.253  20.879  1.00 18.83           C  
ATOM    715  O   GLU A  90      17.510  34.734  19.864  1.00 21.21           O  
ATOM    716  CB  GLU A  90      14.606  34.835  21.452  1.00 19.15           C  
ATOM    717  CG  GLU A  90      13.153  34.707  21.071  1.00 22.01           C  
ATOM    718  CD  GLU A  90      12.202  35.501  22.002  1.00 23.31           C  
ATOM    719  OE1 GLU A  90      12.668  36.402  22.736  1.00 30.26           O  
ATOM    720  OE2 GLU A  90      10.972  35.206  22.010  1.00 32.03           O  
ATOM    721  N   THR A  91      17.683  34.148  21.993  1.00 19.91           N  
ATOM    722  CA  THR A  91      18.983  34.829  22.065  1.00 19.62           C  
ATOM    723  C   THR A  91      20.106  34.000  21.437  1.00 19.12           C  
ATOM    724  O   THR A  91      21.054  34.540  20.891  1.00 20.95           O  
ATOM    725  CB  THR A  91      19.303  35.214  23.515  1.00 20.52           C  
ATOM    726  OG1 THR A  91      18.979  34.126  24.391  1.00 23.64           O  
ATOM    727  CG2 THR A  91      18.489  36.459  23.921  1.00 22.49           C  
ATOM    728  N   THR A  92      19.960  32.686  21.473  1.00 17.20           N  
ATOM    729  CA  THR A  92      21.019  31.754  21.132  1.00 15.32           C  
ATOM    730  C   THR A  92      20.802  31.080  19.787  1.00 13.96           C  
ATOM    731  O   THR A  92      21.744  30.576  19.199  1.00 12.76           O  
ATOM    732  CB  THR A  92      21.061  30.646  22.195  1.00 15.36           C  
ATOM    733  OG1 THR A  92      19.749  30.070  22.301  1.00 13.92           O  
ATOM    734  CG2 THR A  92      21.483  31.216  23.578  1.00 15.74           C  
ATOM    735  N   LEU A  93      19.550  31.060  19.328  1.00 12.75           N  
ATOM    736  CA  LEU A  93      19.095  30.219  18.215  1.00 12.87           C  
ATOM    737  C   LEU A  93      19.298  28.700  18.471  1.00 12.31           C  
ATOM    738  O   LEU A  93      19.229  27.905  17.561  1.00 11.76           O  
ATOM    739  CB  LEU A  93      19.702  30.632  16.892  1.00 12.11           C  
ATOM    740  CG  LEU A  93      19.527  32.121  16.501  1.00 12.84           C  
ATOM    741  CD1 LEU A  93      20.073  32.377  15.063  1.00 14.22           C  
ATOM    742  CD2 LEU A  93      18.059  32.545  16.616  1.00 13.71           C  
ATOM    743  N   PHE A  94      19.483  28.306  19.723  1.00 11.88           N  
ATOM    744  CA  PHE A  94      19.432  26.900  20.047  1.00 11.45           C  
ATOM    745  C   PHE A  94      18.011  26.386  19.801  1.00 11.09           C  
ATOM    746  O   PHE A  94      17.037  27.140  19.882  1.00  8.89           O  
ATOM    747  CB  PHE A  94      19.841  26.671  21.501  1.00 12.54           C  
ATOM    748  CG  PHE A  94      21.258  27.065  21.829  1.00 13.51           C  
ATOM    749  CD1 PHE A  94      22.285  27.021  20.870  1.00 14.52           C  
ATOM    750  CD2 PHE A  94      21.589  27.382  23.141  1.00 14.77           C  
ATOM    751  CE1 PHE A  94      23.589  27.337  21.213  1.00 15.11           C  
ATOM    752  CE2 PHE A  94      22.913  27.698  23.478  1.00 15.64           C  
ATOM    753  CZ  PHE A  94      23.900  27.665  22.508  1.00 14.45           C  
ATOM    754  N   LEU A  95      17.896  25.097  19.497  1.00 10.28           N  
ATOM    755  CA  LEU A  95      16.599  24.461  19.208  1.00 10.54           C  
ATOM    756  C   LEU A  95      16.297  23.270  20.125  1.00  9.30           C  
ATOM    757  O   LEU A  95      17.213  22.628  20.619  1.00  9.25           O  
ATOM    758  CB  LEU A  95      16.590  23.887  17.773  1.00 10.63           C  
ATOM    759  CG  LEU A  95      17.372  24.629  16.681  1.00 10.03           C  
ATOM    760  CD1 LEU A  95      17.388  23.812  15.390  1.00 10.32           C  
ATOM    761  CD2 LEU A  95      16.733  26.007  16.485  1.00  7.77           C  
ATOM    762  N   ILE A  96      15.010  22.951  20.247  1.00  9.46           N  
ATOM    763  CA  ILE A  96      14.571  21.593  20.543  1.00  9.95           C  
ATOM    764  C   ILE A  96      13.869  21.073  19.291  1.00  9.14           C  
ATOM    765  O   ILE A  96      12.972  21.739  18.724  1.00  8.14           O  
ATOM    766  CB  ILE A  96      13.690  21.468  21.839  1.00  9.82           C  
ATOM    767  CG1 ILE A  96      14.564  21.726  23.078  1.00 11.99           C  
ATOM    768  CG2 ILE A  96      13.075  20.051  21.934  1.00 11.61           C  
ATOM    769  CD1 ILE A  96      13.840  21.749  24.412  1.00 11.99           C  
ATOM    770  N   LYS A  97      14.260  19.867  18.891  1.00  9.13           N  
ATOM    771  CA  LYS A  97      13.653  19.136  17.802  1.00  9.83           C  
ATOM    772  C   LYS A  97      13.354  17.713  18.280  1.00  9.85           C  
ATOM    773  O   LYS A  97      13.819  17.273  19.336  1.00  9.46           O  
ATOM    774  CB  LYS A  97      14.586  19.128  16.593  1.00 10.02           C  
ATOM    775  CG  LYS A  97      14.692  20.472  15.895  1.00  9.96           C  
ATOM    776  CD  LYS A  97      15.713  20.507  14.770  1.00  9.48           C  
ATOM    777  CE  LYS A  97      15.536  19.421  13.696  1.00 10.77           C  
ATOM    778  NZ  LYS A  97      14.187  19.222  13.202  1.00  8.23           N  
ATOM    779  N   GLY A  98      12.558  17.004  17.508  1.00 10.35           N  
ATOM    780  CA  GLY A  98      12.221  15.633  17.856  1.00 10.29           C  
ATOM    781  C   GLY A  98      10.825  15.440  18.422  1.00 10.77           C  
ATOM    782  O   GLY A  98      10.502  14.318  18.840  1.00  9.70           O  
ATOM    783  N   GLY A  99       9.990  16.499  18.444  1.00 10.69           N  
ATOM    784  CA  GLY A  99       8.563  16.332  18.739  1.00 11.15           C  
ATOM    785  C   GLY A  99       7.948  15.225  17.892  1.00 11.22           C  
ATOM    786  O   GLY A  99       7.167  14.386  18.379  1.00 11.49           O  
ATOM    787  N   GLY A 100       8.347  15.188  16.629  1.00 10.67           N  
ATOM    788  CA  GLY A 100       7.924  14.107  15.714  1.00 10.91           C  
ATOM    789  C   GLY A 100       8.765  12.832  15.686  1.00  9.85           C  
ATOM    790  O   GLY A 100       8.606  11.996  14.785  1.00 10.20           O  
ATOM    791  N   GLY A 101       9.689  12.686  16.620  1.00  9.61           N  
ATOM    792  CA  GLY A 101      10.379  11.446  16.834  1.00  9.50           C  
ATOM    793  C   GLY A 101      11.560  11.163  15.896  1.00 10.11           C  
ATOM    794  O   GLY A 101      12.112  10.067  15.943  1.00  9.93           O  
ATOM    795  N   CYS A 102      11.958  12.146  15.079  1.00  8.48           N  
ATOM    796  CA  CYS A 102      12.970  11.915  14.046  1.00  8.60           C  
ATOM    797  C   CYS A 102      14.262  12.718  14.204  1.00  8.17           C  
ATOM    798  O   CYS A 102      14.991  12.914  13.237  1.00  7.65           O  
ATOM    799  CB  CYS A 102      12.344  12.203  12.682  1.00  9.94           C  
ATOM    800  SG  CYS A 102      10.889  11.177  12.275  1.00 10.71           S  
ATOM    801  N   HIS A 103      14.551  13.164  15.408  1.00  7.44           N  
ATOM    802  CA  HIS A 103      15.714  14.040  15.677  1.00  7.91           C  
ATOM    803  C   HIS A 103      17.073  13.432  15.334  1.00  7.91           C  
ATOM    804  O   HIS A 103      18.020  14.156  15.006  1.00  8.83           O  
ATOM    805  CB  HIS A 103      15.718  14.522  17.139  1.00  9.06           C  
ATOM    806  CG  HIS A 103      15.689  13.414  18.141  1.00 10.60           C  
ATOM    807  ND1 HIS A 103      14.535  12.738  18.453  1.00 11.16           N  
ATOM    808  CD2 HIS A 103      16.663  12.877  18.912  1.00 13.16           C  
ATOM    809  CE1 HIS A 103      14.797  11.814  19.354  1.00 12.68           C  
ATOM    810  NE2 HIS A 103      16.084  11.869  19.644  1.00 12.37           N  
ATOM    811  N   THR A 104      17.204  12.109  15.465  1.00  7.03           N  
ATOM    812  CA  THR A 104      18.497  11.450  15.208  1.00  8.08           C  
ATOM    813  C   THR A 104      18.965  11.616  13.744  1.00  7.68           C  
ATOM    814  O   THR A 104      20.030  12.185  13.474  1.00  7.65           O  
ATOM    815  CB  THR A 104      18.439   9.991  15.598  1.00  8.34           C  
ATOM    816  OG1 THR A 104      18.150   9.887  16.995  1.00  8.41           O  
ATOM    817  CG2 THR A 104      19.764   9.331  15.321  1.00  7.22           C  
ATOM    818  N   GLN A 105      18.167  11.133  12.801  1.00  8.10           N  
ATOM    819  CA  GLN A 105      18.459  11.367  11.373  1.00  8.05           C  
ATOM    820  C   GLN A 105      18.481  12.848  10.999  1.00  7.99           C  
ATOM    821  O   GLN A 105      19.299  13.264  10.181  1.00  7.97           O  
ATOM    822  CB  GLN A 105      17.468  10.603  10.511  1.00  8.00           C  
ATOM    823  CG  GLN A 105      17.621   9.072  10.677  1.00  8.86           C  
ATOM    824  CD  GLN A 105      18.817   8.452   9.964  1.00 13.28           C  
ATOM    825  OE1 GLN A 105      19.447   9.055   9.079  1.00 15.54           O  
ATOM    826  NE2 GLN A 105      19.092   7.195  10.302  1.00 12.57           N  
ATOM    827  N   GLU A 106      17.587  13.642  11.612  1.00  8.41           N  
ATOM    828  CA  GLU A 106      17.605  15.098  11.432  1.00  7.96           C  
ATOM    829  C   GLU A 106      18.976  15.679  11.785  1.00  8.13           C  
ATOM    830  O   GLU A 106      19.558  16.448  11.007  1.00  8.08           O  
ATOM    831  CB  GLU A 106      16.516  15.778  12.269  1.00  8.46           C  
ATOM    832  CG  GLU A 106      15.141  15.647  11.718  1.00  7.92           C  
ATOM    833  CD  GLU A 106      14.032  15.889  12.759  1.00  9.57           C  
ATOM    834  OE1 GLU A 106      14.281  16.386  13.886  1.00  9.13           O  
ATOM    835  OE2 GLU A 106      12.871  15.551  12.437  1.00 13.54           O  
ATOM    836  N   LYS A 107      19.513  15.306  12.936  1.00  7.95           N  
ATOM    837  CA  LYS A 107      20.820  15.876  13.376  1.00  7.15           C  
ATOM    838  C   LYS A 107      21.962  15.417  12.475  1.00  7.48           C  
ATOM    839  O   LYS A 107      22.841  16.201  12.132  1.00  8.16           O  
ATOM    840  CB  LYS A 107      21.128  15.617  14.839  1.00  6.56           C  
ATOM    841  CG  LYS A 107      22.250  16.497  15.411  1.00  7.44           C  
ATOM    842  CD  LYS A 107      22.445  16.309  16.919  1.00  7.76           C  
ATOM    843  CE  LYS A 107      21.263  16.850  17.766  1.00  6.14           C  
ATOM    844  NZ  LYS A 107      21.617  16.719  19.228  1.00  7.73           N  
ATOM    845  N   ILE A 108      21.937  14.154  12.080  1.00  7.92           N  
ATOM    846  CA  ILE A 108      22.938  13.594  11.154  1.00  7.50           C  
ATOM    847  C   ILE A 108      22.992  14.465   9.853  1.00  8.41           C  
ATOM    848  O   ILE A 108      24.096  14.851   9.386  1.00  8.80           O  
ATOM    849  CB  ILE A 108      22.641  12.099  10.882  1.00  7.81           C  
ATOM    850  CG1 ILE A 108      22.953  11.227  12.116  1.00  8.01           C  
ATOM    851  CG2 ILE A 108      23.397  11.609   9.623  1.00  8.65           C  
ATOM    852  CD1 ILE A 108      22.287   9.846  12.013  1.00  7.48           C  
ATOM    853  N   VAL A 109      21.827  14.793   9.302  1.00  8.03           N  
ATOM    854  CA  VAL A 109      21.766  15.610   8.075  1.00  8.16           C  
ATOM    855  C   VAL A 109      22.103  17.073   8.421  1.00  7.50           C  
ATOM    856  O   VAL A 109      22.953  17.692   7.801  1.00  7.96           O  
ATOM    857  CB  VAL A 109      20.433  15.483   7.364  1.00  8.84           C  
ATOM    858  CG1 VAL A 109      20.294  16.531   6.227  1.00  8.59           C  
ATOM    859  CG2 VAL A 109      20.230  14.056   6.835  1.00  9.57           C  
ATOM    860  N   ASP A 110      21.424  17.612   9.418  1.00  8.96           N  
ATOM    861  CA  ASP A 110      21.387  19.061   9.610  1.00  8.57           C  
ATOM    862  C   ASP A 110      22.747  19.586  10.074  1.00  9.31           C  
ATOM    863  O   ASP A 110      23.216  20.600   9.581  1.00 10.27           O  
ATOM    864  CB  ASP A 110      20.278  19.456  10.611  1.00  8.49           C  
ATOM    865  CG  ASP A 110      18.863  19.154  10.106  1.00  7.89           C  
ATOM    866  OD1 ASP A 110      18.652  18.999   8.899  1.00  9.40           O  
ATOM    867  OD2 ASP A 110      17.956  19.104  10.954  1.00  8.81           O  
ATOM    868  N   TYR A 111      23.395  18.901  11.018  1.00  8.38           N  
ATOM    869  CA  TYR A 111      24.680  19.364  11.522  1.00  8.06           C  
ATOM    870  C   TYR A 111      25.776  19.252  10.452  1.00  9.14           C  
ATOM    871  O   TYR A 111      26.777  19.961  10.512  1.00  9.53           O  
ATOM    872  CB  TYR A 111      25.124  18.537  12.748  1.00  7.66           C  
ATOM    873  CG  TYR A 111      24.628  19.009  14.102  1.00  7.17           C  
ATOM    874  CD1 TYR A 111      23.518  19.842  14.235  1.00  6.24           C  
ATOM    875  CD2 TYR A 111      25.284  18.593  15.264  1.00  8.47           C  
ATOM    876  CE1 TYR A 111      23.076  20.242  15.505  1.00  7.32           C  
ATOM    877  CE2 TYR A 111      24.849  18.982  16.507  1.00  9.13           C  
ATOM    878  CZ  TYR A 111      23.748  19.791  16.632  1.00  6.87           C  
ATOM    879  OH  TYR A 111      23.311  20.202  17.892  1.00  9.07           O  
ATOM    880  N   ASN A 112      25.583  18.337   9.501  1.00  9.42           N  
ATOM    881  CA  ASN A 112      26.590  18.061   8.485  1.00  9.35           C  
ATOM    882  C   ASN A 112      26.422  18.857   7.224  1.00  9.90           C  
ATOM    883  O   ASN A 112      27.309  18.823   6.378  1.00 10.42           O  
ATOM    884  CB  ASN A 112      26.647  16.573   8.157  1.00  9.08           C  
ATOM    885  CG  ASN A 112      27.445  15.818   9.187  1.00  9.49           C  
ATOM    886  OD1 ASN A 112      28.661  16.007   9.291  1.00 12.10           O  
ATOM    887  ND2 ASN A 112      26.772  14.986   9.986  1.00  7.08           N  
ATOM    888  N   ALA A 113      25.311  19.588   7.105  1.00  9.55           N  
ATOM    889  CA  ALA A 113      25.010  20.347   5.925  1.00  9.86           C  
ATOM    890  C   ALA A 113      25.938  21.567   5.845  1.00 10.15           C  
ATOM    891  O   ALA A 113      26.344  22.106   6.867  1.00 10.33           O  
ATOM    892  CB  ALA A 113      23.549  20.780   5.908  1.00  9.97           C  
ATOM    893  N   ASN A 114      26.277  21.984   4.632  1.00 11.04           N  
ATOM    894  CA  ASN A 114      27.022  23.240   4.485  1.00 11.59           C  
ATOM    895  C   ASN A 114      26.272  24.423   5.094  1.00 11.49           C  
ATOM    896  O   ASN A 114      26.856  25.276   5.786  1.00 11.20           O  
ATOM    897  CB  ASN A 114      27.368  23.543   3.036  1.00 12.62           C  
ATOM    898  CG  ASN A 114      28.420  24.659   2.948  1.00 14.56           C  
ATOM    899  OD1 ASN A 114      29.543  24.493   3.439  1.00 20.96           O  
ATOM    900  ND2 ASN A 114      28.041  25.798   2.404  1.00 21.60           N  
ATOM    901  N   GLU A 115      24.971  24.480   4.837  1.00 11.63           N  
ATOM    902  CA  GLU A 115      24.105  25.460   5.478  1.00 12.01           C  
ATOM    903  C   GLU A 115      22.853  24.752   6.005  1.00 11.79           C  
ATOM    904  O   GLU A 115      22.170  24.016   5.271  1.00 10.09           O  
ATOM    905  CB  GLU A 115      23.707  26.585   4.528  1.00 12.78           C  
ATOM    906  CG  GLU A 115      23.129  27.799   5.234  1.00 13.84           C  
ATOM    907  CD  GLU A 115      22.622  28.863   4.285  1.00 16.32           C  
ATOM    908  OE1 GLU A 115      22.350  28.540   3.108  1.00 20.22           O  
ATOM    909  OE2 GLU A 115      22.496  30.023   4.770  1.00 21.72           O  
ATOM    910  N   PHE A 116      22.595  24.981   7.283  1.00 10.58           N  
ATOM    911  CA  PHE A 116      21.430  24.449   7.980  1.00 10.69           C  
ATOM    912  C   PHE A 116      20.483  25.585   8.291  1.00 10.25           C  
ATOM    913  O   PHE A 116      20.785  26.463   9.085  1.00 11.41           O  
ATOM    914  CB  PHE A 116      21.860  23.679   9.238  1.00  9.74           C  
ATOM    915  CG  PHE A 116      20.727  23.240  10.166  1.00 10.80           C  
ATOM    916  CD1 PHE A 116      19.441  22.944   9.689  1.00 10.22           C  
ATOM    917  CD2 PHE A 116      20.990  23.094  11.531  1.00 11.13           C  
ATOM    918  CE1 PHE A 116      18.427  22.542  10.564  1.00  9.80           C  
ATOM    919  CE2 PHE A 116      20.003  22.696  12.414  1.00 12.68           C  
ATOM    920  CZ  PHE A 116      18.703  22.423  11.920  1.00 10.93           C  
ATOM    921  N   VAL A 117      19.320  25.518   7.680  1.00  9.75           N  
ATOM    922  CA  VAL A 117      18.307  26.564   7.728  1.00  9.50           C  
ATOM    923  C   VAL A 117      17.079  26.010   8.421  1.00  9.95           C  
ATOM    924  O   VAL A 117      16.495  25.034   7.973  1.00  9.36           O  
ATOM    925  CB  VAL A 117      17.901  27.035   6.309  1.00  9.39           C  
ATOM    926  CG1 VAL A 117      16.738  28.072   6.382  1.00  8.37           C  
ATOM    927  CG2 VAL A 117      19.122  27.579   5.497  1.00  9.56           C  
ATOM    928  N   VAL A 118      16.693  26.632   9.531  1.00  9.84           N  
ATOM    929  CA  VAL A 118      15.538  26.187  10.287  1.00  9.83           C  
ATOM    930  C   VAL A 118      14.361  27.020   9.775  1.00 10.23           C  
ATOM    931  O   VAL A 118      14.504  28.224   9.560  1.00  9.87           O  
ATOM    932  CB  VAL A 118      15.731  26.433  11.774  1.00 10.17           C  
ATOM    933  CG1 VAL A 118      14.442  26.189  12.578  1.00  8.87           C  
ATOM    934  CG2 VAL A 118      16.917  25.583  12.302  1.00 11.70           C  
ATOM    935  N   LEU A 119      13.215  26.365   9.601  1.00  9.83           N  
ATOM    936  CA  LEU A 119      11.950  27.004   9.194  1.00 10.08           C  
ATOM    937  C   LEU A 119      10.892  26.905  10.286  1.00 10.83           C  
ATOM    938  O   LEU A 119      10.499  25.792  10.709  1.00 10.54           O  
ATOM    939  CB  LEU A 119      11.427  26.335   7.927  1.00 10.07           C  
ATOM    940  CG  LEU A 119      12.404  26.198   6.775  1.00 10.07           C  
ATOM    941  CD1 LEU A 119      11.690  25.603   5.591  1.00 12.05           C  
ATOM    942  CD2 LEU A 119      13.072  27.555   6.430  1.00 10.60           C  
ATOM    943  N   VAL A 120      10.444  28.062  10.800  1.00 10.75           N  
ATOM    944  CA  VAL A 120       9.435  28.055  11.841  1.00 10.18           C  
ATOM    945  C   VAL A 120       8.464  29.185  11.615  1.00 11.11           C  
ATOM    946  O   VAL A 120       8.795  30.168  10.946  1.00  9.74           O  
ATOM    947  CB  VAL A 120       9.992  28.180  13.298  1.00 10.14           C  
ATOM    948  CG1 VAL A 120      10.836  26.947  13.708  1.00  8.94           C  
ATOM    949  CG2 VAL A 120      10.816  29.489  13.473  1.00  9.27           C  
ATOM    950  N   ASP A 121       7.276  29.033  12.176  1.00 11.21           N  
ATOM    951  CA  ASP A 121       6.368  30.176  12.367  1.00 12.15           C  
ATOM    952  C   ASP A 121       6.752  30.865  13.685  1.00 12.49           C  
ATOM    953  O   ASP A 121       7.420  30.277  14.517  1.00 11.37           O  
ATOM    954  CB  ASP A 121       4.917  29.726  12.369  1.00 13.11           C  
ATOM    955  CG  ASP A 121       4.554  28.911  13.589  1.00 13.68           C  
ATOM    956  OD1 ASP A 121       4.656  27.671  13.525  1.00 15.71           O  
ATOM    957  OD2 ASP A 121       4.148  29.512  14.609  1.00 13.39           O  
ATOM    958  N   GLU A 122       6.267  32.092  13.896  1.00 13.11           N  
ATOM    959  CA  GLU A 122       6.656  32.891  15.067  1.00 13.75           C  
ATOM    960  C   GLU A 122       6.352  32.249  16.415  1.00 13.04           C  
ATOM    961  O   GLU A 122       7.052  32.524  17.385  1.00 11.74           O  
ATOM    962  CB  GLU A 122       6.026  34.310  15.026  1.00 14.01           C  
ATOM    963  CG  GLU A 122       6.740  35.335  15.950  1.00 16.13           C  
ATOM    964  CD  GLU A 122       6.358  36.818  15.684  1.00 20.16           C  
ATOM    965  OE1 GLU A 122       5.665  37.120  14.690  1.00 24.51           O  
ATOM    966  OE2 GLU A 122       6.774  37.679  16.494  1.00 28.46           O  
ATOM    967  N   SER A 123       5.345  31.368  16.480  1.00 12.89           N  
ATOM    968  CA  SER A 123       4.992  30.727  17.754  1.00 13.40           C  
ATOM    969  C   SER A 123       6.088  29.837  18.344  1.00 13.45           C  
ATOM    970  O   SER A 123       6.043  29.545  19.537  1.00 14.03           O  
ATOM    971  CB  SER A 123       3.692  29.928  17.627  1.00 13.52           C  
ATOM    972  OG  SER A 123       3.900  28.707  16.955  1.00 13.93           O  
ATOM    973  N   LYS A 124       7.048  29.390  17.521  1.00 12.36           N  
ATOM    974  CA  LYS A 124       8.122  28.515  18.003  1.00 13.02           C  
ATOM    975  C   LYS A 124       9.234  29.237  18.780  1.00 12.97           C  
ATOM    976  O   LYS A 124      10.040  28.590  19.452  1.00 12.60           O  
ATOM    977  CB  LYS A 124       8.744  27.723  16.846  1.00 12.66           C  
ATOM    978  CG  LYS A 124       7.745  26.945  15.998  1.00 13.45           C  
ATOM    979  CD  LYS A 124       6.841  26.078  16.805  1.00 15.58           C  
ATOM    980  CE  LYS A 124       6.002  25.174  15.938  1.00 19.44           C  
ATOM    981  NZ  LYS A 124       6.923  24.214  15.282  1.00 25.41           N  
ATOM    982  N   LEU A 125       9.300  30.567  18.665  1.00 13.07           N  
ATOM    983  CA  LEU A 125      10.310  31.320  19.379  1.00 13.26           C  
ATOM    984  C   LEU A 125      10.022  31.324  20.888  1.00 13.58           C  
ATOM    985  O   LEU A 125       8.879  31.577  21.311  1.00 13.56           O  
ATOM    986  CB  LEU A 125      10.380  32.763  18.861  1.00 14.07           C  
ATOM    987  CG  LEU A 125      11.037  32.938  17.501  1.00 15.84           C  
ATOM    988  CD1 LEU A 125      10.803  34.360  16.967  1.00 20.21           C  
ATOM    989  CD2 LEU A 125      12.522  32.653  17.589  1.00 16.90           C  
ATOM    990  N   VAL A 126      11.042  31.018  21.679  1.00 12.29           N  
ATOM    991  CA  VAL A 126      10.942  30.992  23.131  1.00 13.01           C  
ATOM    992  C   VAL A 126      12.034  31.805  23.792  1.00 13.81           C  
ATOM    993  O   VAL A 126      13.123  31.987  23.228  1.00 12.21           O  
ATOM    994  CB  VAL A 126      10.934  29.547  23.723  1.00 12.81           C  
ATOM    995  CG1 VAL A 126       9.797  28.708  23.101  1.00 13.73           C  
ATOM    996  CG2 VAL A 126      12.299  28.804  23.531  1.00 11.12           C  
ATOM    997  N   LYS A 127      11.737  32.284  25.002  1.00 14.25           N  
ATOM    998  CA  LYS A 127      12.727  33.019  25.773  1.00 16.24           C  
ATOM    999  C   LYS A 127      13.736  32.072  26.393  1.00 15.54           C  
ATOM   1000  O   LYS A 127      14.937  32.344  26.357  1.00 16.85           O  
ATOM   1001  CB  LYS A 127      12.059  33.843  26.861  1.00 17.24           C  
ATOM   1002  CG  LYS A 127      11.309  35.065  26.297  1.00 19.94           C  
ATOM   1003  CD  LYS A 127      10.758  35.919  27.442  0.50 18.79           C  
ATOM   1004  CE  LYS A 127      11.883  36.498  28.293  0.50 21.70           C  
ATOM   1005  NZ  LYS A 127      11.428  37.657  29.120  0.50 22.84           N  
ATOM   1006  N   LYS A 128      13.254  30.938  26.915  1.00 15.89           N  
ATOM   1007  CA  LYS A 128      14.132  29.946  27.567  1.00 15.30           C  
ATOM   1008  C   LYS A 128      13.939  28.550  26.994  1.00 14.56           C  
ATOM   1009  O   LYS A 128      12.850  28.026  27.087  1.00 13.95           O  
ATOM   1010  CB  LYS A 128      13.798  29.904  29.056  1.00 16.62           C  
ATOM   1011  CG  LYS A 128      14.526  28.863  29.886  1.00 18.64           C  
ATOM   1012  CD  LYS A 128      15.967  29.180  29.994  1.00 22.43           C  
ATOM   1013  CE  LYS A 128      16.629  28.350  31.094  1.00 23.55           C  
ATOM   1014  NZ  LYS A 128      18.102  28.640  31.138  1.00 26.41           N  
ATOM   1015  N   LEU A 129      14.995  27.943  26.450  1.00 13.69           N  
ATOM   1016  CA  LEU A 129      14.870  26.606  25.835  1.00 13.29           C  
ATOM   1017  C   LEU A 129      14.443  25.596  26.882  1.00 13.49           C  
ATOM   1018  O   LEU A 129      15.027  25.539  27.970  1.00 12.98           O  
ATOM   1019  CB  LEU A 129      16.202  26.158  25.242  1.00 12.81           C  
ATOM   1020  CG  LEU A 129      16.154  25.062  24.177  1.00 11.80           C  
ATOM   1021  CD1 LEU A 129      15.483  25.611  22.907  1.00 11.90           C  
ATOM   1022  CD2 LEU A 129      17.586  24.555  23.910  1.00 13.23           C  
ATOM   1023  N   GLY A 130      13.457  24.768  26.539  1.00 13.49           N  
ATOM   1024  CA  GLY A 130      13.083  23.659  27.395  1.00 14.61           C  
ATOM   1025  C   GLY A 130      12.218  24.018  28.594  1.00 14.99           C  
ATOM   1026  O   GLY A 130      11.871  23.156  29.369  1.00 14.76           O  
ATOM   1027  N   GLU A 131      11.868  25.285  28.751  1.00 16.94           N  
ATOM   1028  CA  GLU A 131      10.972  25.669  29.837  1.00 18.39           C  
ATOM   1029  C   GLU A 131       9.595  25.027  29.616  1.00 18.18           C  
ATOM   1030  O   GLU A 131       8.969  24.577  30.588  1.00 18.91           O  
ATOM   1031  CB  GLU A 131      10.865  27.194  29.935  1.00 18.57           C  
ATOM   1032  CG  GLU A 131       9.910  27.699  30.991  1.00 20.79           C  
ATOM   1033  CD  GLU A 131       9.953  29.221  31.145  1.00 23.32           C  
ATOM   1034  OE1 GLU A 131       9.925  29.684  32.318  1.00 34.19           O  
ATOM   1035  OE2 GLU A 131       9.996  29.968  30.115  1.00 32.12           O  
ATOM   1036  N   LYS A 132       9.136  24.970  28.366  1.00 17.59           N  
ATOM   1037  CA  LYS A 132       7.783  24.510  28.052  1.00 19.41           C  
ATOM   1038  C   LYS A 132       7.718  23.298  27.124  1.00 18.32           C  
ATOM   1039  O   LYS A 132       6.635  22.837  26.796  1.00 20.52           O  
ATOM   1040  CB  LYS A 132       6.958  25.682  27.503  1.00 21.10           C  
ATOM   1041  CG  LYS A 132       6.917  26.891  28.493  1.00 23.57           C  
ATOM   1042  CD  LYS A 132       6.208  28.098  27.854  1.00 24.18           C  
ATOM   1043  CE  LYS A 132       6.283  29.407  28.669  1.00 27.84           C  
ATOM   1044  NZ  LYS A 132       7.258  29.344  29.793  1.00 32.10           N  
ATOM   1045  N   PHE A 133       8.865  22.743  26.737  1.00 17.02           N  
ATOM   1046  CA  PHE A 133       8.890  21.587  25.832  1.00 15.74           C  
ATOM   1047  C   PHE A 133       9.944  20.574  26.319  1.00 14.40           C  
ATOM   1048  O   PHE A 133      11.034  20.977  26.672  1.00 14.68           O  
ATOM   1049  CB  PHE A 133       9.204  22.072  24.426  1.00 17.32           C  
ATOM   1050  CG  PHE A 133       8.821  21.086  23.365  1.00 16.40           C  
ATOM   1051  CD1 PHE A 133       7.543  21.075  22.848  1.00 18.60           C  
ATOM   1052  CD2 PHE A 133       9.736  20.150  22.916  1.00 18.05           C  
ATOM   1053  CE1 PHE A 133       7.165  20.136  21.906  1.00 20.72           C  
ATOM   1054  CE2 PHE A 133       9.371  19.185  21.961  1.00 19.44           C  
ATOM   1055  CZ  PHE A 133       8.088  19.186  21.451  1.00 20.09           C  
ATOM   1056  N   PRO A 134       9.604  19.266  26.387  1.00 12.28           N  
ATOM   1057  CA  PRO A 134      10.586  18.281  26.850  1.00 12.31           C  
ATOM   1058  C   PRO A 134      11.565  17.917  25.769  1.00 11.76           C  
ATOM   1059  O   PRO A 134      11.249  18.031  24.577  1.00 12.62           O  
ATOM   1060  CB  PRO A 134       9.721  17.070  27.211  1.00 12.95           C  
ATOM   1061  CG  PRO A 134       8.588  17.150  26.264  1.00 11.51           C  
ATOM   1062  CD  PRO A 134       8.350  18.614  25.986  1.00 13.02           C  
ATOM   1063  N   ILE A 135      12.733  17.439  26.178  1.00 11.00           N  
ATOM   1064  CA  ILE A 135      13.781  17.012  25.243  1.00 10.49           C  
ATOM   1065  C   ILE A 135      13.538  15.559  24.806  1.00  8.95           C  
ATOM   1066  O   ILE A 135      13.504  14.680  25.656  1.00  9.64           O  
ATOM   1067  CB  ILE A 135      15.152  17.046  25.930  1.00 10.51           C  
ATOM   1068  CG1 ILE A 135      15.457  18.444  26.488  1.00 11.78           C  
ATOM   1069  CG2 ILE A 135      16.254  16.614  24.932  1.00 10.81           C  
ATOM   1070  CD1 ILE A 135      16.427  18.403  27.676  1.00 11.25           C  
ATOM   1071  N   PRO A 136      13.323  15.313  23.497  1.00  9.17           N  
ATOM   1072  CA  PRO A 136      13.279  13.931  23.009  1.00  8.66           C  
ATOM   1073  C   PRO A 136      14.633  13.240  23.081  1.00  8.53           C  
ATOM   1074  O   PRO A 136      15.666  13.837  22.714  1.00  7.53           O  
ATOM   1075  CB  PRO A 136      12.841  14.081  21.557  1.00  9.41           C  
ATOM   1076  CG  PRO A 136      12.133  15.451  21.504  1.00 10.10           C  
ATOM   1077  CD  PRO A 136      12.965  16.284  22.448  1.00  9.41           C  
ATOM   1078  N   VAL A 137      14.630  11.990  23.522  1.00  8.83           N  
ATOM   1079  CA  VAL A 137      15.856  11.230  23.622  1.00  8.41           C  
ATOM   1080  C   VAL A 137      15.616   9.872  22.988  1.00  8.32           C  
ATOM   1081  O   VAL A 137      14.679   9.186  23.369  1.00  9.22           O  
ATOM   1082  CB  VAL A 137      16.289  11.064  25.102  1.00  9.04           C  
ATOM   1083  CG1 VAL A 137      17.572  10.255  25.196  1.00  9.53           C  
ATOM   1084  CG2 VAL A 137      16.431  12.462  25.804  1.00  8.46           C  
ATOM   1085  N   GLU A 138      16.416   9.499  21.990  1.00  9.09           N  
ATOM   1086  CA  GLU A 138      16.278   8.180  21.356  1.00  8.81           C  
ATOM   1087  C   GLU A 138      17.121   7.199  22.159  1.00  8.81           C  
ATOM   1088  O   GLU A 138      18.303   7.448  22.401  1.00  8.98           O  
ATOM   1089  CB  GLU A 138      16.681   8.232  19.870  1.00  9.67           C  
ATOM   1090  CG  GLU A 138      16.553   6.869  19.195  1.00  8.43           C  
ATOM   1091  CD  GLU A 138      16.456   6.944  17.681  1.00  9.82           C  
ATOM   1092  OE1 GLU A 138      16.374   8.061  17.093  1.00  9.59           O  
ATOM   1093  OE2 GLU A 138      16.488   5.863  17.075  1.00 10.70           O  
ATOM   1094  N   VAL A 139      16.524   6.057  22.520  1.00  8.89           N  
ATOM   1095  CA  VAL A 139      17.107   5.125  23.455  0.50  8.75           C  
ATOM   1097  C   VAL A 139      17.067   3.683  22.946  1.00  8.45           C  
ATOM   1098  O   VAL A 139      16.041   3.251  22.476  1.00  8.78           O  
ATOM   1099  CB  VAL A 139      16.340   5.145  24.812  0.50  9.30           C  
ATOM   1101  CG1 VAL A 139      17.109   4.347  25.866  0.50  6.06           C  
ATOM   1103  CG2 VAL A 139      16.091   6.583  25.265  0.50 10.23           C  
ATOM   1105  N   ILE A 140      18.186   2.971  23.074  1.00  9.00           N  
ATOM   1106  CA  ILE A 140      18.290   1.536  22.801  1.00  9.26           C  
ATOM   1107  C   ILE A 140      17.256   0.838  23.704  1.00 10.50           C  
ATOM   1108  O   ILE A 140      17.269   1.037  24.924  1.00 10.71           O  
ATOM   1109  CB  ILE A 140      19.737   0.992  23.110  1.00  9.71           C  
ATOM   1110  CG1 ILE A 140      20.796   1.633  22.205  1.00 12.21           C  
ATOM   1111  CG2 ILE A 140      19.805  -0.544  23.012  1.00  8.12           C  
ATOM   1112  CD1 ILE A 140      20.574   1.441  20.733  1.00 14.85           C  
ATOM   1113  N   PRO A 141      16.343   0.046  23.114  1.00 10.43           N  
ATOM   1114  CA  PRO A 141      15.224  -0.446  23.924  1.00 11.86           C  
ATOM   1115  C   PRO A 141      15.644  -1.189  25.198  1.00 11.53           C  
ATOM   1116  O   PRO A 141      15.014  -1.012  26.216  1.00 13.21           O  
ATOM   1117  CB  PRO A 141      14.505  -1.385  22.971  1.00 12.29           C  
ATOM   1118  CG  PRO A 141      14.761  -0.800  21.627  1.00 11.87           C  
ATOM   1119  CD  PRO A 141      16.187  -0.313  21.691  1.00 10.84           C  
ATOM   1120  N   SER A 142      16.711  -1.990  25.134  1.00 12.06           N  
ATOM   1121  CA  SER A 142      17.196  -2.706  26.313  1.00 11.93           C  
ATOM   1122  C   SER A 142      17.605  -1.744  27.451  1.00 12.13           C  
ATOM   1123  O   SER A 142      17.773  -2.196  28.574  1.00 12.48           O  
ATOM   1124  CB  SER A 142      18.419  -3.562  25.987  1.00 12.15           C  
ATOM   1125  OG  SER A 142      19.558  -2.748  25.726  1.00 15.31           O  
ATOM   1126  N   ALA A 143      17.845  -0.472  27.129  1.00 11.02           N  
ATOM   1127  CA  ALA A 143      18.368   0.496  28.090  1.00 11.30           C  
ATOM   1128  C   ALA A 143      17.340   1.455  28.666  1.00 10.73           C  
ATOM   1129  O   ALA A 143      17.717   2.349  29.428  1.00 10.35           O  
ATOM   1130  CB  ALA A 143      19.561   1.274  27.506  1.00 11.44           C  
ATOM   1131  N   TYR A 144      16.060   1.286  28.359  1.00 10.80           N  
ATOM   1132  CA  TYR A 144      15.126   2.372  28.662  1.00 12.28           C  
ATOM   1133  C   TYR A 144      15.085   2.634  30.192  1.00 12.52           C  
ATOM   1134  O   TYR A 144      15.090   3.800  30.633  1.00 13.14           O  
ATOM   1135  CB  TYR A 144      13.743   2.170  27.995  1.00 14.93           C  
ATOM   1136  CG  TYR A 144      12.847   1.190  28.700  1.00 14.96           C  
ATOM   1137  CD1 TYR A 144      12.660  -0.099  28.221  1.00 17.94           C  
ATOM   1138  CD2 TYR A 144      12.173   1.562  29.842  1.00 18.13           C  
ATOM   1139  CE1 TYR A 144      11.819  -0.988  28.888  1.00 18.43           C  
ATOM   1140  CE2 TYR A 144      11.337   0.699  30.497  1.00 18.78           C  
ATOM   1141  CZ  TYR A 144      11.159  -0.571  30.021  1.00 18.50           C  
ATOM   1142  OH  TYR A 144      10.322  -1.433  30.733  1.00 21.60           O  
ATOM   1143  N   ARG A 145      15.118   1.580  31.002  1.00 12.14           N  
ATOM   1144  CA  ARG A 145      14.969   1.792  32.453  1.00 12.64           C  
ATOM   1145  C   ARG A 145      16.162   2.545  33.018  1.00 12.56           C  
ATOM   1146  O   ARG A 145      16.000   3.487  33.826  1.00 12.85           O  
ATOM   1147  CB  ARG A 145      14.735   0.474  33.193  1.00 12.50           C  
ATOM   1148  CG  ARG A 145      14.539   0.652  34.733  1.00 13.85           C  
ATOM   1149  CD  ARG A 145      14.441  -0.700  35.423  1.00 13.07           C  
ATOM   1150  NE  ARG A 145      15.699  -1.448  35.369  1.00 12.78           N  
ATOM   1151  CZ  ARG A 145      16.793  -1.154  36.066  1.00 10.73           C  
ATOM   1152  NH1 ARG A 145      16.811  -0.152  36.922  1.00 14.83           N  
ATOM   1153  NH2 ARG A 145      17.874  -1.887  35.927  1.00 15.46           N  
ATOM   1154  N   VAL A 146      17.358   2.123  32.625  1.00 12.12           N  
ATOM   1155  CA  VAL A 146      18.578   2.744  33.141  1.00 11.92           C  
ATOM   1156  C   VAL A 146      18.797   4.165  32.583  1.00 11.52           C  
ATOM   1157  O   VAL A 146      19.388   5.018  33.247  1.00 11.19           O  
ATOM   1158  CB  VAL A 146      19.826   1.811  32.975  1.00 11.81           C  
ATOM   1159  CG1 VAL A 146      19.654   0.536  33.841  1.00 12.87           C  
ATOM   1160  CG2 VAL A 146      20.159   1.465  31.484  1.00  8.83           C  
ATOM   1161  N   VAL A 147      18.341   4.425  31.362  1.00 11.63           N  
ATOM   1162  CA  VAL A 147      18.382   5.791  30.825  1.00 11.04           C  
ATOM   1163  C   VAL A 147      17.406   6.716  31.570  1.00 11.22           C  
ATOM   1164  O   VAL A 147      17.761   7.839  31.925  1.00 10.17           O  
ATOM   1165  CB  VAL A 147      18.129   5.823  29.276  1.00 10.71           C  
ATOM   1166  CG1 VAL A 147      17.974   7.247  28.800  1.00 10.21           C  
ATOM   1167  CG2 VAL A 147      19.311   5.141  28.570  1.00 10.35           C  
ATOM   1168  N   ILE A 148      16.192   6.238  31.817  1.00 12.39           N  
ATOM   1169  CA  ILE A 148      15.229   6.989  32.658  1.00 12.87           C  
ATOM   1170  C   ILE A 148      15.890   7.327  34.006  1.00 12.69           C  
ATOM   1171  O   ILE A 148      15.826   8.474  34.446  1.00 12.85           O  
ATOM   1172  CB  ILE A 148      13.920   6.206  32.876  1.00 14.15           C  
ATOM   1173  CG1 ILE A 148      13.032   6.272  31.626  1.00 14.94           C  
ATOM   1174  CG2 ILE A 148      13.138   6.764  34.101  1.00 14.21           C  
ATOM   1175  CD1 ILE A 148      12.016   5.217  31.590  1.00 14.57           C  
ATOM   1176  N   ARG A 149      16.535   6.355  34.639  1.00 13.02           N  
ATOM   1177  CA  ARG A 149      17.271   6.600  35.902  1.00 13.98           C  
ATOM   1178  C   ARG A 149      18.350   7.669  35.778  1.00 12.83           C  
ATOM   1179  O   ARG A 149      18.441   8.582  36.597  1.00 12.24           O  
ATOM   1180  CB  ARG A 149      17.938   5.328  36.419  1.00 14.16           C  
ATOM   1181  CG  ARG A 149      18.778   5.603  37.671  1.00 15.48           C  
ATOM   1182  CD  ARG A 149      19.518   4.326  38.045  1.00 17.45           C  
ATOM   1183  NE  ARG A 149      18.623   3.436  38.725  1.00 20.26           N  
ATOM   1184  CZ  ARG A 149      18.845   2.139  38.915  1.00 20.12           C  
ATOM   1185  NH1 ARG A 149      19.927   1.546  38.436  1.00 21.76           N  
ATOM   1186  NH2 ARG A 149      17.954   1.442  39.574  1.00 21.33           N  
ATOM   1187  N   ALA A 150      19.196   7.560  34.754  1.00 12.18           N  
ATOM   1188  CA  ALA A 150      20.225   8.560  34.545  1.00 12.25           C  
ATOM   1189  C   ALA A 150      19.639   9.971  34.326  1.00 11.48           C  
ATOM   1190  O   ALA A 150      20.136  10.964  34.911  1.00 12.28           O  
ATOM   1191  CB  ALA A 150      21.177   8.137  33.378  1.00 12.53           C  
ATOM   1192  N   LEU A 151      18.590  10.072  33.526  1.00 10.87           N  
ATOM   1193  CA  LEU A 151      17.974  11.369  33.248  1.00 11.35           C  
ATOM   1194  C   LEU A 151      17.326  11.929  34.520  1.00 11.43           C  
ATOM   1195  O   LEU A 151      17.411  13.127  34.772  1.00 11.65           O  
ATOM   1196  CB  LEU A 151      16.969  11.279  32.114  1.00 11.97           C  
ATOM   1197  CG  LEU A 151      17.574  10.940  30.745  1.00 11.48           C  
ATOM   1198  CD1 LEU A 151      16.446  10.596  29.761  1.00 12.93           C  
ATOM   1199  CD2 LEU A 151      18.438  12.086  30.216  1.00 10.06           C  
ATOM   1200  N   SER A 152      16.693  11.065  35.295  1.00 11.99           N  
ATOM   1201  CA  SER A 152      16.073  11.492  36.560  0.50 12.85           C  
ATOM   1203  C   SER A 152      17.155  11.984  37.529  1.00 12.36           C  
ATOM   1204  O   SER A 152      16.977  12.994  38.230  1.00 12.96           O  
ATOM   1205  CB  SER A 152      15.275  10.351  37.172  0.50 13.04           C  
ATOM   1207  OG  SER A 152      14.200   9.970  36.328  0.50 15.77           O  
ATOM   1209  N   GLU A 153      18.290  11.299  37.555  1.00 13.16           N  
ATOM   1210  CA  GLU A 153      19.398  11.677  38.453  1.00 13.91           C  
ATOM   1211  C   GLU A 153      20.079  12.978  38.043  1.00 13.78           C  
ATOM   1212  O   GLU A 153      20.728  13.620  38.862  1.00 14.43           O  
ATOM   1213  CB  GLU A 153      20.390  10.527  38.649  1.00 13.70           C  
ATOM   1214  CG  GLU A 153      19.774   9.457  39.535  1.00 15.98           C  
ATOM   1215  CD  GLU A 153      20.698   8.309  39.845  1.00 18.71           C  
ATOM   1216  OE1 GLU A 153      20.222   7.343  40.483  1.00 25.08           O  
ATOM   1217  OE2 GLU A 153      21.888   8.382  39.475  1.00 22.35           O  
ATOM   1218  N   MET A 154      19.919  13.348  36.779  1.00 13.09           N  
ATOM   1219  CA  MET A 154      20.329  14.658  36.289  1.00 14.62           C  
ATOM   1220  C   MET A 154      19.311  15.756  36.589  1.00 14.90           C  
ATOM   1221  O   MET A 154      19.568  16.937  36.279  1.00 15.16           O  
ATOM   1222  CB  MET A 154      20.568  14.600  34.778  1.00 14.68           C  
ATOM   1223  CG  MET A 154      21.716  13.769  34.436  1.00 15.99           C  
ATOM   1224  SD  MET A 154      21.858  13.600  32.636  1.00 17.67           S  
ATOM   1225  CE  MET A 154      22.361  15.225  32.143  1.00 19.26           C  
ATOM   1226  N   GLY A 155      18.176  15.395  37.193  1.00 14.97           N  
ATOM   1227  CA  GLY A 155      17.137  16.379  37.524  1.00 15.26           C  
ATOM   1228  C   GLY A 155      15.949  16.398  36.581  1.00 15.70           C  
ATOM   1229  O   GLY A 155      15.009  17.186  36.778  1.00 16.15           O  
ATOM   1230  N   GLY A 156      15.925  15.501  35.598  1.00 14.45           N  
ATOM   1231  CA  GLY A 156      14.846  15.507  34.614  1.00 14.97           C  
ATOM   1232  C   GLY A 156      13.579  14.744  35.003  1.00 14.54           C  
ATOM   1233  O   GLY A 156      13.626  13.800  35.774  1.00 15.16           O  
ATOM   1234  N   GLU A 157      12.459  15.132  34.403  1.00 14.72           N  
ATOM   1235  CA  GLU A 157      11.196  14.406  34.493  1.00 14.80           C  
ATOM   1236  C   GLU A 157      11.041  13.658  33.159  1.00 14.24           C  
ATOM   1237  O   GLU A 157      10.712  14.260  32.155  1.00 13.53           O  
ATOM   1238  CB  GLU A 157      10.071  15.404  34.715  1.00 13.98           C  
ATOM   1239  CG  GLU A 157       8.672  14.911  34.564  1.00 17.42           C  
ATOM   1240  CD  GLU A 157       7.645  15.939  35.038  0.50 17.56           C  
ATOM   1241  OE1 GLU A 157       8.029  16.880  35.768  0.50 22.42           O  
ATOM   1242  OE2 GLU A 157       6.457  15.808  34.681  0.50 22.49           O  
ATOM   1243  N   ALA A 158      11.303  12.357  33.179  1.00 15.30           N  
ATOM   1244  CA  ALA A 158      11.464  11.565  31.945  1.00 15.63           C  
ATOM   1245  C   ALA A 158      10.332  10.578  31.822  1.00 16.36           C  
ATOM   1246  O   ALA A 158      10.061   9.834  32.772  1.00 17.49           O  
ATOM   1247  CB  ALA A 158      12.815  10.833  31.958  1.00 16.77           C  
ATOM   1248  N   VAL A 159       9.714  10.531  30.635  1.00 15.34           N  
ATOM   1249  CA  VAL A 159       8.656   9.580  30.384  0.50 15.45           C  
ATOM   1251  C   VAL A 159       8.798   8.962  28.997  1.00 15.40           C  
ATOM   1252  O   VAL A 159       9.124   9.624  28.011  1.00 14.53           O  
ATOM   1253  CB  VAL A 159       7.270  10.199  30.538  0.50 15.47           C  
ATOM   1255  CG1 VAL A 159       6.979  10.519  32.015  0.50 15.54           C  
ATOM   1257  CG2 VAL A 159       7.154  11.427  29.693  0.50 16.71           C  
ATOM   1259  N   ILE A 160       8.592   7.646  28.954  1.00 15.09           N  
ATOM   1260  CA  ILE A 160       8.646   6.897  27.693  1.00 14.90           C  
ATOM   1261  C   ILE A 160       7.465   7.294  26.845  1.00 13.63           C  
ATOM   1262  O   ILE A 160       6.330   7.305  27.319  1.00 12.83           O  
ATOM   1263  CB  ILE A 160       8.637   5.372  27.952  1.00 15.69           C  
ATOM   1264  CG1 ILE A 160       9.851   4.998  28.788  1.00 17.11           C  
ATOM   1265  CG2 ILE A 160       8.635   4.581  26.639  1.00 15.93           C  
ATOM   1266  CD1 ILE A 160       9.834   3.542  29.311  1.00 19.28           C  
ATOM   1267  N   ARG A 161       7.703   7.591  25.570  1.00 12.71           N  
ATOM   1268  CA  ARG A 161       6.637   8.000  24.674  1.00 12.91           C  
ATOM   1269  C   ARG A 161       5.888   6.771  24.173  1.00 12.95           C  
ATOM   1270  O   ARG A 161       6.500   5.869  23.611  1.00 10.94           O  
ATOM   1271  CB  ARG A 161       7.185   8.782  23.478  1.00 12.92           C  
ATOM   1272  CG  ARG A 161       6.114   9.529  22.736  1.00 11.62           C  
ATOM   1273  CD  ARG A 161       6.599  10.107  21.444  1.00 12.75           C  
ATOM   1274  NE  ARG A 161       7.591  11.159  21.671  1.00 12.03           N  
ATOM   1275  CZ  ARG A 161       8.048  11.955  20.718  1.00 11.71           C  
ATOM   1276  NH1 ARG A 161       7.629  11.792  19.486  1.00 10.98           N  
ATOM   1277  NH2 ARG A 161       8.938  12.916  21.006  1.00 12.70           N  
ATOM   1278  N   LEU A 162       4.577   6.755  24.384  1.00 14.14           N  
ATOM   1279  CA  LEU A 162       3.725   5.625  23.973  1.00 16.15           C  
ATOM   1280  C   LEU A 162       2.860   5.977  22.781  1.00 17.99           C  
ATOM   1281  O   LEU A 162       2.507   7.140  22.562  1.00 19.60           O  
ATOM   1282  CB  LEU A 162       2.801   5.180  25.125  1.00 15.88           C  
ATOM   1283  CG  LEU A 162       3.520   4.732  26.379  1.00 15.85           C  
ATOM   1284  CD1 LEU A 162       2.493   4.316  27.429  1.00 17.40           C  
ATOM   1285  CD2 LEU A 162       4.529   3.640  26.143  1.00 16.44           C  
ATOM   1286  N   GLY A 163       2.515   4.966  21.993  1.00 20.04           N  
ATOM   1287  CA  GLY A 163       1.899   5.195  20.698  1.00 21.18           C  
ATOM   1288  C   GLY A 163       0.419   4.931  20.684  1.00 23.02           C  
ATOM   1289  O   GLY A 163      -0.098   4.322  21.606  1.00 24.16           O  
ATOM   1290  N   ASP A 164      -0.245   5.384  19.619  1.00 24.75           N  
ATOM   1291  CA  ASP A 164      -1.684   5.158  19.431  1.00 25.16           C  
ATOM   1292  C   ASP A 164      -2.023   4.438  18.120  1.00 26.06           C  
ATOM   1293  O   ASP A 164      -3.130   3.923  17.995  1.00 27.90           O  
ATOM   1294  CB  ASP A 164      -2.487   6.473  19.554  0.50 25.81           C  
ATOM   1295  CG  ASP A 164      -1.794   7.661  18.920  0.50 25.87           C  
ATOM   1296  OD1 ASP A 164      -0.796   7.452  18.215  0.50 27.04           O  
ATOM   1297  OD2 ASP A 164      -2.234   8.817  19.153  0.50 27.41           O  
ATOM   1298  N   ARG A 165      -1.101   4.405  17.150  1.00 25.08           N  
ATOM   1299  CA  ARG A 165      -1.302   3.588  15.929  1.00 24.54           C  
ATOM   1300  C   ARG A 165      -0.457   2.304  15.993  1.00 23.92           C  
ATOM   1301  O   ARG A 165      -0.532   1.440  15.103  1.00 20.97           O  
ATOM   1302  CB  ARG A 165      -1.013   4.398  14.646  1.00 25.59           C  
ATOM   1303  CG  ARG A 165      -1.798   5.715  14.527  1.00 28.62           C  
ATOM   1304  CD  ARG A 165      -3.308   5.516  14.374  1.00 35.51           C  
ATOM   1305  NE  ARG A 165      -3.741   5.317  12.977  1.00 39.54           N  
ATOM   1306  CZ  ARG A 165      -4.031   4.138  12.402  1.00 40.22           C  
ATOM   1307  NH1 ARG A 165      -3.960   2.992  13.078  1.00 40.04           N  
ATOM   1308  NH2 ARG A 165      -4.409   4.102  11.122  1.00 40.78           N  
ATOM   1309  N   LYS A 166       0.349   2.191  17.051  1.00 22.68           N  
ATOM   1310  CA  LYS A 166       0.903   0.931  17.448  1.00 22.33           C  
ATOM   1311  C   LYS A 166       0.772   0.831  18.966  1.00 21.93           C  
ATOM   1312  O   LYS A 166       0.844   1.830  19.693  1.00 23.26           O  
ATOM   1313  CB  LYS A 166       2.359   0.797  17.008  1.00 22.65           C  
ATOM   1314  CG  LYS A 166       2.986  -0.571  17.374  1.00 23.95           C  
ATOM   1315  CD  LYS A 166       4.498  -0.623  17.350  1.00 21.85           C  
ATOM   1316  CE  LYS A 166       5.167   0.234  18.350  1.00 19.04           C  
ATOM   1317  NZ  LYS A 166       5.334  -0.364  19.705  1.00 12.68           N  
ATOM   1318  N   ARG A 167       0.565  -0.370  19.459  1.00 19.76           N  
ATOM   1319  CA  ARG A 167       0.474  -0.561  20.890  1.00 18.80           C  
ATOM   1320  C   ARG A 167       1.876  -0.518  21.485  1.00 17.36           C  
ATOM   1321  O   ARG A 167       2.819  -1.071  20.907  1.00 17.35           O  
ATOM   1322  CB  ARG A 167      -0.193  -1.901  21.205  1.00 18.94           C  
ATOM   1323  CG  ARG A 167      -1.652  -1.975  20.777  1.00 20.55           C  
ATOM   1324  CD  ARG A 167      -2.596  -1.219  21.734  1.00 21.50           C  
ATOM   1325  NE  ARG A 167      -2.553  -1.705  23.128  1.00 20.66           N  
ATOM   1326  CZ  ARG A 167      -3.473  -1.403  24.052  1.00 21.78           C  
ATOM   1327  NH1 ARG A 167      -4.503  -0.632  23.735  1.00 22.40           N  
ATOM   1328  NH2 ARG A 167      -3.377  -1.872  25.294  1.00 20.32           N  
ATOM   1329  N   GLY A 168       2.008   0.178  22.611  1.00 15.86           N  
ATOM   1330  CA  GLY A 168       3.252   0.242  23.337  1.00 15.62           C  
ATOM   1331  C   GLY A 168       4.096   1.454  22.957  1.00 14.48           C  
ATOM   1332  O   GLY A 168       3.606   2.395  22.366  1.00 14.48           O  
ATOM   1333  N   PRO A 169       5.392   1.405  23.289  1.00 14.24           N  
ATOM   1334  CA  PRO A 169       6.357   2.475  23.006  1.00 13.35           C  
ATOM   1335  C   PRO A 169       6.414   2.843  21.537  1.00 12.52           C  
ATOM   1336  O   PRO A 169       6.413   1.972  20.688  1.00 11.18           O  
ATOM   1337  CB  PRO A 169       7.688   1.882  23.476  1.00 13.66           C  
ATOM   1338  CG  PRO A 169       7.280   0.922  24.578  1.00 16.49           C  
ATOM   1339  CD  PRO A 169       6.032   0.286  24.005  1.00 14.00           C  
ATOM   1340  N   VAL A 170       6.439   4.149  21.268  1.00 10.94           N  
ATOM   1341  CA  VAL A 170       6.731   4.669  19.953  1.00 11.09           C  
ATOM   1342  C   VAL A 170       8.121   4.189  19.564  1.00 10.13           C  
ATOM   1343  O   VAL A 170       9.062   4.266  20.367  1.00 11.15           O  
ATOM   1344  CB  VAL A 170       6.675   6.224  19.948  1.00 10.30           C  
ATOM   1345  CG1 VAL A 170       7.145   6.790  18.598  1.00 13.58           C  
ATOM   1346  CG2 VAL A 170       5.273   6.745  20.298  1.00 11.33           C  
ATOM   1347  N   ILE A 171       8.236   3.711  18.328  1.00  9.18           N  
ATOM   1348  CA  ILE A 171       9.504   3.242  17.786  1.00  9.14           C  
ATOM   1349  C   ILE A 171       9.949   4.193  16.665  1.00  8.58           C  
ATOM   1350  O   ILE A 171       9.161   4.561  15.761  1.00  8.08           O  
ATOM   1351  CB  ILE A 171       9.417   1.817  17.215  1.00  8.78           C  
ATOM   1352  CG1 ILE A 171       8.950   0.808  18.260  1.00  9.33           C  
ATOM   1353  CG2 ILE A 171      10.813   1.335  16.679  1.00  7.18           C  
ATOM   1354  CD1 ILE A 171       9.796   0.711  19.516  1.00  8.04           C  
ATOM   1355  N   THR A 172      11.221   4.578  16.728  1.00  8.26           N  
ATOM   1356  CA  THR A 172      11.776   5.518  15.747  1.00  8.82           C  
ATOM   1357  C   THR A 172      12.058   4.875  14.393  1.00  8.72           C  
ATOM   1358  O   THR A 172      12.044   3.658  14.257  1.00  8.09           O  
ATOM   1359  CB  THR A 172      13.075   6.117  16.241  1.00  9.49           C  
ATOM   1360  OG1 THR A 172      14.080   5.098  16.284  1.00  7.69           O  
ATOM   1361  CG2 THR A 172      12.877   6.816  17.615  1.00  7.88           C  
ATOM   1362  N   ASP A 173      12.390   5.703  13.404  1.00  8.59           N  
ATOM   1363  CA  ASP A 173      12.770   5.180  12.091  1.00  9.02           C  
ATOM   1364  C   ASP A 173      13.976   4.232  12.174  1.00  8.13           C  
ATOM   1365  O   ASP A 173      14.190   3.409  11.261  1.00 10.15           O  
ATOM   1366  CB  ASP A 173      13.043   6.334  11.105  1.00  7.95           C  
ATOM   1367  CG  ASP A 173      11.788   7.155  10.771  1.00  9.99           C  
ATOM   1368  OD1 ASP A 173      10.667   6.747  11.148  1.00 11.01           O  
ATOM   1369  OD2 ASP A 173      11.941   8.202  10.123  1.00 10.48           O  
ATOM   1370  N   ASN A 174      14.790   4.350  13.242  1.00  8.73           N  
ATOM   1371  CA  ASN A 174      15.948   3.480  13.497  1.00  9.02           C  
ATOM   1372  C   ASN A 174      15.662   2.253  14.394  1.00  8.82           C  
ATOM   1373  O   ASN A 174      16.585   1.469  14.672  1.00 10.10           O  
ATOM   1374  CB  ASN A 174      17.074   4.297  14.118  1.00  8.30           C  
ATOM   1375  CG  ASN A 174      17.192   5.669  13.454  1.00 11.64           C  
ATOM   1376  OD1 ASN A 174      17.533   5.731  12.300  1.00 11.20           O  
ATOM   1377  ND2 ASN A 174      16.749   6.741  14.145  1.00 11.13           N  
ATOM   1378  N   GLY A 175      14.406   2.071  14.805  1.00  9.12           N  
ATOM   1379  CA  GLY A 175      14.027   0.909  15.643  1.00  9.27           C  
ATOM   1380  C   GLY A 175      14.190   1.045  17.143  1.00  9.67           C  
ATOM   1381  O   GLY A 175      14.120   0.039  17.864  1.00 10.62           O  
ATOM   1382  N   ASN A 176      14.393   2.271  17.625  1.00  9.39           N  
ATOM   1383  CA  ASN A 176      14.642   2.526  19.041  1.00  9.05           C  
ATOM   1384  C   ASN A 176      13.430   3.166  19.673  1.00  8.77           C  
ATOM   1385  O   ASN A 176      12.512   3.586  18.969  1.00  7.75           O  
ATOM   1386  CB  ASN A 176      15.859   3.440  19.162  1.00  8.91           C  
ATOM   1387  CG  ASN A 176      17.115   2.772  18.669  1.00  9.74           C  
ATOM   1388  OD1 ASN A 176      17.877   3.333  17.843  1.00 12.79           O  
ATOM   1389  ND2 ASN A 176      17.328   1.554  19.129  1.00  5.46           N  
ATOM   1390  N   MET A 177      13.452   3.272  21.004  1.00  8.60           N  
ATOM   1391  CA  MET A 177      12.404   3.937  21.757  1.00 10.12           C  
ATOM   1392  C   MET A 177      12.706   5.446  21.924  1.00  9.92           C  
ATOM   1393  O   MET A 177      13.806   5.900  21.634  1.00  9.12           O  
ATOM   1394  CB  MET A 177      12.251   3.266  23.114  1.00 10.01           C  
ATOM   1395  CG  MET A 177      11.581   1.905  22.999  1.00 13.66           C  
ATOM   1396  SD  MET A 177      11.615   1.020  24.562  1.00 15.88           S  
ATOM   1397  CE  MET A 177      10.939  -0.588  24.199  1.00 19.24           C  
ATOM   1398  N   ILE A 178      11.713   6.209  22.372  1.00  9.99           N  
ATOM   1399  CA  ILE A 178      11.875   7.628  22.682  1.00 10.05           C  
ATOM   1400  C   ILE A 178      11.458   7.862  24.141  1.00 10.01           C  
ATOM   1401  O   ILE A 178      10.377   7.464  24.562  1.00  9.51           O  
ATOM   1402  CB  ILE A 178      10.992   8.527  21.805  1.00 11.15           C  
ATOM   1403  CG1 ILE A 178      11.272   8.322  20.323  1.00 12.69           C  
ATOM   1404  CG2 ILE A 178      11.170  10.017  22.136  1.00 11.37           C  
ATOM   1405  CD1 ILE A 178      10.049   8.572  19.480  1.00 13.53           C  
ATOM   1406  N   ILE A 179      12.334   8.513  24.885  1.00 10.22           N  
ATOM   1407  CA  ILE A 179      12.016   9.101  26.171  1.00  9.98           C  
ATOM   1408  C   ILE A 179      11.968  10.638  25.985  1.00 10.41           C  
ATOM   1409  O   ILE A 179      12.872  11.237  25.385  1.00 10.27           O  
ATOM   1410  CB  ILE A 179      13.078   8.731  27.206  1.00  9.89           C  
ATOM   1411  CG1 ILE A 179      13.098   7.215  27.448  1.00 10.49           C  
ATOM   1412  CG2 ILE A 179      12.837   9.519  28.522  1.00 10.98           C  
ATOM   1413  CD1 ILE A 179      14.380   6.753  28.112  1.00 12.59           C  
ATOM   1414  N   ASP A 180      10.914  11.273  26.495  1.00 10.04           N  
ATOM   1415  CA  ASP A 180      10.840  12.724  26.507  1.00 10.19           C  
ATOM   1416  C   ASP A 180      11.102  13.159  27.949  1.00 10.24           C  
ATOM   1417  O   ASP A 180      10.511  12.606  28.909  1.00 10.21           O  
ATOM   1418  CB  ASP A 180       9.492  13.229  26.003  1.00 10.22           C  
ATOM   1419  CG  ASP A 180       9.229  12.851  24.555  1.00 12.11           C  
ATOM   1420  OD1 ASP A 180       9.930  13.420  23.667  1.00 12.43           O  
ATOM   1421  OD2 ASP A 180       8.306  12.025  24.310  1.00 13.10           O  
ATOM   1422  N   VAL A 181      12.023  14.103  28.094  1.00 10.48           N  
ATOM   1423  CA  VAL A 181      12.470  14.561  29.410  1.00 10.83           C  
ATOM   1424  C   VAL A 181      12.434  16.090  29.530  1.00 11.74           C  
ATOM   1425  O   VAL A 181      13.043  16.816  28.747  1.00 11.14           O  
ATOM   1426  CB  VAL A 181      13.858  13.971  29.775  1.00 10.87           C  
ATOM   1427  CG1 VAL A 181      15.004  14.442  28.815  1.00 10.42           C  
ATOM   1428  CG2 VAL A 181      14.189  14.267  31.250  1.00 11.24           C  
ATOM   1429  N   PHE A 182      11.647  16.561  30.500  1.00 12.13           N  
ATOM   1430  CA  PHE A 182      11.671  17.970  30.884  1.00 13.59           C  
ATOM   1431  C   PHE A 182      12.875  18.216  31.754  1.00 14.34           C  
ATOM   1432  O   PHE A 182      13.079  17.501  32.741  1.00 14.41           O  
ATOM   1433  CB  PHE A 182      10.422  18.333  31.681  1.00 14.58           C  
ATOM   1434  CG  PHE A 182       9.184  18.424  30.864  1.00 15.86           C  
ATOM   1435  CD1 PHE A 182       8.938  19.539  30.082  1.00 18.99           C  
ATOM   1436  CD2 PHE A 182       8.248  17.412  30.896  1.00 18.34           C  
ATOM   1437  CE1 PHE A 182       7.774  19.643  29.329  1.00 17.68           C  
ATOM   1438  CE2 PHE A 182       7.077  17.528  30.149  1.00 19.39           C  
ATOM   1439  CZ  PHE A 182       6.858  18.636  29.373  1.00 18.06           C  
ATOM   1440  N   MET A 183      13.663  19.222  31.387  1.00 14.85           N  
ATOM   1441  CA  MET A 183      14.869  19.606  32.125  1.00 16.16           C  
ATOM   1442  C   MET A 183      14.968  21.102  32.208  1.00 16.24           C  
ATOM   1443  O   MET A 183      14.432  21.809  31.371  1.00 15.01           O  
ATOM   1444  CB  MET A 183      16.115  19.090  31.421  1.00 16.00           C  
ATOM   1445  CG  MET A 183      16.092  17.595  31.291  1.00 18.93           C  
ATOM   1446  SD  MET A 183      17.676  16.857  30.982  1.00 21.39           S  
ATOM   1447  CE  MET A 183      18.356  16.826  32.630  1.00 25.07           C  
ATOM   1448  N   ASN A 184      15.678  21.552  33.238  1.00 17.28           N  
ATOM   1449  CA  ASN A 184      16.087  22.912  33.392  1.00 19.13           C  
ATOM   1450  C   ASN A 184      17.411  23.085  32.652  1.00 18.83           C  
ATOM   1451  O   ASN A 184      18.466  22.696  33.165  1.00 19.79           O  
ATOM   1452  CB  ASN A 184      16.234  23.200  34.901  1.00 19.20           C  
ATOM   1453  CG  ASN A 184      16.305  24.665  35.203  1.00 23.58           C  
ATOM   1454  OD1 ASN A 184      16.445  25.505  34.288  1.00 25.54           O  
ATOM   1455  ND2 ASN A 184      16.254  25.008  36.519  1.00 24.15           N  
ATOM   1456  N   ILE A 185      17.355  23.648  31.454  1.00 17.60           N  
ATOM   1457  CA  ILE A 185      18.530  23.714  30.600  1.00 18.01           C  
ATOM   1458  C   ILE A 185      19.327  24.978  30.946  1.00 18.41           C  
ATOM   1459  O   ILE A 185      18.967  26.080  30.563  1.00 19.45           O  
ATOM   1460  CB  ILE A 185      18.146  23.694  29.111  1.00 17.07           C  
ATOM   1461  CG1 ILE A 185      17.235  22.496  28.802  1.00 15.70           C  
ATOM   1462  CG2 ILE A 185      19.409  23.659  28.236  1.00 16.67           C  
ATOM   1463  CD1 ILE A 185      16.743  22.430  27.369  1.00 15.62           C  
ATOM   1464  N   ASP A 186      20.398  24.786  31.694  1.00 20.55           N  
ATOM   1465  CA  ASP A 186      21.305  25.871  32.061  1.00 20.43           C  
ATOM   1466  C   ASP A 186      22.274  26.110  30.900  1.00 20.62           C  
ATOM   1467  O   ASP A 186      22.339  27.216  30.364  1.00 22.85           O  
ATOM   1468  CB  ASP A 186      22.035  25.486  33.356  1.00 21.68           C  
ATOM   1469  CG  ASP A 186      23.037  26.539  33.819  1.00 24.59           C  
ATOM   1470  OD1 ASP A 186      23.105  27.635  33.195  1.00 32.45           O  
ATOM   1471  OD2 ASP A 186      23.757  26.261  34.815  1.00 30.73           O  
ATOM   1472  N   ASP A 187      22.963  25.058  30.469  1.00 18.58           N  
ATOM   1473  CA  ASP A 187      23.978  25.142  29.422  1.00 17.01           C  
ATOM   1474  C   ASP A 187      23.588  24.124  28.329  1.00 15.15           C  
ATOM   1475  O   ASP A 187      23.820  22.949  28.521  1.00 14.36           O  
ATOM   1476  CB  ASP A 187      25.333  24.769  30.032  1.00 17.11           C  
ATOM   1477  CG  ASP A 187      26.495  24.864  29.036  1.00 18.72           C  
ATOM   1478  OD1 ASP A 187      26.322  24.746  27.802  1.00 18.16           O  
ATOM   1479  OD2 ASP A 187      27.618  25.067  29.512  1.00 21.85           O  
ATOM   1480  N   ALA A 188      22.969  24.574  27.243  1.00 13.51           N  
ATOM   1481  CA  ALA A 188      22.411  23.637  26.244  1.00 13.60           C  
ATOM   1482  C   ALA A 188      23.516  22.793  25.554  1.00 12.76           C  
ATOM   1483  O   ALA A 188      23.348  21.581  25.320  1.00 11.19           O  
ATOM   1484  CB  ALA A 188      21.593  24.363  25.224  1.00 13.67           C  
ATOM   1485  N   ILE A 189      24.635  23.446  25.220  1.00 12.28           N  
ATOM   1486  CA  ILE A 189      25.753  22.763  24.546  1.00 12.15           C  
ATOM   1487  C   ILE A 189      26.271  21.606  25.411  1.00 11.83           C  
ATOM   1488  O   ILE A 189      26.442  20.460  24.928  1.00 11.66           O  
ATOM   1489  CB  ILE A 189      26.878  23.785  24.162  1.00 11.85           C  
ATOM   1490  CG1 ILE A 189      26.409  24.679  23.005  1.00 12.20           C  
ATOM   1491  CG2 ILE A 189      28.176  23.043  23.782  1.00 13.45           C  
ATOM   1492  CD1 ILE A 189      27.338  25.872  22.692  1.00 13.28           C  
ATOM   1493  N   GLU A 190      26.467  21.877  26.706  1.00 12.01           N  
ATOM   1494  CA  GLU A 190      26.949  20.873  27.636  1.00 11.48           C  
ATOM   1495  C   GLU A 190      25.896  19.802  27.916  1.00 10.80           C  
ATOM   1496  O   GLU A 190      26.214  18.635  27.986  1.00 10.26           O  
ATOM   1497  CB  GLU A 190      27.410  21.516  28.947  1.00 13.07           C  
ATOM   1498  CG  GLU A 190      27.944  20.515  29.970  1.00 12.01           C  
ATOM   1499  CD  GLU A 190      29.142  19.711  29.498  1.00 15.69           C  
ATOM   1500  OE1 GLU A 190      29.851  20.180  28.581  1.00 15.85           O  
ATOM   1501  OE2 GLU A 190      29.376  18.622  30.086  1.00 16.70           O  
ATOM   1502  N   LEU A 191      24.636  20.189  28.014  1.00 10.88           N  
ATOM   1503  CA  LEU A 191      23.569  19.193  28.313  1.00 10.68           C  
ATOM   1504  C   LEU A 191      23.388  18.192  27.154  1.00 10.33           C  
ATOM   1505  O   LEU A 191      23.250  16.995  27.386  1.00 10.24           O  
ATOM   1506  CB  LEU A 191      22.256  19.892  28.600  1.00 10.65           C  
ATOM   1507  CG  LEU A 191      21.074  19.010  28.986  1.00 11.10           C  
ATOM   1508  CD1 LEU A 191      21.466  18.054  30.128  1.00 12.83           C  
ATOM   1509  CD2 LEU A 191      19.819  19.885  29.313  1.00 11.16           C  
ATOM   1510  N   GLU A 192      23.410  18.725  25.939  1.00 10.78           N  
ATOM   1511  CA  GLU A 192      23.375  17.907  24.710  1.00 11.04           C  
ATOM   1512  C   GLU A 192      24.466  16.813  24.794  1.00 10.81           C  
ATOM   1513  O   GLU A 192      24.223  15.622  24.537  1.00 10.82           O  
ATOM   1514  CB  GLU A 192      23.611  18.796  23.493  1.00 10.61           C  
ATOM   1515  CG  GLU A 192      23.534  18.021  22.148  1.00 11.43           C  
ATOM   1516  CD  GLU A 192      23.842  18.885  20.944  1.00 12.05           C  
ATOM   1517  OE1 GLU A 192      24.074  20.109  21.108  1.00 17.00           O  
ATOM   1518  OE2 GLU A 192      23.858  18.350  19.808  1.00 12.76           O  
ATOM   1519  N   LYS A 193      25.682  17.266  25.124  1.00 10.70           N  
ATOM   1520  CA  LYS A 193      26.866  16.410  25.259  0.50 11.26           C  
ATOM   1522  C   LYS A 193      26.663  15.353  26.338  1.00 11.36           C  
ATOM   1523  O   LYS A 193      26.949  14.163  26.134  1.00 10.26           O  
ATOM   1524  CB  LYS A 193      28.117  17.255  25.600  0.50 11.62           C  
ATOM   1526  CG  LYS A 193      28.695  18.060  24.421  0.50 11.75           C  
ATOM   1528  CD  LYS A 193      29.847  19.008  24.832  0.50 11.77           C  
ATOM   1530  CE  LYS A 193      30.121  20.105  23.803  0.50 13.16           C  
ATOM   1532  NZ  LYS A 193      31.206  21.053  24.237  0.50 12.35           N  
ATOM   1534  N   GLU A 194      26.200  15.795  27.501  1.00 11.38           N  
ATOM   1535  CA  GLU A 194      26.073  14.864  28.636  1.00 11.52           C  
ATOM   1536  C   GLU A 194      24.955  13.822  28.395  1.00 10.77           C  
ATOM   1537  O   GLU A 194      25.094  12.633  28.763  1.00 10.47           O  
ATOM   1538  CB  GLU A 194      25.836  15.630  29.925  1.00 12.04           C  
ATOM   1539  CG  GLU A 194      27.052  16.442  30.377  1.00 12.83           C  
ATOM   1540  CD  GLU A 194      26.849  17.153  31.711  1.00 15.85           C  
ATOM   1541  OE1 GLU A 194      25.842  16.868  32.401  1.00 21.37           O  
ATOM   1542  OE2 GLU A 194      27.707  17.993  32.080  1.00 18.78           O  
ATOM   1543  N   ILE A 195      23.854  14.255  27.786  1.00  9.65           N  
ATOM   1544  CA  ILE A 195      22.746  13.318  27.527  1.00  9.46           C  
ATOM   1545  C   ILE A 195      23.240  12.251  26.544  1.00  9.64           C  
ATOM   1546  O   ILE A 195      22.999  11.040  26.744  1.00  7.79           O  
ATOM   1547  CB  ILE A 195      21.460  14.023  27.016  1.00  8.15           C  
ATOM   1548  CG1 ILE A 195      20.791  14.795  28.151  1.00  8.27           C  
ATOM   1549  CG2 ILE A 195      20.452  12.987  26.411  1.00  9.16           C  
ATOM   1550  CD1 ILE A 195      19.676  15.676  27.718  1.00  8.92           C  
ATOM   1551  N   ASN A 196      24.001  12.672  25.535  1.00 10.21           N  
ATOM   1552  CA  ASN A 196      24.518  11.713  24.545  1.00 10.78           C  
ATOM   1553  C   ASN A 196      25.519  10.715  25.110  1.00 12.01           C  
ATOM   1554  O   ASN A 196      25.685   9.665  24.541  1.00 11.78           O  
ATOM   1555  CB  ASN A 196      25.127  12.437  23.331  1.00 11.13           C  
ATOM   1556  CG  ASN A 196      24.064  12.926  22.340  1.00 11.98           C  
ATOM   1557  OD1 ASN A 196      24.286  13.900  21.578  1.00 13.49           O  
ATOM   1558  ND2 ASN A 196      22.905  12.252  22.340  1.00  8.41           N  
ATOM   1559  N   ASN A 197      26.158  11.040  26.236  1.00 11.45           N  
ATOM   1560  CA  ASN A 197      27.141  10.179  26.864  1.00 11.63           C  
ATOM   1561  C   ASN A 197      26.561   9.191  27.896  1.00 12.09           C  
ATOM   1562  O   ASN A 197      27.298   8.417  28.529  1.00 12.18           O  
ATOM   1563  CB  ASN A 197      28.246  11.030  27.489  1.00 12.42           C  
ATOM   1564  CG  ASN A 197      29.535  10.256  27.681  1.00 16.56           C  
ATOM   1565  OD1 ASN A 197      29.955   9.494  26.800  1.00 18.32           O  
ATOM   1566  ND2 ASN A 197      30.196  10.468  28.834  1.00 19.04           N  
ATOM   1567  N   ILE A 198      25.245   9.214  28.071  1.00 10.99           N  
ATOM   1568  CA  ILE A 198      24.547   8.198  28.844  1.00 10.89           C  
ATOM   1569  C   ILE A 198      24.491   6.901  27.998  1.00 10.93           C  
ATOM   1570  O   ILE A 198      23.955   6.931  26.874  1.00 10.45           O  
ATOM   1571  CB  ILE A 198      23.103   8.589  29.170  1.00  9.20           C  
ATOM   1572  CG1 ILE A 198      23.007   9.942  29.960  1.00  9.08           C  
ATOM   1573  CG2 ILE A 198      22.443   7.402  29.928  1.00 10.67           C  
ATOM   1574  CD1 ILE A 198      21.548  10.450  30.130  1.00 10.41           C  
ATOM   1575  N   PRO A 199      25.041   5.785  28.523  1.00 11.75           N  
ATOM   1576  CA  PRO A 199      24.938   4.518  27.773  1.00 11.33           C  
ATOM   1577  C   PRO A 199      23.486   4.159  27.450  1.00 10.65           C  
ATOM   1578  O   PRO A 199      22.621   4.107  28.334  1.00 10.52           O  
ATOM   1579  CB  PRO A 199      25.580   3.480  28.719  1.00 11.75           C  
ATOM   1580  CG  PRO A 199      26.464   4.271  29.613  1.00 12.60           C  
ATOM   1581  CD  PRO A 199      25.849   5.623  29.748  1.00 12.18           C  
ATOM   1582  N   GLY A 200      23.244   3.906  26.166  1.00 10.25           N  
ATOM   1583  CA  GLY A 200      21.903   3.554  25.698  1.00  9.73           C  
ATOM   1584  C   GLY A 200      21.238   4.716  25.003  1.00  9.79           C  
ATOM   1585  O   GLY A 200      20.268   4.511  24.306  1.00  9.64           O  
ATOM   1586  N   VAL A 201      21.746   5.929  25.197  1.00  8.74           N  
ATOM   1587  CA  VAL A 201      21.256   7.081  24.446  1.00  8.49           C  
ATOM   1588  C   VAL A 201      21.936   7.139  23.078  1.00  9.15           C  
ATOM   1589  O   VAL A 201      23.160   7.198  22.973  1.00 11.36           O  
ATOM   1590  CB  VAL A 201      21.457   8.392  25.178  1.00  8.79           C  
ATOM   1591  CG1 VAL A 201      21.090   9.587  24.253  1.00  7.13           C  
ATOM   1592  CG2 VAL A 201      20.604   8.429  26.463  1.00  8.19           C  
ATOM   1593  N   VAL A 202      21.122   7.138  22.039  1.00  8.49           N  
ATOM   1594  CA  VAL A 202      21.575   7.296  20.669  1.00  9.11           C  
ATOM   1595  C   VAL A 202      21.798   8.778  20.276  1.00  9.72           C  
ATOM   1596  O   VAL A 202      22.844   9.153  19.730  1.00 10.63           O  
ATOM   1597  CB  VAL A 202      20.577   6.652  19.719  1.00  9.09           C  
ATOM   1598  CG1 VAL A 202      20.967   6.916  18.264  1.00  9.21           C  
ATOM   1599  CG2 VAL A 202      20.421   5.126  19.984  1.00 10.88           C  
ATOM   1600  N   GLU A 203      20.788   9.598  20.539  1.00  8.65           N  
ATOM   1601  CA  GLU A 203      20.810  11.019  20.203  1.00  8.75           C  
ATOM   1602  C   GLU A 203      19.694  11.708  20.970  1.00  8.41           C  
ATOM   1603  O   GLU A 203      18.738  11.060  21.400  1.00  8.11           O  
ATOM   1604  CB  GLU A 203      20.609  11.202  18.691  1.00  8.53           C  
ATOM   1605  CG  GLU A 203      20.817  12.632  18.173  1.00  9.77           C  
ATOM   1606  CD  GLU A 203      22.159  13.209  18.588  1.00 11.98           C  
ATOM   1607  OE1 GLU A 203      23.191  12.844  17.963  1.00 11.36           O  
ATOM   1608  OE2 GLU A 203      22.176  14.012  19.570  1.00 10.94           O  
ATOM   1609  N   ASN A 204      19.820  13.026  21.142  1.00  8.00           N  
ATOM   1610  CA  ASN A 204      18.789  13.837  21.766  1.00  8.72           C  
ATOM   1611  C   ASN A 204      18.431  15.069  20.923  1.00  9.03           C  
ATOM   1612  O   ASN A 204      19.172  15.455  19.992  1.00  9.15           O  
ATOM   1613  CB  ASN A 204      19.186  14.235  23.196  1.00  8.16           C  
ATOM   1614  CG  ASN A 204      20.404  15.163  23.243  1.00  9.17           C  
ATOM   1615  OD1 ASN A 204      21.587  14.721  23.418  1.00 12.96           O  
ATOM   1616  ND2 ASN A 204      20.139  16.438  23.089  1.00  6.59           N  
ATOM   1617  N   GLY A 205      17.298  15.678  21.274  1.00  7.37           N  
ATOM   1618  CA  GLY A 205      16.699  16.713  20.508  1.00  8.08           C  
ATOM   1619  C   GLY A 205      17.195  18.124  20.715  1.00  8.04           C  
ATOM   1620  O   GLY A 205      16.677  19.032  20.102  1.00  7.97           O  
ATOM   1621  N   ILE A 206      18.182  18.313  21.582  1.00  8.09           N  
ATOM   1622  CA  ILE A 206      18.804  19.632  21.699  1.00  8.54           C  
ATOM   1623  C   ILE A 206      19.705  19.858  20.465  1.00  8.53           C  
ATOM   1624  O   ILE A 206      20.561  19.027  20.159  1.00  8.73           O  
ATOM   1625  CB  ILE A 206      19.649  19.761  22.976  1.00  8.26           C  
ATOM   1626  CG1 ILE A 206      18.789  19.537  24.230  1.00  9.39           C  
ATOM   1627  CG2 ILE A 206      20.341  21.175  23.058  1.00  8.59           C  
ATOM   1628  CD1 ILE A 206      19.647  19.437  25.533  1.00 10.87           C  
ATOM   1629  N   PHE A 207      19.508  20.959  19.756  1.00  9.35           N  
ATOM   1630  CA  PHE A 207      20.376  21.312  18.605  1.00  9.23           C  
ATOM   1631  C   PHE A 207      21.028  22.636  18.933  1.00  9.80           C  
ATOM   1632  O   PHE A 207      20.333  23.590  19.249  1.00 10.40           O  
ATOM   1633  CB  PHE A 207      19.622  21.492  17.287  1.00  9.88           C  
ATOM   1634  CG  PHE A 207      19.227  20.215  16.610  1.00  9.13           C  
ATOM   1635  CD1 PHE A 207      19.489  20.021  15.264  1.00  6.71           C  
ATOM   1636  CD2 PHE A 207      18.555  19.223  17.319  1.00  9.04           C  
ATOM   1637  CE1 PHE A 207      19.073  18.860  14.623  1.00  8.58           C  
ATOM   1638  CE2 PHE A 207      18.138  18.059  16.688  1.00 10.78           C  
ATOM   1639  CZ  PHE A 207      18.423  17.861  15.367  1.00  8.08           C  
ATOM   1640  N   THR A 208      22.337  22.673  18.841  1.00 10.85           N  
ATOM   1641  CA  THR A 208      23.116  23.882  19.185  1.00 11.50           C  
ATOM   1642  C   THR A 208      23.989  24.378  18.022  1.00 12.27           C  
ATOM   1643  O   THR A 208      24.867  25.233  18.230  1.00 13.67           O  
ATOM   1644  CB  THR A 208      23.974  23.638  20.445  1.00 11.64           C  
ATOM   1645  OG1 THR A 208      24.884  22.563  20.201  1.00 12.61           O  
ATOM   1646  CG2 THR A 208      23.102  23.332  21.660  1.00 11.55           C  
ATOM   1647  N   LYS A 209      23.766  23.838  16.822  1.00 12.18           N  
ATOM   1648  CA  LYS A 209      24.412  24.324  15.619  1.00 13.14           C  
ATOM   1649  C   LYS A 209      23.364  24.652  14.599  1.00 13.51           C  
ATOM   1650  O   LYS A 209      22.535  23.791  14.253  1.00 15.35           O  
ATOM   1651  CB  LYS A 209      25.418  23.296  15.087  1.00 13.33           C  
ATOM   1652  CG  LYS A 209      26.398  22.777  16.141  1.00 13.17           C  
ATOM   1653  CD  LYS A 209      27.379  21.776  15.572  1.00 13.87           C  
ATOM   1654  CE  LYS A 209      28.354  21.294  16.658  1.00 16.39           C  
ATOM   1655  NZ  LYS A 209      29.288  20.299  16.096  1.00 22.19           N  
ATOM   1656  N   VAL A 210      23.379  25.891  14.109  1.00 13.54           N  
ATOM   1657  CA  VAL A 210      22.415  26.347  13.108  1.00 12.73           C  
ATOM   1658  C   VAL A 210      23.079  27.475  12.340  1.00 12.81           C  
ATOM   1659  O   VAL A 210      23.897  28.228  12.920  1.00 13.02           O  
ATOM   1660  CB  VAL A 210      21.055  26.818  13.741  1.00 13.32           C  
ATOM   1661  CG1 VAL A 210      21.200  28.113  14.528  1.00 14.48           C  
ATOM   1662  CG2 VAL A 210      19.960  27.003  12.653  1.00 14.67           C  
ATOM   1663  N   ASP A 211      22.743  27.592  11.061  1.00 12.06           N  
ATOM   1664  CA  ASP A 211      23.245  28.716  10.253  1.00 12.91           C  
ATOM   1665  C   ASP A 211      22.292  29.889  10.284  1.00 12.92           C  
ATOM   1666  O   ASP A 211      22.710  31.033  10.549  1.00 13.52           O  
ATOM   1667  CB  ASP A 211      23.566  28.290   8.843  1.00 12.89           C  
ATOM   1668  CG  ASP A 211      24.787  27.416   8.794  1.00 15.38           C  
ATOM   1669  OD1 ASP A 211      25.912  27.968   8.815  1.00 13.62           O  
ATOM   1670  OD2 ASP A 211      24.619  26.177   8.787  1.00 12.30           O  
ATOM   1671  N   LYS A 212      21.012  29.623  10.063  1.00 12.26           N  
ATOM   1672  CA  LYS A 212      20.028  30.679  10.185  1.00 13.61           C  
ATOM   1673  C   LYS A 212      18.651  30.105  10.436  1.00 12.77           C  
ATOM   1674  O   LYS A 212      18.392  28.926  10.159  1.00 11.57           O  
ATOM   1675  CB  LYS A 212      20.042  31.575   8.945  1.00 14.82           C  
ATOM   1676  CG  LYS A 212      19.671  30.881   7.665  1.00 16.80           C  
ATOM   1677  CD  LYS A 212      20.019  31.743   6.461  1.00 17.46           C  
ATOM   1678  CE  LYS A 212      19.436  31.191   5.164  1.00 19.60           C  
ATOM   1679  NZ  LYS A 212      19.680  32.096   3.971  1.00 20.32           N  
ATOM   1680  N   VAL A 213      17.758  30.964  10.910  1.00 12.56           N  
ATOM   1681  CA  VAL A 213      16.375  30.588  11.224  1.00 11.85           C  
ATOM   1682  C   VAL A 213      15.475  31.549  10.451  1.00 12.07           C  
ATOM   1683  O   VAL A 213      15.603  32.774  10.626  1.00 12.88           O  
ATOM   1684  CB  VAL A 213      16.068  30.699  12.741  1.00 11.04           C  
ATOM   1685  CG1 VAL A 213      14.593  30.265  13.033  1.00 11.25           C  
ATOM   1686  CG2 VAL A 213      17.032  29.882  13.580  1.00 11.07           C  
ATOM   1687  N   LEU A 214      14.644  31.022   9.549  1.00 11.26           N  
ATOM   1688  CA  LEU A 214      13.602  31.807   8.899  1.00 12.23           C  
ATOM   1689  C   LEU A 214      12.337  31.679   9.736  1.00 12.46           C  
ATOM   1690  O   LEU A 214      11.920  30.567  10.094  1.00 11.26           O  
ATOM   1691  CB  LEU A 214      13.311  31.355   7.453  1.00 12.45           C  
ATOM   1692  CG  LEU A 214      14.285  31.854   6.394  1.00 14.69           C  
ATOM   1693  CD1 LEU A 214      15.700  31.562   6.746  1.00 18.69           C  
ATOM   1694  CD2 LEU A 214      13.935  31.267   5.045  1.00 14.48           C  
ATOM   1695  N   VAL A 215      11.721  32.831  10.018  1.00 11.52           N  
ATOM   1696  CA  VAL A 215      10.584  32.912  10.900  1.00 11.97           C  
ATOM   1697  C   VAL A 215       9.439  33.557  10.166  1.00 12.55           C  
ATOM   1698  O   VAL A 215       9.548  34.703   9.693  1.00 11.76           O  
ATOM   1699  CB  VAL A 215      10.865  33.733  12.162  1.00 11.20           C  
ATOM   1700  CG1 VAL A 215       9.616  33.792  13.073  1.00 12.03           C  
ATOM   1701  CG2 VAL A 215      12.085  33.176  12.902  1.00 12.06           C  
ATOM   1702  N   GLY A 216       8.350  32.803  10.046  1.00 12.76           N  
ATOM   1703  CA  GLY A 216       7.142  33.322   9.407  1.00 12.29           C  
ATOM   1704  C   GLY A 216       6.392  34.149  10.418  1.00 12.48           C  
ATOM   1705  O   GLY A 216       6.037  33.651  11.446  1.00 11.96           O  
ATOM   1706  N   THR A 217       6.137  35.420  10.082  1.00 13.40           N  
ATOM   1707  CA  THR A 217       5.371  36.350  10.905  1.00 12.94           C  
ATOM   1708  C   THR A 217       4.271  36.977  10.026  1.00 12.96           C  
ATOM   1709  O   THR A 217       4.308  36.897   8.814  1.00 13.76           O  
ATOM   1710  CB  THR A 217       6.280  37.490  11.458  1.00 12.86           C  
ATOM   1711  OG1 THR A 217       6.493  38.509  10.462  1.00 12.64           O  
ATOM   1712  CG2 THR A 217       7.619  36.921  11.906  1.00 13.01           C  
ATOM   1713  N   LYS A 218       3.333  37.655  10.646  1.00 13.71           N  
ATOM   1714  CA  LYS A 218       2.253  38.248   9.883  1.00 15.09           C  
ATOM   1715  C   LYS A 218       2.729  39.284   8.870  1.00 15.31           C  
ATOM   1716  O   LYS A 218       2.135  39.414   7.786  1.00 15.98           O  
ATOM   1717  CB  LYS A 218       1.207  38.800  10.841  1.00 15.64           C  
ATOM   1718  CG  LYS A 218       0.487  37.711  11.617  1.00 20.19           C  
ATOM   1719  CD  LYS A 218      -0.323  36.831  10.663  1.00 23.94           C  
ATOM   1720  CE  LYS A 218      -0.988  35.662  11.375  1.00 25.05           C  
ATOM   1721  NZ  LYS A 218      -1.978  35.097  10.442  1.00 26.07           N  
ATOM   1722  N   LYS A 219       3.813  39.995   9.182  1.00 14.49           N  
ATOM   1723  CA  LYS A 219       4.359  40.999   8.256  1.00 13.87           C  
ATOM   1724  C   LYS A 219       5.420  40.449   7.290  1.00 14.86           C  
ATOM   1725  O   LYS A 219       5.961  41.203   6.474  1.00 16.43           O  
ATOM   1726  CB  LYS A 219       4.935  42.187   9.035  1.00 13.04           C  
ATOM   1727  CG  LYS A 219       3.890  42.920   9.823  1.00 12.98           C  
ATOM   1728  CD  LYS A 219       4.392  44.294  10.280  1.00 11.47           C  
ATOM   1729  CE  LYS A 219       5.571  44.169  11.224  1.00 12.17           C  
ATOM   1730  NZ  LYS A 219       5.376  43.266  12.390  1.00  9.44           N  
ATOM   1731  N   GLY A 220       5.715  39.148   7.359  1.00 14.16           N  
ATOM   1732  CA  GLY A 220       6.614  38.536   6.364  1.00 14.70           C  
ATOM   1733  C   GLY A 220       7.603  37.615   7.045  1.00 14.31           C  
ATOM   1734  O   GLY A 220       7.499  37.348   8.234  1.00 15.93           O  
ATOM   1735  N   VAL A 221       8.591  37.174   6.300  1.00 14.25           N  
ATOM   1736  CA  VAL A 221       9.565  36.229   6.833  1.00 15.06           C  
ATOM   1737  C   VAL A 221      10.832  36.970   7.255  1.00 14.62           C  
ATOM   1738  O   VAL A 221      11.454  37.715   6.460  1.00 15.14           O  
ATOM   1739  CB  VAL A 221       9.901  35.157   5.780  1.00 14.79           C  
ATOM   1740  CG1 VAL A 221      11.016  34.226   6.296  1.00 15.81           C  
ATOM   1741  CG2 VAL A 221       8.609  34.379   5.377  1.00 16.58           C  
ATOM   1742  N   LYS A 222      11.202  36.802   8.509  1.00 14.84           N  
ATOM   1743  CA  LYS A 222      12.446  37.340   8.986  1.00 15.91           C  
ATOM   1744  C   LYS A 222      13.466  36.223   9.125  1.00 15.92           C  
ATOM   1745  O   LYS A 222      13.119  35.055   9.411  1.00 15.36           O  
ATOM   1746  CB  LYS A 222      12.288  38.102  10.288  1.00 16.62           C  
ATOM   1747  CG  LYS A 222      11.688  37.345  11.417  1.00 18.00           C  
ATOM   1748  CD  LYS A 222      11.671  38.216  12.681  1.00 18.61           C  
ATOM   1749  CE  LYS A 222      11.110  37.505  13.902  1.00 20.59           C  
ATOM   1750  NZ  LYS A 222      10.803  38.465  15.015  1.00 22.36           N  
ATOM   1751  N   THR A 223      14.712  36.628   8.918  1.00 15.78           N  
ATOM   1752  CA  THR A 223      15.870  35.755   8.994  1.00 16.17           C  
ATOM   1753  C   THR A 223      16.679  36.108  10.226  1.00 16.28           C  
ATOM   1754  O   THR A 223      17.160  37.254  10.352  1.00 16.30           O  
ATOM   1755  CB  THR A 223      16.777  35.888   7.719  1.00 16.16           C  
ATOM   1756  OG1 THR A 223      16.062  35.466   6.549  1.00 16.48           O  
ATOM   1757  CG2 THR A 223      18.072  35.052   7.896  1.00 16.24           C  
ATOM   1758  N   LEU A 224      16.842  35.144  11.137  1.00 16.60           N  
ATOM   1759  CA  LEU A 224      17.668  35.304  12.316  1.00 17.37           C  
ATOM   1760  C   LEU A 224      19.000  34.583  12.157  1.00 18.70           C  
ATOM   1761  O   LEU A 224      19.024  33.418  11.756  1.00 15.93           O  
ATOM   1762  CB  LEU A 224      16.985  34.745  13.564  1.00 16.52           C  
ATOM   1763  CG  LEU A 224      15.562  35.204  13.822  1.00 16.29           C  
ATOM   1764  CD1 LEU A 224      14.987  34.606  15.086  1.00 17.32           C  
ATOM   1765  CD2 LEU A 224      15.580  36.738  13.830  1.00 15.60           C  
ATOM   1766  N   LYS A 225      20.100  35.266  12.469  1.00 20.04           N  
ATOM   1767  CA  LYS A 225      21.401  34.585  12.488  1.00 24.25           C  
ATOM   1768  C   LYS A 225      22.413  35.190  13.446  1.00 26.58           C  
ATOM   1769  O   LYS A 225      22.325  36.373  13.799  1.00 27.95           O  
ATOM   1770  CB  LYS A 225      21.991  34.436  11.090  1.00 24.90           C  
ATOM   1771  CG  LYS A 225      22.036  35.658  10.245  1.00 26.58           C  
ATOM   1772  CD  LYS A 225      22.125  35.288   8.767  1.00 26.64           C  
ATOM   1773  CE  LYS A 225      22.373  36.537   7.933  1.00 29.15           C  
ATOM   1774  NZ  LYS A 225      22.846  36.281   6.540  1.00 29.58           N  
ATOM   1775  N   LYS A 226      23.310  34.318  13.903  1.00 29.25           N  
ATOM   1776  CA  LYS A 226      24.438  34.622  14.770  1.00 30.11           C  
ATOM   1777  C   LYS A 226      24.062  35.035  16.177  1.00 31.97           C  
ATOM   1778  O   LYS A 226      23.788  34.159  17.007  1.00 34.06           O  
ATOM   1779  CB  LYS A 226      25.372  35.643  14.128  1.00 31.79           C  
ATOM   1780  CG  LYS A 226      26.744  35.697  14.781  1.00 33.19           C  
ATOM   1781  CD  LYS A 226      27.265  34.290  15.186  1.00 37.91           C  
ATOM   1782  CE  LYS A 226      27.301  33.303  14.002  1.00 39.40           C  
ATOM   1783  NZ  LYS A 226      27.465  31.844  14.398  1.00 39.16           N  
TER    1784      LYS A 226                                                      
END
MOLECULE T0438_2_186.pdb
ATOM      1  N   GLN     2      22.301  40.864  20.451  1.00 45.66          
ATOM      2  CA  GLN     2      20.920  40.443  20.090  1.00 45.49          
ATOM      3  C   GLN     2      21.031  39.501  18.881  1.00 45.02          
ATOM      4  O   GLN     2      21.727  39.738  17.859  1.00 44.52          
ATOM      5  CB  GLN     2      20.001  41.664  19.812  1.00 45.68          
ATOM      6  CG  GLN     2      20.247  42.944  20.771  1.00 48.87          
ATOM      7  CD  GLN     2      21.138  44.133  20.172  1.00 50.18          
ATOM      8  OE1 GLN     2      21.022  44.439  18.977  1.00 51.19          
ATOM      9  NE2 GLN     2      21.973  44.802  21.024  1.00 46.81          
ATOM     10  N   TRP     3      20.369  38.376  19.023  1.00 44.69          
ATOM     11  CA  TRP     3      20.378  37.380  17.946  1.00 44.23          
ATOM     12  C   TRP     3      19.071  37.457  17.150  1.00 44.35          
ATOM     13  O   TRP     3      19.030  37.083  15.975  1.00 44.41          
ATOM     14  CB  TRP     3      20.611  35.966  18.508  1.00 42.96          
ATOM     15  CG  TRP     3      19.780  35.702  19.684  1.00 40.96          
ATOM     16  CD1 TRP     3      20.138  35.839  20.974  1.00 39.33          
ATOM     17  CD2 TRP     3      18.406  35.292  19.676  1.00 43.16          
ATOM     18  NE1 TRP     3      19.085  35.522  21.796  1.00 39.72          
ATOM     19  CE2 TRP     3      18.004  35.166  21.034  1.00 40.34          
ATOM     20  CE3 TRP     3      17.461  34.979  18.646  1.00 44.38          
ATOM     21  CZ2 TRP     3      16.695  34.773  21.418  1.00 38.75          
ATOM     22  CZ3 TRP     3      16.145  34.560  19.037  1.00 42.51          
ATOM     23  CH2 TRP     3      15.785  34.475  20.423  1.00 39.71          
ATOM     24  N   GLN     4      18.007  37.933  17.818  1.00 43.59          
ATOM     25  CA  GLN     4      16.729  38.267  17.159  1.00 42.20          
ATOM     26  C   GLN     4      16.911  39.288  16.033  1.00 40.57          
ATOM     27  O   GLN     4      16.105  39.369  15.127  1.00 40.61          
ATOM     28  CB  GLN     4      15.650  38.703  18.176  1.00 41.88          
ATOM     29  CG  GLN     4      16.136  39.685  19.247  1.00 42.96          
ATOM     30  CD  GLN     4      16.105  39.113  20.670  1.00 41.76          
ATOM     31  OE1 GLN     4      16.802  38.164  20.968  1.00 40.40          
ATOM     32  NE2 GLN     4      15.315  39.734  21.554  1.00 42.64          
ATOM     33  N   GLU     5      17.981  40.051  16.056  1.00 39.51          
ATOM     34  CA  GLU     5      18.176  40.924  14.951  1.00 39.47          
ATOM     35  C   GLU     5      18.675  40.092  13.761  1.00 37.95          
ATOM     36  O   GLU     5      18.368  40.367  12.611  1.00 36.65          
ATOM     37  CB  GLU     5      19.087  42.065  15.341  1.00 40.78          
ATOM     38  CG  GLU     5      19.214  43.177  14.290  1.00 48.67          
ATOM     39  CD  GLU     5      17.900  43.902  13.832  1.00 58.49          
ATOM     40  OE1 GLU     5      16.712  43.385  13.955  1.00 62.56          
ATOM     41  OE2 GLU     5      18.077  45.040  13.290  1.00 61.65          
ATOM     42  N   LEU     6      19.385  39.008  14.055  1.00 37.32          
ATOM     43  CA  LEU     6      19.644  37.958  13.054  1.00 35.46          
ATOM     44  C   LEU     6      18.402  37.140  12.689  1.00 34.95          
ATOM     45  O   LEU     6      18.210  36.788  11.527  1.00 34.26          
ATOM     46  CB  LEU     6      20.673  36.969  13.565  1.00 34.98          
ATOM     47  CG  LEU     6      21.750  36.771  12.565  1.00 31.82          
ATOM     48  CD1 LEU     6      22.286  38.168  12.572  1.00 27.40          
ATOM     49  CD2 LEU     6      22.674  35.746  13.153  1.00 30.24          
ATOM     50  N   TYR     7      17.585  36.824  13.686  1.00 34.57          
ATOM     51  CA  TYR     7      16.383  36.095  13.435  1.00 35.06          
ATOM     52  C   TYR     7      15.707  36.885  12.365  1.00 35.55          
ATOM     53  O   TYR     7      15.350  36.315  11.331  1.00 37.74          
ATOM     54  CB  TYR     7      15.505  36.072  14.657  1.00 36.13          
ATOM     55  CG  TYR     7      14.278  35.179  14.558  1.00 37.33          
ATOM     56  CD1 TYR     7      14.341  33.886  15.033  1.00 38.27          
ATOM     57  CD2 TYR     7      13.063  35.630  14.030  1.00 35.78          
ATOM     58  CE1 TYR     7      13.280  33.080  14.995  1.00 37.74          
ATOM     59  CE2 TYR     7      11.974  34.823  13.995  1.00 35.57          
ATOM     60  CZ  TYR     7      12.095  33.528  14.486  1.00 38.65          
ATOM     61  OH  TYR     7      11.067  32.566  14.469  1.00 42.57          
ATOM     62  N   ARG     8      15.578  38.199  12.570  1.00 34.26          
ATOM     63  CA  ARG     8      14.849  39.002  11.639  1.00 33.10          
ATOM     64  C   ARG     8      15.563  38.954  10.305  1.00 31.22          
ATOM     65  O   ARG     8      14.916  38.742   9.332  1.00 30.95          
ATOM     66  CB  ARG     8      14.490  40.421  12.194  1.00 34.39          
ATOM     67  CG  ARG     8      13.122  40.469  12.931  1.00 38.53          
ATOM     68  CD  ARG     8      11.938  39.837  12.015  1.00 46.29          
ATOM     69  NE  ARG     8      10.943  38.935  12.696  1.00 46.06          
ATOM     70  CZ  ARG     8       9.769  38.435  12.158  1.00 42.31          
ATOM     71  NH1 ARG     8       9.426  38.718  10.884  1.00 38.18          
ATOM     72  NH2 ARG     8       8.952  37.646  12.915  1.00 37.18          
ATOM     73  N   GLN     9      16.876  39.075  10.243  1.00 29.86          
ATOM     74  CA  GLN     9      17.528  39.242   8.935  1.00 29.54          
ATOM     75  C   GLN     9      17.539  37.961   8.008  1.00 29.51          
ATOM     76  O   GLN     9      17.934  38.043   6.805  1.00 29.97          
ATOM     77  CB  GLN     9      18.940  39.867   9.110  1.00 29.11          
ATOM     78  CG  GLN     9      19.927  39.779   7.874  1.00 31.47          
ATOM     79  CD  GLN     9      21.436  39.404   8.260  1.00 34.75          
ATOM     80  OE1 GLN     9      22.120  40.202   8.961  1.00 41.31          
ATOM     81  NE2 GLN     9      21.936  38.195   7.809  1.00 34.17          
ATOM     82  N   ARG    10      17.103  36.791   8.536  1.00 27.99          
ATOM     83  CA  ARG    10      17.257  35.479   7.837  1.00 25.47          
ATOM     84  C   ARG    10      15.915  34.801   7.610  1.00 23.91          
ATOM     85  O   ARG    10      15.835  33.715   7.021  1.00 21.35          
ATOM     86  CB  ARG    10      18.087  34.539   8.711  1.00 25.21          
ATOM     87  CG  ARG    10      19.643  34.464   8.447  1.00 24.12          
ATOM     88  CD  ARG    10      20.453  34.545   9.747  1.00 20.79          
ATOM     89  NE  ARG    10      21.708  33.838   9.752  1.00 20.44          
ATOM     90  CZ  ARG    10      22.836  34.319   9.288  1.00 26.06          
ATOM     91  NH1 ARG    10      22.938  35.531   8.710  1.00 31.79          
ATOM     92  NH2 ARG    10      23.893  33.561   9.367  1.00 26.81          
ATOM     93  N   VAL    11      14.856  35.411   8.147  1.00 23.51          
ATOM     94  CA  VAL    11      13.468  34.939   7.856  1.00 24.18          
ATOM     95  C   VAL    11      12.950  35.245   6.394  1.00 24.54          
ATOM     96  O   VAL    11      13.170  36.348   5.886  1.00 25.11          
ATOM     97  CB  VAL    11      12.442  35.295   8.996  1.00 23.08          
ATOM     98  CG1 VAL    11      12.697  36.579   9.455  1.00 22.94          
ATOM     99  CG2 VAL    11      11.053  35.250   8.541  1.00 21.30          
ATOM    100  N   CYS    12      12.364  34.229   5.725  1.00 23.75          
ATOM    101  CA  CYS    12      11.746  34.327   4.406  1.00 23.05          
ATOM    102  C   CYS    12      10.544  33.390   4.344  1.00 22.52          
ATOM    103  O   CYS    12      10.106  32.858   5.350  1.00 22.55          
ATOM    104  CB  CYS    12      12.742  34.040   3.276  1.00 22.22          
ATOM    105  SG  CYS    12      13.790  32.594   3.587  1.00 26.12          
ATOM    106  N   SER    13       9.984  33.237   3.157  1.00 22.63          
ATOM    107  CA  SER    13       8.885  32.332   2.923  1.00 21.87          
ATOM    108  C   SER    13       9.543  31.066   2.564  1.00 20.56          
ATOM    109  O   SER    13      10.679  31.034   2.134  1.00 19.95          
ATOM    110  CB  SER    13       8.045  32.773   1.689  1.00 22.74          
ATOM    111  OG  SER    13       8.782  32.631   0.471  1.00 22.51          
ATOM    112  N   ALA    14       8.778  30.012   2.647  1.00 19.68          
ATOM    113  CA  ALA    14       9.261  28.772   2.182  1.00 18.20          
ATOM    114  C   ALA    14       9.767  28.969   0.743  1.00 17.81          
ATOM    115  O   ALA    14      10.901  28.543   0.407  1.00 17.26          
ATOM    116  CB  ALA    14       8.174  27.770   2.255  1.00 17.48          
ATOM    117  N   ASP    15       8.965  29.650  -0.075  1.00 17.40          
ATOM    118  CA  ASP    15       9.211  29.686  -1.539  1.00 17.58          
ATOM    119  C   ASP    15      10.487  30.433  -1.836  1.00 17.51          
ATOM    120  O   ASP    15      11.311  30.009  -2.674  1.00 17.85          
ATOM    121  CB  ASP    15       8.085  30.371  -2.306  1.00 17.43          
ATOM    122  CG  ASP    15       6.708  29.566  -2.297  1.00 22.38          
ATOM    123  OD1 ASP    15       6.459  28.807  -3.287  1.00 24.07          
ATOM    124  OD2 ASP    15       5.803  29.661  -1.385  1.00 24.81          
ATOM    125  N   GLU    16      10.707  31.526  -1.100  1.00 17.22          
ATOM    126  CA  GLU    16      11.910  32.289  -1.307  1.00 15.21          
ATOM    127  C   GLU    16      13.102  31.449  -0.897  1.00 13.71          
ATOM    128  O   GLU    16      14.168  31.458  -1.579  1.00 12.05          
ATOM    129  CB  GLU    16      11.879  33.572  -0.545  1.00 16.27          
ATOM    130  CG  GLU    16      10.687  34.467  -0.728  1.00 18.47          
ATOM    131  CD  GLU    16      10.627  35.488   0.412  1.00 26.97          
ATOM    132  OE1 GLU    16      10.572  35.074   1.619  1.00 27.31          
ATOM    133  OE2 GLU    16      10.677  36.723   0.119  1.00 25.64          
ATOM    134  N   ALA    17      12.934  30.701   0.189  1.00 12.99          
ATOM    135  CA  ALA    17      14.004  29.727   0.575  1.00 13.65          
ATOM    136  C   ALA    17      14.275  28.533  -0.412  1.00 13.45          
ATOM    137  O   ALA    17      15.406  28.291  -0.777  1.00 12.07          
ATOM    138  CB  ALA    17      13.840  29.269   1.950  1.00 12.61          
ATOM    139  N   VAL    18      13.248  27.833  -0.865  1.00 14.16          
ATOM    140  CA  VAL    18      13.421  26.938  -2.017  1.00 16.22          
ATOM    141  C   VAL    18      14.161  27.625  -3.160  1.00 16.91          
ATOM    142  O   VAL    18      15.203  27.158  -3.659  1.00 16.37          
ATOM    143  CB  VAL    18      12.060  26.490  -2.624  1.00 15.97          
ATOM    144  CG1 VAL    18      12.246  25.850  -3.927  1.00 15.99          
ATOM    145  CG2 VAL    18      11.378  25.552  -1.751  1.00 17.31          
ATOM    146  N   VAL    19      13.630  28.729  -3.615  1.00 18.11          
ATOM    147  CA  VAL    19      14.321  29.245  -4.759  1.00 21.42          
ATOM    148  C   VAL    19      15.773  29.606  -4.525  1.00 23.57          
ATOM    149  O   VAL    19      16.554  29.291  -5.385  1.00 24.74          
ATOM    150  CB  VAL    19      13.635  30.342  -5.447  1.00 21.17          
ATOM    151  CG1 VAL    19      14.518  30.812  -6.572  1.00 20.43          
ATOM    152  CG2 VAL    19      12.330  29.809  -5.973  1.00 20.70          
ATOM    153  N   ASP    20      16.134  30.245  -3.402  1.00 25.89          
ATOM    154  CA  ASP    20      17.526  30.727  -3.203  1.00 28.38          
ATOM    155  C   ASP    20      18.424  29.612  -2.765  1.00 28.06          
ATOM    156  O   ASP    20      19.595  29.604  -3.031  1.00 28.27          
ATOM    157  CB  ASP    20      17.637  31.923  -2.223  1.00 29.34          
ATOM    158  CG  ASP    20      16.938  33.232  -2.806  1.00 39.37          
ATOM    159  OD1 ASP    20      17.516  33.774  -3.826  1.00 46.87          
ATOM    160  OD2 ASP    20      15.794  33.745  -2.406  1.00 40.49          
ATOM    161  N   SER    21      17.878  28.628  -2.101  1.00 27.91          
ATOM    162  CA  SER    21      18.755  27.626  -1.596  1.00 26.75          
ATOM    163  C   SER    21      18.865  26.472  -2.577  1.00 26.31          
ATOM    164  O   SER    21      19.719  25.654  -2.375  1.00 27.08          
ATOM    165  CB  SER    21      18.218  27.089  -0.292  1.00 27.05          
ATOM    166  OG  SER    21      17.116  26.217  -0.582  1.00 25.99          
ATOM    167  N   LEU    22      18.044  26.376  -3.621  1.00 24.68          
ATOM    168  CA  LEU    22      18.091  25.146  -4.364  1.00 23.84          
ATOM    169  C   LEU    22      18.634  25.283  -5.715  1.00 24.93          
ATOM    170  O   LEU    22      17.903  25.130  -6.731  1.00 26.26          
ATOM    171  CB  LEU    22      16.730  24.506  -4.461  1.00 23.97          
ATOM    172  CG  LEU    22      16.233  23.925  -3.138  1.00 22.50          
ATOM    173  CD1 LEU    22      15.176  22.905  -3.324  1.00 18.72          
ATOM    174  CD2 LEU    22      17.411  23.302  -2.398  1.00 22.66          
ATOM    175  N   LYS    23      19.929  25.542  -5.766  1.00 25.02          
ATOM    176  CA  LYS    23      20.602  25.712  -7.053  1.00 24.74          
ATOM    177  C   LYS    23      20.478  24.399  -7.888  1.00 24.03          
ATOM    178  O   LYS    23      20.452  23.302  -7.324  1.00 21.81          
ATOM    179  CB  LYS    23      22.076  26.201  -6.833  1.00 26.07          
ATOM    180  CG  LYS    23      22.142  27.600  -6.255  1.00 26.45          
ATOM    181  CD  LYS    23      20.911  28.383  -6.874  1.00 35.77          
ATOM    182  CE  LYS    23      20.688  29.922  -6.412  1.00 38.56          
ATOM    183  NZ  LYS    23      22.012  30.720  -6.220  1.00 42.87          
ATOM    184  N   PRO    24      20.377  24.511  -9.222  1.00 24.19          
ATOM    185  CA  PRO    24      20.483  23.338 -10.101  1.00 23.91          
ATOM    186  C   PRO    24      21.574  22.320  -9.658  1.00 24.25          
ATOM    187  O   PRO    24      22.636  22.659  -9.149  1.00 22.93          
ATOM    188  CB  PRO    24      20.836  23.955 -11.450  1.00 22.57          
ATOM    189  CG  PRO    24      20.402  25.315 -11.423  1.00 22.41          
ATOM    190  CD  PRO    24      20.124  25.737 -10.011  1.00 24.33          
ATOM    191  N   GLY    25      21.275  21.047  -9.843  1.00 24.91          
ATOM    192  CA  GLY    25      22.148  20.025  -9.339  1.00 22.99          
ATOM    193  C   GLY    25      22.373  19.939  -7.830  1.00 21.94          
ATOM    194  O   GLY    25      23.206  19.174  -7.452  1.00 22.50          
ATOM    195  N   THR    26      21.700  20.674  -6.943  1.00 20.84          
ATOM    196  CA  THR    26      21.987  20.496  -5.476  1.00 20.59          
ATOM    197  C   THR    26      21.419  19.186  -4.937  1.00 19.89          
ATOM    198  O   THR    26      20.437  18.732  -5.457  1.00 21.69          
ATOM    199  CB  THR    26      21.463  21.673  -4.642  1.00 19.97          
ATOM    200  OG1 THR    26      20.344  22.178  -5.331  1.00 22.62          
ATOM    201  CG2 THR    26      22.423  22.922  -4.718  1.00 23.49          
ATOM    202  N   LYS    27      22.040  18.572  -3.930  1.00 18.30          
ATOM    203  CA  LYS    27      21.432  17.516  -3.152  1.00 16.74          
ATOM    204  C   LYS    27      20.976  17.989  -1.786  1.00 16.46          
ATOM    205  O   LYS    27      21.687  18.729  -1.131  1.00 16.95          
ATOM    206  CB  LYS    27      22.493  16.509  -2.873  1.00 17.33          
ATOM    207  CG  LYS    27      23.179  16.134  -4.116  1.00 17.67          
ATOM    208  CD  LYS    27      24.649  15.882  -3.889  1.00 18.17          
ATOM    209  CE  LYS    27      25.100  14.632  -4.679  1.00 20.52          
ATOM    210  NZ  LYS    27      24.686  14.634  -6.118  1.00 22.18          
ATOM    211  N   VAL    28      19.841  17.508  -1.290  1.00 15.30          
ATOM    212  CA  VAL    28      19.279  18.066  -0.095  1.00 13.17          
ATOM    213  C   VAL    28      18.931  16.923   0.743  1.00 13.67          
ATOM    214  O   VAL    28      18.713  15.848   0.183  1.00 14.25          
ATOM    215  CB  VAL    28      18.033  18.943  -0.454  1.00 13.52          
ATOM    216  CG1 VAL    28      17.997  19.224  -1.929  1.00  9.64          
ATOM    217  CG2 VAL    28      16.757  18.404  -0.006  1.00 12.80          
ATOM    218  N   VAL    29      18.846  17.111   2.062  1.00 13.68          
ATOM    219  CA  VAL    29      18.433  16.035   2.988  1.00 13.42          
ATOM    220  C   VAL    29      17.292  16.589   3.831  1.00 14.82          
ATOM    221  O   VAL    29      17.375  17.720   4.317  1.00 14.92          
ATOM    222  CB  VAL    29      19.678  15.573   3.949  1.00 14.04          
ATOM    223  CG1 VAL    29      19.218  14.745   5.141  1.00 13.89          
ATOM    224  CG2 VAL    29      20.792  14.776   3.215  1.00  9.61          
ATOM    225  N   PHE    30      16.211  15.841   4.048  1.00 16.24          
ATOM    226  CA  PHE    30      15.112  16.383   4.929  1.00 15.93          
ATOM    227  C   PHE    30      15.142  15.725   6.246  1.00 17.61          
ATOM    228  O   PHE    30      15.413  14.539   6.318  1.00 18.72          
ATOM    229  CB  PHE    30      13.751  16.049   4.393  1.00 15.13          
ATOM    230  CG  PHE    30      13.355  16.807   3.122  1.00 16.71          
ATOM    231  CD1 PHE    30      12.130  16.473   2.454  1.00 13.37          
ATOM    232  CD2 PHE    30      14.143  17.855   2.618  1.00 14.25          
ATOM    233  CE1 PHE    30      11.714  17.102   1.339  1.00  7.85          
ATOM    234  CE2 PHE    30      13.709  18.537   1.509  1.00 14.62          
ATOM    235  CZ  PHE    30      12.489  18.150   0.845  1.00 15.33          
ATOM    236  N   GLY    31      14.862  16.447   7.324  1.00 20.63          
ATOM    237  CA  GLY    31      14.907  15.849   8.729  1.00 23.62          
ATOM    238  C   GLY    31      13.764  14.870   8.742  1.00 25.45          
ATOM    239  O   GLY    31      12.886  14.924   7.814  1.00 25.70          
ATOM    240  N   HSD    32      13.717  13.921   9.681  1.00 27.22          
ATOM    241  CA  HSD    32      12.664  12.907   9.339  1.00 27.58          
ATOM    242  C   HSD    32      11.594  12.665  10.317  1.00 24.69          
ATOM    243  O   HSD    32      11.641  13.260  11.315  1.00 23.64          
ATOM    244  CB  HSD    32      13.203  11.593   8.699  1.00 29.84          
ATOM    245  CG  HSD    32      13.512  10.536   9.708  1.00 30.57          
ATOM    246  ND1 HSD    32      14.035  10.857  10.955  1.00 33.64          
ATOM    247  CD2 HSD    32      13.316   9.191   9.688  1.00 23.42          
ATOM    248  CE1 HSD    32      14.171   9.722  11.644  1.00 34.23          
ATOM    249  NE2 HSD    32      13.731   8.711  10.906  1.00 24.90          
ATOM    250  N   ALA    33      10.600  11.851   9.922  1.00 23.60          
ATOM    251  CA  ALA    33       9.577  11.246  10.798  1.00 22.77          
ATOM    252  C   ALA    33       8.559  12.357  10.980  1.00 22.68          
ATOM    253  O   ALA    33       7.988  12.811   9.974  1.00 24.97          
ATOM    254  CB  ALA    33      10.154  10.728  12.138  1.00 22.02          
ATOM    255  N   ALA    34       8.327  12.826  12.213  1.00 21.17          
ATOM    256  CA  ALA    34       7.248  13.789  12.461  1.00 18.34          
ATOM    257  C   ALA    34       7.829  15.166  12.415  1.00 17.88          
ATOM    258  O   ALA    34       7.059  16.105  12.626  1.00 19.36          
ATOM    259  CB  ALA    34       6.557  13.552  13.782  1.00 17.06          
ATOM    260  N   ALA    35       9.123  15.287  12.054  1.00 15.79          
ATOM    261  CA  ALA    35       9.798  16.548  11.976  1.00 15.94          
ATOM    262  C   ALA    35      10.119  16.850  10.567  1.00 17.19          
ATOM    263  O   ALA    35      10.953  17.725  10.322  1.00 18.60          
ATOM    264  CB  ALA    35      11.079  16.542  12.757  1.00 15.24          
ATOM    265  N   ALA    36       9.494  16.108   9.656  1.00 18.19          
ATOM    266  CA  ALA    36       9.643  16.199   8.200  1.00 18.59          
ATOM    267  C   ALA    36       9.093  17.570   7.723  1.00 19.68          
ATOM    268  O   ALA    36       8.035  17.993   8.199  1.00 20.43          
ATOM    269  CB  ALA    36       8.852  15.070   7.575  1.00 18.13          
ATOM    270  N   PRO    37       9.807  18.291   6.856  1.00 19.40          
ATOM    271  CA  PRO    37       9.494  19.653   6.592  1.00 19.11          
ATOM    272  C   PRO    37       8.652  19.746   5.328  1.00 19.82          
ATOM    273  O   PRO    37       9.069  20.090   4.211  1.00 19.21          
ATOM    274  CB  PRO    37      10.877  20.291   6.449  1.00 19.33          
ATOM    275  CG  PRO    37      11.789  19.190   6.242  1.00 19.25          
ATOM    276  CD  PRO    37      11.030  17.897   6.136  1.00 19.94          
ATOM    277  N   VAL    38       7.402  19.462   5.573  1.00 21.02          
ATOM    278  CA  VAL    38       6.420  19.357   4.562  1.00 21.32          
ATOM    279  C   VAL    38       6.151  20.724   3.945  1.00 21.37          
ATOM    280  O   VAL    38       5.880  20.781   2.742  1.00 22.79          
ATOM    281  CB  VAL    38       5.198  18.633   5.149  1.00 20.45          
ATOM    282  CG1 VAL    38       5.005  19.063   6.573  1.00 21.69          
ATOM    283  CG2 VAL    38       3.953  18.894   4.314  1.00 23.80          
ATOM    284  N   ARG    39       6.251  21.828   4.695  1.00 21.58          
ATOM    285  CA  ARG    39       6.057  23.200   4.058  1.00 21.31          
ATOM    286  C   ARG    39       6.993  23.492   2.937  1.00 20.54          
ATOM    287  O   ARG    39       6.626  24.009   1.881  1.00 20.63          
ATOM    288  CB  ARG    39       6.234  24.299   5.063  1.00 20.92          
ATOM    289  CG  ARG    39       4.886  24.753   5.544  1.00 23.30          
ATOM    290  CD  ARG    39       4.194  23.790   6.423  1.00 22.38          
ATOM    291  NE  ARG    39       5.084  23.064   7.343  1.00 21.17          
ATOM    292  CZ  ARG    39       4.580  22.148   8.167  1.00 22.55          
ATOM    293  NH1 ARG    39       5.357  21.445   8.985  1.00 21.29          
ATOM    294  NH2 ARG    39       3.258  21.917   8.140  1.00 18.42          
ATOM    295  N   PHE    40       8.233  23.154   3.218  1.00 20.34          
ATOM    296  CA  PHE    40       9.247  23.150   2.258  1.00 19.91          
ATOM    297  C   PHE    40       8.970  22.162   1.149  1.00 21.28          
ATOM    298  O   PHE    40       9.204  22.510  -0.020  1.00 24.41          
ATOM    299  CB  PHE    40      10.528  22.765   2.901  1.00 18.96          
ATOM    300  CG  PHE    40      11.745  23.205   2.122  1.00 17.88          
ATOM    301  CD1 PHE    40      12.305  22.402   1.152  1.00 16.72          
ATOM    302  CD2 PHE    40      12.311  24.425   2.343  1.00 15.73          
ATOM    303  CE1 PHE    40      13.440  22.782   0.458  1.00 13.55          
ATOM    304  CE2 PHE    40      13.397  24.793   1.635  1.00 18.00          
ATOM    305  CZ  PHE    40      13.987  23.926   0.683  1.00 14.48          
ATOM    306  N   SER    41       8.474  20.950   1.419  1.00 21.03          
ATOM    307  CA  SER    41       8.101  20.048   0.285  1.00 20.01          
ATOM    308  C   SER    41       7.008  20.685  -0.618  1.00 20.61          
ATOM    309  O   SER    41       7.081  20.734  -1.879  1.00 18.08          
ATOM    310  CB  SER    41       7.692  18.671   0.799  1.00 19.44          
ATOM    311  OG  SER    41       7.220  17.809  -0.243  1.00 19.22          
ATOM    312  N   GLN    42       6.026  21.262   0.089  1.00 23.29          
ATOM    313  CA  GLN    42       4.854  22.015  -0.501  1.00 23.53          
ATOM    314  C   GLN    42       5.526  23.094  -1.367  1.00 21.04          
ATOM    315  O   GLN    42       5.265  23.134  -2.564  1.00 21.64          
ATOM    316  CB  GLN    42       3.896  22.569   0.635  1.00 24.61          
ATOM    317  CG  GLN    42       2.364  22.442   0.482  1.00 30.98          
ATOM    318  CD  GLN    42       1.797  21.221   1.339  1.00 42.73          
ATOM    319  OE1 GLN    42       1.886  21.261   2.617  1.00 44.13          
ATOM    320  NE2 GLN    42       1.217  20.140   0.639  1.00 39.64          
ATOM    321  N   ALA    43       6.451  23.901  -0.817  1.00 18.30          
ATOM    322  CA  ALA    43       7.058  24.957  -1.689  1.00 17.00          
ATOM    323  C   ALA    43       7.867  24.463  -2.881  1.00 15.00          
ATOM    324  O   ALA    43       7.953  25.133  -3.863  1.00 11.84          
ATOM    325  CB  ALA    43       7.842  26.061  -0.891  1.00 17.47          
ATOM    326  N   MET    44       8.465  23.290  -2.765  1.00 14.50          
ATOM    327  CA  MET    44       9.171  22.718  -3.905  1.00 15.39          
ATOM    328  C   MET    44       8.180  22.315  -4.982  1.00 12.22          
ATOM    329  O   MET    44       8.453  22.459  -6.155  1.00 10.78          
ATOM    330  CB  MET    44      10.004  21.489  -3.456  1.00 16.06          
ATOM    331  CG  MET    44      11.325  21.827  -2.668  1.00 18.15          
ATOM    332  SD  MET    44      12.072  20.295  -2.106  1.00 20.97          
ATOM    333  CE  MET    44      13.066  19.768  -3.438  1.00 18.66          
ATOM    334  N   TYR    45       7.032  21.785  -4.580  1.00 10.67          
ATOM    335  CA  TYR    45       5.946  21.600  -5.542  1.00 10.06          
ATOM    336  C   TYR    45       5.572  22.889  -6.326  1.00  9.87          
ATOM    337  O   TYR    45       5.709  22.956  -7.562  1.00  8.45          
ATOM    338  CB  TYR    45       4.676  21.096  -4.889  1.00  9.54          
ATOM    339  CG  TYR    45       3.695  20.666  -5.899  1.00 10.38          
ATOM    340  CD1 TYR    45       3.758  19.374  -6.440  1.00 12.83          
ATOM    341  CD2 TYR    45       2.722  21.530  -6.378  1.00 13.04          
ATOM    342  CE1 TYR    45       2.851  18.920  -7.393  1.00  9.77          
ATOM    343  CE2 TYR    45       1.831  21.105  -7.362  1.00 12.73          
ATOM    344  CZ  TYR    45       1.896  19.781  -7.881  1.00 10.42          
ATOM    345  OH  TYR    45       1.007  19.310  -8.869  1.00  9.11          
ATOM    346  N   ARG    46       5.079  23.900  -5.622  1.00  9.05          
ATOM    347  CA  ARG    46       4.776  25.139  -6.317  1.00  9.66          
ATOM    348  C   ARG    46       5.910  25.661  -7.187  1.00 10.23          
ATOM    349  O   ARG    46       5.632  26.166  -8.245  1.00 12.26          
ATOM    350  CB  ARG    46       4.439  26.213  -5.329  1.00  9.96          
ATOM    351  CG  ARG    46       3.314  25.881  -4.450  1.00 13.07          
ATOM    352  CD  ARG    46       2.823  27.089  -3.757  1.00 15.66          
ATOM    353  NE  ARG    46       3.804  27.393  -2.785  1.00 13.78          
ATOM    354  CZ  ARG    46       3.789  26.881  -1.575  1.00 16.09          
ATOM    355  NH1 ARG    46       2.775  26.038  -1.199  1.00 13.23          
ATOM    356  NH2 ARG    46       4.827  27.215  -0.748  1.00 17.30          
ATOM    357  N   GLN    47       7.170  25.585  -6.745  1.00 10.28          
ATOM    358  CA  GLN    47       8.277  26.169  -7.466  1.00 10.77          
ATOM    359  C   GLN    47       8.893  25.199  -8.428  1.00 12.81          
ATOM    360  O   GLN    47       9.983  25.484  -8.888  1.00 13.62          
ATOM    361  CB  GLN    47       9.364  26.734  -6.537  1.00  9.13          
ATOM    362  CG  GLN    47       8.858  27.863  -5.590  1.00  8.69          
ATOM    363  CD  GLN    47       8.302  29.097  -6.313  1.00 12.55          
ATOM    364  OE1 GLN    47       9.001  29.654  -7.183  1.00 12.81          
ATOM    365  NE2 GLN    47       7.028  29.512  -5.999  1.00 10.02          
ATOM    366  N   ARG    48       8.234  24.070  -8.757  1.00 14.75          
ATOM    367  CA  ARG    48       8.882  23.003  -9.600  1.00 16.22          
ATOM    368  C   ARG    48       9.508  23.394 -10.941  1.00 18.74          
ATOM    369  O   ARG    48      10.503  22.813 -11.415  1.00 19.44          
ATOM    370  CB  ARG    48       7.955  21.872  -9.857  1.00 15.11          
ATOM    371  CG  ARG    48       6.812  22.197 -10.649  1.00 12.28          
ATOM    372  CD  ARG    48       5.739  21.130 -10.387  1.00 14.04          
ATOM    373  NE  ARG    48       4.596  21.083 -11.320  1.00 12.26          
ATOM    374  CZ  ARG    48       3.366  21.456 -11.022  1.00  7.88          
ATOM    375  NH1 ARG    48       2.382  21.322 -11.895  1.00 10.20          
ATOM    376  NH2 ARG    48       3.112  21.923  -9.830  1.00  8.03          
ATOM    377  N   GLU    49       8.945  24.443 -11.513  1.00 22.00          
ATOM    378  CA  GLU    49       9.142  24.778 -12.905  1.00 23.10          
ATOM    379  C   GLU    49      10.486  25.462 -12.887  1.00 21.97          
ATOM    380  O   GLU    49      11.117  25.564 -13.918  1.00 21.76          
ATOM    381  CB  GLU    49       7.956  25.675 -13.329  1.00 24.94          
ATOM    382  CG  GLU    49       6.632  25.427 -12.445  1.00 32.27          
ATOM    383  CD  GLU    49       5.382  24.838 -13.254  1.00 39.48          
ATOM    384  OE1 GLU    49       5.398  24.978 -14.542  1.00 42.88          
ATOM    385  OE2 GLU    49       4.371  24.278 -12.655  1.00 33.87          
ATOM    386  N   LYS    50      10.952  25.876 -11.706  1.00 20.75          
ATOM    387  CA  LYS    50      12.289  26.415 -11.602  1.00 21.27          
ATOM    388  C   LYS    50      13.357  25.454 -11.107  1.00 22.29          
ATOM    389  O   LYS    50      14.536  25.730 -11.349  1.00 22.17          
ATOM    390  CB  LYS    50      12.382  27.563 -10.644  1.00 20.60          
ATOM    391  CG  LYS    50      11.353  28.501 -10.782  1.00 23.73          
ATOM    392  CD  LYS    50      11.580  29.674  -9.798  1.00 32.88          
ATOM    393  CE  LYS    50      10.446  30.721  -9.868  1.00 34.86          
ATOM    394  NZ  LYS    50      10.027  30.892 -11.304  1.00 40.84          
ATOM    395  N   LEU    51      13.021  24.400 -10.357  1.00 22.84          
ATOM    396  CA  LEU    51      14.108  23.538  -9.925  1.00 24.35          
ATOM    397  C   LEU    51      14.666  22.590 -11.051  1.00 25.58          
ATOM    398  O   LEU    51      13.897  22.020 -11.885  1.00 24.86          
ATOM    399  CB  LEU    51      13.723  22.722  -8.703  1.00 25.21          
ATOM    400  CG  LEU    51      13.068  23.246  -7.435  1.00 24.94          
ATOM    401  CD1 LEU    51      13.734  24.504  -6.999  1.00 24.38          
ATOM    402  CD2 LEU    51      11.688  23.477  -7.833  1.00 24.87          
ATOM    403  N   GLU    52      15.991  22.427 -11.048  1.00 26.21          
ATOM    404  CA  GLU    52      16.666  21.582 -12.020  1.00 28.11          
ATOM    405  C   GLU    52      17.112  20.258 -11.418  1.00 27.85          
ATOM    406  O   GLU    52      16.266  19.421 -11.280  1.00 29.19          
ATOM    407  CB  GLU    52      17.830  22.289 -12.648  1.00 29.97          
ATOM    408  CG  GLU    52      17.450  23.278 -13.716  1.00 34.15          
ATOM    409  CD  GLU    52      17.371  22.581 -15.043  1.00 40.84          
ATOM    410  OE1 GLU    52      18.468  22.252 -15.589  1.00 41.08          
ATOM    411  OE2 GLU    52      16.210  22.347 -15.526  1.00 45.33          
ATOM    412  N   ASN    53      18.362  19.994 -11.063  1.00 26.32          
ATOM    413  CA  ASN    53      18.627  18.552 -10.795  1.00 26.13          
ATOM    414  C   ASN    53      18.692  18.238  -9.325  1.00 24.38          
ATOM    415  O   ASN    53      19.769  17.937  -8.795  1.00 24.90          
ATOM    416  CB  ASN    53      19.880  17.980 -11.476  1.00 27.32          
ATOM    417  CG  ASN    53      19.804  18.070 -12.970  1.00 33.09          
ATOM    418  OD1 ASN    53      18.812  17.618 -13.532  1.00 44.00          
ATOM    419  ND2 ASN    53      20.818  18.709 -13.638  1.00 35.87          
ATOM    420  N   ILE    54      17.566  18.308  -8.645  1.00 20.73          
ATOM    421  CA  ILE    54      17.685  18.294  -7.249  1.00 18.62          
ATOM    422  C   ILE    54      17.515  16.861  -6.767  1.00 18.10          
ATOM    423  O   ILE    54      16.558  16.202  -7.136  1.00 18.14          
ATOM    424  CB  ILE    54      16.653  19.228  -6.667  1.00 18.97          
ATOM    425  CG1 ILE    54      16.495  20.461  -7.562  1.00 18.42          
ATOM    426  CG2 ILE    54      16.981  19.512  -5.250  1.00 13.40          
ATOM    427  CD  ILE    54      17.589  21.414  -7.367  1.00 24.43          
ATOM    428  N   THR    55      18.431  16.379  -5.946  1.00 16.66          
ATOM    429  CA  THR    55      18.296  15.069  -5.355  1.00 17.48          
ATOM    430  C   THR    55      17.849  15.226  -3.939  1.00 17.26          
ATOM    431  O   THR    55      18.475  15.999  -3.210  1.00 17.34          
ATOM    432  CB  THR    55      19.670  14.425  -5.257  1.00 18.10          
ATOM    433  OG1 THR    55      20.177  14.302  -6.554  1.00 19.09          
ATOM    434  CG2 THR    55      19.567  12.992  -4.872  1.00 18.79          
ATOM    435  N   VAL    56      16.828  14.485  -3.492  1.00 16.58          
ATOM    436  CA  VAL    56      16.601  14.516  -2.035  1.00 17.07          
ATOM    437  C   VAL    56      16.821  13.213  -1.320  1.00 16.61          
ATOM    438  O   VAL    56      16.496  12.147  -1.837  1.00 14.95          
ATOM    439  CB  VAL    56      15.356  15.352  -1.560  1.00 16.13          
ATOM    440  CG1 VAL    56      14.273  15.165  -2.494  1.00 18.18          
ATOM    441  CG2 VAL    56      14.912  14.926  -0.175  1.00 15.60          
ATOM    442  N   PHE    57      17.468  13.294  -0.166  1.00 17.83          
ATOM    443  CA  PHE    57      17.566  12.104   0.653  1.00 20.29          
ATOM    444  C   PHE    57      16.736  12.226   1.919  1.00 20.07          
ATOM    445  O   PHE    57      16.657  13.302   2.565  1.00 21.59          
ATOM    446  CB  PHE    57      19.024  11.623   0.950  1.00 20.84          
ATOM    447  CG  PHE    57      19.062  10.550   2.007  1.00 22.77          
ATOM    448  CD1 PHE    57      19.228  10.887   3.360  1.00 24.36          
ATOM    449  CD2 PHE    57      18.769   9.213   1.664  1.00 27.03          
ATOM    450  CE1 PHE    57      19.180   9.884   4.395  1.00 26.23          
ATOM    451  CE2 PHE    57      18.697   8.214   2.674  1.00 28.83          
ATOM    452  CZ  PHE    57      18.906   8.564   4.072  1.00 23.10          
ATOM    453  N   HSD    58      16.086  11.132   2.231  1.00 20.79          
ATOM    454  CA  HSD    58      15.356  10.977   3.520  1.00 23.07          
ATOM    455  C   HSD    58      14.856   9.522   3.756  1.00 23.95          
ATOM    456  O   HSD    58      15.233   8.589   3.005  1.00 24.70          
ATOM    457  CB  HSD    58      14.229  12.033   3.710  1.00 22.43          
ATOM    458  CG  HSD    58      13.028  11.795   2.855  1.00 20.20          
ATOM    459  ND1 HSD    58      12.702  12.604   1.782  1.00 22.17          
ATOM    460  CD2 HSD    58      12.082  10.828   2.897  1.00 16.24          
ATOM    461  CE1 HSD    58      11.581  12.160   1.212  1.00 19.90          
ATOM    462  NE2 HSD    58      11.188  11.082   1.869  1.00 18.72          
ATOM    463  N   MET    59      14.047   9.349   4.804  1.00 24.79          
ATOM    464  CA  MET    59      13.649   8.032   5.330  1.00 25.10          
ATOM    465  C   MET    59      12.198   8.141   5.652  1.00 25.33          
ATOM    466  O   MET    59      11.461   8.248   4.747  1.00 27.43          
ATOM    467  CB  MET    59      14.502   7.639   6.529  1.00 23.90          
ATOM    468  CG  MET    59      15.867   7.184   6.090  1.00 24.27          
ATOM    469  SD  MET    59      16.994   6.955   7.482  1.00 27.42          
ATOM    470  CE  MET    59      17.542   5.314   6.896  1.00 24.67          
ATOM    471  N   LEU    60      11.756   8.168   6.909  1.00 26.46          
ATOM    472  CA  LEU    60      10.329   8.393   7.228  1.00 26.02          
ATOM    473  C   LEU    60       9.941   9.783   6.977  1.00 26.45          
ATOM    474  O   LEU    60      10.475  10.677   7.572  1.00 26.47          
ATOM    475  CB  LEU    60      10.035   8.147   8.709  1.00 25.84          
ATOM    476  CG  LEU    60      10.033   6.701   9.129  1.00 25.58          
ATOM    477  CD1 LEU    60       8.709   6.212   8.924  1.00 27.61          
ATOM    478  CD2 LEU    60      10.939   5.998   8.198  1.00 21.75          
ATOM    479  N   TYR    61       8.926   9.965   6.177  1.00 28.90          
ATOM    480  CA  TYR    61       8.262  11.269   6.102  1.00 30.96          
ATOM    481  C   TYR    61       6.851  11.029   6.539  1.00 30.13          
ATOM    482  O   TYR    61       6.155  10.179   5.967  1.00 28.73          
ATOM    483  CB  TYR    61       8.169  11.718   4.619  1.00 34.27          
ATOM    484  CG  TYR    61       7.359  10.683   3.650  1.00 41.40          
ATOM    485  CD1 TYR    61       7.983   9.487   3.067  1.00 44.61          
ATOM    486  CD2 TYR    61       5.936  10.900   3.304  1.00 46.34          
ATOM    487  CE1 TYR    61       7.195   8.579   2.125  1.00 40.74          
ATOM    488  CE2 TYR    61       5.166   9.985   2.389  1.00 39.60          
ATOM    489  CZ  TYR    61       5.817   8.870   1.840  1.00 38.96          
ATOM    490  OH  TYR    61       5.082   8.073   1.024  1.00 39.91          
ATOM    491  N   PHE    62       6.378  11.814   7.486  1.00 30.46          
ATOM    492  CA  PHE    62       4.942  11.940   7.685  1.00 30.51          
ATOM    493  C   PHE    62       4.272  13.216   7.040  1.00 30.96          
ATOM    494  O   PHE    62       4.502  14.243   7.611  1.00 30.96          
ATOM    495  CB  PHE    62       4.804  11.972   9.177  1.00 30.79          
ATOM    496  CG  PHE    62       5.309  10.724   9.877  1.00 30.41          
ATOM    497  CD1 PHE    62       5.704  10.780  11.212  1.00 32.62          
ATOM    498  CD2 PHE    62       5.307   9.497   9.257  1.00 30.78          
ATOM    499  CE1 PHE    62       6.144   9.622  11.925  1.00 31.31          
ATOM    500  CE2 PHE    62       5.753   8.336   9.940  1.00 32.05          
ATOM    501  CZ  PHE    62       6.160   8.405  11.287  1.00 31.82          
ATOM    502  N   GLY    63       3.548  13.163   5.852  1.00 32.78          
ATOM    503  CA  GLY    63       2.657  14.280   5.178  1.00 32.09          
ATOM    504  C   GLY    63       3.081  14.990   3.844  1.00 34.69          
ATOM    505  O   GLY    63       2.308  15.607   2.985  1.00 34.41          
ATOM    506  N   ASP    64       4.410  15.044   3.799  1.00 36.39          
ATOM    507  CA  ASP    64       5.309  15.294   2.680  1.00 35.00          
ATOM    508  C   ASP    64       4.753  14.780   1.366  1.00 34.29          
ATOM    509  O   ASP    64       5.276  13.798   0.809  1.00 33.58          
ATOM    510  CB  ASP    64       6.508  14.343   3.001  1.00 34.52          
ATOM    511  CG  ASP    64       7.652  15.050   3.379  1.00 32.44          
ATOM    512  OD1 ASP    64       8.674  14.406   3.786  1.00 30.73          
ATOM    513  OD2 ASP    64       7.541  16.298   3.252  1.00 27.43          
ATOM    514  N   ALA    65       3.708  15.324   0.838  1.00 33.07          
ATOM    515  CA  ALA    65       3.454  14.680  -0.458  1.00 33.64          
ATOM    516  C   ALA    65       4.514  15.087  -1.506  1.00 31.92          
ATOM    517  O   ALA    65       5.497  14.427  -1.735  1.00 29.97          
ATOM    518  CB  ALA    65       1.846  14.790  -1.003  1.00 34.74          
ATOM    519  N   PRO    66       4.329  16.237  -2.074  1.00 32.05          
ATOM    520  CA  PRO    66       5.006  16.623  -3.330  1.00 33.03          
ATOM    521  C   PRO    66       6.521  16.253  -3.524  1.00 34.34          
ATOM    522  O   PRO    66       7.373  17.077  -3.280  1.00 33.74          
ATOM    523  CB  PRO    66       4.874  18.121  -3.234  1.00 33.84          
ATOM    524  CG  PRO    66       4.389  18.356  -1.562  1.00 32.17          
ATOM    525  CD  PRO    66       3.498  17.308  -1.500  1.00 30.81          
ATOM    526  N   HSD    67       6.913  15.040  -3.887  1.00 36.42          
ATOM    527  CA  HSD    67       8.299  14.912  -4.441  1.00 37.64          
ATOM    528  C   HSD    67       8.279  13.755  -5.342  1.00 38.84          
ATOM    529  O   HSD    67       9.163  13.665  -6.315  1.00 39.60          
ATOM    530  CB  HSD    67       9.355  14.334  -3.514  1.00 38.67          
ATOM    531  CG  HSD    67       9.399  14.916  -2.154  1.00 37.94          
ATOM    532  ND1 HSD    67       9.396  16.275  -1.927  1.00 35.73          
ATOM    533  CD2 HSD    67       9.531  14.304  -0.952  1.00 31.96          
ATOM    534  CE1 HSD    67       9.456  16.471  -0.625  1.00 38.35          
ATOM    535  NE2 HSD    67       9.510  15.292  -0.015  1.00 37.11          
ATOM    536  N   LEU    68       7.440  12.772  -4.891  1.00 37.72          
ATOM    537  CA  LEU    68       7.176  11.562  -5.710  1.00 36.10          
ATOM    538  C   LEU    68       5.935  11.880  -6.488  1.00 33.90          
ATOM    539  O   LEU    68       5.398  10.980  -7.148  1.00 35.37          
ATOM    540  CB  LEU    68       7.110  10.187  -4.948  1.00 36.82          
ATOM    541  CG  LEU    68       7.523   8.769  -5.573  1.00 38.55          
ATOM    542  CD1 LEU    68       8.359   8.708  -6.967  1.00 37.96          
ATOM    543  CD2 LEU    68       8.153   7.758  -4.525  1.00 36.10          
ATOM    544  N   ALA    69       5.502  13.148  -6.458  1.00 29.05          
ATOM    545  CA  ALA    69       4.440  13.513  -7.345  1.00 25.67          
ATOM    546  C   ALA    69       5.172  13.310  -8.628  1.00 22.99          
ATOM    547  O   ALA    69       6.304  13.731  -8.726  1.00 22.81          
ATOM    548  CB  ALA    69       4.091  14.939  -7.172  1.00 26.27          
ATOM    549  N   PRO    70       4.599  12.552  -9.552  1.00 20.49          
ATOM    550  CA  PRO    70       5.181  12.342 -10.869  1.00 18.83          
ATOM    551  C   PRO    70       5.671  13.601 -11.568  1.00 17.75          
ATOM    552  O   PRO    70       6.665  13.526 -12.299  1.00 18.08          
ATOM    553  CB  PRO    70       4.035  11.697 -11.681  1.00 18.88          
ATOM    554  CG  PRO    70       3.120  11.140 -10.759  1.00 17.25          
ATOM    555  CD  PRO    70       3.385  11.747  -9.370  1.00 20.05          
ATOM    556  N   GLU    71       5.012  14.750 -11.363  1.00 16.84          
ATOM    557  CA  GLU    71       5.385  16.022 -12.066  1.00 14.77          
ATOM    558  C   GLU    71       6.697  16.599 -11.560  1.00 15.46          
ATOM    559  O   GLU    71       7.327  17.440 -12.197  1.00 16.72          
ATOM    560  CB  GLU    71       4.228  17.005 -12.122  1.00 12.78          
ATOM    561  CG  GLU    71       3.378  17.141 -10.891  1.00 14.57          
ATOM    562  CD  GLU    71       2.325  16.045 -10.606  1.00 20.09          
ATOM    563  OE1 GLU    71       1.184  16.257 -10.876  1.00 26.94          
ATOM    564  OE2 GLU    71       2.537  14.991 -10.001  1.00 21.86          
ATOM    565  N   MET    72       7.163  16.102 -10.418  1.00 15.91          
ATOM    566  CA  MET    72       8.532  16.369  -9.972  1.00 16.11          
ATOM    567  C   MET    72       9.590  15.773 -10.867  1.00 16.82          
ATOM    568  O   MET    72      10.752  16.175 -10.777  1.00 16.32          
ATOM    569  CB  MET    72       8.749  15.812  -8.612  1.00 15.79          
ATOM    570  CG  MET    72       7.785  16.416  -7.627  1.00 16.25          
ATOM    571  SD  MET    72       7.583  18.155  -7.899  1.00 17.49          
ATOM    572  CE  MET    72       8.963  19.024  -7.147  1.00  5.62          
ATOM    573  N   ARG    73       9.191  14.814 -11.710  1.00 17.47          
ATOM    574  CA  ARG    73      10.127  14.188 -12.649  1.00 18.49          
ATOM    575  C   ARG    73      10.949  15.230 -13.405  1.00 18.37          
ATOM    576  O   ARG    73      10.418  16.093 -14.086  1.00 19.34          
ATOM    577  CB  ARG    73       9.455  13.193 -13.617  1.00 18.25          
ATOM    578  CG  ARG    73      10.374  12.748 -14.717  1.00 19.07          
ATOM    579  CD  ARG    73       9.821  11.628 -15.541  1.00 22.48          
ATOM    580  NE  ARG    73      10.362  10.331 -15.125  1.00 23.61          
ATOM    581  CZ  ARG    73       9.732   9.507 -14.315  1.00 23.62          
ATOM    582  NH1 ARG    73       8.553   9.876 -13.826  1.00 25.50          
ATOM    583  NH2 ARG    73      10.271   8.337 -13.967  1.00 21.07          
ATOM    584  N   SER    74      12.260  15.086 -13.270  1.00 17.82          
ATOM    585  CA  SER    74      13.283  15.968 -13.810  1.00 16.37          
ATOM    586  C   SER    74      13.431  17.168 -12.940  1.00 18.12          
ATOM    587  O   SER    74      14.343  17.950 -13.187  1.00 20.81          
ATOM    588  CB  SER    74      13.020  16.452 -15.194  1.00 14.43          
ATOM    589  OG  SER    74      12.489  17.717 -15.159  1.00 10.73          
ATOM    590  N   HSD    75      12.584  17.360 -11.923  1.00 17.54          
ATOM    591  CA  HSD    75      12.885  18.456 -10.991  1.00 16.10          
ATOM    592  C   HSD    75      13.540  18.025  -9.744  1.00 15.04          
ATOM    593  O   HSD    75      14.547  18.556  -9.389  1.00 14.88          
ATOM    594  CB  HSD    75      11.660  19.337 -10.746  1.00 16.21          
ATOM    595  CG  HSD    75      11.008  19.797 -12.023  1.00 13.53          
ATOM    596  ND1 HSD    75      11.544  20.796 -12.805  1.00  9.81          
ATOM    597  CD2 HSD    75       9.887  19.367 -12.653  1.00  8.80          
ATOM    598  CE1 HSD    75      10.760  20.970 -13.852  1.00 13.78          
ATOM    599  NE2 HSD    75       9.741  20.130 -13.771  1.00  9.55          
ATOM    600  N   VAL    76      12.961  17.056  -9.063  1.00 15.89          
ATOM    601  CA  VAL    76      13.644  16.465  -7.915  1.00 16.03          
ATOM    602  C   VAL    76      13.323  15.022  -7.738  1.00 17.34          
ATOM    603  O   VAL    76      12.152  14.646  -7.685  1.00 18.48          
ATOM    604  CB  VAL    76      13.393  17.180  -6.596  1.00 14.83          
ATOM    605  CG1 VAL    76      12.180  17.969  -6.643  1.00 10.14          
ATOM    606  CG2 VAL    76      13.333  16.156  -5.480  1.00 13.99          
ATOM    607  N   HSD    77      14.385  14.233  -7.630  1.00 18.66          
ATOM    608  CA  HSD    77      14.274  12.805  -7.416  1.00 20.88          
ATOM    609  C   HSD    77      14.731  12.416  -6.057  1.00 22.14          
ATOM    610  O   HSD    77      15.667  13.046  -5.558  1.00 23.59          
ATOM    611  CB  HSD    77      15.129  12.065  -8.411  1.00 20.82          
ATOM    612  CG  HSD    77      14.694  12.282  -9.823  1.00 24.04          
ATOM    613  ND1 HSD    77      13.466  12.848 -10.144  1.00 25.21          
ATOM    614  CD2 HSD    77      15.315  12.017 -10.996  1.00 20.39          
ATOM    615  CE1 HSD    77      13.363  12.935 -11.454  1.00 23.22          
ATOM    616  NE2 HSD    77      14.457  12.413 -11.990  1.00 23.36          
ATOM    617  N   PRO    78      14.124  11.376  -5.456  1.00 23.06          
ATOM    618  CA  PRO    78      14.643  10.810  -4.176  1.00 23.97          
ATOM    619  C   PRO    78      15.836   9.841  -4.370  1.00 24.35          
ATOM    620  O   PRO    78      15.902   9.146  -5.395  1.00 23.72          
ATOM    621  CB  PRO    78      13.440  10.059  -3.644  1.00 23.70          
ATOM    622  CG  PRO    78      12.746   9.561  -4.959  1.00 22.21          
ATOM    623  CD  PRO    78      12.941  10.634  -5.946  1.00 22.27          
ATOM    624  N   THR    79      16.758   9.811  -3.411  1.00 25.96          
ATOM    625  CA  THR    79      17.809   8.792  -3.430  1.00 28.67          
ATOM    626  C   THR    79      17.750   8.104  -2.128  1.00 30.83          
ATOM    627  O   THR    79      17.203   8.640  -1.108  1.00 31.90          
ATOM    628  CB  THR    79      19.254   9.311  -3.573  1.00 28.44          
ATOM    629  OG1 THR    79      19.285  10.696  -3.253  1.00 28.13          
ATOM    630  CG2 THR    79      19.861   9.199  -5.025  1.00 28.02          
ATOM    631  N   LEU    80      18.303   6.888  -2.203  1.00 32.55          
ATOM    632  CA  LEU    80      18.741   6.101  -1.031  1.00 33.52          
ATOM    633  C   LEU    80      20.077   5.382  -1.384  1.00 33.06          
ATOM    634  O   LEU    80      20.637   5.591  -2.481  1.00 31.87          
ATOM    635  CB  LEU    80      17.644   5.157  -0.541  1.00 31.95          
ATOM    636  CG  LEU    80      17.328   3.966  -1.467  1.00 34.36          
ATOM    637  CD1 LEU    80      16.992   4.359  -2.983  1.00 32.23          
ATOM    638  CD2 LEU    80      18.317   2.698  -1.325  1.00 32.55          
ATOM    639  N   CYS   101      21.530  -0.841   6.743  1.00 45.50          
ATOM    640  CA  CYS   101      20.526  -1.334   7.693  1.00 45.54          
ATOM    641  C   CYS   101      20.963  -1.287   9.222  1.00 45.98          
ATOM    642  O   CYS   101      20.126  -1.461  10.192  1.00 47.36          
ATOM    643  CB  CYS   101      20.300  -2.738   7.347  1.00 45.34          
ATOM    644  SG  CYS   101      21.876  -3.463   7.806  1.00 47.60          
ATOM    645  N   HSD   102      22.265  -1.101   9.476  1.00 45.20          
ATOM    646  CA  HSD   102      22.644  -0.627  10.825  1.00 43.68          
ATOM    647  C   HSD   102      22.277   0.859  10.841  1.00 42.64          
ATOM    648  O   HSD   102      23.146   1.706  10.540  1.00 44.05          
ATOM    649  CB  HSD   102      24.133  -0.753  11.145  1.00 42.86          
ATOM    650  CG  HSD   102      24.684  -2.138  11.011  1.00 44.86          
ATOM    651  ND1 HSD   102      26.028  -2.378  10.768  1.00 47.33          
ATOM    652  CD2 HSD   102      24.089  -3.353  11.077  1.00 43.51          
ATOM    653  CE1 HSD   102      26.240  -3.681  10.695  1.00 46.54          
ATOM    654  NE2 HSD   102      25.078  -4.292  10.871  1.00 47.46          
ATOM    655  N   PHE   103      21.022   1.195  11.177  1.00 39.64          
ATOM    656  CA  PHE   103      20.691   2.585  11.422  1.00 36.08          
ATOM    657  C   PHE   103      21.808   3.521  11.969  1.00 34.98          
ATOM    658  O   PHE   103      21.927   4.629  11.453  1.00 34.66          
ATOM    659  CB  PHE   103      19.429   2.705  12.250  1.00 35.62          
ATOM    660  CG  PHE   103      18.673   3.983  12.020  1.00 34.35          
ATOM    661  CD1 PHE   103      17.616   4.315  12.819  1.00 34.67          
ATOM    662  CD2 PHE   103      19.014   4.860  10.982  1.00 33.50          
ATOM    663  CE1 PHE   103      16.877   5.498  12.565  1.00 36.44          
ATOM    664  CE2 PHE   103      18.290   6.055  10.746  1.00 33.77          
ATOM    665  CZ  PHE   103      17.243   6.376  11.508  1.00 33.22          
ATOM    666  N   HSD   104      22.598   3.136  12.980  1.00 33.95          
ATOM    667  CA  HSD   104      23.627   4.090  13.515  1.00 34.71          
ATOM    668  C   HSD   104      24.690   4.666  12.501  1.00 34.55          
ATOM    669  O   HSD   104      25.382   5.694  12.833  1.00 35.19          
ATOM    670  CB  HSD   104      24.334   3.600  14.802  1.00 34.12          
ATOM    671  CG  HSD   104      25.381   2.568  14.550  1.00 33.67          
ATOM    672  ND1 HSD   104      26.720   2.775  14.840  1.00 36.93          
ATOM    673  CD2 HSD   104      25.294   1.328  14.012  1.00 31.58          
ATOM    674  CE1 HSD   104      27.410   1.702  14.489  1.00 35.47          
ATOM    675  NE2 HSD   104      26.569   0.811  13.984  1.00 32.99          
ATOM    676  N   GLU   105      24.778   4.073  11.288  1.00 32.40          
ATOM    677  CA  GLU   105      25.748   4.484  10.276  1.00 30.25          
ATOM    678  C   GLU   105      25.276   5.484   9.245  1.00 27.86          
ATOM    679  O   GLU   105      26.103   5.998   8.467  1.00 27.71          
ATOM    680  CB  GLU   105      26.257   3.259   9.589  1.00 31.31          
ATOM    681  CG  GLU   105      26.505   2.202  10.636  1.00 34.56          
ATOM    682  CD  GLU   105      26.814   0.843  10.054  1.00 38.25          
ATOM    683  OE1 GLU   105      25.880   0.161   9.535  1.00 38.04          
ATOM    684  OE2 GLU   105      28.003   0.450  10.166  1.00 41.24          
ATOM    685  N   VAL   106      23.987   5.781   9.245  1.00 24.63          
ATOM    686  CA  VAL   106      23.439   6.831   8.393  1.00 24.31          
ATOM    687  C   VAL   106      24.181   8.165   8.602  1.00 23.93          
ATOM    688  O   VAL   106      24.841   8.717   7.690  1.00 26.52          
ATOM    689  CB  VAL   106      21.876   7.000   8.544  1.00 25.36          
ATOM    690  CG1 VAL   106      21.197   7.664   7.288  1.00 21.28          
ATOM    691  CG2 VAL   106      21.192   5.615   8.881  1.00 25.50          
ATOM    692  N   PRO   107      24.187   8.669   9.797  1.00 21.38          
ATOM    693  CA  PRO   107      24.981   9.825  10.038  1.00 19.87          
ATOM    694  C   PRO   107      26.338   9.827   9.351  1.00 18.46          
ATOM    695  O   PRO   107      26.623  10.763   8.703  1.00 16.39          
ATOM    696  CB  PRO   107      25.101   9.776  11.506  1.00 20.31          
ATOM    697  CG  PRO   107      23.732   9.356  11.883  1.00 20.20          
ATOM    698  CD  PRO   107      23.516   8.190  11.010  1.00 21.38          
ATOM    699  N   GLU   108      27.140   8.782   9.447  1.00 18.93          
ATOM    700  CA  GLU   108      28.395   8.687   8.631  1.00 20.48          
ATOM    701  C   GLU   108      28.280   8.933   7.080  1.00 20.01          
ATOM    702  O   GLU   108      29.235   9.273   6.408  1.00 19.49          
ATOM    703  CB  GLU   108      29.048   7.318   8.837  1.00 20.61          
ATOM    704  CG  GLU   108      30.506   7.376   9.264  1.00 25.10          
ATOM    705  CD  GLU   108      30.726   7.994  10.646  1.00 24.03          
ATOM    706  OE1 GLU   108      29.693   8.094  11.353  1.00 23.17          
ATOM    707  OE2 GLU   108      31.916   8.366  10.990  1.00 19.42          
ATOM    708  N   LEU   109      27.114   8.743   6.495  1.00 19.15          
ATOM    709  CA  LEU   109      27.001   9.063   5.095  1.00 18.15          
ATOM    710  C   LEU   109      27.305  10.541   4.832  1.00 18.39          
ATOM    711  O   LEU   109      27.993  10.910   3.869  1.00 19.79          
ATOM    712  CB  LEU   109      25.575   8.727   4.611  1.00 18.32          
ATOM    713  CG  LEU   109      25.292   7.449   3.761  1.00 13.74          
ATOM    714  CD1 LEU   109      26.274   6.224   3.964  1.00  5.50          
ATOM    715  CD2 LEU   109      23.938   7.173   4.170  1.00  7.55          
ATOM    716  N   PHE   110      26.784  11.400   5.687  1.00 17.00          
ATOM    717  CA  PHE   110      27.187  12.800   5.691  1.00 15.01          
ATOM    718  C   PHE   110      28.634  13.069   6.220  1.00 15.12          
ATOM    719  O   PHE   110      29.400  13.758   5.587  1.00 15.21          
ATOM    720  CB  PHE   110      26.145  13.590   6.434  1.00 14.03          
ATOM    721  CG  PHE   110      24.733  13.051   6.249  1.00 13.77          
ATOM    722  CD1 PHE   110      24.223  12.756   4.947  1.00 14.11          
ATOM    723  CD2 PHE   110      23.899  12.861   7.335  1.00 10.22          
ATOM    724  CE1 PHE   110      22.902  12.262   4.796  1.00 10.69          
ATOM    725  CE2 PHE   110      22.521  12.369   7.165  1.00  9.50          
ATOM    726  CZ  PHE   110      22.066  12.063   5.918  1.00 10.95          
ATOM    727  N   ARG   111      29.003  12.505   7.358  1.00 15.13          
ATOM    728  CA  ARG   111      30.144  12.914   8.062  1.00 15.28          
ATOM    729  C   ARG   111      31.270  12.319   7.334  1.00 16.62          
ATOM    730  O   ARG   111      32.272  12.077   7.904  1.00 19.94          
ATOM    731  CB  ARG   111      30.109  12.307   9.432  1.00 14.02          
ATOM    732  CG  ARG   111      29.653  13.267  10.394  1.00 18.60          
ATOM    733  CD  ARG   111      29.820  12.941  11.940  1.00 26.87          
ATOM    734  NE  ARG   111      28.561  13.406  12.583  1.00 37.30          
ATOM    735  CZ  ARG   111      28.135  13.260  13.881  1.00 40.61          
ATOM    736  NH1 ARG   111      28.971  12.738  14.802  1.00 43.89          
ATOM    737  NH2 ARG   111      26.869  13.661  14.248  1.00 33.22          
ATOM    738  N   GLN   112      31.130  11.989   6.076  1.00 17.88          
ATOM    739  CA  GLN   112      32.186  11.184   5.373  1.00 17.82          
ATOM    740  C   GLN   112      31.983  11.420   3.856  1.00 17.31          
ATOM    741  O   GLN   112      32.747  10.991   3.023  1.00 15.36          
ATOM    742  CB  GLN   112      31.937   9.741   5.757  1.00 17.77          
ATOM    743  CG  GLN   112      32.937   8.770   5.474  1.00 24.26          
ATOM    744  CD  GLN   112      33.366   8.058   6.771  1.00 35.06          
ATOM    745  OE1 GLN   112      33.030   6.873   7.039  1.00 37.92          
ATOM    746  NE2 GLN   112      34.084   8.803   7.608  1.00 39.62          
ATOM    747  N   GLY   113      30.903  12.130   3.528  1.00 16.69          
ATOM    748  CA  GLY   113      30.715  12.469   2.210  1.00 18.47          
ATOM    749  C   GLY   113      30.203  11.358   1.289  1.00 19.78          
ATOM    750  O   GLY   113      30.034  11.600   0.090  1.00 18.83          
ATOM    751  N   PHE   114      29.914  10.156   1.789  1.00 20.80          
ATOM    752  CA  PHE   114      29.070   9.234   0.972  1.00 21.04          
ATOM    753  C   PHE   114      27.861   9.905   0.309  1.00 20.89          
ATOM    754  O   PHE   114      27.619   9.654  -0.876  1.00 21.49          
ATOM    755  CB  PHE   114      28.643   8.031   1.736  1.00 20.73          
ATOM    756  CG  PHE   114      29.793   7.199   2.204  1.00 23.48          
ATOM    757  CD1 PHE   114      30.047   7.030   3.557  1.00 26.99          
ATOM    758  CD2 PHE   114      30.618   6.571   1.309  1.00 22.39          
ATOM    759  CE1 PHE   114      31.102   6.225   3.995  1.00 26.36          
ATOM    760  CE2 PHE   114      31.693   5.791   1.762  1.00 23.48          
ATOM    761  CZ  PHE   114      31.921   5.604   3.094  1.00 24.22          
ATOM    762  N   PHE   115      27.146  10.786   1.030  1.00 20.88          
ATOM    763  CA  PHE   115      26.104  11.678   0.402  1.00 20.11          
ATOM    764  C   PHE   115      26.458  13.165   0.639  1.00 19.79          
ATOM    765  O   PHE   115      26.158  13.701   1.704  1.00 18.54          
ATOM    766  CB  PHE   115      24.694  11.339   0.893  1.00 18.75          
ATOM    767  CG  PHE   115      23.614  12.121   0.220  1.00 17.79          
ATOM    768  CD1 PHE   115      22.906  13.095   0.935  1.00 11.55          
ATOM    769  CD2 PHE   115      23.258  11.855  -1.170  1.00 18.01          
ATOM    770  CE1 PHE   115      21.853  13.769   0.326  1.00 11.48          
ATOM    771  CE2 PHE   115      22.231  12.584  -1.838  1.00  9.11          
ATOM    772  CZ  PHE   115      21.551  13.539  -1.122  1.00 13.81          
ATOM    773  N   PRO   116      27.156  13.783  -0.344  1.00 20.18          
ATOM    774  CA  PRO   116      27.699  15.137  -0.181  1.00 20.41          
ATOM    775  C   PRO   116      26.586  16.146  -0.091  1.00 21.00          
ATOM    776  O   PRO   116      26.413  16.892  -1.001  1.00 22.72          
ATOM    777  CB  PRO   116      28.496  15.363  -1.481  1.00 19.12          
ATOM    778  CG  PRO   116      28.037  14.366  -2.418  1.00 18.64          
ATOM    779  CD  PRO   116      27.529  13.218  -1.669  1.00 19.31          
ATOM    780  N   LEU   117      25.833  16.143   0.993  1.00 21.68          
ATOM    781  CA  LEU   117      24.728  17.062   1.226  1.00 21.87          
ATOM    782  C   LEU   117      25.171  18.521   1.129  1.00 22.02          
ATOM    783  O   LEU   117      26.191  18.949   1.700  1.00 23.52          
ATOM    784  CB  LEU   117      24.089  16.710   2.580  1.00 21.33          
ATOM    785  CG  LEU   117      24.050  17.713   3.700  1.00 24.40          
ATOM    786  CD1 LEU   117      22.634  17.784   4.141  1.00 31.96          
ATOM    787  CD2 LEU   117      24.925  17.377   4.866  1.00 24.53          
ATOM    788  N   ASP   118      24.397  19.278   0.394  1.00 21.56          
ATOM    789  CA  ASP   118      24.654  20.659   0.241  1.00 22.59          
ATOM    790  C   ASP   118      23.768  21.520   1.197  1.00 21.72          
ATOM    791  O   ASP   118      24.257  22.550   1.778  1.00 22.08          
ATOM    792  CB  ASP   118      24.347  21.022  -1.238  1.00 24.09          
ATOM    793  CG  ASP   118      25.443  20.582  -2.208  1.00 29.34          
ATOM    794  OD1 ASP   118      26.680  20.684  -1.828  1.00 34.93          
ATOM    795  OD2 ASP   118      25.141  20.121  -3.366  1.00 31.49          
ATOM    796  N   VAL   119      22.470  21.152   1.275  1.00 19.14          
ATOM    797  CA  VAL   119      21.493  21.824   2.128  1.00 17.20          
ATOM    798  C   VAL   119      20.771  20.805   3.006  1.00 15.41          
ATOM    799  O   VAL   119      20.330  19.796   2.516  1.00 16.54          
ATOM    800  CB  VAL   119      20.432  22.694   1.298  1.00 17.99          
ATOM    801  CG1 VAL   119      20.314  22.252  -0.080  1.00 17.88          
ATOM    802  CG2 VAL   119      19.001  22.730   1.946  1.00 13.59          
ATOM    803  N   ALA   120      20.630  21.096   4.281  1.00 12.24          
ATOM    804  CA  ALA   120      19.855  20.289   5.176  1.00 10.62          
ATOM    805  C   ALA   120      18.527  21.002   5.483  1.00  9.86          
ATOM    806  O   ALA   120      18.526  22.100   5.999  1.00  8.76          
ATOM    807  CB  ALA   120      20.692  20.034   6.491  1.00  9.97          
ATOM    808  N   VAL   121      17.391  20.406   5.169  1.00 10.09          
ATOM    809  CA  VAL   121      16.119  21.058   5.473  1.00 11.02          
ATOM    810  C   VAL   121      15.448  20.408   6.667  1.00 12.46          
ATOM    811  O   VAL   121      15.012  19.311   6.521  1.00 14.42          
ATOM    812  CB  VAL   121      15.150  21.024   4.309  1.00 10.38          
ATOM    813  CG1 VAL   121      13.767  21.571   4.701  1.00  9.85          
ATOM    814  CG2 VAL   121      15.694  21.876   3.311  1.00  9.47          
ATOM    815  N   VAL   122      15.356  21.080   7.820  1.00 12.59          
ATOM    816  CA  VAL   122      14.867  20.526   9.051  1.00 12.88          
ATOM    817  C   VAL   122      13.730  21.322   9.628  1.00 14.40          
ATOM    818  O   VAL   122      13.502  22.504   9.312  1.00 14.88          
ATOM    819  CB  VAL   122      15.952  20.504  10.159  1.00 12.79          
ATOM    820  CG1 VAL   122      17.200  19.769   9.719  1.00 11.51          
ATOM    821  CG2 VAL   122      16.309  21.893  10.610  1.00 15.12          
ATOM    822  N   GLN   123      13.030  20.701  10.568  1.00 15.62          
ATOM    823  CA  GLN   123      11.940  21.434  11.196  1.00 15.39          
ATOM    824  C   GLN   123      12.242  21.681  12.667  1.00 15.45          
ATOM    825  O   GLN   123      11.961  20.837  13.393  1.00 18.31          
ATOM    826  CB  GLN   123      10.635  20.625  11.029  1.00 13.80          
ATOM    827  CG  GLN   123       9.477  21.212  11.740  1.00 13.25          
ATOM    828  CD  GLN   123       8.169  20.546  11.364  1.00 16.16          
ATOM    829  OE1 GLN   123       8.115  19.359  11.065  1.00 17.38          
ATOM    830  NE2 GLN   123       7.102  21.301  11.423  1.00 16.59          
ATOM    831  N   VAL   124      12.771  22.783  13.145  1.00 15.40          
ATOM    832  CA  VAL   124      12.923  22.898  14.619  1.00 15.56          
ATOM    833  C   VAL   124      11.836  23.644  15.304  1.00 16.06          
ATOM    834  O   VAL   124      10.858  24.071  14.659  1.00 16.47          
ATOM    835  CB  VAL   124      14.146  23.663  14.939  1.00 15.79          
ATOM    836  CG1 VAL   124      15.330  22.842  14.450  1.00 17.89          
ATOM    837  CG2 VAL   124      14.108  25.044  14.165  1.00 16.01          
ATOM    838  N   SER   125      12.075  23.893  16.594  1.00 16.31          
ATOM    839  CA  SER   125      11.141  24.591  17.487  1.00 16.64          
ATOM    840  C   SER   125      11.526  26.068  17.720  1.00 18.84          
ATOM    841  O   SER   125      12.624  26.536  17.326  1.00 17.98          
ATOM    842  CB  SER   125      11.262  23.984  18.839  1.00 16.62          
ATOM    843  OG  SER   125      12.189  24.785  19.591  1.00 12.33          
ATOM    844  N   THR   126      10.657  26.814  18.426  1.00 20.67          
ATOM    845  CA  THR   126      11.023  28.199  18.726  1.00 21.55          
ATOM    846  C   THR   126      12.234  28.251  19.672  1.00 23.18          
ATOM    847  O   THR   126      12.262  27.529  20.676  1.00 23.07          
ATOM    848  CB  THR   126       9.869  28.974  19.298  1.00 20.93          
ATOM    849  OG1 THR   126       9.083  28.150  20.168  1.00 20.40          
ATOM    850  CG2 THR   126       8.902  29.330  18.190  1.00 24.14          
ATOM    851  N   PRO   127      13.209  29.117  19.354  1.00 24.24          
ATOM    852  CA  PRO   127      14.437  29.287  20.151  1.00 24.55          
ATOM    853  C   PRO   127      14.124  29.909  21.448  1.00 25.49          
ATOM    854  O   PRO   127      13.047  30.447  21.648  1.00 24.73          
ATOM    855  CB  PRO   127      15.256  30.320  19.388  1.00 24.89          
ATOM    856  CG  PRO   127      14.265  31.103  18.573  1.00 25.24          
ATOM    857  CD  PRO   127      13.128  30.088  18.246  1.00 24.52          
ATOM    858  N   ASN   128      15.091  29.820  22.337  1.00 27.55          
ATOM    859  CA  ASN   128      14.846  30.026  23.750  1.00 28.19          
ATOM    860  C   ASN   128      15.588  31.326  24.003  1.00 28.67          
ATOM    861  O   ASN   128      16.014  31.973  23.060  1.00 27.46          
ATOM    862  CB  ASN   128      15.434  28.869  24.555  1.00 27.90          
ATOM    863  CG  ASN   128      16.940  28.934  24.603  1.00 28.56          
ATOM    864  OD1 ASN   128      17.514  29.994  24.416  1.00 28.71          
ATOM    865  ND2 ASN   128      17.584  27.826  24.869  1.00 26.96          
ATOM    866  N   GLU   129      15.779  31.677  25.273  1.00 30.18          
ATOM    867  CA  GLU   129      16.221  33.036  25.626  1.00 30.26          
ATOM    868  C   GLU   129      17.646  33.356  25.096  1.00 30.65          
ATOM    869  O   GLU   129      18.036  34.542  24.994  1.00 30.34          
ATOM    870  CB  GLU   129      16.147  33.194  27.130  1.00 29.31          
ATOM    871  CG  GLU   129      16.185  34.609  27.604  1.00 30.83          
ATOM    872  CD  GLU   129      16.353  34.669  29.113  1.00 35.69          
ATOM    873  OE1 GLU   129      16.477  35.820  29.667  1.00 36.25          
ATOM    874  OE2 GLU   129      16.378  33.560  29.745  1.00 31.69          
ATOM    875  N   GLU   130      18.414  32.290  24.782  1.00 30.58          
ATOM    876  CA  GLU   130      19.783  32.393  24.235  1.00 29.90          
ATOM    877  C   GLU   130      19.867  32.157  22.734  1.00 28.66          
ATOM    878  O   GLU   130      20.944  31.956  22.226  1.00 29.16          
ATOM    879  CB  GLU   130      20.740  31.439  24.942  1.00 29.97          
ATOM    880  CG  GLU   130      20.840  31.736  26.427  1.00 35.17          
ATOM    881  CD  GLU   130      19.855  30.894  27.249  1.00 45.59          
ATOM    882  OE1 GLU   130      20.365  30.058  28.058  1.00 47.60          
ATOM    883  OE2 GLU   130      18.579  31.022  27.071  1.00 48.61          
ATOM    884  N   GLY   131      18.746  32.131  22.028  1.00 26.74          
ATOM    885  CA  GLY   131      18.798  31.931  20.627  1.00 25.05          
ATOM    886  C   GLY   131      19.022  30.504  20.208  1.00 24.50          
ATOM    887  O   GLY   131      19.489  30.225  19.092  1.00 25.31          
ATOM    888  N   TYR   132      18.675  29.575  21.073  1.00 24.19          
ATOM    889  CA  TYR   132      18.951  28.162  20.788  1.00 23.06          
ATOM    890  C   TYR   132      17.619  27.506  20.439  1.00 21.93          
ATOM    891  O   TYR   132      16.687  27.574  21.196  1.00 21.69          
ATOM    892  CB  TYR   132      19.646  27.495  21.999  1.00 22.21          
ATOM    893  CG  TYR   132      21.180  27.520  21.991  1.00 23.03          
ATOM    894  CD1 TYR   132      21.955  28.208  22.987  1.00 24.43          
ATOM    895  CD2 TYR   132      21.870  26.813  21.035  1.00 23.82          
ATOM    896  CE1 TYR   132      23.378  28.202  22.931  1.00 19.96          
ATOM    897  CE2 TYR   132      23.233  26.807  20.990  1.00 22.16          
ATOM    898  CZ  TYR   132      23.984  27.500  21.894  1.00 22.00          
ATOM    899  OH  TYR   132      25.360  27.397  21.663  1.00 26.15          
ATOM    900  N   CYS   133      17.525  26.921  19.272  1.00 21.73          
ATOM    901  CA  CYS   133      16.395  26.048  18.987  1.00 22.78          
ATOM    902  C   CYS   133      16.719  24.568  19.154  1.00 23.84          
ATOM    903  O   CYS   133      17.919  24.131  19.162  1.00 23.34          
ATOM    904  CB  CYS   133      16.021  26.174  17.531  1.00 23.06          
ATOM    905  SG  CYS   133      15.583  27.815  16.949  1.00 18.90          
ATOM    906  N   SER   134      15.633  23.799  19.168  1.00 23.44          
ATOM    907  CA  SER   134      15.692  22.363  19.467  1.00 24.05          
ATOM    908  C   SER   134      15.224  21.636  18.303  1.00 22.22          
ATOM    909  O   SER   134      14.246  22.082  17.669  1.00 22.62          
ATOM    910  CB  SER   134      14.695  21.931  20.615  1.00 25.98          
ATOM    911  OG  SER   134      14.539  20.487  20.661  1.00 31.24          
ATOM    912  N   PHE   135      15.813  20.461  18.099  1.00 20.16          
ATOM    913  CA  PHE   135      15.357  19.609  17.036  1.00 18.92          
ATOM    914  C   PHE   135      14.006  19.013  17.358  1.00 19.00          
ATOM    915  O   PHE   135      13.405  18.409  16.488  1.00 19.70          
ATOM    916  CB  PHE   135      16.409  18.580  16.672  1.00 17.97          
ATOM    917  CG  PHE   135      17.510  19.170  15.847  1.00 18.79          
ATOM    918  CD1 PHE   135      18.763  19.422  16.393  1.00 19.67          
ATOM    919  CD2 PHE   135      17.278  19.566  14.543  1.00 15.91          
ATOM    920  CE1 PHE   135      19.736  20.064  15.634  1.00 16.32          
ATOM    921  CE2 PHE   135      18.248  20.167  13.801  1.00 13.09          
ATOM    922  CZ  PHE   135      19.466  20.430  14.345  1.00 15.02          
ATOM    923  N   GLY   136      13.531  19.183  18.592  1.00 18.14          
ATOM    924  CA  GLY   136      12.240  18.625  19.026  1.00 18.20          
ATOM    925  C   GLY   136      12.198  17.108  19.020  1.00 18.91          
ATOM    926  O   GLY   136      13.002  16.412  19.708  1.00 19.82          
ATOM    927  N   VAL   137      11.278  16.588  18.211  1.00 18.95          
ATOM    928  CA  VAL   137      10.967  15.128  18.133  1.00 18.28          
ATOM    929  C   VAL   137      11.880  14.255  17.194  1.00 18.95          
ATOM    930  O   VAL   137      11.637  13.068  16.950  1.00 18.11          
ATOM    931  CB  VAL   137       9.449  14.883  17.900  1.00 17.64          
ATOM    932  CG1 VAL   137       8.590  15.861  18.745  1.00 12.71          
ATOM    933  CG2 VAL   137       9.109  15.027  16.446  1.00 18.29          
ATOM    934  N   SER   138      12.956  14.861  16.707  1.00 20.84          
ATOM    935  CA  SER   138      13.888  14.173  15.766  1.00 22.85          
ATOM    936  C   SER   138      15.374  14.575  15.896  1.00 23.16          
ATOM    937  O   SER   138      15.773  15.680  15.516  1.00 23.06          
ATOM    938  CB  SER   138      13.438  14.456  14.351  1.00 21.83          
ATOM    939  OG  SER   138      12.890  13.287  13.869  1.00 26.22          
ATOM    940  N   CYS   139      16.188  13.727  16.481  1.00 23.29          
ATOM    941  CA  CYS   139      17.574  14.098  16.526  1.00 24.70          
ATOM    942  C   CYS   139      18.236  13.271  15.411  1.00 26.43          
ATOM    943  O   CYS   139      18.812  13.816  14.441  1.00 26.23          
ATOM    944  CB  CYS   139      18.085  13.700  17.864  1.00 24.45          
ATOM    945  SG  CYS   139      19.615  14.510  18.126  1.00 25.47          
ATOM    946  N   ASP   140      18.026  11.941  15.555  1.00 26.42          
ATOM    947  CA  ASP   140      18.506  10.870  14.707  1.00 26.20          
ATOM    948  C   ASP   140      19.564  11.222  13.710  1.00 23.76          
ATOM    949  O   ASP   140      20.729  11.330  14.113  1.00 24.78          
ATOM    950  CB  ASP   140      17.336  10.194  14.057  1.00 28.14          
ATOM    951  CG  ASP   140      16.414  11.161  13.488  1.00 32.82          
ATOM    952  OD1 ASP   140      16.765  11.780  12.435  1.00 39.32          
ATOM    953  OD2 ASP   140      15.322  11.394  14.061  1.00 39.64          
ATOM    954  N   TYR   141      19.211  11.388  12.436  1.00 21.00          
ATOM    955  CA  TYR   141      20.283  11.667  11.411  1.00 19.84          
ATOM    956  C   TYR   141      20.189  13.104  11.015  1.00 19.27          
ATOM    957  O   TYR   141      21.051  13.644  10.273  1.00 18.41          
ATOM    958  CB  TYR   141      20.164  10.847  10.148  1.00 16.80          
ATOM    959  CG  TYR   141      18.904  11.130   9.367  1.00 16.14          
ATOM    960  CD1 TYR   141      18.818  12.162   8.478  1.00 16.72          
ATOM    961  CD2 TYR   141      17.824  10.297   9.429  1.00 16.49          
ATOM    962  CE1 TYR   141      17.677  12.362   7.738  1.00 10.84          
ATOM    963  CE2 TYR   141      16.681  10.515   8.653  1.00 10.95          
ATOM    964  CZ  TYR   141      16.636  11.530   7.839  1.00  9.36          
ATOM    965  OH  TYR   141      15.508  11.704   7.102  1.00 11.32          
ATOM    966  N   THR   142      19.080  13.668  11.475  1.00 17.87          
ATOM    967  CA  THR   142      18.778  14.980  11.145  1.00 17.85          
ATOM    968  C   THR   142      19.725  15.996  11.819  1.00 18.00          
ATOM    969  O   THR   142      19.997  17.028  11.253  1.00 19.61          
ATOM    970  CB  THR   142      17.254  15.309  11.291  1.00 17.60          
ATOM    971  OG1 THR   142      17.156  16.571  11.939  1.00 19.55          
ATOM    972  CG2 THR   142      16.472  14.397  12.260  1.00 17.10          
ATOM    973  N   LYS   143      20.283  15.767  12.978  1.00 17.42          
ATOM    974  CA  LYS   143      21.132  16.809  13.465  1.00 17.24          
ATOM    975  C   LYS   143      22.517  16.705  12.840  1.00 19.48          
ATOM    976  O   LYS   143      23.206  17.758  12.593  1.00 20.96          
ATOM    977  CB  LYS   143      21.246  16.696  14.945  1.00 18.19          
ATOM    978  CG  LYS   143      22.396  17.366  15.585  1.00 16.62          
ATOM    979  CD  LYS   143      22.112  17.500  17.025  1.00 17.82          
ATOM    980  CE  LYS   143      22.835  18.679  17.624  1.00 18.92          
ATOM    981  NZ  LYS   143      24.242  18.354  17.910  1.00 22.90          
ATOM    982  N   ALA   144      22.971  15.471  12.592  1.00 19.01          
ATOM    983  CA  ALA   144      24.229  15.316  11.921  1.00 18.19          
ATOM    984  C   ALA   144      24.198  15.976  10.551  1.00 18.75          
ATOM    985  O   ALA   144      25.170  16.556  10.065  1.00 20.71          
ATOM    986  CB  ALA   144      24.488  13.935  11.770  1.00 19.18          
ATOM    987  N   ALA   145      23.092  15.850   9.871  1.00 19.25          
ATOM    988  CA  ALA   145      22.936  16.461   8.549  1.00 18.85          
ATOM    989  C   ALA   145      23.077  17.966   8.699  1.00 18.61          
ATOM    990  O   ALA   145      23.931  18.553   7.996  1.00 17.90          
ATOM    991  CB  ALA   145      21.562  16.099   7.967  1.00 18.76          
ATOM    992  N   ALA   146      22.277  18.571   9.619  1.00 17.80          
ATOM    993  CA  ALA   146      22.363  20.043   9.869  1.00 18.04          
ATOM    994  C   ALA   146      23.815  20.449  10.094  1.00 18.51          
ATOM    995  O   ALA   146      24.307  21.417   9.470  1.00 19.27          
ATOM    996  CB  ALA   146      21.499  20.531  10.945  1.00 15.61          
ATOM    997  N   GLU   147      24.533  19.661  10.874  1.00 19.41          
ATOM    998  CA  GLU   147      25.971  19.938  11.053  1.00 21.68          
ATOM    999  C   GLU   147      26.876  19.824   9.829  1.00 20.89          
ATOM   1000  O   GLU   147      27.945  20.313   9.888  1.00 19.85          
ATOM   1001  CB  GLU   147      26.592  19.040  12.132  1.00 23.11          
ATOM   1002  CG  GLU   147      26.536  19.530  13.535  1.00 24.22          
ATOM   1003  CD  GLU   147      26.466  18.358  14.479  1.00 29.86          
ATOM   1004  OE1 GLU   147      25.673  18.527  15.426  1.00 35.07          
ATOM   1005  OE2 GLU   147      27.161  17.287  14.308  1.00 30.64          
ATOM   1006  N   CYS   148      26.483  19.123   8.785  1.00 22.37          
ATOM   1007  CA  CYS   148      27.398  18.832   7.656  1.00 24.38          
ATOM   1008  C   CYS   148      27.021  19.582   6.350  1.00 24.22          
ATOM   1009  O   CYS   148      27.660  19.406   5.319  1.00 25.63          
ATOM   1010  CB  CYS   148      27.470  17.303   7.426  1.00 23.85          
ATOM   1011  SG  CYS   148      28.622  16.453   8.559  1.00 31.79          
ATOM   1012  N   ALA   149      25.935  20.351   6.404  1.00 23.94          
ATOM   1013  CA  ALA   149      25.414  21.093   5.314  1.00 23.23          
ATOM   1014  C   ALA   149      25.914  22.531   5.509  1.00 24.24          
ATOM   1015  O   ALA   149      25.696  23.099   6.579  1.00 24.08          
ATOM   1016  CB  ALA   149      23.941  21.062   5.384  1.00 22.60          
ATOM   1017  N   PRO   150      26.578  23.128   4.483  1.00 25.66          
ATOM   1018  CA  PRO   150      26.808  24.603   4.437  1.00 24.43          
ATOM   1019  C   PRO   150      25.561  25.480   4.339  1.00 23.53          
ATOM   1020  O   PRO   150      25.708  26.683   4.463  1.00 25.61          
ATOM   1021  CB  PRO   150      27.668  24.818   3.170  1.00 22.89          
ATOM   1022  CG  PRO   150      27.554  23.590   2.334  1.00 23.95          
ATOM   1023  CD  PRO   150      27.174  22.475   3.274  1.00 26.29          
ATOM   1024  N   VAL   151      24.372  24.946   4.071  1.00 21.29          
ATOM   1025  CA  VAL   151      23.180  25.795   4.031  1.00 17.99          
ATOM   1026  C   VAL   151      22.162  24.971   4.742  1.00 18.46          
ATOM   1027  O   VAL   151      21.912  23.781   4.361  1.00 19.48          
ATOM   1028  CB  VAL   151      22.657  25.924   2.605  1.00 17.33          
ATOM   1029  CG1 VAL   151      21.255  26.558   2.549  1.00 14.93          
ATOM   1030  CG2 VAL   151      23.588  26.649   1.769  1.00 13.48          
ATOM   1031  N   VAL   152      21.534  25.569   5.736  1.00 16.17          
ATOM   1032  CA  VAL   152      20.536  24.866   6.539  1.00 13.98          
ATOM   1033  C   VAL   152      19.181  25.606   6.532  1.00 14.89          
ATOM   1034  O   VAL   152      19.049  26.764   6.996  1.00 14.57          
ATOM   1035  CB  VAL   152      21.050  24.798   7.996  1.00 12.99          
ATOM   1036  CG1 VAL   152      20.085  24.048   8.889  1.00 12.19          
ATOM   1037  CG2 VAL   152      22.326  24.184   7.987  1.00  9.30          
ATOM   1038  N   VAL   153      18.147  24.953   6.041  1.00 15.48          
ATOM   1039  CA  VAL   153      16.867  25.635   5.989  1.00 17.02          
ATOM   1040  C   VAL   153      15.963  25.140   7.136  1.00 18.29          
ATOM   1041  O   VAL   153      15.552  24.005   7.120  1.00 19.12          
ATOM   1042  CB  VAL   153      16.236  25.348   4.673  1.00 16.72          
ATOM   1043  CG1 VAL   153      14.927  26.090   4.559  1.00 18.64          
ATOM   1044  CG2 VAL   153      17.185  25.738   3.527  1.00 18.16          
ATOM   1045  N   ALA   154      15.638  25.950   8.129  1.00 18.91          
ATOM   1046  CA  ALA   154      14.904  25.394   9.234  1.00 19.52          
ATOM   1047  C   ALA   154      13.489  25.974   9.257  1.00 20.86          
ATOM   1048  O   ALA   154      13.367  27.202   9.222  1.00 22.16          
ATOM   1049  CB  ALA   154      15.557  25.748  10.464  1.00 19.46          
ATOM   1050  N   GLU   155      12.440  25.149   9.350  1.00 19.73          
ATOM   1051  CA  GLU   155      11.142  25.696   9.470  1.00 21.58          
ATOM   1052  C   GLU   155      11.021  25.869  10.919  1.00 19.47          
ATOM   1053  O   GLU   155      11.120  24.947  11.678  1.00 19.01          
ATOM   1054  CB  GLU   155      10.079  24.694   9.039  1.00 22.03          
ATOM   1055  CG  GLU   155       9.993  24.343   7.556  1.00 26.27          
ATOM   1056  CD  GLU   155       8.939  23.210   7.208  1.00 30.22          
ATOM   1057  OE1 GLU   155       8.976  22.709   6.010  1.00 42.45          
ATOM   1058  OE2 GLU   155       8.034  22.804   8.047  1.00 37.34          
ATOM   1059  N   VAL   156      10.796  27.078  11.352  1.00 21.02          
ATOM   1060  CA  VAL   156      10.622  27.332  12.800  1.00 21.50          
ATOM   1061  C   VAL   156       9.167  27.129  13.312  1.00 21.92          
ATOM   1062  O   VAL   156       8.252  27.892  13.008  1.00 21.03          
ATOM   1063  CB  VAL   156      11.225  28.674  13.196  1.00 21.55          
ATOM   1064  CG1 VAL   156      10.880  28.992  14.677  1.00 22.51          
ATOM   1065  CG2 VAL   156      12.727  28.613  12.926  1.00 16.93          
ATOM   1066  N   ASN   157       8.958  26.063  14.060  1.00 22.59          
ATOM   1067  CA  ASN   157       7.625  25.741  14.313  1.00 24.43          
ATOM   1068  C   ASN   157       7.226  26.050  15.753  1.00 26.39          
ATOM   1069  O   ASN   157       7.828  25.550  16.764  1.00 27.35          
ATOM   1070  CB  ASN   157       7.345  24.337  13.894  1.00 24.46          
ATOM   1071  CG  ASN   157       5.874  24.071  13.767  1.00 26.49          
ATOM   1072  OD1 ASN   157       5.034  24.852  14.287  1.00 28.44          
ATOM   1073  ND2 ASN   157       5.526  22.945  13.133  1.00 21.74          
ATOM   1074  N   LYS   158       6.239  26.960  15.825  1.00 27.58          
ATOM   1075  CA  LYS   158       5.632  27.380  17.105  1.00 28.93          
ATOM   1076  C   LYS   158       4.977  26.190  17.819  1.00 28.37          
ATOM   1077  O   LYS   158       4.887  26.195  19.027  1.00 27.48          
ATOM   1078  CB  LYS   158       4.718  28.631  16.978  1.00 28.34          
ATOM   1079  CG  LYS   158       5.611  29.909  17.015  1.00 30.85          
ATOM   1080  CD  LYS   158       4.948  31.311  17.260  1.00 30.90          
ATOM   1081  CE  LYS   158       5.969  32.508  17.006  1.00 31.70          
ATOM   1082  NZ  LYS   158       7.013  32.147  15.925  1.00 35.55          
ATOM   1083  N   GLN   159       4.606  25.151  17.055  1.00 28.17          
ATOM   1084  CA  GLN   159       4.067  23.923  17.606  1.00 27.02          
ATOM   1085  C   GLN   159       5.144  22.846  17.949  1.00 27.08          
ATOM   1086  O   GLN   159       4.848  21.918  18.739  1.00 27.82          
ATOM   1087  CB  GLN   159       3.078  23.313  16.614  1.00 27.34          
ATOM   1088  CG  GLN   159       1.703  22.996  17.150  1.00 27.80          
ATOM   1089  CD  GLN   159       0.772  24.031  16.653  1.00 33.22          
ATOM   1090  OE1 GLN   159      -0.370  23.755  16.203  1.00 33.35          
ATOM   1091  NE2 GLN   159       1.280  25.280  16.653  1.00 36.16          
ATOM   1092  N   MET   160       6.347  22.903  17.353  1.00 25.88          
ATOM   1093  CA  MET   160       7.386  21.845  17.611  1.00 25.34          
ATOM   1094  C   MET   160       7.778  21.930  19.071  1.00 24.46          
ATOM   1095  O   MET   160       8.170  23.003  19.496  1.00 26.22          
ATOM   1096  CB  MET   160       8.668  22.042  16.755  1.00 24.93          
ATOM   1097  CG  MET   160       9.740  20.980  17.040  1.00 24.68          
ATOM   1098  SD  MET   160       9.176  19.242  16.659  1.00 23.44          
ATOM   1099  CE  MET   160       9.043  19.227  14.917  1.00 19.19          
ATOM   1100  N   PRO   161       7.662  20.855  19.841  1.00 23.35          
ATOM   1101  CA  PRO   161       8.119  20.823  21.233  1.00 22.79          
ATOM   1102  C   PRO   161       9.625  21.005  21.437  1.00 22.30          
ATOM   1103  O   PRO   161      10.420  20.714  20.561  1.00 23.57          
ATOM   1104  CB  PRO   161       7.755  19.392  21.686  1.00 21.47          
ATOM   1105  CG  PRO   161       7.524  18.686  20.542  1.00 19.58          
ATOM   1106  CD  PRO   161       7.060  19.573  19.471  1.00 23.05          
ATOM   1107  N   PHE   162       9.990  21.426  22.622  1.00 21.22          
ATOM   1108  CA  PHE   162      11.339  21.685  22.930  1.00 21.01          
ATOM   1109  C   PHE   162      11.746  20.594  23.835  1.00 20.93          
ATOM   1110  O   PHE   162      11.219  20.503  24.944  1.00 21.80          
ATOM   1111  CB  PHE   162      11.466  23.011  23.703  1.00 20.75          
ATOM   1112  CG  PHE   162      12.899  23.533  23.791  1.00 19.93          
ATOM   1113  CD1 PHE   162      13.768  23.102  24.808  1.00 17.51          
ATOM   1114  CD2 PHE   162      13.381  24.433  22.859  1.00 17.17          
ATOM   1115  CE1 PHE   162      15.075  23.556  24.901  1.00 13.11          
ATOM   1116  CE2 PHE   162      14.696  24.890  22.959  1.00 15.14          
ATOM   1117  CZ  PHE   162      15.530  24.434  23.989  1.00 15.27          
ATOM   1118  N   ILE   163      12.751  19.848  23.393  1.00 20.22          
ATOM   1119  CA  ILE   163      13.323  18.717  24.091  1.00 19.54          
ATOM   1120  C   ILE   163      14.853  18.812  24.048  1.00 19.75          
ATOM   1121  O   ILE   163      15.481  19.251  23.033  1.00 21.15          
ATOM   1122  CB  ILE   163      12.900  17.476  23.333  1.00 20.43          
ATOM   1123  CG1 ILE   163      11.399  17.482  23.110  1.00 19.47          
ATOM   1124  CG2 ILE   163      13.442  16.181  23.976  1.00 20.22          
ATOM   1125  CD  ILE   163      11.029  16.242  22.508  1.00 21.66          
ATOM   1126  N   GLY   164      15.469  18.326  25.113  1.00 18.95          
ATOM   1127  CA  GLY   164      16.845  18.694  25.433  1.00 18.83          
ATOM   1128  C   GLY   164      17.693  17.518  25.152  1.00 19.30          
ATOM   1129  O   GLY   164      17.318  16.726  24.310  1.00 20.68          
ATOM   1130  N   GLY   165      18.788  17.359  25.885  1.00 19.83          
ATOM   1131  CA  GLY   165      19.840  16.463  25.462  1.00 21.72          
ATOM   1132  C   GLY   165      20.661  17.128  24.369  1.00 23.35          
ATOM   1133  O   GLY   165      20.704  18.358  24.256  1.00 24.93          
ATOM   1134  N   GLU   166      21.337  16.363  23.538  1.00 24.18          
ATOM   1135  CA  GLU   166      22.208  16.992  22.527  1.00 24.79          
ATOM   1136  C   GLU   166      21.375  17.280  21.318  1.00 24.31          
ATOM   1137  O   GLU   166      21.695  16.791  20.227  1.00 24.49          
ATOM   1138  CB  GLU   166      23.222  16.006  22.049  1.00 24.54          
ATOM   1139  CG  GLU   166      24.643  16.290  22.306  1.00 29.30          
ATOM   1140  CD  GLU   166      25.439  15.463  21.311  1.00 42.20          
ATOM   1141  OE1 GLU   166      25.175  15.546  20.046  1.00 41.81          
ATOM   1142  OE2 GLU   166      26.300  14.676  21.804  1.00 49.52          
ATOM   1143  N   ASN   167      20.326  18.080  21.509  1.00 23.27          
ATOM   1144  CA  ASN   167      19.279  18.257  20.542  1.00 21.97          
ATOM   1145  C   ASN   167      19.091  19.713  20.174  1.00 22.25          
ATOM   1146  O   ASN   167      17.977  20.139  19.849  1.00 25.00          
ATOM   1147  CB  ASN   167      17.979  17.780  21.169  1.00 21.48          
ATOM   1148  CG  ASN   167      17.001  17.363  20.138  1.00 21.78          
ATOM   1149  OD1 ASN   167      17.359  17.264  18.920  1.00 15.30          
ATOM   1150  ND2 ASN   167      15.754  17.147  20.568  1.00 19.59          
ATOM   1151  N   LEU   168      20.129  20.527  20.241  1.00 21.23          
ATOM   1152  CA  LEU   168      19.919  21.962  20.025  1.00 20.24          
ATOM   1153  C   LEU   168      20.632  22.419  18.782  1.00 19.92          
ATOM   1154  O   LEU   168      21.598  21.779  18.361  1.00 17.81          
ATOM   1155  CB  LEU   168      20.424  22.773  21.203  1.00 19.14          
ATOM   1156  CG  LEU   168      19.503  22.952  22.392  1.00 20.97          
ATOM   1157  CD1 LEU   168      18.606  21.740  22.630  1.00 16.95          
ATOM   1158  CD2 LEU   168      20.358  23.340  23.631  1.00 19.33          
ATOM   1159  N   ILE   169      20.183  23.553  18.242  1.00 20.20          
ATOM   1160  CA  ILE   169      20.900  24.196  17.166  1.00 21.27          
ATOM   1161  C   ILE   169      20.722  25.707  17.250  1.00 22.49          
ATOM   1162  O   ILE   169      19.613  26.255  17.411  1.00 23.19          
ATOM   1163  CB  ILE   169      20.421  23.586  15.830  1.00 21.73          
ATOM   1164  CG1 ILE   169      21.413  23.792  14.690  1.00 19.61          
ATOM   1165  CG2 ILE   169      18.925  24.009  15.476  1.00 23.60          
ATOM   1166  CD  ILE   169      21.421  25.127  14.212  1.00 22.53          
ATOM   1167  N   HSD   170      21.819  26.411  17.198  1.00 24.09          
ATOM   1168  CA  HSD   170      21.703  27.841  17.402  1.00 25.34          
ATOM   1169  C   HSD   170      21.152  28.538  16.170  1.00 25.98          
ATOM   1170  O   HSD   170      21.343  28.069  15.017  1.00 25.67          
ATOM   1171  CB  HSD   170      23.026  28.463  17.804  1.00 25.01          
ATOM   1172  CG  HSD   170      22.896  29.896  18.196  1.00 26.77          
ATOM   1173  ND1 HSD   170      22.530  30.292  19.466  1.00 28.68          
ATOM   1174  CD2 HSD   170      23.069  31.034  17.483  1.00 27.59          
ATOM   1175  CE1 HSD   170      22.492  31.611  19.518  1.00 26.52          
ATOM   1176  NE2 HSD   170      22.819  32.082  18.327  1.00 28.10          
ATOM   1177  N   ILE   171      20.485  29.674  16.440  1.00 25.94          
ATOM   1178  CA  ILE   171      19.861  30.502  15.397  1.00 25.57          
ATOM   1179  C   ILE   171      20.873  30.953  14.363  1.00 24.91          
ATOM   1180  O   ILE   171      20.562  31.022  13.200  1.00 24.88          
ATOM   1181  CB  ILE   171      18.923  31.654  16.007  1.00 25.97          
ATOM   1182  CG1 ILE   171      17.767  31.873  15.093  1.00 26.98          
ATOM   1183  CG2 ILE   171      19.541  33.035  16.219  1.00 27.16          
ATOM   1184  CD  ILE   171      16.891  30.707  15.149  1.00 32.18          
ATOM   1185  N   SER   172      22.105  31.202  14.791  1.00 24.61          
ATOM   1186  CA  SER   172      23.091  31.642  13.864  1.00 25.07          
ATOM   1187  C   SER   172      23.529  30.580  12.843  1.00 24.49          
ATOM   1188  O   SER   172      24.073  30.947  11.846  1.00 25.60          
ATOM   1189  CB  SER   172      24.212  32.523  14.520  1.00 26.28          
ATOM   1190  OG  SER   172      25.013  31.895  15.544  1.00 30.35          
ATOM   1191  N   LYS   173      23.195  29.297  13.012  1.00 23.99          
ATOM   1192  CA  LYS   173      23.615  28.229  12.029  1.00 23.35          
ATOM   1193  C   LYS   173      22.552  27.988  10.940  1.00 22.52          
ATOM   1194  O   LYS   173      22.690  27.140  10.007  1.00 23.10          
ATOM   1195  CB  LYS   173      24.044  26.900  12.756  1.00 22.36          
ATOM   1196  CG  LYS   173      25.030  27.120  13.971  1.00 22.97          
ATOM   1197  CD  LYS   173      26.385  27.955  13.580  1.00 20.95          
ATOM   1198  CE  LYS   173      27.133  28.515  14.803  1.00 25.64          
ATOM   1199  NZ  LYS   173      27.243  27.701  16.215  1.00 24.64          
ATOM   1200  N   LEU   174      21.485  28.752  11.073  1.00 21.22          
ATOM   1201  CA  LEU   174      20.372  28.700  10.153  1.00 20.49          
ATOM   1202  C   LEU   174      20.497  29.769   9.082  1.00 21.14          
ATOM   1203  O   LEU   174      20.691  30.910   9.380  1.00 21.36          
ATOM   1204  CB  LEU   174      19.072  28.899  10.942  1.00 20.44          
ATOM   1205  CG  LEU   174      18.450  27.694  11.686  1.00 16.86          
ATOM   1206  CD1 LEU   174      19.454  26.826  12.254  1.00 12.70          
ATOM   1207  CD2 LEU   174      17.457  28.134  12.773  1.00 17.70          
ATOM   1208  N   THR   175      20.439  29.370   7.828  1.00 22.22          
ATOM   1209  CA  THR   175      20.588  30.291   6.696  1.00 23.00          
ATOM   1210  C   THR   175      19.296  30.977   6.334  1.00 23.14          
ATOM   1211  O   THR   175      19.315  32.146   6.000  1.00 23.72          
ATOM   1212  CB  THR   175      20.965  29.494   5.460  1.00 22.65          
ATOM   1213  OG1 THR   175      22.027  28.627   5.802  1.00 25.26          
ATOM   1214  CG2 THR   175      21.563  30.342   4.418  1.00 21.90          
ATOM   1215  N   HSD   176      18.207  30.206   6.277  1.00 23.01          
ATOM   1216  CA  HSD   176      16.901  30.717   5.951  1.00 23.07          
ATOM   1217  C   HSD   176      15.949  30.152   7.005  1.00 22.90          
ATOM   1218  O   HSD   176      16.045  28.948   7.373  1.00 24.29          
ATOM   1219  CB  HSD   176      16.463  30.309   4.538  1.00 23.81          
ATOM   1220  CG  HSD   176      17.498  30.546   3.468  1.00 27.13          
ATOM   1221  ND1 HSD   176      18.397  29.570   3.062  1.00 29.55          
ATOM   1222  CD2 HSD   176      17.748  31.633   2.696  1.00 30.13          
ATOM   1223  CE1 HSD   176      19.177  30.059   2.116  1.00 30.17          
ATOM   1224  NE2 HSD   176      18.802  31.306   1.865  1.00 30.24          
ATOM   1225  N   ILE   177      15.072  31.011   7.539  1.00 20.90          
ATOM   1226  CA  ILE   177      14.152  30.558   8.564  1.00 18.66          
ATOM   1227  C   ILE   177      12.799  30.796   8.018  1.00 18.39          
ATOM   1228  O   ILE   177      12.513  31.881   7.551  1.00 18.22          
ATOM   1229  CB  ILE   177      14.319  31.412   9.857  1.00 19.00          
ATOM   1230  CG1 ILE   177      15.601  31.074  10.553  1.00 11.91          
ATOM   1231  CG2 ILE   177      13.120  31.248  10.874  1.00 18.55          
ATOM   1232  CD  ILE   177      15.889  32.145  11.418  1.00  9.72          
ATOM   1233  N   ILE   178      11.955  29.802   8.127  1.00 17.81          
ATOM   1234  CA  ILE   178      10.629  29.888   7.596  1.00 18.74          
ATOM   1235  C   ILE   178       9.738  29.767   8.810  1.00 21.69          
ATOM   1236  O   ILE   178       9.369  28.658   9.196  1.00 22.13          
ATOM   1237  CB  ILE   178      10.413  28.731   6.690  1.00 16.83          
ATOM   1238  CG1 ILE   178      11.358  28.877   5.529  1.00 17.27          
ATOM   1239  CG2 ILE   178       9.081  28.753   6.119  1.00 14.64          
ATOM   1240  CD  ILE   178      11.772  27.572   4.860  1.00 14.06          
ATOM   1241  N   GLU   179       9.410  30.894   9.457  1.00 24.72          
ATOM   1242  CA  GLU   179       8.565  30.779  10.664  1.00 26.88          
ATOM   1243  C   GLU   179       7.234  30.195  10.334  1.00 27.60          
ATOM   1244  O   GLU   179       6.545  30.728   9.514  1.00 29.85          
ATOM   1245  CB  GLU   179       8.336  32.048  11.494  1.00 25.33          
ATOM   1246  CG  GLU   179       8.683  33.362  10.939  1.00 28.80          
ATOM   1247  CD  GLU   179       9.133  34.214  12.103  1.00 35.59          
ATOM   1248  OE1 GLU   179       9.453  35.411  11.932  1.00 38.57          
ATOM   1249  OE2 GLU   179       9.144  33.661  13.224  1.00 34.98          
ATOM   1250  N   VAL   180       6.877  29.088  10.968  1.00 27.94          
ATOM   1251  CA  VAL   180       5.534  28.673  10.877  1.00 27.56          
ATOM   1252  C   VAL   180       4.913  28.191  12.117  1.00 27.81          
ATOM   1253  O   VAL   180       5.498  28.167  13.195  1.00 28.02          
ATOM   1254  CB  VAL   180       5.310  27.684   9.732  1.00 28.96          
ATOM   1255  CG1 VAL   180       5.174  28.527   8.383  1.00 30.60          
ATOM   1256  CG2 VAL   180       6.355  26.550   9.669  1.00 23.93          
ATOM   1257  N   ASP   181       3.656  27.896  11.911  1.00 28.30          
ATOM   1258  CA  ASP   181       2.774  27.396  12.894  1.00 29.52          
ATOM   1259  C   ASP   181       1.719  26.369  12.341  1.00 29.88          
ATOM   1260  O   ASP   181       0.933  26.655  11.380  1.00 31.11          
ATOM   1261  CB  ASP   181       2.120  28.540  13.605  1.00 29.39          
ATOM   1262  CG  ASP   181       1.391  28.053  14.781  1.00 32.09          
ATOM   1263  OD1 ASP   181       1.249  26.810  14.853  1.00 34.95          
ATOM   1264  OD2 ASP   181       0.933  28.775  15.675  1.00 35.01          
ATOM   1265  N   GLU   182       1.789  25.156  12.892  1.00 28.51          
ATOM   1266  CA  GLU   182       1.183  23.977  12.278  1.00 29.19          
ATOM   1267  C   GLU   182       1.492  22.736  13.147  1.00 27.43          
ATOM   1268  O   GLU   182       2.642  22.505  13.516  1.00 27.31          
ATOM   1269  CB  GLU   182       1.558  23.810  10.777  1.00 28.20          
ATOM   1270  CG  GLU   182       0.527  24.373   9.773  1.00 33.60          
ATOM   1271  CD  GLU   182       0.011  23.352   8.639  1.00 41.70          
ATOM   1272  OE1 GLU   182       0.791  22.459   8.057  1.00 40.51          
ATOM   1273  OE2 GLU   182      -1.234  23.467   8.265  1.00 47.22          
ATOM   1274  N   PRO   183       0.451  21.953  13.468  1.00 26.93          
ATOM   1275  CA  PRO   183       0.538  20.853  14.453  1.00 26.06          
ATOM   1276  C   PRO   183       1.398  19.678  13.954  1.00 26.46          
ATOM   1277  O   PRO   183       1.364  19.291  12.785  1.00 27.59          
ATOM   1278  CB  PRO   183      -0.904  20.390  14.576  1.00 26.28          
ATOM   1279  CG  PRO   183      -1.541  20.716  13.225  1.00 25.49          
ATOM   1280  CD  PRO   183      -0.893  22.019  12.835  1.00 26.25          
ATOM   1281  N   ILE   184       2.185  19.095  14.837  1.00 25.25          
ATOM   1282  CA  ILE   184       3.166  18.158  14.439  1.00 21.69          
ATOM   1283  C   ILE   184       2.447  16.897  14.044  1.00 21.73          
ATOM   1284  O   ILE   184       1.793  16.339  14.840  1.00 21.82          
ATOM   1285  CB  ILE   184       4.037  18.037  15.644  1.00 20.69          
ATOM   1286  CG1 ILE   184       4.833  19.343  15.748  1.00 17.79          
ATOM   1287  CG2 ILE   184       4.862  16.748  15.620  1.00 21.71          
ATOM   1288  CD  ILE   184       6.123  19.386  14.936  1.00  8.23          
ATOM   1289  N   ALA   185       2.534  16.464  12.797  1.00 22.39          
ATOM   1290  CA  ALA   185       1.879  15.219  12.385  1.00 23.14          
ATOM   1291  C   ALA   185       1.835  14.233  13.486  1.00 23.75          
ATOM   1292  O   ALA   185       2.816  14.061  14.220  1.00 21.62          
ATOM   1293  CB  ALA   185       2.632  14.564  11.264  1.00 23.84          
ATOM   1294  N   GLU   186       0.713  13.544  13.570  1.00 25.90          
ATOM   1295  CA  GLU   186       0.520  12.574  14.673  1.00 29.21          
ATOM   1296  C   GLU   186       0.348  11.172  14.153  1.00 28.23          
ATOM   1297  O   GLU   186      -0.203  11.027  13.115  1.00 28.76          
ATOM   1298  CB  GLU   186      -0.662  12.992  15.595  1.00 29.75          
ATOM   1299  CG  GLU   186      -1.960  13.486  14.933  1.00 31.19          
ATOM   1300  CD  GLU   186      -2.910  14.152  15.940  1.00 32.80          
ATOM   1301  OE1 GLU   186      -3.557  15.151  15.525  1.00 39.05          
ATOM   1302  OE2 GLU   186      -3.015  13.716  17.158  1.00 36.29          
END
