
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  200 ( 1506),  selected  200 , name 3cdk_D
# Molecule2: number of CA atoms  222 ( 1716),  selected  222 , name T0438_187_430.pdb
# PARAMETERS: 3cdk_D.T0438_187_430.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      V     187           -
LGA    -       -      L     188           -
LGA    -       -      P     189           -
LGA    -       -      G     192           -
LGA    K     2_D      S     193           #
LGA    E     3_D      D     194          2.393
LGA    A     4_D      L     195          2.185
LGA    R     5_D      E     196          1.993
LGA    K     6_D      L     197          2.245
LGA    R     7_D      R     198          1.576
LGA    M     8_D      I     199          1.445
LGA    V     9_D      G     200          1.282
LGA    K    10_D      Q     201          1.681
LGA    R    11_D      N     202          1.645
LGA    A    12_D      C     203          1.811
LGA    V    13_D      A     204          1.971
LGA    Q    14_D      S     205          1.955
LGA    E    15_D      L     206          1.633
LGA    I    16_D      I     207          1.138
LGA    K    17_D      K     208          0.504
LGA    D    18_D      D     209          1.262
LGA    G    19_D      G     210          1.152
LGA    M    20_D      D     211          0.688
LGA    N    21_D      T     212          0.764
LGA    V    22_D      L     213          0.582
LGA    N    23_D      Q     214          0.460
LGA    L    24_D      L     215          0.784
LGA    G    25_D      G     216          2.041
LGA    I    26_D      I     217          2.955
LGA    G    27_D      G     218          2.370
LGA    M    28_D      G     219          3.232
LGA    P    29_D      I     220          3.037
LGA    T    30_D      P     221          1.606
LGA    L    31_D      D     222          0.997
LGA    V    32_D      A     223          3.441
LGA    -       -      V     224           -
LGA    A    33_D      L     225          1.775
LGA    N    34_D      R     226          2.899
LGA    E    35_D      A     227          3.049
LGA    I    36_D      L     228          1.728
LGA    P    37_D      E     229          2.522
LGA    D    38_D      G     230          4.225
LGA    G    39_D      X     231          3.992
LGA    V    40_D      K     232          1.889
LGA    H    41_D      D     233          1.294
LGA    V    42_D      L     234          0.470
LGA    M    43_D      G     235          1.085
LGA    L    44_D      I     236          2.308
LGA    Q    45_D      X     237          2.360
LGA    S    46_D      T     238          2.859
LGA    E    47_D      E     239          1.084
LGA    N    48_D      M     240          4.704
LGA    G    49_D      F     241           -
LGA    L    50_D      T     242           -
LGA    L    51_D      D     243           -
LGA    G    52_D      G     244           -
LGA    I    53_D      V     245          3.770
LGA    G    54_D      M     246          2.462
LGA    P    55_D      R     247          1.922
LGA    Y    56_D      M     248           -
LGA    P    57_D      I     249           -
LGA    L    58_D      R     250           -
LGA    E    59_D      K     251           -
LGA    G    60_D      G     252           -
LGA    T    61_D      I     253           -
LGA    E    62_D      I     254           -
LGA    D    63_D      N     255           -
LGA    A    64_D      G     256           -
LGA    D    65_D      K     257           -
LGA    -       -      K     258           -
LGA    -       -      K     259           -
LGA    -       -      T     260           -
LGA    -       -      L     261           -
LGA    -       -      X     262           -
LGA    -       -      P     263           -
LGA    -       -      E     264           -
LGA    -       -      K     265           -
LGA    -       -      V     266           -
LGA    -       -      V     267           -
LGA    -       -      T     268           -
LGA    -       -      S     269           -
LGA    -       -      L     270           -
LGA    L    66_D      I     271          5.218
LGA    I    67_D      F     272          3.112
LGA    N    68_D      -       -           -
LGA    A    69_D      -       -           -
LGA    G    70_D      -       -           -
LGA    K    71_D      G     273          5.114
LGA    E    72_D      S     274           #
LGA    T    73_D      K     275           #
LGA    -       -      E     276           -
LGA    I    74_D      L     277          3.074
LGA    T    75_D      Y     278           #
LGA    -       -      D     279           -
LGA    -       -      F     280           -
LGA    -       -      V     281           -
LGA    -       -      N     282           -
LGA    -       -      N     283           -
LGA    E    76_D      N     284           #
LGA    V    77_D      -       -           -
LGA    T    78_D      -       -           -
LGA    G    79_D      P     285           #
LGA    A    80_D      V     286          3.167
LGA    S    81_D      I     287          4.316
LGA    Y    82_D      E     288          1.365
LGA    F    83_D      C     289          3.539
LGA    D    84_D      Y     290          1.508
LGA    S    85_D      P     291          1.299
LGA    -       -      V     292           -
LGA    A    86_D      D     293          2.546
LGA    E    87_D      Y     294          2.634
LGA    S    88_D      I     295          1.003
LGA    F    89_D      N     296          1.804
LGA    A    90_D      N     297          3.082
LGA    M    91_D      -       -           -
LGA    I    92_D      P     298          4.041
LGA    R    93_D      D     299          4.320
LGA    G    94_D      V     300          4.025
LGA    -       -      I     301           -
LGA    G    95_D      G     302          2.105
LGA    H    96_D      K     303          3.582
LGA    -       -      N     304           -
LGA    I    97_D      D     305           #
LGA    -       -      R     306           -
LGA    D    98_D      M     307          1.089
LGA    L    99_D      V     308          0.837
LGA    A   100_D      S     309          0.916
LGA    I   101_D      I     310          1.014
LGA    L   102_D      N     311          1.451
LGA    G   103_D      S     312          1.528
LGA    G   104_D      C     313          1.879
LGA    M   105_D      L     314          1.294
LGA    E   106_D      E     315          0.894
LGA    V   107_D      M     316          1.478
LGA    S   108_D      D     317          1.603
LGA    E   109_D      L     318          2.142
LGA    Q   110_D      M     319          2.269
LGA    G   111_D      G     320          1.299
LGA    D   112_D      Q     321          1.274
LGA    L   113_D      A     322          1.850
LGA    A   114_D      -       -           -
LGA    N   115_D      -       -           -
LGA    W   116_D      -       -           -
LGA    M   117_D      -       -           -
LGA    I   118_D      -       -           -
LGA    P   119_D      -       -           -
LGA    G   120_D      -       -           -
LGA    M   122_D      -       -           -
LGA    V   123_D      -       -           -
LGA    K   124_D      -       -           -
LGA    G   125_D      -       -           -
LGA    M   126_D      -       -           -
LGA    G   127_D      -       -           -
LGA    G   128_D      G     337          1.315
LGA    A   129_D      Q     338          0.919
LGA    M   130_D      V     339          1.932
LGA    D   131_D      D     340          0.786
LGA    L   132_D      F     341          1.456
LGA    V   133_D      L     342          2.160
LGA    N   134_D      R     343          2.132
LGA    G   135_D      G     344          1.715
LGA    A   136_D      A     345          1.353
LGA    K   137_D      K     346          2.611
LGA    -       -      R     347           -
LGA    -       -      S     348           -
LGA    -       -      K     349           -
LGA    -       -      G     350           -
LGA    -       -      G     351           -
LGA    R   138_D      I     352          1.313
LGA    I   139_D      S     353          1.602
LGA    V   140_D      I     354          0.928
LGA    V   141_D      M     355          1.724
LGA    I   142_D      A     356          1.680
LGA    M   143_D      F     357          1.071
LGA    E   144_D      P     358          1.233
LGA    H   145_D      S     359          0.956
LGA    V   146_D      T     360          1.970
LGA    N   147_D      A     361          2.104
LGA    -       -      K     362           -
LGA    -       -      K     363           -
LGA    -       -      G     364           -
LGA    -       -      T     365           -
LGA    -       -      E     366           -
LGA    S   152_D      S     367          1.188
LGA    K   153_D      R     368          1.281
LGA    V   154_D      I     369          0.933
LGA    K   155_D      V     370          1.555
LGA    K   156_D      P     371          1.794
LGA    T   157_D      I     372          2.608
LGA    C   158_D      L     373          1.889
LGA    S   159_D      K     374          1.335
LGA    L   160_D      -       -           -
LGA    P   161_D      -       -           -
LGA    L   162_D      -       -           -
LGA    T   163_D      T     381           #
LGA    G   164_D      G     382           #
LGA    Q   165_D      R     383          4.283
LGA    K   166_D      N     384          3.560
LGA    V   167_D      E     385          1.790
LGA    V   168_D      V     386          1.913
LGA    H   169_D      D     387          1.451
LGA    R   170_D      Y     388          1.357
LGA    L   171_D      V     389          1.232
LGA    I   172_D      V     390          1.391
LGA    T   173_D      T     391          1.239
LGA    D   174_D      E     392          2.129
LGA    L   175_D      Y     393          2.471
LGA    A   176_D      G     394          3.149
LGA    V   177_D      V     395          2.274
LGA    F   178_D      A     396          1.681
LGA    D   179_D      R     397          1.681
LGA    F   180_D      L     398          1.269
LGA    V   181_D      R     399          3.563
LGA    -       -      G     400           -
LGA    N   182_D      A     401          4.351
LGA    G   183_D      T     402          5.027
LGA    R   184_D      L     403          3.136
LGA    -       -      R     404           -
LGA    -       -      Q     405           -
LGA    M   185_D      R     406          0.907
LGA    -       -      A     407           -
LGA    -       -      E     408           -
LGA    T   186_D      A     409          2.219
LGA    -       -      L     410           -
LGA    -       -      T     411           -
LGA    L   187_D      A     412          4.790
LGA    T   188_D      -       -           -
LGA    E   189_D      -       -           -
LGA    L   190_D      I     413           #
LGA    T   195_D      A     414           -
LGA    I   196_D      X     415           -
LGA    E   197_D      -       -           -
LGA    E   198_D      -       -           -
LGA    V   199_D      P     416          4.554
LGA    Y   200_D      -       -           -
LGA    E   201_D      D     417           #
LGA    K   202_D      F     418          1.641
LGA    T   203_D      R     419          3.734
LGA    E   204_D      P     420           -
LGA    -       -      A     421           -
LGA    A   205_D      L     422          4.830
LGA    -       -      E     423           -
LGA    -       -      E     424           -
LGA    -       -      E     425           -
LGA    D   206_D      I     426          3.980
LGA    F   207_D      R     427           #
LGA    A   208_D      R     428           -
LGA    V   209_D      R     429           -
LGA    S   210_D      F     430           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  200  222    5.0    141    2.41    16.31     43.606     5.618

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.485464 * X  +  -0.535868 * Y  +   0.690775 * Z  +  67.338181
  Y_new =   0.261450 * X  +  -0.664982 * Y  +  -0.699602 * Z  +   9.897021
  Z_new =   0.834247 * X  +   0.520235 * Y  +  -0.182722 * Z  +  37.539032 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.908567   -1.233026  [ DEG:   109.3528    -70.6472 ]
  Theta =  -0.986766   -2.154826  [ DEG:   -56.5375   -123.4625 ]
  Phi   =   0.494015   -2.647577  [ DEG:    28.3050   -151.6950 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cdk_D                                        
REMARK     2: T0438_187_430.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cdk_D.T0438_187_430.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  200  222   5.0  141   2.41   16.31  43.606
REMARK  ---------------------------------------------------------- 
MOLECULE 3cdk_D
HEADER    TRANSFERASE                             27-FEB-08   3CDK              
TITLE     CRYSTAL STRUCTURE OF THE CO-EXPRESSED SUCCINYL-COA                    
TITLE    2 TRANSFERASE A AND B COMPLEX FROM BACILLUS SUBTILIS                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SUCCINYL-COA:3-KETOACID-COENZYME A TRANSFERASE             
COMPND   3 SUBUNIT A;                                                           
COMPND   4 CHAIN: A, C;                                                         
COMPND   5 SYNONYM: SUCCINYL COA:3-OXOACID COA-TRANSFERASE, OXCT A;             
COMPND   6 EC: 2.8.3.5;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: SUCCINYL-COA:3-KETOACID-COENZYME A TRANSFERASE             
COMPND  10 SUBUNIT B;                                                           
COMPND  11 CHAIN: B, D;                                                         
COMPND  12 SYNONYM: SUCCINYL COA:3-OXOACID COA-TRANSFERASE, OXCT B;             
COMPND  13 EC: 2.8.3.5;                                                         
COMPND  14 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: SCOA, YXJD, BSU38990, N15K;                                    
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG17;                                  
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 STRAIN: 168;                                                         
SOURCE  14 GENE: SCOB, YXJE, BSU38980, N15L;                                    
SOURCE  15 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PMCSG21                                   
KEYWDS    CO-EXPRESSED COMPLEX, HETERO-TETRAMER, STRUCTURAL GENOMICS,           
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR              
KEYWDS   3 STRUCTURAL GENOMICS, MCSG, TRANSFERASE                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,M.ZHOU,L.STOLS,W.ESCHENFELDT,M.DONNELLY,A.JOACHIMIAK,           
AUTHOR   2 MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)                        
REVDAT   1   18-MAR-08 3CDK    0                                                
JRNL        AUTH   Y.KIM,M.ZHOU,L.STOLS,W.ESCHENFELDT,M.DONNELLY,               
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   CRYSTAL STRUCTURE OF THE CO-EXPRESSED SUCCINYL-COA           
JRNL        TITL 2 TRANSFERASE A AND B COMPLEX FROM BACILLUS SUBTILIS.          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.59 ANGSTROMS.                                          
DBREF  3CDK A    3   240  UNP    P42315   SCOA_BACSU       1    238             
DBREF  3CDK B    1   216  UNP    P42316   SCOB_BACSU       1    216             
DBREF  3CDK C    3   240  UNP    P42315   SCOA_BACSU       1    238             
DBREF  3CDK D    1   216  UNP    P42316   SCOB_BACSU       1    216             
SEQRES   1 A  241  SER ASN ALA MET GLY LYS VAL LEU SER SER SER LYS GLU          
SEQRES   2 A  241  ALA ALA LYS LEU ILE HIS ASP GLY ASP THR LEU ILE ALA          
SEQRES   3 A  241  GLY GLY PHE GLY LEU CYS GLY ILE PRO GLU GLN LEU ILE          
SEQRES   4 A  241  LEU SER ILE ARG ASP GLN GLY VAL LYS ASP LEU THR VAL          
SEQRES   5 A  241  VAL SER ASN ASN CYS GLY VAL ASP ASP TRP GLY LEU GLY          
SEQRES   6 A  241  LEU LEU LEU ALA ASN LYS GLN ILE LYS LYS MET ILE ALA          
SEQRES   7 A  241  SER TYR VAL GLY GLU ASN LYS ILE PHE GLU ARG GLN PHE          
SEQRES   8 A  241  LEU SER GLY GLU LEU GLU VAL GLU LEU VAL PRO GLN GLY          
SEQRES   9 A  241  THR LEU ALA GLU ARG ILE ARG ALA GLY GLY ALA GLY ILE          
SEQRES  10 A  241  PRO GLY PHE TYR THR ALA THR GLY VAL GLY THR SER ILE          
SEQRES  11 A  241  ALA GLU GLY LYS GLU HIS LYS THR PHE GLY GLY ARG THR          
SEQRES  12 A  241  TYR VAL LEU GLU ARG GLY ILE THR GLY ASP VAL ALA ILE          
SEQRES  13 A  241  VAL LYS ALA TRP LYS ALA ASP THR MET GLY ASN LEU ILE          
SEQRES  14 A  241  PHE ARG LYS THR ALA ARG ASN PHE ASN PRO ILE ALA ALA          
SEQRES  15 A  241  MET ALA GLY LYS ILE THR ILE ALA GLU ALA GLU GLU ILE          
SEQRES  16 A  241  VAL GLU ALA GLY GLU LEU ASP PRO ASP HIS ILE HIS THR          
SEQRES  17 A  241  PRO GLY ILE TYR VAL GLN HIS VAL VAL LEU GLY ALA SER          
SEQRES  18 A  241  GLN GLU LYS ARG ILE GLU LYS ARG THR VAL GLN GLN ALA          
SEQRES  19 A  241  SER GLY LYS GLY GLU ALA LYS                                  
SEQRES   1 B  219  SER ASN ALA MET LYS GLU ALA ARG LYS ARG MET VAL LYS          
SEQRES   2 B  219  ARG ALA VAL GLN GLU ILE LYS ASP GLY MET ASN VAL ASN          
SEQRES   3 B  219  LEU GLY ILE GLY MET PRO THR LEU VAL ALA ASN GLU ILE          
SEQRES   4 B  219  PRO ASP GLY VAL HIS VAL MET LEU GLN SER GLU ASN GLY          
SEQRES   5 B  219  LEU LEU GLY ILE GLY PRO TYR PRO LEU GLU GLY THR GLU          
SEQRES   6 B  219  ASP ALA ASP LEU ILE ASN ALA GLY LYS GLU THR ILE THR          
SEQRES   7 B  219  GLU VAL THR GLY ALA SER TYR PHE ASP SER ALA GLU SER          
SEQRES   8 B  219  PHE ALA MET ILE ARG GLY GLY HIS ILE ASP LEU ALA ILE          
SEQRES   9 B  219  LEU GLY GLY MET GLU VAL SER GLU GLN GLY ASP LEU ALA          
SEQRES  10 B  219  ASN TRP MET ILE PRO GLY LYS MET VAL LYS GLY MET GLY          
SEQRES  11 B  219  GLY ALA MET ASP LEU VAL ASN GLY ALA LYS ARG ILE VAL          
SEQRES  12 B  219  VAL ILE MET GLU HIS VAL ASN LYS HIS GLY GLU SER LYS          
SEQRES  13 B  219  VAL LYS LYS THR CYS SER LEU PRO LEU THR GLY GLN LYS          
SEQRES  14 B  219  VAL VAL HIS ARG LEU ILE THR ASP LEU ALA VAL PHE ASP          
SEQRES  15 B  219  PHE VAL ASN GLY ARG MET THR LEU THR GLU LEU GLN ASP          
SEQRES  16 B  219  GLY VAL THR ILE GLU GLU VAL TYR GLU LYS THR GLU ALA          
SEQRES  17 B  219  ASP PHE ALA VAL SER GLN SER VAL LEU ASN SER                  
SEQRES   1 C  241  SER ASN ALA MET GLY LYS VAL LEU SER SER SER LYS GLU          
SEQRES   2 C  241  ALA ALA LYS LEU ILE HIS ASP GLY ASP THR LEU ILE ALA          
SEQRES   3 C  241  GLY GLY PHE GLY LEU CYS GLY ILE PRO GLU GLN LEU ILE          
SEQRES   4 C  241  LEU SER ILE ARG ASP GLN GLY VAL LYS ASP LEU THR VAL          
SEQRES   5 C  241  VAL SER ASN ASN CYS GLY VAL ASP ASP TRP GLY LEU GLY          
SEQRES   6 C  241  LEU LEU LEU ALA ASN LYS GLN ILE LYS LYS MET ILE ALA          
SEQRES   7 C  241  SER TYR VAL GLY GLU ASN LYS ILE PHE GLU ARG GLN PHE          
SEQRES   8 C  241  LEU SER GLY GLU LEU GLU VAL GLU LEU VAL PRO GLN GLY          
SEQRES   9 C  241  THR LEU ALA GLU ARG ILE ARG ALA GLY GLY ALA GLY ILE          
SEQRES  10 C  241  PRO GLY PHE TYR THR ALA THR GLY VAL GLY THR SER ILE          
SEQRES  11 C  241  ALA GLU GLY LYS GLU HIS LYS THR PHE GLY GLY ARG THR          
SEQRES  12 C  241  TYR VAL LEU GLU ARG GLY ILE THR GLY ASP VAL ALA ILE          
SEQRES  13 C  241  VAL LYS ALA TRP LYS ALA ASP THR MET GLY ASN LEU ILE          
SEQRES  14 C  241  PHE ARG LYS THR ALA ARG ASN PHE ASN PRO ILE ALA ALA          
SEQRES  15 C  241  MET ALA GLY LYS ILE THR ILE ALA GLU ALA GLU GLU ILE          
SEQRES  16 C  241  VAL GLU ALA GLY GLU LEU ASP PRO ASP HIS ILE HIS THR          
SEQRES  17 C  241  PRO GLY ILE TYR VAL GLN HIS VAL VAL LEU GLY ALA SER          
SEQRES  18 C  241  GLN GLU LYS ARG ILE GLU LYS ARG THR VAL GLN GLN ALA          
SEQRES  19 C  241  SER GLY LYS GLY GLU ALA LYS                                  
SEQRES   1 D  219  SER ASN ALA MET LYS GLU ALA ARG LYS ARG MET VAL LYS          
SEQRES   2 D  219  ARG ALA VAL GLN GLU ILE LYS ASP GLY MET ASN VAL ASN          
SEQRES   3 D  219  LEU GLY ILE GLY MET PRO THR LEU VAL ALA ASN GLU ILE          
SEQRES   4 D  219  PRO ASP GLY VAL HIS VAL MET LEU GLN SER GLU ASN GLY          
SEQRES   5 D  219  LEU LEU GLY ILE GLY PRO TYR PRO LEU GLU GLY THR GLU          
SEQRES   6 D  219  ASP ALA ASP LEU ILE ASN ALA GLY LYS GLU THR ILE THR          
SEQRES   7 D  219  GLU VAL THR GLY ALA SER TYR PHE ASP SER ALA GLU SER          
SEQRES   8 D  219  PHE ALA MET ILE ARG GLY GLY HIS ILE ASP LEU ALA ILE          
SEQRES   9 D  219  LEU GLY GLY MET GLU VAL SER GLU GLN GLY ASP LEU ALA          
SEQRES  10 D  219  ASN TRP MET ILE PRO GLY LYS MET VAL LYS GLY MET GLY          
SEQRES  11 D  219  GLY ALA MET ASP LEU VAL ASN GLY ALA LYS ARG ILE VAL          
SEQRES  12 D  219  VAL ILE MET GLU HIS VAL ASN LYS HIS GLY GLU SER LYS          
SEQRES  13 D  219  VAL LYS LYS THR CYS SER LEU PRO LEU THR GLY GLN LYS          
SEQRES  14 D  219  VAL VAL HIS ARG LEU ILE THR ASP LEU ALA VAL PHE ASP          
SEQRES  15 D  219  PHE VAL ASN GLY ARG MET THR LEU THR GLU LEU GLN ASP          
SEQRES  16 D  219  GLY VAL THR ILE GLU GLU VAL TYR GLU LYS THR GLU ALA          
SEQRES  17 D  219  ASP PHE ALA VAL SER GLN SER VAL LEU ASN SER                  
FORMUL   5  HOH   *115(H2 O)                                                    
CRYST1   69.337   70.404   97.996  90.00 106.31  90.00 P 1 2 1       4          
ATOM   5094  N   LYS D   2      -8.113 -12.924  18.070  1.00145.02           N  
ATOM   5095  CA  LYS D   2      -7.118 -11.823  18.252  1.00141.75           C  
ATOM   5096  C   LYS D   2      -6.371 -11.918  19.581  1.00141.15           C  
ATOM   5097  O   LYS D   2      -5.258 -11.388  19.714  1.00138.14           O  
ATOM   5098  CB  LYS D   2      -7.800 -10.452  18.127  1.00141.59           C  
ATOM   5099  CG  LYS D   2      -6.861  -9.250  18.221  1.00135.91           C  
ATOM   5100  CD  LYS D   2      -5.802  -9.270  17.133  1.00129.03           C  
ATOM   5101  CE  LYS D   2      -4.983  -8.002  17.167  1.00124.25           C  
ATOM   5102  NZ  LYS D   2      -3.953  -8.018  16.107  1.00121.58           N  
ATOM   5103  N   GLU D   3      -6.986 -12.600  20.551  1.00143.69           N  
ATOM   5104  CA  GLU D   3      -6.406 -12.787  21.882  1.00144.44           C  
ATOM   5105  C   GLU D   3      -4.988 -13.357  21.821  1.00141.63           C  
ATOM   5106  O   GLU D   3      -4.207 -13.226  22.768  1.00140.06           O  
ATOM   5107  CB  GLU D   3      -7.288 -13.699  22.729  1.00148.15           C  
ATOM   5108  CG  GLU D   3      -6.858 -13.758  24.181  1.00150.51           C  
ATOM   5109  CD  GLU D   3      -6.821 -15.168  24.715  1.00154.65           C  
ATOM   5110  OE1 GLU D   3      -7.902 -15.657  25.155  1.00157.56           O  
ATOM   5111  OE2 GLU D   3      -5.712 -15.781  24.701  1.00153.43           O  
ATOM   5112  N   ALA D   4      -4.680 -14.001  20.697  1.00139.71           N  
ATOM   5113  CA  ALA D   4      -3.346 -14.495  20.397  1.00136.43           C  
ATOM   5114  C   ALA D   4      -2.279 -13.515  20.882  1.00132.24           C  
ATOM   5115  O   ALA D   4      -1.439 -13.863  21.719  1.00131.85           O  
ATOM   5116  CB  ALA D   4      -3.212 -14.739  18.893  1.00136.64           C  
ATOM   5117  N   ARG D   5      -2.342 -12.288  20.367  1.00127.99           N  
ATOM   5118  CA  ARG D   5      -1.399 -11.218  20.711  1.00123.23           C  
ATOM   5119  C   ARG D   5      -1.451 -10.773  22.190  1.00123.17           C  
ATOM   5120  O   ARG D   5      -0.449 -10.310  22.739  1.00121.30           O  
ATOM   5121  CB  ARG D   5      -1.558 -10.051  19.714  1.00121.73           C  
ATOM   5122  CG  ARG D   5      -1.881  -8.674  20.296  1.00121.04           C  
ATOM   5123  CD  ARG D   5      -3.388  -8.496  20.462  1.00124.38           C  
ATOM   5124  NE  ARG D   5      -3.761  -7.148  20.885  1.00125.74           N  
ATOM   5125  CZ  ARG D   5      -4.969  -6.811  21.332  1.00128.65           C  
ATOM   5126  NH1 ARG D   5      -5.213  -5.557  21.689  1.00128.70           N  
ATOM   5127  NH2 ARG D   5      -5.933  -7.723  21.427  1.00130.52           N  
ATOM   5128  N   LYS D   6      -2.614 -10.929  22.821  1.00126.21           N  
ATOM   5129  CA  LYS D   6      -2.775 -10.640  24.243  1.00128.27           C  
ATOM   5130  C   LYS D   6      -1.971 -11.631  25.081  1.00128.33           C  
ATOM   5131  O   LYS D   6      -1.332 -11.241  26.058  1.00127.26           O  
ATOM   5132  CB  LYS D   6      -4.250 -10.707  24.630  1.00131.36           C  
ATOM   5133  CG  LYS D   6      -4.655  -9.736  25.725  1.00133.54           C  
ATOM   5134  CD  LYS D   6      -6.166  -9.703  25.924  1.00138.88           C  
ATOM   5135  CE  LYS D   6      -6.906  -9.079  24.735  1.00140.15           C  
ATOM   5136  NZ  LYS D   6      -7.134 -10.046  23.621  1.00140.78           N  
ATOM   5137  N   ARG D   7      -2.013 -12.910  24.693  1.00129.36           N  
ATOM   5138  CA  ARG D   7      -1.136 -13.937  25.267  1.00129.40           C  
ATOM   5139  C   ARG D   7       0.341 -13.601  25.013  1.00124.02           C  
ATOM   5140  O   ARG D   7       1.206 -13.890  25.840  1.00123.23           O  
ATOM   5141  CB  ARG D   7      -1.451 -15.321  24.678  1.00132.43           C  
ATOM   5142  CG  ARG D   7      -2.505 -16.134  25.420  1.00138.82           C  
ATOM   5143  CD  ARG D   7      -2.303 -17.639  25.182  1.00145.49           C  
ATOM   5144  NE  ARG D   7      -3.372 -18.469  25.752  1.00151.78           N  
ATOM   5145  CZ  ARG D   7      -3.317 -19.798  25.877  1.00155.74           C  
ATOM   5146  NH1 ARG D   7      -4.342 -20.463  26.403  1.00158.57           N  
ATOM   5147  NH2 ARG D   7      -2.239 -20.473  25.486  1.00155.76           N  
ATOM   5148  N   MET D   8       0.614 -12.983  23.868  1.00118.52           N  
ATOM   5149  CA  MET D   8       1.983 -12.669  23.460  1.00113.02           C  
ATOM   5150  C   MET D   8       2.647 -11.506  24.207  1.00108.90           C  
ATOM   5151  O   MET D   8       3.846 -11.563  24.497  1.00107.18           O  
ATOM   5152  CB  MET D   8       2.052 -12.430  21.953  1.00112.22           C  
ATOM   5153  CG  MET D   8       2.418 -13.669  21.156  1.00113.45           C  
ATOM   5154  SD  MET D   8       2.635 -13.366  19.383  1.00113.10           S  
ATOM   5155  CE  MET D   8       0.919 -13.463  18.855  1.00113.97           C  
ATOM   5156  N   VAL D   9       1.880 -10.457  24.499  1.00106.63           N  
ATOM   5157  CA  VAL D   9       2.403  -9.308  25.251  1.00103.52           C  
ATOM   5158  C   VAL D   9       2.509  -9.633  26.751  1.00104.91           C  
ATOM   5159  O   VAL D   9       3.524  -9.326  27.389  1.00103.17           O  
ATOM   5160  CB  VAL D   9       1.582  -7.999  24.994  1.00102.98           C  
ATOM   5161  CG1 VAL D   9       1.890  -6.925  26.040  1.00101.27           C  
ATOM   5162  CG2 VAL D   9       1.840  -7.456  23.588  1.00100.18           C  
ATOM   5163  N   LYS D  10       1.464 -10.263  27.297  1.00108.20           N  
ATOM   5164  CA  LYS D  10       1.460 -10.707  28.699  1.00110.84           C  
ATOM   5165  C   LYS D  10       2.754 -11.453  29.013  1.00108.77           C  
ATOM   5166  O   LYS D  10       3.483 -11.110  29.970  1.00107.71           O  
ATOM   5167  CB  LYS D  10       0.237 -11.600  29.004  1.00114.57           C  
ATOM   5168  CG  LYS D  10      -0.982 -10.889  29.660  1.00118.49           C  
ATOM   5169  CD  LYS D  10      -0.708 -10.476  31.127  1.00120.80           C  
ATOM   5170  CE  LYS D  10      -0.079  -9.071  31.188  1.00119.14           C  
ATOM   5171  NZ  LYS D  10       1.210  -8.998  32.046  1.00117.31           N  
ATOM   5172  N   ARG D  11       3.034 -12.453  28.174  1.00107.15           N  
ATOM   5173  CA  ARG D  11       4.251 -13.239  28.274  1.00104.96           C  
ATOM   5174  C   ARG D  11       5.528 -12.405  28.069  1.00100.04           C  
ATOM   5175  O   ARG D  11       6.561 -12.710  28.664  1.00 99.36           O  
ATOM   5176  CB  ARG D  11       4.184 -14.421  27.299  1.00106.54           C  
ATOM   5177  CG  ARG D  11       5.385 -15.358  27.326  1.00107.12           C  
ATOM   5178  CD  ARG D  11       5.681 -15.878  28.728  1.00108.74           C  
ATOM   5179  NE  ARG D  11       7.000 -16.505  28.814  1.00107.48           N  
ATOM   5180  CZ  ARG D  11       8.153 -15.856  28.993  1.00104.56           C  
ATOM   5181  NH1 ARG D  11       9.282 -16.547  29.048  1.00104.16           N  
ATOM   5182  NH2 ARG D  11       8.192 -14.530  29.116  1.00102.28           N  
ATOM   5183  N   ALA D  12       5.455 -11.347  27.261  1.00 94.81           N  
ATOM   5184  CA  ALA D  12       6.633 -10.495  26.999  1.00 89.90           C  
ATOM   5185  C   ALA D  12       7.040  -9.602  28.177  1.00 88.26           C  
ATOM   5186  O   ALA D  12       8.224  -9.299  28.352  1.00 86.59           O  
ATOM   5187  CB  ALA D  12       6.436  -9.664  25.751  1.00 88.00           C  
ATOM   5188  N   VAL D  13       6.058  -9.178  28.970  1.00 89.22           N  
ATOM   5189  CA  VAL D  13       6.306  -8.434  30.210  1.00 89.74           C  
ATOM   5190  C   VAL D  13       7.283  -9.195  31.112  1.00 90.31           C  
ATOM   5191  O   VAL D  13       8.059  -8.601  31.856  1.00 89.01           O  
ATOM   5192  CB  VAL D  13       4.978  -8.182  30.979  1.00 91.40           C  
ATOM   5193  CG1 VAL D  13       5.219  -7.493  32.326  1.00 91.38           C  
ATOM   5194  CG2 VAL D  13       4.038  -7.350  30.139  1.00 91.21           C  
ATOM   5195  N   GLN D  14       7.250 -10.516  31.015  1.00 92.42           N  
ATOM   5196  CA  GLN D  14       8.013 -11.379  31.906  1.00 94.24           C  
ATOM   5197  C   GLN D  14       9.515 -11.482  31.596  1.00 91.42           C  
ATOM   5198  O   GLN D  14      10.277 -11.984  32.413  1.00 91.92           O  
ATOM   5199  CB  GLN D  14       7.370 -12.766  31.941  1.00 97.31           C  
ATOM   5200  CG  GLN D  14       5.892 -12.736  32.312  1.00102.10           C  
ATOM   5201  CD  GLN D  14       5.226 -14.097  32.196  1.00107.86           C  
ATOM   5202  OE1 GLN D  14       5.881 -15.103  31.919  1.00107.86           O  
ATOM   5203  NE2 GLN D  14       3.913 -14.134  32.407  1.00109.40           N  
ATOM   5204  N   GLU D  15       9.940 -10.962  30.458  1.00 87.41           N  
ATOM   5205  CA  GLU D  15      11.350 -11.018  30.128  1.00 80.46           C  
ATOM   5206  C   GLU D  15      12.069  -9.854  30.760  1.00 71.53           C  
ATOM   5207  O   GLU D  15      13.283  -9.869  30.866  1.00 71.96           O  
ATOM   5208  CB  GLU D  15      11.570 -11.040  28.612  1.00 82.17           C  
ATOM   5209  CG  GLU D  15      11.200 -12.343  27.951  1.00 83.78           C  
ATOM   5210  CD  GLU D  15      12.000 -13.526  28.495  1.00 86.94           C  
ATOM   5211  OE1 GLU D  15      13.191 -13.307  28.847  1.00 87.08           O  
ATOM   5212  OE2 GLU D  15      11.439 -14.692  28.564  1.00 88.52           O  
ATOM   5213  N   ILE D  16      11.304  -8.869  31.221  1.00 40.71           N  
ATOM   5214  CA  ILE D  16      11.847  -7.576  31.690  1.00 40.56           C  
ATOM   5215  C   ILE D  16      12.036  -7.412  33.198  1.00 40.75           C  
ATOM   5216  O   ILE D  16      11.053  -7.207  33.917  1.00 67.90           O  
ATOM   5217  CB  ILE D  16      10.858  -6.481  31.337  1.00 40.35           C  
ATOM   5218  CG1 ILE D  16      11.344  -5.127  31.823  1.00 35.58           C  
ATOM   5219  CG2 ILE D  16       9.533  -6.709  32.075  1.00 38.30           C  
ATOM   5220  CD1 ILE D  16      10.532  -4.079  31.123  1.00 32.50           C  
ATOM   5221  N   LYS D  17      13.271  -7.466  33.699  1.00 68.71           N  
ATOM   5222  CA  LYS D  17      13.465  -7.434  35.144  1.00 76.97           C  
ATOM   5223  C   LYS D  17      13.626  -6.011  35.666  1.00 78.64           C  
ATOM   5224  O   LYS D  17      13.803  -5.097  34.893  1.00 76.74           O  
ATOM   5225  CB  LYS D  17      14.640  -8.319  35.541  1.00 80.86           C  
ATOM   5226  CG  LYS D  17      14.663  -9.679  34.841  1.00 83.43           C  
ATOM   5227  CD  LYS D  17      15.972 -10.458  35.093  1.00 85.29           C  
ATOM   5228  CE  LYS D  17      17.267  -9.512  35.026  1.00 84.01           C  
ATOM   5229  NZ  LYS D  17      18.484 -10.191  35.626  1.00 82.15           N  
ATOM   5230  N   ASP D  18      13.551  -5.834  36.984  1.00 80.03           N  
ATOM   5231  CA  ASP D  18      13.700  -4.520  37.637  1.00 79.42           C  
ATOM   5232  C   ASP D  18      15.081  -3.946  37.363  1.00 76.32           C  
ATOM   5233  O   ASP D  18      16.069  -4.671  37.365  1.00 76.01           O  
ATOM   5234  CB  ASP D  18      13.477  -4.643  39.165  1.00 82.12           C  
ATOM   5235  CG  ASP D  18      13.426  -3.282  39.893  1.00 83.07           C  
ATOM   5236  OD1 ASP D  18      14.242  -2.380  39.616  1.00 83.30           O  
ATOM   5237  OD2 ASP D  18      12.571  -3.112  40.775  1.00 84.61           O  
ATOM   5238  N   GLY D  19      15.141  -2.644  37.125  1.00 72.72           N  
ATOM   5239  CA  GLY D  19      16.411  -1.976  36.889  1.00 68.70           C  
ATOM   5240  C   GLY D  19      16.910  -1.992  35.457  1.00 65.62           C  
ATOM   5241  O   GLY D  19      17.848  -1.276  35.127  1.00 64.01           O  
ATOM   5242  N   MET D  20      16.283  -2.802  34.607  1.00 64.66           N  
ATOM   5243  CA  MET D  20      16.671  -2.904  33.192  1.00 62.66           C  
ATOM   5244  C   MET D  20      16.515  -1.593  32.387  1.00 59.45           C  
ATOM   5245  O   MET D  20      15.721  -0.725  32.741  1.00 59.28           O  
ATOM   5246  CB  MET D  20      15.892  -4.033  32.504  1.00 63.45           C  
ATOM   5247  CG  MET D  20      16.403  -5.445  32.790  1.00 65.75           C  
ATOM   5248  SD  MET D  20      15.997  -6.579  31.427  1.00 67.61           S  
ATOM   5249  CE  MET D  20      16.120  -8.189  32.201  1.00 70.21           C  
ATOM   5250  N   ASN D  21      17.292  -1.457  31.316  1.00 55.87           N  
ATOM   5251  CA  ASN D  21      17.054  -0.419  30.318  1.00 53.12           C  
ATOM   5252  C   ASN D  21      16.630  -1.119  29.049  1.00 52.85           C  
ATOM   5253  O   ASN D  21      17.395  -1.899  28.480  1.00 52.87           O  
ATOM   5254  CB  ASN D  21      18.296   0.393  30.052  1.00 51.39           C  
ATOM   5255  CG  ASN D  21      18.727   1.212  31.241  1.00 51.36           C  
ATOM   5256  OD1 ASN D  21      18.087   2.205  31.593  1.00 51.49           O  
ATOM   5257  ND2 ASN D  21      19.851   0.823  31.847  1.00 48.34           N  
ATOM   5258  N   VAL D  22      15.395  -0.873  28.621  1.00 53.09           N  
ATOM   5259  CA  VAL D  22      14.767  -1.733  27.628  1.00 53.47           C  
ATOM   5260  C   VAL D  22      14.479  -0.950  26.368  1.00 51.85           C  
ATOM   5261  O   VAL D  22      14.140   0.231  26.432  1.00 51.18           O  
ATOM   5262  CB  VAL D  22      13.468  -2.373  28.179  1.00 55.06           C  
ATOM   5263  CG1 VAL D  22      12.870  -3.339  27.181  1.00 55.55           C  
ATOM   5264  CG2 VAL D  22      13.735  -3.101  29.503  1.00 56.61           C  
ATOM   5265  N   ASN D  23      14.643  -1.598  25.222  1.00 50.78           N  
ATOM   5266  CA  ASN D  23      14.173  -1.008  23.985  1.00 50.84           C  
ATOM   5267  C   ASN D  23      13.065  -1.814  23.317  1.00 52.54           C  
ATOM   5268  O   ASN D  23      13.224  -2.981  22.981  1.00 52.34           O  
ATOM   5269  CB  ASN D  23      15.337  -0.724  23.026  1.00 49.94           C  
ATOM   5270  CG  ASN D  23      14.883  -0.115  21.709  1.00 47.51           C  
ATOM   5271  OD1 ASN D  23      14.389  -0.821  20.829  1.00 48.26           O  
ATOM   5272  ND2 ASN D  23      15.065   1.200  21.564  1.00 45.26           N  
ATOM   5273  N   LEU D  24      11.935  -1.149  23.142  1.00 55.23           N  
ATOM   5274  CA  LEU D  24      10.768  -1.727  22.500  1.00 58.14           C  
ATOM   5275  C   LEU D  24      10.727  -1.338  21.040  1.00 57.86           C  
ATOM   5276  O   LEU D  24      10.652  -0.151  20.733  1.00 57.45           O  
ATOM   5277  CB  LEU D  24       9.516  -1.232  23.200  1.00 59.17           C  
ATOM   5278  CG  LEU D  24       9.017  -2.046  24.390  1.00 62.55           C  
ATOM   5279  CD1 LEU D  24      10.048  -3.022  24.968  1.00 62.44           C  
ATOM   5280  CD2 LEU D  24       8.473  -1.100  25.454  1.00 64.18           C  
ATOM   5281  N   GLY D  25      10.794  -2.342  20.163  1.00 59.01           N  
ATOM   5282  CA  GLY D  25      10.712  -2.158  18.708  1.00 60.73           C  
ATOM   5283  C   GLY D  25       9.343  -1.667  18.279  1.00 62.99           C  
ATOM   5284  O   GLY D  25       8.368  -1.870  19.007  1.00 63.78           O  
ATOM   5285  N   ILE D  26       9.264  -1.003  17.115  1.00 64.24           N  
ATOM   5286  CA  ILE D  26       7.962  -0.530  16.573  1.00 66.77           C  
ATOM   5287  C   ILE D  26       7.031  -1.720  16.336  1.00 69.52           C  
ATOM   5288  O   ILE D  26       7.494  -2.836  16.082  1.00 70.00           O  
ATOM   5289  CB  ILE D  26       8.081   0.386  15.286  1.00 65.92           C  
ATOM   5290  CG1 ILE D  26       6.713   0.661  14.609  1.00 68.51           C  
ATOM   5291  CG2 ILE D  26       8.936  -0.262  14.237  1.00 66.04           C  
ATOM   5292  CD1 ILE D  26       5.642   1.514  15.415  1.00 71.73           C  
ATOM   5293  N   GLY D  27       5.729  -1.471  16.454  1.00 72.32           N  
ATOM   5294  CA  GLY D  27       4.732  -2.477  16.189  1.00 75.98           C  
ATOM   5295  C   GLY D  27       4.371  -3.123  17.496  1.00 78.45           C  
ATOM   5296  O   GLY D  27       4.178  -2.438  18.505  1.00 78.67           O  
ATOM   5297  N   MET D  28       4.315  -4.449  17.478  1.00 80.56           N  
ATOM   5298  CA  MET D  28       3.857  -5.222  18.626  1.00 83.33           C  
ATOM   5299  C   MET D  28       4.601  -4.916  19.950  1.00 81.74           C  
ATOM   5300  O   MET D  28       3.960  -4.672  20.969  1.00 83.18           O  
ATOM   5301  CB  MET D  28       3.888  -6.714  18.277  1.00 84.74           C  
ATOM   5302  CG  MET D  28       3.186  -7.633  19.249  1.00 88.74           C  
ATOM   5303  SD  MET D  28       2.441  -9.077  18.438  1.00 94.30           S  
ATOM   5304  CE  MET D  28       3.624  -9.476  17.144  1.00 94.10           C  
ATOM   5305  N   PRO D  29       5.944  -4.907  19.941  1.00 78.78           N  
ATOM   5306  CA  PRO D  29       6.611  -4.819  21.239  1.00 77.69           C  
ATOM   5307  C   PRO D  29       6.279  -3.562  22.028  1.00 77.46           C  
ATOM   5308  O   PRO D  29       6.400  -3.571  23.253  1.00 78.02           O  
ATOM   5309  CB  PRO D  29       8.104  -4.818  20.879  1.00 75.95           C  
ATOM   5310  CG  PRO D  29       8.171  -5.406  19.532  1.00 75.99           C  
ATOM   5311  CD  PRO D  29       6.917  -4.978  18.839  1.00 77.29           C  
ATOM   5312  N   THR D  30       5.863  -2.494  21.351  1.00 76.83           N  
ATOM   5313  CA  THR D  30       5.621  -1.239  22.060  1.00 76.46           C  
ATOM   5314  C   THR D  30       4.401  -1.343  22.965  1.00 79.16           C  
ATOM   5315  O   THR D  30       4.229  -0.544  23.877  1.00 79.55           O  
ATOM   5316  CB  THR D  30       5.485  -0.009  21.130  1.00 75.28           C  
ATOM   5317  OG1 THR D  30       4.174   0.027  20.567  1.00 75.85           O  
ATOM   5318  CG2 THR D  30       6.542  -0.011  20.027  1.00 73.03           C  
ATOM   5319  N   LEU D  31       3.567  -2.346  22.723  1.00 82.43           N  
ATOM   5320  CA  LEU D  31       2.360  -2.549  23.520  1.00 86.00           C  
ATOM   5321  C   LEU D  31       2.697  -2.966  24.953  1.00 86.57           C  
ATOM   5322  O   LEU D  31       1.948  -2.675  25.895  1.00 87.65           O  
ATOM   5323  CB  LEU D  31       1.432  -3.561  22.838  1.00 87.67           C  
ATOM   5324  CG  LEU D  31       0.236  -3.032  22.021  1.00 89.89           C  
ATOM   5325  CD1 LEU D  31       0.595  -1.922  21.028  1.00 88.92           C  
ATOM   5326  CD2 LEU D  31      -0.463  -4.186  21.297  1.00 91.09           C  
ATOM   5327  N   VAL D  32       3.845  -3.621  25.102  1.00 85.22           N  
ATOM   5328  CA  VAL D  32       4.306  -4.119  26.389  1.00 85.16           C  
ATOM   5329  C   VAL D  32       4.345  -2.996  27.419  1.00 84.93           C  
ATOM   5330  O   VAL D  32       3.957  -3.196  28.579  1.00 86.13           O  
ATOM   5331  CB  VAL D  32       5.681  -4.801  26.243  1.00 84.17           C  
ATOM   5332  CG1 VAL D  32       6.400  -4.953  27.584  1.00 84.39           C  
ATOM   5333  CG2 VAL D  32       5.516  -6.148  25.561  1.00 84.87           C  
ATOM   5334  N   ALA D  33       4.778  -1.816  26.968  1.00 83.06           N  
ATOM   5335  CA  ALA D  33       4.883  -0.612  27.808  1.00 82.81           C  
ATOM   5336  C   ALA D  33       3.769  -0.497  28.835  1.00 85.80           C  
ATOM   5337  O   ALA D  33       4.023  -0.125  29.979  1.00 86.40           O  
ATOM   5338  CB  ALA D  33       4.924   0.649  26.946  1.00 80.70           C  
ATOM   5339  N   ASN D  34       2.551  -0.842  28.414  1.00 89.51           N  
ATOM   5340  CA  ASN D  34       1.339  -0.613  29.186  1.00 93.52           C  
ATOM   5341  C   ASN D  34       0.944  -1.800  30.055  1.00 96.28           C  
ATOM   5342  O   ASN D  34      -0.219  -1.935  30.452  1.00 98.56           O  
ATOM   5343  CB  ASN D  34       0.198  -0.229  28.239  1.00 94.23           C  
ATOM   5344  CG  ASN D  34       0.374   1.169  27.645  1.00 93.99           C  
ATOM   5345  OD1 ASN D  34      -0.572   1.953  27.632  1.00 96.50           O  
ATOM   5346  ND2 ASN D  34       1.585   1.485  27.154  1.00 91.72           N  
ATOM   5347  N   GLU D  35       1.922  -2.651  30.349  1.00 96.13           N  
ATOM   5348  CA  GLU D  35       1.708  -3.832  31.163  1.00 97.70           C  
ATOM   5349  C   GLU D  35       2.801  -3.968  32.201  1.00 96.61           C  
ATOM   5350  O   GLU D  35       2.794  -4.898  33.000  1.00 98.03           O  
ATOM   5351  CB  GLU D  35       1.652  -5.083  30.293  1.00 98.33           C  
ATOM   5352  CG  GLU D  35       0.569  -5.070  29.212  1.00101.39           C  
ATOM   5353  CD  GLU D  35      -0.828  -4.791  29.755  1.00105.09           C  
ATOM   5354  OE1 GLU D  35      -1.140  -5.240  30.883  1.00107.62           O  
ATOM   5355  OE2 GLU D  35      -1.609  -4.114  29.053  1.00104.74           O  
ATOM   5356  N   ILE D  36       3.749  -3.041  32.179  1.00 93.69           N  
ATOM   5357  CA  ILE D  36       4.778  -2.997  33.198  1.00 92.19           C  
ATOM   5358  C   ILE D  36       4.106  -2.778  34.541  1.00 95.66           C  
ATOM   5359  O   ILE D  36       3.472  -1.744  34.740  1.00 96.30           O  
ATOM   5360  CB  ILE D  36       5.802  -1.874  32.936  1.00 89.31           C  
ATOM   5361  CG1 ILE D  36       6.725  -2.264  31.784  1.00 85.76           C  
ATOM   5362  CG2 ILE D  36       6.614  -1.569  34.202  1.00 88.76           C  
ATOM   5363  CD1 ILE D  36       7.414  -1.075  31.103  1.00 82.45           C  
ATOM   5364  N   PRO D  37       4.236  -3.748  35.454  1.00 98.92           N  
ATOM   5365  CA  PRO D  37       3.642  -3.652  36.798  1.00101.64           C  
ATOM   5366  C   PRO D  37       4.318  -2.567  37.626  1.00101.15           C  
ATOM   5367  O   PRO D  37       5.448  -2.163  37.316  1.00 99.47           O  
ATOM   5368  CB  PRO D  37       3.933  -5.025  37.412  1.00103.36           C  
ATOM   5369  CG  PRO D  37       4.156  -5.932  36.242  1.00102.77           C  
ATOM   5370  CD  PRO D  37       4.811  -5.090  35.190  1.00 99.09           C  
ATOM   5371  N   ASP D  38       3.632  -2.102  38.668  1.00103.27           N  
ATOM   5372  CA  ASP D  38       4.181  -1.070  39.543  1.00103.75           C  
ATOM   5373  C   ASP D  38       5.528  -1.483  40.123  1.00102.52           C  
ATOM   5374  O   ASP D  38       6.489  -0.699  40.085  1.00100.87           O  
ATOM   5375  CB  ASP D  38       3.202  -0.732  40.666  1.00106.52           C  
ATOM   5376  CG  ASP D  38       1.857  -0.257  40.142  1.00108.86           C  
ATOM   5377  OD1 ASP D  38       1.718  -0.066  38.912  1.00108.12           O  
ATOM   5378  OD2 ASP D  38       0.933  -0.081  40.967  1.00113.57           O  
ATOM   5379  N   GLY D  39       5.597  -2.718  40.628  1.00102.85           N  
ATOM   5380  CA  GLY D  39       6.817  -3.234  41.241  1.00101.96           C  
ATOM   5381  C   GLY D  39       8.098  -3.001  40.450  1.00 98.88           C  
ATOM   5382  O   GLY D  39       9.188  -2.897  41.044  1.00 98.86           O  
ATOM   5383  N   VAL D  40       7.966  -2.895  39.111  1.00 95.20           N  
ATOM   5384  CA  VAL D  40       9.140  -2.890  38.222  1.00 90.73           C  
ATOM   5385  C   VAL D  40       9.583  -1.477  37.778  1.00 87.64           C  
ATOM   5386  O   VAL D  40       8.961  -0.846  36.881  1.00 86.80           O  
ATOM   5387  CB  VAL D  40       8.890  -3.762  36.950  1.00 90.39           C  
ATOM   5388  CG1 VAL D  40      10.185  -3.935  36.155  1.00 87.34           C  
ATOM   5389  CG2 VAL D  40       8.291  -5.121  37.339  1.00 92.01           C  
ATOM   5390  N   HIS D  41      10.673  -0.995  38.384  1.00 84.97           N  
ATOM   5391  CA  HIS D  41      11.196   0.328  38.052  1.00 82.13           C  
ATOM   5392  C   HIS D  41      12.264   0.239  36.966  1.00 78.13           C  
ATOM   5393  O   HIS D  41      13.307  -0.391  37.156  1.00 77.66           O  
ATOM   5394  CB  HIS D  41      11.734   1.033  39.303  1.00 83.66           C  
ATOM   5395  CG  HIS D  41      10.822   0.930  40.488  1.00 89.08           C  
ATOM   5396  ND1 HIS D  41      11.169   0.251  41.639  1.00 94.01           N  
ATOM   5397  CD2 HIS D  41       9.571   1.405  40.696  1.00 92.85           C  
ATOM   5398  CE1 HIS D  41      10.174   0.319  42.507  1.00 96.88           C  
ATOM   5399  NE2 HIS D  41       9.191   1.012  41.957  1.00 97.00           N  
ATOM   5400  N   VAL D  42      11.991   0.868  35.823  1.00 74.51           N  
ATOM   5401  CA  VAL D  42      12.812   0.704  34.625  1.00 70.28           C  
ATOM   5402  C   VAL D  42      12.687   1.891  33.693  1.00 67.00           C  
ATOM   5403  O   VAL D  42      11.705   2.615  33.725  1.00 66.90           O  
ATOM   5404  CB  VAL D  42      12.397  -0.559  33.857  1.00 70.81           C  
ATOM   5405  CG1 VAL D  42      12.850  -0.487  32.402  1.00 69.63           C  
ATOM   5406  CG2 VAL D  42      12.962  -1.797  34.527  1.00 71.96           C  
ATOM   5407  N   MET D  43      13.690   2.056  32.837  1.00 63.47           N  
ATOM   5408  CA  MET D  43      13.719   3.122  31.846  1.00 59.82           C  
ATOM   5409  C   MET D  43      13.640   2.546  30.449  1.00 58.17           C  
ATOM   5410  O   MET D  43      14.373   1.608  30.112  1.00 57.65           O  
ATOM   5411  CB  MET D  43      14.971   3.972  32.015  1.00 58.45           C  
ATOM   5412  CG  MET D  43      14.989   4.732  33.308  1.00 58.62           C  
ATOM   5413  SD  MET D  43      13.640   5.931  33.435  1.00 59.95           S  
ATOM   5414  CE  MET D  43      14.447   7.407  32.805  1.00 60.26           C  
ATOM   5415  N   LEU D  44      12.724   3.113  29.661  1.00 57.18           N  
ATOM   5416  CA  LEU D  44      12.461   2.723  28.273  1.00 55.30           C  
ATOM   5417  C   LEU D  44      13.134   3.664  27.287  1.00 52.72           C  
ATOM   5418  O   LEU D  44      12.895   4.871  27.317  1.00 52.55           O  
ATOM   5419  CB  LEU D  44      10.962   2.763  28.021  1.00 56.79           C  
ATOM   5420  CG  LEU D  44      10.147   1.485  28.192  1.00 58.36           C  
ATOM   5421  CD1 LEU D  44      10.938   0.448  28.995  1.00 58.05           C  
ATOM   5422  CD2 LEU D  44       8.773   1.792  28.791  1.00 57.72           C  
ATOM   5423  N   GLN D  45      13.964   3.101  26.413  1.00 50.00           N  
ATOM   5424  CA  GLN D  45      14.780   3.873  25.485  1.00 46.95           C  
ATOM   5425  C   GLN D  45      14.123   3.985  24.106  1.00 46.47           C  
ATOM   5426  O   GLN D  45      13.741   2.979  23.480  1.00 46.63           O  
ATOM   5427  CB  GLN D  45      16.144   3.215  25.360  1.00 46.12           C  
ATOM   5428  CG  GLN D  45      17.284   4.152  24.992  1.00 46.26           C  
ATOM   5429  CD  GLN D  45      17.639   4.124  23.508  1.00 47.74           C  
ATOM   5430  OE1 GLN D  45      16.900   3.583  22.691  1.00 52.96           O  
ATOM   5431  NE2 GLN D  45      18.766   4.716  23.152  1.00 47.37           N  
ATOM   5432  N   SER D  46      13.985   5.221  23.636  1.00 45.17           N  
ATOM   5433  CA  SER D  46      13.601   5.476  22.260  1.00 43.73           C  
ATOM   5434  C   SER D  46      14.862   5.833  21.455  1.00 41.66           C  
ATOM   5435  O   SER D  46      15.548   6.797  21.787  1.00 40.72           O  
ATOM   5436  CB  SER D  46      12.575   6.610  22.195  1.00 43.95           C  
ATOM   5437  OG  SER D  46      11.720   6.451  21.077  1.00 44.55           O  
ATOM   5438  N   GLU D  47      15.138   5.070  20.395  1.00 40.48           N  
ATOM   5439  CA  GLU D  47      16.358   5.259  19.584  1.00 40.03           C  
ATOM   5440  C   GLU D  47      16.496   6.610  18.899  1.00 38.80           C  
ATOM   5441  O   GLU D  47      17.561   6.924  18.367  1.00 37.39           O  
ATOM   5442  CB  GLU D  47      16.590   4.131  18.556  1.00 40.24           C  
ATOM   5443  CG  GLU D  47      15.483   3.894  17.566  1.00 43.93           C  
ATOM   5444  CD  GLU D  47      14.543   2.768  18.017  1.00 53.94           C  
ATOM   5445  OE1 GLU D  47      14.021   2.783  19.198  1.00 53.43           O  
ATOM   5446  OE2 GLU D  47      14.327   1.867  17.157  1.00 57.41           O  
ATOM   5447  N   ASN D  48      15.423   7.398  18.908  1.00 38.93           N  
ATOM   5448  CA  ASN D  48      15.497   8.778  18.432  1.00 38.35           C  
ATOM   5449  C   ASN D  48      16.069   9.780  19.458  1.00 37.62           C  
ATOM   5450  O   ASN D  48      16.201  10.964  19.166  1.00 37.16           O  
ATOM   5451  CB  ASN D  48      14.165   9.242  17.821  1.00 39.40           C  
ATOM   5452  CG  ASN D  48      12.963   9.030  18.739  1.00 40.41           C  
ATOM   5453  OD1 ASN D  48      11.989   9.771  18.661  1.00 43.38           O  
ATOM   5454  ND2 ASN D  48      13.021   8.026  19.594  1.00 40.05           N  
ATOM   5455  N   GLY D  49      16.436   9.299  20.643  1.00 37.26           N  
ATOM   5456  CA  GLY D  49      17.183  10.131  21.593  1.00 37.16           C  
ATOM   5457  C   GLY D  49      16.493  10.433  22.918  1.00 38.16           C  
ATOM   5458  O   GLY D  49      16.655  11.503  23.485  1.00 38.37           O  
ATOM   5459  N   LEU D  50      15.726   9.486  23.433  1.00 39.28           N  
ATOM   5460  CA  LEU D  50      15.104   9.676  24.726  1.00 40.73           C  
ATOM   5461  C   LEU D  50      15.333   8.430  25.517  1.00 40.95           C  
ATOM   5462  O   LEU D  50      15.070   7.336  25.024  1.00 41.04           O  
ATOM   5463  CB  LEU D  50      13.600   9.937  24.585  1.00 41.52           C  
ATOM   5464  CG  LEU D  50      12.681   9.849  25.808  1.00 43.75           C  
ATOM   5465  CD1 LEU D  50      13.111  10.766  26.942  1.00 42.53           C  
ATOM   5466  CD2 LEU D  50      11.243  10.155  25.397  1.00 45.26           C  
ATOM   5467  N   LEU D  51      15.846   8.606  26.728  1.00 41.82           N  
ATOM   5468  CA  LEU D  51      15.854   7.543  27.710  1.00 43.89           C  
ATOM   5469  C   LEU D  51      14.818   7.915  28.744  1.00 46.18           C  
ATOM   5470  O   LEU D  51      14.983   8.921  29.438  1.00 46.56           O  
ATOM   5471  CB  LEU D  51      17.242   7.341  28.345  1.00 43.12           C  
ATOM   5472  CG  LEU D  51      17.303   6.232  29.402  1.00 44.16           C  
ATOM   5473  CD1 LEU D  51      16.853   4.878  28.816  1.00 42.94           C  
ATOM   5474  CD2 LEU D  51      18.683   6.137  30.092  1.00 43.17           C  
ATOM   5475  N   GLY D  52      13.746   7.116  28.815  1.00 48.37           N  
ATOM   5476  CA  GLY D  52      12.608   7.404  29.699  1.00 51.30           C  
ATOM   5477  C   GLY D  52      11.229   7.638  29.061  1.00 52.97           C  
ATOM   5478  O   GLY D  52      10.450   8.475  29.546  1.00 54.07           O  
ATOM   5479  N   ILE D  53      10.929   6.887  27.999  1.00 53.07           N  
ATOM   5480  CA  ILE D  53       9.601   6.815  27.395  1.00 54.66           C  
ATOM   5481  C   ILE D  53       8.456   6.562  28.399  1.00 58.27           C  
ATOM   5482  O   ILE D  53       8.500   5.600  29.178  1.00 59.91           O  
ATOM   5483  CB  ILE D  53       9.539   5.660  26.374  1.00 54.20           C  
ATOM   5484  CG1 ILE D  53      10.514   5.878  25.191  1.00 51.82           C  
ATOM   5485  CG2 ILE D  53       8.089   5.433  25.880  1.00 54.04           C  
ATOM   5486  CD1 ILE D  53      10.549   4.692  24.196  1.00 48.94           C  
ATOM   5487  N   GLY D  54       7.417   7.397  28.361  1.00 60.75           N  
ATOM   5488  CA  GLY D  54       6.254   7.245  29.243  1.00 63.93           C  
ATOM   5489  C   GLY D  54       5.006   7.123  28.398  1.00 66.66           C  
ATOM   5490  O   GLY D  54       5.103   7.156  27.165  1.00 66.07           O  
ATOM   5491  N   PRO D  55       3.824   6.988  29.040  1.00 70.11           N  
ATOM   5492  CA  PRO D  55       2.587   6.713  28.302  1.00 72.25           C  
ATOM   5493  C   PRO D  55       2.162   7.872  27.404  1.00 72.35           C  
ATOM   5494  O   PRO D  55       2.760   8.940  27.457  1.00 71.39           O  
ATOM   5495  CB  PRO D  55       1.553   6.493  29.418  1.00 74.11           C  
ATOM   5496  CG  PRO D  55       2.349   6.263  30.647  1.00 73.94           C  
ATOM   5497  CD  PRO D  55       3.569   7.080  30.488  1.00 71.45           C  
ATOM   5498  N   TYR D  56       1.118   7.660  26.610  1.00 73.97           N  
ATOM   5499  CA  TYR D  56       0.601   8.682  25.709  1.00 75.43           C  
ATOM   5500  C   TYR D  56       0.015   9.907  26.418  1.00 76.58           C  
ATOM   5501  O   TYR D  56      -0.592   9.771  27.464  1.00 77.29           O  
ATOM   5502  CB  TYR D  56      -0.452   8.065  24.808  1.00 76.74           C  
ATOM   5503  CG  TYR D  56       0.079   6.971  23.915  1.00 76.08           C  
ATOM   5504  CD1 TYR D  56       1.222   7.170  23.137  1.00 74.00           C  
ATOM   5505  CD2 TYR D  56      -0.586   5.748  23.825  1.00 77.69           C  
ATOM   5506  CE1 TYR D  56       1.700   6.173  22.312  1.00 72.64           C  
ATOM   5507  CE2 TYR D  56      -0.129   4.747  23.010  1.00 76.00           C  
ATOM   5508  CZ  TYR D  56       1.014   4.960  22.256  1.00 75.15           C  
ATOM   5509  OH  TYR D  56       1.461   3.951  21.438  1.00 75.40           O  
ATOM   5510  N   PRO D  57       0.171  11.104  25.818  1.00 76.58           N  
ATOM   5511  CA  PRO D  57      -0.183  12.373  26.454  1.00 78.48           C  
ATOM   5512  C   PRO D  57      -1.667  12.669  26.434  1.00 82.77           C  
ATOM   5513  O   PRO D  57      -2.394  12.182  25.570  1.00 83.82           O  
ATOM   5514  CB  PRO D  57       0.543  13.426  25.606  1.00 77.14           C  
ATOM   5515  CG  PRO D  57       1.154  12.717  24.474  1.00 74.90           C  
ATOM   5516  CD  PRO D  57       0.687  11.307  24.455  1.00 74.89           C  
ATOM   5517  N   LEU D  58      -2.097  13.479  27.391  1.00 86.18           N  
ATOM   5518  CA  LEU D  58      -3.460  13.946  27.489  1.00 90.30           C  
ATOM   5519  C   LEU D  58      -3.835  14.847  26.326  1.00 91.24           C  
ATOM   5520  O   LEU D  58      -3.078  15.753  25.985  1.00 90.63           O  
ATOM   5521  CB  LEU D  58      -3.597  14.742  28.775  1.00 92.12           C  
ATOM   5522  CG  LEU D  58      -4.570  14.235  29.844  1.00 95.97           C  
ATOM   5523  CD1 LEU D  58      -3.955  14.415  31.260  1.00 97.26           C  
ATOM   5524  CD2 LEU D  58      -5.895  14.969  29.688  1.00 96.63           C  
ATOM   5525  N   GLU D  59      -5.004  14.616  25.731  1.00 93.85           N  
ATOM   5526  CA  GLU D  59      -5.480  15.471  24.654  1.00 96.08           C  
ATOM   5527  C   GLU D  59      -5.211  16.944  24.925  1.00 96.42           C  
ATOM   5528  O   GLU D  59      -5.540  17.448  25.991  1.00 97.91           O  
ATOM   5529  CB  GLU D  59      -6.973  15.265  24.413  1.00 98.37           C  
ATOM   5530  CG  GLU D  59      -7.264  14.531  23.123  1.00100.29           C  
ATOM   5531  CD  GLU D  59      -8.738  14.244  22.915  1.00104.90           C  
ATOM   5532  OE1 GLU D  59      -9.514  14.316  23.893  1.00107.92           O  
ATOM   5533  OE2 GLU D  59      -9.120  13.936  21.766  1.00104.41           O  
ATOM   5534  N   GLY D  60      -4.615  17.632  23.955  1.00 94.86           N  
ATOM   5535  CA  GLY D  60      -4.367  19.064  24.074  1.00 93.87           C  
ATOM   5536  C   GLY D  60      -3.024  19.335  24.698  1.00 91.29           C  
ATOM   5537  O   GLY D  60      -2.668  20.490  24.929  1.00 91.83           O  
ATOM   5538  N   THR D  61      -2.279  18.258  24.955  1.00 88.13           N  
ATOM   5539  CA  THR D  61      -0.980  18.337  25.592  1.00 84.10           C  
ATOM   5540  C   THR D  61       0.080  17.526  24.884  1.00 80.67           C  
ATOM   5541  O   THR D  61       1.219  17.441  25.367  1.00 79.50           O  
ATOM   5542  CB  THR D  61      -1.036  17.878  27.049  1.00 84.86           C  
ATOM   5543  OG1 THR D  61      -0.128  18.673  27.808  1.00 85.77           O  
ATOM   5544  CG2 THR D  61      -0.636  16.407  27.195  1.00 83.40           C  
ATOM   5545  N   GLU D  62      -0.280  16.910  23.764  1.00 78.45           N  
ATOM   5546  CA  GLU D  62       0.722  16.293  22.905  1.00 75.78           C  
ATOM   5547  C   GLU D  62       1.710  17.383  22.534  1.00 73.66           C  
ATOM   5548  O   GLU D  62       1.384  18.574  22.559  1.00 74.46           O  
ATOM   5549  CB  GLU D  62       0.122  15.737  21.603  1.00 76.14           C  
ATOM   5550  CG  GLU D  62      -1.364  15.464  21.628  1.00 80.98           C  
ATOM   5551  CD  GLU D  62      -2.197  16.702  21.322  1.00 86.58           C  
ATOM   5552  OE1 GLU D  62      -2.694  17.350  22.267  1.00 87.45           O  
ATOM   5553  OE2 GLU D  62      -2.344  17.034  20.126  1.00 89.86           O  
ATOM   5554  N   ASP D  63       2.916  16.971  22.179  1.00 70.21           N  
ATOM   5555  CA  ASP D  63       3.941  17.897  21.746  1.00 67.47           C  
ATOM   5556  C   ASP D  63       4.676  17.337  20.524  1.00 65.04           C  
ATOM   5557  O   ASP D  63       5.261  16.242  20.573  1.00 63.82           O  
ATOM   5558  CB  ASP D  63       4.890  18.168  22.916  1.00 67.17           C  
ATOM   5559  CG  ASP D  63       6.076  19.044  22.540  1.00 67.06           C  
ATOM   5560  OD1 ASP D  63       6.089  19.675  21.461  1.00 66.59           O  
ATOM   5561  OD2 ASP D  63       7.015  19.094  23.356  1.00 67.93           O  
ATOM   5562  N   ALA D  64       4.645  18.102  19.432  1.00 64.02           N  
ATOM   5563  CA  ALA D  64       5.329  17.739  18.179  1.00 61.39           C  
ATOM   5564  C   ALA D  64       6.805  17.347  18.347  1.00 58.41           C  
ATOM   5565  O   ALA D  64       7.313  16.478  17.622  1.00 56.87           O  
ATOM   5566  CB  ALA D  64       5.193  18.860  17.160  1.00 62.54           C  
ATOM   5567  N   ASP D  65       7.483  17.985  19.297  1.00 56.56           N  
ATOM   5568  CA  ASP D  65       8.901  17.729  19.554  1.00 53.78           C  
ATOM   5569  C   ASP D  65       9.148  16.444  20.350  1.00 52.50           C  
ATOM   5570  O   ASP D  65      10.296  16.050  20.530  1.00 51.02           O  
ATOM   5571  CB  ASP D  65       9.571  18.939  20.243  1.00 53.70           C  
ATOM   5572  CG  ASP D  65       9.785  20.117  19.297  1.00 54.77           C  
ATOM   5573  OD1 ASP D  65       9.678  19.911  18.066  1.00 58.02           O  
ATOM   5574  OD2 ASP D  65      10.058  21.250  19.763  1.00 53.25           O  
ATOM   5575  N   LEU D  66       8.086  15.782  20.810  1.00 53.06           N  
ATOM   5576  CA  LEU D  66       8.240  14.600  21.684  1.00 53.02           C  
ATOM   5577  C   LEU D  66       7.506  13.361  21.156  1.00 52.82           C  
ATOM   5578  O   LEU D  66       6.272  13.251  21.290  1.00 54.28           O  
ATOM   5579  CB  LEU D  66       7.728  14.918  23.087  1.00 53.91           C  
ATOM   5580  CG  LEU D  66       8.514  14.359  24.274  1.00 54.79           C  
ATOM   5581  CD1 LEU D  66       7.612  14.212  25.500  1.00 55.26           C  
ATOM   5582  CD2 LEU D  66       9.283  13.036  23.971  1.00 54.34           C  
ATOM   5583  N   ILE D  67       8.248  12.435  20.555  1.00 50.72           N  
ATOM   5584  CA  ILE D  67       7.644  11.269  19.878  1.00 49.90           C  
ATOM   5585  C   ILE D  67       8.477  10.019  20.114  1.00 48.98           C  
ATOM   5586  O   ILE D  67       9.639  10.118  20.565  1.00 47.54           O  
ATOM   5587  CB  ILE D  67       7.468  11.470  18.335  1.00 49.41           C  
ATOM   5588  CG1 ILE D  67       8.833  11.675  17.657  1.00 48.28           C  
ATOM   5589  CG2 ILE D  67       6.500  12.609  18.033  1.00 49.46           C  
ATOM   5590  CD1 ILE D  67       8.758  11.892  16.141  1.00 46.57           C  
ATOM   5591  N   ASN D  68       7.886   8.853  19.830  1.00 48.75           N  
ATOM   5592  CA  ASN D  68       8.642   7.605  19.866  1.00 48.06           C  
ATOM   5593  C   ASN D  68       9.229   7.295  18.473  1.00 46.26           C  
ATOM   5594  O   ASN D  68       8.953   7.999  17.514  1.00 46.01           O  
ATOM   5595  CB  ASN D  68       7.772   6.461  20.366  1.00 49.14           C  
ATOM   5596  CG  ASN D  68       6.648   6.124  19.401  1.00 52.83           C  
ATOM   5597  OD1 ASN D  68       6.702   6.460  18.207  1.00 55.00           O  
ATOM   5598  ND2 ASN D  68       5.605   5.473  19.917  1.00 55.25           N  
ATOM   5599  N   ALA D  69      10.013   6.230  18.354  1.00 44.64           N  
ATOM   5600  CA  ALA D  69      10.590   5.897  17.065  1.00 43.88           C  
ATOM   5601  C   ALA D  69       9.542   5.585  16.024  1.00 45.43           C  
ATOM   5602  O   ALA D  69       9.826   5.694  14.834  1.00 45.41           O  
ATOM   5603  CB  ALA D  69      11.573   4.762  17.181  1.00 42.73           C  
ATOM   5604  N   GLY D  70       8.335   5.198  16.457  1.00 47.74           N  
ATOM   5605  CA  GLY D  70       7.234   4.917  15.519  1.00 49.73           C  
ATOM   5606  C   GLY D  70       6.469   6.163  15.086  1.00 51.35           C  
ATOM   5607  O   GLY D  70       5.459   6.069  14.358  1.00 52.43           O  
ATOM   5608  N   LYS D  71       6.937   7.331  15.537  1.00 51.21           N  
ATOM   5609  CA  LYS D  71       6.355   8.616  15.143  1.00 52.54           C  
ATOM   5610  C   LYS D  71       5.074   8.982  15.931  1.00 54.61           C  
ATOM   5611  O   LYS D  71       4.448  10.016  15.673  1.00 55.12           O  
ATOM   5612  CB  LYS D  71       6.096   8.653  13.627  1.00 52.49           C  
ATOM   5613  CG  LYS D  71       7.308   9.002  12.734  1.00 51.12           C  
ATOM   5614  CD  LYS D  71       8.550   8.182  13.040  1.00 49.47           C  
ATOM   5615  CE  LYS D  71       9.119   7.527  11.811  1.00 49.32           C  
ATOM   5616  NZ  LYS D  71      10.508   6.985  12.063  1.00 51.16           N  
ATOM   5617  N   GLU D  72       4.714   8.139  16.901  1.00 55.81           N  
ATOM   5618  CA  GLU D  72       3.627   8.433  17.832  1.00 57.99           C  
ATOM   5619  C   GLU D  72       4.000   9.422  18.936  1.00 58.05           C  
ATOM   5620  O   GLU D  72       5.026   9.311  19.597  1.00 57.09           O  
ATOM   5621  CB  GLU D  72       3.138   7.172  18.517  1.00 58.70           C  
ATOM   5622  CG  GLU D  72       2.793   6.053  17.615  1.00 60.01           C  
ATOM   5623  CD  GLU D  72       2.685   4.768  18.386  1.00 61.24           C  
ATOM   5624  OE1 GLU D  72       3.640   4.456  19.127  1.00 61.04           O  
ATOM   5625  OE2 GLU D  72       1.657   4.074  18.250  1.00 62.68           O  
ATOM   5626  N   THR D  73       3.114  10.377  19.129  1.00 60.14           N  
ATOM   5627  CA  THR D  73       3.206  11.375  20.167  1.00 61.93           C  
ATOM   5628  C   THR D  73       3.204  10.658  21.534  1.00 61.57           C  
ATOM   5629  O   THR D  73       2.399   9.759  21.745  1.00 62.76           O  
ATOM   5630  CB  THR D  73       2.014  12.373  19.936  1.00 63.65           C  
ATOM   5631  OG1 THR D  73       2.465  13.727  20.038  1.00 64.77           O  
ATOM   5632  CG2 THR D  73       0.842  12.121  20.823  1.00 64.62           C  
ATOM   5633  N   ILE D  74       4.140  11.012  22.419  1.00 60.12           N  
ATOM   5634  CA  ILE D  74       4.377  10.272  23.684  1.00 59.44           C  
ATOM   5635  C   ILE D  74       4.651  11.176  24.901  1.00 60.10           C  
ATOM   5636  O   ILE D  74       4.434  12.386  24.837  1.00 61.28           O  
ATOM   5637  CB  ILE D  74       5.554   9.207  23.600  1.00 57.95           C  
ATOM   5638  CG1 ILE D  74       6.861   9.825  23.127  1.00 54.55           C  
ATOM   5639  CG2 ILE D  74       5.192   7.984  22.742  1.00 58.20           C  
ATOM   5640  CD1 ILE D  74       8.058   9.161  23.767  1.00 51.89           C  
ATOM   5641  N   THR D  75       5.139  10.581  25.991  1.00 59.27           N  
ATOM   5642  CA  THR D  75       5.362  11.282  27.264  1.00 59.73           C  
ATOM   5643  C   THR D  75       6.729  10.906  27.841  1.00 57.16           C  
ATOM   5644  O   THR D  75       7.197   9.792  27.618  1.00 56.42           O  
ATOM   5645  CB  THR D  75       4.198  10.956  28.269  1.00 62.07           C  
ATOM   5646  OG1 THR D  75       3.168  11.953  28.173  1.00 62.69           O  
ATOM   5647  CG2 THR D  75       4.668  10.851  29.703  1.00 63.12           C  
ATOM   5648  N   GLU D  76       7.394  11.836  28.536  1.00 56.07           N  
ATOM   5649  CA  GLU D  76       8.683  11.549  29.239  1.00 54.56           C  
ATOM   5650  C   GLU D  76       8.392  11.215  30.689  1.00 56.11           C  
ATOM   5651  O   GLU D  76       7.412  11.696  31.243  1.00 57.70           O  
ATOM   5652  CB  GLU D  76       9.655  12.739  29.164  1.00 53.03           C  
ATOM   5653  CG  GLU D  76       9.202  13.984  29.928  1.00 53.29           C  
ATOM   5654  CD  GLU D  76      10.143  15.182  29.810  1.00 52.46           C  
ATOM   5655  OE1 GLU D  76      10.457  15.585  28.676  1.00 50.00           O  
ATOM   5656  OE2 GLU D  76      10.554  15.741  30.862  1.00 53.17           O  
ATOM   5657  N   VAL D  77       9.225  10.397  31.324  1.00 57.11           N  
ATOM   5658  CA  VAL D  77       9.022  10.117  32.779  1.00 58.58           C  
ATOM   5659  C   VAL D  77       9.913  10.974  33.692  1.00 59.64           C  
ATOM   5660  O   VAL D  77      10.668  11.858  33.238  1.00 58.67           O  
ATOM   5661  CB  VAL D  77       9.222   8.609  33.146  1.00 58.42           C  
ATOM   5662  CG1 VAL D  77       8.187   7.739  32.453  1.00 59.01           C  
ATOM   5663  CG2 VAL D  77      10.641   8.141  32.816  1.00 55.72           C  
ATOM   5664  N   THR D  78       9.838  10.683  34.984  1.00 62.00           N  
ATOM   5665  CA  THR D  78      10.695  11.334  35.960  1.00 63.09           C  
ATOM   5666  C   THR D  78      12.175  10.968  35.768  1.00 61.29           C  
ATOM   5667  O   THR D  78      12.527   9.788  35.632  1.00 61.00           O  
ATOM   5668  CB  THR D  78      10.205  11.034  37.359  1.00 64.79           C  
ATOM   5669  OG1 THR D  78       9.037  11.823  37.605  1.00 67.11           O  
ATOM   5670  CG2 THR D  78      11.245  11.371  38.378  1.00 65.35           C  
ATOM   5671  N   GLY D  79      13.028  12.001  35.738  1.00 59.91           N  
ATOM   5672  CA  GLY D  79      14.468  11.847  35.577  1.00 56.48           C  
ATOM   5673  C   GLY D  79      14.787  11.203  34.254  1.00 54.18           C  
ATOM   5674  O   GLY D  79      15.692  10.385  34.167  1.00 53.69           O  
ATOM   5675  N   ALA D  80      14.024  11.538  33.218  1.00 52.58           N  
ATOM   5676  CA  ALA D  80      14.363  11.106  31.860  1.00 50.03           C  
ATOM   5677  C   ALA D  80      15.543  11.925  31.333  1.00 48.39           C  
ATOM   5678  O   ALA D  80      15.952  12.911  31.953  1.00 48.53           O  
ATOM   5679  CB  ALA D  80      13.171  11.250  30.940  1.00 50.09           C  
ATOM   5680  N   SER D  81      16.096  11.511  30.193  1.00 46.11           N  
ATOM   5681  CA  SER D  81      17.123  12.306  29.523  1.00 44.36           C  
ATOM   5682  C   SER D  81      16.976  12.227  28.016  1.00 43.56           C  
ATOM   5683  O   SER D  81      16.460  11.237  27.495  1.00 42.87           O  
ATOM   5684  CB  SER D  81      18.542  11.913  29.964  1.00 43.51           C  
ATOM   5685  OG  SER D  81      18.819  10.553  29.707  1.00 41.43           O  
ATOM   5686  N   TYR D  82      17.432  13.301  27.357  1.00 42.99           N  
ATOM   5687  CA  TYR D  82      17.449  13.450  25.919  1.00 41.95           C  
ATOM   5688  C   TYR D  82      18.872  13.517  25.457  1.00 40.59           C  
ATOM   5689  O   TYR D  82      19.697  14.069  26.129  1.00 40.89           O  
ATOM   5690  CB  TYR D  82      16.731  14.736  25.506  1.00 42.75           C  
ATOM   5691  CG  TYR D  82      15.246  14.645  25.772  1.00 45.65           C  
ATOM   5692  CD1 TYR D  82      14.418  13.840  24.972  1.00 45.86           C  
ATOM   5693  CD2 TYR D  82      14.667  15.321  26.853  1.00 45.79           C  
ATOM   5694  CE1 TYR D  82      13.063  13.732  25.235  1.00 47.16           C  
ATOM   5695  CE2 TYR D  82      13.318  15.217  27.116  1.00 47.50           C  
ATOM   5696  CZ  TYR D  82      12.517  14.426  26.313  1.00 48.09           C  
ATOM   5697  OH  TYR D  82      11.166  14.325  26.582  1.00 49.42           O  
ATOM   5698  N   PHE D  83      19.141  12.975  24.280  1.00 39.13           N  
ATOM   5699  CA  PHE D  83      20.485  12.941  23.706  1.00 38.07           C  
ATOM   5700  C   PHE D  83      20.344  12.836  22.182  1.00 38.13           C  
ATOM   5701  O   PHE D  83      19.239  12.679  21.639  1.00 38.56           O  
ATOM   5702  CB  PHE D  83      21.306  11.760  24.261  1.00 36.60           C  
ATOM   5703  CG  PHE D  83      20.487  10.532  24.532  1.00 35.97           C  
ATOM   5704  CD1 PHE D  83      19.893  10.338  25.788  1.00 36.23           C  
ATOM   5705  CD2 PHE D  83      20.260   9.593  23.532  1.00 34.23           C  
ATOM   5706  CE1 PHE D  83      19.109   9.216  26.059  1.00 35.47           C  
ATOM   5707  CE2 PHE D  83      19.481   8.459  23.794  1.00 36.18           C  
ATOM   5708  CZ  PHE D  83      18.910   8.265  25.079  1.00 34.92           C  
ATOM   5709  N   ASP D  84      21.458  12.916  21.480  1.00 37.24           N  
ATOM   5710  CA  ASP D  84      21.359  12.963  20.053  1.00 36.82           C  
ATOM   5711  C   ASP D  84      21.564  11.543  19.511  1.00 35.44           C  
ATOM   5712  O   ASP D  84      21.917  10.619  20.268  1.00 34.32           O  
ATOM   5713  CB  ASP D  84      22.328  14.014  19.504  1.00 36.97           C  
ATOM   5714  CG  ASP D  84      23.495  13.422  18.786  1.00 39.69           C  
ATOM   5715  OD1 ASP D  84      24.390  12.761  19.370  1.00 36.73           O  
ATOM   5716  OD2 ASP D  84      23.500  13.634  17.555  1.00 50.72           O  
ATOM   5717  N   SER D  85      21.316  11.394  18.210  1.00 34.22           N  
ATOM   5718  CA  SER D  85      21.343  10.113  17.534  1.00 33.78           C  
ATOM   5719  C   SER D  85      22.672   9.364  17.647  1.00 33.71           C  
ATOM   5720  O   SER D  85      22.671   8.183  18.020  1.00 33.85           O  
ATOM   5721  CB  SER D  85      20.905  10.260  16.087  1.00 33.73           C  
ATOM   5722  OG  SER D  85      19.536  10.631  16.040  1.00 35.25           O  
ATOM   5723  N   ALA D  86      23.805  10.015  17.377  1.00 33.17           N  
ATOM   5724  CA  ALA D  86      25.056   9.301  17.616  1.00 33.33           C  
ATOM   5725  C   ALA D  86      25.148   8.735  19.039  1.00 33.74           C  
ATOM   5726  O   ALA D  86      25.557   7.606  19.185  1.00 34.90           O  
ATOM   5727  CB  ALA D  86      26.250  10.137  17.304  1.00 33.06           C  
ATOM   5728  N   GLU D  87      24.754   9.509  20.054  0.50 33.95           N  
ATOM   5730  CA  GLU D  87      24.812   9.065  21.444  0.50 34.17           C  
ATOM   5732  C   GLU D  87      23.959   7.845  21.685  0.50 34.44           C  
ATOM   5734  O   GLU D  87      24.376   6.878  22.359  0.50 34.30           O  
ATOM   5736  CB  GLU D  87      24.341  10.163  22.392  0.50 34.28           C  
ATOM   5738  CG  GLU D  87      25.455  10.765  23.213  0.50 33.81           C  
ATOM   5740  CD  GLU D  87      26.147   9.735  24.068  0.50 31.35           C  
ATOM   5742  OE1 GLU D  87      25.428   8.981  24.752  0.50 31.85           O  
ATOM   5744  OE2 GLU D  87      27.393   9.665  24.038  0.50 27.29           O  
ATOM   5746  N   SER D  88      22.752   7.927  21.128  1.00 34.50           N  
ATOM   5747  CA  SER D  88      21.728   6.911  21.270  1.00 34.17           C  
ATOM   5748  C   SER D  88      22.231   5.575  20.765  1.00 33.15           C  
ATOM   5749  O   SER D  88      21.913   4.521  21.336  1.00 33.85           O  
ATOM   5750  CB  SER D  88      20.501   7.334  20.482  1.00 34.12           C  
ATOM   5751  OG  SER D  88      19.445   6.421  20.700  1.00 36.90           O  
ATOM   5752  N   PHE D  89      23.058   5.613  19.726  1.00 31.58           N  
ATOM   5753  CA  PHE D  89      23.517   4.369  19.164  1.00 30.86           C  
ATOM   5754  C   PHE D  89      24.829   3.904  19.769  1.00 30.08           C  
ATOM   5755  O   PHE D  89      25.178   2.742  19.668  1.00 29.42           O  
ATOM   5756  CB  PHE D  89      23.447   4.384  17.645  1.00 30.24           C  
ATOM   5757  CG  PHE D  89      22.058   4.119  17.128  1.00 32.90           C  
ATOM   5758  CD1 PHE D  89      21.616   2.813  16.910  1.00 35.77           C  
ATOM   5759  CD2 PHE D  89      21.171   5.166  16.879  1.00 35.06           C  
ATOM   5760  CE1 PHE D  89      20.303   2.547  16.432  1.00 37.49           C  
ATOM   5761  CE2 PHE D  89      19.855   4.913  16.398  1.00 35.73           C  
ATOM   5762  CZ  PHE D  89      19.418   3.602  16.195  1.00 34.74           C  
ATOM   5763  N   ALA D  90      25.522   4.834  20.424  1.00 30.07           N  
ATOM   5764  CA  ALA D  90      26.618   4.519  21.328  1.00 30.14           C  
ATOM   5765  C   ALA D  90      26.060   3.670  22.478  1.00 30.87           C  
ATOM   5766  O   ALA D  90      26.550   2.579  22.748  1.00 30.64           O  
ATOM   5767  CB  ALA D  90      27.242   5.775  21.829  1.00 29.12           C  
ATOM   5768  N   MET D  91      24.987   4.140  23.101  1.00 31.83           N  
ATOM   5769  CA  MET D  91      24.335   3.383  24.146  1.00 33.70           C  
ATOM   5770  C   MET D  91      23.993   1.974  23.657  1.00 33.97           C  
ATOM   5771  O   MET D  91      24.248   0.990  24.354  1.00 34.35           O  
ATOM   5772  CB  MET D  91      23.032   4.054  24.522  1.00 34.42           C  
ATOM   5773  CG  MET D  91      23.081   5.402  25.200  1.00 36.91           C  
ATOM   5774  SD  MET D  91      21.391   5.822  25.730  1.00 40.40           S  
ATOM   5775  CE  MET D  91      20.858   4.176  26.141  1.00 38.36           C  
ATOM   5776  N   ILE D  92      23.390   1.901  22.460  1.00 33.65           N  
ATOM   5777  CA  ILE D  92      22.923   0.650  21.831  1.00 33.23           C  
ATOM   5778  C   ILE D  92      24.076  -0.253  21.340  1.00 33.50           C  
ATOM   5779  O   ILE D  92      24.174  -1.444  21.711  1.00 34.70           O  
ATOM   5780  CB  ILE D  92      21.961   0.978  20.648  1.00 33.01           C  
ATOM   5781  CG1 ILE D  92      20.596   1.430  21.179  1.00 32.63           C  
ATOM   5782  CG2 ILE D  92      21.838  -0.192  19.682  1.00 32.34           C  
ATOM   5783  CD1 ILE D  92      19.631   1.949  20.104  1.00 31.27           C  
ATOM   5784  N   ARG D  93      24.940   0.307  20.506  1.00 32.10           N  
ATOM   5785  CA  ARG D  93      26.019  -0.452  19.912  1.00 32.80           C  
ATOM   5786  C   ARG D  93      26.988  -0.913  20.995  1.00 34.20           C  
ATOM   5787  O   ARG D  93      27.504  -2.030  20.906  1.00 35.36           O  
ATOM   5788  CB  ARG D  93      26.738   0.400  18.860  1.00 32.26           C  
ATOM   5789  CG  ARG D  93      27.825  -0.281  18.005  1.00 32.68           C  
ATOM   5790  CD  ARG D  93      28.175   0.643  16.810  1.00 34.01           C  
ATOM   5791  NE  ARG D  93      28.282   2.019  17.291  1.00 34.83           N  
ATOM   5792  CZ  ARG D  93      27.665   3.077  16.787  1.00 34.17           C  
ATOM   5793  NH1 ARG D  93      26.884   2.989  15.719  1.00 30.97           N  
ATOM   5794  NH2 ARG D  93      27.847   4.252  17.383  1.00 38.59           N  
ATOM   5795  N   GLY D  94      27.213  -0.072  22.016  1.00 34.35           N  
ATOM   5796  CA  GLY D  94      28.151  -0.369  23.083  1.00 35.03           C  
ATOM   5797  C   GLY D  94      27.609  -1.354  24.114  1.00 36.75           C  
ATOM   5798  O   GLY D  94      28.310  -1.713  25.052  1.00 37.85           O  
ATOM   5799  N   GLY D  95      26.383  -1.828  23.963  1.00 36.59           N  
ATOM   5800  CA  GLY D  95      25.982  -2.954  24.800  1.00 38.41           C  
ATOM   5801  C   GLY D  95      25.357  -2.530  26.120  1.00 39.45           C  
ATOM   5802  O   GLY D  95      25.173  -3.334  27.014  1.00 40.72           O  
ATOM   5803  N   HIS D  96      25.015  -1.255  26.238  1.00 39.01           N  
ATOM   5804  CA  HIS D  96      24.439  -0.728  27.459  1.00 38.67           C  
ATOM   5805  C   HIS D  96      22.992  -1.132  27.590  1.00 39.73           C  
ATOM   5806  O   HIS D  96      22.521  -1.284  28.710  1.00 40.70           O  
ATOM   5807  CB  HIS D  96      24.596   0.786  27.507  1.00 37.45           C  
ATOM   5808  CG  HIS D  96      26.013   1.232  27.317  1.00 38.04           C  
ATOM   5809  ND1 HIS D  96      26.910   1.334  28.365  1.00 37.45           N  
ATOM   5810  CD2 HIS D  96      26.708   1.533  26.195  1.00 36.20           C  
ATOM   5811  CE1 HIS D  96      28.084   1.711  27.893  1.00 36.57           C  
ATOM   5812  NE2 HIS D  96      27.988   1.837  26.581  1.00 34.70           N  
ATOM   5813  N   ILE D  97      22.307  -1.331  26.453  1.00 39.59           N  
ATOM   5814  CA  ILE D  97      20.905  -1.723  26.477  1.00 40.83           C  
ATOM   5815  C   ILE D  97      20.708  -3.188  26.909  1.00 43.58           C  
ATOM   5816  O   ILE D  97      21.031  -4.144  26.193  1.00 44.03           O  
ATOM   5817  CB  ILE D  97      20.165  -1.429  25.141  1.00 39.68           C  
ATOM   5818  CG1 ILE D  97      20.158   0.072  24.815  1.00 38.29           C  
ATOM   5819  CG2 ILE D  97      18.746  -1.955  25.192  1.00 39.63           C  
ATOM   5820  CD1 ILE D  97      19.053   0.873  25.503  1.00 36.23           C  
ATOM   5821  N   ASP D  98      20.136  -3.335  28.093  1.00 46.32           N  
ATOM   5822  CA  ASP D  98      19.851  -4.628  28.693  1.00 49.76           C  
ATOM   5823  C   ASP D  98      19.057  -5.619  27.862  1.00 50.53           C  
ATOM   5824  O   ASP D  98      19.396  -6.795  27.813  1.00 50.94           O  
ATOM   5825  CB  ASP D  98      19.134  -4.384  30.012  1.00 51.46           C  
ATOM   5826  CG  ASP D  98      19.925  -3.480  30.914  1.00 52.82           C  
ATOM   5827  OD1 ASP D  98      21.169  -3.587  30.902  1.00 51.98           O  
ATOM   5828  OD2 ASP D  98      19.307  -2.658  31.610  1.00 56.49           O  
ATOM   5829  N   LEU D  99      18.003  -5.135  27.213  1.00 50.85           N  
ATOM   5830  CA  LEU D  99      17.057  -6.000  26.535  1.00 51.77           C  
ATOM   5831  C   LEU D  99      16.368  -5.236  25.420  1.00 50.66           C  
ATOM   5832  O   LEU D  99      15.935  -4.089  25.616  1.00 49.37           O  
ATOM   5833  CB  LEU D  99      16.006  -6.537  27.537  1.00 53.67           C  
ATOM   5834  CG  LEU D  99      14.630  -6.992  27.024  1.00 55.64           C  
ATOM   5835  CD1 LEU D  99      14.672  -8.372  26.379  1.00 56.12           C  
ATOM   5836  CD2 LEU D  99      13.587  -6.958  28.130  1.00 60.33           C  
ATOM   5837  N   ALA D 100      16.267  -5.892  24.263  1.00 50.81           N  
ATOM   5838  CA  ALA D 100      15.499  -5.390  23.132  1.00 51.61           C  
ATOM   5839  C   ALA D 100      14.432  -6.376  22.744  1.00 53.83           C  
ATOM   5840  O   ALA D 100      14.704  -7.569  22.610  1.00 54.81           O  
ATOM   5841  CB  ALA D 100      16.412  -5.120  21.911  1.00 50.47           C  
ATOM   5842  N   ILE D 101      13.220  -5.871  22.550  1.00 55.75           N  
ATOM   5843  CA  ILE D 101      12.129  -6.697  22.057  1.00 58.36           C  
ATOM   5844  C   ILE D 101      11.778  -6.248  20.658  1.00 57.79           C  
ATOM   5845  O   ILE D 101      11.619  -5.053  20.425  1.00 57.07           O  
ATOM   5846  CB  ILE D 101      10.882  -6.612  22.949  1.00 59.91           C  
ATOM   5847  CG1 ILE D 101      11.259  -6.803  24.424  1.00 61.16           C  
ATOM   5848  CG2 ILE D 101       9.858  -7.645  22.493  1.00 61.45           C  
ATOM   5849  CD1 ILE D 101      10.082  -6.740  25.380  1.00 63.16           C  
ATOM   5850  N   LEU D 102      11.685  -7.200  19.731  1.00 59.08           N  
ATOM   5851  CA  LEU D 102      11.295  -6.898  18.349  1.00 59.69           C  
ATOM   5852  C   LEU D 102      10.307  -7.918  17.767  1.00 62.98           C  
ATOM   5853  O   LEU D 102      10.162  -9.039  18.273  1.00 64.03           O  
ATOM   5854  CB  LEU D 102      12.514  -6.801  17.428  1.00 57.98           C  
ATOM   5855  CG  LEU D 102      13.708  -5.885  17.684  1.00 54.64           C  
ATOM   5856  CD1 LEU D 102      14.701  -6.533  18.619  1.00 55.26           C  
ATOM   5857  CD2 LEU D 102      14.394  -5.625  16.364  1.00 52.64           C  
ATOM   5858  N   GLY D 103       9.620  -7.493  16.703  1.00 64.68           N  
ATOM   5859  CA  GLY D 103       8.793  -8.364  15.882  1.00 66.59           C  
ATOM   5860  C   GLY D 103       9.631  -9.006  14.793  1.00 67.91           C  
ATOM   5861  O   GLY D 103      10.847  -8.777  14.690  1.00 67.00           O  
ATOM   5862  N   GLY D 104       8.992  -9.821  13.966  1.00 70.65           N  
ATOM   5863  CA  GLY D 104       9.720 -10.524  12.937  1.00 72.98           C  
ATOM   5864  C   GLY D 104       8.780 -11.056  11.906  1.00 75.85           C  
ATOM   5865  O   GLY D 104       7.637 -11.369  12.213  1.00 77.28           O  
ATOM   5866  N   MET D 105       9.266 -11.133  10.672  1.00 77.17           N  
ATOM   5867  CA  MET D 105       8.537 -11.753   9.573  1.00 79.52           C  
ATOM   5868  C   MET D 105       8.921 -13.236   9.507  1.00 81.43           C  
ATOM   5869  O   MET D 105       8.166 -14.051   8.974  1.00 83.62           O  
ATOM   5870  CB  MET D 105       8.872 -11.055   8.249  1.00 78.59           C  
ATOM   5871  CG  MET D 105       8.574  -9.540   8.161  1.00 77.14           C  
ATOM   5872  SD  MET D 105       9.953  -8.580   7.400  1.00 77.39           S  
ATOM   5873  CE  MET D 105       9.057  -7.267   6.561  1.00 75.66           C  
ATOM   5874  N   GLU D 106      10.095 -13.564  10.056  1.00 80.92           N  
ATOM   5875  CA  GLU D 106      10.655 -14.926  10.112  1.00 81.62           C  
ATOM   5876  C   GLU D 106      11.726 -15.022  11.203  1.00 80.07           C  
ATOM   5877  O   GLU D 106      12.420 -14.040  11.490  1.00 78.58           O  
ATOM   5878  CB  GLU D 106      11.329 -15.304   8.785  1.00 81.96           C  
ATOM   5879  CG  GLU D 106      10.421 -15.816   7.679  1.00 85.68           C  
ATOM   5880  CD  GLU D 106      11.085 -15.804   6.293  1.00 86.94           C  
ATOM   5881  OE1 GLU D 106      12.024 -15.002   6.066  1.00 85.37           O  
ATOM   5882  OE2 GLU D 106      10.655 -16.600   5.423  1.00 89.11           O  
ATOM   5883  N   VAL D 107      11.863 -16.205  11.799  1.00 81.27           N  
ATOM   5884  CA  VAL D 107      13.056 -16.558  12.581  1.00 81.17           C  
ATOM   5885  C   VAL D 107      13.543 -17.911  12.058  1.00 83.67           C  
ATOM   5886  O   VAL D 107      12.743 -18.834  11.884  1.00 85.54           O  
ATOM   5887  CB  VAL D 107      12.801 -16.632  14.134  1.00 81.06           C  
ATOM   5888  CG1 VAL D 107      14.072 -16.971  14.885  1.00 79.51           C  
ATOM   5889  CG2 VAL D 107      12.245 -15.338  14.685  1.00 78.26           C  
ATOM   5890  N   SER D 108      14.839 -18.028  11.777  1.00 83.67           N  
ATOM   5891  CA  SER D 108      15.410 -19.313  11.351  1.00 85.36           C  
ATOM   5892  C   SER D 108      15.592 -20.193  12.569  1.00 87.49           C  
ATOM   5893  O   SER D 108      15.287 -19.788  13.685  1.00 86.95           O  
ATOM   5894  CB  SER D 108      16.757 -19.132  10.635  1.00 84.54           C  
ATOM   5895  OG  SER D 108      17.800 -18.827  11.553  1.00 83.50           O  
ATOM   5896  N   GLU D 109      16.116 -21.389  12.346  1.00 90.95           N  
ATOM   5897  CA  GLU D 109      16.348 -22.333  13.421  1.00 93.98           C  
ATOM   5898  C   GLU D 109      17.510 -21.920  14.299  1.00 92.06           C  
ATOM   5899  O   GLU D 109      17.481 -22.168  15.500  1.00 92.74           O  
ATOM   5900  CB  GLU D 109      16.628 -23.709  12.855  1.00 97.03           C  
ATOM   5901  CG  GLU D 109      17.016 -24.729  13.909  1.00102.42           C  
ATOM   5902  CD  GLU D 109      17.676 -25.943  13.311  1.00107.26           C  
ATOM   5903  OE1 GLU D 109      17.032 -26.618  12.477  1.00108.83           O  
ATOM   5904  OE2 GLU D 109      18.844 -26.213  13.669  1.00108.29           O  
ATOM   5905  N   GLN D 110      18.534 -21.306  13.705  1.00 88.93           N  
ATOM   5906  CA  GLN D 110      19.703 -20.844  14.470  1.00 86.06           C  
ATOM   5907  C   GLN D 110      19.400 -19.507  15.146  1.00 82.70           C  
ATOM   5908  O   GLN D 110      20.278 -18.874  15.760  1.00 81.26           O  
ATOM   5909  CB  GLN D 110      20.938 -20.681  13.582  1.00 85.87           C  
ATOM   5910  CG  GLN D 110      20.906 -21.376  12.229  1.00 87.12           C  
ATOM   5911  CD  GLN D 110      21.838 -20.709  11.209  1.00 86.23           C  
ATOM   5912  OE1 GLN D 110      22.275 -19.546  11.377  1.00 84.08           O  
ATOM   5913  NE2 GLN D 110      22.144 -21.446  10.139  1.00 87.21           N  
ATOM   5914  N   GLY D 111      18.148 -19.078  15.024  1.00 80.79           N  
ATOM   5915  CA  GLY D 111      17.741 -17.789  15.529  1.00 77.40           C  
ATOM   5916  C   GLY D 111      18.273 -16.654  14.672  1.00 74.37           C  
ATOM   5917  O   GLY D 111      18.804 -15.681  15.194  1.00 73.08           O  
ATOM   5918  N   ASP D 112      18.161 -16.779  13.355  1.00 73.42           N  
ATOM   5919  CA  ASP D 112      18.321 -15.609  12.513  1.00 71.59           C  
ATOM   5920  C   ASP D 112      16.980 -14.896  12.492  1.00 70.11           C  
ATOM   5921  O   ASP D 112      15.927 -15.538  12.559  1.00 71.06           O  
ATOM   5922  CB  ASP D 112      18.742 -15.976  11.094  1.00 72.35           C  
ATOM   5923  CG  ASP D 112      19.982 -16.848  11.053  1.00 74.92           C  
ATOM   5924  OD1 ASP D 112      20.724 -16.919  12.063  1.00 76.65           O  
ATOM   5925  OD2 ASP D 112      20.209 -17.483   9.998  1.00 78.12           O  
ATOM   5926  N   LEU D 113      17.015 -13.573  12.412  1.00 66.86           N  
ATOM   5927  CA  LEU D 113      15.788 -12.805  12.294  1.00 65.13           C  
ATOM   5928  C   LEU D 113      15.732 -12.037  10.982  1.00 64.64           C  
ATOM   5929  O   LEU D 113      16.729 -11.475  10.534  1.00 63.97           O  
ATOM   5930  CB  LEU D 113      15.615 -11.857  13.483  1.00 63.65           C  
ATOM   5931  CG  LEU D 113      14.401 -10.926  13.447  1.00 61.73           C  
ATOM   5932  CD1 LEU D 113      13.153 -11.635  13.962  1.00 60.66           C  
ATOM   5933  CD2 LEU D 113      14.709  -9.683  14.247  1.00 57.95           C  
ATOM   5934  N   ALA D 114      14.558 -12.049  10.363  1.00 66.08           N  
ATOM   5935  CA  ALA D 114      14.241 -11.142   9.275  1.00 66.35           C  
ATOM   5936  C   ALA D 114      13.017 -10.358   9.732  1.00 66.39           C  
ATOM   5937  O   ALA D 114      11.968 -10.951  10.014  1.00 67.51           O  
ATOM   5938  CB  ALA D 114      13.930 -11.919   8.012  1.00 67.32           C  
ATOM   5939  N   ASN D 115      13.153  -9.036   9.831  1.00 64.32           N  
ATOM   5940  CA  ASN D 115      12.005  -8.186  10.143  1.00 63.23           C  
ATOM   5941  C   ASN D 115      11.979  -6.841   9.425  1.00 61.88           C  
ATOM   5942  O   ASN D 115      11.203  -5.973   9.799  1.00 62.13           O  
ATOM   5943  CB  ASN D 115      11.830  -8.001  11.663  1.00 63.26           C  
ATOM   5944  CG  ASN D 115      12.826  -6.996  12.285  1.00 62.45           C  
ATOM   5945  OD1 ASN D 115      13.508  -6.230  11.596  1.00 61.87           O  
ATOM   5946  ND2 ASN D 115      12.883  -6.990  13.612  1.00 63.85           N  
ATOM   5947  N   TRP D 116      12.803  -6.659   8.397  1.00 60.68           N  
ATOM   5948  CA  TRP D 116      12.854  -5.354   7.733  1.00 59.42           C  
ATOM   5949  C   TRP D 116      12.366  -5.252   6.300  1.00 60.76           C  
ATOM   5950  O   TRP D 116      12.112  -4.132   5.851  1.00 60.63           O  
ATOM   5951  CB  TRP D 116      14.245  -4.729   7.834  1.00 58.03           C  
ATOM   5952  CG  TRP D 116      15.305  -5.403   7.009  1.00 57.12           C  
ATOM   5953  CD1 TRP D 116      15.898  -6.600   7.268  1.00 57.32           C  
ATOM   5954  CD2 TRP D 116      15.912  -4.905   5.807  1.00 55.98           C  
ATOM   5955  NE1 TRP D 116      16.818  -6.893   6.295  1.00 57.65           N  
ATOM   5956  CE2 TRP D 116      16.855  -5.868   5.389  1.00 56.25           C  
ATOM   5957  CE3 TRP D 116      15.749  -3.744   5.045  1.00 56.19           C  
ATOM   5958  CZ2 TRP D 116      17.635  -5.710   4.245  1.00 56.42           C  
ATOM   5959  CZ3 TRP D 116      16.535  -3.582   3.902  1.00 56.19           C  
ATOM   5960  CH2 TRP D 116      17.460  -4.567   3.515  1.00 56.62           C  
ATOM   5961  N   MET D 117      12.244  -6.362   5.568  1.00 62.88           N  
ATOM   5962  CA  MET D 117      11.899  -6.231   4.143  1.00 65.49           C  
ATOM   5963  C   MET D 117      11.310  -7.452   3.423  1.00 68.28           C  
ATOM   5964  O   MET D 117      11.631  -8.596   3.733  1.00 69.03           O  
ATOM   5965  CB  MET D 117      13.128  -5.730   3.374  1.00 64.59           C  
ATOM   5966  CG  MET D 117      12.885  -5.459   1.923  1.00 65.33           C  
ATOM   5967  SD  MET D 117      14.349  -5.861   0.977  1.00 66.25           S  
ATOM   5968  CE  MET D 117      13.755  -5.650  -0.700  1.00 65.80           C  
ATOM   5969  N   ILE D 118      10.444  -7.183   2.447  1.00 71.18           N  
ATOM   5970  CA  ILE D 118       9.977  -8.211   1.503  1.00 74.35           C  
ATOM   5971  C   ILE D 118      10.313  -7.818   0.071  1.00 74.80           C  
ATOM   5972  O   ILE D 118       9.739  -6.859  -0.457  1.00 74.44           O  
ATOM   5973  CB  ILE D 118       8.466  -8.485   1.609  1.00 75.88           C  
ATOM   5974  CG1 ILE D 118       8.153  -9.169   2.949  1.00 77.26           C  
ATOM   5975  CG2 ILE D 118       7.990  -9.332   0.403  1.00 77.65           C  
ATOM   5976  CD1 ILE D 118       6.670  -9.256   3.315  1.00 77.18           C  
ATOM   5977  N   PRO D 119      11.247  -8.564  -0.560  1.00 76.21           N  
ATOM   5978  CA  PRO D 119      11.645  -8.368  -1.960  1.00 77.90           C  
ATOM   5979  C   PRO D 119      10.418  -8.110  -2.804  1.00 80.02           C  
ATOM   5980  O   PRO D 119       9.441  -8.856  -2.696  1.00 81.42           O  
ATOM   5981  CB  PRO D 119      12.274  -9.711  -2.332  1.00 78.55           C  
ATOM   5982  CG  PRO D 119      12.917 -10.154  -1.046  1.00 77.21           C  
ATOM   5983  CD  PRO D 119      11.988  -9.682   0.059  1.00 76.10           C  
ATOM   5984  N   GLY D 120      10.464  -7.051  -3.613  1.00 80.56           N  
ATOM   5985  CA  GLY D 120       9.275  -6.540  -4.299  1.00 82.14           C  
ATOM   5986  C   GLY D 120       8.293  -5.905  -3.319  1.00 82.21           C  
ATOM   5987  O   GLY D 120       7.283  -5.322  -3.712  1.00 82.80           O  
ATOM   5988  N   MET D 122       7.233  -4.400  -0.568  1.00 82.12           N  
ATOM   5989  CA  MET D 122       7.245  -3.747   0.738  1.00 80.68           C  
ATOM   5990  C   MET D 122       8.664  -3.573   1.297  1.00 78.26           C  
ATOM   5991  O   MET D 122       9.316  -4.543   1.698  1.00 77.97           O  
ATOM   5992  CB  MET D 122       6.371  -4.523   1.728  1.00 81.62           C  
ATOM   5993  CG  MET D 122       6.157  -3.805   3.055  1.00 80.94           C  
ATOM   5994  SD  MET D 122       7.419  -4.169   4.301  1.00 77.69           S  
ATOM   5995  CE  MET D 122       6.557  -5.387   5.287  1.00 78.98           C  
ATOM   5996  N   VAL D 123       9.137  -2.328   1.335  1.00 75.51           N  
ATOM   5997  CA  VAL D 123      10.463  -2.050   1.870  1.00 72.67           C  
ATOM   5998  C   VAL D 123      10.469  -0.847   2.802  1.00 70.87           C  
ATOM   5999  O   VAL D 123      10.894   0.246   2.416  1.00 71.05           O  
ATOM   6000  CB  VAL D 123      11.510  -1.821   0.762  1.00 72.51           C  
ATOM   6001  CG1 VAL D 123      12.901  -1.731   1.377  1.00 72.65           C  
ATOM   6002  CG2 VAL D 123      11.469  -2.940  -0.262  1.00 74.14           C  
ATOM   6003  N   LYS D 124      10.015  -1.055   4.033  1.00 68.82           N  
ATOM   6004  CA  LYS D 124      10.087  -0.023   5.058  1.00 66.51           C  
ATOM   6005  C   LYS D 124      11.530   0.340   5.396  1.00 63.52           C  
ATOM   6006  O   LYS D 124      11.888   1.521   5.420  1.00 63.68           O  
ATOM   6007  CB  LYS D 124       9.335  -0.450   6.326  1.00 67.21           C  
ATOM   6008  CG  LYS D 124       7.810  -0.316   6.210  1.00 70.07           C  
ATOM   6009  CD  LYS D 124       7.414   0.633   5.062  1.00 71.99           C  
ATOM   6010  CE  LYS D 124       5.894   0.772   4.953  1.00 74.23           C  
ATOM   6011  NZ  LYS D 124       5.498   1.803   3.944  1.00 75.48           N  
ATOM   6012  N   GLY D 125      12.356  -0.673   5.656  1.00 60.82           N  
ATOM   6013  CA  GLY D 125      13.762  -0.446   5.970  1.00 56.80           C  
ATOM   6014  C   GLY D 125      14.105  -0.792   7.407  1.00 54.20           C  
ATOM   6015  O   GLY D 125      13.223  -0.910   8.260  1.00 54.09           O  
ATOM   6016  N   MET D 126      15.397  -0.941   7.677  1.00 51.16           N  
ATOM   6017  CA  MET D 126      15.842  -1.580   8.911  1.00 48.61           C  
ATOM   6018  C   MET D 126      15.684  -0.694  10.142  1.00 47.14           C  
ATOM   6019  O   MET D 126      15.451  -1.198  11.242  1.00 47.39           O  
ATOM   6020  CB  MET D 126      17.289  -2.069   8.781  1.00 47.59           C  
ATOM   6021  CG  MET D 126      18.317  -0.962   8.684  1.00 45.59           C  
ATOM   6022  SD  MET D 126      18.743  -0.523   6.988  1.00 44.35           S  
ATOM   6023  CE  MET D 126      19.052  -2.126   6.257  1.00 43.66           C  
ATOM   6024  N   GLY D 127      15.792   0.618   9.956  1.00 45.20           N  
ATOM   6025  CA  GLY D 127      15.846   1.546  11.078  1.00 43.24           C  
ATOM   6026  C   GLY D 127      16.922   1.137  12.077  1.00 42.31           C  
ATOM   6027  O   GLY D 127      18.060   0.803  11.696  1.00 42.17           O  
ATOM   6028  N   GLY D 128      16.562   1.130  13.359  1.00 41.52           N  
ATOM   6029  CA  GLY D 128      17.501   0.766  14.421  1.00 40.65           C  
ATOM   6030  C   GLY D 128      17.659  -0.725  14.687  1.00 40.82           C  
ATOM   6031  O   GLY D 128      18.548  -1.115  15.458  1.00 40.45           O  
ATOM   6032  N   ALA D 129      16.827  -1.551  14.038  1.00 41.30           N  
ATOM   6033  CA  ALA D 129      16.806  -3.007  14.270  1.00 42.52           C  
ATOM   6034  C   ALA D 129      18.164  -3.737  14.259  1.00 42.51           C  
ATOM   6035  O   ALA D 129      18.472  -4.506  15.184  1.00 42.91           O  
ATOM   6036  CB  ALA D 129      15.853  -3.684  13.315  1.00 43.39           C  
ATOM   6037  N   MET D 130      18.956  -3.500  13.211  1.00 41.46           N  
ATOM   6038  CA  MET D 130      20.262  -4.124  13.043  1.00 40.99           C  
ATOM   6039  C   MET D 130      21.228  -3.804  14.177  1.00 40.25           C  
ATOM   6040  O   MET D 130      21.998  -4.676  14.605  1.00 41.29           O  
ATOM   6041  CB  MET D 130      20.870  -3.750  11.679  1.00 41.06           C  
ATOM   6042  CG  MET D 130      20.094  -4.340  10.488  1.00 43.35           C  
ATOM   6043  SD  MET D 130      21.027  -4.491   8.959  1.00 43.87           S  
ATOM   6044  CE  MET D 130      19.882  -5.430   7.940  1.00 47.18           C  
ATOM   6045  N   ASP D 131      21.194  -2.565  14.661  1.00 38.77           N  
ATOM   6046  CA  ASP D 131      22.059  -2.137  15.760  1.00 38.05           C  
ATOM   6047  C   ASP D 131      21.595  -2.809  17.036  1.00 38.87           C  
ATOM   6048  O   ASP D 131      22.395  -3.323  17.825  1.00 39.75           O  
ATOM   6049  CB  ASP D 131      22.002  -0.617  15.924  1.00 37.16           C  
ATOM   6050  CG  ASP D 131      22.845   0.123  14.894  1.00 35.80           C  
ATOM   6051  OD1 ASP D 131      24.067   0.310  15.137  1.00 34.68           O  
ATOM   6052  OD2 ASP D 131      22.283   0.538  13.853  1.00 34.73           O  
ATOM   6053  N   LEU D 132      20.284  -2.798  17.220  1.00 39.77           N  
ATOM   6054  CA  LEU D 132      19.645  -3.388  18.379  1.00 41.43           C  
ATOM   6055  C   LEU D 132      20.025  -4.842  18.498  1.00 42.31           C  
ATOM   6056  O   LEU D 132      20.588  -5.269  19.497  1.00 43.32           O  
ATOM   6057  CB  LEU D 132      18.134  -3.248  18.243  1.00 42.28           C  
ATOM   6058  CG  LEU D 132      17.323  -2.171  18.987  1.00 42.43           C  
ATOM   6059  CD1 LEU D 132      18.158  -1.132  19.612  1.00 42.69           C  
ATOM   6060  CD2 LEU D 132      16.249  -1.558  18.065  1.00 44.08           C  
ATOM   6061  N   VAL D 133      19.768  -5.575  17.433  1.00 43.29           N  
ATOM   6062  CA  VAL D 133      20.008  -7.006  17.355  1.00 44.69           C  
ATOM   6063  C   VAL D 133      21.473  -7.418  17.613  1.00 44.29           C  
ATOM   6064  O   VAL D 133      21.736  -8.514  18.087  1.00 44.58           O  
ATOM   6065  CB  VAL D 133      19.411  -7.525  16.008  1.00 45.32           C  
ATOM   6066  CG1 VAL D 133      20.434  -8.199  15.122  1.00 45.56           C  
ATOM   6067  CG2 VAL D 133      18.169  -8.399  16.263  1.00 46.18           C  
ATOM   6068  N   ASN D 134      22.419  -6.521  17.318  1.00 43.41           N  
ATOM   6069  CA  ASN D 134      23.836  -6.805  17.548  1.00 42.89           C  
ATOM   6070  C   ASN D 134      24.414  -6.186  18.841  1.00 42.45           C  
ATOM   6071  O   ASN D 134      25.502  -6.561  19.255  1.00 42.84           O  
ATOM   6072  CB  ASN D 134      24.695  -6.432  16.320  1.00 42.58           C  
ATOM   6073  CG  ASN D 134      24.268  -7.164  15.041  1.00 44.23           C  
ATOM   6074  OD1 ASN D 134      24.221  -8.401  14.984  1.00 45.08           O  
ATOM   6075  ND2 ASN D 134      23.956  -6.393  14.000  1.00 44.56           N  
ATOM   6076  N   GLY D 135      23.698  -5.266  19.490  1.00 41.93           N  
ATOM   6077  CA  GLY D 135      24.240  -4.593  20.683  1.00 42.10           C  
ATOM   6078  C   GLY D 135      23.508  -4.847  21.997  1.00 43.28           C  
ATOM   6079  O   GLY D 135      24.094  -4.805  23.089  1.00 42.56           O  
ATOM   6080  N   ALA D 136      22.205  -5.088  21.903  1.00 44.64           N  
ATOM   6081  CA  ALA D 136      21.451  -5.447  23.095  1.00 46.78           C  
ATOM   6082  C   ALA D 136      21.988  -6.784  23.568  1.00 48.74           C  
ATOM   6083  O   ALA D 136      22.368  -7.641  22.760  1.00 48.75           O  
ATOM   6084  CB  ALA D 136      19.974  -5.518  22.813  1.00 46.77           C  
ATOM   6085  N   LYS D 137      22.064  -6.940  24.879  1.00 50.97           N  
ATOM   6086  CA  LYS D 137      22.638  -8.140  25.425  1.00 53.84           C  
ATOM   6087  C   LYS D 137      21.622  -9.248  25.383  1.00 55.75           C  
ATOM   6088  O   LYS D 137      21.977 -10.410  25.313  1.00 56.90           O  
ATOM   6089  CB  LYS D 137      23.141  -7.886  26.836  1.00 54.78           C  
ATOM   6090  CG  LYS D 137      22.387  -6.817  27.583  1.00 54.52           C  
ATOM   6091  CD  LYS D 137      23.089  -6.492  28.906  1.00 54.20           C  
ATOM   6092  CE  LYS D 137      23.912  -5.228  28.755  1.00 50.26           C  
ATOM   6093  NZ  LYS D 137      24.654  -4.933  29.990  1.00 46.80           N  
ATOM   6094  N   ARG D 138      20.352  -8.858  25.358  1.00 56.95           N  
ATOM   6095  CA  ARG D 138      19.232  -9.779  25.357  1.00 59.29           C  
ATOM   6096  C   ARG D 138      18.277  -9.445  24.194  1.00 58.58           C  
ATOM   6097  O   ARG D 138      17.751  -8.332  24.119  1.00 57.92           O  
ATOM   6098  CB  ARG D 138      18.539  -9.678  26.721  1.00 60.62           C  
ATOM   6099  CG  ARG D 138      17.335 -10.543  26.911  1.00 64.85           C  
ATOM   6100  CD  ARG D 138      17.702 -11.869  27.523  1.00 70.33           C  
ATOM   6101  NE  ARG D 138      16.519 -12.703  27.728  1.00 73.17           N  
ATOM   6102  CZ  ARG D 138      16.562 -14.023  27.838  1.00 77.82           C  
ATOM   6103  NH1 ARG D 138      17.729 -14.648  27.757  1.00 78.63           N  
ATOM   6104  NH2 ARG D 138      15.444 -14.724  28.024  1.00 80.78           N  
ATOM   6105  N   ILE D 139      18.076 -10.407  23.285  1.00 59.28           N  
ATOM   6106  CA  ILE D 139      17.199 -10.247  22.111  1.00 58.87           C  
ATOM   6107  C   ILE D 139      15.943 -11.121  22.191  1.00 61.85           C  
ATOM   6108  O   ILE D 139      16.014 -12.363  22.181  1.00 62.99           O  
ATOM   6109  CB  ILE D 139      17.926 -10.582  20.811  1.00 57.61           C  
ATOM   6110  CG1 ILE D 139      19.128  -9.645  20.575  1.00 55.29           C  
ATOM   6111  CG2 ILE D 139      16.968 -10.506  19.646  1.00 57.60           C  
ATOM   6112  CD1 ILE D 139      18.784  -8.174  20.314  1.00 50.60           C  
ATOM   6113  N   VAL D 140      14.788 -10.464  22.259  1.00 62.88           N  
ATOM   6114  CA  VAL D 140      13.522 -11.164  22.348  1.00 65.79           C  
ATOM   6115  C   VAL D 140      12.563 -10.761  21.217  1.00 65.94           C  
ATOM   6116  O   VAL D 140      12.242  -9.579  21.051  1.00 65.02           O  
ATOM   6117  CB  VAL D 140      12.866 -10.983  23.738  1.00 66.45           C  
ATOM   6118  CG1 VAL D 140      11.520 -11.718  23.802  1.00 70.10           C  
ATOM   6119  CG2 VAL D 140      13.766 -11.526  24.822  1.00 67.43           C  
ATOM   6120  N   VAL D 141      12.124 -11.759  20.444  1.00 68.16           N  
ATOM   6121  CA  VAL D 141      11.157 -11.559  19.364  1.00 69.78           C  
ATOM   6122  C   VAL D 141       9.772 -12.030  19.784  1.00 73.23           C  
ATOM   6123  O   VAL D 141       9.599 -13.172  20.224  1.00 74.68           O  
ATOM   6124  CB  VAL D 141      11.563 -12.310  18.061  1.00 69.60           C  
ATOM   6125  CG1 VAL D 141      10.583 -12.019  16.925  1.00 69.50           C  
ATOM   6126  CG2 VAL D 141      12.976 -11.964  17.639  1.00 67.23           C  
ATOM   6127  N   ILE D 142       8.791 -11.142  19.671  1.00 75.02           N  
ATOM   6128  CA  ILE D 142       7.395 -11.572  19.729  1.00 78.60           C  
ATOM   6129  C   ILE D 142       6.749 -11.396  18.352  1.00 79.94           C  
ATOM   6130  O   ILE D 142       6.789 -10.329  17.745  1.00 78.75           O  
ATOM   6131  CB  ILE D 142       6.589 -10.955  20.924  1.00 78.88           C  
ATOM   6132  CG1 ILE D 142       5.857  -9.666  20.556  1.00 77.86           C  
ATOM   6133  CG2 ILE D 142       7.512 -10.714  22.111  1.00 79.43           C  
ATOM   6134  CD1 ILE D 142       6.673  -8.408  20.756  1.00 74.16           C  
ATOM   6135  N   MET D 143       6.196 -12.485  17.846  1.00 83.81           N  
ATOM   6136  CA  MET D 143       5.776 -12.548  16.463  1.00 86.85           C  
ATOM   6137  C   MET D 143       4.712 -13.629  16.345  1.00 91.82           C  
ATOM   6138  O   MET D 143       4.791 -14.657  17.031  1.00 93.47           O  
ATOM   6139  CB  MET D 143       6.992 -12.870  15.587  1.00 85.33           C  
ATOM   6140  CG  MET D 143       6.686 -13.404  14.194  1.00 85.53           C  
ATOM   6141  SD  MET D 143       8.088 -14.143  13.321  1.00 85.41           S  
ATOM   6142  CE  MET D 143       8.521 -15.491  14.428  1.00 85.67           C  
ATOM   6143  N   GLU D 144       3.710 -13.391  15.494  1.00 95.52           N  
ATOM   6144  CA  GLU D 144       2.718 -14.417  15.177  1.00100.43           C  
ATOM   6145  C   GLU D 144       3.411 -15.622  14.546  1.00102.38           C  
ATOM   6146  O   GLU D 144       4.376 -15.464  13.803  1.00101.17           O  
ATOM   6147  CB  GLU D 144       1.647 -13.868  14.238  1.00101.18           C  
ATOM   6148  CG  GLU D 144       0.758 -12.808  14.864  1.00102.87           C  
ATOM   6149  CD  GLU D 144      -0.412 -12.448  13.978  1.00105.35           C  
ATOM   6150  OE1 GLU D 144      -1.204 -13.355  13.639  1.00109.02           O  
ATOM   6151  OE2 GLU D 144      -0.546 -11.258  13.620  1.00105.15           O  
ATOM   6152  N   HIS D 145       2.922 -16.822  14.840  1.00106.92           N  
ATOM   6153  CA  HIS D 145       3.641 -18.039  14.471  1.00110.25           C  
ATOM   6154  C   HIS D 145       3.556 -18.374  12.972  1.00111.39           C  
ATOM   6155  O   HIS D 145       4.530 -18.871  12.401  1.00111.10           O  
ATOM   6156  CB  HIS D 145       3.168 -19.202  15.345  1.00112.90           C  
ATOM   6157  CG  HIS D 145       4.008 -20.442  15.242  1.00115.80           C  
ATOM   6158  ND1 HIS D 145       4.830 -20.863  16.274  1.00116.87           N  
ATOM   6159  CD2 HIS D 145       4.110 -21.379  14.255  1.00119.21           C  
ATOM   6160  CE1 HIS D 145       5.419 -21.994  15.920  1.00118.60           C  
ATOM   6161  NE2 HIS D 145       4.999 -22.330  14.699  1.00119.78           N  
ATOM   6162  N   VAL D 146       2.413 -18.085  12.342  1.00113.52           N  
ATOM   6163  CA  VAL D 146       2.174 -18.415  10.925  1.00115.89           C  
ATOM   6164  C   VAL D 146       1.674 -17.193  10.132  1.00113.58           C  
ATOM   6165  O   VAL D 146       1.220 -16.206  10.719  1.00112.48           O  
ATOM   6166  CB  VAL D 146       1.185 -19.602  10.794  1.00119.18           C  
ATOM   6167  CG1 VAL D 146       0.866 -19.923   9.326  1.00121.92           C  
ATOM   6168  CG2 VAL D 146       1.742 -20.838  11.497  1.00121.70           C  
ATOM   6169  N   ASN D 147       1.780 -17.256   8.804  1.00113.07           N  
ATOM   6170  CA  ASN D 147       1.297 -16.187   7.926  1.00113.11           C  
ATOM   6171  C   ASN D 147      -0.234 -16.164   7.757  1.00115.50           C  
ATOM   6172  O   ASN D 147      -0.889 -17.204   7.643  1.00117.94           O  
ATOM   6173  CB  ASN D 147       1.996 -16.259   6.562  1.00112.17           C  
ATOM   6174  CG  ASN D 147       1.670 -17.531   5.807  1.00114.41           C  
ATOM   6175  OD1 ASN D 147       0.588 -17.665   5.238  1.00117.06           O  
ATOM   6176  ND2 ASN D 147       2.609 -18.471   5.795  1.00114.73           N  
ATOM   6177  N   SER D 152       3.685 -20.651   7.453  1.00104.21           N  
ATOM   6178  CA  SER D 152       4.479 -20.599   8.683  1.00102.42           C  
ATOM   6179  C   SER D 152       5.592 -19.543   8.641  1.00 98.61           C  
ATOM   6180  O   SER D 152       6.050 -19.129   7.567  1.00 97.09           O  
ATOM   6181  CB  SER D 152       5.095 -21.974   8.988  1.00104.67           C  
ATOM   6182  OG  SER D 152       6.050 -21.836  10.121  1.00103.39           O  
ATOM   6183  N   LYS D 153       6.031 -19.135   9.831  1.00 94.81           N  
ATOM   6184  CA  LYS D 153       7.008 -18.081   9.992  1.00 90.48           C  
ATOM   6185  C   LYS D 153       8.204 -18.542  10.818  1.00 89.72           C  
ATOM   6186  O   LYS D 153       9.199 -17.816  10.948  1.00 87.36           O  
ATOM   6187  CB  LYS D 153       6.359 -16.873  10.655  1.00 89.44           C  
ATOM   6188  CG  LYS D 153       5.152 -16.334   9.917  1.00 89.13           C  
ATOM   6189  CD  LYS D 153       4.451 -15.262  10.720  1.00 87.57           C  
ATOM   6190  CE  LYS D 153       5.236 -13.978  10.713  1.00 85.30           C  
ATOM   6191  NZ  LYS D 153       4.592 -12.948  11.561  1.00 86.46           N  
ATOM   6192  N   VAL D 154       8.103 -19.745  11.378  1.00 92.51           N  
ATOM   6193  CA  VAL D 154       9.207 -20.319  12.154  1.00 94.24           C  
ATOM   6194  C   VAL D 154       9.967 -21.309  11.282  1.00 95.61           C  
ATOM   6195  O   VAL D 154       9.602 -22.484  11.167  1.00 97.66           O  
ATOM   6196  CB  VAL D 154       8.734 -20.974  13.468  1.00 95.69           C  
ATOM   6197  CG1 VAL D 154       9.926 -21.197  14.393  1.00 94.97           C  
ATOM   6198  CG2 VAL D 154       7.683 -20.102  14.151  1.00 95.00           C  
ATOM   6199  N   LYS D 155      11.041 -20.800  10.690  1.00 93.79           N  
ATOM   6200  CA  LYS D 155      11.681 -21.411   9.533  1.00 93.94           C  
ATOM   6201  C   LYS D 155      12.876 -22.259   9.904  1.00 95.41           C  
ATOM   6202  O   LYS D 155      13.518 -22.032  10.926  1.00 94.91           O  
ATOM   6203  CB  LYS D 155      12.170 -20.316   8.572  1.00 91.81           C  
ATOM   6204  CG  LYS D 155      11.086 -19.479   7.929  1.00 90.99           C  
ATOM   6205  CD  LYS D 155      10.470 -20.204   6.767  1.00 91.89           C  
ATOM   6206  CE  LYS D 155       9.375 -19.387   6.147  1.00 92.49           C  
ATOM   6207  NZ  LYS D 155       8.794 -20.143   5.013  1.00 94.83           N  
ATOM   6208  N   LYS D 156      13.182 -23.223   9.045  1.00 98.48           N  
ATOM   6209  CA  LYS D 156      14.454 -23.917   9.128  1.00100.24           C  
ATOM   6210  C   LYS D 156      15.557 -23.037   8.561  1.00 96.86           C  
ATOM   6211  O   LYS D 156      16.652 -22.971   9.120  1.00 95.82           O  
ATOM   6212  CB  LYS D 156      14.394 -25.288   8.439  1.00103.68           C  
ATOM   6213  CG  LYS D 156      14.245 -26.431   9.443  1.00108.95           C  
ATOM   6214  CD  LYS D 156      14.100 -27.798   8.795  1.00116.30           C  
ATOM   6215  CE  LYS D 156      14.372 -28.890   9.824  1.00119.99           C  
ATOM   6216  NZ  LYS D 156      13.988 -30.254   9.364  1.00123.21           N  
ATOM   6217  N   THR D 157      15.252 -22.351   7.462  1.00 94.65           N  
ATOM   6218  CA  THR D 157      16.141 -21.328   6.899  1.00 91.53           C  
ATOM   6219  C   THR D 157      15.295 -20.123   6.481  1.00 88.80           C  
ATOM   6220  O   THR D 157      14.196 -20.296   5.966  1.00 89.62           O  
ATOM   6221  CB  THR D 157      16.988 -21.902   5.710  1.00 92.47           C  
ATOM   6222  OG1 THR D 157      18.259 -21.248   5.656  1.00 90.76           O  
ATOM   6223  CG2 THR D 157      16.272 -21.800   4.345  1.00 92.71           C  
ATOM   6224  N   CYS D 158      15.782 -18.910   6.719  1.00 84.77           N  
ATOM   6225  CA  CYS D 158      15.028 -17.710   6.329  1.00 82.09           C  
ATOM   6226  C   CYS D 158      14.945 -17.549   4.808  1.00 82.37           C  
ATOM   6227  O   CYS D 158      15.821 -18.032   4.085  1.00 83.36           O  
ATOM   6228  CB  CYS D 158      15.648 -16.459   6.935  1.00 79.65           C  
ATOM   6229  SG  CYS D 158      15.595 -16.389   8.736  1.00 80.80           S  
ATOM   6230  N   SER D 159      13.892 -16.891   4.324  1.00 82.08           N  
ATOM   6231  CA  SER D 159      13.824 -16.526   2.909  1.00 81.50           C  
ATOM   6232  C   SER D 159      14.000 -15.022   2.749  1.00 78.03           C  
ATOM   6233  O   SER D 159      14.823 -14.572   1.957  1.00 77.50           O  
ATOM   6234  CB  SER D 159      12.541 -17.033   2.235  1.00 83.59           C  
ATOM   6235  OG  SER D 159      11.384 -16.461   2.807  1.00 84.82           O  
ATOM   6236  N   LEU D 160      13.254 -14.251   3.530  1.00 74.66           N  
ATOM   6237  CA  LEU D 160      13.378 -12.794   3.509  1.00 71.02           C  
ATOM   6238  C   LEU D 160      14.776 -12.339   3.966  1.00 67.82           C  
ATOM   6239  O   LEU D 160      15.424 -13.045   4.748  1.00 68.35           O  
ATOM   6240  CB  LEU D 160      12.291 -12.159   4.388  1.00 70.69           C  
ATOM   6241  CG  LEU D 160      10.827 -12.507   4.100  1.00 72.59           C  
ATOM   6242  CD1 LEU D 160       9.925 -11.791   5.096  1.00 71.09           C  
ATOM   6243  CD2 LEU D 160      10.399 -12.224   2.633  1.00 72.29           C  
ATOM   6244  N   PRO D 161      15.254 -11.171   3.475  1.00 64.40           N  
ATOM   6245  CA  PRO D 161      16.570 -10.655   3.893  1.00 61.16           C  
ATOM   6246  C   PRO D 161      16.694 -10.559   5.410  1.00 59.21           C  
ATOM   6247  O   PRO D 161      15.761 -10.098   6.063  1.00 58.94           O  
ATOM   6248  CB  PRO D 161      16.615  -9.258   3.273  1.00 59.81           C  
ATOM   6249  CG  PRO D 161      15.733  -9.343   2.099  1.00 62.30           C  
ATOM   6250  CD  PRO D 161      14.616 -10.285   2.484  1.00 64.15           C  
ATOM   6251  N   LEU D 162      17.838 -10.992   5.942  1.00 57.95           N  
ATOM   6252  CA  LEU D 162      18.110 -11.050   7.384  1.00 56.53           C  
ATOM   6253  C   LEU D 162      18.317  -9.689   7.997  1.00 53.88           C  
ATOM   6254  O   LEU D 162      19.000  -8.861   7.426  1.00 53.29           O  
ATOM   6255  CB  LEU D 162      19.343 -11.919   7.678  1.00 57.23           C  
ATOM   6256  CG  LEU D 162      19.183 -13.440   7.565  1.00 60.40           C  
ATOM   6257  CD1 LEU D 162      20.426 -14.203   8.028  1.00 60.43           C  
ATOM   6258  CD2 LEU D 162      17.945 -13.912   8.349  1.00 63.98           C  
ATOM   6259  N   THR D 163      17.704  -9.475   9.159  1.00 52.65           N  
ATOM   6260  CA  THR D 163      17.937  -8.311  10.007  1.00 50.86           C  
ATOM   6261  C   THR D 163      19.219  -8.589  10.774  1.00 51.04           C  
ATOM   6262  O   THR D 163      20.063  -7.696  10.999  1.00 48.31           O  
ATOM   6263  CB  THR D 163      16.794  -8.157  11.038  1.00 50.67           C  
ATOM   6264  OG1 THR D 163      15.589  -7.821  10.351  1.00 51.81           O  
ATOM   6265  CG2 THR D 163      17.093  -7.072  12.049  1.00 48.02           C  
ATOM   6266  N   GLY D 164      19.330  -9.860  11.157  1.00 53.08           N  
ATOM   6267  CA  GLY D 164      20.396 -10.352  12.006  1.00 55.65           C  
ATOM   6268  C   GLY D 164      20.520 -11.857  11.923  1.00 58.46           C  
ATOM   6269  O   GLY D 164      19.546 -12.581  11.668  1.00 59.21           O  
ATOM   6270  N   GLN D 165      21.736 -12.323  12.166  1.00 60.12           N  
ATOM   6271  CA  GLN D 165      22.076 -13.713  11.973  1.00 62.76           C  
ATOM   6272  C   GLN D 165      22.585 -14.293  13.288  1.00 63.67           C  
ATOM   6273  O   GLN D 165      23.624 -13.880  13.803  1.00 63.19           O  
ATOM   6274  CB  GLN D 165      23.121 -13.774  10.869  1.00 63.04           C  
ATOM   6275  CG  GLN D 165      23.801 -15.080  10.642  1.00 66.33           C  
ATOM   6276  CD  GLN D 165      24.869 -14.925   9.593  1.00 69.51           C  
ATOM   6277  OE1 GLN D 165      25.885 -14.266   9.823  1.00 71.42           O  
ATOM   6278  NE2 GLN D 165      24.634 -15.492   8.419  1.00 71.95           N  
ATOM   6279  N   LYS D 166      21.820 -15.239  13.823  1.00 65.85           N  
ATOM   6280  CA  LYS D 166      22.100 -15.898  15.105  1.00 67.08           C  
ATOM   6281  C   LYS D 166      22.031 -14.888  16.239  1.00 64.63           C  
ATOM   6282  O   LYS D 166      22.912 -14.844  17.096  1.00 64.50           O  
ATOM   6283  CB  LYS D 166      23.464 -16.608  15.112  1.00 68.77           C  
ATOM   6284  CG  LYS D 166      23.724 -17.588  13.958  1.00 73.00           C  
ATOM   6285  CD  LYS D 166      24.455 -18.861  14.425  1.00 78.18           C  
ATOM   6286  CE  LYS D 166      25.681 -18.584  15.308  1.00 79.52           C  
ATOM   6287  NZ  LYS D 166      26.142 -19.844  15.993  1.00 81.54           N  
ATOM   6288  N   VAL D 167      20.977 -14.085  16.254  1.00 61.82           N  
ATOM   6289  CA  VAL D 167      20.938 -12.971  17.182  1.00 59.29           C  
ATOM   6290  C   VAL D 167      19.903 -13.084  18.290  1.00 60.42           C  
ATOM   6291  O   VAL D 167      20.085 -12.492  19.360  1.00 60.13           O  
ATOM   6292  CB  VAL D 167      20.762 -11.641  16.460  1.00 57.51           C  
ATOM   6293  CG1 VAL D 167      22.072 -11.250  15.791  1.00 54.95           C  
ATOM   6294  CG2 VAL D 167      19.614 -11.742  15.467  1.00 57.29           C  
ATOM   6295  N   VAL D 168      18.832 -13.836  18.044  1.00 62.20           N  
ATOM   6296  CA  VAL D 168      17.751 -13.943  19.022  1.00 63.90           C  
ATOM   6297  C   VAL D 168      18.029 -15.029  20.044  1.00 65.90           C  
ATOM   6298  O   VAL D 168      18.481 -16.120  19.701  1.00 67.00           O  
ATOM   6299  CB  VAL D 168      16.314 -14.051  18.362  1.00 64.57           C  
ATOM   6300  CG1 VAL D 168      16.360 -14.629  16.944  1.00 63.52           C  
ATOM   6301  CG2 VAL D 168      15.302 -14.805  19.274  1.00 65.75           C  
ATOM   6302  N   HIS D 169      17.782 -14.706  21.306  1.00 66.83           N  
ATOM   6303  CA  HIS D 169      17.967 -15.653  22.400  1.00 69.31           C  
ATOM   6304  C   HIS D 169      16.644 -16.370  22.682  1.00 72.24           C  
ATOM   6305  O   HIS D 169      16.608 -17.587  22.832  1.00 73.95           O  
ATOM   6306  CB  HIS D 169      18.498 -14.940  23.656  1.00 67.91           C  
ATOM   6307  CG  HIS D 169      19.549 -13.914  23.365  1.00 64.93           C  
ATOM   6308  ND1 HIS D 169      20.862 -14.241  23.111  1.00 64.21           N  
ATOM   6309  CD2 HIS D 169      19.476 -12.569  23.266  1.00 62.10           C  
ATOM   6310  CE1 HIS D 169      21.550 -13.140  22.870  1.00 62.20           C  
ATOM   6311  NE2 HIS D 169      20.730 -12.112  22.957  1.00 61.12           N  
ATOM   6312  N   ARG D 170      15.562 -15.593  22.729  1.00 73.05           N  
ATOM   6313  CA  ARG D 170      14.228 -16.107  22.994  1.00 75.17           C  
ATOM   6314  C   ARG D 170      13.199 -15.574  21.995  1.00 75.01           C  
ATOM   6315  O   ARG D 170      13.154 -14.367  21.719  1.00 73.18           O  
ATOM   6316  CB  ARG D 170      13.795 -15.763  24.424  1.00 76.07           C  
ATOM   6317  CG  ARG D 170      12.327 -16.107  24.736  1.00 79.28           C  
ATOM   6318  CD  ARG D 170      12.055 -16.190  26.231  1.00 82.63           C  
ATOM   6319  NE  ARG D 170      12.749 -17.316  26.853  1.00 85.85           N  
ATOM   6320  CZ  ARG D 170      12.914 -17.480  28.165  1.00 87.23           C  
ATOM   6321  NH1 ARG D 170      12.440 -16.590  29.023  1.00 86.64           N  
ATOM   6322  NH2 ARG D 170      13.561 -18.544  28.623  1.00 88.13           N  
ATOM   6323  N   LEU D 171      12.380 -16.490  21.461  1.00 77.73           N  
ATOM   6324  CA  LEU D 171      11.246 -16.138  20.608  1.00 79.61           C  
ATOM   6325  C   LEU D 171       9.948 -16.577  21.281  1.00 82.74           C  
ATOM   6326  O   LEU D 171       9.831 -17.719  21.730  1.00 84.47           O  
ATOM   6327  CB  LEU D 171      11.383 -16.785  19.217  1.00 79.45           C  
ATOM   6328  CG  LEU D 171      10.145 -16.981  18.310  1.00 80.51           C  
ATOM   6329  CD1 LEU D 171       9.422 -15.684  17.977  1.00 79.72           C  
ATOM   6330  CD2 LEU D 171      10.507 -17.710  17.021  1.00 80.57           C  
ATOM   6331  N   ILE D 172       8.986 -15.658  21.356  1.00 83.88           N  
ATOM   6332  CA  ILE D 172       7.635 -15.998  21.804  1.00 87.09           C  
ATOM   6333  C   ILE D 172       6.569 -15.728  20.724  1.00 88.43           C  
ATOM   6334  O   ILE D 172       6.653 -14.755  19.965  1.00 86.69           O  
ATOM   6335  CB  ILE D 172       7.272 -15.360  23.186  1.00 87.09           C  
ATOM   6336  CG1 ILE D 172       6.098 -16.115  23.841  1.00 91.84           C  
ATOM   6337  CG2 ILE D 172       6.939 -13.902  23.067  1.00 85.41           C  
ATOM   6338  CD1 ILE D 172       4.708 -15.496  23.641  1.00 94.32           C  
ATOM   6339  N   THR D 173       5.585 -16.632  20.652  1.00 93.37           N  
ATOM   6340  CA  THR D 173       4.472 -16.521  19.703  1.00 97.16           C  
ATOM   6341  C   THR D 173       3.129 -16.789  20.369  1.00101.01           C  
ATOM   6342  O   THR D 173       3.070 -17.191  21.531  1.00102.26           O  
ATOM   6343  CB  THR D 173       4.606 -17.509  18.513  1.00 97.76           C  
ATOM   6344  OG1 THR D 173       4.110 -18.806  18.889  1.00100.22           O  
ATOM   6345  CG2 THR D 173       6.058 -17.596  18.004  1.00 95.69           C  
ATOM   6346  N   ASP D 174       2.056 -16.559  19.618  1.00104.42           N  
ATOM   6347  CA  ASP D 174       0.716 -17.023  19.979  1.00109.90           C  
ATOM   6348  C   ASP D 174       0.737 -18.452  20.525  1.00114.11           C  
ATOM   6349  O   ASP D 174       0.022 -18.775  21.506  1.00116.45           O  
ATOM   6350  CB  ASP D 174      -0.210 -16.957  18.754  1.00110.05           C  
ATOM   6351  CG  ASP D 174       0.470 -17.436  17.474  1.00109.45           C  
ATOM   6352  OD1 ASP D 174      -0.081 -18.335  16.811  1.00111.14           O  
ATOM   6353  OD2 ASP D 174       1.556 -16.924  17.127  1.00106.42           O  
ATOM   6354  N   LEU D 175       1.575 -19.291  19.890  1.00116.10           N  
ATOM   6355  CA  LEU D 175       1.632 -20.707  20.235  1.00119.99           C  
ATOM   6356  C   LEU D 175       2.476 -20.929  21.497  1.00119.86           C  
ATOM   6357  O   LEU D 175       1.918 -21.315  22.623  1.00122.45           O  
ATOM   6358  CB  LEU D 175       2.196 -21.527  19.061  1.00120.72           C  
ATOM   6359  CG  LEU D 175       2.157 -23.064  19.184  1.00125.45           C  
ATOM   6360  CD1 LEU D 175       0.731 -23.607  19.068  1.00128.84           C  
ATOM   6361  CD2 LEU D 175       3.064 -23.724  18.150  1.00126.26           C  
ATOM   6362  N   ALA D 176       3.886 -20.714  21.268  1.00116.63           N  
ATOM   6363  CA  ALA D 176       4.795 -21.193  22.326  1.00114.88           C  
ATOM   6364  C   ALA D 176       6.032 -20.310  22.555  1.00110.74           C  
ATOM   6365  O   ALA D 176       6.125 -19.174  22.038  1.00108.16           O  
ATOM   6366  CB  ALA D 176       5.221 -22.648  22.020  1.00117.13           C  
ATOM   6367  N   VAL D 177       6.970 -20.845  23.345  1.00109.61           N  
ATOM   6368  CA  VAL D 177       8.205 -20.147  23.697  1.00106.55           C  
ATOM   6369  C   VAL D 177       9.432 -20.980  23.296  1.00106.52           C  
ATOM   6370  O   VAL D 177       9.521 -22.173  23.621  1.00108.03           O  
ATOM   6371  CB  VAL D 177       8.243 -19.782  25.207  1.00106.60           C  
ATOM   6372  CG1 VAL D 177       9.542 -19.047  25.574  1.00104.15           C  
ATOM   6373  CG2 VAL D 177       7.047 -18.916  25.577  1.00105.65           C  
ATOM   6374  N   PHE D 178      10.363 -20.328  22.585  1.00103.32           N  
ATOM   6375  CA  PHE D 178      11.606 -20.954  22.100  1.00101.82           C  
ATOM   6376  C   PHE D 178      12.872 -20.240  22.574  1.00 99.03           C  
ATOM   6377  O   PHE D 178      12.907 -19.011  22.651  1.00 97.14           O  
ATOM   6378  CB  PHE D 178      11.619 -21.025  20.568  1.00101.82           C  
ATOM   6379  CG  PHE D 178      10.512 -21.865  19.985  1.00105.91           C  
ATOM   6380  CD1 PHE D 178      10.606 -23.255  19.967  1.00111.14           C  
ATOM   6381  CD2 PHE D 178       9.382 -21.263  19.450  1.00106.69           C  
ATOM   6382  CE1 PHE D 178       9.581 -24.039  19.432  1.00115.16           C  
ATOM   6383  CE2 PHE D 178       8.356 -22.028  18.913  1.00111.99           C  
ATOM   6384  CZ  PHE D 178       8.452 -23.427  18.903  1.00114.84           C  
ATOM   6385  N   ASP D 179      13.908 -21.028  22.866  1.00 99.45           N  
ATOM   6386  CA  ASP D 179      15.203 -20.533  23.349  1.00 98.09           C  
ATOM   6387  C   ASP D 179      16.355 -21.067  22.510  1.00 97.33           C  
ATOM   6388  O   ASP D 179      16.327 -22.214  22.044  1.00 98.49           O  
ATOM   6389  CB  ASP D 179      15.433 -20.925  24.813  1.00 99.59           C  
ATOM   6390  CG  ASP D 179      14.514 -20.194  25.766  1.00100.08           C  
ATOM   6391  OD1 ASP D 179      15.003 -19.297  26.480  1.00 99.92           O  
ATOM   6392  OD2 ASP D 179      13.300 -20.505  25.794  1.00102.88           O  
ATOM   6393  N   PHE D 180      17.378 -20.236  22.327  1.00 94.06           N  
ATOM   6394  CA  PHE D 180      18.529 -20.607  21.511  1.00 92.66           C  
ATOM   6395  C   PHE D 180      19.821 -20.574  22.329  1.00 93.19           C  
ATOM   6396  O   PHE D 180      20.087 -19.606  23.038  1.00 92.46           O  
ATOM   6397  CB  PHE D 180      18.649 -19.676  20.299  1.00 90.12           C  
ATOM   6398  CG  PHE D 180      17.373 -19.528  19.509  1.00 88.59           C  
ATOM   6399  CD1 PHE D 180      16.399 -18.617  19.897  1.00 86.67           C  
ATOM   6400  CD2 PHE D 180      17.157 -20.287  18.368  1.00 88.63           C  
ATOM   6401  CE1 PHE D 180      15.230 -18.471  19.169  1.00 86.67           C  
ATOM   6402  CE2 PHE D 180      15.987 -20.147  17.633  1.00 88.80           C  
ATOM   6403  CZ  PHE D 180      15.022 -19.239  18.034  1.00 88.18           C  
ATOM   6404  N   VAL D 181      20.615 -21.639  22.238  1.00 96.00           N  
ATOM   6405  CA  VAL D 181      21.948 -21.658  22.833  1.00 97.56           C  
ATOM   6406  C   VAL D 181      22.970 -22.176  21.824  1.00 97.65           C  
ATOM   6407  O   VAL D 181      22.990 -23.369  21.490  1.00 99.58           O  
ATOM   6408  CB  VAL D 181      22.002 -22.507  24.129  1.00 99.87           C  
ATOM   6409  CG1 VAL D 181      23.401 -22.435  24.770  1.00 99.83           C  
ATOM   6410  CG2 VAL D 181      20.921 -22.061  25.120  1.00100.36           C  
ATOM   6411  N   ASN D 182      23.807 -21.263  21.335  1.00 95.68           N  
ATOM   6412  CA  ASN D 182      24.948 -21.612  20.485  1.00 95.87           C  
ATOM   6413  C   ASN D 182      24.556 -22.364  19.216  1.00 96.87           C  
ATOM   6414  O   ASN D 182      25.248 -23.303  18.801  1.00 98.45           O  
ATOM   6415  CB  ASN D 182      26.000 -22.400  21.279  1.00 97.13           C  
ATOM   6416  CG  ASN D 182      26.617 -21.567  22.396  1.00 96.95           C  
ATOM   6417  OD1 ASN D 182      27.000 -20.376  22.184  1.00 95.84           O  
ATOM   6418  ND2 ASN D 182      26.712 -22.184  23.597  1.00 98.74           N  
ATOM   6419  N   GLY D 183      23.437 -21.948  18.609  1.00 96.57           N  
ATOM   6420  CA  GLY D 183      23.167 -22.301  17.221  1.00 96.99           C  
ATOM   6421  C   GLY D 183      21.965 -23.202  17.041  1.00 99.44           C  
ATOM   6422  O   GLY D 183      21.604 -23.529  15.902  1.00100.00           O  
ATOM   6423  N   ARG D 184      21.340 -23.600  18.159  1.00101.81           N  
ATOM   6424  CA  ARG D 184      20.284 -24.615  18.115  1.00105.22           C  
ATOM   6425  C   ARG D 184      19.082 -24.290  19.007  1.00104.86           C  
ATOM   6426  O   ARG D 184      19.208 -23.577  20.012  1.00103.67           O  
ATOM   6427  CB  ARG D 184      20.858 -25.994  18.466  1.00108.18           C  
ATOM   6428  CG  ARG D 184      21.858 -25.980  19.622  1.00111.46           C  
ATOM   6429  CD  ARG D 184      21.208 -26.421  20.930  1.00117.95           C  
ATOM   6430  NE  ARG D 184      20.369 -27.607  20.749  1.00124.44           N  
ATOM   6431  CZ  ARG D 184      20.832 -28.854  20.645  1.00130.01           C  
ATOM   6432  NH1 ARG D 184      19.987 -29.869  20.483  1.00132.96           N  
ATOM   6433  NH2 ARG D 184      22.139 -29.093  20.705  1.00131.49           N  
ATOM   6434  N   MET D 185      17.922 -24.835  18.641  1.00106.21           N  
ATOM   6435  CA  MET D 185      16.651 -24.383  19.199  1.00106.65           C  
ATOM   6436  C   MET D 185      16.004 -25.408  20.138  1.00110.70           C  
ATOM   6437  O   MET D 185      16.043 -26.616  19.884  1.00112.97           O  
ATOM   6438  CB  MET D 185      15.693 -24.028  18.062  1.00105.21           C  
ATOM   6439  CG  MET D 185      14.518 -23.162  18.483  1.00102.54           C  
ATOM   6440  SD  MET D 185      13.557 -22.608  17.062  1.00101.15           S  
ATOM   6441  CE  MET D 185      13.076 -24.167  16.327  1.00105.13           C  
ATOM   6442  N   THR D 186      15.412 -24.906  21.224  1.00111.94           N  
ATOM   6443  CA  THR D 186      14.589 -25.720  22.119  1.00115.64           C  
ATOM   6444  C   THR D 186      13.226 -25.052  22.318  1.00115.28           C  
ATOM   6445  O   THR D 186      12.997 -23.943  21.811  1.00113.20           O  
ATOM   6446  CB  THR D 186      15.274 -25.905  23.491  1.00116.66           C  
ATOM   6447  OG1 THR D 186      16.703 -25.981  23.305  1.00116.50           O  
ATOM   6448  CG2 THR D 186      14.780 -27.183  24.169  1.00120.70           C  
ATOM   6449  N   LEU D 187      12.324 -25.722  23.047  1.00118.51           N  
ATOM   6450  CA  LEU D 187      11.066 -25.086  23.454  1.00120.39           C  
ATOM   6451  C   LEU D 187      10.768 -25.132  24.942  1.00121.51           C  
ATOM   6452  O   LEU D 187      10.323 -26.152  25.478  1.00123.89           O  
ATOM   6453  CB  LEU D 187       9.873 -25.577  22.643  1.00122.27           C  
ATOM   6454  CG  LEU D 187       9.520 -27.056  22.613  1.00127.22           C  
ATOM   6455  CD1 LEU D 187       8.016 -27.197  22.511  1.00131.23           C  
ATOM   6456  CD2 LEU D 187      10.227 -27.747  21.458  1.00129.18           C  
ATOM   6457  N   THR D 188      10.983 -23.991  25.587  1.00119.05           N  
ATOM   6458  CA  THR D 188      10.849 -23.850  27.037  1.00119.09           C  
ATOM   6459  C   THR D 188       9.394 -23.781  27.507  1.00121.90           C  
ATOM   6460  O   THR D 188       9.124 -23.979  28.691  1.00124.14           O  
ATOM   6461  CB  THR D 188      11.657 -22.614  27.543  1.00116.25           C  
ATOM   6462  OG1 THR D 188      13.009 -22.715  27.086  1.00114.02           O  
ATOM   6463  CG2 THR D 188      11.660 -22.499  29.076  1.00116.61           C  
ATOM   6464  N   GLU D 189       8.460 -23.524  26.592  1.00122.42           N  
ATOM   6465  CA  GLU D 189       7.074 -23.275  26.988  1.00124.03           C  
ATOM   6466  C   GLU D 189       6.065 -23.577  25.889  1.00125.95           C  
ATOM   6467  O   GLU D 189       6.415 -23.591  24.705  1.00124.75           O  
ATOM   6468  CB  GLU D 189       6.930 -21.830  27.456  1.00121.92           C  
ATOM   6469  CG  GLU D 189       5.869 -21.582  28.525  1.00122.70           C  
ATOM   6470  CD  GLU D 189       5.950 -20.152  29.066  1.00119.08           C  
ATOM   6471  OE1 GLU D 189       7.051 -19.514  28.937  1.00114.53           O  
ATOM   6472  OE2 GLU D 189       4.912 -19.670  29.617  1.00120.14           O  
ATOM   6473  N   LEU D 190       4.811 -23.818  26.306  1.00130.53           N  
ATOM   6474  CA  LEU D 190       3.756 -24.312  25.415  1.00134.08           C  
ATOM   6475  C   LEU D 190       2.644 -23.289  25.189  1.00132.80           C  
ATOM   6476  O   LEU D 190       2.231 -22.516  26.254  1.00131.43           O  
ATOM   6477  CB  LEU D 190       3.151 -25.594  25.993  1.00138.59           C  
ATOM   6478  CG  LEU D 190       3.750 -26.991  25.756  1.00143.25           C  
ATOM   6479  CD1 LEU D 190       5.322 -27.054  25.743  1.00142.73           C  
ATOM   6480  CD2 LEU D 190       3.132 -27.985  26.800  1.00148.90           C  
ATOM   6481  N   THR D 195      -1.575 -26.867  22.745  1.00163.71           N  
ATOM   6482  CA  THR D 195      -0.939 -28.050  23.328  1.00166.50           C  
ATOM   6483  C   THR D 195       0.386 -28.403  22.649  1.00163.33           C  
ATOM   6484  O   THR D 195       0.785 -27.769  21.661  1.00160.90           O  
ATOM   6485  CB  THR D 195      -1.879 -29.291  23.271  1.00170.55           C  
ATOM   6486  OG1 THR D 195      -2.536 -29.358  21.988  1.00172.35           O  
ATOM   6487  CG2 THR D 195      -2.929 -29.218  24.370  1.00174.48           C  
ATOM   6488  N   ILE D 196       1.055 -29.424  23.192  1.00164.68           N  
ATOM   6489  CA  ILE D 196       2.366 -29.876  22.708  1.00164.55           C  
ATOM   6490  C   ILE D 196       2.339 -30.339  21.249  1.00165.15           C  
ATOM   6491  O   ILE D 196       3.076 -29.822  20.405  1.00162.02           O  
ATOM   6492  CB  ILE D 196       2.929 -31.031  23.587  1.00166.95           C  
ATOM   6493  CG1 ILE D 196       1.797 -31.713  24.379  1.00171.81           C  
ATOM   6494  CG2 ILE D 196       4.026 -30.511  24.513  1.00164.26           C  
ATOM   6495  CD1 ILE D 196       2.191 -33.026  25.045  1.00176.86           C  
ATOM   6496  N   GLU D 197       1.476 -31.312  20.964  1.00170.41           N  
ATOM   6497  CA  GLU D 197       1.583 -32.116  19.745  1.00174.21           C  
ATOM   6498  C   GLU D 197       1.547 -31.264  18.474  1.00170.31           C  
ATOM   6499  O   GLU D 197       1.907 -31.748  17.378  1.00170.70           O  
ATOM   6500  CB  GLU D 197       0.454 -33.155  19.700  1.00179.24           C  
ATOM   6501  CG  GLU D 197       0.678 -34.271  18.678  1.00185.43           C  
ATOM   6502  CD  GLU D 197       1.305 -35.524  19.296  1.00191.76           C  
ATOM   6503  OE1 GLU D 197       2.099 -35.406  20.340  1.00191.51           O  
ATOM   6504  OE2 GLU D 197       1.004 -36.633  18.732  1.00194.66           O  
ATOM   6505  N   GLU D 198       1.121 -30.001  18.623  1.00164.65           N  
ATOM   6506  CA  GLU D 198       0.789 -29.180  17.460  1.00160.05           C  
ATOM   6507  C   GLU D 198       2.030 -28.536  16.847  1.00154.44           C  
ATOM   6508  O   GLU D 198       1.991 -28.051  15.712  1.00153.00           O  
ATOM   6509  CB  GLU D 198      -0.217 -28.094  17.843  1.00159.88           C  
ATOM   6510  CG  GLU D 198      -1.146 -28.486  19.006  1.00164.03           C  
ATOM   6511  CD  GLU D 198      -2.046 -27.351  19.470  1.00164.44           C  
ATOM   6512  OE1 GLU D 198      -1.618 -26.237  19.472  1.00162.30           O  
ATOM   6513  OE2 GLU D 198      -3.465 -27.818  19.706  1.00167.28           O  
ATOM   6514  N   VAL D 199       3.127 -28.541  17.604  1.00150.32           N  
ATOM   6515  CA  VAL D 199       4.256 -27.655  17.310  1.00144.37           C  
ATOM   6516  C   VAL D 199       5.215 -28.231  16.256  1.00144.24           C  
ATOM   6517  O   VAL D 199       5.664 -27.510  15.359  1.00141.73           O  
ATOM   6518  CB  VAL D 199       5.030 -27.282  18.599  1.00143.08           C  
ATOM   6519  CG1 VAL D 199       5.957 -26.105  18.340  1.00137.89           C  
ATOM   6520  CG2 VAL D 199       4.049 -26.954  19.735  1.00143.68           C  
ATOM   6521  N   TYR D 200       5.528 -29.522  16.371  1.00147.90           N  
ATOM   6522  CA  TYR D 200       6.162 -30.266  15.274  1.00150.59           C  
ATOM   6523  C   TYR D 200       5.467 -29.913  13.957  1.00150.58           C  
ATOM   6524  O   TYR D 200       6.121 -29.391  13.004  1.00148.70           O  
ATOM   6525  CB  TYR D 200       6.083 -31.782  15.542  1.00154.38           C  
ATOM   6526  CG  TYR D 200       7.362 -32.365  16.115  1.00156.10           C  
ATOM   6527  CD1 TYR D 200       8.318 -31.532  16.697  1.00153.73           C  
ATOM   6528  CD2 TYR D 200       7.611 -33.745  16.080  1.00160.99           C  
ATOM   6529  CE1 TYR D 200       9.490 -32.040  17.223  1.00153.84           C  
ATOM   6530  CE2 TYR D 200       8.789 -34.268  16.611  1.00161.18           C  
ATOM   6531  CZ  TYR D 200       9.723 -33.401  17.181  1.00157.49           C  
ATOM   6532  OH  TYR D 200      10.896 -33.879  17.717  1.00157.39           O  
ATOM   6533  N   GLU D 201       4.139 -30.169  13.937  1.00152.47           N  
ATOM   6534  CA  GLU D 201       3.294 -29.852  12.788  1.00153.11           C  
ATOM   6535  C   GLU D 201       3.430 -28.391  12.331  1.00147.32           C  
ATOM   6536  O   GLU D 201       3.517 -28.118  11.134  1.00146.55           O  
ATOM   6537  CB  GLU D 201       1.826 -30.172  13.113  1.00156.84           C  
ATOM   6538  CG  GLU D 201       1.567 -31.648  13.460  1.00165.13           C  
ATOM   6539  CD  GLU D 201      -0.025 -31.850  13.779  1.00172.95           C  
ATOM   6540  OE1 GLU D 201      -0.614 -30.909  14.511  1.00174.33           O  
ATOM   6541  OE2 GLU D 201      -0.647 -32.911  13.268  1.00176.61           O  
ATOM   6542  N   LYS D 202       3.457 -27.460  13.284  1.00141.44           N  
ATOM   6543  CA  LYS D 202       3.272 -26.050  12.964  1.00135.11           C  
ATOM   6544  C   LYS D 202       4.586 -25.326  12.603  1.00130.13           C  
ATOM   6545  O   LYS D 202       4.614 -24.370  11.746  1.00128.33           O  
ATOM   6546  CB  LYS D 202       2.547 -25.332  14.128  1.00135.03           C  
ATOM   6547  CG  LYS D 202       0.987 -25.410  14.033  1.00136.60           C  
ATOM   6548  CD  LYS D 202       0.461 -25.237  15.586  1.00139.56           C  
ATOM   6549  CE  LYS D 202      -1.079 -25.577  15.452  1.00142.52           C  
ATOM   6550  NZ  LYS D 202      -1.808 -25.444  16.754  1.00143.23           N  
ATOM   6551  N   THR D 203       5.670 -25.773  13.263  1.00127.00           N  
ATOM   6552  CA  THR D 203       6.960 -25.142  13.054  1.00122.43           C  
ATOM   6553  C   THR D 203       7.661 -25.763  11.851  1.00122.90           C  
ATOM   6554  O   THR D 203       7.855 -26.985  11.786  1.00124.92           O  
ATOM   6555  CB  THR D 203       7.842 -25.267  14.306  1.00121.60           C  
ATOM   6556  OG1 THR D 203       7.103 -24.815  15.453  1.00120.47           O  
ATOM   6557  CG2 THR D 203       9.096 -24.429  14.166  1.00117.77           C  
ATOM   6558  N   GLU D 204       8.033 -24.908  10.898  1.00119.84           N  
ATOM   6559  CA  GLU D 204       8.880 -25.311   9.779  1.00118.47           C  
ATOM   6560  C   GLU D 204      10.317 -25.553  10.236  1.00116.81           C  
ATOM   6561  O   GLU D 204      11.081 -26.255   9.571  1.00117.71           O  
ATOM   6562  CB  GLU D 204       8.848 -24.244   8.684  1.00116.94           C  
ATOM   6563  CG  GLU D 204       8.917 -24.824   7.267  1.00118.42           C  
ATOM   6564  CD  GLU D 204       8.353 -23.852   6.238  1.00117.16           C  
ATOM   6565  OE1 GLU D 204       7.794 -24.320   5.215  1.00118.95           O  
ATOM   6566  OE2 GLU D 204       8.461 -22.626   6.452  1.00114.78           O  
ATOM   6567  N   ALA D 205      10.673 -24.959  11.371  1.00114.19           N  
ATOM   6568  CA  ALA D 205      11.983 -25.161  11.985  1.00112.95           C  
ATOM   6569  C   ALA D 205      12.066 -26.472  12.793  1.00116.07           C  
ATOM   6570  O   ALA D 205      11.036 -27.057  13.170  1.00117.89           O  
ATOM   6571  CB  ALA D 205      12.322 -23.965  12.869  1.00109.72           C  
ATOM   6572  N   ASP D 206      13.298 -26.922  13.047  1.00117.74           N  
ATOM   6573  CA  ASP D 206      13.554 -28.086  13.895  1.00120.79           C  
ATOM   6574  C   ASP D 206      14.053 -27.671  15.285  1.00119.52           C  
ATOM   6575  O   ASP D 206      14.805 -26.701  15.431  1.00117.48           O  
ATOM   6576  CB  ASP D 206      14.550 -29.036  13.228  1.00122.63           C  
ATOM   6577  CG  ASP D 206      14.043 -30.469  13.177  1.00128.89           C  
ATOM   6578  OD1 ASP D 206      12.865 -30.711  13.527  1.00130.51           O  
ATOM   6579  OD2 ASP D 206      14.820 -31.360  12.776  1.00132.76           O  
ATOM   6580  N   PHE D 207      13.641 -28.426  16.299  1.00122.06           N  
ATOM   6581  CA  PHE D 207      13.764 -28.001  17.693  1.00123.25           C  
ATOM   6582  C   PHE D 207      13.899 -29.182  18.657  1.00126.82           C  
ATOM   6583  O   PHE D 207      13.588 -30.332  18.302  1.00129.18           O  
ATOM   6584  CB  PHE D 207      12.535 -27.162  18.082  1.00122.65           C  
ATOM   6585  CG  PHE D 207      11.223 -27.703  17.541  1.00125.46           C  
ATOM   6586  CD1 PHE D 207      10.552 -28.735  18.191  1.00130.73           C  
ATOM   6587  CD2 PHE D 207      10.663 -27.169  16.379  1.00126.02           C  
ATOM   6588  CE1 PHE D 207       9.350 -29.224  17.695  1.00134.88           C  
ATOM   6589  CE2 PHE D 207       9.463 -27.656  15.876  1.00128.94           C  
ATOM   6590  CZ  PHE D 207       8.808 -28.682  16.534  1.00133.64           C  
ATOM   6591  N   ALA D 208      14.351 -28.885  19.879  1.00127.48           N  
ATOM   6592  CA  ALA D 208      14.441 -29.895  20.929  1.00130.37           C  
ATOM   6593  C   ALA D 208      13.760 -29.418  22.223  1.00131.27           C  
ATOM   6594  O   ALA D 208      13.414 -28.231  22.339  1.00129.09           O  
ATOM   6595  CB  ALA D 208      15.905 -30.268  21.180  1.00130.43           C  
ATOM   6596  N   VAL D 209      13.540 -30.358  23.157  1.00135.48           N  
ATOM   6597  CA  VAL D 209      13.120 -30.078  24.550  1.00138.70           C  
ATOM   6598  C   VAL D 209      13.505 -31.249  25.479  1.00143.01           C  
ATOM   6599  O   VAL D 209      13.764 -32.407  24.997  1.00145.05           O  
ATOM   6600  CB  VAL D 209      11.595 -29.743  24.669  1.00138.84           C  
ATOM   6601  CG1 VAL D 209      10.731 -30.957  24.325  1.00142.01           C  
ATOM   6602  CG2 VAL D 209      11.259 -29.214  26.064  1.00138.39           C  
ATOM   6603  N   SER D 210      13.539 -30.950  26.804  1.00145.16           N  
ATOM   6604  CA  SER D 210      13.875 -31.993  27.789  1.00148.98           C  
ATOM   6605  C   SER D 210      12.669 -32.432  28.661  1.00152.87           C  
ATOM   6606  O   SER D 210      12.132 -31.657  29.532  1.00154.13           O  
ATOM   6607  CB  SER D 210      15.036 -31.516  28.666  1.00147.95           C  
ATOM   6608  OG  SER D 210      14.879 -30.135  28.976  1.00145.14           O  
TER    6609      SER D 210                                                      
END
MOLECULE T0438_187_430.pdb
ATOM   1303  N   VAL   187       0.820  10.141  14.824  1.00 28.84          
ATOM   1304  CA  VAL   187       0.445   8.797  14.378  1.00 30.72          
ATOM   1305  C   VAL   187      -0.093   8.019  15.544  1.00 33.62          
ATOM   1306  O   VAL   187       0.620   7.790  16.523  1.00 35.03          
ATOM   1307  CB  VAL   187       1.577   8.082  13.588  1.00 30.22          
ATOM   1308  CG1 VAL   187       2.817   8.965  13.462  1.00 25.66          
ATOM   1309  CG2 VAL   187       1.869   6.636  14.104  1.00 27.80          
ATOM   1310  N   LEU   188      -1.365   7.685  15.552  1.00 36.33          
ATOM   1311  CA  LEU   188      -1.766   7.116  16.820  1.00 39.60          
ATOM   1312  C   LEU   188      -1.463   5.658  16.688  1.00 40.63          
ATOM   1313  O   LEU   188      -1.711   5.121  15.604  1.00 41.97          
ATOM   1314  CB  LEU   188      -3.216   7.391  17.209  1.00 40.09          
ATOM   1315  CG  LEU   188      -4.368   7.933  16.361  1.00 42.34          
ATOM   1316  CD1 LEU   188      -5.749   7.265  16.790  1.00 43.32          
ATOM   1317  CD2 LEU   188      -4.467   9.487  16.362  1.00 40.82          
ATOM   1318  N   PRO   189      -0.900   5.047  17.753  1.00 41.64          
ATOM   1319  CA  PRO   189      -0.405   3.557  17.778  1.00 41.00          
ATOM   1320  C   PRO   189      -1.463   2.511  18.026  1.00 40.32          
ATOM   1321  O   PRO   189      -2.331   2.784  18.846  1.00 38.36          
ATOM   1322  CB  PRO   189       0.536   3.483  19.004  1.00 41.78          
ATOM   1323  CG  PRO   189       0.191   4.840  19.879  1.00 43.14          
ATOM   1324  CD  PRO   189      -0.710   5.778  19.040  1.00 41.44          
ATOM   1325  N   GLY   192      -2.556  -2.871  21.661  1.00 37.19          
ATOM   1326  CA  GLY   192      -2.307  -4.286  21.880  1.00 37.47          
ATOM   1327  C   GLY   192      -3.180  -4.962  20.856  1.00 38.32          
ATOM   1328  O   GLY   192      -3.225  -4.505  19.724  1.00 40.65          
ATOM   1329  N   SER   193      -3.925  -5.989  21.284  1.00 37.83          
ATOM   1330  CA  SER   193      -4.758  -6.938  20.509  1.00 36.10          
ATOM   1331  C   SER   193      -4.707  -8.293  21.254  1.00 36.38          
ATOM   1332  O   SER   193      -3.810  -8.546  22.080  1.00 36.55          
ATOM   1333  CB  SER   193      -4.205  -7.184  19.129  1.00 35.62          
ATOM   1334  OG  SER   193      -3.561  -8.438  19.112  1.00 35.38          
ATOM   1335  N   ASP   194      -5.660  -9.174  20.962  1.00 36.31          
ATOM   1336  CA  ASP   194      -5.613 -10.584  21.386  1.00 35.24          
ATOM   1337  C   ASP   194      -4.148 -11.214  21.381  1.00 34.24          
ATOM   1338  O   ASP   194      -3.422 -11.101  22.379  1.00 33.49          
ATOM   1339  CB  ASP   194      -6.554 -11.354  20.438  1.00 37.64          
ATOM   1340  CG  ASP   194      -6.173 -11.162  18.888  1.00 42.81          
ATOM   1341  OD1 ASP   194      -5.960 -12.200  18.141  1.00 43.94          
ATOM   1342  OD2 ASP   194      -6.064  -9.996  18.354  1.00 48.17          
ATOM   1343  N   LEU   195      -3.732 -11.835  20.252  1.00 32.62          
ATOM   1344  CA  LEU   195      -2.440 -12.531  20.091  1.00 31.45          
ATOM   1345  C   LEU   195      -1.416 -11.687  20.712  1.00 29.72          
ATOM   1346  O   LEU   195      -0.706 -12.112  21.617  1.00 28.28          
ATOM   1347  CB  LEU   195      -2.024 -12.708  18.616  1.00 30.94          
ATOM   1348  CG  LEU   195      -2.372 -13.981  17.815  1.00 31.10          
ATOM   1349  CD1 LEU   195      -3.858 -13.976  17.465  1.00 33.72          
ATOM   1350  CD2 LEU   195      -1.505 -14.211  16.484  1.00 31.79          
ATOM   1351  N   GLU   196      -1.375 -10.452  20.235  1.00 28.49          
ATOM   1352  CA  GLU   196      -0.268  -9.584  20.563  1.00 28.51          
ATOM   1353  C   GLU   196       0.041  -9.456  22.058  1.00 28.27          
ATOM   1354  O   GLU   196       1.186  -9.509  22.490  1.00 27.24          
ATOM   1355  CB  GLU   196      -0.517  -8.243  19.957  1.00 28.39          
ATOM   1356  CG  GLU   196      -0.129  -8.317  18.511  1.00 27.85          
ATOM   1357  CD  GLU   196      -0.400  -7.057  17.766  1.00 26.06          
ATOM   1358  OE1 GLU   196      -1.032  -6.161  18.386  1.00 25.89          
ATOM   1359  OE2 GLU   196       0.047  -6.993  16.571  1.00 26.33          
ATOM   1360  N   LEU   197      -1.033  -9.312  22.819  1.00 28.06          
ATOM   1361  CA  LEU   197      -1.005  -9.258  24.244  1.00 26.40          
ATOM   1362  C   LEU   197      -0.346 -10.470  24.846  1.00 24.61          
ATOM   1363  O   LEU   197       0.492 -10.313  25.705  1.00 23.87          
ATOM   1364  CB  LEU   197      -2.440  -9.100  24.736  1.00 27.26          
ATOM   1365  CG  LEU   197      -2.598  -7.742  25.445  1.00 31.86          
ATOM   1366  CD1 LEU   197      -1.645  -6.583  24.932  1.00 34.54          
ATOM   1367  CD2 LEU   197      -4.052  -7.297  25.442  1.00 33.07          
ATOM   1368  N   ARG   198      -0.717 -11.680  24.434  1.00 23.41          
ATOM   1369  CA  ARG   198      -0.027 -12.851  24.996  1.00 22.68          
ATOM   1370  C   ARG   198       1.454 -12.712  24.688  1.00 21.12          
ATOM   1371  O   ARG   198       2.273 -13.040  25.549  1.00 21.74          
ATOM   1372  CB  ARG   198      -0.588 -14.196  24.519  1.00 22.81          
ATOM   1373  CG  ARG   198      -1.761 -14.689  25.375  1.00 28.17          
ATOM   1374  CD  ARG   198      -2.972 -15.146  24.520  1.00 37.75          
ATOM   1375  NE  ARG   198      -2.798 -16.504  23.931  1.00 46.52          
ATOM   1376  CZ  ARG   198      -3.474 -17.055  22.882  1.00 45.67          
ATOM   1377  NH1 ARG   198      -4.419 -16.365  22.215  1.00 46.96          
ATOM   1378  NH2 ARG   198      -3.159 -18.304  22.499  1.00 39.44          
ATOM   1379  N   ILE   199       1.816 -12.176  23.504  1.00 18.49          
ATOM   1380  CA  ILE   199       3.242 -12.015  23.184  1.00 16.93          
ATOM   1381  C   ILE   199       3.857 -11.166  24.286  1.00 17.14          
ATOM   1382  O   ILE   199       4.748 -11.623  25.008  1.00 16.56          
ATOM   1383  CB  ILE   199       3.506 -11.483  21.694  1.00 17.18          
ATOM   1384  CG1 ILE   199       2.765 -12.329  20.653  1.00 14.61          
ATOM   1385  CG2 ILE   199       4.986 -11.491  21.293  1.00 15.13          
ATOM   1386  CD  ILE   199       3.017 -11.828  19.272  1.00 15.02          
ATOM   1387  N   GLY   200       3.328  -9.953  24.432  1.00 17.68          
ATOM   1388  CA  GLY   200       3.628  -9.063  25.538  1.00 18.66          
ATOM   1389  C   GLY   200       3.802  -9.801  26.833  1.00 20.01          
ATOM   1390  O   GLY   200       4.769  -9.608  27.518  1.00 20.50          
ATOM   1391  N   GLN   201       2.893 -10.689  27.166  1.00 21.65          
ATOM   1392  CA  GLN   201       2.998 -11.336  28.446  1.00 23.80          
ATOM   1393  C   GLN   201       4.179 -12.238  28.567  1.00 23.77          
ATOM   1394  O   GLN   201       4.855 -12.264  29.597  1.00 24.90          
ATOM   1395  CB  GLN   201       1.815 -12.184  28.729  1.00 25.32          
ATOM   1396  CG  GLN   201       1.749 -12.523  30.179  1.00 31.75          
ATOM   1397  CD  GLN   201       1.212 -11.294  30.956  1.00 39.96          
ATOM   1398  OE1 GLN   201       0.708 -10.323  30.309  1.00 42.06          
ATOM   1399  NE2 GLN   201       1.276 -11.333  32.314  1.00 36.47          
ATOM   1400  N   ASN   202       4.426 -13.025  27.550  1.00 23.36          
ATOM   1401  CA  ASN   202       5.631 -13.851  27.620  1.00 23.41          
ATOM   1402  C   ASN   202       6.954 -13.072  27.734  1.00 23.35          
ATOM   1403  O   ASN   202       7.910 -13.617  28.267  1.00 23.05          
ATOM   1404  CB  ASN   202       5.761 -14.764  26.410  1.00 23.49          
ATOM   1405  CG  ASN   202       4.699 -15.832  26.346  1.00 21.40          
ATOM   1406  OD1 ASN   202       3.612 -15.627  25.845  1.00 18.80          
ATOM   1407  ND2 ASN   202       5.074 -17.027  26.770  1.00 21.13          
ATOM   1408  N   CYS   203       7.035 -11.851  27.186  1.00 23.39          
ATOM   1409  CA  CYS   203       8.322 -11.111  27.221  1.00 23.87          
ATOM   1410  C   CYS   203       8.657 -10.698  28.639  1.00 24.29          
ATOM   1411  O   CYS   203       9.835 -10.799  29.070  1.00 24.09          
ATOM   1412  CB  CYS   203       8.266  -9.826  26.439  1.00 24.26          
ATOM   1413  SG  CYS   203       8.218 -10.159  24.708  1.00 23.35          
ATOM   1414  N   ALA   204       7.587 -10.268  29.331  1.00 22.34          
ATOM   1415  CA  ALA   204       7.658  -9.799  30.651  1.00 20.74          
ATOM   1416  C   ALA   204       8.275 -10.787  31.630  1.00 20.51          
ATOM   1417  O   ALA   204       8.866 -10.356  32.676  1.00 20.26          
ATOM   1418  CB  ALA   204       6.309  -9.402  31.070  1.00 21.04          
ATOM   1419  N   SER   205       8.210 -12.091  31.314  1.00 19.37          
ATOM   1420  CA  SER   205       8.977 -13.063  32.147  1.00 19.80          
ATOM   1421  C   SER   205      10.480 -13.054  31.981  1.00 18.45          
ATOM   1422  O   SER   205      11.148 -13.905  32.569  1.00 18.93          
ATOM   1423  CB  SER   205       8.641 -14.514  31.849  1.00 20.42          
ATOM   1424  OG  SER   205       7.751 -14.609  30.784  1.00 25.03          
ATOM   1425  N   LEU   206      10.982 -12.204  31.096  1.00 16.97          
ATOM   1426  CA  LEU   206      12.403 -12.062  30.812  1.00 15.70          
ATOM   1427  C   LEU   206      12.881 -10.751  31.366  1.00 15.61          
ATOM   1428  O   LEU   206      14.060 -10.475  31.476  1.00 16.34          
ATOM   1429  CB  LEU   206      12.620 -12.051  29.281  1.00 15.05          
ATOM   1430  CG  LEU   206      12.103 -13.290  28.527  1.00 10.48          
ATOM   1431  CD1 LEU   206      12.592 -13.301  27.103  1.00  7.76          
ATOM   1432  CD2 LEU   206      12.596 -14.515  29.148  1.00  3.57          
ATOM   1433  N   ILE   207      11.938  -9.923  31.715  1.00 15.91          
ATOM   1434  CA  ILE   207      12.265  -8.572  32.049  1.00 16.57          
ATOM   1435  C   ILE   207      12.173  -8.461  33.559  1.00 17.83          
ATOM   1436  O   ILE   207      11.211  -9.013  34.178  1.00 17.84          
ATOM   1437  CB  ILE   207      11.300  -7.627  31.318  1.00 16.39          
ATOM   1438  CG1 ILE   207      11.331  -7.937  29.806  1.00 12.79          
ATOM   1439  CG2 ILE   207      11.698  -6.209  31.584  1.00 16.59          
ATOM   1440  CD  ILE   207      10.947  -6.819  28.879  1.00  2.00          
ATOM   1441  N   LYS   208      13.187  -7.800  34.134  1.00 17.57          
ATOM   1442  CA  LYS   208      13.381  -7.701  35.563  1.00 17.56          
ATOM   1443  C   LYS   208      13.011  -6.268  36.073  1.00 19.46          
ATOM   1444  O   LYS   208      13.293  -5.274  35.393  1.00 19.85          
ATOM   1445  CB  LYS   208      14.850  -7.980  35.832  1.00 16.83          
ATOM   1446  CG  LYS   208      15.186  -9.416  36.200  1.00 17.79          
ATOM   1447  CD  LYS   208      16.607  -9.647  36.821  1.00 16.25          
ATOM   1448  CE  LYS   208      16.938 -11.112  36.501  1.00 17.50          
ATOM   1449  NZ  LYS   208      18.314 -11.787  36.768  1.00 19.20          
ATOM   1450  N   ASP   209      12.458  -6.104  37.272  1.00 20.51          
ATOM   1451  CA  ASP   209      12.470  -4.736  37.817  1.00 22.31          
ATOM   1452  C   ASP   209      13.884  -4.192  37.626  1.00 22.50          
ATOM   1453  O   ASP   209      14.836  -4.889  37.936  1.00 24.58          
ATOM   1454  CB  ASP   209      12.146  -4.695  39.307  1.00 22.60          
ATOM   1455  CG  ASP   209      10.900  -5.413  39.632  1.00 27.86          
ATOM   1456  OD1 ASP   209      10.457  -6.233  38.811  1.00 37.52          
ATOM   1457  OD2 ASP   209      10.281  -5.297  40.704  1.00 36.97          
ATOM   1458  N   GLY   210      14.028  -2.989  37.104  1.00 22.30          
ATOM   1459  CA  GLY   210      15.317  -2.309  37.032  1.00 22.45          
ATOM   1460  C   GLY   210      16.030  -2.257  35.695  1.00 23.56          
ATOM   1461  O   GLY   210      17.188  -1.809  35.648  1.00 25.26          
ATOM   1462  N   ASP   211      15.360  -2.691  34.625  1.00 23.68          
ATOM   1463  CA  ASP   211      16.011  -3.011  33.353  1.00 24.75          
ATOM   1464  C   ASP   211      15.878  -1.864  32.392  1.00 24.32          
ATOM   1465  O   ASP   211      14.784  -1.321  32.298  1.00 28.00          
ATOM   1466  CB  ASP   211      15.278  -4.155  32.676  1.00 25.04          
ATOM   1467  CG  ASP   211      15.546  -5.446  33.290  1.00 30.56          
ATOM   1468  OD1 ASP   211      15.136  -6.482  32.713  1.00 33.42          
ATOM   1469  OD2 ASP   211      16.145  -5.535  34.402  1.00 44.77          
ATOM   1470  N   THR   212      16.875  -1.481  31.625  1.00 21.94          
ATOM   1471  CA  THR   212      16.608  -0.283  30.924  1.00 20.93          
ATOM   1472  C   THR   212      16.240  -0.778  29.528  1.00 21.46          
ATOM   1473  O   THR   212      17.065  -1.300  28.795  1.00 23.37          
ATOM   1474  CB  THR   212      17.758   0.685  31.019  1.00 19.91          
ATOM   1475  OG1 THR   212      18.668   0.356  30.005  1.00 22.00          
ATOM   1476  CG2 THR   212      18.648   0.504  32.338  1.00 18.58          
ATOM   1477  N   LEU   213      14.974  -0.703  29.169  1.00 20.58          
ATOM   1478  CA  LEU   213      14.515  -1.275  27.882  1.00 20.49          
ATOM   1479  C   LEU   213      14.739  -0.574  26.618  1.00 19.69          
ATOM   1480  O   LEU   213      14.684   0.633  26.578  1.00 19.60          
ATOM   1481  CB  LEU   213      12.999  -1.379  27.848  1.00 20.59          
ATOM   1482  CG  LEU   213      12.296  -2.005  29.034  1.00 21.90          
ATOM   1483  CD1 LEU   213      10.809  -1.706  28.961  1.00 19.21          
ATOM   1484  CD2 LEU   213      12.628  -3.471  29.288  1.00 21.22          
ATOM   1485  N   GLN   214      14.786  -1.356  25.547  1.00 21.19          
ATOM   1486  CA  GLN   214      14.546  -0.828  24.185  1.00 22.07          
ATOM   1487  C   GLN   214      13.502  -1.535  23.379  1.00 22.04          
ATOM   1488  O   GLN   214      13.701  -2.684  22.972  1.00 22.52          
ATOM   1489  CB  GLN   214      15.841  -0.800  23.344  1.00 21.66          
ATOM   1490  CG  GLN   214      15.618  -0.185  21.981  1.00 21.15          
ATOM   1491  CD  GLN   214      15.257  -1.200  20.935  1.00 21.70          
ATOM   1492  OE1 GLN   214      16.051  -2.034  20.602  1.00 28.08          
ATOM   1493  NE2 GLN   214      14.049  -1.161  20.463  1.00 24.03          
ATOM   1494  N   LEU   215      12.450  -0.828  23.049  1.00 22.69          
ATOM   1495  CA  LEU   215      11.413  -1.409  22.188  1.00 25.15          
ATOM   1496  C   LEU   215      10.978  -0.597  20.967  1.00 25.59          
ATOM   1497  O   LEU   215      11.200   0.580  20.901  1.00 26.52          
ATOM   1498  CB  LEU   215      10.161  -1.775  23.005  1.00 25.74          
ATOM   1499  CG  LEU   215       9.541  -0.993  24.156  1.00 26.29          
ATOM   1500  CD1 LEU   215       8.096  -0.796  23.764  1.00 31.17          
ATOM   1501  CD2 LEU   215       9.567  -1.838  25.376  1.00 24.51          
ATOM   1502  N   GLY   216      10.324  -1.218  19.997  1.00 26.42          
ATOM   1503  CA  GLY   216       9.684  -0.414  18.961  1.00 25.79          
ATOM   1504  C   GLY   216       8.387   0.302  19.331  1.00 26.57          
ATOM   1505  O   GLY   216       8.164   0.705  20.484  1.00 26.93          
ATOM   1506  N   ILE   217       7.560   0.482  18.292  1.00 27.62          
ATOM   1507  CA  ILE   217       6.205   1.087  18.315  1.00 28.03          
ATOM   1508  C   ILE   217       5.204   0.168  17.525  1.00 28.39          
ATOM   1509  O   ILE   217       5.488  -0.246  16.423  1.00 29.49          
ATOM   1510  CB  ILE   217       6.214   2.547  17.722  1.00 27.25          
ATOM   1511  CG1 ILE   217       5.820   2.609  16.237  1.00 27.68          
ATOM   1512  CG2 ILE   217       7.548   3.206  17.915  1.00 27.70          
ATOM   1513  CD  ILE   217       6.871   2.119  15.225  1.00 18.93          
ATOM   1514  N   GLY   218       4.055  -0.156  18.079  1.00 28.19          
ATOM   1515  CA  GLY   218       3.222  -1.151  17.446  1.00 27.63          
ATOM   1516  C   GLY   218       2.568  -2.040  18.468  1.00 27.23          
ATOM   1517  O   GLY   218       3.004  -2.114  19.601  1.00 26.66          
ATOM   1518  N   GLY   219       1.514  -2.715  18.066  1.00 26.86          
ATOM   1519  CA  GLY   219       0.976  -3.779  18.879  1.00 28.57          
ATOM   1520  C   GLY   219       1.951  -4.441  19.880  1.00 30.43          
ATOM   1521  O   GLY   219       1.715  -4.355  21.133  1.00 29.92          
ATOM   1522  N   ILE   220       3.018  -5.109  19.372  1.00 30.30          
ATOM   1523  CA  ILE   220       3.917  -5.833  20.270  1.00 30.69          
ATOM   1524  C   ILE   220       4.468  -4.924  21.427  1.00 31.42          
ATOM   1525  O   ILE   220       4.224  -5.228  22.641  1.00 31.44          
ATOM   1526  CB  ILE   220       4.990  -6.584  19.506  1.00 31.04          
ATOM   1527  CG1 ILE   220       4.389  -7.833  18.850  1.00 31.94          
ATOM   1528  CG2 ILE   220       6.058  -7.048  20.419  1.00 32.04          
ATOM   1529  CD  ILE   220       4.178  -7.687  17.269  1.00 34.09          
ATOM   1530  N   PRO   221       5.175  -3.825  21.086  1.00 30.88          
ATOM   1531  CA  PRO   221       5.609  -2.844  22.090  1.00 29.34          
ATOM   1532  C   PRO   221       4.562  -2.373  23.097  1.00 28.20          
ATOM   1533  O   PRO   221       4.829  -2.362  24.329  1.00 30.04          
ATOM   1534  CB  PRO   221       6.132  -1.696  21.240  1.00 29.55          
ATOM   1535  CG  PRO   221       6.808  -2.418  20.135  1.00 31.82          
ATOM   1536  CD  PRO   221       5.723  -3.489  19.745  1.00 32.40          
ATOM   1537  N   ASP   222       3.389  -2.000  22.615  1.00 24.79          
ATOM   1538  CA  ASP   222       2.361  -1.552  23.510  1.00 22.23          
ATOM   1539  C   ASP   222       1.869  -2.714  24.293  1.00 21.12          
ATOM   1540  O   ASP   222       1.383  -2.522  25.376  1.00 21.37          
ATOM   1541  CB  ASP   222       1.198  -0.936  22.757  1.00 22.55          
ATOM   1542  CG  ASP   222       0.198  -0.284  23.665  1.00 23.28          
ATOM   1543  OD1 ASP   222       0.388   0.888  24.069  1.00 25.31          
ATOM   1544  OD2 ASP   222      -0.834  -0.890  24.044  1.00 27.94          
ATOM   1545  N   ALA   223       1.985  -3.924  23.767  1.00 20.69          
ATOM   1546  CA  ALA   223       1.583  -5.110  24.534  1.00 20.25          
ATOM   1547  C   ALA   223       2.562  -5.275  25.651  1.00 19.97          
ATOM   1548  O   ALA   223       2.133  -5.568  26.805  1.00 19.58          
ATOM   1549  CB  ALA   223       1.545  -6.377  23.687  1.00 20.23          
ATOM   1550  N   VAL   224       3.851  -5.050  25.333  1.00 18.88          
ATOM   1551  CA  VAL   224       4.902  -5.406  26.265  1.00 18.40          
ATOM   1552  C   VAL   224       4.758  -4.524  27.439  1.00 19.07          
ATOM   1553  O   VAL   224       4.867  -4.988  28.567  1.00 20.31          
ATOM   1554  CB  VAL   224       6.270  -5.057  25.813  1.00 18.39          
ATOM   1555  CG1 VAL   224       7.274  -5.574  26.842  1.00 16.70          
ATOM   1556  CG2 VAL   224       6.540  -5.597  24.488  1.00 19.20          
ATOM   1557  N   LEU   225       4.570  -3.230  27.183  1.00 18.44          
ATOM   1558  CA  LEU   225       4.441  -2.275  28.245  1.00 17.66          
ATOM   1559  C   LEU   225       3.165  -2.539  29.039  1.00 18.50          
ATOM   1560  O   LEU   225       3.178  -2.369  30.227  1.00 17.98          
ATOM   1561  CB  LEU   225       4.368  -0.911  27.635  1.00 18.15          
ATOM   1562  CG  LEU   225       5.519   0.063  27.547  1.00 16.54          
ATOM   1563  CD1 LEU   225       6.807  -0.745  27.593  1.00 13.33          
ATOM   1564  CD2 LEU   225       5.155   0.738  26.224  1.00 10.62          
ATOM   1565  N   ARG   226       2.072  -2.995  28.398  1.00 19.55          
ATOM   1566  CA  ARG   226       0.893  -3.477  29.149  1.00 20.11          
ATOM   1567  C   ARG   226       1.278  -4.580  30.110  1.00 22.20          
ATOM   1568  O   ARG   226       0.963  -4.486  31.297  1.00 24.87          
ATOM   1569  CB  ARG   226      -0.282  -3.894  28.284  1.00 19.16          
ATOM   1570  CG  ARG   226      -1.251  -2.764  27.843  1.00 19.28          
ATOM   1571  CD  ARG   226      -1.655  -1.708  28.927  1.00 23.97          
ATOM   1572  NE  ARG   226      -2.347  -0.622  28.222  1.00 33.81          
ATOM   1573  CZ  ARG   226      -2.864   0.543  28.714  1.00 37.52          
ATOM   1574  NH1 ARG   226      -2.782   0.921  29.999  1.00 39.99          
ATOM   1575  NH2 ARG   226      -3.485   1.348  27.860  1.00 37.40          
ATOM   1576  N   ALA   227       2.015  -5.605  29.654  1.00 23.51          
ATOM   1577  CA  ALA   227       2.486  -6.715  30.546  1.00 22.45          
ATOM   1578  C   ALA   227       3.381  -6.219  31.699  1.00 22.97          
ATOM   1579  O   ALA   227       3.684  -6.954  32.627  1.00 23.97          
ATOM   1580  CB  ALA   227       3.220  -7.806  29.701  1.00 21.79          
ATOM   1581  N   LEU   228       3.868  -4.989  31.665  1.00 22.94          
ATOM   1582  CA  LEU   228       4.921  -4.636  32.670  1.00 22.77          
ATOM   1583  C   LEU   228       4.353  -3.720  33.786  1.00 22.27          
ATOM   1584  O   LEU   228       5.118  -3.066  34.526  1.00 20.34          
ATOM   1585  CB  LEU   228       6.147  -3.992  31.958  1.00 21.55          
ATOM   1586  CG  LEU   228       6.944  -4.895  31.001  1.00 22.59          
ATOM   1587  CD1 LEU   228       7.419  -4.168  29.814  1.00 21.48          
ATOM   1588  CD2 LEU   228       8.123  -5.637  31.628  1.00 20.92          
ATOM   1589  N   GLU   229       3.023  -3.634  33.843  1.00 21.51          
ATOM   1590  CA  GLU   229       2.408  -2.746  34.794  1.00 23.44          
ATOM   1591  C   GLU   229       2.658  -3.173  36.268  1.00 22.58          
ATOM   1592  O   GLU   229       2.599  -2.326  37.158  1.00 23.33          
ATOM   1593  CB  GLU   229       0.909  -2.450  34.467  1.00 24.34          
ATOM   1594  CG  GLU   229       0.639  -1.940  33.040  1.00 25.41          
ATOM   1595  CD  GLU   229      -0.679  -1.206  32.891  1.00 26.61          
ATOM   1596  OE1 GLU   229      -0.926  -0.544  31.820  1.00 32.26          
ATOM   1597  OE2 GLU   229      -1.441  -1.237  33.867  1.00 30.14          
ATOM   1598  N   GLY   230       3.031  -4.440  36.508  1.00 21.83          
ATOM   1599  CA  GLY   230       3.571  -4.870  37.800  1.00 19.35          
ATOM   1600  C   GLY   230       5.081  -4.788  38.017  1.00 19.16          
ATOM   1601  O   GLY   230       5.629  -5.396  38.969  1.00 19.33          
ATOM   1602  N   HSD   231       5.776  -4.026  37.180  1.00 18.78          
ATOM   1603  CA  HSD   231       7.225  -3.836  37.315  1.00 18.20          
ATOM   1604  C   HSD   231       7.534  -2.510  37.959  1.00 18.51          
ATOM   1605  O   HSD   231       6.675  -1.642  38.052  1.00 18.76          
ATOM   1606  CB  HSD   231       7.952  -4.040  35.962  1.00 17.92          
ATOM   1607  CG  HSD   231       8.013  -5.490  35.527  1.00 19.93          
ATOM   1608  ND1 HSD   231       9.166  -6.240  35.586  1.00 18.47          
ATOM   1609  CD2 HSD   231       7.034  -6.350  35.117  1.00 21.96          
ATOM   1610  CE1 HSD   231       8.896  -7.488  35.236  1.00 16.66          
ATOM   1611  NE2 HSD   231       7.615  -7.582  34.946  1.00 13.36          
ATOM   1612  N   LYS   232       8.767  -2.392  38.425  1.00 19.17          
ATOM   1613  CA  LYS   232       9.283  -1.257  39.160  1.00 19.80          
ATOM   1614  C   LYS   232      10.530  -0.792  38.486  1.00 19.40          
ATOM   1615  O   LYS   232      11.165  -1.574  37.773  1.00 19.57          
ATOM   1616  CB  LYS   232       9.690  -1.721  40.566  1.00 21.37          
ATOM   1617  CG  LYS   232       8.553  -2.441  41.391  1.00 25.41          
ATOM   1618  CD  LYS   232       7.229  -1.578  41.521  1.00 31.08          
ATOM   1619  CE  LYS   232       5.976  -2.321  42.119  1.00 29.36          
ATOM   1620  NZ  LYS   232       4.802  -1.495  41.650  1.00 34.30          
ATOM   1621  N   ASP   233      10.890   0.489  38.698  1.00 19.15          
ATOM   1622  CA  ASP   233      12.188   1.140  38.224  1.00 16.43          
ATOM   1623  C   ASP   233      12.707   0.923  36.810  1.00 14.29          
ATOM   1624  O   ASP   233      13.884   0.817  36.637  1.00 13.53          
ATOM   1625  CB  ASP   233      13.294   0.843  39.226  1.00 16.38          
ATOM   1626  CG  ASP   233      12.886   1.279  40.682  1.00 21.20          
ATOM   1627  OD1 ASP   233      12.220   2.367  40.840  1.00 22.38          
ATOM   1628  OD2 ASP   233      13.132   0.584  41.724  1.00 23.08          
ATOM   1629  N   LEU   234      11.860   0.885  35.788  1.00 12.58          
ATOM   1630  CA  LEU   234      12.390   0.530  34.513  1.00 12.65          
ATOM   1631  C   LEU   234      13.061   1.770  33.909  1.00 13.60          
ATOM   1632  O   LEU   234      12.809   2.928  34.348  1.00 15.29          
ATOM   1633  CB  LEU   234      11.246   0.073  33.673  1.00 13.18          
ATOM   1634  CG  LEU   234      10.472  -1.233  33.971  1.00 11.95          
ATOM   1635  CD1 LEU   234       9.550  -1.446  32.757  1.00  4.48          
ATOM   1636  CD2 LEU   234      11.392  -2.440  34.098  1.00  8.54          
ATOM   1637  N   GLY   235      13.894   1.603  32.902  1.00 11.75          
ATOM   1638  CA  GLY   235      14.590   2.768  32.387  1.00 10.57          
ATOM   1639  C   GLY   235      14.341   2.721  30.926  1.00 11.33          
ATOM   1640  O   GLY   235      13.836   1.751  30.467  1.00 10.45          
ATOM   1641  N   ILE   236      14.684   3.762  30.158  1.00 12.93          
ATOM   1642  CA  ILE   236      14.515   3.692  28.684  1.00 12.17          
ATOM   1643  C   ILE   236      15.789   4.100  27.954  1.00 11.89          
ATOM   1644  O   ILE   236      16.436   5.042  28.340  1.00 10.31          
ATOM   1645  CB  ILE   236      13.327   4.613  28.259  1.00 12.73          
ATOM   1646  CG1 ILE   236      12.033   4.033  28.822  1.00 12.46          
ATOM   1647  CG2 ILE   236      13.191   4.815  26.666  1.00 11.82          
ATOM   1648  CD  ILE   236      11.482   2.820  28.040  1.00  7.82          
ATOM   1649  N   HSD   237      16.092   3.381  26.888  1.00 11.86          
ATOM   1650  CA  HSD   237      17.087   3.820  25.979  1.00 14.23          
ATOM   1651  C   HSD   237      16.755   3.223  24.555  1.00 15.14          
ATOM   1652  O   HSD   237      17.312   2.257  24.173  1.00 14.07          
ATOM   1653  CB  HSD   237      18.458   3.488  26.569  1.00 14.53          
ATOM   1654  CG  HSD   237      19.632   3.938  25.738  1.00 17.07          
ATOM   1655  ND1 HSD   237      20.524   4.896  26.172  1.00 19.74          
ATOM   1656  CD2 HSD   237      20.095   3.517  24.531  1.00 15.39          
ATOM   1657  CE1 HSD   237      21.470   5.059  25.252  1.00 17.99          
ATOM   1658  NE2 HSD   237      21.220   4.250  24.240  1.00 14.05          
ATOM   1659  N   THR   238      15.813   3.822  23.798  1.00 17.07          
ATOM   1660  CA  THR   238      15.373   3.248  22.530  1.00 19.61          
ATOM   1661  C   THR   238      15.813   4.125  21.393  1.00 21.46          
ATOM   1662  O   THR   238      16.131   5.314  21.587  1.00 20.45          
ATOM   1663  CB  THR   238      13.822   3.154  22.367  1.00 18.66          
ATOM   1664  OG1 THR   238      13.290   4.352  22.879  1.00 22.31          
ATOM   1665  CG2 THR   238      13.164   2.145  23.274  1.00 19.60          
ATOM   1666  N   GLU   239      15.788   3.545  20.181  1.00 22.70          
ATOM   1667  CA  GLU   239      15.795   4.449  19.136  1.00 24.55          
ATOM   1668  C   GLU   239      14.488   5.180  18.952  1.00 24.89          
ATOM   1669  O   GLU   239      14.525   6.188  18.343  1.00 27.00          
ATOM   1670  CB  GLU   239      16.380   3.912  17.855  1.00 24.42          
ATOM   1671  CG  GLU   239      15.682   2.737  17.205  1.00 30.11          
ATOM   1672  CD  GLU   239      16.247   2.521  15.780  1.00 32.72          
ATOM   1673  OE1 GLU   239      15.854   3.354  14.877  1.00 33.44          
ATOM   1674  OE2 GLU   239      17.073   1.539  15.581  1.00 30.87          
ATOM   1675  N   MET   240      13.328   4.725  19.419  1.00 25.49          
ATOM   1676  CA  MET   240      12.113   5.626  19.293  1.00 25.76          
ATOM   1677  C   MET   240      11.042   5.358  20.275  1.00 23.01          
ATOM   1678  O   MET   240      11.016   4.334  20.833  1.00 23.27          
ATOM   1679  CB  MET   240      11.495   5.597  17.906  1.00 25.16          
ATOM   1680  CG  MET   240      11.009   4.236  17.505  1.00 25.35          
ATOM   1681  SD  MET   240      10.797   4.098  15.642  1.00 29.88          
ATOM   1682  CE  MET   240      12.474   4.102  14.858  1.00 24.78          
ATOM   1683  N   PHE   241      10.138   6.252  20.498  1.00 21.37          
ATOM   1684  CA  PHE   241       9.069   5.788  21.325  1.00 22.17          
ATOM   1685  C   PHE   241       7.782   6.518  21.068  1.00 24.09          
ATOM   1686  O   PHE   241       7.813   7.600  20.401  1.00 24.75          
ATOM   1687  CB  PHE   241       9.455   5.775  22.819  1.00 21.03          
ATOM   1688  CG  PHE   241       9.585   7.095  23.408  1.00 16.06          
ATOM   1689  CD1 PHE   241      10.840   7.611  23.657  1.00 13.92          
ATOM   1690  CD2 PHE   241       8.464   7.878  23.644  1.00 14.26          
ATOM   1691  CE1 PHE   241      11.011   8.955  24.179  1.00 11.31          
ATOM   1692  CE2 PHE   241       8.594   9.212  24.188  1.00 13.29          
ATOM   1693  CZ  PHE   241       9.893   9.737  24.479  1.00 13.04          
ATOM   1694  N   THR   242       6.661   5.934  21.552  1.00 24.87          
ATOM   1695  CA  THR   242       5.298   6.567  21.364  1.00 25.68          
ATOM   1696  C   THR   242       4.589   6.827  22.695  1.00 25.35          
ATOM   1697  O   THR   242       5.185   6.806  23.798  1.00 26.43          
ATOM   1698  CB  THR   242       4.272   5.728  20.490  1.00 25.87          
ATOM   1699  OG1 THR   242       4.911   4.850  19.551  1.00 26.53          
ATOM   1700  CG2 THR   242       3.300   6.629  19.636  1.00 25.62          
ATOM   1701  N   ASP   243       3.278   6.977  22.573  1.00 24.59          
ATOM   1702  CA  ASP   243       2.403   7.180  23.722  1.00 23.22          
ATOM   1703  C   ASP   243       2.551   6.156  24.774  1.00 22.51          
ATOM   1704  O   ASP   243       2.206   6.455  25.857  1.00 22.53          
ATOM   1705  CB  ASP   243       0.952   7.220  23.303  1.00 21.85          
ATOM   1706  CG  ASP   243       0.672   8.286  22.269  1.00 22.67          
ATOM   1707  OD1 ASP   243      -0.402   8.932  22.405  1.00 20.86          
ATOM   1708  OD2 ASP   243       1.450   8.543  21.292  1.00 24.08          
ATOM   1709  N   GLY   244       3.064   4.965  24.480  1.00 22.90          
ATOM   1710  CA  GLY   244       3.095   3.892  25.495  1.00 24.28          
ATOM   1711  C   GLY   244       4.013   4.258  26.633  1.00 24.94          
ATOM   1712  O   GLY   244       3.692   4.135  27.850  1.00 24.13          
ATOM   1713  N   VAL   245       5.147   4.806  26.214  1.00 25.90          
ATOM   1714  CA  VAL   245       6.163   5.285  27.153  1.00 26.45          
ATOM   1715  C   VAL   245       5.666   6.353  28.117  1.00 25.35          
ATOM   1716  O   VAL   245       6.105   6.355  29.294  1.00 26.37          
ATOM   1717  CB  VAL   245       7.411   5.783  26.395  1.00 27.02          
ATOM   1718  CG1 VAL   245       8.526   6.303  27.363  1.00 27.54          
ATOM   1719  CG2 VAL   245       7.947   4.605  25.630  1.00 29.22          
ATOM   1720  N   MET   246       4.803   7.258  27.611  1.00 21.99          
ATOM   1721  CA  MET   246       4.232   8.360  28.387  1.00 19.63          
ATOM   1722  C   MET   246       3.428   7.825  29.532  1.00 18.56          
ATOM   1723  O   MET   246       3.531   8.240  30.689  1.00 17.82          
ATOM   1724  CB  MET   246       3.377   9.276  27.486  1.00 19.91          
ATOM   1725  CG  MET   246       2.654  10.471  28.205  1.00 19.09          
ATOM   1726  SD  MET   246       1.859  11.454  26.969  1.00 17.34          
ATOM   1727  CE  MET   246       0.647  10.285  26.306  1.00  8.82          
ATOM   1728  N   ARG   247       2.676   6.847  29.139  1.00 18.05          
ATOM   1729  CA  ARG   247       1.735   6.172  29.938  1.00 19.68          
ATOM   1730  C   ARG   247       2.466   5.535  31.179  1.00 19.93          
ATOM   1731  O   ARG   247       2.005   5.571  32.341  1.00 20.05          
ATOM   1732  CB  ARG   247       1.087   5.094  29.014  1.00 18.80          
ATOM   1733  CG  ARG   247      -0.400   4.918  29.217  1.00 20.72          
ATOM   1734  CD  ARG   247      -0.880   3.468  29.574  1.00 24.96          
ATOM   1735  NE  ARG   247      -0.035   2.373  29.049  1.00 22.71          
ATOM   1736  CZ  ARG   247      -0.068   1.998  27.802  1.00 22.34          
ATOM   1737  NH1 ARG   247      -0.896   2.624  26.973  1.00 22.11          
ATOM   1738  NH2 ARG   247       0.714   1.027  27.375  1.00 24.44          
ATOM   1739  N   MET   248       3.602   4.917  30.926  1.00 18.85          
ATOM   1740  CA  MET   248       4.209   4.239  31.982  1.00 17.96          
ATOM   1741  C   MET   248       5.036   5.212  32.782  1.00 18.70          
ATOM   1742  O   MET   248       5.252   5.007  33.981  1.00 20.03          
ATOM   1743  CB  MET   248       5.116   3.228  31.386  1.00 17.70          
ATOM   1744  CG  MET   248       4.418   2.293  30.567  1.00 17.42          
ATOM   1745  SD  MET   248       3.629   1.020  31.569  1.00 24.47          
ATOM   1746  CE  MET   248       2.262   0.713  30.320  1.00 17.96          
ATOM   1747  N   ILE   249       5.557   6.248  32.133  1.00 18.31          
ATOM   1748  CA  ILE   249       6.271   7.237  32.879  1.00 17.62          
ATOM   1749  C   ILE   249       5.240   7.765  33.818  1.00 16.64          
ATOM   1750  O   ILE   249       5.458   7.748  35.006  1.00 15.79          
ATOM   1751  CB  ILE   249       6.832   8.318  32.011  1.00 18.59          
ATOM   1752  CG1 ILE   249       7.928   7.717  31.135  1.00 17.49          
ATOM   1753  CG2 ILE   249       7.316   9.498  32.952  1.00 15.40          
ATOM   1754  CD  ILE   249       8.461   8.626  30.065  1.00 20.17          
ATOM   1755  N   ARG   250       4.100   8.135  33.256  1.00 16.55          
ATOM   1756  CA  ARG   250       2.920   8.538  34.008  1.00 17.53          
ATOM   1757  C   ARG   250       2.548   7.629  35.199  1.00 18.21          
ATOM   1758  O   ARG   250       2.351   8.120  36.280  1.00 18.73          
ATOM   1759  CB  ARG   250       1.730   8.642  33.075  1.00 17.78          
ATOM   1760  CG  ARG   250       1.046   9.911  33.188  1.00 17.46          
ATOM   1761  CD  ARG   250       1.548  10.911  32.237  1.00 16.65          
ATOM   1762  NE  ARG   250       0.618  11.099  31.150  1.00 23.19          
ATOM   1763  CZ  ARG   250       0.257  12.289  30.654  1.00 26.43          
ATOM   1764  NH1 ARG   250       0.756  13.440  31.171  1.00 28.12          
ATOM   1765  NH2 ARG   250      -0.613  12.318  29.636  1.00 23.58          
ATOM   1766  N   LYS   251       2.469   6.306  35.032  1.00 18.47          
ATOM   1767  CA  LYS   251       2.044   5.435  36.135  1.00 16.46          
ATOM   1768  C   LYS   251       3.147   5.311  37.154  1.00 17.34          
ATOM   1769  O   LYS   251       2.964   4.690  38.145  1.00 18.42          
ATOM   1770  CB  LYS   251       1.644   4.042  35.629  1.00 16.13          
ATOM   1771  CG  LYS   251       0.369   3.947  34.753  1.00 14.48          
ATOM   1772  CD  LYS   251       0.467   2.768  33.741  1.00 14.75          
ATOM   1773  CE  LYS   251      -0.819   1.948  33.528  1.00 11.04          
ATOM   1774  NZ  LYS   251      -1.991   2.826  33.278  1.00 19.87          
ATOM   1775  N   GLY   252       4.321   5.865  36.932  1.00 18.53          
ATOM   1776  CA  GLY   252       5.419   5.649  37.925  1.00 19.87          
ATOM   1777  C   GLY   252       6.394   4.484  37.631  1.00 20.82          
ATOM   1778  O   GLY   252       7.458   4.385  38.230  1.00 21.98          
ATOM   1779  N   ILE   253       6.049   3.613  36.687  1.00 20.63          
ATOM   1780  CA  ILE   253       6.902   2.512  36.282  1.00 19.90          
ATOM   1781  C   ILE   253       8.167   2.891  35.526  1.00 19.08          
ATOM   1782  O   ILE   253       9.234   2.388  35.867  1.00 19.65          
ATOM   1783  CB  ILE   253       6.078   1.480  35.538  1.00 20.01          
ATOM   1784  CG1 ILE   253       4.925   1.025  36.444  1.00 23.11          
ATOM   1785  CG2 ILE   253       6.881   0.282  35.157  1.00 19.37          
ATOM   1786  CD  ILE   253       5.285   0.622  37.998  1.00 26.82          
ATOM   1787  N   ILE   254       8.117   3.755  34.524  1.00 18.65          
ATOM   1788  CA  ILE   254       9.426   4.152  33.901  1.00 18.67          
ATOM   1789  C   ILE   254      10.048   5.300  34.645  1.00 19.24          
ATOM   1790  O   ILE   254       9.433   6.351  34.708  1.00 20.05          
ATOM   1791  CB  ILE   254       9.245   4.516  32.441  1.00 18.32          
ATOM   1792  CG1 ILE   254       9.309   3.239  31.629  1.00 17.08          
ATOM   1793  CG2 ILE   254      10.370   5.307  31.959  1.00 17.30          
ATOM   1794  CD  ILE   254       8.268   3.087  30.711  1.00  9.43          
ATOM   1795  N   ASN   255      11.227   5.102  35.236  1.00 19.18          
ATOM   1796  CA  ASN   255      11.890   6.166  36.023  1.00 19.73          
ATOM   1797  C   ASN   255      13.429   6.188  35.921  1.00 20.66          
ATOM   1798  O   ASN   255      14.113   7.123  36.391  1.00 19.58          
ATOM   1799  CB  ASN   255      11.451   6.182  37.469  1.00 18.06          
ATOM   1800  CG  ASN   255      11.736   4.843  38.220  1.00 23.75          
ATOM   1801  OD1 ASN   255      10.875   4.402  39.028  1.00 31.19          
ATOM   1802  ND2 ASN   255      12.918   4.207  38.001  1.00 15.98          
ATOM   1803  N   GLY   256      13.969   5.151  35.271  1.00 22.20          
ATOM   1804  CA  GLY   256      15.411   4.967  35.135  1.00 22.81          
ATOM   1805  C   GLY   256      16.139   5.368  36.377  1.00 23.58          
ATOM   1806  O   GLY   256      17.062   6.107  36.275  1.00 24.29          
ATOM   1807  N   LYS   257      15.724   4.877  37.548  1.00 24.46          
ATOM   1808  CA  LYS   257      16.408   5.199  38.774  1.00 25.58          
ATOM   1809  C   LYS   257      17.650   4.351  38.838  1.00 26.54          
ATOM   1810  O   LYS   257      18.612   4.736  39.521  1.00 26.98          
ATOM   1811  CB  LYS   257      15.562   4.908  40.010  1.00 26.07          
ATOM   1812  CG  LYS   257      14.300   5.792  40.168  1.00 27.18          
ATOM   1813  CD  LYS   257      14.007   6.142  41.581  1.00 23.28          
ATOM   1814  CE  LYS   257      14.330   7.560  41.821  1.00 25.00          
ATOM   1815  NZ  LYS   257      13.474   7.915  42.942  1.00 28.08          
ATOM   1816  N   LYS   258      17.622   3.213  38.107  1.00 27.05          
ATOM   1817  CA  LYS   258      18.687   2.179  38.040  1.00 25.44          
ATOM   1818  C   LYS   258      19.542   2.323  36.819  1.00 24.78          
ATOM   1819  O   LYS   258      20.668   1.857  36.785  1.00 24.36          
ATOM   1820  CB  LYS   258      18.048   0.800  38.028  1.00 26.34          
ATOM   1821  CG  LYS   258      17.987   0.251  39.460  1.00 28.29          
ATOM   1822  CD  LYS   258      16.632  -0.260  39.845  1.00 29.34          
ATOM   1823  CE  LYS   258      16.715  -1.156  41.110  1.00 33.11          
ATOM   1824  NZ  LYS   258      15.580  -2.224  41.078  1.00 31.00          
ATOM   1825  N   LYS   259      19.027   3.006  35.805  1.00 24.34          
ATOM   1826  CA  LYS   259      19.866   3.396  34.671  1.00 23.82          
ATOM   1827  C   LYS   259      21.349   3.612  35.106  1.00 23.44          
ATOM   1828  O   LYS   259      21.608   4.320  36.060  1.00 24.10          
ATOM   1829  CB  LYS   259      19.266   4.632  34.006  1.00 23.20          
ATOM   1830  CG  LYS   259      17.897   4.376  33.452  1.00 22.43          
ATOM   1831  CD  LYS   259      17.506   5.354  32.415  1.00 28.86          
ATOM   1832  CE  LYS   259      18.616   5.669  31.344  1.00 30.79          
ATOM   1833  NZ  LYS   259      18.273   5.259  29.989  1.00 30.81          
ATOM   1834  N   THR   260      22.329   2.986  34.464  1.00 22.57          
ATOM   1835  CA  THR   260      23.683   3.431  34.768  1.00 20.70          
ATOM   1836  C   THR   260      24.186   4.390  33.723  1.00 21.23          
ATOM   1837  O   THR   260      25.378   4.731  33.764  1.00 20.32          
ATOM   1838  CB  THR   260      24.638   2.327  34.805  1.00 19.78          
ATOM   1839  OG1 THR   260      24.689   1.754  33.506  1.00 17.26          
ATOM   1840  CG2 THR   260      24.116   1.240  35.665  1.00 21.11          
ATOM   1841  N   LEU   261      23.306   4.814  32.799  1.00 21.34          
ATOM   1842  CA  LEU   261      23.675   5.793  31.783  1.00 23.14          
ATOM   1843  C   LEU   261      22.524   6.723  31.588  1.00 24.81          
ATOM   1844  O   LEU   261      21.416   6.266  31.289  1.00 26.86          
ATOM   1845  CB  LEU   261      23.985   5.125  30.447  1.00 23.62          
ATOM   1846  CG  LEU   261      24.469   6.006  29.295  1.00 24.98          
ATOM   1847  CD1 LEU   261      25.641   6.733  29.920  1.00 24.21          
ATOM   1848  CD2 LEU   261      24.902   5.233  27.999  1.00 22.89          
ATOM   1849  N   HSD   262      22.769   8.029  31.726  1.00 25.66          
ATOM   1850  CA  HSD   262      21.694   9.047  31.774  1.00 25.43          
ATOM   1851  C   HSD   262      20.606   8.694  32.809  1.00 25.43          
ATOM   1852  O   HSD   262      19.400   8.507  32.491  1.00 25.49          
ATOM   1853  CB  HSD   262      21.123   9.273  30.387  1.00 25.72          
ATOM   1854  CG  HSD   262      22.161   9.593  29.365  1.00 26.70          
ATOM   1855  ND1 HSD   262      22.940  10.734  29.429  1.00 30.00          
ATOM   1856  CD2 HSD   262      22.558   8.925  28.251  1.00 29.05          
ATOM   1857  CE1 HSD   262      23.787  10.741  28.410  1.00 30.18          
ATOM   1858  NE2 HSD   262      23.570   9.661  27.672  1.00 28.18          
ATOM   1859  N   PRO   263      21.050   8.563  34.063  1.00 25.32          
ATOM   1860  CA  PRO   263      20.163   8.111  35.142  1.00 24.95          
ATOM   1861  C   PRO   263      19.022   9.085  35.301  1.00 25.18          
ATOM   1862  O   PRO   263      19.204  10.291  35.158  1.00 25.97          
ATOM   1863  CB  PRO   263      21.061   8.125  36.347  1.00 24.17          
ATOM   1864  CG  PRO   263      22.093   9.062  35.999  1.00 24.04          
ATOM   1865  CD  PRO   263      22.405   8.850  34.548  1.00 24.15          
ATOM   1866  N   GLU   264      17.848   8.547  35.519  1.00 25.21          
ATOM   1867  CA  GLU   264      16.617   9.312  35.687  1.00 25.71          
ATOM   1868  C   GLU   264      16.072   9.975  34.445  1.00 25.87          
ATOM   1869  O   GLU   264      15.355  10.915  34.551  1.00 27.75          
ATOM   1870  CB  GLU   264      16.710  10.283  36.848  1.00 24.65          
ATOM   1871  CG  GLU   264      16.980   9.562  38.142  1.00 28.73          
ATOM   1872  CD  GLU   264      16.710  10.417  39.387  1.00 36.35          
ATOM   1873  OE1 GLU   264      16.402  11.622  39.194  1.00 32.30          
ATOM   1874  OE2 GLU   264      16.799   9.881  40.567  1.00 40.64          
ATOM   1875  N   LYS   265      16.397   9.508  33.247  1.00 26.26          
ATOM   1876  CA  LYS   265      15.773  10.138  32.060  1.00 25.30          
ATOM   1877  C   LYS   265      15.588   9.139  30.967  1.00 23.93          
ATOM   1878  O   LYS   265      16.216   8.082  31.031  1.00 22.95          
ATOM   1879  CB  LYS   265      16.521  11.396  31.572  1.00 25.30          
ATOM   1880  CG  LYS   265      17.999  11.392  31.753  1.00 23.49          
ATOM   1881  CD  LYS   265      18.537  12.851  31.851  1.00 25.73          
ATOM   1882  CE  LYS   265      18.194  13.669  33.110  1.00 22.99          
ATOM   1883  NZ  LYS   265      16.841  14.130  32.978  1.00 21.22          
ATOM   1884  N   VAL   266      14.681   9.445  30.034  1.00 21.97          
ATOM   1885  CA  VAL   266      14.350   8.481  29.009  1.00 22.09          
ATOM   1886  C   VAL   266      15.063   9.017  27.839  1.00 20.95          
ATOM   1887  O   VAL   266      14.786  10.155  27.411  1.00 21.34          
ATOM   1888  CB  VAL   266      12.865   8.427  28.588  1.00 22.10          
ATOM   1889  CG1 VAL   266      12.017   7.637  29.527  1.00 23.90          
ATOM   1890  CG2 VAL   266      12.316   9.727  28.658  1.00 26.27          
ATOM   1891  N   VAL   267      15.968   8.216  27.289  1.00 18.90          
ATOM   1892  CA  VAL   267      16.637   8.674  26.124  1.00 17.83          
ATOM   1893  C   VAL   267      16.161   7.980  24.872  1.00 18.03          
ATOM   1894  O   VAL   267      15.999   6.787  24.904  1.00 18.18          
ATOM   1895  CB  VAL   267      18.149   8.788  26.354  1.00 17.45          
ATOM   1896  CG1 VAL   267      18.326   9.442  27.692  1.00 19.09          
ATOM   1897  CG2 VAL   267      18.926   7.470  26.342  1.00 16.50          
ATOM   1898  N   THR   268      15.800   8.747  23.834  1.00 18.69          
ATOM   1899  CA  THR   268      15.867   8.328  22.415  1.00 18.82          
ATOM   1900  C   THR   268      16.528   9.294  21.340  1.00 19.64          
ATOM   1901  O   THR   268      17.263  10.328  21.569  1.00 19.50          
ATOM   1902  CB  THR   268      14.443   7.918  21.861  1.00 19.23          
ATOM   1903  OG1 THR   268      13.448   8.911  22.152  1.00 18.94          
ATOM   1904  CG2 THR   268      13.892   6.785  22.597  1.00 22.28          
ATOM   1905  N   SER   269      16.147   8.946  20.118  1.00 20.36          
ATOM   1906  CA  SER   269      16.682   9.470  18.915  1.00 19.34          
ATOM   1907  C   SER   269      15.478   9.963  18.172  1.00 18.38          
ATOM   1908  O   SER   269      15.615  10.794  17.336  1.00 21.31          
ATOM   1909  CB  SER   269      17.360   8.346  18.144  1.00 19.04          
ATOM   1910  OG  SER   269      18.307   8.863  17.264  1.00 20.66          
ATOM   1911  N   LEU   270      14.296   9.494  18.466  1.00 17.43          
ATOM   1912  CA  LEU   270      13.105  10.151  17.949  1.00 17.60          
ATOM   1913  C   LEU   270      11.888   9.691  18.661  1.00 17.44          
ATOM   1914  O   LEU   270      11.913   8.715  19.400  1.00 17.28          
ATOM   1915  CB  LEU   270      12.892   9.921  16.450  1.00 17.94          
ATOM   1916  CG  LEU   270      12.873   8.510  15.887  1.00 17.96          
ATOM   1917  CD1 LEU   270      11.968   8.538  14.723  1.00 16.63          
ATOM   1918  CD2 LEU   270      14.294   8.116  15.450  1.00 17.38          
ATOM   1919  N   ILE   271      10.818  10.425  18.384  1.00 17.56          
ATOM   1920  CA  ILE   271       9.483  10.300  19.002  1.00 17.43          
ATOM   1921  C   ILE   271       8.325  10.663  18.051  1.00 17.75          
ATOM   1922  O   ILE   271       8.351  11.700  17.419  1.00 20.25          
ATOM   1923  CB  ILE   271       9.394  11.279  20.141  1.00 16.82          
ATOM   1924  CG1 ILE   271      10.610  11.241  21.042  1.00 13.61          
ATOM   1925  CG2 ILE   271       8.137  11.039  20.956  1.00 20.27          
ATOM   1926  CD  ILE   271      10.462  12.392  22.101  1.00  3.99          
ATOM   1927  N   PHE   272       7.264   9.890  17.987  1.00 17.49          
ATOM   1928  CA  PHE   272       6.062  10.377  17.351  1.00 17.70          
ATOM   1929  C   PHE   272       4.843   9.713  17.904  1.00 18.43          
ATOM   1930  O   PHE   272       4.970   8.675  18.558  1.00 20.49          
ATOM   1931  CB  PHE   272       6.123  10.084  15.921  1.00 18.22          
ATOM   1932  CG  PHE   272       6.672   8.700  15.573  1.00 20.33          
ATOM   1933  CD1 PHE   272       8.067   8.499  15.354  1.00 24.90          
ATOM   1934  CD2 PHE   272       5.808   7.641  15.294  1.00 16.03          
ATOM   1935  CE1 PHE   272       8.571   7.209  14.973  1.00 22.11          
ATOM   1936  CE2 PHE   272       6.299   6.387  14.883  1.00 14.54          
ATOM   1937  CZ  PHE   272       7.666   6.171  14.756  1.00 18.61          
ATOM   1938  N   GLY   273       3.660  10.272  17.697  1.00 17.81          
ATOM   1939  CA  GLY   273       2.483   9.682  18.309  1.00 17.09          
ATOM   1940  C   GLY   273       1.397  10.703  18.315  1.00 17.92          
ATOM   1941  O   GLY   273       1.216  11.488  17.356  1.00 18.41          
ATOM   1942  N   SER   274       0.651  10.741  19.392  1.00 17.38          
ATOM   1943  CA  SER   274      -0.489  11.631  19.409  1.00 16.95          
ATOM   1944  C   SER   274      -0.069  13.086  19.879  1.00 17.22          
ATOM   1945  O   SER   274       1.056  13.311  20.395  1.00 15.99          
ATOM   1946  CB  SER   274      -1.490  11.028  20.381  1.00 16.69          
ATOM   1947  OG  SER   274      -1.096  11.377  21.718  1.00 16.29          
ATOM   1948  N   LYS   275      -1.002  14.042  19.746  1.00 16.78          
ATOM   1949  CA  LYS   275      -0.828  15.357  20.234  1.00 16.56          
ATOM   1950  C   LYS   275      -0.549  15.306  21.714  1.00 17.63          
ATOM   1951  O   LYS   275       0.252  16.091  22.212  1.00 18.45          
ATOM   1952  CB  LYS   275      -2.074  16.167  19.971  1.00 16.15          
ATOM   1953  CG  LYS   275      -1.872  17.701  20.232  1.00 16.65          
ATOM   1954  CD  LYS   275      -3.209  18.570  20.490  1.00 19.16          
ATOM   1955  CE  LYS   275      -2.940  19.882  21.329  1.00 19.10          
ATOM   1956  NZ  LYS   275      -1.548  20.268  20.744  1.00 20.53          
ATOM   1957  N   GLU   276      -1.174  14.383  22.444  1.00 18.94          
ATOM   1958  CA  GLU   276      -0.824  14.213  23.861  1.00 18.88          
ATOM   1959  C   GLU   276       0.671  13.944  24.061  1.00 18.44          
ATOM   1960  O   GLU   276       1.302  14.540  24.922  1.00 17.98          
ATOM   1961  CB  GLU   276      -1.614  13.089  24.470  1.00 19.40          
ATOM   1962  CG  GLU   276      -1.340  12.935  25.967  1.00 25.68          
ATOM   1963  CD  GLU   276      -2.611  13.030  26.786  1.00 32.00          
ATOM   1964  OE1 GLU   276      -2.652  12.633  27.997  1.00 31.80          
ATOM   1965  OE2 GLU   276      -3.578  13.549  26.174  1.00 36.65          
ATOM   1966  N   LEU   277       1.248  13.036  23.271  1.00 18.22          
ATOM   1967  CA  LEU   277       2.684  12.814  23.333  1.00 16.53          
ATOM   1968  C   LEU   277       3.341  14.139  23.240  1.00 16.06          
ATOM   1969  O   LEU   277       4.118  14.513  24.153  1.00 16.46          
ATOM   1970  CB  LEU   277       3.167  11.983  22.164  1.00 16.16          
ATOM   1971  CG  LEU   277       3.988  10.769  22.530  1.00 15.16          
ATOM   1972  CD1 LEU   277       4.642  10.199  21.361  1.00 17.02          
ATOM   1973  CD2 LEU   277       5.044  11.101  23.515  1.00 16.92          
ATOM   1974  N   TYR   278       3.031  14.861  22.156  1.00 15.30          
ATOM   1975  CA  TYR   278       3.770  16.110  21.856  1.00 15.45          
ATOM   1976  C   TYR   278       3.648  17.064  22.979  1.00 15.56          
ATOM   1977  O   TYR   278       4.695  17.483  23.524  1.00 16.38          
ATOM   1978  CB  TYR   278       3.423  16.739  20.512  1.00 15.72          
ATOM   1979  CG  TYR   278       3.549  15.716  19.393  1.00 17.05          
ATOM   1980  CD1 TYR   278       4.563  14.762  19.412  1.00 17.34          
ATOM   1981  CD2 TYR   278       2.633  15.655  18.345  1.00 17.74          
ATOM   1982  CE1 TYR   278       4.668  13.780  18.435  1.00 16.03          
ATOM   1983  CE2 TYR   278       2.744  14.662  17.339  1.00 18.64          
ATOM   1984  CZ  TYR   278       3.767  13.716  17.409  1.00 18.08          
ATOM   1985  OH  TYR   278       3.925  12.724  16.440  1.00 19.49          
ATOM   1986  N   ASP   279       2.427  17.351  23.419  1.00 14.29          
ATOM   1987  CA  ASP   279       2.356  18.173  24.633  1.00 15.43          
ATOM   1988  C   ASP   279       3.031  17.676  25.887  1.00 15.57          
ATOM   1989  O   ASP   279       3.401  18.493  26.686  1.00 15.70          
ATOM   1990  CB  ASP   279       0.949  18.634  25.061  1.00 16.49          
ATOM   1991  CG  ASP   279       0.096  19.034  23.932  1.00 17.79          
ATOM   1992  OD1 ASP   279       0.657  19.327  22.868  1.00 25.20          
ATOM   1993  OD2 ASP   279      -1.157  19.041  24.000  1.00 19.97          
ATOM   1994  N   PHE   280       3.139  16.371  26.104  1.00 16.66          
ATOM   1995  CA  PHE   280       3.854  15.841  27.289  1.00 18.00          
ATOM   1996  C   PHE   280       5.374  16.037  27.143  1.00 19.52          
ATOM   1997  O   PHE   280       6.085  16.457  28.107  1.00 20.25          
ATOM   1998  CB  PHE   280       3.553  14.356  27.447  1.00 16.57          
ATOM   1999  CG  PHE   280       4.337  13.632  28.543  1.00 17.15          
ATOM   2000  CD1 PHE   280       3.973  13.747  29.910  1.00 15.85          
ATOM   2001  CD2 PHE   280       5.368  12.706  28.209  1.00 14.88          
ATOM   2002  CE1 PHE   280       4.675  13.026  30.952  1.00 12.59          
ATOM   2003  CE2 PHE   280       6.045  11.989  29.263  1.00 13.11          
ATOM   2004  CZ  PHE   280       5.669  12.167  30.646  1.00 10.98          
ATOM   2005  N   VAL   281       5.910  15.741  25.964  1.00 20.51          
ATOM   2006  CA  VAL   281       7.376  15.854  25.865  1.00 21.31          
ATOM   2007  C   VAL   281       7.891  17.294  25.772  1.00 21.83          
ATOM   2008  O   VAL   281       9.094  17.606  26.033  1.00 22.34          
ATOM   2009  CB  VAL   281       7.937  14.958  24.772  1.00 22.52          
ATOM   2010  CG1 VAL   281       7.341  13.516  24.992  1.00 18.73          
ATOM   2011  CG2 VAL   281       7.700  15.585  23.334  1.00 19.22          
ATOM   2012  N   ASN   282       6.980  18.199  25.449  1.00 21.58          
ATOM   2013  CA  ASN   282       7.418  19.544  25.341  1.00 21.12          
ATOM   2014  C   ASN   282       7.970  19.994  26.685  1.00 20.32          
ATOM   2015  O   ASN   282       7.312  19.879  27.699  1.00 18.36          
ATOM   2016  CB  ASN   282       6.267  20.366  24.871  1.00 21.67          
ATOM   2017  CG  ASN   282       6.677  21.760  24.497  1.00 24.98          
ATOM   2018  OD1 ASN   282       7.854  22.077  24.351  1.00 27.72          
ATOM   2019  ND2 ASN   282       5.687  22.620  24.328  1.00 30.49          
ATOM   2020  N   ASN   283       9.231  20.428  26.679  1.00 21.35          
ATOM   2021  CA  ASN   283       9.826  21.158  27.820  1.00 21.64          
ATOM   2022  C   ASN   283       9.761  20.257  28.990  1.00 21.37          
ATOM   2023  O   ASN   283       9.180  20.618  29.987  1.00 21.24          
ATOM   2024  CB  ASN   283       9.009  22.394  28.178  1.00 21.22          
ATOM   2025  CG  ASN   283       9.536  23.598  27.532  1.00 23.97          
ATOM   2026  OD1 ASN   283      10.724  23.893  27.645  1.00 25.59          
ATOM   2027  ND2 ASN   283       8.678  24.319  26.810  1.00 27.16          
ATOM   2028  N   ASN   284      10.278  19.057  28.865  1.00 20.78          
ATOM   2029  CA  ASN   284      10.178  18.198  30.001  1.00 20.26          
ATOM   2030  C   ASN   284      11.591  17.672  30.314  1.00 19.95          
ATOM   2031  O   ASN   284      12.222  17.010  29.510  1.00 20.24          
ATOM   2032  CB  ASN   284       9.043  17.173  29.780  1.00 19.15          
ATOM   2033  CG  ASN   284       9.107  16.028  30.696  1.00 19.36          
ATOM   2034  OD1 ASN   284      10.080  15.833  31.430  1.00 19.39          
ATOM   2035  ND2 ASN   284       8.084  15.219  30.651  1.00 14.70          
ATOM   2036  N   PRO   285      12.076  18.033  31.489  1.00 19.63          
ATOM   2037  CA  PRO   285      13.424  17.724  31.912  1.00 19.08          
ATOM   2038  C   PRO   285      13.724  16.255  31.729  1.00 17.46          
ATOM   2039  O   PRO   285      14.800  15.870  31.470  1.00 15.51          
ATOM   2040  CB  PRO   285      13.378  17.985  33.443  1.00 19.35          
ATOM   2041  CG  PRO   285      12.308  19.015  33.618  1.00 19.73          
ATOM   2042  CD  PRO   285      11.314  18.711  32.553  1.00 19.88          
ATOM   2043  N   VAL   286      12.771  15.404  31.900  1.00 18.11          
ATOM   2044  CA  VAL   286      13.191  14.039  32.092  1.00 18.88          
ATOM   2045  C   VAL   286      13.317  13.249  30.746  1.00 19.56          
ATOM   2046  O   VAL   286      13.635  12.005  30.705  1.00 19.16          
ATOM   2047  CB  VAL   286      12.293  13.348  33.062  1.00 17.80          
ATOM   2048  CG1 VAL   286      11.022  12.851  32.353  1.00 14.90          
ATOM   2049  CG2 VAL   286      13.032  12.219  33.490  1.00 22.40          
ATOM   2050  N   ILE   287      13.060  13.997  29.668  1.00 19.67          
ATOM   2051  CA  ILE   287      13.148  13.484  28.324  1.00 19.63          
ATOM   2052  C   ILE   287      14.238  14.196  27.593  1.00 20.46          
ATOM   2053  O   ILE   287      14.352  15.429  27.722  1.00 20.38          
ATOM   2054  CB  ILE   287      11.838  13.651  27.633  1.00 19.75          
ATOM   2055  CG1 ILE   287      11.036  12.352  27.808  1.00 20.96          
ATOM   2056  CG2 ILE   287      12.009  13.903  26.149  1.00 17.28          
ATOM   2057  CD  ILE   287       9.643  12.526  28.442  1.00 24.41          
ATOM   2058  N   GLU   288      15.043  13.402  26.860  1.00 20.61          
ATOM   2059  CA  GLU   288      16.179  13.907  26.126  1.00 21.85          
ATOM   2060  C   GLU   288      16.514  13.226  24.787  1.00 23.03          
ATOM   2061  O   GLU   288      16.495  11.947  24.679  1.00 24.21          
ATOM   2062  CB  GLU   288      17.373  13.868  27.029  1.00 21.66          
ATOM   2063  CG  GLU   288      17.220  14.904  28.124  1.00 24.90          
ATOM   2064  CD  GLU   288      18.355  14.808  29.123  1.00 30.70          
ATOM   2065  OE1 GLU   288      19.021  13.760  29.116  1.00 33.39          
ATOM   2066  OE2 GLU   288      18.599  15.772  29.898  1.00 32.76          
ATOM   2067  N   CYS   289      16.866  14.026  23.763  1.00 21.66          
ATOM   2068  CA  CYS   289      17.186  13.390  22.507  1.00 20.15          
ATOM   2069  C   CYS   289      18.626  13.347  22.230  1.00 18.95          
ATOM   2070  O   CYS   289      19.368  14.183  22.698  1.00 17.72          
ATOM   2071  CB  CYS   289      16.428  14.064  21.402  1.00 21.24          
ATOM   2072  SG  CYS   289      14.673  13.569  21.499  1.00 22.83          
ATOM   2073  N   TYR   290      19.028  12.327  21.509  1.00 18.51          
ATOM   2074  CA  TYR   290      20.346  12.301  20.953  1.00 18.88          
ATOM   2075  C   TYR   290      20.312  11.661  19.599  1.00 19.72          
ATOM   2076  O   TYR   290      19.429  10.868  19.247  1.00 21.00          
ATOM   2077  CB  TYR   290      21.221  11.416  21.763  1.00 19.02          
ATOM   2078  CG  TYR   290      21.386  11.878  23.151  1.00 21.48          
ATOM   2079  CD1 TYR   290      22.486  12.690  23.563  1.00 20.93          
ATOM   2080  CD2 TYR   290      20.439  11.512  24.098  1.00 23.93          
ATOM   2081  CE1 TYR   290      22.597  13.124  24.891  1.00 17.77          
ATOM   2082  CE2 TYR   290      20.536  11.927  25.399  1.00 21.10          
ATOM   2083  CZ  TYR   290      21.588  12.710  25.779  1.00 19.81          
ATOM   2084  OH  TYR   290      21.501  13.022  27.085  1.00 21.44          
ATOM   2085  N   PRO   291      21.322  11.944  18.829  1.00 20.01          
ATOM   2086  CA  PRO   291      21.368  11.411  17.493  1.00 20.30          
ATOM   2087  C   PRO   291      21.609   9.902  17.521  1.00 21.41          
ATOM   2088  O   PRO   291      22.024   9.320  18.550  1.00 20.94          
ATOM   2089  CB  PRO   291      22.580  12.133  16.880  1.00 21.40          
ATOM   2090  CG  PRO   291      23.321  12.890  18.002  1.00 18.50          
ATOM   2091  CD  PRO   291      22.516  12.739  19.215  1.00 19.81          
ATOM   2092  N   VAL   292      21.401   9.257  16.384  1.00 22.37          
ATOM   2093  CA  VAL   292      21.606   7.812  16.315  1.00 23.05          
ATOM   2094  C   VAL   292      23.052   7.381  16.226  1.00 24.39          
ATOM   2095  O   VAL   292      23.382   6.210  16.506  1.00 25.16          
ATOM   2096  CB  VAL   292      21.065   7.287  15.024  1.00 23.65          
ATOM   2097  CG1 VAL   292      19.651   6.820  15.204  1.00 24.45          
ATOM   2098  CG2 VAL   292      21.249   8.346  13.884  1.00 20.96          
ATOM   2099  N   ASP   293      23.920   8.246  15.714  1.00 24.58          
ATOM   2100  CA  ASP   293      25.269   7.801  15.570  1.00 26.32          
ATOM   2101  C   ASP   293      25.804   7.713  17.019  1.00 26.83          
ATOM   2102  O   ASP   293      26.988   7.767  17.289  1.00 27.81          
ATOM   2103  CB  ASP   293      26.059   8.766  14.686  1.00 26.99          
ATOM   2104  CG  ASP   293      25.905  10.189  15.119  1.00 32.47          
ATOM   2105  OD1 ASP   293      26.135  10.366  16.354  1.00 42.06          
ATOM   2106  OD2 ASP   293      25.557  11.192  14.370  1.00 34.47          
ATOM   2107  N   TYR   294      24.902   7.603  17.974  1.00 26.54          
ATOM   2108  CA  TYR   294      25.302   7.577  19.326  1.00 25.55          
ATOM   2109  C   TYR   294      24.373   6.597  19.991  1.00 26.93          
ATOM   2110  O   TYR   294      24.827   5.576  20.540  1.00 27.54          
ATOM   2111  CB  TYR   294      25.132   8.964  19.917  1.00 23.77          
ATOM   2112  CG  TYR   294      25.199   9.022  21.441  1.00 21.08          
ATOM   2113  CD1 TYR   294      24.073   9.288  22.172  1.00 18.49          
ATOM   2114  CD2 TYR   294      26.413   8.860  22.147  1.00 18.58          
ATOM   2115  CE1 TYR   294      24.114   9.367  23.553  1.00 20.84          
ATOM   2116  CE2 TYR   294      26.477   8.965  23.555  1.00 16.51          
ATOM   2117  CZ  TYR   294      25.311   9.207  24.256  1.00 20.61          
ATOM   2118  OH  TYR   294      25.252   9.301  25.650  1.00 19.80          
ATOM   2119  N   ILE   295      23.077   6.898  19.918  1.00 27.03          
ATOM   2120  CA  ILE   295      22.081   6.184  20.677  1.00 28.31          
ATOM   2121  C   ILE   295      22.131   4.694  20.254  1.00 27.35          
ATOM   2122  O   ILE   295      22.015   3.777  21.096  1.00 26.57          
ATOM   2123  CB  ILE   295      20.728   6.897  20.412  1.00 29.38          
ATOM   2124  CG1 ILE   295      19.617   6.473  21.343  1.00 31.88          
ATOM   2125  CG2 ILE   295      20.292   6.693  19.019  1.00 34.62          
ATOM   2126  CD  ILE   295      19.599   7.421  22.648  1.00 31.90          
ATOM   2127  N   ASN   296      22.414   4.487  18.965  1.00 26.34          
ATOM   2128  CA  ASN   296      22.423   3.186  18.354  1.00 26.75          
ATOM   2129  C   ASN   296      23.773   2.563  18.289  1.00 26.69          
ATOM   2130  O   ASN   296      23.955   1.465  17.713  1.00 27.64          
ATOM   2131  CB  ASN   296      21.877   3.237  16.949  1.00 26.78          
ATOM   2132  CG  ASN   296      20.331   3.121  16.909  1.00 31.94          
ATOM   2133  OD1 ASN   296      19.605   3.898  17.598  1.00 26.92          
ATOM   2134  ND2 ASN   296      19.816   2.158  16.075  1.00 34.97          
ATOM   2135  N   ASN   297      24.743   3.245  18.864  1.00 25.95          
ATOM   2136  CA  ASN   297      26.067   2.724  18.885  1.00 24.84          
ATOM   2137  C   ASN   297      26.169   1.607  19.953  1.00 25.05          
ATOM   2138  O   ASN   297      25.951   1.872  21.132  1.00 25.37          
ATOM   2139  CB  ASN   297      27.046   3.846  19.177  1.00 24.62          
ATOM   2140  CG  ASN   297      28.455   3.390  18.982  1.00 24.84          
ATOM   2141  OD1 ASN   297      29.002   2.586  19.792  1.00 16.91          
ATOM   2142  ND2 ASN   297      29.025   3.783  17.821  1.00 23.16          
ATOM   2143  N   PRO   298      26.464   0.360  19.556  1.00 24.74          
ATOM   2144  CA  PRO   298      26.457  -0.772  20.484  1.00 23.87          
ATOM   2145  C   PRO   298      27.305  -0.529  21.726  1.00 24.48          
ATOM   2146  O   PRO   298      27.032  -1.043  22.851  1.00 23.96          
ATOM   2147  CB  PRO   298      27.091  -1.874  19.639  1.00 23.37          
ATOM   2148  CG  PRO   298      26.671  -1.555  18.250  1.00 22.61          
ATOM   2149  CD  PRO   298      26.795  -0.072  18.179  1.00 24.16          
ATOM   2150  N   ASP   299      28.346   0.265  21.505  1.00 25.24          
ATOM   2151  CA  ASP   299      29.219   0.735  22.561  1.00 25.23          
ATOM   2152  C   ASP   299      28.496   1.604  23.558  1.00 24.93          
ATOM   2153  O   ASP   299      28.661   1.420  24.744  1.00 26.24          
ATOM   2154  CB  ASP   299      30.185   1.654  21.931  1.00 26.57          
ATOM   2155  CG  ASP   299      31.535   1.313  22.245  1.00 27.01          
ATOM   2156  OD1 ASP   299      31.960   0.277  21.604  1.00 25.52          
ATOM   2157  OD2 ASP   299      32.183   2.037  23.087  1.00 27.50          
ATOM   2158  N   VAL   300      27.719   2.579  23.093  1.00 22.97          
ATOM   2159  CA  VAL   300      26.934   3.345  24.044  1.00 21.95          
ATOM   2160  C   VAL   300      25.827   2.560  24.629  1.00 20.54          
ATOM   2161  O   VAL   300      25.675   2.576  25.844  1.00 21.44          
ATOM   2162  CB  VAL   300      26.264   4.622  23.509  1.00 22.51          
ATOM   2163  CG1 VAL   300      25.781   5.465  24.714  1.00 22.33          
ATOM   2164  CG2 VAL   300      27.236   5.441  22.652  1.00 23.86          
ATOM   2165  N   ILE   301      25.030   1.908  23.786  1.00 18.77          
ATOM   2166  CA  ILE   301      24.043   0.946  24.264  1.00 17.11          
ATOM   2167  C   ILE   301      24.605   0.080  25.383  1.00 17.65          
ATOM   2168  O   ILE   301      24.012  -0.107  26.483  1.00 15.35          
ATOM   2169  CB  ILE   301      23.597   0.087  23.143  1.00 17.00          
ATOM   2170  CG1 ILE   301      22.702   0.914  22.192  1.00 20.62          
ATOM   2171  CG2 ILE   301      22.778  -1.036  23.674  1.00 13.63          
ATOM   2172  CD  ILE   301      22.543   0.300  20.806  1.00 22.54          
ATOM   2173  N   GLY   302      25.793  -0.427  25.104  1.00 18.32          
ATOM   2174  CA  GLY   302      26.397  -1.308  26.044  1.00 20.16          
ATOM   2175  C   GLY   302      26.543  -0.752  27.463  1.00 20.77          
ATOM   2176  O   GLY   302      26.436  -1.567  28.405  1.00 21.18          
ATOM   2177  N   LYS   303      26.864   0.561  27.614  1.00 20.15          
ATOM   2178  CA  LYS   303      27.117   1.157  28.911  1.00 20.16          
ATOM   2179  C   LYS   303      25.841   1.050  29.821  1.00 20.78          
ATOM   2180  O   LYS   303      25.895   1.168  31.043  1.00 20.99          
ATOM   2181  CB  LYS   303      27.509   2.608  28.797  1.00 19.95          
ATOM   2182  CG  LYS   303      28.323   2.999  27.626  1.00 22.75          
ATOM   2183  CD  LYS   303      29.807   2.923  27.877  1.00 25.83          
ATOM   2184  CE  LYS   303      30.537   4.164  27.265  1.00 29.00          
ATOM   2185  NZ  LYS   303      31.023   5.196  28.298  1.00 27.52          
ATOM   2186  N   ASN   304      24.675   0.829  29.243  1.00 21.18          
ATOM   2187  CA  ASN   304      23.476   0.667  30.045  1.00 20.72          
ATOM   2188  C   ASN   304      23.253  -0.749  30.605  1.00 20.36          
ATOM   2189  O   ASN   304      23.015  -1.687  29.846  1.00 18.96          
ATOM   2190  CB  ASN   304      22.317   1.070  29.183  1.00 20.14          
ATOM   2191  CG  ASN   304      21.738   2.363  29.575  1.00 22.61          
ATOM   2192  OD1 ASN   304      21.434   2.674  30.813  1.00 24.09          
ATOM   2193  ND2 ASN   304      21.452   3.133  28.540  1.00 26.69          
ATOM   2194  N   ASP   305      23.276  -0.923  31.920  1.00 20.88          
ATOM   2195  CA  ASP   305      23.086  -2.298  32.413  1.00 22.32          
ATOM   2196  C   ASP   305      21.715  -2.919  32.334  1.00 23.16          
ATOM   2197  O   ASP   305      20.636  -2.202  32.361  1.00 23.43          
ATOM   2198  CB  ASP   305      23.573  -2.419  33.809  1.00 22.88          
ATOM   2199  CG  ASP   305      24.999  -2.157  33.871  1.00 24.16          
ATOM   2200  OD1 ASP   305      25.657  -2.451  34.848  1.00 21.90          
ATOM   2201  OD2 ASP   305      25.558  -1.637  32.904  1.00 32.45          
ATOM   2202  N   ARG   306      21.718  -4.247  32.253  1.00 22.88          
ATOM   2203  CA  ARG   306      20.417  -4.890  32.195  1.00 24.22          
ATOM   2204  C   ARG   306      19.751  -4.292  30.979  1.00 22.63          
ATOM   2205  O   ARG   306      18.635  -3.823  31.052  1.00 23.71          
ATOM   2206  CB  ARG   306      19.559  -4.569  33.469  1.00 24.33          
ATOM   2207  CG  ARG   306      20.278  -4.937  34.708  1.00 27.69          
ATOM   2208  CD  ARG   306      20.050  -4.045  35.911  1.00 37.95          
ATOM   2209  NE  ARG   306      20.855  -4.670  36.957  1.00 42.64          
ATOM   2210  CZ  ARG   306      20.451  -5.726  37.716  1.00 45.91          
ATOM   2211  NH1 ARG   306      21.293  -6.240  38.621  1.00 48.19          
ATOM   2212  NH2 ARG   306      19.202  -6.250  37.620  1.00 44.11          
ATOM   2213  N   MET   307      20.445  -4.206  29.870  1.00 21.61          
ATOM   2214  CA  MET   307      19.778  -3.544  28.768  1.00 21.34          
ATOM   2215  C   MET   307      19.030  -4.620  28.089  1.00 21.68          
ATOM   2216  O   MET   307      19.660  -5.597  27.677  1.00 22.20          
ATOM   2217  CB  MET   307      20.762  -2.982  27.788  1.00 20.43          
ATOM   2218  CG  MET   307      20.136  -2.599  26.489  1.00 21.54          
ATOM   2219  SD  MET   307      19.371  -0.956  26.430  1.00 25.24          
ATOM   2220  CE  MET   307      20.762   0.152  26.658  1.00 25.33          
ATOM   2221  N   VAL   308      17.711  -4.464  27.949  1.00 21.78          
ATOM   2222  CA  VAL   308      16.951  -5.453  27.160  1.00 21.51          
ATOM   2223  C   VAL   308      16.189  -4.959  25.901  1.00 21.95          
ATOM   2224  O   VAL   308      15.159  -4.264  26.037  1.00 22.84          
ATOM   2225  CB  VAL   308      16.084  -6.432  28.067  1.00 22.04          
ATOM   2226  CG1 VAL   308      16.115  -6.026  29.536  1.00 19.27          
ATOM   2227  CG2 VAL   308      14.636  -6.706  27.420  1.00 18.72          
ATOM   2228  N   SER   309      16.656  -5.346  24.700  1.00 21.08          
ATOM   2229  CA  SER   309      16.083  -4.766  23.461  1.00 22.17          
ATOM   2230  C   SER   309      15.041  -5.702  23.002  1.00 22.53          
ATOM   2231  O   SER   309      15.282  -6.921  23.022  1.00 21.95          
ATOM   2232  CB  SER   309      17.117  -4.586  22.329  1.00 21.69          
ATOM   2233  OG  SER   309      18.046  -5.637  22.413  1.00 22.67          
ATOM   2234  N   ILE   310      13.880  -5.156  22.606  1.00 23.02          
ATOM   2235  CA  ILE   310      12.860  -5.998  21.973  1.00 23.27          
ATOM   2236  C   ILE   310      12.410  -5.583  20.572  1.00 24.34          
ATOM   2237  O   ILE   310      11.712  -4.529  20.424  1.00 25.43          
ATOM   2238  CB  ILE   310      11.642  -6.080  22.794  1.00 22.70          
ATOM   2239  CG1 ILE   310      11.991  -6.284  24.248  1.00 20.55          
ATOM   2240  CG2 ILE   310      10.624  -7.110  22.079  1.00 21.76          
ATOM   2241  CD  ILE   310      10.834  -5.979  25.150  1.00 24.32          
ATOM   2242  N   ASN   311      12.733  -6.437  19.594  1.00 24.31          
ATOM   2243  CA  ASN   311      12.514  -6.128  18.187  1.00 25.43          
ATOM   2244  C   ASN   311      11.651  -7.170  17.592  1.00 26.20          
ATOM   2245  O   ASN   311      11.433  -8.233  18.166  1.00 26.50          
ATOM   2246  CB  ASN   311      13.813  -6.112  17.418  1.00 24.77          
ATOM   2247  CG  ASN   311      14.878  -5.362  18.155  1.00 29.16          
ATOM   2248  OD1 ASN   311      14.716  -4.142  18.464  1.00 21.79          
ATOM   2249  ND2 ASN   311      15.961  -6.114  18.563  1.00 36.31          
ATOM   2250  N   SER   312      11.152  -6.877  16.411  1.00 26.85          
ATOM   2251  CA  SER   312      10.196  -7.762  15.822  1.00 27.23          
ATOM   2252  C   SER   312      10.466  -7.830  14.334  1.00 27.76          
ATOM   2253  O   SER   312      10.309  -6.842  13.593  1.00 27.02          
ATOM   2254  CB  SER   312       8.781  -7.344  16.170  1.00 27.22          
ATOM   2255  OG  SER   312       7.915  -8.133  15.416  1.00 29.30          
ATOM   2256  N   CYS   313      10.957  -9.026  13.983  1.00 28.57          
ATOM   2257  CA  CYS   313      11.268  -9.489  12.679  1.00 29.81          
ATOM   2258  C   CYS   313      10.100 -10.118  12.039  1.00 29.38          
ATOM   2259  O   CYS   313       9.085 -10.434  12.671  1.00 29.40          
ATOM   2260  CB  CYS   313      12.334 -10.551  12.733  1.00 30.61          
ATOM   2261  SG  CYS   313      13.911  -9.785  13.063  1.00 39.26          
ATOM   2262  N   LEU   314      10.285 -10.328  10.741  1.00 29.70          
ATOM   2263  CA  LEU   314       9.192 -10.677   9.872  1.00 29.39          
ATOM   2264  C   LEU   314       9.186 -12.200   9.563  1.00 28.58          
ATOM   2265  O   LEU   314       8.112 -12.787   9.281  1.00 28.96          
ATOM   2266  CB  LEU   314       9.013  -9.639   8.704  1.00 29.51          
ATOM   2267  CG  LEU   314       8.170  -8.307   9.108  1.00 33.74          
ATOM   2268  CD1 LEU   314       6.593  -8.484   9.420  1.00 30.78          
ATOM   2269  CD2 LEU   314       8.773  -7.166  10.198  1.00 34.43          
ATOM   2270  N   GLU   315      10.330 -12.871   9.749  1.00 26.17          
ATOM   2271  CA  GLU   315      10.351 -14.305   9.544  1.00 24.28          
ATOM   2272  C   GLU   315      11.596 -14.809  10.173  1.00 23.08          
ATOM   2273  O   GLU   315      12.502 -14.040  10.400  1.00 22.95          
ATOM   2274  CB  GLU   315      10.261 -14.626   8.053  1.00 24.37          
ATOM   2275  CG  GLU   315      11.312 -15.583   7.557  1.00 26.48          
ATOM   2276  CD  GLU   315      11.087 -15.997   6.127  1.00 30.73          
ATOM   2277  OE1 GLU   315      11.711 -15.429   5.173  1.00 31.86          
ATOM   2278  OE2 GLU   315      10.268 -16.923   5.968  1.00 34.77          
ATOM   2279  N   MET   316      11.621 -16.080  10.518  1.00 22.21          
ATOM   2280  CA  MET   316      12.777 -16.626  11.131  1.00 22.45          
ATOM   2281  C   MET   316      12.900 -18.046  10.746  1.00 23.98          
ATOM   2282  O   MET   316      11.929 -18.657  10.280  1.00 24.21          
ATOM   2283  CB  MET   316      12.606 -16.601  12.598  1.00 22.00          
ATOM   2284  CG  MET   316      13.633 -17.483  13.304  1.00 20.21          
ATOM   2285  SD  MET   316      14.306 -16.439  14.669  1.00 19.96          
ATOM   2286  CE  MET   316      14.656 -17.594  15.883  1.00 23.35          
ATOM   2287  N   ASP   317      14.078 -18.619  10.943  1.00 25.20          
ATOM   2288  CA  ASP   317      14.258 -20.011  10.483  1.00 26.62          
ATOM   2289  C   ASP   317      14.571 -21.004  11.592  1.00 26.80          
ATOM   2290  O   ASP   317      14.804 -20.617  12.723  1.00 26.64          
ATOM   2291  CB  ASP   317      15.236 -20.129   9.302  1.00 26.69          
ATOM   2292  CG  ASP   317      16.729 -19.983   9.708  1.00 30.04          
ATOM   2293  OD1 ASP   317      17.118 -19.741  10.903  1.00 32.11          
ATOM   2294  OD2 ASP   317      17.612 -20.123   8.827  1.00 33.58          
ATOM   2295  N   LEU   318      14.576 -22.291  11.259  1.00 28.00          
ATOM   2296  CA  LEU   318      14.851 -23.334  12.261  1.00 29.18          
ATOM   2297  C   LEU   318      16.226 -23.262  12.960  1.00 30.83          
ATOM   2298  O   LEU   318      16.588 -24.181  13.708  1.00 30.42          
ATOM   2299  CB  LEU   318      14.659 -24.722  11.646  1.00 28.60          
ATOM   2300  CG  LEU   318      13.228 -25.190  11.363  1.00 27.13          
ATOM   2301  CD1 LEU   318      13.214 -26.687  10.991  1.00 24.91          
ATOM   2302  CD2 LEU   318      12.315 -24.914  12.538  1.00 22.46          
ATOM   2303  N   MET   319      16.934 -22.145  12.757  1.00 33.21          
ATOM   2304  CA  MET   319      18.344 -21.995  13.064  1.00 35.25          
ATOM   2305  C   MET   319      18.639 -20.691  13.811  1.00 36.14          
ATOM   2306  O   MET   319      19.666 -20.562  14.472  1.00 37.08          
ATOM   2307  CB  MET   319      19.084 -21.926  11.769  1.00 35.35          
ATOM   2308  CG  MET   319      20.520 -22.235  11.890  1.00 39.20          
ATOM   2309  SD  MET   319      20.801 -23.678  10.823  1.00 49.97          
ATOM   2310  CE  MET   319      19.780 -23.463   9.296  1.00 44.97          
ATOM   2311  N   GLY   320      17.783 -19.697  13.683  1.00 35.93          
ATOM   2312  CA  GLY   320      18.005 -18.523  14.491  1.00 37.02          
ATOM   2313  C   GLY   320      18.289 -17.300  13.672  1.00 38.08          
ATOM   2314  O   GLY   320      18.997 -16.383  14.094  1.00 38.43          
ATOM   2315  N   GLN   321      17.688 -17.281  12.502  1.00 38.22          
ATOM   2316  CA  GLN   321      18.079 -16.370  11.521  1.00 39.03          
ATOM   2317  C   GLN   321      16.869 -15.632  10.922  1.00 39.58          
ATOM   2318  O   GLN   321      15.916 -16.280  10.433  1.00 40.39          
ATOM   2319  CB  GLN   321      18.864 -17.183  10.526  1.00 38.53          
ATOM   2320  CG  GLN   321      19.982 -17.923  11.211  1.00 40.92          
ATOM   2321  CD  GLN   321      21.001 -18.525  10.224  1.00 46.26          
ATOM   2322  OE1 GLN   321      20.593 -19.087   9.201  1.00 47.09          
ATOM   2323  NE2 GLN   321      22.325 -18.424  10.535  1.00 47.29          
ATOM   2324  N   ALA   322      16.918 -14.289  10.972  1.00 39.33          
ATOM   2325  CA  ALA   322      15.832 -13.396  10.541  1.00 39.17          
ATOM   2326  C   ALA   322      15.991 -13.035   9.112  1.00 38.62          
ATOM   2327  O   ALA   322      16.969 -12.387   8.823  1.00 39.19          
ATOM   2328  CB  ALA   322      15.869 -12.118  11.382  1.00 39.72          
ATOM   2329  N   GLY   337      18.043  -0.514  12.714  1.00 32.40          
ATOM   2330  CA  GLY   337      18.308  -0.233  14.136  1.00 33.93          
ATOM   2331  C   GLY   337      18.134  -1.497  14.982  1.00 35.28          
ATOM   2332  O   GLY   337      18.755  -1.762  16.053  1.00 34.21          
ATOM   2333  N   GLN   338      17.244  -2.296  14.451  1.00 36.23          
ATOM   2334  CA  GLN   338      17.023  -3.628  14.912  1.00 37.03          
ATOM   2335  C   GLN   338      18.291  -4.385  15.237  1.00 35.93          
ATOM   2336  O   GLN   338      18.304  -5.091  16.188  1.00 37.48          
ATOM   2337  CB  GLN   338      16.243  -4.379  13.828  1.00 37.68          
ATOM   2338  CG  GLN   338      15.014  -3.597  13.307  1.00 38.68          
ATOM   2339  CD  GLN   338      13.836  -4.506  13.408  1.00 41.17          
ATOM   2340  OE1 GLN   338      12.748  -4.121  13.817  1.00 43.36          
ATOM   2341  NE2 GLN   338      14.074  -5.759  13.111  1.00 40.22          
ATOM   2342  N   VAL   339      19.351  -4.244  14.476  1.00 34.52          
ATOM   2343  CA  VAL   339      20.537  -5.072  14.704  1.00 34.39          
ATOM   2344  C   VAL   339      21.553  -4.400  15.674  1.00 34.32          
ATOM   2345  O   VAL   339      22.336  -5.065  16.406  1.00 33.62          
ATOM   2346  CB  VAL   339      21.206  -5.403  13.321  1.00 34.67          
ATOM   2347  CG1 VAL   339      21.275  -4.081  12.373  1.00 37.99          
ATOM   2348  CG2 VAL   339      22.578  -6.112  13.457  1.00 33.73          
ATOM   2349  N   ASP   340      21.565  -3.067  15.616  1.00 34.35          
ATOM   2350  CA  ASP   340      22.394  -2.243  16.463  1.00 34.10          
ATOM   2351  C   ASP   340      22.140  -2.644  17.895  1.00 32.62          
ATOM   2352  O   ASP   340      23.107  -2.936  18.655  1.00 33.50          
ATOM   2353  CB  ASP   340      22.013  -0.787  16.274  1.00 35.01          
ATOM   2354  CG  ASP   340      22.498  -0.250  14.929  1.00 40.15          
ATOM   2355  OD1 ASP   340      21.869   0.771  14.437  1.00 42.82          
ATOM   2356  OD2 ASP   340      23.513  -0.791  14.346  1.00 40.00          
ATOM   2357  N   PHE   341      20.846  -2.688  18.247  1.00 29.11          
ATOM   2358  CA  PHE   341      20.411  -3.062  19.574  1.00 25.57          
ATOM   2359  C   PHE   341      20.613  -4.535  19.947  1.00 25.69          
ATOM   2360  O   PHE   341      20.893  -4.826  21.082  1.00 24.98          
ATOM   2361  CB  PHE   341      18.980  -2.627  19.767  1.00 24.33          
ATOM   2362  CG  PHE   341      18.862  -1.254  20.222  1.00 19.87          
ATOM   2363  CD1 PHE   341      19.199  -0.916  21.518  1.00 20.29          
ATOM   2364  CD2 PHE   341      18.426  -0.268  19.388  1.00 22.35          
ATOM   2365  CE1 PHE   341      19.107   0.369  21.993  1.00 17.89          
ATOM   2366  CE2 PHE   341      18.318   1.099  19.859  1.00 20.13          
ATOM   2367  CZ  PHE   341      18.627   1.388  21.141  1.00 20.00          
ATOM   2368  N   LEU   342      20.518  -5.470  19.002  1.00 26.15          
ATOM   2369  CA  LEU   342      20.978  -6.852  19.279  1.00 26.79          
ATOM   2370  C   LEU   342      22.359  -6.918  19.895  1.00 27.34          
ATOM   2371  O   LEU   342      22.533  -7.556  20.955  1.00 27.69          
ATOM   2372  CB  LEU   342      21.008  -7.724  18.013  1.00 27.10          
ATOM   2373  CG  LEU   342      19.997  -8.863  17.849  1.00 27.50          
ATOM   2374  CD1 LEU   342      18.501  -8.286  17.801  1.00 27.88          
ATOM   2375  CD2 LEU   342      20.333  -9.770  16.600  1.00 26.40          
ATOM   2376  N   ARG   343      23.303  -6.290  19.165  1.00 27.50          
ATOM   2377  CA  ARG   343      24.744  -6.251  19.396  1.00 28.14          
ATOM   2378  C   ARG   343      25.052  -5.537  20.746  1.00 27.63          
ATOM   2379  O   ARG   343      25.852  -5.988  21.585  1.00 25.82          
ATOM   2380  CB  ARG   343      25.405  -5.434  18.220  1.00 28.93          
ATOM   2381  CG  ARG   343      25.696  -6.077  16.773  1.00 28.79          
ATOM   2382  CD  ARG   343      26.822  -5.307  15.879  1.00 30.08          
ATOM   2383  NE  ARG   343      28.210  -5.718  16.193  1.00 36.69          
ATOM   2384  CZ  ARG   343      28.655  -7.002  16.070  1.00 42.54          
ATOM   2385  NH1 ARG   343      29.916  -7.395  16.382  1.00 38.17          
ATOM   2386  NH2 ARG   343      27.787  -7.936  15.636  1.00 48.43          
ATOM   2387  N   GLY   344      24.393  -4.388  20.892  1.00 26.62          
ATOM   2388  CA  GLY   344      24.594  -3.516  21.970  1.00 26.39          
ATOM   2389  C   GLY   344      23.943  -4.101  23.164  1.00 27.81          
ATOM   2390  O   GLY   344      24.498  -3.947  24.264  1.00 29.57          
ATOM   2391  N   ALA   345      22.798  -4.791  23.019  1.00 28.29          
ATOM   2392  CA  ALA   345      22.240  -5.564  24.188  1.00 28.86          
ATOM   2393  C   ALA   345      23.200  -6.635  24.677  1.00 29.31          
ATOM   2394  O   ALA   345      23.204  -6.955  25.886  1.00 31.38          
ATOM   2395  CB  ALA   345      20.895  -6.185  23.935  1.00 28.65          
ATOM   2396  N   LYS   346      24.025  -7.158  23.764  1.00 28.21          
ATOM   2397  CA  LYS   346      24.878  -8.278  24.091  1.00 27.12          
ATOM   2398  C   LYS   346      26.126  -7.839  24.754  1.00 25.66          
ATOM   2399  O   LYS   346      26.828  -8.689  25.235  1.00 25.19          
ATOM   2400  CB  LYS   346      25.053  -9.279  22.927  1.00 28.37          
ATOM   2401  CG  LYS   346      23.524  -9.807  22.411  1.00 31.34          
ATOM   2402  CD  LYS   346      23.344 -11.325  22.554  1.00 31.43          
ATOM   2403  CE  LYS   346      23.764 -11.810  23.977  1.00 26.80          
ATOM   2404  NZ  LYS   346      24.475 -13.139  23.930  1.00 31.15          
ATOM   2405  N   ARG   347      26.324  -6.519  24.894  1.00 23.77          
ATOM   2406  CA  ARG   347      27.445  -5.949  25.657  1.00 22.80          
ATOM   2407  C   ARG   347      27.105  -5.411  27.061  1.00 22.90          
ATOM   2408  O   ARG   347      28.044  -5.220  27.848  1.00 21.68          
ATOM   2409  CB  ARG   347      28.079  -4.742  24.966  1.00 23.42          
ATOM   2410  CG  ARG   347      29.220  -4.910  24.022  1.00 24.04          
ATOM   2411  CD  ARG   347      28.832  -4.438  22.641  1.00 27.38          
ATOM   2412  NE  ARG   347      29.934  -4.351  21.667  1.00 29.08          
ATOM   2413  CZ  ARG   347      29.810  -4.720  20.389  1.00 25.94          
ATOM   2414  NH1 ARG   347      28.623  -5.230  19.980  1.00 26.17          
ATOM   2415  NH2 ARG   347      30.836  -4.582  19.549  1.00 15.62          
ATOM   2416  N   SER   348      25.832  -5.073  27.389  1.00 21.97          
ATOM   2417  CA  SER   348      25.612  -4.533  28.766  1.00 19.83          
ATOM   2418  C   SER   348      25.601  -5.637  29.710  1.00 18.17          
ATOM   2419  O   SER   348      25.077  -6.671  29.421  1.00 16.32          
ATOM   2420  CB  SER   348      24.325  -3.724  28.924  1.00 20.15          
ATOM   2421  OG  SER   348      23.237  -4.432  29.513  1.00 21.01          
ATOM   2422  N   LYS   349      26.148  -5.408  30.875  1.00 19.17          
ATOM   2423  CA  LYS   349      26.104  -6.460  31.881  1.00 21.21          
ATOM   2424  C   LYS   349      24.685  -6.872  32.410  1.00 20.84          
ATOM   2425  O   LYS   349      23.919  -6.068  32.959  1.00 21.39          
ATOM   2426  CB  LYS   349      27.206  -6.311  32.944  1.00 20.95          
ATOM   2427  CG  LYS   349      26.812  -5.611  34.246  1.00 24.99          
ATOM   2428  CD  LYS   349      28.027  -5.550  35.251  1.00 22.81          
ATOM   2429  CE  LYS   349      28.979  -4.476  34.766  1.00 27.03          
ATOM   2430  NZ  LYS   349      30.318  -4.528  35.402  1.00 34.83          
ATOM   2431  N   GLY   350      24.332  -8.133  32.166  1.00 20.13          
ATOM   2432  CA  GLY   350      22.950  -8.579  32.360  1.00 19.36          
ATOM   2433  C   GLY   350      21.913  -8.181  31.293  1.00 18.81          
ATOM   2434  O   GLY   350      20.732  -7.999  31.620  1.00 18.81          
ATOM   2435  N   GLY   351      22.317  -8.063  30.023  1.00 17.72          
ATOM   2436  CA  GLY   351      21.416  -7.638  28.960  1.00 16.66          
ATOM   2437  C   GLY   351      20.990  -8.846  28.213  1.00 16.32          
ATOM   2438  O   GLY   351      21.598  -9.841  28.313  1.00 17.20          
ATOM   2439  N   ILE   352      19.925  -8.773  27.470  1.00 16.62          
ATOM   2440  CA  ILE   352      19.542  -9.849  26.631  1.00 17.56          
ATOM   2441  C   ILE   352      18.877  -9.237  25.421  1.00 18.21          
ATOM   2442  O   ILE   352      18.710  -8.049  25.361  1.00 19.44          
ATOM   2443  CB  ILE   352      18.515 -10.719  27.307  1.00 18.26          
ATOM   2444  CG1 ILE   352      17.359  -9.878  27.881  1.00 19.02          
ATOM   2445  CG2 ILE   352      19.161 -11.831  28.174  1.00 17.12          
ATOM   2446  CD  ILE   352      16.065 -10.715  28.036  1.00 21.36          
ATOM   2447  N   SER   353      18.496 -10.019  24.431  1.00 18.09          
ATOM   2448  CA  SER   353      17.781  -9.424  23.356  1.00 18.33          
ATOM   2449  C   SER   353      16.710 -10.417  23.000  1.00 19.11          
ATOM   2450  O   SER   353      16.976 -11.616  22.912  1.00 19.87          
ATOM   2451  CB  SER   353      18.713  -9.131  22.203  1.00 17.16          
ATOM   2452  OG  SER   353      19.291 -10.353  21.737  1.00 20.76          
ATOM   2453  N   ILE   354      15.493  -9.912  22.863  1.00 20.30          
ATOM   2454  CA  ILE   354      14.317 -10.702  22.470  1.00 21.76          
ATOM   2455  C   ILE   354      13.772 -10.323  21.066  1.00 23.04          
ATOM   2456  O   ILE   354      13.642  -9.115  20.790  1.00 24.24          
ATOM   2457  CB  ILE   354      13.205 -10.459  23.509  1.00 21.56          
ATOM   2458  CG1 ILE   354      13.706 -10.729  24.955  1.00 21.10          
ATOM   2459  CG2 ILE   354      12.023 -11.295  23.169  1.00 20.81          
ATOM   2460  CD  ILE   354      12.880  -9.976  26.044  1.00 20.26          
ATOM   2461  N   MET   355      13.478 -11.314  20.200  1.00 23.37          
ATOM   2462  CA  MET   355      12.768 -11.102  18.955  1.00 26.21          
ATOM   2463  C   MET   355      11.362 -11.611  19.261  1.00 24.38          
ATOM   2464  O   MET   355      11.165 -12.759  19.530  1.00 25.25          
ATOM   2465  CB  MET   355      13.424 -11.840  17.779  1.00 24.52          
ATOM   2466  CG  MET   355      13.432 -11.101  16.421  1.00 28.05          
ATOM   2467  SD  MET   355      15.152 -10.881  15.479  1.00 38.26          
ATOM   2468  CE  MET   355      15.421  -9.061  14.961  1.00 24.58          
ATOM   2469  N   ALA   356      10.372 -10.748  19.295  1.00 23.77          
ATOM   2470  CA  ALA   356       9.027 -11.220  19.544  1.00 23.95          
ATOM   2471  C   ALA   356       8.231 -10.996  18.261  1.00 24.10          
ATOM   2472  O   ALA   356       8.356  -9.898  17.669  1.00 25.45          
ATOM   2473  CB  ALA   356       8.398 -10.423  20.714  1.00 22.89          
ATOM   2474  N   PHE   357       7.418 -11.974  17.823  1.00 22.67          
ATOM   2475  CA  PHE   357       6.491 -11.775  16.658  1.00 21.17          
ATOM   2476  C   PHE   357       5.428 -12.837  16.670  1.00 21.32          
ATOM   2477  O   PHE   357       5.556 -13.903  17.336  1.00 21.51          
ATOM   2478  CB  PHE   357       7.211 -11.934  15.319  1.00 21.45          
ATOM   2479  CG  PHE   357       8.223 -13.060  15.314  1.00 21.85          
ATOM   2480  CD1 PHE   357       7.813 -14.374  15.045  1.00 18.48          
ATOM   2481  CD2 PHE   357       9.561 -12.805  15.687  1.00 24.34          
ATOM   2482  CE1 PHE   357       8.664 -15.438  15.064  1.00 15.17          
ATOM   2483  CE2 PHE   357      10.427 -13.838  15.723  1.00 28.29          
ATOM   2484  CZ  PHE   357       9.942 -15.224  15.400  1.00 22.57          
ATOM   2485  N   PRO   358       4.384 -12.606  15.885  1.00 20.50          
ATOM   2486  CA  PRO   358       3.243 -13.540  15.866  1.00 19.64          
ATOM   2487  C   PRO   358       3.582 -14.809  15.073  1.00 18.80          
ATOM   2488  O   PRO   358       4.200 -14.702  14.035  1.00 19.52          
ATOM   2489  CB  PRO   358       2.144 -12.697  15.187  1.00 19.24          
ATOM   2490  CG  PRO   358       2.712 -11.350  15.169  1.00 17.91          
ATOM   2491  CD  PRO   358       4.174 -11.483  14.958  1.00 19.30          
ATOM   2492  N   SER   359       3.211 -15.986  15.545  1.00 17.60          
ATOM   2493  CA  SER   359       3.647 -17.183  14.896  1.00 17.37          
ATOM   2494  C   SER   359       3.120 -17.363  13.457  1.00 18.02          
ATOM   2495  O   SER   359       3.599 -18.252  12.728  1.00 18.12          
ATOM   2496  CB  SER   359       3.374 -18.401  15.790  1.00 18.18          
ATOM   2497  OG  SER   359       1.986 -18.580  16.171  1.00 19.03          
ATOM   2498  N   THR   360       2.158 -16.544  13.007  1.00 18.74          
ATOM   2499  CA  THR   360       1.719 -16.605  11.557  1.00 19.28          
ATOM   2500  C   THR   360       1.474 -15.320  10.780  1.00 20.33          
ATOM   2501  O   THR   360       1.661 -14.252  11.292  1.00 18.64          
ATOM   2502  CB  THR   360       0.492 -17.419  11.390  1.00 18.75          
ATOM   2503  OG1 THR   360      -0.504 -16.984  12.309  1.00 15.72          
ATOM   2504  CG2 THR   360       0.768 -18.836  11.792  1.00 22.33          
ATOM   2505  N   ALA   361       1.058 -15.463   9.525  1.00 23.30          
ATOM   2506  CA  ALA   361       0.687 -14.321   8.682  1.00 26.55          
ATOM   2507  C   ALA   361      -0.461 -14.685   7.736  1.00 28.31          
ATOM   2508  O   ALA   361      -0.758 -15.862   7.553  1.00 28.43          
ATOM   2509  CB  ALA   361       1.868 -13.853   7.900  1.00 27.08          
ATOM   2510  N   LYS   362      -1.106 -13.666   7.148  1.00 31.05          
ATOM   2511  CA  LYS   362      -2.247 -13.860   6.230  1.00 31.69          
ATOM   2512  C   LYS   362      -3.324 -14.748   6.894  1.00 31.73          
ATOM   2513  O   LYS   362      -3.684 -15.771   6.330  1.00 31.22          
ATOM   2514  CB  LYS   362      -1.745 -14.479   4.898  1.00 31.56          
ATOM   2515  CG  LYS   362      -2.850 -14.746   3.752  1.00 33.56          
ATOM   2516  CD  LYS   362      -2.604 -15.997   2.736  1.00 32.67          
ATOM   2517  CE  LYS   362      -3.092 -15.759   1.287  1.00 30.06          
ATOM   2518  NZ  LYS   362      -3.220 -17.126   0.656  1.00 31.40          
ATOM   2519  N   LYS   363      -3.812 -14.370   8.089  1.00 32.14          
ATOM   2520  CA  LYS   363      -4.719 -15.251   8.900  1.00 32.38          
ATOM   2521  C   LYS   363      -4.278 -16.742   9.130  1.00 31.83          
ATOM   2522  O   LYS   363      -5.114 -17.677   9.067  1.00 31.88          
ATOM   2523  CB  LYS   363      -6.194 -15.235   8.420  1.00 32.68          
ATOM   2524  CG  LYS   363      -7.206 -16.014   9.390  1.00 32.62          
ATOM   2525  CD  LYS   363      -8.245 -16.892   8.620  1.00 32.47          
ATOM   2526  CE  LYS   363      -9.513 -17.165   9.455  1.00 30.66          
ATOM   2527  NZ  LYS   363     -10.669 -17.298   8.487  1.00 25.02          
ATOM   2528  N   GLY   364      -2.996 -16.963   9.439  1.00 30.74          
ATOM   2529  CA  GLY   364      -2.555 -18.287   9.877  1.00 28.40          
ATOM   2530  C   GLY   364      -2.285 -19.176   8.694  1.00 27.66          
ATOM   2531  O   GLY   364      -2.134 -20.382   8.855  1.00 27.80          
ATOM   2532  N   THR   365      -2.234 -18.604   7.489  1.00 26.68          
ATOM   2533  CA  THR   365      -1.891 -19.412   6.326  1.00 25.47          
ATOM   2534  C   THR   365      -0.387 -19.618   6.324  1.00 25.02          
ATOM   2535  O   THR   365       0.122 -20.616   5.821  1.00 24.58          
ATOM   2536  CB  THR   365      -2.250 -18.737   4.990  1.00 26.04          
ATOM   2537  OG1 THR   365      -2.778 -17.417   5.191  1.00 23.25          
ATOM   2538  CG2 THR   365      -3.261 -19.596   4.154  1.00 23.95          
ATOM   2539  N   GLU   366       0.326 -18.653   6.871  1.00 24.12          
ATOM   2540  CA  GLU   366       1.768 -18.644   6.740  1.00 24.63          
ATOM   2541  C   GLU   366       2.510 -18.541   8.060  1.00 22.94          
ATOM   2542  O   GLU   366       2.266 -17.601   8.845  1.00 21.69          
ATOM   2543  CB  GLU   366       2.148 -17.499   5.816  1.00 25.81          
ATOM   2544  CG  GLU   366       1.054 -17.349   4.763  1.00 31.01          
ATOM   2545  CD  GLU   366       1.314 -18.147   3.470  1.00 37.46          
ATOM   2546  OE1 GLU   366       2.190 -17.662   2.674  1.00 40.28          
ATOM   2547  OE2 GLU   366       0.631 -19.206   3.214  1.00 36.69          
ATOM   2548  N   SER   367       3.405 -19.524   8.253  1.00 21.52          
ATOM   2549  CA  SER   367       4.366 -19.635   9.368  1.00 20.76          
ATOM   2550  C   SER   367       5.509 -18.624   9.280  1.00 20.74          
ATOM   2551  O   SER   367       6.273 -18.670   8.320  1.00 21.55          
ATOM   2552  CB  SER   367       4.998 -21.019   9.315  1.00 20.40          
ATOM   2553  OG  SER   367       5.753 -21.329  10.472  1.00 18.08          
ATOM   2554  N   ARG   368       5.642 -17.752  10.275  1.00 19.74          
ATOM   2555  CA  ARG   368       6.821 -16.882  10.401  1.00 20.25          
ATOM   2556  C   ARG   368       8.073 -17.602  10.877  1.00 19.43          
ATOM   2557  O   ARG   368       9.117 -16.960  11.052  1.00 18.64          
ATOM   2558  CB  ARG   368       6.577 -15.675  11.358  1.00 20.77          
ATOM   2559  CG  ARG   368       5.634 -14.618  10.807  1.00 20.06          
ATOM   2560  CD  ARG   368       5.281 -13.450  11.729  1.00 21.25          
ATOM   2561  NE  ARG   368       4.083 -12.858  11.155  1.00 27.33          
ATOM   2562  CZ  ARG   368       4.062 -11.969  10.155  1.00 30.14          
ATOM   2563  NH1 ARG   368       2.900 -11.554   9.673  1.00 33.09          
ATOM   2564  NH2 ARG   368       5.194 -11.474   9.636  1.00 31.67          
ATOM   2565  N   ILE   369       7.927 -18.898  11.140  1.00 19.51          
ATOM   2566  CA  ILE   369       9.032 -19.809  11.393  1.00 21.00          
ATOM   2567  C   ILE   369       9.246 -20.859  10.271  1.00 22.96          
ATOM   2568  O   ILE   369       8.450 -21.792  10.117  1.00 22.80          
ATOM   2569  CB  ILE   369       8.834 -20.472  12.751  1.00 20.51          
ATOM   2570  CG1 ILE   369       9.040 -19.431  13.832  1.00 18.98          
ATOM   2571  CG2 ILE   369       9.804 -21.709  12.969  1.00 19.37          
ATOM   2572  CD  ILE   369       8.232 -19.708  15.002  1.00 19.39          
ATOM   2573  N   VAL   370      10.326 -20.717   9.509  1.00 24.95          
ATOM   2574  CA  VAL   370      10.597 -21.686   8.452  1.00 27.99          
ATOM   2575  C   VAL   370      11.962 -22.449   8.496  1.00 29.38          
ATOM   2576  O   VAL   370      12.949 -21.948   9.057  1.00 30.48          
ATOM   2577  CB  VAL   370      10.455 -21.015   7.131  1.00 28.29          
ATOM   2578  CG1 VAL   370       8.978 -21.040   6.680  1.00 30.37          
ATOM   2579  CG2 VAL   370      11.017 -19.642   7.242  1.00 27.37          
ATOM   2580  N   PRO   371      12.045 -23.632   7.877  1.00 30.26          
ATOM   2581  CA  PRO   371      13.363 -24.319   7.762  1.00 31.14          
ATOM   2582  C   PRO   371      14.440 -23.414   7.071  1.00 31.94          
ATOM   2583  O   PRO   371      15.621 -23.268   7.518  1.00 31.07          
ATOM   2584  CB  PRO   371      13.049 -25.564   6.886  1.00 31.09          
ATOM   2585  CG  PRO   371      11.612 -25.410   6.373  1.00 30.67          
ATOM   2586  CD  PRO   371      10.941 -24.378   7.223  1.00 30.47          
ATOM   2587  N   ILE   372      13.924 -22.770   6.028  1.00 32.55          
ATOM   2588  CA  ILE   372      14.645 -22.214   4.954  1.00 33.72          
ATOM   2589  C   ILE   372      13.900 -20.910   4.778  1.00 33.85          
ATOM   2590  O   ILE   372      12.693 -20.960   4.574  1.00 34.45          
ATOM   2591  CB  ILE   372      14.635 -23.264   3.662  1.00 34.38          
ATOM   2592  CG1 ILE   372      15.261 -22.703   2.368  1.00 35.93          
ATOM   2593  CG2 ILE   372      13.231 -23.908   3.322  1.00 34.16          
ATOM   2594  CD  ILE   372      16.033 -21.266   2.455  1.00 40.01          
ATOM   2595  N   LEU   373      14.624 -19.783   4.961  1.00 33.96          
ATOM   2596  CA  LEU   373      14.185 -18.381   4.777  1.00 33.84          
ATOM   2597  C   LEU   373      14.279 -17.970   3.328  1.00 35.47          
ATOM   2598  O   LEU   373      15.222 -18.387   2.604  1.00 35.88          
ATOM   2599  CB  LEU   373      15.119 -17.381   5.483  1.00 32.84          
ATOM   2600  CG  LEU   373      15.389 -17.319   6.991  1.00 31.19          
ATOM   2601  CD1 LEU   373      16.822 -17.274   7.225  1.00 29.62          
ATOM   2602  CD2 LEU   373      14.716 -16.216   7.792  1.00 28.03          
ATOM   2603  N   LYS   374      13.308 -17.140   2.920  1.00 36.74          
ATOM   2604  CA  LYS   374      13.351 -16.385   1.668  1.00 37.52          
ATOM   2605  C   LYS   374      14.086 -15.095   2.041  1.00 38.26          
ATOM   2606  O   LYS   374      14.463 -14.298   1.190  1.00 39.31          
ATOM   2607  CB  LYS   374      11.945 -16.047   1.185  1.00 37.25          
ATOM   2608  CG  LYS   374      11.208 -15.084   2.150  1.00 39.22          
ATOM   2609  CD  LYS   374      10.372 -13.988   1.430  1.00 40.96          
ATOM   2610  CE  LYS   374       8.893 -14.336   1.449  1.00 40.29          
ATOM   2611  NZ  LYS   374       8.759 -15.779   1.792  1.00 38.75          
ATOM   2612  N   THR   381      23.178 -12.057   8.569  1.00 46.83          
ATOM   2613  CA  THR   381      22.367 -12.014   9.804  1.00 46.71          
ATOM   2614  C   THR   381      22.180 -13.343  10.590  1.00 46.22          
ATOM   2615  O   THR   381      21.185 -13.510  11.298  1.00 44.64          
ATOM   2616  CB  THR   381      21.020 -11.294   9.553  1.00 46.86          
ATOM   2617  OG1 THR   381      20.095 -11.630  10.630  1.00 47.05          
ATOM   2618  CG2 THR   381      20.403 -11.697   8.119  1.00 45.19          
ATOM   2619  N   GLY   382      23.186 -14.231  10.447  1.00 46.69          
ATOM   2620  CA  GLY   382      23.346 -15.535  11.119  1.00 47.23          
ATOM   2621  C   GLY   382      23.201 -15.549  12.638  1.00 48.13          
ATOM   2622  O   GLY   382      23.565 -14.564  13.301  1.00 47.92          
ATOM   2623  N   ARG   383      22.669 -16.698  13.149  1.00 49.11          
ATOM   2624  CA  ARG   383      22.193 -17.103  14.587  1.00 48.00          
ATOM   2625  C   ARG   383      22.791 -16.603  15.934  1.00 48.29          
ATOM   2626  O   ARG   383      21.975 -16.223  16.786  1.00 48.79          
ATOM   2627  CB  ARG   383      22.045 -18.648  14.733  1.00 47.92          
ATOM   2628  CG  ARG   383      23.382 -19.415  14.955  1.00 46.54          
ATOM   2629  CD  ARG   383      24.429 -19.070  13.897  1.00 44.72          
ATOM   2630  NE  ARG   383      25.347 -20.160  13.626  1.00 46.35          
ATOM   2631  CZ  ARG   383      25.234 -20.985  12.594  1.00 45.54          
ATOM   2632  NH1 ARG   383      26.120 -21.970  12.418  1.00 41.96          
ATOM   2633  NH2 ARG   383      24.216 -20.822  11.747  1.00 46.00          
ATOM   2634  N   ASN   384      24.135 -16.728  16.144  1.00 47.30          
ATOM   2635  CA  ASN   384      25.002 -16.017  17.164  1.00 45.86          
ATOM   2636  C   ASN   384      24.717 -14.511  17.308  1.00 44.88          
ATOM   2637  O   ASN   384      25.647 -13.664  17.369  1.00 44.32          
ATOM   2638  CB  ASN   384      26.435 -16.112  16.686  1.00 45.76          
ATOM   2639  CG  ASN   384      26.517 -16.134  15.167  1.00 43.91          
ATOM   2640  OD1 ASN   384      26.136 -15.179  14.479  1.00 36.42          
ATOM   2641  ND2 ASN   384      26.973 -17.270  14.640  1.00 43.86          
ATOM   2642  N   GLU   385      23.403 -14.231  17.298  1.00 43.19          
ATOM   2643  CA  GLU   385      22.722 -12.934  17.317  1.00 39.67          
ATOM   2644  C   GLU   385      21.753 -12.876  18.594  1.00 39.79          
ATOM   2645  O   GLU   385      22.101 -12.208  19.594  1.00 41.38          
ATOM   2646  CB  GLU   385      22.024 -12.677  15.937  1.00 39.29          
ATOM   2647  CG  GLU   385      22.660 -11.666  14.973  1.00 36.08          
ATOM   2648  CD  GLU   385      24.199 -11.519  15.048  1.00 37.63          
ATOM   2649  OE1 GLU   385      24.868 -12.535  15.375  1.00 34.39          
ATOM   2650  OE2 GLU   385      24.757 -10.380  14.747  1.00 36.34          
ATOM   2651  N   VAL   386      20.640 -13.632  18.618  1.00 36.93          
ATOM   2652  CA  VAL   386      19.509 -13.397  19.542  1.00 34.84          
ATOM   2653  C   VAL   386      19.457 -14.381  20.715  1.00 32.14          
ATOM   2654  O   VAL   386      19.873 -15.531  20.558  1.00 32.06          
ATOM   2655  CB  VAL   386      18.244 -13.503  18.687  1.00 34.37          
ATOM   2656  CG1 VAL   386      17.015 -12.964  19.368  1.00 33.29          
ATOM   2657  CG2 VAL   386      18.496 -12.779  17.322  1.00 35.30          
ATOM   2658  N   ASP   387      18.959 -13.972  21.889  1.00 29.19          
ATOM   2659  CA  ASP   387      19.008 -14.893  23.065  1.00 26.13          
ATOM   2660  C   ASP   387      17.700 -15.518  23.340  1.00 23.66          
ATOM   2661  O   ASP   387      17.645 -16.629  23.785  1.00 22.09          
ATOM   2662  CB  ASP   387      19.446 -14.201  24.363  1.00 26.67          
ATOM   2663  CG  ASP   387      20.590 -13.242  24.172  1.00 27.78          
ATOM   2664  OD1 ASP   387      21.448 -13.571  23.317  1.00 31.49          
ATOM   2665  OD2 ASP   387      20.693 -12.135  24.803  1.00 26.21          
ATOM   2666  N   TYR   388      16.649 -14.762  23.114  1.00 22.00          
ATOM   2667  CA  TYR   388      15.290 -15.284  23.188  1.00 21.60          
ATOM   2668  C   TYR   388      14.389 -14.964  21.989  1.00 20.52          
ATOM   2669  O   TYR   388      14.617 -14.005  21.269  1.00 19.71          
ATOM   2670  CB  TYR   388      14.568 -14.753  24.406  1.00 22.91          
ATOM   2671  CG  TYR   388      15.267 -15.096  25.611  1.00 21.98          
ATOM   2672  CD1 TYR   388      16.015 -14.175  26.261  1.00 22.29          
ATOM   2673  CD2 TYR   388      15.171 -16.360  26.109  1.00 28.98          
ATOM   2674  CE1 TYR   388      16.668 -14.488  27.378  1.00 28.54          
ATOM   2675  CE2 TYR   388      15.843 -16.735  27.270  1.00 31.19          
ATOM   2676  CZ  TYR   388      16.600 -15.788  27.900  1.00 29.27          
ATOM   2677  OH  TYR   388      17.289 -16.156  29.049  1.00 28.52          
ATOM   2678  N   VAL   389      13.346 -15.784  21.823  1.00 18.68          
ATOM   2679  CA  VAL   389      12.349 -15.619  20.786  1.00 17.23          
ATOM   2680  C   VAL   389      11.023 -15.950  21.421  1.00 17.57          
ATOM   2681  O   VAL   389      10.895 -16.990  22.104  1.00 18.46          
ATOM   2682  CB  VAL   389      12.586 -16.615  19.628  1.00 17.02          
ATOM   2683  CG1 VAL   389      11.689 -16.344  18.500  1.00 15.03          
ATOM   2684  CG2 VAL   389      13.967 -16.504  19.164  1.00 15.63          
ATOM   2685  N   VAL   390      10.022 -15.103  21.170  1.00 16.61          
ATOM   2686  CA  VAL   390       8.751 -15.172  21.878  1.00 14.29          
ATOM   2687  C   VAL   390       7.649 -15.106  20.871  1.00 14.73          
ATOM   2688  O   VAL   390       7.691 -14.248  20.002  1.00 15.83          
ATOM   2689  CB  VAL   390       8.606 -13.942  22.792  1.00 13.33          
ATOM   2690  CG1 VAL   390       7.200 -13.875  23.370  1.00 11.71          
ATOM   2691  CG2 VAL   390       9.653 -13.914  23.882  1.00  6.12          
ATOM   2692  N   THR   391       6.640 -15.942  21.026  1.00 14.88          
ATOM   2693  CA  THR   391       5.433 -15.910  20.191  1.00 15.77          
ATOM   2694  C   THR   391       4.252 -16.026  21.107  1.00 15.97          
ATOM   2695  O   THR   391       4.381 -16.451  22.275  1.00 17.22          
ATOM   2696  CB  THR   391       5.474 -17.146  19.310  1.00 16.95          
ATOM   2697  OG1 THR   391       6.175 -16.824  18.111  1.00 17.86          
ATOM   2698  CG2 THR   391       4.124 -17.565  18.809  1.00 17.19          
ATOM   2699  N   GLU   392       3.069 -15.716  20.628  1.00 15.71          
ATOM   2700  CA  GLU   392       1.932 -16.098  21.462  1.00 16.38          
ATOM   2701  C   GLU   392       2.050 -17.499  22.079  1.00 17.10          
ATOM   2702  O   GLU   392       1.394 -17.765  23.038  1.00 17.85          
ATOM   2703  CB  GLU   392       0.596 -15.993  20.747  1.00 15.61          
ATOM   2704  CG  GLU   392       0.361 -17.036  19.697  1.00 15.94          
ATOM   2705  CD  GLU   392       0.815 -16.600  18.288  1.00 21.02          
ATOM   2706  OE1 GLU   392       0.209 -17.168  17.236  1.00 20.40          
ATOM   2707  OE2 GLU   392       1.752 -15.701  18.247  1.00 13.60          
ATOM   2708  N   TYR   393       2.876 -18.408  21.575  1.00 18.12          
ATOM   2709  CA  TYR   393       2.834 -19.740  22.166  1.00 18.30          
ATOM   2710  C   TYR   393       3.958 -19.910  23.106  1.00 18.51          
ATOM   2711  O   TYR   393       4.100 -21.014  23.662  1.00 19.33          
ATOM   2712  CB  TYR   393       2.861 -20.893  21.152  1.00 18.12          
ATOM   2713  CG  TYR   393       1.631 -20.889  20.355  1.00 18.24          
ATOM   2714  CD1 TYR   393       0.439 -21.440  20.869  1.00 17.38          
ATOM   2715  CD2 TYR   393       1.598 -20.255  19.121  1.00 18.63          
ATOM   2716  CE1 TYR   393      -0.745 -21.431  20.159  1.00 12.50          
ATOM   2717  CE2 TYR   393       0.401 -20.191  18.407  1.00 19.02          
ATOM   2718  CZ  TYR   393      -0.761 -20.786  18.939  1.00 17.43          
ATOM   2719  OH  TYR   393      -1.919 -20.765  18.176  1.00 21.78          
ATOM   2720  N   GLY   394       4.772 -18.885  23.304  1.00 17.86          
ATOM   2721  CA  GLY   394       5.720 -19.026  24.416  1.00 18.21          
ATOM   2722  C   GLY   394       7.110 -18.688  24.043  1.00 18.62          
ATOM   2723  O   GLY   394       7.315 -18.043  22.995  1.00 18.68          
ATOM   2724  N   VAL   395       8.051 -19.133  24.886  1.00 18.99          
ATOM   2725  CA  VAL   395       9.440 -18.643  24.873  1.00 18.99          
ATOM   2726  C   VAL   395      10.385 -19.660  24.285  1.00 19.60          
ATOM   2727  O   VAL   395      10.077 -20.794  24.302  1.00 19.24          
ATOM   2728  CB  VAL   395       9.880 -18.271  26.254  1.00 18.55          
ATOM   2729  CG1 VAL   395      11.268 -17.706  26.213  1.00 19.74          
ATOM   2730  CG2 VAL   395       8.956 -17.161  26.835  1.00 20.55          
ATOM   2731  N   ALA   396      11.504 -19.245  23.680  1.00 22.04          
ATOM   2732  CA  ALA   396      12.572 -20.164  23.227  1.00 23.54          
ATOM   2733  C   ALA   396      13.897 -19.569  23.532  1.00 24.09          
ATOM   2734  O   ALA   396      14.154 -18.506  23.044  1.00 24.02          
ATOM   2735  CB  ALA   396      12.491 -20.425  21.739  1.00 23.30          
ATOM   2736  N   ARG   397      14.717 -20.272  24.311  1.00 26.32          
ATOM   2737  CA  ARG   397      16.065 -19.847  24.618  1.00 28.32          
ATOM   2738  C   ARG   397      16.999 -20.314  23.556  1.00 29.36          
ATOM   2739  O   ARG   397      17.053 -21.514  23.234  1.00 29.03          
ATOM   2740  CB  ARG   397      16.575 -20.365  25.952  1.00 28.16          
ATOM   2741  CG  ARG   397      18.136 -20.109  26.296  1.00 29.19          
ATOM   2742  CD  ARG   397      18.520 -20.508  27.784  1.00 31.63          
ATOM   2743  NE  ARG   397      17.361 -20.118  28.614  1.00 43.84          
ATOM   2744  CZ  ARG   397      16.265 -20.882  28.822  1.00 45.49          
ATOM   2745  NH1 ARG   397      15.211 -20.413  29.524  1.00 44.59          
ATOM   2746  NH2 ARG   397      16.241 -22.134  28.336  1.00 47.92          
ATOM   2747  N   LEU   398      17.757 -19.322  23.057  1.00 31.26          
ATOM   2748  CA  LEU   398      18.820 -19.501  22.062  1.00 32.69          
ATOM   2749  C   LEU   398      20.285 -19.354  22.570  1.00 33.83          
ATOM   2750  O   LEU   398      21.101 -20.296  22.308  1.00 33.83          
ATOM   2751  CB  LEU   398      18.572 -18.655  20.812  1.00 32.57          
ATOM   2752  CG  LEU   398      17.278 -18.897  20.013  1.00 32.74          
ATOM   2753  CD1 LEU   398      17.373 -18.435  18.538  1.00 27.61          
ATOM   2754  CD2 LEU   398      16.774 -20.339  20.071  1.00 32.34          
ATOM   2755  N   ARG   399      20.640 -18.249  23.275  1.00 34.19          
ATOM   2756  CA  ARG   399      22.011 -18.236  23.822  1.00 34.75          
ATOM   2757  C   ARG   399      22.252 -19.618  24.494  1.00 35.07          
ATOM   2758  O   ARG   399      21.458 -20.055  25.382  1.00 35.16          
ATOM   2759  CB  ARG   399      22.413 -17.038  24.739  1.00 35.09          
ATOM   2760  CG  ARG   399      24.011 -16.761  24.801  1.00 34.48          
ATOM   2761  CD  ARG   399      25.027 -18.034  25.260  1.00 38.68          
ATOM   2762  NE  ARG   399      26.326 -17.539  25.791  1.00 37.96          
ATOM   2763  CZ  ARG   399      26.691 -17.474  27.080  1.00 34.14          
ATOM   2764  NH1 ARG   399      25.895 -17.993  28.041  1.00 25.71          
ATOM   2765  NH2 ARG   399      27.859 -16.856  27.365  1.00 27.67          
ATOM   2766  N   GLY   400      23.307 -20.297  24.016  1.00 33.86          
ATOM   2767  CA  GLY   400      23.731 -21.554  24.566  1.00 33.89          
ATOM   2768  C   GLY   400      22.940 -22.757  24.069  1.00 33.76          
ATOM   2769  O   GLY   400      22.710 -23.700  24.829  1.00 33.80          
ATOM   2770  N   ALA   401      22.512 -22.761  22.808  1.00 33.23          
ATOM   2771  CA  ALA   401      21.738 -23.916  22.305  1.00 32.16          
ATOM   2772  C   ALA   401      22.423 -24.611  21.092  1.00 31.78          
ATOM   2773  O   ALA   401      22.984 -23.897  20.239  1.00 31.60          
ATOM   2774  CB  ALA   401      20.272 -23.461  21.989  1.00 31.62          
ATOM   2775  N   THR   402      22.404 -25.959  21.001  1.00 31.13          
ATOM   2776  CA  THR   402      22.868 -26.639  19.743  1.00 31.33          
ATOM   2777  C   THR   402      22.002 -26.333  18.545  1.00 30.93          
ATOM   2778  O   THR   402      20.816 -26.129  18.668  1.00 31.50          
ATOM   2779  CB  THR   402      22.860 -28.164  19.806  1.00 31.25          
ATOM   2780  OG1 THR   402      22.156 -28.575  20.976  1.00 31.83          
ATOM   2781  CG2 THR   402      24.290 -28.797  19.889  1.00 30.17          
ATOM   2782  N   LEU   403      22.596 -26.339  17.371  1.00 30.18          
ATOM   2783  CA  LEU   403      21.815 -26.560  16.190  1.00 29.21          
ATOM   2784  C   LEU   403      20.491 -27.325  16.445  1.00 28.84          
ATOM   2785  O   LEU   403      19.454 -26.798  16.085  1.00 27.90          
ATOM   2786  CB  LEU   403      22.696 -27.241  15.141  1.00 29.35          
ATOM   2787  CG  LEU   403      23.651 -26.133  14.659  1.00 27.52          
ATOM   2788  CD1 LEU   403      24.712 -26.583  13.613  1.00 26.10          
ATOM   2789  CD2 LEU   403      22.796 -25.017  14.152  1.00 22.62          
ATOM   2790  N   ARG   404      20.507 -28.499  17.100  1.00 28.59          
ATOM   2791  CA  ARG   404      19.234 -29.270  17.371  1.00 28.94          
ATOM   2792  C   ARG   404      18.230 -28.713  18.399  1.00 28.15          
ATOM   2793  O   ARG   404      17.034 -28.857  18.207  1.00 28.41          
ATOM   2794  CB  ARG   404      19.453 -30.759  17.717  1.00 29.53          
ATOM   2795  CG  ARG   404      20.050 -31.074  19.117  1.00 30.99          
ATOM   2796  CD  ARG   404      21.611 -31.177  19.132  1.00 35.55          
ATOM   2797  NE  ARG   404      22.230 -31.538  20.430  1.00 37.33          
ATOM   2798  CZ  ARG   404      22.763 -32.751  20.740  1.00 39.83          
ATOM   2799  NH1 ARG   404      22.746 -33.753  19.849  1.00 40.31          
ATOM   2800  NH2 ARG   404      23.314 -32.964  21.945  1.00 37.57          
ATOM   2801  N   GLN   405      18.692 -28.137  19.500  1.00 27.10          
ATOM   2802  CA  GLN   405      17.764 -27.504  20.456  1.00 26.33          
ATOM   2803  C   GLN   405      17.046 -26.281  19.866  1.00 26.87          
ATOM   2804  O   GLN   405      15.797 -26.187  19.939  1.00 27.35          
ATOM   2805  CB  GLN   405      18.478 -27.108  21.753  1.00 26.37          
ATOM   2806  CG  GLN   405      19.505 -28.148  22.177  1.00 26.20          
ATOM   2807  CD  GLN   405      20.303 -27.769  23.400  1.00 24.08          
ATOM   2808  OE1 GLN   405      21.050 -26.762  23.434  1.00 18.79          
ATOM   2809  NE2 GLN   405      20.184 -28.602  24.400  1.00 18.86          
ATOM   2810  N   ARG   406      17.839 -25.346  19.299  1.00 26.73          
ATOM   2811  CA  ARG   406      17.358 -24.092  18.710  1.00 26.01          
ATOM   2812  C   ARG   406      16.209 -24.441  17.715  1.00 25.91          
ATOM   2813  O   ARG   406      15.104 -23.873  17.775  1.00 25.19          
ATOM   2814  CB  ARG   406      18.520 -23.360  18.033  1.00 25.69          
ATOM   2815  CG  ARG   406      19.700 -23.015  18.953  1.00 26.41          
ATOM   2816  CD  ARG   406      21.082 -22.719  18.220  1.00 27.44          
ATOM   2817  NE  ARG   406      21.223 -21.357  17.706  1.00 25.23          
ATOM   2818  CZ  ARG   406      21.623 -20.344  18.465  1.00 32.21          
ATOM   2819  NH1 ARG   406      21.937 -20.566  19.745  1.00 34.21          
ATOM   2820  NH2 ARG   406      21.703 -19.097  17.975  1.00 33.65          
ATOM   2821  N   ALA   407      16.478 -25.433  16.856  1.00 25.62          
ATOM   2822  CA  ALA   407      15.515 -26.033  15.949  1.00 25.37          
ATOM   2823  C   ALA   407      14.140 -26.291  16.613  1.00 25.98          
ATOM   2824  O   ALA   407      13.050 -25.758  16.178  1.00 25.55          
ATOM   2825  CB  ALA   407      16.078 -27.347  15.437  1.00 24.95          
ATOM   2826  N   GLU   408      14.189 -27.123  17.661  1.00 25.23          
ATOM   2827  CA  GLU   408      12.968 -27.629  18.176  1.00 24.35          
ATOM   2828  C   GLU   408      12.399 -26.779  19.360  1.00 22.65          
ATOM   2829  O   GLU   408      11.223 -26.871  19.686  1.00 22.54          
ATOM   2830  CB  GLU   408      13.017 -29.181  18.231  1.00 24.61          
ATOM   2831  CG  GLU   408      13.103 -29.874  19.551  1.00 30.18          
ATOM   2832  CD  GLU   408      14.284 -29.388  20.366  1.00 38.77          
ATOM   2833  OE1 GLU   408      15.037 -30.257  20.924  1.00 44.34          
ATOM   2834  OE2 GLU   408      14.464 -28.146  20.455  1.00 39.21          
ATOM   2835  N   ALA   409      13.190 -25.869  19.908  1.00 19.93          
ATOM   2836  CA  ALA   409      12.721 -25.187  21.048  1.00 19.12          
ATOM   2837  C   ALA   409      11.836 -24.144  20.415  1.00 20.33          
ATOM   2838  O   ALA   409      10.849 -23.629  21.021  1.00 22.08          
ATOM   2839  CB  ALA   409      13.856 -24.560  21.767  1.00 18.12          
ATOM   2840  N   LEU   410      12.208 -23.788  19.186  1.00 20.24          
ATOM   2841  CA  LEU   410      11.470 -22.808  18.372  1.00 18.27          
ATOM   2842  C   LEU   410      10.167 -23.458  17.942  1.00 17.01          
ATOM   2843  O   LEU   410       9.084 -22.864  18.097  1.00 16.88          
ATOM   2844  CB  LEU   410      12.213 -22.541  17.080  1.00 18.40          
ATOM   2845  CG  LEU   410      12.756 -21.190  16.686  1.00 19.72          
ATOM   2846  CD1 LEU   410      11.985 -20.109  17.410  1.00 20.05          
ATOM   2847  CD2 LEU   410      14.240 -21.101  16.996  1.00 21.26          
ATOM   2848  N   THR   411      10.293 -24.668  17.378  1.00 14.11          
ATOM   2849  CA  THR   411       9.148 -25.379  16.831  1.00 12.87          
ATOM   2850  C   THR   411       8.032 -25.470  17.877  1.00 12.97          
ATOM   2851  O   THR   411       6.861 -25.454  17.559  1.00 12.63          
ATOM   2852  CB  THR   411       9.565 -26.800  16.423  1.00 13.04          
ATOM   2853  OG1 THR   411      10.314 -26.735  15.214  1.00 10.19          
ATOM   2854  CG2 THR   411       8.349 -27.698  16.130  1.00  9.06          
ATOM   2855  N   ALA   412       8.451 -25.598  19.132  1.00 12.09          
ATOM   2856  CA  ALA   412       7.558 -25.624  20.237  1.00 10.14          
ATOM   2857  C   ALA   412       6.792 -24.310  20.313  1.00  9.10          
ATOM   2858  O   ALA   412       5.673 -24.368  20.706  1.00 10.76          
ATOM   2859  CB  ALA   412       8.276 -26.026  21.615  1.00  8.76          
ATOM   2860  N   ILE   413       7.318 -23.160  19.942  1.00  7.39          
ATOM   2861  CA  ILE   413       6.461 -21.947  19.983  1.00  6.86          
ATOM   2862  C   ILE   413       5.806 -21.450  18.650  1.00  7.02          
ATOM   2863  O   ILE   413       5.103 -20.386  18.612  1.00  6.92          
ATOM   2864  CB  ILE   413       7.224 -20.788  20.535  1.00  7.13          
ATOM   2865  CG1 ILE   413       8.156 -20.269  19.488  1.00  2.75          
ATOM   2866  CG2 ILE   413       7.906 -21.218  21.810  1.00  8.66          
ATOM   2867  CD  ILE   413       8.795 -19.099  19.905  1.00  7.73          
ATOM   2868  N   ALA   414       6.067 -22.208  17.585  1.00  5.48          
ATOM   2869  CA  ALA   414       5.368 -22.088  16.335  1.00  5.13          
ATOM   2870  C   ALA   414       3.869 -22.361  16.446  1.00  4.79          
ATOM   2871  O   ALA   414       3.373 -23.013  17.380  1.00  3.06          
ATOM   2872  CB  ALA   414       5.981 -23.114  15.311  1.00  6.43          
ATOM   2873  N   HSD   415       3.150 -21.959  15.403  1.00  5.00          
ATOM   2874  CA  HSD   415       1.760 -22.258  15.407  1.00  4.24          
ATOM   2875  C   HSD   415       1.682 -23.740  15.320  1.00  4.76          
ATOM   2876  O   HSD   415       2.515 -24.383  14.641  1.00  4.34          
ATOM   2877  CB  HSD   415       1.022 -21.582  14.264  1.00  4.79          
ATOM   2878  CG  HSD   415      -0.446 -21.856  14.273  1.00  7.59          
ATOM   2879  ND1 HSD   415      -1.344 -21.108  15.010  1.00  8.22          
ATOM   2880  CD2 HSD   415      -1.164 -22.864  13.707  1.00 10.65          
ATOM   2881  CE1 HSD   415      -2.549 -21.623  14.881  1.00  8.77          
ATOM   2882  NE2 HSD   415      -2.463 -22.708  14.120  1.00 10.04          
ATOM   2883  N   PRO   416       0.663 -24.276  16.025  1.00  6.12          
ATOM   2884  CA  PRO   416       0.342 -25.714  16.024  1.00  5.79          
ATOM   2885  C   PRO   416       0.146 -26.377  14.652  1.00  6.29          
ATOM   2886  O   PRO   416       0.481 -27.581  14.481  1.00  6.02          
ATOM   2887  CB  PRO   416      -0.955 -25.765  16.861  1.00  5.48          
ATOM   2888  CG  PRO   416      -0.914 -24.598  17.727  1.00  2.49          
ATOM   2889  CD  PRO   416      -0.299 -23.542  16.902  1.00  5.07          
ATOM   2890  N   ASP   417      -0.411 -25.667  13.674  1.00  7.64          
ATOM   2891  CA  ASP   417      -0.611 -26.378  12.346  1.00 10.25          
ATOM   2892  C   ASP   417       0.727 -26.828  11.785  1.00  9.65          
ATOM   2893  O   ASP   417       0.927 -27.955  11.339  1.00  8.87          
ATOM   2894  CB  ASP   417      -1.244 -25.477  11.289  1.00 11.45          
ATOM   2895  CG  ASP   417      -2.594 -24.937  11.696  1.00 14.21          
ATOM   2896  OD1 ASP   417      -3.106 -25.312  12.763  1.00 16.31          
ATOM   2897  OD2 ASP   417      -3.182 -24.080  10.995  1.00 16.39          
ATOM   2898  N   PHE   418       1.643 -25.879  11.903  1.00  9.50          
ATOM   2899  CA  PHE   418       2.947 -25.921  11.360  1.00  8.27          
ATOM   2900  C   PHE   418       3.970 -26.766  12.078  1.00  8.34          
ATOM   2901  O   PHE   418       4.886 -27.267  11.418  1.00  7.82          
ATOM   2902  CB  PHE   418       3.356 -24.493  11.288  1.00  7.71          
ATOM   2903  CG  PHE   418       2.624 -23.798  10.258  1.00  5.97          
ATOM   2904  CD1 PHE   418       2.325 -22.472  10.366  1.00  6.81          
ATOM   2905  CD2 PHE   418       2.155 -24.525   9.174  1.00  3.31          
ATOM   2906  CE1 PHE   418       1.631 -21.865   9.361  1.00  8.08          
ATOM   2907  CE2 PHE   418       1.456 -23.943   8.180  1.00  2.00          
ATOM   2908  CZ  PHE   418       1.182 -22.645   8.235  1.00  3.08          
ATOM   2909  N   ARG   419       3.799 -26.943  13.398  1.00  8.24          
ATOM   2910  CA  ARG   419       4.648 -27.853  14.172  1.00  8.51          
ATOM   2911  C   ARG   419       4.918 -29.266  13.649  1.00 10.04          
ATOM   2912  O   ARG   419       6.050 -29.637  13.745  1.00  9.97          
ATOM   2913  CB  ARG   419       4.168 -27.998  15.568  1.00  8.47          
ATOM   2914  CG  ARG   419       4.138 -26.760  16.357  1.00  9.87          
ATOM   2915  CD  ARG   419       3.769 -26.991  17.815  1.00 11.45          
ATOM   2916  NE  ARG   419       3.190 -25.761  18.396  1.00 14.32          
ATOM   2917  CZ  ARG   419       2.904 -25.568  19.701  1.00  9.94          
ATOM   2918  NH1 ARG   419       2.342 -24.429  20.066  1.00  9.75          
ATOM   2919  NH2 ARG   419       3.121 -26.500  20.599  1.00  2.00          
ATOM   2920  N   PRO   420       3.966 -30.089  13.139  1.00 11.86          
ATOM   2921  CA  PRO   420       4.409 -31.345  12.506  1.00 12.24          
ATOM   2922  C   PRO   420       5.125 -31.125  11.143  1.00 12.90          
ATOM   2923  O   PRO   420       6.049 -31.921  10.831  1.00 13.50          
ATOM   2924  CB  PRO   420       3.133 -32.238  12.412  1.00 11.34          
ATOM   2925  CG  PRO   420       1.956 -31.314  12.572  1.00 11.12          
ATOM   2926  CD  PRO   420       2.480 -29.978  13.104  1.00 12.88          
ATOM   2927  N   ALA   421       4.759 -30.114  10.340  1.00 12.15          
ATOM   2928  CA  ALA   421       5.591 -29.923   9.150  1.00 13.19          
ATOM   2929  C   ALA   421       7.033 -29.627   9.708  1.00 14.31          
ATOM   2930  O   ALA   421       7.988 -30.356   9.419  1.00 14.21          
ATOM   2931  CB  ALA   421       5.029 -28.791   8.195  1.00 12.52          
ATOM   2932  N   LEU   422       7.160 -28.639  10.591  1.00 14.81          
ATOM   2933  CA  LEU   422       8.418 -28.333  11.242  1.00 16.45          
ATOM   2934  C   LEU   422       9.158 -29.455  11.937  1.00 18.10          
ATOM   2935  O   LEU   422      10.369 -29.515  11.871  1.00 18.96          
ATOM   2936  CB  LEU   422       8.229 -27.191  12.229  1.00 16.00          
ATOM   2937  CG  LEU   422       7.985 -25.846  11.488  1.00 18.76          
ATOM   2938  CD1 LEU   422       7.480 -24.669  12.389  1.00 19.48          
ATOM   2939  CD2 LEU   422       9.162 -25.405  10.545  1.00 17.67          
ATOM   2940  N   GLU   423       8.454 -30.325  12.635  1.00 19.85          
ATOM   2941  CA  GLU   423       9.090 -31.351  13.399  1.00 22.17          
ATOM   2942  C   GLU   423       9.607 -32.415  12.453  1.00 23.91          
ATOM   2943  O   GLU   423      10.619 -33.107  12.717  1.00 24.75          
ATOM   2944  CB  GLU   423       8.066 -31.980  14.315  1.00 22.68          
ATOM   2945  CG  GLU   423       8.657 -32.709  15.514  1.00 27.89          
ATOM   2946  CD  GLU   423       9.378 -31.747  16.456  1.00 36.59          
ATOM   2947  OE1 GLU   423       8.664 -31.005  17.211  1.00 41.17          
ATOM   2948  OE2 GLU   423      10.653 -31.701  16.434  1.00 39.61          
ATOM   2949  N   GLU   424       8.867 -32.576  11.358  1.00 25.01          
ATOM   2950  CA  GLU   424       9.260 -33.408  10.232  1.00 25.29          
ATOM   2951  C   GLU   424      10.652 -32.992   9.706  1.00 25.33          
ATOM   2952  O   GLU   424      11.510 -33.833   9.512  1.00 25.66          
ATOM   2953  CB  GLU   424       8.191 -33.236   9.161  1.00 25.64          
ATOM   2954  CG  GLU   424       8.161 -34.291   8.105  1.00 26.62          
ATOM   2955  CD  GLU   424       8.292 -35.659   8.699  1.00 29.11          
ATOM   2956  OE1 GLU   424       7.298 -36.142   9.299  1.00 31.05          
ATOM   2957  OE2 GLU   424       9.391 -36.242   8.548  1.00 30.35          
ATOM   2958  N   GLU   425      10.882 -31.691   9.534  1.00 25.54          
ATOM   2959  CA  GLU   425      12.150 -31.175   9.010  1.00 25.77          
ATOM   2960  C   GLU   425      13.340 -31.484   9.895  1.00 26.40          
ATOM   2961  O   GLU   425      14.370 -31.873   9.378  1.00 27.23          
ATOM   2962  CB  GLU   425      12.076 -29.659   8.768  1.00 25.38          
ATOM   2963  CG  GLU   425      12.853 -29.147   7.565  1.00 24.38          
ATOM   2964  CD  GLU   425      12.224 -29.650   6.285  1.00 27.40          
ATOM   2965  OE1 GLU   425      11.009 -29.384   6.124  1.00 28.78          
ATOM   2966  OE2 GLU   425      12.903 -30.353   5.476  1.00 27.30          
ATOM   2967  N   ILE   426      13.208 -31.281  11.209  1.00 27.22          
ATOM   2968  CA  ILE   426      14.265 -31.610  12.185  1.00 28.53          
ATOM   2969  C   ILE   426      14.681 -33.052  12.036  1.00 29.15          
ATOM   2970  O   ILE   426      15.864 -33.334  12.053  1.00 29.54          
ATOM   2971  CB  ILE   426      13.800 -31.386  13.646  1.00 28.51          
ATOM   2972  CG1 ILE   426      13.653 -29.892  13.882  1.00 31.20          
ATOM   2973  CG2 ILE   426      14.752 -32.085  14.708  1.00 26.81          
ATOM   2974  CD  ILE   426      13.327 -29.559  15.315  1.00 35.97          
ATOM   2975  N   ARG   427      13.703 -33.951  11.919  1.00 29.72          
ATOM   2976  CA  ARG   427      13.988 -35.351  11.795  1.00 30.26          
ATOM   2977  C   ARG   427      14.930 -35.558  10.603  1.00 30.87          
ATOM   2978  O   ARG   427      15.960 -36.234  10.766  1.00 30.83          
ATOM   2979  CB  ARG   427      12.707 -36.192  11.718  1.00 30.20          
ATOM   2980  CG  ARG   427      12.396 -37.086  12.970  1.00 30.64          
ATOM   2981  CD  ARG   427      13.512 -38.114  13.390  1.00 30.85          
ATOM   2982  NE  ARG   427      13.073 -39.535  13.377  1.00 32.37          
ATOM   2983  CZ  ARG   427      13.899 -40.613  13.339  1.00 31.30          
ATOM   2984  NH1 ARG   427      13.403 -41.850  13.290  1.00 27.19          
ATOM   2985  NH2 ARG   427      15.225 -40.449  13.325  1.00 31.58          
ATOM   2986  N   ARG   428      14.640 -34.936   9.448  1.00 31.64          
ATOM   2987  CA  ARG   428      15.547 -35.006   8.252  1.00 32.57          
ATOM   2988  C   ARG   428      16.739 -34.031   8.384  1.00 33.33          
ATOM   2989  O   ARG   428      16.913 -33.073   7.633  1.00 33.74          
ATOM   2990  CB  ARG   428      14.776 -34.874   6.910  1.00 32.10          
ATOM   2991  CG  ARG   428      14.380 -33.447   6.422  1.00 32.75          
ATOM   2992  CD  ARG   428      15.478 -32.685   5.633  1.00 36.34          
ATOM   2993  NE  ARG   428      15.916 -33.309   4.349  1.00 39.92          
ATOM   2994  CZ  ARG   428      16.861 -34.298   4.172  1.00 38.67          
ATOM   2995  NH1 ARG   428      17.149 -34.738   2.939  1.00 35.48          
ATOM   2996  NH2 ARG   428      17.517 -34.851   5.202  1.00 37.85          
ATOM   2997  N   ARG   429      17.562 -34.299   9.385  1.00 34.34          
ATOM   2998  CA  ARG   429      18.595 -33.393   9.800  1.00 35.14          
ATOM   2999  C   ARG   429      19.196 -34.065  10.992  1.00 35.71          
ATOM   3000  O   ARG   429      19.999 -33.430  11.663  1.00 35.65          
ATOM   3001  CB  ARG   429      17.994 -32.092  10.313  1.00 35.15          
ATOM   3002  CG  ARG   429      18.266 -30.880   9.478  1.00 36.40          
ATOM   3003  CD  ARG   429      17.489 -30.773   8.183  1.00 36.40          
ATOM   3004  NE  ARG   429      17.762 -29.487   7.520  1.00 38.98          
ATOM   3005  CZ  ARG   429      18.820 -29.236   6.720  1.00 36.09          
ATOM   3006  NH1 ARG   429      18.959 -28.034   6.174  1.00 31.83          
ATOM   3007  NH2 ARG   429      19.734 -30.182   6.465  1.00 35.33          
ATOM   3008  N   PHE   430      18.763 -35.312  11.269  1.00 36.25          
ATOM   3009  CA  PHE   430      19.106 -36.104  12.478  1.00 37.23          
ATOM   3010  C   PHE   430      18.578 -37.516  12.314  1.00 37.32          
ATOM   3011  O   PHE   430      18.991 -38.271  11.390  1.00 37.53          
ATOM   3012  CB  PHE   430      18.489 -35.537  13.787  1.00 37.93          
ATOM   3013  CG  PHE   430      19.227 -34.340  14.361  1.00 39.13          
ATOM   3014  CD1 PHE   430      20.132 -34.511  15.423  1.00 38.91          
ATOM   3015  CD2 PHE   430      19.010 -33.025  13.833  1.00 39.69          
ATOM   3016  CE1 PHE   430      20.831 -33.402  15.943  1.00 38.73          
ATOM   3017  CE2 PHE   430      19.716 -31.895  14.327  1.00 38.48          
ATOM   3018  CZ  PHE   430      20.628 -32.083  15.375  1.00 38.20          
END
