
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  224 ( 1827),  selected  224 , name 2anu_F
# Molecule2: number of CA atoms  275 ( 2207),  selected  275 , name T0440.pdb
# PARAMETERS: 2anu_F.T0440.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_F      -       -           -
LGA    E     6_F      -       -           -
LGA    W     7_F      -       -           -
LGA    L     8_F      M       1          2.067
LGA    L     9_F      K       2          0.880
LGA    C    10_F      R       3          0.622
LGA    D    11_F      D       4          0.561
LGA    F    12_F      G       5          0.809
LGA    H    13_F      H       6          0.757
LGA    V    14_F      T       7          0.654
LGA    H    15_F      H       8          1.202
LGA    T    16_F      T       9          1.734
LGA    N    17_F      E      10          2.819
LGA    X    18_F      F      11          0.903
LGA    S    19_F      C      12          1.859
LGA    -       -      P      13           -
LGA    D    20_F      H      14          3.619
LGA    G    21_F      G      15          2.779
LGA    H    22_F      T      16          1.937
LGA    L    23_F      H      17          3.763
LGA    P    24_F      D      18          2.561
LGA    L    25_F      D      19          3.312
LGA    -       -      V      20           -
LGA    G    26_F      E      21          1.920
LGA    E    27_F      E      22          1.921
LGA    V    28_F      M      23          1.494
LGA    V    29_F      V      24          1.447
LGA    D    30_F      L      25          1.781
LGA    L    31_F      K      26          1.772
LGA    F    32_F      A      27          1.009
LGA    G    33_F      I      28          1.772
LGA    K    34_F      E      29          1.640
LGA    H    35_F      L      30          1.319
LGA    G    36_F      D      31          1.426
LGA    V    37_F      F      32          0.694
LGA    D    38_F      D      33          0.430
LGA    V    39_F      E      34          0.716
LGA    V    40_F      Y      35          0.257
LGA    S    41_F      S      36          0.527
LGA    I    42_F      I      37          0.479
LGA    T    43_F      V      38          0.563
LGA    D    44_F      E      39          0.619
LGA    H    45_F      H      40          0.827
LGA    I    46_F      A      41          1.007
LGA    V    47_F      P      42          4.529
LGA    D    48_F      L      43          3.736
LGA    R    49_F      S      44          1.304
LGA    -       -      S      45           -
LGA    R    50_F      E      46          4.658
LGA    T    51_F      F      47          4.743
LGA    L    52_F      M      48          3.882
LGA    E    53_F      K      49          4.129
LGA    -       -      N      50           -
LGA    Q    54_F      T      51          4.068
LGA    R    55_F      A      52           #
LGA    K    56_F      G      53           -
LGA    R    57_F      D      54           -
LGA    N    58_F      K      55          3.019
LGA    G    59_F      E      56           #
LGA    E    60_F      A      57           #
LGA    -       -      V      58           -
LGA    P    61_F      T      59          3.396
LGA    L    62_F      T      60          3.207
LGA    G    63_F      A      61          3.071
LGA    A    64_F      S      62          1.547
LGA    I    65_F      M      63          3.216
LGA    T    66_F      A      64          2.985
LGA    E    67_F      M      65          3.117
LGA    D    68_F      S      66          3.282
LGA    K    69_F      D      67          2.621
LGA    F    70_F      L      68          2.114
LGA    Q    71_F      P      69          3.039
LGA    D    72_F      Y      70          2.306
LGA    Y    73_F      Y      71          1.091
LGA    L    74_F      F      72          1.366
LGA    K    75_F      K      73          1.388
LGA    R    76_F      K      74          1.017
LGA    L    77_F      M      75          0.835
LGA    W    78_F      N      76          0.574
LGA    R    79_F      H      77          0.271
LGA    E    80_F      I      78          0.424
LGA    Q    81_F      K      79          0.781
LGA    K    82_F      K      80          2.023
LGA    R    83_F      K      81          2.222
LGA    A    84_F      Y      82          1.954
LGA    W    85_F      A      83          2.546
LGA    E    86_F      S      84          4.740
LGA    E    87_F      -       -           -
LGA    Y    88_F      -       -           -
LGA    G    89_F      D      85          1.014
LGA    X    90_F      L      86          0.923
LGA    I    91_F      L      87          1.156
LGA    L    92_F      I      88          1.123
LGA    I    93_F      H      89          1.049
LGA    P    94_F      I      90          0.641
LGA    G    95_F      G      91          1.501
LGA    V    96_F      F      92          0.875
LGA    E    97_F      E      93          0.567
LGA    I    98_F      V      94          0.437
LGA    T    99_F      D      95          1.160
LGA    N   100_F      Y      96          2.404
LGA    N   101_F      L      97          5.207
LGA    T   102_F      -       -           -
LGA    D   103_F      I      98          3.133
LGA    L   104_F      G      99           -
LGA    Y   105_F      Y     100           -
LGA    H   106_F      E     101           -
LGA    -       -      D     102           -
LGA    -       -      F     103           -
LGA    -       -      T     104           -
LGA    -       -      R     105           -
LGA    -       -      D     106           -
LGA    -       -      F     107           -
LGA    -       -      L     108           -
LGA    -       -      N     109           -
LGA    -       -      E     110           -
LGA    -       -      Y     111           -
LGA    -       -      G     112           -
LGA    -       -      P     113           -
LGA    -       -      Q     114           -
LGA    -       -      T     115           -
LGA    -       -      D     116           -
LGA    -       -      D     117           -
LGA    I   107_F      G     118           #
LGA    V   108_F      V     119          0.799
LGA    A   109_F      L     120           #
LGA    V   110_F      S     121           -
LGA    D   111_F      L     122           -
LGA    V   112_F      H     123           -
LGA    K   113_F      F     124           -
LGA    E   114_F      L     125           -
LGA    Y   115_F      E     126           -
LGA    V   116_F      G     127           -
LGA    D   117_F      Q     128           -
LGA    P   118_F      G     129           -
LGA    S   119_F      G     130           -
LGA    L   120_F      F     131           -
LGA    -       -      R     132           -
LGA    -       -      S     133           -
LGA    -       -      I     134           -
LGA    -       -      D     135           -
LGA    -       -      F     136           -
LGA    -       -      S     137           -
LGA    -       -      A     138           -
LGA    -       -      E     139           -
LGA    -       -      D     140           -
LGA    -       -      Y     141           -
LGA    -       -      N     142           -
LGA    -       -      E     143           -
LGA    -       -      G     144           -
LGA    -       -      I     145           -
LGA    -       -      V     146           -
LGA    -       -      Q     147           -
LGA    -       -      F     148           -
LGA    -       -      Y     149           -
LGA    -       -      G     150           -
LGA    -       -      G     151           -
LGA    -       -      F     152           -
LGA    -       -      E     153           -
LGA    -       -      Q     154           -
LGA    -       -      A     155           -
LGA    -       -      Q     156           -
LGA    -       -      L     157           -
LGA    -       -      A     158           -
LGA    -       -      Y     159           -
LGA    -       -      L     160           -
LGA    -       -      E     161           -
LGA    -       -      G     162           -
LGA    -       -      V     163           -
LGA    -       -      K     164           -
LGA    -       -      Q     165           -
LGA    -       -      S     166           -
LGA    -       -      I     167           -
LGA    P   121_F      E     168           #
LGA    V   122_F      A     169          2.370
LGA    E   123_F      D     170          2.062
LGA    E   124_F      L     171          2.095
LGA    I   125_F      G     172          4.097
LGA    V   126_F      -       -           -
LGA    E   127_F      L     173          2.245
LGA    K   128_F      -       -           -
LGA    L   129_F      F     174          1.037
LGA    K   130_F      K     175           #
LGA    E   131_F      -       -           -
LGA    Q   132_F      -       -           -
LGA    N   133_F      -       -           -
LGA    A   134_F      -       -           -
LGA    L   135_F      P     176           #
LGA    V   136_F      R     177          2.313
LGA    I   137_F      R     178          0.869
LGA    A   138_F      M     179          1.295
LGA    A   139_F      G     180          1.514
LGA    H   140_F      H     181          1.882
LGA    P   141_F      I     182          3.912
LGA    D   142_F      S     183           #
LGA    -       -      L     184           -
LGA    -       -      C     185           -
LGA    R   143_F      Q     186          4.714
LGA    K   144_F      K     187          2.461
LGA    H   150_F      F     188           -
LGA    L   151_F      Q     189           -
LGA    -       -      Q     190           -
LGA    -       -      F     191           -
LGA    -       -      F     192           -
LGA    -       -      G     193           -
LGA    -       -      E     194           -
LGA    -       -      D     195           -
LGA    -       -      T     196           -
LGA    -       -      S     197           -
LGA    -       -      D     198           -
LGA    -       -      F     199           -
LGA    -       -      S     200           -
LGA    -       -      E     201           -
LGA    -       -      E     202           -
LGA    S   152_F      V     203           #
LGA    W   153_F      M     204           -
LGA    Y   154_F      E     205           -
LGA    L   155_F      -       -           -
LGA    W   156_F      K     206           #
LGA    A   157_F      F     207           #
LGA    -       -      R     208           -
LGA    -       -      V     209           -
LGA    N   158_F      I     210          3.502
LGA    X   159_F      L     211          3.691
LGA    E   160_F      A     212          3.466
LGA    R   161_F      L     213          3.803
LGA    F   162_F      V     214          4.201
LGA    K   163_F      K     215          3.207
LGA    D   164_F      K     216          3.277
LGA    T   165_F      R     217          2.807
LGA    F   166_F      D     218          4.540
LGA    D   167_F      Y     219          3.494
LGA    A   168_F      E     220          1.391
LGA    W   169_F      -       -           -
LGA    E   170_F      L     221          2.164
LGA    I   171_F      D     222           #
LGA    A   172_F      F     223          2.263
LGA    N   173_F      N     224          1.655
LGA    R   174_F      T     225          0.725
LGA    D   175_F      A     226           #
LGA    -       -      G     227           -
LGA    -       -      L     228           -
LGA    -       -      F     229           -
LGA    -       -      K     230           -
LGA    -       -      P     231           -
LGA    -       -      L     232           -
LGA    -       -      C     233           -
LGA    -       -      G     234           -
LGA    -       -      E     235           -
LGA    D   176_F      T     236          2.182
LGA    L   177_F      Y     237           #
LGA    -       -      P     238           -
LGA    -       -      P     239           -
LGA    F   178_F      K     240          4.466
LGA    N   179_F      K     241          3.469
LGA    -       -      I     242           -
LGA    -       -      V     243           -
LGA    -       -      T     244           -
LGA    S   180_F      L     245          3.686
LGA    V   181_F      A     246          1.777
LGA    G   182_F      S     247          1.892
LGA    V   183_F      E     248          3.598
LGA    K   184_F      L     249          3.271
LGA    K   185_F      Q     250          3.038
LGA    Y   186_F      -       -           -
LGA    R   187_F      I     251          2.226
LGA    Y   188_F      P     252          1.387
LGA    V   189_F      F     253          1.918
LGA    A   190_F      V     254          2.865
LGA    N   191_F      Y     255          2.037
LGA    S   192_F      G     256          2.718
LGA    -       -      S     257           -
LGA    D   193_F      D     258          1.827
LGA    F   194_F      S     259          1.790
LGA    H   195_F      H     260          2.493
LGA    E   196_F      G     261          4.298
LGA    -       -      V     262           -
LGA    L   197_F      Q     263          1.674
LGA    W   198_F      D     264          3.313
LGA    H   199_F      I     265          4.983
LGA    V   200_F      G     266          2.098
LGA    Y   201_F      R     267          1.891
LGA    S   202_F      G     268          2.364
LGA    W   203_F      Y     269          3.245
LGA    K   204_F      S     270           -
LGA    T   205_F      T     271           -
LGA    L   206_F      -       -           -
LGA    V   207_F      -       -           -
LGA    K   208_F      -       -           -
LGA    S   209_F      -       -           -
LGA    E   210_F      -       -           -
LGA    K   211_F      -       -           -
LGA    N   212_F      -       -           -
LGA    I   213_F      -       -           -
LGA    E   214_F      -       -           -
LGA    A   215_F      -       -           -
LGA    I   216_F      -       -           -
LGA    K   217_F      -       -           -
LGA    E   218_F      -       -           -
LGA    A   219_F      -       -           -
LGA    I   220_F      -       -           -
LGA    R   221_F      -       -           -
LGA    K   222_F      -       -           -
LGA    N   223_F      -       -           -
LGA    T   224_F      -       -           -
LGA    D   225_F      -       -           -
LGA    V   226_F      -       -           -
LGA    A   227_F      -       -           -
LGA    I   228_F      -       -           -
LGA    Y   229_F      Y     272          5.111
LGA    L   230_F      C     273          3.799
LGA    X   231_F      Q     274           -
LGA    R   232_F      K     275           -
LGA    K   233_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  224  275    5.0    146    2.55    16.44     33.906     5.507

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.739342 * X  +   0.648646 * Y  +  -0.180643 * Z  + -96.909912
  Y_new =  -0.655210 * X  +   0.631250 * Y  +  -0.414997 * Z  +  49.723145
  Z_new =  -0.155155 * X  +   0.425184 * Y  +   0.891709 * Z  +  50.926643 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.444932   -2.696661  [ DEG:    25.4927   -154.5073 ]
  Theta =   0.155784    2.985808  [ DEG:     8.9258    171.0742 ]
  Phi   =  -0.725143    2.416450  [ DEG:   -41.5476    138.4524 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2anu_F                                        
REMARK     2: T0440.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2anu_F.T0440.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  224  275   5.0  146   2.55   16.44  33.906
REMARK  ---------------------------------------------------------- 
MOLECULE 2anu_F
HEADER    METAL BINDING PROTEIN                   11-AUG-05   2ANU              
TITLE     CRYSTAL STRUCTURE OF PREDICTED METAL-DEPENDENT                        
TITLE    2 PHOSPHOESTERASE (PHP FAMILY) (TM0559) FROM THERMOTOGA                
TITLE    3 MARITIMA AT 2.40 A RESOLUTION                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TM0559;                               
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: PREDICTED METAL-DEPENDENT PHOSPHOESTERASE (PHP              
COMPND   5 FAMILY);                                                             
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA  MSB8;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MSB8;                                                        
SOURCE   5 GENE: TM0559;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: DL41;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    TM0559, PREDICTED METAL-DEPENDENT PHOSPHOESTERASE (PHP                
KEYWDS   2 FAMILY), STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL            
KEYWDS   3 GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE, PSI                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   18-OCT-05 2ANU    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PREDICTED METAL-DEPENDENT               
JRNL        TITL 2 PHOSPHOESTERASE (PHP FAMILY) (TM0559) FROM                   
JRNL        TITL 3 THERMOTOGA MARITIMA AT 2.40 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2ANU A    1   243  UNP    Q9WZ29   Q9WZ29_THEMA     1    243             
DBREF  2ANU B    1   243  UNP    Q9WZ29   Q9WZ29_THEMA     1    243             
DBREF  2ANU C    1   243  UNP    Q9WZ29   Q9WZ29_THEMA     1    243             
DBREF  2ANU D    1   243  UNP    Q9WZ29   Q9WZ29_THEMA     1    243             
DBREF  2ANU E    1   243  UNP    Q9WZ29   Q9WZ29_THEMA     1    243             
DBREF  2ANU F    1   243  UNP    Q9WZ29   Q9WZ29_THEMA     1    243             
SEQRES   1 A  255  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 A  255  LYS THR ASP THR GLU TRP LEU LEU CYS ASP PHE HIS VAL          
SEQRES   3 A  255  HIS THR ASN MSE SER ASP GLY HIS LEU PRO LEU GLY GLU          
SEQRES   4 A  255  VAL VAL ASP LEU PHE GLY LYS HIS GLY VAL ASP VAL VAL          
SEQRES   5 A  255  SER ILE THR ASP HIS ILE VAL ASP ARG ARG THR LEU GLU          
SEQRES   6 A  255  GLN ARG LYS ARG ASN GLY GLU PRO LEU GLY ALA ILE THR          
SEQRES   7 A  255  GLU ASP LYS PHE GLN ASP TYR LEU LYS ARG LEU TRP ARG          
SEQRES   8 A  255  GLU GLN LYS ARG ALA TRP GLU GLU TYR GLY MSE ILE LEU          
SEQRES   9 A  255  ILE PRO GLY VAL GLU ILE THR ASN ASN THR ASP LEU TYR          
SEQRES  10 A  255  HIS ILE VAL ALA VAL ASP VAL LYS GLU TYR VAL ASP PRO          
SEQRES  11 A  255  SER LEU PRO VAL GLU GLU ILE VAL GLU LYS LEU LYS GLU          
SEQRES  12 A  255  GLN ASN ALA LEU VAL ILE ALA ALA HIS PRO ASP ARG LYS          
SEQRES  13 A  255  LYS GLN ASP GLU GLU HIS LEU SER TRP TYR LEU TRP ALA          
SEQRES  14 A  255  ASN MSE GLU ARG PHE LYS ASP THR PHE ASP ALA TRP GLU          
SEQRES  15 A  255  ILE ALA ASN ARG ASP ASP LEU PHE ASN SER VAL GLY VAL          
SEQRES  16 A  255  LYS LYS TYR ARG TYR VAL ALA ASN SER ASP PHE HIS GLU          
SEQRES  17 A  255  LEU TRP HIS VAL TYR SER TRP LYS THR LEU VAL LYS SER          
SEQRES  18 A  255  GLU LYS ASN ILE GLU ALA ILE LYS GLU ALA ILE ARG LYS          
SEQRES  19 A  255  ASN THR ASP VAL ALA ILE TYR LEU MSE ARG LYS ASN ARG          
SEQRES  20 A  255  LEU SER SER LEU SER ASP VAL ILE                              
SEQRES   1 B  255  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 B  255  LYS THR ASP THR GLU TRP LEU LEU CYS ASP PHE HIS VAL          
SEQRES   3 B  255  HIS THR ASN MSE SER ASP GLY HIS LEU PRO LEU GLY GLU          
SEQRES   4 B  255  VAL VAL ASP LEU PHE GLY LYS HIS GLY VAL ASP VAL VAL          
SEQRES   5 B  255  SER ILE THR ASP HIS ILE VAL ASP ARG ARG THR LEU GLU          
SEQRES   6 B  255  GLN ARG LYS ARG ASN GLY GLU PRO LEU GLY ALA ILE THR          
SEQRES   7 B  255  GLU ASP LYS PHE GLN ASP TYR LEU LYS ARG LEU TRP ARG          
SEQRES   8 B  255  GLU GLN LYS ARG ALA TRP GLU GLU TYR GLY MSE ILE LEU          
SEQRES   9 B  255  ILE PRO GLY VAL GLU ILE THR ASN ASN THR ASP LEU TYR          
SEQRES  10 B  255  HIS ILE VAL ALA VAL ASP VAL LYS GLU TYR VAL ASP PRO          
SEQRES  11 B  255  SER LEU PRO VAL GLU GLU ILE VAL GLU LYS LEU LYS GLU          
SEQRES  12 B  255  GLN ASN ALA LEU VAL ILE ALA ALA HIS PRO ASP ARG LYS          
SEQRES  13 B  255  LYS GLN ASP GLU GLU HIS LEU SER TRP TYR LEU TRP ALA          
SEQRES  14 B  255  ASN MSE GLU ARG PHE LYS ASP THR PHE ASP ALA TRP GLU          
SEQRES  15 B  255  ILE ALA ASN ARG ASP ASP LEU PHE ASN SER VAL GLY VAL          
SEQRES  16 B  255  LYS LYS TYR ARG TYR VAL ALA ASN SER ASP PHE HIS GLU          
SEQRES  17 B  255  LEU TRP HIS VAL TYR SER TRP LYS THR LEU VAL LYS SER          
SEQRES  18 B  255  GLU LYS ASN ILE GLU ALA ILE LYS GLU ALA ILE ARG LYS          
SEQRES  19 B  255  ASN THR ASP VAL ALA ILE TYR LEU MSE ARG LYS ASN ARG          
SEQRES  20 B  255  LEU SER SER LEU SER ASP VAL ILE                              
SEQRES   1 C  255  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 C  255  LYS THR ASP THR GLU TRP LEU LEU CYS ASP PHE HIS VAL          
SEQRES   3 C  255  HIS THR ASN MSE SER ASP GLY HIS LEU PRO LEU GLY GLU          
SEQRES   4 C  255  VAL VAL ASP LEU PHE GLY LYS HIS GLY VAL ASP VAL VAL          
SEQRES   5 C  255  SER ILE THR ASP HIS ILE VAL ASP ARG ARG THR LEU GLU          
SEQRES   6 C  255  GLN ARG LYS ARG ASN GLY GLU PRO LEU GLY ALA ILE THR          
SEQRES   7 C  255  GLU ASP LYS PHE GLN ASP TYR LEU LYS ARG LEU TRP ARG          
SEQRES   8 C  255  GLU GLN LYS ARG ALA TRP GLU GLU TYR GLY MSE ILE LEU          
SEQRES   9 C  255  ILE PRO GLY VAL GLU ILE THR ASN ASN THR ASP LEU TYR          
SEQRES  10 C  255  HIS ILE VAL ALA VAL ASP VAL LYS GLU TYR VAL ASP PRO          
SEQRES  11 C  255  SER LEU PRO VAL GLU GLU ILE VAL GLU LYS LEU LYS GLU          
SEQRES  12 C  255  GLN ASN ALA LEU VAL ILE ALA ALA HIS PRO ASP ARG LYS          
SEQRES  13 C  255  LYS GLN ASP GLU GLU HIS LEU SER TRP TYR LEU TRP ALA          
SEQRES  14 C  255  ASN MSE GLU ARG PHE LYS ASP THR PHE ASP ALA TRP GLU          
SEQRES  15 C  255  ILE ALA ASN ARG ASP ASP LEU PHE ASN SER VAL GLY VAL          
SEQRES  16 C  255  LYS LYS TYR ARG TYR VAL ALA ASN SER ASP PHE HIS GLU          
SEQRES  17 C  255  LEU TRP HIS VAL TYR SER TRP LYS THR LEU VAL LYS SER          
SEQRES  18 C  255  GLU LYS ASN ILE GLU ALA ILE LYS GLU ALA ILE ARG LYS          
SEQRES  19 C  255  ASN THR ASP VAL ALA ILE TYR LEU MSE ARG LYS ASN ARG          
SEQRES  20 C  255  LEU SER SER LEU SER ASP VAL ILE                              
SEQRES   1 D  255  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 D  255  LYS THR ASP THR GLU TRP LEU LEU CYS ASP PHE HIS VAL          
SEQRES   3 D  255  HIS THR ASN MSE SER ASP GLY HIS LEU PRO LEU GLY GLU          
SEQRES   4 D  255  VAL VAL ASP LEU PHE GLY LYS HIS GLY VAL ASP VAL VAL          
SEQRES   5 D  255  SER ILE THR ASP HIS ILE VAL ASP ARG ARG THR LEU GLU          
SEQRES   6 D  255  GLN ARG LYS ARG ASN GLY GLU PRO LEU GLY ALA ILE THR          
SEQRES   7 D  255  GLU ASP LYS PHE GLN ASP TYR LEU LYS ARG LEU TRP ARG          
SEQRES   8 D  255  GLU GLN LYS ARG ALA TRP GLU GLU TYR GLY MSE ILE LEU          
SEQRES   9 D  255  ILE PRO GLY VAL GLU ILE THR ASN ASN THR ASP LEU TYR          
SEQRES  10 D  255  HIS ILE VAL ALA VAL ASP VAL LYS GLU TYR VAL ASP PRO          
SEQRES  11 D  255  SER LEU PRO VAL GLU GLU ILE VAL GLU LYS LEU LYS GLU          
SEQRES  12 D  255  GLN ASN ALA LEU VAL ILE ALA ALA HIS PRO ASP ARG LYS          
SEQRES  13 D  255  LYS GLN ASP GLU GLU HIS LEU SER TRP TYR LEU TRP ALA          
SEQRES  14 D  255  ASN MSE GLU ARG PHE LYS ASP THR PHE ASP ALA TRP GLU          
SEQRES  15 D  255  ILE ALA ASN ARG ASP ASP LEU PHE ASN SER VAL GLY VAL          
SEQRES  16 D  255  LYS LYS TYR ARG TYR VAL ALA ASN SER ASP PHE HIS GLU          
SEQRES  17 D  255  LEU TRP HIS VAL TYR SER TRP LYS THR LEU VAL LYS SER          
SEQRES  18 D  255  GLU LYS ASN ILE GLU ALA ILE LYS GLU ALA ILE ARG LYS          
SEQRES  19 D  255  ASN THR ASP VAL ALA ILE TYR LEU MSE ARG LYS ASN ARG          
SEQRES  20 D  255  LEU SER SER LEU SER ASP VAL ILE                              
SEQRES   1 E  255  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 E  255  LYS THR ASP THR GLU TRP LEU LEU CYS ASP PHE HIS VAL          
SEQRES   3 E  255  HIS THR ASN MSE SER ASP GLY HIS LEU PRO LEU GLY GLU          
SEQRES   4 E  255  VAL VAL ASP LEU PHE GLY LYS HIS GLY VAL ASP VAL VAL          
SEQRES   5 E  255  SER ILE THR ASP HIS ILE VAL ASP ARG ARG THR LEU GLU          
SEQRES   6 E  255  GLN ARG LYS ARG ASN GLY GLU PRO LEU GLY ALA ILE THR          
SEQRES   7 E  255  GLU ASP LYS PHE GLN ASP TYR LEU LYS ARG LEU TRP ARG          
SEQRES   8 E  255  GLU GLN LYS ARG ALA TRP GLU GLU TYR GLY MSE ILE LEU          
SEQRES   9 E  255  ILE PRO GLY VAL GLU ILE THR ASN ASN THR ASP LEU TYR          
SEQRES  10 E  255  HIS ILE VAL ALA VAL ASP VAL LYS GLU TYR VAL ASP PRO          
SEQRES  11 E  255  SER LEU PRO VAL GLU GLU ILE VAL GLU LYS LEU LYS GLU          
SEQRES  12 E  255  GLN ASN ALA LEU VAL ILE ALA ALA HIS PRO ASP ARG LYS          
SEQRES  13 E  255  LYS GLN ASP GLU GLU HIS LEU SER TRP TYR LEU TRP ALA          
SEQRES  14 E  255  ASN MSE GLU ARG PHE LYS ASP THR PHE ASP ALA TRP GLU          
SEQRES  15 E  255  ILE ALA ASN ARG ASP ASP LEU PHE ASN SER VAL GLY VAL          
SEQRES  16 E  255  LYS LYS TYR ARG TYR VAL ALA ASN SER ASP PHE HIS GLU          
SEQRES  17 E  255  LEU TRP HIS VAL TYR SER TRP LYS THR LEU VAL LYS SER          
SEQRES  18 E  255  GLU LYS ASN ILE GLU ALA ILE LYS GLU ALA ILE ARG LYS          
SEQRES  19 E  255  ASN THR ASP VAL ALA ILE TYR LEU MSE ARG LYS ASN ARG          
SEQRES  20 E  255  LEU SER SER LEU SER ASP VAL ILE                              
SEQRES   1 F  255  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MSE          
SEQRES   2 F  255  LYS THR ASP THR GLU TRP LEU LEU CYS ASP PHE HIS VAL          
SEQRES   3 F  255  HIS THR ASN MSE SER ASP GLY HIS LEU PRO LEU GLY GLU          
SEQRES   4 F  255  VAL VAL ASP LEU PHE GLY LYS HIS GLY VAL ASP VAL VAL          
SEQRES   5 F  255  SER ILE THR ASP HIS ILE VAL ASP ARG ARG THR LEU GLU          
SEQRES   6 F  255  GLN ARG LYS ARG ASN GLY GLU PRO LEU GLY ALA ILE THR          
SEQRES   7 F  255  GLU ASP LYS PHE GLN ASP TYR LEU LYS ARG LEU TRP ARG          
SEQRES   8 F  255  GLU GLN LYS ARG ALA TRP GLU GLU TYR GLY MSE ILE LEU          
SEQRES   9 F  255  ILE PRO GLY VAL GLU ILE THR ASN ASN THR ASP LEU TYR          
SEQRES  10 F  255  HIS ILE VAL ALA VAL ASP VAL LYS GLU TYR VAL ASP PRO          
SEQRES  11 F  255  SER LEU PRO VAL GLU GLU ILE VAL GLU LYS LEU LYS GLU          
SEQRES  12 F  255  GLN ASN ALA LEU VAL ILE ALA ALA HIS PRO ASP ARG LYS          
SEQRES  13 F  255  LYS GLN ASP GLU GLU HIS LEU SER TRP TYR LEU TRP ALA          
SEQRES  14 F  255  ASN MSE GLU ARG PHE LYS ASP THR PHE ASP ALA TRP GLU          
SEQRES  15 F  255  ILE ALA ASN ARG ASP ASP LEU PHE ASN SER VAL GLY VAL          
SEQRES  16 F  255  LYS LYS TYR ARG TYR VAL ALA ASN SER ASP PHE HIS GLU          
SEQRES  17 F  255  LEU TRP HIS VAL TYR SER TRP LYS THR LEU VAL LYS SER          
SEQRES  18 F  255  GLU LYS ASN ILE GLU ALA ILE LYS GLU ALA ILE ARG LYS          
SEQRES  19 F  255  ASN THR ASP VAL ALA ILE TYR LEU MSE ARG LYS ASN ARG          
SEQRES  20 F  255  LEU SER SER LEU SER ASP VAL ILE                              
HET    MSE  A  18       8                                                       
HET    MSE  A  90       8                                                       
HET    MSE  A 159       8                                                       
HET    MSE  A 231       8                                                       
HET    MSE  B  18       8                                                       
HET    MSE  B  90       8                                                       
HET    MSE  B 159       8                                                       
HET    MSE  B 231       8                                                       
HET    MSE  C  18       8                                                       
HET    MSE  C  90       8                                                       
HET    MSE  C 159       8                                                       
HET    MSE  C 231       8                                                       
HET    MSE  D  18       8                                                       
HET    MSE  D  90       8                                                       
HET    MSE  D 159       8                                                       
HET    MSE  D 231       8                                                       
HET    MSE  E  18       8                                                       
HET    MSE  E  90       8                                                       
HET    MSE  E 159       8                                                       
HET    MSE  E 231       8                                                       
HET    MSE  F  18       8                                                       
HET    MSE  F  90       8                                                       
HET    MSE  F 159       8                                                       
HET    MSE  F 231       8                                                       
HET     ZN  A 405       1                                                       
HET     ZN  A 505       1                                                       
HET     ZN  A 605       1                                                       
HET     ZN  A 705       1                                                       
HET     ZN  B 405       1                                                       
HET     ZN  B 505       1                                                       
HET     ZN  B 605       1                                                       
HET     ZN  B 705       1                                                       
HET     ZN  C 405       1                                                       
HET     ZN  C 505       1                                                       
HET     ZN  C 605       1                                                       
HET     ZN  C 705       1                                                       
HET     ZN  D 405       1                                                       
HET     ZN  D 505       1                                                       
HET     ZN  D 605       1                                                       
HET     ZN  D 705       1                                                       
HET     ZN  E 405       1                                                       
HET     ZN  E 505       1                                                       
HET     ZN  E 605       1                                                       
HET     ZN  E 705       1                                                       
HET     ZN  F 405       1                                                       
HET     ZN  F 505       1                                                       
HET     ZN  F 605       1                                                       
HET     ZN  F 705       1                                                       
HET     CL   1001       1                                                       
HET     CL   1002       1                                                       
HET     CL   1003       1                                                       
HET     CL   1004       1                                                       
HET     CL   1005       1                                                       
HET     CL   1006       1                                                       
HET     CL   1007       1                                                       
HET     CL   1008       1                                                       
HET     CL   1009       1                                                       
HET     CL   1010       1                                                       
HET     CL   1011       1                                                       
HET     CL   1012       1                                                       
HET     CL   1013       1                                                       
HET     CL   1014       1                                                       
HET     CL   1015       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    24(C5 H11 N O2 SE)                                           
FORMUL   7   ZN    24(ZN 2+)                                                    
FORMUL  31   CL    15(CL 1-)                                                    
FORMUL  46  HOH   *212(H2 O)                                                    
CRYST1  111.307  111.307  383.222  90.00  90.00 120.00 H 3          54          
ATOM   9099  N   THR F   5     -41.062  45.640  42.366  1.00 47.45           N  
ATOM   9100  CA  THR F   5     -41.204  47.031  42.908  1.00 47.48           C  
ATOM   9101  C   THR F   5     -40.073  47.992  42.494  1.00 46.56           C  
ATOM   9102  O   THR F   5     -39.015  48.050  43.119  1.00 45.89           O  
ATOM   9103  CB  THR F   5     -41.291  47.036  44.440  1.00 46.54           C  
ATOM   9104  OG1 THR F   5     -40.114  46.445  44.979  1.00 50.64           O  
ATOM   9105  CG2 THR F   5     -42.496  46.263  44.924  1.00 48.01           C  
ATOM   9106  N   GLU F   6     -40.327  48.735  41.423  1.00 45.32           N  
ATOM   9107  CA  GLU F   6     -39.580  49.934  41.092  1.00 42.14           C  
ATOM   9108  C   GLU F   6     -40.466  51.111  41.507  1.00 37.93           C  
ATOM   9109  O   GLU F   6     -41.625  50.913  41.885  1.00 37.90           O  
ATOM   9110  CB  GLU F   6     -39.268  49.969  39.594  1.00 42.27           C  
ATOM   9111  N   TRP F   7     -39.920  52.326  41.457  1.00 32.74           N  
ATOM   9112  CA  TRP F   7     -40.660  53.538  41.772  1.00 28.89           C  
ATOM   9113  C   TRP F   7     -41.243  54.008  40.475  1.00 27.77           C  
ATOM   9114  O   TRP F   7     -40.537  54.138  39.475  1.00 26.15           O  
ATOM   9115  CB  TRP F   7     -39.784  54.631  42.373  1.00 27.71           C  
ATOM   9116  CG  TRP F   7     -39.335  54.359  43.765  1.00 27.60           C  
ATOM   9117  CD1 TRP F   7     -38.267  53.583  44.147  1.00 25.65           C  
ATOM   9118  CD2 TRP F   7     -39.906  54.880  44.975  1.00 18.37           C  
ATOM   9119  NE1 TRP F   7     -38.161  53.570  45.516  1.00 26.59           N  
ATOM   9120  CE2 TRP F   7     -39.142  54.367  46.052  1.00 25.91           C  
ATOM   9121  CE3 TRP F   7     -40.984  55.729  45.253  1.00 23.33           C  
ATOM   9122  CZ2 TRP F   7     -39.433  54.663  47.391  1.00 23.94           C  
ATOM   9123  CZ3 TRP F   7     -41.285  56.014  46.577  1.00 23.44           C  
ATOM   9124  CH2 TRP F   7     -40.508  55.479  47.632  1.00 26.56           C  
ATOM   9125  N   LEU F   8     -42.545  54.238  40.505  1.00 25.78           N  
ATOM   9126  CA  LEU F   8     -43.315  54.564  39.339  1.00 25.41           C  
ATOM   9127  C   LEU F   8     -43.706  56.044  39.379  1.00 25.35           C  
ATOM   9128  O   LEU F   8     -44.103  56.569  40.428  1.00 21.43           O  
ATOM   9129  CB  LEU F   8     -44.577  53.693  39.310  1.00 26.37           C  
ATOM   9130  CG  LEU F   8     -44.372  52.174  39.267  1.00 28.52           C  
ATOM   9131  CD1 LEU F   8     -45.707  51.437  39.400  1.00 24.19           C  
ATOM   9132  CD2 LEU F   8     -43.620  51.734  37.990  1.00 27.25           C  
ATOM   9133  N   LEU F   9     -43.570  56.703  38.232  1.00 24.51           N  
ATOM   9134  CA  LEU F   9     -44.002  58.067  38.057  1.00 25.71           C  
ATOM   9135  C   LEU F   9     -45.488  58.090  37.628  1.00 25.05           C  
ATOM   9136  O   LEU F   9     -45.871  57.498  36.612  1.00 22.86           O  
ATOM   9137  CB  LEU F   9     -43.107  58.766  37.037  1.00 26.04           C  
ATOM   9138  CG  LEU F   9     -43.346  60.277  36.875  1.00 31.16           C  
ATOM   9139  CD1 LEU F   9     -43.109  61.084  38.170  1.00 29.74           C  
ATOM   9140  CD2 LEU F   9     -42.468  60.781  35.769  1.00 28.26           C  
ATOM   9141  N   CYS F  10     -46.309  58.753  38.436  1.00 24.66           N  
ATOM   9142  CA  CYS F  10     -47.760  58.658  38.340  1.00 27.23           C  
ATOM   9143  C   CYS F  10     -48.418  60.015  38.356  1.00 26.05           C  
ATOM   9144  O   CYS F  10     -48.048  60.873  39.139  1.00 23.55           O  
ATOM   9145  CB  CYS F  10     -48.362  57.867  39.538  1.00 28.14           C  
ATOM   9146  SG  CYS F  10     -47.674  56.260  39.849  1.00 28.65           S  
ATOM   9147  N   ASP F  11     -49.450  60.165  37.531  1.00 28.57           N  
ATOM   9148  CA  ASP F  11     -50.323  61.343  37.568  1.00 29.17           C  
ATOM   9149  C   ASP F  11     -51.768  60.855  37.636  1.00 28.59           C  
ATOM   9150  O   ASP F  11     -52.249  60.188  36.722  1.00 25.97           O  
ATOM   9151  CB  ASP F  11     -50.095  62.237  36.342  1.00 29.57           C  
ATOM   9152  CG  ASP F  11     -50.508  63.675  36.580  1.00 28.57           C  
ATOM   9153  OD1 ASP F  11     -51.359  63.918  37.464  1.00 27.39           O  
ATOM   9154  OD2 ASP F  11     -49.980  64.557  35.865  1.00 27.36           O  
ATOM   9155  N   PHE F  12     -52.453  61.183  38.730  1.00 28.18           N  
ATOM   9156  CA  PHE F  12     -53.757  60.603  38.970  1.00 28.35           C  
ATOM   9157  C   PHE F  12     -54.923  61.516  38.680  1.00 27.36           C  
ATOM   9158  O   PHE F  12     -56.013  61.183  39.045  1.00 27.32           O  
ATOM   9159  CB  PHE F  12     -53.869  60.110  40.407  1.00 29.27           C  
ATOM   9160  CG  PHE F  12     -52.983  58.963  40.716  1.00 30.13           C  
ATOM   9161  CD1 PHE F  12     -53.208  57.716  40.122  1.00 26.76           C  
ATOM   9162  CD2 PHE F  12     -51.935  59.110  41.626  1.00 29.59           C  
ATOM   9163  CE1 PHE F  12     -52.392  56.641  40.418  1.00 28.74           C  
ATOM   9164  CE2 PHE F  12     -51.105  58.036  41.935  1.00 27.98           C  
ATOM   9165  CZ  PHE F  12     -51.337  56.786  41.331  1.00 29.51           C  
ATOM   9166  N   HIS F  13     -54.706  62.623  37.971  1.00 29.52           N  
ATOM   9167  CA  HIS F  13     -55.698  63.703  37.887  1.00 28.19           C  
ATOM   9168  C   HIS F  13     -55.464  64.519  36.588  1.00 28.04           C  
ATOM   9169  O   HIS F  13     -54.743  65.510  36.568  1.00 25.45           O  
ATOM   9170  CB  HIS F  13     -55.618  64.528  39.190  1.00 25.79           C  
ATOM   9171  CG  HIS F  13     -56.597  65.654  39.299  1.00 25.01           C  
ATOM   9172  ND1 HIS F  13     -56.562  66.552  40.342  1.00 25.75           N  
ATOM   9173  CD2 HIS F  13     -57.604  66.056  38.497  1.00 28.22           C  
ATOM   9174  CE1 HIS F  13     -57.523  67.440  40.196  1.00 25.29           C  
ATOM   9175  NE2 HIS F  13     -58.168  67.168  39.081  1.00 28.36           N  
ATOM   9176  N   VAL F  14     -56.103  64.062  35.508  1.00 28.62           N  
ATOM   9177  CA  VAL F  14     -55.825  64.545  34.154  1.00 28.47           C  
ATOM   9178  C   VAL F  14     -57.154  64.659  33.405  1.00 27.76           C  
ATOM   9179  O   VAL F  14     -57.999  63.755  33.501  1.00 25.61           O  
ATOM   9180  CB  VAL F  14     -54.896  63.552  33.407  1.00 28.44           C  
ATOM   9181  CG1 VAL F  14     -54.583  64.024  32.004  1.00 27.45           C  
ATOM   9182  CG2 VAL F  14     -53.614  63.290  34.216  1.00 27.58           C  
ATOM   9183  N   HIS F  15     -57.317  65.765  32.673  1.00 25.14           N  
ATOM   9184  CA  HIS F  15     -58.562  66.090  31.967  1.00 26.14           C  
ATOM   9185  C   HIS F  15     -58.330  66.197  30.425  1.00 25.51           C  
ATOM   9186  O   HIS F  15     -57.234  66.574  29.960  1.00 21.91           O  
ATOM   9187  CB  HIS F  15     -59.189  67.421  32.493  1.00 26.43           C  
ATOM   9188  CG  HIS F  15     -59.479  67.432  33.962  1.00 22.96           C  
ATOM   9189  ND1 HIS F  15     -60.599  66.850  34.497  1.00 30.04           N  
ATOM   9190  CD2 HIS F  15     -58.789  67.939  35.009  1.00 29.12           C  
ATOM   9191  CE1 HIS F  15     -60.592  66.992  35.807  1.00 31.06           C  
ATOM   9192  NE2 HIS F  15     -59.502  67.651  36.146  1.00 31.00           N  
ATOM   9193  N   THR F  16     -59.387  65.890  29.666  1.00 24.88           N  
ATOM   9194  CA  THR F  16     -59.387  65.943  28.210  1.00 24.85           C  
ATOM   9195  C   THR F  16     -60.568  66.771  27.773  1.00 25.34           C  
ATOM   9196  O   THR F  16     -61.411  67.127  28.590  1.00 23.47           O  
ATOM   9197  CB  THR F  16     -59.613  64.575  27.577  1.00 25.37           C  
ATOM   9198  OG1 THR F  16     -60.942  64.141  27.888  1.00 22.75           O  
ATOM   9199  CG2 THR F  16     -58.589  63.519  28.041  1.00 25.14           C  
ATOM   9200  N   ASN F  17     -60.655  67.043  26.474  1.00 25.33           N  
ATOM   9201  CA  ASN F  17     -61.786  67.791  25.925  1.00 25.04           C  
ATOM   9202  C   ASN F  17     -63.121  67.063  26.023  1.00 25.14           C  
ATOM   9203  O   ASN F  17     -64.112  67.600  25.635  1.00 26.19           O  
ATOM   9204  CB  ASN F  17     -61.524  68.258  24.475  1.00 21.56           C  
ATOM   9205  CG  ASN F  17     -61.512  67.109  23.451  1.00 19.94           C  
ATOM   9206  OD1 ASN F  17     -61.724  65.954  23.779  1.00 19.10           O  
ATOM   9207  ND2 ASN F  17     -61.249  67.446  22.195  1.00 18.78           N  
HETATM 9208  N   MSE F  18     -63.158  65.851  26.547  1.00 29.67           N  
HETATM 9209  CA  MSE F  18     -64.437  65.191  26.801  1.00 32.20           C  
HETATM 9210  C   MSE F  18     -65.163  65.836  27.953  1.00 28.76           C  
HETATM 9211  O   MSE F  18     -66.390  65.764  28.009  1.00 25.10           O  
HETATM 9212  CB  MSE F  18     -64.252  63.712  27.065  1.00 31.18           C  
HETATM 9213  CG  MSE F  18     -63.829  62.962  25.811  1.00 37.66           C  
HETATM 9214 SE   MSE F  18     -63.612  61.029  26.050  1.00 45.84          SE  
HETATM 9215  CE  MSE F  18     -62.287  60.900  27.525  1.00 46.40           C  
ATOM   9216  N   SER F  19     -64.407  66.468  28.861  1.00 28.56           N  
ATOM   9217  CA  SER F  19     -64.990  67.362  29.860  1.00 25.30           C  
ATOM   9218  C   SER F  19     -64.533  68.785  29.623  1.00 23.73           C  
ATOM   9219  O   SER F  19     -65.047  69.416  28.741  1.00 23.26           O  
ATOM   9220  CB  SER F  19     -64.815  66.857  31.309  1.00 24.25           C  
ATOM   9221  OG  SER F  19     -63.503  66.958  31.840  1.00 23.94           O  
ATOM   9222  N   ASP F  20     -63.618  69.336  30.406  1.00 27.21           N  
ATOM   9223  CA  ASP F  20     -63.249  70.750  30.224  1.00 24.66           C  
ATOM   9224  C   ASP F  20     -61.782  70.960  29.926  1.00 24.59           C  
ATOM   9225  O   ASP F  20     -61.325  72.082  29.922  1.00 24.13           O  
ATOM   9226  CB  ASP F  20     -63.660  71.577  31.435  1.00 24.89           C  
ATOM   9227  CG  ASP F  20     -62.857  71.254  32.695  1.00 25.93           C  
ATOM   9228  OD1 ASP F  20     -62.229  70.203  32.808  1.00 23.46           O  
ATOM   9229  OD2 ASP F  20     -62.886  72.071  33.611  1.00 30.93           O  
ATOM   9230  N   GLY F  21     -61.052  69.879  29.673  1.00 23.59           N  
ATOM   9231  CA  GLY F  21     -59.698  69.974  29.182  1.00 24.03           C  
ATOM   9232  C   GLY F  21     -59.637  70.523  27.769  1.00 24.36           C  
ATOM   9233  O   GLY F  21     -60.610  70.491  27.024  1.00 22.12           O  
ATOM   9234  N   HIS F  22     -58.459  71.011  27.397  1.00 25.11           N  
ATOM   9235  CA  HIS F  22     -58.266  71.654  26.116  1.00 22.72           C  
ATOM   9236  C   HIS F  22     -57.987  70.668  24.988  1.00 23.65           C  
ATOM   9237  O   HIS F  22     -58.251  70.988  23.815  1.00 22.68           O  
ATOM   9238  CB  HIS F  22     -57.116  72.651  26.215  1.00 21.83           C  
ATOM   9239  CG  HIS F  22     -57.044  73.600  25.058  1.00 25.18           C  
ATOM   9240  ND1 HIS F  22     -57.936  74.631  24.888  1.00 26.81           N  
ATOM   9241  CD2 HIS F  22     -56.196  73.662  24.008  1.00 23.16           C  
ATOM   9242  CE1 HIS F  22     -57.636  75.291  23.788  1.00 26.97           C  
ATOM   9243  NE2 HIS F  22     -56.584  74.724  23.237  1.00 27.55           N  
ATOM   9244  N   LEU F  23     -57.434  69.496  25.330  1.00 22.60           N  
ATOM   9245  CA  LEU F  23     -56.952  68.539  24.328  1.00 24.04           C  
ATOM   9246  C   LEU F  23     -57.779  67.271  24.194  1.00 23.88           C  
ATOM   9247  O   LEU F  23     -58.390  66.813  25.164  1.00 25.47           O  
ATOM   9248  CB  LEU F  23     -55.520  68.110  24.642  1.00 23.71           C  
ATOM   9249  CG  LEU F  23     -54.481  69.209  24.774  1.00 23.88           C  
ATOM   9250  CD1 LEU F  23     -53.203  68.567  25.313  1.00 26.15           C  
ATOM   9251  CD2 LEU F  23     -54.261  69.929  23.452  1.00 20.18           C  
ATOM   9252  N   PRO F  24     -57.778  66.692  22.984  1.00 24.52           N  
ATOM   9253  CA  PRO F  24     -58.332  65.375  22.688  1.00 24.57           C  
ATOM   9254  C   PRO F  24     -57.613  64.311  23.461  1.00 25.88           C  
ATOM   9255  O   PRO F  24     -56.411  64.451  23.692  1.00 24.78           O  
ATOM   9256  CB  PRO F  24     -58.031  65.157  21.212  1.00 24.00           C  
ATOM   9257  CG  PRO F  24     -57.464  66.371  20.694  1.00 24.05           C  
ATOM   9258  CD  PRO F  24     -57.220  67.345  21.791  1.00 23.84           C  
ATOM   9259  N   LEU F  25     -58.350  63.250  23.817  1.00 26.41           N  
ATOM   9260  CA  LEU F  25     -57.824  62.111  24.572  1.00 27.02           C  
ATOM   9261  C   LEU F  25     -56.510  61.548  24.038  1.00 26.78           C  
ATOM   9262  O   LEU F  25     -55.586  61.270  24.812  1.00 25.21           O  
ATOM   9263  CB  LEU F  25     -58.856  60.987  24.553  1.00 28.17           C  
ATOM   9264  CG  LEU F  25     -58.505  59.705  25.303  1.00 25.83           C  
ATOM   9265  CD1 LEU F  25     -58.298  60.004  26.788  1.00 30.54           C  
ATOM   9266  CD2 LEU F  25     -59.595  58.675  25.100  1.00 26.57           C  
ATOM   9267  N   GLY F  26     -56.455  61.351  22.720  1.00 26.42           N  
ATOM   9268  CA  GLY F  26     -55.316  60.710  22.082  1.00 26.45           C  
ATOM   9269  C   GLY F  26     -54.037  61.499  22.292  1.00 27.31           C  
ATOM   9270  O   GLY F  26     -52.973  60.939  22.594  1.00 26.14           O  
ATOM   9271  N   GLU F  27     -54.158  62.817  22.159  1.00 27.13           N  
ATOM   9272  CA  GLU F  27     -53.029  63.712  22.307  1.00 26.51           C  
ATOM   9273  C   GLU F  27     -52.558  63.803  23.744  1.00 24.09           C  
ATOM   9274  O   GLU F  27     -51.370  63.811  24.002  1.00 21.87           O  
ATOM   9275  CB  GLU F  27     -53.376  65.075  21.703  1.00 28.50           C  
ATOM   9276  CG  GLU F  27     -53.108  65.072  20.209  1.00 33.15           C  
ATOM   9277  CD  GLU F  27     -53.761  66.199  19.454  1.00 40.08           C  
ATOM   9278  OE1 GLU F  27     -54.134  67.214  20.091  1.00 39.83           O  
ATOM   9279  OE2 GLU F  27     -53.881  66.055  18.208  1.00 41.80           O  
ATOM   9280  N   VAL F  28     -53.489  63.803  24.685  1.00 25.51           N  
ATOM   9281  CA  VAL F  28     -53.158  63.754  26.104  1.00 24.53           C  
ATOM   9282  C   VAL F  28     -52.394  62.467  26.421  1.00 27.34           C  
ATOM   9283  O   VAL F  28     -51.322  62.496  27.037  1.00 27.79           O  
ATOM   9284  CB  VAL F  28     -54.429  63.842  26.958  1.00 25.60           C  
ATOM   9285  CG1 VAL F  28     -54.138  63.579  28.469  1.00 23.72           C  
ATOM   9286  CG2 VAL F  28     -55.104  65.178  26.754  1.00 23.80           C  
ATOM   9287  N   VAL F  29     -52.935  61.331  25.992  1.00 28.60           N  
ATOM   9288  CA  VAL F  29     -52.253  60.050  26.192  1.00 28.47           C  
ATOM   9289  C   VAL F  29     -50.850  60.034  25.578  1.00 26.81           C  
ATOM   9290  O   VAL F  29     -49.923  59.566  26.218  1.00 24.63           O  
ATOM   9291  CB  VAL F  29     -53.101  58.859  25.663  1.00 28.96           C  
ATOM   9292  CG1 VAL F  29     -52.258  57.567  25.524  1.00 29.35           C  
ATOM   9293  CG2 VAL F  29     -54.276  58.621  26.589  1.00 30.84           C  
ATOM   9294  N   ASP F  30     -50.714  60.521  24.348  1.00 25.49           N  
ATOM   9295  CA  ASP F  30     -49.412  60.617  23.708  1.00 26.80           C  
ATOM   9296  C   ASP F  30     -48.470  61.525  24.508  1.00 27.06           C  
ATOM   9297  O   ASP F  30     -47.332  61.171  24.785  1.00 26.94           O  
ATOM   9298  CB  ASP F  30     -49.559  61.125  22.262  1.00 27.98           C  
ATOM   9299  CG  ASP F  30     -50.180  60.070  21.317  1.00 30.56           C  
ATOM   9300  OD1 ASP F  30     -49.928  58.877  21.519  1.00 31.98           O  
ATOM   9301  OD2 ASP F  30     -50.915  60.421  20.370  1.00 41.53           O  
ATOM   9302  N   LEU F  31     -48.972  62.688  24.903  1.00 27.35           N  
ATOM   9303  CA  LEU F  31     -48.226  63.617  25.740  1.00 27.68           C  
ATOM   9304  C   LEU F  31     -47.575  62.968  26.970  1.00 26.57           C  
ATOM   9305  O   LEU F  31     -46.362  63.062  27.166  1.00 25.03           O  
ATOM   9306  CB  LEU F  31     -49.147  64.748  26.215  1.00 28.77           C  
ATOM   9307  CG  LEU F  31     -48.361  65.940  26.764  1.00 33.18           C  
ATOM   9308  CD1 LEU F  31     -47.414  66.505  25.668  1.00 29.20           C  
ATOM   9309  CD2 LEU F  31     -49.317  66.981  27.261  1.00 32.24           C  
ATOM   9310  N   PHE F  32     -48.402  62.334  27.794  1.00 26.14           N  
ATOM   9311  CA  PHE F  32     -47.944  61.662  28.999  1.00 26.01           C  
ATOM   9312  C   PHE F  32     -47.037  60.488  28.681  1.00 26.95           C  
ATOM   9313  O   PHE F  32     -46.004  60.299  29.332  1.00 27.27           O  
ATOM   9314  CB  PHE F  32     -49.136  61.236  29.856  1.00 24.23           C  
ATOM   9315  CG  PHE F  32     -49.691  62.361  30.673  1.00 28.56           C  
ATOM   9316  CD1 PHE F  32     -50.538  63.320  30.094  1.00 30.13           C  
ATOM   9317  CD2 PHE F  32     -49.323  62.512  32.005  1.00 24.94           C  
ATOM   9318  CE1 PHE F  32     -51.022  64.397  30.844  1.00 28.67           C  
ATOM   9319  CE2 PHE F  32     -49.807  63.576  32.767  1.00 29.55           C  
ATOM   9320  CZ  PHE F  32     -50.643  64.523  32.193  1.00 29.16           C  
ATOM   9321  N   GLY F  33     -47.419  59.710  27.677  1.00 26.98           N  
ATOM   9322  CA  GLY F  33     -46.622  58.584  27.257  1.00 29.03           C  
ATOM   9323  C   GLY F  33     -45.220  58.977  26.841  1.00 28.33           C  
ATOM   9324  O   GLY F  33     -44.251  58.432  27.328  1.00 27.43           O  
ATOM   9325  N   LYS F  34     -45.119  59.946  25.953  1.00 30.06           N  
ATOM   9326  CA  LYS F  34     -43.816  60.400  25.476  1.00 30.80           C  
ATOM   9327  C   LYS F  34     -42.977  61.065  26.570  1.00 29.52           C  
ATOM   9328  O   LYS F  34     -41.764  61.073  26.484  1.00 27.11           O  
ATOM   9329  CB  LYS F  34     -43.983  61.347  24.297  1.00 31.08           C  
ATOM   9330  CG  LYS F  34     -44.531  60.680  23.045  1.00 34.34           C  
ATOM   9331  CD  LYS F  34     -44.785  61.714  21.958  1.00 37.15           C  
ATOM   9332  CE  LYS F  34     -45.509  61.110  20.765  1.00 45.35           C  
ATOM   9333  NZ  LYS F  34     -46.202  62.129  19.881  1.00 43.67           N  
ATOM   9334  N   HIS F  35     -43.619  61.603  27.604  1.00 29.07           N  
ATOM   9335  CA  HIS F  35     -42.880  62.195  28.708  1.00 29.49           C  
ATOM   9336  C   HIS F  35     -42.475  61.169  29.761  1.00 30.70           C  
ATOM   9337  O   HIS F  35     -41.916  61.535  30.782  1.00 32.09           O  
ATOM   9338  CB  HIS F  35     -43.663  63.353  29.332  1.00 29.63           C  
ATOM   9339  CG  HIS F  35     -43.448  64.648  28.624  1.00 32.35           C  
ATOM   9340  ND1 HIS F  35     -44.216  65.048  27.552  1.00 29.76           N  
ATOM   9341  CD2 HIS F  35     -42.509  65.605  28.796  1.00 34.87           C  
ATOM   9342  CE1 HIS F  35     -43.777  66.211  27.114  1.00 36.91           C  
ATOM   9343  NE2 HIS F  35     -42.732  66.563  27.841  1.00 35.02           N  
ATOM   9344  N   GLY F  36     -42.758  59.894  29.514  1.00 30.29           N  
ATOM   9345  CA  GLY F  36     -42.267  58.827  30.352  1.00 30.12           C  
ATOM   9346  C   GLY F  36     -42.987  58.681  31.672  1.00 31.38           C  
ATOM   9347  O   GLY F  36     -42.408  58.160  32.624  1.00 32.19           O  
ATOM   9348  N   VAL F  37     -44.237  59.144  31.739  1.00 31.59           N  
ATOM   9349  CA  VAL F  37     -45.121  58.829  32.881  1.00 30.47           C  
ATOM   9350  C   VAL F  37     -45.497  57.331  32.841  1.00 29.47           C  
ATOM   9351  O   VAL F  37     -45.771  56.785  31.791  1.00 28.70           O  
ATOM   9352  CB  VAL F  37     -46.364  59.719  32.910  1.00 28.33           C  
ATOM   9353  CG1 VAL F  37     -47.304  59.316  34.032  1.00 33.75           C  
ATOM   9354  CG2 VAL F  37     -45.953  61.135  33.096  1.00 30.34           C  
ATOM   9355  N   ASP F  38     -45.438  56.674  33.996  1.00 28.48           N  
ATOM   9356  CA  ASP F  38     -45.659  55.243  34.085  1.00 26.95           C  
ATOM   9357  C   ASP F  38     -47.129  54.878  34.220  1.00 25.98           C  
ATOM   9358  O   ASP F  38     -47.571  53.845  33.720  1.00 24.34           O  
ATOM   9359  CB  ASP F  38     -44.895  54.696  35.287  1.00 28.84           C  
ATOM   9360  CG  ASP F  38     -43.389  54.763  35.105  1.00 27.26           C  
ATOM   9361  OD1 ASP F  38     -42.871  53.990  34.301  1.00 33.15           O  
ATOM   9362  OD2 ASP F  38     -42.726  55.554  35.789  1.00 26.88           O  
ATOM   9363  N   VAL F  39     -47.861  55.742  34.929  1.00 25.23           N  
ATOM   9364  CA  VAL F  39     -49.210  55.534  35.319  1.00 24.06           C  
ATOM   9365  C   VAL F  39     -49.978  56.856  35.220  1.00 24.85           C  
ATOM   9366  O   VAL F  39     -49.592  57.844  35.819  1.00 23.71           O  
ATOM   9367  CB  VAL F  39     -49.285  55.075  36.783  1.00 24.00           C  
ATOM   9368  CG1 VAL F  39     -50.726  54.789  37.162  1.00 26.11           C  
ATOM   9369  CG2 VAL F  39     -48.446  53.876  36.994  1.00 25.39           C  
ATOM   9370  N   VAL F  40     -51.089  56.845  34.491  1.00 25.29           N  
ATOM   9371  CA  VAL F  40     -51.916  58.017  34.315  1.00 26.82           C  
ATOM   9372  C   VAL F  40     -53.367  57.609  34.510  1.00 24.99           C  
ATOM   9373  O   VAL F  40     -53.758  56.563  34.057  1.00 26.40           O  
ATOM   9374  CB  VAL F  40     -51.693  58.681  32.883  1.00 28.11           C  
ATOM   9375  CG1 VAL F  40     -52.153  57.758  31.760  1.00 30.21           C  
ATOM   9376  CG2 VAL F  40     -52.428  59.997  32.777  1.00 27.12           C  
ATOM   9377  N   SER F  41     -54.150  58.425  35.198  1.00 25.12           N  
ATOM   9378  CA  SER F  41     -55.599  58.236  35.266  1.00 25.25           C  
ATOM   9379  C   SER F  41     -56.262  59.389  34.557  1.00 24.78           C  
ATOM   9380  O   SER F  41     -55.957  60.521  34.841  1.00 25.03           O  
ATOM   9381  CB  SER F  41     -56.104  58.168  36.723  1.00 24.26           C  
ATOM   9382  OG  SER F  41     -57.408  57.601  36.769  1.00 22.16           O  
ATOM   9383  N   ILE F  42     -57.129  59.102  33.604  1.00 25.17           N  
ATOM   9384  CA  ILE F  42     -57.922  60.134  32.981  1.00 26.72           C  
ATOM   9385  C   ILE F  42     -59.147  60.332  33.836  1.00 26.61           C  
ATOM   9386  O   ILE F  42     -59.930  59.383  34.030  1.00 26.74           O  
ATOM   9387  CB  ILE F  42     -58.314  59.769  31.556  1.00 26.26           C  
ATOM   9388  CG1 ILE F  42     -57.053  59.509  30.699  1.00 23.22           C  
ATOM   9389  CG2 ILE F  42     -59.220  60.828  30.974  1.00 27.49           C  
ATOM   9390  CD1 ILE F  42     -56.064  60.671  30.604  1.00 28.02           C  
ATOM   9391  N   THR F  43     -59.286  61.555  34.367  1.00 27.33           N  
ATOM   9392  CA  THR F  43     -60.292  61.895  35.389  1.00 27.32           C  
ATOM   9393  C   THR F  43     -61.147  63.073  34.965  1.00 28.59           C  
ATOM   9394  O   THR F  43     -61.126  64.145  35.581  1.00 29.64           O  
ATOM   9395  CB  THR F  43     -59.659  62.220  36.739  1.00 27.80           C  
ATOM   9396  OG1 THR F  43     -58.762  63.322  36.585  1.00 26.86           O  
ATOM   9397  CG2 THR F  43     -58.916  61.022  37.310  1.00 25.78           C  
ATOM   9398  N   ASP F  44     -61.900  62.878  33.892  1.00 27.79           N  
ATOM   9399  CA  ASP F  44     -62.811  63.910  33.446  1.00 27.23           C  
ATOM   9400  C   ASP F  44     -63.970  64.077  34.407  1.00 26.51           C  
ATOM   9401  O   ASP F  44     -64.287  63.182  35.189  1.00 25.14           O  
ATOM   9402  CB  ASP F  44     -63.301  63.618  32.039  1.00 26.63           C  
ATOM   9403  CG  ASP F  44     -62.283  64.001  30.986  1.00 25.65           C  
ATOM   9404  OD1 ASP F  44     -61.759  65.135  31.027  1.00 23.02           O  
ATOM   9405  OD2 ASP F  44     -62.018  63.172  30.109  1.00 21.11           O  
ATOM   9406  N   HIS F  45     -64.588  65.250  34.346  1.00 27.30           N  
ATOM   9407  CA  HIS F  45     -65.557  65.664  35.343  1.00 26.72           C  
ATOM   9408  C   HIS F  45     -66.910  65.038  35.105  1.00 27.00           C  
ATOM   9409  O   HIS F  45     -67.386  64.975  33.975  1.00 26.90           O  
ATOM   9410  CB  HIS F  45     -65.785  67.175  35.314  1.00 25.80           C  
ATOM   9411  CG  HIS F  45     -64.592  67.999  35.671  1.00 29.51           C  
ATOM   9412  ND1 HIS F  45     -64.265  68.323  36.970  1.00 28.67           N  
ATOM   9413  CD2 HIS F  45     -63.696  68.641  34.885  1.00 24.36           C  
ATOM   9414  CE1 HIS F  45     -63.202  69.106  36.968  1.00 27.28           C  
ATOM   9415  NE2 HIS F  45     -62.841  69.316  35.715  1.00 28.35           N  
ATOM   9416  N   ILE F  46     -67.539  64.613  36.190  1.00 26.64           N  
ATOM   9417  CA  ILE F  46     -68.982  64.511  36.231  1.00 28.15           C  
ATOM   9418  C   ILE F  46     -69.408  65.537  37.281  1.00 27.87           C  
ATOM   9419  O   ILE F  46     -68.733  65.722  38.282  1.00 27.71           O  
ATOM   9420  CB  ILE F  46     -69.483  63.055  36.512  1.00 28.94           C  
ATOM   9421  CG1 ILE F  46     -69.033  62.557  37.892  1.00 28.88           C  
ATOM   9422  CG2 ILE F  46     -69.030  62.097  35.376  1.00 26.98           C  
ATOM   9423  CD1 ILE F  46     -69.697  61.263  38.320  1.00 27.54           C  
ATOM   9424  N   VAL F  47     -70.520  66.205  37.041  1.00 27.94           N  
ATOM   9425  CA  VAL F  47     -70.856  67.441  37.739  1.00 29.37           C  
ATOM   9426  C   VAL F  47     -72.249  67.318  38.330  1.00 28.72           C  
ATOM   9427  O   VAL F  47     -73.109  66.664  37.734  1.00 28.60           O  
ATOM   9428  CB  VAL F  47     -70.788  68.609  36.715  1.00 29.70           C  
ATOM   9429  CG1 VAL F  47     -71.600  69.788  37.115  1.00 32.68           C  
ATOM   9430  CG2 VAL F  47     -69.373  68.992  36.474  1.00 31.43           C  
ATOM   9431  N   ASP F  48     -72.488  67.950  39.479  1.00 28.76           N  
ATOM   9432  CA  ASP F  48     -73.812  67.893  40.101  1.00 29.33           C  
ATOM   9433  C   ASP F  48     -74.854  68.487  39.164  1.00 29.40           C  
ATOM   9434  O   ASP F  48     -74.557  69.384  38.389  1.00 28.86           O  
ATOM   9435  CB  ASP F  48     -73.839  68.555  41.487  1.00 29.11           C  
ATOM   9436  CG  ASP F  48     -73.580  70.044  41.445  1.00 28.63           C  
ATOM   9437  OD1 ASP F  48     -72.421  70.436  41.282  1.00 22.16           O  
ATOM   9438  OD2 ASP F  48     -74.541  70.829  41.619  1.00 32.85           O  
ATOM   9439  N   ARG F  49     -76.072  67.965  39.223  1.00 31.18           N  
ATOM   9440  CA  ARG F  49     -77.095  68.329  38.244  1.00 32.58           C  
ATOM   9441  C   ARG F  49     -77.482  69.805  38.289  1.00 32.53           C  
ATOM   9442  O   ARG F  49     -77.748  70.413  37.249  1.00 32.05           O  
ATOM   9443  CB  ARG F  49     -78.342  67.465  38.408  1.00 33.54           C  
ATOM   9444  CG  ARG F  49     -79.319  67.611  37.234  1.00 44.02           C  
ATOM   9445  CD  ARG F  49     -80.115  66.332  36.935  1.00 54.88           C  
ATOM   9446  NE  ARG F  49     -79.265  65.190  36.558  1.00 57.38           N  
ATOM   9447  CZ  ARG F  49     -78.912  64.188  37.367  1.00 60.04           C  
ATOM   9448  NH1 ARG F  49     -79.310  64.157  38.639  1.00 61.52           N  
ATOM   9449  NH2 ARG F  49     -78.143  63.204  36.900  1.00 61.29           N  
ATOM   9450  N   ARG F  50     -77.517  70.372  39.491  1.00 32.55           N  
ATOM   9451  CA  ARG F  50     -77.798  71.792  39.668  1.00 32.90           C  
ATOM   9452  C   ARG F  50     -76.819  72.659  38.833  1.00 31.67           C  
ATOM   9453  O   ARG F  50     -77.240  73.547  38.091  1.00 29.32           O  
ATOM   9454  CB  ARG F  50     -77.720  72.128  41.161  1.00 32.26           C  
ATOM   9455  CG  ARG F  50     -78.217  73.503  41.537  1.00 37.06           C  
ATOM   9456  CD  ARG F  50     -78.540  73.616  43.031  1.00 37.81           C  
ATOM   9457  N   THR F  51     -75.522  72.373  38.939  1.00 31.08           N  
ATOM   9458  CA  THR F  51     -74.498  73.079  38.161  1.00 32.01           C  
ATOM   9459  C   THR F  51     -74.672  72.869  36.647  1.00 32.30           C  
ATOM   9460  O   THR F  51     -74.515  73.810  35.857  1.00 28.58           O  
ATOM   9461  CB  THR F  51     -73.099  72.611  38.572  1.00 32.24           C  
ATOM   9462  OG1 THR F  51     -72.877  72.964  39.936  1.00 31.78           O  
ATOM   9463  CG2 THR F  51     -72.025  73.247  37.707  1.00 34.19           C  
ATOM   9464  N   LEU F  52     -74.980  71.628  36.264  1.00 32.84           N  
ATOM   9465  CA  LEU F  52     -75.312  71.295  34.875  1.00 34.76           C  
ATOM   9466  C   LEU F  52     -76.524  72.051  34.316  1.00 33.41           C  
ATOM   9467  O   LEU F  52     -76.481  72.531  33.184  1.00 32.54           O  
ATOM   9468  CB  LEU F  52     -75.573  69.790  34.725  1.00 35.07           C  
ATOM   9469  CG  LEU F  52     -74.421  68.849  34.386  1.00 41.10           C  
ATOM   9470  CD1 LEU F  52     -75.020  67.525  33.947  1.00 44.71           C  
ATOM   9471  CD2 LEU F  52     -73.507  69.387  33.300  1.00 42.71           C  
ATOM   9472  N   GLU F  53     -77.603  72.102  35.098  1.00 34.47           N  
ATOM   9473  CA  GLU F  53     -78.851  72.787  34.706  1.00 35.65           C  
ATOM   9474  C   GLU F  53     -78.593  74.268  34.491  1.00 33.71           C  
ATOM   9475  O   GLU F  53     -79.140  74.877  33.577  1.00 32.48           O  
ATOM   9476  CB  GLU F  53     -79.933  72.651  35.789  1.00 35.59           C  
ATOM   9477  CG  GLU F  53     -80.658  71.316  35.874  1.00 40.53           C  
ATOM   9478  CD  GLU F  53     -81.667  71.280  37.038  1.00 39.37           C  
ATOM   9479  OE2 GLU F  53     -81.779  70.234  37.723  1.00 44.27           O  
ATOM   9480  N   GLN F  54     -77.771  74.835  35.367  1.00 33.44           N  
ATOM   9481  CA  GLN F  54     -77.372  76.235  35.294  1.00 34.61           C  
ATOM   9482  C   GLN F  54     -76.590  76.537  34.000  1.00 34.30           C  
ATOM   9483  O   GLN F  54     -76.838  77.551  33.342  1.00 31.96           O  
ATOM   9484  CB  GLN F  54     -76.541  76.576  36.533  1.00 34.75           C  
ATOM   9485  CG  GLN F  54     -76.039  78.001  36.619  1.00 38.22           C  
ATOM   9486  CD  GLN F  54     -74.565  78.073  37.000  1.00 43.33           C  
ATOM   9487  NE2 GLN F  54     -74.212  79.049  37.827  1.00 41.98           N  
ATOM   9488  N   ARG F  55     -75.657  75.649  33.648  1.00 34.19           N  
ATOM   9489  CA  ARG F  55     -74.878  75.769  32.415  1.00 34.30           C  
ATOM   9490  C   ARG F  55     -75.739  75.629  31.177  1.00 34.53           C  
ATOM   9491  O   ARG F  55     -75.513  76.312  30.189  1.00 32.03           O  
ATOM   9492  CB  ARG F  55     -73.770  74.723  32.375  1.00 34.21           C  
ATOM   9493  CG  ARG F  55     -72.650  75.029  33.334  1.00 33.33           C  
ATOM   9494  CD  ARG F  55     -71.637  73.892  33.450  1.00 32.35           C  
ATOM   9495  NE  ARG F  55     -70.630  74.257  34.437  1.00 30.10           N  
ATOM   9496  CZ  ARG F  55     -69.615  73.499  34.836  1.00 31.35           C  
ATOM   9497  NH1 ARG F  55     -69.411  72.296  34.334  1.00 31.43           N  
ATOM   9498  NH2 ARG F  55     -68.781  73.964  35.749  1.00 31.95           N  
ATOM   9499  N   LYS F  56     -76.705  74.719  31.233  1.00 36.71           N  
ATOM   9500  CA  LYS F  56     -77.654  74.539  30.143  1.00 38.89           C  
ATOM   9501  C   LYS F  56     -78.500  75.792  29.995  1.00 39.44           C  
ATOM   9502  O   LYS F  56     -78.807  76.191  28.877  1.00 40.34           O  
ATOM   9503  CB  LYS F  56     -78.544  73.311  30.388  1.00 39.93           C  
ATOM   9504  CG  LYS F  56     -79.405  72.892  29.197  1.00 42.37           C  
ATOM   9505  N   ARG F  57     -78.858  76.415  31.122  1.00 39.72           N  
ATOM   9506  CA  ARG F  57     -79.667  77.645  31.126  1.00 39.67           C  
ATOM   9507  C   ARG F  57     -78.926  78.839  30.537  1.00 38.64           C  
ATOM   9508  O   ARG F  57     -79.509  79.623  29.809  1.00 39.51           O  
ATOM   9509  CB  ARG F  57     -80.150  78.001  32.543  1.00 40.08           C  
ATOM   9510  CG  ARG F  57     -81.636  77.787  32.796  1.00 40.35           C  
ATOM   9511  N   ASN F  58     -77.644  78.973  30.852  1.00 38.34           N  
ATOM   9512  CA  ASN F  58     -76.825  80.084  30.347  1.00 37.95           C  
ATOM   9513  C   ASN F  58     -76.157  79.780  29.012  1.00 37.21           C  
ATOM   9514  O   ASN F  58     -75.267  80.524  28.582  1.00 35.01           O  
ATOM   9515  CB  ASN F  58     -75.725  80.442  31.351  1.00 38.18           C  
ATOM   9516  CG  ASN F  58     -76.268  80.777  32.718  1.00 39.16           C  
ATOM   9517  OD1 ASN F  58     -77.406  81.219  32.855  1.00 39.08           O  
ATOM   9518  ND2 ASN F  58     -75.454  80.553  33.745  1.00 36.13           N  
ATOM   9519  N   GLY F  59     -76.572  78.681  28.377  1.00 37.69           N  
ATOM   9520  CA  GLY F  59     -75.985  78.220  27.125  1.00 38.49           C  
ATOM   9521  C   GLY F  59     -74.469  78.113  27.158  1.00 38.65           C  
ATOM   9522  O   GLY F  59     -73.811  78.432  26.174  1.00 38.33           O  
ATOM   9523  N   GLU F  60     -73.917  77.692  28.298  1.00 38.25           N  
ATOM   9524  CA  GLU F  60     -72.474  77.482  28.438  1.00 38.03           C  
ATOM   9525  C   GLU F  60     -72.205  76.016  28.168  1.00 36.35           C  
ATOM   9526  O   GLU F  60     -73.112  75.196  28.308  1.00 36.44           O  
ATOM   9527  CB  GLU F  60     -71.995  77.860  29.840  1.00 38.64           C  
ATOM   9528  CG  GLU F  60     -71.948  79.368  30.096  1.00 41.25           C  
ATOM   9529  CD  GLU F  60     -72.286  79.757  31.542  1.00 44.93           C  
ATOM   9530  OE1 GLU F  60     -72.250  78.903  32.467  1.00 47.95           O  
ATOM   9531  N   PRO F  61     -70.973  75.674  27.750  1.00 35.86           N  
ATOM   9532  CA  PRO F  61     -70.619  74.253  27.579  1.00 34.61           C  
ATOM   9533  C   PRO F  61     -70.676  73.474  28.910  1.00 32.57           C  
ATOM   9534  O   PRO F  61     -70.267  73.990  29.962  1.00 30.12           O  
ATOM   9535  CB  PRO F  61     -69.187  74.310  27.046  1.00 34.67           C  
ATOM   9536  CG  PRO F  61     -68.670  75.651  27.498  1.00 37.71           C  
ATOM   9537  CD  PRO F  61     -69.843  76.561  27.421  1.00 35.96           C  
ATOM   9538  N   LEU F  62     -71.202  72.255  28.844  1.00 30.93           N  
ATOM   9539  CA  LEU F  62     -71.361  71.411  30.017  1.00 31.96           C  
ATOM   9540  C   LEU F  62     -70.044  71.129  30.722  1.00 29.97           C  
ATOM   9541  O   LEU F  62     -69.985  71.181  31.937  1.00 25.92           O  
ATOM   9542  CB  LEU F  62     -72.013  70.076  29.642  1.00 32.27           C  
ATOM   9543  CG  LEU F  62     -73.399  70.163  29.021  1.00 34.97           C  
ATOM   9544  CD1 LEU F  62     -73.997  68.755  28.906  1.00 35.90           C  
ATOM   9545  CD2 LEU F  62     -74.313  71.124  29.817  1.00 32.65           C  
ATOM   9546  N   GLY F  63     -69.003  70.819  29.949  1.00 29.44           N  
ATOM   9547  CA  GLY F  63     -67.683  70.516  30.497  1.00 28.40           C  
ATOM   9548  C   GLY F  63     -67.665  69.309  31.407  1.00 27.32           C  
ATOM   9549  O   GLY F  63     -66.892  69.254  32.355  1.00 26.17           O  
ATOM   9550  N   ALA F  64     -68.506  68.333  31.095  1.00 28.26           N  
ATOM   9551  CA  ALA F  64     -68.656  67.137  31.919  1.00 29.47           C  
ATOM   9552  C   ALA F  64     -69.150  65.945  31.106  1.00 29.01           C  
ATOM   9553  O   ALA F  64     -69.686  66.083  30.011  1.00 29.51           O  
ATOM   9554  CB  ALA F  64     -69.624  67.404  33.066  1.00 29.32           C  
ATOM   9555  N   ILE F  65     -68.963  64.768  31.663  1.00 29.85           N  
ATOM   9556  CA  ILE F  65     -69.590  63.585  31.133  1.00 31.81           C  
ATOM   9557  C   ILE F  65     -70.969  63.405  31.794  1.00 30.80           C  
ATOM   9558  O   ILE F  65     -71.089  63.225  33.009  1.00 30.76           O  
ATOM   9559  CB  ILE F  65     -68.674  62.343  31.275  1.00 31.82           C  
ATOM   9560  CG1 ILE F  65     -67.498  62.474  30.305  1.00 33.61           C  
ATOM   9561  CG2 ILE F  65     -69.419  61.046  30.956  1.00 31.43           C  
ATOM   9562  CD1 ILE F  65     -66.288  62.787  30.969  1.00 38.49           C  
ATOM   9563  N   THR F  66     -72.000  63.455  30.968  1.00 28.91           N  
ATOM   9564  CA  THR F  66     -73.356  63.231  31.439  1.00 29.65           C  
ATOM   9565  C   THR F  66     -73.528  61.800  31.903  1.00 29.73           C  
ATOM   9566  O   THR F  66     -72.829  60.888  31.440  1.00 29.54           O  
ATOM   9567  CB  THR F  66     -74.373  63.515  30.340  1.00 29.58           C  
ATOM   9568  OG1 THR F  66     -74.033  62.760  29.180  1.00 29.01           O  
ATOM   9569  CG2 THR F  66     -74.373  64.981  29.994  1.00 28.19           C  
ATOM   9570  N   GLU F  67     -74.450  61.600  32.834  1.00 30.01           N  
ATOM   9571  CA  GLU F  67     -74.767  60.260  33.295  1.00 31.51           C  
ATOM   9572  C   GLU F  67     -75.004  59.324  32.123  1.00 31.56           C  
ATOM   9573  O   GLU F  67     -74.610  58.173  32.159  1.00 32.47           O  
ATOM   9574  CB  GLU F  67     -76.002  60.265  34.187  1.00 31.58           C  
ATOM   9575  CG  GLU F  67     -76.326  58.902  34.745  1.00 32.93           C  
ATOM   9576  CD  GLU F  67     -77.320  58.941  35.887  1.00 33.62           C  
ATOM   9577  OE1 GLU F  67     -78.018  59.970  36.056  1.00 32.18           O  
ATOM   9578  OE2 GLU F  67     -77.395  57.923  36.608  1.00 35.67           O  
ATOM   9579  N   ASP F  68     -75.620  59.840  31.076  1.00 32.28           N  
ATOM   9580  CA  ASP F  68     -76.064  59.014  29.977  1.00 34.69           C  
ATOM   9581  C   ASP F  68     -74.919  58.544  29.062  1.00 33.03           C  
ATOM   9582  O   ASP F  68     -75.029  57.499  28.419  1.00 31.03           O  
ATOM   9583  CB  ASP F  68     -77.138  59.770  29.192  1.00 36.25           C  
ATOM   9584  CG  ASP F  68     -78.150  60.480  30.120  1.00 45.56           C  
ATOM   9585  OD1 ASP F  68     -77.732  61.402  30.903  1.00 46.04           O  
ATOM   9586  OD2 ASP F  68     -79.356  60.117  30.059  1.00 51.58           O  
ATOM   9587  N   LYS F  69     -73.829  59.309  29.021  1.00 31.80           N  
ATOM   9588  CA  LYS F  69     -72.674  58.994  28.177  1.00 31.20           C  
ATOM   9589  C   LYS F  69     -71.499  58.452  28.988  1.00 27.97           C  
ATOM   9590  O   LYS F  69     -70.434  58.250  28.438  1.00 26.36           O  
ATOM   9591  CB  LYS F  69     -72.195  60.245  27.425  1.00 31.88           C  
ATOM   9592  CG  LYS F  69     -73.277  61.078  26.760  1.00 33.93           C  
ATOM   9593  CD  LYS F  69     -73.502  60.710  25.324  1.00 43.93           C  
ATOM   9594  CE  LYS F  69     -74.607  61.587  24.683  1.00 48.38           C  
ATOM   9595  NZ  LYS F  69     -76.035  61.346  25.205  1.00 46.75           N  
ATOM   9596  N   PHE F  70     -71.681  58.255  30.290  1.00 27.93           N  
ATOM   9597  CA  PHE F  70     -70.588  57.820  31.178  1.00 27.10           C  
ATOM   9598  C   PHE F  70     -69.950  56.496  30.783  1.00 26.96           C  
ATOM   9599  O   PHE F  70     -68.731  56.328  30.873  1.00 25.62           O  
ATOM   9600  CB  PHE F  70     -71.043  57.707  32.625  1.00 26.45           C  
ATOM   9601  CG  PHE F  70     -69.903  57.582  33.574  1.00 28.82           C  
ATOM   9602  CD1 PHE F  70     -69.050  58.655  33.786  1.00 31.12           C  
ATOM   9603  CD2 PHE F  70     -69.643  56.394  34.217  1.00 26.41           C  
ATOM   9604  CE1 PHE F  70     -67.967  58.543  34.638  1.00 32.61           C  
ATOM   9605  CE2 PHE F  70     -68.576  56.280  35.079  1.00 31.60           C  
ATOM   9606  CZ  PHE F  70     -67.734  57.354  35.293  1.00 30.16           C  
ATOM   9607  N   GLN F  71     -70.777  55.560  30.348  1.00 25.67           N  
ATOM   9608  CA  GLN F  71     -70.301  54.255  29.970  1.00 27.26           C  
ATOM   9609  C   GLN F  71     -69.549  54.348  28.640  1.00 25.76           C  
ATOM   9610  O   GLN F  71     -68.537  53.699  28.479  1.00 24.13           O  
ATOM   9611  CB  GLN F  71     -71.466  53.262  29.926  1.00 27.90           C  
ATOM   9612  CG  GLN F  71     -71.130  51.854  30.399  1.00 39.09           C  
ATOM   9613  CD  GLN F  71     -70.555  51.763  31.829  1.00 47.15           C  
ATOM   9614  OE1 GLN F  71     -70.950  52.487  32.742  1.00 47.36           O  
ATOM   9615  NE2 GLN F  71     -69.620  50.841  32.011  1.00 52.78           N  
ATOM   9616  N   ASP F  72     -70.015  55.178  27.705  1.00 26.57           N  
ATOM   9617  CA  ASP F  72     -69.280  55.440  26.457  1.00 26.89           C  
ATOM   9618  C   ASP F  72     -67.922  56.067  26.735  1.00 26.43           C  
ATOM   9619  O   ASP F  72     -66.947  55.735  26.086  1.00 26.30           O  
ATOM   9620  CB  ASP F  72     -70.061  56.349  25.508  1.00 27.52           C  
ATOM   9621  CG  ASP F  72     -71.283  55.671  24.897  1.00 32.31           C  
ATOM   9622  OD1 ASP F  72     -72.070  56.382  24.236  1.00 37.35           O  
ATOM   9623  OD2 ASP F  72     -71.465  54.448  25.061  1.00 37.13           O  
ATOM   9624  N   TYR F  73     -67.874  56.970  27.708  1.00 25.71           N  
ATOM   9625  CA  TYR F  73     -66.628  57.591  28.151  1.00 24.59           C  
ATOM   9626  C   TYR F  73     -65.640  56.570  28.703  1.00 23.77           C  
ATOM   9627  O   TYR F  73     -64.496  56.575  28.318  1.00 21.85           O  
ATOM   9628  CB  TYR F  73     -66.935  58.682  29.183  1.00 22.78           C  
ATOM   9629  CG  TYR F  73     -65.811  59.026  30.125  1.00 24.20           C  
ATOM   9630  CD1 TYR F  73     -64.767  59.868  29.738  1.00 18.32           C  
ATOM   9631  CD2 TYR F  73     -65.790  58.517  31.432  1.00 23.17           C  
ATOM   9632  CE1 TYR F  73     -63.737  60.192  30.636  1.00 23.10           C  
ATOM   9633  CE2 TYR F  73     -64.784  58.854  32.315  1.00 23.48           C  
ATOM   9634  CZ  TYR F  73     -63.761  59.692  31.917  1.00 21.29           C  
ATOM   9635  OH  TYR F  73     -62.759  59.988  32.812  1.00 23.56           O  
ATOM   9636  N   LEU F  74     -66.089  55.706  29.602  1.00 25.10           N  
ATOM   9637  CA  LEU F  74     -65.289  54.582  30.076  1.00 26.30           C  
ATOM   9638  C   LEU F  74     -64.830  53.642  28.951  1.00 27.11           C  
ATOM   9639  O   LEU F  74     -63.738  53.101  29.008  1.00 26.20           O  
ATOM   9640  CB  LEU F  74     -66.060  53.761  31.119  1.00 26.42           C  
ATOM   9641  CG  LEU F  74     -66.360  54.351  32.494  1.00 25.60           C  
ATOM   9642  CD1 LEU F  74     -67.000  53.291  33.392  1.00 28.35           C  
ATOM   9643  CD2 LEU F  74     -65.116  54.898  33.150  1.00 27.74           C  
ATOM   9644  N   LYS F  75     -65.660  53.454  27.932  1.00 28.96           N  
ATOM   9645  CA  LYS F  75     -65.301  52.604  26.792  1.00 31.55           C  
ATOM   9646  C   LYS F  75     -64.147  53.192  25.987  1.00 29.28           C  
ATOM   9647  O   LYS F  75     -63.285  52.459  25.525  1.00 29.98           O  
ATOM   9648  CB  LYS F  75     -66.520  52.376  25.884  1.00 33.37           C  
ATOM   9649  CG  LYS F  75     -66.670  50.951  25.356  1.00 39.14           C  
ATOM   9650  CD  LYS F  75     -68.139  50.556  25.098  1.00 38.87           C  
ATOM   9651  CE  LYS F  75     -68.711  51.292  23.901  1.00 45.41           C  
ATOM   9652  NZ  LYS F  75     -70.146  50.959  23.685  1.00 42.86           N  
ATOM   9653  N   ARG F  76     -64.129  54.503  25.819  1.00 26.61           N  
ATOM   9654  CA  ARG F  76     -62.992  55.157  25.196  1.00 29.44           C  
ATOM   9655  C   ARG F  76     -61.707  54.924  25.989  1.00 27.91           C  
ATOM   9656  O   ARG F  76     -60.661  54.645  25.405  1.00 24.34           O  
ATOM   9657  CB  ARG F  76     -63.239  56.647  25.020  1.00 29.45           C  
ATOM   9658  CG  ARG F  76     -64.277  56.939  23.960  1.00 37.10           C  
ATOM   9659  CD  ARG F  76     -64.103  58.330  23.382  1.00 43.44           C  
ATOM   9660  NE  ARG F  76     -62.910  58.440  22.544  1.00 50.68           N  
ATOM   9661  CZ  ARG F  76     -62.381  59.594  22.132  1.00 49.90           C  
ATOM   9662  NH1 ARG F  76     -62.910  60.761  22.488  1.00 46.55           N  
ATOM   9663  NH2 ARG F  76     -61.302  59.584  21.365  1.00 50.14           N  
ATOM   9664  N   LEU F  77     -61.814  54.990  27.314  1.00 27.68           N  
ATOM   9665  CA  LEU F  77     -60.660  54.795  28.194  1.00 28.65           C  
ATOM   9666  C   LEU F  77     -60.139  53.351  28.196  1.00 28.16           C  
ATOM   9667  O   LEU F  77     -58.941  53.126  28.251  1.00 27.87           O  
ATOM   9668  CB  LEU F  77     -60.960  55.290  29.618  1.00 27.57           C  
ATOM   9669  CG  LEU F  77     -61.279  56.796  29.710  1.00 27.31           C  
ATOM   9670  CD1 LEU F  77     -61.285  57.222  31.155  1.00 25.75           C  
ATOM   9671  CD2 LEU F  77     -60.301  57.640  28.912  1.00 25.29           C  
ATOM   9672  N   TRP F  78     -61.041  52.388  28.100  1.00 28.75           N  
ATOM   9673  CA  TRP F  78     -60.663  50.989  28.050  1.00 28.65           C  
ATOM   9674  C   TRP F  78     -59.897  50.703  26.783  1.00 28.09           C  
ATOM   9675  O   TRP F  78     -58.912  49.971  26.795  1.00 28.55           O  
ATOM   9676  CB  TRP F  78     -61.894  50.097  28.076  1.00 28.98           C  
ATOM   9677  CG  TRP F  78     -62.728  50.215  29.287  1.00 29.36           C  
ATOM   9678  CD1 TRP F  78     -62.315  50.497  30.554  1.00 27.80           C  
ATOM   9679  CD2 TRP F  78     -64.139  50.018  29.354  1.00 27.75           C  
ATOM   9680  NE1 TRP F  78     -63.390  50.493  31.407  1.00 30.63           N  
ATOM   9681  CE2 TRP F  78     -64.522  50.198  30.692  1.00 26.76           C  
ATOM   9682  CE3 TRP F  78     -65.120  49.690  28.403  1.00 31.72           C  
ATOM   9683  CZ2 TRP F  78     -65.845  50.070  31.110  1.00 29.67           C  
ATOM   9684  CZ3 TRP F  78     -66.431  49.589  28.809  1.00 30.88           C  
ATOM   9685  CH2 TRP F  78     -66.785  49.783  30.155  1.00 31.04           C  
ATOM   9686  N   ARG F  79     -60.382  51.247  25.680  1.00 25.55           N  
ATOM   9687  CA  ARG F  79     -59.666  51.166  24.428  1.00 27.87           C  
ATOM   9688  C   ARG F  79     -58.323  51.894  24.485  1.00 26.50           C  
ATOM   9689  O   ARG F  79     -57.363  51.383  23.936  1.00 26.11           O  
ATOM   9690  CB  ARG F  79     -60.529  51.670  23.266  1.00 28.06           C  
ATOM   9691  CG  ARG F  79     -61.702  50.743  22.952  1.00 33.46           C  
ATOM   9692  CD  ARG F  79     -62.532  51.221  21.753  1.00 35.81           C  
ATOM   9693  NE  ARG F  79     -63.760  51.937  22.148  1.00 44.04           N  
ATOM   9694  CZ  ARG F  79     -64.028  53.201  21.830  1.00 38.61           C  
ATOM   9695  NH2 ARG F  79     -65.157  53.767  22.226  1.00 36.19           N  
ATOM   9696  N   GLU F  80     -58.242  53.057  25.140  1.00 25.51           N  
ATOM   9697  CA  GLU F  80     -56.965  53.748  25.295  1.00 26.25           C  
ATOM   9698  C   GLU F  80     -55.982  52.986  26.164  1.00 26.77           C  
ATOM   9699  O   GLU F  80     -54.798  53.139  25.951  1.00 28.14           O  
ATOM   9700  CB  GLU F  80     -57.090  55.151  25.922  1.00 26.16           C  
ATOM   9701  CG  GLU F  80     -57.368  56.275  24.984  1.00 35.93           C  
ATOM   9702  CD  GLU F  80     -56.452  56.309  23.795  1.00 30.58           C  
ATOM   9703  OE1 GLU F  80     -55.233  56.459  23.960  1.00 38.83           O  
ATOM   9704  OE2 GLU F  80     -56.963  56.189  22.688  1.00 41.14           O  
ATOM   9705  N   GLN F  81     -56.445  52.243  27.172  1.00 24.21           N  
ATOM   9706  CA  GLN F  81     -55.549  51.441  28.004  1.00 26.46           C  
ATOM   9707  C   GLN F  81     -54.629  50.572  27.148  1.00 25.68           C  
ATOM   9708  O   GLN F  81     -53.463  50.363  27.470  1.00 26.71           O  
ATOM   9709  CB  GLN F  81     -56.344  50.515  28.949  1.00 25.87           C  
ATOM   9710  CG  GLN F  81     -57.066  51.210  30.086  1.00 28.95           C  
ATOM   9711  CD  GLN F  81     -57.752  50.243  31.064  1.00 30.07           C  
ATOM   9712  OE1 GLN F  81     -58.877  49.788  30.827  1.00 32.01           O  
ATOM   9713  NE2 GLN F  81     -57.080  49.955  32.185  1.00 27.61           N  
ATOM   9714  N   LYS F  82     -55.195  50.042  26.075  1.00 24.95           N  
ATOM   9715  CA  LYS F  82     -54.505  49.176  25.136  1.00 26.06           C  
ATOM   9716  C   LYS F  82     -53.456  49.942  24.367  1.00 25.19           C  
ATOM   9717  O   LYS F  82     -52.314  49.521  24.302  1.00 24.11           O  
ATOM   9718  CB  LYS F  82     -55.524  48.565  24.160  1.00 25.54           C  
ATOM   9719  CG  LYS F  82     -55.025  47.443  23.267  1.00 26.80           C  
ATOM   9720  CD  LYS F  82     -56.117  47.065  22.285  1.00 25.92           C  
ATOM   9721  CE  LYS F  82     -55.720  45.954  21.371  1.00 28.57           C  
ATOM   9722  NZ  LYS F  82     -54.691  46.405  20.450  1.00 32.80           N  
ATOM   9723  N   ARG F  83     -53.852  51.053  23.763  1.00 25.75           N  
ATOM   9724  CA  ARG F  83     -52.897  51.928  23.110  1.00 27.26           C  
ATOM   9725  C   ARG F  83     -51.783  52.373  24.053  1.00 25.59           C  
ATOM   9726  O   ARG F  83     -50.603  52.276  23.733  1.00 25.09           O  
ATOM   9727  CB  ARG F  83     -53.591  53.169  22.558  1.00 28.57           C  
ATOM   9728  CG  ARG F  83     -53.697  53.174  21.046  1.00 33.73           C  
ATOM   9729  CD  ARG F  83     -53.243  54.472  20.443  1.00 33.22           C  
ATOM   9730  NE  ARG F  83     -53.586  55.612  21.287  1.00 36.79           N  
ATOM   9731  CZ  ARG F  83     -52.927  56.764  21.292  1.00 36.25           C  
ATOM   9732  NH1 ARG F  83     -53.318  57.743  22.084  1.00 28.09           N  
ATOM   9733  NH2 ARG F  83     -51.882  56.943  20.498  1.00 37.54           N  
ATOM   9734  N   ALA F  84     -52.174  52.865  25.218  1.00 25.37           N  
ATOM   9735  CA  ALA F  84     -51.230  53.355  26.212  1.00 25.94           C  
ATOM   9736  C   ALA F  84     -50.164  52.298  26.561  1.00 25.58           C  
ATOM   9737  O   ALA F  84     -48.984  52.611  26.653  1.00 23.46           O  
ATOM   9738  CB  ALA F  84     -51.971  53.826  27.448  1.00 26.19           C  
ATOM   9739  N   TRP F  85     -50.580  51.047  26.703  1.00 25.29           N  
ATOM   9740  CA  TRP F  85     -49.659  50.001  27.061  1.00 25.13           C  
ATOM   9741  C   TRP F  85     -48.767  49.626  25.891  1.00 26.05           C  
ATOM   9742  O   TRP F  85     -47.545  49.518  26.039  1.00 23.54           O  
ATOM   9743  CB  TRP F  85     -50.370  48.754  27.613  1.00 24.80           C  
ATOM   9744  CG  TRP F  85     -49.357  47.720  27.857  1.00 24.24           C  
ATOM   9745  CD1 TRP F  85     -49.053  46.642  27.055  1.00 23.29           C  
ATOM   9746  CD2 TRP F  85     -48.395  47.722  28.910  1.00 20.18           C  
ATOM   9747  NE1 TRP F  85     -47.979  45.964  27.573  1.00 22.08           N  
ATOM   9748  CE2 TRP F  85     -47.547  46.611  28.705  1.00 24.62           C  
ATOM   9749  CE3 TRP F  85     -48.166  48.551  30.012  1.00 25.98           C  
ATOM   9750  CZ2 TRP F  85     -46.498  46.301  29.576  1.00 23.43           C  
ATOM   9751  CZ3 TRP F  85     -47.112  48.238  30.882  1.00 25.98           C  
ATOM   9752  CH2 TRP F  85     -46.294  47.125  30.647  1.00 25.07           C  
ATOM   9753  N   GLU F  86     -49.379  49.413  24.736  1.00 28.26           N  
ATOM   9754  CA  GLU F  86     -48.645  48.983  23.543  1.00 30.34           C  
ATOM   9755  C   GLU F  86     -47.606  49.980  23.076  1.00 28.94           C  
ATOM   9756  O   GLU F  86     -46.486  49.599  22.780  1.00 28.61           O  
ATOM   9757  CB  GLU F  86     -49.596  48.726  22.377  1.00 29.93           C  
ATOM   9758  CG  GLU F  86     -50.329  47.402  22.449  1.00 37.47           C  
ATOM   9759  CD  GLU F  86     -51.425  47.282  21.392  1.00 36.76           C  
ATOM   9760  OE1 GLU F  86     -52.026  48.328  20.988  1.00 36.78           O  
ATOM   9761  OE2 GLU F  86     -51.689  46.129  20.994  1.00 40.04           O  
ATOM   9762  N   GLU F  87     -47.999  51.242  22.953  1.00 29.88           N  
ATOM   9763  CA  GLU F  87     -47.100  52.273  22.457  1.00 31.30           C  
ATOM   9764  C   GLU F  87     -46.043  52.687  23.491  1.00 28.55           C  
ATOM   9765  O   GLU F  87     -44.924  52.966  23.124  1.00 25.78           O  
ATOM   9766  CB  GLU F  87     -47.888  53.514  22.006  1.00 31.88           C  
ATOM   9767  CG  GLU F  87     -48.525  53.423  20.614  1.00 39.73           C  
ATOM   9768  CD  GLU F  87     -49.117  54.762  20.155  1.00 37.74           C  
ATOM   9769  N   TYR F  88     -46.410  52.736  24.774  1.00 27.95           N  
ATOM   9770  CA  TYR F  88     -45.592  53.415  25.795  1.00 26.79           C  
ATOM   9771  C   TYR F  88     -45.250  52.574  27.012  1.00 25.05           C  
ATOM   9772  O   TYR F  88     -44.526  53.039  27.865  1.00 25.55           O  
ATOM   9773  CB  TYR F  88     -46.293  54.710  26.280  1.00 25.79           C  
ATOM   9774  CG  TYR F  88     -46.589  55.682  25.172  1.00 25.25           C  
ATOM   9775  CD1 TYR F  88     -45.568  56.316  24.494  1.00 26.69           C  
ATOM   9776  CD2 TYR F  88     -47.883  55.954  24.791  1.00 24.87           C  
ATOM   9777  CE1 TYR F  88     -45.823  57.188  23.456  1.00 26.42           C  
ATOM   9778  CE2 TYR F  88     -48.151  56.830  23.756  1.00 28.48           C  
ATOM   9779  CZ  TYR F  88     -47.111  57.441  23.086  1.00 27.32           C  
ATOM   9780  OH  TYR F  88     -47.369  58.311  22.049  1.00 25.58           O  
ATOM   9781  N   GLY F  89     -45.769  51.363  27.119  1.00 24.55           N  
ATOM   9782  CA  GLY F  89     -45.658  50.621  28.367  1.00 25.90           C  
ATOM   9783  C   GLY F  89     -46.211  51.416  29.545  1.00 26.99           C  
ATOM   9784  O   GLY F  89     -45.703  51.322  30.644  1.00 24.88           O  
HETATM 9785  N   MSE F  90     -47.269  52.194  29.303  1.00 28.50           N  
HETATM 9786  CA  MSE F  90     -47.901  53.012  30.330  1.00 31.52           C  
HETATM 9787  C   MSE F  90     -49.219  52.404  30.755  1.00 27.37           C  
HETATM 9788  O   MSE F  90     -50.000  51.951  29.924  1.00 21.65           O  
HETATM 9789  CB  MSE F  90     -48.133  54.420  29.808  1.00 28.04           C  
HETATM 9790  CG  MSE F  90     -48.746  55.380  30.794  1.00 35.86           C  
HETATM 9791 SE   MSE F  90     -48.879  57.192  29.947  1.00 48.79          SE  
HETATM 9792  CE  MSE F  90     -50.426  56.934  28.721  1.00 39.50           C  
ATOM   9793  N   ILE F  91     -49.441  52.423  32.072  1.00 27.16           N  
ATOM   9794  CA  ILE F  91     -50.705  52.037  32.680  1.00 27.02           C  
ATOM   9795  C   ILE F  91     -51.658  53.230  32.693  1.00 26.08           C  
ATOM   9796  O   ILE F  91     -51.430  54.194  33.396  1.00 26.33           O  
ATOM   9797  CB  ILE F  91     -50.538  51.564  34.154  1.00 27.64           C  
ATOM   9798  CG1 ILE F  91     -49.446  50.476  34.286  1.00 27.67           C  
ATOM   9799  CG2 ILE F  91     -51.902  51.162  34.722  1.00 27.54           C  
ATOM   9800  CD1 ILE F  91     -49.900  49.088  34.325  1.00 40.34           C  
ATOM   9801  N   LEU F  92     -52.724  53.156  31.913  1.00 25.63           N  
ATOM   9802  CA  LEU F  92     -53.767  54.160  31.954  1.00 27.78           C  
ATOM   9803  C   LEU F  92     -54.922  53.593  32.767  1.00 26.80           C  
ATOM   9804  O   LEU F  92     -55.395  52.486  32.490  1.00 27.22           O  
ATOM   9805  CB  LEU F  92     -54.209  54.511  30.533  1.00 27.18           C  
ATOM   9806  CG  LEU F  92     -55.315  55.547  30.373  1.00 31.17           C  
ATOM   9807  CD1 LEU F  92     -55.168  56.283  29.036  1.00 33.89           C  
ATOM   9808  CD2 LEU F  92     -56.715  54.941  30.486  1.00 36.20           C  
ATOM   9809  N   ILE F  93     -55.384  54.338  33.759  1.00 23.91           N  
ATOM   9810  CA  ILE F  93     -56.462  53.858  34.618  1.00 25.31           C  
ATOM   9811  C   ILE F  93     -57.663  54.728  34.412  1.00 23.74           C  
ATOM   9812  O   ILE F  93     -57.547  55.921  34.539  1.00 23.71           O  
ATOM   9813  CB  ILE F  93     -56.086  53.899  36.135  1.00 24.81           C  
ATOM   9814  CG1 ILE F  93     -54.679  53.340  36.375  1.00 26.73           C  
ATOM   9815  CG2 ILE F  93     -57.133  53.139  36.958  1.00 26.40           C  
ATOM   9816  CD1 ILE F  93     -54.153  53.477  37.824  1.00 26.35           C  
ATOM   9817  N   PRO F  94     -58.833  54.140  34.103  1.00 26.15           N  
ATOM   9818  CA  PRO F  94     -60.043  54.974  33.986  1.00 25.86           C  
ATOM   9819  C   PRO F  94     -60.453  55.596  35.312  1.00 26.18           C  
ATOM   9820  O   PRO F  94     -60.470  54.915  36.345  1.00 26.27           O  
ATOM   9821  CB  PRO F  94     -61.118  53.991  33.506  1.00 26.58           C  
ATOM   9822  CG  PRO F  94     -60.372  52.808  32.973  1.00 26.25           C  
ATOM   9823  CD  PRO F  94     -59.124  52.727  33.810  1.00 26.26           C  
ATOM   9824  N   GLY F  95     -60.759  56.888  35.275  1.00 25.98           N  
ATOM   9825  CA  GLY F  95     -61.123  57.642  36.460  1.00 26.26           C  
ATOM   9826  C   GLY F  95     -62.184  58.684  36.184  1.00 26.56           C  
ATOM   9827  O   GLY F  95     -62.749  58.780  35.079  1.00 25.40           O  
ATOM   9828  N   VAL F  96     -62.452  59.462  37.221  1.00 26.62           N  
ATOM   9829  CA  VAL F  96     -63.429  60.519  37.177  1.00 26.41           C  
ATOM   9830  C   VAL F  96     -63.141  61.508  38.276  1.00 26.27           C  
ATOM   9831  O   VAL F  96     -62.711  61.122  39.365  1.00 26.67           O  
ATOM   9832  CB  VAL F  96     -64.883  59.951  37.317  1.00 27.87           C  
ATOM   9833  CG1 VAL F  96     -65.163  59.353  38.709  1.00 27.39           C  
ATOM   9834  CG2 VAL F  96     -65.885  60.992  36.975  1.00 25.27           C  
ATOM   9835  N   GLU F  97     -63.363  62.779  37.976  1.00 26.92           N  
ATOM   9836  CA  GLU F  97     -63.426  63.807  38.999  1.00 27.57           C  
ATOM   9837  C   GLU F  97     -64.885  64.110  39.279  1.00 27.13           C  
ATOM   9838  O   GLU F  97     -65.581  64.720  38.468  1.00 24.57           O  
ATOM   9839  CB  GLU F  97     -62.674  65.083  38.592  1.00 27.61           C  
ATOM   9840  CG  GLU F  97     -62.634  66.070  39.734  1.00 30.98           C  
ATOM   9841  CD  GLU F  97     -61.743  67.276  39.534  1.00 25.39           C  
ATOM   9842  OE1 GLU F  97     -61.117  67.475  38.478  1.00 30.00           O  
ATOM   9843  OE2 GLU F  97     -61.668  68.048  40.492  1.00 39.05           O  
ATOM   9844  N   ILE F  98     -65.339  63.660  40.441  1.00 28.23           N  
ATOM   9845  CA  ILE F  98     -66.706  63.886  40.886  1.00 28.77           C  
ATOM   9846  C   ILE F  98     -66.745  65.295  41.454  1.00 28.19           C  
ATOM   9847  O   ILE F  98     -66.137  65.592  42.487  1.00 25.48           O  
ATOM   9848  CB  ILE F  98     -67.107  62.869  41.957  1.00 30.72           C  
ATOM   9849  CG1 ILE F  98     -67.087  61.450  41.353  1.00 31.97           C  
ATOM   9850  CG2 ILE F  98     -68.457  63.238  42.551  1.00 32.21           C  
ATOM   9851  CD1 ILE F  98     -67.116  60.374  42.351  1.00 32.68           C  
ATOM   9852  N   THR F  99     -67.477  66.147  40.759  1.00 28.20           N  
ATOM   9853  CA  THR F  99     -67.336  67.582  40.874  1.00 29.10           C  
ATOM   9854  C   THR F  99     -68.669  68.191  41.366  1.00 28.11           C  
ATOM   9855  O   THR F  99     -69.629  68.306  40.608  1.00 26.52           O  
ATOM   9856  CB  THR F  99     -66.903  68.151  39.483  1.00 29.23           C  
ATOM   9857  OG1 THR F  99     -65.724  67.474  39.036  1.00 25.00           O  
ATOM   9858  CG2 THR F  99     -66.630  69.613  39.532  1.00 29.87           C  
ATOM   9859  N   ASN F 100     -68.731  68.528  42.646  1.00 27.86           N  
ATOM   9860  CA  ASN F 100     -69.874  69.252  43.188  1.00 29.33           C  
ATOM   9861  C   ASN F 100     -69.480  70.732  43.366  1.00 29.97           C  
ATOM   9862  O   ASN F 100     -68.795  71.108  44.327  1.00 27.81           O  
ATOM   9863  CB  ASN F 100     -70.394  68.614  44.501  1.00 28.59           C  
ATOM   9864  CG  ASN F 100     -71.768  69.142  44.896  1.00 26.64           C  
ATOM   9865  OD1 ASN F 100     -72.113  70.237  44.527  1.00 24.50           O  
ATOM   9866  ND2 ASN F 100     -72.555  68.355  45.619  1.00 22.88           N  
ATOM   9867  N   ASN F 101     -69.886  71.557  42.402  1.00 30.65           N  
ATOM   9868  CA  ASN F 101     -69.592  72.979  42.425  1.00 31.50           C  
ATOM   9869  C   ASN F 101     -70.648  73.727  43.207  1.00 31.71           C  
ATOM   9870  O   ASN F 101     -70.493  74.902  43.469  1.00 32.00           O  
ATOM   9871  CB  ASN F 101     -69.485  73.541  41.001  1.00 31.78           C  
ATOM   9872  CG  ASN F 101     -68.226  73.094  40.307  1.00 35.04           C  
ATOM   9873  OD1 ASN F 101     -67.318  72.584  40.961  1.00 39.70           O  
ATOM   9874  ND2 ASN F 101     -68.149  73.281  38.992  1.00 32.95           N  
ATOM   9875  N   THR F 102     -71.728  73.057  43.581  1.00 31.36           N  
ATOM   9876  CA  THR F 102     -72.705  73.677  44.467  1.00 31.41           C  
ATOM   9877  C   THR F 102     -72.140  73.771  45.882  1.00 31.31           C  
ATOM   9878  O   THR F 102     -72.085  74.854  46.457  1.00 31.74           O  
ATOM   9879  CB  THR F 102     -74.036  72.922  44.453  1.00 30.15           C  
ATOM   9880  OG1 THR F 102     -74.626  73.067  43.162  1.00 26.61           O  
ATOM   9881  CG2 THR F 102     -74.981  73.457  45.494  1.00 30.61           C  
ATOM   9882  N   ASP F 103     -71.717  72.643  46.427  1.00 31.11           N  
ATOM   9883  CA  ASP F 103     -71.227  72.592  47.803  1.00 33.32           C  
ATOM   9884  C   ASP F 103     -69.688  72.679  47.871  1.00 32.54           C  
ATOM   9885  O   ASP F 103     -69.126  72.765  48.951  1.00 33.87           O  
ATOM   9886  CB  ASP F 103     -71.752  71.328  48.526  1.00 33.76           C  
ATOM   9887  CG  ASP F 103     -73.264  71.172  48.418  1.00 34.30           C  
ATOM   9888  N   LEU F 104     -69.028  72.669  46.715  1.00 32.72           N  
ATOM   9889  CA  LEU F 104     -67.567  72.860  46.588  1.00 32.74           C  
ATOM   9890  C   LEU F 104     -66.710  71.730  47.141  1.00 31.65           C  
ATOM   9891  O   LEU F 104     -65.905  71.924  48.060  1.00 30.66           O  
ATOM   9892  CB  LEU F 104     -67.111  74.188  47.196  1.00 33.13           C  
ATOM   9893  CG  LEU F 104     -67.597  75.421  46.457  1.00 36.26           C  
ATOM   9894  CD1 LEU F 104     -67.212  76.673  47.238  1.00 36.42           C  
ATOM   9895  CD2 LEU F 104     -67.044  75.423  45.031  1.00 36.18           C  
ATOM   9896  N   TYR F 105     -66.878  70.549  46.570  1.00 30.24           N  
ATOM   9897  CA  TYR F 105     -65.939  69.477  46.818  1.00 28.87           C  
ATOM   9898  C   TYR F 105     -65.697  68.731  45.534  1.00 27.80           C  
ATOM   9899  O   TYR F 105     -66.631  68.471  44.768  1.00 27.33           O  
ATOM   9900  CB  TYR F 105     -66.387  68.554  47.961  1.00 29.13           C  
ATOM   9901  CG  TYR F 105     -67.760  67.947  47.846  1.00 27.97           C  
ATOM   9902  CD1 TYR F 105     -67.973  66.782  47.112  1.00 27.05           C  
ATOM   9903  CD2 TYR F 105     -68.847  68.517  48.501  1.00 26.25           C  
ATOM   9904  CE1 TYR F 105     -69.236  66.219  47.022  1.00 29.43           C  
ATOM   9905  CE2 TYR F 105     -70.102  67.961  48.410  1.00 26.79           C  
ATOM   9906  CZ  TYR F 105     -70.295  66.815  47.683  1.00 28.03           C  
ATOM   9907  OH  TYR F 105     -71.542  66.264  47.613  1.00 29.02           O  
ATOM   9908  N   HIS F 106     -64.425  68.437  45.302  1.00 27.09           N  
ATOM   9909  CA  HIS F 106     -63.958  67.720  44.126  1.00 28.33           C  
ATOM   9910  C   HIS F 106     -63.277  66.424  44.563  1.00 27.78           C  
ATOM   9911  O   HIS F 106     -62.307  66.447  45.304  1.00 26.87           O  
ATOM   9912  CB  HIS F 106     -63.000  68.585  43.319  1.00 27.58           C  
ATOM   9913  CG  HIS F 106     -63.656  69.757  42.652  1.00 27.31           C  
ATOM   9914  ND1 HIS F 106     -63.098  70.400  41.569  1.00 36.73           N  
ATOM   9915  CD2 HIS F 106     -64.824  70.396  42.897  1.00 35.63           C  
ATOM   9916  CE1 HIS F 106     -63.881  71.397  41.192  1.00 32.12           C  
ATOM   9917  NE2 HIS F 106     -64.938  71.412  41.976  1.00 34.70           N  
ATOM   9918  N   ILE F 107     -63.819  65.298  44.118  1.00 27.18           N  
ATOM   9919  CA  ILE F 107     -63.320  64.009  44.518  1.00 27.80           C  
ATOM   9920  C   ILE F 107     -62.816  63.241  43.295  1.00 27.94           C  
ATOM   9921  O   ILE F 107     -63.577  62.967  42.369  1.00 24.73           O  
ATOM   9922  CB  ILE F 107     -64.392  63.205  45.270  1.00 27.36           C  
ATOM   9923  CG1 ILE F 107     -64.870  64.006  46.485  1.00 28.27           C  
ATOM   9924  CG2 ILE F 107     -63.838  61.855  45.707  1.00 26.66           C  
ATOM   9925  CD1 ILE F 107     -65.973  63.338  47.280  1.00 29.35           C  
ATOM   9926  N   VAL F 108     -61.524  62.909  43.312  1.00 28.90           N  
ATOM   9927  CA  VAL F 108     -60.922  62.137  42.240  1.00 29.07           C  
ATOM   9928  C   VAL F 108     -60.991  60.664  42.618  1.00 28.50           C  
ATOM   9929  O   VAL F 108     -60.584  60.288  43.715  1.00 27.65           O  
ATOM   9930  CB  VAL F 108     -59.499  62.610  41.918  1.00 29.21           C  
ATOM   9931  CG1 VAL F 108     -58.802  61.626  41.017  1.00 30.66           C  
ATOM   9932  CG2 VAL F 108     -59.551  63.969  41.226  1.00 27.91           C  
ATOM   9933  N   ALA F 109     -61.584  59.865  41.721  1.00 27.59           N  
ATOM   9934  CA  ALA F 109     -61.685  58.414  41.863  1.00 27.26           C  
ATOM   9935  C   ALA F 109     -60.888  57.770  40.745  1.00 26.83           C  
ATOM   9936  O   ALA F 109     -61.082  58.084  39.558  1.00 25.71           O  
ATOM   9937  CB  ALA F 109     -63.138  57.953  41.797  1.00 28.57           C  
ATOM   9938  N   VAL F 110     -59.981  56.892  41.140  1.00 27.41           N  
ATOM   9939  CA  VAL F 110     -59.087  56.203  40.238  1.00 28.52           C  
ATOM   9940  C   VAL F 110     -59.515  54.743  40.174  1.00 27.49           C  
ATOM   9941  O   VAL F 110     -59.695  54.088  41.192  1.00 28.74           O  
ATOM   9942  CB  VAL F 110     -57.619  56.372  40.709  1.00 30.47           C  
ATOM   9943  CG1 VAL F 110     -56.653  55.460  39.925  1.00 29.57           C  
ATOM   9944  CG2 VAL F 110     -57.202  57.838  40.582  1.00 30.30           C  
ATOM   9945  N   ASP F 111     -59.700  54.257  38.962  1.00 28.42           N  
ATOM   9946  CA  ASP F 111     -60.210  52.915  38.696  1.00 29.79           C  
ATOM   9947  C   ASP F 111     -61.711  52.813  38.928  1.00 29.12           C  
ATOM   9948  O   ASP F 111     -62.201  51.932  39.644  1.00 27.89           O  
ATOM   9949  CB  ASP F 111     -59.444  51.804  39.439  1.00 30.68           C  
ATOM   9950  CG  ASP F 111     -59.512  50.469  38.693  1.00 31.58           C  
ATOM   9951  OD1 ASP F 111     -59.963  50.467  37.525  1.00 36.89           O  
ATOM   9952  OD2 ASP F 111     -59.132  49.422  39.248  1.00 34.25           O  
ATOM   9953  N   VAL F 112     -62.431  53.721  38.282  1.00 31.04           N  
ATOM   9954  CA  VAL F 112     -63.895  53.817  38.416  1.00 30.99           C  
ATOM   9955  C   VAL F 112     -64.595  52.964  37.362  1.00 28.91           C  
ATOM   9956  O   VAL F 112     -64.123  52.838  36.228  1.00 26.35           O  
ATOM   9957  CB  VAL F 112     -64.383  55.268  38.303  1.00 29.24           C  
ATOM   9958  CG1 VAL F 112     -64.302  55.763  36.858  1.00 30.17           C  
ATOM   9959  CG2 VAL F 112     -65.804  55.392  38.820  1.00 32.51           C  
ATOM   9960  N   LYS F 113     -65.727  52.390  37.739  1.00 29.29           N  
ATOM   9961  CA  LYS F 113     -66.484  51.545  36.816  1.00 30.91           C  
ATOM   9962  C   LYS F 113     -67.928  51.989  36.603  1.00 30.48           C  
ATOM   9963  O   LYS F 113     -68.531  51.602  35.623  1.00 30.83           O  
ATOM   9964  CB  LYS F 113     -66.432  50.088  37.283  1.00 31.19           C  
ATOM   9965  CG  LYS F 113     -65.023  49.480  37.288  1.00 32.29           C  
ATOM   9966  CD  LYS F 113     -64.466  49.331  38.718  1.00 34.72           C  
ATOM   9967  CE  LYS F 113     -63.053  48.759  38.710  1.00 32.26           C  
ATOM   9968  NZ  LYS F 113     -62.405  48.858  40.041  1.00 35.90           N  
ATOM   9969  N   GLU F 114     -68.482  52.789  37.514  1.00 31.94           N  
ATOM   9970  CA  GLU F 114     -69.878  53.221  37.440  1.00 33.51           C  
ATOM   9971  C   GLU F 114     -70.039  54.688  37.823  1.00 31.45           C  
ATOM   9972  O   GLU F 114     -69.357  55.192  38.704  1.00 31.76           O  
ATOM   9973  CB  GLU F 114     -70.740  52.394  38.386  1.00 32.55           C  
ATOM   9974  CG  GLU F 114     -70.838  50.908  38.087  1.00 36.64           C  
ATOM   9975  CD  GLU F 114     -71.436  50.097  39.269  1.00 39.57           C  
ATOM   9976  OE1 GLU F 114     -71.585  50.646  40.383  1.00 47.23           O  
ATOM   9977  OE2 GLU F 114     -71.749  48.900  39.087  1.00 49.58           O  
ATOM   9978  N   TYR F 115     -70.969  55.362  37.170  1.00 29.66           N  
ATOM   9979  CA  TYR F 115     -71.334  56.725  37.536  1.00 30.39           C  
ATOM   9980  C   TYR F 115     -71.809  56.800  38.988  1.00 29.51           C  
ATOM   9981  O   TYR F 115     -72.555  55.939  39.441  1.00 27.70           O  
ATOM   9982  CB  TYR F 115     -72.456  57.213  36.616  1.00 29.92           C  
ATOM   9983  CG  TYR F 115     -72.968  58.612  36.870  1.00 29.36           C  
ATOM   9984  CD1 TYR F 115     -73.990  58.836  37.769  1.00 27.58           C  
ATOM   9985  CD2 TYR F 115     -72.460  59.706  36.173  1.00 31.27           C  
ATOM   9986  CE1 TYR F 115     -74.494  60.115  37.994  1.00 32.62           C  
ATOM   9987  CE2 TYR F 115     -72.954  60.984  36.386  1.00 29.89           C  
ATOM   9988  CZ  TYR F 115     -73.975  61.181  37.304  1.00 32.32           C  
ATOM   9989  OH  TYR F 115     -74.502  62.438  37.530  1.00 36.46           O  
ATOM   9990  N   VAL F 116     -71.367  57.832  39.704  1.00 29.54           N  
ATOM   9991  CA  VAL F 116     -71.842  58.107  41.066  1.00 30.93           C  
ATOM   9992  C   VAL F 116     -72.343  59.551  41.116  1.00 30.58           C  
ATOM   9993  O   VAL F 116     -71.663  60.458  40.666  1.00 29.95           O  
ATOM   9994  CB  VAL F 116     -70.742  57.875  42.147  1.00 30.91           C  
ATOM   9995  CG1 VAL F 116     -71.271  58.228  43.551  1.00 33.07           C  
ATOM   9996  CG2 VAL F 116     -70.243  56.422  42.110  1.00 31.66           C  
ATOM   9997  N   ASP F 117     -73.550  59.733  41.639  1.00 30.20           N  
ATOM   9998  CA  ASP F 117     -74.217  61.036  41.726  1.00 29.97           C  
ATOM   9999  C   ASP F 117     -73.396  62.033  42.580  1.00 28.71           C  
ATOM  10000  O   ASP F 117     -73.350  61.897  43.810  1.00 25.30           O  
ATOM  10001  CB  ASP F 117     -75.613  60.792  42.324  1.00 29.92           C  
ATOM  10002  CG  ASP F 117     -76.469  62.034  42.423  1.00 33.94           C  
ATOM  10003  OD1 ASP F 117     -76.086  63.110  41.909  1.00 36.94           O  
ATOM  10004  OD2 ASP F 117     -77.564  61.910  43.026  1.00 38.94           O  
ATOM  10005  N   PRO F 118     -72.762  63.049  41.934  1.00 28.02           N  
ATOM  10006  CA  PRO F 118     -71.956  64.005  42.684  1.00 27.85           C  
ATOM  10007  C   PRO F 118     -72.693  64.746  43.799  1.00 28.41           C  
ATOM  10008  O   PRO F 118     -72.047  65.189  44.741  1.00 28.42           O  
ATOM  10009  CB  PRO F 118     -71.509  65.000  41.610  1.00 28.40           C  
ATOM  10010  CG  PRO F 118     -71.561  64.262  40.376  1.00 27.97           C  
ATOM  10011  CD  PRO F 118     -72.775  63.407  40.503  1.00 28.44           C  
ATOM  10012  N   SER F 119     -74.017  64.876  43.691  1.00 27.87           N  
ATOM  10013  CA  SER F 119     -74.840  65.577  44.693  1.00 30.12           C  
ATOM  10014  C   SER F 119     -74.924  64.887  46.041  1.00 29.65           C  
ATOM  10015  O   SER F 119     -75.257  65.524  47.031  1.00 30.45           O  
ATOM  10016  CB  SER F 119     -76.272  65.739  44.196  1.00 28.31           C  
ATOM  10017  OG  SER F 119     -76.252  66.286  42.902  1.00 38.96           O  
ATOM  10018  N   LEU F 120     -74.669  63.586  46.081  1.00 28.98           N  
ATOM  10019  CA  LEU F 120     -74.804  62.821  47.309  1.00 28.10           C  
ATOM  10020  C   LEU F 120     -73.865  63.343  48.415  1.00 28.31           C  
ATOM  10021  O   LEU F 120     -72.877  64.026  48.123  1.00 26.85           O  
ATOM  10022  CB  LEU F 120     -74.509  61.343  47.030  1.00 27.90           C  
ATOM  10023  CG  LEU F 120     -75.504  60.588  46.151  1.00 29.15           C  
ATOM  10024  CD1 LEU F 120     -74.990  59.196  45.856  1.00 29.83           C  
ATOM  10025  CD2 LEU F 120     -76.852  60.524  46.812  1.00 27.34           C  
ATOM  10026  N   PRO F 121     -74.167  63.008  49.682  1.00 27.45           N  
ATOM  10027  CA  PRO F 121     -73.208  63.218  50.751  1.00 28.11           C  
ATOM  10028  C   PRO F 121     -71.835  62.607  50.439  1.00 28.82           C  
ATOM  10029  O   PRO F 121     -71.753  61.521  49.860  1.00 26.58           O  
ATOM  10030  CB  PRO F 121     -73.856  62.514  51.948  1.00 29.06           C  
ATOM  10031  CG  PRO F 121     -75.312  62.578  51.678  1.00 27.63           C  
ATOM  10032  CD  PRO F 121     -75.421  62.424  50.183  1.00 28.56           C  
ATOM  10033  N   VAL F 122     -70.776  63.326  50.818  1.00 29.07           N  
ATOM  10034  CA  VAL F 122     -69.405  62.874  50.613  1.00 29.28           C  
ATOM  10035  C   VAL F 122     -69.196  61.420  51.045  1.00 28.71           C  
ATOM  10036  O   VAL F 122     -68.620  60.666  50.302  1.00 28.85           O  
ATOM  10037  CB  VAL F 122     -68.385  63.781  51.341  1.00 28.91           C  
ATOM  10038  CG1 VAL F 122     -67.013  63.122  51.391  1.00 30.05           C  
ATOM  10039  CG2 VAL F 122     -68.279  65.130  50.643  1.00 30.94           C  
ATOM  10040  N   GLU F 123     -69.654  61.041  52.233  1.00 28.79           N  
ATOM  10041  CA  GLU F 123     -69.484  59.690  52.716  1.00 30.24           C  
ATOM  10042  C   GLU F 123     -70.261  58.661  51.901  1.00 29.70           C  
ATOM  10043  O   GLU F 123     -69.806  57.543  51.760  1.00 28.70           O  
ATOM  10044  CB  GLU F 123     -69.903  59.574  54.186  1.00 31.78           C  
ATOM  10045  CG  GLU F 123     -68.968  60.257  55.185  1.00 38.39           C  
ATOM  10046  CD  GLU F 123     -67.564  59.646  55.257  1.00 43.98           C  
ATOM  10047  OE1 GLU F 123     -67.363  58.444  54.957  1.00 44.04           O  
ATOM  10048  OE2 GLU F 123     -66.641  60.391  55.632  1.00 54.36           O  
ATOM  10049  N   GLU F 124     -71.435  59.014  51.389  1.00 30.31           N  
ATOM  10050  CA  GLU F 124     -72.151  58.121  50.476  1.00 31.83           C  
ATOM  10051  C   GLU F 124     -71.423  57.979  49.142  1.00 30.89           C  
ATOM  10052  O   GLU F 124     -71.280  56.883  48.623  1.00 30.45           O  
ATOM  10053  CB  GLU F 124     -73.562  58.606  50.214  1.00 31.77           C  
ATOM  10054  CG  GLU F 124     -74.441  58.515  51.420  1.00 37.74           C  
ATOM  10055  CD  GLU F 124     -75.922  58.590  51.077  1.00 38.53           C  
ATOM  10056  OE1 GLU F 124     -76.272  58.430  49.882  1.00 35.84           O  
ATOM  10057  OE2 GLU F 124     -76.724  58.797  52.015  1.00 31.18           O  
ATOM  10058  N   ILE F 125     -70.952  59.084  48.596  1.00 29.76           N  
ATOM  10059  CA  ILE F 125     -70.130  59.015  47.384  1.00 31.89           C  
ATOM  10060  C   ILE F 125     -68.954  58.071  47.592  1.00 31.20           C  
ATOM  10061  O   ILE F 125     -68.716  57.174  46.805  1.00 29.95           O  
ATOM  10062  CB  ILE F 125     -69.560  60.389  46.970  1.00 30.90           C  
ATOM  10063  CG1 ILE F 125     -70.683  61.325  46.536  1.00 29.16           C  
ATOM  10064  CG2 ILE F 125     -68.515  60.216  45.853  1.00 30.21           C  
ATOM  10065  CD1 ILE F 125     -70.268  62.757  46.440  1.00 31.86           C  
ATOM  10066  N   VAL F 126     -68.235  58.276  48.675  1.00 32.41           N  
ATOM  10067  CA  VAL F 126     -67.036  57.496  48.958  1.00 32.38           C  
ATOM  10068  C   VAL F 126     -67.373  56.018  49.228  1.00 30.95           C  
ATOM  10069  O   VAL F 126     -66.619  55.128  48.855  1.00 30.92           O  
ATOM  10070  CB  VAL F 126     -66.231  58.166  50.110  1.00 32.61           C  
ATOM  10071  CG1 VAL F 126     -65.136  57.263  50.664  1.00 31.30           C  
ATOM  10072  CG2 VAL F 126     -65.650  59.481  49.604  1.00 28.99           C  
ATOM  10073  N   GLU F 127     -68.508  55.740  49.834  1.00 29.98           N  
ATOM  10074  CA  GLU F 127     -68.835  54.341  50.100  1.00 31.70           C  
ATOM  10075  C   GLU F 127     -69.141  53.610  48.780  1.00 29.87           C  
ATOM  10076  O   GLU F 127     -68.766  52.467  48.604  1.00 25.85           O  
ATOM  10077  CB  GLU F 127     -69.994  54.218  51.109  1.00 30.98           C  
ATOM  10078  CG  GLU F 127     -70.478  52.790  51.362  1.00 37.74           C  
ATOM  10079  CD  GLU F 127     -69.337  51.830  51.710  1.00 48.04           C  
ATOM  10080  OE2 GLU F 127     -69.156  50.798  51.015  1.00 50.19           O  
ATOM  10081  N   LYS F 128     -69.835  54.292  47.873  1.00 30.59           N  
ATOM  10082  CA  LYS F 128     -70.108  53.777  46.541  1.00 30.67           C  
ATOM  10083  C   LYS F 128     -68.808  53.550  45.764  1.00 29.21           C  
ATOM  10084  O   LYS F 128     -68.682  52.570  45.044  1.00 29.33           O  
ATOM  10085  CB  LYS F 128     -71.023  54.732  45.757  1.00 32.92           C  
ATOM  10086  CG  LYS F 128     -72.398  54.991  46.380  1.00 33.56           C  
ATOM  10087  CD  LYS F 128     -73.513  54.509  45.531  1.00 33.58           C  
ATOM  10088  CE  LYS F 128     -74.846  54.794  46.181  1.00 32.80           C  
ATOM  10089  NZ  LYS F 128     -75.803  53.683  45.950  1.00 27.82           N  
ATOM  10090  N   LEU F 129     -67.841  54.435  45.904  1.00 28.31           N  
ATOM  10091  CA  LEU F 129     -66.573  54.251  45.206  1.00 30.40           C  
ATOM  10092  C   LEU F 129     -65.737  53.092  45.791  1.00 31.45           C  
ATOM  10093  O   LEU F 129     -65.029  52.412  45.052  1.00 30.05           O  
ATOM  10094  CB  LEU F 129     -65.783  55.546  45.183  1.00 30.68           C  
ATOM  10095  CG  LEU F 129     -66.428  56.691  44.393  1.00 31.97           C  
ATOM  10096  CD1 LEU F 129     -65.664  57.986  44.669  1.00 32.22           C  
ATOM  10097  CD2 LEU F 129     -66.498  56.368  42.915  1.00 31.35           C  
ATOM  10098  N   LYS F 130     -65.858  52.856  47.100  1.00 32.45           N  
ATOM  10099  CA  LYS F 130     -65.200  51.729  47.769  1.00 32.42           C  
ATOM  10100  C   LYS F 130     -65.805  50.387  47.350  1.00 31.03           C  
ATOM  10101  O   LYS F 130     -65.093  49.398  47.244  1.00 28.42           O  
ATOM  10102  CB  LYS F 130     -65.255  51.897  49.291  1.00 33.91           C  
ATOM  10103  CG  LYS F 130     -63.946  52.379  49.935  1.00 39.34           C  
ATOM  10104  CD  LYS F 130     -63.442  53.738  49.424  1.00 43.72           C  
ATOM  10105  CE  LYS F 130     -62.056  54.115  50.027  1.00 45.27           C  
ATOM  10106  NZ  LYS F 130     -62.146  54.698  51.418  1.00 42.50           N  
ATOM  10107  N   GLU F 131     -67.115  50.369  47.113  1.00 29.59           N  
ATOM  10108  CA  GLU F 131     -67.813  49.215  46.555  1.00 30.60           C  
ATOM  10109  C   GLU F 131     -67.384  48.831  45.149  1.00 28.38           C  
ATOM  10110  O   GLU F 131     -67.519  47.689  44.763  1.00 28.64           O  
ATOM  10111  CB  GLU F 131     -69.313  49.483  46.533  1.00 31.71           C  
ATOM  10112  CG  GLU F 131     -69.972  49.410  47.907  1.00 37.41           C  
ATOM  10113  CD  GLU F 131     -71.372  50.019  47.935  1.00 37.33           C  
ATOM  10114  OE1 GLU F 131     -71.926  50.332  46.846  1.00 40.49           O  
ATOM  10115  OE2 GLU F 131     -71.897  50.182  49.061  1.00 43.85           O  
ATOM  10116  N   GLN F 132     -66.883  49.788  44.383  1.00 28.01           N  
ATOM  10117  CA  GLN F 132     -66.336  49.532  43.067  1.00 28.17           C  
ATOM  10118  C   GLN F 132     -64.863  49.163  43.099  1.00 27.98           C  
ATOM  10119  O   GLN F 132     -64.298  48.939  42.037  1.00 27.58           O  
ATOM  10120  CB  GLN F 132     -66.426  50.789  42.189  1.00 27.62           C  
ATOM  10121  CG  GLN F 132     -67.768  51.354  42.017  1.00 27.65           C  
ATOM  10122  CD  GLN F 132     -67.773  52.543  41.099  1.00 28.54           C  
ATOM  10123  OE1 GLN F 132     -66.942  52.642  40.183  1.00 25.45           O  
ATOM  10124  NE2 GLN F 132     -68.698  53.468  41.343  1.00 24.01           N  
ATOM  10125  N   ASN F 133     -64.229  49.180  44.276  1.00 28.48           N  
ATOM  10126  CA  ASN F 133     -62.764  49.044  44.396  1.00 28.89           C  
ATOM  10127  C   ASN F 133     -62.043  50.169  43.629  1.00 29.19           C  
ATOM  10128  O   ASN F 133     -61.091  49.929  42.871  1.00 28.91           O  
ATOM  10129  CB  ASN F 133     -62.294  47.639  43.938  1.00 29.44           C  
ATOM  10130  CG  ASN F 133     -60.805  47.332  44.285  1.00 30.20           C  
ATOM  10131  OD1 ASN F 133     -60.173  48.006  45.105  1.00 31.88           O  
ATOM  10132  ND2 ASN F 133     -60.250  46.308  43.628  1.00 29.23           N  
ATOM  10133  N   ALA F 134     -62.500  51.403  43.825  1.00 29.18           N  
ATOM  10134  CA  ALA F 134     -61.781  52.581  43.311  1.00 29.29           C  
ATOM  10135  C   ALA F 134     -60.914  53.191  44.408  1.00 29.49           C  
ATOM  10136  O   ALA F 134     -61.176  53.023  45.587  1.00 30.06           O  
ATOM  10137  CB  ALA F 134     -62.728  53.589  42.788  1.00 28.87           C  
ATOM  10138  N   LEU F 135     -59.868  53.891  44.007  1.00 29.41           N  
ATOM  10139  CA  LEU F 135     -59.030  54.614  44.951  1.00 30.28           C  
ATOM  10140  C   LEU F 135     -59.568  56.045  45.008  1.00 30.20           C  
ATOM  10141  O   LEU F 135     -59.848  56.617  43.969  1.00 27.59           O  
ATOM  10142  CB  LEU F 135     -57.593  54.594  44.455  1.00 30.27           C  
ATOM  10143  CG  LEU F 135     -56.540  55.426  45.174  1.00 29.61           C  
ATOM  10144  CD1 LEU F 135     -56.034  54.725  46.435  1.00 29.53           C  
ATOM  10145  CD2 LEU F 135     -55.424  55.663  44.196  1.00 30.44           C  
ATOM  10146  N   VAL F 136     -59.731  56.601  46.210  1.00 30.07           N  
ATOM  10147  CA  VAL F 136     -60.461  57.865  46.390  1.00 30.19           C  
ATOM  10148  C   VAL F 136     -59.572  58.982  46.949  1.00 28.91           C  
ATOM  10149  O   VAL F 136     -59.091  58.917  48.075  1.00 28.07           O  
ATOM  10150  CB  VAL F 136     -61.688  57.685  47.312  1.00 30.90           C  
ATOM  10151  CG1 VAL F 136     -62.625  58.856  47.176  1.00 32.19           C  
ATOM  10152  CG2 VAL F 136     -62.438  56.391  46.996  1.00 30.91           C  
ATOM  10153  N   ILE F 137     -59.385  60.012  46.138  1.00 30.01           N  
ATOM  10154  CA  ILE F 137     -58.513  61.133  46.432  1.00 29.31           C  
ATOM  10155  C   ILE F 137     -59.334  62.417  46.685  1.00 27.18           C  
ATOM  10156  O   ILE F 137     -60.232  62.733  45.911  1.00 24.87           O  
ATOM  10157  CB  ILE F 137     -57.558  61.348  45.248  1.00 29.07           C  
ATOM  10158  CG1 ILE F 137     -56.613  60.154  45.117  1.00 31.47           C  
ATOM  10159  CG2 ILE F 137     -56.769  62.656  45.393  1.00 29.77           C  
ATOM  10160  CD1 ILE F 137     -55.858  60.101  43.762  1.00 30.15           C  
ATOM  10161  N   ALA F 138     -59.010  63.144  47.761  1.00 28.33           N  
ATOM  10162  CA  ALA F 138     -59.511  64.518  47.976  1.00 27.61           C  
ATOM  10163  C   ALA F 138     -58.679  65.488  47.166  1.00 28.35           C  
ATOM  10164  O   ALA F 138     -57.561  65.789  47.530  1.00 28.85           O  
ATOM  10165  CB  ALA F 138     -59.449  64.898  49.442  1.00 25.82           C  
ATOM  10166  N   ALA F 139     -59.228  65.973  46.060  1.00 29.90           N  
ATOM  10167  CA  ALA F 139     -58.555  66.953  45.231  1.00 29.56           C  
ATOM  10168  C   ALA F 139     -58.601  68.345  45.875  1.00 32.40           C  
ATOM  10169  O   ALA F 139     -59.577  68.743  46.540  1.00 31.16           O  
ATOM  10170  CB  ALA F 139     -59.159  66.992  43.831  1.00 29.53           C  
ATOM  10171  N   HIS F 140     -57.509  69.069  45.672  1.00 33.81           N  
ATOM  10172  CA  HIS F 140     -57.332  70.396  46.188  1.00 33.86           C  
ATOM  10173  C   HIS F 140     -57.606  71.348  45.049  1.00 34.28           C  
ATOM  10174  O   HIS F 140     -57.218  71.086  43.919  1.00 35.46           O  
ATOM  10175  CB  HIS F 140     -55.895  70.567  46.670  1.00 33.23           C  
ATOM  10176  CG  HIS F 140     -55.676  71.793  47.497  1.00 30.50           C  
ATOM  10177  ND1 HIS F 140     -55.598  73.052  46.950  1.00 28.05           N  
ATOM  10178  CD2 HIS F 140     -55.510  71.951  48.830  1.00 30.19           C  
ATOM  10179  CE1 HIS F 140     -55.398  73.935  47.909  1.00 27.61           C  
ATOM  10180  NE2 HIS F 140     -55.346  73.291  49.060  1.00 32.62           N  
ATOM  10181  N   PRO F 141     -58.275  72.461  45.337  1.00 35.90           N  
ATOM  10182  CA  PRO F 141     -58.458  73.412  44.258  1.00 38.15           C  
ATOM  10183  C   PRO F 141     -57.108  73.986  43.799  1.00 40.44           C  
ATOM  10184  O   PRO F 141     -56.234  74.251  44.636  1.00 40.36           O  
ATOM  10185  CB  PRO F 141     -59.354  74.489  44.893  1.00 38.59           C  
ATOM  10186  CG  PRO F 141     -59.130  74.362  46.369  1.00 37.27           C  
ATOM  10187  CD  PRO F 141     -58.876  72.916  46.607  1.00 36.06           C  
ATOM  10188  N   ASP F 142     -56.921  74.160  42.493  1.00 41.63           N  
ATOM  10189  CA  ASP F 142     -55.681  74.770  42.018  1.00 44.51           C  
ATOM  10190  C   ASP F 142     -55.622  76.237  42.430  1.00 45.43           C  
ATOM  10191  O   ASP F 142     -56.659  76.880  42.638  1.00 44.71           O  
ATOM  10192  CB  ASP F 142     -55.450  74.595  40.502  1.00 45.38           C  
ATOM  10193  CG  ASP F 142     -56.530  75.227  39.655  1.00 44.19           C  
ATOM  10194  OD1 ASP F 142     -57.493  74.518  39.348  1.00 40.66           O  
ATOM  10195  OD2 ASP F 142     -56.406  76.401  39.265  1.00 48.34           O  
ATOM  10196  N   ARG F 143     -54.395  76.747  42.549  1.00 47.80           N  
ATOM  10197  CA  ARG F 143     -54.140  78.061  43.143  1.00 49.15           C  
ATOM  10198  C   ARG F 143     -54.692  79.212  42.297  1.00 49.53           C  
ATOM  10199  O   ARG F 143     -55.091  80.220  42.857  1.00 49.41           O  
ATOM  10200  CB  ARG F 143     -52.644  78.248  43.455  1.00 49.16           C  
ATOM  10201  CG  ARG F 143     -52.365  78.950  44.790  1.00 49.79           C  
ATOM  10202  N   LYS F 144     -54.754  79.056  40.973  1.00 51.32           N  
ATOM  10203  CA  LYS F 144     -55.378  80.080  40.092  1.00 53.42           C  
ATOM  10204  C   LYS F 144     -56.770  80.544  40.558  1.00 54.37           C  
ATOM  10205  O   LYS F 144     -57.764  79.825  40.429  1.00 55.46           O  
ATOM  10206  CB  LYS F 144     -55.472  79.588  38.636  1.00 53.77           C  
ATOM  10207  CG  LYS F 144     -54.273  79.949  37.764  1.00 55.02           C  
ATOM  10208  N   HIS F 150     -61.526  82.831  46.122  1.00 51.42           N  
ATOM  10209  CA  HIS F 150     -61.347  82.657  47.571  1.00 52.39           C  
ATOM  10210  C   HIS F 150     -62.636  82.139  48.218  1.00 49.69           C  
ATOM  10211  O   HIS F 150     -63.283  82.830  49.018  1.00 47.42           O  
ATOM  10212  CB  HIS F 150     -60.866  83.967  48.224  1.00 54.28           C  
ATOM  10213  CG  HIS F 150     -59.640  84.536  47.576  1.00 61.35           C  
ATOM  10214  ND1 HIS F 150     -58.379  84.011  47.777  1.00 68.68           N  
ATOM  10215  CD2 HIS F 150     -59.486  85.555  46.694  1.00 65.21           C  
ATOM  10216  CE1 HIS F 150     -57.501  84.692  47.063  1.00 68.68           C  
ATOM  10217  NE2 HIS F 150     -58.145  85.637  46.399  1.00 68.97           N  
ATOM  10218  N   LEU F 151     -62.980  80.903  47.844  1.00 47.42           N  
ATOM  10219  CA  LEU F 151     -64.173  80.199  48.319  1.00 44.64           C  
ATOM  10220  C   LEU F 151     -63.844  79.285  49.514  1.00 43.35           C  
ATOM  10221  O   LEU F 151     -62.680  79.020  49.794  1.00 44.39           O  
ATOM  10222  CB  LEU F 151     -64.756  79.369  47.176  1.00 43.78           C  
ATOM  10223  CG  LEU F 151     -64.855  80.051  45.811  1.00 41.90           C  
ATOM  10224  N   SER F 152     -64.873  78.812  50.216  1.00 41.87           N  
ATOM  10225  CA  SER F 152     -64.706  77.831  51.302  1.00 40.46           C  
ATOM  10226  C   SER F 152     -64.885  76.403  50.761  1.00 38.15           C  
ATOM  10227  O   SER F 152     -66.018  75.950  50.565  1.00 35.75           O  
ATOM  10228  CB  SER F 152     -65.717  78.101  52.429  1.00 41.66           C  
ATOM  10229  OG  SER F 152     -65.309  77.524  53.662  1.00 43.05           O  
ATOM  10230  N   TRP F 153     -63.770  75.705  50.516  1.00 36.52           N  
ATOM  10231  CA  TRP F 153     -63.814  74.342  49.960  1.00 34.63           C  
ATOM  10232  C   TRP F 153     -64.093  73.312  51.053  1.00 32.86           C  
ATOM  10233  O   TRP F 153     -63.377  73.248  52.055  1.00 30.86           O  
ATOM  10234  CB  TRP F 153     -62.541  74.031  49.190  1.00 34.39           C  
ATOM  10235  CG  TRP F 153     -62.441  74.861  47.950  1.00 37.80           C  
ATOM  10236  CD1 TRP F 153     -61.945  76.133  47.851  1.00 37.84           C  
ATOM  10237  CD2 TRP F 153     -62.894  74.505  46.633  1.00 36.64           C  
ATOM  10238  NE1 TRP F 153     -62.042  76.576  46.548  1.00 38.51           N  
ATOM  10239  CE2 TRP F 153     -62.627  75.603  45.785  1.00 38.11           C  
ATOM  10240  CE3 TRP F 153     -63.502  73.368  46.091  1.00 37.30           C  
ATOM  10241  CZ2 TRP F 153     -62.931  75.591  44.420  1.00 36.76           C  
ATOM  10242  CZ3 TRP F 153     -63.813  73.360  44.738  1.00 37.14           C  
ATOM  10243  CH2 TRP F 153     -63.511  74.461  43.916  1.00 36.45           C  
ATOM  10244  N   TYR F 154     -65.139  72.512  50.835  1.00 30.75           N  
ATOM  10245  CA  TYR F 154     -65.807  71.760  51.909  1.00 32.16           C  
ATOM  10246  C   TYR F 154     -64.921  70.727  52.631  1.00 30.46           C  
ATOM  10247  O   TYR F 154     -64.926  70.647  53.856  1.00 28.33           O  
ATOM  10248  CB  TYR F 154     -67.104  71.117  51.357  1.00 33.33           C  
ATOM  10249  CG  TYR F 154     -67.887  70.263  52.342  1.00 32.47           C  
ATOM  10250  CD1 TYR F 154     -68.317  70.778  53.567  1.00 36.17           C  
ATOM  10251  CD2 TYR F 154     -68.201  68.945  52.047  1.00 31.11           C  
ATOM  10252  CE1 TYR F 154     -69.030  69.989  54.467  1.00 35.61           C  
ATOM  10253  CE2 TYR F 154     -68.900  68.163  52.933  1.00 33.83           C  
ATOM  10254  CZ  TYR F 154     -69.322  68.684  54.134  1.00 36.28           C  
ATOM  10255  OH  TYR F 154     -70.025  67.877  55.001  1.00 38.18           O  
ATOM  10256  N   LEU F 155     -64.154  69.972  51.857  1.00 30.61           N  
ATOM  10257  CA  LEU F 155     -63.233  68.959  52.379  1.00 30.89           C  
ATOM  10258  C   LEU F 155     -62.100  69.567  53.216  1.00 29.77           C  
ATOM  10259  O   LEU F 155     -61.772  69.071  54.297  1.00 27.18           O  
ATOM  10260  CB  LEU F 155     -62.649  68.157  51.209  1.00 31.11           C  
ATOM  10261  CG  LEU F 155     -63.681  67.486  50.279  1.00 32.06           C  
ATOM  10262  CD1 LEU F 155     -63.011  66.692  49.153  1.00 28.31           C  
ATOM  10263  CD2 LEU F 155     -64.642  66.614  51.073  1.00 30.01           C  
ATOM  10264  N   TRP F 156     -61.548  70.666  52.708  1.00 30.05           N  
ATOM  10265  CA  TRP F 156     -60.430  71.397  53.316  1.00 30.08           C  
ATOM  10266  C   TRP F 156     -60.829  72.274  54.514  1.00 28.71           C  
ATOM  10267  O   TRP F 156     -59.993  72.679  55.311  1.00 26.26           O  
ATOM  10268  CB  TRP F 156     -59.752  72.234  52.227  1.00 30.76           C  
ATOM  10269  CG  TRP F 156     -59.366  71.364  51.108  1.00 33.70           C  
ATOM  10270  CD1 TRP F 156     -60.097  71.082  49.990  1.00 34.71           C  
ATOM  10271  CD2 TRP F 156     -58.185  70.568  51.031  1.00 35.23           C  
ATOM  10272  NE1 TRP F 156     -59.423  70.180  49.207  1.00 36.03           N  
ATOM  10273  CE2 TRP F 156     -58.242  69.853  49.821  1.00 32.14           C  
ATOM  10274  CE3 TRP F 156     -57.059  70.424  51.855  1.00 34.19           C  
ATOM  10275  CZ2 TRP F 156     -57.223  68.997  49.409  1.00 31.88           C  
ATOM  10276  CZ3 TRP F 156     -56.050  69.578  51.446  1.00 35.22           C  
ATOM  10277  CH2 TRP F 156     -56.140  68.872  50.232  1.00 31.90           C  
ATOM  10278  N   ALA F 157     -62.116  72.538  54.647  1.00 30.11           N  
ATOM  10279  CA  ALA F 157     -62.649  73.186  55.845  1.00 32.55           C  
ATOM  10280  C   ALA F 157     -63.045  72.161  56.917  1.00 33.93           C  
ATOM  10281  O   ALA F 157     -63.474  72.541  58.003  1.00 35.05           O  
ATOM  10282  CB  ALA F 157     -63.847  74.041  55.476  1.00 30.54           C  
ATOM  10283  N   ASN F 158     -62.931  70.871  56.593  1.00 34.68           N  
ATOM  10284  CA  ASN F 158     -63.454  69.786  57.419  1.00 34.58           C  
ATOM  10285  C   ASN F 158     -62.529  68.584  57.352  1.00 34.82           C  
ATOM  10286  O   ASN F 158     -62.972  67.445  57.255  1.00 33.14           O  
ATOM  10287  CB  ASN F 158     -64.860  69.350  56.963  1.00 34.04           C  
ATOM  10288  CG  ASN F 158     -65.921  70.428  57.161  1.00 34.60           C  
ATOM  10289  OD1 ASN F 158     -66.668  70.415  58.141  1.00 35.04           O  
ATOM  10290  ND2 ASN F 158     -66.011  71.345  56.213  1.00 29.64           N  
HETATM10291  N   MSE F 159     -61.236  68.835  57.435  1.00 36.41           N  
HETATM10292  CA  MSE F 159     -60.271  67.765  57.264  1.00 40.02           C  
HETATM10293  C   MSE F 159     -60.284  66.751  58.382  1.00 36.06           C  
HETATM10294  O   MSE F 159     -60.009  65.589  58.142  1.00 36.69           O  
HETATM10295  CB  MSE F 159     -58.874  68.335  57.115  1.00 39.82           C  
HETATM10296  CG  MSE F 159     -58.692  69.066  55.812  1.00 44.17           C  
HETATM10297 SE   MSE F 159     -56.863  69.710  55.644  1.00 52.92          SE  
HETATM10298  CE  MSE F 159     -56.014  68.139  54.889  1.00 50.05           C  
ATOM  10299  N   GLU F 160     -60.575  67.178  59.597  1.00 34.88           N  
ATOM  10300  CA  GLU F 160     -60.622  66.265  60.728  1.00 34.19           C  
ATOM  10301  C   GLU F 160     -61.789  65.309  60.540  1.00 32.61           C  
ATOM  10302  O   GLU F 160     -61.666  64.112  60.737  1.00 31.84           O  
ATOM  10303  CB  GLU F 160     -60.752  67.036  62.043  1.00 34.25           C  
ATOM  10304  CG  GLU F 160     -60.444  66.209  63.295  1.00 35.00           C  
ATOM  10305  N   ARG F 161     -62.920  65.843  60.121  1.00 32.76           N  
ATOM  10306  CA  ARG F 161     -64.100  65.025  59.851  1.00 32.99           C  
ATOM  10307  C   ARG F 161     -63.899  63.971  58.743  1.00 32.10           C  
ATOM  10308  O   ARG F 161     -64.504  62.904  58.772  1.00 30.00           O  
ATOM  10309  CB  ARG F 161     -65.232  65.958  59.485  1.00 33.19           C  
ATOM  10310  CG  ARG F 161     -66.529  65.310  59.125  1.00 36.16           C  
ATOM  10311  CD  ARG F 161     -67.493  66.409  58.829  1.00 41.13           C  
ATOM  10312  NE  ARG F 161     -68.707  65.937  58.195  1.00 47.54           N  
ATOM  10313  CZ  ARG F 161     -69.718  66.733  57.859  1.00 51.99           C  
ATOM  10314  NH1 ARG F 161     -69.653  68.046  58.088  1.00 49.38           N  
ATOM  10315  NH2 ARG F 161     -70.794  66.213  57.286  1.00 51.55           N  
ATOM  10316  N   PHE F 162     -63.058  64.279  57.763  1.00 31.62           N  
ATOM  10317  CA  PHE F 162     -62.817  63.379  56.652  1.00 31.31           C  
ATOM  10318  C   PHE F 162     -61.466  62.662  56.735  1.00 31.86           C  
ATOM  10319  O   PHE F 162     -61.065  61.984  55.801  1.00 33.05           O  
ATOM  10320  CB  PHE F 162     -62.938  64.160  55.353  1.00 30.86           C  
ATOM  10321  CG  PHE F 162     -64.306  64.743  55.128  1.00 32.15           C  
ATOM  10322  CD1 PHE F 162     -65.437  63.944  55.204  1.00 31.60           C  
ATOM  10323  CD2 PHE F 162     -64.464  66.080  54.822  1.00 30.06           C  
ATOM  10324  CE1 PHE F 162     -66.694  64.474  54.988  1.00 29.07           C  
ATOM  10325  CE2 PHE F 162     -65.709  66.602  54.618  1.00 29.48           C  
ATOM  10326  CZ  PHE F 162     -66.825  65.797  54.694  1.00 28.85           C  
ATOM  10327  N   LYS F 163     -60.793  62.805  57.871  1.00 32.71           N  
ATOM  10328  CA  LYS F 163     -59.522  62.137  58.189  1.00 33.76           C  
ATOM  10329  C   LYS F 163     -59.436  60.668  57.757  1.00 30.78           C  
ATOM  10330  O   LYS F 163     -58.437  60.243  57.221  1.00 28.95           O  
ATOM  10331  CB  LYS F 163     -59.315  62.253  59.715  1.00 34.97           C  
ATOM  10332  CG  LYS F 163     -58.039  61.658  60.315  1.00 38.30           C  
ATOM  10333  CD  LYS F 163     -58.060  61.845  61.852  1.00 39.45           C  
ATOM  10334  CE  LYS F 163     -57.411  60.671  62.633  1.00 49.49           C  
ATOM  10335  NZ  LYS F 163     -55.952  60.447  62.349  1.00 48.55           N  
ATOM  10336  N   ASP F 164     -60.482  59.896  58.021  1.00 31.09           N  
ATOM  10337  CA  ASP F 164     -60.511  58.465  57.724  1.00 30.70           C  
ATOM  10338  C   ASP F 164     -61.387  58.144  56.521  1.00 29.91           C  
ATOM  10339  O   ASP F 164     -61.740  57.001  56.320  1.00 30.83           O  
ATOM  10340  CB  ASP F 164     -61.041  57.678  58.946  1.00 31.55           C  
ATOM  10341  CG  ASP F 164     -60.196  57.882  60.199  1.00 32.15           C  
ATOM  10342  OD1 ASP F 164     -58.958  58.047  60.082  1.00 30.58           O  
ATOM  10343  OD2 ASP F 164     -60.771  57.861  61.309  1.00 31.95           O  
ATOM  10344  N   THR F 165     -61.731  59.148  55.723  1.00 30.27           N  
ATOM  10345  CA  THR F 165     -62.607  58.985  54.563  1.00 29.10           C  
ATOM  10346  C   THR F 165     -61.823  58.741  53.279  1.00 27.79           C  
ATOM  10347  O   THR F 165     -62.154  57.846  52.535  1.00 28.09           O  
ATOM  10348  CB  THR F 165     -63.513  60.238  54.378  1.00 29.47           C  
ATOM  10349  OG1 THR F 165     -64.311  60.419  55.546  1.00 28.10           O  
ATOM  10350  CG2 THR F 165     -64.430  60.108  53.183  1.00 27.04           C  
ATOM  10351  N   PHE F 166     -60.794  59.540  53.021  1.00 26.93           N  
ATOM  10352  CA  PHE F 166     -60.047  59.450  51.762  1.00 27.06           C  
ATOM  10353  C   PHE F 166     -58.819  58.579  51.860  1.00 26.48           C  
ATOM  10354  O   PHE F 166     -58.168  58.542  52.884  1.00 26.14           O  
ATOM  10355  CB  PHE F 166     -59.685  60.853  51.240  1.00 28.17           C  
ATOM  10356  CG  PHE F 166     -60.895  61.646  50.881  1.00 27.24           C  
ATOM  10357  CD1 PHE F 166     -61.540  61.416  49.685  1.00 25.20           C  
ATOM  10358  CD2 PHE F 166     -61.461  62.532  51.796  1.00 30.14           C  
ATOM  10359  CE1 PHE F 166     -62.739  62.099  49.376  1.00 31.53           C  
ATOM  10360  CE2 PHE F 166     -62.642  63.222  51.494  1.00 29.39           C  
ATOM  10361  CZ  PHE F 166     -63.280  63.004  50.289  1.00 28.05           C  
ATOM  10362  N   ASP F 167     -58.508  57.887  50.770  1.00 27.59           N  
ATOM  10363  CA  ASP F 167     -57.275  57.132  50.648  1.00 27.44           C  
ATOM  10364  C   ASP F 167     -56.055  58.056  50.627  1.00 28.29           C  
ATOM  10365  O   ASP F 167     -54.979  57.685  51.098  1.00 28.99           O  
ATOM  10366  CB  ASP F 167     -57.321  56.260  49.394  1.00 28.07           C  
ATOM  10367  CG  ASP F 167     -58.399  55.172  49.469  1.00 29.52           C  
ATOM  10368  OD1 ASP F 167     -58.570  54.541  50.558  1.00 26.12           O  
ATOM  10369  OD2 ASP F 167     -59.073  54.947  48.430  1.00 28.31           O  
ATOM  10370  N   ALA F 168     -56.236  59.265  50.097  1.00 28.00           N  
ATOM  10371  CA  ALA F 168     -55.195  60.284  50.101  1.00 27.88           C  
ATOM  10372  C   ALA F 168     -55.766  61.661  49.778  1.00 27.45           C  
ATOM  10373  O   ALA F 168     -56.868  61.784  49.225  1.00 26.34           O  
ATOM  10374  CB  ALA F 168     -54.098  59.927  49.089  1.00 28.65           C  
ATOM  10375  N   TRP F 169     -55.003  62.689  50.134  1.00 27.04           N  
ATOM  10376  CA  TRP F 169     -55.330  64.067  49.802  1.00 27.23           C  
ATOM  10377  C   TRP F 169     -54.283  64.630  48.870  1.00 26.93           C  
ATOM  10378  O   TRP F 169     -53.121  64.280  48.990  1.00 25.29           O  
ATOM  10379  CB  TRP F 169     -55.340  64.902  51.062  1.00 28.56           C  
ATOM  10380  CG  TRP F 169     -56.338  64.450  52.061  1.00 27.43           C  
ATOM  10381  CD1 TRP F 169     -56.337  63.282  52.766  1.00 24.59           C  
ATOM  10382  CD2 TRP F 169     -57.489  65.178  52.475  1.00 28.49           C  
ATOM  10383  NE1 TRP F 169     -57.431  63.239  53.597  1.00 30.21           N  
ATOM  10384  CE2 TRP F 169     -58.157  64.392  53.434  1.00 28.99           C  
ATOM  10385  CE3 TRP F 169     -58.024  66.423  52.125  1.00 27.62           C  
ATOM  10386  CZ2 TRP F 169     -59.328  64.812  54.052  1.00 28.34           C  
ATOM  10387  CZ3 TRP F 169     -59.196  66.835  52.730  1.00 28.86           C  
ATOM  10388  CH2 TRP F 169     -59.837  66.033  53.679  1.00 28.37           C  
ATOM  10389  N   GLU F 170     -54.691  65.504  47.954  1.00 25.67           N  
ATOM  10390  CA  GLU F 170     -53.740  66.214  47.124  1.00 27.03           C  
ATOM  10391  C   GLU F 170     -52.941  67.258  47.897  1.00 28.01           C  
ATOM  10392  O   GLU F 170     -53.467  68.304  48.297  1.00 27.38           O  
ATOM  10393  CB  GLU F 170     -54.417  66.888  45.958  1.00 27.88           C  
ATOM  10394  CG  GLU F 170     -54.351  66.126  44.689  1.00 32.66           C  
ATOM  10395  CD  GLU F 170     -55.003  66.867  43.539  1.00 34.07           C  
ATOM  10396  OE1 GLU F 170     -55.583  67.948  43.784  1.00 26.92           O  
ATOM  10397  OE2 GLU F 170     -54.933  66.356  42.404  1.00 31.89           O  
ATOM  10398  N   ILE F 171     -51.656  66.956  48.071  1.00 27.79           N  
ATOM  10399  CA  ILE F 171     -50.700  67.819  48.723  1.00 26.56           C  
ATOM  10400  C   ILE F 171     -50.039  68.710  47.691  1.00 26.42           C  
ATOM  10401  O   ILE F 171     -49.295  69.640  48.022  1.00 27.23           O  
ATOM  10402  CB  ILE F 171     -49.642  66.977  49.461  1.00 28.12           C  
ATOM  10403  CG1 ILE F 171     -48.805  67.830  50.414  1.00 27.80           C  
ATOM  10404  CG2 ILE F 171     -48.728  66.211  48.458  1.00 31.69           C  
ATOM  10405  CD1 ILE F 171     -48.150  67.029  51.513  1.00 27.77           C  
ATOM  10406  N   ALA F 172     -50.309  68.451  46.427  1.00 25.89           N  
ATOM  10407  CA  ALA F 172     -49.765  69.306  45.379  1.00 27.56           C  
ATOM  10408  C   ALA F 172     -50.500  69.084  44.094  1.00 27.32           C  
ATOM  10409  O   ALA F 172     -50.899  67.944  43.790  1.00 25.34           O  
ATOM  10410  CB  ALA F 172     -48.267  69.027  45.167  1.00 26.83           C  
ATOM  10411  N   ASN F 173     -50.681  70.175  43.360  1.00 28.07           N  
ATOM  10412  CA  ASN F 173     -51.025  70.106  41.943  1.00 31.27           C  
ATOM  10413  C   ASN F 173     -50.500  71.288  41.153  1.00 29.66           C  
ATOM  10414  O   ASN F 173     -50.095  72.290  41.718  1.00 25.82           O  
ATOM  10415  CB  ASN F 173     -52.530  69.830  41.681  1.00 34.57           C  
ATOM  10416  CG  ASN F 173     -53.449  70.978  42.059  1.00 34.28           C  
ATOM  10417  OD1 ASN F 173     -53.137  72.146  41.865  1.00 45.97           O  
ATOM  10418  ND2 ASN F 173     -54.618  70.629  42.564  1.00 32.86           N  
ATOM  10419  N   ARG F 174     -50.500  71.143  39.837  1.00 29.94           N  
ATOM  10420  CA  ARG F 174     -49.812  72.072  38.973  1.00 30.43           C  
ATOM  10421  C   ARG F 174     -48.425  72.298  39.565  1.00 31.43           C  
ATOM  10422  O   ARG F 174     -47.691  71.335  39.776  1.00 30.73           O  
ATOM  10423  CB  ARG F 174     -50.606  73.364  38.812  1.00 30.86           C  
ATOM  10424  CG  ARG F 174     -52.008  73.157  38.313  1.00 34.02           C  
ATOM  10425  CD  ARG F 174     -52.091  72.985  36.798  1.00 34.11           C  
ATOM  10426  NE  ARG F 174     -53.445  72.577  36.440  1.00 32.85           N  
ATOM  10427  CZ  ARG F 174     -54.492  73.396  36.405  1.00 28.65           C  
ATOM  10428  NH1 ARG F 174     -54.366  74.674  36.649  1.00 32.32           N  
ATOM  10429  NH2 ARG F 174     -55.680  72.938  36.102  1.00 34.13           N  
ATOM  10430  N   ASP F 175     -48.059  73.541  39.857  1.00 33.60           N  
ATOM  10431  CA  ASP F 175     -46.736  73.836  40.368  1.00 34.53           C  
ATOM  10432  C   ASP F 175     -46.767  74.224  41.837  1.00 31.69           C  
ATOM  10433  O   ASP F 175     -45.770  74.736  42.368  1.00 30.88           O  
ATOM  10434  CB  ASP F 175     -46.094  74.942  39.512  1.00 37.88           C  
ATOM  10435  CG  ASP F 175     -45.409  74.391  38.264  1.00 45.41           C  
ATOM  10436  OD1 ASP F 175     -44.775  73.312  38.343  1.00 45.96           O  
ATOM  10437  OD2 ASP F 175     -45.486  75.040  37.200  1.00 52.68           O  
ATOM  10438  N   ASP F 176     -47.888  73.953  42.502  1.00 29.36           N  
ATOM  10439  CA  ASP F 176     -48.082  74.376  43.889  1.00 30.30           C  
ATOM  10440  C   ASP F 176     -48.117  73.267  44.923  1.00 27.63           C  
ATOM  10441  O   ASP F 176     -48.665  72.213  44.688  1.00 26.51           O  
ATOM  10442  CB  ASP F 176     -49.366  75.171  43.997  1.00 31.63           C  
ATOM  10443  CG  ASP F 176     -49.391  76.315  43.046  1.00 34.22           C  
ATOM  10444  OD1 ASP F 176     -48.671  77.302  43.297  1.00 32.34           O  
ATOM  10445  OD2 ASP F 176     -50.113  76.196  42.040  1.00 40.14           O  
ATOM  10446  N   LEU F 177     -47.564  73.563  46.091  1.00 27.95           N  
ATOM  10447  CA  LEU F 177     -47.552  72.667  47.241  1.00 27.03           C  
ATOM  10448  C   LEU F 177     -48.537  73.167  48.272  1.00 26.76           C  
ATOM  10449  O   LEU F 177     -48.650  74.356  48.477  1.00 28.25           O  
ATOM  10450  CB  LEU F 177     -46.156  72.641  47.856  1.00 26.76           C  
ATOM  10451  CG  LEU F 177     -45.023  72.113  46.976  1.00 24.88           C  
ATOM  10452  CD1 LEU F 177     -43.699  72.360  47.596  1.00 27.13           C  
ATOM  10453  CD2 LEU F 177     -45.208  70.637  46.727  1.00 28.61           C  
ATOM  10454  N   PHE F 178     -49.237  72.259  48.935  1.00 29.22           N  
ATOM  10455  CA  PHE F 178     -50.266  72.621  49.904  1.00 29.59           C  
ATOM  10456  C   PHE F 178     -49.902  72.041  51.275  1.00 30.83           C  
ATOM  10457  O   PHE F 178     -50.133  70.870  51.558  1.00 31.25           O  
ATOM  10458  CB  PHE F 178     -51.643  72.136  49.423  1.00 29.78           C  
ATOM  10459  CG  PHE F 178     -51.984  72.567  48.008  1.00 29.56           C  
ATOM  10460  CD1 PHE F 178     -52.055  73.917  47.668  1.00 27.14           C  
ATOM  10461  CD2 PHE F 178     -52.243  71.623  47.016  1.00 30.57           C  
ATOM  10462  CE1 PHE F 178     -52.367  74.320  46.363  1.00 30.25           C  
ATOM  10463  CE2 PHE F 178     -52.563  72.021  45.703  1.00 28.71           C  
ATOM  10464  CZ  PHE F 178     -52.620  73.374  45.381  1.00 29.34           C  
ATOM  10465  N   ASN F 179     -49.340  72.891  52.125  1.00 31.60           N  
ATOM  10466  CA  ASN F 179     -48.660  72.454  53.345  1.00 34.03           C  
ATOM  10467  C   ASN F 179     -49.555  71.788  54.405  1.00 35.80           C  
ATOM  10468  O   ASN F 179     -49.061  71.029  55.238  1.00 37.28           O  
ATOM  10469  CB  ASN F 179     -47.891  73.638  53.973  1.00 32.22           C  
ATOM  10470  CG  ASN F 179     -46.779  73.184  54.913  1.00 31.21           C  
ATOM  10471  OD1 ASN F 179     -46.101  72.195  54.658  1.00 31.48           O  
ATOM  10472  ND2 ASN F 179     -46.588  73.906  56.003  1.00 29.39           N  
ATOM  10473  N   SER F 180     -50.857  72.072  54.358  1.00 36.56           N  
ATOM  10474  CA  SER F 180     -51.833  71.533  55.317  1.00 36.44           C  
ATOM  10475  C   SER F 180     -51.876  70.005  55.365  1.00 34.90           C  
ATOM  10476  O   SER F 180     -52.108  69.419  56.431  1.00 34.35           O  
ATOM  10477  CB  SER F 180     -53.236  72.060  54.989  1.00 37.15           C  
ATOM  10478  OG  SER F 180     -53.652  71.666  53.686  1.00 39.23           O  
ATOM  10479  N   VAL F 181     -51.665  69.373  54.212  1.00 34.21           N  
ATOM  10480  CA  VAL F 181     -51.657  67.904  54.114  1.00 34.88           C  
ATOM  10481  C   VAL F 181     -50.423  67.312  54.804  1.00 33.54           C  
ATOM  10482  O   VAL F 181     -50.529  66.358  55.552  1.00 32.68           O  
ATOM  10483  CB  VAL F 181     -51.749  67.415  52.620  1.00 34.43           C  
ATOM  10484  CG1 VAL F 181     -51.637  65.884  52.512  1.00 35.11           C  
ATOM  10485  CG2 VAL F 181     -53.045  67.869  51.975  1.00 34.97           C  
ATOM  10486  N   GLY F 182     -49.259  67.896  54.545  1.00 34.63           N  
ATOM  10487  CA  GLY F 182     -47.990  67.417  55.102  1.00 35.30           C  
ATOM  10488  C   GLY F 182     -47.833  67.667  56.590  1.00 34.69           C  
ATOM  10489  O   GLY F 182     -47.348  66.802  57.312  1.00 34.39           O  
ATOM  10490  N   VAL F 183     -48.261  68.844  57.040  1.00 34.74           N  
ATOM  10491  CA  VAL F 183     -48.203  69.224  58.450  1.00 34.57           C  
ATOM  10492  C   VAL F 183     -49.123  68.364  59.320  1.00 34.47           C  
ATOM  10493  O   VAL F 183     -48.745  67.947  60.405  1.00 32.16           O  
ATOM  10494  CB  VAL F 183     -48.584  70.690  58.623  1.00 34.79           C  
ATOM  10495  CG1 VAL F 183     -48.765  71.018  60.099  1.00 35.54           C  
ATOM  10496  CG2 VAL F 183     -47.525  71.583  57.994  1.00 34.51           C  
ATOM  10497  N   LYS F 184     -50.333  68.114  58.825  1.00 36.30           N  
ATOM  10498  CA  LYS F 184     -51.271  67.183  59.466  1.00 36.65           C  
ATOM  10499  C   LYS F 184     -50.893  65.707  59.301  1.00 35.39           C  
ATOM  10500  O   LYS F 184     -51.493  64.858  59.917  1.00 33.98           O  
ATOM  10501  CB  LYS F 184     -52.691  67.402  58.932  1.00 37.02           C  
ATOM  10502  CG  LYS F 184     -53.327  68.700  59.358  1.00 34.77           C  
ATOM  10503  CD  LYS F 184     -54.785  68.716  58.962  1.00 39.72           C  
ATOM  10504  CE  LYS F 184     -55.494  69.997  59.382  1.00 44.66           C  
ATOM  10505  NZ  LYS F 184     -54.920  71.210  58.751  1.00 45.15           N  
ATOM  10506  N   LYS F 185     -49.907  65.419  58.459  1.00 38.74           N  
ATOM  10507  CA  LYS F 185     -49.350  64.066  58.252  1.00 38.72           C  
ATOM  10508  C   LYS F 185     -50.338  63.149  57.531  1.00 37.78           C  
ATOM  10509  O   LYS F 185     -50.227  61.941  57.615  1.00 40.57           O  
ATOM  10510  CB  LYS F 185     -48.869  63.424  59.574  1.00 39.67           C  
ATOM  10511  CG  LYS F 185     -47.843  64.250  60.404  1.00 42.19           C  
ATOM  10512  CD  LYS F 185     -46.401  64.087  59.914  1.00 44.48           C  
ATOM  10513  CE  LYS F 185     -45.352  64.165  61.066  1.00 49.73           C  
ATOM  10514  NZ  LYS F 185     -43.998  63.541  60.735  1.00 43.06           N  
ATOM  10515  N   TYR F 186     -51.285  63.729  56.796  1.00 36.02           N  
ATOM  10516  CA  TYR F 186     -52.289  62.962  56.056  1.00 33.18           C  
ATOM  10517  C   TYR F 186     -51.638  62.219  54.914  1.00 30.29           C  
ATOM  10518  O   TYR F 186     -50.609  62.642  54.411  1.00 30.77           O  
ATOM  10519  CB  TYR F 186     -53.369  63.885  55.496  1.00 31.80           C  
ATOM  10520  CG  TYR F 186     -54.437  64.277  56.484  1.00 31.02           C  
ATOM  10521  CD1 TYR F 186     -54.168  64.360  57.847  1.00 37.37           C  
ATOM  10522  CD2 TYR F 186     -55.708  64.602  56.057  1.00 29.78           C  
ATOM  10523  CE1 TYR F 186     -55.145  64.734  58.759  1.00 34.49           C  
ATOM  10524  CE2 TYR F 186     -56.685  64.976  56.952  1.00 36.33           C  
ATOM  10525  CZ  TYR F 186     -56.394  65.040  58.306  1.00 34.53           C  
ATOM  10526  OH  TYR F 186     -57.351  65.411  59.204  1.00 31.53           O  
ATOM  10527  N   ARG F 187     -52.238  61.111  54.516  1.00 27.56           N  
ATOM  10528  CA  ARG F 187     -51.835  60.433  53.294  1.00 27.59           C  
ATOM  10529  C   ARG F 187     -51.962  61.363  52.109  1.00 25.51           C  
ATOM  10530  O   ARG F 187     -52.948  62.094  51.974  1.00 25.49           O  
ATOM  10531  CB  ARG F 187     -52.681  59.186  53.059  1.00 28.91           C  
ATOM  10532  CG  ARG F 187     -52.470  58.149  54.133  1.00 28.92           C  
ATOM  10533  CD  ARG F 187     -53.275  56.920  53.849  1.00 33.84           C  
ATOM  10534  NE  ARG F 187     -54.128  56.652  54.990  1.00 45.01           N  
ATOM  10535  CZ  ARG F 187     -55.407  56.962  55.077  1.00 38.15           C  
ATOM  10536  NH1 ARG F 187     -56.042  57.502  54.070  1.00 44.40           N  
ATOM  10537  NH2 ARG F 187     -56.061  56.699  56.188  1.00 38.93           N  
ATOM  10538  N   TYR F 188     -50.960  61.338  51.248  1.00 25.28           N  
ATOM  10539  CA  TYR F 188     -50.863  62.318  50.177  1.00 25.74           C  
ATOM  10540  C   TYR F 188     -50.585  61.707  48.792  1.00 25.88           C  
ATOM  10541  O   TYR F 188     -50.029  60.605  48.678  1.00 25.67           O  
ATOM  10542  CB  TYR F 188     -49.791  63.369  50.544  1.00 25.79           C  
ATOM  10543  CG  TYR F 188     -48.389  62.815  50.717  1.00 26.05           C  
ATOM  10544  CD1 TYR F 188     -47.564  62.575  49.605  1.00 25.77           C  
ATOM  10545  CD2 TYR F 188     -47.899  62.496  51.981  1.00 24.35           C  
ATOM  10546  CE1 TYR F 188     -46.279  62.041  49.757  1.00 24.75           C  
ATOM  10547  CE2 TYR F 188     -46.623  61.974  52.147  1.00 25.72           C  
ATOM  10548  CZ  TYR F 188     -45.816  61.747  51.034  1.00 24.99           C  
ATOM  10549  OH  TYR F 188     -44.560  61.221  51.210  1.00 23.01           O  
ATOM  10550  N   VAL F 189     -51.004  62.450  47.764  1.00 26.93           N  
ATOM  10551  CA  VAL F 189     -50.571  62.304  46.371  1.00 26.22           C  
ATOM  10552  C   VAL F 189     -50.369  63.679  45.768  1.00 26.21           C  
ATOM  10553  O   VAL F 189     -50.829  64.686  46.311  1.00 26.37           O  
ATOM  10554  CB  VAL F 189     -51.608  61.585  45.461  1.00 28.48           C  
ATOM  10555  CG1 VAL F 189     -51.647  60.122  45.746  1.00 32.32           C  
ATOM  10556  CG2 VAL F 189     -52.991  62.203  45.597  1.00 30.97           C  
ATOM  10557  N   ALA F 190     -49.699  63.719  44.629  1.00 25.30           N  
ATOM  10558  CA  ALA F 190     -49.438  64.958  43.929  1.00 27.18           C  
ATOM  10559  C   ALA F 190     -49.766  64.741  42.475  1.00 26.64           C  
ATOM  10560  O   ALA F 190     -49.305  63.773  41.917  1.00 26.55           O  
ATOM  10561  CB  ALA F 190     -47.997  65.328  44.067  1.00 28.25           C  
ATOM  10562  N   ASN F 191     -50.561  65.622  41.867  1.00 27.65           N  
ATOM  10563  CA  ASN F 191     -50.977  65.457  40.456  1.00 29.23           C  
ATOM  10564  C   ASN F 191     -50.889  66.722  39.643  1.00 27.08           C  
ATOM  10565  O   ASN F 191     -50.631  67.767  40.172  1.00 27.67           O  
ATOM  10566  CB  ASN F 191     -52.405  64.932  40.382  1.00 28.31           C  
ATOM  10567  CG  ASN F 191     -52.617  63.768  41.286  1.00 31.34           C  
ATOM  10568  OD1 ASN F 191     -52.083  62.674  41.042  1.00 28.01           O  
ATOM  10569  ND2 ASN F 191     -53.368  63.989  42.371  1.00 23.89           N  
ATOM  10570  N   SER F 192     -51.099  66.621  38.340  1.00 27.55           N  
ATOM  10571  CA  SER F 192     -51.091  67.811  37.491  1.00 28.42           C  
ATOM  10572  C   SER F 192     -52.388  68.641  37.585  1.00 25.58           C  
ATOM  10573  O   SER F 192     -52.318  69.855  37.566  1.00 26.79           O  
ATOM  10574  CB  SER F 192     -50.815  67.451  36.016  1.00 28.30           C  
ATOM  10575  OG  SER F 192     -51.787  66.535  35.525  1.00 27.59           O  
ATOM  10576  N   ASP F 193     -53.539  67.978  37.676  1.00 24.74           N  
ATOM  10577  CA  ASP F 193     -54.835  68.591  37.374  1.00 24.16           C  
ATOM  10578  C   ASP F 193     -54.778  69.161  35.943  1.00 22.79           C  
ATOM  10579  O   ASP F 193     -55.097  70.308  35.691  1.00 19.62           O  
ATOM  10580  CB  ASP F 193     -55.164  69.666  38.409  1.00 25.71           C  
ATOM  10581  CG  ASP F 193     -56.549  70.265  38.232  1.00 22.69           C  
ATOM  10582  OD1 ASP F 193     -57.466  69.558  37.773  1.00 28.71           O  
ATOM  10583  OD2 ASP F 193     -56.708  71.453  38.582  1.00 31.90           O  
ATOM  10584  N   PHE F 194     -54.358  68.313  35.020  1.00 23.75           N  
ATOM  10585  CA  PHE F 194     -54.039  68.692  33.656  1.00 26.27           C  
ATOM  10586  C   PHE F 194     -55.258  69.194  32.877  1.00 25.26           C  
ATOM  10587  O   PHE F 194     -56.258  68.505  32.799  1.00 26.12           O  
ATOM  10588  CB  PHE F 194     -53.459  67.458  32.936  1.00 26.25           C  
ATOM  10589  CG  PHE F 194     -52.989  67.727  31.537  1.00 25.17           C  
ATOM  10590  CD1 PHE F 194     -53.854  67.627  30.464  1.00 21.99           C  
ATOM  10591  CD2 PHE F 194     -51.688  68.058  31.289  1.00 24.15           C  
ATOM  10592  CE1 PHE F 194     -53.437  67.886  29.185  1.00 20.52           C  
ATOM  10593  CE2 PHE F 194     -51.270  68.315  30.013  1.00 25.51           C  
ATOM  10594  CZ  PHE F 194     -52.152  68.215  28.959  1.00 27.80           C  
ATOM  10595  N   HIS F 195     -55.165  70.388  32.311  1.00 22.43           N  
ATOM  10596  CA  HIS F 195     -56.132  70.853  31.329  1.00 24.94           C  
ATOM  10597  C   HIS F 195     -55.453  71.229  30.015  1.00 24.84           C  
ATOM  10598  O   HIS F 195     -56.006  71.004  28.946  1.00 24.72           O  
ATOM  10599  CB  HIS F 195     -56.948  72.035  31.894  1.00 23.86           C  
ATOM  10600  CG  HIS F 195     -57.870  71.639  33.002  1.00 26.46           C  
ATOM  10601  ND1 HIS F 195     -57.418  71.187  34.224  1.00 23.87           N  
ATOM  10602  CD2 HIS F 195     -59.218  71.584  33.060  1.00 28.85           C  
ATOM  10603  CE1 HIS F 195     -58.446  70.882  34.988  1.00 26.24           C  
ATOM  10604  NE2 HIS F 195     -59.551  71.121  34.308  1.00 28.02           N  
ATOM  10605  N   GLU F 196     -54.235  71.751  30.131  1.00 25.04           N  
ATOM  10606  CA  GLU F 196     -53.496  72.409  29.089  1.00 26.52           C  
ATOM  10607  C   GLU F 196     -52.100  71.791  28.955  1.00 27.10           C  
ATOM  10608  O   GLU F 196     -51.515  71.336  29.938  1.00 26.65           O  
ATOM  10609  CB  GLU F 196     -53.303  73.868  29.489  1.00 28.28           C  
ATOM  10610  CG  GLU F 196     -54.579  74.619  29.808  1.00 34.80           C  
ATOM  10611  CD  GLU F 196     -55.318  75.090  28.573  1.00 37.56           C  
ATOM  10612  OE1 GLU F 196     -54.913  74.733  27.444  1.00 41.53           O  
ATOM  10613  OE2 GLU F 196     -56.303  75.830  28.744  1.00 40.80           O  
ATOM  10614  N   LEU F 197     -51.562  71.811  27.739  1.00 25.56           N  
ATOM  10615  CA  LEU F 197     -50.293  71.181  27.435  1.00 27.32           C  
ATOM  10616  C   LEU F 197     -49.259  71.347  28.569  1.00 27.67           C  
ATOM  10617  O   LEU F 197     -48.681  70.366  29.048  1.00 24.98           O  
ATOM  10618  CB  LEU F 197     -49.737  71.759  26.115  1.00 26.35           C  
ATOM  10619  CG  LEU F 197     -48.754  70.896  25.326  1.00 30.03           C  
ATOM  10620  CD1 LEU F 197     -48.535  71.486  23.948  1.00 36.35           C  
ATOM  10621  CD2 LEU F 197     -47.427  70.753  26.015  1.00 36.87           C  
ATOM  10622  N   TRP F 198     -49.043  72.600  28.979  1.00 26.92           N  
ATOM  10623  CA  TRP F 198     -47.947  72.977  29.861  1.00 25.97           C  
ATOM  10624  C   TRP F 198     -48.096  72.455  31.290  1.00 25.54           C  
ATOM  10625  O   TRP F 198     -47.140  72.502  32.056  1.00 25.39           O  
ATOM  10626  CB  TRP F 198     -47.721  74.503  29.834  1.00 25.76           C  
ATOM  10627  CG  TRP F 198     -48.913  75.335  30.185  1.00 28.54           C  
ATOM  10628  CD1 TRP F 198     -49.336  75.662  31.435  1.00 30.54           C  
ATOM  10629  CD2 TRP F 198     -49.847  75.947  29.272  1.00 29.78           C  
ATOM  10630  NE1 TRP F 198     -50.480  76.431  31.371  1.00 31.90           N  
ATOM  10631  CE2 TRP F 198     -50.812  76.629  30.057  1.00 32.19           C  
ATOM  10632  CE3 TRP F 198     -49.965  75.984  27.874  1.00 28.39           C  
ATOM  10633  CZ2 TRP F 198     -51.883  77.348  29.487  1.00 27.36           C  
ATOM  10634  CZ3 TRP F 198     -51.033  76.690  27.311  1.00 29.26           C  
ATOM  10635  CH2 TRP F 198     -51.975  77.363  28.120  1.00 27.62           C  
ATOM  10636  N   HIS F 199     -49.277  71.953  31.639  1.00 25.19           N  
ATOM  10637  CA  HIS F 199     -49.529  71.313  32.953  1.00 25.47           C  
ATOM  10638  C   HIS F 199     -48.893  69.944  33.087  1.00 26.63           C  
ATOM  10639  O   HIS F 199     -48.880  69.386  34.185  1.00 29.76           O  
ATOM  10640  CB  HIS F 199     -51.032  71.142  33.231  1.00 24.71           C  
ATOM  10641  CG  HIS F 199     -51.795  72.426  33.268  1.00 23.82           C  
ATOM  10642  ND1 HIS F 199     -53.135  72.498  32.972  1.00 24.55           N  
ATOM  10643  CD2 HIS F 199     -51.406  73.689  33.553  1.00 23.31           C  
ATOM  10644  CE1 HIS F 199     -53.542  73.749  33.060  1.00 22.35           C  
ATOM  10645  NE2 HIS F 199     -52.509  74.493  33.407  1.00 28.99           N  
ATOM  10646  N   VAL F 200     -48.393  69.376  31.994  1.00 24.96           N  
ATOM  10647  CA  VAL F 200     -47.712  68.097  32.069  1.00 26.25           C  
ATOM  10648  C   VAL F 200     -46.469  68.234  32.964  1.00 26.69           C  
ATOM  10649  O   VAL F 200     -46.141  67.312  33.695  1.00 27.35           O  
ATOM  10650  CB  VAL F 200     -47.372  67.548  30.654  1.00 27.37           C  
ATOM  10651  CG1 VAL F 200     -46.240  68.354  29.963  1.00 24.48           C  
ATOM  10652  CG2 VAL F 200     -47.043  66.075  30.712  1.00 28.70           C  
ATOM  10653  N   TYR F 201     -45.821  69.407  32.910  1.00 26.58           N  
ATOM  10654  CA  TYR F 201     -44.760  69.822  33.849  1.00 27.25           C  
ATOM  10655  C   TYR F 201     -45.396  70.273  35.170  1.00 26.27           C  
ATOM  10656  O   TYR F 201     -45.897  71.373  35.300  1.00 26.78           O  
ATOM  10657  CB  TYR F 201     -43.890  70.949  33.238  1.00 27.05           C  
ATOM  10658  CG  TYR F 201     -43.418  70.584  31.860  1.00 28.19           C  
ATOM  10659  CD1 TYR F 201     -42.580  69.502  31.676  1.00 29.36           C  
ATOM  10660  CD2 TYR F 201     -43.867  71.257  30.742  1.00 28.28           C  
ATOM  10661  CE1 TYR F 201     -42.182  69.115  30.439  1.00 30.01           C  
ATOM  10662  CE2 TYR F 201     -43.462  70.878  29.475  1.00 29.50           C  
ATOM  10663  CZ  TYR F 201     -42.617  69.806  29.340  1.00 29.56           C  
ATOM  10664  OH  TYR F 201     -42.182  69.397  28.115  1.00 27.70           O  
ATOM  10665  N   SER F 202     -45.388  69.387  36.147  1.00 25.76           N  
ATOM  10666  CA  SER F 202     -46.108  69.608  37.380  1.00 25.78           C  
ATOM  10667  C   SER F 202     -45.571  68.655  38.402  1.00 24.48           C  
ATOM  10668  O   SER F 202     -44.779  67.782  38.092  1.00 22.55           O  
ATOM  10669  CB  SER F 202     -47.600  69.296  37.195  1.00 26.58           C  
ATOM  10670  OG  SER F 202     -47.834  67.881  37.189  1.00 30.08           O  
ATOM  10671  N   TRP F 203     -46.058  68.819  39.619  1.00 25.38           N  
ATOM  10672  CA  TRP F 203     -45.883  67.840  40.653  1.00 25.79           C  
ATOM  10673  C   TRP F 203     -46.571  66.538  40.233  1.00 25.86           C  
ATOM  10674  O   TRP F 203     -47.620  66.555  39.619  1.00 26.00           O  
ATOM  10675  CB  TRP F 203     -46.434  68.381  41.975  1.00 25.16           C  
ATOM  10676  CG  TRP F 203     -45.531  69.445  42.576  1.00 27.67           C  
ATOM  10677  CD1 TRP F 203     -45.767  70.793  42.637  1.00 27.59           C  
ATOM  10678  CD2 TRP F 203     -44.230  69.243  43.166  1.00 30.95           C  
ATOM  10679  NE1 TRP F 203     -44.711  71.433  43.242  1.00 27.67           N  
ATOM  10680  CE2 TRP F 203     -43.754  70.507  43.571  1.00 27.96           C  
ATOM  10681  CE3 TRP F 203     -43.432  68.111  43.406  1.00 28.82           C  
ATOM  10682  CZ2 TRP F 203     -42.520  70.671  44.194  1.00 25.82           C  
ATOM  10683  CZ3 TRP F 203     -42.211  68.279  44.020  1.00 27.41           C  
ATOM  10684  CH2 TRP F 203     -41.770  69.541  44.416  1.00 27.52           C  
ATOM  10685  N   LYS F 204     -45.917  65.421  40.524  1.00 26.64           N  
ATOM  10686  CA  LYS F 204     -46.451  64.084  40.295  1.00 27.17           C  
ATOM  10687  C   LYS F 204     -46.177  63.231  41.533  1.00 26.61           C  
ATOM  10688  O   LYS F 204     -45.492  63.654  42.453  1.00 26.84           O  
ATOM  10689  CB  LYS F 204     -45.759  63.438  39.106  1.00 28.39           C  
ATOM  10690  CG  LYS F 204     -45.572  64.316  37.879  1.00 32.09           C  
ATOM  10691  CD  LYS F 204     -46.634  64.089  36.837  1.00 31.75           C  
ATOM  10692  CE  LYS F 204     -46.355  64.935  35.582  1.00 29.49           C  
ATOM  10693  NZ  LYS F 204     -47.531  65.765  35.239  1.00 25.56           N  
ATOM  10694  N   THR F 205     -46.702  62.021  41.539  1.00 26.73           N  
ATOM  10695  CA  THR F 205     -46.425  61.056  42.589  1.00 26.62           C  
ATOM  10696  C   THR F 205     -45.407  60.007  42.097  1.00 28.16           C  
ATOM  10697  O   THR F 205     -45.526  59.498  40.987  1.00 27.81           O  
ATOM  10698  CB  THR F 205     -47.695  60.298  42.992  1.00 26.46           C  
ATOM  10699  OG1 THR F 205     -48.802  61.191  43.052  1.00 24.81           O  
ATOM  10700  CG2 THR F 205     -47.519  59.620  44.343  1.00 28.47           C  
ATOM  10701  N   LEU F 206     -44.418  59.698  42.939  1.00 27.55           N  
ATOM  10702  CA  LEU F 206     -43.544  58.572  42.759  1.00 26.63           C  
ATOM  10703  C   LEU F 206     -43.952  57.541  43.822  1.00 28.05           C  
ATOM  10704  O   LEU F 206     -43.974  57.830  45.026  1.00 24.55           O  
ATOM  10705  CB  LEU F 206     -42.113  59.019  42.946  1.00 28.84           C  
ATOM  10706  CG  LEU F 206     -41.006  58.285  42.205  1.00 31.80           C  
ATOM  10707  CD1 LEU F 206     -41.001  58.579  40.708  1.00 30.84           C  
ATOM  10708  CD2 LEU F 206     -39.693  58.689  42.826  1.00 33.79           C  
ATOM  10709  N   VAL F 207     -44.328  56.347  43.372  1.00 28.53           N  
ATOM  10710  CA  VAL F 207     -44.725  55.302  44.287  1.00 28.96           C  
ATOM  10711  C   VAL F 207     -43.982  54.007  43.989  1.00 27.62           C  
ATOM  10712  O   VAL F 207     -43.820  53.618  42.843  1.00 27.22           O  
ATOM  10713  CB  VAL F 207     -46.265  55.080  44.300  1.00 31.46           C  
ATOM  10714  CG1 VAL F 207     -46.831  54.789  42.909  1.00 32.09           C  
ATOM  10715  CG2 VAL F 207     -46.635  53.944  45.278  1.00 33.56           C  
ATOM  10716  N   LYS F 208     -43.514  53.360  45.048  1.00 28.17           N  
ATOM  10717  CA  LYS F 208     -42.833  52.087  44.948  1.00 27.07           C  
ATOM  10718  C   LYS F 208     -43.920  51.040  44.952  1.00 26.75           C  
ATOM  10719  O   LYS F 208     -44.612  50.851  45.944  1.00 26.58           O  
ATOM  10720  CB  LYS F 208     -41.897  51.887  46.128  1.00 27.13           C  
ATOM  10721  CG  LYS F 208     -40.818  50.822  45.914  1.00 28.92           C  
ATOM  10722  CD  LYS F 208     -40.267  50.381  47.262  1.00 33.96           C  
ATOM  10723  CE  LYS F 208     -38.811  49.933  47.216  1.00 40.03           C  
ATOM  10724  NZ  LYS F 208     -38.480  48.965  46.143  1.00 42.98           N  
ATOM  10725  N   SER F 209     -44.117  50.401  43.811  1.00 28.02           N  
ATOM  10726  CA  SER F 209     -45.108  49.347  43.706  1.00 28.53           C  
ATOM  10727  C   SER F 209     -44.832  48.510  42.457  1.00 28.33           C  
ATOM  10728  O   SER F 209     -44.139  48.956  41.542  1.00 28.32           O  
ATOM  10729  CB  SER F 209     -46.536  49.951  43.741  1.00 27.62           C  
ATOM  10730  OG  SER F 209     -47.310  49.729  42.590  1.00 24.79           O  
ATOM  10731  N   GLU F 210     -45.374  47.300  42.439  1.00 28.85           N  
ATOM  10732  CA  GLU F 210     -45.459  46.497  41.213  1.00 28.41           C  
ATOM  10733  C   GLU F 210     -46.281  47.258  40.195  1.00 27.02           C  
ATOM  10734  O   GLU F 210     -47.218  48.001  40.546  1.00 26.42           O  
ATOM  10735  CB  GLU F 210     -46.106  45.133  41.503  1.00 29.70           C  
ATOM  10736  CG  GLU F 210     -45.325  44.212  42.495  1.00 34.22           C  
ATOM  10737  CD  GLU F 210     -45.680  44.438  43.992  1.00 42.93           C  
ATOM  10738  OE1 GLU F 210     -46.281  45.515  44.358  1.00 36.64           O  
ATOM  10739  OE2 GLU F 210     -45.359  43.517  44.801  1.00 33.05           O  
ATOM  10740  N   LYS F 211     -45.952  47.100  38.926  1.00 27.84           N  
ATOM  10741  CA  LYS F 211     -46.647  47.861  37.877  1.00 29.88           C  
ATOM  10742  C   LYS F 211     -47.960  47.163  37.459  1.00 28.73           C  
ATOM  10743  O   LYS F 211     -48.084  46.601  36.373  1.00 28.08           O  
ATOM  10744  CB  LYS F 211     -45.717  48.112  36.693  1.00 29.16           C  
ATOM  10745  CG  LYS F 211     -46.143  49.284  35.808  1.00 35.37           C  
ATOM  10746  CD  LYS F 211     -45.086  49.597  34.738  1.00 37.32           C  
ATOM  10747  CE  LYS F 211     -45.533  50.803  33.863  1.00 44.69           C  
ATOM  10748  NZ  LYS F 211     -44.428  51.378  33.024  1.00 48.20           N  
ATOM  10749  N   ASN F 212     -48.929  47.179  38.368  1.00 30.12           N  
ATOM  10750  CA  ASN F 212     -50.279  46.731  38.079  1.00 28.95           C  
ATOM  10751  C   ASN F 212     -51.268  47.577  38.882  1.00 28.76           C  
ATOM  10752  O   ASN F 212     -50.950  48.077  39.954  1.00 28.97           O  
ATOM  10753  CB  ASN F 212     -50.415  45.218  38.321  1.00 27.80           C  
ATOM  10754  CG  ASN F 212     -50.587  44.850  39.774  1.00 27.70           C  
ATOM  10755  OD1 ASN F 212     -51.668  44.965  40.331  1.00 29.39           O  
ATOM  10756  ND2 ASN F 212     -49.540  44.349  40.379  1.00 28.37           N  
ATOM  10757  N   ILE F 213     -52.470  47.729  38.356  1.00 28.33           N  
ATOM  10758  CA  ILE F 213     -53.433  48.644  38.923  1.00 26.75           C  
ATOM  10759  C   ILE F 213     -53.748  48.311  40.391  1.00 26.35           C  
ATOM  10760  O   ILE F 213     -53.673  49.195  41.246  1.00 24.10           O  
ATOM  10761  CB  ILE F 213     -54.672  48.715  38.034  1.00 26.89           C  
ATOM  10762  CG1 ILE F 213     -54.270  49.358  36.705  1.00 28.04           C  
ATOM  10763  CG2 ILE F 213     -55.798  49.507  38.696  1.00 26.45           C  
ATOM  10764  CD1 ILE F 213     -55.320  49.334  35.666  1.00 26.09           C  
ATOM  10765  N   GLU F 214     -54.044  47.054  40.706  1.00 23.55           N  
ATOM  10766  CA  GLU F 214     -54.313  46.714  42.103  1.00 25.67           C  
ATOM  10767  C   GLU F 214     -53.143  47.084  43.012  1.00 25.64           C  
ATOM  10768  O   GLU F 214     -53.329  47.736  44.016  1.00 25.74           O  
ATOM  10769  CB  GLU F 214     -54.687  45.239  42.290  1.00 23.62           C  
ATOM  10770  CG  GLU F 214     -56.082  44.899  41.800  1.00 29.63           C  
ATOM  10771  CD  GLU F 214     -57.171  45.850  42.341  1.00 34.15           C  
ATOM  10772  OE1 GLU F 214     -57.393  45.884  43.585  1.00 31.73           O  
ATOM  10773  OE2 GLU F 214     -57.802  46.561  41.511  1.00 32.23           O  
ATOM  10774  N   ALA F 215     -51.940  46.682  42.650  1.00 26.91           N  
ATOM  10775  CA  ALA F 215     -50.780  47.009  43.453  1.00 28.07           C  
ATOM  10776  C   ALA F 215     -50.637  48.516  43.681  1.00 28.11           C  
ATOM  10777  O   ALA F 215     -50.424  48.932  44.817  1.00 27.62           O  
ATOM  10778  CB  ALA F 215     -49.512  46.442  42.820  1.00 28.20           C  
ATOM  10779  N   ILE F 216     -50.755  49.317  42.612  1.00 26.93           N  
ATOM  10780  CA  ILE F 216     -50.652  50.778  42.711  1.00 26.54           C  
ATOM  10781  C   ILE F 216     -51.704  51.374  43.662  1.00 24.63           C  
ATOM  10782  O   ILE F 216     -51.403  52.201  44.501  1.00 23.89           O  
ATOM  10783  CB  ILE F 216     -50.816  51.482  41.312  1.00 26.98           C  
ATOM  10784  CG1 ILE F 216     -49.664  51.145  40.360  1.00 28.82           C  
ATOM  10785  CG2 ILE F 216     -50.923  53.022  41.473  1.00 27.40           C  
ATOM  10786  CD1 ILE F 216     -49.981  51.384  38.900  1.00 28.01           C  
ATOM  10787  N   LYS F 217     -52.950  50.997  43.498  1.00 24.02           N  
ATOM  10788  CA  LYS F 217     -53.975  51.441  44.430  1.00 27.14           C  
ATOM  10789  C   LYS F 217     -53.590  51.099  45.877  1.00 25.53           C  
ATOM  10790  O   LYS F 217     -53.716  51.945  46.742  1.00 24.51           O  
ATOM  10791  CB  LYS F 217     -55.360  50.856  44.084  1.00 26.86           C  
ATOM  10792  CG  LYS F 217     -55.948  51.376  42.761  1.00 28.70           C  
ATOM  10793  CD  LYS F 217     -57.383  50.888  42.572  1.00 26.22           C  
ATOM  10794  CE  LYS F 217     -57.438  49.418  42.309  1.00 23.19           C  
ATOM  10795  NZ  LYS F 217     -58.738  48.977  41.744  1.00 27.51           N  
ATOM  10796  N   GLU F 218     -53.106  49.885  46.116  1.00 23.69           N  
ATOM  10797  CA  GLU F 218     -52.697  49.470  47.454  1.00 27.96           C  
ATOM  10798  C   GLU F 218     -51.574  50.343  47.992  1.00 26.50           C  
ATOM  10799  O   GLU F 218     -51.596  50.728  49.153  1.00 25.01           O  
ATOM  10800  CB  GLU F 218     -52.244  47.997  47.480  1.00 27.56           C  
ATOM  10801  CG  GLU F 218     -51.961  47.461  48.887  1.00 32.35           C  
ATOM  10802  CD  GLU F 218     -51.325  46.063  48.914  1.00 32.45           C  
ATOM  10803  OE1 GLU F 218     -50.850  45.561  47.879  1.00 41.15           O  
ATOM  10804  OE2 GLU F 218     -51.288  45.460  50.004  1.00 44.61           O  
ATOM  10805  N   ALA F 219     -50.592  50.641  47.149  1.00 25.44           N  
ATOM  10806  CA  ALA F 219     -49.437  51.426  47.584  1.00 27.17           C  
ATOM  10807  C   ALA F 219     -49.817  52.854  47.992  1.00 27.59           C  
ATOM  10808  O   ALA F 219     -49.314  53.354  49.007  1.00 27.81           O  
ATOM  10809  CB  ALA F 219     -48.317  51.427  46.534  1.00 24.01           C  
ATOM  10810  N   ILE F 220     -50.695  53.497  47.219  1.00 28.25           N  
ATOM  10811  CA  ILE F 220     -51.176  54.848  47.554  1.00 29.03           C  
ATOM  10812  C   ILE F 220     -51.920  54.855  48.887  1.00 30.35           C  
ATOM  10813  O   ILE F 220     -51.719  55.768  49.672  1.00 29.58           O  
ATOM  10814  CB  ILE F 220     -52.104  55.451  46.474  1.00 29.15           C  
ATOM  10815  CG1 ILE F 220     -51.403  55.571  45.102  1.00 29.80           C  
ATOM  10816  CG2 ILE F 220     -52.627  56.827  46.929  1.00 32.17           C  
ATOM  10817  CD1 ILE F 220     -50.154  56.356  45.131  1.00 28.90           C  
ATOM  10818  N   ARG F 221     -52.763  53.835  49.115  1.00 31.17           N  
ATOM  10819  CA  ARG F 221     -53.523  53.662  50.354  1.00 33.58           C  
ATOM  10820  C   ARG F 221     -52.606  53.491  51.548  1.00 32.12           C  
ATOM  10821  O   ARG F 221     -52.829  54.124  52.553  1.00 32.51           O  
ATOM  10822  CB  ARG F 221     -54.468  52.445  50.288  1.00 33.18           C  
ATOM  10823  CG  ARG F 221     -55.946  52.752  50.269  1.00 40.22           C  
ATOM  10824  CD  ARG F 221     -56.825  51.487  50.340  1.00 39.62           C  
ATOM  10825  NE  ARG F 221     -56.638  50.588  49.193  1.00 46.96           N  
ATOM  10826  CZ  ARG F 221     -57.311  50.639  48.044  1.00 47.82           C  
ATOM  10827  NH1 ARG F 221     -58.251  51.548  47.830  1.00 49.75           N  
ATOM  10828  N   LYS F 222     -51.621  52.594  51.453  1.00 31.52           N  
ATOM  10829  CA  LYS F 222     -50.611  52.442  52.501  1.00 33.57           C  
ATOM  10830  C   LYS F 222     -49.936  53.783  52.748  1.00 30.77           C  
ATOM  10831  O   LYS F 222     -49.776  54.180  53.886  1.00 28.89           O  
ATOM  10832  CB  LYS F 222     -49.532  51.398  52.145  1.00 33.10           C  
ATOM  10833  CG  LYS F 222     -49.777  50.018  52.693  1.00 40.76           C  
ATOM  10834  CD  LYS F 222     -48.882  48.935  52.021  1.00 42.04           C  
ATOM  10835  CE  LYS F 222     -49.167  47.480  52.558  1.00 48.11           C  
ATOM  10836  NZ  LYS F 222     -50.629  47.116  52.702  1.00 46.37           N  
ATOM  10837  N   ASN F 223     -49.533  54.441  51.660  1.00 29.16           N  
ATOM  10838  CA  ASN F 223     -48.841  55.734  51.676  1.00 29.36           C  
ATOM  10839  C   ASN F 223     -47.467  55.746  52.417  1.00 28.86           C  
ATOM  10840  O   ASN F 223     -47.031  56.762  52.907  1.00 29.63           O  
ATOM  10841  CB  ASN F 223     -49.801  56.852  52.175  1.00 28.21           C  
ATOM  10842  CG  ASN F 223     -49.674  58.136  51.369  1.00 26.13           C  
ATOM  10843  OD1 ASN F 223     -49.137  59.121  51.851  1.00 26.46           O  
ATOM  10844  ND2 ASN F 223     -50.150  58.123  50.126  1.00 16.91           N  
ATOM  10845  N   THR F 224     -46.771  54.622  52.485  1.00 29.59           N  
ATOM  10846  CA  THR F 224     -45.441  54.588  53.112  1.00 29.43           C  
ATOM  10847  C   THR F 224     -44.293  54.681  52.108  1.00 28.91           C  
ATOM  10848  O   THR F 224     -43.172  54.989  52.497  1.00 31.52           O  
ATOM  10849  CB  THR F 224     -45.259  53.322  53.954  1.00 29.06           C  
ATOM  10850  OG1 THR F 224     -45.494  52.179  53.130  1.00 31.61           O  
ATOM  10851  CG2 THR F 224     -46.247  53.315  55.101  1.00 29.20           C  
ATOM  10852  N   ASP F 225     -44.553  54.380  50.842  1.00 27.52           N  
ATOM  10853  CA  ASP F 225     -43.539  54.532  49.801  1.00 29.17           C  
ATOM  10854  C   ASP F 225     -44.085  55.411  48.684  1.00 27.83           C  
ATOM  10855  O   ASP F 225     -44.143  55.010  47.514  1.00 25.52           O  
ATOM  10856  CB  ASP F 225     -43.099  53.176  49.253  1.00 30.91           C  
ATOM  10857  CG  ASP F 225     -42.495  52.284  50.318  1.00 33.06           C  
ATOM  10858  OD1 ASP F 225     -41.490  52.673  50.955  1.00 35.00           O  
ATOM  10859  OD2 ASP F 225     -43.035  51.182  50.514  1.00 39.33           O  
ATOM  10860  N   VAL F 226     -44.507  56.607  49.092  1.00 26.59           N  
ATOM  10861  CA  VAL F 226     -45.010  57.621  48.200  1.00 26.14           C  
ATOM  10862  C   VAL F 226     -44.207  58.916  48.393  1.00 24.16           C  
ATOM  10863  O   VAL F 226     -44.020  59.397  49.502  1.00 22.09           O  
ATOM  10864  CB  VAL F 226     -46.515  57.902  48.422  1.00 25.59           C  
ATOM  10865  CG1 VAL F 226     -46.995  58.870  47.402  1.00 25.42           C  
ATOM  10866  CG2 VAL F 226     -47.322  56.623  48.313  1.00 27.92           C  
ATOM  10867  N   ALA F 227     -43.741  59.455  47.276  1.00 23.82           N  
ATOM  10868  CA  ALA F 227     -42.973  60.657  47.259  1.00 24.13           C  
ATOM  10869  C   ALA F 227     -43.556  61.563  46.210  1.00 24.77           C  
ATOM  10870  O   ALA F 227     -44.373  61.138  45.388  1.00 22.41           O  
ATOM  10871  CB  ALA F 227     -41.533  60.342  46.942  1.00 24.36           C  
ATOM  10872  N   ILE F 228     -43.141  62.823  46.241  1.00 26.17           N  
ATOM  10873  CA  ILE F 228     -43.628  63.777  45.263  1.00 27.83           C  
ATOM  10874  C   ILE F 228     -42.472  64.330  44.459  1.00 25.45           C  
ATOM  10875  O   ILE F 228     -41.383  64.547  44.977  1.00 23.65           O  
ATOM  10876  CB  ILE F 228     -44.582  64.855  45.890  1.00 28.88           C  
ATOM  10877  CG1 ILE F 228     -43.858  65.850  46.777  1.00 28.33           C  
ATOM  10878  CG2 ILE F 228     -45.685  64.166  46.697  1.00 32.18           C  
ATOM  10879  CD1 ILE F 228     -44.808  66.831  47.401  1.00 30.53           C  
ATOM  10880  N   TYR F 229     -42.731  64.543  43.179  1.00 25.25           N  
ATOM  10881  CA  TYR F 229     -41.684  64.719  42.197  1.00 25.82           C  
ATOM  10882  C   TYR F 229     -42.092  65.826  41.253  1.00 25.89           C  
ATOM  10883  O   TYR F 229     -43.172  65.770  40.697  1.00 26.41           O  
ATOM  10884  CB  TYR F 229     -41.525  63.397  41.438  1.00 27.54           C  
ATOM  10885  CG  TYR F 229     -40.652  63.498  40.219  1.00 29.92           C  
ATOM  10886  CD1 TYR F 229     -41.169  63.936  39.000  1.00 28.42           C  
ATOM  10887  CD2 TYR F 229     -39.303  63.173  40.289  1.00 31.24           C  
ATOM  10888  CE1 TYR F 229     -40.367  64.034  37.881  1.00 31.17           C  
ATOM  10889  CE2 TYR F 229     -38.504  63.264  39.184  1.00 37.99           C  
ATOM  10890  CZ  TYR F 229     -39.036  63.693  37.977  1.00 35.27           C  
ATOM  10891  OH  TYR F 229     -38.214  63.804  36.886  1.00 35.43           O  
ATOM  10892  N   LEU F 230     -41.261  66.846  41.076  1.00 28.24           N  
ATOM  10893  CA  LEU F 230     -41.646  67.950  40.194  1.00 30.94           C  
ATOM  10894  C   LEU F 230     -41.092  67.691  38.807  1.00 32.01           C  
ATOM  10895  O   LEU F 230     -39.880  67.708  38.632  1.00 31.42           O  
ATOM  10896  CB  LEU F 230     -41.144  69.299  40.729  1.00 29.83           C  
ATOM  10897  CG  LEU F 230     -41.517  70.547  39.914  1.00 29.88           C  
ATOM  10898  CD1 LEU F 230     -42.986  70.713  39.845  1.00 31.91           C  
ATOM  10899  CD2 LEU F 230     -40.918  71.811  40.493  1.00 31.36           C  
HETATM10900  N   MSE F 231     -41.961  67.433  37.831  1.00 33.69           N  
HETATM10901  CA  MSE F 231     -41.509  67.302  36.438  1.00 39.04           C  
HETATM10902  C   MSE F 231     -41.301  68.664  35.762  1.00 35.85           C  
HETATM10903  O   MSE F 231     -42.195  69.512  35.710  1.00 34.61           O  
HETATM10904  CB  MSE F 231     -42.479  66.458  35.634  1.00 38.72           C  
HETATM10905  CG  MSE F 231     -41.983  66.090  34.234  1.00 45.29           C  
HETATM10906 SE   MSE F 231     -43.049  64.605  33.434  1.00 52.96          SE  
HETATM10907  CE  MSE F 231     -41.893  63.181  33.747  1.00 58.01           C  
ATOM  10908  N   ARG F 232     -40.103  68.879  35.251  1.00 35.88           N  
ATOM  10909  CA  ARG F 232     -39.778  70.165  34.606  1.00 38.14           C  
ATOM  10910  C   ARG F 232     -39.292  69.976  33.173  1.00 36.09           C  
ATOM  10911  O   ARG F 232     -38.824  68.903  32.810  1.00 33.71           O  
ATOM  10912  CB  ARG F 232     -38.757  70.933  35.443  1.00 37.93           C  
ATOM  10913  CG  ARG F 232     -39.296  71.318  36.811  1.00 40.28           C  
ATOM  10914  CD  ARG F 232     -38.209  71.775  37.753  1.00 44.88           C  
ATOM  10915  NE  ARG F 232     -37.352  70.666  38.172  1.00 50.68           N  
ATOM  10916  CZ  ARG F 232     -36.399  70.741  39.097  1.00 42.83           C  
ATOM  10917  NH1 ARG F 232     -36.166  71.861  39.747  1.00 41.23           N  
ATOM  10918  NH2 ARG F 232     -35.697  69.673  39.386  1.00 41.22           N  
ATOM  10919  N   LYS F 233     -39.435  71.009  32.351  1.00 36.42           N  
ATOM  10920  CA  LYS F 233     -38.986  70.899  30.962  1.00 38.05           C  
ATOM  10921  C   LYS F 233     -37.472  70.695  30.978  1.00 38.04           C  
ATOM  10922  O   LYS F 233     -36.746  71.528  31.525  1.00 37.01           O  
ATOM  10923  CB  LYS F 233     -39.373  72.131  30.121  1.00 37.66           C  
ATOM  10924  CG  LYS F 233     -39.388  71.843  28.611  1.00 39.46           C  
ATOM  10925  CD  LYS F 233     -40.166  72.889  27.795  1.00 40.42           C  
TER   10926      LYS F 233                                                      
END
MOLECULE T0440.pdb
ATOM      1  N   MET     1     -40.847  56.255  40.680  1.00 38.33           N  
ATOM      2  CA  MET     1     -42.194  56.148  40.050  1.00 38.30           C  
ATOM      3  C   MET     1     -42.716  57.542  39.716  1.00 37.02           C  
ATOM      4  O   MET     1     -42.489  58.495  40.460  1.00 38.04           O  
ATOM      5  CB  MET     1     -43.162  55.432  40.998  1.00 38.58           C  
ATOM      6  N   LYS     2     -43.418  57.657  38.596  1.00 34.84           N  
ATOM      7  CA  LYS     2     -43.956  58.939  38.166  1.00 32.15           C  
ATOM      8  C   LYS     2     -45.432  58.763  37.827  1.00 29.78           C  
ATOM      9  O   LYS     2     -45.783  58.072  36.873  1.00 28.95           O  
ATOM     10  CB  LYS     2     -43.171  59.436  36.954  1.00 32.26           C  
ATOM     11  CG  LYS     2     -43.327  60.909  36.662  1.00 33.32           C  
ATOM     12  CD  LYS     2     -42.210  61.393  35.744  1.00 34.91           C  
ATOM     13  CE  LYS     2     -42.404  62.847  35.345  1.00 35.48           C  
ATOM     14  NZ  LYS     2     -41.315  63.305  34.439  1.00 34.78           N  
ATOM     15  N   ARG     3     -46.294  59.397  38.614  1.00 27.55           N  
ATOM     16  CA  ARG     3     -47.737  59.274  38.428  1.00 24.76           C  
ATOM     17  C   ARG     3     -48.481  60.606  38.323  1.00 23.58           C  
ATOM     18  O   ARG     3     -48.152  61.564  39.027  1.00 23.54           O  
ATOM     19  CB  ARG     3     -48.315  58.470  39.603  1.00 24.53           C  
ATOM     20  CG  ARG     3     -49.825  58.431  39.671  1.00 23.18           C  
ATOM     21  CD  ARG     3     -50.303  57.757  40.952  1.00 23.52           C  
ATOM     22  NE  ARG     3     -51.759  57.639  40.967  1.00 22.78           N  
ATOM     23  CZ  ARG     3     -52.478  57.305  42.034  1.00 24.08           C  
ATOM     24  NH1 ARG     3     -51.877  57.051  43.190  1.00 23.17           N  
ATOM     25  NH2 ARG     3     -53.799  57.235  41.944  1.00 23.37           N  
ATOM     26  N   ASP     4     -49.489  60.651  37.453  1.00 21.36           N  
ATOM     27  CA  ASP     4     -50.349  61.833  37.297  1.00 21.21           C  
ATOM     28  C   ASP     4     -51.779  61.354  37.579  1.00 20.57           C  
ATOM     29  O   ASP     4     -52.336  60.529  36.850  1.00 20.68           O  
ATOM     30  CB  ASP     4     -50.238  62.414  35.878  1.00 20.11           C  
ATOM     31  CG  ASP     4     -51.030  63.720  35.700  1.00 20.54           C  
ATOM     32  OD1 ASP     4     -50.882  64.365  34.638  1.00 19.64           O  
ATOM     33  OD2 ASP     4     -51.802  64.107  36.606  1.00 18.64           O  
ATOM     34  N   GLY     5     -52.367  61.850  38.657  1.00 20.40           N  
ATOM     35  CA  GLY     5     -53.705  61.409  39.010  1.00 20.01           C  
ATOM     36  C   GLY     5     -54.821  62.363  38.638  1.00 20.02           C  
ATOM     37  O   GLY     5     -55.908  62.305  39.214  1.00 20.91           O  
ATOM     38  N   HIS     6     -54.584  63.237  37.669  1.00 19.73           N  
ATOM     39  CA  HIS     6     -55.624  64.189  37.311  1.00 18.82           C  
ATOM     40  C   HIS     6     -55.457  64.720  35.893  1.00 19.13           C  
ATOM     41  O   HIS     6     -54.725  65.681  35.662  1.00 18.07           O  
ATOM     42  CB  HIS     6     -55.608  65.333  38.338  1.00 19.32           C  
ATOM     43  CG  HIS     6     -56.847  66.167  38.353  1.00 18.49           C  
ATOM     44  ND1 HIS     6     -57.222  66.916  39.448  1.00 18.33           N  
ATOM     45  CD2 HIS     6     -57.786  66.395  37.403  1.00 16.33           C  
ATOM     46  CE1 HIS     6     -58.337  67.569  39.173  1.00 18.17           C  
ATOM     47  NE2 HIS     6     -58.699  67.268  37.939  1.00 17.88           N  
ATOM     48  N   THR     7     -56.126  64.079  34.935  1.00 18.69           N  
ATOM     49  CA  THR     7     -56.060  64.524  33.544  1.00 19.68           C  
ATOM     50  C   THR     7     -57.433  64.486  32.878  1.00 19.99           C  
ATOM     51  O   THR     7     -58.336  63.776  33.321  1.00 19.96           O  
ATOM     52  CB  THR     7     -55.105  63.661  32.712  1.00 19.49           C  
ATOM     53  OG1 THR     7     -55.690  62.369  32.511  1.00 19.21           O  
ATOM     54  CG2 THR     7     -53.754  63.517  33.427  1.00 17.78           C  
ATOM     55  N   HIS     8     -57.578  65.246  31.801  1.00 20.50           N  
ATOM     56  CA  HIS     8     -58.843  65.320  31.089  1.00 21.17           C  
ATOM     57  C   HIS     8     -58.718  64.908  29.625  1.00 21.62           C  
ATOM     58  O   HIS     8     -57.622  64.609  29.152  1.00 20.75           O  
ATOM     59  CB  HIS     8     -59.424  66.723  31.246  1.00 20.98           C  
ATOM     60  CG  HIS     8     -59.872  67.012  32.644  1.00 22.64           C  
ATOM     61  ND1 HIS     8     -61.104  66.621  33.126  1.00 21.49           N  
ATOM     62  CD2 HIS     8     -59.225  67.585  33.687  1.00 23.08           C  
ATOM     63  CE1 HIS     8     -61.199  66.946  34.404  1.00 20.90           C  
ATOM     64  NE2 HIS     8     -60.072  67.532  34.768  1.00 22.21           N  
ATOM     65  N   THR     9     -59.844  64.889  28.914  1.00 22.45           N  
ATOM     66  CA  THR     9     -59.865  64.419  27.533  1.00 23.50           C  
ATOM     67  C   THR     9     -60.677  65.284  26.581  1.00 24.81           C  
ATOM     68  O   THR     9     -61.152  66.362  26.940  1.00 25.56           O  
ATOM     69  CB  THR     9     -60.464  63.000  27.457  1.00 23.68           C  
ATOM     70  OG1 THR     9     -61.875  63.067  27.717  1.00 23.01           O  
ATOM     71  CG2 THR     9     -59.815  62.089  28.491  1.00 22.69           C  
ATOM     72  N   GLU    10     -60.854  64.776  25.363  1.00 25.86           N  
ATOM     73  CA  GLU    10     -61.629  65.464  24.341  1.00 26.95           C  
ATOM     74  C   GLU    10     -63.112  65.482  24.720  1.00 27.63           C  
ATOM     75  O   GLU    10     -63.914  66.177  24.093  1.00 27.20           O  
ATOM     76  CB  GLU    10     -61.447  64.784  22.975  1.00 26.58           C  
ATOM     77  CG  GLU    10     -61.990  63.350  22.881  1.00 28.00           C  
ATOM     78  CD  GLU    10     -60.990  62.282  23.326  1.00 27.24           C  
ATOM     79  OE1 GLU    10     -59.975  62.623  23.972  1.00 27.48           O  
ATOM     80  OE2 GLU    10     -61.231  61.091  23.030  1.00 28.62           O  
ATOM     81  N   PHE    11     -63.469  64.710  25.743  1.00 28.15           N  
ATOM     82  CA  PHE    11     -64.850  64.645  26.213  1.00 29.40           C  
ATOM     83  C   PHE    11     -65.169  65.811  27.149  1.00 30.59           C  
ATOM     84  O   PHE    11     -66.269  65.897  27.691  1.00 31.46           O  
ATOM     85  CB  PHE    11     -65.101  63.312  26.925  1.00 29.24           C  
ATOM     86  CG  PHE    11     -65.374  62.170  25.988  1.00 30.30           C  
ATOM     87  CD1 PHE    11     -66.669  61.909  25.548  1.00 31.04           C  
ATOM     88  CD2 PHE    11     -64.338  61.359  25.537  1.00 30.49           C  
ATOM     89  CE1 PHE    11     -66.927  60.860  24.675  1.00 31.64           C  
ATOM     90  CE2 PHE    11     -64.584  60.303  24.662  1.00 30.53           C  
ATOM     91  CZ  PHE    11     -65.881  60.053  24.231  1.00 31.61           C  
ATOM     92  N   CYS    12     -64.198  66.702  27.336  1.00 30.83           N  
ATOM     93  CA  CYS    12     -64.377  67.876  28.183  1.00 30.91           C  
ATOM     94  C   CYS    12     -64.749  69.059  27.296  1.00 30.93           C  
ATOM     95  O   CYS    12     -63.955  69.504  26.473  1.00 30.92           O  
ATOM     96  CB  CYS    12     -63.093  68.186  28.952  1.00 30.77           C  
ATOM     97  SG  CYS    12     -63.216  69.677  29.963  1.00 30.86           S  
ATOM     98  N   PRO    13     -65.964  69.596  27.467  1.00 31.17           N  
ATOM     99  CA  PRO    13     -66.439  70.729  26.666  1.00 31.95           C  
ATOM    100  C   PRO    13     -65.546  71.967  26.680  1.00 32.57           C  
ATOM    101  O   PRO    13     -65.465  72.678  25.685  1.00 33.04           O  
ATOM    102  CB  PRO    13     -67.825  71.005  27.248  1.00 32.07           C  
ATOM    103  CG  PRO    13     -68.247  69.662  27.785  1.00 31.94           C  
ATOM    104  CD  PRO    13     -66.982  69.188  28.446  1.00 30.62           C  
ATOM    105  N   HIS    14     -64.881  72.231  27.800  1.00 33.02           N  
ATOM    106  CA  HIS    14     -64.017  73.403  27.884  1.00 33.81           C  
ATOM    107  C   HIS    14     -62.537  73.078  27.732  1.00 34.20           C  
ATOM    108  O   HIS    14     -61.681  73.927  27.991  1.00 33.50           O  
ATOM    109  CB  HIS    14     -64.229  74.140  29.202  1.00 34.42           C  
ATOM    110  CG  HIS    14     -64.125  73.263  30.407  1.00 35.96           C  
ATOM    111  ND1 HIS    14     -65.183  72.510  30.871  1.00 37.33           N  
ATOM    112  CD2 HIS    14     -63.080  72.991  31.226  1.00 35.75           C  
ATOM    113  CE1 HIS    14     -64.794  71.812  31.923  1.00 38.40           C  
ATOM    114  NE2 HIS    14     -63.523  72.085  32.158  1.00 36.30           N  
ATOM    115  N   GLY    15     -62.232  71.846  27.335  1.00 33.93           N  
ATOM    116  CA  GLY    15     -60.844  71.474  27.143  1.00 34.73           C  
ATOM    117  C   GLY    15     -60.325  71.976  25.808  1.00 35.34           C  
ATOM    118  O   GLY    15     -61.019  72.691  25.084  1.00 35.68           O  
ATOM    119  N   THR    16     -59.106  71.586  25.473  1.00 34.96           N  
ATOM    120  CA  THR    16     -58.490  71.992  24.222  1.00 35.46           C  
ATOM    121  C   THR    16     -58.976  71.086  23.093  1.00 35.25           C  
ATOM    122  O   THR    16     -58.700  71.327  21.915  1.00 34.96           O  
ATOM    123  CB  THR    16     -56.962  71.876  24.321  1.00 35.94           C  
ATOM    124  OG1 THR    16     -56.356  72.537  23.204  1.00 40.50           O  
ATOM    125  CG2 THR    16     -56.556  70.415  24.321  1.00 33.61           C  
ATOM    126  N   HIS    17     -59.697  70.038  23.474  1.00 34.98           N  
ATOM    127  CA  HIS    17     -60.223  69.050  22.539  1.00 34.90           C  
ATOM    128  C   HIS    17     -59.154  68.156  21.921  1.00 34.06           C  
ATOM    129  O   HIS    17     -59.437  67.406  20.985  1.00 34.16           O  
ATOM    130  CB  HIS    17     -61.059  69.710  21.438  1.00 35.49           C  
ATOM    131  CG  HIS    17     -62.307  70.357  21.948  1.00 37.82           C  
ATOM    132  ND1 HIS    17     -62.357  71.684  22.316  1.00 39.69           N  
ATOM    133  CD2 HIS    17     -63.526  69.842  22.235  1.00 40.96           C  
ATOM    134  CE1 HIS    17     -63.552  71.958  22.810  1.00 41.61           C  
ATOM    135  NE2 HIS    17     -64.281  70.857  22.772  1.00 40.83           N  
ATOM    136  N   ASP    18     -57.927  68.229  22.438  1.00 32.37           N  
ATOM    137  CA  ASP    18     -56.877  67.346  21.942  1.00 31.29           C  
ATOM    138  C   ASP    18     -57.343  65.923  22.234  1.00 30.50           C  
ATOM    139  O   ASP    18     -58.133  65.692  23.152  1.00 30.14           O  
ATOM    140  CB  ASP    18     -55.544  67.555  22.670  1.00 31.24           C  
ATOM    141  CG  ASP    18     -54.868  68.866  22.318  1.00 31.81           C  
ATOM    142  OD1 ASP    18     -55.285  69.525  21.344  1.00 31.72           O  
ATOM    143  OD2 ASP    18     -53.904  69.231  23.029  1.00 29.97           O  
ATOM    144  N   ASP    19     -56.835  64.969  21.468  1.00 29.97           N  
ATOM    145  CA  ASP    19     -57.203  63.582  21.671  1.00 29.68           C  
ATOM    146  C   ASP    19     -56.405  63.016  22.842  1.00 28.58           C  
ATOM    147  O   ASP    19     -55.196  63.227  22.944  1.00 28.17           O  
ATOM    148  CB  ASP    19     -56.918  62.777  20.403  1.00 30.51           C  
ATOM    149  CG  ASP    19     -57.471  61.368  20.470  1.00 31.88           C  
ATOM    150  OD1 ASP    19     -57.104  60.618  21.399  1.00 30.93           O  
ATOM    151  OD2 ASP    19     -58.277  61.013  19.588  1.00 39.55           O  
ATOM    152  N   VAL    20     -57.092  62.296  23.722  1.00 27.29           N  
ATOM    153  CA  VAL    20     -56.456  61.686  24.882  1.00 26.40           C  
ATOM    154  C   VAL    20     -55.247  60.844  24.486  1.00 26.04           C  
ATOM    155  O   VAL    20     -54.262  60.773  25.223  1.00 24.98           O  
ATOM    156  CB  VAL    20     -57.454  60.785  25.657  1.00 26.45           C  
ATOM    157  CG1 VAL    20     -58.030  59.715  24.733  1.00 26.42           C  
ATOM    158  CG2 VAL    20     -56.761  60.141  26.849  1.00 26.16           C  
ATOM    159  N   GLU    21     -55.316  60.205  23.324  1.00 25.64           N  
ATOM    160  CA  GLU    21     -54.213  59.360  22.888  1.00 26.27           C  
ATOM    161  C   GLU    21     -52.922  60.148  22.729  1.00 25.89           C  
ATOM    162  O   GLU    21     -51.849  59.673  23.086  1.00 24.75           O  
ATOM    163  CB  GLU    21     -54.553  58.655  21.571  1.00 26.32           C  
ATOM    164  CG  GLU    21     -53.485  57.663  21.136  1.00 28.87           C  
ATOM    165  CD  GLU    21     -54.016  56.591  20.203  1.00 32.83           C  
ATOM    166  OE1 GLU    21     -55.243  56.551  19.969  1.00 33.36           O  
ATOM    167  OE2 GLU    21     -53.204  55.781  19.710  1.00 36.08           O  
ATOM    168  N   GLU    22     -53.033  61.359  22.199  1.00 26.58           N  
ATOM    169  CA  GLU    22     -51.871  62.211  21.998  1.00 27.45           C  
ATOM    170  C   GLU    22     -51.333  62.659  23.354  1.00 26.54           C  
ATOM    171  O   GLU    22     -50.129  62.878  23.521  1.00 25.22           O  
ATOM    172  CB  GLU    22     -52.260  63.417  21.152  1.00 28.65           C  
ATOM    173  CG  GLU    22     -51.088  64.183  20.588  1.00 34.75           C  
ATOM    174  CD  GLU    22     -51.514  65.112  19.479  1.00 42.94           C  
ATOM    175  OE1 GLU    22     -52.169  64.632  18.528  1.00 48.49           O  
ATOM    176  OE2 GLU    22     -51.202  66.318  19.552  1.00 45.91           O  
ATOM    177  N   MET    23     -52.235  62.792  24.320  1.00 24.70           N  
ATOM    178  CA  MET    23     -51.851  63.176  25.668  1.00 24.81           C  
ATOM    179  C   MET    23     -51.116  62.018  26.332  1.00 24.29           C  
ATOM    180  O   MET    23     -50.134  62.224  27.044  1.00 24.59           O  
ATOM    181  CB  MET    23     -53.086  63.548  26.481  1.00 23.35           C  
ATOM    182  CG  MET    23     -53.733  64.824  25.998  1.00 27.56           C  
ATOM    183  SD  MET    23     -55.430  65.214  26.846  1.00 36.37          SE  
ATOM    184  CE  MET    23     -56.223  66.255  25.437  1.00 39.44           C  
ATOM    185  N   VAL    24     -51.592  60.800  26.090  1.00 24.57           N  
ATOM    186  CA  VAL    24     -50.955  59.615  26.658  1.00 24.14           C  
ATOM    187  C   VAL    24     -49.558  59.408  26.071  1.00 24.13           C  
ATOM    188  O   VAL    24     -48.620  59.057  26.792  1.00 23.58           O  
ATOM    189  CB  VAL    24     -51.808  58.347  26.414  1.00 24.20           C  
ATOM    190  CG1 VAL    24     -50.972  57.091  26.639  1.00 23.69           C  
ATOM    191  CG2 VAL    24     -53.002  58.348  27.357  1.00 24.29           C  
ATOM    192  N   LEU    25     -49.417  59.620  24.765  1.00 23.82           N  
ATOM    193  CA  LEU    25     -48.119  59.462  24.117  1.00 23.95           C  
ATOM    194  C   LEU    25     -47.120  60.454  24.708  1.00 24.01           C  
ATOM    195  O   LEU    25     -45.952  60.122  24.938  1.00 24.46           O  
ATOM    196  CB  LEU    25     -48.251  59.674  22.606  1.00 24.75           C  
ATOM    197  CG  LEU    25     -48.919  58.531  21.833  1.00 24.68           C  
ATOM    198  CD1 LEU    25     -49.305  58.994  20.434  1.00 25.81           C  
ATOM    199  CD2 LEU    25     -47.971  57.339  21.771  1.00 27.20           C  
ATOM    200  N   LYS    26     -47.584  61.672  24.967  1.00 24.19           N  
ATOM    201  CA  LYS    26     -46.726  62.691  25.561  1.00 24.43           C  
ATOM    202  C   LYS    26     -46.343  62.284  26.982  1.00 24.04           C  
ATOM    203  O   LYS    26     -45.199  62.469  27.401  1.00 25.04           O  
ATOM    204  CB  LYS    26     -47.435  64.042  25.587  1.00 24.34           C  
ATOM    205  CG  LYS    26     -46.636  65.142  26.277  1.00 28.30           C  
ATOM    206  CD  LYS    26     -45.344  65.452  25.537  1.00 33.54           C  
ATOM    207  CE  LYS    26     -44.615  66.629  26.177  1.00 38.71           C  
ATOM    208  NZ  LYS    26     -43.472  67.109  25.340  1.00 42.35           N  
ATOM    209  N   ALA    27     -47.298  61.735  27.728  1.00 23.91           N  
ATOM    210  CA  ALA    27     -47.005  61.303  29.089  1.00 24.24           C  
ATOM    211  C   ALA    27     -45.944  60.205  29.074  1.00 24.98           C  
ATOM    212  O   ALA    27     -45.070  60.164  29.937  1.00 24.85           O  
ATOM    213  CB  ALA    27     -48.266  60.805  29.779  1.00 23.73           C  
ATOM    214  N   ILE    28     -46.030  59.305  28.100  1.00 26.29           N  
ATOM    215  CA  ILE    28     -45.051  58.230  27.996  1.00 27.14           C  
ATOM    216  C   ILE    28     -43.690  58.839  27.668  1.00 28.52           C  
ATOM    217  O   ILE    28     -42.675  58.450  28.233  1.00 28.52           O  
ATOM    218  CB  ILE    28     -45.462  57.214  26.910  1.00 27.18           C  
ATOM    219  CG1 ILE    28     -46.731  56.483  27.359  1.00 25.08           C  
ATOM    220  CG2 ILE    28     -44.330  56.228  26.650  1.00 26.49           C  
ATOM    221  CD1 ILE    28     -47.313  55.551  26.318  1.00 22.09           C  
ATOM    222  N   GLU    29     -43.683  59.811  26.765  1.00 30.20           N  
ATOM    223  CA  GLU    29     -42.453  60.496  26.384  1.00 32.05           C  
ATOM    224  C   GLU    29     -41.795  61.097  27.628  1.00 32.33           C  
ATOM    225  O   GLU    29     -40.566  61.104  27.752  1.00 32.72           O  
ATOM    226  CB  GLU    29     -42.769  61.613  25.387  1.00 32.36           C  
ATOM    227  CG  GLU    29     -41.554  62.245  24.719  1.00 37.12           C  
ATOM    228  CD  GLU    29     -41.911  63.524  23.975  1.00 43.15           C  
ATOM    229  OE1 GLU    29     -43.004  63.580  23.368  1.00 43.94           O  
ATOM    230  OE2 GLU    29     -41.097  64.473  23.990  1.00 46.77           O  
ATOM    231  N   LEU    30     -42.615  61.602  28.549  1.00 32.15           N  
ATOM    232  CA  LEU    30     -42.102  62.218  29.773  1.00 31.77           C  
ATOM    233  C   LEU    30     -41.890  61.245  30.934  1.00 31.74           C  
ATOM    234  O   LEU    30     -41.790  61.659  32.093  1.00 31.25           O  
ATOM    235  CB  LEU    30     -43.018  63.368  30.213  1.00 32.07           C  
ATOM    236  CG  LEU    30     -43.190  64.475  29.163  1.00 32.41           C  
ATOM    237  CD1 LEU    30     -43.983  65.641  29.736  1.00 32.33           C  
ATOM    238  CD2 LEU    30     -41.813  64.945  28.700  1.00 35.89           C  
ATOM    239  N   ASP    31     -41.835  59.955  30.614  1.00 31.32           N  
ATOM    240  CA  ASP    31     -41.575  58.901  31.596  1.00 31.90           C  
ATOM    241  C   ASP    31     -42.587  58.632  32.712  1.00 30.97           C  
ATOM    242  O   ASP    31     -42.227  58.105  33.764  1.00 30.42           O  
ATOM    243  CB  ASP    31     -40.196  59.110  32.231  1.00 33.31           C  
ATOM    244  CG  ASP    31     -39.075  59.100  31.208  1.00 36.63           C  
ATOM    245  OD1 ASP    31     -38.964  58.122  30.440  1.00 38.03           O  
ATOM    246  OD2 ASP    31     -38.298  60.073  31.172  1.00 40.43           O  
ATOM    247  N   PHE    32     -43.846  58.988  32.502  1.00 30.11           N  
ATOM    248  CA  PHE    32     -44.858  58.694  33.509  1.00 30.00           C  
ATOM    249  C   PHE    32     -45.162  57.201  33.416  1.00 30.02           C  
ATOM    250  O   PHE    32     -45.183  56.647  32.322  1.00 29.57           O  
ATOM    251  CB  PHE    32     -46.133  59.497  33.236  1.00 29.43           C  
ATOM    252  CG  PHE    32     -46.096  60.901  33.767  1.00 28.82           C  
ATOM    253  CD1 PHE    32     -46.449  61.171  35.087  1.00 28.23           C  
ATOM    254  CD2 PHE    32     -45.683  61.951  32.953  1.00 27.29           C  
ATOM    255  CE1 PHE    32     -46.388  62.467  35.588  1.00 28.98           C  
ATOM    256  CE2 PHE    32     -45.619  63.243  33.443  1.00 29.04           C  
ATOM    257  CZ  PHE    32     -45.972  63.503  34.766  1.00 28.17           C  
ATOM    258  N   ASP    33     -45.380  56.542  34.547  1.00 30.14           N  
ATOM    259  CA  ASP    33     -45.698  55.122  34.495  1.00 31.22           C  
ATOM    260  C   ASP    33     -47.094  54.812  35.023  1.00 30.44           C  
ATOM    261  O   ASP    33     -47.541  53.670  34.982  1.00 29.71           O  
ATOM    262  CB  ASP    33     -44.646  54.306  35.244  1.00 32.46           C  
ATOM    263  CG  ASP    33     -44.305  54.895  36.580  1.00 36.15           C  
ATOM    264  OD1 ASP    33     -45.179  54.873  37.475  1.00 41.79           O  
ATOM    265  OD2 ASP    33     -43.160  55.380  36.732  1.00 40.62           O  
ATOM    266  N   GLU    34     -47.780  55.838  35.515  1.00 29.18           N  
ATOM    267  CA  GLU    34     -49.142  55.682  36.016  1.00 28.10           C  
ATOM    268  C   GLU    34     -49.890  56.947  35.613  1.00 27.02           C  
ATOM    269  O   GLU    34     -49.395  58.059  35.800  1.00 25.67           O  
ATOM    270  CB  GLU    34     -49.149  55.493  37.523  1.00 28.15           C  
ATOM    271  CG  GLU    34     -50.391  54.776  38.012  1.00 30.61           C  
ATOM    272  CD  GLU    34     -50.260  54.285  39.434  1.00 32.72           C  
ATOM    273  OE1 GLU    34     -49.191  54.490  40.036  1.00 33.86           O  
ATOM    274  OE2 GLU    34     -51.228  53.692  39.948  1.00 37.58           O  
ATOM    275  N   TYR    35     -51.083  56.773  35.059  1.00 25.86           N  
ATOM    276  CA  TYR    35     -51.839  57.898  34.529  1.00 25.06           C  
ATOM    277  C   TYR    35     -53.343  57.719  34.725  1.00 24.72           C  
ATOM    278  O   TYR    35     -53.910  56.700  34.324  1.00 25.22           O  
ATOM    279  CB  TYR    35     -51.496  58.000  33.039  1.00 24.41           C  
ATOM    280  CG  TYR    35     -52.047  59.170  32.261  1.00 23.98           C  
ATOM    281  CD1 TYR    35     -51.261  60.287  32.002  1.00 22.99           C  
ATOM    282  CD2 TYR    35     -53.325  59.124  31.710  1.00 22.11           C  
ATOM    283  CE1 TYR    35     -51.725  61.326  31.198  1.00 22.88           C  
ATOM    284  CE2 TYR    35     -53.801  60.151  30.911  1.00 22.76           C  
ATOM    285  CZ  TYR    35     -52.994  61.251  30.654  1.00 23.60           C  
ATOM    286  OH  TYR    35     -53.441  62.244  29.812  1.00 22.37           O  
ATOM    287  N   SER    36     -53.989  58.711  35.333  1.00 23.42           N  
ATOM    288  CA  SER    36     -55.429  58.636  35.564  1.00 22.40           C  
ATOM    289  C   SER    36     -56.245  59.625  34.736  1.00 21.69           C  
ATOM    290  O   SER    36     -55.979  60.832  34.715  1.00 20.94           O  
ATOM    291  CB  SER    36     -55.763  58.846  37.048  1.00 21.81           C  
ATOM    292  OG  SER    36     -55.387  57.738  37.844  1.00 22.25           O  
ATOM    293  N   ILE    37     -57.254  59.079  34.068  1.00 21.44           N  
ATOM    294  CA  ILE    37     -58.184  59.846  33.259  1.00 21.23           C  
ATOM    295  C   ILE    37     -59.431  60.036  34.126  1.00 21.25           C  
ATOM    296  O   ILE    37     -60.207  59.100  34.346  1.00 20.39           O  
ATOM    297  CB  ILE    37     -58.557  59.077  31.981  1.00 21.46           C  
ATOM    298  CG1 ILE    37     -57.304  58.859  31.131  1.00 22.05           C  
ATOM    299  CG2 ILE    37     -59.631  59.831  31.213  1.00 22.76           C  
ATOM    300  CD1 ILE    37     -57.478  57.845  30.022  1.00 25.06           C  
ATOM    301  N   VAL    38     -59.598  61.246  34.642  1.00 20.50           N  
ATOM    302  CA  VAL    38     -60.724  61.551  35.497  1.00 20.76           C  
ATOM    303  C   VAL    38     -61.510  62.706  34.897  1.00 20.95           C  
ATOM    304  O   VAL    38     -61.434  63.849  35.352  1.00 19.92           O  
ATOM    305  CB  VAL    38     -60.237  61.901  36.911  1.00 20.11           C  
ATOM    306  CG1 VAL    38     -59.772  60.633  37.619  1.00 20.73           C  
ATOM    307  CG2 VAL    38     -59.072  62.887  36.831  1.00 20.10           C  
ATOM    308  N   GLU    39     -62.260  62.395  33.850  1.00 20.59           N  
ATOM    309  CA  GLU    39     -63.044  63.404  33.175  1.00 20.51           C  
ATOM    310  C   GLU    39     -64.187  63.905  34.058  1.00 20.57           C  
ATOM    311  O   GLU    39     -64.632  63.210  34.973  1.00 19.13           O  
ATOM    312  CB  GLU    39     -63.597  62.838  31.871  1.00 21.06           C  
ATOM    313  CG  GLU    39     -64.226  63.893  31.016  1.00 21.17           C  
ATOM    314  CD  GLU    39     -63.267  65.035  30.775  1.00 22.65           C  
ATOM    315  OE1 GLU    39     -62.367  64.888  29.919  1.00 20.92           O  
ATOM    316  OE2 GLU    39     -63.402  66.064  31.465  1.00 21.33           O  
ATOM    317  N   HIS    40     -64.653  65.116  33.785  1.00 20.21           N  
ATOM    318  CA  HIS    40     -65.754  65.690  34.541  1.00 21.66           C  
ATOM    319  C   HIS    40     -67.039  64.883  34.416  1.00 22.37           C  
ATOM    320  O   HIS    40     -67.516  64.614  33.313  1.00 21.99           O  
ATOM    321  CB  HIS    40     -66.028  67.112  34.068  1.00 22.33           C  
ATOM    322  CG  HIS    40     -64.959  68.082  34.445  1.00 23.00           C  
ATOM    323  ND1 HIS    40     -64.799  68.546  35.733  1.00 26.99           N  
ATOM    324  CD2 HIS    40     -63.986  68.668  33.709  1.00 24.61           C  
ATOM    325  CE1 HIS    40     -63.775  69.379  35.775  1.00 26.38           C  
ATOM    326  NE2 HIS    40     -63.265  69.470  34.561  1.00 24.77           N  
ATOM    327  N   ALA    41     -67.608  64.515  35.558  1.00 22.98           N  
ATOM    328  CA  ALA    41     -68.857  63.768  35.564  1.00 22.94           C  
ATOM    329  C   ALA    41     -70.006  64.711  35.218  1.00 23.59           C  
ATOM    330  O   ALA    41     -69.978  65.887  35.571  1.00 22.65           O  
ATOM    331  CB  ALA    41     -69.084  63.138  36.935  1.00 22.94           C  
ATOM    332  N   PRO    42     -71.026  64.207  34.507  1.00 23.42           N  
ATOM    333  CA  PRO    42     -72.173  65.037  34.134  1.00 24.19           C  
ATOM    334  C   PRO    42     -72.829  65.664  35.371  1.00 24.64           C  
ATOM    335  O   PRO    42     -72.934  65.028  36.416  1.00 23.90           O  
ATOM    336  CB  PRO    42     -73.096  64.046  33.428  1.00 23.68           C  
ATOM    337  CG  PRO    42     -72.125  63.076  32.804  1.00 23.11           C  
ATOM    338  CD  PRO    42     -71.152  62.854  33.940  1.00 23.81           C  
ATOM    339  N   LEU    43     -73.243  66.921  35.257  1.00 25.51           N  
ATOM    340  CA  LEU    43     -73.883  67.598  36.377  1.00 26.96           C  
ATOM    341  C   LEU    43     -75.335  67.163  36.491  1.00 28.22           C  
ATOM    342  O   LEU    43     -75.897  66.591  35.556  1.00 28.90           O  
ATOM    343  CB  LEU    43     -73.838  69.113  36.186  1.00 26.57           C  
ATOM    344  CG  LEU    43     -72.466  69.777  36.113  1.00 26.06           C  
ATOM    345  CD1 LEU    43     -72.648  71.269  35.843  1.00 25.79           C  
ATOM    346  CD2 LEU    43     -71.699  69.546  37.410  1.00 26.95           C  
ATOM    347  N   SER    44     -75.936  67.427  37.645  1.00 28.80           N  
ATOM    348  CA  SER    44     -77.341  67.107  37.861  1.00 29.00           C  
ATOM    349  C   SER    44     -78.213  68.085  37.072  1.00 29.41           C  
ATOM    350  O   SER    44     -77.995  69.295  37.120  1.00 28.95           O  
ATOM    351  CB  SER    44     -77.674  67.211  39.348  1.00 28.87           C  
ATOM    352  OG  SER    44     -79.018  67.608  39.532  1.00 30.11           O  
ATOM    353  N   SER    45     -79.187  67.560  36.332  1.00 30.08           N  
ATOM    354  CA  SER    45     -80.086  68.409  35.549  1.00 31.04           C  
ATOM    355  C   SER    45     -80.826  69.371  36.479  1.00 30.91           C  
ATOM    356  O   SER    45     -81.083  70.522  36.124  1.00 31.11           O  
ATOM    357  CB  SER    45     -81.089  67.550  34.778  1.00 31.24           C  
ATOM    358  OG  SER    45     -81.755  66.659  35.653  1.00 35.03           O  
ATOM    359  N   GLU    46     -81.162  68.886  37.671  1.00 31.63           N  
ATOM    360  CA  GLU    46     -81.838  69.695  38.678  1.00 32.62           C  
ATOM    361  C   GLU    46     -80.904  70.839  39.071  1.00 30.98           C  
ATOM    362  O   GLU    46     -81.297  72.008  39.097  1.00 31.11           O  
ATOM    363  CB  GLU    46     -82.143  68.841  39.913  1.00 33.51           C  
ATOM    364  CG  GLU    46     -83.618  68.555  40.167  1.00 41.52           C  
ATOM    365  CD  GLU    46     -84.363  69.755  40.732  1.00 48.84           C  
ATOM    366  OE1 GLU    46     -83.919  70.292  41.770  1.00 52.08           O  
ATOM    367  OE2 GLU    46     -85.394  70.157  40.147  1.00 50.59           O  
ATOM    368  N   PHE    47     -79.658  70.487  39.369  1.00 29.51           N  
ATOM    369  CA  PHE    47     -78.662  71.470  39.763  1.00 28.79           C  
ATOM    370  C   PHE    47     -78.540  72.592  38.727  1.00 28.91           C  
ATOM    371  O   PHE    47     -78.476  73.775  39.073  1.00 27.76           O  
ATOM    372  CB  PHE    47     -77.296  70.792  39.939  1.00 27.25           C  
ATOM    373  CG  PHE    47     -76.185  71.752  40.257  1.00 26.28           C  
ATOM    374  CD1 PHE    47     -75.995  72.219  41.551  1.00 25.56           C  
ATOM    375  CD2 PHE    47     -75.359  72.231  39.245  1.00 25.28           C  
ATOM    376  CE1 PHE    47     -75.000  73.153  41.832  1.00 24.35           C  
ATOM    377  CE2 PHE    47     -74.366  73.164  39.516  1.00 24.10           C  
ATOM    378  CZ  PHE    47     -74.188  73.626  40.809  1.00 21.39           C  
ATOM    379  N   MET    48     -78.516  72.208  37.455  1.00 29.37           N  
ATOM    380  CA  MET    48     -78.361  73.172  36.374  1.00 31.03           C  
ATOM    381  C   MET    48     -79.506  74.171  36.240  1.00 31.09           C  
ATOM    382  O   MET    48     -79.353  75.197  35.584  1.00 32.03           O  
ATOM    383  CB  MET    48     -78.127  72.440  35.043  1.00 31.56           C  
ATOM    384  CG  MET    48     -76.836  71.624  35.021  1.00 34.65           C  
ATOM    385  SD  MET    48     -76.383  70.826  33.299  1.00 49.11          SE  
ATOM    386  CE  MET    48     -76.963  69.026  33.653  1.00 41.25           C  
ATOM    387  N   LYS    49     -80.647  73.887  36.861  1.00 30.63           N  
ATOM    388  CA  LYS    49     -81.781  74.810  36.797  1.00 30.68           C  
ATOM    389  C   LYS    49     -81.645  75.884  37.869  1.00 30.06           C  
ATOM    390  O   LYS    49     -82.354  76.889  37.846  1.00 30.35           O  
ATOM    391  CB  LYS    49     -83.101  74.086  37.065  1.00 29.93           C  
ATOM    392  CG  LYS    49     -83.410  72.890  36.187  1.00 31.43           C  
ATOM    393  CD  LYS    49     -84.695  72.236  36.711  1.00 33.55           C  
ATOM    394  CE  LYS    49     -85.078  70.981  35.948  1.00 36.76           C  
ATOM    395  NZ  LYS    49     -86.311  70.381  36.538  1.00 34.76           N  
ATOM    396  N   ASN    50     -80.747  75.655  38.821  1.00 29.50           N  
ATOM    397  CA  ASN    50     -80.582  76.567  39.945  1.00 28.40           C  
ATOM    398  C   ASN    50     -79.263  77.329  39.983  1.00 27.09           C  
ATOM    399  O   ASN    50     -78.736  77.628  41.058  1.00 26.43           O  
ATOM    400  CB  ASN    50     -80.773  75.779  41.243  1.00 28.51           C  
ATOM    401  CG  ASN    50     -82.183  75.231  41.385  1.00 30.55           C  
ATOM    402  OD1 ASN    50     -83.115  75.973  41.691  1.00 30.92           O  
ATOM    403  ND2 ASN    50     -82.348  73.931  41.150  1.00 30.82           N  
ATOM    404  N   THR    51     -78.738  77.657  38.811  1.00 26.46           N  
ATOM    405  CA  THR    51     -77.482  78.388  38.744  1.00 25.47           C  
ATOM    406  C   THR    51     -77.699  79.787  38.200  1.00 24.84           C  
ATOM    407  O   THR    51     -78.731  80.082  37.588  1.00 25.03           O  
ATOM    408  CB  THR    51     -76.450  77.692  37.834  1.00 25.83           C  
ATOM    409  OG1 THR    51     -76.857  77.815  36.469  1.00 27.09           O  
ATOM    410  CG2 THR    51     -76.318  76.218  38.198  1.00 24.93           C  
ATOM    411  N   ALA    52     -76.718  80.646  38.450  1.00 23.07           N  
ATOM    412  CA  ALA    52     -76.724  82.015  37.969  1.00 22.30           C  
ATOM    413  C   ALA    52     -75.328  82.241  37.406  1.00 22.50           C  
ATOM    414  O   ALA    52     -74.559  81.291  37.265  1.00 21.51           O  
ATOM    415  CB  ALA    52     -77.007  82.984  39.109  1.00 22.70           C  
ATOM    416  N   GLY    53     -74.994  83.482  37.077  1.00 22.05           N  
ATOM    417  CA  GLY    53     -73.672  83.745  36.533  1.00 22.44           C  
ATOM    418  C   GLY    53     -73.540  83.293  35.088  1.00 23.27           C  
ATOM    419  O   GLY    53     -74.504  82.822  34.480  1.00 22.19           O  
ATOM    420  N   ASP    54     -72.341  83.419  34.536  1.00 23.60           N  
ATOM    421  CA  ASP    54     -72.114  83.044  33.150  1.00 24.77           C  
ATOM    422  C   ASP    54     -72.572  81.624  32.869  1.00 24.63           C  
ATOM    423  O   ASP    54     -72.065  80.671  33.459  1.00 24.33           O  
ATOM    424  CB  ASP    54     -70.639  83.193  32.787  1.00 25.29           C  
ATOM    425  CG  ASP    54     -70.425  83.283  31.293  1.00 27.08           C  
ATOM    426  OD1 ASP    54     -70.896  82.375  30.574  1.00 28.27           O  
ATOM    427  OD2 ASP    54     -69.798  84.263  30.838  1.00 29.36           O  
ATOM    428  N   LYS    55     -73.537  81.493  31.961  1.00 24.74           N  
ATOM    429  CA  LYS    55     -74.081  80.191  31.600  1.00 24.76           C  
ATOM    430  C   LYS    55     -73.015  79.247  31.055  1.00 24.59           C  
ATOM    431  O   LYS    55     -73.108  78.034  31.229  1.00 23.72           O  
ATOM    432  CB  LYS    55     -75.206  80.352  30.576  1.00 25.36           C  
ATOM    433  CG  LYS    55     -76.428  81.071  31.130  1.00 25.68           C  
ATOM    434  CD  LYS    55     -77.468  81.307  30.054  1.00 27.84           C  
ATOM    435  CE  LYS    55     -78.701  81.981  30.639  1.00 27.11           C  
ATOM    436  NZ  LYS    55     -79.689  82.329  29.588  1.00 27.21           N  
ATOM    437  N   GLU    56     -72.009  79.800  30.391  1.00 24.17           N  
ATOM    438  CA  GLU    56     -70.941  78.977  29.837  1.00 26.31           C  
ATOM    439  C   GLU    56     -70.286  78.133  30.930  1.00 25.51           C  
ATOM    440  O   GLU    56     -69.854  77.007  30.680  1.00 24.60           O  
ATOM    441  CB  GLU    56     -69.897  79.861  29.150  1.00 26.80           C  
ATOM    442  CG  GLU    56     -68.662  79.122  28.675  1.00 33.08           C  
ATOM    443  CD  GLU    56     -67.790  79.974  27.768  1.00 41.19           C  
ATOM    444  OE1 GLU    56     -67.491  81.129  28.136  1.00 45.50           O  
ATOM    445  OE2 GLU    56     -67.398  79.488  26.687  1.00 45.86           O  
ATOM    446  N   ALA    57     -70.230  78.675  32.144  1.00 24.72           N  
ATOM    447  CA  ALA    57     -69.634  77.952  33.263  1.00 25.38           C  
ATOM    448  C   ALA    57     -70.377  76.648  33.540  1.00 25.69           C  
ATOM    449  O   ALA    57     -69.804  75.700  34.077  1.00 25.84           O  
ATOM    450  CB  ALA    57     -69.636  78.827  34.513  1.00 24.59           C  
ATOM    451  N   VAL    58     -71.656  76.610  33.167  1.00 25.09           N  
ATOM    452  CA  VAL    58     -72.499  75.441  33.398  1.00 25.05           C  
ATOM    453  C   VAL    58     -72.640  74.548  32.163  1.00 26.08           C  
ATOM    454  O   VAL    58     -72.432  73.337  32.236  1.00 26.41           O  
ATOM    455  CB  VAL    58     -73.914  75.874  33.870  1.00 24.70           C  
ATOM    456  CG1 VAL    58     -74.771  74.644  34.186  1.00 23.49           C  
ATOM    457  CG2 VAL    58     -73.803  76.764  35.092  1.00 24.79           C  
ATOM    458  N   THR    59     -73.010  75.148  31.034  1.00 26.31           N  
ATOM    459  CA  THR    59     -73.187  74.397  29.796  1.00 26.70           C  
ATOM    460  C   THR    59     -71.885  73.716  29.387  1.00 27.39           C  
ATOM    461  O   THR    59     -71.882  72.632  28.808  1.00 27.63           O  
ATOM    462  CB  THR    59     -73.626  75.322  28.632  1.00 26.21           C  
ATOM    463  OG1 THR    59     -72.580  76.255  28.346  1.00 27.61           O  
ATOM    464  CG2 THR    59     -74.884  76.096  28.997  1.00 25.55           C  
ATOM    465  N   THR    60     -70.779  74.371  29.709  1.00 28.11           N  
ATOM    466  CA  THR    60     -69.448  73.899  29.356  1.00 29.36           C  
ATOM    467  C   THR    60     -68.777  73.035  30.441  1.00 29.49           C  
ATOM    468  O   THR    60     -67.743  72.405  30.194  1.00 29.27           O  
ATOM    469  CB  THR    60     -68.575  75.141  28.993  1.00 28.93           C  
ATOM    470  OG1 THR    60     -68.695  75.412  27.590  1.00 32.24           O  
ATOM    471  CG2 THR    60     -67.136  74.946  29.351  1.00 30.93           C  
ATOM    472  N   ALA    61     -69.394  72.979  31.620  1.00 30.12           N  
ATOM    473  CA  ALA    61     -68.854  72.233  32.757  1.00 30.71           C  
ATOM    474  C   ALA    61     -68.428  70.796  32.466  1.00 30.79           C  
ATOM    475  O   ALA    61     -67.312  70.405  32.801  1.00 30.40           O  
ATOM    476  CB  ALA    61     -69.849  72.255  33.919  1.00 30.41           C  
ATOM    477  N   SER    62     -69.304  70.003  31.860  1.00 31.36           N  
ATOM    478  CA  SER    62     -68.957  68.615  31.578  1.00 32.61           C  
ATOM    479  C   SER    62     -69.802  67.992  30.482  1.00 33.33           C  
ATOM    480  O   SER    62     -70.727  68.612  29.965  1.00 32.97           O  
ATOM    481  CB  SER    62     -69.104  67.772  32.839  1.00 32.97           C  
ATOM    482  OG  SER    62     -70.472  67.638  33.174  1.00 33.68           O  
ATOM    483  N   MET    63     -69.474  66.751  30.144  1.00 33.89           N  
ATOM    484  CA  MET    63     -70.190  66.015  29.114  1.00 35.36           C  
ATOM    485  C   MET    63     -71.597  65.644  29.567  1.00 35.11           C  
ATOM    486  O   MET    63     -71.941  65.778  30.740  1.00 34.74           O  
ATOM    487  CB  MET    63     -69.423  64.743  28.758  1.00 36.25           C  
ATOM    488  CG  MET    63     -69.002  63.943  29.972  1.00 41.57           C  
ATOM    489  SD  MET    63     -68.382  62.160  29.547  1.00 51.78          SE  
ATOM    490  CE  MET    63     -70.088  61.293  29.652  1.00 52.81           C  
ATOM    491  N   ALA    64     -72.402  65.166  28.624  1.00 35.19           N  
ATOM    492  CA  ALA    64     -73.770  64.758  28.907  1.00 35.41           C  
ATOM    493  C   ALA    64     -73.811  63.290  29.314  1.00 35.39           C  
ATOM    494  O   ALA    64     -72.904  62.524  28.995  1.00 35.33           O  
ATOM    495  CB  ALA    64     -74.642  64.979  27.675  1.00 35.64           C  
ATOM    496  N   MET    65     -74.868  62.905  30.022  1.00 35.19           N  
ATOM    497  CA  MET    65     -75.041  61.524  30.459  1.00 35.39           C  
ATOM    498  C   MET    65     -74.962  60.565  29.273  1.00 34.45           C  
ATOM    499  O   MET    65     -74.406  59.471  29.379  1.00 33.78           O  
ATOM    500  CB  MET    65     -76.391  61.363  31.165  1.00 36.60           C  
ATOM    501  CG  MET    65     -76.442  61.947  32.571  1.00 41.25           C  
ATOM    502  SD  MET    65     -75.443  60.901  33.872  1.00 53.07          SE  
ATOM    503  CE  MET    65     -76.774  59.536  34.237  1.00 52.72           C  
ATOM    504  N   SER    66     -75.518  60.981  28.140  1.00 34.02           N  
ATOM    505  CA  SER    66     -75.504  60.146  26.948  1.00 33.69           C  
ATOM    506  C   SER    66     -74.090  59.877  26.423  1.00 33.50           C  
ATOM    507  O   SER    66     -73.862  58.881  25.739  1.00 33.75           O  
ATOM    508  CB  SER    66     -76.359  60.783  25.848  1.00 34.11           C  
ATOM    509  OG  SER    66     -75.912  62.090  25.539  1.00 33.34           O  
ATOM    510  N   ASP    67     -73.135  60.748  26.743  1.00 33.09           N  
ATOM    511  CA  ASP    67     -71.764  60.548  26.273  1.00 32.70           C  
ATOM    512  C   ASP    67     -70.999  59.491  27.070  1.00 31.58           C  
ATOM    513  O   ASP    67     -69.948  59.021  26.634  1.00 31.42           O  
ATOM    514  CB  ASP    67     -70.968  61.860  26.323  1.00 33.87           C  
ATOM    515  CG  ASP    67     -71.489  62.904  25.347  1.00 36.35           C  
ATOM    516  OD1 ASP    67     -71.701  62.571  24.161  1.00 39.46           O  
ATOM    517  OD2 ASP    67     -71.670  64.067  25.769  1.00 41.08           O  
ATOM    518  N   LEU    68     -71.521  59.129  28.238  1.00 30.34           N  
ATOM    519  CA  LEU    68     -70.865  58.159  29.110  1.00 29.88           C  
ATOM    520  C   LEU    68     -70.428  56.858  28.440  1.00 29.09           C  
ATOM    521  O   LEU    68     -69.273  56.461  28.560  1.00 28.49           O  
ATOM    522  CB  LEU    68     -71.758  57.853  30.319  1.00 30.79           C  
ATOM    523  CG  LEU    68     -71.837  58.982  31.351  1.00 31.35           C  
ATOM    524  CD1 LEU    68     -72.912  58.687  32.389  1.00 32.69           C  
ATOM    525  CD2 LEU    68     -70.475  59.153  32.018  1.00 32.70           C  
ATOM    526  N   PRO    69     -71.346  56.169  27.742  1.00 28.50           N  
ATOM    527  CA  PRO    69     -70.975  54.913  27.080  1.00 28.02           C  
ATOM    528  C   PRO    69     -69.770  55.077  26.161  1.00 27.51           C  
ATOM    529  O   PRO    69     -68.877  54.233  26.140  1.00 26.50           O  
ATOM    530  CB  PRO    69     -72.244  54.543  26.319  1.00 28.06           C  
ATOM    531  CG  PRO    69     -73.326  55.075  27.220  1.00 28.33           C  
ATOM    532  CD  PRO    69     -72.779  56.451  27.547  1.00 28.58           C  
ATOM    533  N   TYR    70     -69.745  56.183  25.427  1.00 27.64           N  
ATOM    534  CA  TYR    70     -68.661  56.490  24.499  1.00 28.69           C  
ATOM    535  C   TYR    70     -67.365  56.836  25.235  1.00 27.60           C  
ATOM    536  O   TYR    70     -66.276  56.456  24.798  1.00 27.78           O  
ATOM    537  CB  TYR    70     -69.087  57.645  23.597  1.00 30.11           C  
ATOM    538  CG  TYR    70     -70.329  57.315  22.797  1.00 35.37           C  
ATOM    539  CD1 TYR    70     -70.244  56.582  21.613  1.00 39.91           C  
ATOM    540  CD2 TYR    70     -71.595  57.685  23.255  1.00 39.86           C  
ATOM    541  CE1 TYR    70     -71.390  56.223  20.904  1.00 44.06           C  
ATOM    542  CE2 TYR    70     -72.745  57.331  22.557  1.00 43.29           C  
ATOM    543  CZ  TYR    70     -72.637  56.601  21.384  1.00 45.69           C  
ATOM    544  OH  TYR    70     -73.778  56.246  20.695  1.00 48.83           O  
ATOM    545  N   TYR    71     -67.488  57.550  26.351  1.00 26.10           N  
ATOM    546  CA  TYR    71     -66.322  57.913  27.154  1.00 24.77           C  
ATOM    547  C   TYR    71     -65.597  56.661  27.625  1.00 23.68           C  
ATOM    548  O   TYR    71     -64.400  56.506  27.394  1.00 23.14           O  
ATOM    549  CB  TYR    71     -66.742  58.743  28.372  1.00 24.53           C  
ATOM    550  CG  TYR    71     -65.659  58.912  29.426  1.00 25.13           C  
ATOM    551  CD1 TYR    71     -64.492  59.632  29.153  1.00 24.00           C  
ATOM    552  CD2 TYR    71     -65.821  58.381  30.710  1.00 25.47           C  
ATOM    553  CE1 TYR    71     -63.519  59.826  30.132  1.00 23.82           C  
ATOM    554  CE2 TYR    71     -64.855  58.567  31.696  1.00 24.29           C  
ATOM    555  CZ  TYR    71     -63.707  59.294  31.403  1.00 23.10           C  
ATOM    556  OH  TYR    71     -62.766  59.515  32.383  1.00 18.56           O  
ATOM    557  N   PHE    72     -66.323  55.767  28.286  1.00 23.15           N  
ATOM    558  CA  PHE    72     -65.717  54.539  28.780  1.00 23.21           C  
ATOM    559  C   PHE    72     -65.137  53.701  27.649  1.00 23.50           C  
ATOM    560  O   PHE    72     -64.045  53.156  27.771  1.00 25.00           O  
ATOM    561  CB  PHE    72     -66.731  53.714  29.580  1.00 22.76           C  
ATOM    562  CG  PHE    72     -66.942  54.216  30.977  1.00 22.66           C  
ATOM    563  CD1 PHE    72     -65.883  54.281  31.870  1.00 22.22           C  
ATOM    564  CD2 PHE    72     -68.195  54.634  31.396  1.00 21.08           C  
ATOM    565  CE1 PHE    72     -66.070  54.749  33.167  1.00 22.23           C  
ATOM    566  CE2 PHE    72     -68.394  55.105  32.692  1.00 21.09           C  
ATOM    567  CZ  PHE    72     -67.332  55.163  33.576  1.00 23.10           C  
ATOM    568  N   LYS    73     -65.862  53.599  26.542  1.00 24.15           N  
ATOM    569  CA  LYS    73     -65.361  52.818  25.422  1.00 24.59           C  
ATOM    570  C   LYS    73     -63.995  53.333  24.966  1.00 23.91           C  
ATOM    571  O   LYS    73     -63.037  52.564  24.865  1.00 24.00           O  
ATOM    572  CB  LYS    73     -66.347  52.869  24.256  1.00 24.50           C  
ATOM    573  CG  LYS    73     -65.898  52.077  23.040  1.00 27.22           C  
ATOM    574  CD  LYS    73     -66.849  52.265  21.867  1.00 31.62           C  
ATOM    575  CE  LYS    73     -66.326  51.539  20.630  1.00 32.63           C  
ATOM    576  NZ  LYS    73     -67.092  51.872  19.401  1.00 34.21           N  
ATOM    577  N   LYS    74     -63.911  54.635  24.699  1.00 24.19           N  
ATOM    578  CA  LYS    74     -62.668  55.250  24.237  1.00 23.56           C  
ATOM    579  C   LYS    74     -61.527  55.071  25.237  1.00 23.57           C  
ATOM    580  O   LYS    74     -60.443  54.622  24.871  1.00 22.65           O  
ATOM    581  CB  LYS    74     -62.887  56.741  23.969  1.00 24.16           C  
ATOM    582  CG  LYS    74     -61.633  57.516  23.542  1.00 26.10           C  
ATOM    583  CD  LYS    74     -61.150  57.084  22.162  1.00 30.84           C  
ATOM    584  CE  LYS    74     -60.351  58.181  21.466  1.00 33.83           C  
ATOM    585  NZ  LYS    74     -59.071  58.489  22.134  1.00 37.25           N  
ATOM    586  N   MET    75     -61.772  55.426  26.498  1.00 23.98           N  
ATOM    587  CA  MET    75     -60.750  55.300  27.535  1.00 24.28           C  
ATOM    588  C   MET    75     -60.314  53.855  27.769  1.00 23.97           C  
ATOM    589  O   MET    75     -59.131  53.597  27.983  1.00 24.43           O  
ATOM    590  CB  MET    75     -61.234  55.917  28.849  1.00 24.43           C  
ATOM    591  CG  MET    75     -61.595  57.393  28.739  1.00 26.89           C  
ATOM    592  SD  MET    75     -60.416  58.378  27.532  1.00 36.38          SE  
ATOM    593  CE  MET    75     -61.758  59.466  26.651  1.00 26.61           C  
ATOM    594  N   ASN    76     -61.251  52.910  27.748  1.00 24.33           N  
ATOM    595  CA  ASN    76     -60.872  51.511  27.937  1.00 24.45           C  
ATOM    596  C   ASN    76     -60.013  51.055  26.762  1.00 23.97           C  
ATOM    597  O   ASN    76     -59.149  50.197  26.909  1.00 24.19           O  
ATOM    598  CB  ASN    76     -62.109  50.617  28.075  1.00 24.78           C  
ATOM    599  CG  ASN    76     -62.586  50.507  29.514  1.00 26.25           C  
ATOM    600  OD1 ASN    76     -61.860  50.020  30.382  1.00 26.35           O  
ATOM    601  ND2 ASN    76     -63.807  50.964  29.773  1.00 23.88           N  
ATOM    602  N   HIS    77     -60.238  51.649  25.597  1.00 23.53           N  
ATOM    603  CA  HIS    77     -59.442  51.319  24.419  1.00 23.17           C  
ATOM    604  C   HIS    77     -58.002  51.821  24.592  1.00 23.55           C  
ATOM    605  O   HIS    77     -57.038  51.103  24.324  1.00 22.15           O  
ATOM    606  CB  HIS    77     -60.068  51.956  23.179  1.00 23.37           C  
ATOM    607  CG  HIS    77     -59.217  51.861  21.952  1.00 24.16           C  
ATOM    608  ND1 HIS    77     -58.602  52.958  21.387  1.00 27.50           N  
ATOM    609  CD2 HIS    77     -58.873  50.799  21.189  1.00 22.57           C  
ATOM    610  CE1 HIS    77     -57.914  52.574  20.326  1.00 26.13           C  
ATOM    611  NE2 HIS    77     -58.061  51.269  20.185  1.00 26.54           N  
ATOM    612  N   ILE    78     -57.867  53.059  25.053  1.00 23.85           N  
ATOM    613  CA  ILE    78     -56.552  53.654  25.265  1.00 24.32           C  
ATOM    614  C   ILE    78     -55.810  52.937  26.397  1.00 23.95           C  
ATOM    615  O   ILE    78     -54.599  52.746  26.333  1.00 24.06           O  
ATOM    616  CB  ILE    78     -56.690  55.163  25.587  1.00 24.70           C  
ATOM    617  CG1 ILE    78     -57.465  55.857  24.468  1.00 24.61           C  
ATOM    618  CG2 ILE    78     -55.320  55.814  25.705  1.00 23.44           C  
ATOM    619  CD1 ILE    78     -56.757  55.816  23.131  1.00 28.45           C  
ATOM    620  N   LYS    79     -56.542  52.527  27.426  1.00 24.57           N  
ATOM    621  CA  LYS    79     -55.948  51.819  28.558  1.00 24.11           C  
ATOM    622  C   LYS    79     -55.213  50.558  28.103  1.00 24.57           C  
ATOM    623  O   LYS    79     -54.043  50.348  28.445  1.00 24.32           O  
ATOM    624  CB  LYS    79     -57.034  51.423  29.555  1.00 23.88           C  
ATOM    625  CG  LYS    79     -56.532  50.664  30.788  1.00 26.21           C  
ATOM    626  CD  LYS    79     -57.714  50.225  31.650  1.00 30.53           C  
ATOM    627  CE  LYS    79     -57.365  50.138  33.128  1.00 34.09           C  
ATOM    628  NZ  LYS    79     -56.219  49.235  33.416  1.00 38.79           N  
ATOM    629  N   LYS    80     -55.908  49.722  27.336  1.00 24.07           N  
ATOM    630  CA  LYS    80     -55.333  48.473  26.842  1.00 24.89           C  
ATOM    631  C   LYS    80     -54.238  48.703  25.803  1.00 24.53           C  
ATOM    632  O   LYS    80     -53.194  48.040  25.816  1.00 23.22           O  
ATOM    633  CB  LYS    80     -56.437  47.594  26.240  1.00 25.09           C  
ATOM    634  CG  LYS    80     -57.448  47.094  27.265  1.00 28.28           C  
ATOM    635  CD  LYS    80     -58.597  46.360  26.594  1.00 35.20           C  
ATOM    636  CE  LYS    80     -59.668  45.968  27.600  1.00 37.85           C  
ATOM    637  NZ  LYS    80     -60.976  45.724  26.924  1.00 41.69           N  
ATOM    638  N   LYS    81     -54.479  49.643  24.898  1.00 24.75           N  
ATOM    639  CA  LYS    81     -53.513  49.925  23.847  1.00 25.41           C  
ATOM    640  C   LYS    81     -52.137  50.280  24.398  1.00 26.43           C  
ATOM    641  O   LYS    81     -51.121  49.874  23.840  1.00 26.90           O  
ATOM    642  CB  LYS    81     -54.018  51.060  22.950  1.00 24.90           C  
ATOM    643  CG  LYS    81     -53.095  51.386  21.786  1.00 23.32           C  
ATOM    644  CD  LYS    81     -53.738  52.376  20.825  1.00 21.39           C  
ATOM    645  CE  LYS    81     -52.863  52.604  19.592  1.00 22.94           C  
ATOM    646  NZ  LYS    81     -53.572  53.446  18.588  1.00 21.93           N  
ATOM    647  N   TYR    82     -52.102  51.021  25.502  1.00 27.24           N  
ATOM    648  CA  TYR    82     -50.826  51.448  26.080  1.00 27.54           C  
ATOM    649  C   TYR    82     -50.454  50.809  27.409  1.00 28.50           C  
ATOM    650  O   TYR    82     -49.506  51.244  28.054  1.00 28.23           O  
ATOM    651  CB  TYR    82     -50.816  52.971  26.233  1.00 26.91           C  
ATOM    652  CG  TYR    82     -50.853  53.690  24.908  1.00 24.95           C  
ATOM    653  CD1 TYR    82     -49.731  53.719  24.081  1.00 22.23           C  
ATOM    654  CD2 TYR    82     -52.031  54.276  24.444  1.00 23.40           C  
ATOM    655  CE1 TYR    82     -49.785  54.300  22.825  1.00 22.80           C  
ATOM    656  CE2 TYR    82     -52.092  54.863  23.188  1.00 23.63           C  
ATOM    657  CZ  TYR    82     -50.967  54.867  22.385  1.00 23.00           C  
ATOM    658  OH  TYR    82     -51.035  55.417  21.130  1.00 23.43           O  
ATOM    659  N   ALA    83     -51.187  49.774  27.813  1.00 30.29           N  
ATOM    660  CA  ALA    83     -50.918  49.099  29.082  1.00 32.50           C  
ATOM    661  C   ALA    83     -49.448  48.715  29.209  1.00 34.26           C  
ATOM    662  O   ALA    83     -48.900  48.664  30.308  1.00 35.07           O  
ATOM    663  CB  ALA    83     -51.796  47.855  29.212  1.00 32.89           C  
ATOM    664  N   SER    84     -48.817  48.452  28.071  1.00 35.36           N  
ATOM    665  CA  SER    84     -47.416  48.058  28.027  1.00 36.02           C  
ATOM    666  C   SER    84     -46.467  49.172  28.468  1.00 35.72           C  
ATOM    667  O   SER    84     -45.426  48.900  29.061  1.00 36.03           O  
ATOM    668  CB  SER    84     -47.063  47.598  26.611  1.00 36.15           C  
ATOM    669  OG  SER    84     -45.713  47.192  26.531  1.00 40.00           O  
ATOM    670  N   ASP    85     -46.830  50.421  28.186  1.00 35.44           N  
ATOM    671  CA  ASP    85     -45.986  51.562  28.551  1.00 35.00           C  
ATOM    672  C   ASP    85     -46.506  52.359  29.753  1.00 34.06           C  
ATOM    673  O   ASP    85     -45.741  53.051  30.424  1.00 33.30           O  
ATOM    674  CB  ASP    85     -45.867  52.533  27.372  1.00 35.98           C  
ATOM    675  CG  ASP    85     -45.444  51.852  26.088  1.00 38.71           C  
ATOM    676  OD1 ASP    85     -44.252  51.503  25.952  1.00 41.72           O  
ATOM    677  OD2 ASP    85     -46.315  51.669  25.210  1.00 39.56           O  
ATOM    678  N   LEU    86     -47.807  52.270  30.013  1.00 32.94           N  
ATOM    679  CA  LEU    86     -48.422  53.042  31.091  1.00 32.23           C  
ATOM    680  C   LEU    86     -49.584  52.338  31.769  1.00 31.05           C  
ATOM    681  O   LEU    86     -50.409  51.711  31.105  1.00 31.21           O  
ATOM    682  CB  LEU    86     -48.970  54.368  30.531  1.00 32.92           C  
ATOM    683  CG  LEU    86     -48.378  55.731  30.887  1.00 35.13           C  
ATOM    684  CD1 LEU    86     -49.266  56.796  30.269  1.00 37.83           C  
ATOM    685  CD2 LEU    86     -48.307  55.942  32.384  1.00 37.95           C  
ATOM    686  N   LEU    87     -49.656  52.460  33.091  1.00 29.33           N  
ATOM    687  CA  LEU    87     -50.786  51.916  33.826  1.00 28.10           C  
ATOM    688  C   LEU    87     -51.818  53.048  33.836  1.00 27.27           C  
ATOM    689  O   LEU    87     -51.617  54.088  34.461  1.00 25.68           O  
ATOM    690  CB  LEU    87     -50.398  51.547  35.258  1.00 28.67           C  
ATOM    691  CG  LEU    87     -51.582  51.122  36.131  1.00 28.88           C  
ATOM    692  CD1 LEU    87     -52.338  49.985  35.457  1.00 31.34           C  
ATOM    693  CD2 LEU    87     -51.100  50.707  37.504  1.00 29.64           C  
ATOM    694  N   ILE    88     -52.905  52.854  33.105  1.00 25.70           N  
ATOM    695  CA  ILE    88     -53.937  53.875  33.027  1.00 25.45           C  
ATOM    696  C   ILE    88     -55.158  53.544  33.867  1.00 25.10           C  
ATOM    697  O   ILE    88     -55.681  52.436  33.810  1.00 25.09           O  
ATOM    698  CB  ILE    88     -54.371  54.095  31.566  1.00 25.43           C  
ATOM    699  CG1 ILE    88     -53.168  54.580  30.749  1.00 24.84           C  
ATOM    700  CG2 ILE    88     -55.525  55.084  31.499  1.00 24.39           C  
ATOM    701  CD1 ILE    88     -53.429  54.689  29.267  1.00 24.55           C  
ATOM    702  N   HIS    89     -55.595  54.513  34.661  1.00 24.28           N  
ATOM    703  CA  HIS    89     -56.783  54.350  35.487  1.00 23.74           C  
ATOM    704  C   HIS    89     -57.884  55.175  34.837  1.00 23.39           C  
ATOM    705  O   HIS    89     -57.611  56.207  34.224  1.00 24.14           O  
ATOM    706  CB  HIS    89     -56.533  54.859  36.909  1.00 23.95           C  
ATOM    707  CG  HIS    89     -55.435  54.141  37.626  1.00 25.98           C  
ATOM    708  ND1 HIS    89     -55.497  52.798  37.928  1.00 27.54           N  
ATOM    709  CD2 HIS    89     -54.242  54.577  38.097  1.00 26.27           C  
ATOM    710  CE1 HIS    89     -54.390  52.437  38.553  1.00 28.46           C  
ATOM    711  NE2 HIS    89     -53.611  53.498  38.668  1.00 27.02           N  
ATOM    712  N   ILE    90     -59.123  54.724  34.967  1.00 23.20           N  
ATOM    713  CA  ILE    90     -60.250  55.434  34.382  1.00 22.56           C  
ATOM    714  C   ILE    90     -61.267  55.797  35.461  1.00 21.66           C  
ATOM    715  O   ILE    90     -61.693  54.943  36.231  1.00 20.42           O  
ATOM    716  CB  ILE    90     -60.934  54.573  33.305  1.00 23.09           C  
ATOM    717  CG1 ILE    90     -59.912  54.202  32.224  1.00 24.28           C  
ATOM    718  CG2 ILE    90     -62.135  55.313  32.722  1.00 22.81           C  
ATOM    719  CD1 ILE    90     -60.479  53.380  31.082  1.00 25.45           C  
ATOM    720  N   GLY    91     -61.649  57.070  35.517  1.00 21.72           N  
ATOM    721  CA  GLY    91     -62.617  57.506  36.510  1.00 20.36           C  
ATOM    722  C   GLY    91     -63.188  58.873  36.200  1.00 20.72           C  
ATOM    723  O   GLY    91     -63.226  59.292  35.040  1.00 20.98           O  
ATOM    724  N   PHE    92     -63.628  59.576  37.236  1.00 19.43           N  
ATOM    725  CA  PHE    92     -64.209  60.895  37.051  1.00 19.08           C  
ATOM    726  C   PHE    92     -63.730  61.900  38.073  1.00 18.60           C  
ATOM    727  O   PHE    92     -63.367  61.546  39.197  1.00 17.59           O  
ATOM    728  CB  PHE    92     -65.737  60.856  37.218  1.00 19.92           C  
ATOM    729  CG  PHE    92     -66.448  59.990  36.224  1.00 21.98           C  
ATOM    730  CD1 PHE    92     -66.620  60.416  34.912  1.00 22.24           C  
ATOM    731  CD2 PHE    92     -66.963  58.751  36.608  1.00 22.28           C  
ATOM    732  CE1 PHE    92     -67.296  59.626  33.986  1.00 25.23           C  
ATOM    733  CE2 PHE    92     -67.644  57.947  35.693  1.00 25.18           C  
ATOM    734  CZ  PHE    92     -67.812  58.387  34.378  1.00 24.52           C  
ATOM    735  N   GLU    93     -63.732  63.165  37.668  1.00 18.44           N  
ATOM    736  CA  GLU    93     -63.485  64.226  38.623  1.00 18.28           C  
ATOM    737  C   GLU    93     -64.940  64.507  38.991  1.00 18.74           C  
ATOM    738  O   GLU    93     -65.684  65.097  38.210  1.00 19.05           O  
ATOM    739  CB  GLU    93     -62.880  65.467  37.987  1.00 16.89           C  
ATOM    740  CG  GLU    93     -62.943  66.647  38.943  1.00 16.88           C  
ATOM    741  CD  GLU    93     -62.039  67.793  38.545  1.00 18.00           C  
ATOM    742  OE1 GLU    93     -61.800  67.964  37.341  1.00 11.18           O  
ATOM    743  OE2 GLU    93     -61.592  68.529  39.435  1.00 19.53           O  
ATOM    744  N   VAL    94     -65.356  64.021  40.148  1.00 19.40           N  
ATOM    745  CA  VAL    94     -66.735  64.187  40.571  1.00 19.18           C  
ATOM    746  C   VAL    94     -66.989  65.490  41.298  1.00 19.64           C  
ATOM    747  O   VAL    94     -66.314  65.812  42.269  1.00 19.27           O  
ATOM    748  CB  VAL    94     -67.170  63.015  41.469  1.00 19.77           C  
ATOM    749  CG1 VAL    94     -68.631  63.191  41.878  1.00 18.38           C  
ATOM    750  CG2 VAL    94     -66.961  61.692  40.737  1.00 17.67           C  
ATOM    751  N   ASP    95     -67.974  66.238  40.811  1.00 20.47           N  
ATOM    752  CA  ASP    95     -68.356  67.506  41.420  1.00 21.20           C  
ATOM    753  C   ASP    95     -69.125  67.267  42.709  1.00 21.48           C  
ATOM    754  O   ASP    95     -70.112  66.519  42.716  1.00 21.61           O  
ATOM    755  CB  ASP    95     -69.273  68.297  40.485  1.00 21.65           C  
ATOM    756  CG  ASP    95     -68.528  69.288  39.627  1.00 23.09           C  
ATOM    757  OD1 ASP    95     -68.192  70.382  40.135  1.00 24.34           O  
ATOM    758  OD2 ASP    95     -68.290  68.974  38.441  1.00 25.11           O  
ATOM    759  N   TYR    96     -68.670  67.870  43.801  1.00 21.06           N  
ATOM    760  CA  TYR    96     -69.435  67.773  45.032  1.00 21.65           C  
ATOM    761  C   TYR    96     -70.474  68.889  44.904  1.00 22.40           C  
ATOM    762  O   TYR    96     -70.139  70.072  44.894  1.00 21.91           O  
ATOM    763  CB  TYR    96     -68.573  67.996  46.278  1.00 21.56           C  
ATOM    764  CG  TYR    96     -69.407  67.938  47.539  1.00 21.43           C  
ATOM    765  CD1 TYR    96     -70.055  66.756  47.917  1.00 22.17           C  
ATOM    766  CD2 TYR    96     -69.624  69.079  48.307  1.00 22.97           C  
ATOM    767  CE1 TYR    96     -70.904  66.721  49.019  1.00 21.76           C  
ATOM    768  CE2 TYR    96     -70.471  69.052  49.412  1.00 22.37           C  
ATOM    769  CZ  TYR    96     -71.106  67.873  49.756  1.00 23.00           C  
ATOM    770  OH  TYR    96     -71.958  67.860  50.828  1.00 24.53           O  
ATOM    771  N   LEU    97     -71.731  68.508  44.740  1.00 23.22           N  
ATOM    772  CA  LEU    97     -72.791  69.489  44.593  1.00 23.65           C  
ATOM    773  C   LEU    97     -73.547  69.630  45.904  1.00 23.48           C  
ATOM    774  O   LEU    97     -74.306  68.747  46.300  1.00 22.43           O  
ATOM    775  CB  LEU    97     -73.726  69.065  43.457  1.00 24.10           C  
ATOM    776  CG  LEU    97     -73.059  68.889  42.084  1.00 24.78           C  
ATOM    777  CD1 LEU    97     -74.049  68.273  41.097  1.00 26.29           C  
ATOM    778  CD2 LEU    97     -72.555  70.232  41.565  1.00 22.40           C  
ATOM    779  N   ILE    98     -73.309  70.746  46.580  1.00 23.89           N  
ATOM    780  CA  ILE    98     -73.942  71.029  47.861  1.00 25.04           C  
ATOM    781  C   ILE    98     -75.467  70.973  47.768  1.00 25.55           C  
ATOM    782  O   ILE    98     -76.082  71.722  47.010  1.00 24.78           O  
ATOM    783  CB  ILE    98     -73.510  72.418  48.383  1.00 25.32           C  
ATOM    784  CG1 ILE    98     -72.010  72.409  48.689  1.00 24.00           C  
ATOM    785  CG2 ILE    98     -74.303  72.785  49.637  1.00 28.55           C  
ATOM    786  CD1 ILE    98     -71.417  73.788  48.898  1.00 25.56           C  
ATOM    787  N   GLY    99     -76.064  70.062  48.533  1.00 25.76           N  
ATOM    788  CA  GLY    99     -77.507  69.920  48.536  1.00 26.48           C  
ATOM    789  C   GLY    99     -78.005  68.878  47.556  1.00 27.11           C  
ATOM    790  O   GLY    99     -79.205  68.622  47.475  1.00 28.11           O  
ATOM    791  N   TYR   100     -77.090  68.268  46.810  1.00 27.06           N  
ATOM    792  CA  TYR   100     -77.471  67.260  45.830  1.00 26.88           C  
ATOM    793  C   TYR   100     -76.737  65.938  46.021  1.00 26.77           C  
ATOM    794  O   TYR   100     -76.454  65.241  45.045  1.00 26.45           O  
ATOM    795  CB  TYR   100     -77.216  67.790  44.416  1.00 26.83           C  
ATOM    796  CG  TYR   100     -78.134  68.920  44.026  1.00 27.96           C  
ATOM    797  CD1 TYR   100     -79.290  68.681  43.280  1.00 28.42           C  
ATOM    798  CD2 TYR   100     -77.876  70.224  44.442  1.00 27.95           C  
ATOM    799  CE1 TYR   100     -80.165  69.710  42.963  1.00 29.27           C  
ATOM    800  CE2 TYR   100     -78.745  71.260  44.132  1.00 29.69           C  
ATOM    801  CZ  TYR   100     -79.888  70.995  43.394  1.00 30.10           C  
ATOM    802  OH  TYR   100     -80.762  72.014  43.104  1.00 32.14           O  
ATOM    803  N   GLU   101     -76.440  65.586  47.270  1.00 26.77           N  
ATOM    804  CA  GLU   101     -75.725  64.342  47.548  1.00 27.51           C  
ATOM    805  C   GLU   101     -76.450  63.107  47.017  1.00 27.09           C  
ATOM    806  O   GLU   101     -75.805  62.157  46.583  1.00 26.39           O  
ATOM    807  CB  GLU   101     -75.472  64.182  49.050  1.00 27.72           C  
ATOM    808  CG  GLU   101     -74.741  65.353  49.690  1.00 32.19           C  
ATOM    809  CD  GLU   101     -74.251  65.042  51.090  1.00 38.46           C  
ATOM    810  OE1 GLU   101     -74.892  64.222  51.786  1.00 39.16           O  
ATOM    811  OE2 GLU   101     -73.228  65.629  51.503  1.00 39.59           O  
ATOM    812  N   ASP   102     -77.782  63.107  47.053  1.00 27.04           N  
ATOM    813  CA  ASP   102     -78.530  61.958  46.550  1.00 28.24           C  
ATOM    814  C   ASP   102     -78.176  61.698  45.089  1.00 27.01           C  
ATOM    815  O   ASP   102     -77.870  60.568  44.711  1.00 27.01           O  
ATOM    816  CB  ASP   102     -80.041  62.180  46.682  1.00 29.05           C  
ATOM    817  CG  ASP   102     -80.509  62.180  48.129  1.00 33.51           C  
ATOM    818  OD1 ASP   102     -79.665  61.969  49.028  1.00 37.22           O  
ATOM    819  OD2 ASP   102     -81.720  62.388  48.369  1.00 36.39           O  
ATOM    820  N   PHE   103     -78.221  62.744  44.267  1.00 26.57           N  
ATOM    821  CA  PHE   103     -77.888  62.611  42.851  1.00 25.89           C  
ATOM    822  C   PHE   103     -76.499  62.006  42.681  1.00 25.29           C  
ATOM    823  O   PHE   103     -76.314  61.024  41.961  1.00 24.73           O  
ATOM    824  CB  PHE   103     -77.906  63.976  42.160  1.00 26.89           C  
ATOM    825  CG  PHE   103     -77.163  63.994  40.852  1.00 28.43           C  
ATOM    826  CD1 PHE   103     -77.753  63.501  39.690  1.00 28.63           C  
ATOM    827  CD2 PHE   103     -75.846  64.445  40.797  1.00 29.61           C  
ATOM    828  CE1 PHE   103     -77.044  63.456  38.496  1.00 29.02           C  
ATOM    829  CE2 PHE   103     -75.123  64.405  39.604  1.00 29.18           C  
ATOM    830  CZ  PHE   103     -75.722  63.907  38.453  1.00 28.80           C  
ATOM    831  N   THR   104     -75.525  62.618  43.344  1.00 24.52           N  
ATOM    832  CA  THR   104     -74.138  62.184  43.257  1.00 24.46           C  
ATOM    833  C   THR   104     -73.958  60.740  43.710  1.00 24.86           C  
ATOM    834  O   THR   104     -73.264  59.957  43.064  1.00 23.72           O  
ATOM    835  CB  THR   104     -73.238  63.114  44.093  1.00 24.49           C  
ATOM    836  OG1 THR   104     -73.424  64.465  43.652  1.00 23.86           O  
ATOM    837  CG2 THR   104     -71.777  62.732  43.935  1.00 23.34           C  
ATOM    838  N   ARG   105     -74.591  60.392  44.822  1.00 25.45           N  
ATOM    839  CA  ARG   105     -74.510  59.039  45.350  1.00 26.91           C  
ATOM    840  C   ARG   105     -75.113  58.049  44.350  1.00 26.97           C  
ATOM    841  O   ARG   105     -74.550  56.979  44.125  1.00 27.03           O  
ATOM    842  CB  ARG   105     -75.231  58.966  46.702  1.00 26.66           C  
ATOM    843  CG  ARG   105     -75.184  57.612  47.393  1.00 29.82           C  
ATOM    844  CD  ARG   105     -75.518  57.769  48.873  1.00 32.79           C  
ATOM    845  NE  ARG   105     -76.771  58.494  49.051  1.00 36.37           N  
ATOM    846  CZ  ARG   105     -76.919  59.584  49.797  1.00 37.55           C  
ATOM    847  NH1 ARG   105     -75.890  60.100  50.460  1.00 33.56           N  
ATOM    848  NH2 ARG   105     -78.104  60.172  49.865  1.00 39.34           N  
ATOM    849  N   ASP   106     -76.241  58.406  43.737  1.00 27.32           N  
ATOM    850  CA  ASP   106     -76.860  57.520  42.755  1.00 27.70           C  
ATOM    851  C   ASP   106     -75.931  57.368  41.554  1.00 27.04           C  
ATOM    852  O   ASP   106     -75.707  56.259  41.068  1.00 27.73           O  
ATOM    853  CB  ASP   106     -78.220  58.059  42.281  1.00 28.25           C  
ATOM    854  CG  ASP   106     -79.300  57.961  43.349  1.00 32.62           C  
ATOM    855  OD1 ASP   106     -79.130  57.181  44.313  1.00 34.87           O  
ATOM    856  OD2 ASP   106     -80.332  58.659  43.217  1.00 36.81           O  
ATOM    857  N   PHE   107     -75.391  58.486  41.071  1.00 26.33           N  
ATOM    858  CA  PHE   107     -74.482  58.438  39.930  1.00 24.84           C  
ATOM    859  C   PHE   107     -73.305  57.514  40.227  1.00 24.17           C  
ATOM    860  O   PHE   107     -72.957  56.654  39.415  1.00 22.95           O  
ATOM    861  CB  PHE   107     -73.938  59.832  39.601  1.00 25.02           C  
ATOM    862  CG  PHE   107     -72.896  59.828  38.511  1.00 25.29           C  
ATOM    863  CD1 PHE   107     -73.268  59.764  37.173  1.00 25.79           C  
ATOM    864  CD2 PHE   107     -71.541  59.846  38.829  1.00 28.08           C  
ATOM    865  CE1 PHE   107     -72.308  59.716  36.168  1.00 23.75           C  
ATOM    866  CE2 PHE   107     -70.569  59.799  37.833  1.00 25.26           C  
ATOM    867  CZ  PHE   107     -70.955  59.733  36.498  1.00 23.76           C  
ATOM    868  N   LEU   108     -72.688  57.708  41.391  1.00 23.49           N  
ATOM    869  CA  LEU   108     -71.542  56.899  41.785  1.00 23.47           C  
ATOM    870  C   LEU   108     -71.907  55.427  41.950  1.00 23.81           C  
ATOM    871  O   LEU   108     -71.148  54.555  41.537  1.00 24.04           O  
ATOM    872  CB  LEU   108     -70.926  57.444  43.081  1.00 22.50           C  
ATOM    873  CG  LEU   108     -70.191  58.784  42.927  1.00 22.45           C  
ATOM    874  CD1 LEU   108     -69.762  59.313  44.286  1.00 21.18           C  
ATOM    875  CD2 LEU   108     -68.985  58.598  42.026  1.00 23.95           C  
ATOM    876  N   ASN   109     -73.060  55.141  42.550  1.00 23.97           N  
ATOM    877  CA  ASN   109     -73.450  53.744  42.713  1.00 25.23           C  
ATOM    878  C   ASN   109     -73.646  53.066  41.361  1.00 25.47           C  
ATOM    879  O   ASN   109     -73.353  51.882  41.214  1.00 24.83           O  
ATOM    880  CB  ASN   109     -74.732  53.607  43.544  1.00 25.25           C  
ATOM    881  CG  ASN   109     -74.489  53.807  45.031  1.00 25.96           C  
ATOM    882  OD1 ASN   109     -73.395  53.554  45.535  1.00 28.04           O  
ATOM    883  ND2 ASN   109     -75.519  54.238  45.745  1.00 24.71           N  
ATOM    884  N   GLU   110     -74.122  53.812  40.369  1.00 26.34           N  
ATOM    885  CA  GLU   110     -74.336  53.224  39.048  1.00 27.97           C  
ATOM    886  C   GLU   110     -73.062  53.051  38.218  1.00 27.88           C  
ATOM    887  O   GLU   110     -72.802  51.969  37.695  1.00 28.50           O  
ATOM    888  CB  GLU   110     -75.335  54.055  38.236  1.00 28.81           C  
ATOM    889  CG  GLU   110     -75.764  53.367  36.943  1.00 32.90           C  
ATOM    890  CD  GLU   110     -76.752  54.185  36.136  1.00 39.42           C  
ATOM    891  OE1 GLU   110     -77.441  55.040  36.733  1.00 40.89           O  
ATOM    892  OE2 GLU   110     -76.851  53.961  34.907  1.00 41.96           O  
ATOM    893  N   TYR   111     -72.271  54.114  38.098  1.00 27.53           N  
ATOM    894  CA  TYR   111     -71.059  54.071  37.287  1.00 26.90           C  
ATOM    895  C   TYR   111     -69.766  53.773  38.045  1.00 26.84           C  
ATOM    896  O   TYR   111     -68.739  53.478  37.437  1.00 27.10           O  
ATOM    897  CB  TYR   111     -70.926  55.384  36.519  1.00 27.47           C  
ATOM    898  CG  TYR   111     -72.097  55.645  35.603  1.00 27.55           C  
ATOM    899  CD1 TYR   111     -72.202  55.002  34.372  1.00 26.98           C  
ATOM    900  CD2 TYR   111     -73.123  56.502  35.988  1.00 29.42           C  
ATOM    901  CE1 TYR   111     -73.304  55.207  33.543  1.00 28.45           C  
ATOM    902  CE2 TYR   111     -74.228  56.713  35.170  1.00 28.62           C  
ATOM    903  CZ  TYR   111     -74.309  56.064  33.949  1.00 29.31           C  
ATOM    904  OH  TYR   111     -75.385  56.292  33.123  1.00 31.45           O  
ATOM    905  N   GLY   112     -69.815  53.837  39.367  1.00 26.26           N  
ATOM    906  CA  GLY   112     -68.630  53.551  40.147  1.00 26.43           C  
ATOM    907  C   GLY   112     -67.948  52.245  39.774  1.00 26.24           C  
ATOM    908  O   GLY   112     -66.725  52.199  39.699  1.00 26.15           O  
ATOM    909  N   PRO   113     -68.710  51.164  39.528  1.00 26.34           N  
ATOM    910  CA  PRO   113     -68.123  49.868  39.170  1.00 26.29           C  
ATOM    911  C   PRO   113     -67.258  49.870  37.910  1.00 26.24           C  
ATOM    912  O   PRO   113     -66.411  48.996  37.733  1.00 26.46           O  
ATOM    913  CB  PRO   113     -69.350  48.963  39.032  1.00 26.37           C  
ATOM    914  CG  PRO   113     -70.328  49.571  39.993  1.00 25.96           C  
ATOM    915  CD  PRO   113     -70.171  51.044  39.685  1.00 26.23           C  
ATOM    916  N   GLN   114     -67.464  50.843  37.032  1.00 26.46           N  
ATOM    917  CA  GLN   114     -66.677  50.906  35.803  1.00 26.98           C  
ATOM    918  C   GLN   114     -65.443  51.785  35.949  1.00 26.98           C  
ATOM    919  O   GLN   114     -64.702  51.979  34.988  1.00 26.81           O  
ATOM    920  CB  GLN   114     -67.519  51.457  34.658  1.00 26.93           C  
ATOM    921  CG  GLN   114     -68.703  50.607  34.276  1.00 26.74           C  
ATOM    922  CD  GLN   114     -69.487  51.237  33.147  1.00 28.43           C  
ATOM    923  OE1 GLN   114     -68.997  51.347  32.022  1.00 28.45           O  
ATOM    924  NE2 GLN   114     -70.701  51.679  33.445  1.00 28.19           N  
ATOM    925  N   THR   115     -65.226  52.316  37.147  1.00 27.37           N  
ATOM    926  CA  THR   115     -64.099  53.208  37.389  1.00 26.71           C  
ATOM    927  C   THR   115     -63.005  52.555  38.215  1.00 27.27           C  
ATOM    928  O   THR   115     -63.245  51.581  38.929  1.00 26.34           O  
ATOM    929  CB  THR   115     -64.561  54.486  38.097  1.00 26.98           C  
ATOM    930  OG1 THR   115     -64.949  54.180  39.441  1.00 24.18           O  
ATOM    931  CG2 THR   115     -65.738  55.088  37.357  1.00 25.44           C  
ATOM    932  N   ASP   116     -61.811  53.134  38.148  1.00 27.69           N  
ATOM    933  CA  ASP   116     -60.644  52.592  38.829  1.00 28.15           C  
ATOM    934  C   ASP   116     -59.892  53.624  39.694  1.00 27.11           C  
ATOM    935  O   ASP   116     -58.948  53.280  40.405  1.00 26.06           O  
ATOM    936  CB  ASP   116     -59.716  51.993  37.767  1.00 30.01           C  
ATOM    937  CG  ASP   116     -58.569  51.231  38.360  1.00 35.69           C  
ATOM    938  OD1 ASP   116     -58.758  50.638  39.441  1.00 42.39           O  
ATOM    939  OD2 ASP   116     -57.484  51.211  37.738  1.00 41.43           O  
ATOM    940  N   ASP   117     -60.303  54.888  39.619  1.00 25.47           N  
ATOM    941  CA  ASP   117     -59.694  55.966  40.408  1.00 23.45           C  
ATOM    942  C   ASP   117     -60.688  57.118  40.362  1.00 22.39           C  
ATOM    943  O   ASP   117     -61.698  57.031  39.668  1.00 21.77           O  
ATOM    944  CB  ASP   117     -58.342  56.370  39.800  1.00 22.99           C  
ATOM    945  CG  ASP   117     -57.547  57.335  40.677  1.00 24.26           C  
ATOM    946  OD1 ASP   117     -57.827  57.461  41.887  1.00 22.53           O  
ATOM    947  OD2 ASP   117     -56.611  57.960  40.145  1.00 24.59           O  
ATOM    948  N   GLY   118     -60.428  58.180  41.114  1.00 21.63           N  
ATOM    949  CA  GLY   118     -61.354  59.295  41.116  1.00 19.51           C  
ATOM    950  C   GLY   118     -60.914  60.468  41.962  1.00 18.99           C  
ATOM    951  O   GLY   118     -60.043  60.349  42.820  1.00 18.05           O  
ATOM    952  N   VAL   119     -61.532  61.614  41.705  1.00 18.80           N  
ATOM    953  CA  VAL   119     -61.256  62.832  42.447  1.00 17.41           C  
ATOM    954  C   VAL   119     -62.601  63.478  42.743  1.00 17.43           C  
ATOM    955  O   VAL   119     -63.487  63.490  41.882  1.00 18.20           O  
ATOM    956  CB  VAL   119     -60.403  63.825  41.616  1.00 17.81           C  
ATOM    957  CG1 VAL   119     -60.163  65.101  42.413  1.00 16.69           C  
ATOM    958  CG2 VAL   119     -59.069  63.182  41.230  1.00 16.97           C  
ATOM    959  N   LEU   120     -62.760  63.986  43.962  1.00 16.82           N  
ATOM    960  CA  LEU   120     -63.986  64.671  44.360  1.00 17.38           C  
ATOM    961  C   LEU   120     -63.597  66.142  44.481  1.00 17.17           C  
ATOM    962  O   LEU   120     -62.737  66.486  45.289  1.00 17.15           O  
ATOM    963  CB  LEU   120     -64.468  64.159  45.712  1.00 16.71           C  
ATOM    964  CG  LEU   120     -65.969  64.064  46.011  1.00 20.78           C  
ATOM    965  CD1 LEU   120     -66.183  64.233  47.521  1.00 20.41           C  
ATOM    966  CD2 LEU   120     -66.756  65.100  45.242  1.00 21.06           C  
ATOM    967  N   SER   121     -64.232  67.001  43.691  1.00 17.10           N  
ATOM    968  CA  SER   121     -63.886  68.420  43.688  1.00 16.92           C  
ATOM    969  C   SER   121     -65.043  69.385  43.917  1.00 16.32           C  
ATOM    970  O   SER   121     -66.179  69.141  43.501  1.00 15.79           O  
ATOM    971  CB  SER   121     -63.209  68.790  42.357  1.00 16.83           C  
ATOM    972  OG  SER   121     -62.043  68.020  42.120  1.00 18.99           O  
ATOM    973  N   LEU   122     -64.735  70.508  44.552  1.00 16.44           N  
ATOM    974  CA  LEU   122     -65.731  71.539  44.801  1.00 16.97           C  
ATOM    975  C   LEU   122     -65.498  72.634  43.742  1.00 16.96           C  
ATOM    976  O   LEU   122     -64.427  73.246  43.715  1.00 15.90           O  
ATOM    977  CB  LEU   122     -65.541  72.110  46.205  1.00 17.13           C  
ATOM    978  CG  LEU   122     -66.750  72.665  46.966  1.00 20.25           C  
ATOM    979  CD1 LEU   122     -66.325  73.910  47.739  1.00 16.95           C  
ATOM    980  CD2 LEU   122     -67.888  72.980  46.014  1.00 21.09           C  
ATOM    981  N   HIS   123     -66.495  72.868  42.884  1.00 16.64           N  
ATOM    982  CA  HIS   123     -66.402  73.881  41.817  1.00 16.90           C  
ATOM    983  C   HIS   123     -67.499  74.943  41.891  1.00 17.39           C  
ATOM    984  O   HIS   123     -67.366  76.018  41.299  1.00 17.02           O  
ATOM    985  CB  HIS   123     -66.479  73.232  40.430  1.00 16.08           C  
ATOM    986  CG  HIS   123     -65.332  72.328  40.114  1.00 16.50           C  
ATOM    987  ND1 HIS   123     -65.507  71.021  39.708  1.00 15.45           N  
ATOM    988  CD2 HIS   123     -63.994  72.538  40.135  1.00 15.14           C  
ATOM    989  CE1 HIS   123     -64.328  70.466  39.495  1.00 15.55           C  
ATOM    990  NE2 HIS   123     -63.393  71.366  39.748  1.00 16.05           N  
ATOM    991  N   PHE   124     -68.590  74.629  42.586  1.00 17.90           N  
ATOM    992  CA  PHE   124     -69.695  75.567  42.721  1.00 18.73           C  
ATOM    993  C   PHE   124     -70.096  75.824  44.175  1.00 18.98           C  
ATOM    994  O   PHE   124     -70.113  74.911  45.004  1.00 18.87           O  
ATOM    995  CB  PHE   124     -70.939  75.075  41.966  1.00 19.58           C  
ATOM    996  CG  PHE   124     -70.731  74.875  40.488  1.00 20.54           C  
ATOM    997  CD1 PHE   124     -70.274  73.654  40.000  1.00 18.44           C  
ATOM    998  CD2 PHE   124     -71.019  75.897  39.586  1.00 16.86           C  
ATOM    999  CE1 PHE   124     -70.105  73.450  38.638  1.00 20.85           C  
ATOM   1000  CE2 PHE   124     -70.852  75.707  38.217  1.00 18.55           C  
ATOM   1001  CZ  PHE   124     -70.394  74.478  37.741  1.00 19.89           C  
ATOM   1002  N   LEU   125     -70.421  77.078  44.465  1.00 19.01           N  
ATOM   1003  CA  LEU   125     -70.875  77.487  45.789  1.00 20.31           C  
ATOM   1004  C   LEU   125     -72.182  78.254  45.622  1.00 20.08           C  
ATOM   1005  O   LEU   125     -72.467  78.755  44.538  1.00 20.30           O  
ATOM   1006  CB  LEU   125     -69.856  78.419  46.443  1.00 20.06           C  
ATOM   1007  CG  LEU   125     -68.715  77.830  47.266  1.00 22.86           C  
ATOM   1008  CD1 LEU   125     -67.877  78.978  47.812  1.00 19.08           C  
ATOM   1009  CD2 LEU   125     -69.276  76.978  48.412  1.00 20.92           C  
ATOM   1010  N   GLU   126     -72.980  78.345  46.679  1.00 20.58           N  
ATOM   1011  CA  GLU   126     -74.199  79.145  46.590  1.00 21.38           C  
ATOM   1012  C   GLU   126     -73.722  80.587  46.486  1.00 20.33           C  
ATOM   1013  O   GLU   126     -72.813  80.997  47.207  1.00 19.93           O  
ATOM   1014  CB  GLU   126     -75.070  78.984  47.839  1.00 22.40           C  
ATOM   1015  CG  GLU   126     -75.661  77.589  47.996  1.00 28.31           C  
ATOM   1016  CD  GLU   126     -76.436  77.431  49.287  1.00 36.74           C  
ATOM   1017  OE1 GLU   126     -76.150  76.469  50.037  1.00 39.48           O  
ATOM   1018  OE2 GLU   126     -77.326  78.266  49.552  1.00 37.17           O  
ATOM   1019  N   GLY   127     -74.320  81.344  45.575  1.00 19.41           N  
ATOM   1020  CA  GLY   127     -73.934  82.728  45.393  1.00 19.12           C  
ATOM   1021  C   GLY   127     -75.086  83.604  44.946  1.00 20.12           C  
ATOM   1022  O   GLY   127     -76.260  83.251  45.113  1.00 18.44           O  
ATOM   1023  N   GLN   128     -74.740  84.750  44.369  1.00 19.52           N  
ATOM   1024  CA  GLN   128     -75.724  85.714  43.908  1.00 20.70           C  
ATOM   1025  C   GLN   128     -76.590  85.165  42.785  1.00 20.50           C  
ATOM   1026  O   GLN   128     -76.101  84.890  41.689  1.00 21.20           O  
ATOM   1027  CB  GLN   128     -75.025  86.991  43.437  1.00 20.60           C  
ATOM   1028  CG  GLN   128     -75.961  88.171  43.192  1.00 22.83           C  
ATOM   1029  CD  GLN   128     -76.644  88.644  44.464  1.00 25.86           C  
ATOM   1030  OE1 GLN   128     -76.033  88.668  45.533  1.00 26.02           O  
ATOM   1031  NE2 GLN   128     -77.911  89.041  44.351  1.00 26.03           N  
ATOM   1032  N   GLY   129     -77.879  85.000  43.075  1.00 20.52           N  
ATOM   1033  CA  GLY   129     -78.812  84.504  42.081  1.00 19.84           C  
ATOM   1034  C   GLY   129     -78.925  82.992  42.003  1.00 20.71           C  
ATOM   1035  O   GLY   129     -79.748  82.475  41.251  1.00 20.50           O  
ATOM   1036  N   GLY   130     -78.114  82.277  42.786  1.00 20.70           N  
ATOM   1037  CA  GLY   130     -78.134  80.820  42.764  1.00 19.96           C  
ATOM   1038  C   GLY   130     -76.716  80.268  42.804  1.00 20.99           C  
ATOM   1039  O   GLY   130     -75.788  80.989  43.173  1.00 20.79           O  
ATOM   1040  N   PHE   131     -76.526  79.006  42.426  1.00 20.77           N  
ATOM   1041  CA  PHE   131     -75.182  78.426  42.443  1.00 21.15           C  
ATOM   1042  C   PHE   131     -74.246  79.156  41.486  1.00 20.05           C  
ATOM   1043  O   PHE   131     -74.615  79.474  40.354  1.00 19.99           O  
ATOM   1044  CB  PHE   131     -75.228  76.937  42.093  1.00 21.84           C  
ATOM   1045  CG  PHE   131     -75.770  76.078  43.197  1.00 27.48           C  
ATOM   1046  CD1 PHE   131     -75.052  75.905  44.375  1.00 30.02           C  
ATOM   1047  CD2 PHE   131     -77.017  75.475  43.074  1.00 31.97           C  
ATOM   1048  CE1 PHE   131     -75.569  75.146  45.419  1.00 34.60           C  
ATOM   1049  CE2 PHE   131     -77.543  74.713  44.113  1.00 34.22           C  
ATOM   1050  CZ  PHE   131     -76.818  74.550  45.287  1.00 34.10           C  
ATOM   1051  N   ARG   132     -73.030  79.416  41.947  1.00 17.63           N  
ATOM   1052  CA  ARG   132     -72.048  80.132  41.144  1.00 16.94           C  
ATOM   1053  C   ARG   132     -70.723  79.383  41.030  1.00 17.28           C  
ATOM   1054  O   ARG   132     -70.370  78.579  41.895  1.00 17.29           O  
ATOM   1055  CB  ARG   132     -71.811  81.516  41.744  1.00 16.23           C  
ATOM   1056  CG  ARG   132     -72.984  82.462  41.561  1.00 16.78           C  
ATOM   1057  CD  ARG   132     -73.015  83.000  40.134  1.00 19.35           C  
ATOM   1058  NE  ARG   132     -73.623  84.319  40.123  1.00 27.72           N  
ATOM   1059  CZ  ARG   132     -73.098  85.386  39.540  1.00 25.75           C  
ATOM   1060  NH1 ARG   132     -71.940  85.307  38.895  1.00 23.41           N  
ATOM   1061  NH2 ARG   132     -73.731  86.544  39.626  1.00 32.88           N  
ATOM   1062  N   SER   133     -69.986  79.664  39.963  1.00 16.91           N  
ATOM   1063  CA  SER   133     -68.718  79.004  39.731  1.00 18.41           C  
ATOM   1064  C   SER   133     -67.578  79.643  40.499  1.00 18.91           C  
ATOM   1065  O   SER   133     -67.457  80.866  40.583  1.00 20.07           O  
ATOM   1066  CB  SER   133     -68.373  79.009  38.244  1.00 17.95           C  
ATOM   1067  OG  SER   133     -67.112  78.396  38.018  1.00 18.54           O  
ATOM   1068  N   ILE   134     -66.726  78.786  41.036  1.00 18.90           N  
ATOM   1069  CA  ILE   134     -65.564  79.223  41.782  1.00 18.73           C  
ATOM   1070  C   ILE   134     -64.404  79.500  40.822  1.00 18.92           C  
ATOM   1071  O   ILE   134     -63.588  80.387  41.065  1.00 18.94           O  
ATOM   1072  CB  ILE   134     -65.110  78.118  42.764  1.00 19.30           C  
ATOM   1073  CG1 ILE   134     -66.157  77.942  43.865  1.00 18.83           C  
ATOM   1074  CG2 ILE   134     -63.727  78.451  43.348  1.00 19.78           C  
ATOM   1075  CD1 ILE   134     -65.957  76.680  44.698  1.00 20.43           C  
ATOM   1076  N   ASP   135     -64.357  78.764  39.714  1.00 19.40           N  
ATOM   1077  CA  ASP   135     -63.217  78.875  38.798  1.00 21.59           C  
ATOM   1078  C   ASP   135     -63.420  79.327  37.345  1.00 21.50           C  
ATOM   1079  O   ASP   135     -62.493  79.233  36.539  1.00 22.74           O  
ATOM   1080  CB  ASP   135     -62.479  77.529  38.790  1.00 22.00           C  
ATOM   1081  CG  ASP   135     -63.357  76.397  38.300  1.00 23.63           C  
ATOM   1082  OD1 ASP   135     -64.564  76.638  38.101  1.00 27.42           O  
ATOM   1083  OD2 ASP   135     -62.860  75.269  38.108  1.00 27.62           O  
ATOM   1084  N   PHE   136     -64.599  79.827  36.995  1.00 21.77           N  
ATOM   1085  CA  PHE   136     -64.815  80.255  35.617  1.00 21.47           C  
ATOM   1086  C   PHE   136     -63.986  81.484  35.231  1.00 21.69           C  
ATOM   1087  O   PHE   136     -63.264  81.459  34.239  1.00 21.25           O  
ATOM   1088  CB  PHE   136     -66.291  80.540  35.363  1.00 21.88           C  
ATOM   1089  CG  PHE   136     -66.595  80.831  33.927  1.00 23.93           C  
ATOM   1090  CD1 PHE   136     -66.558  79.812  32.976  1.00 24.41           C  
ATOM   1091  CD2 PHE   136     -66.858  82.132  33.509  1.00 24.01           C  
ATOM   1092  CE1 PHE   136     -66.777  80.085  31.626  1.00 24.93           C  
ATOM   1093  CE2 PHE   136     -67.079  82.419  32.159  1.00 24.65           C  
ATOM   1094  CZ  PHE   136     -67.038  81.394  31.217  1.00 24.69           C  
ATOM   1095  N   SER   137     -64.089  82.563  36.005  1.00 21.35           N  
ATOM   1096  CA  SER   137     -63.318  83.769  35.711  1.00 21.49           C  
ATOM   1097  C   SER   137     -63.298  84.710  36.907  1.00 21.91           C  
ATOM   1098  O   SER   137     -64.187  84.670  37.763  1.00 21.53           O  
ATOM   1099  CB  SER   137     -63.909  84.509  34.513  1.00 22.01           C  
ATOM   1100  OG  SER   137     -65.004  85.315  34.920  1.00 21.84           O  
ATOM   1101  N   ALA   138     -62.288  85.573  36.942  1.00 21.94           N  
ATOM   1102  CA  ALA   138     -62.129  86.529  38.029  1.00 22.39           C  
ATOM   1103  C   ALA   138     -63.368  87.407  38.223  1.00 22.62           C  
ATOM   1104  O   ALA   138     -63.858  87.550  39.347  1.00 22.57           O  
ATOM   1105  CB  ALA   138     -60.901  87.398  37.776  1.00 22.17           C  
ATOM   1106  N   GLU   139     -63.875  87.985  37.135  1.00 22.05           N  
ATOM   1107  CA  GLU   139     -65.049  88.855  37.209  1.00 22.71           C  
ATOM   1108  C   GLU   139     -66.286  88.089  37.681  1.00 21.48           C  
ATOM   1109  O   GLU   139     -67.070  88.590  38.495  1.00 21.62           O  
ATOM   1110  CB  GLU   139     -65.347  89.493  35.844  1.00 23.51           C  
ATOM   1111  CG  GLU   139     -64.249  90.403  35.288  1.00 27.62           C  
ATOM   1112  CD  GLU   139     -62.999  89.643  34.849  1.00 34.14           C  
ATOM   1113  OE1 GLU   139     -63.109  88.459  34.461  1.00 34.06           O  
ATOM   1114  OE2 GLU   139     -61.901  90.241  34.873  1.00 38.90           O  
ATOM   1115  N   ASP   140     -66.463  86.877  37.171  1.00 19.44           N  
ATOM   1116  CA  ASP   140     -67.606  86.075  37.564  1.00 19.61           C  
ATOM   1117  C   ASP   140     -67.496  85.685  39.035  1.00 18.98           C  
ATOM   1118  O   ASP   140     -68.484  85.732  39.777  1.00 18.38           O  
ATOM   1119  CB  ASP   140     -67.700  84.817  36.705  1.00 19.47           C  
ATOM   1120  CG  ASP   140     -68.956  84.020  36.987  1.00 22.31           C  
ATOM   1121  OD1 ASP   140     -70.058  84.501  36.631  1.00 23.22           O  
ATOM   1122  OD2 ASP   140     -68.842  82.920  37.567  1.00 24.47           O  
ATOM   1123  N   TYR   141     -66.287  85.310  39.446  1.00 19.04           N  
ATOM   1124  CA  TYR   141     -66.027  84.917  40.827  1.00 19.28           C  
ATOM   1125  C   TYR   141     -66.271  86.096  41.764  1.00 20.13           C  
ATOM   1126  O   TYR   141     -66.780  85.932  42.872  1.00 19.94           O  
ATOM   1127  CB  TYR   141     -64.581  84.424  40.985  1.00 17.39           C  
ATOM   1128  CG  TYR   141     -64.264  83.885  42.366  1.00 18.18           C  
ATOM   1129  CD1 TYR   141     -64.999  82.829  42.903  1.00 18.10           C  
ATOM   1130  CD2 TYR   141     -63.225  84.421  43.132  1.00 18.30           C  
ATOM   1131  CE1 TYR   141     -64.713  82.316  44.163  1.00 16.81           C  
ATOM   1132  CE2 TYR   141     -62.928  83.915  44.398  1.00 17.68           C  
ATOM   1133  CZ  TYR   141     -63.682  82.859  44.905  1.00 18.93           C  
ATOM   1134  OH  TYR   141     -63.418  82.346  46.158  1.00 18.17           O  
ATOM   1135  N   ASN   142     -65.903  87.287  41.310  1.00 20.72           N  
ATOM   1136  CA  ASN   142     -66.090  88.485  42.110  1.00 21.44           C  
ATOM   1137  C   ASN   142     -67.568  88.819  42.301  1.00 21.82           C  
ATOM   1138  O   ASN   142     -68.015  89.067  43.420  1.00 22.22           O  
ATOM   1139  CB  ASN   142     -65.374  89.668  41.456  1.00 21.19           C  
ATOM   1140  CG  ASN   142     -65.526  90.947  42.251  1.00 23.08           C  
ATOM   1141  OD1 ASN   142     -65.420  90.942  43.478  1.00 24.83           O  
ATOM   1142  ND2 ASN   142     -65.766  92.058  41.556  1.00 23.17           N  
ATOM   1143  N   GLU   143     -68.323  88.822  41.206  1.00 22.81           N  
ATOM   1144  CA  GLU   143     -69.742  89.168  41.259  1.00 23.61           C  
ATOM   1145  C   GLU   143     -70.623  88.094  41.886  1.00 22.47           C  
ATOM   1146  O   GLU   143     -71.559  88.398  42.628  1.00 22.85           O  
ATOM   1147  CB  GLU   143     -70.265  89.470  39.846  1.00 24.72           C  
ATOM   1148  CG  GLU   143     -69.517  90.572  39.110  1.00 31.28           C  
ATOM   1149  CD  GLU   143     -69.991  90.747  37.672  1.00 40.82           C  
ATOM   1150  OE1 GLU   143     -69.338  91.499  36.913  1.00 43.61           O  
ATOM   1151  OE2 GLU   143     -71.018  90.136  37.302  1.00 43.20           O  
ATOM   1152  N   GLY   144     -70.332  86.836  41.577  1.00 20.21           N  
ATOM   1153  CA  GLY   144     -71.150  85.754  42.085  1.00 19.65           C  
ATOM   1154  C   GLY   144     -70.841  85.256  43.482  1.00 19.22           C  
ATOM   1155  O   GLY   144     -71.752  84.865  44.208  1.00 18.45           O  
ATOM   1156  N   ILE   145     -69.565  85.290  43.865  1.00 18.31           N  
ATOM   1157  CA  ILE   145     -69.146  84.757  45.160  1.00 19.09           C  
ATOM   1158  C   ILE   145     -68.471  85.697  46.157  1.00 19.50           C  
ATOM   1159  O   ILE   145     -68.898  85.780  47.310  1.00 19.96           O  
ATOM   1160  CB  ILE   145     -68.237  83.528  44.945  1.00 18.54           C  
ATOM   1161  CG1 ILE   145     -69.085  82.384  44.378  1.00 17.50           C  
ATOM   1162  CG2 ILE   145     -67.551  83.117  46.256  1.00 18.38           C  
ATOM   1163  CD1 ILE   145     -68.290  81.192  43.868  1.00 19.02           C  
ATOM   1164  N   VAL   146     -67.429  86.404  45.734  1.00 19.08           N  
ATOM   1165  CA  VAL   146     -66.729  87.295  46.653  1.00 19.07           C  
ATOM   1166  C   VAL   146     -67.653  88.370  47.226  1.00 19.90           C  
ATOM   1167  O   VAL   146     -67.723  88.553  48.447  1.00 19.26           O  
ATOM   1168  CB  VAL   146     -65.509  87.967  45.975  1.00 20.07           C  
ATOM   1169  CG1 VAL   146     -64.782  88.870  46.974  1.00 17.37           C  
ATOM   1170  CG2 VAL   146     -64.561  86.899  45.436  1.00 16.59           C  
ATOM   1171  N   GLN   147     -68.370  89.073  46.354  1.00 19.68           N  
ATOM   1172  CA  GLN   147     -69.282  90.115  46.810  1.00 20.66           C  
ATOM   1173  C   GLN   147     -70.440  89.527  47.615  1.00 20.02           C  
ATOM   1174  O   GLN   147     -70.922  90.153  48.554  1.00 21.16           O  
ATOM   1175  CB  GLN   147     -69.835  90.916  45.625  1.00 21.57           C  
ATOM   1176  CG  GLN   147     -68.771  91.658  44.821  1.00 24.93           C  
ATOM   1177  CD  GLN   147     -69.354  92.657  43.831  1.00 31.16           C  
ATOM   1178  OE1 GLN   147     -70.368  92.394  43.184  1.00 34.27           O  
ATOM   1179  NE2 GLN   147     -68.702  93.806  43.701  1.00 34.07           N  
ATOM   1180  N   PHE   148     -70.875  88.321  47.250  1.00 19.21           N  
ATOM   1181  CA  PHE   148     -71.978  87.663  47.939  1.00 18.13           C  
ATOM   1182  C   PHE   148     -71.620  87.335  49.383  1.00 18.35           C  
ATOM   1183  O   PHE   148     -72.430  87.537  50.292  1.00 18.47           O  
ATOM   1184  CB  PHE   148     -72.373  86.376  47.200  1.00 18.59           C  
ATOM   1185  CG  PHE   148     -73.532  85.628  47.832  1.00 19.31           C  
ATOM   1186  CD1 PHE   148     -73.305  84.568  48.707  1.00 19.13           C  
ATOM   1187  CD2 PHE   148     -74.848  85.978  47.535  1.00 18.92           C  
ATOM   1188  CE1 PHE   148     -74.375  83.862  49.277  1.00 20.95           C  
ATOM   1189  CE2 PHE   148     -75.927  85.280  48.101  1.00 20.33           C  
ATOM   1190  CZ  PHE   148     -75.689  84.220  48.972  1.00 20.37           C  
ATOM   1191  N   TYR   149     -70.406  86.839  49.600  1.00 17.17           N  
ATOM   1192  CA  TYR   149     -69.978  86.471  50.941  1.00 17.94           C  
ATOM   1193  C   TYR   149     -69.372  87.598  51.768  1.00 18.05           C  
ATOM   1194  O   TYR   149     -69.147  87.432  52.965  1.00 17.84           O  
ATOM   1195  CB  TYR   149     -69.030  85.271  50.879  1.00 17.62           C  
ATOM   1196  CG  TYR   149     -69.756  83.987  50.551  1.00 18.10           C  
ATOM   1197  CD1 TYR   149     -70.607  83.385  51.484  1.00 19.32           C  
ATOM   1198  CD2 TYR   149     -69.637  83.402  49.295  1.00 18.31           C  
ATOM   1199  CE1 TYR   149     -71.324  82.232  51.164  1.00 18.76           C  
ATOM   1200  CE2 TYR   149     -70.349  82.249  48.962  1.00 18.28           C  
ATOM   1201  CZ  TYR   149     -71.190  81.672  49.900  1.00 17.17           C  
ATOM   1202  OH  TYR   149     -71.909  80.551  49.566  1.00 15.74           O  
ATOM   1203  N   GLY   150     -69.115  88.741  51.135  1.00 18.73           N  
ATOM   1204  CA  GLY   150     -68.583  89.881  51.864  1.00 19.52           C  
ATOM   1205  C   GLY   150     -67.123  90.237  51.655  1.00 19.53           C  
ATOM   1206  O   GLY   150     -66.662  91.245  52.180  1.00 19.89           O  
ATOM   1207  N   GLY   151     -66.391  89.423  50.901  1.00 20.05           N  
ATOM   1208  CA  GLY   151     -64.981  89.698  50.671  1.00 19.66           C  
ATOM   1209  C   GLY   151     -64.195  88.441  50.336  1.00 19.37           C  
ATOM   1210  O   GLY   151     -64.723  87.325  50.411  1.00 18.69           O  
ATOM   1211  N   PHE   152     -62.928  88.618  49.968  1.00 18.84           N  
ATOM   1212  CA  PHE   152     -62.100  87.482  49.584  1.00 19.69           C  
ATOM   1213  C   PHE   152     -61.952  86.449  50.697  1.00 19.50           C  
ATOM   1214  O   PHE   152     -62.082  85.251  50.448  1.00 19.96           O  
ATOM   1215  CB  PHE   152     -60.708  87.935  49.124  1.00 19.67           C  
ATOM   1216  CG  PHE   152     -59.965  86.881  48.351  1.00 20.26           C  
ATOM   1217  CD1 PHE   152     -60.273  86.634  47.013  1.00 19.81           C  
ATOM   1218  CD2 PHE   152     -59.002  86.097  48.971  1.00 17.65           C  
ATOM   1219  CE1 PHE   152     -59.633  85.617  46.309  1.00 20.35           C  
ATOM   1220  CE2 PHE   152     -58.359  85.078  48.274  1.00 22.32           C  
ATOM   1221  CZ  PHE   152     -58.678  84.839  46.938  1.00 17.77           C  
ATOM   1222  N   GLU   153     -61.675  86.907  51.917  1.00 19.30           N  
ATOM   1223  CA  GLU   153     -61.518  85.979  53.035  1.00 20.49           C  
ATOM   1224  C   GLU   153     -62.838  85.266  53.334  1.00 20.11           C  
ATOM   1225  O   GLU   153     -62.850  84.063  53.595  1.00 19.98           O  
ATOM   1226  CB  GLU   153     -61.035  86.693  54.300  1.00 21.59           C  
ATOM   1227  CG  GLU   153     -60.520  85.712  55.349  1.00 25.88           C  
ATOM   1228  CD  GLU   153     -60.308  86.329  56.721  1.00 31.96           C  
ATOM   1229  OE1 GLU   153     -59.934  87.518  56.792  1.00 34.23           O  
ATOM   1230  OE2 GLU   153     -60.497  85.612  57.731  1.00 34.56           O  
ATOM   1231  N   GLN   154     -63.940  86.011  53.315  1.00 19.01           N  
ATOM   1232  CA  GLN   154     -65.247  85.407  53.552  1.00 18.72           C  
ATOM   1233  C   GLN   154     -65.499  84.333  52.489  1.00 18.18           C  
ATOM   1234  O   GLN   154     -66.071  83.280  52.781  1.00 18.80           O  
ATOM   1235  CB  GLN   154     -66.354  86.462  53.506  1.00 18.07           C  
ATOM   1236  CG  GLN   154     -66.373  87.400  54.705  1.00 20.43           C  
ATOM   1237  CD  GLN   154     -65.609  88.689  54.469  1.00 22.77           C  
ATOM   1238  OE1 GLN   154     -64.586  88.710  53.778  1.00 22.99           O  
ATOM   1239  NE2 GLN   154     -66.098  89.777  55.058  1.00 23.95           N  
ATOM   1240  N   ALA   155     -65.057  84.598  51.263  1.00 16.90           N  
ATOM   1241  CA  ALA   155     -65.215  83.641  50.181  1.00 16.43           C  
ATOM   1242  C   ALA   155     -64.372  82.402  50.483  1.00 16.30           C  
ATOM   1243  O   ALA   155     -64.830  81.269  50.292  1.00 16.24           O  
ATOM   1244  CB  ALA   155     -64.790  84.263  48.860  1.00 16.24           C  
ATOM   1245  N   GLN   156     -63.143  82.623  50.951  1.00 16.21           N  
ATOM   1246  CA  GLN   156     -62.245  81.522  51.303  1.00 16.17           C  
ATOM   1247  C   GLN   156     -62.902  80.586  52.321  1.00 16.02           C  
ATOM   1248  O   GLN   156     -62.895  79.360  52.160  1.00 15.85           O  
ATOM   1249  CB  GLN   156     -60.939  82.051  51.920  1.00 16.32           C  
ATOM   1250  CG  GLN   156     -59.953  82.670  50.944  1.00 18.97           C  
ATOM   1251  CD  GLN   156     -58.735  83.250  51.651  1.00 22.46           C  
ATOM   1252  OE1 GLN   156     -57.603  83.089  51.194  1.00 24.94           O  
ATOM   1253  NE2 GLN   156     -58.966  83.931  52.770  1.00 17.51           N  
ATOM   1254  N   LEU   157     -63.445  81.176  53.381  1.00 15.59           N  
ATOM   1255  CA  LEU   157     -64.067  80.399  54.446  1.00 16.31           C  
ATOM   1256  C   LEU   157     -65.314  79.635  53.999  1.00 16.15           C  
ATOM   1257  O   LEU   157     -65.542  78.514  54.446  1.00 16.00           O  
ATOM   1258  CB  LEU   157     -64.377  81.311  55.641  1.00 16.37           C  
ATOM   1259  CG  LEU   157     -63.099  81.813  56.337  1.00 17.12           C  
ATOM   1260  CD1 LEU   157     -63.437  82.911  57.321  1.00 20.55           C  
ATOM   1261  CD2 LEU   157     -62.405  80.649  57.039  1.00 15.97           C  
ATOM   1262  N   ALA   158     -66.116  80.228  53.121  1.00 16.11           N  
ATOM   1263  CA  ALA   158     -67.310  79.542  52.623  1.00 17.00           C  
ATOM   1264  C   ALA   158     -66.871  78.386  51.721  1.00 17.36           C  
ATOM   1265  O   ALA   158     -67.490  77.325  51.701  1.00 17.75           O  
ATOM   1266  CB  ALA   158     -68.195  80.504  51.844  1.00 17.22           C  
ATOM   1267  N   TYR   159     -65.786  78.608  50.985  1.00 17.24           N  
ATOM   1268  CA  TYR   159     -65.234  77.599  50.091  1.00 17.56           C  
ATOM   1269  C   TYR   159     -64.732  76.409  50.899  1.00 18.03           C  
ATOM   1270  O   TYR   159     -65.058  75.261  50.587  1.00 18.39           O  
ATOM   1271  CB  TYR   159     -64.085  78.192  49.272  1.00 17.48           C  
ATOM   1272  CG  TYR   159     -63.208  77.158  48.610  1.00 17.79           C  
ATOM   1273  CD1 TYR   159     -63.638  76.466  47.471  1.00 18.24           C  
ATOM   1274  CD2 TYR   159     -61.961  76.834  49.150  1.00 16.46           C  
ATOM   1275  CE1 TYR   159     -62.848  75.477  46.896  1.00 16.00           C  
ATOM   1276  CE2 TYR   159     -61.168  75.853  48.582  1.00 15.74           C  
ATOM   1277  CZ  TYR   159     -61.616  75.175  47.458  1.00 14.74           C  
ATOM   1278  OH  TYR   159     -60.837  74.183  46.920  1.00 15.50           O  
ATOM   1279  N   LEU   160     -63.948  76.683  51.940  1.00 18.00           N  
ATOM   1280  CA  LEU   160     -63.412  75.615  52.785  1.00 18.59           C  
ATOM   1281  C   LEU   160     -64.520  74.859  53.516  1.00 18.99           C  
ATOM   1282  O   LEU   160     -64.397  73.658  53.760  1.00 19.08           O  
ATOM   1283  CB  LEU   160     -62.398  76.177  53.786  1.00 18.19           C  
ATOM   1284  CG  LEU   160     -61.137  76.755  53.134  1.00 17.60           C  
ATOM   1285  CD1 LEU   160     -60.248  77.389  54.184  1.00 18.17           C  
ATOM   1286  CD2 LEU   160     -60.392  75.657  52.394  1.00 17.78           C  
ATOM   1287  N   GLU   161     -65.590  75.560  53.881  1.00 19.53           N  
ATOM   1288  CA  GLU   161     -66.723  74.905  54.531  1.00 20.42           C  
ATOM   1289  C   GLU   161     -67.271  73.866  53.555  1.00 19.41           C  
ATOM   1290  O   GLU   161     -67.601  72.750  53.949  1.00 19.11           O  
ATOM   1291  CB  GLU   161     -67.810  75.923  54.884  1.00 21.45           C  
ATOM   1292  CG  GLU   161     -69.101  75.309  55.426  1.00 27.56           C  
ATOM   1293  CD  GLU   161     -68.851  74.276  56.517  1.00 33.72           C  
ATOM   1294  OE1 GLU   161     -68.078  74.572  57.456  1.00 38.36           O  
ATOM   1295  OE2 GLU   161     -69.429  73.167  56.434  1.00 34.52           O  
ATOM   1296  N   GLY   162     -67.327  74.236  52.274  1.00 19.71           N  
ATOM   1297  CA  GLY   162     -67.800  73.326  51.238  1.00 17.25           C  
ATOM   1298  C   GLY   162     -66.864  72.131  51.086  1.00 17.96           C  
ATOM   1299  O   GLY   162     -67.309  70.993  50.901  1.00 16.23           O  
ATOM   1300  N   VAL   163     -65.561  72.386  51.171  1.00 17.00           N  
ATOM   1301  CA  VAL   163     -64.575  71.317  51.060  1.00 17.82           C  
ATOM   1302  C   VAL   163     -64.769  70.360  52.231  1.00 18.34           C  
ATOM   1303  O   VAL   163     -64.735  69.143  52.059  1.00 18.60           O  
ATOM   1304  CB  VAL   163     -63.128  71.873  51.079  1.00 16.97           C  
ATOM   1305  CG1 VAL   163     -62.116  70.723  51.122  1.00 16.89           C  
ATOM   1306  CG2 VAL   163     -62.892  72.731  49.840  1.00 16.33           C  
ATOM   1307  N   LYS   164     -64.987  70.925  53.417  1.00 18.65           N  
ATOM   1308  CA  LYS   164     -65.201  70.136  54.629  1.00 19.29           C  
ATOM   1309  C   LYS   164     -66.422  69.233  54.438  1.00 19.38           C  
ATOM   1310  O   LYS   164     -66.380  68.045  54.764  1.00 19.61           O  
ATOM   1311  CB  LYS   164     -65.397  71.072  55.828  1.00 19.42           C  
ATOM   1312  CG  LYS   164     -65.532  70.369  57.190  1.00 21.89           C  
ATOM   1313  CD  LYS   164     -65.479  71.396  58.322  1.00 25.85           C  
ATOM   1314  CE  LYS   164     -65.712  70.770  59.689  1.00 30.77           C  
ATOM   1315  NZ  LYS   164     -67.125  70.331  59.871  1.00 31.88           N  
ATOM   1316  N   GLN   165     -67.504  69.795  53.902  1.00 19.51           N  
ATOM   1317  CA  GLN   165     -68.712  69.013  53.649  1.00 20.69           C  
ATOM   1318  C   GLN   165     -68.458  67.873  52.664  1.00 19.56           C  
ATOM   1319  O   GLN   165     -68.972  66.772  52.848  1.00 19.71           O  
ATOM   1320  CB  GLN   165     -69.831  69.897  53.096  1.00 21.02           C  
ATOM   1321  CG  GLN   165     -70.444  70.845  54.104  1.00 25.52           C  
ATOM   1322  CD  GLN   165     -71.551  71.674  53.489  1.00 30.06           C  
ATOM   1323  OE1 GLN   165     -71.363  72.299  52.445  1.00 32.66           O  
ATOM   1324  NE2 GLN   165     -72.711  71.681  54.126  1.00 32.11           N  
ATOM   1325  N   SER   166     -67.680  68.135  51.613  1.00 20.01           N  
ATOM   1326  CA  SER   166     -67.390  67.094  50.630  1.00 19.44           C  
ATOM   1327  C   SER   166     -66.643  65.932  51.282  1.00 19.33           C  
ATOM   1328  O   SER   166     -66.837  64.780  50.913  1.00 20.17           O  
ATOM   1329  CB  SER   166     -66.563  67.656  49.462  1.00 19.39           C  
ATOM   1330  OG  SER   166     -65.203  67.840  49.823  1.00 18.49           O  
ATOM   1331  N   ILE   167     -65.791  66.231  52.254  1.00 19.89           N  
ATOM   1332  CA  ILE   167     -65.040  65.180  52.936  1.00 19.79           C  
ATOM   1333  C   ILE   167     -65.943  64.367  53.861  1.00 20.72           C  
ATOM   1334  O   ILE   167     -65.842  63.143  53.920  1.00 19.98           O  
ATOM   1335  CB  ILE   167     -63.877  65.770  53.773  1.00 20.19           C  
ATOM   1336  CG1 ILE   167     -62.844  66.417  52.849  1.00 18.55           C  
ATOM   1337  CG2 ILE   167     -63.219  64.681  54.615  1.00 18.61           C  
ATOM   1338  CD1 ILE   167     -61.818  67.246  53.588  1.00 19.57           C  
ATOM   1339  N   GLU   168     -66.819  65.055  54.584  1.00 21.44           N  
ATOM   1340  CA  GLU   168     -67.732  64.397  55.517  1.00 22.82           C  
ATOM   1341  C   GLU   168     -68.841  63.624  54.798  1.00 23.36           C  
ATOM   1342  O   GLU   168     -69.426  62.700  55.358  1.00 22.90           O  
ATOM   1343  CB  GLU   168     -68.381  65.437  56.441  1.00 23.31           C  
ATOM   1344  CG  GLU   168     -67.395  66.295  57.215  1.00 26.17           C  
ATOM   1345  CD  GLU   168     -68.066  67.431  57.974  1.00 29.71           C  
ATOM   1346  OE1 GLU   168     -68.995  68.059  57.420  1.00 30.59           O  
ATOM   1347  OE2 GLU   168     -67.653  67.706  59.120  1.00 30.85           O  
ATOM   1348  N   ALA   169     -69.121  64.012  53.557  1.00 23.51           N  
ATOM   1349  CA  ALA   169     -70.202  63.411  52.780  1.00 24.98           C  
ATOM   1350  C   ALA   169     -70.169  61.892  52.606  1.00 26.02           C  
ATOM   1351  O   ALA   169     -69.117  61.296  52.347  1.00 25.90           O  
ATOM   1352  CB  ALA   169     -70.288  64.075  51.415  1.00 24.33           C  
ATOM   1353  N   ASP   170     -71.348  61.287  52.752  1.00 27.07           N  
ATOM   1354  CA  ASP   170     -71.533  59.855  52.549  1.00 28.75           C  
ATOM   1355  C   ASP   170     -72.059  59.724  51.128  1.00 28.18           C  
ATOM   1356  O   ASP   170     -73.236  59.964  50.873  1.00 28.71           O  
ATOM   1357  CB  ASP   170     -72.570  59.274  53.517  1.00 29.87           C  
ATOM   1358  CG  ASP   170     -73.244  58.022  52.963  1.00 34.17           C  
ATOM   1359  OD1 ASP   170     -72.519  57.107  52.509  1.00 40.00           O  
ATOM   1360  OD2 ASP   170     -74.496  57.955  52.976  1.00 35.02           O  
ATOM   1361  N   LEU   171     -71.181  59.377  50.198  1.00 27.38           N  
ATOM   1362  CA  LEU   171     -71.582  59.247  48.804  1.00 26.16           C  
ATOM   1363  C   LEU   171     -71.478  57.811  48.326  1.00 25.38           C  
ATOM   1364  O   LEU   171     -71.308  57.548  47.136  1.00 25.18           O  
ATOM   1365  CB  LEU   171     -70.730  60.176  47.929  1.00 26.12           C  
ATOM   1366  CG  LEU   171     -70.880  61.668  48.265  1.00 25.19           C  
ATOM   1367  CD1 LEU   171     -69.902  62.511  47.450  1.00 24.37           C  
ATOM   1368  CD2 LEU   171     -72.315  62.100  47.997  1.00 23.54           C  
ATOM   1369  N   GLY   172     -71.570  56.882  49.270  1.00 24.58           N  
ATOM   1370  CA  GLY   172     -71.525  55.479  48.912  1.00 24.17           C  
ATOM   1371  C   GLY   172     -70.132  54.886  48.852  1.00 23.58           C  
ATOM   1372  O   GLY   172     -69.137  55.561  49.135  1.00 23.52           O  
ATOM   1373  N   LEU   173     -70.067  53.614  48.471  1.00 22.35           N  
ATOM   1374  CA  LEU   173     -68.810  52.883  48.393  1.00 22.61           C  
ATOM   1375  C   LEU   173     -67.851  53.399  47.338  1.00 22.24           C  
ATOM   1376  O   LEU   173     -66.632  53.283  47.484  1.00 22.11           O  
ATOM   1377  CB  LEU   173     -69.088  51.404  48.113  1.00 23.06           C  
ATOM   1378  CG  LEU   173     -67.868  50.517  47.878  1.00 24.01           C  
ATOM   1379  CD1 LEU   173     -66.994  50.481  49.123  1.00 26.30           C  
ATOM   1380  CD2 LEU   173     -68.333  49.110  47.509  1.00 27.66           C  
ATOM   1381  N   PHE   174     -68.403  53.970  46.276  1.00 21.22           N  
ATOM   1382  CA  PHE   174     -67.589  54.454  45.172  1.00 21.30           C  
ATOM   1383  C   PHE   174     -67.182  55.926  45.238  1.00 20.95           C  
ATOM   1384  O   PHE   174     -66.700  56.490  44.255  1.00 20.64           O  
ATOM   1385  CB  PHE   174     -68.304  54.145  43.861  1.00 21.26           C  
ATOM   1386  CG  PHE   174     -68.526  52.675  43.644  1.00 23.57           C  
ATOM   1387  CD1 PHE   174     -67.493  51.857  43.191  1.00 23.77           C  
ATOM   1388  CD2 PHE   174     -69.757  52.094  43.946  1.00 24.63           C  
ATOM   1389  CE1 PHE   174     -67.685  50.473  43.041  1.00 26.27           C  
ATOM   1390  CE2 PHE   174     -69.959  50.721  43.802  1.00 23.85           C  
ATOM   1391  CZ  PHE   174     -68.920  49.908  43.348  1.00 25.02           C  
ATOM   1392  N   LYS   175     -67.366  56.546  46.398  1.00 20.44           N  
ATOM   1393  CA  LYS   175     -66.974  57.942  46.568  1.00 19.38           C  
ATOM   1394  C   LYS   175     -65.464  58.066  46.402  1.00 18.98           C  
ATOM   1395  O   LYS   175     -64.705  57.267  46.950  1.00 18.56           O  
ATOM   1396  CB  LYS   175     -67.354  58.435  47.966  1.00 20.15           C  
ATOM   1397  CG  LYS   175     -66.828  59.818  48.326  1.00 21.42           C  
ATOM   1398  CD  LYS   175     -67.352  60.215  49.691  1.00 25.65           C  
ATOM   1399  CE  LYS   175     -67.123  61.684  50.010  1.00 29.93           C  
ATOM   1400  NZ  LYS   175     -65.895  61.904  50.805  1.00 32.90           N  
ATOM   1401  N   PRO   176     -65.013  59.050  45.613  1.00 18.15           N  
ATOM   1402  CA  PRO   176     -63.574  59.227  45.428  1.00 17.21           C  
ATOM   1403  C   PRO   176     -62.926  59.437  46.793  1.00 17.67           C  
ATOM   1404  O   PRO   176     -63.570  59.923  47.726  1.00 17.11           O  
ATOM   1405  CB  PRO   176     -63.491  60.484  44.557  1.00 17.99           C  
ATOM   1406  CG  PRO   176     -64.733  60.389  43.723  1.00 17.80           C  
ATOM   1407  CD  PRO   176     -65.776  59.970  44.749  1.00 17.41           C  
ATOM   1408  N   ARG   177     -61.669  59.041  46.926  1.00 18.17           N  
ATOM   1409  CA  ARG   177     -60.964  59.231  48.187  1.00 19.75           C  
ATOM   1410  C   ARG   177     -59.842  60.263  48.049  1.00 19.79           C  
ATOM   1411  O   ARG   177     -59.068  60.481  48.978  1.00 19.29           O  
ATOM   1412  CB  ARG   177     -60.421  57.897  48.697  1.00 20.05           C  
ATOM   1413  CG  ARG   177     -61.528  57.004  49.233  1.00 22.64           C  
ATOM   1414  CD  ARG   177     -61.026  55.650  49.671  1.00 25.55           C  
ATOM   1415  NE  ARG   177     -62.137  54.795  50.085  1.00 28.98           N  
ATOM   1416  CZ  ARG   177     -62.019  53.502  50.365  1.00 28.31           C  
ATOM   1417  NH1 ARG   177     -60.834  52.914  50.278  1.00 27.16           N  
ATOM   1418  NH2 ARG   177     -63.083  52.797  50.721  1.00 28.53           N  
ATOM   1419  N   ARG   178     -59.753  60.892  46.881  1.00 19.58           N  
ATOM   1420  CA  ARG   178     -58.752  61.933  46.672  1.00 18.99           C  
ATOM   1421  C   ARG   178     -59.481  63.262  46.453  1.00 19.27           C  
ATOM   1422  O   ARG   178     -60.262  63.401  45.507  1.00 19.22           O  
ATOM   1423  CB  ARG   178     -57.854  61.598  45.474  1.00 18.29           C  
ATOM   1424  CG  ARG   178     -56.732  62.622  45.252  1.00 18.23           C  
ATOM   1425  CD  ARG   178     -55.537  62.053  44.469  1.00 16.89           C  
ATOM   1426  NE  ARG   178     -55.838  61.780  43.068  1.00 15.32           N  
ATOM   1427  CZ  ARG   178     -56.185  60.586  42.587  1.00 18.34           C  
ATOM   1428  NH1 ARG   178     -56.273  59.536  43.398  1.00 15.71           N  
ATOM   1429  NH2 ARG   178     -56.435  60.441  41.293  1.00 14.71           N  
ATOM   1430  N   MET   179     -59.250  64.218  47.350  1.00 19.23           N  
ATOM   1431  CA  MET   179     -59.907  65.529  47.271  1.00 19.68           C  
ATOM   1432  C   MET   179     -59.193  66.470  46.295  1.00 18.94           C  
ATOM   1433  O   MET   179     -58.004  66.757  46.449  1.00 17.91           O  
ATOM   1434  CB  MET   179     -59.973  66.171  48.666  1.00 20.18           C  
ATOM   1435  CG  MET   179     -60.581  65.272  49.749  1.00 22.77           C  
ATOM   1436  SD  MET   179     -62.447  64.761  49.429  1.00 33.41          SE  
ATOM   1437  CE  MET   179     -62.144  63.004  48.670  1.00 26.03           C  
ATOM   1438  N   GLY   180     -59.937  66.960  45.305  1.00 18.94           N  
ATOM   1439  CA  GLY   180     -59.355  67.833  44.294  1.00 17.90           C  
ATOM   1440  C   GLY   180     -58.971  69.246  44.710  1.00 18.13           C  
ATOM   1441  O   GLY   180     -59.691  69.892  45.470  1.00 17.18           O  
ATOM   1442  N   HIS   181     -57.825  69.710  44.205  1.00 18.74           N  
ATOM   1443  CA  HIS   181     -57.314  71.071  44.431  1.00 18.48           C  
ATOM   1444  C   HIS   181     -58.019  71.819  45.561  1.00 18.47           C  
ATOM   1445  O   HIS   181     -58.823  72.711  45.297  1.00 18.87           O  
ATOM   1446  CB  HIS   181     -57.461  71.873  43.131  1.00 19.21           C  
ATOM   1447  CG  HIS   181     -58.790  71.687  42.456  1.00 18.53           C  
ATOM   1448  ND1 HIS   181     -59.988  71.900  43.101  1.00 13.33           N  
ATOM   1449  CD2 HIS   181     -59.105  71.299  41.195  1.00 16.66           C  
ATOM   1450  CE1 HIS   181     -60.987  71.655  42.269  1.00 14.91           C  
ATOM   1451  NE2 HIS   181     -60.477  71.289  41.107  1.00 15.75           N  
ATOM   1452  N   ILE   182     -57.683  71.507  46.813  1.00 18.53           N  
ATOM   1453  CA  ILE   182     -58.377  72.115  47.948  1.00 19.78           C  
ATOM   1454  C   ILE   182     -58.154  73.586  48.284  1.00 19.78           C  
ATOM   1455  O   ILE   182     -58.519  74.030  49.369  1.00 21.85           O  
ATOM   1456  CB  ILE   182     -58.186  71.287  49.246  1.00 19.21           C  
ATOM   1457  CG1 ILE   182     -56.715  71.241  49.643  1.00 21.47           C  
ATOM   1458  CG2 ILE   182     -58.738  69.874  49.047  1.00 19.76           C  
ATOM   1459  CD1 ILE   182     -56.489  70.649  51.025  1.00 23.75           C  
ATOM   1460  N   SER   183     -57.576  74.348  47.365  1.00 19.67           N  
ATOM   1461  CA  SER   183     -57.404  75.774  47.598  1.00 19.02           C  
ATOM   1462  C   SER   183     -57.770  76.504  46.310  1.00 18.60           C  
ATOM   1463  O   SER   183     -57.144  77.502  45.939  1.00 18.29           O  
ATOM   1464  CB  SER   183     -55.968  76.095  48.006  1.00 19.03           C  
ATOM   1465  OG  SER   183     -55.065  75.781  46.965  1.00 20.37           O  
ATOM   1466  N   LEU   184     -58.798  75.988  45.644  1.00 18.07           N  
ATOM   1467  CA  LEU   184     -59.288  76.539  44.386  1.00 18.50           C  
ATOM   1468  C   LEU   184     -59.767  77.977  44.544  1.00 18.76           C  
ATOM   1469  O   LEU   184     -59.871  78.716  43.565  1.00 18.18           O  
ATOM   1470  CB  LEU   184     -60.423  75.675  43.837  1.00 18.89           C  
ATOM   1471  CG  LEU   184     -60.846  76.015  42.404  1.00 17.29           C  
ATOM   1472  CD1 LEU   184     -59.714  75.667  41.433  1.00 18.05           C  
ATOM   1473  CD2 LEU   184     -62.101  75.235  42.055  1.00 18.24           C  
ATOM   1474  N   CYS   185     -60.052  78.361  45.784  1.00 19.10           N  
ATOM   1475  CA  CYS   185     -60.483  79.719  46.100  1.00 19.71           C  
ATOM   1476  C   CYS   185     -59.365  80.736  45.819  1.00 19.68           C  
ATOM   1477  O   CYS   185     -59.591  81.944  45.876  1.00 20.43           O  
ATOM   1478  CB  CYS   185     -60.903  79.811  47.578  1.00 18.68           C  
ATOM   1479  SG  CYS   185     -59.631  79.310  48.794  1.00 22.42           S  
ATOM   1480  N   GLN   186     -58.166  80.249  45.506  1.00 19.05           N  
ATOM   1481  CA  GLN   186     -57.034  81.143  45.229  1.00 19.81           C  
ATOM   1482  C   GLN   186     -56.770  81.317  43.733  1.00 19.72           C  
ATOM   1483  O   GLN   186     -55.860  82.053  43.342  1.00 20.26           O  
ATOM   1484  CB  GLN   186     -55.751  80.606  45.882  1.00 19.43           C  
ATOM   1485  CG  GLN   186     -55.845  80.347  47.383  1.00 20.80           C  
ATOM   1486  CD  GLN   186     -56.214  81.586  48.174  1.00 23.84           C  
ATOM   1487  OE1 GLN   186     -55.560  82.627  48.067  1.00 25.99           O  
ATOM   1488  NE2 GLN   186     -57.262  81.480  48.980  1.00 22.53           N  
ATOM   1489  N   LYS   187     -57.561  80.652  42.896  1.00 19.16           N  
ATOM   1490  CA  LYS   187     -57.328  80.705  41.457  1.00 20.23           C  
ATOM   1491  C   LYS   187     -57.254  82.106  40.866  1.00 20.82           C  
ATOM   1492  O   LYS   187     -56.534  82.325  39.899  1.00 22.29           O  
ATOM   1493  CB  LYS   187     -58.374  79.881  40.699  1.00 20.30           C  
ATOM   1494  CG  LYS   187     -58.177  79.933  39.189  1.00 20.07           C  
ATOM   1495  CD  LYS   187     -59.134  79.025  38.455  1.00 21.45           C  
ATOM   1496  CE  LYS   187     -58.899  79.096  36.955  1.00 22.68           C  
ATOM   1497  NZ  LYS   187     -59.815  78.171  36.241  1.00 24.78           N  
ATOM   1498  N   PHE   188     -57.993  83.051  41.438  1.00 20.69           N  
ATOM   1499  CA  PHE   188     -57.981  84.423  40.943  1.00 20.86           C  
ATOM   1500  C   PHE   188     -57.431  85.399  41.983  1.00 20.75           C  
ATOM   1501  O   PHE   188     -57.790  86.579  41.997  1.00 20.48           O  
ATOM   1502  CB  PHE   188     -59.390  84.832  40.514  1.00 20.62           C  
ATOM   1503  CG  PHE   188     -59.970  83.945  39.455  1.00 21.60           C  
ATOM   1504  CD1 PHE   188     -59.338  83.807  38.216  1.00 22.38           C  
ATOM   1505  CD2 PHE   188     -61.127  83.210  39.707  1.00 21.94           C  
ATOM   1506  CE1 PHE   188     -59.849  82.943  37.241  1.00 22.97           C  
ATOM   1507  CE2 PHE   188     -61.650  82.344  38.744  1.00 19.81           C  
ATOM   1508  CZ  PHE   188     -61.010  82.209  37.507  1.00 20.16           C  
ATOM   1509  N   GLN   189     -56.553  84.885  42.840  1.00 21.08           N  
ATOM   1510  CA  GLN   189     -55.894  85.637  43.909  1.00 22.72           C  
ATOM   1511  C   GLN   189     -55.538  87.087  43.614  1.00 22.93           C  
ATOM   1512  O   GLN   189     -56.008  88.011  44.268  1.00 23.54           O  
ATOM   1513  CB  GLN   189     -54.572  84.965  44.279  1.00 22.39           C  
ATOM   1514  CG  GLN   189     -54.665  83.748  45.117  1.00 27.19           C  
ATOM   1515  CD  GLN   189     -53.300  83.291  45.553  1.00 21.36           C  
ATOM   1516  OE1 GLN   189     -52.360  83.225  44.748  1.00 27.55           O  
ATOM   1517  NE2 GLN   189     -53.171  82.984  46.827  1.00 28.48           N  
ATOM   1518  N   GLN   190     -54.618  87.241  42.669  1.00 24.26           N  
ATOM   1519  CA  GLN   190     -54.065  88.533  42.299  1.00 25.47           C  
ATOM   1520  C   GLN   190     -55.079  89.549  41.794  1.00 25.27           C  
ATOM   1521  O   GLN   190     -54.824  90.748  41.841  1.00 26.84           O  
ATOM   1522  CB  GLN   190     -52.943  88.332  41.269  1.00 25.43           C  
ATOM   1523  CG  GLN   190     -51.976  87.186  41.602  1.00 28.24           C  
ATOM   1524  CD  GLN   190     -51.143  87.423  42.864  1.00 34.11           C  
ATOM   1525  OE1 GLN   190     -51.251  88.463  43.518  1.00 34.26           O  
ATOM   1526  NE2 GLN   190     -50.303  86.450  43.204  1.00 32.51           N  
ATOM   1527  N   PHE   191     -56.227  89.085  41.311  1.00 25.07           N  
ATOM   1528  CA  PHE   191     -57.261  90.002  40.835  1.00 25.08           C  
ATOM   1529  C   PHE   191     -57.856  90.733  42.030  1.00 24.50           C  
ATOM   1530  O   PHE   191     -58.406  91.825  41.896  1.00 23.83           O  
ATOM   1531  CB  PHE   191     -58.362  89.246  40.087  1.00 25.26           C  
ATOM   1532  CG  PHE   191     -59.482  90.128  39.588  1.00 26.59           C  
ATOM   1533  CD1 PHE   191     -60.634  90.315  40.350  1.00 27.92           C  
ATOM   1534  CD2 PHE   191     -59.393  90.754  38.348  1.00 29.80           C  
ATOM   1535  CE1 PHE   191     -61.683  91.112  39.883  1.00 28.51           C  
ATOM   1536  CE2 PHE   191     -60.437  91.555  37.871  1.00 29.56           C  
ATOM   1537  CZ  PHE   191     -61.583  91.732  38.640  1.00 29.43           C  
ATOM   1538  N   PHE   192     -57.706  90.130  43.204  1.00 23.21           N  
ATOM   1539  CA  PHE   192     -58.216  90.713  44.431  1.00 23.54           C  
ATOM   1540  C   PHE   192     -57.082  91.263  45.288  1.00 24.04           C  
ATOM   1541  O   PHE   192     -57.297  91.664  46.430  1.00 24.06           O  
ATOM   1542  CB  PHE   192     -58.993  89.654  45.208  1.00 22.63           C  
ATOM   1543  CG  PHE   192     -60.186  89.135  44.470  1.00 21.28           C  
ATOM   1544  CD1 PHE   192     -61.390  89.831  44.502  1.00 19.49           C  
ATOM   1545  CD2 PHE   192     -60.092  87.985  43.688  1.00 19.66           C  
ATOM   1546  CE1 PHE   192     -62.485  89.398  43.768  1.00 18.49           C  
ATOM   1547  CE2 PHE   192     -61.183  87.541  42.947  1.00 19.26           C  
ATOM   1548  CZ  PHE   192     -62.384  88.253  42.988  1.00 20.11           C  
ATOM   1549  N   GLY   193     -55.874  91.284  44.728  1.00 24.59           N  
ATOM   1550  CA  GLY   193     -54.721  91.777  45.466  1.00 24.95           C  
ATOM   1551  C   GLY   193     -54.394  90.857  46.627  1.00 25.53           C  
ATOM   1552  O   GLY   193     -53.921  91.294  47.679  1.00 26.00           O  
ATOM   1553  N   GLU   194     -54.651  89.571  46.423  1.00 25.41           N  
ATOM   1554  CA  GLU   194     -54.406  88.555  47.438  1.00 25.11           C  
ATOM   1555  C   GLU   194     -53.384  87.536  46.955  1.00 24.97           C  
ATOM   1556  O   GLU   194     -53.160  87.389  45.754  1.00 25.19           O  
ATOM   1557  CB  GLU   194     -55.709  87.813  47.761  1.00 25.06           C  
ATOM   1558  CG  GLU   194     -56.783  88.656  48.411  1.00 26.33           C  
ATOM   1559  CD  GLU   194     -56.487  88.935  49.862  1.00 30.27           C  
ATOM   1560  OE1 GLU   194     -55.560  88.297  50.406  1.00 32.44           O  
ATOM   1561  OE2 GLU   194     -57.185  89.782  50.465  1.00 32.13           O  
ATOM   1562  N   ASP   195     -52.771  86.842  47.909  1.00 25.01           N  
ATOM   1563  CA  ASP   195     -51.814  85.777  47.637  1.00 24.96           C  
ATOM   1564  C   ASP   195     -51.793  84.850  48.856  1.00 25.02           C  
ATOM   1565  O   ASP   195     -52.448  85.126  49.857  1.00 25.06           O  
ATOM   1566  CB  ASP   195     -50.414  86.331  47.313  1.00 24.26           C  
ATOM   1567  CG  ASP   195     -49.850  87.220  48.404  1.00 25.57           C  
ATOM   1568  OD1 ASP   195     -49.888  86.819  49.586  1.00 23.91           O  
ATOM   1569  OD2 ASP   195     -49.336  88.311  48.066  1.00 21.69           O  
ATOM   1570  N   THR   196     -51.060  83.748  48.774  1.00 26.11           N  
ATOM   1571  CA  THR   196     -51.037  82.800  49.882  1.00 26.84           C  
ATOM   1572  C   THR   196     -50.089  83.155  51.023  1.00 27.33           C  
ATOM   1573  O   THR   196     -49.923  82.376  51.964  1.00 27.48           O  
ATOM   1574  CB  THR   196     -50.706  81.377  49.388  1.00 27.38           C  
ATOM   1575  OG1 THR   196     -49.396  81.357  48.803  1.00 28.27           O  
ATOM   1576  CG2 THR   196     -51.732  80.926  48.354  1.00 28.05           C  
ATOM   1577  N   SER   197     -49.479  84.333  50.964  1.00 26.37           N  
ATOM   1578  CA  SER   197     -48.552  84.723  52.016  1.00 26.63           C  
ATOM   1579  C   SER   197     -49.248  85.196  53.289  1.00 27.08           C  
ATOM   1580  O   SER   197     -48.611  85.331  54.331  1.00 27.09           O  
ATOM   1581  CB  SER   197     -47.631  85.839  51.530  1.00 26.13           C  
ATOM   1582  OG  SER   197     -48.305  87.084  51.550  1.00 22.74           O  
ATOM   1583  N   ASP   198     -50.549  85.456  53.227  1.00 28.08           N  
ATOM   1584  CA  ASP   198     -51.222  85.961  54.418  1.00 29.15           C  
ATOM   1585  C   ASP   198     -52.573  85.339  54.771  1.00 28.37           C  
ATOM   1586  O   ASP   198     -53.530  86.052  55.082  1.00 28.41           O  
ATOM   1587  CB  ASP   198     -51.374  87.485  54.321  1.00 30.12           C  
ATOM   1588  CG  ASP   198     -52.460  87.892  53.353  1.00 32.03           C  
ATOM   1589  OD1 ASP   198     -52.635  87.178  52.340  1.00 34.63           O  
ATOM   1590  OD2 ASP   198     -53.145  88.916  53.602  1.00 34.28           O  
ATOM   1591  N   PHE   199     -52.654  84.014  54.761  1.00 27.28           N  
ATOM   1592  CA  PHE   199     -53.901  83.373  55.159  1.00 27.07           C  
ATOM   1593  C   PHE   199     -54.188  83.788  56.599  1.00 25.85           C  
ATOM   1594  O   PHE   199     -53.313  83.698  57.455  1.00 26.34           O  
ATOM   1595  CB  PHE   199     -53.791  81.845  55.085  1.00 27.44           C  
ATOM   1596  CG  PHE   199     -53.843  81.289  53.680  1.00 29.45           C  
ATOM   1597  CD1 PHE   199     -54.282  82.071  52.611  1.00 31.29           C  
ATOM   1598  CD2 PHE   199     -53.481  79.967  53.432  1.00 32.61           C  
ATOM   1599  CE1 PHE   199     -54.360  81.546  51.322  1.00 31.73           C  
ATOM   1600  CE2 PHE   199     -53.556  79.433  52.144  1.00 31.77           C  
ATOM   1601  CZ  PHE   199     -53.996  80.224  51.090  1.00 30.09           C  
ATOM   1602  N   SER   200     -55.403  84.260  56.858  1.00 24.88           N  
ATOM   1603  CA  SER   200     -55.771  84.676  58.203  1.00 24.87           C  
ATOM   1604  C   SER   200     -55.787  83.474  59.144  1.00 25.00           C  
ATOM   1605  O   SER   200     -55.800  82.317  58.703  1.00 22.67           O  
ATOM   1606  CB  SER   200     -57.152  85.324  58.197  1.00 25.38           C  
ATOM   1607  OG  SER   200     -58.140  84.349  57.929  1.00 27.25           O  
ATOM   1608  N   GLU   201     -55.789  83.761  60.443  1.00 24.64           N  
ATOM   1609  CA  GLU   201     -55.803  82.726  61.467  1.00 25.20           C  
ATOM   1610  C   GLU   201     -57.045  81.844  61.385  1.00 24.96           C  
ATOM   1611  O   GLU   201     -56.976  80.647  61.659  1.00 24.63           O  
ATOM   1612  CB  GLU   201     -55.706  83.354  62.857  1.00 26.41           C  
ATOM   1613  CG  GLU   201     -55.891  82.371  64.002  1.00 30.28           C  
ATOM   1614  CD  GLU   201     -54.908  81.211  63.955  1.00 34.89           C  
ATOM   1615  OE1 GLU   201     -53.839  81.352  63.312  1.00 36.08           O  
ATOM   1616  OE2 GLU   201     -55.201  80.162  64.576  1.00 37.09           O  
ATOM   1617  N   GLU   202     -58.179  82.424  61.014  1.00 25.02           N  
ATOM   1618  CA  GLU   202     -59.399  81.638  60.882  1.00 26.00           C  
ATOM   1619  C   GLU   202     -59.262  80.679  59.702  1.00 25.23           C  
ATOM   1620  O   GLU   202     -59.575  79.490  59.812  1.00 24.58           O  
ATOM   1621  CB  GLU   202     -60.616  82.540  60.670  1.00 26.76           C  
ATOM   1622  CG  GLU   202     -61.947  81.802  60.845  1.00 31.62           C  
ATOM   1623  CD  GLU   202     -63.147  82.733  60.858  1.00 36.65           C  
ATOM   1624  OE1 GLU   202     -62.959  83.941  61.118  1.00 39.84           O  
ATOM   1625  OE2 GLU   202     -64.281  82.254  60.626  1.00 38.66           O  
ATOM   1626  N   VAL   203     -58.782  81.193  58.574  1.00 24.54           N  
ATOM   1627  CA  VAL   203     -58.607  80.352  57.398  1.00 23.71           C  
ATOM   1628  C   VAL   203     -57.673  79.191  57.733  1.00 24.39           C  
ATOM   1629  O   VAL   203     -57.952  78.035  57.388  1.00 24.34           O  
ATOM   1630  CB  VAL   203     -58.042  81.164  56.205  1.00 23.57           C  
ATOM   1631  CG1 VAL   203     -57.487  80.228  55.142  1.00 20.74           C  
ATOM   1632  CG2 VAL   203     -59.144  82.031  55.609  1.00 21.42           C  
ATOM   1633  N   MET   204     -56.578  79.493  58.426  1.00 24.59           N  
ATOM   1634  CA  MET   204     -55.618  78.461  58.801  1.00 25.56           C  
ATOM   1635  C   MET   204     -56.222  77.397  59.712  1.00 25.50           C  
ATOM   1636  O   MET   204     -55.895  76.215  59.584  1.00 24.69           O  
ATOM   1637  CB  MET   204     -54.389  79.071  59.481  1.00 26.14           C  
ATOM   1638  CG  MET   204     -53.432  79.765  58.520  1.00 31.03           C  
ATOM   1639  SD  MET   204     -52.892  78.626  57.030  1.00 46.56          SE  
ATOM   1640  CE  MET   204     -52.341  77.066  58.046  1.00 38.18           C  
ATOM   1641  N   GLU   205     -57.085  77.808  60.637  1.00 25.27           N  
ATOM   1642  CA  GLU   205     -57.720  76.849  61.537  1.00 26.30           C  
ATOM   1643  C   GLU   205     -58.642  75.926  60.740  1.00 25.70           C  
ATOM   1644  O   GLU   205     -58.709  74.725  61.010  1.00 26.31           O  
ATOM   1645  CB  GLU   205     -58.505  77.570  62.636  1.00 26.47           C  
ATOM   1646  CG  GLU   205     -59.182  76.647  63.657  1.00 31.65           C  
ATOM   1647  CD  GLU   205     -58.244  75.588  64.249  1.00 34.99           C  
ATOM   1648  OE1 GLU   205     -57.066  75.900  64.546  1.00 37.55           O  
ATOM   1649  OE2 GLU   205     -58.694  74.435  64.435  1.00 38.25           O  
ATOM   1650  N   LYS   206     -59.344  76.477  59.749  1.00 25.61           N  
ATOM   1651  CA  LYS   206     -60.217  75.650  58.922  1.00 24.54           C  
ATOM   1652  C   LYS   206     -59.410  74.626  58.142  1.00 23.59           C  
ATOM   1653  O   LYS   206     -59.844  73.482  57.969  1.00 23.04           O  
ATOM   1654  CB  LYS   206     -61.039  76.492  57.955  1.00 25.22           C  
ATOM   1655  CG  LYS   206     -62.285  77.073  58.587  1.00 30.34           C  
ATOM   1656  CD  LYS   206     -63.413  77.131  57.570  1.00 35.46           C  
ATOM   1657  CE  LYS   206     -64.660  77.757  58.177  1.00 38.00           C  
ATOM   1658  NZ  LYS   206     -65.638  78.179  57.127  1.00 34.21           N  
ATOM   1659  N   PHE   207     -58.230  75.030  57.681  1.00 22.94           N  
ATOM   1660  CA  PHE   207     -57.375  74.106  56.958  1.00 22.03           C  
ATOM   1661  C   PHE   207     -56.934  72.977  57.894  1.00 21.97           C  
ATOM   1662  O   PHE   207     -56.915  71.811  57.497  1.00 20.82           O  
ATOM   1663  CB  PHE   207     -56.152  74.831  56.384  1.00 21.63           C  
ATOM   1664  CG  PHE   207     -56.340  75.320  54.966  1.00 20.13           C  
ATOM   1665  CD1 PHE   207     -56.613  74.420  53.937  1.00 20.43           C  
ATOM   1666  CD2 PHE   207     -56.232  76.676  54.658  1.00 19.45           C  
ATOM   1667  CE1 PHE   207     -56.776  74.855  52.620  1.00 19.46           C  
ATOM   1668  CE2 PHE   207     -56.392  77.122  53.352  1.00 16.49           C  
ATOM   1669  CZ  PHE   207     -56.665  76.208  52.328  1.00 17.44           C  
ATOM   1670  N   ARG   208     -56.587  73.321  59.134  1.00 22.11           N  
ATOM   1671  CA  ARG   208     -56.159  72.311  60.103  1.00 22.54           C  
ATOM   1672  C   ARG   208     -57.316  71.345  60.383  1.00 22.47           C  
ATOM   1673  O   ARG   208     -57.131  70.131  60.401  1.00 22.71           O  
ATOM   1674  CB  ARG   208     -55.674  72.968  61.409  1.00 23.04           C  
ATOM   1675  CG  ARG   208     -54.310  73.659  61.297  1.00 24.18           C  
ATOM   1676  CD  ARG   208     -53.725  74.029  62.666  1.00 28.61           C  
ATOM   1677  NE  ARG   208     -54.493  75.077  63.332  1.00 31.20           N  
ATOM   1678  CZ  ARG   208     -54.291  76.383  63.166  1.00 30.93           C  
ATOM   1679  NH1 ARG   208     -53.333  76.813  62.356  1.00 30.08           N  
ATOM   1680  NH2 ARG   208     -55.055  77.260  63.803  1.00 28.32           N  
ATOM   1681  N   VAL   209     -58.514  71.883  60.580  1.00 22.19           N  
ATOM   1682  CA  VAL   209     -59.670  71.027  60.816  1.00 22.59           C  
ATOM   1683  C   VAL   209     -59.876  70.101  59.617  1.00 22.02           C  
ATOM   1684  O   VAL   209     -60.098  68.898  59.785  1.00 21.17           O  
ATOM   1685  CB  VAL   209     -60.953  71.861  61.049  1.00 22.76           C  
ATOM   1686  CG1 VAL   209     -62.184  70.961  61.022  1.00 24.17           C  
ATOM   1687  CG2 VAL   209     -60.863  72.571  62.394  1.00 25.28           C  
ATOM   1688  N   ILE   210     -59.786  70.665  58.412  1.00 21.54           N  
ATOM   1689  CA  ILE   210     -59.962  69.902  57.178  1.00 21.59           C  
ATOM   1690  C   ILE   210     -58.930  68.784  57.042  1.00 22.30           C  
ATOM   1691  O   ILE   210     -59.279  67.643  56.730  1.00 23.40           O  
ATOM   1692  CB  ILE   210     -59.882  70.830  55.925  1.00 21.91           C  
ATOM   1693  CG1 ILE   210     -61.206  71.583  55.746  1.00 21.14           C  
ATOM   1694  CG2 ILE   210     -59.546  70.019  54.677  1.00 20.66           C  
ATOM   1695  CD1 ILE   210     -61.217  72.553  54.579  1.00 20.72           C  
ATOM   1696  N   LEU   211     -57.662  69.103  57.289  1.00 22.07           N  
ATOM   1697  CA  LEU   211     -56.598  68.111  57.170  1.00 22.12           C  
ATOM   1698  C   LEU   211     -56.729  66.970  58.182  1.00 22.65           C  
ATOM   1699  O   LEU   211     -56.560  65.798  57.830  1.00 21.72           O  
ATOM   1700  CB  LEU   211     -55.226  68.775  57.323  1.00 21.80           C  
ATOM   1701  CG  LEU   211     -54.850  69.749  56.202  1.00 22.41           C  
ATOM   1702  CD1 LEU   211     -53.482  70.357  56.476  1.00 22.27           C  
ATOM   1703  CD2 LEU   211     -54.855  69.008  54.862  1.00 22.27           C  
ATOM   1704  N   ALA   212     -57.022  67.311  59.434  1.00 22.42           N  
ATOM   1705  CA  ALA   212     -57.164  66.303  60.484  1.00 23.15           C  
ATOM   1706  C   ALA   212     -58.235  65.314  60.049  1.00 23.63           C  
ATOM   1707  O   ALA   212     -58.110  64.102  60.230  1.00 23.26           O  
ATOM   1708  CB  ALA   212     -57.562  66.965  61.805  1.00 24.04           C  
ATOM   1709  N   LEU   213     -59.280  65.852  59.441  1.00 23.54           N  
ATOM   1710  CA  LEU   213     -60.398  65.052  58.981  1.00 24.72           C  
ATOM   1711  C   LEU   213     -60.005  64.155  57.801  1.00 24.04           C  
ATOM   1712  O   LEU   213     -60.413  62.995  57.725  1.00 23.91           O  
ATOM   1713  CB  LEU   213     -61.540  65.981  58.595  1.00 25.51           C  
ATOM   1714  CG  LEU   213     -62.887  65.307  58.407  1.00 29.51           C  
ATOM   1715  CD1 LEU   213     -63.248  64.490  59.652  1.00 30.61           C  
ATOM   1716  CD2 LEU   213     -63.921  66.384  58.149  1.00 31.56           C  
ATOM   1717  N   VAL   214     -59.211  64.692  56.882  1.00 23.07           N  
ATOM   1718  CA  VAL   214     -58.750  63.909  55.742  1.00 22.18           C  
ATOM   1719  C   VAL   214     -57.977  62.700  56.262  1.00 22.72           C  
ATOM   1720  O   VAL   214     -58.147  61.587  55.768  1.00 22.24           O  
ATOM   1721  CB  VAL   214     -57.816  64.732  54.815  1.00 21.89           C  
ATOM   1722  CG1 VAL   214     -57.112  63.816  53.823  1.00 20.52           C  
ATOM   1723  CG2 VAL   214     -58.624  65.782  54.073  1.00 20.66           C  
ATOM   1724  N   LYS   215     -57.130  62.923  57.262  1.00 22.65           N  
ATOM   1725  CA  LYS   215     -56.347  61.838  57.844  1.00 24.25           C  
ATOM   1726  C   LYS   215     -57.269  60.794  58.476  1.00 24.02           C  
ATOM   1727  O   LYS   215     -57.173  59.603  58.182  1.00 24.20           O  
ATOM   1728  CB  LYS   215     -55.381  62.389  58.901  1.00 24.40           C  
ATOM   1729  CG  LYS   215     -54.498  61.330  59.546  1.00 28.12           C  
ATOM   1730  CD  LYS   215     -53.697  60.565  58.503  1.00 32.25           C  
ATOM   1731  CE  LYS   215     -52.795  59.528  59.158  1.00 35.80           C  
ATOM   1732  NZ  LYS   215     -52.008  58.753  58.157  1.00 39.25           N  
ATOM   1733  N   LYS   216     -58.165  61.249  59.340  1.00 23.72           N  
ATOM   1734  CA  LYS   216     -59.104  60.352  60.003  1.00 24.77           C  
ATOM   1735  C   LYS   216     -59.871  59.489  58.997  1.00 24.01           C  
ATOM   1736  O   LYS   216     -60.115  58.303  59.237  1.00 24.05           O  
ATOM   1737  CB  LYS   216     -60.093  61.157  60.841  1.00 24.80           C  
ATOM   1738  CG  LYS   216     -60.989  60.294  61.707  1.00 29.99           C  
ATOM   1739  CD  LYS   216     -62.012  61.134  62.444  1.00 34.90           C  
ATOM   1740  CE  LYS   216     -62.511  60.413  63.684  1.00 39.09           C  
ATOM   1741  NZ  LYS   216     -62.910  59.007  63.380  1.00 41.91           N  
ATOM   1742  N   ARG   217     -60.239  60.097  57.873  1.00 24.19           N  
ATOM   1743  CA  ARG   217     -60.979  59.415  56.808  1.00 24.05           C  
ATOM   1744  C   ARG   217     -60.057  58.544  55.958  1.00 23.85           C  
ATOM   1745  O   ARG   217     -60.520  57.754  55.134  1.00 23.49           O  
ATOM   1746  CB  ARG   217     -61.646  60.450  55.897  1.00 24.91           C  
ATOM   1747  CG  ARG   217     -62.977  60.982  56.385  1.00 26.40           C  
ATOM   1748  CD  ARG   217     -64.061  59.969  56.112  1.00 30.25           C  
ATOM   1749  NE  ARG   217     -65.284  60.623  55.686  1.00 34.04           N  
ATOM   1750  CZ  ARG   217     -66.351  59.987  55.220  1.00 33.25           C  
ATOM   1751  NH1 ARG   217     -66.351  58.660  55.125  1.00 32.68           N  
ATOM   1752  NH2 ARG   217     -67.407  60.684  54.826  1.00 32.08           N  
ATOM   1753  N   ASP   218     -58.754  58.719  56.144  1.00 23.80           N  
ATOM   1754  CA  ASP   218     -57.749  57.985  55.393  1.00 24.33           C  
ATOM   1755  C   ASP   218     -57.829  58.334  53.910  1.00 24.08           C  
ATOM   1756  O   ASP   218     -57.623  57.480  53.043  1.00 24.54           O  
ATOM   1757  CB  ASP   218     -57.920  56.476  55.596  1.00 25.74           C  
ATOM   1758  CG  ASP   218     -56.690  55.692  55.183  1.00 29.11           C  
ATOM   1759  OD1 ASP   218     -55.566  56.129  55.519  1.00 31.99           O  
ATOM   1760  OD2 ASP   218     -56.843  54.637  54.532  1.00 31.70           O  
ATOM   1761  N   TYR   219     -58.144  59.596  53.631  1.00 22.44           N  
ATOM   1762  CA  TYR   219     -58.227  60.082  52.258  1.00 21.69           C  
ATOM   1763  C   TYR   219     -56.849  60.592  51.833  1.00 22.19           C  
ATOM   1764  O   TYR   219     -55.892  60.536  52.604  1.00 21.77           O  
ATOM   1765  CB  TYR   219     -59.240  61.228  52.148  1.00 21.00           C  
ATOM   1766  CG  TYR   219     -60.712  60.845  52.247  1.00 21.11           C  
ATOM   1767  CD1 TYR   219     -61.130  59.512  52.168  1.00 22.20           C  
ATOM   1768  CD2 TYR   219     -61.694  61.835  52.355  1.00 19.86           C  
ATOM   1769  CE1 TYR   219     -62.497  59.180  52.188  1.00 21.59           C  
ATOM   1770  CE2 TYR   219     -63.053  61.517  52.373  1.00 21.74           C  
ATOM   1771  CZ  TYR   219     -63.450  60.190  52.289  1.00 22.59           C  
ATOM   1772  OH  TYR   219     -64.795  59.881  52.301  1.00 18.59           O  
ATOM   1773  N   GLU   220     -56.752  61.087  50.605  1.00 21.76           N  
ATOM   1774  CA  GLU   220     -55.498  61.642  50.107  1.00 21.61           C  
ATOM   1775  C   GLU   220     -55.814  62.941  49.376  1.00 21.14           C  
ATOM   1776  O   GLU   220     -56.982  63.256  49.139  1.00 20.78           O  
ATOM   1777  CB  GLU   220     -54.787  60.645  49.180  1.00 21.38           C  
ATOM   1778  CG  GLU   220     -55.634  60.124  48.033  1.00 23.49           C  
ATOM   1779  CD  GLU   220     -54.891  59.131  47.145  1.00 27.62           C  
ATOM   1780  OE1 GLU   220     -53.851  58.590  47.585  1.00 27.40           O  
ATOM   1781  OE2 GLU   220     -55.361  58.882  46.011  1.00 27.48           O  
ATOM   1782  N   LEU   221     -54.783  63.693  49.020  1.00 20.38           N  
ATOM   1783  CA  LEU   221     -55.006  64.959  48.351  1.00 21.10           C  
ATOM   1784  C   LEU   221     -54.409  65.068  46.964  1.00 20.43           C  
ATOM   1785  O   LEU   221     -53.356  64.506  46.659  1.00 20.14           O  
ATOM   1786  CB  LEU   221     -54.490  66.109  49.219  1.00 21.13           C  
ATOM   1787  CG  LEU   221     -55.172  66.222  50.578  1.00 22.29           C  
ATOM   1788  CD1 LEU   221     -54.452  67.248  51.426  1.00 23.28           C  
ATOM   1789  CD2 LEU   221     -56.639  66.596  50.389  1.00 20.96           C  
ATOM   1790  N   ASP   222     -55.126  65.806  46.128  1.00 20.24           N  
ATOM   1791  CA  ASP   222     -54.733  66.099  44.752  1.00 20.81           C  
ATOM   1792  C   ASP   222     -53.737  67.269  44.808  1.00 21.62           C  
ATOM   1793  O   ASP   222     -54.117  68.371  45.195  1.00 22.22           O  
ATOM   1794  CB  ASP   222     -56.013  66.468  43.980  1.00 21.19           C  
ATOM   1795  CG  ASP   222     -55.763  67.061  42.597  1.00 21.64           C  
ATOM   1796  OD1 ASP   222     -54.950  66.512  41.826  1.00 21.76           O  
ATOM   1797  OD2 ASP   222     -56.445  68.062  42.260  1.00 22.49           O  
ATOM   1798  N   PHE   223     -52.459  67.003  44.527  1.00 21.45           N  
ATOM   1799  CA  PHE   223     -51.443  68.065  44.505  1.00 21.27           C  
ATOM   1800  C   PHE   223     -51.492  68.591  43.084  1.00 21.24           C  
ATOM   1801  O   PHE   223     -50.809  68.096  42.183  1.00 20.61           O  
ATOM   1802  CB  PHE   223     -50.047  67.521  44.828  1.00 22.39           C  
ATOM   1803  CG  PHE   223     -48.992  68.592  44.954  1.00 23.87           C  
ATOM   1804  CD1 PHE   223     -48.524  69.265  43.826  1.00 26.70           C  
ATOM   1805  CD2 PHE   223     -48.478  68.938  46.203  1.00 26.98           C  
ATOM   1806  CE1 PHE   223     -47.557  70.271  43.938  1.00 29.01           C  
ATOM   1807  CE2 PHE   223     -47.514  69.940  46.330  1.00 27.73           C  
ATOM   1808  CZ  PHE   223     -47.051  70.610  45.198  1.00 28.14           C  
ATOM   1809  N   ASN   224     -52.345  69.591  42.903  1.00 20.33           N  
ATOM   1810  CA  ASN   224     -52.643  70.164  41.600  1.00 19.73           C  
ATOM   1811  C   ASN   224     -51.756  71.349  41.201  1.00 19.92           C  
ATOM   1812  O   ASN   224     -51.751  72.387  41.862  1.00 18.07           O  
ATOM   1813  CB  ASN   224     -54.122  70.558  41.615  1.00 19.45           C  
ATOM   1814  CG  ASN   224     -54.700  70.741  40.236  1.00 20.81           C  
ATOM   1815  OD1 ASN   224     -54.194  71.533  39.437  1.00 19.97           O  
ATOM   1816  ND2 ASN   224     -55.789  70.026  39.955  1.00 19.33           N  
ATOM   1817  N   THR   225     -51.036  71.194  40.091  1.00 20.34           N  
ATOM   1818  CA  THR   225     -50.114  72.224  39.614  1.00 21.62           C  
ATOM   1819  C   THR   225     -50.727  73.183  38.603  1.00 22.74           C  
ATOM   1820  O   THR   225     -50.055  74.095  38.126  1.00 23.86           O  
ATOM   1821  CB  THR   225     -48.868  71.602  38.958  1.00 21.51           C  
ATOM   1822  OG1 THR   225     -49.272  70.792  37.845  1.00 22.41           O  
ATOM   1823  CG2 THR   225     -48.093  70.747  39.967  1.00 19.13           C  
ATOM   1824  N   ALA   226     -51.997  72.973  38.270  1.00 23.30           N  
ATOM   1825  CA  ALA   226     -52.680  73.824  37.304  1.00 24.84           C  
ATOM   1826  C   ALA   226     -52.547  75.299  37.681  1.00 25.93           C  
ATOM   1827  O   ALA   226     -52.394  76.153  36.814  1.00 26.60           O  
ATOM   1828  CB  ALA   226     -54.158  73.438  37.210  1.00 24.21           C  
ATOM   1829  N   GLY   227     -52.593  75.579  38.979  1.00 27.07           N  
ATOM   1830  CA  GLY   227     -52.508  76.949  39.456  1.00 29.50           C  
ATOM   1831  C   GLY   227     -51.253  77.704  39.057  1.00 31.07           C  
ATOM   1832  O   GLY   227     -51.273  78.931  38.939  1.00 30.97           O  
ATOM   1833  N   LEU   228     -50.159  76.973  38.857  1.00 32.38           N  
ATOM   1834  CA  LEU   228     -48.888  77.576  38.472  1.00 33.13           C  
ATOM   1835  C   LEU   228     -48.959  78.155  37.069  1.00 34.89           C  
ATOM   1836  O   LEU   228     -48.125  78.980  36.683  1.00 34.29           O  
ATOM   1837  CB  LEU   228     -47.765  76.533  38.525  1.00 33.24           C  
ATOM   1838  CG  LEU   228     -47.462  75.877  39.874  1.00 31.46           C  
ATOM   1839  CD1 LEU   228     -46.370  74.819  39.716  1.00 31.49           C  
ATOM   1840  CD2 LEU   228     -47.039  76.945  40.868  1.00 29.58           C  
ATOM   1841  N   PHE   229     -49.961  77.722  36.310  1.00 35.05           N  
ATOM   1842  CA  PHE   229     -50.108  78.177  34.938  1.00 35.75           C  
ATOM   1843  C   PHE   229     -51.379  78.974  34.643  1.00 36.57           C  
ATOM   1844  O   PHE   229     -51.739  79.168  33.477  1.00 36.56           O  
ATOM   1845  CB  PHE   229     -49.978  76.976  33.995  1.00 36.05           C  
ATOM   1846  CG  PHE   229     -48.693  76.218  34.177  1.00 34.58           C  
ATOM   1847  CD1 PHE   229     -48.548  75.311  35.220  1.00 33.70           C  
ATOM   1848  CD2 PHE   229     -47.601  76.461  33.348  1.00 35.69           C  
ATOM   1849  CE1 PHE   229     -47.335  74.657  35.437  1.00 31.17           C  
ATOM   1850  CE2 PHE   229     -46.383  75.812  33.557  1.00 34.46           C  
ATOM   1851  CZ  PHE   229     -46.251  74.911  34.604  1.00 33.45           C  
ATOM   1852  N   LYS   230     -52.062  79.426  35.697  1.00 36.86           N  
ATOM   1853  CA  LYS   230     -53.251  80.262  35.519  1.00 38.00           C  
ATOM   1854  C   LYS   230     -52.792  81.711  35.718  1.00 38.25           C  
ATOM   1855  O   LYS   230     -52.086  82.019  36.678  1.00 38.66           O  
ATOM   1856  CB  LYS   230     -54.351  79.944  36.541  1.00 37.58           C  
ATOM   1857  CG  LYS   230     -54.292  78.573  37.206  1.00 39.96           C  
ATOM   1858  CD  LYS   230     -54.785  77.409  36.339  1.00 41.77           C  
ATOM   1859  CE  LYS   230     -55.577  77.814  35.100  1.00 43.38           C  
ATOM   1860  NZ  LYS   230     -56.162  76.592  34.451  1.00 44.09           N  
ATOM   1861  N   PRO   231     -53.193  82.618  34.814  1.00 38.70           N  
ATOM   1862  CA  PRO   231     -52.840  84.043  34.857  1.00 38.71           C  
ATOM   1863  C   PRO   231     -52.992  84.784  36.199  1.00 38.29           C  
ATOM   1864  O   PRO   231     -52.076  85.488  36.624  1.00 38.99           O  
ATOM   1865  CB  PRO   231     -53.721  84.651  33.756  1.00 38.52           C  
ATOM   1866  CG  PRO   231     -54.865  83.660  33.624  1.00 39.34           C  
ATOM   1867  CD  PRO   231     -54.134  82.354  33.713  1.00 38.90           C  
ATOM   1868  N   LEU   232     -54.132  84.633  36.868  1.00 36.93           N  
ATOM   1869  CA  LEU   232     -54.357  85.337  38.134  1.00 36.03           C  
ATOM   1870  C   LEU   232     -54.118  84.517  39.406  1.00 35.17           C  
ATOM   1871  O   LEU   232     -54.422  84.966  40.515  1.00 34.40           O  
ATOM   1872  CB  LEU   232     -55.767  85.941  38.144  1.00 36.11           C  
ATOM   1873  CG  LEU   232     -55.953  86.949  36.998  1.00 36.52           C  
ATOM   1874  CD1 LEU   232     -57.423  87.151  36.656  1.00 37.03           C  
ATOM   1875  CD2 LEU   232     -55.290  88.269  37.381  1.00 38.18           C  
ATOM   1876  N   CYS   233     -53.553  83.324  39.245  1.00 34.69           N  
ATOM   1877  CA  CYS   233     -53.263  82.463  40.388  1.00 33.90           C  
ATOM   1878  C   CYS   233     -51.761  82.486  40.686  1.00 33.78           C  
ATOM   1879  O   CYS   233     -51.279  83.351  41.420  1.00 33.56           O  
ATOM   1880  CB  CYS   233     -53.722  81.028  40.112  1.00 33.35           C  
ATOM   1881  SG  CYS   233     -53.537  79.908  41.523  1.00 33.12           S  
ATOM   1882  N   GLY   234     -51.025  81.537  40.111  1.00 33.14           N  
ATOM   1883  CA  GLY   234     -49.585  81.487  40.314  1.00 33.21           C  
ATOM   1884  C   GLY   234     -49.115  80.603  41.456  1.00 32.97           C  
ATOM   1885  O   GLY   234     -47.952  80.678  41.861  1.00 33.41           O  
ATOM   1886  N   GLU   235     -50.010  79.759  41.967  1.00 31.99           N  
ATOM   1887  CA  GLU   235     -49.691  78.862  43.074  1.00 30.38           C  
ATOM   1888  C   GLU   235     -50.223  77.439  42.855  1.00 28.02           C  
ATOM   1889  O   GLU   235     -51.163  77.225  42.088  1.00 27.61           O  
ATOM   1890  CB  GLU   235     -50.297  79.417  44.366  1.00 31.32           C  
ATOM   1891  CG  GLU   235     -49.298  80.005  45.331  1.00 36.82           C  
ATOM   1892  CD  GLU   235     -48.409  78.953  45.957  1.00 41.96           C  
ATOM   1893  OE1 GLU   235     -48.134  79.072  47.168  1.00 45.93           O  
ATOM   1894  OE2 GLU   235     -47.979  78.017  45.244  1.00 41.07           O  
ATOM   1895  N   THR   236     -49.623  76.468  43.537  1.00 24.90           N  
ATOM   1896  CA  THR   236     -50.097  75.087  43.450  1.00 23.28           C  
ATOM   1897  C   THR   236     -51.272  74.947  44.417  1.00 21.76           C  
ATOM   1898  O   THR   236     -51.372  75.705  45.380  1.00 20.06           O  
ATOM   1899  CB  THR   236     -49.024  74.075  43.889  1.00 22.14           C  
ATOM   1900  OG1 THR   236     -48.562  74.420  45.197  1.00 23.56           O  
ATOM   1901  CG2 THR   236     -47.851  74.064  42.926  1.00 23.26           C  
ATOM   1902  N   TYR   237     -52.158  73.988  44.159  1.00 20.89           N  
ATOM   1903  CA  TYR   237     -53.300  73.735  45.045  1.00 21.30           C  
ATOM   1904  C   TYR   237     -52.998  72.433  45.789  1.00 21.37           C  
ATOM   1905  O   TYR   237     -53.048  71.353  45.193  1.00 21.23           O  
ATOM   1906  CB  TYR   237     -54.598  73.554  44.250  1.00 20.79           C  
ATOM   1907  CG  TYR   237     -54.925  74.633  43.236  1.00 21.45           C  
ATOM   1908  CD1 TYR   237     -55.301  75.918  43.636  1.00 21.66           C  
ATOM   1909  CD2 TYR   237     -54.928  74.345  41.871  1.00 22.71           C  
ATOM   1910  CE1 TYR   237     -55.686  76.880  42.699  1.00 20.80           C  
ATOM   1911  CE2 TYR   237     -55.312  75.292  40.932  1.00 21.34           C  
ATOM   1912  CZ  TYR   237     -55.690  76.554  41.348  1.00 23.92           C  
ATOM   1913  OH  TYR   237     -56.114  77.473  40.411  1.00 27.19           O  
ATOM   1914  N   PRO   238     -52.711  72.511  47.097  1.00 21.21           N  
ATOM   1915  CA  PRO   238     -52.622  73.714  47.932  1.00 20.83           C  
ATOM   1916  C   PRO   238     -51.195  74.258  47.987  1.00 21.01           C  
ATOM   1917  O   PRO   238     -50.282  73.665  47.403  1.00 21.61           O  
ATOM   1918  CB  PRO   238     -53.065  73.198  49.286  1.00 21.21           C  
ATOM   1919  CG  PRO   238     -52.379  71.863  49.327  1.00 20.59           C  
ATOM   1920  CD  PRO   238     -52.624  71.296  47.934  1.00 20.68           C  
ATOM   1921  N   PRO   239     -50.982  75.390  48.686  1.00 21.19           N  
ATOM   1922  CA  PRO   239     -49.636  75.969  48.791  1.00 21.35           C  
ATOM   1923  C   PRO   239     -48.742  75.223  49.782  1.00 21.54           C  
ATOM   1924  O   PRO   239     -49.223  74.429  50.589  1.00 21.57           O  
ATOM   1925  CB  PRO   239     -49.903  77.402  49.235  1.00 21.14           C  
ATOM   1926  CG  PRO   239     -51.128  77.259  50.090  1.00 22.82           C  
ATOM   1927  CD  PRO   239     -51.987  76.291  49.288  1.00 21.16           C  
ATOM   1928  N   LYS   240     -47.445  75.502  49.723  1.00 21.81           N  
ATOM   1929  CA  LYS   240     -46.462  74.859  50.589  1.00 23.37           C  
ATOM   1930  C   LYS   240     -46.889  74.692  52.049  1.00 22.59           C  
ATOM   1931  O   LYS   240     -46.802  73.604  52.614  1.00 23.13           O  
ATOM   1932  CB  LYS   240     -45.149  75.641  50.538  1.00 23.21           C  
ATOM   1933  CG  LYS   240     -44.099  75.158  51.517  1.00 29.19           C  
ATOM   1934  CD  LYS   240     -43.098  74.220  50.872  1.00 32.75           C  
ATOM   1935  CE  LYS   240     -41.951  73.958  51.829  1.00 35.90           C  
ATOM   1936  NZ  LYS   240     -40.759  73.399  51.135  1.00 39.70           N  
ATOM   1937  N   LYS   241     -47.335  75.774  52.666  1.00 22.64           N  
ATOM   1938  CA  LYS   241     -47.718  75.713  54.070  1.00 23.09           C  
ATOM   1939  C   LYS   241     -48.713  74.588  54.360  1.00 22.57           C  
ATOM   1940  O   LYS   241     -48.602  73.898  55.377  1.00 21.90           O  
ATOM   1941  CB  LYS   241     -48.301  77.055  54.502  1.00 23.62           C  
ATOM   1942  CG  LYS   241     -48.459  77.198  55.994  1.00 26.80           C  
ATOM   1943  CD  LYS   241     -48.967  78.588  56.316  1.00 31.99           C  
ATOM   1944  CE  LYS   241     -49.041  78.821  57.812  1.00 34.70           C  
ATOM   1945  NZ  LYS   241     -49.444  80.225  58.114  1.00 36.82           N  
ATOM   1946  N   ILE   242     -49.682  74.398  53.470  1.00 21.37           N  
ATOM   1947  CA  ILE   242     -50.675  73.354  53.665  1.00 21.17           C  
ATOM   1948  C   ILE   242     -50.044  71.989  53.399  1.00 20.81           C  
ATOM   1949  O   ILE   242     -50.301  71.027  54.121  1.00 20.07           O  
ATOM   1950  CB  ILE   242     -51.892  73.557  52.736  1.00 21.38           C  
ATOM   1951  CG1 ILE   242     -52.490  74.959  52.950  1.00 22.86           C  
ATOM   1952  CG2 ILE   242     -52.929  72.462  52.980  1.00 19.60           C  
ATOM   1953  CD1 ILE   242     -53.006  75.233  54.357  1.00 25.44           C  
ATOM   1954  N   VAL   243     -49.209  71.914  52.363  1.00 20.91           N  
ATOM   1955  CA  VAL   243     -48.528  70.669  52.018  1.00 21.24           C  
ATOM   1956  C   VAL   243     -47.721  70.177  53.214  1.00 22.36           C  
ATOM   1957  O   VAL   243     -47.729  68.990  53.535  1.00 23.15           O  
ATOM   1958  CB  VAL   243     -47.566  70.854  50.817  1.00 20.93           C  
ATOM   1959  CG1 VAL   243     -46.732  69.591  50.615  1.00 19.61           C  
ATOM   1960  CG2 VAL   243     -48.358  71.162  49.551  1.00 19.49           C  
ATOM   1961  N   THR   244     -47.022  71.095  53.871  1.00 23.46           N  
ATOM   1962  CA  THR   244     -46.206  70.741  55.026  1.00 24.14           C  
ATOM   1963  C   THR   244     -47.068  70.220  56.171  1.00 24.59           C  
ATOM   1964  O   THR   244     -46.720  69.227  56.810  1.00 25.30           O  
ATOM   1965  CB  THR   244     -45.377  71.949  55.503  1.00 24.38           C  
ATOM   1966  OG1 THR   244     -44.460  72.324  54.467  1.00 24.49           O  
ATOM   1967  CG2 THR   244     -44.594  71.604  56.760  1.00 25.17           C  
ATOM   1968  N   LEU   245     -48.190  70.880  56.439  1.00 24.98           N  
ATOM   1969  CA  LEU   245     -49.077  70.416  57.495  1.00 24.98           C  
ATOM   1970  C   LEU   245     -49.613  69.020  57.158  1.00 25.34           C  
ATOM   1971  O   LEU   245     -49.613  68.128  58.009  1.00 24.68           O  
ATOM   1972  CB  LEU   245     -50.241  71.389  57.692  1.00 24.93           C  
ATOM   1973  CG  LEU   245     -49.874  72.760  58.271  1.00 27.25           C  
ATOM   1974  CD1 LEU   245     -51.112  73.635  58.352  1.00 27.15           C  
ATOM   1975  CD2 LEU   245     -49.230  72.603  59.650  1.00 27.56           C  
ATOM   1976  N   ALA   246     -50.049  68.831  55.915  1.00 24.91           N  
ATOM   1977  CA  ALA   246     -50.581  67.541  55.482  1.00 25.18           C  
ATOM   1978  C   ALA   246     -49.535  66.434  55.610  1.00 25.82           C  
ATOM   1979  O   ALA   246     -49.812  65.378  56.187  1.00 25.76           O  
ATOM   1980  CB  ALA   246     -51.084  67.627  54.041  1.00 24.64           C  
ATOM   1981  N   SER   247     -48.340  66.666  55.073  1.00 26.75           N  
ATOM   1982  CA  SER   247     -47.279  65.665  55.161  1.00 28.94           C  
ATOM   1983  C   SER   247     -47.005  65.267  56.613  1.00 30.31           C  
ATOM   1984  O   SER   247     -46.826  64.085  56.911  1.00 30.68           O  
ATOM   1985  CB  SER   247     -45.990  66.182  54.522  1.00 28.90           C  
ATOM   1986  OG  SER   247     -46.169  66.398  53.134  1.00 32.15           O  
ATOM   1987  N   GLU   248     -46.966  66.250  57.509  1.00 32.00           N  
ATOM   1988  CA  GLU   248     -46.727  65.976  58.921  1.00 33.31           C  
ATOM   1989  C   GLU   248     -47.822  65.067  59.479  1.00 33.39           C  
ATOM   1990  O   GLU   248     -47.643  64.443  60.524  1.00 33.68           O  
ATOM   1991  CB  GLU   248     -46.683  67.274  59.732  1.00 33.76           C  
ATOM   1992  CG  GLU   248     -45.611  68.257  59.292  1.00 37.96           C  
ATOM   1993  CD  GLU   248     -45.498  69.456  60.222  1.00 43.25           C  
ATOM   1994  OE1 GLU   248     -46.547  69.998  60.636  1.00 43.98           O  
ATOM   1995  OE2 GLU   248     -44.357  69.862  60.531  1.00 46.59           O  
ATOM   1996  N   LEU   249     -48.954  65.003  58.779  1.00 32.87           N  
ATOM   1997  CA  LEU   249     -50.073  64.152  59.194  1.00 32.64           C  
ATOM   1998  C   LEU   249     -50.085  62.850  58.402  1.00 31.52           C  
ATOM   1999  O   LEU   249     -51.015  62.056  58.513  1.00 32.25           O  
ATOM   2000  CB  LEU   249     -51.406  64.884  58.994  1.00 32.73           C  
ATOM   2001  CG  LEU   249     -51.716  66.002  59.994  1.00 33.49           C  
ATOM   2002  CD1 LEU   249     -52.961  66.762  59.575  1.00 32.24           C  
ATOM   2003  CD2 LEU   249     -51.903  65.398  61.373  1.00 36.58           C  
ATOM   2004  N   GLN   250     -49.035  62.636  57.613  1.00 30.77           N  
ATOM   2005  CA  GLN   250     -48.914  61.451  56.768  1.00 30.27           C  
ATOM   2006  C   GLN   250     -50.052  61.305  55.771  1.00 28.32           C  
ATOM   2007  O   GLN   250     -50.450  60.194  55.446  1.00 27.01           O  
ATOM   2008  CB  GLN   250     -48.831  60.170  57.600  1.00 31.79           C  
ATOM   2009  CG  GLN   250     -47.483  59.925  58.243  1.00 35.48           C  
ATOM   2010  CD  GLN   250     -47.180  60.934  59.314  1.00 40.70           C  
ATOM   2011  OE1 GLN   250     -47.956  61.107  60.253  1.00 43.32           O  
ATOM   2012  NE2 GLN   250     -46.049  61.617  59.183  1.00 44.72           N  
ATOM   2013  N   ILE   251     -50.590  62.429  55.311  1.00 26.54           N  
ATOM   2014  CA  ILE   251     -51.649  62.404  54.312  1.00 24.52           C  
ATOM   2015  C   ILE   251     -50.946  62.321  52.959  1.00 24.45           C  
ATOM   2016  O   ILE   251     -50.077  63.141  52.649  1.00 23.94           O  
ATOM   2017  CB  ILE   251     -52.504  63.687  54.351  1.00 24.89           C  
ATOM   2018  CG1 ILE   251     -53.280  63.773  55.667  1.00 23.70           C  
ATOM   2019  CG2 ILE   251     -53.432  63.719  53.151  1.00 23.90           C  
ATOM   2020  CD1 ILE   251     -54.008  65.099  55.862  1.00 21.71           C  
ATOM   2021  N   PRO   252     -51.293  61.311  52.150  1.00 23.96           N  
ATOM   2022  CA  PRO   252     -50.705  61.102  50.826  1.00 23.94           C  
ATOM   2023  C   PRO   252     -51.110  62.148  49.793  1.00 23.67           C  
ATOM   2024  O   PRO   252     -52.256  62.596  49.760  1.00 22.98           O  
ATOM   2025  CB  PRO   252     -51.203  59.701  50.446  1.00 24.03           C  
ATOM   2026  CG  PRO   252     -51.389  59.023  51.795  1.00 24.79           C  
ATOM   2027  CD  PRO   252     -52.068  60.129  52.563  1.00 24.64           C  
ATOM   2028  N   PHE   253     -50.149  62.532  48.961  1.00 23.10           N  
ATOM   2029  CA  PHE   253     -50.368  63.477  47.875  1.00 23.78           C  
ATOM   2030  C   PHE   253     -50.149  62.736  46.562  1.00 23.38           C  
ATOM   2031  O   PHE   253     -49.270  61.885  46.460  1.00 24.15           O  
ATOM   2032  CB  PHE   253     -49.368  64.643  47.945  1.00 23.07           C  
ATOM   2033  CG  PHE   253     -49.813  65.782  48.823  1.00 24.70           C  
ATOM   2034  CD1 PHE   253     -50.835  66.629  48.410  1.00 24.79           C  
ATOM   2035  CD2 PHE   253     -49.205  66.013  50.056  1.00 25.18           C  
ATOM   2036  CE1 PHE   253     -51.251  67.689  49.205  1.00 25.71           C  
ATOM   2037  CE2 PHE   253     -49.611  67.068  50.861  1.00 25.52           C  
ATOM   2038  CZ  PHE   253     -50.638  67.911  50.434  1.00 25.15           C  
ATOM   2039  N   VAL   254     -50.972  63.041  45.568  1.00 22.52           N  
ATOM   2040  CA  VAL   254     -50.794  62.455  44.250  1.00 20.26           C  
ATOM   2041  C   VAL   254     -50.714  63.621  43.277  1.00 20.00           C  
ATOM   2042  O   VAL   254     -51.623  64.448  43.215  1.00 17.97           O  
ATOM   2043  CB  VAL   254     -51.969  61.560  43.828  1.00 20.64           C  
ATOM   2044  CG1 VAL   254     -51.701  60.992  42.440  1.00 18.55           C  
ATOM   2045  CG2 VAL   254     -52.163  60.441  44.843  1.00 18.39           C  
ATOM   2046  N   TYR   255     -49.610  63.696  42.543  1.00 19.99           N  
ATOM   2047  CA  TYR   255     -49.417  64.753  41.560  1.00 19.74           C  
ATOM   2048  C   TYR   255     -50.584  64.800  40.586  1.00 19.60           C  
ATOM   2049  O   TYR   255     -51.027  63.767  40.082  1.00 20.40           O  
ATOM   2050  CB  TYR   255     -48.129  64.510  40.778  1.00 19.55           C  
ATOM   2051  CG  TYR   255     -48.013  65.328  39.509  1.00 18.66           C  
ATOM   2052  CD1 TYR   255     -47.679  66.685  39.557  1.00 17.53           C  
ATOM   2053  CD2 TYR   255     -48.221  64.738  38.257  1.00 17.16           C  
ATOM   2054  CE1 TYR   255     -47.546  67.436  38.392  1.00 18.34           C  
ATOM   2055  CE2 TYR   255     -48.093  65.479  37.081  1.00 17.14           C  
ATOM   2056  CZ  TYR   255     -47.753  66.828  37.159  1.00 18.27           C  
ATOM   2057  OH  TYR   255     -47.616  67.564  36.005  1.00 17.46           O  
ATOM   2058  N   GLY   256     -51.067  66.009  40.320  1.00 19.45           N  
ATOM   2059  CA  GLY   256     -52.167  66.194  39.392  1.00 19.66           C  
ATOM   2060  C   GLY   256     -51.877  67.383  38.496  1.00 20.10           C  
ATOM   2061  O   GLY   256     -51.783  68.519  38.975  1.00 19.77           O  
ATOM   2062  N   SER   257     -51.713  67.119  37.202  1.00 19.73           N  
ATOM   2063  CA  SER   257     -51.418  68.169  36.231  1.00 19.01           C  
ATOM   2064  C   SER   257     -52.697  68.865  35.784  1.00 19.17           C  
ATOM   2065  O   SER   257     -52.660  69.967  35.237  1.00 17.90           O  
ATOM   2066  CB  SER   257     -50.750  67.568  34.997  1.00 20.14           C  
ATOM   2067  OG  SER   257     -51.685  66.802  34.246  1.00 20.07           O  
ATOM   2068  N   ASP   258     -53.828  68.203  35.995  1.00 18.83           N  
ATOM   2069  CA  ASP   258     -55.115  68.744  35.575  1.00 19.26           C  
ATOM   2070  C   ASP   258     -55.043  69.113  34.086  1.00 19.75           C  
ATOM   2071  O   ASP   258     -55.607  70.121  33.657  1.00 20.46           O  
ATOM   2072  CB  ASP   258     -55.462  69.987  36.395  1.00 18.57           C  
ATOM   2073  CG  ASP   258     -56.952  70.093  36.684  1.00 19.86           C  
ATOM   2074  OD1 ASP   258     -57.752  69.596  35.869  1.00 15.61           O  
ATOM   2075  OD2 ASP   258     -57.321  70.681  37.719  1.00 19.11           O  
ATOM   2076  N   SER   259     -54.347  68.289  33.306  1.00 19.68           N  
ATOM   2077  CA  SER   259     -54.173  68.539  31.877  1.00 20.19           C  
ATOM   2078  C   SER   259     -55.465  68.476  31.068  1.00 20.86           C  
ATOM   2079  O   SER   259     -56.267  67.548  31.223  1.00 19.62           O  
ATOM   2080  CB  SER   259     -53.161  67.546  31.278  1.00 20.27           C  
ATOM   2081  OG  SER   259     -51.857  67.723  31.822  1.00 19.79           O  
ATOM   2082  N   HIS   260     -55.659  69.473  30.208  1.00 20.15           N  
ATOM   2083  CA  HIS   260     -56.824  69.534  29.330  1.00 22.39           C  
ATOM   2084  C   HIS   260     -56.339  69.537  27.890  1.00 23.08           C  
ATOM   2085  O   HIS   260     -57.102  69.806  26.960  1.00 24.11           O  
ATOM   2086  CB  HIS   260     -57.654  70.790  29.601  1.00 22.54           C  
ATOM   2087  CG  HIS   260     -58.335  70.775  30.930  1.00 25.42           C  
ATOM   2088  ND1 HIS   260     -57.642  70.834  32.120  1.00 30.26           N  
ATOM   2089  CD2 HIS   260     -59.642  70.666  31.263  1.00 28.04           C  
ATOM   2090  CE1 HIS   260     -58.491  70.762  33.128  1.00 28.91           C  
ATOM   2091  NE2 HIS   260     -59.712  70.658  32.636  1.00 29.14           N  
ATOM   2092  N   GLY   261     -55.057  69.227  27.727  1.00 23.33           N  
ATOM   2093  CA  GLY   261     -54.442  69.181  26.414  1.00 23.68           C  
ATOM   2094  C   GLY   261     -53.025  68.648  26.499  1.00 23.70           C  
ATOM   2095  O   GLY   261     -52.463  68.526  27.589  1.00 21.77           O  
ATOM   2096  N   VAL   262     -52.447  68.334  25.343  1.00 24.48           N  
ATOM   2097  CA  VAL   262     -51.093  67.793  25.266  1.00 24.70           C  
ATOM   2098  C   VAL   262     -50.031  68.695  25.906  1.00 25.45           C  
ATOM   2099  O   VAL   262     -49.134  68.217  26.603  1.00 25.31           O  
ATOM   2100  CB  VAL   262     -50.701  67.524  23.792  1.00 24.78           C  
ATOM   2101  CG1 VAL   262     -49.259  67.036  23.711  1.00 25.19           C  
ATOM   2102  CG2 VAL   262     -51.647  66.494  23.181  1.00 23.41           C  
ATOM   2103  N   GLN   263     -50.146  69.998  25.685  1.00 25.87           N  
ATOM   2104  CA  GLN   263     -49.169  70.932  26.220  1.00 27.74           C  
ATOM   2105  C   GLN   263     -49.167  71.046  27.735  1.00 27.17           C  
ATOM   2106  O   GLN   263     -48.200  71.540  28.309  1.00 27.20           O  
ATOM   2107  CB  GLN   263     -49.348  72.313  25.581  1.00 28.67           C  
ATOM   2108  CG  GLN   263     -48.984  72.324  24.106  1.00 34.74           C  
ATOM   2109  CD  GLN   263     -47.640  71.660  23.859  1.00 41.06           C  
ATOM   2110  OE1 GLN   263     -46.628  72.068  24.427  1.00 44.93           O  
ATOM   2111  NE2 GLN   263     -47.626  70.628  23.018  1.00 42.26           N  
ATOM   2112  N   ASP   264     -50.231  70.583  28.386  1.00 25.98           N  
ATOM   2113  CA  ASP   264     -50.301  70.646  29.844  1.00 25.46           C  
ATOM   2114  C   ASP   264     -49.585  69.469  30.504  1.00 24.54           C  
ATOM   2115  O   ASP   264     -49.186  69.546  31.666  1.00 23.91           O  
ATOM   2116  CB  ASP   264     -51.755  70.625  30.338  1.00 25.82           C  
ATOM   2117  CG  ASP   264     -52.563  71.819  29.874  1.00 28.55           C  
ATOM   2118  OD1 ASP   264     -51.978  72.893  29.609  1.00 30.52           O  
ATOM   2119  OD2 ASP   264     -53.805  71.676  29.797  1.00 28.80           O  
ATOM   2120  N   ILE   265     -49.456  68.368  29.769  1.00 24.00           N  
ATOM   2121  CA  ILE   265     -48.842  67.154  30.297  1.00 23.14           C  
ATOM   2122  C   ILE   265     -47.499  67.387  30.984  1.00 23.08           C  
ATOM   2123  O   ILE   265     -46.593  67.989  30.410  1.00 22.29           O  
ATOM   2124  CB  ILE   265     -48.657  66.099  29.177  1.00 23.36           C  
ATOM   2125  CG1 ILE   265     -50.015  65.744  28.553  1.00 23.31           C  
ATOM   2126  CG2 ILE   265     -47.999  64.847  29.735  1.00 22.67           C  
ATOM   2127  CD1 ILE   265     -50.988  65.075  29.504  1.00 21.69           C  
ATOM   2128  N   GLY   266     -47.390  66.910  32.222  1.00 21.85           N  
ATOM   2129  CA  GLY   266     -46.157  67.027  32.985  1.00 21.38           C  
ATOM   2130  C   GLY   266     -45.840  68.374  33.624  1.00 22.21           C  
ATOM   2131  O   GLY   266     -44.839  68.495  34.327  1.00 20.92           O  
ATOM   2132  N   ARG   267     -46.686  69.378  33.406  1.00 21.55           N  
ATOM   2133  CA  ARG   267     -46.425  70.713  33.942  1.00 22.08           C  
ATOM   2134  C   ARG   267     -46.265  70.789  35.456  1.00 22.31           C  
ATOM   2135  O   ARG   267     -47.046  70.208  36.217  1.00 23.20           O  
ATOM   2136  CB  ARG   267     -47.518  71.697  33.488  1.00 22.31           C  
ATOM   2137  CG  ARG   267     -48.931  71.398  34.006  1.00 21.85           C  
ATOM   2138  CD  ARG   267     -49.937  72.415  33.463  1.00 24.93           C  
ATOM   2139  NE  ARG   267     -51.317  72.118  33.858  1.00 21.71           N  
ATOM   2140  CZ  ARG   267     -52.370  72.845  33.491  1.00 23.47           C  
ATOM   2141  NH1 ARG   267     -52.204  73.910  32.720  1.00 22.66           N  
ATOM   2142  NH2 ARG   267     -53.592  72.515  33.894  1.00 22.10           N  
ATOM   2143  N   GLY   268     -45.234  71.509  35.885  1.00 22.20           N  
ATOM   2144  CA  GLY   268     -44.982  71.685  37.305  1.00 21.96           C  
ATOM   2145  C   GLY   268     -44.619  70.431  38.085  1.00 22.68           C  
ATOM   2146  O   GLY   268     -44.670  70.428  39.318  1.00 21.51           O  
ATOM   2147  N   TYR   269     -44.236  69.361  37.392  1.00 22.88           N  
ATOM   2148  CA  TYR   269     -43.891  68.137  38.109  1.00 23.59           C  
ATOM   2149  C   TYR   269     -42.690  68.319  39.039  1.00 24.32           C  
ATOM   2150  O   TYR   269     -42.693  67.802  40.160  1.00 24.55           O  
ATOM   2151  CB  TYR   269     -43.634  66.982  37.144  1.00 22.98           C  
ATOM   2152  CG  TYR   269     -43.500  65.667  37.869  1.00 25.04           C  
ATOM   2153  CD1 TYR   269     -42.244  65.124  38.156  1.00 26.89           C  
ATOM   2154  CD2 TYR   269     -44.633  64.982  38.311  1.00 25.25           C  
ATOM   2155  CE1 TYR   269     -42.125  63.933  38.871  1.00 27.44           C  
ATOM   2156  CE2 TYR   269     -44.524  63.800  39.024  1.00 25.00           C  
ATOM   2157  CZ  TYR   269     -43.272  63.280  39.301  1.00 27.02           C  
ATOM   2158  OH  TYR   269     -43.179  62.115  40.024  1.00 26.82           O  
ATOM   2159  N   SER   270     -41.668  69.046  38.584  1.00 25.14           N  
ATOM   2160  CA  SER   270     -40.486  69.297  39.422  1.00 26.58           C  
ATOM   2161  C   SER   270     -40.906  70.025  40.694  1.00 25.38           C  
ATOM   2162  O   SER   270     -40.441  69.709  41.789  1.00 25.49           O  
ATOM   2163  CB  SER   270     -39.452  70.153  38.678  1.00 27.36           C  
ATOM   2164  OG  SER   270     -38.415  70.574  39.565  1.00 33.05           O  
ATOM   2165  N   THR   271     -41.789  71.007  40.537  1.00 25.72           N  
ATOM   2166  CA  THR   271     -42.287  71.781  41.667  1.00 25.54           C  
ATOM   2167  C   THR   271     -42.950  70.841  42.663  1.00 25.92           C  
ATOM   2168  O   THR   271     -42.724  70.939  43.868  1.00 24.85           O  
ATOM   2169  CB  THR   271     -43.298  72.848  41.200  1.00 25.60           C  
ATOM   2170  OG1 THR   271     -42.628  73.798  40.361  1.00 28.28           O  
ATOM   2171  CG2 THR   271     -43.913  73.575  42.391  1.00 24.22           C  
ATOM   2172  N   TYR   272     -43.769  69.931  42.147  1.00 26.64           N  
ATOM   2173  CA  TYR   272     -44.447  68.946  42.985  1.00 27.38           C  
ATOM   2174  C   TYR   272     -43.410  68.194  43.817  1.00 27.95           C  
ATOM   2175  O   TYR   272     -43.494  68.157  45.046  1.00 28.30           O  
ATOM   2176  CB  TYR   272     -45.231  67.964  42.102  1.00 26.88           C  
ATOM   2177  CG  TYR   272     -45.495  66.615  42.739  1.00 28.67           C  
ATOM   2178  CD1 TYR   272     -46.392  66.480  43.799  1.00 29.74           C  
ATOM   2179  CD2 TYR   272     -44.836  65.473  42.285  1.00 29.38           C  
ATOM   2180  CE1 TYR   272     -46.626  65.239  44.390  1.00 30.77           C  
ATOM   2181  CE2 TYR   272     -45.059  64.227  42.867  1.00 28.61           C  
ATOM   2182  CZ  TYR   272     -45.956  64.118  43.917  1.00 30.62           C  
ATOM   2183  OH  TYR   272     -46.187  62.891  44.497  1.00 30.50           O  
ATOM   2184  N   CYS   273     -42.427  67.605  43.143  1.00 28.84           N  
ATOM   2185  CA  CYS   273     -41.380  66.849  43.820  1.00 30.44           C  
ATOM   2186  C   CYS   273     -40.656  67.651  44.902  1.00 30.82           C  
ATOM   2187  O   CYS   273     -40.502  67.180  46.032  1.00 30.32           O  
ATOM   2188  CB  CYS   273     -40.357  66.337  42.803  1.00 30.75           C  
ATOM   2189  SG  CYS   273     -41.057  65.230  41.563  1.00 36.62           S  
ATOM   2190  N   GLN   274     -40.208  68.855  44.553  1.00 30.67           N  
ATOM   2191  CA  GLN   274     -39.482  69.698  45.498  1.00 31.61           C  
ATOM   2192  C   GLN   274     -40.352  70.170  46.655  1.00 31.94           C  
ATOM   2193  O   GLN   274     -39.910  70.209  47.804  1.00 31.24           O  
ATOM   2194  CB  GLN   274     -38.881  70.910  44.769  1.00 31.80           C  
ATOM   2195  CG  GLN   274     -37.881  70.533  43.680  1.00 33.44           C  
ATOM   2196  CD  GLN   274     -36.760  69.663  44.214  1.00 37.81           C  
ATOM   2197  OE1 GLN   274     -36.189  68.844  43.493  1.00 41.63           O  
ATOM   2198  NE2 GLN   274     -36.434  69.842  45.486  1.00 38.86           N  
ATOM   2199  N   LYS   275     -41.600  70.514  46.352  1.00 32.77           N  
ATOM   2200  CA  LYS   275     -42.515  71.011  47.370  1.00 34.31           C  
ATOM   2201  C   LYS   275     -42.776  69.970  48.459  1.00 35.07           C  
ATOM   2202  O   LYS   275     -43.050  70.326  49.603  1.00 35.05           O  
ATOM   2203  CB  LYS   275     -43.837  71.440  46.726  1.00 34.59           C  
ATOM   2204  CG  LYS   275     -44.623  72.453  47.542  1.00 34.84           C  
ATOM   2205  CD  LYS   275     -44.659  73.786  46.815  1.00 38.81           C  
ATOM   2206  CE  LYS   275     -46.079  74.300  46.683  1.00 40.51           C  
ATOM   2207  NZ  LYS   275     -46.141  75.544  45.858  1.00 41.77           N  
END
