
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  271 ( 2026),  selected  271 , name 1jye_A
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 1jye_A.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L    62_A      Y      71          4.792
LGA    L    63_A      S      72          1.801
LGA    I    64_A      I      73          0.876
LGA    G    65_A      A      74          0.615
LGA    V    66_A      L      75          0.650
LGA    A    67_A      I      76          0.655
LGA    T    68_A      I      77          0.775
LGA    S    69_A      P      78          1.313
LGA    S    70_A      S      79          1.639
LGA    L    71_A      L      80          1.302
LGA    A    72_A      F      81          2.879
LGA    L    73_A      E      82          2.877
LGA    H    74_A      K      83          2.866
LGA    A    75_A      A      84          2.670
LGA    P    76_A      C      85          1.708
LGA    S    77_A      A      86          1.130
LGA    Q    78_A      H      87          1.000
LGA    I    79_A      F      88          1.306
LGA    V    80_A      L      89          1.484
LGA    A    81_A      P      90          2.095
LGA    A    82_A      S      91          2.229
LGA    I    83_A      F      92          1.086
LGA    L    84_A      Q      93          1.242
LGA    S    85_A      Q      94          2.129
LGA    R    86_A      A      95          1.630
LGA    A    87_A      L      96          1.526
LGA    D    88_A      N      97          2.025
LGA    Q    89_A      K      98          2.434
LGA    L    90_A      A      99          2.076
LGA    G    91_A      G     100          1.730
LGA    A    92_A      Y     101          1.493
LGA    S    93_A      Q     102          1.047
LGA    V    94_A      L     103          0.309
LGA    V    95_A      L     104          0.614
LGA    V    96_A      L     105          0.951
LGA    S    97_A      G     106          0.385
LGA    M    98_A      Y     107          0.727
LGA    V    99_A      S     108          0.827
LGA    E   100_A      D     109          3.072
LGA    R   101_A      Y     110          2.258
LGA    S   102_A      S     111          3.646
LGA    G   103_A      I     112          3.445
LGA    V   104_A      -       -           -
LGA    E   105_A      E     113          2.090
LGA    A   106_A      Q     114          2.515
LGA    C   107_A      E     115          2.307
LGA    K   108_A      E     116          2.448
LGA    T   109_A      K     117          2.604
LGA    A   110_A      L     118          2.807
LGA    V   111_A      L     119          1.921
LGA    H   112_A      S     120          1.524
LGA    N   113_A      T     121          2.544
LGA    L   114_A      F     122          2.165
LGA    L   115_A      L     123          1.361
LGA    A   116_A      E     124          2.776
LGA    Q   117_A      S     125          3.189
LGA    R   118_A      R     126          1.147
LGA    V   119_A      P     127          4.235
LGA    S   120_A      A     128          0.798
LGA    G   121_A      G     129          1.035
LGA    L   122_A      V     130          0.980
LGA    I   123_A      V     131          1.146
LGA    I   124_A      L     132          0.562
LGA    N   125_A      F     133          2.371
LGA    Y   126_A      -       -           -
LGA    P   127_A      G     134          2.967
LGA    L   128_A      S     135          3.288
LGA    D   129_A      E     136          3.609
LGA    D   130_A      -       -           -
LGA    Q   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    I   134_A      H     137           #
LGA    -       -      S     138           -
LGA    -       -      Q     139           -
LGA    A   135_A      R     140           #
LGA    V   136_A      T     141          3.946
LGA    E   137_A      H     142          4.126
LGA    A   138_A      Q     143          3.649
LGA    A   139_A      L     144          3.017
LGA    C   140_A      L     145          1.206
LGA    T   141_A      E     146          3.875
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    N   142_A      N     149          1.590
LGA    V   143_A      T     150          1.360
LGA    P   144_A      P     151          0.566
LGA    A   145_A      V     152          0.596
LGA    L   146_A      L     153          0.285
LGA    F   147_A      E     154          0.491
LGA    L   148_A      I     155          0.545
LGA    D   149_A      A     156          2.937
LGA    V   150_A      -       -           -
LGA    S   151_A      E     157          3.353
LGA    D   152_A      L     158          2.445
LGA    Q   153_A      S     159           #
LGA    T   154_A      S     160          4.349
LGA    -       -      K     161           -
LGA    P   155_A      A     162          3.320
LGA    -       -      S     163           -
LGA    I   156_A      Y     164          3.128
LGA    N   157_A      L     165          2.017
LGA    S   158_A      N     166          1.187
LGA    I   159_A      I     167          0.446
LGA    I   160_A      G     168          0.686
LGA    F   161_A      V     169          1.000
LGA    S   162_A      D     170          2.417
LGA    H   163_A      H     171          2.089
LGA    E   164_A      F     172          3.460
LGA    D   165_A      E     173          2.622
LGA    G   166_A      V     174          1.172
LGA    T   167_A      G     175          1.783
LGA    R   168_A      K     176          2.298
LGA    L   169_A      A     177          1.516
LGA    G   170_A      C     178          0.529
LGA    V   171_A      T     179          1.301
LGA    E   172_A      R     180          1.239
LGA    H   173_A      H     181          0.591
LGA    L   174_A      L     182          0.650
LGA    V   175_A      I     183          0.836
LGA    A   176_A      E     184          0.550
LGA    L   177_A      Q     185          0.888
LGA    G   178_A      G     186          1.187
LGA    H   179_A      F     187          1.805
LGA    Q   180_A      K     188          1.709
LGA    Q   181_A      N     189          1.022
LGA    I   182_A      V     190          0.870
LGA    A   183_A      G     191          0.380
LGA    L   184_A      F     192          0.899
LGA    L   185_A      I     193          1.054
LGA    A   186_A      G     194          2.167
LGA    G   187_A      A     195          2.514
LGA    P   188_A      R     196          1.574
LGA    L   189_A      G     197          1.640
LGA    S   190_A      N     198          1.905
LGA    S   191_A      H     199          1.371
LGA    V   192_A      S     200          1.478
LGA    S   193_A      T     201          1.241
LGA    A   194_A      L     202          1.158
LGA    R   195_A      Q     203          1.470
LGA    L   196_A      R     204          1.262
LGA    R   197_A      Q     205          1.217
LGA    L   198_A      L     206          1.235
LGA    A   199_A      H     207          1.453
LGA    G   200_A      G     208          1.380
LGA    W   201_A      W     209          1.239
LGA    H   202_A      Q     210          1.194
LGA    K   203_A      S     211          1.725
LGA    Y   204_A      A     212          2.137
LGA    L   205_A      M     213          1.819
LGA    T   206_A      I     214          1.555
LGA    R   207_A      E     215          1.504
LGA    N   208_A      N     216          1.920
LGA    Q   209_A      Y     217          1.931
LGA    I   210_A      L     218          1.389
LGA    Q   211_A      T     219          1.666
LGA    P   212_A      P     220          2.601
LGA    I   213_A      D     221          4.930
LGA    A   214_A      H     222          0.884
LGA    E   215_A      F     223          0.341
LGA    R   216_A      L     224          0.320
LGA    E   217_A      T     225          1.004
LGA    G   218_A      T     226          4.066
LGA    -       -      H     227           -
LGA    -       -      E     228           -
LGA    D   219_A      A     229          2.479
LGA    W   220_A      P     230          2.244
LGA    S   221_A      S     231          2.445
LGA    A   222_A      S     232          2.450
LGA    M   223_A      Q     233          2.596
LGA    S   224_A      L     234          2.098
LGA    G   225_A      G     235          2.055
LGA    F   226_A      A     236          2.309
LGA    Q   227_A      E     237          2.613
LGA    Q   228_A      G     238          1.989
LGA    T   229_A      L     239          2.027
LGA    M   230_A      A     240          2.455
LGA    Q   231_A      K     241          2.642
LGA    M   232_A      L     242          2.370
LGA    L   233_A      L     243          2.615
LGA    N   234_A      -       -           -
LGA    E   235_A      L     244          1.733
LGA    G   236_A      R     245          4.771
LGA    I   237_A      D     246          2.442
LGA    V   238_A      S     247          3.193
LGA    -       -      S     248           -
LGA    P   239_A      L     249          1.389
LGA    T   240_A      N     250          0.796
LGA    A   241_A      A     251          0.643
LGA    M   242_A      L     252          0.772
LGA    L   243_A      V     253          0.913
LGA    V   244_A      C     254          0.869
LGA    A   245_A      S     255          0.638
LGA    N   246_A      H     256          1.615
LGA    D   247_A      E     257          1.494
LGA    Q   248_A      E     258          1.796
LGA    M   249_A      I     259          1.313
LGA    A   250_A      A     260          0.958
LGA    L   251_A      I     261          0.914
LGA    G   252_A      G     262          1.274
LGA    A   253_A      A     263          1.420
LGA    M   254_A      L     264          1.205
LGA    R   255_A      F     265          1.601
LGA    A   256_A      E     266          1.891
LGA    I   257_A      C     267          1.863
LGA    T   258_A      H     268          1.658
LGA    E   259_A      R     269          1.198
LGA    S   260_A      R     270          1.674
LGA    G   261_A      V     271          1.713
LGA    L   262_A      L     272          0.919
LGA    R   263_A      K     273          1.686
LGA    V   264_A      V     274          2.271
LGA    G   265_A      P     275          1.430
LGA    A   266_A      T     276          1.904
LGA    D   267_A      D     277          1.155
LGA    I   268_A      I     278          0.590
LGA    S   269_A      A     279          0.619
LGA    V   270_A      I     280          0.699
LGA    V   271_A      I     281          0.621
LGA    G   272_A      C     282          0.357
LGA    Y   273_A      L     283          1.756
LGA    D   274_A      E     284          2.060
LGA    D   275_A      G     285          2.677
LGA    T   276_A      S     286          1.120
LGA    E   277_A      S     287          2.349
LGA    D   278_A      M     288          1.351
LGA    S   279_A      G     289          1.825
LGA    S   280_A      E     290          1.290
LGA    C   281_A      H     291          0.854
LGA    Y   282_A      A     292          1.367
LGA    I   283_A      Y     293          1.721
LGA    P   284_A      P     294          1.703
LGA    P   285_A      S     295          1.200
LGA    L   286_A      L     296          1.350
LGA    T   287_A      T     297          0.547
LGA    T   288_A      S     298          0.596
LGA    I   289_A      A     299          0.858
LGA    K   290_A      E     300          1.265
LGA    Q   291_A      F     301          1.434
LGA    D   292_A      D     302          1.127
LGA    F   293_A      Y     303          0.843
LGA    R   294_A      E     304          0.838
LGA    L   295_A      R     305          1.272
LGA    L   296_A      M     306          1.153
LGA    G   297_A      G     307          1.322
LGA    Q   298_A      T     308          1.206
LGA    T   299_A      K     309          0.596
LGA    S   300_A      A     310          0.551
LGA    V   301_A      A     311          0.535
LGA    D   302_A      E     312          0.550
LGA    R   303_A      K     313          0.592
LGA    L   304_A      L     314          0.981
LGA    L   305_A      L     315          1.270
LGA    Q   306_A      H     316          1.301
LGA    L   307_A      A     317          1.654
LGA    S   308_A      I     318          2.035
LGA    Q   309_A      K     319          2.810
LGA    G   310_A      E     321          2.888
LGA    Q   311_A      P     322          2.590
LGA    A   312_A      E     323          1.916
LGA    V   313_A      E     324          3.853
LGA    K   314_A      -       -           -
LGA    G   315_A      -       -           -
LGA    N   316_A      P     326          5.691
LGA    Q   317_A      T     327          2.564
LGA    L   318_A      S     328          2.890
LGA    L   319_A      M     329          0.974
LGA    P   320_A      G     330          1.489
LGA    V   321_A      F     331          1.376
LGA    S   322_A      K     332          1.920
LGA    L   323_A      L     333          0.873
LGA    V   324_A      K     334          0.824
LGA    K   325_A      R     335          0.453
LGA    R   326_A      R     336          0.838
LGA    K   327_A      A     337          1.002
LGA    T   328_A      S     338          0.711
LGA    T   329_A      T     339          0.674
LGA    L   330_A      A     340          3.141
LGA    A   331_A      I     341          4.774
LGA    P   332_A      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  271  270    5.0    257    1.98    17.12     74.522    12.349

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.479352 * X  +  -0.011659 * Y  +  -0.877545 * Z  +  97.549965
  Y_new =   0.225171 * X  +   0.968074 * Y  +   0.110136 * Z  +   1.842273
  Z_new =   0.848245 * X  +  -0.250392 * Y  +   0.466673 * Z  + -61.486023 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.492455    2.649138  [ DEG:   -28.2156    151.7844 ]
  Theta =  -1.012663   -2.128930  [ DEG:   -58.0213   -121.9787 ]
  Phi   =   0.439148   -2.702445  [ DEG:    25.1613   -154.8387 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jye_A                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jye_A.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  271  270   5.0  257   1.98   17.12  74.522
REMARK  ---------------------------------------------------------- 
MOLECULE 1jye_A
HEADER    TRANSCRIPTION                           12-SEP-01   1JYE              
TITLE     STRUCTURE OF A DIMERIC LAC REPRESSOR WITH C-TERMINAL                  
TITLE    2 DELETION AND K84L SUBSTITUTION                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LACTOSE OPERON REPRESSOR;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL DELETION MUTANT;                                
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: LACI;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: TB-1;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PJC-1                                     
KEYWDS    GENE REGULATION, PROTEIN STABILITY, PROTEIN DNA-BINDING               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.E.BELL,J.BARRY,K.S.MATTHEWS,M.LEWIS                                 
REVDAT   1   18-OCT-01 1JYE    0                                                
JRNL        AUTH   C.E.BELL,J.BARRY,K.S.MATTHEWS,M.LEWIS                        
JRNL        TITL   STRUCTURE OF A VARIANT OF LAC REPRESSOR WITH                 
JRNL        TITL 2 INCREASED THERMOSTABILITY AND DECREASED AFFINITY             
JRNL        TITL 3 FOR OPERATOR.                                                
JRNL        REF    J.MOL.BIOL.                   V. 313    99 2001              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1JYE A    1   349  UNP    P03023   LACI_ECOLI       1    349             
SEQRES   1 A  349  MET LYS PRO VAL THR LEU TYR ASP VAL ALA GLU TYR ALA          
SEQRES   2 A  349  GLY VAL SER TYR GLN THR VAL SER ARG VAL VAL ASN GLN          
SEQRES   3 A  349  ALA SER HIS VAL SER ALA LYS THR ARG GLU LYS VAL GLU          
SEQRES   4 A  349  ALA ALA MET ALA GLU LEU ASN TYR ILE PRO ASN ARG VAL          
SEQRES   5 A  349  ALA GLN GLN LEU ALA GLY LYS GLN SER LEU LEU ILE GLY          
SEQRES   6 A  349  VAL ALA THR SER SER LEU ALA LEU HIS ALA PRO SER GLN          
SEQRES   7 A  349  ILE VAL ALA ALA ILE LEU SER ARG ALA ASP GLN LEU GLY          
SEQRES   8 A  349  ALA SER VAL VAL VAL SER MET VAL GLU ARG SER GLY VAL          
SEQRES   9 A  349  GLU ALA CYS LYS THR ALA VAL HIS ASN LEU LEU ALA GLN          
SEQRES  10 A  349  ARG VAL SER GLY LEU ILE ILE ASN TYR PRO LEU ASP ASP          
SEQRES  11 A  349  GLN ASP ALA ILE ALA VAL GLU ALA ALA CYS THR ASN VAL          
SEQRES  12 A  349  PRO ALA LEU PHE LEU ASP VAL SER ASP GLN THR PRO ILE          
SEQRES  13 A  349  ASN SER ILE ILE PHE SER HIS GLU ASP GLY THR ARG LEU          
SEQRES  14 A  349  GLY VAL GLU HIS LEU VAL ALA LEU GLY HIS GLN GLN ILE          
SEQRES  15 A  349  ALA LEU LEU ALA GLY PRO LEU SER SER VAL SER ALA ARG          
SEQRES  16 A  349  LEU ARG LEU ALA GLY TRP HIS LYS TYR LEU THR ARG ASN          
SEQRES  17 A  349  GLN ILE GLN PRO ILE ALA GLU ARG GLU GLY ASP TRP SER          
SEQRES  18 A  349  ALA MET SER GLY PHE GLN GLN THR MET GLN MET LEU ASN          
SEQRES  19 A  349  GLU GLY ILE VAL PRO THR ALA MET LEU VAL ALA ASN ASP          
SEQRES  20 A  349  GLN MET ALA LEU GLY ALA MET ARG ALA ILE THR GLU SER          
SEQRES  21 A  349  GLY LEU ARG VAL GLY ALA ASP ILE SER VAL VAL GLY TYR          
SEQRES  22 A  349  ASP ASP THR GLU ASP SER SER CYS TYR ILE PRO PRO LEU          
SEQRES  23 A  349  THR THR ILE LYS GLN ASP PHE ARG LEU LEU GLY GLN THR          
SEQRES  24 A  349  SER VAL ASP ARG LEU LEU GLN LEU SER GLN GLY GLN ALA          
SEQRES  25 A  349  VAL LYS GLY ASN GLN LEU LEU PRO VAL SER LEU VAL LYS          
SEQRES  26 A  349  ARG LYS THR THR LEU ALA PRO ASN THR GLN THR ALA SER          
SEQRES  27 A  349  PRO ARG ALA LEU ALA ASP SER LEU MET GLN LEU                  
HET    GOL    300       6                                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   2  GOL    C3 H8 O3                                                     
FORMUL   3  HOH   *235(H2 O)                                                    
CRYST1   87.007   87.007  224.098  90.00  90.00  90.00 I 41 2 2     16          
ATOM      1  N   LEU A  62      51.402  85.764   8.306  1.00 32.68           N  
ATOM      2  CA  LEU A  62      50.248  85.020   8.889  1.00 31.86           C  
ATOM      3  C   LEU A  62      50.651  84.384  10.214  1.00 31.25           C  
ATOM      4  O   LEU A  62      51.679  83.711  10.300  1.00 29.73           O  
ATOM      5  CB  LEU A  62      49.772  83.941   7.915  1.00 33.97           C  
ATOM      6  CG  LEU A  62      48.572  83.100   8.356  1.00 35.02           C  
ATOM      7  CD1 LEU A  62      47.405  84.009   8.725  1.00 35.56           C  
ATOM      8  CD2 LEU A  62      48.182  82.152   7.231  1.00 36.02           C  
ATOM      9  N   LEU A  63      49.830  84.592  11.239  1.00 30.31           N  
ATOM     10  CA  LEU A  63      50.117  84.059  12.567  1.00 28.59           C  
ATOM     11  C   LEU A  63      48.870  83.572  13.302  1.00 27.73           C  
ATOM     12  O   LEU A  63      47.873  84.290  13.397  1.00 29.08           O  
ATOM     13  CB  LEU A  63      50.802  85.139  13.408  1.00 28.54           C  
ATOM     14  CG  LEU A  63      51.210  84.794  14.840  1.00 27.93           C  
ATOM     15  CD1 LEU A  63      52.415  83.873  14.819  1.00 28.46           C  
ATOM     16  CD2 LEU A  63      51.539  86.071  15.597  1.00 29.00           C  
ATOM     17  N   ILE A  64      48.931  82.353  13.827  1.00 24.75           N  
ATOM     18  CA  ILE A  64      47.814  81.795  14.578  1.00 22.99           C  
ATOM     19  C   ILE A  64      48.279  81.409  15.977  1.00 21.61           C  
ATOM     20  O   ILE A  64      49.474  81.227  16.221  1.00 21.12           O  
ATOM     21  CB  ILE A  64      47.210  80.564  13.873  1.00 24.95           C  
ATOM     22  CG1 ILE A  64      48.274  79.482  13.680  1.00 25.77           C  
ATOM     23  CG2 ILE A  64      46.618  80.985  12.532  1.00 26.37           C  
ATOM     24  CD1 ILE A  64      47.756  78.236  12.981  1.00 28.19           C  
ATOM     25  N   GLY A  65      47.331  81.301  16.900  1.00 18.01           N  
ATOM     26  CA  GLY A  65      47.678  80.952  18.261  1.00 16.95           C  
ATOM     27  C   GLY A  65      47.027  79.663  18.715  1.00 17.21           C  
ATOM     28  O   GLY A  65      45.906  79.345  18.318  1.00 17.01           O  
ATOM     29  N   VAL A  66      47.740  78.916  19.548  1.00 15.38           N  
ATOM     30  CA  VAL A  66      47.227  77.661  20.072  1.00 15.56           C  
ATOM     31  C   VAL A  66      47.309  77.653  21.595  1.00 16.12           C  
ATOM     32  O   VAL A  66      48.383  77.853  22.163  1.00 15.27           O  
ATOM     33  CB  VAL A  66      48.036  76.445  19.549  1.00 15.95           C  
ATOM     34  CG1 VAL A  66      47.504  75.161  20.177  1.00 17.10           C  
ATOM     35  CG2 VAL A  66      47.951  76.364  18.029  1.00 15.53           C  
ATOM     36  N   ALA A  67      46.168  77.447  22.248  1.00 15.57           N  
ATOM     37  CA  ALA A  67      46.124  77.348  23.705  1.00 16.19           C  
ATOM     38  C   ALA A  67      46.010  75.840  23.889  1.00 16.28           C  
ATOM     39  O   ALA A  67      45.041  75.230  23.436  1.00 16.50           O  
ATOM     40  CB  ALA A  67      44.888  78.057  24.257  1.00 15.56           C  
ATOM     41  N   THR A  68      46.986  75.225  24.545  1.00 15.96           N  
ATOM     42  CA  THR A  68      46.954  73.771  24.664  1.00 15.23           C  
ATOM     43  C   THR A  68      47.213  73.156  26.027  1.00 16.33           C  
ATOM     44  O   THR A  68      47.883  73.742  26.878  1.00 16.65           O  
ATOM     45  CB  THR A  68      47.974  73.145  23.682  1.00 15.65           C  
ATOM     46  OG1 THR A  68      47.945  71.717  23.794  1.00 15.54           O  
ATOM     47  CG2 THR A  68      49.381  73.643  24.000  1.00 16.48           C  
ATOM     48  N   SER A  69      46.671  71.955  26.214  1.00 16.44           N  
ATOM     49  CA  SER A  69      46.886  71.195  27.434  1.00 17.34           C  
ATOM     50  C   SER A  69      48.371  70.854  27.374  1.00 17.36           C  
ATOM     51  O   SER A  69      48.992  70.975  26.319  1.00 18.20           O  
ATOM     52  CB  SER A  69      46.068  69.903  27.418  1.00 18.73           C  
ATOM     53  OG  SER A  69      44.676  70.170  27.418  1.00 19.94           O  
ATOM     54  N   SER A  70      48.933  70.416  28.494  1.00 17.91           N  
ATOM     55  CA  SER A  70      50.351  70.083  28.543  1.00 18.11           C  
ATOM     56  C   SER A  70      50.826  69.169  27.416  1.00 18.27           C  
ATOM     57  O   SER A  70      50.215  68.138  27.132  1.00 17.28           O  
ATOM     58  CB  SER A  70      50.695  69.438  29.886  1.00 19.39           C  
ATOM     59  OG  SER A  70      52.053  69.031  29.896  1.00 20.00           O  
ATOM     60  N   LEU A  71      51.932  69.551  26.785  1.00 17.64           N  
ATOM     61  CA  LEU A  71      52.496  68.758  25.702  1.00 19.22           C  
ATOM     62  C   LEU A  71      53.249  67.553  26.258  1.00 18.93           C  
ATOM     63  O   LEU A  71      53.781  66.740  25.505  1.00 19.78           O  
ATOM     64  CB  LEU A  71      53.423  69.615  24.836  1.00 20.67           C  
ATOM     65  CG  LEU A  71      52.726  70.784  24.132  1.00 21.28           C  
ATOM     66  CD1 LEU A  71      53.710  71.480  23.208  1.00 24.01           C  
ATOM     67  CD2 LEU A  71      51.524  70.270  23.340  1.00 23.99           C  
ATOM     68  N   ALA A  72      53.287  67.445  27.583  1.00 20.23           N  
ATOM     69  CA  ALA A  72      53.942  66.314  28.229  1.00 21.19           C  
ATOM     70  C   ALA A  72      53.018  65.117  28.044  1.00 21.91           C  
ATOM     71  O   ALA A  72      53.437  63.965  28.167  1.00 22.12           O  
ATOM     72  CB  ALA A  72      54.150  66.595  29.710  1.00 22.08           C  
ATOM     73  N   LEU A  73      51.753  65.411  27.749  1.00 20.99           N  
ATOM     74  CA  LEU A  73      50.735  64.391  27.518  1.00 21.41           C  
ATOM     75  C   LEU A  73      50.816  63.966  26.052  1.00 21.70           C  
ATOM     76  O   LEU A  73      51.022  64.798  25.167  1.00 21.82           O  
ATOM     77  CB  LEU A  73      49.342  64.959  27.827  1.00 22.31           C  
ATOM     78  CG  LEU A  73      49.081  65.366  29.282  1.00 24.75           C  
ATOM     79  CD1 LEU A  73      47.812  66.204  29.368  1.00 26.70           C  
ATOM     80  CD2 LEU A  73      48.963  64.117  30.143  1.00 27.63           C  
ATOM     81  N   HIS A  74      50.644  62.673  25.796  1.00 21.18           N  
ATOM     82  CA  HIS A  74      50.737  62.147  24.439  1.00 21.94           C  
ATOM     83  C   HIS A  74      49.754  62.722  23.425  1.00 20.43           C  
ATOM     84  O   HIS A  74      50.167  63.234  22.386  1.00 19.62           O  
ATOM     85  CB  HIS A  74      50.619  60.619  24.463  1.00 25.18           C  
ATOM     86  CG  HIS A  74      50.646  59.990  23.103  1.00 26.89           C  
ATOM     87  ND1 HIS A  74      49.512  59.819  22.339  1.00 29.82           N  
ATOM     88  CD2 HIS A  74      51.673  59.513  22.361  1.00 29.33           C  
ATOM     89  CE1 HIS A  74      49.838  59.264  21.186  1.00 29.26           C  
ATOM     90  NE2 HIS A  74      51.144  59.069  21.174  1.00 29.57           N  
ATOM     91  N   ALA A  75      48.459  62.639  23.714  1.00 19.89           N  
ATOM     92  CA  ALA A  75      47.455  63.146  22.780  1.00 20.23           C  
ATOM     93  C   ALA A  75      47.678  64.609  22.382  1.00 18.21           C  
ATOM     94  O   ALA A  75      47.740  64.931  21.195  1.00 17.81           O  
ATOM     95  CB  ALA A  75      46.053  62.961  23.363  1.00 20.40           C  
ATOM     96  N   PRO A  76      47.801  65.515  23.366  1.00 18.35           N  
ATOM     97  CA  PRO A  76      48.015  66.923  23.021  1.00 18.45           C  
ATOM     98  C   PRO A  76      49.250  67.141  22.142  1.00 18.19           C  
ATOM     99  O   PRO A  76      49.208  67.906  21.182  1.00 17.11           O  
ATOM    100  CB  PRO A  76      48.149  67.595  24.388  1.00 20.09           C  
ATOM    101  CG  PRO A  76      47.281  66.742  25.265  1.00 20.93           C  
ATOM    102  CD  PRO A  76      47.662  65.351  24.824  1.00 18.85           C  
ATOM    103  N   SER A  77      50.349  66.462  22.461  1.00 17.74           N  
ATOM    104  CA  SER A  77      51.564  66.625  21.671  1.00 18.13           C  
ATOM    105  C   SER A  77      51.397  66.136  20.231  1.00 16.97           C  
ATOM    106  O   SER A  77      51.952  66.721  19.308  1.00 16.89           O  
ATOM    107  CB  SER A  77      52.742  65.910  22.345  1.00 20.08           C  
ATOM    108  OG  SER A  77      52.488  64.529  22.503  1.00 22.81           O  
ATOM    109  N   GLN A  78      50.622  65.076  20.028  1.00 16.19           N  
ATOM    110  CA  GLN A  78      50.420  64.572  18.671  1.00 16.84           C  
ATOM    111  C   GLN A  78      49.586  65.572  17.875  1.00 15.26           C  
ATOM    112  O   GLN A  78      49.854  65.836  16.703  1.00 14.26           O  
ATOM    113  CB  GLN A  78      49.714  63.213  18.707  1.00 18.23           C  
ATOM    114  CG  GLN A  78      50.475  62.139  19.474  1.00 20.96           C  
ATOM    115  CD  GLN A  78      51.864  61.888  18.913  1.00 23.49           C  
ATOM    116  OE1 GLN A  78      52.019  61.557  17.740  1.00 25.29           O  
ATOM    117  NE2 GLN A  78      52.881  62.042  19.754  1.00 25.00           N  
ATOM    118  N   ILE A  79      48.568  66.130  18.518  1.00 14.42           N  
ATOM    119  CA  ILE A  79      47.714  67.103  17.857  1.00 14.19           C  
ATOM    120  C   ILE A  79      48.488  68.368  17.493  1.00 13.42           C  
ATOM    121  O   ILE A  79      48.429  68.834  16.356  1.00 13.87           O  
ATOM    122  CB  ILE A  79      46.520  67.480  18.757  1.00 14.56           C  
ATOM    123  CG1 ILE A  79      45.669  66.233  19.002  1.00 15.71           C  
ATOM    124  CG2 ILE A  79      45.712  68.610  18.114  1.00 15.01           C  
ATOM    125  CD1 ILE A  79      44.521  66.433  19.985  1.00 15.85           C  
ATOM    126  N   VAL A  80      49.226  68.917  18.452  1.00 15.25           N  
ATOM    127  CA  VAL A  80      49.981  70.137  18.193  1.00 13.69           C  
ATOM    128  C   VAL A  80      51.066  69.923  17.141  1.00 13.23           C  
ATOM    129  O   VAL A  80      51.347  70.818  16.346  1.00 12.87           O  
ATOM    130  CB  VAL A  80      50.577  70.708  19.500  1.00 14.24           C  
ATOM    131  CG1 VAL A  80      51.475  71.900  19.195  1.00 15.96           C  
ATOM    132  CG2 VAL A  80      49.447  71.150  20.426  1.00 16.91           C  
ATOM    133  N   ALA A  81      51.667  68.737  17.124  1.00 14.56           N  
ATOM    134  CA  ALA A  81      52.693  68.440  16.127  1.00 14.07           C  
ATOM    135  C   ALA A  81      52.070  68.564  14.738  1.00 13.91           C  
ATOM    136  O   ALA A  81      52.650  69.155  13.829  1.00 14.97           O  
ATOM    137  CB  ALA A  81      53.236  67.031  16.331  1.00 14.07           C  
ATOM    138  N   ALA A  82      50.875  68.003  14.581  1.00 14.10           N  
ATOM    139  CA  ALA A  82      50.169  68.049  13.306  1.00 14.16           C  
ATOM    140  C   ALA A  82      49.779  69.483  12.961  1.00 14.18           C  
ATOM    141  O   ALA A  82      49.808  69.879  11.798  1.00 15.41           O  
ATOM    142  CB  ALA A  82      48.931  67.167  13.364  1.00 14.24           C  
ATOM    143  N   ILE A  83      49.400  70.254  13.973  1.00 13.31           N  
ATOM    144  CA  ILE A  83      49.036  71.649  13.761  1.00 13.53           C  
ATOM    145  C   ILE A  83      50.247  72.411  13.223  1.00 14.83           C  
ATOM    146  O   ILE A  83      50.150  73.139  12.232  1.00 15.96           O  
ATOM    147  CB  ILE A  83      48.574  72.315  15.077  1.00 13.70           C  
ATOM    148  CG1 ILE A  83      47.203  71.762  15.483  1.00 13.60           C  
ATOM    149  CG2 ILE A  83      48.521  73.834  14.910  1.00 13.64           C  
ATOM    150  CD1 ILE A  83      46.710  72.278  16.820  1.00 14.92           C  
ATOM    151  N   LEU A  84      51.392  72.230  13.874  1.00 15.11           N  
ATOM    152  CA  LEU A  84      52.610  72.917  13.457  1.00 15.82           C  
ATOM    153  C   LEU A  84      53.046  72.501  12.059  1.00 17.11           C  
ATOM    154  O   LEU A  84      53.522  73.326  11.279  1.00 18.44           O  
ATOM    155  CB  LEU A  84      53.740  72.646  14.455  1.00 16.02           C  
ATOM    156  CG  LEU A  84      53.501  73.148  15.881  1.00 17.06           C  
ATOM    157  CD1 LEU A  84      54.663  72.724  16.772  1.00 19.52           C  
ATOM    158  CD2 LEU A  84      53.343  74.661  15.879  1.00 17.22           C  
ATOM    159  N   SER A  85      52.885  71.222  11.739  1.00 17.29           N  
ATOM    160  CA  SER A  85      53.264  70.733  10.420  1.00 18.95           C  
ATOM    161  C   SER A  85      52.409  71.371   9.328  1.00 18.77           C  
ATOM    162  O   SER A  85      52.931  71.870   8.328  1.00 18.18           O  
ATOM    163  CB  SER A  85      53.126  69.210  10.355  1.00 20.71           C  
ATOM    164  OG  SER A  85      53.449  68.732   9.060  1.00 23.50           O  
ATOM    165  N   ARG A  86      51.092  71.361   9.524  1.00 16.83           N  
ATOM    166  CA  ARG A  86      50.178  71.928   8.538  1.00 18.16           C  
ATOM    167  C   ARG A  86      50.327  73.442   8.432  1.00 19.37           C  
ATOM    168  O   ARG A  86      50.228  74.008   7.340  1.00 20.62           O  
ATOM    169  CB  ARG A  86      48.732  71.561   8.884  1.00 18.97           C  
ATOM    170  CG  ARG A  86      47.715  71.964   7.825  1.00 20.15           C  
ATOM    171  CD  ARG A  86      48.091  71.417   6.450  1.00 25.63           C  
ATOM    172  NE  ARG A  86      47.042  71.656   5.462  1.00 27.31           N  
ATOM    173  CZ  ARG A  86      47.225  71.599   4.146  1.00 30.90           C  
ATOM    174  NH1 ARG A  86      48.422  71.312   3.652  1.00 30.91           N  
ATOM    175  NH2 ARG A  86      46.209  71.829   3.324  1.00 31.30           N  
ATOM    176  N   ALA A  87      50.563  74.099   9.563  1.00 18.09           N  
ATOM    177  CA  ALA A  87      50.738  75.547   9.572  1.00 18.76           C  
ATOM    178  C   ALA A  87      51.947  75.901   8.710  1.00 20.74           C  
ATOM    179  O   ALA A  87      51.890  76.816   7.886  1.00 20.99           O  
ATOM    180  CB  ALA A  87      50.946  76.041  10.995  1.00 18.90           C  
ATOM    181  N   ASP A  88      53.036  75.165   8.908  1.00 22.03           N  
ATOM    182  CA  ASP A  88      54.265  75.377   8.148  1.00 25.37           C  
ATOM    183  C   ASP A  88      53.954  75.229   6.662  1.00 26.27           C  
ATOM    184  O   ASP A  88      54.388  76.036   5.839  1.00 26.33           O  
ATOM    185  CB  ASP A  88      55.317  74.343   8.556  1.00 27.49           C  
ATOM    186  CG  ASP A  88      56.668  74.589   7.906  1.00 31.82           C  
ATOM    187  OD1 ASP A  88      57.450  73.624   7.784  1.00 36.02           O  
ATOM    188  OD2 ASP A  88      56.956  75.744   7.529  1.00 34.30           O  
ATOM    189  N   GLN A  89      53.193  74.190   6.332  1.00 26.20           N  
ATOM    190  CA  GLN A  89      52.808  73.909   4.952  1.00 27.58           C  
ATOM    191  C   GLN A  89      52.033  75.059   4.323  1.00 27.65           C  
ATOM    192  O   GLN A  89      52.200  75.355   3.140  1.00 27.87           O  
ATOM    193  CB  GLN A  89      51.943  72.648   4.889  1.00 29.06           C  
ATOM    194  CG  GLN A  89      52.658  71.350   5.218  1.00 33.11           C  
ATOM    195  CD  GLN A  89      51.689  70.188   5.372  1.00 35.27           C  
ATOM    196  OE1 GLN A  89      50.833  69.962   4.516  1.00 35.69           O  
ATOM    197  NE2 GLN A  89      51.822  69.447   6.467  1.00 37.83           N  
ATOM    198  N   LEU A  90      51.186  75.704   5.116  1.00 25.93           N  
ATOM    199  CA  LEU A  90      50.370  76.804   4.616  1.00 27.21           C  
ATOM    200  C   LEU A  90      50.980  78.186   4.837  1.00 27.11           C  
ATOM    201  O   LEU A  90      50.327  79.202   4.593  1.00 28.45           O  
ATOM    202  CB  LEU A  90      48.976  76.734   5.246  1.00 27.37           C  
ATOM    203  CG  LEU A  90      48.226  75.420   4.986  1.00 29.06           C  
ATOM    204  CD1 LEU A  90      46.908  75.417   5.744  1.00 28.37           C  
ATOM    205  CD2 LEU A  90      47.987  75.246   3.491  1.00 29.17           C  
ATOM    206  N   GLY A  91      52.226  78.222   5.299  1.00 26.98           N  
ATOM    207  CA  GLY A  91      52.903  79.489   5.522  1.00 26.50           C  
ATOM    208  C   GLY A  91      52.428  80.297   6.714  1.00 26.09           C  
ATOM    209  O   GLY A  91      52.468  81.527   6.693  1.00 27.58           O  
ATOM    210  N   ALA A  92      51.984  79.617   7.764  1.00 23.81           N  
ATOM    211  CA  ALA A  92      51.513  80.306   8.957  1.00 22.52           C  
ATOM    212  C   ALA A  92      52.402  79.998  10.154  1.00 20.82           C  
ATOM    213  O   ALA A  92      52.755  78.842  10.390  1.00 22.21           O  
ATOM    214  CB  ALA A  92      50.078  79.895   9.264  1.00 22.24           C  
ATOM    215  N   SER A  93      52.772  81.037  10.897  1.00 20.42           N  
ATOM    216  CA  SER A  93      53.586  80.869  12.092  1.00 20.28           C  
ATOM    217  C   SER A  93      52.617  80.600  13.230  1.00 19.66           C  
ATOM    218  O   SER A  93      51.447  80.980  13.156  1.00 19.88           O  
ATOM    219  CB  SER A  93      54.404  82.129  12.375  1.00 22.44           C  
ATOM    220  OG  SER A  93      55.455  82.249  11.434  1.00 24.32           O  
ATOM    221  N   VAL A  94      53.102  79.956  14.284  1.00 18.52           N  
ATOM    222  CA  VAL A  94      52.240  79.607  15.404  1.00 17.07           C  
ATOM    223  C   VAL A  94      52.778  79.973  16.780  1.00 17.89           C  
ATOM    224  O   VAL A  94      53.896  79.598  17.144  1.00 18.21           O  
ATOM    225  CB  VAL A  94      51.957  78.086  15.405  1.00 15.64           C  
ATOM    226  CG1 VAL A  94      50.924  77.740  16.469  1.00 16.78           C  
ATOM    227  CG2 VAL A  94      51.491  77.642  14.029  1.00 17.53           C  
ATOM    228  N   VAL A  95      51.973  80.709  17.542  1.00 16.87           N  
ATOM    229  CA  VAL A  95      52.333  81.076  18.903  1.00 16.93           C  
ATOM    230  C   VAL A  95      51.625  80.025  19.752  1.00 17.60           C  
ATOM    231  O   VAL A  95      50.423  79.807  19.599  1.00 17.14           O  
ATOM    232  CB  VAL A  95      51.803  82.478  19.283  1.00 18.62           C  
ATOM    233  CG1 VAL A  95      52.206  82.817  20.716  1.00 19.00           C  
ATOM    234  CG2 VAL A  95      52.347  83.522  18.314  1.00 20.29           C  
ATOM    235  N   VAL A  96      52.368  79.363  20.633  1.00 16.68           N  
ATOM    236  CA  VAL A  96      51.787  78.321  21.469  1.00 17.43           C  
ATOM    237  C   VAL A  96      51.836  78.675  22.947  1.00 19.33           C  
ATOM    238  O   VAL A  96      52.890  79.027  23.478  1.00 19.59           O  
ATOM    239  CB  VAL A  96      52.524  76.974  21.265  1.00 17.31           C  
ATOM    240  CG1 VAL A  96      51.834  75.869  22.069  1.00 16.45           C  
ATOM    241  CG2 VAL A  96      52.559  76.622  19.788  1.00 17.64           C  
ATOM    242  N   SER A  97      50.683  78.581  23.605  1.00 18.57           N  
ATOM    243  CA  SER A  97      50.582  78.868  25.029  1.00 19.83           C  
ATOM    244  C   SER A  97      50.070  77.611  25.723  1.00 21.21           C  
ATOM    245  O   SER A  97      49.019  77.077  25.356  1.00 19.82           O  
ATOM    246  CB  SER A  97      49.615  80.032  25.273  1.00 19.49           C  
ATOM    247  OG  SER A  97      49.469  80.292  26.661  1.00 22.44           O  
ATOM    248  N   MET A  98      50.816  77.129  26.711  1.00 20.50           N  
ATOM    249  CA  MET A  98      50.420  75.928  27.436  1.00 23.54           C  
ATOM    250  C   MET A  98      49.661  76.360  28.685  1.00 27.23           C  
ATOM    251  O   MET A  98      50.189  77.087  29.525  1.00 27.25           O  
ATOM    252  CB  MET A  98      51.660  75.105  27.802  1.00 23.91           C  
ATOM    253  CG  MET A  98      51.436  73.597  27.784  1.00 23.39           C  
ATOM    254  SD  MET A  98      52.992  72.655  27.828  1.00 22.03           S  
ATOM    255  CE  MET A  98      53.377  72.767  29.561  1.00 21.97           C  
ATOM    256  N   VAL A  99      48.417  75.910  28.799  1.00 29.46           N  
ATOM    257  CA  VAL A  99      47.566  76.282  29.923  1.00 34.49           C  
ATOM    258  C   VAL A  99      48.039  75.784  31.282  1.00 38.61           C  
ATOM    259  O   VAL A  99      48.381  74.614  31.448  1.00 39.19           O  
ATOM    260  CB  VAL A  99      46.118  75.807  29.687  1.00 33.56           C  
ATOM    261  CG1 VAL A  99      45.224  76.249  30.841  1.00 33.98           C  
ATOM    262  CG2 VAL A  99      45.604  76.377  28.376  1.00 33.87           C  
ATOM    263  N   GLU A 100      48.039  76.694  32.254  1.00 43.06           N  
ATOM    264  CA  GLU A 100      48.460  76.396  33.618  1.00 47.51           C  
ATOM    265  C   GLU A 100      47.683  75.224  34.212  1.00 49.08           C  
ATOM    266  O   GLU A 100      47.916  74.830  35.355  1.00 50.20           O  
ATOM    267  CB  GLU A 100      48.281  77.636  34.500  1.00 49.54           C  
ATOM    268  CG  GLU A 100      49.047  78.856  34.007  1.00 52.13           C  
ATOM    269  CD  GLU A 100      48.878  80.062  34.913  1.00 53.31           C  
ATOM    270  OE1 GLU A 100      47.730  80.525  35.085  1.00 54.90           O  
ATOM    271  OE2 GLU A 100      49.895  80.547  35.452  1.00 54.34           O  
ATOM    272  N   ARG A 101      46.755  74.680  33.429  1.00 51.10           N  
ATOM    273  CA  ARG A 101      45.945  73.541  33.844  1.00 51.91           C  
ATOM    274  C   ARG A 101      44.869  73.878  34.870  1.00 51.21           C  
ATOM    275  O   ARG A 101      45.015  74.805  35.667  1.00 51.25           O  
ATOM    276  CB  ARG A 101      46.842  72.432  34.408  1.00 53.40           C  
ATOM    277  CG  ARG A 101      47.879  71.908  33.432  1.00 56.54           C  
ATOM    278  CD  ARG A 101      48.756  70.820  34.051  1.00 58.41           C  
ATOM    279  NE  ARG A 101      47.993  69.651  34.486  1.00 59.92           N  
ATOM    280  CZ  ARG A 101      47.359  69.553  35.652  1.00 60.39           C  
ATOM    281  NH1 ARG A 101      47.391  70.557  36.519  1.00 61.09           N  
ATOM    282  NH2 ARG A 101      46.689  68.449  35.951  1.00 60.66           N  
ATOM    283  N   SER A 102      43.789  73.104  34.830  1.00 49.97           N  
ATOM    284  CA  SER A 102      42.664  73.258  35.743  1.00 48.39           C  
ATOM    285  C   SER A 102      42.019  74.638  35.760  1.00 46.59           C  
ATOM    286  O   SER A 102      42.575  75.590  36.312  1.00 47.06           O  
ATOM    287  CB  SER A 102      43.097  72.889  37.164  1.00 49.21           C  
ATOM    288  OG  SER A 102      43.541  71.545  37.232  1.00 50.92           O  
ATOM    289  N   GLY A 103      40.839  74.744  35.155  1.00 43.84           N  
ATOM    290  CA  GLY A 103      40.131  76.009  35.163  1.00 40.40           C  
ATOM    291  C   GLY A 103      39.950  76.761  33.860  1.00 37.03           C  
ATOM    292  O   GLY A 103      40.842  76.815  33.010  1.00 35.59           O  
ATOM    293  N   VAL A 104      38.773  77.361  33.722  1.00 33.50           N  
ATOM    294  CA  VAL A 104      38.434  78.148  32.549  1.00 30.14           C  
ATOM    295  C   VAL A 104      39.208  79.464  32.605  1.00 28.78           C  
ATOM    296  O   VAL A 104      39.526  80.052  31.574  1.00 27.00           O  
ATOM    297  CB  VAL A 104      36.916  78.441  32.506  1.00 30.20           C  
ATOM    298  CG1 VAL A 104      36.488  79.141  33.789  1.00 30.05           C  
ATOM    299  CG2 VAL A 104      36.578  79.291  31.292  1.00 28.96           C  
ATOM    300  N   GLU A 105      39.519  79.918  33.816  1.00 28.32           N  
ATOM    301  CA  GLU A 105      40.258  81.164  33.987  1.00 27.82           C  
ATOM    302  C   GLU A 105      41.676  81.039  33.438  1.00 26.09           C  
ATOM    303  O   GLU A 105      42.200  81.976  32.840  1.00 25.70           O  
ATOM    304  CB  GLU A 105      40.317  81.558  35.465  1.00 30.38           C  
ATOM    305  CG  GLU A 105      38.966  81.899  36.072  1.00 33.87           C  
ATOM    306  CD  GLU A 105      38.212  82.934  35.262  1.00 36.37           C  
ATOM    307  OE1 GLU A 105      38.826  83.951  34.879  1.00 37.86           O  
ATOM    308  OE2 GLU A 105      37.003  82.734  35.013  1.00 38.81           O  
ATOM    309  N   ALA A 106      42.290  79.880  33.648  1.00 25.15           N  
ATOM    310  CA  ALA A 106      43.643  79.637  33.164  1.00 23.61           C  
ATOM    311  C   ALA A 106      43.647  79.666  31.639  1.00 23.24           C  
ATOM    312  O   ALA A 106      44.583  80.174  31.020  1.00 21.49           O  
ATOM    313  CB  ALA A 106      44.144  78.287  33.665  1.00 24.61           C  
ATOM    314  N   CYS A 107      42.592  79.125  31.036  1.00 21.43           N  
ATOM    315  CA  CYS A 107      42.489  79.096  29.582  1.00 21.37           C  
ATOM    316  C   CYS A 107      42.223  80.500  29.051  1.00 21.84           C  
ATOM    317  O   CYS A 107      42.761  80.891  28.018  1.00 21.84           O  
ATOM    318  CB  CYS A 107      41.370  78.146  29.143  1.00 21.38           C  
ATOM    319  SG  CYS A 107      41.421  77.724  27.382  1.00 21.53           S  
ATOM    320  N   LYS A 108      41.392  81.261  29.757  1.00 21.55           N  
ATOM    321  CA  LYS A 108      41.096  82.625  29.336  1.00 22.06           C  
ATOM    322  C   LYS A 108      42.372  83.462  29.349  1.00 20.78           C  
ATOM    323  O   LYS A 108      42.588  84.298  28.473  1.00 21.54           O  
ATOM    324  CB  LYS A 108      40.055  83.255  30.261  1.00 23.66           C  
ATOM    325  CG  LYS A 108      38.665  82.670  30.099  1.00 26.57           C  
ATOM    326  CD  LYS A 108      37.700  83.277  31.106  1.00 29.40           C  
ATOM    327  CE  LYS A 108      36.286  82.798  30.860  1.00 32.84           C  
ATOM    328  NZ  LYS A 108      35.811  83.228  29.519  1.00 37.17           N  
ATOM    329  N   THR A 109      43.215  83.233  30.348  1.00 21.74           N  
ATOM    330  CA  THR A 109      44.470  83.966  30.458  1.00 22.29           C  
ATOM    331  C   THR A 109      45.359  83.639  29.262  1.00 21.33           C  
ATOM    332  O   THR A 109      45.978  84.527  28.672  1.00 21.16           O  
ATOM    333  CB  THR A 109      45.208  83.608  31.765  1.00 23.33           C  
ATOM    334  OG1 THR A 109      44.434  84.064  32.884  1.00 26.44           O  
ATOM    335  CG2 THR A 109      46.586  84.260  31.806  1.00 25.53           C  
ATOM    336  N   ALA A 110      45.415  82.359  28.904  1.00 20.75           N  
ATOM    337  CA  ALA A 110      46.222  81.930  27.768  1.00 18.95           C  
ATOM    338  C   ALA A 110      45.734  82.627  26.502  1.00 19.85           C  
ATOM    339  O   ALA A 110      46.532  83.135  25.713  1.00 18.51           O  
ATOM    340  CB  ALA A 110      46.139  80.415  27.606  1.00 19.77           C  
ATOM    341  N   VAL A 111      44.418  82.649  26.314  1.00 19.35           N  
ATOM    342  CA  VAL A 111      43.828  83.293  25.149  1.00 20.44           C  
ATOM    343  C   VAL A 111      44.173  84.779  25.137  1.00 20.86           C  
ATOM    344  O   VAL A 111      44.504  85.339  24.093  1.00 20.70           O  
ATOM    345  CB  VAL A 111      42.293  83.120  25.134  1.00 20.56           C  
ATOM    346  CG1 VAL A 111      41.674  84.009  24.068  1.00 20.94           C  
ATOM    347  CG2 VAL A 111      41.945  81.661  24.870  1.00 22.74           C  
ATOM    348  N   HIS A 112      44.098  85.416  26.301  1.00 22.41           N  
ATOM    349  CA  HIS A 112      44.422  86.834  26.405  1.00 24.22           C  
ATOM    350  C   HIS A 112      45.861  87.094  25.950  1.00 24.22           C  
ATOM    351  O   HIS A 112      46.111  88.001  25.156  1.00 23.16           O  
ATOM    352  CB  HIS A 112      44.235  87.313  27.848  1.00 27.72           C  
ATOM    353  CG  HIS A 112      44.625  88.742  28.067  1.00 33.48           C  
ATOM    354  ND1 HIS A 112      45.938  89.164  28.071  1.00 36.05           N  
ATOM    355  CD2 HIS A 112      43.874  89.849  28.277  1.00 34.60           C  
ATOM    356  CE1 HIS A 112      45.978  90.469  28.273  1.00 36.11           C  
ATOM    357  NE2 HIS A 112      44.740  90.909  28.401  1.00 36.72           N  
ATOM    358  N   ASN A 113      46.800  86.292  26.446  1.00 23.30           N  
ATOM    359  CA  ASN A 113      48.204  86.460  26.076  1.00 24.47           C  
ATOM    360  C   ASN A 113      48.428  86.230  24.585  1.00 23.19           C  
ATOM    361  O   ASN A 113      49.255  86.897  23.965  1.00 23.15           O  
ATOM    362  CB  ASN A 113      49.100  85.507  26.874  1.00 24.91           C  
ATOM    363  CG  ASN A 113      49.031  85.753  28.367  1.00 28.10           C  
ATOM    364  OD1 ASN A 113      48.863  86.887  28.815  1.00 29.65           O  
ATOM    365  ND2 ASN A 113      49.183  84.689  29.148  1.00 27.80           N  
ATOM    366  N   LEU A 114      47.698  85.278  24.009  1.00 22.80           N  
ATOM    367  CA  LEU A 114      47.829  84.981  22.587  1.00 22.07           C  
ATOM    368  C   LEU A 114      47.314  86.143  21.739  1.00 23.01           C  
ATOM    369  O   LEU A 114      47.916  86.499  20.724  1.00 22.87           O  
ATOM    370  CB  LEU A 114      47.068  83.696  22.242  1.00 21.47           C  
ATOM    371  CG  LEU A 114      47.690  82.403  22.781  1.00 19.83           C  
ATOM    372  CD1 LEU A 114      46.720  81.248  22.606  1.00 20.34           C  
ATOM    373  CD2 LEU A 114      48.998  82.120  22.048  1.00 20.59           C  
ATOM    374  N   LEU A 115      46.201  86.733  22.162  1.00 23.15           N  
ATOM    375  CA  LEU A 115      45.623  87.860  21.441  1.00 24.46           C  
ATOM    376  C   LEU A 115      46.567  89.057  21.492  1.00 25.26           C  
ATOM    377  O   LEU A 115      46.598  89.876  20.572  1.00 25.41           O  
ATOM    378  CB  LEU A 115      44.268  88.243  22.045  1.00 24.82           C  
ATOM    379  CG  LEU A 115      43.109  87.273  21.807  1.00 25.32           C  
ATOM    380  CD1 LEU A 115      41.889  87.736  22.590  1.00 26.76           C  
ATOM    381  CD2 LEU A 115      42.797  87.198  20.315  1.00 24.28           C  
ATOM    382  N   ALA A 116      47.338  89.153  22.569  1.00 26.52           N  
ATOM    383  CA  ALA A 116      48.286  90.250  22.730  1.00 28.15           C  
ATOM    384  C   ALA A 116      49.433  90.120  21.729  1.00 28.84           C  
ATOM    385  O   ALA A 116      50.154  91.086  21.464  1.00 28.41           O  
ATOM    386  CB  ALA A 116      48.829  90.268  24.152  1.00 29.04           C  
ATOM    387  N   GLN A 117      49.603  88.921  21.180  1.00 28.64           N  
ATOM    388  CA  GLN A 117      50.658  88.681  20.201  1.00 28.98           C  
ATOM    389  C   GLN A 117      50.134  88.904  18.784  1.00 29.25           C  
ATOM    390  O   GLN A 117      50.813  88.609  17.803  1.00 29.73           O  
ATOM    391  CB  GLN A 117      51.208  87.259  20.341  1.00 29.08           C  
ATOM    392  CG  GLN A 117      51.938  87.001  21.652  1.00 29.61           C  
ATOM    393  CD  GLN A 117      53.046  88.010  21.910  1.00 30.12           C  
ATOM    394  OE1 GLN A 117      53.821  88.338  21.013  1.00 30.50           O  
ATOM    395  NE2 GLN A 117      53.128  88.498  23.142  1.00 30.96           N  
ATOM    396  N   ARG A 118      48.914  89.425  18.696  1.00 30.35           N  
ATOM    397  CA  ARG A 118      48.269  89.725  17.421  1.00 31.03           C  
ATOM    398  C   ARG A 118      47.971  88.529  16.519  1.00 29.91           C  
ATOM    399  O   ARG A 118      48.126  88.612  15.301  1.00 28.92           O  
ATOM    400  CB  ARG A 118      49.099  90.744  16.630  1.00 34.33           C  
ATOM    401  CG  ARG A 118      49.355  92.058  17.354  1.00 38.53           C  
ATOM    402  CD  ARG A 118      49.755  93.143  16.364  1.00 42.56           C  
ATOM    403  NE  ARG A 118      50.815  92.695  15.462  1.00 45.80           N  
ATOM    404  CZ  ARG A 118      51.213  93.365  14.385  1.00 47.69           C  
ATOM    405  NH1 ARG A 118      50.640  94.519  14.069  1.00 49.10           N  
ATOM    406  NH2 ARG A 118      52.182  92.879  13.620  1.00 48.20           N  
ATOM    407  N   VAL A 119      47.539  87.418  17.105  1.00 28.64           N  
ATOM    408  CA  VAL A 119      47.204  86.246  16.305  1.00 27.54           C  
ATOM    409  C   VAL A 119      45.874  86.539  15.606  1.00 26.72           C  
ATOM    410  O   VAL A 119      45.042  87.275  16.141  1.00 27.09           O  
ATOM    411  CB  VAL A 119      47.059  84.987  17.186  1.00 26.11           C  
ATOM    412  CG1 VAL A 119      48.369  84.704  17.904  1.00 26.02           C  
ATOM    413  CG2 VAL A 119      45.933  85.175  18.192  1.00 25.69           C  
ATOM    414  N   SER A 120      45.678  85.977  14.414  1.00 25.41           N  
ATOM    415  CA  SER A 120      44.447  86.204  13.658  1.00 25.61           C  
ATOM    416  C   SER A 120      43.510  85.001  13.700  1.00 23.41           C  
ATOM    417  O   SER A 120      42.479  84.975  13.024  1.00 23.38           O  
ATOM    418  CB  SER A 120      44.776  86.549  12.201  1.00 27.41           C  
ATOM    419  OG  SER A 120      45.448  85.485  11.551  1.00 30.17           O  
ATOM    420  N   GLY A 121      43.877  84.008  14.501  1.00 21.14           N  
ATOM    421  CA  GLY A 121      43.066  82.813  14.633  1.00 19.72           C  
ATOM    422  C   GLY A 121      43.528  82.034  15.845  1.00 18.86           C  
ATOM    423  O   GLY A 121      44.715  82.036  16.169  1.00 18.52           O  
ATOM    424  N   LEU A 122      42.595  81.367  16.517  1.00 16.45           N  
ATOM    425  CA  LEU A 122      42.925  80.598  17.708  1.00 16.45           C  
ATOM    426  C   LEU A 122      42.430  79.159  17.678  1.00 16.14           C  
ATOM    427  O   LEU A 122      41.294  78.891  17.297  1.00 15.89           O  
ATOM    428  CB  LEU A 122      42.332  81.276  18.945  1.00 18.58           C  
ATOM    429  CG  LEU A 122      42.852  82.663  19.313  1.00 21.14           C  
ATOM    430  CD1 LEU A 122      41.889  83.331  20.285  1.00 23.11           C  
ATOM    431  CD2 LEU A 122      44.237  82.538  19.921  1.00 23.59           C  
ATOM    432  N   ILE A 123      43.300  78.234  18.072  1.00 13.71           N  
ATOM    433  CA  ILE A 123      42.915  76.833  18.174  1.00 13.48           C  
ATOM    434  C   ILE A 123      42.997  76.522  19.668  1.00 15.22           C  
ATOM    435  O   ILE A 123      44.052  76.672  20.288  1.00 16.20           O  
ATOM    436  CB  ILE A 123      43.868  75.906  17.386  1.00 13.64           C  
ATOM    437  CG1 ILE A 123      43.762  76.218  15.890  1.00 15.81           C  
ATOM    438  CG2 ILE A 123      43.500  74.452  17.644  1.00 15.06           C  
ATOM    439  CD1 ILE A 123      44.682  75.389  15.006  1.00 15.35           C  
ATOM    440  N   ILE A 124      41.870  76.125  20.251  1.00 13.66           N  
ATOM    441  CA  ILE A 124      41.809  75.815  21.675  1.00 14.60           C  
ATOM    442  C   ILE A 124      41.855  74.301  21.874  1.00 14.41           C  
ATOM    443  O   ILE A 124      40.846  73.604  21.722  1.00 14.78           O  
ATOM    444  CB  ILE A 124      40.511  76.375  22.307  1.00 15.03           C  
ATOM    445  CG1 ILE A 124      40.327  77.849  21.922  1.00 17.42           C  
ATOM    446  CG2 ILE A 124      40.570  76.237  23.823  1.00 16.15           C  
ATOM    447  CD1 ILE A 124      41.429  78.772  22.413  1.00 19.56           C  
ATOM    448  N   ASN A 125      43.041  73.803  22.210  1.00 13.94           N  
ATOM    449  CA  ASN A 125      43.269  72.377  22.425  1.00 14.82           C  
ATOM    450  C   ASN A 125      43.340  72.124  23.932  1.00 16.00           C  
ATOM    451  O   ASN A 125      44.345  71.638  24.450  1.00 14.65           O  
ATOM    452  CB  ASN A 125      44.581  71.980  21.740  1.00 16.83           C  
ATOM    453  CG  ASN A 125      44.828  70.490  21.768  1.00 19.61           C  
ATOM    454  OD1 ASN A 125      43.932  69.699  21.475  1.00 21.22           O  
ATOM    455  ND2 ASN A 125      46.055  70.098  22.107  1.00 20.56           N  
ATOM    456  N   TYR A 126      42.249  72.447  24.621  1.00 16.14           N  
ATOM    457  CA  TYR A 126      42.162  72.320  26.071  1.00 16.45           C  
ATOM    458  C   TYR A 126      40.737  71.878  26.429  1.00 16.25           C  
ATOM    459  O   TYR A 126      39.773  72.398  25.877  1.00 16.83           O  
ATOM    460  CB  TYR A 126      42.471  73.686  26.688  1.00 17.58           C  
ATOM    461  CG  TYR A 126      42.550  73.700  28.192  1.00 19.05           C  
ATOM    462  CD1 TYR A 126      43.690  73.248  28.855  1.00 20.55           C  
ATOM    463  CD2 TYR A 126      41.481  74.161  28.957  1.00 20.34           C  
ATOM    464  CE1 TYR A 126      43.762  73.254  30.247  1.00 21.33           C  
ATOM    465  CE2 TYR A 126      41.540  74.171  30.346  1.00 22.70           C  
ATOM    466  CZ  TYR A 126      42.682  73.717  30.985  1.00 23.49           C  
ATOM    467  OH  TYR A 126      42.739  73.726  32.359  1.00 25.63           O  
ATOM    468  N   PRO A 127      40.587  70.922  27.363  1.00 15.94           N  
ATOM    469  CA  PRO A 127      39.254  70.437  27.749  1.00 15.66           C  
ATOM    470  C   PRO A 127      38.374  71.471  28.445  1.00 15.27           C  
ATOM    471  O   PRO A 127      38.732  72.002  29.493  1.00 16.64           O  
ATOM    472  CB  PRO A 127      39.573  69.239  28.638  1.00 16.03           C  
ATOM    473  CG  PRO A 127      40.835  69.670  29.316  1.00 17.39           C  
ATOM    474  CD  PRO A 127      41.633  70.281  28.181  1.00 17.01           C  
ATOM    475  N   LEU A 128      37.210  71.743  27.861  1.00 14.30           N  
ATOM    476  CA  LEU A 128      36.290  72.732  28.421  1.00 15.18           C  
ATOM    477  C   LEU A 128      34.846  72.249  28.364  1.00 15.46           C  
ATOM    478  O   LEU A 128      34.418  71.712  27.346  1.00 15.74           O  
ATOM    479  CB  LEU A 128      36.399  74.040  27.633  1.00 14.42           C  
ATOM    480  CG  LEU A 128      37.720  74.801  27.735  1.00 15.61           C  
ATOM    481  CD1 LEU A 128      37.846  75.777  26.578  1.00 15.24           C  
ATOM    482  CD2 LEU A 128      37.784  75.526  29.078  1.00 16.07           C  
ATOM    483  N   ASP A 129      34.093  72.436  29.444  1.00 17.00           N  
ATOM    484  CA  ASP A 129      32.699  72.016  29.414  1.00 18.19           C  
ATOM    485  C   ASP A 129      31.904  73.053  28.622  1.00 19.73           C  
ATOM    486  O   ASP A 129      32.467  74.047  28.163  1.00 19.19           O  
ATOM    487  CB  ASP A 129      32.128  71.813  30.831  1.00 19.65           C  
ATOM    488  CG  ASP A 129      31.940  73.108  31.607  1.00 22.18           C  
ATOM    489  OD1 ASP A 129      32.103  74.207  31.044  1.00 22.51           O  
ATOM    490  OD2 ASP A 129      31.602  73.012  32.808  1.00 23.39           O  
ATOM    491  N   ASP A 130      30.608  72.820  28.451  1.00 19.47           N  
ATOM    492  CA  ASP A 130      29.773  73.724  27.666  1.00 22.54           C  
ATOM    493  C   ASP A 130      29.895  75.202  28.022  1.00 22.09           C  
ATOM    494  O   ASP A 130      30.282  76.018  27.183  1.00 22.12           O  
ATOM    495  CB  ASP A 130      28.307  73.285  27.754  1.00 24.19           C  
ATOM    496  CG  ASP A 130      27.415  74.022  26.770  1.00 28.86           C  
ATOM    497  OD1 ASP A 130      26.850  75.077  27.135  1.00 31.02           O  
ATOM    498  OD2 ASP A 130      27.285  73.550  25.621  1.00 31.27           O  
ATOM    499  N   GLN A 131      29.571  75.547  29.263  1.00 22.06           N  
ATOM    500  CA  GLN A 131      29.634  76.935  29.703  1.00 23.03           C  
ATOM    501  C   GLN A 131      31.024  77.559  29.641  1.00 21.59           C  
ATOM    502  O   GLN A 131      31.165  78.719  29.251  1.00 20.89           O  
ATOM    503  CB  GLN A 131      29.063  77.059  31.117  1.00 26.50           C  
ATOM    504  CG  GLN A 131      27.551  77.239  31.146  1.00 32.47           C  
ATOM    505  CD  GLN A 131      26.819  76.255  30.254  1.00 35.19           C  
ATOM    506  OE1 GLN A 131      26.817  75.050  30.505  1.00 38.90           O  
ATOM    507  NE2 GLN A 131      26.191  76.767  29.200  1.00 36.33           N  
ATOM    508  N   ASP A 132      32.049  76.800  30.016  1.00 21.04           N  
ATOM    509  CA  ASP A 132      33.408  77.327  29.981  1.00 20.21           C  
ATOM    510  C   ASP A 132      33.895  77.560  28.552  1.00 19.56           C  
ATOM    511  O   ASP A 132      34.612  78.528  28.289  1.00 17.96           O  
ATOM    512  CB  ASP A 132      34.376  76.393  30.718  1.00 21.03           C  
ATOM    513  CG  ASP A 132      34.153  76.388  32.223  1.00 23.10           C  
ATOM    514  OD1 ASP A 132      33.538  77.348  32.739  1.00 24.04           O  
ATOM    515  OD2 ASP A 132      34.607  75.435  32.892  1.00 21.59           O  
ATOM    516  N   ALA A 133      33.512  76.681  27.629  1.00 18.16           N  
ATOM    517  CA  ALA A 133      33.927  76.841  26.237  1.00 18.11           C  
ATOM    518  C   ALA A 133      33.286  78.104  25.668  1.00 18.54           C  
ATOM    519  O   ALA A 133      33.924  78.866  24.938  1.00 18.35           O  
ATOM    520  CB  ALA A 133      33.518  75.617  25.413  1.00 18.65           C  
ATOM    521  N   ILE A 134      32.020  78.325  26.005  1.00 18.87           N  
ATOM    522  CA  ILE A 134      31.320  79.515  25.533  1.00 19.54           C  
ATOM    523  C   ILE A 134      32.013  80.752  26.102  1.00 19.53           C  
ATOM    524  O   ILE A 134      32.176  81.759  25.413  1.00 20.91           O  
ATOM    525  CB  ILE A 134      29.838  79.491  25.965  1.00 20.21           C  
ATOM    526  CG1 ILE A 134      29.094  78.410  25.171  1.00 20.66           C  
ATOM    527  CG2 ILE A 134      29.199  80.863  25.740  1.00 20.57           C  
ATOM    528  CD1 ILE A 134      27.664  78.175  25.633  1.00 24.43           C  
ATOM    529  N   ALA A 135      32.439  80.659  27.358  1.00 20.53           N  
ATOM    530  CA  ALA A 135      33.123  81.765  28.020  1.00 20.82           C  
ATOM    531  C   ALA A 135      34.461  82.056  27.340  1.00 20.83           C  
ATOM    532  O   ALA A 135      34.827  83.215  27.132  1.00 20.25           O  
ATOM    533  CB  ALA A 135      33.338  81.439  29.491  1.00 20.06           C  
ATOM    534  N   VAL A 136      35.197  81.004  26.998  1.00 19.17           N  
ATOM    535  CA  VAL A 136      36.480  81.188  26.329  1.00 18.84           C  
ATOM    536  C   VAL A 136      36.272  81.803  24.947  1.00 19.16           C  
ATOM    537  O   VAL A 136      37.025  82.682  24.530  1.00 19.04           O  
ATOM    538  CB  VAL A 136      37.231  79.846  26.189  1.00 17.99           C  
ATOM    539  CG1 VAL A 136      38.466  80.021  25.305  1.00 18.15           C  
ATOM    540  CG2 VAL A 136      37.643  79.348  27.565  1.00 17.83           C  
ATOM    541  N   GLU A 137      35.242  81.354  24.237  1.00 17.85           N  
ATOM    542  CA  GLU A 137      34.968  81.892  22.911  1.00 20.64           C  
ATOM    543  C   GLU A 137      34.693  83.393  23.002  1.00 21.01           C  
ATOM    544  O   GLU A 137      35.133  84.170  22.154  1.00 21.24           O  
ATOM    545  CB  GLU A 137      33.762  81.191  22.281  1.00 22.05           C  
ATOM    546  CG  GLU A 137      33.452  81.664  20.869  1.00 26.58           C  
ATOM    547  CD  GLU A 137      32.125  81.143  20.352  1.00 30.77           C  
ATOM    548  OE1 GLU A 137      31.089  81.416  20.993  1.00 33.03           O  
ATOM    549  OE2 GLU A 137      32.117  80.462  19.304  1.00 34.37           O  
ATOM    550  N   ALA A 138      33.964  83.797  24.037  1.00 21.98           N  
ATOM    551  CA  ALA A 138      33.639  85.206  24.221  1.00 23.94           C  
ATOM    552  C   ALA A 138      34.914  86.019  24.439  1.00 24.85           C  
ATOM    553  O   ALA A 138      35.011  87.168  24.012  1.00 27.10           O  
ATOM    554  CB  ALA A 138      32.694  85.374  25.412  1.00 22.52           C  
ATOM    555  N   ALA A 139      35.893  85.410  25.096  1.00 25.61           N  
ATOM    556  CA  ALA A 139      37.155  86.082  25.384  1.00 27.79           C  
ATOM    557  C   ALA A 139      38.071  86.228  24.170  1.00 29.23           C  
ATOM    558  O   ALA A 139      39.058  86.958  24.222  1.00 29.22           O  
ATOM    559  CB  ALA A 139      37.886  85.341  26.495  1.00 27.78           C  
ATOM    560  N   CYS A 140      37.747  85.547  23.077  1.00 30.14           N  
ATOM    561  CA  CYS A 140      38.582  85.617  21.881  1.00 31.85           C  
ATOM    562  C   CYS A 140      38.423  86.914  21.084  1.00 34.20           C  
ATOM    563  O   CYS A 140      39.106  87.124  20.081  1.00 34.11           O  
ATOM    564  CB  CYS A 140      38.310  84.404  20.993  1.00 31.32           C  
ATOM    565  SG  CYS A 140      38.800  82.842  21.763  1.00 29.59           S  
ATOM    566  N   THR A 141      37.525  87.781  21.539  1.00 36.51           N  
ATOM    567  CA  THR A 141      37.287  89.071  20.894  1.00 38.16           C  
ATOM    568  C   THR A 141      37.105  89.014  19.375  1.00 39.02           C  
ATOM    569  O   THR A 141      37.897  89.584  18.624  1.00 39.19           O  
ATOM    570  CB  THR A 141      38.434  90.059  21.204  1.00 39.06           C  
ATOM    571  OG1 THR A 141      39.632  89.631  20.544  1.00 41.17           O  
ATOM    572  CG2 THR A 141      38.691  90.120  22.701  1.00 38.54           C  
ATOM    573  N   ASN A 142      36.057  88.327  18.930  1.00 38.93           N  
ATOM    574  CA  ASN A 142      35.747  88.209  17.507  1.00 38.90           C  
ATOM    575  C   ASN A 142      36.791  87.507  16.639  1.00 37.18           C  
ATOM    576  O   ASN A 142      36.548  87.255  15.458  1.00 37.80           O  
ATOM    577  CB  ASN A 142      35.441  89.592  16.925  1.00 41.29           C  
ATOM    578  CG  ASN A 142      34.138  90.167  17.448  1.00 44.07           C  
ATOM    579  OD1 ASN A 142      33.769  91.297  17.126  1.00 46.12           O  
ATOM    580  ND2 ASN A 142      33.428  89.385  18.256  1.00 43.95           N  
ATOM    581  N   VAL A 143      37.955  87.204  17.204  1.00 33.64           N  
ATOM    582  CA  VAL A 143      38.985  86.496  16.450  1.00 30.30           C  
ATOM    583  C   VAL A 143      38.465  85.064  16.317  1.00 26.79           C  
ATOM    584  O   VAL A 143      38.027  84.475  17.299  1.00 27.20           O  
ATOM    585  CB  VAL A 143      40.330  86.476  17.212  1.00 29.96           C  
ATOM    586  CG1 VAL A 143      41.326  85.589  16.489  1.00 30.24           C  
ATOM    587  CG2 VAL A 143      40.877  87.889  17.342  1.00 31.07           C  
ATOM    588  N   PRO A 144      38.503  84.486  15.106  1.00 25.06           N  
ATOM    589  CA  PRO A 144      38.005  83.114  14.963  1.00 24.09           C  
ATOM    590  C   PRO A 144      38.664  82.137  15.931  1.00 21.50           C  
ATOM    591  O   PRO A 144      39.882  82.153  16.109  1.00 20.91           O  
ATOM    592  CB  PRO A 144      38.294  82.789  13.495  1.00 25.45           C  
ATOM    593  CG  PRO A 144      39.469  83.664  13.173  1.00 27.73           C  
ATOM    594  CD  PRO A 144      39.109  84.958  13.849  1.00 25.69           C  
ATOM    595  N   ALA A 145      37.848  81.298  16.564  1.00 20.46           N  
ATOM    596  CA  ALA A 145      38.345  80.316  17.522  1.00 18.55           C  
ATOM    597  C   ALA A 145      37.774  78.934  17.231  1.00 18.73           C  
ATOM    598  O   ALA A 145      36.568  78.775  17.034  1.00 18.66           O  
ATOM    599  CB  ALA A 145      37.981  80.739  18.939  1.00 20.31           C  
ATOM    600  N   LEU A 146      38.649  77.934  17.224  1.00 16.71           N  
ATOM    601  CA  LEU A 146      38.254  76.559  16.952  1.00 15.06           C  
ATOM    602  C   LEU A 146      38.642  75.685  18.144  1.00 14.50           C  
ATOM    603  O   LEU A 146      39.798  75.680  18.562  1.00 15.09           O  
ATOM    604  CB  LEU A 146      38.957  76.076  15.682  1.00 15.35           C  
ATOM    605  CG  LEU A 146      38.641  74.681  15.151  1.00 15.22           C  
ATOM    606  CD1 LEU A 146      37.177  74.609  14.702  1.00 15.53           C  
ATOM    607  CD2 LEU A 146      39.562  74.382  13.982  1.00 16.81           C  
ATOM    608  N   PHE A 147      37.674  74.950  18.686  1.00 13.60           N  
ATOM    609  CA  PHE A 147      37.910  74.093  19.850  1.00 13.71           C  
ATOM    610  C   PHE A 147      38.083  72.624  19.478  1.00 14.00           C  
ATOM    611  O   PHE A 147      37.318  72.085  18.678  1.00 13.70           O  
ATOM    612  CB  PHE A 147      36.748  74.232  20.843  1.00 13.72           C  
ATOM    613  CG  PHE A 147      36.592  75.619  21.411  1.00 14.04           C  
ATOM    614  CD1 PHE A 147      36.091  76.658  20.628  1.00 14.08           C  
ATOM    615  CD2 PHE A 147      36.945  75.884  22.728  1.00 13.67           C  
ATOM    616  CE1 PHE A 147      35.942  77.945  21.156  1.00 14.59           C  
ATOM    617  CE2 PHE A 147      36.803  77.168  23.268  1.00 14.76           C  
ATOM    618  CZ  PHE A 147      36.299  78.201  22.477  1.00 14.31           C  
ATOM    619  N   LEU A 148      39.078  71.976  20.079  1.00 12.95           N  
ATOM    620  CA  LEU A 148      39.355  70.571  19.790  1.00 12.66           C  
ATOM    621  C   LEU A 148      39.097  69.608  20.952  1.00 13.60           C  
ATOM    622  O   LEU A 148      39.260  68.395  20.800  1.00 14.99           O  
ATOM    623  CB  LEU A 148      40.808  70.419  19.325  1.00 13.11           C  
ATOM    624  CG  LEU A 148      41.262  71.334  18.185  1.00 13.27           C  
ATOM    625  CD1 LEU A 148      42.707  70.999  17.796  1.00 14.38           C  
ATOM    626  CD2 LEU A 148      40.329  71.167  16.986  1.00 14.26           C  
ATOM    627  N   ASP A 149      38.697  70.130  22.109  1.00 14.05           N  
ATOM    628  CA  ASP A 149      38.443  69.270  23.267  1.00 15.62           C  
ATOM    629  C   ASP A 149      37.208  69.754  24.013  1.00 16.15           C  
ATOM    630  O   ASP A 149      37.300  70.324  25.103  1.00 15.65           O  
ATOM    631  CB  ASP A 149      39.649  69.277  24.210  1.00 16.70           C  
ATOM    632  CG  ASP A 149      39.648  68.099  25.172  1.00 19.50           C  
ATOM    633  OD1 ASP A 149      38.615  67.399  25.276  1.00 20.42           O  
ATOM    634  OD2 ASP A 149      40.686  67.877  25.829  1.00 21.11           O  
ATOM    635  N   VAL A 150      36.055  69.516  23.405  1.00 14.88           N  
ATOM    636  CA  VAL A 150      34.772  69.927  23.963  1.00 14.80           C  
ATOM    637  C   VAL A 150      33.721  68.894  23.576  1.00 15.62           C  
ATOM    638  O   VAL A 150      34.023  67.908  22.900  1.00 16.60           O  
ATOM    639  CB  VAL A 150      34.325  71.285  23.371  1.00 14.48           C  
ATOM    640  CG1 VAL A 150      35.241  72.392  23.842  1.00 15.15           C  
ATOM    641  CG2 VAL A 150      34.336  71.215  21.837  1.00 15.38           C  
ATOM    642  N   SER A 151      32.491  69.119  24.022  1.00 16.18           N  
ATOM    643  CA  SER A 151      31.387  68.243  23.661  1.00 16.86           C  
ATOM    644  C   SER A 151      30.943  68.737  22.293  1.00 17.49           C  
ATOM    645  O   SER A 151      31.081  69.920  21.992  1.00 17.18           O  
ATOM    646  CB  SER A 151      30.229  68.402  24.646  1.00 17.95           C  
ATOM    647  OG  SER A 151      29.044  67.846  24.108  1.00 21.33           O  
ATOM    648  N   ASP A 152      30.407  67.849  21.464  1.00 19.04           N  
ATOM    649  CA  ASP A 152      29.958  68.267  20.144  1.00 20.49           C  
ATOM    650  C   ASP A 152      28.611  68.986  20.212  1.00 21.93           C  
ATOM    651  O   ASP A 152      28.082  69.430  19.193  1.00 23.06           O  
ATOM    652  CB  ASP A 152      29.886  67.063  19.197  1.00 21.05           C  
ATOM    653  CG  ASP A 152      29.108  65.898  19.780  1.00 24.04           C  
ATOM    654  OD1 ASP A 152      29.417  65.476  20.915  1.00 24.69           O  
ATOM    655  OD2 ASP A 152      28.195  65.392  19.091  1.00 25.11           O  
ATOM    656  N   GLN A 153      28.071  69.110  21.422  1.00 21.13           N  
ATOM    657  CA  GLN A 153      26.791  69.780  21.620  1.00 23.39           C  
ATOM    658  C   GLN A 153      26.966  71.266  21.926  1.00 22.89           C  
ATOM    659  O   GLN A 153      26.018  72.042  21.816  1.00 23.09           O  
ATOM    660  CB  GLN A 153      26.016  69.114  22.760  1.00 25.62           C  
ATOM    661  CG  GLN A 153      25.605  67.677  22.478  1.00 30.21           C  
ATOM    662  CD  GLN A 153      24.748  67.554  21.232  1.00 33.16           C  
ATOM    663  OE1 GLN A 153      23.744  68.251  21.087  1.00 35.53           O  
ATOM    664  NE2 GLN A 153      25.138  66.662  20.330  1.00 35.62           N  
ATOM    665  N   THR A 154      28.175  71.663  22.310  1.00 21.36           N  
ATOM    666  CA  THR A 154      28.437  73.063  22.627  1.00 20.38           C  
ATOM    667  C   THR A 154      28.406  73.898  21.347  1.00 20.56           C  
ATOM    668  O   THR A 154      29.071  73.571  20.365  1.00 19.57           O  
ATOM    669  CB  THR A 154      29.798  73.219  23.324  1.00 20.84           C  
ATOM    670  OG1 THR A 154      29.860  72.314  24.434  1.00 22.83           O  
ATOM    671  CG2 THR A 154      29.980  74.645  23.835  1.00 19.90           C  
ATOM    672  N   PRO A 155      27.626  74.993  21.348  1.00 20.56           N  
ATOM    673  CA  PRO A 155      27.463  75.905  20.211  1.00 20.41           C  
ATOM    674  C   PRO A 155      28.645  76.803  19.862  1.00 21.63           C  
ATOM    675  O   PRO A 155      28.536  78.031  19.896  1.00 21.91           O  
ATOM    676  CB  PRO A 155      26.228  76.709  20.600  1.00 21.28           C  
ATOM    677  CG  PRO A 155      26.404  76.845  22.074  1.00 21.45           C  
ATOM    678  CD  PRO A 155      26.803  75.439  22.488  1.00 21.37           C  
ATOM    679  N   ILE A 156      29.772  76.183  19.528  1.00 19.13           N  
ATOM    680  CA  ILE A 156      30.975  76.906  19.132  1.00 19.03           C  
ATOM    681  C   ILE A 156      31.579  76.142  17.960  1.00 17.12           C  
ATOM    682  O   ILE A 156      31.074  75.082  17.595  1.00 17.23           O  
ATOM    683  CB  ILE A 156      32.004  76.989  20.298  1.00 19.60           C  
ATOM    684  CG1 ILE A 156      32.202  75.616  20.953  1.00 23.47           C  
ATOM    685  CG2 ILE A 156      31.512  77.974  21.348  1.00 20.44           C  
ATOM    686  CD1 ILE A 156      32.939  74.607  20.112  1.00 26.38           C  
ATOM    687  N   ASN A 157      32.638  76.676  17.359  1.00 16.53           N  
ATOM    688  CA  ASN A 157      33.285  75.987  16.244  1.00 16.30           C  
ATOM    689  C   ASN A 157      34.191  74.927  16.844  1.00 15.59           C  
ATOM    690  O   ASN A 157      35.007  75.227  17.715  1.00 14.43           O  
ATOM    691  CB  ASN A 157      34.115  76.965  15.410  1.00 18.98           C  
ATOM    692  CG  ASN A 157      33.262  78.020  14.739  1.00 23.47           C  
ATOM    693  OD1 ASN A 157      32.204  77.717  14.191  1.00 27.52           O  
ATOM    694  ND2 ASN A 157      33.723  79.264  14.768  1.00 23.35           N  
ATOM    695  N   SER A 158      34.056  73.688  16.383  1.00 15.70           N  
ATOM    696  CA  SER A 158      34.866  72.616  16.939  1.00 15.19           C  
ATOM    697  C   SER A 158      35.037  71.415  16.026  1.00 15.06           C  
ATOM    698  O   SER A 158      34.318  71.243  15.046  1.00 14.09           O  
ATOM    699  CB  SER A 158      34.237  72.130  18.248  1.00 14.46           C  
ATOM    700  OG  SER A 158      32.944  71.585  18.004  1.00 15.85           O  
ATOM    701  N   ILE A 159      36.027  70.598  16.365  1.00 13.97           N  
ATOM    702  CA  ILE A 159      36.294  69.357  15.658  1.00 13.73           C  
ATOM    703  C   ILE A 159      36.698  68.387  16.749  1.00 14.16           C  
ATOM    704  O   ILE A 159      37.681  68.622  17.456  1.00 13.89           O  
ATOM    705  CB  ILE A 159      37.477  69.451  14.672  1.00 12.93           C  
ATOM    706  CG1 ILE A 159      37.266  70.604  13.690  1.00 14.56           C  
ATOM    707  CG2 ILE A 159      37.605  68.122  13.920  1.00 12.37           C  
ATOM    708  CD1 ILE A 159      38.456  70.843  12.766  1.00 15.57           C  
ATOM    709  N   ILE A 160      35.931  67.317  16.922  1.00 13.03           N  
ATOM    710  CA  ILE A 160      36.281  66.328  17.928  1.00 13.03           C  
ATOM    711  C   ILE A 160      36.036  64.940  17.368  1.00 13.35           C  
ATOM    712  O   ILE A 160      35.376  64.783  16.339  1.00 14.53           O  
ATOM    713  CB  ILE A 160      35.463  66.486  19.239  1.00 15.28           C  
ATOM    714  CG1 ILE A 160      33.998  66.117  19.000  1.00 15.11           C  
ATOM    715  CG2 ILE A 160      35.596  67.911  19.771  1.00 14.95           C  
ATOM    716  CD1 ILE A 160      33.187  66.034  20.282  1.00 19.71           C  
ATOM    717  N   PHE A 161      36.590  63.937  18.035  1.00 14.44           N  
ATOM    718  CA  PHE A 161      36.406  62.556  17.616  1.00 13.41           C  
ATOM    719  C   PHE A 161      35.063  62.061  18.136  1.00 14.20           C  
ATOM    720  O   PHE A 161      34.564  62.545  19.153  1.00 14.39           O  
ATOM    721  CB  PHE A 161      37.531  61.687  18.170  1.00 13.85           C  
ATOM    722  CG  PHE A 161      38.852  61.931  17.514  1.00 16.65           C  
ATOM    723  CD1 PHE A 161      39.060  61.555  16.192  1.00 16.85           C  
ATOM    724  CD2 PHE A 161      39.884  62.555  18.207  1.00 17.62           C  
ATOM    725  CE1 PHE A 161      40.286  61.796  15.561  1.00 18.30           C  
ATOM    726  CE2 PHE A 161      41.112  62.800  17.589  1.00 19.64           C  
ATOM    727  CZ  PHE A 161      41.309  62.419  16.262  1.00 17.78           C  
ATOM    728  N   SER A 162      34.475  61.100  17.436  1.00 14.46           N  
ATOM    729  CA  SER A 162      33.191  60.554  17.854  1.00 14.92           C  
ATOM    730  C   SER A 162      33.321  59.666  19.091  1.00 15.16           C  
ATOM    731  O   SER A 162      33.738  58.511  18.998  1.00 16.39           O  
ATOM    732  CB  SER A 162      32.561  59.748  16.719  1.00 16.18           C  
ATOM    733  OG  SER A 162      31.334  59.173  17.144  1.00 17.78           O  
ATOM    734  N   HIS A 163      32.966  60.212  20.249  1.00 13.94           N  
ATOM    735  CA  HIS A 163      33.018  59.452  21.492  1.00 14.12           C  
ATOM    736  C   HIS A 163      31.939  58.369  21.503  1.00 15.15           C  
ATOM    737  O   HIS A 163      32.123  57.310  22.095  1.00 13.89           O  
ATOM    738  CB  HIS A 163      32.843  60.392  22.687  1.00 16.47           C  
ATOM    739  CG  HIS A 163      31.714  61.360  22.532  1.00 17.67           C  
ATOM    740  ND1 HIS A 163      30.428  61.079  22.942  1.00 20.01           N  
ATOM    741  CD2 HIS A 163      31.671  62.596  21.978  1.00 18.63           C  
ATOM    742  CE1 HIS A 163      29.643  62.100  22.647  1.00 19.06           C  
ATOM    743  NE2 HIS A 163      30.372  63.033  22.061  1.00 20.38           N  
ATOM    744  N   GLU A 164      30.813  58.634  20.846  1.00 15.28           N  
ATOM    745  CA  GLU A 164      29.733  57.647  20.784  1.00 16.38           C  
ATOM    746  C   GLU A 164      30.232  56.387  20.081  1.00 15.89           C  
ATOM    747  O   GLU A 164      29.980  55.266  20.529  1.00 15.86           O  
ATOM    748  CB  GLU A 164      28.534  58.208  20.011  1.00 17.54           C  
ATOM    749  CG  GLU A 164      27.843  59.385  20.683  1.00 19.18           C  
ATOM    750  CD  GLU A 164      26.965  58.968  21.848  1.00 22.34           C  
ATOM    751  OE1 GLU A 164      26.458  59.862  22.554  1.00 23.61           O  
ATOM    752  OE2 GLU A 164      26.774  57.752  22.054  1.00 23.06           O  
ATOM    753  N   ASP A 165      30.949  56.576  18.978  1.00 15.17           N  
ATOM    754  CA  ASP A 165      31.461  55.446  18.217  1.00 16.10           C  
ATOM    755  C   ASP A 165      32.603  54.733  18.934  1.00 14.84           C  
ATOM    756  O   ASP A 165      32.654  53.510  18.950  1.00 14.39           O  
ATOM    757  CB  ASP A 165      31.913  55.912  16.830  1.00 18.83           C  
ATOM    758  CG  ASP A 165      30.743  56.282  15.931  1.00 24.41           C  
ATOM    759  OD1 ASP A 165      30.934  57.070  14.983  1.00 27.81           O  
ATOM    760  OD2 ASP A 165      29.631  55.767  16.166  1.00 28.60           O  
ATOM    761  N   GLY A 166      33.511  55.502  19.532  1.00 13.58           N  
ATOM    762  CA  GLY A 166      34.633  54.898  20.229  1.00 13.47           C  
ATOM    763  C   GLY A 166      34.228  54.040  21.412  1.00 13.91           C  
ATOM    764  O   GLY A 166      34.778  52.959  21.618  1.00 13.66           O  
ATOM    765  N   THR A 167      33.260  54.512  22.195  1.00 12.52           N  
ATOM    766  CA  THR A 167      32.809  53.757  23.350  1.00 12.67           C  
ATOM    767  C   THR A 167      31.951  52.566  22.927  1.00 13.59           C  
ATOM    768  O   THR A 167      32.048  51.492  23.513  1.00 12.57           O  
ATOM    769  CB  THR A 167      32.033  54.666  24.340  1.00 12.44           C  
ATOM    770  OG1 THR A 167      30.935  55.298  23.667  1.00 14.00           O  
ATOM    771  CG2 THR A 167      32.962  55.742  24.899  1.00 13.25           C  
ATOM    772  N   ARG A 168      31.126  52.750  21.902  1.00 13.10           N  
ATOM    773  CA  ARG A 168      30.288  51.658  21.421  1.00 13.57           C  
ATOM    774  C   ARG A 168      31.175  50.536  20.881  1.00 14.72           C  
ATOM    775  O   ARG A 168      30.949  49.364  21.164  1.00 14.04           O  
ATOM    776  CB  ARG A 168      29.349  52.143  20.316  1.00 14.65           C  
ATOM    777  CG  ARG A 168      28.536  51.023  19.662  1.00 16.32           C  
ATOM    778  CD  ARG A 168      27.707  51.565  18.510  1.00 21.71           C  
ATOM    779  NE  ARG A 168      28.552  52.217  17.516  1.00 24.80           N  
ATOM    780  CZ  ARG A 168      29.355  51.577  16.672  1.00 26.71           C  
ATOM    781  NH1 ARG A 168      29.429  50.253  16.682  1.00 27.36           N  
ATOM    782  NH2 ARG A 168      30.111  52.270  15.834  1.00 27.13           N  
ATOM    783  N   LEU A 169      32.194  50.903  20.111  1.00 14.06           N  
ATOM    784  CA  LEU A 169      33.101  49.909  19.541  1.00 14.00           C  
ATOM    785  C   LEU A 169      33.757  49.050  20.615  1.00 14.50           C  
ATOM    786  O   LEU A 169      33.828  47.829  20.479  1.00 14.61           O  
ATOM    787  CB  LEU A 169      34.184  50.591  18.698  1.00 13.78           C  
ATOM    788  CG  LEU A 169      33.771  51.076  17.307  1.00 16.28           C  
ATOM    789  CD1 LEU A 169      34.868  51.949  16.717  1.00 17.65           C  
ATOM    790  CD2 LEU A 169      33.492  49.875  16.411  1.00 17.89           C  
ATOM    791  N   GLY A 170      34.235  49.691  21.678  1.00 12.50           N  
ATOM    792  CA  GLY A 170      34.879  48.962  22.755  1.00 13.20           C  
ATOM    793  C   GLY A 170      33.914  48.034  23.466  1.00 13.83           C  
ATOM    794  O   GLY A 170      34.216  46.866  23.700  1.00 14.15           O  
ATOM    795  N   VAL A 171      32.741  48.556  23.811  1.00 13.54           N  
ATOM    796  CA  VAL A 171      31.740  47.750  24.498  1.00 14.26           C  
ATOM    797  C   VAL A 171      31.252  46.593  23.631  1.00 14.81           C  
ATOM    798  O   VAL A 171      31.223  45.446  24.079  1.00 16.23           O  
ATOM    799  CB  VAL A 171      30.518  48.607  24.910  1.00 14.47           C  
ATOM    800  CG1 VAL A 171      29.398  47.706  25.425  1.00 15.97           C  
ATOM    801  CG2 VAL A 171      30.924  49.603  25.990  1.00 16.61           C  
ATOM    802  N   GLU A 172      30.872  46.885  22.393  1.00 16.29           N  
ATOM    803  CA  GLU A 172      30.368  45.839  21.510  1.00 17.43           C  
ATOM    804  C   GLU A 172      31.398  44.761  21.206  1.00 16.98           C  
ATOM    805  O   GLU A 172      31.046  43.594  21.029  1.00 17.04           O  
ATOM    806  CB  GLU A 172      29.816  46.455  20.220  1.00 17.52           C  
ATOM    807  CG  GLU A 172      28.513  47.211  20.474  1.00 18.80           C  
ATOM    808  CD  GLU A 172      27.842  47.731  19.221  1.00 20.92           C  
ATOM    809  OE1 GLU A 172      26.703  48.228  19.343  1.00 20.94           O  
ATOM    810  OE2 GLU A 172      28.435  47.653  18.125  1.00 20.23           O  
ATOM    811  N   HIS A 173      32.670  45.144  21.160  1.00 16.21           N  
ATOM    812  CA  HIS A 173      33.736  44.183  20.900  1.00 15.48           C  
ATOM    813  C   HIS A 173      33.792  43.164  22.042  1.00 15.52           C  
ATOM    814  O   HIS A 173      33.821  41.954  21.807  1.00 16.39           O  
ATOM    815  CB  HIS A 173      35.080  44.914  20.776  1.00 15.31           C  
ATOM    816  CG  HIS A 173      36.246  44.005  20.539  1.00 18.20           C  
ATOM    817  ND1 HIS A 173      36.299  43.123  19.482  1.00 18.71           N  
ATOM    818  CD2 HIS A 173      37.412  43.855  21.214  1.00 19.27           C  
ATOM    819  CE1 HIS A 173      37.448  42.468  19.514  1.00 20.07           C  
ATOM    820  NE2 HIS A 173      38.141  42.895  20.555  1.00 19.63           N  
ATOM    821  N   LEU A 174      33.795  43.658  23.278  1.00 15.07           N  
ATOM    822  CA  LEU A 174      33.845  42.797  24.454  1.00 15.89           C  
ATOM    823  C   LEU A 174      32.579  41.959  24.591  1.00 17.34           C  
ATOM    824  O   LEU A 174      32.643  40.775  24.924  1.00 16.70           O  
ATOM    825  CB  LEU A 174      34.056  43.635  25.718  1.00 15.84           C  
ATOM    826  CG  LEU A 174      35.419  44.336  25.783  1.00 14.24           C  
ATOM    827  CD1 LEU A 174      35.515  45.179  27.036  1.00 14.39           C  
ATOM    828  CD2 LEU A 174      36.529  43.285  25.756  1.00 14.66           C  
ATOM    829  N   VAL A 175      31.429  42.572  24.332  1.00 17.37           N  
ATOM    830  CA  VAL A 175      30.161  41.849  24.430  1.00 18.51           C  
ATOM    831  C   VAL A 175      30.104  40.722  23.401  1.00 19.69           C  
ATOM    832  O   VAL A 175      29.686  39.600  23.716  1.00 19.17           O  
ATOM    833  CB  VAL A 175      28.961  42.797  24.216  1.00 18.43           C  
ATOM    834  CG1 VAL A 175      27.662  41.995  24.130  1.00 20.26           C  
ATOM    835  CG2 VAL A 175      28.881  43.786  25.370  1.00 18.07           C  
ATOM    836  N   ALA A 176      30.537  41.022  22.179  1.00 19.05           N  
ATOM    837  CA  ALA A 176      30.536  40.045  21.098  1.00 20.70           C  
ATOM    838  C   ALA A 176      31.435  38.855  21.422  1.00 21.14           C  
ATOM    839  O   ALA A 176      31.171  37.736  20.981  1.00 20.78           O  
ATOM    840  CB  ALA A 176      30.983  40.701  19.797  1.00 20.86           C  
ATOM    841  N   LEU A 177      32.498  39.103  22.184  1.00 19.82           N  
ATOM    842  CA  LEU A 177      33.420  38.042  22.572  1.00 20.33           C  
ATOM    843  C   LEU A 177      32.851  37.193  23.705  1.00 20.76           C  
ATOM    844  O   LEU A 177      33.384  36.126  24.013  1.00 21.75           O  
ATOM    845  CB  LEU A 177      34.771  38.631  22.993  1.00 21.21           C  
ATOM    846  CG  LEU A 177      35.659  39.152  21.859  1.00 20.98           C  
ATOM    847  CD1 LEU A 177      36.860  39.882  22.444  1.00 20.76           C  
ATOM    848  CD2 LEU A 177      36.109  37.989  20.978  1.00 22.42           C  
ATOM    849  N   GLY A 178      31.772  37.671  24.325  1.00 20.35           N  
ATOM    850  CA  GLY A 178      31.144  36.924  25.405  1.00 20.01           C  
ATOM    851  C   GLY A 178      31.348  37.456  26.815  1.00 19.41           C  
ATOM    852  O   GLY A 178      30.923  36.830  27.787  1.00 19.92           O  
ATOM    853  N   HIS A 179      31.989  38.614  26.942  1.00 18.46           N  
ATOM    854  CA  HIS A 179      32.240  39.191  28.261  1.00 18.30           C  
ATOM    855  C   HIS A 179      30.992  39.757  28.930  1.00 19.56           C  
ATOM    856  O   HIS A 179      30.193  40.444  28.296  1.00 20.02           O  
ATOM    857  CB  HIS A 179      33.299  40.289  28.156  1.00 17.86           C  
ATOM    858  CG  HIS A 179      34.666  39.773  27.844  1.00 16.92           C  
ATOM    859  ND1 HIS A 179      35.470  39.176  28.791  1.00 17.23           N  
ATOM    860  CD2 HIS A 179      35.354  39.721  26.679  1.00 18.04           C  
ATOM    861  CE1 HIS A 179      36.593  38.776  28.222  1.00 16.25           C  
ATOM    862  NE2 HIS A 179      36.546  39.094  26.942  1.00 16.88           N  
ATOM    863  N   GLN A 180      30.854  39.468  30.222  1.00 20.41           N  
ATOM    864  CA  GLN A 180      29.727  39.937  31.023  1.00 22.76           C  
ATOM    865  C   GLN A 180      30.224  40.621  32.297  1.00 22.53           C  
ATOM    866  O   GLN A 180      29.522  41.449  32.874  1.00 22.97           O  
ATOM    867  CB  GLN A 180      28.819  38.761  31.393  1.00 25.89           C  
ATOM    868  CG  GLN A 180      28.186  38.059  30.201  1.00 31.99           C  
ATOM    869  CD  GLN A 180      27.189  38.933  29.466  1.00 36.42           C  
ATOM    870  OE1 GLN A 180      27.545  39.970  28.908  1.00 41.09           O  
ATOM    871  NE2 GLN A 180      25.927  38.514  29.461  1.00 39.81           N  
ATOM    872  N   GLN A 181      31.431  40.260  32.734  1.00 21.68           N  
ATOM    873  CA  GLN A 181      32.049  40.836  33.932  1.00 19.74           C  
ATOM    874  C   GLN A 181      33.075  41.858  33.463  1.00 19.40           C  
ATOM    875  O   GLN A 181      34.233  41.520  33.214  1.00 19.46           O  
ATOM    876  CB  GLN A 181      32.753  39.748  34.746  1.00 22.85           C  
ATOM    877  CG  GLN A 181      31.827  38.708  35.359  1.00 26.86           C  
ATOM    878  CD  GLN A 181      30.949  39.285  36.452  1.00 29.90           C  
ATOM    879  OE1 GLN A 181      29.959  39.963  36.178  1.00 33.79           O  
ATOM    880  NE2 GLN A 181      31.318  39.028  37.700  1.00 32.98           N  
ATOM    881  N   ILE A 182      32.651  43.112  33.366  1.00 17.29           N  
ATOM    882  CA  ILE A 182      33.514  44.171  32.864  1.00 16.84           C  
ATOM    883  C   ILE A 182      33.786  45.306  33.842  1.00 16.62           C  
ATOM    884  O   ILE A 182      32.900  45.736  34.578  1.00 18.01           O  
ATOM    885  CB  ILE A 182      32.899  44.749  31.572  1.00 16.23           C  
ATOM    886  CG1 ILE A 182      32.726  43.617  30.553  1.00 16.49           C  
ATOM    887  CG2 ILE A 182      33.779  45.868  31.009  1.00 17.45           C  
ATOM    888  CD1 ILE A 182      31.946  43.997  29.315  1.00 17.76           C  
ATOM    889  N   ALA A 183      35.028  45.785  33.851  1.00 15.29           N  
ATOM    890  CA  ALA A 183      35.408  46.886  34.721  1.00 15.01           C  
ATOM    891  C   ALA A 183      35.804  48.068  33.847  1.00 13.97           C  
ATOM    892  O   ALA A 183      36.271  47.884  32.720  1.00 14.07           O  
ATOM    893  CB  ALA A 183      36.573  46.483  35.623  1.00 16.12           C  
ATOM    894  N   LEU A 184      35.604  49.274  34.366  1.00 14.03           N  
ATOM    895  CA  LEU A 184      35.931  50.493  33.639  1.00 14.48           C  
ATOM    896  C   LEU A 184      37.023  51.281  34.343  1.00 15.13           C  
ATOM    897  O   LEU A 184      37.012  51.413  35.565  1.00 14.95           O  
ATOM    898  CB  LEU A 184      34.698  51.395  33.522  1.00 14.64           C  
ATOM    899  CG  LEU A 184      33.402  50.786  32.980  1.00 14.71           C  
ATOM    900  CD1 LEU A 184      32.307  51.856  32.980  1.00 15.31           C  
ATOM    901  CD2 LEU A 184      33.626  50.241  31.583  1.00 15.69           C  
ATOM    902  N   LEU A 185      37.974  51.797  33.571  1.00 14.25           N  
ATOM    903  CA  LEU A 185      39.036  52.626  34.131  1.00 14.17           C  
ATOM    904  C   LEU A 185      38.981  53.916  33.332  1.00 13.81           C  
ATOM    905  O   LEU A 185      39.495  53.996  32.214  1.00 14.82           O  
ATOM    906  CB  LEU A 185      40.410  51.962  33.985  1.00 16.38           C  
ATOM    907  CG  LEU A 185      41.593  52.833  34.435  1.00 18.05           C  
ATOM    908  CD1 LEU A 185      41.339  53.397  35.831  1.00 20.89           C  
ATOM    909  CD2 LEU A 185      42.865  51.997  34.421  1.00 21.55           C  
ATOM    910  N   ALA A 186      38.336  54.920  33.915  1.00 13.30           N  
ATOM    911  CA  ALA A 186      38.151  56.211  33.268  1.00 12.22           C  
ATOM    912  C   ALA A 186      39.340  57.144  33.394  1.00 13.55           C  
ATOM    913  O   ALA A 186      40.212  56.954  34.242  1.00 14.13           O  
ATOM    914  CB  ALA A 186      36.905  56.893  33.842  1.00 14.65           C  
ATOM    915  N   GLY A 187      39.362  58.152  32.528  1.00 14.58           N  
ATOM    916  CA  GLY A 187      40.409  59.154  32.578  1.00 14.27           C  
ATOM    917  C   GLY A 187      40.000  60.128  33.670  1.00 15.51           C  
ATOM    918  O   GLY A 187      38.941  59.953  34.274  1.00 14.05           O  
ATOM    919  N   PRO A 188      40.801  61.164  33.949  1.00 14.77           N  
ATOM    920  CA  PRO A 188      40.448  62.128  34.995  1.00 14.65           C  
ATOM    921  C   PRO A 188      39.147  62.844  34.643  1.00 14.34           C  
ATOM    922  O   PRO A 188      39.041  63.483  33.599  1.00 15.07           O  
ATOM    923  CB  PRO A 188      41.663  63.054  35.029  1.00 15.72           C  
ATOM    924  CG  PRO A 188      42.155  63.018  33.608  1.00 14.38           C  
ATOM    925  CD  PRO A 188      42.039  61.557  33.253  1.00 15.33           C  
ATOM    926  N   LEU A 189      38.153  62.739  35.519  1.00 15.57           N  
ATOM    927  CA  LEU A 189      36.862  63.350  35.228  1.00 14.86           C  
ATOM    928  C   LEU A 189      36.840  64.870  35.156  1.00 16.62           C  
ATOM    929  O   LEU A 189      35.804  65.459  34.867  1.00 16.64           O  
ATOM    930  CB  LEU A 189      35.801  62.829  36.204  1.00 16.70           C  
ATOM    931  CG  LEU A 189      35.609  61.309  36.116  1.00 17.15           C  
ATOM    932  CD1 LEU A 189      34.424  60.904  36.983  1.00 17.81           C  
ATOM    933  CD2 LEU A 189      35.373  60.883  34.663  1.00 15.94           C  
ATOM    934  N   SER A 190      37.982  65.509  35.402  1.00 16.50           N  
ATOM    935  CA  SER A 190      38.051  66.962  35.296  1.00 17.47           C  
ATOM    936  C   SER A 190      38.094  67.293  33.803  1.00 17.30           C  
ATOM    937  O   SER A 190      37.844  68.430  33.396  1.00 17.75           O  
ATOM    938  CB  SER A 190      39.313  67.489  35.983  1.00 17.45           C  
ATOM    939  OG  SER A 190      40.466  66.853  35.463  1.00 20.43           O  
ATOM    940  N   SER A 191      38.401  66.280  32.997  1.00 16.86           N  
ATOM    941  CA  SER A 191      38.489  66.419  31.543  1.00 16.09           C  
ATOM    942  C   SER A 191      37.202  66.026  30.824  1.00 15.96           C  
ATOM    943  O   SER A 191      36.706  64.914  30.999  1.00 14.87           O  
ATOM    944  CB  SER A 191      39.631  65.554  31.006  1.00 18.02           C  
ATOM    945  OG  SER A 191      39.442  65.266  29.630  1.00 20.13           O  
ATOM    946  N   VAL A 192      36.680  66.926  29.998  1.00 15.32           N  
ATOM    947  CA  VAL A 192      35.457  66.645  29.254  1.00 16.89           C  
ATOM    948  C   VAL A 192      35.602  65.374  28.406  1.00 16.59           C  
ATOM    949  O   VAL A 192      34.654  64.605  28.270  1.00 16.35           O  
ATOM    950  CB  VAL A 192      35.054  67.848  28.355  1.00 18.05           C  
ATOM    951  CG1 VAL A 192      36.108  68.095  27.291  1.00 18.37           C  
ATOM    952  CG2 VAL A 192      33.698  67.588  27.714  1.00 18.12           C  
ATOM    953  N   SER A 193      36.787  65.142  27.844  1.00 16.67           N  
ATOM    954  CA  SER A 193      36.995  63.942  27.038  1.00 16.04           C  
ATOM    955  C   SER A 193      36.828  62.674  27.868  1.00 14.89           C  
ATOM    956  O   SER A 193      36.215  61.706  27.419  1.00 15.85           O  
ATOM    957  CB  SER A 193      38.384  63.949  26.389  1.00 18.06           C  
ATOM    958  OG  SER A 193      38.379  64.752  25.224  1.00 22.93           O  
ATOM    959  N   ALA A 194      37.378  62.680  29.077  1.00 13.71           N  
ATOM    960  CA  ALA A 194      37.273  61.523  29.955  1.00 13.09           C  
ATOM    961  C   ALA A 194      35.816  61.305  30.347  1.00 12.95           C  
ATOM    962  O   ALA A 194      35.356  60.168  30.450  1.00 13.04           O  
ATOM    963  CB  ALA A 194      38.116  61.730  31.199  1.00 14.15           C  
ATOM    964  N   ARG A 195      35.100  62.400  30.577  1.00 12.70           N  
ATOM    965  CA  ARG A 195      33.697  62.310  30.969  1.00 12.82           C  
ATOM    966  C   ARG A 195      32.825  61.745  29.854  1.00 13.52           C  
ATOM    967  O   ARG A 195      32.000  60.862  30.094  1.00 13.97           O  
ATOM    968  CB  ARG A 195      33.169  63.683  31.398  1.00 12.54           C  
ATOM    969  CG  ARG A 195      33.818  64.225  32.670  1.00 12.41           C  
ATOM    970  CD  ARG A 195      33.000  65.366  33.274  1.00 13.21           C  
ATOM    971  NE  ARG A 195      32.892  66.527  32.393  1.00 14.03           N  
ATOM    972  CZ  ARG A 195      33.745  67.548  32.383  1.00 16.71           C  
ATOM    973  NH1 ARG A 195      33.557  68.563  31.545  1.00 15.90           N  
ATOM    974  NH2 ARG A 195      34.784  67.559  33.208  1.00 15.59           N  
ATOM    975  N   LEU A 196      33.002  62.251  28.636  1.00 13.34           N  
ATOM    976  CA  LEU A 196      32.220  61.765  27.503  1.00 14.48           C  
ATOM    977  C   LEU A 196      32.486  60.280  27.282  1.00 14.49           C  
ATOM    978  O   LEU A 196      31.571  59.510  26.972  1.00 13.80           O  
ATOM    979  CB  LEU A 196      32.573  62.546  26.234  1.00 15.55           C  
ATOM    980  CG  LEU A 196      32.153  64.018  26.213  1.00 16.98           C  
ATOM    981  CD1 LEU A 196      32.769  64.704  24.995  1.00 18.12           C  
ATOM    982  CD2 LEU A 196      30.629  64.118  26.182  1.00 19.25           C  
ATOM    983  N   ARG A 197      33.743  59.880  27.449  1.00 12.88           N  
ATOM    984  CA  ARG A 197      34.134  58.486  27.269  1.00 12.38           C  
ATOM    985  C   ARG A 197      33.480  57.593  28.325  1.00 13.02           C  
ATOM    986  O   ARG A 197      32.931  56.537  28.003  1.00 13.45           O  
ATOM    987  CB  ARG A 197      35.664  58.376  27.339  1.00 14.07           C  
ATOM    988  CG  ARG A 197      36.260  57.042  26.889  1.00 16.47           C  
ATOM    989  CD  ARG A 197      37.742  57.249  26.538  1.00 16.36           C  
ATOM    990  NE  ARG A 197      37.857  58.289  25.518  1.00 15.52           N  
ATOM    991  CZ  ARG A 197      38.963  58.970  25.230  1.00 17.44           C  
ATOM    992  NH1 ARG A 197      40.097  58.736  25.881  1.00 13.78           N  
ATOM    993  NH2 ARG A 197      38.925  59.912  24.296  1.00 16.59           N  
ATOM    994  N   LEU A 198      33.520  58.019  29.583  1.00 12.26           N  
ATOM    995  CA  LEU A 198      32.922  57.224  30.649  1.00 12.61           C  
ATOM    996  C   LEU A 198      31.405  57.128  30.471  1.00 12.03           C  
ATOM    997  O   LEU A 198      30.824  56.054  30.635  1.00 12.55           O  
ATOM    998  CB  LEU A 198      33.253  57.827  32.020  1.00 12.85           C  
ATOM    999  CG  LEU A 198      32.668  57.104  33.241  1.00 12.62           C  
ATOM   1000  CD1 LEU A 198      33.067  55.632  33.223  1.00 13.79           C  
ATOM   1001  CD2 LEU A 198      33.166  57.781  34.515  1.00 13.48           C  
ATOM   1002  N   ALA A 199      30.767  58.243  30.127  1.00 12.42           N  
ATOM   1003  CA  ALA A 199      29.316  58.247  29.932  1.00 13.43           C  
ATOM   1004  C   ALA A 199      28.947  57.307  28.794  1.00 14.06           C  
ATOM   1005  O   ALA A 199      27.935  56.602  28.857  1.00 13.79           O  
ATOM   1006  CB  ALA A 199      28.827  59.657  29.629  1.00 14.98           C  
ATOM   1007  N   GLY A 200      29.775  57.306  27.754  1.00 14.63           N  
ATOM   1008  CA  GLY A 200      29.536  56.443  26.611  1.00 14.91           C  
ATOM   1009  C   GLY A 200      29.625  54.976  26.971  1.00 13.72           C  
ATOM   1010  O   GLY A 200      28.772  54.188  26.555  1.00 14.47           O  
ATOM   1011  N   TRP A 201      30.654  54.592  27.726  1.00 13.08           N  
ATOM   1012  CA  TRP A 201      30.782  53.197  28.121  1.00 12.78           C  
ATOM   1013  C   TRP A 201      29.530  52.760  28.863  1.00 13.75           C  
ATOM   1014  O   TRP A 201      28.988  51.692  28.595  1.00 14.45           O  
ATOM   1015  CB  TRP A 201      31.982  52.970  29.036  1.00 13.92           C  
ATOM   1016  CG  TRP A 201      33.288  53.024  28.336  1.00 12.00           C  
ATOM   1017  CD1 TRP A 201      33.537  52.695  27.037  1.00 13.06           C  
ATOM   1018  CD2 TRP A 201      34.549  53.360  28.919  1.00 13.29           C  
ATOM   1019  NE1 TRP A 201      34.885  52.803  26.772  1.00 12.87           N  
ATOM   1020  CE2 TRP A 201      35.527  53.209  27.911  1.00 12.87           C  
ATOM   1021  CE3 TRP A 201      34.949  53.771  30.195  1.00 14.87           C  
ATOM   1022  CZ2 TRP A 201      36.885  53.456  28.144  1.00 14.12           C  
ATOM   1023  CZ3 TRP A 201      36.298  54.018  30.427  1.00 17.01           C  
ATOM   1024  CH2 TRP A 201      37.248  53.857  29.404  1.00 14.41           C  
ATOM   1025  N   HIS A 202      29.079  53.583  29.803  1.00 13.13           N  
ATOM   1026  CA  HIS A 202      27.887  53.242  30.570  1.00 14.25           C  
ATOM   1027  C   HIS A 202      26.660  53.126  29.686  1.00 14.39           C  
ATOM   1028  O   HIS A 202      25.835  52.234  29.878  1.00 14.77           O  
ATOM   1029  CB  HIS A 202      27.646  54.279  31.668  1.00 14.57           C  
ATOM   1030  CG  HIS A 202      28.505  54.078  32.878  1.00 14.45           C  
ATOM   1031  ND1 HIS A 202      28.407  52.960  33.678  1.00 15.41           N  
ATOM   1032  CD2 HIS A 202      29.475  54.847  33.423  1.00 15.51           C  
ATOM   1033  CE1 HIS A 202      29.279  53.050  34.667  1.00 16.51           C  
ATOM   1034  NE2 HIS A 202      29.940  54.186  34.535  1.00 15.84           N  
ATOM   1035  N   LYS A 203      26.539  54.026  28.717  1.00 14.10           N  
ATOM   1036  CA  LYS A 203      25.401  54.006  27.804  1.00 15.38           C  
ATOM   1037  C   LYS A 203      25.317  52.685  27.044  1.00 15.57           C  
ATOM   1038  O   LYS A 203      24.277  52.027  27.036  1.00 14.87           O  
ATOM   1039  CB  LYS A 203      25.498  55.162  26.805  1.00 16.30           C  
ATOM   1040  CG  LYS A 203      24.432  55.127  25.715  1.00 19.69           C  
ATOM   1041  CD  LYS A 203      24.598  56.281  24.738  1.00 21.02           C  
ATOM   1042  CE  LYS A 203      23.653  56.141  23.556  1.00 23.03           C  
ATOM   1043  NZ  LYS A 203      23.791  57.264  22.584  1.00 22.70           N  
ATOM   1044  N   TYR A 204      26.413  52.289  26.409  1.00 14.15           N  
ATOM   1045  CA  TYR A 204      26.400  51.054  25.640  1.00 13.45           C  
ATOM   1046  C   TYR A 204      26.391  49.780  26.478  1.00 13.52           C  
ATOM   1047  O   TYR A 204      25.828  48.770  26.055  1.00 15.38           O  
ATOM   1048  CB  TYR A 204      27.539  51.087  24.617  1.00 14.76           C  
ATOM   1049  CG  TYR A 204      27.279  52.165  23.588  1.00 14.65           C  
ATOM   1050  CD1 TYR A 204      26.272  52.009  22.630  1.00 14.94           C  
ATOM   1051  CD2 TYR A 204      27.957  53.383  23.635  1.00 15.72           C  
ATOM   1052  CE1 TYR A 204      25.939  53.040  21.755  1.00 15.75           C  
ATOM   1053  CE2 TYR A 204      27.633  54.422  22.760  1.00 14.10           C  
ATOM   1054  CZ  TYR A 204      26.620  54.244  21.828  1.00 17.44           C  
ATOM   1055  OH  TYR A 204      26.267  55.274  20.988  1.00 19.17           O  
ATOM   1056  N   LEU A 205      26.986  49.817  27.667  1.00 13.53           N  
ATOM   1057  CA  LEU A 205      26.952  48.641  28.527  1.00 13.21           C  
ATOM   1058  C   LEU A 205      25.490  48.447  28.940  1.00 14.26           C  
ATOM   1059  O   LEU A 205      24.979  47.325  28.936  1.00 14.46           O  
ATOM   1060  CB  LEU A 205      27.822  48.838  29.773  1.00 15.59           C  
ATOM   1061  CG  LEU A 205      29.329  48.627  29.587  1.00 15.79           C  
ATOM   1062  CD1 LEU A 205      30.060  48.940  30.881  1.00 18.60           C  
ATOM   1063  CD2 LEU A 205      29.591  47.188  29.159  1.00 17.30           C  
ATOM   1064  N   THR A 206      24.822  49.549  29.267  1.00 15.26           N  
ATOM   1065  CA  THR A 206      23.416  49.495  29.670  1.00 14.99           C  
ATOM   1066  C   THR A 206      22.560  48.969  28.521  1.00 15.02           C  
ATOM   1067  O   THR A 206      21.660  48.152  28.730  1.00 14.61           O  
ATOM   1068  CB  THR A 206      22.898  50.887  30.091  1.00 16.67           C  
ATOM   1069  OG1 THR A 206      23.644  51.351  31.223  1.00 17.83           O  
ATOM   1070  CG2 THR A 206      21.421  50.812  30.477  1.00 18.34           C  
ATOM   1071  N   ARG A 207      22.841  49.425  27.305  1.00 14.45           N  
ATOM   1072  CA  ARG A 207      22.084  48.966  26.147  1.00 16.41           C  
ATOM   1073  C   ARG A 207      22.237  47.457  25.964  1.00 16.86           C  
ATOM   1074  O   ARG A 207      21.358  46.796  25.407  1.00 17.43           O  
ATOM   1075  CB  ARG A 207      22.541  49.690  24.877  1.00 18.66           C  
ATOM   1076  CG  ARG A 207      22.083  51.140  24.784  1.00 24.08           C  
ATOM   1077  CD  ARG A 207      22.300  51.678  23.374  1.00 28.06           C  
ATOM   1078  NE  ARG A 207      21.770  53.025  23.199  1.00 33.96           N  
ATOM   1079  CZ  ARG A 207      21.793  53.688  22.047  1.00 34.40           C  
ATOM   1080  NH1 ARG A 207      22.323  53.126  20.970  1.00 37.63           N  
ATOM   1081  NH2 ARG A 207      21.290  54.913  21.973  1.00 38.62           N  
ATOM   1082  N   ASN A 208      23.357  46.918  26.436  1.00 16.35           N  
ATOM   1083  CA  ASN A 208      23.621  45.486  26.335  1.00 15.36           C  
ATOM   1084  C   ASN A 208      23.264  44.770  27.639  1.00 16.33           C  
ATOM   1085  O   ASN A 208      23.683  43.637  27.884  1.00 16.83           O  
ATOM   1086  CB  ASN A 208      25.090  45.255  25.955  1.00 15.43           C  
ATOM   1087  CG  ASN A 208      25.344  45.493  24.475  1.00 16.67           C  
ATOM   1088  OD1 ASN A 208      25.110  44.613  23.646  1.00 18.71           O  
ATOM   1089  ND2 ASN A 208      25.795  46.695  24.134  1.00 16.97           N  
ATOM   1090  N   GLN A 209      22.474  45.453  28.467  1.00 16.99           N  
ATOM   1091  CA  GLN A 209      21.994  44.934  29.746  1.00 16.47           C  
ATOM   1092  C   GLN A 209      23.081  44.445  30.690  1.00 16.77           C  
ATOM   1093  O   GLN A 209      22.918  43.444  31.386  1.00 17.47           O  
ATOM   1094  CB  GLN A 209      20.957  43.829  29.485  1.00 17.31           C  
ATOM   1095  CG  GLN A 209      19.897  44.283  28.486  1.00 17.50           C  
ATOM   1096  CD  GLN A 209      18.763  43.288  28.277  1.00 18.73           C  
ATOM   1097  OE1 GLN A 209      18.103  43.305  27.240  1.00 21.20           O  
ATOM   1098  NE2 GLN A 209      18.522  42.436  29.263  1.00 18.18           N  
ATOM   1099  N   ILE A 210      24.188  45.180  30.727  1.00 16.28           N  
ATOM   1100  CA  ILE A 210      25.309  44.839  31.585  1.00 15.93           C  
ATOM   1101  C   ILE A 210      25.684  46.005  32.484  1.00 15.98           C  
ATOM   1102  O   ILE A 210      25.777  47.146  32.030  1.00 17.12           O  
ATOM   1103  CB  ILE A 210      26.568  44.485  30.754  1.00 17.26           C  
ATOM   1104  CG1 ILE A 210      26.316  43.223  29.932  1.00 18.58           C  
ATOM   1105  CG2 ILE A 210      27.770  44.310  31.683  1.00 18.97           C  
ATOM   1106  CD1 ILE A 210      27.402  42.938  28.913  1.00 20.51           C  
ATOM   1107  N   GLN A 211      25.875  45.715  33.767  1.00 15.93           N  
ATOM   1108  CA  GLN A 211      26.318  46.723  34.717  1.00 15.93           C  
ATOM   1109  C   GLN A 211      27.759  46.329  35.044  1.00 15.67           C  
ATOM   1110  O   GLN A 211      28.030  45.182  35.398  1.00 16.40           O  
ATOM   1111  CB  GLN A 211      25.461  46.701  35.986  1.00 17.27           C  
ATOM   1112  CG  GLN A 211      24.082  47.328  35.801  1.00 17.52           C  
ATOM   1113  CD  GLN A 211      23.303  47.416  37.102  1.00 18.33           C  
ATOM   1114  OE1 GLN A 211      22.978  46.401  37.708  1.00 20.20           O  
ATOM   1115  NE2 GLN A 211      23.005  48.638  37.537  1.00 18.43           N  
ATOM   1116  N   PRO A 212      28.711  47.266  34.901  1.00 16.54           N  
ATOM   1117  CA  PRO A 212      30.109  46.935  35.200  1.00 16.83           C  
ATOM   1118  C   PRO A 212      30.295  46.517  36.656  1.00 17.64           C  
ATOM   1119  O   PRO A 212      29.599  47.021  37.539  1.00 18.30           O  
ATOM   1120  CB  PRO A 212      30.848  48.228  34.859  1.00 16.55           C  
ATOM   1121  CG  PRO A 212      29.831  49.290  35.147  1.00 18.02           C  
ATOM   1122  CD  PRO A 212      28.563  48.691  34.560  1.00 15.75           C  
ATOM   1123  N   ILE A 213      31.227  45.601  36.912  1.00 17.65           N  
ATOM   1124  CA  ILE A 213      31.449  45.153  38.284  1.00 19.57           C  
ATOM   1125  C   ILE A 213      32.307  46.124  39.076  1.00 19.50           C  
ATOM   1126  O   ILE A 213      32.474  45.976  40.287  1.00 20.72           O  
ATOM   1127  CB  ILE A 213      32.083  43.742  38.344  1.00 20.85           C  
ATOM   1128  CG1 ILE A 213      33.470  43.744  37.701  1.00 22.17           C  
ATOM   1129  CG2 ILE A 213      31.180  42.746  37.640  1.00 22.39           C  
ATOM   1130  CD1 ILE A 213      34.207  42.429  37.887  1.00 23.61           C  
ATOM   1131  N   ALA A 214      32.855  47.121  38.387  1.00 18.36           N  
ATOM   1132  CA  ALA A 214      33.669  48.134  39.036  1.00 17.30           C  
ATOM   1133  C   ALA A 214      34.056  49.220  38.050  1.00 15.99           C  
ATOM   1134  O   ALA A 214      34.186  48.967  36.854  1.00 15.76           O  
ATOM   1135  CB  ALA A 214      34.931  47.505  39.627  1.00 19.24           C  
ATOM   1136  N   GLU A 215      34.199  50.437  38.557  1.00 16.67           N  
ATOM   1137  CA  GLU A 215      34.631  51.554  37.735  1.00 17.40           C  
ATOM   1138  C   GLU A 215      35.519  52.431  38.595  1.00 17.95           C  
ATOM   1139  O   GLU A 215      35.195  52.741  39.747  1.00 18.31           O  
ATOM   1140  CB  GLU A 215      33.446  52.350  37.156  1.00 19.38           C  
ATOM   1141  CG  GLU A 215      32.523  53.046  38.145  1.00 20.46           C  
ATOM   1142  CD  GLU A 215      31.486  53.910  37.434  1.00 23.44           C  
ATOM   1143  OE1 GLU A 215      30.281  53.774  37.735  1.00 22.39           O  
ATOM   1144  OE2 GLU A 215      31.875  54.728  36.569  1.00 21.32           O  
ATOM   1145  N   ARG A 216      36.665  52.795  38.035  1.00 15.76           N  
ATOM   1146  CA  ARG A 216      37.634  53.620  38.733  1.00 14.93           C  
ATOM   1147  C   ARG A 216      38.064  54.776  37.849  1.00 14.98           C  
ATOM   1148  O   ARG A 216      37.632  54.885  36.698  1.00 14.68           O  
ATOM   1149  CB  ARG A 216      38.840  52.769  39.144  1.00 15.53           C  
ATOM   1150  CG  ARG A 216      38.567  51.901  40.372  1.00 18.93           C  
ATOM   1151  CD  ARG A 216      39.622  50.819  40.547  1.00 20.73           C  
ATOM   1152  NE  ARG A 216      39.499  50.144  41.838  1.00 23.96           N  
ATOM   1153  CZ  ARG A 216      39.973  50.626  42.982  1.00 26.46           C  
ATOM   1154  NH1 ARG A 216      40.610  51.791  43.004  1.00 25.79           N  
ATOM   1155  NH2 ARG A 216      39.816  49.942  44.110  1.00 25.86           N  
ATOM   1156  N   GLU A 217      38.917  55.636  38.397  1.00 15.46           N  
ATOM   1157  CA  GLU A 217      39.382  56.820  37.688  1.00 16.25           C  
ATOM   1158  C   GLU A 217      40.893  56.985  37.804  1.00 15.81           C  
ATOM   1159  O   GLU A 217      41.451  56.891  38.898  1.00 16.23           O  
ATOM   1160  CB  GLU A 217      38.686  58.051  38.274  1.00 17.49           C  
ATOM   1161  CG  GLU A 217      39.038  59.371  37.620  1.00 20.38           C  
ATOM   1162  CD  GLU A 217      38.441  60.553  38.363  1.00 21.95           C  
ATOM   1163  OE1 GLU A 217      37.533  60.339  39.203  1.00 24.64           O  
ATOM   1164  OE2 GLU A 217      38.866  61.695  38.106  1.00 20.21           O  
ATOM   1165  N   GLY A 218      41.542  57.235  36.670  1.00 16.81           N  
ATOM   1166  CA  GLY A 218      42.985  57.427  36.652  1.00 16.59           C  
ATOM   1167  C   GLY A 218      43.329  58.844  36.228  1.00 16.73           C  
ATOM   1168  O   GLY A 218      42.485  59.734  36.325  1.00 16.03           O  
ATOM   1169  N   ASP A 219      44.552  59.070  35.749  1.00 14.69           N  
ATOM   1170  CA  ASP A 219      44.944  60.418  35.337  1.00 16.07           C  
ATOM   1171  C   ASP A 219      45.647  60.487  33.978  1.00 15.79           C  
ATOM   1172  O   ASP A 219      46.376  61.446  33.707  1.00 16.48           O  
ATOM   1173  CB  ASP A 219      45.841  61.065  36.406  1.00 17.87           C  
ATOM   1174  CG  ASP A 219      47.183  60.360  36.561  1.00 20.73           C  
ATOM   1175  OD1 ASP A 219      47.528  59.523  35.705  1.00 19.74           O  
ATOM   1176  OD2 ASP A 219      47.902  60.655  37.542  1.00 22.00           O  
ATOM   1177  N   TRP A 220      45.405  59.477  33.140  1.00 13.91           N  
ATOM   1178  CA  TRP A 220      45.981  59.351  31.794  1.00 14.33           C  
ATOM   1179  C   TRP A 220      47.357  58.677  31.806  1.00 14.11           C  
ATOM   1180  O   TRP A 220      47.846  58.253  30.757  1.00 16.18           O  
ATOM   1181  CB  TRP A 220      46.127  60.716  31.099  1.00 14.38           C  
ATOM   1182  CG  TRP A 220      44.851  61.475  30.784  1.00 14.13           C  
ATOM   1183  CD1 TRP A 220      44.637  62.812  30.985  1.00 15.49           C  
ATOM   1184  CD2 TRP A 220      43.670  60.980  30.126  1.00 14.47           C  
ATOM   1185  NE1 TRP A 220      43.409  63.179  30.492  1.00 15.96           N  
ATOM   1186  CE2 TRP A 220      42.794  62.077  29.961  1.00 14.67           C  
ATOM   1187  CE3 TRP A 220      43.271  59.720  29.658  1.00 15.31           C  
ATOM   1188  CZ2 TRP A 220      41.538  61.955  29.346  1.00 15.03           C  
ATOM   1189  CZ3 TRP A 220      42.018  59.598  29.044  1.00 13.62           C  
ATOM   1190  CH2 TRP A 220      41.170  60.713  28.897  1.00 12.46           C  
ATOM   1191  N   SER A 221      47.978  58.567  32.978  1.00 15.07           N  
ATOM   1192  CA  SER A 221      49.310  57.958  33.062  1.00 13.57           C  
ATOM   1193  C   SER A 221      49.302  56.450  33.260  1.00 15.37           C  
ATOM   1194  O   SER A 221      48.358  55.880  33.813  1.00 15.24           O  
ATOM   1195  CB  SER A 221      50.123  58.593  34.199  1.00 15.62           C  
ATOM   1196  OG  SER A 221      49.652  58.164  35.468  1.00 15.88           O  
ATOM   1197  N   ALA A 222      50.373  55.802  32.809  1.00 13.96           N  
ATOM   1198  CA  ALA A 222      50.492  54.362  32.958  1.00 14.07           C  
ATOM   1199  C   ALA A 222      50.474  53.984  34.433  1.00 14.86           C  
ATOM   1200  O   ALA A 222      49.852  52.993  34.816  1.00 15.72           O  
ATOM   1201  CB  ALA A 222      51.785  53.865  32.302  1.00 15.34           C  
ATOM   1202  N   MET A 223      51.141  54.773  35.271  1.00 16.19           N  
ATOM   1203  CA  MET A 223      51.180  54.451  36.690  1.00 17.04           C  
ATOM   1204  C   MET A 223      49.791  54.475  37.317  1.00 15.63           C  
ATOM   1205  O   MET A 223      49.495  53.661  38.188  1.00 16.48           O  
ATOM   1206  CB  MET A 223      52.111  55.401  37.448  1.00 19.37           C  
ATOM   1207  CG  MET A 223      52.371  54.970  38.897  1.00 23.15           C  
ATOM   1208  SD  MET A 223      53.026  53.273  39.045  1.00 29.02           S  
ATOM   1209  CE  MET A 223      54.729  53.526  38.544  1.00 28.34           C  
ATOM   1210  N   SER A 224      48.932  55.390  36.877  1.00 15.77           N  
ATOM   1211  CA  SER A 224      47.584  55.437  37.447  1.00 16.42           C  
ATOM   1212  C   SER A 224      46.814  54.185  37.027  1.00 17.09           C  
ATOM   1213  O   SER A 224      45.994  53.665  37.785  1.00 16.67           O  
ATOM   1214  CB  SER A 224      46.837  56.708  37.010  1.00 17.33           C  
ATOM   1215  OG  SER A 224      46.417  56.655  35.658  1.00 19.62           O  
ATOM   1216  N   GLY A 225      47.086  53.691  35.822  1.00 15.93           N  
ATOM   1217  CA  GLY A 225      46.417  52.486  35.360  1.00 14.82           C  
ATOM   1218  C   GLY A 225      46.871  51.299  36.188  1.00 16.11           C  
ATOM   1219  O   GLY A 225      46.088  50.412  36.527  1.00 14.51           O  
ATOM   1220  N   PHE A 226      48.157  51.285  36.519  1.00 14.01           N  
ATOM   1221  CA  PHE A 226      48.725  50.210  37.322  1.00 15.31           C  
ATOM   1222  C   PHE A 226      48.148  50.231  38.738  1.00 15.59           C  
ATOM   1223  O   PHE A 226      47.715  49.202  39.262  1.00 16.64           O  
ATOM   1224  CB  PHE A 226      50.245  50.366  37.405  1.00 14.70           C  
ATOM   1225  CG  PHE A 226      50.907  49.362  38.305  1.00 15.62           C  
ATOM   1226  CD1 PHE A 226      51.085  48.047  37.891  1.00 15.04           C  
ATOM   1227  CD2 PHE A 226      51.330  49.727  39.581  1.00 17.34           C  
ATOM   1228  CE1 PHE A 226      51.673  47.105  38.734  1.00 16.59           C  
ATOM   1229  CE2 PHE A 226      51.919  48.792  40.430  1.00 16.76           C  
ATOM   1230  CZ  PHE A 226      52.090  47.480  40.005  1.00 17.02           C  
ATOM   1231  N   GLN A 227      48.151  51.410  39.352  1.00 16.53           N  
ATOM   1232  CA  GLN A 227      47.650  51.562  40.716  1.00 18.09           C  
ATOM   1233  C   GLN A 227      46.171  51.219  40.845  1.00 17.65           C  
ATOM   1234  O   GLN A 227      45.780  50.450  41.721  1.00 17.91           O  
ATOM   1235  CB  GLN A 227      47.887  52.989  41.206  1.00 19.32           C  
ATOM   1236  CG  GLN A 227      49.352  53.402  41.210  1.00 26.63           C  
ATOM   1237  CD  GLN A 227      49.556  54.847  41.622  1.00 29.33           C  
ATOM   1238  OE1 GLN A 227      48.908  55.753  41.096  1.00 33.63           O  
ATOM   1239  NE2 GLN A 227      50.470  55.071  42.556  1.00 33.15           N  
ATOM   1240  N   GLN A 228      45.347  51.790  39.974  1.00 17.57           N  
ATOM   1241  CA  GLN A 228      43.911  51.531  40.030  1.00 16.29           C  
ATOM   1242  C   GLN A 228      43.577  50.065  39.801  1.00 17.44           C  
ATOM   1243  O   GLN A 228      42.708  49.499  40.478  1.00 16.42           O  
ATOM   1244  CB  GLN A 228      43.175  52.399  39.005  1.00 15.19           C  
ATOM   1245  CG  GLN A 228      43.204  53.883  39.335  1.00 16.16           C  
ATOM   1246  CD  GLN A 228      42.638  54.173  40.713  1.00 17.77           C  
ATOM   1247  OE1 GLN A 228      41.532  53.746  41.040  1.00 18.78           O  
ATOM   1248  NE2 GLN A 228      43.394  54.903  41.526  1.00 18.64           N  
ATOM   1249  N   THR A 229      44.263  49.442  38.849  1.00 15.57           N  
ATOM   1250  CA  THR A 229      44.013  48.041  38.548  1.00 16.25           C  
ATOM   1251  C   THR A 229      44.478  47.147  39.695  1.00 17.84           C  
ATOM   1252  O   THR A 229      43.795  46.190  40.057  1.00 17.94           O  
ATOM   1253  CB  THR A 229      44.700  47.632  37.235  1.00 15.90           C  
ATOM   1254  OG1 THR A 229      44.220  48.476  36.179  1.00 16.85           O  
ATOM   1255  CG2 THR A 229      44.384  46.179  36.888  1.00 16.20           C  
ATOM   1256  N   MET A 230      45.637  47.456  40.272  1.00 17.87           N  
ATOM   1257  CA  MET A 230      46.134  46.663  41.391  1.00 20.27           C  
ATOM   1258  C   MET A 230      45.175  46.776  42.571  1.00 19.85           C  
ATOM   1259  O   MET A 230      44.914  45.793  43.263  1.00 21.38           O  
ATOM   1260  CB  MET A 230      47.526  47.134  41.823  1.00 22.59           C  
ATOM   1261  CG  MET A 230      48.662  46.651  40.937  1.00 25.58           C  
ATOM   1262  SD  MET A 230      48.746  44.848  40.822  1.00 30.18           S  
ATOM   1263  CE  MET A 230      48.675  44.391  42.529  1.00 28.41           C  
ATOM   1264  N   GLN A 231      44.649  47.977  42.800  1.00 19.82           N  
ATOM   1265  CA  GLN A 231      43.723  48.193  43.910  1.00 21.74           C  
ATOM   1266  C   GLN A 231      42.444  47.392  43.707  1.00 21.37           C  
ATOM   1267  O   GLN A 231      41.896  46.828  44.656  1.00 22.09           O  
ATOM   1268  CB  GLN A 231      43.397  49.682  44.051  1.00 22.89           C  
ATOM   1269  CG  GLN A 231      44.599  50.525  44.459  1.00 27.56           C  
ATOM   1270  CD  GLN A 231      44.263  51.991  44.658  1.00 29.37           C  
ATOM   1271  OE1 GLN A 231      45.153  52.824  44.838  1.00 33.59           O  
ATOM   1272  NE2 GLN A 231      42.977  52.314  44.631  1.00 29.97           N  
ATOM   1273  N   MET A 232      41.977  47.347  42.463  1.00 19.73           N  
ATOM   1274  CA  MET A 232      40.772  46.602  42.120  1.00 20.68           C  
ATOM   1275  C   MET A 232      40.996  45.113  42.360  1.00 21.31           C  
ATOM   1276  O   MET A 232      40.188  44.442  43.008  1.00 20.73           O  
ATOM   1277  CB  MET A 232      40.414  46.835  40.651  1.00 19.89           C  
ATOM   1278  CG  MET A 232      39.238  46.006  40.164  1.00 20.28           C  
ATOM   1279  SD  MET A 232      38.956  46.205  38.400  1.00 20.28           S  
ATOM   1280  CE  MET A 232      40.331  45.251  37.733  1.00 21.60           C  
ATOM   1281  N   LEU A 233      42.106  44.598  41.838  1.00 21.04           N  
ATOM   1282  CA  LEU A 233      42.437  43.189  41.993  1.00 22.59           C  
ATOM   1283  C   LEU A 233      42.671  42.812  43.453  1.00 23.20           C  
ATOM   1284  O   LEU A 233      42.241  41.748  43.898  1.00 24.43           O  
ATOM   1285  CB  LEU A 233      43.675  42.845  41.160  1.00 21.93           C  
ATOM   1286  CG  LEU A 233      43.509  43.023  39.649  1.00 22.89           C  
ATOM   1287  CD1 LEU A 233      44.838  42.758  38.956  1.00 23.74           C  
ATOM   1288  CD2 LEU A 233      42.435  42.075  39.129  1.00 21.75           C  
ATOM   1289  N   ASN A 234      43.351  43.678  44.199  1.00 24.85           N  
ATOM   1290  CA  ASN A 234      43.617  43.398  45.604  1.00 26.71           C  
ATOM   1291  C   ASN A 234      42.320  43.374  46.411  1.00 28.26           C  
ATOM   1292  O   ASN A 234      42.268  42.788  47.494  1.00 28.50           O  
ATOM   1293  CB  ASN A 234      44.580  44.433  46.199  1.00 27.74           C  
ATOM   1294  CG  ASN A 234      45.984  44.327  45.621  1.00 29.47           C  
ATOM   1295  OD1 ASN A 234      46.420  43.253  45.210  1.00 30.16           O  
ATOM   1296  ND2 ASN A 234      46.703  45.444  45.608  1.00 30.77           N  
ATOM   1297  N   GLU A 235      41.277  44.010  45.879  1.00 27.99           N  
ATOM   1298  CA  GLU A 235      39.969  44.051  46.536  1.00 29.61           C  
ATOM   1299  C   GLU A 235      39.196  42.760  46.305  1.00 28.86           C  
ATOM   1300  O   GLU A 235      38.157  42.530  46.926  1.00 29.72           O  
ATOM   1301  CB  GLU A 235      39.118  45.205  45.995  1.00 31.67           C  
ATOM   1302  CG  GLU A 235      39.415  46.570  46.568  1.00 35.64           C  
ATOM   1303  CD  GLU A 235      38.342  47.578  46.200  1.00 37.30           C  
ATOM   1304  OE1 GLU A 235      38.137  47.824  44.991  1.00 37.71           O  
ATOM   1305  OE2 GLU A 235      37.696  48.119  47.120  1.00 40.13           O  
ATOM   1306  N   GLY A 236      39.690  41.927  45.397  1.00 27.47           N  
ATOM   1307  CA  GLY A 236      39.006  40.684  45.103  1.00 26.70           C  
ATOM   1308  C   GLY A 236      38.072  40.831  43.916  1.00 26.10           C  
ATOM   1309  O   GLY A 236      37.301  39.924  43.604  1.00 26.49           O  
ATOM   1310  N   ILE A 237      38.133  41.983  43.253  1.00 23.70           N  
ATOM   1311  CA  ILE A 237      37.297  42.230  42.086  1.00 22.32           C  
ATOM   1312  C   ILE A 237      38.104  41.853  40.851  1.00 22.36           C  
ATOM   1313  O   ILE A 237      39.055  42.545  40.485  1.00 22.19           O  
ATOM   1314  CB  ILE A 237      36.876  43.710  42.004  1.00 22.03           C  
ATOM   1315  CG1 ILE A 237      36.061  44.077  43.247  1.00 23.76           C  
ATOM   1316  CG2 ILE A 237      36.064  43.955  40.736  1.00 21.80           C  
ATOM   1317  CD1 ILE A 237      35.605  45.524  43.293  1.00 25.62           C  
ATOM   1318  N   VAL A 238      37.724  40.748  40.219  1.00 21.64           N  
ATOM   1319  CA  VAL A 238      38.433  40.262  39.042  1.00 22.04           C  
ATOM   1320  C   VAL A 238      37.516  40.151  37.834  1.00 21.46           C  
ATOM   1321  O   VAL A 238      36.798  39.163  37.663  1.00 22.35           O  
ATOM   1322  CB  VAL A 238      39.069  38.874  39.312  1.00 23.30           C  
ATOM   1323  CG1 VAL A 238      39.962  38.468  38.149  1.00 23.98           C  
ATOM   1324  CG2 VAL A 238      39.860  38.910  40.607  1.00 23.98           C  
ATOM   1325  N   PRO A 239      37.524  41.174  36.972  1.00 19.23           N  
ATOM   1326  CA  PRO A 239      36.675  41.147  35.782  1.00 18.31           C  
ATOM   1327  C   PRO A 239      37.324  40.253  34.734  1.00 18.26           C  
ATOM   1328  O   PRO A 239      38.469  39.837  34.899  1.00 19.22           O  
ATOM   1329  CB  PRO A 239      36.658  42.607  35.352  1.00 19.56           C  
ATOM   1330  CG  PRO A 239      38.075  43.029  35.652  1.00 19.39           C  
ATOM   1331  CD  PRO A 239      38.307  42.424  37.034  1.00 20.85           C  
ATOM   1332  N   THR A 240      36.594  39.941  33.670  1.00 17.29           N  
ATOM   1333  CA  THR A 240      37.166  39.142  32.599  1.00 17.06           C  
ATOM   1334  C   THR A 240      37.649  40.110  31.521  1.00 16.47           C  
ATOM   1335  O   THR A 240      38.406  39.737  30.632  1.00 16.34           O  
ATOM   1336  CB  THR A 240      36.147  38.146  31.993  1.00 17.74           C  
ATOM   1337  OG1 THR A 240      34.992  38.848  31.519  1.00 17.85           O  
ATOM   1338  CG2 THR A 240      35.732  37.113  33.035  1.00 17.69           C  
ATOM   1339  N   ALA A 241      37.216  41.365  31.618  1.00 17.17           N  
ATOM   1340  CA  ALA A 241      37.621  42.378  30.649  1.00 17.07           C  
ATOM   1341  C   ALA A 241      37.590  43.781  31.243  1.00 15.91           C  
ATOM   1342  O   ALA A 241      36.819  44.069  32.161  1.00 14.98           O  
ATOM   1343  CB  ALA A 241      36.721  42.316  29.415  1.00 17.56           C  
ATOM   1344  N   MET A 242      38.438  44.651  30.705  1.00 14.94           N  
ATOM   1345  CA  MET A 242      38.520  46.030  31.161  1.00 15.16           C  
ATOM   1346  C   MET A 242      38.508  47.001  29.989  1.00 14.80           C  
ATOM   1347  O   MET A 242      39.170  46.773  28.978  1.00 15.64           O  
ATOM   1348  CB  MET A 242      39.817  46.263  31.949  1.00 15.67           C  
ATOM   1349  CG  MET A 242      39.949  45.500  33.255  1.00 17.92           C  
ATOM   1350  SD  MET A 242      41.540  45.865  34.044  1.00 18.83           S  
ATOM   1351  CE  MET A 242      41.247  47.497  34.693  1.00 18.92           C  
ATOM   1352  N   LEU A 243      37.734  48.075  30.124  1.00 12.63           N  
ATOM   1353  CA  LEU A 243      37.701  49.134  29.121  1.00 12.76           C  
ATOM   1354  C   LEU A 243      38.530  50.229  29.788  1.00 13.10           C  
ATOM   1355  O   LEU A 243      38.186  50.696  30.874  1.00 12.93           O  
ATOM   1356  CB  LEU A 243      36.262  49.614  28.884  1.00 13.08           C  
ATOM   1357  CG  LEU A 243      35.433  48.679  28.003  1.00 14.55           C  
ATOM   1358  CD1 LEU A 243      33.945  48.979  28.177  1.00 15.13           C  
ATOM   1359  CD2 LEU A 243      35.858  48.837  26.550  1.00 14.95           C  
ATOM   1360  N   VAL A 244      39.636  50.620  29.157  1.00 12.51           N  
ATOM   1361  CA  VAL A 244      40.522  51.635  29.728  1.00 13.74           C  
ATOM   1362  C   VAL A 244      40.524  52.906  28.875  1.00 12.43           C  
ATOM   1363  O   VAL A 244      40.536  52.839  27.646  1.00 12.68           O  
ATOM   1364  CB  VAL A 244      41.951  51.064  29.874  1.00 13.34           C  
ATOM   1365  CG1 VAL A 244      42.844  52.060  30.594  1.00 14.64           C  
ATOM   1366  CG2 VAL A 244      41.893  49.748  30.645  1.00 17.01           C  
ATOM   1367  N   ALA A 245      40.525  54.060  29.545  1.00 13.04           N  
ATOM   1368  CA  ALA A 245      40.427  55.361  28.888  1.00 12.38           C  
ATOM   1369  C   ALA A 245      41.514  55.772  27.898  1.00 12.29           C  
ATOM   1370  O   ALA A 245      41.283  56.647  27.069  1.00 12.99           O  
ATOM   1371  CB  ALA A 245      40.227  56.455  29.940  1.00 15.40           C  
ATOM   1372  N   ASN A 246      42.701  55.188  28.002  1.00 12.69           N  
ATOM   1373  CA  ASN A 246      43.734  55.483  27.015  1.00 12.16           C  
ATOM   1374  C   ASN A 246      44.769  54.378  27.023  1.00 12.14           C  
ATOM   1375  O   ASN A 246      44.775  53.533  27.916  1.00 12.71           O  
ATOM   1376  CB  ASN A 246      44.334  56.900  27.199  1.00 12.76           C  
ATOM   1377  CG  ASN A 246      45.376  56.992  28.302  1.00 11.82           C  
ATOM   1378  OD1 ASN A 246      45.472  56.135  29.171  1.00 16.14           O  
ATOM   1379  ND2 ASN A 246      46.156  58.077  28.274  1.00 14.67           N  
ATOM   1380  N   ASP A 247      45.619  54.351  26.006  1.00 11.82           N  
ATOM   1381  CA  ASP A 247      46.604  53.290  25.903  1.00 13.30           C  
ATOM   1382  C   ASP A 247      47.635  53.260  27.022  1.00 11.54           C  
ATOM   1383  O   ASP A 247      48.042  52.186  27.455  1.00 12.93           O  
ATOM   1384  CB  ASP A 247      47.297  53.355  24.539  1.00 13.18           C  
ATOM   1385  CG  ASP A 247      46.354  53.036  23.392  1.00 15.60           C  
ATOM   1386  OD1 ASP A 247      45.265  52.470  23.650  1.00 15.04           O  
ATOM   1387  OD2 ASP A 247      46.701  53.335  22.231  1.00 16.73           O  
ATOM   1388  N   GLN A 248      48.057  54.424  27.498  1.00 13.03           N  
ATOM   1389  CA  GLN A 248      49.040  54.449  28.571  1.00 14.36           C  
ATOM   1390  C   GLN A 248      48.469  53.872  29.862  1.00 13.60           C  
ATOM   1391  O   GLN A 248      49.141  53.109  30.546  1.00 13.00           O  
ATOM   1392  CB  GLN A 248      49.554  55.869  28.783  1.00 15.34           C  
ATOM   1393  CG  GLN A 248      50.499  56.313  27.679  1.00 18.85           C  
ATOM   1394  CD  GLN A 248      50.674  57.808  27.638  1.00 20.17           C  
ATOM   1395  OE1 GLN A 248      49.767  58.536  27.241  1.00 22.75           O  
ATOM   1396  NE2 GLN A 248      51.842  58.282  28.059  1.00 22.74           N  
ATOM   1397  N   MET A 249      47.232  54.221  30.204  1.00 14.04           N  
ATOM   1398  CA  MET A 249      46.656  53.645  31.410  1.00 13.38           C  
ATOM   1399  C   MET A 249      46.460  52.151  31.178  1.00 13.09           C  
ATOM   1400  O   MET A 249      46.562  51.357  32.111  1.00 13.75           O  
ATOM   1401  CB  MET A 249      45.319  54.309  31.760  1.00 12.76           C  
ATOM   1402  CG  MET A 249      45.469  55.741  32.233  1.00 13.93           C  
ATOM   1403  SD  MET A 249      43.967  56.367  33.003  1.00 18.06           S  
ATOM   1404  CE  MET A 249      42.935  56.525  31.616  1.00 22.58           C  
ATOM   1405  N   ALA A 250      46.188  51.766  29.933  1.00 12.56           N  
ATOM   1406  CA  ALA A 250      45.998  50.350  29.617  1.00 12.85           C  
ATOM   1407  C   ALA A 250      47.305  49.600  29.843  1.00 12.60           C  
ATOM   1408  O   ALA A 250      47.302  48.460  30.303  1.00 12.46           O  
ATOM   1409  CB  ALA A 250      45.528  50.174  28.173  1.00 12.72           C  
ATOM   1410  N   LEU A 251      48.424  50.239  29.509  1.00 13.83           N  
ATOM   1411  CA  LEU A 251      49.733  49.624  29.707  1.00 14.41           C  
ATOM   1412  C   LEU A 251      49.902  49.326  31.196  1.00 14.03           C  
ATOM   1413  O   LEU A 251      50.374  48.251  31.580  1.00 15.56           O  
ATOM   1414  CB  LEU A 251      50.841  50.577  29.246  1.00 13.63           C  
ATOM   1415  CG  LEU A 251      52.283  50.120  29.514  1.00 16.74           C  
ATOM   1416  CD1 LEU A 251      52.637  48.955  28.599  1.00 18.08           C  
ATOM   1417  CD2 LEU A 251      53.230  51.287  29.270  1.00 15.90           C  
ATOM   1418  N   GLY A 252      49.519  50.292  32.025  1.00 13.59           N  
ATOM   1419  CA  GLY A 252      49.620  50.127  33.462  1.00 14.13           C  
ATOM   1420  C   GLY A 252      48.735  48.991  33.942  1.00 14.20           C  
ATOM   1421  O   GLY A 252      49.142  48.189  34.776  1.00 13.91           O  
ATOM   1422  N   ALA A 253      47.517  48.925  33.413  1.00 14.76           N  
ATOM   1423  CA  ALA A 253      46.581  47.868  33.789  1.00 15.29           C  
ATOM   1424  C   ALA A 253      47.152  46.511  33.407  1.00 15.22           C  
ATOM   1425  O   ALA A 253      47.079  45.554  34.175  1.00 15.57           O  
ATOM   1426  CB  ALA A 253      45.239  48.084  33.091  1.00 14.18           C  
ATOM   1427  N   MET A 254      47.722  46.433  32.209  1.00 14.61           N  
ATOM   1428  CA  MET A 254      48.304  45.190  31.726  1.00 15.02           C  
ATOM   1429  C   MET A 254      49.436  44.734  32.641  1.00 14.87           C  
ATOM   1430  O   MET A 254      49.581  43.541  32.913  1.00 16.60           O  
ATOM   1431  CB  MET A 254      48.807  45.381  30.295  1.00 16.48           C  
ATOM   1432  CG  MET A 254      47.679  45.503  29.276  1.00 17.54           C  
ATOM   1433  SD  MET A 254      48.240  46.067  27.661  1.00 19.60           S  
ATOM   1434  CE  MET A 254      49.384  44.752  27.236  1.00 20.97           C  
ATOM   1435  N   ARG A 255      50.235  45.680  33.121  1.00 15.53           N  
ATOM   1436  CA  ARG A 255      51.321  45.327  34.023  1.00 16.01           C  
ATOM   1437  C   ARG A 255      50.745  44.798  35.337  1.00 16.68           C  
ATOM   1438  O   ARG A 255      51.233  43.809  35.880  1.00 16.91           O  
ATOM   1439  CB  ARG A 255      52.217  46.534  34.316  1.00 15.67           C  
ATOM   1440  CG  ARG A 255      53.303  46.202  35.332  1.00 16.42           C  
ATOM   1441  CD  ARG A 255      54.124  47.404  35.767  1.00 16.60           C  
ATOM   1442  NE  ARG A 255      54.791  47.102  37.033  1.00 18.48           N  
ATOM   1443  CZ  ARG A 255      55.069  47.998  37.973  1.00 18.53           C  
ATOM   1444  NH1 ARG A 255      54.753  49.273  37.801  1.00 19.71           N  
ATOM   1445  NH2 ARG A 255      55.629  47.606  39.111  1.00 21.55           N  
ATOM   1446  N   ALA A 256      49.702  45.451  35.839  1.00 16.87           N  
ATOM   1447  CA  ALA A 256      49.078  45.026  37.092  1.00 17.01           C  
ATOM   1448  C   ALA A 256      48.539  43.606  36.951  1.00 18.01           C  
ATOM   1449  O   ALA A 256      48.751  42.757  37.818  1.00 19.16           O  
ATOM   1450  CB  ALA A 256      47.947  45.983  37.468  1.00 16.94           C  
ATOM   1451  N   ILE A 257      47.837  43.358  35.852  1.00 18.13           N  
ATOM   1452  CA  ILE A 257      47.267  42.044  35.578  1.00 17.83           C  
ATOM   1453  C   ILE A 257      48.363  40.981  35.562  1.00 19.84           C  
ATOM   1454  O   ILE A 257      48.266  39.953  36.235  1.00 18.80           O  
ATOM   1455  CB  ILE A 257      46.543  42.045  34.213  1.00 18.66           C  
ATOM   1456  CG1 ILE A 257      45.310  42.953  34.285  1.00 18.47           C  
ATOM   1457  CG2 ILE A 257      46.144  40.627  33.819  1.00 19.26           C  
ATOM   1458  CD1 ILE A 257      44.716  43.297  32.932  1.00 17.67           C  
ATOM   1459  N   THR A 258      49.417  41.251  34.801  1.00 18.63           N  
ATOM   1460  CA  THR A 258      50.528  40.318  34.670  1.00 20.29           C  
ATOM   1461  C   THR A 258      51.248  40.037  35.988  1.00 21.10           C  
ATOM   1462  O   THR A 258      51.529  38.883  36.308  1.00 22.69           O  
ATOM   1463  CB  THR A 258      51.549  40.838  33.641  1.00 20.16           C  
ATOM   1464  OG1 THR A 258      50.884  41.081  32.395  1.00 20.93           O  
ATOM   1465  CG2 THR A 258      52.655  39.813  33.420  1.00 21.66           C  
ATOM   1466  N   GLU A 259      51.543  41.082  36.753  1.00 22.03           N  
ATOM   1467  CA  GLU A 259      52.242  40.898  38.017  1.00 23.79           C  
ATOM   1468  C   GLU A 259      51.360  40.227  39.064  1.00 25.67           C  
ATOM   1469  O   GLU A 259      51.858  39.731  40.077  1.00 26.58           O  
ATOM   1470  CB  GLU A 259      52.775  42.238  38.536  1.00 25.16           C  
ATOM   1471  CG  GLU A 259      53.674  42.950  37.526  1.00 24.38           C  
ATOM   1472  CD  GLU A 259      54.546  44.032  38.139  1.00 25.22           C  
ATOM   1473  OE1 GLU A 259      54.143  44.636  39.154  1.00 22.50           O  
ATOM   1474  OE2 GLU A 259      55.637  44.291  37.584  1.00 24.68           O  
ATOM   1475  N   SER A 260      50.053  40.203  38.813  1.00 24.24           N  
ATOM   1476  CA  SER A 260      49.114  39.570  39.732  1.00 25.76           C  
ATOM   1477  C   SER A 260      49.006  38.080  39.419  1.00 26.34           C  
ATOM   1478  O   SER A 260      48.212  37.360  40.028  1.00 27.63           O  
ATOM   1479  CB  SER A 260      47.732  40.222  39.621  1.00 24.70           C  
ATOM   1480  OG  SER A 260      47.758  41.552  40.108  1.00 25.24           O  
ATOM   1481  N   GLY A 261      49.803  37.627  38.457  1.00 26.32           N  
ATOM   1482  CA  GLY A 261      49.794  36.224  38.082  1.00 25.49           C  
ATOM   1483  C   GLY A 261      48.728  35.847  37.073  1.00 25.44           C  
ATOM   1484  O   GLY A 261      48.408  34.669  36.918  1.00 26.52           O  
ATOM   1485  N   LEU A 262      48.178  36.841  36.381  1.00 23.73           N  
ATOM   1486  CA  LEU A 262      47.144  36.592  35.382  1.00 24.23           C  
ATOM   1487  C   LEU A 262      47.645  36.918  33.981  1.00 23.81           C  
ATOM   1488  O   LEU A 262      48.627  37.641  33.810  1.00 24.93           O  
ATOM   1489  CB  LEU A 262      45.897  37.425  35.692  1.00 23.53           C  
ATOM   1490  CG  LEU A 262      45.222  37.134  37.035  1.00 24.20           C  
ATOM   1491  CD1 LEU A 262      44.040  38.076  37.226  1.00 25.27           C  
ATOM   1492  CD2 LEU A 262      44.761  35.683  37.076  1.00 25.46           C  
ATOM   1493  N   ARG A 263      46.962  36.383  32.978  1.00 23.43           N  
ATOM   1494  CA  ARG A 263      47.344  36.612  31.592  1.00 22.90           C  
ATOM   1495  C   ARG A 263      46.477  37.669  30.928  1.00 22.84           C  
ATOM   1496  O   ARG A 263      45.249  37.583  30.955  1.00 20.93           O  
ATOM   1497  CB  ARG A 263      47.230  35.311  30.798  1.00 25.43           C  
ATOM   1498  CG  ARG A 263      48.158  34.203  31.267  1.00 27.91           C  
ATOM   1499  CD  ARG A 263      47.735  32.876  30.663  1.00 29.90           C  
ATOM   1500  NE  ARG A 263      46.406  32.484  31.125  1.00 32.48           N  
ATOM   1501  CZ  ARG A 263      45.726  31.441  30.661  1.00 32.33           C  
ATOM   1502  NH1 ARG A 263      46.248  30.673  29.714  1.00 33.80           N  
ATOM   1503  NH2 ARG A 263      44.522  31.166  31.143  1.00 32.67           N  
ATOM   1504  N   VAL A 264      47.114  38.675  30.339  1.00 21.15           N  
ATOM   1505  CA  VAL A 264      46.362  39.704  29.632  1.00 20.81           C  
ATOM   1506  C   VAL A 264      45.800  38.994  28.408  1.00 22.21           C  
ATOM   1507  O   VAL A 264      46.534  38.323  27.681  1.00 22.64           O  
ATOM   1508  CB  VAL A 264      47.270  40.865  29.182  1.00 19.74           C  
ATOM   1509  CG1 VAL A 264      46.479  41.851  28.328  1.00 20.28           C  
ATOM   1510  CG2 VAL A 264      47.848  41.566  30.393  1.00 19.57           C  
ATOM   1511  N   GLY A 265      44.497  39.128  28.193  1.00 22.34           N  
ATOM   1512  CA  GLY A 265      43.864  38.472  27.067  1.00 23.05           C  
ATOM   1513  C   GLY A 265      43.152  37.203  27.505  1.00 24.88           C  
ATOM   1514  O   GLY A 265      41.926  37.166  27.594  1.00 25.77           O  
ATOM   1515  N   ALA A 266      43.925  36.162  27.801  1.00 24.94           N  
ATOM   1516  CA  ALA A 266      43.369  34.880  28.219  1.00 25.53           C  
ATOM   1517  C   ALA A 266      42.582  34.941  29.529  1.00 25.42           C  
ATOM   1518  O   ALA A 266      41.530  34.318  29.654  1.00 26.21           O  
ATOM   1519  CB  ALA A 266      44.485  33.847  28.331  1.00 26.73           C  
ATOM   1520  N   ASP A 267      43.094  35.683  30.507  1.00 23.81           N  
ATOM   1521  CA  ASP A 267      42.422  35.803  31.797  1.00 22.87           C  
ATOM   1522  C   ASP A 267      41.630  37.100  31.895  1.00 21.59           C  
ATOM   1523  O   ASP A 267      40.461  37.093  32.275  1.00 21.21           O  
ATOM   1524  CB  ASP A 267      43.446  35.716  32.932  1.00 23.77           C  
ATOM   1525  CG  ASP A 267      44.047  34.326  33.066  1.00 24.54           C  
ATOM   1526  OD1 ASP A 267      45.210  34.215  33.504  1.00 25.14           O  
ATOM   1527  OD2 ASP A 267      43.348  33.340  32.741  1.00 26.04           O  
ATOM   1528  N   ILE A 268      42.270  38.216  31.563  1.00 20.11           N  
ATOM   1529  CA  ILE A 268      41.593  39.505  31.599  1.00 18.18           C  
ATOM   1530  C   ILE A 268      41.881  40.267  30.314  1.00 19.25           C  
ATOM   1531  O   ILE A 268      43.026  40.638  30.045  1.00 18.31           O  
ATOM   1532  CB  ILE A 268      42.050  40.365  32.794  1.00 17.56           C  
ATOM   1533  CG1 ILE A 268      41.731  39.647  34.109  1.00 16.74           C  
ATOM   1534  CG2 ILE A 268      41.344  41.723  32.753  1.00 17.44           C  
ATOM   1535  CD1 ILE A 268      42.078  40.444  35.347  1.00 18.99           C  
ATOM   1536  N   SER A 269      40.841  40.482  29.515  1.00 16.34           N  
ATOM   1537  CA  SER A 269      40.986  41.211  28.261  1.00 16.48           C  
ATOM   1538  C   SER A 269      41.064  42.701  28.547  1.00 16.45           C  
ATOM   1539  O   SER A 269      40.502  43.190  29.531  1.00 15.43           O  
ATOM   1540  CB  SER A 269      39.807  40.924  27.327  1.00 17.60           C  
ATOM   1541  OG  SER A 269      39.872  39.606  26.813  1.00 18.52           O  
ATOM   1542  N   VAL A 270      41.760  43.425  27.679  1.00 15.16           N  
ATOM   1543  CA  VAL A 270      41.923  44.857  27.861  1.00 15.26           C  
ATOM   1544  C   VAL A 270      41.758  45.608  26.554  1.00 15.82           C  
ATOM   1545  O   VAL A 270      42.292  45.201  25.519  1.00 16.11           O  
ATOM   1546  CB  VAL A 270      43.333  45.184  28.435  1.00 15.82           C  
ATOM   1547  CG1 VAL A 270      43.504  46.685  28.588  1.00 14.63           C  
ATOM   1548  CG2 VAL A 270      43.528  44.486  29.772  1.00 16.77           C  
ATOM   1549  N   VAL A 271      40.998  46.700  26.600  1.00 13.50           N  
ATOM   1550  CA  VAL A 271      40.806  47.544  25.430  1.00 13.44           C  
ATOM   1551  C   VAL A 271      41.289  48.937  25.821  1.00 14.83           C  
ATOM   1552  O   VAL A 271      40.874  49.482  26.844  1.00 14.96           O  
ATOM   1553  CB  VAL A 271      39.321  47.630  25.010  1.00 14.57           C  
ATOM   1554  CG1 VAL A 271      39.181  48.528  23.795  1.00 13.65           C  
ATOM   1555  CG2 VAL A 271      38.789  46.244  24.703  1.00 15.86           C  
ATOM   1556  N   GLY A 272      42.190  49.497  25.020  1.00 14.33           N  
ATOM   1557  CA  GLY A 272      42.698  50.825  25.307  1.00 14.21           C  
ATOM   1558  C   GLY A 272      41.974  51.881  24.496  1.00 14.49           C  
ATOM   1559  O   GLY A 272      40.858  51.656  24.021  1.00 14.08           O  
ATOM   1560  N   TYR A 273      42.603  53.043  24.333  1.00 12.42           N  
ATOM   1561  CA  TYR A 273      41.994  54.124  23.567  1.00 13.26           C  
ATOM   1562  C   TYR A 273      43.084  55.090  23.104  1.00 15.19           C  
ATOM   1563  O   TYR A 273      43.872  55.563  23.921  1.00 15.52           O  
ATOM   1564  CB  TYR A 273      40.968  54.863  24.444  1.00 14.06           C  
ATOM   1565  CG  TYR A 273      39.769  55.433  23.707  1.00 14.94           C  
ATOM   1566  CD1 TYR A 273      39.899  56.518  22.837  1.00 14.25           C  
ATOM   1567  CD2 TYR A 273      38.494  54.893  23.896  1.00 16.29           C  
ATOM   1568  CE1 TYR A 273      38.786  57.055  22.179  1.00 15.38           C  
ATOM   1569  CE2 TYR A 273      37.382  55.421  23.246  1.00 15.69           C  
ATOM   1570  CZ  TYR A 273      37.531  56.499  22.392  1.00 15.56           C  
ATOM   1571  OH  TYR A 273      36.417  57.027  21.770  1.00 17.50           O  
ATOM   1572  N   ASP A 274      43.108  55.346  21.791  1.00 13.79           N  
ATOM   1573  CA  ASP A 274      44.041  56.250  21.104  1.00 16.25           C  
ATOM   1574  C   ASP A 274      44.758  55.611  19.915  1.00 15.18           C  
ATOM   1575  O   ASP A 274      44.809  56.186  18.829  1.00 14.37           O  
ATOM   1576  CB  ASP A 274      45.140  56.789  22.034  1.00 16.53           C  
ATOM   1577  CG  ASP A 274      44.649  57.873  22.976  1.00 18.70           C  
ATOM   1578  OD1 ASP A 274      43.536  58.403  22.777  1.00 19.90           O  
ATOM   1579  OD2 ASP A 274      45.400  58.204  23.917  1.00 19.97           O  
ATOM   1580  N   ASP A 275      45.295  54.419  20.146  1.00 15.77           N  
ATOM   1581  CA  ASP A 275      46.103  53.678  19.177  1.00 17.38           C  
ATOM   1582  C   ASP A 275      47.411  54.436  19.018  1.00 18.06           C  
ATOM   1583  O   ASP A 275      47.746  54.930  17.936  1.00 17.07           O  
ATOM   1584  CB  ASP A 275      45.434  53.515  17.803  1.00 18.32           C  
ATOM   1585  CG  ASP A 275      46.286  52.676  16.850  1.00 21.46           C  
ATOM   1586  OD1 ASP A 275      47.115  51.888  17.353  1.00 20.79           O  
ATOM   1587  OD2 ASP A 275      46.139  52.789  15.613  1.00 21.27           O  
ATOM   1588  N   THR A 276      48.136  54.551  20.125  1.00 18.46           N  
ATOM   1589  CA  THR A 276      49.422  55.233  20.117  1.00 18.41           C  
ATOM   1590  C   THR A 276      50.400  54.369  19.340  1.00 18.51           C  
ATOM   1591  O   THR A 276      50.191  53.168  19.181  1.00 17.88           O  
ATOM   1592  CB  THR A 276      49.971  55.417  21.541  1.00 20.97           C  
ATOM   1593  OG1 THR A 276      50.245  54.132  22.116  1.00 20.13           O  
ATOM   1594  CG2 THR A 276      48.961  56.148  22.411  1.00 20.17           C  
ATOM   1595  N   GLU A 277      51.473  54.980  18.852  1.00 20.33           N  
ATOM   1596  CA  GLU A 277      52.476  54.242  18.103  1.00 22.96           C  
ATOM   1597  C   GLU A 277      53.009  53.091  18.950  1.00 21.78           C  
ATOM   1598  O   GLU A 277      53.185  51.978  18.457  1.00 23.72           O  
ATOM   1599  CB  GLU A 277      53.609  55.189  17.707  1.00 27.37           C  
ATOM   1600  CG  GLU A 277      53.116  56.401  16.931  1.00 34.22           C  
ATOM   1601  CD  GLU A 277      54.127  57.530  16.886  1.00 38.69           C  
ATOM   1602  OE1 GLU A 277      55.234  57.314  16.352  1.00 41.32           O  
ATOM   1603  OE2 GLU A 277      53.809  58.634  17.388  1.00 40.66           O  
ATOM   1604  N   ASP A 278      53.243  53.356  20.231  1.00 19.76           N  
ATOM   1605  CA  ASP A 278      53.761  52.339  21.145  1.00 19.45           C  
ATOM   1606  C   ASP A 278      52.820  51.156  21.371  1.00 18.76           C  
ATOM   1607  O   ASP A 278      53.278  50.042  21.621  1.00 17.79           O  
ATOM   1608  CB  ASP A 278      54.062  52.947  22.521  1.00 20.52           C  
ATOM   1609  CG  ASP A 278      55.224  53.922  22.507  1.00 22.55           C  
ATOM   1610  OD1 ASP A 278      55.443  54.572  23.549  1.00 24.35           O  
ATOM   1611  OD2 ASP A 278      55.914  54.038  21.474  1.00 21.87           O  
ATOM   1612  N   SER A 279      51.512  51.391  21.291  1.00 17.22           N  
ATOM   1613  CA  SER A 279      50.546  50.331  21.567  1.00 17.16           C  
ATOM   1614  C   SER A 279      50.710  49.052  20.755  1.00 17.28           C  
ATOM   1615  O   SER A 279      50.355  47.973  21.224  1.00 16.94           O  
ATOM   1616  CB  SER A 279      49.107  50.860  21.425  1.00 17.35           C  
ATOM   1617  OG  SER A 279      48.777  51.146  20.081  1.00 19.59           O  
ATOM   1618  N   SER A 280      51.251  49.162  19.547  1.00 17.55           N  
ATOM   1619  CA  SER A 280      51.444  47.989  18.707  1.00 18.42           C  
ATOM   1620  C   SER A 280      52.563  47.105  19.252  1.00 19.43           C  
ATOM   1621  O   SER A 280      52.716  45.955  18.837  1.00 19.96           O  
ATOM   1622  CB  SER A 280      51.785  48.416  17.279  1.00 21.84           C  
ATOM   1623  OG  SER A 280      53.005  49.137  17.251  1.00 22.51           O  
ATOM   1624  N   CYS A 281      53.347  47.642  20.181  1.00 18.29           N  
ATOM   1625  CA  CYS A 281      54.448  46.878  20.752  1.00 18.23           C  
ATOM   1626  C   CYS A 281      54.323  46.590  22.241  1.00 18.21           C  
ATOM   1627  O   CYS A 281      55.299  46.232  22.896  1.00 17.16           O  
ATOM   1628  CB  CYS A 281      55.780  47.568  20.447  1.00 18.49           C  
ATOM   1629  SG  CYS A 281      56.242  47.415  18.710  1.00 20.05           S  
ATOM   1630  N   TYR A 282      53.124  46.762  22.789  1.00 17.36           N  
ATOM   1631  CA  TYR A 282      52.927  46.434  24.191  1.00 17.76           C  
ATOM   1632  C   TYR A 282      52.978  44.914  24.236  1.00 17.49           C  
ATOM   1633  O   TYR A 282      52.935  44.260  23.193  1.00 18.45           O  
ATOM   1634  CB  TYR A 282      51.560  46.919  24.691  1.00 17.12           C  
ATOM   1635  CG  TYR A 282      51.471  48.405  24.954  1.00 19.43           C  
ATOM   1636  CD1 TYR A 282      52.595  49.228  24.848  1.00 21.82           C  
ATOM   1637  CD2 TYR A 282      50.266  48.987  25.353  1.00 20.23           C  
ATOM   1638  CE1 TYR A 282      52.520  50.585  25.138  1.00 22.47           C  
ATOM   1639  CE2 TYR A 282      50.182  50.341  25.644  1.00 20.49           C  
ATOM   1640  CZ  TYR A 282      51.309  51.134  25.537  1.00 23.79           C  
ATOM   1641  OH  TYR A 282      51.234  52.470  25.844  1.00 24.19           O  
ATOM   1642  N   ILE A 283      53.065  44.350  25.434  1.00 17.35           N  
ATOM   1643  CA  ILE A 283      53.124  42.903  25.578  1.00 19.29           C  
ATOM   1644  C   ILE A 283      51.918  42.370  26.344  1.00 19.72           C  
ATOM   1645  O   ILE A 283      51.853  42.490  27.567  1.00 20.27           O  
ATOM   1646  CB  ILE A 283      54.407  42.475  26.321  1.00 20.25           C  
ATOM   1647  CG1 ILE A 283      55.636  42.996  25.570  1.00 21.78           C  
ATOM   1648  CG2 ILE A 283      54.454  40.957  26.441  1.00 22.25           C  
ATOM   1649  CD1 ILE A 283      56.952  42.730  26.283  1.00 23.49           C  
ATOM   1650  N   PRO A 284      50.935  41.791  25.629  1.00 19.07           N  
ATOM   1651  CA  PRO A 284      50.917  41.631  24.170  1.00 18.35           C  
ATOM   1652  C   PRO A 284      50.354  42.881  23.491  1.00 17.10           C  
ATOM   1653  O   PRO A 284      49.852  43.782  24.167  1.00 17.69           O  
ATOM   1654  CB  PRO A 284      50.022  40.413  23.977  1.00 20.72           C  
ATOM   1655  CG  PRO A 284      49.012  40.589  25.050  1.00 20.61           C  
ATOM   1656  CD  PRO A 284      49.850  41.007  26.248  1.00 19.65           C  
ATOM   1657  N   PRO A 285      50.438  42.957  22.150  1.00 15.89           N  
ATOM   1658  CA  PRO A 285      49.917  44.122  21.424  1.00 15.70           C  
ATOM   1659  C   PRO A 285      48.489  44.442  21.852  1.00 15.82           C  
ATOM   1660  O   PRO A 285      47.644  43.554  21.962  1.00 15.70           O  
ATOM   1661  CB  PRO A 285      50.043  43.695  19.969  1.00 16.75           C  
ATOM   1662  CG  PRO A 285      51.346  42.932  19.997  1.00 16.76           C  
ATOM   1663  CD  PRO A 285      51.169  42.060  21.233  1.00 16.03           C  
ATOM   1664  N   LEU A 286      48.244  45.726  22.073  1.00 14.30           N  
ATOM   1665  CA  LEU A 286      46.969  46.223  22.581  1.00 14.70           C  
ATOM   1666  C   LEU A 286      45.818  46.539  21.631  1.00 14.02           C  
ATOM   1667  O   LEU A 286      45.961  47.318  20.690  1.00 15.75           O  
ATOM   1668  CB  LEU A 286      47.257  47.464  23.433  1.00 14.40           C  
ATOM   1669  CG  LEU A 286      46.083  48.202  24.076  1.00 12.58           C  
ATOM   1670  CD1 LEU A 286      45.443  47.315  25.141  1.00 14.51           C  
ATOM   1671  CD2 LEU A 286      46.584  49.503  24.695  1.00 14.86           C  
ATOM   1672  N   THR A 287      44.667  45.930  21.899  1.00 14.36           N  
ATOM   1673  CA  THR A 287      43.462  46.198  21.123  1.00 14.23           C  
ATOM   1674  C   THR A 287      43.059  47.579  21.615  1.00 14.23           C  
ATOM   1675  O   THR A 287      43.028  47.820  22.821  1.00 14.10           O  
ATOM   1676  CB  THR A 287      42.348  45.195  21.452  1.00 14.90           C  
ATOM   1677  OG1 THR A 287      42.721  43.903  20.961  1.00 16.14           O  
ATOM   1678  CG2 THR A 287      41.029  45.623  20.811  1.00 13.88           C  
ATOM   1679  N   THR A 288      42.732  48.479  20.696  1.00 14.08           N  
ATOM   1680  CA  THR A 288      42.410  49.838  21.098  1.00 14.75           C  
ATOM   1681  C   THR A 288      41.499  50.554  20.101  1.00 14.93           C  
ATOM   1682  O   THR A 288      41.077  49.975  19.101  1.00 15.39           O  
ATOM   1683  CB  THR A 288      43.736  50.627  21.263  1.00 14.86           C  
ATOM   1684  OG1 THR A 288      43.473  51.958  21.711  1.00 15.69           O  
ATOM   1685  CG2 THR A 288      44.493  50.664  19.932  1.00 15.35           C  
ATOM   1686  N   ILE A 289      41.190  51.812  20.403  1.00 13.83           N  
ATOM   1687  CA  ILE A 289      40.349  52.641  19.547  1.00 13.36           C  
ATOM   1688  C   ILE A 289      41.247  53.704  18.931  1.00 12.09           C  
ATOM   1689  O   ILE A 289      41.854  54.509  19.640  1.00 13.06           O  
ATOM   1690  CB  ILE A 289      39.245  53.353  20.352  1.00 13.55           C  
ATOM   1691  CG1 ILE A 289      38.380  52.320  21.079  1.00 15.31           C  
ATOM   1692  CG2 ILE A 289      38.416  54.234  19.427  1.00 14.00           C  
ATOM   1693  CD1 ILE A 289      37.702  51.317  20.165  1.00 17.02           C  
ATOM   1694  N   LYS A 290      41.331  53.710  17.608  1.00 12.80           N  
ATOM   1695  CA  LYS A 290      42.180  54.678  16.938  1.00 13.57           C  
ATOM   1696  C   LYS A 290      41.595  56.077  16.819  1.00 15.48           C  
ATOM   1697  O   LYS A 290      40.491  56.262  16.306  1.00 15.82           O  
ATOM   1698  CB  LYS A 290      42.546  54.178  15.537  1.00 14.35           C  
ATOM   1699  CG  LYS A 290      43.369  55.176  14.726  1.00 17.96           C  
ATOM   1700  CD  LYS A 290      43.732  54.596  13.363  1.00 22.21           C  
ATOM   1701  CE  LYS A 290      44.565  55.573  12.547  1.00 24.93           C  
ATOM   1702  NZ  LYS A 290      44.973  54.976  11.245  1.00 26.69           N  
ATOM   1703  N   GLN A 291      42.346  57.056  17.318  1.00 15.94           N  
ATOM   1704  CA  GLN A 291      41.974  58.463  17.215  1.00 16.27           C  
ATOM   1705  C   GLN A 291      43.121  59.050  16.401  1.00 15.47           C  
ATOM   1706  O   GLN A 291      44.246  59.144  16.889  1.00 16.41           O  
ATOM   1707  CB  GLN A 291      41.925  59.150  18.581  1.00 17.75           C  
ATOM   1708  CG  GLN A 291      40.876  58.602  19.533  1.00 18.86           C  
ATOM   1709  CD  GLN A 291      40.551  59.581  20.642  1.00 19.58           C  
ATOM   1710  OE1 GLN A 291      39.558  60.309  20.569  1.00 21.83           O  
ATOM   1711  NE2 GLN A 291      41.396  59.621  21.666  1.00 19.11           N  
ATOM   1712  N   ASP A 292      42.833  59.435  15.163  1.00 15.39           N  
ATOM   1713  CA  ASP A 292      43.856  59.982  14.271  1.00 14.91           C  
ATOM   1714  C   ASP A 292      44.203  61.432  14.613  1.00 13.59           C  
ATOM   1715  O   ASP A 292      43.708  62.369  13.987  1.00 13.64           O  
ATOM   1716  CB  ASP A 292      43.368  59.867  12.826  1.00 16.81           C  
ATOM   1717  CG  ASP A 292      44.481  60.057  11.814  1.00 17.77           C  
ATOM   1718  OD1 ASP A 292      44.283  59.658  10.648  1.00 20.42           O  
ATOM   1719  OD2 ASP A 292      45.544  60.606  12.178  1.00 18.39           O  
ATOM   1720  N   PHE A 293      45.068  61.606  15.609  1.00 14.00           N  
ATOM   1721  CA  PHE A 293      45.465  62.938  16.054  1.00 15.09           C  
ATOM   1722  C   PHE A 293      46.103  63.774  14.957  1.00 14.96           C  
ATOM   1723  O   PHE A 293      45.941  64.995  14.926  1.00 15.55           O  
ATOM   1724  CB  PHE A 293      46.423  62.838  17.245  1.00 14.99           C  
ATOM   1725  CG  PHE A 293      45.834  62.143  18.439  1.00 17.52           C  
ATOM   1726  CD1 PHE A 293      44.687  62.637  19.053  1.00 19.23           C  
ATOM   1727  CD2 PHE A 293      46.420  60.987  18.944  1.00 19.60           C  
ATOM   1728  CE1 PHE A 293      44.131  61.990  20.153  1.00 19.54           C  
ATOM   1729  CE2 PHE A 293      45.869  60.331  20.048  1.00 20.31           C  
ATOM   1730  CZ  PHE A 293      44.723  60.835  20.651  1.00 20.55           C  
ATOM   1731  N   ARG A 294      46.832  63.125  14.055  1.00 16.18           N  
ATOM   1732  CA  ARG A 294      47.473  63.847  12.966  1.00 16.96           C  
ATOM   1733  C   ARG A 294      46.394  64.478  12.093  1.00 16.13           C  
ATOM   1734  O   ARG A 294      46.494  65.642  11.699  1.00 15.66           O  
ATOM   1735  CB  ARG A 294      48.324  62.900  12.124  1.00 19.95           C  
ATOM   1736  CG  ARG A 294      49.182  63.608  11.088  1.00 26.57           C  
ATOM   1737  CD  ARG A 294      49.521  62.686   9.927  1.00 30.89           C  
ATOM   1738  NE  ARG A 294      48.650  62.910   8.773  1.00 37.14           N  
ATOM   1739  CZ  ARG A 294      47.331  62.734   8.768  1.00 38.53           C  
ATOM   1740  NH1 ARG A 294      46.702  62.323   9.860  1.00 42.60           N  
ATOM   1741  NH2 ARG A 294      46.635  62.979   7.668  1.00 38.17           N  
ATOM   1742  N   LEU A 295      45.357  63.702  11.789  1.00 15.49           N  
ATOM   1743  CA  LEU A 295      44.265  64.200  10.970  1.00 16.94           C  
ATOM   1744  C   LEU A 295      43.572  65.368  11.670  1.00 15.26           C  
ATOM   1745  O   LEU A 295      43.252  66.375  11.041  1.00 17.34           O  
ATOM   1746  CB  LEU A 295      43.254  63.085  10.695  1.00 19.02           C  
ATOM   1747  CG  LEU A 295      42.027  63.487   9.872  1.00 21.17           C  
ATOM   1748  CD1 LEU A 295      42.463  63.967   8.497  1.00 23.09           C  
ATOM   1749  CD2 LEU A 295      41.080  62.305   9.754  1.00 22.72           C  
ATOM   1750  N   LEU A 296      43.346  65.234  12.972  1.00 14.08           N  
ATOM   1751  CA  LEU A 296      42.693  66.296  13.735  1.00 14.41           C  
ATOM   1752  C   LEU A 296      43.497  67.595  13.694  1.00 15.23           C  
ATOM   1753  O   LEU A 296      42.954  68.662  13.407  1.00 14.15           O  
ATOM   1754  CB  LEU A 296      42.499  65.863  15.190  1.00 13.44           C  
ATOM   1755  CG  LEU A 296      41.915  66.924  16.127  1.00 13.95           C  
ATOM   1756  CD1 LEU A 296      40.519  67.325  15.657  1.00 15.10           C  
ATOM   1757  CD2 LEU A 296      41.865  66.374  17.545  1.00 15.73           C  
ATOM   1758  N   GLY A 297      44.791  67.502  13.985  1.00 15.14           N  
ATOM   1759  CA  GLY A 297      45.634  68.685  13.975  1.00 15.31           C  
ATOM   1760  C   GLY A 297      45.693  69.322  12.600  1.00 15.36           C  
ATOM   1761  O   GLY A 297      45.549  70.535  12.459  1.00 14.75           O  
ATOM   1762  N   GLN A 298      45.906  68.498  11.580  1.00 15.74           N  
ATOM   1763  CA  GLN A 298      45.971  68.987  10.208  1.00 16.66           C  
ATOM   1764  C   GLN A 298      44.667  69.689   9.833  1.00 16.86           C  
ATOM   1765  O   GLN A 298      44.666  70.821   9.343  1.00 16.85           O  
ATOM   1766  CB  GLN A 298      46.208  67.814   9.255  1.00 20.46           C  
ATOM   1767  CG  GLN A 298      46.337  68.192   7.792  1.00 26.38           C  
ATOM   1768  CD  GLN A 298      46.354  66.970   6.894  1.00 30.21           C  
ATOM   1769  OE1 GLN A 298      45.312  66.374   6.617  1.00 33.33           O  
ATOM   1770  NE2 GLN A 298      47.543  66.577   6.452  1.00 32.85           N  
ATOM   1771  N   THR A 299      43.554  69.011  10.077  1.00 16.06           N  
ATOM   1772  CA  THR A 299      42.248  69.561   9.742  1.00 16.66           C  
ATOM   1773  C   THR A 299      41.942  70.856  10.492  1.00 16.24           C  
ATOM   1774  O   THR A 299      41.329  71.767   9.931  1.00 17.34           O  
ATOM   1775  CB  THR A 299      41.133  68.526  10.012  1.00 17.30           C  
ATOM   1776  OG1 THR A 299      41.441  67.306   9.319  1.00 19.16           O  
ATOM   1777  CG2 THR A 299      39.786  69.043   9.511  1.00 18.74           C  
ATOM   1778  N   SER A 300      42.381  70.956  11.745  1.00 15.53           N  
ATOM   1779  CA  SER A 300      42.114  72.160  12.531  1.00 14.70           C  
ATOM   1780  C   SER A 300      42.739  73.405  11.909  1.00 14.80           C  
ATOM   1781  O   SER A 300      42.169  74.495  11.974  1.00 14.32           O  
ATOM   1782  CB  SER A 300      42.611  71.995  13.978  1.00 15.28           C  
ATOM   1783  OG  SER A 300      44.028  72.007  14.064  1.00 16.44           O  
ATOM   1784  N   VAL A 301      43.911  73.251  11.301  1.00 13.79           N  
ATOM   1785  CA  VAL A 301      44.572  74.390  10.679  1.00 14.03           C  
ATOM   1786  C   VAL A 301      43.811  74.808   9.427  1.00 15.85           C  
ATOM   1787  O   VAL A 301      43.525  75.993   9.235  1.00 17.29           O  
ATOM   1788  CB  VAL A 301      46.037  74.062  10.311  1.00 14.48           C  
ATOM   1789  CG1 VAL A 301      46.668  75.237   9.567  1.00 15.60           C  
ATOM   1790  CG2 VAL A 301      46.827  73.767  11.578  1.00 14.85           C  
ATOM   1791  N   ASP A 302      43.471  73.837   8.585  1.00 16.67           N  
ATOM   1792  CA  ASP A 302      42.724  74.138   7.368  1.00 18.70           C  
ATOM   1793  C   ASP A 302      41.414  74.828   7.735  1.00 17.04           C  
ATOM   1794  O   ASP A 302      41.029  75.821   7.121  1.00 17.78           O  
ATOM   1795  CB  ASP A 302      42.408  72.858   6.584  1.00 21.97           C  
ATOM   1796  CG  ASP A 302      43.651  72.076   6.201  1.00 26.55           C  
ATOM   1797  OD1 ASP A 302      44.695  72.703   5.940  1.00 29.19           O  
ATOM   1798  OD2 ASP A 302      43.576  70.830   6.146  1.00 31.67           O  
ATOM   1799  N   ARG A 303      40.737  74.296   8.748  1.00 15.77           N  
ATOM   1800  CA  ARG A 303      39.458  74.840   9.199  1.00 15.51           C  
ATOM   1801  C   ARG A 303      39.582  76.263   9.740  1.00 15.03           C  
ATOM   1802  O   ARG A 303      38.778  77.134   9.407  1.00 14.83           O  
ATOM   1803  CB  ARG A 303      38.858  73.929  10.279  1.00 16.00           C  
ATOM   1804  CG  ARG A 303      37.423  74.278  10.700  1.00 16.39           C  
ATOM   1805  CD  ARG A 303      36.447  74.124   9.536  1.00 17.95           C  
ATOM   1806  NE  ARG A 303      36.709  72.900   8.782  1.00 19.58           N  
ATOM   1807  CZ  ARG A 303      36.474  71.668   9.226  1.00 19.82           C  
ATOM   1808  NH1 ARG A 303      36.766  70.626   8.458  1.00 19.80           N  
ATOM   1809  NH2 ARG A 303      35.928  71.472  10.421  1.00 17.50           N  
ATOM   1810  N   LEU A 304      40.592  76.498  10.575  1.00 14.43           N  
ATOM   1811  CA  LEU A 304      40.792  77.823  11.155  1.00 15.87           C  
ATOM   1812  C   LEU A 304      41.025  78.873  10.080  1.00 17.39           C  
ATOM   1813  O   LEU A 304      40.460  79.966  10.136  1.00 17.57           O  
ATOM   1814  CB  LEU A 304      41.982  77.821  12.117  1.00 15.29           C  
ATOM   1815  CG  LEU A 304      42.247  79.166  12.802  1.00 17.19           C  
ATOM   1816  CD1 LEU A 304      41.113  79.479  13.767  1.00 16.93           C  
ATOM   1817  CD2 LEU A 304      43.575  79.116  13.543  1.00 18.58           C  
ATOM   1818  N   LEU A 305      41.864  78.545   9.103  1.00 18.12           N  
ATOM   1819  CA  LEU A 305      42.144  79.489   8.034  1.00 19.65           C  
ATOM   1820  C   LEU A 305      40.893  79.746   7.194  1.00 19.09           C  
ATOM   1821  O   LEU A 305      40.665  80.869   6.749  1.00 20.40           O  
ATOM   1822  CB  LEU A 305      43.301  78.981   7.167  1.00 22.74           C  
ATOM   1823  CG  LEU A 305      44.619  78.811   7.935  1.00 25.04           C  
ATOM   1824  CD1 LEU A 305      45.745  78.509   6.960  1.00 27.17           C  
ATOM   1825  CD2 LEU A 305      44.938  80.079   8.722  1.00 27.30           C  
ATOM   1826  N   GLN A 306      40.078  78.714   6.986  1.00 17.66           N  
ATOM   1827  CA  GLN A 306      38.845  78.884   6.218  1.00 18.58           C  
ATOM   1828  C   GLN A 306      37.917  79.792   7.013  1.00 16.88           C  
ATOM   1829  O   GLN A 306      37.264  80.673   6.453  1.00 17.71           O  
ATOM   1830  CB  GLN A 306      38.167  77.533   5.972  1.00 19.92           C  
ATOM   1831  CG  GLN A 306      38.992  76.578   5.120  1.00 26.25           C  
ATOM   1832  CD  GLN A 306      38.730  76.728   3.641  1.00 30.87           C  
ATOM   1833  OE1 GLN A 306      38.586  77.839   3.131  1.00 33.43           O  
ATOM   1834  NE2 GLN A 306      38.675  75.604   2.934  1.00 33.57           N  
ATOM   1835  N   LEU A 307      37.860  79.576   8.324  1.00 17.20           N  
ATOM   1836  CA  LEU A 307      37.017  80.400   9.186  1.00 18.92           C  
ATOM   1837  C   LEU A 307      37.465  81.858   9.138  1.00 20.29           C  
ATOM   1838  O   LEU A 307      36.633  82.771   9.091  1.00 20.92           O  
ATOM   1839  CB  LEU A 307      37.080  79.901  10.635  1.00 18.71           C  
ATOM   1840  CG  LEU A 307      36.321  78.606  10.929  1.00 16.95           C  
ATOM   1841  CD1 LEU A 307      36.693  78.087  12.305  1.00 17.58           C  
ATOM   1842  CD2 LEU A 307      34.822  78.862  10.825  1.00 20.73           C  
ATOM   1843  N   SER A 308      38.779  82.072   9.141  1.00 21.36           N  
ATOM   1844  CA  SER A 308      39.332  83.423   9.111  1.00 23.79           C  
ATOM   1845  C   SER A 308      39.017  84.144   7.804  1.00 25.55           C  
ATOM   1846  O   SER A 308      39.016  85.373   7.753  1.00 26.42           O  
ATOM   1847  CB  SER A 308      40.849  83.390   9.332  1.00 24.41           C  
ATOM   1848  OG  SER A 308      41.535  82.826   8.228  1.00 27.03           O  
ATOM   1849  N   GLN A 309      38.747  83.379   6.749  1.00 26.02           N  
ATOM   1850  CA  GLN A 309      38.426  83.964   5.452  1.00 28.34           C  
ATOM   1851  C   GLN A 309      36.926  83.917   5.165  1.00 28.34           C  
ATOM   1852  O   GLN A 309      36.482  84.291   4.079  1.00 28.57           O  
ATOM   1853  CB  GLN A 309      39.190  83.241   4.341  1.00 31.33           C  
ATOM   1854  CG  GLN A 309      40.701  83.360   4.449  1.00 35.47           C  
ATOM   1855  CD  GLN A 309      41.423  82.738   3.268  1.00 39.41           C  
ATOM   1856  OE1 GLN A 309      42.654  82.727   3.213  1.00 42.60           O  
ATOM   1857  NE2 GLN A 309      40.658  82.221   2.313  1.00 39.84           N  
ATOM   1858  N   GLY A 310      36.152  83.453   6.143  1.00 27.95           N  
ATOM   1859  CA  GLY A 310      34.710  83.372   5.984  1.00 29.07           C  
ATOM   1860  C   GLY A 310      34.248  82.405   4.912  1.00 30.11           C  
ATOM   1861  O   GLY A 310      33.235  82.639   4.251  1.00 30.91           O  
ATOM   1862  N   GLN A 311      34.981  81.310   4.737  1.00 28.67           N  
ATOM   1863  CA  GLN A 311      34.624  80.323   3.727  1.00 29.51           C  
ATOM   1864  C   GLN A 311      34.421  78.932   4.306  1.00 29.11           C  
ATOM   1865  O   GLN A 311      34.219  77.966   3.571  1.00 24.25           O  
ATOM   1866  CB  GLN A 311      35.694  80.289   2.635  1.00 31.98           C  
ATOM   1867  CG  GLN A 311      37.116  80.386   3.147  1.00 35.46           C  
ATOM   1868  CD  GLN A 311      38.110  80.655   2.033  1.00 36.64           C  
ATOM   1869  OE1 GLN A 311      37.890  81.523   1.189  1.00 40.71           O  
ATOM   1870  NE2 GLN A 311      39.215  79.924   2.034  1.00 38.91           N  
ATOM   1871  N   ALA A 312      34.468  78.835   5.628  1.00 29.57           N  
ATOM   1872  CA  ALA A 312      34.285  77.553   6.287  1.00 33.70           C  
ATOM   1873  C   ALA A 312      32.821  77.360   6.628  1.00 37.81           C  
ATOM   1874  O   ALA A 312      31.966  77.286   5.746  1.00 41.83           O  
ATOM   1875  CB  ALA A 312      35.128  77.484   7.550  1.00 31.70           C  
ATOM   1876  N   VAL A 313      32.538  77.287   7.920  1.00 40.31           N  
ATOM   1877  CA  VAL A 313      31.184  77.092   8.401  1.00 41.88           C  
ATOM   1878  C   VAL A 313      31.002  77.801   9.733  1.00 41.34           C  
ATOM   1879  O   VAL A 313      31.439  78.938   9.912  1.00 42.56           O  
ATOM   1880  CB  VAL A 313      30.884  75.594   8.597  1.00 42.88           C  
ATOM   1881  CG1 VAL A 313      30.977  74.874   7.270  1.00 44.14           C  
ATOM   1882  CG2 VAL A 313      31.870  74.991   9.589  1.00 44.27           C  
ATOM   1883  N   LYS A 314      30.352  77.117  10.663  1.00 41.46           N  
ATOM   1884  CA  LYS A 314      30.109  77.648  11.990  1.00 39.37           C  
ATOM   1885  C   LYS A 314      29.415  76.555  12.787  1.00 36.92           C  
ATOM   1886  O   LYS A 314      28.189  76.542  12.901  1.00 38.64           O  
ATOM   1887  CB  LYS A 314      29.217  78.887  11.911  1.00 41.22           C  
ATOM   1888  CG  LYS A 314      29.576  79.957  12.922  1.00 42.12           C  
ATOM   1889  CD  LYS A 314      30.989  80.467  12.684  1.00 43.09           C  
ATOM   1890  CE  LYS A 314      31.389  81.500  13.717  1.00 44.05           C  
ATOM   1891  NZ  LYS A 314      32.772  81.984  13.474  1.00 44.81           N  
ATOM   1892  N   GLY A 315      30.205  75.632  13.324  1.00 30.93           N  
ATOM   1893  CA  GLY A 315      29.640  74.544  14.096  1.00 25.56           C  
ATOM   1894  C   GLY A 315      30.646  73.445  14.380  1.00 22.30           C  
ATOM   1895  O   GLY A 315      31.856  73.658  14.299  1.00 19.33           O  
ATOM   1896  N   ASN A 316      30.136  72.266  14.708  1.00 20.34           N  
ATOM   1897  CA  ASN A 316      30.983  71.128  15.023  1.00 18.24           C  
ATOM   1898  C   ASN A 316      31.104  70.085  13.924  1.00 18.26           C  
ATOM   1899  O   ASN A 316      30.165  69.843  13.165  1.00 18.47           O  
ATOM   1900  CB  ASN A 316      30.475  70.435  16.290  1.00 19.02           C  
ATOM   1901  CG  ASN A 316      31.087  69.055  16.487  1.00 20.80           C  
ATOM   1902  OD1 ASN A 316      30.569  68.050  15.990  1.00 19.55           O  
ATOM   1903  ND2 ASN A 316      32.204  69.004  17.200  1.00 17.18           N  
ATOM   1904  N   GLN A 317      32.289  69.486  13.847  1.00 15.34           N  
ATOM   1905  CA  GLN A 317      32.561  68.405  12.914  1.00 15.77           C  
ATOM   1906  C   GLN A 317      32.987  67.243  13.795  1.00 16.11           C  
ATOM   1907  O   GLN A 317      33.744  67.427  14.754  1.00 14.99           O  
ATOM   1908  CB  GLN A 317      33.711  68.730  11.947  1.00 15.69           C  
ATOM   1909  CG  GLN A 317      34.253  67.461  11.263  1.00 17.79           C  
ATOM   1910  CD  GLN A 317      35.317  67.720  10.206  1.00 18.09           C  
ATOM   1911  OE1 GLN A 317      36.069  68.689  10.286  1.00 19.67           O  
ATOM   1912  NE2 GLN A 317      35.396  66.831   9.220  1.00 17.79           N  
ATOM   1913  N   LEU A 318      32.478  66.057  13.484  1.00 14.20           N  
ATOM   1914  CA  LEU A 318      32.828  64.852  14.219  1.00 14.24           C  
ATOM   1915  C   LEU A 318      33.731  64.013  13.328  1.00 15.48           C  
ATOM   1916  O   LEU A 318      33.388  63.738  12.178  1.00 17.55           O  
ATOM   1917  CB  LEU A 318      31.577  64.041  14.550  1.00 15.04           C  
ATOM   1918  CG  LEU A 318      30.686  64.547  15.679  1.00 16.56           C  
ATOM   1919  CD1 LEU A 318      29.391  63.734  15.710  1.00 19.26           C  
ATOM   1920  CD2 LEU A 318      31.428  64.410  16.997  1.00 16.56           C  
ATOM   1921  N   LEU A 319      34.887  63.620  13.853  1.00 14.99           N  
ATOM   1922  CA  LEU A 319      35.815  62.787  13.099  1.00 15.19           C  
ATOM   1923  C   LEU A 319      35.594  61.342  13.506  1.00 15.31           C  
ATOM   1924  O   LEU A 319      35.349  61.044  14.674  1.00 15.26           O  
ATOM   1925  CB  LEU A 319      37.264  63.179  13.390  1.00 15.67           C  
ATOM   1926  CG  LEU A 319      37.715  64.561  12.921  1.00 16.12           C  
ATOM   1927  CD1 LEU A 319      39.173  64.772  13.317  1.00 17.47           C  
ATOM   1928  CD2 LEU A 319      37.551  64.675  11.413  1.00 19.52           C  
ATOM   1929  N   PRO A 320      35.681  60.418  12.544  1.00 16.29           N  
ATOM   1930  CA  PRO A 320      35.481  59.003  12.852  1.00 16.45           C  
ATOM   1931  C   PRO A 320      36.634  58.370  13.625  1.00 16.08           C  
ATOM   1932  O   PRO A 320      37.751  58.895  13.657  1.00 16.62           O  
ATOM   1933  CB  PRO A 320      35.312  58.377  11.470  1.00 19.36           C  
ATOM   1934  CG  PRO A 320      36.236  59.208  10.627  1.00 20.97           C  
ATOM   1935  CD  PRO A 320      35.925  60.619  11.103  1.00 18.47           C  
ATOM   1936  N   VAL A 321      36.332  57.246  14.263  1.00 15.03           N  
ATOM   1937  CA  VAL A 321      37.313  56.470  15.005  1.00 14.54           C  
ATOM   1938  C   VAL A 321      37.086  55.033  14.555  1.00 15.35           C  
ATOM   1939  O   VAL A 321      36.080  54.732  13.907  1.00 18.57           O  
ATOM   1940  CB  VAL A 321      37.112  56.567  16.540  1.00 14.32           C  
ATOM   1941  CG1 VAL A 321      37.313  58.008  16.997  1.00 14.77           C  
ATOM   1942  CG2 VAL A 321      35.715  56.065  16.929  1.00 14.46           C  
ATOM   1943  N   SER A 322      38.018  54.149  14.878  1.00 14.30           N  
ATOM   1944  CA  SER A 322      37.879  52.756  14.490  1.00 14.90           C  
ATOM   1945  C   SER A 322      38.495  51.848  15.538  1.00 14.27           C  
ATOM   1946  O   SER A 322      39.307  52.283  16.355  1.00 15.25           O  
ATOM   1947  CB  SER A 322      38.548  52.512  13.132  1.00 16.56           C  
ATOM   1948  OG  SER A 322      39.943  52.747  13.201  1.00 17.66           O  
ATOM   1949  N   LEU A 323      38.087  50.586  15.518  1.00 13.51           N  
ATOM   1950  CA  LEU A 323      38.594  49.593  16.450  1.00 13.90           C  
ATOM   1951  C   LEU A 323      39.793  48.894  15.826  1.00 14.64           C  
ATOM   1952  O   LEU A 323      39.730  48.442  14.683  1.00 15.29           O  
ATOM   1953  CB  LEU A 323      37.512  48.554  16.750  1.00 15.13           C  
ATOM   1954  CG  LEU A 323      37.912  47.315  17.554  1.00 16.87           C  
ATOM   1955  CD1 LEU A 323      38.233  47.713  18.987  1.00 17.35           C  
ATOM   1956  CD2 LEU A 323      36.765  46.301  17.527  1.00 17.81           C  
ATOM   1957  N   VAL A 324      40.884  48.816  16.578  1.00 14.42           N  
ATOM   1958  CA  VAL A 324      42.093  48.149  16.106  1.00 15.16           C  
ATOM   1959  C   VAL A 324      42.224  46.888  16.950  1.00 15.25           C  
ATOM   1960  O   VAL A 324      42.570  46.955  18.126  1.00 16.56           O  
ATOM   1961  CB  VAL A 324      43.340  49.035  16.310  1.00 16.15           C  
ATOM   1962  CG1 VAL A 324      44.581  48.305  15.816  1.00 18.08           C  
ATOM   1963  CG2 VAL A 324      43.164  50.356  15.570  1.00 17.63           C  
ATOM   1964  N   LYS A 325      41.921  45.742  16.354  1.00 16.25           N  
ATOM   1965  CA  LYS A 325      41.988  44.479  17.074  1.00 17.32           C  
ATOM   1966  C   LYS A 325      43.395  43.914  17.103  1.00 17.60           C  
ATOM   1967  O   LYS A 325      44.006  43.698  16.058  1.00 17.28           O  
ATOM   1968  CB  LYS A 325      41.051  43.448  16.436  1.00 19.62           C  
ATOM   1969  CG  LYS A 325      39.578  43.827  16.476  1.00 22.98           C  
ATOM   1970  CD  LYS A 325      38.724  42.733  15.843  1.00 25.84           C  
ATOM   1971  CE  LYS A 325      37.255  43.118  15.810  1.00 28.08           C  
ATOM   1972  NZ  LYS A 325      36.425  42.045  15.193  1.00 31.52           N  
ATOM   1973  N   ARG A 326      43.906  43.681  18.305  1.00 16.32           N  
ATOM   1974  CA  ARG A 326      45.236  43.113  18.443  1.00 17.29           C  
ATOM   1975  C   ARG A 326      45.235  41.842  19.297  1.00 18.31           C  
ATOM   1976  O   ARG A 326      44.423  40.944  19.060  1.00 20.04           O  
ATOM   1977  CB  ARG A 326      46.216  44.163  18.987  1.00 16.93           C  
ATOM   1978  CG  ARG A 326      46.405  45.340  18.030  1.00 16.51           C  
ATOM   1979  CD  ARG A 326      47.762  46.018  18.219  1.00 15.78           C  
ATOM   1980  NE  ARG A 326      47.965  47.131  17.293  1.00 15.89           N  
ATOM   1981  CZ  ARG A 326      47.843  48.415  17.616  1.00 16.34           C  
ATOM   1982  NH1 ARG A 326      47.511  48.773  18.852  1.00 15.87           N  
ATOM   1983  NH2 ARG A 326      48.075  49.348  16.704  1.00 18.25           N  
ATOM   1984  N   LYS A 327      46.103  41.767  20.302  1.00 18.14           N  
ATOM   1985  CA  LYS A 327      46.221  40.550  21.104  1.00 18.42           C  
ATOM   1986  C   LYS A 327      45.733  40.573  22.547  1.00 17.79           C  
ATOM   1987  O   LYS A 327      45.948  39.604  23.277  1.00 19.73           O  
ATOM   1988  CB  LYS A 327      47.687  40.101  21.110  1.00 18.07           C  
ATOM   1989  CG  LYS A 327      48.297  39.902  19.730  1.00 22.51           C  
ATOM   1990  CD  LYS A 327      47.660  38.727  19.013  1.00 24.86           C  
ATOM   1991  CE  LYS A 327      48.338  38.464  17.678  1.00 28.21           C  
ATOM   1992  NZ  LYS A 327      47.743  37.283  16.995  1.00 31.34           N  
ATOM   1993  N   THR A 328      45.074  41.646  22.967  1.00 16.14           N  
ATOM   1994  CA  THR A 328      44.630  41.733  24.353  1.00 16.31           C  
ATOM   1995  C   THR A 328      43.154  41.443  24.599  1.00 16.15           C  
ATOM   1996  O   THR A 328      42.671  41.625  25.717  1.00 15.93           O  
ATOM   1997  CB  THR A 328      44.945  43.117  24.933  1.00 15.48           C  
ATOM   1998  OG1 THR A 328      44.317  44.119  24.126  1.00 15.08           O  
ATOM   1999  CG2 THR A 328      46.460  43.357  24.947  1.00 15.99           C  
ATOM   2000  N   THR A 329      42.448  40.995  23.568  1.00 16.41           N  
ATOM   2001  CA  THR A 329      41.027  40.683  23.704  1.00 19.25           C  
ATOM   2002  C   THR A 329      40.676  39.305  23.155  1.00 20.66           C  
ATOM   2003  O   THR A 329      40.884  39.011  21.973  1.00 21.02           O  
ATOM   2004  CB  THR A 329      40.144  41.740  23.001  1.00 19.38           C  
ATOM   2005  OG1 THR A 329      40.626  41.969  21.671  1.00 20.25           O  
ATOM   2006  CG2 THR A 329      40.153  43.043  23.779  1.00 19.51           C  
ATOM   2007  N   LEU A 330      40.146  38.464  24.037  1.00 20.92           N  
ATOM   2008  CA  LEU A 330      39.742  37.106  23.697  1.00 21.38           C  
ATOM   2009  C   LEU A 330      38.456  36.792  24.450  1.00 22.43           C  
ATOM   2010  O   LEU A 330      38.054  37.542  25.340  1.00 21.31           O  
ATOM   2011  CB  LEU A 330      40.823  36.108  24.120  1.00 22.71           C  
ATOM   2012  CG  LEU A 330      42.165  36.155  23.388  1.00 23.61           C  
ATOM   2013  CD1 LEU A 330      43.180  35.287  24.117  1.00 26.02           C  
ATOM   2014  CD2 LEU A 330      41.980  35.678  21.958  1.00 26.10           C  
ATOM   2015  N   ALA A 331      37.809  35.689  24.090  1.00 23.00           N  
ATOM   2016  CA  ALA A 331      36.585  35.287  24.773  1.00 24.65           C  
ATOM   2017  C   ALA A 331      36.958  35.055  26.235  1.00 26.40           C  
ATOM   2018  O   ALA A 331      38.097  34.691  26.537  1.00 28.64           O  
ATOM   2019  CB  ALA A 331      36.037  34.009  24.157  1.00 25.06           C  
ATOM   2020  N   PRO A 332      36.013  35.264  27.163  1.00 26.88           N  
ATOM   2021  CA  PRO A 332      36.317  35.061  28.584  1.00 28.16           C  
ATOM   2022  C   PRO A 332      36.693  33.627  28.947  1.00 29.75           C  
ATOM   2023  O   PRO A 332      36.397  32.713  28.149  1.00 30.49           O  
ATOM   2024  CB  PRO A 332      35.039  35.522  29.280  1.00 27.80           C  
ATOM   2025  CG  PRO A 332      33.977  35.222  28.270  1.00 27.24           C  
ATOM   2026  CD  PRO A 332      34.614  35.684  26.982  1.00 27.06           C  
TER    2027      PRO A 332                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
