
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  273 ( 2127),  selected  273 , name 2fep_A
# Molecule2: number of CA atoms  270 ( 1966),  selected  270 , name T0441.pdb
# PARAMETERS: 2fep_A.T0441.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T    61_A      -       -           -
LGA    T    62_A      Y      71          3.619
LGA    T    63_A      S      72          1.706
LGA    V    64_A      I      73          0.960
LGA    G    65_A      A      74          0.958
LGA    V    66_A      L      75          1.278
LGA    I    67_A      I      76          0.664
LGA    I    68_A      I      77          0.662
LGA    P    69_A      P      78          1.763
LGA    D    70_A      S      79          2.398
LGA    I    71_A      L      80          2.737
LGA    S    72_A      F      81          4.828
LGA    S    73_A      E      82          4.022
LGA    I    74_A      K      83          4.154
LGA    F    75_A      A      84          3.931
LGA    Y    76_A      C      85          1.875
LGA    S    77_A      A      86          1.478
LGA    E    78_A      H      87          0.739
LGA    L    79_A      F      88          1.152
LGA    A    80_A      L      89          0.923
LGA    R    81_A      P      90          1.436
LGA    G    82_A      S      91          2.356
LGA    I    83_A      F      92          1.137
LGA    E    84_A      Q      93          0.914
LGA    D    85_A      Q      94          1.685
LGA    I    86_A      A      95          1.363
LGA    A    87_A      L      96          0.949
LGA    T    88_A      N      97          1.388
LGA    M    89_A      K      98          2.098
LGA    Y    90_A      A      99          1.416
LGA    K    91_A      G     100          1.184
LGA    Y    92_A      Y     101          1.238
LGA    N    93_A      Q     102          0.958
LGA    I    94_A      L     103          0.699
LGA    I    95_A      L     104          1.148
LGA    L    96_A      L     105          1.938
LGA    S    97_A      G     106          1.127
LGA    N    98_A      Y     107          1.020
LGA    S    99_A      S     108          0.681
LGA    D   100_A      D     109          1.253
LGA    Q   101_A      Y     110          0.157
LGA    N   102_A      S     111          1.661
LGA    M   103_A      I     112          1.893
LGA    E   104_A      E     113          0.970
LGA    K   105_A      Q     114          0.928
LGA    E   106_A      E     115          1.553
LGA    L   107_A      E     116          2.173
LGA    H   108_A      K     117          2.058
LGA    L   109_A      L     118          1.833
LGA    L   110_A      L     119          1.856
LGA    N   111_A      S     120          1.501
LGA    T   112_A      T     121          2.049
LGA    M   113_A      F     122          1.704
LGA    L   114_A      L     123          0.558
LGA    G   115_A      E     124          1.895
LGA    K   116_A      S     125          2.285
LGA    Q   117_A      R     126          1.275
LGA    V   118_A      P     127          3.982
LGA    D   119_A      A     128          1.000
LGA    G   120_A      G     129          1.233
LGA    I   121_A      V     130          1.482
LGA    V   122_A      V     131          1.705
LGA    F   123_A      L     132          1.212
LGA    M   124_A      F     133          1.894
LGA    G   125_A      G     134          3.967
LGA    G   126_A      -       -           -
LGA    N   127_A      -       -           -
LGA    I   128_A      S     135          3.303
LGA    T   129_A      E     136          2.643
LGA    D   130_A      H     137           #
LGA    E   131_A      S     138          3.483
LGA    H   132_A      Q     139           #
LGA    V   133_A      R     140           -
LGA    A   134_A      T     141           #
LGA    E   135_A      H     142          1.054
LGA    F   136_A      -       -           -
LGA    K   137_A      Q     143           #
LGA    R   138_A      L     144          5.134
LGA    S   139_A      L     145          0.961
LGA    -       -      E     146           -
LGA    -       -      A     147           -
LGA    -       -      S     148           -
LGA    P   140_A      N     149          2.907
LGA    V   141_A      T     150          1.690
LGA    P   142_A      P     151          1.106
LGA    I   143_A      V     152          1.206
LGA    V   144_A      L     153          0.747
LGA    L   145_A      E     154          1.754
LGA    A   146_A      I     155          2.037
LGA    A   147_A      -       -           -
LGA    S   148_A      A     156          3.038
LGA    V   149_A      E     157          3.927
LGA    E   150_A      L     158          3.728
LGA    E   151_A      -       -           -
LGA    Q   152_A      -       -           -
LGA    E   153_A      S     159          2.995
LGA    E   154_A      S     160          4.072
LGA    -       -      K     161           -
LGA    -       -      A     162           -
LGA    -       -      S     163           -
LGA    T   155_A      Y     164          3.087
LGA    P   156_A      L     165          2.351
LGA    S   157_A      N     166          1.898
LGA    V   158_A      I     167          1.225
LGA    A   159_A      G     168          1.671
LGA    I   160_A      V     169          1.737
LGA    D   161_A      D     170          1.630
LGA    Y   162_A      H     171          0.989
LGA    E   163_A      F     172          0.792
LGA    Q   164_A      E     173          0.895
LGA    A   165_A      V     174          1.410
LGA    I   166_A      G     175          1.112
LGA    Y   167_A      K     176          0.677
LGA    D   168_A      A     177          0.768
LGA    A   169_A      C     178          0.790
LGA    V   170_A      T     179          0.681
LGA    K   171_A      R     180          0.751
LGA    L   172_A      H     181          1.122
LGA    L   173_A      L     182          0.863
LGA    V   174_A      I     183          0.835
LGA    D   175_A      E     184          1.087
LGA    K   176_A      Q     185          1.705
LGA    G   177_A      G     186          1.893
LGA    H   178_A      F     187          2.330
LGA    T   179_A      K     188          2.332
LGA    D   180_A      N     189          1.287
LGA    I   181_A      V     190          0.962
LGA    A   182_A      G     191          1.298
LGA    F   183_A      F     192          1.518
LGA    V   184_A      I     193          1.403
LGA    S   185_A      G     194          1.922
LGA    G   186_A      A     195          2.057
LGA    P   187_A      R     196          2.483
LGA    M   188_A      G     197          2.327
LGA    A   189_A      N     198          1.099
LGA    E   190_A      H     199          1.317
LGA    P   191_A      S     200          1.433
LGA    I   192_A      T     201          1.295
LGA    N   193_A      L     202          1.415
LGA    R   194_A      Q     203          1.491
LGA    S   195_A      R     204          3.703
LGA    K   196_A      -       -           -
LGA    K   197_A      Q     205          1.021
LGA    L   198_A      L     206          1.618
LGA    Q   199_A      H     207          1.765
LGA    G   200_A      G     208          1.181
LGA    Y   201_A      W     209          1.021
LGA    K   202_A      Q     210          1.665
LGA    R   203_A      S     211          1.473
LGA    A   204_A      A     212          0.943
LGA    L   205_A      M     213          1.220
LGA    E   206_A      I     214          1.787
LGA    E   207_A      E     215          1.443
LGA    A   208_A      N     216          1.278
LGA    N   209_A      Y     217          2.113
LGA    L   210_A      L     218          1.795
LGA    P   211_A      T     219          2.200
LGA    F   212_A      P     220          2.498
LGA    N   213_A      D     221          1.538
LGA    E   214_A      -       -           -
LGA    Q   215_A      -       -           -
LGA    F   216_A      H     222          1.213
LGA    V   217_A      F     223          0.876
LGA    A   218_A      L     224          1.121
LGA    E   219_A      T     225          1.093
LGA    G   220_A      T     226          4.326
LGA    -       -      H     227           -
LGA    D   221_A      E     228          3.654
LGA    Y   222_A      A     229          4.090
LGA    T   223_A      P     230          2.324
LGA    -       -      S     231           -
LGA    Y   224_A      S     232          2.626
LGA    D   225_A      Q     233          2.339
LGA    S   226_A      L     234          1.837
LGA    G   227_A      G     235          1.995
LGA    L   228_A      A     236          2.310
LGA    E   229_A      E     237          2.043
LGA    A   230_A      G     238          1.494
LGA    L   231_A      L     239          1.597
LGA    Q   232_A      A     240          1.734
LGA    H   233_A      K     241          1.800
LGA    L   234_A      L     242          1.367
LGA    M   235_A      L     243          1.632
LGA    S   236_A      L     244          1.558
LGA    L   237_A      R     245          1.345
LGA    D   238_A      D     246          2.775
LGA    K   239_A      S     247          3.799
LGA    K   240_A      S     248          4.146
LGA    P   241_A      L     249          1.939
LGA    T   242_A      N     250          0.791
LGA    A   243_A      A     251          0.775
LGA    I   244_A      L     252          0.531
LGA    L   245_A      V     253          0.884
LGA    S   246_A      C     254          0.903
LGA    A   247_A      S     255          1.278
LGA    T   248_A      H     256          1.345
LGA    D   249_A      E     257          1.399
LGA    E   250_A      E     258          1.875
LGA    M   251_A      I     259          1.416
LGA    A   252_A      A     260          1.118
LGA    L   253_A      I     261          1.144
LGA    G   254_A      G     262          1.291
LGA    I   255_A      A     263          1.243
LGA    I   256_A      L     264          0.873
LGA    H   257_A      F     265          1.083
LGA    A   258_A      E     266          1.857
LGA    A   259_A      C     267          1.926
LGA    Q   260_A      H     268          1.478
LGA    D   261_A      R     269          1.940
LGA    Q   262_A      R     270          2.081
LGA    G   263_A      V     271          2.041
LGA    L   264_A      L     272          1.726
LGA    S   265_A      K     273          2.054
LGA    I   266_A      V     274          1.658
LGA    P   267_A      P     275          1.971
LGA    E   268_A      T     276          2.610
LGA    D   269_A      D     277          1.517
LGA    L   270_A      I     278          0.831
LGA    D   271_A      A     279          0.627
LGA    I   272_A      I     280          0.475
LGA    I   273_A      I     281          0.663
LGA    G   274_A      C     282          0.633
LGA    F   275_A      L     283          1.784
LGA    D   276_A      E     284          2.145
LGA    N   277_A      G     285          2.712
LGA    T   278_A      S     286          1.688
LGA    R   279_A      S     287          2.307
LGA    L   280_A      M     288          1.490
LGA    S   281_A      G     289          1.990
LGA    L   282_A      E     290          2.318
LGA    M   283_A      H     291          3.532
LGA    V   284_A      A     292          1.498
LGA    R   285_A      Y     293          1.553
LGA    P   286_A      P     294          1.677
LGA    Q   287_A      S     295          1.413
LGA    L   288_A      L     296          1.641
LGA    S   289_A      T     297          0.905
LGA    T   290_A      S     298          0.511
LGA    V   291_A      A     299          0.967
LGA    V   292_A      E     300          1.698
LGA    Q   293_A      F     301          1.453
LGA    P   294_A      D     302          1.499
LGA    T   295_A      Y     303          1.665
LGA    Y   296_A      E     304          1.429
LGA    D   297_A      R     305          1.631
LGA    I   298_A      M     306          1.844
LGA    G   299_A      G     307          2.073
LGA    A   300_A      T     308          1.899
LGA    V   301_A      K     309          1.258
LGA    A   302_A      A     310          1.359
LGA    M   303_A      A     311          1.684
LGA    R   304_A      E     312          1.374
LGA    L   305_A      K     313          0.906
LGA    L   306_A      L     314          1.258
LGA    T   307_A      L     315          1.193
LGA    K   308_A      H     316          1.439
LGA    L   309_A      A     317          1.535
LGA    M   310_A      I     318          1.937
LGA    N   311_A      K     319          1.896
LGA    K   312_A      E     321          2.853
LGA    E   313_A      -       -           -
LGA    P   314_A      P     322          1.016
LGA    V   315_A      E     323          1.456
LGA    E   316_A      E     324          2.087
LGA    E   317_A      P     326          3.224
LGA    H   318_A      -       -           -
LGA    I   319_A      -       -           -
LGA    V   320_A      T     327          2.334
LGA    E   321_A      S     328          2.706
LGA    L   322_A      M     329          0.427
LGA    P   323_A      G     330          2.336
LGA    H   324_A      F     331          1.586
LGA    R   325_A      K     332          2.130
LGA    I   326_A      L     333          0.388
LGA    E   327_A      K     334          0.337
LGA    L   328_A      R     335          0.888
LGA    R   329_A      R     336          1.323
LGA    K   330_A      A     337          1.611
LGA    S   331_A      S     338          1.655
LGA    T   332_A      T     339          1.577
LGA    K   333_A      A     340          1.955
LGA    -       -      I     341           -
LGA    -       -      N     342           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  273  270    5.0    255    1.92    19.61     75.326    12.612

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.240542 * X  +  -0.285496 * Y  +   0.927702 * Z  +  17.437071
  Y_new =  -0.864536 * X  +   0.497523 * Y  +  -0.071054 * Z  +  51.930603
  Z_new =  -0.441268 * X  +  -0.819123 * Y  +  -0.366497 * Z  +  42.220058 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.991507    1.150085  [ DEG:  -114.1050     65.8950 ]
  Theta =   0.457011    2.684582  [ DEG:    26.1848    153.8152 ]
  Phi   =  -1.842166    1.299427  [ DEG:  -105.5483     74.4517 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fep_A                                        
REMARK     2: T0441.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fep_A.T0441.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  273  270   5.0  255   1.92   19.61  75.326
REMARK  ---------------------------------------------------------- 
MOLECULE 2fep_A
HEADER    TRANSCRIPTION                           16-DEC-05   2FEP              
TITLE     STRUCTURE OF TRUNCATED CCPA IN COMPLEX WITH P-SER-HPR AND             
TITLE    2 SULFATE IONS                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CATABOLITE CONTROL PROTEIN A;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 61-333;                                           
COMPND   5 SYNONYM: GLUCOSE-RESISTANCE AMYLASE REGULATOR;                       
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: PHOSPHOCARRIER PROTEIN HPR;                                
COMPND   9 CHAIN: S;                                                            
COMPND  10 SYNONYM: HISTIDINE-CONTAINING PROTEIN;                               
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: CCPA, ALSA, AMYR, GRAR;                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE  10 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  11 GENE: PTSH;                                                          
SOURCE  12 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  13 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: BL21                                       
KEYWDS    CCPA, HPR, TRANSCRIPTIONAL REGULATOR                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.CHAPTAL,V.GUEGUEN-CHAIGNON,S.PONCET,C.LECAMPION,P.MEYER,            
AUTHOR   2 J.DEUTSCHER,A.GALINIER,S.NESSLER                                     
REVDAT   2   05-SEP-06 2FEP    1       JRNL                                     
REVDAT   1   27-JUN-06 2FEP    0                                                
JRNL        AUTH   V.CHAPTAL,V.GUEGUEN-CHAIGNON,S.PONCET,C.LECAMPION,           
JRNL        AUTH 2 P.MEYER,J.DEUTSCHER,A.GALINIER,S.NESSLER,S.MORERA            
JRNL        TITL   STRUCTURAL ANALYSIS OF B. SUBTILIS CCPA EFFECTOR             
JRNL        TITL 2 BINDING SITE.                                                
JRNL        REF    PROTEINS                      V.  64   814 2006              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.45 ANGSTROMS.                                          
DBREF  2FEP A   58   334  UNP    P25144   CCPA_BACSU      58    334             
DBREF  2FEP S    2    88  UNP    P08877   PTHP_BACSU       1     87             
SEQRES   1 A  289  MET ARG GLY SER HIS HIS HIS HIS HIS HIS GLY SER SER          
SEQRES   2 A  289  LYS LYS THR THR THR VAL GLY VAL ILE ILE PRO ASP ILE          
SEQRES   3 A  289  SER SER ILE PHE TYR SER GLU LEU ALA ARG GLY ILE GLU          
SEQRES   4 A  289  ASP ILE ALA THR MET TYR LYS TYR ASN ILE ILE LEU SER          
SEQRES   5 A  289  ASN SER ASP GLN ASN MET GLU LYS GLU LEU HIS LEU LEU          
SEQRES   6 A  289  ASN THR MET LEU GLY LYS GLN VAL ASP GLY ILE VAL PHE          
SEQRES   7 A  289  MET GLY GLY ASN ILE THR ASP GLU HIS VAL ALA GLU PHE          
SEQRES   8 A  289  LYS ARG SER PRO VAL PRO ILE VAL LEU ALA ALA SER VAL          
SEQRES   9 A  289  GLU GLU GLN GLU GLU THR PRO SER VAL ALA ILE ASP TYR          
SEQRES  10 A  289  GLU GLN ALA ILE TYR ASP ALA VAL LYS LEU LEU VAL ASP          
SEQRES  11 A  289  LYS GLY HIS THR ASP ILE ALA PHE VAL SER GLY PRO MET          
SEQRES  12 A  289  ALA GLU PRO ILE ASN ARG SER LYS LYS LEU GLN GLY TYR          
SEQRES  13 A  289  LYS ARG ALA LEU GLU GLU ALA ASN LEU PRO PHE ASN GLU          
SEQRES  14 A  289  GLN PHE VAL ALA GLU GLY ASP TYR THR TYR ASP SER GLY          
SEQRES  15 A  289  LEU GLU ALA LEU GLN HIS LEU MET SER LEU ASP LYS LYS          
SEQRES  16 A  289  PRO THR ALA ILE LEU SER ALA THR ASP GLU MET ALA LEU          
SEQRES  17 A  289  GLY ILE ILE HIS ALA ALA GLN ASP GLN GLY LEU SER ILE          
SEQRES  18 A  289  PRO GLU ASP LEU ASP ILE ILE GLY PHE ASP ASN THR ARG          
SEQRES  19 A  289  LEU SER LEU MET VAL ARG PRO GLN LEU SER THR VAL VAL          
SEQRES  20 A  289  GLN PRO THR TYR ASP ILE GLY ALA VAL ALA MET ARG LEU          
SEQRES  21 A  289  LEU THR LYS LEU MET ASN LYS GLU PRO VAL GLU GLU HIS          
SEQRES  22 A  289  ILE VAL GLU LEU PRO HIS ARG ILE GLU LEU ARG LYS SER          
SEQRES  23 A  289  THR LYS SER                                                  
SEQRES   1 S   88  MET ALA GLN LYS THR PHE LYS VAL THR ALA ASP SER GLY          
SEQRES   2 S   88  ILE HIS ALA ARG PRO ALA THR VAL LEU VAL GLN THR ALA          
SEQRES   3 S   88  SER LYS TYR ASP ALA ASP VAL ASN LEU GLU TYR ASN GLY          
SEQRES   4 S   88  LYS THR VAL ASN LEU LYS SEP ILE MET GLY VAL MET SER          
SEQRES   5 S   88  LEU GLY ILE ALA LYS GLY ALA GLU ILE THR ILE SER ALA          
SEQRES   6 S   88  SER GLY ALA ASP GLU ASN ASP ALA LEU ASN ALA LEU GLU          
SEQRES   7 S   88  GLU THR MET LYS SER GLU GLY LEU GLY GLU                      
HET    SEP  S  46      10                                                       
HET    SO4   4398       5                                                       
HET    SO4   4397       5                                                       
HET    SO4   4396       5                                                       
HETNAM     SEP PHOSPHOSERINE                                                    
HETNAM     SO4 SULFATE ION                                                      
HETSYN     SEP PHOSPHONOSERINE                                                  
FORMUL   2  SEP    C3 H8 N O6 P                                                 
FORMUL   3  SO4    3(O4 S 2-)                                                   
FORMUL   6  HOH   *106(H2 O)                                                    
CRYST1   67.620   67.620  167.218  90.00  90.00  90.00 P 41 21 2     8          
ATOM      1  N   THR A  61      51.152  89.641  12.146  1.00 39.61           N  
ATOM      2  CA  THR A  61      51.002  89.157  10.743  1.00 38.75           C  
ATOM      3  C   THR A  61      50.934  87.632  10.687  1.00 36.95           C  
ATOM      4  O   THR A  61      51.759  86.937  11.276  1.00 37.49           O  
ATOM      5  CB  THR A  61      52.181  89.642   9.847  1.00 39.92           C  
ATOM      6  OG1 THR A  61      53.427  89.246  10.434  1.00 39.98           O  
ATOM      7  CG2 THR A  61      52.153  91.164   9.695  1.00 40.64           C  
ATOM      8  N   THR A  62      49.930  87.129   9.979  1.00 34.85           N  
ATOM      9  CA  THR A  62      49.708  85.699   9.803  1.00 31.13           C  
ATOM     10  C   THR A  62      50.299  84.783  10.878  1.00 27.68           C  
ATOM     11  O   THR A  62      51.254  84.045  10.646  1.00 24.56           O  
ATOM     12  CB  THR A  62      50.195  85.269   8.415  1.00 31.83           C  
ATOM     13  OG1 THR A  62      49.487  86.030   7.431  1.00 35.56           O  
ATOM     14  CG2 THR A  62      49.921  83.796   8.169  1.00 33.15           C  
ATOM     15  N   THR A  63      49.703  84.834  12.062  1.00 24.69           N  
ATOM     16  CA  THR A  63      50.139  84.003  13.166  1.00 21.93           C  
ATOM     17  C   THR A  63      48.912  83.549  13.933  1.00 20.84           C  
ATOM     18  O   THR A  63      47.960  84.314  14.088  1.00 20.13           O  
ATOM     19  CB  THR A  63      51.034  84.785  14.132  1.00 21.64           C  
ATOM     20  OG1 THR A  63      52.135  85.350  13.417  1.00 22.63           O  
ATOM     21  CG2 THR A  63      51.567  83.867  15.214  1.00 23.64           C  
ATOM     22  N   VAL A  64      48.919  82.301  14.395  1.00 19.73           N  
ATOM     23  CA  VAL A  64      47.803  81.803  15.189  1.00 19.11           C  
ATOM     24  C   VAL A  64      48.386  81.248  16.480  1.00 18.91           C  
ATOM     25  O   VAL A  64      49.493  80.705  16.487  1.00 18.11           O  
ATOM     26  CB  VAL A  64      46.975  80.696  14.456  1.00 20.02           C  
ATOM     27  CG1 VAL A  64      46.474  81.213  13.107  1.00 19.24           C  
ATOM     28  CG2 VAL A  64      47.798  79.453  14.269  1.00 21.66           C  
ATOM     29  N   GLY A  65      47.654  81.423  17.576  1.00 17.06           N  
ATOM     30  CA  GLY A  65      48.116  80.932  18.854  1.00 14.97           C  
ATOM     31  C   GLY A  65      47.568  79.550  19.124  1.00 16.56           C  
ATOM     32  O   GLY A  65      46.471  79.211  18.687  1.00 17.66           O  
ATOM     33  N   VAL A  66      48.332  78.742  19.845  1.00 16.78           N  
ATOM     34  CA  VAL A  66      47.900  77.395  20.167  1.00 18.37           C  
ATOM     35  C   VAL A  66      48.037  77.150  21.657  1.00 18.71           C  
ATOM     36  O   VAL A  66      49.151  77.122  22.181  1.00 20.11           O  
ATOM     37  CB  VAL A  66      48.735  76.347  19.410  1.00 18.83           C  
ATOM     38  CG1 VAL A  66      48.461  74.959  19.960  1.00 15.53           C  
ATOM     39  CG2 VAL A  66      48.410  76.409  17.929  1.00 18.42           C  
ATOM     40  N   ILE A  67      46.898  76.990  22.330  1.00 17.78           N  
ATOM     41  CA  ILE A  67      46.871  76.734  23.761  1.00 15.17           C  
ATOM     42  C   ILE A  67      46.700  75.240  23.955  1.00 14.97           C  
ATOM     43  O   ILE A  67      45.731  74.654  23.489  1.00 15.26           O  
ATOM     44  CB  ILE A  67      45.719  77.485  24.433  1.00 14.87           C  
ATOM     45  CG1 ILE A  67      45.976  78.987  24.322  1.00 13.20           C  
ATOM     46  CG2 ILE A  67      45.573  77.041  25.892  1.00 11.24           C  
ATOM     47  CD1 ILE A  67      44.835  79.871  24.821  1.00 15.59           C  
ATOM     48  N   ILE A  68      47.649  74.632  24.655  1.00 16.20           N  
ATOM     49  CA  ILE A  68      47.644  73.192  24.874  1.00 15.38           C  
ATOM     50  C   ILE A  68      48.000  72.862  26.323  1.00 15.43           C  
ATOM     51  O   ILE A  68      48.819  73.545  26.935  1.00 17.18           O  
ATOM     52  CB  ILE A  68      48.673  72.538  23.921  1.00 17.07           C  
ATOM     53  CG1 ILE A  68      48.412  71.043  23.787  1.00 16.93           C  
ATOM     54  CG2 ILE A  68      50.080  72.770  24.439  1.00 14.60           C  
ATOM     55  CD1 ILE A  68      49.157  70.430  22.630  1.00 19.34           C  
ATOM     56  N   PRO A  69      47.384  71.817  26.901  1.00 15.63           N  
ATOM     57  CA  PRO A  69      47.748  71.524  28.294  1.00 14.75           C  
ATOM     58  C   PRO A  69      49.216  71.152  28.514  1.00 14.09           C  
ATOM     59  O   PRO A  69      49.870  71.715  29.385  1.00 15.60           O  
ATOM     60  CB  PRO A  69      46.761  70.414  28.706  1.00 13.81           C  
ATOM     61  CG  PRO A  69      46.212  69.894  27.413  1.00 16.03           C  
ATOM     62  CD  PRO A  69      46.175  71.077  26.495  1.00 15.69           C  
ATOM     63  N   ASP A  70      49.755  70.236  27.720  1.00 14.00           N  
ATOM     64  CA  ASP A  70      51.153  69.844  27.900  1.00 14.02           C  
ATOM     65  C   ASP A  70      51.764  69.290  26.616  1.00 13.13           C  
ATOM     66  O   ASP A  70      51.442  68.180  26.187  1.00 11.26           O  
ATOM     67  CB  ASP A  70      51.266  68.818  29.044  1.00 14.96           C  
ATOM     68  CG  ASP A  70      52.716  68.409  29.342  1.00 20.11           C  
ATOM     69  OD1 ASP A  70      53.650  69.141  28.945  1.00 21.20           O  
ATOM     70  OD2 ASP A  70      52.922  67.359  29.990  1.00 18.54           O  
ATOM     71  N   ILE A  71      52.662  70.071  26.016  1.00 15.27           N  
ATOM     72  CA  ILE A  71      53.323  69.687  24.767  1.00 15.63           C  
ATOM     73  C   ILE A  71      54.178  68.426  24.878  1.00 16.19           C  
ATOM     74  O   ILE A  71      54.427  67.765  23.874  1.00 16.50           O  
ATOM     75  CB  ILE A  71      54.224  70.836  24.220  1.00 16.30           C  
ATOM     76  CG1 ILE A  71      54.605  70.553  22.762  1.00 16.76           C  
ATOM     77  CG2 ILE A  71      55.506  70.950  25.042  1.00 14.82           C  
ATOM     78  CD1 ILE A  71      53.403  70.450  21.821  1.00 16.69           C  
ATOM     79  N   SER A  72      54.631  68.086  26.081  1.00 16.36           N  
ATOM     80  CA  SER A  72      55.457  66.894  26.228  1.00 19.62           C  
ATOM     81  C   SER A  72      54.604  65.624  26.233  1.00 20.11           C  
ATOM     82  O   SER A  72      55.128  64.512  26.252  1.00 20.72           O  
ATOM     83  CB  SER A  72      56.305  66.963  27.504  1.00 20.34           C  
ATOM     84  OG  SER A  72      55.612  66.432  28.617  1.00 24.86           O  
ATOM     85  N   SER A  73      53.289  65.794  26.211  1.00 20.53           N  
ATOM     86  CA  SER A  73      52.376  64.659  26.191  1.00 18.76           C  
ATOM     87  C   SER A  73      52.495  63.924  24.857  1.00 18.63           C  
ATOM     88  O   SER A  73      52.631  64.538  23.799  1.00 18.26           O  
ATOM     89  CB  SER A  73      50.937  65.148  26.381  1.00 19.22           C  
ATOM     90  OG  SER A  73      50.001  64.117  26.138  1.00 20.89           O  
ATOM     91  N   ILE A  74      52.451  62.604  24.911  1.00 19.17           N  
ATOM     92  CA  ILE A  74      52.536  61.789  23.706  1.00 19.72           C  
ATOM     93  C   ILE A  74      51.370  62.111  22.774  1.00 18.81           C  
ATOM     94  O   ILE A  74      51.522  62.151  21.556  1.00 17.09           O  
ATOM     95  CB  ILE A  74      52.508  60.288  24.074  1.00 21.74           C  
ATOM     96  CG1 ILE A  74      53.898  59.854  24.540  1.00 25.18           C  
ATOM     97  CG2 ILE A  74      52.034  59.454  22.899  1.00 25.14           C  
ATOM     98  CD1 ILE A  74      54.009  58.372  24.840  1.00 29.15           C  
ATOM     99  N   PHE A  75      50.206  62.352  23.369  1.00 18.53           N  
ATOM    100  CA  PHE A  75      48.990  62.669  22.631  1.00 16.31           C  
ATOM    101  C   PHE A  75      49.016  64.090  22.074  1.00 16.22           C  
ATOM    102  O   PHE A  75      48.833  64.299  20.877  1.00 16.14           O  
ATOM    103  CB  PHE A  75      47.781  62.491  23.560  1.00 15.43           C  
ATOM    104  CG  PHE A  75      46.454  62.660  22.880  1.00 14.90           C  
ATOM    105  CD1 PHE A  75      45.753  63.856  22.982  1.00 16.00           C  
ATOM    106  CD2 PHE A  75      45.904  61.622  22.132  1.00 14.04           C  
ATOM    107  CE1 PHE A  75      44.517  64.017  22.348  1.00 14.78           C  
ATOM    108  CE2 PHE A  75      44.674  61.776  21.498  1.00 13.05           C  
ATOM    109  CZ  PHE A  75      43.982  62.975  21.607  1.00 12.60           C  
ATOM    110  N   TYR A  76      49.244  65.064  22.947  1.00 14.98           N  
ATOM    111  CA  TYR A  76      49.274  66.456  22.532  1.00 15.70           C  
ATOM    112  C   TYR A  76      50.443  66.834  21.622  1.00 15.56           C  
ATOM    113  O   TYR A  76      50.329  67.781  20.842  1.00 16.56           O  
ATOM    114  CB  TYR A  76      49.234  67.369  23.761  1.00 13.50           C  
ATOM    115  CG  TYR A  76      47.886  67.350  24.447  1.00 15.48           C  
ATOM    116  CD1 TYR A  76      46.735  67.768  23.768  1.00 14.45           C  
ATOM    117  CD2 TYR A  76      47.747  66.898  25.760  1.00 15.81           C  
ATOM    118  CE1 TYR A  76      45.486  67.734  24.376  1.00 13.61           C  
ATOM    119  CE2 TYR A  76      46.491  66.859  26.382  1.00 14.32           C  
ATOM    120  CZ  TYR A  76      45.371  67.279  25.682  1.00 15.45           C  
ATOM    121  OH  TYR A  76      44.133  67.255  26.283  1.00 16.61           O  
ATOM    122  N   SER A  77      51.562  66.118  21.700  1.00 13.63           N  
ATOM    123  CA  SER A  77      52.678  66.464  20.821  1.00 14.89           C  
ATOM    124  C   SER A  77      52.327  66.020  19.393  1.00 15.00           C  
ATOM    125  O   SER A  77      52.780  66.619  18.416  1.00 16.79           O  
ATOM    126  CB  SER A  77      53.990  65.813  21.292  1.00 11.77           C  
ATOM    127  OG  SER A  77      54.000  64.420  21.045  1.00 13.62           O  
ATOM    128  N   GLU A  78      51.507  64.981  19.276  1.00 14.26           N  
ATOM    129  CA  GLU A  78      51.084  64.495  17.971  1.00 16.63           C  
ATOM    130  C   GLU A  78      50.050  65.465  17.386  1.00 17.46           C  
ATOM    131  O   GLU A  78      50.110  65.810  16.203  1.00 17.68           O  
ATOM    132  CB  GLU A  78      50.480  63.094  18.094  1.00 20.72           C  
ATOM    133  CG  GLU A  78      49.896  62.560  16.791  1.00 26.85           C  
ATOM    134  CD  GLU A  78      50.927  61.864  15.915  1.00 30.53           C  
ATOM    135  OE1 GLU A  78      52.110  62.278  15.923  1.00 31.31           O  
ATOM    136  OE2 GLU A  78      50.543  60.908  15.203  1.00 31.93           O  
ATOM    137  N   LEU A  79      49.093  65.896  18.209  1.00 17.24           N  
ATOM    138  CA  LEU A  79      48.077  66.845  17.758  1.00 15.40           C  
ATOM    139  C   LEU A  79      48.786  68.104  17.299  1.00 15.27           C  
ATOM    140  O   LEU A  79      48.465  68.673  16.252  1.00 16.03           O  
ATOM    141  CB  LEU A  79      47.134  67.215  18.898  1.00 17.13           C  
ATOM    142  CG  LEU A  79      45.850  66.419  19.089  1.00 19.81           C  
ATOM    143  CD1 LEU A  79      45.398  66.525  20.529  1.00 19.83           C  
ATOM    144  CD2 LEU A  79      44.790  66.940  18.144  1.00 19.85           C  
ATOM    145  N   ALA A  80      49.754  68.534  18.098  1.00 12.96           N  
ATOM    146  CA  ALA A  80      50.517  69.731  17.795  1.00 13.34           C  
ATOM    147  C   ALA A  80      51.246  69.630  16.452  1.00 13.20           C  
ATOM    148  O   ALA A  80      51.275  70.596  15.694  1.00 13.23           O  
ATOM    149  CB  ALA A  80      51.511  70.018  18.921  1.00 11.89           C  
ATOM    150  N   ARG A  81      51.833  68.473  16.149  1.00 12.57           N  
ATOM    151  CA  ARG A  81      52.541  68.335  14.882  1.00 12.95           C  
ATOM    152  C   ARG A  81      51.583  68.497  13.707  1.00 13.04           C  
ATOM    153  O   ARG A  81      51.926  69.130  12.711  1.00 12.10           O  
ATOM    154  CB  ARG A  81      53.260  66.986  14.801  1.00 14.97           C  
ATOM    155  CG  ARG A  81      53.775  66.641  13.412  1.00 16.24           C  
ATOM    156  CD  ARG A  81      54.746  67.677  12.848  1.00 17.17           C  
ATOM    157  NE  ARG A  81      56.104  67.153  12.849  1.00 21.00           N  
ATOM    158  CZ  ARG A  81      56.944  67.193  11.817  1.00 19.26           C  
ATOM    159  NH1 ARG A  81      56.595  67.745  10.661  1.00 15.34           N  
ATOM    160  NH2 ARG A  81      58.144  66.651  11.946  1.00 21.05           N  
ATOM    161  N   GLY A  82      50.379  67.934  13.842  1.00 13.11           N  
ATOM    162  CA  GLY A  82      49.374  68.032  12.800  1.00 10.28           C  
ATOM    163  C   GLY A  82      48.973  69.475  12.572  1.00 11.92           C  
ATOM    164  O   GLY A  82      48.771  69.917  11.438  1.00 12.48           O  
ATOM    165  N   ILE A  83      48.852  70.216  13.664  1.00 13.24           N  
ATOM    166  CA  ILE A  83      48.495  71.620  13.599  1.00 12.81           C  
ATOM    167  C   ILE A  83      49.596  72.401  12.880  1.00 14.44           C  
ATOM    168  O   ILE A  83      49.341  73.158  11.947  1.00 13.83           O  
ATOM    169  CB  ILE A  83      48.324  72.212  15.012  1.00 10.61           C  
ATOM    170  CG1 ILE A  83      47.081  71.623  15.680  1.00 10.28           C  
ATOM    171  CG2 ILE A  83      48.252  73.728  14.930  1.00  9.61           C  
ATOM    172  CD1 ILE A  83      46.783  72.198  17.046  1.00  6.00           C  
ATOM    173  N   GLU A  84      50.828  72.211  13.319  1.00 15.35           N  
ATOM    174  CA  GLU A  84      51.934  72.919  12.709  1.00 19.32           C  
ATOM    175  C   GLU A  84      52.105  72.679  11.215  1.00 18.67           C  
ATOM    176  O   GLU A  84      52.324  73.634  10.466  1.00 19.72           O  
ATOM    177  CB  GLU A  84      53.216  72.600  13.468  1.00 23.10           C  
ATOM    178  CG  GLU A  84      53.080  73.005  14.919  1.00 32.06           C  
ATOM    179  CD  GLU A  84      54.383  73.029  15.664  1.00 37.49           C  
ATOM    180  OE1 GLU A  84      54.973  71.944  15.872  1.00 40.47           O  
ATOM    181  OE2 GLU A  84      54.809  74.145  16.042  1.00 42.07           O  
ATOM    182  N   ASP A  85      51.992  71.425  10.775  1.00 17.91           N  
ATOM    183  CA  ASP A  85      52.152  71.105   9.353  1.00 17.70           C  
ATOM    184  C   ASP A  85      51.167  71.875   8.484  1.00 16.81           C  
ATOM    185  O   ASP A  85      51.566  72.489   7.501  1.00 18.97           O  
ATOM    186  CB  ASP A  85      51.982  69.601   9.093  1.00 17.60           C  
ATOM    187  CG  ASP A  85      53.158  68.770   9.602  1.00 16.72           C  
ATOM    188  OD1 ASP A  85      54.149  69.338  10.104  1.00 15.23           O  
ATOM    189  OD2 ASP A  85      53.086  67.531   9.494  1.00 17.65           O  
ATOM    190  N   ILE A  86      49.886  71.837   8.835  1.00 16.04           N  
ATOM    191  CA  ILE A  86      48.887  72.561   8.063  1.00 15.65           C  
ATOM    192  C   ILE A  86      49.122  74.066   8.220  1.00 16.84           C  
ATOM    193  O   ILE A  86      48.854  74.837   7.303  1.00 17.43           O  
ATOM    194  CB  ILE A  86      47.444  72.161   8.490  1.00 14.81           C  
ATOM    195  CG1 ILE A  86      47.046  70.849   7.801  1.00 14.32           C  
ATOM    196  CG2 ILE A  86      46.439  73.233   8.083  1.00 10.70           C  
ATOM    197  CD1 ILE A  86      48.027  69.731   7.949  1.00 13.43           C  
ATOM    198  N   ALA A  87      49.639  74.477   9.373  1.00 16.29           N  
ATOM    199  CA  ALA A  87      49.942  75.887   9.602  1.00 18.24           C  
ATOM    200  C   ALA A  87      51.078  76.297   8.664  1.00 18.12           C  
ATOM    201  O   ALA A  87      51.051  77.373   8.072  1.00 17.79           O  
ATOM    202  CB  ALA A  87      50.358  76.119  11.051  1.00 18.72           C  
ATOM    203  N   THR A  88      52.084  75.442   8.535  1.00 18.87           N  
ATOM    204  CA  THR A  88      53.200  75.740   7.642  1.00 21.14           C  
ATOM    205  C   THR A  88      52.662  75.788   6.205  1.00 22.50           C  
ATOM    206  O   THR A  88      52.907  76.745   5.462  1.00 22.28           O  
ATOM    207  CB  THR A  88      54.305  74.661   7.753  1.00 22.09           C  
ATOM    208  OG1 THR A  88      54.877  74.701   9.065  1.00 20.36           O  
ATOM    209  CG2 THR A  88      55.404  74.894   6.719  1.00 20.82           C  
ATOM    210  N   MET A  89      51.915  74.756   5.828  1.00 22.64           N  
ATOM    211  CA  MET A  89      51.326  74.664   4.497  1.00 23.31           C  
ATOM    212  C   MET A  89      50.636  75.962   4.092  1.00 23.94           C  
ATOM    213  O   MET A  89      50.809  76.431   2.974  1.00 25.21           O  
ATOM    214  CB  MET A  89      50.307  73.519   4.452  1.00 24.29           C  
ATOM    215  CG  MET A  89      49.648  73.308   3.088  1.00 26.01           C  
ATOM    216  SD  MET A  89      48.302  72.076   3.089  1.00 27.92           S  
ATOM    217  CE  MET A  89      49.057  70.745   3.921  1.00 29.38           C  
ATOM    218  N   TYR A  90      49.857  76.533   5.012  1.00 24.05           N  
ATOM    219  CA  TYR A  90      49.107  77.765   4.762  1.00 23.46           C  
ATOM    220  C   TYR A  90      49.826  79.051   5.189  1.00 24.42           C  
ATOM    221  O   TYR A  90      49.204  80.112   5.319  1.00 24.01           O  
ATOM    222  CB  TYR A  90      47.724  77.672   5.436  1.00 22.22           C  
ATOM    223  CG  TYR A  90      46.770  76.751   4.704  1.00 21.35           C  
ATOM    224  CD1 TYR A  90      45.817  77.262   3.816  1.00 20.76           C  
ATOM    225  CD2 TYR A  90      46.875  75.365   4.824  1.00 19.13           C  
ATOM    226  CE1 TYR A  90      45.000  76.418   3.061  1.00 18.61           C  
ATOM    227  CE2 TYR A  90      46.061  74.512   4.072  1.00 19.59           C  
ATOM    228  CZ  TYR A  90      45.127  75.047   3.192  1.00 19.56           C  
ATOM    229  OH  TYR A  90      44.325  74.215   2.443  1.00 19.56           O  
ATOM    230  N   LYS A  91      51.133  78.946   5.413  1.00 25.57           N  
ATOM    231  CA  LYS A  91      51.969  80.096   5.779  1.00 26.93           C  
ATOM    232  C   LYS A  91      51.720  80.781   7.125  1.00 26.39           C  
ATOM    233  O   LYS A  91      52.088  81.940   7.294  1.00 29.10           O  
ATOM    234  CB  LYS A  91      51.889  81.160   4.674  1.00 27.86           C  
ATOM    235  CG  LYS A  91      52.220  80.654   3.268  1.00 31.33           C  
ATOM    236  CD  LYS A  91      53.659  80.166   3.164  1.00 34.61           C  
ATOM    237  CE  LYS A  91      53.993  79.714   1.747  1.00 37.49           C  
ATOM    238  NZ  LYS A  91      53.892  80.828   0.754  1.00 39.16           N  
ATOM    239  N   TYR A  92      51.114  80.078   8.077  1.00 24.28           N  
ATOM    240  CA  TYR A  92      50.838  80.638   9.399  1.00 22.32           C  
ATOM    241  C   TYR A  92      51.906  80.264  10.434  1.00 22.86           C  
ATOM    242  O   TYR A  92      52.318  79.107  10.514  1.00 23.73           O  
ATOM    243  CB  TYR A  92      49.476  80.139   9.903  1.00 21.21           C  
ATOM    244  CG  TYR A  92      48.293  80.903   9.362  1.00 20.42           C  
ATOM    245  CD1 TYR A  92      47.900  82.102   9.948  1.00 21.17           C  
ATOM    246  CD2 TYR A  92      47.602  80.461   8.231  1.00 20.19           C  
ATOM    247  CE1 TYR A  92      46.851  82.850   9.425  1.00 22.09           C  
ATOM    248  CE2 TYR A  92      46.553  81.205   7.694  1.00 21.64           C  
ATOM    249  CZ  TYR A  92      46.185  82.401   8.300  1.00 21.66           C  
ATOM    250  OH  TYR A  92      45.165  83.160   7.792  1.00 20.79           O  
ATOM    251  N   ASN A  93      52.348  81.243  11.223  1.00 22.36           N  
ATOM    252  CA  ASN A  93      53.324  80.994  12.284  1.00 22.37           C  
ATOM    253  C   ASN A  93      52.518  80.449  13.460  1.00 21.03           C  
ATOM    254  O   ASN A  93      51.313  80.655  13.529  1.00 21.36           O  
ATOM    255  CB  ASN A  93      54.012  82.288  12.739  1.00 23.87           C  
ATOM    256  CG  ASN A  93      54.685  83.030  11.607  1.00 26.68           C  
ATOM    257  OD1 ASN A  93      54.243  84.111  11.215  1.00 28.33           O  
ATOM    258  ND2 ASN A  93      55.764  82.457  11.076  1.00 24.94           N  
ATOM    259  N   ILE A  94      53.186  79.781  14.391  1.00 20.50           N  
ATOM    260  CA  ILE A  94      52.516  79.219  15.554  1.00 19.74           C  
ATOM    261  C   ILE A  94      53.141  79.648  16.878  1.00 21.14           C  
ATOM    262  O   ILE A  94      54.320  79.397  17.127  1.00 22.33           O  
ATOM    263  CB  ILE A  94      52.535  77.670  15.529  1.00 18.94           C  
ATOM    264  CG1 ILE A  94      51.664  77.141  14.388  1.00 18.51           C  
ATOM    265  CG2 ILE A  94      52.070  77.125  16.875  1.00 14.77           C  
ATOM    266  CD1 ILE A  94      50.181  77.477  14.527  1.00 16.37           C  
ATOM    267  N   ILE A  95      52.343  80.298  17.717  1.00 21.92           N  
ATOM    268  CA  ILE A  95      52.784  80.714  19.040  1.00 23.27           C  
ATOM    269  C   ILE A  95      52.231  79.610  19.922  1.00 23.22           C  
ATOM    270  O   ILE A  95      51.017  79.453  20.017  1.00 24.95           O  
ATOM    271  CB  ILE A  95      52.138  82.044  19.480  1.00 24.33           C  
ATOM    272  CG1 ILE A  95      52.644  83.189  18.609  1.00 27.88           C  
ATOM    273  CG2 ILE A  95      52.460  82.318  20.944  1.00 24.42           C  
ATOM    274  CD1 ILE A  95      52.011  84.528  18.953  1.00 30.72           C  
ATOM    275  N   LEU A  96      53.105  78.843  20.559  1.00 22.93           N  
ATOM    276  CA  LEU A  96      52.658  77.739  21.397  1.00 23.64           C  
ATOM    277  C   LEU A  96      52.741  78.066  22.891  1.00 23.69           C  
ATOM    278  O   LEU A  96      53.741  78.603  23.360  1.00 25.07           O  
ATOM    279  CB  LEU A  96      53.502  76.498  21.067  1.00 25.49           C  
ATOM    280  CG  LEU A  96      53.088  75.078  21.482  1.00 27.68           C  
ATOM    281  CD1 LEU A  96      52.915  74.995  22.992  1.00 28.25           C  
ATOM    282  CD2 LEU A  96      51.798  74.684  20.777  1.00 27.98           C  
ATOM    283  N   SER A  97      51.685  77.754  23.633  1.00 23.04           N  
ATOM    284  CA  SER A  97      51.678  77.993  25.076  1.00 22.22           C  
ATOM    285  C   SER A  97      51.059  76.813  25.829  1.00 21.27           C  
ATOM    286  O   SER A  97      50.052  76.251  25.399  1.00 20.49           O  
ATOM    287  CB  SER A  97      50.912  79.278  25.414  1.00 22.81           C  
ATOM    288  OG  SER A  97      51.632  80.430  25.002  1.00 28.11           O  
ATOM    289  N   ASN A  98      51.677  76.441  26.948  1.00 19.35           N  
ATOM    290  CA  ASN A  98      51.194  75.341  27.775  1.00 18.92           C  
ATOM    291  C   ASN A  98      50.310  75.897  28.892  1.00 19.66           C  
ATOM    292  O   ASN A  98      50.615  76.940  29.477  1.00 19.91           O  
ATOM    293  CB  ASN A  98      52.365  74.561  28.398  1.00 18.97           C  
ATOM    294  CG  ASN A  98      53.203  73.827  27.366  1.00 18.05           C  
ATOM    295  OD1 ASN A  98      54.146  74.378  26.810  1.00 20.89           O  
ATOM    296  ND2 ASN A  98      52.854  72.579  27.102  1.00 19.00           N  
ATOM    297  N   SER A  99      49.224  75.195  29.205  1.00 17.72           N  
ATOM    298  CA  SER A  99      48.319  75.662  30.246  1.00 18.31           C  
ATOM    299  C   SER A  99      48.247  74.761  31.475  1.00 19.55           C  
ATOM    300  O   SER A  99      47.821  75.206  32.543  1.00 21.23           O  
ATOM    301  CB  SER A  99      46.912  75.820  29.673  1.00 15.03           C  
ATOM    302  OG  SER A  99      46.374  74.556  29.336  1.00 15.12           O  
ATOM    303  N   ASP A 100      48.648  73.500  31.317  1.00 19.79           N  
ATOM    304  CA  ASP A 100      48.604  72.515  32.399  1.00 21.02           C  
ATOM    305  C   ASP A 100      47.169  72.273  32.877  1.00 20.68           C  
ATOM    306  O   ASP A 100      46.941  71.791  33.993  1.00 20.34           O  
ATOM    307  CB  ASP A 100      49.469  72.962  33.583  1.00 20.81           C  
ATOM    308  CG  ASP A 100      50.939  73.033  33.236  1.00 25.04           C  
ATOM    309  OD1 ASP A 100      51.495  71.998  32.796  1.00 23.45           O  
ATOM    310  OD2 ASP A 100      51.537  74.120  33.409  1.00 25.72           O  
ATOM    311  N   GLN A 101      46.199  72.612  32.036  1.00 19.67           N  
ATOM    312  CA  GLN A 101      44.800  72.409  32.394  1.00 21.29           C  
ATOM    313  C   GLN A 101      44.328  73.343  33.512  1.00 19.76           C  
ATOM    314  O   GLN A 101      43.296  73.102  34.124  1.00 21.24           O  
ATOM    315  CB  GLN A 101      44.577  70.956  32.828  1.00 23.15           C  
ATOM    316  CG  GLN A 101      44.646  69.917  31.716  1.00 25.95           C  
ATOM    317  CD  GLN A 101      43.350  69.821  30.935  1.00 28.05           C  
ATOM    318  OE1 GLN A 101      43.082  68.816  30.267  1.00 26.87           O  
ATOM    319  NE2 GLN A 101      42.538  70.873  31.008  1.00 30.12           N  
ATOM    320  N   ASN A 102      45.085  74.399  33.787  1.00 19.97           N  
ATOM    321  CA  ASN A 102      44.704  75.363  34.821  1.00 18.81           C  
ATOM    322  C   ASN A 102      43.768  76.395  34.184  1.00 19.39           C  
ATOM    323  O   ASN A 102      44.177  77.138  33.290  1.00 18.70           O  
ATOM    324  CB  ASN A 102      45.950  76.065  35.358  1.00 19.35           C  
ATOM    325  CG  ASN A 102      45.627  77.117  36.387  1.00 19.97           C  
ATOM    326  OD1 ASN A 102      45.641  76.851  37.585  1.00 23.47           O  
ATOM    327  ND2 ASN A 102      45.316  78.322  35.924  1.00 20.38           N  
ATOM    328  N   MET A 103      42.519  76.443  34.641  1.00 20.92           N  
ATOM    329  CA  MET A 103      41.538  77.374  34.086  1.00 21.95           C  
ATOM    330  C   MET A 103      41.998  78.826  34.059  1.00 22.10           C  
ATOM    331  O   MET A 103      41.898  79.494  33.026  1.00 22.42           O  
ATOM    332  CB  MET A 103      40.210  77.281  34.839  1.00 22.53           C  
ATOM    333  CG  MET A 103      39.092  77.995  34.111  1.00 25.71           C  
ATOM    334  SD  MET A 103      37.486  77.840  34.884  1.00 30.90           S  
ATOM    335  CE  MET A 103      37.193  76.079  34.669  1.00 31.16           C  
ATOM    336  N   GLU A 104      42.495  79.333  35.182  1.00 22.81           N  
ATOM    337  CA  GLU A 104      42.961  80.719  35.206  1.00 25.50           C  
ATOM    338  C   GLU A 104      44.064  80.927  34.159  1.00 23.96           C  
ATOM    339  O   GLU A 104      44.130  81.964  33.507  1.00 25.14           O  
ATOM    340  CB  GLU A 104      43.481  81.087  36.597  1.00 28.80           C  
ATOM    341  CG  GLU A 104      44.101  82.473  36.673  1.00 35.23           C  
ATOM    342  CD  GLU A 104      44.670  82.805  38.052  1.00 40.56           C  
ATOM    343  OE1 GLU A 104      45.285  83.889  38.182  1.00 43.65           O  
ATOM    344  OE2 GLU A 104      44.504  81.996  38.999  1.00 41.90           O  
ATOM    345  N   LYS A 105      44.918  79.926  33.996  1.00 21.54           N  
ATOM    346  CA  LYS A 105      46.001  79.994  33.027  1.00 21.33           C  
ATOM    347  C   LYS A 105      45.436  80.048  31.605  1.00 20.28           C  
ATOM    348  O   LYS A 105      45.867  80.863  30.790  1.00 18.58           O  
ATOM    349  CB  LYS A 105      46.902  78.763  33.176  1.00 22.76           C  
ATOM    350  CG  LYS A 105      48.326  78.938  32.681  1.00 22.85           C  
ATOM    351  CD  LYS A 105      49.082  79.909  33.563  1.00 27.54           C  
ATOM    352  CE  LYS A 105      50.490  79.401  33.893  1.00 31.75           C  
ATOM    353  NZ  LYS A 105      50.479  78.233  34.831  1.00 33.61           N  
ATOM    354  N   GLU A 106      44.469  79.174  31.317  1.00 20.28           N  
ATOM    355  CA  GLU A 106      43.841  79.094  29.996  1.00 19.34           C  
ATOM    356  C   GLU A 106      43.175  80.408  29.577  1.00 18.63           C  
ATOM    357  O   GLU A 106      43.411  80.920  28.484  1.00 16.03           O  
ATOM    358  CB  GLU A 106      42.801  77.968  29.974  1.00 19.98           C  
ATOM    359  CG  GLU A 106      43.345  76.578  30.308  1.00 20.57           C  
ATOM    360  CD  GLU A 106      42.251  75.515  30.368  1.00 20.65           C  
ATOM    361  OE1 GLU A 106      41.220  75.749  31.034  1.00 19.34           O  
ATOM    362  OE2 GLU A 106      42.421  74.440  29.757  1.00 21.97           O  
ATOM    363  N   LEU A 107      42.342  80.954  30.453  1.00 19.58           N  
ATOM    364  CA  LEU A 107      41.658  82.204  30.156  1.00 20.32           C  
ATOM    365  C   LEU A 107      42.662  83.338  30.027  1.00 20.39           C  
ATOM    366  O   LEU A 107      42.502  84.228  29.185  1.00 19.48           O  
ATOM    367  CB  LEU A 107      40.636  82.516  31.247  1.00 19.89           C  
ATOM    368  CG  LEU A 107      39.615  81.394  31.452  1.00 20.17           C  
ATOM    369  CD1 LEU A 107      38.562  81.835  32.466  1.00 19.55           C  
ATOM    370  CD2 LEU A 107      38.976  81.038  30.115  1.00 17.83           C  
ATOM    371  N   HIS A 108      43.704  83.305  30.851  1.00 20.20           N  
ATOM    372  CA  HIS A 108      44.726  84.339  30.781  1.00 22.62           C  
ATOM    373  C   HIS A 108      45.485  84.286  29.445  1.00 21.04           C  
ATOM    374  O   HIS A 108      45.683  85.312  28.792  1.00 21.55           O  
ATOM    375  CB  HIS A 108      45.712  84.208  31.940  1.00 24.12           C  
ATOM    376  CG  HIS A 108      46.850  85.176  31.863  1.00 29.87           C  
ATOM    377  ND1 HIS A 108      46.671  86.541  31.954  1.00 31.86           N  
ATOM    378  CD2 HIS A 108      48.177  84.982  31.670  1.00 32.10           C  
ATOM    379  CE1 HIS A 108      47.840  87.146  31.822  1.00 31.71           C  
ATOM    380  NE2 HIS A 108      48.770  86.223  31.649  1.00 34.03           N  
ATOM    381  N   LEU A 109      45.913  83.093  29.045  1.00 19.86           N  
ATOM    382  CA  LEU A 109      46.632  82.921  27.787  1.00 19.49           C  
ATOM    383  C   LEU A 109      45.760  83.374  26.616  1.00 19.50           C  
ATOM    384  O   LEU A 109      46.250  83.904  25.621  1.00 17.15           O  
ATOM    385  CB  LEU A 109      47.016  81.452  27.600  1.00 17.77           C  
ATOM    386  CG  LEU A 109      48.255  80.970  28.351  1.00 18.11           C  
ATOM    387  CD1 LEU A 109      48.317  79.444  28.316  1.00 13.45           C  
ATOM    388  CD2 LEU A 109      49.515  81.593  27.720  1.00 15.97           C  
ATOM    389  N   LEU A 110      44.461  83.159  26.750  1.00 19.87           N  
ATOM    390  CA  LEU A 110      43.514  83.541  25.718  1.00 21.60           C  
ATOM    391  C   LEU A 110      43.599  85.039  25.446  1.00 22.34           C  
ATOM    392  O   LEU A 110      43.656  85.476  24.292  1.00 22.66           O  
ATOM    393  CB  LEU A 110      42.104  83.177  26.162  1.00 22.54           C  
ATOM    394  CG  LEU A 110      41.204  82.656  25.054  1.00 25.84           C  
ATOM    395  CD1 LEU A 110      39.853  82.309  25.658  1.00 27.52           C  
ATOM    396  CD2 LEU A 110      41.070  83.709  23.950  1.00 26.77           C  
ATOM    397  N   ASN A 111      43.617  85.830  26.514  1.00 21.95           N  
ATOM    398  CA  ASN A 111      43.707  87.272  26.363  1.00 21.95           C  
ATOM    399  C   ASN A 111      45.129  87.665  25.980  1.00 22.48           C  
ATOM    400  O   ASN A 111      45.347  88.639  25.259  1.00 22.89           O  
ATOM    401  CB  ASN A 111      43.277  87.972  27.656  1.00 20.21           C  
ATOM    402  CG  ASN A 111      41.795  87.794  27.941  1.00 20.02           C  
ATOM    403  OD1 ASN A 111      40.986  87.675  27.014  1.00 19.15           O  
ATOM    404  ND2 ASN A 111      41.428  87.792  29.224  1.00 17.79           N  
ATOM    405  N   THR A 112      46.096  86.890  26.456  1.00 21.70           N  
ATOM    406  CA  THR A 112      47.495  87.147  26.151  1.00 20.76           C  
ATOM    407  C   THR A 112      47.766  86.931  24.662  1.00 20.65           C  
ATOM    408  O   THR A 112      48.503  87.701  24.045  1.00 19.31           O  
ATOM    409  CB  THR A 112      48.408  86.239  27.006  1.00 20.45           C  
ATOM    410  OG1 THR A 112      48.638  86.871  28.271  1.00 20.84           O  
ATOM    411  CG2 THR A 112      49.731  85.981  26.319  1.00 22.42           C  
ATOM    412  N   MET A 113      47.165  85.888  24.090  1.00 21.16           N  
ATOM    413  CA  MET A 113      47.330  85.582  22.668  1.00 20.43           C  
ATOM    414  C   MET A 113      46.828  86.763  21.830  1.00 18.48           C  
ATOM    415  O   MET A 113      47.431  87.118  20.812  1.00 16.14           O  
ATOM    416  CB  MET A 113      46.537  84.320  22.291  1.00 25.57           C  
ATOM    417  CG  MET A 113      46.911  83.049  23.062  1.00 28.92           C  
ATOM    418  SD  MET A 113      48.174  82.033  22.284  1.00 33.46           S  
ATOM    419  CE  MET A 113      49.547  83.192  22.254  1.00 30.79           C  
ATOM    420  N   LEU A 114      45.716  87.356  22.267  1.00 17.28           N  
ATOM    421  CA  LEU A 114      45.115  88.497  21.583  1.00 16.67           C  
ATOM    422  C   LEU A 114      46.055  89.693  21.624  1.00 17.71           C  
ATOM    423  O   LEU A 114      46.147  90.461  20.665  1.00 17.05           O  
ATOM    424  CB  LEU A 114      43.786  88.864  22.241  1.00 16.69           C  
ATOM    425  CG  LEU A 114      42.711  87.780  22.143  1.00 16.23           C  
ATOM    426  CD1 LEU A 114      41.435  88.236  22.846  1.00 14.40           C  
ATOM    427  CD2 LEU A 114      42.454  87.470  20.676  1.00 13.72           C  
ATOM    428  N   GLY A 115      46.748  89.845  22.746  1.00 18.99           N  
ATOM    429  CA  GLY A 115      47.696  90.930  22.884  1.00 19.79           C  
ATOM    430  C   GLY A 115      48.785  90.830  21.828  1.00 20.75           C  
ATOM    431  O   GLY A 115      49.382  91.841  21.463  1.00 20.19           O  
ATOM    432  N   LYS A 116      49.046  89.618  21.335  1.00 20.04           N  
ATOM    433  CA  LYS A 116      50.072  89.423  20.310  1.00 21.81           C  
ATOM    434  C   LYS A 116      49.464  89.573  18.920  1.00 21.24           C  
ATOM    435  O   LYS A 116      50.109  89.303  17.905  1.00 20.56           O  
ATOM    436  CB  LYS A 116      50.724  88.041  20.443  1.00 23.98           C  
ATOM    437  CG  LYS A 116      51.229  87.705  21.850  1.00 27.11           C  
ATOM    438  CD  LYS A 116      52.103  88.813  22.417  1.00 30.53           C  
ATOM    439  CE  LYS A 116      52.752  88.399  23.732  1.00 32.04           C  
ATOM    440  NZ  LYS A 116      51.748  87.880  24.700  1.00 37.51           N  
ATOM    441  N   GLN A 117      48.207  89.998  18.891  1.00 21.26           N  
ATOM    442  CA  GLN A 117      47.482  90.218  17.646  1.00 20.75           C  
ATOM    443  C   GLN A 117      47.337  88.983  16.756  1.00 19.08           C  
ATOM    444  O   GLN A 117      47.340  89.107  15.532  1.00 19.75           O  
ATOM    445  CB  GLN A 117      48.159  91.335  16.850  1.00 23.11           C  
ATOM    446  CG  GLN A 117      48.502  92.574  17.672  1.00 24.80           C  
ATOM    447  CD  GLN A 117      47.302  93.144  18.412  1.00 28.98           C  
ATOM    448  OE1 GLN A 117      46.279  93.478  17.803  1.00 29.42           O  
ATOM    449  NE2 GLN A 117      47.422  93.259  19.736  1.00 28.24           N  
ATOM    450  N   VAL A 118      47.200  87.802  17.358  1.00 15.49           N  
ATOM    451  CA  VAL A 118      47.036  86.572  16.575  1.00 15.58           C  
ATOM    452  C   VAL A 118      45.776  86.634  15.698  1.00 14.86           C  
ATOM    453  O   VAL A 118      44.828  87.356  16.011  1.00 13.58           O  
ATOM    454  CB  VAL A 118      46.946  85.321  17.492  1.00 15.06           C  
ATOM    455  CG1 VAL A 118      48.230  85.166  18.289  1.00 13.99           C  
ATOM    456  CG2 VAL A 118      45.767  85.447  18.439  1.00 14.70           C  
ATOM    457  N   ASP A 119      45.772  85.887  14.596  1.00 14.97           N  
ATOM    458  CA  ASP A 119      44.620  85.872  13.690  1.00 15.81           C  
ATOM    459  C   ASP A 119      43.594  84.795  14.035  1.00 14.67           C  
ATOM    460  O   ASP A 119      42.476  84.803  13.520  1.00 14.23           O  
ATOM    461  CB  ASP A 119      45.084  85.656  12.252  1.00 18.37           C  
ATOM    462  CG  ASP A 119      46.007  86.746  11.773  1.00 22.33           C  
ATOM    463  OD1 ASP A 119      46.557  86.605  10.658  1.00 26.05           O  
ATOM    464  OD2 ASP A 119      46.179  87.740  12.507  1.00 21.58           O  
ATOM    465  N   GLY A 120      43.985  83.866  14.900  1.00 11.16           N  
ATOM    466  CA  GLY A 120      43.098  82.790  15.285  1.00 12.09           C  
ATOM    467  C   GLY A 120      43.759  81.931  16.346  1.00 13.76           C  
ATOM    468  O   GLY A 120      44.954  82.064  16.617  1.00 13.84           O  
ATOM    469  N   ILE A 121      42.991  81.041  16.950  1.00 12.51           N  
ATOM    470  CA  ILE A 121      43.539  80.203  17.992  1.00 14.44           C  
ATOM    471  C   ILE A 121      42.993  78.786  17.964  1.00 15.41           C  
ATOM    472  O   ILE A 121      41.807  78.572  17.674  1.00 14.96           O  
ATOM    473  CB  ILE A 121      43.213  80.779  19.386  1.00 14.11           C  
ATOM    474  CG1 ILE A 121      43.919  82.116  19.598  1.00 15.53           C  
ATOM    475  CG2 ILE A 121      43.631  79.806  20.463  1.00 13.55           C  
ATOM    476  CD1 ILE A 121      43.555  82.765  20.925  1.00 15.36           C  
ATOM    477  N   VAL A 122      43.862  77.821  18.250  1.00 12.10           N  
ATOM    478  CA  VAL A 122      43.417  76.440  18.354  1.00 12.92           C  
ATOM    479  C   VAL A 122      43.530  76.147  19.848  1.00 13.42           C  
ATOM    480  O   VAL A 122      44.589  76.352  20.462  1.00 13.53           O  
ATOM    481  CB  VAL A 122      44.291  75.455  17.560  1.00 12.94           C  
ATOM    482  CG1 VAL A 122      43.739  74.045  17.732  1.00 12.38           C  
ATOM    483  CG2 VAL A 122      44.298  75.828  16.080  1.00  9.61           C  
ATOM    484  N   PHE A 123      42.429  75.703  20.442  1.00 12.84           N  
ATOM    485  CA  PHE A 123      42.410  75.424  21.867  1.00 12.42           C  
ATOM    486  C   PHE A 123      42.206  73.955  22.177  1.00 15.22           C  
ATOM    487  O   PHE A 123      41.374  73.284  21.558  1.00 15.32           O  
ATOM    488  CB  PHE A 123      41.311  76.254  22.541  1.00 12.61           C  
ATOM    489  CG  PHE A 123      41.310  76.160  24.043  1.00 10.53           C  
ATOM    490  CD1 PHE A 123      40.758  75.061  24.690  1.00  9.40           C  
ATOM    491  CD2 PHE A 123      41.912  77.152  24.811  1.00 10.70           C  
ATOM    492  CE1 PHE A 123      40.808  74.945  26.080  1.00  9.13           C  
ATOM    493  CE2 PHE A 123      41.970  77.047  26.204  1.00 11.42           C  
ATOM    494  CZ  PHE A 123      41.415  75.938  26.839  1.00  8.37           C  
ATOM    495  N   MET A 124      42.979  73.464  23.142  1.00 15.98           N  
ATOM    496  CA  MET A 124      42.887  72.084  23.597  1.00 18.26           C  
ATOM    497  C   MET A 124      42.852  72.085  25.123  1.00 18.62           C  
ATOM    498  O   MET A 124      43.750  72.623  25.769  1.00 17.49           O  
ATOM    499  CB  MET A 124      44.086  71.276  23.100  1.00 17.49           C  
ATOM    500  CG  MET A 124      44.057  71.010  21.620  1.00 20.01           C  
ATOM    501  SD  MET A 124      45.684  70.655  20.959  1.00 23.74           S  
ATOM    502  CE  MET A 124      46.312  72.343  20.788  1.00 24.03           C  
ATOM    503  N   GLY A 125      41.809  71.484  25.692  1.00 18.75           N  
ATOM    504  CA  GLY A 125      41.678  71.438  27.134  1.00 18.44           C  
ATOM    505  C   GLY A 125      40.683  70.383  27.564  1.00 19.58           C  
ATOM    506  O   GLY A 125      39.772  70.051  26.808  1.00 21.67           O  
ATOM    507  N   GLY A 126      40.850  69.862  28.778  1.00 17.91           N  
ATOM    508  CA  GLY A 126      39.960  68.830  29.273  1.00 17.13           C  
ATOM    509  C   GLY A 126      38.760  69.321  30.059  1.00 18.96           C  
ATOM    510  O   GLY A 126      37.923  68.525  30.482  1.00 19.65           O  
ATOM    511  N   ASN A 127      38.661  70.626  30.264  1.00 20.83           N  
ATOM    512  CA  ASN A 127      37.530  71.162  31.006  1.00 21.67           C  
ATOM    513  C   ASN A 127      37.045  72.491  30.450  1.00 19.89           C  
ATOM    514  O   ASN A 127      37.484  73.557  30.877  1.00 20.45           O  
ATOM    515  CB  ASN A 127      37.885  71.323  32.484  1.00 21.88           C  
ATOM    516  CG  ASN A 127      36.683  71.682  33.322  1.00 25.59           C  
ATOM    517  OD1 ASN A 127      35.648  71.012  33.264  1.00 26.04           O  
ATOM    518  ND2 ASN A 127      36.803  72.749  34.103  1.00 29.69           N  
ATOM    519  N   ILE A 128      36.132  72.412  29.494  1.00 19.64           N  
ATOM    520  CA  ILE A 128      35.567  73.593  28.866  1.00 20.44           C  
ATOM    521  C   ILE A 128      34.252  73.964  29.557  1.00 20.72           C  
ATOM    522  O   ILE A 128      33.236  73.281  29.403  1.00 19.30           O  
ATOM    523  CB  ILE A 128      35.338  73.327  27.372  1.00 21.06           C  
ATOM    524  CG1 ILE A 128      36.689  73.077  26.706  1.00 20.36           C  
ATOM    525  CG2 ILE A 128      34.625  74.505  26.720  1.00 20.49           C  
ATOM    526  CD1 ILE A 128      36.578  72.619  25.282  1.00 25.67           C  
ATOM    527  N   THR A 129      34.297  75.045  30.331  1.00 20.32           N  
ATOM    528  CA  THR A 129      33.142  75.520  31.081  1.00 22.10           C  
ATOM    529  C   THR A 129      32.370  76.554  30.282  1.00 23.44           C  
ATOM    530  O   THR A 129      32.826  76.995  29.228  1.00 25.21           O  
ATOM    531  CB  THR A 129      33.584  76.160  32.410  1.00 22.88           C  
ATOM    532  OG1 THR A 129      34.381  77.320  32.142  1.00 22.29           O  
ATOM    533  CG2 THR A 129      34.412  75.171  33.220  1.00 22.59           C  
ATOM    534  N   ASP A 130      31.199  76.940  30.780  1.00 24.13           N  
ATOM    535  CA  ASP A 130      30.389  77.939  30.090  1.00 24.05           C  
ATOM    536  C   ASP A 130      31.189  79.239  29.988  1.00 22.55           C  
ATOM    537  O   ASP A 130      30.975  80.054  29.092  1.00 22.59           O  
ATOM    538  CB  ASP A 130      29.075  78.185  30.843  1.00 26.57           C  
ATOM    539  CG  ASP A 130      28.188  76.951  30.901  1.00 29.76           C  
ATOM    540  OD1 ASP A 130      28.304  76.077  30.011  1.00 29.06           O  
ATOM    541  OD2 ASP A 130      27.358  76.863  31.832  1.00 30.71           O  
ATOM    542  N   GLU A 131      32.119  79.420  30.913  1.00 21.26           N  
ATOM    543  CA  GLU A 131      32.961  80.602  30.916  1.00 22.19           C  
ATOM    544  C   GLU A 131      33.929  80.548  29.733  1.00 21.19           C  
ATOM    545  O   GLU A 131      34.149  81.552  29.055  1.00 22.58           O  
ATOM    546  CB  GLU A 131      33.736  80.679  32.223  1.00 24.02           C  
ATOM    547  CG  GLU A 131      34.578  81.915  32.343  1.00 30.26           C  
ATOM    548  CD  GLU A 131      35.206  82.036  33.704  1.00 34.61           C  
ATOM    549  OE1 GLU A 131      35.884  83.054  33.955  1.00 37.90           O  
ATOM    550  OE2 GLU A 131      35.016  81.110  34.525  1.00 38.84           O  
ATOM    551  N   HIS A 132      34.519  79.381  29.489  1.00 18.88           N  
ATOM    552  CA  HIS A 132      35.421  79.242  28.357  1.00 17.61           C  
ATOM    553  C   HIS A 132      34.596  79.561  27.109  1.00 17.62           C  
ATOM    554  O   HIS A 132      34.976  80.399  26.288  1.00 17.98           O  
ATOM    555  CB  HIS A 132      35.961  77.812  28.249  1.00 16.33           C  
ATOM    556  CG  HIS A 132      36.961  77.448  29.303  1.00 16.18           C  
ATOM    557  ND1 HIS A 132      36.611  77.220  30.618  1.00 17.96           N  
ATOM    558  CD2 HIS A 132      38.298  77.245  29.229  1.00 15.49           C  
ATOM    559  CE1 HIS A 132      37.689  76.891  31.307  1.00 16.93           C  
ATOM    560  NE2 HIS A 132      38.726  76.898  30.488  1.00 16.49           N  
ATOM    561  N   VAL A 133      33.454  78.891  26.989  1.00 16.09           N  
ATOM    562  CA  VAL A 133      32.550  79.073  25.853  1.00 13.46           C  
ATOM    563  C   VAL A 133      32.309  80.550  25.534  1.00 12.86           C  
ATOM    564  O   VAL A 133      32.494  80.985  24.399  1.00 11.29           O  
ATOM    565  CB  VAL A 133      31.191  78.358  26.121  1.00 12.74           C  
ATOM    566  CG1 VAL A 133      30.221  78.612  24.976  1.00 11.61           C  
ATOM    567  CG2 VAL A 133      31.420  76.854  26.289  1.00  9.66           C  
ATOM    568  N   ALA A 134      31.904  81.325  26.535  1.00 12.90           N  
ATOM    569  CA  ALA A 134      31.653  82.745  26.331  1.00 12.70           C  
ATOM    570  C   ALA A 134      32.918  83.481  25.892  1.00 13.09           C  
ATOM    571  O   ALA A 134      32.883  84.347  25.019  1.00 12.28           O  
ATOM    572  CB  ALA A 134      31.113  83.357  27.605  1.00 13.38           C  
ATOM    573  N   GLU A 135      34.039  83.135  26.504  1.00 15.82           N  
ATOM    574  CA  GLU A 135      35.297  83.773  26.163  1.00 18.23           C  
ATOM    575  C   GLU A 135      35.678  83.451  24.713  1.00 15.68           C  
ATOM    576  O   GLU A 135      36.197  84.304  24.001  1.00 18.08           O  
ATOM    577  CB  GLU A 135      36.392  83.310  27.129  1.00 20.30           C  
ATOM    578  CG  GLU A 135      37.419  84.384  27.436  1.00 26.64           C  
ATOM    579  CD  GLU A 135      36.831  85.583  28.173  1.00 27.60           C  
ATOM    580  OE1 GLU A 135      37.525  86.613  28.260  1.00 29.94           O  
ATOM    581  OE2 GLU A 135      35.689  85.499  28.672  1.00 30.54           O  
ATOM    582  N   PHE A 136      35.413  82.225  24.279  1.00 12.92           N  
ATOM    583  CA  PHE A 136      35.719  81.816  22.908  1.00 13.95           C  
ATOM    584  C   PHE A 136      34.864  82.610  21.916  1.00 14.05           C  
ATOM    585  O   PHE A 136      35.359  83.065  20.883  1.00 12.62           O  
ATOM    586  CB  PHE A 136      35.451  80.313  22.711  1.00 12.07           C  
ATOM    587  CG  PHE A 136      36.379  79.405  23.493  1.00 11.95           C  
ATOM    588  CD1 PHE A 136      36.010  78.090  23.766  1.00 11.18           C  
ATOM    589  CD2 PHE A 136      37.609  79.854  23.954  1.00 10.41           C  
ATOM    590  CE1 PHE A 136      36.857  77.237  24.492  1.00 10.83           C  
ATOM    591  CE2 PHE A 136      38.457  79.012  24.681  1.00 12.06           C  
ATOM    592  CZ  PHE A 136      38.077  77.701  24.950  1.00 10.81           C  
ATOM    593  N   LYS A 137      33.582  82.769  22.235  1.00 13.99           N  
ATOM    594  CA  LYS A 137      32.663  83.504  21.371  1.00 17.71           C  
ATOM    595  C   LYS A 137      32.980  84.999  21.283  1.00 17.94           C  
ATOM    596  O   LYS A 137      32.917  85.588  20.200  1.00 18.13           O  
ATOM    597  CB  LYS A 137      31.214  83.319  21.847  1.00 18.83           C  
ATOM    598  CG  LYS A 137      30.680  81.883  21.733  1.00 23.94           C  
ATOM    599  CD  LYS A 137      29.251  81.748  22.275  1.00 26.03           C  
ATOM    600  CE  LYS A 137      29.158  82.233  23.727  1.00 32.81           C  
ATOM    601  NZ  LYS A 137      27.785  82.116  24.325  1.00 34.72           N  
ATOM    602  N   ARG A 138      33.329  85.612  22.412  1.00 18.28           N  
ATOM    603  CA  ARG A 138      33.627  87.041  22.422  1.00 19.37           C  
ATOM    604  C   ARG A 138      34.997  87.389  21.876  1.00 19.85           C  
ATOM    605  O   ARG A 138      35.264  88.552  21.579  1.00 20.00           O  
ATOM    606  CB  ARG A 138      33.459  87.624  23.831  1.00 19.17           C  
ATOM    607  CG  ARG A 138      32.037  87.490  24.365  1.00 18.51           C  
ATOM    608  CD  ARG A 138      31.017  87.628  23.234  1.00 17.39           C  
ATOM    609  NE  ARG A 138      29.896  86.713  23.423  1.00 18.40           N  
ATOM    610  CZ  ARG A 138      29.107  86.275  22.450  1.00 17.54           C  
ATOM    611  NH1 ARG A 138      29.303  86.665  21.200  1.00 17.50           N  
ATOM    612  NH2 ARG A 138      28.125  85.435  22.731  1.00 18.95           N  
ATOM    613  N   SER A 139      35.863  86.388  21.741  1.00 18.37           N  
ATOM    614  CA  SER A 139      37.191  86.623  21.200  1.00 18.59           C  
ATOM    615  C   SER A 139      37.019  87.193  19.790  1.00 17.75           C  
ATOM    616  O   SER A 139      36.251  86.661  18.998  1.00 18.20           O  
ATOM    617  CB  SER A 139      37.979  85.312  21.144  1.00 19.18           C  
ATOM    618  OG  SER A 139      39.298  85.517  20.660  1.00 20.19           O  
ATOM    619  N   PRO A 140      37.731  88.285  19.465  1.00 18.23           N  
ATOM    620  CA  PRO A 140      37.645  88.924  18.143  1.00 18.67           C  
ATOM    621  C   PRO A 140      38.209  88.102  16.978  1.00 18.44           C  
ATOM    622  O   PRO A 140      38.043  88.475  15.816  1.00 19.59           O  
ATOM    623  CB  PRO A 140      38.404  90.233  18.342  1.00 17.77           C  
ATOM    624  CG  PRO A 140      39.457  89.847  19.341  1.00 19.74           C  
ATOM    625  CD  PRO A 140      38.661  89.025  20.338  1.00 18.96           C  
ATOM    626  N   VAL A 141      38.876  86.997  17.291  1.00 16.08           N  
ATOM    627  CA  VAL A 141      39.446  86.133  16.255  1.00 15.17           C  
ATOM    628  C   VAL A 141      38.788  84.759  16.322  1.00 12.85           C  
ATOM    629  O   VAL A 141      38.224  84.377  17.350  1.00 11.84           O  
ATOM    630  CB  VAL A 141      40.979  85.953  16.430  1.00 15.06           C  
ATOM    631  CG1 VAL A 141      41.672  87.294  16.378  1.00 15.41           C  
ATOM    632  CG2 VAL A 141      41.277  85.264  17.748  1.00 14.25           C  
ATOM    633  N   PRO A 142      38.849  83.995  15.225  1.00 11.00           N  
ATOM    634  CA  PRO A 142      38.240  82.666  15.206  1.00 11.52           C  
ATOM    635  C   PRO A 142      38.962  81.704  16.135  1.00 12.53           C  
ATOM    636  O   PRO A 142      40.177  81.773  16.286  1.00 14.97           O  
ATOM    637  CB  PRO A 142      38.378  82.243  13.746  1.00 10.51           C  
ATOM    638  CG  PRO A 142      38.412  83.537  13.014  1.00  9.99           C  
ATOM    639  CD  PRO A 142      39.316  84.365  13.883  1.00 10.15           C  
ATOM    640  N   ILE A 143      38.205  80.803  16.744  1.00 13.50           N  
ATOM    641  CA  ILE A 143      38.768  79.801  17.636  1.00 13.90           C  
ATOM    642  C   ILE A 143      38.205  78.424  17.279  1.00 14.46           C  
ATOM    643  O   ILE A 143      37.012  78.283  17.010  1.00 13.50           O  
ATOM    644  CB  ILE A 143      38.443  80.119  19.104  1.00 13.86           C  
ATOM    645  CG1 ILE A 143      39.079  81.460  19.486  1.00 15.91           C  
ATOM    646  CG2 ILE A 143      38.936  78.994  20.000  1.00 11.30           C  
ATOM    647  CD1 ILE A 143      38.797  81.893  20.893  1.00 16.36           C  
ATOM    648  N   VAL A 144      39.080  77.419  17.274  1.00 14.34           N  
ATOM    649  CA  VAL A 144      38.709  76.046  16.959  1.00 13.84           C  
ATOM    650  C   VAL A 144      39.248  75.117  18.037  1.00 13.79           C  
ATOM    651  O   VAL A 144      40.386  75.251  18.471  1.00 15.70           O  
ATOM    652  CB  VAL A 144      39.287  75.602  15.589  1.00 14.32           C  
ATOM    653  CG1 VAL A 144      39.031  74.131  15.370  1.00 12.92           C  
ATOM    654  CG2 VAL A 144      38.653  76.411  14.461  1.00 14.28           C  
ATOM    655  N   LEU A 145      38.418  74.184  18.470  1.00 14.07           N  
ATOM    656  CA  LEU A 145      38.796  73.221  19.490  1.00 13.45           C  
ATOM    657  C   LEU A 145      39.246  71.945  18.811  1.00 14.09           C  
ATOM    658  O   LEU A 145      38.657  71.529  17.811  1.00 16.82           O  
ATOM    659  CB  LEU A 145      37.601  72.884  20.376  1.00 13.27           C  
ATOM    660  CG  LEU A 145      36.979  74.013  21.184  1.00 14.27           C  
ATOM    661  CD1 LEU A 145      35.667  73.543  21.766  1.00 16.00           C  
ATOM    662  CD2 LEU A 145      37.937  74.437  22.273  1.00 15.45           C  
ATOM    663  N   ALA A 146      40.280  71.318  19.358  1.00 11.70           N  
ATOM    664  CA  ALA A 146      40.781  70.073  18.813  1.00 10.07           C  
ATOM    665  C   ALA A 146      40.849  69.059  19.952  1.00 10.55           C  
ATOM    666  O   ALA A 146      41.242  69.404  21.072  1.00  9.24           O  
ATOM    667  CB  ALA A 146      42.166  70.283  18.195  1.00  9.83           C  
ATOM    668  N   ALA A 147      40.441  67.823  19.662  1.00  9.99           N  
ATOM    669  CA  ALA A 147      40.452  66.728  20.627  1.00 12.58           C  
ATOM    670  C   ALA A 147      39.875  67.116  21.984  1.00 15.55           C  
ATOM    671  O   ALA A 147      40.298  66.592  23.020  1.00 16.24           O  
ATOM    672  CB  ALA A 147      41.878  66.212  20.801  1.00 13.62           C  
ATOM    673  N   SER A 148      38.907  68.026  21.980  1.00 16.76           N  
ATOM    674  CA  SER A 148      38.293  68.480  23.217  1.00 18.20           C  
ATOM    675  C   SER A 148      36.788  68.343  23.152  1.00 20.98           C  
ATOM    676  O   SER A 148      36.203  68.304  22.067  1.00 23.54           O  
ATOM    677  CB  SER A 148      38.647  69.942  23.482  1.00 15.36           C  
ATOM    678  OG  SER A 148      40.048  70.123  23.538  1.00 19.42           O  
ATOM    679  N   VAL A 149      36.164  68.279  24.323  1.00 21.29           N  
ATOM    680  CA  VAL A 149      34.722  68.160  24.413  1.00 20.79           C  
ATOM    681  C   VAL A 149      34.089  69.426  24.973  1.00 23.14           C  
ATOM    682  O   VAL A 149      34.521  69.956  26.002  1.00 24.42           O  
ATOM    683  CB  VAL A 149      34.312  66.964  25.300  1.00 20.00           C  
ATOM    684  CG1 VAL A 149      32.812  66.994  25.565  1.00 14.96           C  
ATOM    685  CG2 VAL A 149      34.703  65.668  24.615  1.00 18.29           C  
ATOM    686  N   GLU A 150      33.078  69.916  24.264  1.00 22.92           N  
ATOM    687  CA  GLU A 150      32.336  71.094  24.679  1.00 22.99           C  
ATOM    688  C   GLU A 150      30.868  70.690  24.614  1.00 24.48           C  
ATOM    689  O   GLU A 150      30.255  70.719  23.548  1.00 22.26           O  
ATOM    690  CB  GLU A 150      32.584  72.270  23.736  1.00 20.59           C  
ATOM    691  CG  GLU A 150      32.071  73.582  24.290  1.00 20.27           C  
ATOM    692  CD  GLU A 150      32.058  74.694  23.269  1.00 23.05           C  
ATOM    693  OE1 GLU A 150      31.073  74.799  22.521  1.00 25.60           O  
ATOM    694  OE2 GLU A 150      33.034  75.466  23.208  1.00 26.64           O  
ATOM    695  N   GLU A 151      30.315  70.300  25.756  1.00 26.92           N  
ATOM    696  CA  GLU A 151      28.927  69.878  25.818  1.00 31.52           C  
ATOM    697  C   GLU A 151      27.955  70.789  25.078  1.00 32.59           C  
ATOM    698  O   GLU A 151      27.104  70.300  24.340  1.00 31.64           O  
ATOM    699  CB  GLU A 151      28.500  69.724  27.275  1.00 35.25           C  
ATOM    700  CG  GLU A 151      29.126  68.515  27.951  1.00 39.51           C  
ATOM    701  CD  GLU A 151      28.953  68.550  29.450  1.00 42.55           C  
ATOM    702  OE1 GLU A 151      29.459  69.508  30.077  1.00 42.16           O  
ATOM    703  OE2 GLU A 151      28.314  67.625  29.998  1.00 45.41           O  
ATOM    704  N   GLN A 152      28.078  72.103  25.261  1.00 34.48           N  
ATOM    705  CA  GLN A 152      27.180  73.046  24.587  1.00 37.09           C  
ATOM    706  C   GLN A 152      27.289  72.997  23.062  1.00 37.14           C  
ATOM    707  O   GLN A 152      26.348  73.358  22.354  1.00 38.20           O  
ATOM    708  CB  GLN A 152      27.437  74.481  25.069  1.00 38.75           C  
ATOM    709  CG  GLN A 152      28.859  74.742  25.508  1.00 41.64           C  
ATOM    710  CD  GLN A 152      29.143  74.171  26.878  1.00 42.93           C  
ATOM    711  OE1 GLN A 152      28.603  74.643  27.877  1.00 46.16           O  
ATOM    712  NE2 GLN A 152      29.987  73.147  26.937  1.00 43.08           N  
ATOM    713  N   GLU A 153      28.439  72.551  22.569  1.00 36.47           N  
ATOM    714  CA  GLU A 153      28.686  72.443  21.136  1.00 36.49           C  
ATOM    715  C   GLU A 153      28.331  73.699  20.346  1.00 35.88           C  
ATOM    716  O   GLU A 153      27.503  73.660  19.435  1.00 35.81           O  
ATOM    717  CB  GLU A 153      27.927  71.245  20.562  1.00 37.98           C  
ATOM    718  CG  GLU A 153      28.265  69.924  21.238  1.00 40.65           C  
ATOM    719  CD  GLU A 153      27.867  68.720  20.411  1.00 42.06           C  
ATOM    720  OE1 GLU A 153      28.583  68.406  19.435  1.00 41.87           O  
ATOM    721  OE2 GLU A 153      26.835  68.093  20.735  1.00 43.38           O  
ATOM    722  N   GLU A 154      28.970  74.810  20.688  1.00 35.31           N  
ATOM    723  CA  GLU A 154      28.729  76.071  19.997  1.00 35.67           C  
ATOM    724  C   GLU A 154      30.008  76.526  19.304  1.00 33.84           C  
ATOM    725  O   GLU A 154      29.962  77.159  18.245  1.00 34.86           O  
ATOM    726  CB  GLU A 154      28.276  77.148  20.986  1.00 37.81           C  
ATOM    727  CG  GLU A 154      27.093  76.752  21.856  1.00 40.17           C  
ATOM    728  CD  GLU A 154      26.489  77.940  22.565  1.00 42.24           C  
ATOM    729  OE1 GLU A 154      25.754  77.741  23.556  1.00 42.25           O  
ATOM    730  OE2 GLU A 154      26.747  79.080  22.121  1.00 44.69           O  
ATOM    731  N   THR A 155      31.144  76.200  19.915  1.00 29.01           N  
ATOM    732  CA  THR A 155      32.445  76.562  19.378  1.00 25.83           C  
ATOM    733  C   THR A 155      32.905  75.536  18.352  1.00 23.19           C  
ATOM    734  O   THR A 155      32.857  74.332  18.598  1.00 23.35           O  
ATOM    735  CB  THR A 155      33.498  76.661  20.502  1.00 25.77           C  
ATOM    736  OG1 THR A 155      33.158  77.748  21.369  1.00 29.15           O  
ATOM    737  CG2 THR A 155      34.892  76.909  19.928  1.00 26.18           C  
ATOM    738  N   PRO A 156      33.338  75.999  17.176  1.00 21.39           N  
ATOM    739  CA  PRO A 156      33.788  75.025  16.182  1.00 21.45           C  
ATOM    740  C   PRO A 156      34.872  74.123  16.772  1.00 21.02           C  
ATOM    741  O   PRO A 156      35.801  74.603  17.425  1.00 21.21           O  
ATOM    742  CB  PRO A 156      34.286  75.901  15.021  1.00 21.67           C  
ATOM    743  CG  PRO A 156      34.502  77.261  15.648  1.00 23.58           C  
ATOM    744  CD  PRO A 156      33.397  77.372  16.650  1.00 20.50           C  
ATOM    745  N   SER A 157      34.734  72.816  16.573  1.00 19.23           N  
ATOM    746  CA  SER A 157      35.711  71.883  17.111  1.00 20.16           C  
ATOM    747  C   SER A 157      35.865  70.663  16.221  1.00 18.89           C  
ATOM    748  O   SER A 157      34.958  70.305  15.469  1.00 17.98           O  
ATOM    749  CB  SER A 157      35.317  71.428  18.522  1.00 21.18           C  
ATOM    750  OG  SER A 157      34.465  70.294  18.487  1.00 19.76           O  
ATOM    751  N   VAL A 158      37.028  70.033  16.325  1.00 16.14           N  
ATOM    752  CA  VAL A 158      37.353  68.850  15.550  1.00 13.76           C  
ATOM    753  C   VAL A 158      37.794  67.780  16.533  1.00 14.49           C  
ATOM    754  O   VAL A 158      38.670  68.005  17.372  1.00 12.46           O  
ATOM    755  CB  VAL A 158      38.496  69.144  14.566  1.00 11.95           C  
ATOM    756  CG1 VAL A 158      38.860  67.890  13.791  1.00 12.74           C  
ATOM    757  CG2 VAL A 158      38.079  70.264  13.627  1.00 10.78           C  
ATOM    758  N   ALA A 159      37.171  66.616  16.429  1.00 15.16           N  
ATOM    759  CA  ALA A 159      37.472  65.498  17.310  1.00 15.36           C  
ATOM    760  C   ALA A 159      36.799  64.286  16.698  1.00 14.82           C  
ATOM    761  O   ALA A 159      36.450  64.303  15.518  1.00 15.98           O  
ATOM    762  CB  ALA A 159      36.899  65.771  18.694  1.00 13.26           C  
ATOM    763  N   ILE A 160      36.652  63.228  17.486  1.00 14.68           N  
ATOM    764  CA  ILE A 160      35.949  62.030  17.033  1.00 15.42           C  
ATOM    765  C   ILE A 160      34.783  61.909  17.999  1.00 16.54           C  
ATOM    766  O   ILE A 160      34.655  62.709  18.931  1.00 16.70           O  
ATOM    767  CB  ILE A 160      36.788  60.730  17.151  1.00 13.03           C  
ATOM    768  CG1 ILE A 160      37.272  60.546  18.596  1.00 13.10           C  
ATOM    769  CG2 ILE A 160      37.926  60.752  16.153  1.00 11.80           C  
ATOM    770  CD1 ILE A 160      37.798  59.144  18.907  1.00 11.96           C  
ATOM    771  N   ASP A 161      33.934  60.916  17.786  1.00 17.70           N  
ATOM    772  CA  ASP A 161      32.807  60.708  18.679  1.00 19.63           C  
ATOM    773  C   ASP A 161      33.277  59.759  19.781  1.00 17.55           C  
ATOM    774  O   ASP A 161      33.210  58.544  19.623  1.00 16.86           O  
ATOM    775  CB  ASP A 161      31.640  60.102  17.899  1.00 23.87           C  
ATOM    776  CG  ASP A 161      30.385  59.972  18.733  1.00 26.57           C  
ATOM    777  OD1 ASP A 161      29.312  59.733  18.144  1.00 30.74           O  
ATOM    778  OD2 ASP A 161      30.465  60.099  19.970  1.00 28.87           O  
ATOM    779  N   TYR A 162      33.754  60.317  20.892  1.00 16.85           N  
ATOM    780  CA  TYR A 162      34.258  59.504  22.000  1.00 19.00           C  
ATOM    781  C   TYR A 162      33.203  58.573  22.594  1.00 20.11           C  
ATOM    782  O   TYR A 162      33.509  57.442  22.977  1.00 20.84           O  
ATOM    783  CB  TYR A 162      34.840  60.396  23.100  1.00 18.00           C  
ATOM    784  CG  TYR A 162      35.983  61.268  22.627  1.00 16.85           C  
ATOM    785  CD1 TYR A 162      35.763  62.591  22.234  1.00 18.61           C  
ATOM    786  CD2 TYR A 162      37.274  60.758  22.520  1.00 14.95           C  
ATOM    787  CE1 TYR A 162      36.809  63.378  21.742  1.00 16.03           C  
ATOM    788  CE2 TYR A 162      38.314  61.525  22.033  1.00 12.98           C  
ATOM    789  CZ  TYR A 162      38.079  62.831  21.645  1.00 15.48           C  
ATOM    790  OH  TYR A 162      39.114  63.588  21.155  1.00 18.47           O  
ATOM    791  N   GLU A 163      31.967  59.059  22.662  1.00 21.31           N  
ATOM    792  CA  GLU A 163      30.842  58.288  23.181  1.00 22.79           C  
ATOM    793  C   GLU A 163      30.663  57.012  22.345  1.00 22.07           C  
ATOM    794  O   GLU A 163      30.650  55.905  22.882  1.00 21.79           O  
ATOM    795  CB  GLU A 163      29.571  59.152  23.131  1.00 25.89           C  
ATOM    796  CG  GLU A 163      28.359  58.622  23.906  1.00 29.33           C  
ATOM    797  CD  GLU A 163      27.617  57.507  23.179  1.00 33.46           C  
ATOM    798  OE1 GLU A 163      27.516  57.567  21.932  1.00 36.10           O  
ATOM    799  OE2 GLU A 163      27.115  56.581  23.851  1.00 34.37           O  
ATOM    800  N   GLN A 164      30.542  57.171  21.030  1.00 21.78           N  
ATOM    801  CA  GLN A 164      30.373  56.031  20.133  1.00 22.52           C  
ATOM    802  C   GLN A 164      31.535  55.050  20.218  1.00 23.05           C  
ATOM    803  O   GLN A 164      31.321  53.839  20.363  1.00 21.22           O  
ATOM    804  CB  GLN A 164      30.235  56.502  18.680  1.00 25.76           C  
ATOM    805  CG  GLN A 164      28.811  56.743  18.222  1.00 29.72           C  
ATOM    806  CD  GLN A 164      28.018  55.458  18.068  1.00 31.84           C  
ATOM    807  OE1 GLN A 164      26.787  55.474  18.070  1.00 33.82           O  
ATOM    808  NE2 GLN A 164      28.720  54.340  17.922  1.00 32.94           N  
ATOM    809  N   ALA A 165      32.758  55.580  20.126  1.00 20.50           N  
ATOM    810  CA  ALA A 165      33.966  54.760  20.166  1.00 18.61           C  
ATOM    811  C   ALA A 165      33.993  53.851  21.384  1.00 18.71           C  
ATOM    812  O   ALA A 165      34.260  52.659  21.262  1.00 19.82           O  
ATOM    813  CB  ALA A 165      35.213  55.647  20.141  1.00 16.12           C  
ATOM    814  N   ILE A 166      33.733  54.412  22.560  1.00 18.00           N  
ATOM    815  CA  ILE A 166      33.728  53.613  23.780  1.00 18.82           C  
ATOM    816  C   ILE A 166      32.608  52.566  23.681  1.00 19.69           C  
ATOM    817  O   ILE A 166      32.798  51.392  24.000  1.00 16.22           O  
ATOM    818  CB  ILE A 166      33.480  54.491  25.023  1.00 17.15           C  
ATOM    819  CG1 ILE A 166      34.660  55.443  25.247  1.00 17.38           C  
ATOM    820  CG2 ILE A 166      33.268  53.602  26.242  1.00 17.89           C  
ATOM    821  CD1 ILE A 166      35.942  54.751  25.727  1.00 12.75           C  
ATOM    822  N   TYR A 167      31.440  53.022  23.243  1.00 21.34           N  
ATOM    823  CA  TYR A 167      30.288  52.157  23.068  1.00 22.54           C  
ATOM    824  C   TYR A 167      30.673  50.970  22.195  1.00 21.72           C  
ATOM    825  O   TYR A 167      30.442  49.827  22.574  1.00 22.42           O  
ATOM    826  CB  TYR A 167      29.148  52.928  22.400  1.00 25.88           C  
ATOM    827  CG  TYR A 167      28.044  52.038  21.878  1.00 28.27           C  
ATOM    828  CD1 TYR A 167      27.016  51.606  22.706  1.00 28.50           C  
ATOM    829  CD2 TYR A 167      28.061  51.590  20.561  1.00 30.43           C  
ATOM    830  CE1 TYR A 167      26.030  50.747  22.234  1.00 32.78           C  
ATOM    831  CE2 TYR A 167      27.084  50.731  20.078  1.00 34.20           C  
ATOM    832  CZ  TYR A 167      26.071  50.311  20.917  1.00 34.07           C  
ATOM    833  OH  TYR A 167      25.107  49.453  20.426  1.00 35.23           O  
ATOM    834  N   ASP A 168      31.256  51.249  21.030  1.00 20.23           N  
ATOM    835  CA  ASP A 168      31.666  50.192  20.106  1.00 19.51           C  
ATOM    836  C   ASP A 168      32.615  49.201  20.763  1.00 19.55           C  
ATOM    837  O   ASP A 168      32.474  47.993  20.586  1.00 20.30           O  
ATOM    838  CB  ASP A 168      32.358  50.768  18.858  1.00 19.58           C  
ATOM    839  CG  ASP A 168      31.459  51.689  18.052  1.00 19.98           C  
ATOM    840  OD1 ASP A 168      30.224  51.500  18.069  1.00 17.60           O  
ATOM    841  OD2 ASP A 168      31.997  52.598  17.385  1.00 22.21           O  
ATOM    842  N   ALA A 169      33.596  49.719  21.498  1.00 18.49           N  
ATOM    843  CA  ALA A 169      34.572  48.880  22.183  1.00 17.52           C  
ATOM    844  C   ALA A 169      33.896  47.967  23.197  1.00 16.95           C  
ATOM    845  O   ALA A 169      34.219  46.784  23.285  1.00 16.26           O  
ATOM    846  CB  ALA A 169      35.610  49.747  22.884  1.00 16.20           C  
ATOM    847  N   VAL A 170      32.963  48.521  23.970  1.00 17.52           N  
ATOM    848  CA  VAL A 170      32.253  47.743  24.983  1.00 17.73           C  
ATOM    849  C   VAL A 170      31.350  46.696  24.328  1.00 19.07           C  
ATOM    850  O   VAL A 170      31.323  45.540  24.755  1.00 18.75           O  
ATOM    851  CB  VAL A 170      31.409  48.651  25.893  1.00 17.01           C  
ATOM    852  CG1 VAL A 170      30.613  47.805  26.888  1.00 17.87           C  
ATOM    853  CG2 VAL A 170      32.318  49.633  26.627  1.00 16.07           C  
ATOM    854  N   LYS A 171      30.619  47.102  23.290  1.00 20.23           N  
ATOM    855  CA  LYS A 171      29.735  46.189  22.571  1.00 24.84           C  
ATOM    856  C   LYS A 171      30.542  44.988  22.078  1.00 24.86           C  
ATOM    857  O   LYS A 171      30.127  43.834  22.207  1.00 24.47           O  
ATOM    858  CB  LYS A 171      29.088  46.899  21.377  1.00 29.02           C  
ATOM    859  CG  LYS A 171      28.133  46.016  20.567  1.00 32.23           C  
ATOM    860  CD  LYS A 171      27.587  46.767  19.362  1.00 37.54           C  
ATOM    861  CE  LYS A 171      26.669  45.892  18.517  1.00 39.68           C  
ATOM    862  NZ  LYS A 171      26.109  46.650  17.354  1.00 42.30           N  
ATOM    863  N   LEU A 172      31.703  45.273  21.509  1.00 24.91           N  
ATOM    864  CA  LEU A 172      32.579  44.233  21.014  1.00 25.51           C  
ATOM    865  C   LEU A 172      32.843  43.234  22.140  1.00 26.87           C  
ATOM    866  O   LEU A 172      32.575  42.043  21.989  1.00 28.94           O  
ATOM    867  CB  LEU A 172      33.880  44.868  20.527  1.00 24.05           C  
ATOM    868  CG  LEU A 172      34.976  43.977  19.957  1.00 23.88           C  
ATOM    869  CD1 LEU A 172      35.825  44.783  18.985  1.00 21.84           C  
ATOM    870  CD2 LEU A 172      35.813  43.414  21.098  1.00 25.62           C  
ATOM    871  N   LEU A 173      33.344  43.725  23.272  1.00 26.66           N  
ATOM    872  CA  LEU A 173      33.635  42.867  24.421  1.00 27.13           C  
ATOM    873  C   LEU A 173      32.417  42.044  24.836  1.00 27.63           C  
ATOM    874  O   LEU A 173      32.550  40.872  25.179  1.00 27.21           O  
ATOM    875  CB  LEU A 173      34.124  43.704  25.611  1.00 25.21           C  
ATOM    876  CG  LEU A 173      35.489  44.378  25.460  1.00 22.30           C  
ATOM    877  CD1 LEU A 173      35.799  45.236  26.672  1.00 20.63           C  
ATOM    878  CD2 LEU A 173      36.549  43.315  25.290  1.00 23.66           C  
ATOM    879  N   VAL A 174      31.236  42.656  24.808  1.00 28.01           N  
ATOM    880  CA  VAL A 174      30.010  41.949  25.169  1.00 30.16           C  
ATOM    881  C   VAL A 174      29.710  40.833  24.163  1.00 32.40           C  
ATOM    882  O   VAL A 174      29.401  39.704  24.553  1.00 33.39           O  
ATOM    883  CB  VAL A 174      28.786  42.900  25.215  1.00 30.27           C  
ATOM    884  CG1 VAL A 174      27.492  42.088  25.282  1.00 28.84           C  
ATOM    885  CG2 VAL A 174      28.883  43.821  26.415  1.00 30.80           C  
ATOM    886  N   ASP A 175      29.800  41.150  22.871  1.00 32.51           N  
ATOM    887  CA  ASP A 175      29.528  40.162  21.830  1.00 31.78           C  
ATOM    888  C   ASP A 175      30.434  38.956  21.985  1.00 32.32           C  
ATOM    889  O   ASP A 175      30.184  37.906  21.396  1.00 32.48           O  
ATOM    890  CB  ASP A 175      29.730  40.759  20.431  1.00 30.47           C  
ATOM    891  CG  ASP A 175      28.656  41.772  20.057  1.00 30.04           C  
ATOM    892  OD1 ASP A 175      27.620  41.853  20.757  1.00 25.92           O  
ATOM    893  OD2 ASP A 175      28.849  42.484  19.048  1.00 30.81           O  
ATOM    894  N   LYS A 176      31.484  39.106  22.786  1.00 33.59           N  
ATOM    895  CA  LYS A 176      32.431  38.021  23.008  1.00 34.01           C  
ATOM    896  C   LYS A 176      32.134  37.197  24.264  1.00 33.83           C  
ATOM    897  O   LYS A 176      32.837  36.230  24.550  1.00 34.90           O  
ATOM    898  CB  LYS A 176      33.861  38.575  23.067  1.00 35.12           C  
ATOM    899  CG  LYS A 176      34.285  39.294  21.795  1.00 37.26           C  
ATOM    900  CD  LYS A 176      35.626  38.794  21.274  1.00 40.06           C  
ATOM    901  CE  LYS A 176      35.930  39.379  19.893  1.00 42.35           C  
ATOM    902  NZ  LYS A 176      37.235  38.912  19.346  1.00 41.94           N  
ATOM    903  N   GLY A 177      31.101  37.576  25.013  1.00 32.78           N  
ATOM    904  CA  GLY A 177      30.756  36.826  26.209  1.00 32.13           C  
ATOM    905  C   GLY A 177      31.019  37.480  27.557  1.00 32.14           C  
ATOM    906  O   GLY A 177      30.691  36.904  28.594  1.00 32.17           O  
ATOM    907  N   HIS A 178      31.606  38.673  27.558  1.00 30.84           N  
ATOM    908  CA  HIS A 178      31.894  39.366  28.810  1.00 29.87           C  
ATOM    909  C   HIS A 178      30.644  39.946  29.461  1.00 31.28           C  
ATOM    910  O   HIS A 178      29.798  40.556  28.794  1.00 30.57           O  
ATOM    911  CB  HIS A 178      32.912  40.476  28.575  1.00 28.18           C  
ATOM    912  CG  HIS A 178      34.275  39.970  28.227  1.00 25.63           C  
ATOM    913  ND1 HIS A 178      35.075  39.309  29.134  1.00 25.95           N  
ATOM    914  CD2 HIS A 178      34.961  39.989  27.062  1.00 22.90           C  
ATOM    915  CE1 HIS A 178      36.197  38.942  28.540  1.00 25.63           C  
ATOM    916  NE2 HIS A 178      36.152  39.343  27.281  1.00 21.34           N  
ATOM    917  N   THR A 179      30.542  39.746  30.772  1.00 30.96           N  
ATOM    918  CA  THR A 179      29.414  40.231  31.555  1.00 32.21           C  
ATOM    919  C   THR A 179      29.884  41.260  32.565  1.00 30.85           C  
ATOM    920  O   THR A 179      29.191  42.241  32.849  1.00 31.20           O  
ATOM    921  CB  THR A 179      28.737  39.077  32.306  1.00 34.00           C  
ATOM    922  OG1 THR A 179      28.043  38.250  31.364  1.00 37.33           O  
ATOM    923  CG2 THR A 179      27.763  39.608  33.344  1.00 33.62           C  
ATOM    924  N   ASP A 180      31.071  41.014  33.106  1.00 29.20           N  
ATOM    925  CA  ASP A 180      31.686  41.890  34.084  1.00 27.85           C  
ATOM    926  C   ASP A 180      32.791  42.677  33.367  1.00 26.58           C  
ATOM    927  O   ASP A 180      33.961  42.279  33.358  1.00 26.74           O  
ATOM    928  CB  ASP A 180      32.253  41.045  35.230  1.00 29.88           C  
ATOM    929  CG  ASP A 180      31.187  40.165  35.889  1.00 31.47           C  
ATOM    930  OD1 ASP A 180      30.159  40.719  36.323  1.00 30.05           O  
ATOM    931  OD2 ASP A 180      31.371  38.926  35.974  1.00 32.48           O  
ATOM    932  N   ILE A 181      32.402  43.793  32.759  1.00 23.47           N  
ATOM    933  CA  ILE A 181      33.329  44.637  32.009  1.00 21.75           C  
ATOM    934  C   ILE A 181      33.676  45.919  32.776  1.00 20.83           C  
ATOM    935  O   ILE A 181      32.784  46.623  33.257  1.00 17.98           O  
ATOM    936  CB  ILE A 181      32.721  45.009  30.631  1.00 20.65           C  
ATOM    937  CG1 ILE A 181      32.368  43.728  29.863  1.00 20.24           C  
ATOM    938  CG2 ILE A 181      33.700  45.867  29.834  1.00 19.24           C  
ATOM    939  CD1 ILE A 181      31.547  43.947  28.593  1.00 17.35           C  
ATOM    940  N   ALA A 182      34.970  46.218  32.876  1.00 19.74           N  
ATOM    941  CA  ALA A 182      35.438  47.406  33.594  1.00 18.66           C  
ATOM    942  C   ALA A 182      35.938  48.539  32.697  1.00 19.23           C  
ATOM    943  O   ALA A 182      36.443  48.310  31.591  1.00 18.61           O  
ATOM    944  CB  ALA A 182      36.533  47.020  34.573  1.00 20.10           C  
ATOM    945  N   PHE A 183      35.800  49.765  33.195  1.00 17.54           N  
ATOM    946  CA  PHE A 183      36.246  50.949  32.473  1.00 16.70           C  
ATOM    947  C   PHE A 183      37.188  51.806  33.315  1.00 16.53           C  
ATOM    948  O   PHE A 183      36.804  52.303  34.381  1.00 15.63           O  
ATOM    949  CB  PHE A 183      35.055  51.821  32.066  1.00 15.68           C  
ATOM    950  CG  PHE A 183      35.452  53.143  31.447  1.00 14.75           C  
ATOM    951  CD1 PHE A 183      34.811  54.323  31.821  1.00 15.15           C  
ATOM    952  CD2 PHE A 183      36.461  53.208  30.483  1.00 13.81           C  
ATOM    953  CE1 PHE A 183      35.168  55.548  31.247  1.00 11.49           C  
ATOM    954  CE2 PHE A 183      36.824  54.422  29.902  1.00 12.58           C  
ATOM    955  CZ  PHE A 183      36.175  55.596  30.288  1.00 12.74           C  
ATOM    956  N   VAL A 184      38.418  51.978  32.833  1.00 15.87           N  
ATOM    957  CA  VAL A 184      39.398  52.814  33.517  1.00 15.08           C  
ATOM    958  C   VAL A 184      39.400  54.146  32.772  1.00 15.96           C  
ATOM    959  O   VAL A 184      39.956  54.246  31.681  1.00 16.37           O  
ATOM    960  CB  VAL A 184      40.820  52.212  33.463  1.00 14.50           C  
ATOM    961  CG1 VAL A 184      41.824  53.188  34.086  1.00 13.27           C  
ATOM    962  CG2 VAL A 184      40.859  50.896  34.207  1.00 12.28           C  
ATOM    963  N   SER A 185      38.769  55.161  33.358  1.00 16.25           N  
ATOM    964  CA  SER A 185      38.680  56.484  32.735  1.00 14.89           C  
ATOM    965  C   SER A 185      39.760  57.457  33.188  1.00 15.27           C  
ATOM    966  O   SER A 185      40.645  57.122  33.981  1.00 16.18           O  
ATOM    967  CB  SER A 185      37.332  57.128  33.059  1.00 16.90           C  
ATOM    968  OG  SER A 185      37.309  57.593  34.398  1.00 12.71           O  
ATOM    969  N   GLY A 186      39.677  58.674  32.666  1.00 13.15           N  
ATOM    970  CA  GLY A 186      40.608  59.703  33.075  1.00 14.31           C  
ATOM    971  C   GLY A 186      39.863  60.446  34.170  1.00 13.89           C  
ATOM    972  O   GLY A 186      38.781  60.009  34.563  1.00 13.31           O  
ATOM    973  N   PRO A 187      40.396  61.557  34.691  1.00 13.78           N  
ATOM    974  CA  PRO A 187      39.649  62.257  35.745  1.00 13.93           C  
ATOM    975  C   PRO A 187      38.187  62.510  35.364  1.00 14.17           C  
ATOM    976  O   PRO A 187      37.900  63.051  34.297  1.00 11.75           O  
ATOM    977  CB  PRO A 187      40.442  63.555  35.946  1.00 11.90           C  
ATOM    978  CG  PRO A 187      41.302  63.674  34.720  1.00 14.26           C  
ATOM    979  CD  PRO A 187      41.653  62.252  34.375  1.00 13.84           C  
ATOM    980  N   MET A 188      37.271  62.103  36.240  1.00 15.24           N  
ATOM    981  CA  MET A 188      35.840  62.281  35.988  1.00 18.82           C  
ATOM    982  C   MET A 188      35.448  63.752  35.990  1.00 18.68           C  
ATOM    983  O   MET A 188      34.341  64.103  35.603  1.00 20.04           O  
ATOM    984  CB  MET A 188      35.005  61.526  37.027  1.00 18.38           C  
ATOM    985  CG  MET A 188      35.128  60.018  36.929  1.00 21.55           C  
ATOM    986  SD  MET A 188      34.455  59.367  35.388  1.00 22.94           S  
ATOM    987  CE  MET A 188      33.638  57.876  35.990  1.00 24.77           C  
ATOM    988  N   ALA A 189      36.363  64.608  36.424  1.00 18.40           N  
ATOM    989  CA  ALA A 189      36.103  66.037  36.453  1.00 20.72           C  
ATOM    990  C   ALA A 189      36.110  66.596  35.029  1.00 21.22           C  
ATOM    991  O   ALA A 189      35.675  67.727  34.788  1.00 23.96           O  
ATOM    992  CB  ALA A 189      37.154  66.735  37.302  1.00 19.73           C  
ATOM    993  N   GLU A 190      36.605  65.801  34.086  1.00 21.12           N  
ATOM    994  CA  GLU A 190      36.656  66.215  32.688  1.00 19.14           C  
ATOM    995  C   GLU A 190      35.460  65.646  31.950  1.00 18.24           C  
ATOM    996  O   GLU A 190      35.233  64.439  31.962  1.00 18.46           O  
ATOM    997  CB  GLU A 190      37.937  65.721  32.011  1.00 17.82           C  
ATOM    998  CG  GLU A 190      39.223  66.257  32.612  1.00 18.99           C  
ATOM    999  CD  GLU A 190      40.455  65.688  31.935  1.00 20.49           C  
ATOM   1000  OE1 GLU A 190      41.578  65.941  32.408  1.00 20.73           O  
ATOM   1001  OE2 GLU A 190      40.301  64.982  30.920  1.00 25.18           O  
ATOM   1002  N   PRO A 191      34.673  66.516  31.302  1.00 18.53           N  
ATOM   1003  CA  PRO A 191      33.484  66.121  30.541  1.00 17.71           C  
ATOM   1004  C   PRO A 191      33.718  64.950  29.582  1.00 19.02           C  
ATOM   1005  O   PRO A 191      32.861  64.081  29.449  1.00 18.52           O  
ATOM   1006  CB  PRO A 191      33.112  67.406  29.814  1.00 17.89           C  
ATOM   1007  CG  PRO A 191      33.454  68.462  30.846  1.00 16.80           C  
ATOM   1008  CD  PRO A 191      34.802  67.988  31.356  1.00 18.78           C  
ATOM   1009  N   ILE A 192      34.876  64.916  28.924  1.00 20.18           N  
ATOM   1010  CA  ILE A 192      35.175  63.835  27.985  1.00 20.60           C  
ATOM   1011  C   ILE A 192      35.106  62.468  28.663  1.00 21.10           C  
ATOM   1012  O   ILE A 192      34.827  61.456  28.025  1.00 20.29           O  
ATOM   1013  CB  ILE A 192      36.581  63.991  27.348  1.00 20.83           C  
ATOM   1014  CG1 ILE A 192      36.797  62.906  26.285  1.00 20.90           C  
ATOM   1015  CG2 ILE A 192      37.660  63.850  28.407  1.00 19.19           C  
ATOM   1016  CD1 ILE A 192      38.053  63.094  25.452  1.00 21.65           C  
ATOM   1017  N   ASN A 193      35.366  62.443  29.962  1.00 21.13           N  
ATOM   1018  CA  ASN A 193      35.334  61.197  30.705  1.00 22.09           C  
ATOM   1019  C   ASN A 193      33.953  60.929  31.279  1.00 24.55           C  
ATOM   1020  O   ASN A 193      33.325  59.922  30.960  1.00 25.38           O  
ATOM   1021  CB  ASN A 193      36.371  61.234  31.828  1.00 18.75           C  
ATOM   1022  CG  ASN A 193      37.797  61.047  31.311  1.00 17.79           C  
ATOM   1023  OD1 ASN A 193      38.699  61.812  31.650  1.00 14.25           O  
ATOM   1024  ND2 ASN A 193      38.002  60.015  30.498  1.00 12.27           N  
ATOM   1025  N   ARG A 194      33.470  61.848  32.104  1.00 26.80           N  
ATOM   1026  CA  ARG A 194      32.173  61.693  32.743  1.00 28.51           C  
ATOM   1027  C   ARG A 194      30.963  61.859  31.823  1.00 27.44           C  
ATOM   1028  O   ARG A 194      29.975  61.147  31.976  1.00 27.15           O  
ATOM   1029  CB  ARG A 194      32.053  62.666  33.919  1.00 32.43           C  
ATOM   1030  CG  ARG A 194      30.764  62.505  34.705  1.00 40.91           C  
ATOM   1031  CD  ARG A 194      30.741  63.345  35.976  1.00 46.21           C  
ATOM   1032  NE  ARG A 194      29.546  63.067  36.776  1.00 50.54           N  
ATOM   1033  CZ  ARG A 194      29.305  63.589  37.976  1.00 53.02           C  
ATOM   1034  NH1 ARG A 194      30.178  64.424  38.526  1.00 53.39           N  
ATOM   1035  NH2 ARG A 194      28.190  63.276  38.627  1.00 53.86           N  
ATOM   1036  N   SER A 195      31.040  62.781  30.867  1.00 26.22           N  
ATOM   1037  CA  SER A 195      29.917  63.034  29.966  1.00 24.29           C  
ATOM   1038  C   SER A 195      29.939  62.337  28.606  1.00 23.57           C  
ATOM   1039  O   SER A 195      28.909  62.276  27.934  1.00 23.92           O  
ATOM   1040  CB  SER A 195      29.772  64.538  29.730  1.00 24.10           C  
ATOM   1041  OG  SER A 195      29.611  65.231  30.954  1.00 27.21           O  
ATOM   1042  N   LYS A 196      31.090  61.816  28.192  1.00 21.07           N  
ATOM   1043  CA  LYS A 196      31.184  61.160  26.887  1.00 20.48           C  
ATOM   1044  C   LYS A 196      31.601  59.687  26.948  1.00 20.00           C  
ATOM   1045  O   LYS A 196      30.804  58.797  26.653  1.00 19.25           O  
ATOM   1046  CB  LYS A 196      32.158  61.933  25.983  1.00 21.73           C  
ATOM   1047  CG  LYS A 196      31.745  63.367  25.670  1.00 17.75           C  
ATOM   1048  CD  LYS A 196      30.394  63.405  24.975  1.00 20.79           C  
ATOM   1049  CE  LYS A 196      29.924  64.826  24.713  1.00 19.86           C  
ATOM   1050  NZ  LYS A 196      28.589  64.838  24.062  1.00 20.89           N  
ATOM   1051  N   LYS A 197      32.851  59.436  27.321  1.00 18.52           N  
ATOM   1052  CA  LYS A 197      33.344  58.071  27.413  1.00 20.20           C  
ATOM   1053  C   LYS A 197      32.564  57.208  28.407  1.00 20.83           C  
ATOM   1054  O   LYS A 197      32.287  56.044  28.123  1.00 22.43           O  
ATOM   1055  CB  LYS A 197      34.833  58.071  27.762  1.00 18.90           C  
ATOM   1056  CG  LYS A 197      35.711  58.514  26.603  1.00 17.05           C  
ATOM   1057  CD  LYS A 197      37.180  58.500  26.962  1.00 14.52           C  
ATOM   1058  CE  LYS A 197      38.037  58.922  25.767  1.00 14.83           C  
ATOM   1059  NZ  LYS A 197      39.489  58.976  26.115  1.00 12.88           N  
ATOM   1060  N   LEU A 198      32.201  57.766  29.558  1.00 19.95           N  
ATOM   1061  CA  LEU A 198      31.452  56.998  30.551  1.00 20.03           C  
ATOM   1062  C   LEU A 198      30.037  56.717  30.061  1.00 21.14           C  
ATOM   1063  O   LEU A 198      29.452  55.682  30.379  1.00 19.74           O  
ATOM   1064  CB  LEU A 198      31.394  57.738  31.894  1.00 17.16           C  
ATOM   1065  CG  LEU A 198      30.629  57.016  33.011  1.00 17.04           C  
ATOM   1066  CD1 LEU A 198      31.182  55.607  33.210  1.00 11.29           C  
ATOM   1067  CD2 LEU A 198      30.731  57.820  34.298  1.00 15.68           C  
ATOM   1068  N   GLN A 199      29.490  57.636  29.274  1.00 22.53           N  
ATOM   1069  CA  GLN A 199      28.147  57.457  28.741  1.00 23.84           C  
ATOM   1070  C   GLN A 199      28.096  56.352  27.697  1.00 23.01           C  
ATOM   1071  O   GLN A 199      27.117  55.605  27.628  1.00 23.66           O  
ATOM   1072  CB  GLN A 199      27.626  58.762  28.136  1.00 27.08           C  
ATOM   1073  CG  GLN A 199      27.229  59.795  29.172  1.00 31.67           C  
ATOM   1074  CD  GLN A 199      26.458  59.176  30.323  1.00 36.45           C  
ATOM   1075  OE1 GLN A 199      27.051  58.621  31.252  1.00 38.71           O  
ATOM   1076  NE2 GLN A 199      25.127  59.248  30.259  1.00 37.52           N  
ATOM   1077  N   GLY A 200      29.145  56.254  26.882  1.00 20.76           N  
ATOM   1078  CA  GLY A 200      29.193  55.218  25.867  1.00 18.67           C  
ATOM   1079  C   GLY A 200      29.313  53.865  26.545  1.00 20.49           C  
ATOM   1080  O   GLY A 200      28.802  52.853  26.062  1.00 21.41           O  
ATOM   1081  N   TYR A 201      30.007  53.849  27.675  1.00 20.21           N  
ATOM   1082  CA  TYR A 201      30.180  52.632  28.450  1.00 19.80           C  
ATOM   1083  C   TYR A 201      28.818  52.232  29.020  1.00 20.66           C  
ATOM   1084  O   TYR A 201      28.390  51.085  28.895  1.00 18.72           O  
ATOM   1085  CB  TYR A 201      31.190  52.895  29.568  1.00 18.97           C  
ATOM   1086  CG  TYR A 201      31.292  51.827  30.638  1.00 19.92           C  
ATOM   1087  CD1 TYR A 201      30.727  52.025  31.900  1.00 18.86           C  
ATOM   1088  CD2 TYR A 201      31.984  50.638  30.407  1.00 19.34           C  
ATOM   1089  CE1 TYR A 201      30.856  51.078  32.906  1.00 17.45           C  
ATOM   1090  CE2 TYR A 201      32.114  49.675  31.412  1.00 19.08           C  
ATOM   1091  CZ  TYR A 201      31.548  49.907  32.660  1.00 18.98           C  
ATOM   1092  OH  TYR A 201      31.686  48.980  33.671  1.00 18.45           O  
ATOM   1093  N   LYS A 202      28.132  53.195  29.625  1.00 23.31           N  
ATOM   1094  CA  LYS A 202      26.822  52.953  30.216  1.00 25.98           C  
ATOM   1095  C   LYS A 202      25.811  52.459  29.187  1.00 27.65           C  
ATOM   1096  O   LYS A 202      25.089  51.490  29.431  1.00 27.05           O  
ATOM   1097  CB  LYS A 202      26.288  54.227  30.873  1.00 25.92           C  
ATOM   1098  CG  LYS A 202      27.036  54.653  32.111  1.00 28.44           C  
ATOM   1099  CD  LYS A 202      26.397  55.897  32.717  1.00 31.70           C  
ATOM   1100  CE  LYS A 202      27.161  56.369  33.946  1.00 33.62           C  
ATOM   1101  NZ  LYS A 202      26.648  57.673  34.455  1.00 35.85           N  
ATOM   1102  N   ARG A 203      25.770  53.124  28.034  1.00 29.37           N  
ATOM   1103  CA  ARG A 203      24.835  52.756  26.975  1.00 29.83           C  
ATOM   1104  C   ARG A 203      25.053  51.338  26.457  1.00 28.47           C  
ATOM   1105  O   ARG A 203      24.092  50.611  26.209  1.00 28.90           O  
ATOM   1106  CB  ARG A 203      24.925  53.752  25.811  1.00 32.76           C  
ATOM   1107  CG  ARG A 203      23.847  53.551  24.749  1.00 34.54           C  
ATOM   1108  CD  ARG A 203      23.970  54.557  23.609  1.00 36.83           C  
ATOM   1109  NE  ARG A 203      25.110  54.283  22.735  1.00 37.83           N  
ATOM   1110  CZ  ARG A 203      25.490  55.076  21.741  1.00 38.04           C  
ATOM   1111  NH1 ARG A 203      24.826  56.196  21.494  1.00 40.84           N  
ATOM   1112  NH2 ARG A 203      26.534  54.757  20.993  1.00 38.26           N  
ATOM   1113  N   ALA A 204      26.311  50.943  26.294  1.00 26.98           N  
ATOM   1114  CA  ALA A 204      26.624  49.606  25.797  1.00 26.31           C  
ATOM   1115  C   ALA A 204      26.119  48.528  26.753  1.00 26.56           C  
ATOM   1116  O   ALA A 204      25.496  47.555  26.328  1.00 24.76           O  
ATOM   1117  CB  ALA A 204      28.131  49.456  25.591  1.00 23.21           C  
ATOM   1118  N   LEU A 205      26.399  48.698  28.041  1.00 27.52           N  
ATOM   1119  CA  LEU A 205      25.955  47.730  29.038  1.00 28.43           C  
ATOM   1120  C   LEU A 205      24.428  47.668  29.075  1.00 29.09           C  
ATOM   1121  O   LEU A 205      23.837  46.600  28.953  1.00 27.11           O  
ATOM   1122  CB  LEU A 205      26.491  48.099  30.428  1.00 26.28           C  
ATOM   1123  CG  LEU A 205      28.002  48.022  30.686  1.00 24.20           C  
ATOM   1124  CD1 LEU A 205      28.271  48.468  32.112  1.00 23.72           C  
ATOM   1125  CD2 LEU A 205      28.527  46.606  30.474  1.00 20.84           C  
ATOM   1126  N   GLU A 206      23.794  48.822  29.230  1.00 31.69           N  
ATOM   1127  CA  GLU A 206      22.338  48.884  29.291  1.00 35.35           C  
ATOM   1128  C   GLU A 206      21.671  48.250  28.077  1.00 36.36           C  
ATOM   1129  O   GLU A 206      20.608  47.633  28.187  1.00 36.39           O  
ATOM   1130  CB  GLU A 206      21.880  50.333  29.400  1.00 37.21           C  
ATOM   1131  CG  GLU A 206      20.389  50.499  29.247  1.00 44.47           C  
ATOM   1132  CD  GLU A 206      20.017  51.860  28.705  1.00 50.11           C  
ATOM   1133  OE1 GLU A 206      20.234  52.867  29.415  1.00 53.52           O  
ATOM   1134  OE2 GLU A 206      19.513  51.922  27.559  1.00 53.26           O  
ATOM   1135  N   GLU A 207      22.298  48.414  26.919  1.00 37.78           N  
ATOM   1136  CA  GLU A 207      21.767  47.877  25.677  1.00 37.83           C  
ATOM   1137  C   GLU A 207      21.924  46.369  25.627  1.00 36.97           C  
ATOM   1138  O   GLU A 207      21.146  45.681  24.971  1.00 38.34           O  
ATOM   1139  CB  GLU A 207      22.476  48.532  24.496  1.00 40.88           C  
ATOM   1140  CG  GLU A 207      21.922  48.166  23.136  1.00 45.25           C  
ATOM   1141  CD  GLU A 207      22.380  49.130  22.054  1.00 48.66           C  
ATOM   1142  OE1 GLU A 207      22.204  48.807  20.859  1.00 51.11           O  
ATOM   1143  OE2 GLU A 207      22.907  50.216  22.395  1.00 47.96           O  
ATOM   1144  N   ALA A 208      22.930  45.855  26.328  1.00 35.79           N  
ATOM   1145  CA  ALA A 208      23.171  44.420  26.377  1.00 35.04           C  
ATOM   1146  C   ALA A 208      22.430  43.848  27.587  1.00 36.91           C  
ATOM   1147  O   ALA A 208      22.592  42.676  27.941  1.00 36.81           O  
ATOM   1148  CB  ALA A 208      24.659  44.142  26.494  1.00 33.33           C  
ATOM   1149  N   ASN A 209      21.611  44.691  28.210  1.00 37.16           N  
ATOM   1150  CA  ASN A 209      20.835  44.307  29.383  1.00 39.23           C  
ATOM   1151  C   ASN A 209      21.708  43.937  30.570  1.00 38.27           C  
ATOM   1152  O   ASN A 209      21.442  42.958  31.267  1.00 39.36           O  
ATOM   1153  CB  ASN A 209      19.901  43.143  29.048  1.00 41.90           C  
ATOM   1154  CG  ASN A 209      18.643  43.597  28.343  1.00 44.56           C  
ATOM   1155  OD1 ASN A 209      17.963  42.803  27.692  1.00 48.15           O  
ATOM   1156  ND2 ASN A 209      18.317  44.881  28.477  1.00 44.79           N  
ATOM   1157  N   LEU A 210      22.749  44.732  30.795  1.00 36.30           N  
ATOM   1158  CA  LEU A 210      23.667  44.515  31.905  1.00 34.35           C  
ATOM   1159  C   LEU A 210      23.576  45.719  32.849  1.00 32.92           C  
ATOM   1160  O   LEU A 210      23.380  46.855  32.408  1.00 31.96           O  
ATOM   1161  CB  LEU A 210      25.099  44.353  31.377  1.00 32.59           C  
ATOM   1162  CG  LEU A 210      25.304  43.184  30.404  1.00 31.98           C  
ATOM   1163  CD1 LEU A 210      26.650  43.289  29.699  1.00 29.01           C  
ATOM   1164  CD2 LEU A 210      25.194  41.885  31.176  1.00 31.12           C  
ATOM   1165  N   PRO A 211      23.700  45.481  34.163  1.00 32.39           N  
ATOM   1166  CA  PRO A 211      23.625  46.572  35.142  1.00 32.03           C  
ATOM   1167  C   PRO A 211      24.882  47.435  35.170  1.00 30.54           C  
ATOM   1168  O   PRO A 211      25.986  46.948  34.926  1.00 30.18           O  
ATOM   1169  CB  PRO A 211      23.427  45.829  36.457  1.00 30.56           C  
ATOM   1170  CG  PRO A 211      24.285  44.614  36.253  1.00 31.51           C  
ATOM   1171  CD  PRO A 211      23.908  44.187  34.840  1.00 31.92           C  
ATOM   1172  N   PHE A 212      24.708  48.719  35.459  1.00 30.26           N  
ATOM   1173  CA  PHE A 212      25.839  49.625  35.557  1.00 30.21           C  
ATOM   1174  C   PHE A 212      26.322  49.651  37.005  1.00 29.14           C  
ATOM   1175  O   PHE A 212      25.663  50.223  37.864  1.00 30.65           O  
ATOM   1176  CB  PHE A 212      25.453  51.048  35.145  1.00 30.18           C  
ATOM   1177  CG  PHE A 212      26.483  52.078  35.527  1.00 30.31           C  
ATOM   1178  CD1 PHE A 212      27.751  52.062  34.949  1.00 30.40           C  
ATOM   1179  CD2 PHE A 212      26.210  53.020  36.516  1.00 30.74           C  
ATOM   1180  CE1 PHE A 212      28.740  52.968  35.354  1.00 30.39           C  
ATOM   1181  CE2 PHE A 212      27.186  53.929  36.930  1.00 30.92           C  
ATOM   1182  CZ  PHE A 212      28.457  53.901  36.347  1.00 30.91           C  
ATOM   1183  N   ASN A 213      27.466  49.033  37.277  1.00 28.57           N  
ATOM   1184  CA  ASN A 213      28.007  49.018  38.637  1.00 26.82           C  
ATOM   1185  C   ASN A 213      29.304  49.828  38.778  1.00 25.94           C  
ATOM   1186  O   ASN A 213      30.330  49.487  38.183  1.00 25.27           O  
ATOM   1187  CB  ASN A 213      28.237  47.574  39.096  1.00 25.27           C  
ATOM   1188  CG  ASN A 213      28.897  47.495  40.455  1.00 25.00           C  
ATOM   1189  OD1 ASN A 213      28.766  48.404  41.273  1.00 25.63           O  
ATOM   1190  ND2 ASN A 213      29.604  46.400  40.710  1.00 25.40           N  
ATOM   1191  N   GLU A 214      29.237  50.897  39.571  1.00 24.05           N  
ATOM   1192  CA  GLU A 214      30.374  51.782  39.826  1.00 23.78           C  
ATOM   1193  C   GLU A 214      31.667  51.055  40.160  1.00 22.41           C  
ATOM   1194  O   GLU A 214      32.748  51.554  39.870  1.00 21.02           O  
ATOM   1195  CB  GLU A 214      30.074  52.721  40.996  1.00 25.80           C  
ATOM   1196  CG  GLU A 214      29.530  54.079  40.629  1.00 27.96           C  
ATOM   1197  CD  GLU A 214      29.376  54.984  41.844  1.00 29.68           C  
ATOM   1198  OE1 GLU A 214      29.073  56.182  41.654  1.00 34.17           O  
ATOM   1199  OE2 GLU A 214      29.554  54.507  42.986  1.00 25.77           O  
ATOM   1200  N   GLN A 215      31.557  49.894  40.796  1.00 21.01           N  
ATOM   1201  CA  GLN A 215      32.743  49.144  41.192  1.00 21.41           C  
ATOM   1202  C   GLN A 215      33.628  48.779  40.008  1.00 21.01           C  
ATOM   1203  O   GLN A 215      34.827  48.559  40.173  1.00 20.20           O  
ATOM   1204  CB  GLN A 215      32.344  47.871  41.935  1.00 22.74           C  
ATOM   1205  CG  GLN A 215      31.352  48.089  43.052  1.00 25.38           C  
ATOM   1206  CD  GLN A 215      31.060  46.820  43.814  1.00 25.58           C  
ATOM   1207  OE1 GLN A 215      31.691  46.532  44.831  1.00 24.89           O  
ATOM   1208  NE2 GLN A 215      30.106  46.042  43.314  1.00 26.29           N  
ATOM   1209  N   PHE A 216      33.027  48.715  38.824  1.00 19.08           N  
ATOM   1210  CA  PHE A 216      33.743  48.373  37.606  1.00 19.87           C  
ATOM   1211  C   PHE A 216      34.248  49.603  36.858  1.00 20.79           C  
ATOM   1212  O   PHE A 216      34.551  49.539  35.664  1.00 21.00           O  
ATOM   1213  CB  PHE A 216      32.851  47.535  36.695  1.00 21.76           C  
ATOM   1214  CG  PHE A 216      32.632  46.138  37.189  1.00 23.36           C  
ATOM   1215  CD1 PHE A 216      31.472  45.451  36.867  1.00 25.75           C  
ATOM   1216  CD2 PHE A 216      33.597  45.497  37.952  1.00 24.49           C  
ATOM   1217  CE1 PHE A 216      31.279  44.147  37.296  1.00 26.98           C  
ATOM   1218  CE2 PHE A 216      33.412  44.196  38.382  1.00 26.63           C  
ATOM   1219  CZ  PHE A 216      32.252  43.519  38.054  1.00 26.43           C  
ATOM   1220  N   VAL A 217      34.316  50.727  37.560  1.00 18.68           N  
ATOM   1221  CA  VAL A 217      34.833  51.946  36.974  1.00 16.74           C  
ATOM   1222  C   VAL A 217      35.925  52.431  37.905  1.00 16.05           C  
ATOM   1223  O   VAL A 217      35.680  52.655  39.085  1.00 14.57           O  
ATOM   1224  CB  VAL A 217      33.764  53.049  36.844  1.00 17.93           C  
ATOM   1225  CG1 VAL A 217      34.413  54.336  36.342  1.00 15.40           C  
ATOM   1226  CG2 VAL A 217      32.667  52.612  35.874  1.00 16.56           C  
ATOM   1227  N   ALA A 218      37.139  52.559  37.373  1.00 16.21           N  
ATOM   1228  CA  ALA A 218      38.276  53.037  38.146  1.00 15.38           C  
ATOM   1229  C   ALA A 218      38.655  54.377  37.552  1.00 16.36           C  
ATOM   1230  O   ALA A 218      38.549  54.566  36.345  1.00 18.47           O  
ATOM   1231  CB  ALA A 218      39.442  52.065  38.038  1.00 14.65           C  
ATOM   1232  N   GLU A 219      39.087  55.313  38.388  1.00 17.00           N  
ATOM   1233  CA  GLU A 219      39.466  56.624  37.884  1.00 16.91           C  
ATOM   1234  C   GLU A 219      40.974  56.794  37.818  1.00 16.25           C  
ATOM   1235  O   GLU A 219      41.658  56.768  38.840  1.00 17.13           O  
ATOM   1236  CB  GLU A 219      38.872  57.727  38.758  1.00 19.53           C  
ATOM   1237  CG  GLU A 219      39.125  59.125  38.210  1.00 23.46           C  
ATOM   1238  CD  GLU A 219      38.543  60.216  39.081  1.00 26.25           C  
ATOM   1239  OE1 GLU A 219      38.566  61.386  38.652  1.00 28.30           O  
ATOM   1240  OE2 GLU A 219      38.065  59.910  40.195  1.00 29.69           O  
ATOM   1241  N   GLY A 220      41.491  56.971  36.608  1.00 16.63           N  
ATOM   1242  CA  GLY A 220      42.921  57.161  36.444  1.00 15.95           C  
ATOM   1243  C   GLY A 220      43.173  58.615  36.127  1.00 15.68           C  
ATOM   1244  O   GLY A 220      42.233  59.403  36.086  1.00 17.34           O  
ATOM   1245  N   ASP A 221      44.429  58.982  35.910  1.00 16.52           N  
ATOM   1246  CA  ASP A 221      44.766  60.361  35.577  1.00 17.04           C  
ATOM   1247  C   ASP A 221      45.608  60.429  34.299  1.00 17.37           C  
ATOM   1248  O   ASP A 221      46.386  61.362  34.113  1.00 17.93           O  
ATOM   1249  CB  ASP A 221      45.534  61.017  36.730  1.00 18.57           C  
ATOM   1250  CG  ASP A 221      46.817  60.282  37.069  1.00 19.50           C  
ATOM   1251  OD1 ASP A 221      47.310  59.539  36.200  1.00 19.61           O  
ATOM   1252  OD2 ASP A 221      47.338  60.448  38.196  1.00 20.28           O  
ATOM   1253  N   TYR A 222      45.445  59.432  33.429  1.00 17.02           N  
ATOM   1254  CA  TYR A 222      46.176  59.336  32.164  1.00 16.89           C  
ATOM   1255  C   TYR A 222      47.595  58.844  32.370  1.00 18.08           C  
ATOM   1256  O   TYR A 222      48.283  58.458  31.426  1.00 20.80           O  
ATOM   1257  CB  TYR A 222      46.214  60.687  31.439  1.00 15.83           C  
ATOM   1258  CG  TYR A 222      44.847  61.224  31.115  1.00 13.91           C  
ATOM   1259  CD1 TYR A 222      43.839  60.378  30.659  1.00 12.87           C  
ATOM   1260  CD2 TYR A 222      44.561  62.576  31.254  1.00 14.72           C  
ATOM   1261  CE1 TYR A 222      42.579  60.865  30.350  1.00 14.71           C  
ATOM   1262  CE2 TYR A 222      43.305  63.076  30.946  1.00 15.71           C  
ATOM   1263  CZ  TYR A 222      42.320  62.216  30.497  1.00 16.37           C  
ATOM   1264  OH  TYR A 222      41.074  62.709  30.204  1.00 18.45           O  
ATOM   1265  N   THR A 223      48.029  58.856  33.618  1.00 18.43           N  
ATOM   1266  CA  THR A 223      49.366  58.409  33.957  1.00 18.90           C  
ATOM   1267  C   THR A 223      49.498  56.883  33.912  1.00 19.26           C  
ATOM   1268  O   THR A 223      48.540  56.156  34.168  1.00 19.41           O  
ATOM   1269  CB  THR A 223      49.736  58.923  35.349  1.00 18.53           C  
ATOM   1270  OG1 THR A 223      50.833  59.831  35.239  1.00 20.72           O  
ATOM   1271  CG2 THR A 223      50.073  57.787  36.279  1.00 16.82           C  
ATOM   1272  N   TYR A 224      50.697  56.415  33.583  1.00 19.31           N  
ATOM   1273  CA  TYR A 224      50.997  54.989  33.505  1.00 18.04           C  
ATOM   1274  C   TYR A 224      50.824  54.349  34.874  1.00 19.47           C  
ATOM   1275  O   TYR A 224      50.400  53.196  34.977  1.00 20.63           O  
ATOM   1276  CB  TYR A 224      52.429  54.790  33.000  1.00 17.00           C  
ATOM   1277  CG  TYR A 224      52.971  53.382  33.130  1.00 18.27           C  
ATOM   1278  CD1 TYR A 224      53.717  53.000  34.244  1.00 17.64           C  
ATOM   1279  CD2 TYR A 224      52.753  52.433  32.127  1.00 19.98           C  
ATOM   1280  CE1 TYR A 224      54.234  51.716  34.358  1.00 20.68           C  
ATOM   1281  CE2 TYR A 224      53.269  51.143  32.231  1.00 19.39           C  
ATOM   1282  CZ  TYR A 224      54.006  50.793  33.347  1.00 20.36           C  
ATOM   1283  OH  TYR A 224      54.511  49.524  33.455  1.00 23.02           O  
ATOM   1284  N   ASP A 225      51.162  55.103  35.917  1.00 18.78           N  
ATOM   1285  CA  ASP A 225      51.035  54.625  37.286  1.00 19.66           C  
ATOM   1286  C   ASP A 225      49.580  54.420  37.674  1.00 16.43           C  
ATOM   1287  O   ASP A 225      49.249  53.427  38.316  1.00 14.06           O  
ATOM   1288  CB  ASP A 225      51.684  55.604  38.276  1.00 23.46           C  
ATOM   1289  CG  ASP A 225      53.198  55.622  38.173  1.00 30.35           C  
ATOM   1290  OD1 ASP A 225      53.809  54.530  38.108  1.00 32.63           O  
ATOM   1291  OD2 ASP A 225      53.784  56.729  38.167  1.00 35.73           O  
ATOM   1292  N   SER A 226      48.716  55.360  37.292  1.00 16.87           N  
ATOM   1293  CA  SER A 226      47.292  55.263  37.613  1.00 17.22           C  
ATOM   1294  C   SER A 226      46.717  53.975  37.019  1.00 17.79           C  
ATOM   1295  O   SER A 226      45.846  53.340  37.615  1.00 16.36           O  
ATOM   1296  CB  SER A 226      46.527  56.484  37.087  1.00 18.48           C  
ATOM   1297  OG  SER A 226      46.509  56.548  35.669  1.00 20.53           O  
ATOM   1298  N   GLY A 227      47.216  53.591  35.846  1.00 17.18           N  
ATOM   1299  CA  GLY A 227      46.766  52.360  35.220  1.00 19.67           C  
ATOM   1300  C   GLY A 227      47.219  51.161  36.045  1.00 20.81           C  
ATOM   1301  O   GLY A 227      46.484  50.184  36.201  1.00 20.14           O  
ATOM   1302  N   LEU A 228      48.440  51.236  36.569  1.00 21.24           N  
ATOM   1303  CA  LEU A 228      48.995  50.173  37.406  1.00 22.00           C  
ATOM   1304  C   LEU A 228      48.074  49.991  38.617  1.00 21.32           C  
ATOM   1305  O   LEU A 228      47.610  48.888  38.908  1.00 22.21           O  
ATOM   1306  CB  LEU A 228      50.402  50.569  37.873  1.00 24.67           C  
ATOM   1307  CG  LEU A 228      51.622  49.687  37.565  1.00 27.14           C  
ATOM   1308  CD1 LEU A 228      51.635  49.256  36.111  1.00 26.10           C  
ATOM   1309  CD2 LEU A 228      52.887  50.469  37.890  1.00 28.26           C  
ATOM   1310  N   GLU A 229      47.797  51.096  39.303  1.00 19.76           N  
ATOM   1311  CA  GLU A 229      46.938  51.092  40.477  1.00 19.05           C  
ATOM   1312  C   GLU A 229      45.490  50.785  40.111  1.00 18.85           C  
ATOM   1313  O   GLU A 229      44.773  50.135  40.872  1.00 19.34           O  
ATOM   1314  CB  GLU A 229      47.007  52.446  41.179  1.00 20.04           C  
ATOM   1315  CG  GLU A 229      48.419  52.898  41.486  1.00 23.49           C  
ATOM   1316  CD  GLU A 229      48.461  54.202  42.254  1.00 25.88           C  
ATOM   1317  OE1 GLU A 229      47.748  55.154  41.866  1.00 28.38           O  
ATOM   1318  OE2 GLU A 229      49.215  54.274  43.245  1.00 27.53           O  
ATOM   1319  N   ALA A 230      45.059  51.262  38.949  1.00 16.43           N  
ATOM   1320  CA  ALA A 230      43.700  51.022  38.498  1.00 16.20           C  
ATOM   1321  C   ALA A 230      43.457  49.516  38.476  1.00 17.14           C  
ATOM   1322  O   ALA A 230      42.451  49.025  39.008  1.00 16.87           O  
ATOM   1323  CB  ALA A 230      43.493  51.617  37.098  1.00 13.49           C  
ATOM   1324  N   LEU A 231      44.389  48.784  37.868  1.00 16.67           N  
ATOM   1325  CA  LEU A 231      44.262  47.341  37.788  1.00 17.03           C  
ATOM   1326  C   LEU A 231      44.237  46.701  39.173  1.00 17.46           C  
ATOM   1327  O   LEU A 231      43.354  45.907  39.475  1.00 18.99           O  
ATOM   1328  CB  LEU A 231      45.411  46.720  37.001  1.00 15.72           C  
ATOM   1329  CG  LEU A 231      45.218  45.208  37.123  1.00 17.53           C  
ATOM   1330  CD1 LEU A 231      44.531  44.666  35.877  1.00 14.48           C  
ATOM   1331  CD2 LEU A 231      46.540  44.543  37.377  1.00 18.03           C  
ATOM   1332  N   GLN A 232      45.216  47.030  40.004  1.00 17.09           N  
ATOM   1333  CA  GLN A 232      45.268  46.459  41.345  1.00 20.00           C  
ATOM   1334  C   GLN A 232      43.997  46.773  42.123  1.00 20.61           C  
ATOM   1335  O   GLN A 232      43.560  45.987  42.955  1.00 20.92           O  
ATOM   1336  CB  GLN A 232      46.500  46.971  42.077  1.00 20.22           C  
ATOM   1337  CG  GLN A 232      47.779  46.409  41.495  1.00 21.69           C  
ATOM   1338  CD  GLN A 232      48.950  47.342  41.655  1.00 25.19           C  
ATOM   1339  OE1 GLN A 232      50.093  46.973  41.384  1.00 27.40           O  
ATOM   1340  NE2 GLN A 232      48.678  48.567  42.090  1.00 24.78           N  
ATOM   1341  N   HIS A 233      43.394  47.920  41.834  1.00 21.15           N  
ATOM   1342  CA  HIS A 233      42.153  48.301  42.491  1.00 20.80           C  
ATOM   1343  C   HIS A 233      41.028  47.345  42.070  1.00 22.12           C  
ATOM   1344  O   HIS A 233      40.358  46.750  42.917  1.00 21.24           O  
ATOM   1345  CB  HIS A 233      41.784  49.738  42.113  1.00 20.17           C  
ATOM   1346  CG  HIS A 233      40.364  50.096  42.416  1.00 20.70           C  
ATOM   1347  ND1 HIS A 233      39.854  50.104  43.695  1.00 21.87           N  
ATOM   1348  CD2 HIS A 233      39.337  50.434  41.601  1.00 22.71           C  
ATOM   1349  CE1 HIS A 233      38.575  50.429  43.657  1.00 21.49           C  
ATOM   1350  NE2 HIS A 233      38.236  50.634  42.397  1.00 23.06           N  
ATOM   1351  N   LEU A 234      40.838  47.204  40.755  1.00 21.48           N  
ATOM   1352  CA  LEU A 234      39.799  46.348  40.183  1.00 20.51           C  
ATOM   1353  C   LEU A 234      39.920  44.870  40.543  1.00 22.09           C  
ATOM   1354  O   LEU A 234      38.912  44.184  40.703  1.00 23.50           O  
ATOM   1355  CB  LEU A 234      39.780  46.504  38.660  1.00 18.55           C  
ATOM   1356  CG  LEU A 234      39.385  47.892  38.137  1.00 17.11           C  
ATOM   1357  CD1 LEU A 234      39.737  48.003  36.671  1.00 14.88           C  
ATOM   1358  CD2 LEU A 234      37.890  48.120  38.356  1.00 13.90           C  
ATOM   1359  N   MET A 235      41.144  44.372  40.660  1.00 23.48           N  
ATOM   1360  CA  MET A 235      41.338  42.974  41.017  1.00 26.04           C  
ATOM   1361  C   MET A 235      41.142  42.743  42.523  1.00 28.13           C  
ATOM   1362  O   MET A 235      41.213  41.610  42.996  1.00 28.35           O  
ATOM   1363  CB  MET A 235      42.726  42.506  40.579  1.00 26.12           C  
ATOM   1364  CG  MET A 235      42.913  42.452  39.058  1.00 26.02           C  
ATOM   1365  SD  MET A 235      41.762  41.317  38.228  1.00 26.55           S  
ATOM   1366  CE  MET A 235      40.523  42.463  37.628  1.00 23.12           C  
ATOM   1367  N   SER A 236      40.892  43.822  43.266  1.00 28.85           N  
ATOM   1368  CA  SER A 236      40.663  43.743  44.709  1.00 29.89           C  
ATOM   1369  C   SER A 236      39.184  43.555  45.019  1.00 30.49           C  
ATOM   1370  O   SER A 236      38.813  43.301  46.160  1.00 31.28           O  
ATOM   1371  CB  SER A 236      41.148  45.014  45.411  1.00 30.30           C  
ATOM   1372  OG  SER A 236      42.481  44.864  45.866  1.00 33.16           O  
ATOM   1373  N   LEU A 237      38.343  43.710  44.002  1.00 30.20           N  
ATOM   1374  CA  LEU A 237      36.905  43.549  44.163  1.00 31.60           C  
ATOM   1375  C   LEU A 237      36.567  42.091  44.460  1.00 32.50           C  
ATOM   1376  O   LEU A 237      37.320  41.186  44.096  1.00 31.29           O  
ATOM   1377  CB  LEU A 237      36.182  43.995  42.888  1.00 30.63           C  
ATOM   1378  CG  LEU A 237      36.023  45.495  42.652  1.00 31.38           C  
ATOM   1379  CD1 LEU A 237      37.310  46.217  42.976  1.00 33.75           C  
ATOM   1380  CD2 LEU A 237      35.622  45.739  41.210  1.00 32.03           C  
ATOM   1381  N   ASP A 238      35.441  41.863  45.130  1.00 34.52           N  
ATOM   1382  CA  ASP A 238      35.029  40.499  45.435  1.00 37.05           C  
ATOM   1383  C   ASP A 238      34.743  39.804  44.107  1.00 37.54           C  
ATOM   1384  O   ASP A 238      35.087  38.636  43.922  1.00 37.70           O  
ATOM   1385  CB  ASP A 238      33.788  40.489  46.331  1.00 38.83           C  
ATOM   1386  CG  ASP A 238      34.095  40.935  47.754  1.00 41.18           C  
ATOM   1387  OD1 ASP A 238      35.014  40.358  48.375  1.00 42.63           O  
ATOM   1388  OD2 ASP A 238      33.420  41.860  48.255  1.00 43.46           O  
ATOM   1389  N   LYS A 239      34.119  40.535  43.187  1.00 36.66           N  
ATOM   1390  CA  LYS A 239      33.824  40.009  41.859  1.00 36.32           C  
ATOM   1391  C   LYS A 239      34.619  40.844  40.856  1.00 35.46           C  
ATOM   1392  O   LYS A 239      34.261  41.989  40.564  1.00 35.60           O  
ATOM   1393  CB  LYS A 239      32.320  40.091  41.572  1.00 36.62           C  
ATOM   1394  CG  LYS A 239      31.492  39.263  42.553  1.00 41.96           C  
ATOM   1395  CD  LYS A 239      30.018  39.150  42.165  1.00 44.69           C  
ATOM   1396  CE  LYS A 239      29.282  38.213  43.127  1.00 46.50           C  
ATOM   1397  NZ  LYS A 239      27.870  37.924  42.725  1.00 47.28           N  
ATOM   1398  N   LYS A 240      35.716  40.274  40.358  1.00 33.02           N  
ATOM   1399  CA  LYS A 240      36.574  40.964  39.400  1.00 30.95           C  
ATOM   1400  C   LYS A 240      35.962  40.959  38.012  1.00 30.55           C  
ATOM   1401  O   LYS A 240      35.132  40.107  37.690  1.00 30.91           O  
ATOM   1402  CB  LYS A 240      37.951  40.302  39.294  1.00 29.93           C  
ATOM   1403  CG  LYS A 240      38.256  39.200  40.282  1.00 29.67           C  
ATOM   1404  CD  LYS A 240      38.788  39.746  41.578  1.00 29.24           C  
ATOM   1405  CE  LYS A 240      39.290  38.611  42.442  1.00 30.28           C  
ATOM   1406  NZ  LYS A 240      39.630  39.086  43.804  1.00 32.68           N  
ATOM   1407  N   PRO A 241      36.368  41.920  37.164  1.00 29.31           N  
ATOM   1408  CA  PRO A 241      35.843  41.995  35.798  1.00 28.61           C  
ATOM   1409  C   PRO A 241      36.609  40.960  34.990  1.00 27.52           C  
ATOM   1410  O   PRO A 241      37.652  40.476  35.433  1.00 26.07           O  
ATOM   1411  CB  PRO A 241      36.198  43.416  35.348  1.00 28.17           C  
ATOM   1412  CG  PRO A 241      36.681  44.123  36.609  1.00 30.42           C  
ATOM   1413  CD  PRO A 241      37.290  43.035  37.430  1.00 28.44           C  
ATOM   1414  N   THR A 242      36.100  40.614  33.815  1.00 26.71           N  
ATOM   1415  CA  THR A 242      36.794  39.650  32.972  1.00 25.98           C  
ATOM   1416  C   THR A 242      37.406  40.394  31.789  1.00 26.77           C  
ATOM   1417  O   THR A 242      38.191  39.831  31.025  1.00 29.12           O  
ATOM   1418  CB  THR A 242      35.841  38.549  32.463  1.00 24.45           C  
ATOM   1419  OG1 THR A 242      34.708  39.146  31.826  1.00 24.07           O  
ATOM   1420  CG2 THR A 242      35.371  37.680  33.620  1.00 23.14           C  
ATOM   1421  N   ALA A 243      37.043  41.669  31.656  1.00 24.77           N  
ATOM   1422  CA  ALA A 243      37.550  42.524  30.588  1.00 23.54           C  
ATOM   1423  C   ALA A 243      37.711  43.961  31.084  1.00 23.01           C  
ATOM   1424  O   ALA A 243      36.929  44.441  31.914  1.00 24.20           O  
ATOM   1425  CB  ALA A 243      36.612  42.489  29.397  1.00 22.98           C  
ATOM   1426  N   ILE A 244      38.729  44.647  30.579  1.00 20.60           N  
ATOM   1427  CA  ILE A 244      38.970  46.023  30.984  1.00 18.61           C  
ATOM   1428  C   ILE A 244      39.238  46.928  29.787  1.00 19.30           C  
ATOM   1429  O   ILE A 244      40.103  46.641  28.954  1.00 17.89           O  
ATOM   1430  CB  ILE A 244      40.181  46.137  31.951  1.00 17.51           C  
ATOM   1431  CG1 ILE A 244      39.961  45.263  33.185  1.00 15.88           C  
ATOM   1432  CG2 ILE A 244      40.368  47.595  32.384  1.00 17.64           C  
ATOM   1433  CD1 ILE A 244      41.133  45.228  34.125  1.00  9.13           C  
ATOM   1434  N   LEU A 245      38.474  48.014  29.716  1.00 18.69           N  
ATOM   1435  CA  LEU A 245      38.618  49.020  28.671  1.00 17.81           C  
ATOM   1436  C   LEU A 245      39.192  50.279  29.342  1.00 17.35           C  
ATOM   1437  O   LEU A 245      38.641  50.777  30.323  1.00 16.58           O  
ATOM   1438  CB  LEU A 245      37.261  49.339  28.033  1.00 16.91           C  
ATOM   1439  CG  LEU A 245      37.260  50.559  27.107  1.00 16.62           C  
ATOM   1440  CD1 LEU A 245      38.299  50.378  26.010  1.00 18.12           C  
ATOM   1441  CD2 LEU A 245      35.890  50.740  26.503  1.00 17.62           C  
ATOM   1442  N   SER A 246      40.311  50.770  28.816  1.00 17.20           N  
ATOM   1443  CA  SER A 246      40.977  51.949  29.352  1.00 13.66           C  
ATOM   1444  C   SER A 246      40.714  53.142  28.448  1.00 14.55           C  
ATOM   1445  O   SER A 246      40.727  53.016  27.222  1.00 14.18           O  
ATOM   1446  CB  SER A 246      42.483  51.691  29.446  1.00 15.14           C  
ATOM   1447  OG  SER A 246      43.191  52.873  29.785  1.00 17.15           O  
ATOM   1448  N   ALA A 247      40.474  54.300  29.050  1.00 14.51           N  
ATOM   1449  CA  ALA A 247      40.206  55.507  28.276  1.00 16.69           C  
ATOM   1450  C   ALA A 247      41.460  55.970  27.547  1.00 15.33           C  
ATOM   1451  O   ALA A 247      41.404  56.865  26.709  1.00 14.36           O  
ATOM   1452  CB  ALA A 247      39.701  56.621  29.194  1.00 18.00           C  
ATOM   1453  N   THR A 248      42.584  55.334  27.852  1.00 15.97           N  
ATOM   1454  CA  THR A 248      43.859  55.714  27.260  1.00 16.34           C  
ATOM   1455  C   THR A 248      44.833  54.539  27.088  1.00 17.07           C  
ATOM   1456  O   THR A 248      44.737  53.531  27.789  1.00 19.31           O  
ATOM   1457  CB  THR A 248      44.478  56.825  28.131  1.00 14.96           C  
ATOM   1458  OG1 THR A 248      44.308  58.086  27.474  1.00 18.42           O  
ATOM   1459  CG2 THR A 248      45.918  56.564  28.426  1.00 15.41           C  
ATOM   1460  N   ASP A 249      45.758  54.670  26.141  1.00 17.54           N  
ATOM   1461  CA  ASP A 249      46.755  53.634  25.879  1.00 18.18           C  
ATOM   1462  C   ASP A 249      47.826  53.568  26.957  1.00 18.06           C  
ATOM   1463  O   ASP A 249      48.275  52.478  27.322  1.00 17.96           O  
ATOM   1464  CB  ASP A 249      47.424  53.861  24.521  1.00 18.67           C  
ATOM   1465  CG  ASP A 249      46.597  53.327  23.362  1.00 20.63           C  
ATOM   1466  OD1 ASP A 249      46.988  53.575  22.205  1.00 20.51           O  
ATOM   1467  OD2 ASP A 249      45.566  52.656  23.603  1.00 20.59           O  
ATOM   1468  N   GLU A 250      48.245  54.725  27.465  1.00 16.45           N  
ATOM   1469  CA  GLU A 250      49.264  54.731  28.509  1.00 18.17           C  
ATOM   1470  C   GLU A 250      48.724  54.095  29.793  1.00 17.03           C  
ATOM   1471  O   GLU A 250      49.462  53.438  30.523  1.00 15.64           O  
ATOM   1472  CB  GLU A 250      49.749  56.152  28.807  1.00 20.69           C  
ATOM   1473  CG  GLU A 250      50.996  56.161  29.670  1.00 21.92           C  
ATOM   1474  CD  GLU A 250      51.482  57.553  30.000  1.00 25.26           C  
ATOM   1475  OE1 GLU A 250      51.504  58.416  29.089  1.00 29.91           O  
ATOM   1476  OE2 GLU A 250      51.857  57.777  31.170  1.00 24.22           O  
ATOM   1477  N   MET A 251      47.439  54.287  30.080  1.00 16.88           N  
ATOM   1478  CA  MET A 251      46.884  53.667  31.277  1.00 15.68           C  
ATOM   1479  C   MET A 251      46.715  52.183  31.004  1.00 15.16           C  
ATOM   1480  O   MET A 251      46.888  51.358  31.903  1.00 15.75           O  
ATOM   1481  CB  MET A 251      45.548  54.301  31.667  1.00 15.56           C  
ATOM   1482  CG  MET A 251      45.704  55.702  32.236  1.00 14.71           C  
ATOM   1483  SD  MET A 251      44.202  56.357  32.981  1.00 16.10           S  
ATOM   1484  CE  MET A 251      43.141  56.471  31.602  1.00 11.64           C  
ATOM   1485  N   ALA A 252      46.398  51.848  29.755  1.00 15.44           N  
ATOM   1486  CA  ALA A 252      46.240  50.450  29.359  1.00 15.77           C  
ATOM   1487  C   ALA A 252      47.574  49.720  29.492  1.00 15.80           C  
ATOM   1488  O   ALA A 252      47.602  48.521  29.758  1.00 14.62           O  
ATOM   1489  CB  ALA A 252      45.724  50.348  27.917  1.00 16.18           C  
ATOM   1490  N   LEU A 253      48.684  50.434  29.307  1.00 16.49           N  
ATOM   1491  CA  LEU A 253      49.987  49.789  29.452  1.00 16.58           C  
ATOM   1492  C   LEU A 253      50.175  49.419  30.919  1.00 16.55           C  
ATOM   1493  O   LEU A 253      50.582  48.303  31.239  1.00 17.64           O  
ATOM   1494  CB  LEU A 253      51.126  50.710  28.983  1.00 18.42           C  
ATOM   1495  CG  LEU A 253      51.795  50.328  27.653  1.00 20.36           C  
ATOM   1496  CD1 LEU A 253      50.846  50.550  26.478  1.00 19.47           C  
ATOM   1497  CD2 LEU A 253      53.040  51.161  27.470  1.00 22.52           C  
ATOM   1498  N   GLY A 254      49.860  50.355  31.808  1.00 15.95           N  
ATOM   1499  CA  GLY A 254      49.985  50.091  33.231  1.00 15.57           C  
ATOM   1500  C   GLY A 254      49.120  48.919  33.686  1.00 16.11           C  
ATOM   1501  O   GLY A 254      49.533  48.110  34.519  1.00 14.38           O  
ATOM   1502  N   ILE A 255      47.915  48.830  33.137  1.00 14.57           N  
ATOM   1503  CA  ILE A 255      46.988  47.760  33.477  1.00 15.33           C  
ATOM   1504  C   ILE A 255      47.585  46.398  33.116  1.00 17.21           C  
ATOM   1505  O   ILE A 255      47.599  45.465  33.926  1.00 16.90           O  
ATOM   1506  CB  ILE A 255      45.661  47.957  32.721  1.00 14.84           C  
ATOM   1507  CG1 ILE A 255      45.031  49.277  33.157  1.00 12.85           C  
ATOM   1508  CG2 ILE A 255      44.722  46.785  32.973  1.00 12.96           C  
ATOM   1509  CD1 ILE A 255      43.914  49.749  32.260  1.00 14.04           C  
ATOM   1510  N   ILE A 256      48.084  46.291  31.893  1.00 18.48           N  
ATOM   1511  CA  ILE A 256      48.692  45.052  31.425  1.00 20.29           C  
ATOM   1512  C   ILE A 256      49.870  44.607  32.301  1.00 22.00           C  
ATOM   1513  O   ILE A 256      49.935  43.451  32.717  1.00 22.90           O  
ATOM   1514  CB  ILE A 256      49.178  45.199  29.958  1.00 19.29           C  
ATOM   1515  CG1 ILE A 256      47.974  45.386  29.031  1.00 19.36           C  
ATOM   1516  CG2 ILE A 256      49.985  43.983  29.547  1.00 16.59           C  
ATOM   1517  CD1 ILE A 256      48.346  45.667  27.582  1.00 20.87           C  
ATOM   1518  N   HIS A 257      50.800  45.518  32.576  1.00 24.15           N  
ATOM   1519  CA  HIS A 257      51.966  45.183  33.388  1.00 26.00           C  
ATOM   1520  C   HIS A 257      51.610  44.874  34.838  1.00 27.44           C  
ATOM   1521  O   HIS A 257      52.203  43.983  35.447  1.00 29.16           O  
ATOM   1522  CB  HIS A 257      52.997  46.313  33.323  1.00 25.45           C  
ATOM   1523  CG  HIS A 257      53.574  46.517  31.956  1.00 26.16           C  
ATOM   1524  ND1 HIS A 257      54.356  47.604  31.630  1.00 25.58           N  
ATOM   1525  CD2 HIS A 257      53.490  45.765  30.832  1.00 24.77           C  
ATOM   1526  CE1 HIS A 257      54.725  47.515  30.365  1.00 23.60           C  
ATOM   1527  NE2 HIS A 257      54.214  46.409  29.859  1.00 24.16           N  
ATOM   1528  N   ALA A 258      50.643  45.598  35.393  1.00 27.89           N  
ATOM   1529  CA  ALA A 258      50.227  45.356  36.770  1.00 26.65           C  
ATOM   1530  C   ALA A 258      49.555  43.988  36.830  1.00 27.04           C  
ATOM   1531  O   ALA A 258      49.694  43.260  37.813  1.00 29.01           O  
ATOM   1532  CB  ALA A 258      49.260  46.443  37.235  1.00 24.46           C  
ATOM   1533  N   ALA A 259      48.823  43.649  35.771  1.00 26.26           N  
ATOM   1534  CA  ALA A 259      48.138  42.362  35.693  1.00 26.41           C  
ATOM   1535  C   ALA A 259      49.175  41.250  35.649  1.00 26.95           C  
ATOM   1536  O   ALA A 259      49.003  40.197  36.260  1.00 27.18           O  
ATOM   1537  CB  ALA A 259      47.267  42.304  34.451  1.00 24.41           C  
ATOM   1538  N   GLN A 260      50.261  41.504  34.929  1.00 27.67           N  
ATOM   1539  CA  GLN A 260      51.335  40.534  34.792  1.00 28.42           C  
ATOM   1540  C   GLN A 260      52.196  40.475  36.045  1.00 30.25           C  
ATOM   1541  O   GLN A 260      52.764  39.429  36.360  1.00 28.83           O  
ATOM   1542  CB  GLN A 260      52.176  40.878  33.562  1.00 26.63           C  
ATOM   1543  CG  GLN A 260      51.328  40.962  32.305  1.00 25.57           C  
ATOM   1544  CD  GLN A 260      52.091  41.465  31.107  1.00 25.59           C  
ATOM   1545  OE1 GLN A 260      52.861  42.425  31.202  1.00 26.56           O  
ATOM   1546  NE2 GLN A 260      51.871  40.830  29.959  1.00 24.71           N  
ATOM   1547  N   ASP A 261      52.295  41.595  36.762  1.00 32.87           N  
ATOM   1548  CA  ASP A 261      53.072  41.628  38.001  1.00 35.46           C  
ATOM   1549  C   ASP A 261      52.368  40.769  39.053  1.00 35.25           C  
ATOM   1550  O   ASP A 261      53.005  40.236  39.952  1.00 35.98           O  
ATOM   1551  CB  ASP A 261      53.221  43.061  38.536  1.00 38.02           C  
ATOM   1552  CG  ASP A 261      54.163  43.915  37.694  1.00 41.13           C  
ATOM   1553  OD1 ASP A 261      55.212  43.394  37.266  1.00 43.25           O  
ATOM   1554  OD2 ASP A 261      53.863  45.111  37.474  1.00 41.81           O  
ATOM   1555  N   GLN A 262      51.049  40.642  38.932  1.00 35.37           N  
ATOM   1556  CA  GLN A 262      50.264  39.840  39.866  1.00 35.36           C  
ATOM   1557  C   GLN A 262      50.116  38.392  39.401  1.00 35.38           C  
ATOM   1558  O   GLN A 262      49.391  37.608  40.013  1.00 35.01           O  
ATOM   1559  CB  GLN A 262      48.870  40.450  40.063  1.00 35.18           C  
ATOM   1560  CG  GLN A 262      48.872  41.742  40.852  1.00 34.60           C  
ATOM   1561  CD  GLN A 262      47.483  42.297  41.070  1.00 33.24           C  
ATOM   1562  OE1 GLN A 262      47.321  43.352  41.674  1.00 34.13           O  
ATOM   1563  NE2 GLN A 262      46.472  41.588  40.579  1.00 32.46           N  
ATOM   1564  N   GLY A 263      50.787  38.045  38.304  1.00 34.83           N  
ATOM   1565  CA  GLY A 263      50.725  36.681  37.803  1.00 34.11           C  
ATOM   1566  C   GLY A 263      49.631  36.330  36.811  1.00 34.02           C  
ATOM   1567  O   GLY A 263      49.457  35.157  36.482  1.00 34.99           O  
ATOM   1568  N   LEU A 264      48.890  37.324  36.331  1.00 34.16           N  
ATOM   1569  CA  LEU A 264      47.829  37.075  35.363  1.00 33.51           C  
ATOM   1570  C   LEU A 264      48.424  37.083  33.959  1.00 34.35           C  
ATOM   1571  O   LEU A 264      49.484  37.668  33.724  1.00 34.43           O  
ATOM   1572  CB  LEU A 264      46.748  38.153  35.457  1.00 33.92           C  
ATOM   1573  CG  LEU A 264      46.165  38.425  36.844  1.00 34.14           C  
ATOM   1574  CD1 LEU A 264      45.072  39.480  36.733  1.00 33.98           C  
ATOM   1575  CD2 LEU A 264      45.612  37.136  37.436  1.00 33.33           C  
ATOM   1576  N   SER A 265      47.744  36.426  33.029  1.00 33.88           N  
ATOM   1577  CA  SER A 265      48.216  36.379  31.656  1.00 33.94           C  
ATOM   1578  C   SER A 265      47.235  37.093  30.743  1.00 33.11           C  
ATOM   1579  O   SER A 265      46.026  36.837  30.784  1.00 33.43           O  
ATOM   1580  CB  SER A 265      48.375  34.931  31.192  1.00 35.07           C  
ATOM   1581  OG  SER A 265      49.307  34.246  32.006  1.00 38.65           O  
ATOM   1582  N   ILE A 266      47.761  38.001  29.931  1.00 30.81           N  
ATOM   1583  CA  ILE A 266      46.943  38.744  28.982  1.00 29.36           C  
ATOM   1584  C   ILE A 266      47.275  38.125  27.630  1.00 28.77           C  
ATOM   1585  O   ILE A 266      48.452  37.951  27.307  1.00 28.26           O  
ATOM   1586  CB  ILE A 266      47.323  40.247  28.975  1.00 27.97           C  
ATOM   1587  CG1 ILE A 266      47.481  40.757  30.415  1.00 26.59           C  
ATOM   1588  CG2 ILE A 266      46.276  41.045  28.220  1.00 24.55           C  
ATOM   1589  CD1 ILE A 266      46.303  40.457  31.333  1.00 22.57           C  
ATOM   1590  N   PRO A 267      46.256  37.811  26.809  1.00 28.13           N  
ATOM   1591  CA  PRO A 267      44.808  37.974  26.990  1.00 29.47           C  
ATOM   1592  C   PRO A 267      44.098  36.863  27.763  1.00 29.90           C  
ATOM   1593  O   PRO A 267      42.919  36.990  28.082  1.00 28.78           O  
ATOM   1594  CB  PRO A 267      44.311  38.044  25.559  1.00 29.35           C  
ATOM   1595  CG  PRO A 267      45.155  36.973  24.920  1.00 27.47           C  
ATOM   1596  CD  PRO A 267      46.541  37.267  25.470  1.00 26.99           C  
ATOM   1597  N   GLU A 268      44.812  35.775  28.035  1.00 31.11           N  
ATOM   1598  CA  GLU A 268      44.267  34.619  28.758  1.00 31.48           C  
ATOM   1599  C   GLU A 268      43.260  34.950  29.863  1.00 29.79           C  
ATOM   1600  O   GLU A 268      42.051  34.759  29.716  1.00 28.13           O  
ATOM   1601  CB  GLU A 268      45.415  33.808  29.379  1.00 33.62           C  
ATOM   1602  CG  GLU A 268      45.634  32.425  28.779  1.00 37.09           C  
ATOM   1603  CD  GLU A 268      44.472  31.471  29.042  1.00 39.96           C  
ATOM   1604  OE1 GLU A 268      43.342  31.759  28.586  1.00 40.09           O  
ATOM   1605  OE2 GLU A 268      44.694  30.430  29.703  1.00 39.68           O  
ATOM   1606  N   ASP A 269      43.783  35.441  30.976  1.00 28.63           N  
ATOM   1607  CA  ASP A 269      42.977  35.771  32.137  1.00 28.14           C  
ATOM   1608  C   ASP A 269      42.160  37.054  32.037  1.00 26.01           C  
ATOM   1609  O   ASP A 269      41.172  37.211  32.748  1.00 25.49           O  
ATOM   1610  CB  ASP A 269      43.888  35.860  33.365  1.00 28.64           C  
ATOM   1611  CG  ASP A 269      44.651  34.576  33.614  1.00 31.41           C  
ATOM   1612  OD1 ASP A 269      45.881  34.640  33.838  1.00 33.16           O  
ATOM   1613  OD2 ASP A 269      44.017  33.500  33.587  1.00 31.93           O  
ATOM   1614  N   LEU A 270      42.542  37.955  31.142  1.00 24.54           N  
ATOM   1615  CA  LEU A 270      41.843  39.226  31.072  1.00 22.39           C  
ATOM   1616  C   LEU A 270      41.928  39.889  29.705  1.00 20.00           C  
ATOM   1617  O   LEU A 270      43.007  40.007  29.142  1.00 17.88           O  
ATOM   1618  CB  LEU A 270      42.472  40.139  32.131  1.00 24.51           C  
ATOM   1619  CG  LEU A 270      41.806  41.342  32.786  1.00 24.47           C  
ATOM   1620  CD1 LEU A 270      40.516  40.930  33.490  1.00 26.35           C  
ATOM   1621  CD2 LEU A 270      42.793  41.929  33.796  1.00 24.18           C  
ATOM   1622  N   ASP A 271      40.789  40.315  29.167  1.00 19.30           N  
ATOM   1623  CA  ASP A 271      40.793  41.010  27.882  1.00 20.74           C  
ATOM   1624  C   ASP A 271      41.034  42.497  28.149  1.00 19.81           C  
ATOM   1625  O   ASP A 271      40.369  43.098  28.992  1.00 19.48           O  
ATOM   1626  CB  ASP A 271      39.460  40.846  27.145  1.00 22.02           C  
ATOM   1627  CG  ASP A 271      39.421  39.608  26.270  1.00 25.23           C  
ATOM   1628  OD1 ASP A 271      40.506  39.075  25.928  1.00 26.41           O  
ATOM   1629  OD2 ASP A 271      38.303  39.178  25.903  1.00 25.32           O  
ATOM   1630  N   ILE A 272      41.988  43.085  27.441  1.00 19.45           N  
ATOM   1631  CA  ILE A 272      42.289  44.496  27.625  1.00 20.56           C  
ATOM   1632  C   ILE A 272      42.284  45.270  26.318  1.00 21.84           C  
ATOM   1633  O   ILE A 272      42.930  44.869  25.349  1.00 21.52           O  
ATOM   1634  CB  ILE A 272      43.652  44.678  28.315  1.00 21.93           C  
ATOM   1635  CG1 ILE A 272      43.568  44.131  29.746  1.00 21.46           C  
ATOM   1636  CG2 ILE A 272      44.063  46.164  28.297  1.00 20.76           C  
ATOM   1637  CD1 ILE A 272      44.852  44.228  30.523  1.00 23.47           C  
ATOM   1638  N   ILE A 273      41.539  46.377  26.300  1.00 21.06           N  
ATOM   1639  CA  ILE A 273      41.451  47.240  25.126  1.00 19.90           C  
ATOM   1640  C   ILE A 273      41.786  48.678  25.522  1.00 21.62           C  
ATOM   1641  O   ILE A 273      41.204  49.222  26.472  1.00 23.29           O  
ATOM   1642  CB  ILE A 273      40.039  47.214  24.507  1.00 19.00           C  
ATOM   1643  CG1 ILE A 273      39.725  45.808  23.990  1.00 19.73           C  
ATOM   1644  CG2 ILE A 273      39.946  48.222  23.362  1.00 15.57           C  
ATOM   1645  CD1 ILE A 273      38.432  45.708  23.207  1.00 14.17           C  
ATOM   1646  N   GLY A 274      42.725  49.287  24.798  1.00 18.39           N  
ATOM   1647  CA  GLY A 274      43.114  50.654  25.084  1.00 14.99           C  
ATOM   1648  C   GLY A 274      42.288  51.658  24.296  1.00 13.29           C  
ATOM   1649  O   GLY A 274      41.252  51.309  23.740  1.00 10.92           O  
ATOM   1650  N   PHE A 275      42.745  52.906  24.254  1.00 12.16           N  
ATOM   1651  CA  PHE A 275      42.047  53.949  23.514  1.00 12.76           C  
ATOM   1652  C   PHE A 275      43.038  55.017  23.021  1.00 13.27           C  
ATOM   1653  O   PHE A 275      43.776  55.587  23.821  1.00 10.90           O  
ATOM   1654  CB  PHE A 275      40.967  54.583  24.405  1.00 13.52           C  
ATOM   1655  CG  PHE A 275      39.958  55.415  23.651  1.00 12.70           C  
ATOM   1656  CD1 PHE A 275      40.321  56.629  23.074  1.00 12.80           C  
ATOM   1657  CD2 PHE A 275      38.648  54.969  23.498  1.00 14.52           C  
ATOM   1658  CE1 PHE A 275      39.393  57.385  22.351  1.00 12.60           C  
ATOM   1659  CE2 PHE A 275      37.716  55.718  22.775  1.00 14.75           C  
ATOM   1660  CZ  PHE A 275      38.096  56.931  22.201  1.00 12.78           C  
ATOM   1661  N   ASP A 276      43.033  55.252  21.703  1.00 14.88           N  
ATOM   1662  CA  ASP A 276      43.866  56.236  20.968  1.00 18.44           C  
ATOM   1663  C   ASP A 276      44.695  55.632  19.835  1.00 19.50           C  
ATOM   1664  O   ASP A 276      44.733  56.165  18.727  1.00 19.93           O  
ATOM   1665  CB  ASP A 276      44.833  57.024  21.877  1.00 17.85           C  
ATOM   1666  CG  ASP A 276      44.129  58.096  22.702  1.00 19.90           C  
ATOM   1667  OD1 ASP A 276      43.068  58.578  22.258  1.00 19.76           O  
ATOM   1668  OD2 ASP A 276      44.642  58.464  23.785  1.00 17.43           O  
ATOM   1669  N   ASN A 277      45.358  54.522  20.124  1.00 21.18           N  
ATOM   1670  CA  ASN A 277      46.224  53.848  19.163  1.00 22.52           C  
ATOM   1671  C   ASN A 277      47.494  54.664  18.896  1.00 22.63           C  
ATOM   1672  O   ASN A 277      47.842  54.939  17.749  1.00 22.72           O  
ATOM   1673  CB  ASN A 277      45.500  53.573  17.835  1.00 23.28           C  
ATOM   1674  CG  ASN A 277      46.381  52.807  16.839  1.00 22.92           C  
ATOM   1675  OD1 ASN A 277      47.084  51.870  17.217  1.00 21.19           O  
ATOM   1676  ND2 ASN A 277      46.337  53.202  15.570  1.00 20.84           N  
ATOM   1677  N   THR A 278      48.171  55.062  19.969  1.00 21.75           N  
ATOM   1678  CA  THR A 278      49.416  55.805  19.856  1.00 22.09           C  
ATOM   1679  C   THR A 278      50.475  54.724  19.665  1.00 23.27           C  
ATOM   1680  O   THR A 278      50.193  53.546  19.844  1.00 24.13           O  
ATOM   1681  CB  THR A 278      49.745  56.573  21.150  1.00 20.92           C  
ATOM   1682  OG1 THR A 278      49.842  55.646  22.237  1.00 20.40           O  
ATOM   1683  CG2 THR A 278      48.672  57.597  21.462  1.00 20.36           C  
ATOM   1684  N   ARG A 279      51.687  55.120  19.307  1.00 24.94           N  
ATOM   1685  CA  ARG A 279      52.764  54.160  19.108  1.00 25.32           C  
ATOM   1686  C   ARG A 279      52.878  53.223  20.314  1.00 25.44           C  
ATOM   1687  O   ARG A 279      53.308  52.074  20.180  1.00 24.13           O  
ATOM   1688  CB  ARG A 279      54.089  54.901  18.894  1.00 27.68           C  
ATOM   1689  CG  ARG A 279      54.092  55.835  17.684  1.00 34.23           C  
ATOM   1690  CD  ARG A 279      55.442  56.533  17.483  1.00 40.92           C  
ATOM   1691  NE  ARG A 279      56.383  55.778  16.648  1.00 45.94           N  
ATOM   1692  CZ  ARG A 279      56.951  54.620  16.984  1.00 47.29           C  
ATOM   1693  NH1 ARG A 279      57.791  54.026  16.148  1.00 47.11           N  
ATOM   1694  NH2 ARG A 279      56.688  54.051  18.154  1.00 48.38           N  
ATOM   1695  N   LEU A 280      52.476  53.713  21.488  1.00 24.09           N  
ATOM   1696  CA  LEU A 280      52.551  52.913  22.702  1.00 21.22           C  
ATOM   1697  C   LEU A 280      51.828  51.591  22.564  1.00 20.86           C  
ATOM   1698  O   LEU A 280      52.185  50.626  23.230  1.00 20.39           O  
ATOM   1699  CB  LEU A 280      51.992  53.683  23.895  1.00 20.30           C  
ATOM   1700  CG  LEU A 280      52.810  54.887  24.365  1.00 19.83           C  
ATOM   1701  CD1 LEU A 280      52.109  55.537  25.552  1.00 22.61           C  
ATOM   1702  CD2 LEU A 280      54.202  54.445  24.758  1.00 19.17           C  
ATOM   1703  N   SER A 281      50.823  51.549  21.694  1.00 21.50           N  
ATOM   1704  CA  SER A 281      50.035  50.334  21.451  1.00 22.25           C  
ATOM   1705  C   SER A 281      50.878  49.172  20.943  1.00 21.22           C  
ATOM   1706  O   SER A 281      50.575  48.011  21.215  1.00 20.21           O  
ATOM   1707  CB  SER A 281      48.939  50.596  20.409  1.00 21.99           C  
ATOM   1708  OG  SER A 281      47.936  51.455  20.904  1.00 27.47           O  
ATOM   1709  N   LEU A 282      51.911  49.498  20.175  1.00 20.85           N  
ATOM   1710  CA  LEU A 282      52.804  48.504  19.588  1.00 22.71           C  
ATOM   1711  C   LEU A 282      53.989  48.172  20.476  1.00 22.84           C  
ATOM   1712  O   LEU A 282      54.611  47.122  20.318  1.00 24.78           O  
ATOM   1713  CB  LEU A 282      53.333  49.016  18.243  1.00 22.28           C  
ATOM   1714  CG  LEU A 282      52.577  48.760  16.940  1.00 23.21           C  
ATOM   1715  CD1 LEU A 282      51.102  48.561  17.189  1.00 24.26           C  
ATOM   1716  CD2 LEU A 282      52.822  49.935  16.004  1.00 23.54           C  
ATOM   1717  N   MET A 283      54.307  49.077  21.396  1.00 23.12           N  
ATOM   1718  CA  MET A 283      55.443  48.903  22.287  1.00 23.88           C  
ATOM   1719  C   MET A 283      55.135  48.148  23.573  1.00 23.34           C  
ATOM   1720  O   MET A 283      55.736  48.405  24.612  1.00 21.98           O  
ATOM   1721  CB  MET A 283      56.051  50.273  22.605  1.00 26.34           C  
ATOM   1722  CG  MET A 283      56.650  50.970  21.383  1.00 26.81           C  
ATOM   1723  SD  MET A 283      57.218  52.653  21.713  1.00 30.36           S  
ATOM   1724  CE  MET A 283      58.750  52.354  22.507  1.00 29.76           C  
ATOM   1725  N   VAL A 284      54.196  47.211  23.493  1.00 24.01           N  
ATOM   1726  CA  VAL A 284      53.812  46.396  24.642  1.00 24.41           C  
ATOM   1727  C   VAL A 284      53.716  44.949  24.185  1.00 24.99           C  
ATOM   1728  O   VAL A 284      53.528  44.663  23.002  1.00 23.57           O  
ATOM   1729  CB  VAL A 284      52.415  46.761  25.197  1.00 24.43           C  
ATOM   1730  CG1 VAL A 284      52.416  46.676  26.714  1.00 23.56           C  
ATOM   1731  CG2 VAL A 284      51.992  48.110  24.709  1.00 24.59           C  
ATOM   1732  N   ARG A 285      53.822  44.037  25.138  1.00 26.47           N  
ATOM   1733  CA  ARG A 285      53.726  42.620  24.846  1.00 26.87           C  
ATOM   1734  C   ARG A 285      52.792  42.054  25.916  1.00 25.63           C  
ATOM   1735  O   ARG A 285      53.112  42.081  27.106  1.00 27.43           O  
ATOM   1736  CB  ARG A 285      55.121  41.989  24.921  1.00 27.81           C  
ATOM   1737  CG  ARG A 285      55.325  40.756  24.043  1.00 32.48           C  
ATOM   1738  CD  ARG A 285      54.760  40.956  22.637  1.00 32.97           C  
ATOM   1739  NE  ARG A 285      55.176  42.220  22.034  1.00 33.83           N  
ATOM   1740  CZ  ARG A 285      56.174  42.349  21.168  1.00 33.36           C  
ATOM   1741  NH1 ARG A 285      56.868  41.287  20.794  1.00 32.97           N  
ATOM   1742  NH2 ARG A 285      56.469  43.543  20.670  1.00 31.89           N  
ATOM   1743  N   PRO A 286      51.608  41.565  25.512  1.00 23.77           N  
ATOM   1744  CA  PRO A 286      51.087  41.503  24.141  1.00 21.85           C  
ATOM   1745  C   PRO A 286      50.736  42.875  23.581  1.00 21.88           C  
ATOM   1746  O   PRO A 286      50.458  43.805  24.333  1.00 22.33           O  
ATOM   1747  CB  PRO A 286      49.856  40.618  24.289  1.00 21.67           C  
ATOM   1748  CG  PRO A 286      49.340  41.018  25.647  1.00 21.30           C  
ATOM   1749  CD  PRO A 286      50.611  41.058  26.475  1.00 21.47           C  
ATOM   1750  N   GLN A 287      50.738  43.002  22.258  1.00 22.99           N  
ATOM   1751  CA  GLN A 287      50.407  44.277  21.641  1.00 22.04           C  
ATOM   1752  C   GLN A 287      48.946  44.613  21.890  1.00 19.99           C  
ATOM   1753  O   GLN A 287      48.062  43.773  21.762  1.00 17.68           O  
ATOM   1754  CB  GLN A 287      50.760  44.252  20.155  1.00 23.50           C  
ATOM   1755  CG  GLN A 287      52.271  44.145  19.970  1.00 28.12           C  
ATOM   1756  CD  GLN A 287      52.703  44.084  18.529  1.00 33.21           C  
ATOM   1757  OE1 GLN A 287      52.193  43.275  17.748  1.00 35.47           O  
ATOM   1758  NE2 GLN A 287      53.663  44.933  18.163  1.00 35.35           N  
ATOM   1759  N   LEU A 288      48.719  45.866  22.262  1.00 19.32           N  
ATOM   1760  CA  LEU A 288      47.401  46.362  22.622  1.00 17.87           C  
ATOM   1761  C   LEU A 288      46.339  46.557  21.544  1.00 18.24           C  
ATOM   1762  O   LEU A 288      46.583  47.193  20.515  1.00 15.85           O  
ATOM   1763  CB  LEU A 288      47.574  47.672  23.398  1.00 17.63           C  
ATOM   1764  CG  LEU A 288      46.328  48.401  23.905  1.00 18.87           C  
ATOM   1765  CD1 LEU A 288      45.574  47.546  24.927  1.00 17.25           C  
ATOM   1766  CD2 LEU A 288      46.759  49.707  24.527  1.00 19.00           C  
ATOM   1767  N   SER A 289      45.159  45.991  21.796  1.00 17.69           N  
ATOM   1768  CA  SER A 289      44.017  46.165  20.908  1.00 20.57           C  
ATOM   1769  C   SER A 289      43.517  47.534  21.362  1.00 21.25           C  
ATOM   1770  O   SER A 289      43.405  47.785  22.561  1.00 22.34           O  
ATOM   1771  CB  SER A 289      42.947  45.099  21.165  1.00 21.35           C  
ATOM   1772  OG  SER A 289      43.373  43.811  20.739  1.00 24.27           O  
ATOM   1773  N   THR A 290      43.213  48.421  20.426  1.00 22.67           N  
ATOM   1774  CA  THR A 290      42.794  49.760  20.814  1.00 23.00           C  
ATOM   1775  C   THR A 290      41.809  50.420  19.870  1.00 22.65           C  
ATOM   1776  O   THR A 290      41.663  50.017  18.716  1.00 22.31           O  
ATOM   1777  CB  THR A 290      44.023  50.683  20.912  1.00 22.73           C  
ATOM   1778  OG1 THR A 290      44.950  50.126  21.844  1.00 30.23           O  
ATOM   1779  CG2 THR A 290      43.639  52.064  21.380  1.00 20.24           C  
ATOM   1780  N   VAL A 291      41.131  51.442  20.386  1.00 21.01           N  
ATOM   1781  CA  VAL A 291      40.201  52.222  19.595  1.00 18.44           C  
ATOM   1782  C   VAL A 291      41.117  53.210  18.898  1.00 16.55           C  
ATOM   1783  O   VAL A 291      41.968  53.805  19.534  1.00 15.07           O  
ATOM   1784  CB  VAL A 291      39.209  52.991  20.478  1.00 17.76           C  
ATOM   1785  CG1 VAL A 291      38.445  54.019  19.639  1.00 16.09           C  
ATOM   1786  CG2 VAL A 291      38.247  52.013  21.140  1.00 18.31           C  
ATOM   1787  N   VAL A 292      40.953  53.370  17.593  1.00 17.01           N  
ATOM   1788  CA  VAL A 292      41.790  54.281  16.838  1.00 16.84           C  
ATOM   1789  C   VAL A 292      41.279  55.715  16.820  1.00 16.11           C  
ATOM   1790  O   VAL A 292      40.116  55.962  16.500  1.00 15.55           O  
ATOM   1791  CB  VAL A 292      41.945  53.823  15.364  1.00 18.60           C  
ATOM   1792  CG1 VAL A 292      42.672  54.901  14.553  1.00 16.68           C  
ATOM   1793  CG2 VAL A 292      42.717  52.503  15.300  1.00 18.33           C  
ATOM   1794  N   GLN A 293      42.152  56.650  17.190  1.00 14.49           N  
ATOM   1795  CA  GLN A 293      41.819  58.066  17.132  1.00 14.18           C  
ATOM   1796  C   GLN A 293      42.884  58.693  16.229  1.00 13.96           C  
ATOM   1797  O   GLN A 293      44.078  58.700  16.566  1.00 12.75           O  
ATOM   1798  CB  GLN A 293      41.843  58.746  18.507  1.00 12.72           C  
ATOM   1799  CG  GLN A 293      41.397  60.209  18.399  1.00 12.71           C  
ATOM   1800  CD  GLN A 293      41.257  60.940  19.727  1.00 12.40           C  
ATOM   1801  OE1 GLN A 293      40.771  62.069  19.762  1.00 16.59           O  
ATOM   1802  NE2 GLN A 293      41.683  60.314  20.814  1.00  9.03           N  
ATOM   1803  N   PRO A 294      42.465  59.209  15.060  1.00 12.30           N  
ATOM   1804  CA  PRO A 294      43.360  59.841  14.085  1.00 12.18           C  
ATOM   1805  C   PRO A 294      43.872  61.151  14.674  1.00 11.35           C  
ATOM   1806  O   PRO A 294      43.540  62.232  14.196  1.00 13.23           O  
ATOM   1807  CB  PRO A 294      42.444  60.050  12.884  1.00 11.10           C  
ATOM   1808  CG  PRO A 294      41.139  60.403  13.553  1.00 10.71           C  
ATOM   1809  CD  PRO A 294      41.053  59.382  14.668  1.00 10.80           C  
ATOM   1810  N   THR A 295      44.689  61.034  15.714  1.00 10.50           N  
ATOM   1811  CA  THR A 295      45.223  62.180  16.433  1.00 11.33           C  
ATOM   1812  C   THR A 295      45.883  63.251  15.572  1.00 10.85           C  
ATOM   1813  O   THR A 295      45.553  64.433  15.676  1.00 11.77           O  
ATOM   1814  CB  THR A 295      46.186  61.690  17.529  1.00 12.29           C  
ATOM   1815  OG1 THR A 295      45.465  60.809  18.402  1.00 11.80           O  
ATOM   1816  CG2 THR A 295      46.748  62.854  18.336  1.00  9.68           C  
ATOM   1817  N   TYR A 296      46.815  62.850  14.724  1.00 10.37           N  
ATOM   1818  CA  TYR A 296      47.459  63.818  13.859  1.00 12.44           C  
ATOM   1819  C   TYR A 296      46.391  64.514  13.007  1.00 12.03           C  
ATOM   1820  O   TYR A 296      46.392  65.740  12.871  1.00 10.36           O  
ATOM   1821  CB  TYR A 296      48.478  63.127  12.953  1.00 10.24           C  
ATOM   1822  CG  TYR A 296      49.108  64.045  11.937  1.00 11.88           C  
ATOM   1823  CD1 TYR A 296      50.440  64.447  12.055  1.00 12.93           C  
ATOM   1824  CD2 TYR A 296      48.381  64.497  10.840  1.00 11.68           C  
ATOM   1825  CE1 TYR A 296      51.026  65.269  11.095  1.00 13.30           C  
ATOM   1826  CE2 TYR A 296      48.950  65.314   9.882  1.00 11.90           C  
ATOM   1827  CZ  TYR A 296      50.270  65.696  10.006  1.00 13.16           C  
ATOM   1828  OH  TYR A 296      50.829  66.481   9.027  1.00 10.76           O  
ATOM   1829  N   ASP A 297      45.485  63.729  12.433  1.00 11.52           N  
ATOM   1830  CA  ASP A 297      44.420  64.283  11.591  1.00 13.26           C  
ATOM   1831  C   ASP A 297      43.583  65.340  12.308  1.00 13.55           C  
ATOM   1832  O   ASP A 297      43.203  66.342  11.704  1.00 13.61           O  
ATOM   1833  CB  ASP A 297      43.494  63.170  11.089  1.00 11.84           C  
ATOM   1834  CG  ASP A 297      44.171  62.259  10.082  1.00 14.84           C  
ATOM   1835  OD1 ASP A 297      45.422  62.264  10.014  1.00 13.34           O  
ATOM   1836  OD2 ASP A 297      43.453  61.525   9.369  1.00 13.98           O  
ATOM   1837  N   ILE A 298      43.287  65.108  13.587  1.00 12.79           N  
ATOM   1838  CA  ILE A 298      42.496  66.052  14.366  1.00 12.80           C  
ATOM   1839  C   ILE A 298      43.215  67.403  14.410  1.00 13.57           C  
ATOM   1840  O   ILE A 298      42.594  68.458  14.258  1.00 13.37           O  
ATOM   1841  CB  ILE A 298      42.256  65.520  15.801  1.00 12.05           C  
ATOM   1842  CG1 ILE A 298      41.279  64.342  15.753  1.00 12.96           C  
ATOM   1843  CG2 ILE A 298      41.713  66.623  16.689  1.00  9.43           C  
ATOM   1844  CD1 ILE A 298      41.092  63.631  17.075  1.00 10.29           C  
ATOM   1845  N   GLY A 299      44.526  67.364  14.612  1.00 12.93           N  
ATOM   1846  CA  GLY A 299      45.293  68.591  14.642  1.00 13.09           C  
ATOM   1847  C   GLY A 299      45.262  69.246  13.272  1.00 12.82           C  
ATOM   1848  O   GLY A 299      45.013  70.447  13.151  1.00 12.47           O  
ATOM   1849  N   ALA A 300      45.504  68.451  12.234  1.00 11.63           N  
ATOM   1850  CA  ALA A 300      45.502  68.962  10.861  1.00 13.59           C  
ATOM   1851  C   ALA A 300      44.148  69.571  10.476  1.00 13.00           C  
ATOM   1852  O   ALA A 300      44.077  70.721  10.039  1.00 14.87           O  
ATOM   1853  CB  ALA A 300      45.871  67.840   9.884  1.00 11.25           C  
ATOM   1854  N   VAL A 301      43.082  68.795  10.639  1.00 11.44           N  
ATOM   1855  CA  VAL A 301      41.737  69.256  10.311  1.00 12.62           C  
ATOM   1856  C   VAL A 301      41.331  70.493  11.135  1.00 14.10           C  
ATOM   1857  O   VAL A 301      40.629  71.376  10.630  1.00 13.38           O  
ATOM   1858  CB  VAL A 301      40.702  68.114  10.510  1.00 11.32           C  
ATOM   1859  CG1 VAL A 301      39.279  68.636  10.317  1.00 12.72           C  
ATOM   1860  CG2 VAL A 301      40.987  66.994   9.518  1.00  8.42           C  
ATOM   1861  N   ALA A 302      41.792  70.564  12.384  1.00 13.08           N  
ATOM   1862  CA  ALA A 302      41.482  71.697  13.252  1.00 15.37           C  
ATOM   1863  C   ALA A 302      42.086  72.986  12.701  1.00 17.34           C  
ATOM   1864  O   ALA A 302      41.399  74.005  12.584  1.00 17.99           O  
ATOM   1865  CB  ALA A 302      42.010  71.447  14.651  1.00 14.00           C  
ATOM   1866  N   MET A 303      43.375  72.928  12.369  1.00 17.52           N  
ATOM   1867  CA  MET A 303      44.095  74.078  11.835  1.00 17.28           C  
ATOM   1868  C   MET A 303      43.552  74.452  10.459  1.00 17.26           C  
ATOM   1869  O   MET A 303      43.439  75.633  10.124  1.00 16.68           O  
ATOM   1870  CB  MET A 303      45.594  73.753  11.754  1.00 18.70           C  
ATOM   1871  CG  MET A 303      46.473  74.849  11.156  1.00 17.84           C  
ATOM   1872  SD  MET A 303      46.379  76.469  11.973  1.00 18.83           S  
ATOM   1873  CE  MET A 303      46.418  76.035  13.602  1.00 21.10           C  
ATOM   1874  N   ARG A 304      43.218  73.438   9.666  1.00 17.31           N  
ATOM   1875  CA  ARG A 304      42.669  73.662   8.333  1.00 17.85           C  
ATOM   1876  C   ARG A 304      41.316  74.364   8.466  1.00 16.75           C  
ATOM   1877  O   ARG A 304      41.061  75.357   7.782  1.00 18.25           O  
ATOM   1878  CB  ARG A 304      42.534  72.326   7.587  1.00 17.87           C  
ATOM   1879  CG  ARG A 304      41.773  72.380   6.261  1.00 15.96           C  
ATOM   1880  CD  ARG A 304      42.331  73.404   5.282  1.00 16.00           C  
ATOM   1881  NE  ARG A 304      41.527  73.444   4.063  1.00 13.99           N  
ATOM   1882  CZ  ARG A 304      41.360  74.521   3.300  1.00 16.57           C  
ATOM   1883  NH1 ARG A 304      40.605  74.447   2.210  1.00 16.62           N  
ATOM   1884  NH2 ARG A 304      41.934  75.675   3.624  1.00 15.65           N  
ATOM   1885  N   LEU A 305      40.455  73.859   9.349  1.00 15.01           N  
ATOM   1886  CA  LEU A 305      39.148  74.483   9.576  1.00 13.53           C  
ATOM   1887  C   LEU A 305      39.339  75.924  10.051  1.00 13.94           C  
ATOM   1888  O   LEU A 305      38.579  76.813   9.673  1.00 15.87           O  
ATOM   1889  CB  LEU A 305      38.351  73.706  10.625  1.00 10.53           C  
ATOM   1890  CG  LEU A 305      37.133  74.385  11.269  1.00 10.15           C  
ATOM   1891  CD1 LEU A 305      36.134  74.861  10.213  1.00 10.36           C  
ATOM   1892  CD2 LEU A 305      36.475  73.383  12.202  1.00 10.12           C  
ATOM   1893  N   LEU A 306      40.357  76.153  10.879  1.00 12.93           N  
ATOM   1894  CA  LEU A 306      40.634  77.494  11.377  1.00 11.76           C  
ATOM   1895  C   LEU A 306      41.003  78.423  10.225  1.00 14.16           C  
ATOM   1896  O   LEU A 306      40.521  79.554  10.175  1.00 14.49           O  
ATOM   1897  CB  LEU A 306      41.774  77.478  12.391  1.00  9.92           C  
ATOM   1898  CG  LEU A 306      42.173  78.827  12.998  1.00  9.17           C  
ATOM   1899  CD1 LEU A 306      41.065  79.321  13.917  1.00  9.94           C  
ATOM   1900  CD2 LEU A 306      43.470  78.682  13.783  1.00 10.86           C  
ATOM   1901  N   THR A 307      41.848  77.956   9.302  1.00 14.89           N  
ATOM   1902  CA  THR A 307      42.255  78.792   8.169  1.00 17.43           C  
ATOM   1903  C   THR A 307      41.054  79.176   7.313  1.00 18.55           C  
ATOM   1904  O   THR A 307      41.027  80.263   6.736  1.00 20.95           O  
ATOM   1905  CB  THR A 307      43.317  78.109   7.242  1.00 16.40           C  
ATOM   1906  OG1 THR A 307      42.740  76.978   6.577  1.00 18.37           O  
ATOM   1907  CG2 THR A 307      44.524  77.666   8.049  1.00 16.44           C  
ATOM   1908  N   LYS A 308      40.066  78.289   7.223  1.00 19.13           N  
ATOM   1909  CA  LYS A 308      38.865  78.592   6.443  1.00 19.57           C  
ATOM   1910  C   LYS A 308      38.135  79.739   7.128  1.00 20.63           C  
ATOM   1911  O   LYS A 308      37.677  80.676   6.473  1.00 20.69           O  
ATOM   1912  CB  LYS A 308      37.934  77.382   6.362  1.00 16.73           C  
ATOM   1913  CG  LYS A 308      38.428  76.250   5.477  1.00 14.54           C  
ATOM   1914  CD  LYS A 308      37.368  75.153   5.396  1.00 10.74           C  
ATOM   1915  CE  LYS A 308      37.716  74.127   4.352  1.00  6.02           C  
ATOM   1916  NZ  LYS A 308      36.638  73.124   4.253  1.00  4.48           N  
ATOM   1917  N   LEU A 309      38.030  79.654   8.452  1.00 21.28           N  
ATOM   1918  CA  LEU A 309      37.372  80.692   9.236  1.00 22.20           C  
ATOM   1919  C   LEU A 309      38.117  82.022   9.098  1.00 24.59           C  
ATOM   1920  O   LEU A 309      37.496  83.067   8.895  1.00 25.88           O  
ATOM   1921  CB  LEU A 309      37.302  80.272  10.710  1.00 19.93           C  
ATOM   1922  CG  LEU A 309      36.015  79.649  11.281  1.00 19.39           C  
ATOM   1923  CD1 LEU A 309      35.120  79.104  10.183  1.00 15.53           C  
ATOM   1924  CD2 LEU A 309      36.391  78.557  12.265  1.00 16.11           C  
ATOM   1925  N   MET A 310      39.445  81.985   9.175  1.00 25.64           N  
ATOM   1926  CA  MET A 310      40.242  83.210   9.072  1.00 28.46           C  
ATOM   1927  C   MET A 310      40.239  83.838   7.683  1.00 31.84           C  
ATOM   1928  O   MET A 310      40.509  85.035   7.536  1.00 29.47           O  
ATOM   1929  CB  MET A 310      41.685  82.948   9.515  1.00 25.93           C  
ATOM   1930  CG  MET A 310      41.806  82.587  10.987  1.00 24.51           C  
ATOM   1931  SD  MET A 310      43.498  82.325  11.498  1.00 23.28           S  
ATOM   1932  CE  MET A 310      43.972  80.954  10.386  1.00 21.82           C  
ATOM   1933  N   ASN A 311      39.943  83.035   6.665  1.00 36.61           N  
ATOM   1934  CA  ASN A 311      39.899  83.534   5.290  1.00 41.59           C  
ATOM   1935  C   ASN A 311      38.455  83.620   4.792  1.00 42.95           C  
ATOM   1936  O   ASN A 311      38.193  83.695   3.590  1.00 42.62           O  
ATOM   1937  CB  ASN A 311      40.725  82.631   4.371  1.00 44.91           C  
ATOM   1938  CG  ASN A 311      42.213  82.697   4.675  1.00 49.18           C  
ATOM   1939  OD1 ASN A 311      42.656  82.354   5.776  1.00 50.87           O  
ATOM   1940  ND2 ASN A 311      42.993  83.143   3.698  1.00 51.16           N  
ATOM   1941  N   LYS A 312      37.526  83.601   5.738  1.00 44.85           N  
ATOM   1942  CA  LYS A 312      36.104  83.685   5.443  1.00 47.62           C  
ATOM   1943  C   LYS A 312      35.582  82.789   4.319  1.00 48.27           C  
ATOM   1944  O   LYS A 312      34.644  83.176   3.618  1.00 49.61           O  
ATOM   1945  CB  LYS A 312      35.712  85.142   5.142  1.00 49.45           C  
ATOM   1946  CG  LYS A 312      35.761  86.085   6.345  1.00 51.86           C  
ATOM   1947  CD  LYS A 312      37.178  86.542   6.663  1.00 53.79           C  
ATOM   1948  CE  LYS A 312      37.719  87.467   5.573  1.00 56.42           C  
ATOM   1949  NZ  LYS A 312      39.114  87.944   5.831  1.00 56.19           N  
ATOM   1950  N   GLU A 313      36.168  81.610   4.118  1.00 47.95           N  
ATOM   1951  CA  GLU A 313      35.638  80.741   3.073  1.00 48.28           C  
ATOM   1952  C   GLU A 313      34.489  79.915   3.651  1.00 49.41           C  
ATOM   1953  O   GLU A 313      34.359  79.795   4.872  1.00 48.82           O  
ATOM   1954  CB  GLU A 313      36.723  79.849   2.433  1.00 47.54           C  
ATOM   1955  CG  GLU A 313      37.869  79.370   3.304  1.00 47.53           C  
ATOM   1956  CD  GLU A 313      38.932  78.628   2.487  1.00 47.18           C  
ATOM   1957  OE1 GLU A 313      38.594  77.598   1.866  1.00 48.71           O  
ATOM   1958  OE2 GLU A 313      40.101  79.067   2.457  1.00 46.50           O  
ATOM   1959  N   PRO A 314      33.621  79.360   2.781  1.00 50.15           N  
ATOM   1960  CA  PRO A 314      32.461  78.549   3.179  1.00 49.71           C  
ATOM   1961  C   PRO A 314      32.745  77.395   4.135  1.00 47.91           C  
ATOM   1962  O   PRO A 314      33.612  76.559   3.882  1.00 47.23           O  
ATOM   1963  CB  PRO A 314      31.897  78.076   1.837  1.00 50.32           C  
ATOM   1964  CG  PRO A 314      33.113  78.020   0.962  1.00 50.58           C  
ATOM   1965  CD  PRO A 314      33.800  79.312   1.318  1.00 50.04           C  
ATOM   1966  N   VAL A 315      31.991  77.357   5.231  1.00 47.13           N  
ATOM   1967  CA  VAL A 315      32.156  76.321   6.244  1.00 46.59           C  
ATOM   1968  C   VAL A 315      30.951  75.395   6.388  1.00 46.48           C  
ATOM   1969  O   VAL A 315      29.917  75.766   6.950  1.00 44.62           O  
ATOM   1970  CB  VAL A 315      32.466  76.945   7.623  1.00 46.04           C  
ATOM   1971  CG1 VAL A 315      32.606  75.856   8.676  1.00 43.61           C  
ATOM   1972  CG2 VAL A 315      33.736  77.757   7.537  1.00 45.48           C  
ATOM   1973  N   GLU A 316      31.103  74.184   5.868  1.00 47.43           N  
ATOM   1974  CA  GLU A 316      30.066  73.167   5.947  1.00 49.57           C  
ATOM   1975  C   GLU A 316      30.229  72.477   7.303  1.00 49.13           C  
ATOM   1976  O   GLU A 316      31.069  71.589   7.453  1.00 51.45           O  
ATOM   1977  CB  GLU A 316      30.248  72.152   4.808  1.00 51.12           C  
ATOM   1978  CG  GLU A 316      29.491  70.830   4.978  1.00 54.59           C  
ATOM   1979  CD  GLU A 316      27.986  70.949   4.772  1.00 56.98           C  
ATOM   1980  OE1 GLU A 316      27.328  71.718   5.512  1.00 56.88           O  
ATOM   1981  OE2 GLU A 316      27.461  70.260   3.866  1.00 56.94           O  
ATOM   1982  N   GLU A 317      29.436  72.898   8.287  1.00 46.92           N  
ATOM   1983  CA  GLU A 317      29.492  72.331   9.637  1.00 44.47           C  
ATOM   1984  C   GLU A 317      30.747  72.726  10.417  1.00 41.89           C  
ATOM   1985  O   GLU A 317      31.879  72.457  10.000  1.00 39.33           O  
ATOM   1986  CB  GLU A 317      29.371  70.801   9.592  1.00 45.85           C  
ATOM   1987  CG  GLU A 317      28.003  70.300   9.144  1.00 49.53           C  
ATOM   1988  CD  GLU A 317      26.871  70.778  10.048  1.00 52.40           C  
ATOM   1989  OE1 GLU A 317      26.678  72.009  10.186  1.00 53.27           O  
ATOM   1990  OE2 GLU A 317      26.171  69.918  10.624  1.00 54.94           O  
ATOM   1991  N   HIS A 318      30.527  73.362  11.560  1.00 39.00           N  
ATOM   1992  CA  HIS A 318      31.613  73.807  12.415  1.00 36.74           C  
ATOM   1993  C   HIS A 318      32.018  72.721  13.411  1.00 34.44           C  
ATOM   1994  O   HIS A 318      33.110  72.763  13.966  1.00 34.56           O  
ATOM   1995  CB  HIS A 318      31.202  75.093  13.143  1.00 38.90           C  
ATOM   1996  CG  HIS A 318      30.972  76.257  12.223  1.00 41.08           C  
ATOM   1997  ND1 HIS A 318      30.005  76.251  11.239  1.00 43.20           N  
ATOM   1998  CD2 HIS A 318      31.607  77.450  12.117  1.00 41.44           C  
ATOM   1999  CE1 HIS A 318      30.057  77.388  10.566  1.00 42.65           C  
ATOM   2000  NE2 HIS A 318      31.021  78.133  11.078  1.00 41.41           N  
ATOM   2001  N   ILE A 319      31.138  71.747  13.632  1.00 32.04           N  
ATOM   2002  CA  ILE A 319      31.424  70.638  14.543  1.00 29.86           C  
ATOM   2003  C   ILE A 319      31.757  69.388  13.719  1.00 27.83           C  
ATOM   2004  O   ILE A 319      30.871  68.729  13.175  1.00 28.31           O  
ATOM   2005  CB  ILE A 319      30.217  70.351  15.484  1.00 29.51           C  
ATOM   2006  CG1 ILE A 319      30.183  71.369  16.632  1.00 31.70           C  
ATOM   2007  CG2 ILE A 319      30.336  68.966  16.083  1.00 28.76           C  
ATOM   2008  CD1 ILE A 319      30.028  72.817  16.204  1.00 34.26           C  
ATOM   2009  N   VAL A 320      33.046  69.072  13.641  1.00 25.47           N  
ATOM   2010  CA  VAL A 320      33.536  67.934  12.864  1.00 23.31           C  
ATOM   2011  C   VAL A 320      33.911  66.721  13.708  1.00 22.32           C  
ATOM   2012  O   VAL A 320      34.535  66.846  14.758  1.00 22.81           O  
ATOM   2013  CB  VAL A 320      34.774  68.348  12.031  1.00 23.11           C  
ATOM   2014  CG1 VAL A 320      35.262  67.183  11.189  1.00 22.15           C  
ATOM   2015  CG2 VAL A 320      34.425  69.536  11.161  1.00 21.73           C  
ATOM   2016  N   GLU A 321      33.526  65.544  13.234  1.00 22.37           N  
ATOM   2017  CA  GLU A 321      33.819  64.300  13.928  1.00 23.69           C  
ATOM   2018  C   GLU A 321      34.513  63.379  12.939  1.00 22.40           C  
ATOM   2019  O   GLU A 321      33.861  62.809  12.068  1.00 23.48           O  
ATOM   2020  CB  GLU A 321      32.526  63.625  14.401  1.00 26.73           C  
ATOM   2021  CG  GLU A 321      31.557  64.528  15.151  1.00 31.73           C  
ATOM   2022  CD  GLU A 321      31.610  64.332  16.651  1.00 34.67           C  
ATOM   2023  OE1 GLU A 321      32.703  64.503  17.228  1.00 41.69           O  
ATOM   2024  OE2 GLU A 321      30.565  64.011  17.253  1.00 32.69           O  
ATOM   2025  N   LEU A 322      35.826  63.233  13.062  1.00 20.73           N  
ATOM   2026  CA  LEU A 322      36.562  62.354  12.161  1.00 19.96           C  
ATOM   2027  C   LEU A 322      36.201  60.907  12.516  1.00 19.79           C  
ATOM   2028  O   LEU A 322      35.876  60.604  13.660  1.00 19.73           O  
ATOM   2029  CB  LEU A 322      38.075  62.594  12.286  1.00 15.39           C  
ATOM   2030  CG  LEU A 322      38.557  64.008  11.931  1.00 15.63           C  
ATOM   2031  CD1 LEU A 322      40.068  64.094  12.099  1.00 11.78           C  
ATOM   2032  CD2 LEU A 322      38.160  64.356  10.495  1.00 12.81           C  
ATOM   2033  N   PRO A 323      36.245  59.997  11.534  1.00 20.37           N  
ATOM   2034  CA  PRO A 323      35.902  58.598  11.814  1.00 20.36           C  
ATOM   2035  C   PRO A 323      36.884  57.855  12.717  1.00 20.94           C  
ATOM   2036  O   PRO A 323      38.081  58.152  12.737  1.00 21.79           O  
ATOM   2037  CB  PRO A 323      35.810  57.987  10.419  1.00 18.98           C  
ATOM   2038  CG  PRO A 323      36.845  58.769   9.653  1.00 20.45           C  
ATOM   2039  CD  PRO A 323      36.610  60.186  10.116  1.00 19.16           C  
ATOM   2040  N   HIS A 324      36.361  56.895  13.474  1.00 20.72           N  
ATOM   2041  CA  HIS A 324      37.182  56.081  14.362  1.00 21.28           C  
ATOM   2042  C   HIS A 324      36.987  54.616  13.991  1.00 20.97           C  
ATOM   2043  O   HIS A 324      36.156  54.289  13.151  1.00 21.65           O  
ATOM   2044  CB  HIS A 324      36.796  56.295  15.834  1.00 21.74           C  
ATOM   2045  CG  HIS A 324      35.389  55.893  16.161  1.00 22.60           C  
ATOM   2046  ND1 HIS A 324      34.324  56.766  16.077  1.00 24.09           N  
ATOM   2047  CD2 HIS A 324      34.870  54.703  16.546  1.00 21.28           C  
ATOM   2048  CE1 HIS A 324      33.210  56.130  16.395  1.00 22.77           C  
ATOM   2049  NE2 HIS A 324      33.512  54.878  16.683  1.00 21.69           N  
ATOM   2050  N   ARG A 325      37.761  53.737  14.613  1.00 20.75           N  
ATOM   2051  CA  ARG A 325      37.662  52.306  14.343  1.00 22.73           C  
ATOM   2052  C   ARG A 325      38.429  51.579  15.431  1.00 22.19           C  
ATOM   2053  O   ARG A 325      39.034  52.209  16.295  1.00 20.03           O  
ATOM   2054  CB  ARG A 325      38.264  51.965  12.969  1.00 23.20           C  
ATOM   2055  CG  ARG A 325      39.620  52.627  12.704  1.00 27.21           C  
ATOM   2056  CD  ARG A 325      40.247  52.149  11.401  1.00 29.88           C  
ATOM   2057  NE  ARG A 325      41.052  50.945  11.588  1.00 32.47           N  
ATOM   2058  CZ  ARG A 325      42.377  50.940  11.698  1.00 33.51           C  
ATOM   2059  NH1 ARG A 325      43.057  52.077  11.635  1.00 35.81           N  
ATOM   2060  NH2 ARG A 325      43.025  49.798  11.877  1.00 33.59           N  
ATOM   2061  N   ILE A 326      38.406  50.254  15.392  1.00 22.26           N  
ATOM   2062  CA  ILE A 326      39.114  49.480  16.395  1.00 21.78           C  
ATOM   2063  C   ILE A 326      40.182  48.597  15.768  1.00 21.28           C  
ATOM   2064  O   ILE A 326      39.931  47.886  14.804  1.00 20.49           O  
ATOM   2065  CB  ILE A 326      38.147  48.599  17.205  1.00 21.87           C  
ATOM   2066  CG1 ILE A 326      37.021  49.467  17.779  1.00 22.68           C  
ATOM   2067  CG2 ILE A 326      38.902  47.887  18.322  1.00 19.84           C  
ATOM   2068  CD1 ILE A 326      35.963  48.684  18.528  1.00 24.20           C  
ATOM   2069  N   GLU A 327      41.384  48.670  16.323  1.00 22.83           N  
ATOM   2070  CA  GLU A 327      42.501  47.871  15.857  1.00 25.23           C  
ATOM   2071  C   GLU A 327      42.693  46.779  16.905  1.00 25.97           C  
ATOM   2072  O   GLU A 327      43.098  47.061  18.037  1.00 25.60           O  
ATOM   2073  CB  GLU A 327      43.758  48.739  15.751  1.00 27.38           C  
ATOM   2074  CG  GLU A 327      45.042  47.991  15.365  1.00 33.12           C  
ATOM   2075  CD  GLU A 327      44.964  47.351  13.987  1.00 36.64           C  
ATOM   2076  OE1 GLU A 327      44.510  48.030  13.043  1.00 38.66           O  
ATOM   2077  OE2 GLU A 327      45.364  46.175  13.844  1.00 37.90           O  
ATOM   2078  N   LEU A 328      42.370  45.543  16.534  1.00 26.24           N  
ATOM   2079  CA  LEU A 328      42.515  44.407  17.437  1.00 27.21           C  
ATOM   2080  C   LEU A 328      43.891  43.803  17.285  1.00 27.82           C  
ATOM   2081  O   LEU A 328      44.312  43.471  16.178  1.00 29.66           O  
ATOM   2082  CB  LEU A 328      41.469  43.326  17.142  1.00 28.51           C  
ATOM   2083  CG  LEU A 328      40.039  43.552  17.637  1.00 29.57           C  
ATOM   2084  CD1 LEU A 328      39.434  44.761  16.946  1.00 31.73           C  
ATOM   2085  CD2 LEU A 328      39.215  42.317  17.349  1.00 29.99           C  
ATOM   2086  N   ARG A 329      44.600  43.664  18.396  1.00 26.60           N  
ATOM   2087  CA  ARG A 329      45.921  43.078  18.354  1.00 25.21           C  
ATOM   2088  C   ARG A 329      45.949  41.841  19.233  1.00 27.84           C  
ATOM   2089  O   ARG A 329      45.073  40.984  19.111  1.00 30.23           O  
ATOM   2090  CB  ARG A 329      46.966  44.106  18.785  1.00 23.27           C  
ATOM   2091  CG  ARG A 329      46.978  45.338  17.889  1.00 20.38           C  
ATOM   2092  CD  ARG A 329      48.316  46.050  17.905  1.00 19.11           C  
ATOM   2093  NE  ARG A 329      48.358  47.152  16.946  1.00 18.72           N  
ATOM   2094  CZ  ARG A 329      47.875  48.373  17.172  1.00 21.54           C  
ATOM   2095  NH1 ARG A 329      47.306  48.669  18.333  1.00 21.81           N  
ATOM   2096  NH2 ARG A 329      47.962  49.308  16.235  1.00 21.07           N  
ATOM   2097  N   LYS A 330      46.920  41.745  20.133  1.00 28.67           N  
ATOM   2098  CA  LYS A 330      47.033  40.564  20.982  1.00 28.99           C  
ATOM   2099  C   LYS A 330      46.606  40.687  22.448  1.00 29.07           C  
ATOM   2100  O   LYS A 330      46.752  39.727  23.211  1.00 29.84           O  
ATOM   2101  CB  LYS A 330      48.470  40.027  20.917  1.00 28.88           C  
ATOM   2102  CG  LYS A 330      48.890  39.561  19.529  1.00 29.76           C  
ATOM   2103  CD  LYS A 330      47.926  38.512  18.993  1.00 31.67           C  
ATOM   2104  CE  LYS A 330      48.371  37.977  17.635  1.00 35.20           C  
ATOM   2105  NZ  LYS A 330      49.724  37.337  17.694  1.00 35.81           N  
ATOM   2106  N   SER A 331      46.086  41.841  22.859  1.00 27.31           N  
ATOM   2107  CA  SER A 331      45.662  41.986  24.252  1.00 25.03           C  
ATOM   2108  C   SER A 331      44.213  41.528  24.448  1.00 24.95           C  
ATOM   2109  O   SER A 331      43.673  41.615  25.549  1.00 22.52           O  
ATOM   2110  CB  SER A 331      45.851  43.432  24.742  1.00 21.97           C  
ATOM   2111  OG  SER A 331      45.058  44.349  24.018  1.00 20.08           O  
ATOM   2112  N   THR A 332      43.601  41.038  23.371  1.00 25.40           N  
ATOM   2113  CA  THR A 332      42.232  40.521  23.401  1.00 29.38           C  
ATOM   2114  C   THR A 332      42.199  39.151  22.704  1.00 32.31           C  
ATOM   2115  O   THR A 332      42.849  38.947  21.673  1.00 32.86           O  
ATOM   2116  CB  THR A 332      41.219  41.483  22.699  1.00 28.61           C  
ATOM   2117  OG1 THR A 332      41.630  41.741  21.348  1.00 27.23           O  
ATOM   2118  CG2 THR A 332      41.127  42.789  23.448  1.00 27.73           C  
ATOM   2119  N   LYS A 333      41.451  38.213  23.281  1.00 35.10           N  
ATOM   2120  CA  LYS A 333      41.341  36.856  22.737  1.00 37.33           C  
ATOM   2121  C   LYS A 333      40.722  36.841  21.344  1.00 38.27           C  
ATOM   2122  O   LYS A 333      41.360  36.289  20.419  1.00 40.30           O  
ATOM   2123  CB  LYS A 333      40.502  35.980  23.677  1.00 37.94           C  
ATOM   2124  CG  LYS A 333      41.047  35.890  25.100  1.00 40.26           C  
ATOM   2125  CD  LYS A 333      39.907  35.838  26.122  1.00 43.09           C  
ATOM   2126  CE  LYS A 333      40.405  36.179  27.521  1.00 43.63           C  
ATOM   2127  NZ  LYS A 333      39.311  36.561  28.466  1.00 45.53           N  
TER    2128      LYS A 333                                                      
END
MOLECULE T0441.pdb
ATOM   1966  N   TYR    71      49.594  89.534  10.660  1.00 83.57           N  
ATOM   1967  CA  TYR    71      48.568  88.745  11.391  1.00 83.73           C  
ATOM   1968  C   TYR    71      49.071  87.324  11.626  1.00 83.84           C  
ATOM   1969  O   TYR    71      49.434  86.619  10.681  1.00 83.94           O  
ATOM   1970  CB  TYR    71      47.245  88.735  10.617  1.00 83.64           C  
ATOM   1971  N   SER    72      49.096  86.923  12.896  1.00 83.90           N  
ATOM   1972  CA  SER    72      49.603  85.615  13.315  1.00 83.83           C  
ATOM   1973  C   SER    72      48.574  84.867  14.158  1.00 83.82           C  
ATOM   1974  O   SER    72      47.678  85.478  14.757  1.00 83.79           O  
ATOM   1975  CB  SER    72      50.905  85.773  14.103  1.00 83.93           C  
ATOM   1976  OG  SER    72      50.713  86.579  15.256  1.00 83.98           O  
ATOM   1977  N   ILE    73      48.729  83.546  14.221  1.00 83.67           N  
ATOM   1978  CA  ILE    73      47.692  82.646  14.742  1.00 83.53           C  
ATOM   1979  C   ILE    73      48.098  81.919  16.050  1.00 83.45           C  
ATOM   1980  O   ILE    73      49.184  81.323  16.148  1.00 83.38           O  
ATOM   1981  CB  ILE    73      47.225  81.659  13.623  1.00 83.50           C  
ATOM   1982  CG1 ILE    73      46.156  80.671  14.113  1.00 83.40           C  
ATOM   1983  CG2 ILE    73      48.419  80.944  13.007  1.00 83.88           C  
ATOM   1984  CD1 ILE    73      46.690  79.468  14.879  1.00 82.70           C  
ATOM   1985  N   ALA    74      47.204  81.964  17.038  1.00 83.07           N  
ATOM   1986  CA  ALA    74      47.529  81.533  18.394  1.00 82.96           C  
ATOM   1987  C   ALA    74      46.796  80.279  18.842  1.00 82.74           C  
ATOM   1988  O   ALA    74      45.665  80.017  18.424  1.00 83.01           O  
ATOM   1989  CB  ALA    74      47.301  82.671  19.390  1.00 83.02           C  
ATOM   1990  N   LEU    75      47.457  79.513  19.704  1.00 82.10           N  
ATOM   1991  CA  LEU    75      46.938  78.237  20.154  1.00 81.49           C  
ATOM   1992  C   LEU    75      47.412  77.951  21.572  1.00 81.22           C  
ATOM   1993  O   LEU    75      48.610  77.992  21.869  1.00 81.01           O  
ATOM   1994  CB  LEU    75      47.382  77.129  19.198  1.00 81.47           C  
ATOM   1995  CG  LEU    75      47.316  75.695  19.705  1.00 80.81           C  
ATOM   1996  CD1 LEU    75      45.955  75.124  19.430  1.00 80.85           C  
ATOM   1997  CD2 LEU    75      48.374  74.879  19.016  1.00 80.38           C  
ATOM   1998  N   ILE    76      46.456  77.661  22.444  1.00 80.63           N  
ATOM   1999  CA  ILE    76      46.765  77.385  23.834  1.00 79.97           C  
ATOM   2000  C   ILE    76      46.554  75.911  24.133  1.00 79.25           C  
ATOM   2001  O   ILE    76      45.423  75.417  24.188  1.00 79.06           O  
ATOM   2002  CB  ILE    76      45.952  78.278  24.785  1.00 80.00           C  
ATOM   2003  CG1 ILE    76      46.060  79.741  24.346  1.00 80.18           C  
ATOM   2004  CG2 ILE    76      46.436  78.113  26.225  1.00 80.49           C  
ATOM   2005  CD1 ILE    76      45.212  80.711  25.164  1.00 80.47           C  
ATOM   2006  N   ILE    77      47.676  75.223  24.300  1.00 78.70           N  
ATOM   2007  CA  ILE    77      47.728  73.816  24.669  1.00 78.25           C  
ATOM   2008  C   ILE    77      47.348  73.636  26.137  1.00 77.99           C  
ATOM   2009  O   ILE    77      47.729  74.449  26.983  1.00 77.85           O  
ATOM   2010  CB  ILE    77      49.159  73.254  24.395  1.00 78.34           C  
ATOM   2011  CG1 ILE    77      49.362  72.938  22.905  1.00 78.12           C  
ATOM   2012  CG2 ILE    77      49.490  72.045  25.269  1.00 78.58           C  
ATOM   2013  CD1 ILE    77      48.130  72.369  22.181  1.00 78.12           C  
ATOM   2014  N   PRO    78      46.579  72.580  26.441  1.00 77.98           N  
ATOM   2015  CA  PRO    78      46.216  72.257  27.820  1.00 78.03           C  
ATOM   2016  C   PRO    78      47.234  71.368  28.534  1.00 77.93           C  
ATOM   2017  O   PRO    78      47.503  71.584  29.707  1.00 77.64           O  
ATOM   2018  CB  PRO    78      44.885  71.526  27.661  1.00 78.05           C  
ATOM   2019  CG  PRO    78      44.986  70.835  26.343  1.00 78.02           C  
ATOM   2020  CD  PRO    78      45.967  71.637  25.486  1.00 78.23           C  
ATOM   2021  N   SER    79      47.770  70.367  27.835  1.00 78.42           N  
ATOM   2022  CA  SER    79      48.829  69.499  28.378  1.00 78.87           C  
ATOM   2023  C   SER    79      49.870  69.176  27.323  1.00 79.25           C  
ATOM   2024  O   SER    79      49.586  69.185  26.129  1.00 79.38           O  
ATOM   2025  CB  SER    79      48.268  68.194  28.963  1.00 78.67           C  
ATOM   2026  OG  SER    79      47.852  68.370  30.302  1.00 78.28           O  
ATOM   2027  N   LEU    80      51.083  68.906  27.785  1.00 79.95           N  
ATOM   2028  CA  LEU    80      52.169  68.467  26.929  1.00 80.52           C  
ATOM   2029  C   LEU    80      52.079  66.957  26.805  1.00 80.91           C  
ATOM   2030  O   LEU    80      52.534  66.381  25.819  1.00 80.65           O  
ATOM   2031  CB  LEU    80      53.510  68.863  27.557  1.00 80.60           C  
ATOM   2032  N   PHE    81      51.459  66.344  27.817  1.00 81.78           N  
ATOM   2033  CA  PHE    81      51.446  64.895  28.023  1.00 82.60           C  
ATOM   2034  C   PHE    81      50.295  64.154  27.320  1.00 83.52           C  
ATOM   2035  O   PHE    81      50.105  62.945  27.531  1.00 83.41           O  
ATOM   2036  CB  PHE    81      51.424  64.590  29.522  1.00 82.23           C  
ATOM   2037  N   GLU    82      49.535  64.860  26.482  1.00 84.40           N  
ATOM   2038  CA  GLU    82      48.391  64.229  25.857  1.00 85.69           C  
ATOM   2039  C   GLU    82      48.537  63.989  24.344  1.00 86.38           C  
ATOM   2040  O   GLU    82      48.646  64.938  23.555  1.00 86.64           O  
ATOM   2041  CB  GLU    82      47.087  64.947  26.220  1.00 85.68           C  
ATOM   2042  CG  GLU    82      45.826  64.054  26.091  1.00 88.45           C  
ATOM   2043  CD  GLU    82      45.926  62.697  26.857  1.00 91.76           C  
ATOM   2044  OE1 GLU    82      46.359  61.679  26.239  1.00 91.96           O  
ATOM   2045  OE2 GLU    82      45.563  62.652  28.066  1.00 91.67           O  
ATOM   2046  N   LYS    83      48.543  62.706  23.967  1.00 87.01           N  
ATOM   2047  CA  LYS    83      48.568  62.251  22.569  1.00 87.39           C  
ATOM   2048  C   LYS    83      47.903  63.247  21.619  1.00 87.84           C  
ATOM   2049  O   LYS    83      48.505  63.676  20.634  1.00 87.78           O  
ATOM   2050  CB  LYS    83      47.866  60.886  22.444  1.00 87.25           C  
ATOM   2051  CG  LYS    83      48.729  59.642  22.702  1.00 87.00           C  
ATOM   2052  CD  LYS    83      49.144  59.465  24.169  1.00 86.17           C  
ATOM   2053  CE  LYS    83      49.422  57.996  24.482  1.00 85.98           C  
ATOM   2054  NZ  LYS    83      49.983  57.805  25.857  1.00 86.52           N  
ATOM   2055  N   ALA    84      46.660  63.610  21.939  1.00 88.65           N  
ATOM   2056  CA  ALA    84      45.878  64.570  21.164  1.00 89.16           C  
ATOM   2057  C   ALA    84      46.681  65.819  20.810  1.00 89.74           C  
ATOM   2058  O   ALA    84      46.688  66.230  19.661  1.00 90.35           O  
ATOM   2059  CB  ALA    84      44.584  64.931  21.889  1.00 89.06           C  
ATOM   2060  N   CYS    85      47.389  66.406  21.768  1.00 90.04           N  
ATOM   2061  CA  CYS    85      48.221  67.571  21.454  1.00 90.17           C  
ATOM   2062  C   CYS    85      49.563  67.138  20.901  1.00 89.89           C  
ATOM   2063  O   CYS    85      50.009  67.664  19.885  1.00 90.18           O  
ATOM   2064  CB  CYS    85      48.406  68.444  22.680  1.00 90.12           C  
ATOM   2065  SG  CYS    85      46.881  68.515  23.610  1.00 91.77           S  
ATOM   2066  N   ALA    86      50.201  66.177  21.565  1.00 89.42           N  
ATOM   2067  CA  ALA    86      51.482  65.646  21.112  1.00 88.98           C  
ATOM   2068  C   ALA    86      51.483  65.354  19.609  1.00 88.68           C  
ATOM   2069  O   ALA    86      52.378  65.793  18.885  1.00 88.59           O  
ATOM   2070  CB  ALA    86      51.845  64.392  21.899  1.00 89.30           C  
ATOM   2071  N   HIS    87      50.464  64.646  19.131  1.00 88.21           N  
ATOM   2072  CA  HIS    87      50.435  64.242  17.727  1.00 87.79           C  
ATOM   2073  C   HIS    87      49.810  65.308  16.818  1.00 87.04           C  
ATOM   2074  O   HIS    87      50.122  65.385  15.633  1.00 87.02           O  
ATOM   2075  CB  HIS    87      49.774  62.874  17.581  1.00 87.92           C  
ATOM   2076  CG  HIS    87      50.509  61.774  18.292  1.00 89.43           C  
ATOM   2077  ND1 HIS    87      50.432  61.583  19.659  1.00 90.36           N  
ATOM   2078  CD2 HIS    87      51.346  60.813  17.829  1.00 90.29           C  
ATOM   2079  CE1 HIS    87      51.179  60.549  20.005  1.00 89.29           C  
ATOM   2080  NE2 HIS    87      51.743  60.064  18.914  1.00 90.44           N  
ATOM   2081  N   PHE    88      48.961  66.144  17.401  1.00 86.05           N  
ATOM   2082  CA  PHE    88      48.298  67.229  16.695  1.00 85.20           C  
ATOM   2083  C   PHE    88      49.260  68.361  16.278  1.00 84.88           C  
ATOM   2084  O   PHE    88      49.353  68.703  15.094  1.00 85.42           O  
ATOM   2085  CB  PHE    88      47.192  67.736  17.603  1.00 85.13           C  
ATOM   2086  CG  PHE    88      46.521  68.975  17.141  1.00 84.81           C  
ATOM   2087  CD1 PHE    88      45.364  68.902  16.378  1.00 85.76           C  
ATOM   2088  CD2 PHE    88      46.995  70.216  17.520  1.00 84.06           C  
ATOM   2089  CE1 PHE    88      44.713  70.059  15.949  1.00 85.65           C  
ATOM   2090  CE2 PHE    88      46.353  71.372  17.105  1.00 85.29           C  
ATOM   2091  CZ  PHE    88      45.207  71.293  16.313  1.00 85.42           C  
ATOM   2092  N   LEU    89      49.983  68.921  17.242  1.00 84.05           N  
ATOM   2093  CA  LEU    89      50.886  70.068  17.019  1.00 83.60           C  
ATOM   2094  C   LEU    89      51.788  70.137  15.761  1.00 83.37           C  
ATOM   2095  O   LEU    89      51.823  71.174  15.101  1.00 82.95           O  
ATOM   2096  CB  LEU    89      51.751  70.304  18.263  1.00 83.53           C  
ATOM   2097  CG  LEU    89      51.536  71.596  19.044  1.00 83.15           C  
ATOM   2098  CD1 LEU    89      52.428  72.696  18.523  1.00 83.68           C  
ATOM   2099  CD2 LEU    89      50.089  72.024  18.990  1.00 82.82           C  
ATOM   2100  N   PRO    90      52.539  69.060  15.441  1.00 83.25           N  
ATOM   2101  CA  PRO    90      53.534  69.246  14.386  1.00 83.05           C  
ATOM   2102  C   PRO    90      52.955  69.281  12.965  1.00 82.81           C  
ATOM   2103  O   PRO    90      53.599  69.821  12.060  1.00 82.76           O  
ATOM   2104  CB  PRO    90      54.493  68.051  14.564  1.00 82.87           C  
ATOM   2105  CG  PRO    90      54.005  67.293  15.736  1.00 83.15           C  
ATOM   2106  CD  PRO    90      52.570  67.680  15.954  1.00 83.48           C  
ATOM   2107  N   SER    91      51.767  68.718  12.763  1.00 82.38           N  
ATOM   2108  CA  SER    91      51.143  68.802  11.448  1.00 81.93           C  
ATOM   2109  C   SER    91      50.214  70.003  11.407  1.00 81.59           C  
ATOM   2110  O   SER    91      49.813  70.450  10.336  1.00 81.40           O  
ATOM   2111  CB  SER    91      50.416  67.504  11.079  1.00 82.17           C  
ATOM   2112  OG  SER    91      49.149  67.398  11.700  1.00 82.10           O  
ATOM   2113  N   PHE    92      49.876  70.513  12.588  1.00 81.10           N  
ATOM   2114  CA  PHE    92      49.159  71.767  12.688  1.00 80.93           C  
ATOM   2115  C   PHE    92      50.138  72.901  12.470  1.00 81.32           C  
ATOM   2116  O   PHE    92      49.748  73.982  12.055  1.00 81.63           O  
ATOM   2117  CB  PHE    92      48.487  71.906  14.052  1.00 80.67           C  
ATOM   2118  CG  PHE    92      47.610  73.130  14.180  1.00 80.49           C  
ATOM   2119  CD1 PHE    92      46.341  73.164  13.612  1.00 80.67           C  
ATOM   2120  CD2 PHE    92      48.049  74.248  14.871  1.00 80.65           C  
ATOM   2121  CE1 PHE    92      45.530  74.288  13.731  1.00 79.47           C  
ATOM   2122  CE2 PHE    92      47.240  75.379  14.988  1.00 79.58           C  
ATOM   2123  CZ  PHE    92      45.983  75.394  14.416  1.00 78.92           C  
ATOM   2124  N   GLN    93      51.413  72.659  12.764  1.00 81.80           N  
ATOM   2125  CA  GLN    93      52.452  73.626  12.450  1.00 82.18           C  
ATOM   2126  C   GLN    93      52.701  73.603  10.948  1.00 82.40           C  
ATOM   2127  O   GLN    93      52.641  74.658  10.308  1.00 82.79           O  
ATOM   2128  CB  GLN    93      53.746  73.361  13.232  1.00 82.30           C  
ATOM   2129  CG  GLN    93      54.901  74.348  12.946  1.00 82.85           C  
ATOM   2130  CD  GLN    93      54.952  75.553  13.894  1.00 84.06           C  
ATOM   2131  OE1 GLN    93      55.199  75.412  15.100  1.00 84.93           O  
ATOM   2132  NE2 GLN    93      54.759  76.746  13.341  1.00 83.84           N  
ATOM   2133  N   GLN    94      52.952  72.412  10.388  1.00 82.32           N  
ATOM   2134  CA  GLN    94      53.298  72.272   8.950  1.00 82.26           C  
ATOM   2135  C   GLN    94      52.285  72.961   8.053  1.00 81.40           C  
ATOM   2136  O   GLN    94      52.627  73.864   7.285  1.00 81.12           O  
ATOM   2137  CB  GLN    94      53.399  70.801   8.521  1.00 82.33           C  
ATOM   2138  CG  GLN    94      54.645  70.039   8.991  1.00 82.94           C  
ATOM   2139  CD  GLN    94      54.467  68.511   8.907  1.00 83.39           C  
ATOM   2140  OE1 GLN    94      53.375  67.968   9.184  1.00 84.98           O  
ATOM   2141  NE2 GLN    94      55.540  67.815   8.532  1.00 83.49           N  
ATOM   2142  N   ALA    95      51.035  72.530   8.182  1.00 80.74           N  
ATOM   2143  CA  ALA    95      49.950  73.000   7.331  1.00 80.28           C  
ATOM   2144  C   ALA    95      49.831  74.514   7.392  1.00 79.73           C  
ATOM   2145  O   ALA    95      49.824  75.193   6.372  1.00 79.34           O  
ATOM   2146  CB  ALA    95      48.655  72.348   7.741  1.00 80.26           C  
ATOM   2147  N   LEU    96      49.761  75.025   8.612  1.00 79.10           N  
ATOM   2148  CA  LEU    96      49.730  76.452   8.869  1.00 78.60           C  
ATOM   2149  C   LEU    96      50.927  77.196   8.233  1.00 78.27           C  
ATOM   2150  O   LEU    96      50.807  78.337   7.773  1.00 77.92           O  
ATOM   2151  CB  LEU    96      49.723  76.631  10.386  1.00 78.42           C  
ATOM   2152  CG  LEU    96      49.111  77.866  11.030  1.00 78.09           C  
ATOM   2153  CD1 LEU    96      48.036  78.478  10.159  1.00 77.95           C  
ATOM   2154  CD2 LEU    96      48.558  77.469  12.379  1.00 77.13           C  
ATOM   2155  N   ASN    97      52.076  76.527   8.217  1.00 77.88           N  
ATOM   2156  CA  ASN    97      53.311  77.119   7.753  1.00 77.73           C  
ATOM   2157  C   ASN    97      53.400  77.172   6.246  1.00 77.39           C  
ATOM   2158  O   ASN    97      54.012  78.082   5.694  1.00 77.37           O  
ATOM   2159  CB  ASN    97      54.512  76.366   8.319  1.00 77.92           C  
ATOM   2160  CG  ASN    97      54.996  76.943   9.635  1.00 78.53           C  
ATOM   2161  OD1 ASN    97      55.805  76.323  10.329  1.00 79.28           O  
ATOM   2162  ND2 ASN    97      54.512  78.137   9.985  1.00 78.73           N  
ATOM   2163  N   LYS    98      52.801  76.187   5.583  1.00 76.93           N  
ATOM   2164  CA  LYS    98      52.710  76.196   4.124  1.00 76.24           C  
ATOM   2165  C   LYS    98      51.789  77.323   3.664  1.00 76.03           C  
ATOM   2166  O   LYS    98      51.972  77.874   2.579  1.00 76.19           O  
ATOM   2167  CB  LYS    98      52.234  74.840   3.588  1.00 76.26           C  
ATOM   2168  CG  LYS    98      53.328  73.774   3.541  1.00 75.92           C  
ATOM   2169  CD  LYS    98      52.787  72.358   3.344  1.00 75.87           C  
ATOM   2170  CE  LYS    98      52.095  71.855   4.606  1.00 76.31           C  
ATOM   2171  NZ  LYS    98      52.580  70.522   5.076  1.00 76.48           N  
ATOM   2172  N   ALA    99      50.811  77.662   4.502  1.00 75.67           N  
ATOM   2173  CA  ALA    99      49.934  78.804   4.269  1.00 75.44           C  
ATOM   2174  C   ALA    99      50.624  80.111   4.660  1.00 75.42           C  
ATOM   2175  O   ALA    99      50.207  81.192   4.233  1.00 75.32           O  
ATOM   2176  CB  ALA    99      48.633  78.641   5.030  1.00 75.42           C  
ATOM   2177  N   GLY   100      51.670  80.003   5.479  1.00 75.27           N  
ATOM   2178  CA  GLY   100      52.513  81.147   5.822  1.00 74.98           C  
ATOM   2179  C   GLY   100      52.128  81.881   7.093  1.00 74.87           C  
ATOM   2180  O   GLY   100      52.148  83.114   7.126  1.00 74.67           O  
ATOM   2181  N   TYR   101      51.781  81.129   8.138  1.00 74.73           N  
ATOM   2182  CA  TYR   101      51.436  81.722   9.425  1.00 74.59           C  
ATOM   2183  C   TYR   101      52.349  81.225  10.526  1.00 74.86           C  
ATOM   2184  O   TYR   101      52.516  80.017  10.707  1.00 74.76           O  
ATOM   2185  CB  TYR   101      50.001  81.396   9.796  1.00 74.36           C  
ATOM   2186  CG  TYR   101      48.964  82.095   8.967  1.00 73.95           C  
ATOM   2187  CD1 TYR   101      48.368  83.266   9.417  1.00 73.86           C  
ATOM   2188  CD2 TYR   101      48.559  81.575   7.737  1.00 73.74           C  
ATOM   2189  CE1 TYR   101      47.401  83.915   8.658  1.00 74.17           C  
ATOM   2190  CE2 TYR   101      47.593  82.214   6.969  1.00 73.77           C  
ATOM   2191  CZ  TYR   101      47.020  83.385   7.434  1.00 74.11           C  
ATOM   2192  OH  TYR   101      46.066  84.031   6.679  1.00 74.13           O  
ATOM   2193  N   GLN   102      52.940  82.166  11.258  1.00 75.23           N  
ATOM   2194  CA  GLN   102      53.738  81.844  12.441  1.00 75.47           C  
ATOM   2195  C   GLN   102      52.784  81.400  13.541  1.00 75.57           C  
ATOM   2196  O   GLN   102      51.637  81.854  13.593  1.00 75.49           O  
ATOM   2197  CB  GLN   102      54.579  83.049  12.885  1.00 75.36           C  
ATOM   2198  N   LEU   103      53.251  80.505  14.404  1.00 75.93           N  
ATOM   2199  CA  LEU   103      52.373  79.886  15.404  1.00 76.44           C  
ATOM   2200  C   LEU   103      52.726  80.233  16.848  1.00 76.58           C  
ATOM   2201  O   LEU   103      53.607  79.619  17.452  1.00 76.58           O  
ATOM   2202  CB  LEU   103      52.312  78.370  15.200  1.00 76.25           C  
ATOM   2203  CG  LEU   103      51.753  77.551  16.354  1.00 76.96           C  
ATOM   2204  CD1 LEU   103      50.597  76.658  15.909  1.00 77.99           C  
ATOM   2205  CD2 LEU   103      52.879  76.743  16.987  1.00 78.03           C  
ATOM   2206  N   LEU   104      52.028  81.232  17.382  1.00 76.98           N  
ATOM   2207  CA  LEU   104      52.191  81.659  18.772  1.00 77.25           C  
ATOM   2208  C   LEU   104      51.404  80.720  19.685  1.00 77.34           C  
ATOM   2209  O   LEU   104      50.200  80.545  19.496  1.00 77.33           O  
ATOM   2210  CB  LEU   104      51.702  83.104  18.937  1.00 77.19           C  
ATOM   2211  N   LEU   105      52.068  80.094  20.655  1.00 77.63           N  
ATOM   2212  CA  LEU   105      51.348  79.161  21.538  1.00 78.04           C  
ATOM   2213  C   LEU   105      51.460  79.438  23.026  1.00 78.18           C  
ATOM   2214  O   LEU   105      51.963  80.487  23.423  1.00 78.14           O  
ATOM   2215  CB  LEU   105      51.617  77.676  21.209  1.00 78.03           C  
ATOM   2216  CG  LEU   105      52.910  76.947  21.532  1.00 77.24           C  
ATOM   2217  CD1 LEU   105      52.633  75.462  21.463  1.00 75.82           C  
ATOM   2218  CD2 LEU   105      53.979  77.343  20.534  1.00 76.89           C  
ATOM   2219  N   GLY   106      50.943  78.515  23.835  1.00 78.44           N  
ATOM   2220  CA  GLY   106      50.848  78.730  25.270  1.00 78.68           C  
ATOM   2221  C   GLY   106      50.420  77.497  26.020  1.00 78.85           C  
ATOM   2222  O   GLY   106      49.593  76.726  25.549  1.00 78.75           O  
ATOM   2223  N   TYR   107      51.000  77.325  27.197  1.00 79.29           N  
ATOM   2224  CA  TYR   107      50.712  76.199  28.044  1.00 80.09           C  
ATOM   2225  C   TYR   107      49.837  76.638  29.199  1.00 80.64           C  
ATOM   2226  O   TYR   107      50.132  77.624  29.869  1.00 80.55           O  
ATOM   2227  CB  TYR   107      52.011  75.670  28.607  1.00 80.24           C  
ATOM   2228  CG  TYR   107      51.937  74.259  29.117  1.00 80.88           C  
ATOM   2229  CD1 TYR   107      52.073  73.185  28.233  1.00 81.29           C  
ATOM   2230  CD2 TYR   107      51.759  73.986  30.482  1.00 80.68           C  
ATOM   2231  CE1 TYR   107      52.038  71.876  28.678  1.00 81.13           C  
ATOM   2232  CE2 TYR   107      51.710  72.665  30.947  1.00 80.59           C  
ATOM   2233  CZ  TYR   107      51.853  71.618  30.027  1.00 81.06           C  
ATOM   2234  OH  TYR   107      51.807  70.303  30.423  1.00 81.11           O  
ATOM   2235  N   SER   108      48.760  75.897  29.434  1.00 81.48           N  
ATOM   2236  CA  SER   108      47.944  76.081  30.631  1.00 81.83           C  
ATOM   2237  C   SER   108      47.770  74.734  31.295  1.00 82.04           C  
ATOM   2238  O   SER   108      47.041  73.887  30.786  1.00 81.98           O  
ATOM   2239  CB  SER   108      46.568  76.648  30.276  1.00 82.01           C  
ATOM   2240  OG  SER   108      45.611  75.611  30.094  1.00 81.96           O  
ATOM   2241  N   ASP   109      48.453  74.528  32.414  1.00 82.52           N  
ATOM   2242  CA  ASP   109      48.228  73.356  33.248  1.00 83.03           C  
ATOM   2243  C   ASP   109      46.733  73.171  33.403  1.00 83.40           C  
ATOM   2244  O   ASP   109      46.158  73.614  34.397  1.00 83.57           O  
ATOM   2245  CB  ASP   109      48.850  73.565  34.632  1.00 83.08           C  
ATOM   2246  CG  ASP   109      50.091  72.736  34.852  1.00 83.07           C  
ATOM   2247  OD1 ASP   109      50.689  72.870  35.938  1.00 82.19           O  
ATOM   2248  OD2 ASP   109      50.461  71.946  33.956  1.00 84.02           O  
ATOM   2249  N   TYR   110      46.099  72.556  32.406  1.00 83.90           N  
ATOM   2250  CA  TYR   110      44.644  72.418  32.380  1.00 84.39           C  
ATOM   2251  C   TYR   110      43.954  73.571  33.141  1.00 84.01           C  
ATOM   2252  O   TYR   110      43.148  73.323  34.038  1.00 84.11           O  
ATOM   2253  CB  TYR   110      44.256  71.062  32.990  1.00 85.46           C  
ATOM   2254  CG  TYR   110      44.167  69.892  32.028  1.00 86.39           C  
ATOM   2255  CD1 TYR   110      43.451  68.731  32.377  1.00 88.11           C  
ATOM   2256  CD2 TYR   110      44.775  69.942  30.778  1.00 86.99           C  
ATOM   2257  CE1 TYR   110      43.356  67.644  31.494  1.00 89.23           C  
ATOM   2258  CE2 TYR   110      44.683  68.878  29.880  1.00 88.26           C  
ATOM   2259  CZ  TYR   110      43.980  67.730  30.234  1.00 88.95           C  
ATOM   2260  OH  TYR   110      43.910  66.682  29.326  1.00 88.28           O  
ATOM   2261  N   SER   111      44.287  74.821  32.809  1.00 83.45           N  
ATOM   2262  CA  SER   111      43.785  75.969  33.578  1.00 82.93           C  
ATOM   2263  C   SER   111      42.975  76.969  32.771  1.00 82.79           C  
ATOM   2264  O   SER   111      43.508  77.675  31.914  1.00 82.84           O  
ATOM   2265  CB  SER   111      44.920  76.701  34.294  1.00 82.92           C  
ATOM   2266  OG  SER   111      44.437  77.893  34.896  1.00 82.27           O  
ATOM   2267  N   ILE   112      41.687  77.043  33.073  1.00 82.55           N  
ATOM   2268  CA  ILE   112      40.819  78.039  32.466  1.00 82.51           C  
ATOM   2269  C   ILE   112      41.275  79.459  32.837  1.00 82.56           C  
ATOM   2270  O   ILE   112      41.142  80.388  32.036  1.00 82.61           O  
ATOM   2271  CB  ILE   112      39.344  77.823  32.868  1.00 82.53           C  
ATOM   2272  CG1 ILE   112      39.191  77.823  34.395  1.00 82.91           C  
ATOM   2273  CG2 ILE   112      38.812  76.516  32.271  1.00 82.32           C  
ATOM   2274  CD1 ILE   112      37.809  78.227  34.891  1.00 83.59           C  
ATOM   2275  N   GLU   113      41.827  79.607  34.045  1.00 82.47           N  
ATOM   2276  CA  GLU   113      42.247  80.907  34.577  1.00 82.23           C  
ATOM   2277  C   GLU   113      43.539  81.422  33.924  1.00 82.15           C  
ATOM   2278  O   GLU   113      43.615  82.599  33.536  1.00 82.07           O  
ATOM   2279  CB  GLU   113      42.389  80.847  36.106  1.00 82.12           C  
ATOM   2280  N   GLN   114      44.543  80.545  33.808  1.00 81.92           N  
ATOM   2281  CA  GLN   114      45.823  80.892  33.175  1.00 81.67           C  
ATOM   2282  C   GLN   114      45.618  81.159  31.692  1.00 81.48           C  
ATOM   2283  O   GLN   114      46.235  82.059  31.127  1.00 81.36           O  
ATOM   2284  CB  GLN   114      46.866  79.788  33.376  1.00 81.69           C  
ATOM   2285  N   GLU   115      44.738  80.365  31.084  1.00 81.35           N  
ATOM   2286  CA  GLU   115      44.268  80.560  29.713  1.00 81.20           C  
ATOM   2287  C   GLU   115      43.864  82.013  29.439  1.00 81.00           C  
ATOM   2288  O   GLU   115      44.206  82.570  28.396  1.00 80.85           O  
ATOM   2289  CB  GLU   115      43.085  79.635  29.455  1.00 81.14           C  
ATOM   2290  CG  GLU   115      42.639  79.574  28.018  1.00 81.89           C  
ATOM   2291  CD  GLU   115      41.362  78.782  27.854  1.00 83.45           C  
ATOM   2292  OE1 GLU   115      40.333  79.180  28.452  1.00 83.74           O  
ATOM   2293  OE2 GLU   115      41.390  77.763  27.123  1.00 84.55           O  
ATOM   2294  N   GLU   116      43.127  82.605  30.379  1.00 80.81           N  
ATOM   2295  CA  GLU   116      42.815  84.031  30.367  1.00 80.68           C  
ATOM   2296  C   GLU   116      44.074  84.899  30.385  1.00 80.55           C  
ATOM   2297  O   GLU   116      44.409  85.539  29.376  1.00 80.38           O  
ATOM   2298  CB  GLU   116      41.961  84.387  31.577  1.00 80.76           C  
ATOM   2299  CG  GLU   116      40.498  84.522  31.299  1.00 80.66           C  
ATOM   2300  CD  GLU   116      39.763  85.078  32.487  1.00 80.62           C  
ATOM   2301  OE1 GLU   116      40.232  86.086  33.063  1.00 80.57           O  
ATOM   2302  OE2 GLU   116      38.713  84.513  32.843  1.00 80.61           O  
ATOM   2303  N   LYS   117      44.760  84.921  31.535  1.00 80.26           N  
ATOM   2304  CA  LYS   117      46.010  85.668  31.687  1.00 80.03           C  
ATOM   2305  C   LYS   117      46.824  85.614  30.377  1.00 80.00           C  
ATOM   2306  O   LYS   117      47.229  86.658  29.843  1.00 80.11           O  
ATOM   2307  CB  LYS   117      46.819  85.142  32.880  1.00 79.64           C  
ATOM   2308  N   LEU   118      47.003  84.397  29.849  1.00 79.65           N  
ATOM   2309  CA  LEU   118      47.718  84.159  28.591  1.00 79.10           C  
ATOM   2310  C   LEU   118      46.980  84.693  27.355  1.00 78.74           C  
ATOM   2311  O   LEU   118      47.507  85.553  26.652  1.00 78.73           O  
ATOM   2312  CB  LEU   118      48.060  82.670  28.427  1.00 79.06           C  
ATOM   2313  N   LEU   119      45.771  84.197  27.095  1.00 78.31           N  
ATOM   2314  CA  LEU   119      45.033  84.592  25.892  1.00 78.10           C  
ATOM   2315  C   LEU   119      45.044  86.103  25.727  1.00 77.97           C  
ATOM   2316  O   LEU   119      45.298  86.614  24.631  1.00 77.79           O  
ATOM   2317  CB  LEU   119      43.591  84.065  25.911  1.00 78.00           C  
ATOM   2318  N   SER   120      44.795  86.803  26.835  1.00 77.94           N  
ATOM   2319  CA  SER   120      44.726  88.258  26.855  1.00 77.90           C  
ATOM   2320  C   SER   120      45.905  88.840  26.096  1.00 77.85           C  
ATOM   2321  O   SER   120      45.718  89.517  25.084  1.00 77.87           O  
ATOM   2322  CB  SER   120      44.698  88.782  28.294  1.00 77.89           C  
ATOM   2323  N   THR   121      47.111  88.533  26.575  1.00 77.76           N  
ATOM   2324  CA  THR   121      48.355  88.997  25.963  1.00 77.75           C  
ATOM   2325  C   THR   121      48.344  88.758  24.452  1.00 77.54           C  
ATOM   2326  O   THR   121      48.592  89.683  23.670  1.00 77.62           O  
ATOM   2327  CB  THR   121      49.606  88.298  26.579  1.00 77.90           C  
ATOM   2328  OG1 THR   121      49.306  87.811  27.895  1.00 78.26           O  
ATOM   2329  CG2 THR   121      50.802  89.258  26.637  1.00 77.53           C  
ATOM   2330  N   PHE   122      48.038  87.522  24.055  1.00 77.21           N  
ATOM   2331  CA  PHE   122      48.031  87.136  22.645  1.00 77.00           C  
ATOM   2332  C   PHE   122      47.154  88.080  21.826  1.00 76.92           C  
ATOM   2333  O   PHE   122      47.615  88.711  20.869  1.00 76.53           O  
ATOM   2334  CB  PHE   122      47.543  85.693  22.475  1.00 76.79           C  
ATOM   2335  CG  PHE   122      48.515  84.644  22.962  1.00 76.82           C  
ATOM   2336  CD1 PHE   122      49.739  84.446  22.324  1.00 77.17           C  
ATOM   2337  CD2 PHE   122      48.191  83.827  24.042  1.00 76.21           C  
ATOM   2338  CE1 PHE   122      50.633  83.461  22.776  1.00 76.99           C  
ATOM   2339  CE2 PHE   122      49.069  82.845  24.491  1.00 75.67           C  
ATOM   2340  CZ  PHE   122      50.288  82.663  23.857  1.00 76.05           C  
ATOM   2341  N   LEU   123      45.891  88.173  22.230  1.00 76.97           N  
ATOM   2342  CA  LEU   123      44.917  89.018  21.564  1.00 76.96           C  
ATOM   2343  C   LEU   123      45.412  90.465  21.457  1.00 77.02           C  
ATOM   2344  O   LEU   123      45.308  91.083  20.393  1.00 76.98           O  
ATOM   2345  CB  LEU   123      43.571  88.936  22.292  1.00 76.85           C  
ATOM   2346  N   GLU   124      45.981  90.982  22.547  1.00 77.12           N  
ATOM   2347  CA  GLU   124      46.488  92.362  22.601  1.00 77.27           C  
ATOM   2348  C   GLU   124      47.697  92.601  21.687  1.00 77.40           C  
ATOM   2349  O   GLU   124      48.242  93.707  21.643  1.00 77.22           O  
ATOM   2350  CB  GLU   124      46.839  92.748  24.045  1.00 77.16           C  
ATOM   2351  N   SER   125      48.091  91.563  20.949  1.00 77.69           N  
ATOM   2352  CA  SER   125      49.311  91.571  20.143  1.00 77.82           C  
ATOM   2353  C   SER   125      49.043  91.677  18.636  1.00 77.79           C  
ATOM   2354  O   SER   125      49.388  92.679  18.006  1.00 77.81           O  
ATOM   2355  CB  SER   125      50.151  90.325  20.463  1.00 77.81           C  
ATOM   2356  OG  SER   125      51.121  90.078  19.463  1.00 78.12           O  
ATOM   2357  N   ARG   126      48.446  90.631  18.069  1.00 77.84           N  
ATOM   2358  CA  ARG   126      48.179  90.554  16.633  1.00 77.85           C  
ATOM   2359  C   ARG   126      46.932  89.704  16.366  1.00 77.80           C  
ATOM   2360  O   ARG   126      46.707  88.699  17.052  1.00 77.48           O  
ATOM   2361  CB  ARG   126      49.398  89.996  15.879  1.00 77.88           C  
ATOM   2362  N   PRO   127      46.130  90.106  15.357  1.00 77.81           N  
ATOM   2363  CA  PRO   127      44.809  89.524  15.099  1.00 77.75           C  
ATOM   2364  C   PRO   127      44.822  88.030  14.732  1.00 77.71           C  
ATOM   2365  O   PRO   127      44.996  87.175  15.605  1.00 77.50           O  
ATOM   2366  CB  PRO   127      44.268  90.368  13.924  1.00 77.79           C  
ATOM   2367  CG  PRO   127      45.141  91.579  13.850  1.00 77.76           C  
ATOM   2368  CD  PRO   127      46.466  91.162  14.379  1.00 77.80           C  
ATOM   2369  N   ALA   128      44.651  87.750  13.438  1.00 77.80           N  
ATOM   2370  CA  ALA   128      44.354  86.417  12.894  1.00 77.74           C  
ATOM   2371  C   ALA   128      43.229  85.716  13.658  1.00 77.90           C  
ATOM   2372  O   ALA   128      42.241  86.353  14.034  1.00 77.82           O  
ATOM   2373  CB  ALA   128      45.611  85.556  12.807  1.00 77.56           C  
ATOM   2374  N   GLY   129      43.375  84.408  13.865  1.00 78.04           N  
ATOM   2375  CA  GLY   129      42.442  83.637  14.675  1.00 78.06           C  
ATOM   2376  C   GLY   129      43.176  82.886  15.765  1.00 78.22           C  
ATOM   2377  O   GLY   129      44.402  82.801  15.751  1.00 78.35           O  
ATOM   2378  N   VAL   130      42.424  82.335  16.709  1.00 78.36           N  
ATOM   2379  CA  VAL   130      42.996  81.570  17.810  1.00 78.47           C  
ATOM   2380  C   VAL   130      42.282  80.225  17.955  1.00 78.73           C  
ATOM   2381  O   VAL   130      41.078  80.127  17.714  1.00 78.85           O  
ATOM   2382  CB  VAL   130      42.961  82.384  19.136  1.00 78.50           C  
ATOM   2383  CG1 VAL   130      41.597  83.036  19.350  1.00 78.46           C  
ATOM   2384  CG2 VAL   130      43.367  81.531  20.339  1.00 78.02           C  
ATOM   2385  N   VAL   131      43.025  79.191  18.345  1.00 78.91           N  
ATOM   2386  CA  VAL   131      42.456  77.844  18.458  1.00 79.10           C  
ATOM   2387  C   VAL   131      42.680  77.258  19.848  1.00 79.16           C  
ATOM   2388  O   VAL   131      43.788  77.310  20.378  1.00 79.16           O  
ATOM   2389  CB  VAL   131      42.949  76.905  17.316  1.00 79.01           C  
ATOM   2390  CG1 VAL   131      44.387  77.189  16.976  1.00 79.69           C  
ATOM   2391  CG2 VAL   131      42.766  75.446  17.670  1.00 79.09           C  
ATOM   2392  N   LEU   132      41.605  76.717  20.424  1.00 79.37           N  
ATOM   2393  CA  LEU   132      41.578  76.304  21.827  1.00 79.76           C  
ATOM   2394  C   LEU   132      41.049  74.894  22.053  1.00 79.97           C  
ATOM   2395  O   LEU   132      40.119  74.447  21.378  1.00 80.05           O  
ATOM   2396  CB  LEU   132      40.717  77.266  22.644  1.00 79.69           C  
ATOM   2397  CG  LEU   132      41.098  78.741  22.703  1.00 79.74           C  
ATOM   2398  CD1 LEU   132      40.214  79.418  23.725  1.00 80.08           C  
ATOM   2399  CD2 LEU   132      42.565  78.928  23.055  1.00 79.42           C  
ATOM   2400  N   PHE   133      41.633  74.216  23.033  1.00 80.04           N  
ATOM   2401  CA  PHE   133      41.185  72.898  23.429  1.00 80.28           C  
ATOM   2402  C   PHE   133      40.108  73.003  24.494  1.00 80.56           C  
ATOM   2403  O   PHE   133      40.110  73.941  25.293  1.00 80.66           O  
ATOM   2404  CB  PHE   133      42.371  72.102  23.948  1.00 80.49           C  
ATOM   2405  CG  PHE   133      43.274  71.621  22.868  1.00 80.30           C  
ATOM   2406  CD1 PHE   133      43.353  70.268  22.567  1.00 80.61           C  
ATOM   2407  CD2 PHE   133      44.031  72.518  22.128  1.00 81.02           C  
ATOM   2408  CE1 PHE   133      44.188  69.799  21.548  1.00 81.06           C  
ATOM   2409  CE2 PHE   133      44.861  72.067  21.098  1.00 82.01           C  
ATOM   2410  CZ  PHE   133      44.940  70.699  20.811  1.00 81.89           C  
ATOM   2411  N   GLY   134      39.181  72.045  24.491  1.00 80.85           N  
ATOM   2412  CA  GLY   134      38.109  71.982  25.489  1.00 80.82           C  
ATOM   2413  C   GLY   134      37.007  73.003  25.278  1.00 80.96           C  
ATOM   2414  O   GLY   134      37.208  74.041  24.650  1.00 80.88           O  
ATOM   2415  N   SER   135      35.829  72.704  25.807  1.00 81.18           N  
ATOM   2416  CA  SER   135      34.695  73.602  25.680  1.00 81.05           C  
ATOM   2417  C   SER   135      34.586  74.526  26.882  1.00 80.93           C  
ATOM   2418  O   SER   135      34.092  75.645  26.753  1.00 81.16           O  
ATOM   2419  CB  SER   135      33.404  72.809  25.510  1.00 81.09           C  
ATOM   2420  OG  SER   135      32.276  73.635  25.761  1.00 81.64           O  
ATOM   2421  N   GLU   136      35.028  74.052  28.047  1.00 80.75           N  
ATOM   2422  CA  GLU   136      34.955  74.830  29.286  1.00 80.69           C  
ATOM   2423  C   GLU   136      35.961  75.971  29.239  1.00 80.73           C  
ATOM   2424  O   GLU   136      37.146  75.731  29.002  1.00 81.00           O  
ATOM   2425  CB  GLU   136      35.211  73.942  30.506  1.00 80.45           C  
ATOM   2426  N   HIS   137      35.481  77.205  29.433  1.00 80.79           N  
ATOM   2427  CA  HIS   137      36.324  78.419  29.372  1.00 80.69           C  
ATOM   2428  C   HIS   137      35.913  79.509  30.365  1.00 80.60           C  
ATOM   2429  O   HIS   137      35.260  79.225  31.369  1.00 80.58           O  
ATOM   2430  CB  HIS   137      36.395  78.980  27.944  1.00 80.70           C  
ATOM   2431  CG  HIS   137      36.929  78.002  26.947  1.00 80.78           C  
ATOM   2432  ND1 HIS   137      38.248  77.600  26.933  1.00 80.45           N  
ATOM   2433  CD2 HIS   137      36.317  77.320  25.951  1.00 81.04           C  
ATOM   2434  CE1 HIS   137      38.427  76.721  25.963  1.00 81.19           C  
ATOM   2435  NE2 HIS   137      37.269  76.532  25.355  1.00 81.73           N  
ATOM   2436  N   SER   138      36.293  80.752  30.078  1.00 80.51           N  
ATOM   2437  CA  SER   138      36.219  81.824  31.070  1.00 80.52           C  
ATOM   2438  C   SER   138      35.430  83.028  30.571  1.00 80.55           C  
ATOM   2439  O   SER   138      35.549  83.411  29.405  1.00 80.87           O  
ATOM   2440  CB  SER   138      37.632  82.282  31.421  1.00 80.48           C  
ATOM   2441  OG  SER   138      38.611  81.466  30.794  1.00 80.51           O  
ATOM   2442  N   GLN   139      34.647  83.641  31.459  1.00 80.23           N  
ATOM   2443  CA  GLN   139      33.923  84.869  31.127  1.00 79.89           C  
ATOM   2444  C   GLN   139      34.812  85.814  30.321  1.00 79.71           C  
ATOM   2445  O   GLN   139      34.462  86.202  29.210  1.00 79.58           O  
ATOM   2446  CB  GLN   139      33.409  85.563  32.392  1.00 79.92           C  
ATOM   2447  N   ARG   140      35.978  86.145  30.867  1.00 79.60           N  
ATOM   2448  CA  ARG   140      36.902  87.054  30.199  1.00 79.65           C  
ATOM   2449  C   ARG   140      37.416  86.529  28.859  1.00 79.76           C  
ATOM   2450  O   ARG   140      37.629  87.318  27.940  1.00 79.77           O  
ATOM   2451  CB  ARG   140      38.064  87.445  31.114  1.00 79.45           C  
ATOM   2452  N   THR   141      37.620  85.217  28.735  1.00 79.92           N  
ATOM   2453  CA  THR   141      37.982  84.667  27.428  1.00 80.22           C  
ATOM   2454  C   THR   141      36.786  84.818  26.507  1.00 80.34           C  
ATOM   2455  O   THR   141      36.883  85.431  25.446  1.00 80.34           O  
ATOM   2456  CB  THR   141      38.474  83.175  27.447  1.00 80.32           C  
ATOM   2457  OG1 THR   141      37.567  82.350  28.191  1.00 80.43           O  
ATOM   2458  CG2 THR   141      39.886  83.055  28.023  1.00 80.28           C  
ATOM   2459  N   HIS   142      35.648  84.288  26.943  1.00 80.60           N  
ATOM   2460  CA  HIS   142      34.422  84.361  26.172  1.00 81.02           C  
ATOM   2461  C   HIS   142      34.151  85.794  25.730  1.00 81.36           C  
ATOM   2462  O   HIS   142      33.628  86.014  24.637  1.00 81.61           O  
ATOM   2463  CB  HIS   142      33.239  83.820  26.976  1.00 81.02           C  
ATOM   2464  CG  HIS   142      33.238  82.331  27.131  1.00 80.89           C  
ATOM   2465  ND1 HIS   142      33.105  81.471  26.062  1.00 80.95           N  
ATOM   2466  CD2 HIS   142      33.328  81.550  28.234  1.00 80.66           C  
ATOM   2467  CE1 HIS   142      33.129  80.224  26.499  1.00 81.37           C  
ATOM   2468  NE2 HIS   142      33.261  80.244  27.814  1.00 80.89           N  
ATOM   2469  N   GLN   143      34.509  86.760  26.577  1.00 81.50           N  
ATOM   2470  CA  GLN   143      34.430  88.166  26.203  1.00 81.69           C  
ATOM   2471  C   GLN   143      35.481  88.435  25.136  1.00 81.85           C  
ATOM   2472  O   GLN   143      35.164  88.437  23.950  1.00 81.76           O  
ATOM   2473  CB  GLN   143      34.620  89.089  27.413  1.00 81.65           C  
ATOM   2474  N   LEU   144      36.732  88.606  25.562  1.00 82.17           N  
ATOM   2475  CA  LEU   144      37.842  88.930  24.664  1.00 82.38           C  
ATOM   2476  C   LEU   144      37.687  88.287  23.284  1.00 82.63           C  
ATOM   2477  O   LEU   144      37.574  88.994  22.285  1.00 82.58           O  
ATOM   2478  CB  LEU   144      39.185  88.552  25.297  1.00 82.22           C  
ATOM   2479  N   LEU   145      37.643  86.954  23.245  1.00 82.96           N  
ATOM   2480  CA  LEU   145      37.533  86.201  21.992  1.00 83.27           C  
ATOM   2481  C   LEU   145      36.392  86.719  21.103  1.00 83.56           C  
ATOM   2482  O   LEU   145      36.633  87.189  19.984  1.00 83.60           O  
ATOM   2483  CB  LEU   145      37.396  84.692  22.265  1.00 83.02           C  
ATOM   2484  N   GLU   146      35.162  86.654  21.613  1.00 83.94           N  
ATOM   2485  CA  GLU   146      33.975  87.060  20.847  1.00 84.23           C  
ATOM   2486  C   GLU   146      33.827  88.579  20.756  1.00 84.35           C  
ATOM   2487  O   GLU   146      33.075  89.086  19.917  1.00 84.46           O  
ATOM   2488  CB  GLU   146      32.703  86.432  21.430  1.00 84.36           C  
ATOM   2489  N   ALA   147      34.539  89.291  21.629  1.00 84.44           N  
ATOM   2490  CA  ALA   147      34.620  90.749  21.573  1.00 84.44           C  
ATOM   2491  C   ALA   147      35.611  91.162  20.491  1.00 84.47           C  
ATOM   2492  O   ALA   147      35.467  92.221  19.881  1.00 84.50           O  
ATOM   2493  CB  ALA   147      35.032  91.319  22.925  1.00 84.37           C  
ATOM   2494  N   SER   148      36.603  90.307  20.251  1.00 84.47           N  
ATOM   2495  CA  SER   148      37.626  90.534  19.231  1.00 84.47           C  
ATOM   2496  C   SER   148      37.141  90.243  17.803  1.00 84.55           C  
ATOM   2497  O   SER   148      37.855  90.523  16.832  1.00 84.50           O  
ATOM   2498  CB  SER   148      38.865  89.690  19.543  1.00 84.45           C  
ATOM   2499  OG  SER   148      39.876  89.866  18.567  1.00 84.27           O  
ATOM   2500  N   ASN   149      35.937  89.678  17.686  1.00 84.58           N  
ATOM   2501  CA  ASN   149      35.347  89.277  16.398  1.00 84.53           C  
ATOM   2502  C   ASN   149      36.227  88.342  15.548  1.00 84.51           C  
ATOM   2503  O   ASN   149      35.811  87.892  14.476  1.00 84.60           O  
ATOM   2504  CB  ASN   149      34.871  90.493  15.592  1.00 84.46           C  
ATOM   2505  N   THR   150      37.433  88.056  16.043  1.00 84.39           N  
ATOM   2506  CA  THR   150      38.348  87.104  15.413  1.00 84.21           C  
ATOM   2507  C   THR   150      37.834  85.677  15.594  1.00 84.06           C  
ATOM   2508  O   THR   150      37.134  85.396  16.571  1.00 83.91           O  
ATOM   2509  CB  THR   150      39.765  87.199  16.004  1.00 84.22           C  
ATOM   2510  OG1 THR   150      39.697  87.069  17.428  1.00 84.14           O  
ATOM   2511  CG2 THR   150      40.419  88.529  15.633  1.00 84.28           C  
ATOM   2512  N   PRO   151      38.185  84.773  14.657  1.00 84.05           N  
ATOM   2513  CA  PRO   151      37.658  83.399  14.618  1.00 84.01           C  
ATOM   2514  C   PRO   151      38.306  82.435  15.625  1.00 83.83           C  
ATOM   2515  O   PRO   151      39.492  82.568  15.936  1.00 83.74           O  
ATOM   2516  CB  PRO   151      37.958  82.944  13.178  1.00 84.13           C  
ATOM   2517  CG  PRO   151      38.579  84.156  12.469  1.00 84.11           C  
ATOM   2518  CD  PRO   151      39.126  85.015  13.548  1.00 83.98           C  
ATOM   2519  N   VAL   152      37.515  81.470  16.104  1.00 83.61           N  
ATOM   2520  CA  VAL   152      37.924  80.513  17.149  1.00 83.43           C  
ATOM   2521  C   VAL   152      37.639  79.054  16.777  1.00 83.25           C  
ATOM   2522  O   VAL   152      36.544  78.726  16.293  1.00 83.10           O  
ATOM   2523  CB  VAL   152      37.228  80.798  18.522  1.00 83.46           C  
ATOM   2524  CG1 VAL   152      38.055  81.736  19.387  1.00 83.44           C  
ATOM   2525  CG2 VAL   152      35.820  81.347  18.321  1.00 83.44           C  
ATOM   2526  N   LEU   153      38.620  78.184  17.027  1.00 83.03           N  
ATOM   2527  CA  LEU   153      38.447  76.734  16.837  1.00 82.86           C  
ATOM   2528  C   LEU   153      38.654  75.922  18.130  1.00 82.67           C  
ATOM   2529  O   LEU   153      39.779  75.746  18.609  1.00 82.81           O  
ATOM   2530  CB  LEU   153      39.372  76.205  15.728  1.00 82.99           C  
ATOM   2531  CG  LEU   153      39.002  74.945  14.921  1.00 82.76           C  
ATOM   2532  CD1 LEU   153      40.209  74.455  14.142  1.00 82.62           C  
ATOM   2533  CD2 LEU   153      38.473  73.818  15.769  1.00 83.07           C  
ATOM   2534  N   GLU   154      37.561  75.417  18.688  1.00 82.32           N  
ATOM   2535  CA  GLU   154      37.659  74.515  19.822  1.00 81.86           C  
ATOM   2536  C   GLU   154      38.007  73.118  19.332  1.00 81.16           C  
ATOM   2537  O   GLU   154      37.369  72.597  18.425  1.00 81.08           O  
ATOM   2538  CB  GLU   154      36.359  74.531  20.628  1.00 82.04           C  
ATOM   2539  CG  GLU   154      36.303  75.686  21.641  1.00 83.27           C  
ATOM   2540  CD  GLU   154      34.886  76.092  22.052  1.00 84.75           C  
ATOM   2541  OE1 GLU   154      33.964  76.045  21.200  1.00 85.08           O  
ATOM   2542  OE2 GLU   154      34.705  76.488  23.228  1.00 84.61           O  
ATOM   2543  N   ILE   155      39.056  72.530  19.889  1.00 80.58           N  
ATOM   2544  CA  ILE   155      39.269  71.103  19.707  1.00 80.18           C  
ATOM   2545  C   ILE   155      38.451  70.483  20.820  1.00 80.40           C  
ATOM   2546  O   ILE   155      38.919  70.335  21.953  1.00 80.38           O  
ATOM   2547  CB  ILE   155      40.744  70.663  19.801  1.00 80.03           C  
ATOM   2548  CG1 ILE   155      41.675  71.621  19.033  1.00 80.46           C  
ATOM   2549  CG2 ILE   155      40.899  69.223  19.333  1.00 78.46           C  
ATOM   2550  CD1 ILE   155      41.344  71.846  17.532  1.00 80.24           C  
ATOM   2551  N   ALA   156      37.206  70.172  20.480  1.00 80.44           N  
ATOM   2552  CA  ALA   156      36.202  69.778  21.437  1.00 81.04           C  
ATOM   2553  C   ALA   156      35.025  69.126  20.700  1.00 81.37           C  
ATOM   2554  O   ALA   156      34.869  69.328  19.489  1.00 81.22           O  
ATOM   2555  CB  ALA   156      35.742  70.993  22.249  1.00 81.17           C  
ATOM   2556  N   GLU   157      34.222  68.349  21.439  1.00 81.45           N  
ATOM   2557  CA  GLU   157      33.124  67.554  20.877  1.00 81.75           C  
ATOM   2558  C   GLU   157      31.935  68.439  20.608  1.00 81.75           C  
ATOM   2559  O   GLU   157      31.402  68.466  19.504  1.00 81.64           O  
ATOM   2560  CB  GLU   157      32.716  66.434  21.844  1.00 81.93           C  
ATOM   2561  CG  GLU   157      33.872  65.496  22.219  1.00 82.80           C  
ATOM   2562  CD  GLU   157      33.538  64.499  23.323  1.00 81.61           C  
ATOM   2563  OE1 GLU   157      33.578  64.889  24.514  1.00 80.54           O  
ATOM   2564  OE2 GLU   157      33.268  63.323  22.993  1.00 80.74           O  
ATOM   2565  N   LEU   158      31.522  69.148  21.649  1.00 82.07           N  
ATOM   2566  CA  LEU   158      30.516  70.185  21.555  1.00 82.27           C  
ATOM   2567  C   LEU   158      31.252  71.517  21.677  1.00 82.36           C  
ATOM   2568  O   LEU   158      32.365  71.563  22.220  1.00 82.34           O  
ATOM   2569  CB  LEU   158      29.460  70.003  22.657  1.00 82.22           C  
ATOM   2570  CG  LEU   158      29.671  70.449  24.118  1.00 82.26           C  
ATOM   2571  CD1 LEU   158      28.475  69.993  24.982  1.00 81.08           C  
ATOM   2572  CD2 LEU   158      31.000  69.984  24.741  1.00 81.66           C  
ATOM   2573  N   SER   159      30.650  72.588  21.166  1.00 82.50           N  
ATOM   2574  CA  SER   159      31.304  73.896  21.163  1.00 82.81           C  
ATOM   2575  C   SER   159      30.503  74.984  21.881  1.00 82.85           C  
ATOM   2576  O   SER   159      29.341  75.235  21.551  1.00 83.04           O  
ATOM   2577  CB  SER   159      31.614  74.328  19.733  1.00 82.74           C  
ATOM   2578  OG  SER   159      30.426  74.675  19.052  1.00 83.60           O  
ATOM   2579  N   SER   160      31.139  75.630  22.856  1.00 82.93           N  
ATOM   2580  CA  SER   160      30.540  76.749  23.580  1.00 83.14           C  
ATOM   2581  C   SER   160      30.296  77.913  22.625  1.00 83.33           C  
ATOM   2582  O   SER   160      30.729  77.863  21.473  1.00 83.49           O  
ATOM   2583  CB  SER   160      31.447  77.182  24.735  1.00 83.20           C  
ATOM   2584  OG  SER   160      32.739  77.553  24.278  1.00 83.09           O  
ATOM   2585  N   LYS   161      29.606  78.949  23.101  1.00 83.48           N  
ATOM   2586  CA  LYS   161      29.256  80.127  22.288  1.00 83.69           C  
ATOM   2587  C   LYS   161      29.030  79.795  20.800  1.00 83.73           C  
ATOM   2588  O   LYS   161      29.973  79.735  20.005  1.00 83.71           O  
ATOM   2589  CB  LYS   161      30.289  81.246  22.470  1.00 83.65           C  
ATOM   2590  N   ALA   162      27.757  79.599  20.455  1.00 83.80           N  
ATOM   2591  CA  ALA   162      27.294  79.051  19.164  1.00 83.79           C  
ATOM   2592  C   ALA   162      28.199  79.233  17.940  1.00 83.72           C  
ATOM   2593  O   ALA   162      28.488  78.267  17.225  1.00 83.78           O  
ATOM   2594  CB  ALA   162      25.865  79.541  18.857  1.00 83.86           C  
ATOM   2595  N   SER   163      28.641  80.469  17.713  1.00 83.56           N  
ATOM   2596  CA  SER   163      29.419  80.821  16.527  1.00 83.41           C  
ATOM   2597  C   SER   163      30.926  80.549  16.697  1.00 83.37           C  
ATOM   2598  O   SER   163      31.769  81.378  16.337  1.00 83.23           O  
ATOM   2599  CB  SER   163      29.153  82.280  16.145  1.00 83.39           C  
ATOM   2600  OG  SER   163      28.983  82.424  14.745  1.00 83.39           O  
ATOM   2601  N   TYR   164      31.245  79.380  17.250  1.00 83.33           N  
ATOM   2602  CA  TYR   164      32.618  78.893  17.361  1.00 83.28           C  
ATOM   2603  C   TYR   164      32.804  77.750  16.364  1.00 83.07           C  
ATOM   2604  O   TYR   164      31.977  76.830  16.316  1.00 82.87           O  
ATOM   2605  CB  TYR   164      32.881  78.380  18.781  1.00 83.59           C  
ATOM   2606  CG  TYR   164      33.219  79.427  19.834  1.00 83.74           C  
ATOM   2607  CD1 TYR   164      32.826  80.760  19.698  1.00 83.83           C  
ATOM   2608  CD2 TYR   164      33.905  79.063  20.994  1.00 83.60           C  
ATOM   2609  CE1 TYR   164      33.141  81.710  20.678  1.00 84.42           C  
ATOM   2610  CE2 TYR   164      34.217  79.998  21.981  1.00 83.95           C  
ATOM   2611  CZ  TYR   164      33.837  81.318  21.819  1.00 84.30           C  
ATOM   2612  OH  TYR   164      34.151  82.244  22.796  1.00 84.43           O  
ATOM   2613  N   LEU   165      33.870  77.819  15.561  1.00 82.85           N  
ATOM   2614  CA  LEU   165      34.238  76.733  14.631  1.00 82.53           C  
ATOM   2615  C   LEU   165      34.851  75.616  15.466  1.00 82.31           C  
ATOM   2616  O   LEU   165      35.478  75.901  16.485  1.00 82.47           O  
ATOM   2617  CB  LEU   165      35.227  77.225  13.564  1.00 82.25           C  
ATOM   2618  N   ASN   166      34.666  74.355  15.075  1.00 82.01           N  
ATOM   2619  CA  ASN   166      35.080  73.255  15.962  1.00 81.62           C  
ATOM   2620  C   ASN   166      35.370  71.877  15.338  1.00 81.69           C  
ATOM   2621  O   ASN   166      35.004  71.595  14.198  1.00 81.74           O  
ATOM   2622  CB  ASN   166      34.092  73.114  17.135  1.00 81.51           C  
ATOM   2623  CG  ASN   166      33.298  71.840  17.072  1.00 80.00           C  
ATOM   2624  OD1 ASN   166      32.559  71.603  16.127  1.00 79.28           O  
ATOM   2625  ND2 ASN   166      33.468  70.998  18.073  1.00 78.62           N  
ATOM   2626  N   ILE   167      35.996  71.020  16.142  1.00 81.64           N  
ATOM   2627  CA  ILE   167      36.523  69.735  15.714  1.00 81.65           C  
ATOM   2628  C   ILE   167      36.879  68.905  16.970  1.00 81.39           C  
ATOM   2629  O   ILE   167      37.498  69.410  17.908  1.00 81.71           O  
ATOM   2630  CB  ILE   167      37.773  69.954  14.790  1.00 81.82           C  
ATOM   2631  CG1 ILE   167      37.985  68.794  13.799  1.00 82.60           C  
ATOM   2632  CG2 ILE   167      39.029  70.295  15.602  1.00 82.00           C  
ATOM   2633  CD1 ILE   167      38.673  67.539  14.354  1.00 83.11           C  
ATOM   2634  N   GLY   168      36.476  67.640  16.998  1.00 80.83           N  
ATOM   2635  CA  GLY   168      36.765  66.771  18.131  1.00 79.92           C  
ATOM   2636  C   GLY   168      36.180  65.402  17.885  1.00 79.40           C  
ATOM   2637  O   GLY   168      35.303  65.255  17.047  1.00 79.16           O  
ATOM   2638  N   VAL   169      36.665  64.389  18.597  1.00 78.88           N  
ATOM   2639  CA  VAL   169      36.100  63.066  18.419  1.00 78.43           C  
ATOM   2640  C   VAL   169      34.942  62.925  19.388  1.00 78.66           C  
ATOM   2641  O   VAL   169      34.799  63.718  20.316  1.00 78.78           O  
ATOM   2642  CB  VAL   169      37.128  61.905  18.583  1.00 78.27           C  
ATOM   2643  CG1 VAL   169      38.461  62.270  17.975  1.00 78.12           C  
ATOM   2644  CG2 VAL   169      37.299  61.505  20.030  1.00 77.88           C  
ATOM   2645  N   ASP   170      34.101  61.931  19.138  1.00 78.48           N  
ATOM   2646  CA  ASP   170      33.042  61.579  20.037  1.00 78.11           C  
ATOM   2647  C   ASP   170      33.518  60.388  20.856  1.00 77.65           C  
ATOM   2648  O   ASP   170      33.521  59.244  20.406  1.00 77.39           O  
ATOM   2649  CB  ASP   170      31.768  61.276  19.243  1.00 78.30           C  
ATOM   2650  CG  ASP   170      30.722  60.532  20.052  1.00 79.56           C  
ATOM   2651  OD1 ASP   170      29.614  60.382  19.526  1.00 81.69           O  
ATOM   2652  OD2 ASP   170      30.989  60.075  21.191  1.00 82.57           O  
ATOM   2653  N   HIS   171      33.900  60.671  22.088  1.00 77.71           N  
ATOM   2654  CA  HIS   171      34.503  59.665  22.945  1.00 77.55           C  
ATOM   2655  C   HIS   171      33.497  58.628  23.414  1.00 77.58           C  
ATOM   2656  O   HIS   171      33.864  57.468  23.686  1.00 77.98           O  
ATOM   2657  CB  HIS   171      35.176  60.348  24.107  1.00 77.09           C  
ATOM   2658  CG  HIS   171      36.363  61.157  23.705  1.00 78.95           C  
ATOM   2659  ND1 HIS   171      37.615  60.603  23.516  1.00 80.05           N  
ATOM   2660  CD2 HIS   171      36.493  62.480  23.441  1.00 80.65           C  
ATOM   2661  CE1 HIS   171      38.469  61.551  23.177  1.00 80.66           C  
ATOM   2662  NE2 HIS   171      37.814  62.700  23.124  1.00 81.52           N  
ATOM   2663  N   PHE   172      32.233  59.040  23.473  1.00 77.03           N  
ATOM   2664  CA  PHE   172      31.160  58.159  23.895  1.00 76.98           C  
ATOM   2665  C   PHE   172      31.113  56.943  22.991  1.00 77.19           C  
ATOM   2666  O   PHE   172      31.136  55.817  23.492  1.00 77.09           O  
ATOM   2667  CB  PHE   172      29.836  58.921  23.864  1.00 77.18           C  
ATOM   2668  CG  PHE   172      28.661  58.154  24.354  1.00 76.49           C  
ATOM   2669  CD1 PHE   172      28.342  58.138  25.697  1.00 78.32           C  
ATOM   2670  CD2 PHE   172      27.829  57.495  23.466  1.00 76.70           C  
ATOM   2671  CE1 PHE   172      27.210  57.435  26.156  1.00 78.10           C  
ATOM   2672  CE2 PHE   172      26.694  56.800  23.910  1.00 76.12           C  
ATOM   2673  CZ  PHE   172      26.388  56.775  25.250  1.00 76.31           C  
ATOM   2674  N   GLU   173      31.079  57.163  21.668  1.00 76.95           N  
ATOM   2675  CA  GLU   173      31.035  56.046  20.734  1.00 77.23           C  
ATOM   2676  C   GLU   173      32.259  55.176  20.964  1.00 77.15           C  
ATOM   2677  O   GLU   173      32.178  53.953  20.993  1.00 76.58           O  
ATOM   2678  CB  GLU   173      30.930  56.511  19.272  1.00 77.36           C  
ATOM   2679  CG  GLU   173      30.816  55.359  18.226  1.00 80.90           C  
ATOM   2680  CD  GLU   173      29.582  54.416  18.451  1.00 88.97           C  
ATOM   2681  OE1 GLU   173      29.768  53.259  18.935  1.00 93.40           O  
ATOM   2682  OE2 GLU   173      28.422  54.817  18.160  1.00 88.23           O  
ATOM   2683  N   VAL   174      33.398  55.819  21.160  1.00 77.60           N  
ATOM   2684  CA  VAL   174      34.596  55.075  21.387  1.00 78.62           C  
ATOM   2685  C   VAL   174      34.424  54.137  22.569  1.00 79.30           C  
ATOM   2686  O   VAL   174      34.714  52.946  22.431  1.00 80.41           O  
ATOM   2687  CB  VAL   174      35.834  55.961  21.599  1.00 79.19           C  
ATOM   2688  CG1 VAL   174      37.048  55.081  21.906  1.00 77.82           C  
ATOM   2689  CG2 VAL   174      36.097  56.819  20.353  1.00 79.42           C  
ATOM   2690  N   GLY   175      33.961  54.649  23.712  1.00 78.91           N  
ATOM   2691  CA  GLY   175      33.727  53.794  24.878  1.00 78.37           C  
ATOM   2692  C   GLY   175      32.796  52.665  24.490  1.00 78.79           C  
ATOM   2693  O   GLY   175      33.177  51.503  24.459  1.00 78.33           O  
ATOM   2694  N   LYS   176      31.565  53.018  24.146  1.00 79.45           N  
ATOM   2695  CA  LYS   176      30.585  52.048  23.666  1.00 79.96           C  
ATOM   2696  C   LYS   176      31.176  51.022  22.687  1.00 79.37           C  
ATOM   2697  O   LYS   176      31.013  49.829  22.882  1.00 79.42           O  
ATOM   2698  CB  LYS   176      29.397  52.772  23.033  1.00 79.56           C  
ATOM   2699  CG  LYS   176      28.260  51.855  22.659  1.00 81.40           C  
ATOM   2700  CD  LYS   176      26.926  52.606  22.380  1.00 81.77           C  
ATOM   2701  CE  LYS   176      26.848  53.142  20.911  1.00 84.89           C  
ATOM   2702  NZ  LYS   176      25.676  54.054  20.647  1.00 83.93           N  
ATOM   2703  N   ALA   177      31.865  51.469  21.642  1.00 79.24           N  
ATOM   2704  CA  ALA   177      32.176  50.535  20.566  1.00 79.27           C  
ATOM   2705  C   ALA   177      33.219  49.554  21.081  1.00 79.93           C  
ATOM   2706  O   ALA   177      33.099  48.324  20.921  1.00 80.24           O  
ATOM   2707  CB  ALA   177      32.622  51.252  19.346  1.00 78.51           C  
ATOM   2708  N   CYS   178      34.207  50.110  21.768  1.00 79.78           N  
ATOM   2709  CA  CYS   178      35.165  49.311  22.478  1.00 80.08           C  
ATOM   2710  C   CYS   178      34.496  48.388  23.454  1.00 80.09           C  
ATOM   2711  O   CYS   178      34.971  47.279  23.695  1.00 80.25           O  
ATOM   2712  CB  CYS   178      36.129  50.201  23.244  1.00 79.97           C  
ATOM   2713  SG  CYS   178      37.208  51.015  22.135  1.00 83.90           S  
ATOM   2714  N   THR   179      33.414  48.826  24.075  1.00 80.07           N  
ATOM   2715  CA  THR   179      32.910  47.912  25.041  1.00 79.86           C  
ATOM   2716  C   THR   179      31.955  46.883  24.476  1.00 79.65           C  
ATOM   2717  O   THR   179      31.944  45.763  24.964  1.00 80.10           O  
ATOM   2718  CB  THR   179      32.618  48.501  26.423  1.00 79.75           C  
ATOM   2719  OG1 THR   179      31.564  47.759  27.025  1.00 81.48           O  
ATOM   2720  CG2 THR   179      32.283  49.953  26.388  1.00 78.95           C  
ATOM   2721  N   ARG   180      31.260  47.181  23.378  1.00 79.52           N  
ATOM   2722  CA  ARG   180      30.469  46.119  22.713  1.00 78.90           C  
ATOM   2723  C   ARG   180      31.441  45.028  22.254  1.00 78.05           C  
ATOM   2724  O   ARG   180      31.097  43.843  22.240  1.00 77.76           O  
ATOM   2725  CB  ARG   180      29.714  46.601  21.481  1.00 78.83           C  
ATOM   2726  CG  ARG   180      28.670  47.636  21.682  1.00 80.53           C  
ATOM   2727  CD  ARG   180      27.735  47.674  20.441  1.00 84.24           C  
ATOM   2728  NE  ARG   180      26.867  48.854  20.436  1.00 88.24           N  
ATOM   2729  CZ  ARG   180      25.893  49.112  19.556  1.00 92.40           C  
ATOM   2730  NH1 ARG   180      25.595  48.268  18.554  1.00 93.33           N  
ATOM   2731  NH2 ARG   180      25.205  50.247  19.677  1.00 94.32           N  
ATOM   2732  N   HIS   181      32.651  45.436  21.886  1.00 76.48           N  
ATOM   2733  CA  HIS   181      33.605  44.486  21.390  1.00 75.74           C  
ATOM   2734  C   HIS   181      33.821  43.362  22.410  1.00 75.96           C  
ATOM   2735  O   HIS   181      33.502  42.217  22.120  1.00 75.40           O  
ATOM   2736  CB  HIS   181      34.909  45.177  20.994  1.00 75.30           C  
ATOM   2737  CG  HIS   181      35.996  44.228  20.583  1.00 73.49           C  
ATOM   2738  ND1 HIS   181      35.785  43.182  19.708  1.00 74.20           N  
ATOM   2739  CD2 HIS   181      37.301  44.166  20.925  1.00 71.10           C  
ATOM   2740  CE1 HIS   181      36.908  42.510  19.537  1.00 70.48           C  
ATOM   2741  NE2 HIS   181      37.841  43.085  20.271  1.00 71.52           N  
ATOM   2742  N   LEU   182      34.321  43.699  23.600  1.00 76.46           N  
ATOM   2743  CA  LEU   182      34.436  42.751  24.721  1.00 77.19           C  
ATOM   2744  C   LEU   182      33.182  41.868  24.879  1.00 78.63           C  
ATOM   2745  O   LEU   182      33.265  40.636  24.969  1.00 79.20           O  
ATOM   2746  CB  LEU   182      34.654  43.512  26.026  1.00 76.44           C  
ATOM   2747  CG  LEU   182      35.972  44.295  26.188  1.00 75.55           C  
ATOM   2748  CD1 LEU   182      36.016  45.069  27.463  1.00 72.73           C  
ATOM   2749  CD2 LEU   182      37.183  43.414  26.136  1.00 72.50           C  
ATOM   2750  N   ILE   183      32.016  42.499  24.893  1.00 78.80           N  
ATOM   2751  CA  ILE   183      30.797  41.759  24.965  1.00 79.22           C  
ATOM   2752  C   ILE   183      30.567  40.870  23.730  1.00 79.91           C  
ATOM   2753  O   ILE   183      30.315  39.669  23.883  1.00 80.72           O  
ATOM   2754  CB  ILE   183      29.609  42.691  25.219  1.00 79.49           C  
ATOM   2755  CG1 ILE   183      29.902  43.591  26.417  1.00 79.82           C  
ATOM   2756  CG2 ILE   183      28.332  41.889  25.471  1.00 78.82           C  
ATOM   2757  CD1 ILE   183      28.888  44.708  26.629  1.00 82.25           C  
ATOM   2758  N   GLU   184      30.628  41.408  22.512  1.00 80.05           N  
ATOM   2759  CA  GLU   184      30.426  40.527  21.338  1.00 80.10           C  
ATOM   2760  C   GLU   184      31.446  39.401  21.394  1.00 80.16           C  
ATOM   2761  O   GLU   184      31.192  38.297  20.944  1.00 80.55           O  
ATOM   2762  CB  GLU   184      30.549  41.262  20.006  1.00 79.71           C  
ATOM   2763  CG  GLU   184      29.544  42.364  19.803  1.00 81.68           C  
ATOM   2764  CD  GLU   184      30.022  43.440  18.843  1.00 83.99           C  
ATOM   2765  OE1 GLU   184      29.181  43.990  18.091  1.00 84.65           O  
ATOM   2766  OE2 GLU   184      31.238  43.750  18.849  1.00 86.64           O  
ATOM   2767  N   GLN   185      32.593  39.696  21.982  1.00 80.10           N  
ATOM   2768  CA  GLN   185      33.676  38.749  22.099  1.00 80.36           C  
ATOM   2769  C   GLN   185      33.483  37.698  23.167  1.00 80.27           C  
ATOM   2770  O   GLN   185      34.251  36.752  23.237  1.00 80.62           O  
ATOM   2771  CB  GLN   185      34.967  39.504  22.425  1.00 81.07           C  
ATOM   2772  CG  GLN   185      35.668  40.050  21.188  1.00 80.87           C  
ATOM   2773  CD  GLN   185      36.068  38.953  20.272  1.00 78.91           C  
ATOM   2774  OE1 GLN   185      35.308  38.574  19.386  1.00 81.42           O  
ATOM   2775  NE2 GLN   185      37.238  38.383  20.511  1.00 77.13           N  
ATOM   2776  N   GLY   186      32.509  37.881  24.041  1.00 80.11           N  
ATOM   2777  CA  GLY   186      32.293  36.923  25.108  1.00 79.60           C  
ATOM   2778  C   GLY   186      32.768  37.339  26.483  1.00 79.55           C  
ATOM   2779  O   GLY   186      32.462  36.665  27.451  1.00 80.17           O  
ATOM   2780  N   PHE   187      33.502  38.441  26.591  1.00 79.33           N  
ATOM   2781  CA  PHE   187      33.986  38.923  27.886  1.00 78.91           C  
ATOM   2782  C   PHE   187      32.943  39.820  28.552  1.00 79.97           C  
ATOM   2783  O   PHE   187      32.911  41.047  28.385  1.00 80.79           O  
ATOM   2784  CB  PHE   187      35.304  39.652  27.708  1.00 78.21           C  
ATOM   2785  CG  PHE   187      36.365  38.824  27.034  1.00 77.68           C  
ATOM   2786  CD1 PHE   187      36.646  38.999  25.676  1.00 79.19           C  
ATOM   2787  CD2 PHE   187      37.064  37.856  27.742  1.00 75.88           C  
ATOM   2788  CE1 PHE   187      37.615  38.238  25.030  1.00 78.14           C  
ATOM   2789  CE2 PHE   187      38.013  37.078  27.119  1.00 77.33           C  
ATOM   2790  CZ  PHE   187      38.308  37.272  25.750  1.00 78.08           C  
ATOM   2791  N   LYS   188      32.071  39.208  29.322  1.00 80.38           N  
ATOM   2792  CA  LYS   188      30.915  39.937  29.794  1.00 80.84           C  
ATOM   2793  C   LYS   188      31.063  40.627  31.167  1.00 80.86           C  
ATOM   2794  O   LYS   188      30.079  41.211  31.669  1.00 80.99           O  
ATOM   2795  CB  LYS   188      29.664  39.026  29.744  1.00 80.76           C  
ATOM   2796  CG  LYS   188      29.261  38.639  28.296  1.00 81.71           C  
ATOM   2797  CD  LYS   188      28.091  37.692  28.232  1.00 81.52           C  
ATOM   2798  CE  LYS   188      27.244  38.001  27.006  1.00 85.18           C  
ATOM   2799  NZ  LYS   188      25.736  37.841  27.224  1.00 86.22           N  
ATOM   2800  N   ASN   189      32.221  40.561  31.824  1.00 80.14           N  
ATOM   2801  CA  ASN   189      32.241  41.338  33.062  1.00 80.65           C  
ATOM   2802  C   ASN   189      33.378  42.269  33.287  1.00 80.24           C  
ATOM   2803  O   ASN   189      34.320  41.987  34.008  1.00 80.39           O  
ATOM   2804  CB  ASN   189      31.732  40.616  34.331  1.00 81.09           C  
ATOM   2805  CG  ASN   189      32.468  39.378  34.631  1.00 81.57           C  
ATOM   2806  OD1 ASN   189      31.864  38.341  34.936  1.00 78.74           O  
ATOM   2807  ND2 ASN   189      33.792  39.455  34.563  1.00 83.76           N  
ATOM   2808  N   VAL   190      33.171  43.433  32.687  1.00 79.71           N  
ATOM   2809  CA  VAL   190      34.188  44.366  32.349  1.00 79.19           C  
ATOM   2810  C   VAL   190      34.303  45.369  33.445  1.00 78.89           C  
ATOM   2811  O   VAL   190      33.314  45.846  33.933  1.00 78.26           O  
ATOM   2812  CB  VAL   190      33.776  45.122  31.074  1.00 79.19           C  
ATOM   2813  CG1 VAL   190      34.944  45.917  30.532  1.00 78.94           C  
ATOM   2814  CG2 VAL   190      33.273  44.163  30.030  1.00 79.00           C  
ATOM   2815  N   GLY   191      35.528  45.688  33.822  1.00 79.46           N  
ATOM   2816  CA  GLY   191      35.778  46.807  34.694  1.00 80.54           C  
ATOM   2817  C   GLY   191      36.290  47.944  33.841  1.00 81.68           C  
ATOM   2818  O   GLY   191      36.678  47.753  32.672  1.00 81.85           O  
ATOM   2819  N   PHE   192      36.308  49.131  34.426  1.00 82.51           N  
ATOM   2820  CA  PHE   192      36.807  50.314  33.732  1.00 83.52           C  
ATOM   2821  C   PHE   192      37.820  51.041  34.596  1.00 83.55           C  
ATOM   2822  O   PHE   192      37.572  51.283  35.782  1.00 84.79           O  
ATOM   2823  CB  PHE   192      35.622  51.245  33.469  1.00 83.85           C  
ATOM   2824  CG  PHE   192      35.963  52.492  32.717  1.00 84.15           C  
ATOM   2825  CD1 PHE   192      35.894  52.519  31.322  1.00 83.73           C  
ATOM   2826  CD2 PHE   192      36.299  53.661  33.399  1.00 85.06           C  
ATOM   2827  CE1 PHE   192      36.167  53.697  30.607  1.00 83.70           C  
ATOM   2828  CE2 PHE   192      36.585  54.859  32.693  1.00 85.36           C  
ATOM   2829  CZ  PHE   192      36.520  54.873  31.300  1.00 84.60           C  
ATOM   2830  N   ILE   193      38.934  51.434  34.017  1.00 82.61           N  
ATOM   2831  CA  ILE   193      39.823  52.292  34.748  1.00 82.73           C  
ATOM   2832  C   ILE   193      40.120  53.495  33.879  1.00 82.43           C  
ATOM   2833  O   ILE   193      40.569  53.339  32.751  1.00 82.40           O  
ATOM   2834  CB  ILE   193      41.120  51.560  35.095  1.00 83.08           C  
ATOM   2835  CG1 ILE   193      40.841  50.351  35.984  1.00 83.58           C  
ATOM   2836  CG2 ILE   193      42.049  52.468  35.824  1.00 83.03           C  
ATOM   2837  CD1 ILE   193      41.969  49.322  35.948  1.00 83.18           C  
ATOM   2838  N   GLY   194      39.885  54.693  34.399  1.00 82.42           N  
ATOM   2839  CA  GLY   194      40.259  55.911  33.670  1.00 83.13           C  
ATOM   2840  C   GLY   194      40.774  57.070  34.505  1.00 84.00           C  
ATOM   2841  O   GLY   194      40.590  57.097  35.723  1.00 84.09           O  
ATOM   2842  N   ALA   195      41.420  58.043  33.868  1.00 85.27           N  
ATOM   2843  CA  ALA   195      41.868  59.211  34.625  1.00 86.69           C  
ATOM   2844  C   ALA   195      41.589  60.556  34.003  1.00 87.86           C  
ATOM   2845  O   ALA   195      40.987  60.666  32.943  1.00 88.25           O  
ATOM   2846  CB  ALA   195      43.313  59.095  34.951  1.00 87.22           C  
ATOM   2847  N   ARG   196      42.105  61.583  34.671  1.00 89.60           N  
ATOM   2848  CA  ARG   196      41.675  62.986  34.509  1.00 90.66           C  
ATOM   2849  C   ARG   196      40.163  63.034  34.302  1.00 90.86           C  
ATOM   2850  O   ARG   196      39.666  63.607  33.347  1.00 90.92           O  
ATOM   2851  CB  ARG   196      42.504  63.802  33.487  1.00 90.49           C  
ATOM   2852  CG  ARG   196      43.175  63.034  32.375  1.00 91.94           C  
ATOM   2853  CD  ARG   196      42.213  62.693  31.252  1.00 96.21           C  
ATOM   2854  NE  ARG   196      42.211  63.696  30.178  1.00100.30           N  
ATOM   2855  CZ  ARG   196      41.193  63.892  29.335  1.00102.27           C  
ATOM   2856  NH1 ARG   196      40.076  63.157  29.441  1.00101.77           N  
ATOM   2857  NH2 ARG   196      41.282  64.837  28.394  1.00102.48           N  
ATOM   2858  N   GLY   197      39.467  62.411  35.255  1.00 91.35           N  
ATOM   2859  CA  GLY   197      38.034  62.202  35.216  1.00 91.79           C  
ATOM   2860  C   GLY   197      37.219  63.293  35.868  1.00 92.28           C  
ATOM   2861  O   GLY   197      36.054  63.079  36.230  1.00 92.31           O  
ATOM   2862  N   ASN   198      37.844  64.452  36.035  1.00 92.64           N  
ATOM   2863  CA  ASN   198      37.138  65.677  36.366  1.00 93.28           C  
ATOM   2864  C   ASN   198      37.107  66.523  35.088  1.00 92.95           C  
ATOM   2865  O   ASN   198      36.318  67.469  34.981  1.00 93.11           O  
ATOM   2866  CB  ASN   198      37.806  66.429  37.539  1.00 93.99           C  
ATOM   2867  CG  ASN   198      37.985  65.549  38.834  1.00 96.42           C  
ATOM   2868  OD1 ASN   198      38.247  66.086  39.919  1.00 98.53           O  
ATOM   2869  ND2 ASN   198      37.868  64.219  38.710  1.00 97.94           N  
ATOM   2870  N   HIS   199      37.977  66.173  34.128  1.00 92.31           N  
ATOM   2871  CA  HIS   199      37.888  66.677  32.748  1.00 91.43           C  
ATOM   2872  C   HIS   199      36.818  65.892  31.993  1.00 89.90           C  
ATOM   2873  O   HIS   199      36.617  64.715  32.274  1.00 89.72           O  
ATOM   2874  CB  HIS   199      39.228  66.602  31.997  1.00 91.96           C  
ATOM   2875  CG  HIS   199      39.172  67.240  30.640  1.00 95.07           C  
ATOM   2876  ND1 HIS   199      38.842  66.537  29.495  1.00 97.43           N  
ATOM   2877  CD2 HIS   199      39.324  68.533  30.254  1.00 97.09           C  
ATOM   2878  CE1 HIS   199      38.828  67.363  28.461  1.00 97.18           C  
ATOM   2879  NE2 HIS   199      39.114  68.580  28.894  1.00 97.50           N  
ATOM   2880  N   SER   200      36.148  66.535  31.032  1.00 88.30           N  
ATOM   2881  CA  SER   200      34.909  65.990  30.461  1.00 86.92           C  
ATOM   2882  C   SER   200      35.070  64.754  29.576  1.00 85.74           C  
ATOM   2883  O   SER   200      34.207  63.901  29.582  1.00 85.73           O  
ATOM   2884  CB  SER   200      34.069  67.078  29.776  1.00 87.22           C  
ATOM   2885  OG  SER   200      34.280  67.122  28.371  1.00 88.08           O  
ATOM   2886  N   THR   201      36.168  64.643  28.838  1.00 84.64           N  
ATOM   2887  CA  THR   201      36.411  63.449  28.016  1.00 83.55           C  
ATOM   2888  C   THR   201      36.262  62.141  28.785  1.00 83.42           C  
ATOM   2889  O   THR   201      35.669  61.198  28.312  1.00 83.11           O  
ATOM   2890  CB  THR   201      37.801  63.485  27.375  1.00 83.05           C  
ATOM   2891  OG1 THR   201      37.890  64.655  26.567  1.00 84.53           O  
ATOM   2892  CG2 THR   201      38.055  62.255  26.503  1.00 80.40           C  
ATOM   2893  N   LEU   202      36.821  62.053  29.974  1.00 83.48           N  
ATOM   2894  CA  LEU   202      36.689  60.793  30.638  1.00 83.21           C  
ATOM   2895  C   LEU   202      35.206  60.453  30.854  1.00 82.67           C  
ATOM   2896  O   LEU   202      34.805  59.316  30.618  1.00 82.50           O  
ATOM   2897  CB  LEU   202      37.481  60.744  31.941  1.00 83.44           C  
ATOM   2898  CG  LEU   202      37.032  59.479  32.695  1.00 84.26           C  
ATOM   2899  CD1 LEU   202      37.781  58.229  32.239  1.00 82.06           C  
ATOM   2900  CD2 LEU   202      37.125  59.673  34.185  1.00 84.40           C  
ATOM   2901  N   GLN   203      34.403  61.435  31.275  1.00 81.91           N  
ATOM   2902  CA  GLN   203      32.993  61.188  31.605  1.00 81.41           C  
ATOM   2903  C   GLN   203      32.186  60.645  30.422  1.00 80.68           C  
ATOM   2904  O   GLN   203      31.303  59.796  30.588  1.00 80.17           O  
ATOM   2905  CB  GLN   203      32.323  62.413  32.221  1.00 81.28           C  
ATOM   2906  CG  GLN   203      31.132  62.047  33.157  1.00 84.16           C  
ATOM   2907  CD  GLN   203      31.493  61.959  34.684  1.00 88.19           C  
ATOM   2908  OE1 GLN   203      30.637  62.242  35.549  1.00 88.30           O  
ATOM   2909  NE2 GLN   203      32.757  61.593  35.007  1.00 88.03           N  
ATOM   2910  N   ARG   204      32.525  61.121  29.231  1.00 80.29           N  
ATOM   2911  CA  ARG   204      31.944  60.638  28.000  1.00 79.76           C  
ATOM   2912  C   ARG   204      32.359  59.220  27.672  1.00 80.40           C  
ATOM   2913  O   ARG   204      31.599  58.500  27.069  1.00 81.29           O  
ATOM   2914  CB  ARG   204      32.342  61.546  26.878  1.00 79.22           C  
ATOM   2915  CG  ARG   204      31.510  62.815  26.779  1.00 78.09           C  
ATOM   2916  CD  ARG   204      30.503  62.709  25.671  1.00 73.78           C  
ATOM   2917  NE  ARG   204      29.178  62.581  26.260  1.00 73.94           N  
ATOM   2918  CZ  ARG   204      28.079  62.153  25.643  1.00 71.92           C  
ATOM   2919  NH1 ARG   204      28.089  61.774  24.372  1.00 70.10           N  
ATOM   2920  NH2 ARG   204      26.953  62.101  26.329  1.00 72.91           N  
ATOM   2921  N   GLN   205      33.552  58.810  28.069  1.00 81.01           N  
ATOM   2922  CA  GLN   205      34.001  57.430  27.859  1.00 81.83           C  
ATOM   2923  C   GLN   205      33.366  56.483  28.874  1.00 81.54           C  
ATOM   2924  O   GLN   205      32.989  55.372  28.525  1.00 81.79           O  
ATOM   2925  CB  GLN   205      35.523  57.295  27.986  1.00 81.66           C  
ATOM   2926  CG  GLN   205      36.339  58.403  27.364  1.00 82.67           C  
ATOM   2927  CD  GLN   205      37.824  58.230  27.614  1.00 83.74           C  
ATOM   2928  OE1 GLN   205      38.590  57.948  26.687  1.00 87.39           O  
ATOM   2929  NE2 GLN   205      38.245  58.386  28.868  1.00 85.67           N  
ATOM   2930  N   LEU   206      33.280  56.923  30.129  1.00 81.26           N  
ATOM   2931  CA  LEU   206      32.664  56.154  31.211  1.00 80.62           C  
ATOM   2932  C   LEU   206      31.267  55.837  30.799  1.00 80.58           C  
ATOM   2933  O   LEU   206      30.844  54.691  30.807  1.00 80.68           O  
ATOM   2934  CB  LEU   206      32.554  56.999  32.473  1.00 80.35           C  
ATOM   2935  CG  LEU   206      32.950  56.478  33.855  1.00 80.48           C  
ATOM   2936  CD1 LEU   206      31.895  56.834  34.835  1.00 79.54           C  
ATOM   2937  CD2 LEU   206      33.171  54.998  33.885  1.00 82.11           C  
ATOM   2938  N   HIS   207      30.560  56.892  30.421  1.00 81.09           N  
ATOM   2939  CA  HIS   207      29.186  56.802  30.008  1.00 81.13           C  
ATOM   2940  C   HIS   207      29.084  55.873  28.824  1.00 81.17           C  
ATOM   2941  O   HIS   207      28.182  55.036  28.763  1.00 81.97           O  
ATOM   2942  CB  HIS   207      28.688  58.171  29.616  1.00 80.90           C  
ATOM   2943  CG  HIS   207      28.303  59.019  30.776  1.00 81.89           C  
ATOM   2944  ND1 HIS   207      28.257  60.393  30.710  1.00 83.73           N  
ATOM   2945  CD2 HIS   207      27.917  58.691  32.028  1.00 83.91           C  
ATOM   2946  CE1 HIS   207      27.853  60.877  31.869  1.00 84.17           C  
ATOM   2947  NE2 HIS   207      27.636  59.864  32.686  1.00 85.03           N  
ATOM   2948  N   GLY   208      30.017  56.007  27.888  1.00 80.25           N  
ATOM   2949  CA  GLY   208      30.003  55.150  26.725  1.00 79.50           C  
ATOM   2950  C   GLY   208      30.023  53.729  27.212  1.00 78.89           C  
ATOM   2951  O   GLY   208      29.307  52.886  26.719  1.00 78.71           O  
ATOM   2952  N   TRP   209      30.828  53.478  28.223  1.00 79.07           N  
ATOM   2953  CA  TRP   209      31.034  52.119  28.677  1.00 79.62           C  
ATOM   2954  C   TRP   209      29.805  51.629  29.414  1.00 79.46           C  
ATOM   2955  O   TRP   209      29.413  50.468  29.268  1.00 79.36           O  
ATOM   2956  CB  TRP   209      32.300  52.019  29.528  1.00 79.54           C  
ATOM   2957  CG  TRP   209      32.366  50.838  30.418  1.00 80.47           C  
ATOM   2958  CD1 TRP   209      32.629  49.542  30.055  1.00 80.70           C  
ATOM   2959  CD2 TRP   209      32.163  50.824  31.840  1.00 80.61           C  
ATOM   2960  NE1 TRP   209      32.607  48.720  31.177  1.00 80.20           N  
ATOM   2961  CE2 TRP   209      32.324  49.480  32.279  1.00 79.61           C  
ATOM   2962  CE3 TRP   209      31.846  51.806  32.783  1.00 79.52           C  
ATOM   2963  CZ2 TRP   209      32.174  49.101  33.615  1.00 78.81           C  
ATOM   2964  CZ3 TRP   209      31.724  51.421  34.131  1.00 79.47           C  
ATOM   2965  CH2 TRP   209      31.876  50.079  34.523  1.00 78.39           C  
ATOM   2966  N   GLN   210      29.179  52.521  30.173  1.00 79.68           N  
ATOM   2967  CA  GLN   210      28.035  52.146  31.021  1.00 79.73           C  
ATOM   2968  C   GLN   210      26.840  51.860  30.171  1.00 80.37           C  
ATOM   2969  O   GLN   210      26.070  50.968  30.458  1.00 80.30           O  
ATOM   2970  CB  GLN   210      27.714  53.238  32.011  1.00 79.17           C  
ATOM   2971  CG  GLN   210      28.840  53.487  32.944  1.00 78.82           C  
ATOM   2972  CD  GLN   210      28.479  54.365  34.067  1.00 77.16           C  
ATOM   2973  OE1 GLN   210      27.879  55.413  33.884  1.00 76.86           O  
ATOM   2974  NE2 GLN   210      28.858  53.954  35.264  1.00 79.17           N  
ATOM   2975  N   SER   211      26.716  52.604  29.084  1.00 81.82           N  
ATOM   2976  CA  SER   211      25.690  52.330  28.096  1.00 82.60           C  
ATOM   2977  C   SER   211      25.819  50.883  27.620  1.00 82.35           C  
ATOM   2978  O   SER   211      24.942  50.048  27.874  1.00 82.07           O  
ATOM   2979  CB  SER   211      25.813  53.297  26.922  1.00 82.72           C  
ATOM   2980  OG  SER   211      24.608  53.282  26.170  1.00 85.36           O  
ATOM   2981  N   ALA   212      26.933  50.589  26.962  1.00 82.35           N  
ATOM   2982  CA  ALA   212      27.198  49.247  26.454  1.00 82.75           C  
ATOM   2983  C   ALA   212      26.832  48.124  27.447  1.00 83.30           C  
ATOM   2984  O   ALA   212      26.241  47.099  27.028  1.00 83.70           O  
ATOM   2985  CB  ALA   212      28.635  49.131  26.039  1.00 82.33           C  
ATOM   2986  N   MET   213      27.158  48.315  28.741  1.00 82.82           N  
ATOM   2987  CA  MET   213      26.838  47.320  29.773  1.00 82.13           C  
ATOM   2988  C   MET   213      25.330  47.205  29.978  1.00 81.75           C  
ATOM   2989  O   MET   213      24.724  46.151  29.739  1.00 81.60           O  
ATOM   2990  CB  MET   213      27.488  47.680  31.087  1.00 81.95           C  
ATOM   2991  CG  MET   213      28.964  47.810  31.050  1.00 84.63           C  
ATOM   2992  SD  MET   213      29.883  46.136  30.639  0.90 92.81          SE  
ATOM   2993  CE  MET   213      29.680  45.178  32.333  1.00 90.40           C  
ATOM   2994  N   ILE   214      24.727  48.304  30.421  1.00 81.16           N  
ATOM   2995  CA  ILE   214      23.289  48.340  30.703  1.00 80.55           C  
ATOM   2996  C   ILE   214      22.459  47.774  29.546  1.00 80.64           C  
ATOM   2997  O   ILE   214      21.670  46.870  29.767  1.00 80.55           O  
ATOM   2998  CB  ILE   214      22.807  49.760  31.122  1.00 80.05           C  
ATOM   2999  CG1 ILE   214      23.707  50.302  32.235  1.00 78.65           C  
ATOM   3000  CG2 ILE   214      21.416  49.697  31.633  1.00 78.55           C  
ATOM   3001  CD1 ILE   214      23.628  51.791  32.454  1.00 76.82           C  
ATOM   3002  N   GLU   215      22.681  48.282  28.329  1.00 80.87           N  
ATOM   3003  CA  GLU   215      22.042  47.797  27.091  1.00 80.88           C  
ATOM   3004  C   GLU   215      22.051  46.275  27.002  1.00 80.66           C  
ATOM   3005  O   GLU   215      21.127  45.696  26.460  1.00 80.62           O  
ATOM   3006  CB  GLU   215      22.741  48.417  25.876  1.00 81.14           C  
ATOM   3007  CG  GLU   215      22.337  47.919  24.489  1.00 81.26           C  
ATOM   3008  CD  GLU   215      22.902  48.789  23.336  1.00 81.95           C  
ATOM   3009  OE1 GLU   215      22.057  49.343  22.600  1.00 82.54           O  
ATOM   3010  OE2 GLU   215      24.162  48.922  23.153  1.00 83.52           O  
ATOM   3011  N   ASN   216      23.067  45.628  27.567  1.00 80.46           N  
ATOM   3012  CA  ASN   216      23.105  44.163  27.627  1.00 80.35           C  
ATOM   3013  C   ASN   216      22.707  43.497  28.982  1.00 80.42           C  
ATOM   3014  O   ASN   216      23.016  42.325  29.199  1.00 80.86           O  
ATOM   3015  CB  ASN   216      24.477  43.638  27.155  1.00 80.81           C  
ATOM   3016  CG  ASN   216      24.736  43.879  25.653  1.00 81.75           C  
ATOM   3017  OD1 ASN   216      25.231  44.935  25.240  1.00 82.86           O  
ATOM   3018  ND2 ASN   216      24.440  42.871  24.844  1.00 83.41           N  
ATOM   3019  N   TYR   217      21.993  44.212  29.859  1.00 80.03           N  
ATOM   3020  CA  TYR   217      21.676  43.754  31.241  1.00 79.43           C  
ATOM   3021  C   TYR   217      22.903  43.442  32.069  1.00 79.05           C  
ATOM   3022  O   TYR   217      22.855  42.674  33.003  1.00 78.59           O  
ATOM   3023  CB  TYR   217      20.775  42.535  31.266  1.00 78.94           C  
ATOM   3024  CG  TYR   217      19.520  42.715  30.500  1.00 79.30           C  
ATOM   3025  CD1 TYR   217      19.528  42.600  29.113  1.00 80.49           C  
ATOM   3026  CD2 TYR   217      18.311  42.989  31.144  1.00 78.52           C  
ATOM   3027  CE1 TYR   217      18.373  42.762  28.366  1.00 80.34           C  
ATOM   3028  CE2 TYR   217      17.140  43.153  30.411  1.00 78.65           C  
ATOM   3029  CZ  TYR   217      17.181  43.044  29.005  1.00 79.65           C  
ATOM   3030  OH  TYR   217      16.058  43.210  28.205  1.00 79.47           O  
ATOM   3031  N   LEU   218      24.022  44.032  31.722  1.00 79.48           N  
ATOM   3032  CA  LEU   218      25.203  43.811  32.513  1.00 80.02           C  
ATOM   3033  C   LEU   218      25.235  44.948  33.505  1.00 81.06           C  
ATOM   3034  O   LEU   218      24.770  46.049  33.194  1.00 81.03           O  
ATOM   3035  CB  LEU   218      26.417  43.787  31.611  1.00 79.50           C  
ATOM   3036  CG  LEU   218      26.866  42.414  31.093  1.00 78.14           C  
ATOM   3037  CD1 LEU   218      25.746  41.443  30.890  1.00 75.30           C  
ATOM   3038  CD2 LEU   218      27.696  42.586  29.819  1.00 76.40           C  
ATOM   3039  N   THR   219      25.706  44.685  34.719  1.00 82.41           N  
ATOM   3040  CA  THR   219      25.541  45.691  35.769  1.00 83.88           C  
ATOM   3041  C   THR   219      26.892  46.345  35.941  1.00 84.11           C  
ATOM   3042  O   THR   219      27.820  45.689  36.393  1.00 84.65           O  
ATOM   3043  CB  THR   219      24.888  45.134  37.111  1.00 84.63           C  
ATOM   3044  OG1 THR   219      23.454  44.965  36.963  1.00 84.24           O  
ATOM   3045  CG2 THR   219      25.135  46.086  38.300  1.00 85.95           C  
ATOM   3046  N   PRO   220      26.963  47.657  35.612  1.00 84.07           N  
ATOM   3047  CA  PRO   220      28.052  48.528  35.185  1.00 83.80           C  
ATOM   3048  C   PRO   220      28.682  49.405  36.290  1.00 84.24           C  
ATOM   3049  O   PRO   220      28.902  50.622  36.095  1.00 83.18           O  
ATOM   3050  CB  PRO   220      27.308  49.474  34.248  1.00 83.87           C  
ATOM   3051  CG  PRO   220      25.976  49.681  34.961  1.00 83.16           C  
ATOM   3052  CD  PRO   220      25.711  48.437  35.749  1.00 83.40           C  
ATOM   3053  N   ASP   221      28.948  48.822  37.447  1.00 84.85           N  
ATOM   3054  CA  ASP   221      29.414  49.635  38.556  1.00 85.97           C  
ATOM   3055  C   ASP   221      30.748  49.146  39.059  1.00 85.17           C  
ATOM   3056  O   ASP   221      30.990  49.126  40.246  1.00 85.59           O  
ATOM   3057  CB  ASP   221      28.342  49.769  39.683  1.00 86.83           C  
ATOM   3058  CG  ASP   221      27.426  48.535  39.794  1.00 90.87           C  
ATOM   3059  OD1 ASP   221      27.667  47.577  38.987  1.00 94.30           O  
ATOM   3060  OD2 ASP   221      26.486  48.519  40.671  1.00 91.66           O  
ATOM   3061  N   HIS   222      31.613  48.729  38.146  1.00 84.85           N  
ATOM   3062  CA  HIS   222      32.964  48.320  38.535  1.00 84.13           C  
ATOM   3063  C   HIS   222      33.944  49.158  37.783  1.00 83.02           C  
ATOM   3064  O   HIS   222      34.596  48.720  36.811  1.00 82.52           O  
ATOM   3065  CB  HIS   222      33.197  46.793  38.449  1.00 83.98           C  
ATOM   3066  CG  HIS   222      32.434  46.044  39.496  1.00 86.64           C  
ATOM   3067  ND1 HIS   222      32.674  46.207  40.846  1.00 88.07           N  
ATOM   3068  CD2 HIS   222      31.353  45.229  39.407  1.00 89.19           C  
ATOM   3069  CE1 HIS   222      31.819  45.469  41.537  1.00 88.71           C  
ATOM   3070  NE2 HIS   222      31.000  44.872  40.689  1.00 87.42           N  
ATOM   3071  N   PHE   223      34.006  50.403  38.238  1.00 81.78           N  
ATOM   3072  CA  PHE   223      34.900  51.371  37.632  1.00 81.50           C  
ATOM   3073  C   PHE   223      35.734  52.130  38.659  1.00 82.19           C  
ATOM   3074  O   PHE   223      35.310  52.274  39.825  1.00 82.35           O  
ATOM   3075  CB  PHE   223      34.123  52.326  36.734  1.00 79.77           C  
ATOM   3076  CG  PHE   223      33.174  53.199  37.451  1.00 77.37           C  
ATOM   3077  CD1 PHE   223      31.837  52.880  37.519  1.00 77.18           C  
ATOM   3078  CD2 PHE   223      33.592  54.371  38.036  1.00 77.31           C  
ATOM   3079  CE1 PHE   223      30.918  53.713  38.164  1.00 72.44           C  
ATOM   3080  CE2 PHE   223      32.661  55.214  38.694  1.00 76.67           C  
ATOM   3081  CZ  PHE   223      31.335  54.874  38.735  1.00 73.97           C  
ATOM   3082  N   LEU   224      36.905  52.604  38.219  1.00 82.06           N  
ATOM   3083  CA  LEU   224      37.733  53.499  39.012  1.00 82.61           C  
ATOM   3084  C   LEU   224      38.128  54.698  38.205  1.00 82.97           C  
ATOM   3085  O   LEU   224      38.662  54.527  37.092  1.00 83.77           O  
ATOM   3086  CB  LEU   224      39.026  52.802  39.399  1.00 82.82           C  
ATOM   3087  CG  LEU   224      39.254  52.219  40.774  1.00 83.50           C  
ATOM   3088  CD1 LEU   224      37.959  52.088  41.554  1.00 85.03           C  
ATOM   3089  CD2 LEU   224      39.894  50.858  40.578  1.00 85.70           C  
ATOM   3090  N   THR   225      37.933  55.902  38.744  1.00 82.85           N  
ATOM   3091  CA  THR   225      38.495  57.087  38.075  1.00 83.61           C  
ATOM   3092  C   THR   225      39.307  57.980  39.011  1.00 84.39           C  
ATOM   3093  O   THR   225      39.051  58.007  40.209  1.00 84.97           O  
ATOM   3094  CB  THR   225      37.412  57.907  37.391  1.00 83.54           C  
ATOM   3095  OG1 THR   225      36.355  58.157  38.318  1.00 83.97           O  
ATOM   3096  CG2 THR   225      36.843  57.160  36.177  1.00 83.17           C  
ATOM   3097  N   THR   226      40.304  58.691  38.493  1.00 84.90           N  
ATOM   3098  CA  THR   226      40.943  59.733  39.305  1.00 85.90           C  
ATOM   3099  C   THR   226      40.960  61.051  38.587  1.00 86.24           C  
ATOM   3100  O   THR   226      40.904  61.124  37.361  1.00 86.36           O  
ATOM   3101  CB  THR   226      42.401  59.413  39.730  1.00 86.41           C  
ATOM   3102  OG1 THR   226      43.255  59.353  38.579  1.00 86.81           O  
ATOM   3103  CG2 THR   226      42.481  58.094  40.507  1.00 87.66           C  
ATOM   3104  N   HIS   227      41.040  62.109  39.368  1.00 87.18           N  
ATOM   3105  CA  HIS   227      41.241  63.440  38.816  1.00 88.05           C  
ATOM   3106  C   HIS   227      42.692  63.543  38.325  1.00 87.59           C  
ATOM   3107  O   HIS   227      43.010  64.354  37.461  1.00 87.62           O  
ATOM   3108  CB  HIS   227      40.868  64.527  39.852  1.00 88.59           C  
ATOM   3109  CG  HIS   227      41.334  64.250  41.262  1.00 91.75           C  
ATOM   3110  ND1 HIS   227      41.565  65.260  42.180  1.00 94.04           N  
ATOM   3111  CD2 HIS   227      41.605  63.087  41.915  1.00 94.12           C  
ATOM   3112  CE1 HIS   227      41.957  64.732  43.329  1.00 94.60           C  
ATOM   3113  NE2 HIS   227      42.001  63.417  43.193  1.00 94.22           N  
ATOM   3114  N   GLU   228      43.550  62.666  38.845  1.00 87.05           N  
ATOM   3115  CA  GLU   228      44.947  62.625  38.439  1.00 86.70           C  
ATOM   3116  C   GLU   228      45.210  62.211  36.991  1.00 85.50           C  
ATOM   3117  O   GLU   228      44.288  61.895  36.247  1.00 84.81           O  
ATOM   3118  CB  GLU   228      45.757  61.781  39.408  1.00 87.01           C  
ATOM   3119  CG  GLU   228      46.501  62.670  40.394  1.00 89.88           C  
ATOM   3120  CD  GLU   228      46.612  62.040  41.770  1.00 93.66           C  
ATOM   3121  OE1 GLU   228      46.266  62.723  42.759  1.00 94.15           O  
ATOM   3122  OE2 GLU   228      47.029  60.857  41.859  1.00 94.91           O  
ATOM   3123  N   ALA   229      46.486  62.239  36.608  1.00 84.35           N  
ATOM   3124  CA  ALA   229      46.906  61.929  35.241  1.00 82.60           C  
ATOM   3125  C   ALA   229      47.145  60.431  35.095  1.00 81.39           C  
ATOM   3126  O   ALA   229      47.444  59.757  36.095  1.00 80.76           O  
ATOM   3127  CB  ALA   229      48.147  62.717  34.875  1.00 82.24           C  
ATOM   3128  N   PRO   230      47.005  59.912  33.850  1.00 80.34           N  
ATOM   3129  CA  PRO   230      47.079  58.488  33.551  1.00 79.67           C  
ATOM   3130  C   PRO   230      48.490  57.998  33.807  1.00 79.33           C  
ATOM   3131  O   PRO   230      49.441  58.728  33.544  1.00 79.37           O  
ATOM   3132  CB  PRO   230      46.791  58.446  32.060  1.00 79.50           C  
ATOM   3133  CG  PRO   230      47.291  59.746  31.566  1.00 79.05           C  
ATOM   3134  CD  PRO   230      46.788  60.679  32.610  1.00 80.01           C  
ATOM   3135  N   SER   231      48.618  56.787  34.331  1.00 78.06           N  
ATOM   3136  CA  SER   231      49.889  56.293  34.756  1.00 77.44           C  
ATOM   3137  C   SER   231      49.764  54.794  34.771  1.00 77.76           C  
ATOM   3138  O   SER   231      48.660  54.257  34.891  1.00 77.53           O  
ATOM   3139  CB  SER   231      50.167  56.775  36.161  1.00 77.01           C  
ATOM   3140  OG  SER   231      49.558  55.912  37.102  1.00 76.78           O  
ATOM   3141  N   SER   232      50.882  54.093  34.662  1.00 77.58           N  
ATOM   3142  CA  SER   232      50.761  52.664  34.703  1.00 77.72           C  
ATOM   3143  C   SER   232      50.582  52.211  36.124  1.00 77.42           C  
ATOM   3144  O   SER   232      50.033  51.143  36.326  1.00 78.13           O  
ATOM   3145  CB  SER   232      51.926  51.958  34.038  1.00 77.32           C  
ATOM   3146  OG  SER   232      53.123  52.333  34.672  1.00 80.66           O  
ATOM   3147  N   GLN   233      51.023  53.005  37.106  1.00 77.03           N  
ATOM   3148  CA  GLN   233      50.759  52.656  38.518  1.00 76.52           C  
ATOM   3149  C   GLN   233      49.248  52.585  38.710  1.00 77.02           C  
ATOM   3150  O   GLN   233      48.710  51.699  39.382  1.00 76.52           O  
ATOM   3151  CB  GLN   233      51.331  53.665  39.512  1.00 75.54           C  
ATOM   3152  CG  GLN   233      50.857  53.389  40.915  1.00 72.24           C  
ATOM   3153  CD  GLN   233      51.261  54.449  41.915  1.00 73.31           C  
ATOM   3154  OE1 GLN   233      51.663  55.559  41.563  1.00 74.54           O  
ATOM   3155  NE2 GLN   233      51.161  54.109  43.190  1.00 74.95           N  
ATOM   3156  N   LEU   234      48.566  53.522  38.088  1.00 77.12           N  
ATOM   3157  CA  LEU   234      47.147  53.527  38.196  1.00 77.96           C  
ATOM   3158  C   LEU   234      46.530  52.232  37.636  1.00 78.74           C  
ATOM   3159  O   LEU   234      45.608  51.708  38.248  1.00 79.47           O  
ATOM   3160  CB  LEU   234      46.584  54.758  37.521  1.00 77.70           C  
ATOM   3161  CG  LEU   234      45.370  55.355  38.177  1.00 79.13           C  
ATOM   3162  CD1 LEU   234      44.947  56.555  37.375  1.00 82.80           C  
ATOM   3163  CD2 LEU   234      44.222  54.330  38.267  1.00 80.77           C  
ATOM   3164  N   GLY   235      47.029  51.718  36.500  1.00 79.10           N  
ATOM   3165  CA  GLY   235      46.478  50.499  35.880  1.00 78.47           C  
ATOM   3166  C   GLY   235      46.785  49.249  36.687  1.00 78.51           C  
ATOM   3167  O   GLY   235      45.963  48.374  36.811  1.00 78.65           O  
ATOM   3168  N   ALA   236      47.985  49.156  37.222  1.00 79.07           N  
ATOM   3169  CA  ALA   236      48.313  48.110  38.190  1.00 79.99           C  
ATOM   3170  C   ALA   236      47.314  48.145  39.331  1.00 80.11           C  
ATOM   3171  O   ALA   236      46.516  47.236  39.528  1.00 80.82           O  
ATOM   3172  CB  ALA   236      49.721  48.320  38.744  1.00 79.45           C  
ATOM   3173  N   GLU   237      47.336  49.226  40.078  1.00 80.17           N  
ATOM   3174  CA  GLU   237      46.568  49.254  41.290  1.00 79.92           C  
ATOM   3175  C   GLU   237      45.127  49.207  40.916  1.00 79.99           C  
ATOM   3176  O   GLU   237      44.324  48.569  41.598  1.00 81.06           O  
ATOM   3177  CB  GLU   237      46.919  50.465  42.102  1.00 79.24           C  
ATOM   3178  CG  GLU   237      48.337  50.394  42.513  1.00 79.76           C  
ATOM   3179  CD  GLU   237      48.812  51.687  43.053  1.00 84.93           C  
ATOM   3180  OE1 GLU   237      49.783  51.685  43.842  1.00 89.59           O  
ATOM   3181  OE2 GLU   237      48.216  52.724  42.706  1.00 87.95           O  
ATOM   3182  N   GLY   238      44.802  49.827  39.792  1.00 79.75           N  
ATOM   3183  CA  GLY   238      43.430  49.763  39.256  1.00 79.00           C  
ATOM   3184  C   GLY   238      42.989  48.320  39.201  1.00 77.94           C  
ATOM   3185  O   GLY   238      41.979  47.950  39.823  1.00 78.05           O  
ATOM   3186  N   LEU   239      43.773  47.499  38.500  1.00 76.52           N  
ATOM   3187  CA  LEU   239      43.450  46.101  38.382  1.00 75.69           C  
ATOM   3188  C   LEU   239      43.298  45.514  39.771  1.00 75.56           C  
ATOM   3189  O   LEU   239      42.265  44.888  40.092  1.00 75.42           O  
ATOM   3190  CB  LEU   239      44.538  45.355  37.665  1.00 75.82           C  
ATOM   3191  CG  LEU   239      44.167  44.117  36.844  1.00 75.08           C  
ATOM   3192  CD1 LEU   239      45.276  43.100  36.964  1.00 71.28           C  
ATOM   3193  CD2 LEU   239      42.840  43.508  37.195  1.00 73.29           C  
ATOM   3194  N   ALA   240      44.302  45.739  40.613  1.00 75.04           N  
ATOM   3195  CA  ALA   240      44.243  45.216  41.986  1.00 74.69           C  
ATOM   3196  C   ALA   240      42.893  45.477  42.653  1.00 74.79           C  
ATOM   3197  O   ALA   240      42.198  44.533  43.034  1.00 74.63           O  
ATOM   3198  CB  ALA   240      45.359  45.736  42.823  1.00 73.80           C  
ATOM   3199  N   LYS   241      42.507  46.743  42.764  1.00 75.18           N  
ATOM   3200  CA  LYS   241      41.346  47.095  43.555  1.00 76.31           C  
ATOM   3201  C   LYS   241      40.051  46.506  42.967  1.00 76.89           C  
ATOM   3202  O   LYS   241      39.150  46.100  43.704  1.00 76.65           O  
ATOM   3203  CB  LYS   241      41.230  48.606  43.696  1.00 77.02           C  
ATOM   3204  CG  LYS   241      42.432  49.312  44.336  1.00 79.16           C  
ATOM   3205  CD  LYS   241      41.960  50.650  44.905  1.00 83.08           C  
ATOM   3206  CE  LYS   241      43.102  51.600  45.260  1.00 86.88           C  
ATOM   3207  NZ  LYS   241      43.539  52.449  44.099  1.00 90.07           N  
ATOM   3208  N   LEU   242      39.967  46.448  41.640  1.00 77.59           N  
ATOM   3209  CA  LEU   242      38.846  45.799  40.996  1.00 78.27           C  
ATOM   3210  C   LEU   242      38.787  44.308  41.355  1.00 78.63           C  
ATOM   3211  O   LEU   242      37.764  43.814  41.804  1.00 78.46           O  
ATOM   3212  CB  LEU   242      38.903  46.022  39.480  1.00 78.55           C  
ATOM   3213  CG  LEU   242      38.591  47.426  38.937  1.00 78.41           C  
ATOM   3214  CD1 LEU   242      38.297  47.335  37.480  1.00 78.32           C  
ATOM   3215  CD2 LEU   242      37.400  48.064  39.613  1.00 76.96           C  
ATOM   3216  N   LEU   243      39.904  43.608  41.184  1.00 79.41           N  
ATOM   3217  CA  LEU   243      40.029  42.229  41.647  1.00 79.93           C  
ATOM   3218  C   LEU   243      39.565  42.060  43.060  1.00 80.28           C  
ATOM   3219  O   LEU   243      39.089  40.995  43.404  1.00 81.87           O  
ATOM   3220  CB  LEU   243      41.481  41.776  41.598  1.00 79.58           C  
ATOM   3221  CG  LEU   243      41.994  40.912  40.448  1.00 80.56           C  
ATOM   3222  CD1 LEU   243      41.020  40.762  39.265  1.00 81.41           C  
ATOM   3223  CD2 LEU   243      43.334  41.430  39.975  1.00 80.94           C  
ATOM   3224  N   LEU   244      39.748  43.076  43.897  1.00 79.94           N  
ATOM   3225  CA  LEU   244      39.491  42.915  45.318  1.00 79.65           C  
ATOM   3226  C   LEU   244      38.041  43.245  45.590  1.00 80.53           C  
ATOM   3227  O   LEU   244      37.427  42.723  46.520  1.00 80.53           O  
ATOM   3228  CB  LEU   244      40.424  43.809  46.140  1.00 79.63           C  
ATOM   3229  CG  LEU   244      40.195  44.023  47.644  1.00 78.57           C  
ATOM   3230  CD1 LEU   244      40.535  42.772  48.389  1.00 80.14           C  
ATOM   3231  CD2 LEU   244      41.050  45.133  48.169  1.00 78.59           C  
ATOM   3232  N   ARG   245      37.514  44.157  44.782  1.00 81.43           N  
ATOM   3233  CA  ARG   245      36.104  44.454  44.754  1.00 81.46           C  
ATOM   3234  C   ARG   245      35.417  43.118  44.408  1.00 81.77           C  
ATOM   3235  O   ARG   245      34.539  42.669  45.140  1.00 81.58           O  
ATOM   3236  CB  ARG   245      35.838  45.576  43.724  1.00 81.30           C  
ATOM   3237  CG  ARG   245      34.440  46.194  43.750  1.00 82.92           C  
ATOM   3238  CD  ARG   245      34.456  47.706  43.527  1.00 86.21           C  
ATOM   3239  NE  ARG   245      33.213  48.354  44.017  1.00 91.72           N  
ATOM   3240  CZ  ARG   245      32.935  48.729  45.297  1.00 91.05           C  
ATOM   3241  NH1 ARG   245      33.784  48.526  46.318  1.00 87.40           N  
ATOM   3242  NH2 ARG   245      31.772  49.324  45.563  1.00 89.97           N  
ATOM   3243  N   ASP   246      35.875  42.443  43.350  1.00 82.20           N  
ATOM   3244  CA  ASP   246      35.144  41.312  42.784  1.00 82.59           C  
ATOM   3245  C   ASP   246      35.994  40.486  41.807  1.00 82.66           C  
ATOM   3246  O   ASP   246      36.337  40.947  40.734  1.00 82.39           O  
ATOM   3247  CB  ASP   246      33.900  41.854  42.079  1.00 82.72           C  
ATOM   3248  CG  ASP   246      33.016  40.761  41.505  1.00 84.75           C  
ATOM   3249  OD1 ASP   246      31.801  40.773  41.815  1.00 86.71           O  
ATOM   3250  OD2 ASP   246      33.517  39.908  40.735  1.00 86.22           O  
ATOM   3251  N   SER   247      36.311  39.248  42.172  1.00 83.39           N  
ATOM   3252  CA  SER   247      37.240  38.423  41.364  1.00 83.24           C  
ATOM   3253  C   SER   247      36.642  37.914  40.067  1.00 83.14           C  
ATOM   3254  O   SER   247      37.365  37.639  39.119  1.00 84.49           O  
ATOM   3255  CB  SER   247      37.813  37.237  42.161  1.00 83.19           C  
ATOM   3256  OG  SER   247      36.788  36.346  42.615  1.00 83.91           O  
ATOM   3257  N   SER   248      35.338  37.779  39.977  1.00 82.77           N  
ATOM   3258  CA  SER   248      34.817  37.268  38.733  1.00 83.19           C  
ATOM   3259  C   SER   248      35.249  38.151  37.543  1.00 83.13           C  
ATOM   3260  O   SER   248      35.228  37.691  36.406  1.00 83.48           O  
ATOM   3261  CB  SER   248      33.309  37.140  38.792  1.00 83.03           C  
ATOM   3262  OG  SER   248      32.768  38.435  38.784  1.00 84.39           O  
ATOM   3263  N   LEU   249      35.657  39.397  37.813  1.00 83.13           N  
ATOM   3264  CA  LEU   249      36.135  40.353  36.787  1.00 82.64           C  
ATOM   3265  C   LEU   249      36.877  39.615  35.716  1.00 82.64           C  
ATOM   3266  O   LEU   249      37.651  38.739  36.047  1.00 83.40           O  
ATOM   3267  CB  LEU   249      37.087  41.356  37.404  1.00 82.11           C  
ATOM   3268  CG  LEU   249      37.791  42.260  36.391  1.00 83.16           C  
ATOM   3269  CD1 LEU   249      36.932  43.464  36.112  1.00 83.79           C  
ATOM   3270  CD2 LEU   249      39.157  42.713  36.873  1.00 81.01           C  
ATOM   3271  N   ASN   250      36.656  39.946  34.448  1.00 82.36           N  
ATOM   3272  CA  ASN   250      37.342  39.240  33.369  1.00 82.52           C  
ATOM   3273  C   ASN   250      37.651  40.026  32.087  1.00 83.30           C  
ATOM   3274  O   ASN   250      38.069  39.448  31.095  1.00 83.64           O  
ATOM   3275  CB  ASN   250      36.637  37.926  33.046  1.00 82.21           C  
ATOM   3276  CG  ASN   250      35.394  38.103  32.221  1.00 81.28           C  
ATOM   3277  OD1 ASN   250      35.194  39.113  31.571  1.00 83.19           O  
ATOM   3278  ND2 ASN   250      34.555  37.098  32.227  1.00 80.62           N  
ATOM   3279  N   ALA   251      37.426  41.333  32.108  1.00 84.24           N  
ATOM   3280  CA  ALA   251      38.035  42.235  31.119  1.00 85.17           C  
ATOM   3281  C   ALA   251      38.202  43.674  31.666  1.00 85.56           C  
ATOM   3282  O   ALA   251      37.555  44.055  32.666  1.00 85.84           O  
ATOM   3283  CB  ALA   251      37.249  42.233  29.821  1.00 84.51           C  
ATOM   3284  N   LEU   252      39.032  44.465  31.000  1.00 85.03           N  
ATOM   3285  CA  LEU   252      39.224  45.832  31.410  1.00 85.80           C  
ATOM   3286  C   LEU   252      39.114  46.825  30.272  1.00 86.02           C  
ATOM   3287  O   LEU   252      39.662  46.583  29.186  1.00 86.98           O  
ATOM   3288  CB  LEU   252      40.613  45.952  31.998  1.00 86.34           C  
ATOM   3289  CG  LEU   252      40.856  46.259  33.464  1.00 86.70           C  
ATOM   3290  CD1 LEU   252      39.724  45.801  34.310  1.00 86.48           C  
ATOM   3291  CD2 LEU   252      42.162  45.577  33.868  1.00 88.38           C  
ATOM   3292  N   VAL   253      38.434  47.947  30.501  1.00 85.70           N  
ATOM   3293  CA  VAL   253      38.505  49.059  29.547  1.00 85.61           C  
ATOM   3294  C   VAL   253      39.384  50.110  30.187  1.00 86.01           C  
ATOM   3295  O   VAL   253      39.072  50.601  31.254  1.00 87.31           O  
ATOM   3296  CB  VAL   253      37.138  49.732  29.270  1.00 85.41           C  
ATOM   3297  CG1 VAL   253      37.299  50.868  28.281  1.00 83.63           C  
ATOM   3298  CG2 VAL   253      36.116  48.753  28.759  1.00 84.62           C  
ATOM   3299  N   CYS   254      40.470  50.473  29.547  1.00 85.81           N  
ATOM   3300  CA  CYS   254      41.311  51.516  30.071  1.00 85.82           C  
ATOM   3301  C   CYS   254      41.166  52.796  29.277  1.00 85.90           C  
ATOM   3302  O   CYS   254      41.260  52.787  28.022  1.00 86.76           O  
ATOM   3303  CB  CYS   254      42.750  51.076  29.968  1.00 86.09           C  
ATOM   3304  SG  CYS   254      43.022  49.648  30.943  1.00 87.05           S  
ATOM   3305  N   SER   255      41.006  53.903  29.992  1.00 84.47           N  
ATOM   3306  CA  SER   255      40.847  55.172  29.330  1.00 83.85           C  
ATOM   3307  C   SER   255      42.078  55.569  28.498  1.00 83.36           C  
ATOM   3308  O   SER   255      41.943  56.300  27.498  1.00 83.50           O  
ATOM   3309  CB  SER   255      40.566  56.249  30.348  1.00 83.72           C  
ATOM   3310  OG  SER   255      41.766  56.625  30.974  1.00 84.32           O  
ATOM   3311  N   HIS   256      43.248  55.075  28.906  1.00 81.70           N  
ATOM   3312  CA  HIS   256      44.527  55.571  28.419  1.00 80.68           C  
ATOM   3313  C   HIS   256      45.512  54.444  28.269  1.00 81.83           C  
ATOM   3314  O   HIS   256      45.438  53.425  28.959  1.00 82.07           O  
ATOM   3315  CB  HIS   256      45.162  56.514  29.435  1.00 79.68           C  
ATOM   3316  CG  HIS   256      44.628  57.896  29.397  1.00 75.29           C  
ATOM   3317  ND1 HIS   256      43.323  58.193  29.705  1.00 73.05           N  
ATOM   3318  CD2 HIS   256      45.229  59.071  29.111  1.00 72.69           C  
ATOM   3319  CE1 HIS   256      43.138  59.496  29.601  1.00 73.77           C  
ATOM   3320  NE2 HIS   256      44.279  60.054  29.237  1.00 71.70           N  
ATOM   3321  N   GLU   257      46.496  54.661  27.412  1.00 82.44           N  
ATOM   3322  CA  GLU   257      47.441  53.611  27.098  1.00 82.31           C  
ATOM   3323  C   GLU   257      48.394  53.288  28.235  1.00 81.42           C  
ATOM   3324  O   GLU   257      48.726  52.121  28.432  1.00 80.55           O  
ATOM   3325  CB  GLU   257      48.198  53.968  25.835  1.00 82.78           C  
ATOM   3326  CG  GLU   257      48.803  52.806  25.111  1.00 83.56           C  
ATOM   3327  CD  GLU   257      49.789  53.282  24.108  1.00 86.39           C  
ATOM   3328  OE1 GLU   257      50.529  54.253  24.425  1.00 88.34           O  
ATOM   3329  OE2 GLU   257      49.816  52.709  22.996  1.00 87.47           O  
ATOM   3330  N   GLU   258      48.829  54.308  28.978  1.00 81.44           N  
ATOM   3331  CA  GLU   258      49.629  54.073  30.226  1.00 81.37           C  
ATOM   3332  C   GLU   258      48.894  53.151  31.197  1.00 80.61           C  
ATOM   3333  O   GLU   258      49.465  52.222  31.746  1.00 80.28           O  
ATOM   3334  CB  GLU   258      49.958  55.370  30.942  1.00 81.09           C  
ATOM   3335  CG  GLU   258      50.756  56.303  30.103  1.00 84.47           C  
ATOM   3336  CD  GLU   258      50.012  57.578  29.721  1.00 89.55           C  
ATOM   3337  OE1 GLU   258      48.869  57.541  29.169  1.00 87.61           O  
ATOM   3338  OE2 GLU   258      50.630  58.643  29.973  1.00 93.93           O  
ATOM   3339  N   ILE   259      47.600  53.401  31.350  1.00 80.21           N  
ATOM   3340  CA  ILE   259      46.764  52.619  32.222  1.00 80.11           C  
ATOM   3341  C   ILE   259      46.742  51.144  31.812  1.00 80.24           C  
ATOM   3342  O   ILE   259      46.965  50.250  32.626  1.00 80.65           O  
ATOM   3343  CB  ILE   259      45.379  53.229  32.232  1.00 79.76           C  
ATOM   3344  CG1 ILE   259      45.480  54.624  32.840  1.00 80.71           C  
ATOM   3345  CG2 ILE   259      44.394  52.329  32.950  1.00 79.34           C  
ATOM   3346  CD1 ILE   259      44.325  55.559  32.565  1.00 81.97           C  
ATOM   3347  N   ALA   260      46.507  50.902  30.535  1.00 80.27           N  
ATOM   3348  CA  ALA   260      46.356  49.566  30.034  1.00 79.77           C  
ATOM   3349  C   ALA   260      47.669  48.847  30.160  1.00 79.71           C  
ATOM   3350  O   ALA   260      47.700  47.641  30.270  1.00 79.58           O  
ATOM   3351  CB  ALA   260      45.945  49.623  28.594  1.00 80.65           C  
ATOM   3352  N   ILE   261      48.767  49.584  30.132  1.00 79.78           N  
ATOM   3353  CA  ILE   261      50.069  48.958  30.234  1.00 79.85           C  
ATOM   3354  C   ILE   261      50.293  48.515  31.678  1.00 80.61           C  
ATOM   3355  O   ILE   261      50.737  47.375  31.943  1.00 80.58           O  
ATOM   3356  CB  ILE   261      51.156  49.917  29.793  1.00 79.31           C  
ATOM   3357  CG1 ILE   261      51.105  50.043  28.276  1.00 81.41           C  
ATOM   3358  CG2 ILE   261      52.498  49.436  30.232  1.00 77.40           C  
ATOM   3359  CD1 ILE   261      51.792  48.907  27.512  1.00 84.06           C  
ATOM   3360  N   GLY   262      49.980  49.413  32.612  1.00 80.40           N  
ATOM   3361  CA  GLY   262      50.056  49.061  34.007  1.00 80.65           C  
ATOM   3362  C   GLY   262      49.307  47.762  34.166  1.00 80.88           C  
ATOM   3363  O   GLY   262      49.828  46.808  34.722  1.00 81.27           O  
ATOM   3364  N   ALA   263      48.093  47.717  33.631  1.00 81.05           N  
ATOM   3365  CA  ALA   263      47.205  46.595  33.852  1.00 81.34           C  
ATOM   3366  C   ALA   263      47.828  45.313  33.311  1.00 82.15           C  
ATOM   3367  O   ALA   263      47.917  44.328  34.041  1.00 82.89           O  
ATOM   3368  CB  ALA   263      45.868  46.867  33.226  1.00 80.54           C  
ATOM   3369  N   LEU   264      48.280  45.346  32.050  1.00 82.57           N  
ATOM   3370  CA  LEU   264      48.885  44.204  31.350  1.00 82.63           C  
ATOM   3371  C   LEU   264      50.021  43.614  32.157  1.00 83.42           C  
ATOM   3372  O   LEU   264      50.038  42.426  32.456  1.00 84.14           O  
ATOM   3373  CB  LEU   264      49.463  44.649  30.004  1.00 82.03           C  
ATOM   3374  CG  LEU   264      49.329  43.693  28.809  1.00 82.31           C  
ATOM   3375  CD1 LEU   264      50.477  43.882  27.850  1.00 83.64           C  
ATOM   3376  CD2 LEU   264      49.224  42.220  29.158  1.00 82.40           C  
ATOM   3377  N   PHE   265      50.985  44.467  32.483  1.00 83.88           N  
ATOM   3378  CA  PHE   265      52.086  44.109  33.320  1.00 83.77           C  
ATOM   3379  C   PHE   265      51.622  43.507  34.642  1.00 83.96           C  
ATOM   3380  O   PHE   265      52.248  42.571  35.128  1.00 84.61           O  
ATOM   3381  CB  PHE   265      52.920  45.342  33.578  1.00 83.96           C  
ATOM   3382  CG  PHE   265      53.969  45.592  32.545  1.00 85.31           C  
ATOM   3383  CD1 PHE   265      54.675  44.531  31.965  1.00 86.87           C  
ATOM   3384  CD2 PHE   265      54.316  46.895  32.189  1.00 86.60           C  
ATOM   3385  CE1 PHE   265      55.683  44.767  31.018  1.00 86.32           C  
ATOM   3386  CE2 PHE   265      55.343  47.144  31.238  1.00 85.63           C  
ATOM   3387  CZ  PHE   265      56.014  46.084  30.657  1.00 84.94           C  
ATOM   3388  N   GLU   266      50.534  44.017  35.222  1.00 83.47           N  
ATOM   3389  CA  GLU   266      50.076  43.521  36.529  1.00 83.66           C  
ATOM   3390  C   GLU   266      49.419  42.146  36.393  1.00 84.31           C  
ATOM   3391  O   GLU   266      49.481  41.324  37.316  1.00 84.28           O  
ATOM   3392  CB  GLU   266      49.131  44.529  37.227  1.00 83.95           C  
ATOM   3393  CG  GLU   266      48.665  44.190  38.634  1.00 82.61           C  
ATOM   3394  CD  GLU   266      49.831  44.163  39.608  1.00 84.94           C  
ATOM   3395  OE1 GLU   266      50.880  44.748  39.219  1.00 86.56           O  
ATOM   3396  OE2 GLU   266      49.726  43.561  40.726  1.00 81.04           O  
ATOM   3397  N   CYS   267      48.781  41.906  35.245  1.00 84.70           N  
ATOM   3398  CA  CYS   267      48.246  40.596  34.932  1.00 85.28           C  
ATOM   3399  C   CYS   267      49.410  39.630  34.959  1.00 84.98           C  
ATOM   3400  O   CYS   267      49.389  38.628  35.677  1.00 85.53           O  
ATOM   3401  CB  CYS   267      47.648  40.615  33.550  1.00 85.97           C  
ATOM   3402  SG  CYS   267      46.056  41.419  33.472  1.00 90.56           S  
ATOM   3403  N   HIS   268      50.463  39.960  34.221  1.00 84.08           N  
ATOM   3404  CA  HIS   268      51.678  39.175  34.324  1.00 83.30           C  
ATOM   3405  C   HIS   268      52.142  38.917  35.762  1.00 81.89           C  
ATOM   3406  O   HIS   268      52.492  37.786  36.086  1.00 81.78           O  
ATOM   3407  CB  HIS   268      52.777  39.735  33.443  1.00 83.22           C  
ATOM   3408  CG  HIS   268      52.461  39.622  31.989  1.00 85.46           C  
ATOM   3409  ND1 HIS   268      53.184  40.267  31.011  1.00 86.53           N  
ATOM   3410  CD2 HIS   268      51.474  38.956  31.345  1.00 87.96           C  
ATOM   3411  CE1 HIS   268      52.670  39.996  29.829  1.00 84.77           C  
ATOM   3412  NE2 HIS   268      51.629  39.206  30.002  1.00 87.65           N  
ATOM   3413  N   ARG   269      52.097  39.930  36.623  1.00 80.16           N  
ATOM   3414  CA  ARG   269      52.585  39.750  38.001  1.00 78.66           C  
ATOM   3415  C   ARG   269      51.748  38.698  38.753  1.00 78.29           C  
ATOM   3416  O   ARG   269      52.281  37.860  39.503  1.00 77.61           O  
ATOM   3417  CB  ARG   269      52.597  41.066  38.789  1.00 77.55           C  
ATOM   3418  CG  ARG   269      53.533  40.970  39.951  1.00 76.08           C  
ATOM   3419  CD  ARG   269      53.725  42.245  40.730  1.00 73.34           C  
ATOM   3420  NE  ARG   269      52.597  42.430  41.631  1.00 71.11           N  
ATOM   3421  CZ  ARG   269      52.631  42.304  42.952  1.00 68.49           C  
ATOM   3422  NH1 ARG   269      53.751  42.031  43.609  1.00 67.24           N  
ATOM   3423  NH2 ARG   269      51.498  42.475  43.615  1.00 70.15           N  
ATOM   3424  N   ARG   270      50.440  38.743  38.512  1.00 77.23           N  
ATOM   3425  CA  ARG   270      49.484  37.999  39.290  1.00 76.19           C  
ATOM   3426  C   ARG   270      49.201  36.708  38.580  1.00 75.95           C  
ATOM   3427  O   ARG   270      48.387  35.900  39.018  1.00 75.43           O  
ATOM   3428  CB  ARG   270      48.203  38.800  39.411  1.00 76.37           C  
ATOM   3429  CG  ARG   270      48.399  40.257  39.742  1.00 74.85           C  
ATOM   3430  CD  ARG   270      47.141  40.820  40.363  1.00 72.59           C  
ATOM   3431  NE  ARG   270      47.443  42.022  41.138  1.00 70.63           N  
ATOM   3432  CZ  ARG   270      47.415  42.119  42.460  1.00 70.78           C  
ATOM   3433  NH1 ARG   270      47.057  41.106  43.240  1.00 70.72           N  
ATOM   3434  NH2 ARG   270      47.737  43.267  43.006  1.00 74.54           N  
ATOM   3435  N   VAL   271      49.905  36.525  37.467  1.00 75.84           N  
ATOM   3436  CA  VAL   271      49.743  35.346  36.612  1.00 74.88           C  
ATOM   3437  C   VAL   271      48.313  35.199  36.145  1.00 75.23           C  
ATOM   3438  O   VAL   271      47.847  34.101  36.023  1.00 75.71           O  
ATOM   3439  CB  VAL   271      50.197  34.017  37.312  1.00 74.43           C  
ATOM   3440  CG1 VAL   271      50.468  32.912  36.298  1.00 70.81           C  
ATOM   3441  CG2 VAL   271      51.399  34.254  38.213  1.00 73.03           C  
ATOM   3442  N   LEU   272      47.603  36.293  35.906  1.00 76.44           N  
ATOM   3443  CA  LEU   272      46.354  36.217  35.101  1.00 77.40           C  
ATOM   3444  C   LEU   272      46.669  36.270  33.586  1.00 77.51           C  
ATOM   3445  O   LEU   272      46.988  37.324  33.042  1.00 77.60           O  
ATOM   3446  CB  LEU   272      45.349  37.324  35.461  1.00 77.07           C  
ATOM   3447  CG  LEU   272      44.613  37.514  36.809  1.00 78.26           C  
ATOM   3448  CD1 LEU   272      43.810  36.322  37.267  1.00 77.82           C  
ATOM   3449  CD2 LEU   272      45.555  37.905  37.888  1.00 81.04           C  
ATOM   3450  N   LYS   273      46.598  35.126  32.914  1.00 77.78           N  
ATOM   3451  CA  LYS   273      46.627  35.093  31.449  1.00 77.71           C  
ATOM   3452  C   LYS   273      45.803  36.201  30.738  1.00 76.95           C  
ATOM   3453  O   LYS   273      44.687  36.556  31.151  1.00 76.88           O  
ATOM   3454  CB  LYS   273      46.186  33.717  30.960  1.00 78.46           C  
ATOM   3455  CG  LYS   273      47.344  32.771  30.761  1.00 81.33           C  
ATOM   3456  CD  LYS   273      48.324  33.300  29.641  1.00 86.35           C  
ATOM   3457  CE  LYS   273      49.550  32.367  29.373  1.00 85.14           C  
ATOM   3458  NZ  LYS   273      49.243  31.298  28.380  1.00 88.29           N  
ATOM   3459  N   VAL   274      46.355  36.720  29.652  1.00 76.06           N  
ATOM   3460  CA  VAL   274      45.667  37.696  28.831  1.00 76.26           C  
ATOM   3461  C   VAL   274      45.513  37.167  27.387  1.00 77.43           C  
ATOM   3462  O   VAL   274      46.503  36.897  26.721  1.00 78.31           O  
ATOM   3463  CB  VAL   274      46.401  39.035  28.943  1.00 76.12           C  
ATOM   3464  CG1 VAL   274      45.889  40.072  27.980  1.00 74.36           C  
ATOM   3465  CG2 VAL   274      46.334  39.558  30.436  1.00 75.82           C  
ATOM   3466  N   PRO   275      44.269  37.015  26.880  1.00 78.20           N  
ATOM   3467  CA  PRO   275      42.963  37.409  27.389  1.00 78.84           C  
ATOM   3468  C   PRO   275      42.131  36.338  28.084  1.00 79.41           C  
ATOM   3469  O   PRO   275      40.998  36.623  28.471  1.00 79.46           O  
ATOM   3470  CB  PRO   275      42.230  37.809  26.105  1.00 78.68           C  
ATOM   3471  CG  PRO   275      42.751  36.848  25.092  1.00 78.47           C  
ATOM   3472  CD  PRO   275      44.138  36.407  25.546  1.00 78.30           C  
ATOM   3473  N   THR   276      42.630  35.120  28.236  1.00 80.07           N  
ATOM   3474  CA  THR   276      41.711  34.091  28.724  1.00 80.73           C  
ATOM   3475  C   THR   276      41.370  34.158  30.216  1.00 81.09           C  
ATOM   3476  O   THR   276      40.515  33.414  30.662  1.00 81.71           O  
ATOM   3477  CB  THR   276      42.116  32.659  28.335  1.00 80.48           C  
ATOM   3478  OG1 THR   276      43.346  32.336  28.966  1.00 81.49           O  
ATOM   3479  CG2 THR   276      42.268  32.525  26.830  1.00 81.18           C  
ATOM   3480  N   ASP   277      42.019  35.029  30.989  1.00 81.71           N  
ATOM   3481  CA  ASP   277      41.555  35.297  32.368  1.00 81.91           C  
ATOM   3482  C   ASP   277      41.077  36.709  32.434  1.00 81.75           C  
ATOM   3483  O   ASP   277      40.046  36.994  32.980  1.00 82.59           O  
ATOM   3484  CB  ASP   277      42.651  35.107  33.413  1.00 82.07           C  
ATOM   3485  CG  ASP   277      43.087  33.671  33.555  1.00 83.35           C  
ATOM   3486  OD1 ASP   277      42.200  32.805  33.764  1.00 84.57           O  
ATOM   3487  OD2 ASP   277      44.315  33.420  33.479  1.00 83.88           O  
ATOM   3488  N   ILE   278      41.855  37.608  31.875  1.00 81.75           N  
ATOM   3489  CA  ILE   278      41.415  38.958  31.732  1.00 81.55           C  
ATOM   3490  C   ILE   278      41.684  39.411  30.284  1.00 81.63           C  
ATOM   3491  O   ILE   278      42.785  39.182  29.730  1.00 81.02           O  
ATOM   3492  CB  ILE   278      42.078  39.807  32.819  1.00 81.80           C  
ATOM   3493  CG1 ILE   278      41.279  39.615  34.132  1.00 82.82           C  
ATOM   3494  CG2 ILE   278      42.174  41.269  32.401  1.00 81.69           C  
ATOM   3495  CD1 ILE   278      41.974  40.012  35.402  1.00 81.58           C  
ATOM   3496  N   ALA   279      40.655  39.969  29.651  1.00 80.88           N  
ATOM   3497  CA  ALA   279      40.844  40.618  28.369  1.00 81.25           C  
ATOM   3498  C   ALA   279      41.083  42.109  28.584  1.00 81.18           C  
ATOM   3499  O   ALA   279      40.575  42.674  29.537  1.00 82.19           O  
ATOM   3500  CB  ALA   279      39.641  40.405  27.513  1.00 81.61           C  
ATOM   3501  N   ILE   280      41.826  42.769  27.712  1.00 80.88           N  
ATOM   3502  CA  ILE   280      42.109  44.188  27.939  1.00 80.85           C  
ATOM   3503  C   ILE   280      41.836  45.024  26.693  1.00 81.76           C  
ATOM   3504  O   ILE   280      42.144  44.605  25.564  1.00 82.66           O  
ATOM   3505  CB  ILE   280      43.595  44.413  28.419  1.00 80.89           C  
ATOM   3506  CG1 ILE   280      43.809  43.922  29.865  1.00 79.90           C  
ATOM   3507  CG2 ILE   280      43.988  45.887  28.363  1.00 79.91           C  
ATOM   3508  CD1 ILE   280      45.294  43.804  30.291  1.00 79.26           C  
ATOM   3509  N   ILE   281      41.300  46.224  26.863  1.00 81.46           N  
ATOM   3510  CA  ILE   281      41.121  47.068  25.675  1.00 81.24           C  
ATOM   3511  C   ILE   281      41.394  48.532  25.992  1.00 81.42           C  
ATOM   3512  O   ILE   281      40.860  49.073  26.967  1.00 81.87           O  
ATOM   3513  CB  ILE   281      39.710  46.858  25.035  1.00 81.39           C  
ATOM   3514  CG1 ILE   281      39.680  47.507  23.648  1.00 81.23           C  
ATOM   3515  CG2 ILE   281      38.570  47.299  26.009  1.00 80.21           C  
ATOM   3516  CD1 ILE   281      38.335  47.725  23.069  1.00 77.98           C  
ATOM   3517  N   CYS   282      42.227  49.178  25.187  1.00 81.39           N  
ATOM   3518  CA  CYS   282      42.668  50.538  25.517  1.00 81.35           C  
ATOM   3519  C   CYS   282      41.896  51.518  24.697  1.00 81.30           C  
ATOM   3520  O   CYS   282      41.590  51.248  23.547  1.00 81.66           O  
ATOM   3521  CB  CYS   282      44.147  50.710  25.237  1.00 81.07           C  
ATOM   3522  SG  CYS   282      44.722  52.425  25.344  1.00 82.39           S  
ATOM   3523  N   LEU   283      41.570  52.661  25.273  1.00 81.28           N  
ATOM   3524  CA  LEU   283      40.664  53.593  24.583  1.00 81.05           C  
ATOM   3525  C   LEU   283      41.380  54.608  23.684  1.00 81.11           C  
ATOM   3526  O   LEU   283      40.730  55.408  23.004  1.00 80.38           O  
ATOM   3527  CB  LEU   283      39.812  54.326  25.619  1.00 81.16           C  
ATOM   3528  CG  LEU   283      38.326  53.980  25.772  1.00 80.91           C  
ATOM   3529  CD1 LEU   283      37.959  52.551  25.366  1.00 81.11           C  
ATOM   3530  CD2 LEU   283      37.855  54.275  27.195  1.00 80.76           C  
ATOM   3531  N   GLU   284      42.716  54.583  23.706  1.00 81.12           N  
ATOM   3532  CA  GLU   284      43.532  55.544  22.971  1.00 81.87           C  
ATOM   3533  C   GLU   284      44.925  54.982  22.838  1.00 81.92           C  
ATOM   3534  O   GLU   284      45.863  55.460  23.473  1.00 82.86           O  
ATOM   3535  CB  GLU   284      43.571  56.913  23.663  1.00 81.14           C  
ATOM   3536  CG  GLU   284      44.092  58.032  22.774  1.00 82.40           C  
ATOM   3537  CD  GLU   284      44.717  59.220  23.536  1.00 83.80           C  
ATOM   3538  OE1 GLU   284      45.325  59.021  24.637  1.00 86.52           O  
ATOM   3539  OE2 GLU   284      44.629  60.364  23.002  1.00 85.86           O  
ATOM   3540  N   GLY   285      45.056  53.937  22.034  1.00 82.25           N  
ATOM   3541  CA  GLY   285      46.353  53.284  21.813  1.00 82.49           C  
ATOM   3542  C   GLY   285      47.267  53.991  20.828  1.00 82.72           C  
ATOM   3543  O   GLY   285      46.853  54.829  20.037  1.00 83.15           O  
ATOM   3544  N   SER   286      48.533  53.653  20.905  1.00 82.98           N  
ATOM   3545  CA  SER   286      49.527  54.126  19.986  1.00 83.27           C  
ATOM   3546  C   SER   286      50.352  52.890  19.659  1.00 83.62           C  
ATOM   3547  O   SER   286      50.068  51.794  20.156  1.00 83.96           O  
ATOM   3548  CB  SER   286      50.415  55.144  20.698  1.00 83.98           C  
ATOM   3549  OG  SER   286      51.532  54.520  21.344  1.00 83.20           O  
ATOM   3550  N   SER   287      51.409  53.062  18.883  1.00 83.50           N  
ATOM   3551  CA  SER   287      52.313  51.954  18.609  1.00 83.23           C  
ATOM   3552  C   SER   287      52.865  51.370  19.895  1.00 82.51           C  
ATOM   3553  O   SER   287      53.332  50.230  19.918  1.00 82.19           O  
ATOM   3554  CB  SER   287      53.461  52.434  17.738  1.00 83.21           C  
ATOM   3555  OG  SER   287      54.187  53.392  18.470  1.00 84.46           O  
ATOM   3556  N   MET   288      52.798  52.151  20.967  1.00 82.36           N  
ATOM   3557  CA  MET   288      53.336  51.723  22.269  1.00 82.73           C  
ATOM   3558  C   MET   288      52.685  50.447  22.698  1.00 81.57           C  
ATOM   3559  O   MET   288      53.353  49.471  22.970  1.00 80.97           O  
ATOM   3560  CB  MET   288      53.148  52.813  23.319  1.00 83.18           C  
ATOM   3561  CG  MET   288      52.963  52.326  24.721  1.00 89.04           C  
ATOM   3562  SD  MET   288      54.574  51.903  25.725  0.80105.94          SE  
ATOM   3563  CE  MET   288      55.558  53.606  25.569  1.00 99.22           C  
ATOM   3564  N   GLY   289      51.356  50.474  22.697  1.00 81.59           N  
ATOM   3565  CA  GLY   289      50.536  49.378  23.123  1.00 80.65           C  
ATOM   3566  C   GLY   289      50.502  48.338  22.054  1.00 80.78           C  
ATOM   3567  O   GLY   289      50.423  47.174  22.361  1.00 81.79           O  
ATOM   3568  N   GLU   290      50.561  48.749  20.792  1.00 80.73           N  
ATOM   3569  CA  GLU   290      50.595  47.806  19.661  1.00 80.56           C  
ATOM   3570  C   GLU   290      51.689  46.760  19.799  1.00 80.60           C  
ATOM   3571  O   GLU   290      51.555  45.650  19.285  1.00 80.71           O  
ATOM   3572  CB  GLU   290      50.832  48.544  18.346  1.00 80.31           C  
ATOM   3573  CG  GLU   290      50.862  47.612  17.159  1.00 81.56           C  
ATOM   3574  CD  GLU   290      51.363  48.285  15.913  1.00 83.89           C  
ATOM   3575  OE1 GLU   290      51.760  49.463  16.044  1.00 86.52           O  
ATOM   3576  OE2 GLU   290      51.370  47.653  14.816  1.00 82.25           O  
ATOM   3577  N   HIS   291      52.781  47.126  20.466  1.00 80.18           N  
ATOM   3578  CA  HIS   291      53.913  46.253  20.524  1.00 80.05           C  
ATOM   3579  C   HIS   291      54.216  45.812  21.935  1.00 81.23           C  
ATOM   3580  O   HIS   291      55.373  45.528  22.261  1.00 81.74           O  
ATOM   3581  CB  HIS   291      55.128  46.923  19.904  1.00 79.38           C  
ATOM   3582  CG  HIS   291      55.208  46.775  18.421  1.00 76.46           C  
ATOM   3583  ND1 HIS   291      54.601  47.655  17.550  1.00 74.30           N  
ATOM   3584  CD2 HIS   291      55.824  45.848  17.653  1.00 73.89           C  
ATOM   3585  CE1 HIS   291      54.844  47.283  16.309  1.00 72.44           C  
ATOM   3586  NE2 HIS   291      55.579  46.185  16.344  1.00 73.21           N  
ATOM   3587  N   ALA   292      53.187  45.773  22.778  1.00 81.96           N  
ATOM   3588  CA  ALA   292      53.274  45.117  24.078  1.00 82.59           C  
ATOM   3589  C   ALA   292      53.062  43.600  23.888  1.00 83.24           C  
ATOM   3590  O   ALA   292      52.928  43.144  22.767  1.00 84.32           O  
ATOM   3591  CB  ALA   292      52.243  45.676  24.962  1.00 82.78           C  
ATOM   3592  N   TYR   293      53.059  42.814  24.956  1.00 83.78           N  
ATOM   3593  CA  TYR   293      52.790  41.380  24.851  1.00 84.14           C  
ATOM   3594  C   TYR   293      51.913  40.864  25.987  1.00 84.11           C  
ATOM   3595  O   TYR   293      52.261  41.049  27.147  1.00 84.38           O  
ATOM   3596  CB  TYR   293      54.072  40.586  24.911  1.00 84.66           C  
ATOM   3597  CG  TYR   293      53.806  39.097  24.974  1.00 86.11           C  
ATOM   3598  CD1 TYR   293      53.805  38.418  26.196  1.00 86.38           C  
ATOM   3599  CD2 TYR   293      53.535  38.368  23.806  1.00 86.68           C  
ATOM   3600  CE1 TYR   293      53.554  37.053  26.256  1.00 86.76           C  
ATOM   3601  CE2 TYR   293      53.289  37.001  23.851  1.00 86.49           C  
ATOM   3602  CZ  TYR   293      53.300  36.357  25.081  1.00 86.96           C  
ATOM   3603  OH  TYR   293      53.043  35.015  25.134  1.00 87.32           O  
ATOM   3604  N   PRO   294      50.782  40.212  25.664  1.00 83.61           N  
ATOM   3605  CA  PRO   294      50.186  40.103  24.344  1.00 83.14           C  
ATOM   3606  C   PRO   294      49.870  41.513  23.883  1.00 82.69           C  
ATOM   3607  O   PRO   294      49.586  42.348  24.729  1.00 83.29           O  
ATOM   3608  CB  PRO   294      48.879  39.374  24.637  1.00 82.88           C  
ATOM   3609  CG  PRO   294      49.141  38.596  25.828  1.00 82.74           C  
ATOM   3610  CD  PRO   294      49.976  39.497  26.665  1.00 83.43           C  
ATOM   3611  N   SER   295      49.947  41.790  22.584  1.00 81.63           N  
ATOM   3612  CA  SER   295      49.701  43.126  22.058  1.00 80.96           C  
ATOM   3613  C   SER   295      48.275  43.461  22.357  1.00 81.34           C  
ATOM   3614  O   SER   295      47.440  42.558  22.446  1.00 81.90           O  
ATOM   3615  CB  SER   295      49.830  43.093  20.559  1.00 81.04           C  
ATOM   3616  OG  SER   295      49.004  42.066  20.053  1.00 80.89           O  
ATOM   3617  N   LEU   296      47.936  44.737  22.478  1.00 81.03           N  
ATOM   3618  CA  LEU   296      46.570  44.976  22.908  1.00 80.63           C  
ATOM   3619  C   LEU   296      45.616  45.704  21.996  1.00 79.83           C  
ATOM   3620  O   LEU   296      45.924  46.746  21.427  1.00 79.65           O  
ATOM   3621  CB  LEU   296      46.506  45.529  24.347  1.00 81.66           C  
ATOM   3622  CG  LEU   296      47.613  46.402  24.916  1.00 81.55           C  
ATOM   3623  CD1 LEU   296      47.722  47.649  24.054  1.00 81.34           C  
ATOM   3624  CD2 LEU   296      47.280  46.701  26.377  1.00 79.93           C  
ATOM   3625  N   THR   297      44.437  45.114  21.903  1.00 79.07           N  
ATOM   3626  CA  THR   297      43.313  45.677  21.198  1.00 79.14           C  
ATOM   3627  C   THR   297      43.068  47.087  21.679  1.00 79.58           C  
ATOM   3628  O   THR   297      42.826  47.311  22.854  1.00 81.39           O  
ATOM   3629  CB  THR   297      42.061  44.843  21.479  1.00 78.86           C  
ATOM   3630  OG1 THR   297      42.166  43.595  20.794  1.00 78.44           O  
ATOM   3631  CG2 THR   297      40.802  45.559  21.036  1.00 78.03           C  
ATOM   3632  N   SER   298      43.105  48.046  20.777  1.00 79.51           N  
ATOM   3633  CA  SER   298      42.795  49.389  21.166  1.00 79.09           C  
ATOM   3634  C   SER   298      42.246  50.237  20.038  1.00 78.30           C  
ATOM   3635  O   SER   298      42.322  49.891  18.851  1.00 78.13           O  
ATOM   3636  CB  SER   298      44.065  50.048  21.618  1.00 79.90           C  
ATOM   3637  OG  SER   298      44.503  50.824  20.534  1.00 82.76           O  
ATOM   3638  N   ALA   299      41.750  51.391  20.443  1.00 77.50           N  
ATOM   3639  CA  ALA   299      41.158  52.355  19.545  1.00 77.20           C  
ATOM   3640  C   ALA   299      42.214  53.346  19.183  1.00 76.88           C  
ATOM   3641  O   ALA   299      42.933  53.800  20.055  1.00 77.33           O  
ATOM   3642  CB  ALA   299      40.041  53.064  20.236  1.00 77.48           C  
ATOM   3643  N   GLU   300      42.312  53.691  17.902  1.00 76.19           N  
ATOM   3644  CA  GLU   300      43.326  54.630  17.472  1.00 75.41           C  
ATOM   3645  C   GLU   300      42.703  55.808  16.792  1.00 74.48           C  
ATOM   3646  O   GLU   300      41.589  55.705  16.319  1.00 74.51           O  
ATOM   3647  CB  GLU   300      44.326  53.941  16.566  1.00 76.01           C  
ATOM   3648  CG  GLU   300      45.229  52.989  17.335  1.00 77.18           C  
ATOM   3649  CD  GLU   300      46.257  52.373  16.456  1.00 78.27           C  
ATOM   3650  OE1 GLU   300      46.411  52.838  15.317  1.00 81.55           O  
ATOM   3651  OE2 GLU   300      46.916  51.421  16.892  1.00 79.79           O  
ATOM   3652  N   PHE   301      43.414  56.929  16.772  1.00 73.35           N  
ATOM   3653  CA  PHE   301      42.907  58.151  16.172  1.00 72.73           C  
ATOM   3654  C   PHE   301      44.040  58.747  15.362  1.00 72.26           C  
ATOM   3655  O   PHE   301      45.188  58.401  15.568  1.00 72.70           O  
ATOM   3656  CB  PHE   301      42.466  59.165  17.240  1.00 73.07           C  
ATOM   3657  CG  PHE   301      41.539  58.604  18.297  1.00 72.90           C  
ATOM   3658  CD1 PHE   301      40.168  58.748  18.179  1.00 73.42           C  
ATOM   3659  CD2 PHE   301      42.047  57.968  19.424  1.00 73.00           C  
ATOM   3660  CE1 PHE   301      39.319  58.249  19.142  1.00 73.89           C  
ATOM   3661  CE2 PHE   301      41.210  57.450  20.388  1.00 72.82           C  
ATOM   3662  CZ  PHE   301      39.845  57.599  20.256  1.00 74.30           C  
ATOM   3663  N   ASP   302      43.725  59.648  14.447  1.00 71.31           N  
ATOM   3664  CA  ASP   302      44.730  60.199  13.594  1.00 70.69           C  
ATOM   3665  C   ASP   302      44.826  61.684  13.899  1.00 70.98           C  
ATOM   3666  O   ASP   302      44.295  62.526  13.206  1.00 71.04           O  
ATOM   3667  CB  ASP   302      44.393  59.872  12.144  1.00 69.96           C  
ATOM   3668  CG  ASP   302      45.422  60.382  11.147  1.00 70.55           C  
ATOM   3669  OD1 ASP   302      45.106  60.217   9.948  1.00 71.95           O  
ATOM   3670  OD2 ASP   302      46.505  60.945  11.510  1.00 67.91           O  
ATOM   3671  N   TYR   303      45.522  62.008  14.968  1.00 71.92           N  
ATOM   3672  CA  TYR   303      45.611  63.391  15.358  1.00 73.12           C  
ATOM   3673  C   TYR   303      46.477  64.171  14.394  1.00 73.92           C  
ATOM   3674  O   TYR   303      46.251  65.362  14.211  1.00 74.47           O  
ATOM   3675  CB  TYR   303      46.108  63.540  16.799  1.00 73.26           C  
ATOM   3676  CG  TYR   303      45.215  62.899  17.838  1.00 73.56           C  
ATOM   3677  CD1 TYR   303      43.843  63.221  17.923  1.00 73.22           C  
ATOM   3678  CD2 TYR   303      45.739  61.977  18.753  1.00 74.58           C  
ATOM   3679  CE1 TYR   303      43.009  62.619  18.892  1.00 73.27           C  
ATOM   3680  CE2 TYR   303      44.921  61.376  19.738  1.00 74.96           C  
ATOM   3681  CZ  TYR   303      43.558  61.701  19.798  1.00 74.41           C  
ATOM   3682  OH  TYR   303      42.774  61.103  20.765  1.00 74.15           O  
ATOM   3683  N   GLU   304      47.459  63.520  13.769  1.00 74.71           N  
ATOM   3684  CA  GLU   304      48.185  64.188  12.685  1.00 75.38           C  
ATOM   3685  C   GLU   304      47.207  64.759  11.638  1.00 75.84           C  
ATOM   3686  O   GLU   304      47.320  65.934  11.303  1.00 76.04           O  
ATOM   3687  CB  GLU   304      49.267  63.306  12.044  1.00 75.36           C  
ATOM   3688  N   ARG   305      46.237  63.966  11.161  1.00 76.26           N  
ATOM   3689  CA  ARG   305      45.231  64.479  10.190  1.00 77.38           C  
ATOM   3690  C   ARG   305      44.364  65.615  10.754  1.00 77.78           C  
ATOM   3691  O   ARG   305      44.148  66.635  10.103  1.00 77.58           O  
ATOM   3692  CB  ARG   305      44.340  63.367   9.608  1.00 77.16           C  
ATOM   3693  CG  ARG   305      43.794  63.717   8.222  1.00 78.11           C  
ATOM   3694  CD  ARG   305      43.069  62.572   7.509  1.00 78.41           C  
ATOM   3695  NE  ARG   305      41.604  62.717   7.526  1.00 81.34           N  
ATOM   3696  CZ  ARG   305      40.784  62.276   6.563  1.00 81.76           C  
ATOM   3697  NH1 ARG   305      41.289  61.674   5.490  1.00 81.84           N  
ATOM   3698  NH2 ARG   305      39.461  62.442   6.663  1.00 80.57           N  
ATOM   3699  N   MET   306      43.880  65.426  11.974  1.00 78.66           N  
ATOM   3700  CA  MET   306      43.192  66.472  12.711  1.00 79.70           C  
ATOM   3701  C   MET   306      44.028  67.736  12.738  1.00 78.26           C  
ATOM   3702  O   MET   306      43.512  68.826  12.546  1.00 78.02           O  
ATOM   3703  CB  MET   306      42.919  65.988  14.118  1.00 79.65           C  
ATOM   3704  CG  MET   306      42.229  66.966  15.018  1.00 80.59           C  
ATOM   3705  SD  MET   306      41.519  65.936  16.498  0.80 85.28          SE  
ATOM   3706  CE  MET   306      42.450  66.827  17.975  1.00 83.16           C  
ATOM   3707  N   GLY   307      45.325  67.578  12.967  1.00 77.83           N  
ATOM   3708  CA  GLY   307      46.274  68.672  12.818  1.00 77.37           C  
ATOM   3709  C   GLY   307      46.055  69.431  11.513  1.00 77.05           C  
ATOM   3710  O   GLY   307      45.695  70.610  11.539  1.00 77.12           O  
ATOM   3711  N   THR   308      46.241  68.768  10.371  1.00 76.40           N  
ATOM   3712  CA  THR   308      45.998  69.440   9.091  1.00 76.00           C  
ATOM   3713  C   THR   308      44.560  69.928   8.927  1.00 75.96           C  
ATOM   3714  O   THR   308      44.337  71.037   8.450  1.00 75.72           O  
ATOM   3715  CB  THR   308      46.468  68.650   7.844  1.00 75.64           C  
ATOM   3716  OG1 THR   308      46.651  67.273   8.162  1.00 75.36           O  
ATOM   3717  CG2 THR   308      47.782  69.176   7.384  1.00 75.66           C  
ATOM   3718  N   LYS   309      43.596  69.125   9.362  1.00 76.13           N  
ATOM   3719  CA  LYS   309      42.190  69.469   9.156  1.00 76.38           C  
ATOM   3720  C   LYS   309      41.766  70.672   9.977  1.00 76.06           C  
ATOM   3721  O   LYS   309      41.019  71.519   9.501  1.00 75.80           O  
ATOM   3722  CB  LYS   309      41.276  68.267   9.391  1.00 76.48           C  
ATOM   3723  CG  LYS   309      41.620  67.100   8.470  1.00 78.46           C  
ATOM   3724  CD  LYS   309      40.435  66.630   7.627  1.00 81.61           C  
ATOM   3725  CE  LYS   309      40.929  65.983   6.316  1.00 83.14           C  
ATOM   3726  NZ  LYS   309      39.821  65.434   5.466  1.00 84.93           N  
ATOM   3727  N   ALA   310      42.261  70.748  11.205  1.00 76.28           N  
ATOM   3728  CA  ALA   310      42.050  71.923  12.038  1.00 76.51           C  
ATOM   3729  C   ALA   310      42.585  73.143  11.298  1.00 76.75           C  
ATOM   3730  O   ALA   310      41.852  74.095  11.024  1.00 77.08           O  
ATOM   3731  CB  ALA   310      42.747  71.767  13.365  1.00 76.32           C  
ATOM   3732  N   ALA   311      43.864  73.097  10.951  1.00 76.62           N  
ATOM   3733  CA  ALA   311      44.478  74.175  10.198  1.00 76.64           C  
ATOM   3734  C   ALA   311      43.645  74.576   8.977  1.00 76.53           C  
ATOM   3735  O   ALA   311      43.379  75.761   8.765  1.00 76.69           O  
ATOM   3736  CB  ALA   311      45.889  73.786   9.783  1.00 76.78           C  
ATOM   3737  N   GLU   312      43.228  73.585   8.192  1.00 76.15           N  
ATOM   3738  CA  GLU   312      42.462  73.840   6.987  1.00 75.78           C  
ATOM   3739  C   GLU   312      41.185  74.606   7.320  1.00 75.33           C  
ATOM   3740  O   GLU   312      40.912  75.647   6.726  1.00 75.39           O  
ATOM   3741  CB  GLU   312      42.146  72.532   6.259  1.00 75.89           C  
ATOM   3742  CG  GLU   312      43.263  72.000   5.339  1.00 76.04           C  
ATOM   3743  CD  GLU   312      42.806  70.800   4.482  1.00 76.60           C  
ATOM   3744  OE1 GLU   312      43.546  69.789   4.431  1.00 76.90           O  
ATOM   3745  OE2 GLU   312      41.708  70.861   3.861  1.00 77.96           O  
ATOM   3746  N   LYS   313      40.426  74.102   8.289  1.00 75.10           N  
ATOM   3747  CA  LYS   313      39.162  74.719   8.701  1.00 74.88           C  
ATOM   3748  C   LYS   313      39.348  76.187   9.083  1.00 74.77           C  
ATOM   3749  O   LYS   313      38.543  77.037   8.702  1.00 74.69           O  
ATOM   3750  CB  LYS   313      38.502  73.926   9.845  1.00 74.88           C  
ATOM   3751  N   LEU   314      40.424  76.484   9.808  1.00 74.67           N  
ATOM   3752  CA  LEU   314      40.723  77.861  10.177  1.00 74.80           C  
ATOM   3753  C   LEU   314      41.236  78.704   9.001  1.00 75.05           C  
ATOM   3754  O   LEU   314      40.760  79.823   8.788  1.00 75.20           O  
ATOM   3755  CB  LEU   314      41.718  77.913  11.329  1.00 74.61           C  
ATOM   3756  CG  LEU   314      41.297  78.760  12.539  1.00 74.70           C  
ATOM   3757  CD1 LEU   314      42.530  79.183  13.348  1.00 74.54           C  
ATOM   3758  CD2 LEU   314      40.422  79.975  12.186  1.00 73.41           C  
ATOM   3759  N   LEU   315      42.211  78.189   8.251  1.00 75.16           N  
ATOM   3760  CA  LEU   315      42.679  78.880   7.057  1.00 75.32           C  
ATOM   3761  C   LEU   315      41.467  79.239   6.185  1.00 75.72           C  
ATOM   3762  O   LEU   315      41.296  80.404   5.814  1.00 75.85           O  
ATOM   3763  CB  LEU   315      43.708  78.045   6.289  1.00 75.00           C  
ATOM   3764  N   HIS   316      40.601  78.256   5.913  1.00 76.07           N  
ATOM   3765  CA  HIS   316      39.384  78.477   5.106  1.00 76.44           C  
ATOM   3766  C   HIS   316      38.391  79.447   5.755  1.00 76.66           C  
ATOM   3767  O   HIS   316      37.469  79.929   5.097  1.00 76.77           O  
ATOM   3768  CB  HIS   316      38.689  77.153   4.765  1.00 76.26           C  
ATOM   3769  N   ALA   317      38.591  79.727   7.040  1.00 77.07           N  
ATOM   3770  CA  ALA   317      37.791  80.715   7.759  1.00 77.38           C  
ATOM   3771  C   ALA   317      38.216  82.131   7.390  1.00 77.50           C  
ATOM   3772  O   ALA   317      37.396  82.907   6.896  1.00 77.65           O  
ATOM   3773  CB  ALA   317      37.880  80.496   9.269  1.00 77.42           C  
ATOM   3774  N   ILE   318      39.489  82.462   7.618  1.00 77.67           N  
ATOM   3775  CA  ILE   318      40.028  83.778   7.232  1.00 77.87           C  
ATOM   3776  C   ILE   318      39.970  84.001   5.720  1.00 77.98           C  
ATOM   3777  O   ILE   318      39.694  85.110   5.259  1.00 78.07           O  
ATOM   3778  CB  ILE   318      41.481  83.981   7.709  1.00 77.73           C  
ATOM   3779  N   LYS   319      40.223  82.937   4.959  1.00 78.18           N  
ATOM   3780  CA  LYS   319      40.194  82.991   3.497  1.00 78.23           C  
ATOM   3781  C   LYS   319      38.763  82.947   2.975  1.00 78.20           C  
ATOM   3782  O   LYS   319      37.871  83.590   3.532  1.00 78.21           O  
ATOM   3783  CB  LYS   319      41.004  81.836   2.903  1.00 78.26           C  
ATOM   3784  N   GLU   321      34.693  82.271   1.962  1.00 74.27           N  
ATOM   3785  CA  GLU   321      34.900  82.107   3.395  1.00 74.30           C  
ATOM   3786  C   GLU   321      33.844  81.217   4.043  1.00 74.51           C  
ATOM   3787  O   GLU   321      33.642  81.295   5.254  1.00 74.65           O  
ATOM   3788  CB  GLU   321      34.931  83.469   4.097  1.00 74.09           C  
ATOM   3789  N   PRO   322      33.168  80.365   3.244  1.00 74.74           N  
ATOM   3790  CA  PRO   322      32.223  79.354   3.752  1.00 74.90           C  
ATOM   3791  C   PRO   322      32.861  78.479   4.854  1.00 75.01           C  
ATOM   3792  O   PRO   322      34.088  78.308   4.876  1.00 74.69           O  
ATOM   3793  CB  PRO   322      31.880  78.536   2.502  1.00 74.76           C  
ATOM   3794  N   GLU   323      32.037  77.934   5.752  1.00 75.38           N  
ATOM   3795  CA  GLU   323      32.535  77.464   7.062  1.00 75.85           C  
ATOM   3796  C   GLU   323      32.427  75.967   7.418  1.00 76.08           C  
ATOM   3797  O   GLU   323      32.744  75.568   8.551  1.00 76.17           O  
ATOM   3798  CB  GLU   323      31.918  78.313   8.185  1.00 75.75           C  
ATOM   3799  N   GLU   324      32.004  75.136   6.469  1.00 76.23           N  
ATOM   3800  CA  GLU   324      31.926  73.700   6.730  1.00 76.37           C  
ATOM   3801  C   GLU   324      32.229  72.879   5.487  1.00 76.47           C  
ATOM   3802  O   GLU   324      32.432  71.666   5.577  1.00 76.61           O  
ATOM   3803  CB  GLU   324      30.553  73.323   7.301  1.00 76.41           C  
ATOM   3804  N   PRO   326      29.553  70.241   8.915  1.00 95.52           N  
ATOM   3805  CA  PRO   326      29.812  69.129   9.825  1.00 95.72           C  
ATOM   3806  C   PRO   326      31.238  68.570   9.670  1.00 95.90           C  
ATOM   3807  O   PRO   326      31.919  68.898   8.690  1.00 95.91           O  
ATOM   3808  CB  PRO   326      28.764  68.093   9.409  1.00 95.76           C  
ATOM   3809  N   THR   327      31.684  67.749  10.632  1.00 96.04           N  
ATOM   3810  CA  THR   327      33.073  67.259  10.678  1.00 96.02           C  
ATOM   3811  C   THR   327      33.203  65.933  11.444  1.00 96.07           C  
ATOM   3812  O   THR   327      33.840  65.883  12.518  1.00 96.24           O  
ATOM   3813  CB  THR   327      34.020  68.312  11.342  1.00 96.16           C  
ATOM   3814  OG1 THR   327      33.682  69.633  10.904  1.00 96.54           O  
ATOM   3815  CG2 THR   327      35.486  68.041  11.008  1.00 96.21           C  
ATOM   3816  N   SER   328      32.627  64.856  10.901  1.00 95.82           N  
ATOM   3817  CA  SER   328      32.566  63.563  11.646  1.00 95.51           C  
ATOM   3818  C   SER   328      33.847  62.708  11.593  1.00 94.47           C  
ATOM   3819  O   SER   328      33.890  61.683  10.899  1.00 94.49           O  
ATOM   3820  CB  SER   328      31.360  62.724  11.193  1.00 95.74           C  
ATOM   3821  OG  SER   328      31.361  61.465  11.854  1.00 96.57           O  
ATOM   3822  N   MET   329      34.871  63.115  12.333  1.00 93.48           N  
ATOM   3823  CA  MET   329      36.152  62.405  12.269  0.50 93.09           C  
ATOM   3825  C   MET   329      36.327  61.429  13.437  1.00 92.01           C  
ATOM   3826  O   MET   329      36.420  61.822  14.591  1.00 91.96           O  
ATOM   3827  CB  MET   329      37.348  63.367  12.125  0.50 93.68           C  
ATOM   3829  CG  MET   329      37.341  64.227  10.838  0.50 94.63           C  
ATOM   3831  SD  MET   329      37.278  63.239   9.130  0.40 98.13          SE  
ATOM   3833  CE  MET   329      37.122  64.739   7.873  0.50 95.11           C  
ATOM   3835  N   GLY   330      36.365  60.141  13.096  1.00 90.14           N  
ATOM   3836  CA  GLY   330      36.347  59.051  14.062  1.00 87.30           C  
ATOM   3837  C   GLY   330      37.647  58.336  14.396  1.00 85.42           C  
ATOM   3838  O   GLY   330      38.648  58.968  14.694  1.00 85.23           O  
ATOM   3839  N   PHE   331      37.612  57.008  14.359  1.00 83.74           N  
ATOM   3840  CA  PHE   331      38.656  56.173  14.940  1.00 82.47           C  
ATOM   3841  C   PHE   331      38.652  54.766  14.352  1.00 82.34           C  
ATOM   3842  O   PHE   331      37.671  54.349  13.772  1.00 82.98           O  
ATOM   3843  CB  PHE   331      38.464  56.092  16.455  1.00 81.49           C  
ATOM   3844  CG  PHE   331      37.339  55.220  16.866  1.00 80.32           C  
ATOM   3845  CD1 PHE   331      36.019  55.680  16.794  1.00 79.28           C  
ATOM   3846  CD2 PHE   331      37.575  53.931  17.321  1.00 79.03           C  
ATOM   3847  CE1 PHE   331      34.940  54.860  17.179  1.00 77.25           C  
ATOM   3848  CE2 PHE   331      36.478  53.097  17.701  1.00 79.12           C  
ATOM   3849  CZ  PHE   331      35.167  53.570  17.618  1.00 76.56           C  
ATOM   3850  N   LYS   332      39.746  54.029  14.490  1.00 82.06           N  
ATOM   3851  CA  LYS   332      39.744  52.645  14.048  1.00 81.68           C  
ATOM   3852  C   LYS   332      39.954  51.803  15.289  1.00 80.82           C  
ATOM   3853  O   LYS   332      40.748  52.182  16.147  1.00 81.05           O  
ATOM   3854  CB  LYS   332      40.860  52.348  13.034  1.00 82.28           C  
ATOM   3855  CG  LYS   332      41.420  53.529  12.228  1.00 83.84           C  
ATOM   3856  CD  LYS   332      40.515  53.890  11.081  1.00 88.56           C  
ATOM   3857  CE  LYS   332      40.984  55.162  10.384  1.00 91.04           C  
ATOM   3858  NZ  LYS   332      42.167  54.957   9.492  1.00 92.95           N  
ATOM   3859  N   LEU   333      39.231  50.684  15.378  1.00 79.21           N  
ATOM   3860  CA  LEU   333      39.462  49.651  16.374  1.00 77.70           C  
ATOM   3861  C   LEU   333      40.387  48.520  15.870  1.00 77.78           C  
ATOM   3862  O   LEU   333      39.915  47.509  15.335  1.00 77.74           O  
ATOM   3863  CB  LEU   333      38.138  49.031  16.780  1.00 77.15           C  
ATOM   3864  CG  LEU   333      37.916  48.395  18.155  1.00 76.10           C  
ATOM   3865  CD1 LEU   333      37.206  47.074  17.992  1.00 74.66           C  
ATOM   3866  CD2 LEU   333      39.204  48.190  18.921  1.00 76.71           C  
ATOM   3867  N   LYS   334      41.694  48.690  16.073  1.00 77.57           N  
ATOM   3868  CA  LYS   334      42.709  47.623  15.950  1.00 77.41           C  
ATOM   3869  C   LYS   334      42.488  46.428  16.907  1.00 77.39           C  
ATOM   3870  O   LYS   334      42.820  46.500  18.111  1.00 77.20           O  
ATOM   3871  CB  LYS   334      44.107  48.214  16.237  1.00 77.53           C  
ATOM   3872  CG  LYS   334      44.483  49.394  15.358  1.00 77.59           C  
ATOM   3873  CD  LYS   334      44.342  49.017  13.876  1.00 76.62           C  
ATOM   3874  CE  LYS   334      44.277  50.242  13.000  1.00 76.35           C  
ATOM   3875  NZ  LYS   334      44.662  49.855  11.593  1.00 79.37           N  
ATOM   3876  N   ARG   335      41.944  45.332  16.377  1.00 76.73           N  
ATOM   3877  CA  ARG   335      41.714  44.131  17.169  1.00 76.39           C  
ATOM   3878  C   ARG   335      43.018  43.372  17.254  1.00 76.19           C  
ATOM   3879  O   ARG   335      43.547  42.989  16.227  1.00 76.67           O  
ATOM   3880  CB  ARG   335      40.672  43.259  16.491  1.00 76.80           C  
ATOM   3881  CG  ARG   335      39.317  43.921  16.311  1.00 77.80           C  
ATOM   3882  CD  ARG   335      38.713  43.597  14.951  1.00 80.51           C  
ATOM   3883  NE  ARG   335      37.259  43.764  14.985  1.00 83.77           N  
ATOM   3884  CZ  ARG   335      36.618  44.925  14.824  1.00 83.52           C  
ATOM   3885  NH1 ARG   335      35.293  44.960  14.897  1.00 82.23           N  
ATOM   3886  NH2 ARG   335      37.295  46.052  14.597  1.00 83.15           N  
ATOM   3887  N   ARG   336      43.563  43.186  18.459  1.00 75.95           N  
ATOM   3888  CA  ARG   336      44.812  42.418  18.642  1.00 75.87           C  
ATOM   3889  C   ARG   336      44.651  41.331  19.695  1.00 76.49           C  
ATOM   3890  O   ARG   336      43.530  40.919  19.977  1.00 76.09           O  
ATOM   3891  CB  ARG   336      45.979  43.312  19.031  1.00 75.21           C  
ATOM   3892  CG  ARG   336      45.888  44.687  18.504  1.00 74.74           C  
ATOM   3893  CD  ARG   336      47.143  45.342  18.894  1.00 77.89           C  
ATOM   3894  NE  ARG   336      47.073  46.798  18.870  1.00 79.85           N  
ATOM   3895  CZ  ARG   336      47.284  47.537  17.789  1.00 78.38           C  
ATOM   3896  NH1 ARG   336      47.558  46.957  16.619  1.00 77.89           N  
ATOM   3897  NH2 ARG   336      47.222  48.855  17.895  1.00 77.33           N  
ATOM   3898  N   ALA   337      45.758  40.878  20.295  1.00 77.29           N  
ATOM   3899  CA  ALA   337      45.681  39.710  21.175  1.00 78.02           C  
ATOM   3900  C   ALA   337      44.743  39.905  22.347  1.00 79.10           C  
ATOM   3901  O   ALA   337      43.889  39.054  22.593  1.00 80.51           O  
ATOM   3902  CB  ALA   337      47.014  39.284  21.649  1.00 77.04           C  
ATOM   3903  N   SER   338      44.854  41.030  23.046  1.00 79.69           N  
ATOM   3904  CA  SER   338      44.249  41.133  24.372  1.00 80.21           C  
ATOM   3905  C   SER   338      42.716  41.048  24.376  1.00 80.61           C  
ATOM   3906  O   SER   338      42.090  41.114  25.460  1.00 80.70           O  
ATOM   3907  CB  SER   338      44.676  42.422  25.037  1.00 80.31           C  
ATOM   3908  OG  SER   338      44.043  43.510  24.389  1.00 82.53           O  
ATOM   3909  N   THR   339      42.104  40.931  23.192  1.00 80.30           N  
ATOM   3910  CA  THR   339      40.679  40.593  23.135  1.00 80.65           C  
ATOM   3911  C   THR   339      40.355  39.427  22.267  1.00 80.79           C  
ATOM   3912  O   THR   339      39.209  39.275  21.880  1.00 81.10           O  
ATOM   3913  CB  THR   339      39.741  41.755  22.707  1.00 80.18           C  
ATOM   3914  OG1 THR   339      39.994  42.121  21.349  1.00 80.98           O  
ATOM   3915  CG2 THR   339      39.907  42.939  23.611  1.00 81.05           C  
ATOM   3916  N   ALA   340      41.339  38.591  21.967  1.00 81.72           N  
ATOM   3917  CA  ALA   340      41.148  37.574  20.928  1.00 82.33           C  
ATOM   3918  C   ALA   340      40.507  36.324  21.509  1.00 83.30           C  
ATOM   3919  O   ALA   340      40.431  36.157  22.732  1.00 83.25           O  
ATOM   3920  CB  ALA   340      42.437  37.257  20.272  1.00 81.36           C  
ATOM   3921  N   ILE   341      40.020  35.455  20.632  1.00 84.69           N  
ATOM   3922  CA  ILE   341      39.407  34.212  21.076  1.00 86.00           C  
ATOM   3923  C   ILE   341      39.703  33.111  20.070  1.00 86.21           C  
ATOM   3924  O   ILE   341      39.423  33.264  18.880  1.00 86.39           O  
ATOM   3925  CB  ILE   341      37.893  34.393  21.307  1.00 86.04           C  
ATOM   3926  CG1 ILE   341      37.229  33.043  21.605  1.00 87.67           C  
ATOM   3927  CG2 ILE   341      37.247  35.115  20.124  1.00 86.43           C  
ATOM   3928  CD1 ILE   341      35.691  32.966  21.275  1.00 86.79           C  
ATOM   3929  N   ASN   342      40.301  32.020  20.548  1.00 86.81           N  
ATOM   3930  CA  ASN   342      40.675  30.879  19.681  1.00 87.10           C  
ATOM   3931  C   ASN   342      39.975  29.568  20.069  1.00 86.91           C  
ATOM   3932  O   ASN   342      38.977  29.176  19.458  1.00 86.63           O  
ATOM   3933  CB  ASN   342      42.206  30.682  19.636  1.00 87.08           C  
ATOM   3934  CG  ASN   342      42.650  29.605  18.607  1.00 87.89           C  
ATOM   3935  OD1 ASN   342      41.844  29.088  17.815  1.00 85.68           O  
ATOM   3936  ND2 ASN   342      43.951  29.271  18.629  1.00 89.00           N  
END
